﻿USE sofia;
DROP TABLE IF EXISTS sofia.nya_vpl;
CREATE TABLE nya_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nya_vpl WRITE;
INSERT INTO nya_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Pachiyambi Mulungu analenga kumwamba ndi dziko lapansi. ");
INSERT INTO nya_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Dziko lapansi linali losakonzedwa ndi lopanda kanthu. Mdima wandiweyani unakuta nyanja ndipo Mzimu wa Mulungu unkayendayenda pamwamba pa madziwo. ");
INSERT INTO nya_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Pamenepo Mulungu anati, “Kuwale” ndipo kunawaladi. ");
INSERT INTO nya_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Mulungu anaona kuti kuwalako kunali bwino ndipo Iye analekanitsa kuwala ndi mdima. ");
INSERT INTO nya_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Mulungu anatcha kuwalako “usana” ndipo mdima anawutcha “usiku.” Ndipo panali madzulo ndiponso mmawa pa tsiku loyamba. ");
INSERT INTO nya_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Kenaka Mulungu anati, “Pakhale thambo pakati pa madzi kuti lilekanitse madzi a mʼmwamba ndi madzi a pansi.” ");
INSERT INTO nya_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ndipo Mulungu anapanga thambo nalekanitsa madzi amene anali pansi ndi pamwamba pa thambo lija, ndipo zinachitikadi. ");
INSERT INTO nya_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Mulungu anatcha thambo lija “kumwamba.” Ndipo panali madzulo ndiponso mmawa pa tsiku lachiwiri. ");
INSERT INTO nya_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Mulungu anati, “Madzi a pansi pa thambo asonkhane pa malo amodzi kuti mtunda uwoneke,” ndipo zinachitikadi. ");
INSERT INTO nya_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Mulungu anawutcha mtundawo “dziko,” madzi osonkhana pamodziwo anawatcha “nyanja.” Ndipo Mulungu anaona kuti zinali bwino. ");
INSERT INTO nya_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Kenaka Mulungu anati, “Dziko libereke zomera zobala mbewu, mitengo yobala zipatso za mbewu, molingana ndi mitundu yake.” Ndipo zinachitikadi. ");
INSERT INTO nya_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Dziko linabereka zomera zokhala ndi mbewu monga mwa mitundu yake ndi mitengo yokhala ndi zipatso za mbewu mʼkati mwake monga mwa mitundu yake. Ndipo Mulungu anaona kuti zinali bwino. ");
INSERT INTO nya_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ndipo panali madzulo ndiponso mmawa pa tsiku lachitatu. ");
INSERT INTO nya_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Mulungu anati, “Pakhale zowunikira kuthambo kuti zilekanitse usana ndi usiku. Ndipo zimenezi zikhale zizindikiro zoonetsa nyengo, masiku ndi zaka; ");
INSERT INTO nya_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","zikhale kuthambo kuti ziwunikire pa dziko lapansi. Ndipo zinachitikadi.” ");
INSERT INTO nya_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Mulungu anapanga zowunikira zazikulu ziwiri; chachikulu chilamulire usana ndi chachingʼono chilamulire usiku. Iye anapanganso nyenyezi. ");
INSERT INTO nya_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Mulungu anaziyika mlengalenga kuti ziziwunikira pa dziko lapansi, ");
INSERT INTO nya_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","kuti zilamulire usana ndi usiku, ndi kuti zilekanitse kuwala ndi mdima. Mulungu anaona kuti zinali bwino. ");
INSERT INTO nya_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ndipo panali madzulo ndiponso mmawa pa tsiku lachinayi. ");
INSERT INTO nya_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Mulungu anati, “Mʼmadzi mukhale zamoyo zochuluka ndipo mbalame ziwuluke mlengalenga pamwamba pa dziko lapansi.” ");
INSERT INTO nya_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Choncho Mulungu analenga zamoyo zikuluzikulu za mʼnyanja ndi chamoyo chamtundu uliwonse chokhala mʼmadzi ndi mbalame iliyonse ya mapiko monga mwa mtundu wake. Mulungu anaona kuti zinali bwino. ");
INSERT INTO nya_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Mulungu anazidalitsa nati, “Muswane, ndi kudzaza mʼmadzi a mʼnyanja, ndipo mbalame zichuluke pa dziko lapansi.” ");
INSERT INTO nya_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ndipo panali madzulo ndiponso mmawa pa tsiku lachisanu. ");
INSERT INTO nya_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Kenaka Mulungu anati, “Dziko lapansi litulutse zolengedwa zamoyo monga mwa mitundu yawo: ziweto, zolengedwa zokwawa ndi nyama zakuthengo, iliyonse monga mwa mtundu wake.” Ndipo zinaterodi. ");
INSERT INTO nya_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Mulungu anapanga nyama zakuthengo monga mwa mitundu yawo, nyama zoweta monga mwa mitundu yawo ndi nyama zokwawa monga mwa mitundu yawo. Ndipo Mulungu anaona kuti zinali bwino. ");
INSERT INTO nya_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Zitatha izi Mulungu anati, “Tipange munthu mʼchifanizo chathu, mofanana ndi ife kuti alamulire nsomba za mʼnyanja, mbalame zamlengalenga, nyama zonse zoweta ndi zonse zokwawa za pa dziko lapansi ndi zamoyo zonse zakutchire.” ");
INSERT INTO nya_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ndipo Mulungu analenga munthu mʼchifanizo chake. Anawalengadi mʼchifanizo cha Mulungu; analenga iwo, mwamuna ndi mkazi. ");
INSERT INTO nya_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Mulungu anawadalitsa nati kwa iwo, “Muberekane, muchulukane, mudzaze dziko lapansi ndipo muligonjetse. Mulamulire nsomba zamʼnyanja, mbalame zamlengalenga ndi cholengedwa chamoyo chilichonse chimene chimayenda mokwawa pa dziko lapansi.” ");
INSERT INTO nya_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kenaka Mulungu anati, “Ine ndakupatsani chomera chilichonse cha pa dziko lapansi chimene chili ndi mbewu komanso mtengo uliwonse wobala zipatso zokhala ndi mbewu mʼkati mwake kuti zikhale chakudya chanu. ");
INSERT INTO nya_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ndaperekanso msipu kwa nyama zonse za pa dziko lapansi ndi kwa mbalame zamlengalenga ndi kwa cholengedwa chamoyo chilichonse chimene chimakwawa, chilichonse chimene chili ndi moyo.” Ndipo zinachitikadi. ");
INSERT INTO nya_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Mulungu anaona zonse zimene anazilenga kuti zinali zabwino kwambiri. Ndipo panali madzulo ndiponso mmawa, tsiku lachisanu ndi chimodzi. ");
INSERT INTO nya_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Motero kumwamba, dziko lapansi ndi zonse za mʼmenemo zinatha kulengedwa monga mwa kuchuluka kwawo. ");
INSERT INTO nya_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Pofika tsiku lachisanu ndi chiwiri Mulungu anamaliza ntchito zonse zimene ankagwira ndipo pa tsiku lachisanu ndi chiwiri anapumula ku ntchito zake zonse. ");
INSERT INTO nya_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ndipo Mulungu anadalitsa tsiku lachisanu ndi chiwiri nalipatula, chifukwa pa tsiku limeneli Iye anapumula ku ntchito yonse yolenga imene anayigwira. ");
INSERT INTO nya_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Mbiri ya momwe kumwamba ndi dziko lapansi zinalengedwera pa tsiku lija Yehova Mulungu ankazilenga ndi iyi: Yehova Mulungu atapanga dziko lapansi ndi kumwamba, ");
INSERT INTO nya_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","zitsamba zinali zisanamere ndipo chomera chilichonse chinali chisanamerenso popeza Yehova Mulungu anali asanagwetse mvula pa dziko lapansi. Panalibe munthu wolima nthaka, ");
INSERT INTO nya_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","koma kasupe ankatuluka mʼnthaka ndi kuthirira pa dziko lonse. ");
INSERT INTO nya_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Tsono Yehova Mulungu anawumba munthu kuchokera ku dothi nawuziramo mpweya wamoyo mʼmphuno mwake ndipo munthuyo anakhala wamoyo. ");
INSERT INTO nya_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Kenaka Yehova Mulungu anatsekula munda wa Edeni chakummawa; kumeneko anayikako munthu amene anamupanga uja. ");
INSERT INTO nya_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ndipo Yehova Mulungu anameretsa mʼmundamo mitengo ya mitundu yonse. Inali mitengo yokongola ndi ya zipatso zokoma. Pakati pa munda uja panali mtengo wopatsa moyo ndi mtengo wopatsa nzeru zodziwitsa chabwino ndi choyipa. ");
INSERT INTO nya_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Mtsinje wothirira mundawo unkatuluka mu Edeni; kuchokera apo unkagawikana kukhala mitsinje inayi. ");
INSERT INTO nya_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Dzina la mtsinje woyamba ndi Pisoni; uwu umazungulira dziko lonse la Havila, kumene kuli golide. ");
INSERT INTO nya_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Golide wa ku dziko ili ndi wabwino. Kulinso miyala yokongola ya bedola ndi onikisi). ");
INSERT INTO nya_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Dzina la mtsinje wachiwiri ndi Gihoni; uwu umazungulira dziko lonse la Kusi. ");
INSERT INTO nya_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Dzina la mtsinje wachitatu ndi Tigirisi; umayenda chakummawa kwa Asiriya. Ndipo mtsinje wachinayi ndi Yufurate. ");
INSERT INTO nya_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Yehova Mulungu anatenga munthu uja ndi kumuyika mʼmunda wa Edeni kuti awulime ndi kuwusamalira. ");
INSERT INTO nya_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ndipo Yehova Mulungu analamula munthu uja kuti, “Uzidya zipatso za mu mtengo wina uliwonse mʼmundamu; ");
INSERT INTO nya_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","koma usadye zipatso za mu mtengo wodziwitsa chabwino ndi choyipa, popeza ukadzadya za mu mtengowu udzafa ndithu.” ");
INSERT INTO nya_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ndipo Yehova Mulungu anati, “Sibwino kuti munthu akhale yekha. Ndidzamupangira mnzake womuthandiza.” ");
INSERT INTO nya_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Kenaka Yehova Mulungu anawumba ndi dothi nyama zonse zakuthengo ndi mbalame zonse zamlengalenga. Ndipo Iye anapita nazo kwa munthu uja kuti akazipatse mayina; ndipo dzina lililonse limene Adamu anapereka ku chamoyo chilichonse, lomwelo linakhala dzina lake. ");
INSERT INTO nya_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Choncho Adamu anazitcha mayina ziweto zonse, mbalame zamlengalenga ndi nyama zakuthengo zonse. Komabe munthu uja analibe mnzake womuthandiza. ");
INSERT INTO nya_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Tsono Yehova Mulungu anamugonetsa munthu uja tulo tofa nato; ali mtulo chomwecho, Mulungu anachotsa imodzi mwa nthiti zake ndi kutseka pamalopo ndi mnofu. ");
INSERT INTO nya_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Motero Yehova Mulungu anapanga mkazi ndi nthiti ija imene anatenga kwa munthu uja nabwera naye kwa iye. ");
INSERT INTO nya_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Munthu uja anati, “Uyu ndiye fupa lochokera ku mafupa anga ndi mnofu wochokera ku mnofu wanga; adzatchedwa ‘mkazi,’ popeza wachokera mwa mwamuna.” ");
INSERT INTO nya_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Nʼchifukwa chake, mwamuna amasiya abambo ndi amayi ake nakaphatikana ndi mkazi wake ndipo awiriwo amakhala thupi limodzi. ");
INSERT INTO nya_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Munthu uja ndi mkazi wakeyo, onse awiri anali maliseche ndipo analibe manyazi. ");
INSERT INTO nya_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ndipo njoka inali yochenjera kuposa nyama yakuthengo iliyonse imene Yehova Mulungu anapanga. Njokayo inati kwa mkaziyo, “Kodi Mulungu ananenadi kuti, ‘Inu musadye zipatso za mtengo uliwonse mʼmundamu?’ ” ");
INSERT INTO nya_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mkaziyo anati kwa njokayo, “Tikhoza kudya zipatso za mʼmitengo ya mʼmundawu, ");
INSERT INTO nya_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","koma Mulungu anati, ‘Musadye zipatso za mu mtengo umene uli pakati pa munda, ndipo musadzawukhudze kuti mungadzafe.’ ” ");
INSERT INTO nya_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","“Ndithudi simudzafa,” inatero njokayo kwa mkaziyo. ");
INSERT INTO nya_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","“Pakuti Mulungu akudziwa kuti tsiku limene mudzadye zipatso za mu mtengowo, maso anu adzatsekuka, ndipo mudzakhala ngati Mulungu, wodziwa zabwino ndi zoyipa.” ");
INSERT INTO nya_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Pamene mkaziyo anaona kuti mtengowo unali wabwino kudya ndi wokongola ndi kuti unali wopatsa nzeru, anatengako zipatso zake nadya. Zina anamupatsako mwamuna wake amene anali naye pomwepo ndipo naye anadyanso. ");
INSERT INTO nya_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Kenaka maso awo anatsekuka, ndipo anazindikira kuti anali maliseche. Choncho anasoka masamba a mkuyu nadzipangira zovala. ");
INSERT INTO nya_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Kenaka munthu uja ndi mkazi wake anamva mtswatswa wa Yehova Mulungu akuyendayenda mʼmundamo madzulo a tsikulo, ndipo iwo anabisala pamaso pa Yehova Mulungu pakati pa mitengo ya mʼmundamo. ");
INSERT INTO nya_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Yehova Mulungu anayitana munthu uja kuti, “Uli kuti?” ");
INSERT INTO nya_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Iye anayankha, “Ndinakumvani mʼmundamo, ndipo ndimaopa chifukwa ndinali maliseche; choncho ndinabisala.” ");
INSERT INTO nya_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ndipo anamufunsa, “Ndani anakuwuza kuti uli maliseche? Kodi wadya zipatso za mtengo umene ndinakulamulira kuti usadye?” ");
INSERT INTO nya_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Koma munthu uja anati, “Mkazi amene munandipatsa kuti ndizikhala nayeyu anandipatsako chipatso cha mtengowo ndipo ndinadya.” ");
INSERT INTO nya_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Tsono Yehova Mulungu anati kwa mkaziyo, “Wachitachi nʼchiyani?” Mkaziyo anati, “Njoka inandinamiza, ndipo ndinadya.” ");
INSERT INTO nya_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Choncho Yehova Mulungu anati kwa njokayo, “Popeza wachita zimenezi, “Ndiwe wotembereredwa kuposa ziweto zonse ndi nyama zakuthengo zonse. Udzayenda chafufumimba ndipo udzadya fumbi masiku onse a moyo wako. ");
INSERT INTO nya_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ndipo ndidzayika chidani pakati pa iwe ndi mkaziyo, pakati pa mbewu yako ndi mbewu yake; Iye adzaphwanya mutu wako ndipo iwe udzaluma chidendene chake.” ");
INSERT INTO nya_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kwa mkaziyo Iye anati, “Ndidzachulukitsa ululu wako kwambiri pamene uli ndi pakati; ndipo udzamva ululu pa nthawi yako yobereka ana. Udzakhumba mwamuna wako, ndipo adzakulamulira.” ");
INSERT INTO nya_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ndipo kwa Adamu Mulungu anati, “Chifukwa wamvera mkazi wako ndipo wadya zipatso za mu mtengo umene ndinakulamulira kuti, ‘Usadye.’ “Nthaka yatembereredwa chifukwa cha iwe, movutikira udzadya zochokera mʼnthakamo masiku onse a moyo wako. ");
INSERT INTO nya_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Mʼnthakamo mudzamera minga ndi nthula ndipo udzadya zomera zakuthengo. ");
INSERT INTO nya_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kuti upeze chakudya udzayenera kukhetsa thukuta, mpaka utabwerera ku nthaka pakuti unachokera kumeneko; pakuti ndiwe fumbi ku fumbi komweko udzabwerera.” ");
INSERT INTO nya_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Munthu uja anatcha mkazi wake Hava, chifukwa iyeyu adzakhala mayi wa anthu onse amoyo. ");
INSERT INTO nya_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Yehova Mulungu anapangira Adamu ndi mkazi wake zovala zachikopa ndipo anawaveka. ");
INSERT INTO nya_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ndipo Yehova Mulungu anati, “Tsopano munthu uyu wasanduka mmodzi wa ife, wodziwa zabwino ndi zoyipa. Iyeyu asaloledwe kutambasula dzanja ndi kutengako zipatso za mu mtengo wopatsa moyo uja kuti angakhale ndi moyo mpaka muyaya.” ");
INSERT INTO nya_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kotero Yehova Mulungu anatulutsa Adamu Mʼmunda wa Edeni kuti azilima mʼnthaka imene anachokera. ");
INSERT INTO nya_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Atamuthamangitsa munthu uja, Yehova anayika Akerubi mbali ya kummawa kwa Munda wa Edeni ndi lupanga lamoto limene limayendayenda ponsepo, kuteteza njira ya ku mtengo wopatsa moyo. ");
INSERT INTO nya_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu anagona malo amodzi ndi Hava mkazi wake ndipo mkaziyo anakhala woyembekezera nabala Kaini, ndipo anati, “Ndi thandizo la Yehova ndapeza mwana wamwamuna.” ");
INSERT INTO nya_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Kenaka anabereka mʼbale wake Abele. Abele anali woweta nkhosa ndipo Kaini anali mlimi. ");
INSERT INTO nya_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Patapita nthawi, Kaini anatenga zipatso za ku munda nakazipereka kwa Yehova monga nsembe. ");
INSERT INTO nya_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Nayenso Abele anatenga ana ankhosa oyamba kubadwa pamodzi ndi mafuta ake nakazipereka ngati nsembe kwa Yehova. Yehova anakondwera ndi Abele ndi nsembe yake. ");
INSERT INTO nya_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Koma sanakondwere ndi Kaini ndi nsembe yake. Kotero Kaini anakwiya kwambiri ndipo nkhope yake inagwa. ");
INSERT INTO nya_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Choncho Yehova anati kwa Kaini, “Chifukwa chiyani wakwiya ndipo bwanji nkhope yako yagwa? ");
INSERT INTO nya_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ukanachita zabwino sindikanakulandira kodi? Koma tsopano wachita zoyipa ndipo tchimo likukudikira pa khomo pako, likufuna kukugwira; koma iwe uyenera kugonjetsa tchimolo.” ");
INSERT INTO nya_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Tsiku lina Kaini anati kwa mʼbale wake Abele, “Tiye tipite ku munda.” Ndipo ali ku mundako, Kaini anawukira mʼbale wake namupha. ");
INSERT INTO nya_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ndipo Yehova anamufunsa Kaini kuti, “Ali kuti mʼbale wako Abele?” Iye anayankha kuti, “Sindikudziwa. Kodi ine ndine wosunga mʼbale wanga?” ");
INSERT INTO nya_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Yehova anati, “Kodi wachita chiyani? Tamvera! Magazi a mʼbale wako akulirira kwa Ine kuchokera mʼnthaka. ");
INSERT INTO nya_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ndipo tsopano ndiwe wotembereredwa ndipo wachotsedwa mʼdziko limene nthaka yake inatsekula pakamwa pake kulandira magazi a mʼbale wako amene unakhetsa. ");
INSERT INTO nya_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Udzalima munda koma nthakayo sidzakupatsanso zokolola zake. Udzakhala wosakhazikika; womangoyendayenda pa dziko lapansi.” ");
INSERT INTO nya_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kaini anati kwa Yehova, “Chilango changa ndi chachikulu kuposera mphamvu zanga. ");
INSERT INTO nya_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Lero mukundipirikitsa pa dziko ndi pamaso panu; ndidzakhala wosakhazikika, woyendayenda, ndipo aliyense amene adzandipeze adzandipha.” ");
INSERT INTO nya_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Koma Yehova anamuwuza kuti, “Sizidzatero ayi; aliyense amene adzaphe Kaini adzalangidwa ndi kulipiritsidwa kasanu ndi kawiri.” Pamenepo Yehova anayika chizindikiro pa Kaini kuti aliyense womupeza asamuphe. ");
INSERT INTO nya_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ndipo Kaini anachoka pamaso pa Yehova nakakhala ku dziko la Nodi, kummawa kwa Edeni. ");
INSERT INTO nya_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaini anagona malo amodzi ndi mkazi wake ndipo mkaziyo anakhala woyembekezera nabala Enoki. Kaini nthawi imeneyo nʼkuti akumanga mzinda ndipo anawutcha dzina la mwana wake Enoki. ");
INSERT INTO nya_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoki anabereka Iradi; Iradi anabereka Mehuyaeli, ndipo Mehuyaeli anabereka Metusela, ndipo Metusela anabereka Lameki. ");
INSERT INTO nya_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameki anakwatira akazi awiri, wina dzina lake linali Ada ndi winayo dzina lake linali Zila. ");
INSERT INTO nya_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada anabereka Yabala; iyeyu anali kholo la onse okhala mʼmatenti ndi oweta ziweto. ");
INSERT INTO nya_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Dzina la mʼbale wake linali Yubala; iyeyu anali kholo la onse oyimba zeze ndi chitoliro. ");
INSERT INTO nya_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila nayenso anali ndi mwana wamwamuna, dzina lake Tubala-Kaini. Iyeyu anali kholo la amisiri onse osula zida za mkuwa ndi chitsulo. Mlongo wake wa Tubala-Kaini anali Naama. ");
INSERT INTO nya_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameki anawuza akazi akewo kuti, “Ada ndi Zila, ndimvereni; inu akazi anga imvani mawu anga. Ine ndinapha munthu chifukwa anandipweteka. Ndinapha mnyamatayo chifukwa anandimenya. ");
INSERT INTO nya_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ngati wopha Kaini amulipsira kasanu nʼkawiri, ndiye kuti wopha ine Lameki adzamulipsira kokwanira 77.” ");
INSERT INTO nya_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu anagonanso malo amodzi ndi mkazi wake, ndipo anabereka mwana wamwamuna namutcha Seti, kutanthauza kuti, “Mulungu wandipatsa mwana wina mʼmalo mwa Abele, popeza Kaini anamupha.” ");
INSERT INTO nya_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seti naye anali ndi mwana wa mwamuna, ndipo anamutcha Enosi. Pa nthawi imeneyi anthu anayamba kupemphera mʼdzina la Yehova. ");
INSERT INTO nya_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ndondomeko ya mibado ya Adamu ndi iyi: Pamene Mulungu analenga munthu, anamulenga mʼchifaniziro cha Mulungu. ");
INSERT INTO nya_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Iye analenga mwamuna ndi mkazi. Anawadalitsa ndipo anawatcha “Munthu.” ");
INSERT INTO nya_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Pamene Adamu anali ndi zaka 130, anabereka mwana wamwamuna wofanana naye ndipo anamutcha Seti. ");
INSERT INTO nya_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Atabadwa Seti, Adamu anakhala ndi moyo zaka zina 800 ndipo anabereka ana ena aamuna ndi aakazi. ");
INSERT INTO nya_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Zaka zonse za Adamu zinali 930 ndipo anamwalira. ");
INSERT INTO nya_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Pamene Seti anali ndi zaka 105, anabereka Enosi. ");
INSERT INTO nya_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Atabadwa Enosi, Seti anakhala ndi moyo zaka zina 807 ndipo anabereka ana ena aamuna ndi aakazi. ");
INSERT INTO nya_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Zaka zonse za Seti zinali 912 ndipo anamwalira. ");
INSERT INTO nya_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Pamene Enosi anali ndi zaka 90, anabereka Kenani. ");
INSERT INTO nya_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Atabadwa Kenani, Enosi anakhala ndi moyo zaka zina 815 ndipo anabereka ana ena aamuna ndi aakazi. ");
INSERT INTO nya_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Zaka zonse za Enosi pamodzi zinali 905 ndipo anamwalira. ");
INSERT INTO nya_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Pamene Kenani anali ndi zaka 70, anabereka Mahalaleli. ");
INSERT INTO nya_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Atabadwa Mahalaleli, Kenani anakhala ndi moyo zaka zina 840 ndipo anabereka ana ena aamuna ndi aakazi. ");
INSERT INTO nya_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Zaka zonse za Kenani zinali 910, ndipo anamwalira. ");
INSERT INTO nya_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Pamene Mahalaleli anali ndi zaka 65, anabereka Yaredi. ");
INSERT INTO nya_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Atabadwa Yaredi, Mahalaleli anakhala ndi moyo zaka zina 830 ndipo anabereka ana ena aamuna ndi aakazi. ");
INSERT INTO nya_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Zaka zonse za Mahalaleli zinali 895 ndipo anamwalira. ");
INSERT INTO nya_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Pamene Yaredi anali ndi zaka 162, anabereka Enoki. ");
INSERT INTO nya_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Atabadwa Enoki, Yaredi anakhala ndi moyo zaka zina 800 ndipo anabereka ana ena aamuna ndi aakazi. ");
INSERT INTO nya_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Zaka zonse za Yaredi zinali 962 ndipo anamwalira. ");
INSERT INTO nya_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Pamene Enoki anali ndi zaka 65, anabereka Metusela. ");
INSERT INTO nya_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Atabadwa Metusela, Enoki anayenda ndi Mulungu zaka 300 ndipo anabereka ana ena aamuna ndi aakazi. ");
INSERT INTO nya_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Zaka zonse za Enoki zinali 365. ");
INSERT INTO nya_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoki anayenda ndi Mulungu; ndipo iye sanaonekenso chifukwa Mulungu anamutenga. ");
INSERT INTO nya_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Pamene Metusela anali ndi zaka 187, anabereka Lameki. ");
INSERT INTO nya_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ndipo atabadwa Lameki, Metusela anakhala ndi moyo zaka zina 782 ndipo anabereka ana ena aamuna ndi aakazi. ");
INSERT INTO nya_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Zaka zonse za Metusela zinali 969, ndipo anamwalira. ");
INSERT INTO nya_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Pamene Lameki anali ndi zaka 182, anabereka mwana wamwamuna. ");
INSERT INTO nya_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ndipo anamutcha Nowa ndipo anati, “Iyeyu adzatipumulitsa ku ntchito zathu zolemetsazi, zolima nthaka imene Yehova anayitemberera.” ");
INSERT INTO nya_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Atabadwa Nowa, Lameki anakhala zaka zina 595 ndipo anabereka ana ena aamuna ndi aakazi. ");
INSERT INTO nya_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Zaka zonse za Lameki zinali 777, ndipo kenaka anamwalira. ");
INSERT INTO nya_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Pamene Nowa anali ndi zaka 500, anabereka Semu, Hamu ndi Yafeti. ");
INSERT INTO nya_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Anthu atayamba kuchuluka pa dziko lapansi ndi kubereka ana aakazi, ");
INSERT INTO nya_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ana aamuna a Mulungu anaona kuti ana aakazi a anthuwo anali okongola. Ndipo anakwatira aliyense amene anamusankha. ");
INSERT INTO nya_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Tsono Yehova anati, “Sindilola kuti chipwirikiti chikuchitikachi chipitirire mpaka muyaya, pakuti iye ndi munthu; masiku a moyo wake adzakhala zaka 120.” ");
INSERT INTO nya_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Masiku amenewo komanso pambuyo pake, pa dziko lapansi panali Anefili, anthu amphamvu ndiponso otchuka. Anthuwa ndi amene ankabadwa ana a Mulungu aja atakwatira ana aakazi a anthu. ");
INSERT INTO nya_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Pamene Yehova anaona kuti kuyipa kwa munthu pa dziko lapansi kunali kwakukulu ndi kuti nthawi zonse amalingalira ndi kukhumbira kuchita zoyipa zokhazokha, ");
INSERT INTO nya_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yehova anamva chisoni kuti analenga munthu ndi kumuyika pa dziko lapansi, ndipo anawawidwa mtima. ");
INSERT INTO nya_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Choncho Yehova anati, “Ndidzafafaniza munthu, nyama, zonse zokwawa, ndi mbalame za mu mlengalenga pa dziko lapansi, pakuti ndikumva chisoni kuti ndinazilenga zimenezi.” ");
INSERT INTO nya_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Koma Yehova anamukomera mtima Nowa. ");
INSERT INTO nya_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Mbiri ya Nowa inali yotere: Nowa anali munthu wolungama ndi wopanda tchimo pakati pa anthu a mʼbado wake. Ndipo anayenda ndi Mulungu. ");
INSERT INTO nya_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nowa anabereka ana aamuna atatu: Semu, Hamu ndi Yafeti. ");
INSERT INTO nya_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Chiwawa chinadzaza pa dziko lapansi kotero kuti dziko linakhala lowonongeka pamaso pa Mulungu. ");
INSERT INTO nya_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Mulungu atayangʼana, anaona kuti dziko layipadi chifukwa cha makhalidwe oyipa a anthu onse pa dziko lapansi. ");
INSERT INTO nya_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ndipo Mulungu anati kwa Nowa, “Ndatsimikiza mtima kuti ndiwononge anthu onse, pakuti dziko lapansi ladzaza ndi ntchito zawo zoyipa. Ndithudi ndiwawononga pamodzi ndi zonse za pa dziko. ");
INSERT INTO nya_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Tsono udzipangire chombo cha matabwa a mtengo wanjale; mʼkati mwake upange zipinda ndipo upake phula mʼkati ndi kunja. ");
INSERT INTO nya_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Uchipange motere: Chombo chikhale mamita 140 mulitali, mamita 23 mulifupi ndi mamita 13 mu msinkhu wake. ");
INSERT INTO nya_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Uchipangire denga ndi kuchimaliza ndi zenera la masentimita makumi asanu. Uyike khomo mʼmbali mwa chombocho ndi kupanga zipinda zosanjikana; chapansi, chapakati ndi chapamwamba. ");
INSERT INTO nya_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ndidzagwetsa mvula ya chigumula pa dziko lapansi kuti ndiwononge zamoyo zonse za pansi pa thambo ndipo chilichonse cha pa dziko lapansi chidzafa. ");
INSERT INTO nya_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Koma ndidzachita pangano langa ndi iwe. Iwe, ana ako aamuna, mkazi wako ndi akazi a ana ako nonse mudzalowa mʼchombocho. ");
INSERT INTO nya_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Iwe udzalowa mʼchombocho ndi zolengedwa zamoyo zonse ziwiriziwiri, chachimuna ndi chachikazi, kuti zisungike ndi moyo pamodzi ndi iwe. ");
INSERT INTO nya_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Udzatenga ziwiriziwiri za mitundu yonse ya mbalame, mitundu yonse ya nyama, ndi mitundu yonse ya zokwawa kuti zikhale ndi moyo. ");
INSERT INTO nya_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Udzatengenso chakudya cha mtundu uliwonse ndi kuchisunga kuti inu ndi nyamazo muzidzadya.” ");
INSERT INTO nya_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nowa anachita zonse monga Mulungu anamulamulira. ");
INSERT INTO nya_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ndipo Yehova anati kwa Nowa, “Lowa mu chombo iwe ndi banja lako lonse, chifukwa ndaona kuti ndiwe wolungama mu mʼbado uwu. ");
INSERT INTO nya_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Pa mtundu uliwonse wa nyama zoti nʼkudya utengepo zazimuna zisanu ndi ziwiri ndi zazikazi zisanu ndi ziwirinso. Koma pa mtundu wa nyama iliyonse yosati nʼkudya utengepo zazimuna ziwiri ndi zazikazi ziwirinso. ");
INSERT INTO nya_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Chimodzimodzinso mbalame, utenge zisanu ndi ziwiri zazimuna ndi zisanu ndi ziwiri zazikazi za mtundu uliwonse kuti mitundu yawo isungike ndi moyo pa dziko lonse lapansi. ");
INSERT INTO nya_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Pakapita masiku asanu ndi awiri ndidzagwetsa mvula pa dziko lapansi kwa masiku makumi anayi usana ndi usiku ndipo ndidzawononga cha moyo chilichonse chimene ndinachipanga pa dziko lapansi.” ");
INSERT INTO nya_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ndipo Nowa anachita zonse zimene Yehova anamulamulira. ");
INSERT INTO nya_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Pamene chigumula chinabwera pa dziko lapansi Nowa anali ndi zaka 600. ");
INSERT INTO nya_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ndipo Nowa, ana ake aamuna, mkazi wake, pamodzi ndi ana ake aakazi analowa mu chombo chija kuthawa madzi a chigumula. ");
INSERT INTO nya_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Nyama zoti nʼkudya ndi nyama zosadyedwa, mbalame, pamodzi ndi nyama zokwawa zonse zinadza kwa Nowa ziwiriziwiri ndi kulowa mʼchombomo. ");
INSERT INTO nya_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Ndipo Nowa anatenga ziwiriziwiri, yayimuna ndi yayikazi monga anamulamulira Mulungu. ");
INSERT INTO nya_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Patapita masiku asanu ndi awiri chigumula chinabwera pa dziko lapansi. ");
INSERT INTO nya_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Pa tsiku la 17 la mwezi wachiwiri, Nowa ali ndi zaka 600, akasupe onse akuya kwambiri anasefuka ndiponso zitseko za madzi akumwamba zinatsekuka. ");
INSERT INTO nya_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ndipo mvula inagwa pa dziko lapansi masiku makumi anayi usana ndi usiku. ");
INSERT INTO nya_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Linali tsiku lomwelo pamene Nowa ndi ana ake aamuna, Semu, Hamu ndi Yafeti, pamodzi ndi mkazi wake ndi akazi a ana ake atatu aja analowa mu chombo. ");
INSERT INTO nya_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Iwowa analowa mʼchombomo pamodzi ndi nyama iliyonse ya kutchire monga mwa mtundu wake, ziweto zonse monga mwa mitundu yawo, nyama yokwawa iliyonse monga mwa mtundu wake ndi mbalame iliyonse monga mwa mtundu wake. ");
INSERT INTO nya_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Nowa analowa mu chombo muja pamodzi ndi zamoyo zonse. ");
INSERT INTO nya_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Iye analowa nazo zazimuna ndi zazikazi monga mmene Mulungu anamulamulira. Kenaka Yehova anatseka pa khomo. ");
INSERT INTO nya_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Chigumula chinagwa pa dziko la pansi kwa masiku makumi anayi. Madzi anayamba kuchuluka ndipo ananyamula chombo chija ndi kuchiyandamitsa pamwamba pa dziko. ");
INSERT INTO nya_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Madzi anafika mwamphamvu ndipo anachulukirachulukira pa dziko lapansi moti chombo chinayandama pamwamba pa madziwo. ");
INSERT INTO nya_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Madzi a chigumula anabwerabe molimbika motero kuti mapiri ataliatali onse a pa dziko anamizidwa. ");
INSERT INTO nya_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Madzi anakwera namiza mapiri kwa mamita pafupifupi asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Chamoyo chilichonse choyenda pa dziko lapansi chinafa: mbalame, ziweto, nyama zakuthengo, miyandamiyanda ya zonse zolengedwa za pa dziko lapansi pamodzi ndi anthu. ");
INSERT INTO nya_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Chilichonse chamoyo, chokhala pa mtunda chinafa. ");
INSERT INTO nya_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Chamoyo chilichonse pa dziko lapansi chinawonongedwa, kuyambira munthu, nyama, zokwawa ndi mbalame. Nowa yekha ndiye anatsala pamodzi ndi onse amene anali naye. ");
INSERT INTO nya_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Madziwo anadzaza dziko lonse lapansi kwa masiku 150. ");
INSERT INTO nya_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Tsono Mulungu anakumbukira Nowa ndi nyama zonse zakuthengo ndi ziweto zimene anali nazo mu chombo. Yehova anatumiza mphepo pa dziko lapansi ndipo madzi anaphwera. ");
INSERT INTO nya_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Tsono akasupe a madzi ambiri a pansi pa dziko ndi zitseko za madzi a kumwamba zinatsekedwa, ndipo mvula inaleka kugwa. ");
INSERT INTO nya_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Madzi amaphwabe pa dziko lapansi. Pakutha pa masiku 150, madzi anatsika, ");
INSERT INTO nya_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ndipo pa tsiku la 17 la mwezi wachisanu ndi chiwiri, chombo chija chinakakhazikika pa mapiri a Ararati. ");
INSERT INTO nya_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Madzi anapitirira kuphwa mpaka mwezi wa khumi, ndipo pa tsiku loyamba la mwezi wa khumiwo msonga za mapiri zinayamba kuonekera. ");
INSERT INTO nya_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Patapita masiku makumi anayi, Nowa anatsekula zenera limene anapanga mʼchombomo ");
INSERT INTO nya_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","natulutsa khwangwala, koma khwangwalayo ankangowuluka uku ndi uku mpaka madzi anawuma pa dziko lapansi. ");
INSERT INTO nya_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Kenaka anatulutsa nkhunda kuti aone ngati madzi aphwa pa dziko. ");
INSERT INTO nya_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Koma nkhunda sinapeze poti nʼkutera chifukwa panali madzi ponseponse pa dziko lapansi. Choncho inabwerera kwa Nowa mʼchombo. Nowa anatulutsa dzanja lake kunja ndi kutenga nkhundayo kuyibwezera mʼchombo mmene iye anali. ");
INSERT INTO nya_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Choncho anadikirabe masiku ena asanu ndi awiri ndipo anatulutsanso nkhundayo mʼchombo muja. ");
INSERT INTO nya_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Pamene nkhunda inabwerera madzulo ake, inali itanyamula tsamba laliwisi la mtengo wa olivi. Motero Nowa anadziwa kuti madzi aphwadi pa dziko lapansi. ");
INSERT INTO nya_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Iye anadikira masiku ena asanu ndi awiri ndipo anatumizanso nkhunda ija, koma nthawi imeneyi sinabwererenso kwa iye. ");
INSERT INTO nya_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Pofika tsiku loyamba la mwezi woyamba wa chaka chimene Nowa anakwanitsa zaka 601, madzi anawuma pa dziko lapansi. Ndipo Nowa anachotsa denga la chombo ndipo anaona kuti kunja kwawuma. ");
INSERT INTO nya_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Pokwana tsiku la 27 la mwezi wachiwiri dziko lapansi linawumiratu. ");
INSERT INTO nya_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Tsono Mulungu anawuza Nowa kuti, ");
INSERT INTO nya_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Iwe, mkazi wako, ana ako pamodzi ndi akazi awo tulukani mʼchombomo. ");
INSERT INTO nya_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Tulutsa zamoyo zonse zili ndi iwe, mbalame, nyama ndi zokwawa zonse kuti ziswane ndi kuchulukana pa dziko lapansi.” ");
INSERT INTO nya_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nowa anatuluka pamodzi ndi ana ake aamuna, mkazi wake ndi akazi a ana ake. ");
INSERT INTO nya_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Nyama zonse, zokwawa zonse, mbalame zonse, chilichonse choyenda pa dziko lapansi, zinatuluka mʼchombo motsogozana monga mwa mitundu yawo. ");
INSERT INTO nya_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Pamenepo Nowa anamanga guwa lansembe la Yehova ndipo anatengako mtundu uliwonse wa nyama zoti nʼkudya ndi mbalame zoti nʼkudya naperekapo nsembe yopsereza. ");
INSERT INTO nya_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yehova atamva fungo labwino anati mu mtima mwake: “Sindidzatembereranso nthaka chifukwa cha munthu, ngakhale kuti maganizo a mu mtima mwake ndi oyipa kuyambira ubwana wake. Ndipo sindidzawononganso zolengedwa zonse zamoyo monga ndachitiramu. ");
INSERT INTO nya_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Nthawi zonse mmene dziko lapansi lidzakhalire, nthawi yodzala ndi nthawi yokolola yozizira ndi yotentha, dzinja ndi chilimwe, usana ndi usiku, sizidzatha.” ");
INSERT INTO nya_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ndipo Mulungu anadalitsa Nowa ndi ana ake aamuna nati kwa iwo, “Berekanani ndipo muchulukane ndi kudzaza dziko lapansi. ");
INSERT INTO nya_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Nyama zonse za dziko lapansi, ndi mbalame zonse za mlengalenga, ndi chamoyo chilichonse chokwawa, ndiponso nsomba zonse za ku nyanja; zidzakuopani ndipo ndazipereka kuti muzilamulire. ");
INSERT INTO nya_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Tsopano chamoyo chilichonse chidzakhala chakudya chanu. Monga momwe ndinakupatsirani ndiwo zamasamba, tsopano ndikupatsaninso nyama iliyonse. ");
INSERT INTO nya_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Koma musamadye nyama imene ikanali ndi magazi oyenda. ");
INSERT INTO nya_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Aliyense wopha munthu adzaphedwa, nyama iliyonse yopha munthu idzaphedwa, munthu aliyense wopha munthu mnzake, adzaphedwa. ");
INSERT INTO nya_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Aliyense wopha munthu, adzaphedwanso ndi munthu; pakuti Mulungu analenga munthu mʼchifanizo chake. ");
INSERT INTO nya_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Inu muberekane ndi kuchulukana kuti mudzaze dziko lonse lapansi ndi kuligonjetsa.” ");
INSERT INTO nya_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Mulungu anawuza Nowa ndi ana ake kuti, ");
INSERT INTO nya_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Tsopano Ine ndapangana ndi iwe ndi zidzukulu zako zamʼtsogolomo, ");
INSERT INTO nya_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","pamodzi ndi zamoyo zonse, mbalame, ziweto ndi nyama zonse za kuthengo, ndi zonse zimene zinatuluka mʼchombo pamodzi ndi iwe. ");
INSERT INTO nya_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Pangano langa ndi ili: Ine ndilonjeza kuti sindidzawononganso zamoyo ndi madzi a chigumula. Chigumula sichidzawononganso dziko lapansi.” ");
INSERT INTO nya_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ndipo Mulungu anati, “Ine ndikupereka chizindikiro ichi cha pangano langa la pakati pa Ine ndi iwe, ana ako, zamoyo zonse, pamodzi ndi mibado ya mʼtsogolo. ");
INSERT INTO nya_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ndayika utawaleza wanga mʼmitambo, ndipo chidzakhala chizindikiro cha pangano langa ndi dziko lapansi. ");
INSERT INTO nya_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Nthawi zonse pakakhala mitambo mu mlengalenga ndipo utawaleza uwoneka, ");
INSERT INTO nya_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ndizikumbukira pangano langa pakati pa Ine ndi inu ndi zolengedwa zonse. Madzi sadzakhalanso chigumula chowononga dziko lapansi. ");
INSERT INTO nya_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Utawaleza ukamadzaoneka mʼmitambo, ndidzawuona ndi kukumbukira pangano losatha pakati pa Mulungu ndi zamoyo zonse pa dziko lapansi.” ");
INSERT INTO nya_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Choncho Mulungu anati kwa Nowa, “Ichi ndiye chizindikiro cha pangano limene ndalichita pakati pa Ine ndi zamoyo zonse pa dziko lapansi.” ");
INSERT INTO nya_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Ana aamuna a Nowa amene anatuluka mʼchombo muja anali Semu, Hamu ndi Yafeti. Hamu anali abambo ake a Kanaani. ");
INSERT INTO nya_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ana aamuna a Nowa amenewa ndiwo anali makolo a anthu onse pa dziko lapansi. ");
INSERT INTO nya_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowa anali munthu woyamba kulima munda wamphesa. ");
INSERT INTO nya_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Tsiku lina pamene Nowa anamwako vinyo wa zipatso za mʼmundawo analedzera ndipo anavula zovala zake zonse ndi kugona mu tenti yake ali maliseche. ");
INSERT INTO nya_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Hamu, abambo ake a Kanaani ataona kuti abambo ake ali maliseche anakawuza abale ake awiri aja omwe anali panja. ");
INSERT INTO nya_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Koma Semu ndi Yafeti anatenga chofunda nachiyika pa mapewa awo; ndipo anayenda chamʼmbuyo naphimba umaliseche wa abambo awo. Anafulatira kuti asaone umaliseche wa abambo awo. ");
INSERT INTO nya_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nowa atadzuka, kuledzera kutatha, ndikudziwa zimene mwana wake wamngʼono wamwamuna uja anamuchitira, ");
INSERT INTO nya_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","anati, “Atembereredwe Kanaani! Adzakhala kapolo wa pansi kwenikweni kwa abale ake.” ");
INSERT INTO nya_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Anatinso, “Atamandike Yehova, Mulungu wa Semu! Kanaani akhale kapolo wa Semu. ");
INSERT INTO nya_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Mulungu akulitse dziko la Yafeti; Yafeti alandire madalitso pamodzi ndi Semu, ndipo Kanaani akhale kapolo wawo.” ");
INSERT INTO nya_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Chitatha chigumula, Nowa anakhala ndi moyo zaka 350. ");
INSERT INTO nya_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Anamwalira ali ndi zaka 950. ");
INSERT INTO nya_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nayi mbiri ya ana a Nowa, Semu, Hamu ndi Yafeti. Ana atatuwa anabereka ana awo chitatha chigumula. ");
INSERT INTO nya_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ana aamuna a Yafeti anali: Gomeri, Magogi, Madai, Yavani, Tubala, Mesaki ndi Tirasi. ");
INSERT INTO nya_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ana aamuna a Gomeri anali: Asikenazi, Rifati ndi Togarima. ");
INSERT INTO nya_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ana aamuna a Yavani anali: Elisa, Tarisisi, Kitimu ndi Rodanimu. ");
INSERT INTO nya_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(Amenewa ndiwo makolo a anthu okhala mʼmphepete mwa nyanja. Awa ndi ana a Yafeti monga mwa mafuko a mu mitundu yawo, uliwonse ndi chiyankhulo chake). ");
INSERT INTO nya_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ana aamuna a Hamu anali: Kusi, Miziraimu, Puti ndi Kanaani. ");
INSERT INTO nya_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ana aamuna a Kusi anali: Seba, Havila, Sabita, Raama ndi Sabiteka. Ana aamuna a Raama anali: Seba ndi Dedani. ");
INSERT INTO nya_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusi anabereka Nimurodi amene anali wankhondo wamphamvu kwambiri pa dziko lapansi. ");
INSERT INTO nya_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Iye anali mlenje wamphamvu kwambiri pamaso pa Yehova; nʼchifukwa chake anthu ali ndi chisudzo, chakuti, “Ndiwe mlenje wamphamvu kwambiri pamaso pa Yehova monga Nimurodi.” ");
INSERT INTO nya_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Malo oyambirira a ufumu wake anali Babeli, Ereki, Akadi ndi Kaline. Malo onsewa anali mʼdziko la Sinara. ");
INSERT INTO nya_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Atachoka mʼdziko limeneli anapita ku Asiriya kumene anakamanga Ninive, Rehoboti-Iri, Kala, ");
INSERT INTO nya_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ndi Reseni, mzinda waukulu umene uli pakati pa Ninive ndi Kala. ");
INSERT INTO nya_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Igupto ndiye kholo la Aludi, Aanami, Alehabu, Anafutu, ");
INSERT INTO nya_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Apaturusi, Akasilu ndi Akafitori (kumene kunachokera Afilisti). ");
INSERT INTO nya_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaani anabereka mwana wake wachisamba, Sidoni, ndipo anaberekanso Ahiti; ");
INSERT INTO nya_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Ayebusi, Aamori, Agirigasi; ");
INSERT INTO nya_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Ahivi, Aariki, Asini, ");
INSERT INTO nya_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Aaravadi, Azemari ndi Ahamati. Pambuyo pake, mafuko a Akanaani anafalikira ponseponse, ");
INSERT INTO nya_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","mpaka ku malire a Kanaani. Malirewo anachokera ku Sidoni kulowa cha ku Gerari mpaka ku Gaza, ndi kulowa ku Sodomu, Gomora, Adima ndi Zeboimu mpaka ku Lasa. ");
INSERT INTO nya_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Amenewa ndiwo ana aamuna a Hamu monga mwa mafuko ndi ziyankhulo zawo, mʼmadera omwe amakhala ndi mitundu yawo. ");
INSERT INTO nya_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Semu amene anali mkulu wake wa Yafeti nayenso anabereka nakhala kholo la Eberi. ");
INSERT INTO nya_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ana aamuna a Semu anali: Elamu, Asuri, Aripakisadi, Ludi ndi Aramu. ");
INSERT INTO nya_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ana aamuna a Aramu anali: Uzi, Huri, Geteri ndi Mesaki. ");
INSERT INTO nya_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Aripakisadi anabereka Sela, ndipo Selayo anabereka Eberi. ");
INSERT INTO nya_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","A Eberi anabereka ana aamuna awiri: Wina anamutcha Pelegi chifukwa pa nthawiyo anthu a pa dziko lapansi anagawikana. Dzina la mʼbale wake linali Yokitani. ");
INSERT INTO nya_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokitani anabereka Alimodadi, Selefi, Hazari-Maveti, Yera, ");
INSERT INTO nya_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoramu, Uzali, Dikila, ");
INSERT INTO nya_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obali, Abimaeli, Seba, ");
INSERT INTO nya_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofiri, Havila ndi Yobabu. Onsewa anali ana aamuna a Yokitani. ");
INSERT INTO nya_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Chigawo chimene ankakhala chinayambira ku Mesa mpaka ku Seferi, ku dera la mapiri chakummawa. ");
INSERT INTO nya_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Amenewa ndiwo ana a Semu monga mwa mafuko ndi ziyankhulo zawo, mʼmadera omwe ankakhala ndi mitundu yawo. ");
INSERT INTO nya_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Amenewa ndiwo mafuko a ana aamuna a Nowa monga mwa mibado ya mitundu yawo. Mitundu yonse ya anthu inatuluka mwa iwowa ndi kufalikira pa dziko lonse lapansi chitatha chigumula chija. ");
INSERT INTO nya_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Nthawi imeneyo anthu onse a pa dziko lapansi ankayankhula chiyankhulo chimodzi ndipo mawu amene ankayankhula anali amodzi. ");
INSERT INTO nya_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Pamene anthu amapita chakummawa anapeza chigwa ku dziko la Sinara nakhazikikako. ");
INSERT INTO nya_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Tsono anawuzana kuti, “Tiyeni tiwumbe njerwa ndi kuziwotcha bwinobwino.” Tsono mʼmalo mwa miyala anagwiritsa ntchito njerwa zowotcha, ndipo mʼmalo mwa matope anagwiritsa ntchito phula. ");
INSERT INTO nya_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Kenaka anati, “Tiyeni tidzimangire mzinda wokhala ndi nsanja yoti ikafike kumwamba kuti titchuke. Kupanda kutero tibalalikana pa dziko lonse lapansi.” ");
INSERT INTO nya_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Koma Yehova anatsika kudzaona mzindawo ndi nsanja imene anthu aja ankayimanga. ");
INSERT INTO nya_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Yehova anati, “Anthuwa ndi amodzi, ndipo ali ndi chiyankhulo chimodzi. Izi akuchitazi nʼchiyambi chabe cha zomwe akufuna kukwaniritsa kuchita. ");
INSERT INTO nya_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Tiyeni titsikireko tikasokoneze chiyankhulo chawo kuti asamamvetsetsane.” ");
INSERT INTO nya_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Choncho Yehova anabalalitsa anthu aja pa dziko lonse lapansi ndipo analeka kumanga mzindawo. ");
INSERT INTO nya_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Nʼchifukwa chake mzindawo unatchedwa Babeli, popeza Yehova anasokoneza chiyankhulo cha anthu onse. Powachotsa kumeneko, Yehova anawabalalitsira pa dziko lonse lapansi. ");
INSERT INTO nya_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Nayi mibado yochokera kwa Semu. Patapita zaka ziwiri chitatha chigumula, Semu ali ndi zaka 100, anabereka Aripakisadi. ");
INSERT INTO nya_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Atabereka Aripakisadi, Semu anakhala ndi moyo zaka 500 ndipo anali ndi ana ena aamuna ndi aakazi. ");
INSERT INTO nya_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Pamene Aripakisadi anali ndi zaka 35, anabereka Sela. ");
INSERT INTO nya_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Atabereka Sela, Aripakisadi anakhala ndi moyo zaka zina 403 ndipo anali ndi ana ena aamuna ndi aakazi. ");
INSERT INTO nya_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Pamene Sela anali ndi zaka makumi atatu, anabereka Eberi. ");
INSERT INTO nya_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Atabereka Eberi, Sela anakhala ndi moyo zaka zina 403 ndipo anali ndi ana ena aamuna ndi aakazi. ");
INSERT INTO nya_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Pamene Eberi anali ndi zaka 34 anabereka Pelegi. ");
INSERT INTO nya_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Atabereka Pelegi, Eberi anakhala ndi moyo zaka zina 430 ndipo anali ndi ana ena aamuna ndi aakazi. ");
INSERT INTO nya_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pamene Pelegi anali ndi zaka makumi atatu, anabereka Reu. ");
INSERT INTO nya_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Atabereka Reu, Pelegi anakhala zaka zina 209 ndipo anali ndi ana ena aamuna ndi aakazi. ");
INSERT INTO nya_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Pamene Reu anali ndi zaka 32, anabereka Serugi. ");
INSERT INTO nya_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Atabereka Serugi, Reu anakhala ndi moyo zaka zina 207 ndipo anali ndi ana ena aamuna ndi aakazi. ");
INSERT INTO nya_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Pamene Serugi anali ndi zaka makumi atatu, anabereka Nahori. ");
INSERT INTO nya_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Atabereka Nahori, Serugi anakhala ndi moyo zaka zina 200 ndipo anali ndi ana ena aamuna ndi aakazi. ");
INSERT INTO nya_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Pamene Nahori anali ndi zaka 29, anabereka Tera. ");
INSERT INTO nya_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Atabereka Tera, Nahori anakhala ndi moyo zaka zina 119 ndipo anali ndi ana ena aamuna ndi aakazi. ");
INSERT INTO nya_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Pamene Tera anali ndi zaka 70, anabereka Abramu, Nahori ndi Harani. ");
INSERT INTO nya_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Nayi mibado yochokera mwa Tera. Tera anabereka Abramu, Nahori ndi Harani. Ndipo Harani anabereka Loti. ");
INSERT INTO nya_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Abambo ake a Tera akanali ndi moyo, Harani anamwalira ku Uri wa ku Akaldeya kumene anabadwira. ");
INSERT INTO nya_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abramu ndi Nahori onse anakwatira. Dzina la mkazi wa Abramu linali Sarai, ndipo la mkazi wa Nahori linali Milika. Iyeyu ndi Isika abambo awo anali Harani. ");
INSERT INTO nya_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai analibe ana chifukwa anali wosabereka. ");
INSERT INTO nya_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera anatenga mwana wake Abramu, mdzukulu wake Loti, ndi mpongozi wake Sarai, mkazi wa Abramu natuluka mzinda wa Uri wa ku Akaldeya kupita ku Kanaani. Pamene anafika ku Harani, anakhazikika kumeneko. ");
INSERT INTO nya_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera anamwalira ku Harani ali ndi zaka 205. ");
INSERT INTO nya_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Tsiku lina Yehova anamuwuza Abramu kuti, “Tuluka mʼdziko lako. Siya abale ako ndi banja la abambo ako ndipo pita ku dziko limene ndidzakusonyeza. ");
INSERT INTO nya_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Ndidzakusandutsa kholo la mtundu waukulu wa anthu ndipo ndidzakudalitsa; ndi kukusandutsa wotchuka kotero kuti udzakhala dalitso kwa anthu ambiri. ");
INSERT INTO nya_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ndidzadalitsa amene adzadalitsa iwe, ndi kutemberera amene adzatemberera iwe; ndipo mafuko onse a pa dziko lapansi adzadalitsika kudzera mwa iwe.” ");
INSERT INTO nya_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Choncho Abramu ananyamuka monga momwe Yehova anamuwuzira, napita pamodzi ndi Loti. Pamene Abramu amachoka ku Harani nʼkuti ali ndi zaka 75. ");
INSERT INTO nya_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abramu anatenga mkazi wake Sarai, Loti, mwana wamngʼono wake, pamodzi ndi chuma chawo chimene anapeza ndi antchito amene anali nawo ku Harani. Iwo ananyamuka ulendo mpaka kukafika ku dziko la Kanaani. ");
INSERT INTO nya_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abramu anadutsa mʼdzikomo mpaka kukafika ku Sekemu pa mtengo wa thundu wa ku More. Nthawi imeneyo Akanaani analipobe mʼdzikomo. ");
INSERT INTO nya_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yehova anadza kwa Abramu nati, “Kwa zidzukulu zako ndidzapereka dziko limeneli.” Choncho Abramu anamangira Yehova amene anadza kwa iye, guwa lansembe. ");
INSERT INTO nya_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Atachoka pamenepo analowera cha ku mapiri a kummawa kwa Beteli namangako tenti yake pakati pa Beteli chakumadzulo ndi Ai chakummawa. Kumeneko anamangira Yehova guwa lansembe napemphera mʼdzina la Yehovayo. ");
INSERT INTO nya_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kenaka Abramu ananyamuka kumalowera cha ku Negevi. ");
INSERT INTO nya_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kunagwa njala yayikulu mʼdzikomo, ndipo Abramu anapita ku Igupto kukakhala ngati mlendo kwa kanthawi kochepa popeza njalayo inakula kwambiri. ");
INSERT INTO nya_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Atatsala pangʼono kulowa mu Igupto, Abramu anamuwuza mkazi wake Sarai kuti, “Ndimadziwa kuti ndiwe mkazi wokongola kwambiri. ");
INSERT INTO nya_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Tsono Aigupto akakuona adzanena kuti ‘Ameneyu ndi mkazi wake.’ Tsono adzandipha ine nakusiya iwe ndi moyo. ");
INSERT INTO nya_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Tsono udzikawawuza kuti iwe ndiwe mlongo wanga. Ukatero zidzandiyendera bwino ndipo ndidzapulumuka chifukwa cha iwe.” ");
INSERT INTO nya_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Pamene Abramu anafika ku Igupto, Aigupto aja anaona kuti Sarai anali mkazi wokongoladi. ");
INSERT INTO nya_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Pamene akuluakulu a ku nyumba ya Farao anamuona, anakamuyamikira pamaso pa Farao ndipo ananka naye ku nyumba ya Farao. ");
INSERT INTO nya_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Abramu naye zinthu zinkamuyendera bwino chifukwa cha Sarai. Farao anamupatsa nkhosa, ngʼombe, abulu aamuna ndi abulu aakazi, antchito aakazi pamodzi ndi ngamira. ");
INSERT INTO nya_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Koma Yehova anabweretsa matenda owopsa pa Farao pamodzi ndi banja lake lonse chifukwa cha Sarai mkazi wa Abramu. ");
INSERT INTO nya_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Choncho Farao anayitanitsa Abramu namufunsa kuti, “Nʼchiyani wandichitirachi? Nʼchifukwa chiyani sunandiwuze kuti ameneyu ndi mkazi wako? ");
INSERT INTO nya_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nʼchifukwa chiyani unati ndi mlongo wako, mpaka ine ndinamutenga kukhala mkazi wanga? Eko mkazi wako. Mutenge uzipita!” ");
INSERT INTO nya_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Farao analamula asilikali ake ndipo iwo anamutulutsa Abramu pamodzi ndi mkazi wake ndi zonse anali nazo. ");
INSERT INTO nya_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Choncho Abramu pamodzi ndi mkazi wake ndi zonse anali nazo, anachoka ku Igupto kupita ku Negevi. Loti naye anapita nawo. ");
INSERT INTO nya_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abramu anali wolemera kwambiri; anali ndi ziweto ndiponso siliva ndi golide. ");
INSERT INTO nya_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Atachoka ku Negevi, anayenda malo osiyanasiyana mpaka anafika ku Beteli, ku malo a pakati pa Beteli ndi Ai, kuja kumene anamanga tenti poyamba, ");
INSERT INTO nya_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ndiponso kumene Abramu anamangira Yehova guwa lansembe kwa nthawi yoyamba ndi kupemphera mʼdzina la Yehova. ");
INSERT INTO nya_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Loti amene ankayendayenda ndi Abramu nayenso anali ndi ziweto zosiyanasiyana ndi matenti. ");
INSERT INTO nya_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Motero dziko linayamba kuwachepera kuti onse nʼkukhala pamodzi, popeza katundu wawo anali wochuluka kwambiri moti sakanatha kukhala pamodzi. ");
INSERT INTO nya_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Mikangano inayambika pakati pa abusa a Abramu ndi abusa a Loti. Nthawi imeneyo nʼkuti Akanaani ndi Aperezi akukhalanso mʼdziko lomwelo. ");
INSERT INTO nya_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Tsono Abramu anati kwa Loti, “Pasakhale mikangano pakati pa iwe ndi ine kapena pakati pa abusa ako ndi anga, popeza ndife abale. ");
INSERT INTO nya_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Kodi dziko lonseli silili pamaso pako? Tiye tisiyane. Iwe ukalowera kumanzere, ine ndilowera kumanja; ukalowera kumanja, ine ndipita kumanzere.” ");
INSERT INTO nya_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Loti atamwazamwaza maso anaona kuti chigwa chonse cha mtsinje wa Yorodani chinali chothiriridwa bwino ngati munda wa Yehova, kapena ngati dziko la ku Igupto mpaka ku Zowari. (Nthawi iyi nʼkuti Yehova asanawononge Sodomu ndi Gomora). ");
INSERT INTO nya_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Choncho Loti anadzisankhira yekha chigwa chonse cha Yorodani nanyamuka kulowera cha kummawa. Choncho anthu awiriwa anasiyana. ");
INSERT INTO nya_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abramu anakhala mʼdziko la Kanaani, pamene Loti anakakhala pakati pa mizinda ikuluikulu ya mʼchigwamo. Anamanga tenti yake pafupi ndi Sodomu. ");
INSERT INTO nya_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Tsono anthu a ku Sodomu anali oyipa ndiponso ankachimwira Yehova kwambiri. ");
INSERT INTO nya_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Loti atachoka, Yehova anati kwa Abramu, “Kuchokera pamene ulipo tayangʼanayangʼana cha kumpoto, kummwera, kummawa ndi kumadzulo. ");
INSERT INTO nya_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Dziko lonse ukulionalo ndidzalipereka kwa iwe ndi zidzukulu zako mpaka muyaya. ");
INSERT INTO nya_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ndidzakupatsa zidzukulu zochuluka ngati fumbi lapansi moti amene angathe kuwerenga fumbilo ndiye kuti angathenso kuwerenga zidzukulu zako. ");
INSERT INTO nya_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Dzuka ndipo uyendere dziko lonseli mulitali ndi mulifupi pakuti ndalipereka kwa iwe.” ");
INSERT INTO nya_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Choncho Abramu anasamutsa tenti yake napita kukakhala pafupi ndi mitengo ikuluikulu ija ya thundu ya ku Mamre ku Hebroni, kumene anamangira Yehova guwa lansembe. ");
INSERT INTO nya_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Pa nthawi imeneyi Amarafeli mfumu ya Sinara, Arioki mfumu ya Elasara, Kedorilaomere mfumu ya Elamu ndi Tidala mfumu ya Goimu ");
INSERT INTO nya_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","anathira nkhondo Bera mfumu ya ku Sodomu, Birisa mfumu ya Gomora, Sinabi mfumu ya Adima, Semeberi mfumu ya Ziboimu ndi mfumu ya Bela (kumeneko ndi ku Zowari). ");
INSERT INTO nya_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Mafumu onse anathiridwa nkhondowa anagwirizana pamodzi kupita ku Chigwa cha Sidimu (Nyanja ya Mchere). ");
INSERT INTO nya_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kwa zaka khumi ndi ziwiri anali pansi pa ulamuliro wa Kedorilaomere, koma mʼchaka cha khumi ndi chitatu anamuwukira. ");
INSERT INTO nya_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mʼchaka cha khumi ndi chinayi, Kedorilaomere mogwirizana ndi mafumu ena aja anapita kukagonjetsa Arefaiwa ku Asiteroti-karanaimu, Zuzimu wa ku Hamu, Aemi wa ku Savekiriataimu ");
INSERT INTO nya_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","amene ankakhala ku Ahori, ku dziko la mapiri la Seiri mpaka ku Eli Parani kufupi ndi chipululu. ");
INSERT INTO nya_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Kenaka anabwerera napita ku Eni-Misipati (ku Kadesi), ndipo anagonjetsa dera lonse la Aamaleki, kuphatikizanso Aamori amene ankakhala ku Hazazoni Tamara. ");
INSERT INTO nya_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Tsono mafumu a ku Sodomu, Gomora, Adima, Zeboimu ndi ku Bela (ku Zowari) anapita ku Chigwa cha Sidimu kukakonzekera kuthira nkhondo ");
INSERT INTO nya_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Kedorilaomere mfumu ya Elamu, Tidala mfumu ya Goimu, Amarafeli mfumu ya Sinara ndi Arioki mfumu ya Elasara. Mafumu anayi analimbana ndi mafumu asanu. ");
INSERT INTO nya_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Koma Chigwa cha Sidimu chinali chodzaza ndi maenje aphula. Choncho pamene mafumu a ku Sodomu ndi Gomora amathawa, ankhondo ena anagweramo ndipo ena anathawira ku mapiri. ");
INSERT INTO nya_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Mafumu anayi aja anatenga katundu yense ndi chakudya chonse cha ku Sodomu ndi Gomora napita nazo. ");
INSERT INTO nya_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Anatenganso Loti, mwana wa mʼbale wake wa Abramu pamodzi ndi katundu wake popeza ankakhala mu Sodomu. ");
INSERT INTO nya_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Koma munthu wina amene anathawa, anabwera kudzamufotokozera Abramu Mhebri. Tsono Abramu ankakhala pafupi ndi mitengo ikuluikulu ya thundu ya Mamre wa fuko la Aamori, mʼbale wake wa Esikolo ndi Aneri. Onsewa anali pa mgwirizano ndi Abramu. ");
INSERT INTO nya_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abramu atamva kuti Loti wagwidwa pa nkhondo, anasonkhanitsa asilikali 318 obadwira mʼbanja lake lomwelo nalondola mpaka ku Dani. ");
INSERT INTO nya_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Pa nthawi ya usiku Abramu anawagawa asilikali ake kuti athire nkhondo mafumu aja, ndipo anawakantha nawapirikitsa mpaka ku Hoba, cha kumpoto kwa Damasiko. ");
INSERT INTO nya_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ndipo anawalanda katundu wawo yense nabwera naye Loti, katundu wake yense, pamodzi ndi akazi ndi anthu ena. ");
INSERT INTO nya_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abramu atabwerera kuchokera kogonjetsa Kedorilaomere ndi mafumu amene anali nawo pa mgwirizano, mfumu ya ku Sodomu inabwera kudzakumana naye ku Chigwa cha Save (chimenechi ndicho Chigwa cha Mfumu). ");
INSERT INTO nya_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ndipo Melikizedeki mfumu ya ku Salemu anabweretsa buledi ndi vinyo. Iyeyu anali wansembe wa Mulungu Wammwambamwamba, ");
INSERT INTO nya_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ndipo anadalitsa Abramu nati, “Mulungu Wammwambamwamba, wolenga kumwamba ndi dziko lapansi, akudalitse iwe Abramu. ");
INSERT INTO nya_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ndipo adalitsike Mulungu Wammwambamwamba amene anapereka adani ako mʼdzanja lako.” Ndipo Abramu anamupatsa iye chakhumi cha zonse anali nazo. ");
INSERT INTO nya_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mfumu ya Sodomu inati kwa Abramu, “Ine undipatse anthu okhawo, koma katundu akhale wako.” ");
INSERT INTO nya_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Koma Abramu anawuza mfumu ya Sodomu kuti, “Ndakweza manja anga kwa Yehova, Mulungu Wammwambamwamba, Mlengi wakumwamba ndi dziko lapansi, kulumbira ");
INSERT INTO nya_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","kuti sindidzalandira kanthu kalikonse kako, ngakhale utakhala ulusi chabe kapena chingwe cha nsapato, kuopa kuti ungamanene kuti, ‘Ndamulemeretsa Abramu.’ ");
INSERT INTO nya_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Sindidzalandira kanthu kalikonse kupatula zokhazo zimene anthu anga adya ndi gawo la katundu la anthu amene ndinapita nawo monga Aneri, Esikolo ndi Mamre. Iwowa atenge gawo lawo.” ");
INSERT INTO nya_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Zitatha izi, Yehova anayankhula ndi Abramu mʼmasomphenya nati: “Usaope Abramu. Ine ndili ngati chishango chokutchinjiriza. Mphotho yako idzakhala yayikulu.” ");
INSERT INTO nya_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Koma Abramu anati, “Haa! Ambuye Yehova, mukhoza kundipatsa chiyani popeza ndikanali wopanda mwana ndipo amene adzatenge chuma changa ndi Eliezara wa ku Damasiko? ");
INSERT INTO nya_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Inu simunandipatse ana kotero kuti wantchito wa ku nyumba kwanga ndiye amene adzalowe mʼmalo mwanga.” ");
INSERT INTO nya_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Yehova anayankhula naye nati: “Munthu uyu sadzalowa mʼmalo mwako, koma mwana wako weniweni wamwamuna, wobereka wekha ndiye adzalowe mʼmalo mwako.” ");
INSERT INTO nya_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Yehova anapita naye Abramu panja nati, “Tayangʼana kumwambaku, ndipo chifukwa cha chimenechi uwerenge nyenyezi ngati ungathe kuziwerenga.” Ndipo anamuwuza kuti, “Ndi mmene adzakhalire ana ako ndi zidzukulu zako.” ");
INSERT INTO nya_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abramu anakhulupirira Yehova, ndipo ichi chinamuchititsa kukhala wolungama. ");
INSERT INTO nya_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ndipo anamuwuza kuti, “Ine ndine Yehova amene ndinakuchotsa iwe ku mzinda wa Uri wa ku Akaldeya kuti ndikupatse dziko ili kuti likhale lako.” ");
INSERT INTO nya_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Koma Abramu anati, “Haa! Ambuye Yehova, kodi ndingadziwe bwanji kuti lidzakhaladi langa?” ");
INSERT INTO nya_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Kotero Yehova anati kwa iye, “Kanditengere kamsoti kangʼombe ka zaka zitatu, kamsoti ka mbuzi ka zaka zitatu, ndi nkhosa yayimuna ya zaka zitatu pamodzi ndi nkhunda ndi kamwana ka njiwa.” ");
INSERT INTO nya_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abramu anabweretsadi zonsezi nadula chilichonse pakati nʼkuzindandalika, chidutswa chilichonse kuyangʼanana ndi chinzake; koma njiwa ndi nkhunda sanazidule pakati. ");
INSERT INTO nya_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Pamene miphamba inabwera kuti itole nyama ija, Abramu anayipirikitsa. ");
INSERT INTO nya_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Pamene dzuwa limalowa Abramu anagona tulo tofa nato ndipo mdima wandiweyani ndi wochititsa mantha unamuphimba. ");
INSERT INTO nya_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Tsono Yehova anati kwa iye, “Uyenera kudziwa mosakayika kuti zidzukulu zako zidzakhala alendo mʼdziko lachilendo ndipo zidzakhala akapolo ndi kuzunzidwa zaka 400. ");
INSERT INTO nya_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Koma ndidzalanga dziko limene zidzukulu zako zidzagwireko ukapolo ndipo pambuyo pake iwo adzatulukamo ndi chuma chambiri. ");
INSERT INTO nya_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Komabe iweyo udzamwalira mu mtendere ndi kuyikidwa mʼmanda utakalamba bwino. ");
INSERT INTO nya_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Patapita mibado inayi, adzukulu ako adzabwereranso kuno popeza tchimo la Aamori silinafike pachimake kuti alangidwe.” ");
INSERT INTO nya_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Dzuwa litalowa ndipo mdima utagwa, panaoneka mʼphika wofuka nthunzi ya moto ndi sakali yoyaka ndipo zinadutsa pakati pa zidutswa za nyama zija. ");
INSERT INTO nya_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Pa tsiku limenelo, Yehova anachita pangano ndi Abramu nati, “Ndikulonjeza kuti ndidzapereka dziko ili kwa zidzukulu zako, kuchokera ku mtsinje wa ku Igupto mpaka ku mtsinje waukulu wa Yufurate. ");
INSERT INTO nya_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ndidzakupatsani dziko la Akeni, Akenizi, Akadimoni, ");
INSERT INTO nya_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Ahiti, Aperezi, Arefaimu, ");
INSERT INTO nya_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Aamori, Akanaani, Agirigasi ndi Ayebusi.” ");
INSERT INTO nya_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Tsono Sarai, mkazi wa Abramu anali asanamuberekere ana Abramuyo. Koma anali ndi wantchito wamkazi wa ku Igupto dzina lake Hagara; ");
INSERT INTO nya_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ndipo Sarai anati kwa Abramu, “Yehova sanalole kuti ine ndikhale ndi ana. Bwanji mulowe mwa wantchito wanga wamkaziyu kuti mwina ndingaone ana kudzera mwa iyeyu.” Abramu anamvera Sarai. ");
INSERT INTO nya_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Tsono Sarai anatenga Hagara wantchito wake wamkazi wa ku Igupto uja namupereka kwa Abramu mwamuna wake kuti akhale mkazi wake. Izi zinachitika Abramu atakhala ku Kanaani zaka khumi. ");
INSERT INTO nya_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abramu atalowana ndi Hagara, Hagara uja anatenga mimba. Pamene Hagara anadziwa kuti anali woyembekezera anayamba kunyoza mbuye wake Sarai. ");
INSERT INTO nya_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Pamenepo Sarai anati kwa Abramu, “Inu ndinu amene mwandiputira nkhanza zikundichitikirazi. Ndinakupatsani wantchito wanga wamkazi kuti akhale mkazi wanu, ndiye tsopano wayamba kundinyoza ine chifukwa wadziwa kuti ndi woyembekezera. Yehova ndiye amene aweruze pakati pa inu ndi ine.” ");
INSERT INTO nya_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abramu anati, “Wantchito wakoyu ali mʼmanja mwako. Chita naye chilichonse chimene ukuganiza kuti ndi chokukomera.” Tsono Sarai anazunza Hagara mpaka anathawa. ");
INSERT INTO nya_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Mngelo wa Yehova anamupeza Hagara pafupi ndi chitsime mʼchipululu. Chinali chitsime chimene chili mʼmphepete mwa msewu wopita ku Suri. ");
INSERT INTO nya_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ndipo mngeloyo anati, “Hagara, iwe wantchito wa Sarai, ukuchokera kuti ndipo ukupita kuti?” Iye anayankha, “Ndikuthawa mbuye wanga Sarai.” ");
INSERT INTO nya_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Mngelo wa Yehova anamuwuza kuti, “Bwerera kwa mbuye wako ndipo ukamugonjere. ");
INSERT INTO nya_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ndidzakupatsa zidzukulu zambiri zoti munthu sangaziwerenge.” ");
INSERT INTO nya_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Mngelo wa Yehova uja anamuwuzanso kuti, “Ndiwe woyembekezera ndipo udzabala mwana wamwamuna. Udzamutcha dzina lake Ismaeli, pakuti Yehova wamva kulira chifukwa cha kuzunzika kwako. ");
INSERT INTO nya_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Iye adzakhala munthu wa khalidwe ngati mʼmbulu wamisala; adzadana ndi aliyense ndipo anthu onse adzadana naye, adzakhala mwaudani pakati pa abale ake onse.” ");
INSERT INTO nya_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagara anatcha Yehova amene anamuyankhula uja dzina loti: “Ndinu Mulungu amene mumandiona,” popeza anati, “Ndakumana ndi Yehova atatha kundikomera mtima.” ");
INSERT INTO nya_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Nʼchifukwa chake chitsime chija chimene chili pakati pa Kadesi ndi Beredi chinatchedwa Beeri-lahai-roi. ");
INSERT INTO nya_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Tsono Hagara anamuberekera Abramu mwana wamwamuna ndipo Abramu anamutcha mwanayo Ismaeli. ");
INSERT INTO nya_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Pamene Hagara anamubalira Ismaeli nʼkuti Abramuyo ali ndi zaka 86. ");
INSERT INTO nya_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Pamene Abramu anali ndi zaka 99, Yehova anamuonekera nati, “Ine ndine Mulungu Wamphamvuzonse. Ukhale munthu wochita zolungama nthawi zonse. ");
INSERT INTO nya_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ndipo Ine ndikulonjeza kuti ndidzakupatsa zidzukulu zambiri.” ");
INSERT INTO nya_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Pomwepo Abramu anadziponya pansi ndipo Mulungu anati kwa iye, ");
INSERT INTO nya_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Pangano langa ndi iwe ndi ili: Udzakhala kholo la mitundu yambiri ya anthu. ");
INSERT INTO nya_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Sudzatchedwanso Abramu; dzina lako lidzakhala Abrahamu, chifukwa ndakusandutsa kukhala kholo la mitundu yambiri ya anthu. ");
INSERT INTO nya_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ndidzakupatsa zidzukulu zambiri motero kuti mitundu yambiri ya anthu idzatuluka mwa iwe. Mafumunso adzatuluka mwa iwe. ");
INSERT INTO nya_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Pangano langa ndi iwe pamodzi ndi zidzukulu za mibado ya mʼtsogolo lidzakhala la muyaya. Ndidzakhala Mulungu wako ndi Mulungu wa zidzukulu zako. ");
INSERT INTO nya_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Dziko lonse la Kanaani, limene iwe ukukhala tsopano, ndalipereka kwa iwe ndi kwa zidzukulu zako kuti likhale chuma chanu mpaka muyaya. Ndipo Ine ndidzakhala Mulungu wa zidzukulu zako.” ");
INSERT INTO nya_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Kenaka Mulungu anati kwa Abrahamu, “Koma iwe pamodzi ndi zidzukulu zako zobwera pambuyo pako mʼmibado ya mʼtsogolomo, sungani pangano langali. ");
INSERT INTO nya_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Iwe pamodzi ndi zidzukulu zako zobwera pambuyo pako muzisunga pangano ili loti mwamuna aliyense pakati panupa azichita mdulidwe. ");
INSERT INTO nya_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Kuyambira tsopano muzichita mdulidwe ndipo ichi chidzakhala chizindikiro cha pangano langa ndi iwe. ");
INSERT INTO nya_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Kuyambira tsopano mpaka mibado ya mʼtsogolomo mwana wamwamuna aliyense pakati panu amene wakwana masiku asanu ndi atatu ayenera kuchita mdulidwe. Awa ndi ana obadwa mʼbanja lako, kapena akapolo ochita kugula ndi ndalama, mlendo osakhala wa mʼmbumba yako. ");
INSERT INTO nya_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Achite mdulidwe ndithu mwana wamwamuna aliyense, mbadwa ngakhale kapolo wochita kugula ndi ndalama, ndipo ichi chidzakhala chizindikiro pa thupi lanu cha pangano langa lamuyaya. ");
INSERT INTO nya_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Mwamuna aliyense amene adzakhala wosachita mdulidwe adzachotsedwa pakati pa anthu ake chifukwa sanasunge pangano langa.” ");
INSERT INTO nya_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Mulungu anatinso kwa Abrahamu, “Sarai mkazi wako, sudzamutchanso Sarai; dzina lake lidzakhala Sara. ");
INSERT INTO nya_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ndidzamudalitsa ndipo adzakubalira mwana wamwamuna. Ndidzamudalitsa kuti akhale mayi wa mitundu ya anthu; mafumu a anthuwo adzachokera mwa iye.” ");
INSERT INTO nya_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abrahamu anadzigwetsa pansi pamaso pa Yehova, Iye anaseka nati, “Kodi munthu wa zaka 100 nʼkubala mwana? Kodi Sara adzabereka mwana pa msinkhu wa zaka makumi asanu ndi anayi?” ");
INSERT INTO nya_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ndipo Abrahamu anati kwa Mulungu, “Bwanji mumudalitse Ismaeli.” ");
INSERT INTO nya_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Koma Mulungu anati, “Ayi, koma mkazi wako Sara adzakubalira mwana wamwamuna, ndipo udzamutcha Isake. Ndidzasunga pangano langa losatha ndi iyeyu komanso ndi zidzukulu zobwera pambuyo pake. ");
INSERT INTO nya_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Koma za Ismaeli, ndamva. Ndidzamudalitsadi, ndipo adzakhala ndi zidzukulu zambiri. Iye adzakhala kholo la mafumu khumi ndi awiri ndipo mwa iye mudzatuluka mtundu waukulu wa anthu. ");
INSERT INTO nya_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Koma ndidzasunga pangano langali ndi Isake amene Sara adzakubalira pofika nthawi ngati ino chaka chamawa.” ");
INSERT INTO nya_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Atatha kuyankhula, Mulungu anamuchokera Abrahamu. ");
INSERT INTO nya_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Tsono Abrahamu anachita mdulidwe mwana wake Ismaeli ndi onse amene anali mʼbanja lake, mbadwa ngakhale kapolo ochita kugula ndi ndalama, monga mmene Mulungu analamulira. ");
INSERT INTO nya_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abrahamu anali ndi zaka 99 pamene anachita mdulidwe, ");
INSERT INTO nya_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ndipo mwana wake Ismaeli anali ndi zaka khumi ndi zitatu; ");
INSERT INTO nya_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Onse, Abrahamu ndi mwana wake Ismaeli, anachita mdulidwe tsiku limodzi. ");
INSERT INTO nya_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Aliyense wamwamuna wa pa banja pa Abrahamu, kuphatikizapo iwo amene anabadwira pa banja pomwepo kapena akapolo ogula ndi ndalama kwa alendo, anachita mdulidwe. ");
INSERT INTO nya_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Yehova anadza kwa Abrahamu pafupi ndi mitengo ikuluikulu ya thundu ya ku Mamre. Abrahamu nʼkuti atakhala pansi pa khoma la tenti yake masana, dzuwa likutentha. ");
INSERT INTO nya_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Tsono Abrahamu atakweza maso ake patali anangoona anthu atatu atayima cha potero. Atawaona, ananyamuka mofulumira kuti awachingamire. Atafika anaweramitsa mutu pansi mwa ulemu nati, ");
INSERT INTO nya_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“Ngati mwandikomera mtima, mbuye wanga, musamulambalale mtumiki wanu. ");
INSERT INTO nya_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ndikupatseniko timadzi pangʼono kuti nonse musambitse mapazi anu ndi kupumula pansi pa mtengo uwu. ");
INSERT INTO nya_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Tsono ndikutengereniko kachakudya kuti mudye kuti mwina nʼkupezako mphamvu zopitirizira ulendo wanu. Inu mwafika kumalo kwa mtumiki wanu.” Ndipo iwo anamuyankha nati, “Zikomo kwambiri, chita monga wanenera.” ");
INSERT INTO nya_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Choncho Abrahamu anafulumira kupita kwa Sara mʼtenti nati, “Tafulumira, tenga mabeseni atatu a ufa wosalala, ukande ndi kupanga buledi.” ");
INSERT INTO nya_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Kenaka Abrahamu anakatenga mwana wangʼombe wonenepa ndi wofewa bwino ndi kupatsa wantchito wake amene anachita changu kukonza ndiwoyo. ");
INSERT INTO nya_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Tsono Abrahamu anatenga chambiko, mkaka ndi mwana wangʼombe wokonzedwa uja nazipereka kwa anthu aja. Alendowo akudya, Abrahamu ankawayangʼana atayimirira pansi pa mtengo. ");
INSERT INTO nya_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Anthuwo anafunsa Abrahamu kuti, “Mkazi wako Sara ali kuti?” Iye anati, “Ali mu tentimu.” ");
INSERT INTO nya_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Tsono mmodzi mwa iwo anati, “Mosakayikira ndidzabweranso pa nthawi ngati yomwe ino chaka chamawa, ndipo Sara mkazi wako adzakhala ndi mwana wamwamuna.” Koma Sara amene anali kumbuyo kwa Abrahamu pa khoma la tenti ankamva zonsezi. ");
INSERT INTO nya_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abrahamu ndi Sara anali okalamba kale ndipo anali ndi zaka zambiri. Sara nʼkuti atapyola kale pa msinkhu oti nʼkubereka. ");
INSERT INTO nya_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Choncho anangoseka nati mu mtima mwake, “Kodi munthu wothayitha ngati ine ndingasangalalenso kugona pamodzi ndi mbuye wanga? Mwamuna wanga nayenso ndi wokalamba.” ");
INSERT INTO nya_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ndipo Yehova anati kwa Abrahamu, “Nʼchifukwa chiyani Sara anaseka nʼkumati, ‘Moti ine nʼkudzakhaladi ndi mwana mmene ndakalambiramu?’ ");
INSERT INTO nya_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Kodi pali chimene chikhoza kumukanika Yehova? Pa nthawi yake, ngati yomwe ino chaka chamawa ndidzabweranso, ndipo Sara adzabala mwana wamwamuna.” ");
INSERT INTO nya_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Koma Sara ndi mantha ananama nati, “Sindinaseke.” Koma Iye anati, “Inde iwe unaseka.” ");
INSERT INTO nya_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Kenaka anthu aja ananyamuka ndi kumapita, molunjika ku Sodomu. Ndipo Abrahamu anayenda nawo pamodzi kuwaperekeza. ");
INSERT INTO nya_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Tsono Yehova anati mu mtima mwake, “Kodi ndingamubisire Abrahamu chimene ndikuti ndichite posachedwa? ");
INSERT INTO nya_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abrahamu adzakhaladi mtundu wa anthu waukulu ndi wamphamvu, ndipo mitundu yonse ya anthu pa dziko lapansi adzadalitsika kudzera mwa iye. ");
INSERT INTO nya_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Pakuti ndasankha iyeyu kuti adzatsogolere ana ake ndi a pa banja lake, kuti asunge mawu a Yehova pochita zoyenera ndi zachilungamo. Choncho Yehova adzachita kwa Abrahamu chimene anamulonjeza iye.” ");
INSERT INTO nya_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ndipo Yehova anati kwa Abrahamu, “Kulirira Gomora kwakula ndipo tchimo lawo lafika poyipa kwambiri ");
INSERT INTO nya_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","choncho ndikuti ndipiteko ndikaone ngati zimene achita zilidi zoyipa monga mmene madandawulo andipezera Ine. Ngati sizili choncho, ndikadziwa.” ");
INSERT INTO nya_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Anthu aja anatembenuka nʼkumapita, kulowera ku Sodomu, koma Abrahamu anali chiyimirire pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Kenaka Abrahamu anasendera kufupi ndi Iye nati, “Kodi mudzawonongera kumodzi wolungama ndi woyipa? ");
INSERT INTO nya_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Nanga bwanji patakhala anthu makumi asanu olungama mu mzindamo? Kodi mudzawonongadi onse osausiyako mzindawo chifukwa cha anthu makumi asanu olungama omwe ali mʼmenemo? ");
INSERT INTO nya_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ndithu simungachite zimenezi, kupha anthu olungama pamodzi ndi oyipa. Nʼzosatheka kuti inu nʼkufananitsa olungama ndi oyipa. Kodi woweruza wa dziko lapansi nʼkulephera kuchita chilungamo?” ");
INSERT INTO nya_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yehova anati, “Nditapeza anthu makumi asanu olungama mu mzinda wa Sodomu, ndidzasiya malo onsewo osawawononga chifukwa cha iwo.” ");
INSERT INTO nya_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ndipo Abrahamu anayankhulanso nati, “Tsono poti ndalimba mtima kuyankhula ndi Ambuye, ngakhale kuti ndine fumbi ndi phulusa chabe, ");
INSERT INTO nya_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","bwanji anthu olungama atacheperapo ndi asanu pa anthu makumi asanu? Kodi mudzawononga mzinda wonse chifukwa cha asanuwo?” Iye anati, “Nditapezamo anthu 45, sindidzawuwononga.” ");
INSERT INTO nya_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Kenakanso anayankhula kwa Iye nati, “Bwanji atangopezekamo anthu 40 okha?” Iye anayankha, “Chifukwa cha anthu 40 amenewa, sindidzatero.” ");
INSERT INTO nya_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ndipo Abrahamu anati, “Pepanitu musandipsere mtima Ambuye, koma mundilole kuti ndiyankhule. Nanga mutapezekamo anthu makumi atatu okha?” Iye anayankha, “Sindidzatero ngati atapezekamo anthu makumi atatu.” ");
INSERT INTO nya_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abrahamu anati, “Tsono poti ndalimba mtima chonchi kumayankhula ndi Ambuye, bwanji atangopezeka anthu makumi awiri okha?” Iye anati, “Chifukwa cha anthu makumi awiriwo, sindidzawuwononga.” ");
INSERT INTO nya_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Kenaka Abrahamu anati, “Pepani Ambuye musandipsere mtima, ndingoyankhula kamodzi kokhaka basi. Bwanji atangopezeka khumi okha mʼmenemo?” Iye anayankha nati, “Chifukwa cha khumiwo, sindidzawuwononga.” ");
INSERT INTO nya_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Yehova atatsiriza kuyankhula ndi Abrahamu, anachoka ndipo Abrahamu anabwerera ku nyumba yake. ");
INSERT INTO nya_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Angelo awiri aja anafika ku Sodomu madzulo ndipo Loti anali atakhala pansi pa chipata cha mzindawo. Loti atawaona, anayimirira ndi kukakumana nawo ndipo anaweramitsa mutu wake pansi mwaulemu. ");
INSERT INTO nya_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Iye anati, “Ambuye wanga, chonde patukirani ku nyumba kwa mtumiki wanu. Mukhoza kusambitsa mapazi anu ndi kugona usiku uno kenaka nʼkumapitirira ndi ulendo wanu mmamawa.” Iwo anati, “Ayi, tigona panja.” ");
INSERT INTO nya_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Koma iye anawawumiriza kwambiri kotero kuti anapita naye pamodzi ku nyumba kwake. Anawakonzera chakudya buledi wopanda yisiti ndipo anadya. ");
INSERT INTO nya_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Alendo aja asanapite kogona, amuna onse achinyamata ndi achikulire ochokera mbali zonse za mzinda wa Sodomu anazinga nyumba ya Loti. ");
INSERT INTO nya_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Iwo anayitana Loti namufunsa kuti, “Ali kuti amuna aja amene afika kuno usiku womwe uno? Atulutse, utipatse kuti tigone nawo malo amodzi.” ");
INSERT INTO nya_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Loti anatuluka panja kukakumana nawo natseka chitseko ");
INSERT INTO nya_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ndipo anati, “Ayi anzanga, musachite zinthu zoyipa zotere. ");
INSERT INTO nya_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Taonani, ine ndili ndi ana anga akazi awiri amene sanagonepo ndi mwamuna. Mundilole ndikutulutsireni amenewo ndipo muchite nawo zimene mungafune. Koma musachite chilichonse ndi anthuwa, pakuti iwowa ndi alendo anga ndipo ndiyenera kuwatchinjiriza.” ");
INSERT INTO nya_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Iwo anayankha kuti, “Tachoka apa tidutse.” Ndipo anati, “Munthu uyu anabwera kuno ngati mlendo chabe, tsono lero akufuna kuti akhale wotiweruza! Tikukhawulitsa kuposa iwowa.” Anapitiriza kumuwumiriza Loti uja nʼkumasunthira kutsogolo kuti athyole chitseko. ");
INSERT INTO nya_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Koma anthu aja anali mʼkatiwa anasuzumira namukokera Loti uja mʼkati mwa nyumba nʼkutseka chitseko. ");
INSERT INTO nya_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Kenaka anawachititsa khungu anthu amene anali panja pa nyumba aja, aangʼono ndi aakulu omwe, kuti asaone pa khomo. ");
INSERT INTO nya_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Anthu awiri aja anati kwa Loti, “Kodi uli ndi wina aliyense pano, kaya ndi akamwini ako, kaya ndi ana ako aamuna kapena aakazi, kapena aliyense mu mzindamu amene ndi anzako? Atulutse onse muno, ");
INSERT INTO nya_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","chifukwa tiwononga malo ano. Yehova waona kuti kuyipa kwa anthu a mu mzindawu kwakulitsa. Choncho watituma kuti tiwuwononge.” ");
INSERT INTO nya_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Choncho Loti anatuluka nayankhula ndi akamwini ake amene anali kuyembekezera kukwatira ana ake akazi nati, “Fulumirani, tiyeni tichoke pa malo ano chifukwa Yehova watsala pangʼono kuwononga mzindawu.” Koma akamwini akewo ankayesa kuti akungoselewula. ");
INSERT INTO nya_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Mmene kumacha, angelo aja anamufulumizitsa Loti nati, “Nyamuka, tenga mkazi wako ndi ana ako aakazi awiriwo, ndipo mutuluke mu mzindawo kuopa kuti mungaphedwe pamodzi nawo.” ");
INSERT INTO nya_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Koma Loti ankakayikabe. Koma Yehova anawachitira chifundo motero kuti anthu aja anagwira mkazi wake ndi ana ake aakazi aja nawatsogolera bwinobwino kuwatulutsa mu mzindawo. ");
INSERT INTO nya_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Atangowatulutsa, mmodzi wa angelowo anati, “Thawani kuti mudzipulumutse, musachewuke, musayime pena paliponse mʼchigwamo! Thawirani ku mapiri kuopa kuti mungawonongeke!” ");
INSERT INTO nya_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Koma Loti anawawuza kuti, “Ayi, ambuye anga chonde musatero! ");
INSERT INTO nya_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Taonani, Inu mwachitira mtumiki wanu chifundo, ndipo mwaonetsa kukoma mtima kwanu pondipulumutsa. Sindingathawire ku mapiri chifukwa chiwonongekochi chikhoza kundipeza ndisanafike ku mapiriko ndipo ndingafe. ");
INSERT INTO nya_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Koma, chapafupi pomwepa pali mudzi woti ndikhoza kuthamanga nʼkukafikako. Mundilole ndithawireko, ndi waungʼono kwambiri, si choncho? Mukatero, moyo wanga upulumuka.” ");
INSERT INTO nya_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Mngeloyo anati kwa iye, “Chabwino, ndavomeranso pempho lako, sindiwononga mudzi ukunenawo. ");
INSERT INTO nya_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Koma uthawireko mofulumira chifukwa sindichita kena kalikonse mpaka utafikako.” (Nʼchifukwa chake mudziwo unatchedwa Zowari). ");
INSERT INTO nya_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Pamene Loti amafika ku Zowari, nʼkuti dzuwa litatuluka. ");
INSERT INTO nya_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ndiye Yehova anathira sulufule wamoto wochokera kumwamba kwa Yehova pa Sodomu ndi Gomora. ");
INSERT INTO nya_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Kotero, anawononga mizindayo, chigwa chonse pamodzi ndi onse okhala mʼmizindayo. Anawononganso zomera zonse za mʼdzikolo. ");
INSERT INTO nya_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Koma mkazi wa Loti anachewuka ndipo anasanduka mwala wa mchere. ");
INSERT INTO nya_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Mmawa mwake, Abrahamu ananyamuka nabwerera kumalo kumene anakumana ndi Yehova kuja. ");
INSERT INTO nya_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Anayangʼana kumunsi ku Sodomu, Gomora ndi ku dziko lonse la ku chigwa, ndipo anaona chiwutsi chikufuka mʼdzikolo ngati chikuchokera mʼngʼanjo. ");
INSERT INTO nya_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Choncho Mulungu anawononga mizinda ya ku chigwa, koma anakumbukira pemphero la Abrahamu natulutsa Loti ku sulufule ndi moto zimene zinawononga mizinda ya kumene Loti amakhalako. ");
INSERT INTO nya_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Loti ndi ana ake awiri aakazi anachoka ku Zowari nakakhala ku mapiri, chifukwa amachita mantha kukhala ku Zowari. Iye ndi ana ake awiri ankakhala mʼphanga. ");
INSERT INTO nya_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Tsiku lina mwana wake wamkazi wamkulu anawuza mngʼono wake kuti, “Abambo athu ndi wokalamba ndipo palibe mwamuna aliyense pano woti atikwatire ndi kubereka ana monga mwa chikhalidwe cha pa dziko lonse lapansi. ");
INSERT INTO nya_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Tiye tiwamwetse vinyo ndipo tigone nawo. Tikatero mtundu wathu udzakhalapobe.” ");
INSERT INTO nya_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Usiku umenewo analedzeretsa vinyo abambo awo, ndipo wamkuluyo analowa nagona naye. Abambo awo samadziwa kanthu pamene mwanayo anagona naye kapena pamene anadzuka. ");
INSERT INTO nya_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Tsiku linali mwana wamkazi wamkulu uja anati kwa mngʼono wake, “Usiku wathawu ine ndinagona ndi abambo anga. Tiye tiwaledzeretsenso vinyo usiku uno ndipo iwe upite ndi kugona nawo ndipo mtundu wathu udzakhalapobe.” ");
INSERT INTO nya_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Choncho analedzeranso vinyo abambo awo usiku umenewonso, ndipo mwana wamkazi wamngʼono anapita nagona nawo. Abambo awo sanadziwenso kanthu pamene mwanayo anagona naye kapena pamene anadzuka. ");
INSERT INTO nya_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Choncho ana onse awiri a Loti aja anatenga pathupi pa abambo awo. ");
INSERT INTO nya_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Mwana wamkazi wamkulu uja anabereka mwana wa mwamuna ndipo anamutcha Mowabu. Iyeyo ndiye kholo la Amowabu onse. ");
INSERT INTO nya_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Mwana wamkazi wamngʼono naye anabereka mwana wamwamuna, ndipo anamutcha iye Beni-Ammi. Iyeyu ndiye kholo la Aamoni onse. ");
INSERT INTO nya_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrahamu anachokako kumeneko napita ku Negevi ndipo anakakhala ku dziko la Gerari, limene lili pakati pa mzinda wa Kadesi ndi mzinda wa Suri. Anakhala ku Gerari kwa kanthawi, ");
INSERT INTO nya_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ndipo Abrahamu ankawawuza za Sara kuti, “Iyeyu ndi mlongo wanga.” Choncho Abimeleki, mfumu wa ku Gerari anamutenga Sara uja. ");
INSERT INTO nya_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Koma usiku, Mulungu anafika kwa Abimeleki kutulo nati, “Ufatu iwe chifukwa cha mkazi amene watengayu popeza ndi wokwatiwa.” ");
INSERT INTO nya_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Nthawi imeneyi nʼkuti Abimeleki asanamukhudze mkaziyo, kotero kuti anati, “Ambuye, kodi mudzawonongadi mtundu wolungama? ");
INSERT INTO nya_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Kodi Abrahamu sanandiwuze kuti iyeyu ndi mlongo wake? Ndiponso mkaziyu ankanena kuti Abrahamu ndi mlongo wake. Choncho ine pochita izi, ndinkachita moona mtima ndiponso mopanda chinyengo.” ");
INSERT INTO nya_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Tsono kumaloto komweko Mulungu anati kwa iye, “Inde ndikudziwa kuti wachita izi moona mtima, ndipo Ine sindinafune kuti undichimwire. Nʼchifukwa chake sindinakulole kuti umukhudze. ");
INSERT INTO nya_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Tsopano kabwezere mkaziyo kwa mwamuna wake. Iyeyu ndi mneneri, ndipo adzakupempherera kuti ukhale ndi moyo. Koma ukapanda kukamupereka, udziwiretu kuti udzafa pamodzi ndi onse a pa banja pako.” ");
INSERT INTO nya_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Mmamawa mwake Abimeleki anayitanitsa akuluakulu ake onse, ndipo atawafotokozera zimene zinachitika, iwo aja anachita mantha kwambiri. ");
INSERT INTO nya_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Kenaka Abimeleki anayitana Abrahamu ndipo anati, “Kodi wachita chiyani? Ndakulakwira chiyani kuti undibweretsere ine pamodzi ndi anthu anga chilango chachikulu chotere? Wandichitira zinthu zimene sizinayenera kuchitika.” ");
INSERT INTO nya_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ndipo Abrahamu anafunsa Abimeleki kuti, “Chifukwa chiyani wachita zimenezi?” ");
INSERT INTO nya_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abrahamu anayankha nati, “Ndinkaganiza kuti kuno kulibiretu munthu woopa Mulungu. Ndiye ndimati mwina adzandipha chifukwa cha mkazi wanga. ");
INSERT INTO nya_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Komabe kunena zoona, iyeyu ndi mlongo wangadi, mwana wamkazi wa abambo anga ngakhale kuti si ife a mayi mmodzi. Tsono akhoza kukhala mkazi wanga. ");
INSERT INTO nya_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ndiye pamene Mulungu anati ndichoke ku nyumba ya abambo anga, ndinawuza mkazi wangayu kuti, ‘Kuti uwonetse kuti ndiwe mkazi wokoma mtima, uziwuza anthu kulikonse kumene tingapite kuti ndine mlongo wako.’ ” ");
INSERT INTO nya_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Tsono Abimeleki anapereka nkhosa, ngʼombe ndi antchito aamuna ndi aakazi kwa Abrahamu. Ndipo anamubwezeranso Abrahamu Sara, mkazi wake. ");
INSERT INTO nya_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Tsono Abimeleki anati kwa Abrahamu, “Dziko langa ndi limene ukulionali; ukhale paliponse pamene ufuna.” ");
INSERT INTO nya_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ndipo kwa Sara, iye anati, “Ndikumupatsa mlongo wakoyu makilogalamu khumi ndi awiri a siliva kutsimikiza kuti iwe ndi wosalakwa pamaso pa onse amene ali ndi iwe; ulibedi mlandu.” ");
INSERT INTO nya_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Tsono Abrahamu anapemphera kwa Mulungu ndipo Mulunguyo anachiritsa Abimeleki, mkazi wake pamodzi ndi adzakazi ake kuti athenso kubereka ana. ");
INSERT INTO nya_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Paja Yehova nʼkuti atatseka akazi onse a mʼbanja la Abimeleki kuti asabereke ana chifukwa cha Sara, mkazi wa Abrahamu. ");
INSERT INTO nya_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yehova anakomera mtima Sara monga ananenera, ndipo Yehovayo anachita monga momwe analonjezera. ");
INSERT INTO nya_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara anakhala ndi pathupi ndipo anamuberekera Abrahamu mwana wamwamuna mu ukalamba wake, pa nyengo imene Mulungu anamulonjeza. ");
INSERT INTO nya_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abrahamu anapereka dzina loti Isake kwa mwana wamwamuna amene Sara anamuberekera. ");
INSERT INTO nya_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Isake atakwanitsa masiku asanu ndi atatu, Abrahamu anamuchita mdulidwe monga Mulungu anamulamulira. ");
INSERT INTO nya_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abrahamu anali ndi 100 pamene mwana wake Isake anabadwa. ");
INSERT INTO nya_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara anati, “Mulungu wandibweretsera mseko, ndipo aliyense amene adzamva zimenezi adzaseka nane pamodzi.” ");
INSERT INTO nya_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ndipo anawonjezera kuti, “Ndani akanamuwuza Abrahamu kuti Sara nʼkudzayamwitsako ana? Chonsecho ndamubalira mwana wamwamuna kuwukalamba wake.” ");
INSERT INTO nya_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Mwana uja anakula mpaka kumuletsa kuyamwa. Tsiku lomuletsa Isake kuyamwa, Abrahamu anakonza phwando lalikulu. ");
INSERT INTO nya_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Koma Sara anaona kuti mwana wamwamuna amene Hagara Mwigupto anamuberekera Abrahamu amamuseka, ");
INSERT INTO nya_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ndipo anati kwa Abrahamu, “Muchotse mdzakazi ndi mwana wake wamwamunayu, pakuti mwana wa kapolo sadzagawana chuma ndi mwana wanga Isake.” ");
INSERT INTO nya_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Nkhaniyi inamumvetsa chisoni kwambiri Abrahamu chifukwa imakhudza mwana wake. ");
INSERT INTO nya_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Koma Mulungu anamuwuza Abrahamu kuti, “Usamve chisoni motero ndi mnyamatayu ndi mdzakazi wakoyu. Mvetsera chilichonse chomwe Sara akukuwuza, chifukwa zidzukulu zako zidzachokera mwa Isake. ");
INSERT INTO nya_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Mwana wa mdzakazi wakoyu ndidzamusandutsa mtundu wa anthu chifukwa ndi mwana wako.” ");
INSERT INTO nya_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Mmamawa wake, Abrahamu anatenga chakudya ndi botolo la madzi nazipereka kwa Hagara. Anasenzetsa Hagara nawaperekeza pangʼono ndi mnyamatayo. Hagara ananyamuka nayendayenda mʼchipululu cha Beeriseba. ");
INSERT INTO nya_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Madzi atatha mʼbotolo muja, anamuyika mnyamatayo pansi pa zitsamba. ");
INSERT INTO nya_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Kenaka Hagara anachoka nakakhala pansi cha pakatalipo, pafupifupi mamita makumi asanu ndi anayi, popeza mʼmaganizo mwake amati, “Sindingaonerere mwanayu akufa.” Ndipo anakhala pansi cha poteropo nʼkumalira. ");
INSERT INTO nya_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Mulungu anamva mnyamatayo akulira ndipo mngelo wa Mulungu anayankhula kwa Hagara kuchokera kumwamba nati, “Chavuta nʼchiyani Hagara? Usachite mantha; Mulungu wamva kulira kwa mnyamatayo pamene wagonapo. ");
INSERT INTO nya_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Munyamule mnyamatayo ndipo umugwire dzanja pakuti ndidzamupanga kukhala mtundu waukulu.” ");
INSERT INTO nya_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Kenaka Mulungu anatsekula maso a Hagara ndipo anaona chitsime cha madzi. Choncho anapita nadzaza botolo lija ndi madzi ndi kumupatsa mnyamatayo kuti amwe. ");
INSERT INTO nya_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Mulungu anali ndi mnyamatayo pamene ankakula. Anakhala ku chipululu nakhala katswiri wolasa uta. ");
INSERT INTO nya_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Akukhala ku chipululu cha Parani, mayi ake anamupezera mkazi wochokera ku Igupto. ");
INSERT INTO nya_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Pa nthawiyo, Abimeleki ndi Fikolo wamkulu wankhondo wake anati kwa Abrahamu, “Mulungu ali nawe pa chilichonse umachita. ");
INSERT INTO nya_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Tsopano undilumbirire ine pano pamaso pa Mulungu kuti sudzachita mwa chinyengo ndi ine kapena ana anga kapena zidzukulu zanga. Undionetse ine pamodzi ndi dziko limene ukukhalamo ngati mlendo, kukoma mtima kokhala ngati kumene ndinakuonetsa ine.” ");
INSERT INTO nya_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abrahamu anati, “Ine ndikulumbira.” ");
INSERT INTO nya_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Kenaka Abrahamu anadandaula kwa Abimeleki pa za chitsime chimene antchito a Abimeleki analanda. ");
INSERT INTO nya_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Koma Abimeleki anati, “Ine sindikudziwa amene anachita zimenezi. Iwe sunandiwuze, ndipo ndazimva lero zimenezi.” ");
INSERT INTO nya_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Choncho Abrahamu anabweretsa nkhosa ndi ngʼombe nazipereka kwa Abimeleki, ndipo anthu awiriwo anachita pangano. ");
INSERT INTO nya_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abrahamu anapatulako ana ankhosa aakazi asanu ndi awiri kuchoka pagulu la nkhosa zina, ");
INSERT INTO nya_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ndipo Abimeleki anafunsa Abrahamu, “Kodi tanthauzo lake la ana ankhosa aakazi asanu ndi awiri amene wawapatula pawokhawa nʼchiyani?” ");
INSERT INTO nya_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Iye anayankha kuti, “Landirani ana ankhosa aakazi kuchokera mʼdzanja langa ngati umboni kuti ndinakumba chitsime ichi.” ");
INSERT INTO nya_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Kotero malo amenewo anatchedwa Beeriseba, chifukwa anthu awiriwo analumbirirapo malumbiro. ");
INSERT INTO nya_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Atatha kuchita pangano pa Beeriseba, Abimeleki ndi Fikolo mkulu wankhondo wake anabwerera ku dziko la Afilisti. ");
INSERT INTO nya_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abrahamu anadzala mtengo wa bwemba ku Beeriseba, ndipo anapemphera pamenepo mʼdzina la Yehova, Mulungu Wamuyaya. ");
INSERT INTO nya_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ndipo Abrahamu anakhala mʼdziko la Afilisti kwa nthawi yayitali. ");
INSERT INTO nya_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Nthawi ina zitatha izi, Mulungu anamuyesa Abrahamu. Iye anati, “Abrahamu!” Ndipo iye anayankha kuti, “Ee Ambuye.” ");
INSERT INTO nya_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ndipo Mulungu anati, “Tenga Isake, mwana wako yekhayo amene umamukonda ndi kupita naye ku dziko la Moriya. Ukamupereke iye ngati nsembe yopsereza pa limodzi la mapiri a kumeneko limene ndidzakuwuza.” ");
INSERT INTO nya_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abrahamu anadzuka mmamawa wake namangirira chokhalira pa bulu. Atadula nkhuni zokwanira zowotchera nsembe yopsereza, Abrahamu, antchito ake awiri pamodzi ndi Isake ananyamuka kupita kumalo kumene Mulungu anamuwuza Abrahamu. ");
INSERT INTO nya_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Pa tsiku lachitatu, Abrahamu anakweza maso ake ndipo anaona malowo chapatali. ");
INSERT INTO nya_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ndipo Abrahamu anati kwa antchito ake aja, “Bakhalani pano ndi buluyu. Ine ndi mnyamatayu tipita uko kukapemphera, koma tibweranso.” ");
INSERT INTO nya_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abrahamu anatenga nkhuni za nsembe yopsereza zija namusenzetsa mwana wake Isake, ndipo iye mwini anatenga moto ndi mpeni. Pamene awiriwo amayendera pamodzi, ");
INSERT INTO nya_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isake anati kwa abambo ake Abrahamu, “Abambo?” Abrahamu anayankha, “Ee mwana wanga.” Isake anafunsa, “Moto ndi nkhuni zilipo, koma nanga mwana wankhosa wa nsembe yopsereza ali kuti?” ");
INSERT INTO nya_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abrahamu anayankha, “Mwana wanga, Mulungu adzipezera yekha mwana wankhosa wa nsembe yopsereza.” Ndipo awiriwo anapitiriza ulendo. ");
INSERT INTO nya_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Atafika pamalo pamene Mulungu anamuwuza paja, Abrahamu anamangapo guwa lansembe nayika nkhuni pamwamba pa guwapo. Kenaka anamumanga mwana wake Isake namugoneka paguwapo, pamwamba pa nkhuni paja. ");
INSERT INTO nya_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Kenaka Abrahamu anatambasula dzanja lake natenga mpeni kuti aphe mwana wake. ");
INSERT INTO nya_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Koma mngelo wa Yehova anayitana Abrahamu kuchokera kumwamba nati, “Abrahamu! Abrahamu!” Iye anayankha kuti, “Ee Ambuye.” ");
INSERT INTO nya_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Mngeloyo anati, “Usatambasulire mwanayo dzanja lako kuti umuphe, pakuti tsopano ndadziwa kuti iwe umaopa Mulungu. Iwe sunandimane mwana wako mmodzi yekhayo.” ");
INSERT INTO nya_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abrahamu anatukula maso ake ndipo anaona nkhosa yamphongo itakoledwa ndi nyanga zake mu ziyangoyango. Iye anapita nakatenga nkhosa ija ndikuyipha ngati nsembe yopsereza mʼmalo mwa mwana wake. ");
INSERT INTO nya_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Choncho Abrahamu anatcha malo amenewa kuti Yehova-Yire (Wopereka). Ndipo mpaka lero amatchula malowo kuti ndi “Pa phiri la Yehova wopereka.” ");
INSERT INTO nya_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Mngelo wa Yehova anayitana Abrahamu kuchokera kumwamba kachiwiri ");
INSERT INTO nya_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ndipo anati, “Ndikulumbira mwa Ine ndekha kuti popeza wachita zimenezi, wosandikaniza mwana wako mmodzi yekhayu, ");
INSERT INTO nya_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ndidzakudalitsa ndithu ndipo ndidzakupatsa zidzukulu zochuluka ngati nyenyezi zamlengalenga komanso ngati mchenga wa mʼmphepete mwa nyanja. Zidzukulu zako zidzalanda mizinda ya adani awo, ");
INSERT INTO nya_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ndipo kudzera mwa chidzukulu chako, mitundu yonse ya anthu pa dziko lapansi idzadalitsika, chifukwa iwe wandimvera.” ");
INSERT INTO nya_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Kenaka Abrahamu anabwerera kumene anasiya antchito ake kuja nanyamukira nawo pamodzi kupita ku Beeriseba. Ndipo Abrahamu anakhala ku Beeriseba. ");
INSERT INTO nya_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Patapita nthawi, Abrahamu anamva kuti, “Milika nayenso anaberekera Nahori, mʼbale wake ana. ");
INSERT INTO nya_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Woyamba anali Huzi ndipo kenaka mʼbale wake Buzi. Anaberekanso Kemueli, amene anali abambo ake a Aramu. ");
INSERT INTO nya_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Ana ena ndi Kesede Hazo, Pilidasi, Yidilafi ndi Betueli.” ");
INSERT INTO nya_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betueli anabereka Rebeka. Milika anaberekera Nahori, mʼbale wake wa Abrahamu, ana aamuna asanu ndi atatu amenewa. ");
INSERT INTO nya_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Mkazi wake wachiwiri, dzina lake Reuma, anamubaliranso Nahori ana awa: Teba, Gahamu, Tahasi ndi Maaka. ");
INSERT INTO nya_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara anakhala ndi moyo zaka 127. ");
INSERT INTO nya_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Anamwalirira ku Kiriyati-Araba, kumeneku ndi ku Hebroni, mʼdziko la Kanaani, ndipo Abrahamu anapita kukakhuza maliro a Sara, namulirira. ");
INSERT INTO nya_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Kenaka Abrahamu ananyamuka pamene panali mtembo wa mkazi wakepo kupita kukayankhula ndi anthu a ku Hiti. Ndipo anati, ");
INSERT INTO nya_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ine ndine mlendo wongoyendayenda kwanu kuno. Bwanji mundigulitse malo woti akhale manda kuti ndiyikepo thupi la mkazi wanga.” ");
INSERT INTO nya_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Anthu a ku Hiti aja anamuyankha Abrahamu kuti, ");
INSERT INTO nya_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Tatimverani mbuye wathu, inu ndinu mwana wa mfumu wamkulu pakati pathu. Chonde ikani thupi la mkazi wanu mʼmanda aliwonse amene mungafune. Palibe mmodzi wa ife amene adzakukanizani manda ake kuti musayike mkazi wanu.” ");
INSERT INTO nya_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Tsono Abrahamu anayimirira naweramira anthu a dziko la Hiti aja ");
INSERT INTO nya_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","nati, “Ngati mwaloladi kuti ndiyike mkazi wanga kuno, ndiye ndimvereni. Mundipemphere kwa Efroni mwana wa Zohari ");
INSERT INTO nya_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","kuti andigulitse phanga la Makipela, limene lili kumapeto kwa munda wake. Mumupemphe kuti andigulitse pamtengo wake ndithu inu mukuona kuti akhale manda.” ");
INSERT INTO nya_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Pamenepo nʼkuti Efroni Mhiti ali pomwepo pakati pa anthuwo amene anabwera ku chipata cha mzindawo. Ndipo onse akumva anamuyankha Abrahamu ");
INSERT INTO nya_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","nati, “Ayi mbuye wanga tandimverani, ine ndikukupatsani mundawo ndiponso phanga limene lili mʼmenemo. Ndikukupatsani malowa pamaso pa anthu a mtundu wanga. Chonde ikani mtembo wamkazi wanu.” ");
INSERT INTO nya_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Apo Abrahamu anaweramanso mwaulemu pamaso pa anthu a mʼdzikolo ");
INSERT INTO nya_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ndipo anthu onse akumva Abrahamu anati kwa Efroni, “Ngati kungatheke, chonde ndimvereni. Ine ndichita kugula mundawu. Landirani ndalama za mundawu kuti ine ndiyike mkazi wanga mʼmenemo.” ");
INSERT INTO nya_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Koma Efroni anamuyankha Abrahamu nati, ");
INSERT INTO nya_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Mundimvere mbuye wanga; mundawo mtengo wake ndi masekeli asiliva okwana 400. Koma zimenezo nʼchiyani pakati pa ine ndi inu? Ikani mtembo wa mkazi wanu.” ");
INSERT INTO nya_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abrahamu anavomera mtengo umene ananena Efroni Ahiti onse akumva ndipo anamuwerengera masekeli asiliva okwana 400 monga mwa mtengo wa ndalama umene amalonda a nthawi imeneyo ankagwiritsa ntchito. ");
INSERT INTO nya_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Choncho munda wa Efroni wa ku Makipela umene unali kufupi ndi Mamre, kuphatikiza munda, phanga linali mʼmenemo pamodzi ndi mitengo yonse ya mʼmundamo, zinaperekedwa ");
INSERT INTO nya_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","kwa Abrahamu ngati chuma chake pamaso pa anthu onse a ku Hiti amene anabwera ku chipata cha mzindawo. ");
INSERT INTO nya_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Zitatha izi, Abrahamu anayika mkazi wake Sara mʼphanga la mʼmunda wa ku Makipela, kufupi ndi ku Mamre (kumene ndi ku Hebroni) mʼdziko la Kanaani. ");
INSERT INTO nya_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Choncho Ahiti anapereka munda pamodzi ndi phanga la mʼmenemo kwa Abrahamu kuti akhale manda. ");
INSERT INTO nya_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Tsopano Abrahamu anali atakalamba kwambiri, ndipo Yehova anamudalitsa mu zonse anachita. ");
INSERT INTO nya_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Tsiku lina Abrahamu anawuza wantchito wake wamkulu amene ankayangʼanira zonse anali nazo, kuti “Ika dzanja lako pansi pa ntchafu yanga. ");
INSERT INTO nya_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ndikufuna kuti ulumbire pamaso pa Yehova, Mulungu wakumwamba ndi dziko lapansi, kuti sudzamupezera mwana wanga mkazi pakati pa atsikana Achikanaani a kuno kumene ndikukhala, ");
INSERT INTO nya_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","koma kuti udzapita ku dziko la kwathu ndi kukamupezera mkazi mwana wanga Isake pakati pa abale anga.” ");
INSERT INTO nya_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Wantchito uja anafunsa kuti, “Nanga atakhala kuti mkaziyo sakufuna kubwera nane kuno? Kodi ine ndingadzatenge mwana wanu ndi kubwerera naye ku dziko kumene munachokera?” ");
INSERT INTO nya_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abrahamu anati, “Uwonetsetse kuti usadzabwerere naye mwana wanga kumeneko. ");
INSERT INTO nya_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yehova Mulungu wakumwamba amene ananditenga kwa makolo anga nanditulutsa mʼdziko lobadwira, ameneyo anayankhula nane molumbira kuti, ‘Kwa zidzukulu zako ndidzapereka dziko ili.’ Iyeyu adzatumiza mngelo wake kuti akutsogolere kumeneko kukapezera mwana wanga mkazi. ");
INSERT INTO nya_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ngati mkaziyo adzakana kubwerera nawe ndiye kuti udzakhala womasuka ku lumbiro langa. Koma usadzamutenge mwana wanga ndi kubwerera naye kumeneko.” ");
INSERT INTO nya_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Choncho wantchitoyo anayika dzanja lake pansi pa ntchafu ya mbuye wake Abrahamu nalumbira kwa iye kuti adzachitadi monga mwa mawu a Abrahamu. ");
INSERT INTO nya_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Tsono wantchito uja anatengapo ngamira khumi mwa ngamira za mbuye wake pamodzi ndi zinthu zabwino za mitundumitundu. Ndipo ananyamuka kupita ku mzinda wa Nahori, mʼdziko la Mesopotamiya. ");
INSERT INTO nya_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Atafika, anagwaditsa pansi ngamira zija pafupi ndi chitsime chimene chinali kunja kwa mzinda uja. Awa anali madzulo ndithu, nthawi imene amayi amapita kukatunga madzi. ");
INSERT INTO nya_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ndipo wantchito uja anapemphera nati, “Haa, Yehova, Mulungu wa mbuye wanga Abrahamu, mulole kuti zinthu zindiyendere ine lero, ndipo muonetseni mbuye wanga Abrahamu kukoma mtima kwanu kosasinthika. ");
INSERT INTO nya_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Taonani ndayima pambali pa chitsimechi, ndipo atsikana a mu mzindawu akubwera kudzatunga madzi. ");
INSERT INTO nya_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ine ndipempha mtsikana wina kuti, ‘Chonde tula mtsuko wako kuti ndimweko madzi.’ Tsono iye akayankha kuti ‘Imwani,’ ndipo ndidzapatsanso ngamira zanu madziwo, ameneyo akhale mkazi amene mwasankhira mtumiki wanu Isake.” Zimenezi zikachitika, ndidzadziwa kuti mwaonetsadi kukoma mtima kwanu kosasinthika kwa mbuye wanga. ");
INSERT INTO nya_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Asanatsirize kupemphera, anangoona Rebeka watulukira atasenza mtsuko wake pa phewa. Iyeyu anali mwana wa Betueli mwana wa Milika, mkazi wa Nahori mʼbale wake wa Abrahamu. ");
INSERT INTO nya_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Mtsikanayo anali wokongola kwambiri, namwali amene sanadziwe mwamuna. Iye anatsikira ku chitsime nadzaza mtsuko nakweranso ku mtunda. ");
INSERT INTO nya_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Wantchito uja anathamanga kukakumana naye nati, “Chonde patseko madzi pangʼono a mu mtsuko wakowo kuti ndimwe.” ");
INSERT INTO nya_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Mtsikanayo anati, “Imwani mbuye wanga.” Ndipo mofulumira anatsitsa mtsuko uja nawuyika mʼmanja ndi kumupatsa kuti amwe. ");
INSERT INTO nya_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Atatha kupereka madzi akumwa kwa mlendo uja, mtsikanayo anati, “Ndikatungiranso ngamira madzi kuti zimwe mpaka zitakwana.” ");
INSERT INTO nya_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Choncho anafulumira kukhuthula madzi a mu mtsuko aja momwera ziweto, nathamanga kubwerera ku chitsime kukatunga madzi ena, ndipo anatunga okwanira ngamira zake zonse. ");
INSERT INTO nya_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Modekha, munthu uja anayangʼanitsitsa kwambiri mtsikana uja kuti adziwedi ngati Yehova anamutsogolera pa ulendo wake uja kapena ayi. ");
INSERT INTO nya_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ngamira zija zitatha kumwa, mlendo uja anatulutsa chipini chagolide cholemera theka la sekeli ndi zibangiri zagolide ziwiri zolemera masekeli 100. ");
INSERT INTO nya_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Kenaka anafunsa namwaliyo kuti, “Chonde tandiwuza, kodi ndiwe mwana wa yani? Ndipo kodi malo alipo kwanu woti ife nʼkugona?” ");
INSERT INTO nya_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Anamuyankha kuti, “Ine ndine mwana wa Betueli, mwana amene Milika anaberekera Nahori.” ");
INSERT INTO nya_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ndipo anapitiriza kunena kuti, “Chakudya chodyetsa nyamazi chilipo kwathu ndipo malo woti mugone aliponso.” ");
INSERT INTO nya_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Kenaka munthuyo anawerama pansi napembedza Yehova, ");
INSERT INTO nya_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","nati, “Alemekezeke Yehova, Mulungu wa mbuye wanga Abrahamu, amene waonetsa kukoma mtima kwake kosasintha ndi kukhulupirika kwake kwa mbuye wanga. Yehova wanditsogolera pa ulendo wanga mpaka ndafika ku nyumba kwa abale ake a mbuye wanga.” ");
INSERT INTO nya_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Mtsikana uja anathamanga nakafotokozera zimenezi anthu a kwa amayi ake. ");
INSERT INTO nya_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Tsono Rebeka anali ndi mlongo wake dzina lake Labani. ");
INSERT INTO nya_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Iyeyu atangoona chipini pa mphuno ndi zibangiri pa mikono ya mlongo wake komanso kumva zimene mlendo uja ananena kwa Rebekayo, anathamangira kwa mlendo uja, ndipo anamupeza atangoyima ndi ngamira zake pafupi ndi chitsime. ");
INSERT INTO nya_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Iye anati, “Tiyeni kwathu, ndinu munthu amene Yehova wamudalitsa. Bwanji mwangoyimirira panja pano? Ine ndakukonzerani malo ogona inu ndi ngamira zanu.” ");
INSERT INTO nya_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Choncho munthu uja analowa mʼnyumba. Labani anatsitsa katundu anali pa ngamira uja. Kenaka anazipatsa ngamira zija chakudya, ndiponso anapereka madzi wosamba mapazi kwa mlendo uja ndi anthu ena onse. ");
INSERT INTO nya_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Chakudya chitabwera mlendo uja anati, “Sindidya mpaka nditakuwuzani zimene ndadzera kuno.” Labani anati, “Yankhulani.” ");
INSERT INTO nya_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Motero iye anati, “Ine ndine wantchito wa Abrahamu. ");
INSERT INTO nya_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yehova wadalitsa mbuye wanga kwambiri, ndiponso walemera. Wamupatsa nkhosa ndi ngʼombe, siliva ndi golide, antchito aamuna ndi antchito aakazi, komanso ngamira ndi abulu. ");
INSERT INTO nya_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara, mkazi wa mbuye wanga anamubalira iye mwana wamwamuna ngakhale kuti Sarayo anali wokalamba. Tsono mbuye wanga wamupatsa mwanayo chuma chonse. ");
INSERT INTO nya_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Tsono mbuye wanga anandilumbiritsa kuti ndisunge mawu ake akuti, ‘Usadzamupezere mwana wanga mkazi kuchokera mwa atsikana a dziko lino la Kanaani, ");
INSERT INTO nya_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","koma upite ku banja la abambo anga ndi kwa abale anga kuti ukamupezere mkazi mwana wanga.’ ” ");
INSERT INTO nya_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Ndipo ine ndinati kwa mbuye wanga, ‘Nanga mkaziyo akakapanda kubwera nane pamodzi?’ ");
INSERT INTO nya_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Iye anayankha, ‘Yehova amene ndakhala ndikumumvera nthawi zonse, adzatumiza mngelo wake kuti akuperekeze ndipo adzakuthandiza mpaka ukamupezere mwana wanga mkazi kuchokera ku mtundu wanga, wa fuko langa. ");
INSERT INTO nya_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ukadzachita zimenezi udzakhala mfulu wosamangidwa ndi lumbiro langali. Koma tsono ukadzafika kwa fuko langa, ndipo ngati sadzalola kukupatsa mbeta ya mwana wanga, aponso udzamasuka ku lumbiro langali.’ ” ");
INSERT INTO nya_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Tsono lero lino pamene ndafika pa chitsime, ndinapempha kuti, ‘Yehova, Mulungu wa mbuye wanga, Abrahamu, ngati Inu mwandidalitsadi pa ulendowu, ");
INSERT INTO nya_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","taonani ndayima pambali pa chitsime ichi; ndipo ndidzati kwa namwali amene atabwere kudzatunga kuti, chonde nditamwako madzi a mu mtsuko wakowu,’ ");
INSERT INTO nya_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ndipo ngati adzandiyankha kuti, ‘Imwani ndipo ndizimwetsanso madzi ngamira zanuzi,’ ameneyo akhale yemwe Yehova wamusankhira mwana wa mbuye wanga.” ");
INSERT INTO nya_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Ndisanatsirize kupemphera, ndinangoona Rebeka akutulukira mtsuko wake uli pa phewa. Anatsetserekera ku chitsime kukatunga madzi ndipo ndinati kwa iye, ‘Chonde patseko madzi akumwa.’ ");
INSERT INTO nya_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Mofulumira, anatsitsa mtsuko wake pa phewa pake nati, ‘Imwani ndiponso ndizimwetsa madzi ngamira zanuzi.’ Kotero ine ndinamwa ndipo anamwetsanso ngamirazo. ");
INSERT INTO nya_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Ndinamufunsa kuti, ‘Ndiwe mwana wa yani?’ “Iye anati, ‘Ndine mwana wa Betueli mwana wa Nahori, amene Milika anamuberekera.’ “Tsono ndinayika chipini pa mphuno yake ndi kumveka zibangiri mʼmikono yake, ");
INSERT INTO nya_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","kenaka ndinawerama pansi ndi kupembedza Yehova. Ndipo ndinatamanda Yehova, Mulungu wa mbuye wanga Abrahamu, amene anandilondolera mokhulupirika njira yanga. Iye wandifikitsa kwa mʼbale wake kumene ndapezera mbeta mwana wa mbuye wanga. ");
INSERT INTO nya_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Tsono ngati mukufuna kuonetsa kukoma mtima kwanu kwa mbuye wanga, ndikuonetsa kukhulupirika kwanu, ndiwuzeni; ndipo ngati si choncho ndiwuzeninso kuti ndidziwe chochita.” ");
INSERT INTO nya_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Labani ndi Betueli anayankha nati, “Izi ndi zochokera kwa Yehova, ndipo ife sitinganenepo kanthu. ");
INSERT INTO nya_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Nayu Rebeka, mutengeni muzipita naye kuti akakhale mkazi wa mwana wa mbuye wanu, monga Yehova wanenera.” ");
INSERT INTO nya_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Wantchito wa Abrahamu uja atamva zimene anawerama pansi pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Kenaka wantchitoyo anatulutsa ziwiya zagolide ndi zasiliva ndi zovala nazipereka kwa Rebeka. Anaperekanso mphatso zina za mtengowapatali kwa mlongo wake ndi amayi ake a Rebeka. ");
INSERT INTO nya_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Tsono wantchito uja ndi anthu amene anali naye anadya, kumwa nagona komweko. Kutacha mmawa wake, wantchito uja anati, “Mundilole ndibwerere kwa mbuye wanga.” ");
INSERT INTO nya_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Koma mlongo wake ndi amayi ake a Rebeka anayankha kuti, “Muloleni mtsikanayu abakhala nafe masiku khumi kapena kupyolerapo, kenaka mukhoza kupita.” ");
INSERT INTO nya_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Koma iye anawawuza kuti, “Chonde musandichedwetse. Yehova wandithandiza kale pa ulendo wanga. Mundilole ndibwerere kwa mbuye wanga.” ");
INSERT INTO nya_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Koma iwo anati, “Bwanji timuyitane mtsikanayo ndipo timufunse ngati afuna kupita nanu panopa.” ");
INSERT INTO nya_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Choncho iwo anamuyitana Rebeka uja namufunsa kuti, “Kodi ukufuna kupita ndi munthuyu panopa?” Iye anayankha kuti, “Ndipita.” ");
INSERT INTO nya_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kotero anamulola Rebeka pamodzi ndi mlezi wake kuti apite ndi wantchito wa Abrahamu pamodzi ndi anthu amene anali naye. ");
INSERT INTO nya_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ndipo iwo anadalitsa Rebeka ndi kumuwuza kuti, “Iwe ndiwe mlongo wathu, Mulungu akudalitse iwe, ukhale mayi wa anthu miyandamiyanda; ndi kuti zidzukulu zako zidzalanda mizinda ya adani awo.” ");
INSERT INTO nya_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Kenaka Rebeka ndi antchito ake ananyamuka kukakwera ngamira zawo ndipo anapita naye pamodzi munthu uja. Choncho wantchito uja anatenga Rebeka nʼkumapita. ");
INSERT INTO nya_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Pa nthawiyi nʼkuti Isake atafika kuchokera ku chitsime cha Wamoyo Wondipenya (Beeri-lahai-roi), popeza tsopano ankakhala ku Negevi. ");
INSERT INTO nya_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Tsiku lina chakumadzulo, Isake anatuluka kukayendayenda ku munda, ndipo atakweza maso anaona ngamira zikubwera. ");
INSERT INTO nya_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka nayenso anatukula maso naona Isake. Ndipo anatsika pa ngamira yake ");
INSERT INTO nya_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","nafunsa wantchito uja kuti, “Kodi munthu uyo ndi ndani akuyenda mʼmundamo kubwera kudzakumana nafe?” Wantchitoyo anayankha, “Ndiye mbuye wanga.” Choncho Rebeka anatenga nsalu ndi kufunda kumaso. ");
INSERT INTO nya_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Tsono wantchito uja anawuza Isake zonse zimene anazichita. ");
INSERT INTO nya_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isake analowa naye Rebeka mu tenti ya amayi ake Sara, ndipo anakhala mkazi wake. Isake anamukonda kwambiri Rebeka mkazi wake motero kuti zimenezi zinamutonthoza imfa ya amayi ake. ");
INSERT INTO nya_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abrahamu anakwatira mkazi wina dzina lake Ketura. ");
INSERT INTO nya_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Iyeyu anamubalira Zimurani, Yokisani, Medani, Midiyani, Isibaki ndi Suwa. ");
INSERT INTO nya_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokisani anabereka Seba ndi Dedani ndipo zidzukulu za Dedani ndiwo Aasuri, Aletusi, ndi Aleumi. ");
INSERT INTO nya_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ana aamuna a Midiyani anali, Efai, Eferi, Hanoki, Abida ndi Elida. Onsewa anali zidzukulu za Ketura. ");
INSERT INTO nya_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abrahamu anasiyira Isake chilichonse anali nacho. ");
INSERT INTO nya_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Koma pamene anali ndi moyo, Abrahamu anapereka mphatso kwa ana aakazi ake ena onse. Kenaka anawatumiza ku dziko la kummawa kuti akhale kutali ndi mwana wake Isake. ");
INSERT INTO nya_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abrahamu anakhala ndi moyo zaka 175. ");
INSERT INTO nya_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abrahamu anamwalira atakalamba kwambiri ndipo anakakhala ndi anthu a mtundu wake. ");
INSERT INTO nya_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ana ake, Isake ndi Ismaeli anamuyika mʼphanga la Makipela pafupi ndi Mamre, mʼmunda umene kale unali wa Efroni mwana wa Zohari Mhiti, ");
INSERT INTO nya_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","uwu ndi munda umene Abrahamu anagula kwa Ahiti. Kumeneko Abrahamu anakayikidwa pamodzi ndi mkazi wake Sara. ");
INSERT INTO nya_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Atamwalira Abrahamu, Mulungu anadalitsa mwana wake Isake, amene ankakhala pafupi ndi Beeri-lahai-roi (chitsime cha Wamoyo Wondipenya). ");
INSERT INTO nya_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Nazi zidzukulu za Ismaeli, mwana wa Abrahamu amene wantchito wa Sara, Hagara Mwigupto uja, anaberekera Abrahamu. ");
INSERT INTO nya_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Awa ndi mayina a ana a Ismaeli monga mwa mndandanda wa mabadwidwe awo: Nebayoti ndiye anali mwana woyamba wa Ismaeli; kenaka Kedara, Adibeeli, Mibisamu, ");
INSERT INTO nya_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misima, Duma, Masa, ");
INSERT INTO nya_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadadi, Tema, Yeturi, Nafisi ndi Kedema; ");
INSERT INTO nya_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Amenewa ndi ana a Ismaeli ndi mayina awo monga mwa midzi ndi misasa yawo. Anali olamulira mafuko khumi ndi awiri. ");
INSERT INTO nya_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismaeli anakhala ndi moyo zaka 137. Iye anamwalira ndipo anakakhala ndi anthu a mtundu wake. ");
INSERT INTO nya_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Zidzukulu za Ismaeli zinkakhala mʼdera la pakati pa Havila ndi Suri, kummwera kwa Igupto, mukamapita cha ku Asuri. Choncho anakhala kummawa kwa abale awo. ");
INSERT INTO nya_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Iyi ndi mbiri ya Isake mwana wa Abrahamu. Abrahamu anabereka Isake ");
INSERT INTO nya_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ndipo Isake anali ndi zaka makumi anayi pamene anakwatira Rebeka mwana wa Betueli Mwaramu wa ku Padanaramu mlongo wa Labani Mwaramu. ");
INSERT INTO nya_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isake anapempherera mkazi wake kwa Yehova popeza iye anali wosabereka. Yehova anayankha pemphero lake ndipo mkazi wake Rebeka anatenga pathupi. ");
INSERT INTO nya_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Koma pamene anawo amalimbana mʼmimba mwake, iye anati, “Bwanji zikundichitikira zoterezi?” Choncho anapita kukafunsa kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yehova anati kwa iye, “Udzabala mafuko awiri a anthu olimbana, ndipo magulu awiri a anthu ochokera mwa iwe adzasiyana; fuko limodzi lidzakhala la mphamvu kuposa linzake, ndipo wamkulu adzatumikira wamngʼono.” ");
INSERT INTO nya_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Pamene nthawi inakwana yakuti abeleke, Rebeka anaberekadi mapasa. ");
INSERT INTO nya_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Woyamba kubadwa anali wofiira, ndipo thupi lake lonse linali ngati chovala cha ubweya; choncho anamutcha Esau. ");
INSERT INTO nya_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Kenaka mʼbale wake anabadwa atagwira chidendene cha Esau; choncho anamutcha Yakobo. Isake anali ndi zaka 60 pamene Rebeka anabereka mapasawa. ");
INSERT INTO nya_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Anyamatawo anakula ndipo Esau anakhala katswiri wosaka, munthu wamʼthengo, pamene Yakobo anali munthu wofatsa, wokonda kukhala pa nyumba. ");
INSERT INTO nya_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isake ankakonda Esau chifukwa cha nyama za kutchire zomwe ankakonda kudya, koma Rebeka ankakonda Yakobo. ");
INSERT INTO nya_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Tsiku lina pamene Yakobo ankaphika chakudya, Esau anabwera kuchokera kuthengo ali wolefuka ndi njala. ");
INSERT INTO nya_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Iye anati kwa Yakobo, “Tandipatsako phala lofiiralo, ndimwe! Ndalefuka ndi njala.” (Nʼchifukwa chake amatchedwanso Edomu). ");
INSERT INTO nya_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakobo anayankha, “Choyamba undigulitse ukulu wako.” ");
INSERT INTO nya_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau anati, “Chabwino, ine ndatsala pangʼono kufa, ukulu undithandiza chiyani?” ");
INSERT INTO nya_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Koma Yakobo anati, “Lumbira kwa ine choyamba.” Kotero Esau analumbiradi, ndipo anagulitsa ukulu wake kwa Yakobo. ");
INSERT INTO nya_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Choncho Yakobo anamupatsa Esau buledi ndi phala lofiira lija. Iye anadya ndi kumwa, nanyamuka kumapita. Motero Esau anapeputsa ukulu wake wachisamba uja. ");
INSERT INTO nya_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Tsono kunagwa njala ina mʼdzikomo kuwonjezera pa ija ya poyamba ya nthawi ya Abrahamu ndipo Isake anapita kwa Abimeleki mfumu ya Afilisti ku Gerari. ");
INSERT INTO nya_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Yehova anadza kwa Isake nati, “Usapite ku Igupto; koma ukhale mʼdziko limene ndidzakuwuza kuti ukakhalemo. ");
INSERT INTO nya_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Khala mʼdziko lino ndipo ndidzakhala nawe ndi kukudalitsa. Pakuti kwa iwe ndi zidzukulu zako ndidzapereka mayiko onsewa. Choncho ndidzakwaniritsa pangano limene ndinalumbira kwa Abrahamu, abambo ako. ");
INSERT INTO nya_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Zidzukulu zako ndidzazichulukitsa ngati nyenyezi za mu mlengalenga ndi kuzipatsa mayiko onsewa. Ndiponso anthu onse a pa dziko lapansi adzadalitsika kudzera mwa zidzukulu zako, ");
INSERT INTO nya_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","chifukwa Abrahamu anandimvera, nasunga malamulo anga onse.” ");
INSERT INTO nya_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Choncho Isake anakhala ku Gerari. ");
INSERT INTO nya_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Anthu akumaloko atafunsa Isake za mkazi wake, iye anati, “Ndi mlongo wanga ameneyu.” Iye anaopa kunena kuti, “Ndi mkazi wanga ameneyu,” popeza ankaganiza kuti anthu akumeneku akhoza kumupha ndi kukwatira mkazi wake popeza Rebeka anali wokongola. ");
INSERT INTO nya_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isake atakhalako kumeneko nthawi yayitali, Abimeleki mfumu ya Afilisti, anasuzumira pa zenera kuyangʼana kunja, ndipo anaona Isake akugwiragwira Rebeka, mkazi wake. ");
INSERT INTO nya_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Choncho Abimeleki anamuyitanitsa Isake nati, “Uyu ndi mkazi wako ndithu! Nanga bwanji umati, ‘Ndi mlongo wanga’?” Ndipo Isake anamuyankha kuti, “Ine ndimaganiza kuti ndingataye moyo wanga chifukwa cha iyeyu.” ");
INSERT INTO nya_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Tsono Abimeleki anati, “Nʼchiyani chimene watichitira? Mmodzi mwa anthuwa anatsala pangʼono kugona ndi mkazi wako ndipo ukanatisandutsa ife kukhala olakwa.” ");
INSERT INTO nya_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Choncho Abimeleki analamula anthu ake onse nati, “Aliyense amene avutitse munthu uyu pamodzi ndi mkazi wake adzaphedwa ndithu.” ");
INSERT INTO nya_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isake anadzala mbewu mʼmunda, ndipo chaka chomwecho anakolola zinthu zambiri chifukwa Yehova anamudalitsa. ");
INSERT INTO nya_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Isake analemera. Chuma chake chinkachulukirachulukira mpaka anasanduka munthu wolemera kwambiri. ");
INSERT INTO nya_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Anali ndi nkhosa, ngʼombe ndi antchito ambiri mwakuti Afilisti anamuchitira nsanje. ");
INSERT INTO nya_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Nthawi iyi nʼkuti Afilisti atakwirira ndi dothi zitsime zonse zimene antchito abambo ake Abrahamu anakumba mu nthawi ya abambo akewo. ");
INSERT INTO nya_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ndipo Abimeleki anati kwa Isake, “Muchoke pakati pathu chifukwa mwasanduka wamphamvu kuposa ife.” ");
INSERT INTO nya_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Choncho Isake anachokako kumeneko nakakhala ku chigwa cha Gerari kumene anakhazikikako. ");
INSERT INTO nya_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isake anafukulanso zitsime zija zimene zinakumbidwa mu nthawi ya abambo ake Abrahamu. Atamwalira Abrahamu, Afilisti anakwirira zitsimezi. Tsono anazitcha mayina omwewo amene abambo ake anazitcha. ");
INSERT INTO nya_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Antchito a Isake anakumba mʼchigwamo ndipo anapezamo kasupe wa madzi. ");
INSERT INTO nya_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Koma abusa a ku Gerari anakangana ndi abusa a Isake nati, “Madziwa ndi athu.” Motero iye anachitcha chitsimecho Mkangano chifukwa anakangana naye. ");
INSERT INTO nya_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Kenaka iwo anakumba chitsime china, koma anakangananso chifukwa cha chitsimecho. Choncho anachitcha dzina lakuti Chidani. ");
INSERT INTO nya_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Anachokapo pamenepo nakakumba china. Koma apa sanakanganiranenso ndi munthu. Iye anachitcha Kutakasuka, nati, “Tsopano Yehova watipatsa ife malo otakasukirako ndipo tilemera muno.” ");
INSERT INTO nya_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Kenaka Isake anachoka ku malo kuja kupita ku Beeriseba. ");
INSERT INTO nya_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Usiku umenewo Yehova anadza kwa Isake nati, “Ine ndine Mulungu wa abambo ako Abrahamu. Usachite mantha popeza Ine ndili ndi iwe. Ndidzakudalitsa ndipo ndidzakupatsa zidzukulu zambiri chifukwa cha mtumiki wanga Abrahamu.” ");
INSERT INTO nya_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isake anamanga guwa lansembe pamenepo ndipo anapembedza Yehova. Pomwepo anamanga tenti yake, ndipo antchito ake anakumba chitsime. ");
INSERT INTO nya_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimeleki pamodzi ndi Ahuzati mlangizi wake ndi Fikolo mkulu wa ankhondo ake anabwera kwa Isake kuchokera ku Gerari. ");
INSERT INTO nya_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Tsopano Isake anawafunsa kuti, “Bwanji mwabwera kwa ine, popeza munandichitira nkhanza ndi kundithamangitsa?” ");
INSERT INTO nya_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Iwo anayankha, “Tsopano tadziwa kuti Yehova anali ndi iwe; ndiye taganiza kuti inu ndi ife tichite lumbiro. Ife tichite pangano ndi inu ");
INSERT INTO nya_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","kuti inu simudzatichitira zoyipa monga ifenso sitinakuchitireni nkhondo. Ife tinakuchitirani zabwino zokhazokha, ndipo tinakulolani kuti musamuke kuchoka kwathu mu mtendere. Tsopano Yehova wakudalitsani.” ");
INSERT INTO nya_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Tsono Isake anawakonzera phwando, ndipo anadya ndi kumwa. ");
INSERT INTO nya_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Mmawa wake aliyense analumbira pangano kwa mnzake. Tsono Isake anawalola kuti anyamuke ndipo anamusiya mu mtendere. ");
INSERT INTO nya_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Tsiku limenelo, antchito a Isake anabwera namuwuza za chitsime chimene anakumba. Iwo anati, “Tawapeza madzi!” ");
INSERT INTO nya_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Iye chitsimecho anachitcha Pangano. Nʼchifukwa chake mzindawu umatchedwa Beeriseba mpaka lero. ");
INSERT INTO nya_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Pamene Esau anali ndi zaka 40, anakwatira Yuditi mwana wamkazi wa Beeri Mhiti. Anakwatiranso Basemati mwana wa mkazi wa Eloni Mhiti. ");
INSERT INTO nya_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Akazi awiriwa anasandutsa Isake ndi Rebeka kukhala ndi moyo wa madandawulo nthawi zonse. ");
INSERT INTO nya_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isake atakalamba maso ake anachita khungu mwakuti sankatha kuona. Iye anayitana mwana wake wamkulu Esau nati kwa iye, “Mwana wanga.” Iye anayankha, “Ine abambo.” ");
INSERT INTO nya_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isake anati, “Tsopano ine ndakalamba, ndipo sindidziwa tsiku langa lakufa. ");
INSERT INTO nya_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Tsono tenga zida zako, muvi wako ndi uta, pita kuthengo ukandiphere nyama. ");
INSERT INTO nya_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Undikonzere chakudya chabwino monga muja ndimakonderamu ndipo ubwere nacho kwa ine kuti ndidye ndi kuti ndikudalitse ndisanamwalire.” ");
INSERT INTO nya_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Koma Rebeka amamvetsera pamene Isake amayankhula ndi mwana wake Esau. Esau atanyamuka kupita kuthengo kukaphera abambo ake nyama, ");
INSERT INTO nya_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka anati kwa mwana wake Yakobo, “Taona ndamva abambo ako akuwuza mʼbale wako Esau kuti, ");
INSERT INTO nya_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Bweretsere nyama yakutchire ndipo undikonzere chakudya chokoma kuti ndidye; kuti ndikudalitse pamaso pa Yehova ndisanamwalire.’ ");
INSERT INTO nya_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Tsopano mwana wanga, mvetsetsa ndipo uchite zimene ndikuwuze: ");
INSERT INTO nya_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Pita ku khola, ukatenge ana ambuzi abwino awiri, kuti ndikonzere abambo ako chakudya chokoma monga amakondera. ");
INSERT INTO nya_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Kenaka upite nacho chakudyacho kwa abambo ako kuti adye ndi kukudalitsa asanafe.” ");
INSERT INTO nya_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Koma Yakobo anati kwa Rebeka amayi ake, “Komatu mʼbale wanga Esau ndi munthu wa khungu la ubweya zedi, ndipo ine ndine munthu wa khungu losalala. ");
INSERT INTO nya_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Mwina abambo anga adzandikhudza, ndipo ndidzaoneka kuti ndawapusitsa. Tsono ndizadzitengera temberero mʼmalo mwa madalitso.” ");
INSERT INTO nya_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Amayi ake anati kwa iye, “Mwana wanga, temberero limenelo ligwere ine. Iwe ungochita zimene ine ndikukuwuza; pita kanditengere timbuzito.” ");
INSERT INTO nya_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Choncho anapita nakatenga timbuzito ndi kubwera nato kwa amayi ake. Choncho Rebeka anaphika chakudya chokoma monga momwe Isake amakondera. ");
INSERT INTO nya_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Tsono Rebeka anatenga zovala zabwino kwambiri za Esau mwana wake wamkulu zimene zinali mʼnyumba namuveka Yakobo. ");
INSERT INTO nya_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Anamuvekanso manja ake ndi khosi lake ndi zikopa za mwana wambuzi. ");
INSERT INTO nya_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Kenaka, anamupatsa Yakobo chakudya chokoma chija chimene anaphika pamodzi ndi buledi. ");
INSERT INTO nya_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakobo anapita kwa abambo ake ndipo anati, “Abambo anga.” Ndipo anayankha, “Eya, kodi ndiwe mwana wanga uti?” ");
INSERT INTO nya_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakobo anati kwa abambo ake, “Ndine Esau mwana wanu woyamba. Ndachita monga munandiwuzira. Chonde dzukani ndi kukhala tsonga kuti mudyeko nyama ndakukonzeraniyi kuti tsono mundidalitse.” ");
INSERT INTO nya_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isake anafunsa mwana wake, “Wayipeza msanga chotere bwanji mwana wanga?” Iye anayankha, “Yehova Mulungu wanu anandithandiza kuti ndiyipeze.” ");
INSERT INTO nya_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Pamenepo Isake anati kwa Yakobo, “Tabwera pafupi ndikukhudze mwana wanga, kuti ndidziwedi ngati uli mwana wanga Esau kapena ayi.” ");
INSERT INTO nya_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakobo anasendera kufupi ndi abambo ake Isake ndipo anamukhudza nati, “Mawuwa ndi mawu a Yakobo koma mikonoyi ndi mikono ya Esau.” ");
INSERT INTO nya_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Sanamuzindikire, popeza mikono yake inali ndi ubweya ngati ya mʼbale wake Esau; choncho anamudalitsa. ");
INSERT INTO nya_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Isake anafunsa, “Kodi ndiwedi mwana wanga Esau?” Yakobo anayankha, “Inde ndine.” ");
INSERT INTO nya_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ndipo iye anati, “Mwana wanga, patseko nyama yakoyo ndidye kuti ndikudalitse.” Yakobo anabwera ndi nyama ija kwa Isake ndipo anadya. Kenaka anamupatsanso vinyo ndipo anamwa. ");
INSERT INTO nya_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Tsono Isake anati kwa Yakobo, “Bwera kuno mwana wanga undipsompsone.” ");
INSERT INTO nya_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Choncho anapita namupsompsona. Apa Isake anamva fungo la zovala zake, ndipo anamudalitsa nati, “Haa, fungo la mwana wanga lili ngati fungo la munda umene Yehova waudalitsa. ");
INSERT INTO nya_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Mulungu akugwetsere mame akumwamba ndipo minda yako ibale tirigu wambiri ndi vinyo watsopano. ");
INSERT INTO nya_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Mitundu ya anthu ikutumikire iwe ndipo anthu akugwadire iwe. Ukhale wolamula abale ako, ndipo ana aamuna a amayi ako akugwadire. Amene akutemberera iwe atembereredwe ndipo amene adalitsa iwe adalitsike.” ");
INSERT INTO nya_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isake atatsiriza kudalitsa Yakobo, atangochoka pamaso pa abambo akewo, Esau anabwera kuchokera kosaka kuja. ");
INSERT INTO nya_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Nayenso anakonza chakudya chokoma nabwera nacho kwa abambo ake. Ndipo anati kwa iye, “Chonde abambo, dzukani mukhale tsonga kuti mudye nyamayi ndi kuti mundidalitse.” ");
INSERT INTO nya_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Abambo ake, Isake, anamufunsa kuti, “Ndiwe yani?” Iye anayankha, “Ndine mwana wanu woyamba Esau.” ");
INSERT INTO nya_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isake ananjenjemera kwambiri nati, “Nanga ndani uja anakapha nyama kutchire nʼkudzandipatsa? Ine ndadya kale, ndadya nyamayo iwe utangotsala pangʼono kubwera ndipo ndamudalitsa ndipo adzakhaladi wodalitsika.” ");
INSERT INTO nya_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau atamva mawu a abambo ake, analira mokweza ndi mowawidwa mtima nati kwa abambo ake, “Inenso dalitseni abambo anga!” ");
INSERT INTO nya_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Koma iye anati, “Mʼbale wako anabwera mwachinyengo ndipo watenga madalitso ako.” ");
INSERT INTO nya_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau anati, “Kodi nʼchifukwa chake iyeyu dzina lake lili Yakobo eti? Aka nʼkachiwiri kundinyenga: Anatenga ukulu wanga, pano watenga madalitso anga!” Kenaka anafunsa, “Kodi simunandisungireko ena madalitsowo?” ");
INSERT INTO nya_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Koma Isake anamuyankha nati, “Ndamudalitsa iye kuti akhale wokulamulira iwe. Ndaperekanso abale ake onse kuti akhale omutumikira iye, ndipo ndamudalitsa ndi tirigu wambiri, ndi vinyo watsopano. Ndiye ndingakuchitirenso chiyani mwana wanga?” ");
INSERT INTO nya_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau anati kwa abambo ake, “Kodi muli ndi dalitso limodzi lokhali, abambo anga? Inenso mundidalitse chonde abambo anga!” Pomwepo Esau analira mokuwa. ");
INSERT INTO nya_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Tsono Isake abambo ake anamuyankha kuti, “Malo ako okhalapo sadzabala dzinthu, ndipo mvula sidzagwa pa minda yako. ");
INSERT INTO nya_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Udzakhala ndi moyo podalira lupanga ndipo udzatumikira mʼbale wako. Koma idzafika nthawi pamene udzakhala mfulu udzachotsa goli lake mʼkhosi mwako.” ");
INSERT INTO nya_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ndipo Esau anamusungira chiwembu Yakobo chifukwa cha madalitso amene abambo ake anamupatsa. Esau anati kwa iye yekha, “Masiku olira abambo anga ayandikira; pambuyo pake ndidzamupha mʼbale wangayu Yakobo.” ");
INSERT INTO nya_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Pamene Rebeka anamva zimene mwana wake wamkulu Esau ankaganiza, anayitanitsa Yakobo nati kwa iye, “Mʼbale wako Esau akulingalira zakuti akuphe kuti akulipsire. ");
INSERT INTO nya_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Tsopano mwana wanga, chita zimene ndinene: Nyamuka tsopano, uthawire kwa mlongo wanga Labani ku Harani. ");
INSERT INTO nya_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ukakhale naye kwa kanthawi mpaka mkwiyo wa mʼbale wako utatsika. ");
INSERT INTO nya_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Tsono mkwiyo wa mʼbale wakoyo ukadzatsika ndi kuyiwala zonse wamuchitirazi, ndidzatuma munthu kuti adzakutenge. Nanga nditayirenji nonse awiri nthawi imodzi?” ");
INSERT INTO nya_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Tsono Rebeka anati kwa Isake, “Ine sindikukondwera nawo anamwali a Chihiti. Ndipo ngati Yakobo angapeze mbeta kuno mwa anamwali a Chihitiwa, ndiye kuli bwino kungofa.” ");
INSERT INTO nya_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Choncho Isake anayitanitsa Yakobo namudalitsa nʼkumuwuzitsa kuti, “Usakwatire mkazi wa kuno ku Kanaani. ");
INSERT INTO nya_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Panopo upite ku Padanaramu, ku nyumba kwa Betueli abambo a amayi akowa, kumeneko ukakwatire mmodzi mwa ana aakazi a Labani, mlongo wa amayi akowa. ");
INSERT INTO nya_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Mulungu Wamphamvuzonse akudalitse iwe nakupatse ana ambiri mpaka udzasanduke gulu lalikulu la mitundu ya anthu. ");
INSERT INTO nya_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Mulunguyo akudalitse iwe monga mmene anamudalitsira Abrahamu kuti zidzukulu zako zidzalandira dziko limene ukukhalamo ngati mlendo kuti lidzakhale lawo. Ili ndi dziko limene Mulungu anapereka kwa Abrahamu.” ");
INSERT INTO nya_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ndipo Isake anamulola Yakobo kuti anyamuke kupita ku Padanaramu kwa Labani mwana wa Betueli Mwaramu. Labani anali mlongo wa Rebeka, mayi wa Yakobo ndi Esau. ");
INSERT INTO nya_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Tsopano Esau anadziwa kuti Isake anadalitsa Yakobo ndi kumutumiza ku Padanaramu kuti akakwatire kumeneko. Anawuzidwanso kuti, “Usakwatire mkazi wa ku Kanaani.” ");
INSERT INTO nya_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yakobo anamvera abambo ake ndi amayi ake ndi kupita ku Padanaramu. ");
INSERT INTO nya_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ndiye pamenepo Esau anazindikira kuti abambo ake Isake sankakondwera ndi akazi a ku Kanaani; ");
INSERT INTO nya_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","anapita kwa Ismaeli mwana wa Abrahamu nakwatira Mahalati mwana wa Ismaeli, mlongo wake wa Nebayoti. Anatero kuwonjezera akazi amene anali nawo kale. ");
INSERT INTO nya_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakobo ananyamuka pa ulendo kuchoka ku Beeriseba kupita ku Harani. ");
INSERT INTO nya_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Atafika pa malo pena, anayima kuti agonepo chifukwa dzuwa linali litalowa. Anatenga mwala wina pomwepo natsamiritsapo mutu wake, ndipo anagona. ");
INSERT INTO nya_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Mʼmaloto, anaona makwerero oyimikidwa pansi ndipo anakafika kumwamba. Angelo a Mulungu amakwera ndi kutsika pa makwereropo. ");
INSERT INTO nya_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Tsono Yehova anayimirira pambali pake, nati, “Ine ndine Yehova, Mulungu wa Abrahamu kholo lake la Isake abambo ako. Ndidzakupatsa iwe ndi zidzukulu zako dziko limene ukugonamolo. ");
INSERT INTO nya_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Zidzukulu zako zidzachuluka ngati fumbi la pa dziko lapansi ndipo zidzabalalikira kumadzulo ndi kummawa, kumpoto ndi kummwera. Anthu onse adzalandira madalitso kudzera mwa iwe ndi zidzukulu zako. ");
INSERT INTO nya_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ine ndili nawe pamodzi ndipo ndidzakuyangʼanira kulikonse upiteko, ndipo ndidzakubwezera ku dziko lino. Sindidzakusiya mpaka nditachita zimene ndakulonjezazi.” ");
INSERT INTO nya_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakobo atadzidzimuka, anati, “Zoonadi Yehova ali pa malo ano, ndipo ine sindinadziwe.” ");
INSERT INTO nya_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Tsono anachita mantha ndipo anati, “Malo ano ndi woopsa ndithu. Zoonadi pano ndi pa nyumba ya Mulungu ndi khomo la kumwamba.” ");
INSERT INTO nya_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Mmamawa mwake Yakobo anatenga mwala umene anatsamira mutu wake uja nawuyimika ngati chipilala ndi kuthira mafuta pamwamba pake ");
INSERT INTO nya_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Iye anawatcha malowo Beteli, ngakhale kuti poyamba mzindawo ankawutcha Luzi. ");
INSERT INTO nya_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Pamenepo Yakobo analumbira kwa Yehova nati, “Ngati inu Mulungu mukhala ndi ine, kundiyangʼanira pa ulendo wangawu ndi kundipatsa chakudya ndi chovala; ");
INSERT INTO nya_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ngati inu mudzandibweretsa kwathu mu mtendere, ndiye kuti mudzakhala Mulungu wanga, ");
INSERT INTO nya_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ndipo mwala uwu ndawuyimikawu udzakhala Nyumba ya Mulungu. Ine ndidzakupatsani chakhumi cha zinthu zonse zimene mudzandipatse.” ");
INSERT INTO nya_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakobo anapitiriza ulendo wake kupita ku dziko la anthu a kummawa. ");
INSERT INTO nya_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Atafika kumeneko anaona chitsime ku busa ndipo panali magulu atatu a nkhosa zitagona pafupi ndi chitsimecho chifukwa nkhosazo zimamwetsedwa madzi ochokera mʼchitsimecho. Pamwamba pa chitsimecho panali mwala waukulu. ");
INSERT INTO nya_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Amati nkhosa zonse zikasonkhana, abusawo ankagudubuza mwalawo, kuwuchotsa ndi kumwetsa madzi nkhosazo. Kenaka ankawubwezera mwalawo pamalo pake, pakamwa pa chitsimepo. ");
INSERT INTO nya_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakobo anafunsa abusawo kuti, “Abale anga, mwachokera kuti?” Iwo anayankha, “Tachokera ku Harani.” ");
INSERT INTO nya_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Iye anawafunsanso kuti, “Kodi Labani, mdzukulu wa Nahori mukumudziwa?” Iwo anayankha, “Inde tikumudziwa?” ");
INSERT INTO nya_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ndipo Yakobo anawafunsanso, “Kodi ali bwino?” Iwo anati, “Inde ali bwino. Nayu Rakele mwana wake akubwera apoyu ndi nkhosa.” ");
INSERT INTO nya_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Iye anati, “Taonani, dzuwa likanalipo ndipo nthawi yosonkhanitsa nkhosa sinakwane. Bwanji osazimwetsa madzi nkhosazi.” ");
INSERT INTO nya_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Iwo anayankha, “Ayi sitingatero. Tidikira mpaka nkhosa zonse zisonkhane. Zikatero, tigubuduza mwalawu kuwuchotsa pamwamba pa chitsimepo, kenaka nʼkuzimwetsa madzi nkhosazo.” ");
INSERT INTO nya_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ali chiyankhulire nawo, Rakele anafika ndi nkhosa za abambo ake popeza ndiye amene ankaweta nkhosazo. ");
INSERT INTO nya_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakobo ataona Rakele mwana wa Labani, mlongo wa amayi ake, ali ndi nkhosa za Labani, anapita nawugudubuza mwala uja nazimwetsa madzi nkhosa za amalume akezo. ");
INSERT INTO nya_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Kenaka Yakobo anapsompsona Rakele nayamba kulira mokweza. ");
INSERT INTO nya_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Kenaka Yakobo anawuza Rakele kuti iye ndi mwana wa Rebeka, mlongo wa abambo a Rakele uja. Choncho Rakele anathamanga nakawuza abambo ake. ");
INSERT INTO nya_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labani atamva za Yakobo, mwana wa mlongo wake, anafulumira kukakumana naye. Anamukupatira napsompsona, napita naye ku nyumba kwake. Yakobo anafotokozera Labani zonse zinachitika. ");
INSERT INTO nya_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ndipo, Labani anati kwa iye, “Iwe ndiwe ndithu fupa ndi mnofu wanga.” Yakobo anakhala ndi Labani mwezi umodzi. ");
INSERT INTO nya_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Tsono Labani anawuza Yakobo kuti, “Zoona iwe ndi ife ndi abale. Koma suyenera kundigwirira ntchito popanda malipiro. Ndiwuze kuti malipiro ako azikhala wotani?” ");
INSERT INTO nya_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Tsono Labani anali ndi ana aakazi awiri; dzina la wamkulu linali Leya, ndipo dzina la wamngʼono linali Rakele. ");
INSERT INTO nya_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya anali ndi maonekedwe wofowoka koma Rakele anali wa maonekedwe wokongola kwambiri. ");
INSERT INTO nya_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakobo anakonda Rakele ndipo anati, “Ndidzakugwirirani ntchito kwa zaka zisanu ndi ziwiri chifukwa cha mwana wanu wamngʼono, Rakele.” ");
INSERT INTO nya_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labani anati, “Kuli bwino kuti ndimupereke kwa iwe ameneyu kusiyana ndi munthu wina. Khala ndi ine kuno.” ");
INSERT INTO nya_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Choncho Yakobo anagwira ntchito zaka zisanu ndi ziwiri chifukwa cha Rakele. Koma kwa iye zaka zonsezi zinakhala ngati masiku wochepa chifukwa anamukonda Rakele. ");
INSERT INTO nya_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Kenaka Yakobo anati kwa Labani, “Nthawi yanga ndakwanitsa, ndipatseni mwana wanu kuti ndimukwatire.” ");
INSERT INTO nya_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Pamenepo Labani anakonza phwando la ukwati, nayitana anthu onse a pamalopo. ");
INSERT INTO nya_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Koma pokwana usiku, Labani anatenga mwana wake wamkazi Leya namupatsa Yakobo, ndipo Yakobo anagona naye. ");
INSERT INTO nya_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ndipo Labani anapereka wantchito wake wamkazi Zilipa kwa Leya kuti akhale wantchito wake. ");
INSERT INTO nya_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Pakucha mmawa, Yakobo anaona kuti anagona ndi Leya. Choncho Yakobo anafunsa Labani, “Nʼchiyani mwandichitirachi? Kodi ine sindinakugwirireni ntchito chifukwa cha Rakele? Bwanji mwandinyenga?” ");
INSERT INTO nya_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labani anayankha, “Si mwambo wathu kuno kupereka wamngʼono ku banja, wamkulu asanakwatiwe. ");
INSERT INTO nya_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Yamba watsiriza sabata ya chikondwerero cha ukwati wa Leya; kenaka ndidzakupatsanso Rakele. Koma udzayenera kundigwirira ntchito zaka zisanu ndi ziwiri.” ");
INSERT INTO nya_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakobo anachitadi momwemo. Anamaliza sabata ya chikondwerero cha Leya, ndipo Labani anamupatsa Rakele kuti akhale mkazi wake. ");
INSERT INTO nya_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labani anapereka wantchito wake wamkazi Biliha kwa Rakele kuti akhale wantchito wake. ");
INSERT INTO nya_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakobo analowana ndi mkazi wake Rakele, ndipo Yakobo anakonda Rakele kuposa Leya. Ndipo anamugwirira ntchito Labani zaka zina zisanu ndi ziwiri chifukwa cha Rakele. ");
INSERT INTO nya_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Pamene Mulungu anaona kuti Yakobo sankamukonda Leya kwambiri, Iye analola kuti Leya uja akhale ndi ana, ndi kuti Rakele akhale wosabala. ");
INSERT INTO nya_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leya anakhala ndi pathupi ndipo anabereka mwana wamwamuna. Anamutcha Rubeni pakuti anati, “Yehova waona kusauka kwanga. Zoonadi, mwamuna wanga adzandikonda tsopano.” ");
INSERT INTO nya_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Anakhalanso ndi pathupi ndipo pamene anabereka mwana wamwamuna anati, “Yehova anamva kuti mwamuna wanga sakundikonda, choncho wandipatsanso mwana winayu.” Ndipo anamutcha dzina lake Simeoni. ");
INSERT INTO nya_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Anatenganso pathupi kachitatu, ndipo pamene anabereka mwana wamwamuna anati, “Pano pokha tidzaphatikana kwambiri ndi mwamuna wanga, chifukwa ndamubalira ana aamuna atatu.” Kotero anamutcha dzina lake Levi. ");
INSERT INTO nya_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Anatenganso pathupi pena, ndipo pamene anabereka mwana wamwamuna, iye anati, “Nthawi ino ndidzalemekeza Yehova.” Choncho anamutcha Yuda. Kenaka analeka kubereka. ");
INSERT INTO nya_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rakele ataona kuti sakumuberekera Yakobo ana, anayamba kumuchitira nsanje mʼbale wake. Choncho anati kwa Yakobo, “Undipatse ana kapena apo ayi ndingofa!” ");
INSERT INTO nya_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakobo anapsera mtima Rakele ndipo nati, “Kodi ine ndalowa mʼmalo mwa Mulungu amene wakulepheretsa iwe kukhala ndi ana?” ");
INSERT INTO nya_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Pamenepo Rakele anati kwa Yakobo, “Mdzakazi wanga Biliha nayu. Lowana naye kuti mwina nʼkundibalira mwana, ndipo kudzera mwa iyeyu nanenso nʼkukhala ndi ana.” ");
INSERT INTO nya_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ndipo anamupatsa Yakobo wantchito wake Biliha kuti alowane naye. Choncho Yakobo analowana ndi Biliha, ");
INSERT INTO nya_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ndipo Bilihayo anatenga pathupi namubalira Yakobo mwana wamwamuna. ");
INSERT INTO nya_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Pamenepo Rakele anati, “Mulungu waweruza mondikomera mtima, wamva kupempha kwanga ndipo wandipatsa mwana wa mwamuna.” Choncho anamutcha Dani. ");
INSERT INTO nya_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Biliha, wantchito wa Rakele, anatenganso pathupi nabalira Yakobo mwana wa mwamuna wachiwiri. ");
INSERT INTO nya_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Pamenepo Rakele anati, “Ndakhala ndikulimbana kwambiri ndi mʼbale wanga ndipo ndapambana.” Choncho anamutcha Nafutali. ");
INSERT INTO nya_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Pamene Leya anaona kuti waleka kubereka ana, iye anatenga wantchito wake Zilipa namupereka kwa Yakobo kuti alowane naye. ");
INSERT INTO nya_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilipa, wantchito wa Leya, anaberekera Yakobo mwana wamwamuna. ");
INSERT INTO nya_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Pamenepo Leya anati, “Mwayi wangawo!” Choncho anamutcha Gadi. ");
INSERT INTO nya_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilipa, wantchito wa Leya anamubalira Yakobo mwana wa mwamuna wachiwiri. ");
INSERT INTO nya_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Pamenepo Leya anati, “Ndakondwa bwanji! Amayi adzanditcha ine wokondwa.” Choncho anamutcha Aseri. ");
INSERT INTO nya_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Pa nthawi yokolola tirigu, Rubeni anapita ku munda ndipo anapezako zipatso za mankhwala wobereketsa. Tsono anatengerako mayi wake Leya. Rakele anati kwa Leya, “Chonde patseko mankhwala wakupezera mwana wakowo.” ");
INSERT INTO nya_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Koma iye anati kwa Rakele, “Kodi sizinakukwanire kulanda mwamuna wanga? Ukuti utengenso mankhwala a mwana wangawa.” Iye anati, “Chabwino, agone ndi iwe usiku uno kuti tisinthane ndi mankhwala a mwana wakowo.” ");
INSERT INTO nya_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Choncho pamene Yakobo ankabwera kuchokera ku munda madzulo, Leya anapita kukakumana naye nati, “Lero mukagona ku nyumba chifukwa ndakubwerekani ndi mankhwala wobereketsa a mwana wanga.” Choncho usiku umenewo Yakobo anakalowa kwa Leya. ");
INSERT INTO nya_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Mulungu anamva pemphero la Leya ndipo anatenga pathupi nabalira Yakobo mwana wa mwamuna wachisanu. ");
INSERT INTO nya_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Pamenepo Leya anati, “Mulungu wandipatsa mphotho chifukwa chopereka wantchito wanga kwa mwamuna wanga.” Choncho anamutcha Isakara. ");
INSERT INTO nya_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leya anatenganso pathupi nabalira Yakobo mwana wa mwamuna wachisanu ndi chimodzi. ");
INSERT INTO nya_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Pamenepo Leya anati, “Mulungu wandipatsa mphatso yapamwamba. Tsopano mwamuna wanga adzandilemekeza chifukwa ndamubalira ana aamuna asanu ndi mmodzi.” Choncho anamutcha Zebuloni. ");
INSERT INTO nya_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Patapita nthawi Leya anabereka mwana wamkazi ndipo anamutcha Dina. ");
INSERT INTO nya_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Kenaka, Mulungu anakumbukira Rakele namva pemphero lake ndi kulola kuti akhale ndi mwana. ");
INSERT INTO nya_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Rakele anatenga pathupi nabala mwana wamwamuna ndipo anati, “Mulungu wandichotsera manyazi anga.” ");
INSERT INTO nya_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Iye anamutcha mwanayo Yosefe, ndipo anati, “Mulungu andipatsenso mwana wina.” ");
INSERT INTO nya_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rakele atabereka Yosefe, Yakobo anati kwa Labani, “Ndimasuleni kuti ndizipita ku dziko la kwathu. ");
INSERT INTO nya_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Patseni akazi anga ndi ana anga, amene ndinakugwirirani ntchito, ndipo ndidzanyamuka ulendo. Inu mukudziwa ntchito imene ndakugwirirani.” ");
INSERT INTO nya_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Koma Labani anati kwa iye, “Chonde, ngati mungandikomere mtima musapite chifukwa ndadziwa kudzera mwa kuwombeza kwanga kuti Yehova wandidalitsa chifukwa cha inu.” ");
INSERT INTO nya_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Anapitiriza kunena kuti, “Tchula malipiro ako ndipo ndidzakupatsa.” ");
INSERT INTO nya_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Koma Yakobo anati kwa iye, “Inu mukudziwa mmene ine ndakugwirirani ntchito ndi mmene ziweto zanu zaswanira pamene ine ndimazisamalira. ");
INSERT INTO nya_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Poyamba munali nazo zochepa ine ndisanabwere, koma tsopano zachuluka. Yehova wakudalitsani chifukwa cha ine. Ndi nthawi tsopano kuti nane ndisamalire banja langa.” ");
INSERT INTO nya_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labani anafunsa, “Ndikupatse chiyani?” Yakobo anayankha, “Musandipatse kanthu. Koma mungondichitira izi ndipo ndidzapitiriza kusamalira nkhosa zanu ndi kuziyangʼanira: ");
INSERT INTO nya_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Mundilole ndiyendeyende pakati pa ziweto zanu lero ndi kuchotsamo mwana wankhosa wamkazi aliyense wakuda, mbuzi iliyonse yamathothomathotho ndi yamawangamawanga. Zimenezi ndiye zikhale malipiro anga. ");
INSERT INTO nya_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ndipo chilungamo changa chidzaoneka mʼtsogolo, pamene inu mudzabwere kudzaona malipiro angawo. Ngati mudzapeza mbuzi mʼgulu langa imene si yamawangamawanga, kapena mwana wankhosa wamkazi amene si wakuda ndiye kuti zimenezo zidzakhala kuti ndinakuberani.” ");
INSERT INTO nya_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labani anati, “Ndavomera, zikhale monga mmene wayankhuliramu.” ");
INSERT INTO nya_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Tsiku lomwelo Labani anachotsa atonde onse ndi mbuzi zazikazi zonse zimene zinali ndi mawangamawanga kapena zamathothomathotho, ndiponso zonse zabanga loyera. Anachotsa ana onse ankhosa aakazi akuda, napereka ziweto zonsezi kwa ana ake aamuna kuti aziweta. ");
INSERT INTO nya_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Kenaka Labani anayenda mtunda wa masiku atatu kutalikirana ndi Yakobo koma Yakobo anapitiriza kuweta nkhosa zina zonse za Labani. ");
INSERT INTO nya_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Tsono Yakobo anatenga nthambi zaziwisi za mitengo ya mkundi, alimoni ndi puleni nazisenda kuchotsa makungwa ake mpaka mtengo woyera wamʼkati kuonekera. ");
INSERT INTO nya_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Atatero anayika nthambi zija mʼmagome omwera madzi molunjika ziweto zija kuti pakumwa madziwo ziweto zazikazi ziziyangʼana nthambi zija popeza kuti pakumwa madzi ziweto zija zinkakwerana. ");
INSERT INTO nya_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ndiye kuti nkhosa zija zinkatenga mawere pakumwa madzi molunjika nthambi zija, ndipo zinkaswa ana a mawangamawanga kapena a mathothomathotho. ");
INSERT INTO nya_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakobo anayika padera ana a ziweto zija. Koma ziweto zina anaziyika kuti ziyangʼanane ndi za Labani, zimene zinali za mawangamawanga ndi zakuda. Motero anapeza ziweto zakezake, ndipo sanazisakanize ndi za Labani. ");
INSERT INTO nya_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Yakobo ankayika nthambi zija momwera madzi pamene ziweto zamphamvu zazikazi zinkakweredwa pofuna kuti zitenge mawere pakumwa madzi moyangʼanana ndi nthambi zija. ");
INSERT INTO nya_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Koma sankayika nthambizo pamene ziweto zofowoka zazikazi zinkakweredwa pakumwa madzi. Choncho ziweto zofowoka zonse zinakhala za Labani, ndi ziweto zamphamvu zinakhala za Yakobo. ");
INSERT INTO nya_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Mwa njira imeneyi, Yakobo analemera kwambiri ndipo anali ndi ziweto zochuluka kwambiri, antchito aakazi ndi aamuna, ngamira ndi abulu. ");
INSERT INTO nya_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakobo anamva zimene ana aamuna a Labani ankanena kuti, “Yakobo watenga chilichonse cha abambo athu ndipo wapeza chuma chonsechi pogwiritsa ntchito chuma cha abambo athu.” ");
INSERT INTO nya_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Choncho Yakobo anaona kuti Labani sankamuonetsanso nkhope yabwino monga kale. ");
INSERT INTO nya_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Pamenepo Yehova anati kwa Yakobo, “Bwerera ku dziko la makolo ako ndi kwa abale ako, ndipo Ine ndidzakhala nawe.” ");
INSERT INTO nya_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Choncho Yakobo anatumiza mawu kukayitana Rakele ndi Leya kuti abwere ku busa kumene ankaweta ziweto zake. ");
INSERT INTO nya_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Iye anawawuza kuti, “Abambo anu sakundionetsanso nkhope yabwino monga kale, koma Mulungu wa makolo anga wakhala ali nane. ");
INSERT INTO nya_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Inu mukudziwa kuti ndagwirira ntchito abambo anu ndi mphamvu zanga zonse, ");
INSERT INTO nya_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","chonsecho abambo anu akhala akundinyenga posintha malipiro anga kakhumi konse. Komabe Mulungu sanalole kuti andichitire choyipa ");
INSERT INTO nya_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Pamene abambo anu anati, ‘Zamawangamawanga zidzakhala malipiro ako,’ ziweto zonse zinaswa ana amawangamawanga; ndipo pamene anati, ‘Zamichocholozi zidzakhala malipiro ako,’ ziweto zonse zinaswa ana a michocholozi. ");
INSERT INTO nya_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Motero Mulungu walanda abambo anu ziweto zawo ndi kundipatsa. ");
INSERT INTO nya_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Pa nthawi imene ziweto zimatenga mawere ndinalota maloto, ndipo ndinaona kuti atonde onse amene ankakwerawo anali amichocholozi, amawangamawanga kapena amathothomathotho ");
INSERT INTO nya_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Kutulo komweko, mngelo wa Mulungu anati, ‘Yakobo.’ Ine ndinayankha, ‘Ee, Ambuye.’ ");
INSERT INTO nya_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ndipo iye anati, ‘Tayangʼana ndipo taona kuti atonde onse okwerana ndi ziweto ali amichocholozi, amawangamawanga kapena a mathothomathotho, popeza ndaona zonse zimene Labani wakhala akukuchitira. ");
INSERT INTO nya_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ine ndine Mulungu amene ndinadza kwa iwe pa Beteli paja. Beteli ndi kumalo kuja kumene unayimika mwala ndi kuwudzoza mafuta, komanso kulumbira kwa Ine. Tsopano choka mʼdziko lino msanga ndi kubwerera ku dziko la kwanu.’ ” ");
INSERT INTO nya_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Pamenepo Rakele ndi Leya anayankha, “Kodi ngati ife tilinso ndi gawo ngati cholowa pa chuma cha abambo athu? ");
INSERT INTO nya_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Kodi abambo athu samationa ife ngati alendo? Iwo anatigulitsa ndi kuwononga ndalama zonse anazipeza pa ifezo. ");
INSERT INTO nya_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Chuma chonse chimene Mulungu walanda abambo athu, ndi chathu ndi ana athu. Tsono inu chitani zimene Mulungu wakuwuzani.” ");
INSERT INTO nya_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Pamenepo Yakobo anakonzeka nakweza ana ake ndi akazi ake pa ngamira, ");
INSERT INTO nya_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","anakusa ziweto zake zonse patsogolo natenga katundu wake yense amene anamupeza ku Padanaramu, ndipo ananyamuka kupita ku Kanaani, ku dziko la abambo ake, Isake. ");
INSERT INTO nya_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Labani atachoka pa khomo kupita kukameta nkhosa, mʼmbuyomu Rakele anaba timafano ta milungu ta abambo ake. ");
INSERT INTO nya_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Komanso nthawi iyi nʼkuti Yakobo atamunamiza Labani Mwaramu posamuwuza zoona kuti afuna kuthawa. ");
INSERT INTO nya_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Choncho anathawa ndi zonse anali nazo. Ananyamuka nawoloka mtsinje wa Yufurate kupita cha ku Giliyadi, dziko la mapiri. ");
INSERT INTO nya_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Patapita masiku atatu, Labani anawuzidwa kuti Yakobo wathawa. ");
INSERT INTO nya_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Pomwepo anatengana ndi abale ake namulondola Yakobo kwa masiku asanu ndi awiri ndipo anakamupezera ku Giliyadi, dziko la mapiri. ");
INSERT INTO nya_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Koma Mulungu anabwera kwa Labani, Mwaramu kutulo usiku nati kwa iye, “Samala kuti usamuopseze Yakobo mwa njira iliyonse.” ");
INSERT INTO nya_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Pamene Labani amamupeza Yakobo, nʼkuti Yakobo atamanga matenti ake ku mapiri a dziko la Giliyadi. Nayenso Labani ndi abale ake anamanga matenti awo komweko. ");
INSERT INTO nya_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Tsono Labani anati kwa Yakobo, “Kodi ndakuchita chiyani kuti iwe undinamize ndi kutenga ana anga ngati anthu ogwidwa ku nkhondo? ");
INSERT INTO nya_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Chifukwa chiyani unandinamiza ndi kuthawa mozemba wosandiwuza? Ukanandiwuza, bwezi titatsanzikana mwa chisangalalo ndi kuyimba nyimbo ndi zisekese ndi azeze. ");
INSERT INTO nya_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Sunandilole kuti ndingopsompsona adzukulu anga ndi ana anga aakazi motsanzikana nawo. Unachita zopusa. ");
INSERT INTO nya_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ndili nayo mphamvu yakukuchita choyipa; koma usiku wapitawu, Mulungu wa abambo ako wandiwuza ine kuti, ‘Usamuopseze Yakobo mwa njira iliyonse.’ ");
INSERT INTO nya_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ndikudziwa kuti unachoka chifukwa unapukwa kufuna kubwerera kwanu kwa abambo ako. Koma nʼchifukwa chiyani unaba milungu yanga?” ");
INSERT INTO nya_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakobo anayankha Labani kuti, “Ine ndinkaopa chifukwa ndinkaganiza kuti mukhoza kundilanda anawa. ");
INSERT INTO nya_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Koma mukapeza wina aliyense ndi milungu yanu, ameneyo sakhala ndi moyo. Anthu onse akupenya, lozani chilichonse chanu chimene chili ndi ine, ndipo ngati muchipeze tengani. Koma Yakobo sankadziwa kuti Rakele anabadi milunguyo.” ");
INSERT INTO nya_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Choncho Labani analowadi mu tenti ya Yakobo, ya Leya ndi mʼmatenti a adzakazi awiri aja, koma sanapeze kalikonse. Atatuluka mu tenti ya Leya, analowa ya Rakele. ");
INSERT INTO nya_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Koma Rakele anatengadi milungu ija ndi kuyiika mʼkati mwa chokhalira cha pa ngamira, iye nʼkukhalapo. Choncho Labani anafunafuna mu tenti monse koma wosapeza kanthu. ");
INSERT INTO nya_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rakele anati kwa abambo ake, “Pepanitu musandikwiyire mbuye wanga chifukwa choti sinditha kuyimirira pamaso panu chifukwa ndili kumwezi.” Choncho Labani anafunafuna koma sanayipeze milungu ija. ");
INSERT INTO nya_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yakobo anapsa mtima nafunsa Labani mwaukali kuti, “Kodi ndalakwa chiyani? Ndi tchimo lanji limene ndachita kuti muchite kundisaka chonchi? ");
INSERT INTO nya_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Chifukwa chiyani mwafunyulula katundu wanga? Ndipo mwapeza chiyani cha inu pamenepa? Chimene mwapezapo chiyikeni poyera pamaso pa abale anu ndi anga kuti atiweruze. ");
INSERT INTO nya_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Ndakhala nanu kwa zaka makumi awiri tsopano ndipo nkhosa ndi mbuzi zanu sizinapoloze, kapena ine kudyapo nkhosa za mʼkhola mwanu. ");
INSERT INTO nya_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Chiweto chikakhadzulidwa ndi chirombo, sindinkabwera nacho kwa inu. Ineyo ndinkalipira. Inuyo munkandilipiritsa kalikonse kobedwa masana kapena usiku. ");
INSERT INTO nya_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Moyo wanga unali wotere: Dzuwa limanditentha masana ndipo usiku ndimazunzika ndi kuzizira. Tulo sindimalipeza konse. ");
INSERT INTO nya_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Zinthu zinali chonchi kwa zaka makumi awiri zimene ndinali mʼnyumba mwanu. Ndinakugwirirani ntchito kwa zaka khumi ndi zinayi chifukwa cha ana anu aakazi awiri ndipo zaka zina zisanu ndi chimodzi chifukwa cha ziweto zanu, ndipo munandisinthira malipiro kakhumi konse. ");
INSERT INTO nya_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Akanapanda kukhala nane Mulungu wa abambo anga, Mulungu wa Abrahamu ndi Mulungu amene Isake ankamuopa, mosakayika inu mukanandichotsa chimanjamanja. Koma Mulungu waona zovuta zanga ndi kulimbikira ntchito kwanga, ndipo usiku wapitawu anakudzudzulani.” ");
INSERT INTO nya_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labani anayankha Yakobo nati, “Ana aakaziwa ndi anga, ana awo ndi anganso. Ziwetozi ndi zanga. Chilichonse ukuona apa ndi changa. Koma tsopano ndingachite chiyani ndi ana anga aakaziwa kapena ndi ana awo? ");
INSERT INTO nya_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Tsono, tiye tichite pangano pakati pa iwe ndi ine, ndipo likhale mboni pakati pathu.” ");
INSERT INTO nya_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Choncho Yakobo anayimiritsa mwala ngati chipilala. ");
INSERT INTO nya_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Nati kwa abale ake, “Tutani miyala ina.” Choncho anawunjika miyalayo, ndipo anadya chakudya atakhala pa mbali pa muluwo. ");
INSERT INTO nya_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labani anawutcha muluwo Yegara-sahaduta, ndipo Yakobo anawutcha Galeeda. ");
INSERT INTO nya_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labani anati, “Mulu uwu ndi mboni pakati pa inu ndi ine lero.” Ndi chifukwa chake unatchedwa Galeeda. ");
INSERT INTO nya_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Unatchedwanso Mizipa, chifukwa iye anati, “Yehova aonetsetsa kuti palibe mmodzi mwa ife adzaswe panganoli ngakhale titatalikirana. ");
INSERT INTO nya_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ngati ukazunza ana anga kapena kukwatira akazi enanso, ngakhale kuti palibe wina amene ali nafe pano, koma kumbukira kuti Mulungu ndiye mboni pakati pathu.” ");
INSERT INTO nya_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labani anatinso kwa Yakobo, “Taona pano pali miyala ndi chipilala chimene ndayimika pakati pa iwe ndi ine. ");
INSERT INTO nya_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Mulu wa miyala uwu ndi chipilalachi ndi mboni. Ine sindidzadutsa mulu wa miyalawu kudzalimbana ndi iwe. Iwenso usadzadutse mulu wa miyalawu kudzalimbana nane. ");
INSERT INTO nya_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Mulungu wa Abrahamu ndi Mulungu wa Nahori ndiye adzatiweruze.” Choncho Yakobo analumbira mʼdzina la Mulungu amene Isake, abambo ake ankamuopa. ");
INSERT INTO nya_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yakobo anapereka nsembe pa phiri paja, ndipo anayitana abale ake kuti adzadye chakudya. Atadya chakudya anagona pa phiri pomwepo. ");
INSERT INTO nya_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Mmamawa wake, Labani anapsompsona zidzukulu zake ndi ana ake nawadalitsa. Kenaka ananyamuka kubwerera ku mudzi. ");
INSERT INTO nya_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Nayenso Yakobo analowera njira yake, ndipo angelo a Mulungu anakumana naye. ");
INSERT INTO nya_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Pamene Yakobo anawaona anati, “Ili ndi gulu la Mulungu.” Choncho anawatcha malowo Mahanaimu. ");
INSERT INTO nya_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakobo anatumiza amithenga ake kwa mʼbale wake Esau ku dera la Seiri, dziko la Edomu. ");
INSERT INTO nya_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Anawalangiza kuti, “Zimene mukanene ndi izi kwa mbuye wanga Esau: ‘Mtumiki wanu Yakobo akuti, Ine ndakhala ndi kukhala ndi Labani mpaka tsopano. ");
INSERT INTO nya_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ndili ndi ngʼombe, abulu, nkhosa ndi mbuzi, antchito aamuna ndi aakazi. Tsopano ndikutumiza mawu amenewa kwa mbuye wanga, kuti mundikomere mtima.’ ” ");
INSERT INTO nya_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Pamene amithenga aja anabwerera kwa Yakobo, anati, “Tinapita kwa mʼbale wanu Esau, ndipo tsopano iye akubwera kudzakumana nanu. Ali ndi anthu 400.” ");
INSERT INTO nya_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakobo anali ndi mantha ndi nkhawa yayikulu kwambiri. Tsono anagawa anthu onse amene anali naye, ndiponso nkhosa, mbuzi, ngʼombe ndi ngamira mʼmagulu awiri. ");
INSERT INTO nya_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Mʼmaganizo ake iye ankanena kuti, “Ngati Esau atabwera ndi kuthira nkhondo gulu limodzi, gulu lina lotsalalo likhoza kupulumuka.” ");
INSERT INTO nya_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Pamenepo Yakobo anapemphera, “Haa, Mulungu wa kholo langa Abrahamu, Mulungu wa abambo anga Isake, Aa Yehova amene munati kwa ine, ‘Bwerera ku dziko la kwanu ndi kwa abale ako, ndipo ndidzakuchitira zabwino.’ ");
INSERT INTO nya_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ine siwoyenera kulandira kukoma mtima kwanu ndi kukhulupirika kwanu kumene mwaonetsa wantchito wanu. Ndinali ndi ndodo yokha pamene ndinawoloka Yorodani uyu koma tsopano ndili ndi magulu awiri. ");
INSERT INTO nya_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ndipulumutseni mʼdzanja la mʼbale wanga Esau, popeza ndikuopa kuti mwina akubwera kudzandithira nkhondo pamodzi ndi akazi ndi ana omwe. ");
INSERT INTO nya_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Paja Inu munandilonjeza kuti simudzalephera kundichitira zabwino ndi kuti zidzukulu zanga zidzakhala zosawerengeka ngati mchenga wa ku nyanja.” ");
INSERT INTO nya_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Iye anagona pomwepo usiku umenewo. Pambuyo pake anasankhula pa chuma chimene anali nacho zinthu izi ngati mphatso za Esau, mʼbale wake: ");
INSERT INTO nya_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Anasankhula mbuzi zazikazi 200 ndi atonde makumi awiri, nkhosa zazikazi 200 ndi nkhosa zazimuna makumi awiri, ");
INSERT INTO nya_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ngamira za mkaka 30 ndi ana awo, ngʼombe zazikazi 40 ndi zazimuna khumi, ndipo abulu aakazi makumi awiri ndi abulu aamuna khumi. ");
INSERT INTO nya_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Iye anazipereka kwa antchito ake kuti azikuse, gulu lililonse pa lokha, ndipo anati kwa antchito akewo, “Tsogolani ndipo muonetsetse kuti pali mpata pakati pa gulu ndi gulu linzake.” ");
INSERT INTO nya_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Anawuza mnyamata wa gulu loyamba kuti, “Ngati ukumana naye mʼbale wanga Esau nakufunsa kuti, ‘Ndinu antchito a yani, ndipo mukupita kuti? Nanga ziweto zonse zili patsogolo pakozi ndi za yani?’ ");
INSERT INTO nya_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Pamenepo ukayankhe kuti, ‘Zimenezi ndi za wantchito wanu, Yakobo, ndipo wazipereka kwa inu, Esau, mbuye wake ngati mphatso. Mtumiki wanuyu akubwera mʼmbuyo mwathumu.’ ” ");
INSERT INTO nya_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Anawuza mawu omwewo kwa wachiwiri, wachitatu ndi ena onse amene ankayenda motsogoza ziwetozo kuti, “Inunso munene zomwezo kwa Esau mukakumana naye. ");
INSERT INTO nya_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Muzikanena kuti, ‘Wantchito wanu Yakobo akubwera mʼmbuyo mwathumu.’ ” Popeza anaganiza kuti, “Ndidzamutsitsa mtima ndi mphatso ndazitsogozazi. Apo tsono ndikadzakumana naye, mwina adzandilandira bwino.” ");
INSERT INTO nya_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Choncho mphatso za Yakobo zinatsogola, koma iye mwini anagona pa msasa pomwepo usiku umenewo. ");
INSERT INTO nya_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Usiku umenewo Yakobo anauka natenga akazi ake awiri, antchito ake awiri ndi ana ake aamuna khumi ndi mmodzi nawoloka pa dooko la mtsinje wa Yaboki. ");
INSERT INTO nya_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Atatha kuwawolotsa pa mtsinjewo anawolotsanso katundu wake yense. ");
INSERT INTO nya_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Tsono Yakobo anatsala yekha. Tsono munthu wina anadzalimbana naye mpaka mʼmbandakucha. ");
INSERT INTO nya_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Pamene munthuyo anaona kuti sangathe kumugonjetsa, anakhudza nyungʼunyu ya pa ntchafu ya Yakobo ndipo inaguluka polimbanapo. ");
INSERT INTO nya_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Kenaka munthuyo anati, “Ndisiye ndizipita, popeza kunja kukucha.” Koma Yakobo anayankha, “Sindikulolani kupita pokhapokha mutandidalitsa.” ");
INSERT INTO nya_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Munthu uja anamufunsa Yakobo kuti, “Kodi dzina lako ndiwe yani?” Iye anayankha, “Ndine Yakobo.” ");
INSERT INTO nya_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Pamenepo munthuyo anati, “Dzina lako silidzakhalanso Yakobo koma Israeli, chifukwa walimbana ndi Mulungu ndi anthu ndipo wapambana.” ");
INSERT INTO nya_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakobo anati, “Chonde, uzeni dzina lanu.” Koma munthuyo anati, “Chifukwa chiyani ukundifunsa dzina?” Kenaka anamudalitsa pomwepo. ");
INSERT INTO nya_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Choncho Yakobo anawatcha malowo Penueli, popeza anati, “Ndinaonana ndi Mulungu maso ndi maso koma sindinafe.” ");
INSERT INTO nya_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Dzuwa linamutulukira Yakobo pamene amachoka pa Penueli. Tsono ankayenda chotsimphina chifukwa cha nyungʼunyu yake ija. ");
INSERT INTO nya_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Nʼchifukwa chake mpaka lero Aisraeli sadya nyama ya pa nyungʼunyu chifukwa Yakobo anakhudzidwa pa nyungʼunyu. ");
INSERT INTO nya_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakobo atakweza maso ake anaona Esau akubwera ndi anthu ake 400. Choncho ana ake anawagawira Leya, Rakele ndi antchito awiri aja. ");
INSERT INTO nya_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Anayika antchito ndi ana awo patsogolo, kenaka nʼkubwera Leya ndi ana ake, ndipo pambuyo pawo Rakele ndi Yosefe. ");
INSERT INTO nya_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Iye mwini anakhala patsogolo nawerama mpaka kukhudza pansi kasanu ndi kawiri pamene amayandikira mʼbale wake. ");
INSERT INTO nya_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Koma Esau anathamanga kukakumana ndi Yakobo ndipo anamukupatira namupsompsona. Onse awiri ankangolira. ");
INSERT INTO nya_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Kenaka Esau ataona amayi ndi ana awo anamufunsa Yakobo kuti, “Kodi anthu amene uli nawowa ndi a ndani?” Yakobo anayankha kuti, “Awa ndi ana amene Mulungu, mwa kukoma mtima kwake, wapereka kwa mtumiki wanune.” ");
INSERT INTO nya_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Tsono antchito aja anayandikira naweramitsa mitu pansi. ");
INSERT INTO nya_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Kenaka, Leya ndi ana ake anabwera. Nawonso anaweramitsa mitu pansi. Potsiriza pa onse anabwera Yosefe ndi Rakele naweramitsanso mitu yawo pansi. ");
INSERT INTO nya_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau anafunsa kuti, “Kodi gulu la ziweto ndakumana nalo lija ndi layani?” Yakobo anayankha nati, “Mbuye wanga, gulu lija ndi lanu kuti mundikomere mtima.” ");
INSERT INTO nya_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Koma Esau anati, “Mʼbale wanga, ine ndili nazo kale zambiri. Zinthu zakozi sunga.” ");
INSERT INTO nya_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakobo anati, “Chonde musatero. Ngati mwandikomera mtima, landirani mphatso yangayi kuchokera kwa ine. Pakuti ndi mmene mwandirandira bwinomu, ine ndikamaona nkhope yanu ndikuchita ngati ndikuona nkhope ya Mulungu. ");
INSERT INTO nya_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Chonde, landirani mphatso imene ndakutengeraniyi, popeza Mulungu wandikomera mtima kwambiri moti ndili ndi zonse zimene ndizifuna.” Ndipo popeza kuti Yakobo anamuwumiriza, Esau analandira. ");
INSERT INTO nya_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ndipo Esau anati, “Tiyeni tizipita; nditsagana nanu.” ");
INSERT INTO nya_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Koma Yakobo anati kwa iye, “Mbuye wanga, inu mudziwa kuti anawa ndi a nthete ndiponso ndiyenera kusamalira nkhosa ndi ngʼombe zimene zikuyamwitsa ana awo. Ngati ndizimenya kuti zifulumire, tsiku limodzi lokha nyamazo zidzafa. ");
INSERT INTO nya_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Choncho, mbuye wanga lolani kuti mutsogole. Ine ndiziyenda pangʼonopangʼono pambuyo pa ziwetozi ndi anawa mpaka ndikafika ku Seiri.” ");
INSERT INTO nya_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau anati, “Ndiye bwanji ndikusiyireko ena mwa anthu anga.” Koma Yakobo anati, “Koma muchitiranji zimenezi? Chachikulu nʼkuti mwandilandira bwino, mbuye wanga.” ");
INSERT INTO nya_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Choncho tsiku limenelo Esau anayamba ulendo wobwerera ku Seiri. ");
INSERT INTO nya_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Komabe Yakobo anapita ku Sukoti. Kumeneko anamanga nyumba yake ndi makola a ziweto zake. Nʼchifukwa chake malowa amatchedwa Sukoti. ");
INSERT INTO nya_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Mmene ankabwerera kuchokera ku Padanaramu, Yakobo anafika ku Salemu, mzinda wa Sekemu ku Kanaani. Anamanga msasa pamalopo moyangʼanana ndi mzindawo. ");
INSERT INTO nya_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Malo amenewo anagula kwa zidzukulu za Hamori, abambo a Sekemu ndi ndalama 100 zasiliva. ");
INSERT INTO nya_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Pamalopo anamanganso guwa lansembe, nalitcha Eli Elohe Israeli. ");
INSERT INTO nya_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Tsopano Dina, mwana amene Leya anaberekera Yakobo, anapita kukacheza ndi akazi ena a mʼdzikolo. ");
INSERT INTO nya_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Pamene Sekemu mwana wa Hamori Mhivi, mfumu ya deralo, anamuona, anamugwirira. ");
INSERT INTO nya_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Koma Sekemu anamukondadi namwali uja, Dina, mwana wa Yakobo motero kuti anamuyankhula mawu womutonthoza. ");
INSERT INTO nya_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Choncho Sekemu anati kwa abambo ake Hamori, “Mundipezere mtsikana uyu kuti akhale mkazi wanga.” ");
INSERT INTO nya_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakobo anamva kuti mwana wake Dina wagwiriridwa, koma sanachitepo kanthu msanga kudikira mpaka ana ake amuna omwe anali ku busa atabwerako. ");
INSERT INTO nya_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Kenaka Hamori, abambo a Sekemu, anapita kukakambirana ndi Yakobo. ");
INSERT INTO nya_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Pa nthawi iyi nʼkuti ana a Yakobo atabwererako ku busa kuja. Iwo atangomva zimene zinachitika, anawawidwa mtima. Iwo anapsa mtima kwambiri kuti Sekemu nʼkuchita chonyansa choterechi mu dziko la Israeli, kumugwirira Dina, mwana wa Yakobo. ");
INSERT INTO nya_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Koma Hamori anawawuza kuti, “Mwana wanga Sekemu wamukonda kwambiri mwana wanu. Chonde muloleni kuti akhale mkazi wake. ");
INSERT INTO nya_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Tiyeni tichite mgwirizano wa ukwati kuti ife tidzikwatira ana anu ndi inu mudzikwatira ana athu. ");
INSERT INTO nya_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Khazikikani pakati pathu. Mukhoza kupeza malo wokhala kulikonse kumene mufuna. Mukhozanso kuchita malonda momasuka ndi kupeza chuma.” ");
INSERT INTO nya_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Pamenepo Sekemu anati kwa abambo ndi alongo ake a Dina, “Inu mundikomere mtima, ndipo ndidzakupatsani chilichonse munganene. ");
INSERT INTO nya_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Tchulani mtengo wamalowolo umene ndiyenera kupereka, ndipo ndipereka. Ndidzakupatsani chilichonse chimene mukufuna malingana inu mukandipatsa namwaliyu kuti ndimukwatire.” ");
INSERT INTO nya_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ana a Yakobo anayankha Sekemu ndi abambo ake, Hamori mwachinyengo chifukwa mlongo wawo, Dina anali atayipitsidwa. ");
INSERT INTO nya_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Iwo anati, “Sitingachite zimenezo, kupereka mlongo wathu kwa munthu wosachita mdulidwe. Chimenecho ndi chinthu cha manyazi kwa ife. ");
INSERT INTO nya_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Tikuvomerani pokhapokha mutakhala ngati ife, mutachita mdulidwe ana anu onse aamuna. ");
INSERT INTO nya_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Kenaka tidzakulolani kuti mukwatire ana athu, ifenso tizikwatira ana anu. Choncho tidzakhala pakati panu ndipo tidzakhala anthu amodzi. ");
INSERT INTO nya_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Koma ngati simuvomereza kuchita mdulidwe titenga mlongo wathu ndi kupita.” ");
INSERT INTO nya_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Mawu amenewa anakondweretsa Hamori ndi mwana wake Sekemu. ");
INSERT INTO nya_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Mnyamata uja amene anali wolemekezeka kwambiri pa banja lake lonse, sanachedwe kuchita mdulidwe popeza anamukonda kwambiri mwana wa Yakobo. ");
INSERT INTO nya_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Choncho Hamori ndi mwana wake Sekemu anapita ku chipata cha mzinda wawo kukayankhula ndi anthu a mu mzindawo. ");
INSERT INTO nya_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Iwo anati, “Anthu awa ndi a mtendere. Aloleni kuti akhale mʼdziko mwathu muno nachitamo malonda. Dzikoli lili ndi malo ambiri woti iwo nʼkukhalamo. Tingathe kukwatira ana awo aakazi ndipo angathe kukwatira ana athu aakazi. ");
INSERT INTO nya_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Komatu anthuwa adzavomereza kukhala amodzi a ife pokhapokha ngati amuna onse pakati pathu atachita mdulidwe monga alili iwo. ");
INSERT INTO nya_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Tikatero, ndiye kuti ziweto zawo zonsezi, katundu wawo yenseyu ndi ziweto zawo zina zonsezi zidzakhala zathu. Choncho tiyeni tiwavomereze ndipo adzakhazikika pakati pathu.” ");
INSERT INTO nya_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Amuna onse amene anatuluka ku chipata cha mzinda anavomerezana ndi Hamori ndi mwana wake Sekemu, ndipo aliyense wamwamuna mu mzindamo anachita mdulidwe. ");
INSERT INTO nya_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Patapita masiku atatu, amuna onse akumvabe ululu wa kuchita mdulidwe uja, ana awiri a Yakobo, Simeoni ndi Levi, alongo ake a Dina, anatenga malupanga ndi kulowa mu mzindawo mwakachetechete napha amuna onse. ");
INSERT INTO nya_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Anapha Hamori ndi Sekemu. Anakatenga Dina ku nyumba kwa Sekemu nanyamuka. ");
INSERT INTO nya_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ana a Yakobo anafika kwa anthu ophedwawo ndi kututa katundu mu mzindawo chifukwa anagwiririra mlongo wawo. ");
INSERT INTO nya_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Analanda nkhosa zawo, ngʼombe zawo, abulu awo ndi china chilichonse chawo mu mzindamo pamodzi ndi za ku minda. ");
INSERT INTO nya_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Anawatengera chuma chawo chonse, akazi ndi ana awo, pamodzi ndi zonse zimene zinapezeka mʼnyumba zawo. Zonsezi zinayesedwa ngati zolandidwa ku nkhondo. ");
INSERT INTO nya_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Pamenepo Yakobo anati kwa Simeoni ndi Levi, “Mwandiputira mavuto, ndi kundiyipitsira dzina pakati pa anthu a mʼdziko lino, Akanaani ndi Aperezi. Ife ndife owerengeka, ndipo atati aphatikizane kudzandithira nkhondo, ndiye kuti ine ndi banja langa tidzawonongeka.” ");
INSERT INTO nya_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Koma iwo anayankha kuti, “Pepani, nanga achite kumusandutsa mlongo wathu ngati mkazi wachiwerewere?” ");
INSERT INTO nya_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Tsono Mulungu anati kwa Yakobo, “Nyamuka uchoke kuno kupita ku Beteli. Kumeneko ukamange guwa lansembe la Mulungu amene anadza kwa iwe pamene umathawa Esau, mʼbale wako.” ");
INSERT INTO nya_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Choncho Yakobo anawuza a pa banja pake ndi onse amene anali naye kuti, “Chotsani milungu yachilendo imene muli nayo, ndipo mudziyeretse nokha ndi kusintha zovala zanu. ");
INSERT INTO nya_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Tiyeni tinyamuke kuchoka kuno kupita ku Beteli. Kumeneko ndikamumangira guwa lansembe Mulungu amene anandithandiza pa nthawi za masautso anga, komanso amene wakhala nane mʼmayendedwe anga onse.” ");
INSERT INTO nya_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Choncho anamupatsa Yakobo milungu yachilendo yonse imene anali nayo pamodzi ndi ndolo. Iye anazikwirira pansi pa mtengo wa thundu ku Sekemu. ");
INSERT INTO nya_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Pamenepo ananyamuka, ndipo mtima woopa Mulungu unagwera anthu onse a mʼmizinda yozungulira, kotero kuti palibe aliyense amene anatsatira banja la Yakobo. ");
INSERT INTO nya_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakobo ndi anthu onse anali naye aja anafika ku Luzi (ku Beteli) mu dziko la Kanaani. ");
INSERT INTO nya_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Kumeneko anamanga guwa lansembe nalitcha Eli Beteli, chifukwa kunali kumeneko kumene Mulungu anadziwulula yekha kwa Yakobo pamene ankathawa mʼbale wake. ");
INSERT INTO nya_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Debora mlezi wa Rakele anamwalira komweko nayikidwa mʼmanda pansi pa mtengo wa thundu cha kumunsi kwa Beteli. Choncho panatchedwa Aloni-Bakuti (mtengo wamaliro). ");
INSERT INTO nya_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakobo atabwera kuchokera ku Padanaramu, Mulungu anabweranso kwa iye namudalitsa. ");
INSERT INTO nya_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Mulungu anati kwa iye, “Dzina lako ndiwe Yakobo, koma sudzatchedwanso Yakobo; koma udzatchedwa Israeli.” Choncho anamutcha iye Israeli. ");
INSERT INTO nya_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ndipo Mulungu anati kwa iye, “Ine ndine Mulungu Wamphamvuzonse; berekanani ndi kuchulukana. Mtundu wa anthu, inde, mitundu yambiri ya anthu idzatuluka mwa iwe, ndipo ena mwa zidzukulu zako adzakhala mafumu. ");
INSERT INTO nya_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Dziko limene ndinapereka kwa Abrahamu ndi Isake ndiliperekanso kwa iwe. Lidzakhala lako ndi la zidzukulu zako.” ");
INSERT INTO nya_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Kenaka Mulungu anamusiya Yakobo. ");
INSERT INTO nya_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakobo anayika mwala wachikumbutso pa malo pamene Mulungu anayankhula naye paja. Iye anathirapo nsembe yachakumwa ndi yamafuta. ");
INSERT INTO nya_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakobo anawatcha malo amene Mulungu anayankhula naye aja kuti Beteli. ");
INSERT INTO nya_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Kenaka anachoka ku Beteli. Koma ali pafupi kufika ku Efurata nthawi yakuti Rakele aone mwana inakwana. Iye anavutika pobereka. ");
INSERT INTO nya_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Akanali chivutikire choncho, mzamba anamulimbikitsa nati, “Usaope pakuti ubala mwana wina wamwamuna.” ");
INSERT INTO nya_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Tsono pamene Rakele ankapuma wefuwefu (popeza ankamwalira) iye anatcha mwana uja kuti Beni-Oni. Koma abambo ake anamutcha kuti Benjamini. ");
INSERT INTO nya_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Choncho Rakele anamwalira ndipo anayikidwa pa njira yopita ku Efurata (Kumeneko ndiye ku Betelehemu). ");
INSERT INTO nya_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Pa manda ake, Yakobo anayimika mwala wachikumbutso wa pa manda ndipo ulipobe mpaka lero. ");
INSERT INTO nya_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israeli (Yakobo) anasunthanso nakamanga tenti yake kupitirira nsanja ya Ederi. ");
INSERT INTO nya_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Israeli akanali mʼderali, Rubeni anapita nakagonana ndi Biliha, mdzakazi wa abambo ake. Yakobo uja anazimva zimenezi. Yakobo anali ndi ana aamuna khumi ndi awiri: ");
INSERT INTO nya_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ana a Leya ndi awa: Rubeni anali mwana woyamba wa Yakobo, Simeoni, Levi, Yuda, Isakara, ndi Zebuloni. ");
INSERT INTO nya_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ana a Rakele ndi awa: Yosefe ndi Benjamini. ");
INSERT INTO nya_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ana a Biliha, wantchito wa Rakele ndi awa: Dani ndi Nafutali. ");
INSERT INTO nya_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ana a Zilipa wantchito wa Leya ndi awa: Gadi ndi Aseri. Awa ndiwo ana a Yakobo amene anabadwira ku Padanaramu. ");
INSERT INTO nya_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakobo anafika ku mudzi kwa abambo ake Isake ku Mamre, (kumene kunkatchedwa ku Kiriyati-Ariba kapenanso Hebroni) kumene Abrahamu ndi Isake anakhalako kale. ");
INSERT INTO nya_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isake anakhala ndi moyo zaka 180. ");
INSERT INTO nya_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Anamwalira ali wokalamba kwambiri ndipo anakakhala ndi anthu a mtundu wake. Ndipo ana ake Esau ndi Yakobo anamuyika mʼmanda. ");
INSERT INTO nya_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Nazi zidzukulu za Esau amene ankatchedwanso Edomu: ");
INSERT INTO nya_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau anakwatira akazi atatu a ku Kanaani. Iwowa ndiwo Ada mwana wa Eloni Mhiti; Oholibama mwana wa Ana amene anali mwana wa Zibeoni Mhivi ");
INSERT INTO nya_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ndi Basemati mwana wa Ismaeli, amenenso anali mlongo wa Nabayoti. ");
INSERT INTO nya_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada anaberekera Esau, Elifazi; Basemati anabereka Reueli; ");
INSERT INTO nya_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ndipo Oholibama anabereka Yeusi, Yolamu ndi Kora. Amenewa anali ana a Esau amene anabadwira ku Kanaani. ");
INSERT INTO nya_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau anatenga akazi ake, ana ake aamuna ndi aakazi ndi ena onse a pa banja pake. Anatenganso ziweto zake ndi ziweto zake zonse pamodzi ndi katundu wake yense amene anamupata ku Kanaani, ndipo anachoka ku dziko la Kanaani kupatukana ndi mʼbale wake Yakobo. ");
INSERT INTO nya_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Iwo anatero chifukwa dziko limene ankakhalamo silikanakwanira awiriwo. Iwowa anali ndi ziweto zochuluka motero kuti sakanatha kukhala pamodzi. ");
INSERT INTO nya_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Choncho Esau (amene ndi Edomu) anakakhazikika ku dziko la mapiri ku Seiri. ");
INSERT INTO nya_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Nazi zidzukulu za Esau, kholo la Aedomu amene ankakhala ku Seiri. ");
INSERT INTO nya_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Awa ndi mayina a ana aamuna a Esau: Elifazi, mwana wa Ada, mkazi wa Esau, ndi Reueli, mwana wamwamuna wa Basemati, mkazi wa Esau. ");
INSERT INTO nya_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Awa ndi mayina a ana a Elifazi: Temani, Omari, Zefo, Gatamu ndi Kenazi. ");
INSERT INTO nya_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna anali mzikazi wa Elifazi, mwana wa Esau. Iyeyo anaberekera Elifazi mwana dzina lake Amaleki. Amenewa ndiwo zidzukulu za Ada, mkazi wa Esau. ");
INSERT INTO nya_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Awa ndi ana a Reueli: Nahati, Zera, Sama ndi Miza. Amenewa ndi ana a Basemati, mkazi wa Esau. ");
INSERT INTO nya_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ana aamuna a Oholibama, mkazi wa Esau, mwana wa Ana ndi mdzukulu wa Zebeoni ndi awa: Yeusi, Yolamu ndi Kora. ");
INSERT INTO nya_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Nawa mafumu a zidzukulu za Esau: Mwa ana a Elifazi, mwana woyamba wa Esau panali mafumu awa: Temani, Omari, Zefo, ndi Kenazi, ");
INSERT INTO nya_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatamu, ndi Amaleki. Awa anali mafumu mwa ana a Elifazi ku Edomu ndipo onsewa anali zidzukulu za Ada. ");
INSERT INTO nya_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Mwa ana a Reueli, mwana wa Esau munali mafumu awa: Nahati, Zera, Sama ndi Miza. Awa anali mafumu mwa ana a Reueli ku Edomu. Iwowa anali zidzukulu za Basemati mkazi wa Esau. ");
INSERT INTO nya_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Mwa ana a Oholibama, mkazi wa Esau munali mafumu awa: Yeusi, Yolamu, ndi Kora. Amenewa anali mafumu mwa ana a mkazi wa Esau, Oholibama, mwana wa Ana. ");
INSERT INTO nya_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Amenewa ndiwo zidzukulu za Esau (amene ndi Edomu) ndiponso mafumu awo. ");
INSERT INTO nya_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Awa ndi ana a Seiri Mhori, amene ankakhala mʼdzikomo: Lotani, Sobala, Zibeoni, Ana, ");
INSERT INTO nya_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disoni, Ezeri ndi Disani. Amenewa ndiwo ana a Seiri a ku Edomu ndipo analinso mafumu a Ahori. ");
INSERT INTO nya_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ana aamuna a Lotani anali awa: Hori ndi Homamu. Timna anali mlongo wake wa Lotani. ");
INSERT INTO nya_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ana aamuna a Sobala anali awa: Alivani, Manahati, Ebala, Sefo ndi Onamu. ");
INSERT INTO nya_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ana aamuna a Zibeoni anali awa: Ayiwa ndi Ana. Uyu ndi Ana amene anapeza akasupe a madzi amoto mʼchipululu pamene ankadyetsa abulu abambo wake Zibeoni. ");
INSERT INTO nya_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana a Ana anali: Disoni ndi Oholibama mwana wake wamkazi. ");
INSERT INTO nya_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ana aamuna a Disoni anali awa: Hemudani, Esibani, Itirani ndi Kerani. ");
INSERT INTO nya_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ana aamuna a Ezeri anali awa: Bilihani, Zaavani ndi Akani. ");
INSERT INTO nya_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ana aamuna a Disani anali awa: Uzi ndi Arani. ");
INSERT INTO nya_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Mafumu a Ahori anali awa: Lotani, Sobala, Zibeoni, Ana, ");
INSERT INTO nya_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disoni, Ezeri ndi Disani. Amenewa ndiwo mafumu a Ahori, monga mwa mafuko awo, mʼdziko la Seiri. ");
INSERT INTO nya_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Awa ndi mafumu amene ankalamulira dziko la Edomu, mfumu iliyonse ya Israeli isanayambe kulamulira kumeneko: ");
INSERT INTO nya_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela mwana wa Beori anakhala mfumu ya ku Edomu. Mzinda wake ankawutcha Dinihaba. ");
INSERT INTO nya_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela atamwalira, Yobabu mwana wa Zera wochokera ku Bozira analowa ufumu mʼmalo mwake. ");
INSERT INTO nya_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Atafa Yobabu, Husamu wochokera ku dziko la Atemani, analowa mʼmalo mwake ngati mfumu. ");
INSERT INTO nya_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husamu atamwalira, Hadadi mwana wa Bedadi, amene anagonjetsa Amidiyani mʼdziko la Mowabu, analowa ufumu mʼmalo mwake. Mzinda wake unkatchedwa Aviti. ");
INSERT INTO nya_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadi atamwalira, Samila wochokera ku Masireka, analowa ufumu mʼmalo mwake. ");
INSERT INTO nya_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samila atamwalira, Sauli wochokera ku Rehoboti wa ku Mtsinje, analowa ufumu mʼmalo mwake. ");
INSERT INTO nya_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sauli atamwalira, Baala-Hanani, mwana wa Akibori analowa ufumu mʼmalo mwake. ");
INSERT INTO nya_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Pamene Baala-Hanani mwana wa Akibori anamwalira, Hadari analowa ufumu mʼmalo mwake. Mzinda wake unkatchedwa Pau, ndipo dzina la mkazi wake linali Mehatabeli, mwana wamkazi wa Matiredi, mwana wamkazi wa Me-Zahabu. ");
INSERT INTO nya_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Mayina a mafumu ochokera mwa zidzukulu za Esau malingana ndi mafuko awo ndi malo a fuko lililonse anali awa: Timna, Aliva, Yeteti, ");
INSERT INTO nya_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinoni, ");
INSERT INTO nya_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenazi, Temani, Mibezari, ");
INSERT INTO nya_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magidieli ndi Iramu. Awa anali mafumu a ku Edomu molingana ndi malo awo okhala mʼdzikomo. Umenewu ndi mndandanda wa mʼbado wa Esau, kholo la Aedomu. ");
INSERT INTO nya_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakobo ankakhala mʼdziko la Kanaani kumene abambo ake ankakhala. ");
INSERT INTO nya_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Mbiri ya banja la Yakobo ndi iyi: Yosefe, mnyamata wa zaka 17 ankaweta nkhosa ndi abale ake, pamodzi ndi ana a Biliha ndi Zilipa, akazi a abambo ake. Tsono Yosefe ankabwera kudzawuza abambo ake zoyipa za abale ake. ");
INSERT INTO nya_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Tsono Israeli ankakonda Yosefe koposa ana ake ena onse, chifukwa anali mwana wobadwa muukalamba wake. Ndipo anamusokera mkanjo wa manja aatali. ");
INSERT INTO nya_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Pamene abale ake anaona kuti abambo awo ankakonda Yosefe kuposa aliyense wa iwo, anayamba kumuda Yosefe ndipo sankayankhula naye zamtendere. ");
INSERT INTO nya_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Tsiku lina Yosefe analota maloto ndipo pamene anawuza abale ake za malotowo, iwo anawonjeza kumuda. ");
INSERT INTO nya_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Iye anawawuza kuti, “Tamvani maloto amene ndinalota: ");
INSERT INTO nya_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ife timamanga mitolo ya tirigu ku munda ndipo mwadzidzidzi mtolo wanga unayimirira chilili, pamene mitolo yanu inazungulira mtolo wangawo nʼkumawugwadira.” ");
INSERT INTO nya_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Abale ake aja anamufunsa nati, “Kodi ukuyesa kuti ungakhale mfumu yathu? Ungadzatilamuliredi iweyo?” Ndipo anamuda kuposa kale chifukwa cha maloto ake ndi zimene ankakonda kunena kwa abambo awo. ");
INSERT INTO nya_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Tsiku lina analotanso maloto ena, ndipo anafotokozera abale ake za malotowo. Iye anati, “Tamverani, ndinalotanso maloto ena. Ulendo uno dzuwa ndi mwezi pamodzi ndi nyenyezi khumi ndi imodzi zimandigwadira.” ");
INSERT INTO nya_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Atawuza abambo ake ndi abale ake malotowa, abambo ake anamukalipira nati, “Ndi maloto anji umalotawa? Kodi uganiza kuti ine, amayi ako pamodzi ndi abale ako onsewa tingadzabwere kudzakugwandira iwe?” ");
INSERT INTO nya_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Abale ake anamuchitira nsanje, koma abambo ake anasunga nkhaniyi mu mtima. ");
INSERT INTO nya_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Tsono abale ake anapita kukadyetsa ziweto za abambo awo ku Sekemu, ");
INSERT INTO nya_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ndipo Israeli anati kwa Yosefe, “Tsono, ndikufuna kukutuma kwa abale ako.” Iye anayankha nati, “Chabwino.” ");
INSERT INTO nya_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Choncho anati kwa iye, “Pita ukaone ngati abale ako ali bwino. Ukaonenso nkhosa ngati zili bwino. Kenaka ubwere udzandiwuze.” Choncho Israeli anatuma Yosefe kuchokera ku chigwa cha Hebroni. Yosefe atafika ku Sekemu, ");
INSERT INTO nya_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","munthu wina anamupeza akungozungulirazungulira mʼmunda ndipo anamufunsa, “Ukufunafuna chiyani?” ");
INSERT INTO nya_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Iye anayankha, “Ndikufuna abale anga. Mungandiwuze kumene akudyetsa ziweto zawo?” ");
INSERT INTO nya_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Munthuyo anayankha nati, “Anasamukako kuno. Ndinawamva akuti, ‘Tiyeni tipite ku Dotani.’ ” Choncho Yosefe analondola abale ake ndipo anakawapeza ku Dotani. ");
INSERT INTO nya_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Abale ake aja anamuonera patali. Ndipo asanafike nʼkomwe kumene kunali iwo kuja, anayamba kale kumupangira chiwembu choti amuphe. ");
INSERT INTO nya_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Iwo anawuzana nati, “Uyo akubwera apo wamaloto uja. ");
INSERT INTO nya_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Tsono tiyeni timuphe ndi kuponya thupi lake mu chimodzi mwa zitsime izi ndipo tidzati anadyedwa ndi nyama zakuthengo zolusa. Tsono timuonera zomwe ziti zichitike ndi maloto ake aja.” ");
INSERT INTO nya_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Koma Rubeni atamva izi, anapulumutsa Yosefe. Iye anati kwa abale ake, “Ayi, tisamuphe, ");
INSERT INTO nya_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","tisakhetse magazi. Tiyeni timuponye mʼchitsime ku chipululu konkuno. Koma tisamuvulaze nʼkomwe. Rubeni ananena zonsezi kuti apulumutse Yosefe ndi kuti pambuyo pake akamupereke kwa abambo awo.” ");
INSERT INTO nya_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Choncho Yosefe atafika kwa abale ake, iwo anamuvula mkanjo wake wamanja aatali uja umene anavala ");
INSERT INTO nya_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ndipo anamutenga namuponya mʼchitsime chopanda madzi komanso mopanda chilichonse. ");
INSERT INTO nya_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Atakhala pansi kuti adye chakudya, anatukula maso naona gulu la Aismaeli akubwera kuchokera ku Giliyadi. Ngamira zawo zinanyamula zonunkhiritsa bwino zakudya zamitundumitundu, ndipo zimenezi ankapita nazo ku Igupto. ");
INSERT INTO nya_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda anafunsa abale ake nati, “Kodi tidzapindula chiyani tikapha mʼbale wathuyu ndi kuphimbitsa magazi ake? ");
INSERT INTO nya_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Bwanji timugulitse kwa Aismaeliwa, koma ife tisamuchite kanthu kalikonse. Ameneyu ndi mʼbale wathu thupi limodzi ndi ife.” Abale ake anavomereza zimenezi. ");
INSERT INTO nya_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Amalonda ena a ku Midiyani ankadutsa pomwepo. Tsono abale ake a Yosefe anamutulutsa Yosefe uja mu chitsime chija ndipo anamugulitsa kwa Aismaeli aja pamtengo wa masekeli makumi awiri. Choncho anapita naye Yosefe ku Igupto. ");
INSERT INTO nya_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rubeni atabwerera ku chitsime kuja anapeza kuti Yosefe mulibe mʼchitsimemo. Pamenepo iye anangʼamba zovala zake ");
INSERT INTO nya_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","nabwerera kwa abale ake nati, “Mnyamata uja mulibemo! Nanga ndilowere kuti ine tsopano?” ");
INSERT INTO nya_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Tsono anapha kamwana ka mbuzi, natenga mkanjo wa Yosefe ndi kuwunyika mʼmagazi ake. ");
INSERT INTO nya_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Iwo anatenga mkanjo uja nabwerera nawo kwa abambo awo nati, “Ife tapeza mkanjowu. Tawuyangʼanitsitsani muone ngati uli wa mwana wanu.” ");
INSERT INTO nya_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Iye anawuzindikira ndipo anati, “Ndi mkanjo wa mwana wanga umenewu! Nyama yakuthengo yolusa yamudya. Mosakayika, mwana wanga Yosefe wakhadzulidwa.” ");
INSERT INTO nya_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Pamenepo Yakobo anangʼamba zovala zake, navala chisaka mʼchiwuno mwake. Iye analira maliro a mwana wake masiku ambiri. ");
INSERT INTO nya_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ngakhale kuti ana ake onse aamuna ndi aakazi anasonkhana kudzamutonthoza, iye anakana kutonthozedwa. Iye anati, “Ayi. Ndidzalira mpaka ndidzapite kwa mwana wanga ku manda.” Choncho Israeli anapitirirabe kulira mwana wake. ");
INSERT INTO nya_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Amidiyani aja anagulitsa Yosefe kwa Potifara, mmodzi mwa nduna za Farao ku Igupto. Potifarayu anali mkulu wa asilikali olonda nyumba ya Farao. ");
INSERT INTO nya_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Pa nthawi imeneyi, Yuda anasiyana ndi abale ake napita kukakhala ndi munthu wina wa ku Adulamu wotchedwa Hira. ");
INSERT INTO nya_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Kumeneko, Yuda anaona mwana wamkazi wa munthu wina wa Chikanaani wotchedwa Suwa. Anamukwatira nagona naye malo amodzi. ");
INSERT INTO nya_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Iye anatenga pathupi, nabala mwana wamwamuna amene anamutcha Eri. ");
INSERT INTO nya_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Anatenganso pathupi nabala mwana wa mwamuna ndipo anamutcha Onani. ");
INSERT INTO nya_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Anaberekanso mwana wina wamwamuna ndipo anamutcha Sela. Ameneyu anabadwa Yuda ali ku Kezibi. ");
INSERT INTO nya_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yuda anamupezera mkazi mwana wake woyamba uja Eri, ndipo dzina la mkaziyo linali Tamara. ");
INSERT INTO nya_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Koma ntchito zoyipa za Eri, mwana wachisamba wa Yuda zinayipira Yehova. Choncho Mulungu anamulanga ndi imfa. ");
INSERT INTO nya_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Pamenepo Yuda anati kwa Onani, “Kwatira mkazi wamasiye wa mʼbale wako. Ulowe chokolo kuti mʼbale wako akhale ndi mwana.” ");
INSERT INTO nya_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Koma Onani anadziwa kuti mwanayo sadzakhala wake. Choncho nthawi zonse pamene amagona naye mkaziyo, ankatayira umuna pansi kuti asamuberekere mwana mʼbale wake. ");
INSERT INTO nya_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Zimene ankachitazi zinayipira Yehova. Choncho anamulanganso ndi imfa. ");
INSERT INTO nya_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Kenaka Yuda anati kwa mpongozi wake Tamara, “Bwererani ku nyumba ya abambo anu ndi kukhala kumeneko ngati wamasiye mpaka mwana wanga Sela atakula.” Ananena izi chifukwa ankaopa kuti Sela angafenso ngati abale ake aja. Choncho Tamara anapita kukakhala ku nyumba ya abambo ake. ");
INSERT INTO nya_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Patapita nthawi yayitali, Batishua, mkazi wa Yuda anamwalira. Yuda atatha kulira maliro a mkazi wake, anapita, iyeyu pamodzi ndi bwenzi lake Hira, Mwadulamu uja, ku Timna kumene ankameta nkhosa zawo. ");
INSERT INTO nya_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamara atamva kuti apongozi ake akupita ku Timna kukameta nkhosa, ");
INSERT INTO nya_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","iye anavula zovala zake za umasiye, nadziphimba nkhope ndi nsalu kuti asadziwike, ndipo anakhala pansi pa chipata cha ku Enaimu popita ku Timna. Tamara anachita izi chifukwa anaona kuti ngakhale Selayo anali atakula tsopano, iye sanaperekedwe kuti amulowe chokolo. ");
INSERT INTO nya_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuda atamuona anangomuyesa mkazi wadama chabe, chifukwa anadziphimba nkhope. ");
INSERT INTO nya_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Tsono anapita kwa mkaziyo pamphepete pa msewu paja nati, “Tabwera ndigone nawe.” Apa Yuda sankadziwa kuti mkazi uja anali mpongozi wake. Ndiye mkazi uja anamufunsa Yuda nati, “Mudzandipatsa chiyani kuti ndigone nanu?” ");
INSERT INTO nya_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Iye anati, “Ndidzakutumizira kamwana kambuzi ka mʼkhola mwanga.” Mkaziyo anayankha kuti, “Chabwino, ndavomera, koma mungandipatse chikole mpaka mutanditumizira mbuziyo?” ");
INSERT INTO nya_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Iye anati, “Ndikupatse chikole chanji?” Mkaziyo anayankha, “Mundipatse mphete yanuyo, chingwe chanucho pamodzi ndi ndodo imene ili mʼdzanja lanulo.” Choncho anazipereka kwa iye nagona naye ndipo anatenga pathupi. ");
INSERT INTO nya_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Kenaka Tamara anachoka, navula nsalu anadziphimba nayo ija, navalanso zovala zake za umasiye zija. ");
INSERT INTO nya_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Tsono Yuda anatuma bwenzi lake Mwadulamu uja ndi kamwana kambuzi kaja kuti akapereke kwa mkazi wadama uja, ndi kuti akatero amubwezere chikole chake chija. Koma atafika sanamupezepo. ");
INSERT INTO nya_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Anawafunsa anthu a komweko, “Kodi mkazi wadama uja amene ankakhala pambali pa msewu wa ku Enaimu, ali kuti?” Iwo anayankha, “Sipanakhalepo mkazi wa dama aliyense pano.” ");
INSERT INTO nya_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Choncho anabwerera kwa Yuda nati, “Sindinamupeze mkazi uja. Kuwonjeza apo, anthu a kumeneko amati, ‘Sipanakhalepo mkazi wadama pano.’ ” ");
INSERT INTO nya_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Pamenepo Yuda anati, “Mulekeni atenge zinthuzo zikhale zake, kuopa kuti anthu angatiseke. Ine sindinalakwe, ndinamutumizira kamwana kambuzika, koma simunamupeze.” ");
INSERT INTO nya_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Patapita miyezi itatu, Yuda anawuzidwa kuti, “Mpongozi wanu Tamara anachita zadama, ndipo zotsatira zake nʼzakuti ali ndi pathupi.” Yuda anati, “Kamutulutseni ndipo mukamutenthe kuti afe!” ");
INSERT INTO nya_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Akumutulutsa, iye anatuma mawu kwa apongozi ake. Anati, “Ndili ndi pathupi pa munthu amene ndi mwini wake wa zinthu izi. Taziyangʼanitsitsani, kodi mwini wa khoza, chingwe ndi ndodo yoyenderayi ndi yani?” ");
INSERT INTO nya_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda anazizindikira zinthuzo ndipo anati, “Uyu ndi wolungama kuposa ine, chifukwa sindinamupereke kwa mwana wanga Sela.” Ndipo Yuda sanagone nayenso. ");
INSERT INTO nya_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Pamene Tamara nthawi inamukwanira yoti abeleke, mʼmimbamo munali mapasa. ");
INSERT INTO nya_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Pamene ankabereka, mmodzi wa iwo anatulutsa dzanja lake. Choncho mzamba anatenga kawulusi kofiira nakamangirira pa mkono pa mwanayo nati, “Uyu ndiye anayamba kubadwa.” ");
INSERT INTO nya_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Koma pamene anabweza mkonowo, mʼbale wake anabadwa ndipo mzamba anati, “Wachita kudziphotcholera wekha njira chonchi!” Ndipo anamutcha Perezi. ");
INSERT INTO nya_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Pambuyo pake mʼbale wake amene anali ndi ulusi wofiira pa mkono wake uja anabadwa ndipo anapatsidwa dzina lakuti Zera. ");
INSERT INTO nya_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Tsopano Yosefe anatengedwa kupita ku Igupto. Potifara Mwigupto amene anali mmodzi wa akuluakulu a Farao ndiponso mkulu wa asilikali olonda ku nyumba kwa Farao, anagula Yosefe kwa Aismaeli amene anapita naye kumeneko. ");
INSERT INTO nya_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Koma Yehova anali ndi Yosefe ndipo zake zonse zimayenda bwino. Iye ankakhala mʼnyumba ya mbuye wake wa ku Igupto. ");
INSERT INTO nya_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Mbuye wake anaona kuti Yehova anali naye Yosefe ndi kuti pa chilichonse chimene anachita Yehova ankaonetsetsa kuti achite bwino. ");
INSERT INTO nya_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potifara anakondwera ndi Yosefe chifukwa cha matumikiridwe ake. Choncho anamusandutsa woyangʼanira nyumba yake ndi zonse za mʼnyumba yake. ");
INSERT INTO nya_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Kuchokera pa nthawi imene anamuyika kukhala woyangʼanira wa nyumbayo ndi zonse za mʼnyumbamo, Yehova anadalitsa nyumba ya Mwiguptoyo chifukwa cha Yosefe. Madalitso a Yehova anali pa chilichonse chimene Potifara anali nacho, za mʼnyumba komanso za ku munda. ");
INSERT INTO nya_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Choncho anasiyira mʼmanja mwa Yosefe chilichonse chomwe anali nacho, kotero kuti samadandaula ndi chilichonse kupatula chakudya chimene ankadya. Tsopano Yosefe anali wa thupi labwino ndi wokongola. ");
INSERT INTO nya_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Patapita kanthawi, mkazi wa mbuye wake anayamba kusirira Yosefe nati, “Bwanji ugone nane!” ");
INSERT INTO nya_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Koma iye anakana namuwuza kuti, “Inu mukuona kuti mbuye wanga sadandaula ndi kena kalikonse mʼnyumba muno, ndipo chawo chilichonse anachiyika mʼmanja mwanga. ");
INSERT INTO nya_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Motero kuti palibe wina wamkulu kuposa ine mʼnyumba muno. Ndipo palibe chilichonse chimene mbuye wanga sanachipereke kwa ine kupatula inuyo, chifukwa ndinu mkazi wake. Tsono ndingachite bwanji choyipa choterechi ndi kuchimwira Mulungu?” ");
INSERT INTO nya_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ndipo ngakhale kuti iye anayankhula mawu omwewa ndi Yosefe tsiku ndi tsiku, Yosefe sanalole kugona naye ngakhale kukhala naye pafupi. ");
INSERT INTO nya_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Tsiku lina Yosefe analowa mʼnyumbamo kukagwira ntchito zake, ndipo munalibe wina aliyense wantchito mʼnyumbamo. ");
INSERT INTO nya_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Mkazi uja anamugwira mkanjo Yosefe nati, “Tiye ugone nane!” Koma Yosefe anasiya mkanjo wake mʼmanja mwa mkaziyo nathawira kunja kwa nyumba. ");
INSERT INTO nya_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Pamene mkazi uja anaona kuti Yosefe wamusiyira mkanjo wake mʼmanja mwake nathawira kunja kwa nyumba, ");
INSERT INTO nya_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","iye anayitana antchito ake a mʼnyumba nati, “Taonani mwamuna wanga anabwera ndi Mhebri uyu mʼnyumba muno kuti adzagone nane. Iyeyu analowa ku chipinda kwanga kuti adzagone nane ndipo ine ndinakuwa kwambiri. ");
INSERT INTO nya_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Atandimva ndikukuwa, anandisiyira mkanjo wakewu nʼkuthawira kunja.” ");
INSERT INTO nya_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Tsono mkazi wa Potifara uja anasunga mkanjowo mpaka mbuye wake wa Yosefe atabwera ku nyumba. ");
INSERT INTO nya_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Tsono anamuwuza nkhaniyi nati: “Wantchito Wachihebri amene munatibweretsera uja anabwera kuti adzagone nane. ");
INSERT INTO nya_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Koma pamene ndinakuwa, iye anandisiyira mkanjo wake nathawira kunja.” ");
INSERT INTO nya_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Mbuye wake wa Yosefe atamva nkhani imene mkazi wake anamuwuza kuti, “Ndi zimene anandichitira wantchito wanu,” anapsa mtima kwambiri. ");
INSERT INTO nya_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Tsono iye anatenga Yosefe namuyika mʼndende mmene ankasungiramo amʼndende a mfumu. Ndipo Yosefe anakhala mʼndendemo ");
INSERT INTO nya_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","koma Yehova anali naye, ndipo anamuonetsa kukoma mtima kwake, kotero kuti woyangʼanira ndende anakondwera ndi Yosefe. ");
INSERT INTO nya_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Choncho woyangʼanira ndende uja anamuyika Yosefe kukhala woyangʼanira onse amene anayikidwa mʼndende. Ndiponso anamupatsa udindo woyangʼanira zonse zochitika mʼndendemo. ");
INSERT INTO nya_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Woyangʼanira ndende uja sankayangʼaniranso china chilichonse chimene chinali mu ulamuliro wa Yosefe, chifukwa Yehova anali ndi Yosefe. Ndipo Yehova anaonetsetsa kuti chilichonse chimene Yosefe ankachita chimuyendere bwino. ");
INSERT INTO nya_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Patapita nthawi, woperekera zakumwa ndi wopanga buledi a ku nyumba kwa mfumu ya ku Igupto analakwira mbuye wawoyo. ");
INSERT INTO nya_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Farao anapsa mtima ndi akuluakulu awiriwa, ");
INSERT INTO nya_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ndipo anakawatsekera mʼndende, nakawayika mʼmanja mwa mkulu wa asilikali olonda ku nyumba kwa mfumu kuja, mʼndende momwe Yosefe ankasungidwamo. ");
INSERT INTO nya_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Mkulu wa alonda aja anawapereka mʼmanja mwa Yosefe, ndipo iye anawasamalira. Iwo anakhala mʼndendemo kwa kanthawi. ");
INSERT INTO nya_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Usiku wina, aliyense wa anthu awiriwa, wopereka zakumwa pamodzi ndi wopanga buledi wa ku nyumba ya mfumu ya ku Igupto aja, amene ankasungidwa mʼndende, analota maloto. Malotowo anali ndi tanthauzo lake. ");
INSERT INTO nya_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Mmawa wake, Yosefe atabwera, anaona kuti nkhope zawo zinali zakugwa. ");
INSERT INTO nya_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Choncho anafunsa akuluakulu a kwa Farao amene anali naye mʼndende muja kuti, “Bwanji nkhope zanu zili zachisoni lero?” ");
INSERT INTO nya_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Iwo anayankha, “Tonse awiri talota maloto, koma palibe wotitanthauzira malotowo.” Pamenepo Yosefe anawawuza kuti, “Ndi Mulungu yekha amene amapereka matanthauzo a maloto. Uzeni ine maloto anu.” ");
INSERT INTO nya_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Choncho mkulu wa operekera zakumwa uja anamuwuza Yosefe maloto ake. Anati, “Mʼmaloto anga ndinaona mtengo wa mpesa, ");
INSERT INTO nya_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","unali ndi nthambi zitatu. Mpesawo utangophukira, unachita maluwa ndipo maphava ake anabereka mphesa zakupsa. ");
INSERT INTO nya_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Chikho cha Farao chinali mʼmanja mwanga, ndipo ndinatenga mphesa, kupsinyira mu chikho cha Farao ndi kuchipereka mʼmanja mwake.” ");
INSERT INTO nya_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yosefe anati kwa iye, “Tanthauzo lake ndi ili: Nthambi zitatuzo ndi masiku atatu. ");
INSERT INTO nya_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Pakangopita masiku atatu, Farao adzakutulutsa muno. Udzaperekera zakumwa kwa Farao monga momwe umachitira poyamba. ");
INSERT INTO nya_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Koma zako zikakuyendera bwino, udzandikumbukire ndi kundikomera mtima. Chonde ukandipepesere kwa Farao kuti anditulutse muno. ");
INSERT INTO nya_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Popezatu ine anangochita mondiba kubwera nane kuno kuchokera ku dziko la Ahebri, ndipo ngakhale kunoko, ine sindinalakwe kali konse kuti ndizipezeka mʼdzenje muno.” ");
INSERT INTO nya_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Mkulu wa opanga buledi ataona kuti Yosefe wapereka tanthauzo labwino, anati kwa Yosefe, “Inenso ndinalota nditasenza nsengwa zitatu za buledi. ");
INSERT INTO nya_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Mu nsengwa yapamwamba munali zakudya zamitundumitundu za Farao, koma mbalame zimadya zakudyazo.” ");
INSERT INTO nya_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yosefe anati, “Tanthauzo lake ndi ili: nsengwa zitatuzo ndi masiku atatu. ");
INSERT INTO nya_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Pakangotha masiku atatu Farao adzakutulutsa muno koma adzakupachika. Ndipo mbalame zidzadya mnofu wako.” ");
INSERT INTO nya_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Tsono tsiku lachitatulo linali lokumbukira kubadwa kwa Farao, ndipo anawakonzera phwando akuluakulu ake onse. Anatulutsa mʼndende mkulu wa operekera zakumwa ndi mkulu wa ophika buledi, ndipo anawayimiritsa pamaso pa nduna zake. ");
INSERT INTO nya_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Tsono Farao anamubwezera mkulu wa operekera zakumwa uja pa udindo wake, kotero kuti anayamba kuperekeranso zakumwa kwa Farao, ");
INSERT INTO nya_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","koma mkulu wa ophika buledi anamupachika, mofanana ndi mmene Yosefe anatanthauzira maloto. ");
INSERT INTO nya_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Koma mkulu wa operekera zakumwa uja sanamukumbukire Yosefe ndipo anamuyiwaliratu. ");
INSERT INTO nya_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Patapita zaka ziwiri zathunthu, Farao analota atayimirira mʼmbali mwa mtsinje wa Nailo, ");
INSERT INTO nya_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ndipo anangoona ngʼombe zazikazi zisanu ndi ziwiri zooneka bwino ndi zonenepa zikutuluka mu mtsinje muja ndi kuyamba kudya msipu wa mu mawango. ");
INSERT INTO nya_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Kenaka ngʼombe zina zazikazi zisanu ndi ziwiri zosaoneka bwino ndi zowonda zinatulukanso mu mtsinje wa Nailo ndipo zinayimirira pambali pa zina zija zimene zinali mʼmphepete mwa mtsinje uja. ");
INSERT INTO nya_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ndipo ngʼombe zosaoneka bwino ndi zowonda zija zinadya ngʼombe zonenepa zija. Kenaka Farao anadzidzimuka. ");
INSERT INTO nya_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Posakhalitsa anagonanso ndipo analota kachiwiri: Analota ngala zisanu ndi ziwiri za tirigu zathanzi labwino zitabala pa phata limodzi. ");
INSERT INTO nya_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Kenaka ngala zina zisanu ndi ziwiri zinaphuka. Izi zinali zowonda ndi zowauka ndi mphepo ya kummawa. ");
INSERT INTO nya_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ngala zowonda zija zinameza ngala zathanzi ndi zonenepa zija. Farao anadzidzimuka ndipo anaona kuti anali maloto chabe. ");
INSERT INTO nya_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Mmawa, Farao anavutika mu mtima kotero anayitanitsa amatsenga ndi anzeru onse a mu Igupto. Iwo atabwera, iye anawawuza maloto ake, koma panalibe ndi mmodzi yemwe amene anatha kutanthauzira malotowo kwa Farao. ");
INSERT INTO nya_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ndipo mkulu wa operekera zakumwa anati kwa Farao, “Lero ndakumbukira kulephera kwanga. ");
INSERT INTO nya_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Paja nthawi ina Farao anapsera mtima antchito akefe, ndipo anatitsekera (ine ndi mkulu wa ophika buledi) mʼndende, mʼnyumba ya mkulu wa alonda. ");
INSERT INTO nya_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Tsiku lina tonse awiri tinalota maloto, ndipo loto lililonse linali ndi tanthauzo lake. ");
INSERT INTO nya_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Tsono momwemo munali mnyamata wina Wachihebri, wantchito wa mkulu wa alonda. Ife tinamufotokozera maloto athu, ndipo anatitanthauzira malotowo. Munthu aliyense anamupatsa tanthauzo la loto lake. ");
INSERT INTO nya_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ndipo zinthu zinachitikadi monga mmene anatitanthauzira. Ine anandibwezera pa ntchito yanga ndipo winayo anapachikidwa.” ");
INSERT INTO nya_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Choncho Farao anamuyitanitsa Yosefe, ndipo mofulumira anabwera naye kuchokera mʼdzenje muja. Ndipo atameta, ndi kusintha zovala, anapita kwa Farao. ");
INSERT INTO nya_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Farao anati kwa Yosefe, “Ndinalota maloto ndipo palibe amene watha kunditanthauzira. Tsono ndawuzidwa kuti iwe ukamva loto umadziwanso kulimasulira.” ");
INSERT INTO nya_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yosefe anamuyankha Farao kuti, “Sindingathe koma Mulungu apereka yankho limene Farao akufuna.” ");
INSERT INTO nya_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ndipo Farao anati kwa Yosefe, “Ndinalota nditayimirira mʼmphepete mwa mtsinje wa Nailo, ");
INSERT INTO nya_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ndipo ngʼombe zisanu ndi ziwiri zonenepa ndi zooneka bwino zinatuluka mu mtsinje muja ndi kumadya msipu wa mu mawango. ");
INSERT INTO nya_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Kenaka, ngʼombe zina zisanu ndi ziwiri zinatuluka. Izi zinali zosaoneka bwino ndiponso zowonda ndipo sindinaonepo ngʼombe zosaoneka bwino chonchi mʼdziko lonse la Igupto. ");
INSERT INTO nya_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ngʼombe zosaoneka bwino ndi zowonda zija zinadya zisanu ndi ziwiri zonenepa zimene zinatuluka poyamba zija. ");
INSERT INTO nya_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Koma ngakhale ngʼombezi zinadya zinazo, palibe amene akanatha kuzindikira kuti zinatero popeza zinali zosaonekabe bwino monga poyamba. Ndipo ndinadzidzimuka. ");
INSERT INTO nya_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Nditagonanso kachiwiri, ndinalota ngala zisanu ndi ziwiri za tirigu zathanzi ndi zonenepa zitabala pa phata limodzi. ");
INSERT INTO nya_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Kenaka panaphukanso ngala zina zisanu ndi ziwiri zofota, zowonda ndi zowauka ndi mphepo ya kummawa. ");
INSERT INTO nya_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ngala zowondazo zinameza ngala zisanu ndi ziwiri zabwino zija. Ndinawawuza amatsenga koma palibe ndi mmodzi yemwe anatha kundimasulira.” ");
INSERT INTO nya_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ndipo Yosefe anati kwa Farao, “Maloto awiriwa ndi ofanana ndipo ali ndi tanthauzo limodzi. Mulungu waululira Farao chimene atachite. ");
INSERT INTO nya_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ngʼombe zisanu ndi ziwiri zabwinozo ndi zaka zisanu ndi ziwiri. Ndipo ngala zisanu ndi ziwiri zabwinozo ndi zaka zisanu ndi ziwiri. Kutanthauza kwa maloto nʼkumodzi. ");
INSERT INTO nya_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ngʼombe zisanu ndi ziwiri zowonda ndi zosaoneka bwino zimene zinatuluka pambuyozo ndiponso ngala zisanu ndi ziwiri zachabechabe, zowauka ndi mphepo ya kummawa zija ndi zaka zisanu ndi ziwiri za njala. ");
INSERT INTO nya_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Tsono ndi monga ndafotokozeramu kuti Mulungu wakuwuziranitu zimene adzachite. ");
INSERT INTO nya_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Zaka zisanu ndi ziwiri za zokolola zochuluka zikubwera mu dziko lonse la Igupto, ");
INSERT INTO nya_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","koma zidzatsatana ndi zaka zina zisanu ndi ziwiri za njala. Chakudya chochuluka cha mu Igupto chija chidzayiwalika ndipo njalayo idzawononga dziko. ");
INSERT INTO nya_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Zakudya zochuluka za mʼdzikomo zija sizidzakumbukirikanso chifukwa njala imene iti idzabwereyo idzakhala yoopsa. ");
INSERT INTO nya_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Popeza kuti malotowa aperekedwa kwa inu Mfumu kawiri, ndiye kuti Mulungu watsimikiza kuti adzachitadi zimenezi posachedwapa. ");
INSERT INTO nya_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Tsopano Farao apezeretu munthu wozindikira ndi wanzeru ndipo amuyike kukhala woyangʼanira dziko lonse la Igupto. ");
INSERT INTO nya_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Asankhenso akuluakulu a mʼdziko lino. Iwowa azitenga ndi kuyika padera limodzi la magawo asanu aliwonse a zokolola za mʼdziko muno mu zaka zonse zisanu ndi ziwiri za chakudya chochuluka. ");
INSERT INTO nya_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Iwo asonkhanitse zakudya zonse za mʼzaka zabwino zikubwerazi. Pansi pa ulamuliro wa Farao, akuluakuluwo asonkhanitse ndi kusunga bwino tirigu mʼmizinda yonse. ");
INSERT INTO nya_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Chakudya chimenechi chisungidwe kuti chidzagwiritsidwe ntchito mʼzaka zisanu ndi ziwiri za njala imene ikubwerayo mu Igupto, kuti anthu a mʼdzikoli asadzafe ndi njalayo.” ");
INSERT INTO nya_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Farao ndi nduna zake anagwirizana nawo malangizo a Yosefe. ");
INSERT INTO nya_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Choncho Farao anafunsa nduna zake nati, “Kodi tingathe kumupeza munthu wina ngati uyu, amene ali ndi mzimu wa Mulungu?” ");
INSERT INTO nya_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Farao anati kwa Yosefe, “Pakuti Mulungu wakudziwitsa iwe zonsezi, palibe wina wodziwa zinthu ndi wanzeru ngati iwe. ");
INSERT INTO nya_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Iwe ukhala nduna yayikulu mu dziko langa ndipo anthu onse adzamvera zimene walamula. Ine ndekha ndiye amene ndidzakuposa mphamvu chifukwa ndimakhala pa mpando waufumu.” ");
INSERT INTO nya_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Choncho Farao anati kwa Yosefe, “Ine ndikukuyika iwe kukhala nduna yoyangʼanira dziko lonse la Igupto.” ");
INSERT INTO nya_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ndipo Farao anavula mphete ku chala chake nayiveka ku chala cha Yosefe. Anamuvekanso mkanjo wonyezimira ndi nkufu wagolide mʼkhosi mwake. ");
INSERT INTO nya_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Anamukweza Yosefe pa galeta ngati wachiwiri pa ulamuliro. Ndipo anthu anafuwula pamaso pake nati, “Mʼgwadireni!” Motero anakhala nduna yayikulu ya dziko lonse la Igupto. ");
INSERT INTO nya_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Kenaka Farao anati kwa Yosefe, “Ine ndine Farao; tsono iwe ukapanda kulamula, palibe amene akhoza kuchita chilichonse ngakhale kuyenda kumene mʼdziko lonse la Igupto.” ");
INSERT INTO nya_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Farao anamupatsa Yosefe dzina lakuti Zafenati-Panea ndipo anamupatsanso Asenati mwana wa mkazi wa Potifara, wansembe wa Oni, kuti akhale mkazi wake. Choncho Yosefe anayendera dziko lonse la Igupto. ");
INSERT INTO nya_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yosefe anali ndi zaka 30 pamene amayamba ntchito kwa Farao, mfumu ya ku Igupto. Ndipo Yosefe anachoka pa maso pa Farao nayendera dziko lonse la Igupto. ");
INSERT INTO nya_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Mʼzaka zisanu ndi ziwiri za zokolola zambiri zija, anthu mʼdzikomo anakolola zochuluka. ");
INSERT INTO nya_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yosefe anasonkhanitsa zakudya zonse zokololedwa mʼzaka zisanu ndi ziwiri zija ndipo anazisunga mʼmizinda. Mu mzinda uliwonse anayikamo chakudya chimene chinalimidwa mʼminda yozungulira komweko. ");
INSERT INTO nya_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yosefe anasunga tirigu wochuluka kwambiri ngati mchenga wa ku nyanja. Kunali tirigu wochuluka kwambiri motero kuti analeka nʼkulembera komwe. ");
INSERT INTO nya_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Zisanafike zaka zanjala, Yosefe anabereka ana aamuna awiri mwa Asenati mwana wa mkazi wa Potifara, wansembe wa Oni. ");
INSERT INTO nya_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yosefe anamutcha mwana wake woyamba, Manase popeza anati, “Mulungu wandiyiwalitsa zovuta zanga zija ndiponso banja la abambo anga.” ");
INSERT INTO nya_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Mwana wachiwiri wa mwamuna anamutcha Efereimu popeza anati, “Mulungu wandipatsa ana mʼdziko la masautso anga.” ");
INSERT INTO nya_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Zaka zisanu ndi ziwiri za zokolola zochuluka zija zinatha, ");
INSERT INTO nya_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ndipo zaka zisanu ndi ziwiri za njala zija zinayamba monga ananenera Yosefe. Njalayi inafika ku mayiko ena onse koma ku dziko lonse la Igupto kunali chakudya. ");
INSERT INTO nya_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Pamene njala ija inakwanira dziko lonse la Igupto anthu analilira Farao kuti awapatse chakudya. Koma Farao anawawuza kuti, “Pitani kwa Yosefe ndipo mukachite zimene akakuwuzeni.” ");
INSERT INTO nya_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Pamene njala inafalikira dziko lonse, Yosefe anatsekula nkhokwe za zakudya namagulitsa tirigu kwa anthu a ku Igupto aja, pakuti njala inafika poyipa kwambiri mu Igupto monse. ");
INSERT INTO nya_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Anthu ankabwera ku Igupto kuchokera ku mayiko ena onse kudzagula tirigu kwa Yosefe, chifukwa njala inafika poyipa kwambiri pa dziko lonse lapansi. ");
INSERT INTO nya_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakobo atamva kuti ku Igupto kuli tirigu, anati kwa ana ake, “Nʼchifukwa chiyani mukungoyangʼanana wina ndi mnzake? ");
INSERT INTO nya_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ine ndamva kuti ku Igupto kuli tirigu. Pitani kumeneko mukatigulireko kuti tisafe ndi njala.” ");
INSERT INTO nya_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Choncho abale ake khumi a Yosefe anapita kukagula tirigu ku Igupto. ");
INSERT INTO nya_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Koma Yakobo sanamulole Benjamini mngʼono wake wa Yosefe kuti apite nawo chifukwa anaopa kuti choyipa chingamuchitikire. ");
INSERT INTO nya_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Choncho ana a Israeli aja anapita pamodzi ndi gulu la anzawo kukagula tirigu pakuti ku Kanaani kunalinso njala. ");
INSERT INTO nya_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Pakuti Yosefe anali nduna yayikulu yolamulira dziko la Igupto, ndiye kuti analinso amene ankagulitsa tirigu kwa anthu onse. Choncho abale ake a Yosefe nawonso anabwera, ndipo anamugwadira pansi. ");
INSERT INTO nya_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yosefe atangowaona abale ake anawazindikira, koma ananamizira kukhala ngati mlendo nawayankhula mwaukali kuwafunsa kuti, “Mwachokera kuti?” Iwo anayankha, “Ku dziko la Kanaani, tikudzagula chakudya.” ");
INSERT INTO nya_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ngakhale Yosefe anawazindikira abale ake, koma iwo sanamuzindikire. ");
INSERT INTO nya_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Pamenepo anakumbukira maloto aja amene analota za iwo ndipo anati, “Inu ndinu akazitape! Mwabwera kudzazonda dziko lathu kuti muone pamene palibe chitetezo.” ");
INSERT INTO nya_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Iwo anayankha, “Ayi mbuye wathu, antchito anufe tabwera kudzagula chakudya. ");
INSERT INTO nya_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Tonse ndife ana a munthu mmodzi. Ndife antchito anu okhulupirika osati akazitape.” ");
INSERT INTO nya_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Iye anawawuza kuti, “Ayi! Inu mwabwera kudzaona pamene palibe chitetezo mʼdziko muno.” ");
INSERT INTO nya_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Koma iwo anayankha, “Tinalipo ana aamuna khumi ndi awiri. Abambo athu ndi mmodzi, ndipo kwathu ndi ku Kanaani. Panopo wotsiriza ali ndi abambo athu ndipo wina anamwalira.” ");
INSERT INTO nya_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yosefe anawawuza kuti, “Ndi momwe ndaneneramo: Inu ndinu akazitape. ");
INSERT INTO nya_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ndiye ndikuyesani motere: Ine ndikulumbira pali Farao ndithu, inuyo simudzachoka malo ano mpaka wotsirizayo atabwera kuno. ");
INSERT INTO nya_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Tumizani mmodzi wa inu akamutenge mʼbale wanuyo ndipo ena nonsenu musungidwa mʼndende, kuti titsimikize ngati zimene mukunenazi ndi zoona. Apo ayi, pali Farao ndithu, inu ndinu akazitape!” ");
INSERT INTO nya_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ndipo onse anawayika mʼndende kwa masiku atatu. ");
INSERT INTO nya_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Pa tsiku lachitatu Yosefe anawawuza kuti, “Popeza ine ndimaopa Mulungu, ndipo inuyo ngati mukufuna kukhala ndi moyo muchite izi: ");
INSERT INTO nya_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ngati muli anthu achilungamo, mmodzi wa inu atsale mʼndende, pamene ena nonse mupite kwanu kuti muwatengere chakudya anthu akwanu kuli njalako. ");
INSERT INTO nya_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Mukabwere naye kuno mngʼono wanu wotsirizayo kuti titsimikizire zimene munanena kuti musafe.” Ndipo anachita zomwezo. ");
INSERT INTO nya_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Iwo anati kwa wina ndi mnzake, “Ndithu ife tinalakwira mʼbale wathu uja popeza kuti ngakhale tinaona kuvutika kwake ndi kumva kulira kwake pamene ankatidandaulira kuti timuchitire chifundo, koma ife sitinamvere. Nʼchifukwa chake masautso awa atigwera.” ");
INSERT INTO nya_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubeni anayankha, “Kodi sindinakuwuzeni kuti musamuchite kanthu mnyamata uja? Koma inu simunamvere! Tsopano tikulandira malipiro a magazi ake.” ");
INSERT INTO nya_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Koma sanadziwe kuti Yosefe ankawamva popeza kuti ankagwiritsa ntchito wotanthauzira poyankhula naye. ");
INSERT INTO nya_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yosefe anapita pambali payekha kukalira. Kenaka anabweranso nadzayankhula nawo. Iye anatenga Simeoni namumanga iwo akuona. ");
INSERT INTO nya_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yosefe analamula kuti awadzazire matumba awo ndi tirigu, awayikiremo ndalama zawo momwemo ndiponso awapatse chakudya cha panjira. Izi anawachitiradi. ");
INSERT INTO nya_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Abale a Yosefe aja anasenzetsa abulu awo tirigu amene anagula uja ndipo ananyamuka ulendo wawo. ");
INSERT INTO nya_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Atafika pamalo pena poti agone, mmodzi mwa iwo anatsekula thumba lake kuti atapemo chakudya cha bulu wake. Atangomasula anaona kuti ndalama zake zili pakamwa pa thumba. ");
INSERT INTO nya_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Iye anati kwa abale akewo, “Ndalama zanga andibwezera, izi zili mʼthumba mwangamu.” Mitima yawo inachita ngati yachokamo ndipo anali ndi mantha ambiri, nati, “Ndi chiyani chimene Mulungu watichitira?” ");
INSERT INTO nya_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Atafika kwa abambo awo Yakobo mʼdziko la Kanaani anafotokoza zonse zimene zinawachitikira nati, ");
INSERT INTO nya_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Nduna yayikulu ya mʼdzikomo inatiyankhula mwa ukali kwambiri ndipo inkatiyesa kuti ndife akazitape. ");
INSERT INTO nya_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Koma tinamuwuza kuti, ‘Ndife anthu woona mtima osati akazitape. ");
INSERT INTO nya_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ife tonse tinalipo ana aamuna khumi ndi awiri, abambo mmodzi. Mmodzi anamwalira, ndipo wamngʼono ali ndi abambo athu ku Kanaani.’ ” ");
INSERT INTO nya_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ndipo nduna ija inati kwa ife, “Kuti ndidziwedi kuti ndinu anthu owona mtima muchite izi: Mmodzi mwa inu atsale ndi ine kuno, ndipo enanu mutenge chakudya ndi kubwerera kwanu kumene kuli njalako. ");
INSERT INTO nya_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Koma mundibweretsere wotsirizayo kuti ndidziwedi kuti sindinu akazitape koma anthu achilungamo. Kenaka ndidzakubwezerani mʼbale wanuyu ndipo mukhoza kuchita malonda mʼdzikoli.” ");
INSERT INTO nya_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Pamene amakhuthula matumba awo a tirigu aliyense anapeza kuti kathumba kake ka ndalama kali momwemo. Ataona zimenezi, iwo pamodzi ndi abambo awo anachita mantha kwambiri. ");
INSERT INTO nya_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Abambo awo Yakobo anawawuza kuti, “Mwandilanda ana anga ine. Yosefe anamwalira ndipo Simeoni palibenso, ndiye tsopano mukufuna mutengenso Benjamini. Zonsezi zandigwera ine!” ");
INSERT INTO nya_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Koma Rubeni anati kwa abambo ake, “Ngati sindidzabwera naye kwa inu, mudzaphe ana anga aamuna awiri. Muperekeni mʼmanja mwangamu ndipo ndidzamusamala ndi kubwera naye kwa inu.” ");
INSERT INTO nya_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Koma Yakobo anati, “Mwana wanga sapita nanu kumeneko; mkulu wake anamwalira ndipo watsala yekha. Ngati choyipa chitamuchitikira pa ulendo mukupitawu, ndiye kuti ndi mmene ndakalambiramu inu mudzandipha ndi chisoni chotere.” ");
INSERT INTO nya_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Njala inakula kwambiri mʼdzikomo. ");
INSERT INTO nya_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Tsono atatha kudya tirigu yense amene anakatenga ku Igupto, Yakobo anati kwa ana ake aja, “Pitani kuti mukatigulire chakudya china pangʼono.” ");
INSERT INTO nya_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Koma Yuda anati kwa iye, “Munthu uja anatichenjeza monenetsa kuti, ‘Simudzandionanso ine pokhapokha mutabwera ndi mngʼono wanu.’ ");
INSERT INTO nya_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Mukalola kuti mngʼono wathuyu apite nafe, ndiye ife tidzapita kukakugulirani chakudya. ");
INSERT INTO nya_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Koma mukapanda kumulola, ife sitipita, chifukwa munthuyo anatiwuza kuti, ‘Simudzandionanso pokhapokha mutabwera ndi mngʼono wanuyo.’ ” ");
INSERT INTO nya_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Tsono Israeli anafunsa kuti, “Bwanji inu munandiputira mavuto oterewa pomuwuza munthuyo kuti muli ndi mʼbale wanu wina?” ");
INSERT INTO nya_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Iwo anayankha, “Munthuyo ankangofunsafunsa za ife ndi za banja lathu. Iye anatifunsa kuti, ‘Kodi abambo anu akanali ndi moyo? Kodi muli ndi mʼbale wanu wina?’ Ife tinkangoyankha mafunso ake. Ife tikanadziwa bwanji kuti adzanena kuti, ‘Mubwere naye kuno mʼbale wanu’?” ");
INSERT INTO nya_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ndipo Yuda anati kwa Israeli abambo ake, “Muloleni mnyamatayo apite ndi ine, ndipo tinyamuka nthawi yomweyo, kuti ife ndi inu pamodzi ndi ana athu tikhale ndi moyo. ");
INSERT INTO nya_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ine ndidzipereka kuti ndikhale chikole cha moyo wa mnyamatayu. Ine ndidzamuteteza. Ngati sindibwera naye ndi kumupereka kwa inu, ndidzakhala wolakwa pamaso panu moyo wanga wonse. ");
INSERT INTO nya_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Mmene zililimu, tikanapanda kuchedwa, bwenzi titapita ndi kubwerako kawiri.” ");
INSERT INTO nya_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Tsono abambo awo Israeli anawawuza kuti, “Ngati pafunika kutero, ndiye muchite izi: Ikanimo zipatso zabwino kwambiri za dziko lino mʼmatumba mwanu ndi kumutengera munthuyo ngati mphatso. Mumutengere mafuta wopaka pangʼono, uchi pangʼono, mafuta wonunkhiritsa chakudya, mule, mtedza ndi alimoni. ");
INSERT INTO nya_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Mutenge ndalama zokwanira. Ndalama zina nʼzokamubwezera zija anakuyikirani mʼmatumba anu zija. Mwina anangolakwitsa. ");
INSERT INTO nya_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Mutengeninso mngʼono wanuyu ndi kubwerera kwa munthuyo msanga. ");
INSERT INTO nya_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ndipo Mulungu Wamphamvuzonse akuchitireni chifundo pamaso pa munthuyo kuti akamulole mʼbale wanu wina uja ndi Benjamini kuti abwerere ndi inu. Kukakhala kulira, ndine wolira basi.” ");
INSERT INTO nya_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Choncho abale aja anatenga mphatso, ndalama zokwanira ndi Benjamininso. Iwo anafulumira kupita ku Igupto ndipo anakaonekera kwa Yosefe. ");
INSERT INTO nya_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yosefe ataona Benjamini ali pamodzi ndi abale ake, anati kwa wantchito wa mʼnyumba mwake, “Atengereni anthu awa ku nyumba kwanga, ndipo uphe nyama ndi kukonza bwino chakudya popeza amenewa adya ndi ine masana ano.” ");
INSERT INTO nya_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Wantchitoyo anachita monga momwe Yosefe ananenera, ndipo anawatengera abale aja ku nyumba kwa Yosefe. ");
INSERT INTO nya_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Tsono anthu aja anachita mantha ataona kuti akuwatengera ku nyumba kwa Yosefe. Mʼmaganizo awo ankanena kuti, “Atibweretsa kuno chifukwa cha ndalama zija zinabwezeredwa mʼmatumba athu poyamba paja. Ameneyu akufuna kuti atipanikize ndi kutigwira ukapolo natilanda abulu athu.” ");
INSERT INTO nya_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Choncho atafika pa khomo la nyumba ya Yosefe anamuyandikira wantchito wa Yosefe nayankhula naye kuti, ");
INSERT INTO nya_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Pepani mbuye wathu, ife tinabweranso ulendo woyamba kudzagula chakudya ");
INSERT INTO nya_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","koma titafika pa malo ena kuti tigone, tinatsekula matumba athu ndipo aliyense wa ife anapeza ndalama zake momwe zinalili zili pakamwa pa thumba lake. Ndiye tabwerera nazo. ");
INSERT INTO nya_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Tabweretsanso ndalama zina kuti tigule chakudya. Sitikudziwa kuti kaya ndani anayika ndalamazo mʼmatumba athu.” ");
INSERT INTO nya_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Koma iye anati, “Mitima yanu ikhale pansi ndipo musachite mantha. Mulungu wanu, Mulungu wa abambo anu, anakuyikirani chumacho mʼmatumba anu. Ine ndinalandira ndalama zanu.” Ndipo anakawatulutsira Simeoni. ");
INSERT INTO nya_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Wantchito uja anawalowetsa anthuwo mʼnyumba ya Yosefe, nawapatsa madzi kuti asambe mapazi awo. Anadyetsanso abulu awo. ");
INSERT INTO nya_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Abale aja anakonzeratu mphatso zawo zija kuti adzapereke kwa Yosefe, popeza anamva kuti Yosefe adzadya komweko masana. ");
INSERT INTO nya_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yosefe atafika ku nyumbako, iwo anapereka mphatso zija namuweramira pansi. ");
INSERT INTO nya_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yosefe anawafunsa za moyo wawo kenaka anati, “Kodi abambo anu wokalamba amene munkandiwuza aja ali bwanji? Ali ndi moyobe?” ");
INSERT INTO nya_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Iwo anayankha kuti, “Mtumiki wanu abambo athu akanali ndi moyo ndipo ali bwino.” Ndipo anamugwadira namuweramira pansi. ");
INSERT INTO nya_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Pomwazamwaza maso Yosefe anaona Benjamini, mʼbale wake weniweni wa bere limodzi, ndipo anafunsa, “Kodi uyu ndiye mʼbale wanu wamngʼono kwambiri amene munkandiwuza uja?” Kenaka anati, “Ambuye akukomere mtima mwana wanga.” ");
INSERT INTO nya_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Kenaka Yosefe anafulumira kutuluka chifukwa mtima wake unadzaza ndi chifundo cha mngʼono wake ndipo anafuna kulira. Tsono anakalowa mʼchipinda chakechake nakalira kumeneko. ");
INSERT INTO nya_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Atatha kupukuta misozi mʼmaso mwake anatuluka, ndipo modzilimbitsa analamula kuti chakudya chibwere. ");
INSERT INTO nya_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Anamupatsira Yosefe chakudya payekha, abale ake aja pawokha, ndiponso Aigupto amene ankadya pamodzi ndi iye nawonso pawokha. Izi zinali choncho chifukwa Aigupto ankanyansidwa kudya pamodzi ndi Ahebri. ");
INSERT INTO nya_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Abale aja anawakhazika patsogolo pa Yosefe. Iwo anawakhazika monga mwa mabadwidwe awo kuyambira woyamba kubadwa mpaka wotsirizira; ndipo ankangoyangʼanitsitsana modabwa. ");
INSERT INTO nya_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Tsono ankawagawira chakudya kuchokera pa tebulo la Yosefe. Koma chakudya cha Benjamini chinkaposa cha ena onsewa kasanu. Motero anadya ndi kumwa mpaka kukhuta, ndipo anasangalala pamodzi ndi Yosefe. ");
INSERT INTO nya_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Pambuyo pake Yosefe analamulira wantchito wa mʼnyumba mwake kuti, “Adzazire chakudya anthuwa mʼmatumba mwawo monga mmene anganyamulire, ndipo uwayikire ndalama zawo pakamwa pa matumba awowo. ");
INSERT INTO nya_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Tsono uyike chikho changa cha siliva chija, pakamwa pa thumba la wamngʼono kwambiriyu pamodzi ndi ndalama zake za chakudya” Ndipo iye anachita monga Yosefe ananenera. ");
INSERT INTO nya_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Mmawa kutacha anthu aja analoledwa kuti apite ndi abulu awo. ");
INSERT INTO nya_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Atangotuluka mu mzinda muja, koma asanapite patali, Yosefe anati kwa wantchito wake, “Nyamuka atsatire anthu aja msanga. Ndipo ukawapeza, uwafunse kuti, ‘Bwanji mwabwezera zoyipa ndi zabwino? ");
INSERT INTO nya_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Mwaberanji chikho chimene mbuye wanga amamweramo ndi kugwiritsa ntchito akafuna kuwombeza? Chimene mwachitachi ndi chinthu choyipa.’ ” ");
INSERT INTO nya_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Wantchito uja atawapeza ananena mawu anawuzidwa aja. ");
INSERT INTO nya_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Koma iwo anati kwa iye, “Kodi mbuye wanga mukuneneranji zimenezi? Sizingatheke ndi pangʼono pomwe kuti antchito anufe nʼkuchita zoterozo ayi! ");
INSERT INTO nya_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Paja ife pobwera kuchokera ku Kanaani tinatenga ndalama kubwezera zimene tinazipeza mʼmatumba mwathu. Ndiye pali chifukwa chanji kuti tikabe siliva kapena golide mʼnyumba mwa mbuye wanu? ");
INSERT INTO nya_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ngati wantchito wanu wina pano atapezeka nacho chikhocho, ameneyo aphedwe ndipo ena tonsefe tidzakhala akapolo anu, mbuye wathu.” ");
INSERT INTO nya_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Iye anati, “Chabwino, tsono zikhale monga mwaneneramu. Komatu aliyense amene angapezeke nacho chikhocho adzakhala kapolo wanga, ndipo ena nonsenu muzipita mwaufulu.” ");
INSERT INTO nya_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Tsono onse anafulumira kutsitsa pansi aliyense thumba lake ndi kulitsekula. ");
INSERT INTO nya_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Kenaka anayamba kufufuza, kuyambira pa wamkulu mpaka pa wamngʼono. Ndipo chikhocho chinapezeka mʼthumba mwa Benjamini. ");
INSERT INTO nya_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Apo onse anangʼamba zovala zawo ndi chisoni. Ndipo anasenzetsa abulu katundu wawo nabwerera ku mzinda konkuja. ");
INSERT INTO nya_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Pamene Yuda ndi abale ake ankafika ku nyumba kwa Yosefe nʼkuti Yosefe akanali komweko. Ndipo anadzigwetsa pansi pamaso pake. ");
INSERT INTO nya_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yosefe anafunsa kuti, “Nʼchiyani mwachitachi? Kodi simudziwa kuti munthu ngati ine ndikhoza kuona zinthu mwakuwombeza?” ");
INSERT INTO nya_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda anayankha, “Kodi tinganenenji kwa mbuye wanga? Tinena chiyani? Tingadzilungamitse bwanji? Mulungu waulula kulakwa kwa antchito anu. Ndipo tsopano ndife akapolo a mbuye wanga, ife tonse pamodzi ndi amene wapezeka ndi chikhocho.” ");
INSERT INTO nya_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Koma Yosefe anati, “Sindingachite choncho ayi! Yekhayo amene wapezeka ndi chikhocho ndi amene akhale kapolo wanga. Ena nonsenu, bwererani kwa abambo anu mu mtendere.” ");
INSERT INTO nya_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ndipo Yuda anamuyandikira iye nati, “Chonde mbuye wanga mulole kapolo wanune ndinene mawu pangʼono kwa mbuye wanga. Musandipsere mtima, kapolo wanune, popeza inu muli ngati Farao yemwe. ");
INSERT INTO nya_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mbuye wanga munafunsa akapolo anufe kuti, ‘Kodi muli ndi abambo anu kapena mʼbale wanu?’ ");
INSERT INTO nya_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ndipo ife tinayankha, ‘Inde mbuye wathu, ife tili ndi abambo athu wokalamba, ndipo pali mwana wamwamuna wamngʼono amene anabadwa abambo athu atakalamba kale. Mʼbale wake anafa ndipo ndi yekhayo mʼmimba mwa amayi ake amene watsala ndipo abambo ake amamukonda.’ ");
INSERT INTO nya_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Ndipo inu munatiwuza kuti, ‘Mubwere naye kwa ine kuti ndidzamuone ndekha.’ ");
INSERT INTO nya_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ife tinati, ‘Mbuye wathu, mnyamatayo sangasiye abambo ake, akawasiya ndiye kuti abambo akewo adzafa.’ ");
INSERT INTO nya_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Koma inu munatichenjeza kuti, ‘Pokhapokha mutabwera naye mʼbale wanu wamngʼono kwambiri, simudzandionanso.’ ");
INSERT INTO nya_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ndiye pamene tinafika kwa kapolo wanu, abambo athu tinawawuza zonse zimene munanena. ");
INSERT INTO nya_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Abambo athu anatiwuza kuti, ‘Pitaninso mukagule kachakudya pangʼono.’ ");
INSERT INTO nya_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Koma tinati, ‘Sitingathe kupitanso. Sitingapite pokhapokha mngʼono wathuyu apite nafe chifukwa munthu uja anati sitingaonane naye ngati mngʼono wathuyu sakhala nafe.’ ");
INSERT INTO nya_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Koma kapolo wanu, abambo athu anatiwuza kuti, ‘Inu mukudziwa kuti mkazi wanga anandiberekera ana aamuna awiri. ");
INSERT INTO nya_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Mmodzi wa iwo anandisiya. Ine ndimati anadyedwa ndi chirombo popeza sindinamuonenso mpaka lero. ");
INSERT INTO nya_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Tsopano mukanditengeranso uyu, nakaphedwa mu njira ndiye kuti mudzandikankhira ku manda ndi chisoni.’ ");
INSERT INTO nya_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Tsono ngati tizibwerera kwa mtumiki wanu, abambo athu popanda mnyamatayu, amene moyo wa abambo ake uli pa iyeyu, ");
INSERT INTO nya_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ndipo akakaona kuti mnyamatayu palibe, basi akafa. Ife tidzakhala ngati takankhira abambo athu ku manda ndi chisoni. ");
INSERT INTO nya_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ndiponsotu ine ndinadzipereka kwa abambo anga kukhala chikole chotsimikiza kuti mnyamatayu ndidzamuteteza, ndipo ndinati, ‘Ngati sindibwerera naye mnyamatayu kwa inu, ndiye kuti ndidzakhala wochimwira inu abambo anga moyo wanga wonse.’ ");
INSERT INTO nya_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Tsono, chonde mulole kuti ine kapolo wanu nditsalire kuno kukhala kapolo wa mbuye wathu mʼmalo mwa mnyamatayu. Koma iye apite pamodzi ndi abale akewa. ");
INSERT INTO nya_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ndingabwerere bwanji kwa abambo anga ngati sindingapite ndi mnyamatayu? Ayi! Sindifuna kukaona tsoka limene lingakagwere abambo anga.” ");
INSERT INTO nya_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Tsono Yosefe sanathenso kuwugwira mtima kuti asalire pamaso pa antchito ake ndipo anafuwula kuti, “Aliyense achoke pamaso panga!” Motero panalibe wina aliyense pamene Yosefe anadziwulula kwa abale ake. ");
INSERT INTO nya_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ndipo analira mokweza mwakuti Aigupto anamva. Onse a ku nyumba kwa Farao anamvanso za zimenezi. ");
INSERT INTO nya_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yosefe anati kwa abale ake, “Ine ndine Yosefe! Kodi abambo anga akanali ndi moyo?” Koma abale ake sanathe kumuyankha chifukwa anali ndi mantha kwambiri pamaso pake. ");
INSERT INTO nya_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ndipo Yosefe anati kwa abale ake, “Senderani pafupi nane.” Atasendera iye anati, “Ine ndine mʼbale wanu Yosefe amene munamugulitsa ku Igupto! ");
INSERT INTO nya_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ndipo tsopano, musawawidwe mtima kapena kudzipsera mtima chifukwa choti munandigulitsa ine kuno, popeza Mulungu ananditsogoza ine kuti adzapulumutse miyoyo yanu. ");
INSERT INTO nya_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Kwa zaka ziwiri tsopano, kwakhala kuli njala mʼdziko muno, ndipo kwa zaka zisanu zikubwerazi, anthu sadzalima kapena kukolola. ");
INSERT INTO nya_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Koma Mulungu ananditsogoza kuti adzakusungeni ndi moyo ndi kuti mudzakhale ndi zidzukulu pa dziko lapansi. ");
INSERT INTO nya_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Motero, si inu amene munanditumiza kuno koma Mulungu. Iye anandisandutsa kukhala nduna yayikulu ya Farao, ndipo zonse za mʼnyumba mwake zili mʼmanja mwangamu. Komanso amene akulamulira dziko lonse la Igupto ndi ine. ");
INSERT INTO nya_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Tsono fulumirani mubwerere kwa abambo anga ndi kuwawuza kuti, ‘Mwana wanu Yosefe akuti, Mulungu anandisandutsa kukhala mbuye wa dziko lonse la Igupto. Ndiye bwerani kuno musachedwe. ");
INSERT INTO nya_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ndipo inu, ana anu, zidzukulu zanu, pamodzi ndi nkhosa ndi ngʼombe zanu ndi antchito anu amene muli nawo muzidzakhala mʼdziko la Goseni pafupi ndi ine. ");
INSERT INTO nya_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ine ndizidzakupatsani zakudya kumeneko chifukwa zaka zisanu za njala zikubwera ndithu. Kupanda kutero, inu ndi mabanja anu pamodzi ndi anthu anu onse mudzasowa chakudya.’ ");
INSERT INTO nya_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Tsono inu nonse pamodzi ndi mʼbale wangayu Benjamini, mukuona kuti ndi inedi amene ndikuyankhula nanu. ");
INSERT INTO nya_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Mukawawuze abambo anga kuti ndili pa ulemerero ku dziko la Igupto kuno ndi zonse zimene mwaziona. Tsopano fulumirani kuti mukabwere nawo kuno abambo anga.” ");
INSERT INTO nya_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Kenaka Yosefe anakhumbatira Benjamini, mngʼono wake uja nayamba kulira. Nayenso Benjamini anayamba kulira atamukumbatira. ");
INSERT INTO nya_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Atatero, Yosefe anapsompsona abale ake onse aja, akulira. Pambuyo pake abale ake aja anacheza ndi Yosefe. ");
INSERT INTO nya_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Akunyumba kwa Farao atamva kuti abale ake a Yosefe abwera, Farao pamodzi ndi nduna zake zonse anakondwera. ");
INSERT INTO nya_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Farao anati kwa Yosefe, “Uwawuze abale ako kuti, ‘Senzetsani nyama zanu katundu ndi kubwerera ku dziko la Kanaani. ");
INSERT INTO nya_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Mukabwere nawo abambo anu ndi mabanja anu kuno, ndipo ine ndidzakupatsani dera lachonde kwambiri mʼdziko la Igupto. Mudzadya zokoma za mʼdzikoli.’ ” ");
INSERT INTO nya_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Uwawuzenso kuti, ‘Tengani ngolo zingapo za kuno ku Igupto kuti mukakwezepo ana anu, akazi anu pamodzi ndi abambo ako ndi kubwera nawo kuno. ");
INSERT INTO nya_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Musadandaule zosiya katundu komweko chifukwa dziko lachonde la kuno ku Igupto lidzakhala lanu.’ ” ");
INSERT INTO nya_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Choncho ana a Israeli anachita zimenezo. Yosefe anawapatsa ngolo monga Farao analamulira, ndipo anawapatsanso chakudya cha paulendo wawo. ");
INSERT INTO nya_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Anaperekanso kwa aliyense zovala zatsopano, koma kwa Benjamini anapereka siliva wolemera pafupifupi makilogalamu anayi ndi zovala zisanu. ");
INSERT INTO nya_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ndipo abambo ake anawatumizira izi: abulu khumi osenza zinthu zabwino kwambiri za ku Igupto, ndi abulu aakazi khumi osenza tirigu, buledi ndi zakudya zina za pa ulendo wake. ");
INSERT INTO nya_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Kenaka anawalola abale ake aja kuti azipita, ndipo akunyamuka, iye anawawuza kuti, “Osakangana mʼnjira!” ");
INSERT INTO nya_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ndipo anachoka ku Igupto nafika kwa abambo awo Yakobo mʼdziko la Kanaani. ");
INSERT INTO nya_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Iwo anawuza abambo awo kuti, “Yosefe akanali ndi moyo! Ndiponsotu, ndiye akulamulira dziko la Igupto.” Yakobo anangoti kakasi osankhulupirira. ");
INSERT INTO nya_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Komabe atamufotokozera zonse zimene Yosefe anawawuza ndipo ataona ngolo zimene Yosefe anatumiza kuti adzakweremo popita ku Igupto, mtima wa Yakobo, abambo awo unatsitsimuka. ");
INSERT INTO nya_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ndipo Israeli anati, “Ndatsimikizadi! Mwana wanga Yosefe akanali ndi moyodi. Ndipita ndikamuone ndisanafe.” ");
INSERT INTO nya_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israeli anasonkhanitsa zonse anali nazo napita ku Beeriseba kukapereka nsembe kwa Mulungu wa abambo ake Isake. ");
INSERT INTO nya_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ndipo Mulungu anayankhula ndi Israeli mʼmasomphenya usiku nati, “Yakobo! Yakobo!” Iye anayankha, “Ee, Ambuye.” ");
INSERT INTO nya_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Mulungu anati, “Ine ndine Mulungu. Mulungu wa abambo ako. Usachite mantha kupita ku Igupto, pakuti ndidzachulukitsa zidzukulu zako kumeneko moti zidzakhala mtundu waukulu. ");
INSERT INTO nya_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ine ndidzapita ku Igupto pamodzi ndi iwe ndipo mosakayika konse zidzukulu zako ndidzazibweretsa konkuno. Yosefe adzakhalapo pa nthawi yako yomwalira.” ");
INSERT INTO nya_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Yakobo anachoka ku Beeriseba, ndipo ana ake anakweza abambo awo, ana awo, pamodzi ndi akazi awo pa ngolo zimene Farao anatumiza kuti adzakwerepo. ");
INSERT INTO nya_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Iwo anatenganso ziweto zawo ndi katundu wawo amene anali naye ku Kanaani, ndipo Yakobo pamodzi ndi ana ndi zidzukulu zake anapita ku Igupto. ");
INSERT INTO nya_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ndiye kuti popita ku Igupto Yakobo anatenga ana aamuna, zidzukulu zazimuna, ana aakazi ndi zidzukulu zazikazi. ");
INSERT INTO nya_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Nawa ana a Israeli (ndiye kuti Yakobo ndi ana ake) amene anapita ku Igupto: Rubeni mwana woyamba wa Yakobo. ");
INSERT INTO nya_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ana aamuna a Rubeni ndi awa: Hanoki, Palu, Hezironi ndi Karimi. ");
INSERT INTO nya_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ana aamuna a Simeoni ndi awa: Yemueli, Yamini, Ohadi, Yakini, Zohari ndi Shaulo amene mayi wake anali wa ku Kanaani. ");
INSERT INTO nya_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ana aamuna a Levi ndi awa: Geresoni, Kohati ndi Merari. ");
INSERT INTO nya_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ana aamuna a Yuda ndi awa: Eri, Onani, Sela, Perezi ndi Zera. Koma Eri ndi Onani anamwalira mʼdziko la Kanaani. Ana a Perezi anali Hezironi ndi Hamuli. ");
INSERT INTO nya_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ana aamuna a Isakara ndi awa: Tola, Puwa, Yobi ndi Simironi. ");
INSERT INTO nya_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ana aamuna a Zebuloni ndi awa: Seredi, Eloni ndi Yahaleeli. ");
INSERT INTO nya_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Amenewa ndi ana aamuna a Leya amene anamubalira Yakobo ku Padanaramu. Panali mwana wamkazi dzina lake Dina. Ana onse analipo 33. ");
INSERT INTO nya_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ana aamuna a Gadi ndi awa: Zifioni, Hagi, Suni, Eziboni, Eri, Arodi ndi Areli. ");
INSERT INTO nya_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ana aamuna a Aseri ndi awa: Imuna, Isiva, Isivi, Beriya ndi Sera mlongo wawo. Ana aamuna a Beriya ndi awa: Heberi ndi Malikieli. ");
INSERT INTO nya_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Amenewa ndi zidzukulu za Yakobo mwa Zilipa amene Labani anapereka kwa mwana wake, Leya. Onse pamodzi analipo 16. ");
INSERT INTO nya_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ana aamuna a Rakele mkazi wa Yakobo anali: Yosefe ndi Benjamini. ");
INSERT INTO nya_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ku Igupto, Asenati mwana wa Potifara wansembe wa Oni, anamuberekera Yosefe ana awa: Manase ndi Efereimu. ");
INSERT INTO nya_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ana aamuna a Benjamini ndi awa: Bela, Bekeri, Asibeli, Gera, Naamani, Ehi, Rosi, Mupimu, Hupimu ndi Aridi. ");
INSERT INTO nya_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Amenewa ndi zidzukulu za Yakobo mwa mkazi wake Rakele. Onse analipo khumi ndi anayi. ");
INSERT INTO nya_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Mwana wa mwamuna wa Dani anali: Husimu. ");
INSERT INTO nya_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ana aamuna a Nafutali ndi awa: Yahazeeli, Guni, Yezeri ndi Silemu. ");
INSERT INTO nya_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Amenewa ndi zidzukulu za Yakobo mwa Biliha amene Labani anapereka kwa mwana wake Rakele. Onse pamodzi analipo asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Onse amene anapita ndi Yakobo (iwo amene anali akeake, osawerengera akazi a ana ake), analipo 66. ");
INSERT INTO nya_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Pophatikiza ana awiri a Yosefe obadwira ku Igupto, anthu a pa banja la Yakobo amene anapita ku Igupto, onse pamodzi analipo 70. ");
INSERT INTO nya_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Tsopano Yakobo anatumiza Yuda kwa Yosefe kukamupempha kuti akakumane naye ku Goseni. Iwo atafika ku chigawo cha Goseni, ");
INSERT INTO nya_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yosefe anakonza galeta nakwerapo ndi kupita ku Goseni kukakumana ndi abambo ake, Israeli. Yosefe atangofika pamaso pa abambo ake, anawakumbatira nalira kwa nthawi yayitali. ");
INSERT INTO nya_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israeli anati kwa Yosefe, “Tsopano ndikhoza kumwalira poti ndaona nkhope yako kuti ukanali ndi moyo.” ");
INSERT INTO nya_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ndipo Yosefe anati kwa abale ake pamodzi ndi a pa banja la abambo ake, “Ndipita kwa Farao ndipo ndikamuwuza kuti, ‘Abale anga pamodzi ndi onse a mʼnyumba ya abambo anga amene amakhala mʼdziko la Kanaani abwera kuno kwa ine. ");
INSERT INTO nya_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Anthuwa ndi abusa; amaweta ziweto zawo ndipo abwera ndi nkhosa ndi ngʼombe zawo, pamodzi ndi antchito awo.’ ");
INSERT INTO nya_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Tsono Farao akakuyitanani nakufunsani kuti, ‘Kodi mumagwira ntchito yanji?’ ");
INSERT INTO nya_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Muyankhe kuti, ‘Ife, bwana ndife oweta ziweto kuyambira ubwana wathu mpaka tsopano. Takhala tikuweta ziweto monga mmene ankachitira makolo athu.’ Mukadzayankha choncho, ndiye kuti mudzakhala mʼdziko la Goseni chifukwa anthu a ku Igupto amanyansidwa nawo anthu oweta ziweto.” ");
INSERT INTO nya_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yosefe anapita kukamuwuza Farao kuti, “Abambo anga, abale anga pamodzi ndi nkhosa, ngʼombe zawo, ndi antchito awo abwera kuchokera ku dziko la Kanaani ndipo tsopano ali ku Goseni.” ");
INSERT INTO nya_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Iye anapita kwa Farao kuja ndi abale ake asanu, kukawaonetsa. ");
INSERT INTO nya_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Farao anafunsa abale akewo kuti, “Mumagwira ntchito yanji?” Iwo anamuyankha kuti, “Ife, bwana ndife oweta ziweto, monga ankachitira makolo athu. ");
INSERT INTO nya_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ife tabwera kudzakhala kuno kwa kanthawi chifukwa njala yafika poopsa ku Kanaani motero kuti kulibe msipu wodyetsera ziweto. Ndiye bwana tiloleni kuti tikhale ku Goseni.” ");
INSERT INTO nya_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Farao anati kwa Yosefe, “Abambo ako ndi abale ako abwera kwa iwe. ");
INSERT INTO nya_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Dziko lonse la Igupto lili mʼdzanja lako. Uwakhazike abambo ako ndi abale ako mʼmalo achonde kwambiri. Akhale ku Goseni. Ndipo ngati ukudziwapo ena mwa iwo amene ali akatswiri pa kuweta ziweto, uwapatse udindo woyangʼanira ziweto zanga.” ");
INSERT INTO nya_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Kenaka Yosefe anapita ndi abambo ake kwa Farao kukawaonetsa, ndipo Yakobo anadalitsa Faraoyo. ");
INSERT INTO nya_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Atatero, Farao anafunsa Yakobo kuti, “Muli ndi zaka zingati?” ");
INSERT INTO nya_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakobo anayankha kuti, “Zaka za maulendo anga zakwana 130. Zaka za moyo wanga ndi zowerengeka, komanso zakhala zaka za masautso. Zaka za moyo wanga sizingafanane ndi zaka za moyo wa makolo anga.” ");
INSERT INTO nya_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Atatha kumudalitsa Farao uja, Yakobo anatsanzika nʼkunyamuka. ");
INSERT INTO nya_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Choncho Yosefe anakhazika abambo ake aja ndi abale ake mʼdziko la Igupto. Iye anawapatsa dera la Ramesesi limene linali dziko lachonde kwambiri monga analamulira Farao. ");
INSERT INTO nya_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yosefe anaperekanso chakudya kwa abambo ake, kwa abale ake ndi kwa onse a mʼnyumba ya abambo ake monga mwa chiwerengero cha ana awo. ");
INSERT INTO nya_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Njala inakula kwambiri motero kuti chakudya chinasowa mʼdziko lonse. Anthu a ku Igupto ndi ku Kanaani analefuka nayo njalayo. ");
INSERT INTO nya_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yosefe anasonkhanitsa ndalama zonse zimene anthu a mu Igupto ndi Kanaani ankapereka pogula tirigu, ndipo anabwera nazo ku nyumba kwa Farao. ");
INSERT INTO nya_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Anthu a ku Igupto ndi Kanaani ndalama zitawathera, Aigupto onse anabwera kwa Yosefe nati, “Tipatseni chakudya. Nanga tiferenji pamaso panu? Ndalama zathu zatha.” ");
INSERT INTO nya_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ndipo Yosefe anawayankha kuti, “Bwerani ndi ziweto zanu ndipo tidzasinthana ndi chakudya poti mukuti ndalama zanu zatha.” ");
INSERT INTO nya_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Choncho anthu anabwera ndi ziweto zawo monga akavalo, nkhosa, mbuzi, ngʼombe ndi abulu ndipo Yosefe anawapatsa zakudya. ");
INSERT INTO nya_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Chitatha chaka chimenecho, anthu anapitanso kwa Yosefe chaka chinacho nati, “Ife sitingakubisireni mbuye wathu kuti ndalama zathu zatithera ndipo ziweto zathu zili ndi inu, palibenso choti nʼkukupatsani mbuye wathu kupatula matupi athu ndi dziko lathu. ");
INSERT INTO nya_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Tiferenji ife ndi dziko lathu inu mukuona? Mutipatse chakudya ndipo tidzigulitsa ife ndi minda yathu yomwe. Ife tidzakhala akapolo a Farao. Tipatseni mbewuzo kuti tikhale ndi moyo tisafe ndipo dziko lisachite bwinja.” ");
INSERT INTO nya_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Choncho Yosefe anamugulira Farao dziko lonse la Igupto. Aliyense mu Igupto anagulitsa munda wake chifukwa njala inakula kwambiri. Dziko lonse linasanduka la Farao, ");
INSERT INTO nya_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ndipo Yosefe anawasandutsa anthu onse kukhala akapolo a Farao, kuchokera ku malire a mbali ina ya Igupto kukafika ku malire a mbali ina ya dzikolo. ");
INSERT INTO nya_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Komabe, sanagule minda ya ansembe chifukwa Farao ankawapatsa thandizo lokwanira. Nʼchifukwa chake sanagulitse minda yawo. ");
INSERT INTO nya_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yosefe anati kwa anthuwo, “Tsono poti ndakugulani inu ndi minda yanu, kugulira Farao. Nayi mbewu kuti mudzale mʼminda yanu. ");
INSERT INTO nya_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Koma podzakolola, mudzapereka gawo limodzi la magawo asanu aliwonse kwa Farao. Magawo anayi enawo adzakhala anu. Zina mudzasunge mbewu ndi zina mudzadye inuyo, mabanja anu ndi ana anu.” ");
INSERT INTO nya_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Iwo anati, “Mwatipulumutsa potichitira zabwinozi, mbuye wathu, tsono tidzakhala akapolo a Farao.” ");
INSERT INTO nya_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Choncho Yosefe anakhazikitsa lamulo limene lilipobe mpaka lero mʼdziko lonse la Igupto kuti limodzi la magawo asanu a zokolola ndi la Farao. Ndi minda ya ansembe yokha imene sinatengedwe kukhala ya Farao. ");
INSERT INTO nya_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Tsono Aisraeli anakhazikika mʼdziko la Igupto ku chigawo cha Goseni. Kumeneko anapeza chuma ndipo anaberekana nachuluka kwambiri. ");
INSERT INTO nya_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakobo anakhala ku Igupto zaka 17 ndipo zaka za moyo wake zinali 147. ");
INSERT INTO nya_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Nthawi itayandikira yoti Israeli amwalire, anayitanitsa mwana wake Yosefe nati kwa iye, “Ngati ukundikondadi monga abambo ako, ika dzanja lako pansi pa ntchafu yanga ndipo ulonjeze kuti udzaonetsa kukoma mtima ndi kukhulupirika kwako kwa ine kuti sudzayika mtembo wanga kuno ku Igupto. ");
INSERT INTO nya_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ine ndikagona pamodzi ndi makolo anga. Choncho ndikadzamwalira udzanditulutse mu Igupto muno ndipo ukayike mtembo wanga kumene anayikidwa makolo anga.” Yosefe anati, “Ndidzachita monga mwanenera.” ");
INSERT INTO nya_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakobo anati, “Lumbira kwa ine.” Yosefe analumbira kwa iye, ndipo Israeli anapembedza Mulungu atatsamira ndodo yake. ");
INSERT INTO nya_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Patapita kanthawi Yosefe anawuzidwa kuti, “Abambo ako akudwala.” Choncho anatenga ana ake awiri aja Manase ndi Efereimu ndi kupita nawo kwa Yakobo. ");
INSERT INTO nya_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yakobo atawuzidwa kuti, “Mwana wanu Yosefe wabwera,” Israeli anadzilimbitsa nadzuka kukhala tsonga pa bedi pake. ");
INSERT INTO nya_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakobo anati kwa Yosefe, “Mulungu Wamphamvuzonse anandionekera ku Luzi mʼdziko la Kanaani, ndipo anandidalitsa, ");
INSERT INTO nya_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","nati kwa ine, ‘Ndidzakupatsa ana ambiri ndipo zidzukulu zako zidzasanduka mitundu yambiri ya anthu. Ndidzapereka dziko ili kwa zidzukulu zako zobwera pambuyo pako kuti likhale lawo mpaka muyaya.’ ");
INSERT INTO nya_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Tsopano ana ako aamuna awiri amene anabadwa ine ndisanabwere kuno adzakhala ana anga. Efereimu ndi Manase adzakhala anga monga mmene alili Rubeni ndi Simeoni. ");
INSERT INTO nya_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Koma amene ati adzabadwe pambuyo pa iwowa adzakhala ako ndipo cholowa chawo chidzadziwika ndi mayina a abale awo. ");
INSERT INTO nya_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Pamene ndimabwerera kuchoka ku Parani, mwachisoni Rakele, amayi ako anamwalira mʼdziko la Kanaani, tikanali mʼnjira, mtunda wokafika ku Efurata ukanalipo. Ndipo ndinawayika kumeneko mʼmphepete mwa msewu wa ku Efurata” (amene ndi Betelehemu). ");
INSERT INTO nya_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israeli ataona ana a Yosefe anafunsa kuti, “Anyamatawa ndi a yani?” ");
INSERT INTO nya_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yosefe anati kwa abambo ake, “Awa ndi ana anga amene Mulungu wandipatsa kuno.” Ndipo Israeli anati, “Bwera nawo kuno kuti ndiwadalitse.” ");
INSERT INTO nya_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Koma maso a Israeli anali ofowoka chifukwa cha kukalamba moti sankaona nʼkomwe. Tsono Yosefe anabwera nawo ana ake aja pafupi ndi abambo ake ndipo abambo ake anawapsompsona nawakumbatira. ");
INSERT INTO nya_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israeli anati kwa Yosefe, “Ine sindinali kuyembekeza kuti nʼkudzaonanso nkhope yako, ndipo tsopano Mulungu wandilola kuti ndionenso ngakhale ana ako.” ");
INSERT INTO nya_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Tsono Yosefe anawachotsa ana aja pa mawondo a Israeli ndipo anamuweramira nkhope pansi. ");
INSERT INTO nya_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yosefe anawagwira ana onse awiri padzanja, Efereimu ku dzanja lake lamanja kulunjika dzanja lamanzere la Israeli ndipo Manase ku dzanja lamanzere kulunjikitsa dzanja lamanja la Israeli, ndipo anawayandikiza kwa Yakobo. ");
INSERT INTO nya_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Koma Israeli anapinganitsa mikono motero kuti anayika dzanja lake lamanja pamutu pa Efereimu ngakhale kuti iyeyo anali wamngʼono ndi dzanja lake lakumanzere analisanjika pamutu pa Manase ngakhale kuti iyeyu ndiye anali mwana woyamba. ");
INSERT INTO nya_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Kenaka anadalitsa Yosefe nati, “Mulungu amene makolo anga Abrahamu ndi Isake anamutumikira, Mulungu amene wakhala ali mʼbusa wanga moyo wanga wonse kufikira lero, ");
INSERT INTO nya_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","mngelo amene wandipulumutsa ine ku zovuta zonse, ameneyo adalitse anyamata awa. Kudzera mwa iwowa dzina langa ndi mayina a makolo anga, Abrahamu ndi Isake, adzamveka. Iwowa adzakhala ndi ana ambiri nadzasanduka mtundu waukulu pa dziko lapansi.” ");
INSERT INTO nya_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yosefe ataona kuti abambo ake ayika dzanja lamanja pa Efereimu, sanakondwere. Choncho anagwira dzanja la abambo ake kuti alichotse pamutu pa Efereimu ndi kuliyika pamutu pa Manase, ");
INSERT INTO nya_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","nati kwa abambo ake, “Ayi, abambo anga, uyu ndiye woyamba kubadwa, ikani dzanja lanu lamanja pamutu pake.” ");
INSERT INTO nya_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Koma abambo ake anakana nati, “Ndikudziwa, mwana wanga, ndikudziwa. Adzukulu a iyeyunso adzakhala mtundu waukulu. Komabe mʼbale wake wamngʼonoyu adzakhala wamkulu kuposa iye, ndipo zidzukulu zake zidzakhala mitundu yayikulu ya anthu.” ");
INSERT INTO nya_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Tsono iye anawadalitsa tsiku limenelo nati, “Aisraeli adzagwiritsa ntchito dzina lanu podalitsa nadzati: Mulungu akudalitseni monga Efereimu ndi Manase.” Choncho anayika Efereimu patsogolo pa Manase. ");
INSERT INTO nya_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Kenaka Israeli anati kwa Yosefe, “Ine ndatsala pangʼono kufa, koma Mulungu adzakhala ndipo adzakutenganinso kubwerera nanu ku dziko la makolo anu. ");
INSERT INTO nya_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ndiponso iwe wekha ndikupatsa moposera abale ako, malo woonjezera, Sekemu, malo amene ndinalanda kwa Aamori ndi lupanga ndi uta wanga.” ");
INSERT INTO nya_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Pambuyo pake Yakobo anayitanitsa ana ake aamuna nati: Sonkhanani pamodzi kuti ndikuwuzeni zimene zidzakuchitikireni mʼmasiku a mʼtsogolo. ");
INSERT INTO nya_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Bwerani ndipo imvani mawu anga, inu ana a Yakobo; mverani abambo anu Israeli. ");
INSERT INTO nya_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Rubeni, ndiwe woyamba kubadwa; mphamvu yanga ndiponso chizindikiro choyamba cha mphamvu zanga, wopambana pa ulemerero ndi mphamvu. ");
INSERT INTO nya_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Wokokoma ngati madzi a chigumula, koma sudzakhalanso wopambana, iwe unagona pa bedi la abambo ako, ndithu unayipitsa bedi la mdzakazi wake. ");
INSERT INTO nya_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeoni ndi Levi ndi pachibale pawo, anachitira nkhanza anthu amene anachita nawo pangano. ");
INSERT INTO nya_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Iwe moyo wanga, usakhale nawo pa misonkhano yawo ya mseri, kapena kugwirizana nawo mʼmabwalo awo, pakuti anapha anthu mu mkwiyo wawo ndipo anapundula ngʼombe zamphongo monga kunawakomera. ");
INSERT INTO nya_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Matemberero awagwere chifukwa cha mkwiyo wawo woopsa chonchi ndi ukali wawo wankhanza choterewu! Ine ndidzawabalalitsa mʼdziko la Yakobo ndi kuwamwaza iwo mʼdziko la Israeli. ");
INSERT INTO nya_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yuda, ndiwe amene abale ako adzatamanda; dzanja lako lidzagwira pa khosi pa adani ako; abale ako adzakugwadira iwe. ");
INSERT INTO nya_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda ali ngati mwana wa mkango; umabwerera ku malo ako ndi zofunkha, mwana wanga. Monga mkango, amadziwongola ndi kugona pansi, ndipo ngati mkango waukazi, ndani angalimbe mtima kumudzutsa? ");
INSERT INTO nya_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ndodo yaufumu sidzachoka mwa Yuda, udzawupanirira ulamuliro motero kuti palibe amene adzawuchotse, mpaka mwini wake weniweni atabwera ndipo mitundu yonse ya anthu idzamumvera. ");
INSERT INTO nya_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ndiye amene amamangirira bulu wake wamkazi kumtengo wa mpesa, ndi mwana wa bulu ku nthambi ya mpesa wabwino. Ndi iye amene amachapa zovala zake mu vinyo; ndi mkanjo wake mu vinyo wofiira ngati magazi. ");
INSERT INTO nya_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Maso ake adzakhala akuda chifukwa cha vinyo, mano ake woyera chifukwa cha mkaka. ");
INSERT INTO nya_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zebuloni adzakhala mʼmphepete mwa nyanja; adzakhala pa dooko la sitima zapamadzi; malire ake adzafika ku Sidoni. ");
INSERT INTO nya_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakara ali ngati bulu wamphamvu wogona pansi pakati pa makola. ");
INSERT INTO nya_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ataona ubwino wake wa pamalo pake popumira ndi kukongola kwa dziko lake, iye anaweramutsa msana kuti anyamule katundu wake ndipo anasanduka wogwira ntchito ya ukapolo. ");
INSERT INTO nya_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dani adzaweruza mwachilungamo anthu ake monga limodzi mwa mafuko a anthu a mu Israeli. ");
INSERT INTO nya_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dani adzakhala ngati njoka ya mʼmphepete mwa msewu, songo yokhala mʼnjira imene imaluma chidendene cha kavalo kuti wokwerapoyo agwe chagada. ");
INSERT INTO nya_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Ndikuyembekeza chipulumutso chanu Yehova. ");
INSERT INTO nya_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gadi adzachitidwa chiwembu ndi gulu la amaliwongo, koma iye adzawathamangitsa. ");
INSERT INTO nya_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Dziko la Aseri lidzabereka chakudya chokoma, ndipo iye adzapereka chakudya kwa mafumu. ");
INSERT INTO nya_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Nafutali ali ngati mbawala yayikazi yokhala ndi ana okongola kwambiri. ");
INSERT INTO nya_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yosefe ali ngati mtengo wobereka zipatso, mtengo wobereka zipatso pafupi ndi kasupe, nthambi zake zimayanga pa chipupa cha mwala. ");
INSERT INTO nya_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Alenje a uta anamuchita chiwembu mwankhanza; anamuthamangitsa ndi mauta awo. ");
INSERT INTO nya_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Koma uta wake sunagwedezeke, ndi manja ake amphamvu aja analimbika, chifukwa cha mphamvu za Mulungu Wamphamvu wa Yakobo, chifukwa ali Mʼbusa ndi Thanthwe la Israeli. ");
INSERT INTO nya_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Chifukwa cha Mulungu wa makolo ako amene amakuthandiza; chifukwa cha Mulungu Wamphamvu, amene amakudalitsa ndi mvula yochokera kumwamba, ndi madzi otumphuka pansi pa nthaka, ndipo amakudalitsa pokupatsa ana ambiri ndi ngʼombe zambiri. ");
INSERT INTO nya_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Madalitso a kholo lako ndi amphamvu kuposa madalitso a mapiri akale oposa zabwino za ku zitunda zamgonagona. Zonse izi zikhale pamutu pa Yosefe, pa mphumi pa wopatulika uja amene anapatulidwa pakati pa abale ake. ");
INSERT INTO nya_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamini ali ngati mʼmbulu wolusa; umene mmawa umapha ndi kudya zofunkha, ndipo madzulo umagawa zofunkhazo,” ");
INSERT INTO nya_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Onse awa ndi mafuko khumi ndi awiri a Israeli, ndipo zimenezi ndi zomwe abambo awo ananena pamene anawadalitsa, kuwapatsa aliyense madalitso ake womuyenera iye. ");
INSERT INTO nya_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Kenaka Yakobo analamula ana ake nati: “Ine ndatsala pangʼono kufa. Tsono mukandiyike pamodzi ndi makolo anga mʼphanga la mʼmunda wa Efroni Mhiti. ");
INSERT INTO nya_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ili ndi phanga la mʼmunda wa Makipela, pafupi ndi Mamre mʼdziko la Kanaani. Abrahamu anagula phangalo pamodzi ndi munda womwe kwa Efroni Mhiti kuti pakhale manda. ");
INSERT INTO nya_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Kumeneko kunayikidwa Abrahamu ndi mkazi wake Sara, Isake ndi mkazi wake Rebeka ndipo ndinayikakonso Leya. ");
INSERT INTO nya_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Munda ndi manda amene ali mʼmenemo zinagulidwa kwa Ahiti.” ");
INSERT INTO nya_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakobo atamaliza kupereka malangizo kwa ana ake, anabwezera miyendo yake pa bedi, namwalira ndipo anakakhala ndi anthu a mtundu wake. ");
INSERT INTO nya_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Kenaka Yosefe anadzigwetsa pa nkhope ya abambo ake, nawapsompsona kwinaku akulira. ");
INSERT INTO nya_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ndipo Yosefe analamula antchito ake a chipatala kuti akonze thupi la Israeli ndi mankhwala kuti lisawole. Kotero antchitowo anakonzadi thupilo. ");
INSERT INTO nya_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Antchito aja zinawatengera masiku 40 kuti akonze mtembo uja popeza ntchito ngati imeneyi inafunikira masiku monga amenewa. Ndipo Aigupto anamulira Yakobo kwa masiku makumi asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Yosefe atatha kulira maliro a abambo ake, anayankhula kwa nduna za Farao nati, “Ngati mungandikomere mtima, chonde mundiyankhulire kwa Farao kumuwuza kuti, ");
INSERT INTO nya_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Abambo anga anandilumbiritsa ndipo anati, ‘Ndatsala pangʼono kumwalira, ukandiyike mʼmanda amene ndinakumba ndekha mʼdziko la Kanaani.’ Tsono mundilole ndikayike abambo anga, ndipo ndikabweranso.’ ” ");
INSERT INTO nya_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Farao anati, “Pita ukayike abambo ako monga anakulumbiritsa kuti uchite.” ");
INSERT INTO nya_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Kotero Yosefe anapita kukayika abambo ake. Nduna zonse za Farao, akuluakulu a bwalo lake ndi akuluakulu a ku Igupto, anapita naye pamodzi. ");
INSERT INTO nya_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Anapitanso onse a pa banja la Yosefe ndi abale ake ndi onse amene anali a pa banja la abambo ake. Ana awo okha, nkhosa ndi ngʼombe zinatsala ku Goseni ");
INSERT INTO nya_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Asilikali okwera pa magaleta ndi asilikali a pa akavalo anapita nayenso pamodzi. Linali gulu lalikulu. ");
INSERT INTO nya_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Atafika pa Goreni ha-Atadi, pafupi ndi Yorodani, anachita mwambo waukulu wa maliro. Choncho Yosefe analira maliro a abambo ake masiku asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Akanaani amene ankakhala ku Goreni ha-Atadi ataona mwambo wa maliro anati, “Aigupto ali ndi mwambo wa maliro a akulu.” Ndi chifukwa chake malo amenewo a pafupi ndi Yorodani amatchedwa Abeli-Mizraimu. ");
INSERT INTO nya_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Choncho ana a Yakobo anachita monga momwe abambo awo anawalamula: ");
INSERT INTO nya_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ndiye kuti ana a Yakobo anamunyamula kupita naye ku Kanaani kuti akamuyike mʼphanga limene lili mʼmunda wa Makipela pafupi ndi Mamre. Abrahamu anagula mundawo kwa Efroni Mhiti kuti pakhale manda. ");
INSERT INTO nya_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Atatha kuyika abambo ake, Yosefe anabwerera ku Igupto, pamodzi ndi abale ake ndi onse amene anapita nawo kukayika abambo ake. ");
INSERT INTO nya_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Abale ake a Yosefe ataona kuti abambo awo amwalira, anati, “Nanga tidzatani ngati Yosefe anatisungira mangawa nafuna kutibwezera pa zoyipa zonse zimene tinamuchitira?” ");
INSERT INTO nya_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Motero anatumiza mawu kwa Yosefe kuti, “Abambo anu anasiya malangizo asanafe nati: ");
INSERT INTO nya_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Zimene mudzayenera kunena kwa Yosefe ndi izi: Ndikukupempha kuti uwakhululukire abale ako cholakwa chawo ndi machimo awo, popeza anakuchitira zoyipa.’ Ndiye tsopano chonde tikhululukireni zolakwa zimene ife akapolo a Mulungu wa abambo anu tinachita.” Yosefe atangomva mawu amenewa anayamba kulira. ");
INSERT INTO nya_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Kenaka abale ake anabwera nadzigwetsa pansi pamaso pake, nati, “Ife ndife akapolo anu.” ");
INSERT INTO nya_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Koma Yosefe anawawuza kuti, “Musachite mantha. Kodi ine ndalowa mʼmalo mwa Mulungu? ");
INSERT INTO nya_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Inu munafuna kundichitira zoyipa, koma Mulungu anasandutsa zoyipazo kuti zikhale zabwino kuti zikwaniritsidwe zimene zikuchitika panozi, zopulumutsa miyoyo yambiri. ");
INSERT INTO nya_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kotero, musachite mantha. Ine ndidzasamalira inu pamodzi ndi ana anu omwe.” Tsono iye anawalimbitsa mtima powayankhula moleza mtima. ");
INSERT INTO nya_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yosefe anakhala mu Igupto pamodzi ndi banja lonse la abambo ake. Anakhala ndi moyo zaka 110 ");
INSERT INTO nya_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ndipo anaona mʼbado wachitatu wa ana a Efereimu. Yosefe anatenganso ana a Makiri, mwana wa Manase kukhala ngati ana a mʼbanja lake. ");
INSERT INTO nya_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Kenaka Yosefe anati kwa abale ake, “Ine ndatsala pangʼono kufa. Koma mosakayika Mulungu adzakuyangʼanirani nadzakutengani kukutulutsani mʼdziko lino kupita ku dziko limene Iye analonjeza kwa Abrahamu, Isake ndi Yakobo.” ");
INSERT INTO nya_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ndipo Yosefe analumbiritsa ana a Israeli lumbiro nati, “Lonjezani kuti Mulungu akadzakusungani mudzanyamula mafupa anga kuwachotsa ku malo kuno.” ");
INSERT INTO nya_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Choncho Yosefe anafa ali ndi zaka 110. Motero iwo atakonza thupi lake ndi mankhwala kuti lisawole, analiyika mʼbokosi ku Igupto.");
INSERT INTO nya_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Awa ndi mayina a ana a Israeli amene anapita ku Igupto pamodzi ndi Yakobo abambo awo, aliyense ndi banja lake: ");
INSERT INTO nya_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubeni, Simeoni, Levi, Yuda; ");
INSERT INTO nya_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakara, Zebuloni, Benjamini; ");
INSERT INTO nya_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani, Nafutali; Gadi ndi Aseri. ");
INSERT INTO nya_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Anthu onse obadwa mwa Yakobo analipo 70. Yosefe nʼkuti ali kale ku Igupto. ");
INSERT INTO nya_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Tsono Yosefe ndi abale ake onse ndiponso mʼbado wawo wonse anamwalira. ");
INSERT INTO nya_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Koma Aisraeli anaberekana ndi kuchuluka kwambiri nakhala amphamvu kwambiri, kotero kuti anadzaza dzikolo. ");
INSERT INTO nya_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Pambuyo pake mfumu yatsopano imene sinkamudziwa Yosefe, inayamba kulamulira dziko la Igupto. ");
INSERT INTO nya_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Iyo inati kwa anthu ake, “Taonani, Aisraeli achuluka ndipo ndi amphamvu kwambiri kuposa ife. ");
INSERT INTO nya_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Tiyeni tiwachenjerere. Tikapanda kutero adzachuluka kuposa ife, ndipo ngati kutakhala nkhondo, adzadziphatika kwa adani athu nadzamenyana nafe, kenaka nʼkudzachoka mʼdziko muno.” ");
INSERT INTO nya_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Kotero anayika akapitawo kuti aziwazunza ndi kuwagwiritsa ntchito yolemetsa mokakamiza. Iwo anamangira Farao mizinda ya Pitomu ndi Ramesesi kumene ankasungirako chakudya. ");
INSERT INTO nya_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Koma pamene ankawazunza kwambiri, Aisraeli ndiye ankachulukirachulukira mpaka kubalalikira mʼdziko lonse. Kotero Aigupto anayamba kuopa Aisraeliwo ");
INSERT INTO nya_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ndipo anawagwiritsa ntchito mwankhanza kwambiri. ");
INSERT INTO nya_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Aigupto anachititsa moyo wa Aisraeli kukhala owawa kwambiri powagwiritsa ntchito yakalavulagaga yowumba njerwa ndi kuponda dothi lomangira, pamodzi ndi ntchito zina zosiyanasiyana zamʼminda. Iwo anakakamiza Aisraeli mwankhanza kuti agwire ntchito yowawayi. ");
INSERT INTO nya_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Mfumu ya Igupto inati kwa azamba a Chihebri omwe mayina awo anali Sifira ndi Puwa, ");
INSERT INTO nya_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Mukamathandiza amayi a Chihebri pa mwala wochirira, muzionetsetsa kuti akabadwa mwana wamwamuna muzipha, koma akakhala wamkazi muzimuleka akhale ndi moyo.” ");
INSERT INTO nya_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Koma azambawo ankaopa Mulungu ndipo sanachite zimene mfumu ya Igupto inawawuza kuti achite. Iwo analeka ana aamuna kuti akhale ndi moyo. ");
INSERT INTO nya_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Kenaka mfumu ya Igupto inayitanitsa azamba aja ndi kuwafunsa kuti, “Chifukwa chiyani mwachita zimenezi? Bwanji mwasiya ana aamuna kuti akhale ndi moyo?” ");
INSERT INTO nya_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Azambawo anamuyankha Farao kuti, “Amayi a Chihebri sali ngati amayi a Chiigupto; Iwo ndi amphamvu ndipo amachira azamba asanafike.” ");
INSERT INTO nya_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Kotero Mulungu anawakomera mtima azambawo, ndipo Aisraeli anapitirirabe kuchulukana nakhala amphamvu kwambiri. ");
INSERT INTO nya_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Pakuti azambawo ankaopa Mulungu, Iye anawapatsa mabanja awoawo. ");
INSERT INTO nya_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Pamenepo Farao analamulira anthu ake onse kuti, “Mwana wamwamuna aliyense akabadwa, mukamuponye mu mtsinje wa Nailo, koma wamkazi mulekeni akhale ndi moyo.” ");
INSERT INTO nya_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ndipo munthu wina wa fuko la Levi anakwatira mkazi wa fuko lomwelo. ");
INSERT INTO nya_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Mkaziyo anatenga pathupi ndipo anabereka mwana wamwamuna. Ataona kuti mwanayo anali wokongola, anamubisa kwa miyezi itatu. ");
INSERT INTO nya_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Koma mwanayo atafika pa msinkhu woti sakanathanso kubisidwa, amayi ake anatenga kadengu kopangidwa ndi bango nakamata phula. Kenaka anayika mwanayo mʼmenemo ndi kukamuyika pa mabango mu mtsinje wa Nailo. ");
INSERT INTO nya_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Mlongo wake wa mwanayo anayima pataliko kuti aone chimene chidzamuchitikira mwanayo. ");
INSERT INTO nya_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Mwana wamkazi wa Farao anapita ku mtsinje wa Nailo kukasamba ndipo adzakazi ake ankayenda mʼmbali mwa mtsinjewo. Tsono mwana wa Farao uja anaona kadenguko pakati pa mabango ndipo anatuma mdzakazi wake kuti akakatenge. ");
INSERT INTO nya_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Iye atavundukula anaona mwana wamwamuna akungolira. Iye anamva naye chisoni mwana uja, nati, “Ameneyu ndi mmodzi mwa ana a Chihebri.” ");
INSERT INTO nya_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Kenaka mlongo wake wa mwanayo anafunsa mwana wa Farao kuti, “Ndingapite kukakupezerani mmodzi mwa amayi a Chihebri kuti azikakulererani mwanayu?” ");
INSERT INTO nya_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Iye anayankha kuti, “Inde, pita.” Ndipo mtsikanayo anapita nakayitana amayi a mwanayo. ");
INSERT INTO nya_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Mwana wa Farao anati, “Tengani mwanayu mukandilerere, ndidzakulipirani.” Mayiyo anatenga mwanayo kukamulera. ");
INSERT INTO nya_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Mwanayo atakula anakamupereka kwa mwana wa Farao ndipo anakhala mwana wake. Iye anamutcha dzina lake Mose, popeza anati, “Ndinamuvuwula mʼmadzi.” ");
INSERT INTO nya_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Tsiku lina, Mose atakula, anapita kumene kunali anthu a mtundu wake ndipo anawaona akugwira ntchito yowawa. Iye anaona Mwigupto akumenya Mhebri, mmodzi mwa anthu a mtundu wake. ");
INSERT INTO nya_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Atayangʼana uku ndi uku, naona kuti panalibe wina aliyense, Mose anamupha Mwiguptoyo ndipo anamukwirira mu mchenga. ");
INSERT INTO nya_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Mmawa mwake Mose anapita ndipo anaona anthu awiri a Chihebri akumenyana. Iye anafunsa amene anali wolakwa kuti, “Chifukwa chiyani ukumenya Mhebri mnzako?” ");
INSERT INTO nya_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Munthu uja anati, “Kodi ndani anakuyika kuti ukhale wotilamulira ndi wotiweruza? Kodi ukufuna kundipha monga momwe unaphera Mwigupto uja?” Mose anachita mantha ndipo anati mu mtima mwake, “Chimene ndinachita chija chadziwika.” ");
INSERT INTO nya_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Farao atamva zimenezi anafuna kuti aphe Mose, koma Mose anathawa ndipo anapita kukakhala ku Midiyani. Ali kumeneko, tsiku lina anakhala pansi pafupi ndi chitsime. ");
INSERT INTO nya_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Wansembe wa ku Midiyaniko anali ndi ana aakazi asanu ndi awiri. Iwowa anabwera kudzatunga madzi ndi kudzaza mu zomwera kuti amwetse nkhosa za abambo awo. ");
INSERT INTO nya_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Koma kunabwera abusa ena amene anathamangitsa atsikana aja. Ndiye Mose anayimirira nawathandiza atsikana aja ndi kumwetsa nkhosa zawo. ");
INSERT INTO nya_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Atsikana aja atabwerera kwa abambo awo Reueli, iye anawafunsa kuti, “Chifukwa chiyani lero mwabwera msanga?” ");
INSERT INTO nya_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Atsikanawo anayankha kuti, “Mwigupto wina ndiye watilanditsa kwa abusa. Ndiponso anatitungira madzi ndi kumwetsa ziweto zathu.” ");
INSERT INTO nya_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Tsono Reueli anafunsa ana ake kuti, “Ndiye ali kuti munthuyo? Chifukwa chiyani mwamusiya? Kamuyitaneni kuti adzadye.” ");
INSERT INTO nya_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mose anavomera kukhala ndi Reueli, ndipo anamupatsa Zipora kuti akhale mkazi wake. ");
INSERT INTO nya_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Zipora anabereka mwana wa mwamuna amene Mose anamutcha Geresomu, popeza anati, “Ndakhala mlendo mʼdziko la eni.” ");
INSERT INTO nya_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Nthawi yonseyo nʼkuti ana a Israeli akulira chifukwa cha ukapolo wawo uja. Iwo anafuwula kupempha thandizo, ndipo kulira kwawoko kunafika kwa Mulungu. ");
INSERT INTO nya_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Mulungu anamva kubuwula kwawo ndipo anakumbukira pangano lake ndi Abrahamu, Isake ndi Yakobo. ");
INSERT INTO nya_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Mulungu ataona Aisraeli aja ndi masautso awo, Iye anawamvera chifundo. ");
INSERT INTO nya_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Tsono Mose amaweta ziweto za mpongozi wake Yetero, wansembe uja wa ku Midiyani. Tsiku lina iye anazitsogolera kupita ku chipululu ndipo anafika ku phiri la Mulungu lotchedwa Horebu. ");
INSERT INTO nya_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Kumeneko mngelo wa Yehova anaonekera kwa iye mʼmalawi amoto mʼchitsamba. Mose anaona kuti ngakhale chitsambacho chimayaka koma sichimanyeka. ");
INSERT INTO nya_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Tsono Mose anati mu mtima mwake, “Ine ndipita komweko ndikaone zodabwitsazi, chitsamba sichikunyeka chifukwa chiyani?” ");
INSERT INTO nya_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Yehova ataona kuti Mose anapatuka kuti adzaonetsetse, Mulungu anamuyitana Mose kuchokera mʼchitsambamo nati, “Mose! Mose!” Ndipo anayankha, “Wawa.” ");
INSERT INTO nya_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Mulungu anati, “Usayandikire kuno. Vula nsapato zako, pakuti malo amene wayimapo ndi opatulika.” ");
INSERT INTO nya_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Mulungu anati, “Ine ndine Mulungu wa makolo ako, Mulungu wa Abrahamu, Mulungu wa Isake, ndi Mulungu wa Yakobo.” Atamva zimenezi, Mose anaphimba nkhope yake chifukwa anaopa kuona Mulungu. ");
INSERT INTO nya_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Yehova anati, “Ine ndaona ndithu mazunzo a anthu anga amene ali ku Igupto. Ndamva kulira kwawo chifukwa cha anthu amene akuwapsinja, ndipo ndakhudzidwa ndi masautso awo. ");
INSERT INTO nya_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Choncho ndabwera kuti ndiwapulumutse mʼdzanja la Aigupto, kuwatulutsa mʼdzikolo ndi kukawalowetsa mʼdziko labwino ndi lalikulu, dziko loyenda mkaka ndi uchi, kwawo kwa Akanaani, Ahiti, Aamori, Aperezi, Ahivi ndi Ayebusi. ");
INSERT INTO nya_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ine ndamva ndithu kulira kwa Aisraeli, ndipo ndaona mmene Aigupto akuwazunzira. ");
INSERT INTO nya_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Kotero tsopano, pita. Ine ndikukutuma kwa Farao kuti ukatulutse anthu anga, Aisraeli mʼdziko la Igupto.” ");
INSERT INTO nya_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Koma Mose anafunsa Mulungu, “Ine ndine yani kuti ndipite kwa Farao ndi kukatulutsa Aisraeli mʼdziko la Igupto?” ");
INSERT INTO nya_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ndipo Mulungu anati, “Ine ndidzakhala nawe, ndipo ichi chidzakhala chizindikiro kwa iwe kuti ndine amene ndakutuma; Ukadzatulutsa anthu anga mʼdziko la Igupto, udzapembedza Mulungu pa phiri lino.” ");
INSERT INTO nya_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mose anati kwa Mulungu, “Ngati ndipita kwa Aisraeli ndi kukawawuza kuti, ‘Mulungu wa makolo anu wandituma kwa inu,’ ndipo iwo nʼkukandifunsa kuti ‘Dzina lake ndi ndani?’ Tsono ine ndikawawuze chiyani?” ");
INSERT INTO nya_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Mulungu anati kwa Mose, “NDINE AMENE NDILI. Izi ndi zimene ukanene kwa Aisraeli: ‘NDINE wandituma kwa inu.’ ” ");
INSERT INTO nya_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Mulungu anatinso kwa Mose, “Ukanene kwa Aisraeli kuti ‘Yehova, Mulungu wa makolo anu, Mulungu wa Abrahamu, Mulungu wa Isake, ndi Mulungu wa Yakobo, wandituma kwa inu.’ Ili ndilo dzina langa mpaka muyaya, ndipo mibado ya mʼtsogolomo izidzanditchula ndi dzina limeneli. ");
INSERT INTO nya_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Pita, ukawasonkhanitse akuluakulu a Israeli ndipo ukati kwa iwo, ‘Yehova, Mulungu wa makolo anu, Mulungu wa Abrahamu, Isake ndi Yakobo, anandionekera ndipo akuti Iye wadzakuyenderani ndipo waona mmene Aigupto akukuzunzirani. ");
INSERT INTO nya_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Choncho wanenetsa kuti adzakutulutsani mʼdziko la Igupto, dziko la masautsoli kupita ku dziko la Akanaani, Ahiti, Aamori Aperezi, Ahivi ndi Ayebusi, dziko loyenda mkaka ndi uchi.’ ");
INSERT INTO nya_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Akuluakulu a Israeli akakumvera. Kenaka iwe ndi akuluakuluwo mukapite kwa mfumu ya Igupto ndipo mukanene kuti, ‘Yehova, Mulungu wa Ahebri, wakumana nafe. Tsono tikukupemphani kuti mutilole tipite pa ulendo wa masiku atatu mʼchipululu kuti tikapereke nsembe kwa Yehova Mulungu wathu.’ ");
INSERT INTO nya_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Koma Ine ndikudziwa kuti mfumu ya Igupto sikakulolani kuti mupite pokhapokha Ine nditayikakamiza. ");
INSERT INTO nya_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Tsono Ine ndidzatambasula dzanja langa ndi kukantha Aigupto ndi zodabwitsa zanga zimene ndidzazichita pakati pawo. Zikadzatha izi, Iye adzakulolani kuti mupite. ");
INSERT INTO nya_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Ndipo ine ndidzafewetsa mtima wa Aigupto pa anthu anga, kotero kuti mukadzatuluka simudzapita wopanda kanthu. ");
INSERT INTO nya_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Mkazi aliyense adzapemphe Mwigupto woyandikana naye ndiponso mkazi amene akukhala mʼnyumba yake, kuti amupatse ziwiya za siliva ndi golide ndiponso zovala zimene mudzaveka ana anu aamuna ndi aakazi. Ndipo potero mudzawalanda zonse Aiguptowo.” ");
INSERT INTO nya_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mose anayankha, “Aisraeliwo sakandikhulupirira ndipo sakandimvera. Iwowo adzati, ‘Yehova sanakuonekere iwe.’ ” ");
INSERT INTO nya_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ndipo Yehova anamufunsa nati, “Nʼchiyani chili mʼdzanja lakolo?” Mose anayankha kuti, “Ndodo.” ");
INSERT INTO nya_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Yehova anati, “Tayiponya pansi.” Mose anayiponya pansi ndipo inasanduka njoka ndipo anayithawa. ");
INSERT INTO nya_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Kenaka Yehova anati kwa iye, “Igwire mtchira.” Ndipo Mose anayigwira mchira njokayo ndipo inasandukanso ndodo mʼdzanja lake. ");
INSERT INTO nya_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Yehova anati, “Ukachite zimenezi ndipo akakukhulupirira kuti Yehova, Mulungu wa makolo awo, Mulungu wa Abrahamu, Mulungu wa Isake ndi Mulungu wa Yakobo, wakuonekera iwe.” ");
INSERT INTO nya_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Yehova anatinso, “Pisa dzanja lako mʼmalaya akowo.” Choncho Mose anapisa dzanja lake mʼmalaya ake ndipo pamene analitulutsa, linali la khate kuchita kuti mbuu ngati ufa. ");
INSERT INTO nya_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Yehova anati, “Tsopano pisanso dzanja lako mʼmalaya.” Mose anapisanso dzanja lakelo mʼmalaya ake ndipo atalitulutsa, linali labwinobwino, ngati thupi lake lonse. ");
INSERT INTO nya_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Tsono Yehova anati “Akakapanda kukukhulupirira, osalabadira chozizwitsa choyambacho, akakhulupirira ndithu chifukwa cha chozizwitsa chachiwiricho. ");
INSERT INTO nya_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Koma ngati sakakhulupirira zizindikiro ziwiri izi kapena kukumvera, ukatunge madzi a mu mtsinje wa Nailo ndi kuwathira pa mtunda powuma ndipo madziwo adzasanduka magazi.” ");
INSERT INTO nya_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mose anati kwa Yehova, “Chonde Ambuye, chikhalire ine ndakhala munthu wosatha kuyankhula bwino. Ngakhale tsopano pamene mukundiyankhula, lilime langa ndi lolemera. Ndine wachibwibwi.” ");
INSERT INTO nya_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Yehova anati kwa iye, “Kodi anapatsa munthu pakamwa ndani? Ndani amasandutsa munthu kuti akhale wosayankhula kapena wosamva? Ndani amapanga munthu kukhala wopenya kapena wosaona? Kodi si Ine Yehova? ");
INSERT INTO nya_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Tsopano pita, Ine ndidzakuthandiza kuyankhula ndipo ndidzakulangiza zoti ukanene.” ");
INSERT INTO nya_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Koma Mose anati, “Chonde Ambuye, pepani, tumani wina kuti akachite zimenezi.” ");
INSERT INTO nya_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Kenaka Yehova anamupsera mtima Mose ndipo anati, “Kodi suli ndi mʼbale wako Aaroni wa fuko la Levi? Ine ndikudziwa kuti iye amayankhula bwino. Iye wanyamuka kale kudzakumana nawe ndipo adzasangalala akadzakuona. ");
INSERT INTO nya_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Iwe udzayankhula naye ndi kumuwuza mawu oti akanene. Ine ndidzakuthandizani kuyankhula nonse awirinu ndi kukulangizani zoti mukachite. ");
INSERT INTO nya_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Iye akayankhula kwa anthu mʼmalo mwako. Iye adzakhala wokuyankhulira ndipo iweyo udzakhala ngati Mulungu kwa iye. ");
INSERT INTO nya_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Koma utenge ndodo imene ili mʼdzanja lakoyo kuti ukachite nayo zizindikiro zozizwitsa.” ");
INSERT INTO nya_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Tsono Mose anabwerera kwa Yetero, mpongozi wake ndipo anati kwa Iye, “Chonde ndiloleni kuti ndibwerere ku Igupto kwa anthu anga kuti ndikaone ngati ali moyo.” Yeteri anati, “Pitani mu mtendere.” ");
INSERT INTO nya_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Nthawiyi Yehova anali atamuwuza kale Mose ku Midiyani kuti, “Bwerera ku Igupto, pakuti anthu onse amene amafuna kukupha aja anamwalira.” ");
INSERT INTO nya_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Kotero Mose anatenga mkazi wake ndi ana ake aamuna, ndipo anawakweza pa bulu nayamba ulendo wobwerera ku Igupto. Ndipo anatenga ndodo ya Mulungu ija mʼdzanja lake. ");
INSERT INTO nya_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Yehova anati kwa Mose, “Ukaonetsetse kuti wachita pamaso pa Farao zodabwitsa zonse zimene ndayika mphamvu mwa iwe kuti ukachite. Koma Ine ndidzawumitsa mtima wake kotero kuti sadzalola anthuwo kuti apite. ");
INSERT INTO nya_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ndipo iwe ukati kwa Farao, ‘Yehova akuti, Israeli ali ngati mwana wanga wachisamba.’ ");
INSERT INTO nya_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Choncho ndikuti, ‘Mulole mwana wanga apite kuti akandipembedze. Koma ngati ukana, Ine ndidzapha mwana wako wachisamba.’ ” ");
INSERT INTO nya_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Pambuyo pake Mose ali mʼnjira, pamalo wogona, Yehova anakumana naye, ndipo anafuna kumupha. ");
INSERT INTO nya_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Koma Zipora anatenga mwala wakuthwa nachita mdulidwe mwana wake ndipo khungulo analikhudzitsa pa mapazi a Mose. Iye anati “Zoonadi, kwa ine ndiwe mkwati wamagazi.” ");
INSERT INTO nya_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Choncho Yehova anamuleka Mose wosamupha. Pa nthawiyo, Zipora anati, “Mkwati wa magazi,” ponena za mdulidwe. ");
INSERT INTO nya_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Yehova anati kwa Aaroni, “Pita ku chipululu ukakumane ndi Mose.” Iye anapitadi nakakumana ndi Mose pa phiri la Mulungu namupsompsona. ");
INSERT INTO nya_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Kenaka Mose anamufotokozera Aaroni chilichonse chimene Yehova anamutuma kuti akanene. Anamufotokozera za zizindikiro zozizwitsa zimene anamulamulira kuti akazichite. ");
INSERT INTO nya_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mose ndi Aaroni anapita kukasonkhanitsa pamodzi akuluakulu onse a Aisraeli. ");
INSERT INTO nya_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Ndipo Aaroni anawafotokozera zonse zimene Yehova ananena kwa Mose. Anachita zizindikirozo pamaso pa anthu onse, ");
INSERT INTO nya_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ndipo anakhulupirira. Iwo atamva kuti Yehova anadzawayendera ndi kuti waona mmene akuzunzikira, anaweramitsa mitu pansi napembedza. ");
INSERT INTO nya_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Zitachitika izi, Mose ndi Aaroni anapita kwa Farao ndipo anati, “Yehova Mulungu wa Israeli akuti, ‘Aloleni anthu anga apite, kuti akachite chikondwerero cha Ine mʼchipululu.’ ” ");
INSERT INTO nya_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Koma Farao anati, “Yehova ndani kuti ine ndimumvere ndi kulola Aisraeli kuti apite? Ine Yehova sindikumudziwa ndipo sindilola kuti Aisraeli apite.” ");
INSERT INTO nya_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ndipo iwo anati, “Mulungu wa Ahebri anakumana nafe. Chonde tiloleni tipite ulendo wa masiku atatu ku chipululu kuti tikapereke nsembe kwa Yehova Mulungu wathu, ngati sititero iye adzatipweteka ndi miliri kapena lupanga.” ");
INSERT INTO nya_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Koma mfumu ya Igupto inati, “Mose ndi Aaroni, chifukwa chiyani mukuchititsa anthuwa kuti asagwire ntchito zawo? Bwererani ku ntchito zanu!” ");
INSERT INTO nya_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ndiponso Farao anati, “Taonani, anthuwa mʼdziko muno alipo ochuluka, ndipo inu mukuwaletsa kugwira ntchito.” ");
INSERT INTO nya_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Pa tsiku lomwelo Farao analamulira akapitawo a thangata ndi anzawo a Chiisraeli amene ankayangʼanira anthu kuti ");
INSERT INTO nya_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Inu musawapatsenso udzu wopangira njerwa monga mumachitira kale, iwo azipita ndi kukatenga udzu wawo. ");
INSERT INTO nya_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Koma musawachepetsere chiwerengero cha njerwa chomwe munawalamulira kale kuti aziwumba. Iwowa ndi aulesi. Nʼchifukwa chake akulira kuti, ‘Tiloleni tipite tikapereke nsembe kwa Mulungu wathu.’ ");
INSERT INTO nya_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Muwakhawulitse ndi ntchito anthu amenewa kuti azitanganidwa, asakhale ndi mpata omvera zabodza.” ");
INSERT INTO nya_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Choncho akapitawo a thangata ndi anzawo a Chiisraeli amene ankayangʼanira anthu anapita kwa anthu aja nati, “ ‘Farao akuti sadzakupatsaninso udzu. ");
INSERT INTO nya_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Mʼmalo mwake mupite mukadzimwetere udzu kulikonse kumene mungawupeze. Komabe ntchito yanu sichepetsedwa.’ ” ");
INSERT INTO nya_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Kotero anthuwo anamwazikana mʼdziko lonse la Igupto kukamweta udzu. ");
INSERT INTO nya_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Akapitawo a thangata aja anawafulumiza anthu aja nati, “Malizani kugwira ntchito yanu ya tsiku ndi tsiku monga mmene zinalili pamene munkapatsidwa udzu.” ");
INSERT INTO nya_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Akapitawo a thangata a Farao ankawamenya oyangʼanira anzawo a Chiisraeli aja nawapanikiza kuti, “Chifukwa chiyani lero simunawumbe chiwerengero chovomerezeka cha njerwa monga chakale chija?” ");
INSERT INTO nya_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Pamenepo oyangʼanira anzawo a Chiisraeli aja anapita kukadandaula kwa Farao kuti, “Chifukwa chiyani mwachitira antchito anu zotere? ");
INSERT INTO nya_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Antchito anu sakupatsidwa udzu, komabe akutiwuza kuti, ‘Umbani njerwa!’ Antchito anu akumenyedwa, koma cholakwa sichili ndi anthu anu.” ");
INSERT INTO nya_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Farao anati, “Ulesi, inu ndinu alesi! Nʼchifukwa chake mukumanena kuti, ‘Mutilole tipite kukapereka nsembe kwa Yehova.’ ");
INSERT INTO nya_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Pitani tsopano kuntchito. Simudzapatsidwanso udzu komabe muyenera kuwumba muyeso wanu wovomerezeka wa njerwa.” ");
INSERT INTO nya_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Oyangʼanira anzawo a Chiisraeli anazindikira kuti ali pa mavuto pamene anawuzidwa kuti, “Musachepetse chiwerengero cha njerwa chimene muyenera kuwumba tsiku lililonse.” ");
INSERT INTO nya_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Atachoka pamaso pa Farao, anakumana ndi Mose ndi Aaroni akuwadikira, ");
INSERT INTO nya_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ndipo iwo anati, “Yehova akupenyeni ndi kukuweruzani popeza mwachititsa Farao ndi nduna zake kuti anyansidwe nafe ndipo mwayika lupanga mʼmanja mwawo kuti atiphe.” ");
INSERT INTO nya_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mose anabwerera kwa Yehova ndipo anati, “Chonde Ambuye, chifukwa chiyani mukuzunza anthu anu? Kodi munanditumira zimenezi? ");
INSERT INTO nya_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Chipitireni changa kwa Farao kukamuyankhula mʼdzina lanu, iye wakhala akuzunza anthuwa, ndipo inu simunawapulumutse konse anthu anu.” ");
INSERT INTO nya_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Yehova anawuza Mose kuti, “Tsopano udzaona zimene ndimuchite Farao: Chifukwa cha dzanja langa lamphamvu adzalola anthu anga kuti atuluke. Chifukwa cha dzanja langa lamphamvu adzawatulutsa mʼdziko lake.” ");
INSERT INTO nya_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Mulungu anatinso kwa Mose, “Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ndinaonekera kwa Abrahamu, kwa Isake ndi kwa Yakobo monga Mulungu Wamphamvuzonse, koma sindinawadziwitse dzina langa kuti ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ndinakhazikitsa pangano langa ndi iwo kuwalonjeza kuti ndidzawapatsa dziko la Kanaani kumene anakhalako kale ngati alendo. ");
INSERT INTO nya_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ndamvanso kubuwula kwa Aisraeli, amene Aigupto awayesa akapolo ndipo ndakumbukira pangano langa.” ");
INSERT INTO nya_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Nʼchifukwa chake nena kwa Aisraeli kuti, ‘Ine ndine Yehova, ndipo ndidzakutulutsani mʼgoli la Aigupto. Ndidzakumasulani mu ukapolo, ndidzakuwombolani ndi dzanja langa lotambasuka ndi kuchita ntchito zachiweruzo. ");
INSERT INTO nya_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ndidzakutengani kukhala anthu anga, ndipo Ine ndidzakhala Mulungu wanu. Pamenepo inu mudzadziwa kuti Ine ndine Yehova Mulungu wanu amene ndinakutulutsani mʼgoli la Aigupto. ");
INSERT INTO nya_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ndipo ndidzakufikitsani ku dziko limene ndinalumbira kuti ndidzalipereka kwa Abrahamu, kwa Isake ndi kwa Yakobo. Ndidzakupatsani dziko limenelo kuti likhale lanu. Ine ndine Yehova.’ ” ");
INSERT INTO nya_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mose anawafotokozera Aisraeli zimenezi, koma iwo sanamumvere chifukwa cha kukhumudwa ndi goli lankhanza. ");
INSERT INTO nya_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Kenaka Yehova anati kwa Mose, ");
INSERT INTO nya_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Pita ukawuze Farao mfumu ya Igupto kuti awalole Aisraeli atuluke mʼdziko lake.” ");
INSERT INTO nya_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Koma Mose ananena kwa Yehova kuti, “Ngati Aisraeli sanandimvere, Farao akandimvera chifukwa chiyani, pajatu sinditha kuyankhula bwino?” ");
INSERT INTO nya_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ndipo Yehova analamula Mose ndi Aaroni kuti awuze Aisraeli ndi Farao mfumu ya Igupto kuti Aisraeli ayenera kutuluka mʼdziko la Igupto. ");
INSERT INTO nya_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Atsogoleri a mafuko awo anali awa: Ana a Rubeni mwana wachisamba wa Israeli anali Hanoki, Palu, Hezironi ndi Karimi. Awa anali mafuko a Rubeni. ");
INSERT INTO nya_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ana a Simeoni anali Yemueli, Yamini, Ohadi, Yakini, Zohari ndi Saulo mwana wa kwa mkazi wa Chikanaani. Awa anali mafuko a Simeoni. ");
INSERT INTO nya_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Mayina a ana a Levi pamodzi ndi zidzukulu zawo anali awa: Geresoni, Kohati ndi Merari. Levi anakhala ndi moyo kwa zaka 137. ");
INSERT INTO nya_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ana a Geresoni, mwa mafuko awo, anali Libini ndi Simei. ");
INSERT INTO nya_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ana a Kohati anali Amramu, Izihari, Hebroni ndi Uzieli. Kohati anakhala ndi moyo zaka 133. ");
INSERT INTO nya_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ana a Merari anali Mali ndi Musi. Awa anali mafuko a Levi monga mwa mibado yawo. ");
INSERT INTO nya_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amramu anakwatira Yokobedi mlongo wa abambo ake, amene anabereka Aaroni ndi Mose. Amramu anakhala ndi moyo kwa zaka 137. ");
INSERT INTO nya_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ana a Izihari anali Kora, Nefegi ndi Zikiri. ");
INSERT INTO nya_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ana a Uzieli anali Misaeli, Elizafani ndi Sitiri. ");
INSERT INTO nya_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaroni anakwatira Eliseba, mwana wamkazi wa Aminadabu, mlongo wa Nasoni ndipo Iye anabereka Nadabu, Abihu, Eliezara ndi Itamara. ");
INSERT INTO nya_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ana a Kora anali Asiri, Elikana ndi Abiasafu. Awa ndiwo mafuko a Kora. ");
INSERT INTO nya_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eliezara mwana wa Aaroni anakwatira mmodzi mwa ana aakazi a Putieli, ndipo anabereka Finehasi. Awa anali atsogoleri a mabanja a Levi, monga mwa mafuko awo. ");
INSERT INTO nya_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aaroni ndi Mose ndi aja amene Yehova anawawuza kuti, “Tulutsani Aisraeli mu Igupto mʼmagulu awo.” ");
INSERT INTO nya_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Mose ndi Aaroni ndiwo amene anayankhula ndi Farao mfumu ya Igupto kuti atulutse Aisraeli mu Igupto. ");
INSERT INTO nya_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Tsopano pamene Yehova anayankhula kwa Mose mu Igupto, ");
INSERT INTO nya_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","anati, “Ine ndine Yehova. Umuwuze Farao mfumu ya Igupto zonse zimene Ine ndikuwuze iwe.” ");
INSERT INTO nya_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Koma Mose anati kwa Yehova, “Farao akandimvera bwanji, pakuti ine sinditha kuyankhula bwino?” ");
INSERT INTO nya_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ndipo Yehova anati kwa Mose, “Taona ine ndakuyika kuti ukhale ngati Mulungu kwa Farao, ndipo mʼbale wako Aaroni adzakhala mneneri wako. ");
INSERT INTO nya_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Iwe ukanene zonse zimene ndakulamulirazi, ndipo Aaroni mʼbale wako ndiye akaziyankhule kwa Farao kuti atulutse ana a Israeli mʼdziko la Igupto. ");
INSERT INTO nya_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Koma ndidzawumitsa mtima wa Farao, ndipo ngakhale nditachulukitsa zizindikiro zozizwitsa ndi zodabwitsa mu Igupto, ");
INSERT INTO nya_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","iyeyo sadzakumverani. Choncho ndidzakantha Igupto, ndipo ndi ntchito zachiweruzo ndidzatulutsa magulu anga, anthu anga Aisraeli kuwachotsa mʼdziko la Igupto. ");
INSERT INTO nya_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ndipo Aigupto adzadziwa kuti Ine ndine Yehova, ndikadzatambasula dzanja langa kukantha Igupto ndi kutulutsa Aisraeli mʼdzikomo.” ");
INSERT INTO nya_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mose ndi Aaroni anachita monga momwe Yehova anawalamulira. ");
INSERT INTO nya_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Mose anali ndi zaka 80, ndipo Aaroni anali ndi zaka 83 pamene anakayankhula kwa Farao. ");
INSERT INTO nya_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Yehova anati kwa Mose ndi Aaroni, ");
INSERT INTO nya_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Ngati Farao adzati kwa inu, ‘Chitani chozizwitsa,’ iwe Mose udzati kwa Aaroni, ‘Tenga ndodo yako ndipo uyiponye pamaso pa Farao,’ ndipo idzasanduka njoka.” ");
INSERT INTO nya_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Kotero Mose ndi Aaroni anapita kwa Farao ndi kuchita monga momwe Yehova anawalamulira. Aaroni anaponya ndodo yake pansi patsogolo pa Farao ndi nduna zake ndipo inasanduka njoka. ");
INSERT INTO nya_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Naye Farao anayitanitsa anthu ake anzeru ndi amatsenga, ndipo nawonso amatsenga a Chiigupto anachita zinthu zomwezo mwa matsenga awo. ");
INSERT INTO nya_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Aliyense wa iwo anaponya ndodo yake pansi ndipo inasanduka njoka. Koma ndodo ya Aaroni inameza ndodo zawo. ");
INSERT INTO nya_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Koma mtima wa Farao unawuma ndipo sanawamvere monga momwe Yehova ananenera. ");
INSERT INTO nya_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Kenaka Yehova anati kwa Mose, “Farao ndi wowuma mtima. Akukana kulola anthu anga kuti apite. ");
INSERT INTO nya_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Upite kwa Farao mmawa pamene azidzapita ku madzi. Ukamudikire mʼmbali mwa Nailo kuti ukakumane naye ndipo unyamule ndodo imene inasanduka njoka ija mʼdzanja lako. ");
INSERT INTO nya_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ndipo ukamuwuze Farao kuti, ‘Yehova, Mulungu wa Ahebri wandituma kuti ndikuwuzeni kuti: Lolani anthu anga apite kuti akandipembedze mʼchipululu. Koma mpaka tsopano inu simunandimvere. ");
INSERT INTO nya_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Izi ndi zimene Yehova akunena: Ndi ndodo imene ili mʼdzanja langa ndidzamenya madzi a mu Nailo, ndipo madzi adzasanduka magazi. Ndikadzachita ichi udzadziwa kuti Ine ndine Yehova: ");
INSERT INTO nya_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Nsomba za mu Nailo zidzafa, mtsinje udzanunkha ndipo Aigupto sadzatha kumwa madzi ake.’ ” ");
INSERT INTO nya_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Yehova anati kwa Mose, “Uza Aaroni kuti, ‘Tenga ndodo yako uyilozetse ku madzi a mu Igupto pa mitsinje, pa ngalande, pa zithaphwi ndi pa madambo, ndipo onse adzasanduka magazi.’ Mʼdziko lonse la Igupto mudzakhala magazi, ngakhale mʼzotungira madzi zopangidwa ndi mitengo ndi miyala.” ");
INSERT INTO nya_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mose ndi Aaroni anachita monga momwe Yehova analamulira. Anakweza ndodo yake pamaso pa Farao ndi akuluakulu ake ndipo anamenya madzi a mu Nailo, ndipo madzi onse anasanduka magazi. ");
INSERT INTO nya_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Nsomba za mu Nailo zinafa ndipo mtsinje unanunkha kwambiri kotero kuti Aigupto sanathe kumwa madzi ake. Magazi anali ponseponse mu Igupto. ");
INSERT INTO nya_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Koma amatsenga a Chiigupto anachita zinthu zomwezo mwa matsenga awo. Choncho Farao anawumabe mtima, ndipo sanamvere zonena za Mose ndi Aaroni monga momwe Yehova ananeneratu. ");
INSERT INTO nya_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Mʼmalo mwake iye anatembenuka ndi kupita ku nyumba yake yaufumu ndipo zimenezi sanazilabadire. ");
INSERT INTO nya_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Anthu onse a ku Igupto anayamba kukumba mʼmbali mwa mtsinje wa Nailo kuti apeze madzi akumwa, chifukwa sanathe kumwa madzi a mu mtsinjemo. ");
INSERT INTO nya_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Panapita masiku asanu ndi awiri Yehova atamenya madzi a mu mtsinje wa Nailo. ");
INSERT INTO nya_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Kenaka Yehova anati kwa Mose, “Ukamuwuze Farao kuti, Lolani anthu anga kuti apite, akandipembedze. ");
INSERT INTO nya_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ndipo ngati simulola kuti apite Ine ndidzalanga dziko lonse la Igupto polidzaza ndi achule. ");
INSERT INTO nya_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mtsinje wa Nailo udzadzaza ndi achule. Achulewo adzatuluka ndi kukalowa mʼnyumba yaufumu, ku chipinda chogona ndi pa bedi lako, mʼnyumba za nduna zako ndi pa anthu ako ndi mophikira buledi ndiponso mopangira bulediyo. ");
INSERT INTO nya_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Achulewo adzakulumphira iwe ndi anthu ako ndiponso nduna zako.” ");
INSERT INTO nya_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ndipo Yehova anati kwa Mose, “Uza Aaroni kuti, ‘Loza ndodo yako ku mitsinje, ku ngalande ndi ku zithaphwi ndipo pakhale achule pa dziko lonse la Igupto.’ ” ");
INSERT INTO nya_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Kotero Aaroni analoza dzanja lake pa madzi a ku Igupto, ndipo achule anatuluka nadzaza dziko lonse la Igupto. ");
INSERT INTO nya_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Koma amatsenga anachita zinthu zomwezo mʼmatsenga awo. Iwonso anatulutsa achule mʼdziko lonse la Igupto. ");
INSERT INTO nya_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Kenaka, Farao anayitanitsa Mose ndi Aaroni ndipo anati, “Pemphera kwa Yehova kuti achulewa achoke kwa ine ndi anthu anga, ndipo ine ndidzalola kuti anthu anu apite kukapereka nsembe kwa Yehova.” ");
INSERT INTO nya_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mose anati kwa Farao, “Inu mungonditchulira nthawi imene mukufuna kuti ndikupempherereni, nduna zanu pamodzi ndi anthu anu kuti achule achoke mʼnyumba zanu ndi kuti atsale okhawo ali mu mtsinje wa Nailo.” ");
INSERT INTO nya_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Farao anati, “Mawa.” Mose anamuyankha kuti, “Chabwino zidzakhala monga mwaneneramu, kuti mudzadziwe kuti palibe wina wofanana ndi Yehova Mulungu wathu. ");
INSERT INTO nya_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Achule adzachoka mʼnyumba yanu, mʼnyumba za nduna zanu pamodzi ndi za anthu anu. Koma adzatsala mu mtsinje wa Nailo basi.” ");
INSERT INTO nya_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Mose ndi Aaroni anachoka, ndipo Mose anapemphera kwa Yehova kuti achotse achule amene anatumiza kwa Farao. ");
INSERT INTO nya_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ndipo Yehova anachita zomwe Mose anapempha. Achule amene anali mʼnyumba, mʼmabwalo ndi mʼminda anafa ");
INSERT INTO nya_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Aigupto anawunjika achulewo milumilu ndipo dziko linanunkha. ");
INSERT INTO nya_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Koma Farao ataona kuti zinthu zinayambanso kukhala bwino, anawumitsanso mtima wake ndipo sanamverenso mawu a Mose ndi Aaroni, monga momwe Yehova ananenera. ");
INSERT INTO nya_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Kenaka Yehova anati kwa Mose, “Uza Aaroni kuti akweze ndodo yake ndi kumenya fumbi la pa nthaka, ndipo fumbilo lidzasanduka nsabwe pa dziko lonse la Igupto.” ");
INSERT INTO nya_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Iwo anachita momwemo, ndipo pamene Aaroni anakweza ndodo yake ndi kumenya fumbi, nsabwe zinafika pa munthu aliyense ndi pa ziweto. Fumbi lonse la mʼdziko la Igupto linasanduka nsabwe. ");
INSERT INTO nya_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Koma amatsenga atayesa kupanga nsabwe mwa matsenga awo, analephera. Ndipo nsabwezo zinali pa munthu aliyense ndi pa ziweto zawo. ");
INSERT INTO nya_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Amatsenga anati kwa Farao, “Izi wachita ndi Mulungu.” Koma mtima wa Farao unali wowumabe ndipo sanamvere zonena za Mose ndi Aaroni monga momwe Yehova ananenera. ");
INSERT INTO nya_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Kenaka Yehova anati kwa Mose, “Mmawa, upite ukakumane ndi Farao maso ndi maso pamene azidzapita ku madzi ndipo ukanene kuti, ‘Yehova akuti, Lola anthu anga kuti apite akandipembedze. ");
INSERT INTO nya_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Koma ngati suwalola anthu anga kuti apite, Ine ndidzatumiza pa iwe ntchentche zoluma ndi pa nduna zako ndi anthu ako ndi mʼnyumba zanu. Mʼnyumba za Aigupto mudzadzaza ntchentche zoluma. Ngakhale pa nthaka pamene akhalapo padzadzaza ndi ntchentche zoluma.’ ” ");
INSERT INTO nya_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“Koma pa tsikulo ndidzapatula dera la Goseni, kumene kumakhala anthu anga, motero kuti sikudzakhala ntchentche zoluma. Choncho iwe udzadziwa kuti Ine Yehova ndi amene ndikulamulira dziko lino. ");
INSERT INTO nya_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ndidzasiyanitsa pakati pa anthu anga ndi anthu ako. Chizindikiro chozizwitsa ichi chidzachitika mawa.” ");
INSERT INTO nya_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ndipo Yehova anachita zimenezi: Ntchentche zoluma zochuluka zinalowa mʼnyumba yaufumu ya Farao ndi nyumba za nduna zake. Choncho ntchentche zolumazi zinawononga dziko lonse la Igupto. ");
INSERT INTO nya_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Kenaka Farao anayitanitsa Mose ndi Aaroni nati, “Pitani kaperekeni nsembe kwa Mulungu wanu mʼdziko lomwe lino.” ");
INSERT INTO nya_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Koma Mose anati, “Sitingathe kutero pakuti nsembe zathu kwa Yehova Mulungu ndi zowayipira Aigupto. Ngati tipereke nsembe zowayipira Aigupto mʼmaso mwawo, adzatiponya miyala kuti tife. ");
INSERT INTO nya_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Ife tiyenera kuyenda ulendo wa masiku atatu kupita ku chipululu kukapereka nsembe kwa Yehova Mulungu wathu monga anatilamulira.” ");
INSERT INTO nya_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Farao anati, “Ine ndikulolani kuti mupite ku chipululu kukapereka nsembe kwa Yehova Mulungu wanu, koma musapite kutali kwambiri. Tsopano ndipempherereni.” ");
INSERT INTO nya_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mose anayankha kuti, “Ine ndikangochoka pano, ndikapemphera kwa Yehova ndipo mawa lomweli ntchentche zoluma zidzachoka kwa Farao, nduna zake pamodzi ndi anthu ake. Koma Farao, onetsetsani kuti musachitenso zachinyengo ndi kuwakaniza anthu kuti asakapereke nsembe kwa Yehova.” ");
INSERT INTO nya_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Choncho Mose anasiyana ndi Farao nakapemphera kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ndipo Yehova anachita zomwe Mose anapempha: Ntchentche zoluma zinachoka kwa Farao ndi nduna zake ndiponso kwa anthu ake. Palibe ngakhale imodzi yomwe inatsala. ");
INSERT INTO nya_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Koma nthawi imeneyinso Farao anawumitsa mtima wake ndipo sanalole kuti anthu atuluke. ");
INSERT INTO nya_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Kenaka Yehova anati kwa Mose, “Pita kwa Farao ndipo ukamuwuze kuti Yehova, Mulungu wa Ahebri akuti alole anthu anga apite kuti akandipembedze. ");
INSERT INTO nya_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Koma ngati ukana kuti apite ndi kupitiriza kuwaletsa, ");
INSERT INTO nya_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","dzanja la Yehova lidzakantha ziweto zako zimene zili ku munda, pamodzi ndi akavalo, abulu, ngamira, ngʼombe, nkhosa ndi mbuzi ndi mliri woopsa kwambiri. ");
INSERT INTO nya_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Koma Yehova adzasiyanitsa pakati pa ziweto za Israeli ndi ziweto za Igupto, kotero kuti palibe chiweto nʼchimodzi chomwe cha Aisraeli chimene chidzafe.” ");
INSERT INTO nya_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Yehova anayika nthawi ndipo anati, “Yehova adzachita zimenezi mmawa mʼdziko muno.” ");
INSERT INTO nya_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ndipo mmawa mwake Yehova anachitadi zimenezi. Ziweto zonse za Aigupto zinafa, koma palibe chiweto ndi chimodzi chomwe cha Aisraeli chomwe chinafa. ");
INSERT INTO nya_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Farao anatuma anthu kuti akafufuze ndipo anapeza kuti palibe chiweto chilichonse cha Aisraeli chomwe chinafa. Komabe mtima wake sunagonje ndipo iye sanalole kuti anthu apite. ");
INSERT INTO nya_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Kenaka Yehova anati kwa Mose ndi Aaroni, “Tapani phulusa la pa moto lodzaza dzanja ndipo Mose aliwaze mmwamba pamaso pa Farao. ");
INSERT INTO nya_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Phulusalo lidzasanduka fumbi pa dziko lonse la Igupto. Tsono fumbilo lidzasanduka zithupsa zomaphulika nʼkukhala zilonda pa munthu aliyense ndi pa nyama zomwe mʼdziko lonse la Igupto.” ");
INSERT INTO nya_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Kotero anatenga phulusa la pa moto ndi kuyima pamaso pa Farao. Mose analiwaza mmwamba, ndipo panabuka zotupa zophulika zokha pa munthu aliyense ndi pa ziweto. ");
INSERT INTO nya_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Amatsenga sanathe kumuyandikira Mose chifukwa nawonso anali ndi zithupsa monga mmene analili Aigupto ena onse. ");
INSERT INTO nya_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Koma Yehova anawumitsa mtima wa Farao ndipo iye sanamvere Mose ndi Aaroni monga momwe Yehova anamuwuzira Mose. ");
INSERT INTO nya_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Kenaka Yehova anati kwa Mose, “Mawa mmawa upite ukakumane ndi Farao maso ndi maso ndipo ukamuwuze kuti Yehova Mulungu wa Ahebri akuti ulole anthu anga apite kuti akandipembedze. ");
INSERT INTO nya_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ngati suwalola, tsopano ndidzagwetsa miliri yanga yonse pa iwe ndi nduna zako ndiponso pa anthu ako, kuti udziwe kuti palibe wina wofanana nane pa dziko lonse lapansi. ");
INSERT INTO nya_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Pakuti ndikanakhala nditatukula kale dzanja langa ndikupheratu iwe pamodzi ndi anthu ako onse pa dziko lapansi. ");
INSERT INTO nya_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Koma ndakuyika kukhala mfumu ndi cholinga choti ndionetse mphamvu zanga kwa iwe ndiponso kuti dzina langa litchuke pa dziko lonse lapansi. ");
INSERT INTO nya_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Komabe iwe ukudzitukumula pa anthu anga osawalola kuti atuluke. ");
INSERT INTO nya_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Nʼchifukwa chake mawa, nthawi ngati ino, ndidzagwetsa matalala amphamvu amene sanagwepo pa Igupto, kuyambira pachiyambi mpaka lero. ");
INSERT INTO nya_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Tsopano lamula kuti ziweto zanu zonse ndi zinthu zonse zomwe zili ku minda kuti zilowetsedwe mʼkhola, chifukwa matalala adzagwera munthu aliyense ndi chiweto chilichonse chimene sichidzalowetsedwa mʼkhola ndipo zimene zidzakhala zili ku munda zidzafa.” ");
INSERT INTO nya_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Nduna za Farao zinachita mantha ndi mawu a Yehova, ndipo zinalowetsa antchito awo ndi ziweto zawo mʼnyumba. ");
INSERT INTO nya_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Koma iwo amene ananyozera mawu a Yehova anasiya akapolo ndi ziweto zawo panja. ");
INSERT INTO nya_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Kenaka Yehova anati kwa Mose, “Kweza dzanja lako kumwamba kuti matalala agwe pa dziko lonse la Igupto, pa munthu aliyense, pa ziweto ndi pa zonse zomera mʼminda ya Igupto.” ");
INSERT INTO nya_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mose ataloza ndodo yake kumwamba, Yehova anatumiza mabingu ndi matalala ndi ziphaliwali zongʼanima pa nthaka. Kotero Yehova anagwetsa matalala pa dziko la Igupto. ");
INSERT INTO nya_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Matalala anagwa ndipo ziphaliwali zinangʼanima. Inali mphepo ya mkuntho yoopsa kwambiri imene sinakhaleponso mʼdziko lonse la Igupto chiyambire pamene Aigupto anakhala mtundu woyima pa okha. ");
INSERT INTO nya_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Matalala anawononga dziko lonse la Igupto, munthu aliyense pamodzi ndi ziweto. Matalala aja anawononga zomera zonse za mʼmunda ndi kukhadzula mtengo uliwonse. ");
INSERT INTO nya_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ku malo kokhako kumene matalala sanafikeko ndi dera la Goseni kumene kunali Aisraeli. ");
INSERT INTO nya_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Kenaka Farao anayitanitsa Mose ndi Aaroni nati kwa iwo, “Tsopano ndachimwa, Yehova ndi wolungama, ine ndi anthu anga ndife olakwa. ");
INSERT INTO nya_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Upemphere kwa Mulungu chifukwa mabingu ndi matalala atikwana. Ine ndidzakulolani kuti mupite. Simuyenera kukhalabe kuno.” ");
INSERT INTO nya_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mose anayankha, “Ndikangotuluka mu mzinda muno, ine ndidzakweza manja anga kwa Yehova ndi kupemphera. Mabingu ndi matalalawa adzaleka ndipo inu mudzadziwa kuti Yehova ndiye akulamulira dziko lapansi. ");
INSERT INTO nya_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Koma ine ndikudziwa kuti inu ndi nduna zanu simukuopabe Yehova Mulungu.” ");
INSERT INTO nya_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Thonje ndi barele zinawonongeka, popeza barele anali atakhwima ndi thonje linali ndi maluwa. ");
INSERT INTO nya_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Koma tirigu ndi mchewere sizinawonongeke chifukwa zimakhwima mochedwa. ");
INSERT INTO nya_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mose anasiyana ndi Farao natuluka mu mzindawo. Iye anakweza manja ake kwa Yehova. Mabingu ndi matalala zinaleka, ndipo mvula inalekeratu kugwa mʼdzikolo. ");
INSERT INTO nya_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Farao ataona kuti mvula, matalala ndi mabingu zaleka, anachimwanso. Iye ndi nduna zake anawumitsanso mitima yawo. ");
INSERT INTO nya_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Choncho Farao sanalole kuti Aisraeli apite monga momwe Yehova anamuwuzira Mose. ");
INSERT INTO nya_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Kenaka Yehova anati kwa Mose, “Pita kwa Farao, pakuti Ine ndawumitsa mtima wake ndi mitima ya nduna zake kuti ndichite zizindikiro zozizwitsa pakati pawo ");
INSERT INTO nya_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","kuti inu mudzawuze ana ndi zidzukulu zanu za mmene ndinawakhawulitsira Aigupto ndi zizindikiro zozizwitsa zimene ndinachita pakati pawo ndiponso kuti inu mudziwe kuti ine ndine Yehova.” ");
INSERT INTO nya_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ndipo Mose ndi Aaroni anapita kwa Farao ndi kukanena kuti, “Yehova Mulungu wa Ahebri, akuti: ‘Kodi udzakanabe kudzichepetsa pamaso panga mpaka liti? Alole anthu anga apite kuti akandipembedze. ");
INSERT INTO nya_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ngati ukana kuwalola, ndigwetsa dzombe mʼdziko lako lino mawa. ");
INSERT INTO nya_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Dzombeli lidzakuta nthaka yonse moti sidzaoneka konse. Lidzadya kalikonse kakangʼono kamene sikanawonongedwe ndi matalala aja, kuphatikizapo mitengo yonse imene ikumera mʼminda yanu. ");
INSERT INTO nya_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Dzombeli lidzadzaza nyumba zako ndi za nduna zako ndiponso za Aigupto onse, chinthu chimene ngakhale makolo anu kapena makolo awo sanachionepo kuyambira tsiku limene anakhala mʼdzikoli mpaka lero.’ ” Ndipo Mose ndi Aaroni anatembenuka ndi kumusiya Farao. ");
INSERT INTO nya_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Nduna za Farao zinamufunsa kuti, “Kodi munthu uyu adzativutitsa mpaka liti? Aloleni anthuwa apite, kuti akapembedze Yehova Mulungu wawo. Kodi simukuona kuti dziko la Igupto lawonongeka?” ");
INSERT INTO nya_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Choncho Mose ndi Aaroni anayitanidwanso kwa Farao ndipo anati, “Pitani kapembedzeni Yehova Mulungu wanu. Koma ndani amene adzapite?” ");
INSERT INTO nya_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mose anayankha kuti, “Ife tidzapita tonse pamodzi; angʼonoangʼono ndi akuluakulu, ana athu aamuna ndi aakazi, ndiponso ziweto zathu ndi ngʼombe chifukwa tikakhala ndi chikondwerero cha kwa Yehova.” ");
INSERT INTO nya_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Farao anati, “Yehova akhale ndi inu ngati ndingakuloleni kupita pamodzi ndi akazi ndi ana anu! Zikuoneka kuti mwakonzeka kuchita choyipa. ");
INSERT INTO nya_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ndakana! Amuna okha ndiwo apite ndi kukapembedza Yehova pakuti izi ndi zimene mwakhala mukupempha.” Kenaka Mose ndi Aaroni anathamangitsidwa pamaso pa Farao. ");
INSERT INTO nya_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ndipo Yehova anati kwa Mose, “Tambalitsa dzanja lako pa dziko la Igupto kuti dzombe lidze pa dziko la Igupto ndi kuwononga chilichonse chimene chikumera mʼminda ndi chilichonse chimene chinatsala pa nthawi ya matalala.” ");
INSERT INTO nya_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Kotero Mose anakweza ndodo yake pa dziko la Igupto, ndipo Yehova anawutsa mphepo ya kummawa imene inawomba pa dziko usana ndi usiku wonse. Mmene kumacha nʼkuti mphepoyo itabweretsa dzombe. ");
INSERT INTO nya_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Dzombelo linafika pa dziko lonse la Igupto ndi kukhala dera lililonse la dzikolo. Dzombe lambiri ngati limenelo silinakhaleponso nʼkale lonse ndipo silidzakhalapo ngakhale mʼtsogolo. ");
INSERT INTO nya_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Dzombelo linaphimba nthaka yonse mpaka kuoneka kuti bii. Linadya zonse zimene zinatsala nthawi ya matalala, zomera za mʼmunda ndi zipatso. Panalibe chobiriwira chilichonse chimene chinatsala pa mtengo kapena pa chomera chilichonse mʼdziko lonse la Igupto. ");
INSERT INTO nya_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Mwamsangamsanga, Farao anayitanitsa Mose ndi Aaroni ndipo anati, “Ine ndachimwira Yehova Mulungu wanu ndiponso inu. ");
INSERT INTO nya_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Tsopano ndikhululukirenso tchimo langa kano konkha ndipo pempherani kwa Yehova Mulungu wanu kuti andichotsere mliri wosakazawu.” ");
INSERT INTO nya_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Mose anachoka kwa Farao nakapemphera kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ndipo Yehova anasintha mphepo ija kuti ikhale ya mphamvu yochokera ku madzulo, ndipo inanyamula dzombe lija nʼkulikankhira mʼNyanja Yofiira. Panalibe dzombe ndi limodzi lomwe limene linatsala mu Igupto. ");
INSERT INTO nya_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Koma Yehova anawumitsa mtima wa Farao, ndipo sanalole kuti Aisraeli apite. ");
INSERT INTO nya_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Kenaka Yehova anati kwa Mose, “Tambasulira dzanja lako kumwamba kuti kukhale mdima umene udzaphimba dziko lonse la Igupto, mdima wandiweyani.” ");
INSERT INTO nya_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Choncho Mose anakweza dzanja lake kumwamba ndipo mdima wandiweyani unaphimba dziko lonse la Igupto kwa masiku atatu. ");
INSERT INTO nya_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Palibe amene anatha kuona mnzake kapena kuchoka pa khomo pake kwa masiku atatu. Koma kumalo kumene kumakhala Aisraeli kunali kowala. ");
INSERT INTO nya_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Kenaka Farao anayitanitsa Mose ndi Aaroni nati, “Pitani kapembedzeni Yehova. Ngakhale akazi ndi ana anu apite pamodzi ndi inu. Koma musatenge ziweto zanu ndi ngʼombe zanu.” ");
INSERT INTO nya_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Koma Mose anati, “Ndiye inu mutipatse nsembe zopsereza zoti tikapereke kwa Yehova Mulungu wathu. ");
INSERT INTO nya_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Koma ayi, ife tipita ndi ziweto zathu. Palibe chiweto chilichonse chimene chitatsale kuno, popeza tikasankha komweko ziweto zokapembedzera Yehova. Sitingadziwe zimene tikagwiritse ntchito popembedza Yehova mpaka titakafika kumeneko.” ");
INSERT INTO nya_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Koma Yehova anawumitsa mtima wa Farao ndipo sanafune kuwalola kuti apite. ");
INSERT INTO nya_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Farao anati kwa Mose, “Choka pamaso panga! Uwonetsetse kuti usadzaonekerenso pamaso panga! Tsiku limene ndidzakuonenso udzafa.” ");
INSERT INTO nya_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mose anayankha kuti, “Monga momwe mwaneneramu, Ine sindidzaonekeranso pamaso panu.” ");
INSERT INTO nya_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Tsopano Yehova anati kwa Mose, “Ine ndidzalanga Farao pamodzi ndi Aigupto onse ndi mliri umodzi wotsiriza. Zikadzachitika izi iye adzakulolani kuti mutuluke mʼdziko lino. Ndithu pamene azidzakutulutsani adzachita ngati akukuyingitsani. ");
INSERT INTO nya_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Awuze anthu kuti mwamuna aliyense ndi mkazi aliyense apemphe kwa mnansi wake ziwiya zasiliva ndi golide.” ");
INSERT INTO nya_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Tsono Yehova anachititsa Aigupto kuti akomere mtima Aisraeli. Komanso Mose anali wotchuka kwambiri mʼdziko la Igupto, pamaso pa nduna za Farao ndi anthu onse. ");
INSERT INTO nya_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Tsono Mose anawuza Farao kuti, “Pakati pa usiku, Yehova adzayenda pakati pa anthu a ku Igupto. ");
INSERT INTO nya_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ndipo mwana aliyense wamwamuna wachisamba adzafa, kuyambira mwana wamwamuna wa Farao amene amakhala pa mpando waufumu, mpaka mwana wamwamuna wachisamba wa mdzakazi wake amene ali naye pa mtondo, komanso ana oyamba a ziweto. ");
INSERT INTO nya_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Kudzakhala kulira kwakukulu mʼdziko lonse la Igupto, kumene sikunachitikepo ndipo sikudzachitikanso. ");
INSERT INTO nya_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Koma pakati pa Aisraeli, ngakhale galu sadzawuwa munthu aliyense kapena chiweto!” Kotero mudzadziwa kuti Yehova ndiye wasiyanitsa pakati pa Igupto ndi Israeli. ");
INSERT INTO nya_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Nduna zanu zonse zidzabwera kwa ine, kugwada pamaso panga ndi kunena kuti, “Pita iwe ndi anthu ako onse amene akukutsatirawa! Zimenezi zikadzachitika ine ndidzachoka.” Ndipo Mose anachoka kwa Farao atakwiya kwambiri. ");
INSERT INTO nya_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Yehova ananena kwa Mose kuti, “Farao adzakana kukumvera, kuti zodabwitsa zanga zichuluke mʼdziko la Igupto.” ");
INSERT INTO nya_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mose ndi Aaroni anachita zodabwitsa zonsezi pamaso pa Farao koma Yehova anawumitsa mtima wa Farao, ndipo sanalole kuti Aisraeli atuluke mʼdziko lake. ");
INSERT INTO nya_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Yehova anayankhula kwa Mose ndi Aaroni mʼdziko la Igupto kuti, ");
INSERT INTO nya_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Mwezi uno uzikhala mwezi wanu woyamba wa chaka. ");
INSERT INTO nya_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Muliwuze khamu lonse la Israeli kuti pa tsiku la khumi la mwezi uno, munthu aliyense asankhire banja lake mwana wankhosa mmodzi. Banja lililonse litenge mwana wankhosa mmodzi. ");
INSERT INTO nya_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ngati banja lili lochepa moti silingathe kudya nyama yonse ya nkhosa, ligawane ndi banja lomwe layandikana nalo nyumba. Mabanja adziwiretu chiwerengero cha anthu amene alipo pokonzekera zimenezi. Muwerengere kuchuluka kwa nyama imene anthu adzadye potengera mmene munthu mmodzi angadyere. ");
INSERT INTO nya_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ziweto zimene musankhe ziyenera kukhala zazimuna za chaka chimodzi, zopanda chilema, ndipo zikhale nkhosa kapena mbuzi. ");
INSERT INTO nya_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Muzisunge mpaka tsiku la khumi ndi chinayi la mwezi, pamene gulu lonse la Aisraeli lidzaphe nyamazo madzulo. ");
INSERT INTO nya_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ndipo adzatengeko magazi anyamazo ndi kuwaza pa mphuthu ziwiri za chitseko ndiponso pamwamba pa chitseko cha nyumba mmene adzadyeremo ana ankhosawo. ");
INSERT INTO nya_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Adzawotche nyamayo ndi kudya usiku womwewo, ndipo adzayidye ndi buledi wophikidwa popanda yisiti pamodzi ndi masamba wowawa. ");
INSERT INTO nya_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Musadzadye yayiwisi kapena yophika, koma mudzawotche yonse, mutu, miyendo ndi zamʼmimba. ");
INSERT INTO nya_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Musadzasiye nyama ina mpaka mmawa, ngati ina idzatsala mpaka mmawa, mudzayitenthe. ");
INSERT INTO nya_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Muzidzadya nyamayo mutavala chotere, pokonzekera ulendo: mudzazimangirire lamba mʼchiwuno, nsapato zanu kuphazi ndi ndodo yanu kumanja. Mudzadye mofulumira. Imeneyi ndi Paska ya Yehova. ");
INSERT INTO nya_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Usiku umenewo Ine ndidzadutsa mʼdziko la Igupto ndipo ndidzapha chilichonse choyamba kubadwa kuyambira mwana wa munthu aliyense mpaka ana aziweto. Ndidzalanganso milungu yonse ya Igupto. Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Magazi amene mudzawaze pa mphuthu za zitseko ndi pamwamba pa zitseko aja adzakhala ngati chizindikiro. Ine ndikadzaona magaziwo ndidzakudutsani, ndipo ndikadzamakantha anthu a Igupto, mliri wosakazawu sudzakukhudzani. ");
INSERT INTO nya_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Ili ndi tsiku la chikumbutso. Tsiku limeneli muzidzachita chikondwerero, kupembedza Yehova. Mibado yonse imene ikubwera izidzakumbukira tsiku limeneli ngati lamulo lamuyaya ndi kuti pa tsikuli azidzachita chikondwerero cholemekeza Yehova. ");
INSERT INTO nya_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Kwa masiku asanu ndi awiri muzidya buledi wopanda yisiti. Tsiku loyamba muzichotsa yisiti mʼnyumba zanu, ngati aliyense adzadya kanthu kalikonse kali ndi yisiti kuyambira tsiku loyamba mpaka tsiku lachisanu ndi chiwiri, munthu ameneyo adzayenera kuchotsedwa mʼgulu la Israeli. ");
INSERT INTO nya_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Pa tsiku loyamba muzichita msonkhano wopatulika, ndipo winanso uzikhala pa tsiku lachisanu ndi chiwiri. Musamagwire ntchito masiku onsewa, koma ntchito yokonza chakudya yokha kuti aliyense adye. Izi ndi zimene muzichita. ");
INSERT INTO nya_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Muzichita chikondwerero cha buledi wopanda yisiti, chifukwa ndi pa tsiku limeneli ndinatulutsa magulu anu mʼdziko la Igupto. Muzikondwerera tsiku limeneli pa mibado yonse ngati lamulo lamuyaya. ");
INSERT INTO nya_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Mwezi woyamba muzidzadya buledi wopanda yisiti kuyambira madzulo tsiku la 14 la mweziwo mpaka tsiku la 21 mwezi womwewo. ");
INSERT INTO nya_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Yisiti asamapezeka mʼnyumba zanu kwa masiku asanu ndi awiri. Ndipo aliyense amene adya chakudya chimene muli yisiti, munthu ameneyo ayenera kuchotsedwa mʼgulu la Aisraeli, kaya iyeyo ndi mlendo kapena mbadwa. ");
INSERT INTO nya_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Musadye chilichonse chokhala ndi yisiti. Kulikonse kumene mukukhala, muyenera kudya buledi wopanda yisiti.” ");
INSERT INTO nya_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ndipo Mose anasonkhanitsa akuluakulu onse a Israeli nati, “Pitani msanga kukasankha nkhosa zokwanira pa mabanja anu, ndipo muziphe ngati Paska. ");
INSERT INTO nya_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Mutengenso nthambi ya chitsamba cha hisope, muchiviyike mʼmagazi amene mwawayika mʼbeseni ndipo muwaze ena mwa magaziwo pamwamba ndi mʼmbali mwa mphuthu za chitseko. Palibe aliyense wa inu amene adzatuluke mʼnyumba yake mpaka mmawa. ");
INSERT INTO nya_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Pamene Yehova adzadutsa mʼdziko kudzakantha Aigupto, nʼkuona magazi pamwamba ndi mʼmbali mwa mphuthu za chitseko, Iye adzadutsa khomo limenelo ndipo sadzalola woonongayo kuti alowe mʼnyumba zanu kuti akukantheni. ");
INSERT INTO nya_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Muzimvera malamulo amenewa kwa muyaya, inu ndi zidzukulu zanu. ");
INSERT INTO nya_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Mukakalowa mʼdziko limene Yehova adzakupatseni monga analonjeza, mukasunge mwambo umenewu. ");
INSERT INTO nya_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ndipo ana anu akakakufunsani kuti, ‘Mwambo umenewu ukutanthauza chiyani?’ ");
INSERT INTO nya_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Inu mukawawuze kuti, ‘Ndi nsembe ya Paska ya Yehova, popeza pamene ankakantha nyumba za Aigupto anasiya nyumba zathu.’ ” Kenaka anthu anawerama napembedza. ");
INSERT INTO nya_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Aisraeli anachita monga momwe Yehova analamulira Mose ndi Aaroni. ");
INSERT INTO nya_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Pakati pa usiku Yehova anakantha ana onse oyamba kubadwa mʼdziko la Igupto, kuyambira woyamba kubadwa wa Farao, amene amakhala pa mpando waufumu wa Faraoyo, mpaka mwana woyamba kubadwa wa munthu amene anali mʼdzenje, pamodzinso ndi ana oyamba kubadwa a ziweto zawo. ");
INSERT INTO nya_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Farao ndi nduna zake zonse ndiponso Aigupto onse anadzuka pakati pa usiku, ndipo kunali kulira kwakukulu mʼdziko lonse la Igupto, pakuti panalibe nyumba imene munalibe munthu wakufa. ");
INSERT INTO nya_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Pakati pa usiku Farao anayitanitsa Mose ndi Aaroni ndipo anati, “Nyamukani! Asiyeni anthu anga, inu ndi Aisraeli! Pitani, kapembedzeni Yehova monga munapempha. ");
INSERT INTO nya_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Tengani ziweto ndi ngʼombe zanu ndipo pitani kapembedzeni Mulungu wanu monga munanenera kuti ine ndidalitsike.” ");
INSERT INTO nya_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Aigupto anawawumiriza anthuwo kuti atuluke mofulumira ndi kusiya dziko lawo. Iwo anati, “Ngati sitiwalola kutero, tonse tidzafa.” ");
INSERT INTO nya_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Motero anthuwo ananyamula ufa wawo wopangira buledi asanathiremo yisiti ndipo anasenza pa mapewa awo pamodzi ndi zokandiramo buledi atazikulunga mu nsalu. ");
INSERT INTO nya_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Aisraeli anachita monga anawawuzira Mose kuti apemphe kwa Aigupto zozikongoletsera zasiliva ndi zagolide ndi zovala. ");
INSERT INTO nya_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Yehova anafewetsa mtima Aigupto kuti akomere mtima Aisraeliwo ndipo anawapatsa zimene anawapempha. Motero Aisraeli anawalanda zinthu Aigupto. ");
INSERT INTO nya_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Aisraeli anayenda ulendo kuchokera ku Ramesesi mpaka kukafika ku Sukoti. Anthu aamuna oyenda pansi analipo 600,000 osawerengera akazi ndi ana. ");
INSERT INTO nya_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Anthu enanso ambiri anapita nawo, kuphatikizanso gulu lalikulu la ziweto, mbuzi, nkhosa pamodzi ndi ngʼombe. ");
INSERT INTO nya_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Iwo anapanga buledi wopanda yisiti ndi ufa umene anachoka nawo ku Igupto. Ufawo unalibe yisiti chifukwa anachita kuthamangitsidwa ku Igupto ndipo analibe nthawi yokonzera chakudya chawo. ");
INSERT INTO nya_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Ndipo Aisraeli anakhala ku Igupto kwa zaka 430. ");
INSERT INTO nya_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Pa tsiku lomwelo limene anakwanitsa zaka 430, magulu onse a Yehova anatuluka mʼdziko la Igupto. ");
INSERT INTO nya_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Usiku wonse Yehova anachezera kutulutsa ana a Israeli mʼdziko la Igupto. Nʼchifukwa chake pa tsiku limeneli Aisraeli onse azichezera usiku wonse kulemekeza Mulungu kamba ka mibado yonse ya mʼtsogolo. ");
INSERT INTO nya_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yehova anati kwa Mose ndi Aaroni, “Malamulo a Paska ndi awa: “Mlendo asadye Paska. ");
INSERT INTO nya_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Kapolo aliyense amene munagula angadye ngati atayamba wachita mdulidwe. ");
INSERT INTO nya_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Koma amene mukukhala naye kwa kanthawi kapena waganyu asadye Paska. ");
INSERT INTO nya_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Muzidyera Paska mʼnyumba imodzi. Musatulutse nyama iliyonse kunja kwa nyumba. Musaswe mafupa aliwonse. ");
INSERT INTO nya_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Gulu lonse la Israeli lizichita mwambo wachikondwererochi. ");
INSERT INTO nya_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Ngati mlendo wokhala pakati panu angafune kuchita nawo mwambo wa chikondwerero cha Paska, cha Yehovachi, amuna onse a mʼnyumba mwake ayenera kuchita mdulidwe. Akatero muzimutenga ngati mbadwa pakati panu. Koma aliyense wosachita mdulidwe asadye Paska. ");
INSERT INTO nya_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Lamulo limeneli likhudza mbadwa ngakhalenso alendo wochita mdulidwe wokhala pakati panu. ");
INSERT INTO nya_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","“Aisraeli onse anachita monga momwe Yehova analamulira Mose ndi Aaroni. ");
INSERT INTO nya_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ndipo tsiku lomwelo Yehova anatulutsa gulu lonse la ana a Israeli mʼdziko la Igupto.” ");
INSERT INTO nya_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yehova anati kwa Mose, ");
INSERT INTO nya_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Ana onse aamuna oyamba kubadwa uwapatule, ndi anga. Aliyense woyamba kubadwa pakati pa Aisraeli ndi wanga, kaya ndi wa munthu kapena wa chiweto.” ");
INSERT INTO nya_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ndipo Mose anati kwa anthu, “Muzikumbukira tsiku lino, tsiku limene munatuluka mʼdziko la Igupto, dziko la ukapolo chifukwa Yehova anakutulutsani ndi dzanja lake lamphamvu. Musadye kalikonse kamene kali ndi yisiti. ");
INSERT INTO nya_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Pa tsiku la lero mwezi uno wa Abibu, mukutuluka mʼdziko la Igupto. ");
INSERT INTO nya_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Yehova akadzakulowetsani mʼdziko la Akanaani, Ahiti, Aamori, Ahivi ndi Ayebusi, dziko loyenda mkaka ndi uchi, muzikachita mwambo uwu mwezi uno. ");
INSERT INTO nya_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Muzidzadya buledi wopanda yisiti kwa masiku asanu ndi awiri ndipo tsiku lachisanu ndi chiwirilo muzichita chikondwerero cha Yehova. ");
INSERT INTO nya_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Mudye buledi wopanda yisiti masiku asanu ndi awiri. Pasapezeke chinthu chilichonse chokhala ndi yisiti pakati panu, kapena paliponse mʼdziko lanu. ");
INSERT INTO nya_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Tsiku limenelo muzidzawuza ana anu kuti, ‘Ine ndimachita zimenezi chifukwa cha zimene Yehova anandichitira pamene ndimatuluka mʼdziko la Igupto.’ ");
INSERT INTO nya_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Lamulo ili lidzakhala ngati chizindikiro chomangidwa pa dzanja lanu ndi chikumbutso choyikidwa pamphumi panu kuti malamulo a Yehova asachoke pakamwa panu. Pakuti Yehova anakutulutsani mʼdziko la Igupto ndi dzanja lake lamphamvu. ");
INSERT INTO nya_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Muzichita mwambo uwu pa nthawi yake chaka ndi chaka. ");
INSERT INTO nya_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Yehova akadzakulowetsani ndi kukupatsani dziko la Kanaani monga analonjezera kwa inu ndi makolo anu, ");
INSERT INTO nya_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","muzikapereka kwa Ambuye ana onse oyamba kubadwa. Ziweto zonse zazimuna zoyamba kubadwa ndi za Ambuye. ");
INSERT INTO nya_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Koma mwana woyamba kubadwa wa bulu muzikamuwombola ndi mwana wankhosa, koma ngati simukamuwombola, muzikamuthyola khosi. Mwana wamwamuna woyamba kubadwa muzikamuwombola. ");
INSERT INTO nya_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Mʼtsogolomo mwana wanu akakafunsa kuti, ‘Zimenezi zikutanthauza chiyani?’ Mukamuwuze kuti, ‘Yehova anatitulutsa mʼdziko la Igupto, dziko la ukapolo ndi dzanja lamphamvu. ");
INSERT INTO nya_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Farao atakanitsitsa kuti asatitulutse, Yehova anapha aliyense woyamba kubadwa mʼdziko la Igupto, kuyambira ana a anthu ndi ziweto zomwe. Nʼchifukwa chake ine ndimapereka nsembe kwa Yehova, chachimuna chilichonse choyamba kubadwa ndipo mwana wamwamuna woyamba kubadwa ndimamuwombola.’ ");
INSERT INTO nya_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ndipo chidzakhala kwa inu ngati chizindikiro chomangidwa pa dzanja lanu ndi pamphumi panu kuonetsa kuti Yehova anakutulutsani mʼdziko la Igupto ndi dzanja lake lamphamvu.” ");
INSERT INTO nya_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Farao atalola anthu aja kuti atuluke, Mulungu sanawadzeretse njira yodutsa dziko la Afilisti, ngakhale kuti inali yachidule popeza Mulungu anati, “Ngati anthuwa atadzakumana ndi nkhondo angadzakhumudwe ndi kubwerera ku Igupto.” ");
INSERT INTO nya_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Choncho Mulungu anawadzeretsa anthuwo njira yozungulira ya mʼchipululu kulowera ku Nyanja Yofiira. Komabe Aisraeli anatuluka mʼdziko la Igupto atakonzekera nkhondo. ");
INSERT INTO nya_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mose ananyamula mafupa a Yosefe chifukwa Yosefe anawalumbiritsa ana a Israeli. Iye anawawuza kuti, “Mulungu adzabwera ndithu kudzakuthandizani, ndipo mudzanyamule mafupa anga pochoka ku malo ano.” ");
INSERT INTO nya_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Atachoka ku Sukoti anakagona ku Etamu mʼmphepete mwa chipululu. ");
INSERT INTO nya_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Nthawi yamasana Yehova amakhala patsogolo pa anthu kuwatsogolera njira ndi chipilala cha mtambo, ndipo usiku Yehova ankawatsogolera ndi chipilala cha moto, kuwawunikira njira kuti athe kuyenda masana ndi usiku. ");
INSERT INTO nya_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Usana, chipilala cha mtambo ndi usiku, chipilala cha moto zinali patsogolo kuwatsogolera anthu aja. ");
INSERT INTO nya_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Kenaka Yehova anati kwa Mose, ");
INSERT INTO nya_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Uza Aisraeli abwerere ndi kukagona pafupi ndi Pihahiroti, pakati pa Migidoli ndi nyanja. Inu mumange zithando mʼmbali mwa nyanja moyangʼanana ndi Baala-Zefoni. ");
INSERT INTO nya_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Farao adzaganiza kuti ‘Aisraeli asokonezeka nʼkumangozungulirazungulira mu dzikomo, chipululu chitawazinga.’ ");
INSERT INTO nya_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ndidzawumitsa mtima wa Farao ndipo adzathamangira Aisraeliwo. Choncho ndikadzagonjetsa Farao ndi gulu lake lonse la nkhondo, Ine ndidzalemekezedwa.” Choncho Aisraeli aja anachita zimenezi. ");
INSERT INTO nya_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Farao, mfumu ya Igupto atamva kuti anthu aja athawa, iye pamodzi ndi nduna zake anasintha maganizo awo pa Israeli ndipo anati, “Ife tachita chiyani? Tawalola Aisraeli kuti apite ndi kuleka kutitumikira?” ");
INSERT INTO nya_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Choncho anakonzetsa galeta lake ndipo ananyamuka pamodzi ndi ankhondo ake. ");
INSERT INTO nya_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Iye anatenga magaleta 600 abwino kwambiri pamodzi ndi magaleta ena a dziko la Igupto. Anatenganso akuluakulu onse ankhondo. ");
INSERT INTO nya_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Yehova anawumitsa mtima wa Farao mfumu ya dziko la Igupto, kotero iye anawathamangira Aisraeli amene ankachoka mʼdzikomo mosavutika. ");
INSERT INTO nya_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Aigupto aja (kutanthauza akavalo ndi magaleta onse a Farao, okwera akavalowo pamodzi ndi gulu lonse la nkhondo) analondola Aisraeli aja ndipo anakawapeza pamalo pamene anamanga zithando paja, mʼmbali mwa nyanja, pafupi ndi Pihahiroti, moyangʼanana ndi Baala-Zefoni. ");
INSERT INTO nya_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Tsono Farao anayandikira. Ndipo Aisraeli ataona kuti Aigupto akuwatsatira, anachita mantha aakulu ndipo anafuwula kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Iwo anafunsa Mose kuti, “Kodi nʼchifukwa chakuti kunalibe manda ku dziko la Igupto kuti iwe utibweretse muno mʼchipululu kuti tidzafe? Chimene watichitachi nʼchiyani, kutitulutsa mʼdziko la Igupto? ");
INSERT INTO nya_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Kodi sindizo zimene tinakuwuza mʼdziko la Igupto? Ife tinati, ‘Tileke titumikire Aigupto?’ Zikanatikomera kutumikira Aigupto kulekana ndi kufa mʼchipululu muno.” ");
INSERT INTO nya_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mose anayankha anthu kuti, “Musachite mantha. Imani, ndipo muone chipulumutso chimene Yehova akuchitireni lero. Aigupto amene mukuwaona lerowa simudzawaonanso. ");
INSERT INTO nya_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yehova adzakumenyerani nkhondo. Inu mungokhala chete.” ");
INSERT INTO nya_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Kenaka Yehova anati kwa Mose, “Chifukwa chiyani ukufuwulira kwa ine? Uwuze Aisraeli aziyenda. ");
INSERT INTO nya_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Nyamula ndodo yako ndi kutambasula dzanja lako kuloza ku nyanja, kugawa madzi kuti Aisraeli awoloke powuma. ");
INSERT INTO nya_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ine ndidzawumitsa mitima ya Aigupto kotero kuti adzatsatirabe Aisraeli. Ndipo ine ndikadzagonjetsa Farao ndi asilikali ake onse ankhondo, okwera magaleta ndi akavalo, ndidzapeza ulemerero. ");
INSERT INTO nya_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Aigupto adzadziwa kuti Ine ndine Yehova akadzaona mmene ndipambanire Farao ndi magaleta ndi owayendetsa ake.” ");
INSERT INTO nya_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ndipo mngelo wa Mulungu amene amayenda patsogolo pa gulu lankhondo la Israeli anachoka ndi kupita kumbuyo kwawo. Chipilala cha mtambo chinasunthanso kuchoka kutsogolo ndi kupita kumbuyo kwawo. ");
INSERT INTO nya_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Choncho mtambowo unakhala pakati pa asilikali ankhondo a dziko la Igupto ndi a dziko la Israeli. Choncho panali mdima motero kuti magulu awiri ankhondowa sanathe kuyandikizana usiku wonse. ");
INSERT INTO nya_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Kenaka Mose anatambalitsa dzanja lake pa nyanja, ndipo Yehova pogwiritsa ntchito mphepo yamphamvu ya kummawa imene inawomba usiku wonse anabweza madzi ndi kuwumitsa nyanja ija. Choncho nyanja ija inagawanika. ");
INSERT INTO nya_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Ndipo Aisraeli anawoloka pakati pa nyanja powuma, madzi atasanduka khoma kumanja ndi kumanzere kwawo. ");
INSERT INTO nya_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Aigupto onse, Farao, ndi onse okwera pa magaleta ndi akavalo anawalondola ndipo analowa mʼmadzi. ");
INSERT INTO nya_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Kutatsala pangʼono kucha, Yehova ali mu chipilala chamoto ndi chamtambo, anayangʼana asilikali ankhondo a Igupto ndipo anabweretsa chisokonezo pakati pawo. ");
INSERT INTO nya_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Yehova anamanga matayala a magaleta kotero kuti ankavutika kuyenda. Ndipo Aigupto anati, “Tiyeni tiwathawe Aisraeli! Yehova akuwamenyera nkhondo kulimbana nafe.” ");
INSERT INTO nya_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Kenaka Yehova anati kwa Mose, “Tambasula dzanja lako pa nyanja kuti madzi amize Aigupto ndi magaleta awo ndi okwera pa akavalo.” ");
INSERT INTO nya_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mose anatambasula dzanja lake pa nyanja, ndipo mmene kumacha nyanja inabwerera mʼmalo mwake. Aigupto pothawa anakumana nayo, ndipo Yehova anawakokera mʼnyanja momwemo. ");
INSERT INTO nya_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Madzi anabwerera ndi kumiza magaleta ndi okwera akavalo, asilikali ankhondo onse amene anatsatira Aisraeli mʼnyanja, palibe ndi mmodzi yemwe amene anapulumuka. ");
INSERT INTO nya_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Koma Aisraeli aja anawoloka nyanja pansi pali powuma, madzi atachita khoma kumanja ndi kumanzere kwawo. ");
INSERT INTO nya_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Tsiku limeneli Yehova anapulumutsa Israeli mʼmanja mwa Aigupto ndipo Israeli anaona Aigupto ali lambalamba mʼmbali mwa nyanja atafa ");
INSERT INTO nya_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Choncho Aisraeli anaona dzanja lamphamvu la Yehova limene linagonjetsa Aigupto aja, ndipo iwo anaopa Yehova ndi kumukhulupirira pamodzi ndi mtumiki wake Mose. ");
INSERT INTO nya_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ndipo Mose ndi Aisraeli anayimbira Yehova nyimbo iyi: “Ine ndidzayimbira Yehova pakuti wakwezeka mʼchigonjetso. Kavalo ndi wokwera wake, Iye wawaponya mʼnyanja. ");
INSERT INTO nya_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yehova ndiye mphamvu yanga ndi nyimbo yanga; ndiye chipulumutso changa. Iye ndiye Mulungu wanga, ndipo ndidzamutamanda, Mulungu wa makolo anga, ine ndidzamukweza. ");
INSERT INTO nya_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yehova ndi wankhondo; Yehova ndilo dzina lake. ");
INSERT INTO nya_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Magaleta a Farao ndi asilikali ake ankhondo Iye wawaponya mʼnyanja. Akatswiri ankhondo amphamvu a Farao amizidwa mʼNyanja Yofiira. ");
INSERT INTO nya_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Nyanja yakuya inawaphimba; Iwo anamira pansi ngati mwala.” ");
INSERT INTO nya_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Yehova, dzanja lanu lamanja ndi laulemerero chifukwa cha mphamvu zake. Ndithu Yehova, dzanja lanu lamanja linaphwanya mdani. ");
INSERT INTO nya_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ndi ulemerero wanu waukulu, munagonjetsa okutsutsani. Inu munatumiza mkwiyo wanu waukulu; ndipo unawapsereza ngati udzu. ");
INSERT INTO nya_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ndi mpweya wotuluka mʼmphuno mwanu madzi anawunjikana pamodzi. Nyanja yakuya ija inasanduka madzi owuma gwaa kufika pansi. ");
INSERT INTO nya_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Mdaniyo anati, “Ine ndidzawalondola, ndipo ndidzawagwira. Ndidzagawa chuma chawo; ndiye chokhumba changa chidzakwaniritsidwa. Ine ndidzasolola lupanga langa, ndi mkono wanga ndidzawawononga.” ");
INSERT INTO nya_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Koma Inu munawuzira mphepo yanu, ndipo nyanja inawaphimba. Iwo anamira ngati chitsulo mʼmadzi amphamvu. ");
INSERT INTO nya_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ndithu Yehova, pakati pa milungu, ndani afanana nanu? Inu amene muli woyera, ndiponso wotamandika wolemekezeka, chifukwa cha ntchito zanu, zazikulu ndi zodabwitsa? ");
INSERT INTO nya_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Munatambasula dzanja lanu lamanja ndipo dziko linawameza. ");
INSERT INTO nya_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ndi chikondi chanu chosasinthika mudzatsogolera anthu amene munawawombola. Ndi mphamvu zanu munawatsogolera ku malo anu woyera. ");
INSERT INTO nya_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Anthu amitundu ina anamva za mbiriyi ndipo ananjenjemera ndi mantha, mantha woopsa agwira anthu a dziko la Filisiti. ");
INSERT INTO nya_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Tsopano mafumu a ku Edomu agwidwa ndi mantha aakulu, otsogolera a dziko la Mowabu akunjenjemera ndi mantha, ndipo anthu a ku Kanaani asungunuka ndi mantha. ");
INSERT INTO nya_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Onse agwidwa ndi mantha woopsa. Popeza anaona mphamvu zanu zazikulu, iwo ayima chilili ngati mwala mpaka anthu anu, Inu Yehova atadutsa; inde mpaka atadutsa anthu amene munawagula. ");
INSERT INTO nya_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Inu mudzawalowetsa ndi kuwakhazikitsa pa phiri lanu. Pa malo pamene Inu Yehova munawapanga kuti muzikhalapo; malo wopatulika amene Inu Ambuye munawakonza ndi manja anu. ");
INSERT INTO nya_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“Yehova adzalamula mpaka muyaya.” ");
INSERT INTO nya_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Akavalo a Farao, magaleta ndi oyendetsa akavalo atalowa mʼnyanja, Yehova anawabwezera madziwo mʼnyanja ndi kuwamiza, koma Aisraeli anawoloka nyanjayo powuma. ");
INSERT INTO nya_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ndipo Miriamu mneneri wamkazi, mlongo wa Aaroni anatenga zoyimbira ndipo akazi onse anamutsatira pambuyo, akuyimba ndi zoyimbira ndi kuvina. ");
INSERT INTO nya_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriamu anawayimbira nyimbo iyi: “Imbirani Yehova, chifukwa iye wapambana. Kavalo ndi wokwerapo wake Iye wawamiza mʼnyanja.” ");
INSERT INTO nya_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ndipo Mose anatsogolera Israeli kuchoka ku nyanja yofiira ndi kupita ku chipululu cha Suri. Anayenda mʼchipululu masiku atatu wosapeza madzi. ");
INSERT INTO nya_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ndipo anafika ku Mara. Koma sanathe kumwa madzi akumeneko chifukwa anali owawa. (Ndi chifukwa chake malowo amatchedwa Mara). ");
INSERT INTO nya_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Tsono anthu aja anadandaulira Mose ndi kumufunsa kuti, “Kodi tikumwa chiyani?” ");
INSERT INTO nya_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ndipo Mose anapemphera kwa Yehova, ndipo Yehova anamuonetsa kamtengo. Iye anakaponya mʼmadzimo ndipo madzi anakhala abwino. Kumeneko Yehova anawayikira lamulo ndi maweruziro. Kumenekonso Yehova anawayesa. ");
INSERT INTO nya_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Yehova anati, “Ngati inu mudzamvetsa bwino mawu anga, kuchita zolungama, kumvera malamulo anga ndi kusamalitsa zimene ndikukuwuzani ndiye kuti Ine sindidzayika pa inu matenda amene ndinayika pa anthu a ku Igupto popeza ndine Yehova amene ndimakuchiritsani.” ");
INSERT INTO nya_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Kenaka anafika ku Elimu, kumene kunali akasupe khumi ndi awiri ndi mitengo ya migwalangwa makumi asanu ndi awiri, ndipo anamanga misasa yawo kumeneko pafupi ndi madzi. ");
INSERT INTO nya_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Pambuyo pake gulu lonse la Aisraeli linachoka ku Elimu, ndipo pa tsiku la khumi ndi chisanu mwezi wachiwiri chichokere mʼdziko la Igupto, anafika ku chipululu cha Sini chimene chinali pakati pa Elimu ndi Sinai. ");
INSERT INTO nya_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Mʼchipululumo gulu lonse linadandaulira Mose ndi Aaroni ");
INSERT INTO nya_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","kuti, “Kukanakhala bwino Yehova akanatiphera mʼdziko la Igupto! Kumeneko timadya nyama ndi buledi mpaka kukhuta, koma inu mwabwera nafe ku chipululu kudzapha mpingo wonsewu ndi njala!” ");
INSERT INTO nya_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ndipo Yehova anati kwa Mose, “Ine ndidzakupatsani buledi wogwa kuchokera kumwamba ngati mvula. Anthu azituluka tsiku lililonse kukatola buledi wokwanira tsiku limenelo. Ine ndidzawayesa mʼnjira imeneyi kuti ndione ngati adzatsatira malangizo anga. ");
INSERT INTO nya_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Pa tsiku lachisanu ndi chimodzi, pamene azidzakonza buledi amene abwera naye, adzapeza kuti ndi wokwanira masiku awiri.” ");
INSERT INTO nya_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Kotero Mose ndi Aaroni anati kwa Aisraeli onse, “Nthawi yamadzulo inu mudzadziwa kuti ndi Yehova amene anakutulutsani mʼdziko la Igupto. ");
INSERT INTO nya_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Ndipo mmawa mudzaona ulemerero wa Yehova pakuti wamva kudandaula kwanu. Kodi ife ndi yani kuti muzitidandaulira?” ");
INSERT INTO nya_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mose anati, “Yehova adzakupatsani nyama madzulo aliwonse ndi buledi mmawa uliwonse kuti mukhute chifukwa Iye wamva madandawulo anu. Nanga ife ndi yani? Kudandaula kwanu simudandaulira ife, koma Yehova.” ");
INSERT INTO nya_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Kenaka Mose anawuza Aaroni kuti, “Uza gulu lonse la Aisraeli kuti, ‘Bwerani pamaso pa Yehova pakuti wamva kudandaula kwanu.’ ” ");
INSERT INTO nya_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Pamene Aaroni amayankhula ndi gulu lonse la Aisraeli, iwo anayangʼana ku chipululu, ndipo ulemerero wa Yehova umaoneka mu mtambo. ");
INSERT INTO nya_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Yehova anati kwa Mose, ");
INSERT INTO nya_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Ine ndamva kudandaula kwa Aisraeli. Awuze kuti, ‘Madzulo mudzadya nyama ndipo mmawa mudzakhuta buledi. Pamenepo mudzadziwa kuti ine ndine Yehova Mulungu wanu.’ ” ");
INSERT INTO nya_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Madzulo amenewo panatuluka zinziri zimene zinali ponseponse pa misasa yawo, ndipo mmawa panali mame kuzungulira misasa yawo. ");
INSERT INTO nya_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Mamewo atachoka, pa nthaka mʼchipululumo panaoneka tinthu tina topyapyala komanso totuwa ngati chipale. ");
INSERT INTO nya_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Aisraeli atationa anafunsana wina ndi mnzake nati, “Kodi timeneti nʼchiyani?” Popeza sanatidziwe. Mose anawawuza kuti, “Uyu ndi buledi amene Yehova wakupatsani kuti mudye. ");
INSERT INTO nya_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Yehova walamula kuti, ‘Aliyense atole zomukwanira kudya, malita awiri pa munthu mmodzi molingana ndi chiwerengero cha anthu amene ali mu tenti yanu.’ ” ");
INSERT INTO nya_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Aisraeli anachita zonse anawawuza. Ena anatola zambiri ena zochepa. ");
INSERT INTO nya_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ndipo iwo atayeza ndi muyeso wa malita awiri, iye amene anatola zambiri sizinamutsalireko ndipo amene anatola pangʼono sizinamuchepere. Aliyense anatola zomukwanira kudya. ");
INSERT INTO nya_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ndipo Mose anawawuza kuti, “Wina aliyense asasunge mpaka mmawa.” ");
INSERT INTO nya_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Komabe ena sanamvere Mose, anasungako mpaka mmawa. Koma mmawa mwake tonse tinali mphutsi zokhazokha. Kotero Mose anawapsera mtima. ");
INSERT INTO nya_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Mmawa uliwonse aliyense amatola zimene amazifuna, ndipo dzuwa likatentha zimasungunuka. ");
INSERT INTO nya_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Tsiku lachisanu ndi chimodzi anatuta malita anayi munthu aliyense, ndipo atsogoleri a mpingo wonse anabwera kudzawuza Mose za zimenezi. ");
INSERT INTO nya_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Iye anawawuza kuti, “Izi ndi zimene Yehova analamula, ‘Mawa ndi tsiku lopumula, Sabata Loyera la Yehova, choncho wotchani ndi kuphika zimene mukufuna. Sungani zotsala mpaka mmawa.’ ” ");
INSERT INTO nya_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Choncho anasunga mpaka mmawa monga Mose anawalamulira, ndipo sananunkhe kapena kuchita mphutsi. ");
INSERT INTO nya_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mose anati, “Idyani lero chifukwa lero ndi Sabata la Yehova. Lero simukapeza chilichonse kunjaku. ");
INSERT INTO nya_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Muzitola chakudya masiku asanu ndi limodzi koma tsiku la chisanu ndi chiwiri ndi la Sabata, simukapeza chilichonse kunjaku.” ");
INSERT INTO nya_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Komabe anthu ena anapita kuti akatole chakudya tsiku lachisanu ndi chiwiri, koma sanapeze kanthu. ");
INSERT INTO nya_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ndipo Yehova anafunsa Mose nati, “Kodi inu muzipitirira kukana kusunga malamulo ndi malangizo anga mpaka liti? ");
INSERT INTO nya_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Taonani, popeza Yehova wakupatsani Sabata nʼchifukwa chake tsiku lachisanu ndi chimodzi amakupatsani chakudya cha masiku awiri. Aliyense azikhala pamene ali pa tsiku lachisanu ndi chiwiri, pasapezeke wotuluka kunja.” ");
INSERT INTO nya_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Kotero anthu anapuma tsiku lachisanu ndi chiwiri. ");
INSERT INTO nya_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Aisraeli anatchula chakudyacho Mana. Chakudyacho chinkaoneka ngati mbewu zamapira, zoyera. Ndipo chinkakoma ngati chothira uchi. ");
INSERT INTO nya_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mose anati, “Chimene Yehova walamula ndi ichi: ‘Tengani muyeso wa malita awiri a mana ndi kusungira mibado imene ikubwera, kuti iwo adzaone chakudya chimene Ine ndinakupatsani kuti mudye mʼchipululu pamene ndinakutulutsani mʼdziko la Igupto.’ ” ");
INSERT INTO nya_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Choncho Mose anati kwa Aaroni, “Tenga mtsuko ndipo uyikemo malita awiri a mana. Ndipo uyike manawo pamaso pa Yehova kusungira mibado imene ikubwera.” ");
INSERT INTO nya_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Monga momwe Yehova analamulira Mose, Aaroni anayika mtsuko uja pafupi ndi bokosi la Chipangano kuti manawo asungike. ");
INSERT INTO nya_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Aisraeli anadya mana zaka 40, mpaka pamene anafika ku dziko kumene amati akakhazikeko. Iwo anadya mana mpaka pamene anafika mʼmalire a Kanaani. ");
INSERT INTO nya_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Malita awiri amafanana ndi gawo lakhumi la efa). ");
INSERT INTO nya_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Gulu lonse la Aisraeli linachoka ku chipululu cha Sini, ndi kumayenda malo ndi malo monga momwe anawalamulira Yehova. Iwo anamanga misasa yawo ku Refidimu koma kunalibe madzi woti anthu onse ndi kumwa. ");
INSERT INTO nya_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Kotero iwo anakangana ndi Mose nati, “Tipatse madzi akumwa.” Mose anayankha kuti, “Chifukwa chiyani mukukangana ndi ine? Chifukwa chiyani mukumuyesa Yehova?” ");
INSERT INTO nya_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Koma anthu anali ndi ludzu pamenepo ndipo anangʼungʼudza pamaso pa Mose namufunsa kuti, “Kodi nʼchifukwa chiyani unatitulutsa mʼdziko la Igupto kuti ife, ana athu pamodzi ndi ziweto zathu tife ndi ludzu?” ");
INSERT INTO nya_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ndipo Mose anapemphera kwa Yehova, “Kodi ndichite chiyani ndi anthu awa? Iwo atsala pangʼono kundigenda ndi miyala.” ");
INSERT INTO nya_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yehova anati kwa Mose, “Pita patsogolo pa anthuwo. Tenga ndodo imene unamenyera nyanja ya Nailo pamodzi ndi akuluakulu ena a Israeli ndi kunyamuka. ");
INSERT INTO nya_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ine ndidzayima patsogolo pako pafupi ndi thanthwe la ku Horebu. Ukamenye thanthwelo, madzi adzatuluka kuti anthu amwe.” Motero Mose anachita zimenezi pamaso pa akuluakulu a Israeli. ");
INSERT INTO nya_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ndipo iye anatcha malowo Masa ndi Meriba chifukwa Aisraeli anakangana ndi kuyesa Yehova ponena kuti, “Kodi pakati pathu pali Yehova kapena palibe?” ");
INSERT INTO nya_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amaleki anabwera ku Refidimu kudzamenyana ndi Aisraeli. ");
INSERT INTO nya_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mose anati kwa Yoswa, “Sankha amuna amphamvu ndipo upite ukamenyane ndi Amaleki. Mawa ndidzayima pamwamba pa phiri nditagwira ndodo ya Mulungu.” ");
INSERT INTO nya_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ndipo Yoswa anachitadi monga Mose anamulamulira. Iye anapita kukamenyana ndi Aamaleki ndipo Mose, Aaroni ndi Huri anapita pamwamba pa phiri. ");
INSERT INTO nya_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mose ankati akakweza manja ake, Aisraeli amapambana, koma akatsitsa manja akewo Amaleki amapambana. ");
INSERT INTO nya_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Manja a Mose atatopa, Aaroni ndi Huri anatenga mwala ndi kuyika pansi ndipo Mose anakhalapo. Aaroni ndi Huri anagwirizitsa manja a Mose wina mbali ina winanso mbali ina. Choncho manja a Mose analimba mpaka kulowa kwa dzuwa. ");
INSERT INTO nya_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Kotero Yoswa anagonjetsa asilikali ankhondo a Amaleki ndi lupanga. ");
INSERT INTO nya_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Kenaka Yehova anati kwa Mose, “Lemba izi mʼbuku kuti zidzakumbukirike ndipo uwonetsetse kuti Yoswa amve zimenezi, chifukwa Ine ndidzafafaniziratu Amaleki pa dziko lapansi, kotero kuti palibe amene adzawakumbukire.” ");
INSERT INTO nya_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mose anamanga guwa lansembe ndipo analitcha Yehova Chipambano Changa (Yehova Nisi). ");
INSERT INTO nya_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ndipo anati, “Kwezani mbendera ya Yehova. Yehova adzachitabe nkhondo ndi mibado yonse ya Aamaleki.” ");
INSERT INTO nya_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yetero wansembe wa ku Midiyani amenenso anali mpongozi wa Mose, anamva zonse zimene Mulungu anachitira Mose ndi anthu ake a Aisraeli ndi mmene Yehova anawatulutsira mʼdziko la Igupto. ");
INSERT INTO nya_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Mose atamubweza Zipora, mkazi wake, Yetero, mpongozi wake anamulandira ");
INSERT INTO nya_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","mwana wake wamkaziyo pamodzi ndi ana ake aamuna awiri. Mose anamupatsa mwana wachisamba dzina loti Geresomu popeza anati, “Ndakhala mlendo mʼdziko lachilendo.” ");
INSERT INTO nya_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ndipo mwana wake wachiwiri anamupatsa dzina loti Eliezara, pakuti anati, “Mulungu wa makolo anga anali thandizo langa. Iye anandipulumutsa ku lupanga la Farao.” ");
INSERT INTO nya_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yetero, mpongozi wa Mose pamodzi ndi ana a Mose aamuna awiri ndi mkazi wake anabwera kwa Mose ku chipululu pa phiri la Mulungu kumene Mose anamanga misasa. ");
INSERT INTO nya_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yetero anali atatumiza uthenga kwa Mose kuti, “Ine Yetero, mpongozi wako, ndikubwera ndi mkazi wako ndi ana ake awiri.” ");
INSERT INTO nya_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Kotero Mose anatuluka kukakumana ndi mpongozi wake ndipo anawerama ndi kupsompsona. Atalonjerana anakalowa mu tenti ");
INSERT INTO nya_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mose anafotokozera mpongozi wake zonse zimene Yehova anamuchita Farao ndi Aigupto chifukwa cha Israeli komanso zowawa zonse anakumana nazo mʼnjira. Mose anafotokozanso momwe Yehova anawapulumutsira. ");
INSERT INTO nya_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yetero anakondwa kwambiri atamva zabwino zonse zimene Yehova anachitira Aisraeli powapulumutsa mʼdzanja la Aigupto. ");
INSERT INTO nya_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Iye anati, “Alemekezeke Yehova amene wakupulumutsani mʼdzanja la Aigupto ndi Farao. Wapulumutsanso anthuwa mʼdzanja la Aigupto. ");
INSERT INTO nya_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Tsopano ndikudziwa kuti Yehova ndi wopambana milungu ina yonse, pakuti anachita izi kwa amene ananyoza Israeli.” ");
INSERT INTO nya_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Ndipo Yetero, mpongozi wa Mose anapereka nsembe yopsereza ndi nsembe zina kwa Mulungu. Aaroni ndi akuluakulu onse a Israeli anabwera kudzadya chakudya pamodzi ndi mpongozi wa Mose pamaso pa Mulungu. ");
INSERT INTO nya_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Mmawa mwake, Mose anakhala pa mpando kuti aweruze milandu ya anthu. Anthu anayima momuzungulira kuyambira mmawa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Mpongozi wa Mose ataona zonse zimene iye amawachitira anthu anati, “Nʼchiyani chimene mukuwachitira anthuwa? Nʼchifukwa chiyani mulipo nokha woweruza, pamene anthu onsewa ayimirira kuyambira mmawa mpaka madzulo?” ");
INSERT INTO nya_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mose anamuyankha kuti, “Chifukwa anthuwa anabwera kwa ine kudzafunsa zimene Mulungu akufuna. ");
INSERT INTO nya_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ngati munthu akangana ndi mʼbale wake, onse awiri amabwera kwa ine, ndipo ine ndimawaweruza. Ndimawawuzanso malamulo a Mulungu ndi malangizo ake.” ");
INSERT INTO nya_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Mpongozi wa Mose anayankha kuti, “Zimene mukuchitazi si zabwino. ");
INSERT INTO nya_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ntchitoyi ndi yayikulu kuposa mphamvu zanu. Inu simungathe kuyigwira nokha. Inu pamodzi ndi anthuwa amene amabwera kwa inu mudzatopa. ");
INSERT INTO nya_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Tsono tamverani ndikulangizeni, ndipo Mulungu akhale nanu. Inu muziwayimirira anthuwa pamaso pa Mulungu, ndipo mikangano yawo muzibwera nayo kwa Iye. ");
INSERT INTO nya_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Aphunzitseni mawu ndi malangizo a Mulungu. Aphunzitseni mmene ayenera kukhalira ndi zimene ayenera kuchita. ");
INSERT INTO nya_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Koma sankhani amuna odziwa ntchito yawo, anthu owopa Mulungu, anthu odalirika amene amadana ndi kupeza phindu mwachinyengo. Tsono muwayike kuti akhale oyangʼanira anthu motere: atsogoleri a anthu 1,000, ena a anthu 100, ena a anthu 50 ndi ena a anthu khumi. ");
INSERT INTO nya_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Tsono amenewa aziweruza anthu nthawi zonse. Mlandu uliwonse waukulu azibwera nawo kwa inu, koma mlandu waungʼono aziweruza okha. Izi zidzachititsa kuti ntchito yanu ipepuke, popeza mudzagwira ntchito mothandizana. ");
INSERT INTO nya_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ngati mutsatira malangizowa monga mmene Mulungu wakulamulirani ndiye kuti simudzafowoka ndipo anthu onsewa adzapita kwawo mu mtendere.” ");
INSERT INTO nya_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mose anamvera mpongozi wake ndi kuchita zonse zimene iye ananena. ");
INSERT INTO nya_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Iye anasankha amuna odziwa bwino ntchito zawo ndipo anawayika kuti akhale atsogoleri, oyangʼanira anthu motere: atsogoleri a anthu 1,000, ena a anthu 500, ena a anthu makumi asanu ndi ena a anthu khumi. ");
INSERT INTO nya_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Iwowa ankaweruza anthu nthawi zonse. Milandu yovuta ankabwera nayo kwa Mose, koma yosavuta ankayiweruza okha. ");
INSERT INTO nya_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Kenaka Mose analola kuti mpongozi wake, Yetero anyamuke kubwerera ku dziko la kwawo. ");
INSERT INTO nya_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Ana a Israeli aja anafika ku chipululu cha Sinai pa tsiku loyamba la mwezi wachitatu chichokere mʼdziko la Igupto. ");
INSERT INTO nya_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Atachoka ku Refidimu, anafika ku Sinai, ndipo Aisraeli anamangako misasa yawo moyangʼanana ndi phirilo. ");
INSERT INTO nya_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mose anakwera ku phiri kukakumana ndi Mulungu ndipo Yehova anamuyitana nati, “Ukawuze zidzukulu za Yakobo, ana onse a Israeli kuti, ");
INSERT INTO nya_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Inu eni munaona zimene ndinawachitira Aigupto ndiponso mmene ndinakunyamulirani, monga mmene chiwombankhanga chimanyamulira ana ake pa mapiko,’ ndikukubweretsani kwa Ine. ");
INSERT INTO nya_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Tsopano, ngati mumveradi mawu anga ndi kusunga pangano langa, mudzakhala chuma changa chapamtima pakati pa mitundu yonse. Ngakhale kuti dziko lonse lapansi ndi langa, ");
INSERT INTO nya_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","inu mudzakhala ansembe achifumu ndi mtundu woyera mtima. Awa ndi mawu amene uyenera kuwawuza Aisraeli.” ");
INSERT INTO nya_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ndipo Mose anabwerera ndi kuyitanitsa akuluakulu. Atabwera anawafotokozera mawu amene Yehova anamulamulira kuti adzanene. ");
INSERT INTO nya_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Anthu onse anayankha pamodzi kuti, “Ife tidzachita zonse zimene Yehova wanena.” Choncho Mose anabweza yankho lawo kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Yehova anati kwa Mose, “Ine ndibwera kwa iwe mu mtambo wakuda kuti anthu adzandimve ndikuyankhula ndi iwe. Choncho adzakukhulupirira nthawi zonse.” Kenaka Mose anawuza Yehova zimene anthu ananena. ");
INSERT INTO nya_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ndipo Yehova anati kwa Mose, “Pita kwa anthu onse ndi kuwayeretsa lero ndi mawa. Achape zovala zawo ");
INSERT INTO nya_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ndipo akhale atakonzeka pofika tsiku lachitatu, chifukwa tsiku limenelo Yehova adzatsika pa phiri la Sinai anthu onse akuona. ");
INSERT INTO nya_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Uwalembere malire anthuwo kuzungulira phirilo ndipo uwawuze kuti, ‘Samalani musakwere phirilo kapena kukhudza tsinde lake. Aliyense wokhudza phiri adzaphedwa ndithu. ");
INSERT INTO nya_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Aliyense wokhudza phiri adzaphedwa ndi miyala kapena kumulasa ndi mivi. Palibe amene adzamukhudze. Palibe munthu amene adzaloledwa kukhala ndi moyo ngakhale nyama. Iwo adzayenera kuphedwa.’ Koma anthu adzapita ku phirilo akadzamva kulira kwa lipenga la nyanga yankhosa.” ");
INSERT INTO nya_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Tsono Mose anatsika phiri lija nafika kwa anthu aja ndi kuwayeretsa. Iwo anachapa zovala zawo. ");
INSERT INTO nya_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Kenaka iye anati kwa anthu, “Konzekerani tsiku lachitatu, musagone pamodzi ndi mkazi.” ");
INSERT INTO nya_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Mʼmamawa wa tsiku lachitatu kunali mabingu, ziphaliwali ndi mtambo wakuda umene unaphimba phiri, ndiponso lipenga lolira kwambiri. Aliyense ku misasa kuja ananjenjemera ndi mantha. ");
INSERT INTO nya_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Ndipo Mose anatsogolera anthu kutuluka mʼmisasa kukakumana ndi Mulungu, ndipo anayima mʼmunsi mwa phiri. ");
INSERT INTO nya_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Phiri la Sinai linakutidwa ndi utsi, chifukwa Yehova anatsika ndi moto pa phiripo. Utsi unakwera ngati wochokera mʼngʼanjo yamoto ndipo phiri lonse linagwedezeka kwambiri. ");
INSERT INTO nya_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Liwu la lipenga linkakulirakulira. Tsono Mose anayankhula ndipo Yehova anamuyankha ndi mabingu. ");
INSERT INTO nya_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yehova anatsika nafika pamwamba pa phiri la Sinai, ndipo anayitana Mose kuti apite pa phiripo. Choncho Mose anakwera, ");
INSERT INTO nya_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ndipo Yehova anati kwa iye, “Tsika ukawachenjeze anthu kuti asayesere kudutsa malire kuti adzandione chifukwa ambiri a iwo adzafa. ");
INSERT INTO nya_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ngakhale ansembe amene amatumikira pamaso pa Yehova ayenera kudziyeretsa kuopa kuti ndingadzawalange.” ");
INSERT INTO nya_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mose anati kwa Yehova, “Anthu sangakwere phiri la Sinai chifukwa inu munatichenjeza. Lembani malire kuzungulira phiri ndipo mulipatule kuti likhale loyera.” ");
INSERT INTO nya_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Yehova anayankha, “Tsika ukamutenge Aaroni. Koma ansembe ndi anthu asayesere kubzola malire kuti abwere kwa Yehova chifukwa Iye adzawalanga.” ");
INSERT INTO nya_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ndipo Mose anatsika ndi kukawawuza anthuwo. ");
INSERT INTO nya_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ndipo Mulungu anayankhula mawu onse awa nati: ");
INSERT INTO nya_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ine ndine Yehova Mulungu wako amene ndinakutulutsa ku Igupto, mʼdziko la ukapolo. ");
INSERT INTO nya_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Usakhale ndi milungu ina koma Ine ndekha.” ");
INSERT INTO nya_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Usadzipangire chofanizira chinthu chilichonse chakumwamba kapena cha pa dziko lapansi kapena cha mʼmadzi a pansi pa dziko. ");
INSERT INTO nya_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Usazigwadire kapena kuzipembedza, pakuti Ine Yehova Mulungu wako, ndine Mulungu wansanje, wolanga ana chifukwa cha tchimo la makolo awo mpaka mʼbado wachitatu ndi wachinayi wa iwo amene amadana nane. ");
INSERT INTO nya_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Koma ndimaonetsa chikondi chosasinthika ku mibado miyandamiyanda ya anthu amene amandikonda, ndi kusunga malamulo anga. ");
INSERT INTO nya_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Usagwiritse ntchito molakwika dzina la Yehova Mulungu wako, pakuti Yehova adzamutenga kukhala wochimwa aliyense amene akugwiritsa ntchito dzina lakelo molakwika. ");
INSERT INTO nya_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Uzisunga tsiku la Sabata kuti likhale lopatulika. ");
INSERT INTO nya_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Uzigwira ntchito zako zonse masiku asanu ndi limodzi. ");
INSERT INTO nya_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Koma tsiku lachisanu ndi chiwiri ndi Sabata, tsiku loperekedwa kwa Yehova Mulungu wako. Tsiku limeneli musagwire ntchito iliyonse, inuyo kapena mwana wanu wamwamuna kapena mwana wanu wamkazi, wantchito wanu wamwamuna kapena mdzakazi wanu, ziweto zanu kapena mlendo amene akukhala mʼmudzi mwanu. ");
INSERT INTO nya_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Pakuti Yehova anapanga kumwamba ndi dziko lapansi, nyanja ndi zonse zimene zili mʼmenemo mʼmasiku asanu ndi limodzi. Iye anapuma pa tsiku lachisanu ndi chiwiri. Kotero Yehova anadalitsa tsiku la Sabata kuti likhale loyera. ");
INSERT INTO nya_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Lemekeza abambo ako ndi amayi ako kuti ukhale ndi moyo wautali mʼdziko limene Yehova Mulungu wako akukupatsa. ");
INSERT INTO nya_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Usaphe. ");
INSERT INTO nya_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Usachite chigololo. ");
INSERT INTO nya_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Usabe. ");
INSERT INTO nya_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Usapereke umboni womunamizira mnzako. ");
INSERT INTO nya_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Usasirire nyumba ya mnzako. Usasirire mkazi wa mnzako kapena wantchito wake wamwamuna kapena mdzakazi wake, ngʼombe yake kapena bulu wake, kapena chilichonse cha mnzako.” ");
INSERT INTO nya_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Pamene anthu ankamva mabingu ndi kuona ziphaliwali ndi kumvanso lipenga ndi kuona utsi umene umafuka mʼphiri, ananjenjemera ndi mantha. Ndipo iwo anayima patali. ");
INSERT INTO nya_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ndipo anati kwa Mose, “Iwe utiyankhule ndipo tidzamvera. Koma usalole kuti Mulungu atiyankhule, tingafe.” ");
INSERT INTO nya_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Koma Mose anati kwa anthuwo, “Musachite mantha. Mulungu wabwera kudzakuyesani kuti mukhale ndi mtima woopa Mulungu kuti musamuchimwire.” ");
INSERT INTO nya_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Anthu aja anayima patali koma Mose anayandikira mtambo wakuda kumene kunali Mulungu. ");
INSERT INTO nya_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ndipo Yehova anati kwa Mose, “Awuze izi Aisraeli: ‘Inu mwaona nokha kuti Ine ndakuyankhulani kuchokera kumwamba. ");
INSERT INTO nya_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Choncho musadzipangire milungu yasiliva kapena yagolide kuti muziyipembedza pamodzi ndi Ine.’ ” ");
INSERT INTO nya_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Mundimangire guwa ladothi ndipo muziperekapo nsembe zopsereza ndi nsembe zachiyanjano, nkhosa, mbuzi ndi ngʼombe zanu. Pamalo paliponse pamene Ine ndidzakonza kuti muzinditamandirapo, ndidzabwera ndi kukudalitsani. ");
INSERT INTO nya_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ngati mudzandimangira guwa lansembe lamiyala, musagwiritse ntchito miyala yosema, pakuti mudzalidetsa mukadzagwiritsa ntchito zida. ");
INSERT INTO nya_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Musamakwere pa makwerero popita pa guwa langa lansembe kuti mungaonetse maliseche anu. ");
INSERT INTO nya_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Uwawuze Aisraeli malamulo awa: ");
INSERT INTO nya_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Mukagula kapolo wa Chihebri, azikugwirirani ntchito zaka zisanu ndi chimodzi. Koma mʼchaka cha chisanu ndi chiwiri muzimumasula, ndipo asalipire kanthu. ");
INSERT INTO nya_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ngati anabwera yekha, amasulidwenso yekha. Koma ngati anali ndi mkazi pamene ankabwera, mkaziyo apite nayenso. ");
INSERT INTO nya_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ngati bwana wake amupatsa mkazi ndipo mkaziyo anabereka ana aamuna kapena aakazi, mkazi ndi anawo adzakhala a bwanayo ndipo mwamuna yekhayo ndiye adzamasulidwe. ");
INSERT INTO nya_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Koma ngati kapoloyo alengeza kuti, ‘Ine sindikufuna kumasulidwa chifukwa ndimakonda mbuye wanga, mkazi wanga ndi ana,’ ");
INSERT INTO nya_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","mbuye wakeyo abwere naye kwa Yehova. Abwere naye pa chitseko kapena pa mphuthu zachitseko ndipo abowole khutu lake ndi chitsulo. Ndipo iye adzakhala kapolo wake moyo wake wonse. ");
INSERT INTO nya_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Ngati munthu agulitsa mwana wake wamkazi kukhala mdzakazi, mwanayo asamasulidwe monga achitira ndi akapolo aamuna. ");
INSERT INTO nya_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Koma ngati mkaziyo sakukondweretsa bwana wake amene wamusankha kuti amukwatire, amulole kuti awomboledwe. Bwanayo alibe mphamvu zomugulitsa kwa anthu achilendo, chifukwa iyeyo waphwanya pangano lake lomukwatira iye. ");
INSERT INTO nya_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ngati anamusankha kuti akhale mkazi wa mwana wake, ayenera kumusunga ngati mwana wake wamkazi. ");
INSERT INTO nya_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ngati akwatira mkazi wina, asamumane woyambayo chakudya ngakhale chovala ndipo apiritirize kugona naye ngati mkazi wake. ");
INSERT INTO nya_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Koma ngati sangathe kumuchitira zonsezi, ndiye amuleke apite popanda kulipira kanthu. ");
INSERT INTO nya_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Munthu aliyense amene amenya mnzake namupha, iyenso ayenera kuphedwa. ");
INSERT INTO nya_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Koma ngati sanachite dala, ndipo Mulungu analola kuti zichitike, iyeyo athawire ku malo kumene ndidzakupatsani. ");
INSERT INTO nya_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Koma ngati munthu akonza chiwembu ndi kupha mnzake mwadala, ameneyo muchotseni ngakhale ku guwa langa lansembe ndipo aphedwe. ");
INSERT INTO nya_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Munthu aliyense amene amenya abambo ake kapena mayi ake ayenera kuphedwa. ");
INSERT INTO nya_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Munthu aliyense amene aba munthu mnzake, ndi kukamugulitsa, kapena kumangomusunga, ayenera kuphedwa. ");
INSERT INTO nya_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Aliyense amene atemberera abambo ake kapena amayi ake ayenera kuphedwa. ");
INSERT INTO nya_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Ngati anthu awiri akangana ndipo wina amenya mnzake ndi mwala kapena nkhonya koma wosamupha, womenyedwayo akadwala nagona pa bedi, ");
INSERT INTO nya_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","kenaka nachira ndi kuyamba kuyenda ndi ndodo kutuluka kunja kwa nyumba yake, ndiye kuti womenya mnzakeyo sadzayimbidwa mlandu. Komabe adzayenera kulipira womenyedwayo chifukwa cha nthawi imene anagona pa bedi ija, ndiponso ayenera kumusala mpaka atachiritsitsa. ");
INSERT INTO nya_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Ngati munthu amenya kapolo wake wamwamuna kapena mdzakazi ndi ndodo, kapolo uja ndikufa chifukwa cha kumenyedwako, munthuyo ayenera kulangidwa. ");
INSERT INTO nya_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Koma ngati kapolo uja akhala ndi moyo tsiku lonse kapena masiku awiri, ndiye kuti mbuye uja asalangidwe chifukwa kapolo ndi chuma chake. ");
INSERT INTO nya_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Ngati anthu akumenyana ndi kupweteka mayi woyembekezera, mayiyo napita padera, koma osavulala, wolakwayo ayenera kulipira chilichonse chimene mwamuna wake wa mkaziyo adzalamula ndipo bwalo lamilandu lavomereza. ");
INSERT INTO nya_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Koma ngati wavulazidwa kwambiri, ndiye malipiro ake adzakhala motere: moyo kulipa moyo, ");
INSERT INTO nya_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","diso kulipira diso, dzino kulipira dzino, mkono kulipa mkono, phazi kulipa phazi. ");
INSERT INTO nya_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Kutentha ndi moto kulipa kutentha ndi moto, bala kulipa bala, mkwingwirima kulipa mkwingwirima. ");
INSERT INTO nya_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Ngati munthu amenya wantchito wake wa mwamuna kapena mdzakazi wake pa diso ndi kuliwononga, wantchitoyo amasulidwe ngati malipiro a diso lake. ");
INSERT INTO nya_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ndipo ngati agulula dzino la wantchito wamwamuna kapena mdzakazi, wantchitoyo amasulidwe ngati malipiro a dzino lake. ");
INSERT INTO nya_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Ngati ngʼombe ipha munthu wamwamuna kapena wamkazi ndi nyanga yake, iponyedwe miyala ndipo nyama yake isadyedwe. Ndipo mwini ngʼombeyo asayimbidwe mlandu. ");
INSERT INTO nya_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Koma ngati ngʼombeyo inali ndi chizolowezi chogunda anthu ndipo mwini wakeyo anachenjezedwa koma iye sanayimange ndipo yapha mwamuna kapena mkazi, ngʼombeyo iponyedwe miyala ndipo mwini wakeyo aphedwenso. ");
INSERT INTO nya_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Koma ngati wauzidwa kuti alipire, iye apereke zimene wauzidwazo kuti awombole moyo wake. ");
INSERT INTO nya_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Lamulo ili ligwirenso ntchito ngati ngʼombeyo yagunda mwana wamwamuna kapena wamkazi. ");
INSERT INTO nya_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ngati ngʼombeyo yagunda kapolo wamwamuna kapena mdzakazi, mwini ngʼombeyo apereke masekeli makumi atatu a siliva kwa mwini kapoloyo, ndipo ngʼombeyo iponyedwe miyala. ");
INSERT INTO nya_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Munthu akasiya dzenje lapululu kapena akakumba dzenje koma wosaphimbapo, ndipo ngʼombe kapena bulu nʼkugweramo, ");
INSERT INTO nya_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","mwini dzenjelo amulipire mwini chiweto chakufacho koma iye atenge chiwetocho. ");
INSERT INTO nya_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Ngati ngʼombe ya munthu wina ipha ngʼombe ya mnzake, ngʼombe yamoyo ija igulitsidwe ndipo anthu awiriwo agawane pakati ndalama yake. Achite chimodzimodzi ndi ngʼombe yakufa ija. ");
INSERT INTO nya_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Koma zikadziwika kuti ngʼombeyo inali ndi khalidwe logunda, ndipo mwini wake samayitsekera mʼkhola, mwini ngʼombeyo alipire ngʼombe ina yamoyo koma atenge yakufayo.” ");
INSERT INTO nya_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Ngati munthu aba ngʼombe kapena nkhosa ndi kuyipha kapena kuyigulitsa, iye abweze ngʼombe zisanu pa ngʼombe imodzi ndi nkhosa zinayi pa nkhosa imodzi. ");
INSERT INTO nya_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Ngati mbala ipezeka ikuthyola nyumba ndipo imenyedwa nʼkufa, amene wapha mbalayo sanalakwe. ");
INSERT INTO nya_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Koma akayipha dzuwa litatuluka, woyiphayo ali ndi mlandu wakupha. “Mbala iyenera kubweza ndithu koma ngati ilibe kalikonse igulitsidwe, kulipira zomwe yabazo. ");
INSERT INTO nya_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Ngati chiweto chobedwacho chipezeka chamoyo mʼmanja mwake, kaya ndi ngʼombe kapena bulu kapena nkhosa, mbalayo ibwezere ziweto ziwiri pa chiweto chobedwacho. ");
INSERT INTO nya_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Ngati munthu alekerera ziweto zake kukalowa mʼmunda wa munthu wina kukadya mbewu zake, munthuyo amubwezere mwini mundawo mbewu zina zabwino kapena mpesa wina wabwino kwambiri. ");
INSERT INTO nya_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Ngati munthu ayatsa moto, motowo ndikukafika mpaka ku munda ndi kuwotcha mulu wa tirigu kapena tirigu wosadula, kapena munda wonse, ndiye kuti munthu amene anayatsa motoyo alipire. ");
INSERT INTO nya_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Ngati munthu asungitsidwa ndi mnzake ndalama kapena katundu, ndipo zinthu zija nʼkubedwa mʼnyumba mwake, wakubayo ngati agwidwa, ayenera kubwezera kawiri chobedwacho. ");
INSERT INTO nya_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Koma ngati mbalayo sipezeka, mwini nyumbayo ayenera kukaonekera ku bwalo lamilandu kuti akamve ngati anaba katundu wa mnzakeyo. ");
INSERT INTO nya_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ngati pali kukangana kokhudza ngʼombe, bulu, nkhosa, zovala kapena kanthu kalikonse kotayika, ndipo mmodzi ndikunena kuti chinthucho nʼchake, awiriwo abwere nawo mlandu wawowo pamaso pa Mulungu ndipo amene mlandu umugomere adzayenera kumulipira mnzakeyo kawiri. ");
INSERT INTO nya_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Ngati munthu wina anasungitsa mnzake bulu, ngʼombe, nkhosa, kapena chiweto chilichonse ndipo chiweto chija nʼkufa kapena kupweteka kapena kutengedwa popanda wina kuona, ");
INSERT INTO nya_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ndiye kuti anthu awiriwo ayenera kulumbira pamaso pa Mulungu kuti asatenge chinthu cha mnzake. Zikatero mwini katundu uja avomereze zimenezi ndipo asabwezeredwe kanthu. ");
INSERT INTO nya_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Koma ngati chiwetocho chinabedwa, iye ayenera kubwezera mwini wakeyo. ");
INSERT INTO nya_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ngati chinagwidwa ndi zirombo, iye ayenera kubweretsa zotsalira ngati umboni ndipo sadzalipira kanthu. ");
INSERT INTO nya_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Ngati munthu abwereka chiweto cha mnzake ndipo chiweto chija nʼkuvulala kapena kufa chikanali ndi iyebe, wobwerekayo ayenera kulipira. ");
INSERT INTO nya_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Koma ngati mwini wakeyo ali ndi chiwetocho, wobwerekayo sadzalipira. Ngati anapereka ndalama pobwereka chiwetocho, ndalama anaperekazo zilowa mʼmalo mwa chiweto chakufacho. ");
INSERT INTO nya_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Ngati munthu anyenga namwali wosadziwa mwamuna amene sanapalidwe ubwenzi ndi kugona naye, munthuyo ayenera kulipira malowolo ndipo adzakhala mkazi wake. ");
INSERT INTO nya_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ngati abambo ake akanitsitsa kwamtuwagalu kumupereka kuti amukwatire, munthuyo aperekebe malowolo woyenera namwaliyo. ");
INSERT INTO nya_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Musayilole mfiti yayikazi kuti ikhale ndi moyo. ");
INSERT INTO nya_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Aliyense wogonana ndi chiweto ayenera kuphedwa. ");
INSERT INTO nya_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Aliyense wopereka nsembe kwa mulungu wina osati Yehova awonongedwe. ");
INSERT INTO nya_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Musazunze mlendo kapena kumuchitira nkhanza, pakuti inu munali alendo mʼdziko la Igupto. ");
INSERT INTO nya_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Musazunze mkazi wamasiye kapena mwana wamasiye. ");
INSERT INTO nya_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ngati muwazunza ndipo iwo nʼkulirira kwa Ine, ndidzamva kulira kwawo. ");
INSERT INTO nya_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ine ndidzakukwiyirani ndipo ndidzakuphani ndi lupanga. Akazi anu adzakhala amasiye ndiponso ana anu adzakhala wopanda abambo. ");
INSERT INTO nya_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Ngati mukongoza ndalama kwa mʼbale wanu amene ndi mʼmphawi pakati panu, musadzamuchite monga zimene amachita wokongoza ndalama. Musadzamuyikire chiwongoladzanja. ");
INSERT INTO nya_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Mukatenga chovala cha mnzanu kuti chikhale chikole mumubwezere dzuwa lisanalowe ");
INSERT INTO nya_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","chifukwa chovala chimene amadzifundira nacho nʼchomwecho. Nanga usiku adzafunda chiyani? Tsonotu ngati adzandilirira, Ine ndidzamva pakuti ndine wachifundo. ");
INSERT INTO nya_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Musachite chipongwe Mulungu wanu kapena kutemberera mtsogoleri wa anthu anu. ");
INSERT INTO nya_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Musachedwe kupereka kwa Ine zokolola zanu zochuluka ndi vinyo wanu wochuluka. “Mundipatse ana anu achisamba aamuna. ");
INSERT INTO nya_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Muchite chimodzimodzi ndi ngʼombe zanu ndi nkhosa zanu. Mwana woyamba kubadwa azikhala ndi amayi ake masiku asanu ndi awiri. Koma pa tsiku lachisanu ndi chitatu mwanayo muzimupereka kwa Ine. ");
INSERT INTO nya_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Inu mukhale anthu anga opatulika. Choncho musadye nyama ya chiweto chimene chaphedwa ndi zirombo. Nyamayo muwaponyere agalu.” ");
INSERT INTO nya_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Usafalitse mbiri yabodza. Usathandize munthu wolakwa pomuchitira umboni wonama. ");
INSERT INTO nya_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Usatsate gulu la anthu ndi kuchita choyipa. Pamene ukupereka umboni mʼbwalo lamilandu, usakhotetse mlandu chifukwa chofuna kukondweretsa anthu ambiri. ");
INSERT INTO nya_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ndipo poweruza mlandu wa munthu wosauka usamukondere. ");
INSERT INTO nya_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Ngati ukumana ndi ngʼombe kapena bulu wa mdani wako zitasochera, uwonetsetse kuti wazitenga kupita nazo kwa mwini wakeyo. ");
INSERT INTO nya_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ngati uwona bulu wa munthu wina amene amakuda atagwa ndi katundu, usamusiye pomwepo, uwonetsetse kuti wamuthandiza. ");
INSERT INTO nya_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Usakhotetse milandu ya anthu osauka. ");
INSERT INTO nya_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Upewe zabodza ndipo usaphetse munthu wosalakwa ndi wolungama, chifukwa Ine sindidzakhululukira wochimwa. ");
INSERT INTO nya_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Musamalandire chiphuphu, pakuti chiphuphu chimadetsa mʼmaso anthu oweruza ndi kusintha mawu awo kuti mlandu uyipire osalakwa. ");
INSERT INTO nya_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Usamuzunze mlendo, pakuti inu nomwe mukudziwa mmene amamvera mlendo chifukwa nanunso munali alendo mʼdziko la Igupto. ");
INSERT INTO nya_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Muzidzala mbewu zanu mʼmunda ndi kumakolola mbewuzo kwa zaka zisanu ndi chimodzi. ");
INSERT INTO nya_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Koma chaka chachisanu ndi chiwiri muzisiya osalima mindayo kuti anthu osauka pakati panu azipezamo chakudya, ndipo nyama zakuthengo zizidya zotsalazo. Muzichita chimodzimodzi ndi minda ya mpesa ndi mitengo ya olivi. ");
INSERT INTO nya_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Muzigwira ntchito masiku asanu ndi limodzi koma tsiku lachisanu ndi chiwiri musagwire ntchito kuti ngʼombe yanu ndi bulu wanu apume ndiponso kuti kapolo wobadwira mʼnyumba yanu ndi mlendo yemwe apezenso mphamvu. ");
INSERT INTO nya_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Samalani pochita zonse zimene ine ndanena. Musamapemphere kwa milungu ina ndipo mayina awo musamawatchule. ");
INSERT INTO nya_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Muzichita zikondwerero zolemekeza Ine katatu pa chaka. ");
INSERT INTO nya_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Muzichita Chikondwerero cha Buledi wopanda Yisiti. Kwa masiku asanu ndi awiri muzidya buledi wopanda yisiti monga ndinakulamulirani. Muzichita zimenezi mwezi wa Abibu pa nthawi yomwe ndayika, pakuti mʼmwezi umenewu munatuluka mʼdziko la Igupto. “Pasapezeke munthu wobwera pamaso panga wopanda kanthu mʼmanja. ");
INSERT INTO nya_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Muzichita Chikondwerero cha Masika pogwiritsa ntchito zipatso zoyambirira kucha zimene munadzala mʼmunda. “Muzichitanso Chikondwerero cha Zokolola pakutha pa chaka, pamene mukututa zokolola zanu mʼmunda. ");
INSERT INTO nya_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Amuna onse azionekera pamaso pa Ambuye Yehova katatu pa chaka. ");
INSERT INTO nya_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Musapereke magazi anyama ngati nsembe kwa Ine pamodzi ndi chilichonse chimene chili ndi yisiti. “Ndipo musasunge mafuta anyama yansembe ya pa chikondwerero mpaka mmawa. ");
INSERT INTO nya_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Muzibwera ndi zipatso zoyambirira kucha zabwino kwambiri ku Nyumba ya Yehova Mulungu wanu. “Musamaphike kamwana kambuzi mu mkaka wa mayi wake. ");
INSERT INTO nya_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Taona Ine ndikutuma mngelo wanga patsogolo panu kuti akutetezeni mʼnjiramo ndi kukakufikitsani ku malo amene ndakonza. ");
INSERT INTO nya_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Muzimumvera ndi kumvetsetsa zimene akunena. Musamuwukire chifukwa sadzakhululuka kuwukira kwanu, pakuti akuchita zimenezi mʼdzina langa. ");
INSERT INTO nya_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ngati mudzamvera iyeyu ndi kuchita zonse zimene Ine ndikunena, Ine ndidzakhala mdani wa adani anu ndipo ndidzatsutsana ndi onse otsutsana nanu. ");
INSERT INTO nya_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Mngelo wanga adzakhala patsogolo panu ndipo adzakufikitsani mʼdziko la Aamori, Ahiti, Aperezi, Akanaani, Ahivi ndi Ayebusi, ndipo ndidzawapheratu onsewo. ");
INSERT INTO nya_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Musagwadire milungu yawo kapena kuyipembedza. Ndipo musatsatire zinthu zomwe amachita. Koma inu mukawononge milungu yawo ndi kuphwasula malo amene amapembedzerapo. ");
INSERT INTO nya_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Muzipembedza Yehova Mulungu wanu ndipo adzakudalitsani ndi chakudya ndi madzi ndiponso ndidzachotsa nthenda pakati panu. ");
INSERT INTO nya_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Palibe mkazi amene adzapite padera kapena kukhala wosabereka mʼdziko mwanu. Ndidzakupatsani moyo wautali. ");
INSERT INTO nya_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Ine ndidzawachititsa mantha ndi kusokoneza anthu onse amene adzalimbana ndi inu ndipo adani anu onse adzakuthawani. ");
INSERT INTO nya_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ahivi, Akanaani ndi Ahiti adzathawa ngati kuti ndawatumizira mavu. ");
INSERT INTO nya_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Komabe sindidzawachotseratu onse mʼchaka chimodzi chifukwa dziko lingadzakhale lopanda anthu ndipo nyama zakuthengo zidzakuchulukirani. ");
INSERT INTO nya_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ndidzawathamangitsa pangʼonopangʼono mpaka inu mutachuluka kokwanira mwakuti nʼkutenga dzikolo. ");
INSERT INTO nya_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Malire a dziko lanu adzakhala kuyambira ku Nyanja Yofiira mpaka ku nyanja ya Afilisti, ndiponso kuyambira ku chipululu mpaka ku mtsinje wa Yufurate. Anthu onse okhala mʼdziko limeneli ndidzawapereka mʼmanja mwanu ndipo mudzawathamangitsa. ");
INSERT INTO nya_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Musachite pangano ndi iwo kapena ndi milungu yawo. ");
INSERT INTO nya_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Asadzakhale mʼdziko lanu chifukwa angadzakuchimwitseni ndi kuyamba kupembedza milungu yawo. Mukadzatero ndiye kuti mwakodwa mu msampha.” ");
INSERT INTO nya_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Ndipo Yehova anati kwa Mose, “Bwera ku phiri kuno kwa Yehova, iwe pamodzi ndi Aaroni, Nadabu, Abihu ndi akuluakulu a Israeli makumi asanu ndi awiri. Enanu mundipembedze muli chapatali. ");
INSERT INTO nya_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Koma Mose yekha ayandikire Yehova, ndipo enawo asayandikire. Komanso anthu ena onse asakwere nawe ku phiri kuno.” ");
INSERT INTO nya_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Tsono Mose anapita kukawuza anthu mawu onse a Yehova ndi malamulo onse, ndipo anthu onse anayankha mogwirizana kuti, “Tidzachita zonse zimene Yehova wanena.” ");
INSERT INTO nya_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ndipo Mose analemba zonse zimene Yehova ananena. Mmawa mwake Mose anadzuka nayamba kumanga guwa lansembe mʼmunsi mwa phirilo ndipo anayimika miyala khumi ndi iwiri ngati zipilala kuyimira mafuko khumi ndi awiri a Israeli. ");
INSERT INTO nya_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Kenaka Mose anatuma Aisraeli achinyamata kuti aphe ndi kukapereka kwa Yehova nsembe zopsereza zachiyanjano. ");
INSERT INTO nya_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mose anatenga theka la magazi ndi kuyika mʼmbale, ndipo theka linalo analiwaza pa guwa lansembe. ");
INSERT INTO nya_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Anatenganso Buku la Chipangano ndi kuwerengera anthu. Anthuwo anayankha kuti, “Zonse zimene Yehova wanena tamva, ndipo tidzazichita.” ");
INSERT INTO nya_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Kenaka Mose anatenga magazi, nawaza anthuwo ndipo anati, “Awa ndi magazi a pangano limene Yehova wapanga ndi inu molingana ndi mawu ake onsewa.” ");
INSERT INTO nya_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Kenaka Mose pamodzi ndi Aaroni, Nadabu, Abihu ndi akuluakulu makumi asanu ndi awiri a Israeli aja anakwera ku phiri, ");
INSERT INTO nya_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ndipo anaona Mulungu wa Israeli. Pansi pa mapazi ake panali njira yoyendamo yopangidwa ndi mwala wa safiro woyalidwa bwino wa maonekedwe owala ngati thambo. ");
INSERT INTO nya_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ngakhale anaona Yehova koma sanafe, mʼmalo mwake anadya ndi kumwa. ");
INSERT INTO nya_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Yehova anati kwa Mose, “Bwera kwa ine ku phiri kuno, ndipo udikire konkuno. Ndidzakupatsa miyala imene ndalembapo malemba kuti ndiwaphunzitse.” ");
INSERT INTO nya_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ndipo anayamba ulendo wopita ku phiri la Mulungu pamodzi ndi womuthandiza wake Yoswa. ");
INSERT INTO nya_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Apa nʼkuti Mose atawawuza akuluakulu aja kuti, “Mudikire pano mpaka titabweranso. Aaroni ndi Huri ali nanu, aliyense amene ali ndi milandu apite kwa iwo.” ");
INSERT INTO nya_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mose atakwera ku phiri kuja mtambo unaphimba phirilo. ");
INSERT INTO nya_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ulemerero wa Yehova unakhala pa phiri la Sinai, ndipo mtambo unaphimba phirilo kwa masiku asanu ndi limodzi. Pa tsiku lachisanu ndi chiwiri Yehova anayitana Mose kuchokera mu mtambowo. ");
INSERT INTO nya_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ulemerero wa Yehova uja unkaoneka ngati malawi a moto pamwamba pa phirilo. ");
INSERT INTO nya_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ndipo Mose analowa mʼmitambo nakwera phiri. Iye anakhala ku phiriko 40 usana ndi usiku. ");
INSERT INTO nya_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Yehova ananena kwa Mose kuti, ");
INSERT INTO nya_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Uza Aisraeli kuti abweretse chopereka kwa Ine. Iwe ulandire choperekacho mʼmalo mwanga kuchokera kwa munthu amene akupereka mwakufuna kwake. ");
INSERT INTO nya_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Zopereka zimene ulandire kwa anthuwo ndi izi: Golide, siliva ndi mkuwa. ");
INSERT INTO nya_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Nsalu zobiriwira, zapepo, zofiira, nsalu zofewa, ubweya wambuzi; ");
INSERT INTO nya_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","zikopa za nkhosa zazimuna za utoto wofiira ndi zikopa za akatumbu; matabwa amtengo wa mkesha; ");
INSERT INTO nya_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","mafuta anyale a olivi, zonunkhiritsa mafuta odzozera ndi zopangira lubani wonunkhira; ");
INSERT INTO nya_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","miyala yokongola ya mtundu wa onikisi ndi ina yabwino yoyika pa efodi ndi pa chovala cha pachifuwa. ");
INSERT INTO nya_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Iwo andipangire malo wopatulika, ndipo Ine ndidzakhala pakati pawo. ");
INSERT INTO nya_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Umange chihema ndiponso ziwiya zamʼkatimo monga momwe Ine ndidzakuonetsere. ");
INSERT INTO nya_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Tsono apange bokosi lamatabwa amtengo wa mkesha, ndipo kutalika kwake kukhale masentimita 114, mulifupi mwake masentimita 69, msinkhu wake masentimita 69. ");
INSERT INTO nya_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Bokosilo ulikute ndi golide wabwino kwambiri, mʼkati mwake ndi kunja komwe, ndipo upange mkombero wagolide kuzungulira bokosilo. ");
INSERT INTO nya_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Upange mphete zinayi zagolide ndipo uzimangirire ku miyendo yake inayi ya bokosilo, mbali ina ziwiri ndi mbali inanso ziwiri. ");
INSERT INTO nya_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Kenaka upange mizati yamtengo wa mkesha ndi kuzikuta ndi golide. ");
INSERT INTO nya_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ndipo ulowetse nsichizo mʼmphete zija za mbali zonse ziwiri za bokosilo kuti azinyamulira. ");
INSERT INTO nya_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Nsichizo zizikhala mʼmphete za bokosilo nthawi zonse, zisamachotsedwe. ");
INSERT INTO nya_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ndipo udzayike mʼbokosilo miyala iwiri yolembedwapo malamulo imene Ine ndidzakupatse. ");
INSERT INTO nya_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Upange chivundikiro cha bokosilo cha golide wabwino kwambiri, kutalika kwake masentimita 114, mulifupi mwake masentimita 69. ");
INSERT INTO nya_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ndipo upange Akerubi awiri agolide osula ndi nyundo, uwayike mbali ziwiri za chivundikirocho, ");
INSERT INTO nya_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","kerubi mmodzi mbali ina ndi wina mbali inayo. Akerubiwa uwapangire limodzi ndi chivundikirocho mʼmapeto mwa mbali ziwirizo. ");
INSERT INTO nya_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Mapiko a Akerubiwo adzatambasukire pamwamba pa chivundikiro cha bokosilo kuti achiphimbe. Akerubiwo adzakhale choyangʼanana, aliyense kuyangʼana chivundikirocho. ");
INSERT INTO nya_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Uyike chivundikirocho pamwamba pa bokosi ndipo mʼbokosilo uyikemo miyala ya malamulo, imene ndidzakupatse. ");
INSERT INTO nya_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ndizidzakumana nawe pamenepo, pamwamba pa chivundikiro cha bokosilo, pakati pa Akerubi awiriwo, ndikumadzakupatsa malamulo onse okhudzana ndi Aisraeli. ");
INSERT INTO nya_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Upange tebulo la matabwa amtengo wa mkesha, mulitali mwake masentimita 91, mulifupi mwake masentimita 46, msinkhu wake masentimita 69. ");
INSERT INTO nya_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Tebulolo ulikute ndi golide wabwino kwambiri ndipo upange mkombero wagolide mʼmbali mwake. ");
INSERT INTO nya_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Upange feremu yozungulira tebulo, mulifupi mwake ngati chikhatho cha dzanja, ndipo uyike mkombero wagolide kuzungulira feremuyo. ");
INSERT INTO nya_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Upange mphete zinayi zagolide, ndipo uzilumikize ku ngodya zake zinayi, kumene kuli miyendo yake inayi. ");
INSERT INTO nya_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Mphetezo uziyike kufupi ndi feremu kuti azikolowekamo nsichi zonyamulira tebuloyo. ");
INSERT INTO nya_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Upange nsichi zamtengo wa mkesha ndi kuzikuta ndi golide kuti azinyamulira tebulolo. ");
INSERT INTO nya_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Upange mbale ndi zipande zagolide wabwino, pamodzinso ndi mitsuko ndi mabeseni zogwiritsa ntchito popereka nsembe. ");
INSERT INTO nya_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Pa tebulopo uyikepo buledi woperekedwa kosalekeza, kuti azikhala pamaso panga nthawi zonse. ");
INSERT INTO nya_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Upange choyikapo nyale chagolide wabwino kwambiri. Tsinde lake ndi mphanda zake zikhale zosulidwa ndi nyundo. Zikho zake zokhala ndi mphukira ndi maluwa ake zipangidwire kumodzi. ");
INSERT INTO nya_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Mʼmbali mwake mukhale mphanda zisanu ndi imodzi, zitatu mbali iliyonse. ");
INSERT INTO nya_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Zikho zitatu zokhala ngati za maluwa amtowo, mphukira ndi duwa zikhale pa mphanda yoyamba. Pa mphanda yachiwiri pakhalenso zikho zitatu zokhala ngati za maluwa amtowo, mphukira ndi duwa. Ndipo mphanda zonse zisanu ndi imodzi zikhale chimodzimodzi ndipo zituluke mʼchoyikapo nyalecho. ");
INSERT INTO nya_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Pa choyikapo nyalecho pakhale zikho zinayi zopangidwa ngati maluwa amtowo ali ndi mphukira ndi maluwa. ");
INSERT INTO nya_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Mphukira yoyamba ikhale mʼmunsi mwa nthambi ziwiri zoyamba za pa choyikapo nyale. Mphukira yachiwiri ikhale mʼmunsi mwa nthambi ziwiri zinazo. Ndipo mphukira yachitatu ikhale mʼmunsi mwa nthambi zina ziwirinso. Zonse pamodzi zikhale nthambi zisanu ndi imodzi ");
INSERT INTO nya_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Mphukira ndi nthambi zonse zisulidwe kumodzi ndi choyikapo nyalecho ndi golide wabwino kwambiri. ");
INSERT INTO nya_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Ndipo upange nyale zisanu ndi ziwiri ndi kuziyika pa choyikapo nyalecho kuti ziwunikire kutsogolo. ");
INSERT INTO nya_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Mbaniro ndi zowolera phulusa zikhale zagolide wabwino kwambiri. ");
INSERT INTO nya_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Choyikapo nyale ndi zipangizo zonse zipangidwe ndi golide wabwino kwambiri wolemera makilogalamu 34. ");
INSERT INTO nya_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Uwonetsetse kuti wapanga zonse monga momwe ndikukuonetsera pa phiri pano.” ");
INSERT INTO nya_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Panga chihema pogwiritsa ntchito nsalu khumi zofewa, zosalala ndi zolukidwa bwino, zobiriwira, zapepo ndi zofiira. Ndipo anthu aluso apete pa nsaluzo Akerubi. ");
INSERT INTO nya_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Nsalu zonse zikhale zofanana. Mulitali mwake zikhale mamita khumi ndi atatu, mulifupi mamita awiri. ");
INSERT INTO nya_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Ulumikize nsalu zisanu kuti ikhale nsalu imodzi. Uchite chimodzimodzi ndi nsalu zisanu zinazo. ");
INSERT INTO nya_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Panga zokolowekamo za nsalu yobiriwira mʼmphepete mwa nsalu imodzi yotsiriza ya mbali ina. Uchitenso chimodzimodzi ndi nsalu yotsiriza ya mbali inayo. ");
INSERT INTO nya_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Upange zokolowekamo 50 pa nsalu yoyamba ndi zokolowekamo makumi asanu zinanso pa nsalu inayo. Upange motero kuti zokolowekamozo ziziyangʼanana. ");
INSERT INTO nya_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Kenaka upange ngowe zagolide makumi asanu zolumikizira nsalu ziwirizo kuti zipange chihema chimodzi. ");
INSERT INTO nya_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Upange nsalu za ubweya wambuzi zophimba pamwamba pa chihemacho. Nsalu zonse pamodzi zikhale khumi ndi imodzi. ");
INSERT INTO nya_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Nsalu zonse khumi ndi imodzi zikhale zofanana. Mulitali mwake mukhale mamita khumi ndi anayi ndipo mulifupi mwake mukhale mamita awiri. ");
INSERT INTO nya_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ulumikize nsalu zisanu kuti ikhale nsalu imodzi ndipo zina zisanu ndi imodzi uzilumikizenso kuti ikhale nsalu imodzinso. Nsalu yachisanu ndi chimodzi imene ili kutsogolo kwa tenti uyipinde pawiri. ");
INSERT INTO nya_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Upange zokolowekamo 50 mʼmphepete mwa nsalu imodzi yotsirizira ya nsalu yoyamba yolumikiza ija. Upangenso zokolowekamo zina 50 mʼmphepete mwa nsalu yotsirizira ya nsalu inanso yolumikiza ija. ");
INSERT INTO nya_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Kenaka upange ngowe 50 zamkuwa ndipo uzilowetse mu zokolowekazo. Ndiye uphatikize nsalu ziwirizo kuti tentiyo ikhale imodzi. ");
INSERT INTO nya_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Theka lotsalira la nsaluyo lidzalendewera kumbuyo kwa chihemacho. ");
INSERT INTO nya_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Nsalu yotsalira ya masentimita 46 mulitali mwake mʼmbali zonse ziwiri idzalendewere kuphimba mbali ziwirizo. ");
INSERT INTO nya_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Upange chikopa cha nkhosa zazimuna cha utoto wofiira chophimbira tentiyo ndipo pamwamba pake upangireponso chophimbira china cha zikopa za akatumbu. ");
INSERT INTO nya_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Upange maferemu amatabwa amtengo wa mkesha oyimikira chihemacho. ");
INSERT INTO nya_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Feremu iliyonse ikhale yotalika mamita anayi ndipo mulifupi mwake mukhale masentimita 69. ");
INSERT INTO nya_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Thabwa lililonse likhale ndi zolumikizira ziwiri. Upange maferemu onse a chihemacho ndi matabwa otere. ");
INSERT INTO nya_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Upange maferemu makumi awiri a mbali yakummwera kwa chihemacho. ");
INSERT INTO nya_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Ndipo upange matsinde 40 asiliva ndipo uwayike pansi pa maferemuwo. Pansi pa feremu iliyonse pakhale matsinde awiri ogwiriziza zolumikizira ziwiri zija. ");
INSERT INTO nya_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ndipo mbali yakumpoto ya chihemacho upangenso maferemu makumi awiri. ");
INSERT INTO nya_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Upangenso matsinde 40 asiliva, awiri pansi pa feremu iliyonse. ");
INSERT INTO nya_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Upange maferemu asanu ndi imodzi a kumbuyo kwa tenti, kumbali yakumadzulo. ");
INSERT INTO nya_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Ndipo upangenso maferemu awiri a pa ngodya yakumbuyo kwenikweni kwa tenti. ");
INSERT INTO nya_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Pa ngodya ziwirizi pakhale maferemu awiri, kuyambira pansi mpaka pamwamba ndipo alumikizidwe pa ngowe imodzi. Maferemu onse akhale ofanana. ");
INSERT INTO nya_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Choncho pakhale maferemu asanu ndi atatu ndiponso matsinde 16 asiliva, awiri akhale pansi pa feremu iliyonse. ");
INSERT INTO nya_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Upange mitanda ya matabwa amtengo wa mkesha: mitanda isanu ikhale ya maferemu a mbali imodzi ya chihema, ");
INSERT INTO nya_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","mitanda isanu inanso ikhale ya maferemu a mbali inayo. Pakhalenso mitanda ina isanu ya mbali yakumadzulo, kumapeto kwenikweni kwa chihema. ");
INSERT INTO nya_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Mtanda wapakati pa maferemuwo uchokere pa maferemu a mbali ina mpaka mbali inanso. ");
INSERT INTO nya_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Maferemuwo uwakute ndi golide ndiponso upange mphete zagolide zogwiriziza mitandayo. Ndipo mitandayonso uyikute ndi golide. ");
INSERT INTO nya_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Upange chihema mofanana ndi momwe ndinakuonetsera pa phiri paja. ");
INSERT INTO nya_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Upange nsalu yokhala ndi mtundu wamtambo, wapepo ndi ofiira ndipo nsaluyo ikhale yolukidwa bwino, yofewa ndi yosalala. Ndipo anthu aluso apetepo zithunzi za Akerubi. ");
INSERT INTO nya_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Nsaluyo uyikoloweke pa nsanamira zinayi zamtengo wa mkesha zokutidwa ndi golide zomwe zili ndi ngowe zagolide, zomwe zayima pa matsinde asiliva anayi. ");
INSERT INTO nya_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ukoloweke kataniyo ku ngowe ndipo uyike Bokosi la Chipangano mʼkatimo. Kataniyo idzalekanitse malo wopatulika ndi malo wopatulika kwambiri. ");
INSERT INTO nya_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Uyike chivundikiro pa bokosi laumboni ku malo wopatulika kwambiri. ");
INSERT INTO nya_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Uyike tebulo kunja kwa katani yotchinga cha kumpoto kwa chihema ndipo uyike choyikapo nyale chija kummwera moyangʼanana ndi tebulolo. ");
INSERT INTO nya_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Pa chipata cholowera mu chihema, uyikepo nsalu yamtundu wamtambo, wapepo ndi ofiira, yomwe ndi yofewa ndi yosalala, yopetedwa bwino ndi amisiri aluso. ");
INSERT INTO nya_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Upange ngowe zagolide za nsaluyo ndi nsanamira zisanu zamtengo wa mkesha ndipo uzikute ndi golide. Upangenso matsinde asanu amkuwa a nsanamirazo.” ");
INSERT INTO nya_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Upange guwa lansembe lamatabwa amtengo wa mkesha. Likhale lofanana mbali zonse, msinkhu wake masentimita 137, mulitali mwake masentimita 229, mulifupi mwake masentimita 229. ");
INSERT INTO nya_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Upange nyanga imodziimodzi pa ngodya zake zinayizo kuti nyangazo ndi guwalo zikhale chinthu chimodzi, ndipo ulikute guwalo ndi mkuwa. ");
INSERT INTO nya_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Upange ziwiya zamkuwa izi zogwirira ntchito pa guwalo: miphika yochotsera phulusa, mafosholo, mabeseni owazira magazi, ngowe zokowera nyama ndi zosonkhezera moto. ");
INSERT INTO nya_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Upange sefa yachitsulo chamkuwa ndipo mʼngodya zake zinayizo upangiremo mphete zamkuwa. ");
INSERT INTO nya_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Uyike sefayo mmunsi mwa khoma la guwa lansembelo, ndipo ilekezere pakati pa guwa lansembelo. ");
INSERT INTO nya_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Upange nsichi zamtengo wa mkesha ndipo uzikutire ndi mkuwa. ");
INSERT INTO nya_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Pamene mukunyamula guwalo, muzilowetsa nsichizo mʼmphetemo mbali zonse ziwiri za guwalo. ");
INSERT INTO nya_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Guwalo likhale lamatabwa ndi logoba mʼkati mwake. Ulipange monga momwe ndinakuonetsera pa phiri paja. ");
INSERT INTO nya_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Upange bwalo la chihema. Mbali yakummwera ikhale yotalika mamita 46 ndipo ikhale ndi nsalu yotchinga yofewa yosalala yolukidwa bwino. ");
INSERT INTO nya_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Upangenso mizati makumi awiri, matsinde makumi awiri amkuwa, ndi ngowe zasiliva ndi zingwe za mizatiyo. ");
INSERT INTO nya_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Mbali yakumpoto ikhalenso yotalika mamita 46 ndipo ikhale ndi nsalu yotchinga. Pakhalenso mizati makumi awiri, matsinde amkuwa makumi awiri, ngowe zasiliva ndi zingwe za mizatiyo. ");
INSERT INTO nya_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Mbali yakumadzulo ya bwalolo ikhale yotalika mamita 23 ndipo ikhale ndi nsalu yotchinga, nsichi khumi ndi matsinde khumi. ");
INSERT INTO nya_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Mbali yakummawa, kotulukira dzuwa, kutalika kwa bwalo kukhale mamita 23. ");
INSERT INTO nya_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Mbali imodzi yachipata kukhale nsalu yotchinga yotalika mamita asanu ndi awiri, mizati itatu ndi matsinde atatu. ");
INSERT INTO nya_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Ndipo ku mbali inayo kukhale nsalu yotchinga ya mamita asanu ndi awiri pamodzi ndi mizati itatu ndi matsinde atatu. ");
INSERT INTO nya_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Pa chipata cha bwalolo pakhale nsalu yotchinga yamtundu wa mtambo, yapepo ndi yofiira ndiponso yofewa yosalala. Nsaluyo ikhale yotalika mamita asanu ndi anayi, yopangidwa ndi anthu aluso. Pakhalenso mizati yake inayi ndi matsinde akenso anayi. ");
INSERT INTO nya_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Mizati yonse yozungulira bwalolo ilumikizidwe ndi zingwe zasiliva. Ngowe zake zikhale zasiliva, koma matsinde ake akhale amkuwa. ");
INSERT INTO nya_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Kutalika kwa bwalolo kukhale mamita 46, mulifupi mwake mamita 23, msinkhu wake masentimita 230. Nsalu ya katani ikhale yofewa ndi yosalala bwino. Matsinde ake akhale amkuwa. ");
INSERT INTO nya_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Zipangizo zonse zogwiritsa ntchito zosiyanasiyana pa chihemacho, zikhomo za chihema ndi zabwalolo zikhale zamkuwa. ");
INSERT INTO nya_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Lamula Aisraeli kuti akupatse mafuta anyale a olivi wabwino kwambiri kuti nyalezo ziziyaka nthawi zonse. ");
INSERT INTO nya_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Mʼchihema cha msonkhano, koma kunja kwa nsalu yotchinga Bokosi la Chipangano, Aaroni ndi ana ake azionetsetsa kuti nyale ikukhala chiyakire pamaso pa Yehova kuyambira madzulo mpaka mmawa. Limeneli ndi lamulo lamuyaya pakati pa Aisraeli pa mibado yonse.” ");
INSERT INTO nya_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Aaroni mʼbale wako ndi ana ake aamuna, Nadabu, Abihu, Eliezara ndi Itamara uwapatule pakati pa Aisraeli. Abwere kwa iwe kuti anditumikire monga ansembe. ");
INSERT INTO nya_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Umusokere mʼbale wako, Aaroni, zovala zopatulika kuti azioneka mwaulemerero ndi molemekezeka. ");
INSERT INTO nya_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Uwawuze anthu onse aluso amene Ine ndawapatsa nzeru pa ntchito yosoka kuti apange zovala za Aaroni za pa mwambo womupatula, kuti iye anditumikire monga wansembe. ");
INSERT INTO nya_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Zovala zoti apange ndi izi: chovala chapachifuwa, efodi, mkanjo, mwinjiro wolukidwa, nduwira ndi lamba. Apangire mʼbale wako Aaroni ndi ana ake aamuna zovala zopatulikazi kuti iwo anditumikire monga ansembe. ");
INSERT INTO nya_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Iwo agwiritse ntchito golide, nsalu yamtundu wa mtambo, yapepo, yofiira ndi yosalala yofewa. ");
INSERT INTO nya_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Apange efodi pogwiritsa ntchito golide, nsalu yamtundu wa mtambo, yapepo ndi yofiira yolukidwa mwaluso. ");
INSERT INTO nya_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Efodiyo ikhale ndi timalamba tiwiri ta pa mapewa tosokerera ku msonga zake ziwiri kuti azitha kumanga. ");
INSERT INTO nya_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Lamba womangira efodi akhale wolukidwa mwaluso ngati efodiyo. Akhale wopangidwa ndi golide, nsalu yamtundu wa mtambo, yapepo, yofiira, yofewa yosalala. ");
INSERT INTO nya_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Utenge miyala iwiri ya onikisi ndipo uzokotepo mayina a ana a Israeli. ");
INSERT INTO nya_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Mayina asanu ndi limodzi akhale pa mwala umodzi, ndipo mayina asanu ndi limodzi pa mwala winawo motsata mabadwidwe awo. ");
INSERT INTO nya_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Mayina a ana a Israeli uwazokote pa miyala iwiriyo, monga momwe amachitira mmisiri wozokota miyala. Ndipo uyike miyalayo mu zoyikamo zake zagolide. ");
INSERT INTO nya_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Umangirire miyala iwiriyi pa tinsalu ta mʼmapewa ta efodi tija ngati miyala ya chikumbutso cha ana a Israeli. Aaroni azinyamula mayinawo mʼmapewa ake kuti akhale chikumbutso pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Upange zoyikamo za maluwa agolide, ");
INSERT INTO nya_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ndiponso maunyolo awiri a golide wabwino kwambiri, wopetedwa ngati zingwe ndipo uwalumikize ku zoyikamozo. ");
INSERT INTO nya_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Upange chovala chapachifuwa chogwiritsa ntchito poweruza mlandu ndipo uchipange mwaluso kwambiri. Uchipange ngati efodi pogwiritsa ntchito golide, nsalu yamtundu wa mtambo, yapepo, yofiira, yofewa yosalala ndi yolukidwa bwino. ");
INSERT INTO nya_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kutalika kwake kukhale kofanana mbali zonse, mulitali masentimita 23, mulifupi masentimita 23, ndipo chikhale chopinda pawiri. ");
INSERT INTO nya_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Uyikepo mizere inayi ya miyala yokongola kwambiri. Mzere woyamba ukhale ndi miyala ya rubi, topazi ndi berili. ");
INSERT INTO nya_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Mzere wachiwiri pakhale miyala ya emeradi, safiro ndi dayimondi; ");
INSERT INTO nya_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","mzere wachitatu pakhale miyala ya opera, agate ndi ametisiti. ");
INSERT INTO nya_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Mzere wachinayi pakhale miyala ya topazi, onikisi ndi yasipa. Miyalayi uyiike mu zoyikamo zagolide. ");
INSERT INTO nya_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Miyalayo ikhalepo khumi ndi iwiri, uliwonse kuyimira dzina limodzi la ana a Israeli. Mwala uliwonse uzokotedwe ngati chidindo dzina limodzi la mafuko khumi ndi awiri a Israeli. ");
INSERT INTO nya_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Upange timaunyolo tagolide wabwino kwambiri ta pa chovala chapachifuwa, topota ngati chingwe. ");
INSERT INTO nya_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Upangenso mphete ziwiri zagolide ndipo uzimangirire pa ngodya ziwiri za pa chovala chapachifuwa. ");
INSERT INTO nya_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Umangirire timaunyolo tiwiri tagolide tija pa mphete za pa ngodya pa chovala chapachifuwacho. ");
INSERT INTO nya_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ndipo mbali ina ya timaunyoloto umangirire pa zoyikapo zake ziwiri zija ndi kulumikiza pa tinsalu takutsogolo kwa mapewa a efodi. ");
INSERT INTO nya_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Upangenso mphete ziwiri zagolide, ndipo uzilumikize ku ngodya ziwiri zamʼmunsi mwa chovala chapachifuwa, champhepete mwake, mʼkati pafupi ndi efodi ija. ");
INSERT INTO nya_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Upangenso mphete zina ziwiri zagolide ndipo uzilumikize kumunsi kwa tinsalu takutsogolo kwa efodi, pafupi ndi msoko, pamwamba pangʼono pa lamba wamʼchiwuno wa efodi. ");
INSERT INTO nya_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Tsono umangirire mphete za pa chovala chapachifuwa zija ku mphete za efodi ndi chingwe chamtundu wa mtambo, kulumikiza lamba ndi chovala chapachifuwacho kuti chovala chapachifuwacho chisalekane ndi efodi. ");
INSERT INTO nya_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Pamene Aaroni akulowa kumalo opatulika azivala chovala chapachifuwa cha zoweruzira chija chimene chalembedwa mayina a ana a Israeli kuti Yehova awakumbukire nthawi zonse. ");
INSERT INTO nya_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ndiponso uyike Urimu ndi Tumimu mu chovala chapachifuwa cha zoweruziracho, kuti zikhale pamtima pa Aaroni. Choncho Aaroniyo adzakhala akutenga nthawi zonse zida zomuthandizira kuweruza ana a Israeli pamene adzafika pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Uyipangire efodiyo mkanjo wamtundu wa mtambo. ");
INSERT INTO nya_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Mkanjowo ukhala ndi malo opisapo mutu pakati pakepo. Pa chibowopo pakhale chibandi chosokedwa mochita ngati kuluka monga muja akhalira malaya kuti chibowocho chilimbe, chisangʼambike. ");
INSERT INTO nya_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Pa mpendero wamʼmunsi wa mkanjowo, upange mphonje zokhala ngati makangadza za nsalu yamtundu wa mtambo, yapepo ndi yofiira zokhala ndi maberu agolide pakati pake. ");
INSERT INTO nya_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Choncho pazikhala mphonje imodzi kenaka belu limodzi, kuzungulira mpendero wa mkanjo wonse. ");
INSERT INTO nya_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaroni azivala mkanjowo pamene akutumikira ngati wansembe. Kulira kwa maberu kuzimveka pamene akulowa mʼmalo opatulika pamaso pa Yehova ndiponso pamene akutuluka, kuti asafe. ");
INSERT INTO nya_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Upange duwa lagolide wabwino kwambiri kukhala ngati chidindo ndipo uzokotepo mawu akuti, Cohoperekedwa kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ulimange ndi chingwe cha nsalu yamtundu wa mtambo pa nduwira ya Aaroni, ndipo duwalo likhale kutsogolo kwa nduwirayo. ");
INSERT INTO nya_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Lidzakhala pa mphumi ya Aaroni, motero iye adzasenza cholakwa chilichonse cha pa zopereka zilizonse zimene Aisraeli amazipatulira Yehova. Aaroni azivala chikwangwanichi pa mphumi pake nthawi zonse kuti Yehova alandire zopereka za anthu ake. ");
INSERT INTO nya_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Uluke mwinjiro wa nsalu yofewa yosalala ndiponso upange nduwira ya nsalu yofewa yosalala. Lamba wake akhale wolukidwa bwino ndi munthu waluso. ");
INSERT INTO nya_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Upangirenso ana a Aaroni mwinjiro, malamba ndi nduwira kuti azioneka mwaulemu ndi molemekezeka. ");
INSERT INTO nya_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Zovala zimenezi umuveke Aaroni, mʼbale wako ndi ana ake. Kenaka uwadzoze, uwapatse udindo ndi kuwapatula kuti anditumikire ngati ansembe anga. ");
INSERT INTO nya_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Uwapangire akabudula a nsalu yofewa oyambira mʼchiwuno kulekeza mʼntchafu kuti asamaonetse maliseche. ");
INSERT INTO nya_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaroni ndi ana ake ayenera kuvala akabudulawo pamene akulowa mu tenti ya msonkhano kapena pamene akupita ku guwa lansembe kukatumikira malo oyera kuopa kuti angachimwe ndi kufa. “Ili likhale lamulo la nthawi zonse kwa Aaroni ndi zidzukulu zake.” ");
INSERT INTO nya_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Pofuna kumupatula Aaroni ndi ana ake kuti akhale ansembe onditumikira Ine, uchite izi: Utenge ngʼombe yayingʼono yayimuna ndi nkhosa ziwiri zazimuna zopanda chilema. ");
INSERT INTO nya_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Utengenso buledi wopanda yisiti, makeke wopanda yisiti wopakidwa mafuta. Zonsezi uzipange ndi ufa wosalala wa tirigu. ");
INSERT INTO nya_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Uziyike mʼdengu ndipo ubwere nazo kwa Ine pamodzi ndi ngʼombe yayimuna ija ndi nkhosa ziwiri zazimuna zija. ");
INSERT INTO nya_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Kenaka ubwere naye Aaroni ndi ana ake pa khomo la tenti ya msonkhano ndipo uwasambitse ndi madzi. ");
INSERT INTO nya_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Tenga zovala ndipo umuveke Aaroni mwinjiro, mkanjo wa efodi, efodiyo ndi chovala chapachifuwa. Umumange mʼchiwuno lamba wa efodi wolukidwa mwaluso uja. ");
INSERT INTO nya_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Umuveke nduwira kumutu, ndiponso uyike chizindikiro chopatulika chija pa nduwirayo. ");
INSERT INTO nya_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Utenge mafuta wodzozera ndipo uwatsanulire pamutu pake kumudzoza. ");
INSERT INTO nya_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Ubwere ndi ana ake aamuna ndipo uwavekenso minjiro ");
INSERT INTO nya_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ndi nduwira. Kenaka umange malamba Aaroniyo pamodzi ndi ana ake ndi kuwaveka nduwira. Motero unsembe udzakhala wawo malingana ndi lamulo ili losatha. “Umu ndi mmene udzadzozere Aaroni ndi ana ake aamuna. ");
INSERT INTO nya_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Ubwere ndi ngʼombe yayimuna pa khomo la tenti ya msonkhano ndipo Aaroni ndi ana ake asanjike manja awo pamutu pake. ");
INSERT INTO nya_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Uphe ngʼombeyo pamaso pa Yehova pa khomo la tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Utenge magazi ena angʼombeyo ndi kupaka ndi chala chako pa nyanga zaguwa lansembe ndipo magazi otsalawo uwakhutulire pa tsinde laguwalo. ");
INSERT INTO nya_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Kenaka utenge mafuta onse okuta matumbo, mafuta ophimba chiwindi ndiponso impsyo zonse ziwiri pamodzi ndi mafuta ake. Zonsezi uzitenthe pa guwapo. ");
INSERT INTO nya_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Koma nyama yangʼombeyo, chikopa chake ndi matumbo ake uziwotche kunja kwa msasa. Iyi ndi nsembe yopepesera machimo. ");
INSERT INTO nya_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Utenge nkhosa yayimuna imodzi ndipo Aaroni ndi ana ake aamuna asanjike manja awo pamutu pake. ");
INSERT INTO nya_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Uyiphe ndipo utenge magazi ake ndi kuwaza mbali zonse zaguwalo. ");
INSERT INTO nya_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Uyidule nkhosayo nthulinthuli, kutsuka matumbo ake ndi miyendo yake. Ukatero, pamodzi ndi mutu wake, uziyike pamwamba pa nthulizo. ");
INSERT INTO nya_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ndipo uwotche nkhosa yonseyo pa guwa lansembe. Iyi ndi nsembe yopsereza ya kwa Yehova. Ili ndi fungo lokoma, loperekedwa pa moto kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Utenge nkhosa yayimuna ina ndipo Aaroni ndi ana ake aamuna asanjike manja awo pamutu pake. ");
INSERT INTO nya_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Uyiphe ndipo utenge magazi ake ena ndi kupaka ndewere za makutu a kudzanja lamanja la Aaroni ndi ana ake aamuna. Upakenso pa zala zawo zazikulu za kudzanja lawo lamanja, ndi zala zazikulu za kuphazi lakudzanja lawo lamanja. Kenaka uwaze magazi otsalawo mbali zonse za guwalo. ");
INSERT INTO nya_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ndipo utenge magazi ena amene ali pa guwa lansembe komanso pa mafuta ena odzozera ndipo uwawaze pa Aaroni ndi zovala zake ndi ana ake ndi zovala zawo. Ndiye kuti iyeyo ndi ana ake aamuna adzakhala opatulika pamodzi ndi zovala zawo. ");
INSERT INTO nya_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Pa nkhosa yayimuna ija utengepo mafuta ake, mafuta a ku mchira wake, mafuta okuta matumbo, mafuta okuta chiwindi, impsyo zonse ziwiri ndi mafuta ake, ndiponso ntchafu yakumanja. Iyi ndi nkhosa ya mwambo wodzoza. ");
INSERT INTO nya_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Utengenso mʼdengu la buledi wopanda yisiti limene lili pamaso pa Yehova, buledi mmodzi, buledi wokhala ndi mafuta a olivi, ndi buledi wopyapyala mmodzi. ");
INSERT INTO nya_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Izi zonse uzipereke mʼmanja mwa Aaroni ndi ana ake, ndipo iwo aziweyule pamaso pa Yehova kuti zikhale nsembe yoweyula. ");
INSERT INTO nya_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Kenaka uzitenge mʼmanja mwawo ndipo uzipsereze pa guwa lansembe, pamwamba penipeni pamodzi ndi nsembe yopsereza kuti ipereke fungo lokoma kwa Yehova. Ichi ndiye chopereka chachakudya kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Kenaka utenge chidale cha nkhosa yayimuna imene inaperekedwa pamwambo wodzoza Aaroni, uchiweyule kuti chikhale nsembe yoweyula pamaso pa Yehova ndipo chidzakhala gawo lako. ");
INSERT INTO nya_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Uzipatule ziwalo zonse za nkhosa ya pa mwambo wodzoza Aaroni ndi ana ake. Chidale chimene unaweyula chija ndiponso ntchafu imene inaperekedwa ija. ");
INSERT INTO nya_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Nsembe izi ndi zimene Aisraeli azipereka kwa Aaroni ndi ana ake mwa zonse zimene azipereka nthawi zonse. Mwa zopereka za mtendere zimene ana a Aisraeli adzapereka kwa Yehova, zimenezi zikhale gawo lawo. ");
INSERT INTO nya_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Zovala zopatulika za Aaroni zidzakhala za ana ake aamuna iye atafa kuti adzavale podzozedwa ndi polandira udindo wawo. ");
INSERT INTO nya_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Mwana amene adzalowa mʼmalo mwake monga wansembe pamene adzabwerera kudzalowa mu tenti ya msonkhano kudzatumikira ku malo wopatulika, adzavala zovala zimenezi masiku asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Utenge nkhosa yayimuna ya pamwambo wodzoza ansembe ndipo uyiphike pamalo opatulika. ");
INSERT INTO nya_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaroni ndi ana ake adye nyama ya nkhosa yayimunayi pamodzi ndi buledi amene ali mʼdengu pa khomo la tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Adye zonse zimene anazipereka kwa Yehova pamwambo wopepesera machimo powadzoza ndi kuwapatula. Munthu wamba asadye chifukwa ndi zopatulika. ");
INSERT INTO nya_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ndipo ngati nyama ina ya nkhosa ya pamwambo wodzoza ansembe kapena buledi zatsala mpaka mmawa, muziwotche, asazidye chifukwa ndi zopatulika. ");
INSERT INTO nya_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Uchitire Aaroni ndi ana ake aamuna zonse zimene ndakulamulazi. Uchite mwambo wowapatula kukhala ansembe masiku asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Tsiku lililonse uzipereka ngʼombe yayimuna ngati nsembe yopepesera machimo kuti machimowo akhululukidwe. Ndiponso upatule guwalo popereka nsembe yopepesera ndi kulidzoza mafuta kuti likhale lopatulika. ");
INSERT INTO nya_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Pa masiku asanu ndi awiri uzipereka pa guwapo nsembe zoyeretsera guwalo, ukatero ndiye kuti uzilipatula. Ndipo guwa lansembelo lidzakhala loyera kwambiri, ndipo chilichonse chimene chidzakhudza guwalo chidzayeretsedwa. ");
INSERT INTO nya_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Tsiku ndi tsiku pa guwa lansembe uzipereka izi: Ana ankhosa a chaka chimodzi awiri. ");
INSERT INTO nya_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Mmawa muzipereka mwana wankhosa mmodzi ndipo winayo madzulo. ");
INSERT INTO nya_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Pamodzi ndi mwana wankhosa woyambayo, muzipereka kilogalamu imodzi ya ufa wosalala wosakaniza ndi lita imodzi ya mafuta a olivi pamodzi ndi lita imodzi ya vinyo ngati chopereka chachakumwa. ");
INSERT INTO nya_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Upereke mwana wankhosa winayo madzulo pamodzi ndi chopereka chachakudya monga poyamba paja ndi chopereka chachakumwa monga mmawa kuti ikhale fungo lokoma la chopereka chachakudya kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Zopereka zopsereza zimenezi ziziperekedwa nthawi zonse, pa mibado yonse. Muzidzazipereka pamaso pa Yehova pa khomo la tenti ya msonkhano. Pa guwa lansembe, Yehova adzakumana nanu ndi kuyankhula nanu. ");
INSERT INTO nya_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Pameneponso Ine ndidzakumana ndi Aisraeli, ndipo guwalo lidzakhala lopatulika chifukwa cha ulemerero wanga. ");
INSERT INTO nya_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Tsono Ine ndidzapatula tenti ya msonkhano ndi guwa lansembe. Ndidzapatulanso Aaroni pamodzi ndi ana ake kuti akhale ansembe anga onditumikira. ");
INSERT INTO nya_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ndidzakhala pakati pa Aisraeli ndikukhala Mulungu wawo. ");
INSERT INTO nya_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Adzadziwa kuti ine ndine Mulungu wawo amene ndinawatulutsa mʼdziko la Igupto kuti ndikhale pakati pawo. Ine ndine Yehova, Mulungu wawo.” ");
INSERT INTO nya_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Upange guwa lamatabwa amtengo wa mkesha lofukizirapo lubani. ");
INSERT INTO nya_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Likhale lofanana mbali zonse. Mulitali masentimita 46, mulifupi masentimita 46, ndipo msinkhu masentimita 91. Nyanga zake zipangidwe kumodzi ndi guwalo. ");
INSERT INTO nya_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ukute guwa lonse ndi golide wabwino kwambiri, pamwamba pake, mbali zonse zinayi, pamodzi ndi nyanga zake. Ndipo upange mkombero wagolide kuzungulira guwalo. ");
INSERT INTO nya_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Upange mphete ziwiri zagolide ndipo uzilumikize ku guwa mʼmunsi mwa mkombero, mphete ziwiri ku mbali zonse ziwiri zoyangʼanana. Mphetozo zizigwira nsichi zonyamulira guwalo. ");
INSERT INTO nya_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Upange mizati yamtengo wa mkesha ndipo uyikute ndi golide. ");
INSERT INTO nya_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Uyike guwalo patsogolo pa nsalu yotchinga Bokosi la Chipangano. Apa ndi pamene ndizidzakumana nawe. ");
INSERT INTO nya_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Aaroni ayenera kumafukiza lubani wonunkhira pa guwalo mmawa uliwonse. Pamene akukonza nyale zija afukizenso lubani. ");
INSERT INTO nya_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Aaroni ayenera kufukizanso lubani pamene ayatsa nyale madzulo kuti lubani akhale akuyaka nthawi zonse pamaso pa Yehova kwa mibado imene ikubwera. ");
INSERT INTO nya_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Pa guwapo usafukize lubani wachilendo kapena kuperekapo nsembe yopsereza kapena nsembe yaufa. Usathire pa guwapo ngakhale nsembe yachakumwa. ");
INSERT INTO nya_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aaroni azidzapereka nsembe yopepesera machimo pa nyanga za guwalo kamodzi pa chaka. Mwambowu uzidzachitika pogwiritsa ntchito magazi a nsembe yopepesera machimo, ndipo zizidzachitika mʼmibado yanu yonse. Choncho guwa lansembelo lidzakhala loyera ndi loperekedwa kwa Yehova.” ");
INSERT INTO nya_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Ndipo Yehova anati kwa Mose, ");
INSERT INTO nya_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Pamene ukuchita kalembera wa Aisraeli, munthu aliyense ayenera kupereka kwa Yehova chowombolera moyo wake pamene akuwerengedwa. Motero mliri sudzabwera pa iwo pamene ukuwawerenga. ");
INSERT INTO nya_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Izi ndi zimene aliyense wolembedwa mu kawundula ayenera kupereka: theka la sekeli, kutanthauza ndalama zolemera magalamu asanu ndi limodzi malingana ndi kawerengedwe ka ndalama za ku Nyumba ya Mulungu. Paja sekeli imodzi ikulingana ndi magera makumi awiri. Theka la sekeli chidzakhala chopereka cha kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Aliyense wolembedwa mu kawundula amene ali ndi zaka makumi awiri kapena kupitirira ayenera kupereka chopereka kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Anthu olemera asapereke koposa theka la sekeli ndipo osauka asapereke kuchepera theka la sekeli pamene mukupereka nsembe kwa Yehova yowombolera miyoyo yanu. ");
INSERT INTO nya_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ulandire ndalama zopepeserazo kuchokera kwa Aisraeli ndipo zigwiritsidwe ntchito ya ku tenti ya msonkhano. Zoperekazi zidzakhala chikumbutso cha Aisraeli pamaso pa Yehova, ndiponso zowombolera miyoyo yanu.” ");
INSERT INTO nya_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Ndipo Yehova anati kwa Mose, ");
INSERT INTO nya_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Upange beseni lamkuwa lokhala ndi miyendo yamkuwanso. Uliyike pakati pa tenti ya msonkhano ndi guwa lansembe ndipo uthiremo madzi. ");
INSERT INTO nya_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aaroni ndi ana ake azisamba mʼmanja ndi kutsuka mapazi awo ndi madzi amenewo. ");
INSERT INTO nya_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Pamene akulowa mu tenti ya msonkhano, iwo asambe madziwa kuti asafe. Ndiponso pamene akupita kukatumikira ku guwa lansembe ndi kupereka nsembe yopsereza kwa Yehova, ");
INSERT INTO nya_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","azisamba mʼmanja mwawo ndi kutsuka mapazi kuti asadzafe. Limeneli ndi lamulo limene Aaroni, pamodzi ndi ana ndi zidzukulu zake mʼtsogolomo ayenera kumadzalitsatira mpaka muyaya.” ");
INSERT INTO nya_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Ndipo Yehova anati kwa Mose, ");
INSERT INTO nya_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Utenge zonunkhira bwino kwambiri izi: makilogalamu asanu ndi limodzi a mure wamadzi, makilogalamu atatu a zonunkhira bwino za mtundu wa sinamoni, makilogalamu atatu a nzimbe yonunkhira bwino kwambiri, ");
INSERT INTO nya_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","makilogalamu asanu ndi limodzi a mkesha. Zonsezi zikhale malingana ndi muyeso wa ku Nyumba ya Mulungu. Pakhalenso malita anayi a mafuta a olivi. ");
INSERT INTO nya_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Ugwiritse ntchito zinthu zimenezi kupanga mafuta opatulika odzozera, mafuta onunkhira, apangidwe ndi mʼmisiri waluso lopanga zonunkhiritsa. Awa adzakhala mafuta opatulika odzozera. ");
INSERT INTO nya_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Tsono uwagwiritse ntchito podzoza tenti ya msonkhano, Bokosi la Chipangano, ");
INSERT INTO nya_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","tebulo, ndi ziwiya zake zonse, choyikapo nyale ndi zipangizo zake, guwa lofukizirapo lubani, ");
INSERT INTO nya_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","guwa lansembe yopsereza ndi ziwiya zake zonse, ndiponso beseni pamodzi ndi nsichi yake. ");
INSERT INTO nya_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Zonsezi uzipatule kuti zidzakhale zopatulika, ndipo chilichonse chimene chidzakhudza zimenezi chidzakhala chopatulika. ");
INSERT INTO nya_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Udzoze Aaroni ndi ana ake aamuna ndi kuwapatula kuti akhale ansembe onditumikira. ");
INSERT INTO nya_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Tsono awuze a Israeli kuti, mafuta wodzozera awa adzakhala wopatulika mpaka muyaya. ");
INSERT INTO nya_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Musadzadzozere munthu wamba mafuta amenewa, ndipo musadzapange mafuta wofanana ndi amenewa. Mafutawa ndi wopatulika ndipo akhale woyera kwa inu. ");
INSERT INTO nya_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Wina aliyense amene adzapanga mafuta wonunkhira wofanana nawo kapena kudzozera mafutawa munthu wamba osati wansembe ayenera kuchotsedwa pakati pa anthu anzake.” ");
INSERT INTO nya_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Kenaka Yehova anati kwa Mose, “Tenga muyeso wofanana wa zinthu zonunkhira izi: sitakate, onika, galibanumu pamodzi ndi lubani weniweni. ");
INSERT INTO nya_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Uziphatikize pamodzi zonsezi ndi kupanga lubani monga amachitira mmisiri wopanga zonunkhira. Athire mchere ndipo akhale woyera ndi wopatulika. ");
INSERT INTO nya_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Upere gawo lina mosalala kwambiri ndipo utapepo pangʼono ndi kuyika patsogolo pa Bokosi la Chipangano mu tenti ya msonkhano, kumene ine ndidzakumane nawe. Lubani ameneyu kwa inu adzakhala wopatulika kwambiri. ");
INSERT INTO nya_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Musapange lubani wanu potsatira njira iyi. Lubani yense wopangidwa mwa njira iyi akhale wopatulika, woperekedwa kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Aliyense amene adzapanga wofanana naye kuti asangalale ndi fungo lake ayenera kuchotsedwa pakati pa anthu anzake.” ");
INSERT INTO nya_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Ndipo Yehova anati kwa Mose, ");
INSERT INTO nya_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Taona, ndasankha Bezaleli mwana wa Uri, mwana wa Huri, wa fuko la Yuda. ");
INSERT INTO nya_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Ndipo ndamudzaza ndi Mzimu wa Mulungu kotero kuti ali ndi luso ndi nzeru zomvetsa zinthu ndipo akudziwa bwino ntchito zonse zamanja monga izi: ");
INSERT INTO nya_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Kulemba ndondomeko ya ntchito zaluso ndi kupanga zinthu zagolide, zasiliva ndi zamkuwa, ");
INSERT INTO nya_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","kusema ndi kuyika miyala yokongola, kukonza zinthu zamatabwa ndiponso kugwira ntchito ina iliyonse yamanja. ");
INSERT INTO nya_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ndasankhanso Oholiabu mwana wa Ahisamaki wa fuko la Dani. Ndiponso ndapereka nzeru kwa anthu aluso motero adzagwira ntchito zonse zimene ndakulamulira kuti zichitike monga izi: ");
INSERT INTO nya_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Kupanga tenti ya msonkhano, bokosi laumboni pamodzi ndi chophimbira chake, ndiponso zonse za mu tenti, ");
INSERT INTO nya_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","tebulo ndi zida zake, choyikapo nyale cha golide wabwino kwambiri ndi ziwiya zake zonse, guwa lofukizirapo lubani, ");
INSERT INTO nya_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","guwa lansembe yopsereza ndi ziwiya zake zonse, beseni ndi nsichi yake, ");
INSERT INTO nya_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ndiponso zovala zonse zolukidwa, zovala zopatulika za Aaroni wansembe pamodzi ndi za ana ake, zovala pamene akutumikira monga ansembe, ");
INSERT INTO nya_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ndiponso mafuta odzozera ndi lubani wonunkhira wa ku malo opatulika. Iwo azipanga monga momwe Ine ndinakulamulira.” ");
INSERT INTO nya_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Ndipo Yehova anati kwa Mose, ");
INSERT INTO nya_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Uza ana a Israeli kuti azisunga Masabata anga. Ichi chidzakhala chizindikiro pakati pa inu ndi Ine pamodzi ndi zidzukulu zanu mʼtsogolomo, chosonyeza kuti Ine ndine amene ndimakuyeretsani. ");
INSERT INTO nya_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“Motero muzisunga tsiku la Sabata chifukwa ndi loyera kwa inu. Aliyense amene adetsa tsiku la Sabata ayenera kuphedwa. Aliyense amene agwira ntchito iliyonse pa tsikuli ayenera kuchotsedwa pakati pa anthu anzake. ");
INSERT INTO nya_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Mugwire ntchito kwa masiku asanu ndi limodzi koma tsiku lachisanu ndi chiwiri ndi Sabata, lopuma, tsiku lopatulika la Yehova. Aliyense amene agwira ntchito iliyonse pa tsiku la Sabata ayenera kuphedwa. ");
INSERT INTO nya_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Aisraeli onse komanso zidzukulu zawo mʼtsogolo azidzasunga tsiku la Sabata ngati pangano lamuyaya. ");
INSERT INTO nya_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Tsiku la Sabata lidzakhala chizindikiro chamuyaya pakati pa Ine ndi Aisraeli chosonyeza kuti Yehova analenga za kumwamba ndi dziko lapansi kwa masiku asanu ndi limodzi ndi kuti pa tsiku lachisanu ndi chiwiri analeka kugwira ntchito napumula.” ");
INSERT INTO nya_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Yehova atamaliza kuyankhula ndi Mose pa phiri la Sinai, anamupatsa Mose miyala iwiri yaumboni, imene Mulungu analembapo ndi chala chake. ");
INSERT INTO nya_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Anthu ataona kuti Mose akuchedwa kutsika mʼphiri, anasonkhana kwa Aaroni ndipo anati, “Bwera utipangire milungu imene idzititsogolera. Kunena za Mose amene anatitulutsa mʼdziko la Igupto, sitikudziwa chimene chamuchitikira.” ");
INSERT INTO nya_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaroni anawayankha kuti, “Vulani ndolo zagolide zimene avala akazi anu, ana anu aamuna ndi aakazi ndipo muzibweretse kwa ine.” ");
INSERT INTO nya_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Kotero anthu onse anavula ndolo zagolide ndi kubwera nazo kwa Aaroni. ");
INSERT INTO nya_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Choncho Aaroni analandira golideyo ndipo anamuwumba ndi chikombole ndi kupanga fano la mwana wangʼombe. Kenaka anthu aja anati, “Inu Aisraeli, nayu mulungu wanu amene anakutulutsani mʼdziko la Igupto.” ");
INSERT INTO nya_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aaroni ataona izi, anamanga guwa lansembe patsogolo pa mwana wangʼombeyo ndipo analengeza kuti, “Mawa kudzakhala chikondwerero cha Yehova.” ");
INSERT INTO nya_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Kotero tsiku linalo anthu anadzuka mmamawa ndithu ndi kupereka nsembe zopsereza ndi nsembe zachiyanjano. Atatha kupereka nsembezo, anthuwo anakhala pansi nayamba kudya ndi kumwa. Kenaka anayimirira nayamba kuvina mwachilendo. ");
INSERT INTO nya_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Pamenepo Yehova anati kwa Mose, “Tsika msanga, chifukwa anthu ako amene unawatulutsa mʼdziko la Igupto aja adziyipitsa kwambiri. ");
INSERT INTO nya_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Iwo apatuka mwamsanga kuleka kutsatira zimene ndinawalamula. Ndiye adzipangira fano la mwana wangʼombe. Aligwadira ndi kuliperekera nsembe nʼkumati, ‘Inu Aisraeli, nayu mulungu wanu amene anakutulutsani mʼdziko la Igupto.’ ” ");
INSERT INTO nya_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Yehova anati kwa Mose, “Ine ndikuwadziwa anthu amenewa. Iwowa ndi ankhutukumve. ");
INSERT INTO nya_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Chifukwa chake undileke kuti mkwiyo wanga uyake pa iwo ndi kuwawononga. Ndipo Ine ndidzakusandutsa kuti ukhale mtundu waukulu.” ");
INSERT INTO nya_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Koma Mose anapempha chifundo cha Mulungu wake ndipo anati, “Chonde Yehova, chifukwa chiyani mwakwiyira anthu awa amene munawatulutsa mʼdziko la Igupto ndi mphamvu yanu yayikulu ndi dzanja lanu lamphamvu. ");
INSERT INTO nya_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Kodi mukufuna kuti Aigupto azinena kuti, ‘Munali ndi cholinga choyipa chofuna kuwaphera ku mapiri kuno ndi kuwawonongeratu pa dziko lapansi pamene munkawatulutsa ku Igupto kuja?’ Ayi, chonde mkwiyo wanu woyaka ngati motowu ubwezeni ndipo sinthani maganizo ofunira zoyipa anthu anu. ");
INSERT INTO nya_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Kumbukirani atumiki anu, Abrahamu, Isake, Israeli ndi zija munawalonjeza polumbira pa dzina lanu kuti, ‘Ine ndidzachulukitsa zidzukulu zanu ndipo zidzakhala zambiri ngati nyenyezi zakumwamba. Zidzukulu zanuzo ndidzazipatsa dziko lonseli limene ndinalonjeza. Dziko limeneli lidzakhala lawo nthawi zonse.’ ” ");
INSERT INTO nya_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Choncho Yehova analeka ndipo sanawachitire choyipa anthu ake monga anaopsezera. ");
INSERT INTO nya_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mose anatembenuka ndi kutsika phiri miyala iwiri ya pangano ili mʼmanja mwake. Miyalayi inalembedwa mbali zonse, kutsogolo ndi kumbuyo komwe. ");
INSERT INTO nya_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Miyalayi anayikonza ndi Mulungu. Malembawo analemba ndi Mulungu mozokota pa miyalapo. ");
INSERT INTO nya_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Pamene Yoswa anamva phokoso la anthu anati kwa Mose, “Ku msasa kuli phokoso la nkhondo.” ");
INSERT INTO nya_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mose anayankha kuti, “Phokoso limeneli sindikulimva ngati phokoso la opambana nkhondo, kapena kulira kwa ongonjetsedwa pa nkhondo. Koma ndikulimva ngati phokoso la anthu amene akuyimba.” ");
INSERT INTO nya_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Mose atayandikira msasa ndi kuona mwana wangʼombe ndiponso kuvina, anakwiya kwambiri ndipo anaponya pansi miyala imene inali mʼmanja mwake, ndi kuyiphwanya pa tsinde la phiri. ");
INSERT INTO nya_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ndipo iye anatenga mwana wangʼombe amene anthu anapanga uja ndi kumuwotcha pa moto ndi kumuperapera ndikukhala ngati fumbi. Kenaka anawaza fumbilo mʼmadzi ndi kuwamwetsa Aisraeli madziwo. ");
INSERT INTO nya_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Tsono Mose anafunsa Aaroni kuti, “Kodi anthu awa anakuchita chiyani kuti uwachimwitse koopsa chotere?” ");
INSERT INTO nya_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaroni anayankha kuti, “Musakwiye mbuye wanga. Inu mukudziwa kuti anthu awa ndi ovuta. ");
INSERT INTO nya_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Iwo anati kwa ine, ‘Bwera utipangire milungu imene idzititsogolera. Kunena za Mose amene anatitulutsa ife mʼdziko la Igupto, sitikudziwa chimene chamuchitikira.’ ");
INSERT INTO nya_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Choncho ine ndinawawuza kuti, ‘Aliyense amene ali ndi zokometsera zagolide azivule.’ Choncho iwo anandipatsa golide, ndipo ndinamuponya pa moto ndi kupanga fano la mwana wangʼombeyu.” ");
INSERT INTO nya_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mose anaona kuti anthuwo anali osokonezekadi chifukwa Aaroni anawalekerera mpaka kusanduka anthu osekedwa pakati pa adani awo. ");
INSERT INTO nya_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Choncho iye anayima pa chipata cholowera mu msasa ndipo anati, “Aliyense amene ali mbali ya Yehova abwere kwa ine.” Ndipo Alevi onse anapita mbali yake. ");
INSERT INTO nya_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ndipo iye anawawuza kuti, “Izi ndi zimene Yehova Mulungu wa Israeli akunena, ‘Pitani ku misasa konse, mulowe ku zipata zonse ndipo aliyense akaphe mʼbale wake, kapena mnzake kapena mnansi wake.’ ” ");
INSERT INTO nya_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Alevi anachita zomwe Mose analamula, ndipo tsiku limenelo panafa anthu pafupifupi 3,000. ");
INSERT INTO nya_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Kenaka Mose anati, “Lero mwadzipatula nokha kukhala ansembe otumikira Yehova. Mwachita izi popeza aliyense wa inu wapha mwana wake kapena mʼbale wake. Tsono lero Yehova wakudalitsani.” ");
INSERT INTO nya_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Mmawa mwake Mose anati kwa anthu onse, “Inu mwachita tchimo lalikulu. Koma tsopano ine ndipita ku phiri kwa Yehova mwina ndikatha kukupepeserani chifukwa cha tchimo lanu.” ");
INSERT INTO nya_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Kotero Mose anabwereranso kwa Yehova ndipo anati, “Aa! Anthu awa achita tchimo lalikulu! Iwo adzipangira milungu yagolide. ");
INSERT INTO nya_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Koma tsopano, chonde akhululukireni tchimo lawo. Ngati simutero, ndiye mundifute ine mʼbuku limene mwalemba.” ");
INSERT INTO nya_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Yehova anamuyankha Mose kuti, “Ndidzafuta mʼbuku aliyense amene wandichimwira. ");
INSERT INTO nya_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Tsopano pita ukawatsogolere anthu kumalo kumene ine ndinanena, ndipo mngelo wanga adzakutsogolerani. Komabe, nthawi yanga ikadzafika kuti ndiwalange, ndidzawalanga chifukwa cha tchimo lawo.” ");
INSERT INTO nya_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ndipo Yehova anawakantha anthuwo ndi mliri chifukwa anawumiriza Aaroni kuti awapangire fano la mwana wangʼombe. ");
INSERT INTO nya_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Ndipo Yehova anati, “Chokani pa malo ano, iwe ndi anthu amene unawatulutsa mʼdziko la Igupto. Pitani ku dziko limene ine ndinalonjeza ndi lumbiro kwa Abrahamu, Isake ndi Yakobo kuti, ‘Ine ndidzalipereka kwa zidzukulu zanu.’ ");
INSERT INTO nya_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ndipo ndidzatumiza mngelo patsogolo panu kuthamangitsa Akanaani, Aamori, Ahiti, Aperezi, Ahivi ndi Ayebusi. ");
INSERT INTO nya_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Pitani ku dziko loyenda mkaka ndi uchi. Koma ine sindidzapita nanu, chifukwa anthu inu ndinu nkhutukumve ndipo nditha kukuwonongani mʼnjiramo.” ");
INSERT INTO nya_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Anthu atamva mawu owopsawa, anayamba kulira ndipo palibe anavala zodzikometsera. ");
INSERT INTO nya_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Pakuti Yehova anali atanena kwa Mose kuti, “Awuze Aisraeli kuti, ‘Inu ndinu nkhutukumve.’ Ngati ine ndipita ndi inu kwa kanthawi, nditha kukuwonongani. Tsopano vulani zodzikometsera zanu ndipo ine ndidzaganiza choti ndichite nanu.” ");
INSERT INTO nya_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Kotero Aisraeli anavula zodzikometsera zawo pa phiri la Horebu. ");
INSERT INTO nya_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Tsono Mose ankatenga tenti ndi kukayimanga kunja kwa msasa chapatalipo, ndipo ankayitcha “tenti ya msonkhano.” Aliyense wofuna kukafunsa kanthu kwa Yehova amapita ku tenti ya msonkhano kunja kwa msasa. ");
INSERT INTO nya_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ndipo nthawi ina iliyonse imene Mose amapita ku tenti anthu onse amanyamuka ndi kuyimirira pa makomo amatenti awo, kumuyangʼana Mose mpaka atalowa mu tentimo. ");
INSERT INTO nya_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Mose akamalowa mu tenti, chipilala cha mtambo chimatsika ndi kukhala pa khomo pamene Yehova amayankhula ndi Mose. ");
INSERT INTO nya_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Nthawi zonse anthu akaona chipilala cha mtambo chitayima pa khomo la tentiyo amayimirira ndi kupembedza, aliyense ali pa khomo la tenti yake. ");
INSERT INTO nya_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Yehova amayankhula ndi Mose maso ndi maso ngati mmene munthu amayankhulira ndi bwenzi lake. Kenaka Mose amabwerera ku msasa koma womuthandiza wake, Yoswa, mwana wa Nuni samachoka pa tentiyo. ");
INSERT INTO nya_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mose anati kwa Yehova, “Inu mwakhala mukundiwuza kuti, ‘Tsogolera anthu awa,’ koma simunandiwuze amene mudzamutuma kuti apite pamodzi nane. Inu mwanena kuti, ‘Ndikukudziwa bwino kwambiri ndipo wapeza chisomo pamaso panga.’ ");
INSERT INTO nya_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ngati mwakondwera nane ndiphunzitseni njira zanu kuti ndikudziweni ndi kupitiriza kupeza chisomo pamaso panu. Kumbukirani kuti mtundu uwu ndi anthu anu.” ");
INSERT INTO nya_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Yehova anayankha kuti, “Ine ndemwe ndidzapita pamodzi ndi iwe, ndipo ndidzakupatsa mpumulo.” ");
INSERT INTO nya_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Kenaka Mose anati kwa Yehova, “Ngati inu simupita nafe, musatitumize kuti tipite, kutichotsa pano. ");
INSERT INTO nya_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Kodi wina adzadziwa bwanji kuti inu mwandikomera mtima pamodzi ndi anthu awa ngati simupita nafe? Kodi nʼchiyani chomwe chidzatisiyanitse pakati pa anthu onse amene ali pa dziko lapansi?” ");
INSERT INTO nya_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ndipo Yehova anati kwa Mose, “Ine ndidzachita zimene iwe wandipempha chifukwa Ine ndikukondwera nawe, ndikukudziwa bwino lomwe.” ");
INSERT INTO nya_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Kenaka Mose anati, “Tsopano ndionetseni ulemerero wanu.” ");
INSERT INTO nya_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ndipo Yehova anati, “Ine ndidzakuonetsa ulemerero wanga wonse ndipo ndidzatchula dzina langa lakuti Yehova pamaso pako. Ine ndidzachitira chifundo amene ndikufuna kumuchitira chifundo ndipo ndidzakomera mtima amene ndikufuna kumukomera mtima.” ");
INSERT INTO nya_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Iye anati, “Koma iwe sungaone nkhope yanga, pakuti palibe munthu amene amaona Ine nakhala ndi moyo.” ");
INSERT INTO nya_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ndipo Yehova anati, “Pali malo pafupi ndi ine pomwe ungathe kuyima pa thanthwe. ");
INSERT INTO nya_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Pamene ulemerero wanga udutsa, ndidzakuyika mʼphanga la thanthwe ndi kukuphimba ndi dzanja langa mpaka nditadutsa. ");
INSERT INTO nya_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Kenaka ine ndidzachotsa dzanja langa ndipo iwe udzaona msana wanga, koma nkhope yanga sidzaoneka.” ");
INSERT INTO nya_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Yehova anati kwa Mose, “Sema miyala iwiri yofanana ndi yoyamba ija, ndipo Ine ndidzalembapo mawu amene anali pa miyala yoyamba ija, imene unayiphwanya. ");
INSERT INTO nya_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ukonzeke mmamawa, ndipo ubwere ku Phiri la Sinai. Udzaonekera pamaso panga pamwamba pa phiri. ");
INSERT INTO nya_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Palibe amene abwere nawe kapena kuoneka pena paliponse pafupi ndi phiri. Ndipo ngakhale nkhosa kapena ngʼombe zisadye mʼmbali mwa phirilo.” ");
INSERT INTO nya_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Choncho Mose anasema miyala iwiri yofanana ndi yoyamba ija ndipo anapita ku Phiri la Sinai mmawa atanyamula miyala iwiri mʼmanja mwake monga momwe Yehova anamulamulira. ");
INSERT INTO nya_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ndipo Yehova anatsika mu mtambo ndi kuyima pamodzi ndi Mose ndi kulengeza dzina lake lakuti Yehova. ");
INSERT INTO nya_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ndipo Iye anadutsa kutsogolo kwa Mose akulengeza kuti, “Yehova, Yehova, Mulungu wachifundo ndi wokoma mtima, wosapsa mtima msanga, wodzaza ndi chikondi chosasinthika ndi kukhulupirika, ");
INSERT INTO nya_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","waonetsa chikondi chosasinthika kwa anthu miyandamiyanda, wokhululukira zoyipa, kuwukira, ndiponso tchimo, komatu salekerera ochimwa kuti asalangidwe. Iye amalanga ana ndi zidzukulu chifukwa cha machimo a makolo awo mpaka mʼbado wachitatu ndi wachinayi.” ");
INSERT INTO nya_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Pamenepo Mose anawerama pansi napembedza. ");
INSERT INTO nya_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Iye anati, “Chonde Ambuye, ngati ndapeza chisomo pamaso panu, lolani Ambuye kuti mupite nafe pamodzi. Ngakhale kuti anthuwa ndi nkhutukumve, khululukirani zoyipa ndi machimo athu, ndipo mutenge ife kukhala anthu anu.” ");
INSERT INTO nya_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Choncho Yehova anati: “Ine ndikuchita nanu pangano. Ndidzachita zodabwitsa pamaso pa anthu onse zimene sizinachitikenso ndi mtundu wina uliwonse wa anthu pa dziko lonse lapansi. Anthu amene mudzakhala pakati pawo adzaona kuopsa kwa ntchito imene Ine Yehova ndidzakuchitireni. ");
INSERT INTO nya_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Mverani zimene ndikukulamulirani lero. Ine ndidzathamangitsa pamaso panu Aamori, Akanaani, Ahiti, Aperezi, Ahivi, ndi Ayebusi. ");
INSERT INTO nya_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Musamale kuti musakachite mgwirizano ndi anthu amene akukhala mʼdziko limene mukupitalo, chifukwa mukadzatero iwo adzakhala ngati msampha pakati panu. ");
INSERT INTO nya_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Mukagumule maguwa awo ansembe, mukaswe miyala yawo yachipembedzo, ndipo mukadule mitengo yawo ya Asera. ");
INSERT INTO nya_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Musapembedze mulungu wina, pakuti Yehova amene dzina lake ndi Nsanje, ndi Mulungu wa nsanje. ");
INSERT INTO nya_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Musamale kuti musakachite mgwirizano ndi anthu amene akukhala mʼdziko limene mukupitalo, chifukwa iwo akamakachita zadama ndi milungu yawo ndi kupereka nsembe, adzakuyitanani ndipo inu mudzadya nsembe zawo. ");
INSERT INTO nya_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ndipo inu mukasankha ena mwa ana awo aakazi kukhala akazi a ana anu, akaziwo akakachita zadama ndi milungu yawo, akatsogolera ana anu aamuna kuchita chimodzimodzi. ");
INSERT INTO nya_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Musadzipangire milungu yosungunula. ");
INSERT INTO nya_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Muzichita chikondwerero cha buledi wopanda yisiti. Kwa masiku asanu ndi awiri muzidya buledi wopanda yisiti monga momwe ndinakulamulirani. Muzichita zimenezi pa nthawi yoyikika mwezi wa Abibu, pakuti mwezi umenewu inu munatuluka mʼdziko la Igupto. ");
INSERT INTO nya_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Mwana aliyense woyamba kubadwa ndi wanga, pamodzi ndi ziweto zoyamba kubadwa zazimuna kuchokera ku ngʼombe kapena nkhosa. ");
INSERT INTO nya_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Muziwombola mwana woyamba kubadwa wa bulu popereka mwana wankhosa. Mukapanda kumuwombola mupheni. Muziwombola ana anu onse aamuna. “Palibe ndi mmodzi yemwe adzaonekere pamaso panga wopanda kanthu mʼdzanja lake. ");
INSERT INTO nya_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Muzigwira ntchito masiku asanu ndi limodzi, koma tsiku lachisanu ndi chiwiri, musagwire ntchito ina iliyonse, Ngakhale nthawi yolima ndi yokolola muyenera kupuma. ");
INSERT INTO nya_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Muzichita Chikondwerero cha Masabata, chifukwa ndi chikondwerero cha tirigu woyambirira kucha, ndiponso ndi chikondwerero cha kututa zokolola pakutha pa chaka. ");
INSERT INTO nya_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Amuna onse azionekera pamaso pa Yehova Mulungu wa Israeli, katatu pa chaka. ");
INSERT INTO nya_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ine ndidzapirikitsa mitundu inayo pamene inu mukufikako ndi kukulitsa malire anu. Palibe ndi mmodzi yemwe adzafune kulanda dziko lanu ngati inu muzidzapita katatu pa chaka pamaso pa Yehova Mulungu wanu, chaka chilichonse. ");
INSERT INTO nya_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Musapereke magazi anyama ngati nsembe kwa Ine pamodzi ndi chilichonse chimene chili ndi yisiti, ndipo musasunge nsembe ya pa Chikondwerero cha Paska mpaka mmawa. ");
INSERT INTO nya_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Muzibwera ndi zipatso zoyambirira kucha zabwino kwambiri ku nyumba ya Yehova Mulungu wanu. “Musamaphike kamwana kambuzi mu mkaka wa mayi wake.” ");
INSERT INTO nya_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Kenaka Yehova anati kwa Mose, “Lemba mawu awa pakuti potsatira mawuwa, ine ndipangana pangano ndi iwe ndi Israeli.” ");
INSERT INTO nya_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mose anakhala kumeneko pamodzi ndi Yehova masiku 40, usana ndi usiku, wosadya kanthu kapena kumwa madzi. Ndipo iye analemba pa miyala ija mawu a pangano, malamulo khumi. ");
INSERT INTO nya_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mose anatsika kuchokera mʼPhiri la Sinai pamodzi ndi miyala iwiri ija ya pangano mʼmanja mwake. Iye sanazindikire kuti nkhope yake imanyezimira pakuti anayankhula ndi Yehova. ");
INSERT INTO nya_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aaroni ndi Aisraeli ataona kuti nkhope ya Mose imanyezimira anaopa kumuyandikira. ");
INSERT INTO nya_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Koma Mose anawayitana. Kotero Aaroni ndi atsogoleri onse a gululo anabwera kwa iye, ndipo anawayankhula. ");
INSERT INTO nya_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Kenaka Aisraeli onse anamuyandikira, ndipo anawapatsa malamulo onse omwe Yehova anamupatsa pa Phiri la Sinai. ");
INSERT INTO nya_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mose atamaliza kuyankhula nawo anaphimba nkhope yake. ");
INSERT INTO nya_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Koma nthawi zonse popita pamaso pa Yehova kukayankhula naye amachotsa chophimbacho mpaka atatuluka. Ndipo akatuluka kudzawuza Aisraeli zimene walamulidwa, ");
INSERT INTO nya_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","iwo amaona nkhope yake ikunyezimira. Choncho Mose amaphimba nkhope yake ngakhale pamene amapita kukayankhula ndi Yehova. ");
INSERT INTO nya_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mose anasonkhanitsa gulu lonse la Aisraeli ndipo anawawuza kuti, “Zinthu zimene Yehova wakulamulirani kuti muzichite ndi izi: ");
INSERT INTO nya_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Muzigwira ntchito zanu pa masiku asanu ndi limodzi, koma tsiku la chisanu ndi chiwiri likhale la Sabata, tsiku lanu lopuma, lopatulika kwa Yehova. Aliyense amene adzagwira ntchito iliyonse pa tsikuli ayenera kuphedwa. ");
INSERT INTO nya_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Pa tsiku la Sabata musakoleze moto paliponse pamene mukhala.” ");
INSERT INTO nya_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mose ananena kwa gulu lonse la Aisraeli kuti, “Zimene Yehova wakulamulirani ndi izi: ");
INSERT INTO nya_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Kuchokera pa zomwe muli nazo, mutenge chopereka cha Yehova. Aliyense amene ali ndi mtima wofuna kupereka abweretse kwa Yehova zopereka izi: Golide, siliva ndi mkuwa; ");
INSERT INTO nya_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","nsalu zobiriwira, zapepo, zofiira, nsalu zofewa; ubweya wambuzi; ");
INSERT INTO nya_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","zikopa za nkhosa zazimuna za utoto wofiira ndi zikopa za akatumbu; matabwa amtengo wa mkesha, ");
INSERT INTO nya_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","mafuta anyale a olivi, zonunkhiritsa mafuta odzozera ndi zopangira lubani wonunkhira; ");
INSERT INTO nya_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","miyala yokongola ya mtundu wa onikisi ndi ina yabwino yoyika pa Efodi ndi pa chovala cha pachifuwa. ");
INSERT INTO nya_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Anthu onse aluso pakati panu abwere ndi kupanga zonse zimene Yehova walamula: ");
INSERT INTO nya_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Chihema ndi tenti yake ndiponso chophimba chake, ngowe zake, maferemu ake, mitanda yake, mizati yake ndi matsinde ake; ");
INSERT INTO nya_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Bokosi la Chipangano pamodzi ndi mitengo yake yonyamulira ndiponso chovundikira chake cha bokosilo ndi nsalu zophimba bokosilo; ");
INSERT INTO nya_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","tebulo pamodzi ndi mitengo yake yonyamulira pamodzi ndi zipangizo zake zonse ndiponso buledi wokhala pamaso pa Yehova; ");
INSERT INTO nya_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","choyikapo nyale yowunikira pamodzi ndi zipangizo zake, nyale ndi mafuta anyalezo; ");
INSERT INTO nya_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","guwa lofukizira lubani pamodzi ndi mitengo yake yonyamulira, mafuta odzozera ndi lubani onunkhira; nsalu yotchinga pa khomo lolowera mʼchihema; ");
INSERT INTO nya_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","guwa lansembe yopsereza pamodzi ndi sefa yamkuwa, mitengo yake yonyamulira ndi zipangizo zake zonse, beseni losambira lamkuwa ndi miyendo yake; ");
INSERT INTO nya_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","nsalu yotchingira bwalo pamodzi ndi mizati yake ndi matsinde ake, ndiponso nsalu yotchingira pa khomo lolowera ku bwalo; ");
INSERT INTO nya_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","zikhomo za tenti ya chihema ndiponso za bwalo, ndi zingwe zake; ");
INSERT INTO nya_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","zovala zolukidwa zovala potumikira kumalo opatulika, zovala zopatulika za wansembe, Aaroni pamodzi ndi za ana ake aamuna pamene akutumikira monga ansembe.” ");
INSERT INTO nya_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Kenaka gulu lonse la Aisraeli linachoka pamaso pa Mose, ");
INSERT INTO nya_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ndipo aliyense amene anakhudzidwa mu mtima mwake nafuna kupereka, anabwera kudzapereka chopereka kwa Yehova cha ntchito yokonza tenti ya msonkhano, cha ntchito zonse za mʼtentimo ndi cha zovala zopatulika. ");
INSERT INTO nya_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Onse amene anali ndi mtima wofuna, amuna ndi amayi omwe anabwera kudzapereka zodzikometsera zagolide za mtundu uliwonse: zomangira zovala, ndolo, mphete ndi zokometsera. Onse anapereka golide wawo monga nsembe yoweyula pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Aliyense amene anali ndi nsalu ya mtundu wa mtambo, yapepo kapena yofiira kapena yofewa, yosalala, kapena ubweya wambuzi, zikopa za nkhosa zonyika mu utoto wofiira kapena zikopa anazibweretsa. ");
INSERT INTO nya_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Onse amene anapereka chopereka cha siliva kapena mkuwa anabweretsa monga chopereka kwa Yehova. Ndipo aliyense amene anali ndi matabwa a mtengo wa mkesha kuti awagwiritse ntchito mbali ina iliyonse ya ntchitoyo, anabweretsa. ");
INSERT INTO nya_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Mayi aliyense waluso analuka ndi manja ake ndi kubweretsa chomwe analuka cha mtundu wa mtambo, chapepo kapena chofiira kapena chofewa, chosalala. ");
INSERT INTO nya_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ndipo amayi onse amene anali ndi mtima wofuna ndipo anali ndi luso analuka ubweya wa mbuzi. ");
INSERT INTO nya_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Atsogoleri anabweretsa miyala ya onikisi ndi miyala yokongola yoyika pa efodi ndi chovala chapachifuwa. ");
INSERT INTO nya_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Anabweretsanso zonunkhiritsa ndiponso mafuta owunikira a olivi ndi odzozera ndi zofukizira zonunkhira. ");
INSERT INTO nya_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Aisraeli onse aamuna ndi aakazi amene anali ndi mtima wofuna, anabweretsa kwa Yehova chopereka chaufulu ku ntchito yonse ya Yehova imene analamulira kudzera mwa Mose kuti achite. ");
INSERT INTO nya_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Kenaka Mose anati kwa Aisraeli, “Taonani, Yehova wasankha Bezaleli mwana wa Uri, mwana wa Huri, wa fuko la Yuda, ");
INSERT INTO nya_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ndipo wamudzaza ndi Mzimu wa Mulungu kotero kuti ali ndi luso ndi nzeru zomvetsa zinthu, ndipo akudziwa bwino ntchito zonse zamanja monga izi: ");
INSERT INTO nya_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Kulemba ndondomeko ya ntchito zaluso ndi kupanga zinthu zagolide, zasiliva ndi zamkuwa, ");
INSERT INTO nya_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","kusema ndi kuyika miyala yokongola, kukonza zinthu zamatabwa ndiponso kugwira ntchito ina iliyonse yamanja. ");
INSERT INTO nya_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ndipo Iye wapereka kwa Bezaleli pamodzi ndi Oholiabu mwana wa Ahisamaki, wa fuko la Dani luso lophunzitsa ena. ");
INSERT INTO nya_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Mulungu wawapatsa maluso osiyanasiyana, maluso ogoba, olemba ndondomeko, opeta zokometsera pa nsalu zamtundu wamtambo, zapepo ndi zofiira ndiponso zofewa zosalala ndi zoluka. Onsewa ndi amisiri a ntchito zamanja ndi zokonza ndondomeko. ");
INSERT INTO nya_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Choncho Bezaleli, Oholiabu pamodzi ndi anthu aluso onse amene Yehova anawapatsa luso ndi nzeru zodziwira kupanga zofunika zonse zomangira malo opatulika, adzapanga zonse iwowo, monga momwe Yehova analamulira.” ");
INSERT INTO nya_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Ndipo Mose anayitana Bezaleli ndi Oholiabu ndiponso munthu aliyense waluso amene Yehova anamupatsa luso ndiponso amene anali ndi mtima wofuna kugwira ntchito. ");
INSERT INTO nya_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Iwo analandira kuchokera kwa Mose zopereka zonse Aisraeli anabweretsa kuti agwirire ntchito yomanga malo wopatulika. Ndipo anthu anapitirira kupereka zopereka zaufulu mmawa uliwonse. ");
INSERT INTO nya_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Kotero amisiri onse amene amagwira ntchito yonse ya malo wopatulika anasiya ntchitoyo ");
INSERT INTO nya_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ndipo anati kwa Mose, “Anthu akubweretsa kuposa zimene zikufunika kugwirira ntchito imene Yehova analamulira kuti ichitike.” ");
INSERT INTO nya_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Choncho Mose analamulira ndipo analengeza mu msasa onse, “Mwamuna kapena mayi aliyense asaperekenso chopereka chilichonse cha ku malo wopatulika.” Choncho anthu analetsedwa kubweretsa zambiri, ");
INSERT INTO nya_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","chifukwa zimene anali nazo zinali zoposera zimene zimafunika kugwirira ntchito yonse. ");
INSERT INTO nya_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Anthu onse aluso pakati pa anthu ogwira ntchitoyo anapanga chihema pogwiritsa ntchito nsalu khumi zofewa, zosalala ndi zolukidwa bwino, zobiriwira, zapepo ndi zofiira. Ndipo anthu aluso anapeta pa nsaluzo Akerubi. ");
INSERT INTO nya_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Nsalu zonse zinali zofanana. Mulitali mwake zinali mamita khumi ndi atatu, mulifupi mamita awiri. ");
INSERT INTO nya_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Iwo analumikiza nsalu zisanu, kuti ikhale nsalu imodzi ndipo anachita chimodzimodzi ndi nsalu zisanu zinazo. ");
INSERT INTO nya_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Kenaka anapanga zokolowekamo za nsalu yobiriwira mʼmphepete mwa nsalu imodzi yotsiriza ya mbali ina. Ndipo anachita chimodzimodzi ndi nsalu yotsiriza ya mbali inayo. ");
INSERT INTO nya_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Iwo anasokerera zokolowekamo makumi asanu pa nsalu yoyamba ndi zokolowekamo makumi asanu zinanso pa nsalu inayo. Anapanga kuti zokolowekamozo ziziyangʼanana. ");
INSERT INTO nya_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Kenaka anapanga ngowe zagolide 50 zolumikizira nsalu ziwirizo kotero kuti zinapanga chihema chimodzi. ");
INSERT INTO nya_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Iwo anapanga nsalu za ubweya wambuzi zophimba pamwamba pa chihemacho. Nsalu zonse pamodzi zinalipo khumi ndi imodzi. ");
INSERT INTO nya_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Nsalu zonse khumi ndi imodzi zinali zofanana. Mulitali mwake munali mamita khumi ndi anayi ndipo mulifupi mwake munali mamita awiri. ");
INSERT INTO nya_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Iwo analumikiza nsalu zisanu kukhala nsalu imodzi ndipo nsalu zinazo zisanu ndi imodzi, analumikizanso kukhala nsalu imodzinso. ");
INSERT INTO nya_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Kenaka anasokerera zokolowekamo makumi asanu mʼmphepete mwa nsalu imodzi yotsirizira ya nsalu yoyamba yolumikiza ija ndiponso anapanga zokolowekamo zina makumi asanu mʼmphepete mwa nsalu yotsirizira ya nsalu inanso yolumikiza ija. ");
INSERT INTO nya_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Iwo anapanga ngowe 50 zamkuwa zolowetsa mu zokolowekazo ndipo anaphatikiza nsalu ziwirizo kuti tentiyo ikhale imodzi. ");
INSERT INTO nya_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ndipo anapanga chikopa cha nkhosa zazimuna cha utoto wofiira chophimbira tentiyo ndipo pamwamba pake anapanganso chophimbira china cha zikopa za akatumbu. ");
INSERT INTO nya_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Iwo anapanga maferemu amatabwa amtengo wa mkesha oyimikira chihemacho. ");
INSERT INTO nya_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Feremu iliyonse inali yotalika mamita anayi ndipo mulifupi mwake munali masentimita 69. ");
INSERT INTO nya_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Thabwa lililonse linali ndi zolumikizira ziwiri. Iwo anapanga maferemu onse a chihemacho ndi matabwa otere. ");
INSERT INTO nya_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Anapanga maferemu makumi awiri a mbali yakummwera kwa chihemacho, ");
INSERT INTO nya_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ndiponso anapanga matsinde 40 asiliva ndipo anawayika pansi pa maferemuwo. Pansi pa feremu iliyonse anayika matsinde awiri ogwiriziza zolumikizira ziwiri zija. ");
INSERT INTO nya_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Iwo anapanganso maferemu makumi awiri a mbali yakumpoto ya chihemacho, ");
INSERT INTO nya_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ndiponso matsinde makumi anayi asiliva, awiri pansi pa feremu iliyonse. ");
INSERT INTO nya_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Anapanganso maferemu asanu ndi imodzi a kumbuyo kwa tenti, kumbali yakumadzulo, ");
INSERT INTO nya_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ndiponso maferemu awiri a pa ngodya yakumbuyo kwenikweni kwa tenti. ");
INSERT INTO nya_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Pa ngodya ziwirizi panali maferemu awiri, kuyambira pansi mpaka pamwamba atalumikizidwa pa ngowe imodzi. Maferemu onse anali ofanana. ");
INSERT INTO nya_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Choncho panali maferemu asanu ndi atatu ndiponso matsinde 16 asiliva, awiri anali pansi pa feremu iliyonse. ");
INSERT INTO nya_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Iwo anapanganso mitanda ya matabwa amtengo wa mkesha. Mitanda isanu inali ya maferemu a mbali imodzi ya chihema, ");
INSERT INTO nya_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","mitanda isanu inanso inali ya maferemu a mbali inayo ndipo mitanda ina isanu ya mbali yakumadzulo, kumapeto kwenikweni kwa chihema. ");
INSERT INTO nya_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Anapanga mtanda wapakati omwe umachokera pa maferemu a mbali ina mpaka mbali inanso. ");
INSERT INTO nya_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Iwo anakuta maferemuwo ndi golide ndiponso anapanga mphete zagolide zogwiriziza mitandayo. Ndipo mitandayonso anayikuta ndi golide. ");
INSERT INTO nya_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Anapanga nsalu yokhala ndi mtundu wamtambo, wapepo ndi ofiira ndipo nsaluyo inali yolukidwa bwino, yofewa ndi yosalala. Ndipo anthu aluso anapetapo zithunzi za Akerubi. ");
INSERT INTO nya_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Iwo anapanga nsanamira zinayi zamtengo wa mkesha zokutidwa ndi golide. Anapanganso ngowe zagolide za nsanamirazo ndi matsinde asiliva anayi. ");
INSERT INTO nya_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Anapanga nsalu ya pa chipata cholowera mu chihema, yamtundu wamtambo, wapepo ndi ofiira yomwe inali yofewa ndi yosalala, yopetedwa bwino ndi amisiri aluso. ");
INSERT INTO nya_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Anapanga nsanamira zisanu ndi ngowe zake. Anakuta pamwamba pa nsanamirazo ndi zomangira zake ndi golide, ndipo anapanganso matsinde asanu amkuwa. ");
INSERT INTO nya_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezaleli anapanga Bokosi la Chipangano lamatabwa amtengo wa mkesha. Kutalika kwake kunali masentimita 114, mulifupi mwake munali masentimita 69, msinkhu wake masentimita 69. ");
INSERT INTO nya_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Iye analikuta bokosilo ndi golide wabwino kwambiri mʼkati mwake ndi kunja komwe. Anapanganso mkombero wagolide kuzungulira bokosilo. ");
INSERT INTO nya_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Iye anapanga mphete zinayi zagolide ndi kuzimangirira ku miyendo yake inayi ija, mbali ina ziwiri ndi mbali inanso ziwiri. ");
INSERT INTO nya_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Kenaka anapanga mizati yamtengo wa mkesha ndi kuzikuta ndi golide. ");
INSERT INTO nya_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Ndipo analowetsa nsichizo mʼmphete zija za mbali zonse ziwiri za bokosilo kuti azinyamulira. ");
INSERT INTO nya_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Iye anapanga chivundikiro cha bokosilo cha golide wabwino kwambiri, kutalika kwake masentimita 114, mulifupi mwake masentimita 69. ");
INSERT INTO nya_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ndipo anapanga Akerubi awiri agolide osula ndi nyundo ndi kuwayika mbali ziwiri za chivundikirocho. ");
INSERT INTO nya_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Iye anapanga kerubi mmodzi mbali ina ndi wina mbali inayo. Akerubiwa anawapangira limodzi ndi chivundikirocho mʼmapeto mwa mbali ziwirizo. ");
INSERT INTO nya_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Mapiko a Akerubiwo anatambasukira pamwamba pa chivundikiro cha bokosilo kuti achiphimbe. Akerubiwo anakhala choyangʼanana, aliyense kuyangʼana chivundikirocho. ");
INSERT INTO nya_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Iwo anapanga tebulo la matabwa amtengo wa mkesha, mulitali mwake masentimita 91, mulifupi mwake masentimita 46, msinkhu wake masentimita 69. ");
INSERT INTO nya_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Kenaka analikuta ndi golide wabwino kwambiri, ndipo anapanga mkombero wagolide mʼmbali mwake. ");
INSERT INTO nya_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Iwo anapanga feremu yozungulira tebulo, mulifupi mwake ngati chikhatho cha dzanja, ndipo anayika mkombero wagolide kuzungulira feremuyo. ");
INSERT INTO nya_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Iwo anapanga mphete zinayi zagolide ndipo anazilumikiza ku ngodya zake zinayi, kumene kunali miyendo yake inayi. ");
INSERT INTO nya_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Mphetezo anaziyika kufupi ndi feremu kuti azikolowekamo nsichi zonyamulira tebuloyo. ");
INSERT INTO nya_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Anapanga nsichi zamtengo wa mkesha ndi kuzikuta ndi golide kuti azinyamulira tebulolo. ");
INSERT INTO nya_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ndipo anapanga ziwiya za pa tebulolo zagolide wabwino, mbale ndi zipande, mitsuko ndi mabeseni zogwiritsa ntchito popereka nsembe za chakumwa. ");
INSERT INTO nya_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Iwo anapanga choyikapo nyale chagolide wabwino kwambiri. Tsinde lake ndi mphanda zake zinasulidwa ndi nyundo. Zikho zake zokhala ndi mphukira ndi maluwa ake zinapangidwa kumodzi. ");
INSERT INTO nya_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Mʼmbali mwake munali mphanda zisanu ndi imodzi, zitatu mbali iliyonse. ");
INSERT INTO nya_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Zikho zitatu zokhala ngati za maluwa amtowo, mphukira ndi duwa zinali pa mphanda yoyamba. Pa mphanda yachiwiri panalinso zikho zitatu zokhala ngati za maluwa amtowo, mphukira ndi duwa. Ndipo mphanda zonse zisanu ndi imodzi zinali chimodzimodzi ndipo zinatuluka mʼchoyikapo nyalecho. ");
INSERT INTO nya_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Pa choyikapo nyalecho panali zikho zinayi zokhala ngati maluwa amtowo, mphukira ndi maluwa ake. ");
INSERT INTO nya_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Mphukira yoyamba inali mʼmunsi mwa nthambi ziwiri zoyamba za pa choyikapo nyale. Mphukira yachiwiri inali mʼmunsi mwa nthambi ziwiri zinazo. Mphukira yachitatu inali mʼmunsi mwa nthambi zina ziwirinso. Zonse pamodzi zinali nthambi zisanu ndi imodzi ");
INSERT INTO nya_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Mphukira ndi nthambi zonse zinasulidwa kumodzi ndi choyikapo nyalecho ndi golide wabwino kwambiri. ");
INSERT INTO nya_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Iwo anapanga nyale zisanu ndi ziwiri, mbaniro ndi zowolera phulusa, zonse zinali zagolide wabwino kwambiri. ");
INSERT INTO nya_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Iwo anapanga choyikapo nyale ndi zipangizo zake zonse zagolide wabwino kwambiri wolemera makilogalamu 34. ");
INSERT INTO nya_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Iwo anapanga guwa lamatabwa amtengo wa mkesha lofukizirapo lubani. Linali lofanana mbali zonse, mulitali masentimita 46, mulifupi masentimita 46, ndipo msinkhu masentimita 91, ndipo nyanga zake zinapangidwa kumodzi ndi guwalo. ");
INSERT INTO nya_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Iwo anakuta guwa lonse ndi golide wabwino kwambiri, pamwamba pake, mbali zonse ndi nyanga zake, ndipo anapanga mkombero wagolide kuzungulira guwalo. ");
INSERT INTO nya_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Anapanga mphete ziwiri pansi pa mkomberowo ndi kulumikiza ku mbali zonse ziwiri kuti apisemo nsichi zonyamulira. ");
INSERT INTO nya_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Anapanga mizati yamtengo wa mkesha ndipo anayikuta ndi golide. ");
INSERT INTO nya_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Iwo anapanganso mafuta opatulika odzozera ndi zofukiza za fungo lokoma kwambiri. Iyi inali ntchito ya mʼmisiri waluso lopanga zonunkhiritsa. ");
INSERT INTO nya_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Anapanga guwa lansembe zopsereza lamatabwa amtengo wa mkesha. Linali lofanana mbali zonse. Msinkhu wake masentimita 137, mulitali mwake masentimita 229, mulifupi masentimita 229. ");
INSERT INTO nya_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Anapanga nyanga imodziimodzi pa ngodya zake zinayizo, kotero kuti nyangazo ndi guwalo zinali chinthu chimodzi, ndipo anakuta guwalo ndi mkuwa. ");
INSERT INTO nya_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Anapanganso ziwiya zamkuwa izi zogwirira ntchito pa guwalo: miphika, mafosholo, mabeseni owazira magazi, ngowe zokowera nyama ndi zosonkhezera moto. ");
INSERT INTO nya_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Anapanga sefa yachitsulo chamkuwa ya guwa lansembelo kuti ikhale mmunsi mwa khoma la guwa lansembelo, kuchokera pansi mpaka pakati pa khoma la guwalo. ");
INSERT INTO nya_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Anapanga mphete zamkuwa zinayi ndipo anazilumikiza ku ngodya zinayi za sefa ija kuti zigwire nsichi zonyamulira. ");
INSERT INTO nya_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Anapanga nsichi zamtengo wa mkesha ndipo anazikuta ndi mkuwa. ");
INSERT INTO nya_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Iwo analowetsa nsichizo mʼmphetemo mbali zonse ziwiri za guwalo kuti azinyamulira. Guwalo linali lamatabwa ndi logoba mʼkati mwake. ");
INSERT INTO nya_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Anapanga beseni lamkuwa lokhala ndi miyendo yamkuwanso kuchokera ku magalasi oyangʼanira nkhope a amayi amene ankatumikira pa chipata cha tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Kenaka anapanga bwalo la chihema. Mbali yakummwera inali yotalika mamita 46 ndipo kunali nsalu yotchinga yofewa yosalala yolukidwa bwino. ");
INSERT INTO nya_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Anapanganso mizati makumi awiri, matsinde makumi awiri amkuwa ndi ngowe zasiliva ndi zingwe za mizatiyo. ");
INSERT INTO nya_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Mbali yakumpoto inalinso yotalika mamita 46 ndipo inali ndi mizati makumi awiri, matsinde amkuwa makumi awiri, ngowe zasiliva ndi zingwe za mizatiyo. ");
INSERT INTO nya_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Mbali yakumadzulo inali yotalika mamita 23 ndipo inali ndi nsalu yotchinga, mizati khumi ndi matsinde khumi. Inalinso ndi ngowe zasiliva ndi zingwe za mizatiyo. ");
INSERT INTO nya_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Mbali yakummawa, kotulukira dzuwa, inalinso yotalika mamita 23. ");
INSERT INTO nya_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Mbali imodzi yachipata kunali nsalu yotchinga yotalika mamita asanu ndi awiri, mizati itatu ndi matsinde atatu, ");
INSERT INTO nya_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","polowera mʼbwalo panali nsalu yotchinga ya mamita asanu ndi awiri pamodzi ndi mizati itatu ndi matsinde atatu. ");
INSERT INTO nya_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Katani yonse yotchinga kuzungulira chihema inali yofewa, yosalala ndi yolukidwa bwino. ");
INSERT INTO nya_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Matsinde amizati anali amkuwa. Ngowe ndi zingwe za mizati zinali zasiliva, ndipo pamwamba pa mizatiyo anakutapo siliva. Choncho mizati yonse ya bwalolo inalumikizidwa ndi zingwe zasiliva. ");
INSERT INTO nya_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Nsalu yotchinga ya pa chipata inali yamtundu wa mtambo, yapepo ndi yofiira, yofewa yosalala ndi yopangidwa ndi anthu aluso. Nsaluyo inali yotalika mamita asanu ndi anayi, molingana ndi nsalu zotchinga bwalo. Msinkhu wake unali masentimita 229, ");
INSERT INTO nya_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","pamodzi ndi mizati yake inayi ndi matsinde amkuwa anayi. Ngowe ndi zingwe zake zinali za siliva, ndipo pamwamba pake pa mzati anakutapo ndi siliva. ");
INSERT INTO nya_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Zikhomo za chihema ndi zina zonse zozungulira chihemacho zinali zamkuwa. ");
INSERT INTO nya_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Chiwerengero cha zipangizo zimene anagwiritsa ntchito popanga chihema, chihema chaumboni, zimene Mose analamulira Alevi kuti alembe motsogozedwa ndi Itamara mwana wa Aaroni, wansembe, chinali ichi: ");
INSERT INTO nya_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezaleli mwana wa Uri, mwana wa Huzi wa fuko la Yuda anapanga chilichonse Yehova analamulira Mose, ");
INSERT INTO nya_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","pamodzi ndi Oholiabu mwana wa Ahisamaki, wa fuko la Dani, wa luso la zopangapanga ndi kulemba mapulani, ndi wopanga nsalu zolukidwa bwino za mtundu wa mtambo, yapepo ndi zofiira, zofewa ndi zosalala. ");
INSERT INTO nya_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Golide yense wochokera ku nsembe yoweyula amene anagwiritsa ntchito pa ntchito yonse yopanga malo wopatulika anali wolemera makilogalamu 1,000 potsata miyeso ya kumalo wopatulika. ");
INSERT INTO nya_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Siliva wochokera ku gulu lonse la anthu anali wolemerera makilogalamu 3,430, potsata miyeso ya ku malo wopatulika. ");
INSERT INTO nya_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Munthu aliyense amapereka beka imodzi, kufanana ngati makilogalamu 6, potsata muyeso wa ku malo wopatulika. Kuchokera kwa aliyense amene anawerengedwa kuyambira zaka 20 kapena kuposerapo, amuna onse analipo 603,550. ");
INSERT INTO nya_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Anagwiritsa ntchito siliva wolemera makilogalamu 3,400 kupanga matsinde 100 a ku malo wopatulika ndi makatani, ndipo makilogalamu 34 kupanga tsinde limodzi. ");
INSERT INTO nya_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Makilogalamu otsalawo anagwiritsa ntchito popanga ngowe zamzati kukutira pamwamba pa mizati ndiponso kupanga zingwe zake. ");
INSERT INTO nya_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Mkuwa ochokera ku nsembe yoweyula unali makilogalamu 2,425. ");
INSERT INTO nya_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Iwo anawugwiritsa ntchito popanga matsinde a pa chipata cha tenti ya msonkhano, guwa la mkuwa pamodzi ndi sefa yake ndiponso ziwiya zonse, ");
INSERT INTO nya_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","matsinde ozungulira bwalo ndiponso a pa chipata pake, ndi zikhomo zonse za tentiyo ndi matsinde a malo wozungulirapo. ");
INSERT INTO nya_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Anapanga zovala za ansembe, zovala potumikira ku malo wopatulika pogwiritsa ntchito nsalu ya mtundu wa mtambo, yapepo ndi yofiira. Anapanganso zovala zopatulika za Aaroni monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Popanga efodi, iwo anagwiritsa ntchito golide, nsalu yamtundu wa mtambo, yapepo, yofiira, yosalala yofewa. ");
INSERT INTO nya_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Anasula golide wopyapyala ndi kumulezaleza kuti alumikize kumodzi ndi nsalu yamtundu wa mtambo, yapepo ndi yofiira yosalala yofewa yolukidwa mwaluso. ");
INSERT INTO nya_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Iwo anapanga efodi imene inali ndi timalamba tiwiri ta pa mapewa, tosokerera ku msonga zake ziwiri kuti azitha kumanga. ");
INSERT INTO nya_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Lamba womangira efodi anali wolukidwa mwaluso ngati efodiyo. Anali nsalu imodzi ndi efodiyo, wopangidwa ndi golide, nsalu yamtundu wa mtambo, yapepo, yofiira, yofewa yosalala, monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Iwo anakonza miyala ya onikisi ndi kuyiika mu zoyikamo zake zagolide ndipo anazokota mayina a ana a Israeli monga amachitira pa chidindo. ");
INSERT INTO nya_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Kenaka anayimangirira pa tinsalu ta mʼmapewa ta efodi tija ngati miyala ya chikumbutso cha ana a Israeli monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Iwo anapanga chovala chapachifuwa mwaluso kwambiri. Anachipanga ngati efodi pogwiritsa ntchito golide, nsalu yamtundu wa mtambo, yapepo, yofiira, yofewa yosalala ndi yolukidwa bwino. ");
INSERT INTO nya_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Kutalika kwake kunali kofanana mbali zonse, mulitali masentimita 23, mulifupi masentimita 23, chinali chopinda pawiri. ");
INSERT INTO nya_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Kenaka anayikapo mizere inayi ya miyala yokongola kwambiri. Mzere woyamba anayika miyala ya rubi, topazi ndi berili; ");
INSERT INTO nya_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","mzere wachiwiri anayikapo miyala ya emeradi, safiro ndi dayimondi; ");
INSERT INTO nya_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","mzere wachitatu anayikapo miyala ya opera, agate ndi ametisiti; ");
INSERT INTO nya_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","mzere wachinayi anayikapo miyala ya topazi, onikisi ndi yasipa. Miyalayi anayiyika mu zoyikamo zagolide. ");
INSERT INTO nya_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Miyalayo inalipo khumi ndi iwiri, uliwonse kuyimira dzina limodzi la ana a Israeli. Mwala uliwonse unazokotedwa ngati chidindo dzina limodzi la mafuko khumi ndi awiri a Israeli. ");
INSERT INTO nya_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Anapanga timaunyolo tagolide wabwino kwambiri ta pa chovala chapachifuwa, topota ngati chingwe. ");
INSERT INTO nya_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Anapanganso zoyikamo zake zagolide ndi mphete ziwiri zagolide, ndipo anamangirira mphetezo pa ngodya ziwiri za chovala chapachifuwa. ");
INSERT INTO nya_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Anamangirira timaunyolo tiwiri tagolide tija pa mphete za pa ngodya pa chovala chapachifuwacho. ");
INSERT INTO nya_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Ndipo mbali ina ya timaunyoloto anamangirira pa zoyikapo zake ziwiri zija, ndi kulumikiza pa tinsalu takutsogolo kwa mapewa a efodi. ");
INSERT INTO nya_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Anapanganso mphete ziwiri zagolide ndipo analumikiza ku ngodya ziwiri zamʼmunsi mwa chovala chapachifuwa, champhepete mwake, mʼkati pafupi ndi efodi ija. ");
INSERT INTO nya_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Kenaka anapanga mphete zina ziwiri zagolide ndi kuzilumikiza kumunsi kwa tinsalu takutsogolo kwa efodi, pafupi ndi msoko, pamwamba pangʼono pa lamba wamʼchiwuno wa efodi. ");
INSERT INTO nya_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Anamangirira mphete za pa chovala chapachifuwa zija ku mphete za efodi ndi chingwe chamtundu wa mtambo, kulumikiza lamba ndi chovala chapachifuwacho kuti chovala chapachifuwacho chisalekane ndi efodi ija monga Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Anayipangira efodiyo mkanjo wamtundu wa mtambo, wolukidwa ndi mmisiri waluso. ");
INSERT INTO nya_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Mkanjowo unali ndi malo opisapo mutu pakati pakepo. Pa chibowopo panali chibandi chosokedwa mochita ngati kuluka monga muja akhalira malaya kuti chibowocho chilimbe, chisangʼambike. ");
INSERT INTO nya_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Pa mpendero wamʼmunsi wa mkanjowo, analumikiza mphonje zokhala ngati makangadza za nsalu yamtundu wa mtambo, yapepo ndi yofiira yofewa yosalala ndi yopetedwa bwino yomwe inazungulira mkanjo. ");
INSERT INTO nya_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ndipo anapanga maberu agolide wabwino kwambiri ndipo analumikiza mozungulira mpendero pakati pa makangadzawo. ");
INSERT INTO nya_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Kotero panali mphonje imodzi ndi belu limodzi kuzungulira mpendero wa mkanjo wovala potumikira monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Kwa Aaroni ndi ana ake anawapangira minjiro ya nsalu yofewa yosalala, yolukidwa bwino ndi munthu waluso, ");
INSERT INTO nya_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","nduwira ya nsalu yofewa yosalala, lamba wa nsalu yofewa yosalala, womanga mʼmutu, ndi makabudula amʼkati a nsalu yofewa yosalala olukidwa bwino. ");
INSERT INTO nya_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Anapanga lamba wolukidwa bwino wa nsalu yofewa ndi yosalala ya mtundu wa mtambo yapepo ndi yofiira. Ili linaliluso la munthu wopanga zokometsera monga Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Iwo anapanga duwa lagolide wabwino kwambiri ngati chidindo ndipo anazokotapo mawu akuti, Wopatulikira Yehova. ");
INSERT INTO nya_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Kenaka analimangira ndi chingwe cha nsalu yamtundu wa mtambo pa nduwira, monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Tsopano ntchito yonse ya tenti ya msonkhano inatha. Aisraeli anachita zonse monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Kenaka anabweretsa chihema kwa Mose. Tenti ndi zipangizo zake, ngowe zake, maferemu ake, mitanda yake, mizati yake ndi matsinde ake; ");
INSERT INTO nya_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","chophimba cha chikopa cha nkhosa yayimuna chonyikidwa mu utoto ofiira, chophimba cha chikopa cha akatumbu ndi nsalu zophimba; ");
INSERT INTO nya_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","bokosi la umboni pamodzi ndi mitengo yake yonyamulira ndiponso chovundikira chake; ");
INSERT INTO nya_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","tebulo pamodzi ndi zipangizo zake ndiponso buledi wokhala pamaso pa Yehova; ");
INSERT INTO nya_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","choyikapo nyale chagolide wabwino kwambiri pamodzi ndi nyale zake ndi zipangizo zake zonse, ndiponso mafuta anyalezo; ");
INSERT INTO nya_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","guwa lagolide, mafuta odzozera, lubani onunkhira ndi nsalu yotchinga pa khomo lolowera mu tenti; ");
INSERT INTO nya_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","guwa lamkuwa ndi sefa yamkuwa, mitengo yake yonyamulira ndi zipangizo zake zonse; beseni ndi miyendo yake; ");
INSERT INTO nya_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","nsalu yotchingira bwalo pamodzi ndi mizati yake ndi matsinde ake ndiponso nsalu yotchingira pa khomo lolowera ku bwalo; zingwe zake ndi zikhomo za tenti; zipangizo zonse za chihema, tenti ya msonkhano; ");
INSERT INTO nya_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ndiponso zovala zolukidwa zovala potumikira kumalo opatulika, zovala zopatulika za wansembe, Aaroni pamodzi ndi za ana ake aamuna pamene akutumikira monga ansembe. ");
INSERT INTO nya_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Aisraeli anagwira ntchito yonse monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mose anayendera ntchitoyo ndipo anaona kuti anayichita monga momwe Yehova analamulira. Kotero Mose anawadalitsa. ");
INSERT INTO nya_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Kenaka Yehova anati kwa Mose, ");
INSERT INTO nya_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Imika chihema, tenti ya msonkhano, tsiku loyamba la mwezi. ");
INSERT INTO nya_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Uyikemo bokosi la umboni ndipo uphimbe bokosilo ndi katani. ");
INSERT INTO nya_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ulowetsemo tebulo ndi kuyika zimene zimakhala pamenepo. Kenaka ulowetse choyikapo nyale ndipo uyikepo nyale zake. ");
INSERT INTO nya_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Uyike guwa lofukiza la golide patsogolo pa bokosi la umboni ndipo uyike katani ya pa chipata cha chihema. ");
INSERT INTO nya_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Uyike guwa lansembe yopsereza patsogolo pa chipata cha chihema, tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Uyike beseni pakati pa tenti ya msonkhano ndi guwa lansembe ndipo uyikemo madzi. ");
INSERT INTO nya_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Upange bwalo lozungulira chihemacho ndipo uyike katani ya pa chipata cha bwalolo. ");
INSERT INTO nya_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Utenge mafuta wodzozera ndipo udzoze chihema ndi chilichonse chili mʼmenemo ndipo zidzakhala zoyeretsedwa. ");
INSERT INTO nya_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Kenaka udzoze guwa lansembe lopsereza ndi ziwiya zake zonse. Ulipatule guwalo ndipo lidzakhala loyera kwambiri. ");
INSERT INTO nya_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Udzoze beseni ndi miyendo yake ndipo uzipatule. ");
INSERT INTO nya_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Ubwere ndi Aaroni ndi ana ake pa chipata cha tenti ya msonkhano ndipo uwasambitse ndi madzi. ");
INSERT INTO nya_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Kenaka umuveke Aaroni zovala zopatulika, umudzoze ndi kumupatula kotero kuti athe kunditumikira monga wansembe. ");
INSERT INTO nya_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ubweretse ana ake ndipo uwaveke minjiro. ");
INSERT INTO nya_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Uwadzoze monga momwe unadzozera abambo awo, kotero kuti anditumikire monga ansembe. Kudzozedwako kudzakhala unsembe wawo pa mibado ndi mibado” ");
INSERT INTO nya_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mose anachita zonse monga Yehova anamulamulira. ");
INSERT INTO nya_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Kotero anayimika chihema tsiku loyamba la mwezi woyamba mʼchaka chachiwiri. ");
INSERT INTO nya_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Nthawi imene Mose anayimika chihema, anayika matsinde mʼmalo ake, kuyimitsa maferemu, kulowetsa mitanda ndi kuyika nsichi. ");
INSERT INTO nya_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Kenaka anayika tenti pamwamba pa chihema ndipo anayika chophimba pa tenti monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Iye anatenga miyala ya umboni nayika mʼbokosi lija ndi kuyika chivundikiro pamwamba pake. ");
INSERT INTO nya_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Kenaka analowetsa bokosilo mʼchihema ndipo anapachika katani ndi kubisa bokosi la umboni monga momwe Yehova analamulira iye. ");
INSERT INTO nya_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Mose anayika tebulo mu tenti ya msonkhano kumpoto kwa chihema, kunja kwa katani, ");
INSERT INTO nya_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ndipo anayikapo buledi pamaso pa Yehova, monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Iye anayikanso choyikapo nyale mu tenti ya msonkhano moyangʼanana ndi tebulo mbali yakummwera kwa chihema. ");
INSERT INTO nya_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ndipo anayikapo nyale zija pamaso pa Yehova, monga Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Mose anayika guwa la golide mu tenti ya msonkhano patsogolo pa katani ");
INSERT INTO nya_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ndipo anapserezapo lubani wonunkhira monga Yehova anamulamulira. ");
INSERT INTO nya_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Kenaka anayika katani ya pa chipata cha chihema. ");
INSERT INTO nya_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Iye anayika guwa lansembe yopsereza pafupi ndi chipata cha chihema, tenti ya msonkhano, ndipo anapereka nsembe yopsereza ndi nsembe ya ufa monga Yehova anamulamulira. ");
INSERT INTO nya_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Iye anayika beseni pakati pa tenti ya msonkhano ndi guwa lansembe ndipo anathiramo madzi wosamba, ");
INSERT INTO nya_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ndipo Mose, Aaroni ndi ana ake amasamba manja ndi mapazi awo. ");
INSERT INTO nya_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Iwo amasamba nthawi zonse akamalowa mu tenti ya msonkhano kapena kuyandikira guwa lansembe monga Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Kenaka Mose anamanga bwalo kuzungulira chihema ndi guwa lansembe ndipo anayika katani ya pa chipata cha bwalo. Kotero Mose anamaliza ntchito. ");
INSERT INTO nya_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Kenaka mtambo unaphimba tenti ya msonkhano, ndipo ulemerero wa Yehova unadzaza mʼchihemacho. ");
INSERT INTO nya_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Mose sanathe kulowa mu tenti ya msonkhano chifukwa mtambo unali utakhazikika pa chihemacho, ndipo ulemerero wa Yehova unadzaza mʼchihemacho. ");
INSERT INTO nya_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Pa maulendo awo onse, mtambo ukachoka pamwamba pa chihema, Aisraeli ankasamukanso pamene analipo. ");
INSERT INTO nya_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Koma ngati mtambo sunachoke, iwo sankasamukanso mpaka tsiku limene udzachoke. ");
INSERT INTO nya_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Kotero mtambo wa Yehova unkakhala pamwamba pa chihema usana, ndi mtambo wamoto umakhala usiku, pamaso pa nyumba yonse ya Israeli pa masiku onse aulendo wawo.");
INSERT INTO nya_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","26 Yehova anayitana Mose mu tenti ya msonkhano. Iye anati, ");
INSERT INTO nya_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Aliyense wa inu ngati abwera ndi nsembe kwa Yehova kuchokera pa ziweto zake, choperekacho chikhale ngʼombe, nkhosa kapena mbuzi. ");
INSERT INTO nya_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘Ngati munthu apereka nsembe yopsereza ya ngʼombe, ikhale yayimuna yopanda chilema. Aziyipereka pa khomo la tenti ya msonkhano, kuti Yehova alandire. ");
INSERT INTO nya_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Munthuyo asanjike dzanja lake pa mutu pa nsembe yopserezayo, ndipo idzalandiridwa kuti ikhale yopepesera machimo ake. ");
INSERT INTO nya_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Pambuyo pake aphe ngʼombeyo pamaso pa Yehova, ndipo ansembe, ana a Aaroni, atenge magazi ake ndi kuwawaza mbali zonse za guwa lansembe limene lili pa khomo la tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Munthuyo asende nsembe yopserezayo ndi kuyidula nthulinthuli. ");
INSERT INTO nya_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Ndipo ana a Aaroni, wansembe uja asonkhe moto pa guwa ndi kuyalapo nkhuni pa motopo. ");
INSERT INTO nya_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Kenaka ana a Aaroni, wansembe uja, ayike nthuli za nyamayo, mutu wake pamodzi ndi mafuta omwe pa nkhuni zimene zili paguwapo. ");
INSERT INTO nya_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Munthuyo atsuke zamʼkati mwa nyamayo pamodzi ndi miyendo yake yomwe, ndipo wansembe awotche nyama yonse paguwapo. Iyi ndi nsembe yopsereza, chopereka chowotcha pa moto, cha fungo lokomera Yehova. ");
INSERT INTO nya_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘Koma ngati chopereka cha nsembe yopserezayo ndi nkhosa kapena mbuzi kuchokera pa ziweto zake, munthuyo apereke yayimuna yopanda chilema. ");
INSERT INTO nya_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Ayiphere kumpoto kwa guwa, pamaso pa Yehova, ndipo ana a Aaroni amene ndi ansembe, awaze magazi ake mbali zonse za guwalo. ");
INSERT INTO nya_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Kenaka ayidule nyamayo nthulinthuli, ndipo wansembe ayike nthulizo pa guwa, atengenso mutu ndi mafuta omwe, ndipo ayike zonsezi pa nkhuni zimene zikuyaka pa guwa. ");
INSERT INTO nya_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Munthuyo atsuke zamʼkati mwa nyamayo pamodzi ndi miyendo yake yomwe, ndipo wansembe abwere nazo zonse ndi kuzitentha pa guwa. Iyi ndi nsembe yopsereza, chopereka chotentha pa moto, fungo lokomera Yehova. ");
INSERT INTO nya_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘Koma ngati chopereka kwa Yehova ndi nsembe yopsereza ya mbalame, ndiye ikhale njiwa kapena mawunda. ");
INSERT INTO nya_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Wansembe abwere nayo ku guwa, ayidule mutu moyipotola ndi kutentha mutuwo pa guwa. Magazi ake awathire pansi kuti ayenderere pambali pa guwa. ");
INSERT INTO nya_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Iye achotse chithokomiro pamodzi ndi nthenga zake zomwe ndi kuzitaya ku malo wotayirako phulusa, kummawa kwa guwalo. ");
INSERT INTO nya_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Kenaka ayingʼambe pakati, koma asachotse mapiko. Ndipo wansembe ayiwotche pa nkhuni zimene zikuyaka pa guwa. Imeneyi ndi nsembe yopsereza, yowotcha pa moto ndiponso ya fungo lokomera Yehova. ");
INSERT INTO nya_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘Munthu wina aliyense akabwera ndi nsembe ya chakudya kwa Yehova, chopereka chake chizikhala ufa wosalala. Ufawo ausakanize ndi mafuta ndi lubani, ");
INSERT INTO nya_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ndipo apite nawo kwa ansembe, ana a Aaroni. Atapeko modzazitsa dzanja ufa wosalala uja kuti ukhale wachikumbutso pamodzi ndi mafuta ndi lubani ndipo atenthe zonsezi pa guwa lansembe kuti zilandiridwe ndi Yehova mʼmalo mwa chopereka chonse. Iyi ndi nsembe yotentha pa moto ndiponso fungo lokomera Yehova. ");
INSERT INTO nya_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Zotsala za nsembe ya chakudyazo ndi za Aaroni pamodzi ndi ana ake. Chimenechi ndi chigawo chopatulika kwambiri chifukwa chatapidwa pa chopereka chotentha pa moto cha Yehova. ");
INSERT INTO nya_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘Ukabweretsa nsembe ya chakudya chophika mu uvuni, ikhale ya buledi wa ufa wosalala wopanda yisiti koma wosakaniza ndi mafuta, kapena timitanda ta buledi topyapyala, topanda yisiti koma topaka mafuta. ");
INSERT INTO nya_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ngati nsembe yako yachakudya ndi yophika pa chitsulo chamoto, ikhale ya buledi wa ufa wosalala wopanda yisiti koma wosakaniza ndi mafuta. ");
INSERT INTO nya_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Umuduledule bulediyo ndi kumupaka mafuta; imeneyo ndi nsembe yachakudya. ");
INSERT INTO nya_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Ngati nsembe yako yachakudya ndi yophikidwa pa chiwaya, ikhale ya buledi wa ufa wosalala wosakaniza ndi mafuta. ");
INSERT INTO nya_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Munthu azibwera ndi nsembe za chakudya zimene wapanga ndi zinthu zimenezi. Atachipereka kwa wansembe, iyeyu adzipita nacho ku guwa. ");
INSERT INTO nya_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Wansembeyo atengeko gawo lina la nsembeyo kukhala ufa wachikumbutso kuti ilandiridwe ndi Yehova mʼmalo mwa nsembe yonse ndipo ayitenthe pa moto monga nsembe yopsereza ya fungo lokomera Yehova. ");
INSERT INTO nya_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Zotsala za nsembe ya chakudyayo zikhale za Aaroni ndi ana ake. Chimenechi ndi chigawo chopatulika kwambiri chifukwa chatapidwa pa chopereka chotentha pa moto cha Yehova. ");
INSERT INTO nya_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘Nsembe ya chakudya chilichonse imene ubweretsa kwa Yehova ikhale yopanda yisiti, pakuti suyenera kupereka kwa Yehova nsembe yotentha pa moto imene ili ndi yisiti kapena uchi. ");
INSERT INTO nya_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ziwirizi ungathe kubwera nazo kwa Yehova ngati chopereka cha zokolola zoyambirira. Koma usazitenthe pa guwa kuti zikhale fungo lokomera Yehova. ");
INSERT INTO nya_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Zopereka zako zonse zachakudya uzithire mchere. Usayiwale kuthira mchere pa chopereka chako popeza mcherewo ukusonyeza pangano pakati pa iwe ndi Mulungu wako. Tsono uzinthira mchere pa chopereka chako chilichonse. ");
INSERT INTO nya_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘Mukamapereka kwa Yehova chopereka cha chakudya choyamba kucha, choperekacho chikhale cha chipatso chatsopano chokazinga pa moto ndi chopunthapuntha. ");
INSERT INTO nya_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Uchithire mafuta ndi lubani pakuti ndi chopereka cha chakudya. ");
INSERT INTO nya_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Tsono wansembe atenthe gawo la chopereka chopunthapuntha chija kuti chikhala ufa wachikumbutso ndi cha mafuta pamodzi ndi lubani yense kuti Yehova alandire mʼmalo mwa zopereka zonse. Ichi ndi chopereka chotentha pa moto cha Yehova. ");
INSERT INTO nya_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘Ngati munthu apereka nsembe ya chiyanjano kwa Yehova, ndipo choperekacho nʼkukhala ngʼombe yayimuna kapena yayikazi, ikhale yopanda chilema. ");
INSERT INTO nya_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Munthuyo asanjike dzanja lake pamutu pa ngʼombeyo, ndipo ayiphere pa khomo la tenti ya msonkhano. Ndipo ansembe, ana a Aaroni, awaze magazi mbali zonse za guwalo. ");
INSERT INTO nya_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Pa nsembe yachiyanjanopo, ayenera kupatula zamʼkati mwa nyamayo ndi mafuta onse amene amakuta zamʼkati kupereka nsembe ya chakudya kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Apatulenso impsyo zonse ziwiri pamodzi ndi mafuta ake omwe ndiponso mafuta okuta chiwindi amene achotsedwa pamodzi ndi impsyo zija. ");
INSERT INTO nya_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Ndipo ana a Aaroni atenthe zimenezi pa guwa, pamwamba pa chopereka chopsereza chimene chili pa nkhuni zoyakazo. Imeneyi ndi nsembe yotentha pa moto, ya fungo lokomera Yehova. ");
INSERT INTO nya_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘Ngati munthu apereka nsembe ya chiyanjano kwa Yehova, choperekacho chikhale nkhosa yayimuna kapena yayikazi yopanda chilema. ");
INSERT INTO nya_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ngati apereka nsembe ya mwana wankhosa, abwere naye pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Asanjike dzanja lake pamutu pa nkhosayo ndipo ayiphere pa khomo la tenti ya msonkhano. Ndipo ana a Aaroni awaze magaziwo mbali zonse za guwalo. ");
INSERT INTO nya_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Pa nsembe yachiyanjanopo ayenera kuchotsa ndi kubweretsa: mafuta a nkhosayo, mchira wake wonse wonona atawudulira mʼtsinde pafupi ndi fupa la msana, zamʼkati zonse ndi mafuta onse amene akuta ziwalo zamʼkatimo, ");
INSERT INTO nya_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","impsyo zonse ziwiri pamodzi ndi mafuta amene akuta impsyozo, msonga ya chiwindi imene idzachotsedwere limodzi ndi impsyozo. ");
INSERT INTO nya_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Wansembe awotche zonsezi pa guwa. Ichi ndi chakudya chotentha pa moto choperekedwa kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘Ngati munthuyo apereka mbuzi ngati nsembe, abwere nayo kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Asanjike dzanja lake pamutu pa mbuziyo ndipo ayiphere pa khomo la tenti ya msonkhano. Ndipo ana a Aaroni awaze magazi ake mbali zonse za guwa. ");
INSERT INTO nya_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Tsono pa nsembe yoti iwotchedwe kukhala nsembe chakudya ya Yehova, achotse ndi kubweretsa: mafuta onse amene amaphimba zamʼkati kapena mafuta onse a mʼkatimo, ");
INSERT INTO nya_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","impsyo zonse ziwiri pamodzi ndi mafuta onse omwe akuta impsyozo ndi msonga ya chiwindi imene adzachotsera pamodzi ndi impsyo zija. ");
INSERT INTO nya_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Wansembe awotche zonsezi pa guwa. Ichi ndi chakudya cha Yehova, chowotcha pa moto ndiponso cha fungo lokomera Yehova. Mafuta onse ndi a Yehova. ");
INSERT INTO nya_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘Limeneli likhale lamulo lamuyaya pa mibado yanu yonse kuti musadzadye mafuta kapena magazi kulikonse kumene mudzakhale.’ ” ");
INSERT INTO nya_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Yehova anayankhula ndi Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Awuze Aisraeli kuti, ‘Munthu akachimwa mosadziwa ndi kuchita chilichonse chimene Yehova walamula kuti asachite, azichita izi: ");
INSERT INTO nya_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘Ngati wansembe wodzozedwa achimwa, ndi kuchimwitsa anthu onse, iyeyu ayenera kupereka mwana wangʼombe wamphongo wopanda chilema chifukwa cha tchimo limene wachitalo. Imeneyi ndi nsembe ya Yehova yopepesera tchimo lake. ");
INSERT INTO nya_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Wansembeyo abwere nayo ngʼombeyo pa khomo la tenti ya msonkhano pamaso pa Yehova. Asanjike dzanja lake pamutu pa ngʼombeyo ndipo ayiphe pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Kenaka wansembe wodzozedwa atengeko magazi a ngʼombeyo ndi kulowa nawo mu tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Iye aviyike chala chake mʼmagazi, ndipo awawaze kasanu ndi kawiri pamaso pa Yehova, patsogolo pa katani yotchinga malo wopatulika. ");
INSERT INTO nya_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Kenaka wansembe apake magaziwo pa nyanga za guwa lofukizira lubani limene lili pamaso pa Yehova mu tenti ya msonkhano. Magazi ena otsalawo awathire pa tsinde pa guwa lansembe zopsereza, limene lili pa khomo la tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Pambuyo pake achotse mafuta onse a ngʼombe yayimuna yopepesera machimoyo: mafuta okuta zamʼkati kapena mafuta onse amʼkatimo. ");
INSERT INTO nya_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Achotsenso ndi kubwera ndi impsyo zonse ziwiri pamodzi ndi mafuta onse ndiponso mafuta onse amene aphimba chiwindi ndi impsyo ");
INSERT INTO nya_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","monga momwe amachotsera mafuta a ngʼombe yoperekedwa kuti ikhale chopereka chachiyanjano. Tsono wansembe atenthe zimenezi pa guwa lansembe zopsereza. ");
INSERT INTO nya_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Koma chikopa cha ngʼombe yayimunayo ndi mnofu wake wonse, pamodzi ndi mutu ndi miyendo, zamʼkati ndi matumbo, ");
INSERT INTO nya_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","kapena kuti ngʼombe yonse yotsalayo apite nayo kunja kwa msasa ku malo woyeretsedwa, kumene amatayako phulusa ndi kuyitentha pa nkhuni, pa phulusapo. ");
INSERT INTO nya_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘Ngati gulu lonse la Aisraeli lichimwa mosadziwa, nachita chomwe ndi choletsedwa ndi Yehova, ngakhale kuti gulu lonselo silikudziwa kuti lachimwa, anthuwo ndi olakwa ndithu. ");
INSERT INTO nya_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Akazindikira tchimo limene achita, gulu lonse lipereke mwana wangʼombe wamphongo kuti akhale chopereka chopepesera tchimo ndipo abwere naye pa khomo la tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Akuluakulu a anthuwo asanjike manja awo pa mutu pa ngʼombe pamaso pa Yehova, ndipo ayiphe pomwepo pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Tsono wansembe wodzozedwa atengeko magazi a ngʼombeyo ndi kulowa nawo mu tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Aviyike chala chake mʼmagaziwo ndi kuwawaza pamaso pa Yehova kasanu ndi kawiri patsogolo pa nsalu yotchinga. ");
INSERT INTO nya_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Pambuyo pake iye apake magaziwo pa nyanga za guwa limene lili pamaso pa Yehova mu tenti ya msonkhano. Magazi ena otsalawo awathire pa tsinde pa guwa lansembe zopsereza limene lili pa khomo la tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Kenaka achotse mafuta onse a ngʼombeyo ndi kuwatentha pa guwa, ");
INSERT INTO nya_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ndipo achite ndi ngʼombe yayimunayi monga anachitira ndi ngʼombe yayimuna yopepesera machimo. Potero, wansembe adzapereka nsembe yopepesera anthu, ndipo machimo awo adzakhululukidwa. ");
INSERT INTO nya_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Kenaka atulutse ngʼombeyo kunja kwa msasa ndi kuyitentha monga anatenthera ngʼombe yoyamba ija. Imeneyi ndiyo nsembe yopepesera machimo a gulu lonse. ");
INSERT INTO nya_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘Ngati mtsogoleri achimwa mosadziwa nachita zimene ndi zoletsedwa ndi Yehova Mulungu wake, ndiye kuti wapalamula. ");
INSERT INTO nya_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Ndipo ngati wauzidwa za tchimo limene wachita, iye abwere ndi mbuzi yayimuna yopanda chilema kuti ikhale chopereka chake. ");
INSERT INTO nya_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Asanjike dzanja lake pa mutu wa mbuziyo ndi kuyiphera pamalo pamene amaphera zopereka zopsereza pamaso pa Yehova. Ichi ndi chopereka chopepesera tchimo. ");
INSERT INTO nya_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Pambuyo pake wansembe atengeko magazi a chopereka chopepesera tchimocho ndi chala chake, ndipo awapake pa nyanga za guwa lansembe zopsereza. Athire magazi otsalawo pa tsinde la guwalo. ");
INSERT INTO nya_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Wansembeyo atenthe mafuta onse pa guwapo monga amatenthera chopereka chachiyanjano. Pochita zimenezi, wansembe adzapereka nsembe yopepesera tchimo la munthuyo, ndipo adzakhululukidwa. ");
INSERT INTO nya_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘Ngati munthu wamba achimwa mosadziwa nachita zimene ndi zoletsedwa ndi Yehova, ndiye kuti wapalamula. ");
INSERT INTO nya_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Ndipo ngati wauzidwa za tchimo limene wachita, abweretse mbuzi yayikazi yopanda chilema kuti ikhale chopereka chopepesera tchimo. ");
INSERT INTO nya_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Asanjike dzanja lake pamutu pa mbuziyo ndipo ayiphe pamalo pamene amaphera chopereka chopsereza. ");
INSERT INTO nya_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Ndipo wansembe atenge magazi ndi chala chake ndi kuwapaka pa nyanga za guwa lansembe zopsereza ndi kuthira magazi wotsalawo pa tsinde la guwalo. ");
INSERT INTO nya_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Kenaka iye achotse mafuta onse monga momwe anachotsera mafuta a chopereka chachiyanjano, ndipo awatenthe pa guwa kuti akhale fungo lokomera Yehova. Potero, wansembe adzapereka nsembe yopepesera tchimo la munthuyo ndipo adzakhululukidwa. ");
INSERT INTO nya_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘Ngati munthu apereka mwana wankhosa ngati chopereka chopepesera tchimo lake, abwere ndi mwana wankhosa wamkazi wopanda chilema. ");
INSERT INTO nya_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Asanjike dzanja lake pa mutu wa mwana wankhosayo ndipo amuphe pamalo pamene amaphera chopereka chopsereza. ");
INSERT INTO nya_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Kenaka wansembe atengeko ndi chala chake magazi a mwana wankhosa uja ndi kuwapaka pa nyanga za guwa lansembe zopsereza. Magazi otsalawo athire pa tsinde la guwalo. ");
INSERT INTO nya_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Iye achotse mafuta onse, monga amachotsera mafuta a mwana wankhosa wa chopereka chachiyanjano, ndipo wansembe awatenthe pa guwa pamodzi ndi zopereka zina zopsereza za Yehova. Potero, wansembe adzapereka nsembe yopepesera tchimo limene munthuyo anachita ndipo adzakhululukidwa. ");
INSERT INTO nya_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘Ngati munthu anayitanidwa ku bwalo kuti akachitire umboni pa zimene anaziona kapena kuzimva koma iye nʼkukana kuchitira umboni, munthu ameneyo wachimwa ndipo ayenera kulangidwa. ");
INSERT INTO nya_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘Munthu akakhudza chinthu chilichonse chodetsedwa, monga nyama yakufa ya mʼthengo, kapena chiweto chakufa kapenanso chokwawa chakufa, ngakhale iyeyo wachikhudza mosadziwa, wasanduka wodetsedwa ndipo wachimwa. ");
INSERT INTO nya_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“ ‘Munthu akakhudza choyipitsa munthu cha mtundu uliwonse, ndipo pochikhudzapo ndi kuyipitsidwa nacho mosadziwa, munthuyo adzakhala wopalamula akangodziwa chimene wachitacho. ");
INSERT INTO nya_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“ ‘Munthu akalumbira mofulumira kapena mosasamala kuti adzachita chinthu, choyipa kapena chabwino, ngakhale kuti wachita izi mosadziwa kuti nʼkulakwa, pamene wazindira kulakwa kwake, iye adzakhalabe wopalamula akangodziwa chimene wachitacho. ");
INSERT INTO nya_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“ ‘Pamene munthu wazindikira kuti wachimwa motere, awulule tchimo limene wachitalo. ");
INSERT INTO nya_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Pambuyo pake, munthuyo abwere kwa Yehova ndi mwana wankhosa wamkazi kapena mbuzi kuti ikhale chopereka chopepesera tchimo ndipo wansembe achite mwambo wopepesera tchimo lomwe wachitalo. Tsono wansembe achite mwambo wopepesera tchimo la munthuyo. ");
INSERT INTO nya_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘Ngati munthuyo alibe mwana wankhosa, abweretse njiwa ziwiri kapena nkhunda ziwiri kwa Yehova ngati chopereka chopepesera tchimo lake. Imodzi ikhale nsembe yopepesera tchimo, ndipo inayo ikhale nsembe yopsereza. ");
INSERT INTO nya_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Tsono abwere nazo kwa wansembe, ndipo wansembeyo ayambe wapereka mbalame imodzi ngati yopepesera tchimo. Apotole khosi koma osayidula mutu, ");
INSERT INTO nya_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","kenaka awaze magazi a chopereka chopepesera tchimocho mʼmbali mwa guwa. Magazi ena onse awathire pa tsinde la guwa. Imeneyi ndi nsembe yopepesera tchimo. ");
INSERT INTO nya_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Pambuyo pake wansembe apereke mbalame inayo kuti ikhale chopereka chopsereza potsata mwambo wake. Wansembe atatha kupereka nsembe yopepesera tchimo limene munthu uja wachita, wochimwayo adzakhululukidwa. ");
INSERT INTO nya_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘Koma ngati munthuyo alibe njiwa ziwiri kapena nkhunda ziwiri, abweretse ufa wosalala wokwanira kilogalamu imodzi kuti ukhale chopereka chopepesera tchimo limene wachita. Asathiremo mafuta kapena lubani chifukwa ndi chopereka chopepesera tchimo. ");
INSERT INTO nya_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Abweretse ufawo kwa wansembe ndipo wansembeyo atapeko dzanja limodzi kuti ukhale ufa wachikumbutso ndi kuwutentha pa guwa pamodzi ndi chopereka chopsereza kwa Yehova. Imeneyi ndi nsembe yopepesera tchimo. ");
INSERT INTO nya_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Umu ndi mmene wansembe adzachitire mwambo wopepesera machimo ena aliwonse amene munthu wachita, ndipo munthuyo adzakhululukidwa. Zopereka zonse zotsala zidzakhala za wansembeyo monga momwe amachitira ndi chopereka chachakudya.’ ” ");
INSERT INTO nya_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Munthu akachita zinthu mosakhulupirika, nachimwa mosadziwa posapereka zinthu zopatulika zofunika kwa Yehova, munthuyo apereke kwa Yehova nsembe yopepesera machimo ake. Nsembeyo ikhale nkhosa yayimuna yopanda chilema ndipo mtengo wake ukhale wokwana masekeli oyenera a siliva pakawerengedwe ka ku Nyumba ya Mulungu. Imeneyi ndi nsembe yopepesera kupalamula. ");
INSERT INTO nya_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Munthuyo ayenera kubweza zinthu zopatulika zimene sanaperekezo. Awonjezepo chimodzi mwa zigawo zisanu zilizonse ndi kuzipereka zonsezo kwa wansembe amene adzachita mwambo wopepesera machimo a munthuyo, popereka nkhosa yayimuna ija ngati nsembe yopepesera ndipo wochimwayo adzakhululukidwa. ");
INSERT INTO nya_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Ngati munthu wachimwa mosadziwa pochita chilichonse chimene Yehova salola, munthuyo ndi wopalamula ndithu, ndipo ayenera kulangidwa. ");
INSERT INTO nya_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Abwere kwa wansembe ndi chopereka chopepesera kupalamula kwake. Chopereka chikhale nkhosa yayimuna yopanda chilema ndipo mtengo wake ukhale woyenera nsembe yopepesera kupalamula kumene anachimwa mosadziwako, ndipo munthuyo adzakhululukidwa. ");
INSERT INTO nya_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Imeneyi ndi nsembe yopepesera kupalamula popeza munthuyo wapezeka wolakwa pamaso pa Yehova.” ");
INSERT INTO nya_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Ngati munthu wina aliyense achimwa, nachita zinthu mosakhulupirika kwa Yehova chifukwa cha kunyenga mnzake pokana kumubwezera zimene anamusungitsa, kapena kumubera kapenanso kumulanda, ");
INSERT INTO nya_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","kapena ndi kunama kuti sanatole chinthu chimene chinatayika, kapena kulumbira mwachinyengo pa chinthu chilichonse chimene munthu akachita amachimwa nacho, ");
INSERT INTO nya_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ndi wopalamula ndithu, ndipo ayenera kubweza zimene anabazo, zimene analanda mwachinyengozo, zimene anamusungitsazo, zimene anatolazo ");
INSERT INTO nya_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","kapena zimene analumbira monyengazo. Pa tsiku limene apezeke kuti wapalamuladi, iye ayenera kumubwezera mwini wake zinthu zonsezi ndi kuwonjezerapo chimodzi mwa zigawo zisanu zilizonse. ");
INSERT INTO nya_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Pambuyo pake apereke kwa Yehova nsembe yopalamula. Nsembe yake ikhale nkhosa yayimuna yopanda chilema ndipo mtengo wake wogwirizana ndi nsembe yopepesera machimo. ");
INSERT INTO nya_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Kenaka wansembe achite mwambo wopepesera tchimo la munthuyo pamaso pa Yehova, ndipo adzakhululukidwa chilichonse chomwe anachita kuti akhale wopalamula.” ");
INSERT INTO nya_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Lamula Aaroni ndi ana ake kuti, ‘Lamulo la nsembe yopsereza ndi ili: Nsembe yopserezayo izikhala pa moto pa guwa usiku wonse mpaka mmawa, ndipo moto wa paguwapo uzikhala ukuyaka nthawi zonse. ");
INSERT INTO nya_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Tsono wansembe avale mkanjo wake wa nsalu yofewa ndi yosalala. Mʼkati avalenso kabudula wofewa, wosalala. Pambuyo pake atenge phulusa la nyama imene yatenthedwa pa guwa lansembe paja ndi kulithira pambali pa guwa lomwelo. ");
INSERT INTO nya_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Akatero avule zovala zakezo ndi kuvala zovala zina. Kenaka atulutse phulusalo ndi kukaliyika pa malo woyeretsedwa kunja kwa chithando. ");
INSERT INTO nya_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Moto wa pa guwa uzikhala ukuyaka nthawi zonse, usamazime. Mmawa uliwonse wansembe aziwonjezerapo nkhuni pa motopo ndi kukonza nsembe yopsereza, ndi kutentha mafuta a nsembe yachiyanjano pamenepo. ");
INSERT INTO nya_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Moto uzikhala ukuyaka pa guwa nthawi zonse ndipo usazimepo. ");
INSERT INTO nya_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘Lamulo la nsembe yachakudya ndi ili: ana a Aaroni azibwera nayo nsembeyo pamaso pa Yehova, patsogolo pa guwa. ");
INSERT INTO nya_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Wansembe mmodzi atapeko dzanja limodzi la ufa wosalala wa nsembe yachakudya ija kuti ukhala ufa wachikumbutso ndi mafuta pamodzi ndi lubani yense amene ali pa nsembe ya chakudyacho, ndipo azitenthe pa guwa kuti zilandiridwe ndi Yehova mʼmalo mwa nsembe yonse kuti zikhale nsembe ya fungo lokomera Yehova. ");
INSERT INTO nya_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Aaroni ndi ana ake azidya zimene zatsala koma azidya zopanda yisiti ku malo wopatulika, ku bwalo la tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Poziphika asathire yisiti. Ndawapatsa zotsalazo kuti zikhale gawo lawo la nsembe zanga zopsereza. Zonsezi ndi zopatulika kwambiri monga nsembe yopepesera tchimo ndiponso nsembe yopepesera machimo. ");
INSERT INTO nya_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Mwana aliyense wamwamuna wa Aaroni azidyako za nsembe zopsereza zopereka kwa Yehova. Ndi gawo lake lokhazikika la chopereka chopsereza kwa Yehova pa mibado yanu yonse. Chilichonse chimene chidzakhudza nsembezo chidzakhala chopatulika.’ ” ");
INSERT INTO nya_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Yehova anawuzanso Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Nsembe imene Aaroni ndi ana ake ayenera kupereka kwa Yehova pa tsiku limene wansembe akudzozedwa ndi iyi: ufa wosalala kilogalamu imodzi ngati chopereka chachakudya cha nthawi zonse. Azipereka theka limodzi mmawa ndipo theka linalo madzulo. ");
INSERT INTO nya_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Ipangidwe ndi mafuta pa chiwaya ndipo ubwere nayo ili yosakaniza bwino, yophikidwa mitandamitanda monga amachitira ndi nsembe yachakudya. Iphikidwe moti itulutse fungo lokomera Yehova. ");
INSERT INTO nya_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Mwana wa fuko la Aaroni amene adzadzozedwe kukhala wansembe kulowa mʼmalo mwa Aaroni ndiye amene azidzakonza ndi kupereka nsembeyi kwa Yehova nthawi zonse monga kunalembedwera. ");
INSERT INTO nya_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Nsembe iliyonse yachakudya ya wansembe izitenthedwa kwathunthu, isamadyedwe.” ");
INSERT INTO nya_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Yehova anawuza Mose kuti ");
INSERT INTO nya_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Uza Aaroni ndi ana ake kuti, ‘Malamulo a nsembe ya tchimo ndi awa: Nsembeyi iziphedwa pamaso pa Yehova pa malo pamene mumaphera nsembe yopsereza popeza ndi nsembe yopatulika. ");
INSERT INTO nya_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Wansembe amene apereke nsembeyi adyere ku malo wopatulika ndiye kuti mʼbwalo la tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Chilichonse chimene chidzakhudza nsembeyo chidzakhala chopatulika, ndipo ngati magazi ake agwera pa chovala, muchape chovalacho pa malo opatulika. ");
INSERT INTO nya_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Mʼphika wadothi umene aphikira nyamayo auphwanye. Koma ngati yaphikidwa mu mʼphika wa mkuwa, awukweche ndi kuwutsukuluza ndi madzi. ");
INSERT INTO nya_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Munthu wamwamuna aliyense wa mʼbanja la wansembe angathe kuyidya popeza nsembeyi ndi yopatulika kwambiri. ");
INSERT INTO nya_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Koma nsembe yopepesera tchimo imene magazi ake amabwera nawo mu tenti ya msonkhano kudzachita mwambo wopepesera tchimo ku malo opatulika isadyedwe, mʼmalo mwake itenthedwe.’ ” ");
INSERT INTO nya_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘Malamulo a nsembe yopepesera kupalamula imene ndi nsembe yopatulika kwambiri ndi awa: ");
INSERT INTO nya_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Nsembe yopepesera machimo iziphedwa pamalo pomwe amaphera nsembe yopsereza ndipo awaze magazi ake mbali zonse za guwa. ");
INSERT INTO nya_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Tsono apereke mafuta ake onse: mchira wamafuta ndi mafuta amene amakuta matumbo. ");
INSERT INTO nya_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Aperekenso impsyo ziwiri, mafuta ake pamodzi ndi mafuta onse amene ali chamʼchiwuno, ndiponso mafuta onse amene aphimba chiwindi. ");
INSERT INTO nya_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Wansembe azitenthe pa guwa kuti zikhale nsembe yotentha pa moto, yoperekedwa kwa Yehova. Imeneyi ndi nsembe yopepesera tchimo lopalamula. ");
INSERT INTO nya_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Munthu wamwamuna aliyense wa mʼbanja la wansembe angathe kudyako nsembeyo koma adyere ku malo opatulika. Imeneyi ndi nsembe yopatulika kwambiri. ");
INSERT INTO nya_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘Nsembe yopepesera tchimo lopalamula ndi yofanana ndi nsembe yoperekedwa chifukwa cha tchimo. Ndipo nsembe ziwiri zonsezi zili ndi lamulo limodzi lokha. Wansembe amene wachita mwambo wa nsembe yopepesera machimo a kupalamula atenge nyamayo ngati yake. ");
INSERT INTO nya_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Wansembe wopereka nsembe yopsereza ya munthu wina aliyense, atenge chikopa cha nsembe yopserezayo kuti chikhale chake. ");
INSERT INTO nya_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Chopereka chilichonse cha chakudya chophika mu uvuni kapena chokazinga mu mʼphika kapena mu chiwaya ndi cha wansembe amene wapereka nsembezo. ");
INSERT INTO nya_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Ndipo chopereka china chilichonse cha chakudya chosakaniza ndi mafuta kapena chowuma, chikhale cha ana onse a Aaroni ndipo anawo achigawane mofanana. ");
INSERT INTO nya_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘Malamulo a nsembe ya chiyanjano imene munthu angathe kupereka kwa Yehova ndi awa: ");
INSERT INTO nya_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘Ngati munthuyo apereka chifukwa cha kuthokoza, apereke nsembeyo pamodzi ndi makeke wopanda yisiti, osakaniza ndi mafuta; timitanda ta buledi wopanda yisiti, topyapyala, topaka mafuta, ndiponso makeke a ufa wosalala wophikidwa bwino, wosakaniza ndi mafuta. ");
INSERT INTO nya_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Pamodzi ndi nsembe yachiyanjano yothokozerayo abwerenso ndi makeke opangidwa ndi yisiti ngati chopereka chake. ");
INSERT INTO nya_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Munthuyo atenge mtanda umodzi pa mtanda wa buledi wa mtundu uliwonse kuti ukhale nsembe yopereka kwa Yehova. Tsono mtanda umenewo ndi wake wa wansembe amene awaze magazi a nsembe yachiyanjano. ");
INSERT INTO nya_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Nyama ya nsembe yachiyanjano yothokozera idyedwe pa tsiku lomwe nsembeyo yaperekedwa ndipo isatsaleko mpaka mmawa. ");
INSERT INTO nya_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘Koma ngati nsembe yakeyo apereka chifukwa cha lumbiro kapena mwaufulu, nsembeyo adye tsiku lomwe yaperekedwalo. Koma yotsala angathe kuyidya mmawa mwake. ");
INSERT INTO nya_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ngati nyama ina ya nsembe yatsalabe mpaka tsiku lachitatu, imeneyo itenthedwe pa moto. ");
INSERT INTO nya_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ngati munthu adya nyama yachiyanjano pa tsiku lachitatu, nsembeyo sidzalandiridwa. Amene wayipereka nsembeyo Mulungu sadzamulandira ndipo nsembeyo idzakhala yonyansa pamaso pa Mulungu, yosamupindulira kanthu woperekayo. ");
INSERT INTO nya_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘Nyama imene yakhudza chilichonse chodetsedwa, munthu asayidye, koma itenthedwe pa moto. Aliyense amene ali woyeretsedwa angathe kudya nyama inayo. ");
INSERT INTO nya_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Koma ngati munthu wina amene ndi wosayeretsedwa adya nyama ya nsembe yachiyanjano imene ndi ya Yehova, ameneyo achotsedwe pakati pa anthu a mtundu wake. ");
INSERT INTO nya_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Ndipo ngati munthu wina akhudza chinthu chodetsedwa, kaya chonyansa cha munthu kapena cha nyama, kapenanso chonyansa china chilichonse, ndipo kenaka nʼkudya nyama ya nsembe yachiyanjano imene ndi ya Yehova, munthu ameneyo achotsedwe pakati anthu a mtundu wake.’ ” ");
INSERT INTO nya_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Yehova anayankhula ndi Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Awuze Aisraeli kuti, ‘Musadye mafuta a ngʼombe, nkhosa kapenanso mbuzi. ");
INSERT INTO nya_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Mafuta a nyama yofa yokha, kapena mafuta a nyama yophedwa ndi zirombo akhoza kuwagwiritsa ntchito iliyonse, koma inu musadye mafuta amenewo. ");
INSERT INTO nya_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Pakuti munthu wakudya mafuta a nyama yoperekedwa kwa Yehova ngati nsembe yotentha pa moto, ayenera kuchotsedwa pakati pa anthu a mtundu wake. ");
INSERT INTO nya_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ndipo kulikonse kumene mukakhale musakadye magazi a mbalame iliyonse kapena magazi a nyama iliyonse. ");
INSERT INTO nya_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Ngati munthu aliyense adya magazi achotsedwe pakati pa anthu a mtundu wake.’ ” ");
INSERT INTO nya_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Yehova anayankhula ndi Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Awuze Aisraeli kuti, Aliyense amene apereka nsembe yachiyanjano kwa Yehova, abwere ndi gawo la nsembeyo kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Atenge ndi manja ake zigawo za chopereka zoyenera kuzitentha pa moto ngati chopereka kwa Yehova. Abweretse mafuta, pamodzi ndi chidale chomwe, ndipo chidalecho achiweyule kuti chikhale chopereka choweyula kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Wansembe atenthe mafutawo pa guwa koma chidalecho chikhale cha Aaroni ndi ana ake. ");
INSERT INTO nya_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Mumupatse wansembe ntchafu ya kumanja ya nsembe yanu yachiyanjano kuti ikhale chopereka chanu kwa iye. ");
INSERT INTO nya_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Mwana wa Aaroni amene amapereka magazi ndi mafuta a nsembe yachiyanjano, adzitenga ntchafu ya kumanja kukhala gawo lake. ");
INSERT INTO nya_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Choncho pa zopereka zachiyanjano za Aisraeli, Ine ndatengapo chidale chomwe amaweyula ndi ntchafu zimene amapereka nsembe ndipo ndazipereka kwa wansembe Aaroni ndi ana ake. Izi ndizo gawo lawo nthawi zonse pa zopereka za Aisraeli.” ");
INSERT INTO nya_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Zimenezi ndi chigawo cha Aaroni ndi ana ake chotapidwa pa zopereka kwa Yehova zoti zitenthedwe pa moto zimene zinaperekedwa pa tsiku limene anapatulidwa kuti akhale ansembe otumikira Yehova. ");
INSERT INTO nya_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Yehova ndiye analamulira kuti pa zopereka za Aisraeli azitapapo zimenezi ndi kuwapatsa ansembe ngati gawo lawo. Yehovayo analamula zimenezi pa tsiku limene ansembewo anapatulidwa ndipo anachikhazikitsa ngati lamulo la nthawi zonse. ");
INSERT INTO nya_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Awa ndi malamulo a nsembe izi: nsembe yopsereza, nsembe yachakudya, nsembe yopepesera machimo, nsembe yopepesera kupalamula, nsembe ya mwambo wodzoza ndi nsembe yachiyanjano. ");
INSERT INTO nya_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Malamulo amenewa Yehova anapereka kwa Mose pa Phiri la Sinai pa tsiku limene Yehova analamulira Aisraeli kuti abwere ndi zopereka za kwa Yehova, ku chipululu cha Sinai kuja. ");
INSERT INTO nya_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Tenga Aaroni ndi ana ake, zovala zawo, mafuta wodzozera, ngʼombe yayimuna kuti ikhale nsembe yopepesera machimo, nkhosa ziwiri zazimuna ndi dengu la buledi wopanda yisiti, ");
INSERT INTO nya_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ndipo usonkhanitse gulu la anthu pa khomo la tenti ya msonkhano.” ");
INSERT INTO nya_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mose anachita zomwe Yehova anamulamula ndipo gulu la anthu linasonkhana pa khomo la tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Mose anawuza gulu la anthuwo kuti, “Izi ndi zimene Yehova walamulira kuti zichitike.” ");
INSERT INTO nya_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Pamenepo Mose anabwera ndi Aaroni ndi ana ake nawasambitsa ndi madzi. ");
INSERT INTO nya_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Anamuveka Aaroni mwinjiro, ndi kumumanga lamba mʼchiwuno. Anamuvekanso mkanjo wa efodi ndi efodiyo. Anamangira lamba efodiyo amene analukidwa mwaluso uja, motero efodiyo analimba mʼchiwunomo. ");
INSERT INTO nya_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Anamuvekanso chovala chapachifuwa ndipo mʼchovalacho anayikamo Urimu ndi Tumimu. ");
INSERT INTO nya_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Kenaka anamuveka Aaroniyo nduwira kumutu ndipo patsogolo pa nduwirayo anayikapo duwa lagolide, chizindikiro chopatulika monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Pamenepo Mose anatenga mafuta wodzozera nadzoza tenti ya msonkhano pamodzi ndi zonse zimene zinali mʼmenemo, ndipo potero anazipatula. ");
INSERT INTO nya_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Anawaza mafuta ena pa guwa kasanu ndi kawiri, nalidzoza guwalo pamodzi ndi ziwiya zake zonse. Anadzozanso beseni ndi tsinde lake, nazipatula. ");
INSERT INTO nya_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Anathira mafuta wodzozera ena pamutu pa Aaroni ndipo anamudzoza ndi kumupatula. ");
INSERT INTO nya_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Kenaka anabwera ndi ana a Aaroni. Anawaveka minjiro, ndi kuwamanga malamba mʼchiwuno ndi kuwaveka nduwira kumutu monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Kenaka Mose anabwera ndi ngʼombe yayimuna ya nsembe yopepesera machimo, ndipo Aaroni ndi ana ake anasanjika manja awo pamutu pa ngʼombeyo. ");
INSERT INTO nya_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Mose anapha ngʼombeyo, ndi kutenga magazi ena angʼombeyo ndi kupaka ndi chala chake pa nyanga zaguwa lansembe, naliyeretsa. Magazi otsalawo anawakhuthulira pa tsinde laguwalo. Motero anachita mwambo wopepesera machimo. ");
INSERT INTO nya_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Mose anatenganso mafuta onse okuta matumbo, mafuta ophimba chiwindi, ndiponso impsyo zonse ziwiri pamodzi ndi mafuta ake, nazitentha pa guwapo. ");
INSERT INTO nya_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Koma nyama yangʼombeyo, chikopa chake ndi matumbo ake anaziwotcha kunja kwa msasa monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Kenaka anabwera ndi nkhosa yayimuna ya nsembe yopsereza, ndipo Aaroni ndi ana ake aamuna anasanjika manja awo pamutu pake. ");
INSERT INTO nya_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Ndipo Mose anapha nkhosayo ndi kuwaza magazi ake mbali zonse zaguwalo. ");
INSERT INTO nya_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Anayidula nkhosayo nthulinthuli ndipo anatentha mutu wake, nthulizo ndi mafuta. ");
INSERT INTO nya_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Anatsuka matumbo ake ndi miyendo yake, ndi kutentha nkhosa yonseyo pa guwa lansembe kuti ikhale nsembe yopsereza, fungo lokoma, nsembe yachakudya yoperekedwa kwa Yehova monga Yehovayo analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Kenaka Mose anapereka nkhosa yayimuna ina pamwambo wodzoza ansembe, ndipo Aaroni ndi ana ake aamuna anasanjika manja awo pamutu pake. ");
INSERT INTO nya_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Mose anayipha nkhosayo ndipo anatenga magazi ake ena ndi kupaka ndewere za khutu la kudzanja lamanja la Aaroni, pa chala chake chachikulu cha kudzanja lamanja, ndi pa chala chake chachikulu cha phazi lakumanja. ");
INSERT INTO nya_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Pambuyo pake Mose anabwera ndi ana aamuna a Aaroni ndi kupaka magazi pa ndewere za makutu awo akumanja, pa zala zawo zazikulu za dzanja lamanja, ndiponso pa zala zawo zazikulu za kuphazi lakumanja. Kenaka iye anawaza magazi otsalawo mbali zonse za guwalo. ");
INSERT INTO nya_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Anatenganso mafuta ake, mafuta a ku mchira wake, mafuta okuta matumbo, mafuta okuta chiwindi, impsyo zonse ziwiri ndi mafuta ake ndiponso ntchafu yakumanja. ");
INSERT INTO nya_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Ndipo mʼdengu la buledi wopanda yisiti limene linali pamaso pa Yehova, anatengamo buledi mmodzi, buledi mmodzi wokhala ndi mafuta a olivi, ndi buledi wopyapyala mmodzi. Zonsezi anaziyika pa mafuta aja ndi pa ntchafu ya ku dzanja lamanja ija. ");
INSERT INTO nya_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Mose anapereka zonsezi mʼmanja mwa Aaroni ndi ana ake amene anazipereka kwa Yehova kuti zikhale nsembe yoweyula. ");
INSERT INTO nya_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Kenaka Mose anazitenga mʼmanja mwawo ndipo anazipsereza pa guwa lansembe pamwamba penipeni pamodzi ndi nsembe yopsereza ija kuti ikhale nsembe yopereka pamwambo wodzoza ansembe, kuti ipereke fungo lokoma, chopereka chachakudya kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Mose anatenga chidale cha nkhosa yayimuna, chomwe ndi gawo lake pamwambo wodzoza ansembe, ndipo anachiweyula pamaso pa Yehova kuti chikhale nsembe yoweyula monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Kenaka Mose anatenga mafuta wodzozera ansembe ndi magazi amene anali pa guwa nawaza pa Aaroni ndi zovala zake ndiponso ana ake aja ndi zovala zawo. Motero Mose anapatula Aaroni ndi zovala zake, ndiponso ana ake ndi zovala zawo. ");
INSERT INTO nya_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Mose anawuza Aaroni ndi ana ake kuti, “Phikani nyamayo pa khomo la tenti ya msonkhano, ndipo mudyere pomwepo pamodzi ndi buledi amene ali mʼdengu la zopereka za pamwambo wodzoza ansembe monga Yehova analamulira kuti, ‘Aaroni ndi ana ake azidya zimenezi.’ ");
INSERT INTO nya_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ndipo nyama ndi buledi zotsalazo, muziwotche. ");
INSERT INTO nya_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Musatuluke kunja kwa tenti ya msonkhano kwa masiku asanu ndi awiri mpaka masiku amwambo wokudzozani unsembe atatha, pakuti mwambowu ndi wa masiku asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Zimene zachitika lerozi analamula ndi Yehova kuti zichitike ngati nsembe yopepesera machimo anu. ");
INSERT INTO nya_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Muzikhala pa khomo la tenti ya msonkhano usana ndi usiku kwa masiku asanu ndi awiri. Ndipo muzichita zimene Yehova wakulamulani kuti musafe, pakuti zimenezi ndi zomwe Yehova wandilamulira.” ");
INSERT INTO nya_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Choncho Aaroni ndi ana ake anachita zonse zimene Yehova analamula kudzera mwa Mose. ");
INSERT INTO nya_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Pa tsiku lachisanu ndi chitatu Mose anayitana Aaroni, ana ake ndi akuluakulu a Aisraeli. ");
INSERT INTO nya_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Ndipo anawuza Aaroni kuti, “Tenga mwana wangʼombe wamwamuna kuti akhale nsembe yako yopepesera machimo ndi nkhosa yayimuna kuti ikhale nsembe yopsereza. Zonsezi zikhale zopanda chilema ndipo uzipereke pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Kenaka uwawuze Aisraeli kuti, ‘Tengani mbuzi yayimuna kuti ikhale nsembe yopepesera machimo. Mutengenso mwana wangʼombe ndi mwana wankhosa. Zonsezi zikhale za chaka chimodzi ndi zopanda chilema kuti zikhale nsembe yopsereza. ");
INSERT INTO nya_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Mutengenso ngʼombe yayimuna ndi nkhosa yayimuna kuti zikhale nsembe yachiyanjano zoti ziperekedwe pamaso pa Yehova. Pamodzi ndi izi mubwerenso ndi nsembe yachakudya yosakaniza ndi mafuta pakuti lero Yehova akuonekerani.’ ” ");
INSERT INTO nya_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Anthu anatenga zonse zimene Mose analamula nabwera nazo pa khomo la tenti ya msonkhano. Gululo linasendera pafupi ndi kuyima pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Tsono Mose anati, “Izi ndi zimene Yehova walamula kuti muchite kuti ulemerero wa Yehova ukuonekereni.” ");
INSERT INTO nya_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Pambuyo pake Mose anawuza Aaroni kuti, “Sendera pafupi ndi guwa ndipo upereka nsembe yako yopepesera machimo ndi nsembe yako yopsereza ndikuchita mwambo wopepesera machimo ako ndi machimo a anthu. Anthuwa apereke nsembe zawo zopepesera machimo monga momwe Yehova walamulira.” ");
INSERT INTO nya_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Choncho Aaroni anasendera pafupi ndi guwa, napha mwana wangʼombe uja kukhala nsembe yake yopepesera machimo. ");
INSERT INTO nya_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ana a Aaroni anabwera ndi magazi kwa Aaroni ndipo iye anaviyika chala chake mʼmagaziwo, nawapaka pa nyanga za guwa. Magazi wotsalawo anawathira pa tsinde la guwalo. ");
INSERT INTO nya_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Kenaka anatentha paguwapo, mafuta, impsyo pamodzi ndi mafuta amene amakuta chiwindi ngati nsembe yopepesera machimoyo, monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Koma nyama ndi chikopa anazitenthera kunja kwa msasa. ");
INSERT INTO nya_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Kenaka anapha nsembe yopsereza. Ana a Aaroni atabwera ndi magazi kwa iye, Aaroniyo anawawaza mbali zonse za guwa. ");
INSERT INTO nya_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ana akewo anamupatsa nyama yoduladula ya nsembe yopsereza ija pamodzi ndi mutu ndipo anazitentha pa guwa. ");
INSERT INTO nya_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Aaroni anatsuka matumbo ndi miyendo nazitentha pa guwa pamodzi ndi nsembe yopsereza ija. ");
INSERT INTO nya_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Kenaka Aaroni anapereka zopereka za anthuwo. Anatenga mbuzi yopepesera machimo a anthuwo, yopereka chifukwa cha tchimo, nayipha ndi kuyipereka kuti ikhale yopepesera machimo monga anachitira ndi nsembe yoyamba ija. ");
INSERT INTO nya_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Anabwera ndi nsembe yopsereza, nayipereka potsata mwambo wake. ");
INSERT INTO nya_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Anabweranso ndi chopereka cha chakudya. Anatapa ufa dzanja limodzi ndi kutentha pa guwa, kuwonjezera pa nsembe yopsereza ya mmawa ija. ");
INSERT INTO nya_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Tsono Aaroni anapha ngʼombe ndi nkhosa yayimuna monga nsembe yachiyanjano ya anthu. Ana ake anamupatsira magazi ndipo anawawaza mbali zonse za guwa. ");
INSERT INTO nya_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Anamupatsiranso mafuta a ngʼombeyo ndi nkhosa yayimunayo: mchira wamafuta, mafuta wokuta matumbo, impsyo ndi mafuta wokuta chiwindi. ");
INSERT INTO nya_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Ana a Aaroni anayika mafutawo pa zidale. Pambuyo pake Aaroni anatentha mafutawo pa guwa lansembe. ");
INSERT INTO nya_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Koma zidale ndi ntchafu ya kumanja Aaroni anaziweyula ngati chopereka choweyula pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Kenaka Aaroni anakweza manja ake pa anthuwo nawadalitsa. Ndipo atatha kupereka nsembe yopepesera machimo, nsembe yopsereza ndi nsembe yachiyanjano, anatsika pa guwapo. ");
INSERT INTO nya_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Ndipo Mose pamodzi ndi Aaroni analowa mu tenti ya msonkhano. Atatulukamo anadalitsa anthuwo ndipo ulemerero wa Yehova unaonekera kwa anthu onse. ");
INSERT INTO nya_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Pomwepo moto unatuluka pamaso pa Yehova niwutentha nsembe zopsereza ndi mafuta zimene zinali pa guwa. Anthu onse ataona zimenezi anafuwula mwachimwemwe ndipo anaweramitsa nkhope zawo pansi. ");
INSERT INTO nya_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Ana a Aaroni, Nadabu ndi Abihu, aliyense anatenga chofukizira lubani chake nayikamo makala a moto ndi kuthiramo lubani. Iwo anapereka pamaso pa Yehova moto wachilendo, moto umene Yehova sanawalamule. ");
INSERT INTO nya_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Choncho moto unatuluka pamaso pa Yehova ndi kuwapsereza, ndipo anafa pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Pamenepo Mose anawuza Aaroni kuti, “Pajatu Yehova ananena kuti, “ ‘Kwa iwo amene amandiyandikira ndidzaonetsa ulemerero wanga; pamaso pa anthu onse ndidzalemekezedwa.’ ” Aaroni anakhala chete wosayankhula. ");
INSERT INTO nya_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mose anayitana Misaeli ndi Elizafani, ana a Uzieli, abambo angʼono a Aaroni, ndipo anawawuza kuti, “Bwerani kuno mudzachotse abale anuwa pa malo wopatulika ndi kuwatulutsira kunja kwa msasa.” ");
INSERT INTO nya_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Choncho anabwera atavala minjiro yawo ndipo anawatenga ndi kuwatulutsa kunja kwa msasawo monga momwe Mose analamulira. ");
INSERT INTO nya_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Ndipo Mose anawuza Aaroni ndi ana ake Eliezara ndi Itamara kuti, “Musalileke tsitsi lanu nyankhalala ndipo musangʼambe zovala zanu kuti mungafe, ndi mkwiyo wa Yehova ungagwere anthu onsewa. Koma abale anu okha, kutanthauza fuko lonse la Israeli ndiwo ayenera kulira omwalira aja amene Yehova wawapsereza ndi moto. ");
INSERT INTO nya_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Musatuluke kunja kwa tenti ya msonkhano, mungafe, chifukwa munadzozedwa ndi mafuta a Yehova kukhala ansembe.” Choncho iwo anachita monga Mose ananenera. ");
INSERT INTO nya_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Pambuyo pake Yehova anayankhula ndi Aaroni nati, ");
INSERT INTO nya_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Iwe ndi ana ako musamamwe vinyo kapena chakumwa chilichonse choledzeretsa pamene mukulowa mu tenti ya msonkhano kuti mungafe. Ili ndi lamulo lamuyaya pa mibado yanu yonse. ");
INSERT INTO nya_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Muzisiyanitsa pakati pa zinthu zopatulika ndi zinthu wamba, pakati pa zinthu zodetsedwa ndi zinthu zoyeretsedwa, ");
INSERT INTO nya_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","ndipo muyenera kuphunzitsa Aisraeli onse malamulo amene Yehova wakupatsani kudzera mwa Mose.” ");
INSERT INTO nya_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mose anawuza Aaroni ndi ana ake otsalawo, Eliezara ndi Itamara kuti, “Tengani zopereka zachakudya zopanda yisiti zimene zatsala pa nsembe zopsereza za kwa Yehova ndipo muzidye pafupi ndi guwa pakuti ndi zopatulika kwambiri. ");
INSERT INTO nya_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Muzidye pa malo wopatulika chifukwa zimenezi ndi gawo lako ndi la ana ako pa zopereka zopsereza kwa Yehova. Izitu ndi zimene Yehova anandilamulira. ");
INSERT INTO nya_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Koma iwe pamodzi ndi ana ako aamuna ndi aakazi muzidya chidale chimene chinaweyulidwa ndi ntchafu zimene zinaperekedwa nsembe. Muzidye pamalo woyeretsedwa. Zimenezi zaperekedwa kwa iwe ndi ana ako monga gawo lanu pa zopereka zachiyanjano zimene apereka Aisraeli. ");
INSERT INTO nya_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ntchafu imene inaperekedwayo ndi chidale chomwe chinaweyulidwacho abwere nazo pamodzi ndi nsembe ya mafuta ya Yehova yotentha pa moto, ndipo uziweyule kuti zikhale zopereka zoweyula pamaso pa Yehova. Zimenezi zizikhala zako ndi ana ako nthawi zonse monga walamulira Yehova.” ");
INSERT INTO nya_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Pambuyo pake Mose anafunafuna mbuzi ya nsembe yopepesera machimo koma anapeza kuti anayitentha kale. Apa Mose anakalipira Eliezara ndi Itamara, ana a Aaroni otsala aja nati, ");
INSERT INTO nya_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Chifukwa chiyani simunadyere pamalo wopatulika nsembe yopepesera machimo ija? Kodi imene ija siyopatulika? Kodi Yehova sanapereke nyamayo kwa inu kuti muchotse machimo a mpingo wonse powachitira mwambo wa nsembe yopepesera machimo pamaso pa Yehova? ");
INSERT INTO nya_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Pakuti magazi ake sanalowe nawo ku Malo Wopatulika, mukanadya nyama ya mbuziyo pa malo wopatulikawo monga Yehova analamulira.” ");
INSERT INTO nya_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aaroni anamuyankha Mose kuti, “Lero anthu apereka nsembe yawo yopepesera machimo ndiponso nsembe yawo yopsereza pamaso pa Yehova komabe zinthu zoterezi zandichitikira. Kodi Yehova akanakondwa ndikanadya nsembe yopepesera machimo lero?” ");
INSERT INTO nya_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Pamene Mose anamva zimenezi, anakhutira. ");
INSERT INTO nya_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Yehova anayankhula ndi Mose ndi Aaroni kuti, ");
INSERT INTO nya_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Awuze Aisraeli kuti, ‘Nyama zomwe mukhoza kudya mwa nyama zonse za dziko lapansi ndi izi: ");
INSERT INTO nya_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Nyama iliyonse imene ili ndi chipondero chogawikana pakati ndi yobzikula mukhoza kudya. ");
INSERT INTO nya_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘Koma pali nyama zina zimene zimabzikula kokha kapena ndi zogawikana zipondero zimene simukuyenera kudya. Nyama zimenezi ndi ngamira, ngakhale imabzikula ilibe zipondero zogawikana. Choncho ndi yodetsedwa, musadye. ");
INSERT INTO nya_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Ina ndi mbira, ngakhale imabzikula, zipondero zake nʼzosagawikana. Choncho ndi yodetsedwa, musadye. ");
INSERT INTO nya_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Inanso ndi kalulu, ngakhale amabzikula, zipondero zake nʼzosagawikana. Choncho ndi wodetsedwa, musadye. ");
INSERT INTO nya_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Nkhumba simabzikula ngakhale ili ndi zipondero zogawikana. Choncho ndi yodetsedwa, musadye. ");
INSERT INTO nya_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Musamadye nyama yake kapena kukhudza imene yafa chifukwa ndi yodetsedwa. ");
INSERT INTO nya_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘Mwa zamoyo zonse zimene zimakhala mʼmadzi a mʼnyanja ndi a mʼmitsinje mukhoza kudya chilichonse chimene chili ndi minga ya pa msana ndi mamba. ");
INSERT INTO nya_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Koma zamoyo zonse za mʼnyanja kapena za mʼmitsinje zimene zilibe minga ya pa msana ndi mamba, kaya ndi tizirombo tonse ta mʼmadzi ndi zamoyo zonse zopezeka mʼmenemo ndi zodetsedwa kwa inu. ");
INSERT INTO nya_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Pakuti zimenezi ndi zodetsedwa kwa inu, nyama yake musadye, ndipo zikafa zikhalebe zodetsedwa kwa inu. ");
INSERT INTO nya_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Chamoyo chilichonse cha mʼmadzi chimene chilibe minga ya pa msana kapena mamba ndi chodetsedwa kwa inu. ");
INSERT INTO nya_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘Mbalame zimene simukuyenera kudya chifukwa ndi zodetsedwa ndi izi: mphungu, nkhwazi, mwimba, ");
INSERT INTO nya_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","nankapakapa, akamtema a mitundu yonse, ");
INSERT INTO nya_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","akhungubwi a mitundu yonse, ");
INSERT INTO nya_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","kadzidzi wamphondo, kadzidzi wodzuma, chipudo ndi mtundu uliwonse wa akabawi ");
INSERT INTO nya_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","kadzidzi wamngʼono, chiswankhono ndi mantchichi, ");
INSERT INTO nya_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","tsekwe, vuwo, dembo, ");
INSERT INTO nya_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","indwa, zimeza za mitundu yonse, nsadzu ndi mleme. ");
INSERT INTO nya_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘Zowuluka zonse za miyendo inayi ndi zodetsedwa. ");
INSERT INTO nya_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Komabe mwa zowuluka zokhala ndi miyendo inayi zimene mukhoza kudya ndi zokhazo zimene zili ndi miyendo yolumphira. ");
INSERT INTO nya_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Pa zimenezo mungathe kudya izi: dzombe la mitundu yonse, atsokonombwe a mitundu yonse, nkhululu za mitundu yonse, ndi ziwala za mitundu yonse. ");
INSERT INTO nya_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Koma za mapiko zina zonse zokhala ndi miyendo inayi muzitenge kukhala zodetsedwa kwa inu. ");
INSERT INTO nya_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘Zimenezi zidzakudetsani. Aliyense wozikhudza zitafa adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Aliyense wonyamula chiwalo chilichonse cha nyama zakufazo ayenera kuchapa zovala zake, ndipo adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘Nyama iliyonse imene ili ndi ziboda zogawikana koma mapazi ake wosagawikana, kapena imene sibzikula muyiyese yodetsedwa kwa inu ndipo munthu aliyense akakhudza nyama yakufayo, adzakhala wodetsedwa. ");
INSERT INTO nya_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Mwa nyama zonse zoyenda ndi miyendo inayi, nyama zonse zokhala ndi zikhadabo kuphazi muzitenge kukhala zodetsedwa ndipo aliyense wozikhudza zitafa adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Aliyense wonyamula nyamazi zitafa ayenera kuchapa zovala zake, ndipo adzakhala wodetsedwa mpaka madzulo. Zimenezi ndi zodetsedwa kwa inu. ");
INSERT INTO nya_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘Mwa nyama zokwawa, zimene zili zodetsedwa kwa inu ndi izi: likongwe, mbewa, msambulu za mitundu yonse, ");
INSERT INTO nya_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","gondwa, mngʼazi, buluzi, dududu ndi nanzikambe. ");
INSERT INTO nya_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Mwa nyama zonse zoyenda pansi, zimenezi ndi zodetsedwa kwa inu. Munthu aliyense wozikhudza zitafa adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Iliyonse mwa nyama zimenezi ikafa ndi kugwera pa chiwiya chilichonse, kaya chimagwira ntchito yotani, kaya ndi chopangidwa ndi mtengo, kaya ndi cha nsalu, kaya ndi cha chikopa kapena chiguduli chiwiyacho chidzakhala chodetsedwa. Muchiviyike mʼmadzi chiwiyacho komabe chidzakhala chodetsedwa mpaka madzulo, ndipo kenaka chidzakhala choyeretsedwa. ");
INSERT INTO nya_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Tsono nyama ina iliyonse mwa zimenezi ikagwera mʼmbiya ya dothi, ndiye kuti chilichonse cha mʼmbiyamo chidzakhala chodetsedwa, ndipo muyenera kuswa mbiyayo. ");
INSERT INTO nya_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Chakudya chilichonse chimene mungadye chikakhala kuti chathiridwa mʼmbiyamo, ndiye kuti chakudyacho chidzakhala chodetsedwa, ndipo madzi akumwa wochokera mʼmbiya zotere ndi wodetsedwa. ");
INSERT INTO nya_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Chiwalo chilichonse cha nyama yakufa chikagwera pa chinthu chilichonse kaya pa uvuni, kapena pa mʼphika, ndiye kuti zinthuzo zidzakhala zodetsedwa, ndipo ziphwanyidwe popeza ndi zodetsedwa. ");
INSERT INTO nya_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Koma kasupe kapena chitsime chamadzi chidzakhala choyeretsedwa ngakhale kuti chilichonse chokhudza nyama yakufayo chidzakhala chodetsedwa. Zimenezi muzitenge kukhala zodetsedwa. ");
INSERT INTO nya_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Chiwalo chilichonse cha nyama yakufayo chikagwera pa mbewu zimene akuti adzale, mbewu zimenezo zidzakhalabe zabwino. ");
INSERT INTO nya_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Koma mbewuzo zikakhala zonyowa ndi madzi, ndipo chiwalo chilichonse cha nyama zakufazo chikagwera pa mbewuzo, mbewuzo zikhale zodetsedwa kwa inu. ");
INSERT INTO nya_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘Ngati nyama imene mumaloledwa kudya yafa yokha, ndiye kuti aliyense wokhudza nyama yakufayo adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Aliyense amene adyako nyama yakufayo achape zovala zake, ndipo adzakhala wodetsedwa mpaka madzulo. Aliyense amene wanyamula nyama yakufayo ayenera kuchapa zovala zake, ndipo adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘Chinthu chilichonse chokwawa pansi ndi chonyansa, simuyenera kudya. ");
INSERT INTO nya_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Musadye chilichonse chokwawa pansi, choyenda chamimba kapena choyenda ndi miyendo inayi kapenanso yambiri popeza ndi chodetsedwa. ");
INSERT INTO nya_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Musadzisandutse nokha odetsedwa ndi chokwawa chilichonse. Musadziyipitse nazo, kuti mukhale odetsedwa. ");
INSERT INTO nya_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Ine ndine Yehova Mulungu wanu, choncho dziyeretseni kuti mukhale woyera, chifukwa Ine ndine woyera. Musadzisandutse odetsedwa ndi chokwawa chilichonse. ");
INSERT INTO nya_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ine ndine Yehova amene ndinakutulutsani ku Igupto kuti ndikhale Mulungu wanu. Tsono mukhale woyera, chifukwa Ine ndine woyera. ");
INSERT INTO nya_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘Amenewa ndi malamulo onena za nyama, mbalame, chamoyo chilichonse choyenda mʼmadzi ndiponso chamoyo chilichonse chokwawa. ");
INSERT INTO nya_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Muzisiyanitsa pakati pa chodetsedwa ndi choyeretsedwa, komanso pakati pa zomwe mutha kudya ndi zomwe simuyenera kudya.’ ” ");
INSERT INTO nya_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Yehova anayankhula ndi Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Awuze Aisraeli kuti, ‘Mkazi akakhala woyembekezera, nabala mwana wa mwamuna, mkaziyo adzakhala wodetsedwa kwa masiku asanu ndi awiri, ngati pa masiku ake akusamba. ");
INSERT INTO nya_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Pa tsiku lachisanu ndi chitatu, mwanayo achite mdulidwe. ");
INSERT INTO nya_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Mkaziyo adikire masiku ena 33 kuti ayeretsedwe ku matenda ake. Asakhudze kanthu kalikonse koyera kapena kulowa mʼmalo wopatulika mpaka masiku a kuyeretsedwa kwake atatha. ");
INSERT INTO nya_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ngati abala mwana wamkazi, adzakhala wodetsedwa kwa masabata awiri, monga zikhalira pa nthawi yake yosamba. Ndipo mkaziyo adikire masiku ena 66, kuti ayeretsedwe ku matenda akewo. ");
INSERT INTO nya_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘Masiku ake wodziyeretsa akatha, kaya ndi a mwana wamwamuna kapena a mwana wamkazi, abwere kwa wansembe ndi mwana wankhosa wa chaka chimodzi pa khomo la tenti ya msonkhano kuti ikhale nsembe yopsereza. Abwerenso ndi chiwunda cha nkhunda kapena njiwa kuti ikhale nsembe yopepesera machimo. ");
INSERT INTO nya_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Wansembeyo apereke zimenezi pamaso pa Yehova pochita mwambo wopepesera mkaziyo. Ndipo mkaziyo adzakhala woyeretsedwa ku msambo wake. “ ‘Amenewa ndiwo malamulo a mkazi amene wabala mwana wamwamuna kapena wamkazi. ");
INSERT INTO nya_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Ngati mkaziyo sangathe kupeza mwana wankhosa, abwere ndi njiwa ziwiri kapena mawunda ankhunda awiri: imodzi ikhale ya nsembe yopsereza ndipo inayo ikhale ya nsembe yopepesera machimo. Tsono wansembe achite mwambo wopepesera wa mkaziyo ndipo adzayeretsedwa.’ ” ");
INSERT INTO nya_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Yehova anawuza Mose ndi Aaroni kuti, ");
INSERT INTO nya_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Munthu akakhala ndi chithupsa, kapena mʼbuko, kapena chikanga pa thupi lake chimene chitha kusanduka nthenda ya khate, abwere naye munthuyo kwa Aaroni wansembe kapena kwa mmodzi mwa ana ake amene ndi ansembe. ");
INSERT INTO nya_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Tsono wansembe ayangʼanitsitse nthendayo pa khungupo, ndipo ngati ubweya wa pamalo pamene pali nthendapo wasanduka woyera, komanso kuti nthendayo yazama mʼkati kupitirira khungu, ndiye kuti nthendayo ndi khate. Wansembe akamuonetsetsa alengeze kuti ndi wodetsedwa. ");
INSERT INTO nya_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ngati chikanga cha pa khungulo chikuoneka choyera, ndipo kuya kwake sikukuonekera kuti kwapitirira khungu ndi ubweya wake pamalopo sunasanduke woyera, wansembe amuyike wodwalayo padera kwa masiku asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Pa tsiku lachisanu ndi chiwiri wansembe amuonenso bwino wodwalayo. Ndipo ngati waona kuti nthendayo sinasinthe ndipo sinafalikire pa khungu, amuyikenso wodwalayo padera kwa masiku ena asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Pa tsiku lachisanu ndi chiwiri wansembeyo amuonenso bwino munthuyo, ndipo ngati nthendayo yazima ndi kusafalikira pa khungu, wansembe amutchule munthuyo kuti ndi woyera. Umenewo unali mʼbuko chabe. Choncho munthuyo achape zovala zake ndipo adzakhala woyera. ");
INSERT INTO nya_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Koma ngati mʼbukowo ufalikira pakhungu atakadzionetsa kale kwa wansembe ndipo wansembeyo nʼkulengeza kuti munthuyo ndi woyeretsedwa, ndiye kuti apitenso kukadzionetsa kwa wansembeyo. ");
INSERT INTO nya_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Wansembe amuonetsetsenso munthuyo, ndipo ngati mʼbukowo wafalikira pa khungu, wansembe alengeze kuti munthuyo ndi wodetsedwa ndi kuti nthendayo ndi khate. ");
INSERT INTO nya_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Ngati munthu aliyense ali ndi nthenda ya pakhungu yoyipitsa thupi, wodwalayo abwere naye kwa wansembe. ");
INSERT INTO nya_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Wansembe amuonetsetse munthuyo, ndipo ngati ali ndi chithupsa chamaonekedwe woyera pa khungupo chimene chasandutsa ubweya wa pamalopo kukhala woyera, ndipo ngati pali zilonda pa chotupacho, ");
INSERT INTO nya_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","limenelo ndi khate lachikhalire la pa khungu, ndipo wansembe alengeze kuti munthuyo ndi wodetsedwa. Asamutsekere munthu woteroyo pakuti ndi wodetsedwa kale. ");
INSERT INTO nya_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Ndipo ngati, mʼkuona kwa wansembe, khate lija lafalikira pa khungu lonse moti lamugwira thupi lonse kuyambira kumutu mpaka kumapazi, ");
INSERT INTO nya_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","wansembe amuonetsetse munthuyo, ndipo ngati khatero lagwira thupi lake lonse, wansembe alengeze kuti munthuyo ndi woyera. Popeza kuti thupi lonse lasanduka loyera, munthuyo ndi woyeretsedwa. ");
INSERT INTO nya_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Koma pa tsiku limene zilonda zidzaoneka pa iye, munthuyo adzakhala wodetsedwa. ");
INSERT INTO nya_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Wansembe aonetsetse zilondazo ndipo alengeze kuti munthuyo ndi wodetsedwa. Zilondazo ndi zodetsedwa ndipo ili ndi khate. ");
INSERT INTO nya_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Koma zilondazo zikasinthika ndi kusanduka zoyera, munthuyo ayenera kupita kwa wansembe. ");
INSERT INTO nya_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Wansembe amuonetsetse ndipo ngati zilondazo zasanduka zoyera, wansembe amutchule wodwalayo kuti ndi woyera ndipo adzakhala woyera ndithu. ");
INSERT INTO nya_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Ngati pa khungu la munthu wodwalayo pali chithupsa chimene chinapola kale, ");
INSERT INTO nya_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ndipo pamalo pamene panali chithupsacho pakatuluka chotupa choyera kapena banga loyera mofiirira, munthuyo ayenera kukadzionetsa kwa wansembe. ");
INSERT INTO nya_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Wansembe aonetsetse bwino ndipo ngati chikuoneka kuti chazama, ndipo ubweya wa pamalopo wasanduka woyera, wansembe alengeze kuti munthuyo ndi wodetsedwa. Imeneyo ndi nthenda ya khate imene yatuluka mʼchithupsacho. ");
INSERT INTO nya_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Koma ngati wansembe waonetsetsa napeza kuti palibe ubweya woyera ndipo chithupsacho sichinazame, koma chazimirira, wansembeyo amuyike padera wodwalayo kwa masiku asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Ngati nthendayo ikufalikira pa khungu, wansembe alengeze kuti munthuyo ndi wodetsedwa. Limeneli ndi khate. ");
INSERT INTO nya_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Koma bangalo likakhala malo amodzi, wosafalikira, chimenecho ndi chipsera cha chithupsacho, ndipo wansembe alengeze kuti munthuyo ndi woyera. ");
INSERT INTO nya_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Munthu akakhala ndi bala lamoto pa khungu lake, ndipo chilonda cha balalo chikasanduka banga loyera mofiirira kapena loyera, ");
INSERT INTO nya_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","wansembe aonetsetse bangalo, ndipo ngati ubweya wa pa bangapo usanduka woyera, ndipo balalo lioneka kuti ndi lozama, limenelo ndi khate lomwe latuluka pa balalo. Wansembe alengeze kuti munthuyo ndi wodetsedwa. Limenelo ndi khate la pa khungu. ");
INSERT INTO nya_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Koma ngati wansembe waonetsetsa balalo ndipo palibe ubweya woyera, ndipo ngati balalo silinazame ndi kuti lazirala, wansembe amuyike padera wodwalayo kwa masiku asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Pa tsiku lachisanu ndi chiwiri wansembe amuonenso wodwalayo, ndipo ngati bangalo lafalikira pa khungu, wansembe alengeze kuti munthuyo ndi wodetsedwa. Limenelo ndi khate. ");
INSERT INTO nya_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Koma ngati bangalo likhala pa malo amodzi wosafalikira pa khungu, ndipo lazimirira, limenelo ndi thuza la bala lamoto, ndipo wansembe alengeze kuti munthuyo ndi woyera. Chimenecho ndi chipsera chamoto. ");
INSERT INTO nya_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Mwamuna kapena mkazi akakhala ndi nthenda kumutu kapena ku chibwano, ");
INSERT INTO nya_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","wansembe aonetsetse balalo ndipo likaoneka kuti lazama, ndipo ubweya wa pamalopo wasanduka wachikasu ndi wonyololoka, wansembe alengeze kuti munthuyo ndi wodetsedwa. Zimenezo ndi mfundu zonyerenyetsa, khate lakumutu kapena ku chibwano. ");
INSERT INTO nya_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Koma wansembe akaonetsetsa mfundu zonyerenyetsazo, ndipo zikaoneka kuti sizinazame ndi kuti palibe ubweya wakuda, wansembe amuyike padera munthuyo kwa masiku asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Pa tsiku lachisanu ndi chiwiri wansembe aonetsetsenso mfundu zonyerenyetsazo, ndipo ngati sizinafalikire ndipo palibe ubweya wachikasu pamalopo ndiponso sizinazame, ");
INSERT INTO nya_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","wodwalayo ametedwe, koma pamene pali mfunduyo pasametedwe. Wansembe amuyike padera munthuyo kwa masiku enanso asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Pa tsiku lachisanu ndi chiwiri wansembe aonetsetsenso mfundu zonyerenyetsazo ndipo ngati sizinafalikire pa khungu ndi kuti sizinazame, wansembe alengeze kuti munthuyo ndi woyera. Tsono achape zovala zake, ndipo adzakhala woyera. ");
INSERT INTO nya_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Koma mfundu zonyerenyetsazo zikafalikira pa khungu, wansembe atalengeza kuti ndi woyera, ");
INSERT INTO nya_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","wansembe amuonetsetsenso wodwalayo ndipo ngati mfunduzo zafalikira pa khungu, iye asalabadirenso zoyangʼana ngati ubweya uli wachikasu. Munthuyo ndi wodetsedwa. ");
INSERT INTO nya_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Koma ngati wansembe waonetsetsa kuti mfunduzo sizinasinthe ndipo ubweya wakuda wamera pa mfundupo, ndiye kuti wodwalayo wachira. Tsono wansembe alengeze kuti munthuyo ndi woyeretsedwa. ");
INSERT INTO nya_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Mwamuna kapena mkazi akakhala ndi mawanga woyera pa khungu, ");
INSERT INTO nya_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","wansembe aonetsetse mawangawo, ndipo ngati ali otuwa, ndiye kuti ndi mibuko chabe yotuluka pa khungu. Munthuyo ndi woyera. ");
INSERT INTO nya_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Tsitsi la munthu likayoyoka kumutu ndiye kuti ndi dazi limenelo koma munthuyo ndi woyeretsedwa. ");
INSERT INTO nya_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ngati tsitsi lake layoyoka chapamphumi ndiye kuti ndi dazi la pa chipumi limenelo koma munthuyo ndi woyera. ");
INSERT INTO nya_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Koma ngati pa dazi la pamutu kapena la pa chipumi pakhala chithupsa choyera mofiirira, ndiye kuti ndi khate limenelo lochokera mu dazi la pamutu lija kapena pa chipumi lija. ");
INSERT INTO nya_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Tsono wansembe amuonetsetse wodwalayo ndipo ngati chithupsa cha pa dazi lapankhongo kapena pa dazi lapachipumicho ndi choyera mofiirira monga nthenda ya khate imaonekera, ");
INSERT INTO nya_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ndiye kuti munthuyo ali ndi khate, motero ndi wodetsedwa. Wansembe alengeze kuti munthuyo ndi wodetsedwa chifukwa cha chithupsa cha pamutu pakepo. ");
INSERT INTO nya_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Munthu wa khate lotere avale sanza, tsitsi lake alilekerere, aphimbe mlomo wake wapamwamba ndipo azifuwula kuti, ‘Ndine wodetsedwa, ndine wodetsedwa!’ ");
INSERT INTO nya_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Munthu wodwalayo adzakhala wodetsedwa kwa nthawi yonse imene ali ndi nthendayo. Iye ayenera kumakhala payekha kunja kwa msasa. ");
INSERT INTO nya_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Nsalu iliyonse ikakhala ndi nguwi, ");
INSERT INTO nya_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","kaya ndi chovala chopangidwa ndi nsalu yathonje kapena yaubweya, yoluka ndi thonje kapena ubweya, yachikopa kapena yopangidwa ndi chikopa, ");
INSERT INTO nya_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ndipo ngati pamalo pamene pachita nguwiyo pali ndi maonekedwe obiriwira kapena ofiirira imeneyo ndi nguwi yoyipitsa chovala ndipo chovalacho chikaonetsedwe kwa wansembe. ");
INSERT INTO nya_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Wansembeyo ayionetsetse nguwiyo ndipo chovalacho achiyike padera kwa masiku asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Pa tsiku lachisanu ndi chiwiri ayionetsetsenso nguwiyo ndipo ngati nguwiyo yafalikira pa chovalacho, chathonje kapena chaubweya, kapena pa chikopacho, kaya ndi cha ntchito ya mtundu wanji, imeneyo ndi nguwi yoopsa ndipo chovalacho ndi chodetsedwa. ");
INSERT INTO nya_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Wansembe atenthe chovala chathonje kapena chaubweya chija, ngakhalenso chinthu chachikopa chija popeza nguwiyo yachidetsa. Nguwiyo ndi yoopsa choncho chinthucho achitenthe. ");
INSERT INTO nya_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Koma ngati wansembe akayangʼanitsitsa nguwiyo apeza kuti sinafalikire pa chovalacho kapena pa chinthu chilichonse chachikopa, ");
INSERT INTO nya_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","iye alamulire kuti chinthu choyipitsidwacho achichape. Akatero achiyike padera kwa masiku enanso asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Chovalacho chitachapidwa, wansembe achionenso ndipo ngati nguwiyo sinasinthe maonekedwe ake, ngakhale kuti sinafalikire, chovalacho ndi chodetsedwa ndithu. Muchitenthe, ngakhale kuti nguwiyo ili kumbuyo kapena kumaso kwa chinthucho. ");
INSERT INTO nya_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Koma ngati wansembe aonetsetsa nʼkupeza kuti nguwi ija yathimbirira pa chovala chija kapena pa chinthu chachikopa chija atachichapa, ndiye angʼambeko chinthucho pa banga la nguwiyo. ");
INSERT INTO nya_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Koma ngati nguwiyo iwonekanso pa chovala chathonje kapena chaubweya ndiye kuti nguwiyo ikufalikira. Chilichonse chimene chili ndi nguwi chiyenera kutenthedwa. ");
INSERT INTO nya_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Chovala chathonje kapena chaubweya, ngakhale chinthu china chilichonse chopangidwa ndi chikopa, mukachichapa nguwi yake nʼkuchoka muchichapenso kawiri ndipo chidzakhala choyeretsedwa.” ");
INSERT INTO nya_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Amenewa ndiwo malamulo a nguwi yokhala pa chovala chaubweya kapena pa chovala chathonje, kapenanso pa chinthu chilichonse chopangidwa ndi chikopa kuti muzitha kulekanitsa choyeretsedwa ndi chodetsedwa. ");
INSERT INTO nya_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Malamulo a munthu wakhate pa tsiku la kuyeretsedwa kwake ndi awa: Abwere naye kwa wansembe. ");
INSERT INTO nya_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Wansembe atuluke kunja kwa msasa ndipo amuonetsetse wodwalayo. Ngati munthu wakhateyo wachira, ");
INSERT INTO nya_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","wansembe alamule anthu kuti amutengere wodwala woti ayeretsedweyo, mbalame zamoyo ziwiri zomwe Ayuda amaloledwa kudya, nthambi yamkungudza, kansalu kofiirira ndi kanthambi ka hisope. ");
INSERT INTO nya_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Wansembe alamule anthuwo kuti mbalame imodzi ayiphere mu mʼphika wa dothi pamwamba pa madzi abwino. ");
INSERT INTO nya_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Kenaka wansembe atenge mbalame yamoyo ija ndi kuyinyika pamodzi ndi nthambi yamkungudza, kansalu kofiirira ndi kanthambi ka hisope kaja mʼmagazi ambalame imene anayiphera pamwamba pa madzi abwino. ");
INSERT INTO nya_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Wansembe awaze magazi kasanu ndi kawiri pa munthu woti amuyeretse khateyo ndipo alengeze kuti munthuyo ndi woyeretsedwa. Kenaka wansembe awulutsire ku thengo mbalame yamoyoyo. ");
INSERT INTO nya_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Munthu amene wayeretsedwa uja achape zovala zake, amete tsitsi lake lonse, ndipo asambe mʼmadzi. Akatero adzakhala woyeretsedwa. Atatha zimenezi munthuyo apite ku msasa wake koma akhale kunja kwa msasawo kwa masiku asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Pa tsiku lachisanu ndi chiwiri amete tsitsi lake lonse: amete kumutu, ndevu zake, nsidze zake pamodzi ndi tsitsi lina lonse. Kenaka achape zovala zake ndi kusamba mʼmadzi, ndipo adzakhala woyeretsedwa. ");
INSERT INTO nya_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Pa tsiku lachisanu ndi chitatu munthuyo atenge ana ankhosa aamuna awiri ndi mwana wankhosa wamkazi wa chaka chimodzi. Zonsezi zikhale zopanda chilema. Atengenso chopereka chachakudya cha ufa wosalala wa makilogalamu atatu wosakaniza ndi mafuta wokwana limodzi mwa magawo atatu a lita. ");
INSERT INTO nya_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Wansembe amene ati ayeretse munthu wodwalayo amuyimitse munthuyo ali ndi zopereka zake zonse pamaso pa Yehova pa khomo la tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Ndipo wansembe atenge mwana wankhosa wamwamuna mmodzi ndi kumupereka kuti akhale nsembe yopepesera kupalamula, pamodzi ndi mafuta wokwana limodzi mwa magawo atatu a lita. Wansembe aziweyule zonsezi pamaso pa Yehova kuti zikhale chopereka choweyula. ");
INSERT INTO nya_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Mwana wankhosayo amuphere pa malo amene amaphera nsembe yopepesera machimo ndi nsembe yopsereza, kutanthauza malo opatulika. Monga zimakhalira ndi chopereka chopepesera machimo, chopereka ichi ndi chake cha wansembe ndipo ndi chopereka choyera kopambana. ");
INSERT INTO nya_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Wansembe atengeko magazi a nsembe yopepesera kupalamula ndi kuwapaka pa msonga pa khutu lakumanja la munthu woti ayeretsedweyo. Apakenso pa chala chachikulu cha ku dzanja lamanja, ndi chala chachikulu cha ku phazi lakumanja. ");
INSERT INTO nya_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Wansembe atengeko mafuta pangʼono, nʼkuwathira mʼdzanja lake lamanzere, ");
INSERT INTO nya_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","aviyike chala chake cha ku dzanja lamanja mʼmafuta amene ali mʼdzanja lamanzerewo, ndi kuwaza mafutawo ndi chala chakecho kasanu ndi kawiri pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Wansembe apake mafuta otsala mʼdzanja lake pa khutu lakumanja la munthu amene akuyeretsedwayo. Awapakenso pa chala chake chachikulu cha ku dzanja lamanja ndiponso pa chala chake chachikulu cha ku phazi lakumanja, pamalo pamene anali atapakapo magazi a nsembe yopepesera kupalamula paja. ");
INSERT INTO nya_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Mafuta onse otsala mʼdzanja la wansembe awathire pamutu pa munthu woti ayeretsedwe uja, ndipo potero adzachita mwambo womupepesera pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Kenaka wansembe apereke nsembe yopepesera machimo kuti achite mwambo womupepesera munthu woti ayeretsedwe khate lake uja. Atatha kuchita zimenezi, wansembe aphe nyama ya nsembe yopsereza ");
INSERT INTO nya_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ndi kuyipereka pa guwa, pamodzi ndi nsembe yachakudya. Akatero ndiye kuti wansembe wachita mwambo wopepesera munthu wodzayeretsedwayo, ndipo adzakhala woyera. ");
INSERT INTO nya_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Ngati munthu woti ayeretsedweyo ndi wosauka ndipo sangathe kupeza zinthu zimenezi, apereke mwana wankhosa wamwamuna monga nsembe yopepesera kupalamula ndipo ayiweyule pochita mwambo womupepesera. Aperekenso kilogalamu imodzi ya ufa wosalala osakaniza ndi mafuta kuti ikhale nsembe yachakudya, pamodzi ndi mafuta wokwanira limodzi mwa magawo atatu a lita. ");
INSERT INTO nya_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Aperekenso njiwa ziwiri kapena mawunda awiri zomwe iye angathe kuzipeza. Imodzi ikhale nsembe yopepesera machimo, ndi inayo ikhale ya nsembe yopsereza. ");
INSERT INTO nya_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Pa tsiku lachisanu ndi chitatu zonsezo abwere nazo kwa wansembe, pa khomo pa tenti ya msonkhano, pamaso pa Yehova kuti munthuyo ayeretsedwe. ");
INSERT INTO nya_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Wansembe atenge mwana wankhosa wopereka nsembe yopepesera kupalamula, pamodzi ndi mafuta aja, ndipo aziweyule kuti zikhale nsembe yoweyula pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Wansembe aphe nkhosa yopereka nsembe yopepesera kupalamula ndipo atenge magazi ake ndi kuwapaka pa msonga ya khutu lakumanja la munthu amene ayeretsedweyo. Awapakenso pa chala chachikulu cha ku dzanja lamanja, ndiponso pa chala chachikulu cha ku phazi lakumanja. ");
INSERT INTO nya_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Kenaka wansembe athire mafuta mʼdzanja lake lamanzere, ");
INSERT INTO nya_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ndipo ndi chala chake cha ku dzanja lamanja awaze mafutawo kasanu ndi kawiri pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Apakenso mafuta omwewo amene ali mʼdzanja lake lamanja pa msonga ya khutu la kudzanja lamanja la munthu amene akuyeretsedwayo. Apakenso pa chala chachikulu cha phazi lakumanja, pamalo pamene anapakapo magazi a nsembe yopepesera kupalamula. ");
INSERT INTO nya_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Mafuta onse otsala amene ali mʼdzanja la wansembe awapake pamutu pa munthu amene ayeretsedweyo kuti amuchitire mwambo wopepesera machimo pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Ndipo munthuyo apereke njiwa ziwiri kapena mawunda ankhunda awiri, molingana ndi mmene anapezeramo, ");
INSERT INTO nya_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","imodzi ikhale ya nsembe yopepesera machimo ndipo inayo ikhale ya nsembe yopsereza, pamodzi ndi chopereka chachakudya. Akatero ndiye kuti wansembe wachita mwambo wopepesera machimo a munthu woti ayeretsedwe. ");
INSERT INTO nya_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","“Amenewa ndi malamulo a munthu wakhate amene alibe zinthu zoti apereke pamene akuyeretsedwa. ");
INSERT INTO nya_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","“Yehova anawuza Mose ndi Aaroni kuti, ");
INSERT INTO nya_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Mukakalowa mʼdziko la Kanaani limene ndikukupatsani kuti likhale lanu, ndipo Ine ndikakabweretsa ndere zoyanga mʼnyumba mʼdziko limenelo, ");
INSERT INTO nya_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","mwini wake nyumbayo adzapite kwa wansembe ndi kukamuwuza kuti, ‘Ndaona chinthu chooneka ngati ndere mʼnyumba mwanga.’ ");
INSERT INTO nya_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Tsono wansembe alamule kuti anthu atulutse zinthu zonse mʼnyumbamo iye asanalowemo ndi kukaonetsetsa ndereyo kuti mʼnyumbamo musapezeke chinthu choti achitchule chodetsedwa. Izi zitachitika, wansembe alowe mʼnyumbamo ndi kukaonamo. ");
INSERT INTO nya_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Iye aonetsetse nderezo. Tsono akapeza kuti nderezo zili mʼkhoma la nyumba, ndipo ngati zili ndi mawanga obiriwira kapena ofiirira, komanso zikuoneka kuti zalowerera mpaka mʼkati mwa khoma, ");
INSERT INTO nya_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","wansembe atuluke mʼnyumbamo ndi kupita pa khomo, ndipo ayitseke nyumbayo masiku asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Pa tsiku la chisanu ndi chiwiri wansembe abwerenso kudzayangʼana mʼnyumbamo. Ngati ndere yafalikira mʼmakoma a nyumbayo, ");
INSERT INTO nya_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","wansembe alamule kuti anthu agumule miyala imene muli nderezo ndipo akayitaye kudzala la kunja kwa mzinda. ");
INSERT INTO nya_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Wansembe awuze anthu kuti apale makoma onse a mʼkati mwa nyumbayo, ndipo zopalidwazo akazitaye ku malo odetsedwa a kunja kwa mudzi. ");
INSERT INTO nya_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Tsono anthuwo atenge miyala ina ndi kuyilowetsa mʼmalo mwa miyala imene anagumula ija ndipo atenge dothi latsopano ndi kumata nyumbayo. ");
INSERT INTO nya_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Ngati ndere iwonekanso mʼnyumbamo atagumula kale miyala ndiponso atayipala kale ndi kuyimatanso, ");
INSERT INTO nya_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","wansembe apite kukayionetsetsenso ndipo ngati nderezo zafalikira mʼnyumbamo, ndiye kuti ndere zimenezo ndi zoopsa. Nyumba imeneyo ndi yodetsedwa. ");
INSERT INTO nya_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Agwetse nyumbayo, ndipo miyala yake, matabwa pamodzi ndi dothi lake lonse, zonse akazitaye kudzala lodetsedwa, kunja kwa mzinda. ");
INSERT INTO nya_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Aliyense amene alowa mʼnyumbamo itatsekedwa adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Munthu amene wagona mʼnyumbamo kapena kudyeramo ayenera kuchapa zovala zake. ");
INSERT INTO nya_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Koma ngati pambuyo pa kuyimata, wansembe abwera kudzaonetsetsa mʼnyumbamo napeza kuti ndereyo sinafalikire, iye alengeze kuti nyumbayo ndi yoyeretsedwa, chifukwa ndereyo yatha. ");
INSERT INTO nya_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Kuti nyumbayo iyeretsedwe, mwini wake atenge mbalame ziwiri, kanthambi kamkungudza, kansalu kofiirira ndi kachitsamba ka hisope. ");
INSERT INTO nya_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Wansembe aphe mbalame imodzi pamwamba pa madzi abwino mu mʼphika wa dothi. ");
INSERT INTO nya_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Kenaka atenge kanthambi kamkungudza, kachitsamba ka hisope, kansalu kofiirira pamodzi ndi mbalame yamoyo ija, zonsezi aziviyike mʼmagazi a mbalame yophedwa ija, ndiponso mʼmadzi abwino aja, ndipo awaze nyumbayo kasanu ndi kawiri ");
INSERT INTO nya_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Akatero ndiye kuti wayeretsa nyumbayo ndi magazi a mbalame, madzi abwino, mbalame yamoyo, kanthambi kamkungudza, kachitsamba ka hisope ndi kansalu kofiirira. ");
INSERT INTO nya_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Kenaka ayiwulutsire mbalame yamoyo ija kuthengo, kunja kwa mzinda. Pamenepo ndiye kuti wansembe wachita mwambo wopepesera nyumbayo, ndipo idzakhala yoyeretsedwa.” ");
INSERT INTO nya_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Amenewa ndiwo malamulo a nthenda ya khate, bala lonyerenyetsa, ");
INSERT INTO nya_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","nguwi za pa zovala, ndere za mʼnyumba, ");
INSERT INTO nya_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","khate la chithupsa, khate la mʼbuko ndi khate la banga ");
INSERT INTO nya_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","kuti mudziwe ngati chinthucho ndi choyeretsedwa kapena chodetsedwa. Amenewa ndiwo malamulo a nthenda zonse za khate. ");
INSERT INTO nya_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Yehova anawuza Mose ndi Aaroni kuti, ");
INSERT INTO nya_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Yankhulani ndi Aisraeli ndipo muwawuze kuti, ‘Mwamuna aliyense akakhala ndi nthenda yotulutsa mafinya ku maliseche ake, zotulukazo ndi zonyansa ndithu. ");
INSERT INTO nya_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Lamulo lokhudza kudziyipitsira ndi zotuluka ku maliseche a munthu nali: Malisechewo akamatulukabe mafinya, kaya aleka, munthuyo adzakhala wodetsedwa: ");
INSERT INTO nya_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘Bedi lililonse limene munthu wotulutsa mafinyayo agonapo, ndiponso chinthu chilichonse chimene akhalepo chidzakhala chodetsedwa. ");
INSERT INTO nya_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Aliyense wokhudza bedi la munthuyo achape zovala zake ndi kusamba. Komabe adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Aliyense wokhala pa chinthu chimene munthu wotulutsa mafinyayo anakhalapo, achape zovala zake ndi kusamba. Komabe adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘Aliyense wokhudza thupi la munthu amene akutulutsa mafinyayo achape zovala zake ndi kusamba. Komabe adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘Munthu wotulutsa mafinya akalavulira malovu munthu wina amene ndi woyeretsedwa, munthu ameneyo achape zovala zake ndi kusamba. Komabe adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘Chilichonse chimene munthuyo akhalira akakwera pa kavalo chidzakhala chodetsedwa. ");
INSERT INTO nya_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Ndipo aliyense wokhudza chimene anakhalira munthuyo adzakhala wodetsedwanso mpaka madzulo. Aliyense wonyamula chinthucho achape zovala zake ndi kusamba. Komabe adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘Munthu wotulutsa mafinyayo akakhudza munthu aliyense asanasambe mʼmanja, wokhudzidwayo achape zovala zake ndi kusamba. Komabe adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘Mʼphika wadothi umene munthu wotulutsa mafinyayo wakhudza awuphwanye, ndipo chiwiya chilichonse chamtengo achitsuke ndi madzi. ");
INSERT INTO nya_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘Munthu wotulutsa mafinyayo akaona kuti wachira, awerenge masiku asanu ndi awiri akuyeretsedwa kwake kenaka achape zovala zake ndi kusamba pa kasupe, ndipo adzayeretsedwa. ");
INSERT INTO nya_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Pa tsiku la chisanu ndi chitatu atenge njiwa ziwiri kapena mawunda a nkhunda awiri ndi kubwera nazo pamaso pa Yehova pa khomo pa tenti ya msonkhano ndipo azipereke kwa wansembe. ");
INSERT INTO nya_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Wansembe apereke zimenezo: imodzi ikhale nsembe yopepesera machimo ndipo inayo ikhale ya nsembe yopsereza. Pamenepo ndiye kuti wansembeyo wachita mwambo wopepesera machimo a munthu wotulutsa mafinya uja pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘Mwamuna akataya pansi mbewu yake yaumuna, asambe thupi lake lonse. Komabe adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Chovala chilichonse kapena chikopa chilichonse pomwe pagwera mbewu yaumunayo achichape, komabe chidzakhala chodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Mwamuna akagona ndi mkazi wake nataya mbewu yake yaumuna, onse awiriwo asambe. Komabe adzakhala odetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘Mkazi akakhala wosamba ndipo ikakhala kuti ndi nthawi yake yeniyeni yosamba, adzakhala wodetsedwa masiku asanu ndi awiri. Aliyense amene adzamukhudza adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘Chilichonse chimene mkaziyo agonera pa nthawi yake yosamba chidzakhala chodetsedwa, ndipo chilichonse chimene adzakhalira chidzakhalanso chodetsedwa. ");
INSERT INTO nya_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Aliyense wokhudza bedi lake achape zovala zake ndi kusamba, komabe adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Aliyense wokhudza chimene wakhalapo achape zovala zake ndi kusamba, komabe adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Kaya ndi bedi kapena chinthu china chilichonse chimene anakhalapo, ngati munthu wina akhudza chinthucho, munthuyo adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘Mwamuna aliyense akagona naye ndipo magazi osamba kwake ndi kumukhudza, munthuyo adzakhala wodetsedwa masiku asanu ndi awiri, ndipo bedi limene wagonapo lidzakhalanso lodetsedwa. ");
INSERT INTO nya_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘Mkazi akataya magazi masiku ambiri, wosakhala pa nthawi yake yosamba, kapena akamasambabe kupitirira nthawi yake yosamba, mkaziyo adzakhala wodetsedwa nthawi yonse imene akutaya magazi, monga momwe amakhalira pa masiku ake osamba. ");
INSERT INTO nya_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Bedi lililonse limene mkaziyo adzagonapo pa masiku onse pamene ali wotaya magazi, ndiponso chilichonse chimene wakhalira chidzakhala chodetsedwa monga mmene chimakhalira chodetsedwa pa nthawi yake yosamba. ");
INSERT INTO nya_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Aliyense amene adzakhudza zinthu zimenezo adzakhala wodetsedwa ndipo ayenera kuchapa zovala zake ndi kusamba, komabe adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘Nthawi yosamba ikatha, mkaziyo awerenge masiku asanu ndi awiri, ndipo masikuwo akatha adzakhala woyeretsedwa. ");
INSERT INTO nya_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Pa tsiku lachisanu ndi chitatu, mkaziyo atenge njiwa ziwiri kapena mawunda awiri, ndipo abwere nazo kwa wansembe pa khomo la Tenti ya Msonkhano. ");
INSERT INTO nya_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Wansembe apereke imodzi kuti ikhale nsembe yopepesera machimo ndipo inayo ikhale ya nsembe yopsereza. Pamenepo ndiye kuti wansembeyo wachita mwambo wopepesera mkaziyo pamaso pa Yehova chifukwa cha matenda ake wosamba aja. ");
INSERT INTO nya_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘Choncho muwayeretsa ana a Israeli nʼkudetsedwa kwawo kuti angafe pochita tchimo lowadetsa limene polichita limadetsa malo anga wokhalamo amene ali pakati pawo.’ ” ");
INSERT INTO nya_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Amenewa ndi malamulo a munthu amene akutuluka mafinya kumaliseche kwake, komanso a munthu aliyense amene wadetsedwa ndi mbewu yaumuna, ");
INSERT INTO nya_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","mkazi wodwala chifukwa cha msambo komanso a mwamuna kapena mkazi amene akutulutsa mafinya kumaliseche kwake ndi mwamuna wogona ndi mkazi amene akusamba. ");
INSERT INTO nya_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Atafa ana awiri a Aaroni amene anaphedwa atapita pamaso pa Yehova mosayenera, Yehova anayankhula ndi Mose. ");
INSERT INTO nya_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Yehova anawuza Mose kuti, “Uza mchimwene wako Aaroni kuti asamalowe ku Malo Wopatulika, kuseri kwa katani, pamaso pa chivundikiro cha Bokosi la Chipangano nthawi iliyonse imene akufuna kuopa kuti angadzafe, pakuti Ine ndimaoneka mu mtambo umene uli pamwamba pa chivundikiro cha Bokosi la Chipangano. ");
INSERT INTO nya_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Aaroni azilowa Malo Wopatulika Kwambiri motere: azitenga mwana wangʼombe wamwamuna kuti akhale nsembe yopepesera machimo ndi nkhosa yayimuna kuti ikhale nsembe yopsereza. ");
INSERT INTO nya_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Azivala mwinjiro wopatulika wa nsalu yosalala, azivalanso kabudula wa mʼkati wa nsalu yosalala, azimanga lamba wa nsalu yosalala, ndipo avalenso nduwira ya nsalu yosalala kumutu. Zimenezi ndi nsalu zopatulika ndipo atasamba thupi lonse azivala zimenezi. ");
INSERT INTO nya_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Kuchokera pa gulu la Aisraeli, Aaroni azitenga mbuzi zazimuna ziwiri kuti zikhale nsembe yopepesera machimo ndi nkhosa yayimuna kuti ikhale nsembe yopsereza. ");
INSERT INTO nya_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Aaroni apereke ngʼombe yayimuna kuti ikhale yopepesera machimo a iye mwini kuti achite mwambo wopepesera machimo ake pamodzi ndi a banja lake. ");
INSERT INTO nya_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Kenaka atenge mbuzi ziwiri zija ndipo aziyimike pamaso pa Yehova pa khomo la tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aaroni ndiye achite maere pa mbuzi ziwirizo kuti imodzi ikhale ya Yehova, ndipo inayo ikhale ya Azazele. ");
INSERT INTO nya_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aaroni abwere ndi mbuzi imene maere aonetsa kuti ndi ya Yehova, ndipo apereke kuti ikhale nsembe yopereka chifukwa cha tchimo. ");
INSERT INTO nya_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Koma mbuzi imene maere aonetsa kuti ndi yosenza machimo, apereke ya moyo pamaso pa Yehova, kuti achite mwambo wopepesera machimo pa mbuziyo poyitumiza ku chipululu kuti ikhale ya Azazele. ");
INSERT INTO nya_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Aaroni apereke ngʼombe yayimuna kuti ikhale nsembe yopepesera machimo ake. Ndiye achite mwambo wopepesera machimo a iye mwini wake pamodzi ndi banja lake. Pambuyo pake aphe ngʼombe yopepesera machimo ake aja. ");
INSERT INTO nya_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Kenaka iye atenge chofukizira chodzaza ndi makala a moto ochokera pa guwa lansembe pamaso pa Yehova. Atengenso lubani wonunkhira ndi woperapera wokwanira manja awiri, ndipo alowe naye kuseri kwa katani. ");
INSERT INTO nya_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Athire lubani pa moto pamaso pa Yehova kuti utsi wa lubaniyo uphimbe chivundikiro chimene chili pamwamba pa Bokosi la Chipangano, kuti Aaroniyo asafe. ");
INSERT INTO nya_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Ndipo atenge magazi ena a ngʼombeyo, awawaze ndi chala chake pa chivundikiro cha kummawa; kenaka awaze magaziwo ndi chala chake kasanu ndi kawiri patsogolo pa chivundikirocho. ");
INSERT INTO nya_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Kenaka Aaroni aphe mbuzi ya nsembe yopepesera machimo a anthu, ndipo magazi ake alowe nawo kuseri kwa katani ndi kuchita chimodzimodzi monga anachitira ndi magazi a ngʼombe aja: Aaroni awaze magaziwo pa chivundikiro chija ndi patsogolo pa chivundikirocho. ");
INSERT INTO nya_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Pamenepo ndiye kuti wansembeyo wachita mwambo wopepesera ku Malo Wopatulika chifukwa cha kudetsedwa ndi kuwukira kwa Aisraeli pa machimo ena aliwonse amene achita. Achite chimodzimodzi ndi tenti ya msonkhano imenenso ili yodetsedwa chifukwa cha machimo awo. ");
INSERT INTO nya_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Mu tenti ya msonkhano musakhale munthu ndi mmodzi yemwe nthawi imene Aaroni akupita kukachita mwambo wopepesera ku Malo Wopatulika mpaka atatulukako. Musakhale munthu mu tenti ya msonkhano mpaka atachita mwambo wopepesera machimo a iye mwini wake, banja lake ndi gulu lonse la Aisraeli. ");
INSERT INTO nya_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Kenaka, Aaroniyo akatuluka apite ku guwa limene lili pamaso pa Yehova ndi kulichitira mwambo wolipepesera. Atengeko magazi a ngʼombe yayimuna ndiponso magazi a mbuzi ndi kuwapaka pa nyanga zonse za guwa lansembe. ");
INSERT INTO nya_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Magazi ena awawaze pa guwalo ndi chala chake kasanu ndi kawiri kuliyeretsa ndi kulipatula kuchotsa zodetsa za Aisraeli. ");
INSERT INTO nya_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Aaroni akatsiriza mwambo wopepesera Malo Wopatulika, tenti ya msonkhano ndi guwa, azibwera ndi mbuzi yamoyo kudzayipereka nsembe. ");
INSERT INTO nya_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aaroni asanjike manja ake pa mutu wa mbuziyo ndipo awulule pa mbuziyo zoyipa zonse ndi zowukira zonse za Aisraeli, kutanthauza machimo awo onse. Machimowo awayike pa mutu wa mbuziyo. Kenaka munthu amene anasankhidwa athamangitsire mbuziyo ku chipululu. ");
INSERT INTO nya_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Mbuziyo isenze machimo awo onse ndi kupita nawo kutali ndipo munthuyo aleke mbuziyo kuti ipite ku chipululuko. ");
INSERT INTO nya_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Pambuyo pake Aaroni alowe mu tenti ya msonkhano ndi kuvula zovala zosalala zija zimene anavala polowa ku Malo Wopatulika ndi kuzisiya komweko. ");
INSERT INTO nya_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Asambe thupi lonse ku Malo Wopatulika ndi kuvala zovala zake za nthawi zonse. Kenaka atuluke ndi kukapereka nsembe yopsereza ya iye mwini, ndiponso nsembe yopsereza yoperekera anthu. Akatero ndiye kuti wachita mwambo wopepesera machimo a iye mwini wake ndi a anthu. ");
INSERT INTO nya_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Mafuta a nyama yopepesera machimo awatenthe pa guwa lansembe. ");
INSERT INTO nya_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Tsono munthu amene anaperekeza mbuzi yosenza machimo ija achape zovala zake ndi kusamba. Pambuyo pake alowe ku msasa. ");
INSERT INTO nya_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ngʼombe ndi mbuzi zoperekera nsembe yopepesera machimo zimene magazi ake anabwera nawo kuti achitire mwambo wopepesera Malo Wopatulika, azitulutsire kunja kwa msasa. Koma zikopa zake, nyama yake ndi matumbo ake azitenthe. ");
INSERT INTO nya_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Munthu amene azitenthe achape zovala zake ndi kusamba. Pambuyo pake alowe mu msasa. ");
INSERT INTO nya_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Ili likhale lamulo lanu lamuyaya: Mwezi wachisanu ndi chiwiri, pa tsiku la khumi la mwezi, mugonje pamaso pa Yehova. Musamagwire ntchito iliyonse, kaya ndinu mbadwa kapena mlendo amene akukhala pakati panu, ");
INSERT INTO nya_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","chifukwa tsiku limeneli kudzachitika mwambo wopepesera machimo anu, kukuyeretsani kuti mukhale oyeretsedwa ku machimo anu pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Limeneli ndi tsiku lanu la Sabata lopumula, ndipo muzigonja pamaso pa Yehova. Limeneli ndi lamulo lanu la muyaya. ");
INSERT INTO nya_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Wansembe amene wadzozedwa ndi kupatulidwa kuti akhale wansembe kulowa mʼmalo mwa abambo ake ndiye azichita mwambo wopepesera machimo atavala zovala zake zosalala ndi zopatulika. ");
INSERT INTO nya_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Adzachite mwambo wopepesera machimo Malo Wopatulika, tenti ya msonkhano ndi guwa lansembe. Adzachitenso mwambo wopepesera anzake ndi gulu lonse la anthu. ");
INSERT INTO nya_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Ili likhale lamulo lanu lamuyaya. Mwambo wopepesera machimo uzichitika kamodzi pa chaka chifukwa cha machimo a anthu onse.” Ndipo Mose anachita monga momwe Yehova analamulira. ");
INSERT INTO nya_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Uza Aaroni ndi ana ake, pamodzi ndi Aisraeli onse kuti, ‘Chimene Yehova walamula ndi ichi: ");
INSERT INTO nya_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Mwisraeli aliyense amene apha ngʼombe, mwana wankhosa kapena mbuzi mu msasa kapena kunja kwa msasa, ");
INSERT INTO nya_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","mʼmalo mobwera nayo pa khomo la tenti ya msonkhano pamaso pa Yehova ndi kuyipereka kuti ikhale nsembe ya Yehova, ameneyo wapalamula mlandu wa magazi, wakhetsa magazi ndipo ayenera kuchotsedwa pakati pa anthu anzake. ");
INSERT INTO nya_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Izi zili choncho kuti Aisraeli azibwera ndi nyama zawo za nsembe zimene akanaphera ku malo kwina kulikonse. Aisraeli azibwera nazo nyamazo kwa Yehova, kwa wansembe wokhala pa khomo la tenti ya msonkhano ndipo aziphere pomwepo kuti zikhale nsembe za chiyanjano. ");
INSERT INTO nya_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Wansembe awaze magazi ake pa guwa la Yehova limene lili pa khomo la tenti ya msonkhano ndipo atenthe mafuta ake kuti atulutse fungo lokomera Yehova. ");
INSERT INTO nya_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Motero asadzapherenso nsembe fano la mbuzi limene amachita nalo zadama. Limeneli ndi lamulo la muyaya kwa iwo ndi mibado ya mʼtsogolo.’ ” ");
INSERT INTO nya_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Uwawuze kuti, ‘Mwisraeli aliyense kapena mlendo amene amakhala pakati pawo akapereka nsembe yopsereza kapena nsembe ina iliyonse ");
INSERT INTO nya_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","popanda kubwera nayo pa khomo la tenti ya msonkhano kudzayipereka pamaso pa Yehova, munthu ameneyo achotsedwe pakati pa anthu anzake.’ ” ");
INSERT INTO nya_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Mwisraeli aliyense kapena mlendo aliyense wokhala pakati panu amene adya magazi, ndidzamufulatira ndipo ndidzamuchotsa pakati pa anthu anzake. ");
INSERT INTO nya_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Pakuti moyo wa cholengedwa chilichonse uli mʼmagazi, ndipo ndawupereka kwa inu kuti muzichitira mwambo wopepesera machimo a moyo wanu pa guwa. Pajatu magazi ndiwo amachotsa machimo chifukwa moyo uli mʼmenemo. ");
INSERT INTO nya_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Choncho ndikuwawuza Aisraeli kuti, ‘Pasapezeke aliyense wa inu wodya magazi, ngakhale mlendo wokhala pakati panu.’ ” ");
INSERT INTO nya_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“Mwisraeli aliyense kapena mlendo aliyense wokhala pakati panu amene amasaka ndi kupha nyama zakuthengo kapena mbalame zimene amadya, ataye magazi ake pansi ndi kuwakwirira ndi dothi, ");
INSERT INTO nya_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","chifukwa moyo wa cholengedwa chilichonse uli mʼmagazi ake. Nʼchifukwa chake ndinawawuza Aisraeli kuti, ‘Musamadye magazi a cholengedwa chilichonse, chifukwa moyo wa cholengedwa chilichonse uli mʼmagazi. Aliyense wodya magaziwo ayenera kuchotsedwa pakati pa anthu anzake. ");
INSERT INTO nya_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘Munthu aliyense, kaya ndi mbadwa kapena mlendo, amene amadya chilichonse chofa chokha, kapena chojiwa ndi zirombo, achape zovala zake ndi kusamba, komabe adzakhala wodetsedwa mpaka madzulo. Kenaka adzakhala woyeretsedwa. ");
INSERT INTO nya_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Koma ngati sachapa zovala zake ndi kusamba, adzasenzabe machimo ake.’ ” ");
INSERT INTO nya_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Yankhula ndi Aisraeli ndipo uwawuze kuti, ‘Ine ndine Yehova Mulungu wanu. ");
INSERT INTO nya_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Musamachite zomwe amachita anthu a ku Igupto kumene munkakhala kuja, ndiponso musamachite zomwe amachita anthu a ku Kanaani kumene ndikukupititsani. Musatsatire miyambo yawo. ");
INSERT INTO nya_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Inu muzimvera malamulo anga ndipo muzisamalitsa kutsatira malangizo anga. Ine ndine Yehova Mulungu wanu. ");
INSERT INTO nya_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Choncho sungani malangizo ndi malamulo anga, popeza munthu amene amvera zimenezi adzakhala ndi moyo. Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘Munthu aliyense asagonane ndi wachibale wake. Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘Usachititse manyazi abambo ako pogonana ndi amayi ako. Iwo ndi amayi ako. Usagonane nawo. ");
INSERT INTO nya_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘Usagonane ndi mkazi wa abambo ako (osakhala amayi okubala). Ukatero ukuchititsa manyazi abambo ako. ");
INSERT INTO nya_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘Usagonane ndi mlongo wako, mwana wamkazi wa abambo ako, kapena mwana wamkazi wa amayi ako, kaya anabadwira mʼnyumba mwanu kapena kwina. ");
INSERT INTO nya_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘Usagonane ndi mdzukulu wako: mwana wa mwana wako wamwamuna kapena mwana wa mwana wako wamkazi. Kutero nʼkudzichotsa ulemu. ");
INSERT INTO nya_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘Usagonane ndi mwana wamkazi wa mkazi wa abambo ako, amene abambo akowo anabereka; popeza ameneyo ndi mlongo wako. ");
INSERT INTO nya_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘Usagonane ndi mlongo wa abambo ako; popeza ameneyo ndi thupi limodzi ndi abambo ako. ");
INSERT INTO nya_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘Usagonane ndi mchemwali wa amayi ako chifukwa ameneyo ndi thupi limodzi ndi amayi ako. ");
INSERT INTO nya_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘Usachititse manyazi mchimwene wa abambo ako pogonana ndi mkazi wake popeza amenewo ndi azakhali ako. ");
INSERT INTO nya_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘Usagonane ndi mpongozi wako popeza ameneyo ndi mkazi wa mwana wako. Choncho usamuchititse manyazi. ");
INSERT INTO nya_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘Usagonane ndi mkazi wa mchimwene wako popeza potero ukuchititsa manyazi mʼbale wakoyo. ");
INSERT INTO nya_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘Usagonane ndi mkazi ndiponso mwana wake wamkazi. Usagonane ndi mwana wamkazi wa mwana wake wamwamuna, kapena mwana wamkazi wa mwana wake wamkazi. Amenewo ndi thupi limodzi ndi mkaziyo. Kutero ndikuchita chinthu choyipa kwambiri. ");
INSERT INTO nya_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘Usakwatire mchemwali wa mkazi wako ndi kumagonana naye mkazi wakoyo ali moyo ngati wopikisana naye. ");
INSERT INTO nya_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘Usamuyandikire mkazi kuti ugonane naye pa nthawi yake yosamba. ");
INSERT INTO nya_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘Usagonane ndi mkazi wa mnzako ndi kudziyipitsa naye. ");
INSERT INTO nya_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘Usapereke mwana wako aliyense kuti akhale nsembe yamoto kwa Moleki ndi kuyipitsa dzina la Yehova. Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘Usagonane ndi mwamuna ngati mkazi; chimenecho ndi chinthu chonyansa. ");
INSERT INTO nya_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘Usagonane ndi nyama ndi kudziyipitsa nayo. Mkazi asadzipereke kwa nyama kuti agonane nayo. Chimenecho ndi chisokonezo. ");
INSERT INTO nya_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘Musadzidetse ndi zinthu zimenezi chifukwa umo ndi mmene mitundu ina imene ndikuyithamangitsa pamaso panu inadzidetsera. ");
INSERT INTO nya_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Choncho dziko linayipa ndipo ndinalilanga chifukwa cha tchimo lake. Motero dzikolo linasanza anthu ake okhalamo. ");
INSERT INTO nya_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Koma inu mukasunge malangizo ndi malamulo anga. Mbadwa ndiponso alendo amene akukhala pakati panu asakachite china chilichonse cha zinthu zonyansazi, ");
INSERT INTO nya_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","pakuti zinthu zonsezi ndi zomwe ankachita anthu amene ankakhala mʼdzikomo inu musanafike, ndipo dziko linayipitsidwa. ");
INSERT INTO nya_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Koma inu musachite zimenezi kuti dziko lingakusanzeni mutaliyipitsa monga linasanzira mitundu imene imakhalamo inu musanafike. ");
INSERT INTO nya_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘Aliyense wochita zinthu zonyansa zimenezi achotsedwe pakati pa anthu anzake. ");
INSERT INTO nya_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Choncho mverani malangizo anga oletsa kuchita miyambo yonyansayi imene ankatsatira anthu amene analipo inu musanafike ndi kudziyipitsa nayo. Ine ndine Yehova Mulungu wanu.’ ” ");
INSERT INTO nya_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Uza gulu lonse la Aisraeli kuti, ‘Khalani oyera mtima chifukwa Ine, Yehova Mulungu wanu, ndine Woyera. ");
INSERT INTO nya_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘Aliyense mwa inu azilemekeza abambo ake ndi amayi ake. Ndipo muzisunga masabata anga. Ine ndine Yehova Mulungu wanu. ");
INSERT INTO nya_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘Musatembenukire ku mafano kapena kudzipangira nokha milungu ya zitsulo zosungunula. Ine ndine Yehova Mulungu wanu. ");
INSERT INTO nya_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘Pamene mukupereka nsembe yachiyanjano kwa Yehova, muyipereke mwanjira yoti ilandiridwe. ");
INSERT INTO nya_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Nsembe izidyedwa tsiku lomwe mwayiperekalo kapena mmawa mwake. Chilichonse chotsala mpaka tsiku lachitatu chiyenera kutenthedwa. ");
INSERT INTO nya_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Ngati mudya choperekacho tsiku lachitatu, ndiye kuti mwachita chonyansa ndipo chakudyacho sichidzalandiridwa. ");
INSERT INTO nya_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Munthu aliyense amene adya chakudyacho adzasenza machimo ake chifukwa wayipitsa chinthu chimene ndi choyera kwa Yehova. Munthu ameneyo achotsedwe pakati pa anthu anzake. ");
INSERT INTO nya_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘Pamene mukolola zinthu mʼmunda mwanu musakolole mpaka mʼmphepete mwa munda, ndipo musatole khunkha lake. ");
INSERT INTO nya_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Musakolole mphesa zonse mʼmunda wanu wa mpesa kapena kutola mphesa zakugwa mʼmundamo. Zimenezi muzisiyire anthu osauka ndi alendo. Ine ndine Yehova Mulungu wako. ");
INSERT INTO nya_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘Musabe. “ ‘Musamanamizane. “ ‘Musachitirane zinthu mwachinyengo. ");
INSERT INTO nya_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘Musalumbire mʼdzina langa monyenga popeza kutero ndi kuyipitsa dzina la Mulungu wanu. Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘Musapsinje mnzanu kapena kumulanda zinthu zake. “ ‘Musasunge malipiro a munthu wantchito usiku wonse mpaka mmawa. ");
INSERT INTO nya_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘Musatemberere wosamva kapena kuyikira munthu wosaona chinthu choti apunthwe nacho patsogolo pake, koma muziopa Mulungu wanu. Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘Musamaweruze mopanda chilungamo. Musachite tsankho pakati pa osauka ndi olemera, koma muweruze mlandu wa mnzanu mwachilungamo. ");
INSERT INTO nya_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘Musamapite uku ndi uku kunena bodza pakati pa anthu anu. “ ‘Musachite kanthu kalikonse kamene kangadzetse imfa kwa mnzanu. Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘Musamude mʼbale wanu mu mtima mwanu. Koma mudzudzuleni mnzanu moona mtima kuti musakhale wolakwa. ");
INSERT INTO nya_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘Musamubwezere mnzanu choyipa kapena kumusungira kanthu kunkhosi, koma konda mnansi wako monga iwe mwini. Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘Muzisunga malangizo anga. “ ‘Tsono musamalole kuti ngʼombe zanu zikwerane ndi chiweto cha mtundu wina. “ ‘Ndiponso musamadzale mbewu za mitundu iwiri mʼmunda umodzi. “ ‘Musavale chovala chopangidwa ndi nsalu za mitundu iwiri. ");
INSERT INTO nya_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘Ngati munthu agonana ndi kapolo wamkazi amene wafunsidwa mbeta ndi munthu wina, koma sanawomboledwe kapenanso kulandira ufulu wake, alangidwe. Koma onsewa asaphedwe, chifukwa mkaziyo anali asanalandire ufulu wake. ");
INSERT INTO nya_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Koma mwamunayo abwere ndi nsembe yopepesera kupalamula kwa Yehova pa khomo la tenti ya msonkhano. Nsembe yake ikhale nkhosa yayimuna ");
INSERT INTO nya_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","ndipo wansembe achite nayo mwambo wopepesera chifukwa cha kupalamula kumene anachita pamaso pa Yehova. Akatero tchimo lake lidzakhululukidwa. ");
INSERT INTO nya_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘Mukadzalowa mʼdzikomo ndi kudzala mtengo wa mtundu uliwonse wa zipatso, zipatso zakezo mudzaziyese ngati zodetsedwa. Ndiye kuti kwa zaka zitatu zidzakhale zoletsedwa kwa inu. Musadzazidye nthawi imeneyi. ");
INSERT INTO nya_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Chaka chachinayi, zipatso zake zonse zidzakhala zopatulika, ndipo zidzakhala chopereka cha matamando kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Koma chaka chachisanu, mudzatha kudya zipatso zake kuti mitengoyo idzakubalireni zochuluka. Ine ndine Yehova Mulungu wanu. ");
INSERT INTO nya_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘Musadye nyama ya magazi. “ ‘Musamawombeze kapena kuchita zamatsenga. ");
INSERT INTO nya_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘Musamamete mduliro kapena kumeta mʼmphepete mwa ndevu zanu. ");
INSERT INTO nya_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘Musadzichekecheke pathupi panu chifukwa cha munthu wakufa kapena kudzitema mphini pa thupi lanu. Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘Musamuyipitse mwana wanu wamkazi pomusandutsa mkazi wachiwerewere. Mukatero dziko lidzasanduka la anthu achiwerewere ndi lodzaza ndi zoyipa. ");
INSERT INTO nya_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘Muzisunga Masabata anga ndipo muzilemekeza malo anga opatulika. Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘Musamapite kwa woyankhula ndi mizimu ya anthu akufa, kapena kwa owombeza. Musamawafunefune kuti angakuyipitseni. Ine ndine Yehova Mulungu wanu. ");
INSERT INTO nya_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘Muzikhala mwa ulemu pamaso pa munthu wachikulire, ndipo muzichitira ulemu munthu wokalamba. Kumeneko ndiye kuopa Mulungu wanu. Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘Pamene mlendo akhala nanu mʼdziko mwanu, musamuzunze. ");
INSERT INTO nya_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Mlendo amene akhala nanu akhale ngati mmodzi mwa mbadwa zanu. Mumukonde monga momwe mumadzikondera inu nomwe. Paja inu munali alendo mʼdziko la Igupto. Ine ndine Yehova Mulungu wanu. ");
INSERT INTO nya_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘Musamachite za chinyengo poweruza mlandu, kapena poyeza utali, kulemera ngakhalenso kuchuluka kwa zinthu. ");
INSERT INTO nya_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Miyeso ya sikelo, miyeso yoyezera kulemera kwa zinthu, miyeso yotchedwa efa ndi miyeso yotchedwa hini zikhale zolungama. Ine ndine Yehova, Mulungu wanu amene ndinakutulutsani ku dziko la Igupto. ");
INSERT INTO nya_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘Choncho muzisunga malangizo ndi malamulo angawa ndi kuwatsatira. Ine ndine Yehova.’ ” ");
INSERT INTO nya_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Uza Aisraeli kuti, ‘Mwisraeli aliyense kapena mlendo aliyense wokhala mu Israeli wopereka mwana wake kwa Moleki ayenera kuphedwa. Anthu a mʼdera lakelo amuphe ndi miyala. ");
INSERT INTO nya_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Munthu ameneyo ndidzamufulatira ndi kumuchotsa pakati pa anzake.’ Popereka mwana wake kwa Moleki, wadetsa malo anga wopatulika ndi kuyipitsa dzina langa loyera. ");
INSERT INTO nya_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ngati anthu a mʼderalo achita ngati sakumuona munthuyo pamene akupereka mwana wake kwa Moleki ndi kusamupha, ");
INSERT INTO nya_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Ineyo ndidzamufulatira pamodzi ndi banja lake. Ndidzawachotsa pakati pa anthu anzawo onse amene anamutsatira, nadziyipitsa okha popembedza Moleki.” ");
INSERT INTO nya_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘Ngati munthu adzapita kwa woyankhula ndi mizimu ya anthu akufa kapena kwa owombeza, nadziyipitsa powatsatira iwowo, Ine ndidzamufulatira ndi kumuchotsa pakati pa anthu anzake. ");
INSERT INTO nya_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘Chifukwa chake dzipatuleni ndi kukhala woyera popeza Ine ndine Yehova Mulungu wanu. ");
INSERT INTO nya_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Ndipo sungani malangizo anga ndi kuwatsata. Ine ndine Yehova amene ndimakuyeretsani. ");
INSERT INTO nya_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘Munthu aliyense amene atemberera abambo ake kapena amayi ake ayenera kuphedwa. Magazi ake adzakhala pamutu pake chifukwa iye watemberera abambo kapena amayi ake. ");
INSERT INTO nya_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘Ngati munthu wachita chigololo ndi mkazi wa mnzake, mwamunayo pamodzi ndi mkaziyo ayenera kuphedwa. ");
INSERT INTO nya_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘Ngati munthu agonana ndi mkazi wa abambo ake, wachititsa manyazi abambo ake. Munthuyo pamodzi ndi mkaziyo ayenera kuphedwa. Magazi awo adzakhala pa mitu pake. ");
INSERT INTO nya_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘Ngati munthu agonana ndi mkazi wa mwana wake, awiriwo ayenera kuphedwa. Iwo achita chinthu chonyansa kwambiri. Magazi awo adzakhala pa mitu pawo. ");
INSERT INTO nya_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘Ngati munthu agonana ndi mwamuna mnzake ngati akugonana ndi mkazi, ndiye kuti onsewo achita chinthu cha manyazi. Choncho aphedwe. Magazi awo adzakhala pa mitu pawo. ");
INSERT INTO nya_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘Ngati munthu akwatira mkazi, nakwatiranso amayi ake, chimenecho ndi chinthu choyipa kwambiri. Mwamunayo pamodzi ndi akaziwo ayenera kutenthedwa pa moto kuti chinthu choyipa chotere chisapezekenso pakati panu. ");
INSERT INTO nya_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘Ngati mwamuna agonana ndi nyama, iye ayenera kuphedwa, ndipo muyeneranso kupha nyamayo. ");
INSERT INTO nya_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘Ngati mkazi agonana ndi nyama, aphedwe pamodzi ndi nyamayo. Mkaziyo ndi nyamayo ayenera kuphedwa, ndipo magazi awo adzakhala pa mitu pawo. ");
INSERT INTO nya_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘Ngati munthu akakwatira mlongo wake, mwana wamkazi wa abambo ake, kapena mwana wamkazi wa amayi ake, ndipo iwo nʼkugonana, ndiye kuti achita chinthu chochititsa manyazi. Onse awiri ayenera kuchotsedwa pa gulu la abale awo. Tsono popeza munthuyo wachititsa manyazi mlongo wake, adzayenera kulandira chilango. ");
INSERT INTO nya_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘Ngati munthu agonana ndi mkazi pa nthawi yake yosamba, ndiye kuti wavula msambo wake, ndipo mkaziyo wadzivulanso. Onse awiri achotsedwe pakati pa anthu anzawo. ");
INSERT INTO nya_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘Musagonane ndi mchemwali wa amayi anu kapena abambo anu, pakuti kutero ndi kuchititsa manyazi mʼbale wanu. Nonse mudzalipira mlandu wanu. ");
INSERT INTO nya_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘Ngati munthu agonana ndi azakhali ake, munthuyo wachititsa manyazi a malume ake. Onse adzalipira mlandu wawo. Onsewo adzafa wopanda mwana. ");
INSERT INTO nya_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘Munthu akakwatira mkazi wa mchimwene wake ndiye kuti wachita chinthu chonyansa. Wachititsa manyazi mʼbale wakeyo. Onse awiriwo adzakhala wopanda mwana. ");
INSERT INTO nya_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘Nʼchifukwa chake muzisunga malangizo anga onse ndi malamulo anga ndipo muwatsatire kuti ku dziko limene Ine ndikupita nanu kuti mukakhalemo lisakakusanzeni. ");
INSERT INTO nya_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Musatsanzire miyambo ya mitundu ya anthu imene ndi kuyipirikitsa inu mukufika. Chifukwa iwo anachita zinthu zonsezi, ndipo Ine ndinanyansidwa nawo. ");
INSERT INTO nya_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Koma Ine ndinakuwuzani kuti, ‘Mudzatenga dziko lawo. Ine ndidzakupatsani dzikolo kuti likhale cholowa chanu, dziko loyenda mkaka ndi uchi.’ Ine ndine Yehova Mulungu wanu amene ndakupatulani pakati pa mitundu yonse ya anthu. ");
INSERT INTO nya_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘Chifukwa chake muzisiyanitsa pakati pa nyama zoyeretsedwa ndi nyama zodetsedwa ndiponso pakati pa mbalame zoyeretsedwa ndi mbalame zodetsedwa. Musadzidetse pakudya nyama iliyonse kapena mbalame, kapena chilichonse chimene chimakwawa pansi, chimene Ine ndachipatula kuti chikhale chodetsedwa kwa inu. ");
INSERT INTO nya_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Muzikhala woyera pamaso panga chifukwa Ine Yehova, ndine woyera ndipo ndakupatulani pakati pa anthu a mitundu yonse kuti mukhale anthu anga. ");
INSERT INTO nya_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘Mwamuna kapena mkazi woyankhula ndi mizimu ya anthu akufa kapena wanyanga pakati panu ayenera kuphedwa. Muwagende ndi miyala, ndipo magazi awo adzakhala pa mitu pawo.’ ” ");
INSERT INTO nya_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Yehova anawuza Mose kuti, “Yankhula ndi ansembe, ana a Aaroni, ndipo uwawuze kuti, ‘Wansembe asadzidetse pokhudza munthu wakufa pakati pa abale ake. ");
INSERT INTO nya_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Koma akhoza kukhudza thupi lakufa la amayi ake, abambo ake, mwana wake wamwamuna, mwana wake wamkazi, mchimwene wake, ");
INSERT INTO nya_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","kapena mlongo wake wosakwatiwa amene amadalira iye chifukwa sanakwatiwe. Iye akhoza kudzidetsa pokhudza thupi lakufa la mchemwali wake wosakwatiwa yekha. ");
INSERT INTO nya_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Koma wansembe asadzidetse chifukwa cha anthu amene ali nawo pa ubale obwera chifukwa cha ukwati. ");
INSERT INTO nya_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘Ansembe asamete tsitsi kumutu kwawo kapena mʼmphepete mwa ndevu zawo, kapenanso kudzichekacheka pa thupi lawo. ");
INSERT INTO nya_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ayenera kukhala oyera pamaso pa Mulungu wawo ndipo asachititse manyazi dzina la Mulungu wawo. Popeza amapereka nsembe zotentha pa moto kwa Yehova, chakudya cha Mulungu wawo, iwo azikhala woyera. ");
INSERT INTO nya_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘Asakwatire akazi amene adzidetsa ndi chiwerewere kapena akazi amene amuna awo awasudzula, chifukwa ansembe ndi oyera pamaso pa Mulungu wawo. ");
INSERT INTO nya_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Iwo akhale oyera chifukwa amapereka nsembe kwa Mulungu wanu. Muziwaona kuti ndi oyera, popeza Ine Yehova amene ndimawayeretsa ndine woyera, nawonso akhale oyera. ");
INSERT INTO nya_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘Ngati mwana wamkazi wa wansembe adziyipitsa pochita zachiwerewere, ndiye kuti iye akuchititsa manyazi abambo ake; mwanayo atenthedwe pa moto. ");
INSERT INTO nya_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘Munthu amene ali mkulu wa ansembe pakati pa abale ake, amene anamudzoza pomutsanulira mafuta pamutu pake, ndiponso amene anapatulidwa pomuveka zovala zaunsembe, asalekerere tsitsi lake kapena kungʼamba zovala zake kusonyeza kuti ali pa chisoni. ");
INSERT INTO nya_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Asalowe mʼnyumba mmene muli munthu wakufa ngakhale womwalirayo ndi amayi ake kapena abambo ake. ");
INSERT INTO nya_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Asadzidetse potulukira kunja kwa malo opatulika popeza mafuta womupatula kukhala wansembe ali pamutu pake. Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘Iye akwatire namwali wosadziwa mwamuna. ");
INSERT INTO nya_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Asakwatire mkazi wamasiye, mkazi wosudzulidwa, kapena mkazi wachiwerewere, koma akwatire namwali wosadziwa mwamuna pakati pa anthu a mtundu wake, ");
INSERT INTO nya_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","kuti mtundu wake usakhale wodetsedwa pakati pa abale popeza ndine Yehova, amene ndimamuyeretsa.’ ” ");
INSERT INTO nya_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Muwuze Aaroni kuti, ‘Munthu aliyense mwa zidzukulu zake ku mibado yawo yonse ikubwera akakhala ndi chilema asabwere kudzapereka nsembe kwa Mulungu wake. ");
INSERT INTO nya_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Munthu aliyense wachilema motere: munthu wakhungu kapena wolumala miyendo, munthu wolumala nkhope kapena waziwalo zambiri, ");
INSERT INTO nya_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","munthu wa phazi lolumala kapena dzanja lolumala, ");
INSERT INTO nya_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","kapena munthu wokhota msana kapena wamfupi kwambiri, kapena wolumala maso, munthu wa nthenda yonyerenyetsa, kapena wamphere, kapenanso wophwanyika mavalo, sayenera kusendera pafupi. ");
INSERT INTO nya_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Mdzukulu aliyense wa Aaroni wansembe, amene ali ndi chilema asadzayandikire kukapereka nsembe zopsereza kwa Yehova. Popeza kuti ali ndi chilema, asayandikire kudzapereka nsembe ya chakudya kwa Mulungu wake. ");
INSERT INTO nya_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Koma iye angathe kudya chakudya chopatulika kwambiri chija, ngakhalenso chakudya chotsala pa nsembe zopatulika. ");
INSERT INTO nya_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Koma chifukwa cha kulumala kwake, sayenera kuyandikira katani kapena kufika pa guwa kuti angadetse malo anga wopatulika. Ine ndine Yehova, amene ndimawayeretsa.’ ” ");
INSERT INTO nya_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Choncho Mose anawuza Aaroni ndi ana ake pamodzi ndi Aisraeli onse zimenezi. ");
INSERT INTO nya_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Uza Aaroni ndi ana ake kuti azilemekeza zinthu zopatulika zimene Aisraeli azipereka kwa Ine, kuti asayipitse dzina langa loyera. Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Uwawuze kuti ngati wina aliyense mwa zidzukulu zawo mʼmibado yonse imene ikubwera adzayandikira zinthu zopatulika zimene ana a Israeli apereka kwa Yehova, ali wodetsedwa, ameneyo achotsedwe pamaso pa Yehova. Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Munthu aliyense mwa zidzukulu za Aaroni amene ali ndi khate kapena amatulutsa zoyipa mʼthupi mwake, asadye zinthu zopatulika mpaka atayeretsedwa. Wansembe angakhale wodetsedwa atakhudzana ndi chinthu chimene chadetsedwa ndi chinthu chakufa kapena kukhudza munthu amene wataya umuna, ");
INSERT INTO nya_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","kapena kukhudza chilichonse chokwawa chomwe chimadetsa munthu, kapena kukhudza munthu amene angamudetse, kapenanso kukhudza kanthu kena kalikonse kodetsedwa. ");
INSERT INTO nya_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Tsono ngati wansembe angakhudze chilichonse mwa zimenezi ndiye kuti adzakhala wodetsedwa mpaka madzulo. Asadye chopereka chilichonse chopatulika mpaka atasamba thupi lake lonse. ");
INSERT INTO nya_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Munthuyo adzakhala woyeretsedwa pamene dzuwa lalowa, ndipo angathe kudya chopereka chopatulikacho popeza ndi chakudya chake. ");
INSERT INTO nya_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Wansembe sayenera kudya chinthu chofa chokha kapena chojiwa ndi chirombo kuopa kuti angadzidetse ndi chakudyacho. Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘Choncho ansembe azisunga malamulo angawa kuti asapezeke wolakwa ndi kufa chifukwa chopeputsa malamulowa. Ine ndine Yehova, amene ndimawayeretsa. ");
INSERT INTO nya_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘Aliyense amene si wabanja la wansembe, kaya ndi mlendo wa wansembe, kapena wantchito wake, asadye chopereka chopatulika. ");
INSERT INTO nya_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Koma kapolo amene wagulidwa ndi ndalama kapena kubadwira mʼbanja la wansembe angathe kudya chakudya cha wansembeyo. ");
INSERT INTO nya_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Mwana wamkazi wa wansembe amene wakwatiwa ndi munthu amene si wansembe, asadyeko nsembe zopatulikazo. ");
INSERT INTO nya_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Koma mwana wamkazi wa wansembe amene ali wamasiye kapena wosudzulidwa, ndipo alibe mwana, komanso anabwerera ku nyumba ya abambo ake monga pa nthawi ya utsikana wake, angathe kudya chakudya cha abambo ake. Mlendo asadye chakudya chopatulika. ");
INSERT INTO nya_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘Ngati munthu wina aliyense adya chopereka chopatulika mosadziwa, munthuyo amubwezere wansembe chinthu chopatulikacho ndipo awonjezerepo limodzi la magawo asanu a chinthucho. ");
INSERT INTO nya_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Choncho ansembe asayipitse zopereka zopatulika za Aisraeli zimene apereka kwa Yehova ");
INSERT INTO nya_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ndipo asachimwitse ndi kupalamulitsa Aisraeli powalola kudya zakudya zawo zopatulika. Ine ndine Yehova amene ndimawayeretsa.’ ” ");
INSERT INTO nya_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Yankhula ndi Aaroni, ana ake pamodzi ndi Aisraeli onse, ndipo uwawuze kuti, ‘Ngati wina aliyense wa inu, Mwisraeli kapena mlendo amene akukhala mu Israeli abwera ndi mphatso ya nsembe yopsereza kwa Yehova, kupereka chimene analumbira kapena kuti ikhale nsembe yaufulu, ");
INSERT INTO nya_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ndiye kuti abwere ndi ngʼombe yayimuna, nkhosa yayimuna kapena mbuzi yayimuna. Izi zikhale zopanda chilema kuti zilandiridwe. ");
INSERT INTO nya_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Musapereke nyama iliyonse yokhala ndi chilema chifukwa sidzalandiridwa mʼmalo mwanu. ");
INSERT INTO nya_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Pamene wina aliyense abweretsa ngʼombe kapena nkhosa kuti ikhale nsembe yachiyanjano kwa Yehova, kukwaniritsa zimene analumbira kapena kuti ikhale nsembe yaufulu, nyamayo iyenera kukhala yangwiro ndi yopanda chilema kuti ilandiridwe. ");
INSERT INTO nya_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Musapereke kwa Yehova nyama zakhungu, zovulala kapena zolumala, kapena nyama zimene zikutulutsa mafinya mʼthupi mwake, kapena zimene zili ndi nthenda yonyerenyetsa, kapena zimene zili ndi mphere. Nyama zotere musaziyike pa guwa kuti zikhale nsembe yopsereza kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Koma mungathe kupereka ngʼombe yayimuna kapena nkhosa imene ili ndi chiwalo chachitali kapena chachifupi kukhala nsembe yaufulu. Koma simungayipereke ngati nsembe yoperekera zimene munalumbirira chifukwa sidzalandiridwa. ");
INSERT INTO nya_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Nyama iliyonse imene mavalo ake ndi onyuka kapena ophwanyika, ongʼambika kapena oduka, musamayipereke kwa Yehova mʼdziko lanu. ");
INSERT INTO nya_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Ndipo musalandire nyama zotere kuchokera kwa mlendo ndi kuzipereka kukhala zakudya za Mulungu wanu. Zimenezi sizidzalandiridwa mʼmalo mwanu chifukwa zili ndi chilema ndipo ndi zolumala.’ ” ");
INSERT INTO nya_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Pamene mwana wangʼombe, mwana wankhosa kapena mwana wambuzi wabadwa, akhale ndi make kwa masiku asanu ndi awiri. Kuyambira tsiku lachisanu ndi chitatu mpaka mʼtsogolo mwake, angathe kulandiridwa kuti akhale nsembe yopsereza ya kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Musaphe ngʼombe kapena nkhosa pamodzi ndi mwana wake tsiku limodzi. Muyidye pa tsiku lomwelo; musasiyeko ina mpaka mmawa. Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Pamene mupereka nsembe yoyamika kwa Yehova, muyipereke mwakufuna kwanu mu njira yoti ilandiridwe mʼmalo mwanu. ");
INSERT INTO nya_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Muyidye pa tsiku lomwelo, wosasiyako ina mpaka mmawa. Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Choncho sungani malamulo anga ndi kuwatsatira. Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Musanyoze dzina langa loyera. Koma lilemekezedwe pakati pa Aisraeli. Ine ndine Yehova amene ndimakuyeretsani ");
INSERT INTO nya_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ndipo ndine amene ndinakutulutsani mu Igupto kuti ndikhale Mulungu wanu. Ine ndine Yehova.” ");
INSERT INTO nya_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Yankhula ndi Aisraeli ndipo uwawuze kuti, ‘Awa ndi masiku anga osankhika a chikondwerero, masiku osankhika olemekeza Yehova amene uyenera kulengeza kuti akhale masiku opatulika a misonkhano. ");
INSERT INTO nya_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘Pa masiku asanu ndi limodzi muzigwira ntchito, koma tsiku lachisanu ndi chiwiri ndi Sabata lopuma, tsiku la msonkhano wopatulika. Kulikonse kumene inu mukukhala musamagwire ntchito iliyonse tsiku limeneli popeza ndi tsiku la Sabata la Yehova. ");
INSERT INTO nya_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘Awa ndiwo masiku osankhidwa a zikondwerero za Yehova, masiku woyera a misonkhano amene muti mudzalengeze pa nthawi yake: ");
INSERT INTO nya_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Chikondwerero cha Paska chiziyamba madzulo a tsiku la 14 la mwezi woyamba. ");
INSERT INTO nya_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Tsiku la 15 la mwezi womwewo ndi tsiku lolemekeza Yehova ndipo muziyamba Chikondwerero cha Buledi Wopanda Yisiti. Muzidya buledi wopanda yisiti kwa masiku asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Pa tsiku loyamba muzichita msonkhano wopatulika. Musamagwire ntchito iliyonse. ");
INSERT INTO nya_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Pa masiku asanu ndi awiri muzipereka nsembe yopsereza kwa Yehova. Ndipo tsiku lachisanu ndi chiwiri muzikhala ndi msonkhano wopatulika ndipo musamagwire ntchito yolemetsa.’ ” ");
INSERT INTO nya_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Yankhula ndi Aisraeli ndipo uwawuze kuti, ‘Mukakalowa mʼdziko limene ndikukupatsanilo ndi kukolola za mʼminda mwanu, mudzabwere kwa wansembe ndi mtolo wa tirigu woyambirira kucha wa mʼminda mwanu. ");
INSERT INTO nya_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Wansembeyo auweyule mtolowo pamaso pa Yehova kotero mtolowo udzalandiridwa mʼmalo mwanu. Wansembe auweyule tsiku lotsatana ndi la Sabata. ");
INSERT INTO nya_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Pa tsiku limene muweyula mtolowo, muperekenso mwana wankhosa wa mwamuna wa chaka chimodzi, wopanda chilema kuti akhale nsembe yopsereza ya kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Chopereka chachakudya chake chikhale cha makilogalamu awiri a ufa wosalala wosakaniza ndi mafuta kuti chikhale nsembe yopsereza yopereka kwa Yehova, ya fungo lokoma. Ndipo chopereka cha chakumwa chake chikhale vinyo wa malita anayi ndi theka. ");
INSERT INTO nya_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Musadye buledi aliyense kapena tirigu wokazinga, kapena wamuwisi mpaka tsiku limene mwabwera ndi chopereka ichi kwa Mulungu wanu. Limeneli ndi lamulo lamuyaya pa mibado yanu yonse, kulikonse kumene mukakhale. ");
INSERT INTO nya_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘Kuyambira tsiku lotsatana ndi la Sabata lija, tsiku limene munabwera ndi mtolo wa nsembe yoweyula, muziwerenga masabata asanu ndi awiri athunthu. ");
INSERT INTO nya_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Ndiye kuti muwerenge masiku makumi asanu kuchokera pa tsiku lotsatana ndi Sabata la chisanu ndi chiwiri, ndipo kenaka mupereke nsembe ya tirigu watsopano kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Kuchokera kulikonse kumene mukukhala, mubwere pamaso pa Yehova ndi buledi muwiri wa ufa wosalala wa makilogalamu awiri, ophikidwa ndi yisiti kuti akhale nsembe yoweyula ya zakudya zoyamba kucha. ");
INSERT INTO nya_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Pamodzi ndi bulediyu muperekenso ana ankhosa aamuna asanu ndi awiri, aliyense akhale wa chaka chimodzi ndi wopanda chilema. Pakhalenso ngʼombe yayingʼono yayimuna ndi nkhosa zazimuna ziwiri. Zimenezi zidzakhala nsembe zopsereza zopereka kwa Yehova pamodzi ndi nsembe za zakudya ndi nsembe za zakumwa. Zonsezi zikhale nsembe zopsereza za fungo lokomera Yehova. ");
INSERT INTO nya_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Kenaka mupereke mbuzi imodzi yayimuna kuti ikhale nsembe yopepesera machimo ndiponso ana ankhosa awiri, aliyense wa chaka chimodzi kuti akhale nsembe yachiyanjano. ");
INSERT INTO nya_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Wansembe aweyule ana ankhosa awiriwo pamaso pa Yehova monga nsembe yoweyula, pamodzi ndi buledi wa tirigu woyambirira kucha. Zimenezi ndi zopereka zopatulika za Yehova zopatsidwa kwa ansembe. ");
INSERT INTO nya_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Pa tsiku lomwelo mulengeze za msonkhano wopatulika ndipo musagwire ntchito zolemetsa. Limeneli ndi lamulo lamuyaya pa mibado yanu yonse, kulikonse kumene mukakhale. ");
INSERT INTO nya_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘Pamene mukukolola zinthu mʼmunda mwanu, musakolole munda wanu mpaka mʼmalire mwenimweni, ndipo musatole khunkha lake. Zimenezo musiyire anthu osauka ndi alendo. Ine ndine Yehova Mulungu wanu.’ ” ");
INSERT INTO nya_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Uza Aisraeli kuti, ‘Tsiku loyamba la mwezi wachisanu ndi chiwiri, likhale tsiku lopumula, la msonkhano wopatulika, mulilengeze poyimba lipenga. ");
INSERT INTO nya_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Musagwire ntchito zolemetsa koma mupereke nsembe yopsereza kwa Yehova.’ ” ");
INSERT INTO nya_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Tsiku lakhumi la mwezi wachisanu ndi chiwiri ndi tsiku lochita Mwambo Wopepesera Machimo. Muzichita msonkhano wopatulika. Muzidzichepetsa pamaso pa Yehova ndi kupereka nsembe zopsereza kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Tsiku limeneli musamagwire ntchito chifukwa ndi tsiku la Mwambo Wopepesera Machimo, kupepesera machimo anu pamaso pa Yehova Mulungu wanu. ");
INSERT INTO nya_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Munthu aliyense amene sasala zakudya pa tsiku limeneli ayenera kuchotsedwa pakati pa anthu a mtundu wake. ");
INSERT INTO nya_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Aliyense wogwira ntchito tsiku limeneli ndidzamuwononga pakati pa anthu a mtundu wake. ");
INSERT INTO nya_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Inu musadzagwire ntchito iliyonse. Limeneli ndi lamulo lamuyaya pa mibado yanu yonse, kulikonse kumene mukakhale. ");
INSERT INTO nya_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Limeneli kwa inu ndi tsiku la Sabata lopumula, ndipo muyenera kusala zakudya. Kuyambira madzulo a tsiku lachisanu ndi chinayi la mwezi mpaka madzulo ena otsatirawo muzisunga tsikulo ngati Sabata lanu.” ");
INSERT INTO nya_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Uwawuze Aisraeli kuti pa masiku asanu ndi awiri kuyambira pa tsiku la 15 la mwezi wachisanu ndi chiwiri pazikhala Chikondwerero cha Misasa cholemekeza Yehova. ");
INSERT INTO nya_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Tsiku loyamba ndi la msonkhano wopatulika, musagwire ntchito zolemetsa. ");
INSERT INTO nya_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Pa masiku asanu ndi awiri muzipereka nsembe zopsereza kwa Yehova. Ndipo pa tsiku lachisanu ndi chitatu muzikhala ndi msonkhano wopatulika ndipo muzipereka nsembe yopsereza kwa Yehova. Kumeneku ndi kutsekera kwa msonkhano waukulu. Musagwire ntchito zolemetsa. ");
INSERT INTO nya_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(“ ‘Amenewa ndi masiku osankhika a chikondwerero cha Yehova, amene muziwalengeza kuti ndi nthawi ya msonkhano wopatulika. Masiku amenewa muzipereka nsembe zopsereza, nsembe za chakudya, nsembe zanyama ndi zopereka zachakumwa za tsiku ndi tsiku. ");
INSERT INTO nya_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Zopereka zimenezi ndi zowonjezera pa zopereka za Yehova za pa Sabata, zopereka zanu zolumbira ndiponso mphatso zanu zaufulu zopereka kwa Yehova.) ");
INSERT INTO nya_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘Choncho kuyambira pa tsiku la 15 la mwezi wachisanu ndi chiwiri, mutakolola zinthu mʼmunda mwanu, muchite chikondwerero cha Yehova kwa masiku asanu ndi awiri. Tsiku loyamba ndi tsiku lopumula, ndipo tsiku lachisanu ndi chitatu ndi lopumulanso. ");
INSERT INTO nya_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Pa tsiku loyamba muzitenga zipatso zabwino kwambiri zothyola mʼmitengo, nthambi za kanjedza, nthambi zazikulu za mitengo ya masamba ambiri, ndi za misondozi yakumtsinje, ndipo muzikondwera pamaso pa Yehova Mulungu wanu kwa masiku asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Chaka chilichonse muzichita chikondwerero cha Yehova kwa masiku asanu ndi awiri. Limeneli ndi lamulo lamuyaya pa mibado yanu yonse. Muzichita chikondwerero chimenechi mwezi wachisanu ndi chiwiri. ");
INSERT INTO nya_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Muzikhala mʼmisasa masiku asanu ndi awiri. Onse amene ali mbadwa mʼdziko la Israeli azikhala mʼmisasa ");
INSERT INTO nya_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","kuti zidzukulu zanu zidzadziwe kuti ndine amene ndinakhazika Aisraeli mʼmisasa nditawatulutsa ku Igupto. Ine ndine Yehova Mulungu wanu.’ ” ");
INSERT INTO nya_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Choncho Mose analengeza kwa Aisraeli masiku osankhika a zikondwerero za Yehova. ");
INSERT INTO nya_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Lamula Aisraeli kuti akupatse mafuta anyale, a olivi wabwino kwambiri kuti nyalezo ziziyaka nthawi zonse. ");
INSERT INTO nya_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Kunja kwa nsalu yotchinga Bokosi la Chipangano, mʼchihema cha msonkhano, Aaroni azionetsetsa kuti nyale ikukhala chiyakire pamaso pa Yehova kuyambira madzulo mpaka mmawa, nthawi zonse. Limeneli ndi lamulo lamuyaya pa mibado yonse. ");
INSERT INTO nya_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Aaroni ayatse nyale zimene zili pa choyikapo nyale chagolide wabwino kwambiri kuti zikhale zoyaka nthawi zonse pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Mutenge ufa wosalala ndipo muphike makeke khumi ndi awiri ndipo keke iliyonse ikhale ya ufa wa makilogalamu awiri. ");
INSERT INTO nya_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Muwayike pa tebulo la golide wabwino kwambiri pamaso pa Yehova mʼmizere iwiri. Mzere uliwonse ukhale wa makeke asanu ndi imodzi. ");
INSERT INTO nya_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Pa mzere uliwonse muyikepo lubani wafungo lokoma kuti pamodzi ndi bulediyo akhale wachikumbutso cha nsembe yopsereza yopereka kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Sabata ndi sabata nthawi zonse Aaroni aziyika makeke amenewa pamaso pa Yehova mʼmalo mwa Aisraeli onse kuti akhale pangano lamuyaya. ");
INSERT INTO nya_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Chakudyacho ndi cha Aaroni ndi ana ake ndipo azidyera ku malo wopatulika chifukwa kwa iye chakudyacho ndi chopatulika kwambiri chochokera pa chopereka chopsereza cha Yehova.” ");
INSERT INTO nya_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Tsiku lina munthu wina wamwamuna amene amayi ake anali Mwisraeli koma abambo ake anali Mwigupto anapita kwa Aisraeli ndipo anakangana ndi Mwisraeli wina ku msasa. ");
INSERT INTO nya_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Munthu uja ananyoza dzina la Yehova ndi kulitemberera. Choncho anabwera naye kwa Mose. Dzina la amayi ake linali Selomiti, mwana wa Dibiri, wa fuko la Dani. ");
INSERT INTO nya_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Anamuyika mʼndende mpaka atadziwa bwino chofuna cha Yehova. ");
INSERT INTO nya_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Ndipo Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Pita naye kunja kwa msasa munthu wotembererayo. Onse amene anamumva akutemberera asanjike manja awo pamutu pake ndipo gulu lonse la anthu limugende miyala. ");
INSERT INTO nya_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Choncho uza Aisraeli kuti, ‘Aliyense wotemberera Mulungu wake alangidwe. ");
INSERT INTO nya_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Aliyense wonyoza dzina la Yehova, mlendo ngakhale mbadwa, aphedwe. Gulu lonse la anthu limuponye miyala. ");
INSERT INTO nya_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘Ngati munthu wina aliyense achotsa moyo wa munthu mnzake, munthuyo ayenera kuphedwa. ");
INSERT INTO nya_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Aliyense wopha chiweto cha mnzake ayenera kulipira china. Moyo kulipa moyo. ");
INSERT INTO nya_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Ngati munthu avulaza mnzake, nayenso amuchite zomwe wachitira mnzakeyo: ");
INSERT INTO nya_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","kuthyola fupa kulipira kuthyola fupa, diso kulipira diso, dzino kulipira dzino. Monga momwe anavulazira mnzake, amuvulaze chimodzimodzinso. ");
INSERT INTO nya_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Aliyense wopha chiweto cha mnzake, alipire chiweto china, koma aliyense wopha munthu ayenera kuphedwa. ");
INSERT INTO nya_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Lamulo la mlendo ndi mbadwa ndi limodzi lomweli. Ine ndine Yehova Mulungu wanu.’ ” ");
INSERT INTO nya_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Pamenepo Mose anawuza Aisraeli zimenezi, ndipo iwo anatulutsira munthu wotembererayo kunja kwa msasa ndi kumugenda miyala. Aisraeli anachita zimene Yehova analamula Mose. ");
INSERT INTO nya_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Yehova anawuza Mose pa phiri la Sinai kuti, ");
INSERT INTO nya_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Yankhula ndi Aisraeli ndipo uwawuze kuti, ‘Mukadzalowa mʼdziko limene ndikukupatsani, nthakayo iyenera kumakasunga Sabata la Yehova. ");
INSERT INTO nya_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Pa zaka zisanu ndi chimodzi muzikalima minda yanu, ndipo kwa zaka zisanu ndi chimodzi muzikasadza mitengo yanu ya mpesa ndi kuthyola zipatso zake. ");
INSERT INTO nya_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Koma chaka chachisanu ndi chiwiri ndi chaka choti nthaka ipume, chaka cha Sabata la Yehova. Musalime mʼminda yanu kapena kusadza mitengo yanu ya mpesa. ");
INSERT INTO nya_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Musakolole zimene zinamera zokha mʼmunda mwanu. Musakakolole kapena kuthyola mphesa za mʼmitengo imene simunasadze. Chaka chimenechi nʼchoti nthaka ipumule. ");
INSERT INTO nya_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Chaka chimene nthakayo ipumula mudzakhala ndi chakudya chokwanira inuyo, akapolo anu aamuna ndi aakazi, antchito ndi alendo okhala nanu. ");
INSERT INTO nya_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Ziweto zanu pamodzi ndi nyama za mʼdziko lanu zizidzadya zipatso za mʼnthaka. ");
INSERT INTO nya_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘Muzichotsera Masabata asanu ndi awiri a zaka, ndi kuchulukitsa zaka zisanu ndi ziwiri kasanu ndi kawirinso kuti Masabata asanu ndi awiri a zakawo akwane zaka 49. ");
INSERT INTO nya_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Ndipo pa tsiku la khumi la mwezi wachisanu ndi chiwiri mulize lipenga mofuwula. Tsiku lochita mwambo wopepesera machimo muziliza lipenga mʼdziko lanu lonse. ");
INSERT INTO nya_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Mupatule chaka cha makumi asanu, ndipo mulengeze kuti pakhale ufulu mʼdziko lonse kwa onse amene ali mʼmenemo. Kwa inu chakachi chidzakhala choyimba lipenga la chikondwerero. Aliyense wa inu adzayenera kubwerera pa munda wake, ndipo aliyense wa inu adzabwerera ku fuko lake. ");
INSERT INTO nya_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Kwa inu chakachi chidzakhaladi chaka choyimba lipenga kukondwerera zaka makumi asanu. Pa chaka chimenechi musadzale kanthu ndipo musakolole mbewu zomera zokha kapenanso kuthyola mphesa pa mitengo yosasadzira. ");
INSERT INTO nya_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Chimenechi ndi chaka chokondwerera zaka makumi asanu. Choncho chikhale chaka chopatulika kwa inu. Muzidya zokhazo zimene zakololedwa mʼminda. ");
INSERT INTO nya_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘Chaka chimenechi ndi choliza lipenga, kukondwerera zaka makumi asanu, ndipo aliyense abwerere pa malo ake. ");
INSERT INTO nya_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘Ngati unagulitsa kapena kugula malo ako kwa mnzako wa mʼdzikomo, pasakhale kuchenjeretsana. ");
INSERT INTO nya_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Ugule kwa mnzako potsata chiwerengero cha zaka zimene zatha kuyambira pa chikondwerero cha chaka cha makumi asanu chapita. Ndipo mnzakoyo akugulitse potsata chiwerengero cha zaka zokolola zomwe zatsala. ");
INSERT INTO nya_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Zaka zikakhala zochuluka, uwonjezere mtengo, ndipo zaka zikakhala zochepa, uchepetse mtengo, pakuti chimene iye akukugulitsa ndi zaka zokolola. ");
INSERT INTO nya_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Musachenjeretsane koma muope Mulungu wanu. Ine ndine Yehova Mulungu wanu. ");
INSERT INTO nya_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘Tsatirani malangizo anga ndipo mverani mosamala malamulo anga ndipo mudzakhala mʼdzikomo mwamtendere. ");
INSERT INTO nya_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Ndipo nthaka idzakupatsani zipatso zake. Mudzadya mpaka kukhuta ndiponso mudzakhala mʼdzikomo mwamtendere. ");
INSERT INTO nya_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Mwina nʼkafunsa kuti, ‘Kodi chaka chachisanu ndi chiwiri tidzadya chiyani ngati sitidzala kapena kukolola mbewu zathu?’ ");
INSERT INTO nya_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Ine ndidzatumiza madalitso ambiri chaka chachisanu ndi chimodzi moti nthaka yanu idzabala zinthu zokwanira kudya zaka zitatu. ");
INSERT INTO nya_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Pamene mukudzala chaka chachisanu ndi chitatu, muzidzadya chakudya chogonera ndipo mudzapitirira kudya mpaka nthawi yokolola mʼchaka chachisanu ndi chinayi. ");
INSERT INTO nya_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘Malo asagulitsidwe mpaka muyaya chifukwa dzikolo ndi langa. Inu ndinu alendo okhala ndi Ine. ");
INSERT INTO nya_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Malo onse amene ali mʼmanja mwanu mudzalole kuti amene anakugulitsani awawombole. ");
INSERT INTO nya_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘Ngati Mwisraeli mnzanu wasauka nagulitsako gawo lina la malo ake, mʼbale wake wapaphata abwere kudzawombola malo amene mʼbale wakeyo wagulitsa. ");
INSERT INTO nya_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Koma ngati munthuyo alibe wachibale woti nʼkuwombola malowo koma pambuyo pake iye mwini nʼkulemera ndi kupeza zokwanira kuwombolera, awombole malowo. ");
INSERT INTO nya_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Awerengerane zaka kuyambira pamene anagulitsa mundawo ndipo amubwezere amene anagulayo ndalama zimene akanayenera kuzipereka mpaka chaka chokondwerera zaka makumi asanu. Atatero angathe kubwerera pa malo ake. ");
INSERT INTO nya_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Koma ngati sakhala nazo zokwanira kuti amubwezere amene anagula malowo, gawo limene anagulitsalo lidzakhala mʼmanja mwa munthu amene anagulayo mpaka chaka chokondwerera zaka makumi asanu. Malowo adzabwezedwa chaka chimenechi, ndipo iye adzatha kubwerera pa malo ake. ");
INSERT INTO nya_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘Ngati munthu agulitsa nyumba ya mu mzinda umene uli mu linga, angathe kuyiwombola nyumbayo chisanathe chaka chathunthu chigulitsire. Mu nthawi imeneyi wogulitsayo atha kuyiwombola. ");
INSERT INTO nya_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ngati nyumbayo siwomboledwa chisanathe chaka chimodzicho, nyumbayo idzakhala ya amene anagulayo ndi zidzukulu zake mpaka muyaya. Sidzabwezedwanso kwa mwini wake mʼchaka chokondwerera zaka makumi asanu. ");
INSERT INTO nya_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Koma nyumba za mʼmizinda yosazingidwa ndi linga ziwomboledwe monga mmene achitira ndi minda ya mʼdzikomo. ");
INSERT INTO nya_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘Alevi ali ndi ufulu owombola nyumba zawo za mʼmidzi yawo nthawi ina iliyonse. ");
INSERT INTO nya_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Koma ngati Mlevi sawombola nyumba imene inagulitsidwa mʼmudzi mwake, ndiye kuti idzabwezedwe mʼchaka choliza lipenga pokondwerera zaka makumi asanu, popeza nyumba zimenezi zili mʼmidzi ya Alevi ndi yawo pakati pa Aisraeli. ");
INSERT INTO nya_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Koma malo owetera ziweto a mʼmidzi yawoyo sayenera kugulitsidwa. Awa ndi malo awo mpaka muyaya. ");
INSERT INTO nya_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘Ngati mʼbale wako akhala wosauka kuti sangathe kudzisamalira yekha, umuthandize. Ukhale naye ngati mlendo kapena ngati munthu amene ukhala naye kwa kanthawi. ");
INSERT INTO nya_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Usalandire chiwongoladzanja chilichonse kuchokera kwa iye kapena kuwonjezerapo kanthu kena, koma uziopa Mulungu kuti mʼbale wakoyo akhale nawe. ");
INSERT INTO nya_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Musakongoze mnzanu ndalama kuti mulandire chiwongoladzanja, kapena kumugulitsa chakudya kuti mupeze phindu. ");
INSERT INTO nya_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ine ndine Yehova Mulungu wanu, amene ndinakutulutsani mʼdziko la Igupto kuti ndikupatseni dziko la Kanaani ndi kuti ndikhale Mulungu wanu. ");
INSERT INTO nya_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘Ngati mʼbale wanu asauka ndipo adzigulitsa yekha kwa inu, musamugwiritse ntchito ngati kapolo. ");
INSERT INTO nya_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Akhale ngati wantchito kapena ngati mlendo. Akugwirireni ntchito mpaka chaka chokondwerera zaka makumi asanu. ");
INSERT INTO nya_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Kenaka iye ndi ana ake achoke, ndipo apite ku fuko lake ndi kubwerera ku malo a makolo ake. ");
INSERT INTO nya_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Chifukwa Aisraeli ndi atumiki anga amene ndinawatulutsa mʼdziko la Igupto, asagulitsidwe ngati akapolo. ");
INSERT INTO nya_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Musawalamulire mwankhanza koma wopani Mulungu wanu. ");
INSERT INTO nya_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘Kunena za akapolo aamuna ndi aakazi, amenewa mungathe kuwagula kuchokera kwa mitundu ya anthu imene yakuzungulirani. ");
INSERT INTO nya_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Mungathenso kugula akapolo kuchokera kwa alendo amene akukhala nanu kapena kuchokera ku mabanja amene mukukhala nawo amene ndi mbadwa za mʼdziko lanu. Iwowa akhoza kukhala akapolo anu. ");
INSERT INTO nya_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Akapolowo mungathe kuwasiya mʼmanja mwa ana anu inu mutafa kuti akhale cholowa chawo moyo wawo wonse. Koma musawalamulire mwankhanza Aisraeli anzanu. ");
INSERT INTO nya_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘Ngati mlendo kapena munthu amene akukhala nanu kwa kanthawi kochepa alemera ndipo mmodzi wa abale anu amene akukhala naye pafupi nʼkusauka, nadzigulitsa yekha kwa mlendo amene akukhala pakati panuyo kapena kwa mmodzi wa fuko la munthu wongokhala pafupi nayeyo, ");
INSERT INTO nya_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","wodzigulitsayo ali ndi ufulu wowomboledwa. Mmodzi mwa abale ake angathe kumuwombola: ");
INSERT INTO nya_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","amalume ake kapena mwana wa amalume ake, kapena wachibale wa mu fuko lake. Kapena ngati iye mwini alemera, atha kudziwombola yekha. ");
INSERT INTO nya_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Iye pamodzi ndi munthu amene anamugulayo awerengerane kuyambira chaka chimene anadzigulitsa kwa iyeyo mpaka chaka chokondwerera zaka makumi asanu. Mtengo wodziwombolera ukhale wofanana ndi zakazo. Ndipo nthawi imene anali ndi mbuye wakeyo iwerengedwe ngati nthawi ya munthu wantchito. ");
INSERT INTO nya_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ngati patsala zaka zambiri, iye ayenera kulipira mtengo woposera umene anamugulira. ");
INSERT INTO nya_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Ngati kwatsala zaka zochepa kuti ifike nthawi ya chaka chokondwerera zaka makumi asanu, iye awerengerane ndi mbuye wake, ndipo apereke ndalama za zowomboledwera molingana ndi zaka zotsalazo. ");
INSERT INTO nya_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Azikhala naye ngati wantchito wolembedwa chaka ndi chaka. Ndipo muonetsetse kuti mbuye wakeyo sakumulamulira mwankhanza. ");
INSERT INTO nya_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘Ngakhale munthuyo atapanda kuwomboledwa mwa njira zimenezi, iye ndi ana ake ayenera kumasulidwa mʼchaka chokondwerera zaka makumi asanu, ");
INSERT INTO nya_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","pakuti Aisraeli ndi atumiki anga. Iwo ndi atumiki anga amene ndinawatulutsa mʼdziko la Igupto. Ine ndine Yehova Mulungu wanu. ");
INSERT INTO nya_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘Musadzipangire mafano ndipo musayimike chifanizo chosema kapena mwala woti mudzipembedza. Musayike mwala wosema mʼdziko mwanu kuti muziwugwadira. Ine ndine Yehova Mulungu wanu. ");
INSERT INTO nya_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘Muzisunga Masabata anga ndipo muzilemekeza malo anga wopatulika. Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘Mukamayenda motsata malangizo anga ndi kumvera mosamalitsa malamulo anga, ");
INSERT INTO nya_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ndidzakupatsani mvula pa nyengo yake. Nthaka yanu idzabala zokolola zake, ndipo mitengo ya mʼmunda idzabala zipatso zake. ");
INSERT INTO nya_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Mudzakhala mukupuntha tirigu mpaka nthawi yothyola mphesa, ndipo mudzakhala mukuthyola mphesa mpaka nthawi yodzala. Mudzadya chakudya chanu mpaka kukhuta ndipo mudzakhala mʼdziko lanu mwamtendere. ");
INSERT INTO nya_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘Ndidzabweretsa mtendere mʼdziko lanu, ndipo muzidzagona popanda wokuopsezani. Ndidzachotsa nyama zakuthengo zoopsa mʼdziko mwanu, ndipo mʼdzikomo simudzakhala nkhondo. ");
INSERT INTO nya_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Mudzapirikitsa adani anu, ndipo mudzawagonjetsa ndi lupanga pamaso panu. ");
INSERT INTO nya_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Anthu asanu mwa inu adzapirikitsa anthu 100, ndipo anthu 100 mwa inu adzathamangitsa anthu 10,000, ndipo adani anuwo mudzawagonjetsa ndi lupanga. ");
INSERT INTO nya_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘Ndidzakukumbukirani ndi kukupatsani ana ambiri ndi kukuchulukitsani. Ndidzasunga pangano langa ndi inu. ");
INSERT INTO nya_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Mudzakhala mukudyabe chakudya chogonera ndipo mudzachotse chakudyacho mʼnkhokwe kuti mupezemo malo woyika chakudya china chatsopano. ");
INSERT INTO nya_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ndidzakhala pakati panu, ndipo sindidzayipidwa nanu. ");
INSERT INTO nya_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ine ndidzayendayenda pakati panu ndipo ndidzakhala Mulungu wanu. Inu mudzakhala anthu anga. ");
INSERT INTO nya_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ine ndine Yehova Mulungu wanu amene ndinakutulutsani mʼdziko la Igupto kuti musakhalenso akapolo a Aigupto. Ndinadula mipiringidzo ya goli lanu ndi kukuthandizani kuti muziyenda momasuka. ");
INSERT INTO nya_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘Koma mukadzapanda kundimvera ndi kuphwanya malamulo anga onsewa, ");
INSERT INTO nya_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ndipo ngati mudzanyoza malangizo anga ndi kunyansidwa ndi malamulo anga, ndi kulephera kumvera zonse zimene ndakulamulani, ndi kuswa pangano langa, ");
INSERT INTO nya_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Ine ndidzakuchitirani izi: ndidzabweretsa zoopsa zadzidzidzi monga chifuwa chachikulu chowondetsa ndiponso malungo amene adzawononga maso ndi kufowoketsa moyo wanu. Mudzangovutika kudzala mbewu zanu chifukwa adani anu adzazidya. ");
INSERT INTO nya_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ndidzakufulatirani, kotero kuti adani anu adzakugonjetsani. Odana nanu adzakulamulirani ndipo inu muzidzagothawa popanda wokupirikitsani. ");
INSERT INTO nya_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘Ngati simudzandimvera mutaona zonsezi, ndidzakulanganinso mochulukitsa kasanu ndi kawiri chifukwa cha kuchimwa kwanu. ");
INSERT INTO nya_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Ndidzathyola mphamvu zanu zimene mukunyadirazo, ndipo ndidzasandutsa mitambo kuti ikhale yowuma ngati chitsulo, ndiponso nthaka yanu kuti ikhale ngati mkuwa. ");
INSERT INTO nya_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Mphamvu zanu zidzapita pachabe chifukwa nthaka yanu sidzabala kanthu, ngakhale mitengo yake sidzabala zipatso zake. ");
INSERT INTO nya_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘Ngati mudzapitirira kutsutsana nane ndi kukana kundimvera, ndidzachulukitsa masautso anu kasanu ndi kawiri molingana ndi machimo anu. ");
INSERT INTO nya_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ndidzabweretsa zirombo zolusa pakati panu, ndipo zidzakulandani ana anu ndi kuwononga ngʼombe zanu. Choncho zidzachepetsa chiwerengero chanu kotero kuti mʼnjira mwanu simudzapita anthu. ");
INSERT INTO nya_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘Mukadzapanda kutembenukira kwa Ine ngakhale nditakulangani motere, ndi kumachitabe zotsutsana ndi Ine, ");
INSERT INTO nya_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Ine mwini ndidzalimbana nanu, ndipo ndidzakulangani mochulukitsa kasanu ndi kawiri chifukwa cha machimo anu. ");
INSERT INTO nya_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ndipo ndidzabweretsa lupanga pa inu ndi kukulangani chifukwa chophwanya pangano langa. Mukadzasonkhana mʼmizinda yanu, ndidzatumiza miliri pakati panu ndipo ndidzakuperekani mʼmanja mwa adani anu. ");
INSERT INTO nya_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Ndikadzachepetsa buledi wanu, akazi khumi adzaphika buledi wawo mu uvuni umodzi, ndipo adzakugawirani bulediyo pangʼonopangʼono. Choncho mudzadya koma wosakhuta. ");
INSERT INTO nya_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘Mukadzapanda kundimvera ngakhale nditakulangani motere, ndi kumatsutsanabe ndi Ine, ");
INSERT INTO nya_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","pamenepo ndidzalimbana nanu mwaukali, ndipo Ine mwini ndidzakulangani mochulukitsa kasanu ndi kawiri chifukwa cha kuchimwa kwanu. ");
INSERT INTO nya_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Mudzadya ana anu aamuna ndiponso mudzadya ana anu aakazi. ");
INSERT INTO nya_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Ine ndidzawononga malo anu opembedzera mafano a ku mapiri. Ndidzagwetsa maguwa anu ofukizira lubani, ndipo ndidzawunjika pamodzi mitembo ya mafano anu wopanda moyowo, ndipo ndidzanyansidwa nanu. ");
INSERT INTO nya_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ndidzasandutsa mizinda yanu kukhala mabwinja ndi kuwononga malo anu wopatulika. Sindidzakondweranso ndi fungo lokoma la zopereka zanu. ");
INSERT INTO nya_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ndidzawononga dziko kotero kuti adani anu mʼmenemo adzadabwa. ");
INSERT INTO nya_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ndidzakubalalitsani pakati pa mitundu ina ya anthu ndipo ndidzasolola lupanga langa ndi kukupirikitsani. Dziko lanu lidzawonongedwa, ndipo mizinda yanu idzasanduka mabwinja. ");
INSERT INTO nya_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Nthawi imeneyo nthaka idzasangalalira kuyipumitsa kwake nthawi yonse imene idzakhala yosalimidwa, pamene inu mudzakhala muli mʼdziko la adani anu. Pa nthawi imeneyo dziko lidzapumula ndi kukondwerera kulipumuza kwake. ");
INSERT INTO nya_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Nthawi zonse pamene dzikolo lidzakhala lopanda anthu, nthaka idzapumula. Mpumulo umenewu udzakhala umene nthakayo sinapumulepo pa nthawi zimene inu munkapumula muli mʼdzikomo. ");
INSERT INTO nya_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘Kunena za amene adzatsale, ndidzayika mantha mʼmitima mwawo mʼdziko la adani awo kotero kuti adzathawa ngakhale mtswatswa wa tsamba lowuluka ndi mphepo. Adzathawa ngati akuthawa lupanga, ndipo adzagwa pansi ngakhale padzakhale wopanda kuwapirikitsa. ");
INSERT INTO nya_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Iwo adzaphunthwitsana ngati akuthawa nkhondo, ngakhale padzakhale popanda wowapirikitsa. Choncho simudzatha kuyima pamaso pa adani anu. ");
INSERT INTO nya_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Mudzatheratu pakati pa mitundu ya anthu. Dziko la adani anu lidzakudyani. ");
INSERT INTO nya_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Ngakhale iwo amene adzatsale adzatheratu mʼdziko la adani awo chifukwa cha machimo awo ndi machimo a makolo awo. ");
INSERT INTO nya_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘Tsono adzawulula machimo awo ndi machimo a makolo awo, kusakhulupirika kwawo ndi mayendedwe awo otsutsana nane, ");
INSERT INTO nya_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","zomwe zinandipangitsa kuwafulatira ndi kuwapereka mʼmanja mwa adani awo. Ndipo mitima yawo yowumayo ikadzadzichepetsa ndi kuvomera kulangidwa chifukwa cha machimo awo, ");
INSERT INTO nya_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Ine ndidzakumbukira pangano langa ndi Yakobo, pangano langa ndi Isake, pangano langa ndi Abrahamu. Ndidzakumbukiranso dzikolo. ");
INSERT INTO nya_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Pakuti adzasiya dziko lawo lopanda anthu, nthaka idzakondwerera zaka zake zoyipumuza pamene iwo kudzakhala kulibe. Koma adzalangidwa chifukwa cha machimo awo popeza anakana malamulo anga ndipo mitima yawo inkayipidwa nawo malangizo anga. ");
INSERT INTO nya_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Komabe ngakhale adzachite zonsezi ali mʼdziko la adani awo, Ine sindidzawakana kapena kuyipidwa nawo kwakuti nʼkuwawononga kwathunthu ndi kuthetsa pangano langa ndi iwo. Ine ndine Yehova Mulungu wawo. ");
INSERT INTO nya_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Koma powachitira chifundo, ndidzakumbukira pangano langa ndi makolo awo amene ndinawatulutsa mʼdziko la Igupto mitundu ina ikuona kuti Ine ndikhale Mulungu wawo. Ine ndine Yehova.’ ” ");
INSERT INTO nya_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Amenewa ndi malamulo ndi malangizo amene Yehova anawayika pakati pa Iye mwini ndi Aisraeli pa Phiri la Sinai kudzera mwa Mose. ");
INSERT INTO nya_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Yankhula ndi Aisraeli ndipo uwawuze kuti, ‘Ngati munthu anachita lumbiro lapadera loti adzapereka munthu mnzake kwa Yehova ndipo akufuna kuti amuwombole, ");
INSERT INTO nya_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","mtengo wake ukhale masekeli a siliva makumi asanu, molingana ndi kawerengedwe ka ku Nyumba ya Mulungu, ngati munthuyo ndi wamwamuna wa zaka zapakati pa 20 ndi 60. ");
INSERT INTO nya_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Ndipo ngati ndi wamkazi, mtengo wake ukhale masekeli makumi atatu. ");
INSERT INTO nya_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Mtengo wa munthu wamwamuna wa zaka zapakati pa zisanu ndi makumi awiri ukhale masekeli makumi awiri ndipo munthu wamkazi ukhale masekeli khumi. ");
INSERT INTO nya_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Ngati ndi munthu wamwamuna wa pakati pa mwezi umodzi ndi zaka zisanu, mtengo wa munthu wamwamuna ukhale masekeli asanu a siliva ndipo ngati ndi wamkazi, ukhale masekeli atatu a siliva. ");
INSERT INTO nya_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Ngati ndi munthu wa zaka makumi asanu ndi limodzi kapena kuposerapo, mtengo wa wamwamuna ukhale masekeli khumi ndi asanu, ndipo wamkazi ukhale masekeli khumi. ");
INSERT INTO nya_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ngati munthu amene anachita lumbiro ndi wosauka kwambiri kuti sangathe kulipira ndalama zimenezo, abwere ndi munthu woperekedwa uja kwa wansembe, ndipo wansembeyo ayike mtengo woti munthu wolumbirayo angathe kulipira. ");
INSERT INTO nya_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘Ngati chimene anachitira lumbiro kuti apereke ndi nyama imene amapereka kukhala nsembe kwa Yehova, zonse zimene amapereka kwa Yehova nʼzopatulika. ");
INSERT INTO nya_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Munthu asasinthanitse ndi ina kapena kupereka ina yabwino mʼmalo mwa yoyipa, kapena yoyipa mʼmalo mwa yabwino. Ngati asinthitsa nyama ina mʼmalo mwa ina, nyamayo pamodzi ndi inzake wasinthitsayo zikhala zopatulika. ");
INSERT INTO nya_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Ngati chimene anachitira lumbiro ndi nyama yodetsedwa, nyama imene siloledwa kuyipereka kukhala nsembe kwa Yehova, nyamayo abwere nayo kwa wansembe, ");
INSERT INTO nya_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ndipo wansembeyo atchule mtengo wake poona ngati ndi yabwino kapena ndi yoyipa. Mtengo umene wansembe atchule ndiwo udzakhale mtengo wake. ");
INSERT INTO nya_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ngati mwini wakeyo akufuna kuwombola nyamayo, awonjezere pa mtengo wake wa nyamayo chimodzi mwa zigawo zisanu zamtengowo. ");
INSERT INTO nya_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘Ngati munthu apereka nyumba yake kuti ikhale yopatulika kwa Yehova, wansembe atchule mtengo wake poona ngati ndi yabwino kapena ndi yoyipa. Mtengo umene wansembe atchule ndiwo udzakhale mtengo wake. ");
INSERT INTO nya_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ngati munthu amene wapereka nyumbayo afuna kuyiwombola nyumbayo, awonjezere pamtengo wake wa nyumbayo, limodzi mwa magawo asanu amtengowo. Ndipo nyumbayo idzakhalanso yake. ");
INSERT INTO nya_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘Ngati munthu apereka kwa Yehova mbali ina ya malo a makolo ake, mtengo umene awuyike ukhale wolingana ndi mtengo wa mbewu zimene zimadzabzalidwamo. Zikhale mbewu za barele za makilogalamu makumi awiri ndipo mtengo wake ukhale masekeli makumi asanu. ");
INSERT INTO nya_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Ngati munthu apereka munda wake kuyambira chaka chokondwerera zaka makumi asanu, mtengo wake ukhale umene unakhazikitsidwa. ");
INSERT INTO nya_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Koma ngati apereka mundawo chaka chokondwerera zaka makumi asanu chitapita, wansembe adzatchula mtengo molingana ndi zaka zomwe zatsala kuti chifike chaka china chokondwerera zaka makumi asanu, ndipo mtengo wake udzakhala wotsikirapo. ");
INSERT INTO nya_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Ngati munthu amene wapereka munda afuna kuwuwombola, ayenera kuwonjezera pa mtengo wake wa mundawo, limodzi mwa magawo asanu a mtengowo. Ndipo mundawo udzakhalanso wake. ");
INSERT INTO nya_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Koma ngati sawuwombola mundawo, kapena ngati waugulitsa kwa munthu wina, mundawo sudzawomboledwanso. ");
INSERT INTO nya_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Mwini mundawo akawusiya mʼchaka chokondwerera zaka makumi asanu ndiye kuti mundawo udzakhala wopatulika monga woperekedwa kwa Yehova: udzakhala munda wa ansembe. ");
INSERT INTO nya_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘Ngati munthu apereka kwa Yehova munda umene anagula, umene si malo a makolo ake, ");
INSERT INTO nya_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","wansembe atchule mtengo wake kufikira pa chaka chokondwerera zaka makumi asanu, ndipo munthuyo apereke ndalama zokwanira mtengo wake pa tsikulo monga ndalama zopatulika kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Pa chaka chokondwerera zaka makumi asanu, mundawo udzabwezedwa kwa munthu amene anawugulitsayo, amene malowo anali ake. ");
INSERT INTO nya_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Potchula mtengo uliwonse wansembe awerengere molingana ndi mtengo wa sekeli wa ku Nyumba ya Mulungu: magera makumi awiri pa sekeli imodzi. ");
INSERT INTO nya_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘Koma pasapezeke munthu wopereka mwana woyamba kubadwa wa nyama, popeza mwana woyamba kubadwa ali kale wa Yehova, kaya ndi ngʼombe kapena nkhosa, zimenezi ndi za Yehova. ");
INSERT INTO nya_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Ngati ili nyama yodetsedwa, ayiwombole pa mtengo umene wansembe wawuyika, ndi kuwonjezeranso pa mtengo wake wa nyamayo, limodzi mwa magawo asanu amtengowo. Ngati sayiwombola, igulitsidwe pa mtengo umene wansembe awuyike. ");
INSERT INTO nya_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘Koma chinthu chilichonse choperekedwa kwa Yehova, kaya ndi munthu, nyama, kaya ndi malo a makolo, chimenechi chisagulitsidwe kapena kuwomboledwa. Choperekedwa kwa Yehova motere nʼchopatulika kwambiri. ");
INSERT INTO nya_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘Munthu amene waperekedwa kotheratu sangawomboledwe. Munthuyo ayenera kuphedwa. ");
INSERT INTO nya_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘Chakhumi chilichonse chochokera mʼdziko, kaya ndi tirigu wochokera mʼnthaka kapena chipatso cha mʼmitengo ndi za Yehova. Chimenecho ndi chopatulika kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Ngati munthu afuna kuwombola chakhumi chilichonse, awonjezere pamtengo wake chimodzi mwa zigawo zisanu za mtengowo. ");
INSERT INTO nya_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Chakhumi cha ngʼombe ndi nkhosa, kapena kuti nyama iliyonse ya khumi imene mʼbusa wayiwerenga idzakhala yopatulikira kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Palibe amene adzaloledwa kusankha nyama yomwe ili yabwino kapena kusinthitsa. Ngati asinthitsa, nyamayo pamodzi ndi inzakeyo zidzakhala zopatulika ndipo sangaziwombole.’ ” ");
INSERT INTO nya_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Amenewa ndi malamulo amene Yehova anamupatsa Mose pa Phiri la Sinai kuti awuze Aisraeli.");
INSERT INTO nya_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Yehova anayankhula ndi Mose mʼchipululu cha Sinai, mu tenti ya msonkhano, pa tsiku loyamba la mwezi wachiwiri, mʼchaka chachiwiri atatuluka mu Igupto, kuti, ");
INSERT INTO nya_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Werengani Aisraeli onse mʼmafuko awo ndi mʼmabanja awo, lemba dzina la munthu wamwamuna aliyense, mmodzimmodzi. ");
INSERT INTO nya_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Iwe ndi Aaroni mwawerenge mwa magulu awo mu Israeli, amuna onse a zaka makumi awiri zakubadwa ndi opitirirapo omwe angathe kugwira ntchito ya usilikali. ");
INSERT INTO nya_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Munthu mmodzi wochokera ku fuko lililonse yemwe ndi mtsogoleri wa banja lake, ndiye akuthandizeni pa ntchitoyi. ");
INSERT INTO nya_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Mayina a anthu amene akuthandizeniwo ndi awa: Elizuri mwana wa Sedeuri, kuchokera ku fuko la Rubeni, ");
INSERT INTO nya_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Selumieli mwana wa Zurisadai, kuchokera ku fuko la Simeoni, ");
INSERT INTO nya_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Naasoni mwana wa Aminadabu, kuchokera ku fuko la Yuda, ");
INSERT INTO nya_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Netanieli mwana wa Zuwara, kuchokera ku fuko la Isakara, ");
INSERT INTO nya_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Eliabu mwana wa Heloni, kuchokera ku fuko la Zebuloni, ");
INSERT INTO nya_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Mwa ana a Yosefe: kuchokera ku fuko la Efereimu, Elisama mwana wa Amihudi; kuchokera ku fuko la Manase, Gamalieli mwana wa Pedazuri; ");
INSERT INTO nya_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Abidani mwana wa Gideoni, kuchokera ku fuko la Benjamini, ");
INSERT INTO nya_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Ahiyezeri mwana wa Amisadai, kuchokera ku fuko la Dani, ");
INSERT INTO nya_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Pagieli mwana wa Okirani, kuchokera ku fuko la Aseri, ");
INSERT INTO nya_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Eliyasafu mwana wa Deuweli, kuchokera ku fuko la Gadi, ");
INSERT INTO nya_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Ahira mwana wa Enani, kuchokera ku fuko la Nafutali.” ");
INSERT INTO nya_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Amenewa ndi anthu amene anasankhidwa kuchokera mʼmagulu mwawo, eni mbumba a mafuko a makolo awo. Iwowa anali atsogoleri a mafuko a Israeli. ");
INSERT INTO nya_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Mose ndi Aaroni anatenga anthu amene mayina awo anaperekedwa, ");
INSERT INTO nya_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ndipo pa tsiku loyamba la mwezi wachiwiri, anasonkhanitsa anthu onse pamodzi. Anthuwo anafotokoza za makolo awo mwa mafuko awo ndi mabanja awo. Ndipo mayina a amuna onse amene anali ndi zaka makumi awiri kapena kupitirirapo analembedwa, mmodzimmodzi ");
INSERT INTO nya_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","monga momwe Yehova analamulira Mose. Motero iyeyo anawawerenga mʼchipululu cha Sinai: ");
INSERT INTO nya_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Kuchokera mwa ana a Rubeni, mwana wamwamuna woyamba wa Israeli: Amuna onse a zaka makumi awiri kapena kupitirirapo, omwe akanatha kugwira ntchito ya usilikali, anawalemba mayina awo, mmodzimmodzi monga mwa mbiri ya mafuko awo ndi mabanja awo. ");
INSERT INTO nya_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Chiwerengero cha anthu ochokera mʼfuko la Rubeni chinali 46,500. ");
INSERT INTO nya_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Kuchokera mwa zidzukulu za Simeoni: Amuna onse a zaka makumi awiri kapena kupitirirapo, omwe akanatha kugwira ntchito ya usilikali anawalemba mayina awo, mmodzimmodzi monga mwa mbiri ya mafuko awo ndi mabanja awo. ");
INSERT INTO nya_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Chiwerengero cha anthu ochokera mʼfuko la Simeoni chinali 59,300. ");
INSERT INTO nya_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Kuchokera mwa zidzukulu za Gadi: Amuna onse a zaka makumi awiri kapena kupitirirapo, omwe akanatha kugwira ntchito ya usilikali anawalemba mayina awo monga mwa mbiri ya mafuko awo ndi mabanja awo. ");
INSERT INTO nya_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Chiwerengero cha anthu ochokera mʼfuko la Gadi chinali 45, 650. ");
INSERT INTO nya_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Kuchokera mwa zidzukulu za Yuda: Amuna onse a zaka makumi awiri kapena kupitirirapo, omwe akanatha kugwira ntchito ya usilikali anawalemba mayina awo monga mwa mbiri ya mafuko awo ndi mabanja awo. ");
INSERT INTO nya_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Chiwerengero cha anthu ochokera mʼfuko la Yuda chinali 74, 600. ");
INSERT INTO nya_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Kuchokera mwa zidzukulu za Isakara: Amuna onse a zaka makumi awiri kapena kupitirirapo, omwe akanatha kugwira ntchito ya usilikali anawalemba mayina awo monga mwa mbiri ya mafuko awo ndi mabanja awo. ");
INSERT INTO nya_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Chiwerengero cha anthu ochokera mʼfuko la Isakara chinali 54,400. ");
INSERT INTO nya_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Kuchokera mwa zidzukulu za Zebuloni: Amuna onse a zaka makumi awiri kapena kupitirirapo, omwe akanatha kugwira ntchito ya usilikali anawalemba mayina awo monga mwa mbiri ya mafuko awo ndi mabanja awo. ");
INSERT INTO nya_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Chiwerengero cha anthu ochokera mʼfuko la Zebuloni chinali 57,400. ");
INSERT INTO nya_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Kuchokera mwa ana aamuna a Yosefe: Kuchokera mwa zidzukulu za Efereimu: Amuna onse a zaka makumi awiri kapena kupitirirapo, omwe akanatha kugwira ntchito ya usilikali anawalemba mayina awo monga mwa mbiri ya mafuko awo ndi mabanja awo. ");
INSERT INTO nya_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Chiwerengero cha anthu ochokera mʼfuko la Efereimu chinali 40,500. ");
INSERT INTO nya_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Kuchokera mwa zidzukulu za Manase: Amuna onse a zaka makumi awiri kapena kupitirirapo, omwe akanatha kugwira ntchito ya usilikali anawalemba mayina awo monga mwa mbiri ya mafuko awo ndi mabanja awo. ");
INSERT INTO nya_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Chiwerengero cha anthu ochokera mʼfuko la Manase chinali 32,200. ");
INSERT INTO nya_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Kuchokera mwa zidzukulu za Benjamini: Amuna onse a zaka makumi awiri kapena kupitirirapo, omwe akanatha kugwira ntchito ya usilikali anawalemba mayina awo monga mwa mbiri ya mafuko awo ndi mabanja awo. ");
INSERT INTO nya_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Chiwerengero cha anthu ochokera mʼfuko la Benjamini chinali 35,400. ");
INSERT INTO nya_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Kuchokera mwa zidzukulu za Dani: Amuna onse a zaka makumi awiri kapena kupitirirapo, omwe akanatha kugwira ntchito ya usilikali anawalemba mayina awo monga mwa mbiri ya mafuko awo ndi mabanja awo. ");
INSERT INTO nya_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Chiwerengero cha anthu ochokera mʼfuko la Dani chinali 62,700. ");
INSERT INTO nya_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Kuchokera mwa zidzukulu za Aseri: Amuna onse a zaka makumi awiri kapena kupitirirapo, omwe akanatha kugwira ntchito ya usilikali anawalemba mayina awo monga mwa mbiri ya mafuko awo ndi mabanja awo. ");
INSERT INTO nya_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Chiwerengero cha anthu ochokera mʼfuko la Aseri chinali 41,500. ");
INSERT INTO nya_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Kuchokera mwa zidzukulu za Nafutali: Aamuna onse a zaka makumi awiri kapena kupitirirapo, omwe akanatha kugwira ntchito ya usilikali anawalemba mayina awo monga mwa mbiri ya mafuko awo ndi mabanja awo. ");
INSERT INTO nya_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Chiwerengero cha anthu ochokera mʼfuko la Nafutali chinali 53,400. ");
INSERT INTO nya_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Amenewa ndiwo anthu amene Mose ndi Aaroni anawawerenga mothandizidwa ndi atsogoleri khumi ndi awiri a Israeli, aliyense kuyimira fuko lake. ");
INSERT INTO nya_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Aisraeli onse a zaka makumi awiri kapena kupitirirapo, omwe akanatha kugwira ntchito ya usilikali mʼgulu lankhondo la Israeli anawawerenga monga mwa mabanja awo. ");
INSERT INTO nya_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Chiwerengero cha anthu onse pamodzi chinali 603,550. ");
INSERT INTO nya_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Koma mabanja a fuko la Levi okha sanawawerenge pamodzi ndi ena. ");
INSERT INTO nya_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Pakuti Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Usawerenge fuko la Levi kapena kuliphatikiza mʼkawundula wa Aisraeli. ");
INSERT INTO nya_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Koma uyike Aleviwo kuti aziyangʼanira tenti yanga yopatulika, zipangizo zake ndi zonse zili mʼmenemo. Azinyamula tentiyo pamodzi ndi zipangizo zake zonse; azisamalira ndi kumanga misasa mozungulira tentiyo. ");
INSERT INTO nya_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Pamene akusamutsa tentiyo, Alevi ndiwo aziyitsitsa, akafuna kuyimanganso, Alevi ndiwo aziyimiritsa. Wina aliyense amene adzayandikire tentiyo adzaphedwa. ");
INSERT INTO nya_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Aisraeli azimanga matenti awo mʼmagulumagulu, munthu aliyense ku gulu lake pansi pa mbendera yake. ");
INSERT INTO nya_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Alevi nawonso, azimanga matenti awo mozungulira tenti yopatulika kuti chilango chisagwere Aisraeli onse. Ndipo Alevi aziyangʼanira ndi kusamalira tenti yopatulikayo.” ");
INSERT INTO nya_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Choncho Aisraeli anachita monga Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Yehova anati kwa Mose ndi Aaroni: ");
INSERT INTO nya_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Aisraeli azimanga misasa yawo mozungulira tenti ya msonkhano motalikira pangʼono. Munthu aliyense amange pamene pali mbendera ya fuko lake.” ");
INSERT INTO nya_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Kummawa, kotulukira dzuwa, magulu a msasa wa Yuda amange pamene pali mbendera yawo. Mtsogoleri wa Ayudawo ndi Naasoni mwana wa Aminadabu. ");
INSERT INTO nya_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Chiwerengero cha gulu lake lankhondo ndi 74,600. ");
INSERT INTO nya_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Fuko la Isakara lidzamanga pafupi ndi Yuda. Mtsogoleri wa gulu la Isakara ndi Netanieli mwana wa Zuwara. ");
INSERT INTO nya_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Chiwerengero cha gulu lake lankhondo ndi 54,400. ");
INSERT INTO nya_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Lotsatira lidzakhala fuko la Zebuloni. Mtsogoleri wa gulu la Zebuloni ndi Eliabu mwana wa Heloni. ");
INSERT INTO nya_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Chiwerengero cha gulu lake lankhondo ndi 57,400. ");
INSERT INTO nya_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Anthu onse aamuna mʼmisasa ya Yuda, chiwerengero chawo ndi 186,400 monga mwa magulu awo. Iwowo ndiwo aziyamba kusamuka. ");
INSERT INTO nya_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Kummwera kudzakhala magulu a msasa wa Rubeni pamene pali mbendera yawo. Mtsogoleri wa gulu la Rubeni ndi Elizuri mwana wa Sedeuri. ");
INSERT INTO nya_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Chiwerengero cha gulu lake lankhondo ndi 46,500. ");
INSERT INTO nya_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Fuko la Simeoni lidzamanga pafupi ndi Rubeni. Mtsogoleri wa gulu la Simeoni ndi Selumieli mwana wa Zurisadai. ");
INSERT INTO nya_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Chiwerengero cha gulu lake lankhondo ndi 59,300. ");
INSERT INTO nya_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Lotsatira lidzakhala fuko la Gadi. Mtsogoleri wa gulu la Gadi ndi Eliyasafu mwana wa Deuweli. ");
INSERT INTO nya_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Chiwerengero cha gulu lake lankhondo ndi 45,650. ");
INSERT INTO nya_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Anthu onse aamuna mu msasa wa Rubeni, chiwerengero chawo monga mwa magulu awo, ndi 151,450. Iwowo azikhala achiwiri posamuka. ");
INSERT INTO nya_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Tsono tenti ya msonkhano ndi msasa wa Alevi zidzakhala pakati pa misasayo. Iwo adzasamuka monga momwe anamangira misasa yawo, aliyense pa malo ake pamene pali mbendera yake. ");
INSERT INTO nya_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Kumadzulo kudzakhala magulu a msasa wa Efereimu pamene pali mbendera yawo. Mtsogoleri wa Aefereimuwo ndi Elisama mwana wa Amihudi. ");
INSERT INTO nya_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Chiwerengero cha gulu lake lankhondo ndi 40,500. ");
INSERT INTO nya_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Fuko la Manase lidzakhala pafupi ndi Efereimu. Mtsogoleri wa Amanase ndi Gamalieli mwana wa Pedazuri. ");
INSERT INTO nya_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Chiwerengero cha gulu lake lankhondo ndi 32,200. ");
INSERT INTO nya_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Lotsatira lidzakhala fuko la Benjamini. Mtsogoleri wa Abenjamini ndi Abidani mwana wa Gideoni. ");
INSERT INTO nya_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Chiwerengero cha gulu lake lankhondo ndi 35,400. ");
INSERT INTO nya_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Anthu onse aamuna mu msasa wa Efereimu, chiwerengero chawo ndi 108,100 monga mwa magulu awo. Iwowo azikhala achitatu posamuka. ");
INSERT INTO nya_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Kumpoto kudzakhala msasa wa magulu a Dani pamene pali mbendera yawo. Mtsogoleri wa Adani ndi Ahiyezeri mwana wa Amisadai. ");
INSERT INTO nya_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Chiwerengero cha gulu lake lankhondo ndi 62,700. ");
INSERT INTO nya_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Fuko la Aseri lidzamanga pafupi ndi iwowo. Mtsogoleri wa Aaseri ndi Pagieli mwana wa Okirani. ");
INSERT INTO nya_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Chiwerengero cha gulu lake lankhondo ndi 41,500. ");
INSERT INTO nya_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Lotsatira lidzakhala fuko la Nafutali. Mtsogoleri wa Anafutali ndi Ahira mwana wa Enani. ");
INSERT INTO nya_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Chiwerengero cha gulu lake lankhondo ndi 53,400. ");
INSERT INTO nya_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Anthu onse aamuna mu msasa wa Dani chiwerengero chawo ndi 157,600. Iwo azidzanyamuka pomaliza, ndi mbendera zawo. ");
INSERT INTO nya_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Amenewa ndi Aisraeli monga mwa mabanja a makolo awo. Chiwerengero cha Aisraeli onse mʼmisasa chinali 603,550, mwa magulu awo. ");
INSERT INTO nya_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Koma Alevi sanawawerenge pamodzi ndi Aisraeli enawo monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Choncho Aisraeli anachita zonse zomwe Yehova analamulira Mose. Umo ndi momwe amamangira misasa yawo pamene panali mbendera zawo, ndipo ankasamuka monga mwa mafuko a makolo awo. ");
INSERT INTO nya_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Iyi ndi mbiri ya banja la Aaroni ndi Mose pa nthawi yomwe Yehova anayankhula ndi Mose pa phiri la Sinai. ");
INSERT INTO nya_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Mayina a ana aamuna a Aaroni anali Nadabu, woyamba kubadwa, Abihu, Eliezara ndi Itamara. ");
INSERT INTO nya_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Amenewa ndi mayina a ana aamuna a Aaroni, ansembe odzozedwa omwe anapatulidwa kuti azitumikira ngati ansembe. ");
INSERT INTO nya_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Koma Nadabu ndi Abihu, anagwa nafa pamaso pa Yehova pamene ankapereka nsembe ndi moto wachilendo pamaso pa Yehova mʼchipululu cha Sinai. Iwowo analibe ana aamuna. Choncho Eliezara ndi Itamara ndiwo amene ankatumikira ngati ansembe nthawi imene Aaroni abambo awo anali moyo. ");
INSERT INTO nya_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Yehova anati kwa Mose, ");
INSERT INTO nya_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Bweretsa fuko la Levi ndipo ulipereke kwa Aaroni wansembe kuti lizimutumikira. ");
INSERT INTO nya_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Azigwira ntchito yothandiza iyeyo ndi gulu lonse ku tenti ya msonkhano pogwira ntchito ya ku Chihema. ");
INSERT INTO nya_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Azisamalira zipangizo zonse za mu tenti ya msonkhano, ndipo azigwirira ntchito Aisraeli potumikira mu tenti. ");
INSERT INTO nya_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Pereka Alevi kwa Aaroni ndi kwa ana ake aamuna. Amenewa ndiwo Aisraeli amene aperekedwa kwa iye kwathunthu. ");
INSERT INTO nya_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Usankhe Aaroni ndi ana ake aamuna kuti azitumikira pa ntchito ya unsembe. Koma wina aliyense woyandikira malo opatulika aphedwe.” ");
INSERT INTO nya_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Yehova anawuzanso Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Pakati pa Aisraeli onse ndatenga Alevi kulowa mʼmalo mwa mwana wamwamuna aliyense woyamba kubadwa kwa amayi a Chiisraeli. Alevi ndi anga, ");
INSERT INTO nya_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","pakuti ana onse oyamba kubadwa ndi anga. Nditakantha ana onse oyamba kubadwa mu Igupto, ndinadzipatulira ndekha mwana aliyense woyamba kubadwa mu Israeli, wa munthu ndi nyama. Azikhala anga. Ine ndine Yehova.” ");
INSERT INTO nya_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Yehova anawuza Mose mʼchipululu cha Sinai kuti, ");
INSERT INTO nya_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Werenga Alevi monga mwa mabanja awo ndi mafuko awo. Werenga mwamuna aliyense kuyambira wa mwezi umodzi kapena kupitirirapo.” ");
INSERT INTO nya_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Choncho Mose anawawerenga potsatira zomwe Yehova anamulamulira. ");
INSERT INTO nya_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Mayina a ana aamuna a Levi ndi awa: Geresoni, Kohati ndi Merari. ");
INSERT INTO nya_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Mayina a ana a Geresoni potsata mabanja awo ndi awa: Libini ndi Simei. ");
INSERT INTO nya_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Ana a Kohati potsata mabanja awo ndi awa: Amramu, Izihari, Hebroni ndi Uzieli. ");
INSERT INTO nya_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Ana a Merari potsata mabanja awo ndi awa: Mali ndi Musi. Amenewa ndiwo anali mabanja a Alevi monga mwa makolo awo. ");
INSERT INTO nya_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Kwa Geresoni kunali banja la Alibini, banja la Asimei. Amenewa ndiwo anali mabanja a Ageresoni. ");
INSERT INTO nya_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Chiwerengero cha amuna onse amene anawawerenga a mwezi umodzi kapena kupitirirapo chinali 7,500. ");
INSERT INTO nya_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Mabanja a Ageresoni azimanga misasa yawo kumadzulo, kumbuyo kwa Chihema. ");
INSERT INTO nya_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Mtsogoleri wa mabanja a Ageresoni anali Eliyasafu mwana wa Laeli. ");
INSERT INTO nya_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Ntchito imene Ageresoni anapatsidwa ku tenti ya msonkhano inali yosamalira Chihema ndi tenti, pamodzi ndi zophimbira zake, katani ya pa khomo la ku tenti ya msonkhano, ");
INSERT INTO nya_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ndi makatani wotchinga bwalo, katani ya pa chipata cholowera ku bwalo lozungulira Chihema ndi guwa lansembe, zingwe ndi zonse zokhudzana ndi ntchito yawo. ");
INSERT INTO nya_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kwa Kohati kunali mabanja a Amramu, Aizihara, Ahebroni ndi Auzieli. Awa ndiye anali mabanja a Akohati. ");
INSERT INTO nya_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Chiwerengero cha amuna onse a mwezi umodzi kapena kupitirirapo chinali 8,600. Akohati ankagwira ntchito yosamalira malo wopatulika. ");
INSERT INTO nya_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Mabanja a ana a Kohati ankamanga misasa yawo kummwera kwa Chihema. ");
INSERT INTO nya_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Mtsogoleri wa magulu a mabanja a Kohati anali Elizafani mwana wa Uzieli. ");
INSERT INTO nya_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Iwo ankagwira ntchito yosamalira Bokosi la Chipangano, tebulo, choyikapo nyale, maguwa, zipangizo za kumalo wopatulika zimene ansembe ankagwiritsa ntchito, katani, ndi zonse zomwe ankagwiritsa ntchito. ");
INSERT INTO nya_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Mtsogoleri wamkulu wa Alevi anali Eliezara mwana wa Aaroni wansembe. Iye anasankhidwa kukhala woyangʼanira omwe ankasamalira malo wopatulika. ");
INSERT INTO nya_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Kwa Merari kunali banja la Mali ndi banja la Musi. Amenewa ndiye anali mabanja a Amerari. ");
INSERT INTO nya_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Chiwerengero cha amuna onse kuyambira a mwezi umodzi kapena kupitirirapo chinali 6,200. ");
INSERT INTO nya_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Mtsogoleri wa magulu a mabanja a Amerari anali Zuriyeli mwana wa Abihaili. Iwo ankamanga misasa yawo kumpoto kwa Chihema. ");
INSERT INTO nya_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Amerari anapatsidwa ntchito yosamalira mitengo ya chihema, nsichi zake, mizati yake, matsinde ake, ndi zida zake zonse, ndi zonse zomwe ankagwiritsa ntchito, ");
INSERT INTO nya_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","pamodzi ndi mizati yozungulira bwalo ndi matsinde ake, zikhomo za chihema ndi zingwe zake. ");
INSERT INTO nya_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Mose ndi Aaroni ndi ana ake aamuna ankamanga misasa yawo kummawa kwa chihema, kuyangʼana kotulukira dzuwa, kutsogolo kwa tenti ya msonkhano. Anali ndi ntchito yosamalira malo wopatulika mʼmalo mwa Aisraeli. Aliyense woyandikira malo wopatulika ankayenera kuphedwa. ");
INSERT INTO nya_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Alevi onse amene Mose ndi Aaroni anawawerenga potsatira lamulo la Yehova monga mwa magulu a mabanja awo, amuna onse kuyambira a mwezi umodzi kapena kupitirirapo anali 22,000. ");
INSERT INTO nya_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Yehova anawuza Mose kuti, “Werenga ana onse aamuna oyamba kubadwa mu Israeli, omwe ali ndi mwezi umodzi kapena kupitirirapo ndipo ulembe mndandanda wa mayina awo. ");
INSERT INTO nya_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Unditengere Alevi onse mʼmalo mwa ana oyamba kubadwa onse a Aisraeli, ndiponso ziweto zazimuna za Alevi mʼmalo mwa ziweto zonse zazimuna zoyamba kubadwa za Aisraeli. Ine ndine Yehova.” ");
INSERT INTO nya_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Choncho Mose anawerenga ana aamuna onse oyamba kubadwa a Aisraeli monga momwe Yehova anamulamulira. ");
INSERT INTO nya_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Chiwerengero chonse cha ana aamuna oyamba kubadwa kuyambira a mwezi umodzi kapena kupitirirapo chinali 22, 273. ");
INSERT INTO nya_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Ndipo Yehova anawuzanso Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Tenga Alevi mʼmalo mwa ana aamuna oyamba kubadwa onse a Aisraeli, ndiponso zoweta zonse za Alevi mʼmalo mwa zoweta za Aisraeli. Alevi ndi anga. Ine ndine Yehova. ");
INSERT INTO nya_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Pofuna kuwombola ana aamuna 273 oyamba kubadwa a Aisraeli amene anaposa chiwerengero cha aamuna a fuko la Levi, ");
INSERT INTO nya_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","utenge masekeli asanu pa munthu aliyense. Masekeliwo akhale ofanana ndi masekeli a ku malo wopatulika, kumene sekeli imodzi imakwanira magera makumi awiri. ");
INSERT INTO nya_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Ndalama zimenezi uzipereke kwa Aaroni ndi ana ake aamuna kuti ukhale mtengo woombolera Aisraeli woonjezerawo.” ");
INSERT INTO nya_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Choncho Mose anatenga ndalama zowombolera zija kuchokera kwa Aisraeli amene chiwerengero chawo chinaposa chiwerengero cha omwe anawomboledwa ndi Alevi. ");
INSERT INTO nya_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Anatenga masekeli a siliva okwana 1,365 molingana ndi masekeli a ku malo opatulika, kuchokera kwa ana aamuna oyamba kubadwa a Aisraeli. ");
INSERT INTO nya_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Mose anapereka ndalama zowombolera zija kwa Aaroni ndi ana ake aamuna monga mwa mawu amene Yehova analamulira. ");
INSERT INTO nya_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Yehova anati kwa Mose ndi Aaroni: ");
INSERT INTO nya_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Werengani Akohati omwe ndi gawo limodzi la Alevi monga mwa mafuko awo ndi mabanja awo. ");
INSERT INTO nya_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Werengani amuna onse amene ali ndi zaka makumi atatu mpaka zaka makumi asanu amene amabwera kudzagwira ntchito mu tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Ntchito ya Akohati mu tenti ya msonkhano ndi iyi: kusamalira zinthu zopatulika kwambiri. ");
INSERT INTO nya_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Pamene anthu akusamuka pa msasa, Aaroni ndi ana ake aamuna azilowa mu tenti ndi kuchotsa chinsalu chotchingira ndi kuphimba nacho bokosi la umboni. ");
INSERT INTO nya_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Ndipo azikuta bokosilo ndi zikopa za akatumbu ndi kuyala pamwamba pake nsalu ya mtundu wa thambo ndi kuyika mitengo yonyamulira mʼmalo mwake. ");
INSERT INTO nya_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Pa tebulo pamene pamakhala buledi wa ansembe aziyalapo nsalu ya mtundu wa thambo, ndipo aziyikapo mbale, mabeseni, zipande ndi mitsuko yoperekera nsembe yachakumwa. Aziyikaponso buledi wokhala pamenepo nthawi zonse. ");
INSERT INTO nya_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Tsono pamwamba pa izi aziyalapo nsalu yofiira, ndi kuzikuta mʼzikopa za akatumbu ndi kuyika mitengo yonyamulira mʼmalo mwake. ");
INSERT INTO nya_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Azitenga nsalu ya mtundu wa thambo ndi kukutira choyikapo nyale, pamodzi ndi nyale zake, zopanira zake, zotengera zake ndi mitsuko yonse yosungiramo mafuta. ");
INSERT INTO nya_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Kenaka achikulunge pamodzi ndi zipangizo zake zonse mʼzikopa za akatumbu ndi kuchiyika pa chonyamulira chake. ");
INSERT INTO nya_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Pamwamba pa guwa la golide aziyalapo nsalu ya mtundu wa thambo ndi kukutira ndi zikopa za akatumbu ndi kuyika mʼmalo mwake mitengo yonyamulira. ");
INSERT INTO nya_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Azitenga zipangizo zonse zogwiritsira ntchito ku malo wopatulika, azizikulunga mʼnsalu ya mtundu wa thambo, azizikuta ndi zikopa za akatumbu ndi kuziyika pa zonyamulira zake. ");
INSERT INTO nya_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Azichotsa phulusa la pa guwa lansembe lamkuwa ndi kuyalapo nsalu yapepo pamwamba pake. ");
INSERT INTO nya_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Kenaka aziyikapo zipangizo zonse zogwiritsira ntchito potumikira pa guwa, kuphatikizapo miphika yowotchera nyama, mafoloko otengera nyama, zowolera phulusa ndi mbale zowazira magazi pa guwa lansembe ndipo pamwamba pake aziyalapo zikopa za akatumbu ndi kuziyika mʼzonyamulira zake. ");
INSERT INTO nya_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Aaroni ndi ana ake aamuna akamaliza kukutira ziwiya za ku malo wopatulika ndi zipangizo zopatulika zonse, ndipo akakonzeka kusamuka pamalopo, Akohati abwere kudzazinyamula koma asagwire zinthu zopatulikazo. Akatero adzafa. Izi ndizo zinthu zimene Akohati ayenera kunyamula mu tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Eliezara mwana wa Aaroni, wansembe, aziyangʼanira mafuta a nyale, ndi lubani wa nsembe zofukiza, nsembe yaufa yoperekedwa nthawi zonse ndi mafuta odzozera. Aziyangʼaniranso chihema ndi zonse zili mʼmenemo, kuphatikizapo zida ndi ziwiya zonse zopatulika.” ");
INSERT INTO nya_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Yehova anawuzanso Mose ndi Aaroni kuti, ");
INSERT INTO nya_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Onetsetsani kuti mabanja a fuko la Kohati asachotsedwe kwa Alevi. ");
INSERT INTO nya_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Koma muziwachitira izi kuti asafe, akhalebe ndi moyo pamene ayandikira zinthu za ku malo wopatulika kwambiri: Aaroni ndi ana ake aamuna azipita ku malo wopatulika ndi kumamupatsa munthu aliyense ntchito yake ndi zimene ayenera kunyamula. ");
INSERT INTO nya_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Koma Akohati asalowe kukaona zinthu zopatulika, ngakhale kanthawi pangʼono, chifukwa akatero adzafa.” ");
INSERT INTO nya_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Werenganso Ageresoni monga mwa mabanja ndi mafuko awo. ");
INSERT INTO nya_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Uwerenge amuna onse a zaka makumi atatu mpaka a zaka makumi asanu zakubadwa amene amabwera kudzatumikira ku tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Ntchito ya mafuko a Ageresoni pamene akugwira ntchito ndi kunyamula katundu ndi iyi: ");
INSERT INTO nya_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Azinyamula makatani a ku chihema, tenti ya msonkhano, zokutira zake ndi zokutira kunja za zikopa za akatumbu, makatani a pa khomo la ku tenti ya msonkhano, ");
INSERT INTO nya_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","makatani wotchingira bwalo lozungulira chihema ndi guwa, katani ya pa khomo, zingwe ndi zida zonse zimene zimagwiritsidwa ntchito mʼchihema. Ageresoni azichita zonse zofunika kuchitika ndi zinthu zimenezi. ");
INSERT INTO nya_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Ntchito yawo yonse, kaya kunyamula kapena kugwira ntchito zina, achite Ageresoni motsogozedwa ndi Aaroni ndi ana ake aamuna. Uwagawire ntchito zonse zimene akuyenera kugwira. ");
INSERT INTO nya_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Iyi ndiye ntchito ya fuko la Ageresoni ku tenti ya msonkhano. Ntchito zawo zichitike motsogozedwa ndi Itamara mwana wa wansembe Aaroni. ");
INSERT INTO nya_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Werenga Amerari monga mwa mafuko awo ndi mabanja awo. ");
INSERT INTO nya_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Werenga amuna onse a zaka makumi atatu mpaka zaka makumi asanu zakubadwa amene akatumikire mu tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Ntchito yawo pamene azikatumikira mu tenti ya msonkhano ndi iyi: kunyamula matabwa a chihema, mitanda, mizati ndi matsinde, ");
INSERT INTO nya_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ndiponso mizati yozungulira bwalo ndi matsinde ake, zikhomo za chihema, zingwe ndi zipangizo zake zonse ndiponso zonse zokhudzana ndi ntchito yake. Uwuze munthu aliyense chomwe ayenera kuchita. ");
INSERT INTO nya_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Iyi ndiyo ntchito ya mafuko a Amerari pamene akugwira ntchito ku tenti ya msonkhano motsogozedwa ndi Itamara mwana wa wansembe Aaroni.” ");
INSERT INTO nya_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Mose, Aaroni ndi atsogoleri a magulu a anthu anawerenga Akohati monga mwa mafuko ndi mabanja awo. ");
INSERT INTO nya_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Aamuna onse a zaka makumi atatu mpaka makumi asanu amene anabwera kudzagwira ntchito ku tenti ya msonkhano, ");
INSERT INTO nya_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","atawawerenga mwa mafuko awo, anali 2,750. ");
INSERT INTO nya_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Ichi chinali chiwerengero cha mafuko a Akohati onse omwe ankatumikira mu tenti ya msonkhano. Mose ndi Aaroni anawawerenga monga mwa lamulo la Yehova. ");
INSERT INTO nya_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Ageresoni anawerengedwanso monga mwa mafuko ndi mabanja awo. ");
INSERT INTO nya_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Amuna onse a zaka makumi atatu mpaka makumi asanu amene anabwera kudzagwira ntchito ku tenti ya msonkhano, ");
INSERT INTO nya_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","atawawerenga mwa mafuko ndi mabanja awo, anali 2,630. ");
INSERT INTO nya_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Ichi chinali chiwerengero cha Ageresoni mwa mabanja awo amene ankatumikira ku tenti ya msonkhano. Mose ndi Aaroni anawawerenga monga mwa lamulo la Yehova. ");
INSERT INTO nya_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Amerari anawawerenga monga mwa mafuko ndi mabanja awo. ");
INSERT INTO nya_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Amuna onse kuyambira zaka makumi atatu mpaka makumi asanu amene anabwera kudzatumikira ntchito mu tenti ya msonkhano, ");
INSERT INTO nya_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","atawawerenga mwa mafuko ndi mabanja awo, anali 3,200. ");
INSERT INTO nya_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Ichi ndicho chinali chiwerengero cha mabanja a Amerari. Mose ndi Aaroni anawawerenga monga momwe Yehova anawalamulira kudzera mwa Mose. ");
INSERT INTO nya_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Kotero Mose, Aaroni ndi atsogoleri a Israeli anawerenga Alevi onse monga mwa mafuko ndi mabanja awo. ");
INSERT INTO nya_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Aamuna onse a zaka makumi atatu mpaka zaka makumi asanu omwe anabwera kudzagwira ntchito yonyamula zinthu ku tenti ya msonkhano ");
INSERT INTO nya_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","analipo 8,580. ");
INSERT INTO nya_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Aliyense anamupatsa ntchito ndi kumuwuza choti anyamule monga mwa lamulo la Yehova kudzera mwa Mose. Anawawerenga chomwechi potsata zimene Yehova analamula Mose. ");
INSERT INTO nya_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Lamula Aisraeli kuti achotse mu msasa aliyense amene ali ndi matenda opatsirana a pa khungu kapena matenda otuluka madzi mʼthupi a mtundu uliwonse, kapena aliyense wodetsedwa chifukwa cha munthu wakufa. ");
INSERT INTO nya_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Muchotse amuna komanso amayi ndipo muwatulutsire kunja kwa msasa kuti asadetse msasa wawo kumene Ine ndimakhala pakati pawo.” ");
INSERT INTO nya_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Aisraeli anachitadi zimenezi. Anawatulutsira kunja kwa msasa monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Yehova anati kwa Mose, ");
INSERT INTO nya_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Uza Aisraeli kuti, ‘Pamene mwamuna kapena mayi walakwira mnzake mwa njira iliyonse, ndiye kuti ndi wosakhulupirika pamaso pa Yehova. Munthuyo ndi wochimwa ndithu ndipo ");
INSERT INTO nya_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ayenera kuwulula tchimo limene anachitalo. Ayenera kubweza zonse zimene anawononga, ndipo awonjezerepo chimodzi mwa magawo asanu ndi kuzipereka kwa munthu amene anamulakwirayo. ");
INSERT INTO nya_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ngati wolakwiridwayo alibe mʼbale komwe kungapite zinthu zobwezedwazo, zinthuzo zikhale za Yehova ndipo azipereke kwa wansembe, pamodzi ndi nkhosa yayimuna ya nsembe yopepesera tchimo lake. ");
INSERT INTO nya_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Zopereka zonse zopatulika zomwe Aisraeli abwera nazo kwa wansembe zikhale za wansembeyo. ");
INSERT INTO nya_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Mphatso zilizonse zopatulika ndi za munthuyo, koma zomwe wapereka kwa wansembe ndi za wansembeyo.’ ” ");
INSERT INTO nya_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Kenaka Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Yankhula ndi Aisraeli ndipo uwawuze kuti, ‘Ngati mkazi wa munthu wina ayenda njira yosayenera nakhala wosakhulupirika kwa mwamuna wake, ");
INSERT INTO nya_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","nakagonana ndi mwamuna wina koma mwamuna wake wosadziwa, ndipo palibe wina aliyense wadziwa za kudzidetsa kwake (pakuti palibe mboni yomuneneza chifukwa sanagwidwe akuchita), ");
INSERT INTO nya_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","mwamuna wake ndi kuyamba kuchita nsanje ndi kukayikira mkazi wakeyo kuti ndi wodetsedwa, komanso ngati amuchitira nsanje ndi kumukayikira ngakhale asanadzidetse, ");
INSERT INTO nya_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","apite naye mkaziyo kwa wansembe. Ndipo popita atengenso gawo lakhumi la chopereka chaufa wa barele wokwana kilogalamu imodzi mʼmalo mwa mkaziyo. Asathire mafuta pa nsembeyo kapena lubani, chifukwa ndi nsembe ya chopereka ya chakudya yopereka chifukwa cha nsanje, nsembe yozindikiritsa tchimo.’ ” ");
INSERT INTO nya_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘Wansembe abwere naye mkaziyo ndi kumuyimitsa pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Ndipo wansembeyo atenge madzi oyera mʼmbiya ya dothi ndi kuyika mʼmadzimo fumbi lapansi la mʼTenti ya Msonkhano. ");
INSERT INTO nya_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Wansembe atayimika mkaziyo pamaso pa Yehova, amumasule tsitsi lake, ndipo ayike mʼmanja mwake nsembe yozindikiritsa tchimo, nsembe yachakudya ya nsanje, wansembeyo atanyamula madzi owawa omwe amabweretsa temberero.’ ");
INSERT INTO nya_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Kenaka wansembeyo alumbiritse mkaziyo ndi kuti, ‘Ngati mwamuna wina aliyense sanagonane ndi iwe ndipo sunayende njira yoyipa ndi kukhala wodetsedwa pomwe uli pa ukwati ndi mwamuna wako, madzi owawa awa omwe amabweretsa temberero asakupweteke. ");
INSERT INTO nya_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Koma ngati wayenda njira yoyipa uli pa ukwati ndi mwamuna wako ndi kudzidetsa pogonana ndi mwamuna amene si mwamuna wako,’ ");
INSERT INTO nya_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","pamenepo wansembe alumbiritse mkaziyo ndi mawu a matemberero ndi kumuwuza kuti, ‘Yehova achititse anthu ako kukutemberera ndi kukunyoza pamene awononga ntchafu yako ndi kutupitsa mimba yako. ");
INSERT INTO nya_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Madzi awa obweretsa temberero alowe mʼthupi mwako ndi kutupitsa mimba yako ndi kuwononga ntchafu yako.’ ” “Pamenepo mkaziyo anene kuti, ‘Ameni, ameni.’ ” ");
INSERT INTO nya_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘Wansembe alembe matemberero amenewa mʼbuku ndi kuwanyika mʼmadzi owawa aja. ");
INSERT INTO nya_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Amwetse mkaziyo madzi owawawo omwe amabweretsa temberero, ndipo madzi amenewo adzalowa mʼmimba mwake ndi kuyambitsa ululu woopsa. ");
INSERT INTO nya_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Wansembe achotse mʼmanja mwa mkaziyo nsembe yachakudya ya nsanje ija, nayiweyula pamaso pa Yehova ndi kuyipereka pa guwa lansembe. ");
INSERT INTO nya_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Tsono wansembeyo atapeko ufa dzanja limodzi kuti ukhale wachikumbutso ndi kuwutentha pa guwa lansembe. Atatha izi, amwetse mkaziyo madzi aja. ");
INSERT INTO nya_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ndipo ngati mkaziyo anadzidetsadi ndi kukhala wosakhulupirika kwa mwamuna wake, pamene amwa madzi obweretsa matemberero aja, nalowa mʼmimba mwake, adzamva ululu woopsa. Mimba yake idzatupa ndi ntchafu yake idzawonongeka ndipo adzakhala wotembereredwa pakati pa anthu ake. ");
INSERT INTO nya_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Koma ngati mkaziyo sanadzidetse ndi kuti alibe tchimo, adzakhala wopanda mlandu ndipo adzabereka ana. ");
INSERT INTO nya_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘Limeneli ndiye lamulo la nsanje pamene mkazi wayenda njira yoyipa ndi kudzidetsa ali pa ukwati ndi mwamuna wake, ");
INSERT INTO nya_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","kapena pamene maganizo a nsanje abwera kwa mwamuna wake chifukwa chokayikira mkazi wakeyo. Wansembe azitenga mkazi wotere ndi kumuyimiritsa pamaso pa Yehova ndipo agwiritse ntchito lamulo lonseli kwa mkaziyo. ");
INSERT INTO nya_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Mwamunayo adzakhala wopanda tchimo lililonse, koma mkaziyo adzasenza zotsatira za tchimo lake.’ ” ");
INSERT INTO nya_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Yankhula ndi Aisraeli ndipo uwawuze kuti, ‘Ngati mwamuna kapena mkazi afuna kuchita lonjezo lapadera, lonjezo lodzipatula yekha kwa Yehova ngati Mnaziri, ");
INSERT INTO nya_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","sayenera kumwa vinyo kapena zakumwa zosasa ndipo asamamwe chakumwa chilichonse cha mphesa. Asamamwe madzi a mphesa kapena kudya mphesa zaziwisi kapena zowuma. ");
INSERT INTO nya_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Pa nthawi yonse imene ali Mnaziri, asamadye chilichonse chopangidwa kuchokera ku mphesa ngakhale mbewu zake kapena makungu ake.’ ");
INSERT INTO nya_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘Pa nthawi yonse ya lonjezo lodzipatula yekhalo, asamete kumutu kwake ndi lumo. Akhale wopatulika mpaka nthawi yake yonse ya kudzipatula yekha kwa Yehova itatha. Alileke tsitsi la pamutu pake kuti likule.’ ");
INSERT INTO nya_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Pa nthawi yonse imene munthuyo wadzipatula yekha kwa Yehova asayandikire mtembo. ");
INSERT INTO nya_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Ngakhale abambo ake kapena amayi ake kapena mchimwene wake kaya mchemwali wake atamwalira, asadzidetse pokhudza mitembo yawo chifukwa kulumbira kwake kwa kudzipatula yekha kwa Yehova kuli pamutu pake. ");
INSERT INTO nya_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Munthuyo ndi wopatulika masiku onse odzipereka kwake kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Ngati munthu wina afa mwadzidzidzi pafupi naye ndi kudetsa tsitsi lake loperekedwalo, amete mutu wake pa tsiku lodziyeretsa, tsiku lachisanu ndi chiwiri. ");
INSERT INTO nya_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Tsono pa tsiku lachisanu ndi chitatu abweretse nkhunda ziwiri kapena mawunda awiri anjiwa kwa wansembe pa khomo lolowera ku tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Wansembe apereke imodzi kuti ikhale nsembe yauchimo ndi ina nsembe yopsereza yotetezera tchimo chifukwa anachimwa popezeka pafupi ndi mtembo. Ndipo tsiku lomwelo apatulenso tsitsi la pamutu pake. ");
INSERT INTO nya_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Adzipereke kwa Yehova pa nthawi yodzipatula ndipo abweretse nkhosa yayimuna ya chaka chimodzi ngati nsembe yopepesera. Masiku akale sawerengedwanso chifukwa anadzidetsa pa nthawi yodzipatulira kwake. ");
INSERT INTO nya_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Tsono ili ndi lamulo la Mnaziri pamene nthawi yodzipatula kwake yatha: Abwere naye pa khomo la tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Pamenepo apereke chopereka chake kwa Yehova: Nkhosa yayimuna ya chaka chimodzi yopanda chilema kuti ikhale nsembe yopsereza, mwana wankhosa wamkazi mmodzi wopanda chilema kuti ikhale nsembe yauchimo, ndi nkhosa imodzi yayikulu yayimuna kuti ikhale nsembe yachiyanjano, ");
INSERT INTO nya_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ndipo abwere pamodzi ndi nsembe yachakudya ndi nsembe yachakumwa ndi dengu la buledi wopanda yisiti, makeke opangidwa ndi ufa wosalala wosakaniza ndi mafuta, ndi timitanda ta buledi topakidwa mafuta. ");
INSERT INTO nya_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Wansembe apereke zimenezi pamaso pa Yehova ndi kuchita nsembe ya uchimo ndi nsembe yopsereza. ");
INSERT INTO nya_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Apereke dengu la buledi wopanda yisiti ndiponso nsembe yachiyanjano kwa Yehova ya nkhosa yayimuna, pamodzi ndi chopereka cha chakudya ndi chopereka cha chakumwa. ");
INSERT INTO nya_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“Mnaziriyo amete tsitsi limene analipereka lija pa khomo la tenti ya msonkhano. Atenge tsitsilo ndi kuliyika pa moto umene uli pansi pa nsembe yachiyanjano. ");
INSERT INTO nya_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“Mnaziriyo atatha kumeta tsitsi analiperekalo, wansembe ayike mʼmanja mwake mwendo wa mmwamba wankhosa yayimuna umene waphikidwa ndipo atengenso keke ndi kamtanda ka buledi, zonse zopanda yisiti zomwe zili mʼdengu lija. ");
INSERT INTO nya_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Wansembe aziweyule pamaso pa Yehova ngati nsembe yoweyula. Zimenezi ndi zopatulika ndipo ndi za wansembe pamodzi ndi chidale chimene anachiweyula ndi ntchafu yomwe anayipereka ija. Zitatha izi, Mnaziri akhoza kumwa vinyo. ");
INSERT INTO nya_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Ili ndi lamulo la Mnaziri yemwe walonjeza kudzipereka kwa Yehova podzipatula yekha kuphatikiza pa zomwe angathe kukwaniritsa. Ayenera kukwaniritsa lonjezo lomwe wachitalo potsata lamulo la Mnaziri.” ");
INSERT INTO nya_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Uza Aaroni ndi ana ake aamuna kuti, ‘Umu ndi mmene muzidalitsira Aisraeli. Muzinena kuti, ");
INSERT INTO nya_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘Yehova akudalitse ndi kukusunga; ");
INSERT INTO nya_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Yehova awalitse nkhope yake pa iwe, nakuchitira chisomo; ");
INSERT INTO nya_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Yehova akweze nkhope yake pa iwe, nakupatse mtendere.’ ” ");
INSERT INTO nya_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Choncho akadzatchula dzina langa podalitsa Aisraeli, Ine ndidzawadalitsadi. ");
INSERT INTO nya_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Mose atamaliza kuyimika chihema chija, anachidzoza mafuta ndi kuchipatula pamodzi ndi ziwiya zake zonse. Anadzozanso guwa lansembe ndi kulipatula pamodzi ndi ziwiya zake zonse. ");
INSERT INTO nya_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Kenaka atsogoleri a Aisraeli, akuluakulu a mabanja omwe ankayangʼanira mafuko a anthu omwe anawawerenga aja, anachita chopereka. ");
INSERT INTO nya_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Anabweretsa zopereka zawo pamaso pa Yehova: ngolo zophimbidwa zisanu ndi imodzi ndiponso ngʼombe zothena khumi ndi ziwiri. Mtsogoleri mmodzi ngʼombe yothena imodzi ndipo atsogoleri awiri ngolo imodzi. Izi anazipereka ku chihema. ");
INSERT INTO nya_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Ulandire zimenezi kwa iwo kuti zigwire ntchito ku tenti ya msonkhano. Uzipereke kwa Alevi, aliyense monga mwa ntchito yake.” ");
INSERT INTO nya_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Choncho Mose anatenga ngolo ndi ngʼombe zothenazo nazipereka kwa Alevi. ");
INSERT INTO nya_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Anapereka ngolo ziwiri ndi ngʼombe zothena zinayi kwa Ageresoni monga mwantchito yawo ");
INSERT INTO nya_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ndiponso anapereka ngolo zinayi ndi ngʼombe zothena zisanu ndi zitatu kwa Amerari molingananso ndi ntchito yawo. Onsewa ankawayangʼanira anali Itamara mwana wa Aaroni wansembe. ");
INSERT INTO nya_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Koma Mose sanapereke zimenezi kwa Akohati chifukwa zinthu zawo zopatulika zomwe ankayangʼanira zinali zoti azinyamula pa mapewa awo. ");
INSERT INTO nya_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Guwa la nsembe litadzozedwa, atsogoleri anabweretsa zopereka zawo zopatulira guwa nazipereka paguwapo. ");
INSERT INTO nya_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Pakuti Yehova anawuza Mose kuti, “Tsiku lililonse mtsogoleri mmodzi azibweretsa chopereka chake chopatulira guwa lansembe.” ");
INSERT INTO nya_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Amene anabweretsa chopereka chake tsiku loyamba anali Naasoni mwana wa Aminadabu wa fuko la Yuda. ");
INSERT INTO nya_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Chopereka chake chinali mbale imodzi yasiliva yolemera kilogalamu imodzi, ndi beseni lasiliva limodzi lowazira, lolemera magalamu 800, zonse monga mwa muyeso wa ku malo wopatulika ndipo zonse ziwiri zinali zodzaza ndi ufa wosalala wosakaniza ndi mafuta ngati chopereka chachakudya; ");
INSERT INTO nya_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","mbale imodzi yagolide yolemera magalamu 110, yodzaza ndi lubani; ");
INSERT INTO nya_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","mwana wangʼombe wamwamuna mmodzi, nkhosa yayimuna imodzi ndi mwana wankhosa wamwamuna mmodzi wa chaka chimodzi, za nsembe yopsereza; ");
INSERT INTO nya_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","mbuzi yayimuna imodzi, nsembe ya machimo; ");
INSERT INTO nya_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ndi ngʼombe zothena ziwiri, nkhosa zazimuna zisanu, mbuzi zazimuna zisanu ndi ana ankhosa asanu a chaka chimodzi kuti zikhale za nsembe yachiyanjano. Ichi chinali chopereka cha Naasoni mwana wa Aminadabu. ");
INSERT INTO nya_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Pa tsiku lachiwiri, Natanieli mwana wa Zuwara, mtsogoleri wa Isakara, anabweretsa chopereka chake. ");
INSERT INTO nya_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Chopereka chomwe anabwera nacho chinali mbale imodzi yasiliva yolemera kilogalamu imodzi, beseni limodzi lowazira lasiliva lolemera magalamu 800, molingana ndi muyeso wa ku malo opatulika. Mbale zonse zinali zodzaza ndi ufa wosalala wosakaniza ndi mafuta monga chopereka cha chakudya. ");
INSERT INTO nya_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Mbale imodzi yagolide yolemera magalamu 110 yodzaza ndi lubani; ");
INSERT INTO nya_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","mwana wangʼombe wamwamuna mmodzi, nkhosa yayimuna imodzi ndi mwana wankhosa mmodzi wa chaka chimodzi, za nsembe yopsereza: ");
INSERT INTO nya_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","mbuzi yayimuna imodzi ya nsembe yotetezera machimo; ");
INSERT INTO nya_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ndi ngʼombe ziwiri, nkhosa zazimuna ziwiri, mbuzi zazimuna zisanu ndi ana ankhosa asanu a chaka chimodzi, nsembe ya chiyanjano. Ichi chinali chopereka cha Netanieli mwana wa Zuwara. ");
INSERT INTO nya_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Pa tsiku lachitatu, Eliabu mwana wa Heloni, mtsogoleri wa Azebuloni, anabweretsa chopereka chake. ");
INSERT INTO nya_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Chopereka chake chinali mbale imodzi yasiliva yolemera kilogalamu imodzi ndi theka, ndi beseni limodzi lasiliva lowazira lolemera magalamu 800, zonse monga mwa muyeso wa ku malo opatulika, mbale zonse zodzaza ndi ufa wosalala wosakaniza ndi mafuta, chopereka cha chakudya; ");
INSERT INTO nya_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","mbale imodzi yagolide yolemera magalamu 110, yodzaza ndi lubani; ");
INSERT INTO nya_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","mwana wangʼombe wamwamuna mmodzi, nkhosa yayimuna imodzi ndi mwana wankhosa wamwamuna mmodzi wa chaka chimodzi, za nsembe yopsereza; ");
INSERT INTO nya_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","mbuzi imodzi ya nsembe yopepesera machimo; ");
INSERT INTO nya_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ndi ngʼombe ziwiri, nkhosa zazimuna zisanu, mbuzi zazimuna zisanu ndi ana ankhosa aamuna asanu a chaka chimodzi, nsembe yachiyanjano. Ichi chinali chopereka cha Eliabu mwana wa Heloni. ");
INSERT INTO nya_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Tsiku lachinayi linali la Elizuri mwana wa Sedeuri, mtsogoleri wa fuko la Rubeni, anabweretsa chopereka chake. ");
INSERT INTO nya_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Chopereka chake chinali mbale imodzi yasiliva yolemera kilogalamu imodzi ndi theka, beseni limodzi lowazira lasiliva lolemera magalamu 800, zonse monga mwa muyeso wa ku malo opatulika; zonse ziwiri zinali zodzaza ndi ufa wosalala wosakaniza ndi mafuta, chopereka chachakudya. ");
INSERT INTO nya_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Mbale imodzi yagolide yolemera magalamu 110, yodzaza ndi lubani; ");
INSERT INTO nya_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","mwana wangʼombe wamwamuna mmodzi, nkhosa yayimuna imodzi ndi mwana wankhosa wa chaka chimodzi, za nsembe yopsereza; ");
INSERT INTO nya_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","mbuzi imodzi ya nsembe yopepesera machimo; ");
INSERT INTO nya_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ndi ngʼombe zazimuna ziwiri, nkhosa zazimuna ziwiri, mbuzi zazimuna zisanu ndi ana ankhosa aamuna asanu a chaka chimodzi, nsembe yachiyanjano. Ichi chinali chopereka cha Elizuri mwana wa Sedeuri. ");
INSERT INTO nya_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Pa tsiku lachisanu Selumieli mwana wa Zurisadai, mtsogoleri wa fuko la Simeoni, anabweretsa chopereka chake. ");
INSERT INTO nya_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Chopereka chake chinali mbale yasiliva yolemera kilogalamu imodzi ndi theka ndi beseni limodzi lowazira lasiliva lolemera magalamu 800, zonse monga mwa muyeso wa ku malo opatulika. Zonse ziwiri zinali zodzaza ndi ufa wosalala wosakaniza ndi mafuta monga chopereka chachakudya; ");
INSERT INTO nya_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","mbale yagolide imodzi yolemera 110, yodzaza ndi lubani; ");
INSERT INTO nya_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","mwana wangʼombe wamwamuna mmodzi, nkhosa imodzi ndi mwana wankhosa mmodzi wamwamuna wa chaka chimodzi, za nsembe yopsereza; ");
INSERT INTO nya_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","mbuzi imodzi ya nsembe yopepesera machimo; ");
INSERT INTO nya_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ngʼombe ziwiri, nkhosa zisanu, mbuzi zazimuna zisanu ndi ana ankhosa aamuna asanu a chaka chimodzi, nsembe yachiyanjano. Ichi chinali chopereka cha Selumieli mwana wa Zurisadai. ");
INSERT INTO nya_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Pa tsiku lachisanu ndi chimodzi, Eliyasafu mwana wa Deuweli, mtsogoleri wa fuko la Gadi, anabweretsa chopereka chake. ");
INSERT INTO nya_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Chopereka chakecho chinali mbale imodzi yasiliva yolemera kilogalamu imodzi ndi theka, beseni limodzi lowazira lasiliva lolemera magalamu 800, zonse monga mwa muyeso wa ku malo opatulika; zonse ziwiri zinali zodzaza ndi ufa wosalala wosakaniza ndi mafuta monga chopereka chachakudya; ");
INSERT INTO nya_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","mbale imodzi yagolide yolemera magalamu 110, yodzaza ndi lubani; ");
INSERT INTO nya_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","mwana wangʼombe wamwamuna mmodzi, nkhosa yayimuna imodzi ndi mwana wankhosa wamwamuna mmodzi wa chaka chimodzi, chopereka cha nsembe yopsereza: ");
INSERT INTO nya_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","mbuzi yayimuna imodzi ya nsembe yopepesera machimo; ");
INSERT INTO nya_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ngʼombe zazimuna ziwiri, nkhosa zazimuna zisanu, mbuzi zazimuna zisanu ndi ana ankhosa aamuna asanu a chaka chimodzi, nsembe yachiyanjano. Ichi chinali chopereka cha Eliyasafu mwana wa Deuweli. ");
INSERT INTO nya_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Pa tsiku lachisanu ndi chiwiri Elisama mwana wa Amihudi, mtsogoleri wa fuko la Efereimu, anabweretsa chopereka chake. ");
INSERT INTO nya_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Chopereka chakecho chinali mbale imodzi yasiliva yolemera kilogalamu imodzi ndi theka, ndi beseni limodzi lowazira lasiliva lolemera magalamu 800, zonsezi monga mwa muyeso wa ku malo opatulika, zonse ziwiri zinali zodzaza ndi ufa wosalala wosakaniza ndi mafuta monga chopereka chachakudya; ");
INSERT INTO nya_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","mbale imodzi yagolide yolemera magalamu 110, yodzaza ndi lubani; ");
INSERT INTO nya_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","mwana wangʼombe wamwamuna mmodzi, nkhosa imodzi yayimuna ndi mwana wankhosa wamwamuna mmodzi wa chaka chimodzi, nsembe yopsereza; ");
INSERT INTO nya_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","mbuzi imodzi ya nsembe yopepesera machimo; ");
INSERT INTO nya_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ngʼombe ziwiri, nkhosa zazimuna zisanu, mbuzi zazimuna zisanu ndi ana ankhosa aamuna asanu a chaka chimodzi, nsembe yachiyanjano. Ichi chinali chopereka cha Elisama mwana wa Amihudi. ");
INSERT INTO nya_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Pa tsiku lachisanu ndi chitatu Gamalieli mwana wa Pedazuri, mtsogoleri wa fuko Manase, anabweretsa chopereka chake. ");
INSERT INTO nya_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Chopereka chakecho chinali mbale imodzi yasiliva yolemera kilogalamu imodzi ndi theka, ndi beseni limodzi lowazira lasiliva lolemera magalamu 800, zonse monga mwa muyeso wa ku malo opatulika; zonse ziwiri zinali zodzaza ndi ufa wosalala wosakaniza ndi mafuta monga chopereka chachakudya; ");
INSERT INTO nya_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","mbale imodzi yagolide yolemera magalamu 110, yodzaza ndi lubani, ");
INSERT INTO nya_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","mwana wangʼombe wamwamuna mmodzi, nkhosa yayimuna imodzi ndi mwana wankhosa mmodzi wa chaka chimodzi, nsembe yopsereza; ");
INSERT INTO nya_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","mbuzi imodzi ya nsembe yopepesera machimo; ");
INSERT INTO nya_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ngʼombe zazimuna ziwiri, nkhosa zazimuna zisanu, mbuzi zazimuna zisanu ndi ana ankhosa a chaka chimodzi, nsembe yachiyanjano. Ichi chinali chopereka cha Gamalieli mwana wa Pedazuri. ");
INSERT INTO nya_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Pa tsiku lachisanu ndi chinayi Abidani mwana wa Gideoni mtsogoleri wa fuko la Benjamini, anabweretsa chopereka chake. ");
INSERT INTO nya_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Chopereka chakecho chinali mbale imodzi yasiliva yolemera kilogalamu imodzi ndi theka ndi beseni limodzi lowazira lolemera magalamu 800, zonse monga mwa muyeso wa ku malo opatulika; zonse ziwiri zinali zodzaza ndi ufa wosalala wosakaniza ndi mafuta monga chopereka cha zakudya; ");
INSERT INTO nya_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","mbale imodzi yagolide yolemera magalamu 110, yodzaza ndi lubani; ");
INSERT INTO nya_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","mwana wangʼombe wamwamuna mmodzi, nkhosa imodzi yayimuna ndi mwana wankhosa mmodzi wa chaka chimodzi, nsembe yopsereza; ");
INSERT INTO nya_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","mbuzi yayimuna imodzi ya nsembe yopepesera machimo; ");
INSERT INTO nya_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ngʼombe zazimuna ziwiri, nkhosa zazimuna zisanu, mbuzi zazimuna zisanu, ndi ana ankhosa aamuna asanu a chaka chimodzi, nsembe yachiyanjano. Ichi chinali chopereka cha Abidani mwana wa Gideoni. ");
INSERT INTO nya_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Pa tsiku lakhumi Ahiyezeri mwana wa Amisadai, mtsogoleri wa fuko la Dani anabweretsa chopereka chake. ");
INSERT INTO nya_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Chopereka chake chinali mbale imodzi yasiliva yolemera kilogalamu imodzi ndi theka, beseni limodzi lowazira lasiliva lolemera magalamu 800, zonse monga mwa muyeso wa ku malo opatulika, zonse ziwiri zinali zodzaza ndi ufa wosalala wosakaniza ndi mafuta monga chopereka chachakudya; ");
INSERT INTO nya_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","mbale imodzi yagolide yolemera magalamu 110, yodzaza ndi lubani; ");
INSERT INTO nya_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","mwana wangʼombe wamwamuna mmodzi, nkhosa imodzi yayimuna ndi mwana wankhosa mmodzi wa chaka chimodzi, nsembe yopsereza; ");
INSERT INTO nya_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","mbuzi yayimuna imodzi ya nsembe yopepesera machimo; ");
INSERT INTO nya_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ndi ngʼombe ziwiri zazimuna, nkhosa zazimuna zisanu, mbuzi zazimuna zisanu, ndi ana ankhosa aamuna asanu a chaka chimodzi, nsembe yachiyanjano. Ichi chinali chopereka cha Ahiyezeri mwana wa Amisadai. ");
INSERT INTO nya_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Pa tsiku la khumi ndi chimodzi, Pagieli mwana wa Okirani, mtsogoleri wa fuko la Aseri, anabweretsa chopereka chake. ");
INSERT INTO nya_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Chopereka chakecho chinali mbale imodzi yasiliva yolemera kilogalamu imodzi ndi theka, beseni limodzi lowazira lasiliva lolemera magalamu 800, zonse monga mwa muyeso wa ku malo opatulika; zonse ziwiri zinali zodzaza ndi ufa wosalala wosakaniza ndi mafuta monga chopereka chachakudya; ");
INSERT INTO nya_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","mbale imodzi yagolide yolemera magalamu 110, yodzaza ndi lubani; ");
INSERT INTO nya_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","mwana wangʼombe wamwamuna mmodzi, nkhosa imodzi yayimuna ndi mwana wankhosa mmodzi wa chaka chimodzi, za nsembe yopsereza; ");
INSERT INTO nya_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","mbuzi imodzi yayimuna ya nsembe yopepesera machimo; ");
INSERT INTO nya_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ngʼombe ziwiri zazimuna, nkhosa zazimuna zisanu, mbuzi zazimuna zisanu, ndi ana ankhosa aamuna asanu a chaka chimodzi, nsembe yachiyanjano. Ichi chinali chopereka cha Pagieli mwana wa Okirani. ");
INSERT INTO nya_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Pa tsiku la khumi ndi chimodzi Ahira mwana wa Enani, mtsogoleri wa fuko la Nafutali, anabweretsa chopereka chake. ");
INSERT INTO nya_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Chopereka chakecho chinali mbale imodzi yasiliva yolemera kilogalamu imodzi ndi theka, beseni limodzi lowazira lasiliva lowazira lolemera magalamu 800, zonse monga mwa muyeso wa ku malo opatulika, zonse ziwiri zinali zodzaza ndi ufa wosalala wosakaniza ndi mafuta monga chopereka chachakudya; ");
INSERT INTO nya_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","mbale imodzi yagolide yolemera magalamu 110, yodzaza ndi lubani; ");
INSERT INTO nya_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","mwana wangʼombe wamwamuna mmodzi, nkhosa imodzi yayimuna ndi mwana wankhosa mmodzi wa chaka chimodzi, nsembe yopsereza; ");
INSERT INTO nya_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","mbuzi yayimuna imodzi ya nsembe yopepesera machimo; ");
INSERT INTO nya_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ngʼombe zazimuna ziwiri, nkhosa zazimuna zisanu, mbuzi zazimuna zisanu, ndi ana ankhosa aamuna asanu a chaka chimodzi, nsembe yachiyanjano. Ichi chinali chopereka cha Ahira mwana wa Enani. ");
INSERT INTO nya_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Zopereka za atsogoleri a Israeli zopatulira guwa lansembe pamene linadzozedwa zinali izi: mbale khumi ndi ziwiri zasiliva, mabeseni owazira asiliva khumi ndi awiri ndi mbale zagolide khumi ndi ziwiri. ");
INSERT INTO nya_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Mbale iliyonse yasiliva inkalemera kilogalamu imodzi ndi theka, ndipo beseni lililonse lowazira linkalemera magalamu 800. Pamodzi, mbale zonse zasiliva zinkalemera makilogalamu 27 monga mwa muyeso wa ku malo opatulika. ");
INSERT INTO nya_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Mbale khumi ndi ziwiri zagolide zodzaza ndi lubanizo zinkalemera magalamu 110 iliyonse, monga mwa muyeso wa ku malo opatulika. Pamodzi, mbale zagolide zinkalemera kilogalamu imodzi ndi theka. ");
INSERT INTO nya_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Chiwerengero cha nyama zonse za nsembe yopsereza chinali motere: ngʼombe zazimuna khumi ndi ziwiri, nkhosa zazimuna khumi ndi ziwiri ndi ana ankhosa aamuna khumi ndi awiri a chaka chimodzi pamodzi ndi chopereka chachakudya. Mbuzi zazimuna khumi ndi ziwiri zinali za nsembe yopepesera machimo. ");
INSERT INTO nya_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Chiwerengero cha nyama zonse za nsembe yachiyanjano chinali motere: ngʼombe zothena 24, nkhosa zazimuna 60, mbuzi zazimuna 60 ndi ana ankhosa aamuna a chaka chimodzi 60. Zimenezi ndi zimene zinali zopereka zopatulira guwa lansembe litadzozedwa. ");
INSERT INTO nya_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Mose atalowa mu tenti ya msonkhano kukayankhula ndi Yehova, anamva mawu kuchokera pakati pa Akerubi awiri amene anali pamwamba pa chivundikiro cha bokosi la umboni. Ndipo anayankhula naye. ");
INSERT INTO nya_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Yankhula ndi Aaroni kuti pamene uyimika nyale zisanu ndi ziwiri, nyalezo ziziyaka kutsogolo kwa choyikapo nyale.” ");
INSERT INTO nya_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aaroni anachitadi zomwezo. Anayimika nyale ndi kuziyangʼanitsa kumene kunali choyikapo nyale monga Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Choyikapo nyalecho chinapangidwa motere: chinasulidwa kuchokera ku golide, kuyambira pa tsinde pake mpaka ku maluwa ake. Choyikapo nyalecho chinapangidwa monga momwe Yehova anaonetsera Mose. ");
INSERT INTO nya_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Tenga Alevi pakati pa Aisraeli ndipo uwayeretse. ");
INSERT INTO nya_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Powayeretsa uchite izi: uwawaze madzi oyeretsa ndipo amete thupi lawo lonse ndi kuchapa zovala zawo kuti adziyeretse. ");
INSERT INTO nya_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Atenge ngʼombe yayimuna yayingʼono ndi chopereka cha chakudya cha ufa wosalala wosakaniza ndi mafuta. Atengenso ngʼombe ina yayimuna, yayingʼono, ya chopereka chopepesera machimo. ");
INSERT INTO nya_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Ubwere nawo Aleviwo kutsogolo kwa tenti ya msonkhano ndipo usonkhanitse gulu la Aisraeli. ");
INSERT INTO nya_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Ubwere nawo pamaso pa Yehova, ndipo Aisraeli asanjike manja awo pa iwo. ");
INSERT INTO nya_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Aaroni apereke Alevi aja pamaso pa Yehova ngati chopereka choweyula kuchokera kwa Aisraeli kuti akhale okonzeka kugwira ntchito ya Yehova. ");
INSERT INTO nya_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Alevi akatsiriza kusanjika manja awo pa mitu ya ngʼombe zazimuna, imodzi ikhale ya nsembe yopepesera machimo ndipo inayo ikhale ya nsembe yopsereza ya kwa Yehova, kupepesera machimo a Alevi. ");
INSERT INTO nya_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Uyimiritse Aleviwo pamaso pa Aaroni ndi ana ake aamuna ndipo uwapereke ngati nsembe yoweyula kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Pochita zimenezi mudzapatula Alevi pakati pa Aisraeli ndipo Aleviwo adzakhala anga. ");
INSERT INTO nya_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Utatha kuyeretsa ndi kupereka Aleviwo monga nsembe yoweyula, apite kukagwira ntchito yawo ku tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Iwo ndiwo Aisraeli amene aperekedwa kwathunthu kwa Ine. Ndawatenga kuti akhale anga mʼmalo mwa mwana wamwamuna aliyense woyamba kubadwa wa Mwisraeli aliyense wamkazi. ");
INSERT INTO nya_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Mwana aliyense wamwamuna woyamba kubadwa mu Israeli, kaya wa munthu kapena wa ziweto, ndi wanga. Pamene ndinakantha ana oyamba kubadwa ku Igupto, ndinawapatulira kwa Ine mwini. ");
INSERT INTO nya_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Ndipo ndatenga Alevi mʼmalo mwa ana aamuna onse oyamba kubadwa mu Israeli. ");
INSERT INTO nya_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Mwa Aisraeli onse, ndapereka Alevi kuti akhale mphatso kwa Aaroni ndi ana ake aamuna kugwira ntchito ya ku tenti ya msonkhano mʼmalo mwa Aisraeli onse kuti azikapereka nsembe yopepesera machimo, kuti mliri usadzaphe Aisraeli pamene ayandikira ku malo wopatulika.” ");
INSERT INTO nya_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Mose, Aaroni pamodzi ndi gulu lonse la Israeli anachita kwa Alevi monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Alevi anadziyeretsa ndi kuchapa zovala zawo. Kenaka Aaroni anawapereka ngati nsembe yoweyula pamaso pa Yehova ndi kuchita nsembe yopepesera machimo yowayeretsa. ");
INSERT INTO nya_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Zitatha zimenezi, Alevi anapita kukagwira ntchito yawo ku tenti ya msonkhano motsogozedwa ndi Aaroni ndi ana ake aamuna. Anachita kwa Alevi monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Ntchito za Alevi ndi izi: Amuna a zaka 24 kapena kuposera pamenepa ndiye azibwera kudzagwira ntchito ku tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Koma akakwana zaka makumi asanu, apume pa ntchito yawo ya tsiku ndi tsiku ndi kulekeratu kugwira ntchitoyo. ");
INSERT INTO nya_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Atha kuthandiza abale awo kugwira ntchito za ku tenti ya msonkhano, koma iwowo asamagwire ntchitoyo. Mmenemu ndimo ugawire ntchito yomwe azigwira Alevi.” ");
INSERT INTO nya_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Yehova anayankhula ndi Mose mʼchipululu cha Sinai pa mwezi woyamba wa chaka chachiwiri atatuluka mu Igupto, nati, ");
INSERT INTO nya_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Aisraeli azichita Paska pa nthawi yake yoyikika. ");
INSERT INTO nya_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Muzichita Paska pa nthawi yake yoyikika, madzulo a tsiku la 14 la mwezi uno, potsata malamulo ndi malangizo ake.” ");
INSERT INTO nya_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Choncho Mose anawuza Aisraeli kuti azichita Paska, ");
INSERT INTO nya_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ndipo anachitadi Paskayo mʼchipululu cha Sinai madzulo a tsiku la 14 la mwezi woyamba. Aisraeli anachita zonse monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Koma ena a iwo sanathe kuchita nawo Paska pa tsiku limenelo chifukwa anali odetsedwa chifukwa chokhudza mtembo. Choncho anabwera kwa Mose ndi Aaroni tsiku lomwelo, ");
INSERT INTO nya_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ndipo anawuza Moseyo kuti, “Ife tadetsedwa chifukwa cha mtembo wa munthu. Nʼchifukwa chiyani taletsedwa kupereka nsembe kwa Yehova pamodzi ndi Aisraeli ena pa nthawi yake?” ");
INSERT INTO nya_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mose anawayankha kuti, “Dikirani mpaka nditamva zimene Yehova walamula zokhudza Inu.” ");
INSERT INTO nya_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Ndipo Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Uza Aisraeli kuti, ‘Pamene wina mwa inu kapena zidzukulu zanu adetsedwa chifukwa chokhudza mtembo wa munthu, kapena akakhala pa ulendo, akhoza kuchita nawo Paska ya Yehova. ");
INSERT INTO nya_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Azichita chikondwererochi madzulo a pa tsiku la 14 la mwezi wachiwiri. Azidya mwana wankhosa wamwamuna pamodzi ndi buledi wopanda yisiti ndi ndiwo zowawa zamasamba. ");
INSERT INTO nya_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Iwo asasiye nyama ina iliyonse mpaka mmawa. Asaswe mafupa aliwonse. Pamene akuchita chikondwerero cha Paska, atsate malangizo onse. ");
INSERT INTO nya_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Koma ngati munthu wina ali woyeretsedwa ndipo sali pa ulendo koma alephera kuchita Paska, munthu ameneyo achotsedwe pakati pa anthu a mtundu wake chifukwa sanabweretse chopereka cha Yehova pa nthawi yake. Munthu ameneyo adzalangidwa chifukwa cha tchimo lake. ");
INSERT INTO nya_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘Mlendo amene akukhala pakati panu, nafuna kuchita nawo Paska ya Yehova, achite nawo motsata malamulo ndi malangizo ake. Muzikhala ndi malangizo ofanana a Paska; mbadwa kapena mlendo.’ ” ");
INSERT INTO nya_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Pa tsiku limene anayimika chihema, tenti ya umboni, mtambo unaphimba chihemacho. Kuyambira madzulo mpaka mmawa, mtambo umene unali pamwamba pa chihemacho unkaoneka ngati moto. ");
INSERT INTO nya_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Zinkachitika motere mosalekeza: mtambo unkakhala pamwamba pa chihema, ndipo usiku unkaoneka ngati moto. ");
INSERT INTO nya_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Nthawi ina iliyonse mtambo ukachoka pamwamba pa chihema, Aisraeli ankasamukanso, ndipo paliponse pamene mtambo wayima, Aisraeli ankamangapo misasa. ");
INSERT INTO nya_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Aisraeli ankasamuka pamalopo Yehova akawalamula, ndipo ankamanganso misasa Iyeyo akawalamula. Nthawi yonse imene mtambowo wayima pa chihema, ankakhalabe mʼmisasa yawo. ");
INSERT INTO nya_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Mtambowo ukakhala pa chihema nthawi yayitali, Aisraeli ankasungabe lamulo la Yehova ndipo iwo sankasamukanso. ");
INSERT INTO nya_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Nthawi zina mtambowo unkakhala pa chihemapo masiku owerengeka. Aisraeli ankamanga misasa molamulidwa ndi Yehova ndipo ankasamukanso molamulidwa ndi Iyeyo. ");
INSERT INTO nya_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Nthawi zina mtambo unkakhala kuyambira madzulo mpaka mmawa ndipo unkachoka mmawa mwake, ankasamuka. Kaya ndi masana kapena usiku, pamene mtambo wachoka, ankasamuka. ");
INSERT INTO nya_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ngakhale mtambo ukhale pa chihema masiku awiri kapena mwezi kapena chaka, Aisraeli ankakhalabe pa msasa osachoka. Koma ukachoka, ankasamuka. ");
INSERT INTO nya_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Molamulidwa ndi Yehova ankamanga misasa yawo ndipo ankasamukanso Yehova akawalamula. Ankamvera lamulo la Yehova kudzera mwa Mose. ");
INSERT INTO nya_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Sula malipenga awiri a siliva, ndipo uziwagwiritsa ntchito posonkhanitsa anthu pamodzi ndiponso powasamutsa mʼmisasa. ");
INSERT INTO nya_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Pamene akuliza malipenga onse awiri, anthu onse asonkhane kwa iwe pa khomo la tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Akaliza limodzi lokha, atsogoleri, akulu a mafuko a Aisraeli, asonkhane kwa iwe. ");
INSERT INTO nya_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Akaliza lipenga lochenjeza, misasa yomwe ili kummawa iyambe kusamuka. ");
INSERT INTO nya_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Akaliza lipenga lochenjeza lachiwiri, misasa yakummwera iyambe kusamuka. Kuliza kwa lipenga lochenjeza kudzakhala chizindikiro choyamba ulendo. ");
INSERT INTO nya_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Pofuna kusonkhanitsa anthu, muziliza malipenga, koma mosiyana ndi mmene malipenga ochenjeza amalizidwira. ");
INSERT INTO nya_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Ana a Aaroni, ansembe aja, ndiwo aziliza malipengawo. Zimenezi zikhale zokhazikika kwa inu ndi ku mibado yanu yonse. ");
INSERT INTO nya_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Pamene mukupita ku nkhondo mʼdziko lanu lomwe, kulimbana ndi mdani amene akukuzunzani, muziliza malipenga ochenjeza ndipo Yehova Mulungu wanu adzakukumbukirani ndi kukulanditsani mʼmanja mwa adani anu. ");
INSERT INTO nya_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Komanso pa nthawi yanu ya chisangalalo, pa maphwando anu oyikika ndi maphwando a mwezi watsopano, muziliza malipenga pa nsembe zanu zopsereza ndi nsembe zanu za chiyanjano, ndipo zidzakhala chikumbutso chanu pamaso pa Mulungu. Ine ndine Yehova Mulungu wanu.” ");
INSERT INTO nya_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Pa chaka chachiwiri, mwezi wachiwiri, tsiku la 20, mtambo unachoka pamwamba pa chihema cha umboni. ");
INSERT INTO nya_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Ndipo Aisraeli ananyamuka kuchoka mʼchipululu cha Sinai ndipo anayenda malo osiyanasiyana mpaka pamene mtambo unayima mʼchipululu cha Parani. ");
INSERT INTO nya_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Kameneka kanali koyamba kuti Aisraeli anyamuke monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Magulu a msasa wa Yuda ndiwo anayamba kunyamuka potsata mbendera yawo. Mtsogoleri wa gulu lawo anali Naasoni mwana wa Aminadabu. ");
INSERT INTO nya_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Mtsogoleri wa gulu la fuko la Isakara anali Netanieli mwana wa Zuwara, ");
INSERT INTO nya_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eliabu mwana wa Heloni ndiye anali mtsogoleri wa fuko la Zebuloni. ");
INSERT INTO nya_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Kenaka anagwetsa chihema, ndipo Ageresoni ndi Amerari amene ananyamula chihemacho, ananyamuka. ");
INSERT INTO nya_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Kenaka magulu a msasa wa fuko la Rubeni ananyamuka potsatira mbendera yawo. Mtsogoleri wawo anali Elizuri mwana wa Sedeuri. ");
INSERT INTO nya_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Mtsogoleri wa fuko la Simeoni anali Selumieli mwana wa Zurisadai, ");
INSERT INTO nya_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ndipo Eliyasafu mwana wa Deuweli ndiye ankatsogolera fuko la Gadi. ");
INSERT INTO nya_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Kenaka Akohati ananyamuka atanyamula zinthu zopatulika. Chihema chinkayenera kuyimikidwa iwo asanafike. ");
INSERT INTO nya_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Magulu a msasa wa Aefereimu anatsatira potsatira mbendera yawo. Elisama mwana wa Amihudi ndiye anali mtsogoleri wawo. ");
INSERT INTO nya_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamalieli mwana wa Pedazuri ndiye anali mtsogoleri wa fuko la Manase. ");
INSERT INTO nya_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Abidani mwana wa Gideoni ndiye anali mtsogoleri wa mtundu wa Benjamini. ");
INSERT INTO nya_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Pambuyo pa magulu onse panali magulu a msasa wa Dani, omwe ankateteza magulu onsewa ndipo ananyamuka potsatira mbendera yawo. Mtsogoleri wawo anali Ahiyezeri mwana wa Amisadai. ");
INSERT INTO nya_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagieli mwana wa Okirani ndiye anali mtsogoleri wa fuko la Aseri, ");
INSERT INTO nya_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ndipo mtsogoleri wa mtundu wa Nafutali anali Ahira mwana wa Enani. ");
INSERT INTO nya_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Umenewu ndiwo unali mndandanda wa kayendedwe ka magulu a Aisraeli pamene ankanyamuka ulendo wawo mʼmagulumagulu. ");
INSERT INTO nya_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Ndipo Mose anawuza Hobabu mwana wa Reueli Mmidiyani, mpongozi wa Mose kuti, “Tikunyamuka kupita ku malo amene Yehova anati, ‘Ndidzakupatsani.’ Tiye upite nafe ndipo tidzakusamalira bwino, pakuti Yehova analonjeza zinthu zabwino kwa Israeli.” ");
INSERT INTO nya_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobabu anayankha kuti, “Ayi, sindipita nanu, ndibwerera ku dziko la kwathu ndi kwa abale anga.” ");
INSERT INTO nya_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Ndipo Mose anati, “Pepa usatisiye popeza ukudziwa kumene tingamange misasa mʼchipululu muno ndipo udzakhala maso athu. ");
INSERT INTO nya_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Iweyo ukapita nafe, tidzagawana nawe zinthu zabwino zomwe Yehova adzatipatsa.” ");
INSERT INTO nya_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Motero ananyamuka ku Phiri la Yehova nayenda ulendo wa masiku atatu. Bokosi la Chipangano cha Yehova linkayenda patsogolo pawo pa masiku atatuwo kuti apeze malo woti apumulepo. ");
INSERT INTO nya_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Mtambo wa Yehova unkawaphimba masana pamene ankasamuka pa misasa yawo. ");
INSERT INTO nya_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Nthawi iliyonse imene Bokosi la Chipangano likunyamuka, Mose ankanena kuti, “Dzukani, Inu Yehova! Adani anu abalalike; Odana nanu athawe pamaso panu. ");
INSERT INTO nya_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","“Pamene likupumula, ankanena kuti, “Bwererani, Inu Yehova, ku chinamtindi cha Aisraeli.” ");
INSERT INTO nya_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Anthu atadandaula kwa Yehova chifukwa cha mavuto awo, Yehovayo anamva ndipo anakwiya kwambiri. Kenaka moto wa Yehova unayaka pakati pawo ndi kutentha zigawo zina za kunja kwa msasa. ");
INSERT INTO nya_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Anthuwo analira kwa Mose ndipo Moseyo atapemphera kwa Yehova, motowo unazima. ");
INSERT INTO nya_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Motero malowo anawatcha Tabera, chifukwa moto wa Yehova unayaka pakati pawo. ");
INSERT INTO nya_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Anthu ena osokoneza amene anali pakati pa Aisraeli anayamba kukhumba chakudya cha ku Igupto ndipo Aisraeli nawonso anayamba kufuwula kwambiri nʼkumati, “Tikanangopeza nyama yoti nʼkudya! ");
INSERT INTO nya_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Tikukumbukira nsomba zaulere zimene tinkadya ku Igupto komanso nkhaka, mavwende, anyezi wamitundumitundu ndi adyo. ");
INSERT INTO nya_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Koma tsopano chilakolako chathu chatha. Sitikuona kanthu kena kakudya koma mana basi!” ");
INSERT INTO nya_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mana ankafanana ndi mbewu zamapira ndipo maonekedwe ake anali ngati ulimbo wowuma. ");
INSERT INTO nya_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Anthu ankapita kukatola manawo, nʼkumasinja mu mtondo kapena kupera. Ankawaphika mu mʼphika kapena kupanga makeke. Ndipo ankakoma ngati makeke ophikira mafuta a olivi. ");
INSERT INTO nya_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Mame akamagwa pa msasawo usiku ankagwera kumodzi ndi manawo. ");
INSERT INTO nya_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Mose anamva anthu a banja lililonse akufuwula, banja lililonse pa khomo la tenti yake. Yehova anakwiya kwambiri ndipo Mose anavutikanso mu mtima. ");
INSERT INTO nya_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Mose anafunsa Yehova kuti, “Chifukwa chiyani mwabweretsa mavuto otere pa mtumiki wanune? Nʼchiyani chimene ndachita choti sichinakusangalatseni mpaka kundisenzetsa katundu wa anthu onsewa? ");
INSERT INTO nya_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Kodi Ndine amene ndinatenga pathupi pa anthu onsewa? Kodi ndinawabala ndine? Bwanji mukundiwuza kuti ndiwanyamule mʼmanja mwanga, monga momwe mlezi amanyamulira kamwana, kupita nawo ku malo omwe munalonjeza ndi lumbiro kwa makolo awo? ");
INSERT INTO nya_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ndingayipeze kuti nyama yoti anthu onsewa adye? Iwowa akulirira ine kuti, ‘Tipatse nyama tidye!’ ");
INSERT INTO nya_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Sindingathe kusamala anthu onsewa ndekha. Katundu ameneyu ndi wolemera kwambiri kwa ine. ");
INSERT INTO nya_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ngati umu ndi mmene muzichitira nane, chonde ingondiphani pompano. Koma ngati mwandikomera mtima ndiye ndisaonenso mavutowa.” ");
INSERT INTO nya_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Yehova anawuza Mose kuti, “Undibweretsere anthu 70 ochokera pakati pa akuluakulu a Aisraeli, amene umawadziwa kuti ndiwo atsogoleri komanso akuluakulu a mabanja. Abwere ku tenti ya msonkhano kuti ayime kumeneko pamodzi ndi iwe. ");
INSERT INTO nya_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ndidzatsika ndi kuyankhula nawe kumeneko, ndipo ndidzatenga mzimu umene uli pa iwe ndi kuyika pa iwowo. Adzakuthandiza kusenza nkhawa za anthuwa ndipo sudzasenzanso wekha.” ");
INSERT INTO nya_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Uwawuze anthuwo kuti, ‘Mudziyeretse, kukonzekera mawa, pamene mudzadya nyama.’ Yehova anakumvani pamene munkalira kuti, ‘Zikanakhala bwino tikanapeza nyama yoti tidye! Tinkakhala bwino ku Igupto!’ Tsopano Yehova adzakupatsani nyama ndipo mudzayidyadi. ");
INSERT INTO nya_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Simudzadya tsiku limodzi lokha, kapena masiku awiri, kapena asanu, khumi kapena masiku makumi awiri, ");
INSERT INTO nya_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","koma mwezi wonse, mpaka itakukolani ndi kutopa nayo chifukwa mwakana Yehova yemwe ali pakati panu ndipo mwalira pamaso pake kuti, ‘Bwanji tinachoka ku Igupto?’ ” ");
INSERT INTO nya_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Koma Mose anati, “Taonani pano ndili pakati pa anthu 600,000 amene ndi kuyenda nawo ndipo Inuyo mukuti, ‘Ndidzawapatsa nyama kuti adye mwezi wathunthu!’ ");
INSERT INTO nya_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Kodi ngakhale titapha nkhosa ndi ngʼombe, zingawakwanire? Ngakhale titagwira nsomba zonse za mʼnyanja, kodi zingawakwanire iwowa?” ");
INSERT INTO nya_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Yehova anayankha Mose kuti, “Kodi dzanja langa ndi lalifupi? Uwona tsopano ngati zimene ndanenazo zichitike kapena ayi.” ");
INSERT INTO nya_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Choncho Mose anatuluka nakawuza anthu zomwe Yehova ananena. Anasonkhanitsa pamodzi akuluakulu makumi asanu ndi awiri aja ndi kuwayimiritsa mozungulira Chihema. ");
INSERT INTO nya_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Ndipo Yehova anatsika mʼmitambo ndi kuyankhula naye ndipo anatengako mzimu womwe unali pa Mose ndi kuwuyika pa akuluakulu makumi asanu ndi awiri aja. Pamene mzimuwo unakhazikika pa akuluakuluwo, anayamba kunenera koma sanapitirize. ");
INSERT INTO nya_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Koma anthu ena awiri omwe mayina awo anali Elidadi ndi Medadi, anatsalira mu msasa. Anali nawo mʼgulu la olembedwa aja, koma sanapite nawo ku Chihema. Komabe mzimu unakhala pa iwo ndipo ananenera ali mu msasa. ");
INSERT INTO nya_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Mnyamata wina anathamanga kudzawuza Mose kuti, “Elidadi ndi Medadi akunenera mu msasa.” ");
INSERT INTO nya_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Yoswa mwana wa Nuni, mtumiki wa Mose kuyambira ubwana wake, anayankha kuti, “Mbuye wanga Mose, aletseni!” ");
INSERT INTO nya_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Koma Mose anati, “Kodi ukuchita nsanje chifukwa cha ine? Ndikanakonda kuti anthu onse a Yehova akhale aneneri ndi kuti Yehova ayike mzimu wake pa iwo!” ");
INSERT INTO nya_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Mose ndi akuluakulu a Israeli aja anabwerera ku msasa. ");
INSERT INTO nya_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Pamenepo Yehova anawutsa mphepo yochokera ku nyanja imene inabweretsa zinziri. Zinzirizo zinagwera pansi kuzungulira msasa, mtunda wa kilomita imodzi mbali zonse ndipo msinkhu wake unali mita imodzi. ");
INSERT INTO nya_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Tsiku limenelo masana onse mpaka usiku ndiponso tsiku lotsatiralo, anthu anatuluka kunja kukatola zinziri. Palibe amene anasonkhanitsa zochepera makilogalamu 1,000 ndipo anaziyanika kuzungulira msasa wonse. ");
INSERT INTO nya_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Koma pamene anthuwo ankadya nyamayo, asanayimeze nʼkomwe, ukali wa Yehova unafika pa iwo ndipo Iye anawakantha ndi mliri woopsa. ");
INSERT INTO nya_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Nʼchifukwa chake malowo anawatcha Kibiroti Hatava chifukwa pamenepo anakwirirapo anthu osusuka aja. ");
INSERT INTO nya_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Kuchoka pa Kibiroti Hatava anthuwo anayenda kupita ku Heziroti ndipo anakhala kumeneko kwa kanthawi. ");
INSERT INTO nya_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miriamu ndi Aaroni anayamba kuyankhula motsutsana ndi Mose chifukwa cha mkazi wa ku Kusi, popeza Moseyo anakwatira Mkusi. ");
INSERT INTO nya_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Iwowo anafunsa kuti, “Kodi Yehova anayankhula kudzera mwa Mose yekha? Kodi sanayankhule kudzeranso mwa ife?” Ndipo Yehova anamva zimenezi. ");
INSERT INTO nya_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Koma Mose anali munthu wodzichepetsa kwambiri kuposa munthu aliyense pa dziko lapansi). ");
INSERT INTO nya_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Nthawi yomweyo Yehova anati kwa Mose, Aaroni ndi Miriamu, “Bwerani ku tenti ya msonkhano nonse atatu.” Ndipo atatuwo anapitadi kumeneko. ");
INSERT INTO nya_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Tsono Yehova anatsika mu mtambo, nayima pa khomo la chihema. Kenaka anayitana Aaroni ndi Miriamu. Ndipo onse awiri atapita patsogolo, ");
INSERT INTO nya_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Mulungu anati, “Mverani mawu anga: “Pakakhala mneneri wa Yehova pakati panu, ndimadzionetsera kwa iyeyo mʼmasomphenya, ndimayankhula naye mʼmaloto. ");
INSERT INTO nya_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Koma sinditero ndi Mose mtumiki wanga; Iyeyu ndi wokhulupirika mʼnyumba yanga yonse. ");
INSERT INTO nya_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ndimayankhula naye maso ndi maso, momveka bwino osati mophiphiritsa; ndipo amaona maonekedwe a Yehova. Nʼchifukwa chiyani simunaope kuyankhula motsutsana ndi Mose mtumiki wanga?” ");
INSERT INTO nya_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Ndipo Yehova anawakwiyira, nachoka. ");
INSERT INTO nya_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Pamene mtambo unachoka pamwamba pa Chihema, taonani, Miriamu anagwidwa ndi khate. Aaroni atachewuka anaona Miriamu ali ndi khate; ");
INSERT INTO nya_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ndipo Aaroni anawuza Mose kuti, “Pepani mbuye wanga, musatilange chifukwa cha tchimo limene tachita mopusa. ");
INSERT INTO nya_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Musalole kuti Miriamu akhale ngati mwana wobadwa wakufa kuchoka mʼmimba mwa amayi ake, thupi lake litawonongeka.” ");
INSERT INTO nya_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Tsono Mose anafuwulira Yehova kuti, “Chonde Inu Mulungu, muchiritseni!” ");
INSERT INTO nya_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Yehova anayankha Mose kuti, “Abambo ake akanamulavulira malovu mʼmaso, kodi sakanakhala wonyozeka masiku asanu ndi awiri? Mutsekereni kunja kwa msasa masiku asanu ndi awiri, kenaka mumulowetsenso.” ");
INSERT INTO nya_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Choncho anamutsekera Miriamu kunja kwa msasa masiku asanu ndi awiri ndipo anthu sanayende ulendo wawo mpaka Miriamu atamulowetsanso. ");
INSERT INTO nya_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Pambuyo pake anthu ananyamuka ku Heziroti ndi kukamanga mʼchipululu cha Parani. ");
INSERT INTO nya_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Tuma anthu kuti akazonde dziko la Kanaani limene ndikupereka kwa Aisraeli. Kuchokera pa fuko lililonse utume munthu mmodzi amene ndi mtsogoleri wawo.” ");
INSERT INTO nya_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Monga mwa mawu a Yehova, Mose anawatuma kuchokera ku chipululu cha Parani. Onsewo anali atsogoleri a Aisraeli. ");
INSERT INTO nya_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Mayina awo ndi awa: kuchokera ku fuko la Rubeni, Samuwa mwana wa Zakuri; ");
INSERT INTO nya_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","kuchokera ku fuko la Simeoni, Safati mwana wa Hori; ");
INSERT INTO nya_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","kuchokera ku fuko la Yuda, Kalebe mwana wa Yefune; ");
INSERT INTO nya_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","kuchokera ku fuko la Isakara, Igala mwana wa Yosefe; ");
INSERT INTO nya_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","kuchokera ku fuko la Efereimu, Hoseya mwana wa Nuni; ");
INSERT INTO nya_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","kuchokera ku fuko la Benjamini, Paliti mwana wa Rafu; ");
INSERT INTO nya_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","kuchokera ku fuko la Zebuloni, Gadieli mwana wa Sodi; ");
INSERT INTO nya_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","kuchokera ku fuko la Manase (fuko la Yosefe), Gadi mwana wa Susi; ");
INSERT INTO nya_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","kuchokera ku fuko la Dani, Amieli mwana wa Gemali; ");
INSERT INTO nya_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","kuchokera ku fuko la Aseri, Seturi mwana wa Mikayeli; ");
INSERT INTO nya_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","kuchokera ku fuko la Nafutali, Naabi mwana wa Vofisi; ");
INSERT INTO nya_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","kuchokera ku fuko la Gadi, Geuweli mwana wa Maki. ");
INSERT INTO nya_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Amenewa ndiwo mayina a anthu amene Mose anawatuma kukazonda dzikolo. (Hoseya mwana wa Nuni, Mose anamupatsa dzina loti Yoswa). ");
INSERT INTO nya_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Mose atawatuma kuti akazonde Kanaani anati, “Mupite kudzera ku Negevi, mukapitirire mpaka ku dziko la mapiri. ");
INSERT INTO nya_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Mukaone dzikolo kuti ndi lotani ndi anthu okhala mʼmenemo ngati ndi amphamvu kapena ofowoka, ochepa kapena ambiri. ");
INSERT INTO nya_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Nanga dziko limene akukhalako ndi lotani? Ndi labwino kapena loyipa? Mizinda imene akukhalamo ndi yotani? Kodi ilibe malinga kapena ndi ya malinga? ");
INSERT INTO nya_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Nthaka yake ndi yotani? Yachonde kapena yopanda chonde? Kodi dzikolo lili ndi mitengo kapena lilibe mitengo? Mukayesetse kubweretsako zipatso za mʼdzikomo.” (Inali nthawi yamphesa zoyamba kupsa). ");
INSERT INTO nya_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Choncho anapita kukazonda dzikolo kuchokera ku chipululu cha Zini mpaka ku Rehobu, mopenyana ndi Lebo Hamati. ");
INSERT INTO nya_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Anapita kudzera ku Negevi ndi kukafika ku Hebroni, kumene Ahimani, Sesai ndi Talimai, ana a Anaki ankakhala. (Anamanga Hebroni zaka zisanu ndi ziwiri asanamange Zowani ku Igupto). ");
INSERT INTO nya_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Atafika ku chigwa cha Esikolo, anadulako nthambi ya mpesa ya phava limodzi la mphesa ndipo anthu awiri ananyamulizana, natenganso makangadza ndi nkhuyu. ");
INSERT INTO nya_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Malo amenewo anawatcha chigwa cha Esikolo chifukwa cha phava la mphesa limene Aisraeli anadula kumeneko. ");
INSERT INTO nya_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Patapita masiku makumi anayi, anthu aja anabwerako kokazonda dziko lija. ");
INSERT INTO nya_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Ndipo atabwerako anapita kwa Mose ndi Aaroni ndi kwa Aisraeli onse ku Kadesi mʼchipululu cha Parani. Kumeneko anafotokozera anthu onse nawaonetsanso zipatso za mʼdzikolo. ");
INSERT INTO nya_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Anthuwo anafotokozera Mose kuti, “Tinapita ku dziko komwe munatituma. Dzikolo ndi loyenda mkaka ndi uchi ndipo zipatso zake ndi izi. ");
INSERT INTO nya_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Koma anthu amene amakhala mʼdzikomo ndi amphamvu, mizinda yawo ndi ya malinga aakulu kwambiri. Tinaonanso Aanaki kumeneko. ");
INSERT INTO nya_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Aamaleki amakhala ku Negevi, Ahiti, Ayebusi ndi Aamori amakhala mʼdziko la mapiri ndipo Akanaani amakhala pafupi ndi nyanja, mʼmbali mwa Yorodani.” ");
INSERT INTO nya_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Koma Kalebe anawakhalitsa chete anthuwo pamaso pa Mose, ndipo anati, “Tiyeni tipite ndithu ndi kutenga dzikolo, pakuti tingathe kulitenga.” ");
INSERT INTO nya_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Koma anthu aja amene anapita naye anati, “Sitingathe kulimbana ndi anthuwo popeza ndi amphamvu kuposa ifeyo.” ");
INSERT INTO nya_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Choncho anthuwo anafalitsa pakati pa Aisraeli mbiri yoyipa ya dziko lomwe anakalionalo. Iwo anati, “Dziko limene tinapita kukalizonda limawononga anthu okhala mʼmenemo. Ndipo anthu onse amene tinakawaona kumeneko ndi ataliatali. ");
INSERT INTO nya_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Kumeneko tinaona Anefili (ana a Aanaki ochokera kwa Nefili). Ifeyo timangodziona ngati ziwala mʼmaso mwawo, ndipo kwa iwo timaonekadi motero ndithu.” ");
INSERT INTO nya_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Usiku umenewo gulu lonse la Aisraeli linalira mofuwula kwambiri. ");
INSERT INTO nya_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ndipo Aisraeli onse anayankhula motsutsana ndi Mose ndi Aaroni. Gulu lonse linanena kwa iwo kuti, “Kunali bwino tikanafera ku Igupto kapena mʼchipululu muno! ");
INSERT INTO nya_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Nʼchifukwa chiyani Yehova akutilowetsa mʼdziko limenelo? Kodi kuti tikaphedwe ndi lupanga? Kuti akazi ndi ana athu akatengedwe ngati katundu wolanda ku nkhondo? Kodi sikungakhale bwino kuti tibwerere ku Igupto?” ");
INSERT INTO nya_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ndipo anawuzana wina ndi mnzake kuti, “Tiyeni tisankhe mtsogoleri ndipo tibwerere ku Igupto.” ");
INSERT INTO nya_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Koma Mose ndi Aaroni anadzigwetsa pansi chafufumimba pamaso pa Aisraeli onse omwe anasonkhana pamenepo. ");
INSERT INTO nya_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Yoswa mwana wa Nuni ndi Kalebe mwana wa Yefune, omwe anali amodzi mwa amene anakazonda nawo dziko, anangʼamba zovala zawo ");
INSERT INTO nya_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ndipo anati kwa gulu lonse la Aisraeli, “Dziko limene tinakayendamo ndi kuliona ndi labwino kwambiri zedi. ");
INSERT INTO nya_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ngati Yehova akukondwera nafe, adzatitsogolera kulowa mʼdziko limenelo. Dziko loyenda mkaka ndi uchi adzalipereka kwa ife, ");
INSERT INTO nya_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","koma musawukire Yehova. Komanso musaope anthu a mʼdzikomo, pakuti tidzawagonjetsa. Chitetezo chawachokera, koma ife Yehova ali nafe. Musawaope.” ");
INSERT INTO nya_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Koma gulu lonse linayankhula zofuna kuwagenda miyala. Pamenepo ulemerero wa Yehova unaonekera kwa Aisraeli onse ku tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Yehova anawuza Mose kuti, “Anthu awa adzandinyoza mpaka liti? Sadzandikhulupirira mpaka liti, ngakhale ndachita zizindikiro zozizwitsa zonsezi pakati pawo? ");
INSERT INTO nya_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ndidzawakantha ndi mliri ndi kuwawononga. Koma ndidzakusandutsa iwe mtundu waukulu ndi wamphamvu kuposa iwo.” ");
INSERT INTO nya_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mose anati kwa Yehova, “Aigupto adzamva zimenezi! Mwa mphamvu yanu munawatulutsa anthu amenewa pakati pawo. ");
INSERT INTO nya_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Ndipo iwowo adzawuza anthu okhala mʼdziko lino zimenezi. Anthuwa amva kale kuti Inu Yehova mumakhala pakati pa anthu amenewa ndi kuti Inuyo Yehova mwawaonekera maso ndi maso. Mtambo wanu umakhala pamwamba pawo ndiponso mumayenda nawo mu mtambo woyima, masana ndi moto woyima, usiku. ");
INSERT INTO nya_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Tsono mukawapha anthu onsewa nthawi imodzi, mayiko amene anamva za Inu adzati, ");
INSERT INTO nya_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Yehova walephera kuwalowetsa anthuwo mʼdziko lomwe anawalonjeza molumbira, ndipo wawapha mʼchipululu.’ ");
INSERT INTO nya_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Chonde Ambuye wonetsani mphamvu yanu monga munalonjezera kuti, ");
INSERT INTO nya_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Yehova sakwiya msanga, ndipo ndi wodzaza ndi chikondi chosasinthika, wokhululukira tchimo ndi kuwukira. Koma Iye sadzaleka kulanga ochimwa. Iyeyo amalanga ana chifukwa cha tchimo la makolo awo kufikira mʼbado wachitatu ndi wachinayi.’ ");
INSERT INTO nya_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Chifukwa cha kukula kwa chikondi chanu chosasinthika, akhululukireni anthuwa tchimo lawo monga mwakhala mukuwakhululukira kuchokera pa nthawi imene anachoka ku Igupto mpaka tsopano.” ");
INSERT INTO nya_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Yehova anayankha kuti, “Ndawakhululukira monga wapemphera. ");
INSERT INTO nya_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Komabe, ndikunenetsa kuti pali Ine, ndiponso pamene dziko lapansi ladzaza ndi ulemerero wa Yehova, ");
INSERT INTO nya_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","palibe ndi mmodzi yemwe mwa anthu amene anaona ulemerero wanga ndi zizindikiro zozizwitsa zimene ndinazichita ku Igupto ndi mʼchipululu muno, koma osandimvera ndi kundiyesa kokwanira kakhumi, ");
INSERT INTO nya_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","palibe ndi mmodzi yemwe wa anthu amenewa amene adzaone dziko limene ndinalonjeza ndi lumbiro kwa makolo awo. Aliyense amene anandinyoza sadzaliona dzikolo. ");
INSERT INTO nya_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Koma mtumiki wanga Kalebe, pakuti ali ndi mtima wosiyana ndi ena ndiponso amanditsatira ndi mtima wonse, ndidzamulowetsa mʼdziko limene anapitamolo ndipo zidzukulu zake zidzalandira dzikolo ngati cholowa chawo. ");
INSERT INTO nya_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Ndipo popeza kuti Aamaleki ndi Akanaani akukhala ku chigwa, mawa mubwerere ndipo mupite ku chipululu podzera ku Nyanja Yofiira.” ");
INSERT INTO nya_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Yehova anawuza Mose ndi Aaroni kuti, ");
INSERT INTO nya_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Kodi anthu oyipawa adzangʼungʼudza ndi kutsutsana nane mpaka liti? Ndamva madandawulo a Aisraeli ongʼungʼudzawa. ");
INSERT INTO nya_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Tsono awuze kuti, ‘Ndikulumbira pali Ine,’ akutero Yehova, ‘Ndidzakuchitirani zinthu zonse zimene ndamva inu mukunena: ");
INSERT INTO nya_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Mitembo yanu idzakhala ili ngundangunda mʼchipululu muno; mtembo wa munthu aliyense pakati panu amene ali ndi zaka makumi awiri kapena kupitirirapo, amene anawerengedwa pa chiwerengero chija ndipo anangʼungʼudza motsutsana nane. ");
INSERT INTO nya_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Palibe ndi mmodzi yemwe mwa inu amene adzalowe mʼdziko lomwe ndinalumbira mokweza manja kuti likhale lanu, kupatula Kalebe mwana wa Yefune ndi Yoswa mwana wa Nuni. ");
INSERT INTO nya_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Koma ana anu amene mukunena kuti adzatengedwa ngati katundu wolanda ku nkhondo, Ine ndidzawalowetsa kuti akasangalale mʼdziko limene munalikana. ");
INSERT INTO nya_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Koma inu mitembo yanu idzakhala ngundangunda mʼchipululu muno. ");
INSERT INTO nya_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ana anu adzakhala abusa mʼchipululu muno zaka makumi anayi, kuvutika chifukwa cha kusakhulupirika kwanu, mpaka munthu womaliza mwa inu atafa mʼchipululu muno. ");
INSERT INTO nya_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Mudzavutika chifukwa cha machimo anu kwa zaka makumi anayi Chaka chimodzi chikuyimira tsiku limodzi la masiku makumi anayi amene munakazonda dziko lija ndipo mudzadziwa kuyipa kwake kwa kukangana ndi Ine.’ ");
INSERT INTO nya_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ine Yehova, ndanena, ndidzachitadi zimenezi kwa anthu onse oyipawa, amene agwirizana kunditsutsa. Adzathera mʼchipululu momwe muno, adzafera muno basi.” ");
INSERT INTO nya_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Ndipo anthu amene Mose anawatuma kukazonda dziko aja anachoka pamaso pake nachititsa gulu lonse la anthu kuwukira Moseyo chifukwa chofalitsa mbiri yoyipa ya dzikolo. ");
INSERT INTO nya_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Anthu amene ankafalitsa mbiri yoyipa ya dzikolo anakanthidwa ndi mliri ndipo anafa pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Mwa anthu amene anakaona dzikolo, Yoswa mwana wa Nuni ndi Kalebe mwana wa Yefune ndi okhawo amene anapulumuka. ");
INSERT INTO nya_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mose atafotokoza izi kwa Aisraeli onse, anthuwo analira kwambiri. ");
INSERT INTO nya_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Mmamawa tsiku linalo anapita mbali ya ku dziko la mapiri. Iwo anati, “Tachimwa, tipita ku dziko limene Yehova anatilonjeza.” ");
INSERT INTO nya_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Koma Mose anati, “Chifukwa chiyani simukumvera lamulo la Yehova? Zimenezi sizitheka! ");
INSERT INTO nya_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Musapite chifukwa Yehova sali pakati panu. Mudzagonjetsedwa ndi adani anu ");
INSERT INTO nya_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","chifukwa kumeneko mukakumana ndi Aamaleki ndi Akanaani. Popeza mwaleka kutsata Yehova, Iyeyo sadzakhala nanu ndipo mudzaphedwa ndi lupanga.” ");
INSERT INTO nya_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Komabe mwa maganizo awo anapita molunjika dziko la mapiri ngakhale kuti Mose sanachoke ndi Bokosi la Chipangano la Yehova pa msasa. ");
INSERT INTO nya_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Koma Aamaleki ndi Akanaani amene ankakhala ku dziko lamapirilo anatsika ndi kumenyana nawo ndipo anawakantha mʼnjira yonse mpaka ku Horima. ");
INSERT INTO nya_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Yankhula ndi Aisraeli ndipo uwawuze kuti, ‘Mukakalowa mʼdziko limene ndikukupatsanilo, ");
INSERT INTO nya_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ndipo mukamadzapereka kwa Yehova, nsembe yotentha pa moto ya ngʼombe kapena nkhosa monga fungo lokoma kwa Yehova, kaya ndi nsembe yopsereza kapena nsembe zina, nsembe yapadera chifukwa cha lumbiro kapena nsembe yoperekedwa mwaufulu kapenanso yoperekedwa pa chikondwerero, ");
INSERT INTO nya_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","munthu amene akubweretsa zopereka zake, azikapereka kwa Yehova chopereka chachakudya cholemera kilogalamu imodzi ya ufa wosalala wosakaniza ndi mafuta wokwana lita imodzi. ");
INSERT INTO nya_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Pamodzi ndi mwana wankhosa aliyense wa nsembe yopsereza kapena nsembe ina, muzikakonzanso lita imodzi la vinyo ngati chopereka cha chakumwa.’ ” ");
INSERT INTO nya_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“Pamodzi ndi nkhosa yayimuna, muzikakonzanso chopereka cha chakudya cholemera makilogalamu awiri a ufa wosalala, wosakaniza ndi mafuta okwanira lita imodzi ndi theka, ");
INSERT INTO nya_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ndi vinyo wokwanira lita imodzi ndi theka ngati chopereka cha chakumwa. Muzikapereka monga nsembe yopereka fungo lokoma kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘Pamene mukukonza mwana wangʼombe wamwamuna kuti akhale nsembe yopsereza kapena nsembe ina iliyonse: ya lumbiro lapadera kapena nsembe yachiyanjano kwa Yehova, ");
INSERT INTO nya_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","pamodzi ndi mwana wangʼombe wamwamunayo muzibweretsa nsembe yachakudya yolemera makilogalamu atatu a ufa wosalala wosakaniza ndi mafuta okwana malita awiri. ");
INSERT INTO nya_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Komanso muzibweretsa vinyo wokwanira malita awiri monga chopereka chachakumwa. Imeneyi idzakhala chopereka chotentha pa moto kuti likhale fungo lokoma kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Ngʼombe yayimuna iliyonse kapena nkhosa yayimuna iliyonse, mwana wankhosa aliyense kapena mbuzi yayingʼono, zizikonzedwa motere. ");
INSERT INTO nya_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Ngakhale zingachuluke chotani, chitani izi kwa iliyonse ya nyamazo. ");
INSERT INTO nya_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘Mbadwa iliyonse ya mu Israeli izichita zimenezi pamene ibweretsa nsembe yotentha pa moto kuti ikhale fungo lokoma kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Ku mibado yanu yonse ya mʼtsogolo, pamene mlendo kapena wina aliyense wokhala pakati panu apereka chopereka chotentha pa moto kuti chikhale fungo lokoma kwa Yehova, azichita mofanana ndi momwe inu mumachitira. ");
INSERT INTO nya_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Gulu lonse likhale ndi malamulo ofanana a inu kapena mlendo wokhala pakati panu. Limeneli ndi lamulo lamuyaya kwa mibado imene ikubwera. Inuyo ndi mlendo mudzakhala wofanana pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Mudzakhale ndi malamulo ndi miyambo yofanana, inuyo ndi mlendo wokhala pakati panu.’ ” ");
INSERT INTO nya_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Yankhula ndi Aisraeli ndipo unene kuti, ‘Mukakalowa mʼdziko limene ndikukutengeraniko ");
INSERT INTO nya_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ndipo mukakadya chakudya cha mʼdzikolo, mukapereke gawo lina kwa Yehova monga chopereka. ");
INSERT INTO nya_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Pa buledi wanu woyamba, mukapereke mmodzi monga nsembe, ngati chopereka chochokera ku malo wopunthira tirigu. ");
INSERT INTO nya_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Pa mibado yanu yonse muzidzapereka chopereka ichi kwa Yehova kuchokera ku zakudya zanu zoyamba za mʼnthaka. ");
INSERT INTO nya_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘Ndipo ngati muchimwa mosadziwa posasunga ena mwa malamulo awa amene Yehova wapereka kwa Mose, ");
INSERT INTO nya_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","lina lililonse mwa malamulo a Yehova amene wapereka kwa inu kudzera mwa Mose, kuyambira tsiku limene Yehova anawapereka mpaka mibado ya mʼtsogolo, ");
INSERT INTO nya_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ndipo ngati zimenezi zachitika osati mwadala ndipo gulu lonse silinadziwe, zikatero gulu lonselo lipereke mwana wangʼombe wamwamuna monga nsembe yopsereza kuti likhale fungo lokoma kwa Yehova pamodzinso ndi chopereka chachakudya ndi chopereka cha chakumwa ndi mbuzi yayimuna ngati nsembe yopepesera machimo potsata zimene zinalamulidwa. ");
INSERT INTO nya_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Wansembe apereke nsembe yopepesera machimo a gulu lonse la Aisraeli, ndipo adzakhululukidwa, pakuti linali tchimo lochita mosadziwa. Ndipo chifukwa cha tchimo lawolo, abweretse kwa Yehova nsembe yotentha pa moto ndi nsembe yopepesera machimo. ");
INSERT INTO nya_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Gulu lonse la Aisraeli ndi alendo okhala pakati pawo adzakhululukidwa chifukwa anthu onsewo anachimwa mosadziwa. ");
INSERT INTO nya_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘Koma ngati munthu mmodzi achimwa mosadziwa, ayenera kubweretsa mbuzi yayikazi ya chaka chimodzi kuti ikhale nsembe yopepesera machimo. ");
INSERT INTO nya_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Wansembe apereke nsembe yopepesera machimowo pamaso pa Yehova chifukwa cha munthu yemwe anachimwa mosadziwayo. Nsembe yopepesera tchimo lakelo ikaperekedwa, munthuyo adzakhululukidwa. ");
INSERT INTO nya_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Lamulo lomweli ligwiritsidwe ntchito kwa aliyense wochimwa mosadziwa, kaya ndi mbadwa ya mu Israeli kapena mlendo. ");
INSERT INTO nya_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘Koma aliyense amene achimwa mwadala, kaya ndi mbadwa kapena mlendo, nachitira chipongwe Yehova, ameneyo achotsedwe ndithu pakati pa anthu ake. ");
INSERT INTO nya_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Popeza wanyoza mawu a Yehova ndi kuphwanya malamulo ake. Munthu ameneyo achotsedwe ndithu, kuchimwa kwake kudzakhala pa iyeyo.’ ” ");
INSERT INTO nya_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Aisraeli ali mʼchipululu, munthu wina anapezeka akutola nkhuni tsiku la Sabata. ");
INSERT INTO nya_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Amene anamupeza akutola nkhunizo anabwera naye kwa Mose ndi Aaroni ndi kwa gulu lonse ");
INSERT INTO nya_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ndipo anamutsekera mʼndende chifukwa sankadziwa choti achite naye. ");
INSERT INTO nya_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Pamenepo Yehova anawuza Mose kuti, “Munthu ameneyu ayenera kuphedwa. Gulu lonse liyenera kumugenda ndi miyala kunja kwa msasa.” ");
INSERT INTO nya_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Choncho gululo linamutengera kunja kwa msasa ndi kumupha pomugenda ndi miyala, monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Yankhula ndi Aisraeli ndipo uwawuze kuti, ‘Pa mibado yanu yonse muzisokerera mphonje pa ngodya za zovala zanu ndipo pa ngodya ya mphonje iliyonse azisokererapo chingwe chobiriwira. ");
INSERT INTO nya_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Mudzakhala ndi mphonje zimenezi kuti mukaziona muzikakumbukira malamulo onse a Yehova ndi kuwamvera kuti musamatsatenso zilakolako za mʼmitima mwanu ndi za maso anu. ");
INSERT INTO nya_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Motero mudzakumbukira kumvera malamulo anga ndipo mudzakhala opatulikira a Mulungu wanu. ");
INSERT INTO nya_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ine ndine Yehova Mulungu wanu, amene ndinakutulutsani mʼdziko la Igupto kuti ndikhale Mulungu wanu. Ine ndine Yehova Mulungu wanu.’ ” ");
INSERT INTO nya_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kora mwana wa Izihari, mwana wa Kohati, mwana wa Levi ndi Datani ndi Abiramu ana a Eliabu, pamodzi ndi Oni mwana wa Perezi, ana a Rubeni, anayamba kudzikuza, ");
INSERT INTO nya_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ndipo anawukira Mose. Mʼgulu mwawo munali atsogoleri a Aisraeli 250, anthu otchuka amene anasankhidwa ndi anthu pa msonkhano. ");
INSERT INTO nya_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Iwo anasonkhana kudzatsutsana ndi Mose ndi Aaroni nawawuza kuti, “Mwawonjeza! Anthu onsewa ndi oyera, aliyense wa iwo, ndipo Yehova ali pakati pawo. Chifukwa chiyani mukudzikuza pakati pa gulu lonse la Yehova?” ");
INSERT INTO nya_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Mose atamva izi, anagwa chafufumimba. ");
INSERT INTO nya_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Ndipo iye anawuza Kora ndi anthu onse amene ankamutsatira kuti, “Yehova mawa mmawa adzasonyeza yemwe ndi wake ndiponso amene ndi woyera mtima. Munthuyo adzabwera pafupi ndi Iye. Munthu amene adzamusankheyo adzamusendeza pafupi. ");
INSERT INTO nya_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Iwe Kora pamodzi ndi onse amene akukutsatira chitani izi: Tengani zofukizira ");
INSERT INTO nya_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ndipo mawa muyikemo moto ndi lubani pamaso pa Yehova. Munthu amene Yehova amusankhe ndiye amene ali woyera. Alevi inu mwawonjeza kwambiri!” ");
INSERT INTO nya_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mose anawuzanso Kora kuti, “Inu Alevi, tsopano tamverani! ");
INSERT INTO nya_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Kodi sizinakukwanireni kuti Mulungu wa Israeli anakupatulani pakati pa gulu lonse la Aisraeli ndi kukubweretsani pafupi ndi Iye, kuti muzigwira ntchito ku nyumba ya Yehova ndi kumayima pamaso pa gulu, kumatumikira? ");
INSERT INTO nya_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Wakubweretsa iwe pamodzi ndi Alevi anzako kufupi ndi Iye mwini. Koma tsopano ukufuna kutenganso unsembe. ");
INSERT INTO nya_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Nʼkulakwira Yehova kuti iwe ndi gulu lako lonseli mwasonkhana kuti mutsutsane ndi Yehova. Kodi Aaroni ndani kuti muzikangana naye?” ");
INSERT INTO nya_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Kenaka Mose anayitana Datani ndi Abiramu, ana aamuna a Eliabu koma iwo anati, “Sitibwera! ");
INSERT INTO nya_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Kodi sikukwanira kuti unatitulutsa, kutichotsa mʼdziko loyenda mkaka ndi uchi kuti udzatiphe mʼchipululu muno? Kodi tsopano ukufunanso kutilemetsa? ");
INSERT INTO nya_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Kuwonjezera apo, sunatilowetse mʼdziko loyenda mkaka ndi uchi kapena kutipatsa malo wolima ndi minda ya mpesa. Kodi ukufuna kuchotsa maso a anthuwa? Ayi, sitibwera!” ");
INSERT INTO nya_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Pamenepo Mose anakwiya kwambiri ndipo anati kwa Yehova, “Musalandire chopereka chawo. Sindinatenge kalikonse kwa iwo ngakhale bulu, ndiponso sindinalakwire wina aliyense wa iwo.” ");
INSERT INTO nya_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Mose anati kwa Kora, “Iwe ndi okutsatira onse mudzaonekere pamaso pa Yehova mawa, iweyo ndi iwowo pamodzi ndi Aaroni. ");
INSERT INTO nya_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Munthu aliyense akatenge chofukizira ndi kuyikamo lubani, zofukizira 250 zonse pamodzi ndi kuzibweretsa pamaso pa Yehova. Iwe ndi Aaroni mudzabweretsenso zofukizira zanu.” ");
INSERT INTO nya_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Choncho munthu aliyense anatenga chofukizira chake nayikamo moto ndi lubani, ndipo anayima pamodzi ndi Mose ndi Aaroni pa khomo la tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kora atasonkhanitsa omutsatira ake onse amene amatsutsa nawo pa khomo la tenti ya msonkhano, ulemerero wa Yehova unaonekera kwa gulu lonselo. ");
INSERT INTO nya_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Yehova anawuza Mose ndi Aaroni kuti, ");
INSERT INTO nya_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Chokani pakati pa gulu ili kuti ndithetse mkanganowu kamodzinʼkamodzi.” ");
INSERT INTO nya_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Koma Mose ndi Aaroni anadzigwetsa chafufumimba ndipo analira mokweza, “Chonde Mulungu, Mulungu wa mizimu ya anthu onse, kodi mudzakwiyira gulu lonse pamene munthu mmodzi yekha ndiye amene wachimwa?” ");
INSERT INTO nya_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Pamenepo Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Uza gulu lonse kuti, ‘Khalani kutali ndi matenti a Kora, Datani ndi Abiramu.’ ” ");
INSERT INTO nya_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mose anayimirira napita kwa Datani, Abiramu ndi kwa akuluakulu a Israeli amene ankamutsatira. ");
INSERT INTO nya_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Anachenjeza gulu lonse kuti, “Khalani kutali ndi matenti a anthu oyipawa! Musakhudze kanthu kawo kalikonse, mukatero mudzawonongedwa limodzi nawo chifukwa cha machimo awo.” ");
INSERT INTO nya_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Choncho anthuwo anachokadi ku matenti a Kora, Datani ndi Abiramu. Datani ndi Abiramu anali atatuluka nayima pamodzi ndi akazi awo, ana awo ndi makanda awo pa makomo a matenti awo. ");
INSERT INTO nya_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Tsono Mose anati, “Umu ndi mmene mudzadziwire kuti Yehova ndiye amene anandituma kuti ndichite zinthu zonsezi ndipo kuti si maganizo anga. ");
INSERT INTO nya_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ngati anthu awa afa ndi imfa ya chilengedwe ndi kuwachitikira zomwe zimachitikira munthu aliyense, ndiye kuti Yehova sananditume. ");
INSERT INTO nya_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Koma Yehova akachita china chake chachilendo, nthaka nitsekula pakamwa pake ndi kuwameza iwo pamodzi ndi zonse zimene ali nazo, iwowa nʼkulowa mʼmanda ali moyo, pamenepo mudzazindikira kuti anthu amenewa ananyoza Yehova.” ");
INSERT INTO nya_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Atangotsiriza kuyankhula zimenezi, nthaka ya pamene anayimapo inagawikana ");
INSERT INTO nya_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ndipo dziko linatsekula pakamwa pake ndi kuwameza pamodzi ndi nyumba zawo ndi anthu onse a Kora ndi katundu wawo yense. ");
INSERT INTO nya_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Analowa mʼmanda amoyo pamodzi ndi zonse zimene anali nazo. Nthaka inawatsekera ndi kuwawononga ndipo sanaonekenso. ");
INSERT INTO nya_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Atamva kulira kwawo, Aisraeli onse amene anali pafupi ndi anthuwo anathawa akufuwula kuti, “Nthaka imezanso ife!” ");
INSERT INTO nya_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Ndipo moto wochokera kwa Yehova unabwera nʼkunyeketsa anthu 250 amene ankapereka nsembe yofukiza aja. ");
INSERT INTO nya_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Uza Eliezara mwana wa Aaroni, wansembe kuti atenge zofukizirazo pakati pa mitembo yopsererayo ndipo amwazire makalawo kutali chifukwa zofukizirazo nʼzopatulika. ");
INSERT INTO nya_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Izi ndi zofukizira za anthu omwe anafa chifukwa cha uchimo wawo. Musule zofukizirazo kuti zikhale zophimbira pa guwa lansembe, chifukwa zinaperekedwa kwa Yehova ndipo ndi zopatulika. Zimenezi zikhale chizindikiro kwa Aisraeli.” ");
INSERT INTO nya_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Choncho Eliezara, wansembe, anasonkhanitsa zofukizira zamkuwa zija zomwe anthu opsererawo anabwera nazo ndipo anazisula kuti zikhale zophimbira pa guwa lansembe, ");
INSERT INTO nya_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","monga momwe Yehova anamulangizira kudzera mwa Mose. Chimenechi chinali chikumbutso kwa Aisraeli kuti munthu wina aliyense, kupatula zidzukulu za Aaroni, sayenera kupsereza lubani pamaso pa Yehova, kuopa kuti munthu woteroyo angakhale ngati Kora ndi omutsatira ake. ");
INSERT INTO nya_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Tsiku lotsatira, gulu lonse la Aisraeli linatsutsana ndi Mose ndi Aaroni. Iwo anati, “Inu mwapha anthu a Yehova.” ");
INSERT INTO nya_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Koma pamene anthuwo anasonkhana kuti atsutsane ndi Mose ndi Aaroni, atatembenuka kuyangʼana ku tenti ya msonkhano, mwadzidzidzi mtambo unaphimba tentiyo ndipo ulemerero wa Yehova unaonekera. ");
INSERT INTO nya_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Pamenepo Mose ndi Aaroni anapita patsogolo pa tenti ya msonkhano ija ");
INSERT INTO nya_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","ndipo Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Chokani pakati pa gulu la anthuwa kuti ndiwawononge kamodzinʼkamodzi.” Ndipo iwo anagwa pansi chafufumimba. ");
INSERT INTO nya_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Kenaka Mose anawuza Aaroni kuti, “Tenga chofukizira chako ndipo ikamo lubani pamodzi ndi moto wochokera pa guwa lansembe, fulumira, pita pa gulu la anthuwo ndipo ukachite nsembe yopepesera machimo awo popeza mkwiyo wa Yehova wafika, mliri wayamba.” ");
INSERT INTO nya_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Ndipo Aaroni anachita monga ananenera Mose, nathamangira mʼkatikati mwa gulu la anthuwo. Pamenepo nʼkuti mliri utayamba kale pakati pa anthu aja ndipo Aaroni anafukiza lubani ndi kupereka nsembe yopepesera machimo awo. ");
INSERT INTO nya_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Iye anayimirira pakati pa anthu amoyo ndi akufa ndipo mliri unaleka. ");
INSERT INTO nya_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Komabe anthu 14, 700 anafa ndi mliriwo, kuwonjezera pa aja amene anafa chifukwa cha Kora. ");
INSERT INTO nya_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Ndipo Aaroni anabwerera kwa Mose ku khomo la tenti ya msonkhano, chifukwa mliriwo unali utatha. ");
INSERT INTO nya_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Yankhula ndi Aisraeli ndipo akupatse ndodo khumi ndi ziwiri, imodzi kuchokera kwa mtsogoleri wa fuko lililonse. Ulembe dzina la munthu aliyense pa ndodo yake. ");
INSERT INTO nya_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Pa ndodo ya Levi ulembepo dzina la Aaroni, chifukwa pafunika ndodo imodzi ya mtsogoleri pa fuko lililonse. ");
INSERT INTO nya_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Uyike ndodozo mu tenti ya msonkhano, kutsogolo kwa Bokosi la Umboni, kumene ndimakumana nawe. ");
INSERT INTO nya_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Ndodo ya munthu amene ndamusankha idzachita maluwa potero ndidzaletsa madandawulo osatha a Aisraeli otsutsana nawe.” ");
INSERT INTO nya_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Choncho Mose anayankhula ndi Aisraeli, ndipo atsogoleri awo anapereka ndodo khumi ndi ziwiri, imodzi kuchokera kwa mtsogoleri wa fuko lililonse ndipo ndodo ya Aaroni inali pakati pa ndodo zawozo. ");
INSERT INTO nya_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Mose anayika ndodozo pamaso pa Yehova mu tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Pa tsiku lotsatira Mose analowa mu tenti ya msonkhanoyo ndipo anaona kuti ndodo ya Aaroni, yomwe inkayimira fuko la Levi, sinangophuka masamba chabe, komanso inachita maluwa nʼkubala zipatso za alimondi. ");
INSERT INTO nya_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Choncho Mose anatulutsa ndodo zonse pamaso pa Yehova napita nazo kwa Aisraeli onse. Iwowo anaziona ndipo munthu aliyense anatenga ndodo yake. ");
INSERT INTO nya_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Yehova anawuza Mose kuti, “Bwezera ndodo ya Aaroni patsogolo pa Bokosi la Umboni, kuti chikhale chizindikiro cha kuwukira kwawo. Zimenezi zidzathetsa kudandaula kwawo kotsutsana nane, kuopa kuti angafe.” ");
INSERT INTO nya_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Mose anachita monga Yehova anamulamulira. ");
INSERT INTO nya_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Aisraeli anati kwa Mose, “Tikufa! Tatayika, tonse tatayika! ");
INSERT INTO nya_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Aliyense woyandikira chihema adzafa. Kodi ndiye kuti tonse tikufa?” ");
INSERT INTO nya_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Yehova anawuza Aaroni kuti, “Iwe, ana ako aamuna ndi banja la abambo ako mudzasenza tchimo la malo wopatulika, koma iwe ndi ana ako aamuna okha mudzasenza tchimo lokhudza unsembe wanu. ");
INSERT INTO nya_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Ubweretse Alevi, abale ako, kuchokera ku fuko la abambo ako kuti azikhala ndi iwe ndi kumakuthandiza pamodzi ndi ana ako amuna pamene mukutumikira mu tenti ya umboni. ");
INSERT INTO nya_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Iwowo azikutumikirani ndipo azichita ntchito zonse za ku tenti, koma asamafike pafupi ndi zipangizo za ku malo opatulika kapena guwa lansembe, kuopa kuti iwo ndi inu mungafe. ");
INSERT INTO nya_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Azikhala ndi inu ndipo azisamalira ntchito yonse ya mu tenti ya msonkhano koma munthu wina aliyense wapadera sayenera kufika pafupi nanu. ");
INSERT INTO nya_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Inuyo muzisamalira malo wopatulika ndi guwa lansembe, kuti ukali wa Yehova usawagwerenso Aisraeli. ");
INSERT INTO nya_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ine mwini ndasankha Alevi, abale ako, pakati pa Aisraeli ngati mphatso yako ndipo aperekedwa kwa Yehova kuti azigwira ntchito ku tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Koma iwe wekha ndi ana ako aamuna muzitumikira ngati ansembe ndi zina zonse zokhudza pa guwa lansembe ndi za mʼkati mwa malo wopatulika kwambiri. Ndikukupatsani mphatso ya utumiki wa unsembe. Aliyense woyandikira malo wopatulika ayenera kuphedwa. ");
INSERT INTO nya_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","“Kenaka Yehova anati kwa Aaroni, ona, Ine mwini ndikukuyika kuti ukhale woyangʼanira zopereka zobwera kwa Ine; zopereka zonse zopatulika za Aisraeli zimene amapereka kwa ine ndi kuzipereka kwa iwe ndi ana ako aamuna ngati gawo lanu la nthawi zonse. ");
INSERT INTO nya_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Uzilandiranso gawo la zopereka zopatulika kwambiri zomwe sizinawotchedwe pa moto. Kuchokera pa mphatso zonse zimene amabweretsa kwa Ine ngati zopatulika kwambiri, nsembe zachakudya kapena nsembe zopepesera machimo, gawo limenelo ndi lako ndi ana ako aamuna. ");
INSERT INTO nya_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Muzidya zimenezo ngati zinthu zopatulika kwambiri; mwamuna aliyense adyeko. Uzitenge kukhala zopatulika. ");
INSERT INTO nya_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Izinso ndi zako: chilichonse chopatulidwa kuchokera ku mphatso zoweyula za Aisraeli ndapereka kwa iwe ndi ana ako aamuna ndi aakazi ngati gawo lako la nthawi zonse. Aliyense wa mʼnyumba mwako amene ali woyeretsedwa monga mwa mwambo angathe kudyako. ");
INSERT INTO nya_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Ndikukupatsani mafuta onse abwino kwambiri a olivi ndi vinyo yense watsopano wabwino kwambiri ndi tirigu yense zomwe Aisraeli amapereka kwa Yehova ngati zipatso zoyamba pa zokolola zawo. ");
INSERT INTO nya_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Zipatso zonse zoyamba kucha za mʼdziko lawo zomwe amapereka kwa Yehova zidzakhala zako. Aliyense mʼnyumba mwako amene ali woyeretsedwa angathe kudyako. ");
INSERT INTO nya_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Chilichonse mu Israeli chomwe chapatulidwira Yehova ndi chako. ");
INSERT INTO nya_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Chilichonse choyamba kubadwa kwa munthu kaya nyama, chomwe chaperekedwa kwa Yehova ndi chako. Koma uyenera kuwombola mwana aliyense wamwamuna ndi mwana aliyense woyamba wa nyama zodetsedwa. ");
INSERT INTO nya_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Pamene zili ndi mwezi umodzi wa kubadwa, uziwombole pa mtengo wowombolera wa ndalama zisanu zasiliva, monga mwa ndalama za ku malo wopatulika. ");
INSERT INTO nya_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Koma usawombole ana oyamba kubadwa a ngʼombe, nkhosa kapena mbuzi. Iwo ndi opatulika. Uwaze magazi a nyamazi pa guwa lansembe ndi kutentha mafuta ake ngati nsembe yotentha ndi moto kuti likhale fungo lokoma kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Nyama yake ikhale yanu monga momwe chimakhalira chidale cha nsembe yoweyula ndi ntchafu za miyendo ya kumanja, zonsezi ndi zako. ");
INSERT INTO nya_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Zonse zimene mwazichotsa ku zopereka zoyera zomwe Aisraeli anapereka kwa Yehova ndazipereka kwa iwe ndi ana ako aamuna ndi aakazi ngati gawo lanu nthawi zonse. Ili ndi pangano losatha la mchere pamaso pa Yehova kwa iwe ndi ana ako.” ");
INSERT INTO nya_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Ndipo Yehova anati kwa Aaroni, “Iweyo sudzakhala ndi cholowa mʼdziko lawo, ndiponso sudzalandira gawo lililonse pakati pawo. Ine ndine gawo lako ndi cholowa chako pakati pa Aisraeli. ");
INSERT INTO nya_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Taonani, ndawapatsa Alevi chakhumi chonse mu Israeli ngati cholowa chawo chifukwa cha ntchito ya ku tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Kuyambira tsopano mpaka mʼtsogolo Aisraeli asamapite pafupi ndi tenti ya msonkhano. Ngati atero adzasenza zotsatira za tchimo lawo ndipo adzafa. ");
INSERT INTO nya_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Alevi ndi amene azidzagwira ntchito ya ku tenti ya msonkhano ndipo adzalangidwa chilichonse chikalakwika. Ili ndi lamulo losatha kwa mibado yawo yonse. Iwowo sadzalandira cholowa pakati pa Aisraeli. ");
INSERT INTO nya_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Mʼmalo mwake, ndikuwapatsa Aleviwo chakhumi ngati cholowa chawo chimene Aisraeli amapereka kwa Yehova. Nʼchifukwa chake zokhudza iwo ndinati: ‘Sadzakhala ndi cholowa pakati pa Aisraeli.’ ” ");
INSERT INTO nya_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Yehova anati kwa Mose, ");
INSERT INTO nya_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Yankhula ndi Alevi ndi kunena nawo kuti, ‘Pamene mulandira chakhumi kuchoka kwa Aisraeli chimene ndimakupatsani ngati cholowa chanu, muyenera kupereka chakhumi cha choperekacho kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Chopereka chanucho chidzawerengedwa kwa inu ngati tirigu wochokera kopunthira kapena ngati mphesa zopsinya kuchokera kopsinyira mphesa. ");
INSERT INTO nya_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Mwa njira imeneyi inunso muzipereka chopereka kwa Yehova kuchokera ku chakhumi chanu chilichonse chimene mumalandira kuchokera kwa Aisraeli. Kuchokera ku chakhumicho muziperekako gawo la Yehova kwa Aaroni, wansembe. ");
INSERT INTO nya_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Muyenera kupereka monga gawo la Yehova magawo abwino kwambiri ndi opatulika a chilichonse chimene chapatsidwa kwa inu.’ ");
INSERT INTO nya_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Nena kwa Alevi: ‘Pamene mupereka gawo labwino lopambana zonse, gawo limenelo lidzawerengedwa kwa inu ngati lochokera popunthira tirigu kapenanso kopsinyira mphesa. ");
INSERT INTO nya_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Inu ndi a pa banja panu mungathe kudyera zimenezi paliponse chifukwa ndi malipiro a ntchito yanu ya ku tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Popereka gawo labwino kwambirilo simudzapezeka olakwa. Mukatero simudzadetsa zopereka zoyera za Aisraeli, ndipo simudzafa.’ ” ");
INSERT INTO nya_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Yehova anati kwa Mose ndi Aaroni: ");
INSERT INTO nya_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Lamulo limene Yehova wapereka ndi ili: Uzani Aisraeli kuti abweretse ngʼombe yayikazi yofiira yopanda chilema chilichonse imenenso sinakhalepo pa goli. ");
INSERT INTO nya_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Muyipereke kwa Eliezara, wansembe ndipo apite nayo kunja kwa msasa. Iphedwe iye ali pomwepo. ");
INSERT INTO nya_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Ndipo Eliezara wansembe atengeko ena mwa magazi a ngʼombeyo ndi chala chake ndi kuwaza kasanu nʼkawiri ku tsogolo kwa tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Wansembeyo akuona, ngʼombeyo ayiwotche ­­chikopa chake, mnofu wake, magazi ake ndi zamʼkati zake. ");
INSERT INTO nya_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Wansembe atenge mtengo wamkungudza, hisope ndi kansalu kofiira ndipo aponye zimenezo pakati pa moto umene akuwotchera ngʼombeyo. ");
INSERT INTO nya_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Zitatha izi, wansembeyo ayenera kuchapa zovala zake ndiponso asambe ndi madzi. Iye angathe kupita ku msasa, komabe adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Munthu amene amawotcha ngʼombeyo ayeneranso kuchapa zovala zake ndi kusamba ndi madzi. Iyenso adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Munthu amene ndi woyeretsedwa achotse phulusa la ngʼombeyo ndi kuliyika pa malo woyeretsedwa kunja kwa msasa. Aisraeli adzasunge phulusalo kuti azikaligwiritsa ntchito polithira mʼmadzi woyeretsera ndi wochotsera tchimo. ");
INSERT INTO nya_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Munthu wochotsa phulusa la ngʼombeyo ayeneranso kuchapa zovala zake. Iyenso adzakhala wodetsedwa mpaka madzulo. Ili likhale lamulo la nthawi zonse kwa Aisraeli ndi alendo okhala pakati pawo. ");
INSERT INTO nya_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Aliyense wokhudza mtembo wa munthu wina aliyense adzakhala wodetsedwa masiku asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Adziyeretse yekha ndi madzi pa tsiku lachitatu ndi pa tsiku lachisanu ndi chiwiri ndipo adzayeretsedwa. Koma ngati sadziyeretsa yekha pa tsiku la chitatu ndi lachisanu ndi chiwiri sadzakhala woyeretsedwa. ");
INSERT INTO nya_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Aliyense amene akhudza mtembo wa munthu nʼkulephera kudziyeretsa yekha, ndiye kuti wadetsa Nyumba ya Yehova. Munthu ameneyo achotsedwe pakati pa Aisraeli. Iye ndi wodetsedwa chifukwa sanamuwaze madzi oyeretsa; kudetsedwa kwake kukhalabe pa iyeyo. ");
INSERT INTO nya_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Pamene munthu wamwalira mu tenti, lamulo lomwe ligwire ntchito ndi ili: Aliyense wolowa mu tentimo ndi amene anali momwemo adzakhala odetsedwa kwa masiku asanu ndi awiri, ");
INSERT INTO nya_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","ndiponso chiwiya chilichonse chopanda chivundikiro chidzakhala chodetsedwa. ");
INSERT INTO nya_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Aliyense wokhudza munthu amene waphedwera kunja ndi lupanga kapena amene wafa ndi imfa ya chilengedwe, kapena aliyense wokhudza fupa la munthu kapena manda, munthu ameneyo adzakhala wodetsedwa kwa masiku asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Za munthu wodetsedwayo: ikani phulusa lochokera ku nsembe ya chiyeretso mu mtsuko ndi kuthiramo madzi abwino. ");
INSERT INTO nya_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Tsono munthu woyeretsedwa atenge hisope, amuviyike mʼmadzi ndi kuwaza tentiyo ndi zipangizo zonse, pamodzi ndi anthu anali mʼmenemo. Ayenera kuwazanso aliyense wakhudza fupa kapena, munthu wochita kuphedwa, kapena amene wafa ndi imfa ya chilengedwe kapenanso amene wakhudza manda. ");
INSERT INTO nya_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Munthu woyeretsedwa ndiye awaze munthu wodetsedwayo pa tsiku lachitatu ndi pa tsiku lachisanu ndi chiwiri, ndipo pa tsiku lachisanu ndi chiwiri amuyeretse. Munthu amene akuyeretsedwayo ayenera kuchapa zovala zake ndi kusamba ndi madzi, ndipo madzulo ake adzakhala woyeretsedwa. ");
INSERT INTO nya_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Koma ngati munthu wodetsedwayo sadziyeretsa yekha, ndiye kuti ayenera kuchotsedwa pakati pa gulu chifukwa anadetsa malo wopatulika a Yehova, popeza sanawazidwe madzi oyeretsa ndiye kuti ndi wodetsedwa. ");
INSERT INTO nya_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Ili ndi lamulo lokhazikika kwa iwo. “Munthu amene amawaza madzi oyeretsawo ayenera kuchapa zovala zake ndipo yense wokhudza madzi oyeretserawo adzakhala wodetsedwa mpaka madzulo. ");
INSERT INTO nya_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Chilichonse chimene munthu wodetsedwayo achikhudze chidzakhala chodetsedwa ndiponso aliyense wochikhudza adzakhala wodetsedwa mpaka madzulo.” ");
INSERT INTO nya_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Pa mwezi woyamba gulu lonse la Aisraeli linafika ku chipululu cha Zini, ndipo anakhala ku Kadesi. Miriamu anafera kumeneko ndipo anayikidwa mʼmanda. ");
INSERT INTO nya_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Kunalibe madzi woti anthu onse ndi kumwa, choncho anthuwo anasonkhana motsutsana ndi Mose ndi Aaroni. ");
INSERT INTO nya_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Anakangana ndi Mose kuti, “Kunali bwino ifenso tikanangofa pamene abale athu anafa pamaso pa Yehova! ");
INSERT INTO nya_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Chifukwa chiyani unabweretsa gulu la Yehova mʼchipululu muno, kuti ife ndi ziweto zathu tife kuno? ");
INSERT INTO nya_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Nʼchifukwa chiyani unatitulutsa mʼdziko la Igupto ndi kutibweretsa kumalo woyipa ano? Kuno kulibe tirigu kapena nkhuyu, mphesa kapena makangadza. Ndipo kuno kulibenso madzi akumwa!” ");
INSERT INTO nya_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mose ndi Aaroni anachoka mu msonkhano ndi kupita pa khomo la tenti ya msonkhano, nagwa pansi chafufumimba ndipo ulemerero wa Yehova unaonekera. ");
INSERT INTO nya_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Yehova anati kwa Mose, ");
INSERT INTO nya_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Tenga ndodo, ndipo iwe ndi mʼbale wako Aaroni musonkhanitse anthu onse pamodzi. Uyankhule ndi thanthwe ilo iwo akuona ndipo lidzatulutsa madzi ake. Udzatulutsa madzi mʼthanthwe limeneli kuti anthu onse ndi ziweto zawo amwe.” ");
INSERT INTO nya_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Choncho Mose anatenga ndodo pamaso pa Yehova monga momwe anamulamulira. ");
INSERT INTO nya_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Mose ndi Aaroni anasonkhanitsa anthuwo pamodzi ku thanthwelo ndipo Mose anawawuza kuti, “Tamverani osamvera inu, kodi tikupatseni madzi kuchokera ku thanthwe ili?” ");
INSERT INTO nya_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Choncho Mose anatukula dzanja lake ndi kumenya thanthwelo kawiri ndi ndodo yake ndipo madzi ambiri anatuluka mwamphamvu, ndipo anthu ndi ziweto zawo anamwa. ");
INSERT INTO nya_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Koma Yehova anati kwa Mose ndi Aaroni, “Chifukwa chakuti simunandikhulupirire ndiponso simunandilemekeze monga Woyera pamaso pa Aisraeli, simudzalowetsa anthuwa mʼdziko limene ndikupereka kwa iwo.” ");
INSERT INTO nya_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Awa anali madzi a ku Meriba, kumene Aisraeli anakangana ndi Yehova ndiponso kumene Yehovayo anadzionetsa yekha kuti ndi Woyera pakati pawo. ");
INSERT INTO nya_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Mose anatumiza amithenga kuchokera ku Kadesi kupita kwa mfumu ya ku Edomu, kukanena kuti, “Mʼbale wako Israeli akunena izi: Inuyo mukudziwa za mavuto onse amene anatigwera. ");
INSERT INTO nya_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Makolo athu anapita ku Igupto ndipo tinakhala kumeneko zaka zambiri. Aigupto anatizunza pamodzi ndi makolo athuwo, ");
INSERT INTO nya_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","koma titalirira Yehova, Iyeyo anamva kulira kwathuko ndipo anatitumizira mngelo amene anatitulutsa ku Igupto.” “Taonani, tsopano tili pano pa Kadesi, mzinda wa mʼmalire a dziko lanu. ");
INSERT INTO nya_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Chonde mutilole tidutse mʼdziko lanu. Sitidzera mʼminda yanu kapena mu mpesa wanu, kapenanso kumwa madzi mʼchitsime chilichonse. Tidzayenda kutsata msewu waukulu wa mfumu ndipo sitidzapatukira ku dzanja lamanja kapena lamanzere mpaka titadutsa malire a dziko lanu.” ");
INSERT INTO nya_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Koma Edomu anayankha kuti, “Musadutse kuno: Mukangoyesera tidzabwera ndi kumenyana nanu ndi lupanga.” ");
INSERT INTO nya_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Aisraeli anayankha kuti, “Tidzayenda motsata msewu waukulu. Ndipo ngati ife kapena ziweto zathu tidzamwa madzi anu tidzalipira. Tikungofuna tidutse nawo, palibenso china.” ");
INSERT INTO nya_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Koma Edomu anayankhanso kuti, “Musadutse.” Kenaka Edomu anatuluka ndi gulu lankhondo lalikulu komanso lamphamvu. ");
INSERT INTO nya_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Edomu anakaniza Israeli kuti adutse mʼdziko lake, choncho Israeli anabwerera. ");
INSERT INTO nya_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Gulu lonse la Aisraeli linachoka ku Kadesi ndipo linafika ku phiri la Hori. ");
INSERT INTO nya_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Ali pa phiri la Hori, pafupi ndi malire a Edomu, Yehova anati kwa Mose ndi Aaroni, ");
INSERT INTO nya_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aaroni adzakakhala ndi anthu a mtundu wake, sadzalowa mʼdziko limene ndapereka kwa Aisraeli, chifukwa nonse munandiwukira motsutsana ndi malamulo anga ku madzi a ku Meriba. ");
INSERT INTO nya_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Tenga Aaroni ndi mwana wake wamwamuna Eliezara ndipo ukwere nawo ku phiri la Hori. ");
INSERT INTO nya_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Uvule Aaroni zovala zake ndipo umuveke mwana wake Eliezara, pakuti Aaroni adzafera komweko, ndipo adzakakhala ndi anthu a mtundu wake.” ");
INSERT INTO nya_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Mose anachita monga Yehova anamulamulira: Anapita ku phiri la Hori gulu lonse likuona. ");
INSERT INTO nya_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Pamenepo Mose anavula Aaroni zovala zake ndi kuveka mwana wake Eliezara. Aaroni anafa kumeneko pamwamba pa phirilo. Koma Mose ndi Eliezara anatsika ku phiriko, ");
INSERT INTO nya_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","ndipo pamene anthu onse anamva kuti Aaroni wafa, nyumba yonse ya Israeli inamulira Aaroniyo masiku makumi atatu. ");
INSERT INTO nya_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Mfumu ya Akanaani ya ku Aradi, imene inkakhala ku Negevi, itamva kuti Aisraeli akubwera kudzera msewu wopita ku Atarimu, inachita nkhondo ndi Aisraeli nigwira ena mwa iwo. ");
INSERT INTO nya_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Ndipo Israeli anachita lonjezo ili kwa Yehova: “Mukapereka anthu awa mʼdzanja lathu ife tidzawonongeratu mizinda yawo.” ");
INSERT INTO nya_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Yehova anamva pempho la Aisraeli ndipo anapereka Akanaaniwo kwa iwo. Anawawononga pamodzi ndi mizinda yawo. Kotero malowo anatchedwa Horima. ");
INSERT INTO nya_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Aisraeli anayenda kuchokera ku phiri la Hori kudzera njira ya ku Nyanja Yofiira kuzungulira dziko la Edomu. Koma anthu anataya mtima mʼnjiramo ");
INSERT INTO nya_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ndipo anayankhula motsutsana ndi Mulungu ndi Mose, nati, “Chifukwa chiyani munatitulutsa kuchoka mʼdziko la Igupto kuti tidzafere mʼchipululu muno? Kuno kulibe chakudya, kulibe madzi ndipo chakudya cha chabechabechi tatopa nacho.” ");
INSERT INTO nya_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Choncho Yehova anatumiza njoka zaululu pakati pawo. Zinaluma anthu ndipo Aisraeli ambiri anafa. ");
INSERT INTO nya_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Anthuwo anabwera kwa Mose ndi kunena kuti, “Tachimwa chifukwa tayankhula motsutsana ndi Yehova komanso inu. Pempherani kwa Yehova kuti atichotsere njokazi.” Tsono Mose anapempherera anthuwo. ");
INSERT INTO nya_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Yehova anati kwa Mose, “Upange njoka yaululu ndipo uyipachike pa mtengo. Aliyense amene walumidwa akangoyangʼana njokayo adzakhala ndi moyo.” ");
INSERT INTO nya_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Pamenepo Mose anapanga njoka yamkuwa ndi kuyipachika pa mtengo. Ndipo aliyense wolumidwa akayangʼana njoka yamkuwayo ankakhala ndi moyo. ");
INSERT INTO nya_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Aisraeli anayendabe nakamanga misasa yawo ku Oboti. ");
INSERT INTO nya_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Kenaka anasamuka ku Oboti nakamanga misasa yawo ku Iye-Abarimu, mʼchipululu chimene chili kummawa kwa Mowabu, kotulukira dzuwa. ");
INSERT INTO nya_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Kuchoka kumeneko anayendabe nakamanga misasa yawo mʼchigwa cha Zeredi. ");
INSERT INTO nya_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Anasamukanso kumeneko nakamanga moyandikana ndi Arinoni mʼdera limene lili mʼchipululu chimene chimafika mʼdziko la Aamori. Arinoni ndiwo malire a Mowabu ndi Aamori. ");
INSERT INTO nya_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Nʼchifukwa chake Buku la Nkhondo za Yehova limati, “Mzinda wa Wahebu uli mu Sufa, mu zigwa za Arinoni, ");
INSERT INTO nya_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ku matsitso a zigwa amene afika mpaka ku Ari nakhudza malire a dziko la Mowabu.” ");
INSERT INTO nya_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Kuchokera kumeneko anapitirira mpaka ku Beeri, pa chitsime chomwe Yehova anawuza Mose kuti, “Sonkhanitsa anthu pamodzi ndipo ndidzawapatsa madzi.” ");
INSERT INTO nya_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Pamenepo Aisraeli anayimba nyimbo iyi: “Tulutsa madzi, chitsime iwe! Chiyimbireni nyimbo, ");
INSERT INTO nya_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","chitsime chomwe anakumba mafumu, chomwe anakumba anthu omveka, ndi ndodo zawo zaufumu ndi ndodo zawo zoyendera.” Kenaka anachoka ku chipululu ndi kupita ku Matana. ");
INSERT INTO nya_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Kuchoka ku Matana anapita ku Nahalieli, kuchoka ku Nahalieli anapita ku Bamoti, ");
INSERT INTO nya_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ndipo atachoka ku Bamoti anapita ku chigwa cha dziko la Mowabu kudzera njira ya pamwamba pa phiri la Pisiga, moyangʼanana ndi Yesimoni. ");
INSERT INTO nya_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Aisraeli anatumiza amithenga kwa Sihoni mfumu ya Aamori, kuti, ");
INSERT INTO nya_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Tiloleni kuti tidutse mʼdziko mwanu. Sitidzapatukira mʼminda mwanu kapena mu mpesa wanu kapena kumwa madzi mʼchitsime chili chonse. Tidzayenda mu msewu waukulu wa mfumu mpaka titadutsa malire a dziko lanu.” ");
INSERT INTO nya_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Koma Sihoni sanalole kuti Aisraeli adutse mʼdziko mwake. Iye anasonkhanitsa pamodzi ankhondo ake onse kuti akamenyane ndi Aisraeli mʼchipululu. Atafika pa Yahazi anamenyana ndi Aisraeli. ");
INSERT INTO nya_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Koma Aisraeli anamupha ndi kulanda dziko lake kuchokera ku Arinoni mpaka ku Yaboki, kulekezera mʼmalire a dziko la Aamoni, chifukwa malire a dziko la Aamoni anali otetezedwa. ");
INSERT INTO nya_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Ndipo Aisraeli analanda mizinda yonse ya Aamori, nakhalamo kuphatikizapo Hesiboni ndi midzi yake yozungulira. ");
INSERT INTO nya_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hesiboni unali mzinda wa Sihoni mfumu ya Aamori, yemwe anamenyana ndi mfumu yakale ya dziko la Mowabu. Lonselo linakhala dziko lake mpaka ku Arinoni. ");
INSERT INTO nya_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Nʼchifukwa chake alakatuli amati: “Bwerani ku Hesiboni, mzindawo umangidwenso; mzinda wa Sihoni ukhazikike. ");
INSERT INTO nya_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“Moto unabuka ku Hesiboni, malawi a moto kuchokera mu mzinda wa Sihoni. Unanyeketsa Ari mzinda wa ku Mowabu, nzika za ku malo okwera a Arinoni. ");
INSERT INTO nya_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Tsoka kwa iwe Mowabu! Mwawonongedwa inu anthu a ku Kemosi! Ana ake aamuna wawasandutsa ngati anthu othawathawa ndipo ana ake aakazi ngati akapolo, akapolo a Sihoni, mfumu ya Aamori. ");
INSERT INTO nya_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“Koma ife tawagonjetsa; Hesiboni wawonongedwa mʼnjira monse mpaka kufika ku Diboni. Tawaphwasula mpaka ku mzinda wa Nofa, mzinda womwe umafika ku Medeba. ");
INSERT INTO nya_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","“Choncho Aisraeli anakhala mʼdziko la Aamori.” ");
INSERT INTO nya_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Mose atatumiza azondi ku Yazeri, Aisraeliwo analanda midzi yozungulira ndi kuthamangitsa Aamori omwe ankakhala kumeneko. ");
INSERT INTO nya_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Kenaka anabwerera, nadzera njira ya ku Basani. Choncho Ogi mfumu ya ku Basani ndi gulu lake lonse lankhondo anatuluka kukakumana nawo ndipo anamenyana nawo ku Ederi. ");
INSERT INTO nya_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Yehova anati kwa Mose, “Usachite naye mantha pakuti ndamupereka mʼmanja mwako pamodzi ndi gulu lake lonse lankhondo ndi dziko lake lomwe. Ndipo uchite kwa iye zimene unachita Sihoni mfumu ya Aamori, amene ankalamulira ku Hesiboni.” ");
INSERT INTO nya_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Choncho Aisraeli anapha Ogi pamodzi ndi ana ake aamuna ndi gulu lake lonse la nkhondo. Palibe ndi mmodzi yemwe amene anatsala wamoyo, ndipo analanda dziko lakelo. ");
INSERT INTO nya_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Aisraeli anayenda kupita ku zigwa za Mowabu nakamanga misasa yawo tsidya lina la Yorodani moyangʼanana ndi Yeriko. ");
INSERT INTO nya_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Tsono Balaki mwana wa Zipori anaona zonse zimene Aisraeli anachitira Aamori, ");
INSERT INTO nya_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ndipo Amowabu anaopa anthuwo chifukwa analipo ambiri. Amowabuwo anachita mantha kwambiri mpaka ananjenjemera chifukwa cha Aisraeli. ");
INSERT INTO nya_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Iwo anati kwa akuluakulu a ku Midiyani, “Gulu ili lidzabudula zonse zimene zatizungulira monga momwe ngʼombe yothena imathera udzu wa ku tchire.” Tsono Balaki mwana wa Zipori, yemwe anali mfumu ya Mowabu pa nthawi imeneyo, ");
INSERT INTO nya_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","anatumiza amithenga kwa Balaamu mwana wa Beori, yemwe anali ku Petori, pafupi ndi mtsinje, mʼdziko la kwawo kuti akamuyitane. Balaki anati: “Taonani, anthu ochokera ku Igupto abwera, adzaza dziko lonse ndipo akufuna kuchita nane nkhondo. ");
INSERT INTO nya_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Tsopano bwera, utemberere anthu amenewa chifukwa ndi amphamvu kwambiri kuposa ine. Mwina ndingadzawagonjetse ndi kuwatulutsira kunja kwa dzikoli chifukwa ndikudziwa kuti amene umawadalitsa amadalitsika, ndipo amene umawatemberera amatembereredwa.” ");
INSERT INTO nya_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Akuluakulu a Mowabu ndi akuluakulu a Midiyani ananyamuka atatenga ndalama zokalipirira mawula. Atafika kwa Balaamu, anamuwuza zomwe Balaki ananena. ");
INSERT INTO nya_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaamu anawawuza kuti, “Mugone konkuno usiku uno, ndipo ndikuyankhani zomwe Yehova andiwuze.” Choncho akuluakulu a Amowabu anagona kwa Balaamu. ");
INSERT INTO nya_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Mulungu anabwera kwa Balaamu namufunsa kuti, “Kodi anthu ali ndi iwewa ndani?” ");
INSERT INTO nya_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaamu anayankha Mulungu kuti, “Balaki mwana wa Zipori, mfumu ya Mowabu, ananditumizira uthenga uwu: ");
INSERT INTO nya_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Taonani, anthu amene achokera ku dziko la Igupto adzaza dziko lonse. Tsopano bwera udzawatemberere mʼmalo mwanga. Mwina ndidzatha kumenyana nawo ndi kuwatulutsa.’ ” ");
INSERT INTO nya_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Koma Mulungu anawuza Balaamu kuti, “Usapite nawo. Usawatemberere anthu amenewo chifukwa ndi odalitsika.” ");
INSERT INTO nya_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Mmawa mwake Balaamu anadzuka ndi kuwuza akuluakulu a Balaki aja kuti, “Bwererani ku dziko la kwanu chifukwa Yehova sanandilole kuti ndipite nanu.” ");
INSERT INTO nya_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Kotero akuluakulu a Mowabu anabwerera kwa Balaki ndi kukanena kuti, “Balaamu wakana kubwera nafe.” ");
INSERT INTO nya_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Kenaka Balaki anatumanso akuluakulu ena ambiri ndi olemekezeka kwambiri kuposa oyamba aja ndipo ");
INSERT INTO nya_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","anafika kwa Balaamu nati; “Zomwe Balaki mwana wa Zipori akunena ndi izi: ‘Usalole kuti china chilichonse chikulepheretse kubwera kwa ine, ");
INSERT INTO nya_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","chifukwa ndidzakulipira bwino kwambiri ndipo ndidzakuchitira chilichonse chimene unganene. Bwera ndipo uwatemberere anthu amenewa mʼmalo mwanga.’ ” ");
INSERT INTO nya_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Koma Balaamu anayankha atumiki a Balaki kuti, “Ngakhale Balaki atandipatsa nyumba yaufumu yodzaza ndi siliva ndi golide sindingachite chilichonse chachikulu kapena chachingʼono kuposa kuchita lamulo la Yehova Mulungu wanga. ");
INSERT INTO nya_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Tsopano mukhale kuno usiku uno monga ena anachitira, ndidzaona chimene Yehova adzandiwuza.” ");
INSERT INTO nya_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Usiku umenewo Mulungu anabwera kwa Balaamu ndipo anati, “Popeza anthu awa abwera kudzakuyitana, nyamuka, pita nawo koma ukachite zokhazo zimene ndikuwuze.” ");
INSERT INTO nya_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaamu anadzuka mmawa, namanga bulu wake wamkazi ndipo anapita ndi akuluakulu a Mowabu. ");
INSERT INTO nya_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Koma Mulungu anakwiya kwambiri pamene ankapita ndipo mngelo wa Yehova anayima pa njira kutsutsana naye. Balaamu anakwera bulu wake wamkazi ndipo antchito ake awiri anali naye. ");
INSERT INTO nya_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Pamene buluyo anaona mngelo wa Yehova atayima pa njira ndi lupanga mʼmanja mwake, anapatukira kumbali kwa msewu napita kutchire. Balaamu anamumenya kuti abwerere mu msewu. ");
INSERT INTO nya_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Kenaka mngelo wa Yehova anayima mʼkanjira kakangʼono pakati pa minda iwiri ya mpesa yokhala ndi makoma mbali zonse ");
INSERT INTO nya_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Bulu uja ataona mngelo wa Yehova anadzipanikiza ku khoma, kukhukhuza phazi la Balaamu kukhomako. Ndipo pomwepo Balaamu anamenya buluyo kachiwiri. ");
INSERT INTO nya_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Kenaka mngelo wa Yehova anapita patsogolo ndi kuyima pamalo opanikizika pomwe panalibe poti nʼkutembenukira ku dzanja lamanja kapena lamanzere. ");
INSERT INTO nya_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Buluyo ataonanso mngelo wa Yehova uja, anagona pansi Balaamu ali pa msana, ndipo iye anakwiya ndi kumumenya ndi ndodo yake. ");
INSERT INTO nya_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Pamenepo Yehova anayankhulitsa bulu uja, ndipo buluyo anati kwa Balaamu, “Ndakuchitirani chiyani kuti mundimenye katatuka?” ");
INSERT INTO nya_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaamu anati kwa buluyo, “Wandipusitsa, ndikanakhala ndi lupanga mʼmanja mwanga, ndikanakupha pomwe pano.” ");
INSERT INTO nya_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Buluyo anati kwa Balaamu, “Kodi sindine bulu wanu, amene mumakwera nthawi zonse kufikira lero? Kodi ndinakuchitiranipo zoterezi?” Iye anati “Ayi.” ");
INSERT INTO nya_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Pomwepo Yehova anatsekula maso Balaamu ndipo anaona mngelo wa Yehovayo ali chiyimire pa njira ndi lupanga losolola. Tsono iye anawerama nalambira pamaso pake. ");
INSERT INTO nya_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Mngelo wa Yehova anamufunsa kuti, “Chifukwa chiyani wamenya bulu wako katatu? Taona, Ine ndabwera kudzakutsutsa chifukwa ulendo wakowu ndi woyipa pamaso panga. ");
INSERT INTO nya_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Buluyu anandiona ndi kupatuka katatu aka. Akanakhala kuti sanapatuke, ndikanakupha tsopano, koma buluyu nʼkanamusiya ndi moyo.” ");
INSERT INTO nya_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaamu anati kwa mngelo wa Yehova uja, “Ndachimwa. Sindinadziwe kuti munayima pa njira kunditsutsa. Tsopano ngati Inu simunakondwe, ineyo ndibwerera.” ");
INSERT INTO nya_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Mngelo wa Yehova anati kwa Balaamu, “Pita ndi anthuwa koma ukayankhule zokhazo zimene ndikakuwuze.” Choncho Balaamu anapita ndi akuluakulu a Balaki. ");
INSERT INTO nya_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaki atamva kuti Balaamu akubwera, anapita kukakumana naye ku mzinda wa Mowabu umene unali mʼmalire a Arinoni, mʼmphepete mwa dziko lake. ");
INSERT INTO nya_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaki anati kwa Balaamu, “Kodi sindinakutumizire uthenga woti ubwere msanga? Chifukwa chiyani sunabwere kwa ine? Kodi sindingathe kukulipira mokwanira?” ");
INSERT INTO nya_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaamu anayankha Balaki kuti, “Taonani, ndabwera kwa inu lero, kodi ine ndili ndi mphamvu zoti nʼkuyankhula chilichonse? Inetu ndiyenera kuyankhula zokhazo zimene Mulungu wandiwuza.” ");
INSERT INTO nya_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Pamenepo Balaamu anapita pamodzi ndi Balaki ku Kiriati-Huzoti. ");
INSERT INTO nya_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balaki anapereka nsembe ngʼombe ndi nkhosa, ndipo anapereka zina kwa Balaamu ndi kwa akuluakulu omwe anali naye. ");
INSERT INTO nya_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Mmawa mwake Balaki anatenga Balaamu napita limodzi ku Bamoti Baala, ndipo kumeneko anakaonako gulu lina la Aisraeliwo. ");
INSERT INTO nya_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaamu anati kwa Balaki, “Mundimangire maguwa ansembe asanu ndi awiri pano, ndipo mukonzenso ngʼombe zazimuna zisanu ndi ziwiri ndi nkhosa zazimuna zisanu ndi ziwiri.” ");
INSERT INTO nya_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaki anachita monga Balaamu ananenera ndipo awiriwo anapereka ngʼombe imodzi ndi nkhosa yayimuna imodzi pa guwa lansembe lililonse. ");
INSERT INTO nya_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Kenaka Balaamu anati kwa Balaki, “Khalani pano pafupi ndi nsembe yanu ineyo ndipite pambali. Mwina Yehova adzabwera kuti akumane nane. Chilichonse chimene akandionetse ndidzakuwuzani” Choncho anapita ku malo okwera a chipululu. ");
INSERT INTO nya_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Mulungu anakumana naye ndipo Balaamu anati, “Ndakonza maguwa asanu ndi awiri ndipo pa guwa lililonse ndaperekapo nsembe ya ngʼombe yayimuna imodzi ndi nkhosa yayimuna imodzinso.” ");
INSERT INTO nya_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Yehova anawuza Balaamu kuti, “Bwerera kwa Balaki ndipo ukamuwuze uthenga uwu.” ");
INSERT INTO nya_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ndipo anabwerera kwa iye namupeza atayima pafupi ndi nsembe yake pamodzi ndi akuluakulu onse a Mowabu. ");
INSERT INTO nya_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Ndipo Balaamu ananena uthenga wake: “Balaki ananditenga kuchoka ku Aramu, mfumu ya ku Mowabu kuchokera ku mapiri a kummawa. Iye anati, ‘Bwera, temberera Yakobo mʼmalo mwanga, pita nyoza Israeli.’ ");
INSERT INTO nya_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ndingatemberere bwanji amene Mulungu sanawatemberere? Ndinganyoze bwanji amene Yehova sanawanyoze? ");
INSERT INTO nya_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Kuchokera pamwamba pa mapiri ndikuona anthu, ndikuwaona kuchokera pa zitunda. Ndikuona anthu okhala pawokha, osakhala mʼgulu limodzi ndi mitundu ina. ");
INSERT INTO nya_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ndani angawerenge zidzukulu za Yakobo zochuluka ngati fumbi, kapena chimodzi mwa zigawo zinayi za Israeli? Lekeni ndife imfa ya oyera mtima, ndi chimaliziro changa chikhale ngati chawo!” ");
INSERT INTO nya_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaki anati kwa Balaamu, “Wandichitira chiyani? Ndinakuyitana kuti utemberere adani anga, ndipo taona, sunachite chilichonse koma kuwadalitsa!” ");
INSERT INTO nya_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Iye anayankha kuti, “Kodi sindinayenera kuyankhula zimene Yehova anandiwuza?” ");
INSERT INTO nya_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Kenaka Balaki anawuza Balaamu kuti, “Tiye tipite limodzi ku malo ena komwe ungawaone. Udzangoona gulu limodzi osati onsewo. Ndipo pamenepo, ukawatemberere mʼmalo mwanga.” ");
INSERT INTO nya_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Tsono anamutengera ku munda wa Zofimu pamwamba pa phiri la Pisiga ndipo kumeneko anamanga maguwa ansembe asanu ndi awiri ndipo anapereka nsembe ngʼombe yayimuna imodzi ndi nkhosa yayimuna imodzi pa guwa lansembe lililonse. ");
INSERT INTO nya_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaamu anawuza Balaki kuti, “Khalani pano pafupi ndi nsembe yanu pamene ine ndikukakumana ndi Mulungu cha uko.” ");
INSERT INTO nya_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Yehova anakumana ndi Balaamu ndipo anamuyankhula kuti, “Bwerera kwa Balaki ndipo ukamuwuze uthenga uwu.” ");
INSERT INTO nya_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Ndipo anapita kwa iye ndipo anamupeza atayimirira pafupi ndi nsembe yake pamodzi ndi akuluakulu a ku Mowabu. Balaki anafunsa Balaamu kuti, “Yehova wayankhula chiyani?” ");
INSERT INTO nya_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Pamenepo Balaamu ananena uthenga wake: “Nyamuka Balaki ndipo tamvera; Undimvere iwe mwana wa Zipori. ");
INSERT INTO nya_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Mulungu si munthu kuti aname, kapena mwana wa munthu kuti asinthe maganizo ake. Kodi amayankhula koma osachita? Kodi amalonjeza koma osakwaniritsa? ");
INSERT INTO nya_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Wandilamula kuti ndidalitse, Iyeyo wadalitsa ndipo sindingasinthe. ");
INSERT INTO nya_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“Palibe kuwukira kulikonse kumene wakuona mwa Yakobo, sanaone chovuta mu Israeli. Yehova Mulungu wawo ali nawo: mfuwu wa mfumu uli pakati pawo. ");
INSERT INTO nya_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Mulungu wowatulutsa mʼdziko la Igupto, ali ndi mphamvu ngati za njati. ");
INSERT INTO nya_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Palibe matsenga amene angalimbane ndi Yakobo, palibe mawula amene angalimbane ndi Israeli. Tsopano za Yakobo ndi Israeli adzanena kuti, ‘Onani zimene Mulungu wachita!’ ");
INSERT INTO nya_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Taonani, anthu anyamuka ngati mkango waukazi; adzuka okha ngati mkango waumuna umene supuma mpaka utadya nyama imene wagwira ndi kumwa magazi a nyama yogwidwayo.” ");
INSERT INTO nya_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Ndipo Balaki anati kwa Balaamu, “Usawatemberere ndi pangʼono pomwe kapena kuwadalitsa! ");
INSERT INTO nya_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","“Balaamu anayankha Balaki kuti, ‘Kodi sindinakuwuzeni kuti ndiyenera kuchita zimene Yehova wanena?’ ” ");
INSERT INTO nya_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Kenaka Balaki anati kwa Balaamu, “Bwera ndikutengere ku malo ena. Mwina chidzamukondweretsa Mulungu kuti uwatemberere kumeneko mʼmalo mwanga.” ");
INSERT INTO nya_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Ndipo Balaki anamutengera Balaamu pamwamba pa Peori, poyangʼanana ndi chipululu. ");
INSERT INTO nya_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaamu anati kwa Balaki, “Mundimangire maguwa ansembe asanu ndi awiri pano ndipo mundikonzere ngʼombe zazimuna zisanu ndi ziwiri, nkhosa zazimuna zisanu ndi ziwiri.” ");
INSERT INTO nya_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaki anachita monga Balaamu ananenera ndipo anapereka nsembe ngʼombe imodzi yayimuna ndi nkhosa imodzi yayimuna pa guwa lililonse. ");
INSERT INTO nya_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Tsopano Balaamu ataona kuti kunakomera Yehova kudalitsa Israeli, sanapitenso ku mawula monga ankachitira kale, koma kuyangʼana ku chipululu. ");
INSERT INTO nya_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Balaamu atayangʼana, anaona Aisraeli atamanga misasa yawo fuko ndi fuko. Pamenepo mzimu wa Mulungu unabwera pa iye ");
INSERT INTO nya_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ndipo ananena uthenga wake: “Uthenga wa Balaamu mwana wa Beori, uthenga wa amene diso lake ndi lotsekuka, ");
INSERT INTO nya_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","uthenga wa amene amamva mawu a Mulungu, yemwe amaona masomphenya wochokera kwa Wamphamvuzonse, yemwe amagwa chafufumimba, koma maso ake ali chipenyere: ");
INSERT INTO nya_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“Matenti ako ndi okongola kwambiri iwe Yakobo, misasa yako, iwe Israeli! ");
INSERT INTO nya_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“Monga zigwa zotambalala, monga minda mʼmbali mwa mtsinje, monga aloe wodzalidwa ndi Yehova, monga mikungudza mʼmbali mwa madzi. ");
INSERT INTO nya_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Madzi adzayenderera mʼmitsuko yake; mbewu zake zidzakhala ndi madzi ambiri. “Mfumu yake idzakhala yamphamvu kuposa Agagi; ufumu wake udzakwezedwa. ");
INSERT INTO nya_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“Mulungu womutulutsa mʼdziko la Igupto ali ndi mphamvu ngati za njati. Amawononga mitundu yomuwukira ndi kuphwanya mafupa awo, amalasa ndi mivi yake. ");
INSERT INTO nya_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Monga mkango waumuna, amabisala nagona pansi, monga mkango waukazi, adzamuputa ndani? “Amene adalitsa iwe, adalitsike ndipo amene atemberera iwe, atembereredwe!” ");
INSERT INTO nya_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Kenaka Balaki anakwiyira Balaamu. Anawomba mʼmanja ndi kunena naye kuti, “Ndinakuyitana kuti utemberere adani anga, koma taona, wawadalitsa katatu konseka. ");
INSERT INTO nya_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Tsopano choka msanga uzipita kwanu! Ndinanena kuti ndidzakulipira bwino kwambiri, koma Yehova sanafune kuti ulandire malipirowo.” ");
INSERT INTO nya_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaamu anayankha Balaki kuti, “Kodi sindinawawuze amithenga amene munawatumiza kwa ine, ");
INSERT INTO nya_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","kuti ngakhale Balaki atandipatsa nyumba yake yaufumu yodzaza ndi siliva ndi golide sindingathe kuchita zinthu mwa ine ndekha, zabwino kapena zoyipa, kuposa lamulo la Yehova ndi kuti ndiyenera kunena zokhazo zimene Yehova akunena? ");
INSERT INTO nya_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Tsopano ndikupita kwa anthu anga, koma tabwerani ndikuchenjezeni zimene anthu awa adzachitira anthu anu masiku akubwerawa.” ");
INSERT INTO nya_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Ndipo iye ananena uthenga wake nati, “Uthenga wa Balaamu mwana wa Beori, uthenga wa amene diso lake ndi lotsekuka. ");
INSERT INTO nya_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Uthenga wa amene amamva mawu a Mulungu, amene ali ndi nzeru zochokera kwa Wammwambamwamba, amene amaona masomphenya wochokera kwa Wamphamvuzonse, amene amagwa chafufumimba koma diso lake lili lotsekuka: ");
INSERT INTO nya_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“Ndikumuona iye koma osati tsopano; ndikumupenya iye koma osati pafupi. Nyenyezi idzatuluka mwa Yakobo; ndodo yaufumu idzatuluka mwa Israeli. Iye adzagonjetsa Mowabu ndi kugonjetsa ana onse a Seti. ");
INSERT INTO nya_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edomu adzagonjetsedwa; Seiri, mdani wake, adzawonongedwa koma mphamvu za Israeli zidzachuluka. ");
INSERT INTO nya_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Wolamulira adzachokera mwa Yakobo ndipo adzawononga otsala a mu mzindamo.” ");
INSERT INTO nya_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Kenaka Balaamu anaona Aamaleki ndipo ananena uthenga wake uwu: “Aamaleki anali oyamba mwa mitundu ya anthu koma potsiriza pake adzawonongeka.” ");
INSERT INTO nya_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Kenaka anaonanso Akeni ndipo ananena uthenga wake, “Malo amene mukukhalamo ndi otetezedwa, chisa chanu chinayikidwa pa thanthwe; ");
INSERT INTO nya_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","komabe inu Akeni mudzawonongedwa, pamene Asuri adzakutengeni ukapolo.” ");
INSERT INTO nya_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ndipo ananenanso uthenga wina kuti, “Aa, ndani adzakhala ndi moyo Mulungu akachita zimenezi? ");
INSERT INTO nya_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Sitima zapamadzi zidzabwera kuchokera ku madooko a Kitimu; kupondereza Asuri ndi Eberi, koma iwonso adzawonongeka.” ");
INSERT INTO nya_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Pamenepo Balaamu ananyamuka ndi kubwerera kwawo ndipo Balaki anapitanso njira yake. ");
INSERT INTO nya_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Aisraeli akukhala ku Sitimu, anayamba kuchita chigololo ndi akazi a ku Mowabu, ");
INSERT INTO nya_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","amene ankawayitana ku nsembe za milungu yawo. Anthuwo anadya chakudya chopereka kwa milungu ndi kupembedza milunguyo. ");
INSERT INTO nya_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Motero Aisraeli anapembedza nawo Baala-Peori ndipo Yehova anawapsera mtima kwambiri. ");
INSERT INTO nya_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Pamenepo Yehova anawuza Mose kuti, “Tenga atsogoleri onse a anthu awa, uwaphe poyera, pamaso pa Yehova kuti mkwiyo waukulu wa Yehova uchoke pa Israeli.” ");
INSERT INTO nya_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Choncho Mose anawuza oweruza a Israeli kuti, “Aliyense wa inu ayenera kupha anthu ake amene anapembedza nawo Baala-Peori.” ");
INSERT INTO nya_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Kenaka mwamuna wina wa ku Israeli anabweretsa ku banja lake mkazi wa Chimidiyani pamaso pa Mose ndi anthu onse a Israeli pamene ankalira pa khomo la tenti ya msonkhano. ");
INSERT INTO nya_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Finehasi mwana wa Eliezara, mwana wa wansembe Aaroni ataona izi, anachoka pa msonkhanowo, natenga mkondo mʼdzanja lake. ");
INSERT INTO nya_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Ndipo anatsatira Mwisraeliyu mpaka mʼtenti yake. Anasolola mkondowo ndi kubaya awiriwo kupyola Mwisraeliyo mpaka mʼthupi la mkaziyo. Pamenepo mliri unaleka pakati pa Aisraeli. ");
INSERT INTO nya_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Pa mliriwo, anthu okwana 24,000 anafa. ");
INSERT INTO nya_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finehasi mwana wa Eliezara, mwana wa wansembe Aaroni wabweza mkwiyo wanga pa Aisraeli chifukwa sanalole kuti wina aliyense apembedze mulungu wina koma Ine ndekha. Nʼchifukwa chake sindinawawononge mu mkwiyo wanga. ");
INSERT INTO nya_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Tsono muwuze kuti ndikhazikitsa pangano langa la mtendere ndi iye. ");
INSERT INTO nya_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Ndikupangana naye pangano la unsembe wosatha, iyeyo pamodzi ndi zidzukulu zake zonse, chifukwa sanalole kuti anthu awukire Ine Mulungu, ndipo anachita ntchito yopepesera machimo Aisraeli.” ");
INSERT INTO nya_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Dzina la Mwisraeli yemwe anaphedwa ndi mkazi wa Chimidiyani anali Zimuri mwana wa Salu, mtsogoleri wa banja la Simeoni. ");
INSERT INTO nya_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Ndipo dzina la mkazi wa Chimidiyani, yemwe anaphedwayo, linali Kozibi mwana wa Zuri, mtsogoleri wa fuko la ku Midiyaniko. ");
INSERT INTO nya_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Amidiyani ndi adani anu ndipo uwaphe, ");
INSERT INTO nya_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","chifukwa ankakuonani inu ngati adani awo pamene anakupusitsani pa nkhani ya ku Peori, ndiponso za mlongo wawo Kozibi, mwana wamkazi wa mtsogoleri wa Amidiyani, mkazi yemwe anaphedwa pamene mliri unabwera chifukwa cha zimene zinachitika ku Peori.” ");
INSERT INTO nya_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Utatha mliri Yehova anati kwa Mose ndi Eliezara mwana wa Aaroni, ");
INSERT INTO nya_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Werengani Aisraeli onse mwa mabanja awo, onse a zaka makumi awiri kapena kuposera pamenepo omwe angathe kugwira ntchito ya usilikali mʼgulu lankhondo la Israeli.” ");
INSERT INTO nya_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Kotero mu zigwa za Mowabu pafupi ndi mtsinje wa Yorodani ku Yeriko, Mose ndi wansembe Eliezara anayankhula nawo kuti, ");
INSERT INTO nya_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Werengani amuna a zaka makumi awiri kapena kuposera pamenepo, monga momwe Yehova walamulira Mose.” Aisraeli omwe anachokera ku Igupto ndi awa: ");
INSERT INTO nya_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Zidzukulu za Rubeni, mwana woyamba wamwamuna wa Israeli, zinali izi: kuchokera mwa Hanoki, fuko la Ahanoki; kuchokera mwa Palu, fuko la Apalu; ");
INSERT INTO nya_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","kuchokera mwa Hezironi, fuko la Ahezironi; kuchokera mwa Karimi, fuko la Akarimi. ");
INSERT INTO nya_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Awa anali mafuko a Rubeni: onse amene anawerengedwa analipo 43,730. ");
INSERT INTO nya_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Mwana wa Palu anali Eliabu, ");
INSERT INTO nya_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ndipo ana a Eliabu anali Nemueli, Datani ndi Abiramu. Datani ndi Abiramu anali gulu la akuluakulu aja amene anawukira Mose ndi Aaroni ndipo analinso mʼgulu la otsatira Kora pamene anawukira Yehova. ");
INSERT INTO nya_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Nthaka inangʼambika ndi kuwameza pamodzi ndi Kora, kotero kuti gulu lawo linafa pamene moto unapsereza anthu 250 aja, nasanduka chenjezo. ");
INSERT INTO nya_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Koma ana a Kora sanafe nawo. ");
INSERT INTO nya_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Zidzukulu za Simeoni mwa mafuko awo zinali izi: kuchokera mwa Nemueli, fuko la Anemuele; kuchokera mwa Yamini, fuko la Ayamini; kuchokera mwa Yakini fuko la Ayakini; ");
INSERT INTO nya_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","kuchokera mwa Zera, mbumba ya Zera; kuchokera mwa Sauli, fuko la Asauli. ");
INSERT INTO nya_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Awa anali mafuko a Simeoni. Iwowa analipo amuna 22,200. ");
INSERT INTO nya_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Zidzukulu za Gadi mwa mafuko awo ndi izi: kuchokera mwa Zefoni, fuko la Azefoni; kuchokera mwa Hagi, fuko la Ahagi; kuchokera mwa Suni, fuko la Asuni; ");
INSERT INTO nya_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","kuchokera mwa Ozini, fuko la Aozini; kuchokera mwa Eri, fuko la Aeri; ");
INSERT INTO nya_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","kuchokera mwa Arodi, fuko la Aarodi; kuchokera mwa Arieli, fuko la a Areli. ");
INSERT INTO nya_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Awa ndiwo anali mafuko a Gadi. Onse amene anawerengedwa analipo 40,500. ");
INSERT INTO nya_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Eri ndi Onani anali ana aamuna a Yuda, koma anafera mu Kanaani. ");
INSERT INTO nya_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Zidzukulu za Yuda monga mwa mafuko awo zinali izi: kuchokera mwa Sela, fuko la Asera; kuchokera mwa Perezi, fuko la Aperezi; kuchokera mwa Zera, mbumba ya Zera. ");
INSERT INTO nya_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Zidzukulu za Perezi zinali izi: kuchokera mwa Hezironi, fuko la Ahezironi; kuchokera mwa Hamuli, fuko la Ahamuli. ");
INSERT INTO nya_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Awa ndiwo anali mafuko a Yuda. Amene anawerenga analipo 76,500. ");
INSERT INTO nya_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Zidzukulu za Isakara monga mwa mafuko awo zinali izi: kuchokera mwa Tola, fuko la Atola; kuchokera mwa Puwa, fuko la Apuwa; ");
INSERT INTO nya_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","kuchokera mwa Yasubu, fuko la Ayasubu. Kuchokera mwa Simironi, fuko la Asimironi. ");
INSERT INTO nya_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Awa ndi amene anali a fuko la Isakara. Amene anawerengedwa analipo 64,300. ");
INSERT INTO nya_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Zidzukulu za Zebuloni mwa mafuko awo zinali izi: kuchokera mwa Seredi, fuko la Aseredi; kuchokera mwa Eloni, fuko la Aeloni; kuchokera mwa Yahaleeli, fuko la Ayahaleeli. ");
INSERT INTO nya_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Awa ndiwo anali mafuko a Zebuloni. Amene anawerengedwa analipo 60,500. ");
INSERT INTO nya_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Zidzukulu za Yosefe mwa mafuko awo kupyolera mwa Manase ndi Efereimu zinali izi: ");
INSERT INTO nya_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Zidzukulu za Manase: kuchokera mwa Makiri, fuko la Amakiri (Makiri anali abambo ake a Giliyadi); kuchokera mwa Giliyadi, fuko la Agiliyadi. ");
INSERT INTO nya_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Izi ndizo zinali zidzukulu za Giliyadi; kuchokera mwa Iyezeri, fuko la Aiyezeri; kuchokera mwa Heleki, fuko la Aheleki; ");
INSERT INTO nya_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","kuchokera mwa Asirieli, fuko la Aasirieli; kuchokera mwa Sekemu, fuko la Asekemu; ");
INSERT INTO nya_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","kuchokera mwa Semida, fuko la Asemida; kuchokera mwa Heferi, fuko la Aheferi. ");
INSERT INTO nya_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(Zelofehadi mwana wa Heferi analibe ana aamuna koma ana aakazi okha, amene mayina awo anali: Mala, Nowa, Hogila, Milika ndi Tiriza.) ");
INSERT INTO nya_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Awa ndiwo anali mafuko a Manase. Amene anawerengedwa analipo 52,700. ");
INSERT INTO nya_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Zidzukulu za Efereimu monga mwa mafuko awo zinali izi; kuchokera mwa Sutela, fuko la Asutela; kuchokera mwa Bekeri, fuko la Abekeri; kuchokera mwa Tahani, fuko la Atahani. ");
INSERT INTO nya_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Zidzukulu za Sutela zinali izi: kuchokera mwa Erani, fuko la Aerani. ");
INSERT INTO nya_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Awa ndiwo anali mafuko a Efereimu. Amene anawerengedwa analipo 32,500. Zimenezi zinali zidzukulu za Yosefe monga mwa mafuko awo. ");
INSERT INTO nya_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Zidzukulu za Benjamini monga mwa mabanja awo zinali izi: kuchokera mwa Bela, fuko la Abela; kuchokera mwa Asibeli, fuko la Aasibeli; kuchokera mwa Ahiramu, fuko la Ahiramu; ");
INSERT INTO nya_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","kuchokera mwa Sufamu, fuko la Asufamu; kuchokera mwa Hufamu, fuko la Ahufamu; ");
INSERT INTO nya_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Zidzukulu za Bela kupyolera mwa Aridi ndi Naamani zinali izi: kuchokera mwa Aridi, fuko la Aaridi; kuchokera mwa Naamani, fuko la Anaamani; ");
INSERT INTO nya_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Awa ndiwo anali mabanja a Benjamini. Amene nawerengedwa analipo 45,600. ");
INSERT INTO nya_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Zidzukulu za Dani mwa mabanja awo zinali izi: kuchokera mwa Suhamu fuko la Asuhamu. Izi zinali zidzukulu za Dani. ");
INSERT INTO nya_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Onse a fuko la Asuhamu amene anawerengedwa analipo 64,400. ");
INSERT INTO nya_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Zidzukulu za Aseri monga mwa mafuko awo zinali izi: kuchokera mwa Imina, fuko la Aimuna; kuchokera mwa Isivi, fuko la Ayisivi; kuchokera mwa Beriya, fuko la Aberiya; ");
INSERT INTO nya_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","ndipo kupyolera mwa zidzukulu za Beriya: kuchokera mwa Heberi, fuko la Aheberi; kuchokera mwa Malikieli, fuko la Amalikieli; ");
INSERT INTO nya_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","(Aseri anali ndi mwana wamkazi dzina lake Sera) ");
INSERT INTO nya_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Awa ndiwo anali mafuko a Aseri. Onse amene anawerengedwa analipo 53,400. ");
INSERT INTO nya_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Zidzukulu za Nafutali mwa mafuko awo zinali izi: kuchokera mwa Yahazeeli, fuko la Ayahazeeli; kuchokera mwa Guni, fuko la Aguni; ");
INSERT INTO nya_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","kuchokera mwa Yezeri, fuko la Ayezeri; kuchokera mwa Silemu, fuko la Asilemu. ");
INSERT INTO nya_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Awa ndiwo anali mafuko a Nafutali. Onse amene anawerengedwa analipo 45,400. ");
INSERT INTO nya_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Chiwerengero chonse cha amuna mu Israeli chinalipo 601,730. ");
INSERT INTO nya_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Uwagawire dziko anthu awa kuti likhale cholowa chawo molingana ndi chiwerengero cha mayina awo. ");
INSERT INTO nya_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Gulu lalikulu ulipatse cholowa chachikulu, ndipo lochepa cholowa chocheperapo. Gulu lililonse lilandire cholowa chake molingana ndi chiwerengero cha amene anawerengedwa. ");
INSERT INTO nya_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Dzikolo uligawe pochita maere. Alandire cholowa chawocho potsata mayina a mafuko a makolo awo. ");
INSERT INTO nya_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Cholowa chawo uchigawe pakati pa fuko lalikulu ndi lalingʼono mwa maere.” ");
INSERT INTO nya_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Alevi omwe anawerengedwa monga mwa mafuko awo ndi awa: kuchokera mwa Geresoni, fuko la Ageresoni; kuchokera mwa Kohati, fuko la Akohati; kuchokera mwa Merari, fuko la Amerari. ");
INSERT INTO nya_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Awanso anali mabanja a Alevi: banja la Alibini, banja la Ahebroni, banja la Amali, banja la Amusi, fuko la Kora banja la Akohati, (Kohati anali abambo a Amramu. ");
INSERT INTO nya_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Dzina la mkazi wa Amramu linali Yokobedi, mdzukulu wa Levi, yemwe anabadwa mwa Alevi mu Igupto. Yokobedi anaberekera Amramu Aaroni, Mose ndi Miriamu mlongo wawo. ");
INSERT INTO nya_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aaroni anali abambo a Nadabu, Abihu, Eliezara ndi Itamara. ");
INSERT INTO nya_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Koma Nadabu ndi Abihu anafa pamene anapereka nsembe pamaso pa Yehova ndi moto wachilendo). ");
INSERT INTO nya_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Alevi onse aamuna a mwezi umodzi kapena kuposera pamenepa analipo 23,000. Iwowo sanawerengedwe pamodzi ndi Aisraeli ena chifukwa sanalandire cholowa pakati pawo. ");
INSERT INTO nya_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Awa ndi amene anawerengedwa ndi Mose ndi Eliezara wansembe pamene ankawerenga Aisraeli pa zigwa za ku Mowabu mʼmbali mwa Yorodani ku Yeriko. ");
INSERT INTO nya_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Mwa anthu amenewa panalibe ndi mmodzi yemwe amene anali mʼgulu la Aisraeli omwe Mose ndi wansembe Aaroni anawawerenga mʼchipululu cha Sinai; ");
INSERT INTO nya_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Chifukwa Yehova anali atawuza Aisraeliwo kuti adzafera ndithu mʼchipululu, ndipo palibe ndi mmodzi yemwe amene anatsala kupatula Kalebe mwana wa Yefune ndi Yoswa mwana wa Nuni. ");
INSERT INTO nya_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Kenaka ana aakazi a Zelofehadi mwana wa Heferi, mwana wa Giliyadi, mwana wa Makiri, mwana wamwamuna wa Manase, a mʼmabanja a Manase, mwana wa Yosefe anabwera. Mayina a ana aakaziwo anali awa: Mala, Nowa, Hogila, Milika ndi Tiriza. Iwo anakayima ");
INSERT INTO nya_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","pa chipata cha tenti ya msonkhano pamaso pa Mose, wansembe Eliezara, atsogoleri ndi anthu onse, ndipo anati, ");
INSERT INTO nya_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Abambo athu anafera mʼchipululu koma sanali nawo mʼgulu la anthu otsatira Kora, omwe anasonkhana pamodzi kutsutsana ndi Yehova. Abambo athuwo anafa chifukwa cha tchimo lawo ndipo sanasiye ana aamuna. ");
INSERT INTO nya_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Nʼchifukwa chiyani dzina la abambo athu lasowa pakati pa fuko lawo, kodi popeza analibe mwana wamwamuna? Tipatseni cholowa chathu pakati pa abale a abambo athu.” ");
INSERT INTO nya_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Tsono Mose anabweretsa nkhani yawo pamaso pa Yehova ");
INSERT INTO nya_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","ndipo Yehova anati kwa iye, ");
INSERT INTO nya_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Zimene ana aakazi a Zelofehadi akunena ndi zoona. Uyenera kuwapatsadi cholowa chawo pakati pa abale a abambo awo ndipo uwapatse cholowa cha abambo awowo. ");
INSERT INTO nya_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Uza Aisraeli kuti, ‘Ngati munthu afa wosasiya mwana wamwamuna, muzipereka cholowa chake kwa mwana wake wamkazi. ");
INSERT INTO nya_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ngati alibe mwana wamkazi, muzipereka cholowa chakecho kwa abale ake. ");
INSERT INTO nya_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Ngati alibe abale muzipereka cholowa chake kwa abale a abambo ake. ");
INSERT INTO nya_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ngati abambo ake analibe mʼbale, muzipereka cholowa chakecho kwa mnansi wake wa mʼbanja lake kuti chikhale chake. Ili likhale lamulo kwa Aisraeli, monga momwe Yehova analamulira Mose.’ ” ");
INSERT INTO nya_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Kenaka Yehova anati kwa Mose, “Kwera phiri la Abarimu kuti ukaone dziko limene ndalipereka kwa Aisraeli. ");
INSERT INTO nya_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Ukakaliona udzamwalira ngati Aaroni mʼbale wako, ");
INSERT INTO nya_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","chifukwa pamene anthu anawukira ku madzi a Meriba mʼchipululu cha Zini, inu nonse simunamvere lamulo londilemekeza Ine ngati Woyera pamaso pawo.” (Awa anali madzi a ku Meriba ku Kadesi mʼchipululu cha Zini). ");
INSERT INTO nya_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Mose anati kwa Yehova, ");
INSERT INTO nya_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Ngati nʼkotheka Yehova, Mulungu wa mizimu ya anthu onse, sankhani munthu woti ayangʼanire gulu ili kuti ");
INSERT INTO nya_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","alitsogolere potuluka ndi polowa, kuti anthu a Yehova asakhale ngati nkhosa zopanda mʼbusa.” ");
INSERT INTO nya_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Pamenepo Yehova anawuza Mose kuti, “Tenga Yoswa mwana wa Nuni, munthu amene ali ndi mzimu wa utsogoleri, ndipo umusanjike dzanja lako. ");
INSERT INTO nya_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Umuyimiritse pamaso pa wansembe Eliezara ndi pamaso pa gulu lonse ndipo umupatse mphamvu zolamulira, anthuwo akuona. ");
INSERT INTO nya_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Umupatse gawo lina la ulemerero wako kuti Aisraeli onse azimumvera. ");
INSERT INTO nya_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Ayime pamaso pa wansembe Eliezara, amene adzamudziwitse zimene Yehova akufuna pogwiritsa ntchito Urimu. Iye akalamula, Aisraeli onse azituluka ndipo akalamulanso, Aisraeliwo azibwereranso.” ");
INSERT INTO nya_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Mose anachita monga Yehova anamulamulira. Anatenga Yoswa ndi kumuyimiritsa pamaso pa Eliezara wansembe ndi pamaso pa gulu lonse. ");
INSERT INTO nya_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Ndipo anamusanjika manja ndi kumupatsa mphamvu, monga Yehova ananenera kudzera mwa Mose. ");
INSERT INTO nya_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Lamula Aisraeli kuti, ‘Onetsetsani kuti mukupereka kwa Ine pa nthawi yoyikika, chopereka cha chakudya chotentha pa moto monga fungo lokoma kwa Ine.’ ");
INSERT INTO nya_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Awuze kuti, ‘Nsembe ya chakudya imene muzipereka pa moto kwa Yehova tsiku ndi tsiku ndi iyi: Ana ankhosa a chaka chimodzi awiri, wopanda chilema. ");
INSERT INTO nya_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Mmawa muzipereka mwana wankhosa mmodzi ndipo winayo madzulo. ");
INSERT INTO nya_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Muziperekanso kilogalamu imodzi ya ufa wosalala wosakaniza ndi lita imodzi ya mafuta a olivi. ");
INSERT INTO nya_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Iyi ndi nsembe yopsereza ya tsiku ndi tsiku imene analamula pa phiri la Sinai kuti ikhale fungo lokoma, nsembe yopsereza pa moto yopereka kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Chopereka chachakumwa chikhale lita imodzi yachakumwa chaukali pa nkhosa iliyonse. Muzithira pamalo opatulika, kupereka kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Muzipereka mwana wankhosa winayo madzulo, pamodzi ndi chopereka chachakudya monga poyamba paja ndi chopereka chachakumwa monga mmawa. Ichi ndi chopereka chachakudya, fungo lokoma kwa Yehova.’ ” ");
INSERT INTO nya_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘Pa tsiku la Sabata, muzipereka nsembe ana ankhosa awiri a chaka chimodzi wopanda chilema, pamodzi ndi chopereka chachakumwa ndi chopereka chachakudya chokwana makilogalamu awiri a ufa wosalala wosakaniza ndi mafuta. ");
INSERT INTO nya_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Iyi ndi nsembe yopsereza ya pa Sabata iliyonse, kuwonjezera pa nsembe yopsereza ya nthawi zonse ndi chopereka chake chachakumwa.’ ” ");
INSERT INTO nya_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“Pa tsiku loyamba la mwezi uliwonse muzipereka kwa Yehova nsembe yopsereza ya ana angʼombe aamuna awiri, nkhosa yayimuna imodzi, ana ankhosa aamuna asanu ndi awiri a chaka chimodzi, onse wopanda chilema. ");
INSERT INTO nya_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Pa ngʼombe yayimuna iliyonse pakhale chopereka cha chakudya cha makilogalamu atatu a ufa wosalala wosakaniza ndi mafuta; ndi nkhosa yayimuna, chopereka cha chakudya cha makilogalamu awiri a ufa wosalala wosakaniza ndi mafuta; ");
INSERT INTO nya_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ndipo pa mwana wankhosa aliyense, chopereka cha ufa wa kilogalamu imodzi ya ufa wosalala wosakaniza ndi mafuta, izi ndi za nsembe yopsereza, fungo lokoma, nsembe yotentha pa moto ya kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Pa ngʼombe yayimuna iliyonse pakhale chopereka cha chakumwa cha malita awiri a vinyo; ndipo pa nkhosa yayimuna, lita limodzi ndi theka, ndipo pa mwana wankhosa, lita limodzi. Iyi ndi nsembe yopsereza ya mwezi ndi mwezi yoperekedwa pa mwezi watsopano mʼkati mwa chaka. ");
INSERT INTO nya_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Powonjezera pa nsembe yopsereza ya nthawi zonse ndi chopereka chake cha chakumwa, mbuzi yayimuna imodzi iperekedwe kwa Yehova ngati nsembe yopepesera machimo. ");
INSERT INTO nya_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘Pa tsiku la 14 la mwezi woyamba muzichita Paska wa Yehova. ");
INSERT INTO nya_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Pa tsiku la 15 la mwezi womwewo pazikhala chikondwerero. Muzidya buledi wopanda yisiti kwa masiku asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Pa tsiku loyamba muzichita msonkhano wopatulika ndipo musamagwire ntchito iliyonse. ");
INSERT INTO nya_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Koma muzipereka kwa Yehova nsembe yotentha pa moto, nsembe yopsereza ya ana angʼombe aamuna awiri, nkhosa yayimuna imodzi ndi ana ankhosa asanu ndi awiri aamuna a chaka chimodzi, onsewo wopanda chilema. ");
INSERT INTO nya_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Pamodzi ndi ngʼombe yayimuna iliyonse, muzikonza chopereka cha chakudya cha makilogalamu atatu a ufa wosalala wosakaniza ndi mafuta; makilogalamu awiri pa nkhosa yayimuna iliyonse. ");
INSERT INTO nya_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Kilogalamu imodzi pa mwana wankhosa aliyense mwa ana ankhosa asanu ndi awiri aja. ");
INSERT INTO nya_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Muziphatikizapo mbuzi yayimuna monga nsembe yopepesera machimo anu. ");
INSERT INTO nya_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Muzikonza zimenezi nthawi zonse, powonjezera pa nsembe yopsereza ya mmawa. ");
INSERT INTO nya_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Motere muzikonza chakudya cha nsembe yopsereza ya tsiku ndi tsiku pa masiku asanu ndi awiri ngati fungo lokomera Yehova. Zimenezi ziziperekedwa kuwonjezera pa nsembe yopsereza ya nthawi zonse pamodzi ndi nsembe yachakumwa. ");
INSERT INTO nya_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Pa tsiku lachisanu ndi chiwiri muzichita msonkhano wopatulika ndipo musamagwire ntchito iliyonse. ");
INSERT INTO nya_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘Pa tsiku la zipatso zoyambirira kucha, pamene mukupereka chopereka cha chakudya chatsopano kwa Yehova, pa nthawi ya chikondwerero cha Masabata, muzichita msonkhano wopatulika ndipo musagwire ntchito zolemetsa. ");
INSERT INTO nya_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Muzipereka nsembe zopsereza za ana angʼombe aamuna awiri, nkhosa imodzi yayimuna ndi ana ankhosa aamuna asanu ndi awiri a chaka chimodzi monga fungo lokomera Yehova. ");
INSERT INTO nya_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Pa ngʼombe yayimuna iliyonse pazikhala chopereka cha chakudya cha makilogalamu atatu a ufa wosalala wosakaniza ndi mafuta, pa nkhosa yayimuna iliyonse makilogalamu awiri. ");
INSERT INTO nya_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Ndipo pa mwana wankhosa aliyense mwa asanu ndi awiri aja, kilogalamu imodzi. ");
INSERT INTO nya_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Muziperekanso mbuzi yayimuna imodzi kuti izikhala nsembe yopepesera machimo anu. ");
INSERT INTO nya_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Muzipereka zimenezi pamodzi ndi zopereka za zakumwa ndi nsembe yake ya chakudya. Onetsetsani kuti nyamazo zilibe chilema. ");
INSERT INTO nya_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘Pa tsiku loyamba la mwezi wachisanu ndi chiwiri muzichita msonkhano wopatulika ndipo musamagwire ntchito iliyonse. Ili ndi tsiku limene muziliza malipenga. ");
INSERT INTO nya_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Muzipereka mwana wangʼombe wamwamuna mmodzi, nkhosa yayimuna imodzi ndi ana ankhosa asanu ndi awiri a chaka chimodzi wopanda chilema monga nsembe zopsereza, fungo lokoma kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Pa ngʼombe yayimuna iliyonse, muzipereka chopereka cha chakudya cha makilogalamu atatu a ufa wosalala wosakaniza ndi mafuta. Pa nkhosa yayimuna iliyonse muzipereka makilogalamu awiri. ");
INSERT INTO nya_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","Pa mwana wankhosa aliyense mwa asanu ndi awiri aja muzipereka kilogalamu imodzi. ");
INSERT INTO nya_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Muziperekanso mbuzi yayimuna kuti izikhala nsembe yopepesera machimo anu. ");
INSERT INTO nya_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Izi ndi zowonjezera pa nsembe zopsereza za mwezi ndi mwezi komanso za tsiku ndi tsiku pamodzi ndi zopereka za chakudya ndi zopereka za chakumwa potsata malamulo ake. Izi ndi zopereka zotentha pa moto, zoperekedwa kwa Yehova, fungo lokoma. ");
INSERT INTO nya_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘Pa tsiku lakhumi la mwezi wachisanu ndi chiwiriwu, muzichita msonkhano wopatulika. Muzisala zakudya ndipo musamagwire ntchito. ");
INSERT INTO nya_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Muzipereka kwa Yehova nsembe yopsereza, yotulutsa fungo lokoma lokondweretsa Yehovayo; ngʼombe yayimuna imodzi, nkhosa yayimuna imodzi ndi ana ankhosa asanu ndi awiri a chaka chimodzi. Zimenezi zizikhala zopanda chilema. ");
INSERT INTO nya_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Pa ngʼombe yayimuna iliyonse, muzikonza chopereka cha chakudya cha makilogalamu atatu a ufa wosalala wosakaniza ndi mafuta; pa nkhosa yayimuna iliyonse makilogalamu awiri; ");
INSERT INTO nya_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","kilogalamu imodzi pa mwana wankhosa aliyense mwa asanu ndi awiriwo. ");
INSERT INTO nya_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Muziperekanso mbuzi imodzi yayimuna kuti izikhala nsembe yopepesera machimo, kuwonjezera pa nsembe yopepesera machimo ya pa tsiku la mwambo ija, kuwonjezanso pa nsembe zopsereza za tsiku ndi tsiku zija, pamodzi ndi chopereka chake cha chakudya ndi cha chakumwa. ");
INSERT INTO nya_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘Pa tsiku la mwezi wachisanu ndi chiwiri, muzichita msonkhano wopatulika ndipo musamagwire ntchito iliyonse. Muzichita madyerero a Yehova masiku asanu ndi awiri. ");
INSERT INTO nya_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Muzipereka nsembe yotentha pa moto, kuti izikhala fungo lokoma kwa Yehova, nsembe yopsereza ya ana angʼombe aamuna khumi ndi atatu, nkhosa zazimuna ziwiri, ndi ana ankhosa aamuna khumi ndi anayi a chaka chimodzi, zonse zopanda chilema. ");
INSERT INTO nya_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Pa mwana wangʼombe aliyense mwa ana angʼombe aamuna khumi ndi atatu aja, muzikonza chopereka cha chakudya cha makilogalamu atatu a ufa wosalala wosakaniza ndi mafuta. Pa nkhosa iliyonse mwa nkhosa ziwiri zija, mukonza chopereka cha chakudya cha makilogalamu awiri. ");
INSERT INTO nya_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","Pa mwana wankhosa aliyense mwa ana ankhosa aamuna khumi ndi anayiwo, muzipereka chakudya cha kilogalamu imodzi. ");
INSERT INTO nya_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Muziperekanso mbuzi yayimuna imodzi kuti izikhale nsembe yopepesera machimo, kuwonjezera pa nsembe zopsereza za tsiku ndi tsiku zija pamodzi ndi chopereka chake cha chakudya ndi chakumwa. ");
INSERT INTO nya_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘Pa tsiku lachiwiri muzipereka ana angʼombe aamuna khumi ndi awiri aja, nkhosa zazimuna ziwiri ndi ana ankhosa aamuna khumi ndi anayi a chaka chimodzi aja, zonse zopanda chilema. ");
INSERT INTO nya_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Pamodzi ndi ngʼombe zazimuna, nkhosa zazimuna ndi ana ankhosa, muzipereka zopereka za chakudya ndi za chakumwa molingana ndi chiwerengero cha nyamazo. ");
INSERT INTO nya_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Muziperekanso mbuzi imodzi yayimuna ya nsembe yopepesera machimo powonjezera pa nsembe yopsereza ya tsiku ndi tsiku pamodzi ndi chopereka chake cha chakudya ndi chakumwa. ");
INSERT INTO nya_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘Pa tsiku lachitatu muzipereka ngʼombe zazimuna khumi ndi imodzi, nkhosa zazimuna ziwiri ndi ana ankhosa aamuna khumi ndi anayi a chaka chimodzi, zonse zopanda chilema. ");
INSERT INTO nya_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Pamodzi ndi ngʼombe zazimuna, nkhosa zazimuna ndi ana ankhosa, muzipereka zopereka za chakudya ndi za chakumwa molingana ndi chiwerengero cha nyamazo. ");
INSERT INTO nya_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Muziperekanso mbuzi imodzi yayimuna ya nsembe yopepesera machimo, powonjezera pa nsembe yopsereza ya tsiku ndi tsiku pamodzi ndi chopereka chake cha chakudya ndi chakumwa. ");
INSERT INTO nya_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘Pa tsiku lachinayi muzipereka ngʼombe zazimuna khumi, nkhosa zazimuna ziwiri ndi ana ankhosa aamuna khumi ndi anayi a chaka chimodzi, zonse zopanda chilema. ");
INSERT INTO nya_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Pamodzi ndi ngʼombe zazimuna, nkhosa zazimuna ndi ana ankhosa, muzipereka chopereka cha chakudya ndi chakumwa molingana ndi chiwerengero cha nyamazo. ");
INSERT INTO nya_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Muziperekanso mbuzi imodzi yayimuna ya nsembe yopepesera machimo, powonjezera pa nsembe yopsereza ya tsiku ndi tsiku pamodzi ndi chopereka chake cha chakudya ndi chakumwa. ");
INSERT INTO nya_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘Pa tsiku lachisanu muzipereka ngʼombe zazimuna zisanu ndi zinayi, nkhosa zazimuna ziwiri ndi ana ankhosa aamuna khumi ndi anayi a chaka chimodzi, zonse zopanda chilema. ");
INSERT INTO nya_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Pamodzi ndi ngʼombe zazimuna, nkhosa zazimuna ndi ana ankhosa, muzipereka chopereka cha chakudya ndi chakumwa molingana ndi chiwerengero cha nyamazo. ");
INSERT INTO nya_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Muziperekanso mbuzi imodzi yayimuna ya nsembe yopepesera machimo, powonjezera pa nsembe yopsereza ya tsiku ndi tsiku ndi chopereka chake cha chakudya ndi chakumwa. ");
INSERT INTO nya_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘Pa tsiku lachisanu ndi chimodzi muzipereka ngʼombe zazimuna zisanu ndi zitatu, nkhosa zazimuna ziwiri ndi ana ankhosa aamuna khumi ndi anayi a chaka chimodzi, zonse zopanda chilema. ");
INSERT INTO nya_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Pamodzi ndi ngʼombe zazimuna, nkhosa zazimuna ndi ana ankhosa, muzipereka chopereka cha chakudya ndi cha chakumwa molingana ndi chiwerengero cha nyamazo. ");
INSERT INTO nya_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Muziperekenso mbuzi imodzi yayimuna ya nsembe yopepesera machimo, powonjezera pa nsembe yopsereza ya tsiku ndi tsiku pamodzi ndi chopereka chake cha chakudya ndi chakumwa. ");
INSERT INTO nya_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘Pa tsiku lachisanu ndi chiwiri muzipereka ngʼombe zazimuna zisanu ndi ziwiri, nkhosa zazimuna ziwiri ndi ana ankhosa amuna khumi ndi anayi a chaka chimodzi, zonse zopanda chilema. ");
INSERT INTO nya_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Pamodzi ndi ngʼombe zazimuna, nkhosa zazimuna ndi ana ankhosa, muzipereka chopereka cha chakudya ndi chakumwa molingana ndi chiwerengero cha nyamazo. ");
INSERT INTO nya_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Muziperekanso mbuzi imodzi yayimuna ya nsembe yopepesera machimo, powonjezera pa nsembe yopsereza ya tsiku ndi tsiku pamodzi ndi chopereka chake cha chakudya ndi chakumwa. ");
INSERT INTO nya_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘Pa tsiku lachisanu ndi chitatu muzichita msonkhano ndipo musamagwire ntchito iliyonse. ");
INSERT INTO nya_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Muzipereka chopereka chotentha pa moto monga fungo lokoma kwa Yehova, nsembe yopsereza ya ngʼombe imodzi yayimuna, nkhosa yayimuna imodzi ndi ana ankhosa amuna asanu ndi awiri a chaka chimodzi, zonse zopanda chilema. ");
INSERT INTO nya_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Pamodzi ndi ngʼombe yayimunayo, nkhosa yayimunayo ndi ana ankhosawo, muzipereka chopereka cha chakudya ndi chakumwa molingana ndi chiwerengero cha nyamazo. ");
INSERT INTO nya_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Muziperekanso mbuzi imodzi yayimuna ya nsembe yopepesera machimo, powonjezera pa nsembe yopsereza ya tsiku ndi tsiku pamodzi ndi chopereka chake cha chakudya ndi chakumwa. ");
INSERT INTO nya_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘Kuwonjezera pa zopereka zimene munalumbirira ndi pa zopereka zanu zaufulu, muzipereka zimenezi kwa Yehova pa masiku osankhika a chikondwerero chanu. Nsembe zanu zachakumwa ndi nsembe zanu zachiyanjano.’ ” ");
INSERT INTO nya_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Mose anawuza Aisraeli zonse zimene Yehova anamulamulira. ");
INSERT INTO nya_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Mose anawuza Aisraeli onse zonse zimene Yehova anamulamula. Iye anati, “Zimene Yehova walamula ndi izi: ");
INSERT INTO nya_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Munthu wamwamuna ngati walonjeza kwa Yehova kapena kulumbira kuti adzachita zimene walumbirazo, asaphwanye mawuwo koma ayenera kuchita chilichonse chimene wanena. ");
INSERT INTO nya_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Pamene munthu wamkazi amene akukhalabe mʼnyumba ya abambo ake alumbira kwa Yehova kuti adzachita zimene walonjeza pa ubwana wake, ");
INSERT INTO nya_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","abambo ake namva kulumbira kwakeko kapena kulonjeza kwake kuti adzachitadi, ndipo abambo akewo wosayankhula kanthu, mkaziyo achitedi zomwe analumbirazo. Ayenera kudzachita zonse zimene walonjeza zija. ");
INSERT INTO nya_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Koma ngati abambo akewo amva kulumbira kwake ndi kumukaniza, palibe lamulo lomukakamiza mkaziyo kuchita zimene walonjeza. Yehova adzamukhululukira chifukwa abambo ake anamukaniza. ");
INSERT INTO nya_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Ngati akwatiwa atalumbira kale kapena ngati alonjeza mofulumira ndi pakamwa pake, ");
INSERT INTO nya_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","mwamuna wake ndi kumva kulumbira kwakeko koma wosanenapo kanthu, mkaziyo achitedi zomwe walumbirazo. Achite ndithu zomwe walonjeza zija. ");
INSERT INTO nya_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Koma ngati mwamuna wake amuletsa atamva kulumbira kwakeko, pamenepo amumasula mayiyo ku zimene analumbira komanso ku zimene analonjeza mosaganiza bwinozo ndipo Yehova adzamukhululukira. ");
INSERT INTO nya_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Mayi wamasiye kapena wosiyidwa ukwati akalumbira kapena kulonjeza kuti adzachita kanthu kalikonse, ayenera kukachitadi. ");
INSERT INTO nya_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Koma ngati mayi wokwatiwa alumbira nalonjeza kuti adzachitadi zimene walonjeza, ");
INSERT INTO nya_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","mwamuna wake ndi kumva kulumbira kwakeko koma osayankhulapo kanthu, osamuletsa, ayenera kuchitadi zonse zimene walumbira ndi zonse zimene walonjeza. ");
INSERT INTO nya_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Koma ngati mwamuna wake amva ndi kumuletsa kuti asachite zomwe walumbirazo, palibe lamulo lomukakamiza mayiyo kuchita zomwe walumbirazo kapenanso zimene walonjeza. Popeza mwamuna wake wamuletsa, Yehova adzamukhululukira mayiyo. ");
INSERT INTO nya_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Mwamuna wake ali ndi mphamvu zovomereza kapena kukana zimene mayiyo walumbira kapena zimene walonjeza zokhudza kudzilanga yekha. ");
INSERT INTO nya_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Ndipo ngati mmawa mwake ndi masiku otsatira mwamuna wake sanenapo kanthu atamva zimenezi, mayiyo achitedi zimene walumbira kapena zimene walonjeza. Mwamunayo wavomereza zimenezo, chifukwa sanamuwuze kanthu mayiyo pa tsiku limene anamva akulonjeza kapena kulumbira. ");
INSERT INTO nya_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Koma ngati mwamunayo amukaniza patapita kanthawi atazimva kale, iyeyo ndiye wochimwa mʼmalo mwa mayiyo.” ");
INSERT INTO nya_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Awa ndiwo malamulo amene Yehova analamula Mose za mwamuna ndi mkazi wake, ndiponso abambo ndi mwana wawo wamkazi amene akanali mtsikana wokhalabe mʼnyumba ya abambo akewo. ");
INSERT INTO nya_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Uwabwezere zoyipa Amidiyani chifukwa cha zimene anachitira Aisraeli. Ukatha kuchita zimenezi, iwe udzamwalira.” ");
INSERT INTO nya_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Ndipo Mose anati kwa Aisraeli, “Perekani zida kwa ena mwa anthu anu kuti akamenyane ndi Amidiyani ndi kuwabwezera choyipa mʼmalo mwa Yehova. ");
INSERT INTO nya_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Mutumize ku nkhondoko amuna 1,000 kuchokera ku fuko lililonse la Aisraeli.” ");
INSERT INTO nya_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Choncho amuna okwana 12,000 anatenga zida kukonzekera nkhondo, anthu 1,000 kuchokera ku fuko lililonse la Aisraeli. ");
INSERT INTO nya_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Mose anawatumiza ku nkhondo, anthu 1,000 kuchokera ku fuko lililonse pamodzi ndi Finehasi mwana wa Eliezara wansembe amene ananyamula zipangizo zochokera ku malo wopatulika ndi malipenga okaliza. ");
INSERT INTO nya_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Iwo anamenyana ndi Amidiyani monga momwe Yehova analamulira Mose ndipo anapha mwamuna aliyense. ");
INSERT INTO nya_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Mwa anthu ophedwawo munali Evi, Rekemu, Zuri, Huri ndi Reba, mafumu asanu a Amidiyani. Ndipo anaphanso ndi lupanga Balaamu mwana wa Beori. ");
INSERT INTO nya_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Aisraeli anagwira ukapolo amayi a Chimidiyani ndi ana awo ndipo analandanso ngʼombe, ziweto zawo zina zonse ndi katundu wawo yense. ");
INSERT INTO nya_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Anawotcha mizinda yonse imene Amidiyani ankakhalamo pamodzi ndi misasa yawo yonse. ");
INSERT INTO nya_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Anatenga zonse zimene analanda ku nkhondoko, anthu ndi zoweta zomwe. ");
INSERT INTO nya_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Ndipo anabwera nawo akapolowo ndi zolanda ku nkhondozo kwa Mose ndi kwa wansembe Eliezara ndi kwa gulu lonse la Aisraeli ku misasa yawo ku chigwa cha Mowabu, mʼmbali mwa mtsinje wa Yorodani ku Yeriko. ");
INSERT INTO nya_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Mose, wansembe Eliezara ndi atsogoleri onse a gululo anapita kukakumana nawo kunja kwa misasa. ");
INSERT INTO nya_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Mose anakwiya nawo akuluakulu a magulu a ankhondowo: olamulira 1,000 ndi olamulira 100, amene ankachokera ku nkhondo. ");
INSERT INTO nya_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Iye anafunsa kuti, “Kodi nʼchifukwa chiyani mwawaleka amoyo amayi onsewa?” ");
INSERT INTO nya_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Paja iwo ndi amene ankatsatira uphungu wa Balaamu ndiponso ndi amene anachititsa Aisraeli kuti asiye Yehova pa zimene zinachitika ku Peori, kotero mliri unagwera anthu a Yehova. ");
INSERT INTO nya_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Tsopano iphani munthu wamwamuna aliyense. Ndiponso iphani mayi aliyense amene anagonapo ndi mwamuna, ");
INSERT INTO nya_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","koma sungani mtsikana aliyense amene sanagonepo ndi mwamuna. ");
INSERT INTO nya_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Inu nonse amene mwaphapo wina wake, kapena kukhudza aliyense amene anaphedwa mukhale kunja kwa msasa masiku asanu ndi awiri. Pa tsiku lachitatu mudziyeretse nokha pamodzi ndi akapolo anu. ");
INSERT INTO nya_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Muyeretsenso zovala zanu ndi china chilichonse chopangidwa ndi chikopa, ubweya wa mbuzi kapenanso ndi mtengo.” ");
INSERT INTO nya_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Tsono wansembe Eliezara anati kwa asilikali amene anapita ku nkhondo aja, “Lamulo limene Yehova anapereka kwa Mose ndi ili: ");
INSERT INTO nya_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Golide, siliva, mkuwa, chitsulo, chiwaya, mtovu ");
INSERT INTO nya_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ndi china chilichonse chimene sichingapse ndi moto muchidutsitse pa moto, ndipo chidzayeretsedwa. Komanso chiyeretsedwe ndi madzi oyeretsa. Ndipo chilichonse chimene chingapse ndi moto muchidutsitse mʼmadzimo. ");
INSERT INTO nya_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Pa tsiku lachisanu ndi chiwiri muchape zovala zanu ndipo mudzayera. Mukatero mutha kulowa mu msasa.” ");
INSERT INTO nya_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Iwe ndi wansembe Eliezara ndiponso akuluakulu a mabanja a anthuwa, muwerenge anthu onse ndi ziweto zomwe zinagwidwa ku nkhondo. ");
INSERT INTO nya_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Mugawe zolanda ku nkhondozo magawo awiri, lina la ankhondo amene anapita ku nkhondo, lina la anthu onse. ");
INSERT INTO nya_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Pa gawo la ankhondowo, mutengeko gawo la Yehova, pa zofunkha 500 zilizonse mutengeko chimodzi, pa akapolo, ngʼombe, bulu ndi nkhosa. ");
INSERT INTO nya_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Utenge zimenezo pa theka la gawo la ankhondowo ndipo upereke kwa wansembe Eliezara kuti zikhale zopereka zanu kwa Yehova. ");
INSERT INTO nya_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Kuchokera pa theka la gawo la Aisraeli, utengeko cholanda chimodzi pa makumi asanu aliwonse, pa anthu, ngʼombe, abulu, nkhosa, mbuzi kapena zoweta zina. Uzipereke kwa Alevi amene ntchito yawo ndi yosamalira tenti ya Yehova.” ");
INSERT INTO nya_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Ndipo Mose ndi wansembe Eliezara anachita monga Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Zotsala pa zolanda ku nkhondo zimene ankhondowo anatenga zinali nkhosa 675,000, ");
INSERT INTO nya_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","Ngʼombe 72,000, ");
INSERT INTO nya_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","abulu 61,000, ");
INSERT INTO nya_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ndi atsikana omwe sanagonepo ndi mwamuna 32,000. ");
INSERT INTO nya_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Gawo la ankhondo amene anapita ku nkhondo linali: nkhosa 337,500, ");
INSERT INTO nya_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","mwa zimenezi gawo la Yehova linali 675; ");
INSERT INTO nya_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","ngʼombe zinalipo 36,000 ndipo gawo la Yehova linali 72; ");
INSERT INTO nya_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","abulu analipo 30,500 ndipo gawo la Yehova linali 61; ");
INSERT INTO nya_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","anthu analipo 16,000 ndipo gawo la Yehova linali 32. ");
INSERT INTO nya_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Mose anapereka kwa wansembe Eliezara gawo limene linali loyenera kupereka kwa Yehova monga momwe Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Pa gawo la Aisraeli, Mose anapatula theka limodzi kuchotsa pa zolanda ku nkhondo zonse zimene zinabwera ndi ankhondo aja. ");
INSERT INTO nya_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","Tsono gawo la Aisraeli linali ili: nkhosa 337,500, ");
INSERT INTO nya_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","ngʼombe 36,000, ");
INSERT INTO nya_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","abulu 30,500, ");
INSERT INTO nya_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","anthu 16,000. ");
INSERT INTO nya_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Kuchoka pa gawo la Aisraelilo, Mose anatengapo chimodzi pa zolanda ku nkhondo makumi asanu aliwonse, anthu ndi nyama, ndipo anazipereka kwa Alevi amene ankayangʼanira tenti ya Yehova monga Yehova analamulira Mose. ");
INSERT INTO nya_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Pamenepo omwe ankayangʼanira magulu a ankhondo olamulira 1,000 ndi olamulira 100 anabwera kwa Mose, ");
INSERT INTO nya_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","iwo anati kwa iye, “Ife anthu anu tawerenga ankhondo amene timawalamulira. Palibe munthu ndi mmodzi yemwe amene wasowa. ");
INSERT INTO nya_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Ndipo tabweretsa zopereka kwa Yehova zimene munthu aliyense anapeza: ziwiya zagolide, zibangiri, zigwinjiri, mphete zosindikizira, ndolo ndi mikanda kuti tichitire mwambo wopepesera machimo pamaso pa Yehova.” ");
INSERT INTO nya_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Ndipo Mose ndi wansembe Eliezara analandira kuchokera kwa atsogoleriwo golide pamodzi ndi zipangizo zonse zosula. ");
INSERT INTO nya_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Golide yense wochokera kwa atsogoleri a 1,000 ndi atsogoleri a 100 zomwe Mose ndi Eliezara anapereka ngati mphatso kwa Yehova zinali zolemera makilogalamu 200. ");
INSERT INTO nya_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Wankhondo aliyense anatenga zomwe analanda yekha ku nkhondo. ");
INSERT INTO nya_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Mose ndi Eliezara wansembe analandira golide kuchokera kwa atsogoleri a 1,000 ndi atsogoleri a 100 ndi kukamuyika mu tenti ya msonkhano ngati chikumbutso cha Aisraeli pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Arubeni ndi Agadi amene anali ndi ngʼombe zambiri ndi ziweto zina anaona dziko la Yazeri ndi la Giliyadi kuti linali labwino kwa ziwetozo. ");
INSERT INTO nya_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Choncho Arubeni ndi Agadi anapita kwa Mose ndi kwa wansembe Eliezara ndi kwa atsogoleri a anthu ndi kunena kuti, ");
INSERT INTO nya_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Ataroti, Diboni, Yazeri, Nimira, Hesiboni, Eleali, Sebamu, Nebo ndi Beoni, ");
INSERT INTO nya_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","dziko lomwe Yehova anagonjetsa pamaso pa Aisraeli, ndiwo malo woyenera ziweto, ndipo atumiki anufe tili ndi ziweto. ");
INSERT INTO nya_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Iwo anati, ‘Ngati tapeza ufulu pamaso panu atumiki anufe, mutipatse dziko limeneli kuti likhale lathu. Tisawoloke nanu Yorodani.’ ” ");
INSERT INTO nya_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Ndipo Mose anati kwa Agadi ndi Arubeni, “Kodi anthu a mtundu wanu apite ku nkhondo inu mutangokhala kuno? ");
INSERT INTO nya_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Chifukwa chiyani mukufowoketsa Aisraeli kupita mʼdziko limene Yehova wawapatsa? ");
INSERT INTO nya_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Izi ndi zimene makolo anu anachita pamene ndinawatuma kuchokera ku Kadesi kukaona dzikolo. ");
INSERT INTO nya_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Atapita ku chigwa cha Esikolo, ndi kuliona dzikolo, anafowoketsa Aisraeli kuti asalowe mʼdziko limene Yehova anawapatsa. ");
INSERT INTO nya_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Yehova anakwiya tsiku limenelo ndipo analumbira kuti, ");
INSERT INTO nya_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Chifukwa sananditsatire ndi mtima wonse, palibe ndi mmodzi yemwe mwa amuna a zaka makumi awiri kapena kuposa pamenepo, amene anachokera ku Igupto, amene adzaone dziko limene ndinalonjeza mwa lumbiro kwa Abrahamu, Isake ndi Yakobo. ");
INSERT INTO nya_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Palibe ndi mmodzi yemwe kupatula Kalebe mwana wa Yefune, Mkeni, ndi Yoswa mwana wa Nuni chifukwa anatsatira Yehova ndi mtima wonse.’ ");
INSERT INTO nya_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Yehova anakwiyira Aisraeli kwambiri ndipo anawachititsa kuyenda mʼchipululu zaka makumi anayi, mpaka mʼbado wonse wa anthu amene anachita choyipa pamaso pake unatha. ");
INSERT INTO nya_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“Ndipo onani tsopano, inu mʼbado wochimwa, mwalowa mʼmalo mwa makolo anu ndipo mwachititsa kuti Yehova akwiyire Israeli kwambiri. ");
INSERT INTO nya_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Ngati muleka kumutsata, Iye adzawasiyiranso anthu onsewa mʼchipululu ndipo mudzawonongetsa anthu onsewa.” ");
INSERT INTO nya_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Ndipo iwo anabwera kwa Mose namuwuza kuti, “Ife tikufuna kumanga makola a ziweto zathu kuno ndi mizinda yokhalamo akazi athu ndi ana athu. ");
INSERT INTO nya_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Koma ndife okonzeka kutenga zida za nkhondo ndi kupita pamodzi ndi Aisraeli mpaka titakawafikitsa ku malo awo. Panopa, akazi ndi ana athu akhala mʼmizinda yotetezedwa, kuwateteza kwa anthu okhala mʼdzikoli. ");
INSERT INTO nya_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Sitidzabwerera ku midzi yathu mpaka Mwisraeli aliyense atalandira cholowa chake. ");
INSERT INTO nya_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Sitidzalandira cholowa chilichonse pamodzi nawo ku tsidya lina la Yorodani, chifukwa cholowa chathu tachipezera ku tsidya lino la kummawa kwa Yorodani.” ");
INSERT INTO nya_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Tsono Mose anati kwa anthuwo, “Ngati inu mudzachita zimenezi, kutenga zida zankhondo pamaso pa Yehova kuti muchite nkhondo, ");
INSERT INTO nya_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ndipo ngati nonsenu mudzapita ndi zida kuwoloka Yorodani pamaso pa Yehova mpaka atachotsa adani ake pamaso pake, ");
INSERT INTO nya_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","dzikolo nʼkugonja pamaso pa Yehova, mudzabwera ndi kukhala mfulu pamaso pa Yehova ndi Aisraeli. Ndipo dziko lino lidzakhala lanu pamaso pa Yehova. ");
INSERT INTO nya_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“Koma mukalephera kuchita izi, mudzakhala mukuchimwira Yehova. Ndipo dziwani kuti tchimo lanu lidzakupezani. ");
INSERT INTO nya_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Amangireni akazi ndi ana anu mizinda, mangani makola a ziweto zanu, koma chitani zomwe mwalonjeza.” ");
INSERT INTO nya_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Agadi ndi Arubeni anati kwa Mose, “Ife antchito anu tidzachita monga mbuye wathu mwalamulira. ");
INSERT INTO nya_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Ana ndi akazi athu, ziweto zathu zina ndi ngʼombe zidzatsala kuno ku mizinda ya Giliyadi, ");
INSERT INTO nya_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","koma antchito anufe, mwamuna aliyense amene ali ndi chida cha nkhondo, adzawoloka kukamenya nkhondo pamaso pa Yehova monga mbuye wathu wanenera.” ");
INSERT INTO nya_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Choncho Mose anapereka malamulo awa kwa wansembe Eliezara, kwa Yoswa mwana wa Nuni ndi kwa akulu a mafuko a Aisraeli. ");
INSERT INTO nya_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Mose anawawuza kuti, ngati Agadi ndi Arubeni, mwamuna aliyense wokonzekera nkhondo, awoloka Yorodani pamodzi ndi inu pamaso pa Yehova, ndipo dzikolo nʼkugonjetsedwa pamaso panu, mudzawapatse dziko la Giliyadi kukhala lawo. ");
INSERT INTO nya_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Koma ngati sawoloka pamodzi nanu ndi zida zankhondo, ayenera kulandira cholowa chawo pamodzi ndi inu ku Kanaani. ");
INSERT INTO nya_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Agadi ndi Arubeni anayankha kuti, “Antchito anu adzachita zimene Yehova wanena. ");
INSERT INTO nya_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Tidzawoloka pamaso pa Yehova ndipo tidzalowa mu Kanaani ndi zida zankhondo, koma cholowa chathu chidzakhala ku tsidya lino la Yorodani.” ");
INSERT INTO nya_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Choncho Mose anapatsa Agadi, Arubeni ndi theka la fuko la Manase mwana wa Yosefe dziko la Sihoni mfumu ya Aamori ndi dziko la Ogi, mfumu ya ku Basani, dziko lonse, mizinda yake ndi midzi yowazungulira. ");
INSERT INTO nya_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Agadi anamanga Diboni, Ataroti, Aroeri, ");
INSERT INTO nya_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atiroti-Sofani, Yazeri, Yogibeha, ");
INSERT INTO nya_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beti-Nimira ndi Beti-Harani mizinda ya malinga. Anamanganso makola a ziweto zawo. ");
INSERT INTO nya_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Ndipo Arubeni anamanga Hesiboni, Eleali, Kiriataimu, ");
INSERT INTO nya_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo ndi Baala-Meoni (mayina awa anasinthidwa) ndi Sibima. Anapereka mayina ku mizinda ina yomwe anamangayo. ");
INSERT INTO nya_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Zidzukulu za Makiri mwana wa Manase zinapita ku Giliyadi kulanda mzindawo ndi kuthamangitsira kunja Aamori omwe anali kumeneko. ");
INSERT INTO nya_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Tsono Mose anapereka Giliyadi kwa Amakiri, ana a Manase, ndipo anakhala kumeneko. ");
INSERT INTO nya_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Yairi, mwana wa Manase analanda midzi yambiri ya Giliyadi ndi kuyitcha kuti Havoti-Yairi. ");
INSERT INTO nya_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Ndipo Noba analanda Kenati ndi midzi yozungulira ndi kuyitcha Noba, kutengera dzina la iye mwini. ");
INSERT INTO nya_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Malo otsatirawa ndi omwe Aisraeli anayima pa maulendo awo atatuluka mʼdziko la Igupto mʼmagulu awo motsogozedwa ndi Mose ndi Aaroni. ");
INSERT INTO nya_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Mose analemba malo amene anayambira maulendo awo molamulidwa ndi Yehova. Maulendo awo ndi malo omwe anayambira ndi awa: ");
INSERT INTO nya_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Aisraeli ananyamuka kuchokera ku Ramesesi pa tsiku la 15 la mwezi woyamba, itangotha Paska. Iwo anatuluka nayenda molimba mtima Aigupto onse akuona, ");
INSERT INTO nya_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","pamene ankayika maliro a ana awo oyamba kubadwa, omwe Yehova anawakantha pakati pawo chifukwa Yehova anaweruza milungu yawo. ");
INSERT INTO nya_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Aisraeli atachoka ku Ramesesi, anamanga misasa yawo ku Sukoti. ");
INSERT INTO nya_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Atachoka ku Sukoti anakamanga misasa yawo ku Etamu, mʼmbali mwa chipululu. ");
INSERT INTO nya_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Ndipo atachoka ku Etamu, anabwerera ku Pihahiroti, kummawa kwa Baala-Zefoni, ndipo anamanga misasa yawo pafupi ndi Migidoli. ");
INSERT INTO nya_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Atachoka ku Pihahiroti anadutsa mʼkati mwa nyanja kupita ku chipululu ndipo atayenda masiku atatu mʼchipululu cha Etamu, anamanga misasa yawo ku Mara. ");
INSERT INTO nya_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Atachoka ku Mara anafika ku Elimu, kumene kunali akasupe a madzi khumi ndi awiri ndi mitengo ya migwalangwa 70 ndipo anamanga misasa yawo kumeneko. ");
INSERT INTO nya_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Atachoka ku Elimu anakamanga misasa yawo mʼmbali mwa Nyanja Yofiira. ");
INSERT INTO nya_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Atachoka ku Nyanja Yofiira anakamanga misasa yawo mʼchipululu cha Sini. ");
INSERT INTO nya_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Atachoka ku chipululu cha Sini anakamanga ku Dofika. ");
INSERT INTO nya_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Atachoka ku Dofika anakamanga misasa yawo ku Alusi. ");
INSERT INTO nya_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Atachoka ku Alusi anakamanga misasa yawo ku Refidimu, kumene kunalibe madzi woti anthu ndi kumwa. ");
INSERT INTO nya_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Atachoka ku Refidimu anakamanga ku chipululu cha Sinai ");
INSERT INTO nya_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Atachoka ku chipululu cha Sinai anakamanga misasa yawo ku Kiburoti-Hataava. ");
INSERT INTO nya_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Atachoka ku Kiburoti-Hataava anakamanga misasa yawo ku Heziroti. ");
INSERT INTO nya_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Atachoka ku Heziroti anakamanga ku Ritima. ");
INSERT INTO nya_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Atachoka ku Ritima anakamanga ku Rimoni-Perezi. ");
INSERT INTO nya_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Atachoka ku Rimoni-Perezi anakamanga ku Libina. ");
INSERT INTO nya_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Atachoka ku Libina anakamanga ku Risa. ");
INSERT INTO nya_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Atachoka ku Risa anakamanga ku Kehelata. ");
INSERT INTO nya_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Atachoka ku Kehelata anakamanga ku phiri la Seferi. ");
INSERT INTO nya_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Atachoka ku phiri la Seferi anakamanga ku Harada. ");
INSERT INTO nya_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Atachoka ku Harada anakamanga ku Mekheloti. ");
INSERT INTO nya_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Atachoka ku Mekheloti anakamanga ku Tahati. ");
INSERT INTO nya_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Atachoka ku Tahati anakamanga ku Tera. ");
INSERT INTO nya_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Atachoka ku Tera anakamanga ku Mitika. ");
INSERT INTO nya_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Atachoka ku Mitika anakamanga ku Hasimona. ");
INSERT INTO nya_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Atachoka ku Hasimona anakamanga ku Moseroti. ");
INSERT INTO nya_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Atachoka ku Moseroti anakamanga ku Beni Yaakani. ");
INSERT INTO nya_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Atachoka ku Beni Yaakani anakamanga ku Hori-Hagidigadi. ");
INSERT INTO nya_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Atachoka ku Hori-Hagidigadi anakamanga ku Yotibata. ");
INSERT INTO nya_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Atachoka ku Yotibata anakamanga ku Abirona. ");
INSERT INTO nya_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Atachoka ku Abirona anakamanga ku Ezioni-Geberi. ");
INSERT INTO nya_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Atachoka ku Ezioni-Geberi anakamanga ku Kadesi, mʼchipululu cha Zini chimene ndi Kadesi. ");
INSERT INTO nya_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Anachoka ku Kadesi ndi kukamanga ku phiri la Hori, mʼmalire mwa dziko la Edomu. ");
INSERT INTO nya_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Molamulidwa ndi Yehova, wansembe Aaroni anakwera ku phiri la Hori kumene anakamwalirira pa tsiku loyamba la mwezi wachisanu, mʼchaka cha makumi anayi, Aisraeli atatuluka mʼdziko la Igupto. ");
INSERT INTO nya_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aaroni anamwalira pa phiri la Hori ali ndi zaka 123. ");
INSERT INTO nya_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Mfumu ya Akanaani ya ku Aradi yomwe inkakhala ku Negevi kummwera kwa Kanaani, inamva kuti Aisraeli akubwera. ");
INSERT INTO nya_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Atachoka ku phiri la Hori anakamanga ku Zalimoni. ");
INSERT INTO nya_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Atachoka ku Zalimoni anakamanga ku Punoni. ");
INSERT INTO nya_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Atachoka ku Punoni anakamanga ku Oboti. ");
INSERT INTO nya_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Atachoka ku Oboti anakamanga ku Iye-Abarimu. ");
INSERT INTO nya_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Atachoka ku Iye-Abarimu anakamanga ku Diboni Gadi. ");
INSERT INTO nya_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Atachoka ku Diboni Gadi anakamanga ku Alimoni-Dibulataimu. ");
INSERT INTO nya_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Atachoka ku Alimoni-Dibulataimu anakamanga mʼmapiri a Abarimu, pafupi ndi Nebo. ");
INSERT INTO nya_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Atachoka ku mapiri a Abarimu anakamanga ku zigwa za Mowabu mʼmbali mwa Yorodani moyangʼanana ndi Yeriko. ");
INSERT INTO nya_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Ali ku zigwa za Mowabu anamanga mʼmbali mwa Yorodani kuchokera ku Beti-Yesimoti mpaka ku Abeli-Sitimu. ");
INSERT INTO nya_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Pa zigwa za Mowabu, mʼmbali mwa Yorodani moyangʼanana ndi ku Yeriko, Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Nena kwa Aisraeli kuti, ‘Pamene muwoloka Yorodani kulowa mʼdziko la Kanaani, ");
INSERT INTO nya_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","mukathamangitse nzika zonse za mʼdzikomo pamaso panu. Mukawononge mafano awo onse a miyala ndi osula ndi malo awo achipembedzo. ");
INSERT INTO nya_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Mukalande dzikolo ndi kukhalamo chifukwa ndakupatsani dziko limenelo kuti mukhalemo. ");
INSERT INTO nya_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Mukagawane dzikolo pochita maere monga mwa mafuko anu. Kwa omwe ali ambiri, cholowa chambiri, ndipo amene ali ocheperapo, chocheperanso. Chilichonse chimene chidzawagwere iwo mwa maere chidzakhala chawo. Mukaligawane monga mwa mafuko a makolo anu. ");
INSERT INTO nya_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ ‘Koma ngati simukathamangitsa nzika zimene zili mʼdzikomo, amene mukawalole kukhalamo adzakhala ngati zisonga mʼmaso mwanu ndi ngati minga mʼmbali mwanu. Adzakubweretserani mavuto mʼdziko limene mudzakhalemolo. ");
INSERT INTO nya_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Ndipo pamenepo ndidzachitira inu zomwe ndinaganiza kuwachitira iwowo.’ ” ");
INSERT INTO nya_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Lamula Aisraeli ndipo uwawuze kuti, ‘Pamene mulowa mʼdziko la Kanaani, dziko lomwe lidzaperekedwa kwa inu ngati cholowa chanu, lidzakhale ndi malire awa: ");
INSERT INTO nya_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“ ‘Chigawo cha kummwera kwa dziko lanu chidzayambira ku chipululu cha Zini motsatana ndi malire a Edomu. Kummawa malire anu a kummwera adzayambira kummawa, kumathero a Nyanja ya Mchere. ");
INSERT INTO nya_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Malirewo adzapita kummwera ndipo adzakwera phiri la Akirabimu mpaka ku Zini. Mathero ake adzakhala kummwera kwa Kadesi-Baranea. Ndipo adzapitenso ku Hazari Adari mpaka kukafika ku Azimoni, ");
INSERT INTO nya_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","kumene malirewo adzakhote kuchokera ku Azimoni mpaka ku khwawa la ku Igupto ndi kukathera ku Nyanja Yayikulu. ");
INSERT INTO nya_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“ ‘Malire anu a ku madzulo adzakhala ku gombe la Nyanja Yayikulu. Amenewo ndiwo adzakhale malire anu a ku madzulo. ");
INSERT INTO nya_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“ ‘Malire anu a kumpoto, mzere wake uyambire ku Nyanja Yayikulu mpaka ku phiri la Hori ");
INSERT INTO nya_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","ndi kuchokera ku phiri la Hori mpaka ku Lebo Hamati. Malirewa apite ku Zedadi, ");
INSERT INTO nya_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ndi kupitirira mpaka ku Ziforoni ndi kukathera ku Hazari-Enani. Awa ndiwo adzakhale malire anu a kumpoto. ");
INSERT INTO nya_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“ ‘Za malire anu a kummawa, mulembe mzere kuchokera ku Hazari-Enani mpaka kukafika ku Sefamu. ");
INSERT INTO nya_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Malirewo adzatsikire ku Sefamu mpaka ku Ribila cha kummawa kwa Aini ndi kupitirira mpaka ku matsitso a cha kummawa kwa Nyanja ya Kinereti. ");
INSERT INTO nya_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Tsono malirewo adzatsika motsatana ndi Yorodani ndi kukathera ku Nyanja ya Mchere. “ ‘Limeneli lidzakhala dziko lanu ndi malire ake mbali zonse.’ ” ");
INSERT INTO nya_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Ndipo Mose analamula Aisraeli kuti, “Limeneli ndi dziko limene mudzalilandira pochita maere kuti likhale cholowa chanu. Yehova analamula kuti liperekedwe ku mafuko asanu ndi anayi ndi theka, ");
INSERT INTO nya_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","chifukwa mabanja a fuko la Rubeni, fuko la Gadi, ndi theka la fuko la Manase analandiriratu cholowa chawo. ");
INSERT INTO nya_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Mafuko awiriwa pamodzi ndi theka la fuko la Manase analandiriratu cholowa chawo patsidya pa mtsinje wa Yorodani ku Yeriko cha kummawa kotulukira dzuwa.” ");
INSERT INTO nya_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Awa ndi mayina a anthu amene adzakugawireni dzikoli kuti likhale cholowa chanu: wansembe Eliezara ndi Yoswa mwana wa Nuni. ");
INSERT INTO nya_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Musankhe mtsogoleri mmodzi kuchokera ku fuko lililonse kuti athandize kugawa dzikolo. ");
INSERT INTO nya_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Mayina awo ndi awa: Kalebe mwana wa Yefune, wochokera ku fuko la Yuda, ");
INSERT INTO nya_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Semueli mwana wa Amihudi, wochokera ku fuko la Simeoni; ");
INSERT INTO nya_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Elidadi mwana wa Kisiloni, wochokera ku fuko la Benjamini; ");
INSERT INTO nya_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Buki mwana wa Yogili, mtsogoleri wochokera ku fuko la Dani; ");
INSERT INTO nya_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Hanieli mwana wa Efodi, mtsogoleri wochokera ku fuko la Manase, mwana wa Yosefe; ");
INSERT INTO nya_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Kemueli mwana wa Sifitani, mtsogoleri wochokera ku fuko la Efereimu, mwana wa Yosefe. ");
INSERT INTO nya_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Elizafani mwana wa Parinaki, mtsogoleri wochokera ku fuko la Zebuloni; ");
INSERT INTO nya_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Palitieli mwana wa Azani, mtsogoleri wochokera ku fuko la Isakara, ");
INSERT INTO nya_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Ahihudi mwana wa Selomi, mtsogoleri wochokera ku fuko la Aseri; ");
INSERT INTO nya_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Pedaheli mwana wa Amihudi, mtsogoleri wochokera ku fuko la Nafutali.” ");
INSERT INTO nya_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Awa ndiwo mayina a anthu amene Yehova analamula kuti agawe cholowa cha Aisraeli mʼdziko la Kanaani. ");
INSERT INTO nya_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Ku zigwa za Mowabu pafupi ndi Yorodani ku Yeriko, Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Lamula Aisraeli kuti apereke kwa Alevi midzi yoti azikhalamo kuchokera pa cholowa chomwe adzalandira. Muwapatsenso malo oweteramo ziweto kuzungulira midziyo. ");
INSERT INTO nya_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Midziyo idzakhala yawo ndipo azidzakhala mʼmenemo. Malo a msipu adzakhala a ngʼombe, nkhosa ndi zoweta zawo zina zonse. ");
INSERT INTO nya_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“Malo a msipu a mudziwo amene mudzawapatse Aleviwo, adzayambire ku khoma la mudzi ndipo adzatuluke kunja mamita 450, kuzungulira mudziwo. ");
INSERT INTO nya_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Kunja kwa mudzi yezani mamita 900 kummawa, mamita 900 kumpoto ndipo mudziwo ukhale pakati. Adzakhala ndi dera limeneli ngati malo a midziyo, owetera ziweto zawo. ");
INSERT INTO nya_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“Isanu ndi umodzi mwa midzi imene mudzapereke kwa Alevi idzakhala mizinda yopulumukirako, kumene munthu wopha mnzake adzathawireko. Ndipo mudzawapatsenso midzi ina 42. ");
INSERT INTO nya_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Midzi yonse imene mudzapereke kwa Alevi idzakhale 48, pamodzi ndi malo oweterako ziweto. ");
INSERT INTO nya_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Pamene mukupatula midzi imeneyi pa cholowa cha Aisraeli, muchotsepo midzi yambiri pa mafuko aakulu, ndipo midzi pangʼono pa mafuko aangʼono. Fuko lililonse lidzapereka kwa Alevi molingana ndi kukula kwa cholowa chimene lalandira.” ");
INSERT INTO nya_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Ndipo Yehova anawuza Mose kuti, ");
INSERT INTO nya_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Yankhula ndi Aisraeli kuti, ‘Pamene muwoloka Yorodani