﻿USE sofia;
DROP TABLE IF EXISTS sofia.nxl_vpl;
CREATE TABLE nxl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nxl_vpl WRITE;
INSERT INTO nxl_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Mataanoe tunne Anahatana ihaye tau tuniai reini pusiki. ");
INSERT INTO nxl_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Tuniai rei remono wae rewae-wae. Putie hae, putie hae nitae tuniai tewa. Anahatana Ne Inaha ihasa-hasa pusu waene hahae. ");
INSERT INTO nxl_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Anahatana iaisosi tuniai wan repumonoi. Iahata, “Manahane!” Oyo manahane. ");
INSERT INTO nxl_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Inoo tau rei iake. Reiso inea manahane rei rerihoni pumono. ");
INSERT INTO nxl_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Oyo ihete manahane rei tau “Manahane.” Ihete mono rei tau “Pumono.” Nene pumono rei reniku oyo omnanoe. Areimo onone wani mataanoe. ");
INSERT INTO nxl_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Nta iasau osi waene rei, “Asamaya tau ua, asuka suru roe, asuka suru poe.” Reiso rasuka rapusu Anahatana iasau rei. ");
INSERT INTO nxl_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ihete waena uare tihue rei tau “Nante.” Nene onone rei reniku oyo omnanoe. Areimo onona ua nea. ");
INSERT INTO nxl_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Nta iahata, “Waene wapo nante nohue amanoua tau osa na noo tuamane.” Reiso reuna sani Anahatana iasau rei. ");
INSERT INTO nxl_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ihete tuamane rei nanae tau “Ria muni.” Ihete waene wan remanoui rei tau “Nuae.” Inoo tau rei iake. ");
INSERT INTO nxl_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","12","Nta iahata, “Ria muni mo, atuhu waron nita-nitaya oruhu. Oruhu roe, na omi panesi. Atuhu waron nene huaya kania. Aiu waron nene huaya kania.” Oyo raruhu sani Anahatana iaisosi rei. Inoo tau rei iake. ");
INSERT INTO nxl_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Nene onone rei reniku oyo omnanoe. Areimo onona tonu nea. ");
INSERT INTO nxl_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ita iahata, “Wan osita roe nante, ohoka. Wan osita tau manahane, wan osita tau pumono. Osita na oautuu onona, hunana, umetena. Oautuu musum ihata, musum runna. ");
INSERT INTO nxl_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Osita tuniai.” Oyo rasita sani Anahatana iasau rei. ");
INSERT INTO nxl_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","18","Reiso ihaye tau ranie na resita tau manahane, hunane na resita tau pumono. Oneu iae, rasita tau mono. Iautue ranie, hunane, runa oneu na rasita tuniai. Rasita oyo inoo tau rei iake. ");
INSERT INTO nxl_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Nene onone rei reniku oyo omnanoe. Areimo onona ate nea. ");
INSERT INTO nxl_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ita iahata, “Poe waene nosite, poe nuae nosite, ikaya, nunu, runa pusire uture ohoka. Roe nante, manua orihu.” ");
INSERT INTO nxl_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ita iahata, “Poe waene nosite, poe nuae nosite, ikaya, nunu, runa pusire uture ohoka. Roe nante manua orihu.” Inoo tau rei iake. ");
INSERT INTO nxl_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Irui iake osi ikaya, manua pusire iahata, “Osusu haha na ouna nuae, waene, runa nante nohue reini taua.” ");
INSERT INTO nxl_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Nene onone rei ereniku oyo omnanoe. Areimo onona nima nea. ");
INSERT INTO nxl_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ita iahata, “Tuamane ahoka binatang ria muni waron hikina mainaya pusire uture.” Oyo rahoka. ");
INSERT INTO nxl_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Reiso Anahatana iuna binatang pusire oyo inoo tau rei iake. ");
INSERT INTO nxl_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ita iahata, “Mai na ita ihaye tau mansiau pusu ita nitari. Mka sio no kawasa tau ikaya, manua, runa binatang ria muni pusire uture.” ");
INSERT INTO nxl_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Reiso Anahatana ihaye tau mansia nitao sani ia ruai. Ihaye tau ia pina runa ia hanaie. ");
INSERT INTO nxl_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Reiso irui iake osiso iahata, “Osusu haha panesi na orue tau tuniai reini pusiki. Omi mo kawasa tanui. Omi mo kawasa tau ikaya nau nuae, manua roe nante, runa binatang ria muni pusire uture. ");
INSERT INTO nxl_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Urui atuhu pusire uture waron nene kania, nene huaya tau me muaine. ");
INSERT INTO nxl_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ne osi binatang runa manua pusire uture urui monota runa aiu waron nene totua tau nene muaina.” Oyo rapusu ia iasau rei. ");
INSERT INTO nxl_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Inoo pusire uture waron ihaye tanure rei iake mainae. Nene onone rei ereniku oyo omnanoe. Areimo onona nome nea. ");
INSERT INTO nxl_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Reiso Anahatana ihaye tau tuniai reini pusiki. ");
INSERT INTO nxl_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Nene onona nome rai ihaye tau pusire oyo nene onona itu mo, iaranahai nea, na pene ipakarian. ");
INSERT INTO nxl_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Rania hataya rotu-tu mai nene onona itu rai mo, monne. Anahatana irui iake tau onone wan iamuira Anahatana. Tea mo, ranie hatae rei Anahatana ruai iaranahai. Ihaye tau tuniai reini pusi oyo iaranahai. ");
INSERT INTO nxl_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Areini sahoro sou monae rerihoni Yahweh Anahatana ihaye tau tuniai reini pusiki. Ihaye tau tuniai reini pusiki mo, ");
INSERT INTO nxl_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","aiu raruhu mai tuniai reini tewasi, atuhu iae raruhu sui nisiu tewasi. Tea mo, Yahweh Anahatana irati uane tewasi. Ihaye tau mansia na orahuso tewasi. ");
INSERT INTO nxl_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Hasae wae huhuna rania reiso rauna tuamana hahaya rampeta pusire. ");
INSERT INTO nxl_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Taa san rei, oyo Yahweh Anahatana inana tuamane mkane samatoro iposoi na nanie reuna mansia. Iposoi pusi oyo, iauhona ne nusete osiki na ikarihuru iamahai. Iauhona ne nusete pusu okoi, oyo ia mansia rei iamahaiki. ");
INSERT INTO nxl_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ita iuna nisi iake ria ranie matae eresaa ria otoe Eden. Iunai pusi, oyo iautue ia mansia rei ria nisi rei. ");
INSERT INTO nxl_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Oyo iuna aiu waron inoore iaka raruhu ria nisi rei. Aiu waron nene huaya iaire mo, iake. Ria nisi tihue rei aiu ua honu raruhu oi. Ai isa, nene huaya rauna mansiau okarihuru oamahai. Ai isa honu, nene huaya rauna mansiau oanei sae sahoro no hali iake, sae sahoro no hali kahatene. ");
INSERT INTO nxl_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Waene isa renia pusu Eden. Rempeta nisi rei. Renia rotu-tu rehokai nau mui, oyo resamai tau sanana ate. ");
INSERT INTO nxl_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","12","Waene sanae wani mataanoe nanae Pison. Renia rehori tuama Hawila. Pan rei, osupu hunahane isie wani iake tunne runa kama hau rihue. Osupu hatu waron ita-itana oi. ");
INSERT INTO nxl_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Waene sanae isa honu nanae Gihon. Erenia erehori tuama Kus. ");
INSERT INTO nxl_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Waene sanae isa honu nanae Tigris. Erenia pan Asyur napi ranie matae eresaa. Sanane isa honu nanae Efrat. ");
INSERT INTO nxl_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Reiso Yahweh Anahatana iautue ia mansia wain iposoi arihoni tuamane rei na isaka nisi rei na irahui. ");
INSERT INTO nxl_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Yahweh Anahatana iasau osi ia mansia rei. Iahata, “Utapia aai ai huae sae man mai nisi anoe reini. ");
INSERT INTO nxl_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Hasae ai wani nene huaya rauna mansiau oanei sae sahoro no hali iake, sae sahoro no hali kahatene mo, pene aiki. Tea mo, sani aiki ranie hatae reini oyo, mka amataya rei sirinia.” ");
INSERT INTO nxl_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Oyo Yahweh Anahatana iasau pan anoi. Iahata, “Ia mansia reini mo, ruai man mka iake tewa. Kahurae au una ne neta isa wain pannuhu runai na iakahaiki oi.” ");
INSERT INTO nxl_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Reiso inana tuamane mkane samatoro iposo tuamane rei samatoro iunai tau binatang pusire uture runa manua pusire uture. Iposoi samatoro irorire osi ia manisa rei nanie inoore. Inoore na ihete nanaya. ");
INSERT INTO nxl_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Arai sahoro ia mansia rei isima runa binatang runa manua pusire nene nanaya sakakau. Ne binatang rai pusire uture pannuhu runa ia mansia rei tewa. Pannuhu runai tewa na ioi ne neta tanui na iakahaiki tewa. ");
INSERT INTO nxl_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Reiso Yahweh Anahatana iuna ia mansia hanaie rei inekei munui. Inekei munui oyo, ihoka nusui anae isa. Ihokai samatoro isou nusui anae nahae rei tau ne henate. ");
INSERT INTO nxl_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Nusui anae rei, iunai tau ia pina isa oyo iroriki osi ia hanaie rei. ");
INSERT INTO nxl_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Oyo ia mansia rei iasau iahata, “Ira oe! Ia rei sahoro unina-ninai reini tea! Ia sahoro pannuhu runa au. Ne unia arihoni au we unia. Ne henate arihoni au we henate. Reiso uhete nanai tau ia pina. Tea mo, Anahatana inanai arihoni au hanaie.” ");
INSERT INTO nxl_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ia pina pannuhu runa ia hanaie reiso, sio hanaia oeu oarihoni no mansia mainaya na orue okata no pinau. Nooso sani sio tumata osa man. ");
INSERT INTO nxl_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ia pina rei runa ia hanaie rei sanakuso ne oaumaa tewa. ");
INSERT INTO nxl_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Yahweh Anahatana ihaye tau binatang pusire. Pusire mo iaka. Hasae tekene sahoro ianei panesi, ne iakarota. Tekene rei iasei arihoni ia pina rei, “Titue si? Anahatana isopo iahata, ‘Pene oai ai huae sae man wan nisi anoe reini?’” ");
INSERT INTO nxl_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Iahata, “Ami ai ai huaya pusire iake. ");
INSERT INTO nxl_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ne hasae ai isa wani reooi paka nisi tihue mo, aiki tewa. Tea mo, Anahatana isopo. Akahuui man iae, tewa oi. Tea mo, sani aiki te akahuui, mka amatama.” ");
INSERT INTO nxl_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Iahata, “Hmm. Iakarotamo. Ne titue tewa. Omi mka omatamo tewa. ");
INSERT INTO nxl_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Anahatana iasau san rei tau ianei ata mka oai ai huae rei, oyo onoo hainau. Mka omi sani Anahatana. Omi sani Anahatana reiso, oanei sae sahoro mo hali iaka sae sahoro mo hali kahatena.” ");
INSERT INTO nxl_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ia pina rei inoo ai huae rei, inooi marainie, reiso iahata iaiki iae mka iahanai iake. Iasau pan anoi iahata, “Nene iake mo, au uanei panesi.” Reiso ikure ai huae rei oyo iaiki. Iaiki samatoro iruiki osi sahai. Reiso sahai iae iaiki oi. ");
INSERT INTO nxl_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Uaso oaiki suka, oyo onoo hainau. Oanei ata sanakuso. Reiso uaso onana ai ara totua samatoro ohonire. Ohonire oyo oateire. Osou nete no patana. ");
INSERT INTO nxl_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Reiso nene ranie hatae rei tau ranie remanu, oatinu Yahweh Anahatana kinakai pan nisi rei. Reiso uaso oauhuniso sui ai aikuna. Oauhuniso na pene inooso. ");
INSERT INTO nxl_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ne ioi ia hanaie rei. Iahata, “Ano. Ano wani sui supa?” ");
INSERT INTO nxl_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Iahata, “Upu. Uatinu kinakam mai nisi reini so, uauhuniku. Ukaitaua. Tea mo, tenennta.” ");
INSERT INTO nxl_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Iahata, “Ia seia isima ata sanakua rei? Ano aai ai huae wani usopoa rei te sae rei?” ");
INSERT INTO nxl_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Iahata, “Ia pina wain ano aruiki osiku na ikataku rei, sahoro iruiki osiku. Iruiki oyo uaiki.” ");
INSERT INTO nxl_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ita iasei arihoni ia pina rei. “Amuna na auna me hali rei?” Iahata, “Tekene rei sahoro iakarotaku. Reiso uai ai huae rei tea.” ");
INSERT INTO nxl_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Reiso Yahweh Anahatana iasau osi tekene rei san rei. Iahata, “Ano me hali rei, reiso mka uapasanaya. Arihoni binatang pusire hasae ano sahoro urui kahatene osia. Urui kahatene osia rei, ranie hatae reini ro-rotu-tu ria supan ausu tau tiam pokone. Mka ausua pusu tapune hahae ria ro-rotu-tu amataya. ");
INSERT INTO nxl_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ano runa ia pina rei, uamo mka ouna nisa na umau. Ano mea upu momou na ia nea upu momou ohiti nisa na umau. Ano mka arutu upui toui. Ne ia mo, mka iheta poho unumu.” ");
INSERT INTO nxl_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ita iasau osi ia pina rei. Iahata, “Tinaim taua, au mka una resunia. Ia ikine iamrai, au mka una tiam reun mainae. Ne masike tiam ereun san rei iae, anom reoto runa saham sirinia. Masike resunia iae atinu tanui sirinia.” ");
INSERT INTO nxl_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ita iasau osi ia hanaie rei. Iahata, “Ano atinu tau saham, reiso aai ai huae rei wani au usopo unete na pene aiki. Ano apusui reiso uapasanaya. Urui kahatene osi tuamane. Reiso kahurae apakarian eresuni-sunia rotu-tu amataya. Apakarian akahi-kahia samatoro tuamane rei ereuna me atuhu isia iaka tau me muaina. ");
INSERT INTO nxl_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Akahi-kahia tau monota runa awaneu monota waron nene unia. Mka ai utana waron orahure tewa. ");
INSERT INTO nxl_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ne masike ai utana waron orahure tewa iae, mka apakarian mainae tau ruam me kausa wanaya na arahu tuamane reini na asupu me muaina. Me kausa wanaya rotu-tu amataya na ruam auna tuamane honu. Mataanoe uposoa arihoni tuamane, reiso anunia auna tuamane honu.” ");
INSERT INTO nxl_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ia mansia mataanoe rei nanai Adam. Ihete sahai nanai Hawa. Ia pina rei iuna ina tau sio mansiau pusiso, reiso nanai Hawa. Hawa nene nohue, “Iapuhai.” ");
INSERT INTO nxl_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Reiso Yahweh Anahatana iuna apia arihoni binatang unte, samatoro iausahure osi Adam runa sahai uaso. ");
INSERT INTO nxl_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Yahweh Anahatana iahata, “Muie reini mansia nooi sani ita nea. Ianei sae sahoro no hali iaka runa sae sahoro no hali kahatena. Reiso kahurae inetei na pene iai ai huae wani ereuna okarihuru oamahai. Inetei na pene iamahaiki rotu-tu ria supan.” ");
INSERT INTO nxl_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Reiso inei ia mansia rei uaso arihoni Nisi Eden rei. Iaisosiki irahu tau tuamane wani iposoi arihoniki rei. ");
INSERT INTO nxl_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ineiso samatoro iaisosi sio mamsakaya on roe noiyaha osaka nisi rei, napi on ria ranie mata eresaa. Osaka nene mitanunue. Oyo iautue tunue wani ereita-itai. Tunue rei resawai eretope erenete mitanunue rei. Tunue rei runa sio mamsakaya rai nanie osaka arena wani ereeui nau ai wani nene huae ereuna mansia okarihuru oamahai. Reiso iuna san rei na pene ia seia oi ieu haineke ai rei. ");
INSERT INTO nxl_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam inekei ikata sahai Hawa oyo tinain taua. Anai iamrai, ia hanaie. Iamrai poe, Hawa iahata, “Yahweh iakahaiku reiso ususu we ia iki hanaie.” Reiso ihete nanai tau Kain. Nene nohue, “Ususu.” ");
INSERT INTO nxl_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ita ia iki muie isa iamrai honu. Nanai Habel. Uaso sio mainaya, oyo Kain isaka irahu nisi. Ne Habel mo, isaka rompau runa une-uneu. ");
INSERT INTO nxl_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ereeu mai, taue isa Kain inana atuhu oyo iruire osi Yahweh. ");
INSERT INTO nxl_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habel iae san rei oi. Ne ia mo, irui rompau. Rompau anaya manonta. Irui nene minaya. Reiso Yahweh ikaumin runa Habel irui rompau nene minaya rai. ");
INSERT INTO nxl_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ne Kain mo, ipenei iatarimai runa ne atuhu rai. Reiso Kain anoi resaa hun ruai rotu-tu uai anoe remtukui. ");
INSERT INTO nxl_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Reiso Yahweh iasau osi Kain. Iahata, “Amuna na anom resaa rei? Na uam anoe remtukui rei? ");
INSERT INTO nxl_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Sani auna iake, mka uam anoi kaie. Mka anoku iake runaya. Ne sani auna kahatene mo, ainati. Rosa wani rekaohua haineke nea. Ano nanie apalalosa. Ne kahurae apamese anom.” ");
INSERT INTO nxl_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Nene taue isa Kain iasau osi wanin san rei. Iahata, “Mai, na uata ieuta na ria nisi.” Hokaso ria nisi, oyo Kain ihunu wanin. ");
INSERT INTO nxl_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Reiso Yahweh iasei tau Kain, “Wanim Habel wainpa?” Iahata, “Mpanei. Ia seia ianeiki? Au usaka waniku?” ");
INSERT INTO nxl_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Iahata, “Amuna na auna kahatene san rei? Wanim ne nasin wani reasei nea. ");
INSERT INTO nxl_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Au nanie urui kahatene osia, reiso wan uneia arihoni tuamane reini. Tuamane wani reninu wanim ne nasin rei. Tau ahunu wanim, tuamane rei reninu ne nasin. Reiso nanie uapasanaya. ");
INSERT INTO nxl_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Sani nanie arahua, mka atuhu isia tewa. Mka aeu ahori-horia asupu naniam manisate isa tewa mai tuniai reini.” ");
INSERT INTO nxl_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Iahata, “Upu. Ira oe! Mka umataku tea! Apasanaku mainae san rei mana mo, ukua tewa! ");
INSERT INTO nxl_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Aneiku arihoni tuamane reini. Aneiku arihoni uam anoe. Mka uhori-horiku, usupu naniaku mai tuniai reini tewa. Reiso sani ia isa isupuku mka ihunuku.” ");
INSERT INTO nxl_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Iahata, “Tewa. Sani ia isa ihunua, mka ia rei, uapasanai mainae rotu-tu nai itu.” Oyo Yahweh iakakinai na sio umau osupui pene ohunui. ");
INSERT INTO nxl_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Oyo ieui iarihoni Yahweh uai anoe. Iruei pan tuama Nod pan napi ranie mata resaa, pan Eden on pan hae. ");
INSERT INTO nxl_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kain iausahai, oyo sahai uaso osusu no ia iki hanaie isa nanai Henokh. Iamrai poe, Kain wain iapuoo niane isa reiso ihete niane nanae tau Henokh erepusu anai hanaie. ");
INSERT INTO nxl_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ita Henokh iausahai, isusu anai hanaie isa wain nanai Irad. Ita Irad iausahai, isusu anai hanaie wain nanai Mehuyael. Ita Mehuyael iausahai, isusu anai hanaie wain nanai Metusael. Ita Metusael iausahai, isusu anai hanaie wain nanai Lamekh. ");
INSERT INTO nxl_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamekh inana ne pinau ua. Ia isa nanai Ada. Ia isa honu nanai Sila. ");
INSERT INTO nxl_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada isusu Yabal. Ia sahoro nea upu nea momou oapiara makapanau. Orueso tau numau waron onanare arihoni makapana unta. ");
INSERT INTO nxl_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabal wanin nanai Yubal. Ia sahoro nea upu momou oaise sae isa wani nooi sani gitar runa oauhona suling. ");
INSERT INTO nxl_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Lamekh sahai muie Sila isusu Tubal-Kain. Ia sahoro nea upu momou otuka alatiu arihoni tampaka runa mamono. Tubal-Kain hotai nanai Naama. ");
INSERT INTO nxl_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamekh iasau osi ne pinau uaso, irui ruai roe uae. Iahata, “Ada runa Sila uamo. Saka ono-noo au. Sani ia honue isa nanie ihitaku mo, mka uhunui. ");
INSERT INTO nxl_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Sani ia isa ihunu Kain, Anahatana iapasanai mainae nai itu. Mka sani ia isa ihunu au mo, Anahatana iapasanai mainae nai osa, nai hutu itu rahana itu.” ");
INSERT INTO nxl_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam inekei ikata sahai honu. Oyo isusu anai hanaie isa honu. Anai hanaie rei nanai Set. Inai iahata, “Anahatana irui anaku hanaie isa honu ikati Habel wain kakai ihunui.” Set nene nohue, “Irui.” ");
INSERT INTO nxl_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set iausahai oyo isusu anai hanaie isa nanai Enos. Tau muie rei samatoro mansiau oainisi oainaa na Yahweh. ");
INSERT INTO nxl_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Areini sahoro Adam nea upu momou nanao. Mataanoe Anahatana ihaye tau mansiau. Ia mansia rei iroma ruai nitai. ");
INSERT INTO nxl_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ihaye tau mansia mo, ia pina runa ia hanaie. Irui iake osiso. Ioiso tau mansiau. ");
INSERT INTO nxl_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam iruei rotu-tu ne musum 130. Ita isusu anai hanaie isa honu. Nooi sani ia ruai. Ihete nanai tau Set. ");
INSERT INTO nxl_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Adam ikarihuru iamahai rotu-tu musum 800 honu, isusu ne hehuka umau honu. ");
INSERT INTO nxl_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Rotu-tu iruei ne musum 930 samatoro imatai. ");
INSERT INTO nxl_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Tau Set ne musum 105 isusu anai hanaie isa nanai Enos. ");
INSERT INTO nxl_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Set ikarihuru iamahai rotu-tu musum 807 honu, isusu ne hehuka umau honu. ");
INSERT INTO nxl_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Rotu-tu iruei ne musum 912 samatoro imatai. ");
INSERT INTO nxl_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Tau Enos ne musum 90 isusu anai hanaie isa nanai Kenan. ");
INSERT INTO nxl_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enos ikarihuru iamahai rotu-tu musum 815 honu, isusu ne hehuka umau honu. ");
INSERT INTO nxl_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Rotu-tu iruei ne musum 905 samatoro imatai. ");
INSERT INTO nxl_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Tau Kenan ne musum 70 isusu anai hanaie isa nanai Mahalaleel. ");
INSERT INTO nxl_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenan ikarihuru iamahai rotu-tu musum 840 honu, isusu ne hehuka umau honu. ");
INSERT INTO nxl_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Rotu-tu iruei ne musum 910 samatoro imatai. ");
INSERT INTO nxl_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Tau Mahalaleel ne musum 65 isusu anai hanaie isa nanai Yared. ");
INSERT INTO nxl_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalaleel ikarihuru iamahai rotu-tu musum 830 honu, isusu ne hehuka umau honu. ");
INSERT INTO nxl_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Rotu-tu iruei ne musum 895 samatoro imatai. ");
INSERT INTO nxl_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Tau Yared ne musum 162 isusu anai hanaie isa nanai Henokh. ");
INSERT INTO nxl_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yared ikarihuru iamahai rotu-tu musum 800 honu, isusu ne hehuka umau honu. ");
INSERT INTO nxl_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Rotu-tu iruei ne musum 962 samatoro imatai. ");
INSERT INTO nxl_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Tau Henokh ne musum 65 isusu anai hanaie isa nanai Metusalah. ");
INSERT INTO nxl_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Henokh ikarihuru iamahai anoi osa runa Anahatana rotu-tu musum 300 honu, isusu ne hehuka umau honu. ");
INSERT INTO nxl_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Iruei rotu-tu ne musum 365. ");
INSERT INTO nxl_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henokh anoi osa runa Anahatana sui osa reiso, Anahatana iapusaai. Sira tau tutui tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Tau Metusalah ne musum 187 isusu anai hanaie isa nanai Lamekh. ");
INSERT INTO nxl_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Metusalah ikarihuru iamahai rotu-tu musum 782 honu, isusu ne hehuka umau honu. ");
INSERT INTO nxl_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Rotu-tu iruei ne musum 969 samatoro imatai. ");
INSERT INTO nxl_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Tau Lamekh ne musum 182 isusu anai hanaie isa. ");
INSERT INTO nxl_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Iahata, “Ia ikine rei mka irui karahirine osita tau irahuta mai tuamane wan Yahweh irui kahatene tanui.” Reiso Lamekh ihete nanai tau Nuh. Nuh nene nohue, “Karahirine.” ");
INSERT INTO nxl_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamekh ikarihuru iamahai rotu-tu musum 595 honu, isusu ne hehuka umau honu. ");
INSERT INTO nxl_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Rotu-tu iruei ne musum 777 oyo imatai. ");
INSERT INTO nxl_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuh ne musum 500, oyo isusu ne hehuka hanaia tonu. Ia manaonete nanai Sem, ia autihue nanai Yafet, ia muie nanai Ham. ");
INSERT INTO nxl_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Sio mansiau osusu haha, reiso orue ohori pusi tuniai reini. Reiso osusu no sio iki pinau panesi. ");
INSERT INTO nxl_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Sio on roe noiyaha onoo sio pina hehuka rei, sio iaka. Reiso onana sio pina hehuka wason okaumin runaso rei. ");
INSERT INTO nxl_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Yahweh inoo ata sio mansiau no kahatena panesi reiso iahata, “Mka utapi sio mansiau oamahaiso rotu-tu ria supan tewa tau sio opalalosa panesi. Utapiso rotu-tu orue rotu-tu musum utun hutu ua nesi tewa. Kahurae pannuhu musum san rei oyo omataso.” ");
INSERT INTO nxl_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Tau napisi rei runa ereeu sio mansiau, sio noa-noaya mai tuniai reini. Sio reini sahoro rerihoni sio pina hehuka wason onana sio on roe noiyaha rei. Sio noa-noaya rei mo, sio panesi oationaso tau no kawasa mainae tau napisi reini. ");
INSERT INTO nxl_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yahweh inoo sio mai tuniai no kahatena panesi. Hasae anoo ranoo kahatena man. ");
INSERT INTO nxl_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Iatamisi ata ihaye tau mansiau mai tuniai reini nea. Iahana iake pan anoi tewa. ");
INSERT INTO nxl_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Reiso iahata, “Uatamisi ata uhaye tau mansiau runa manua, binatang pusire uture reiso mka uhunu pusiso.” ");
INSERT INTO nxl_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ne Nuh mo, iuna Yahweh anoi iake. ");
INSERT INTO nxl_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Areini sou monae rerihoni Nuh. Nuh anoi manisate. Rerihoni ia ne naene ia sahoro sio mka oasau tewa ata ne isanae. Tea mo, ia ne isanae isa tewa. Anoi osa runa Anahatana. ");
INSERT INTO nxl_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Isusu ne hehuka hanaia tonu. Ia manaonete nanai Sem, ia autihue nanai Yafet, runa ia muie nanai Ham. ");
INSERT INTO nxl_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ne Anahatana inoo sui supan man sio tamena mai tuniai reini ouna kahatena. Oturuhaka, oakakapa. ");
INSERT INTO nxl_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Anahatana inoo mai tuniai reini mo, hasae inoo kahatena ruae man. ");
INSERT INTO nxl_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Reiso iasau osi Nuh. Iahata, “Uapamata sou nea. Nanie uhunu sio mansiau runa binatang pusire uture. Tuniai reini taue runa sio no kahatena rai. Reiso nanie uhunu pusire uture. Nanie uapumoko tuniai reini. ");
INSERT INTO nxl_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Reiso atuka me kapane isa arihoni ai gopir wani makae. Auna nene kakaranaya panesi pan anoe. Apunu aspal mai mui runa pan anoe. ");
INSERT INTO nxl_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Kapane rei kahurae nene naue meteri 133, hekani meteri 22, naue suru roe meteri 13. ");
INSERT INTO nxl_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ainata me kapane rei. Arenu kasunepene hahae ereeu roe ainataya na karate senti 44. Atuka kapane rei, nene napisi tonu. Atuka nene mitanunue isa mai nusue. ");
INSERT INTO nxl_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Mka au una waene eresaa rotu-tu eresau-sau tuamane pusiki. Waene eresau-sau tuamane na erehunu pusi mansiau, manua, binatang pusire uture. Mka ramata pusiso. ");
INSERT INTO nxl_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ne ano mo, mka utotoe runaya. Anusua pan kapane anoe rei akata saham, me hehuka runa no pinau pusiso. ");
INSERT INTO nxl_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Rerihoni manua nitaya pusire, arori manu inae isa runa manu hanaie isa. Rerihoni binatang pusire, arori binatang inae isa runa binatang hanaie isa. ");
INSERT INTO nxl_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Mka pusire uture rahokaso mai tanua na arorire pan kapane anoe na ramahaiso. ");
INSERT INTO nxl_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Arori muaina nitaya pusire na osi ruamo runa binatang runa manua rai pusire uture.” ");
INSERT INTO nxl_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuh inana pusire pusu Anahatana iasau osiki rei. ");
INSERT INTO nxl_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Yahweh iasau osi Nuh, iahata, “Hasae ano sahoro atinu tanuku. Hasae ano sahoro anom manisate. Ne sio pusiso mai tuniai reini oatinu tanuku tewa. Reiso anusua pan kapane anoe. Anusua akata saham, me hehuka tonso runa no pinau. ");
INSERT INTO nxl_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Rerihoni binatang nitaya pusire uture waron oaire iake oakanupure osiku iake, arori pina runa hanaie unua itu. Ne rerihoni waron oamaonre mo, arori unue osa man. ");
INSERT INTO nxl_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Rerihoni manua nitaya pusire uture waron oaire iake, oakanupure osiku iake arori unua itu oi. Ne rerihoni waron oamaonre mo, arori unue osa man. Arorire pan kapane anoe na ramahaiso. ");
INSERT INTO nxl_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Nesie itu rei, una uane mainae rotu-tu onona hutu ate. Au mka uhunu pusi mansiau runa binatang waron uhaye tau pusire rei.” ");
INSERT INTO nxl_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Reiso Nuh iuna sae waron Yahweh iasau osiki rei. ");
INSERT INTO nxl_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Waene eresaa mai tuniai reini mo, Nuh ne musum utun nome. ");
INSERT INTO nxl_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuh runa sahai, ne hehuka tonso, runa no pinau onususo pan kapane anoe rei. Onususo na pene omokoso tau waene eresaa rei. ");
INSERT INTO nxl_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Manua runa binatang nitaya pusire uture ranusu pusire rakata Nuh sio. Ranusu unue erepusu unue. Waroni oaire iake, oakanupure osi Anahatana iake runa waron oamaonre. Ranusu pusu Anahatana iasau rei. ");
INSERT INTO nxl_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ereruma onona itu nau oyo, waene eresaa. Eresou tuniai reini pusiki. ");
INSERT INTO nxl_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nuh ne musum utun nome pannuhu hunana ua umetene wani onona hutusa rahana itu. Oyo wae huhuna rasaa pusire mai tuniai reini. Sira tau waene erenia eresaa suru ria suru nau noo sani waene sanane. On roe nante mo, sira tau waene erenia san rei oi. Noo sani sio ohuka mitanunue wani erenete waene roe nante. ");
INSERT INTO nxl_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Uane rotu-tu onona hutu ate. ");
INSERT INTO nxl_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tau ranie hatae rei Nuh sio pusiso onususo pan kapane rei anoe. ");
INSERT INTO nxl_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","15","Binatang runa manua pusire uture ranusu oi ");
INSERT INTO nxl_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","sani Anahatana iasau rei. Onusu pusiso san rei oyo, Yahweh iraru kapane rei nene mitanunue. ");
INSERT INTO nxl_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","18","Waene eresaa rei rotu-tu onona hutu ate. Waene eresaa mainae reiso kapane rei remamanui. ");
INSERT INTO nxl_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Waene eresaa rotu-tu noo mosa tinetaya tewa nea. Masike tinetaya waron mainaya nai osa iae, noo mosa nene hahaya tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Waene eresaa sui osa reiso ereniku tinetaya waron mainaya rotu-tu meter itu. ");
INSERT INTO nxl_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","Anahatana ihunu pusire waron rakarihuru ramahai mai tuniai reini. Ihunu mansia, manua, binatang pusire uture. Wason ihunso tewa mo, hasae Nuh runa pusire waron ikatare pan kapane anoe rei. ");
INSERT INTO nxl_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Waene rei erekaisunu tewa rotu-tu onona utun hutu nima. ");
INSERT INTO nxl_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Anahatana anoi kanihue runa Nuh tewa. Anoi kanihue runa binatang waron rakatai pan kapane anoe rei tewa. Reiso iuna ihute reuhona pusu tuniai reini. Iuna ihute reuhona na waene erekaisunu. ");
INSERT INTO nxl_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Inete wae huhuna hunaya poe tuamane. Inete waena pusire roe nante. Uane ereminai ");
INSERT INTO nxl_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","oyo waene erekai-kaisunu. Waene erekaisunu rotu-tu onona utun hutu nima oimo, waene nekete mkane nea. ");
INSERT INTO nxl_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Tau hunana itu onona hutusa rahana itu kapane rei erekokiee. Erekokiee roe tinetae hahae pan tinetaya Ararat. ");
INSERT INTO nxl_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Waene erekaisunu sui osa rotu-tu hunana hutusa onone osa, oyo noo mosa tinetaya hahaya nea. Rahotuso nea. ");
INSERT INTO nxl_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ereeu rotu-tu onona hutu ate samatoro Nuh ihuka kapane rei nene sasamata. ");
INSERT INTO nxl_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ihukai nanie ihoka manu gagak. Ihoka manue rei, ne erenuniki mai kapane tewa nea. Ne ererihu suru ria suru nau sui osa rotu-tu waene rei erekaimeniki nai osa. ");
INSERT INTO nxl_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ita Nuh ihoka manu puane, nanie ianei ata kani waene erekaimeniki nea te tewasi. ");
INSERT INTO nxl_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ne waene eresou pusi tuniai reini pusiki reiso manue rei eresupu naniae na retasohoi tewa. Eresupu naniae tewa reiso erenuniki mai kapane rei honu. Erenuniki oyo Nuh iasasona hanai na inotai. Inotai samatoro inusu iroriki mai kapane anoe rei. ");
INSERT INTO nxl_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Inapa rotu-tu onona itu honu, ita ihoka manue rei honu. Ihokai oyo ialapasiki honu. ");
INSERT INTO nxl_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Tau nene ranie manne manue rei erenuniki mai Nuh honu. Erenuniki ererori ai saitun totue isa wani matae asi. Ereroriki tau hohae. Tau rei samatoro Nuh ianei ata waene erekaimeniki nea. ");
INSERT INTO nxl_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ita inapa rotu-tu onona itu honu. Ita ialapasi manue rei honu. Ialapasiki rei oimo, erenuni mai tanui tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nuh ne musum utun nome nesi osa, tau hunane osa, onone osa samatoro waene erekaimeniki ia-ia, Nuh ihuka kapane rei nene ainatae isa oyo inoo sui tihue rei. Ne inoo tihue rei erekaimeniki nea. ");
INSERT INTO nxl_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Tau hunana ua onona hutu ua rahana itu tuniai mo, erekaimeniki nai osa nea. ");
INSERT INTO nxl_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Oyo Anahatana iasau osi Nuh. ");
INSERT INTO nxl_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Iahata, “Ahokaya arihoni kapane rei runa saham na me hehuka na no pinau. ");
INSERT INTO nxl_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ohoka orori manua runa binatang pusire uture. Ohokare na rasusu haha mai tuniai reini.” ");
INSERT INTO nxl_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Reiso Nuh sio ohokaso arihoni kapane anoe rei. ");
INSERT INTO nxl_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Manua runa binatang pusire rahokaso arihoni kapane rei. Rahokaso sakakau. Manu inae erekata manu hanaie. Une-une inae erekata une-une hanaie oi. ");
INSERT INTO nxl_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nuh sio ohokaso oyo irane hatu noore sani anau. Iranere nanie iainisi iainaa runa Yahweh. Oyo inana manu hatae isa runa binatang hatae isa rerihoni manua runa binatang pusire waron iaire iake, iakanupure osi Anahatana iake. Inanare oyo iakanupure roe hatu hahaya rai. ");
INSERT INTO nxl_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Iakanupure oyo Yahweh anoi iake runa hau rihue rei. Reiso iahata, “Au mka urui kahatene osi sio mansiau pusu no kahatena rai tewa nea. Uanei ata on sio honua mo, anoo ranoa kahatena. Au mka uhunu mansiau runa binatang wason okarihuru oamahai sani mato una osiso rei tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Mka musum mamrahue runa mapahia nisi sui osa. Musum mahatane musum titie sui osa. Ihate runa runne sui osa. Pumono runa manahane sui osa rotu-tu tuniai reini erepena.” ");
INSERT INTO nxl_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Anahatana irui iake osi Nuh runa ne hehuka. Iahata, “Asusu haha na moa upu momou panesi. Mka moa upu momou orue sui tuniai reini pusiki. ");
INSERT INTO nxl_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Manua, ikaya runa binatang pusire uture, mka omi mo kawasa tau pusire. Mka rakaitaumo. ");
INSERT INTO nxl_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Rai pusire tau mo muaina sani ai huaya ai totua pusire. Rai pusire uruire osimo tau mo muaina. ");
INSERT INTO nxl_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Hasae usopo na pene oai henate wani nasie asi. Tea mo, inaha mo, wamo nasi rei. ");
INSERT INTO nxl_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Sio mansiau runa binatang wason ohunu mansia mo, kahurae oapasanai. Mka uhunui oi. ");
INSERT INTO nxl_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Tea mo, uhaye tau mansia pusu nitaku. Reiso ia seia ihunu mansia mo, mka mansia ihunui oi. ");
INSERT INTO nxl_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ne omi mo, osusu haha na moa upu momou orue sui tuniai reini pusiki. ");
INSERT INTO nxl_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","9","Atinu. Au nanie utotoe osimo runa moa upu momou. ");
INSERT INTO nxl_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Nanie utotoe runa manua runa binatang pusire uture waron rakatamo pan kapane anoe rei. ");
INSERT INTO nxl_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nanie utotoe san rei: Utotoe na uhunu omi mansiau runa binatang pusire uture pusu waene eresaa sani mato-mato rei tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Nanie urui kakinate osimo. Kakinate na anori rapeka runa sae wani utotoe osimo rei. Utotoe osi omi mansiau runa binatang pusimo utumo. Utotoe rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Reiso kakinate rei, mka uautue tihana roe nante na anori rapeka ata utotoe osimo nea. ");
INSERT INTO nxl_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Sani onoo onoe oyo mka tihana rei, onooi ");
INSERT INTO nxl_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","17","mka anoku repeka runa sae wani utotoe osimo rei. Reiso mka waene eresaa erehunu pusimo utumo san rei tewa nea.” ");
INSERT INTO nxl_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nuh ne hehuka wason osipuso arihoni kapane rei mo: Sem, Yafet, runa Ham. Ham mo, ia Kanaan amai. ");
INSERT INTO nxl_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nuh ne hehuka tonu rei sahoro ouna numa upua tau sio pusiso mai tuniai reini. ");
INSERT INTO nxl_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuh mo, ia mamrahu nisi. Ia sahoro irahu nisi anggur mataanoe. ");
INSERT INTO nxl_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Taue isa Nuh ininu tihu anggur. Reiso imukei. Imukei oyo, inosu pusi ne apia oyo inekei sanakui pan ne numa unte anoe. Ne numa wani sio onanai arihoni makapana unte rei. ");
INSERT INTO nxl_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Inekei isanakui oyo Ham inusu pan numa anoe inoo amai isanakui. Reiso ihokai pan mui isima osi nea kakau uaso. ");
INSERT INTO nxl_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Uaso oatinu san rei oyo, onana papi naue. Onana papite rei, samatoro uaso oaunutui mai manao. Oyo oeu orike totu onusu pan numa rei. Nanie osou noa ama tau papite rei. Uaso orike totu na pene onoo noa ama wain isanakui rei. ");
INSERT INTO nxl_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Imukei suka oyo ianei ata anai hanaie muie ituruhaka iakakapa tanui. ");
INSERT INTO nxl_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Oyo iahata, “Masi amataya! Uainisi na Anahatana irui kahatene osi Kanaan! Mka iuna maniane mainae tau nea kakau uaso. ");
INSERT INTO nxl_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Uainisi uainaa runa Yahweh Anahatana wain Sem iainisi iainaa runai. Kanaan mka iuna maniane tau Sem. ");
INSERT INTO nxl_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Uainisi na Anahatana iuna Yafet isusu haha. Uainisi na nea upu momou orueso okata Sem nea upu momou. Kanaan mka iuna maniane tau Yafet.” ");
INSERT INTO nxl_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Waene erekaisunu suka, Nuh ikarihuru iamahai asi rotu-tu musum 350 honu. ");
INSERT INTO nxl_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Rotu-tu ne musum 950 oyo imatai. ");
INSERT INTO nxl_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Areini sahoro Nuh ne hehuka nea upu momou nanao. Nuh ne hehuka mo, Sem, Yafet runa Ham. Waene erekaisunu suka, oyo tonso osusu haha no hehuka hanaia. ");
INSERT INTO nxl_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafet ne hehuka mo, Gomer, Magog, Madai, Yawan, Tubal, Mesekh runa Tiras. ");
INSERT INTO nxl_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer nea upu momou sahoro orueso pan: Askenas, Rifat runa Togarma. ");
INSERT INTO nxl_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yawan nea upu momou sahoro orueso pan: Elisa, Tarsis, nusa Siprus runa Rodes. ");
INSERT INTO nxl_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Sio rei sahoro noa upu momou orueso pena nusau. Orueso pena nua nusua. Reiso sio rei pusiso sahoro Yafet nea upu momou. Orueso pena ruao no niana. Pena niana waron no sou sakakau. ");
INSERT INTO nxl_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham nea upu momou mo, sio Kus, Mesir, Libia runa sio Kanaan. ");
INSERT INTO nxl_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus nea upu momou mo, sio Seba, Hawila, Sabta, Raema runa sio Sabtekha. Raema nea upu momou mo, sio Syeba runa sio Dedan. ");
INSERT INTO nxl_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus anai hanaie isa nanai Nimrod. Ia sahoro iahita iake inesi sio pusiso mai tuniai reini. ");
INSERT INTO nxl_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Yahweh iakahaiki na iakaohu iake inesi sio pusiso. Reiso sio oasau. Oahata, “Uainisi na Yahweh iunaya akaohu iake sani Nimrod.” ");
INSERT INTO nxl_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Mataanoe Nimrod irime Babel, Erekh runa Akad. Kotau tonu rai waropan otoe Babilonia. ");
INSERT INTO nxl_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","On pan Babilonia ieui na poe otoe Asyur. Hoka poe oyo iapuoo kotau Niniwe, Rehobot-Ir, Kalah ");
INSERT INTO nxl_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","runa Resen. Resen wani kua Niniwe runa Kalah uare tihue. Kota rei mo, kota mainae. ");
INSERT INTO nxl_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mesir nea upu momou mo, sio Lidia, Anamim, Lehabim, Naftuhim, ");
INSERT INTO nxl_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusim, Kasluhim runa sio Kaftorim. Sio Kasluhim noa upu momou tau sio Pilistin. ");
INSERT INTO nxl_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan ne hehuka mo, Sidon, ia manaonete, runa Het, ia muie. ");
INSERT INTO nxl_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kanaan iae nea upu momou tau sio Yebusi, Amori, Girgasi, ");
INSERT INTO nxl_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hewi, Arki, Sini, ");
INSERT INTO nxl_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwadi, Semari runa sio Hamati. Kanaan nea upu momou rei orue osama-samaso ohainau umau. ");
INSERT INTO nxl_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Reiso no tihua rai nene nenena hainau, on pan Sidon ereeu na poe Gerar erehokai haineke Gasa. Hae napi ranie matae eresaa nanie ereeu na ria Sodom, Gomora, Adma runa Seboim, rotu-tu haineke Lasa. ");
INSERT INTO nxl_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Sio rei sahoro Ham nea upu momou. Orue sakakau niana, sakakau sou. ");
INSERT INTO nxl_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem wanin tau Yafet. Sem sahoro nea upu momou sio Ibrani. ");
INSERT INTO nxl_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem ne hehuka mo, Elam, Asyur, Arpakhsad, Lud runa Aram. ");
INSERT INTO nxl_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram nea upu momou mo, sio Us, Hul, Geter runa sio Mas. ");
INSERT INTO nxl_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpakhsad isusu Selah. Selah isusu Eber. ");
INSERT INTO nxl_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber isusu anai hanaia ua. Ia manaonete nanai Peleg. Tea mo, tau ne naene sio pusiso mai tuniai reini osama-samaso pena niana. Peleg nene nohue, “Osama-samaso”. Ia muie nanai Yoktan. ");
INSERT INTO nxl_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan nea upu momou mo, sio Almodad, Selef, Hasar-Mawet, Yerah, ");
INSERT INTO nxl_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usel, Dikla, ");
INSERT INTO nxl_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Syeba, ");
INSERT INTO nxl_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila runa sio Yobab. Sio rei pusiso sahoro Yoktan nea upu momou. ");
INSERT INTO nxl_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","No tihue wani orueso tanui reimo hekani on nau Mesa ereeu rotu-tu ria Sefar. Sefar areimo, waria pupua napi ranie matae eresaa. ");
INSERT INTO nxl_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Sio rei pusiso, Sem nea upu momou. Orue sakakau otoa, sakakau niana, sakakau sou. ");
INSERT INTO nxl_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Sio rei pusiso utuso sahoro Nuh nea upu momou. Niane osa ereeu mai niane osa. Ipane osa ereeu mai ipane osa. Sio rei pusiso utuso sahoro Nuh nea upu momou. Reiso waene eresaa suka, samatoro sio rei pusiso orati sio niana-niana mai tuniai reini pusiki. ");
INSERT INTO nxl_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Mataanoe sio niana-niana mai tuniai reini pusiso utuso no sou osa. ");
INSERT INTO nxl_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Oeuso rotu-tu ohokaso ria rani mata msaae. Ohokaso ria watane wan hekan. Watane rei nanae Babilonia. Hoka ria oyo orueso ria rei. ");
INSERT INTO nxl_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Taue isa oasau osi umau. Oahata, “Mai na inehu tuamane runa monota oyo iamanre na makaya.” Reiso sio ouna hatu nanie oapuoo numa. Oyo onana aspal opunui tau hatu rai na nanie rakina umau. ");
INSERT INTO nxl_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Oamanou pusire, ita oasau osi umau honu. Oahata, “Mai na iapuoo kota isa. Kota wani nene numa isa rehokai roe nante. Iapuooi na sio pusiso oatinu nanari na pene isama-samata ineka pusi tuniai reini.” ");
INSERT INTO nxl_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Wasoni onanai asi, oyo sira tau Yahweh ikaisunu nanie inoo kota rei. Kota runa nene numa wani sio mansiau oapuooi rotu-tu erehokai roe nante rei. ");
INSERT INTO nxl_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Iahata, “Sio reini no niane osa, no sou osa. Areini mo, mato mataanoe. Potu-potuina, mka ouna sae man pusu no maue. ");
INSERT INTO nxl_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Reiso mai, na ikaisunu na iuna wena-wena no sou. Iwena-wena no sou na pene oanei umau.” ");
INSERT INTO nxl_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Reiso Yahweh iuna wena-wenaso, oneka pusi tuniai reini. Reiso oapuoo kota rei tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ria kota rei, Yahweh iuna wena-wena no sou, reiso kota rei nanae Babel. Nene nohue, “Wena-wenaso”. Ria kota rei, Yahweh iuna wena-wenaso oneka pusi tuniai reini. ");
INSERT INTO nxl_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Areini sahoro Sem nea upu momou nanao. Waene erekaisunu musum ua nea, Sem ne musum utun. Ne musum utun samatoro isusu anai hanaie manaonete. Nanai Arpakhsad. ");
INSERT INTO nxl_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Isusu Arpakhsad oyo ikarihuru iamahai rotu-tu musum 500 honu. Ne isusu ne hehuka umau honu. ");
INSERT INTO nxl_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpakhsad ne musum 35, isusu anai hanaie manaonete nanai Selah. ");
INSERT INTO nxl_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Isusu Selah oyo ikarihuru iamahai rotu-tu musum 403 honu. Ne isusu ne hehuka umau honu. ");
INSERT INTO nxl_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Selah ne musum 30, isusu anai hanaie manaonete nanai Eber. ");
INSERT INTO nxl_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Isusu Eber oyo ikarihuru iamahai rotu-tu musum 403 honu. Ne isusu ne hehuka umau honu. ");
INSERT INTO nxl_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber ne musum 34, isusu anai hanaie manaonete nanai Peleg. ");
INSERT INTO nxl_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Isusu Peleg oyo ikarihuru iamahai rotu-tu musum 430 honu. Ne isusu ne hehuka umau honu. ");
INSERT INTO nxl_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg ne musum 30, isusu anai hanaie manaonete nanai Rehu. ");
INSERT INTO nxl_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Isusu Rehu oyo ikarihuru iamahai rotu-tu musum 209 honu. Ne isusu ne hehuka umau honu. ");
INSERT INTO nxl_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rehu ne musum 32, isusu anai hanaie manaonete nanai Serug. ");
INSERT INTO nxl_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Isusu Serug oyo ikarihuru iamahai rotu-tu musum 207 honu. Ne isusu ne hehuka umau honu. ");
INSERT INTO nxl_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug ne musum 30, isusu anai hanaie manaonete nanai Nahor. ");
INSERT INTO nxl_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Isusu Nahor oyo ikarihuru iamahai rotu-tu musum 200 honu. Ne isusu ne hehuka umau honu. ");
INSERT INTO nxl_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor ne musum 29, isusu anai hanaie manaonete nanai Terah. ");
INSERT INTO nxl_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Isusu Terah oyo ikarihuru iamahai rotu-tu musum 119 honu. Ne isusu ne hehuka umau honu. ");
INSERT INTO nxl_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terah ne musum 70, isusu ne hehuka hanaia tonu. Ia manaonete nanai Haran. Ia autihue nanai Abram. Ia muie nanai Nahor. ");
INSERT INTO nxl_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Areini sou monae arihoni Terah. Terah isusu Haran, Abram, runa Nahor. Haran isusu anai hanaie manaonete nanai Lot. ");
INSERT INTO nxl_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Isusu Lot. Ereeu honu oyo amai, Haran, imatai pan ne niane hahae. Ne niane rei nanae Ur. Ur wapan otoe Babilonia. Haran imatai mo, amai iamahaiki asi. ");
INSERT INTO nxl_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram iausahai inana Sarai. Nahor inana Milka. Milka mo, Haran anai pina. Haran, anai hanaie isa honu, nanai Yiska. ");
INSERT INTO nxl_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ne Sarai mo, imutui. Isusu tewa. ");
INSERT INTO nxl_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah sio ohitio oeu arihoni kota Ur ria otoe Babilonia. Terah ieu ikata anai hanaie Abram runa ne mananue Sarai, runa momoi Lot. Ateso nanie oeuso nau otoe Kanaan. Ne ohokaso pan nia Haran oyo orueso pan rei. ");
INSERT INTO nxl_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Orueso pan Haran oyo Terah imatai. Imatai tau ne musum 205. ");
INSERT INTO nxl_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Naone Yahweh iasau osi Abram. Iahata, “Aeua arihoni me niane, me ipane taue runa me numa hutu nohue. Oeumo pan otoe isa wani mka uautuu runai osia. ");
INSERT INTO nxl_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Au mka una mea upu momou panesi. Au mka urui iake osia. Au mka una nanam mainae. Pusu ano, mka urui iake osi sio pusiso. ");
INSERT INTO nxl_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Au mka urui iake osi sio wason oainisi na urui iake osia. Au mka urui kahatene osi sio wason oainisi na urui kahatene osia. Pusu ano, mka urui iake osi sio niana pusiso utuso mai tuniai reini.” ");
INSERT INTO nxl_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Abram ihitio ieu arihoni nia Haran mo, ne musum hutu itu rahana nima. Ihitio ieui tau ipusu Yahweh ioiki. Abram ihitio ieu pan otoe Kanaan ikata sahai Sarai runa oai (wanin anai) Lot. Oeu orori no numa hutae runa no manianeu pusiso. Orori pusire waron osupure pan Haran. Ohokaso pan Kanaan oyo, ");
INSERT INTO nxl_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram sio oeu opusu otoe rei. Oeu rotu-tu ohokaso mai ai onate wani sio Kanaan oainisi oainaa runa no anahatanau waron titue tewa tanui. Ai onate wani mai More mai nia Sikhem. Tau rei sio Kanaan wason orueso pan otoe rei asi. ");
INSERT INTO nxl_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yahweh iatuhete ruai osi Abram honu. Iahata, “Otoe reini mo, mka uruiki osi mea upu momou.” Abram iatinu san rei oyo, irane hatu noore sani anau nanie iainisi iainaa runa Yahweh tanure. Yahweh wain naone iatuhete ruai osiki rei. ");
INSERT INTO nxl_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Taa san rei ita ieui suru poe honu. Ieui poe otoe pupua poe nia Betel hae ranie matae eresaa. Hoka poe oyo, oapuoo no numa wani onanai arihoni makapana unta. Oapuooi kua Betel runa nia Ai uare nene tihue. Betel wani hae ranie matae eresohui, Ai wani hae ranie matae eresaa. Kua naniao rei iae, Abram irane hatu noore sani anau nanie iainisi iainaa runa Yahweh. ");
INSERT INTO nxl_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ita ihitio ieui honu. Ieui arihoni otoe rei, ieui na poe otoe Negeb. ");
INSERT INTO nxl_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Mai otoe Kanaan atuhu iaka tewa reiso, omata muaine. Abram sio osupu muaina tewa, reiso oeu suru poe hainau honu. Oeuso rotu-tu ohokaso poe otoe Mesir. Hoka poe oyo, orueso rotu-tu musum waron omata muaine raniku. ");
INSERT INTO nxl_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ne nanie oniku nenene na onusu poe Mesir, Abram iasau osi sahai Sarai. Iahata, “Ano. Ano mo, ano iake. ");
INSERT INTO nxl_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Munata sio poe Mesir onooa mka oahata, ‘Ia pina reimo sahai, kani ia rei tea.’ Reiso mka ohunuku. Ne ano mo, mka oapuhaia. ");
INSERT INTO nxl_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Reiso nene iake mo, ano asau ahata, ‘Hotaku. Asau san rei na pene ohunuku. Mka oamuiraku noso ano.’” ");
INSERT INTO nxl_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abram sio ohokaso poe Mesir oyo, ereeu sani iasau rei. Iatinu sio Mesir oasau osi umau oahata, “Ina ee! Ia pina rei ia iake tunne maa!” ");
INSERT INTO nxl_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ia ona aia hanai wanana umau roe ne numa aia onoo ia pina rei. Onooi oyo osima osi ia ona aia. Oahata, “Upu. Ia pina reinau mo, ia iake tunne nai osa.” Reiso oeu nau, onanai, ororiki roe ne numa. ");
INSERT INTO nxl_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ia ona aia inoo runa Abram iake noso Sarai. Inoo runai iake reiso irui ne manianeu. Sio pinau runa sio hanaia. Irui ne rompau, ne une-uneu, ne koropou, ne unta, runa ne keledaiu. (Unta, nene totu unie mo, nene pupua sonota. Keledai nooi sani naitanane ne ikine man.) ");
INSERT INTO nxl_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ne Yahweh irui kupua inaya waron mtinta raunaso omasikikiso osi ia ona aia runa sio pusiso wason okatai pan ne numa anoe. Ia ona aia inana Abram ne pina suanane, reiso Yahweh irui kupua inaya osiso. ");
INSERT INTO nxl_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Oyo ia ona aia ioi Abram nanie iasei tanui. Iahata, “Auna sae tanuku reini? Asima osiku runa ia pina reini ata saham tewa tahae hae? ");
INSERT INTO nxl_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Amuna na asima ata hotamu? Rotu-tu unanai tau sahaku. Reiso mai na anana saham na oeumo!” ");
INSERT INTO nxl_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ia ona aia iaisosi ne makahaia na oautunu Abram sio rotu-tu ohokaso arihoni Mesir. Ieu ikata sahai runa ne numa hutae pusiki. ");
INSERT INTO nxl_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram ieui iarihoni otoe Mesir, ieu suru pan. Ieu pan otoe Kanaan on poe hae. Inusu pan Kanaan ikata sahai, oai runa no apia pusire. ");
INSERT INTO nxl_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram ne kaya mainae nea. Ne kaya tau ne rompau, ne une-uneu, ne koropou. Ne kaya tau ne hunahana runa ne perak. ");
INSERT INTO nxl_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Hoka pan oyo, ihitio ieu iarihoni naniai isa ihokai pan naniai isa honu. Ita ihitio honu ieu arihoni naniai rei ihokai pan naniai isa honu rotu-tu ihokai pan nia Betel. Ihokai pan Betel runa nia Ai uare tihue. Hoka pan tihue wani naone oapuoo no numa wani sio onanai arihoni makapana unta. ");
INSERT INTO nxl_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Naone irane hatu noore sani anau na iainisi iainaa runa Yahweh pan rei. ");
INSERT INTO nxl_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Oai Lot iae ne pina ne hehuka, ne manianeu, ne rompau, ne une-uneu, ne koropou. ");
INSERT INTO nxl_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Reiso otoe rei nene monota hutua ralai uaso no makapanau muaia tewa. Uaso no makapanau panesi onate. ");
INSERT INTO nxl_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Reiso sio wason osaka no makapanau rai oatana runa umau. (Tau rei sio Kanaan runa sio Peris orueso mai otoe rei asi.) ");
INSERT INTO nxl_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abram iasau osi Lot san rei. “Oaku. Ita reini ita tamena tewa. Munata uata iatana runa umau, areimo iake tewa. Samatoro munata au we mamsakaya runa ano me mamsakaya oatana runa umau, areimo iake tewa. ");
INSERT INTO nxl_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Reiso nene iake uata ieu sakakau umau. Aroma hae supa wani me sukai. Munata ano aeu suru nau, au mka ueuku suru ria. Ne munata ano aeu suru ria, au mka ueuku suru nau.” ");
INSERT INTO nxl_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Reiso Lot ieu iararou inoo sui tihue otoe rei pusiki. Iararou inoo hae Wae Yordan nene Ekote rotu-tu poe nia Soar. Inoo ata hae reimo nene tihu panesi. Nooi sani Anahatana ne nisi on ihaye tau tuniai. Nooi sani otoe Mesir. (Inoo san rei on Yahweh iakanupu nia Sodom runa nia Gomora tewasi.) ");
INSERT INTO nxl_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Iararou inoo pusi oyo iroma hae Wae Yordan nene Ekote. Iroma pusi oyo, ieui ria Wae Yordan rei. Taa san rei oyo uaso oeu sakakau umau. ");
INSERT INTO nxl_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram iruei mai otoe Kanaan sirinia. Ne Lot iapuoo ne numa wani onanai arihoni makapana unta ria ekote tihue haineke Sodom. ");
INSERT INTO nxl_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sio wason orueso mai Sodom reimo, sio kahatena mainae. Opalalosa mainae tau Yahweh. ");
INSERT INTO nxl_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Taa Lot ieui oyo, Yahweh iasau osi Abram. Iahata, “Ararou anoo ia-ia suru ria suru nau noi naniam wamo aooa reino. ");
INSERT INTO nxl_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Au mka urui otoe reini pusiki wani anooi reini osia runa mea upu momou. Uruiki osimo rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Au mka unaya asusu haha. Asusu haha rotu-tu ia isa man iae, ireken kuaso tewa. Noo sani tapuna poe tuamane. Ia isa ireken kuare tewa. Reiso ano mea upu momou iae mo, ia isa ireken kuaso tewa oi. ");
INSERT INTO nxl_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Au mka urui otoe reini pusiki osia. Reiso aeu sui otoe reini pusiki.” ");
INSERT INTO nxl_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Yahweh ianamana runai pusi, oyo iautotu ne numa waron onani arihoni makapana unta. Ita iapuooi honu haineke ai onata mai nia Mamre haineke nia Hebron. Iapuooi, oyo irane hatu noore sani anau, na iainisi iainaa runa Yahweh. ");
INSERT INTO nxl_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","2","Sio aiau ate ohiti nisa runa sio aiau nima. Sio aiau ate rei mo, Amrafel on pan otoe Babilonia. Ariokh on pan nia Elasar. Kedorlaomer on pan otoe Elam. Tideal ia ona aia tau sio Goyim. Sio aiau nima rei mo, wason, Bera on ria nia Sodom. Birsya on ria nia Gomora. Syninab on ria nia Adma. Semeber on ria nia Seboim. Ia ona aia on ria nia Bela. Bela mo, sio oaoiki tau Soar oi. ");
INSERT INTO nxl_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Sio aiau nima rei okata umau oamanou no tantarau ria Ekote Sidim. Muie reini sio oaoiki tau Wae Matane. ");
INSERT INTO nxl_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ia ona aia Kedorlaomer irime sio aiau nima rotu-tu musum hutusa rahana ua nea. Ne nanie ereeu mai musum hutusa rahana tonu oimo, sio aiau nima rei ohiti nisa runai. ");
INSERT INTO nxl_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Oyo nene musum hutusa rahana ate sio aiau ate rei runa no tantarau oahita runa sio Refaim pan nia Asyterot-Karnaim. Ia ona aia Kedorlaomer sahoro irori arena osiso. Oahita oyo, sio aiau ate rei onesi. Ita oahita runa sio Susim poe nia Ham. Ateso onesi. Ita oahita runa sio Emim poe nia Syawe-Kiryataim. Ateso onesi sirinia. ");
INSERT INTO nxl_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Ita oahita runa sio Hori roe pupua ria Edom. Osui pususo poe otoe El-Paran poe otoe huie nusue. Ne sio onesi sirinia. ");
INSERT INTO nxl_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Osuiso pusi oyo, onunso na pan otoe En-Mispat. Muie reini sio oaoiki tau Kades. Ateso onesi sio Amalek reiso no otoe osiso. Ateso onesi tau sio Amori wason orueso poe nia Haseson-Tamar. ");
INSERT INTO nxl_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Sio aiau nimaso oamanou no tantarau ria Ekote Sidim oyo oahita ");
INSERT INTO nxl_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","runa sio aiau ate rei. ");
INSERT INTO nxl_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ekote rei mo, aspal nene aikune. Aspal rei ereruei poe nonu anoe. Reiso sio tantarau arihoni Sodom runa Gomora nanie orumaso arihoni manahitane rei. Orumaso reiso oamnahuso poe nonu anoa rai. Ne sio umau osihaso orumaso na roe pupua. ");
INSERT INTO nxl_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Sio aiau ate rei onesi sirinia. Reiso owahu sio Sodom runa sio Gomora no apia pusire rotu-tu owahu no muaina oi. Owahu pusire oyo, oeuso. ");
INSERT INTO nxl_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abram oai Lot iruei ria Sodom oi. Reiso sio owahui runa ne apia pusire oi. ");
INSERT INTO nxl_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ne ia isa rerihoni sio tantarau rei isihai, reiso irumai suru nau nanie isima osi Abram, ia Ibrani rei. Abram iruei haineke ai onata. Ai onata rai, Mamre irahure. Mamre mo, ia arihoni sio Amori. Mamre nea waniu tau Eskol runa Aner. Tonuso oakahai Abram tau manahitana. ");
INSERT INTO nxl_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Taa Abram iatinu ata sio osota oai reiso iamanou ne manianeu wason okatai on sio ikina asi. Ne manianeu wason sio oatuheteso oahita. Sio reimo sio utun tonu hutusa rahana wanu. Reiso Abram iroriso nanie osui sio aiau ate rei. Osuiso rotu-tu ohokaso pan Dan. ");
INSERT INTO nxl_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Hoka pan oyo, isama ne tantarau tau tikana-tikana. Isamaso samatoro oahita runaso tau pumono. Abram sio onesiso. Isuiso rotu-tu ohokaso na pan nia Hoba pan kota Damsyik on pan hae. ");
INSERT INTO nxl_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abram inesi reiso iwahu apia waron sio owahure rei. Inana oai runa ne apia oi. Iwahu sio Sodom runa sio Gomora no pinau hehuka oi. ");
INSERT INTO nxl_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram inesi sio aiau ate rei wason ia ona aia Kedorlaomer iroriso. Inesi oyo inuniki. Ne ia ona aia arihoni nia Sodom ihokai mai Abram sio poe Ekote Syawe. Sio oaoiki tau Ekote Aia oi. ");
INSERT INTO nxl_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melkisedek mo, ia ona aia tau nia Salem ihokai mai Abram. Ia mo, ia imam. Anahatana mo, ia mainae nai osa. Melkisedik irori poroti runa tihu anggur osi Abram. ");
INSERT INTO nxl_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Hoka pan oyo, iainisi na Anahatana irui iake osi Abram. Iahata, “Upuku Anahatana. Ano mo, ano mainae nai osa. Uainisi na arui iake osi Abram. Ahaye tau nante runa tuamane. ");
INSERT INTO nxl_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Uainaa runaya tau ano mo, ano mainae nai osa. Arui Abram inesi ne nisau pusiso utuso nea.” Iainisi iake osiki san rei, oyo Abram isama apia waron iwahure arihoni sio aiau ate rei tau pahakian hutusa. Samatoro irui pahakian osa osi Melkisedek. ");
INSERT INTO nxl_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Oyo ia ona aia Sodom iahata, “Anana apia waron awahure rai osi ruam na arui we pinau hehuka reino mai.” ");
INSERT INTO nxl_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Iahata, “Au usopa uamanane Yahweh Anahatana. Ia mo, Ia mainae nai osa. Ihaye tau nante runa tuamane. ");
INSERT INTO nxl_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Usopa ata au mka unana sae isa arihonia tewa. Masike nipa sinte isa iae, mka unanai arihonia tewa. Tea mo, mka ano asau ata au we kaya reini mo, noso ano. ");
INSERT INTO nxl_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Upeneku unana sae isa osi ruaku. Ne hasae unana sae waron we mansiau oaire nea. Ne we netau tonu reini, mka onana no pahakian. Sio reimo Aner, Esdol, runa Mamre.” ");
INSERT INTO nxl_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Taue isa, Abram inekei iamnii inoo Yahweh. Iahata, “Abram. Pene akaitau. Au unetea sani aniaue. Urui iake wani mainae osia tau ano mo, apusuku.” ");
INSERT INTO nxl_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Iahata, “Yahweh wan arime tuniai reini. Arui we hehuka umau tewa reiso, mka ia seia isaka we numa hutae runa we rusun? Reiso ia wain mka isakare mo, we maniane, Elieser, ia Damsyik rei. Reiso nanie arui iake wani mainae rei osiku tau sae?” ");
INSERT INTO nxl_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Iahata, “Tewa. Mka anam hanaie ruai. Ia sahoro isaka me numa hutae rei. Me maniane isaka tewa.” ");
INSERT INTO nxl_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Yahweh irori Abram ihokai arihoni numa. Iahata, “Masi anoo roe nante na areken tau oneu rairo. Areken kuare te tewa? Mka mea upu momou panesi sani oneu rei oi.” ");
INSERT INTO nxl_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram iparisaa mainae tau Yahweh reiso Yahweh iahata anoi manisate. ");
INSERT INTO nxl_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Yahweh iahata, “Au sahoro Yahweh wan uaisosia ahokaya arihoni me kota Ur pan otoe Babilonia. Ahokaya na urui tapuna raini mai otoe Kanaan reini osia tau mea upu momou.” ");
INSERT INTO nxl_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ne Abram iasei, “Yahweh, Ano wan arime tuniai reini. Sapani na uanei ata tuamana raini osi wea upu momou?” ");
INSERT INTO nxl_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Iahata, “Anana koropou inae isa, une-une inae isa runa rompa hanaie isa. Tonure nene musum tonu-tonu. Runa manu naka teura isa na manu puane isa.” ");
INSERT INTO nxl_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Reiso Abram inina makapanau rai osi Yahweh. Isupure oyo ihutu haka koropou, une-une runa rompa rai tau ua. Iaunuture na hae remanane hae. Ne manua rai ihutu hakare tewa. ");
INSERT INTO nxl_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Manua waron rarutu-rutu peni kopua nanie rarutu makapanau rai, ne Abram ineire. ");
INSERT INTO nxl_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Haineke ranie nanie eresohui, oyo Abram ineke munui nai osa. Ineke munui oyo ikaitau hunu ruai. ");
INSERT INTO nxl_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Yahweh iahata, “Anom repeka. Mka mea upu momou orueso noi nia tamene sani sio rakana. Sio mka ouna manianeu poe niane rei. Mka sinsaraso rotu-tu musum utun ate. ");
INSERT INTO nxl_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ne sio wason ounaso tau manianeu mo, mka uapasanaso. Tau mea upu momou ohitio oeuso arihoni niane rei, mka orori no apia panesi. ");
INSERT INTO nxl_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ano ruam mo, mka rotu-tu akore-korea amtuaya ia-ia. Amataya tau sanani, oyo oaunutua tau naniam iake. ");
INSERT INTO nxl_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Mea upu momou sio napisi ate oyo onunso mai tuamane reini. Mka unei sio Amori tewasi. Ne rotu-tu no kahatena mainaya samatoro uapasanaso. Uapasanaso, areimo uneiso arihoni tuamane reini, samatoro tuamane reini osi mea upu momou.” ");
INSERT INTO nxl_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Tau pumono oyo, sira tau usa wani erewenu mai naniae runa kamane wani ereai raeu pusu makapanau rai tihue. ");
INSERT INTO nxl_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Tau ranie hatae reimo Yahweh itotoe osi Abram. Iahata, “Au utotoe na mka urui tuamane reini osi mea upu momou. Urui tuamane on poe nenene poe Mesir rotu-tu pan Wae Efrat. ");
INSERT INTO nxl_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Mka urui sio Keni no tuamane. Urui sio Kenas, sio Kadmon, ");
INSERT INTO nxl_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","sio Het, sio Peris, sio Refaim, ");
INSERT INTO nxl_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","sio Amori, sio Kanaan, sio Girgasi runa sio Yebus no tuamana oi.” ");
INSERT INTO nxl_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Abram iruei mai otoe Kanaan ne musum hutusa nea. Ne sahai, Sarai mo, isusu tewasi. Tau rei ne ia pina makahaie isa iruei ikataso. Ia makahaie rei, ia pina Mesir. Nanai Hagar. Ia makahaie rei ia pina hehuke asi. Reiso Sarai iasau osi sahai, “Yahweh iruiku ususu tewa. Reiso nene iake mo, anana re makahaie reini tau saham. Na hitio isusu osiku.” Oyo Abram iamanaku. San rei oyo, Sarai irui Hagar osi Abram tau sahai muie. ");
INSERT INTO nxl_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Reiso Abram inanai. Inanai oyo, sahai muie rei tinain taua. Ne sahai muie rei ianei ata tinain taua, reiso inana hatia tau Sarai. Iunai iake tewa. ");
INSERT INTO nxl_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Oyo Sarai iasau osi sahai, “Urui Hagar, re makahaie rei osia tau saham nea. Ne ianei ata tinain taua oyo, iunaku iake tewa. Ano sahoro asana. Ne napa sahoro Yahweh inoo uata re isanae reini, na iarinii ia seia sahoro ne manisate runa ia seia sahoro isana.” ");
INSERT INTO nxl_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Iahata, “Me makahaie rei, tea. Reiso ruam auna sae man tanui. Ano me kawasa tanui. Aunai pusu ruam me maue man nea, tea.” Oyo Sarai ne hau tanui sui osa. Reiso rotu-tu Hagar irumai. ");
INSERT INTO nxl_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Irumai oyo sira tau Yahweh iatuhete ruai osiki nooi sani Yahweh ne maisosie on roe noiyaha. Iatuhete ruai osiki haineke wae huhune poe arena nusue poe otoe huie. Arena rei nanie ereeu poe nia Sur. ");
INSERT INTO nxl_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Iatuhete ruai iahata, “Hagar! Sarai ne makahaie! Ano on supa, nanie aeua supa?” Iahata, “Upuku. Nanie urumaku arihoni upuku.” ");
INSERT INTO nxl_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Iahata, “Anunia pan tanui na apakarian osiki. ");
INSERT INTO nxl_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Au mka urui mea upu momou panesi. Mka rotu-tu sio oreken kuaso tewa. ");
INSERT INTO nxl_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Potuina tewa oyo, mka asusu me ia ikine hanaie isa. Ahete nanai tau Ismael. Tea mo, ano arani Yahweh iatinu. ");
INSERT INTO nxl_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ne anam hanaie rei, mka iatinu tau maunauna tewa. Mka ituntana runa mansiau panesi. Sio mansiau iae, mka otuntana runai oi. Ia mka iruei ikata ne mansiau tewa.” ");
INSERT INTO nxl_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagar iasei pan anoi, “Kani unoo Anahatana nea reisi? Anahatana wain ino-noo au sui osa!” Reiso ihete Anahatana nanai tau, “Anahatana wain ino-noo.” ");
INSERT INTO nxl_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Reiso sio oaoi wae huhune rei tau Lahai-Roi. Nene nohue, “Ia wain iamahaiki wain ino-nooku ne wae huhune.” Wae huhune rei wapo nia Kadesy runa nia Bered tihue. Wapo rotu-tu reini. ");
INSERT INTO nxl_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","16","Abram ne musum hutu wanu rahana nome oyo Hagar anai hanaie iamrai. Oyo amai Abram ihete nanai tau Ismael. ");
INSERT INTO nxl_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram ne musum hutu sia rahana sia. Ita Yahweh iatuhete ruai osiki. Iahata, “Au mo, au Anahatana wani we kawasa mainae erenesi sio pusiso. Apusu we maue sui osa. ");
INSERT INTO nxl_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Au mka utotoe osia na urui mea upu momou panesi. Mka urime ia-ia tau sae wani utotoe reini.” ");
INSERT INTO nxl_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Oyo Abram irike tune iakapuni ain. Irike tune oyo, Anahatana iahata, ");
INSERT INTO nxl_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Au reini mo, utotoe runaya. Ano mka auna numa upue osi sio niana-niana. ");
INSERT INTO nxl_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Reiso nanie ukati nanam. Nanam Abram tewa nea. Ne nanam honue mo, Abraham. ");
INSERT INTO nxl_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Au mka urui mea upu momou panesi. Arihoni sio panesi reimo, mka sio umau ouna aiau. Mea upu momou rei, sio panesi mka oapuoo niana-niana. ");
INSERT INTO nxl_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Wani utotoe rei, mka uruiki osia runa mea upu momou rotu-tu ria supan. Ano runa mea upu momou oainisi oainaa runaku. Au sahoro Anahatana wani sio oainisi oainaa runaku. ");
INSERT INTO nxl_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Muie reini omi orue tau tuamane reini sani omi rakana asi. Ne mka uruiki osia runa mea upu momou. Tuama Kanaan reini, urui pusiki utue osi mea upu momou rotu-tu ria supan. Au mo, au Anahatana wani sio oainisi oainaa runaku. ");
INSERT INTO nxl_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Ano iae, kahurae apusu maunaune reini. Kahurae orehi pusimo. Ano runa mea upu momou kahurae opusu maunaune reini. Sio hanaia pusiso kahurae orehiso. ");
INSERT INTO nxl_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Oni ranie hatae reini sio iki hanaia wason no onona itu pusiso kahurae orehiso. Sio manianeu wason oamrai mai me numa, kahurae orehiso oi. Runa sio wason ohaneso rei oi. Sio hanaia pusiso wason orueso mai me numa kahurae orehiso. Sio wason me hehuka, sio wason me hehuka tewa oi. Orehimo rei, ereuna anomo rapeka runa wani au utotoe reini sui osa. ");
INSERT INTO nxl_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Omi hanaia pusimo kahurae orehimo. Orehimo na rauna anomo rapeka runa wani utotoe reini. Utotoe rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Sio hanaia wason orehimo tewa mo, nooi sani Au we mansiau tewa nea. Tea mo, orime we maunaune reini tewa. ");
INSERT INTO nxl_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Isa honu. Saham Sarai mo, ukati nanai tau Sara. Nanai Sarai tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Au mo, mka urui iake osiki na isusu anai hanaie isa wain mka uruiki osia. Urui iake osi Sara na iuna ia pina numa upue osi sio niana-niana. Arihoni nea upu momou reimo, mka sio umau ouna aiau oi.” ");
INSERT INTO nxl_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Oyo Abraham irike tune iakapuni ain ne, iauman. Iasau pan anoi, “Ia hanaie kore-korene isa sani au reini mka ususu ia iki hanaie isa asi si? We musum utun nea reini! Ia pina isa ikore-korei sani Sara reini isusu asi si? Ne musum hutu sia nea reini!” ");
INSERT INTO nxl_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Oyo Abraham iasau osi Anahatana. Iahata, “Ismael isaka we numa hutae man nea, tea!” ");
INSERT INTO nxl_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ne Anahatana iahata, “Tewa. Saham Sara ruai mka isusu anam hanaie isa. Saka ahete nanai tau Isak. Au mka ukata sae wani utotoe reini rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ano ainisi rerihoni Ismael rei mo, mka uatinu tanua. Reiso mka urui iake osiki. Urui nea upu momou panesi. Ia mka iuna numa upue tau ipana hutusa rahana ua. Nea upu momou mo, mka au unaso orime otoe wani mainae oi. ");
INSERT INTO nxl_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ne wani utotoe reini mo, mka una usuiki osi Isak. Isak anam wain mka Sara isusui rei. Isusui musum reinau sani musum hunana raini.” ");
INSERT INTO nxl_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Iasau pusi san rei oyo Anahatana ieu iarihoniki. ");
INSERT INTO nxl_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Nene ranie hatae rei oyo, Abraham ipusu Anahatana ne maunaune rei reiso irehi anai hanaie Ismael runa sio hanaia noi ne numa anoe pusiso. Irehiso ne manianeu oi. Ne manianeu wason oamrai noi ne numa runa sio wason ihaneso. ");
INSERT INTO nxl_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham irehiso reimo, tau ne musum hutu sia rahana sia. ");
INSERT INTO nxl_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Tau rei anai hanaie Ismael ne musum hutusa rahana tonu. ");
INSERT INTO nxl_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Orehi uaso tau ranie hatae osa rei oi ");
INSERT INTO nxl_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","runa Abraham ne manianeu pusiso. ");
INSERT INTO nxl_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Yahweh ihoka ruai osi Abraham haineke ai onate poe nia Mamre. Tau rei, ranie katopu. Abraham iru-ruei poe ne numa wani sio onanai rerihoni makapana unte. Iruei poe mitanunue. ");
INSERT INTO nxl_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ihetu unui, isira tau sio tonu wason oooso mai uai anoe nea. Inoo san rei, iruma noi inapaso, oyo irike tune iakapuni aio. ");
INSERT INTO nxl_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Iahata, “Wea upu. Pene oniku we numa. Onusu mai na, oaimo ee. ");
INSERT INTO nxl_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Onusu mai na osohu aimo atua ee. Na oaranahamo mkane mai ai nohue reini ee, ");
INSERT INTO nxl_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","na unoo runa muaine osimo. Oaimo na oamkona na oeu kua. Hokamo mai numa nea reiso, oaimo ee, samatoro oeumo.” Oahata, “Iake. Aranahama mkane ee.” ");
INSERT INTO nxl_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Reiso Abraham imale suru ria suru nau. Inusui pan numa anoe, iasau osi sahai. Iahata, “Anana rapu tariku karuni isa mai. Tariku wani ohie rei, na auna poroti hua isa.” ");
INSERT INTO nxl_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Oyo iruma ria ne makapanau nene koka. Iroma koropou anae wani kopo-kopotuene. Nene henate mo, manne. Ihokai arihoni koka anoe rei samatoro, iruiki osi ne makahaie. Ne makahaie rei irehiki, oyo ihutui rapu-rapu. ");
INSERT INTO nxl_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Taa san rei oyo, Abraham inana koropou nene susu, oyo inana nene susu wani mataanoe runa koropou anae nene henate wani masae nea rei. Inanare oyo iratare osi sio onata tonu rei. Wasoni oaiso, Abraham iooi isakaso poe ai nohue rei. ");
INSERT INTO nxl_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Oaiso suka oyo, oasei, “Sahamu, Sara oi?” Iahata, “Waipan numa anoe.” ");
INSERT INTO nxl_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ia isa iata, “Nene hunana sia rainau, mka uhokaku mai honu. Tau rei mka saham isusu hanaie isa nea.” Iasau san rei, Sara iatinu haineke mitanunue pan ia onate rei totui. ");
INSERT INTO nxl_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ne Abraham runa Sara uaso okore-kore oamtuaso nea. Sara isupu hunane tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Reiso Sara iauman pan anoe. Iahata, “Ukore-koreku na ukua tewa nea reini. Sapan na anoku mirike na ususu? Samatoro Abraham ikore-korei iamtuai nea reini!” ");
INSERT INTO nxl_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Oyo Yahweh iasei tau Abraham, “Sae remuna na Sara iauman rei? Sapan na Sara iasei iahata, ‘Sapan na ia pina kore-korene isa sani au reini mka ususu asi?’ ");
INSERT INTO nxl_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Au, Upum, we kawasa una sae man. Sani sinasi uasau wani mka hunana sia rainau uhokaku honu. Tau rei Sara anai hanaie iamrai nea.” ");
INSERT INTO nxl_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara ikaitau reiso iauhuni iahata, “Tewa. Au uauman tewa.” Ne Yahweh iahata, “Tewa. Ano sinasi auman.” ");
INSERT INTO nxl_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Tonuso osima runa Abraham anai hanaie suka, oyo nanie onunso. Abraham iautunuso. Oeu rotu-tu ateso ohokaso ria tihue otoe isa haineke kota Sodom. Haineke Sodom reiso onoo na poe Sodom. ");
INSERT INTO nxl_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yahweh iasei pan anoi, “Kani mka upeneku tau usima runa sae wani nanie unai tau sio Sodom rei osi Abraham? ");
INSERT INTO nxl_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ne arihoni ia sahoro nea upu momou sio panesi. Sio panesi reiso mka no kawasa mainae. Reiso uauhuni runai sapan? Mka urui iake osi sio niana pusire mai tuniai reini tau arihoni ia. ");
INSERT INTO nxl_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Tea mo, uromai nea. Uromai nanie iaisosi ne hehuka nea upu momou. Iaisosiso na opusuku. Iaisosiso nanie onana sae waron manisata. Pusire waron utotoe osi Abraham rei mka una suire. Una suire hete sae, opusuku. Onana sae waron manisata rai.” ");
INSERT INTO nxl_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Oyo Yahweh iasau osi Abraham, “Sio wason osima osiku oahata, ‘Nia Sodom runa nia Gomora mo, nene kahatena panesi. Sapani na apasanaso tewa?’ No rosau raimo kahatena mainaya. ");
INSERT INTO nxl_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Reiso mka uhokaku pan, na unoo sae waron sio oasau runare rei. Unoo ata kani manisate te tewa.” ");
INSERT INTO nxl_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Oyo sio onata ua wason okata Yahweh rei, ruao oeuso na poe Sodom. Ne Yahweh ikata Abraham asi. ");
INSERT INTO nxl_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Uaso oeuso oyo Abraham iasei, “Upuku. Titue si? Mka ohunu sio wason anoo manisata runa sio wason anoo kahatena rei pusiso? ");
INSERT INTO nxl_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Sani sio hutu nima wason anoo kahatena tewa poe niane rei, kani mka ahunu sio Sodom pusiso utuso sirinia si? Te mka apuheu sio pusiso na sio hutu nima rei oamahaiso? ");
INSERT INTO nxl_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Pene ahunu sio wason anoo manisata rei runa sio wason anoo kahatena rei pusiso. Pene, Upu. Tea mo, ahunu sio wason anoo kahatena tewa rei okata sio rei, tea! Ano wani arinii ia sia wain titue na ia sia wain titue tewa. Reiso, kahurae auna sae wani manisate. Pene ahunu sio wason anoo manisata rei tea.” ");
INSERT INTO nxl_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Iahata, “Sani usupu sio hutu nima poe Sodom wason anoo manisata mo, mka uapuhai sio Sodom pusiso utuso noso sio hutu nima rei.” ");
INSERT INTO nxl_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Iahata, “Upuku. Pene akapuku tanuku ee. Tea mo, unesi-nesi uainisi tanua honu. Aikee au ikine honue. ");
INSERT INTO nxl_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ne sani poe niane rei, sio hutu ate rahana nima man wason anoo manisata. Mka ahunu pusiso tau hasae sio nima man?” Iahata, “Sani usupu sio hutu ate rahana nima rei wason anoo manisata, mka uhunu pusiso tewa.” ");
INSERT INTO nxl_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Iahata, “Upuku. Sani sio hutu ate man mo, sapan?” Iahata, “Noso sio hutu ate rei, mka uhunso tewa.” ");
INSERT INTO nxl_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Iahata, “Upuku. Pene akapuku tanuku sani uanamana honu. Sani hasae sio hutu tonu man mo, sapan?” Iahata, “Sani usupu sio hutu tonu mo, mka uhunso tewa.” ");
INSERT INTO nxl_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Iahata, “Upuku. Pene apasanaku ee. Tea mo, mka uainisi arihonia honu. Sani hasae sio hutu ua man mo, sapan?” Iahata, “Sani usupu sio hutu ua man mo, mka uhunso tewa.” ");
INSERT INTO nxl_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Iahata, “Upuku. Pene akapuku tanuku ee. Tea mo, au mka uainisi arihonia nai osa-sa honu. Sani asupu sio hutusa man mo, sapan?” Iahata, “Sani sio hutusa wason anoo manisata, mka uhunso tewa sirinia.” ");
INSERT INTO nxl_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Yahweh ianamana pusi oyo ieu arihoni Abraham, oyo Abraham inuniki roe ne numa. ");
INSERT INTO nxl_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Sio maisosia ua on roe noiyaha oeu arihoni Abraham nanie oeuso poe kota Sodom. Ohokaso poe tau pumono. Lot wain iru-ruei mai kota rei nene mitanunue. Taa inoo uaso, oyo iooi inapaso. Ohoka mai tanui, oyo irike tune iakapuni uaso aio. ");
INSERT INTO nxl_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Iahata, “Wea upu. Osinimo mai we numa ee. Na osohu aimo. Onekemo mai we numa ee. Na hanu roe samatoro wea upu uamo oeumo tau omnano tunne honu.” Oahata, “Iake. Ruae nea. Mka anekema mai tuama huie mai kota tihue reini.” ");
INSERT INTO nxl_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ne Lot iapa-apamanuso. Iahata, “Tewa wea upu. Mai na poe onekemo poe we numa nea.” Iapamanuso rotu-tu uaso opusui pan numa anoe. Lot iaisosi ne makahaia na okotu poroti wani erepake nehue tewa osiso samatoro iratare runa muaina waron iaka osi uaso na oaire. ");
INSERT INTO nxl_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ne uaso omakawanaso asi, sira tau sio hanaia pusiso poe Sodom ohoka on ria on nau ohori pusi numa rei. Pusiso ohoka ohori Lot ne numa rei. Sio mtuana kore-korena runa sio honua pusiso utuso. ");
INSERT INTO nxl_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Pusiso oakapona Lot. Oasei, “Sio hanaia ua wason ohokaso onekeso mai me numa rei wason wanpa? Ahokaso mai osima, na asoulahaso!” ");
INSERT INTO nxl_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot ihokai arihoni numa anoe oyo iraru mitanunue. ");
INSERT INTO nxl_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Iahata, “Wea amau, wea kakau waniu. Uainisi arihonimo. Pene ouna kahatene san rei. ");
INSERT INTO nxl_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ne masi oatinu. Au we hehu pinau tunna ua wason. Reiso uruiso osimo na ounaso pusu ruamo mo maue. Hete sae, pene una sae isa tau sio ua wason ohokaso reini. Tea mo, uapusaaso mai we numa nea. Reiso kahurae uneteso.” ");
INSERT INTO nxl_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ne oahata, “Aeua! Ano mo, ano rakane man rei! Ano mo, ano sia, nani asau ata ami asana? Reiso aeua teria kahu matam. Tea mo, mka auna kahatene mainae tanua ranesi sio ua reino.” Oyo oruru heu Lot, nanie oruru heu mitanunue. ");
INSERT INTO nxl_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ne sio ua wason ohokaso rei, oakahuu Lot hanai atue, samatoro onesai pan numa anoe. Onesai oyo oraru mitanunue. ");
INSERT INTO nxl_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Uaso ouna sio panesi rei onoo mosa tewa reiso sio panesi rei onoo mosa mitanunue rei tewa nea. Oyo pusiso utuso matao usena raputiso. ");
INSERT INTO nxl_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Uaso oasau osi Lot. “Sani me hehuka hanaia umau, me hehuka pinau umau, me msahana runa me enau umau mai kota reini mo, asau osiso na pusimo ohokamo. ");
INSERT INTO nxl_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Tea mo, kota reini mka ami apumokoi. Sio panesi osima osi Yahweh oahata, ‘Sio Sodom no kahatena mainaya. Reiso apasanaso tewa tahae?’ Reiso Yahweh iaisosima mai, na apumoko Sodom reini.” ");
INSERT INTO nxl_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Reiso Lot ieui iasau osi ne hehuka pinau uare no hanaia wason nanie onanaso rei. Iahata, “Orapu na ihokata arihoni kota reini. Tea mo, Yahweh nanie iapumokoi nea.” Ne sio ata kani noa ama iakasiru man. ");
INSERT INTO nxl_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Tau ereputi-puti asi sio maisosia ua rei oaisosi Lot sio oeuso on sini. Oahata, “Sisaa! Aeua runa saham runa me hehuka pinau uaso na pene omokomo. Pene omatamo tau kota wani nanie eremokoi reini.” ");
INSERT INTO nxl_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lot iarinii asi. Ne Yahweh anoi runai. Reiso sio onata ua rei oakahuu hanai oyo onesai runa sahai runa ne hehuka pinau. Pusiso ohokaso arihoni kota rei. ");
INSERT INTO nxl_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Hokaso arihoni kota rei, oyo ia isa arihoni sio ua rei iahata, “Orumamo na oamahaimo. Pene onoo hae muie. Pene oaranahamo sui ekote reini. Orumamo na roe pupua. Orumamo na pene omatamo.” ");
INSERT INTO nxl_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ne Lot iahata, “Ira oe, upu! Pene aisosima arumama na roe pupua. ");
INSERT INTO nxl_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Upu. Omi oakahaima na amahaima nea mo, muna? Ne pene aisosima orumama roe pupua raimo hainau maa! Pene rotu-tu ahokama roe rei tewasi oimo, kota reini eremokoi nea. Mka amatama oi! ");
INSERT INTO nxl_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Reiso masi anoo pan uae reipan. Nia ikine isa waria haineke nea. Reiso otapima arumama na ria nia ikine rei man na amahaima.” ");
INSERT INTO nxl_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Iahata, “Iake. Nia ikine rei, mka uapumokoi tewa. ");
INSERT INTO nxl_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Oruma rapu. Tea mo, au iae uapumoko kota Sodom tewasi rotu-tu ahokaya ria nia ikine rei ee samatoro uapumokoi.” Lot iasau iahata, “Niane rei ikine man reiso ohete nanae tau Soar.” Nene nohue “Nia ikine”. ");
INSERT INTO nxl_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lot ihokai pan Soar mo, ranie eresaa nea. ");
INSERT INTO nxl_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Sira tau Yahweh irati aspal wani usa ereai-ai tanui nooi sani uane. Iratiki poe Sodom runa Gomora hahaya. ");
INSERT INTO nxl_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Kotau ua rai ramokoso. Runa ekota hanaya, atuhu ai nohua, runa mansia pusiki wason orueso sui tihue rei pusiki oi. ");
INSERT INTO nxl_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ne Lot sahai inoo hae muie reiso ineniki tau masine, nooi sani hatu. ");
INSERT INTO nxl_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Nene omnano tunne rei, oyo Abraham ieui roe tihue wani iooi ikata Yahweh rei. ");
INSERT INTO nxl_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Inoo na poe Sodom runa Gomora. Inoo usa wenue ereputi sui ekote rei pusiki. Inoo sani usa reinuna. ");
INSERT INTO nxl_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Anahatana iapumoko kotau waron Lot iruei tanure. Ne anoi repeka runa Abraham reiso itapi Lot irumai. ");
INSERT INTO nxl_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot ihitio ieui iarihoni nia Soar ikata ne hehuka pinau uaso. Tea mo, ikaitau. Reiso oeuso roe tinetaya nanie orueso roe rei. Orueso pan hatu nohue isa anoe. ");
INSERT INTO nxl_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Taue isa ia iki pina manaonete iasau osi wanin san rei. Iahata, “Amari ikore-korei nea. Mai tihue reini ia iki hanaie isa tewa. Sapani na mka iausahata na isusu? ");
INSERT INTO nxl_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Reiso mai na uata iuna amari ininu tihu minne na imukei. Imukei oyo ineketa runai na isusu.” ");
INSERT INTO nxl_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Oyo nene mono rei ouna noa ama ininu tihu minne, oyo amai imukei. Imukei oyo anai pina manaonete inekei runai. Ne amai imukei mainae reiso ianei ruai tewa nai osa. Ianei tewa ata inekei runa anai pina. ");
INSERT INTO nxl_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Nene hanu roe omnanoe iasau osi wanin. Iahata, “Monosi unekeku runa amaku nea. Reiso nene mka-mka mono iuna amari ininu honu na ano anekea runai. Mka uata isusu re hehuka.” ");
INSERT INTO nxl_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Reiso nene mono rei uaso ouna noa ama ininu honu rotu-tu imukei mainae. Ita ia iki pina muie inekei runai honu. Ne amai imukei mainae reiso ianei ruai tewa nai osa. ");
INSERT INTO nxl_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Reiso ne hehuka ua rei tinaio taua tau noa ama ruai. ");
INSERT INTO nxl_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ia iki pina manaonete iruei runa anai hanaie. Ihete nanai tau Moab. Ia sahoro sio Moab no numa upue rotu-tu reini. ");
INSERT INTO nxl_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ia iki pina muie isusu anai hanaie oi. Ihete nanai tau Ben-Ami. Arihoni ia sahoro sio Amon no numa upue rotu-tu reini. ");
INSERT INTO nxl_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham ihitio ieu arihoni nia Mamre ieui napi na poe otoe Kanaan nene nenene on poe hae. Hoka poe oyo, orueso poe nia Kades runa nia Syur uare tihue. Ereruma kani hunana inasa rai, oyo Abraham isuka iruei ria nia Gerar. ");
INSERT INTO nxl_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Iasau osi sio ria rei ata Sara mo hotai. Reiso ia aia tau niane rei nanai Abimelekh iaisosi ne makahaia. Iahata, “Rori hotai rei mai osiku ee.” ");
INSERT INTO nxl_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Oyo taue isa ineke iamnii. Anahatana ihokai iasau osiki. Iahata, “Ano mka amataya. Ano arori ia pina rei mai me numa mo, ia sahai wain nea.” ");
INSERT INTO nxl_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ne Abimelekh ineke runai tewasi. Reiso iahata, “Upuku. Au usana tewa. Pene ahunuku runa we mansiau pusima. ");
INSERT INTO nxl_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham ruai isima ata ia pina reimo hotai. Tewa ne ia pina rei ruai iasau san rei oi. Au uanaha runa ia pina rei, anoku manisate. Reiso au usana tewa.” ");
INSERT INTO nxl_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Reiso Anahatana iahata, “E-e. Uanei ata ano aroriki mai tau anom manisate. Reiso unetea na pene apalalosa tanuku. Utapia anekea runa ia pina rei tewa. ");
INSERT INTO nxl_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Hete sae anei nea, reiso auni ia pina rei osi sahai nea. Sahai mo, ia wain ia mamsima runa au, Anahatana, we maunauna. Mka iainisi osia na pene amataya. Ne sani auni ia pina rei tewa reimo, saka atinu. Mka ruam runa me mansiau omata pusimo.” ");
INSERT INTO nxl_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Nene hanroe omnanoe tunne san rei oyo, Abimelekh ianaha runa ne makahaia oyo isima runa ne niine rei osiso. Reiso okaitau hunu ruao. ");
INSERT INTO nxl_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Isima osiso pusi oyo, ianaha runa Abraham oi. Ihokai mai tanui oyo, iahata, “Ano auna masana sae tanuma reini? We masana sae tanua reiso auna siraka reini osiku runa we mansiau pusima reini? Sani rei mo, iake tewa. Kahurae pene auna siraka reini osiku. ");
INSERT INTO nxl_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Amuna na auna san rei osiku rei?” ");
INSERT INTO nxl_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Iahata, “Upu. Uata kani mai rei omi umau okaitau Anahatana tewa reiso mka ohunuku. Uata kani mka sio wason okaumin runa sahaku mka ohunuku. ");
INSERT INTO nxl_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Nene manisate ia mo, hotaku. Uama mania ama osa. Mania inau sakakau. Ne uama anana umau. ");
INSERT INTO nxl_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Reiso Anahatana iaisosiku ueu arihoni amaku ne numa ueu na noi nia rakana. Reiso uasau osi sahaku uahata, ‘Sani anom runaku reimo asau osi sio wason uata isupuso pena niana-niana ata au mo, hotamu.’” ");
INSERT INTO nxl_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Taa san rei, oyo Abimelekh iuni Sara osi sahai. Tau rei irui Abraham ne manianeu umau. Sio pinau runa sio hanaia. Irui ne rompau umau runa ne koropou umau. ");
INSERT INTO nxl_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Iahata, “Abraham. Otoa rasu mai mo, au we otoa pusire. Reiso aruea pusu ruam me maue.” ");
INSERT INTO nxl_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ita iahata osi Sara, “Hotam reini mo, urui kepen panesi osiki nea. Urui perak inata nihuni na pusiso oanei ata ano mo asana tewa.” ");
INSERT INTO nxl_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Abimelekh irori Sara mai ne numa, reiso Yahweh iuna sio pinau pusiso noi rei omutuso. Omutuso noso Sara. Ne Abimelekh iuni Sara nea, reiso Abraham iainisi tau Anahatana osi Abimelekh sio. Reiso Anahatana iunaso iake nea. Reiso sahai runa ne pina makahaia osusu honu. ");
INSERT INTO nxl_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","5","Abraham ne musum utun. Ikore-korei iamtuai nea. Oyo Yahweh irui iake osi Sara sani Ia ruai itotoe rei nea. Sara anai hanaie iamrai tau hunane wan Anahatana ruai iaunutu umetene tanui. Oyo amai ihete nanai tau Isak. Tau Isak ne onona itu amai irehiki. Naone Anahatana iaisosiki irehi sio iki hanaia pusiso. Reiso irehi Isak oi. ");
INSERT INTO nxl_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Isak iamrai poe, oyo inai iahata, “Anahatana irui iake osiku reiso uauman. Tea mo, ukaumin. Sio pusiso oatinu ata ususu nea mka oauman, okaumin okataku. ");
INSERT INTO nxl_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Naone sio oasei tau sahaku, oahata, ‘Ia pina reino mka isusu?’ Masike amai ikore-korei iamtuai nea iae, ususu osiki sirinia.” ");
INSERT INTO nxl_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ia ikine rei ipira iruhu. Iruhu ia mainae mkane nea, oyo inai iarihoni susu runai. Iarihoni susu reiso ouna karisaa mainae. ");
INSERT INTO nxl_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Taue isa Ismael, Abraham anai hanaie rei, iauman Isak. Isak inai tau Sara, ne Ismael inai tau Hagar, ia pina Mesir rei. ");
INSERT INTO nxl_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sara inoo san rei oyo, ipenei tau Ismael nea. Reiso iasau osi Abraham. Iahata, “Nei ia pina makahaie reino runa anai rei. Upeneku tau usama ano me numa hutae reini tau ua. Kahurae anaku hanaie Isak isupu pusire oo!” ");
INSERT INTO nxl_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ne Abraham ipenei tau iatinu sou nanae rei asi. Tea mo, Ismael iae anai oi. ");
INSERT INTO nxl_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ne Anahatana iasau osiki. Iahata, “Pene anom reuponu runa me makahaie runa anam hanaie rei. Apusu Sara ne maue rei. Tea mo, arihoni Isak sahoro asupu mea upu momou wason utotoe osia nea rei. ");
INSERT INTO nxl_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ne Hagar anai Ismael iae mka san rei oi. Mka au una nea upu momou panesi oi. Tea mo, ia iae, anam oi.” ");
INSERT INTO nxl_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Nene hanu omnano tunne san rei oyo, Abraham irui no wekau. Iaiinu tihu tau tasi wani sio onanai arihoni makapana unte. Tasi rei Abraham iakatanai mai Hagar sanini ukune. Oyo iaisosiki ieui runa anai rei. Uaso oeu oneka pusi otoe huie wani nanae Bersyeba. ");
INSERT INTO nxl_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Oeu rotu-tu no tihu wani ororiki rei pusiki, oyo Hagar iautue anai poe ai hasa-hasan isa nohue. ");
INSERT INTO nxl_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Oyo iruei hainau mkane arihoni anai sani sio oana niune ereruma remnahu hainau arihoniso. Iasau pan anoi, “Upeneku tau unoo ia ikine rei imatai asi.” Reiso irani. ");
INSERT INTO nxl_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ia ikine rei irani oi. Anahatana iatinui. Reiso Anahatana ne maisosie on roe noiyaha ioi Hagar on roe nante. Iahata, “Hagar. Anom reuponu runa sae rei? Pene akaitau. Anahatana iatinu anam irani nea. ");
INSERT INTO nxl_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Eua haineke anam reipan na apamanui. Au mka una nea upu momou panesi.” ");
INSERT INTO nxl_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Oyo Anahatana iuna Hagar inoo iake. Reiso inoo parike isa. Inooi oyo, ieu pan, iripa tihu, samatoro iaiinui tau ne tasi rei honu. Iaiinui pusi oyo, iuna anai ininu. ");
INSERT INTO nxl_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Anahatana ikata runa Ismael. Reiso ia ikine rei iruhu nanie ia mainae nea. Orueso ria otoe huie wani nanae Paran. Ia ikine rei ianei irime henue, ianei iana iake nea. Inai iaisosi runa ia pina Mesir isa tau sahai. ");
INSERT INTO nxl_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Tau rei ia ona aia Abimelekh runa ne kapitane, Pikhol, ohokaso mai Abraham. Oahata, “Anahatana iakahaia tau me pakarian pusire waron ananare rei. ");
INSERT INTO nxl_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Reiso mai na asopa mai Anahatana uai anoe. Asopa ata ano mo, mka akarota au tewa runa we hehuka wea upu momou pan muie. Sani we iake runaya, reiso auna iake osi au san rei oi. Auna iake osi au runa sio mai tihue otoe wani aruea reini.” ");
INSERT INTO nxl_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Iahata, “E-e. Iake. Mka usopa san rei.” ");
INSERT INTO nxl_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ne Abraham iamanaru Abimelekh ne makahaia osiki. Iahata, “Me makahaia owahu parike arihoniku nea.” ");
INSERT INTO nxl_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Iahata, “Au uanei tewa ata ia seia iwahui. Asima na reini osiku tewasi. Reiso mato uatinu reini tea!” ");
INSERT INTO nxl_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Oyo Abraham irui rompau runa koropou umau osi Abimelekh. Oyo uaso osopa. ");
INSERT INTO nxl_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham ianena rompa anaya itu. ");
INSERT INTO nxl_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ianenare oyo Abimelekh iasei, “Amuna na anena rompau rai rei?” ");
INSERT INTO nxl_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Iahata, “Ananare noi, na uanei ata ano amanaku ata au sahoro ukani parike reini tea.” ");
INSERT INTO nxl_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Reiso tihue rei nanae Bersyeba tau poe rei uaso osopa. Bersyeba nene nohue “Parike Mamsopae.” ");
INSERT INTO nxl_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Osopa poe Bersyeba suka, oyo Abimelekh runa Pikhol uaso onunso nau sio Pilistin no otoe. ");
INSERT INTO nxl_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Onunso, oyo Abraham irahu ai tamariska anae isa mai Bersyeba. Irahui suka, oyo iainisi iainaa runa Yahweh Anahatana wain iamahaiki rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Taa san rei oyo iruei potuina mai sio Pilistin no otoe. ");
INSERT INTO nxl_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Taue isa Anahatana nanie irea Abraham ata kani anoi runai mainae erenesi anai hanaie ruai te tewa. Reiso Anahatana ioiki san rei, “Abraham.” Oyo iahata, “Sae rei, Upu.” ");
INSERT INTO nxl_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Iahata, “Abraham. Aeu akata anam hanaie Isak wain anom runai mainae rei. Waini ruai man rei. Aeu akatai roe otoe Moria. Mka usima runa tinetae isa roe rei osia. Saka aeu roe na akanupu anam rei osiku.” ");
INSERT INTO nxl_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Nene hanu roe omnano tunne san rei oyo, Abraham ihanui ireta menie. Ireta menie tau nanie iakanupu Isak. Ireta pusi, oyo iapusaa makapana unte roe keledai totue unie tau Isak naniai. (Keledai, nooi sani naitanane ne ikine man.) Oyo ioi ne makahaia ua runa anai hanaie Isak. Iahata, “Mai, na ieuta ria iakanupu makapana osi Anahatana.” Oyo ohitio oeuso onina tihue wani Anahatana iasau osiki rei. ");
INSERT INTO nxl_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Oeu rotu-tu nene onona tonu san rei oyo, Abraham iararoo roe uae inoo tihue wani Anahatana isima runai osiki rei. Inooi hainau mkane asi. ");
INSERT INTO nxl_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Oyo iasau osi ne makahaia, iahata, “Uamo onapama mai rei runa keledai reini. Au runa anaku hanaie uama mka aeuma roe tinetae reiro na nanie ainisi ainaa runa Anahatana samatoro uama anunima mai tanumo honu.” ");
INSERT INTO nxl_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Oyo Abraham isiu menia rai, iautuere roe Isak sanini ukune. Ia ruai sahoro irori usa runa seite. Uaso oeu opusu-pusu umau, ");
INSERT INTO nxl_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","oyo Isak ioi amai, “Ama.” Iahata, “Sae rei anaku?” Iasei, “Ita irori usa runa menia nea reini. Ne rompa anae wanpa tau nanie iakanupui osi Anahatana?” ");
INSERT INTO nxl_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Iahata, “Anaku. Anahatana ruai sahoro mka irui rompa anae rei osita na iakanupui.” Uaso suru roe oeuso sui osa. ");
INSERT INTO nxl_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Oeu rotu-tu ohokaso roe tinetae wani Anahatana isima runai osi Abraham rei. Hoka roe oyo, irane hatu noore sani anau. Iranere pusi, samatoro iaunutu menia on roe haha. Oyo ikanihoo anai hanaie, samatoro iautuei roe hatu hahae runa menia rai na iakanupui. ");
INSERT INTO nxl_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Oyo inana seite na nanie irehi anai hanaie rei. ");
INSERT INTO nxl_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Nanie irehiki ne sira tau Yahweh ne maisosie on roe noiyaha ioi on roe nante. Iahata, “Abraham, Abraham.” Iahata, “Sae rei, Upu?” ");
INSERT INTO nxl_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Pene arehi ia ikine reino. Pene akanupui ee. Ranie hatae reini mato uanei ia-ia ata ano mo, anom runaku nai osa erenesi ruam anam hanaie reino. Reiso ano sahunuti anam hanaie osa reino arihoniku tewa.” ");
INSERT INTO nxl_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Oyo Abraham ihetu unui, isira tau inoo rompa hanaie isa wanau remaninui tau nene sepi-sepia ratala tau ai sanaya. Oyo ieu nau, inana rompa rei na iakanupui osi Anahatana erekati anai hanaie rei. ");
INSERT INTO nxl_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Reiso ioi tihue rei tau Yahweh Irui. Reiso muie reini iae sio oaoi tinetae rei tau Tinetae Yahweh Irui sirinia. ");
INSERT INTO nxl_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ita ia maisosie rei iasau on roe nante honu. ");
INSERT INTO nxl_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","17","“Yahweh iahata, ‘Usopa tau ruaku nanaku mka urui iake osia. Tea mo, arui anam hanaie osa rei osiku. Asahunutiki arihoniku tewa. Reiso mka urui iake osia. Urui mea upu momou panesi nooso sani oneu roe nante. Panesi nooso sani sisia nau nuae. Mea upu momou mka no kawasa tau no nisau. ");
INSERT INTO nxl_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ano atinu tanuku na nanie akanupu anam hanaie, reiso mka urui iake osi sio pusiso mai tuniai reini tau pusu mea upu momou.’” ");
INSERT INTO nxl_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Taa san rei oyo, onunso poe no makahaia ua rei honu. Oyo pusiso onunso poe nia Bersyeba. Abraham iruei poe rei. ");
INSERT INTO nxl_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","23","Abraham inuniki on roe Tineta Moria oyo, sio osima osiki oahata, “Kakam Nahor sahai Milka isusu ne hehuka hanaia wanu nea. Ne hehuka rei nanao mo, Ia manaonete nanai Us. Wanini nanai Bus. Samatoro Kemuel (Aram amai). Samatoro Kesed, Haso, Pildasy, Yidlaf runa ia iki muie Betuel (Ribka amai). ");
INSERT INTO nxl_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahor inana ne makahaie wain nanai Reuma tau sahai. Ia makahaie rei isusu ne hehuka hanaia ate. Ne hehuka rei nanao mo, Tebah, Haham, Tahasy runa Maakha.” ");
INSERT INTO nxl_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara iamahaiki rotu-tu ne musum 127 ");
INSERT INTO nxl_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","oyo imatai. Imatai mai nia Hebron mai otoe Kanaan. Abraham anoi repunokoi runa sahai reiso iatamisiki. ");
INSERT INTO nxl_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","11","Taa san rei oyo ihitio ieui iarihoni sahai waipo inutu rei. Ieu poe iasei tau sio Het. Sio Het rei wason orueso oasau osi umau mai kota nene mitanunue. Iahata, “Wea amau. Au reini mo, au rakane wani urueku mai mo niane reini oi. Reiso uainisi arihonimo, na oahen mo tihu otoe isa osiki. Tihu otoe wani nene hatu nohue na uaunutu sahaku tanui.” Oahata, “Upu. Ami anoo ata Anahatana inoo ano mo, ano mainae. Reiso aunutu saham mai ami man hatu nohue wani iake mainae. Ia isa arihoni ami reini pusima mo, asahunuti ma hatu nohue arihonia tewa na aunutu saham.” Oyo Abraham ihitio irike tune iakapuni sio Het rei aio. Iahata, “Wea amau. Uainisi arihonimo. Sani mo maue na uaunutu sahaku mai rei, reiso oasau osi Efron, Sohor anai hanaie rei. Oasau osiki na iahen ne tihu otoe wani nene hatu nohue osiki. Ne hatu nohue rei nanae Makhpela wani haineke ne nisi nusue. Oasau osiki na iaheniki osiku na usenui osiki. Usenui samatoro uaunutu we sio matana mai mo otoe reini oi.” Abraham waimo iainisi arihoniso rei, ne Efron, ia Het rei wain ne tihu otoe rei tutui oi. Irue ikata sio Het rei pusiso oi. Reiso iahata, “Tewa upu. Hatu nohue runa nisi rei mka uruiki osia san rei man. Uruire osia mai we mansiau uao anoa. Uruire na aunutu me sio matana tanui.” ");
INSERT INTO nxl_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham iatinu san rei irike tune isopa kokuro pusiso. ");
INSERT INTO nxl_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Irike tune samatoro iasau osi Efron. Iahata, “Efron. Atinu tanuku ee. Au, mka usenu me nisi runa me hatu nohue rei. Uainisi arihonia na anana kepen raini tau nene hunonia. Na uaunutu sahaku tanui.” Uaso oanamana rei, sio Het pusiso wason oru-rueso oatinu no anamanae rei. ");
INSERT INTO nxl_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Abraham nanie isenure ne Efron iahata, ");
INSERT INTO nxl_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Upu. Uainisi arihonia. Tuamane wani poe hatu nohue runa nisi rei hunonie hasae perak inata utun ate. Uata ioi umau tau neta, reiso uhete hunonie mainae tewa. Aunutu saham poe hatu nohue reipo.” ");
INSERT INTO nxl_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Iahata, “Iake. Mka usenure.” Reiso masike ihete hunonie mainae san rei iae, iheu perak waron Efron iasau runare, areimo perak inata utun ate. Iheure pusu sio manahenia. Isenure osi Efron mo, sio Het pusiso wason ono-noo. ");
INSERT INTO nxl_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Isenure nea oyo, Efron ne tuamane wani poe Makhpela poe Mamre on ria hae rei osi Abraham. Nisi runa hatu nohue runa aiu poe nisi rei pusire osiki. ");
INSERT INTO nxl_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Sio Het pusiso wason oru-rueso poe kota nene mitanunue rei onoo ata tuamane rei osi Abraham nea. ");
INSERT INTO nxl_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Taa san rei oyo, Abraham iautotu sahai ieu iaunutui pan hatu nohue rei. Hatu nohue wani pan Makhpela pan otoe Kanaan. ");
INSERT INTO nxl_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Reiso nisi runa hatu nohue rei osi Abraham nea na iaunutu ne sio matana tanui. ");
INSERT INTO nxl_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham ikore-korei iamtuai nea. Yahweh irui iake osiki pusu sae man. ");
INSERT INTO nxl_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Nene taue isa iasau osi ne ia makahaie wain ia manaonete arihoni ne sio makahaia pusiso utuso. Ia makahaie wain isaka ne numa hutae pusiki rei. Abraham iahata, “Mai na uata isopa mtinte reiso mai na akahuu karaku pusu re monne. ");
INSERT INTO nxl_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Isopa mtinte, Yahweh Anahatana inoo. Ia mo, Anahatana wain irime nante na tuamane. Asopa ata mka apenea anina ia pina isa osi anaku hanaie Isak mai otoe Kanaan reini. ");
INSERT INTO nxl_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Kahurae aeua pan we niane na anina ia pina hehuke isa arihoni ruaku we ipane taue osi anaku hanaie.” ");
INSERT INTO nxl_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Iahata, “Upu. Sani ia iki pina hehuke rei ipenei ieui iarihoni ne mansia mainaya na ieu ikataku mai rei mo, kahurae urori Isak suru pan?” ");
INSERT INTO nxl_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ne iahata, “Pene! Pene arori anaku suru pan. ");
INSERT INTO nxl_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yahweh Anahatana wain irime nante runa tuamane iaisosiku uhokaku arihoni amaku ne numa nea. Reiso uhokaku arihoni we mansiau runa we niane nea. Anahatana itotoe osiku. Iahata mka irui tuamana raini osi wea upu momou. Anahatana mka iaisosi ne masisosie on roe noiyaha ihokai pan naone na iakahaia. Iakahaia na anina ia iki pina hehuke isa osi anaku hanaie. ");
INSERT INTO nxl_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ne sani ia iki pina hehuke rei ipenei ieu ikataya mai rei, areimo mamsopae wani uata isopai reini, mka eresupua tewa. Masike sapan iae, pene arori anaku rei suru pan!” ");
INSERT INTO nxl_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Sani rei oyo ia makahaie rei iaunutu hanai atue poe upui Abraham karai pusu no monne, samatoro isopa sani upui iaisosiki rei. ");
INSERT INTO nxl_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Isopa pusi oyo, inana upui ne unta hata hutusa. (Unta mo, makapana wani nene totu unie nene pupua sonota.) Irori unta rai runa upui ne apia waron iaka umau sani api hunahana. Iapusaare roe unta nene totu unia na rarorire. Inana pusire, samatoro ihitio ieu na pan niane wani Nahor iruei tanui pan otoe Mesopotamia. ");
INSERT INTO nxl_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Hoka pan oyo, ikanihoo ne unta rai na raranahaso mai parike nusue mai niane muie. Tea mo, ranie manne nea. Ranie manne mo, sio pinau mai niane rei osaka oeu oripa tihu poe parike rei. ");
INSERT INTO nxl_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Reiso Abraham ne ia makahaie rei iainisi, “Yahweh Anahatana. Ano wani upuku Abraham iainisi iainaa runaya. Uainisi arihonia na akahaiku na usupu ia pina hehuke isa osi upuku anai hanaie. Akahai upuku Abraham na auna anai hanaie iausahai. ");
INSERT INTO nxl_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Au wani uhaineke parike nusue reini. Potuina tewa oi, mka sio pina hehuka mai niane reini ohokaso mai, oripa tihu. ");
INSERT INTO nxl_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Reiso uainisi arihonia na ia iki pina hehu seia man wain mka uainisi tihu arihoniki na uninu, reiso mka irati ne tihu na uninu. Sani irati ne tihu rei no uninu, ouo sani iahata, ‘Me unta raino mka uunare raninu oi.’ Na uanei ata ano aroma ia pina hehuke rei osi me manorine Isak. Unoo san rei, areimo mka uanei ata anom iake runa upuku Abraham.” ");
INSERT INTO nxl_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","Iainisi pusi tewasi oimo, sira tau ia iki pina hehu iake tunne isa ihokai. Ianei isoulaha tewasi. Nanai Ribka. Ia mo, Betuel anai pina. Momoi onate tau Nahor, momoi pina onate tau Milka. Nahor mo, Abraham kakai. Ihokai nanie iripa tihu poe parike rei. Iasaoa ne tihu huie. Ihokai poe oyo, iaiinu ne tihu huie rei tau tihu. Oyo on poe nanie inuniki. ");
INSERT INTO nxl_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ne Abraham ne ia makahaie rei iruma na mai ihainekei. Iahata, “Ina. Akahaiku ee! Na uninu tihu noi me tihu huie reino ee.” ");
INSERT INTO nxl_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Iahata, “Mai, na aninu upu.” Oyo irati ne tihu rei sisaa arihoni manai. Poe oyo, iuna ia onate rei ininu. ");
INSERT INTO nxl_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ininu suka oyo ia pina hehuke rei iahata, “Upu. Mka uripa tihu osi me unta rai oi. Na me makapanau raninu rotu-tu tiaya pokona. Tea mo, ano kasaya oi, tea!” ");
INSERT INTO nxl_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Reiso isuhu tihu tau unta nene tihu naniaya sisaa na raninu. Ita iruma poe, iripa tihu honu. Inina na tihu panesi na iunare raninu rotu-tu ramkona honu. ");
INSERT INTO nxl_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ieu inuni nana iripa tihu, ne Abraham ne ia makahaie rei iari-ariniiki rotu-tu ianamana sae isa tewa oi. Iariniiki na ianei ata kani Yahweh iakahaiki na isupu Isak sahai te tewa. ");
INSERT INTO nxl_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Unta rai raninu pusi oyo, Abraham ne ia makahaie rei ihoka hunahana waron hunonia mainaya waron sio pinau tau ia ne naene oausahure. Ihoka sapauu iausahui roe ia pina hehuke rei okoi. Sapauu rei mtinte haineke gram 6. Ihoka nitianaya ua waron mtinta gram 114. ");
INSERT INTO nxl_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Oyo iahata, “Masi asima ee. Ano mo, amam tau ia seia? Mo naniake huie isa waria mo numa te tewa na anekema tanui?” ");
INSERT INTO nxl_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Iahata, “Upu. Au mo, Betuel anai. Betuel mo, Nahor runa Milka no hehuke. ");
INSERT INTO nxl_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ria mani numa naniake huie waria, upu. Monota waron kaimenna osi makapanau iae warora oi.” ");
INSERT INTO nxl_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Iatinu san rei oyo, irike tune iainisi iainaa runa Anahatana. ");
INSERT INTO nxl_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Iahata, “Upuku Anahatana uainaa runaya. Ano mo, ano Anahatana wani upuku Abraham iainaa runaya. Ano arihoni tewa auna iake osi upuku Abraham. Ano arime kuru-kuru me anamanaya. Au reini mo, ano akata runaku rotu-tu uhokaku mai upuku Abraham ne mansiau reini.” ");
INSERT INTO nxl_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Taa san rei oyo, ia iki pina hehuke rei irumai inuniki ria inai ne numa. Hoka ria oyo iruni osi ne mansia mainaya. ");
INSERT INTO nxl_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ribka hotai isa nanai Laban. Iatinu hotai iruni runa Abraham ne ia makahaie rei samatoro inoo sapauu roe hotai okoi runa nitianaya poe hanai atue. Inoo san rei oyo, iruma poe, inoo. Hoka poe oyo, inoo Abraham ne ia makahaie rei waipo iooi runa ne unta poe parike rei nusue asi. ");
INSERT INTO nxl_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Oyo iahata, “Upu. Ano mo, Yahweh irui iake osia. Reiso pene aruea mai mui reini. Mai na ieuta ria numa. Ami aseka tau naniam nea. Me unta iae, aseka tau naniaya oi.” ");
INSERT INTO nxl_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Reiso ia makahaie rei ipusui. Uaso onususo ria numa. Laban iaisosi ne sio makahaia orati unta nene apia, oyo orui mono kaimenna osi makapanau rai raai. Orui monota osi ne makapanau rai ne orui tihu osi ia makahaie rei runa ne mansiau. Orui tihu osiso nanie osohu aio atua. ");
INSERT INTO nxl_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Taa san rei oyo, orata muaina. Ne sira tau Abraham ne makahaie rei iasau san rei, “Napa mkane ee. Usima runa we anamanae reini ee, samatoro iaita.” Laban iahata, “Reiso anamana roe, upu.” ");
INSERT INTO nxl_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Oyo iahata, “Au reini mo, Abraham ne ia makahaie. ");
INSERT INTO nxl_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yahweh irui iake mainae osi upuku Abraham. Irui iake mainae osiki reiso ne kaya. Irui ne rompau, ne koropou, ne unta, runa ne keledaiu. Irui ne hunahana runa ne perak. Irui ne sio pina makahaia runa sio hanai makahaia. ");
INSERT INTO nxl_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Samatoro sahai Sara isusu ia iki hanaie isa. Aikee sae mo, ikore-korei iamtuai nea. Upuku Abraham irui ne numa hutae pusiki osi anai hanaie rei. ");
INSERT INTO nxl_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Iaisosiku usopa. Iahata, ‘Pene anini ia pina hehu Kanaan isa oi osi anaku hanaie. Pene iausahai mai otoe Kanaan wani irueta reini.’ ");
INSERT INTO nxl_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Iaisosiku ueuku mai amai ne numa, mai ne mansiau na unina ia pina hehuke isa osi anai hanaie. ");
INSERT INTO nxl_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Oyo uasei, ‘Sani ia iki pina hehuke rei ipenei ieu ikataku suru mai mo, sapan?’ ");
INSERT INTO nxl_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Oyo iahata, ‘Yahweh wain upusui na ukata ne anamanaya mka iaisosi ne maisosie on roe noiyaha na ikataya. Ikataya na iakahaia tau me arena reini na asupu ia iki pina hehuke isa osi anaku. Mka asupui pan ruaku we mansiau pan amaku ne numa. ");
INSERT INTO nxl_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ne sani ia iki pina rei runa ne mansiau openeso mo, mka mamsopae rei eresupua tewa.’ ");
INSERT INTO nxl_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ne sinasi uhokaku poe parike rei nusue oyo uainisi pan anoku. Uahata, ‘Yahweh Anahatana. Ano sahoro upuku Abraham iainisi iainaa runaya. Reiso Upu, uainisi arihonia na akahaiku runa we arena reini na usupu ia iki pina hehuke isa. ");
INSERT INTO nxl_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Reiso akahaiku na uooku mai parike rei nusue sui osa. Na sani ia iki pina hehuke isa ihokai iripa tihu oyo uainisi tihu arihoniki na uninu.’ Uahata, ‘Masi akahaiku na uninu mkane arihoni me tihu reino ee.’ ");
INSERT INTO nxl_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Oyo sani iamanaku, iahata, ‘E-e. Mai na aninu, upu. Runa me unta rai raninu oi.’ Samatoro au uanei ata ia iki pina reimo, Yahweh ruai ininiki osi upuku Abraham anai hanaie. ");
INSERT INTO nxl_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Uainisi pan anoku suka tewasi oyo, sira tau Ribka ihokai. Iasaoa ne tihu huie nanie iripa tihu poe parike. Iripa ne tihu suka oyo, uahata, ‘Ina. Akahaiku ee, na uninu arihoni me tihu reino ee.’ ");
INSERT INTO nxl_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Oyo ia iki pina rei irati ne tihu arihoni manai sisaa oyo iahata, ‘Upu, mai na aninu. Runa me unta rai iae mka au unare raninu oi.’ Reiso uninu. Oyo iuna we unta rai raninu oi. ");
INSERT INTO nxl_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Raninu suka oyo uasei, ‘Amam tau ia seia?’ Iahata, ‘Amaku tau Betuel, Nahor runa Milka no hehuke hanaie.’ Uatinu san rei oyo, uhoka sapauu oyo uausahui roe okoi, nitianae unue, unusui tau hanai. ");
INSERT INTO nxl_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Reiso rike tune uainisi uainaa runa Yahweh. Yahweh Anahatana wain upuku Abraham iainisi iainaa runai. Uahata, ‘Yahweh Anahatana. Ano mo, ano iake nai osa. Ano akahaiku rotu-tu uhokaku mai rei. Uhokaku mai upuku Abraham ne mansiau. Reiso uhokaku mai, usupu ia iki pina hehuke rei arihoni ne mansiau osi anai hanaie. Usupu kakai momoi.’ ");
INSERT INTO nxl_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Reiso ranie hatae reini sani mo maue na anomo runa upuku Abraham, areimo oamanaku orui mo hehuke pina osi upuku anai hanaie, areimo oasau. Sani mo maue oruiki te, tewa te. Hete sae, oasau osiku mai na uanei ia-ia ata nanie una sae.” ");
INSERT INTO nxl_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban runa Betuel oahata, “Upu. Ami asau sae isa tewa oi tau anamanae reimo arihoni Yahweh. Reiso ami anei tewa ata nanie asau sae. ");
INSERT INTO nxl_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ne mai. Ribka ia reini. Ananai niu na ieu ikataya. Ikataya, na ria inana upum Abraham anai tau sahai sani Anahatana ruai iasau rei.” ");
INSERT INTO nxl_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ia makahaie rei iatinu san rei oyo irike tune iainaa runa Yahweh. ");
INSERT INTO nxl_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Irike tune samatoro ihoka apia runa hunahana na perak. Ihoka pusire oyo iruire osi Ribka. Irui apia umau osi Ribka hotai runa inai oi. Irui apia waron hunonia mainaya. ");
INSERT INTO nxl_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Taa san rei oyo ia makahaie rei runa ne mansiau oaiso. Oaiso suka oyo, onekeso noi Ribka sio. Onekeso onone hatae. Nene hanu omnanoe oyo ia makahaie rei iahata, “Upu. Tapiku na ununiku poe upuku Abraham nea.” ");
INSERT INTO nxl_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Oyo Ribka hotai runa inai oahata, “Ribka iruei ikatama onona hutusa te minggu unue isa ee. Samatoro ieui.” ");
INSERT INTO nxl_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ne iahata, “Pene osopo onetema nea. Ne Yahweh iakahaiku reiso rotu-tu usupu Isak sahai. Reiso otapima na anunima poe upuku nea.” ");
INSERT INTO nxl_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Oahata, “Reiso mai na ioi Ribka na iasei tanui ee.” ");
INSERT INTO nxl_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Reiso ooiki oyo oasei tanui. “Me maue na apusu sio reini te tewa?” Iahata, “E-e. Iake.” ");
INSERT INTO nxl_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Reiso otapi Ribka runa ne ia pina mampakananae oeuso runa Abraham ne makahaie rei runa ne mansiau. ");
INSERT INTO nxl_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Oainisi na Anahatana irui iake osiki. Oasau oahata, “Ami ainisi na asusu haha panesi rotu-tu mea upu momou sio nihun nanan. Mea upu momou rei mka oheta tau no nisau.” ");
INSERT INTO nxl_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Reiso Ribka runa ne sio makahaia rei oseka tau no apia. Oyo osaaso roe unta. Osaa roe oyo, oeuso okata Abraham ne makahaie runa ne mansiau rei. ");
INSERT INTO nxl_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Tau Abraham ne makahaie ieui pan Laban sio mo, Isak ipaki ne apia ieui poe parike wani nanae Lahai-Roi. Lahai-Roi nene nohue, “Ia inoo au sui osa.” Iruei mai Kanaan on poe hae. ");
INSERT INTO nxl_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Taue isa tau ranie manne ihokai iarinii roe ne nisi anoe. Ne ihetu unui, isira tau inoo unta umau waron hainau asi. ");
INSERT INTO nxl_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Unta raimo, Abraham ne makahaie runa ne mansiau. Ribka iae ihetu unui, inoo Isak. Oyo isipui arihoni ne unta rei. ");
INSERT INTO nxl_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Iasei arihoni Abraham ne makahaie rei. Iahata, “Ia hanai seia wain on poe ieui imetata reini?” Iahata, “Au upuku Isak.” Reiso Ribka inete uai anoe tau hana-hana. ");
INSERT INTO nxl_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Hoka mai oyo, ia makahaie rei iruni osi Isak runa sapani na isupu Ribka osiki nanie tau sahai rei. ");
INSERT INTO nxl_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Reiso Isak inusu irori Ribka pan numa anoe. Pani inai ne numa wani sio onanai arihoni makapana unta. Oyo inanai tau sahai. Isak anoi runai. Anoi runai reiso anoi mirike nai osa, anoi repunoko inai tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham iausahai honu. Sahai honue reimo nanai Ketura. ");
INSERT INTO nxl_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Isusu ne hehuka hanaia wason nanao: Simran, Yoksan, Medan, Midian, Isybak runa Suah. ");
INSERT INTO nxl_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan isusu ne hehuka wason nanao Syeba runa Dedan. Dedan nea upu sahoro muie reini oaoiso tau sio Asyur, sio Letus runa sio Leum. ");
INSERT INTO nxl_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midia ne hehuka tau: Efa, Efer, Henokh, Abida runa Eldaa. Sio rei pusiso noa upu tau Ketura. ");
INSERT INTO nxl_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Masike Abraham irui Isak ne kawasa tau numa anoe rusun aikuna ");
INSERT INTO nxl_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","tau wain ikarihuru iamahai asi iae, isaka iru-rui apia runa muaina osi Isak nea waniu rei oi. Oyo iaisosiso orue hainau arihoni Isak. Orue ria otoe Kanaan on ria hae. ");
INSERT INTO nxl_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abraham ikore-korei iamtuai nea oyo imatai. Imatai tau ne musum utun hutu itu rahana nima. ");
INSERT INTO nxl_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Imatai oyo Isak runa Ishmael uaso oautotui, oaunutui pan hatu nohue wani nanae Makhpela. Hatu nohue wani haineke nia Mamre on ria hae. Wani mai nisi anoe wani Abraham ihane arihoni Efrom. Efrom mo, Sohar anai, ia Het rei. Abraham ihanei na iaunutu sahai Sara tanui. Reiso oeu oaunutu Abraham tanui na ikata sahai oi. ");
INSERT INTO nxl_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham imatai, oyo Anahatana irui iake osi Isak. Tau rei Isak iruei haineke parike wani nanae Lahai-Roi asi. Lahai-Roi nene nohue “Ia inoo au sui osa”. ");
INSERT INTO nxl_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ismael mo, Abraham anai. Inai tau Hagar, ia pina Mesir rei. Sara ne makahaie. ");
INSERT INTO nxl_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismael ne hehuka wason nanao: Nebayot, ia manaonete, samatoro Kedar, samatoro Adbeel, samatoro Mibsam, ");
INSERT INTO nxl_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","samatoro Misyma, samatoro Duma, samatoro Masa, ");
INSERT INTO nxl_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","samatoro Hadad, samatoro Tema, samatoro Yetur, samatoro Nafis, samatoro Kedma ia iki muie tune rei. ");
INSERT INTO nxl_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Sio hutusa rahana ua sahoro ouna numa upua tau ipana hutusa rahana ua. No niana mo, ohetere pusu nanao. ");
INSERT INTO nxl_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael ne musum utun hutu tonu rahana itu oyo imatai. ");
INSERT INTO nxl_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Nea upu momou orueso sui otoa on poe Syur rotu-tu ohoka pan Hawila. Syur mo, wapo Mesir on ria hae, ria arena wani nanie ereeui ria Asyur. Orueso hainau arihoni Abraham nea upu momou umau honu. ");
INSERT INTO nxl_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Areini sou monae rerihoni Isak. Isak mo, amai tau Abraham. ");
INSERT INTO nxl_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isak ne musum hutu ate samatoro inana Ribka. Ribka mo, Laban hotai. Noa ama tau Betuel. Betuel mo, upui tau Aram. Sio mo, arihoni otoe Mesopotamia. ");
INSERT INTO nxl_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Onana umau potuina nea ne Ribka isusu tewasi. Isusu tewasi reiso Isak iainisi osi sahai arihoni Yahweh. Oyo Yahweh irui sae wani Isak iainisiki rei. Reiso sira tau Ribka tinain taua. ");
INSERT INTO nxl_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ribka iahana sani sio ikina ua nisu-nisuo pan tiai anoe reiso iasau pan anoi, “Ira oe! Sapan na sio ikina ua reini nisu-nisuo oakarema umau pan tiaku anoe reini omi?” Reiso iainisi tau Yahweh san rei, “Upuku Anahatana. Sapan na sio ikina ua reini nisu-nisuo na oakarema umau mai tiaku anoe reini?” ");
INSERT INTO nxl_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Reiso Yahweh isima osiki iahata, “Niana ua waromo tiam anoe reino tea! Ano mka arue runa niana ua waron mka oahita runa umau. Ia isa mka iamkona erenesi ia isa. Ia manaonete mka ianori runa ia muie.” ");
INSERT INTO nxl_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Taa ne hunana mtuaya oyo, iruei runa sio iki alalekau. Sio ikina ua rei, sio iki hanaia. ");
INSERT INTO nxl_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ia wain iheta manahane ianaone mo, ia msinae, samatoro ne hunua noo sani papite wani nene hunua panesi rei. Reiso ohete nanai tau Esau. Esau mo, nene nohue, “Hunua.” ");
INSERT INTO nxl_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ita ia muie honu. Ne hanai atue wanane rekahuu kakai toui. Reiso ohete nanai tau Yakup. (Yakup nene nohue iakahuu toui. Iakahuu toui, areimo rekakina ata ia mo, mka iakarota.) Uaso oamrai pannuhu Isak ne musum hutu nome nea. ");
INSERT INTO nxl_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Esau runa Yakup sio mainaya nea. Esau ianei iakaohu. Reiso ia ne suka ieu inekei noi wesie. Ne Yakup mo, ia menene. Ia ne suka iruei mai numa man. No numa wani onanai arihoni makapana unte. ");
INSERT INTO nxl_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Reiso Isak anoi runa Esau. Tea mo, ia ne suka iai peniu waron Esau ihunure. Ne Ribka mo, anoi runa Yakup. ");
INSERT INTO nxl_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Tau ranie hatae isa Yakup wain irie sanau kihue msinae. Waini irie sanaute oyo sira tau Esau ihokai on ria wesie. Imata muaine. ");
INSERT INTO nxl_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Reiso Esau iasau osi Yakup san rei, “Rui we sanau kihue msinae reino mkane mai. Tea mo, wani umata muaine nea reini!” Reiso ohete nanai tau Edom. (Edom atinui sani “Msinae” tau sou Ibrani.) ");
INSERT INTO nxl_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakup iahata, “Iake. Mka urui osia sirinia. Hete sae arui me kawasa manaonete rei na urime numa hutae, ipane taue pusiki.” ");
INSERT INTO nxl_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Iahata, “Iake. Nanie umata muaine nea reini! Umataku mka una sae runa we kawasa rei?” ");
INSERT INTO nxl_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Iahata, “Reiso asopa osiku ee. Samatoro mka urui sanaute reini osia.” Oyo Esau isopa mai Yakup uai anoe. Iahata, “Iake. Urui we kawasa manaonete osia nea. Hete sae uai sanau kihue msinae reino.” Reiso iahen ne kawasa manaonete rei osi wanin Yakup. ");
INSERT INTO nxl_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Oyo Yakup irui poroti runa sanau kihue msinae osi Esau. Esau iaiki rotu-tu tiai pokone samatoro ihitioi ieui. Tau san rei Esau ipenei tau ne kawasa manaonete rei. ");
INSERT INTO nxl_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Poe otoe Kanaan reimo muaina tewa sani naone Abraham iamahaiki asi rei. Muaina tewa reiso Isak sio ohitio oeuso na poe nia Gerar. Hoka poe oyo, iainisi arihoni Abimelekh ia ona aia Pilistin na orueso poe rei. ");
INSERT INTO nxl_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ieu poe Gerar. Tea mo, Upuri iatuhete ruai osiki nea, iasau san rei. Iahata, “Pene aeua poe otoe Mesir nea. Aruea pan otoe wani mka uasau osia reini. ");
INSERT INTO nxl_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Aruea mai otoe reini mkane ee. Mka ukatamo na urui iake osimo sui osa. Otoe Kanaan reini pusiki mka uruiki osia. Uruiki osia runa mea upu momou pusiso utuso. Mka urui sae waron utotoe osi amam Abraham rei. ");
INSERT INTO nxl_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Mka urui mea upu momou panesi nooi sani oneu roe nante. Au mka urui otoe reini osiso oi. Mka urui iake osi sio niana pusiso pusu upum isa. ");
INSERT INTO nxl_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Mka urui iake osimo. Tau Abraham iatinu tanuku. Ipusu we maunauna pusire uture.” ");
INSERT INTO nxl_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Reiso Isak iruei poe Gerar. ");
INSERT INTO nxl_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Orueso poe nia Gerar oyo sio onoo Ribka mo, ia iake. Oasei tau Isak san rei, “Ribka mo, hotam te saham?” Isak iausau iahata, “Ia mo, sahaku tewa ne hotaku.” Tea mo, Isak ikaitau sio poe niane rei mka ohunui sani iasau ata sahai. Tau Ribka mo, nooi ia iake nai osa. ");
INSERT INTO nxl_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isak iruei poe nia Gerar nea. Ranie hatae isa ia ona aia inoo pusu yanela. Inoo Isak iasa-asamau Ribka. ");
INSERT INTO nxl_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Reiso ioi Isak na iasei tanui, “Ia pina reimo titie saham te hotamu?” Iahata, “Ia pina rei, sahaku. Sani sinana uasau uahata, ‘Sahaku’ mka ohunuku reiso uasau uahata, ‘Hotaku’ rei tea.” ");
INSERT INTO nxl_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Iahata, “Ano auna sae tanuma reini? Sinana we sio iki hanaia mai niane reini oneke okatai sapan? Reiso pene apasanama. Tea mo, ruam asana.” ");
INSERT INTO nxl_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Taa san rei oyo, iasau osi ne sio iki hanaia poe niane hahae rei. Iahata, “Sani ia isa mai niane reini iakarema ia hanaie reini te, isoulaha ia pina reini te, mka imatai.” ");
INSERT INTO nxl_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Reiso Isak iruei poe niane rei. Iruei poe niane rei oyo inana ne tanei apia, irahu ne nisi. Irahu ne nisi rei, Upuri irui iake osiki reiso isupu muaina panesi. Sani irahu atuhu anae osa man ne isupu ne atuhu utun. ");
INSERT INTO nxl_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Isupu ne atuhu panesi reiso ne kaya. ");
INSERT INTO nxl_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ne manianeu panesi. Ne rompau ne une-uneu panesi. Ne koropou panesi. Reiso sio Pilistin oananai. ");
INSERT INTO nxl_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Oananai reiso osou no parikeu tau tapune. Parikeu raimo, amai Abraham ne manianeu okanire on Abraham iamahai asi. ");
INSERT INTO nxl_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Taa ia ona aia iatinu san rei oyo, ioi Isak. Isak ihoka mai oyo, ia aia iasau san rei, “Aeu arihoni mani otoe reini nea. Tea mo, ano me kawasa anesi ami nea.” ");
INSERT INTO nxl_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Reiso Isak sio ohitio oeuso rotu-tu ohokaso poe watane Gerar. Hoka poe samatoro oapuoo no wanane wani sio ounai arihoni makapana unta. Oapuooi pusi oyo orueso poe rei. ");
INSERT INTO nxl_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Sio okani parikeu umau honu. Parikeu rai iae, sio Pilistin sahoro osoure tau tapune. Parikeu raimo Abraham ne manianeu okanire on Abraham iamahai asi. Imatai oyo sio Pilistin osoure. Parikeu rai Isak ihete nanaya sani amai naone ihete nanaya rai. ");
INSERT INTO nxl_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isak ne manianeu okani parike poe Watane Gerar, osupu tihu panesi. ");
INSERT INTO nxl_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ne sio mamsaka rompau on poe Gerar oatana runa Isak ne sio mamsaka rompau. Oahata, “Waene reini mo, ami mani waene.” Reiso Isak ihete parike rei nanae Esek wani nene nohue “Atana Runa Umau.” ");
INSERT INTO nxl_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ita Isak ne manianeu okani parike isa honu. Ne oatana runa umau sinia. Reiso Isak ihete parike rei nanae Sitna wani nene nohue “Nisa.” ");
INSERT INTO nxl_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ita oeuso arihoni rei, oyo okani parike isa honu. Parikeu tonu nea. Parike isa reini honu mo, oatana runa umau tewa nea. Reiso Isak ihete nanae Rehobat wani nene nohue “Tuamana Ralai.” Reiso Isak iahata, “Upuri irui iake osita na irueta mai otoe reini. Mka ita panesi iuna kaya mai niane reini.” ");
INSERT INTO nxl_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ita Isak ieui honu, ihokai pan nia Bersyeba. ");
INSERT INTO nxl_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Tau mono rei Yahweh iatuhete ruai osiki. Iahata, “Au mo, au Anahatana wain amam iainisi iainaa runaku. Pene akaitau. Au mka ukata runaya. Urui iake osia. Mka mea upu momou panesi sani sae wani utotoe osi amam rei.” ");
INSERT INTO nxl_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Oyo Isak irane hatu noore sani anau samatoro iainisi iainaa runa Upuri. Oyo iapuoo ne wanane pan otoe rei. Ne wanane rei mo, ounai arihoni makapana unta. Ita ne manianeu okani parike isa honu. ");
INSERT INTO nxl_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Taue isa ia ona aia Abimelekh on poe nia Gerar ihokai pan Isak. Ihokai ikata Ahusat runa Pikhol. Ahusat mo, isaka iau-aunaui. Pikhol mo, isaka iai-aisosi sio tentara. ");
INSERT INTO nxl_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ohokaso pan, oyo Isak iasei tanso, “Ohokamo mai tanuku muie reini nanie taa hae? Aikee naone mo, openemo tanuku rei. Rotu-tu oneiku arihoni mo niane rei, tea!” ");
INSERT INTO nxl_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Abimelekh iahata, “Ama. Muie reini mo, ami mato anei ata Upuri ikata runaya. Reiso ami nanie aeuma mai tanua na asau osia na uata isopa. Uata isopa ");
INSERT INTO nxl_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","na pene omi ouna kahatene tanuma. Nooi sani ami iae auna kahatene tanumo tewa rei. Auna iake runamo reiso atapimo oeumo anori kaia runa umau. Auna kahatene isa tanumo tewa. Reiso ami anei ata Yahweh ikata runaya. Irui iake osia.” ");
INSERT INTO nxl_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Oanamana pusi oyo, Isak iaisosi ne manianeu onana muaine oyo oaiso. ");
INSERT INTO nxl_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Nene hanu omnanoe wapan ereputi-puti asi oimo, uaso ototoe osopa nea. Osopa pusi oyo, Isak iahaaso, “Eu noi. Oeu ainati rotu-tu ohokamo poe mo niane.” Oyo Abimelekh sio onunso. ");
INSERT INTO nxl_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Tau ranie hatae rei, Isak ne manianeu ohokaso tanui osima osiki. Oahata, “Ami akani parike isa honu. Asupu nene tihu panesi.” ");
INSERT INTO nxl_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Reiso Isak ihete nanae tau Syeba. Nene nohue mo, sopa. Reiso niane rei nanae san rei rotu-tu reini. Nanae Bersyeba. ");
INSERT INTO nxl_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau ne musum hutu ate, oyo iausahai inana sio pinau ua arihoni sio Het. Ia isa nanai Yudit. Amai tau Beeri. Ia isa nanai Basmat. Amai tau Elon. ");
INSERT INTO nxl_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Sio pinau ua rei no haliu iaka tewa. Reiso Esau inai Ribkha runa amai Isak oatamisi no pina msahana rei. ");
INSERT INTO nxl_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isak ikore-korei iamtuai. Matai usena raputiso nea. Reiso taue isa ioi Esau, anai hanaie manaonete. Iahata, “Esau.” Esau isana, “Oe, ama.” ");
INSERT INTO nxl_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Iahata, “Ano anei ata wani uamtuaku nea, tea! Reiso mka ukarihuru uamahai potuina tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Reiso anana me henua niuna, na aeu akaohu na ahunu peni isa mai osiku. ");
INSERT INTO nxl_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Aroriki hokaya mai, oyo aapamasai ia-ia pusu sae wani we sukai rei. Roriki mai osiku na uaiki. Tiaku pokone pusi samatoro uainisi arihoni Anahatana na irui iake osia. Uainisi osia on wani uamkona asi reini.” ");
INSERT INTO nxl_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Isak runa Esau wason oanamana ne, Ribka iatinu. Reiso taa Esau ihitio ieu iakaohui, ");
INSERT INTO nxl_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","oyo Ribka ioi Yakup. Iahata, “Yakup. Eu mai ee. Na uasau na sae isa reini wani mato uatinui. Amam mato iasau osi kakamu. Iahata, ");
INSERT INTO nxl_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Aeu na ahunu peni isa osiku mai. Apamasai ia-ia pusu sae wani we sukai rei. Na uaiku tiaku pokone samatoro uainisi arihoni Yahweh na irui iake osia. Uainisi osia on wani uamkona asi reini.’ ");
INSERT INTO nxl_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Reiso mai na atinu ia-ia runa sae wani nanie uasau osia reini. ");
INSERT INTO nxl_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Eua pan re makapanau naniaya na anini une-une honua hata ua waron rapokotueso. Aninire na uapamasare ia-ia pusu sae wani amam ne sukai rei. ");
INSERT INTO nxl_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Na aroriki osiki na iaiki. Iaiki tiai pokone na iainisi na Anahatana irui iake osia on wain iamkona asi reini.” ");
INSERT INTO nxl_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ne Yakup iahata, “Ina, ano anei, tea! Kakaku mo, ne patane hunua panesi. Ne au mo, tewa. ");
INSERT INTO nxl_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Pene tu-tu amaku iakahuu hanaku atue na iahana ata hanaku atue nene hunua tewa, areimo uakarotai rei, tea! Reiso mka iainisi arihoni Anahatana na irui iake osiku tewa, ne mka iainisi arihoni Anahatana na irui kahatene osiku.” ");
INSERT INTO nxl_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Inai iahata, “Anaku. Pene anom reuponu san rei! Mka au sahoro uhana rosa rei. Reiso eu na anana sae wani uasau osia rei. Eu na anana une-uneu rai mai osiku. Pene anom reuponu.” ");
INSERT INTO nxl_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Taa san rei oyo, Yakup ieu inana une-uneu rai osi inai. Iseka tau pusire pusi oyo iruire osi inai iapamasare. Iapamasare pusu sae wani amai ne sukai rei. ");
INSERT INTO nxl_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Iapamasare pusi oyo, inana Esau ne api honua waron iaunuture mai numa anoe rei. Inanare osi Yakup. Oyo iausahure osi Yakup. ");
INSERT INTO nxl_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ita inana une-une anae nene unte. Ipakei mai hanai atua runa tionai waron hunua tewa rei. ");
INSERT INTO nxl_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ipake pusi Yakup pusi oyo, irui muaina rai runa porotiu waron iunare rai. ");
INSERT INTO nxl_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakup inanare arihoni inai oyo irorire osi amai. Hoka pan amai oyo iahata, “Ama.” Amai isana, “Oe. Ano mo, ano seia? Ano Esau te, ano Yakup?” ");
INSERT INTO nxl_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Iahata, “Au mo, au Esau, tea! Anam manaonete. Ama. Uhunu peni isa, uapamasai pusu sae wani aasau osiku rei. Hanu roe na aruea na ai peni wani uroriki osia reini. Ai pusiki oyo ainisi arihoni Anahatana na irui iake osiku.” ");
INSERT INTO nxl_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Iahata, “Asupui supa rapu-rapu man rei, ama?” Iahata, “Ama. Yahweh Anahatana wain ano ainisi ainaa runai iruiki osiku.” ");
INSERT INTO nxl_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Iahata, “Reiso mai na uakahuua, ata kani titue ano mo, ano Esau?” ");
INSERT INTO nxl_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Oyo Yakup ieu ihaineke amai. Ihainekei oyo amai akahuui. Iakahuui oyo iahata, “Niom mo, Yakup nioi. Ne hanam atua mo, hana atu Esau!” ");
INSERT INTO nxl_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Reiso Isak iationa Yakup tewa tau Yakup hanai atua hunua. Hunua sani Esau. Ne haineke Isak nanie iainisi arihon Anahatana na irui iake osiki, ");
INSERT INTO nxl_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ne iasei honu san rei, “Titue ano mo, ano Esau?” Iahata, “E-e. Ama. Au reini mo, au Esau, tea sahoro seia?” ");
INSERT INTO nxl_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Iahata, “Reiso rui peni reino mai na uaiki. Uai pusi oyo uainisi arihoni Anahatana na irui iake osia.” Reiso Yakup irui muaina rai runa tihu anggur mkane na ininu. ");
INSERT INTO nxl_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Iai pusi oyo iahata, “Eu mai hainekeku. Na amukiku mkane.” ");
INSERT INTO nxl_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Reiso Yakup ieu haineke amai nanie imukiki. Ne amai ioko Esau ne apia haua. Ioko san rei oyo iainisi arihon Anahatana na irui iake osiki. Iahata, “Upuku Anahatana. Anaku ne apia raini haua iaka. Haua iaka sani hau nisi wan Ano auna nene atuhu huaya panesi. ");
INSERT INTO nxl_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Uainisi na arui uane on roe nante. Auna ne nisiu nene atuhu panesi. Uainisi na auna ne gandum runa anggur nene huaya panesi nai osa. ");
INSERT INTO nxl_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Uainisi na auna niana waisa pusiso ouna manianeu tanui. Auna sio mai otoa-otoa pusiso ohahue tanui. Uainisi na auna nea upu momou no kawasa mainae arihoni wanin nea upu momou. Auna wanin nea upu momou ohahue tanso. Uainisi na arui kahatene osi sio wason nanie orui kahatene osiki. Uainisi na arui iake osi sio wason nanie orui iake osiki.” ");
INSERT INTO nxl_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isak iainisi arihoni Anahatana na irui iake osi Yakup pusi oyo Yakup ihokai arihoni amai. Mata hun tewa oyo Esau ihokai on pan wesie. ");
INSERT INTO nxl_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ia iae irie peni rei iake oyo iroriki osi amai. Iahata, “Hanu roe nea ama. Aruea na ai we muaina waron urorire osia reini. Ai na ainisi arihon Anahatana na irui iake osiku.” ");
INSERT INTO nxl_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","“Ano seia reini?” Iahata, “Au ama. Au mo, anam hanaie manaonete, tea?” ");
INSERT INTO nxl_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isak isira reiso ikana-kananunu. Ikananunu oyo iasei, “Ano rei sahoro ia seia wain sinasi irori peni osiku rei? Au uaire nea on anunia tewasi rei! Reiso au uainisi arihoni Anahatana na irui iake osiki nea. We mainisie reimo, we mainisie nanie haineke umataku. Reiso we mainisie rei osi ruai runa nea upu nea momou rotu-tu ria supan.” ");
INSERT INTO nxl_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau iatinu san rei oyo irani nioi mainae. Irani iatamisi rotu-tu ipesi rau ruai. Oyo iasau, “Ama. Ainisi osi au reini oi. Ama.” ");
INSERT INTO nxl_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Iahata, “Wanim sinasi ihokai mai iakarotaku. Uainisi arihoni Anahatana na irui iake osiki. Aikee nanie uainisi osi ano san rei, ne ia mai inanare nea. Reiso uruire osiki nea.” ");
INSERT INTO nxl_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau iahata, “Areini mo, nai ua nea. Waniku iakarotaku. Reiso nanai pannuhui. Inana we kawasa manaonete nea. Ita inana mainisie wani mka osiku rei. Ama ano me mainisie tamene isa tewa nea?” ");
INSERT INTO nxl_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Iahata, “Uainisi na iuna mainae inesi ano. Uainisi na nea kakau nea waniu ouna manianeu tanui. Au iae uainisi na Anahatana iuna ne nisi nene gandum huaya panesi, nene anggur huaya panesi. Reiso mka urui sae osia oi, ama?” ");
INSERT INTO nxl_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau iainisi arihoni amai sirinia. Iasei, “Ama. Ano me mainisie osa rei man si? Ainisi na Anahatana irui iake osi au oi ama!” Iainisi san rei ne irani sirinia. ");
INSERT INTO nxl_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Reiso amai iasau san rei, “Uane on roe nante osia tewa. Me nisiu nene huaya panesi tewa. ");
INSERT INTO nxl_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ano mo, mka amahaia ahita runa me nisau man. Ahita runa me tunue man. Mka auna maniane tau wanim. Ne masike san rei iae mka ano ahanamata atinu tanui. Ano mka arumaya arihoni ne kawasa sani koropou wani sio okanihoo tionai erenosui oyo ererumai arihoni upue ne kawasa.” ");
INSERT INTO nxl_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Reiso Esau ipenei tau wanin nea. Tau sae? Amai iainisi na Anahatana irui iake osi wanin. Irui osi Esau ruai tewa. Reiso Esau iasau pan anoi san rei, “Potuina tewa nea oyo mka amaku imatai. Imatai oyo anoma rapunokoi. Anoma rapunokoi pusi oyo mka uhunu waniku.” ");
INSERT INTO nxl_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ribka iatinu tau anamanae rei oyo iaisosiso na ooi Yakup. Iahata, “Mai na atinu anamanae reini ee. Kakam ipenei tanua reiso nanie ihunua. ");
INSERT INTO nxl_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Reiso apusu we anamanae reini. Masi aeua rapu pan hotaku Laban waipan iruei pan nia Haran. ");
INSERT INTO nxl_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Aruea pan etem rotu-tu potuina mkane rotu-tu kakam ne sate rei eremanu ");
INSERT INTO nxl_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","na anoi kanihue runa sae wani aunai tanui rei. Unoo ata kakam anoi eresaa tewa nea, mka uaisosi sio umau pan, onanaya na anunia mai numa. Upeneku tau unoo we hehuka hanaia uamo omatamo tau ranie hatae osa.” ");
INSERT INTO nxl_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Reiso Ribka iasau osi sahai san rei, “Uhanamata unoo Esau ne sio pina rakana ua rei. Upeneku tanso. Munata Yakup iausahai mai otoe reini runa ia pina arihoni sio Het isa honu nene iake umataku nai osa.” ");
INSERT INTO nxl_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isak iatinu san rei oyo ioi Yakup. Yakup taa iooi mai mitanunue oyo Isak iasau iahata, “Anaku. Mka Anahatana ikata runaya. Reiso mai na arue na uasau na sae isa reini ee. Pene anana ia iki pina isa arihoni sio Het mai Kanaan reini. ");
INSERT INTO nxl_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Aeua pan otoe Mesopotamia pan momom Betuel na ausahaya runa etem anai pina isa. ");
INSERT INTO nxl_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Uainisi na Anahatana wain ne kawasa erenesi pusire irui iake osi ano runa saham na irui me hehuka mea upu mea momou panesi. Ano mka auna numa upue tau sio niana panesi. ");
INSERT INTO nxl_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Uainisi na Upuri Anahatana irui iake osia runa mea upu mea momou sani Upuri Anahatana irui iake osi momom Abraham rei. Uainisi na arue mai otoe wani aruea tanui reini wani Anahatana iruiki osi momom Abraham. Otoe reini wani irue tanui reini sani ita rakana mka tuamane reini osi ruari.” ");
INSERT INTO nxl_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Reiso Isak iaisosi Yakup ieui pan Mesopotamia pan etei, Laban. Laban amai tau Betuel arihoni sio Aram. ");
INSERT INTO nxl_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau iatinu ata amai iainisi na Upuri irui iake osi wanin oyo iaisosiki ieui pan otoe Mesopotamia na inina sahai isa pan rei. Isopoi na pene inana ia pina mai otoe Kanaan. ");
INSERT INTO nxl_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Esau ianei ata wanin ipusu inai runa amai no maunauna. Ieui pan Mesopotamia nea. ");
INSERT INTO nxl_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Reiso ianei ata inai runa amai uaso openeso tau sio pina Kanaan rei. ");
INSERT INTO nxl_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Esau ianei san rei nea oyo, ieui pan oai Ismael. Ismael mo, momoi Abraham anai. Oyo inana oai anai pina isa wain nanai Mahalat, Nebayot hotai. Reiso inana sahai isa honu. ");
INSERT INTO nxl_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakup ieui iarihoni nia Bersyeba nanie ieui pan nia Haran. ");
INSERT INTO nxl_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ihokai ria otoe isa mo ranie eremanu-manu nea. Reiso ia inekei ria otoe rei. Inekei inaka unui tau hatu isa. ");
INSERT INTO nxl_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ineke munui nai osa oyo inekei iamnii. Ineke iamnii inoo oane isa ereoo poe tuamane rotu-tu erehokai roe nante. Inoo Upuri Anahatana ne sio maisosia on roe noiyaha osipu osaa tau oane rei. ");
INSERT INTO nxl_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Inoo Yahweh iooi mai nusui oyo iasau osiki, “Au sahoro Yahweh Anahatana wain momom Abraham runa amam Isak oanisi oainaa runaku. Mka urui tuamane wani anekea tanui reini osi mea hehuka, mea upu, mea momou. ");
INSERT INTO nxl_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Mea upu mka sio panesi sani tapuna waron poe tuamane. Sio mka onana tuamane on ria, on nau, rotu-tu no tuamana panesi. Mka urui iake osi sio niana pusiso pusu ano runa mea upu, mea momou. ");
INSERT INTO nxl_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Anom repeka. Aeua sui supan man, mka ukata runaya nanie usakaya. Mka ununi uroria mai otoe reini. Mka uarihonia tewa. Mka una sae wani utotoe osia reini.” ");
INSERT INTO nxl_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","17","Oyo Yakup imaranae. Isira reiso iasau pan anoe. Iahata, “Ira oe. Yahweh wain reini! Wain otoe reini. Ne muie reini samatoro uanei! Otoe reini reasiraku. Areini mo, Anahatana ne numa maa! Areini noiyaha nene mitanunue maa omi!” ");
INSERT INTO nxl_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Nene hanu omnanoe tau kinoke asi Yakup ihanui oyo inana hatu wani inaka unui tanui rei nanie iapuooi. Iapuooi tau hatu wani ereunaso anoo rapeka sapan na Anahatana itotoe osiki. Inana mina saitun oyo iohui roe hatu rei. Iohui roe hatu rei na iunai osi Anahatana ruai. Hatu reimo, hatu monne. ");
INSERT INTO nxl_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ihete otoe rei nanae tau Betel wani nene nohue Anahatana ne numa. (Naone otoe rei nene nanae Lus.) ");
INSERT INTO nxl_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Oyo Yakup isopa, “Upuku Anahatana. Munata ano akata runaku runa asakaku tau arena tinai tihue reini runa arui we muaina runa apia ");
INSERT INTO nxl_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","rotu-tu ununiku nau inaku runa amaku na iake mo, mka uainisi uainaa runaya rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Mka usama we sae man wani aruiki osiku tau pahakian hutusa samatoro urui pahakian osa osia. Hatu wani uapuooi reini, mka sio oainisi oainaa runaya mai tanui.” ");
INSERT INTO nxl_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakup ieui honu rotu-tu ihokai pan otoe wani ranie eresaa. ");
INSERT INTO nxl_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","3","Ihokai pan oyo isira tau inoo parike pan otoe huie rei runa sio mamsaka rompau tonu. No rompau waron ranekeso sui parike nusue. Tonuso wason onapa-napa no netau umau honu nanie oruru hatu arihoni parike hahae rei. Nanie ouna no rompau rai raninu. Raninu pusi oruru hatu rei roe, ererohi parike hahae honu. Hatu reimo, hatu mainae. ");
INSERT INTO nxl_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakup iasei tanso. Iahata, “Wea amau. Omi reini, omi on supa?” Oahata, “Ami on pan nia Haran.” ");
INSERT INTO nxl_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Iahata, “Oationa Laban, Nahor momoi rei?” Oahata, “E-e.” ");
INSERT INTO nxl_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ita iasei honu, “Waipan sapan? Ne patane miri-mirike?” Oahata, “E-e. Waipan ne patane mirike, tea. Io, noo pan, anai pina ia rei pan. Waini on pan irori amai ne rompau. Anai pina rei, nanai Rahel.” ");
INSERT INTO nxl_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Iahata, “Omi muna na orui mo rompau raninu tewa rei? Oruire na raninu oyo ororire ria monota na raaiso. Tewa mo, ranie waro mainae asi rei. Mka ramakaneaso. Munata onusure pan koka anoe nea, mka ramakaneaso.” ");
INSERT INTO nxl_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Oahata, “Rotu-tu pusima amanouma samatoro aruru hatu reini arihoni parike hahae. Arurui na arui mani rompau raninu.” ");
INSERT INTO nxl_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Wasoni oanamanaso asi, sira tau Rahel ihokai, irori amai ne rompau. Rahel, ia mamsaka rompau oi. ");
INSERT INTO nxl_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Taa Yakup inoo hotai Rahel ihoka runa ne rompau oyo iruru hatu rei arihoni parike hahae rei. Irurui samatoro irui Rahel ne rompau raninu. ");
INSERT INTO nxl_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Irui ne rompau raninu oyo iatipuniki oyo irani. ");
INSERT INTO nxl_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Iahata, “Hota. Au inaku mo, amam hotai.” Taa Rahel iatinu san rei oyo irumai pan no numa nanie isima osi amai. Hoka pan oyo iahata, “Ama. Hotaku wain ihokai on poe otoe Kanaan.” ");
INSERT INTO nxl_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Taa Laban iatinu ata etei wain ihokai reiso irumai poe tanui. Hoka poe oyo iatipuniki imukiki. Oyo ieui ikatai pan ne numa. Ihokai pan numa oyo Yakup isima osi etei iahata, “Inaku runa amaku wasopo ia-iake. Oaisosiku mai na nanie unina we ia pina isa mai rei.” ");
INSERT INTO nxl_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Etei Laban iahata, “Titue. Ita mo, kaka wani.” Oyo Yakup iruei mai etei ne numa hunane katemae. ");
INSERT INTO nxl_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Taue isa Laban iasau osi Yakup. Iahata, “Ete. Masike ioi umau tau kaka wani iae pene pakarian osiku san rei man. Kahurae asupu me pakarian rei nene hunonie. Ainisi ina arihoniku?” ");
INSERT INTO nxl_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","17","Ne Laban ne hehuka pinau ua. Ia manaonete nanai Lea. Matai kania hele. Ne anai pina muie reimo nanai Rahel. Ia mo, ia iake tunne. ");
INSERT INTO nxl_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakup iaunutu anoi tau Rahel nea. Reiso iahata, “Ete. Au pakarian osia rotu-tu musum itu hete nanie unana Rahel anam pina muie rei.” ");
INSERT INTO nxl_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Iahata, “Nene iake ano ruam nanai. Na pene uruiki osi sio tamena nea. Reiso aruea mai rei.” ");
INSERT INTO nxl_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Oyo Yakup ipakarian rotu-tu musum itu na nanie inana Rahel. Anoi erematai pusu ia pina hehuke rei reiso iahana musum itu rai, sani onona hataya tonusa te atesa man. ");
INSERT INTO nxl_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ipakarian rotu-tu musum itu oyo Yakup iasau osi etei, “Ete. Musum itu raniku nea, reiso pusita iapamata sou na uama aisenema nea.” ");
INSERT INTO nxl_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Taa san rei oyo etei iasau runa onone wani etei runa anai pina uaso mka aiseneso. Reiso oanaha runa sio noi niane anoe rei pusiki mai tau no karisaa. ");
INSERT INTO nxl_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Onana karisaa, nene mono rei etei isaa iautunu Rahel tewa ne iautunu Lea osi etei. Oyo etei ineke runai. ");
INSERT INTO nxl_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Etei iae irui Lea ne ia pina makahaie isa nanai Silpa. ");
INSERT INTO nxl_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Nene hanu omnanoe Yakup mato ianei ata ia reimo Lea. Oyo ieui pan etei. Iahata, “Ama. Aunaku san rei nanie taa hae? Au upakarian rotu-tu musum itu rai mo, nanie unana Rahel. Ama, akarotaku tau sae?” ");
INSERT INTO nxl_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Iahata, “Mai niane reini mo nene monne san rei. Ia muie mo iausaha iniku kakai tewa. ");
INSERT INTO nxl_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Reiso anapa rotu-tu maisene onona itu rai raniku samatoro anana Rahel honu. Ne mka apakarian osiku musum itu honu.” ");
INSERT INTO nxl_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakup iamanaku. Taa maisene rei nene onona itu pusire oyo amai irui Rahel osiki. ");
INSERT INTO nxl_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Amai iae irui Rahel ne ia pina makahaie isa nanai Bilha. ");
INSERT INTO nxl_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakup iae ineke ikata Rahel oi. Ne Yakup anoi pusiki runa Rahel arihoni Lea. Ita ipakarian musum itu honu. ");
INSERT INTO nxl_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Taa Yakup iausahai pusi oyo Yahweh inoo ata Yakup anoi pusiki runa Lea tewa. Reiso irui Lea isusu ne Rahel mo, isusu tewa. ");
INSERT INTO nxl_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea tinain taua oyo iruei runa anai hanaie isa. Iahata, “Yahweh inoo we kasiane reini. Reiso mka sahaku anoi runaku oi.” Reiso ihete anai hanaie rei nanai tau Ruben. Nene nohue mo, Yahweh inoo we kasiane. ");
INSERT INTO nxl_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ita tinain taua honu. Oyo iruei runa ia iki hanaie isa honu. Iahata, “Upuri iatinu ata au mo sahaku anoi runaku tewa reiso irui ia ikine reini osiku oi.” Reiso ihete nanai tau Simeon. Simeon nene nohue mo, Upuri iatinu. ");
INSERT INTO nxl_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ita tinain taua honu. Oyo iruei runa ia iki hanaie isa honu. Iahata, “Mka sahaku ikataku sui osa. Tau sae? Ususu sio iki hanaia tonu.” Reiso ihete ia ikine rei nanai tau Lewi. Nene nohue mo, sokohuu. ");
INSERT INTO nxl_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ita tinain taua honu. Oyo iruei runa ia iki hanaie isa honu. Iahata, “Nene taue reini uainaa runa Yahweh.” Reiso ihete ia ikine rei nanai tau Yehuda. Nene nohue mo, ainaa. Iruei runa Yehuda oyo isusu tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ne Rahel mo, isusu tewa sirinia. Reiso ianana kakai. Iasau osi Yakup san rei, “Ano auna au anaku isa tewa? Munata auna anaku isa tewa mka umataku!” ");
INSERT INTO nxl_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakup iatinu san rei oyo anoi eresaa tau Rahel. Iahata, “Au mo, au Anahatana tewa. Ia sahoro irui ano asusu tewa rei.” ");
INSERT INTO nxl_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Reiso iahata, “Mai na anana Bilha, we ia makahaie reini na anekea runai na isusu osiku. Tau ia isusu mka sio oaoi au tau inai.” ");
INSERT INTO nxl_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Reiso irui ne makahaie Bilha osi sahai. Oyo sahai inekei runai. ");
INSERT INTO nxl_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ineke runai san rei oyo tinain taua. Oyo Bilha iruei runa anai hanaie. ");
INSERT INTO nxl_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rahel iahata, “Anahatana iatuhete ata au we isanae tau reini tewa. Reiso iatinu tau we mainisie. Reiso irui ia iki hanaie reini osiku.” Reiso ihete nanai tau Dan. Dan nene nohue, “Iapasanaku tewa.” ");
INSERT INTO nxl_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ita Bilha tinain taua honu. Iruei runa ia iki hanaie isa. Sio iki hanaia ua nea. ");
INSERT INTO nxl_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rahel iahata, “Aapataruna runa kakaku oo au we untu.” Reiso ihete ia ikine rei nanai tau Naftali. Nene nohue, “Apataruna.” ");
INSERT INTO nxl_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Taa Lea ianei ata ia mka isusu tewa nea, reiso irui ne ia makahaie rei osi sahai. Ne makahaie rei nanai Silpa. Reiso Yakup inekei runai oyo tinain taua. ");
INSERT INTO nxl_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Oyo iruei runa ia iki hanaie isa. ");
INSERT INTO nxl_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea iahata, “Au usupu iake nea!” Reiso ihete nanai tau Gad. Gad nene nohue, “Usupu iake.” ");
INSERT INTO nxl_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ita Silpa tinain taua honu. Iruei runa ia iki hanaie isa honu. ");
INSERT INTO nxl_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea iahata, “Anoku mirike. Mka sio pinau oasau oahata au anoku mirike.” Reiso ihete ia iki hanaie rei nanai tau Asyer. Nene nohue, “Anoi mirike.” ");
INSERT INTO nxl_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Tau musum gandum nanie. (Manei, nooi sani ana.) Ruben ieui napi ria nisi. Hoka ria oyo isupu ai totue isa nanie ereuna sio osusu. Oyo iroriki osi inai. Ne hoka nau numa oyo Rahel inooi. Inooi oyo iainisi arihoni kakai. Iahata, “Asamaku tau me ai totue wani anam hanaie isupui reini na mkane osiku.” ");
INSERT INTO nxl_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Iahata, “Ano anana au sahaku nea. Ineke ikataku tewa nea. Mka nanie anana ai totue wani anaku hanaie isupui reini?” Iahata, “Reiso arui anam hanaie ne ai totue reino mai. Samatoro mka-mkasini mono sahaku inekei ikataya.” ");
INSERT INTO nxl_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Reiso taa Yakup inuniki on ria nisi tau nene ranie manne rei mo, Lea inapai. Oyo iahata, “Ano tau mono reipan aneke akatama mai numa. Tewa mo, uasau osi saham nea. Urui anaku hanaie ne ai totue wani isupui ria nisi. Reiso usehaya tau ai totue rei nea.” Nene mono rei oyo Yakup inekei runa Lea. ");
INSERT INTO nxl_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Lea iainisi reiso Anahatana iatinu tanui. Reiso tinain taua. Ita isusu ne ia iki hanaie isa honu. Ne hehuka hanaia sio nima nea. ");
INSERT INTO nxl_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Oyo iahata, “Anahatana irui iake osiku. Tau sae urui we ia makahaie osi sahaku.” Reiso ihete nanai tau Isakhar. Nene nohue, “iuni iake.” ");
INSERT INTO nxl_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ita Lea tinain taua honu. Iruei runa ia iki hanaie isa honu. Ne sio iki hanaia sio nome nea. ");
INSERT INTO nxl_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Iahata, “Anahatana irui ia ikine rei sani sinente wani iake nai osa. Reiso muie reini mka sahaku iamuiraku. Tau sae? Ususu ne sio iki hanaia nome nea.” Reiso ihete ia iki hanaie rei nanai tau Sebulon. Nene nohue, “amuira.” ");
INSERT INTO nxl_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ita tinain taua honu. Iruei runa anai pina isa. Ihete nanai tau Dina. ");
INSERT INTO nxl_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Oyo Anahatana anoi runa Rahel. Iatinu tau ne mainisie reiso iruiki isusu. ");
INSERT INTO nxl_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Oyo tinain taua. Iruei runa anai hanaie isa. Iahata, “Anahatana iunaku ususu nea na pene sio ouna pumaaku.” ");
INSERT INTO nxl_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Reiso ihete nanai tau Yusup. Nene nohue, “Hete ususu honu.” Ihete nanai oyo iahata, “Uainisi na Yahweh irui anaku hanaie isa honu.” ");
INSERT INTO nxl_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Taa Rahel iruei runa Yusup oyo Yakup iasau osi amai. Iahata, “Ama. Uainisi arihonia na ununiku poe we niane nea. ");
INSERT INTO nxl_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Runa arui me hehuka runa mea momou. Tau sae? Upakarian osia reimo noso sio. Tapiso osiku na pusima anunima. Tewa mo, ukonaupua rotu-tu reini nea rei tea.” ");
INSERT INTO nxl_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Amai iahata, “Atinu ee. Au una nau oyo nau renoo ata Yahweh irui iake osiku rei tau ano arue mai tanuku. Reiso pene aeu nea. ");
INSERT INTO nxl_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Nanie ainisi sae arihoniku na apakarian osiku sirinia?” ");
INSERT INTO nxl_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Iahata, “Ama. Ano ruam anei nea, tea?. Upakarian panesi osia nea. Reiso me makapanau panesi tau au uapiarare. ");
INSERT INTO nxl_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Tau uhoka tewasi, reimo me makapanau panesi tewasi. Ne muie reini mo me makapanau panesi nea. Reiso me kaya nea. Yahweh irui iake osia rei pusu au. Reiso au ruaku nanie upakarian osi ruaku we pina hehuka pan muie oi.” ");
INSERT INTO nxl_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Iahata, “Sae wani mka uruiki osia honu?” Iahata, “Ruae nea. Ama. Pene arui sae isa osiku nea. Mka usaka me makapanau sirinia. Hete sae amanaku we anamanae reini. ");
INSERT INTO nxl_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ranie hatae reini ueuku uarinii me makapanau na unana rompau waron nikapanta runa waron maniahua. Unana rompa anaya waron metena. Unana une-uneu waron nikapanta runa waron maniahua. Unanare osi ruaku. Hasae uainisi rai man. ");
INSERT INTO nxl_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Pani muie samatoro amaku ruam anei. Ata kani we manisate te tewa. Sani taue isa ahoka arinii we makapanau asupu une-uneu waron nikapanta tewa, te waron maniahua tewa runa rompa anaya waron metena tewa samatoro anei noi rei ata unehure.” ");
INSERT INTO nxl_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Iahata, “Iake. Ita iuna sae wani ano asaui rei.” ");
INSERT INTO nxl_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ne ranie hatae rei amai ianena une-une waron nikapanta runa waron maniahua osi ruai. Ianena rompa anaya waron metena osi ruai. Oyo iaisosi ne hehuka hanaia osakare. ");
INSERT INTO nxl_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Oyo ne hehuka hanaia rei oeu okata makapanau rai rahainau arihoni Yakup. Oeu onona tonu samatoro ohokaso pan tihue rei, oo makapanau nesia rai, osi Yakup isakare. ");
INSERT INTO nxl_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ne Yakup inana ai sana mataya rerihoni ai hawar, ai badam, runa ai berangan oyo inuki nene unta nanie iunare makinikata. ");
INSERT INTO nxl_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Iuna pusire oyo iaunuture mai makapanau nene tihu naniae. Tau sae? Makapanau rai nanie raninu mo, rakata umau ee. ");
INSERT INTO nxl_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Reiso munata makapanau rai rakata umau mai ai sanaya waron makinikata rai, mka nene anaya makinikata maniahua san rei oi. ");
INSERT INTO nxl_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ita Yakup inana rompau ramanane une-uneu waron makinikata. Iuna san rei na ruai isupu ne makapanau na ineare arihoni amai ne makapanau. ");
INSERT INTO nxl_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Yakup inapa rotu-tu inoo makapanau waron ramkona nanie rakata umau samatoro iuna ai sanaya rai poe tihu. ");
INSERT INTO nxl_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ne inoo makapanau waron rakua tewa nanie rakata umau mo, iaunutu tewa. Reiso makapanau waron putia reimo rakua tewa. Araimo amai hanahanai ne makapanau. Ne makapanau waron metena, nikapanta, runa maniahua waron ramkona reimo Yakup ne makapanau. ");
INSERT INTO nxl_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Reiso Yakup ne makapanau panesi. Ne une-uneu, ne rompau, ne unta, ne keledaiu panesi. (Unta mo, makapana wani nene totu unie mo, nene pupua sonota. Keledai, nooi sani naitanane ne ikine.) Ne manianeu panesi. Reiso Yakup iakanihu amai san rei reiso ne kaya mainae. ");
INSERT INTO nxl_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Nene ranie hatae isa Yakup iatinu ata nea saua oasau tanui. Oahata, “Sauri reimo, inana pusi amari ne makapanau reiso ne kaya. Inana re rusun pusire.” ");
INSERT INTO nxl_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakup iae inoo amai ne muiran runai sani naone tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Reiso Yahweh iasau osiki. Iahata, “Anunia poe amam ne niane poe amam runa me mansiau poe otoe Kanaan nea. Mka ukata runaya.” ");
INSERT INTO nxl_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Taa san rei oyo Yakup ianaha runa ne pinau uaso na opusui ria otoe wani isaka ne makapanau rai. ");
INSERT INTO nxl_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ohokaso ria oyo iahata, “Mai na uasau sou reini osi uamo. Unoo amari iamuiraku sani naone rei tewa nea. Ne Anahatana wain amaku iainisi iainaa runai wain ikata runaku sirinia. ");
INSERT INTO nxl_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Uamo ruamo oanei nea, tea? Au pakarian osi amari rotu-tu uhunu-hunu ruaku. ");
INSERT INTO nxl_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Masike upakarian uhunu-hunu ruaku san rei iae, amari iakarotaku sirinia. Iasa-sawariku rotu-tu nai hutusa raini. Ne Anahatana itapi amari iuna kahatene tanuku tewa. ");
INSERT INTO nxl_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Taue isa amari iahata, ‘Makapanau waron nikapanta rai mka osi ano.’ Oyo rompau runa une-uneu rai rarue runa nene anaya rai poe oo, nikapanta. Ne munata iahata, ‘Makapanau waron maniahua rai mka osi ano.’ Oyo makapanau rai rarue runa nene anaya poe oo, maniahua sirinia. ");
INSERT INTO nxl_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Reiso Anahatana inana makapanau waron amari rei osiku. ");
INSERT INTO nxl_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Tau makapanau nene musum nanie rakata umau oyo uneke uamnii. Unoo une-une hanaia rakata une-une nikapanta runa maniahua. ");
INSERT INTO nxl_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Uneke uamnii Anahatana ne maisosie on roe noiyaha iasau osiku. Iahata, ‘Yakup.’ Oyo usana, ‘Oe. Upu.’” ");
INSERT INTO nxl_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Iahata, “Masi anoo makapanau waron rakata umau reimo une-une hanaia pusire nikapanta runa maniahua. Unoo sae waron amam hanahanai iuna tanua rei nea. Reiso au unenire san rei. ");
INSERT INTO nxl_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Au mo, au Anahatana wani uatuhete ruaku osia poe nia Betel rei. Uatuhete ruaku osia oyo asuhu mina saitun roe hatu hahae wani anaka unum tanui rei. Asuhu mina, samatoro asopa osiku. Reiso autotu me apia pusire nea, na anunia poe me niane.” ");
INSERT INTO nxl_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ne pinau oahata, “Amari ne kausae wanae isa osima tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ami mo, inooma sani ami tamena. Iahenima nea. Inana ami hunonima pusire ne iapahia pusire nea. Iapahia iwena-wenare nea. ");
INSERT INTO nxl_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Anahatana inana makapanau waron ami runa mani hehuka mani pahakian inanare arihoni amari nea. Reiso auna sae wani Anahatana iaisosia rei.” ");
INSERT INTO nxl_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Taa san rei oyo Yakup iautotu ne numa hutae pusiki, nanie inuniki poe amai Isak, poe ne niane hahae poe otoe Kanaan. Iapusaa ne pina hehuka roe unta. (Unta mo, makapana wani nene totu unie mo, nene pupua sonota.) Iapusaa pusiso roe unta samatoro ikatu ne makapanau waron isupure mai otoe Mesopotamia. ");
INSERT INTO nxl_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ranie hatae wani sio oeuso rei mo, noa ama waira iatori ne rompau nene hunua. Tau ranie hatae rei iae Rahel inana iauhuni amai ne anahatana wani titue tewa nene siaie isa. Siaie wani ereruei mai numa eresakaso. ");
INSERT INTO nxl_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Oeuso rei, Yakup isima osi amai tewa. ");
INSERT INTO nxl_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Inana pusi ne numa hutae pusiki oyo orumaso. Osipu toha Wae Efrat na oeuso poe otoe Gilead, nanie opusu pupua poe rei. ");
INSERT INTO nxl_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Nene onona ua nau san rei samatoro sio osima. Oahata, “Laban. Me hehuka wason suru poe oeuso arihonia nea. Osima osia oe?” Iahata, “Tewa maa!” ");
INSERT INTO nxl_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Oyo Laban iamanou ne mansiau samatoro oeu opususo. Oeuso rotu-tu onona nome samatoro osupu nahao oyo opususo sui pupua Gilead. ");
INSERT INTO nxl_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","25","Laban sio osupu Yakup sio mo, oapuoo no numa wani sio onanai arihoni makapanau unta nea. Oapuooi roe pupua ria Gilead rei. Ria pupua rei iae Laban sio onekeso oi. Nene mono rei ineke iamnii Anahatana ihokai mai tanui oyo iahata, “Ainati. Pene akapuku tau Yakup.” ");
INSERT INTO nxl_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban ineke iamnii oyo nene hanu omnanoe ieui roe tanui. Iahata, “Yakup. Ano auna au san rei taa hae? Akarotaku nanie taa hae? Aruma arori we hehuka sani sio wason osotaso tau manahitane? ");
INSERT INTO nxl_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Amuna na on pan oeumo osima osiku tewa nea rei? Ne sani oasau osiku mka utapiso osia na anori miri-mirika. Mka iuna maisene. Iuna karisaa mainae. Iahinata. Iakapeti tihana waron nene mamono inata. Iaise maisene isa nooi sani gitar. ");
INSERT INTO nxl_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Na umuki we hehuka wea momou na pusita iauhaa umau. Arirunea! ");
INSERT INTO nxl_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Au we kawasa una kahatene tanua. Ne monosi Anahatana wain amam iainisi iainaa runai isopo na pene uanamana makae tanua. ");
INSERT INTO nxl_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Au uanei nea ata ano nanie anunia reimo anom ererihu runa me niane. Ne amuna na anana we siaie wani eresaka we numa rei?” ");
INSERT INTO nxl_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Iahata, “Ama. Ueu umene-mene rei tau ukaitau, pene rotu-tu asopo mea momou runa noa inau. ");
INSERT INTO nxl_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ne arihoni siaie wani asau runai reimo, masi ruam aninai. Ne munata asupui mai ami reini pusima, ano ruam ahunui. Pene apuhaiki. Anina, hitio me sae umau waron reimo, ananare. Ananare na amanoure mai na uata re mansiau onoo.” Ne Yakup ianei tewa ata sahai Rahel sahoro inana amai ne siaie rei. ");
INSERT INTO nxl_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Oyo noa ama inusui pan ne msahane ne numa unta oyo ininai. Ita inina pan Lea runa no makahaia ua rei no numa unta oi. Ne isupui tewa. Samatoro inusui pan anai pina muie ne numa unta honu. ");
INSERT INTO nxl_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ne Rahel inana siaie rei iaunutui pan tasi. Tasi wani sio okanihooi tau naniai wani iru-ruei tanui roe unta totu hahae. Inana siaie rei samatoro Rahel iruei iese tanui mai numa anoe. Amai ininai isui nehu ne numa anoe ne isupui tewa sirinia. ");
INSERT INTO nxl_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rahel iahata, “Ama. Pene akapuku tanuku kee. Tewa mo, uhitio unapaya iake tewa. Tewa mo, au wani uneniku.” Ne amai ininai ia-ia sirinia ne isupui tewa. ");
INSERT INTO nxl_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Isupui tewa reiso Yakup anoi eresaa. Iahata, “Ama. Au una isanae sae tanua? Te we masana mainae sae tanua na rotu-tu asui aka-kaohuku sani akaohu peni rei? ");
INSERT INTO nxl_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ama. Anina sui nehu pusi mani numa anoa nea. Asupu me apia umau mai tanuma? Saka ahokare mai na autuere kua rei na re mansiau onoore. Onoore na oasau ia seia wain inanare rei. ");
INSERT INTO nxl_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Musum hutu ua urueku ukataya. Me rompau runa me une-uneu rasusu panesi nea. Ranahu tewa. Une-une hanaie isa nanie uaiki man oo tewa oi. ");
INSERT INTO nxl_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ne makapanau waron binatang waron rasea raaire rei oo, ununi rorire osia tewa. Ne ruaku ukatire. Waroni sio okimanakare tau mono te tau ranie oo, ano asau tanuku na ukatire. ");
INSERT INTO nxl_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Tau ranie, umataku tau ranie titie. Tau pumono, umataku tau mahatane. Nanie uneke man oo, tewa oi. ");
INSERT INTO nxl_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Eresuniku tau pakarian san rei rotu-tu musum hutu ua raini nea. Upakarian musum hutusa rahana ate tau nanie unana me hehuka pinau uaso. Ita musum nome rai upakarian nanie usupu une-uneu runa rompau arihonia. Upakarian nanie usupu makapanau arihonia ne asa-sawariku rotu-tu nai hutusa. ");
INSERT INTO nxl_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Sinana pene Anahatana wain amaku runa momoku Abraham uaso oainisi oainaa runai rei ikata runaku mo, mka aisosiku ununiku unaku-nakuku. Ne Anahatana wain amaku Isak iamuirai ikata runaku. Ianei we kausa wanaya rai. Reiso monosi iasau osia rei, tea?” ");
INSERT INTO nxl_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban iasau osi Yakup iahata, “Lea runa Rahel, au we hehuka pinau. Uaso no hehuka, au we kawasa tanso. Me rompau, me une-uneu rai, mo au. Ne sae waron ano anoore mai rei mo, araimo au we numa hutae. Ne kani umuna na uni we hehuka, wea momou oi? ");
INSERT INTO nxl_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Reiso mai na uata isopa. Iapuoo hatu rei.” ");
INSERT INTO nxl_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Reiso Yakup inana hatu isa iapuooi na anoo rapeka tau uaso osopa rei. ");
INSERT INTO nxl_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Oyo iaisosi ne mansiau iahata, “Oamanou hatu mai na oranere.” Orane pusire oyo onana muaine na oaiso mai hatu nusue rei. ");
INSERT INTO nxl_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Amai ihete hatu rei nanae tau Yegar-Sahaduta. Ne Yakup ihete nanae tau Galed. ");
INSERT INTO nxl_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban iahata, “Mka inoo hatu waron oranere reini anori rapeka runa isopa rei.” Reiso otoe rei nanae Galed. Galed nene nohue “Hatu waron oranere na anoo rapeka.” ");
INSERT INTO nxl_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ita iahata, “Uainisi na Yahweh isaka inoo uata masike irue hainau umau.” Reiso otoe rei nanae Mispa. Mispa nene nohue “Numa wani noa-noae osi sio mamsakaya.” ");
INSERT INTO nxl_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ita iasau honu, “Munata auna kahatene tau we hehuka pinau te, anana sio pina tamena mo, masike ia isa ianei tewa iae, Anahatana wain inoota. ");
INSERT INTO nxl_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Hatu raini waron oranere runa hatu wani ereoo reini, inoore oyo anori rapeka. ");
INSERT INTO nxl_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Mka uniku hatu waron oranere na una kahatene tanua tewa. Ano iae, mka aniku hatu waron oranere runa hatu wani ereoo, ano mka anikure tewa na auna kahatene tanuku. ");
INSERT INTO nxl_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Uainisi na Anahatana wain Abraham runa amaku Nahor runa noa ama oainisi oainaa runai, isaka iapasanata.” Ne Yakup isopa ihete Anahatana wain amai Isak iamuirai. ");
INSERT INTO nxl_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Reiso Yakup irehi makapana roe pupue rei osi Anahatana, oyo ianaha runa ne mansiau na pusiso oaiso. Oaiso pusi oyo onekeso. ");
INSERT INTO nxl_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Nene hanu omnanoe Laban imuki nea momou runa ne hehuka pinau, iainisi na Anahatana irui iake osiso samatoro inuniki. ");
INSERT INTO nxl_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakup runa Laban osopa pusi oyo suru poe Yakup sio ohitio oeuso. Oeuso oyo Anahatana ne sio maisosia on roe noiyaha umau ohokaso mai tanui. ");
INSERT INTO nxl_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Inooso oyo iahata, “Naniaku reini Anahatana naniai.” Reiso ihete nanae tau Mahanaim. Mahanaim nene nohue “Naniaka ua.” ");
INSERT INTO nxl_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Taa san rei oyo Yakup iaisosi ne makahaia na oeu oanaoneso poe otoe Edom, nanie osima osi kakai Esau. ");
INSERT INTO nxl_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yakup iasau osiso. Iahata, “Oasau osi kakaku san rei. ‘Me maniane Yakup nanie inuniki mai tanua. Tewa mo, iruei potuina ikata Laban nea. ");
INSERT INTO nxl_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Reiso muie reini ne koropou, ne rompau, ne une-uneu, runa ne keledaiu. (Keledai nooi sani naitanane ne ikine man.) Ne manorina. Reiso upu, ia iauwatu ne anamanae reini osia. Iainisi na arui iake osiki.’” ");
INSERT INTO nxl_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ne makahaia oeu poe oasau. Oasau pusi oyo on poe onunso. Oahata, “Upu. Ami asupu kakam nea. Reiso ia iae wain on poe tau arena tinai tihue nea. Nanie ihokai mai tanua. Ne wain on poe ikata sio utun ate.” ");
INSERT INTO nxl_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakup iatinu tau rei reiso ikaitau hunu ruai. Reiso ne mansiau wason okatai rei mo, isamaso tau ua. Isama ne rompau, ne une-uneu, ne koropou, runa ne unta tau ua oi. (Unta mo, makapana wani nene totu unie nene pupua sonota.) ");
INSERT INTO nxl_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Iasau pan anoe iahata, “unata kakaku ihokai mai na iahita runa sio wason roe uae rei na okua tewa, mka sio wason hae muie rei kani osihaso?” ");
INSERT INTO nxl_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Reiso iainisi. Iahata, “Yahweh Anahatana Ano wan momoku Abraham runa amaku Isak oainisi oainaa runaya. Ano aisosiku na ununiku poe we niane na ukata we mansiau. Atotoe ata mka arui iake osiku na we hehuka panesi, we makapanau panesi, we sae man panesi. ");
INSERT INTO nxl_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ne Upu, ano arui iake osi au, me manorine. Ano akata runaku ne au mo, au ikine honue reiso sapani na uatarima ano me iaka rai? Tau au on mai ueuku usipu toha Wae Yordan. Hasae urori we karupae man. Sae isa tewa. Ne muie reini mo, au wani ununiku runa we apia, we pina hehuka, we makapanau panesi rotu-tu usamaso tau ua. ");
INSERT INTO nxl_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Uainisi runa anoku pusiki arihonia na asaka apuheuku arihoni kakaku. Ukaitau pene rotu-tu ihokai mai, iahita runaku na we pinau runa no hehuka reini. ");
INSERT INTO nxl_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Upu. Uainisi arihoni na anom repeka runa sae wani atotoe osiku rei. Mka arui iake osiku na we hehuka panesi, we makapanau panesi, we sae man panesi. Wea upu panesi reiso ia isa man mka ireken kuaso tewa. Tau sae? Sio panesi sani sisia nau nuae.” ");
INSERT INTO nxl_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Onekeso pan rei oyo nene hanu omnanoe isama ne makapanau umau osi kakai. ");
INSERT INTO nxl_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Isamai tau une-une pinau utun ua, une-une hanaia hutu ua, rompa pinau utun ua, rompa hanaia hutu ua, ");
INSERT INTO nxl_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","unta hutu tonu runa nene anaya waron rasusu-susu asi, koropou pinau hutu ate, koropou hanaia hutusa, keledai pinau hutu ua, runa keledai hanaia hutusa oi. (Keledai nooi sani naitanane ne ikine man.) ");
INSERT INTO nxl_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Isama-samare tau polotu-polotu inasa rai. Iruire osi ne makahaia sana osa-osa iahata, “Oeumo oanaone. Osaka na polotu isa rehainau arihoni polotu isa.” ");
INSERT INTO nxl_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Iasau osi ia wain ianaone iahata, “Munata kakaku isupumo na iasei tanumo, iahata, ‘Moa upu tau ia seia? Nanie oeumo sui supa? Ia seia ne makapanau waromo okature rei?’ ");
INSERT INTO nxl_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Saka oasau oahata, ‘Araini mo me maniane Yakup nanie iruire osia. Mania upu ruai wain on pan tau muie asi.’” ");
INSERT INTO nxl_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Iasau osi ne makahaia wason osaka polotu tamena. Iahata, “Osupu kakaku, omi iae oasau san rei sirinia. ");
INSERT INTO nxl_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Oasau, ‘Me maniane Yakup wain on pan tau muie asi.’” Iahata pan anoe, “Munata urui makapanau raini osiki hitio kani mka anoi runaku? Kani anoi kanihue runa we masana wani on naone rei?” ");
INSERT INTO nxl_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Reiso iauwatu ne makapanau osi kakai naone oo, ia ruai inekei mai ne numa wani sio onanai arihoni makapana unta asi. ");
INSERT INTO nxl_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Nene mono rei Yakup ihanu oyo ieu iautunu ne pinau uaso, no makahaia uaso, runa no hehuka hanaia sio hutusa rahana osa rei. Iautunuso na ruao oeu osipu toha Wae Yabok. ");
INSERT INTO nxl_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Iautunu pusiso oyo iaisosi ne makahaia orori ne apia pusire poe waene on poe hae. ");
INSERT INTO nxl_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ne ia ruai on mai hae asi. Oyo sira tau inoo ia hanaie isa ihokai mai tanui ipalapaposona runai rotu-tu haineke nanie omnanoe. ");
INSERT INTO nxl_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ia hanaie rei ianei ata mka inesiki tewa, reiso iakahuu Yakup kanakai na ikuparehiki. Reiso ne unia rarue sana. ");
INSERT INTO nxl_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Reiso ia hanaie rei iahata, “lapasiku na ueuku. Tewa mo ranie mka eresaa nea rei.” Iahata, “Ualapasia tewasi. Rotu-tu arui iake osiku ee.” ");
INSERT INTO nxl_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Iahata, “Nanam seia?” “Nanaku Yakup.” ");
INSERT INTO nxl_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Iahata, “Nanam Yakup tewa nea. Tau sae ano apalapaposona runa Anahatana na tumata reiso me untu. Reiso ukati nanam tau Israel.” Israel nene nohue “Palapaposona runa Anahatana.” ");
INSERT INTO nxl_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Iahata, “Masi asima runa nanam.” Iahata, “Asei runa nanaku nanie taa hae?” Oyo irui iake osi Yakup. ");
INSERT INTO nxl_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Iahata, “Ira. Unoo Anahatana uai anoe, tea? Ne iapuhaiku asi maa!” Reiso ihete naniao rei tau Pniel. Pniel nene nohue mo, Anahatana uai anoe. ");
INSERT INTO nxl_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Inoo ata ranie eresaa nea oyo ieui iarihoni Pniel ne ieu seu-seu. Tau sae? Ne unia mai kanakai rasana. ");
INSERT INTO nxl_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Reiso Israel nea upu oai muaine wani nene henate erenete unie wani kanakae rei tewa. Oaiki tewa rotu-tu reini. Tau sae? Anahatana iakahuu Yakup kanakai rotu-tu unia rarue sana. ");
INSERT INTO nxl_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakup inoo Esau runa ne netau sio utun ate wason ohokaso. Reiso isama Lea ne hehuka, Rahel ne hehuka, runa no makahaia rei no hehuka pusiso. ");
INSERT INTO nxl_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Isamaso oyo ianena no makahaia runa no hehuka roe uae. Ita Lea runa ne hehuka paka tihue. Samatoro Rahel runa Yusup hae muie nai osa. ");
INSERT INTO nxl_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ne Yakup irori uae. On nau nanie ieui ihaineke kakai ihahue rotu-tu nai itu. ");
INSERT INTO nxl_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ne Esau irumai nau inopa wanin. Inopai oyo imukiki. Oyo uaso orani. ");
INSERT INTO nxl_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ne Esau inoo sio pinau runa no hehuka rei, oyo iasei, “Seiso wason okataya reini?” Iahata, “Upu. We hehuka wason Anahatana iruiso osiku. Anahatana irui iake osiku reiso irui we hehuka panesi reini, tea?” ");
INSERT INTO nxl_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Taa san rei oyo no makahaia runa no hehuka oeuso mai ohainekei, ohahue mai tanui. ");
INSERT INTO nxl_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ita Lea runa ne hehuka samatoro Yusup runa inai ohainekei oyo ohahue mai tanui oi. ");
INSERT INTO nxl_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau iahata, “Makapanau polotu-polotu waron sinasi ororire mai tanuku rei, nanie tau sae?” Iahata, “Upu. Nanie rauna anom iake tanuku.” ");
INSERT INTO nxl_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ne iahata, “Pene nea. Au we makapanau panesi nea. Pene arui osiku nea.” ");
INSERT INTO nxl_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Iahata, “Pene. Nanare noi. Sani anom iake runaku nea mo, anana makapanau rai noi. Au una sana tanua ne anom eresaa tanuku tewa nea, areimo sani una sana tau Anahatana ne iapuheui. Reiso unoo uam anoe mo, areimo sani unoo Anahatana uai anoe. ");
INSERT INTO nxl_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Uainisi arihonia na atarima we makapanau waron urorire osia reini. Anahatana irui iake osiku reiso irui sae waron uninare.” Yakup itentene sirinia reiso kakai inana ne makapanau. ");
INSERT INTO nxl_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Oyo Esau iahata, “Mai na ieuta. Ueu uanaone arihonimo.” ");
INSERT INTO nxl_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Iahata, “Upu. Ruam anei we sio ikina reimo omankaeso. Samatoro kahurae au ueu manu-manu. Tewa mo, we makapanau waron rasusu asi. Munata ueu usapae runare mo, mka ramata pusire. Masike usapae runare ranie hatae osa man iae, mka ramata pusire. ");
INSERT INTO nxl_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Reiso upu, aeu anaonea. Ami on mai apusua manu-manu. Ueu ukatu sio ikina runa makapanau rotu-tu ahokama poe tanumo poe otoe Edom.” ");
INSERT INTO nxl_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Iahata, “Munata sanreimo iake. Mka uarihoni we netau umau osia na oakahaia.” Ne iahata, “Upu. Ruae nea. Pene anom reuponu runaku. Hete sae anom iake runaku.” ");
INSERT INTO nxl_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Reiso Esau inuniki napi roe Edom tau ranie hatae rei sirinia. ");
INSERT INTO nxl_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ne Yakup ieui napi poe nia Sukot. Hoka poe iapuoo ne numa wani sio onanai rerihoni makapana unta rei. Iapuooi oyo inana koka osi ne makapanau. Inana koka rei, reiso sio oaoi niane rei nanae tau Sukot. Sukot nene nohue, “Kokau.” ");
INSERT INTO nxl_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Reiso sio oeuso on pan otoe Mesopotomia rotu-tu ohokaso mai kota Sikhem mai otoe Kanaan iake oyo oapuoo no numa unte. Oapuooi mai kota nusue. Ohokaso mai no patana miri-mirika sirinia. ");
INSERT INTO nxl_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Mai naniao rei mo, ohane tuamane rei rerihoni Hemor nea upu. Hemor mo, Sikhem amai. Ohane tau nene hunonie perak inata utun. ");
INSERT INTO nxl_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Hoka mai oyo Yakup irane hatu noore sani anau nanie iainisi iainaa runa Anahatana. Ihete hatu rai nanae tau El Elohe Israel. Nene nohue, Anahatana wain sio Israel oainisi oainaa runai. ");
INSERT INTO nxl_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Yakup sio orueso mai kota Sikhem mai otoe Kanaan oyo ereeu taue isa Yakup anai pina Dina ieui iaisei sui ne netau, sio pina Kanaan rei. Dina mo, inai tau Lea. ");
INSERT INTO nxl_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ieui iaisei oyo Hemor anai hanaie Sikhem inooi. Hemor mo, ia arihoni ipa Hewa. Ia sahoro irime otoe rei. Reiso Sikhem inooi oyo iruma iroriki na nanie inesiki na ineke runai. ");
INSERT INTO nxl_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ne iaunutu anoi tanui rotu-tu anoi pusiki runai oi. Reiso ianamana iake osiki. ");
INSERT INTO nxl_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sikhem iasau osi amai san rei, “Ama. Au uainisi arihonia na anusu ainisi ia pina hehuke rei osiku na unanai.” ");
INSERT INTO nxl_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakup iatinu ata anai pina nanai rekahatei nea. Ne, ne hehuka hanaia wasomo osaka no makapanau ria otoe huie wani nene monota asi. Reiso iamaturui runa masana rei rotu-tu ne hehuka hanaia onunso on ria otoe huie rei. ");
INSERT INTO nxl_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hemor ihokai mai Yakup na nanie iainisi Dina osi anai hanaie. ");
INSERT INTO nxl_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ihokai oyo sira tau Yakup ne hehuka hanaia ohokaso. Oatinu masana rei osira anoo rasaa hunu ruao. Tau oatinu ata Sikhem iapahia noa hota. Areimo iuna pumaa sio Israel pusiso. ");
INSERT INTO nxl_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hemor iasau osi Yakup iahata, “Upu. Au anaku hanaie Sikhem anoi pusiki runa anam pina. Reiso uainisi arihonia na arui anam pina osiki na uaso onana umau. ");
INSERT INTO nxl_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Mai na uata iapamata sou. Ano me hehuka runa au we hehuka mka oausaha onusu hoka umau. ");
INSERT INTO nxl_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Oruemo mai tanuma sui supan mai kota reini pusu ruamo mo maue. Oahen sae man ohane sae man mai kota reini.” ");
INSERT INTO nxl_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sikhem iasau osi Dina amai runa nea hotau san rei, “Wea upu. Uainisi arihonimo na oamanaku we sou reini. Mka urui sae man wani omi ainisiki. ");
INSERT INTO nxl_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Oasau runa hunonin ina man iae mka uruire osimo. Hete sae orui mo ia iki pina reini na unanai.” ");
INSERT INTO nxl_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Sikhem iuna noa hota nanai rekahatei reiso nea hotau oakarota Sikhem runa amai uaso. ");
INSERT INTO nxl_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Oahata, “Munata ami arui mania hota inana omi wason oeu waene tewasi mo, ami aumaa. ");
INSERT INTO nxl_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ami amanaku hete sae omi sani ami. Areimo omi hanaia pusimo kahurae oeu waene. ");
INSERT INTO nxl_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Oeu waene samatoro arui mania hota osia na iausaha inusu ihoka umau. Ami mka arue akatamo. Ioi umau tau kaka wani. ");
INSERT INTO nxl_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ne munata omi openemo tau oeu waene mo, ami mka anana mania hota arihonia oyo aeuma.” ");
INSERT INTO nxl_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Sikhem runa amai oatinu tau sou rei iake. ");
INSERT INTO nxl_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Reiso Sikhem inina nanie oeu waene on sini. Tau sae? Anoi pusiki runa Dina. Mai kota rei Sikhem sahoro sio oamuirai mainae arihoni ne numa anoe pusiso. ");
INSERT INTO nxl_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Oanamana osi Yakup sio pusi oyo Hemor runa anai hanaie uaso oeuso pan kota rei nene mitanunue. Pani mitanunue rei sio kota anoe pusiso osaka oamanouso oana-anamana osi umau. Reiso uaso oasau osi sio kota anoe san rei. ");
INSERT INTO nxl_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Oahata, “Wea amau pusimo utumo. Arinii we sou reini. Sio Israel wason orueso mai ita re kota reini mo, ita re netau. Reiso itapiso orueso mai reini okatata. Orueso onusu ohoka oahen ohane sui supan man ruao no maue. Otoe reini mo hekani. Reiso orueso tanui iae iake. Ita iausahata inusu ihoka iake. ");
INSERT INTO nxl_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ne sio rei nanie orue okatata na ioi umau tau kaka wani, hete sae ipusu sio no sou isa. Areimo kahurae ita hanaia pusita ieu waene sani sio ruao. ");
INSERT INTO nxl_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Mka no makapanau runa no numa hutaya pusire osita, tea? Reiso mai na ipusu no sou rei na orue okatata.” ");
INSERT INTO nxl_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Sio pusiso mai kota anoe rei wason oamanouso oamanaku tau Hemor runa anai hanaie uaso no anamanae rei. Reiso sio hanaia pusiso mai kota rei oeu waene. ");
INSERT INTO nxl_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ereruma nene onona tonu sio hanaia wason oeu waene rei oahana raina asi. Yakup ne hehuka hanaia ua onana no tunua. Uaso wason Dina nea hotau. Nanao Simeon runa Lewi. Onana no tunua oyo onusu oauhuniso pan kota anoe. Ohunu sio hanaia pusiso. ");
INSERT INTO nxl_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ohunu Hemor runa Sikhem oi. Ohunuso oyo onana Dina arihoni Sikhem ne numa samatoro oeuso. ");
INSERT INTO nxl_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ohunu pusiso samatoro uaso noa kakau noa waniu ohokaso mai owahu sio Sikhem no numa hutaya pusire. Owahu pusire tau Sikhem iuna noa hota nanai rekahatei. ");
INSERT INTO nxl_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Onana no makapanau. Areimo onana no une-uneu, no rompau, no koropou, runa no keledaiu. (Keledai nooi sani naitanane ne ikine.) Onana no sae man waromo pan kota anoe rei runa no nisiu. ");
INSERT INTO nxl_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Onana no apia pusire waron nene hunonia mainaya. Osota sio pinau runa no hehuka pusiso. Owahu pusi no numa hutaya. ");
INSERT INTO nxl_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ohokaso mai numa oyo noa ama iasau osi Simeon runa Lewi uaso san rei. Iahata, “Omi ouna siraka reini tanuku tau sae rei? Mka sio mai Kanaan runa sio Peris wason orue mai otoe reini openeso tanuku. Ita mo, ita panesi tewa. Munata sio reini pusiso okata umau na oahita runata, mka pusita imatata.” ");
INSERT INTO nxl_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Oahata, “Ami atapi mania hota osi sio unai sani ia pina numa naue tewa.” ");
INSERT INTO nxl_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Taue isa Anahatana iasau osi Yakup iahata, “Oeumo poe nia Betel na oruemo poe rei. Arane hatu noore sani anau. Aranere na ainisi ainaa runa au, Anahatana, tanure. Naone arumaya arihoni kakam Esau, au Anahatana sahoro uatuhete ruaku osia rei.” ");
INSERT INTO nxl_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Reiso Yakup iasau osi ne pina hehuka runa sio wason okatai rei. Iahata, “Pesi sio rakana no siaia waromo tanumo. Siaia rerihoni anahatanau waron titue tewa. Osohumo samatoro okati mo papita. ");
INSERT INTO nxl_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Mai na ieuta poe Betel. Mka urane hatu noore sani anau na iainisi iainaa runa Anahatana. Anahatana wain iatinu tau mainisie. Anoku ereruei tewa reiso uainisi arihoniki oyo iakahaiku. Ikata runaku sui supan man.” ");
INSERT INTO nxl_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Reiso orui no siaia runa no pua-puana waron opakere sani ai totua na raneteso rei. Oruire osi Yakup samatoro ikanire na pene opakere nea. Ikanire poe ai onate nohue haineke kota Sikhem. ");
INSERT INTO nxl_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Tau Yakup sio ohitio oeu oyo Anahatana iuna niana waisa okaitauso. Okaitau reiso osuiso tewa. ");
INSERT INTO nxl_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Oeu rotu-tu ohokaso poe otoe Kanaan. Ohokaso poe Betel wani naone nanae Lus. ");
INSERT INTO nxl_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ohokaso poe, oyo Yakup irane hatu noore sani anau na iainisi iainaa runa Anahatana. Ihete otoe rei tau El-Betel wani nene nohue, “Anahatana wain iatuhete ruai osiku mai Betel.” Ihete otoe rei tau Anahatana iatuhete ruai osiki pan rei on irumai arihoni kakai. ");
INSERT INTO nxl_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Pani Betel iae Ribka ne mampakananae wain nanai Debora imatai. Imatai oyo okaniki poe ai onate nohue rei oi. Reiso ohete ai onate rei tau “Ai Mananokone.” ");
INSERT INTO nxl_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakup inuniki on pan otoe Mesopotamia oyo Anahatana iatuhete ruai osiki honu. Itotoe ata mka irui iake osiki. ");
INSERT INTO nxl_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Iahata, “Ano mka sio oaoia tau Yakup tewa nea. Ne mka oaoia tau Israel. ");
INSERT INTO nxl_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Au mo, au Anahatana wani we kawasa mainae erenesi pusire. Mka asusu haha panesi. Mea upu mea momou mka ouna niana panesi. Ouna otoa panesi. Mea upu mea momou mka ouna aiau. ");
INSERT INTO nxl_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Tuamane wani uruiki osi momom Abraham runa amam Isak reini iae, mka uruiki osi ano runa mea upu mea momou oi.” Yakup nene nohue “Iakarota”. Ne Israel nene nohue “Ipalapaposona runa Anahatana”. ");
INSERT INTO nxl_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Anahatana ianamana pusi oyo ieu iarihoni Yakup. ");
INSERT INTO nxl_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Mai tihue wani Anahatana iatuhete ruai osi Yakup rei, Yakup iapuoo hatu isa. Iapuooi na sio anoo rapeka runa Anahatana iatuhete ruai osiki rei. Iapuooi oyo isona mina saitun runa tihu anggur roe hatu hahae rei. Isonare nanie iainisi iainaa runa Anahatana. ");
INSERT INTO nxl_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ihete tihue rei nanae tau Betel. Nene nohue, “Anahatana ne numa.” ");
INSERT INTO nxl_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yakup sio ohitio oeuso oarihoni nia Betel. Ne sio wason arena tinai tihue hainau arihoni nia Efrata asi, oimo Rahel ina-inaso nea. Ne anai rei iamrai eresuni. ");
INSERT INTO nxl_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Tiai ereun mainae nea oyo ia pian iahata, “Rahel. Apamese anom. Anam reini mo, ia iki hanaie honu.” ");
INSERT INTO nxl_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ne Rahel nahai nanie erenikui nea ihete anai rei nanai tau Ben-oni. Nene nohue “Anaku iuna sinsaraku.” Ne amai ihete nanai tau Benyamin. Nene nohue, “Anaku hanaku wanane.” Hanai wanane nene nohue sio oamuirai. ");
INSERT INTO nxl_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rahel imatai oyo sio okaniki haineke arena nusue wani nanie ereeu poe Efrata rei. Muie reini Efrata, sio oiki tau Betlehem. ");
INSERT INTO nxl_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakup iapuoo hatu isa roe kupuro hahae na nanie sio onoo na oationa ata reini mo, Rahel ne kupuro. Hatu rei wapan rotu-tu muie reini. ");
INSERT INTO nxl_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Okaniki pusi oyo ohitio oeuso oyo oapuoo no numa wani sio onanai rerihoni makapana unta. Oapuooi paka otoe isa ereniku numa mamsakae roe naue wani nanae Eder. ");
INSERT INTO nxl_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Wasomo orueso pan rei, Ruben ineke runa amai sahai Bilha, Rahel ne pina makahaie rei. Taa iatinu san rei oyo Yakup anoi eresaa. Yakup ne hehuka hanaia sio hutusa rahana ua. ");
INSERT INTO nxl_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Areini mo Lea ne hehuka. Ne hehuka tau: Ruben ia manaonete, Simeon, Lewi, Yehuda, Isakhar, Sebulon. ");
INSERT INTO nxl_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Areini mo Rahel ne hehuka. Ne hehuka tau: Yusup, Benyamin. ");
INSERT INTO nxl_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Areini mo Bilha, Rahel ne makahaie, ne hehuka. Ne hehuka tau: Dan, Naftali. ");
INSERT INTO nxl_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Areini mo Silpa, Lea ne makahaie, ne hehuka. Ne hehuka tau: Gad, Asyer. Sio ikina reini oamrai pan otoe Mesopotamia. ");
INSERT INTO nxl_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakup ihokai mai amai Isak. Amai wain iruei mai nia Mamre haineke nia Hebron. Naone momoi iae iruei pan rei. ");
INSERT INTO nxl_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isak imatai tau ne musum utun hutu wanu. ");
INSERT INTO nxl_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Iamtuai ikore-korei nea. Watipusi nahai, oyo ne hehuka, Esau runa Yakup, uaso okaniki. ");
INSERT INTO nxl_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Areini mo, Esau nea upu. Esau iae sio oaoiki tau Edom oi. ");
INSERT INTO nxl_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau inana ne pinau tonu arihoni otoe Kanaan. Sio reimo, ia isa nanai Ada. Ada amai tau Elon. Elon ne ipane Het. Sahai isa honu nanai Oholibama. Amai tau Ana. Momoi tau Sibeon. Ia ne ipane Hewi. ");
INSERT INTO nxl_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ita sahai isa nanai Basmat. Amai tau Ismael. Hotai tau Hebayot. ");
INSERT INTO nxl_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada isusu Elifas. Basmat isusu Rehuel. ");
INSERT INTO nxl_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama isusu Yeus, Yaelam runa Korah. Sio ikina rei pusiso oamrai mai Kanaan. ");
INSERT INTO nxl_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Taue isa Esau ihitio ieu iarihoni Yakup ieui sui otoe tamene. Ieu ikata ne pina hehuka runa sio wason orueso mai ne numa rei pusiso. Ieu ikatu-katu ne makapanau pusire. Irori ne apia pusire waron isupure mai Kanaan rei. ");
INSERT INTO nxl_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Esau ieu iarihoni Yakup tau no makapanau no pina hehuka panesi. No makapanau panesi reiso muaina ralaiso tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Reiso Esau iruei ria pupua ria otoe Seir. ");
INSERT INTO nxl_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Areini mo Esau ne hehuka, nea momou, nea upu nanao. Esau mo, ia numa upue tau sio Edom. Sio Edom wason orueso ria pupua ria otoe Seir. ");
INSERT INTO nxl_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Esau ne hehuka wason: Esau sahai Ada isusu anai hanaie Elifas. Elifas isusu: Teman, Omar, Sefo, Gaetam, runa Kenas. Elifas sahai isa honu. Ne oaiseneso tewa. Nanai Timna. Timna isusu Amalek. Esau sahai Basmat isusu anai hanaie Rehuel. Rehuel isusu: Nahat, Serah, Syama, runa Misa. ");
INSERT INTO nxl_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau sahai Oholibama wain amai tau Ana, momoi tau Sibeon isusu ne hehuka hanaia: Yeusy, Yaelam, runa Korah. ");
INSERT INTO nxl_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Sio numa upua arihoni Esau wason: Esau anai manaonete, Elifas, ne hehuka wason sio numa upua tau ipana reini: Teman, Omar, Sefo, Kenas, ");
INSERT INTO nxl_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gaetam, runa Amalek. Sio noa momou tau Esau runa Ada. ");
INSERT INTO nxl_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau anai hanaie, Reuel, ne hehuka wason sio numa upua tau ipana reini: Nahat, Serah, Syama, runa Misa. Sio noa momou tau Esau runa Basmat. ");
INSERT INTO nxl_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ipana rerihoni Esau runa sahai, Oholibama wain amai tau Ana wason: Yeus, Yaelam, runa Korah. ");
INSERT INTO nxl_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Sio wason numa upua tau ipana waron Esau nea momou. ");
INSERT INTO nxl_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Esau ihitio ieu ria otoe Seir. Seir nea hehuka wason orue tanui nea. Seir nea upu tau Hori. Seir nea hehuka wason numa upua tau ipana reini: Lotan, Syobal, Sibeon, Ana, Disyon, Eser, runa Disyan. ");
INSERT INTO nxl_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan ne hehuka tau: Hori runa Heman. Lotan hotai tau Timna. ");
INSERT INTO nxl_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Syobal ne hehuka tau: Alwan, Manahat, Ebal, Syefo, runa Onam. ");
INSERT INTO nxl_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeon ne hehuka tau: Aya runa Ana. Ana sahoro isupu wae pusate nau otoe huie. Waini isaka amai ne keledaiu nau rei, oyo isupui. (Keledai nooi sani naitanane ne ikine.) ");
INSERT INTO nxl_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana ne hehuka tau: Disyon runa anai pina Oholibama. ");
INSERT INTO nxl_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disyon ne hehuka tau: Hemdan, Esyban, Yitran, runa Keran. ");
INSERT INTO nxl_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser ne hehuka tau: Bilhan, Saawan, runa Akan. ");
INSERT INTO nxl_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disyan ne hehuka tau: Us runa Aran. ");
INSERT INTO nxl_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Sio numa upua tau sio Hori wason: Lotan, Syobal, Sibeon, Ana, ");
INSERT INTO nxl_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disyon, Eser, runa Disyan. ");
INSERT INTO nxl_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Sio aiau orime otoe Edom on ia aia isa irime sio Israel tewasi. ");
INSERT INTO nxl_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Sio ohiti Bela na irime kota Dinhaba. Bela amai tau Beor. ");
INSERT INTO nxl_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela imatai oyo sio ohiti Yobab na ikatiki. Yobab amai tau Serah. Ia arihoni nia Bosra. ");
INSERT INTO nxl_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobab imatai ita ohiti Husyam na ikatiki. Husyam arihoni otoe Teman. ");
INSERT INTO nxl_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husyam imatai ita ohiti Hadad na ikatiki. Hadad amai tau Bedad. Ia sahoro iahita runa sio Midian ria Moab. Oahita, ia sahoro ne untu. Ne kota wani Awit. ");
INSERT INTO nxl_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ita imatai reiso ohiti Samla na ikatiki. Ia rerihoni nia Masreka. ");
INSERT INTO nxl_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Ita imatai sio ohiti Saul na ikatiki. Ia rerihoni nia Rehobot wani haineke waene nusue. ");
INSERT INTO nxl_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ita Saul imatai ohiti Baal-Hanan na ikatiki. Amai tau Akhbor. ");
INSERT INTO nxl_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ita Baal-Hanan imatai oyo ohiti Hadar na ikatiki. Ia arihoni kota Pahu. Sahai nanai Mehetabeel. Mehetabeel amai tau Matred, inai tau Mesahab. ");
INSERT INTO nxl_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Reiso Esau nea upu tau: Timna, Alwa, Yetet, Oholibama, Ela, Pinon, Kenas, Teman, Mibsar, Magdiel, runa Iram. Sio wason numa upua tau ipana ria Edom. No ipana rai ohete nanaya tau otoa waron orue tanure rei. ");
INSERT INTO nxl_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakup iruei mai otoe wani amai, Isak naone iruei tanui rei. Otoe rei nanae Kanaan. ");
INSERT INTO nxl_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Areini sahoro sou monae arihoni Yakup ne hehuka. Yusup ne musum hutusa rahana itu nea reiso iakahai amai. Isaka rompau runa une-uneu iakahai nea kakau. Sio reimo nea kakau wason noa ina tau Bilha runa Silpha. Bilha runa Silpha mo, Yakup ne pinau no makahaia. Reiso isaka ikata nea kakau. Munata osana mo, isima inahu nea kakau rei osi amai. ");
INSERT INTO nxl_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yusup iamrai tau amai ikore-korei nea. Reiso amai anoi runai mainae erenesi nea kakau. Oyo iaisosi sio umau ohoni Yusup ne papi naue isa wani marainie. ");
INSERT INTO nxl_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Nea kakau onoo ata noa ama anoi runa Yusup erenesi sio. Reiso anoo rasaa tau Yusup. Openeso tanui rotu-tu oanamana ia-ia runai tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Taue isa tau pumono Yusup inekei iamnii. Ne niine rei iruniki osi nea kakau. ");
INSERT INTO nxl_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yusup iasau osiso, “Masi oatinu we niine rei. Monosi uneke uamnii ");
INSERT INTO nxl_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ita pusita noi nisi ikanihoo gandum (gandum nooi sani ana) oyo we gandum kamanunne ereoo katopu. Ne omi mo gandum kamanunna rahori we gandum kamanunne. Rahoriki oyo rahahue mai tanui.” ");
INSERT INTO nxl_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Oyo nea kakau oasau osiki. Oahata, “Ano nanie auna aia tau ami? Ano nanie akawasa tau ami si?” Reiso anoo rasaa mainae tau ne niine na ne anamanaya rai. ");
INSERT INTO nxl_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ita ineke iamnii honu. Oyo iruniki osi nea kakau. Iahata, “Uneke uamnii honu. Unoo ranie, hunane, runa oneu hutusa rahana osa ohahue mai tanuku.” ");
INSERT INTO nxl_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Niine rei iae, iruniki osi amai oi. Ne amai iatinu oyo iakapuku tanui. Iahata, “Me niine sae rei? Ata kani au, inam, runa mea kakau pusima mka ahahue mai tanua si?” ");
INSERT INTO nxl_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Nea kakau oananai. Ne amai iari-arinii niine rei. ");
INSERT INTO nxl_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Taue isa Yusup nea kakau wason osaka amai ne rompau runa ne une-uneu haineke nia Sikhem. Osakare na raai monota sui otoe rei. ");
INSERT INTO nxl_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Reiso Yakup iasau osi Yusup iahata, “Yusup. Masi aeua ria Sikhem, ria mea kakau. Wasora osaka re rompau runa re une-uneu.” Oyo Yusup isana, “Iake, ama.” ");
INSERT INTO nxl_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Iahata, “Masi anoo mea kakau runa re rompau runa une-uneu ata kani iake te tewa. Na nuni mai asima osiku.” Reiso iaisosi Yusup ieu iarihoni Ekote Hebron. Oyo ieu rotu-tu ihokai ria Sikhem. ");
INSERT INTO nxl_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Hoka ria oyo ieu suru ria suru nau sui otoe huie wani nene monota panesi. Isupu ia hanaie isa. Oyo ia hanaie rei iasei tanui, “He. Anina sae rei?” ");
INSERT INTO nxl_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Iahata, “Ama. Unina wea kakau wason osaka rompau runa une-uneu. Ama anooso? Munata anooso, asima osiku ee.” ");
INSERT INTO nxl_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Iahata, “Oeuso oarihoni reini nea. Tewa mo, uatinu oasau oahata, ‘Mai na ieuta iarihoni reini na ieuta poe nia Dotan.’” Oyo Yusup ieu ipusu nea kakau. Isupuso poe Dotan. ");
INSERT INTO nxl_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Waini on pan hainau asi, ne nea kakau onooi nea. Ne ihainekeso tewasi oimo pusiso oasau osi umau, “Mai na ihunui. ");
INSERT INTO nxl_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ia wain ineke iamnii sui osa rei ihokai nea. ");
INSERT INTO nxl_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Mai, ihunui na ipesiki poe parike anoe mai oto huie reini na iasau, iahata, ‘Binatang seae erehunui nea.’ Na inoo sapani na ne niineu rai.” ");
INSERT INTO nxl_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Noa kaka Ruben iatinu ata nanie ohunui reiso nanie iapuheui. Iapuheui arihoni nea waniu. Iahata, “Pene ohunui. ");
INSERT INTO nxl_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ne mai, na ipesiki na poe parike anoe mai otoe huie man. Pene ihitai.” Iasau san rei tau nanie iapuheui arihoni nea waniu na inuni roriki pan amai. ");
INSERT INTO nxl_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Mato ihokai mai nea kakau asi oimo, onosu ne papi naue wani marainie rei. ");
INSERT INTO nxl_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Onosui oyo ohetei. Ohetei oyo opesiki na poe parike anoe wani huie rei. ");
INSERT INTO nxl_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Opesiki poe parike anoe oyo orue poe, nanie oaiso. Ohetu uao anoa oyo osira tau sio tikana sio arihoni Ismael nea upu ohokaso on pan otoe Gilead. Ohokaso runa no unta waron rapunia kamane, hau rihua, runa ai unte. Nanie oeuso oahenre poe otoe Mesir. (Unta mo, makapana wani nene totue nene sonota pupua.) ");
INSERT INTO nxl_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Oyo Yehuda iasau osi nea kakau nea waniu. Iahata, “Nanie ihunui iauhuniki taa hae? Ne, mai na iaheniki na isupu re kepen umau. ");
INSERT INTO nxl_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Iaheniki osi sio Ismael reipa. Ne pene ihunui. Pene ihitai. Ia mo rea wani. Ita ruari re nasi.” Nea kakau nea waniu oatinu tau ne anamanae rei. ");
INSERT INTO nxl_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Reiso sio manaheniu on pan otoe Midian arihoni Ismael nea upu nanie oniku oyo ooiso mai. Hoka mai oyo ohoka noa wani arihoni parike anoe rei. Ohokai oyo oaheniki osi sio Ismael rei tau kepen inata hutu ua. Oyo orori Yusup na poe Mesir. ");
INSERT INTO nxl_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Sinasi oahen Yusup, Ruben tutui tewa. Ihokai mai, oimo inoo poe parike anoe Yusup tutui tewa nea. Iatamisiki. Reiso ikiha ruai ne papite. ");
INSERT INTO nxl_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Oyo ieu pan nea waniu iasei, “Ia ikine reimo wain tewa nea. Kani umunaku?” ");
INSERT INTO nxl_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Oyo onana Yusup ne papi naue wani marainie rei. Onanai oyo ohunu une-une isa samatoro okusa une-une nasie tau ne papite rei. ");
INSERT INTO nxl_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Oyo orori papite rei osi noa ama samatoro oasau, oahata, “Papite rei, ami asupui. Masi ationa, areimo anam hanaie ne papite te tewa?” ");
INSERT INTO nxl_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Oyo iationa papite rei. Iasau ata, “Ira oe! Titue. Reini mo anaku hanaie ne papite rei, tea? Binatang seae ereaiki nea, tea?. Ira oe. Yusup imatai nea tea?” ");
INSERT INTO nxl_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Reiso ikiha ne papite. Iatamisiki reiso ikihai. Oyo iausahu karuni wani sani karuni nione rei. Iausahui na sio oanei ata iatamisi anai hanaie. Iatamisi anai hanaie rei ro-rotu-tu potuina. ");
INSERT INTO nxl_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ne, ne hehuka hanaia, ne mananua, runa anai pina pusiso ohoka mai tanui. Oaunaui san rei, “Ama. Pene arani kuru. Imatai nea, tea? Kani arani ata mka inuniki mai tanua honu?” Ne ipenei iatinu tau sio no anamanaya rai. Iahata, “Rotu-tu umataku iae, urani runa anaku hanaie sirinia. Urani rotu-tu usipuku poe tanui poe tuniai matane.” Reiso irani sirinia noso anai hanaie Yusup. ");
INSERT INTO nxl_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ne poe Mesir sio Midian rei oahen Yusup osi Potifar. Potifar ia mamsaka aia. Sio Mesir ooi no aiau tau Piraun. Ia mamsakae rei, ia kapitane tau sio mamsaka Piraun ne numa onate. ");
INSERT INTO nxl_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Nene muie rei Yehuda ihitio ieui iarihoni nea kakau nea waniu oyo iruei ikata ia hanaie isa arihoni nia Adulam. Ia hanaie reimo, nanai Hira. ");
INSERT INTO nxl_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Mai niane rei Yehuda inoo ia pina hehu Kanaan isa. Ia pina rei amai nanai Sua. Uaso onana umau. ");
INSERT INTO nxl_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Oyo sahai tinain taua. Iruei runa anai hanaie manaonete ohete nanai tau Er. ");
INSERT INTO nxl_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ita sahai tinain taua honu. Iruei runa anai hanaie isa honu. Ohete nanai tau Onan. ");
INSERT INTO nxl_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ita tinain taua honu. Iruei runa anai hanaie isa honu. Ohete nanai tau Syela. Ne Syela iamrai rei Yehuda waira nia Kesib. ");
INSERT INTO nxl_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Er ia mainae nea oyo amai inina sahai isa wain nanai Tamar. ");
INSERT INTO nxl_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Yahweh inoo Er ne kahatena panesi reiso ihunui. ");
INSERT INTO nxl_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Er imatai nea reiso amai iasau osi anai hanaie autihue. Iahata, “Onan. Aeu poe kakam pina na ananai. Kahurae ananai na aneke runai. Me hehuka rei tau kakam nanai.” ");
INSERT INTO nxl_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ianei ata mka ne hehuka rei osi ia ruai tewa reiso inekei ikata sahai ne ipenei tau iunai tinain taua. Inekei ikatai sui osa ne ipenei tau iunai tinain taua reiso Onan iohui poe tuamane. ");
INSERT INTO nxl_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ipenei iunai tinain taua reiso Yahweh iapasanai reiso imatai. ");
INSERT INTO nxl_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Imatai reiso Yehuda iasau osi ne mananue, Tamar. Iahata, “Anunia poe me numa. Aruea poe inam runa amam tau ano uhanu nea. Aruea poe inam runa amam sio rotu-tu Syela ia mainae samatoro uamo onana umau.” Iasau san rei tau ikaitau pene rotu-tu Anahatana ihunu Syela sani ihunu nea kakau uaso rei. Amai, Yehuda iaisosiki san rei, reiso Tamar inuniki poe inai runa amai. ");
INSERT INTO nxl_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Kani nene musum isa san rei ereniku oyo Yehuda sahai imatai. Sahai mo, Sua anai pina rei. Iatamisi sahai suka oyo Yehuda runa ne neta isa oeuso roe nia Timna roe sio wason oatori rompau nene hunua. Ne neta rei nanai Hira. Ia arihoni nia Adulam. ");
INSERT INTO nxl_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Sio osima osi Tamar oahata, “Amam tanaite wain ihokai. Nanie ieui roe Timna na nanie iatori ne rompau nene hunua.” ");
INSERT INTO nxl_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Iatinu san rei reiso inosu ne papi uhanu rei oyo iausahu papi wani erenete uai anoe pusiki. Inete uai anoe pusi samatoro iruei haineke niane rei nene mitanunue. Niane rei nanae Enaim. Niane rei erehaineke arena wani nanie ereeu roe Timna. Iuna san rei tau ianei ata anai hanaie Syela ia mainae nea ne amai irui uaso oausahaso tewasi. ");
INSERT INTO nxl_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Reiso Tamar iruei mai mitanunue oyo amai inooi iahata kani ia pina numa naue wain iahen ruai. Tewa mo, inete uai anoe. ");
INSERT INTO nxl_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Inooi oyo ieui haineke. Iahata, “Ano ainisi ina na uneke ukataya?” Iationa ne mananue tewa. Iahata, “Pusu ruam arui, upu.” ");
INSERT INTO nxl_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Iahata, “Au mka urui me une-une honue isa.” Iahata, “Iake. Hete sae arui sae isa osiku mai ee. Rotu-tu arui une-une rei osiku samatoro on mai uniki.” ");
INSERT INTO nxl_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Iahata, “Reiso ainisi sae rei?” Iahata, “Rui me mamono inate reino mai runa nene awane. Rui me karupae reino wamo akatai reino mai oi.” Mamono inate rei sio ouna siaie tanui na oanei ata Yehuda ne mamono. Yehuda irui ne apia rai oyo uaso onekeso. Onekeso oyo Tamar tinain taua. ");
INSERT INTO nxl_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Onekeso pusi oyo Tamar inuniki poe ne numa. Ihoka poe inosu ne papite rei oyo iausahu ne papi uhanu rei honu. ");
INSERT INTO nxl_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Nene onona inasa nau san rei oyo Yehuda iaisosi ne neta rei. Iaisosi Hira na irori une-une rei na inana ne apia rai. Inana ne mamono inate runa karupae waron naone iruire rai. Ne Hira isupu ia pina rei tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Reiso iasei suru ria suru nau tau sio poe Enaim. Iahata, “Ia pina numa naue wain iruei inapa mai arena nusue rei wainpa?” Sio oahata, “Ia pina numa naue isa mai rei tewa.” ");
INSERT INTO nxl_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Reiso inuniki pan, iasau osi Yehuda san rei, “Au usupu ia pina rei tewa. Sio poe niane rei iae, oasau ata ia pina numa naue isa poe rei tewa.” ");
INSERT INTO nxl_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Iahata, “Apia rai ruaya osiki man nea, tea? Hete sae ita pene ihana kaumaate rei. Unina nanie usenu, ne aninai nea ne asupui tewa.” ");
INSERT INTO nxl_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Reiso nene hunana tonu nau san rei oyo sio oasau osi Yehuda oahata, “Me mananue iuna ruai sani ia pina numa naue reiso waipo tinain taua nea.” Iahata, “Onana ia pina rei mai na iakanupui na imatai arihoni tuniai nea.” ");
INSERT INTO nxl_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Taa Tamar ihokai arihoni numa oyo iaunau osi amai. Iahata, “Tinaiku taua rei tau ia hanaie wain ne apia rai. Arinii kani ia seia ne apia rai?” ");
INSERT INTO nxl_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yehuda iationa ne apia rai. Iahata, “Ia pina reimo isana tewa. Au sahoro usana. Uahata nanie inuniki poe ne mansia mainaya inapa-napa Syela rotu-tu ia mainae samatoro uaso onana umau. Ne urui uaso onana umau sani uasau rei tewa. Reiso au sahoro usana.” Yehuda ineke-neke runa Tamar tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamar iruei runa anai hanaie rei poe sira tau sio iki lalekau. ");
INSERT INTO nxl_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Pannuhu uaso nanie oamrai rei ia ikine isa ihoka hanai atue naone. Ia pina ona pian ikanihoo ia ikine wain hanai atue erehokai naone rei tau pola msinae. Iahata, “Ia ikine rei sahoro ihokai naone.” ");
INSERT INTO nxl_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ne ia ikine rei isaru hanai atue honu reiso ia ikine isa iamraiki naone. Ia pina ona pian iahata, “Reiso ano arapu nanie ahokaya san rei si?” Reiso ohete ia ikine rei nanai tau Peres. Peres nene nohue “ihokai naone”. ");
INSERT INTO nxl_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ihokai samatoro ia ikine wain ikanihoo hanai atue tau pola msinae rei ihokai. Ohete nanai tau Serah. Serah nene nohue, “Msinae”. ");
INSERT INTO nxl_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Reiso sio Ismael noa upu orori Yusup poe otoe Mesir oaheniki osi Potifar rei. ");
INSERT INTO nxl_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ne Yahweh ikata runa Yusup reiso ne pakarian pusire raeu iake. Iahesa tau sae isa tewa. Iruei poe upui ne numa. Upui, reimo Potifar. ");
INSERT INTO nxl_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potifar ianei ata Yahweh ikata runa Yusup. Ianei ata Yahweh iakahaiki na ne pakarian raeu iake. ");
INSERT INTO nxl_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potifar anoi iake tau Yusup reiso ihitiki tau hanai wanane. Irui kawasa osiki na isaka ne numa hutae pusiki. Isaka ne sae man. ");
INSERT INTO nxl_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ihitiki oyo Yahweh irui iake osi Potifar ne numa hutae. Irui iake osi ne sae man. Masike mai numa runa noi ne nisiu iae, irui iake osiki. Yusup tutui reiso Yahweh irui iake osi Potifar. ");
INSERT INTO nxl_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potifar iparisaa tau Yusup reiso irui kawasa osiki na isaka ne sae man. Reiso Potifar anoi erenoa runa sae isa tewa nea. Anoi erenoa runa ne muaine man. Yusup mo, ia hehu iake. Ne patane maka-makae. ");
INSERT INTO nxl_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Reiso taue isa, Potifar sahai iasu-asumata Yusup. Oyo iasau osiki, “Mai na uata ineketa.” ");
INSERT INTO nxl_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ne Yusup ipenei inekei runai. Iahata, “Au upeneku. Upuku Potifar iparisaa tanuku tau ne sae man. Anoi erenoa runa sae isa mai numa anoe reini tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Mai numa reini mo, we kawasa mainae. Sani upuku Potifar oi. Iparisaa pusire osiku nea. Hasae ano sahoro tewa. Sapan na nanie una kahatene san rei na upalalosa tau Anahatana?” ");
INSERT INTO nxl_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Masike san rei iae, Potifar sahai iapamanui iae, ne ipenei ineke ikatai. Iapamanui sui osa, ne ipenei sirinia. ");
INSERT INTO nxl_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Tau ranie hatae isa Yusup inusui pan numa anoe nanie ipakarian. Ia osa-sa man nooi pan numa anoe rei tewa. Numa rei huie nai osa. ");
INSERT INTO nxl_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Potifar sahai inesa tau ne papite iasau iahata, “Mai na uata ineketa.” Ne ikoka ruai oyo ikasu heu ruai. Ikasu heu ruai oyo irumai. Ne, ne papite wamo ia pina rei ikatai. ");
INSERT INTO nxl_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ia pina rei inoo ata Yusup irumai ne, ne papite wani hanai atue ");
INSERT INTO nxl_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","reiso ioi iakapona sio numa anoe rei. Ioiso oyo iasau iahata, “Masi onoo. Ia Ibrani rei wain sahaku iroriki mai numa reini iakarotata. Inusui pan we kakaranae anoe nanie ineke runaku. Ne uakapona kuati. ");
INSERT INTO nxl_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Iatinu au uakapona kuati oyo irumai, ne iarihoni ne papite mai nusuku.” ");
INSERT INTO nxl_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Reiso Potifar sahai ikata Yusup ne papite rei erenapa sahai inuniki. ");
INSERT INTO nxl_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Sahai inuniki samatoro isima nahu Yusup osiki. Iahata, “Ia Ibrani wain aroriki mai rei, reimo inusui mai re kakaranae nanie ineke runaku. ");
INSERT INTO nxl_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ne uakapona runai reiso irumai iarihoni ne papite mai nusuku.” ");
INSERT INTO nxl_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Iatinu san rei oyo anoi eresaa mainae. ");
INSERT INTO nxl_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Reiso iaisosi ne makahaia na onota Yusup na onusui pan pui anoe. Pui wani sio osaka ia aia ne maresia tanui. Reiso onusui pan pui anoe. ");
INSERT INTO nxl_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ne Yahweh ikata runa Yusup. Anoi runai rotu-tu ia pui upue rei ne sukai. ");
INSERT INTO nxl_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Reiso ia pui upue rei irui Yusup isaka sio aia ne maresia rei. ");
INSERT INTO nxl_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ia pui upue rei isaka sio maresia tewa nea. Tewa mo, irui Yusup isakaso nea. Yahweh ikata runai reiso ne pakarian pusire iake. Mahesae tanui tewa. ");
INSERT INTO nxl_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Oyo tau muie sio makahaia tau ia onate aia Mesir ua ouna sana tau ia ona aia rei. Sio makahaia reimo, ia isa ia mamsuhu tihu anggur osi ia ona aia, ia isa isaka ikotu porotiu. ");
INSERT INTO nxl_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Ouna sana reiso ia ona aia anoi eresaa tanso. ");
INSERT INTO nxl_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Oyo inususo pan pui anoe. Pui rei wapo ia kapitane tau sio mamsaka ia ona aia ne numa. Yusup wain tanui oi. ");
INSERT INTO nxl_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ia kapitane rei irui kawasa osi Yusup na isakaso. Uaso potuina pan pui anoe rei ");
INSERT INTO nxl_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","oyo tau onone hatae isa uaso oneke oamnii. No niineu rai nene nohue osa tewa. ");
INSERT INTO nxl_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Oyo nene hanroe Yusup ihokai mai tanso. Inoo uaso anoo mtinta. ");
INSERT INTO nxl_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Reiso iasei tanso, “We netau. Ranie hatae reini mo, unoo uamo anomo mtinta tau sae rei?” ");
INSERT INTO nxl_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Oahata, “Monosi uama aneke aamnii. Ia isa ianei isima runa nene nohue tewa.” Iahata, “Anahatana man sahoro isima runa niineu nene nohue. Masi oruni mo niineu rai roe.” ");
INSERT INTO nxl_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ia mamsuhu tihu anggur iasau, “Monosi uneke uamnii ai anggur eresapa mai uaku anoe. ");
INSERT INTO nxl_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Anggur eresapa nene sakata tonu. Nene sakata rai samatoro nene totua. Potuina tewa oyo nene kupako rarata. Oyo huaya rai munaya. ");
INSERT INTO nxl_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Tau rei ukata ia ona aia ne koinanae. Sani rei oyo unona anggur huaya rai oyo uhusire poe koinanae anoe. Uhusi pusire samatoro uruiki osiki.” ");
INSERT INTO nxl_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusup iahata, “Wani san rei. Sakata tonu raimo, onona tonu. ");
INSERT INTO nxl_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Reiso nesie onona tonu rai, mka ia ona aia ihokaya arihoni pui anoe. Iapasanaya tewa nea. Mka ihitia tau ne mamsuhu anggur honu. Mka arui koinanae osi ia ona aia sani naone rei honu. ");
INSERT INTO nxl_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ne asupu me iake nea mo, anom repeka runaku. Masi aruni we masana reini osi ia onate aia na ihokaku rerihoni pui anoe reini. ");
INSERT INTO nxl_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Tewa mo, sio okimanakaku arihoni otoe wani sio Ibrani orueso. Ne mai Mesir reini mo, una masana isa tewa ne onusuku mai pui anoe.” ");
INSERT INTO nxl_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ia mamkotu poroti rei iatinu tau ia mamsuhu anggur ne niine rei iake reiso iruni ne niine osi Yusup oi. Iahata, “Uneke uamnii ukoku pakuna tonu taua tau porotiu. ");
INSERT INTO nxl_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Tau pakune wani on roe haha mo porotiu nitaya-nitaya osi ia ona aia. Ne manua rahoka mai raaire.” ");
INSERT INTO nxl_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusup iahata, “Me niine rei wani san rei. Pakuna tonu rai mo onona tonu. ");
INSERT INTO nxl_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Nesie onona tonu oimo ia ona aia mka iaisosiso na oroto roha unum samatoro oakatana me patane roe hini. Oakatanai oyo manua rahoka rarutu me henate.” ");
INSERT INTO nxl_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Nene onona tonu oyo ia ona aia ne musum ereneni. Reiso iuna karisaa mainae osi sio mamsakaya. Iaisosi san rei. Iahata, “Ohoka ia mamsuhu anggur runa ia mamkotu poroti arihoni pui anoe na ororiso mai sio mamsaka aia uao anoa.” ");
INSERT INTO nxl_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Hoka mai oyo ia mamsuhu anggur rei, ihitiki tau isuhu anggur honu. ");
INSERT INTO nxl_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ne ia mamkotu poroti reimo, ohunui. Pusire raeu sani Yusup iasau rei. ");
INSERT INTO nxl_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ne ia mamsuhu anggur rei anoi repeka runa Yusup tewa. Anoi kanihue nai osa. Isima runa Yusup ne masana tewa. ");
INSERT INTO nxl_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Yusup isima runa uaso no niineu, musum ua raniku nea oyo ia ona aia inekei iamnii. Ineke iamnii iooi nau waene wani nanae Nil nusue. ");
INSERT INTO nxl_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Sira tau inoo koropou itu rahotu on poe waene rei. Koropou rai noore kopotuena samatoro pasa-pasanisia. Rahotu oyo raai monota sui waene nusue. ");
INSERT INTO nxl_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ita koropou itu honu rahotu. Koropou rai mo rakahanokaso. Nene unta rapunu unia. Koropou kahanokana rai, raoo mai koropou waron pokotuena mai waene nusue. ");
INSERT INTO nxl_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Oyo koropou kahanokana rai, raai koropou pokotuena. Sani rei oyo ia ona aia ihanui. ");
INSERT INTO nxl_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ita inekei honu. Ineke iamnii gandum huaya itu waron mtuaya nea. Nene kania rai maka-makaya. Huaya itu rai raruhu tau nene sakate osa. ");
INSERT INTO nxl_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ita hua itu raruhu honu. Ne ramkukuso. Isia iaka tewa. Ramotoso tau ihu titie. ");
INSERT INTO nxl_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Oyo kania waron ramkukuso rai rarono gandum waron isia iaka rai. Taa san rei oyo ia ona aia ihanui samatoro isira ata inekei iamnii. ");
INSERT INTO nxl_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Nene omnanoe rei ia ona aia anoi ererau. Reiso ioi sio nau upua runa pakakasi upua. Oyo iruni ne niineu rai osiso. Ne ia osa-sa ianei nene nohue tewa. ");
INSERT INTO nxl_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Oyo ia mamsuhu tihu anggur iasau osi ia ona aia, iahata, “Ranie hatae reini matoro uamanaku we isanae. We isanae wani usima runa Yusup, ia makahaie, ne masana tewa. Anoku kanihue reiso usima runa ia makahaie wain ia Ibrani pan pui anoe rei ne masana tewa. ");
INSERT INTO nxl_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Naone ano akapuku tanuku runa ia mamkotu porotiu uama oyo aisosiso onusuma pan pui anoe poe ia kapitane tau sio mamsaka me numa. ");
INSERT INTO nxl_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Tau mono isa uama aneke aamnii. Uama ma niineu rai nene nohue osa tewa. ");
INSERT INTO nxl_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ia isa rerihoni Ibrani ikatama pan rei. Ia mo ia makahaie tau ia kapitane rei. Ami aruni ma niineu rai osiki oyo isima runa nene nohue. ");
INSERT INTO nxl_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Pusire pannuhu sani iasaure rei. Ano ahiti au mai we tanei wani mataanoe honu. Ne aaisosiso ohunu ia mamkotu porotiu rei.” ");
INSERT INTO nxl_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Reiso ia ona aia iaisosiso na ohoka Yusup arihoni pui anoe. Reiso ohokai sansana. Yusup ikoma ne manapesiu samatoro iausahu ne apia oyo ieui ria ia ona aia. ");
INSERT INTO nxl_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ia ona aia iahata, “Uneke uamnii, ne ia isa ianei we niine rei nene nohue tewa. Ia isa isima osiku rerihoni ano ata ano mo, aanei asima runa niine nene nohue.” ");
INSERT INTO nxl_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ihata, “Upuku. Au uanei tewa. Ne Anahatana sahoro irui nene nohue rai.” ");
INSERT INTO nxl_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Iahata, “Uneke uamnii uooku nau Wae Nil nusue. ");
INSERT INTO nxl_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Oyo koropou itu rahotu on poe waene anoe. Koropou raimo kopotuena runa pasa-pasanisia. Rahotu oyo raai monota nau waene nusue rei. ");
INSERT INTO nxl_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ita koropou itu honu rahotu. Koropou raimo kahanokana. Nene unta rapunu unia. Unoo koropou kahanokana san rei mai Mesir tewasi. ");
INSERT INTO nxl_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Koropou waron rakahanokaso rei raai pusi koropou waron kopotuena rai. ");
INSERT INTO nxl_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ne koropou waron rakahanokaso rei rakahanokaso sirinia. Oyo uhanuku. ");
INSERT INTO nxl_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ita unekeku honu. Uneke uamnii gandum hua itu waron mtuaya nene isia iaka. Raruhu tau sakate osa. ");
INSERT INTO nxl_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ita gandum hua itu honu, gandum raimo ramkukuso. Isia iaka tewa. Ramotoso tau ihu titie. ");
INSERT INTO nxl_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Maneiu waron ramkukuso rai rarono gandum waron mtuaya rai. Uruni we niineu ua rai osi sio nau upua runa sio pakakasi upua ne ia isa ianei nene mamariti tewa.” ");
INSERT INTO nxl_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Iahata, “Upuku. Me niineu ua raimo, uare osa. Anahatana isima osia runa sae wani mka iunai. ");
INSERT INTO nxl_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Koropou itu waron pokotuena rai runa gandum waron mtuaya, areimo musum itu. Uare nene nohue osa. ");
INSERT INTO nxl_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ne koropou kahanokana itu waron rahotu tau muie runa gandum kani kukuta tau ihu titie, areimo musum itu honu. Tau musum itu rai, mka musum muaine tewa. ");
INSERT INTO nxl_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Sani uasau osi upuku rei, Anahatana iatuhete osia sae wani mka iunai. ");
INSERT INTO nxl_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Musum itu, muaina panesi mai Mesir pusiki. ");
INSERT INTO nxl_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Oyo mka musum itu, muaine tewa. Na muaina panesi mka anori kanihua. Tau sae? Musum muaine tewa mka otoe reini sio anoo mtinta. ");
INSERT INTO nxl_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Me niineu ua raimo, nene nohue Anahatana ruai iautuei na mka iunai sansana. ");
INSERT INTO nxl_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Reiso nene iake mo, aroma ia isa wain ianei iheu iake. Ianei iaisosiso rotu-tu ne kaheute ereeu iake. Aromai oyo arui kawasa osiki na isaka otoe Mesir reini. ");
INSERT INTO nxl_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","35","Kahurae ahiti mamsakaya tamena na arui kawasa osiso na oamanou gandum umau. Oaisosi sio mamrahua rei na osama no gandum tau pahakian nima. Pahakiani osa osi sio mamsakaya rai osakare, pahakian ate osi sio ruao oaire orahure. Aisosiso san rei tau musum itu rai muaina panesi. Oyo sio mamsakaya oaunutu no pahakian noi kotau na osakare. ");
INSERT INTO nxl_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Osakare rotu-tu musum itu muaine tewa. Mka ita mai otoe Mesir reini, oaire tau musum itu rai, na pene imata muaine.” ");
INSERT INTO nxl_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ia ona aia runa ne makahaia oatinu tau Yusup ne anamanaya rai iake. ");
INSERT INTO nxl_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Reiso ia ona aia iasau osiso iahata, “Mka isupu ia isa iake sani Yusup reini tewa. Ia iake tau Anahatana Ne Inaha ikata runai.” ");
INSERT INTO nxl_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Reiso ia ona aia iasau osi Yusup iahata, “Anahatana irui pusire reini osia reiso ano aanei pusire anesi ia seia man. ");
INSERT INTO nxl_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ano mo, mka uhitia tau ano mainae tau otoe Mesir reini. Mka sio pusiso oatinu tanua. Hasae au sahoro au mainae unesi ano.” ");
INSERT INTO nxl_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","42","Reiso ia ona aia inosu ne sapauu arihoni hanai nakate. Sapauu rei sio ouna siaie tanui na oationa ata ia ona aia ne sapauu. Inosui oyo inusui tau Yusup hanai nakate. Iahata, “Runa sapauu reini uhitia na auna mainae akawasa mai otoe Mesir pusiki.” Ita iausahu papi naue wani ohie osiki. Ita iausahu rante hunahane osiki oi. ");
INSERT INTO nxl_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Oyo irui kareta isa wani naitanane ereroriki. Kereta rei, areimo osi ia ona aia hanai wanane. Ia onate aia ne mamsakaya oeu oanaone arihoni kareta rei na oaka-akapona, “Suka arihoni arena. Suka arihoni ia ona aia hanai wanane.” Reiso ihiti Yusup na iuna ia mainae iakawasa otoe Mesir. ");
INSERT INTO nxl_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ia ona aia iahata, “Au mo, au aia. Munata ano amanaku tewasi, utapi ia isa iuna sae isa tewasi.” ");
INSERT INTO nxl_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Oyo ia ona aia ihete nananake Mesir isa osi Yusup, areimo ikati nanai tau Sapnat-Paaneah. Irui ia pina isa osi Yusup tau sahai. Ia pina rei nanai Asnat. Ia mo, ia Potifera anai pina. Potifera, ia isaka ianori runa sio Mesir no anahatana ranie wani titue tewa. Isaka poe kota Heliopolis. ");
INSERT INTO nxl_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yusup mato ipakarian osi ia ona aia tau ne musum hutu tonu. Reiso Yusup ieui iarihoni ia ona aia ne numa oyo ieu sui otoe Mesir na isaka sio wason oamanou gandum kania. ");
INSERT INTO nxl_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Tau musum itu atuhu rahua panesi. Reiso muaina panesi. ");
INSERT INTO nxl_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Maneiu rai, Yusup iaisosiso oamanoure samatoro oaunuture sui kotau. Tau kota isa oaunutu gandum waron sio onanare arihoni no nisiu haineke rei. ");
INSERT INTO nxl_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Maneiu waron oaunuture rai, panesi-panesi rotu-tu oarihoni oheu tanure. Oheure tewa nea. Tau sae? Panesi sani sisia nau nuae. ");
INSERT INTO nxl_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Musum itu muaina tewa rahoka tewasi. Musum itu muaina panesi asi. Yusup sahai Asnat isusu ne hehuka hanaia ua nea. ");
INSERT INTO nxl_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusup iahata, “Anahatana iuna anoku kanihue tau au sinsaraku runa wea enau arihoni amaku.” Reiso ihete anai hanaie manaonete nanai tau Manasye. Manasye mo, atinui sani sou Ibrani wani nene nohue anoi kanihue. ");
INSERT INTO nxl_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ita iasau honu, “Anahatana irui we hehuka mai otoe wani au sinsaraku tanui.” Reiso ihete anai hanaie muie nanai tau Efraim. Efraim mo, atinui sani sou Ibrani wani nene nohue isusu nai ua. ");
INSERT INTO nxl_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Musum itu muaina panesi raniku nea. ");
INSERT INTO nxl_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Oyo musum itu muaina tewa. Ereeu sani Yusup iasau rei. Sui tuniai pusiki muaina tewa. Hasae mai otoe Mesir sahoro no muaina. ");
INSERT INTO nxl_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Taa sio Mesir no muaina pusire nea oyo oainisi muaine tau ia ona aia. Oyo ia ona aia iaisosiso san rei, “Oeu noi Yusup. Opusu sae wani ia iasau osimo.” ");
INSERT INTO nxl_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Taa sio panesi honu osupu no muaina tewa sui otoe rei, oyo Yusup iaisosiso ohuka numau waron oaunutu gandum tanure nea. Ohukare oyo iahen gandum osi sio Mesir. ");
INSERT INTO nxl_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Oni tuniai reini pusiki sio ohoka ohane gandum mai Mesir arihoni Yusup. Tau muaina tewa mai tuniai reini pusiki. ");
INSERT INTO nxl_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","2","Yakup iatinu ata gandum waropo otoe Mesir oyo iasau osi ne hehuka hanaia iahata, “Uatinu ata gandum panesi waropo Mesir. Oeu poe na ohane na pene imata muaie. Omi nanie oru-ruemo oasumata umau man taa hae?” ");
INSERT INTO nxl_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Reiso Yusup nea kakau hutusa oeu poe ohane gandum poe Mesir. ");
INSERT INTO nxl_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ne Yakup irui Benyamin, Yusup wanin rei, ieu ikataso tewa. Tau sae? Ikaitau pene rotu-tu siraka isa rekahuui. ");
INSERT INTO nxl_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Yakup ne hehuka runa sio panesi oeuso poe na ohane gandum. Tau sae? Pani otoe Kanaan muaina tewa. ");
INSERT INTO nxl_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ia wain iahen gandum osi sio tuniai reini pusiki mo Yusup, gubernur tau otoe Mesir. Reiso Yusup nea kakau ohokaso mai ohahue mai tanui. ");
INSERT INTO nxl_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yusup inoo nea kakau, iationaso. Ne iakarota ata iationaso tewa. Iasei tanso nioi makae, “Omi reini mo, omi on supa?” Oahata, “Upuku. Ami mo, ami Kanaan. Ahokama mai, nanie ahane gandum.” ");
INSERT INTO nxl_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Masike Yusup iationa nea kakau iae, sio oationa ia tewa. ");
INSERT INTO nxl_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Anoi repeka runa ne niine rerihoni nea kakau. Reiso iasau iahata, “Omi reini mo, omi osaka osima-sima osi mania nisau. Omi ohoka mai nanie onoo mania niane, ata kani asaka paka supa tewa.” ");
INSERT INTO nxl_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Oahata, “Tewa, upu. Ami mo, me manianeu. Ahokama mai nanie ahane gandum man. ");
INSERT INTO nxl_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ami mo, ami kaka wani. Ami mo, ami makarotana tewa. Asaka asima-sima tewa.” ");
INSERT INTO nxl_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Iahata, “Tewa. Omi mo, oakarota! Ohokamo mai nanie onoo mani niane rei, ami asaka paka supa tewa.” ");
INSERT INTO nxl_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Oahata, “Upuku ami reini mo ami kaka wani hutusa rahana ua. Mania ama waipa Kanaan. Ia isa arihoni ami, imatai nea. Mania wani muie waipan ikata mania ama.” ");
INSERT INTO nxl_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","“Titue sani uasau rei. Omi reini mo, omi osaka osima-sima. ");
INSERT INTO nxl_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Nanie ureamo. Usopa tau ia ona aia nanai. Munata moa wani ihokai mai tewa, omi mka oeu oarihoni otoe reini tewa. ");
INSERT INTO nxl_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ia isa arihoni omi rei, mka inuni suru pan, inana moa wani muie rei. Omi umau onapa mai rei pan pui anoe rotu-tu onuni mai orori moa wani rei. Munata tewa, usopa tau ia ona aia nanai, omi mo, osaka osima-sima osi mania nisau!” ");
INSERT INTO nxl_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Reiso inususo pan pui anoe rotu-tu onona tonu. ");
INSERT INTO nxl_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Nene onona ua oyo Yusup iasau osiso iahata, “Uamuira Anahatana. Mka uapuheumo hete sae ouna sani wani uasau reini. ");
INSERT INTO nxl_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ouna san rei na uanei ata oakarota tewa. Ia isa arihoni omi mka inusu pui. Omi umau onunimo orori gandum waron ohanere osi mo enau na pene omata muaie. ");
INSERT INTO nxl_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Taa san rei oyo orori mo wani muie osiku. Na uanei ata omi mo anamanaya rai titue na mka uhunumo tewa.” Sio oamanaku tau Yusup ne anamanaya. ");
INSERT INTO nxl_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Reiso oasau osi umau oahata, “Imatata. Anahatana wain iapasanata nea. Tau sae? Naone iuna rosa tau rea wani. Iainisi na pene ihunui. Ne ipeneta iatinu tanui. Masike inoo ata ia sinsarai, ipeneta iatinu tanui sirinia. Reiso muie reini siraka reini rekahuuta nea.” ");
INSERT INTO nxl_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben iahata, “Hmm. Naone uasau mo, oatinu tau au tewa. Reiso rasa na rasa. Uasau ata nanie pene ipalalosa tanui. Ne oatinu tau au tewa. Reiso muie reini ne nasi wani reasei tanuta.” ");
INSERT INTO nxl_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Sio oahata Yusup ianei no sou tewa. Tau sae? Sinasi oanamana osi Yusup tau ia isa isima runa no anamanaya tau ruao no sou. Reiso sio oahata kani Yusup ianei no sou tewa. Aikee ianei. ");
INSERT INTO nxl_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yusup iatinu Ruben iasau san rei anoi runai reiso iuni ikusa matai waena. Iapamese anoi oyo iuni ianamana osiso honu. Iaisosiso onana Simeon iarihoniso na okanihooi. Reiso okanihooi noi nea kakau nea waniu uao anoa. ");
INSERT INTO nxl_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Taa san rei oyo Yusup iaisosi ne makahaia iahata, “Oaiinu no gandum tau no karuni. No kepen rai, oaiinure noi no karuni anoa. Orui no wekau na oaire sui arena.” Ia ne anamanaya rai, opusure. ");
INSERT INTO nxl_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Reiso nea kakau oapusaa no muaina rai roe keledaiu totua. (Keledai nooi sani naitanane ne ikine.) Oapusaare oyo onunso. ");
INSERT INTO nxl_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Nanie onekeso pan arena tinai tihue, ia isa ihuka ne karuni nanie ipana ne keledai. Ihukai oyo sira tau isupu ne kepen rai roe karuni anoe. ");
INSERT INTO nxl_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","“Ira! Masi oeu mai! Au we kepen waron maa! Waroni mai we karuni hahae.” Anoo rarau okaitau hunu ruao oyo oasei tau umau, “Sae wani Anahatana iunai tanuta reini?” ");
INSERT INTO nxl_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Yusup nea kakau ohokaso pan noa ama pan otoe Kanaan. Ohoka pan, oruni runa sae wani ia ona mainae tau otoe Mesir iunaso. Oasau oahata, ");
INSERT INTO nxl_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Ama. Ia ona mainae wain ne kawasa tau otoe Mesir ianamana makae tanuma. Iahata, ‘Omi mo, omi osaka osima-sima runa mai otoe reini.’ ");
INSERT INTO nxl_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ne ami asau osiki ata, ‘Upu. Ami mo, ami iaka. Asaka asima-sima tewa. Ami mo, ami makarotana tewa. ");
INSERT INTO nxl_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ami kaka wani pusima, ami hutusa rahana ua. Ami pusima arihoni mani ama osa. Ia osa imatai nea. Ia muie mo waipan ikata mani ama pan Kanaan.’ ");
INSERT INTO nxl_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Iahata, ‘Nanie ureamo ata kani omi makarotana te tewa. Ia isa arihoni omi reini pusimo mka inapa mai rei. Omi umau onunimo. Onunimo orori gandum osi mo enau wason omata muaine. ");
INSERT INTO nxl_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Rotu-tu orori moa wani muie samatoro uanei ata omi mo, osaka osima-sima tewa. Na omi mo oakarota tewa. Ororiki samatoro uhoka moa wani moa kaka reini osimo. Na oruemo mai otoe reini, mo suka oahen ohane.’” ");
INSERT INTO nxl_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Reiso ohuka karuni oyo osuhu gandum rai. Osuhure arihoni karuni samatoro sira tau onoo no kepen rai. Osupu no kepen pan nene naniaya anoa. Onoore oyo okaitau hunu ruao. Noa ama iae ikaitau oi. ");
INSERT INTO nxl_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Reiso noa ama iasau, “Yusup wain tewa nea. Simeon wain tewa nea. Ita nanie orori Benyamin honu? Mka orori we hehuka pusiso oarihoniku. Pusimo oheta tanuku.” ");
INSERT INTO nxl_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Oyo Ruben iasau osi amai iahata, “Arui Benyamin osiku ee, ama. Mka ununi roriki osia. Munata ununi roriki osia tewa mo, asaka ahunu we hehuka hanaiya uaso.” ");
INSERT INTO nxl_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Iahata, “Au upeneku asi! Benyamin mo, pene ororiki. Kakai imatai nea. Nesie ia ruai sahoro wain ikataku. Pene rotu-tu isupu siraka sui arena tinai tihue. Au reini mo, ukore-koreku nea. We kasiana waron ounare reini mka raunaku umataku.” ");
INSERT INTO nxl_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Muaine pan otoe Kanaan tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Tau muaina waron Yusup nea kakau ororire on poe Mesir rei pusire nea. Oyo Yakup iasau osiso, iahata, “We hehuka. Masi oeu poe Mesir honu na ohane re gandum umau osita honu.” ");
INSERT INTO nxl_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ne Yehuda iasau osi amai, iahata, “Ama. Ia mainae poe otoe Mesir iasau osima, iahata, ‘Ainati. Munata orori moa wani mai osiku tewa mo, pene oeu mai tanuku nea.’ ");
INSERT INTO nxl_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Reiso munata arui mania wani na ikatama, mka aeuma poe, ahane gandum. ");
INSERT INTO nxl_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ne munata arui mania wani na ikatama tewa mo, ami apenema aeu. Tau sae? Ia mainae rei iasau, munata mania wani ikatama tewa, pene aeuma poe tanui nea.” ");
INSERT INTO nxl_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Iahata, “Nanie oasau osi ia onate rei ata moa wani muie isa wain ikataku, nanie taa hae? Nanie ouna anoku ererau, nanie taa hae?” ");
INSERT INTO nxl_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Oahata, “Ama. Ia onate rei iasei tanuma ia-ia rerihoni ami na mania enau. Iasei, ‘Moa ama iamahaiki asi? Moa wani muie isa waimo asi?’ Asima runa wani iasei tanuma man. Sapan na ami anei ata ia mka iaisosima arori mania wani?” ");
INSERT INTO nxl_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Reiso Yehuda iasau osi amai, iahata, “Ama. Arui ia ikine rei ipusu na masi aeuma on sini mkane. Aeuma on sini tewa, mka pusita imata muaine. ");
INSERT INTO nxl_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Au sahoro usakai. Munata ununi roriki osia tewa mo, au sahoro uhana rosa rerihonia rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Sinana ipene mo, kani aeu nai ua nea.” ");
INSERT INTO nxl_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Iahata, “Munata san rei, mai orori sae waron iaka mai otoe reini pan mo karuni anoa. Ororire na oatoa ia mainae tau otoe Mesir rei. Orori hau rihua, kilalanta, ai unta, kamana, kahea pukuna, runa iana umau. ");
INSERT INTO nxl_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Runa orori kepen waron osupure pan mo karuni anoa rai. Orori kepen rai runa kepen umau honu na ohane gandum honu. Hitio sio oaiinu sana kepen pan karuni anoa. ");
INSERT INTO nxl_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Orori moa wani reini na oeu on sini. Oeu poe ia onate rei.” ");
INSERT INTO nxl_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Oyo Yakup iainisi san rei, “Upuku Anahatana. Ano mo, me kawasa mainae renesi pusire. Masi auna ia mainae tau otoe Mesir rei anoi runa we hehuka reini. Masi auna ia mainae rei na ihoka Simeon na onuni roriki runa Benyamin uaso. Ne munata au reini, we hehuka nanie tihoniso arihoniku, kani uasau sapan?” ");
INSERT INTO nxl_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Reiso Yusup nea kakau orori atoana rai. Atoa hau rihua, kilalanta, iana rai. Orori kepen waron osupure pan karuni anoa rai. Orori kepen umau honu na ohane gandum honu. Oyo oeu poe otoe Mesir okata Benyamin. Hoka poe oyo oooso mai Yusup uai anoe. ");
INSERT INTO nxl_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Taa Yusup inoo Benyamin runa nea kakau oyo iasau osi ne makahaie wain ia mainae tau ne numa. Iahata, “Rori sio reini mai we numa. Ahutu makapana isa na nana muaine. Sio reini mka-mka oai ranie katopu runaku.” ");
INSERT INTO nxl_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ia makahaie rei iuna sae wani Yusup iaisosiki. Oyo irori Yusup nea kakau runa wanin rei pan Yusup ne numa. ");
INSERT INTO nxl_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Iroriso pan Yusup ne numa, ne sio okaitau. Reiso oasau pan anoo, “Sio ororita mai reini, noso kepen waron ita inuni rorire pan karuni anoa waron mataanoe ihokata mai ihane gandum, tea? Nanie osotata samatoro onana re keledaiu oyo ounata tau no manianeu?” ");
INSERT INTO nxl_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Reiso ohoka haineke Yusup ne numa nene mitanunue oyo oasau osi ia makahaie rei, ");
INSERT INTO nxl_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Upu. Ahokama mai taue isa nea ahane muaine. ");
INSERT INTO nxl_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Ne anunima oyo ahokama pan arena tinai tihue pannuhu mono nea reiso nanie anekema. Ahuka mania karuni rai anoo kepen pusire uture waron asenu gandum rai waropa karuni anoa. Kepeni pan karuni anoa rai pusire pannuhu. Aanei tewa ia seia sahoro inusure pan karuni anoa rai. Ne ahokama reini nanie aunire osia. Aunire runa arori kepen umau oi nanie ahane gandum honu.” ");
INSERT INTO nxl_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Iahata, “Iake. Pene okaitau. Pene anomo rauponu. Anahatana wani moa ama runa omi oainisi oainaa runai kani inusu kepen rai pan mo karuni anoa. Ne uatarima kepen waron osenu gandum tanure nea.” Oyo ohoka Simeon osiso. ");
INSERT INTO nxl_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ohokai osiso oyo okatai mai numa anoe. Irui tihu osiso na osohu aio atua. Irui muaine osiso na opana no keledaiu. ");
INSERT INTO nxl_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Taa san rei oyo oseka tau no atoana osi Yusup. Oseka tanure na oruire osi Yusup. Mka ihokai tau ranie katopu. Tau sae? Sio osima osiso ata mka iai ikataso. ");
INSERT INTO nxl_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Taa Yusup ihokai mai numa, oyo nea kakau orui no atoana rai osiki. Oruire ohahue tanui. ");
INSERT INTO nxl_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Oyo Yusup iasei tanso. Iahata, “Omi sapan? Naone oruni osiku rerihoni moa ama wain ikore-korei nea rei. Sapan runa moa ama rei? Waipan iake?” ");
INSERT INTO nxl_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Oahata, “Upu. Me manorine, mania ama waipa iake.” Ita ohahue honu nanie oamuirai. ");
INSERT INTO nxl_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Taa Yusup inoo wanin, Benyamin, iahata, “Moa wani muie reini si? Ia wain oasau runai osiku reisi? Anaku. Uainisi na Anahatana irui iake osia.” ");
INSERT INTO nxl_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Oyo Yusup anoi runa wanin. Iahana anoi kasiane nanie irani. Reiso ihoka sansana iarihoni nea kakau runa wanin rei oyo inusui pan kakaranae anoe na irani. ");
INSERT INTO nxl_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Irani pusi oyo iauneu uai anoe oyo ihokai honu. Iapamese anoi na pene irani. Oyo iaisosiso onata muaina. ");
INSERT INTO nxl_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yusup iaiki tau ruai ne meya isa. Nea kakau runa wanin oaiso tau meya tamene isa oi. Sio Mesir wasomo rei oaiso tau meya tamene isa oi. Tau sae? Sio Mesir oai okata sio Ibrani mo, monne. Omasikikiso. ");
INSERT INTO nxl_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yusup ne meya runa nea kakau runa wanin no meya ramanane umau. Nea kakau runa wanin orue pusu no musum on ia iki manonete rotu ia muie. Taa onoo san rei, oyo oasumata umau, osira. Oasei tau umau oahata, “Ira oe. Sapan na ianei ia seia sahoro ia manaonete, ia seia sahoro ia autihue, ia seia sahoro ia muie?” ");
INSERT INTO nxl_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Orui muaine osiso arihoni Yusup ne meya. Nea kakau osupu no pahakian osa man. Ne Benyamin isupu ne pahakian nima. Oyo pusiso oai okata Yusup rotu-tu tiao pokona. ");
INSERT INTO nxl_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Oyo Yusup iaisosi ne ia mamsaka numa rei iahata, “Aiinu sio reini no karuni tau gandum rotu-tu taua. (Manei, nooi sani ana.) Aiinure rotu-tu haineke orori kuare tewa nea. Aiinu sana osa-osa no kepen rai pan no karuni anoa rai roe gandum hahae. ");
INSERT INTO nxl_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Anusu we koinanae rei oi pan ia muie rei ne karuni anoe. We koinanae wani marainie rei. Wani sio onanai rerihoni perak. Anusui erekata ne kepen waron gandum hunonie.” Ia mamsaka numa rei iuna sani sae wani Yusup iaisosiki. ");
INSERT INTO nxl_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Nene hanu omnano tun-tunne Yusup nea kakau runa wanin oeu oarihoniki nanie onunso pan noa ama pan Kanaan runa no keledaiu. (Keledai, nooi sani naitanane ne ikine.) ");
INSERT INTO nxl_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Matoro ohoka oarihoni kota rei hainau tewasi oimo Yusup iaisosi ne ia mamsaka numa rei iahata, “Eu rapu apusu sio rei. Munata asupuso nea, asau osiso ahata ita iuna iake osiso, ne sio nanie ouna kahatene tanuta taa hae? ");
INSERT INTO nxl_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Nanie okimanaka we koinanae tau sae? Koinanae rei mo, upake tau uninu runa una nau tanui. Sio ouna kahatene mainae!” ");
INSERT INTO nxl_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Reiso ia mamsaka numa rei ieu ipususo rotu-tu isupuso. Isupuso oyo iasau iahata, “Auna iake osimo, ne omi nanie ouna kahatene tanuma san rei, nanie taa hae? Nanie okimanaka upuku ne koinanae, nanie taa hae? Koinanae rei mo ipake tau ininu runa iuna nau tanui. Omi ouna kahatene mainae san rei, nanie taa hae?” ");
INSERT INTO nxl_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Oahata, “Asau runa me sae reini? Ami anei koinanae rei tewa. Ananai tewa. ");
INSERT INTO nxl_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ruam anei ata kepen waron asupure pan mani karuni anoa roe gandum hahaya rai iae, anuni on pan Kanaan arorire osia nea rei, tea? Reiso akimanaka perak te hunahane te poe ia mainae ne numa rei tewa. ");
INSERT INTO nxl_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Mania neta. Munata koinanae rei asupui arihoni ami reini ia isa masike apasanai rotu-tu imatai runa ami mka auna manianeu osia.” ");
INSERT INTO nxl_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Iahata, “Iake. Ne hasae ia wain koinanae rei usupui noi tanui, mka ia sahoro iuna we maniane. Omi umau mka onunimo.” ");
INSERT INTO nxl_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Reiso mata huni tewa oyo sana osa-osa irati ne karuni oyo ihukai. ");
INSERT INTO nxl_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Oyo ia mamsaka numa rei iarinii sana osa-osa ne karuni arihoni on ia manaonete ne karuni rotu-tu ia muie ne karuni, oyo sira tau isupu koinanae rei. ");
INSERT INTO nxl_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Anoo rarau rotu-tu okiha no apia noi no patana. Oyo oapusaa no gandum rai roe keledai totua unia. Oapusaare oyo onunso poe kota honu. ");
INSERT INTO nxl_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ohokaso poe, Yusup waipo numa asi. Ohoka poe oyo ohahue mai tanui. ");
INSERT INTO nxl_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Oyo Yusup iasei, “Sae wani ounai reini? Oanei tewa ata ia isa sani au mka iuna nau na ianei ia seia sahoro inana koinanae rei?” ");
INSERT INTO nxl_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yehuda iahata, “Upu. Ami mka asau mani sou sae osia? Sapan na anamana auni runa ruama. Anahatana wain iapasanama tau mani rosau waron naone. Muie reini pusima auna maniane tanua. Pusima runa ia wain koinanae supui pan ne karuni anoe rei.” ");
INSERT INTO nxl_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Iahata, “Tewa. Upeneku. Hasae ia wain supu koinanae poe ne karuni anoe rei, sahoro iuna maniane tanuku. Omi umau onunimo pan moa ama.” ");
INSERT INTO nxl_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yehuda ihitio ieu haineke Yusup iahata, “Upuku nanie uanamana mkane ee. Pene akapuku tanuku. Upuku, ano mo, ano sani ia ona aia Mesir ruai. ");
INSERT INTO nxl_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Naone ano asei tanuma, ahata, ‘Omi moa ama moa wani wasomo asi?’ ");
INSERT INTO nxl_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ami on poe asau ahata, ‘Mania ama waipa ikore-korei nea. Mania wani muie rei iamrai mo, mania ama ikore-korei nea. Ia ikine rei kakai uaso orue tiake osa, imatai nea. Reiso muie reini mo, nesie ia ruai. Reiso mania ama anoi runai nai osa. ");
INSERT INTO nxl_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ano aisosima aroriki mai tanua nanie anooi.’ ");
INSERT INTO nxl_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ne ami on poe asau ahata, ‘Ia ikine rei mka ieu iarihoni mania ama tewa. Ieu iarihoniki mo, mka mania ama imatai.’ ");
INSERT INTO nxl_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ita ano on poe asau honu, ‘Munata orori mo wani muie tewa, pene ohoka mai tanuku nea.’ ");
INSERT INTO nxl_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Reiso ami anunima pan mania ama oyo asau runa me anamanaya rai. ");
INSERT INTO nxl_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ita mania ama iaisosima aeu mai tau ahane muaina honu. ");
INSERT INTO nxl_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ne ami asau ahata, ‘Ami mka aeu poe rei tewa. Tau sae? Munata mania wani ipusu tewa, mka anoo ia mainae rei uai anoi tewa. Mka aeu sani mania wani ieu oi oo.’ ");
INSERT INTO nxl_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Oyo mania ama on poe iasau, iahata, ‘Omi oanei ata sahaku, Rahel, hasae ne hehuka sio ua man. ");
INSERT INTO nxl_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ia iki manaonete iarihoniku nea. Kani binatang seae ereaiki nea. Tau sae? Rotu-tu reini nooi tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Munata onana ia iki muie reini iarihoniku honu na sae isa eremunai, we kasiana waron ounare tanuku reini, mka raunaku tau umataku. Tau sae? Ukore-koreku nea.’ ");
INSERT INTO nxl_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Reiso upuku munata anunima pan mania ama akata mania wani tewa mo, mka mania ama imatai. Munata ia ikine rei imatai mka mania ama imatai oi. Tau sae? Ami auna ne kasiane reiso mka imatai. ");
INSERT INTO nxl_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Utotoe osi amaku nea. Munata ununi rori ia ikine reini tewa, mo uhana rosa rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Reiso uainisi arihonia na au sahoro una maniane tanua ukati waniku reini, ne waniku reini inuni ikata nea kakau. ");
INSERT INTO nxl_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Sapan na ununiku pan amaku, waniku inuni ikataku tewa? Upeneku asi. Upeneku unoo amaku anoi repunoko ruai.” ");
INSERT INTO nxl_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yusup iapamese kua anoi tewa nea mai ne makahaia. Reiso iaisosiso oeu arihoniki na nanie isima runa ruai osi nea kakau runa wanin. ");
INSERT INTO nxl_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Taa ne makahaia ohokaso arihoniki oyo irani kua-kuati. Rotu-tu sio Mesir pan manahane oatinu oi. Irani kua-kuati rotu-tu sio pan ia ona aia ne numa oatinu. ");
INSERT INTO nxl_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yusup iasau osi nea kakau runa wanin san rei. Iahata, “Au reini mo, au Yusup. Rea ama iamahaiki asi?” Nea kakau onoo san rei oyo okaitau hunu ruao nai osa. Okaitau reiso osana tewa. ");
INSERT INTO nxl_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yusup on poe iasau honu, “Masi oeu mai.” Oyo oeuso hainekei. Euso hainekei oyo iahata, “Au mo, Yusup wani omi oaheniku mai otoe Mesir. ");
INSERT INTO nxl_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Pene okaitau te, oapunoko ruamo tau oaheniku. Areimo Anahatana ruai iroriku mai rei uanaone arihoni omi pusimo na uapuhai sio panesi. ");
INSERT INTO nxl_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Muie reini mato musum ua muaina tewa. Nesie musum nima asi sio mka orahu runa oapahia nisi tewa. ");
INSERT INTO nxl_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Anahatana sahoro iroriku uanaone arihoni omi pusimo na uapuhaimo runa mo mansiau umau na pene omata muaine na sio tuniai reini osira. ");
INSERT INTO nxl_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Anahatana sahoro iaisosiku mai rei ne omi tewa. Ia sahoro iuna au tau ia ona aia hanai wanane mai Mesir reini. Ia sahoro irui we kawasa tau ne numa reini runa Mesir pusiki. ");
INSERT INTO nxl_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Reiso onuni rapu pan amari na oasau osiki, oahata, ‘Anam Yusup iasau san rei, “Anahatana iunaku we kawasa tau Mesir pusiki. Hoka rapu mai tanuku. ");
INSERT INTO nxl_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ama, mka aruea mai otoe Gosyen haineke au. Ahokaya mai akata mea hehuka, mea momou, me rompau, me une-uneu, me koropou runa me apia pusire. ");
INSERT INTO nxl_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Munata ano wani Gosyen mka uapiaraya. Nesie musum nima muaina tewa. Reiso uapiaraya. Tewa mo, mka ano runa me hehuka, runa me makapanau omata muaine.” ");
INSERT INTO nxl_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Wea kakau. Omi ruamo onoo au reini, tea? Runa waniku Benyamin ruam wani atinu we anamanaya raini. Titue-tue au mo, au Yusup. ");
INSERT INTO nxl_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Asau osi amari ahata we kawasa mainae mai Mesir reini. Oruni osiki runa sae wani onooi mai rei. Na roriki mai on sini.’” ");
INSERT INTO nxl_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Taa ianamana pusi oyo iatipuni wanin Benyamin oyo irani. Benyamin iae irani oi. Irani iatipuni kakai. ");
INSERT INTO nxl_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Iatipuni Benyamin pusi oyo wani irani asi, ieu iatipuni nea kakau pusiso runa imukiso. Taa san rei oyo oanamana osi umau. ");
INSERT INTO nxl_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Sio pan ia ona aia ne numa oatinu ata Yusup, nea kakau runa wanin ohokaso, reiso ia ona aia runa sio makahaia pusiso anoo mirika. ");
INSERT INTO nxl_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Reiso ia ona aia iasau osi Yusup, “Aisosi mea kakau runa wanim rei na oapatau no gandum tau no karuni na oapusaare roe keledai totu hahaya na onunso pan otoe Kanaan. ");
INSERT INTO nxl_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Onunso pan na on pan orori moa ama runa mo mansiau. Ororiso na oeuso mai rei. Mka urui tuamane wani iake mai otoe Mesir reini osiso. Na orueso mai tuamane rei, na atanane amrahuso iake na oamahaiso. ");
INSERT INTO nxl_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Aisosiso oi na orori karetau hua inasa on mai rei osi no pina hehuka wason sio ikina asi. Onana moa ama na ororiki mai oi. ");
INSERT INTO nxl_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Pene anomo runa mo apia waron oarihonire. Tau sae? Mka osupu iaka mai otoe Mesir reini. Sae waron iaka mai otoe Mesir reini mka osiso.” ");
INSERT INTO nxl_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Yakup ne hehuka ouna sae wani ia ona aia iaisosiso ounai rei. Yusup irui karetau sani sae wani ia ona aia iasau rei. Irui no wekau na oaire sui arena tinai tihue. ");
INSERT INTO nxl_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Irui no api honua hua osa-osa osiso. Ne irui Benyamin ne perak kilo tonu samatihue runa ne apia honua hua nima. ");
INSERT INTO nxl_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Iauwatu apia waron iaka mai Mesir osi amai. Iapusaare roe keledaiu hata hutusa honu. Ita iauwatu gandum, poroti, runa muai tamena roe keledai inaya hata hutusa nene totu hahaya. Nanie tau no wekau na oaire sui arena on pan Kanaan ereeu na poe Mesir. ");
INSERT INTO nxl_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Oyo iaisosi nea kakau runa wanin na oeuso oyo iaunauso, “Pene oatana runa umau sui arena tinai tihue.” ");
INSERT INTO nxl_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Oeu arihoni Mesir na onunso na pan Kanaan oyo osupu noa ama Yakup. ");
INSERT INTO nxl_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Hoka pan, oyo oasau, “Ama. Yusup waipo iamahaiki poe Mesir asi maa! Ia mo, ia iuna mainae ne kawasa tau otoe Mesir!” Iatinu anamanaya rai noo sani iparisaa tewa. ");
INSERT INTO nxl_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ne oruni sae waron Yusup iasau osiso runa oautuu runa karetau na sae waron Yusup iauwature osiki rei na nanie ororiki poe Mesir. Oruni mato isira. Iparisaa. ");
INSERT INTO nxl_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Iahata, “Titue si? Anaku Yusup iamahaiki asi. Mka ueu na uno-nooi on umata tewasi reini. Hasae rei sahoro uninai.” ");
INSERT INTO nxl_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yakup iautotu ne numa samatoro ieui ikata ne numa hutae. Ieu rotu-tu ihokai poe otoe Bersyeba oyo iainisi iainaa runa Anahatana. Anahatana wain amai Isak iainisi iainaa runai oi. Iainaa runai irehi makapana osiki. ");
INSERT INTO nxl_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Irehi makapana oyo nene pumono rei, Yakup inekei iamnii. Ineke iamnii Anahatana ianamana osiki san rei, “Yakup, Yakup.” Yakup on poe isana, “Oe, Upu. Upuku anamana roe. Au wani uatinu.” ");
INSERT INTO nxl_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Iahata, “Au Anahatana wain amam iainaa runaku. Pene akaitau. Ne aeua poe otoe Mesir. Au mka una mea momou mea upu sio panesi poe Mesir. ");
INSERT INTO nxl_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mka ukataya rotu-tu ahokaya poe Mesir. Mka ununi rori mea momou mea upu mai otoe reini honu. Mka amataya mo, Yusup iruei mai nusum na irohi matam usena.” ");
INSERT INTO nxl_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Reiso nene hanu omnanoe san rei oyo Yakup ieui iarihoni Bersyeba. Ne hehuka oapusaai roe kareta runa no pina hehuka. Pusiso osaa karetau waron ia ona aia Mesir iauwature osiso rei. ");
INSERT INTO nxl_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Orori makapanau runa no apia waron osupure pan Kanaan rei oi. Oyo ororire poe Mesir. Yakup on pan ieu ikata ne numa matae pusiki. ");
INSERT INTO nxl_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Areimo ne hehuka, nea momou, nea upu. ");
INSERT INTO nxl_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","15","Areini mo Yakup ne hehuka wason noa ina tau sahai Lea. Pusiso oeuso okata Yakup poe otoe Mesir. Anai hanaie manaonete nanai Ruben. Ruben ne hehuka hanaia wason nanao: Henokh, Palu, Hesron, runa Karmi. Simeon ne hehuka hanaia wason nanao: Yemuel, Yamin, Ohad, Yakhin, Sohar, runa Saul. (Saul inai mo, Yakup sahai arihoni otoe Kanaan.) Lewi ne hehuka hanaia wason nanao: Gerson, Kehat, runa Merari. Yehuda ne hehuka hanaia wason nanao: Er, Onan, Syela, Peres, runa Serah. (Ne Er runa Onan omataso pan Kanaan nea, on amai ieui poe Mesir tewasi.) Peres ne hehuka hanaia wason nanao: Hesron runa Hamul. Isakhar ne hehuka hanaia wason nanao: Tola, Pua, Ayub, runa Simron. Sebulon ne hehuka hanaia wason nanao: Sered, Elon, runa Yahleel. Yakup ne hehuka reini mo oamraiso pan otoe Mesopotamia runa noa hota, Dina. Pusiso sio hutu tonu rahana tonu. ");
INSERT INTO nxl_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","18","Areini mo Yakup ne hehuka hanaia wason noa ina tau Silpa. Silpa mo ia wain iuna ia makahaie tau Laban anai pina Lea. Laban iruiki osi anai pina, Lea. Gad ne hehuka hanaia wason nanao: Sifyon, Hagi, Syuni, Esbon, Eri, Arodi, runa Areli. Asyer ne hehuka hanaia wason nanao: Yimna, Yiswa, Yiswi, runa Beria. Runa noa hota Serah. Beria ne hehuka hanaia wason nanao: Heber runa Malkiel. Sio reini mo, sio hutusa rahana nome. ");
INSERT INTO nxl_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","22","Areini mo Yakup ne hehuka hanaia wason noa ina tau sahai Rahel. Yusup ne hehuka hanaia wason nanao: Manasye runa Efraim. Uaso oamrai poe Mesir. Noa ina tau Asnat, Potifera anai pina. Potifera wain isaka ianori runa sio Mesir no anahatana ranie wani titue tewa poe Heliopolis. Benyamin ne hehuka hanaia wason nanao: Bela, Bekher, Asybel, Gera, Naaman, Ehi, Ros, Mupim, Hupim, runa Ared. Sio reini mo, sio hutusa rahana ate. ");
INSERT INTO nxl_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","25","Areini mo Yakup ne hehuka hanaia wason noa ina tau Bilha. Bilha mo ia wain iuna ia makahaie tau Laban anai pina Rahel. Laban iruiki osi anai pina Rahel. Dan ne hehuke hanaie wain nanai: Husim. Naftali ne hehuka hanaia wason nanao: Yahseel, Guni, Yeser, runa Syilem. Sio reini mo, sio itu. ");
INSERT INTO nxl_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yakup nea hehuka, nea momou, nea upu wason oeuso poe Mesir rei, sio hutu nome rahana nome. Ne mananua reken tanso tewa. ");
INSERT INTO nxl_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yusup runa ne hehuka ua wason oamrai poe Mesir runa Yakup ne hehuka wason oeu okatai poe Mesir, pusiso sio hutu itu. ");
INSERT INTO nxl_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakup sio ohokaso mai otoe Gosyen nea. Reiso iaisosi Yehuda ieu ianaonei nanie ioi Yusup na ieui mai amai mai Gosyen. ");
INSERT INTO nxl_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusup isaa kareta wani naitanane erenesai na ieui mai amai. Tau osupu umau oyo Yusup iatipuni amai oyo irani rotu-tu potuina. ");
INSERT INTO nxl_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Yakup iasau osi Yusup iahata, “Masike umataku iae iake, hete nanie unooa amahaia asi rei.” ");
INSERT INTO nxl_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Oyo Yusup on poe iasau osi nea kakau runa wanin muie runa no pina hehuka. Iahata, “Au nanie ueuku poe na usima osi ia ona aia runa amaku, wea kakau runa waniku, runa no pina hehuka wason ohokaso on pan otoe Kanaan nea. ");
INSERT INTO nxl_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Mka uasau ata omi mo, omi mamsaka rompau runa koropou. Makapanau rai mo waron orori pusire mai rei nea runa mo apia pusire. ");
INSERT INTO nxl_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Munata ia ona aia ioimo na iasei tanumo, iahata, ‘Mo pakarian sae?’ ");
INSERT INTO nxl_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Oahata, ‘Ami mo asaka makapanau on ami ikina asi. Sani mania upu oi.’ Oasau san rei mo, mka iaisosimo oruemo mai otoe Gosyen reini.” Yusup iasau san rei tau sio Mesir oahana omasikiki tau sio mamsaka rompau. ");
INSERT INTO nxl_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Taa san rei oyo Yusup iautunu nea kakau nima nanie ia ona aia iationaso. Iahata, “Upu. Amaku runa wea kakau wason ohokaso on pan otoe Kanaan, orori no une-uneu, no rompau, no koropou runa no apia pusire. Wasoni otoe Gosyen nea.” Oyo iatuhete nea kakau osi ia ona aia. ");
INSERT INTO nxl_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ia ona aia iasei tanso, “Omi mo pakarian sae?” Oahata, “Upu. Ami mo, ami mamsaka rompau sani mania upu, mania momou. ");
INSERT INTO nxl_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ahokama mai otoe Mesir reini tau pan Kanaan muaina tewa. Ihu titie erehunu pusi monota rotu-tu une-uneu runa rompau rasupu nene muaina tewa nea. Ami ainisi arihonia na aruema pan Gosyen.” ");
INSERT INTO nxl_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Iahata, “Yusup. Amam runa mea kakau wason rei nea. ");
INSERT INTO nxl_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Aroma pusu ruam otoe sae wani nanie orueso tanui. Rui otoe wani iake mai Mesir reini. Otoe Gosyen iae iake. Runa rui we makapanau osi ia seia wain mka isaka iake.” ");
INSERT INTO nxl_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yusup iatuhete amai osi ia ona aia oi. Oyo Yakup iainisi na Anahatana irui iake osi ia ona aia ");
INSERT INTO nxl_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","samatoro ia ona aia iasei tanui, “Ama. Me musum ina nea?” ");
INSERT INTO nxl_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Iahata, “Au we musum utun hutu tonu. Ueu uhori suru poe suru pan rotu-tu reini. Au sinsaraku on au honue rotu-tu reini. Ne uhori rotu-tu potuina sani wea upu wea momou tewa.” ");
INSERT INTO nxl_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Taa san rei Yakup iainisi na Anahatana irui iake osi ia ona aia oyo iauhaai na nanie inuniki. ");
INSERT INTO nxl_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yusup iakahai amai runa nea kakau orueso poe Mesir. Irui otoe rei osi ruao mai haineke Gosyen. Gosyen, tau muie sio oiki tau Ramses. Gosyen, areimo otoe wani iake mai otoe Mesir. Iruiki sani ia ona aia iaisosiki ");
INSERT INTO nxl_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","oyo Yusup iakapena muaina osi amai, nea kakau, runa nea enau pusiso. Irui muaina pusu sio ina noi numa anoe rei. ");
INSERT INTO nxl_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Mai otoe rei muaina tewa nai osa rotu-tu sui supan-supan oai tewa nea. Sio Mesir runa sio Kanaan omakaneaso reiso omankae hunu ruao, reiso okua tewa nea. ");
INSERT INTO nxl_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yusup iamanou kepen pusire waron sio Mesir runa sio Kanaan ohane gandum tanure. (Manei nooi sani ana.) Iamanou kepen rai poe ia ona aia ne numa. ");
INSERT INTO nxl_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Kepeni poe Mesir runa pan Kanaan pusire osi Yusup nea. Oyo sio Mesir ohokaso mai tanui oahata, “Upu. Masi arui mania muaina umau mai. Pene atapima na amatama ee. Mania kepen pusire nea.” ");
INSERT INTO nxl_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Iahata, “Munata mo kepen pusire nea, orui mo makapanau na urui muaina osimo.” ");
INSERT INTO nxl_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Oyo orui no makapanau osiki. Oruire osiki oyo irui muaine osiso na ikati no naitanana, no rompau, no une-uneu, no koropou runa no keledaiu waron noore sani naitanane ne ikine. Tau musum rei Yusup irui muaina osiso. Ohane tau no makapanau. ");
INSERT INTO nxl_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Tau musum isa honu ohokaso mai tanui ita oasau, “Upu. Ami nanie asau osia ia-ia. Mania kepen pusire nea. Mani makapanau waron osia nea. Mani sae isa tewa nea wani mka arui osia. Hasae mka auna manianeu tanua runa arui mani tuamane osia. ");
INSERT INTO nxl_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Reiso pene atapima rotu-tu amatama. Pene atapi mani nisiu rotu-tu rakaimeneso. Ananama tau me manianeu. Ahane mani tuamana tau gandum. Ami runa mani tuamane osi ia ona aia. Rui mani gandum runa gandum kania umau na ahurarare noi mani nisiu. Ruire na pene amatama muaine.” ");
INSERT INTO nxl_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Reiso Yusup ihane tuamane pusiki poe Mesir osi ia ona aia. Sio poe Mesir oahen no tuamana pusire osiki tau musum muaina tewa. Omata muaine. Reiso no tuamana rai pusire osi ia ona aia ruai. ");
INSERT INTO nxl_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Sio Mesir pusiso ouna manianeu tau Yusup. ");
INSERT INTO nxl_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ne hasae sio wason osaka oanori runa sio Mesir no anahatanau waron titue tewa. Sio wason osaka rei, no tuamane sahoro oahenre tewa. Tau sae? Sio osupu muaine rerihoni ia ona aia. Reiso oahen no tuamane tewa. ");
INSERT INTO nxl_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yusup iasau osi sio Mesir san rei, “Masi onoo, mo tuamana, uhanere osi ia ona aia nea. Omi ruamo, unanamo tau manianeu osi ia ona aia nea. Onana gandum kania raini na oahurarare noi mo nisiu. ");
INSERT INTO nxl_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Munata gandum mtuaya nea, mka osama mo gandum rai tau pahakian nima samatoro orui pahakian osa osi ia ona aia. Nesia rai osi ruamo orahure na oaire. Osi ruamo runa mo hehuka.” ");
INSERT INTO nxl_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Oahata, “Upu. Ano apuhaima nea, reiso ami ainisi iake rerihonia. Aamanaku auna manianeu osi ia ona aia.” ");
INSERT INTO nxl_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Reiso Yusup iasau runa maunaune isa poe Mesir. Maunaune rei, areimo wani tau muie reini sio osama no atuhu tau pahakian nima-nima na orui pahakian osa osi ia ona aia. Ne hasae atuhu arihoni sio wason osaka oanori runa sio Mesir no anahatanau waron titue tewa sahoro orui atuhu tewa. Maunaune rei ereeu rotu-tu reini. ");
INSERT INTO nxl_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Reiso sio Israel orueso poe Mesir. Orueso poe otoe wani nanae Gosyen. Sio okikasi oasinena poe Mesir. ");
INSERT INTO nxl_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakup iruei poe Mesir ne musum hutusa rahana itu rotu-tu ne musum utun hutu ate rahana itu. ");
INSERT INTO nxl_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Haineke nanie imatai nea reiso ioi Yusup, anai hanaie rei nanie iasau osiki. Iahata, “Aunutu hanam atue poe karaku na asopa ata mka umataku mo, mka aunutuku pan hatu nohue mai Mesir tewa. ");
INSERT INTO nxl_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Unina na aunutuku pan hatu nohue wani sio oaunutu wea amau wea momou tanui. Arori we tihane hatae arihoni otoe reini na aunutuku pan hatu nohue rei.” Iahata, “Ama. Au mka una sae wani asaui rei.” ");
INSERT INTO nxl_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Iahata, “Asopa ata mka aunai.” Reiso Yusup isopa oyo Yakup iainisi iainaa runa Anahatana roe naniai. ");
INSERT INTO nxl_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Taue isa sio umau oeuso poe Yusup osima oahata, “Yusup. Amam ikupui mtinte.” Reiso Yusup ieu ikata ne hehuka hanaia uaso wason nanao Manasye runa Efraim. ");
INSERT INTO nxl_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Hoka poe oyo sio osima oahata, “Ama. Anam Yusup wain ihokai nea.” Iatinu san rei oyo iamkona runa ruai nanie ihanui. Ihanui oyo iruei roe naniai. ");
INSERT INTO nxl_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Iruei oyo iasau osi Yusup, iahata, “Anahatana wain ne kawasa mainae erenesi pusire iatuhete ruai osiku pan nia Lus pan otoe Kanaan. Iatuhete ruai osiku samatoro irui iake osiku. ");
INSERT INTO nxl_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Iasau osiku san rei, ‘Au mka una me hehuka tau ipana panesi. Mka ipana rai rakikasi rasinena. Mka urui otoe Kanaan reini osi me hehuka osi ruao rotu-tu ria supan.’ ");
INSERT INTO nxl_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Reiso me hehuka ua wason oamrai mai otoe Mesir reini on uhokaku mai Mesir tewasi, mka unanaso tau au ruaku we hehuka. Areimo unoo me hehuka Efraim runa Manasye sani ruaku we hehuka, Ruben runa Simeon. ");
INSERT INTO nxl_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Munata saham isusu honu, me hehuka rei mka unooso sani we hehuka tewa. Ne ano ruam me hehuka. Mka onana rusun arihoni Efraim runa Manasye. ");
INSERT INTO nxl_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Au una san rei tau inam Rahel. Ununiku on pan otoe Mesopotamia inam imatai pan otoe Kanaan, haineke nia Efrata. Reiso anoku repunokoi mainae. Ukaniki pan rei, paka arena nusue. Arena rei nanie ereeu napi poe Efrata.” (Muie reini Efrata nanae Betlehem.) ");
INSERT INTO nxl_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","10","Yakup inoo iake tewa nea. Tau sae? Ikore-korei nea. Matai kania haineke raputiso nea. Reiso inoo Yusup ne hehuka oyo iasei, “Seia ne hehuka reini?” Iahata, “Sio ikina reini au we hehuka wason Anahatana iruiso osiku mai Mesir reini.” Iahata, “Haineke me hehuka reino mai na uainisi na Anahatana irui iake osiso.” Yusup haineke ne hehuka rei osi amai oyo iatipuniso runa imukiso. ");
INSERT INTO nxl_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Oyo Yakup iasau osi Yusup, “Au uahata kani amataya nea reiso unooa tewa nea. Aikee muie reini Anahatana itapiku nanie unoo me hehuka.” ");
INSERT INTO nxl_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Oyo Yusup inana ne hehuka uaso arihoni amai karai oyo ruai ihahue mai amai uai anoe. ");
INSERT INTO nxl_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ihahue pusi oyo iakahuu ne hehuka uaso tau hanai atua na iroriso na ohaineke noa momo. Manasye, ia manaonete, mai momoi hanai atue wanane. Oo Efraim, ia muie rei, mai momoi hanai atue pante. ");
INSERT INTO nxl_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ne Yakup hanai atua rasupa neka umau. Hanai atue wanane iaunutui roe Efraim ia muie unui. Hanai atue pante iaunutui roe Manasye ia manaonete unui. ");
INSERT INTO nxl_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Samatoro iainisi na Anahatana irui iake osi Yusup. Iainisi san rei, “Upuku Anahatana, ano sahoro momoku Abraham runa amaku Isak oamahaiso opusu me maunaune. Ano sahoro asakaku sani ia mamsaka rompau isaka ne rompau. Asakaku on au uamrai rotu-tu reini. ");
INSERT INTO nxl_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ano sahoro aisosi me maisosie on roe noiyaha na iakahaiku tau we susau pusire. Uainisi na arui iake osi we hehuka reini. Uainisi na sio pusiso oanei ata sio wason we hehuka, wason Isak nea momou, Abraham nea upu. Uainisi na aunaso no ipane rekikasi resinena.” ");
INSERT INTO nxl_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","18","Yusup inoo amai hanai atua rasupa neka umau san rei oyo iakahuu amai hanai atue wanane iasau, “Ama. Pene auna hanam atue wanane rei roe Epraim unui tau ia mo, ia muie. Ne una hanam atue wanane rei mai Manasye unui tau ia mo, ia manaonete.” Iakahuu hanai nanie inea amai hanai atue wanane rei arihoni Epraim unui nanie iunai mai Manasye unui. ");
INSERT INTO nxl_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ne amai ipenei. Iahata, “Anaku. Au uanei. Au uanei. Manasye mka ne kawasa mainae na ne ipane mka rekikasi resinena. Ne wanin mka ne kawasa mainae inesi ia. Na ne ipane iae, rekikasi resinena panesi erenesi ia.” ");
INSERT INTO nxl_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ita iainisi arihoni Anahatana honu na irui iake osi sio ikina ua rei tau ranie hatae rei sirinia. Iahata, “Upuku Anahatana. Uainisi na arui iake osi we hehuka reini tau me kawasa. Pani muie, mka sio Israel oainisi na arui iake osi ia isa, mka oainisi san rei, ‘Uainisi na auna ia reini sani Epraim runa Manasye.’” Reiso Yakup ihete Epraim nanai naone arihoni Manasye. ");
INSERT INTO nxl_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Oyo Yakup iasau osi Yusup iahata, “Ano anoo nea, nanie haineke umataku nea. Ne Anahatana mka iakahaimo na ohokamo arihoni otoe Mesir reini na oeumo pan moa upu moa momou no otoe. Areimo otoe Kanaan. ");
INSERT INTO nxl_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Urui nia Sikhem osi ano ruam. Uruiki osi mea kakau tewa. Sikhem wani uahita runai arihoni sio Amori.” ");
INSERT INTO nxl_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakup iaunau Yusup pusi oyo ioi ne hehuka hanaia pusiso utuso. Iahata, “Amanou pusimo mai nusuku reini. Mka uasau osimo pan muie reimo kaneita sapan runa moa hehuka, moa momou, moa upu. ");
INSERT INTO nxl_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Oamanoumo mai, we hehuka. Oatinu tau moa ama, au. ");
INSERT INTO nxl_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben ano mo, au anaku manaonete. Ano wani we nasi manaonete. Ano mo, ano manaonete reiso me muiran mainae. Me kawasa mainae. ");
INSERT INTO nxl_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ne apusu maunauna tewa. Apusu maunauna tewa reiso ano sani waene erenia mainae erepusu nahae rei tewa nea. Reiso ano mka sani ano manaonete tewa. Tau sae? Anekea runa sahaku isa. Ano apaputi naniaku. ");
INSERT INTO nxl_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon, Lewi omi ua mo, kaka wani. Uamo ohunu tau mo tunua. ");
INSERT INTO nxl_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Upeneku uamanouku ukatamo. Upeneku upusu tau mo mananoune. Tau ohunu tumata tau anomo rasaa okaumin oseha koropou nene una onate inamatane na ereeu iake tewa. ");
INSERT INTO nxl_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Masi omatamo runa mo sata rai wani ohunu panesi rei. Masi omatamo runa anomo rasaa mainae rai tau okaumin ounaso sinsaraso. Anahatana mka isama-samamo pusu sio Israel pusiso. Anahatana mka iuna wena-wenamo pusu sio ipana Israel. ");
INSERT INTO nxl_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yehuda, ano mka akua ahunu me nisau. Mea kakau, mea waniu mka oainaa runaya, mka ohahue mai tanua. ");
INSERT INTO nxl_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ano mo, ahunu samatoro anunia mai numa areimo sani singa honue erehunu samatoro erenuniki noi naniae. Singa erenuniki oyo erenusa ruae samatoro erenekei. Singa inae mo, sio pusiso okaitau oakaremai. Ano sani singa rei, ahunu oyo me nisau okaitaua. ");
INSERT INTO nxl_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Sio rerihoni ano me mansiau mka ouna aiau mea upu mka ouna aiau rotu-tu ria supan. Ouna aiau rotu-tu mea upu wain Anahatana ihitiki iuna aia. Iuna aia oyo sio niana oatinu tanui. ");
INSERT INTO nxl_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Omi mka mo iake runa umau reiso oahita tewa nea. Mo muaina panesi. Mo makapanau panesi, mo atuhu panesi. Mo anggur huaya panesi reiso mka okanihoo keledai anai tau ai anggur wani iake mainae. Mo muaina panesi, oninu sanauta panesi. Mo sae man panesi rotu-tu opapa apia tau tihu anggur. ");
INSERT INTO nxl_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Oninu tihu anggur reiso matamo kania msinaya. Oninu susu reiso nesimo putia. ");
INSERT INTO nxl_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulon, ano mo, mea upu mka orueso haineke nuae. Kapana mka ramamanuso nau nuae rei. Me tuamane rotu-tu haineke nia Sidon. ");
INSERT INTO nxl_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","15","Isakhar, ano mo, mka anei naniam na aranahaya iake, me tuamane iake. Reiso apakarian panesi na pene sio onanai arihonia. Apakarian panesi rotu-tu mea upu ouna manianeu na pene sio onanai arihonia. Apakarian panesi sani keledai wani remkona. Erepakarian panesi rotu-tu erenekei kua pakuna ua tihua. Pakuna waron sio oapataure tau apia panesi rei mtinta. ");
INSERT INTO nxl_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan, ano mo, mka asau ia seia ne manisate ia seia ne isanae. Ano mka asau tau ano mo ano numa upue tau ipane isa arihoni au. ");
INSERT INTO nxl_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ano asiraso na ahunu sani tekene mai arena nusue. Ano sani mnanate mai parisi nusue wani ererutu naitanane toue rotu-tu ia wain isaa naitanane rei iamnahui.” ");
INSERT INTO nxl_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Yakup iasau iahata, “Upuku. Au unapa-napa na ano apuheuma.” ");
INSERT INTO nxl_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gad, ano mo, mka sio kimanakana onana mo apia runa ohitamo. Ne ano mka aneiso runa anana no apia oi. ");
INSERT INTO nxl_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asyer ano mo, me muaina panesi, muai iaka-iaka. Na mka arui muai iaka-iaka osi sio ona aiau. ");
INSERT INTO nxl_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali, ano mo, ano runa mea upu mka osotamo tau manianeu tewa. Reiso ano sani maianane wani sio osotai tewa, maianane wani nene anaya marainia. ");
INSERT INTO nxl_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusup ano mo, mka mea upu panesi orueso sui supan-supan man. Areimo ano sani awane wasi wani nene huaya panesi. Areimo ano sani awane wasi wani ereruhu haineke waene hunae. Areimo ano sani awane wasi wani nene sakata rasapa rarohi kasunepene. ");
INSERT INTO nxl_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Mea kakau anoo rasaa tanua reiso ahenia. Areimo sani ia isa ikata henue na iana ia isa nanie ihunui. ");
INSERT INTO nxl_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ne ano akarihuru amahai. Me patane maka-makae. Areimo sani ia isa ikata henue ne ikananunu tewa. Ikata henue hanai atua makaya. Ano amahaia tau Anahatana wain uainisi uainaa runai isakaya. Anahatana mo, ne kawasa mainae erenesi pusire. Ano amahaia tau Anahatana isakamo sani ia mamsaka rompau isaka ne rompau. Anahatana iararou nohu, areimo sani hatu tinetae rerarou nohu. ");
INSERT INTO nxl_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ano amahaia tau Anahatana wain uainaa runai iakahaia. Ano amahaia tau ia wain ne kawasa mainae erenesi pusire irui iake osia. Irui iake sani uane on roe nante. Irui iake sani waene on poe tuamane anoe. Irui iake sani mo pinau osusu haha panesi. Irui iake sani mo makapanau nene anaya panesi. ");
INSERT INTO nxl_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Anahatana irui iake osiku erenesi iaka sani hunahana waron sio onanare arihoni tinetaya waron ramtuaso. Anahatana irui iake osiku erenesi iaka sani hatu itana nene hunonia mainaya waron sio onanare arihoni pupua waron on masuae. Anahatana inini ano arihoni mea kakau runa wanim pusiso na irui iaka rairo pusire osia. ");
INSERT INTO nxl_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin, ano mo anom eresaa sani asu manene. Tau omnanoe asu manene ereoto nene muaine oyo ereaiki. Nene neta isa erehokai oyo anoe eresaa. Tau pumono asu manene eresama-sama nene muaine osi nene anaya.” ");
INSERT INTO nxl_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Yakup ianamana san rei osi ne hehuka hanaia hutusa rahana ua rei pusu sapani na Anahatana mka irui iake osi sio ruao sana osa-osa runa noa upu. Iaunutu anoi rerihoni ne hehuka sana osa-osa pannuhu runa no atata. ");
INSERT INTO nxl_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Yakup isima runa ne hehuka pusi oyo iasau runa ne hako iahata, “Mka-mkane umataku reiso saka oaunutuku pan hatu nohue anoe. Hatu nohue wani Abraham ihane arihoni Efron, ia arihoni sio Het. Ihanei runa nene tuamane otoe rei. ");
INSERT INTO nxl_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Hatu nohue rei wapan nia Makhpela. Wapan nia Mamre hae ranie eresaa pan otoe Kanaan. Ihane hatu nohue rei nanie tau iau-aunutu sio matana. ");
INSERT INTO nxl_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Pani hatu nohue rei oaunutu Abraham runa Sara. Ita oaunutu Isak runa Ribka. Ita au ruaku uaunutu Lea. ");
INSERT INTO nxl_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Aunutu au pan hatu nohue rei oi.” ");
INSERT INTO nxl_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Taa iasau pusi ne hako rei osi ne hehuka oyo iapusaa ain atua roe naniai samatoro inekei. Inekei oyo imatai. ");
INSERT INTO nxl_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Imatai oyo Yusup ipesi ruai iatipuni amai irani imuki amai uai anoe. ");
INSERT INTO nxl_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Irani pusi oyo iaisosi sio wason oasamau sio matana tau upati wani ereuna sio okopu tewa. Reiso iaisosiso ouna osi amai. ");
INSERT INTO nxl_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Osaka ososa-sosa sio matana tau upati rei rotu-tu onona hutu ate reiso sio ososa-sosa Yakup ne patane rotu-tu onona hutu ate. Sio Mesir orani anoo rapunoko Yakup rotu-tu onona hutu itu. ");
INSERT INTO nxl_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Sio anoo rapunoko Yakup pusi oyo Yusup iasau osi ia ona aia ne makahaia, iahata, “Oasau na we anamanae reini osi re ia ona aia, ");
INSERT INTO nxl_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","oahata, ‘Tau amaku nanie haineke imatai rei, iaunutu hako osiku. Iahata, “Munata umataku mo, saka oaunutuku pan hatu nohue wani ukaniki matane nea. Hatu nohue rei wapan otoe Kanaan.” Reiso tapiku na uaunutu amaku ee. Uaunutu amaku pusi samatoro on pan ununiku mai.’” ");
INSERT INTO nxl_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Osima osi ia ona aia oyo iahata, “Iake. Eu na aunutu amam sani ne hako osia rei.” ");
INSERT INTO nxl_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Reiso Yusup ieu iaunutu amai. Ieu ikata sio panesi. Ikata ia ona aia ne makahaia, sio onata tau ne numa, runa sio onata tau otoe Mesir. ");
INSERT INTO nxl_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Sio wason orueso okata Yusup, runa nea kakau na wanin, runa sio wason orueso mai amai ne numa oeu okatai oi. Hasae sio wason orueso mo, sio ikina runa no makapanau oarihonire mai otoe Gosyen. ");
INSERT INTO nxl_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Sio wason osaa kareta wani naitanane ereroriki iae oeu oi. Reiso sio panesi oeu. ");
INSERT INTO nxl_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Taa ohokaso pan otoe wani opapa gandum. (Manei, nooi sani ana.) Otoe rei nanae Goren-Haatad, pan Wae Yordan on pan hae. Ohoka pan oyo anoo rapunoko ruao reiso orani nio mainaya. Reiso Yusup ipusu monne iatamisi amai rotu-tu onona itu. ");
INSERT INTO nxl_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Taa sio poe otoe Kanaan onoo ata anoo rapunoko ruao pan Goren-Haatad oyo oahata, “Kasiane! Sio Mesir rei opusu no monne oatamisi ia matane rei anoo runai mainae.” Reiso ohete otoe rei tau Abel-Misraim. Nene nohue “Sio Mesir anoo rapunokoi”. ");
INSERT INTO nxl_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Reiso Yakup ne hehuka ouna sae wani iasau osiso rei. ");
INSERT INTO nxl_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Orori ia matane rei poe otoe Kanaan na oaunutui pan hatu nohue pan nia Makhpela wani Abraham ihane arihoni Efron ia Het rei nanie iaunutu sio matana pan anoe. Hatu nohue rei wapan nia Mamre on pan hae. ");
INSERT INTO nxl_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Taa iaunutu amai pan hatu nohue pusi oyo inuniki na poe Mesir ikata nea kakau, wanin, runa sio wason okatai suru pan oaunutu amai rei. ");
INSERT INTO nxl_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Taa oaunutu amai pan hatu nohue oyo onunso poe otoe Mesir oyo Yusup nea kakau okaitaui pene rotu-tu ihunuso. Reiso oahata, “Munata Yusup anoi repeka runa wani naone iaheniki rei, mka ihunuta. Reiso sapani na ita?” ");
INSERT INTO nxl_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Anoo rapeka runa no masana rei oyo oaisosi ia isa poe iasau na no anamanae reini poe osi noa wani. “Tau amari imatai tewasi ");
INSERT INTO nxl_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","iasau osima ata nanie ami asau osia san rei, ‘Uainisi arihonia na pene apasana mea kakau tau no masana wani naone ounai tanua rei.’ Reiso ami ainisi arihonia na pene apasanama tau mani masana wani naone aunai tanua. Ami aanori runa Anahatana wain amari iainisi iainaa runai.” Yusup iatinu san rei oyo anoi mtinte. Nea kakau oparisaa tanui tewasi reiso matai waena. ");
INSERT INTO nxl_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Oyo nea kakau ruao ohokaso mai tanui. Ohokaso mai ohahue mai tanui. Oahata, “Ami auna maniane tanua.” ");
INSERT INTO nxl_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ne Yusup iahata, “Pene okaitauku. Tau au mo, ukati Anahatana? ");
INSERT INTO nxl_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ruamo oapamata sou nanie ouna kahatene tanuku ne Anahatana ikati kahatene rei tau iake na wani naone rei nooi sani kahatene ereuna iake nea. Anahatana iapuheu sio panesi wason naone omata muaine. Reiso oamahaiso. ");
INSERT INTO nxl_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Pene anomo rauponu. Mka urui muaina osimo runa mo hehuka.” Reiso ianamana iake san rei osi nea kakau na pene okaitaui. ");
INSERT INTO nxl_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Reiso Yusup iruei poe Mesir runa nea kakau, wanin, runa nea enau pusiso. Iamahaiki rotu-tu ne musum utun hutusa. ");
INSERT INTO nxl_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Inoo nea momou, nea upu arihoni Efraim. Inahi Makhir ne hehuka. Sio reimo, sio Manasye nea momou. Inahiso, areimo sio no monne nanie inooso sani ruai ne hehuka. ");
INSERT INTO nxl_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yusup iasau osi nea kakau runa wanin san rei, “Au nanie haineke umataku nea. Ne Anahatana mka isakamo na ihokamo arihoni otoe reini na onunimo pan otoe wani itotoe nanie iruiki osi Abraham, Isak, runa Yakup noa upu noa momou.” ");
INSERT INTO nxl_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Oyo Yusup ioi nea enau pusiso na ohokaso mai tanui na nanie iaunutu hako osiso. Iahata, “Mka Anahatana ihokamo arihoni otoe reini mo saka orori we patane arihoni reini.” ");
INSERT INTO nxl_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Taa ianamana pusi san rei oyo imatai poe otoe Mesir. Ne musum utun hutusa. Oaunutu upati ososa-sosai mai ne patane na oaunutui poe peti anoe.");
INSERT INTO nxl_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Taue isa, oni ita Israel rea aia tewasi, uane tewa. Reiso sio mai ita Israel re otoe osupu muaine tewa rotu-tu omata muaine. Reiso, ia hanaie isa wain nanai Elimelekh. Ia mo, ne ipane Efrata. Iruei poe kota Betlehem poe otoe Yehuda. Ieui pan otoe Moab runa sahai, Naomi, runa ne hehuka hanaia uaso, Mahlon runa Kilyon. Oyo orueso pan rei. ");
INSERT INTO nxl_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Oyo Elimelekh imatai iarihoni sahai Naomi runa ne hehuka hanaia uaso. ");
INSERT INTO nxl_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Oyo ne hehuka hanaia uaso oausahaso onana sio pina hehu Moab. Ia iki manaonete mo, Mahlon sahai nanai Orpa. Ia iki muie mo, Kilyon, sahai nanai Rut. Kani orueso musum hutusa san rei, ");
INSERT INTO nxl_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","oyo Mahlon runa Kilyon omataso oi. Reiso, Naomi iauhanui, tau sahai runa ne hehuka uaso mataso arihoniki nea. ");
INSERT INTO nxl_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Naomi sahai runa ne hehuka uaso omataso, oyo oatinu anamanae mai Moab ata Yahweh iakahai ne mansiau, sio Israel, nea. Iakahaiso pusu no atuhu raruhu iake. Reiso osupu muaine nea. Naomi runa ne mananua uaso, Orpa runa Rut, oseka tau no apia na nanie onunso poe kota Betlehem. ");
INSERT INTO nxl_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Reiso ohitio oeu arihoni otoe Moab nanie onunso okata umau na poe otoe Yehuda. ");
INSERT INTO nxl_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Ne hoka poe arena tinai tihue, oyo Naomi iasau osi ne mananua uaso. Iahata, “Uamo onunimo man. Onunimo poe moa inau no numau nea. Na puruae Yahweh anoi runamo noo sani mo iake osiku runa sahaku na we hehuka uaso wason omataso nea rei. ");
INSERT INTO nxl_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Uainisi na hitio Yahweh iakahai uamo na osupu mo hanai tamena na okatamo honu.” Iasau san rei pusi oyo, imuki uaso. Oyo iauhaa uaso, ne Orpa runa Rut orani oasanoata. ");
INSERT INTO nxl_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Uaso oahata, “Pene! Ami nanie anuni apusua poe me mansiau.” ");
INSERT INTO nxl_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Ne Naomi iahata, “We hehuka onunimo. Nanie opusu au nanie tahae? Mka ususu sio iki hanaia na onanaso tau mo hanaia tewa nea. ");
INSERT INTO nxl_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","We hehuka, onunimo man. Tea mo, uamtuaku nea, reiso mka uausaha tewa nea. Ne masike sani uausahaku tau mono repan, oyo sani ususu we hehuka hanaia ua iae, ");
INSERT INTO nxl_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","nanie onapaso rotu-tu sio karihurua? Reiso mka oausaha nana sio hanai tamena tewa nanie san rei tahae? Nene iake pene opusu au. Pene onapa rotu-tu ususu sio iki hanaia umau honu na onanaso tau mo hanaia. Tea mo, sae wani usupui reini mo, mtinte renesi sae wani osupui rei. Tau Yahweh iuna resuniku nea.” ");
INSERT INTO nxl_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Orani honu oyo Orpa ihuu imuki inai hanahanai, oyo iauhaai na inuniki na poe ne numa. Ne Rut mo, ipenei ieu iarihoni inai hanahanai. ");
INSERT INTO nxl_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Naomi iahata, “Kakam mo, inuniki poe ne niane nea. Inuniki poe nea upu wason nea mansiau oainisi oainaa runare. Ano iae, nene iake mo, anunia na poe me niane oi.” ");
INSERT INTO nxl_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ne Rut iahata, “Pene atentene tanuku na ueu arihonia. Tau ano aeua sui supan, au iae, mka upusua oi. Runa aruea sui supan iae, au iae, mka urue kataya. Ano me mansiau iae, au we mansiau rei sirinia. Anahatana wain ano ainisi ainaa runai iae, au uainisi uainaa runai rei sirinia. ");
INSERT INTO nxl_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Amataya sui supan iae, au umataku kua rei oi. Mka okaniku kua rei oi. Uainisi na Yahweh iapasanaku sani ueu arihonia. Sani rotu-tu uarihonia, areimo umataku nea rei tea.” ");
INSERT INTO nxl_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Naomi inoo ata Rut nanie ipusui sirinia, reiso iamaturui man. ");
INSERT INTO nxl_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Oyo uaso oeu okata umau rotu-tu hokaso poe kota Betlehem. Uaso hoka poe, oyo sio panesi poe rei oruni rerihoni uaso. Sio pinau oasei, oahata, “Ia reino mo, ia Naomi rei si?” ");
INSERT INTO nxl_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Ne Naomi iasau osiso, iahata, “Pene ooiku tau Naomi ooiku tau Mara. Tea mo, Anahatana wain ne kawasa mainae erenesi pusire, irui iake tewa osiku nea. ");
INSERT INTO nxl_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Oni ueuku arihon reini mo, ukata sahaku runa we hehuka hanaia ua, ne Yahweh inun roriku mai rei honu runa hanaku huaya. Reiso nanie ooiku tau Naomi nanie tahae? Tea mo, Yahweh wain ne kawasa mainae erenesi pusire iapasanaku nea.” ");
INSERT INTO nxl_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Reiso Naomi inuniki on pan otoe Moab runa ne mananue, ia pina Moab rei poe otoe Israel. Uaso hoka poe Betlehem pannuhu sio mato ohuku jelai kania (jelai mo, nooi sani ana kania). ");
INSERT INTO nxl_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Pani kota Betlehem mo, ia hanaie isa wain ne rusun panesi. Ia reimo ne ipane osa runa Naomi sahai, Elimelekh. Ia mo, nanai Boas. ");
INSERT INTO nxl_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Reiso Rut, ia pina Moab rei, iasau osi inai hanahanai, Naomi. Iahata, “Ina. Atapiku na ueuku pan nisi isa, na unina sio wason oroha jelai kaia. Mka ueu upusu totuo na uroma jelai kania. Puruae usupu ia isa wain anoi runaku na mka itapiku uroma jelai kania umau waron ramnahuso.” (Jelai mo, nooi sani ana kania.) Inai iamanaku, ");
INSERT INTO nxl_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","reiso Rut ihitio ieui. Hoka pan nisi isa, oyo iroma jelai ipusu sio mamrohaya rei totuo. Iroma pakarema Boas ne tuamane. Boas wain ne ipane osa runa Elimelekh rei. Ne ianei tewa ata reimo Boas ne tuamane. ");
INSERT INTO nxl_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Oyo sira tau Boas ihokai on pan kota Betlehem. Iasau osi sio mamrohaya rei, iahata, “Uainisi na Yahweh ikata runamo.” Oyo sio on poe oasau oi, “Ami ainisi na Yahweh irui iake osia oi.” ");
INSERT INTO nxl_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Oyo Boas iasei tau ia wain isaka sio mamrohaya rei. Iahata, “Ia pina reinau mo, ia pina seia?” ");
INSERT INTO nxl_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Ia wain isaka sio mamrohaya rei iasau, iahata, “Ia pina reinau mo, ia pina Moab wain mato ihokai ikata Naomi on pan otoe Moab rei. ");
INSERT INTO nxl_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Sinasi omnanoe iainisi arihoniku na iroma jelai nesia noi sio mamrohaya totuo. Oni ihokai rotu-tu reipan, iroma sui osa. Mato waipan iaranahai mkane pan wanane reipan.” ");
INSERT INTO nxl_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Boas iatinu san rei, oyo ieui pan Rut. Hoka pan iasau osiki. Iahata, “Atinu tanuku, anaku. Pene aeu aroma jelai sui nisi tamena nea. Pene aeua arihoni nisi reini oi. Arue mai rei akata sio pinau wason opakarian osiku. ");
INSERT INTO nxl_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Anoo ia-ia noi nisi wani sio hanai mamrohaya oroha jelai rei. Aeua apusu-pusu tau muie pusu sio pinau wason opakarian rei. Tea mo, uaunau osi sio makanana taneiu rei nea ata pene oakaremaya. Munata anom kasae mo, aeu noi, aninu noi unena waron sio hanaia oainure tau tihu nea rei na aninu.” ");
INSERT INTO nxl_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Oyo Rut irike tune, ikanahata rotu-tu uai anoe poe tuamane. Oyo iasei, iahata, “Anom runaku nai osa nanie tahae? Rotu-tu anoo runaku, aikee au mo, au rakane.” ");
INSERT INTO nxl_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boas iahata, “Uatinu sio orun nea. Oahata taa saham imatai iarihonia, oyo akahai inam hanahanai. Arai mo, uatinu pusire ia-ia nea. Uanei nea oi ata aeua arihoni inam, amam, runa me otoe wani amrai noi tanui rei oi. Aeu mai otoe wani naone aneiki tewa. ");
INSERT INTO nxl_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Uainisi na Yahweh irui iake osia erepusu me iake rei. Uainisi na irui wani iake nai osa osia. Areimo, Yahweh Anahatana wain ami Israel ainisi ainaa runai rei. Ia sahoro anom tanui na iaunohua, nooi sani manu inae reunohu nene anaya poe nene kihena nohua.” ");
INSERT INTO nxl_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Oyo Rut iahata, “Ama. Uainisi na anom runaku sui osa. Masike nooku sani me sio pina pakarian tewa oi, ne auna anoku iake. Apamanuku na pene uahana anoku mtinte nea.” ");
INSERT INTO nxl_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Taa nanie oaiso oyo, Boas iahata, “Aeu mai na ai sae isa akatama. Anono me poroti rei poe cuka reini iae, iake sirinia.” Oyo Rut irue haineke sio mamrohaya. Boas irui gandum kania umau osiki. Gandum mo, nooi sani ana kania. Gandum kania rei mo, okoture nea. Reiso Rut iai rotu-tu tiai pokone. Muaina rai iae nene nesia asi oi. ");
INSERT INTO nxl_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Ihitioi roe na ieui iroma jelai honu. Ieui, oyo Boas iasau osi sio mamrohaya rei. Iahata, “Masike iroma jelai sui jelai kaia waron okanihoore nea iae, pene ouna pumaai na pene oakapuku tanui. ");
INSERT INTO nxl_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Ne kahurae onesa ouna amnahu jelai kaia umau waron orohare nea rei, na nanie okanihoore. Otapiki iromare. Pene oakapuku tanui.” ");
INSERT INTO nxl_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Reiso iroma jelai noi nisi rotu-tu ranie manne. Oyo inana ai anae na ihita ne jelai kaia waron iromare rei. Ihitare na nene kania ramnahuso. Jelai kania waron iromare rei mo, mtinta haineke kilo hutusa rahana tonu. ");
INSERT INTO nxl_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Isiu ne jelai kania rai na inuniki nau kota. Hoka nau numa, inai hanahanai inoo jelai waron iromare rei. Rut ihoka muaina nesia waron iai pusire ria nisi rei tewa osi inai hanahanai oi. ");
INSERT INTO nxl_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Reiso, inai hanahanai iasei tanui. Iahata, “Aroma raini pusire sui supa? Apakarian kua ia seia ne nisi? Uainisi na Yahweh irui iake osi ia wain ne iake nai osa runaya rei tea.” Oyo Rut iruni osi inai hanahanai. Iahata, “Uroma jelai noi ia onate isa ne nisi. Ia rei mo, nanai Boas.” ");
INSERT INTO nxl_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Oyo Naomi iahata, “Uainisi na Yahweh irui iake osi ia rei. Yahweh mo, anoi runa sio wason oamahaiso asi runa sio wason omataso nea. Irime sae waron itotoe. Ia onate reimo, ne ipane osa runa ita. Reiso ia mo, re kaka wani wain pusu maunaune mo, kahurae anam hanaie ihaha saham nanai na inoo runata.” ");
INSERT INTO nxl_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Oyo Rut, ia pina Moab rei, iahata, “Ia iae, iasau osiku oi. ‘Akata sio wason opakarian osiku rei rotu-tu oroha pusi jelai mai we nisi reini.’” ");
INSERT INTO nxl_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Naomi iahata, “Nene iake, anaku, apakarian akata ne sio pina pakarian rei tea. Na pene sio umau oakaremaya noi nisi tamene nea.” ");
INSERT INTO nxl_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Reiso Rut ikata-kata sio pinau wason oroma noi Boas ne nisi rei sui osa na iroma jelai oi rotu-tu gandum runa jelai nene nania pusire. Iruei ikata inai hanahanai sirinia. ");
INSERT INTO nxl_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Taue isa Naomi iasau osi ne mananue Rut. Iahata, “Anakku, nanie unooa ausahaya honu na pene resunia nea. ");
INSERT INTO nxl_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Apakarian runa sio pinau wason opakarian osi Boas nea. Anei ata Boas mo, ita re kaka wani. Ia iae re mansia wain kahurae iakahaita rei oi. Tau mono repan nanie ieu irei jelai noi numa wani sio osaka oheta tau jelai na ramnahu arihoni nene kaia rei. ");
INSERT INTO nxl_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Reiso, mai na asohua na pake me papi iake runa pake mina hau rihue mkane sini oi. Oyo, eua poe numa wani sio osaka oheta tau jelai na ramnahu arihoni nene kaia rei. Ne pene auna ia ianei ata ano apo rei. Tapiki rotu-tu iaiki pusi. ");
INSERT INTO nxl_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Oyo, sani nanie ieu inekei, areimo noo pusui ia-ia nanie ieui inekei kua supa. Napa rotu-tu ineke munui, samatoro aeu hainekei, oyo siu ne nipae poe ain atua, samatoro anekea haineke ain atua rei. Taa inooa, oyo mka iasau osia runa sae wani mka aunai.” ");
INSERT INTO nxl_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rut iahata, “Mka una pusi sae waron asau runare rei.” ");
INSERT INTO nxl_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Rut iatinu inai hanahanai suka, oyo ieui poe naniake wani saka sio ohuka jelai arihoni nene kaia rei. Iuna pusire sani sae wani inai hanahanai iasau osiki rei. ");
INSERT INTO nxl_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boas iaiki suka iahana tiai pokone, reiso iahana anoi mirike. Oyo, ieu haineke jelai polotu waron rasanou rei rurue na inekei. Potuina tewa, oyo Rut ieu manu-manu ihaineke Boas naniai wani inekei rei. Oyo, isiu Boas ne nipae rurue wan poe ain atue, samatoro inekei. ");
INSERT INTO nxl_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Taa saa monon tihue Boas ihanui. Iuni oyo sira tau isupu ia pina wain ineke poe ain atua. ");
INSERT INTO nxl_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Iasei iahata, “Ano seia reini?” Rut dari bawah iahata, “Upu. Au me manorine Rut. Uainisi arihonia na asouku tau me nipae rurue mkane na uanei ata amanaku ananaku tau saham. Tea mo, ano mo, amaku hanahanai kaka wani isa wain kahurae anoo nnaku.” ");
INSERT INTO nxl_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Rut ianamana pusi oyo, Boas iahata, “Uainisi na Yahweh irui iake osia, anaku. Sae wani aunai rahata reini mo, retuhete ata ano mo, anom runa au renesi sae wan aunai naone rei. Anina ia ikine honue tewa na ananai tau saham masike ia kaya te ia mosokinie iae mo, tewa. ");
INSERT INTO nxl_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Reiso, pene anom reuponu anaku. Tea mo, au mka una pusi sae waron ano aninare rei. Mansia pusiki mai ma kota reini oaneia nea ata ano mo, ano pina wani me hali iake. ");
INSERT INTO nxl_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Sae wani asaui rei mo, manisate. Au sahoro kahurae unoo runaya. Tea mo, au mo, amam hanahanai ne kaka wani wan hainekei. Ne ia hanaie isa wain kahurae inoo runaya tau ia mo, amam hanahanai ne kaka wani wain haineke inesi au. ");
INSERT INTO nxl_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Nekea mai rei tau mono reipan. Hanu omnanoe mka uoi ia wain kahurae inoo runaya na uasei tanui. Sani nanie inoo runaya areimo ia ruai na inoo runaya. Ne sani ipenei, utotoe tau Yahweh ain iamahaiki, areimo au sahoro mka unoo runaya. Anekea mai rei rotu-tu on punano tunne.” ");
INSERT INTO nxl_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Rut iatinu pusi san rei, oyo inekei haineke Boas ain atua rotu-tu haineke manahane. Rut ihanui tau kinoke asi na pene sio umau oationai. Boas iahata, “Upeneku tau mansiau oanei ata ia pina ieu mai rei.” ");
INSERT INTO nxl_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Iasau honu. Iahata, “Rata me nipae wamo manam reino na arimei mai.” Oyo iapatau jelai haineke kilo hutu tonu tau ne nipae rei, samatoro isiu iaunuture roe Rut unui. Pusi, oyo Boas ieui poe kota. ");
INSERT INTO nxl_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Rut inuniki ihokai nau numa, oyo inai hanahanai iasei. Iahata, “Anaku, sapan?” Oyo Rut iruni rerihoni sae waron Boas iunare rei. ");
INSERT INTO nxl_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Iasau honu iahata, “Irui jelai kilou tonu raini osiku oi. Iasau osiku iahata, ‘Pene anunia poe inam hanahanai runa hanam huie.’” ");
INSERT INTO nxl_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Oyo Naomi iahata, “Napa inoo ata mka Boas iuna sae. Tea mo, mka irue mosa tewa sani ne tanei rei pusiki tewasi rahata reipan.” ");
INSERT INTO nxl_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Boas ieui poe kota nene mitanunue nanie iruei poe rei. Oyo, sira tau ia wain kahurae inoo runa Rut renesi Boas rei iniku noi Boas uai anoe. Oyo Boas iahata, “Kakaku sin, waniku sin, mai na aruea roe.” Oyo ia rei iuni iruei. ");
INSERT INTO nxl_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Oyo Boas iroma sio hutusa arihoni sio mtuana noi kota rei, samatoro iasau iahata, “Mai na oruemo kua reini.” ");
INSERT INTO nxl_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Oyo iasau osi ia waini kahurae inoo runa Rut rei. Iahata, “Au nanie uanamana rerihoni rea kaka wani Elimelekh ne tuamane. Tea mo, Naomi ia pina uhanu wain mato inuniki on pan otoe Moab rei nanie iaheniki. ");
INSERT INTO nxl_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Reiso unina na usima osia. Unina na ano ahanei mai sio onata wason orueso reini uao anoa. Sani nanie ahanei areimo, asau. Ne sani ahanei tewa asau. Tea mo, ano sahoro me kawasa ahanei mataanoe samatoro au.” Oyo ia rei iahata, “E, au mka uhanei.” ");
INSERT INTO nxl_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Ne Boas iahata, “Sani ahane tuamane rei arihoni Naomi runa Rut, ano iae mka asupu Mahlon sahai, Rut, ia pina Moab rei wain iauhanui. Ano mo, kahurae ananai tau saham. Na isusu ia iki hanaie isa na ihaha Mahlon nanai.” ");
INSERT INTO nxl_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Oyo ia rei iahata, “Munata san rei mo, au bisa uhane tuamane rei tewa. Tea mo, mka tuamane rei osi au we sio ikina tewa. Ano sahoro ahane tuamane rei! Tea mo, au bisa uhanei tewa.” ");
INSERT INTO nxl_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(Naone pan Israel mo, sani ohane te otuka apie, ia isa mka inosu ne sandali hae, oyo iruiki osi ia isa honu. Areimo, rerui kakinate ata uaso ohunu sou nea. Areini sahoro sio Israel saka ounai sani nani ohunu anamanae.) ");
INSERT INTO nxl_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Reiso ia rei iahata, “Ano ahanei nea.” Oyo inosu ne sandali. ");
INSERT INTO nxl_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Oyo Boas iasau osi sio mtuana na pusiso wason orueso oatinu rei. Iahata, “Rahata reini omi sahoro onoo runa oatinu ata au uhane Elimelekh, Kilyon, runa Mahlon no sae man pusire. Uhanere arihoni Naomi. ");
INSERT INTO nxl_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Rahata reini omi sahoro onoo runa oatinu ata au iae mka unana Rut, ia pina Moab wani sahai Mahlon imatai iarihoniki, reiso iauhanui. Mka unanai tau sahaku oi. Au mka unanai na isusu na anai isaka sae man arihoni Mahlon. Mka unanai na sio anoo rapeka ata tuamane rei, Mahlon ne tuamane na sio Betlehem ohete-hete nanai sirinia. Omi sahoro onoo na oatinu.” ");
INSERT INTO nxl_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Reiso sio onata noi kota rei runa sio wason oatinu noi kota mitanunue rei oahata, “Titue, ami atinu runa anoo nea! Ami ainisi na Yahweh iuna ia pina wain ananai tau saham rei isusu haha sio ikina panesi nooi sani Rahel runa Lea rei. Uaso no hehuka wason okikasi tau sio otoe Israel. Ami ainisi arihoni Yahweh na iunaya me rusun panesi pan ipa Efrata. Ami ainisi arihoni Yahweh na iuna sio oationa nanam poe kota Betlehem. ");
INSERT INTO nxl_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Ami ainisi na arihoni ia ikine wain Yahweh iruiki osia arihoni ia pina reini, mka isusu haha sio ikina panesi nooi sani Peres. Tamar isusu Peres osi Yehuda.” ");
INSERT INTO nxl_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Boas ianamana runa Elimelekh pusi, oyo inana Rut tau sahai. Inanai, oyo ineke runai. Oyo Yahweh ikata runa Rut rotu-tu tinain taua. Oyo irue runa anai. Anai reimo, ia iki hanaie. ");
INSERT INTO nxl_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Ia ikine rei iamrai suka, oyo sio pinau oasau osi Naomi. Oahata, “Ami ainaa runa Yahweh! Tea mo, irui momom hanaie osia na inoo nnaya. Ami ainisi arihoni Yahweh na Yahweh iuna momom tau mansia mainae mai Israel reini pusiki. ");
INSERT INTO nxl_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Yahweh irui iake osia nea. Tea mo, me mananue wain anoi runaya rei isusu nea. Nene iake asupu mananue sani Rut rerihoni asusu sio iki hanaia itu. Momom rei mka isakaya rotu-tu akore-kore amtuaya nea. Iuna ano ahana sani ano honue asi.” ");
INSERT INTO nxl_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Oyo, Naomi inana ia ikine rei ihetei. Iakahai Rut ipakanana runa isaka ia ikine rei rotu-tu ia mainae. ");
INSERT INTO nxl_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Sio pinau wason orueso noi rei ohete nanai tau Obed. Oahata, “Naomi anai hanaie isa nea.” Obed mo, Isai amai. Isai mo, Daud amai. ");
INSERT INTO nxl_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Peres nea upu momou: Peres mo, anai tau Hesron. ");
INSERT INTO nxl_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hesron anai tau Ram. Ram anai tau Aminadab. ");
INSERT INTO nxl_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab anai tau Nahason. Nahason anai tau Salmon. ");
INSERT INTO nxl_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmon anai tau Boas. Boas anai tau Obed. ");
INSERT INTO nxl_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obed anai tau Isai. Isai anai tau Daud.");
INSERT INTO nxl_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Taue isa Yahweh iaisosi Yunus. Yunus mo, Amitai anai. Iahata, ");
INSERT INTO nxl_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Yunus. Eua ria Niniwe, kota onate rei. Hoka ria, na asau osiso ata Au unoo no hali kahatena rai nea. Reiso mka uapasanamo.” ");
INSERT INTO nxl_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Ne Yunus ipenei ieui ria kota rei. Tea mo, ne nisau tau sio Niniwe rei. Reiso inina arena na irumai hainau arihon Yahweh ne anamanaya rai. Taa san rei oyo nanie irumai pan niane isa wan nanae Tarsis. Oyo ieui nau namane isa wan nanae Yapo. Hoka nau, isupu kapane isa wan nanie reeui na pan Tarsis. Oyo isenu arena hunonie, oyo isaa ikata sio wason opakarian roe kapane rei. Inina arena san reini mo, tau nanie irumai iauhuniki hainau arihon Yahweh. ");
INSERT INTO nxl_vpl VALUES ("JH1_4","033_1_4","JON","1","4","5","Isaai roe kapane rei oyo, isipui poe kapane anoe poe nohu nai osa na inekei. Waipo inekei munui. Kapane rei rehokai nau nuae tihue, oyo sira tau Yahweh iuna ihu onate. Ihu onate rei reuna nuae resau-sau. Reiso kolau nanie rahita poho kapane rei. Taa onoo san rei oyo, sio wason opakarian noi kapane rei okaitau hun ruao nai osa. Reiso oakapona no anahatanau waron titue tewa na rakahaiso. Opesi apia umau na poe nuae na kapane rei karahirine mkane. ");
INSERT INTO nxl_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Ne Yunus mo, waipo inekei asi. Oyo ia mainae tau kapane rei isipui poe kapane anoe rei, isira tau Yunus waipo inekei. Reiso ihanui. Iahata, “He. Ano mo, anekea iake maa! Ahanu. Na ainisi tau me Anahatana na hitio anoi runata na iakahaita na pene imokota.” ");
INSERT INTO nxl_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Taa san rei oyo, Yunus ihanui. Oyo uaso osaaso roe kapane hahae. Hoka roe, oyo sio iki pakarian noi kapane rei oasau osi umau. Oahata, “Mai, na iuna nau na ianei ata kani ia seia sahoro ne isanae reini na rotu-tu wan isupu siraka reini.” Ouna nau, oyo nau rei reutuu pannuhu Yunus. ");
INSERT INTO nxl_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Reiso oasei tanui, “Masi asima ee! Ia seia sahoro iuna isanae rotu-tu isupu siraka reini? Me pakarian sae? Ano on supa? Me niane sae?” ");
INSERT INTO nxl_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Iahata, “Au mo, au Ibrani. Au mo, uainisi uainaa runa Yahweh Anahatana wairo noiyaha. Ia sahoro ihaye tau tuniai reini pusiki.” ");
INSERT INTO nxl_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Isima osiso naone nea ata ia mo, wain irumai arihoni Yahweh. Reiso okaitau hun ruao. Oahata, “Auna san rei nan tahae?” ");
INSERT INTO nxl_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Ihute reini rehua nuae renesi wan sinasi rei honu. Reiso oasei tanui, “Nanie amunaya na nuae reini remanu?” ");
INSERT INTO nxl_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Iahata, “Pesiku na poe nuae. Mka nuae reini remanu. Uanei nea ata areini mo, au we isanae, reiso siraka reini tea!” ");
INSERT INTO nxl_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Ne openeso opesiki. Reiso opakumoni osai kapane rei na rehaineke muni. Ne okuai tewa tau nuae rei resau-sau renesi honu. ");
INSERT INTO nxl_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Reiso oainisi oakapona tau Yahweh san rei, “Yahweh. Ami ma maue tewa, na apesi ia reini. Ne Ano sahoro auna siraka reini pusu me maue, reiso pene apasanama noso ahunu ia reini wain isana tewa.” ");
INSERT INTO nxl_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Oainisi pusi oyo opesiki. Oyo nuae rei remanu. ");
INSERT INTO nxl_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Onoo san rei, okaitau hun ruao tau Yahweh. Reiso oatanima makapana osi Yahweh na pene anoi resaa tanso na ototoe osiki ata mka opusui. ");
INSERT INTO nxl_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Yahweh ne maue reiso, iaisosi ika mainae rerono Yunus. Reiso iruei pan ikae rei tiae onona hataya tonu. ");
INSERT INTO nxl_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Yunus waipan ikae rei tiai, iainisi arihoni Yahweh Anahatana san rei, ");
INSERT INTO nxl_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","“Yahweh. Sinasi nanie umokoku reiso uainisi arihonia. Uainisi oyo, Ano akahaiku. Yahweh. Nanie umataku nea. Reiso uainisi na akahaiku. Uainisi oyo, Ano atinu tanuku. ");
INSERT INTO nxl_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Apesiku poe nuae wan naue nai osa. Reiso umokoku na poe nuae nosite. Auna kana reuneniku suru ria suru nau. Kolau rapapaku. ");
INSERT INTO nxl_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Uanamana pan anoku uahata, ‘Aneiku arihoni uam anoe nea reini tea! Kani mka unoo me numa mainisie tewa nea.’ ");
INSERT INTO nxl_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Sinasi nuae hasae tionaku nea. Nanie upunuku nea reini! Mono nuae waron rahehe unuku nea reini! ");
INSERT INTO nxl_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Umokoku rotu-tu uhokaku poe nuae nosite nene tinetaya nene aikune. Noo sani oneteku poe rei rotu-tu ria supan. Ne Yahweh Anahatana. Nanie umataku nea. Ne Ano apuheuku na uamahaiku. ");
INSERT INTO nxl_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Haineke nanie watipusi nahaku nea oyo anoku repeka runaya reiso uainisi. Uainisi, Ano atinu. Atinu roe me numa mainisie. ");
INSERT INTO nxl_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Sio wason oainisi oainaa tau anahatanau waron rakahaiso tewa rei mo, opusua tewa. Aikee anom runaso sui osa. Arime sae waron atotoe. ");
INSERT INTO nxl_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Ne au mo, mka uhete kapata uainisi iake arihonia sui osa. Mka uatanima makapana osia. Utotoe osia, mka au una suiki. Yahweh, ano sahoro apuheuku.” ");
INSERT INTO nxl_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Iainisi pusi oyo, Yahweh iaisosi ika mainae wani reronoi rei reumutai ria muni. ");
INSERT INTO nxl_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Yahweh iaisosi Yunus honu. Nai ua nea. Iahata, ");
INSERT INTO nxl_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Yunus. Eua ria Niniwe, kota onate rei, na asau osi sio ria rei runa sae wan uaisosia rei.” ");
INSERT INTO nxl_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Yunus iatinu tau Yahweh, reiso ieui na ria Niniwe. Ne Niniwe mo, kota onate reiso ieuta rotu-tu onona tonu samatoro ihokata pan kota rei rurue. ");
INSERT INTO nxl_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Yunus ihokai ria kota rei, oyo ieu pan kota rei anoe rotu-tu ranie hatae samatoro iakapona. Iahata, “Omi Niniwe. Nesie onona hutu ate reini, oyo mka Anahatana iuna mo kota reini watikohui.” ");
INSERT INTO nxl_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Sio Niniwe oatinu tau Anahatana ne anamanae rei oyo oparisaa tau Anahatana. Oyo ohunu sou na oamaon. Tea mo, oatamisi no rosau. Mansia pusiki, hikine mainae oatei api mananokona waron ounare arihon karun na oanei ata oarihon no rosau pusire nea. ");
INSERT INTO nxl_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Taa ia aia Niniwe iatinu anamanae rei, oyo isipui arihoni ne katera aia rei. Oyo ihuka ne papi aia rei, na iatei api mananokona waron ounare arihoni karun oi, oyo iruei poe otumatae na oanei ata iarihoni ne rosau. ");
INSERT INTO nxl_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Irui anamanae osi ne mansiau mai kota rei, “Au aia runa we hanaku wanana wan arui anamanae reini: Mansia runa makapana waron oapiarare sani koropou, une-une, runa sae man pene oai, pene oninu. ");
INSERT INTO nxl_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Mansia kahurae oatei api mananokona na oanei ata oarihoni no rosau nea. Makapanau iae, soure tau api mananokona wan ounai arihoni karun oi. Kahurae pusita iainisi ia-ia osi Anahatana na anoi runata. Kahurae pusita iarihoni re haliu kahatena. Kahurae pene imuna sio umau. ");
INSERT INTO nxl_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Kani puruae Anahatana anoi resaa tanta tewa nea, ne mka ineni anoi na anoi reruei. Reiso ita mka imatata tewa.” ");
INSERT INTO nxl_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Anahatana inoo ata sio Niniwe oarihon no rosau runa oarihoni no haliu kahatena waron ounare rei. Reiso ineni anoi na iatikohu no kota rei tewa oi. ");
INSERT INTO nxl_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Yahweh iatikohu kota Niniwe tewa reiso Yunus iatamisi ruai. Anoi resaa mainae. ");
INSERT INTO nxl_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Oyo iainisi. Iahata, “Yahweh. Ano aisosiku na ueuku mai rei mataanoe oni urueku pan we niane asi. Uanei nea ata areini sahoro mka aunai. Reini sahoro reunaku nanie urumaku na pan kota Tarsis. Tau uanei ata Ano mo, anom runa mansiau. Masike ami apalalosa iae, arui iake nai osa osima sirinia. Me sate resaa rapu tewa. Anom runama na arime sae waron atotoe osima rei sirinia. Reiso asaka aneni me anamanae wan nanie apasanama rei. ");
INSERT INTO nxl_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Reiso, Yahweh, atapiku umataku man nea! Tau nene iake mo, umataku uarihon tuniai reini nea.” ");
INSERT INTO nxl_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Ne Yahweh iahata, “Ano me sae na anom resaa rei?” ");
INSERT INTO nxl_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Iatinu san rei oyo ieui arihoni kota rei, na ria rani mata saae. Hoka pan oyo, iuna ne wanane isa na iaraonoi. Irue inapa, nanie inoo mka sae ereyari tau kota Niniwe. ");
INSERT INTO nxl_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Oyo sira tau Yahweh Anahatana iuna ai isa sani hunanene reruhu haineke Yunus ne wanane rei. Reraonoi na reuna anoi wani mtinte rei karahirine mkane. Reiso anoi mirike nai osa. ");
INSERT INTO nxl_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Ne nene hanroe san rei wapan reputi-puti asi oyo, Anahatana iaisosi une hatae isa reai ai rei rotu-tu ai rei rematai. ");
INSERT INTO nxl_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Taa ranie resaa oyo, Anahatana iuna ihute wan titie reuhona on pan rani mata saae. Ran titie repana Yunus unui reiso iahana imankaei mainae. Oyo iahata, “Nene iake mo, umataku man nea na pene unoo tuniai reini nea tea!” ");
INSERT INTO nxl_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Ne Anahatana iahata, “Nanie anom resaa noso ai rei nan tahae?” Iahata, “Nanie umataku nea reini tau ranie titie mainae! Reiso anoku resaa tea!” ");
INSERT INTO nxl_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Iahata, “Anom runa ai reini si? Aikee me kausa wanaya rahoka tanui tewa oi rei! Asakai tewa rei! Ai reini reruhui tau onone hatae man. Han roe rematai nea rei! ");
INSERT INTO nxl_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Ano man anom runa ai reini! Reiso Au sapan runa kota Niniwe reini? Sio nihun nihu utun hutu ua nesi wason orueso poe kota rei. Samatoro no makapanau iae panesi oi. Oanei sae wan manisate runa sae wani kahatene tewasi! Reiso Au iae kahurae anoku runaso oi tea!”");
INSERT INTO nxl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Au nanie usima na Sou Iake rerihoni Yesus Kristus. Yesus Kristus mo, Anahatana Anai. Sou Iake rei nene aikune wan san naone wan ia mamsima runa Anahatana ne maunauna isa wain nanai Yesaya ikanui. Ikanu ata Anahatana iasau osi Anai, Yesus, san rei, “Anahatana iasau ata, ‘Au mka uaisosi we ia mamsimae isa ianaone. Ia mka iseka tau mansia anoo, noo sani oseka tau arena osi aia, na inikui noi arena rei. ");
INSERT INTO nxl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ia isa nioi iakapona ria otoe huie san rei, “Sani sio oseka tau arena osi ia mainae, aunauso rerihoni Au, na oatinu tau Upuri san ouna arena katopue na mka ieu pusui.”’” ");
INSERT INTO nxl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yesaya ikanu san rei, areimo sani Yohanis ihokai pan otoe huie. Ihokai na isohuso na mansiau oanei ata oarihon no rosau nea. Iaunauso san rei, “Oarihon mo rosau na Anahatana isiru heu mo rosau rai. Oarihonre, oyo usohumo na mansiau oanei ata oarihon mo rosau nea.” ");
INSERT INTO nxl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mansia pusiki sui otoe Yudea runa kota Yerusalem ohoka, nanie oatinu Yohanis ne maunauna. Oamanaku no rosau, oyo Yohanis isohuso na mansiau oanei ata oarihon no rosau nea. Isohuso pan Wae Yordan. ");
INSERT INTO nxl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohanis mo, iausahu papite wan ounai arihoni makapana wan nanae unta nene hunua. Inene koropou unte pan ahai. Iai kauka runa kilalan wesie. ");
INSERT INTO nxl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Iaunauso san rei, “Mka ia isa ihokai tau muie. Ia reimo mka ne kawasa mainae renesi au. Au mo, au mainae tewa. Reiso ukanahata na unosu ne sandaliu arihoni ain atua man iae, iake tewa oi. ");
INSERT INTO nxl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Usohumo tau tihu na mansiau oanei ata oarihon mo rosau nea. Ne Ia sahoro mka irui Anahatana ne Inaha osimo.” ");
INSERT INTO nxl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Oyo Yesus ihokai on poe nia Nasaret poe otoe Galilea, samatoro Yohanis isohui pusu monne ria Wae Yordan. ");
INSERT INTO nxl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Isohui pusi, oyo Yesus ihokai arihon waene rei, inoo nante rehekai. Oyo Anahatana Ne Inaha isipui. Anahatana ne Inaha rei mo, nooi sani manu puane. Isipui, ");
INSERT INTO nxl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","oyo iatasohoi roe Yesus. Iatasohoi oyo oatinu nioke isa on roe noiyaha. Iahata, “Ano mo, Au Anaku. Anoku runaya nai osa. Anoku iake tau Ano.” ");
INSERT INTO nxl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mata hun tewa oi, oyo Anahatana Ne Inaha iaisosi Yesus ieui ria otoe huie. ");
INSERT INTO nxl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Reiso iruei ria otoe huie rei, onona hutu ate. Oyo ia aia sakahatene ireai na ipalalosa. Binatang seata warora rei oi. Ne Anahatana ne maisosia on roe noiyaha ohoka oakahaiki. ");
INSERT INTO nxl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Sio oaresi Yohanis nea, oyo Yesus ieui poe otoe Galilea. Ieui poe rei, nanie isima runa Sou Iake rerihoni Anahatana. ");
INSERT INTO nxl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Hoka poe, isima ata, “Anahatana nanie irime ne mansiau nea. Oarihon mo rosau. Oparisaa tau Sou Iake rerihoni Au.” ");
INSERT INTO nxl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Taue isa Yesus wain ieui ipusu Wae Galilea nusue, oyo inoo sio mamhikua ua. Sio ua reimo, Simon runa wanin Anreas. Uaso wason ohikuso onina ikae. ");
INSERT INTO nxl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesus iasau osiso ata, “Mai na opusu Au. Mka uatuhetemo na oeu onina mansiau na opusu Au, nooi sani oeu onina ikae rei.” ");
INSERT INTO nxl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Oyo oarihon no ueta rai sirinia, samatoro opusu Yesus. ");
INSERT INTO nxl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesus ieui hainau mkane, ita inoo Sebedeus ne hehuka, Yakobis runa wanin Yohanis. Uaso wasopan no arupai anoe, oseka tau no ueta. ");
INSERT INTO nxl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Oyo Yesus ioiso rei sirinia. Reiso oeu arihon noa ama pan arupai anoe rei runa sio umau honu. Oarihoniki runa sio wason isehaso na opakarian osiki rei. Oyo uaso oeu opusu Yesus. ");
INSERT INTO nxl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesus runa ne mampusua oeu rotu-tu ohokaso pan kota Kapernaum. Tau ranie hatae isa wan ita Yahudiu iamuira Anahatana, Yesus inusui pan sio Yahudiu no numa mananoune, nanie iatuhete pan rei. ");
INSERT INTO nxl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Sio wason oatinui rei, osira tau ne anamanaya rai. Tea mo, iatuhete runa ne kawasa. Iatuhete san sio matuhete Musa ne maunauna tewa. ");
INSERT INTO nxl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Oyo Yesus iatuheteso pan sio Yahudiu no numa mananoune. Pan rei, ia isa waimo sakahatene remasuniki. Oyo sira tau iakapona ata, ");
INSERT INTO nxl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesus, Ano Nasaret. Nanie amunama? Ahokaya reini mo, nanie ahunuma si? Uaneia nea. Ano mo, Ano manisate onate. Ahokaya on roe Anahatana!” ");
INSERT INTO nxl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ne Yesus iasau osi sakahatene rei. Iahata, “Amaturua! Ahokaya arihon ia reno.” ");
INSERT INTO nxl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Reiso ia rei ikananunu tau sakahatene rei remasuniki, oyo iasanoata. Oyo sakahatene rei rehokai arihoniki rei sinia. ");
INSERT INTO nxl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Rehokai oyo sio pusiso osira hun ruao. Reiso oasei mai umau oahata, “Ira oe! Sae reini? Matuhete honue maa! Tau ne kawasa iaisosi sakahatena rahoka, oyo rahokaso rei sirinia tea!” ");
INSERT INTO nxl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Reiso mata hun tewa oi, oyo sio pusiso oatinu rerihoni Yesus sui otoe Galilea pusiki. ");
INSERT INTO nxl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesus ikata Yakobis runa Yohanis, oyo tonso ohokaso oarihoni sio Yahudiu no numa mananoune rei, samatoro oeuso poe Simon runa Anreas no numa. ");
INSERT INTO nxl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon inai hanahanai waipo inekei. Tea mo, titie retanunui. Reiso osima runa ne kupue rei osi Yesus. ");
INSERT INTO nxl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Oyo Yesus ieui poe, iakahuu ia pina onate hanai atue, samatoro iakahaiki ihitioi. Oyo ia pina onate rei, ne kupue iake rei sinia. Ia iake nea, oyo inana muaine osi pusiso oaiso. ");
INSERT INTO nxl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nene manin ruru san rei, mansiau orori sio kupua runa sio wason oauwena na sakahatena. ");
INSERT INTO nxl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Reiso sio niane hahae rei pusiki, pusiso oamanouso haineke Petrus ne numa mitanunue. ");
INSERT INTO nxl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Oyo Yesus isuisene sio panesi wason osupu kupu nita-nitaya, inei sakahatena. Ne isopo sio sakahatena rei na pene oanamana. Areimo tau raanei ata Yesus mo, Ia seia. ");
INSERT INTO nxl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nene hanroe omnano tunne san rei oyo, Yesus ihanui. Ihanui oyo ieui arihon numa rei. Ieui na pan otoe isa wan meneta nai osa, nanie iainisi tau Anahatana. ");
INSERT INTO nxl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ne Simon sio oeu oninai. ");
INSERT INTO nxl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Taa osupui, oasau osiki ata, “Sio pusiso wason oeu oninaya rei!” ");
INSERT INTO nxl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ne Yesus iasau osiso ata, “Mai, na ieuta sui nia tamena sui otoe Galilea reini. Na usima na Sou Iake rerihoni Au osi sio oi. Tea mo, uhokaku mai rei mo, tau rei, tea!” ");
INSERT INTO nxl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Reiso Yesus ieu ihori otoe Galilea rei pusiki. Ieu isima na Sou Iake rerihoni Anahatana sui sio Yahudiu no numa mananouna na ieu isuisene sio wason oauwena runa sakahatena. ");
INSERT INTO nxl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Taue isa, ia isa wain ikupu unte wan iake tewa nai osa ieui mai Yesus. Hoka mai, irike tune iakapuni Yesus ain isopa ikokuroui. Oyo iainisi na Yesus isuisenei. Iahata, “Upu. Sani me maue mo, mai na asuiseneku, areimo Ano me kawasa asuiseneku.” ");
INSERT INTO nxl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesus anoi runai, reiso iahusiei. Iahata, “Au we maue. Reiso ano iake nea.” Oyo ia rei iake rei sinia. ");
INSERT INTO nxl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ranie hatae rei sinia, oyo kupue rei rerihoniki rei sinia. Kupue rei rerihoniki, oyo ia kupu unte rei iake rei sinia. ");
INSERT INTO nxl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Oyo Yesus iaisosiki ieui. Iasau osiki ata, ");
INSERT INTO nxl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Anom repeka. Asupu sio umau mo, pene aruni. Ne aeua pan ia imam isa na ainisi na inooa. Arui manua ua osiki na ikenure osi Anahatana sani Musa iaunau rei. Tau rei, sio pusiso mka oanei ata ano iake nea.” ");
INSERT INTO nxl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ne ipusu Yesus ne maunaune rei tewa. Ieu suru ria, suru nau iruni osi sio panesi. Iahata, “Yesus isuiseneku.” Reiso iruni suru ria, suru nau rotu-tu Yesus inusu niana mo, iau-iauhuniki man. Iruei iauhuniki pan otoe huia man. Ne sio on ria, on nau ohokaso mai tanui sui osa sinia. ");
INSERT INTO nxl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Yesus isuisene ia kupu unte pusi, oyo nene onona ate san rei, inuniki pan kota Kapernaum. Sio panesi onooi, reiso osima osi umau. Oahata, “Yesus waipan ihokai nea.” ");
INSERT INTO nxl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Reiso mansia hutue ohoka oamanouso haineke numa rei rotu-tu sio umau mo, osupu naniao tewa nea. Pan mui, haineke mitanunue iae, san rei sinia. San rei oyo, Yesus isima na Anahatana ne anamanaya osiso. ");
INSERT INTO nxl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Oyo sira tau sio umau ohoka orori ia talae isa. Sio ate ohanai, nanie ororiki mai Yesus. ");
INSERT INTO nxl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ne okeka kua mansia hutue rei tewa. Reiso oeu mai tanui iake tewa. Oyo osaaso pusu oane na roe numa hahae, samatoro ohuka nene ainataya. Oyo oratiki tau ne kinoe mai Yesus. ");
INSERT INTO nxl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Oratiki oyo, Yesus inoo ata sio rei oparisaa ata Ia mo, imaha heu kupue rei. Taa san rei oyo, Yesus iasau mai ia talae rei ata, “Anaku, me rosau, usiru heure nea.” ");
INSERT INTO nxl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ne sio matuhete Musa ne maunauna umau wason oru-rueso pan rei. Oatinu Yesus ianamana san rei, oyo oasei pan anoo ata, ");
INSERT INTO nxl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ia mo, masike nai osa. Ianamana san rei mo, sani Ia mo, Anahatana rei. Ia seia sahoro imaha isiru heu rosau sani Anahatana? Anahatana ruai sahoro ne kawasa isiru heu rosau.” ");
INSERT INTO nxl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Taa san rei oyo, Yesus ianei anoo. Reiso iasau osiso ata, “Nanie oarinii pan anomo san rei tahae? ");
INSERT INTO nxl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Sani uasau osi ia talae reini, ‘Me rosau, usiru heure nea.’ Ne sapani na oanei ata kani usiru heure te tewa? Ne sani uasau osiki, ‘Hanua! Ahitioa, ahetu me kinoe rei, oyo ruam aeu.’ Omi mka oanei ata Au we kawasa usuisene. ");
INSERT INTO nxl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ne muie reini, unina na oanei ata, mai tuniai reini, Au, Tumata Reini mo, Anahatana Ihitiku, we kawasa usiru heu rosau.” Oyo Yesus iasau osi ia talae rei ata, ");
INSERT INTO nxl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Uasau osia, ahanua, ahetu me kinoe rei, na anunia.” ");
INSERT INTO nxl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Oyo ia rei ihanui, ihetu ne kinoe rei, oyo ihokai. Sio pusiso onooi ihanui, ihetu ne kinoe rei. Reiso osira. Oainaa runa Anahatana ata, “Mania upu Anahatana. Ano mo, ano iake tunne nai osa. Ano me kawasa mainae. Una nitae reini mo, ami anooi tewasi.” ");
INSERT INTO nxl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesus isuisene ia talae isa pusi, oyo ieui pan Wae Galilea honu. Ihokai pan waene nusue, oyo sio panesi ohokaso mai tanui na iatuheteso. ");
INSERT INTO nxl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Taa Yesus wain ieu ipusu arena pan rei, oyo inoo ia mainisi pea isa waipo iruei poe ne numa mainisi peau. Ia reimo, nanai Lewi. Amai tau Alpeus. Sio mainisi peau oakahai sio Romau na oamanou peau arihon sio Yahudiu. Sio Romau rei otapiso oakapena na onana kepen umau osi ruao oi. Reiso sio Yahudiu openeso tanso. Sio oahata sio mo, sio kahatena nai osa sani sio kimanakana. Yesus ioi ia rei ata, “Mai, na apusuku.” Lewi iatinu san rei oyo, ihitioi ipusu Yesus rei sinia. ");
INSERT INTO nxl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesus wain iaiki pan Lewi ne numa, oyo sio mainisi peau runa sio wason nusa niane oahata sio kahatena rei ohoka oaiso okata Yesus runa ne mampusua oi, tau sio panesi wason oeu opusu-pusui oi. ");
INSERT INTO nxl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Sio matuhete Musa ne maunauna arihon sio ona akama Yahudiu onoo Yesus iaiki ikata sio mainisi peau runa sio wason nusa niane oahata sio kahatena rei. Reiso oasei tau Yesus ne mampusua ata, “Omi mo matuhetene rei, nanie iaiki ikata sio mainisi peau runa sio wason opalalosa oi tahae?” ");
INSERT INTO nxl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesus iatinu san rei oyo iahata, “Sani ia isa ikupui tewa, inina ia mamsuisene tewa. Ne ia wain ikupui sahoro ininai. Au mo, nooku sani ia mamsuisene rei oi. Uhokaku mai tuniai reini mo, nanie uoi sio wason opalalosa. Ne sio wason oahata ruao oamanisa mo, uhokaku na uoiso mo, tewa.” ");
INSERT INTO nxl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Taue isa Yohanis ia mamsohue ne mampusua runa sio onata arihon akama Yahudiu pusiso wason oamaon. Oyo sio umau ohokaso mai Yesus, nanie oasei tanui ata, “Yohanis ne mampusua runa sio onata arihon akama Yahudi no mampusua oamaon. Oo, Ano me mampusua mo, oamaon tewa tau sae?” ");
INSERT INTO nxl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesus nanie iatuheteso ata on ikata ne mampusua asi, ne mampusua oamaon iake tewa. Anoo rapunokoso iake tewa. Reiso iahata, “Tau sio mausahaya oaiseneso, sio wason opusu karisaa rei, oamaon tewa, tea! Munata ia hehuke wain ikataso asi, oaiso sinia, tea! Oamaon iake tewa. ");
INSERT INTO nxl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ne mka sio umau osota ia hehuke rei, samatoro sio wason noi karisaa rei oamaon iake. ");
INSERT INTO nxl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ia sia man iaturui papi monae tau nipa sinte wan honue tewa. Sani iuna san rei, mka opapa papite rei, oyo renunui. Oyo papite rei wakihai mainae honu. ");
INSERT INTO nxl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Areimo nooi sani iaiinu tihu anggur wan honue tau tasi wan sio ounai arihon une-une unte wan monae nea. Tea mo, mka tihu anggur rei reuna tasi wan monae rei wakihai. Oyo tihu anggur rei reohui sai-saiki na tasi rei, iake tewa nea. Ne tihu anggur wan honue mo, kahurae aiinui tau tasi wan honue oi, na uare iaka sirinia.” ");
INSERT INTO nxl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Taue isa, tau ranie hatae wan ita Yahudiu iamuira Anahatana, Yesus ieu ikata ne mampusua oeu opusu nisi gandum isa. Oyo ne mampusua ohuku gandum huaya na oai nene isia. ");
INSERT INTO nxl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Sio onata arihon akama Yahudi onoo san rei, oyo oasei ata, “Omuna na onana tau ranie hatae wan ita Yahudiu iamuira Anahatana reini? Opusu Musa ne maunauna tewa!” ");
INSERT INTO nxl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Iahata, “Omi onoo tau Anahatana ne anamanaya tewa, sapani na Daud inana poroti wani sio oruiki osi Anahatana.Poroti reimo, pusu Musa ne maunauna, hasae sio imam ruao man sahoro oaiki.Aikee Daud inanai. Inanai tau rei mo, tau Abiatar iuna sio imam no ia mainae. Daud runa sio wason okatai rei omakaneaso. Reiso inusui pan Anahatana ne numa mainisie, oyo iai poroti rei. Isama sio wason okatai rei oi. Ne ia isa iakapuku tanui tewa. ");
INSERT INTO nxl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Reiso ranie hatae wan ita Yahudiu iamuira Anahatana mo, Anahatana iunai osi mansia. Ihaye mansia tewa na opusu maunauna rerihoni ranie hatae wan iamuira Anahatana rei man. ");
INSERT INTO nxl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Reiso Au, Tumata Reini mo, Anahatana Ihitiku we kawasa tau ranie hatae wan ita Yahudiu iamuira Anahatana. We kawasa uasau ouna sae na ouna sae tewa.” ");
INSERT INTO nxl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tau ranie hatae isa honu wan sio Yahudiu oamuira Anahatana, Yesus inusui pan sio Yahudiu no numa mananoune, oyo isupu ia hanaie isa. Ia reimo, hanai rematai. ");
INSERT INTO nxl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Sio umau wason onina arena na nanie oapasana Yesus. Reiso oaka-akaohui. Pene tu-tu isuisene sio umau tau ranie hatae wan ita Yahudiu iamuira Anahatana rei. ");
INSERT INTO nxl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Oyo Yesus iasau osi ia wain hanai rematai rei. Iahata, “Aeu mai na ooa mai uae reini.” ");
INSERT INTO nxl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Oyo Yesus iasei tau sio onata arihoni akama Yahudi runa sio matuhete Musa ne maunauna ata, “Sani pusu Musa ne maunauna mo, iuna sae tau ranie hatae wan iamuira Anahatana sahoro iake? Iuna iake te, iuna kahatene? Iakahai mansia na iamahaiki te, itapiki na imatai?” Ne sio panesi rei oamaturuso man. ");
INSERT INTO nxl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iasau san rei pusi, oyo inoo neka-neka sio wason ohoriki rei. Anoi resaa. Ne anoi runaso tau unuo onata. Oyo iasau osi ia rei ata, “Asasona hanam mai.” Ia rei iasasona hanai oyo sira tau hanai wan rematai rei, iake rei sirinia. ");
INSERT INTO nxl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Oyo sio onata arihon akama Yahudi rei ohokaso arihoni sio Yahudiu no numa mananoune rei, oyo oanamana runa Herodes ne mansiau, na nanie ohunu Yesus. ");
INSERT INTO nxl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesus runa ne mampusua oeuso oarihon sio hutue rei, oyo oeuso pan waene. Ne sio Galileau panesi, sio on pan otoe Yudea, sio on roe kota Yerusalem, sio on pan otoe Idumea, sio on ria Wae Yordan on ria hae, runa sio on pan kota Tirus na Sidon oeu pusu Yesus sio oi. Sio rei pusiso ohokaso pan Yesus tau oatinu rerihoni iuna sae. ");
INSERT INTO nxl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Reiso Yesus iaisosi ne mampusua onoo na arupai isa matane osiki nea. Oyo orurui hainekei. Ikaitau pene tu-tu sio mansia hutue wason sinasi rei oesei, reiso iainisi arupai rei. ");
INSERT INTO nxl_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Isuisene kupua inaya panesi, reiso sio kupua pusiso oruru heu umau, na oeu haineke Yesus na oakahuui. ");
INSERT INTO nxl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Sakahatena ranoo Yesus ata Ia mo, ihokai arihoni Anahatana. Reiso oakapona ata, “Ano sahoro Anahatana Anai!” ");
INSERT INTO nxl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ne isoposo ata, “Pene oeu osima osi sio umau ata Au mo, Au seia.” ");
INSERT INTO nxl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesus isuisene sio kupua pusi, oyo inoai na roe pupue, samatoro ianaha runa sio umau wason ruai ne maue na opusui. Sio rei ohokaso roe, ");
INSERT INTO nxl_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","oyo ihiti sio hutusa rahana ua. Oyo iahata, “Uhitimo na okataku sui supan man na uaisosimo osima na Sou Iake rerihoni Au. ");
INSERT INTO nxl_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Mka Anahatana irui kawasa osimo na onei sakahatena.” ");
INSERT INTO nxl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Sio hutusa rahana ua wason Yesus ihitiso rei mo, nanao: Simon (Simon mo, Yesus ihete nanai tau Petrus), ");
INSERT INTO nxl_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobis runa wanin Yohanis (uaso noa ama tau Sebedeus. Yesus ihete nanao tau Boanerges Nene nohue mo, sio sani tinaa), ");
INSERT INTO nxl_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anreas, Pilipus, Bartolomeus, Matius, Tomas, Yakobis (amai tau Alpeus), Tadeus, Simon, ia wain ipenei tau sio Romau orime ita Israel, ");
INSERT INTO nxl_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","runa Yudas Iskariot, ia wain mka iahen Yesus na sio ohunui. ");
INSERT INTO nxl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesus inuniki on roe pupue, oyo inusui pan numa isa. Ne mansia hutue ohoka oamanouso honu rotu-tu Yesus runa ne mampusua oai mosa tewa. ");
INSERT INTO nxl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ne mansiau oatinu san rei, oyo oeu osotai. Tea mo, sio panesi oasau ata, “Imukei nea.” Sio oasau san rei tau iai tewa. ");
INSERT INTO nxl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Sio matuhete Musa ne maunauna wason ohokaso on roe kota Yerusalem oasau ata, “Beelsebul remasuniki! Ia mo, wain inei sakahatene tau Beelsebul, ia aia sakahatene, ne kawasa.” ");
INSERT INTO nxl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Oyo Yesus ioi sio hutue rei, samatoro iaunauso tau matieua. Iahata, “Sapan na ia aia sakahatene renei sakahatene? ");
INSERT INTO nxl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Munata sio niane owena-wenaso, areimo niane rei huie nea. ");
INSERT INTO nxl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Munata ipane isa rewena-wenai, areimo ipane rei tihoniki nea. ");
INSERT INTO nxl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Reiso munata ia aia sakahatene inei ruai ne mansiau na owena-wenaso, mka ia aia sakahatene ne kawasa tanso tewa nea. ");
INSERT INTO nxl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Noo sani ia isa nanie inusui pan ia isa wain iamkona ne numa na ikimanaka ne apia. Ne kahurae ikanihoo ia mkonae rei ee. Ikanihooi, samatoro inusui ikimanaka ne apia.” (Yesus ianamana rerihoni ruai sani ia wain ikanihoo ia mkonae rei. Ikanihooi, areimo sani inanaia aia sakahatene ne kawasa.) ");
INSERT INTO nxl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Atinu mai ia-ia, nanie uasau osimo. Anahatana isiru heu rosa sae man. Orati sohi Anahatana, Anahatana isiru heu no rosa rei. ");
INSERT INTO nxl_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ne sani munata orati sohi Anahatana Ne Inaha, areimo Anahatana mka isiru heu no rosa rei tewa rotu-tu ria supan.” ");
INSERT INTO nxl_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iasau san rei tau sio oasau ata, “Sakahatene remasuniki.” ");
INSERT INTO nxl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yesus iatuhete pan numa anoe, inai runa nea waniu ohokaso. Ooso pan mui, oyo oaisosi ia isa ioi Yesus. ");
INSERT INTO nxl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Sio mansia hutue wason orue ohoriki. Oyo ia rei iasau osiki ata, “Masi anoo. Inam runa me waniu wason pan mui oninaya.” ");
INSERT INTO nxl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Iahata, “Ia seia sahoro inaku? Ia seia sahoro waniku?” ");
INSERT INTO nxl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Oyo inoo ineka pusi sio wason orue ohoriki rei, oyo iahata, “Omi reini pusimo sahoro inaku runa wea waniu. ");
INSERT INTO nxl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ia seia man wain ipusu Anahatana ne maue, ia rei sahoro anoku runai sani waniku, hotaku, runa inaku.” ");
INSERT INTO nxl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesus wain iatuheteso honu mai Wae Galilea nusue. Sio panesi oo ohoriki. Sio hutue rei ouna patapariki reiso isaai pan arupai anoe oyo iruei pan rei. Arupae rei wani remanu-manui. Oo sio hutue rei wasora waene nusue. ");
INSERT INTO nxl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Oyo Yesus iatuheteso tau matieua. Iatuheteso san rei, ");
INSERT INTO nxl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Oatinu. Taue isa, ia mamrahue isa ieui iahurara atuhu kania noi ne nisi, ne umau ramnahuso noi arena tiae. Oyo manua ratasoho raaire. ");
INSERT INTO nxl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Iahurara atuhu kania rai, oo umau ramnahu arena tiae. Oyo manua ratasoho raaire rotu-tu pusire. ");
INSERT INTO nxl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Atuhu kania umau honu ramnahu tuama hatu leka wan tuamane mkane man. Atuhu kania rai raruhu sansana man. Tea mo, tuamane kamanite man. ");
INSERT INTO nxl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Oyo ranie katopu san rei, atuhu tuhua rai ramnunuso rakaimenso, oyo ramataso. Tea mo, namta rakaisunu hainau tewa tau tuamane kamanite man. ");
INSERT INTO nxl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Atuhu kania umau honu ramnahu mono unia. Oyo mono unia rai raruhu rasapa atuhu tuhua rai, reiso rauhua tewa. ");
INSERT INTO nxl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Atuhu kania umau honu, ramnahu tuama iake. Taa raruhuso roe, nene huaya panesi ranesi sae waron irahure rei. Kanie osa nene huaya utun.” ");
INSERT INTO nxl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesus iruni matieue pusi oyo iakapona, “Ia sia tinai ukuna mo, kahurae atinu ia-ia!” ");
INSERT INTO nxl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesus wain ruai man. Ia isa ikatai tewa nea. Oyo sio hutusa rahana ua rei runa sio umau honu oasei tanui rerihoni matieue rei. ");
INSERT INTO nxl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Reiso Yesus iasau osiso ata, “Anahatana ihuka omi, we mampusua, anomo nea. Reiso oanei sapan na irime ne mansiau. Ne uruni matieua osi sio wason we mampusua tewa ");
INSERT INTO nxl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","na ‘Onoo runa oatinu, ne oanei tewa. Munata oanei, mka anoo rauni rapusu Anahatana oyo Anahatana isiru heu no rosau.’” ");
INSERT INTO nxl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Oyo Yesus iasau osiso ata, “Munata oanei matieue rei tewa, sapani na oanei matieua umau honu? ");
INSERT INTO nxl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ia mamrahue mo, nooi sani ia wain iaunau rerihoni Anahatana ne anamanaya. ");
INSERT INTO nxl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Atuhu kania waron ramnahu arena tiae mo, noore sani sio wason oatinu Anahatana ne anamanaya ne oaneire tewa. Ia aia sakahatene ihoka, oyo iuna anoo kanihua runa sae wan ia mamrahue rei irahui pan anoo rei. ");
INSERT INTO nxl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Atuhu kania waron ramnahu hatu lekau mo, noore sani sio wason oatinu Anahatana ne anamanaya, anoo mirika. Oyo sira tau oparisaa tau Anahatana tewa nea. ");
INSERT INTO nxl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ne anamanaya rai nene namta pan anoo tewa. Reiso oapamese kua tewa. Osupu susa te sio umau ounaso sinsaraso noso oparisaa tau anamanaya rai, oyo oarihonre rei sirinia. ");
INSERT INTO nxl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Atuhu kania waron ramnahu mono unia mo, noore san sio wason oatinu anamanaya rai, ");
INSERT INTO nxl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ne anoo rauponu runa tuniai reini. Nanie onina kepen runa apia panesi man. Reiso Anahatana ne anamanaya rasapa pan anoo. Reiso sio mo, sani atuhu waron rauhua tewa rei. ");
INSERT INTO nxl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Atuhu kania waron ramnahu tuama iake mo, noore sani sio wason oatinu Anahatana ne anamanaya rai, oyo oatarimare. No haliu pannuhu runa Anahatana ne anamanaya. Sio reimo sani atuhu waron rahua panesi. Umau rasupu hutu tonu, umau hutu nome, umau honu, rasupu utun.” ");
INSERT INTO nxl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesus iasei tau ne mampusua ata, “Sani sio orori kamane, mka osoui tau parten? Te, oaunutui poe koi nohue? Areim tewa tea! Ne kahurae oaunutui roe kamane aie na resita pusi numa anoe. ");
INSERT INTO nxl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Sae wan reuhuniki mo, mka rehokai mai manahane. Sae man wan oauhuniki, mka sio oaneiki sinia. ");
INSERT INTO nxl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ia sia tinai ukuna mo, kahurae iatinu ia-ia. ");
INSERT INTO nxl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Oarinii sae waron oatinure rei. Sani Anahatana irui osimo, areimo mka ipake supa wan opakei tau orenu osi sio umau rei oi. Ne mka osupu renesi sae wan oruiki rei. ");
INSERT INTO nxl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ia sia man wain ianei we maunauna nea, mka Anahatana ihuka anoi na ianei renesi honu. Ne ia sia waini ianeire tewa, mka Anahatana inea sae waron ianeire nea rei.” ");
INSERT INTO nxl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesus iatuhete ne mampusua honu. Iahata, “Anahatana irime ne mansiau mo, ita ianei tewa nooi sapan. Areini mo, nooi sani ia mamrahue wain iahurara atuhu kania poe tuamane. ");
INSERT INTO nxl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tau mono pan, ia mamrahue rei inekei, tau ranie ihanui. Ne tau inekei ihanu, oyo inoo atuhu kania rai raruhu. Raruhu rotu-tu mainaya. Ne ia mamrahue rei ianei tewa ata atuhu kania rai mo, raruhu sapan. ");
INSERT INTO nxl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tuamane rei ruae sahoro reuna atuhu kania rai raruhu. Mataanoe tuhua, oyo noena, samatoro huaya. ");
INSERT INTO nxl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Sani huaya mtuaya nea, oyo ia mamrahue rei ikurere. Tea mo, nania nea.” ");
INSERT INTO nxl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesus iatuhete ne mampusua honu. Iahata, “Anahatana irime ne mansiau mo, nooi sani sae? Au nanie uruni matieue isa osimo na oanei rerihoni Anahatana irime ne mansiau mo, sapan. ");
INSERT INTO nxl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Irime ne mansiau mo, nooi sani kanapua kanie wan orahui poe tuamane. Kanie reimo, kanie wan ohie nai osa. Areimo, sani mataanoe sio panesi opusu Anahatana tewasi. ");
INSERT INTO nxl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Sani munata kanapua kanie rei reruhu, mka reruhu mainae nai osa. Nene sanaya mainaya, rotu-tu manua rarihu ratasoho rauna nene nanone rapusu sanaya nohua.” ");
INSERT INTO nxl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesus iatuhete tau matieua panesi san rei, areimo inoo pusu ia seia man wain ianei mosa maunauna rai. ");
INSERT INTO nxl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Yesus iatuhete mansia hutue tau matieua man. Ne mampusua iae, iaunauso tau matieua oi, ne isima runa nene nohue osiso. ");
INSERT INTO nxl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Taue isa, tau ran manne, Yesus iasau osi ne mampusua ata, “Mai, na isaa arupai na ieuta ria hae.” ");
INSERT INTO nxl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yesus wain iru-ruei pan arupai anoe nea, oyo ne mampusua oeu oarihoni sio hutue nau waene nusue, samatoro osaa opusu Yesus pan arupai anoe. Nau rei iae, arupaiu tamena waronau oi. ");
INSERT INTO nxl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Potuina tewa oyo sira tau ihu onate reutenu waene rotu-tu reuna kolau rahita-hita arupai rei. Reiso waene renusu pan arupai anoe rotu-tu haineke taue nea. ");
INSERT INTO nxl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesus wain inekei pan arupai rei nene muie. Inekei inaka unui roe kanakuru. Ne mampusua ohanui, oyo oasau ata, “Ano Matuhetene, Ano mo, anom iake? Mka imokota nea reini!” ");
INSERT INTO nxl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesus ihanui, oyo iasau na nioi makae tau ihute rei. Iasau osi waene rei. Iahata, “Apurumenea! Amaturua!” Oyo ihute rei rematurui. Waene rei remanu. ");
INSERT INTO nxl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Oyo Yesus iasau osi ne mampusua, “Omi okaitau tahae? Oparisaa tau Au tewa tahae?” ");
INSERT INTO nxl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Reiso okaitau. Oasei mai umau, “Ia onate reini mo, ia sia? Ihute runa kolau man iae, ratinu tanui!” ");
INSERT INTO nxl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesus runa ne mampusua ohokaso ria Wae Galilea ria hae, ria otoe Gerasa. ");
INSERT INTO nxl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Hoka ria oyo, osipuso oarihoni no arupai rei. Oyo, sira tau ia isa wain sakahatene remasuniki ihokai mai Yesus. Ihokai on ria hatu nohua. ");
INSERT INTO nxl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ia reimo iruei ria hatu nohua. Sio okanihoo kuai tewa nea. Tau rante iae, okanihoo kuai tewa oi. ");
INSERT INTO nxl_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Naone okanihoo hanai ain, ne iuna roha rante rai arihon hanai ain. Ia rei mo, iamkona, reiso oapamese kuai tewa. ");
INSERT INTO nxl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ieu onon ranie pan hatu nohua rai sirinia. Roe pupua iaka-kapona iasa-sanoata. Ihita ruai tau hatu rotu-tu ne apata. ");
INSERT INTO nxl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","Taa inoo Yesus on nau hainau, oyo irumai mai tanui irike tune. Oyo Yesus iaisosi sakahatene rei. Iahata, “Ohokaya!” Irike tune oyo, iakapona nioi mainae. Iahata, “Yesus, Anahatana wain Ia Mainae Anai, nanie amunaku? Uainisi tau Anahatana nanai, pene auna sinsaraku.” ");
INSERT INTO nxl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Oyo Yesus iasei tanui, “Nanam sia?” Iahata, “Au mo, nanaku ‘Panesi’. Tau ami mo, am panesi.” ");
INSERT INTO nxl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Oyo iainisi arihoni Yesus. Iahata, “Pene aneima arihon tihue reini.” ");
INSERT INTO nxl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ne hahu panesi waruro ranina muaia roe sanene pupue hainekeso. ");
INSERT INTO nxl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Sakahatena rai raainisi arihon Yesus ata, “Yesus ee! Sani nanie aneima mo, aisosima anusuma pan hahu raro!” ");
INSERT INTO nxl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Oyo Yesus iasau ata, “E-e! Eumo na nusumo pan hahu raro nea!” Pusi oyo, sakahatena rai rahokaso arihon ia rei, samatoro oeuso onususo pani hahu rai. Hahu raimo kani nihu ua. Oyo hahu rai raruma rapu pusu ekote hanae rei rotu-tu rasoman na poe waene. Oyo ramokoso, oyo ramataso. ");
INSERT INTO nxl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Reiso, sio mamsaka hahu rai orumaso nanie osima osi sio ria niane runa sio sui nisiu. Osima, oyo pusiso ohoka, nanie onoo. ");
INSERT INTO nxl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Hoka nau oyo, onoo ia hanaie wain naone sakahatena ramasuniki rei. Onooi waipo iruei iausahu apia nea na imuke tewa nea. Reiso pusiso okaitau. ");
INSERT INTO nxl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Oyo sio wason onoo pusire sinasi rei, orun ria nau rerihoni Yesus inei sakahatena arihon ia hanaie rei. Oruni runa sapan na iaisosi sakahatena rai ranusu tau hahu rai. ");
INSERT INTO nxl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Oyo pusiso oainisi tau Yesus ata, “Upu. Aeua arihoni ma otoe reini nea.” ");
INSERT INTO nxl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Reiso, Yesus isaa no arupai wan sinasi rei. Oyo ia wain naone sakahatena ramasuniki rei, iainisi arihoni Yesus ata, “Upu! Ueu upusua oi kee!” ");
INSERT INTO nxl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ne Yesus iamanaku tewa. Iata, “Nunia na asima osi me mansiau rerihoni sapan na Upum iunaya iake nea reini. Asima runa sapani na anoi runaya.” ");
INSERT INTO nxl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Pusi oyo, Yesus sio osaa no arupai wan sinasi rei. Oyo, ia rei ieu iruni osi mansiau sui Niana Hutusa rai rerihoni Yesus inei sakahatena arihoniki rei. Sio pusiso oatinui, osira. ");
INSERT INTO nxl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesus inuniki on ria Gerasa isaa arupai nanie ieui nau waene on nau hae. Hoka nau oyo, sio panesi oamanouso ohoriki nau waene rei nusue. ");
INSERT INTO nxl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ia onate isa inoo Yesus. Oyo sira tau ihoka poe, irike tune mai Yesus uai anoe. Ia onate rei mo, nanai Yairus. Ia mo, ia onate tau sio Yahudiu no numa mananoune. ");
INSERT INTO nxl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Oyo iainisi tau Yesus ata, “Upu. Anaku pina waipo ikupui mtinte. Masi apusuku mai, na aeua poe, akahuui tau hanam, na ikarihuru iamahai ee. Pene imatai ee.” ");
INSERT INTO nxl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Reiso, Yesus ieu ikata Yairus. Sio panesi rei opusu Yesus oi. Sio rei oesei on ria, on nau. ");
INSERT INTO nxl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ia pina isa wain ieu nasi musum hutusa rahana ua nea waimo ikata sio panesi rei oi. ");
INSERT INTO nxl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Inun nana sui sio mamsuisenea nea, rotu-tu ne kepen runa ne apia pusire nea. Ne, kupue rei iake tewa sirinia. Kupue rei mtinte rekapena honu. ");
INSERT INTO nxl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Iatinu sio orun ria nau rerihoni Yesus. Reiso ieu pusu-pusu Yesus totui nanie ieu hainekei, oyo isii ne papi naue. ");
INSERT INTO nxl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Iasau pan anoi ata, “Hete sae usii ne papite man oo, we kupue rein iake rei sirinia.” ");
INSERT INTO nxl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Reiso isii ne papite, oyo nasi rerihon rei sirinia. Iahana ata ne kupue rei iake nea. ");
INSERT INTO nxl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesus iae, iahana noo sani ne mkonae rekaisunu mkane. Reiso inoo hae muie na inoo sio panesi rei, oyo iasei ata, “Ia sia isii we papite rei ano?” ");
INSERT INTO nxl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ne mampusua oasau ata, “Upu. Anoo sio hutue reini wason oesea on ria on nau reini tewa? Reiso, nanie asei ata ia seia isii me papite rei nan tahae?” ");
INSERT INTO nxl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ne Yesus inoo neka pusiso, na nanie isupu ia seia wain isii ne papite sinasi rei. ");
INSERT INTO nxl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Oyo ia pina wain isii Yesus ne papite sinasi rei, ianei ata ne kupue rei iake nea. Reiso ikana-kananunui. Ikaitau isima na ruai. Oyo irike tune mai Yesus uai anoe, iakapuni ain, oyo isima runa pusire. ");
INSERT INTO nxl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Reiso, Yesus iasau osiki ata, “Anaku. Aparisaa tanuku, reiso me kupue rei iake rei sinia. Aeua noi, akarihuru amahai. Mka asupu kupue rei tewa nea.” ");
INSERT INTO nxl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Reiso wain ianamana osiki asi, sira tau sio umau ohoka on pan Yairus, ia onate wain sinasi rei, ne numa. Hoka poe oyo, oasau ata, “Upu. Anam pina watipusi nahai nea. Reiso pene auna apaputa ia matuhetene reino nea.” ");
INSERT INTO nxl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ne Yesus iatinu tau sio rei tewa. Iasau osi ia onate rei, ata, “Pene akaitau. Aparisaa man.” ");
INSERT INTO nxl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Oyo Yesus isopo na pene ia isa man inusu katai. Hasae Petrus, Yakobis, runa wanin Yohanis man. ");
INSERT INTO nxl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Hokaso poe ia onate rei ne numa oyo, onoo sio panesi ouna purie mainae nai osa. Wason orani, ohiti, oasanoata. ");
INSERT INTO nxl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Oyo Yesus inusui pan numa rei, iasei tanso ata, “Omi ouna purie, orani oasanoata, nan tahae? Ia iki pina reini mo, imata tewa. Ne wain inekei man!” ");
INSERT INTO nxl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Iasau san rei oyo, sio panesi rei oaumaniki. Reiso iaisosi sio pusiso ohokaso. Oyo ikata ia iki pina rei ne mansia mainaya runa sio mampusua ton rei man pan ia ikine rei ne kamar. ");
INSERT INTO nxl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Oyo irime ia iki pina rei hanai, iasau osiki ata, “Talita kum.” (Nene nohue mo, anaku pina, ahanua.) ");
INSERT INTO nxl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Oyo tau rei sinia ihanu ihitioi. (Ia iki pina rei ne musum hutusa rahana ua nea.) Ihanui oyo, ieui. Sio pusiso wason onoo rei, osira hun ruao nai osa. ");
INSERT INTO nxl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Oyo Yesus isopo sio pusiso ata, “Pene oeu orun osi ia sia man. Ne mai, na opanai.” ");
INSERT INTO nxl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesus iapuhai ia iki pina rei pusi oyo, ieu arihoni otoe rei. Inuniki poe ruai ne niane ikata ne mampusua. ");
INSERT INTO nxl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Hoka poe oyo iatuhete tau ranie hatae wan ita Yahudiu iamuira Anahatana pan re numa mananoune. Sio panesi wason pan rei oi. Iatuheteso oyo sio wason oatinu rei, osira. Oasei, “Ia reini mo, isupu ne maunauna rai on supa? Ianei sae waron iaka runa sae waron iaka tewa on supa? Sapan na imaha iuna sima-simana arihon Anahatana rei? ");
INSERT INTO nxl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ia reini mo, ia mamnana numa si? Maria anai si? Ia mo, Yakobis, Yoses, Yudas, runa Simon kakai. Nea hotau iae orue mai rei oi.” Reiso sio rei openeso tanui. Openeso oatin tanui nea. ");
INSERT INTO nxl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesus iahata, “Ia mamsima runa Anahatana ne maunauna mo, oamuirai sui supan. Hasae ia ruai ne niane, ne ipane taue, ne enau sahoro oamuirai tewa.” ");
INSERT INTO nxl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Pan kota rei, Yesus iuna sima-simane arihon Anahatana isa tewa oi. Hasae isuisene sio kupua mkana man. Iahusieso man oyo iake rei sirinia. ");
INSERT INTO nxl_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Isira ata oparisaa tanui tewa. Oyo ieui iatuhete neka niana-niana. ");
INSERT INTO nxl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesus ianaha na ne mampusua hutusa rahana ua rei. Pusiso oamanouso oyo iaisosiso oeu sana ua-ua. Irui kawasa osiso na onei sakahatena. ");
INSERT INTO nxl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Iaisosiso ata, “Pene orori sae man. Pene orori weka te, tasi te, kepen te. Pene oi. Hasae orori toka-toka man. ");
INSERT INTO nxl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Oausahu sandaliu. Ne pene orori papite tau okati. Orori hasae osa man. ");
INSERT INTO nxl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Sani munata onusu pan numa isa, orue tau numa rei rotu-tu oeu oarihon niane rei. ");
INSERT INTO nxl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ne munata ohokamo noi niane isa, oyo oapusaamo tewa, areimo oeumo arihon niane rei. Ne munata openeso oatinu tanumo, areimo oeu arihonso. Oroho heu tapuna arihoni aimo atua na oanei ata Anahatana inooso osana. Sio osana tau atinu tau ne maunaune tewa.” ");
INSERT INTO nxl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Reiso, Yesus ne mampusua hutusa rahana ua rei oeu oaunau. Oahata, “Ita kahurae iarihon re rosau.” ");
INSERT INTO nxl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Oeu onei sakahatena panesi na oauhene sio kupua tau weketisie na osuiseneso. ");
INSERT INTO nxl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tau Yesus sio oeu osuisene rei, Herodes sahoro iuna aia. Herodes iatinu rerihoni Yesus ne atata. Tea mo, sio panesi oanei Yesus nanai sui supan man. Sio umau oahata, “Anahatana iuna Yohanis ia mamsohue iamahaiki honu! Reiso ne kawasa iuna sima-simana rai.” ");
INSERT INTO nxl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ne sio umau honu oasau ata, “Ia mo, Elia.” Sio umau honu oasau ata, “Ia mo, ia mamsima runa Anahatana ne maunauna isa sani sio mamsimaya naone.” ");
INSERT INTO nxl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodes iatinu san rei oyo, iahata, “Mansate, ia reini mo, Yohanis ia mamsohue wain naone uaisosiso onana unui rei tea! Wain iamahaiki honu.” ");
INSERT INTO nxl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tea mo, naone Herodes iaisosi sio umau na osota Yohanis na onusui pan pui anoe. Iuna san rei noso Herodias. Herodias mo, wanin Pilipus sahai. Ne Herodes inanai tau sahai nea. Aikee Pilipus mo, imata tewasi. ");
INSERT INTO nxl_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Reiso Yohanis ia mamsohue iaunaui ata, “Pusu Musa ne maunauna mo, iake tewa sani anana wanim pina.” ");
INSERT INTO nxl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Reiso Herodias iakapuku tau Yohanis, nanie ihunui. ");
INSERT INTO nxl_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ne Herodes inetei na pene ihunui. Iaisosi sio umau osaka Yohanis ia-ia na pene sio umau oakaremai. Tea mo, Herodes ikaitau Yohanis. Ianei ata Yohanis mo, anoi manisate. Ia manisate onate. Sani Yohanis iaunau mo, Herodes ne suka iatinu. Masike anoi resama-samai tau Yohanis ne maunauna rai iae, ne suka iatinu tanui sinia. ");
INSERT INTO nxl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ne taue isa Herodias isupu arena na ihunu Yohanis sirinia. Herodes ne musum manisata oyo, iuna karisaa. Ianaha na sio onata arihon kupania, sio tantarau, runa sio onata pusiso sui otoe Galilea. ");
INSERT INTO nxl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tau karisaa rei, Herodias anai pina imarai. Herodes runa sio onata wason ianaha runaso rei pusiso no suka oasumatai. ");
INSERT INTO nxl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Reiso Herodes isopa san rei, “Sae man wan ainisiki arihoniku rei mo, mka uruiki osia. Masike ainisi we tuamane samatihue iae, mka uruiki osia oi.” ");
INSERT INTO nxl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Oyo ia pina hehuke rei ihokai arihoni sio panesi rei, na nanie iasei tau inai. Iahata, “Ina. Nene iake mo, uainisi sae?” Iahata, “Ainisi Yohanis ia mamsohue unui.” ");
INSERT INTO nxl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mata hun tewa oi, inuniki mai Herodes honu. Oyo iahata, “Nanie uainisi Yohanis ia mamsohue unui. Aroriki sansana mai. Aunutui roe loyan anoe!” ");
INSERT INTO nxl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodes iatin sae wan iainisiki rei oyo, anoi mtinte. Nanie ipenei, ne isopa nea. Sio wason opusu karisaa rei iae, oatinui nea oi. ");
INSERT INTO nxl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Reiso iaisosi ia mamhunue isa na inana Yohanis ia mamsohue unui. Reiso ia mamhunue rei, ieui poe pui, oyo iroto roha Yohanis tionai. Iroto roha tionai pusi, ");
INSERT INTO nxl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","oyo irori unuke rei tau loyan. Iruiki osi ia pina hehuke rei samatoro ia pina hehuke rei irui unuke rei osi inai honu. ");
INSERT INTO nxl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yohanis ne mampusua oatin san rei oyo, oeu onana Yohanis hatai, samatoro oaunutui pan hatu nohue. ");
INSERT INTO nxl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesus ne maisosia oeu oaunau oyo onunso. Hoka mai, oyo oamanouso. Oamanouso na osima runa sae waron ounare rei osiki runa oaunau sapan. ");
INSERT INTO nxl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ne sio panesi onusu ohoka mai Yesus rotu-tu Ia runa ne mampusua oai mosa tewa. Reiso Yesus iasau osiso ata, “Mai na ieuta pan otoe huie isa na oaranahamo mkane.” ");
INSERT INTO nxl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Reiso osaa arupai, oeuso pan otoe huie. ");
INSERT INTO nxl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ne oeuso rei, sio panesi onoo. Oationaso. Reiso sio panesi arihoni niana pusire pan otoe reipa oruma oanaoneso pusu rukene, nanie osupu Yesus runa ne mampusua. ");
INSERT INTO nxl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesus sio ohokaso on nau hae, nanie osipuso arihon no arupai rei. Inoo sio hutue rei, anoi runaso. Tea mo, sio sani rompau wason no ia mamsakae tewa. Reiso iatuhete panesi osiso. ");
INSERT INTO nxl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Taa resou-sou san rei, oyo sio mampusua ohokaso mai Yesus oahata, “Upu. Wapan haineke pumono nea. Otoe reini mo, huie. ");
INSERT INTO nxl_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nene iake mo, aisosi sio hutue rei na oeuso na ohane muaine sui niana-niana waroni rahaineke otoe reini.” ");
INSERT INTO nxl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ne iahata, “Omi sahoro opanaso.” Oahata, “Ira oe! Mka ahane poroti osi sio panesi rei sapan? Arai ranana kepen panesi.” ");
INSERT INTO nxl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Iahata, “Oeu onoo. Porotiu hua ina waromo?” Oeu onoo oyo, osima ata, “Porotiu hua nima waron runa ika use ua man.” ");
INSERT INTO nxl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Oyo Yesus iaisosi sio pusiso orue tumun-tumun poe monota hutua. ");
INSERT INTO nxl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Sio pusiso orue tumun-tumun. Sio utun oamanouso tau osa. Sio hutu nima oamanouso tau osa. ");
INSERT INTO nxl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Oyo Yesus inana porotiu hua nima rai runa ikaya use ua rai. Ikatare oyo iarinaa na roe nante. Iahata, “Ama. Uainisi iake arihonia. Tea mo, arui muaina raini osima.” Iasau san rei oyo, ikuparehi porotiu rai mkana-mkana tau hanai, oyo iruire osi ne mampusua, inina na osamare osi sio panesi rei. Oyo isama ikaya use ua rai osi pusiso oi. ");
INSERT INTO nxl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Oyo sio pusiso oaiso rotu-tu tiao pokona nea. ");
INSERT INTO nxl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Oaiso suka, oyo sio mampusua oamanou porotiu runa ikaya nesia rai. Nesia rai, oamanoure tau pakuna hutusa rahana ua rotu-tu taua. ");
INSERT INTO nxl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tau sio hutue rei mo, sio hanaia, sio mainaya nihu nima oai muaina rai runa sio pinau runa sio ikina oi. ");
INSERT INTO nxl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yesus ipana sio hutue rei pusi, mata hun tewa oi, oyo iaisosi ne mampusua oeuso oanaone tau arupai pan nia Betsaida, pan hae. Oo, ia ruai iaisosi sio hutue rei onunso. ");
INSERT INTO nxl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pusiso onunso samatoro Yesus ieu roe pupue, nanie iainisi tau Anahatana. ");
INSERT INTO nxl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nene pumono pan san rei oyo, ne mampusua runa no arupai rei wasonau waene tihue nea. Ne Yesus ruai waira rukene asi. ");
INSERT INTO nxl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Inoo ata omankaeso, osai kua no arupai tewa nea tau ihute on nau uae. Oyo nene kinoke san rei, ieui pan tanso. Ieu tau ain roe waene hahae. Hoka pan oyo, ieu sani nanie inikuso. ");
INSERT INTO nxl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Onooi ieu roe waene hahae sio ata kan sakahatene. Reiso oasanoata. ");
INSERT INTO nxl_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tea mo, onooi, oyo okaitau hun ruao. Oyo sira tau iasau ata, “Apamese anomo. Au ruaku rein tea! Pene okaitau.” ");
INSERT INTO nxl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Oyo isaa pan tanso, pan arupai rei. Isaa oyo, ihute rei repurumene. Sio mampusua osira hun ruao. ");
INSERT INTO nxl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Osira hun ruao, tea mo, potusi Yesus inana porotiu hua nima iunare tau panesi. Oanei tewasi ata sima-simane arihoni Anahatana rei nene nohue sapan. Oanei resun. ");
INSERT INTO nxl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Reiso ohokaso pan hae, oyo opesi hatu aie pan tihue wan nanae Genesaret. ");
INSERT INTO nxl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Hoka pan oyo, osipuso arihon no arupai rei. Osipuso poe, oyo sio pusiso pan rei oationa Yesus. ");
INSERT INTO nxl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Reiso ohori otoe rei, orori sio kupua mai Yesus tau kinoa. Munata oatinu ata Yesus waipan otoe isa, orori sio kupua pan otoe rei oi. ");
INSERT INTO nxl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Sui supan man Yesus ihokai, pan niana, noi nisiu, orori sio kupua pan tanui oi. Sio oamanouso sui osa. Oyo oainisi tanui. Oahata, “Upu. Pene asopo sio kupua osii me papite aie. Masike hasae me papite aie iae, pene asoposo.” Sio pusiso sani osiiki mo, no kupue iake rei sinia. ");
INSERT INTO nxl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Sio onata arihon akama Yahudi runa sio matuhete Musa ne maunauna mato ohokaso arihon kota Yerusalem, oyo oamanouso mai Yesus. ");
INSERT INTO nxl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Onoo Yesus ne mampusua umau oaiso osohu hanao tewa. Opusu no upu no monne tewa. ");
INSERT INTO nxl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Sio onata rei runa sio Yahudiu pusiso opusu no upu momou no monna ia-ia. No monna waron rakai-kaisunu osiso. Reiso osohu hanao samatoro oaiso. ");
INSERT INTO nxl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Muaina waron ohanei mo, osohui tewasi mo, pene oaiki. Orime kuru no upu momou no monna panesi waron rakai-kaisunu osiso. Monna sani osohu no koinanaya, piruna, runa parteniu. ");
INSERT INTO nxl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Reiso sio onata runa sio matuhete Musa ne maunauna oasei tau Yesus ata, “Ano me mampusua opusu rea upu momou no monna waron rakai-kaisunu osita tewa, tahae? Sapan na oaiso osohu hanao opusu monne tewa?” ");
INSERT INTO nxl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iahata, “Omi oasei oreaku. Naone Yesaya isima rerihoni mo haliu on oamrai tewasi mo, sapan. Isima pannuhu. Iahata Anahatana iasau san rei, ‘Sio reini mo, oamuiraku. Ne oamuiraku hasae roe hohao man, ne anoo hainau arihoni Au. ");
INSERT INTO nxl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Sio oainisi oainaa runa Au tau sae isa tewa tau sio oatuheteso tau mansiau no maunauna sani Au we maunauna. Aikee Au we maunauna mo, san rei tewa.’ ");
INSERT INTO nxl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Anahatana ne maunauna mo, omi oarihonre. Ne mansiau no monna mo, orime kurure. ");
INSERT INTO nxl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Oanei ia-ia openemo tau Anahatana ne maunauna. Opesi ne maunauna rai na opusu ruamo mo monna. ");
INSERT INTO nxl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musa iaunau san rei nea, ‘Amuira inam na amam. Ia seia man ianamana kahatene rerihoni inai na amai mo, kahurae oaresiki, oyo ohunui.’ ");
INSERT INTO nxl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ne omi oaunau san reini. Munata ia isa iasau tau inai te amai mo, ata, ‘Sae man kahurae uruiki osimo, uruiki osi Anahatana nea.’ ");
INSERT INTO nxl_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Sani ia rei iakahai inai na amai tewa, omi oasau ata iake. ");
INSERT INTO nxl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Reiso tau monne san rei, omi oruiki osiso, ouni Anahatana ne anamanaya. Mo atata panesi san rei.” ");
INSERT INTO nxl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Oyo Yesus ianaha na sio panesi honu samatoro iasau osiso ata, “Oatinu na oanei! ");
INSERT INTO nxl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Sae isa wapan manahane, sani renusui mai anori, reuna Anahatana inoo ita iapaputi ruari. Ne sae man wan rehokai arihoni mansia, areimo reuna Anahatana inoo ita iapaputi ruari. ");
INSERT INTO nxl_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ia sia tinai ukuna mo, kahurae iatinu ia-ia!” ");
INSERT INTO nxl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesus ieui arihon sio panesi rei, oyo inusui pan numa isa, samatoro ne mampusua oasei ata, “Upu. Matieue rei nene nohue sae?” ");
INSERT INTO nxl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Iahata, “Oanei tewasi? Oanei tewa ata sae man wan iaiki reunata iapaputi ruari tewa? ");
INSERT INTO nxl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Sae wan ita iaiki renusu pan tiari man, oyo ieu heui honu.” Pusu anamanaya rai, Yesus iasau ata ita iai muai sae man iae iake. ");
INSERT INTO nxl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Oyo Yesus iasau honu ata, “Sae wani rehoka arihoni anori, areimo reunata iapaputi ruari. ");
INSERT INTO nxl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","On pan anori rahoka sae man wan kahatena waron rauna ita ikaparua, ikimanaka, ihunu, ");
INSERT INTO nxl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","isahu-sahu re pina hanai, nanie inana sio umau no apia, iakahate, iakarota, iamuira tewa, ianana, iruni mansia, ihatie ruari, iarinii tewa. ");
INSERT INTO nxl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Re huna-hunau rai rahoka arihon anori, oyo rauna Anahatana inoo ata iapaputi ruari.” ");
INSERT INTO nxl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Oyo Yesus ieui iarihoni otoe rei nanie ieui poe otoe wan rehaineke kota Tirus. Hoka poe oyo, inusui iauhuniki pan numa isa. Ipenei tau sio oanei ata wain ihokai nea. Ne masike san rei iae, mansia oatinu sinia ata waipo ihokai. ");
INSERT INTO nxl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mata hun tewa oyo, ia pina isa iatinu ata wain ihokai nea. Reiso ihokai mai tanui. Hoka mai oyo, irike tune mai uai anoe. Ia pina rei anai pina isa, sakahatene remasuniki. ");
INSERT INTO nxl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ia mo, ia Yahudi tewa. Ia rakane. Ianamana sou Yunani. Iamrai poe otoe isa wan nanae Penisia poe otoe Siria. Reiso irike tune mai uai anoe iahata, “Upu. Uainisi arihonia na anei sakahatene arihon anaku pina.” ");
INSERT INTO nxl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Oyo Yesus ianamana rerihoni sio Yahudiu san sio ikina. Iahata, “Kahurae opana sio ikina naone. Sani onana sio ikina no muaine, oyo opesiki osi asu, areimo iake tewa.” ");
INSERT INTO nxl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Iahata, “Titue Upu. Ne asu wan poe tuamane reai muaine nesia waron sio ikina ouna amnahure.” ");
INSERT INTO nxl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Iahata, “Ano asana iake, reiso masi anunia. Sakahatene rehokai arihon anam pina nea.” ");
INSERT INTO nxl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Oyo inuniki. Ihokai pan numa, oyo isupu anai rei inekei roe naniai. Sakahatene rei rehokai arihoniki nea. ");
INSERT INTO nxl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesus ieui arihoni otoe wani nanae Tirus, oyo ieu poe nia Sidon. Oyo ieu ria otoe wan nanae Niana Hutusa, samatoro ihokai mai Wae Galilea. ");
INSERT INTO nxl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Hoka mai oyo, sio umau orori ia isa wain iaririe na iakumoui osiki. Oainisi ata, “Upu. Akahuui tau hanam ee.” ");
INSERT INTO nxl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesus inana ia rei arihon sio hutue wason pan rei, oyo isipa hanai nakata pan tinai ukuna. Oyo ihuto na isii ia rei mein. ");
INSERT INTO nxl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Isiiki, samatoro iarinaa na roe nante, inuse saena, oyo iasau osiki tau Ia ne sou, “Efata.” Nene nohue mo, Huka nea. ");
INSERT INTO nxl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Iasau san rei oyo, tinai ukuna rahuka. Iatinu iake nea. Mein manne nea. Ianamana iake nea. ");
INSERT INTO nxl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Oyo Yesus isopo na pene oeu osima osi ia seia man. Yesus isopo sui osa. Ne sio oeu orun suru ria, suru nau osi sio panesi. ");
INSERT INTO nxl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Oyo sio pusiso wason oatinu rei, osira nai osa. Oasau ata, “Ira oe! Iuna pusire iake maa. Iuna sio wason oaririeso oatinu, na sio wason oakumouso oanamana.” ");
INSERT INTO nxl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Yesus isuisene ia mouke wain iaririe pusi, oyo tau rei oi, sio panesi oamanouso honu. Sio panesi rei no muaine tewa, reiso Yesus ioi ne mampusua. Oyo iasau osiso, ");
INSERT INTO nxl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Anoku runa sio panesi reini. Okatata onona ua nea rotu-tu no muaine tewa nea. ");
INSERT INTO nxl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Sani uaisosiso onunso oai tewa, mka omankaeso sui arena tinai tihue. Sio umau mo, orue hainau.” ");
INSERT INTO nxl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Sio mampusua oasei tau Yesus ata, “Mai otoe huie reini mo, mka asupu muaine na relai pusiso sapan?” ");
INSERT INTO nxl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Iahata, “Omi mo porotiu hua ina warumo?” Oahata, “Hua itu.” ");
INSERT INTO nxl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Reiso iaisosi sio panesi rei oru-rueso poe tuamane, samatoro inana porotiu hua itu rai. Iainisi iake arihon Anahatana iahata, “Ama. Uainisi iake arihonia. Tea mo, arui porotiu raini osima.” Oyo ikuparehi porotiu rai mkana-mkana tau hanai, samatoro iruire osi ne mampusua rei, oyo osama-samare osi sio panesi rei pusiso. ");
INSERT INTO nxl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","No ikaya use ikina mkana oi. Yesus iainisi iake arihon Anahatana iahata, “Ama. Uainisi iake arihonia. Tea mo, arui ikaya rain osima oi.” Oyo iaisosi ne mampusua rei osama-samare oi osi sio panesi rei. ");
INSERT INTO nxl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Oaiso rotu-tu tiao pokona nea, oyo sio mampusua oamanou muaina nesia tau paku onata itu rotu-tu taua. ");
INSERT INTO nxl_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tau sio panesi rei mo, sio hanai mainaya nihu ate runa sio pinau runa sio ikina oi. Oaiso pusi, oyo Yesus iaisosiso onunso. ");
INSERT INTO nxl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Iaisosiso onunso, oyo isaa no arupai runa ne mampusua. Osai rotu-tu ohokaso nau otoe wan nanae Dalmanuta. ");
INSERT INTO nxl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Yesus sio ohokaso nau otoe wan nanae Dalmanuta, oyo sio onata arihon akama Yahudi ohokaso mai Yesus nanie otuntana nnai. Nanie oreai, reiso oainisi na iuna sima-simane wan retuhete ata ne kawasa arihon Anahatana. ");
INSERT INTO nxl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesus inesa naha naue pan anoi, oyo iasei ata, “Omi naene reini mo, oainisi na Au una sima-simane wan retuhete ata we kawasa arihon Anahatana, nan tahae? Atinu mai ia-ia, nanie uasau osimo. Upeneku una sima-simane san rei osimo.” ");
INSERT INTO nxl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Oyo isaa pan arupai anoe honu, oyo isai on nau hae ieu arihon sio rei. ");
INSERT INTO nxl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ne Yesus ne mampusua anoo kanihua orori poroti tewa, hasae poroti hua osa wapan arupai anoe man. ");
INSERT INTO nxl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iaisosiso san rei, “Ainati! Pene mo atata sani sio onata arihon akama Yahudi. Tea mo, sio makarotana wason oasau ata ruao sahoro sio manisata. Aikee sio mo, sio manisata tewa oi. Sio mo, sani ragi oi. Ragi mkane man oo, reuna poroti resaa mainae. Oainati na Herodes oi!” ");
INSERT INTO nxl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Reiso oasei tau umau ata, “Iasau san rei, nan tahae?” Oyo oapamata sou ata iasau san rei tau sio anoo kanihua orori poroti. ");
INSERT INTO nxl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesus ianei ata oasau san rei, reiso iasei tanso ata, “Oasau na re poroti tewa, nan tahae? Oanei tewasi? Anomo makaya reiso oanei tewasi. ");
INSERT INTO nxl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Omi mo, aikee matamo usena, ne onoo tewa. Omi mo, aikee tinamo ukuna, ne oatinu tewa. Anomo rapeka runa sae isa tewa. ");
INSERT INTO nxl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Naone ukuparehi porotiu hua nima mkana-mkana osi sio nihu nima, oyo oamanou nesia tau pakuna ina rotu-tu taua?” Oahata, “Pakuna hutusa rahana ua waron taua.” ");
INSERT INTO nxl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ita tau muie honu, ukuparehi porotiu hua itu mkana-mkana osi sio nihu ate, oyo oamanou nesia tau pakuna ina oi rotu-tu taua?” Oahata, “Pakuna itu.” ");
INSERT INTO nxl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Iasei honu ata, “Ne omi oanei tewasi ia seia sahoro iauwatuku?” ");
INSERT INTO nxl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesus runa ne mampusua oeuso poe nia Betsaida. Hoka poe oyo, sio umau oautunu ia mata putie isa osiki. Oyo oasau osiki ata, “Upu. Ahusiei na ia iake.” ");
INSERT INTO nxl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Oyo Yesus irime hanai, ihokai arihon niane rei. Oyo ihuto matai usena, samatoro iahusiei. Iahusiei, oyo iasei tanui ata, “Anoo sae isa nea?” ");
INSERT INTO nxl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Inoo roe uae, iahata, “Unoo sio umau sani ai tinaia, ne sio wason oeu suru ria suru nau.” ");
INSERT INTO nxl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ita iahusie matai usena tau hanai honu. Oyo ia mata putie rei inoo iake. Matai raputiso tewa nea. Inoo relalopo tewa nea. ");
INSERT INTO nxl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Oyo Yesus iaisosiki inuniki. Ne iasau osiki ata, “Pene anun poe niane rei nea.” ");
INSERT INTO nxl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesus na ne mampusua oeu ohori otoe Kaisarea Pilipi. Wason arena tinai tihue, oyo Yesus iasei tanso ata, “Sio oasau ata Au reini mo, Au seia?” ");
INSERT INTO nxl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Oahata, “Upu. Sio umau oasau ata Ano mo Yohanis ia mamsohue wain iamahaiki honu. Sio umau honu oasau ata Ano mo, Elia. Samatoro sio tamena umau honu oasau ata Ano mo, ia mamsima runa Anahatana ne maunauna isa.” ");
INSERT INTO nxl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Iasei honu, “Ne pusu omi ruamo mo, Au reini mo, Au seia?” Oyo Petrus on poe iasau ata, “Ano sahoro Ia Aia wain Anahatana Ihitia na Apuheu Mansia!” ");
INSERT INTO nxl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Oyo Yesus iasau ata, “Pene osima osi ia seia man. Pene osima rerihoni Au ata, Au mo, Au Aia wain Anahatana Ihitiku na Uapuheu Mansia.” ");
INSERT INTO nxl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesus iatuhete ne mampusua ata, “Kahurae Au, Tumata Reini mo, Anahatana Ihitiku mka sinsaraku panesi. Mka sio ona Yahudiu, sio imam no sio mainaya, na sio matuhete Musa ne maunauna openeso tanuku. Mka ohunuku, oyo onona ua, uamahaiku honu.” ");
INSERT INTO nxl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iasau san rei na oanei ia-ia ata wain iasau sapan. Reiso Petrus inesa Yesus na uaso ruao. Iakapuku tanui, oyo iasau san rei, “Upu. Pene asau san rei.” ");
INSERT INTO nxl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ne Yesus iuni inoo ne mampusua. Iakapuku tau Petrus, iasau ata, “Masi aeu arihoniku, ano aia sakahatene. Ano asau san rei, ano arinii pusu mansia, ano arinii pusu Anahatana tewa.” Ioi Petrus tau ia aia sakahatene tau ia aia sakahatene ipenei tau Yesus ipusu Anahatana ne maue. ");
INSERT INTO nxl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Oyo Yesus ianaha na ne mampusua runa sio panesi wason pan rei. Hoka mai tanui, oyo Yesus iasau osiso ata, “Ia sia wain nanie ipusu Au mo, kahurae pene ipusu ruai ne maue. Kahurae inoo ruai sani imatai onon ranie. Noo sani ia wain ihana ne hini wan reniene na sio ohunui. Iahana san ruai imatai nea. Ihana ne hini wan reniene oyo ipusu-pusuku. ");
INSERT INTO nxl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Munata ipenei irui ruai sinsarai na imatai, mka tau muie, imatai sinia. Ne iruei hainau arihon Anahatana rotu-tu ria supan. Ne munata ia isa irui ruai na iaunauso tau Sou Iake rerihoni Au, mka iamahaiki ikata Anahatana rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Masike ia isa isupu arataeu pusire mai tuniai rein iae, ne mka imatai iruei hainau arihon Anahatana rotu-tu ria supan. Arataeu rai tau sae? ");
INSERT INTO nxl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Masike isenu ne arataeu pusire iae, mka iamahaiki ikata Anahatana rotu-tu ria supan tewa. ");
INSERT INTO nxl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tau naene wason opalalosa reini mo, wason oarihoni Anahatana na oainaa runa sio tamena, munata ia isa iaumaa iamanaku ata iparisaa tau Au runa we maunauna, Au, Tumata Reini mo, Anahatana Ihitiku iae, mka tau uhokaku honu, upeneku uamanaku ata uationa ia rei oi. Mka uhokaku honu, oyo sio onooku. Onooku ita-itaku sani Amaku Anahatana na ne maisosia on roe noiyaha wason sio manisate onate. ");
INSERT INTO nxl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Atinu mai ia-ia, nanie uasau osimo. Omi umau wan okataku reini mka onoo Anahatana irime ne mansiau runa ne kawasa. Onoo ata irime ne mansiau mo, on omatamo tewasi.” ");
INSERT INTO nxl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nene nome rei san rei oyo, Yesus ieu ikata Petrus, Yakobis, na Yohanis roe tinetae na ateso ruao. Hoka roe oyo, mai mata kahutua, sira tau Yesus imuinen nitai. ");
INSERT INTO nxl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ne apia ita-itana, puti tunna. Ia mapatoie isa mai tuniai reini pusiki ianei ipapa apia puti tunna san rein tewasi. ");
INSERT INTO nxl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Oyo ne mampusua ton rei onoo Yesus wain ianamana runa Elia na Musa. ");
INSERT INTO nxl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Oyo Petrus iasau osi Yesus ata, “Ano Ona Matuhetene. Ita mai rei mo, iake nai osa maa. Nene iake mo, ami apuoo wanana tonu. Isa osi Upuku, Ano. Isa osi Musa. Isa honu osi Elia.” ");
INSERT INTO nxl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Iasau san rei tau ianei tewa kahurae iasau sae. Tau ia na ne netau ua rei wason okaitau hun ruao. ");
INSERT INTO nxl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Oyo yahu resohiso samatoro oatinu nioke on pan yahu rei reasau ata, “Ia reini mo, Au Anaku. Anoku nnai. Oatinu tanui!” ");
INSERT INTO nxl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Oyo ono-noo suru roe suru poe sansana, ne onoo ia isa wain ikataso tewa nea. Hasae Yesus ruai man. ");
INSERT INTO nxl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ateso omusu on roe tinetae rei, oyo Yesus isoposo ata, “Pene oeu orun osi ia seia man rerihoni sinasi onoo sae mai rei. Pene osima on Au, Tumata Reini mo, Anahatana Ihitiku, uamahaiku honu tewasi.” ");
INSERT INTO nxl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Sio opusu ne maunaune rei, reiso osima osi ia isa tewa oi. Ne tonso ruao oasei tau umau ata, “Iasau ata mka iamahaiki honu. Areimo sapan?” ");
INSERT INTO nxl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Reiso oasei tanui ata, “Sio matuhete Musa ne maunauna oasau ata kahurae Elia ihokai naone, nan tahae?” ");
INSERT INTO nxl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Iahata, “Titue. Mka Elia ihokai naone na ipamanisa pusire na iaka. Reiso sapani na sio okanu tau Anahatana ne anamanaya ata Au, Tumata Reini mo, Anahatana Ihitiku, mka ouna sinsaraku panesi runa sio panesi openeso tanuku? ");
INSERT INTO nxl_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ne Au mo, uasau osimo ata ia isa sani Elia ihokai nea. Ne sio ouna kahatene osiki pusu ruao no maue san sae wani okanui tau Anahatana ne anamanaya nea rei.” ");
INSERT INTO nxl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesus runa ne mampusua tonu rei ohokaso poe sio mampusua tamena rei, oyo onoo ata sio hutue wason oamanouso poe rei. Sio matuhete Musa ne maunauna wason otuntana na sio rei. ");
INSERT INTO nxl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mata hun tewa oyo, sio pusiso onoo Yesus reiso osira, oyo orumaso mai tanui, nanie oatapeai. ");
INSERT INTO nxl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesus iasei tanso ata, “Omi wan otuntana runa sae na sio reini?” ");
INSERT INTO nxl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ia isa arihon sio hutue rei iasau ata, “Ano Matuhetene, uautunu anaku mai tanua. Sakahatene remasuni anaku reini, reiso iakumoui. ");
INSERT INTO nxl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Sui supan man sakahatene rei remasuniki, oyo reunai ipesi ruai poe tuamane, kahusea rahokaso on roe hohai, reuna ioto nesin. Reuna tinain rerimuniki. Uainisi arihoni me mampusua nea na onei sakahatene rei ne onei kuai tewa.” ");
INSERT INTO nxl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iahata, “Omi mo, masike. Omi napisi reini mo, oparisaa tewa. Kahurae urue ukatamo rotu-tu inasa? Kahurae uapamesemo rotu-tu inasa? Oautunu ia ikine rei mai.” ");
INSERT INTO nxl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Reiso oautunu ia ikine rei mai Yesus. Sakahatene rei renoo Yesus, oyo ia ikine rei ikana-kananunui rotu-tu iamnohoi poe tuamane, ikama-kamauniki, kahusea rahoka arihon hohai. ");
INSERT INTO nxl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Oyo Yesus iasei tau ia ikine rei amai ata, “Ia ikine reini mo, san reini potuina nea?” Iahata, “Upu. On ia ikine asi. ");
INSERT INTO nxl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Sakahatene rei reninai onon ranie, nanie rehunui, reiso reunai iamnohoi pan usa te pan waene. Ne kani amaha auna sae isa, uainisi arihonia na anom runama na akahaima ee.” ");
INSERT INTO nxl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iahata, “Ano asau kani umaha tau sae? Anahatana imaha iuna sae man, hete sae, oparisaa.” ");
INSERT INTO nxl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","“Uparisaa mkane man. Akahaiku na uparisaa mainae.” ");
INSERT INTO nxl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesus inoo sio panesi ohokaso oruma oamanouso, oyo iaisosi sakahatene rei. Isopoi ata, “Ano sakahatene wan auna mansia iakumoui na iaririei, uaisosia ahokaya arihon ia ikine rein na pene amasuniki nea.” ");
INSERT INTO nxl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Iasau san rei oyo, sira tau sakahatene rei rekapona. Reuna ia ikine tinain rekana-kananunui, samatoro rehokai arihon ia ikine rei. Rehokai oyo, onoo ia ikine rei nooi san imatai. Reiso sio panesi oasau ata, “Ira oe! Imatai nea tea!” ");
INSERT INTO nxl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ne Yesus irime hanai, ihetui, oyo ia ikine rei ihanui. Ihanui ihitioi roe. ");
INSERT INTO nxl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesus inusui pan numa, oyo ne mampusua rei ruao ohokaso mai Yesus oasei tanui ata, “Ami amaha anei sakahatene rei tewa tau sae?” ");
INSERT INTO nxl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Iahata, “Sakahate nitae reini mo, ineiki hasae tau mainisie man.” ");
INSERT INTO nxl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesus runa ne mampusua oeuso oarihoni otoe rei, oyo oeuso sui otoe Galilea. Ne Yesus ipenei tau sio oanei ata Ia waipan ihokai. ");
INSERT INTO nxl_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tea mo, nanie iatuhete ne mampusua ruao. Iahata, “Au, Tumata Reini mo, Anahatana Ihitiku, mka oaheniku osi we nisau, oyo ohunuku. Ne onona ua, oyo uamahaiku honu.” ");
INSERT INTO nxl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Oanei sae wan iasaui rei tewa, ne omoniki, reiso oasei tanui tewa. ");
INSERT INTO nxl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesus sio ohokaso mai nia Kapernaum. Tau Yesus waipan numa anoe nea, iasei tau ne mampusua ata, “Sinasi otuntana rerihoni sae poe arena tihue rei?” ");
INSERT INTO nxl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ne oamaturuso man. Tea mo, oaumaa osima runa sinasi poe arena tihue mo, otuntana rerihoni ia seia sahoro ia mainae nai osa. ");
INSERT INTO nxl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iruei poe, oyo ioi ne mampusua hutusa rahana ua rei. Ohoka mai, samatoro iaunauso ata, “Ia seia nanie iuna mainae mo, kahurae inuniki tau muie na ianori na sio pusiso.” ");
INSERT INTO nxl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Oyo ioi ia ikine isa oyo, iunai iooi kua tihue, oyo inahiki. Iasau osiso ata, ");
INSERT INTO nxl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ia wain anoi runa ia ikine san reini noso anoi runaku, areimo sani anoi runa Au sinia. Ia wain anoi runa Au, anoi runa Au ruaku man tewa. Areimo, anoi runa Ia wain iaisosiku oi.” ");
INSERT INTO nxl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Oyo Yohanis iasau osi Yesus ata, “Ano Matuhetene, ami anoo ia isa inei sakahatena ihete nanam. Reiso asopoi. Tea mo, ia rei mo, arihon ita tewa.” ");
INSERT INTO nxl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Iahata, “Pene osopoi. Sani ia isa iuna sima-simana arihon Anahatana ihete Au nanaku, oyo sira tau ianamana kahatene tanuku mo, tewa. ");
INSERT INTO nxl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tea mo, ia wain re nisa tewa, areimo ita re neta. ");
INSERT INTO nxl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Atinu mai ia-ia nanie uasau osimo. Ia wain iakahaimo mkane sani irui tihu kalasi taue isa osimo na oninu tau opusu Au, Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau, mka ia rei, isupu sae wan Anahatana irui osi sio wason oanori runai rei osiki. ");
INSERT INTO nxl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Sani ia isa irea ia isa wain iparisaa ia-ia tau Au tewasi, na iunai ipalalosa mo, nene iake okanihoo hatu mainae roe ia wain irea ia rei tionai oyo omokoi nau nuae. ");
INSERT INTO nxl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Munata hanam atue hae reunaya apalalosa, areimo nene iake aroto rohai. Nene iake amahaia akata Anahatana rotu-tu ria supan runa hanam atue hae man. Ne pene sio pesia poe usa mainae wan hainau arihon Anahatana runa hanam atua uare. Usa reimo, remata tewa rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Poe rei, usa remata tewa, uneu ramata tewa. ");
INSERT INTO nxl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Munata aim atue hae reunaya apalalosa, areimo aroto rohai. Nene iake amahaia akata Anahatana rotu-tu ria supan runa aim atue hae man. Ne pene sio pesia poe usa mainae wan hainau arihon Anahatana na aim atua uare. ");
INSERT INTO nxl_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Poe rei, usa remata tewa, uneu ramata tewa. ");
INSERT INTO nxl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Munata matam usene hae reunaya apalalosa, areimo apekui. Nene iake arue akata Anahatana tau irime ne mansiau runa matam usene hae man. Ne pene sio opesia poe usa mainae wan hainau arihon Anahatana na matam usena uare. ");
INSERT INTO nxl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Poe rei, usa remata tewa, uneu ramata tewa. ");
INSERT INTO nxl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ia seia wain ipusuku oyo sinsarai, mka una iamanisai noso sinsarai. Nooi sani usa repasanisi hunahane. ");
INSERT INTO nxl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Masine mo, iake nai osa tau reuna muaina nanaya. Ne, sani masine rei masine tewa nea mo, nanie iuna sae tanui asi na masine tewa nea rei? Mka reuna muaina nanaya tewa nea. Sani otuntana rerihoni ia seia, ia mainae, omi iae noomo sani masine reniniki rei oi. Pene otuntana na umau. Orue anomo ramaturuso na umau.” ");
INSERT INTO nxl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesus sio oeuso arihon nia Kapernaum, nanie oeuso ria otoe wan nanae Yudea, oyo oeuso ria Wae Yordan ria hae. Hoka ria oyo, sio panesi ohokaso oamanouso mai Yesus. Iatuheteso. Areimo iunai sui osa. ");
INSERT INTO nxl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Sio onata arihon akama Yahudi ohokaso mai Yesus nani oreai. Nanie onoo ata Ia mo, ianamana pannuhu runa Musa ne maunauna te tewa. Reiso oasei tanui ata, “Pusu Musa ne maunauna mo, Anahatana itapi ia hanaie isa itihi sahai te tewa?” ");
INSERT INTO nxl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Iahata, “Musa iaisosimo sapan?” ");
INSERT INTO nxl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Oahata, “Musa itapi ia hanaie ikanu surate na itihi sahai, oyo iaisosiki ieui.” ");
INSERT INTO nxl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iahata, “Musa ikanu san rei tau omi mo, anomo makaya na openemo opusu Anahatana ne maunauna. ");
INSERT INTO nxl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ne on Anahatana ihaye tau tuniai reini mo, oasau ata, ‘Anahatana ihaye tau mansia pina runa mansia hanaie.’ ");
INSERT INTO nxl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Reiso ia hanaie ieu arihon inai na amai, oyo ikata sahai. ");
INSERT INTO nxl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","‘Inoo uaso sani ia osa man.’Sio ua tewa nea. Ne sio osa man. ");
INSERT INTO nxl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Reiso sae wan Anahatana iunai tau osa nea mo, pene mansia inenai.” ");
INSERT INTO nxl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Taa wason pan numa nea, oyo ne mampusua oasei tanui runa ne anamanaya rai. ");
INSERT INTO nxl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ne Yesus iasau osiso ata, “Atieu sani ia isa wain iausahai nea, ne itihi sahai oyo inana ia pina tamene honu, areimo Anahatana iasau ata isahu-sahu sahai. ");
INSERT INTO nxl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Sani ia pina isa itihi sahai, oyo inana ia hanai tamene isa, ia iae isahu-sahu sahai oi.” ");
INSERT INTO nxl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Taue isa sio umau ohoka orori no sio ikina oi na nanie Yesus hanai tanso na iainisi na Anahatana irui iake osiso. Ne sio mampusua oakapuku tanso. ");
INSERT INTO nxl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesus iatinu san rei, anoi resaa. Iahata, “Tapi sio ikina rei na oeuso mai tanuku! Pene osoposo! Sio wason oparisaa resun tewa sani sio ikina reini mo, sio sahoro mka opusu tau Anahatana irime ne mansiau. ");
INSERT INTO nxl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Atinu mai ia-ia nanie uasau osimo. Tau Anahatana irime ne mansiau mo, ia wain ipenei itapi Anahatana irimei mo, sani ia ikine itapi amai irimei, ia mo, mka iamahaiki ikata Anahatana rotu-tu ria supan tewa.” ");
INSERT INTO nxl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Oyo ihete sio ikina rei samatoro iahusieso. Iahusieso, oyo iainisi osiso ata, “Ama. Uainisi na arui iake osi sio ikina reini na okarihuru oamahai.” ");
INSERT INTO nxl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesus iainisi osi sio ikina pusi, oyo nanie ieui. Ne sira tau ia isa irumai mai tanui. Irike tune mai uai anoe, nanie iamuirai, oyo iasei tanui ata, “Ano Matuhetene. Ano mo, Ano iake. Kahurae una sae na uamahaiku ukata Anahatana rotu-tu ria supan?” ");
INSERT INTO nxl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iahata, “Hasae Anahatana man sahoro ne iake! Ia isa ne iake sani Ia tewa! Reiso ano nanie asau ata Au we iake tau sae? ");
INSERT INTO nxl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ano anei ata tau Musa ne maunauna mo, Anahatana iasau ata, ‘Pene osahu-sahu mo pina hanai. Pene ohunu mansia. Pene okimanaka. Pene orun mansia inamatane. Pene oruma orori mansiau no kepen. Oamuira mo mansia mainaya.’” ");
INSERT INTO nxl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Iahata, “Ano Matuhetene. Sae warumo Ano asaure rei mo, au una pusu pusire on au ikine asi.” ");
INSERT INTO nxl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus iasumatai. Anoi runai. Iahata, “Munata san rei mo, ano mo, kahurae auna isa honu. Ano mo, kahurae eua na ahen me numa hutae pusiki. Pusi oyo, eu asama me kepen waron asupure rei osi sio mosokinia. Sani auna san rei nea, mka asupu me numa hutae roe noiyaha. Pusi oyo, aeu mai, na aeu apusu Au.” ");
INSERT INTO nxl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Oyo ikanahatai. Ieui arihoni rei, anoi mtinte. Areimo, tau anoi runa ne kupan kaya mainae nai osa. ");
INSERT INTO nxl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesus inoo neka ne mampusua, oyo iasau osiso ata, “Anahatana irime ne mansiau mo, resun tau sio kupan kaya opusui.” ");
INSERT INTO nxl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Taa oatinu tau ne anamanaya rai, oyo ne mampusua osira. Ne Yesus isakanau ne anamanae honu. Iahata, “We hehuka. Opusu tau Anahatana irime ne mansiau mo, mtinte. ");
INSERT INTO nxl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Areimo noo sani makapana wan nanae unta wan mainae nai osa. Makapana rei resun mkane renusui pusu sisunue matae. Ne sio kupan kaya mo, opusu tau Anahatana irime ne mansiau mo, resun nai osa.” ");
INSERT INTO nxl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Oatinu san rei, osira hun ruao. Reiso oasei mai umau ata, “Ira oe! Munata san rei mo, mka Anahatana iapuheu ia isa tewa oi tea! Iapuheuso na pene iapasanaso tea!” ");
INSERT INTO nxl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus inooso honu. Iahata, “Mansia mo, omaha oapuheu ruao tewa. Ne Anahatana imaha iuna sae man.” ");
INSERT INTO nxl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Oyo Petrus iasau ata, “Ami reini mo, aeu arihoni ma sae man na apusua.” ");
INSERT INTO nxl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iahata, “Atinu mai ia-ia nanie uasau osimo. Ia sia wain ieu iarihon ne niane, kaka wan, mansia mainaya, ne hehuka, ne atuhu ai nohua rusun pusakau iae, noso anoi runaku na nanie isima na Sou Iake rerihoni Au, ");
INSERT INTO nxl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ia rei mo, pan muie, mka isupu panesi arihon sae waron ieu arihonre rei. Mka isupu niana utun, kaka wan utun, ne inau utun, sio ikina utun, nisi utun. Ne mka sio umau ouna sinsarai noso iparisaa tau Au. Oyo mka pan muie rei iamahaiki honu ikata Anahatana rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ne sio panesi wason oata kan sio mainaya nea, mka sio mainaya tewa. Samatoro sio panesi wason muie rei oata kan sio mainaya tewa, mka sio mainaya.” ");
INSERT INTO nxl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesus sio wason oeuso roe kota Yerusalem. Ia ieui roe uae, ne mampusua oeu hae muie. Osira. Samatoro sio wason opusu hae muie okaitau. Oyo Yesus ioi ne mampusua hutusa rahana ua na sio ruao man, nanie isima osiso rerihon mka Ia sapan. ");
INSERT INTO nxl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Iahata, “Atinu. Nanie ieuta roe kota Yerusalem. Roe rei, Au, Tumata Reini mo, Anahatana Ihitiku, mka oruiku osi sio imam no sio mainaya runa sio matuhete Musa ne maunauna. Mka oasau ata kahurae ohunuku, oyo sio Yahudiu mka oruiku osi sio wason sio Yahudiu tewa. ");
INSERT INTO nxl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Oyo sio rei oaumaniku, ohutoku, osapuku tau awane unie, oyo ohunuku. Ne nene poua pan san rei, uamahaiku honu.” ");
INSERT INTO nxl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedeus ne hehuka, Yakobis, runa Yohanis, ohokaso mai Yesus. Oasau osiki ata, “Ano Matuhetene, ami nanie ainisi sae isa arihonia na aunai osima.” ");
INSERT INTO nxl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Oyo Yesus iasei tanso ata, “Onina na una sae osimo?” ");
INSERT INTO nxl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Oahata, “Ami nanie auna aia na aruema akataya, ia isa hae hanam wanane, isa honu hae hanam pante pannuhu sio pusiso oanei ata Ano auna natu tau sio pusiso.” ");
INSERT INTO nxl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Iahata, “Oanei tewa oainisi sae rei. Oamkona oapamese sinsaramo rotu-tu omatamo sani mka umataku?” ");
INSERT INTO nxl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Oahata, “Ami amkona apamese.” Iahata, “Titue. Omi mka sinsaramo rotu-tu omatamo sani mka umataku. ");
INSERT INTO nxl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ne rerihoni ia seia mka iruei mai hanaku wanane runa hanaku pante mo, we kawasa uasau tewa. Anahatana sahoro iasau ia seia sahoro iuna aia ikataku. Ianei nea ia seia sahoro ihitiki.” ");
INSERT INTO nxl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Sio mampusua nesia hutusa rei oatinu san rei, oyo anoo rasaa tau Yakobis runa Yohanis. ");
INSERT INTO nxl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Reiso Yesus ianaha na sio pusiso, iasau ata, “Omi oanei ata sio mainaya arihon niana-niana waron oationa Anahatana tewa mo, orime no mansiau pusu ruao no maue. Orime kawasa mtinte. ");
INSERT INTO nxl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ne omi mo, pene mo haliu san rei. Sani ia isa arihon omi nanie iuna ia mainae, areimo kahurae iuna ia manorine ee. ");
INSERT INTO nxl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ia wain nanie iuna mainae arihon omi mo, kahurae iuna manorine tau ia seia man. ");
INSERT INTO nxl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ne Au, Tumata Reini mo, wain Anahatana Ihitiku iae, uhokaku na mansia oanori nnaku mo, tewa. Uhokaku na uanori na mansia, oyo umataku na usi sio panesi no rosau.” ");
INSERT INTO nxl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesus iaunau ne mampusua pusi, oyo oeuso na pan nia Yeriko. Taa pannuhu Yesus, ne mampusua, na sio hutue wason nanie ohokaso arihon niane rei, ia mata putie isa waimo iru-ruei noi arena nusue. Iai-ainisi kepen arihon sio wason oniku ria nau noi rei. Ia mata putie reimo, nanai Bartimeus. Amai tau Timeus. ");
INSERT INTO nxl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Iatinu ata Yesus, Ia kota Nasaret, wain iniku, reiso iakapona, “Yesus, aia Daud upui, anom nnaku.” ");
INSERT INTO nxl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Sio panesi oakapuku tanui ata, “Amaturua!” Ne ia rei iakapona sui osa sinia. Iahata, “Daud upui, anom nnaku.” ");
INSERT INTO nxl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesus iatinu san rei, oyo iaraoo. Iahata, “Oiki mai.” Reiso sio ooi ia mata putie rei. Oata, “Apamese anom. Yesus wain ioia, hitio roe.” ");
INSERT INTO nxl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ia mata putie rei ipesi ne papi naue, oyo ihitio sansana na ieu mai Yesus. ");
INSERT INTO nxl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Oyo Yesus iasei tanui ata, “Anina nanie una sae osia?” Iahata, “Upu! Nanie unoo.” ");
INSERT INTO nxl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Iahata, “Aparisaa tanuku, reiso wan usuisenea nea.” Sira tau ia mata putie rei inoo mosa. Ieu ipusu Yesus sui arena rei. ");
INSERT INTO nxl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesus sio oeuso arihon nia Yeriko, oyo oeuso na roe kota Yerusalem. Sio wason haineke kota Yerusalem nea, mai nia Betpage na nia Betania. Niana ua rai mo, warupan Pupue Saitun nene sanene aikune. Pan rei, Yesus iaisosi ne mampusua ua oeuso oanaoneso. ");
INSERT INTO nxl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Iahata, “Uamo oeumo nau niane wanau uae reinau. Onusui, mka osupu keledai anae isa wapan okanihooi. Keledai anae reimo, ia seia man isaai tewasi. Onosu nene awane na onesai mai. ");
INSERT INTO nxl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ne, sani sio umau oasei tanumo ata, ‘Nanie onosu keledai anae rei tau sae?’ Areimo asau osiso ata, ‘Mani upu nanie isaai. Mka sansana oyo ieui mai, iuniki osimo.’” ");
INSERT INTO nxl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Reiso uaso oeuso. Hoka nau oyo, osupu keledai anae rei. Sio okanihooi mai numa mitanunue nea, pakarema arena nusue. Reiso uaso onosui. ");
INSERT INTO nxl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Onosui oyo, sio umau wason ooso noi rei oasei tanso ata, “He. Ouna sae reino? Onosu keledai anae rei, nan tahae?” ");
INSERT INTO nxl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Oahata, “Mania upu nanie isaai. Mka sansana mai, iuniki osimo.” Reiso sio rei osoposo tewa. Oyo uaso onesa keledai rei. ");
INSERT INTO nxl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Hoka ria Yesus, oyo oaunutu no papi naua roe nene totu hahae samatoro Yesus isaai roe. ");
INSERT INTO nxl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Sio panesi orata no papi naua poe arena. Sio umau honu orata ai sana mataya poe arena. Ai sanaya rai mo, ororire on noi nisiu. Ohuka no papi naua oyo oratare sui arena na oamuirai san oamuira sio aiau. ");
INSERT INTO nxl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yesus isaa makapana rei oyo reeu roe papita runa ai sanaya rai nanie inusui pan Yerusalem. Sio umau oeu roe uae, sio umau hae muie. Mansia pusiki oakapona. “Ainaa na Anahatana. Arui iake osi ia wain ihokai tau ma Upu nanai. ");
INSERT INTO nxl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ia reimo ihokai, mka iuna natu sani naone ma upu Daud, ia aia. Ainaa na Anahatana wain iruei roe noiyaha.” ");
INSERT INTO nxl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Reiso Yesus ihokai mai Yerusalem. Hoka mai, oyo inusui pan Anahatana ne numa mainisie. Inusui pan numa anoe, oyo ino-noo. Iarinii neka pusi numa anoe. Ne haineke pumono nea, reiso ieui poe nia Betania ikata ne mampusua hutusa rahana ua rei. ");
INSERT INTO nxl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nene han roe san rei, Yesus sio oeuso oarihon nia Betania, oyo Yesus imakaneai. ");
INSERT INTO nxl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","On pan hainau asi mo, inoo ai ara isa. Ai ara rei nene totua panesi. Reiso ieui pan hainekei na nanie inoo ata kani nene huaya umau te tewa. Ne ihokai mai ai rei aikune, ne isupu ai rei huae isa tewa nai osa. Hasae nene totua man. Tea mo, ai ara nene nanie tewasi. ");
INSERT INTO nxl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Oyo Yesus iasau osi ai rei ata, “Tau ranie hatae rei pan sinia, ia isa man pene iai me huaya nea!” Yesus ne mampusua oatinu ne anamanae rei. ");
INSERT INTO nxl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesus sio ohokaso roe kota Yerusalem. Hoka roe oyo, Yesus ieu honu roe Anahatana ne numa mainisie. Hoka roe numa rei nene nusue, oyo inei sio umau wason oahen runa ohoka ohane roe tihue rei. Iuni hehi meya waron otuka kepen tanre. Iuni hehi sio manaheni manu puana no katerau oi. ");
INSERT INTO nxl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Anahatana itapiso orori sae man pusu ne numa mainisie nusue tewa. ");
INSERT INTO nxl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Oyo Yesus iatuhete sio panesi kua tihue rei. Iahata, “Tau Anahatana ne anamanaya, sio okanu san rei, Anahatana iasau ata, ‘Au we numa mo, mka sio ooiki tau numa mainisie osi sio niana-niana.’Ne omi wan ounai tau sio kimanakana naniao nea.” ");
INSERT INTO nxl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sio imam no sio mainaya na sio matuhete Musa ne maunauna oatinu tau rei. Reiso onina arena nanie ohunu Yesus. Oananai tau sio mansiau pusiso osira oatinu ne anamanaya. ");
INSERT INTO nxl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ne nene pumono pan san rei, Yesus runa ne mampusua oeuso oarihon kota rei. ");
INSERT INTO nxl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nene hanu omnano tunne, oyo Yesus sio nanie oeuso. Oeuso oniku ai ara wan Yesus iainisi nnai rei. Oyo sira tau onoo ata ai rei remeniki nea. Nene namta iae rakaimen pusire oi. ");
INSERT INTO nxl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Oyo Petrus anoi repeka na Yesus ne anamanae wan potusi rei. Reiso iasau osi Yesus ata, “Ano Ona Matuhetene. Masi anoo! Ai ara wan Ano ainisi nnai potusi rei, remeniki nea tea!” ");
INSERT INTO nxl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Iahata, “Kahurae omi oparisaa tau Anahatana. ");
INSERT INTO nxl_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Atinu mai ia-ia nanie uasau osimo. Omi oasau tau tinetae reini, ‘Ahitioa. Apesi ruam nau nuae!’ Mka tinetae rei repesi ruae nau nuae oi. Hete sae, omi pene ouna pie-pie. Hete sae, oparisaa ata wan oasau rei ata oaisosi tinetae rei repesi ruae nau nuae, mka repesi ruae oi. ");
INSERT INTO nxl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Anomo rapeka. Munata oainisi sae isa arihon Anahatana, kahurae oparisaa ata mka iruiki osimo sinia. Oparisaa, mka osupui sinia. ");
INSERT INTO nxl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Sani oainisi, ne anomo ramaturuso tewa tau ia isa wain iuna isanae tanumo, kahurae pene anomo rasaa nea na moa Ama roe noiyaha iae isiru heu mo isanaya rai oi. ");
INSERT INTO nxl_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Sani anomo rasaa tau ia wain iuna sana tanumo sirinia, moa Ama roe noiyaha iae, ipenei isiru heu mo isanaya rai oi.” ");
INSERT INTO nxl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesus sio ohokaso mai kota Yerusalem honu. Oyo tau wain ieu ihori pan Anahatana ne numa mainisie nusue, sio imam no sio mainaya, sio matuhete Musa ne maunauna, na sio onata rerihoni akama Yahudi nesia rei ohokaso mai tanui. ");
INSERT INTO nxl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Hoka mai oyo, oasei tanui ata, “Atuhete san rei na anei mansiau wason oahen roe Anahatana ne numa mainisie rei mo, sahoro asupu kawasa on supa? Ia seia irui kawasa osia rei?” ");
INSERT INTO nxl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iahata, “Au nanie uasei honu tau pusimo utumo. Oasau osiku mai ee, samatoro usima na usupu kawasa arihon ia seia na una rai pusire. ");
INSERT INTO nxl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yohanis ia mamsohue mo, isohuso na mansiau oanei ata oarihon no rosau nea. Isohuso runa Anahatana ne kawasa te mansiau no kawasa? Masi oasau mai.” ");
INSERT INTO nxl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Iasei pusi san rei oyo sio onata rei oasei mai umau. “Sani iahata, ‘Yohanis mo, isohu mansiau runa Anahatana ne kawasa,’ mka iasau honu ata, ‘Reiso omi nanie oparisaa tau Ia tewa tau sae?’ ");
INSERT INTO nxl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ne sani iasau ata, ‘Isohu mansiau runa mansia ne kawasa’, areimo imatata.” Okaitau pene rotu-tu sio panesi oakapuku tanso. Sio panesi oahata, “Titue! Yohanis mo, ia mamsima runa Anahatana ne maunauna isa.” ");
INSERT INTO nxl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Reiso oasau ata, “Ami anei tewa.” Oyo Yesus iasau osiso, “Munata san rei mo, Au iae upeneku uasau ia sia sahoro irui kawasa osiku na una rai pusire.” ");
INSERT INTO nxl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesus iaunauso tau matieua. Iaunau sio imam no siniriu, sio onata, na sio matuhete Musa ne maunauna. Iahata, “Ia isa irahu anggur noi ne nisi. Inana tone rehori ne nisi rei, oyo ikani nonu na oheta tau anggur nene huaya rotu-tu nene tihu rehokai poe nonu anoe rei. Oyo inana numa arihon hatu wan iapuooi naue. Iapuooi na orue osaka nisi rei roe tanui, samatoro iseha ne nisi anggur rei osi sio umau osakai na osama nene huaya osiki. Pusi oyo, ieui arihon otoe rei. ");
INSERT INTO nxl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nene orase tau nanie okure anggur huaya, ia nisi anggur rei upue iaisosi ne ia manorine isa na ieui poe sio wason osaka ne nisi anggur rei. Iaisosiki na orui nisi upue ne pahakian oi. ");
INSERT INTO nxl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ne sio wason osaka nisi rei oakahuu ia manorine rei. Ohitai oyo oaisosiki inuniki na hanai huie. ");
INSERT INTO nxl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nta Ia nisi anggur upue iaisosi ne manorine isa honu. Ita suru ria ieu. Hoka ria, ouna pumaai. Ohitai roe unui. ");
INSERT INTO nxl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ita iaisosi ne manori tamene isa honu. Ita suru ria ieu honu. Ieui rotu-tu ihokai ria, oyo ohunui. Ita iaisosi sio panesi, ia isa pusi ia isa. Ne sio umau mo, ohitaso, sio umau honu, ohunso. ");
INSERT INTO nxl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Iaisosi rotu-tu pusiso. Kani iaisosi ia seia honu? Nesie ia osa man mai ne numa anoe. Ia rei mo, ia ruai anai hanaie. Anoi runai. Iasau pan anoi ata, ‘Sani anaku ruai ieu, areimo mka oamuirai.’ Reiso iaisosi ruai anai. ");
INSERT INTO nxl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ne sio wason osaka nisi anggur rei onoo ia nisi upue rei anai oyo oasau mai umau, ‘Ia reini sahoro mka isupu ia onate rei ne rusun na ne numa hutae pusiki. Mai na ihunui na ita sahoro isupu ia onate rei ne rusun na ne numa hutae rei.’ ");
INSERT INTO nxl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Oyo onesai arihon nisi anoe rei, oyo ohunui. ");
INSERT INTO nxl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Reiso nisi anggur rei upue mka iuna sae osi sio wason osaka ne nisi rei? Mka inuniki mai ne nisi anggur rei oyo ihunu sio wason osakai rei. Ihunso oyo inina sio umau honu okatiso na osaka ne nisi rei. ");
INSERT INTO nxl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Onoo tau Anahatana ne anamanaya tewa tau sou wan reasau san reini? ‘Hatu isa wan sio tukana openeso tanui mo, muie rein reuna hatu tinipae wan rerime numa. ");
INSERT INTO nxl_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Upuri iuna san rei mo, inooi iake.’” ");
INSERT INTO nxl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","12 Reiso sio onata oanei ata Yesus waimo iruni matieue rei mo, iruni rerihon sio. Reiso, tau rei sinia, onina arena nanie osota Yesus. Ne okaitau sio hutue, reiso oeuso oarihon Yesus. ");
INSERT INTO nxl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Sio mainaya oaisosi sio onata arihon akama Yahudi umau runa Herodes ne mansiau umau mai Yesus, nanie oasei tanui na osotai sani ianamana kahatene rerihoni Ia Aia Mainae Roma. ");
INSERT INTO nxl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Hoka mai Yesus, oahata, “Ano Matuhetene. Ami anei ata Ano mo, Ano manisate. Anom reuponu tewa rerihoni mansia inooa sapan. Aoo tihue. Anoo ia isa mo, ia mainae tewa. Ano atuhete Anahatana ne maunauna pusire manisata. Pusu Musa ne maunauna, Anahatana itapita isenu peau osi Ia Aia Mainae Roma mo, iake te tewa?” ");
INSERT INTO nxl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ne Yesus ianei ata areimo oasei reai. Reiso iasau osiso ata, “Omi nanie osotaku, nan tahae? Masi orori kepen inate isa mai na unooi.” ");
INSERT INTO nxl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Reiso orui kepen inate isa osiki, oyo iasei, “Mai kepen inate reini mo, ia sia siain wan tanui? Okanu ia sia nanai tanui?” Oahata, “Ia Aia Mainae Roma.” ");
INSERT INTO nxl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Iahata, “Munata san rei mo, rui osi Ia Aia Mainae Roma sae wan ne kawasa iainisiki. Na rui osi Anahatana sae wan ne kawasa iainisiki oi. Ia mo, inina na iatinu tanui, iainisi iainaa nnai.” Osira tau oatinu tau rei. ");
INSERT INTO nxl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Taue isa sio ona Sadukiu umau ohokaso mai Yesus nanie oasei tanui. Sio ona Sadukiu mo, oparisaa tewa ata sio matana oamahaiso honu. Oahata, ");
INSERT INTO nxl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ano Ona Matuhetene, Musa ikanu maunaune rein osima. ‘Sani ia hanai suanane isa imatai arihoni sahai, ne isusu tewa, areimo wanin kahurae iausahai inana kakai pina wain iauhanui nea rei. Inanai na isusu osi kakai wain imatai nea rei.’ ");
INSERT INTO nxl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Taue isa, sio hanaia kaka wan sio itu. Ia iki manonte iausahai ne isusu tewa. Oyo reeu mai imatai arihon sahai reiso iauhanui. ");
INSERT INTO nxl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ita wanin inana kakai pina rei honu. Ita wanin rei imatai iarihon ia pina rei honu. Ia pina rei isusu tewa sinia. Ita wanin ia isa honu inanai, ne san rei sirinia. ");
INSERT INTO nxl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Rotu-tu ituso san rei sirinia. Oyo tau muie, ia pina uhanu rei imatai oi. ");
INSERT INTO nxl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tau onone wan Anahatana iuna sio matana oamahaiso honu mo, mka ia pina uhanu reimo, sahai tau ia sia? Areimo tau iausahai inana sio kaka wani itu rei nea.” ");
INSERT INTO nxl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iahata, “Omi osana rerihoni sio matana oamahaiso honu, sio sapan. Oanei tewa ata Anahatana ne anamanaya raasau sapan. Oanei tewa ata Anahatana ne kawasa sapan. ");
INSERT INTO nxl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mka sio matana oamahaiso honu mo, oausahaso tewa nea. Sio sani Anahatana ne maisosia on roe noiyaha. ");
INSERT INTO nxl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Rerihoni sio matana oamahaiso honu, onoo tau Musa ne anamanaya tewa? Ikanu ata tau Anahatana ianamana osiki on pan ai hutue rei, wan usa reai tanui rei. Iahata, ‘Au reini mo, Au Anahatana wan Abraham iainaa runaku. Isak iainaa runaku. Yakup iainaa runaku.’ ");
INSERT INTO nxl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Masike tonso omataso nea, Anahatana inooso sani oamahaiso asi. Reiso ia mo, ia wain Anahatana tau sio matana tewa. Ia Anahatana tau sio wason oamahaiso. Omi osana sani oasau ata sio matana oamahaiso honu tewa.” ");
INSERT INTO nxl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nene poua san rei, oyo ia matuhete Musa ne maunauna isa iatinu sio otuntana na umau. Iatinu ata Yesus ianamana iake osi sio ona Sadukiu arihon akama Yahudi iake. Reiso iasei tanui ata, “Upu. Maunau sae wan mtinte renesi maunauna pusire?” ");
INSERT INTO nxl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iahata, “Maunau mtinte wan san rei, ‘Atinu omi Israel! Upuri Anahatana, Ia osa man. ");
INSERT INTO nxl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Anom runa Upum Anahatana mo, runa anom pusiki, me inaha pusiki, anom repeka nnai sui osa, anom runai pusu me atata.’ ");
INSERT INTO nxl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Maunau mtinte isa honu mo, san rei, ‘Anom runa ia sia man sani anom runa ruam.’ Maunauna ua rai sahoro mtinta ranesi maunauna pusire.” ");
INSERT INTO nxl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Iahata, “Titue, Ano Ona Matuhetene! Ano asau manisate ata Upuri Anahatana ia osa man runa anahatana tamene isa waimo tewa nea. ");
INSERT INTO nxl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Anomo runa mo Upu Anahatana mo, runa anomo pusire, mo inaha pusire, anomo rapeka nnai sui osa, anomo runai pusu mo atata, anomo runa ia sia man sani anomo runa ruamo. Auna san rei iake renesi iakanupu makapana sae man te irui sae man osi Anahatana.” ");
INSERT INTO nxl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesus iatinu ata ianamana san reimo iake nai osa, reiso iahata, “Ano haineke nea na mka apusu tau Anahatana irime ne mansiau.” Oyo ia sia man imoniki. Iasei reai tewa nea. ");
INSERT INTO nxl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesus wain iatuhete pan Anahatana ne numa mainisie nusue, oyo iasei ata, “Sapan na rotu-tu sio matuhete Musa ne maunauna oasau ata Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau mo, hasae aia Daud upui momoi. Ne oasau san rei mo, resana. ");
INSERT INTO nxl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Aikee Anahatana Ne Inaha iuna Daud ruai iasau ata, ‘Anahatana iasau osi Upuku, Rue hae hanaku wanane rotu-tu aheta tau me nisau.’ ");
INSERT INTO nxl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Reiso munata Daud ruai ioi Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau tau Upui sani Ia sahoro Ia manonte, Ia mo, hasae Daud upui wain Ia muie man tewa.” Sio hutue oatinui iake. ");
INSERT INTO nxl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iasau honu ata, “Oainati runa sio matuhete Musa ne maunauna. No suka oausahu papi naua waron marainia mai mui, na mansiau onoo ata sio mo, sio mainaya. Sio iae no suka oeuso sui sio manahenia naniao na mansiau oatapeaso. ");
INSERT INTO nxl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Sio iae saka oru-rueso roe uae sui karisaa mainaya. Sio mo, saka oru-rueso tau katerau waron sio mainaya orueso tanre noi ita Yahudiu re numa mananouna. ");
INSERT INTO nxl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Sio mo, saka oakarota sio pina uhanu na onana no numa hutae. Oyo ouna ruao sani sio manisata. Reiso sani oainisi mo, no mainisie rei naue nai osa. Ne Anahatana mka iapasanaso mtinte nai osa.” ");
INSERT INTO nxl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesus wain iru-ruei pan Anahatana ne numa mainisie. Iruei iamanane peti kepen waron orui osi Anahatana. Iasumata sio onusu kepen tanui. Sio kupan kaya panesi onusu kepen panesi. ");
INSERT INTO nxl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Oyo ia pina uhanu mosokinie isa ihokai. Inusu kepen ikina ina ua man pan peti kepen rei na iruire osi Anahatana oi. Areimo kepen panesi tewa, mkana man. ");
INSERT INTO nxl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Oyo Yesus ioi ne mampusua, iahata, “Atinu mai ia-ia nanie uasau osimo. Titue, sio kupan kaya mo, no kepen panesi ne orui mkane man osi Anahatana. Ne ia pina uhanu wain imosokiniki rei mo, irui osi Anahatana renesi sio pusiso wason orui osi Anahatana rei. ");
INSERT INTO nxl_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sio kupan kaya rei onusu no kepen nesia na oruire osi Anahatana. Ne ia pina uhanu mosokinie rei mo, ne kepen tau ne muaine onon ranie rei mo, inusu pusire noi peti kepen na iruire osi Anahatana.” ");
INSERT INTO nxl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesus runa ne mampusua oeu arihon Anahatana ne numa mainisie nusue, oyo ne mampusue isa iasau ata, “Ano Ona Matuhetene, masi anoo. Anahatana ne numa mainisie rei iake. Sio onanai tau hatu maina-mainaya waron iaka.” ");
INSERT INTO nxl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iahata, “Onoo numa mainaya rai? Mka sio okuka Anahatana ne numa mainisie reini na hatu rai ratanuhaha tewa nea. Hatu rai rakukaso arihon nahaya.” ");
INSERT INTO nxl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Oyo Yesus ieui roe pupue wani nanae Saitun. Hoka roe oyo, iruei iamanane Anahatana ne numa mainisie pan ekote hanae pan hae. Oyo Petrus, Yakobis, Yohanis, runa Anreas ohoka mai tanui, nanie oasei tanui tau sio umau okataso tewa nea. ");
INSERT INTO nxl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Oasei ata, “Masi asau mai. Sae waron Ano asau runare mo, inasa rayari? Na sani munata nanie rayari nea mo, nene kakinata waron sapan?” ");
INSERT INTO nxl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iahata, “Osaka ruamo ia-ia. Pene tu-tu mansiau oakarotamo rerihon rai pusire. Mka sio panesi ohoka oasau ata, ‘Au mo, au Aia wain Anahatana Ihitiku na Uapuheu Mansia.’ ");
INSERT INTO nxl_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mka sio panesi ohokaso ohete nanaku oasau ata, ‘Au mo, Ia wain Anahatana Iratiku Uapuheu Mansia’ oyo oakarota sio panesi. ");
INSERT INTO nxl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Sani oatinu hapare rerihoni manahitana mo, pene okaitau. Areimo tau kahurae reeu san rei naone. Ne, tuniai nanie repena mo, tewasi. ");
INSERT INTO nxl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mataanoe niane isa osaa niane isa honu. Mka ia aia isa ieu iahita na ia aia tamene isa honu. Mka isu mainaya sui supa-supan. Mka omata muaine sui supan man. Ne areini mo, pusire nene aikune man sani ia ikine nanie iamrai, inai tiai reun.” ");
INSERT INTO nxl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kahurae osaka-saka. Mka sio osotamo na oruimo osi sio mainaya tau niana-niana. Mka ohitamo sui sio Yahudiu no numa mananouna. Mka ororimo noi sio gubernur runa sio aiau noso opusu Au. Reiso saka osima rerihoni Au. ");
INSERT INTO nxl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kahurae osima na Sou Iake rerihoni Au osi sio niana-niana pusire mai tuniai reini naone. ");
INSERT INTO nxl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mka oaresimo, oyo ororimo oamanane sio onata, pene anomo rauponu runa mka oasau sapan. Mka Anahatana iasau osimo kahurae oasau sapan. Omi ruamo oanamana tewa, ne Anahatana Ne Inaha mka irui anamanaya osimo. ");
INSERT INTO nxl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mka kakai irui wanin wain iparisaa tau Au osi sio ohunui. Wanin irui kakai wain iparisaa tau Au osi sio ohunui. San rei honu na amai na ne hehuka. Sio ikina mka orui noa ama na noa ina osi sio umau ohunso. ");
INSERT INTO nxl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mka mansia pusiki openeso tanumo noso oparisaa tau Au. Ne ia seia iapamese rotu-tu imatai, mka Anahatana iapuheui na pene iapasanai. ");
INSERT INTO nxl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Mka onoo sio oapuoo sae isa wan repaputi reiso reuna Anahatana ieui arihon ne numa. Anahatana isopo na pene oapuooi pan ne numa rei. (Ano wan ahatae tau surate reini, atinu ia-ia na anei.) Sio oapuooi, oyo kahurae omi wan oruemo pan otoe Yudea mo, orumamo na roe tinetaya nea. ");
INSERT INTO nxl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Sio wason pan mui mo, pene onususo pan no numau honu na onana no apia. Tea mo, mka orari tewa nea. ");
INSERT INTO nxl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Sio wason noi nisi iae, pene onunso poe numa na onana no papite. Sio mo, kahurae oaparikuna. ");
INSERT INTO nxl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tau rei mo, mka sio pina onata wason osusu no sio iki msinana runa sio pina matitiana mo, mka siraka tanso nai osa. Tea mo, oruma kua tewa. ");
INSERT INTO nxl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ainisi na pene san rei tau ihate. ");
INSERT INTO nxl_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Pan muie reimo, sinsaraso mainae san sio sinsaraso tewasi on Anahatana ihaye tau tuniai reini asi. Oyo pan muie honu sinsaraso tewa nea. ");
INSERT INTO nxl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ne mka Upuri anoi repeka na sio wason ininiso na ouna ne mansiau. Reiso itapiso sinsaraso rotu-tu potuina tewa. Sinana sinsaraso rotu-tu potuina mo, mka ia isa iamahaiki tewa nea. ");
INSERT INTO nxl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Tau napisi reimo, mka ia isa iasau osimo ata, “Masi onoo. Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau wain ihokai nea. Te, ia isa honu iahata, ‘Mai, ia waipan rei.’ Pene oparisaa tau sio rei. ");
INSERT INTO nxl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tau sae? Sio umau mka ohokaso oasau oakarota ata sio rei wason Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau te sio wason ia mamsima runa Anahatana ne maunauna umau. Mka ouna sima-simana waron ratuhete ata no kawasa rerihoni Anahatana runa sima-simana arihon Anahatana waron rasiraso. Oakarota rea sio wason Anahatana ininiso na ouna ne mansiau. ");
INSERT INTO nxl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Reiso osaka-saka. Uatuhetemo nea, tuniai reini mo repena sapan on repena tewasi.” ");
INSERT INTO nxl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Tau napisi reimo, sinsaraso, oyo ranie repumonoi, hunane reriohui. ");
INSERT INTO nxl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Oneu ramnahuso on roe nante na ranie na hunane rakoka roe nante. ");
INSERT INTO nxl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tau orase rei sirinia mka mansiau onoo Au, Tumata Reini mo, Anahatana Ihitiku uhokaku on roe nante pan yahu anoa. Mka ukaisunu runa we rinane reita-itai runa we kawasa mainae. ");
INSERT INTO nxl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mka uaisosi we maisosia on roe noiyaha na oamanou sio wason Anahatana ininiso na ouna ne mansia. Oamanouso on nau, on ria, on poe, on pan, oyo on pan tuniai rurue rotu-tu rekotoi poe rurue. ");
INSERT INTO nxl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Anei pusu matieue reini. Sani inoo ai ara totua rasineu nea mo, rekakina na anei ata nanie naene na irahuta nea. ");
INSERT INTO nxl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Sani inoo ai ara totua rasineu nea mo, ianei ata mata hun tewa oyo, tuniai reini repena nea. ");
INSERT INTO nxl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Atinu mai ia-ia nanie asau osimo. Titue! Sae waron mato uasau nnare osimo reini, mka rayari on omi naene reini omatamo tewasi. ");
INSERT INTO nxl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nante na tuniai reini mka ranikuso, ne Au we anamanaya mo, mka ranikuso tewa. ");
INSERT INTO nxl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ia seia man iae ianei tewa inasa mka sio sinsaraso san rei. Anahatana ne maisosia roe noiyaha iae, oanei tewa oi. Au Anahatana Anai iae uanei tewa oi. Hasae amaku ruai man sahoro ianei. ");
INSERT INTO nxl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Reiso oainati. Osaka-saka. Oanei tewa inasa na uhokaku honu. ");
INSERT INTO nxl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Areimo sani ia isa ieui arihoni ne numa, oyo ieui hainau. Ia rei iaisosi ne manorina. Irui kawasa osiso na osaka ne numa rei. Sio pusiso osupu no taneiu. Iaisosi ia mamsaka mitanunue isakai ia-ia. ");
INSERT INTO nxl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Reiso osaka-saka. Oanei tewasi inasa na numa upue inuniki. Kani tau ran manne te? Tau saa monon tihu te? Tau manua ratunkeko te? Tau ranie resaa te? Oanei tewa. ");
INSERT INTO nxl_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Pene rotu-tu uhokaku, omi osaka-saka tewa, oyo usupu pusimo oneke munumo. ");
INSERT INTO nxl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sae wan uasaui osimo reini mo, uasau osi sio pusiso, na osaka-saka. ");
INSERT INTO nxl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nesie onona ua man samatoro karisaa anori rapeka na Anahatana ihoka re upu momou arihon otoe Mesir runa karisaa ita Yahudiu iai poroti wan resaa tewa. Sio imam no sio mainaya na sio matuhete Musa ne maunauna wason onina arena, nanie osota Yesus puru-purumene na ohunui. ");
INSERT INTO nxl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Oahata, “Ne pene isotai tau karisaa rei. Tea mo, mka mansia pusiso oatana na umau. Openeso oatin tau ita.” ");
INSERT INTO nxl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tau rei, Yesus waira nia Betania, ria Simon ne numa. Ia mo, naone ikupu unte wan iake tewa nai osa. Oyo ia pina isa ihokai mai Yesus irori potone. Potone rei mo, ounai arihon hatu. Oapataui tau mina tunne wan haue rihue. Mina rei mo, ounai arihon ai namte. Yesus wain iaiki, oyo ia pina rei ihoka, ikuparehi potone rei tionae, samatoro isona mina rei roe Yesus unui. ");
INSERT INTO nxl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Sio umau noi rei oakapuku tanui. Reiso oasei mai umau ata, “Ia pina rei mo, iuna sai-sai mina san rei, nan tahae? ");
INSERT INTO nxl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mina rei mo, sani iaheniki mo, mka isupu kepen panesi. Kepen sani ia isa isupu kati tau musum osa. Kepen rai, mka iruire osi sio mosokinia!” Reiso oakapuku tau ia pina rei. ");
INSERT INTO nxl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ne Yesus iasau osiso ata, “Ia ruai! Omi nanie oakapuku tanui nan tahae? Ia ne hali san rei osiku, areimo iake. ");
INSERT INTO nxl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Sio mosokinia wason okatamo sui osa. Kani mo maue, omaha oakahaiso sui osa. Ne Au mo, mka ukatamo sui osa tewa. ");
INSERT INTO nxl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ia pina reini iuna pusire waron imaha iunare. Mka umataku, oyo oaunutuku, ne ia pina rei isonaku tau mina pusu monne naone nea. ");
INSERT INTO nxl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Atinu mai ia-ia nanie uasau osimo. Sui supa-supan man mai tuniai reini, osima na Sou Iake rerihoni Au, mka oatinu rerihoni ia pina rei na anoo rapeka runai.” ");
INSERT INTO nxl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yudas mo, ia isa arihon Yesus ne mampusua hutusa rahana ua. Ia mo, ia on pan nia Kariot. Ieui pan sio imam no sio mainaya, nanie iahen Yesus osiso. ");
INSERT INTO nxl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Sio nanie ohunui, reiso oatinu tau anamanae rei, anoo mirika. Oahata, “Mka arui kepen osia sani arori Yesus osima.” Reiso Yudas inina arena na irori Yesus osiso. ");
INSERT INTO nxl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tau ranie hatae wan mataanoe arihon karisaa ita Yahudiu iai poroti wan resaa tewa sio orehi rompau. Orehi rompau tau karisaa anori rapeka na Anahatana ihoka rea upu momou arihon otoe Mesir. Tau rei, sio mampusua oasei tau Yesus ata, “Upu. Tau karisaa anori rapeka na Anahatana ihoka rea upu momou arihon otoe Mesir mo, nanie aseka tau re muaina sui supa?” ");
INSERT INTO nxl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Reiso Yesus iaisosi sio ua ata, “Uamo oeu roe kota Yerusalem. Mka onusu kota rei, onoo ia hanaie isa iasaoa tihu naniae wan nanae unene. Oeu opusui. ");
INSERT INTO nxl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mka inusu numa isa. Hoka noi, oyo oasei tau numa upue ata, ‘Upu. Ma ia matuhetene inina kamar wan nanie iai ikata ne mampusua. Nanie iai tau karisaa anori rapeka na Anahatana ihoka rea upu momou arihon otoe Mesir. Reiso kamar na iaiki wanpa?’ ");
INSERT INTO nxl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mka iautuu na kamar isa roe naue wan mainae. Katerau runa pusire waroro matane nea. Seka tau pusire roe rei nea.” ");
INSERT INTO nxl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Reiso uaso oeuso roe kota rei. Hoka roe, oyo onoo pusire pannuhu sani sae waron Yesus iasau runare rei. Reiso oseka tau muai karisaa rai. ");
INSERT INTO nxl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nene pumono pan san rei, Yesus ihokai roe kamar rei ikata ne mampusua hutusa rahana ua rei. ");
INSERT INTO nxl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Hoka roe, oyo oaiso. Sio wason oaiso, oyo Yesus iasau ata, “Atinu mai ia-ia nanie uasau osimo. Ia isa arihon omi reini wain iaiki ikataku, mka iaheniku osi sio wason nanie ohunuku.” ");
INSERT INTO nxl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Oatinu tau rei, anoo nnai. Ia isa iasei ata, “Ia reimo, au te sae rei?” Oyo ia isa honu iasei honu ata, “Ia reimo, au te sae rei?” Oasei rotu-tu pusiso oasei san rei. ");
INSERT INTO nxl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Oyo Yesus iasau ata, “Ia rei mo, ia isa arihon om hutusa rahana ua reini. Ia rei mo, wain inono poroti poe pirune osa runaku. ");
INSERT INTO nxl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tea mo, Au, Tumata reini mo, Anahatana Ihitiku mo, mka umataku sani Anahatana iaunutui nea rei. Ne ia wain iaheniku osi we nisau mo, mka siraka tanui. Nene iake tau ia rei, pene iamrai nea.” ");
INSERT INTO nxl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Reiso wason oaiso, oyo Yesus inana poroti oyo iainisi iainaa na Anahatana. Iahata, “Ama. Uainisi iake arihonia. Ano mo, Ano aia tau nante na tuamane pusiki utui. Auna gandum raruhu on poe tuamane na auna poroti tanui.” Oyo ikihoi tau hanai, isamai osi ne mampusua, iahata, “Onana poroti rei na oaiki. Areini mo, tinaiku.” ");
INSERT INTO nxl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ita inana koinanae. Iainisi iake arihon Anahatana. Iahata, “Ama. Uainisi iake arihonia. Ano mo, Ano Aia tau nante na tuamane pusiki utui. Ahaye tau anggur huaya.” Oyo irui koinanae rei osi ne mampusua. Sio pusiso oninu mkane-mkane. ");
INSERT INTO nxl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Iahata, “Areini mo, Au we nasi. Mka umataku, we nasi renia na sio pusiso oanei ata Anahatana iuna osiso sani naone itotoe. We nasi rei renia tau sio panesi. ");
INSERT INTO nxl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Atinu mai ia-ia, nanie uasau osimo. On reini, Au mka uninu tihu anggur tewa nea rotu-tu Anahatana irime ne mansiau.” ");
INSERT INTO nxl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Oyo sio ohete ahinae oainaa na Anahatana samatoro oeuso roe pupue wan nanae Saitun. ");
INSERT INTO nxl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesus sio wason oeuso roe pupue wan nanai Saitun. Wason arena tinai tihue oyo iasau osi ne mampusua ata, “Mka pusimo orumamo oarihoniku. Tea mo, oaunutui tau Anahatana ne anamanaya ata Anahatana iasau san reini, ‘Mka uhunu ia mamsakae, oyo ne rompau pusiso oruma wena-wenaso. Sio umau su ria, sio umau su nau.’ ");
INSERT INTO nxl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ne mka uamahaiku honu, oyo ueu uanaone poe otoe Galilea. Mka opusu tau muie.” ");
INSERT INTO nxl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petrus iasau ata, “Upu. Masike sio pusiso oeu arihonia iae, mka au mo, ueu uarihon ano tewa.” ");
INSERT INTO nxl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Oyo Yesus iasau ata, “Atinu mai ia-ia, nanie uasau osimo. Mka-mka pumono, manue retunkeko nai ua tewasi oimo, ano asau ata ationa Au tewa, rotu-tu nai tonu.” ");
INSERT INTO nxl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Iahata, “Uasau osia, Upu. Masike umataku nnaya iae, upeneku uasau ata uationaya tewa!” Oyo ne mampusua pusiso oasau san rei oi. ");
INSERT INTO nxl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Oyo Yesus na ne mampusua oeuso ria nisi wan nanae Getsemani. Hoka ria, oyo iasau osi ne mampusua ata, “Oru-ruemo mai rei, na ueu uainisi arihon Anahatana.” ");
INSERT INTO nxl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Oyo ieu ikata Petrus, Yakobis, na Yohanis. Anoi reuponu. Iahana anoi mtinte nai osa. ");
INSERT INTO nxl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Iahata, “Anoku mtinte nai osa. Uahana nanie umataku nea. Onapa mai rei na osaka-saka.” ");
INSERT INTO nxl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Oyo ieui hainau mkane, samatoro irike tune poe tuamane. Iainisi tau Anahatana na kani pene sinsarai. ");
INSERT INTO nxl_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Iahata, “Ama, amaku, Ano amaha auna sae man. Reiso uainisi arihonia na kani pene sinsaraku. Ne pene pusu Au we maue. Ne pusu Ano me maue.” ");
INSERT INTO nxl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Oyo Yesus inuniki poe ne mampusua tonu rei. Isupuso wasopo onekeso. Iasei tau Petrus ata, “Simon, anekea rei si? Ueu uarihonimo potuina tewasi, ne omaha osaka-saka tewa! ");
INSERT INTO nxl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Saka oainisi tau Anahatana na iakahaimo na pene ia aia sakahatene ireamo na opalalosa. Mansate, anomo nanie rapusu manisate. Ne okua tewa tau tinaimo ramankaeso.” ");
INSERT INTO nxl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Oyo ieu iarihonso honu, nanie iainisi san sinasi rei honu. ");
INSERT INTO nxl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Iainisi pusi oyo, inuniki honu pan tonso. Isupu tonso onekeso honu. Tea mo, matao usena mtinta. Reiso oanei tewa nanie oasau sae osi Yesus. ");
INSERT INTO nxl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yesus inuniki mai tanso nai tonu, oyo iasei ata, “Onekemo oaranahamo asi? Onekemo hasae rei nea. Mata hun tewa nea, mka oahen Au, Tumata Reini mo, Anahatana Ihitiku, osi sio wason opalalosa. ");
INSERT INTO nxl_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ohanumo roe, na ieuta. Onoo ia wain iruiku wain ihokai nea.” ");
INSERT INTO nxl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesus wain ianamana asi mo, sira tau Yudas, ia isa arihon sio mampusua hutusa rahana ua rei, ihokai ikata sio panesi. Sio rei orori tunua runa kahitata. Sio imam no sio mainaya, sio matuhete Musa ne maunauna, runa sio ona Yahudi nesia rei sahoro oaisosi sio rei na nanie osota Yesus. ");
INSERT INTO nxl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudas iasau osiso nea ata, “Ia wain oninai mo, mka umukiki na oationai. Osotai oyo ororiki. Osakai ia-ia.” ");
INSERT INTO nxl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ihoka noi, oyo sira tau ieui haineke Yesus. Iahata, “Ano Ona Matuhetene.” Oyo imukiki. ");
INSERT INTO nxl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Imukiki oyo, sio rei osotai na oaresiki. ");
INSERT INTO nxl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ia isa wain hainekeso, isaru ne tunue, oyo iseha sio imam no ia mainae ne manorine isa tinai totue hae. ");
INSERT INTO nxl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Oyo Yesus iasei tanso ata, “Omi ata kan Au mo, Au kahatene si? Tu-tu ohokamo orori tunua na kahitata nanie osotaku si? ");
INSERT INTO nxl_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Aikee onon ranie uatuhetemo pan Anahatana ne numa mainisie, ne osotaku tewa. Ne osotaku san reini mo, reeu sani Anahatana ne anamanaya reasau.” ");
INSERT INTO nxl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Oyo sio mampusua pusiso oruma oarihon Yesus. ");
INSERT INTO nxl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ia hanai nasonane isa pan rei, irehe nipae man, ipusu Yesus. Oyo sio nanie osotai, ");
INSERT INTO nxl_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ne inosu ne nipae rei, oyo irumai sanakui. ");
INSERT INTO nxl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Sio orori Yesus pan sio imam no ia mainae. Hoka pan oyo, sio imam no sio mainaya, sio matuhete Musa ne maunauna, na sio ona Yahudi nesia rei pusiso oamanouso. ");
INSERT INTO nxl_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petrus ipusu Yesus on ria hainau rotu-tu inusui pan sio imam no ia mainae rei ne numa tihue. Hoka pan oyo, iruei iasa tinain haineke usa ikata sio mamsakaya. ");
INSERT INTO nxl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sio imam no sio mainaya runa sio siniriu pusiso onina sio umau na osima runa Yesus ne isanaya na oruiki osi sio wason no kawasa ohunui. Ne osupu ne isanae isa tewa. ");
INSERT INTO nxl_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Sio panesi ohoka orun oakarota rerihoni Yesus, ne no mamrunia osa tewa. Pusiso oruni tamena-tamena. Reiso no kawasa tewa na oaisosi sio ohunui. ");
INSERT INTO nxl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Oyo sio umau ohitio roe, samatoro oruni oakarota rerihoni Yesus ata, ");
INSERT INTO nxl_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ami atinui iasau ata, ‘Mka ukohu Anahatana ne numa mainisie reini wan mansia onanai, oyo onona ua, uapuoo honue honu. Areimo mansia oakahaiku uapuooi tewa.’” ");
INSERT INTO nxl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Aikee sio no mamrunie osa tewa. ");
INSERT INTO nxl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Reiso sio imam no ia mainae iooi kua tihue, oyo iasei tau Yesus ata, “Sio rei orun me kahatena. Ne Ano asau sae isa tewa tau sae?” ");
INSERT INTO nxl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ne Yesus iamaturui man. Iasau sae isa tewa. Oyo sio imam no ia mainae rei iasei honu ata, “Ano mo, Ia Aia wain Anahatana Ihitia na Apuheu Mansia si? Ia sahoro ami ainaa nnai, Anai si?” ");
INSERT INTO nxl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iahata, “Au wan rei nea rei tea. Mka pusimo onoo Au, Tumata Reini mo, Anahatana Ihitiku, urue mai Ia wain Ne Kawasa hanai wanane. Mka uhokaku honu on roe nante pan yahu anoa.” ");
INSERT INTO nxl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Iatin san rei, oyo sio imam no ia mainae ikiha ne papite na sio oanei ata anoi resaa tau Yesus. Iahata, “Reiso pene susa nina sio umau wason onoo tau matao nea. ");
INSERT INTO nxl_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Omi ruamo oatinui ianamana sani Ia mo, Anahatana rei. Oapamata sou sapan?” Sio pusiso oapamata sou ata Yesus isana, reiso kahurae ohunui. ");
INSERT INTO nxl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Oyo sio umau ohuto Yesus, okanihoo nete matai usena na inoo mosa tewa, oyo ohitai oaumaniki. Oasau osiki ata, “Masi asima mai. Ia seia ihitaya?” Sio mamsakaya ohita Yesus panesi oi. ");
INSERT INTO nxl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petrus waipan iasai pan usa asi, oyo ia pina makahaie isa tau sio imam no ia mainae ihokai mai tanui. ");
INSERT INTO nxl_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Inoo ata Petrus wain iasa tinain haineke usa, oyo iarinii uai anoe ia-ia, samatoro iasei tanui ata, “Ano sahoro akata ia Nasaret rei oi rei tea! Ia Nasaret wain nanai Yesus rei tea!” ");
INSERT INTO nxl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Iahata, “He. Au mo, uationa Ia rei tewa. Uanei tewa. Ano wan asau na sae rei?” Oyo Petrus ieui pan mitanunue. ");
INSERT INTO nxl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ia pina makahaie rei inoo Petrus, oyo iasau osi sio pan rei ata, “Mansate, ia reini mo, ia isa arihon sio wason opusu Yesus rei.” ");
INSERT INTO nxl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Iahata, “Au? Au mo, tewa!” Oyo sira tau sio pan rei oasau osi Petrus ata, “Titue! Ano mo, ano isa arihon sio rei. Tea mo, ano on ria otoe Galilea tea!” ");
INSERT INTO nxl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Oyo Petrus isopa ihete Anahatana. Iahata, “Uationa Ia rei tewa. Sani uakarota mka Anahatana iapasanaku!” ");
INSERT INTO nxl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mata hun tewa oyo, manue retunkeko honu. Retunkeko nai ua nea. Oyo Petrus anoi repeka na Yesus ne anamanae. “Mka-mka mono repan, manue retunkeko nai ua tewasi oi mo, ano auhaa nai tonu nea ata ationaku.” Reiso Petrus iran anoi repunoko nai osa. ");
INSERT INTO nxl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nene omnano tunne san rei, sio imam no sio mainaya, sio matuhete Musa ne maunauna na sio siniriu pusiso oapamata sou. Okanihoo Yesus, oyo ororiki poe gubernur wain nanai Pilatus. ");
INSERT INTO nxl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Hoka poe, oyo Pilatus iasei tanui ata, “Areimo mansate? Ano sahoro auna natu tau sio Yahudiu si?” Iahata, “E-e. Areimo sani ano wamo asaui rei tea!” ");
INSERT INTO nxl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sio imam no sio mainaya oamanaru Yesus ata, “Ia reimo, ne masanau panesi.” ");
INSERT INTO nxl_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Reiso Pilatus iasei Yesus honu ata, “Ano asau sae isa tewa? Masi anoo, sio wason osima sapan runaya.” ");
INSERT INTO nxl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ne Yesus iamaturui man. Pilatus inoo san rei, isira. ");
INSERT INTO nxl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tau karisaa anori rapeka na Anahatana ihoka re upu momou arihon otoe Mesir mo, Pilatus saka ihoka ia isa arihon pui sani sio oainisi. ");
INSERT INTO nxl_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pan pui anoe ia isa wain nanai Barabas. Ikata sio wason oatana na sio kupaniau, reiso ohunu sio umau. ");
INSERT INTO nxl_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Reiso sio panesi ohokaso, oyo oainisi arihon Pilatus ata, “Upu. Ami ainisi arihonia na ahoka ia isa arihoni pui anoe sani auna sui osa tau karisaa reini.” ");
INSERT INTO nxl_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatus iasei tanso ata, “Onina na uhoka ia natu tau omi Yahudiu osimo?” ");
INSERT INTO nxl_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Iasei san rei tau inoo ata sio imam no sio mainaya orui Yesus osiki tau sio oananai. ");
INSERT INTO nxl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ne sio imam no sio mainaya rei oasau osi sio panesi rei ata, “Oainisi na ihoka Barabas. Pene oainisi na ihoka Yesus.” Reiso oainisi Barabas. ");
INSERT INTO nxl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Oyo Pilatus iasei honu tau sio panesi rei ata, “Reiso omi onina na una sae runa Ia reini? Ia wain omi oiki tau natu tau omi Yahudiu.” ");
INSERT INTO nxl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Oakapona ata, “Pakui roe hini wan reniene!” ");
INSERT INTO nxl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Iasei, “Tau sae? Ia ne isanae sae?” Oyo oakapona renesi sinasi ata, “Pakui roe hini wan reniene!” ");
INSERT INTO nxl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatus inina na sio anoo iaka reiso ihoka Barabas osiso. Oyo iaisosi sio umau osapu Yesus tau awane unia. Osapui samatoro iruiki osi sio umau na opakui roe hini wan reniene. ");
INSERT INTO nxl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sio tantarau orori Yesus pan Pilatus ne numa, oyo oanaha na no sio tantarau tikane pusiso. Oanaha runaso, oyo oamanouso. ");
INSERT INTO nxl_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Sio nanie oauman Yesus tau sio oaoiki tau natu. Reiso oausahu papi msinae osiki, oyo opepe awane unie wan nonae, samatoro oausahui roe unui. ");
INSERT INTO nxl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Oyo oatapeai. Oahata, “Arue nai-naim, natu tau sio Yahudiu.” ");
INSERT INTO nxl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ohita-hita unui tau ai sanae, oyo ohutoi, samatoro orike tune mai Yesus sani oamuirai. ");
INSERT INTO nxl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Oaumaniki pusi, oyo onosu papi msinae rei, oyo oausahu ruai ne papite osiki honu. Oyo ororiki pan manahane nanie opakui roe hini wan reniene. ");
INSERT INTO nxl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sio otentene tau Simon, ia Kirene, na ihana Yesus ne hini wan reniene osiki. Ia rei Aleksander runa Rupus amai. Ia mato ihokai on pan niane isa, nanie inusu roe kota. ");
INSERT INTO nxl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Reiso orori Yesus roe pupue wan nanae Golgota. Golgota nene nohue mo, unuke kanie. ");
INSERT INTO nxl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Hoka roe oyo, nanie oruiki ininu tihu anggur wan onehui na mur na pene iahana tinain reina. Ne ipenei ininu. ");
INSERT INTO nxl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Oyo opakui roe hini wan reniene rei, samatoro orehi katoite, nanie osama-sama Yesus ne apia osi ruao. ");
INSERT INTO nxl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Opakui roe hini tau ranie rehiti-hiti. ");
INSERT INTO nxl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Okanu roe hini rei, roe unui hahae, Ia ne isanae sapan. Okanu, “Natu tau sio Yahudiu.” ");
INSERT INTO nxl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Opaku Yesus runa sio kimanakana ua roe hiniu waron raniene oi. Opaku ia isa mai Yesus hanai wanane na ia isa honu mai hanai pante. ");
INSERT INTO nxl_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ouna sani Anahatana ne anamanaya raasau ata, “Oahata Ia rei mo, ia isa arihon sio kahatena.” ");
INSERT INTO nxl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Sio wason onikuso, okoka unuo oaumaniki, oyo orati osohiki, ata, “He. Ano asau ata mka akohu Anahatana ne numa mainisie, oyo onona ua, apuooi honu. ");
INSERT INTO nxl_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Masi asipua arihon hini na apuheu ruam.” ");
INSERT INTO nxl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Sio imam no sio mainaya runa sio matuhete Musa ne maunauna oaumaniki oi. Oahata, “Hmm! Iapuheu mansia tamene, ne ianei iapuheu ruai tewa. ");
INSERT INTO nxl_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Sani ia reimo natu Israel, Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau, mo kahurae isipui arihon hini rei na inoo na iparisaa tanui.” Sio ua wason opakuso roe hiniu okatai rei iae, orati sohiki oi. ");
INSERT INTO nxl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tau ranie katopu san rei, otoe rei repumonoi pusiki rotu-tu yam tonu ranie remanu. ");
INSERT INTO nxl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Oyo nene yam tonu, ran manne san rei, Yesus iakapona nioi mainae tau ruai ne sou. Iahata, “Eli, Eli lama sabakhtani?” Nene nohue mo, “Anahatana wain uainaa runaya, Anahatana wani uainaa runaya ee! Nanie aeu arihoniku tahae?” ");
INSERT INTO nxl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sio umau wasomo ooso haineke oatinui ioi san rei, reiso oasau ata, “Masi oatinu. Ioi Elia.” Elia mo, naone ia wain ia mamsima runa Anahatana ne maunauna. ");
INSERT INTO nxl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ia isa roe rei irumai inana nokasa sanae. Inonoi poe tihu anggur wan maninue, samatoro isipai tau ai sanae rurue. Oyo isopai roe Yesus sihurui, inina na Yesus ininu tihu rei. Isopai roe, iahata, “Tapiki! Mai, na inoo ata kani Elia ihokai iratiki arihon hini wan reniene rein te tewa.” ");
INSERT INTO nxl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Oyo Yesus iakapona mainae, samatoro watipusi nahai. ");
INSERT INTO nxl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tau rei sinia, nipa kapitorune naue wan sio oakatanai roe Anahatana ne numa mainisie anoe na renete kakarana monne rei, wakihai tau ua on roe rurue rotu-tu poe rurue. ");
INSERT INTO nxl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Oyo ia kapitane tau sio tantara Roma utun iooi mai hini rei uae iatinu Yesus iakapona na inoo Yesus imatai sapan. Iahata, “Titue maa! Ia reini mo, Anahatana Anai.” ");
INSERT INTO nxl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Sio pinau umau wason roe rei oi. Wason oasumata pusire on poe hainau. Sio rei mo, Salome, Maria arihon nia Magdalena, runa Maria (Yoses na Yakobis nasonane, inai). ");
INSERT INTO nxl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tonso opusu-pusu Yesus. Sani ihokai pan otoe Galilea, oakahaiki. Roe rei iae, sio pinau panesi oi. Sio rei ohokaso mai Yerusalem okata Yesus. ");
INSERT INTO nxl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ranie hatae rei, areimo ranie hatae wan sio oatanunu tau hanroe. Tea mo, hanroe mo, ranie hatae wan iamuira Anahatana. Tau ran manne nea, ");
INSERT INTO nxl_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yusup arihon nia Arimatea ihokai. Ia rei mo, ia isa arihon sio ona Yahudiu. Sio panesi oationai na oamuirai. Ia iae, wain inapa-napa na Anahatana irime ne mansiau. Reiso Yusup iapamese anoi, oyo ihokai mai Pilatus nanie iainisi Yesus hatai. ");
INSERT INTO nxl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatus iatinu ata Yesus imatai nea, isira. Reiso iaisosi ia isa ioi ia kapitane tau sio tantara Roma utun rei. Hoka mai oyo iasei tanui ata, “Yesus imatai nea?” ");
INSERT INTO nxl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Iahata, “E-e, upu. Imatai nea.” Oyo Pilatus iamanaku. Iasau osi Yusup ata, “Aeu anana hatai rei nea.” ");
INSERT INTO nxl_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Oyo Yusup ihane nipae isa wan ohie, samatoro iaputunu Yesus, oyo iopai tau nipae rei. Oyo inusu hatai rei pan hatu nohue. Hatu nohue rei mo, ounai arihon hatu tatepie. Inusu tihane hatae rei, samatoro ikamaun hatu mainae isa renete hatu nohue rei nene mitanunue. ");
INSERT INTO nxl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria, ia Magdalena, runa Maria, Yoses inai, oasumata sio oaunutui. ");
INSERT INTO nxl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ranie hatae wan sio Yahudiu oamuira Anahatana renikui nea, oyo Salome, Maria (arihon nia Magdalena) na Maria (Yakobis inai) tonso oeuso ohane mina hau rihue nanie osonai roe Yesus tinain. ");
INSERT INTO nxl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tau omnano tunne, ranie hatae mataanoe arihon minku unue rei, oeuso poe hatu nohue tau ranie resaa nea. ");
INSERT INTO nxl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Oasei tau umau ata, “Ia seia mka iakahaita na ikamauni hatu wan renete hatu nohue nene mitanunue omi?” ");
INSERT INTO nxl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Hoka poe oyo, onoo roe uae, samatoro onoo ata sio okamauni hatu rei arihon mitanunue nea. Hatu rei mainae nai osa. ");
INSERT INTO nxl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Reiso onususo pan hatu nohue rei anoe, samatoro sira tau onoo ia nasonane isa iru-ruei mai hanao wanana. Ia wain iausahu papi naue wan putie. Onoo ia nasonane rei, reiso osira hun ruao. ");
INSERT INTO nxl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ia nasonane rei iasau osiso ata, “Pene osira. Onina Yesus arihon nia Nasaret. Ia wain sio opakui roe hini wan reniene. Ia mo, iamahaiki honu nea. Ia mo, wain rei tewa nea. Masi onoo, naniai wan oaunutui wapan rei. ");
INSERT INTO nxl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ne masi oeu orun osi Petrus na ne mampusua pusiso. Osima osiso ata, ‘Yesus wain ieu ianaone poe otoe Galilea nea. Poe rei, omi mka onooi sani naone iasau osimo rei.’” ");
INSERT INTO nxl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Reiso ohokaso arihon hatu nohue rei, oyo orumaso. Tea mo, osira na okaitau. Oasau sae isa tewa osi ia seia man oi. Tea mo, okaitau hun ruao. ");
INSERT INTO nxl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesus iamahaiki honu tau omnano tunne tau ranie hatae mataanoe arihon minku unue rei. Mataanoe mo, iatuhete ruai osi Maria, ia pina Magdalena. Ia mo, naone Yesus inei sakahatena itu arihoniki. ");
INSERT INTO nxl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Reiso Maria, ia pina Magdalena rei, ieu isima ata inoo Yesus wain iamahaiki honu. Isima osi sio wason naone okata Yesus. Sio rei wason orani oasanoata. ");
INSERT INTO nxl_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ne oatinu ata Yesus wain iamahaiki honu. Oatinu ata Maria inooi nea, ne oparisaa tewa. ");
INSERT INTO nxl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Oyo Yesus iatuhete ruai osi ne mampusua ua. Uaso onooi tamene. Onooi pannuhu wason oeuso mai nisiu. ");
INSERT INTO nxl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Reiso onunso, oyo orun osi no netau. Oahata, “Ira oe! Ami anoo Yesus wain iamahaiki honu!” Ne no netau rei oparisaa tewa sinia. ");
INSERT INTO nxl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tau muie, Yesus iatuhete ruai osi ne mampusua hutusa rahana osa pannuhu wason oaiso. Iasau nioi mainae. Tea mo, sio opisa unuo tewa na unuo onata reiso oparisaa tau sio wason orun-run rei tewa. Orun ata onoo Yesus wain iamahaiki honu nea. ");
INSERT INTO nxl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Oyo Yesus iasau osiso ata, “Oeu ohori niana-niana pusire mai tuniai reini. Osima na Sou Iake rerihoni Au. Osima osi sio pusiso mai tuniai reini. ");
INSERT INTO nxl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ia seia wain iparisaa, oyo osohui na mansiau oanei ata iarihon ne rosau nea, Anahatana iapuheui na pene iapasanai. Ne ia seia iparisaa tewa, mka Anahatana iapasanai. ");
INSERT INTO nxl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Sio wason oparisaa, mka ouna sima-simana waron ratuhete ata no kawasa arihon Anahatana. Ouna sima-simana sani onei sakahatena tau Au we kawasa, oanamana tau sou waron ruao oaneire tewa. ");
INSERT INTO nxl_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Munata orime tekene te oninu minne, sio rei okupu tewa, omata tewa. Munata oahusie sio kupua tau hanao, mka sio kupua rei iake. Okupu tewa nea.” ");
INSERT INTO nxl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Upuri Yesus iaunauso pusi, oyo Anahatana iapusaai na roe noiyaha. Roe rei, Yesus isupu kawasa reiso iruei mai Anahatana hanai wanane. ");
INSERT INTO nxl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Reiso ne mampusua oeu osima na Sou Iake rerihoni Anahatana sui niana-niana mai tuniai reini pusiki. Upuri iakahaiso oi na ouna sima-simana waron ratuhete ata no kawasa arihon Anahatana. Tau rei, sio pusiso oanei ata no anamanaya manisata.");
INSERT INTO nxl_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Osi upuku Teopilus. Sio panesi okanu surata nea. Nanie osima runa sae waron Yesus iunare on ikatama asi. ");
INSERT INTO nxl_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Sio wason ruao onoo tau matao osima osi sio umau oi. Onoore on mataanoe asi, on Yesus iamrai sahoro osima runa pusire reini. Oyo sio wason oatinu rei, oanori na Anahatana na okanure. ");
INSERT INTO nxl_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Au iae uasei runa pusire ia-ia on mataanoe nea. Reiso Teopilus wain ami amuiraya, uahana iake sani au iae, ukanu ia-ia na usima runa pusire osia oi. ");
INSERT INTO nxl_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ukanu san rei na ano anei ata sae waron sio oatuhetea tanure na osima runa Yesus rei, arai pusire mo, titue. ");
INSERT INTO nxl_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tau Herodes iuna aia pan otoe Yudea mo, ia imam isa wain nanai Sakaria waimo. Ia mo, ia arihoni sio imam wason noa upu tau Abia. Sahai nanai Elisabet. Ia iae, nea upu arihoni sio imam rei oi. ");
INSERT INTO nxl_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Anahatana inoo ata uaso anoo manisata. Uaso opusu Upuri ne maunauna pusire ia-ia. Ouna sui sae waron Upuri iaisosiso ounare rei. ");
INSERT INTO nxl_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ne osusu tewa. Elisabet ikaimeniki. Uaso okore-koreso nea. ");
INSERT INTO nxl_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Taue isa Sakaria runa ne neta imam sio wason osaka roe Anahatana ne numa mainisie. Pusiso osaka okati-kati umau. Sakaria wain ianori na Anahatana iuna imam. ");
INSERT INTO nxl_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sio orehi katoite oroma ia imam isa wain mka ianori runa Anahatana. Reiso katoite reutuu pannuhu Sakaria na inusui pan Upuri Anahatana ne numa mainisie pan anoe. Inusui oyo iakanupu kumaniane. ");
INSERT INTO nxl_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wain iakanupu kumaniane osi Anahatana pannuhu mansia hutue wason pan mui oainisi. ");
INSERT INTO nxl_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Wain iakanupui oyo, sira tau Upuri ne maisosie isa on roe noiyaha iatuhete ruai osiki. Ia maisosie rei iooi kua meya nusue hae wanane. Meya wan oakanupu kumaniane tanui rei. ");
INSERT INTO nxl_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakaria inoo ia maisosie rei, oyo isira. Ikaitau hunu ruai. ");
INSERT INTO nxl_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ne ia maisosie rei iahata, “Sakaria. Pene akaitau. Anahatana iatinu me mainisie nea. Mka saham Elisabet isusu. Anai rei, mka ia iki hanaie. Reiso ahete nanai tau Yohanis. ");
INSERT INTO nxl_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mka ia ikine rei iamrai poe, oyo anom mirike. Sio panesi iae, mka anoo mirika oi. ");
INSERT INTO nxl_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Anomo mirika tau ia ikine rei. Upuri mka inoo ia ikine rei mo, ia mainae. Mka ininu tihu anggur te tihu minne tewa. On pan saa pumono asi, ia ikine rei isupu kawasa arihoni Anahatana Ne Inaha nea. ");
INSERT INTO nxl_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mka iakahai omi Israel panesi na oneni anomo na opusu moa Upu Anahatana honu. ");
INSERT INTO nxl_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ia ikine rei, mka ianaone arihon Upuri. Isupu ne inaha runa ne kawasa sani Elia. Mka iuna noa amau anoo runa no hehuka honu. Iatuhete sio wason sio kahatena na oanei sae waron iaka, sae waron iaka tewa sani sio wason anoo manisata. Iuna san rei na sio oatinu tau Upuri.” ");
INSERT INTO nxl_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Oyo Sakaria iasei tau ia maisosie rei, “Sapan na uanei ata sae wani ano asau runai rei mo, titue? Ukore-koreku nea reini. Sahaku iae ikore-korei nea oi.” ");
INSERT INTO nxl_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Iahata, “Au reini mo, au Gabriel. Uoo ukata Anahatana na, uanori runai. Ia sahoro iaisosiku mai na usima na Sou Iake rerihoni Anahatana reini osia. ");
INSERT INTO nxl_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Masi atinu. Aparisaa tewa reiso mka akumoua. Akumoua rotu-tu ia ikine rei iamrai. Anahatana ihete umetene nea na iuna sui sae wani uasau runai osia reini.” ");
INSERT INTO nxl_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sio hutue wason onapa-napa Sakaria pan mui rei oasei pan anoo, “Ira oe! Iapuari pan Anahatana ne numa mainisie anoe tau sae rei?” ");
INSERT INTO nxl_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Oyo sira tau ihokai. Ne ianamana sae isa osiso tewa. Hasae iatieu man. Tea mo, iakumoui nea. Reiso sio hutue rei oanei ata inoo sae isa pan Anahatana ne numa mainisie anoe. ");
INSERT INTO nxl_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sakaria ianori roe Anahatana ne numa rotu-tu ne tanei pusiki, oyo inuniki poe ne numa honu. ");
INSERT INTO nxl_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Inuniki oyo, ereeu potuina tewa oi. Oyo, sira tau sahai Elisabet tinain taua. Tinain taua oyo, Elisabet ihokai arihoni no numa tewa rotu-tu hunana nima. ");
INSERT INTO nxl_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Iahata, “Upuku iakahaiku san rei nea. Inea we kaumaata pusire arihoniku nea.” ");
INSERT INTO nxl_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet tinain taua hunana nome nea, oyo Anahatana iaisosi Gabriel. Gabriel mo, Anahatana ne maisosie on roe noiyaha isa. Iaisosiki ieui poe otoe Galilea poe nia Nasaret. ");
INSERT INTO nxl_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Reiso ieu. Oyo ihoka poe ia pina hehu tunne isa wain nanai Maria. Ia pina hehuke rei mo, Yusup ne haene. Yusup mo, ia aia Daud upui. ");
INSERT INTO nxl_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabriel ihokai poe Maria, oyo iahata, “Tapea! Ano wani Anahatana irui iake mainae osia! Upuri ikata runaya!” ");
INSERT INTO nxl_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Iatinu tau rei oyo, anoi ererue tewa. Iasei pan anoi, “Iatapeaku san rei, nanie tahae?” ");
INSERT INTO nxl_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ne Gabriel iahata, “Maria, pene akaitau. Anahatana inoo ano iake. ");
INSERT INTO nxl_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mka asusu. Ia ikine rei, mka ia iki hanaie. Ahete nanai tau Yesus. ");
INSERT INTO nxl_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ia mo, mka iuna mainae. Mka oiki tau Anahatana wain Ia Mainae Nai Osa Anai. Upuri Anahatana mka ihitiki iuna natu sani upui aia Daud oi. ");
INSERT INTO nxl_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mka iuna Aia irime Yakup nea upu momou rotu-tu ria supan.” ");
INSERT INTO nxl_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria iasei, “Areimo mka sapan? Uneke ukata ia hanaie isa tewasi reini!” ");
INSERT INTO nxl_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Iahata, “Mka Anahatana Ne Inaha isipui tanua. Oyo Anahatana wain Ia Mainae Nai osa rei ne kawasa iaraonoa. Oyo tinaim taua. Reiso ia ikine wain mka asusui rei mo, ia manisate onate. Sio mka ooiki tau Anahatana Anai. ");
INSERT INTO nxl_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Me mansia wain nanai Elisabet, ia iae tinain taua hunana nome nea oi. Ia ikine rei iae, mka ia iki hanaie oi. Masike ikore-korei nea iae, na sio oasau ata ikaimeniki iae, tinain taua sirinia. ");
INSERT INTO nxl_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tea mo, Anahatana ne kawasa iuna sae man.” ");
INSERT INTO nxl_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria iahata, “Iake. Au wani una manorine tau Upuri. Anahatana iuna sani ano asau rei mo, iake.” Oyo ia maisosie rei ieui iarihoniki. ");
INSERT INTO nxl_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Anahatana ne maisosie on roe noiyaha ianamana runa Maria pusi oyo, Maria iautotu ne apia nanie ieu pan niane isa pan otoe wani nene pupua panesi pan otoe Yudea. ");
INSERT INTO nxl_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Hoka pan oyo, ieui roe Sakaria ne numa. Ihoka roe oyo, inusui pan numa anoe, oyo iatapea Elisabet. ");
INSERT INTO nxl_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet iatinu Maria iatapeai, oyo ia ikine wain pan saa pumono rei nisui. Elisabet ruai isupu kawasa arihoni Anahatana Ne Inaha oi. ");
INSERT INTO nxl_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Reiso Elisabet iakapona nioi mainae. Iahata, “Anahatana irui iake osia renesi ita pinau pusita. Anahatana irui iake osi anam wain mka iamrai. ");
INSERT INTO nxl_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Au reini mo, au seia rotu-tu Upuku inai ihokai mai tanuku reini? ");
INSERT INTO nxl_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Uatinu ano atapeaku, oyo ia ikine wain pan saa pumono rei nisui, anoi mirike, tea! ");
INSERT INTO nxl_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Anahatana irui iake osia tau aparisaa ata sae wani Upuri iasau osia rei mo, mka reeu sani naone iasau rei!” ");
INSERT INTO nxl_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria iahata, “Upu. Uainaa runaya. ");
INSERT INTO nxl_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Anoku mirike tau Upuku apuheuku na pene apasanaku. ");
INSERT INTO nxl_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Anom repeka runa me manorine, au reini. Au mo, au mainae tewa! Au ikine man. Ne on muie reini mo, mka sio napisi tau napisi pusiso oasau ata Upuku arui iake osiku. ");
INSERT INTO nxl_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tea mo, Upuku sahoro me kawasa mainae arihoni rai pusire. Auna sae waron rasira osiku. Upuku mo, Ano manisate onate. ");
INSERT INTO nxl_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Napisi tau napisi anom runa sio wason oamuiraya. ");
INSERT INTO nxl_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Auna atata mainaya tau hanam nene kawasa mainae. Auna sio wason ohati ruao pani anoo owena-wenaso runa no kaheuta rai. ");
INSERT INTO nxl_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Auna sio aiau ouna mainae tewa nea. Ne auna sio wason sio mainaya tewa, ouna mainae. ");
INSERT INTO nxl_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Sio wason omakaneaso, auna tiao pokona tau muai iake. Ne sio kupan kaya mo, aneiso runa hanao huia. ");
INSERT INTO nxl_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Upuku akahai me manorina, ami Israel. Anom repeka runa sae wani atotoe osima rei. Anom runama. ");
INSERT INTO nxl_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Anom repeka runa sae wani atotoe osi Abraham runa nea upu pusima rotu-tu ria supan sani naone Upuku asau osi mania upu rei.” ");
INSERT INTO nxl_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria iruei ikata Elisabet kani ne hunana tonu san rei, oyo inuniki poe ne numa honu. ");
INSERT INTO nxl_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet ne hunana mtuaya nea. Ia ikine haineke nanie iamrai nea. Oyo ia ikine iamrai, ia iki hanaie. ");
INSERT INTO nxl_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Sio sui ne numa nusue runa ne ipane taue oatinu sapani na Upuri anoi runa Elisabet. Reiso anoo mirika sani Elisabet ruai oi. ");
INSERT INTO nxl_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ia ikine rei iamrai ne onona itu nea, oyo oamanouso, na nanie orehi ia ikine rei. Nanie ohete nanai tau Sakaria pusu amai nanai. ");
INSERT INTO nxl_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ne inai iahata, “Pene! Kahurae ihete nanai tau Yohanis.” ");
INSERT INTO nxl_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ne oahata, “Ia isa arihoni me ipane wain nanai san rei tewa rei!” ");
INSERT INTO nxl_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Oyo oatieu osi amai. Oasei tanui. Oahata, “Nanie ahete nanai tau seia?” ");
INSERT INTO nxl_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Amai iatieu iainisi ai inate isa. Oruiki osiki oyo ikanu, “Nanai Yohanis.” ");
INSERT INTO nxl_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mata hun tewa oyo, iahana mein manne oyo sira tau ianamana honu. Iakumoui tewa nea. Oyo iainaa runa Anahatana. ");
INSERT INTO nxl_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Sio pusiso wason orueso sui numa nusue rei osira hunu ruao. Osima runa rei sui pupua Yudea pusiki. ");
INSERT INTO nxl_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Sio pusiso oatinu sio wason osima rei oasei pan anoo, “Mka ia ikine rei iuna sae?” Tau Upuri iakahaiki ikata runai. ");
INSERT INTO nxl_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yohanis amai, Sakaria, isupu kawasa arihoni Anahatana Ne Inaha na isupu sou reini. Iahata, ");
INSERT INTO nxl_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Upuku Anahatana. Upuku iake tunne nai osa reiso uainaa runaya. Upu mo, Anahatana wani ami Israel ainaa runaya. Tau sae? Upu akahaima. Akahai me mansiau nea. Ausi mani rosau nea. ");
INSERT INTO nxl_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ahiti Ia Waini Iapuheuma na pene Upu apasanama. Ia mo, ia iamkona. Ia mo, ia aia Daud, me manorine rei, upui. ");
INSERT INTO nxl_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Naone atotoe osi me mamsima runa me maunauna wason sio manisata onate. ");
INSERT INTO nxl_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Atotoe na iapuheuma arihoni mani nisau. Ananama arihoni sio wason openeso tanuma. ");
INSERT INTO nxl_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Atotoe na anom runa mania upu na Upuku wan manisate onate, mka auna sui sae wani atotoe rei. ");
INSERT INTO nxl_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Atotoe osi mania upu Abraham. ");
INSERT INTO nxl_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Mka apuheuma arihoni mani nisau na anori runaya, akaitau tewa. ");
INSERT INTO nxl_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ami anori runaya mo, ami manisata onate. Anoma manisata rotu-tu amatama.” Iainaa runa Anahatana suka, samatoro iasau osi anai hanaie rei pan muie mka sapan. ");
INSERT INTO nxl_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Anaku, mka sio oaoia tau ano mamsima runa Anahatana wain Ia Mainae nai osa ne maunauna. Ano mka anaone arihoni Upuri na aunauso na oatinu tanui iake, sani aseka tau arena osiki na ieu sui arena reimo, iake. ");
INSERT INTO nxl_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ano aunauso na ne mansiau oanei sapani na iapuheuso na pene Anahatana iapasanaso. Iapuheuso pusu Anahatana isiru heu no rosau. ");
INSERT INTO nxl_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Upuri Anahatana iapuheuta tau anoi runata. Mka ia wain iapuheuta ihokai sani ranie eresaa. ");
INSERT INTO nxl_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ihokai na iaunauso na oanei sapani na iapuheuso sani iuna ranie eresita osi sio wason orueso noi pumono na oanei arena. Ihokai na iaunau sio wason okaitau omataso. Sani ia isa iatuhete arena osita, mka iatuheteta ioi neta tau Anahatana.” ");
INSERT INTO nxl_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Reiso Sakaria anai iruhu rotu-tu ia mainae nea. Ne inaha makae nea. Iruei pan otoe huie rotu-tu iatuhete ruai osi sio Israel. ");
INSERT INTO nxl_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tau napisi rei, Ia Aia Mainae Roma wain nanai Agustus iaisosi mansia pusiki sui tuniai reini pusiki na oaunutu nanao na oreken tanso. ");
INSERT INTO nxl_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Oaunutu nanao mataanoe mo, tau Kirenius iuna gubernur pan otoe Siria. ");
INSERT INTO nxl_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mansia pusiki oeu sui ruao no niana-niana na oaunutu nanao. ");
INSERT INTO nxl_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Reiso, Yusup iae ieu iarihoni kota Nasaret na pan otoe Galilea na nanie ieui poe kota Betlehem pan otoe Yudea. Betlehem mo, ia aia Daud ne niane. Yusup mo, arihoni Daud ne ipane reiso ieui pan Betlehem oi. ");
INSERT INTO nxl_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yusup ieu iaunutu nanai ikata ne haene oi. Ne haene mo, Maria. Maria mo, waimo tinain taua nea. ");
INSERT INTO nxl_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Hoka pan, oyo Maria sio ina-inaso. ");
INSERT INTO nxl_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Taa ia ikine rei iamrai poe, oo ia iki hanaie. Anai manaonete. Ia ikine iheta nusa oyo, iasinehai tau nipa hiraya samatoro ihukei poe makapana nene muaia naniae tau osupu naniao noi numa seha-sehau tewa nea. ");
INSERT INTO nxl_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tau mono rei, sio mamsaka rompau umau wason osaka no rompau pan monota hutua haineke kota Betlehem. ");
INSERT INTO nxl_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Sira tau Upuri ne ia maisosie isa on roe noiyaha iatuhete ruai osiso. Osira tau ia maisosie rei ne rinane. Ne rinane rei eresita pusiso, reiso pusiso okaitau hunu ruao. ");
INSERT INTO nxl_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Oyo ia maisosie rei iahata, “Pene okaitau! Uhokaku reini mo, usima na Sou Iake rerihoni Anahatana osimo. Mka mansia pusiki mai tuniai reini anoo mirika hun ruao tau Sou Iake reini. ");
INSERT INTO nxl_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Sinasi ia ikine isa iamrai poe aia Daud ne kota. Ia ikine rei sahoro mka iapuheumo na pene Anahatana iapasanamo. Iamrai noso omi. Ia reimo Upuri wain Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau. ");
INSERT INTO nxl_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Areini mo, kakinate na oanei ata osupu ia ikine rei wain mato iamrai. Inai iasinehai tau nipa hiraya nea. Mka osupui waipo inekei poe makapanau nene muaia naniae.” ");
INSERT INTO nxl_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Osira tau Anahatana ne maisosia on roe noiyaha panesi honu okata ia maisosie wain sinasi rei. Pusiso oainaa runa Anahatana oahata, ");
INSERT INTO nxl_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Mania Upu Anahatana. Ano wan roe noiyaha, roe naue mo, Ano mainae nai osa. Ano mo, ano iake tunne nai osa. Sio pusiso wason anom iake runaso mai tuniai reini oi neta tanua nea.” ");
INSERT INTO nxl_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Taa pusi oyo, sio maisosia rei onunso na roe noiyaha. Oyo sio mamsaka rompau rei oasau mai umau. Oahata, “Mai, na ieuta poe Betlehem na inoo sae wani Upuri isima runai osita rei.” ");
INSERT INTO nxl_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Oyo ohitio oeuso rei sirinia. Hoka poe, osupu Maria, Yusup, runa ia ikine rei waipo inekei poe makapanau nene muaia naniae. ");
INSERT INTO nxl_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Sio mamsakaya rei onoo ia ikine rei, oyo oruni runa sae wani Anahatana ne maisosie on roe noiyaha isima runai osiso rei. Osima osi Maria runa Yusup rerihoni ia ikine rei. Na oruni osi sio umau oi. ");
INSERT INTO nxl_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Reiso sio wason oatinu sio mamsakaya oruni rei, osira. ");
INSERT INTO nxl_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ne Maria mo, anoi repeka runa pusire sui osa. Ipikire tanure sui osa. ");
INSERT INTO nxl_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sio mamsakaya rei onunso pan naniao wani osaka-saka no rompau rai oai-ainaa runa Anahatana. Oahata, “Mania Upu Anahatana. Ami ainaa runaya tau Ano mo, Ano iake tunne nai osa. Ano aisosi me maisosie rei isima runa ia ikine rei osima. Ami aeuma poe tanui nea. Asupui pannuhu runa me maisosie rei iasau rei.” ");
INSERT INTO nxl_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yesus ne onona itu nea, oyo orehiki. Ohete nanai tau Yesus repusu Anahatana ne maisosie on roe noiyaha iaisosi inai on tinain taua tewasi rei. ");
INSERT INTO nxl_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Yesus iamrai nene onona hutu ate nea oyo nanie pusu reiso inai na amai ororiki roe kota Yerusalem na nanie oruiki osi Upuri. Tea mo, Musa ne maunaune isa wan san rei, “Sio iki hanai manaoneta pusiso mo, kahurae oruiso osi Upuri.” ");
INSERT INTO nxl_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Reiso oeuso roe Yerusalem nanie orehi manua osi Anahatana oi. Nanie opusu Upuri ne maunaune isa honu wani Musa ikanui na orui “manu totuna hata ua te manu puane waron honua hata ua” osi imam na irehire osiki. ");
INSERT INTO nxl_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tau rei ia isa wain nanai Simeon wairo Yerusalem oi. Ia mo, anoi manisate. Ipusu Anahatana ia-ia. Wain inapa-napa Anahatana iapuheu sio Israel pusu Ia Aia wain Anahatana Iratiki na Iapuheu Mansiau. Anahatana Ne Inaha ikata runai. ");
INSERT INTO nxl_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Anahatana Ne Inaha rei iatuhete nea ata mka imatai tewasi. Ia mka inoo Ia Aia wain Upuri Ihitiki na Iapuheu Mansiau rei. Mka inooi samatoro imatai. ");
INSERT INTO nxl_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Anahatana Ne Inaha iunai inusui roe Anahatana ne numa mainisie nusue. Tau rei Yesus inai runa amai orori Yesus roe Anahatana ne numa mainisie rei. Yesus mo, ia ikine asi. Ororiki nanie opusu Musa ne maunauna. ");
INSERT INTO nxl_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Reiso Simeon ihetei, oyo iainisi iainaa runa Anahatana san rei, ");
INSERT INTO nxl_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Upuku Anahatana. Arime tuniai reini pusiki. Upuku, Ano mo, Ano iake tunne nai osa reiso uainaa runaya. Auna sani atotoe osiki nea, reiso atapi me manorine au, na umataku anoku kaie. ");
INSERT INTO nxl_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tea mo, ruaku unoo tau mataku nea, Ia Wain mka Iapuheuso na pene Upu apasanaso wain aratiki nea. ");
INSERT INTO nxl_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ia Wain mka Iapuheuso reini wain aratiki osi sio niana pusiso. ");
INSERT INTO nxl_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mka iuna sio wason sio Yahudiu tewa oi oanei ata mka iapuheuso na pene apasanaso na pusu Ia oamahaiso rotu-tu ria supan sani kamane eresita na ianei arena. Mka iunaso oamuira me mansiau, ami Israel.” ");
INSERT INTO nxl_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Inai runa amai osira oatinu sae wani Simeon iasau rerihoni ia ikine rei. ");
INSERT INTO nxl_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Oyo Simeon iainisi na Anahatana irui iake osiso. Iainisi suka oyo iasau osi Maria, ia ikine rei inai. Iahata, “Anahatana iroma ia ikine reini na mka sio panesi mai Israel onesiki. Onesiki reiso mka Anahatana iapasanaso. Ne sio umau honu, mka iapuheuso na pene iapasanaso. ");
INSERT INTO nxl_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mka ia ikine reini iatuhete sapan na anoo ranoa. Mka ano ruam anom ererau. Mka ahana sani sio ohutu anom tau tunue.” ");
INSERT INTO nxl_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ia pina mamsima runa Anahatana ne maunauna isa wain nanai Hana. Ikore-korei iamtuai nea. Amai tau Panuel. Ne ipane Asyer. Iausahai musum itu nea, oyo sahai imatai. ");
INSERT INTO nxl_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ia pina rei iauhanui nea. Ne musum hutu wanu rahana ate nea. Ieu iarihoni Anahatana ne numa mainisie nusue tewa. Iainisi iainaa na Anahatana onone ranie roe Anahatana ne numa mainisie rei. Iainisi iainaa runa Anahatana mo, iamaon na iainisi. ");
INSERT INTO nxl_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ihokai roe Anahatana ne numa mainisie rei pannuhu Maria runa Yusup wason orui no ia ikine. Iainaa runa Anahatana san rei, “Upuku Anahatana. Arui iake osiku runa pusima utuma mai rei. Ia ikine wain aratiki na iapuheuso iamrai nea. Au ruaku unooi nea. Upuku mo, Ano iake tunne nai osa.” Oyo ianamana rerihoni ia ikine rei osi sio pusiso wason onapa-napa na Anahatana iapuheu sio Yahudiu arihoni no nisau rei. ");
INSERT INTO nxl_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Maria runa Yusup ouna pusire rapusu Upuri ne maunauna waron Musa ikanure nea rei. Oyo onunso poe no nia Nasaret poe otoe Galilea. ");
INSERT INTO nxl_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ia ikine rei iruhu rotu-tu ia mainae nea. Iamkona nea. Ianei sae waron iaka runa sae waron iaka tewa nea. Anahatana irui iake mainae osiki. ");
INSERT INTO nxl_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Musum rekati musum Yesus inai runa amai oeuso roe kota Yerusalem tau sio Yahudiu no karisaa anoo rapeka na Anahatana ihoka noa upu momou arihon otoe Mesir. ");
INSERT INTO nxl_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesus ne musum hutusa rahana ua nea, ne numa taue rei pusiso oeuso roe karisaa rei sui osa sirinia. ");
INSERT INTO nxl_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Karisaa pusiki nea, oyo onunso okata sio hutue. Ne Yesus ruai wairo Yerusalem asi. Inai runa amai oaneiki tewa. ");
INSERT INTO nxl_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Oata kani wain ikata sio hutue rei oi. Reiso oeu rotu-tu pumono nea samatoro onoo san rei mo, Yesus wain ikataso tewa. Uaso oeu oasei neka pusi no mansiau, oeu onina-ninai sui sio hutue rei, sui ruao no ipane taue runa sio pusiso wason oationaso oi. ");
INSERT INTO nxl_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ne osupui tewa sirinia. Reiso onunso roe Yerusalem honu na oninai. ");
INSERT INTO nxl_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Onona ua san rei samatoro osupui roe Anahatana ne numa mainisie nusue. Osupui mo, wairo irue ikata sio matuhetena. Irue iatinuso. Irue iasei-asei tau sio matuhetena rei. ");
INSERT INTO nxl_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Sio pusiso wason oatinui rei osira runa sapani na ianei san rei. Osira runa sapani na isana tau sio matuhetena rei. ");
INSERT INTO nxl_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Inai runa amai iae onooi, oyo osira oi. Inai iasei, iahata, “Anaku. Aunama san rei, nan tahae? Inam, Au reini runa amam uama aninaya anoma rauponu runaya!” ");
INSERT INTO nxl_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesus iahata, “Nanie oninaku tahae? Oaneiku tewa? Au mo, kahurae Au wan mai Amaku ne numa!” ");
INSERT INTO nxl_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ne oanei tewa mka oasau sapan. Oanei sae wan iasau rei tewa. ");
INSERT INTO nxl_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Oyo Yesus inuniki poe nia Nasaret ikata inai runa amai. Iatinu tanso. Maria anoi repeka-peka runa pusire pan anoi asi. ");
INSERT INTO nxl_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesus mo, ianei sae waron iaka runa sae waron iaka tewa. Iruhu rotu-tu ia mainae nea. Anahatana runa mansiau anoo runai mainae renesi honu. ");
INSERT INTO nxl_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberius iuna Ia Aia Mainae Roma. Irime sio Romau musum hutusa rahana nima nea. Pontius Pilatus iuna gubernur pan otoe Yudea. Herodes iuna gubernur pan otoe Galilea. Herodes wanin wain nanai Pilipus iuna gubernur pan otoe Iturea runa Trakonitis. Lisanias iuna gubernur pan otoe Abilene. ");
INSERT INTO nxl_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hanas runa Kayapas sahoro sio imam no sio mainaya. Tau rei Anahatana ianamana osi Yohanis. Yohanis iruei pan otoe huie. Yohanis mo, Sakaria anai. Anahatana ianamana osi Yohanis pan otoe huie. ");
INSERT INTO nxl_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Oyo Yohanis ieu ineka pusi otoe wan haineke Wae Yordan na iaunauso. Iaunauso san rei, “Oarihoni mo rosau na Anahatana isiru heu mo rosau rai. Oarihonre, oyo usohumo na mansiau oanei ata oarihoni mo rosau nea.” ");
INSERT INTO nxl_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Naone Yesaya, ia mamsima runa Anahatana ne maunauna, ikanu rerihoni Yohanis. Ikanu ata Anahatana iasau san rei, “Ia isa iakapona ria otoe huie san rei, ‘Sani sio oseka tau arena osi ia mainae, oseka tau anomo na oatinu tau Upuri sani ouna arena katopue mka ieui pusui.’ ");
INSERT INTO nxl_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Sou ekota hanaya pusire. Rati pupua runa tinetaya na watane. Arenau waron katopua tewa, mka ounare katopua. Arenau waron nene nonu panesi mo, mka osoure na rauna watana. ");
INSERT INTO nxl_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na mansia pusiki mka onoo Ia wain Anahatana iaisosiki mai tuniai reini na iapuheu ne mansiau na pene Anahatana iapasanaso.” ");
INSERT INTO nxl_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yohanis iasau osi sio panesi wason ohokaso noi tanui na isohuso rei. Iahata, “Ee. Omi kahatena. Omi mo, noomo sani teke minna. Mka Anahatana iapasana sio wason opalalosa. Pene ata kani mka orumamo na osihamo. Mka Anahatana iapasanamo sirinia. ");
INSERT INTO nxl_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kahurae ouna sae waron manisata na sio onoo ata oarihoni mo rosau pusu mo atata. Areimo sani onoo ata ai remahaiki pusu nene huaya. Pene oasau pan anomo oahata, ‘Ami mo, Abraham nea upu momou reiso mka Anahatana iapasanama tewa.’ Masi oatinu, Anahatana ne kawasa iuna Abraham nea upu momou arihoni hatu raini. ");
INSERT INTO nxl_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Anahatana nanie iapasana sio wason oarihoni no rosau tewa. Noo sani ia isa wain irime tumane haineke ai namta na iranai. Iranai rotu-tu poe nene namta. Ia mo, noo sani Anahatana wain mka iapasana mansiau wason oarihoni no rosau tewa sani sio orana aiu waron rauhua iaka tewa. Oranare, oyo opesire pan usa na oakanupure.” ");
INSERT INTO nxl_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Oyo sio panesi rei oasei, oahata, “Kahurae auna sae na sio onoo ata ami arihoni ma rosau nea?” ");
INSERT INTO nxl_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohanis iahata, “Ia seia wain ne papita ua mo, kahurae irui isa osi ia wain ne papite tewa. Ia seia ne muaina mo, kahurae isama osi ia wain ne muaine tewa.” ");
INSERT INTO nxl_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Sio mainisi peau umau iae oeuso noi Yohanis oi, na isohuso na mansiau oanei ata oarihoni no rosau nea. Oyo oasei oahata, “Ano ona matuhetene, reiso kahurae auna sae?” ");
INSERT INTO nxl_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Iahata, “Pene onana peau arihoni sio mansiau ranesi sae waron sio kupaniau oasau ata kahurae onanare rei.” ");
INSERT INTO nxl_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sio hana naua umau oasei, oahata, “Sapan runa ami? Nanie auna sae?” Yohanis iahata, “Pene otentene na sio orui kepen osimo. Pene oakarota oapusaa parakana na osupu kepen. Kahurae anomo kaia runa mo katiu man.” ");
INSERT INTO nxl_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Naone Anahatana itotoe ata mka irati Ia Aia wain Ihitiki na Iapuheu Mansiau. Reiso sio panesi wason onapa-napai. Reiso pusiso oasei pan anoo. Oahata, “Pene tu-tu Yohanis mo, Ia wain Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau mo, ia rein nea te sarei!” ");
INSERT INTO nxl_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Reiso Yohanis iahata, “Usohumo tau tihu na mansiau oanei ata oarihoni mo rosau nea. Ne ia wain ne kawasa renesi au wain nanie ihokai nea. Au mo, au mainae tewa. Reiso ukanahata na unosu ne sandaliu arihoni ain atua man iae, iake tewa oi. Ia mka irui Anahatana ne Inaha osimo. Ne, mka iapasana sio wason oarihoni no rosau tewa pan usa mainae. ");
INSERT INTO nxl_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nanie ianena sio manisata arihoni sio kahatena nea. Atieu rei sani irime nuite na irei ana. Irei kitataia arihoni ana rei. Ana rei, mka iaunutui pakarema naniae. Ne, nene kitataia rai, iakanupure. Sio manisata mka okata Anahatana roe naniai. Ne sio kahatena mka oeu poe usa mainae wani remata tewa rotu-tu ria supan.” ");
INSERT INTO nxl_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohanis iaunauso tau maunauna panesi oi na isima runa Sou Iake rerihoni Anahatana osiso. ");
INSERT INTO nxl_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ne Yohanis iasau osi Herodes ia gubernur tau otoe Galilea. Iahata, “Ee, ano apalalosa. Tau sae? Ano anana Herodias, wanim sahai. Ne me isanae rei man tewa. Ano me isanaya panesi.” ");
INSERT INTO nxl_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ne Herodes iarihoni iuna isanae tewa. Iuna isanae isa honu. Isanae rei mo, inusu Yohanis poe pui anoe. ");
INSERT INTO nxl_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","On sio onusu Yohanis poe pui tewasi mo, Yohanis isohu sio panesi na mansiau oanei ata oarihoni no rosau nea. Yohanis iae isohu Yesus oi. Oyo Yesus iainisi, sira tau nante erehuka. ");
INSERT INTO nxl_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Oyo, Anahatana Ne Inaha isipui. Anahatana ne Inaha rei mo, nooi sani manu pua putie. Isipui oyo iatasohoi roe Yesus. Iatasohoi oyo, oatinu nioke isa on roe noiyaha. Iahata, “Ano mo, Au Anaku. Anoku runaya. Anoku iake tau ano.” ");
INSERT INTO nxl_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesus ne musum kani hutu tonu san rei, oyo ieu ianori runa Anahatana. Pusu mansiau Yesus mo, Yusup anai. Yusup mo, amai tau Eli. ");
INSERT INTO nxl_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli amai tau Matat. Matat amai tau Lewi. Lewi amai tau Malki. Malki amai tau Yanai. Yanai amai tau Yusup. ");
INSERT INTO nxl_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusup amai tau Matias. Matias amai tau Amos. Amos amai tau Nahum. Nahum amai tau Hesli. Hesli amai tau Nagai. ");
INSERT INTO nxl_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai amai tau Maat. Maat amai tau Matias. Matias amai tau Semein. Semein amai tau Yosek. Yosek amai tau Yoda. ");
INSERT INTO nxl_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda amai tau Yohanan. Yohanan amai tau Resa. Resa amai tau Serubabel. Serubabel amai tau Sealtiel. Sealtiel amai tau Neri. ");
INSERT INTO nxl_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri amai tau Malki. Malki amai tau Adi. Adi amai tau Kosam. Kosam amai tau Elmadam. Elmadam amai tau Er. ");
INSERT INTO nxl_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er amai tau Yosua. Yosua amai tau Elieser. Elieser amai tau Yorim. Yorim amai tau Matat. Matat amai tau Lewi. ");
INSERT INTO nxl_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi amai tau Simeon. Simeon amai tau Yehuda. Yehuda amai tau Yusup. Yusup amai tau Yonam. Yonam amai tau Elyakim. ");
INSERT INTO nxl_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim amai tau Melea. Melea amai tau Mena. Mena amai tau Matata. Matata amai tau Natan. Natan amai tau Daud ");
INSERT INTO nxl_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daud amai tau Isai. Isai amai tau Obet. Obet amai tau Boas. Boas amai tau Salmon. Salmon amai tau Nahason. ");
INSERT INTO nxl_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason amai tau Aminadap. Aminadap amai tau Admin. Admin amai tau Arni. Arni amai tau Hesron. Hesron amai tau Peres. Peres amai tau Yehuda. ");
INSERT INTO nxl_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yehuda amai tau Yakup. Yakup amai tau Isak. Isak amai tau Abraham. Abraham amai tau Tera. Tera amai tau Nahor. ");
INSERT INTO nxl_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor amai tau Seruk. Seruk amai tau Rehu. Rehu amai tau Pelek. Pelek amai tau Eber. Eber amai tau Salmon. ");
INSERT INTO nxl_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salmon amai tau Kenan. Kenan amai tau Arpaksat. Arpaksat amai tau Sem. Sem amai tau Nuh. Nuh amai tau Lamek. ");
INSERT INTO nxl_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek amai tau Metusala. Metusala amai tau Henok. Henok amai tau Yared. Yared amai tau Mahalalel. Mahalalel amai tau Kenan. ");
INSERT INTO nxl_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan amai tau Enos. Enos amai tau Set. Set amai tau Adam. Adam mo, Anahatana ioiki tau anai. ");
INSERT INTO nxl_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesus ieu arihoni Wae Yordan, Anahatana ne Inaha iruei anoi. Oyo ne Inaha iaisosiki ieui pan otoe huie. ");
INSERT INTO nxl_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Iruei pan rei onona hutu ate. Pani rei, ia aia sakahatene rei ireai na ipalalosa. Tau rei, Yesus iamaon. Reiso, onona hutu ate rai ranikuso oyo, iahana imakaneai nai osa. ");
INSERT INTO nxl_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Reiso ia aia sakahatene iasau osiki. Iahata, “Ano mo, Anahatana Anai tea! Reiso aisosi hatu reini na reuna muaine.” ");
INSERT INTO nxl_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesus iahata, “Tau Anahatana ne anamanaya mo, sio okanu oahata, ‘Ita mansiau mo, iamahaita arihoni muaine man tewa.’” ");
INSERT INTO nxl_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pusi oyo, ia aia sakahatene irori Yesus roe tinetae isa, oyo sira tau ia aia sakahatene rei, iatuhete nia onata pusire mai tuniai reini osiki inoore rapu-rapu. ");
INSERT INTO nxl_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Iasau osi Yesus ata, “Anahatana irui kawasa osiku nea tau nia marainia rai. Mka urui kawasa osia na arime pusi nia onata rai. Mka au una mansia panesi oationaya. Reiso utapi ia sia mani irimere pusu ruaku we maue mo, iake. ");
INSERT INTO nxl_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Reiso sani ano ainisi ainaa runaku, mka urui pusire osia.” ");
INSERT INTO nxl_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesus iahata, “Tau Anahatana ne anamanaya sio okanu oahata, ‘Ainisi ainaa runa Upum Anahatana mani. Anori runa Ia mani.’” ");
INSERT INTO nxl_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Oyo ia aia sakahatene irori Yesus roe kota Yerusalem. Iroriki roe Anahatana ne numa mainisie nene huhue. Oyo iasau ata, “Ano mo, Anahatana Anai tea! Reiso apesi ruam supoe. ");
INSERT INTO nxl_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tau Anahatana ne anamanaya sio okanu oahata, ‘Anahatana mka iaisosi ne maisosia on roe noiyaha na osakaya ia-ia. ");
INSERT INTO nxl_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Mka osilaya. Reiso aim atua rakahuu hatu tewa oi.’” ");
INSERT INTO nxl_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Oyo Yesus iasau honu, iahata, “Tau Anahatana ne anamanaya sio okanu oahata, ‘Pene rea Upum Anahatana.’” ");
INSERT INTO nxl_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ia aia sakahatene irea Yesus tau nitaya panesi oyo ieu iarihoniki. Nanie inoo-noo rotu-tu inuni ireai honu. ");
INSERT INTO nxl_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ia aia sakahatene irea Yesus na ipalalosa. Pusi, oyo Yesus inuniki poe otoe Galilea honu. Anahatana ne Inaha irui kawasa osiki. Oyo sio oeu oruni rerihoni Yesus neka pusi otoe rei. ");
INSERT INTO nxl_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Iatuhete mansiau sui sio Yahudiu no numa mananouna. Sio pusiso oainaa runai. ");
INSERT INTO nxl_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesus inuniki poe kota Nasaret honu. Naone irue poe rei on Ia ikine asi. Yesus inusui pan ita Yahudiu re numa mananoune pannuhu ranie hatae wan ita Yahudiu iamuira Anahatana. Ia mo, isaka iuna san rei sui osa nea. Iooi nanie ihatae tau Anahatana ne anamanaya. ");
INSERT INTO nxl_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Orui Anahatana ne anamanaya waron Yesaya ikanure tau ne surate. Yesaya mo, ia mamsima runa Anahatana ne maunauna. Oyo ihukai, isupu anamanaya waroni atinure san rei, ");
INSERT INTO nxl_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Upuri ne Inaha wain anoku. Areimo, tau ihiti Au nea na usima na Sou Iake rerihoni Anahatana osi sio mosokinia. Ia iae iaisosiku oi ");
INSERT INTO nxl_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","na usima ata Anahatana mka iuna sio wason ia aia sakahatene isotaso osihaso. Mka irui kawasa osiku na Au una sio wason matao raputiso onoo honu. Mka irui kawasa osiku na sio wason sio umau ounaso kahi-kahiso, kahi-kahiso tewa nea. Usima ata nene orase nea tau Upuri irui iake osi mansiau.” ");
INSERT INTO nxl_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pusi, oyo Yesus isou Anahatana ne anamanaya oyo iruiki osi ia wain iruiki osiki rei. Oyo iruei. Sio wason noi numa mananoune rei pusiso oasumata Yesus ia-ia. ");
INSERT INTO nxl_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Oyo Yesus iasau osi sio wason noi rei. Iahata, “Rahata repan, Anahatana ne anamanaya waroni mato oatinu pusire rei mo, rayari nea.” ");
INSERT INTO nxl_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Sio pusiso wason oatinu oasau ata, “Ira! Iatuhete iake maa! Ne anamanaya waroni iasaure reimo, pusire iaka.” Oasei, “Ia reini mo, Yusup anai si?” ");
INSERT INTO nxl_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesus iasau osiso. Iahata, “Au nanie uasau. Mka omi oasau na matieue reini osiku ata, ‘He ano mamsuisene! Aeua suisene ruam na iake ee. Una sae mani waron ami atinu ata aunare pani kota Kapernaum rei mai me niane oi.’” ");
INSERT INTO nxl_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Iasau honu, “Atinu mai ia-ia nanie uasau osimo. Ia mamsima runa Anahatana ne maunauna mo, ruai ne niane oatarimai tewa. ");
INSERT INTO nxl_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Masi pusimo oatinu ia-ia. Tau Elia, ia mamsima runa Anahatana ne maunauna, iamahaiki asi mo, sio pina wason auhanuso panesi nai osa mai Israel. Tau naene rei mo, uane mkane sini man tewa oi rotu-tu musum tonu, hunana nome mai otoe reini. Reiso omata muaine nai osa. ");
INSERT INTO nxl_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Masike san rei iae, Anahatana iaisosi Elia ieui noi sio pina uhanu mai otoe Israel mo, tewa. Ne iaisosiki ieui noi ia pina uhanu isa pani kota Sarpat pani otoe Sidon. ");
INSERT INTO nxl_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","San rei oi tau Anahatana ne ia mamsima runa ne maunauna waini nanai Elisa iamahaiki asi mo, sio wason okupu unte wani iake tewa nai osa panesi mai Israel. Ne ia isa tewa oi ne kupue rei iake. Hasae ia osa mani. Ia reimo, ia tamene arihoni otoe Siria. Nanai Naaman.” ");
INSERT INTO nxl_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Oatinu Yesus iasau san rei oyo, sio pusiso wasoni noi numa mananoune rei anoo rasaa nai osa. ");
INSERT INTO nxl_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Oyo ohitio otentene tau Yesus. Ororiki roe tatepie. Kota Nasaret mo, rerue roe tatepie rei. Ororiki roe, nanie opesiki na poe ekote. ");
INSERT INTO nxl_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ne sira tau ieui noi pusiso tihue oyo ieui arihoniso. ");
INSERT INTO nxl_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesus ihokai arihoni kota Nasaret, oyo ieui poe kota Kapernaum poe otoe Galilea. Noi kota rei Yesus iatuhete mansiau. Iatuheteso pannuhu ranie hatae wan sio Yahudiu oamuira Anahatana. ");
INSERT INTO nxl_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Sio wason oatinui rei, osira tau ne anamanaya rai. Tea mo iatuhete runa ne kawasa. ");
INSERT INTO nxl_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Yesus iatuheteso pan sio Yahudiu no numa mananoune. Pan rei, ia isa waimo sakahatene remasuniki. Oyo sira tau iakapona mainae iahata, ");
INSERT INTO nxl_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ee! Yesus, ano Nasaret. Nanie amunama? Ahokaya reini mo, nanie ahunuma si? Uaneia nea. Ano mo, Ano manisate onate. Ahokaya on roe Anahatana!” ");
INSERT INTO nxl_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ne Yesus iasau osi sakahatene rei. Iahata, “Amaturua! Ahokaya arihoni ia reno!” Oyo sira tau sakahatene rei repara ia rei poe tuamane noi mansia hutue rei tihuo oyo rehokai. Ne sae isa eremuna ia rei tewa nai osa. ");
INSERT INTO nxl_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Sio wasoni onoo rei, osira. Reiso oasau mai umau, “Ira! Ia reini mo, ne sou anamanaya nene kawasa maa! Tau ne kawasa iaisosi sakahatena rahokaso oyo rahokaso rei sirinia.” ");
INSERT INTO nxl_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Oyo sio pusiso oatinu rerihoni Yesus neka niana-niana noi otoe rei pusiki. ");
INSERT INTO nxl_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesus ihokai arihoni sio Yahudiu no numa mananoune, oyo ieui poe Simon ne numa. Hoka poe, isupu Simon inai hanahanai waipo titie retanunui. Oyo oainisi arihoni Yesus. Oahata, “Ama, mai na asuisenei ee.” ");
INSERT INTO nxl_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Reiso Yesus iooi noi nusui oyo, ianamana tau kupue rei. Oyo kupue rei iake rei sirinia. Sira tau ia pina onate rei ihanui na inana muaine osi pusiso oaiso. ");
INSERT INTO nxl_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Taa ranie eresou san rei, mansiau orori sio kupua wasoni okupu nita-nitaya noi Yesus. Oyo hanai tanso sana osa-osa na isuiseneso. Iuna san rei oyo no kupua iaka rei sirinia. ");
INSERT INTO nxl_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Yesus inei sakahatena arihoni sio panesi rei oi. Sakahatena rai rahokaso rakapona rahata, “Ano mo, Anahatana Anai.” Ne Yesus isoposo iahata, “Amaturumo!” Isopo sakahatena rai na pene oanamana. Areimo tau ranei ata Yesus mo, Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau. ");
INSERT INTO nxl_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Taa hanu omnanoe san rei, Yesus ieui arihoni kota Kapernaum. Oyo ieui noi otoe isa wani meneta nai osa na iainisi tau Anahatana. Ne sio panesi oeu oninai. Taa osupui, oyo osopoi. Oahata, “Pene aeua arihoni ma kota reini nea.” ");
INSERT INTO nxl_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ne iahata, “Anahatana iaisosiku mai tuniai reini mo, na ueu usima na Anahatana sui kotau, nia tamena oi. Usima na Sou Iake rerihoni Anahatana irime ne mansiau.” ");
INSERT INTO nxl_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Reiso ieui isima na Sou Iake rerihoni Anahatana sui sio Yahudiu no numa mananouna sui otoe Yudea. ");
INSERT INTO nxl_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Taue isa Yesus iooi nau Wae Galilea nusue. Sio panesi oo ohoriki nanie oatinu Yesus iaunau rerihoni Anahatana ne anamanaya. ");
INSERT INTO nxl_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesus inoo arupaiu ua nau waene rei nusue. Sio mapaparia wason no arupaiu rai osipuso nea na wason oseka tau no ueta. ");
INSERT INTO nxl_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Reiso isaai roe arupai isa. Lepa-lepa reimo, Simon ne arupai. Oyo iaisosi Simon iruru ne arupai rei hainau mkane arihoni kaimenne. Oyo iruei nau arupai rei na iaunau sio panesi rei. ");
INSERT INTO nxl_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Iaunauso pusi oyo, iasau osi Simon. Iahata, “Asai arupai reini hainau mkane, nau naue reinau, na pesi ueta na ranana ikaya.” ");
INSERT INTO nxl_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Iahata, “Upu. Ami apakarian resunima on monosi rotu-tu omnanoe repa na nanie asupu ikae. Ne asupu sae isa tewa oi! Ne ano aisosima reiso mka upesi ueta raini honu.” ");
INSERT INTO nxl_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Taa opesi no ueta rai, sira tau osupu ikaya panesi rotu-tu ueta rai nanie wakihare nea. ");
INSERT INTO nxl_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Reiso oauwae no netau umau wason tau arupai tamene na oeu mai oakahaiso. No netau rei ohoka oyo, pusiso oakahai umau tau ikaya rai. Oapataure tau arupai uare rotu-tu uare sina ramokoso. ");
INSERT INTO nxl_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Taa Simon, wain sio oiki tau Petrus oi, inoo san rei oyo isira. Irike tune iakapuni ain mai Yesus uai anoe iahata, “Upu. Au reini mo, upalalosa panesi. Reiso aeua arihoniku.” Ne neta mapaparia osira oi. Sio ua arihoni sio reimo, Yakobis runa Yohanis. Sabedeus ne hehuka. Oyo Yesus iasau osi Simon. Iahata, “Pene akaitau. On rahata reini mo, ano mka aeua anina ikae tewa nea. Ne mka aeua anina mansia na opusuku.” ");
INSERT INTO nxl_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Reiso oruru no arupai na ria kaimenne. Oyo oeu arihoni no arupai runa no ueta na no sae mani pusire na opusu Yesus. ");
INSERT INTO nxl_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Taue isa Yesus waipan kota isa. Isupu ia isa wain ikupu unte wan iake tewa nai osa. Ne patane mo, nooi iake tewa nai osa. Taa ia rei inooi, oyo irike tune iakapuni ain. Iahata, “Upu. Sani me maue mo, mai na asuiseneku, areimo ano me kawasa asuisene.” ");
INSERT INTO nxl_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Oyo Yesus iahusiei. Iahata, “Au we maue. Reiso ano iake nea.” Oyo ia rei iake nea. ");
INSERT INTO nxl_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Iasau osiki honu. Iahata, “Anom repeka. Asupu sio umau mo, pene aruni. Ne aeua pan ia imam isa na ainisi na inooa. Arui manua ua osiki na ikenure osi Anahatana sani Musa iaunau rei. Tau rei, sio pusiso mka oanei ata ano iake nea.” ");
INSERT INTO nxl_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ne sio panesi oatinu sirinia. Reiso ohoka oamanouso na oatinu ne maunauna na isuisene no kupua inaya oi. ");
INSERT INTO nxl_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ne, Yesus isaka ieu noi tihu otoa waron meneta na iainisi. ");
INSERT INTO nxl_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Taue isa Yesus wain iatuhete noi numa isa. Sio onata arihon akama Yahudi umau runa sio matuhete Musa ne maunauna umau wason oru-rueso pan numa rei oi. Sio onata rei runa sio matuhetena rei pusiso ohokaso on pan niana pusire pan otoe Galilea, otoe Yudea, na on roe kota Yerusalem. Upuri irui kawasa osi Yesus na isuisene sio kupua. ");
INSERT INTO nxl_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Oyo sira tau sio umau ohoka ohana ia talae isa tau ne kinoe. Onina nanie onususo pan numa anoe rei na oautue ia rei noi Yesus uai anoe na isuisenei. ");
INSERT INTO nxl_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ne okeka kua mansia hutue rei tewa reiso onusu iake tewa. Reiso osaaso pusu oane na roe numa rei nene hahae. Oyo ohuka nene ainataya. Ohukare oyo, oratiki tau ne kinoe mai Yesus uai anoe runa sio panesi rei. ");
INSERT INTO nxl_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Oratiki oyo, Yesus inoo ata sio rei oparisaa ata ia imaha heu kupue rei. Taa san rei oyo, Yesus iasau mai ia talae rei iahata, “Kakaku. Waniku. Me rosau, usiru heure nea.” ");
INSERT INTO nxl_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Sio onata arihon akama Yahudi runa sio matuhete Musa ne maunauna oasau pan anoo. “Ia reini mo, ia seia? Ianamana sani ia mo, Anahatana rei! Na nanie isiru heu rosau. Anahatana ruai sahoro ne kawasa isiru heu rosa!” ");
INSERT INTO nxl_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ne Yesus ianei anoo. Reiso iahata, “Nanie oarinii pan anomo san rei tahae? ");
INSERT INTO nxl_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Sani uasau, ‘Me rosau, usiru heure nea.’ Ne sapani na oanei ata kani usiru heure te tewa? Ne sani uasau, ‘Hanu! Ahitio na eu.’ Omi mka oanei ata au we kawasa usuisene! ");
INSERT INTO nxl_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ne sani usuisene ia reini, mka oanei ata Au Tumata Reini mo, Anahatana Ihitiku, we kawasa mai tuniai reini na usiru heu rosau.” Oyo Yesus iasau osi ia wain italae rei, iahata, “Hitio na siu me kinoe reino na anunia.” ");
INSERT INTO nxl_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Sira tau ia talae rei ihitioi noi mansia hutue rei uao anoa, oyo isiu ne kinoe na inuniki iai-ainaa runa Anahatana. ");
INSERT INTO nxl_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mansia hutue rei pusiso osira hunu ruao. Osira reiso oainaa runa Anahatana. Oahata, “Ira oe! Rahata reini matoro ami anoo sima-simane wan mainae nai osa reini!” ");
INSERT INTO nxl_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yesus isuisene ia italae oyo ihokai nanie ieui. Inoo ia mainisi peau isa. Ia mainisi peau rei mo, nanai Lewi. Waipo iruei poe ne numa mainisi pea. Yesus iasau osiki, “Mai, na apusu Au!” ");
INSERT INTO nxl_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi iatinu san rei oyo, ihitioi iarihoni ne pakarian rei runa ne sae man na ipusu Yesus rei sirinia. ");
INSERT INTO nxl_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Taa san rei oyo, Lewi inana muaina na iuna nasae osi Yesus poe ne numa. Sio mainisi peau panesi runa sio umau oi orue oaiso okataso oi. ");
INSERT INTO nxl_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ne sio onata arihon akama Yahudi runa sio matuhete Musa ne maunauna oakapuku tau ne mampusua. Oahata, “Nanie oaimo okata sio mainisi peau runa sio umau wason opalalosa oi tahae?” ");
INSERT INTO nxl_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesus iatinu san rei oyo iahata, “Sani ia isa ikupui tewa, inina ia mamsuisene tewa. Ne ia wain ikupui sahoro ininai. Au mo, nooku sani ia mamsuisene rei oi. ");
INSERT INTO nxl_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Uhokaku mai tuniai reini mo, nanie uoi sio wason opalalosa na oarihoni no rosau. Ne sio wason oata ruao oamanisa mo, uhoka na uoiso tewa.” ");
INSERT INTO nxl_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sio onata arihoni akama Yahudi runa sio matuhete Musa ne maunauna oasau osi Yesus. Oahata, “Yohanis ia mamsohue ne mampusua oamaon na oainisi sui osa. Ami onata arihoni akama Yahudi ma mampusua iae ouna san rei oi. Oo, ano me mampusua mo, oai oninu sirinia tahae rei?” ");
INSERT INTO nxl_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesus nanie iatuheteso ata oni ikata ne mampusua asi, ne mampusua oamaon, anoo rapunokoso iake tewa. Reiso iahata, “Rerihoni omi mo, sapan? Tau sio mausahaya oaiseneso, sio wason opusu karisaa rei oamaon te tewa? ");
INSERT INTO nxl_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ne mka sio umau osota ia hehuke rei, samatoro sio wason noi karisaa rei oamaon iake.” ");
INSERT INTO nxl_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iruni runa matieue reini osiso na pene sio wasoni opusu Anahatana ne maunau honua mo, pene otentene na opusu maunau monaya sani iamaon. Iahata, “Ia sia man iaturui papite wan monae tau nipa sinte wani honue tewa. Sani iuna san rei mo, mka papite wani honue wakihai, na nipa sinte wani honue mka pannuhu runa papite wani monae rei tewa. ");
INSERT INTO nxl_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Areimo nooi sani iaiinu tihu anggur wan honue tau tasi wani sio ounai arihoni une-une unte wan monae nea tewa. Tea mo, mka tihu anggur rei reuna tasi wan monae rei wakihai. Oyo tihu anggur rei ereohui sai-saiki na tasi iake tewa nea. ");
INSERT INTO nxl_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ne tihu anggur wan honue mo, kahurae aiinui tau tasi wani honue oi, na uare iaka sirinia. ");
INSERT INTO nxl_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Sani ininu anggur monae nea, ipenei ininu tihu anggur wan honue nea. Tea mo, mka iahata, ‘Anggur wani monae mo, iake tunne nai osa.’” ");
INSERT INTO nxl_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Taue isa, tau ranie hatae wan sio Yahudiu oamuira Anahatana, Yesus ieu ikata ne mampusua oeu opusu nisi gandum isa. Oyo ne mampusua ohuku gandum huaya. Oyo oasimisore na oai nene isia. ");
INSERT INTO nxl_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Sio onata arihoni akama Yahudi umau onoo san rei, oyo oasei ata, “Omuna na onana tau ranie hatae wan ita Yahudiu iamuira Anahatana reini? Opusu Musa ne maunauna tewa!” ");
INSERT INTO nxl_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Yesus iahata, “Omi onoo tau Anahatana ne anamanaya tewa, sapani na Daud inana poroti wani sio oruiki osi Anahatana. Poroti reimo, pusu Musa ne maunauna hasae sio imam ruao man sahoro oaiki. Aikee Daud inanai. Daud runa sio wason okatai rei omakaneaso. Reiso inusui pan Anahatana ne numa mainisie, oyo iai poroti rei. Isama sio wason okatai rei oi. Ne ia isa iakapuku tanui tewa. ");
INSERT INTO nxl_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Reiso Au Tumata Reini mo, Anahatana Ihitiku we kawasa tau ranie hatae wan ita Yahudiu iamuira Anahatana. We kawasa uasau ouna sae na ouna sae tewa.” ");
INSERT INTO nxl_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tau ranie hatae wan sio Yahudiu oamuira Anahatana isa honu, Yesus inusui pan sio Yahudiu no numa mananoune, oyo iatuhete sio wason noi rei. Ia hanaie isa wain hanai wanane rematai waimo iatinu ikata sio rei oi. ");
INSERT INTO nxl_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Sio onata arihoni akama Yahudi runa sio matuhete Musa ne maunauna wason onina arena na nanie oapasana na oamanuru Yesus. Reiso oaka-akaohui. Pene tu-tu isuisene sio umau tau ranie hatae wan sio Yahudiu oamuira Anahatana rei. ");
INSERT INTO nxl_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ne Yesus ianei anoo. Reiso iasau osi ia wain hanai wanane erematai rei. Iahata, “Ahitioa na aeu mai. Ooa mai uae reini!” Reiso ia rei ihitioi iooi pan uae. ");
INSERT INTO nxl_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Oyo Yesus iasei tau sio onata arihon akama Yahudi runa sio matuhete Musa ne maunauna. Iahata, “Sani pusu Musa ne maunauna mo, iuna sae tau ranie hatae wan ita Yahudiu iamuira Anahatana sahoro iake? Iuna iake te iuna kahatene? Iakahai mansia na iamahaiki te itapiki na imatai?” ");
INSERT INTO nxl_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Iasau san rei pusi, oyo inoo neka-neka sio wason ohoriki rei. Oyo iasau osi ia rei iahata, “Asasona hanam mai!” Ia rei iasasona hanai oyo sira tau hanai wanane wani rematai rei, iake nea. ");
INSERT INTO nxl_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ne sio onata arihon akama Yahudi runa sio matuhete Musa ne maunauna anoo rasaa mainae. Oyo pusiso oasau osi umau, “Mka iuna sae tau Yesus?” ");
INSERT INTO nxl_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Taue isa Yesus inoai na roe pupue na nanie iainisi tau Anahatana tau pumono. Iainisi rotu-tu manahane. ");
INSERT INTO nxl_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Taa ranie eresaa, oyo ioi ne mampusua pusiso. Ohokaso noi tanui, oyo iroma sio hutusa rahana ua arihoni ne mampusua rei. Ioiso tau ne maisosia. Sio rei mo: ");
INSERT INTO nxl_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon wain Yesus ihete nanai tau Petrus oi, Simon wanin Anreas, Yakobis, Yohanis, Pilipus, Bartolomeus, ");
INSERT INTO nxl_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matius, Tomas, Yakobis. Ia mo, amai tau Alpeus. Simon. Ia mo, ipenei tau sio rakana orime ne otoe. ");
INSERT INTO nxl_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas. Ia mo, amai tau Yakobis Yudas arihoni nia Kariot wain mka iahen Yesus. ");
INSERT INTO nxl_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesus imusui on roe pupue ikata ne mampusua hutusa rahana ua wason iromaso rei. Ohoka poe watane oyo oaraoo. Osupu ne mampusua tamena panesi wason ohokaso on roe kota Yerusalem runa otoe Yudea pusiki. Sio umau honu ohokaso on pan kota Tirus runa Sidon waron haineke nuae nusue. ");
INSERT INTO nxl_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ohokaso na nanie oatinui iatuhete runa nanie oainisi na isuiseneso. Sio wason oauwena runa sakahatena ohokaso oi oyo inei sakahatena rai. ");
INSERT INTO nxl_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Sio panesi rei onina na nanie oakahuu Yesus. Tau ia mo, ne kawasa isuisene pusiso. ");
INSERT INTO nxl_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesus inoo ne mampusua oyo iahata, “Anahatana irui iake osi omi wan omosokinimo. Tea mo, Anahatana irime ne mansiau, okatai. ");
INSERT INTO nxl_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Anahatana irui iake osi omi wan omakaneamo muie reini. Tea mo, mka tiamo pokona. Anahatana irui iake osi omi wan orani anoo rapunokomo muie reini. Tea mo, mka oaumani anomo mirika. ");
INSERT INTO nxl_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Anahatana irui iake osi omi wan mansia openeso tanumo runa orati sohimo oahata, ‘Sio mo, sio kahatena.’ Irui Iake osimo noso opusu Au Tumata Reini mo, Anahatana Ihitiku.” ");
INSERT INTO nxl_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sani munata mansiau openeso tanumo, kahurae okaumin. Osoman anomo mirika. Tea mo, mka Anahatana irui pahalaa mainae osimo roe noiyaha. Sani mansia openeso tanumo orati sohimo, areimo sani moa upu momou openeso tau sio mamsima runa Anahatana ne maunauna oi. ");
INSERT INTO nxl_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ne omi wan mo kupan kaya muie reini, mka osupu siraka. Tea mo, osupu pusire tau ruamo mo sanan nea. ");
INSERT INTO nxl_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Omi wani tiamo pokona muie reini, mka usupu siraka. Mka omakaneamo. Omi wani oaumani anomo mirika muie reini, mka osupu siraka. Mka orani anomo rapunokoso. ");
INSERT INTO nxl_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Sani sio pusiso oanamana oainaa runamo, mka osupu siraka. Moa upu moa momou oainaa runa sio wason oakarota ata sio mamsima runa Anahatana ne maunauna, aikee sae mo, tewa. ");
INSERT INTO nxl_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ne nanie uasau osi omi wan oatinu, “Anomo runa mo nisau. Ouna iake osi sio wason openeso tanumo. ");
INSERT INTO nxl_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Oainisi na Anahatana irui iake osi sio wason oainisi nnamo. Oainisi osi sio wason ouna kahatene tanumo. ");
INSERT INTO nxl_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Sani ia isa iasapana asum hae, arui asum hae honu na iasapanai oi. Te sani ia isa inana me papi naue, areimo atapiki inana me papite oi. ");
INSERT INTO nxl_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Sani ia isa iainisi sae isa arihonia, areimo aruiki osiki oi. Te sani ia isa inana me sae isa, areimo pene ainisi na iuniki osia honu. ");
INSERT INTO nxl_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Sani onina na sio ouna iake osimo, areimo kahurae ouna iake osi sio oi. ");
INSERT INTO nxl_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Sani anomo runa sio wason anoo runamo, areimo omi ata kani mka Anahatana iainaa runamo si? Sio palalosaya man anoo runa sio wason anoo runaso oi. ");
INSERT INTO nxl_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Te sani ouna iake osi sio wason ouna iake osimo, areimo omi ata kani mka Anahatana iainaa runamo si? Sio palalosaya iae ouna san rei oi. ");
INSERT INTO nxl_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Te sani sio umau nanie ohiti kepen arihonimo. Omi ata kani mka ounre osimo honu, areimo mka Anahatana iainaa runamo si? Areimo tewa, tea! Sio palalosaya iae orui osi umau oi na oata kani mka ounre osiso honu. ");
INSERT INTO nxl_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ne kahurae anomo runa mo nisau. Ouna iake osiso. Orui sae wani nanie ohitiki arihonimo rei, pene anomo rauponu na ounre osimo honu. Sani ouna san rei, areimo mka Anahatana irui pahalaa wan mainae nai osa osimo. Mka ouna Anahatana wain Ia Mainae Nai osa ne hehuka. Tau Ia mo, ne iake runa sio kahatena runa sio wason oainisi iake arihoniki tewa. ");
INSERT INTO nxl_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Anomo runa ia seia man, nooi sani Amari roe noiyaha wain anoi runa ia seia man oi.” ");
INSERT INTO nxl_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesus wain iaunau ne mampusua. Iahata, “Pene amanaru sio umau, na pene Anahatana iamanarumo oi. Pene oapasana sio umau, na pene Anahatana iapasanamo oi. Pene anomo rasaa tau sio wasoni ouna sana tanumo, na Anahatana iae anoi eresaa tanumo tewa. ");
INSERT INTO nxl_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Orui sae wan iake osi sio umau, oyo Anahatana iae mka irui sae wan iake osi omi honu. Nooi sani ia isa iapatau supa wani irotui, ikokai rotu-tu taue ia-ia reasa-asapupui rotu-tu umau raohuso pan mui. Oyo iohu pusire tau me wola-wola. Sani Anahatana irui osimo, areimo mka ipake supa wani nooi sani opakei tau orenu osi sio umau rei oi.” ");
INSERT INTO nxl_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesus iruni runa matieue isa osiso na iatuhete ata kahurae ne mampusua no hali sani Ia. Pene sani sio ona akama Yahudiu. Iahata, “Sani ia mata putie irori ia mata putie mo, mka sapan? Mka uaso oamnahu nonu tea! ");
INSERT INTO nxl_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Pene ia mampusue iata kani ia mo, mka ia mainae inesi ne ia matuhetene. Ne sani ia isa wain isupu matuhetene pusi nea, mka nooi sani ne ia matuhetene rei. ");
INSERT INTO nxl_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nanie onoo kakam wanim ne rosa wani ikine man tahae? Rosa wani ikine rei mo, nooi sani ai sinte pan matai usene anoe. Aikee sae mo, ruamo mo rosa mainae. Mainae nooi sani ai oto mainae pan matamo usena anoa. ");
INSERT INTO nxl_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Sapan na oasau osi kakam wanim oahata, ‘Kaka, mai na unana ai sinte waro matam usena reino.’ Aikee ai oto mainae waro ruamo matamo usena anoe, ne onooi tewa. Ee omi makarotana wani oasau ata omi mo, omi manisata. Aikee omi mo, omi manisata tewa. Kahurae ruamo onana ai otoe arihoni matamo usena anoa naone, samatoro onoo iake na onana ai sinte arihoni kakam wanim matai usene.” ");
INSERT INTO nxl_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesus wain iaunau ne mampusua. Iahata, “Ai wani reruhu iake, mka rehoka huaya waron iaka oi. Ai wani reruhu iake tewa, mka rehoka huaya waron iaka tewa oi, tea! ");
INSERT INTO nxl_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ita iationa ai arihoni nene huaya. Mono unie erehoka ara huaya tewa. Ita ihuku anggur huaya arihoni kainuniu hutua tewa tea! ");
INSERT INTO nxl_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Sio wason iaka ouna sae man waron iaka tau anoa iae iaka oi. Sio wason sio kahatena ouna sae man waron kahatena tau anoa iae kahatena oi. Tau sae wani erehokai arihoni hohari, areimo erehokai arihoni anori oi.” ");
INSERT INTO nxl_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yesus wain ianamana osi ne mampusua. Iahata, “Pene oi Au ‘Upu, Upu,’ ne oatinu tau we maunauna tewa. ");
INSERT INTO nxl_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ia seia wain ihokai mai tanuku, oyo iatinu tau sae wani uaunaui na ipusui, areimo nooi sani sae wani nanie uruniki osimo reini. ");
INSERT INTO nxl_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ia rei mo, nooi sani ia isa wain iapuoo numa. Ia rei ikani nonu rotu-tu hainau samatoro iaunutu hatu tinipae roe tuama makae oyo iapuoo ne numa. Oyo uane mainae, waene erenia mainae. Waene rei mka eresau-sau numa rei, ne numa rei remnoho tewa. Tau sae, numa reimo, iapuooi roe tuama makae. ");
INSERT INTO nxl_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ne ia wain iatinu tau we maunauna, ne ipusure tewa, ia rei mo, nooi sani sio wason oapuoo numa tau tuamane hahae man. Oyo ua mainae, waene erenia mainae. Waene rei mka eresau-sau numa rei, oyo remnohoi. Rekahatei mainae nai osa.” ");
INSERT INTO nxl_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesus iaunau mansia panesi pusi, oyo ieui poe kota Kapernaum. ");
INSERT INTO nxl_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Poe kota rei ia kapitane tau tantara Roma sio utun ne ia maniane isa waini anoi runai. Ia maniane rei waipo ikupui mtinte rotu-tu sira-sira tanui nea. ");
INSERT INTO nxl_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Taa ia kapitane rei iatinu sio oruni rerihoni Yesus, oyo iaisosi sio ona Yahudiu umau na oeuso noi Yesus na oainisi arihoniki na ihoka isuisene ne ia maniane waini ikupui rei. ");
INSERT INTO nxl_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Taa ohokaso noi Yesus oainisi runa anoo pusire ata, “Ama! Sani akahai ami ma ia kapitane mo, iake. ");
INSERT INTO nxl_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Areimo, tau ia mo, anoi runa ita Yahudiu. Ia iae, iakahaima tau apuoo ma numa mananoune rei oi.” ");
INSERT INTO nxl_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Iatinu san rei reiso ieu ikataso. Taa nanie ohaineke ia kapitane ne numa nea, ia kapitane rei iaisosi ne netau umau na oasau osi Yesus ata, “Upu! Pene unum reina tau aeua mai we numa nea. Tea mo, au reini mo, au sia na nanie uapusaaya mai we numa? ");
INSERT INTO nxl_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Reiso uanei ata au iae ueuku noi tanua iae iake tewa. Reiso pene aeua mai nea. Ne asau me sou otoe isa mani na we maniane reini iake. ");
INSERT INTO nxl_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tea mo, au reini mo, uatinu tau we sio mainaya oi. Au iae we tantarau oi wason oatinu tanuku. Sani uasau osi we tantara isa ata, ‘Aeu,’ oyo ieu. Nta uasau osi we tantara isa honu ata, ‘Aeu mai,’ oyo ieui mai. Te uasau osi we maisosie, ‘Una rei,’ oyo iunai.” ");
INSERT INTO nxl_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Taa Yesus iatinu sae wani ia kapitane rei iasau rei, isira nai osa. Oyo iuni iasau osi sio panesi rei iahata, “Oatinu ia-ia! Ia reini mo, ia Israel tewa, ne iparisaa tau Au nai osa erenesi omi Israel.” ");
INSERT INTO nxl_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Sio wasoni ia kapitane iaisosiso rei onunso poe numa. Hoka poe oimo, ia maniane rei iake nea. ");
INSERT INTO nxl_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yesus isuisene ia kapitane ne ia maniane pusi, oyo ieui poe niane isa. Ne mampusua na sio panesi oeu okatai oi. Niane rei nanae Nain. ");
INSERT INTO nxl_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yesus nanie inusu niane rei nene mitanunue, sira tau sio umau ohana ia matane isa tau ne enete nanie oeu okaniki. Ia waini imatai rei mo, ia pina uhanu isa anai hanaie osa man. Sio panesi arihoni niane rei wason okata ia pina uhanu rei. ");
INSERT INTO nxl_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Taa Upuri Yesus inooi, anoi runai nai osa. Oyo iasau ata, “Ina! Pene arani nea!” ");
INSERT INTO nxl_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Oyo Yesus ieu haineke enete rei iakahuui. Oyo sio wasoni oahana enete rei oaraoo rei sirinia. Yesus iasau osi ia waini imatai rei. Iahata, “Ano iki hehuke, hanua nea!” ");
INSERT INTO nxl_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Sira tau ia iki hehuke rei ihanui oyo iruei ianamanai. Pusi, oyo Yesus ikatai noi inai. ");
INSERT INTO nxl_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Sio pusiso wasoni noi rei osira. Oyo oainaa runa Anahatana. Oasau ata, “Ia mamsima runa Anahatana ne maunauna isa wain ne kawasa mainae wain ihokai mai tanuta nea.” Sio umau honu oasau ata, “Anahatana waini ihokai na iakahai ne mansiau, ita reini.” ");
INSERT INTO nxl_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mansiau oeu oruni rerihoni Yesus iapuhai ia iki hehuke rei neka pusi otoe Yudea na otoa umau waron rahaineke Yudea oi. ");
INSERT INTO nxl_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yohanis ne mampusua osima osi Yohanis rerihoni sae waroni Yesus iunare nea rei. Reiso Yohanis ioi ne mampusua ua ");
INSERT INTO nxl_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","na iaisosiso oeuso pan Upuri Yesus na oasei tanui. Oasei ata, “Upu, ano reini mo, Ia Anahatana Iratia Apuheu Mansia wain sio mamsima runa Anahatana ne maunauna oasau runaya te tewa? Ami wan anapa-napaya reini tea. Te ami kahurae anapa ia tamene isa honu?” ");
INSERT INTO nxl_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Taa ohokaso noi Yesus, oasau ata, “Upu, Yohanis ia mamsohue iaisosima mai, na asei tanua ata, ‘Ano reini sahoro Ia Aia wain Anahatana Ihitia na Apuheu Mansia wain sio mamsima runa Anahatana ne maunauna oasau runaya te tewa? Ami wani anapa-napaya reini tea. Te ami kahurae anapa ia tamene isa honu?’” ");
INSERT INTO nxl_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tau rei iae, Yesus isuisene sio panesi wasoni no kupua inaya nita-nitaya. Inei sakahatena arihoni sio panesi. Isuisene sio mata putia panesi oi na onoo mosa. ");
INSERT INTO nxl_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Iasau ata, “Onunimo poe Yohanis na oasau osiki rerihoni sae waroni onoore tau matao kahutua na ruamo oatinure rei. Sio mata putia onoo, sio talaya oeu, sio wason okupu unte wani iake tewa nai osa iaka, sio ririena oatinu. Sio matana oamahaiso honu. Au iae wani usima na Sou Iake rerihoni Anahatana osi sio mosokinia. ");
INSERT INTO nxl_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Anahatana irui iake osi ia sia wain iparisaa tau Au sirinia, masike Au mo, sio ata kani nooku sani Au Aia wain Anahatana Ihitiku na Uapuheu Mansia tewa.” ");
INSERT INTO nxl_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yohanis ne mampusua ua rei onunso, oyo Yesus iruni rerihoni Yohanis osi sio panesi. Iahata, “Oeumo pani otoe huie rei nanie onoo sia? Oeu oatinu ia wain ikati-kati ne maunauna sani oni hutua waron ihute reuhonare suru ria suru nau mo, tewa tea? ");
INSERT INTO nxl_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Oeumo pan rei nanie onoo sia? Nanie onoo ia wain iausahu api marainia? Tewa, tea! Sio wason oausahu papi hunonia mainaya na orueso no sanan orue tau numa aiau. Orueso pan otoe huie tewa. ");
INSERT INTO nxl_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ne oeumo pani rei nanie onoo sia? Nanie onoo ia mamsima runa Anahatana ne maunauna tea! Titue! Yohanis mo, ia mamsima runa Anahatana ne maunauna wain inesi sio mamsima runa Anahatana ne maunauna wason oanaonei. ");
INSERT INTO nxl_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ia mamsima runa Anahatana ne anamanaya isa ikanu rerihoni Yohanis mamsohue tau Anahatana ne anamanaya nea.” Anahatana iasau ata, “Au mka uaisosi we ia mamsimae isa ianaonea. Ia mka iseka tau mansia anoo noo sani oseka tau arena osi aia na inikui noi arena rei. ");
INSERT INTO nxl_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Oatinu ia-ia! Rerihoni omi pusimo wani oamrai mai tuniai reini mo, ia sia man inesi Yohanis tewa. Ne muie reini, ia sia sahoro ikata Anahatana tau irime ne mansiau, masike ia mo, ia ikine mani, ia mo, ia mainae. Ia reimo inesi Yohanis.” ");
INSERT INTO nxl_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Sio pusiso oatinu sae wani Yesus iasaui rei. Sio mainisi peau iae oatinu oi. Pusiso oamanaku ata Anahatana ne arena mo, manisate. Areimo, tau orui ruao na Yohanis isohuso na mansiau oanei ata oarihoni no rosau nea. ");
INSERT INTO nxl_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ne sio onata arihon akama Yahudiu na sio matuhete Musa ne maunauna openeso oatinu tau Anahatana ne maue tau sio. Areimo, tau openeso tau Yohanis isohuso na mansiau oanei ata oarihoni no rosau nea. ");
INSERT INTO nxl_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesus iasau honu iahata, “Omi wan oamahaimo naene reini noomo sani sae ano? ");
INSERT INTO nxl_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Omi mo, noomo sani sio iki hehuka polotu ua wasoni oru-rueso poe sio manahenia oyo polotu isa oakapona osi polotu isa ata, ‘Akeku tihane nea na oauwotimo, ne oauwoti tewa. Ahete ahina mananokone, ne orani tewa.’ ");
INSERT INTO nxl_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Omi iae openemo tau Au na Yohanis oi. Tea mo, Yohanis ia mamsohue ihokai mo, iai muaina waron onon ranie iaire mo, tewa. Irui ruai osi Anahatana reiso iai poroti tewa, ininu tihu anggur tewa. Omi oasau ata, ‘Iauwena runa sakahatene.’ ");
INSERT INTO nxl_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ne Au, Tumata Reini, Anahatana Ihitiku mo, uai na uninu. Ne omi oasau ata, ‘Masi onoo. Ia tai onate. Ininu panesi. Ioi neta runa sio mainisi peau na sio palalosa tamena.’ ");
INSERT INTO nxl_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ne, sani ita nanie ianei Anahatana waini ianei sae waron iaka runa sae waron iaka tewa mo, inoo pusu sio wasoni oparisaa tau Anahatana no atata. Sio mo, omaha ia-ia reiso oanei ata sae waroni Yohanis runa Au aunare mo, titue.” ");
INSERT INTO nxl_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ia onate arihoni akama Yahudi isa ianaha runa Yesus sio na oaiso poe ne numa. Ia rei mo, nanai Simon. Reiso Yesus ieui poe Simon ne numa oyo irue iaiki. ");
INSERT INTO nxl_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Noi niane rei ia pina isa waimo. Ia pina rei mo, mansia pusiki oanei ata ia mo, ia pina numa naue. Iatinu ata Yesus waimo iaiki noi ia onate rei ne numa oyo ieui noi numa rei. Ihoka irori mina hau rihue wan sio oaiinui tau potone isa. Potone rei mo, sio ounai arihoni hatu wan marainie. ");
INSERT INTO nxl_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ia pina rei iooi mai Yesus totui. Ieui ihaineke Yesus ain atui oyo ikanahata na irani. Reiso iuna iampeta Yesus ain atui tau matai waena. Oyo ikusare tau ne huau. Oyo imuki Yesus ain atui. Oyo isona Yesus ain tau mina hau rihue rei. ");
INSERT INTO nxl_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ia onate waini ianaha runa Yesus rei inoo sae wani ia pina rei iunai osi Yesus rei. Oyo ianamana pani anoi. Iahata, “Munata ia reini mo, Anahatana ne ia mamsima runa ne maunauna mo, kahurae ianei ata ia pina waini iakahuui reini mo, ia pina wan ne hali sapan. Kahurae ianei ata ia pina numa naue.” ");
INSERT INTO nxl_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Oyo Yesus iasau ata, “Simon, nanie uasau sae isa osia.” Oyo Simon iahata, “Matuhetene, asaui roe.” ");
INSERT INTO nxl_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Iahata, “Sio ua oeu ohiti noti noi ia wain saka ihiti ai totua osi mansiau. Ia isa ihiti panesi sani ia isa ipakarian onona utun nima nene kati. Ia isa honu, ihiti mkane sani ia isa ipakarian onona hutu nima nene kati. ");
INSERT INTO nxl_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Uaso osenu kua notiu rai tewa. Reiso ia waini ihiti ai totua osiso rei iasau osi uaso, ‘Pene osenu mo notiu rai nea.’ Reiso, arihoni sio ua reini mo, ia sia sahoro anoi runa ia waini ihiti ai totue osiso rei mainae?” ");
INSERT INTO nxl_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon iahata, “Pusu au mo, kani ia wain ihiti noti mainae nai osa.” Iahata, “Titue nai osa.” Yesus iruni mamruni matieue rei, tea mo, ia wain ne noti mainae noo sani ia pina wain ne rosau panesi rei. ");
INSERT INTO nxl_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Oyo Yesus iuni inoo ia pina rei oyo iasau osi Simon ata, “Masi anoo ia pina rei! Uhokaku mai me numa, arui tihu osiku tewa na usohu aiku atua. Ne ia pina rei isohu aiku atua tau matai waena. Oyo ikusare tau ne huau na kaimenna. ");
INSERT INTO nxl_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tau apusaaku mai me numa, amukiku man tewa oi. Ne ia pina rei iarihoni imuki aiku atua tewa. Imuki oni unusu me numa asi rotu-tu reipan. ");
INSERT INTO nxl_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ano asona mina roe unuku tewa nai osa. Ne ia pina rei isona mina hau rihue poe aiku atua. ");
INSERT INTO nxl_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Reiso atinu ia-ia. Ne rosau waroni panesi rei, usiru heu pusire nea. Tea mo, mato iatuhete ata anoi runaku mainae. Ne ia sia man wain iahana ata ne rosau mkana man, oyo usiru heu ne rosau rai, anoi runaku iae mkane man oi.” ");
INSERT INTO nxl_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Oyo iasau osi ia pina rei. Iahata, “Usiru heu me rosau nea.” ");
INSERT INTO nxl_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Sio panesi wasoni oaiso kata Yesus rei oasau pani anoo. Oahata, “Ira! Ia reini mo, ia sia na iasau ata isiru heu mansiau no rosau?” ");
INSERT INTO nxl_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pusi, oyo Yesus iasau osi ia pina rei ata, “Ano aparisaa tau Au reiso uapuheua na pene Anahatana iapasanaya. Eua noi. Uainisi na Anahatana iunaya akarihuru amahai.” ");
INSERT INTO nxl_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ia pina isa isona Yesus ain atui tau mina hau rihue oyo potuina tewa, oyo Yesus ieu neka kotau runa niana-niana. Ieu isima na Sou Iake rerihoni Anahatana irime ne mansiau. Ne mampusua hutusa rahana ua oeu okatai oi. ");
INSERT INTO nxl_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Sio pinau umau wasomo okataso oi. Sio pinau rei mo, sio umau Yesus isuiseneso, sio umau honu inei sakahatena arihoniso nea. Sio pinau rei mo: Maria wain sio ooiki tau Magdalena. Tea mo, ia ne niane nanae Magdalena. Ia iae, Yesus inei sakahatena itu arihoniki nea oi. ");
INSERT INTO nxl_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yohana, Kusa sahai. Kusa mo, Herodes hanai wanane. Susana runa sio pinau panesi umau oi. Sio pinau reini mo, saka orui ai totua na oakahai Yesus sio. ");
INSERT INTO nxl_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Taue isa, sio panesi oamanouso mai Yesus. Ohokaso arihoni kotau noi otoe rei. Oyo Yesus iruni matieue isa. Arei mo, atinui san rei, ");
INSERT INTO nxl_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Taue isa, ia mamrahue isa ieui iahurara atuhu kania noi ne nisi. Iahurara atuhu kania rai ne umau ramnahuso noi arena tiae. Reiso mansiau oniku ohetare. Manua ratasoho raaire. ");
INSERT INTO nxl_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Atuhu kania umau honu ramnahu tuama hatu lekau. Reiso, raruhu roe, oyo potuina tewa oi ramnunuso. Areimo, tau tuamane rekaimeniki. ");
INSERT INTO nxl_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Atuhu kania umau honu ramnahu mono unia. Oyo raruhu rakata umau ne mono unia rai raruhu rasapare rotu ramataso. ");
INSERT INTO nxl_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Atuhu kania umau honu ramnahu tuama iake. Taa raruhuso roe, nene huaya panesi ranesi sae waroni irahure rei. Kanie osa nene huaya utun.” Yesus iruni matieue pusi oyo iakapona, “Ia sia tinai ukuna mo, kahurae atinu ia-ia!” ");
INSERT INTO nxl_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Pusi, oyo Yesus ne mampusua oasei tanui. Oahata, “Upu! Matieue rerihoni atuhu kania rai mo, sima runa nene isie osima ee!” ");
INSERT INTO nxl_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesus iasau ata, “Anahatana ihuka omi, we mampusua, anomo nea. Reiso oanei sapan na irime ne mansiau. Ne uruni matieua osi sio wason we mampusua tewa. Na masike onoo sae waron Au unare nea iae, oaneire tewa. Masike oatinu we maunaune nea iae, oanei nene isie rei tewa sirinia. ");
INSERT INTO nxl_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Reiso matieue rei mo, nene isie san rei. Atuhu kania rai mo, noore sani Anahatana ne anamanaya. ");
INSERT INTO nxl_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Atuhu kania waroni ramnahuso noi arena mo, noore sani sio wasoni oatinu Anahatana ne anamanaya. Ne ia aia sakahatene ihoka iuna anoo kanihua runa sae waron oatinure rei. Reiso oparisaa tanure tewa reiso Anahatana iapuheuso na okatai rotu-tu ria supan tewa. ");
INSERT INTO nxl_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Atuhu kania umau honu waroni ramnahu tuama hatu lekau mo, atieu rei sani sio wasoni oatinu Anahatana ne anamanaya, oyo oatarimare anoo mirika. Ne oapamese kua tewa sani atuhu waron nene namta tewa mo, rapamese kua tewa. Areimo oparisaa rotu-tu potuina tewa. Osupu masana, oyo oparisaa tau Anahatana tewa nea. ");
INSERT INTO nxl_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Atuhu kania waroni ramnahu mono unia mo, atieu rei sani sio wasoni oatinu Anahatana ne anamanaya oyo opusure. Ne anoo raupono runa tuniai reini, onina kepen runa apia panesi man, na nanie tau no sanan mai tuniai reini mani. Sio wasoni san rei mo, mka no hali pannuhu na Anahatana ne anamanaya tewa. Noo sani atuhu waron nene huaya tewa. ");
INSERT INTO nxl_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Oo atuhu kania waroni ramnahu tuama iake mo, atieu rei sani sio wasoni oatinu Anahatana ne anamanaya oyo rarue pani anoo. Anoo rai iaka nai osa. Oakarota tewa. Sio wasoni san rei mo, no hali pannuhu na Anahatana ne anamanaya.” ");
INSERT INTO nxl_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Mansia oakanupu kamane oyo osoui tau parten mo, tewa tea! Te oaunutui poe koi nohue mo, tewa tea! Ne oaunutui tau naniae na ia sia mani waini inusui noi numa anoe inoo nene itane na inoo mosa. ");
INSERT INTO nxl_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mka Anahatana iatuhete ne maunauna waron naone rauhunso. Sae mani wan rauhunso, mka Anahatana iatuhete ne maunauna nene isie. ");
INSERT INTO nxl_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Reiso saka oatinu ia-ia. Ia sia mani wain anei we maunauna nea, mka Anahatana ihuka anoi na ianei renesi honu. Ne ia sia waini ianeire tewa, mka Anahatana inea sae waron iata kani ianeire rei.” ");
INSERT INTO nxl_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Taue isa, Yesus inai runa nea waniu oeuso noi tanui. Ne nanie ohainekei ne resun tau mansiau panesi onete arena. ");
INSERT INTO nxl_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ia isa isima osiki ata, “Upu, inam runa mea waniu nanie oeuso mai tanua. Wason ooso pan mui nanie onooa.” ");
INSERT INTO nxl_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ne Yesus iahata, “Sio wasoni oatinu tau Anahatana ne maunauna oyo ouna suire areimo, sio sahoro inaku runa we waniu.” ");
INSERT INTO nxl_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Taue isa, Yesus iasau osi ne mampusua. Iahata, “Mai na isaa arupai na ieuta ria waene ria hae.” Reiso osaa arupai oyo oeuso. ");
INSERT INTO nxl_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Wasoni oeuso, Yesus ineke munui. Sira tau ihu onate ereuna kola onata rapapa no arupai rei rotu-tu waene renusu pani arupai anoe. Haineke omokoso nea. ");
INSERT INTO nxl_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Reiso Yesus ne mampusua ohanu Yesus. Oahata, “Upu, Upu! Mka imatata. Nanie imokota nea reini!” Oyo Yesus ihanui iasau na nioi makae tau ihute runa kola onata rei. Iahata, “Amaturumo!”. Oyo ihute runa kolau rai ramanu. ");
INSERT INTO nxl_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Oyo Yesus iasau ata, “Oparisaa tau Au tewa ata mka uakahaimo tewa si?” Oyo pusiso okaitau na osira. Oasei mai umau. Oahata, “Ia onate reino mo, ia sia? Ihute na kolau man oo, ratinu tanui.” ");
INSERT INTO nxl_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesus runa ne mampusua osaa arupai rotu-tu ososuso ria hae, ria otoe Gerasa. Otoe rei mo, waria Wae Galilea ria hae. ");
INSERT INTO nxl_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Noi otoe rei, ia hanaie isa wain sakahatena ramasuniki. Sakahatena saka ranesa-nesai potuina nea. Reiso sio noi otoe rei okanihoo ain atui runa hanai atua tau rante. Ne, masike osakai sui osa iae, iuna roha ranteu rai sirinia. Oyo sakahatena raroriki noi otoa waroni huia. Reiso irue mosa noi numa anoe tewa nea. Naone irue ria kota Gerasa ne tewa nea. Saka iruei sui kupuro. Iausahu papite na taka tewa potuina nea oi. Taa Yesus isipu ria kaimenne oyo ia hanaie waini sakahatena ramasuniki rei ieui mai Yesus. Hoka mai, oyo Yesus iaisosi sakahatena rai. Iahata, “Ohokamo!” Taa inoo Yesus, iakapona oyo irike tunne mai Yesus uai anoe. Ne sakahatena rai raasau na nioa mainaya. Raahata, “Yesus, Anahatana Wain Ia Mainae Anai, nanie amunaku? Uainisi tau Anahatana nanai, pene auna sinsaraku.” ");
INSERT INTO nxl_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Pusi, oyo Yesus iasei tanui, iahata, “Nanam sia?” Iahata, “Au mo, nanaku ‘Panesi’.” Iasau san rei tau sakahatena panesi nai osa ramasuniki nea. ");
INSERT INTO nxl_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Oyo sakahatena rai raai-ainisi arihon Yesus. Rahata, “Pene aisosima aeu poe ekote wan Anahatana iapasana sakahatena.” ");
INSERT INTO nxl_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Noi tihue rei, hahu panesi warumo ranina muaia roe sanene pupue. Oyo sakahatena rai raainisi arihoni Yesus ata, “Yesus ee! Sani nanie aneima mo, aisosima na anusuma pan hahu rapan!” Oyo Yesus iasau ata, “E-e! Eumo na nusumo pani hahu rapan nea!” ");
INSERT INTO nxl_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Pusi oyo, sakahatena rai rahokaso arihoni ia rei, samatoro oeuso onususo pani hahu rai. Oyo hahu rai raruma rapu pusu ekote hanae rei rotu-tu rasoman na poe waene. Oyo ramokoso, oyo ramataso. ");
INSERT INTO nxl_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Sio mamsaka hahu rai onoo san rei, oyo oruma osima osi sio ria niane runa sio sui nisiu. ");
INSERT INTO nxl_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Osima, oyo pusiso ohokaso, nanie onoo. Hoka nau Yesus sio oyo osupu ia hanaie wain naone sakahatena ramasuniki rei. Onooi waimo iruei haineke Yesus ain. Iausahu apia nea na imuke tewa nea. Reiso pusiso okaitau. ");
INSERT INTO nxl_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Oyo sio wason onoo pusire sinasi rei, oruni rerihoni Yesus inei sakahatena arihoni ia hanaie rei. ");
INSERT INTO nxl_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","39","Pusi, oyo sio noi otoe Gerasa oasau osi Yesus. Oahata, “Upu! Aeua arihoni ma otoe rein nea!” Oasau san rei, tau pusiso okaitau hunu ruao. Ne ia wain naone sakahatena ramasuniki rei iainisi arihoni Yesus. Iahata, “Upu! Ueu upusua oi kee!” Ne Yesus iasau osiki ata, “Pene nea! Nunia poe me numa na asima osi me mansiau rerihoni sapani na Anahatana iunaya iake nea reini.” Pusi oyo, Yesus sio osaa no arupai wan sinasi rei. Oyo, ia rei ieu iruni osi mansiau sui supan mani noi niane rei rerihoni Yesus inei sakahatena arihoniki rei. ");
INSERT INTO nxl_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesus inuniki on nau waene, on nau hae. Sio panesi onapai reiso oatarimai. ");
INSERT INTO nxl_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Sira tau ia onate isa tau sio Yahudiu no numa mananoune ihokai mai tanui. Ia onate rei mo, nanai Yairus. Ihokai oyo irike tune mai Yesus uai anoe. Iahata, “Upu, mai na eua poe we numa nea. ");
INSERT INTO nxl_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Tea mo, anaku pina waipo ikupui mtinte haineke imatai nea.” Anai pina osa mtola mani. Ia ikine pina rei mo, kani ne musum hutusa rahana ua san rei nea. Reiso Yesus ieu ikata Yairus poe ne numa. Wason oeu, mansia panesi oneteso rotu-tu oeseso. ");
INSERT INTO nxl_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ia pina isa wain ieu nasi musum hutusa rahana ua nea waimo ikata sio panesi rei oi. Ia isa tewa oi isuisene kua ne kupue rei tewa. ");
INSERT INTO nxl_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ieu pusu Yesus totui nanie ieu hainekei. Oyo isii Yesus ne papi naue nene rurue. Oyo nasi rerihon rei sirinia. ");
INSERT INTO nxl_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Oyo Yesus iasau. Iahata, “Ia sia isiiku rei ano?” Ne sio pusiso oauhaa. Oyo Petrus iasau ata, “Upu, mansia hutue wason rotu-tu ososo umau oesea.” ");
INSERT INTO nxl_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ne Yesus iasau ata, “Ia isa isiiku. Areimo tau uahana we mkonae rekaisunu mkane.” ");
INSERT INTO nxl_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ia pina rei ianei ata sae waini iunai rei mo, Yesus ianeiki nea. Oyo ieu ikana-kananunui mai Yesus. Oyo irike tune mai Yesus uai anoe. Pusi, oyo iruni osi sio panesi rerihoni sae eremuna na isii Yesus oyo tau rei sirinia, ne kupue iake rei sirinia. ");
INSERT INTO nxl_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesus iasau osi ia pina rei. Iahata, “Anaku! Aparisaa tanuku, reiso me kupue rei iake sirinia. Aeu noi, akarihuru amahai.” ");
INSERT INTO nxl_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesus waini ianamana osi ia pina rei asi, sira tau ia isa ihokai on pan Yairus, ia onate wain sinasi rei, ne numa. Iasau osi Yairus ata, “Upu! Anam pina watipusi nahai nea. Reiso pene auna apaputa ia matuhetene reino nea.” ");
INSERT INTO nxl_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ne Yesus iatinu ia rei ianamana reiso iasau osi Yairus iahata, “Pene akaitau! Aparisaa man. Anam reimo mka iamahaiki honu.” ");
INSERT INTO nxl_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Taa ohokaso poe Yairus ne numa, Yesus isopo na pene ia isa man inusu katai. Hasae Petrus, Yohanis, Yakobis runa ia ikine rei inai na amai man. ");
INSERT INTO nxl_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mansia pusiki wasoni noi rei orani ohiti tau ia ikine rei imatai nea. Ne Yesus iasau ata, “Pene orani. Ia ikine pina reini mo, imata tewa. Ne wain inekei man.” ");
INSERT INTO nxl_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ne sio panesi rei oaumaniki. Tea mo, oanei nea ata ia ikine pina rei mo, imatai nea. ");
INSERT INTO nxl_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Oyo Yesus irime ia ikine pina rei hanai oyo iasau osiki iahata, “Anaku, ahanu!” ");
INSERT INTO nxl_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Oyo ia ikine rei tiunui erenuniki noi tanui honu. Oyo tau rei sirinia ihanu hitio. Yesus iahata, “Mai, na opanai.” ");
INSERT INTO nxl_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ia ikine rei inai na amai osira hunu ruao. Ne Yesus iasau, “Pene oeu oruni osi ia seia man rerihoni sae wani onooi reini.” ");
INSERT INTO nxl_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesus ianaha na ne mampusua hutusa rahana ua, oyo irui kawasa osiso na onei sakahatena arihoni sio wason oauwena na sakahatena na osuisene kupua inaya. ");
INSERT INTO nxl_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Iaisosiso oeu osima na Anahatana irime ne mansiau na oeu osuisene sio kupua. ");
INSERT INTO nxl_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Iasau osiso iahata, “Pene orori sae man. Pene orori toka-toka te, tasi te, weka te, kepen te, papite tau okati. Orori hasae osa man. ");
INSERT INTO nxl_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Sani munata onusu pan numa isa, orue tau numa rei rotu-tu oeu oarihoni niane rei. ");
INSERT INTO nxl_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Sani sio noi niane isa oatarimamo tewa, areimo oeumo arihoni niane rei. Taa nanie ohitio oeumo mo, oroho heu tapuna arihoni aimo atua na rerui kakinate osi sio rei ata Anahatana mka iapasanaso tau sio oatinu tau ne maunauna tewa.” ");
INSERT INTO nxl_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Reiso ne mampusua rei ohitio oeuso neka niana-niana. Oeu osima na Sou Iake rerihoni Yesus runa osuisene sio kupua sui supan. ");
INSERT INTO nxl_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Aia Herodes iatinu rerihoni sima-simana waron Yesus iunare. Reiso anoi reuponu. Tea mo, iatinu sio umau oahata, “Anahatana iuna Yohanis ia mamsohue iamahaiki honu!” ");
INSERT INTO nxl_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Sio umau honu oahata, “Ia mamsima runa Anahatana ne maunauna wain nanai Elia rei ihokai mai tuniai honu.” Sio tamena umau honu oahata, “Ia isa arihoni sio mamsimaya wason naone wain iamahaiki honu.” ");
INSERT INTO nxl_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ne Herodes iasau iahata, “Yohanis mo, uaisosiso onana unui nea rei. Reiso ia wain uatinu hapare ata iuna sima-simana reini mo, ia seia manisate?” Oyo inina arena na isupu Yesus. ");
INSERT INTO nxl_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesus ne maisosia osima runa Sou Iake rerihoni Yesus na osuisene sio kupua, oyo onunso poe Yesus honu. Hoka poe, oyo osima runa sae waron ounare rei pusire osiki. Osima pusi, oyo Yesus ieu ikataso poe nia Betsaida na sio ruao man. ");
INSERT INTO nxl_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ne sio panesi oatinu, reiso oeu pusui. Yesus iatarimaso, oyo iruni rerihoni Anahatana irime ne mansiau osiso na isuisene sio wason okupuso. ");
INSERT INTO nxl_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Taa eresou-sou san rei, oyo sio mampusua hutusa rahana ua rei ohokaso mai Yesus. Oyo oahata, “Upu, otoe reini mo, huie. Samatoro meneta nai osa. Reiso nene iake mo, Upuku aisosi sio panesi reini oeuso na onina naniao tau onekeso runa no muaina sui niana-niana waron rahaineke otoe reini.” ");
INSERT INTO nxl_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ne iasau osiso iahata, “Omi sahoro opanaso!” Ne oahata, “Ami hasae ma porotiu hua nima runa ma ikaya use ua man. Sapani na aeu ahane muaine osi sio panesi reini?” ");
INSERT INTO nxl_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tau sio hutue rei mo, sio hanaia, sio mainaya nihu nima runa sio pinau na sio ikina oi. Oyo Yesus iasau osi ne mampusua honu iahata, “Aisosi sio panesi rei oru-rueso, tumun-tumun kani sana hutu nima-nima tau polotu osa-osa.” ");
INSERT INTO nxl_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ne mampusua ouna sae wani Yesus iasaui rei, oyo pusiso oru-rueso. ");
INSERT INTO nxl_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Oyo Yesus inana porotiu hua nima rai na ikaya use ua rai. Ikatare samatoro iarinaa na roe nante. Iahata, “Amaku Anahatana, Ano mo, Ano iake. Asamama tau muaina raini.” Oyo ikuparehi porotiu rai mkana-mkana tau hanai na iruire osi ne mampusua. Oyo ne mampusua osama-samare osi sio panesi rei. ");
INSERT INTO nxl_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pusiso oai rotu-tu tiao pokona. Oaiso suka, oyo sio mampusua oeu oamanou muaina nesia rai tau pakuna. Oapataure tau pakuna hutusa rahana ua rotu-tu taua. ");
INSERT INTO nxl_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Taue isa Yesus ruai iainisi. Ne mampusua iae wasumo okatai oi. Oyo iasei mai tanso iahata, “Sio hutue oasau ata Au reini mo, Au seia?” ");
INSERT INTO nxl_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Oahata, “Upu. Sio umau oasau ata Ano mo, Yohanis ia mamsohue wain iamahaiki honu. Sio umau honu oasau ata Ano mo, Elia, ia mamsima runa Anahatana ne maunauna. Samatoro sio tamena umau honu oasau ata Ano mo, Ano wan ia mamsima runa Anahatana ne maunauna isa on naone wain iamahaiki honu.” ");
INSERT INTO nxl_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Iasei honu, “Ne pusu omi ruamo mo, Au reini mo, Au seia?” Oyo Petrus on poe iasau iahata, “Ano mo, Ano Aia wain Anahatana Ihitia na Apuheu Mansiau.” ");
INSERT INTO nxl_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesus iatinu san rei pusi, oyo isoposo iahata, “Pene osima-sima osi ia seia man. Pene osima rerihoni Au ata, Au mo, Au Aia wain Anahatana Ihitiku na Uapuheu ne Mansiau. ");
INSERT INTO nxl_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kahurae Au Tumata Reini Anahatana Ihitiku mka sinsaraku panesi. Mka sio ona Yahudiu, sio imam no sio mainaya, na sio matuhete Musa ne maunauna openeso tanuku. Mka ohunuku, oyo onona ua oyo uamahaiku honu.” ");
INSERT INTO nxl_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesus iasau osi ne mampusua, “Ia sia wain nanie ipusu Au mo, kahurae pene ipusu ruai ne maue. Kahurae inoo ruai sani imatai onon ranie. Noo sani ia wain ihana ne hini wan reniene na sio ohunui. Iahana sani ruai imatai nea. Ihana ne hini wan reniene oyo ipusu-pusuku. ");
INSERT INTO nxl_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Munata ia isa ipenei irui ruai na imatai, mka tau muie imatai sirinia. Iamahaiki rotu-tu ria supan ikata Anahatana tewa. Ne munata ia isa irui ruai na imatai, mka iruei ikata Anahatana rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Masike ia isa isupu arataeu pusire mai tuniai reini iae, ne mka imatai iruei hainau arihoni Anahatana. Arataeu rai tau sae? ");
INSERT INTO nxl_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Munata ia isa iaumaa iamanaku ata iparisaa tau Au runa we maunauna, Au Tumata Reini mo, Anahatana Ihitiku iae, mka tau uhokaku honu, upeneku uamanaku ata uationa ia rei oi. Mka uhokaku honu, oyo sio onooku. Onooku, ita-itaku sani Amaku Anahatana na ne maisosia on roe noiyaha wason sio manisate onate. ");
INSERT INTO nxl_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Atinu mai ia-ia nanie uasau osimo. Omi umau wani okataku reini mka onoo Anahatana irime ne mansiau runa ne kawasa. Onoo ata irime ne mansiau mo, on omatamo tewasi.” ");
INSERT INTO nxl_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesus iatuhete rerihoni sio wason opusui no haliu pusi, oyo wanu rei san rei oyo, ieu ikata Petrus, Yohanis runa Yakobis roe tinetae isa nanie iainisi. ");
INSERT INTO nxl_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yesus wain iainisi, sira tau uai anoe reneniki. Resita haai. Ne apia iae nooi rahehi sani isoe oi. ");
INSERT INTO nxl_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Oyo sira tau onoo Musa runa Elia. ");
INSERT INTO nxl_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Uaso osita haaso. Uaso oanamana runa Yesus rerihoni mka imatai roe Yerusalem sani naone sio mamsima runa Anahatana ne maunauna oasau rei. ");
INSERT INTO nxl_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petrus runa ne netau ua rei mo, onekeso nea. Ne omaranae roe, osira tau onoo Yesus isita hai ikata sio ua wason oanamana runai rei oi. ");
INSERT INTO nxl_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Sio ua rei nanie oeu arihoni Yesus, oyo Petrus iasau osiki. Iahata, “Upu, ita mai rei mo, iake nai osa maa. Nene iake mo, ami apuoo wanana tonu. Isa osi Upuku, Ano. Isa osi Musa. Isa honu osi Elia.” Iasau san rei tau ianei tewa kahurae iasau sae. ");
INSERT INTO nxl_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petrus wain ianamana asi oimo, sira tau yahu eresouso. Wasopan yahu rei, okaitau hun ruao. ");
INSERT INTO nxl_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Oatinu nioke on pan yahu rei reasau ata, “Ia reini mo, Au Anaku wain uromai. Reiso oatinu tanui.” ");
INSERT INTO nxl_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nioke rei reasau pusi oyo, sira tau Yesus ruai nea. Ne mampusua tonu rei oama-amaturuso man. Tau rei, oeu oruni rerihoni sae wani onooi rei osi ia isa tewa oi. ");
INSERT INTO nxl_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Yesus ne mampusua onoo Yesus isita hai oyo nene hanroe san rei, Yesus runa ne mampusua rei onunso on roe tinetae rei. Sio hutue ohokaso nanie osupu Yesus. ");
INSERT INTO nxl_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ia isa arihoni sio hutue rei iakapona iahata, “Upuku Matuhetene. Usopa ukoku roua na aeua poe asuisene anaku. Tea mo, ia mo, anaku ia osa man. ");
INSERT INTO nxl_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Sakahatene remasuniki. Remasuniki oyo sira tau iasanoata. Sakahatene rei reunai imakakonai rotu-tu kahusea rahokaso on roe hohai. Sakahatene rei reunai sinsarai sui osa, noo sani nanie reeui arihoniki tewa nea. ");
INSERT INTO nxl_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Uainisi arihoni me mampusua nea na onei sakahatene rei ne onei kuai tewa.” ");
INSERT INTO nxl_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Oyo Yesus iasau osi sio panesi rei iahata, “Ee! Omi mo, masike. Omi napisi reini mo, oparisaa tewa. Mo haliu kahatena. Kahurae urue ukatamo rotu-tu inasa? Kahurae uapamesemo rotu-tu inasa?” Oyo iasau osi ia ikina rei amai iahata, “Autunu anam rei mai!” ");
INSERT INTO nxl_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ia ikine rei wain ihokai mai Yesus, sira tau sakahatene rei repesiki na poe tuamane. Reuna ne patane eremakakonai rotu-tu iamnohoi poe tuamane. Ne Yesus isopoi. Iahata, “Ahokaya arihoni ikine reino nea!” Rehokai oyo Yesus iasau osi ia ikine rei amai, iahata, “Mai anam reini.” ");
INSERT INTO nxl_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Sio panesi rei osira hunu ruao tau onoo Anahatana ne kawasa wani mainae nai osa rei. ");
INSERT INTO nxl_vpl VALUES ("LK9_43b","072_9_43b","LUK","9","43b","43b","Sio panesi osira tau Yesus iuna sima-simana. Oyo iasau osi ne mampusua. ");
INSERT INTO nxl_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Iahata, “Masi oatinu runa we anamanae reini ia-ia. Au Tumata Reini Anahatana Ihitiku mka oaheniku osi we nisau.” ");
INSERT INTO nxl_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ne oanei tewa rerihoni sae wani iasaui rei. Tea mo, Anahatana iuna iakanihu Yesus ne anamanae rei na pene oaneiki. Omoniki, reiso oasei tanui tewa. ");
INSERT INTO nxl_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesus ne mampusua otuntana runa umau noso ia seia sahoro mka iuna mainae nai osa. ");
INSERT INTO nxl_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ne Yesus ianei anoo. Reiso, ioi ia ikine isa oyo, iunai iooi mai nusui. ");
INSERT INTO nxl_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Oyo iasau mai tanso. Iahata, “Ia wain iatarima ia ikine isa sani ia ikine reini noso ipusuku, areimo noo sani iatarima Au oi. Sani ia isa iatarima Au, areimo iatarima Ia wain ihitiku rei oi tea! Pusu Anahatana mo, ia wain ia mainae mo, ia wain irati ruai na ianori runa mansia.” ");
INSERT INTO nxl_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohanis iasau osi Yesus iahata, “Upu, ami anoo ia isa inei sakahatena ihete Ano nanam. Ami asopoi. Tea mo, ia rei mo, arihoni ita tewa.” ");
INSERT INTO nxl_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Iahata, “Pene asopoi. Tea mo, ia wain mo nisa tewa, areimo omi mo neta.” ");
INSERT INTO nxl_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Haineke umetene Anahatana nanie iapusaa Yesus na roe noiyaha. Yesus ioto hatu nanie ieui na roe kota Yerusalem. ");
INSERT INTO nxl_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Iaisosi sio umau oeu anaoneso na oseka tau naniao poe niane isa pan otoe Samaria. ");
INSERT INTO nxl_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ne sio Samaria oatinu ata nanie ieu roe Yerusalem, oyo openeso oapusaai. ");
INSERT INTO nxl_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Taa ne mampusua ua, Yakobis runa Yohanis, onoo ata sio Samaria openeso oapusaaso, oyo uaso oahata, “Upu, anina na ami ainisi arihoni Anahatana na irati usa na rehunuso?” ");
INSERT INTO nxl_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ne Yesus iuni iakapuku tanso iahata, “Pene oasau san rei!” ");
INSERT INTO nxl_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Oyo pusiso ohitio oeuso poe nia tamene. ");
INSERT INTO nxl_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesus na ne mampusua wason oeu sui arena, oyo ia isa iasau osiki. Iahata, “Upu, aeu sui supan man, mka upusua.” ");
INSERT INTO nxl_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesus iasau osiki iahata, “Asu wesie runa manue mo, nene naniaya. Ne Au, Tumata reini Anahatana Ihitiku mo, naniaku tau uaunaka unuku tewa.” ");
INSERT INTO nxl_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Iasau osi ia tamene isa honu. Iahata, “Mai na apusuku.” Ne ia rei iahata, “Upu, tapiku ununiku na urueku ukata amaku rotu-tu imatai na ueu uautotui, samatoro ueu upusua.” ");
INSERT INTO nxl_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ne Yesus iahata, “Sio wason opusu Au tewa mo, Anahatana nooso sani sio matana. Reiso tapiso na oeu oautotu no sio matana rei. Ne ano mo, eua na asima na sapani na Anahatana nanie irime ne mansiau.” ");
INSERT INTO nxl_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ia tamene isa honu iahata, “Upu, au nanie una ano me mampusue. Ne tapiku ununiku poe we numa na usima osiso we numa hutae, samatoro mai upusua.” ");
INSERT INTO nxl_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ne Yesus iahata, “Sani ia isa ieti tuamane, pene inoo hae muie tau tuamane wan ietiki rei nea. Mka ieti katopue tewa. Ne pakarian iake tewa. Kahurae inoo hae uae. Areimo sani ia wain nanie ianori tau Anahatana irime ne mansiau. Pene anoi repeka runa ne mansiau na sae waron iarihonre nea. Mka ianori iake tewa.” ");
INSERT INTO nxl_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yesus wain ieui sui kotau runa niana umau. Reiso ioi ne mampusua tamena umau. Ioi sio hutu itu. Oyo iaisosi sana ua-ua oeu oanaone sui niana-niana waron mka ieui noi tanure rei. ");
INSERT INTO nxl_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Iasau osiso iahata, “Sio panesi wason mka oparisaa tau we maunauna mo, nooso sani atuhu panesi nai osa mtuaya nea. Ne sio wason nanie oeu oaunau mo, sio mkana man. Noo sani sio wason nanie oapahia atuhu rai mo, sio mkana man. Reiso ainisi arihoni Anahatana na iaisosi sio panesi honu oaunauso tau we maunaune. Noo sani ia nisi upue rei iaisosi sio umau na oeu oapahia atuhu rai. ");
INSERT INTO nxl_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ohitio na oeumo. Uaisosimo! Ne mka sio umau onesimo. Sio umau nanie ohunumo. Reiso omi mo, noomo noo sani rompa anae wani remahaiki kua asu wesia tihua. ");
INSERT INTO nxl_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Pene oeu orori tasi anae te tasi te sandaliu hasae waroni noi mo patana rai man. Pene oaraoo anamana runa mansiau sui arena tiae.” ");
INSERT INTO nxl_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Sani onusu pan numa isa, areimo ainisi arihoni Anahatana san rei “Upuku Anahatana. Auna sio mai numa reini okarihuru oamahai.” ");
INSERT INTO nxl_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Sani sio noi numa rei oatarimamo runa iake, areimo mka Anahatana iunaso okarihuru oamahai. Ne sani tewa mo, mka Anahatana iuna omi okarihuru oamahai, ne sio mo, tewa. ");
INSERT INTO nxl_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Oruemo noi numa rei. Oai oninu sae man wani numa upue rei iaunuture osimo na oai. Uaunaumo tau raini pusire, tea mo, omi mo, kahurae osupu seha pusu sae wani ounare rei. Pene oruemo tau numa isa pusi isa. ");
INSERT INTO nxl_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Sani onusu tau niane isa, oyo sio noi niane rei oatarimamo anoo kaia, areimo oai muai sae man waron oaunuture osimo. ");
INSERT INTO nxl_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Suisene sio wason okupuso. Sima osi pusiso ata Anahatana nanie irime ne mansiau nea. ");
INSERT INTO nxl_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ne sani onusu noi niane isa, ne oatarimamo tewa, areimo oeumo pusu arena onata oasau. ");
INSERT INTO nxl_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Oahata, “Ami mo penema oi neta runa omi nea. Reiso ami nanie akusa tapuna arihoni aima atua na oanei ata Anahatana ipenei iatarimamo. Ne omi mo, kahurae oatinu. Anahatana nanie irime ne mansiau nea. ");
INSERT INTO nxl_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Oatinu ia-ia! Nene orase wani Anahatana iapasana mansia pusiki mo, mka Anahatana iapasana sio wason oatarimamo tewa mtinte renesi sio poe kota Sodom.” ");
INSERT INTO nxl_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Anahatana mka iapasana omi kota Korasim, runa omi kota Betsaida! Sinana sima-simana waron Au unare pan omi, Au unare pan kota Tirus runa kota Sidon mo, sio pan kota ua rai oarihoni no rosau potuina reini nea. Mka oausahu api mananokoa, tea mo oatamisi hunu ruao noso rosau waron ounare rei. ");
INSERT INTO nxl_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ne tau orase wani Anahatana iapasana mansia pusiki mo, mka iapasana omi Korasim na Betsaida renesi sio pan kota Tirus runa kota Sidon. Tea mo, omi onoo Au una sima-simana panesi ne penemo oarihoni mo rosau sirinia. ");
INSERT INTO nxl_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Omi wani oruemo pan kota Kapernaum, omi mo mka Anahatana iapusaamo roe noiyaha tewa. Mka Anahatana ipesimo poe usa mainae wan hainau arihoni Anahatana. ");
INSERT INTO nxl_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Oyo Yesus ianamana osi ne mampusua honu. Iahata, “Sani ia isa iatinu tau mo maunauna, areimo noo sani iatinu tau we maunauna. Ne sani ia isa iatarimamo tewa, arei iae noo sani iatarima Au tewa oi. Sani iatarima Au tewa areimo, iatarima Anahatana wain iratiku rei tewa oi.” ");
INSERT INTO nxl_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yesus ne mampusua hutu itu oeu osima ata Anahatana nanie irime ne mansiau nea oyo onunso. Onunso anoo mirika. Oasau osi Yesus oahata, “Upu, ami ahete Ano nanam na anei sakahatena. Taa ahete nanam, oyo sakahatena rai rapusu rei sirinia. Sakahatena rai iae ratinu tau ami oi.” ");
INSERT INTO nxl_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesus iahata, “E-e. Unoo ia aia sakahatene remnahui on roe nante nooi sani isoe erehehi rei tea!” ");
INSERT INTO nxl_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Urui kawasa osimo nea na oheta tau tekena runa atoria. Urui kawasa osimo na onesi re nisa, ia aia sakahatene. Mka sae isa remunamo tewa. ");
INSERT INTO nxl_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ne pene anomo mirika tau sakahatena rapusu mo anamanaya. Ne kahurae anomo mirika tau Anahatana inusu nanamo roe noiyaha nea. ");
INSERT INTO nxl_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Anahatana Ne Inaha iuna Yesus anoi mirike, reiso iasau osi Anahatana iahata, “Ama, uainaa runaya. Ano mo, Upu. Arime noiyaha runa mai tuniai reini. Ano auhun maunauna arihoni sio wason oata kani oanei panesi. Ano atuhetere osi sio wason oparisaa tau me maunauna nooso sani tumata ikina. Ama. Auna san rei pusu ruam me maue.” ");
INSERT INTO nxl_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yesus iainaa na Anahatana oyo iahata, “Amaku Anahatana iatuheteku na irui kawasa osiku na Au una taneiu waron iruire osiku. Hasae Amaku sahoro ianei Au mo, Au sia. Hasae Au na sio wason uatuheteso oanei Amaku Anahatana ne hali sapan.” ");
INSERT INTO nxl_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pusi oyo, Yesus iuni ianamana runa ne mampusua ruao man. Iahata, “Anahatana irui iake nea osi omi wani onoo sae man waron Au unare rei. ");
INSERT INTO nxl_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Uasau osimo. Sio mamsima runa Anahatana ne maunauna wason naone runa sio aiau no maue nanie onoo sae waron Au unare rei, ne onoo tewa. No maue tau nanie oatinu sae waron omi oatinure rei, ne oatinure tewa.” ");
INSERT INTO nxl_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Taue isa, ia matuhete Musa ne maunauna isa nanie irea Yesus. Reiso ihitio nanie iasei. Iahata, “Upu matuhetene, kahurae au una sae na uamahaiku ukata Anahatana rotu-tu ria supan?” ");
INSERT INTO nxl_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesus iuni iasei honu iahata, “Musa ikanu sapan tau ne maunauna? Anoo sae?” ");
INSERT INTO nxl_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ia rei iahata, “Anomo runa mo Upu Anahatana mo, runa anomo pusire, mo inaha pusire, anomo runai pusu mo atata, runa anomo rapeka nnai sui osa. Anomo runa ia sia man nooi sani anomo runa ruamo.” ");
INSERT INTO nxl_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesus iahata, “Wani ano asaui rei mo manisate. Reiso eu na una san rei, na mka amahaia akata Anahatana rotu-tu ria supan akata Anahatana.” ");
INSERT INTO nxl_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ne ia rei nanie inete ruai. Reiso iasei tau Yesus honu. Iahata, “We neta tau ia seia?” ");
INSERT INTO nxl_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Oyo Yesus iruni matieue isa. Iahata, “Taue isa ia isa mato ikaisunu on roe Yerusalem nanie ieui poe kota Yeriko. Wain ieu, sira tau sio kahatena umau ohitai. Onana ne papite na ne apia. Ohitai rotu-tu sina imatai. Oyo oeu oarihoniki. ");
INSERT INTO nxl_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ia imam isa ikaisunu on roe Yerusalem pusu arena rei oi. Inoo ia rei waipo wasiparai poe arena, ne ieui inikui pusu arena nusue sui ria hae. ");
INSERT INTO nxl_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ita ia Yahudi isa arihoni ipane Lewi wani ouna imam iniku pusu arena rei. Inoo ia rei, ieu inikui pusu arena nusue on ria hae oi. ");
INSERT INTO nxl_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ne ia isa on pan otoe Samaria wain ieu. Ieu iniku pusu arena wani sinasi rei. Taa inoo ia waipo wasiparai rei, anoi runai. ");
INSERT INTO nxl_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Oyo ieu ihaineke ia rei, oyo isohu seka tau ia rei ne apata tau tihu anggur na wekatisie. Oyo iopa apata rai tau nipa sinte samatoro iapusaai roe ruai ne keledai. Oyo iroriki noi naniake isa poe numa seha-seha. Oyo iseha naniake isa, oyo isakai. ");
INSERT INTO nxl_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nene hanu roe san rei, oyo isenu naniake rei hunonie tau ai totua ina ua. Oyo iasau osi ia numa seha-seha rei upue iahata, ‘Saka anoo-noo nnai. Sani hunonie relai tewa mo, mka ununi samatoro usenu nesia osia.’ ");
INSERT INTO nxl_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Pusu ano mo, arihoni sio tonu rei, ia seia sahoro ia wain sio kahatena ohitai rei ne neta?” ");
INSERT INTO nxl_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ia matuhete Musa ne maunauna rei iahata, “Ia wain anoi runai, oyo iakahaiki rei.” Yesus iasau osiki iahata, “Munata san rei mo, aeu na auna san ia oi.” ");
INSERT INTO nxl_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesus na ne mampusua ohitio oeuso honu, nanie oeuso pan kota Yerusalem. Oyo ohokaso pan niane isa. Pan niane rei ia pina isa wain nanai Marta iapusaaso poe ne numa. ");
INSERT INTO nxl_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ia pina rei mo, wanin isa wain nanai Maria. Maria mo, iru-ruei poe Yesus ain atua iatinu ne anamanaya. ");
INSERT INTO nxl_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ne Marta mo, wain patapariki inana muaina osi Yesus sio. Reiso, iatinu Yesus ne anamanaya tewa. Oyo ieui ihaineke Yesus iahata, “Upu, masi anoo ee! Waniku itapi au ruaku unana pusire. Oo ia mo, iru-ruei man. Aisosiki na inana iakahaiku.” ");
INSERT INTO nxl_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ne Yesus iasau osiki iahata, “Marta, Marta. Pataparia anom reuponu runa sae man. ");
INSERT INTO nxl_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ne hasae osa man sahoro ininai iake. Maria inini sae wani iake mainae, reiso pene ia isa isopoi.” ");
INSERT INTO nxl_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Taue isa Yesus wain iainisi pan otoe isa. Taa iainisi pusi, oyo ne mampusue isa iasau osiki iahata, “Upu, atuhetema rerihoni sapani na ami ainisi tau Anahatana noo sani Yohanis iatuhete ne mampusua.” ");
INSERT INTO nxl_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Oyo Yesus iahata, “Sani nanie oainisi, areimo oainisi san rei: Ama. Ami ainisi na mansia pusiki oamuiraya. Ainisi na arime sio mai tuniai reini pusiki. ");
INSERT INTO nxl_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Onon ranie arui ma muaina na akarihuru amahai. ");
INSERT INTO nxl_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Siru heu ma isanaya. Tea mo, ami iae, anoma rasaa tewa tau sio wason ouna isanae tanuma rei. Anetema na apalalosa tewa.” ");
INSERT INTO nxl_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Oyo Yesus nanie iatuheteso ata kahurae oainisi rotu-tu Anahatana irui sae wan oainisiki rei. Reiso iahata, “Sani ia isa arihoni omi reini ieui noi ne neta ne numa tau saa monon tihu, oyo iasau osiki iahata, ‘We neta! Samaku muaine mkane sini. Mka ukatire. ");
INSERT INTO nxl_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Tea mo, we neta isa wain ieu hainau mato ihokai. Samatoro we muaine isa tewa na upanai.’ ");
INSERT INTO nxl_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Oyo me neta rei mka isana on pan numanoe iahata, ‘Pene akaremaku. Ukatunepa mitanunue nea. We hehuka pusima wani anekema nea. Upeneku uhanu usamaya tau muaine.’ ");
INSERT INTO nxl_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Uasau osimo! Masike ia reimo ipenei ihanui na isamai tau muaine noso ne neta tanui, mka ihanui isamai tau muaine noso iainisi tentene sui osa. Iaumaa tewa. Mka isamai tau muaina waron ininare. ");
INSERT INTO nxl_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Reiso uasau osimo. Oainisi sae wan oninai tau Anahatana. Mka iruiki. Onina sui osa sae wan oninai. Mka Anahatana iruiki. Oaka-kapeti mitanunue. Mka Anahatana ihukai. ");
INSERT INTO nxl_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tea mo, ia seia man wain iainisi sae isa onone ranie, mka Anahatana irui sae wani iainisiki rei. Ia seia wain inina sae isa pusi anoi mo, mka isupui. Ia seia wain iarihon iakapeti mitanunue tewa mo, mka Anahatana ihukai osiki. ");
INSERT INTO nxl_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Omi wan ouna mansia mainae nea. Sani anam hanaie iainisi ikae, mka orui tekene minne si? Tewa tea! ");
INSERT INTO nxl_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Te sani iainisi mantoune, ne orui atorie osiki? Tewa tea! ");
INSERT INTO nxl_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mo haliu kahatena ne oanei sae wan iake. Oanei sae wan iake na oruiki osi mo hehuka. Amam wain roe noiyaha mka irui sae wan iake oi. Erenesi honu, mka irui ne Inaha osi sio wason oainisi arihoniki rei.” ");
INSERT INTO nxl_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Taue isa Yesus inei sakahatene arihoni ia isa. Sakahatene rei reunai iakumoui. Taa sakahatene rei erehokai arihoniki, oyo ia mouke rei iana-namanai. Reiso sio panesi wason onoo rei osira hunu ruao. ");
INSERT INTO nxl_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ne sio umau oasau oahata, “Ia mo, inei sakahatene tau Beelsebul, ia aia sakahatene, ne kawasa.” ");
INSERT INTO nxl_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Sio umau honu oaisosiki iuna kakinate isa wani retuhete osiso ata Yesus mo, Anahatana iratiki. Oaisosiki iuna sima-simane reini mo, nanie oreai man. ");
INSERT INTO nxl_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ne Yesus ianei anoo. Reiso iasau iahata, “Munata sio niane owena-wenaso, areimo niane rei huie nea. Munata ipane isa rewena-wenai, areimo ipane rei tihoniki nea. ");
INSERT INTO nxl_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Munata ia aia sakahatene na ne sakahatena iae owena-wenaso mo, mka ia aia sakahatene ne kawasa tanso tewa nea. Uasau san rei tau omi oahata au upake Beelsebul ne kawasa tau unei sakahatene. ");
INSERT INTO nxl_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Reiso sani au upake Beelsebul ne kawasa tau unei sakahatene oo, omi mo mampusua opake ia seia ne kawasa tau onei sakahatena? Opake Beelsebul ne kawasa? Areimo, titue tewa tea! Reiso pene oahata Au upake Beelsebul ne kawasa tau unei sakahatene. Reiso sio ruao oatuhete ata omi osana. ");
INSERT INTO nxl_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ne sani Au mo, unei sakahatene runa Anahatana ne kawasa, areimo, uatuhete ata Anahatana mo, nanie irime ne mansiau nea.” ");
INSERT INTO nxl_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Oyo Yesus nanie iatuhete ata ia ne kawasa inei sakahatena noso ia mo, ne kawasa renesi sakahatena. Reiso iahata, “Sani ia isa wain iamkona isaka ruai ne numa runa ne henua, niuna, atiena, tunua mo, mka sio kimanakana onusu okimanaka kua ne apia tewa. ");
INSERT INTO nxl_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ne sani ia isa wain iamkona inesiki honu ihoka, oyo ia rei ikua tewa. Reiso ia wain iamkona rei mka ikanihooi. Oyo inana pusi ne henua, niuna, atiena, tunua waron iaunutu anoi tanre rei. Oyo ieu isama-sama apia waron inanare rei osi sio tamena. Arei iae noo sani au oi. Au mo, unesi ia aia sakahatene nea, reiso we kawasa tau unei sakahatena. ");
INSERT INTO nxl_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ia seia ipusuku tewa, areimo inesiku. Ia seia wain iaunau mansiau na opusuku tewa, areimo iunaso owena-wenaso. ");
INSERT INTO nxl_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Taa sakahatene erehokai arihoni ia isa, mka ereeu erehori otoa huia renina naniae. Ne resupu naniae tewa, reiso reasau pan anoe. Reahata, ‘Mka ununiku poe naniaku wani ueu uarihoniki poe ia mansia rei na urueku poe rei honu.’ ");
INSERT INTO nxl_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Oyo erenuniki poe naniae rei. Hoka poe, taa erenoo naniae poe ia mansia rei nooi sani numa anoe wani iautotui ne. Renapa-napa ia isa na iruei tanui. ");
INSERT INTO nxl_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Oyo sakahatene rei ereeu reoi sakahate tamena itu waron kahatena nai osa ranesi ia rei oi. Oyo ranususo pan ia rei, oyo rarueso pan rei rotu-tu ramasuniki. Reiso ia rei isupu masanau ranesi waron mataanoe rei honu.” ");
INSERT INTO nxl_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Taa Yesus iatuheteso, oyo sira tau ia pina isa arihoni sio panesi rei iakapona. Iahata, “Anahatana mka irui iake osi inam wain isusua.” ");
INSERT INTO nxl_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ne Yesus iahata, “Sio wason Anahatana mka irui iake osi mo, sio wason oatinu tau Anahatana ne anamanaya na opusu sae waron oatinure rei.” ");
INSERT INTO nxl_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Yesus wain iaunau sio panesi. Oyo sio panesi honu ohoka. Oyo iasau osiso iahata, “Omi naene reini mo, omi kahatena. Oainisi na Au una kakinate, samatoro oparisaa ata Anahatana iratiku. Ne Au mo, mka una kakinate isa osimo tewa. Hasae kakinate wan Anahatana iunai osi ia mamsima runa ne maunauna wain nanai Yunus man.” ");
INSERT INTO nxl_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yesus wain ianamana rerihoni Yunus mo, Yunus iruei pan ika onate tiae anoe onona tonu oyo Anahatana iuna kakinate. Kakinate rei mo, Anahatana iuna ika onate rei reumuta heui reiso noo sani iamahaiki honu. Reiso Yesus iasau ata, “Sae wani Anahatana iunai osi Yunus mo, retuhete osi sio pan kota Niniwe ata Anahatana sahoro iaisosiki. Au Tumata Reini mo, Anahatana Ihitiku, mka una kakinate osi sio naene reini ata Anahatana iaisosiku. ");
INSERT INTO nxl_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Naone, ia ratu Seba ihokai on pan nia hainau tau nanie iatinu ia aia Salomo ne anamanaya. Tea mo, Salomo ianei sae waron iaka runa sae waron iaka tewa. Ne muie reini mo, ia isa wain. Ia mo, ia mainae inesi Salomo, ne omi oatinu tanui tewa. Reiso tau orase wan Anahatana iapasana mansia pusiki wason oamahaiso naene reini mo, ia ratu Seba mka iapasanamo. ");
INSERT INTO nxl_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tau orase wani Anahatana iapasana mansia pusiki mai tuniai mo, mka sio Niniwe ohitio oapasana omi wani oamahaimo naene reini. Mka sio pan Niniwe oamanarumo. Arei ereeu san rei tau sio pan kota Niniwe oarihoni no rosau. Yunus iaunauso oyo oarihonre. Muie reini mo, ia isa wain ia mainae inesi Yunus ikatamo. Ne omi penemo oarihoni mo rosau na oatinu tanui.” ");
INSERT INTO nxl_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesus iaunau sio panesi. Iahata, “Ita inai kamane, oyo iauhuniki te isoui tau parten mo, tewa tea! Ne mka inai kamane rei, oyo iaunutui roe kamane aie na sio wason onusu pan numa anoe onoo mosa nene rinane. ");
INSERT INTO nxl_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matam usena iae, noo sani kamane wan eresita me numa anoe. Sani matam usena ranoo iake, noo sani ano manahane. Ne sani matam usena ranoo iake tewa, noo sani ano apumonoa. ");
INSERT INTO nxl_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Reiso oainati na manahane wani pani anom pene repumonoi. ");
INSERT INTO nxl_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Reiso, sani Anahatana iuna manahane pani anom rotu-tu anom manahane pusiki, sae isa repumonoi tewa, areimo manahane ia-ia. Noo sani kamane resitaya.” ");
INSERT INTO nxl_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus ianamana osi sio panesi, oyo ia onate arihoni akama Yahudi isa ioiki na ieui poe iaiki poe ne numa. Reiso Yesus ieui poe iaiki poe ne numa. ");
INSERT INTO nxl_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ia onate rei inoo san rei, isira tau Yesus nanie iaiki ne isohu hanai tewa. ");
INSERT INTO nxl_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ne Yesus iasau osiki iahata, “Omi onata arihoni akama Yahudi mo, ouna sae isa wani iake na mansia onoo man ne pan anomo mo, taua runa kahatena. Taimo onata. Noo sani osohu kalasi na pirune nene muie man. Ne osohu nene anoa tewa. ");
INSERT INTO nxl_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Omi rirunena! Ita ianei ata Anahatana wain ihaye tau tinairi mo, ihaye tau anori oi. ");
INSERT INTO nxl_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kahurae oakahai sio mosokinia. Oakahaiso runa anomo kaia. Ouna san rei, samatoro mka anomo pusire iaka. Anahatana inoomo iaka. ");
INSERT INTO nxl_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Siraka tau omi onata arihoni akama Yahudi! Tea mo, oapahia mo nisi, osama mo atuhu pusire tau pahakian hutusa oyo orui pahakian osa osi Anahatana. Masike atuhu waron iki-kina. Ne onini mansia na anomo runa Anahatana tewa. Kahurae ouna rai pusire. ");
INSERT INTO nxl_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Siraka tau omi onata arihoni akama Yahudi! Tea mo, omi mo, Omi mo, mo suka oru-ruemo tau katerau waron sio mainaya orueso tanre noi ita Yahudiu re numa mananouna Onina na sio oatapeamo sui sio manahenia naniao. ");
INSERT INTO nxl_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Siraka tanumo! Tea mo, omi mo, noomo mai mui iake. Aikee noomo sani nihane wani sio oakakinai tewa rei. Reiso mai mui nooi iake. Sio oheta roe hahae ne oanei tewa ata nimoe wapo anoe.” ");
INSERT INTO nxl_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ia matuhete Musa ne maunauna isa iasau osi Yesus iahata, “Matuhetene. Ano asau san rei osi sio onata arihon akama Yahudi, areimo sani oasau tau ami oi rei tea!” ");
INSERT INTO nxl_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ne Yesus iahata, “Siraka tau omi matuhete Musa ne maunauna oi. Tea mo, oaunau mansiau tau maunauna waron mtinta na ouna pusure, ne omi ruamo opusu maunauna rai tewa. Oakahaiso na ouna pusu maunauna rai mo, mkane man tewa oi. ");
INSERT INTO nxl_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Siraka tanumo! Tea mo, onana nihana osi Anahatana ne sio mamsima runa ne maunauna. Moa upu moa momou sahoro ohunuso nea rei. ");
INSERT INTO nxl_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ouna san rei reiso oatuhete ata omi oamanaku ata moa upu moa momou osana tewa. Moa upu moa momou ohunso, omi mo, sanan, reiso omi ouna nihana osiso. ");
INSERT INTO nxl_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Reiso, Anahatana wain ianei sae waron iaka runa sae waron iaka tewa iahata, ‘Mka uaisosi sio mamsima runa we maunauna runa we maisosia umau osi omi Yahudiu. Ne mka ohunu sio umau, sio umau mo, mka ouna sinsaraso.’ ");
INSERT INTO nxl_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Reiso omi naene reini sahoro osana tau moa upu moa momou ohunu Anahatana ne sio mamsima runa ne maunauna oni Anahatana ihaye tau tuniai reini. ");
INSERT INTO nxl_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Oni mataanoe tau Kain ihunu wanin Habel. Ereeu rotu-tu mai tau muie ohunu ia imam wain nanai Sakaria. Ohunui pan hatu waron oranere noore sani anau na Anahatana ne numa mainisie kua tihue. ");
INSERT INTO nxl_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Siraka tau omi matuhete Musa ne maunauna. Tea mo, osima runa Anahatana ne maunauna tewa. Reiso mansiau oaneire tewa. Noo sani onana numa nene kunsi. Omi ruamo onusu numa tewa na oneteso na pene onusu oi.” ");
INSERT INTO nxl_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Oyo Yesus ieui arihon rei. Ieui arihon rei ne sio onata arihon akama Yahudi na sio matuhete Musa ne maunauna ohiti nisa runai nea. Oasei-sei tanui panesi. ");
INSERT INTO nxl_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Oreai onapa rotu-tu iasau sae isa wan resana na oapasanai. ");
INSERT INTO nxl_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Sio onata arihoni akama Yahudiu wason orea Yesus, oo sio mansia hutue ohoka oamanouso nanie oatinu Yesus iaunau rotu-tu oo oese umau. Oyo Yesus iasau osi ne mampusua. Iahata, “Ainati! Pene mo atata sani sio onata arihon akama Yahudi. Tea mo, sio makarotana wason oasau ata ruao sahoro sio manisata. Aikee sio mo, manisata tewa oi. Sio mo, sani mnehue oi. Mnehue mkane mani oo, reuna poroti resaa mainae. ");
INSERT INTO nxl_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Sae mani wani reuhuniki, mka erehokai sirinia. Sae mani wani oauhuniki, mka sio oaneiki sirinia. ");
INSERT INTO nxl_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Sae wani oasaui tau pumono, mka oatinui tau ranie. Sae wani oarahuhui sui sio mansiau tinao ukuna pan kakaranae mo, mka ohoue osima nnai osi mansia hutue on roe numa hahaya.” ");
INSERT INTO nxl_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesus wain iaunau ne mampusua. Iahata, “Oatinu, we netau. Pene okaitau mansiau wason nanie ohunumo. Sio mo, ohunu me patane man. Oyo mka ouna sae isa tanumo tewa nea. ");
INSERT INTO nxl_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ne nanie uasau osimo rerihoni ia seia sahoro kahurae okaitaui. Okaitau Anahatana. Ia sahoro ne kawasa ihunuta. Na Ia ne kawasa ipesita poe usa mainae wan hainau arihoniki. Reiso titue, kahurae okaitau Ia. ");
INSERT INTO nxl_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Oahen kinanahana hata nima tau kepen inata ua man, tea! Ne Anahatana anoi repeka nnare. ");
INSERT INTO nxl_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Masi oatinu. Omi san rei oi. Anahatana ianei mo huau wanaya osa-osa rotu-tu pusire waroni roe unumo. Reiso pene okaitau. Anahatana anoi runa omi renesi kinanahana. ");
INSERT INTO nxl_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Mai na uasau osimo. Ia wain ikaitau tewa iamanaku osi sio umau ata ia mo, au we mampusue. Au, Tumata Reini mo, Anahatana Ihitiku iae mka uamanaku osi Anahatana runa ne maisosia on roe noiyaha ata ia reimo, Au we mampusue oi. ");
INSERT INTO nxl_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ne sani ia seia iasau osi sio umau ata ia mo, ipusu au tewa, areimo mka uasau osi Anahatana ne maisosia roe noiyaha ata ia reimo, Au we mampusue tewa oi. ");
INSERT INTO nxl_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Sani ia seia man iasau sae isa wani kahatene rerihoni Au, Tumata Reini mo, Anahatana ihitiku mo, mka Anahatana isiru heu ne rosa rei. Ne sani munata ia seia irati sohi Anahatana Ne Inaha, areimo Anahatana mka isiru heu ne rosa rei tewa. ");
INSERT INTO nxl_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Sani sio oapisara nnamo poe ita Yahudiu re numa mananoune te noi sio ona kupaniau mo, pene anomo rauponu sapani na oanamana nete ruamo. ");
INSERT INTO nxl_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tea mo, mka Anahatana Ne Inaha iatuhete sae wani nanie oasaui rei.” ");
INSERT INTO nxl_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yesus waimo iatuhete mansia hutue. Oyo ia isa arihoni sio hutue rei iasau osi Yesus iahata, “Ano matuhetene, aisosi kakaku isama ma mansia mainaya no rusun runa numa hutae osi uama.” ");
INSERT INTO nxl_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesus iahata, “Ia isa ihiti Au tewa tau ia wain saka iarinii parakanau, tea!” ");
INSERT INTO nxl_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Oyo Yesus iasau osi sio hutue rei. Iahata, “Oainati! Pene taimo onata na onina mansiau no apia, rusun osi ruamo. Tea mo, masike re rusun panesi, apia panesi, ne ianei tewa mka iamahaita sapan.” ");
INSERT INTO nxl_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Oyo Yesus iruni matieue osi sio hutue rei. Iahata, “Ia hanai kupan kaya isa. Ia hanaie rei mo, ne atuhu isia panesi. ");
INSERT INTO nxl_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Iasau pan anoi iahata, ‘Kani nanie una sae ano? Nanie uaunutu we atuhu isia raini sui supa? We naniake tau uaunuture tewa.’ ");
INSERT INTO nxl_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Iasau pan anoi honu iahata, ‘Uaneiki nea! Mka ukohu we kokau waron usaka uaiinu we atuhu isia rei na utukai tau kokau waron mainaya na uaunutu we gandum runa we api tamena umau oi. ");
INSERT INTO nxl_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pusi oyo mka uasau mai ruaku, uahata, “Uamanou we muaina na apia panesi nea. Mka uai rotu-tu musum inasa rai. Reiso muie reini uaranahaku man. Uai uninu man. We sanan man.”’ ");
INSERT INTO nxl_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ne Anahatana iasau osiki. Iahata, ‘Ee, ano rirunene! Tau onone repan, mka au uni me inaha. Oyo mka me numa hutae wani amanoure rotu reini mka osi sio tamena, tea!’ ");
INSERT INTO nxl_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Arei mo, mka reyari tau sio wason onina na no kupan osi ruao mai tuniai reini, ne opusu Anahatana ne maunauna tewa. Oanori runa Anahatana tewa.” ");
INSERT INTO nxl_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesus asau osi ne mampusua. Iahata, “Reiso nanie uasau osimo. Pene anomo rauponu runa muaine onone ranie te api sae waron nanie opakere tau oamahaimo mai tuniai reini. ");
INSERT INTO nxl_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tea mo, iamahaita mo, arihoni muaine na apia man tewa. ");
INSERT INTO nxl_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Onoo tau manua tewa. Rarahu tewa. Rapahia nisi tewa. Ramanou muaine tewa. Ne Anahatana inoo runare sirinia. Omi mo, onesi manua rai oi. ");
INSERT INTO nxl_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Masike ia isa anoi reuponu, mka iakapena orase osa-sa tau iamahaiki mo, tewa oi. ");
INSERT INTO nxl_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Oakapena orase osa-sa tewa oi, reiso pene anomo rauponu runa muaina na apia. ");
INSERT INTO nxl_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Onoo tau kupako waron raruhu inamatane sui wesie tewa? Rapakarian tewa. Rarae pola tewa na rauna nene apia osi ruao tewa. Ne kupako rai marainia nai osa ranesi ia aia Salomo ne apia. Aikee aia Salomo ne apia marainia mainae. ");
INSERT INTO nxl_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Anahatana iuna monota waron raruhu inamatane sui wesie marainia. Aikee reruhu potuina tewa. Sira tau rahata rei ramataso, hanroe oakanupure. Reiso mka Anahatana irui apia osi omi na opakere. Oparisaa tau Anahatana ia-ia tewa tahae? ");
INSERT INTO nxl_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Reiso pene hasae oarinii muaine na apia. Pene anomo rauponu runa rai. ");
INSERT INTO nxl_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Sio wason oationa Anahatana tewa mai tuniai mo, onina rai sui osa. Ne Anahatana ianei omi kahurae oai, kahurae mo apia. ");
INSERT INTO nxl_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ne onina na Anahatana irime tanumo ia-ia oyo mka irui muaine na apia pusire osimo. ");
INSERT INTO nxl_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Omi sahoro we mampusua. Omi mo, sani rompau waroni panesi tewa. Moa Ama anoi kaie na okatai irime ne mansiau. Reiso pene okaitau. ");
INSERT INTO nxl_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Oahen pusi mo sae man, oyo orui nene ai totua osi sio mosokinia. Sani ouna san rei, noo sani ouna tasi nanaene osi ruamo wan mka rekahate tewa. Areimo oamanou mo hutae roe noiyaha. Hutaya rai mo, mka pusi-pusi tewa. Sio kimanakana okimanaka kuare tewa. Tanana raaire tewa. ");
INSERT INTO nxl_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tea mo, sui supan me hutae warumo, areimo anomo pusire iae warumo rei oi.” ");
INSERT INTO nxl_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yesus ianamana osi ne mampusua. Iahata, “Osaka-saka na oanori osi Anahatana onone ranie sani ia wain isaka ne kamana na pene ramataso. ");
INSERT INTO nxl_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Omi mo, kahurae noomo sani sio manorina wason orue onapa no upu rotu-tu inuni arihoni maise mausahae. Sani upui rei inuniki, oyo iakapeti mitanunue mo, ne manorina wasomo orue osaka na oheka mitanunue osiki nea. ");
INSERT INTO nxl_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mka noa upu inuniki isupuso wason omaranae osaka-saka, reiso osupu iake. Atinu mai ia-ia nanie uasau osimo. Noa upu rei mka iausahu papi manorine, oyo iaisosi ne manorina rei orue oaiso noi numa anoe. Oyo mka ia ruai iaunutu muaine osi ne manorina rei na oaiso. ");
INSERT INTO nxl_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Sani noa upu inuni na inooso omakawanaso, onapai tau saa monon tihue te rotu-tu tau kinoke, mka osupu iake. ");
INSERT INTO nxl_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Anomo rapeka! Ia numa upue ianei tewa ata sio kimanakana mka ohoka okimanaka tau pumono te tau ranie. Sani ianei mo, mka ineke tewa na isaka ne numa na sio kimanakana onusu okimanaka tewa. ");
INSERT INTO nxl_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Reiso kahurae omi iae osaka-saka onone ranie. Tea mo, Au Tumata Reini mo, Anahatana Ihitiku, mka sira tau uhokaku honu tau orase wani oaneiki tewa.” ");
INSERT INTO nxl_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Oyo Petrus iasei, iahata, “Upu, wamo aruni matieue reimo, aruni osi ami man te osi mansia pusiki?” ");
INSERT INTO nxl_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yesus iahata, “Ia wain nanie iuna ia mamsaka sio manorina mo, kahurae upui iparisaa tanui iake na ianei sae waron iaka runa sae waron iaka tewa. Tea mo, ia manorine wan san rei, upui mka ihitiki na isaka isama muaine osi sio manorina tamena rei. ");
INSERT INTO nxl_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Sani ia mamsaka sio manorina rei isakaso ia-ia, mka sani upui inuni, ia mamsaka isupu iake. ");
INSERT INTO nxl_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Atinu mai ia-ia nanie uasau osimo. Mka upui iaisosiki na isaka ne numa hutae pusiki. ");
INSERT INTO nxl_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ne sani ia manorine rei iasau pan anoi iahata, ‘Upuku ieui potuina nea. Inuniki tewasi.’ Oyo ihita sio manori tamena rei. Ihita sio hanaia runa sio pinau pusiso. Oyo iai, ininu rotu-tu imukei. ");
INSERT INTO nxl_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Sira tau upui ihokai tau onone wani ianeiki tewa. Oyo upui rei iapasanai mtinte na ipesiki poe sio wason oparisaa tewa naniao. ");
INSERT INTO nxl_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Sani ia manorine ianei upui ne maue ne iuna upui ne maue rei tewa, areimo mka upui rei ihita hunui. ");
INSERT INTO nxl_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ne sani ia manorine rei ianei upui ne maue tewa, oyo iuna sae isa eresana rotu-tu kahurae upui iapasanai, areimo mka upui ihitai panesi tewa. Tea mo, ia seia isupu panesi arihoni Anahatana, mka Anahatana iainisi panesi arihoniki oi.” ");
INSERT INTO nxl_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesus wain iaunau ne mampusua. Iahata, “Uhokaku mai tuniai mo, noo sani usa. Nene iake mo, usa rei reai nea. ");
INSERT INTO nxl_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ne Au mo, kahurae sinsaraku rotu-tu umataku naone ee. Reiso anoku mtinte mainae, on pusire rayari tewasi. ");
INSERT INTO nxl_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Pene oarinii ata uhokaku mai tuniai reini mo, nanie una mansiau ouna iake runa umau, areimo tewa! Ne uhokaku na una mansiau oatana na umau. ");
INSERT INTO nxl_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tea mo, on naene reini mo, mka sio nima tau numa matae osa oatana runa umau noso Au. Mka osamaso tau ua. Oyo sio tonu oatana runa sio ua noso Au. ");
INSERT INTO nxl_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mka oatana runa umau. Ia iki hanaie isa iuna nisa na amai. Ia iki pina isa iuna nisa runa inai. Ia pina msahane iuna nisa runa inai tanaite. Inai tanaite iuna nisa runa ia pina msahane noso Au.” ");
INSERT INTO nxl_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesus ianamana osi sio hutue. Iahata, “Sani onoo yahu hae rani mata msohue, oyo oahata, ‘Wapan nanie uane.’ Oyo uane rei sirinia. ");
INSERT INTO nxl_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Sani ihute ereuhona on nau haha oyo omi oahata, ‘Mka ranie titie.’ Oyo ranie titie rei sirinia. ");
INSERT INTO nxl_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","He omi makarotana! Omi oanei tewa! Omi oanei onoo ihute mai tuniai na onoe roe nante ata mka uane runa mka ranie titie. Ne oanei tewa sima-simana waron Au unai mai tuniai muie reini mo, rekakina sae. ");
INSERT INTO nxl_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Omi ruamo kahurae oarinii sae sahoro manisate, sae sahoro resana. ");
INSERT INTO nxl_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Sani ia isa nanie iroria poe sio mainaya na oapisara nnaya, ano mo, kahurae aeua anina ia rei na auna iake nnai naone. Auna iake nnai na pene iroria poe ia wain saka iarinii parakanau oyo mka iaisosi sio hana naua oaresia na onusua poe pui. ");
INSERT INTO nxl_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Uasau osia. Ano mo, mka ahokaya arihoni pui tewa rotu-tu asenu pusi me notiu pusire.” ");
INSERT INTO nxl_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tau Yesus wain iatuhete sio panesi, sio umau wason oatinu oyo osima osiki oahata, “Gubernur wain nanai Pilatus iaisosi sio ohunu sio pani otoe Galilea umau. Ohunuso pannuhu oakanupu makapanau osi Anahatana.” ");
INSERT INTO nxl_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Oyo Yesus iahata, “Pene omi ata kani sio hunu sio Galileau rei mo, noso no rosau panesi ranesi sio pusiso mai otoe Galilea. ");
INSERT INTO nxl_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Areimo titue tewa tea! Ne sani oarihoni mo rosau tewa mo, mka Anahatana iapasana pusimo na omatamo oi. ");
INSERT INTO nxl_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Te arei iae noo sani sio hutusa rahana wanu wason omataso tau numa wan ereroke-rokei pan Siloam rei watikohui reeseso. Pene omi ata kani sio mo, no rosau panesi ranesi sio tamena wason oamahaiso pan kota Yerusalem. ");
INSERT INTO nxl_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Areimo titue tewa tea! Ne sani oarihonimo rosau tewa mo, mka Anahatana iapasana pusimo na omatamo oi.” ");
INSERT INTO nxl_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Oyo Yesus iruni matieue isa na iatuheteso ata Anahatana mka iapasana sio wason oarihoni no rosau tewa. Iahata, “Ia isa ne nisi anggur. Pan ne nisi rei irahu ai ara isa. Taue isa ieui noi, nanie inina ai ara rei nene huae. Ne isupu huae isa man tewa oi. ");
INSERT INTO nxl_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Reiso iasau osi ia wain isaka ne nisi anggur rei. Iahata, ‘Masi anoo! Musum tonu nea ueuku mai unina ai ara reini nene huae. Ne usupu huae isa man tewa oi. Reiso mai na rana ai reini nea. Tea mo, renana pusi tapu minae ne reuhua tewa.’ ");
INSERT INTO nxl_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ne ia wain isaka nisi rei iahata, ‘Upu, rei ruae rotu-tu musum isa ee. Au mo, mka ueti tapune sui nusue. Mka uaunutu tapu minae poe nene aikune. ");
INSERT INTO nxl_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Puruae musum rennau huae, areimo mka uranai tewa. Ne sani musum rennau huae tewa honu, areimo mka uranai.’” ");
INSERT INTO nxl_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Taue isa tau ranie hatae wan sio Yahudiu oamuira Anahatana, Yesus iatuhete pan sio Yahudiu no numa mananoune isa. ");
INSERT INTO nxl_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ia pina isa waimo rei oi. Ia pina rei mo, sakahatene reunai ikupui rotu-tu musum hutusa rahana wanu nea. Ieu inoku rotu-tu ioo iakatopu iake tewa nea. ");
INSERT INTO nxl_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Taa Yesus inooi san rei, iahata, “Ano pina onate. Masi aeu mai uae. Usuisene me kupue rei nea!” ");
INSERT INTO nxl_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Oyo Yesus hanai tanui. Oyo ia pina rei, sira tau ioo iakatopui. Oyo iainaa runa Anahatana rei sirinia. ");
INSERT INTO nxl_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ia onate tau sio Yahudiu no numa mananoune anoi eresaa, tau Yesus isuisene sio kupua tau ranie hatae wani sio Yahudiu oamuira Anahatana. Reiso iasau osi sio pan rei, iahata, “Rania hata nome ipakarian nea, reiso sani onina na Yesus isuisenemo, areimo ohokamo pannuhu onona nome rai. Ne pene ohokamo tau onone wan iamuira Anahatana rei.” ");
INSERT INTO nxl_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ne Yesus iasau osi ia mainae rei. Iahata, “Ee, omi makarotana wason oahata ruamo manisata! Ohuka pusimo makapanau waron oapiarare tau ranie hatae wan ita Yahudiu iamuira Anahatana, oyo oeu ororire raninu, tea! ");
INSERT INTO nxl_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ia pina reini mo, makapana tewa. Ia mo, Abraham upui momoi. Ne ia aia sakahatene reunai ikupui rotu-tu musum hutusa rahana wanu nea reini. Reiso unei sakahatene arihoniki tau ranie hatae wan ita Yahudiu iamuira Anahatana mo, iake tea!” ");
INSERT INTO nxl_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesus iasau san rei, oyo sio wason onesiki rei oaumaa hunu ruao. Oaumaa noso Yesus iausau osiso ata onoo na ia pina rei tewa. Ne sio hutue rei mo, anoo mirika. Tea mo, no maue nanie onoo sima-simana waron Yesus iunare rei. ");
INSERT INTO nxl_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesus isuisene ia pina isa pusi, oyo iasei tau sio wason onoo. Iahata, “Sani Anahatana irime ne mansiau mo, nooi sapan? Nooi sani sae?” Oyo iruni matieue isa. ");
INSERT INTO nxl_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Iahata, “Anahatana irime ne mansiau mo, nooi sani kanapua kanie. Kanapua kanie rei mo, ia isa irahui pan ne nisi. Oyo ereruhui rotu-tu reuna ai mainae. Mainae reiso manua rarihu ratasohoso rauna nene nanone sui nene sanaya.” ");
INSERT INTO nxl_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Oyo Yesus iasei honu. Iahata, “Sani Anahatana irime ne mansiau mo, nooi sani sae? ");
INSERT INTO nxl_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Anahatana irime ne mansiau mo, nooi sani ia pina wain nanie iuna poroti. Inehu mnehue mkane runa tarigu panesi. Oyo mnehue mkane rei ereuna tarigu panesi rei eresaa rotu-tu mainae nai osa.” ");
INSERT INTO nxl_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesus iruni rerihoni Anahatana irime ne mansiau pusi, oyo ihitio ieu na roe Yerusalem. Ieu siniki sui niana-niana pan rei nanie iatuheteso. ");
INSERT INTO nxl_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Oyo ia isa iasei tau Yesus. Iahata, “Upu, sio wason mka Anahatana iapuheuso na pene iapasanaso mo, sio mkana mani?” ");
INSERT INTO nxl_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Yesus iasau osiki, iahata, “Anahatana ne mansiau wason irimeso, sio mkana man. Noo sani numa wan nene mitanunue kote-kote mani. Sio mkana man onusu pan numa anoe rei. Reiso, omi mo, kahurae oamkona na onusu pusu mitanunu kote-kote rei. Oatinu ia-ia. Sio panesi onina na onusu mitanunu kote-kote rei, ne onusu kua tewa. ");
INSERT INTO nxl_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ne sani numa upue ihanu na iraru mitanunue rei nea, mka oomo pan mui. Oomo pan mui oaka-akapeti mitanunue man na oasau ata, ‘Upu, huka mitanunue osima ee!’ Ne numa rei upue mka isana iahata, ‘Omi seiso? Uationamo tewa! Au iae uanei tewa ata omi on supa?’ ");
INSERT INTO nxl_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Oyo oahata, ‘Ano ationama tewa si? Ami reini mo, saka arue aima akataya rei! Ano iae saka atuhetema sui ma arenau oi rei.’ ");
INSERT INTO nxl_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ne numa upue rei mka iasau honu, iahata, ‘Uationamo tewa rei! Uanei tewa oi omi on supa! Omi mo, omi kahatena. Reiso, oeumo arihoniku nea reini!’ ");
INSERT INTO nxl_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Reiso sani Anahatana irime ne mansiau nea, omi mka onoo Abraham, Isak, Yakup, runa Anahatana ne sio mamsima runa ne maunauna umau honu wasuro okata Anahatana oi. Ne omi mo, orue pan mui. Mka sinsaramo. Reiso orani. Anomo rasaa tau omi oruemo pani mui. ");
INSERT INTO nxl_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mka sio mansiau wason sio Yahudiu tewa ohoka on supa mani mai tuniai reini. Ohokaso on pani rani mata msaie, on poe rani mata msohue. Ohokaso on ria nunte, on nau raka. Sio rei mka orue oai nasae okata Anahatana sani Anahatana irime ne mansiau. ");
INSERT INTO nxl_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Masi oatinu. Sio wason sio mainaya tewa, Anahatana mka iunaso sio mainaya. Ne sio wasoni sio mainaya, Anahatana mka iunaso sio ikina.” ");
INSERT INTO nxl_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sio onata arihoni akama Yahudi ohokaso noi Yesus oyo oasau oahata, “Upu, aeua arihoni reini nea. Tea mo, aia Herodes nanie ihunua!” ");
INSERT INTO nxl_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesus iasau osiso iahata, “Oeu na oasau osi Herodes wani ne hali kahatene sani asu manenene rei. Asau osiki ata unei sakahatena arihoni mansiau na usuisene mansiau rahata repan na hanroe ee. Mka poua rei samatoro we pakarian reini pusiki. ");
INSERT INTO nxl_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ne rahata repan, hanroe, poua rei, Au mo, kahurae ueu sui osa rotu uhokaku roe kota Yerusalem. Una san rei tau Anahatana ne sio mamsima runa ne maunauna mo, ohunuso sui nia tamena tewa. Ne ohunuso mo, roe kota Yerusalem. Reiso au iae, kahurae uhokaku roe rei oi. ");
INSERT INTO nxl_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Omi Yerusalem! Omi sahoro ohunu Anahatana ne sio mamsima runa ne maunauna. Omi sahoro orau sio wason Anahatana iaisosiso na oeuso noi tanumo tau hatu rotu-tu omataso tea! Au mo, unina arena sui osa na nanie uamanou pusimo na unetemo sani manue inae remanou nene anaya poe nene kihena nohua na renetere. Ne openemo. ");
INSERT INTO nxl_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Reiso Anahatana ihuka hanai arihoni pusimo nea. Ipenei tau isaka mo kota nea. Reiso oatinu ia-ia! Oni orase repan omi mo, mka onooku tewa nea rotu mka oasau ata, ‘Anahatana irui iake osi ia waini ihokai mai tuniai reini runa Anahatana ne kawasa.’” ");
INSERT INTO nxl_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Taue isa, pannuhu ranie hatae wan sio Yahudiu oamuira Anahatana, Yesus ieu iaiki noi ia mainae isa ne numa. Ia mainae rei mo, ia wain ia onate arihoni akama Yahudi isa. Sio onata wasoni noi rei oasu-asumata Yesus na otarukirai ia-ia. ");
INSERT INTO nxl_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Oyo sira tau ia isa waini ikupu posue ihoka iooi mai Yesus uai anoe. ");
INSERT INTO nxl_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesus iasei tau sio matuhete Musa ne maunauna runa sio onata arihon akama Yahudi. Iahata, “Sani isuisene sio kupua tau ranie hatae wan ita Yahudiu iamuira Anahatana mo, Musa ne maunauna rasopo te tewa?” ");
INSERT INTO nxl_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ne pusiso oamaturuso man. Reiso Yesus hanai tau ia waini ikupui rei, oyo isuisenei. Isuisenei oyo iaisosiki inuniki. ");
INSERT INTO nxl_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pusi, oyo iasei tau sio onata rei. Iahata, “Arihoni omi reini pusimo, sani mo hehuke isa te, koropou hatae isa remnahui poe parike anoe tau ranie hatae wan ita Yahudiu iamuira Anahatana mo, ohokai on sin te tewa?” ");
INSERT INTO nxl_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Atinu san rei, pusiso oamaturuso man. ");
INSERT INTO nxl_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesus iaiki noi ia mainae ne numa, inoo sio wasoni ohoka na oaiso rei mo, onina na orueso roe uae. Oyo iruni matieue isa osiso. Iahata, ");
INSERT INTO nxl_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Sani ia isa ioia na ahokaya tau karisaa mausahae mo, pene anina na aruea roe uae. Areimo, pene rotu-tu karisaa upue ioi ia isa waini ia mainae renesi ano oi. ");
INSERT INTO nxl_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Sani ia isa wain ia mainae renesi ihokai, mka ia karisaa upue ieu ikata ia rei noi tanua na iasau ata, ‘Pene anom resaa. Asuka na aruea pani muie kee! Tea mo, ia reini mka iruei mai rei.’ ");
INSERT INTO nxl_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ne, sani sio umau ooia apusu karisaa mo, eua nina na aru-rue hae muie nea. Na sani karisaa upue inooa mka iasau osia ata, ‘Kakaku, waniku. Mai na aruea mai uae reini nea.’ Areimo, iamuiraya mainae noi sio pusiso. ");
INSERT INTO nxl_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Areimo, tau ia sia man sahoro iuna ruai ia mainae, Anahatana mka iunai ia ikine. Ne ia sia man sahoro iuna ruai ia ikine, mka Anahatana ihitiki iuna ia mainae.” ");
INSERT INTO nxl_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pusi, oyo Yesus iasau osi karisaa upue. Iahata, “Sani aoi sio umau oai ranie te oai pumono okataya mo, pene aoi me netau. Pene aoi me kaka waniu. Pene aoi sio sui me numa nusue wasoni no kupan kaya man mo, pene. Areimo, tau kani mka ooia honu na aia poe sio no numa reiso asupu sae isa. ");
INSERT INTO nxl_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ne sani auna karisaa mo, aoi sio mosokinia. Aoi sio wasoni no patana katemaya tewa. Aoi sio wason oeu seu-seu. Aoi sio mata putia. ");
INSERT INTO nxl_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Sio reimo, mka ouni sae isa osia tewa. Tea mo, no sae isa tewa. Ne Anahatana sahoro mka iunre osia na irui iake osia. Mka iunre osia tau orase wani iuna sio wason oamanisa oamahaiso honu.” ");
INSERT INTO nxl_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesus waini irue iaiki noi ia mainae isa ne numa. Oyo ia isa iatinu Yesus ianamana rerihoni sio wason oamanisa oamahaiso honu. Iahata, “Anahatana irui iake osi ia wain mka iai nasae ikatai pannuhu irime ne mansiau.” ");
INSERT INTO nxl_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ne Yesus iruni matieue isa na iatuheteso ata Anahatana ioi sio panesi ouna ne mansiau, ne openeso. Iahata, “Ia isa iuna nasa onate. Oyo ioi sio panesi nai osa. ");
INSERT INTO nxl_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Haineke nanie oaiso, ia rei iaisosi ne manorine na ioi sio wasoni ioiso nea rei. Ioiso iasau ata, ‘Mai na rue roe nea. Tea mo, pusire waron nea.’ ");
INSERT INTO nxl_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ne sana osa-osa oasau ata ohoka iake tewa. Ia waini mataanoe iasau, ‘Pene anom resaa. Tea mo, mato uhane we tuamane mkane. Reiso kahurae ueu unooi ee.’ ");
INSERT INTO nxl_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ia isa honu iasau ata, ‘Pene anom resaa. Tea mo, mato uhane koropou hata nima. Reiso nanie ueu ureare ee.’ ");
INSERT INTO nxl_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ia isa honu iasau ata, ‘Pene anom resaa. Uhoka iake tewa. Tea mo, mato we hutupau pusi.’ ");
INSERT INTO nxl_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Pusi oyo, ia manorine rei inuniki poe numa. Oyo iruni pusire osi ia karisaa upue. Iatinu san rei, oyo anoi resaa nai osa. Oyo iaisosi ia manorine rei honu. Iahata, ‘Munata san rei mo, mai na aeua pusu arena onata runa arena kote-kote mai kota reini. Oyo rori sio mosokinia. Rori sio wasoni no patana katemaya tewa. Rori sio mata putia. Rori sio wason oeu seu-seu.’ ");
INSERT INTO nxl_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Oyo ia manorine rei iasau ata, ‘Upu, sae wani ano aisosiku runai reimo, unai nea. Ne noo nasae rei mo, wani huie panesi asi!’ ");
INSERT INTO nxl_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Oyo ia karisaa upue rei iasau ata, ‘Munata san rei, aeua hokaya arihon kota. Oyo eua pusu arena onata rotu hoka sui arena kote-kote na apamanu ia sia man. Apamanuso na oeu mai oakaponu we numa anoe wani huie asi reini.’ ");
INSERT INTO nxl_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Uasau osimo. Ia sia wain uoiki mataanoe rei nea, ne ihoka tewa mo, mka iai nasae rei tewa oi!” ");
INSERT INTO nxl_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Taue isa Yesus waini ieu ikata sio panesi. Oyo iuni iasau osiso iahata, ");
INSERT INTO nxl_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ia sia titue-tue nanie ipusu Au mo, kahurae anoi runa Au renesi inai na amai, sahai, ne hehuka, ne kakau waniu. Erenesi honu mo, kahurae anoi runa Au renesi ruai oi. Sani iuna san rei tewa mo, mka iuna Au we mampusue tewa. ");
INSERT INTO nxl_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ia sia wain nanie iuna we mampusue mo, kahurae inoo ruai sani imatai nea. Noo sani ia wain ihana ne hini wan reniene na sio ohunui. Ihana ne hini wan reniene oyo ipusu-pusuku. Ipusu ruai ne maue tewa nea. ");
INSERT INTO nxl_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Reiso, sani nanie opusu Au mo, kahurae orura ia-ia ee. Areimo sani ia isa waini nanie iapuoo ne numa wani ereroke-rokei. Ia reimo, kahurae iruei ireken tau ne numa rei nene hunonie ia-ia ee, samatoro ianei ata kani ai totua pannuhu tau iapuoo numa rotu-tu pusiki te tewa. ");
INSERT INTO nxl_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pene tu-tu iaunutu hatu tinipae nea, oyo iuna pusi kuai tewa. Mka sio oaumaniki. ");
INSERT INTO nxl_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Mka oasau ata, ‘Masi onoo ee! Ia rei nanie iapuoo numa ne ikua tau iuna pusiki tewa.’ ");
INSERT INTO nxl_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Te sani ia aia isa nanie ieu tau manahitane na ia aia tamene. Mka irue irura ia-ia naone ee. Kahurae inoo ata kani ne soratatua nihu hutusa okua onesi no nisau sio nihu hutu ua te tewa tea! ");
INSERT INTO nxl_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Sani munata ianei nea ata ikua tewa, mka iaisosi ne manori sou isa na irori sou karehate. Irori sou karehate na oahita na umau tewa nea. Mka iaisosiki on ne nisau rei waimo hainau asi. ");
INSERT INTO nxl_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Arei iae sani omi oi. Reiso, ia sia arihoni omi reini nanie opusu Au mo, kahurae iarinii pani anoi ia-ia ee. Tea mo, sani ia isa nanie iuna au we mampusue mo, kahurae ieu arihoni ne sae man. ");
INSERT INTO nxl_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Masine mo, iake nai osa tau reuna muaina nanaya. Ne, sani masine rei masine tewa nea mo, nanie iuna sae tanui asi na masine tewa nea rei? ");
INSERT INTO nxl_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mka ereuna muaina ahanare iaka tewa nea. Ereuna atuhu nene muaia iae iake tewa nea oi. Reiso nene iake mo, pesiki man. Mka omi san rei oi sani oanori runaku ia-ia tewa. Ia sia tinai ukuna mo, kahurae atinu ia-ia!” ");
INSERT INTO nxl_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Taue isa, sio mainisi peau runa sio palalosaya umau oeuso noi Yesus nanie oatinui iruni. ");
INSERT INTO nxl_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ne sio onata arihon akama Yahudi runa sio matuhete Musa ne maunauna umau oamum ananaso. Oahata, “Ikata sio palalosaya. Orue oaiso okata umau.” ");
INSERT INTO nxl_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesus iatinu san rei oyo iruni matieue isa. Matieue rei mo, atinui san rei. ");
INSERT INTO nxl_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Sani ia isa arihoni omi reini mo, ne rompau hata utun. Oyo hatae isa tihoniki. Mka iuna sae? Mka irori rompa hata hutu sia rahana sia rai noi pesete oyo ieu inina rompa osa wani tihoniki rei rotu-tu isupui tea! ");
INSERT INTO nxl_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Oyo sani isupu ne rompa hatae wani tihoniki rei mo, anoi mirike rotu-tu iasaoai roe manai. ");
INSERT INTO nxl_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ihokai poe numa oyo ioi ne netau runa ne mansiau sui ne numa nusue. Oyo iahata, ‘Mai na pusita anori mirika. Tea mo, usupu we rompa hatae wani tihoniki rei nea!’ ");
INSERT INTO nxl_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Uasau osimo. Roe noiyaha mo, mka san rei oi. Sani ia isa wain saka ipalalosa oyo iarihoni ne rosau nea, mka sio wason roe noiyaha anoo mirika. Sio mo, anoo mirika nai osa sani ia isa waini saka ipalalosa rei iarihoni ne rosau renesi sio hutu sia rahana sia wasoni oata kani opalalosa tewa rotu-tu kahurae oarihoni no rosau.” ");
INSERT INTO nxl_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesus iruni runa matieue isa. Atinui san rei, “Ia pina isa ne ai totu perak inata hutusa waron nene hunonia mainaya. Sani ne ai totue inate isa tihoniki mo, mka iuna sae? Mka inai kamane, inana kasanate, oyo ikopa numa anoe rei sui osa rotu-tu isupui, tea! ");
INSERT INTO nxl_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Oyo sani isupui, oyo ioi ne netau runa ne mansiau sui ne numa nusue. Oyo iahata, ‘Mai na pusita anori mirika. Tea mo, usupu we ai totue inate wani tihoniki rei nea!’ ");
INSERT INTO nxl_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Uasau osimo. Anahatana ne maisosia roe noiyaha iae wason san rei oi. Anoo mirika sani ia isa waini saka ipalalosa iarihoni ne rosau rai.” ");
INSERT INTO nxl_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesus iruni matieue na iatuheteso ata sani ia isa iarihoni ne rosau, Anahatana isiru heu ne rosau rai. Iahata, “Ia onate isa ne hehuka hanaia sio ua. ");
INSERT INTO nxl_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Taue isa ia iki muie ituruhaka iakakapa iasau osi amai. Iahata, ‘Ama, sama we pahakian arihoni me rusun nea.’ Amai iatinu san rei, oyo isama ne pahakian arihoni ne rusun osi ne hehuka hanaia uaso. ");
INSERT INTO nxl_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Potuina tewa oi, ia iki muie ieu iahen pusi ne pahakian rai oyo ieui noi nia hainau isa. Noi rei iaisei ipesi-ipesi ne ai totua rai tau ruai ne sanan mani. ");
INSERT INTO nxl_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Taa ne ai totua rai pusire, sira tau otoe rei omata muaine. Ia ikine rei iae, imata muaine oi. ");
INSERT INTO nxl_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Reiso ieui noi ia isa noi otoe rei na iainisi na ipakarian osiki. Oyo ia rei iunai ipakarian noi tanui. Iaisosiki ieui ipana ne hahu noi ne nisi. ");
INSERT INTO nxl_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ipana hahu oyo iahana imakaneai nai osa. Reiso nanie iai hahu nene muaia. Ne ia isa man tewa oi, irui muaine osiki na iai. ");
INSERT INTO nxl_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Taa san rei mato ianei ruai oyo iasau pani anoi, ‘Amaku ne sio pakarian osupu muaina panesi tau oaiso rotu-tu no muaina nesia. Ne au wan umata muaine. ");
INSERT INTO nxl_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Reiso nanie ununiku poe amaku na uanamana runai. Mka uasau osiki ata, “Ama. Usopa ukoku roua ne pene anom resaa tanuku! Tea mo, upalalosa tau Anahatana na una sana tanua oi. ");
INSERT INTO nxl_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Reiso aoiku tau anam mo, iake tewa. Ne uainisi arihonia na aunaku upakarian osia man ukata me makahaia.”’ ");
INSERT INTO nxl_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ianamana pani anoi pusi, oyo ieu iarihoni rei na inuniki poe amai. On pan hainau asi, amai inooi, oyo anoi runai. Reiso amai irumai noi, iatipuniki na imukiki. ");
INSERT INTO nxl_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Oyo ia ikine hanaie muie rei iasau osi amai. Iahata, ‘Ama. Usopa ukoku roua ne pene anom resaa tanuku! Tea mo, upalalosa tau Anahatana na una sana tanua oi. Reiso aoiku tau anam mo, iake tewa.’ ");
INSERT INTO nxl_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ne amai iasau osi ne makahaia, iahata, ‘Eu rapu! Nana we papi naue wani iake nai osa na ausahui osiki. Ausahu sapauu tau hanai nakata na sandaliu tau ain atua. ");
INSERT INTO nxl_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pusi oyo, nana koropou anae wani kopotuene oyo rehiki. Iuna karisaa mainae na pusita iai kata umau. ");
INSERT INTO nxl_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Areimo tau anaku reini mo, nooi sani imatai nea. Ne wain iamahaiki honu. Nooi sani tihoniki, ne isupui honu.’ Reiso ouna karisaa mainae. ");
INSERT INTO nxl_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Tau rei, ia iki hanai manonte waira ipakarian ria nisi. Inuniki, waini haineke numa, iatinu tihana tinunua. Iatinuso oakahuaso na omaraso. ");
INSERT INTO nxl_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Reiso ioi ia makahaie isa waini ipakarian noi numa rei oyo iasei, iahata, ‘Wasoni oakahuaso, omaraso mai numa reini tau sae?’ ");
INSERT INTO nxl_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ia makahaie rei iasau ata, ‘Wanim inuniki nea. Reiso amam iaisosima ahunu koropou ana pokotuene na una karisaa. Tea mo, wanim inuniki runa ne patane maka-makae.’ ");
INSERT INTO nxl_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ia ikine manonte iatinu san rei, oyo anoi resaa mainae rotu-tu ipenei inusu pani numa anoe rei nea. Reiso amai ieu pusui pani manahane. Iapamanui na inusui pani numa anoe. ");
INSERT INTO nxl_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ne ia ikine manonte iasau osi amai, ‘Atinu ama! Potuina reini upakarian sani me maniane osia. Uatinu tanua na upusu me maue sui osa. Ne auna sae osiku? Arui une-une anae hatae isa man osiku man tewa oi. Aruiki osiku na una karisaa na uai kata we netau man tewa oi! ");
INSERT INTO nxl_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ne noo! Anam hanaie ieu ipesi sai-sai ne ai totua waron isupure arihoni ne rusun pahakian waroni asamare osima rei. Ipesi sai-saire na sio pina numa naua! Waini inuniki mai tanua, oyo ano ahunu koropou anae wani pokotuene osiki!’ ");
INSERT INTO nxl_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ne amai iasau, ‘Anaku, ano mo, akataku sui osa. We sae man, araimo osi ano oi. ");
INSERT INTO nxl_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ne wanim reini mo, nooi sani imatai nea. Ne wain iamahaiki honu. Nooi sani tihoniki, ne isupui honu. Reiso ita mo, kahurae anori mirika na iuna karisaa iai ikata umau.’” ");
INSERT INTO nxl_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesus iruni matieue isa osi ne mampusua honu. Iasau san rei, “Ia hanaie isa mo, ia kupan kaya. Iuna ia isa ipakarian osiki. Ia rei isaka ia kupan kaya rei ne numa hutae. Taue isa, ia kupan kaya rei iatinu ata ne ia mamsakae rei, iuna sai-sai upui ne numa hutae. ");
INSERT INTO nxl_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Oyo ia kupan kaya rei ioiki. Iahata, ‘Au uatinu ata auna sai-sai we numa hutae si? Eu na kanu pusi au we numa hutae waroni asakare rai. Oyo rorire mai osiku. Ukisi heu nanam arihoni me pakarian reini nea.’ ");
INSERT INTO nxl_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Iatinu san rei oyo, pani anoi man. Iahata, ‘Reiso nene iake mo, una sae? Upuku reini nanie ikisi heu nanaku nea. Au reini uata nanie ueti tuamane mo, ukua tewa. Sani nanie ueu uai-ainisi kepen pena arena onata mo, uaumaa! ");
INSERT INTO nxl_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Io, uaneiki nea! Uanei kahurae una sae! Au kahurae unina mansia umau wason nanie oapusaaku noi no numau sani upuku reini ikisi heu nanaku arihoni we pakarian rein nea.’ ");
INSERT INTO nxl_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Reiso ioi sio wason ohiti noti noi upui rei. Oyo iasei tau ia waini mataanoe iahata, ‘Me notiu ina noi au upuku?’ ");
INSERT INTO nxl_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ia rei iahata, ‘Uhiti mina saitun liter nihu ate.’ Oyo ia mamsaka numa rei iahata, ‘Mai me notiu rai mai. Aruea poe na akatiki. Arue poe sisaa na akanu ata liter nihu ua man!’ ");
INSERT INTO nxl_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Oyo iasau osi ia isa honu. Iahata, ‘Oo ano mo, me notiu ina oi?’ Ia rei iasau ata, ‘Au we notiu mo, gandum karun taua nihun.’ Oyo ia mamsaka numa rei iasau honu, ‘Mai me notiu rai. Arue poe na akanure ata utun wanu man.’ ");
INSERT INTO nxl_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Oyo ia kupan rei iatinu ata ne ia mamsaka ne numa hutae rei ne hali wani iamanisa tewa rei. Oyo iasau, ‘Ano! Iakanihu iake oi maa!’” Oyo Yesus iasau osi ne mampusua honu. Iahata, “Sio wason opusu Anahatana tewa mai tuniai reini man mo, oanei oakanihu. Sio oakanihu iake renesi Anahatana ne mansiau. ");
INSERT INTO nxl_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Areiso nanie uasau osimo! Omi mo kupan kaya mai tuniai reini mo, kahurae pene ouna sai-saire. Ne kahurae oakahai mansiau tanure. Sani ouna san rei mo, mka osupu mo netau panesi nai osa. Tea mo, sani omatamo arihoni mo kupan kaya rai pusire nea, mka Upuri Anahatana iapusaamo roe noiyaha. ");
INSERT INTO nxl_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ia wain ita iparisaai iake na iuna tanei wani ikine mo, mka iparisaai na iuna tanei wani mainae oi. Ne sani ia isa waini iakarota tau tanei ikine mo, mka ianei ata iakarota tau tanei wani mainae oi. ");
INSERT INTO nxl_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Reiso sani osaka mo numa hutae ia-ia tewa mai tuniai reini mo, mka sapani na Anahatana iparisaa tanumo oi tau isupu numa hutae wani rotu-tu ria supan roe noiyaha? ");
INSERT INTO nxl_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Sani osaka mansiau mo numa hutae iake tewa mo, mka Anahatana itapimo osaka numa hutae roe noiyaha tewa oi tea! ");
INSERT INTO nxl_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Mai tuniai reini mo, ia manorine ipakarian osi sana ua iake tewa. Tea mo, mka anoi runa ia isa, ipenei tau ia isa. Iatinu tau ia isa, iananen tau ia isa. Omi iae san rei oi. Oanori runa Anahatana iake tewa sani anomo na mo numa hutae renesi Anahatana.” ");
INSERT INTO nxl_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yesus ianamana osi sio panesi, sio onata arihon akama Yahudi iae wasumo rei oi. Reiso oatinu Yesus ianamana rerihoni sio kupan na sio wason anoo tau no numa hutae mo, oaumaniki. Tea mo, sio onata rei anoo runa kepen. ");
INSERT INTO nxl_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Oyo Yesus iasau osiso, iahata, “Omi sahoro onina na mansia onoomo oamanisa, ne Anahatana ianei anomo! Sae mani mai tuniai reini waroni mansia onoore iake mo, Anahatana ipenei tanure. ");
INSERT INTO nxl_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ipusu Musa ne maunauna runa sio mamsima runa Anahatana ne maunauna. Ipusure rotu-tu reeu mai tau Yohanis mamsohue ihokai. Oni orase rei, usima na Sou Iake rerihoni Anahatana nanie irime ne mansiau. Sio panesi iae wasoni onina ia-ia nanie opusui na irimeso. ");
INSERT INTO nxl_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tuniai reini mka repena. Ne Musa ne maunauna mo, nene anamanae mkane sini mani iae tihoniki mo, tewa. ");
INSERT INTO nxl_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Atieu sani ia isa wain iausahai nea ne itihi sahai oyo inana ia pina tamene honu, areimo Anahatana iasau isahu-sahu sahai. Ia isa inana ia pina waini sahai itihiki nea iae, areimo Anahatana iasau ata isahu-sahu sahai oi.” ");
INSERT INTO nxl_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesus iruni matieue isa. Iahata, “Ia isa mo, ne kupan kaya mainae. Ne apia mo, marainia nai osa. Noore sani ia aia ne papi naue. Ounare arihoni nipae wani manne nai osa. Onone ranie mo, ne sanan man. Areimo tau ne sae man warumo. ");
INSERT INTO nxl_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ne ia isa honu saka iai-iainisi kepen waimo noi ne numa nusue nene mitanunue. Ia rei mo, nanai Lasarus. Ne patane taue tau kana-kanau. ");
INSERT INTO nxl_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Imata muaine nai osa. Reiso nanie iai ia kupan kaya ne muaina nesia waroni ramnahuso poe tuamane. Erenesi honu, asu rahoka ramleha ne kana-kanau rai. ");
INSERT INTO nxl_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ereeu mai, oyo Lasarus imatai. Oyo Anahatana ne maisosia on roe noiyaha ohoka ororiki. Ororiki oyo ounai iruei hae Abraham. ");
INSERT INTO nxl_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ita ia kupan kaya rei imatai oyo okaniki. Ia kupan kaya rei imatai, inusui poe usa mainae wan hainau arihoni Anahatana na isupu sinsara. Sinsarai nai osa. Taa iarinaa roe, inoo hainau san rei, inoo Abraham wairo iru-rue ikata Lasarus. Inoo Lasarus wairo iru-rue hae Abraham. ");
INSERT INTO nxl_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Reiso, iakapona iahata, ‘Amaku, Abraham! Anom runa au reini oi. Aisosi Lasarus inono hanai nakate rurue poe tihu na iuna iampeta meiku reini mkane oi. Tea mo, sinsaraku nai osa mai usa reini.’ ");
INSERT INTO nxl_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ne Abraham iasau iahata, ‘Anaku! Anom repeka ia-ia ee! On poe tuniai maiapane mo, asupu sae mani waroni iaka tunna. Ne Lasarus mo, isupu sae waroni iaka tewa. Ne mai rei, ia mo, ne sanan. Ne ano mo, sinsaraya nai osa. ");
INSERT INTO nxl_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Na isa honu mo, Upuri Anahatana iuna ekote mainae na renetei. Omi on poe hae, ami on mai hae reini. Reiso omi wapo noi usa mainae rei mo, oeu mai rei iake tewa. Ami wani mai rei iae, aeu poe rei iake tewa oi.’ ");
INSERT INTO nxl_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ia kupan rei iasau. Iahata, ‘Munata san rei mo, uainisi usopa koku roua. Amaku, aisosi Lasarus na ieui poe amaku ne numa ee. ");
INSERT INTO nxl_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Areimo, tau we waniu sio nima wasupo numa rei oi. Reiso, aisosi Lasarus na iaunauso ia-ia na pene onususo mai usa mainae wani hainau arihoni Anahatana reini. Pene sinsaraso sani au reini oi.’ ");
INSERT INTO nxl_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ne Abraham iasau honu. Iahata, ‘Musa ne maunauna waron. Sio mamsima runa Anahatana ne maunauna waron tanso oi. Reiso, tapiso opusu sae waroni okanure tau Anahatana ne anamanaya rai!’ ");
INSERT INTO nxl_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ne ia kupan rei iasau, iahata, ‘Amaku Abraham! Arai man mo, rakua tewa. Ne sani ia matane isa iamahaiki honu oyo ieu poe iasau osiso, sio mo, mka oarihoni no rosau.’ ");
INSERT INTO nxl_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ne Abraham iasau, iahata, ‘Sani oatinu tau Musa na sio mamsima runa Anahatana ne maunauna no maunauna tewa, masike ia waini imatai iamahaiki honu mka oparisaa tewa sirinia.’” ");
INSERT INTO nxl_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Taue isa Yesus ianamana osi ne mampusua, iahata, “Mai tuniai reini mo, mka mo imin tau sae man. Reiso mka sio oreamo sui osa na opalalosa. Ne mka siraka tau sio wasoni oreamo rei. ");
INSERT INTO nxl_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Sani ia isa irea ia isa wain iparisaa ia-ia tau Au tewasi na ipalalosa mo, nene iake okanihoo hatu mainae roe ia wain irea ia rei tionai oyo omokoi nau nuae. Omi ata kani areimo oapasanai mtinte, ne Anahatana mka iapasana sio wason ouna ia isa ipalalosa. Iapasanai mtinte renesi honu sani omokoi nau nuae. ");
INSERT INTO nxl_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Reiso, oainati na ruamo. Sani anoo kakam wanim isa wain iparisaa tanuku iuna sana, areimo kahurae akapuku tanui. Sani iarihoni ne rosa rei, pene anom resaa tanui nea. ");
INSERT INTO nxl_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Sani kakam wanim rei iuna sana tanua nai itu tau onone rei sirinia oyo ieu mai tanua sui osa na iahata, ‘Mka au una san rei tewa nea. Usopa koku roua na pene apasanaku ee.’ Areimo pene anom resaa tanui nea.” ");
INSERT INTO nxl_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yesus ne maisosia oatinu Yesus iasau ata Anahatana iapasana sio wason ouna sio tamena opalalosa oyo oasau osiki. Oahata, “Upu! Akahaima na aparisaa tau Anahatana pusi anoma honu!” ");
INSERT INTO nxl_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yesus iasau ata, “Kanapua kanie mo, ikine man. Ne reruhu reuna ai onate. San rei oi na omi. Sani oparisaa mkane man sani kanapua kanie ikine rei, omi mo, mka oasau tau ai onate isa ata, ‘Ai onate! Asukaya arihon naniam na aeu nau nuae na aruhu nau rei!’ Oyo orase rei sirinia, ai rei resukai nau nuae.” ");
INSERT INTO nxl_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesus ianamana osi ne mampusua. Iahata, “Sani ia isa arihoni omi reini mo, ne ia manorine isa. Ia manorine rei ne pakarian mo, ieti me nisi te isaka me rompau. Taa inuni on ria nisi, hoka poe, ano auna sae? Asau osiki ahata, ‘Mai rue roe na iaita.’ Areimo, tewa tea! ");
INSERT INTO nxl_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ne ano mka asau osiki ata, ‘Eu na atanunu na aeu asohua. Oyo hoka mai na aooa anori runaku rotu-tu uai suka. Uai suka samatoro ano aia!’ ");
INSERT INTO nxl_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Aia suka, ainisi iake arihoni me ia makahaie rei tewa tea! Me manorine rei hasae iuna sae wani upui iaisosiki iunai rei tea! ");
INSERT INTO nxl_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Arei iae noo sani omi reini oi. Sani opakarian suka nea mo, kahurae oasau ata, ‘Ami reini mo, ami manorina man. Ami mo, ma sae isa tewa. Ami mo, hasae auna pakarian waron iaisosima rein man.’” ");
INSERT INTO nxl_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesus runa ne mampusua wason oeuso na roe kota Yerusalem. Oeuso oniku otoe Samaria na otoe Galilea nene nenene. ");
INSERT INTO nxl_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Taa onusu niane isa, sio kupu unte wan iake tewa nai osa sio hutusa ohokaso noi tanuso. Sio rei ooso hainau mkane arihoni Yesus sio. Areimo tau kupu unte mo, sio otapiki oeu haineke mansiau tewa. ");
INSERT INTO nxl_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Oyo oakapona oahata, “Upu, Yesus! Anom runama.” ");
INSERT INTO nxl_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Taa Yesus inooso oyo iahata, “Oeumo roe sio imam na onoo mo patana ata kani mo kupue iake nea te tewasi.” Wasoni oeuso, sira tau kupu unte wani iake tewa rei tihoniki arihoni no patana rei sirinia. Pusiso okupu tewa nea. ");
INSERT INTO nxl_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ia isa arihoni sio hutusa rei inoo ata ne kupue rei iake nea. Oyo iuni iai-ainaa runa Anahatana nioi mainae. Iasau ata, “Uainisi iake arihonia, Upuku! Tau we kupue iake nea!” ");
INSERT INTO nxl_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Oyo ieu noi Yesus oyo irike tune mai Yesus uai anoe iahata, “Ama, uainisi iake arihonia. Tea mo, we kupue iake nea!” Ia hanaie rei mo, ia Samaria. Sio Samaria mo, sio Yahudiu no sukaso tewa. ");
INSERT INTO nxl_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Oyo Yesus iasau osiki. Iahata, “Usuisene omi hutusa tea? Oo sio sia mo, wasonpa? ");
INSERT INTO nxl_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Sio umau rei onuni mai tanuku tewa tau sae? Hasae ia hanai rakane reini man sahoro wain inuni mai iainaa runa Anahatana!” ");
INSERT INTO nxl_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Oyo iasau honu osi ia hanaie rei. Iahata, “Hitio roe na anunia. Ano aparisaa tanuku reiso Anahatana isuisenea nea.” ");
INSERT INTO nxl_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Taue isa, sio onata arihon akama Yahudiu umau oasei tau Yesus. Oahata, “Sima osima ee! Inasa Anahatana irime ne mansiau?” Yesus iasau iahata, “Anahatana irime ne mansiau mo, mka onooi tau matamo kahutua tewa. ");
INSERT INTO nxl_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Reiso mka mansiau oasau tewa ata, ‘Ee! Wain irimeta mai rei nea!’ Te, ‘Masi onoo. Wain irimeso pan rei nea.’ Ne Anahatana waini irime ne mansiau anoo nea. ");
INSERT INTO nxl_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mka nene orase wamo tau onina nanie onoo Au Tumata Reini mo, Anahatana Ihitiku rei. Nanie onooku urime we mansia, masike hasae onone osa-sa man. Ne mka onoo tewa. ");
INSERT INTO nxl_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mka sio umau oeu mai osima osimo. Oahata, ‘Mai! Tea mo, Ia Aia waini Anahatana Ihitiki na Iapuheu ne Mansiau waini rei.’ Te oahata, ‘Waira rei.’ Ne pene unumo raina tau nanie oeu pusu sio rei. ");
INSERT INTO nxl_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Areimo, tau Au Tumata Reini mo, Anahatana Ihitiku, uhokaku honu mai tuniai reini mo, mka sani isoe erehehi ereuna itane na resita nante rekotoi ria rurue tu-tu nau rurue. Mka ia sia mani onooku. ");
INSERT INTO nxl_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ne Au reini mo, kahurae uhana sinsara panesi naone. Mka naene reini openeso tanuku. ");
INSERT INTO nxl_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ne orase wani Au Tumata Reini mo, Anahatana Ihitiku, nanie uhokaku mai tuniai reini honu, mka mansiau ouna sani naone ouna tau Nuh ne naene. ");
INSERT INTO nxl_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tau Nuh ne naene rei, Anahatana nanie iapasanaso, ne anoo rauponu runai tewa. Hasae oai, oninu, na oausaha sirinia. Ouna san rei sirinia rotu-tu Nuh sio osaaso roe kapane anoe. Osaaso roe, oyo sira tau waene onate resaa rotu-tu sio wason nau kapane rei mui mo, omoko pusiso. ");
INSERT INTO nxl_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Arei iae noo sani sio tau Lot ne naene oi. Tau rei Anahatana nanie iapasanaso nea, ne anoo rauponu runai tewa. Hasae oai, oninu, ohane oahen, orahu nisi, na oapuoo no numau sirinia. ");
INSERT INTO nxl_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ne pannuhu Lot ieu iarihoni kota Sodom rei, sira tau Anahatana irati usa na hatu waron raai-aiso sani usa. Iratire noore sani uane. Iratire na rahunu pusi sio wason noi kota rei. ");
INSERT INTO nxl_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mka san rei oi tau Au Tumata Reini mo, Anahatana Ihitiku, uhokaku honu mai tuniai rei. Mka uhokaku honu na uapasanaso ne anoo rauponu tewa. ");
INSERT INTO nxl_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tau orase rei sirinia, ia sia waipan mui mo, pene inusui pani numa anoe na inana ne sae man pani rei. Tea mo, mka irari tewa nea. Tea ne, sio wason noi nisi iae, pene onunso poe numa na onana no sae isa oi. Sio mo, kahurae oaparikuna. ");
INSERT INTO nxl_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Anomo rapeka runa Lot sahai te tewa? Noso inoo hae muie rotu-tu imatai meke-meke. ");
INSERT INTO nxl_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ia sia wain iamahaiki pusu Au tewa, mka iamahaiki ikata Anahatana rotu-tu ria supan tewa. Ne ia seia wain iamahaiki ipusu Au, mka iamahaiki ikata Anahatana rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Oatinu ia-ia! Sani uhokaku honu mai tuniai reini, atieu rei sani sana ua onekeso tau naniake osa. Sira tau mka unana ia isa tau iparisaa tanuku. Oo ia isa mo, uarihoniki. Tea mo, iparisaa tanuku tewa. ");
INSERT INTO nxl_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Sani sio pinau ua orei ana okata umau, sira tau unana ia isa oyo uarihon ia isa.  ");
INSERT INTO nxl_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Sani sana ua orahuso noi nisi, sira tau unana ia isa oyo uarihon ia isa.” ");
INSERT INTO nxl_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesus ne mampusua oatinu san rei oyo oasei tanui. Oahata, “Upu! Mka araimo rayari napi supa?” Oyo Yesus iasau ata, “Sani manua waron saka raai matane mo, rarihuso ramanouso roe naniake isa wan matane wamo rei, mka Anahatana iapasana sio wason kahatena.” ");
INSERT INTO nxl_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Taue isa Yesus iruni matieue isa osi ne mampusua na iatuheteso ata kahurae oainisi sui osa pene anoo rasama-samaso. ");
INSERT INTO nxl_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yesus iasau iahata, “Noi niane isa, ia isa wain saka iarinii parakanau mo, ikaitau Anahatana tewa. Anoi na mansia tewa oi. ");
INSERT INTO nxl_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ia pina uhanu isa waimo niane rei oi. Ia mo, saka ieu-ieui noi ia wain saka iarinii parakanau rei. Oyo iahata, ‘Upuku! Akahaiku runa we parakana reini ee! Asau ata au sahoro au manisate na unesi kua we nisa rei.’ ");
INSERT INTO nxl_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ia rei iatinu san rei, ne ipenei iakahai ia pina rei. Ne tau muie, iasau pani anoi, iahata, ‘Masike au reini mo, ukaitau Anahatana tewa na anoku na mansia tewa oi, ");
INSERT INTO nxl_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ne noso ia pina uhanu rei iakaremaku sui osa, reiso nene iake mo, uakahaiki runa ne parakana rei. Tea mo, mka ihokai mai tanuku sui osa na iuna putaku man.’” ");
INSERT INTO nxl_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Oyo Upuri Yesus iasau honu. Iahata, “Masi anomo rapeka runa sae waron ia wani saka iarinii parakanau iasau rei. Masike ia mo, ne hali kahatene! ");
INSERT INTO nxl_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Reiso Anahatana mo, mka iakahai sio wasoni iromaso tea! Mka iakahai sio wason oainisi onone ranie tea! Mka iunaso onapa potuina tewa. ");
INSERT INTO nxl_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nanie uasau osimo! Anahatana mka iakahaiso. Mka iasau ata no parakana rei pusiki nea. Mka no parakanau pusire manisate sansana man. Ne Au Tumata Reini mo, Anahatana Ihitiku, mka uhokaku honu mai tuniai reini mo, mka usupu sio wason oparisaa tanuku te tewa?” ");
INSERT INTO nxl_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesus iruni runa matieue isa na iatuhete sio wasoni onoo ruao ata sio mo, sio manisate mainae renesi sio pusiso reiso onoo sio pusiso sio ikina honua. ");
INSERT INTO nxl_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Yesus iahata, “Taue isa sio ua oeu roe Anahatana ne numa mainisie nanie oainisi. Ia isa mo, ia onate arihoni akama Yahudiu. Ia isa honu mo, ia mainisi peau. ");
INSERT INTO nxl_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ia onate arihoni akama Yahudiu rei ihitio iainisi iahata, ‘Upu, uainisi iake arihonia tau au mo, nooku sani sio tamena tewa. Ukimanaka tewa, uakarota mansia tewa. Usahu-sahu sahaku tewa. Nooku sani ia mainisi peau reini tewa. ");
INSERT INTO nxl_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Minku unue mo, uamaon nai ua pusu Musa ne maunaune. Sae man usupure, usamare tau pahakian hutusa oyo urui pahakian osa osi Anahatana.’ ");
INSERT INTO nxl_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ne ia mainisi peau rei mo, hasae iooi hainau arihon sio wason noi Anahatana ne numa mainisie rei. Iarinaa na roe nante tewa oi. Hasae iroho unui matae na iatuhete ata ia mo, iatamisi ne rosau. Iasau iahata, ‘Upu, au reini mo, upalalosa. Anom runaku na asiru heu we rosau.’ ");
INSERT INTO nxl_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Uasau osimo. Ia mainisi peau reini sahoro inuniki poe ne numa, Anahatana isiru heu ne rosau nea. Ne ia onate arihon akama Yahudiu mo, Anahatana iatinu ne mainisie tewa. Tea mo, ia sia man waini irati ruai areimo, Anahatana mka iapusaai. Ne ia wain iapusaa ruai mo, Anahatana mka iratiki.” ");
INSERT INTO nxl_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Taue isa sio panesi oeuso noi Yesus. Sio umau ohoka orori no sio ikina oi na nanie Yesus hanai tanso na iainisi na Anahatana irui iake osiso. Taa Yesus ne mampusua onoo san rei oyo, oakapuku tau sio wasoni orori no sio ikina rei. ");
INSERT INTO nxl_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ne Yesus ioi sio ikina rei na oeuso mai tanui. Iahata, “Tapi sio ikina rei na oeuso mai tanuku! Pene soposo! Sio wason oparisaa resun tewa sani sio ikina reini mo, sio wason mka opusu tau Anahatana irime ne mansiau. ");
INSERT INTO nxl_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Atinu mai ia-ia nanie uasau osimo. Ia sia wain itapi Anahatana irimei tewa noo sani sio ikina reini, mka ipusu tewa sani Anahatana irime ne mansiau.” ");
INSERT INTO nxl_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Taue isa ia mainae isa iasei tau Yesus. Iahata, “Matuhetene wani me iake! Kahurae una sae na uamahaiku ukata Anahatana rotu-tu ria supan?” ");
INSERT INTO nxl_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesus iasau, iahata, “Hasae Anahatana man sahoro ne iake! Ia isa ne iake sani Ia tewa! Reiso ano nanie asau ata Au we iake tau sae? ");
INSERT INTO nxl_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ano anei ata tau Musa ne maunauna mo, Anahatana iasau ata, ‘Pene osahu-sahu mo pina hanai. Pene ohunu mansia. Pene okimanaka. Pene oruni mansia inamatane. Oamuira mo mansia mainaya.’” ");
INSERT INTO nxl_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ia onate rei iasau ata, “Upuku! Sae warumo ano asaure reimo, au una pusu pusire oni au ikine asi.” ");
INSERT INTO nxl_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesus iatinu san rei oyo iasau honu. Iahata, “Munata san rei mo, ano mo, kahurae auna isa honu. Ano mo, kahurae eua na ahen me numa hutae pusiki. Pusi oyo, eua asama kepen waron asupure rei osi sio mosokinia. Sani auna san rei nea, mka asupu me numa hutae roe noiyaha. Pusi oyo, aeu mai na aeu apusu Au.” ");
INSERT INTO nxl_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ne ia onate rei iatinu Yesus iasau san rei oyo, ieui runa anoi mtinte nai osa. Areimo, ia mo, ne kupan kaya mainae nai osa. ");
INSERT INTO nxl_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesus ianei ata ia onate rei mo, anoi mtinte nai osa reiso inooi oyo iasau, “Anahatana irime ne mansiau mo, resun tau sio kupan kaya opusui. ");
INSERT INTO nxl_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Masi oatinu. Areimo noo sani makapana wani nanae unta wani mainae nai osa. Makapana rei resun mkane renusui pusu sisunue matae. Ne sio kupan kaya mo, opusu Anahatana irime ne mansiau mo, resun nai osa.” ");
INSERT INTO nxl_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Sio wasoni oatinu Yesus iasau rei oasei. Oahata, “Ira oe. Munata san rei mo, mka Anahatana iapuheu ia isa tewa oi tea! Iapuheuso na pene iapasanaso tewa tea!” ");
INSERT INTO nxl_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ne Yesus iasau osiso iahata, “Anahatana imaha iuna sae man wan mansia ounai kua tewa. Reiso, Anahatana imaha iapuheu ia sia man.” ");
INSERT INTO nxl_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Oyo Petrus iasau ata, “Ama! Ami mo, aeu arihoni ma sae man nea na apusua.” ");
INSERT INTO nxl_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Oyo Yesus iasau ata, “Atinu mai ia-ia nanie uasau osimo. Ia sia wain ieu iarihoni ne niane, pina hanai, kaka wan, mansia mainaya, te ne hehuka noso nanie isima ata Anahatana nanie irime ne mansiau nea, ");
INSERT INTO nxl_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mka tau wain iamahaiki mai tuniai reini isupu panesi arihoni sae waron iarihonre rei. Na sani imatai nea, mka iamahaiki honu ikata Anahatana rotu-tu ria supan.” ");
INSERT INTO nxl_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus ioi ne mampusua hutusa rahana ua na sio ruao man oyo iasau osiso. Iahata, “Nanie ieuta roe kota Yerusalem. Mka pusire waron Anahatana ne sio mamsima runa ne maunauna okanu rerihoni Au Tumata Reini Anahatana Ihitiku, mka pusire raeu roe rei. ");
INSERT INTO nxl_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Sio Yahudiu mka oruiku osi sio wason sio Yahudiu tewa na oaumaniku, okumateneku, na ohutoku. ");
INSERT INTO nxl_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Osapuku tau awane unie oyo ohunuku. Ne nene poua san rei, uamahaiku honu.” ");
INSERT INTO nxl_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ne, ne mampusua oanei sae wani Yesus iasaui osiso rei tewa. Areimo tau Anahatana iunaso na pene oaneiki. ");
INSERT INTO nxl_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesus sio wason haineke ohokaso pani kota Yeriko. Pan rei mo, ia mata putie isa waimo iruei noi arena nusue. Waimo iruei iai-iainisi ai totue. ");
INSERT INTO nxl_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ia mata putie rei iatinu sio hutue oniku, reiso iasei iahata, “Sae rei?” ");
INSERT INTO nxl_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Sio oasau osiki ata, “Yesus, ia kota Nasaret rei, wain inikui.” ");
INSERT INTO nxl_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ia mata putie rei iatinu san rei oyo iakapona. Iahata, “Yesus, aia Daud upui, anom runaku.” ");
INSERT INTO nxl_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sio wasoni pani uae oakapuku tanui. Oahata, “Amaturua!” Ne ia rei iakapona sui osa sirinia. Iahata, “Daud upui, anom runaku.” ");
INSERT INTO nxl_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesus iatinu san rei, oyo iaraoo. Iahata, “Orori ia mata putie rei mai tanuku.” Ia rei ihoka noi Yesus, oyo Yesus iasei tanui. Iahata, ");
INSERT INTO nxl_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Anina nanie una sae osia?” Ia rei iahata, “Upu! Nanie unoo.” ");
INSERT INTO nxl_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesus iahata, “Anoo mosa! Aparisaa tanuku, reiso wani usuisenea.” ");
INSERT INTO nxl_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Sira tau ia mata putie rei inoo mosa. Ieu ipusu Yesus iainaa runa Anahatana. Iahata, “Upuku Anahatana. Uainisi iake arihonia. Unoo mosa nea.” Sio panesi wasoni onoo rei, pusiso oainaa runa Anahatana oi. ");
INSERT INTO nxl_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Taue isa, Yesus ihokai poe kota isa wan nanae Yeriho. Inusui pani kota rei oyo ieui iniku pusu kota rei. ");
INSERT INTO nxl_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Noi kota rei sio mainisi peau no ia mainae isa waipo. Ia mo, ne kupan kaya mainae nai osa. Nanai Sakeus. ");
INSERT INTO nxl_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Inina nanie inoo Yesus ata Ia mo, Ia seia. Ne mansia hutue sui arena. Samatoro ia iae ia puku-pukune oi. Reiso inoo mosa Yesus tewa. ");
INSERT INTO nxl_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Reiso iruma sansana ianaone iniku sio mansia hutue rei. Oyo isaai roe ai onate isa na nanie inoo Yesus wain nanie inikui noi rei. ");
INSERT INTO nxl_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesus ihokai noi ai rei, iarinaa. Inoo Sakeus oyo iasau iahata, “Sakeus, sipu mai nea! Tea mo, kahurae unekeku poe me numa.” ");
INSERT INTO nxl_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakeus iatinu san rei oyo, isipui sisaa arihoni ai rei. Oyo ieu ikata Yesus poe ne numa. Hoka poe, iapusaai anoi mirike. ");
INSERT INTO nxl_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ne sio wason onoo rei, oamum ananaso. Oahata, “Ira oe! Ieui poe, iruei poe ia palalosae ne numa!” ");
INSERT INTO nxl_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ne Sakeus ihitio iasau osi Upuri Yesus. Iahata, “Upuku, masi anoo! Nanie usama we kupan kaya tau pahakian ua nea. Reiso pahakian isa reini, nanie usama-sama sio kasiana. Sani ia sia man wain uakarotai na unana no kepen, au mka unre osiki rotu-tu nai ate.” ");
INSERT INTO nxl_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Oyo Yesus iasau, “Tau rahata repan, Anahatana iapuheu ano runa me numa hutae pusimo na pene iapasanamo. Iapuheumo tau ano aparisaa Anahatana noo sani upum momom Abraham rei tea! ");
INSERT INTO nxl_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Areimo tau, Au Tumata Reini mo, Anahatana Ihitiku uhokaku na unina sio palalosaya na uapuheuso na pene Anahatana iapasanaso. Sio sani sio wason oamaninuso.” ");
INSERT INTO nxl_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sio panesi wasoni oatinu Yesus ianamana, Yesus iruni matieue isa osiso. Areimo, tau wain haineke kota Yerusalem nea. Tau rei, sio oata kan Anahatana nanie irime ne mansiau nea. ");
INSERT INTO nxl_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Reiso iasau osiso iahata, “Taue isa ia mainae isa nanie ieu noi otoe isa wan hainau. Nanie ieu na sio ohitiki tau aia. Ohitiki tau aia suka, samatoro inuniki mai ne otoe honu. ");
INSERT INTO nxl_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Reiso ioi ne sio manorina hutusa. Oyo irui sana osa-osa ne ai totu inate. Ai totu inate rei, ia isa ne kati tau hunana tonu. Iasau osiso, ‘Hane na oahen na ai totua rai rotu-tu ununiku na usupu ai totua panesi honu.’ Iruire oyo ieui. ");
INSERT INTO nxl_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ne sio noi ne niane rei openeso tanui. Reiso oaisosi sio umau na oeuso pan sio wason nanie ohitiki tau aia rei. Hoka pan, oahata, ‘Apenema tau ia rei iuna ami ma aia!’ ");
INSERT INTO nxl_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ne ohiti ia mainae rei tau aia sirinia. Ohitiki pusi, samatoro inuniki poe ne niane honu. Hoka poe, oyo iaisosi sio oi ne manorina hutusa wasoni isama ai totue inate osiso rei. Ioiso rei, nanie ianei ata osupu ina arihoni no ai totue inate wan osupui rei. ");
INSERT INTO nxl_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ia manorine isa ihokai mai tanui oyo iasau osiki iahata, ‘Upu, ai totu inate wan upuku aruiki osiku reimo, usupu untu arihoniki nea. Usupu inata hutusa nea.’ ");
INSERT INTO nxl_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Iasau osi ne manorine rei, iahata, ‘Iake nai osa. Ano mo, we manorine wain ne iake nai osa! Areimo tau arime we anamanaya masike areimo ai totue mkane. Reiso mka uparisaaya iake. Reiso muie reini, nanie urui tanei mainae osia na aunai. Mka urui kawasa osia na arime kotau hutusa.’ ");
INSERT INTO nxl_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nta ia manorine isa honu ihokai. Iahata, ‘Upu, ai totu inate wan upuku aruiki reimo, usupu untu arihoniki nea. Usupu inata nima nea.’ ");
INSERT INTO nxl_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nta upui iasau osiki, iahata, ‘Ano mo, mka arime kotau nima.’ ");
INSERT INTO nxl_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ia manorine isa honu ihokai honu. Iahata, ‘Upu, mai me ai totue inate osa wani aruiki osiku rei. Uopai tau we mamkusa hana oyo uauhuniki. Uauhuniki na pene tihoniki. ");
INSERT INTO nxl_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ukaitaua. Areimo tau upuku ano mo, aisosi ia isa inana osia mo, anina na inana kahi-kahiki. Upuku, ano iae, saka anana sio umau no untu. Areimo noo sani ia isa wain iai nisi wan ruai irahui tewa.’ ");
INSERT INTO nxl_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Upui rei iahata, ‘Ano mo, ano manorine wan me kahatene! Au mo, mka uapasanaya repusu sae wan asaui rei. Areimo tau ano anei au mo, we makae. Au mo, unana sio umau no untu. Uai nisi wan urahui tewa. ");
INSERT INTO nxl_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Munata san rei, kahurae arui we ai totue inate rei osi ia wain saka ihitire osi mansiau na asupu ai totua ranesi. Na san unun mai, mka unanai na nene untu osi ruaku!’ ");
INSERT INTO nxl_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Pusi oyo, ia onate rei iasau osi sio wason ooso noi rei, iahata, ‘Onana ai totu inate rei arihoniki. Oyo eu ruiki osi ia manorine wain ne ai totu inata hutusa rai.’ ");
INSERT INTO nxl_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ne sio rei oahata, ‘Upu, ia reimo ne ai totu inata hutusa nea!’ ");
INSERT INTO nxl_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ia onate rei iahata, ‘Oatinu ia-ia! Ia wain isupu sae isa oyo ipakei ia-ia mo, mka Anahatana irui renesi honu osiki. Ne ia isa wain isupu sae isa oyo ipakere ia-ia tewa mo, mka Anahatana inanare arihoniki honu. ");
INSERT INTO nxl_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ne, sio wason openeso tau au una aia mo, oeu na oamanouso na roriso mai. Oyo ohunu pusiso mai uaku anoe!’” ");
INSERT INTO nxl_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesus iruni matieue pusi, oyo ieui na roe kota Yerusalem. Ieu ianaone ne mampusua. ");
INSERT INTO nxl_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nanie ohaineke nia Betpage runa nia Betania. Niana ua rai mo, warupan Pupue Saitun nene sanene aikune. Iaisosi ne mampusua ua. Iasau osiso, iahata, ");
INSERT INTO nxl_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Uamo oeumo nau niane wanau uae reinau. Onusui, mka osupu keledai anae isa wapan okanihooi. Keledai anae reimo, ia seia man isaai tewasi. Onosu nene awane na onesai mai. ");
INSERT INTO nxl_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ne, sani sio umau oasei tanumo, ata, ‘Nanie onosu keledai anae rei tau sae?’ Asau osiso ata, ‘Mani upu nanie isaai.’” ");
INSERT INTO nxl_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yesus iasau iaunauso pusi, oyo uaso oeuso. Oeu oyo osupu keledai anae rei nooi sani Yesus iasau osiso rei. ");
INSERT INTO nxl_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Uaso wasoni onosu keledai anae rei, oyo nene upue oasei tau uaso. Iahata, “Nanie onosu keledai anae rei tau sae?” ");
INSERT INTO nxl_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Oasau ata, “Mani Upu nanie isaai.” Reiso itapiso orori keledai anae rei osi Yesus. ");
INSERT INTO nxl_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Hoka mai, oaunutu no papi naua roe keledai anae rei nene totue unie oyo oakahai Yesus na isaai roe irue roe tanui. ");
INSERT INTO nxl_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Taa Yesus iniku isaa keledai anae rei, mansiau wasumo rei ohuka no papi naua oyo oratare sui arena na oamuirai sani oamuira sio aiau. Oyo, keledai anae reeu reheta roe tanure. Ouna san rei tau oamuira Yesus nooi sani oamuira sio maina tamena oi. ");
INSERT INTO nxl_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Wain nanie ihaineke inusu kota Yerusalem nea. Wain imusu-musu Pupue Saitun rei. Ne mampusua wason oeu okatai rei anoo mirika nai osa. Reiso pusiso oainaa na Anahatana nio mainaya. Oahata, “Ami ainisi iake arihoni mani Upu Anahatana! Areimo, tau anoo sima-simana panesi nea. ");
INSERT INTO nxl_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Mani Upu, arui iake osi Ia Aia wain aratiki runa me kawasa. Naone noo mansia mai tuniai sani Ano roe noiyaha me nisau. Ne muie reini nanie aunaso oi neta tanua. Ainaa nnaya waro noiyaha.” ");
INSERT INTO nxl_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ne sio onata arihon akama Yahudiu umau oasau osi Yesus. Oahata, “Matuhetene! Akapuku tau me mampusua rei ee.” ");
INSERT INTO nxl_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesus iahata, “Uasau osimo. Sani sio reini oamaturuso, mka hatu rasupoe rakapona raainaa nnaku.” ");
INSERT INTO nxl_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Taa Yesus sio wasoni ohaineke kota Yerusalem nea, inoo kota rei oyo irani. ");
INSERT INTO nxl_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Iahata, “Anoku kasiane na omi Yerusalem. Unina na rahata repan oanei sapani na ouna iake na Anahatana na oi Anahatana tau mo neta. Ne oationa Au tewa reiso Anahatana iunamo oanei tewa sapani na ouna iake nnai na oiki tau neta. ");
INSERT INTO nxl_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mka pannuhu nene orase, mo nisau ohoka osaamo. Osaamo oyo oapuoo kasunepene rehorimo na rekasunepe netemo hae uae, hae muie, on pan, on poe, rotu-tu ohoka iake tewa. ");
INSERT INTO nxl_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Mka ouna watikohu mo kota rei oyo ohunu pusimo wamo kota rei. Omi mainaya na mo sio ikina. Mo kota rei mka rotu-tu rehasa na tuamane. Araini pusire mka rayari, areimo tau Anahatana irati Au, Aia wan Ihitiku na Uapuheu Mansia. Iratiku ne oationaku tewa.” ");
INSERT INTO nxl_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesus ihokai roe Anahatana ne numa mainisie nusue oyo inei mansia pusiki wasumo oahen noi rei. ");
INSERT INTO nxl_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Iasau osiso, ata, “Yesaya, Anahatana ne ia mamsima runa ne maunauna, ikanu ata, ‘Anahatana iasau. “Au we numa mo, mka tau numa mainisie.” Ne omi wani ounai tau sio kimanakana naniao nea.’” ");
INSERT INTO nxl_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Onone ranie Yesus iatuhete mansiau roe Anahatana ne numa mainisie. Ne sio imam no sio mainaya, sio matuhete Musa ne maunauna, na sio mainaya arihoni sio Yahudiu wasoni onina arena nanie ohunu Yesus. ");
INSERT INTO nxl_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ne oanei tewa nanie ouna sae. Areimo tau, sio panesi okaumin oatinu Yesus iatuheteso. ");
INSERT INTO nxl_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Taue isa Yesus wain iatuhete mansiau roe Anahatana ne numa mainisie nene nusue. Wain isima na Sou Iake rerihoni Anahatana. Sira tau sio imam no sio mainaya, sio matuhete Musa ne maunauna, runa sio ona Yahudiu ohokaso mai tanui. ");
INSERT INTO nxl_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Oasau osiki ata, “Asau osima mai ee! Atuhete san rei na anei mansiau wasoni oahen noi Anahatana ne numa mainisie rei mo, sahoro asupu kawasa on supa? Ia seia irui kawasa osia rei?” ");
INSERT INTO nxl_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Oyo, Yesus iasau, iahata, “Munata san rei mo, nanie uasei tanumo ee! Oasau osiku mai! ");
INSERT INTO nxl_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohanis ia mamsohue mo, isohuso na mansiau oanei ata oarihoni no rosau nea. Isohuso runa Anahatana ne kawasa te mansiau no kawasa?” ");
INSERT INTO nxl_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Iasei pusi san rei oyo sio onata rei oasei mai umau. “Sani iahata, ‘Yohanis mo, isohu mansiau runa Anahatana ne kawasa,’ mka iasau honu ata, ‘Reiso omi nanie oparisaa tau Ia tewa tau sae?’ ");
INSERT INTO nxl_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ne sani iasau ata, ‘Isohu mansiau runa mansia ne kawasa’, mka mansia hutue reini orauta tau hatu rotu-tu imatata. Areimo, tau sio oata kan Yohanis mo, ia mamsima runa Anahatana ne maunauna isa rei oi.” ");
INSERT INTO nxl_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Reiso oasau ata, “Ami anei tewa.” ");
INSERT INTO nxl_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Oyo Yesus iasau osiso, “Munata san rei, Au iae upeneku uasau ia sia sahoro irui kawasa osiku na una rai pusire.” ");
INSERT INTO nxl_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesus iruni matieue isa osi sio panesi. Iasau ata, “Ia isa irahu anggur noi ne nisi. Oyo iseha ne nisi anggur rei osi sio umau osakai na osama nene huaya osiki. Pusi oyo ieu na pan nia hainau iruei pan rei potuina. ");
INSERT INTO nxl_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nene orase tau nanie okure anggur huaya, ia nisi anggur rei nene upue iaisosi ne ia manorine isa na ieui poe sio wason osaka ne nisi anggur rei. Iaisosiki na orui nisi upue ne pahakian oi. Ne sio wason osaka nisi rei ohita ia manorine rei oyo oaisosiki inuniki na hanai huie. ");
INSERT INTO nxl_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nta ia waini ne nisi anggur rei iaisosi ne manorine isa honu. Ne sio wason osaka nisi anggur rei ohitai na ouna pumaa ia manorine rei. Oyo oaisosiki inuniki runa hanai huia. ");
INSERT INTO nxl_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nta ia waini ne nisi anggur rei iaisosi ne manorine isa honu. Ne sio wasoni osaka nisi rei ohitai honu rotu ne apata. Oyo opesiki arihoni nisi anoe rei. ");
INSERT INTO nxl_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Reiso nisi anggur upue rei iasau pan anoi. Iahata, ‘Kahurae una sae honu? Nene iake mo, uaisosi anaku hanaie waini anoku runai nai osa! Kani mka oamuirai?’ ");
INSERT INTO nxl_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ne sio wasoni osaka nisi anggur rei onoo ia nisi anggur rei upue anai oyo oasau mai umau, ‘Ia reini sahoro mka isupu ia onate rei ne rusun na ne numa hutae pusiki. Mai na ihunui na ita sahoro isupu ia onate rei ne rusun na ne numa hutae rei.’ ");
INSERT INTO nxl_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Oyo onesai arihoni nisi anoe rei oyo ohunui. Reiso, nisi anggur rei upue mka iuna sae osi sio wason osaka ne nisi rei? ");
INSERT INTO nxl_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Mka inuniki mai ne nisi anggur rei oyo ihunu sio wason osakai rei. Ihunso oyo inina sio umau honu na osaka ne nisi okatiso.” Oatinu san rei pusi, sio wasoni noi rei oasau osi Yesus ata, “Ami mka auna tewa sani wan sio kahatena rei ounai rei!” ");
INSERT INTO nxl_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesus inooso oyo iasau ata, “Munata san rei mo, Anahatana iuna aia Daud ikanu tau ne Sura Kapatau isa mo, nene nohue sae? ‘Hatu isa wani sio tukana openeso tanui mo, muie reini reuna hatu tinipae wan ererime numa.’ ");
INSERT INTO nxl_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Hatu rei sani Au, Aia wain Anahatana Ihitiku na Uapuheu Mansiau. Ia sia man wain ipenei tanuku mo, noo sani sio wason oamnahuso poe hatu rei mka iakahatei. Na ia sia wain hatu rei rerorui mo, mka reesei na iakahatei nai osa.” ");
INSERT INTO nxl_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Pusi, oyo sio matuhete Musa ne maunauna na sio imam no sio mainaya oanei ata Yesus waimo iruni matieue rei mo, iruni rerihon sio. Reiso, tau rei sirinia, onina arena nanie osota Yesus. Ne okaitau sio hutue. ");
INSERT INTO nxl_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Sio matuhete Musa ne maunauna na sio imam no sio mainaya otarukira Yesus. Onina arena na osota Yesus sani iasau sae isa eresana. Reiso onina na osotai pusu sae wani iasau rei. Oaisosi sio umau na oakarota ata opusu Yesus runa anoo pusire. Aikee saka oaka-oakanin na Yesus. Oaka-akanin onina na Yesus iasau sae isa oyo osima nnai osi ia ona gubernur wain ne kawasa na osotai. ");
INSERT INTO nxl_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Sio wason saka oaka-akanin na Yesus rei oasei osiu-siu Yesus nanai. Oahata, “Ano ona matuhetene! Ami anei sae wani Ano asau na atuhetere reimo pusire manisata. Masike atuhete sio mainaya, atuhete manisate. Masike sio mainaya no suka me anamanaya rai tewa. Anini mansia mo, tewa. Ano atuhete Anahatana ne maunauna pusire manisata. ");
INSERT INTO nxl_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Reiso asau osima mai ee! Sani pusu Musa ne maunauna mo, isenu peau osi Ia Aia Mainae Roma mo, iake te tewa?” ");
INSERT INTO nxl_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ne Yesus ianei anoo kahatena rai. Reiso iasau osiso iahata, ");
INSERT INTO nxl_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Oatuhete kepen inate isa osiku mai ee! Mai kepen inate reini mo, ia sia siain wan tanui? Okanu ia sia ne nananake tanui?” Oasau osi Yesus. Oahata, “Ia Aia Mainae Roma.” ");
INSERT INTO nxl_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Iahata, “Munata san rei mo, rui osi Ia Aia Mainae Roma sae wan ne kawasa iainisiki. Na rui osi Anahatana sae wan ne kawasa iainisiki. Ia mo, inina na iatinu tanui, iainisi iainaa nnai.” ");
INSERT INTO nxl_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Oatinu san rei, osira hunu ruao. Tea mo, nanie osotai ne iasau sae isa resana tewa. Reiso oamaturuso man. Areimo tau Yesus iasau ne sou isa resana tewa nai osa noi mansia hutue rei uao anoa. ");
INSERT INTO nxl_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Taue isa sio ona Sadukiu umau ohokaso mai Yesus nanie oasei tanui. Sio ona Sadukiu mo, oparisaa tewa ata sio matana oamahaiso honu. ");
INSERT INTO nxl_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Oahata, “Ano Ona Matuhetene, Musa ikanu maunaune reini osima. ‘Sani ia hanai suanane isa imatai arihoni sahai ne isusu tewa, areimo wanin kahurae iausahai inana sahai wain iauhanui nea rei. Inanai na isusu osi kakai wain imatai nea rei.’ ");
INSERT INTO nxl_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Taue isa, sio hanaia kaka wan sio itu. Ia iki manonte iausahai inana ia pina isa ne osusu tewa. Oyo ereeu mai imatai arihoni sahai reiso iauhanui. ");
INSERT INTO nxl_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Oyo wanin wain ipusu-pusui inana kakai sahai rei. Ne isusu tewa oi. Oyo imatai honu. ");
INSERT INTO nxl_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Arei ereyari tau ia iki autihue waini ipusu-pusu ia ikine hanaie waini mato imatai rei oi. Reyari san rei sui osa rotu-tu ia iki hanaie muie tunne nai osa. Ia iae imatai oi. Ituso omataso ne osusu tewa. ");
INSERT INTO nxl_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ereeu mai tau muie, ia pina uhanu rei imatai oi. ");
INSERT INTO nxl_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Reiso sapan? Tau onone wani Anahatana iuna sio matana oamahaiso honu mo, mka ia pina uhanu reimo, sahai tau ia sia? Areimo tau iausahai inana sio kaka wani itu rei nea.” ");
INSERT INTO nxl_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Oyo Yesus iasau osiso, “Sio wason oamahaiso mai tuniai reini mo, oausaha onana umau. ");
INSERT INTO nxl_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ne sio wason Anahatana iasau ata sio manisata reiso mka oamahaiso honu na okatai roe noiyaha, mka oausahaso tewa nea. ");
INSERT INTO nxl_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Sio iae mka omata tewa nea. Omataso tewa sani Anahatana ne maisosia on roe noiyaha. Anahatana iuna sio manisata oamahaiso honu reiso wason ne hehuka nea. ");
INSERT INTO nxl_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Musa ikanu tau ne maunauna rerihoni sio matana oamahaiso honu. Ikanu rerihoni ai hutue wani usa reai tanui. Ihete Upui Anahatana wain Abraham, Isak, runa Yakup wason oainaa runai rei. ");
INSERT INTO nxl_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Sio matana oainaa nna Anahatana tewa. Ne sio wason oamahaiso sahoro oainaa nnai. Areimo tau, pusu Anahatana mo, ia sia man mo, iamahaiki. Reiso masike tau Musa ne naene Abraham, Isak, na Yakup omataso nea, Musa iasau ata wason oainaa na Anahatana asi. No inahau ramahaiso rakata Anahatana asi na oainaa na Anahatana.” ");
INSERT INTO nxl_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Oatinu san rei oyo, sio matuhete Musa ne maunauna umau oasau ata, “Ano ona matuhetene, sae wamo asaui reimo iake!” ");
INSERT INTO nxl_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Pusi rei, oyo ia sia man imoniki. Iasei reai tewa nea. ");
INSERT INTO nxl_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesus waini iatuhete oyo iasau. Iahata, “Sio umau oasau ata Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau mo, hasae aia Daud upui momoi. Ne oasau san rei mo, resana. ");
INSERT INTO nxl_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tea mo, naone ia aia Daud ruai ikanu rerihoni Ia Aia rei tau ne Sura Kapatau, ‘Anahatana iasau osi Upuku, Rue hae hanaku wanane ");
INSERT INTO nxl_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","rotu-tu aheta tau me nisau.’ ");
INSERT INTO nxl_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Reiso munata Daud ruai ioi Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau tau Upui sani Ia sahoro ia manaonete, reiso Ia mo, hasae Daud upui wain Ia muie man tewa.” ");
INSERT INTO nxl_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Sio panesi wasoni oatinu Yesus iatuhete. Oyo iasau osi ne mampusua. Iahata, ");
INSERT INTO nxl_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Oainati runa sio matuhete Musa ne maunauna. No suka oausahu papi naua waron marainia mai mui, na mansiau onoo ata sio mo, sio mainaya. Sio iae no suka oeuso sui sio manahenia naniao na mansiau oatapeaso. Sio iae saka oru-rueso roe uae sui karisaa mainaya. Sio mo, saka oru-rueso tau katerau waron sio mainaya orueso tanre noi ita Yahudiu re numa mananouna. ");
INSERT INTO nxl_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Sio mo, saka oakarota sio pina uhanu na onana no numa hutae. Oyo ouna ruao sani sio manisata. Reiso sani oainisi mo, no mainisie rei naue nai osa. Ne Anahatana mka iapasanaso mtinte nai osa.” ");
INSERT INTO nxl_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesus wairo Anahatana ne numa mainisie. Roe rei, inoo sio kupan kaya onusu kepen tau peti kepen waron orui osi Anahatana. ");
INSERT INTO nxl_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Yesus iae inoo ia pina uhanu mosokinie isa inusu kepen ikina ina ua man pan peti kepen rei na iruire osi Anahatana oi. ");
INSERT INTO nxl_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Oyo, Yesus iasau osi ne mampusua ata, “Atinu mai ia-ia nanie uasau osimo. Titue, sio kupan kaya mo, no kepen panesi ne orui mkane man osi Anahatana. Ne ia pina uhanu waini imosokiniki rei mo, irui osi Anahatana renesi sio pusiso wason orui osi Anahatana rei. ");
INSERT INTO nxl_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Areimo tau sio rei onusu no kepen nesia na oruire osi Anahatana. Ne ia pina uhanu mosokinie rei mo, ne kepen tau ne muaine onone ranie rei inusu pusire noi peti kepen na iruire osi Anahatana.” ");
INSERT INTO nxl_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Taue isa Yesus ne mampusua umau oanamana rerihoni Anahatana ne numa mainisie. Oahata, “Masi onoo ee! Anahatana ne numa mainisie reini mo, marainie nai osa! Ounai marainie tau hatu marainia na sae waron oruire osi Anahatana.” Ne Yesus iasau osiso. Iahata, ");
INSERT INTO nxl_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Sae man waron onoore tau numa mainisie reini, mka ranie hatae isa okuka Anahatana ne numa mainisie reini na hatu rai ratanuhaha tewa nea. Hatu rai rakukaso rarihoni nahaya.” ");
INSERT INTO nxl_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Oasei tau Yesus. Oahata, “Ano ona matuhetene. Sae waron Ano asau runare mo, inasa rayari? Na sani munata nanie rayari nea mo, nene kakinate wan sapan?” ");
INSERT INTO nxl_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesus iasau osiso, iahata, “Osaka ruamo ia-ia. Pene tu-tu mansiau oakarotamo rerihoni rai pusire. Mka sio panesi ohoka oasau ata, ‘Au mo, au Aia wain Anahatana Ihitiku na Uapuheu Mansiau.’ Mka sio umau honu oasau ata, ‘Tuniai nanie repena nea.’ Ne pene opusu sio rei. ");
INSERT INTO nxl_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Sani oatinu hapare rerihoni mansia onesi aiau runa manahitana mo, pene okaitau. Areimo tau kahurae reeu san rei naone. Ne, tuniai nanie repena mo, tewasi. ");
INSERT INTO nxl_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Mka niane isa osaa niane isa honu. Mka ia aia isa ieu iahita runa ia aia tamene isa honu. ");
INSERT INTO nxl_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mka isu mainaya sui supan-supan. Mka omata muaine sui supan man. Mka kupu inaya waron ranae rei, mka rekikasi sui supan man. Mansiau mka onoo kakinata waron mainaya roe nante. Mka onoo sae waron raunaso okaitau mainae. ");
INSERT INTO nxl_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ne mka osotamo, oyo ounamo sinsaramo. Mka ororimo noi sio Yahudiu no numa mananouna na oamanarumo. Mka onusumo pan pui. Mka ororimo noi sio aiau runa gubernur uao anoa. Sio ounamo san rei mo, noso opusu Au. Ounamo san rei samatoro sirakau rai pusire rayari. ");
INSERT INTO nxl_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Sae waron rayari rei mo, arena na osima rerihoni Au osiso. ");
INSERT INTO nxl_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ne oapamese anomo na pene anomo rauponu. Pene anomo rauponu runa mka sapani na oanamana nete ruamo oni rai pusire rayari tewasi. ");
INSERT INTO nxl_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Areimo tau Au ruaku sahoro mka unamo oanei sae waron iake runa sae waron iake tewa na oanei nanie oanamana sapan. Unamo san rei na mo nisau mka oanei tewa nanie oasau sapan. ");
INSERT INTO nxl_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mo mansia mainaya, kaka waniu, mo mansiau, runa mo netau wason oparisaa tau Au tewa iae, mka oahen omi wan opusu Au oi. Omi umau mo, mka ohunumo. ");
INSERT INTO nxl_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mka mansia pusiki openeso tanumo noso oparisaa tau Au. ");
INSERT INTO nxl_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ne mka omunamo tewa. Masike mo huau munu osa man iae, ohohui tewa. ");
INSERT INTO nxl_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Reiso, sani oapamese na opusu Au sui osa, mka Upuri iapuheumo na pene iapasanamo. Mka oamahaimo okatai rotu-tu ria supan.” ");
INSERT INTO nxl_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesus iasau osi ne mampusua ata, “Sani onoo sio tantara oo hori kota Yerusalem mo, kahurae oanei nea ata potuina tewa nea, kota rei nanie okohui nea. ");
INSERT INTO nxl_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Taa onoo san rei, kahurae omi wan oruemo pan otoe Yudea mo, orumamo na roe tinetaya nea. Na omi wan oruemo mai kota reini mo, oruma ohokamo nea. Omi wan oruemo sui niana-niana mo, pene oruma nusumo mai kota rei honu. ");
INSERT INTO nxl_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Areimo tau orase reimo, orase wan Upuri iapasana mansia pusiki wason oparisaa tanui tewa. Arai pusire mo, mka raeu sani naone Anahatana ne sio mamsima runa ne maunauna okanu tau no surata. ");
INSERT INTO nxl_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Tau rei mo, mka sio pina onata wason osusu no sio iki msinana runa sio pina matitiana mo, mka siraka tanso nai osa. Tea mo, oruma kua tewa. Mka sio mai otoe reini sinsaraso nai osa tau Anahatana iapasanaso. Mka iatuhete ata anoi remotoi na sio wason orueso mai otoe reini. ");
INSERT INTO nxl_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mka sio ohunu sio umau tau tunue. Sio umau honu, mka osotaso oyo ororiso sui niana-niana neka tuniai reini. Sio rakana wason oationa Anahatana tewa mka ohoka oheta tau kota Yerusalem na orimei. Orimei rotu-tu orase wani Anahatana iaunutui na irimeso rei renikui.” ");
INSERT INTO nxl_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yesus iasau osi ne mampusua iahata, “Tau nanie uhokaku mai tuniai reini honu, mka nene kakinata waron mka onoore roe nante. Mka onoore roe ranie, hunane, na oneu. Mka mai tuamane, sio niana-niana okaitau hun ruao. Mka anoo rauponu tau oatinu nuae, onoo kolau onata. ");
INSERT INTO nxl_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Okaitau hun ruao rotu-tu sira tanuso onapa onoo mka tuniai sapan. Okaitau noso onoo ranie, hunane, runa oneu rakoka roe nante. ");
INSERT INTO nxl_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tau orase rei sirinia mka mansiau onoo Au Tumata Reini mo, Anahatana Ihitiku uhokaku on roe nante pani yahu anoe. Mka ukaisunu runa we rinane reita-itai runa we kawasa mainae. ");
INSERT INTO nxl_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Taa onoo kakinata rai nanie rayari nea, kahurae oparisaa na oapamese kuru anomo. Areimo tau nene orase tau Upuri iapuheumo na pene sinsaramo haineke nea.” ");
INSERT INTO nxl_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Pusi, oyo Yesus iruni matieue isa osi ne mampusua. “Masi onoo ai ara ia-ia. Te onoo ai sae man. ");
INSERT INTO nxl_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Taa nene totua rasineu mo, areimo kakinate. Rekakina na anei ata nanie naene na irahuta nea. ");
INSERT INTO nxl_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Sani inoo ai ara totua rasineu nea mo, ianei ata Anahatana nanie irime ne mansiau nea. ");
INSERT INTO nxl_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Atinu mai ia-ia nanie asau osimo. Titue! Sae waron mato uasau runare osimo reini, mka rayari oni omi naene rei omata tewasi. ");
INSERT INTO nxl_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nante runa tuniai reini mka ranikuso, ne Au we anamanaya mka ranikuso tewa.” ");
INSERT INTO nxl_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yesus iasau osi ne mampusua ata, “Osaka ruamo ia-ia. Pene tu-tu sira tau uhokaku honu mo, omi wani pataparimo tau maise onata, oninu omukemo, na orue anomo rauponu na mo muaine mo apia. Tea mo, mka uhokaku honu mai tuniai reini, osira. Osira nooi sani maianane rei reasira heune. ");
INSERT INTO nxl_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sio pusiso mai tuniai reini mo, mka osira tau uhokaku honu. Tea mo, ia sia man mka iauhuniki arihoni Au tewa. ");
INSERT INTO nxl_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Reiso, omi mo, kahurae osaka ruamo ia-ia sui osa. Oainisi na oamkona oapamese sani rai pusire rayari. Oainisi na oo okaitau tewa sani onoo Au Tumata Reini mo, Anahatana Ihitiku.” ");
INSERT INTO nxl_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tau minku unue rei, tau ranie Yesus saka ieu iatuhete mansiau noi Anahatana ne numa mainisie nene nusue. Tau pumono, Yesus ieu inekei roe pupue wani nanae Saitun. ");
INSERT INTO nxl_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","On punanoe mo, sio panesi oeuso roe Anahatana ne numa mainisie. Oeuso roe nanie oatinui iatuheteso. ");
INSERT INTO nxl_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Karisaa sio Yahudiu oai poroti wan resaa tewa haineke nea. Sio ooi karisaa rei tau karisaa anoo rapeka na Anahatana ihoka noa upu momou arihon otoe Mesir. ");
INSERT INTO nxl_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Sio imam no sio mainaya runa sio matuhete Musa ne maunauna wason onina arena na ohunu Yesus mene-mene man. Tea mo, okaitau sio panesi mka onesiso. ");
INSERT INTO nxl_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Taa wason onina arena nanie ohunu Yesus, ia aia sakahatene iamasuni Yudas. Yudas mo, ia on pan nia Kariot. Yudas iae, ia isa arihoni Yesus ne mampusua hutusa rahana ua rei oi. ");
INSERT INTO nxl_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Oyo Yudas ieu noi sio imam no sio mainaya runa sio mainaya tau sio mamsaka Anahatana ne numa mainisie. Hoka mai nanie ihunu sou nnaso. Ihunu sou nnaso rerihoni sapani na iahen Yesus osiso. ");
INSERT INTO nxl_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Reiso anoo mirika. Ototoe ata “Mka arui kepen osia sani arori Yesus osima.” ");
INSERT INTO nxl_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudas iamanaku. Reiso inina arena na irui Yesus osiso. Ne onina na pene sio panesi oanei. ");
INSERT INTO nxl_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pannuhu karisaa sio Yahudiu oai poroti wan resaa tewa nea. Reiso kahurae orehi rompa tau karisaa anoo rapeka na Anahatana ihoka noa upu momou arihon otoe Mesir. ");
INSERT INTO nxl_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Reiso Yesus iaisosi Petrus runa Yohanis. Iahata, “Mai na oeu na oseka tau re muaina tau karisaa reini.” ");
INSERT INTO nxl_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ne oasei, “Upu. Seka tau re muaina sui supa?” ");
INSERT INTO nxl_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Iahata, “Uamo oeu roe kota Yerusalem. Mka onusu kota onoo ia hanaie isa iasaoa tihu naniae wani nanae unene. Oeu opusui. Mka inusu numa isa. ");
INSERT INTO nxl_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ohoka noi, oyo oasei tau numa upue rei. Oahata, ‘Upu. Mani ia matuhetene inina kamar wan nanie iai ikata ne mampusua. Nanie iai tau karisaa anori rapeka na Anahatana ihoka rea upu momou arihon otoe Mesir. Reiso kamar na iaiki wanpa?’ ");
INSERT INTO nxl_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mka iautuu runa kamar isa roe naue wan mainae. Katerau runa pusire waroro matane nea. Seka tau pusire roe rei nea.” ");
INSERT INTO nxl_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Reiso Petrus runa Yohanis uaso oeu. Ohoka roe oyo onoo pusire waron Yesus iasau runare rei pannuhu. Reiso oseka tau muai karisaa rai. ");
INSERT INTO nxl_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nene mono rei pannuhu karisaa nene orase na oaiso, Yesus irue iaiki ikata ne maisosia. ");
INSERT INTO nxl_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Iahata, “Anoku ererihu mainae, nanie uai muai karisaa reini ukatamo on sinsaraku tewasi reini. ");
INSERT INTO nxl_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Uasau osimo. Au mka uai muai karisaa reini tewa nea oni Anahatana irime ne mansiau tewasi na ne mansiau oanei ata muai karisaa reini rekakina ata Anahatana iusi no rosau.” ");
INSERT INTO nxl_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iasau pusi san rei oyo inana koinanae wani taue tau tihu anggur oyo iainisi iake arihoni Anahatana. Oyo iahata, “Onana koinanae rei noi na oninu osama-samai osi umau. ");
INSERT INTO nxl_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Atinu mai ia-ia nanie uasau osimo. Oni reini, Au mka uninu tihu anggur tewa nea rotu-tu Anahatana irime ne mansiau.” ");
INSERT INTO nxl_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ita inana poroti huae oyo iainisi iake arihoni Anahatana. Iainisi pusi oyo ikiho poroti huae rei, isama-samai, oyo iruiki osiso. Iahata, “Poroti reini mo, Au tinaiku tau kakinate osimo. Urui tinaiku na ohunuku na usi mo rosau. Saka oai poroti reini na anomo rapeka-peka runaku.” ");
INSERT INTO nxl_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Oai pusi ita san rei honu. Inana koinanae honu iahata, “Tihu anggur reini mo, Au nasiku tau kakinate ata Anahatana itotoe runa sae isa wan honue honu. Itotoe honue reimo, mka we nasi reroti na Au usi mo rosau. ");
INSERT INTO nxl_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ne ia isa wain iaheniku osi we nisau. Ia reimo wain iruei iaiki ikataku. ");
INSERT INTO nxl_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tea mo, Au Tumata reini mo, Anahatana Ihitiku mo, mka umataku sani Anahatana iaunutui rei. Ne ia wain iaheniku osi we nisau mo, mka siraka tanui.” ");
INSERT INTO nxl_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Oatinu san rei, oyo oasei mai umau. Oahata, “Ia seia rei? Ia seia sahoro wain iruiki rei omi?” ");
INSERT INTO nxl_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yesus runa ne mampusua wason orue oaiso asi, oyo ne mampusua otuntana runa umau rerihoni ia seia sahoro ia mainae nai osa. ");
INSERT INTO nxl_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Oyo Yesus iasau osiso iahata, “Sio aiau arihoni niana-niana waron oationa Anahatana tewa mo, orime no mansiau pusu ruao no maue. Orime kawasa mtinte ne oaoi ruao tau ‘makahai nusa niane’. ");
INSERT INTO nxl_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ne omi mo, pene ouna san rei. Ia seia arihoni omi wain ia mainae mo, kahurae iuna tumata ikine honue na ianori runa mansia. Noo sani sio wason no sae isa tewa. Omi wan omi mainaya mo, kahurae anomo runa ia seia man. ");
INSERT INTO nxl_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Reiso pusu omi mo, ia seia sahoro ia mainae? Ia wain iruei iaiki te ia wain ianori isaka nasae? Nene manisate mo, ia wain irue iaiki sahoro ia mainae tea! Ne Au wani ukatamo mo, uanori runamo. ");
INSERT INTO nxl_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Omi reini sahoro okataku sui osa. Sinsaraku iae, okataku sui osa. ");
INSERT INTO nxl_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Reiso urui kawasa osimo. Amaku irui kawasa osi Au na una Aia urime we mansiau. Oyo Au urui kawasa osi omi oi ");
INSERT INTO nxl_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","na orue okataku tau meya osa na iai ininu ikata umau. Na urui kawasa osimo na orime sio ipana hutusa rahana ua mai otoe Israel.” ");
INSERT INTO nxl_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesus wain iruei iaiki ikata ne mampusua asi. Oyo ianamana osi Petrus. Iahata, “Simon, atinu ia-ia! Ia aia sakahatene wain ireamo na ineamo arihoni Au. Areimo, noo sani sio orei ana na onea kitataia arihoni ana rei. ");
INSERT INTO nxl_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ne, Simon, uainisi osia nea na aparisaa tanuku sirinia. Reiso mka ireaya suka, aparisaa tanuku honu, saka aunau mea kaka waniu wason oparisaa na oparisaa mainae honu.” ");
INSERT INTO nxl_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Oyo Petrus iahata, “Upu, masike sapan iae, au mo, mka upusua rotu-tu unusu pui. Upusua rotu-tu umataku ukataya.” ");
INSERT INTO nxl_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Oyo Yesus iahata, “Petrus, uasau osia. Mka-mka mono repan, manue retunkeko tewasi oi mo, ano auhaa nai tonu nea ata ationaku.” ");
INSERT INTO nxl_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Oyo Yesus iasei tau ne mampusua. Iahata, “Naone uaisosimo oeu oaunau sio niana-niana mo, usopomo na pene orori kepen, tasi maiinu apia, te sandali. Oni orori sae isa tewa areimo, oahana sani onina sae isa te tewa?” Pusiso oahata, “Tewa, Upu!”. ");
INSERT INTO nxl_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Iahata, “Ne muie reini sio umau oakahaimo tewa. Reiso sani mo kepen waromo mo, ororire. Sani mo tasi maiinu apia waromo, roriki. Sani mo tunu naue tewa, ahen mo papi naue na ohanei. ");
INSERT INTO nxl_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tea mo, ia mamsima runa Anahatana ne anamanaya ikanu rerihoni Au nea. Reiso rei kahurae ereeu sani sae wan iasaui rei. Ikanu, ‘Ounai sani Ia mo, Ia kahatene.’ Reiso nanie ouna Au sani Au kahatene.” ");
INSERT INTO nxl_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Oyo Yesus ne mampusua oahata, “Upu. Noo mai. Tunua ua waron nea reini!” Iahata, “Hasae rei nea. Pene ianamana rerihoni tunua nea!” ");
INSERT INTO nxl_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesus ieu ikata ne mampusua roe pupue wani nanae Saitun. Yesus mo, saka ieui roe rei sui osa. ");
INSERT INTO nxl_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Hoka roe, oyo iasau osi ne mampusua iahata, “Oainisi tau Anahatana na iakahaimo na pene ia aia sakahatene ireamo na opalalosa.” ");
INSERT INTO nxl_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Iasau pusi, oyo ieu hainau mkane arihoni ne mampusua. Kani meter hutu tonu. Oyo irike tune iainisi. Iahata, ");
INSERT INTO nxl_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ama, uainisi arihonia na sani me maue mo, mai na pene sinsaraku. Ne apusu ruam me maue. Pene pusu Au we maue.” ");
INSERT INTO nxl_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Oyo sira tau Anahatana ne maisosie on roe noiyaha isa ihokai mai tanui na iuna kua anoi. ");
INSERT INTO nxl_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ne Yesus anoi mtinte nai osa reiso iainisi runa anoi pusiki. Iainisi rotu-tu iakausa hunu ruai. Ne kausa wanaya rei mo, rotu-tu noore sani nasi utua ramnahu poe tuamane. ");
INSERT INTO nxl_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Taa iainisi pusi, oyo ihitio inuniki poe ne mampusua honu. Hoka poe isupuso mo, pusiso wasupo onekeso. Onekeso tau resunso na anoo rapunoko ruao nai osa. ");
INSERT INTO nxl_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Oyo Yesus iasau osiso, iahata, “Omi mo, pene onekemo nea. Hanu na oainisi tau Anahatana na iakahaimo na pene ia aia sakahatene ireamo na opalalosa.” ");
INSERT INTO nxl_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesus wain ianamana osi ne mampusua asi, oyo sira tau sio panesi ohokaso mai tanso. Yudas iautunso. Yudas mo, ia isa arihoni Yesus ne mampusua hutusa rahana ua rei. Hoka mai oyo ieu haineke Yesus nanie imukiki. ");
INSERT INTO nxl_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ne Yesus iasau osiki. Iahata, “Yudas! Nanie amukiku reini mo, nanie ahen Au Tumata Reini mo, Anahatana Ihitiku osi sio wason osotaku si?” ");
INSERT INTO nxl_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Taa Yesus ne mampusua onoo ata sio nanie osota Yesus, oahata, “Upu, anina na aroto rohaso tau ma tunua raini?” ");
INSERT INTO nxl_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ne sira tau Yesus ne mampusue isa iroto roha ia isa tinai ukune hae wanane. Ia rei mo, sio imam no ia mainae ne manorine isa. ");
INSERT INTO nxl_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ne Yesus iasau osiso. Iahata, “Hasae rei nea!” Oyo Yesus iakahuu ia rei tinai ukune oyo ia rei tinai ukune iake honu. ");
INSERT INTO nxl_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pusi oyo Yesus ianamana osi sio wason ohokaso nanie osotai rei. Sio reimo, sio imam no sio mainaya, sio onata arihoni sio wason osaka-saka Anahatana ne numa mainisie, runa sio ona Yahudiu. Iahata, “Omi ata kani Au mo, Au kahatene si? Tu-tu ohokamo orori tunua na kahitata nanie osotaku si? ");
INSERT INTO nxl_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Aikee onon ranie ukatamo pan Anahatana ne numa mainisie, ne osotaku tewa. Ne onon hatae repan samato nanie osotaku. Tau onon hatae reipan, ia aia sakahatene waini iatuhete ne kawasa.” ");
INSERT INTO nxl_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sio mamsaka Anahatana ne numa mainisie osota Yesus oyo ororiki poe sio imam no ia mainae ne numa. Petrus ipusu Yesus on ria hainau. ");
INSERT INTO nxl_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kua numa rei tihue wan oainatai tewa mo, oamanou usa mainae kua tihue. Sio umau orue ohori usa rei. Reiso Petrus ieu poe, irue ikataso. ");
INSERT INTO nxl_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ia pina makahaie isa inoo Petrus irue haineke usa rei. Oyo ia pina onate rei iariniiki. Oyo iahata, “Ia reini iae sinasi ikata-katai oi!” ");
INSERT INTO nxl_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ne Petrus iahata, “Tewa, ina! Au mo, uationa Ia rei tewa!” ");
INSERT INTO nxl_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Potuina tewa oyo ia isa honu inoo Petrus honu oyo iahata, “Ano mo, ia isa arihoni sio tea!” Ne Petrus iahata, “Tewa! Au mo, tewa!” ");
INSERT INTO nxl_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ita reruma yam osa reniku oyo ia isa honu inooi. Iahata, “Titue! Ia reini mo, ikatai! Ianamana sani ia on pan otoe Galilea.” ");
INSERT INTO nxl_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ne Petrus iahata, “Ano wamo anamana me sae rei? Au mo, uanei tewa.” Oyo sira tau manue retunkeko. ");
INSERT INTO nxl_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Oyo Upuri Yesus iuni inoo Petrus samatoro Petrus anoi repeka runa Yesus ne anamanae. Iahata, “Mka-mka mono repan, manue eretunkeko tewasi oi mo, ano auhaa nai tonu nea ata ationaku.” ");
INSERT INTO nxl_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Taa san rei oyo Petrus ihokai arihoni numa rei oyo irani rotu-tu iamseku makarante. ");
INSERT INTO nxl_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Sio mamsaka Anahatana ne numa mainisie wason osaka Yesus rei ouna pumaa Yesus na ohitai. ");
INSERT INTO nxl_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Okanihoo nete Yesus matai usena samatoro oasau osiki. Oahata, “Ano asau ata ano mo, Anahatana ne ia mamsima runa ne maunauna. Reiso asima mai, ata kani ia seia ihitaya rei.” ");
INSERT INTO nxl_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ouna pumaai tau sou nita-nitaya panesi honu. ");
INSERT INTO nxl_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nene omnanoe tunne san rei, sio siniriu oamanouso. Sio reimo, sio imam no sio mainaya na sio matuhete Musa ne maunauna. Oamanouso, oyo sio mamsakaya orori Yesus mai tanso. ");
INSERT INTO nxl_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Oyo sio onata rei oasei tanui. Oahata, “Sani munata Ano mo, Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau mo, asau osima mai.” Oyo Yesus iahata, “Sani uasau osimo iae, mka oparisaa tanuku tewa sirinia. ");
INSERT INTO nxl_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Na sani uasei tanumo rerihoni Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau, omi mka osana tanuku tewa. ");
INSERT INTO nxl_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ne potuina tewa nea, Au Tumata Reini mo, Anahatana Ihitiku, urueku hae Anahatana wain ne kawasa mainae renesi pusire rei hanai wanane.” ");
INSERT INTO nxl_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Pusiso oasei, oahata, “Munata san rei, Ano reini mo, Anahatana Anai si?” Yesus iahata, “Omi ruamo sahoro oasau ata Au mo, Anahatana Anai.” ");
INSERT INTO nxl_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Oyo oahata, “Reiso pene susa nina sio umau wason onoo tau matao nea. Ita ruari iatinu arihoni Ia ruai nea reini!” ");
INSERT INTO nxl_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Sio onata arihoni akama Yahudi oapisara runa Yesus pusi oyo pusiso ororiki poe gubernur wain nanai Pilatus. ");
INSERT INTO nxl_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Hoka poe, oyo oamanaru Yesus. Oahata, “Upu! Asupu Ia reini iatuhete ma mansiau na onesi kupania mai ma otoe. Isoposo na pene osenu peau osi Ia Aia Mainae Roma. Iasau ata Ia mo, Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau. Na iasau ata Ia mo, Ia Aia.” ");
INSERT INTO nxl_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Reiso Pilatus iasei tau Yesus. Iahata, “Titue si? Ano mo, sio Yahudiu no ia Aia si?” Yesus iahata, “Ano sahoro asau tea.” ");
INSERT INTO nxl_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Oyo Pilatus iasau osi sio imam no sio mainaya runa sio panesi rei, “Usupu ne isanae isa tewa.” ");
INSERT INTO nxl_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ne otentene sirinia. Oasau ata, “Ia reini iatuhete iakanihu sou na ma mansiau onesi kupania sui otoe Yudea pusiki. Iuna san rei on pan otoe Galilea asi.” ");
INSERT INTO nxl_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatus iatinu sio oasau ata Yesus iatuhete iakanihu sou on pan otoe Galilea oyo iasei, “Reiso Ia reini mo, Ia on pan otoe Galilea si?” ");
INSERT INTO nxl_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Oahata, “E-e. Ia reini mo, Ia Galilea.” Pilatus iatinu ata Ia on pan otoe wan Aia Herodes irimei, oyo iahata, “Munata san rei, ororiki poe Herodes. Tau ia mo, wain mai kota Yerusalem.” ");
INSERT INTO nxl_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Gubernur Pilatus iaisosiso orori Yesus poe Aia Herodes oyo oeu ororiki. Herodes mo, iatinu sio oruni rerihoni Yesus panesi nea. Reiso taa inoo Yesus, oyo anoi miri-mirike. Areimo tau inapa potuina nea na nanie inoo Yesus. Nanie inooi iuna sima-simane. ");
INSERT INTO nxl_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Reiso iasei panesi arihoni Yesus. Ne Yesus iamaturui mani. ");
INSERT INTO nxl_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tau rei, sio imam no sio mainaya runa sio matuhete Musa ne maunauna oapasanai mtinte renesi honu. ");
INSERT INTO nxl_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Oyo Herodes runa ne tantarau oataenai oaumaniki. Oyo oausahu papi aia osiki, samatoro Herodes iaisosiso ororiki poe Pilatus honu. ");
INSERT INTO nxl_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herodes runa Pilatus mo, oi nisa tau umau. Ne tau rei sirinia, uaso oi neta tau umau. ");
INSERT INTO nxl_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Oyo Pilatus iamanou sio imam no sio mainaya, sio onata, runa sio panesi rei. ");
INSERT INTO nxl_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Iahata, “Orori ia reini osi au, na oasau ata, ‘Ia reini iatuhete ma mansiau na onesi kupania.’ Ne ruamo onoo, uasei tanui ne usupu ne isanae isa tewa sani an oapasanai rei. ");
INSERT INTO nxl_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes ruai san rei iae, isupu Yesus ne isanae isa tewa. Reiso iuniki mai ami honu. Omi onoo Yesus iuna isanae isa tewa reiso uapasanai rotu-tu imatai iake tewa. ");
INSERT INTO nxl_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Reiso mka uaisosi sio osapui oyo oalapasiki mana.”  ");
INSERT INTO nxl_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilatus iasau san rei tau ia mo, sani pusu maunaune, kahurae pannuhu karisaa rei ialapasi ia isa waini inusu pui rei. ");
INSERT INTO nxl_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ne sio panesi wason oamanouso pan rei pusiso oakapona oahata, “Hunui! Alapasi Barabas osi ami mai!” ");
INSERT INTO nxl_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas mo, inusu pui noso iuna mansia panesi onesi kupania mai kota Yerusalem reini. Ihunu ia isa oi. ");
INSERT INTO nxl_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ne Pilatus nanie ialapasi Yesus sirinia. Reiso, iuni iasau osi sio panesi wasumo rei. Iahata, “Ne isanae isa tewa. Uhunui iake tewa!” ");
INSERT INTO nxl_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ne pusiso oaka-kapona oahata, “Pakui roe hini wan reniene! Opakui roe hini wan reniene!” ");
INSERT INTO nxl_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Oyo Pilatus iasau osiso honu. Nai tonu nea. Iahata, “Pakui roe hini an reniene tau sae? Usupu ne isanae isa tewa. Iuna sae isa tewa na uapasanai tu-tu imatai. Reiso mka uaisosiso osapui oyo ualapasiki honu.” ");
INSERT INTO nxl_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ne oakapona mainae renesi honu. Oahata, “Pakui roe hini an reniene! Paku roe hini wan reniene!” Oaka-kapona sui osa rotu-tu Pilatus ikua tewa nea. ");
INSERT INTO nxl_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Reiso, ipusu no maue. ");
INSERT INTO nxl_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Iaisosiso oalapasi Barabas pusu sio panesi rei no maue sirinia. Barabas wain inusu pui noso iuna mansia panesi onesi kupania rei. Wain ihunu mansia. Oyo Pilatus irui Yesus osi sio panesi rei na ounai pusu ruao no maue. ");
INSERT INTO nxl_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sio tantarau orori Yesus na opakui roe hini wan reniene. Wason oeu oyo, mai arena tihue, sira tau oapamese ia hanaie isa. Ia hanaie rei mo, nanai Simon. Ia mo, on pan kota Kirene. Mato ihokai on pan niane isa haineke kota Yerusalem. Sio otentenei na ihana Yesus ne hini wan reniene rei. Oyo ieu pusu-pusu Yesus hae muie. ");
INSERT INTO nxl_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Sio panesi iae oeu pusu-pusui hae muie oi. Sio pinau umau wasumo oi. Sio pinau rei mo, orani oapunoko Yesus. ");
INSERT INTO nxl_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesus iuni iasau osiso. Iahata, “Om pina Yerusalem, pene orani na Au! Ne orani na ruamo na mo sio ikina. ");
INSERT INTO nxl_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tau mka pannuhu nene orase rei oi, Anahatana mka iapasana mo kota reini. Mka oasau ata, ‘Anahatana irui iake osi sio pinau wason okaimenso na sio pinau wason osusu sio ikina tewa nai osa.’ ");
INSERT INTO nxl_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mka oasau osi tinetaya ata, ‘Mai na esema!’ Na oasau tau pupua ata, ‘Mai na sonama!’ ");
INSERT INTO nxl_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Usana tewa. Ne Anahatana itapiso ounaku san reini. Reiso oanei ata mka iapasana sio wason opalalosa mainae nai osa.” ");
INSERT INTO nxl_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Sio hanai tamena ua wasumo oi. Sio hanaia ua rei mo, sio kahatena. Sio tantarau orori uaso okata Yesus na nanie opaku hunuso roe hini wani reniene oi. ");
INSERT INTO nxl_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ohokaso roe naniake isa wani nanae Unuke Kanie. Oyo opaku Yesus roe hini wan reniene. Opaku sio kahatena ua rei oi tau no hiniu waron raniene. Oapuoo ia isa hae Yesus hanai wanane na ia isa honu hae Yesus hanai pante. ");
INSERT INTO nxl_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Oyo Yesus iainisi iahata, “Ama! Pene apasana sio wason ohunuku reini. Areimo, tau oanei tewa ata Au reini mo, Au seia.” Pusi oyo, tantarau rei orehi katoite na nanie osama-sama Yesus ne apia waron onosure arihoni Yesus tinain rei. ");
INSERT INTO nxl_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Sio panesi wasumo ooso oasumata. Sio mainaya arihoni akama Yahudi iae wasumo oataena Yesus oahata, “Iapuheu mansia tamena. Reiso, munata Ia mo, titue Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau wain Anahatana ininiki, areimo, tapiki na iapuheu ruai.” ");
INSERT INTO nxl_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sio tantarau rei oataena Yesus oi. Nanie ounai ininu tihu anggur wan maninue. ");
INSERT INTO nxl_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Oasau ata, “Munata titue Ano mo, sio Yahudiu no Ia Aia mo, apuheu ruam!” ");
INSERT INTO nxl_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Oakatana ai inate roe Yesus unui hahae. Okanu tau ai otoe rei ata, “Natu tau sio Yahudiu.” ");
INSERT INTO nxl_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ia hanai kahatene isa wain sio opakui oyo oapuooi haineke Yesus irati sohi Yesus oi. Iahata, “Munata Ano mo, Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau mo, apuheu ruam na ami ua reini oi!” ");
INSERT INTO nxl_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ne ia hanai kahatene isa honu iasau osi ne neta rei ata, “Ano mo, akaitau Anahatana tewa si? Ita reini iae wan oapasanata. Opakuta na imatata nooi sani Ia oi! ");
INSERT INTO nxl_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ita ua reini mo, kahurae sio paku hunta na imatata tau iuna kahatene mainae. Ne ia onate reini mo, isana tewa.” ");
INSERT INTO nxl_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Oyo iasau osi Yesus iahata, “Yesus ee! Sani auna Aia arime me mansiau nea mo, anom repeka runa au reini na anom runaku ee!” ");
INSERT INTO nxl_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesus iasau osiki. Iahata, “Atinu mai ia-ia nanie asau osia. Titue, rahata reipan oi mo, akataku roe noiyaha.” ");
INSERT INTO nxl_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ranie katopu san rei, otoe rei repumonoi pusiki rotu-tu yam tonu ranie remanu. ");
INSERT INTO nxl_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Areimo tau ranie resita tewa. Oyo nipa kapitorune naue wan sio oakatanai roe Anahatana ne numa mainisie anoe na renete kakarana monne rei, wakihai tau ua on roe rurue rotu-tu poe rurue. ");
INSERT INTO nxl_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Oyo Yesus iakapona nioi mainae iahata, “Ama ee! Urui nahaku osia nea.” Iasau pusi san rei oyo nahai watipusiki. ");
INSERT INTO nxl_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ia kapitane tau sio tantara Roma utun inoo Yesus imatai sapan, iainaa na Anahatana. Iahata, “Ia onate reini mo, titue-tue ia mo, iamanisa maa!” ");
INSERT INTO nxl_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Sio panesi wason ohoka oasumata sio ohunu Yesus rei, onunso oroho unuo mataya tau oatamisi nai osa. ");
INSERT INTO nxl_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ne Yesus ne netau mo, ooso oasumata on hainau man. Sio pinau wason oeu pusui on poe otoe Galilea rei iae ooso oasumata on hainau man. ");
INSERT INTO nxl_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ia hanaie isa nanai Yusup. Ne kota nanae Arimatea. Kota rei mo, wapan otoe Yudea. Yusup mo, ia wain ne hali iake mainae. Iamanisa. Wain inapa-napa Anahatana irime ne mansiau. Ia mo, ia osa arihon sio ona Yahudiu. Ne ohunu Yesus mo, iamanaku tewa. ");
INSERT INTO nxl_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Reiso ieu roe gubernur Pilatus iainisi Yesus hatai na ieu iautotui. ");
INSERT INTO nxl_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pusi oyo, Yusup ieu irati Yesus hatai arihon hini wani reniene rei. Oyo iopai tau nipa ohie. Oyo, Yusup irori Yesus tinain hatai rei oyo iaunutui pani kupuro. Kupuro rei mo, okaniki pani hatu anoe. Kupuro rei mo, honue asi. Sio umau oaunutu matane pan anoe tewasi. ");
INSERT INTO nxl_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ranie hatae rei mo, sio Yahudiu wason oseka tau no muaina na oaunutu noi no numau tau hanroe oatanunu tewa. Tea mo, nene pumono reipan, no ranie hatae wani oamuira Anahatana nea. ");
INSERT INTO nxl_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Sio pinau wasoni opusu Yesus on pani otoe Galilea rei oeu pusu Yusup hae totui. Reiso onoo Yesus ne kupuro na onoo oaunutu Yesus tinain hatai pani kupuro rei sapan. ");
INSERT INTO nxl_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Onoo san rei pusi, oyo pusiso onunso. Hoka poe oyo, oamanou mina hau rihua na mina hau rihue wan nanae mur tau nanie oauhene Yesus tinain hatai tanure. Oyo oaranahaso. Tea mo, ranie hatae wan sio Yahudiu oamuira Anahatana. Oaranahaso oamuira Anahatana rei erepusu Musa ne maunauna. ");
INSERT INTO nxl_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tau onone mataanoe arihoni minku unue rei, nene on punano tunne, sio pina onata wason opusu Yesus on pan otoe Galilea oeuso pan Yesus ne kupuro. Orori mina hau rihua waron ruao oamanoure nea rei. ");
INSERT INTO nxl_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Hoka mai kupuro rei, sira tau osupu hatu onate wan renete kupuro rei, okamauniki nea. ");
INSERT INTO nxl_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Oyo onususo pan kupuro rei anoe. Ne osupu Upuri Yesus hatai pan rei tewa nea. ");
INSERT INTO nxl_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Oyo pusiso ooso pan rei na oaparina. Sira tau sio ua ooso mai nusuo. No apia rakino-kinoso. ");
INSERT INTO nxl_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Reiso okaitau hun ruao. Oyo ohahue na poe tuamane. Oyo sio ua rei oasau osiso oahata, “Nanie onina ia wain iamahaiki mai sio wason omataso nea reini tahae? ");
INSERT INTO nxl_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ia mo, wain rei tewa nea. Ia mo, iamahaiki honu. Ne anomo rapeka runa ne anamanae wan iasau nnai osimo on ikatamo poe otoe Galilea asi rei. ");
INSERT INTO nxl_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Au, Tumata reini Anahatana Ihitiku mo, mka sio oruiku osi sio wasoni opalalosa na opakuku roe hini wan reniene. Ne mka nene onona ua pan, oyo uamahaiku honu.’” ");
INSERT INTO nxl_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Oyo sio pina onata rei anoo rapeka-peka na ne anamanaya waron iasau nnare nea rei. ");
INSERT INTO nxl_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Taa onunso on pani kupuro oyo, oruni na sae wan oatinui na onooi pan rei osi Yesus ne maisosia hutusa rahana osa rei na sio pusiso wason saka opusui. ");
INSERT INTO nxl_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Sio pina onata rei wason sahoro oruni osi ne maisosia mo, Maria Magdalena, Yohana, Maria Yakobis inai, na sio pina onata umau oi wason saka okata-kata umau. ");
INSERT INTO nxl_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ne Yesus ne maisosia rei oparisaa tewa tau sae waron sio pina onata rei oasau nnare rei. Oata kani oruni oakarota man. ");
INSERT INTO nxl_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Taa san rei oyo, Petrus ihanui oyo ihitio irumai na pan Yesus ne kupuro. Ihokai pan, oyo ikanahata na iakanin na pan Yesus ne kupuro anoe. Ne taa hasae inoo nipa iake nene sinta man. Isira hun ruai. Oyo inuniki na anoi rerue mosa tewa tau ianei tewa ata Yesus tinain hatai wani sui supa. ");
INSERT INTO nxl_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tau onone wan Anahatana iuna Yesus iamahaiki honu, Yesus ne mampusua ua nanie oeuso na poe niane isa. Niane rei mo, nanae Emaus. Nene hainau arihoni kota Yerusalem mo, kani mka nene kilou hutusa rahana osa san rei. ");
INSERT INTO nxl_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Uaso wason oeu oana-anamanaso rerihon Yesus. Uaso oasau osi umau na sou anamanaya waron mtinta tau mui-muie reini. ");
INSERT INTO nxl_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Uaso wason oana-anamanaso, sira tau Yesus ruai ihokai mai tanso. Oyo tonso oeu okata umau. ");
INSERT INTO nxl_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Uaso onoo Yesus, ne nooi sani sae isa reunaso rotu-tu oationai tewa. ");
INSERT INTO nxl_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Oyo Yesus iasei tanuso ata, “Uamo wamo oanamana rerihoni sae reno mai arena tinain tihue reini?” Oatinu san rei oyo, uaso oaraoo rei sirinia. Uao anoa man-manna nai osa. ");
INSERT INTO nxl_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Sio ua rei mo, ia isa nanai Kleopas. Oyo iasei tau Yesus ata, “Ama. Kani Ano ruam man sahoro Ano tamene mai Yerusalem wan anei tewa sou anamanaya waron mtinta tau mui-muie reini?” ");
INSERT INTO nxl_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesus iahata, “Sou anamana sae?” Ia rei iahata, “Sou wan rehete rerihoni Yesus, Ia kota Nasaret rei. Ia mo, ia mamsima runa Anahatana ne maunauna isa. Iatuhete tumatau na iuna sima-simana nita-nitaya tau ne kawasa. Sio mansiau na Anahatana iae anoo sanan nnai. ");
INSERT INTO nxl_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ne sio imam no sio mainaya na ma sio mainaya mai ma otoe reini oruiki osi sio wason orime otoe reini na opaku hunui roe hini wani reniene. ");
INSERT INTO nxl_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ami aunutu anoma tau Ia nea ata Ia sahoro mka iuna ita Israel isihata arihoni re nisau. Ne on naha uasi ohunui nea. ");
INSERT INTO nxl_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Samatoro ma netau, sio pinau umau, oasirama nea. Sinasi, kinoke asi, oeuso pani ne kupuro. ");
INSERT INTO nxl_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ne hoka pan, osupu Yesus tinain hatai tewa. Oyo onunso mai tanuma na oasau ata onoo Anahatana ne maisosia on roe noiyaha. Oyo sio maisosia rei oasau osiso ata, ‘Yesus iamahaiki honu!’ ");
INSERT INTO nxl_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Pusima atinu san rei, oyo ma netau umau oeuso pan kupuro honu. Hoka pan, onoo san sae wan sio pinau rei oasau rei. Ne onoo Yesus tewa.” ");
INSERT INTO nxl_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesus iasau osiso. Iahata, “Omi mo pikiran raeu tewa tau sae rei? Oparisaa tewa tau sae waron sio mamsima runa Anahatana ne maunauna oasau runare nea rei tau sae? ");
INSERT INTO nxl_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kahurae omi oanei ata Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau mo, kahurae sinsarai panesi rotu-tu imatai. Imatai samatoro Anahatana iunai iamahaiki honu, oyo iatarima muiran manetane runa kawasa.” ");
INSERT INTO nxl_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Oyo Yesus ruai iatuhete uaso rerihoni Ia ruai repusu sae waron sio okanu tau Anahatana ne anamanaya rerihoniki rei. Iatuheteso arihoni Anahatana ne maunauna waron Musa ikanure rotu-tu noi sae waron sio mamsima runa Anahatana ne maunauna tamena okanure oi. ");
INSERT INTO nxl_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tau wason nanie ohaineke nia Emaus nea, Yesus iuna sani nanie ieu asi. ");
INSERT INTO nxl_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ne uaso oapamesei. Oahata, “Arue katama ee! Tea mo, wapan nanie pumono nea. Ranie nanie resohui nea.” Reiso inusui nanie irue ikataso. ");
INSERT INTO nxl_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Wain irue iaiki ikata uaso, inana poroti oyo iainisi iake arihoni Anahatana. Ikuparehi poroti rei, oyo isamai osi uaso. ");
INSERT INTO nxl_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tau wain ikuparehi poroti rei, samatoro Anahatana ihuka matao na oationai. Ne sira tau tihoniki arihoni uaso uao anoa. ");
INSERT INTO nxl_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Oyo uaso oasei mai umau ata, “Sinasi ikaumin hunu ruari, tea! Tau ianamana runa uata pani arena tihue rei. Isima na Anahatana ne anamanaya nene isie rei, tea!” ");
INSERT INTO nxl_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Yesus tihoniki arihoni uaso oyo ohitio onunso roe Yerusalem. Hoka roe, osupu Yesus ne mampusua hutusa rahana osa rei. Wason oamanouso na sio umau oi. ");
INSERT INTO nxl_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Oyo Yesus ne mampusua oasau osi uaso. Iahata, “Titue maa! Upuri mo, iamahaiki honu. Iatuhete ruai osi Simon nea.” ");
INSERT INTO nxl_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Oyo uaso oruni osi Yesus ne mampusua rei rerihoni osupu Yesus poe arena tinai tihue rei. Oyo oahata, “Mataanoe ationai tewa. Ne ikuparehi poroti nanie aima samatoro ationai.” ");
INSERT INTO nxl_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Yesus ne mampusua wason oanamanaso rerihoni sio umau onoo Yesus wain iamahaiki honu, sira tau Yesus ruai iooi mai tihuo. Oyo iasau osiso. Iahata, “Anahatana iunamo okarihuru oamahai.” ");
INSERT INTO nxl_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Onooi pusiso osira. Okaitau hunu ruao. Oata kan onoo sakahatene. ");
INSERT INTO nxl_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ne Yesus iasau osiso iahata, “Pene osira. Pene anomo rasama-samare ata kani uamahaiku te tewa. ");
INSERT INTO nxl_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Masi onoo hanaku aiku raini. Au reini, tea! Mai na oakahuuku na onoo. Au mo, sakahatene tewa. Sakahatene mo, nene unia tewa, nene isie tewa. Ne Au mo, we unia na isiku waron, tea!” ");
INSERT INTO nxl_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Iasau san rei pusi, oyo iatuhete hanai ain osiso. ");
INSERT INTO nxl_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Anoo mirika. Osira hunu ruao. Ne oparisaa tewa sirinia ata wain iamahaiki honu. Reiso iasei tanuso. Iahata, “Mo muaina waromo te tewa?” ");
INSERT INTO nxl_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Oyo orui ika kotu-kotu otoe isa osiki. ");
INSERT INTO nxl_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Inanai oyo iaiki mai uao anoa. ");
INSERT INTO nxl_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Iasau osiso iahata, “Oni ukatamo asi mo, uasau osimo nea. Uasau ata Musa ne maunauna, Sura Kapatau, na sae waron sio mamsima runa Anahatana ne maunauna okanu rerihoni Au pusire mka raeu.” ");
INSERT INTO nxl_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Oyo, ihuka anoo na oanei rerihoni Anahatana ne anamanaya rai. ");
INSERT INTO nxl_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Iasau san rei, “Tau Anahatana ne anamanaya mo, sio kanu rerihoni Au Aia wan Anahatana ihitiku na Uapuheu Mansiau. Okanu ata mka sinsaraku rotu-tu umataku, oyo nene poua rei uamahaiku honu. ");
INSERT INTO nxl_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Okanu ata we mampusua mo, mka oeu osima ata mansia pusiki kahurae oarihoni no rosau. Oarihoni no rosau oyo Anahatana mka iapasanaso tewa nea. Mka osima on mai kota Yerusalem rotu-tu sio niana-niana pusiso mai tuniai reini. Osima na Au Aia reini we kawasa. ");
INSERT INTO nxl_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Omi ruamo sahoro onoo rai pusire tau matamo nea reiso omi sahoro mka osima. ");
INSERT INTO nxl_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Au mo, mka urui Anahatana ne Inaha osimo sani Amaku itotoe nea rei. Ne omi mo, kahurae oruemo mai kota reini ee, rotu-tu osupu kawasa arihoni Anahatana ne Inaha rei.” ");
INSERT INTO nxl_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yesus ieu ikata ne mampusua ohokaso arihoni kota Yerusalem. Oeu rotu-tu ohokaso pan nia Betania. Ohokaso pan niane rei, oyo iapusaa hanai iainisi na Anahatana irui iake osiso. ");
INSERT INTO nxl_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Wain iainisi iake osiso, oyo sira tau Anahatana iapusaai na roe noiyaha. Ikataso tewa nea. ");
INSERT INTO nxl_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pusiso okanahata rotu-tu orike tune poe tuamane oainisi oainaa nnai. Oyo onunso na roe Yerusalem anoo miri-mirika. ");
INSERT INTO nxl_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Onon ranie wasomo Anahatana ne numa mainisie oainaa na Anahatana.");
INSERT INTO nxl_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mataanoe, oni Anahatana ihaye tau tuniai reini tewasi, Ia isa wain. Ia reimo, sio oaoiki tau Sou. Sou rei ikata Anahatana. Sou rei mo, Anahatana ruai. ");
INSERT INTO nxl_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ikata Anahatana oni ihaye tuniai reini tewasi. ");
INSERT INTO nxl_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Pusu Ia, Anahatana ihaye tau rai pusire. Sani Ia wain tewa, Anahatana ihaye tau saisa tewa. ");
INSERT INTO nxl_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ia sahoro iuna pusire ramahai. Ia wain iapuhaita rei mo, irori manahane osi mansia pusiki na oanei sae sahoro manisate. ");
INSERT INTO nxl_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mansia mo, openeso tau Sou rei, tau iatuhete ata ouna kahatene. Ne sio kahatena onete kua Sou rei tewa. Noo sani pumono renete kua manahane tewa. Sou rei iatuhete sae sahoro manisate sirinia. ");
INSERT INTO nxl_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Anahatana iaisosi ia isa. Ia rei mo, nanai Yohanis. ");
INSERT INTO nxl_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yohanis ihokai na isima runa manahane rei. Isima runai na mansia pusiki oparisaa tau manahane rei. ");
INSERT INTO nxl_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ia mo, manahane rei tewa. Ia mo, hasae isima runa manahane rei man. ");
INSERT INTO nxl_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ia wain sahoro ia manahane rei mo, Ia wain iatuhete sae wani manisate osi pusita. Ia mo, wain ihokai mai tuniai reini nea. ");
INSERT INTO nxl_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ia mo, wain mai tuniai nea. Ia sahoro ihaye tau tuniai reini. Ne sio mai tuniai rei oanei tewa ata Ia mo, arihoni Anahatana. ");
INSERT INTO nxl_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ihokai mai ami Yahudiu. Tea mo, ami wan ruai ne mansiau wan iromama. Ne, ne mansiau, sio Yahudiu, sio panesi openeso tanui. ");
INSERT INTO nxl_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ne sio wason oatarimai mo, Anahatana ihitiso tau ne hehuka. Ihiti sio wason oparisaa tanui tau ne hehuka. ");
INSERT INTO nxl_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ihitiso tau ne hehuka pusu no upu momou wason ne mansiau areimo tewa. Ihitiso tau ne hehuka pusu pina hanai no maue nanie osusu areimo tewa. Ne ihitiso tau ne hehuka areimo, tau Anahatana ruai sahoro nanie ihitiso. ");
INSERT INTO nxl_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Reiso Sou rei iamrai iuna mansia. Irue ikataso mai tuniai reini. Onoo ne kawasa nea. Ihokai on roe Amai Anahatana. Amai irui kawasa osiki. Ia mo, Ia osa ruai man. Masike mansiau opalalosa iae, irui iake mainae osiso sirinia. Iatuheteso runa sae wan manisate rerihoni Anahatana. ");
INSERT INTO nxl_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohanis isima nnai osi sio panesi. Reiso iakapona iahata, “Uasau nea ata Ia isa mka ihokai tau muie. Ia mo, ia mainae inesi au. Tea mo, au wan tewasi, ia wain potuina nea. Ia reimo sahoro ain uasau nnai rei. Ia rei tea!” ");
INSERT INTO nxl_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Masike ita ipalalosa iae, irui iake mainae osi pusita ututa sirinia. ");
INSERT INTO nxl_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tea mo, Anahatana irui ne maunauna osi Musa na isima runare osi rea upu momou. Ne, pusu Yesus Kristus, Anahatana iatuheteta ata, masike ita ipalalosa iae, irui iake mainae osita sirinia. Isima runa sae wan manisate. ");
INSERT INTO nxl_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ia seia man inoo Anahatana tewa. Hasae Anai osa ruai tunne wain ihaineke runai man, sahoro isima runa Amai Anahatana osita nea. ");
INSERT INTO nxl_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Taue isa, sio mainaya arihoni akama Yahudi roe kota Yerusalem oaisosi sio imam umau runa sio arihoni ipane Lewi umau. Sio Lewi oanori roe Anahatana ne numa mainisie oakahai sio imam. Sio mainaya oaisosiso na oeuso oasei tau Yohanis. Oasei tanui ata, “Ano reini mo, ano seia?” Oyo isima runa Yesus osiso. ");
INSERT INTO nxl_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Iasau mai uao anoa. Iahata, “Au mo, Au wan Aia wain Anahatana Ihitiki na Iapuheu Mansiau rei mo, tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ouni oasei tanui honu. Oahata, “Munata san rei mo, ano mo, ano seia? Ano reini mo, Elia si?” Iasau osiso, “Tewa! Au reini mo, Elia tewa.” Ne ouni oasei tanui honu. Oahata, “Pene tu-tu ano reini mo, ia mamsima runa Anahatana ne maunauna isa waini Anahatana itotoe runai nea rei te sae rei?” Yohanis iasau osiso honu. Iahata, “Au reini mo, ia mamsima runa Anahatana ne maunauna waini itotoe runai rei mo, tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ne tau muie san rei, oasei tau Yohanis nai osa-sa honu. Oahata, “Aree asau mai ata ano reini mo, ano seia? Ami mo, kahurae anei na anunima, asau osi ma sio mainaya wason oaisosima reini.” ");
INSERT INTO nxl_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohanis iasau osiso rerihoni Yesaya ne anamanae isa. Yesaya mo, naone ia mamsima runa Anahatana ne maunauna isa. Yesaya ikanu ata, “Au reini mo, au wani uhatae osi mansiau pani otoe huie runa nioku mainae ata, ‘Seka tau anomo sani sio seka tau arena osi Upuri na inikui.’” ");
INSERT INTO nxl_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Tau sio wason sio mainaya oaisosiso oasei rei mo, sio onata umau arihon akama Yahudi wasumo oi. ");
INSERT INTO nxl_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Oasei tau Yohanis oi. Oahata, “Sani munata ano reini mo, Aia wain Anahatana Ihitiki na Iapuheu Mansiau tewa. Ano mo, Elia tewa. Ano mo, ia mamsima runa Anahatana ne maunauna isa waini itotoe runai nea rei tewa. Reiso, sapan na asohuso na mansiau oanei ata oarihoni no rosau nea?” ");
INSERT INTO nxl_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohanis iasau osiso, iahata, “Au usohu mansia tau tihu. Ne, Ia isa wain ikatamo ne oationai tewa. ");
INSERT INTO nxl_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ia mo, mka ihokai tau muie. Ne Ia mo, Ia mainae inesi au. Reiso nanie unosu ne sandaliu arihoni ain atua mani oo, umoniki. Reiso unosure mo, pannuhu tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yohanis isohu mansiau poe nia Betania, poe Wae Yordan on poe hae rani mata msaie. ");
INSERT INTO nxl_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nene han san rei, Yohanis inoo Yesus ihokai mai tanui. Iahata, “Masi onoo! Ia mo, Anahatana iromai na irui ruai osi sio ohunui noo sani rompa anae wan ita Israel ihunui na iusi re rosau. Tea mo, mka iusi mansiau no rosau. ");
INSERT INTO nxl_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ia onate rei sahoro uasau runai osimo rei. Uasau ata mka ihokai tau muie. Ia mo, Ia mainae inesi au. Areimo tau Ia mo, wain naone nea samatoro au. ");
INSERT INTO nxl_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Naone au ruaku uanei tewa ata Ia mo, Ia seia. Ne masike uanei tewa ata Ia mo, Ia seia, uhokaku na usohu omi Israel tau tihu na mansiau oanei ata oarihoni mo rosau nea. Usohumo na oationai.” ");
INSERT INTO nxl_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Pusi, oyo Yohanis isima osi mansiau rerihoni sae waron Anahatana iatuhetere osiki nea rei. Iahata, “We kakau waniu ee! Anahatana wain iaisosiku na usohuso na mansiau oanei ata oarihoni no rosau rai. Iasau osiku ata, ‘Sani anoo we Inaha isipui oyo iatasohoi tau Ia isa mo, Ia rei wain mka irui we Inaha osimo.’ Taa ihokai, uationai tewa ata Ia mo, Ia seia. Ne unoo Anahatana ne Inaha isipui on roe nante nooi sani manu puane hatae isa oyo iatasohoi roe tanui samatoro uationai. ");
INSERT INTO nxl_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Unoo rai pusire tau ruaku mataku nea. Reiso usima osi pusimo ata Ia mo, Anahatana Anai.” ");
INSERT INTO nxl_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nene han san rei, Yohanis waipo wae Yordan honu ikata ne mampusua ua. ");
INSERT INTO nxl_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Taa inoo Yesus iniku, oyo iasau osi ne mampusua ua rei. Iahata, “Masi onoo! Ia mo, Anahatana iromai na irui ruai osi sio ohunui noo sani rompa anae wan ita Israel ihunui na iusi re rosau.” ");
INSERT INTO nxl_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Taa oatinu sae wani Yohanis iasau rei, oyo uaso oeu pusu Yesus rei sirinia. ");
INSERT INTO nxl_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Oyo Yesus iuni inoo hae muie, inoo uaso wason oeu pusui. Oyo iasei tau uaso. Iahata, “Uamo wan onina sae?” Uaso oasau ata, “Ano Ona Matuhetene, Ano mo, aruea sui supa?” ");
INSERT INTO nxl_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Iahata, “Mai na mka uamo ruamo onoo.” Reiso uaso oeu okatai na onoo ata irue sui supa. Tau reimo kani yam ate ran manne. Oyo uaso orueso katai rotu-tu ranie resohui. ");
INSERT INTO nxl_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ia isa arihoni sio ua wason oatinu Yohanis ne anamanae oyo oeu pusu Yesus rei mo, nanai Anreas. Ia mo, Simon Petrus wanin. ");
INSERT INTO nxl_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Anreas inuniki on pan Yesus oyo ieui inina kakai Simon sansana. Isupui, oyo iasau osiki. Iahata, “Anoo! Ami asupu Ia wain sio oiki tau Mesias nea.” (Sio oiki tau Kristus oi. Kristus nene nohue mo, Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau.) ");
INSERT INTO nxl_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Oyo Anreas irori kakai osi Yesus. Yesus inoo mai Simon ia-ia, oyo iasau osiki. Iahata, “Nanam Simon. Amam nanai Yohanis. Ne uhete nanam tau Kepas.” (Kepas nene nohue tau sou Yunani mo, Petrus. Petrus nene nohue mo, hatu.) ");
INSERT INTO nxl_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nene han san rei, Yesus iapamata sou nanie ieu poe otoe Galilea. Isupu Pilipus oyo iasau osiki ata, “Pilipus, mai na apusuku.” ");
INSERT INTO nxl_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipus mo, ia on pan kota Betsaida. Anreas runa Petrus iae on pani kota rei oi. ");
INSERT INTO nxl_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pusi oyo, Pilipus ieu isupu Natanael. Iahata, “Anoo! Ami asupu Ia waini naone Musa ikanu rerihoniki tau ne maunauna nea rei. Sio mamsima runa Anahatana ne maunauna iae oasau runa Ia rei naone nea oi. Ia mo, nanai Yesus, Yusup anai hanaie. Ia mo, ia arihoni nia Nasaret.” ");
INSERT INTO nxl_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ne Natanael iahata, “Nasaret? Sae isa wan iake mo, rehokai on pan nia ikine rei mo, tewa!” Pilipus iahata, “Munata san rei mo, mai na ruam anoo tau matam!” ");
INSERT INTO nxl_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Taa Yesus inoo Natanael wain ihokai mai tanui, iahata, “Masi onoo ia rei ee! Ia mo, titue-tue ia Israel. Ia mo, ianei iakarota iakanihu anamanae tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Oyo Natanael iasau osiki. Iahata, “Ama, sapani na Ano anei rerihoni au reini?” Yesus iasau ata, “Oni Pilipus ieu ioia tewasi oimo, unooa. Ano wapo ai ara nohue asi.” ");
INSERT INTO nxl_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Pusi, oyo Natanael iasau iahata, “Ano Ona Matuhetene! Au mato uanei reini ata Ano mo, titue-tue Anahatana Anai. Ano mo, ita Israel ma Ia Aia!” ");
INSERT INTO nxl_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesus iasau honu ata, “Uasau ata unooa nea poe ai ara nohue man reiso aparisaa rei sirinia si? Atinu! Ano mo, mka anoo sae umau honu waron ranesi reini.” ");
INSERT INTO nxl_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Oyo iakapena iahata, “Oatinu ia-ia mai, nanie uasau osimo! Omi mo, mka onoo nante rehukai oyo Anahatana ne maisosia on roe noiyaha osipu osaa mai Au Tumata Reini wain Anahatana Ihitiku.” ");
INSERT INTO nxl_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yesus iroma Natanael runa Pilipus tau ne mampusua suka, oyo nene poua pan san rei, karisaa mausahae isa pan kota Kana. Kota rei mo, wapan otoe Galilea. Tau rei, Yesus inai waimo karisaa rei oi. ");
INSERT INTO nxl_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesus runa ami, ne mampusua iae, sio oima tau ahokama tau karisaa rei oi. ");
INSERT INTO nxl_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ne karisaa pusiki tewasi, tihu anggur pusire nea. Reiso Yesus inai iasau osiki iahata, “Ama! No tihu anggur pusire nea.” ");
INSERT INTO nxl_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesus iasau ata, “Ina! Areini mo, nene orase tewasi tau uatuhete we kawasa. Reiso pene asau osi Au.” ");
INSERT INTO nxl_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ne Yesus inai iasau osi sio manorina ata, “Kahurae ouna sae man wan iaisosimo na ounai rei.” ");
INSERT INTO nxl_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Pan rei mo, unena waron oapatau tihu tanre hua nome warumo. Unene osa reaiinu tihu kani liter 100. Sio Yahudiu oaiinu tihu tau unene san rei na osohu aio atua repusu no monna. ");
INSERT INTO nxl_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesus iasau osi sio manorina. Iahata, “Mai na oaiinu tihu tau unena rai ee!” Reiso oaiinu unena rai tau tihu rotu-tu taua ia-ia. ");
INSERT INTO nxl_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pusi, oyo iasau osiso ata, “Eu na ripa tihu mkane arihoni unene isa na roriki osi ia karisaa upue.” Reiso orori tihu rei osi ia karisaa upue rei. ");
INSERT INTO nxl_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tau ia karisaa upue rei ininu rea tihu wan ororiki osiki rei mo, tihu rei mo, iahanai reneniki tau tihu anggur nea. Ia karisaa upue rei ianei tewa ata tihu anggur reimo, onanai on supa. Ne sio manorina wason ororiki rei oanei. Irea tihu anggur rei iake nai osa. Reiso ioi ia hanaie wain iaisenei rei. ");
INSERT INTO nxl_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Iasau osiki ata, “Tau maisena mo, sio saka ohoka tihu anggur wan iake nai osa naone. Sani sio wason ohoka tau maisene rei oninu rotu okua tewa samatoro ihoka tihu anggur wan iake mainae tewa tau muie. Ne ano mo, ahoka tihu anggur wan iake mainae tewa naone samatoro ahoka tihu anggur wani iake reini tau muie.” ");
INSERT INTO nxl_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Sae wan Yesus iunai pani kota Kana rei mo, ne sima-simane wan retuhete ata ne kawasa arihon Anahatana mataanoe. Sima-simane wani iunai rei mo, iatuhete ne kawasa wan mainae osi mansiau. Ne mampusua oparisaa tanui tau rei sirinia. ");
INSERT INTO nxl_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pusi oyo, Yesus na inai, ne waniu, runa ne mampusua oeuso na pan kota Kapernaum. Orueso pan rei onona inasa asi. ");
INSERT INTO nxl_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Haineke ami Yahudiu ma karisaa anoma rapeka na Anahatana ihoka ma upu momou arihon otoe Mesir nea, reiso Yesus ieui roe kota Yerusalem. ");
INSERT INTO nxl_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Hoka roe, ieu roe Anahatana ne numa mainisie nene nusue. Inoo sio wasumo oahen koropou, rompau, runa manu puana na sio wason ohane oatanimare osi Anahatana. Inoo sio umau oi wasumo orueso noi no meyau tau otuka kepen Roma tau sio no kepen. ");
INSERT INTO nxl_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Inoo san rei reiso isapa kasapute isa arihon awane. Oyo inei pusiso arihon Anahatana ne numa mainisie runa no koropou na no rompau pusire oi. Iuni hehi sio wason saka orue otuka kepen rei no meyau na iuna iahurara no kepen pusire oi. ");
INSERT INTO nxl_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Oyo iasau osi sio wason oahen manu puana rai ata, “Oeumo runa mo manua rai! Pene ouna Au Amaku ne numa mainisie reini mo tau naniamo ohane oahen.” ");
INSERT INTO nxl_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yesus ne mampusua onoo Yesus iuna san rei, oyo anoo rapeka runa sae wan okanui tau Anahatana ne anamanaya. Okanu ata Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau iasau, “Anoku runa me numa mainisie. Reiso onesiku rotu-tu umataku iae iake sirinia. Hete sae, oamuira me numa.” ");
INSERT INTO nxl_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Sio mainaya arihon akama Yahudi oasau osi Yesus. Oahata, “Atuhete osima ata me kawasa aneni ma monna. Mai na una sima-simane isa na ami anei ata Anahatana irui kawasa osia.” ");
INSERT INTO nxl_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Oyo Yesus iasau osiso ata, “Okohu Anahatana ne numa mainisie reini, mka onona ua mani oo, uapuooi honu.” ");
INSERT INTO nxl_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Sio Yahudiu oahata, “Ee! Anahatana ne numa mainisie reini mo, sio onanai musum hutu ate rahana nome, reiso pene asau ata mka apuooi tau onona ua man!” ");
INSERT INTO nxl_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ne oanei tewa sae wan Yesus iasaui rei. Tau sae wan Yesus iasau rerihoni Anahatana ne numa mainisie reimo, waimo iasau rerihoni ia ruai tinain. ");
INSERT INTO nxl_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Imatai, oyo iamahaiki honu, samatoro ami, ne mampusua, anoma rapeka runa sae wan naone iasau rerihoni Anahatana ne numa mainisie rei. Anoma rapeka oyo, aparisaa Anahatana ne anamanaya waron raasau ata Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau mka iamahaiki honu. Aparisaa ata sae waron Yesus iasau runare reimo, titue. ");
INSERT INTO nxl_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesus irue roe Yerusalem asi tau karisaa anoma rapeka na Anahatana ihoka ma upu momou arihon otoe Mesir. Reiso sio panesi onoo Yesus iuna sima-simana waron ratuhete ata ne kawasa arihon Anahatana oyo oparisaa tanui. ");
INSERT INTO nxl_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ne Yesus mo, iparisaa tau sio tewa. Areimo tau ianei pusiso anoo nea. ");
INSERT INTO nxl_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ianei mansia anoi, mansia ne hali nea. Reiso inina ia isa tewa na isima rerihoni mansia mo, tewa. ");
INSERT INTO nxl_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ia hanaie isa nanai Nikodemus. Nikodemus mo, ia isa arihon sio onata arihon akama Yahudi. Ia mo, ia isa arihoni sio mainaya wason orime sio Yahudiu. ");
INSERT INTO nxl_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Taue isa ihokai mai Yesus tau pumono. Hoka mai, iahata, “Ano Ona Matuhetene. Ami anei ata Ano mo, Anahatana iaisosia mai na nanie atuhetema. Tea mo, hasae ia isa wain Anahatana ikata runai sahoro ne kawasa iuna sima-simana sani Ano reini.” ");
INSERT INTO nxl_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Iahata, “Atinu mai ia-ia nanie uasau osia. Ia seia man iae wain iamrai honu tewa, mka Anahatana irime ne mansiau, ia mka ipusu tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Iahata, “Sapan na ia isa wain ia mainae nea, iamrai honu? Kani inusui pan inai tiai anoe honu na iamrai nai ua?” ");
INSERT INTO nxl_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iahata, “Atinu mai ia-ia nanie uasau osia. Sani ia isa nanie ipusu tau Anahatana irime ne mansiau, ia mo, kahurae osohu heu ne rosau tau tihu. Na kahurae Anahatana ne Inaha irui kawasa osiki na ne hali honue. ");
INSERT INTO nxl_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ia isa iamrai arihoni inai, areimo tinain. Ne ia isa iamrai honu arihoni Anahatana Ne Inaha, areimo ia rei ne inaha remahaiki. ");
INSERT INTO nxl_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Pene asira sani uasau ata kahurae pusimo oamrai honu. ");
INSERT INTO nxl_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Atieu sani ihute reuhona sui supan man repusu ruae nene maue. Ita hasae iatinu nene tinunue man. Ne inoo mosai tewa. Ianei tewa, kani on supa, reeu sui supa. Arei iae sani pusiso wason oamrai arihoni Anahatana Ne Inaha. Omi oaneiki tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Iahata, “Areimo sapan?” ");
INSERT INTO nxl_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iahata, “Ira oe! Ano reini mo, atuhete sio Israel. Ne anei rerihoni sapani na oamrai honu tewa, si? Reiso mka atuheteso sapan? ");
INSERT INTO nxl_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Atinu mai ia-ia nanie uasau osia. Ami asima runa sae waron aneire rerihoni Anahatana ne Inaha nea. Asima runa sae waron anoo tau matama nea. Ne omi mo, openemo parisaa. ");
INSERT INTO nxl_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Usima runa sae waron mai tuniai reini ne omi oparisaa tewa. Reiso sapani na omi oparisaa sani usima runa mka sapan roe noiyaha? ");
INSERT INTO nxl_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ia isa man iae isaai roe noiyaha tewa. Ne hasae Au Tumata Reini, Anahatana Ihitiku, sahoro ukaisunu on roe noiyaha nea. ");
INSERT INTO nxl_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Naone Musa iapusaa tekene nene siaie tau hini pan otoe huie. Iapusaai na ia seia wain tekene reotoi oyo iarinaa na roe tanui, imatai tewa. San rei iae na Au oi. Kahurae Au Tumata Reini, Anahatana ihitiku, mka sio oapusaaku roe hini oi. ");
INSERT INTO nxl_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Oapusaaku roe hini na ia seia man wain iparisaa tanuku, mka iamahaiki ikata Anahatana rotu-tu ria supan.” ");
INSERT INTO nxl_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Anahatana anoi runa mansia mai tuniai reini pusiki mainae rotu-tu irui Anai hanaie wain ia osa man. Iruiki na ia seia man wain iparisaa tanui, mka imatai rotu-tu ria supan tewa. Ne mka iamahaiki ikatai rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tea mo, Anahatana iaisosi Anai rei, na iapasana omi mai tuniai reini tewa. Ne nanie iapuheumo na orue okatai rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ia seia wain iparisaa tanui, mka Anahatana iapasanai tewa. Ne ia wain iparisaa tanui tewa rei mo, Anahatana iasau nea ata nanie iapasanai. Tea mo, iparisaa tewa tau Anahatana Anai wain Ia osa man. ");
INSERT INTO nxl_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Anahatana iapasana sio mai tuniai reini san rei. Anai ihokai mai tuniai reini atieu rei sani manahane na iatuhete sae wan manisate osi mansia. Ne sio anoo runa pumono. Anoo runa kahatene. Anoo runa manahane rei tewa. Tea mo, no atata kahatena. Reiso mka Anahatana iapasanaso. ");
INSERT INTO nxl_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ia seia man wain ne atata kahatena, ipenei tau Ia wain sani manahane rei. Ipenei ihoka ruai mai Ia wain sani manahane rei. Pene rotu-tu ne kahatena rai onoore. ");
INSERT INTO nxl_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ne ia seia wain ipusu Anahatana ne maunauna waron titue, mka ihoka ruai mai Ia wain sani manahane rei. Ihoka ruai na sio onooi na oanei ata anoi tau Anahatana. ");
INSERT INTO nxl_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Taue isa Yesus ieu ikata ami ne mampusua pan otoe Yudea. Aruema pan rei na asohuso na mansiau oanei ata oarihoni no rosau nea. ");
INSERT INTO nxl_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Tau rei mo, Yohanis inusu pui tewasi. Reiso ia iae waipan isohuso na mansiau oanei ata oarihoni no rosau nea oi. Isohuso pan nia Ainon. Ainon mo, haineke na nia Salim. Yohanis isohu mansiau pan niane rei tau nene waena panesi. Sio panesi saka ohokaso na Yohanis isohuso pan rei. ");
INSERT INTO nxl_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Taue isa Yohanis ne mampusua umau otuntana runa ia Yahudi isa rerihoni sio Yahudiu no mon mamsohue nene maunauna. ");
INSERT INTO nxl_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Oyo Yohanis ne mampusua oeuso mai tanui oasau osiki. Oahata, “Ano Ona Matuhetene! Anom repeka runa ia onate wain ikataya ria wae Yordan on pan hae rei asi te tewa? Ia wain asima nnai osima rerihoniki rei. Muie reini wain isohuso na mansiau oanei ata oarihoni no rosau nea. Sio panesi wason oeuso ria tanui. Oeu mai ami tewa nea!” ");
INSERT INTO nxl_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Oyo Yohanis iasau osiso. Iahata, “Ia seia man mka iuna kua sae isa tewa, sani Anahatana irui kawasa osiki tewa. ");
INSERT INTO nxl_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Oatinu au uasau osimo nea ata au reini mo, au Aia wain Anahatana Ihitiki na Iapuheu Mansiau mo, tewa. Ne au reini mo, Anahatana iaisosiku uanaonei na useka tau mansia anoo osiki. ");
INSERT INTO nxl_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Atieu rei sani Ia mo, Ia hanaie wain iaisenei. Au mo, sani ne neta. Ne neta inapai ihoka. Ne neta rei iatinu nioi, anoi mirike. Arei iae nooi sani au oi. Anoku mirike nai osa tau uatinu sae wan iasaui rei osiku. ");
INSERT INTO nxl_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ia mo, kahurae Ia mainae inesi honu. Na au mo, kahurae pene unesi Ia. ");
INSERT INTO nxl_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ia mo, ihokai on roe noiyaha. Reiso Ia mo, ia mainae inesi ia sia man. Ne sio wason oamrai arihoni no mansia mainaya mai tuniai reini mo, sio mansiau man. Hasae oanamana rerihoni sae waron mai tuniai reini. Ne Yesus ihokai on roe noiyaha reiso Ia ne anamanaya mainaya ranesi ia sia man. ");
INSERT INTO nxl_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Isima rerihoni sae waron inoo runa iatinure roe noiyaha nea. Ne sio panesi oparisaa tau sae waron iasau runare rei tewa. ");
INSERT INTO nxl_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Sio wason oparisaa tau sae waron iasau runare rei mo, noo sani oamanaku ata sae waron Anahatana iasau runare rei mo, pusire titue. ");
INSERT INTO nxl_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ita ianei ata pusire titue tau Yesus mo, Anahatana sahoro iaisosiki. Iaisosiki na isima runa Anahatana ne maunauna. Pusire titue tau Anahatana iuna ne Inaha iruei pan Yesus anoi. ");
INSERT INTO nxl_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Anahatana anoi runa Anai hanaie na irui kawasa pusire osiki. ");
INSERT INTO nxl_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Reiso ia seia man wain iparisaa tau Anahatana Anai mo, wain iamahaiki ikata Anahatana rotu-tu ria supan nea. Ne ia seia wain iparisaa tau Anahatana Anai tewa, areimo mka iamahaiki ikata Anahatana rotu-tu ria supan tewa oi. Ne Anahatana anoi resaa tanui na mka iapasanai.” ");
INSERT INTO nxl_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Sio onata arihon akama Yahudi oatinu ata sio wason oeuso noi Yesus na isohuso na mansiau oanei ata oarihoni no rosau nea, sio panesi onesi sio wasoni oeuso noi Yohanis. ");
INSERT INTO nxl_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Aikee Yesus sahoro isohuso tewa. Ne ne mampusua sahoro osohuso. ");
INSERT INTO nxl_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Upuri Yesus iatinu ata sio onata arihoni akama Yahudi oaneiki nea oyo ikata ne mampusua na oeuso arihoni otoe Yudea na onunso pan otoe Galilea. ");
INSERT INTO nxl_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Onunso poe otoe Galilea mo, kahurae oniku pusu otoe Samaria. ");
INSERT INTO nxl_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Oeu rotu-tu ohokaso pan kota isa. Kota reimo haineke runa tuamane wan naone upuri Yakup iruiki osi anai Yusup. Kota rei nanae Sikar. ");
INSERT INTO nxl_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Pan tuamane rei mo, parike isa wamo. Parike reimo naone Yakup ne parike. Yesus resuniki nai osa tau oeu hainau. Tau rei, ranie katopu. Yesus resuniki, reiso iruei haineke parike rei ");
INSERT INTO nxl_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","oo, ne mampusua oeuso poe kota na ohane muaine. Sira tau ia pina Samaria isa ihokai nanie iripa tihu poe parike rei. Yesus iasau osiki. Iahata, “Ano pina onate, rui we tihu mkane na uninu ee.” ");
INSERT INTO nxl_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ne ia pina onate rei iasau. Iahata, “Ama, Ano reini mo, Ano Yahudi. Au mo, au Samaria. Sapani na ainisi tihu arihoni au Samaria reini?” (Ia pina rei iasau san rei tau sio Yahudiu mo, openeso tau onusu hoka tau sio Samaria.) ");
INSERT INTO nxl_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Oyo Yesus iahata, “Ina, sani ano anei Anahatana nanie irui sae osia na anei Ia sia sahoro wain iainisi tihu arihonia reini mo, mka ano ruam ainisi tihu arihoniku. Ainisi tihu oyo mka urui tihu wan reunaya amahaia.” ");
INSERT INTO nxl_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Oyo iahata, “Upu, me titipate tewa. Samatoro parike reini mo, naue wapo hainau. Reiso mka asupu tihu wan reunaku uamahaiku rei sui supa? ");
INSERT INTO nxl_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mani upu Yakup iarihoni parike reini osima. Ia ruai runa ne upu momou oninu arihoni parike reini. Ne une-uneu, koropou iae raninu arihoniki oi. Ano ata kani Ano mo, Ano mainae anesi ami ma upu Yakup tu-tu arui tihu wan reunama amahaima rei si?” ");
INSERT INTO nxl_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesus iahata, “Ia seia wain ininu tihu arihoni parike reini mka anoi kasae honu. ");
INSERT INTO nxl_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ne ia seia wain ininu tihu wan Au uruiki osiki, ia mo, mka anoi kasae tewa rotu-tu ria supan. Erenesi honu, tihu wan uruiki osiki rei mo, nooi sani waene hunae wan renia sui osa on pan anoi. Waene hunae rei reunai iamahaiki ikata Anahatana rotu-tu ria supan.” ");
INSERT INTO nxl_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ne ia pina rei ianei sae wan Yesus iasau runai rei tewa. Reiso iasau ata, “Upu, munata san rei mo, rui tihu rei osiku mai nea, na pene anoku kasae nea. Na pene ueuku mai uripa tihu sui osa nea.” ");
INSERT INTO nxl_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Oyo Yesus iahata, “Eua na aoi saham mai, samatoro eu akatai mai rei.” ");
INSERT INTO nxl_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Iahata, “Ne au mo, uausahaku tewasi.” Yesus iahata, “Sae wamo asaui rei mo, titue. Ano mo, ausahaya tewasi. ");
INSERT INTO nxl_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ano mo, ausahaya nai nima nea. Ne ia waipo iruei ikataya poe me numa rei mo, saham tewa oi. Tea mo, uamo oaisenemo tewasi. Reiso sae wan inaku asaui rei mo, titue.” ");
INSERT INTO nxl_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Iahata, “Upu. Wan mato uanei ata Ano mo, Ia mamsima runa Anahatana ne maunauna. ");
INSERT INTO nxl_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ne nanie uasei tanua ee. Ami ma upu momou oainisi oainaa na Anahatana mai tinetae reini. Ne, omi Yahudiu oasau ata ita mo, kahurae iainisi ainaa na Anahatana roe kota Yerusalem. Reiso sae sahoro wan manisate?” ");
INSERT INTO nxl_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Oyo Yesus iasau ata, “Ano pina onate, parisaa sae wan nanie uasau nnai reini. Mka omi oainisi oainaa na Anahatana sui supan man. Oainisi oainaa nnai mai tinetae reini tewa nea. Oeu roe kota Yerusalem iae, tewa nea. ");
INSERT INTO nxl_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Omi Samariau mo, oainisi oainaa na Anahatana ne oationai tewa. Ne ami Yahudiu mo, ainisi ainaa nnai mo, ationai nea. Tea mo, Anahatana itotoe nea ata mka Ia Yahudi isa ihokai na iapuheu mansia na pene Anahatana iapasanaso. ");
INSERT INTO nxl_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ne sani pannuhu nene umetene nea, sio wason titue-tue oainisi oainaa runa Anahatana, mka oainisi oainaa nnai runa kawasa arihoni Anahatana ne Inaha. Sio iae mka oainisi oainaa na Anahatana pusu Anahatana ne maunauna waron titue. Umetene rei mo, repan nea rei. Amaku inina na ita iainisi iainaa nnai san rei. ");
INSERT INTO nxl_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anahatana mo, Inaha. Reiso sio wason nanie oainisi oainaa nnai mo, kahurae oainisi oainaa nnai runa kawasa arihon ne Inaha. Sio iae kahurae oainisi oainaa runai pusu ne maunauna waron titue.” ");
INSERT INTO nxl_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Oyo ia pina ona Samaria rei iasau osi Yesus. Iahata, “Ama! Au uanei ata Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau mo, mka ihokai. Sani ihokai nea, mka isima na rai pusire osita.” (Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau mo, oaoiki tau Kristus.) ");
INSERT INTO nxl_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesus iahata, “Ano pina onate. Ia wain ano asau ata Aia rei mo, Au. Au wan uanamana runaya rein, tea!” ");
INSERT INTO nxl_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sira tau ami, Yesus ne mampusua, ahokama on poe kota. Asira tau Yesus waimo iruni runa ia pina wain isupui sinasi rei. Ne ia sia man iasei tewa arihoni ia pina rei ata, “Nanie anina sae?” Ia sia man iasei tewa tau Yesus ata, “Nanie anamana na ia pina rei tau sae?” ");
INSERT INTO nxl_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pusi oyo, ia pina rei ieui iarihon ne tihu naniae rei sirinia, oyo ieu na poe kota na isima osi mansiau. Iahata, ");
INSERT INTO nxl_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mai na ieuta pan, inoo ia onate isa repan. Iasau runa sae man waron au unare rei. Pene tu-tu Ia sahoro Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau rei te sae rei?” ");
INSERT INTO nxl_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Oatinu san rei oyo, oeuso rei sirinia. Oeuso, ohokaso arihoni kota, na oeuso pan osupu Yesus. ");
INSERT INTO nxl_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Oo ia pina sinasi rei ieui iarihonima, ami ne mampusua atentene tau Yesus na iaiki mkane. Asau ata, “Ano Ona Matuhetene, mai na aia mkane ee!” ");
INSERT INTO nxl_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ne Yesus iasau osima. Iahata, “Au mo, we muaina waron tau uaiku. Ne omi oaneiki tewasi.” ");
INSERT INTO nxl_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Reiso ami asei tau umau oahata, “Pene tu-tu sio umau orori muaina osiki nea te sae rei?” ");
INSERT INTO nxl_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Oyo Yesus iasau osiso, “Amaku Anahatana iaisosiku na upusu ne maue na una sae waron inina na Au unare. Uamahaiku na una san rei, areimo sani Au we muaina. ");
INSERT INTO nxl_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mansiau saka oasau ata, ‘Nesie hunana ate oyo iapahia nisi tea!’ Ne Au uasau osimo onoo sio Samaria wason sio Yahudiu tewa. Sio nanie oparisaa we maunaune. Sio mo, nooso sani atuhu isia noi nisi waron nanie mtuaya nea, reiso nanie oapahia nisi nea. ");
INSERT INTO nxl_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ia seia wain isima runa Au osi mansiau, ia mo, nooi sani ia wain irahu nisi. Oyo ia sia sahoro iakahai sio mansiau rei na oparisaa tau Au, ia rei mo, nooi sani ia wain iapahia nisi. Iapahiai na isupu atuhu isia tau rekati ne kausa wanaya. Ia wain iapahia nisi rei mo, noo sani ia wain iaunau sio wason oatinu rerihoni Au oyo oparisaa. Oparisaa oyo oamahaiso okata Anahatana rotu-tu ria supan. Mka ia wain iaunauso isupu ne pahalaa sani ia wain iapahia nisi isupu nene atuhu isia. Reiso anoi mirike noo sani ia wain iapahia nisi anoi mirike. ");
INSERT INTO nxl_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Reiso sani sou nanae reini mo, manisate. Sou nanae wan reasau, ‘Sio umau orahu nisi, oo sio umau honu oapahia nisi.’ ");
INSERT INTO nxl_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Au uaisosimo na oeu oaunau sio wason mka oparisaa mo maunaune rei. Ne rotu-tu oparisaa mo, noso sio umau honu oeu oaunauso oanaonemo. Areimo sani oapahia nisi wan omi ruamo orahui tewa. Sio umau orahu nisi rei naone. Omi mo, hasae oeumo pan oapahia atuhu isia pan nisi wani sio umau orahui rei.” ");
INSERT INTO nxl_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ia pina onate wain Yesus ianamana runai iruni osi sio pan kota rei oyo sio Samariau panesi oparisaa tau Yesus. Oparisaa noso ia pina onate rei iasau osiso ata, “Ia onate reini iasau osiku runa sae man waron unai.” ");
INSERT INTO nxl_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Reiso sio Samariau rei ohokaso mai Yesus. Hoka mai, oapamanui na iruei ikataso pan no kota rei. Reiso iruei ikataso onona ua pan rei. ");
INSERT INTO nxl_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Sio panesi honu oparisaa tau Yesus tau ruao oatinu ne maunauna. ");
INSERT INTO nxl_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Sio oasau osi ia pina ona Samaria rei ata, “Ano pina onate, naone ami aparisaa tau Ia onate reini mo, repusu sae wani ano asaui osima rei. Ne muie reini ami aparisaa pusu ami ruama atinu ne maunauna nea oi. Ami anei ia-ia nea ata Ia reini mo, titue-tue iapuheu mansia na pene Anahatana iapasanaso.” ");
INSERT INTO nxl_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesus iruei pan kota Sikar onona ua pusi oyo, ieui pani otoe Galilea. ");
INSERT INTO nxl_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Naone ruai iasau nea ata, “Sio mansiau oamuira ia mamsima runa Anahatana ne maunauna noi ruai ne niane tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ne tau ihokai pan otoe Galilea, mansiau oapusaai ia-ia. Tea mo, ruao onoo pusire waron Yesus iunare roe kota Yerusalem tau karisaa anori rapeka runa Anahatana ihoka rea upu arihoni otoe Mesir. ");
INSERT INTO nxl_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesus ieu honu pan nia Kana wapan otoe Galilea. Naone Yesus iuna tihu reneniki tau tihu anggur pan niane rei. Niane rei mo, hainau arihoni kota Kapernaum tewa. Pan kota Kapernaum mo, ia onate isa iruei pan rei. Ia onate rei reimo, ia aia hanai wanane isa. Anai hanaie waipo ikupui mtinte. ");
INSERT INTO nxl_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Reiso iatinu ata Yesus wain ihokai on pani otoe Yudea na waipo otoe Galilea, oyo ieui poe Yesus na iapamanui. Iahata, “Upu, uainisi arihonia na aeu akataku poe Kapernaum. Tea mo, anaku waipo ikupui mtinte. Nanie imatai nea. Uainisi arihonia na asuisenei ee.” ");
INSERT INTO nxl_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Oyo Yesus iasau ata, “Waniku sin, kakaku sin! Omi openemo oparisaa tau Au sani onoo sima-simana waron ratuhete ata no kawasa arihon Anahatana runa sima-simana waron raasiraso tewasi. Onoo sima-simana samatoro oparisaa tanuku.” ");
INSERT INTO nxl_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Oyo ia rei iahata, “Upu, uainisi arihonia na mai aeu akataku nea. Pene tu-tu anaku hanaie imatai.” ");
INSERT INTO nxl_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ne Yesus iasau ata, “Amaku, pene anom reuponu. Anunia nea. Anam hanaie waipo iake nea.” Ia onate rei iparisaa tau sae wan Yesus iasau rei oyo inuniki na poe ne numa. ");
INSERT INTO nxl_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Wain arena tihue asi, sira tau ne sio makahaia ohoka osima osiki. Oahata, “Upu! Upu! Anam hanaie iake nea.” ");
INSERT INTO nxl_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Reiso iasei tanso ata, “Ne kupue iake tau yam ina?” Oasau osiki ata, “Potusi! Yam osa ranie katopu ne patane titie tewa nea.” ");
INSERT INTO nxl_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Oyo amai anoi repeka rei sirinia. Anoi repeka runa potusi yam osa ranie katopu mo, Yesus iasau osiki ata, “Anam hanaie iake nea.” Reiso ia onate runa sio pusiso wason orueso okatai noi ne numa rei pusiso oparisaa tau Yesus. ");
INSERT INTO nxl_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Areimo Yesus iuna sima-simane wan retuhete ata ne kawasa arihon Anahatana nai ua nea on ihokai mai Galilea on poe otoe Yudea. ");
INSERT INTO nxl_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Taue isa Yesus ieui na roe kota Yerusalem. Ieui roe, nanie ihokai tau sio Yahudiu no karisaa isa roe rei. ");
INSERT INTO nxl_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Roe kota rei mo, waene isa wamo. Waene rei mo, wamo haineke kota Yerusalem nene mitanunue isa. Mitanunue rei nanae Rompa nene Mitanunue. Waene rei tau sou Ibrani mo, nanae Betesda. Waene nusue rei nene heuta hua nima. Heuta rai oainatare. ");
INSERT INTO nxl_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Sio kupua panesi onekeso poe heuta rai. Sio umau mo, matao putia. Sio umau honu mo, oeu seu-seu. Sio umau honu mo, otalaso. Onekeso poe heuta rai onapa-napa waene rei nisue. ");
INSERT INTO nxl_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Areimo, tau taua-taua mo, Anahatana ne maisosie on roe noiyaha ikaisunu na iuna waene rei nisue. Ia seia man wain isipui naone tau waene rei nisue areimo, ia rei ne kupue iake rei sirinia. Kupue sae man mka iake. ");
INSERT INTO nxl_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ia hanaie isa waimo iruei pan waene rei nusue. Ia hanaie rei mo, ikupui musum hutu tonu rahana wanu nea. ");
INSERT INTO nxl_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesus inooi waipo inekei poe rei. Iatinu ata ia hanaie rei mo, ikupui potuina nea. Oyo Yesus iasei tanui ata, “Nanie me kupue rei iake te tewa?” ");
INSERT INTO nxl_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Iahata, “Upu! E-e. Unina na we kupue rein iake. Ne waene reini nisue kani ia sia nanie iakahaiku na usipu poe waene reini? Ruaku nanie usipu, ne ukua tewa. Ia isa ianaoneku sui osa.” ");
INSERT INTO nxl_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesus iasau ata, “Hanua roe, na noku me kinoe na aeu!” ");
INSERT INTO nxl_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Oyo sira tau ia hanaie rei iake. Ihitioi, inoku ne kinoe, oyo ieu. Yesus isuisene ia hanaie rei tau ranie hatae wan ami Yahudiu amuira Anahatana. ");
INSERT INTO nxl_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Reiso sio Yahudiu no sio mainaya oasau osi ia hanaie rei. Oahata, “Ano onate! Ranie hatae repan mo, ranie hatae wan ita Yahudiu iamuira Anahatana. Musa ne maunauna rasopo na pene ipakarian. Reiso pene arori me kinoe rei!” ");
INSERT INTO nxl_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ne iahata, “We amau! Ia wain isuiseneku rei sahoro iaisosiku unoku we kinoe na ueu.” ");
INSERT INTO nxl_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Oasei tanui honu. Oahata, “Reiso ia wain iaisosia anoku me kinoe na aeu mo, Ia sia?” ");
INSERT INTO nxl_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ne ia hanaie rei ianei tewa ata Ia sia sahoro isuisenei rei. Areimo tau sio panesi onete Yesus nea reiso inoo mosa Yesus tewa nea. ");
INSERT INTO nxl_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Potuina tewa oyo, Yesus isupu ia hanaie rei roe Anahatana ne numa mainisie nene nusue. Iasau osiki. Iahata, “Amaku atinu mai na uasau osia ia-ia. Me kupue iake nea tea! Pene apalalosa nea! Pene tu-tu sae isa remunaya renesi me kupue wan mato-mato rei honu.” ");
INSERT INTO nxl_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ia hanaie rei ianamana runa Yesus suka oyo, ieu isima osi sio Yahudiu no sio mainaya. Iahata, “We amau, uanei ia wain isuiseneku mo, ia sia nea. Nanai Yesus.” ");
INSERT INTO nxl_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Reiso, noso Yesus isuisene pannuhu ranie hatae wan ami Yahudiu amuira Anahatana, sio mainaya rei onina arena na ouna sinsara Yesus. ");
INSERT INTO nxl_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ne Yesus iasau osiso. Iahata, “We amau. Au Amaku mo, ipakarian onone ranie rotu-tu ranie hatae repan, masike reimo ranie hatae wani iamuira Anahatana oi. Reiso, Au iae, kahurae upakarian oi. Masike rei mo, ranie hatae wani iamuira Anahatana oi.” ");
INSERT INTO nxl_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Noso Yesus iasau ata ipakarian tau ranie hatae wan ami Yahudiu iamuira Anahatana, reiso sio Yahudiu anoo rasaa renesi honu. Reiso onina arena na ohunu Yesus. Areimo tau pusu sio mo, Yesus ipusu Musa ne maunauna rerihoni ranie hatae wani iamuira Anahatana rei tewa. Na isa honu mo, Yesus ioi Anahatana tau Amai. Areimo iuna ruai nooi sani Anahatana. ");
INSERT INTO nxl_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesus iasau osi sio mainaya arihoni akama Yahudi. Iahata, “We amau, oatinu mai ia-ia nanie uasau osimo ia-ia. Au, Anahatana Anai, una sae isa mo, upusu ruaku we maue tewa. Au mo, hasae una sae wan unoo Amaku iunai. Areimo noso sae wani Amaku iunai, Au iae una rei oi. ");
INSERT INTO nxl_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tea mo, Amaku anoi runaku. Iatuhete osiku runa sae man waron Ia ruai iunare. Mato-mato rei usuisene ia wain ikupui rei. Ne mka Anahatana iatuheteku una sima-simana waron mainaya ranesi usuisene sio kupua, reiso mka omi osira. ");
INSERT INTO nxl_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Noo sani Amaku iuna mansia matane iamahaiki honu. Reiso Au iae, mka uapuhai mansia matane pusu ruaku we maue. ");
INSERT INTO nxl_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Amaku iapasana ia sia man tewa. Ne irui pusi kawasa osi Au na Au sahoro uapasana mansia. ");
INSERT INTO nxl_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Amaku irui kawasa osi Au na mansia pusiki oamuira Au. Ia sia iamuira Au tewa, areimo noo sani iamuira Amaku tewa. Amaku wain iaisosiku uhokaku mai tuniai reini oi. ");
INSERT INTO nxl_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Oatinu mai ia-ia nanie uasau osimo. Ia sia iatinu sae wani uasau runai reini na iparisaa tau Anahatana wain iaisosiku mo, mka iamahaiki ikata Anahatana rotu-tu ria supan. Mka Anahatana iapasanai tewa nea. Ia wain naone iruei hainau arihon Anahatana mo, muie reini wain iamahaiki ikata Anahatana rotu-tu ria supan nea. ");
INSERT INTO nxl_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Oatinu mai ia-ia nanie uasau osimo. Mka nene orase rehokai na sio wason oparisaa tau Au tewa mo, mka oatinu Au, Anahatana Anai, nioku. Sio reimo, nooso sani sio matana. Ne wain iatinu tanuku mo, mka iamahaiki ikata Anahatana rotu-tu ria supan. Orase rei mo, wan reeu nea. ");
INSERT INTO nxl_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Iamahaiki tau Amaku ne kawasa tau iunaso oamahaiso rotu-tu ria supan. Ia iae irui kawasa rei osi Au na una mansiau oamahaiso okatai rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Irui kawasa osiku na uarinii ia sia wain ia manisate, ia sia wain ia manisate tewa. Irui kawasa osiku tau Au reini mo, Au Tumata wain Anahatana Ihitiku. ");
INSERT INTO nxl_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Pene osira tau sae wan mato uasau runai osimo rei. Tea mo, pannuhu nene orase, sio matana wason ria hatu nohua oatinu Au nioku. ");
INSERT INTO nxl_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Mka ohokaso arihoni kupuro anoa na oamahaiso honu. Ia sia wain on mai tuniai iamanisa, mka iamahaiki honu na iamahaiki rotu-tu ria supan ikata Anahatana. Ne ia sia wain on mai tuniai mo, iuna kahatene mka iamahaiki honu, uapasanai. ");
INSERT INTO nxl_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ne uapasana mansia pusu ruaku we kawasa tewa. Uapasana mansia pusu sae wan Amaku iasau osiku na unai. Uapasana mansiau mo, uese hae osa man tewa. Tea mo, upusu ruaku we maue mo, tewa. Ne upusu Amaku ne maue. Ia sahoro iaisosiku uhokaku mai tuniai reini.” ");
INSERT INTO nxl_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Sani Au ruaku usima na ruaku, mka sio oanei tewa ata kani sae wan usima runai rei mo, titue te tewa. ");
INSERT INTO nxl_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ne ia isa honu wain isima rerihoni Au. Ia rei mo, Amaku ruai. Au uanei ata sae wan isima runare rerihoni Au mo, pusire manisata. ");
INSERT INTO nxl_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Omi oaisosi sio umau pan Yohanis mamsohue na oasei rerihoni Au rei. Yohanis mo, isima runa sae waron manisata. ");
INSERT INTO nxl_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ne unina mansia na osima rerihoni Au tewa. Hasae nanie uasau osimo na anomo rapeka runa sae wan Yohanis isima runai nea osimo rei man. Isima na oparisaa na Anahatana iapuheumo na pene iapasanamo. ");
INSERT INTO nxl_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Sae wan Yohanis iasau runai rerihoni Au mo, reuna omi oanei sae wan titue rerihoni Au. Nooi sani kamane wani resita itane manahane nai osa na oanei mosa arena. Mataanoe okaumin na sae waron Yohanis isima nnare rei. Ne okaumin hasae rapu-rapu man. ");
INSERT INTO nxl_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ne sae isa wan mainae renesi Yohanis resima runa Au. Sima-simana waron Au unare rei mo, pusire ratuhete ata Au reini mo, Amaku sahoro iaisosiku na unare rei. Ratuhete ata Amaku wain roe noiyaha iaisosiku mai tuniai reini. ");
INSERT INTO nxl_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Amaku wain iaisosiku rei iae ruai isima runa Au. Omi mo, oatinu nioi tewa nai osa. Te onooi iae tewa oi. ");
INSERT INTO nxl_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Omi oparisaa tau Au reini tewa. Au wan Anahatana iaisosiku reini. Reiso oparisaa tau ne anamanaya pan anomo tewa. ");
INSERT INTO nxl_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Oarinii Anahatana ne anamanaya ia-ia noso omi ata kani oariniire, mka osupu arena na oamahaimo kata Anahatana rotu-tu ria supan. Ne Anahatana ne anamanaya rai rasima rerihoni Au. ");
INSERT INTO nxl_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ne openemo oparisaa tau Au na oamahaimo okata Anahatana rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Unina na mansiau oamuiraku tewa. ");
INSERT INTO nxl_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ne omi mo, Au uanei anomo. Omi mo, anomo runa Anahatana tewa. ");
INSERT INTO nxl_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Uhokaku mai tuniai reini runa Amaku ne kawasa. Ne openemo oatarimaku. Ne sani ia tamene isa ihokai na ruai ne kawasa, omi oatarimai. ");
INSERT INTO nxl_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Reiso onina na mansiau oamuiramo. Ne onina tewa na Anahatana wain ia osa man rei iamuiramo. Reiso oparisaa tau Au tewa. ");
INSERT INTO nxl_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Pene oata kan Au mka uamanarumo roe Amaku. Ia wain mka iamanarumo mo, Musa. Aikee omi oata kani opusu Musa ne maunauna mo, mka Anahatana iapuheumo. ");
INSERT INTO nxl_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ne sani oparisaa tau sae waron Musa ikanure, areimo omi iae oparisaa tau Au oi. Tea mo, sae waroni ikanure rei mo, ikanu rerihoni Au. ");
INSERT INTO nxl_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ne oparisaa tau sae waron Musa ikanure rei tewa. Reiso oparisaa tau sae waron uasau runare tewa, tea!” ");
INSERT INTO nxl_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Sio Yahudiu no karisaa pusiki nea oyo Yesus inuniki on roe kota Yerusalem. Ieu ria nakane wan nanae Galilea ria hae. Nakane rei mo, nene nanae isa oi mo, Tiberias. ");
INSERT INTO nxl_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mansia hutue oeu pusui. Opusui tau onoo sima-simana waron ratuhete ata ne kawasa arihon Anahatana waron iunare na sio kupua iake. ");
INSERT INTO nxl_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ihokai ria nakane ria hae, inoai na roe pupue isa. Hoka roe, iruei poe ikata ne mampusua. ");
INSERT INTO nxl_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tau rei mo, ami Yahudiu ma karisaa anoma rapeka na Anahatana ihoka ma upu momou arihon otoe Mesir haineke nea. ");
INSERT INTO nxl_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesus ihetu unui inoo ria nau. Inoo san rei mo, mansia hutue wason oeuso mai tanui. Reiso iasau osi ne mampusue isa wain nanae Pilipus. Iahata, “Pilipus. Kani ihane poroti sui supa na ipana sio panesi reini?” ");
INSERT INTO nxl_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesus iasau san rei osi Pilipus tau nanie ireai man. Areimo, tau Yesus ianei nea ata nanie iuna sae. ");
INSERT INTO nxl_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Oyo Pilipus iasau osi Yesus ata, “Ama. Masike ia isa ipakarian hunana wanu oi, ne kati relai tewa na ihane poroti osi pusiso. Masike kihore mkana-mkana na samare sinta-sinta osiso sana osa-osa oi.” ");
INSERT INTO nxl_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ne Yesus ne mampusue isa honu wain nanai Anreas. Ia mo, Simon Petrus wanin. Iasau osi Yesus ata, ");
INSERT INTO nxl_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ama. Ia iki hanaie isa wain rei. Irori poroti wan unai arihoni jelai. Irori hua nima runa ikaya use ua. Ne ralai tau ipana sio panesi reini tewa nai osa!” ");
INSERT INTO nxl_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Oyo Yesus iasau osi ne mampusua rei ata, “Aisosi sio panesi rei oru-rueso.” Noi tihue rei mo, monota panesi. Reiso sio rei oru-rueso poe. Tau sio hutue rei mo, sio hanaia, sio mainaya nihu nima runa sio pinau na sio ikina oi. ");
INSERT INTO nxl_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Oyo Yesus inana poroti rei oyo, iainisi iake arihoni Anahatana. Iahata, “Amaku Anahatana, Ano mo, Ano iake. Asamama tau muaina raini.” Pusi, oyo isama-samare osi sio wason orueso sui monota rei pusiso. Inana ikaya use ua rai. Iainisi, oyo ikuparehire oyo isama-sama osi sio mansiau panesi rei oi. Isama-sama ikaya osiso oi. Pusiso oaiso rotu-tu tiao pokona. ");
INSERT INTO nxl_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Pusiso oaiso tiao pokona oyo Yesus iasau osi ne mampusua. Iahata, “Oeu oamanou muaina nesia rai ee. Pene pesi sai-saire.” ");
INSERT INTO nxl_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Reiso oamanou muaina nesia rai. Oaiinure tau pakuna hutusa rahana ua na poroti nesia rai oi. ");
INSERT INTO nxl_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Sio panesi rei onoo sima-simane wan retuhete ata Yesus ne kawasa arihon Anahatana wan iunai rei oyo oahata, “Titue-tue! Ia reini mo, ia mamsima runa Anahatana ne maunauna wain Anahatana itotoe runai nea ata mka ihokai mai tuniai.” ");
INSERT INTO nxl_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ne Yesus ianei ata sio panesi reimo nanie otentenei na iuna no aia. Reiso ieu arihon tihue otoe rei roe pupua honu na ruai man pan rei. ");
INSERT INTO nxl_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Resou-sou nea, ami, Yesus ne mampusua, amusuma nau nakane wani nanae Galilea. ");
INSERT INTO nxl_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Oyo asaa ma arupai nanie aeuma ria hae, ria kota Kapernaum. Wapan pumono nea. Ne Yesus masi ihoka nau tanuma tewa sirinia. ");
INSERT INTO nxl_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Wan asaai, sira tau ihute reuhona mainae reuna kolau mainaya. ");
INSERT INTO nxl_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Asaai hainau kani kilo nima nomesa san rei nea. Oyo anoo Yesus ieu roe waene hahae, nanie ieui mai tanuma mai arupai rei. Akaitau hunu ruama. ");
INSERT INTO nxl_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ne Yesus iasau osima ata, “Ee! Pene okaitau! Au ruaku reini, tea!” ");
INSERT INTO nxl_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Reiso akaumin hunu ruama rotu-tu apusaai roe ma arupai. Anoo oi mo, ahokama ria hae nea. ");
INSERT INTO nxl_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Yesus ieu roe waene hahae, sio panesi asi wason nau nakane wan nanae Galilea nusue sirinia. Nene han roe san rei, osira tau Yesus tutui tewa nea. Potusi onoo arupai osa mtola man. Ne oanei ata Yesus ne mampusua osaa arupai rei na ria hae ria kota Kapernaum nea, ne isaa ikataso tewa. ");
INSERT INTO nxl_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Oyo sio umau ohokaso osaa no arupaiu on pan Kota Tiberias. No arupaiu rai ramanu-manuso haineke Upuri Yesus naniai wan potusi iainisi iake arihoni Anahatana oyo ipana sio panesi rei tau porotiu hua nima rei. ");
INSERT INTO nxl_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Sio panesi rei onoo Yesus runa ne mampusua wasumo rei tewa nea. Reiso osaa no arupaiu rai oyo oeuso na ria kota Kapernaum onina Yesus. ");
INSERT INTO nxl_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Sio panesi oeu onina Yesus oyo osupui pan nakane wani nanae Galilea on pan hae. Osupui pan kota Kapernaum. Oyo oasau ata, “Ano Ona Matuhetene! Reiso ahokaya mai rei onnaha inasi nea rei?” ");
INSERT INTO nxl_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iahata, “Oatinu mai ia-ia nanie uasau osimo. Oeu oninaku tewa noso onoo sima-simana waron ratuhete ata we kawasa arihon Anahatana. Ne oninaku noso oai poroti wan oaiki rotu-tu tiamo pokona rei. ");
INSERT INTO nxl_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Pene opakarian onina muaine wan mka rekopui. Ne, onina muaine wan mka rekahate tewa. Onina muaine wan reunamo oamahaimo okata Anahatana rotu-tu ria supan. Muaine rei mo, hasae Au, Tumata Reini mo, Anahatana Ihitiku sahoro mka uruiki osimo. Areimo tau Au mo, Amaku irui kawasa osiku nea.” ");
INSERT INTO nxl_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Oyo oasei tanui ata, “Ama! Reiso munata san rei mo, kahurae auna sae na apusu Anahatana ne maue?” ");
INSERT INTO nxl_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iahata, “Anahatana ne maue mo, na omi oparisaa tau Au wan iaisosiku uhokaku mai tuniai reini.” ");
INSERT INTO nxl_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Oasei ata, “Munata san rei mo, masi auna sima-simane isa wan retuhete ata me kawasa arihon Anahatana osima mai. Mka anoo na aparisaa ata Ano mo, Anahatana iaisosia mai rei! Reiso nanie auna sae? ");
INSERT INTO nxl_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Naone ami ma upu momou orueso pani otoe huie okata Musa mo, oai poroti wan on roe noiyaha wan sio oiki tau manna. Anahatana ne anamanaya raasau, ‘Irui poroti on roe noiyaha osiso na oai.’” ");
INSERT INTO nxl_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Oyo Yesus iasau ata, “Oatinu mai ia-ia nanie uasau osimo. Musa ipanaso mo, tewa. Ne Amaku sahoro irui poroti on roe noiyaha rei osi omi mo upu momou. Muie reini nanie irui poroti tunne on roe noiyaha osi omi. ");
INSERT INTO nxl_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Areimo tau poroti tunne wan Anahatana iruiki mo, ikaisunu on roe noiyaha. Ia sahoro iapuhai mansia mai tuniai reini rotu-tu ria supan.” ");
INSERT INTO nxl_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Oahata, “Upu, masi arui poroti wan on roe noiyaha rei osima sui osa nea.” ");
INSERT INTO nxl_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesus iahata, “Au reini mo, poroti wan uapuhai mansia na ikata Anahatana rotu-tu ria supan. Ia sia wain ihoka mai tanuku mo, mka imakanea tewa nea. Na ia sia wain iparisaa tanuku mo, mka anoi kasae tewa nea. ");
INSERT INTO nxl_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ne uasau osimo nea. Onooku nea, ne oparisaa tanuku tewa sirinia. ");
INSERT INTO nxl_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ia sia man wain Amaku iruiki na ouna we mansiau rei mo, mka oeuso mai tanuku. Na ia sia wain ihokai mai tanuku mo, mka uapusaa pusiso. Uneiso tewa. ");
INSERT INTO nxl_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Areimo tau usipu on roe noiyaha na una pusu ruaku we maue mo, tewa. Ne nanie una pusu Amaku wain iaisosiku rei ne maue. ");
INSERT INTO nxl_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Amaku iaisosiku rei mo, ne maue na ia seia man wain iruiki osiku nea rei mo, pene iamaninui. Ne ne maue na iapuhai sio pusiso honu pannuhu tuniai reini repena. ");
INSERT INTO nxl_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Areimo tau Amaku ne maue mo, ia sia man wain ianei ata Au reini mo, Anahatana Anai oyo iparisaa tanuku, ia mo, mka iamahaiki ikata Anahatana rotu-tu ria supan. Oyo tau tuniai reini nanie repena mo, Au mka uapuhaiki honu pannuhu tuniai reini repena.” ");
INSERT INTO nxl_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Oatinu Yesus iasau ata “Au mo, Au poroti wan on roe noiyaha.” Reiso sio Yahudiu oana-namanaso pani muie. ");
INSERT INTO nxl_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Oasau osi umau ata, “Ia reini mo, Yesus wain inai na amai ita iationaso rei, tea! Yusup anai, tea! Reiso nanie iasau ata ihokai on roe noiyaha mo, iakarota.” ");
INSERT INTO nxl_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ne Yesus iasau ata, “Pene oana-namanamo pani muie. ");
INSERT INTO nxl_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tea mo, Amaku wain iaisosiku rei sahoro iunaso oparisaa tanuku. Oparisaa pusu ruao no maue tewa. Oparisaa oyo mka uapuhaiso honu tau tuniai reini nanie repena. ");
INSERT INTO nxl_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yesaya, ia mamsima runa Anahatana ne maunauna rei, iasau nea. Ikanu ata, ‘Anahatana mka iatuhete pusiso.’ Reiso, ia seia man wain iatuheteso na oatinu tanui mo, mka iparisaa tanuku. ");
INSERT INTO nxl_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ia sia man inoo Amaku Anahatana tewasi. Hasae Au wan iaisosiku mai tuniai reini man sahoro unooi nea. ");
INSERT INTO nxl_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Oatinu mai ia-ia nanie uasau osimo! Omi wan oparisaa tau Au mo, mka oamahaimo okata Anahatana rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Sani poroti reuna tinairi ramahaiso, Au mo, uapuhaimo na okata Anahatana rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tau omi mo upu momou pani otoe huie mo, oai poroti wani oiki tau manna rei nea. Ne masike oai poroti rei nea, ne omataso sirinia. ");
INSERT INTO nxl_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ne poroti tunne rekaisunu on roe noiyaha nea. Poroti rei reuna mansia wason oaiki omata rotu-tu ria supan tewa. ");
INSERT INTO nxl_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Au mo, poroti wan reuna mansia oamahaiso rotu-tu ria supan ukaisunu on roe noiyaha. Ia seia wain iai poroti rei mo, mka iamahaiki ikata Anahatana rotu-tu ria supan. Poroti wan uasau runai rei mo, Au ruaku tinaiku wan uruiki osi mansia mai tuniai reini na oamahaiso okata Anahatana rotu-tu ria supan.” ");
INSERT INTO nxl_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Sio Yahudiu rei oatinu san rei, oyo otuntana na umau. Oahata, “Ia hanaie reini ianamana ne sae reini? Sapani na irui tinain osi ita iaiki?” ");
INSERT INTO nxl_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Oyo Yesus iasau ata, “Oatinu mai ia-ia nanie uasau osimo. Ia sia wain iai Au Tumata reini Anahatana Ihitiku tinaiku tewa, na ininu nasiku tewa, ia mo, mka iamahaiki ikata Anahatana rotu-tu ria supan tewa. ");
INSERT INTO nxl_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ne ia sia wain iai Au tinaiku runa ininu nasiku mo, mka iamahaiki ikata Anahatana rotu-tu ria supan. Na mka unai iamahaiki honu tau tuniai reini nanie repena. ");
INSERT INTO nxl_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tea mo, Au tinaiku mo, muaine wan manisate. We nasi mo, mamninue wan manisate. ");
INSERT INTO nxl_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ia sia iai tinaiku na ininu we nasi mo, anoi osa runa Au nea. Na Au iae, anoku osa runa ia nea oi. ");
INSERT INTO nxl_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Au Amaku wain iapuhai pusire sahoro iaisosiku uhokaku mai tuniai reini. Na Au uamahaiku reini mo, noso Amaku iapuhaiku. Reiso sio wason oai Au tinaiku mo, mka oamahaiso rotu-tu ria supan noso sae wan Au unai osiso. ");
INSERT INTO nxl_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Reiso Au reini mo, poroti wan rekaisunui on roe noiyaha. Poroti wani Au uruiki mo, nooi sani poroti wan mo upu momou oaiki rei mo, tewa. Masike oai poroti rei iae omataso sirinia. Ne ia sia man iai poroti wan Au uruiki mo, mka iamahaiki ikata Anahatana rotu-tu ria supan.” ");
INSERT INTO nxl_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesus iasau runa rai pusire osi sio panesi reimo tau wain iatuhete sio panesi pan sio Yahudiu no numa mananoune pan kota Kapernaum. ");
INSERT INTO nxl_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Sio panesi wason opusu Yesus oatinu iruni rerihoni poroti rei oasau ata, “Maunaune reini mo, mtinte mainae. Ia sia man ianei kuai tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesus ianei ata sio wason saka oeu pusui rei wason oana-namanaso pani muie rerihoni ne maunauna waron iasaure osiso rei. Reiso iasau osiso ata, “Openemo oatinu uasau san rei nan tau sae? ");
INSERT INTO nxl_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Munata san rei, mka omi sapan sani onoo Au Tumata Reini Anahatana Ihitiku usaa na roe noiyaha honu? ");
INSERT INTO nxl_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Anahatana ne Inaha sahoro iuna mansia oamahaiso okatai rotu-tu ria supan. Mansia mo, ruai ikua iuna na iamahaiki rotu-tu ria supan mo, tewa. Maunauna waron uasau runare rei mo, on roe Anahatana ne Inaha. Maunauna rai raunamo oamahaimo okata Anahatana rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ne Au uanei ata arihoni omi reini mo, sio umau wason oparisaa we maunauna tewa.” Yesus iasau san rei tau, on naon-naone nea mo, ianei ia sia man wason oparisaa tanui tewa. Na ianei nea ia sia wain mka iaheniki. ");
INSERT INTO nxl_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Oyo iasau ata, “Omi umau wan oparisaa we maunauna tewa reiso uasau osimo nea ata hasae sio wason Anahatana ihuka anoo sahoro oparisaa tanuku na oamahaiso rotu-tu ria supan.” ");
INSERT INTO nxl_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Oni orase reini, sio panesi wason opusui rei, oeu oarihoniki na openeso oeu pusui nea. ");
INSERT INTO nxl_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Oyo Yesus iasei tau ami, ne mampusua hutusa rahana ua rei. Iahata, “Pene tu-tu omi iae nanie oeu oarihoniku oi?” ");
INSERT INTO nxl_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ne Petrus iasau osi Yesus. Iahata, “Upu, nanie aeuma tau ia sia honu? Hasae Ano man sahoro asima runa sapan na amahaima akata Anahatana rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ami aparisaa na anei ia-ia ata Ano mo, Ano manisate onate. Anahatana iaisosia ahokaya mai tuniai reini.” ");
INSERT INTO nxl_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Oyo Yesus iasau ata, “Masike Au ruaku sahoro uroma omi hutusa rahana ua reini tau we mampusua, ne ia isa arihoni omi reini mo, mka ipusu ia aia sakahatene ne maue.” ");
INSERT INTO nxl_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesus ianamana rerihoni Yudas. Yudas mo, amai tau Simon on pan nia Iskariot. Masike ia mo, ia isa arihon Yesus ne mampusua hutusa rahana ua rei iae, mka iaheniki sinia. ");
INSERT INTO nxl_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yesus ianamana osi sio panesi pusi, oyo ieu ihori otoe Galilea. Ipenei ieu poe otoe Yudea. Areimo tau sio Yahudiu no sio mainaya wason onina arena nanie ohunui. ");
INSERT INTO nxl_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ne tau rei mo, haineke ami Yahudiu ma karisaa wan oiki tau karisaa orueso sui wanana. ");
INSERT INTO nxl_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesus ne waniu oasau osiki ata, “Nene iake mo, aeua poe otoe Yudea na auna sima-simana arihon Anahatana poe rei na me mampusua rei onoore. ");
INSERT INTO nxl_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ia sia man wain inina na sio panesi oationai mo, iuna sae isa iauhun-iauhun tewa. Reiso sani me kawasa, areimo auna sima-simana arihon Anahatana na atuhete osi sio pusiso mai tuniai reini.” ");
INSERT INTO nxl_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ne waniu rei oasau san rei tau sio ruao iae oparisaa tanui tewa oi. ");
INSERT INTO nxl_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Reiso Yesus iasau osiso. Iahata, “Nene orase tau Au ueuku roe kota Yerusalem tewasi. Ne omi mo, supan man tau oeu iae iake. ");
INSERT INTO nxl_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Areimo tau sio mai tuniai reini mo, openeso tau omi tewa. Ne openeso tau Au. Openeso tanuku noso uasau ata no haliu waron kahatena. ");
INSERT INTO nxl_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Reiso omi oeumo na roe karisaa rei. Ne Au mo, ueu tewa. Tea mo, Au mo, nene orase tau ueu roe rei tewasi.” ");
INSERT INTO nxl_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesus iasau san rei pusi, oyo iruei pan otoe Galilea asi. ");
INSERT INTO nxl_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesus ne waniu oeuso roe karisaa wan orueso sui wanana rai. Oyo Yesus iae ieu pususo. Ne ieui mene-mene man na pene mansia hutue oaneiki. ");
INSERT INTO nxl_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Roe karisaa rei, sio Yahudiu no sio mainaya wason onina-nina Yesus. Oasei tau mansiau oahata, “Ia mo, wainpa?” ");
INSERT INTO nxl_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mansia panesi wason roe karisaa rei oarahuhu osi umau rerihoni Yesus. Sio umau oahata, “Ia mo, Ia mansia iake!” Ne sio umau honu oasau ata, “Tewa. Ia mo, Ia iakarota sio panesi.” ");
INSERT INTO nxl_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ne ia sia man ikaitau ianamana mainae rerihoni Yesus na mansia pusiki oatinu. Areimo tau okaitau sio Yahudiu no sio mainaya. ");
INSERT INTO nxl_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Karisaa rei reeu onona tonu te ate san rei nea, oyo Yesus ieui roe Anahatana ne numa mainisie nusue na iatuhete mansiau roe rei. ");
INSERT INTO nxl_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Sio Yahudiu no sio mainaya osira oatinu Yesus iatuhete sio panesi roe rei. Oasau ata, “Ia reini mo, isikola akama tewa, tea! Reiso sapan na ianamana san rei?” ");
INSERT INTO nxl_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Oyo Yesus iasau osiso ata, “Sae wan uatuhetei osimo reini mo, rehokai on mai Au ruaku mo, tewa. Ne usupui arihoni Anahatana wain iaisosiku rei. ");
INSERT INTO nxl_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ia seia nanie ipusu Anahatana ne maue mo, mka ianei ata sae waron Au uatuhetere reini mo, rahoka arihon Anahatana te arihon Au ruaku. ");
INSERT INTO nxl_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ia sia wain iatuhete mansia pusu ruai ne pikiran, areimo hasae inina na mansiau oamuira ia man. Ne Au uatuhete maunauna waron rauna mansiau oamuira Amaku wain iaisosiku rei. Areimo retuhete ata Au mo, uakarota tewa. Reiso oparisaa tau we matuhetene iae, iake. ");
INSERT INTO nxl_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Anomo rapeka runa Anahatana ne maunauna waron Musa ikanure rei. Ia sia man arihon omi ipusu pusire ia-ia tewa. Sinana opusure, areimo mka onina arena na ohunuku tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Oyo sio panesi oahata, “Amukea! Auwena na sakahatene reiso anamana san rei si? Ia sia nanie ihunua?” ");
INSERT INTO nxl_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesus iasau ata, “Au una sima-simane arihon Anahatana osa man tau ranie hatae wan ita Yahudiu iamuira Anahatana, oyo pusimo osira. ");
INSERT INTO nxl_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ne rerihoni ranie hatae wan ita Yahudiu iamuira Anahatana mo, naone Musa ikanu ata omi mo, kahurae orehi mo sio iki hanaia wason mato oamrai pannuhu no onona itu. Ne nene manisate mo, mo upu Abraham sahoro isupu maunaune rei naone. Reiso noso maunaune rei, omi iae taua-taua orehi mo hehuka hanaia tau ranie hatae wan iamuira Anahatana sirinia. ");
INSERT INTO nxl_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Omi orehi mo hehuka hanaia tau ranie hatae wan iamuira Anahatana sirinia repusu Musa ne maunauna, reiso nanie anomo rasaa tau Au noso usuisene ia isa pannuhu ranie hatae wan iamuira Anahatana nanie tau sae? ");
INSERT INTO nxl_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Pene oapasana Au tau onoo usuisene ia isa tau ranie hatae wan iamuira Anahatana rei. Pene arinii pusu sae waron mansiau onoore man. Ne kahurae onoo sae wan manisate na iakahai mansiau.” ");
INSERT INTO nxl_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tau Yesus ianamana osi sio Yahudiu roe Anahatana ne numa mainisie nusue roe kota Yerusalem mo, sio Yerusalem umau oasei tau umau ata, “Ia reini mo, Ia wain sio nanie ohunui rei, tea! ");
INSERT INTO nxl_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Masi onooi. Iatuhete mansia panesi san rei, ne sio mainaya osopoi tewa. Pene tu-tu oata kani Ia reini mo, Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau te sae rei? ");
INSERT INTO nxl_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ne Ia reini mo, Ia Aia wain Anahatana Ihitiki na Iapuheu mansia mo, tewa. Tea mo, sani Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau ihokai mo, ia sia man ianeiki tewa ata ihokai on supa. Ne Ia reini mo, ita ianei ihokai on supan.” ");
INSERT INTO nxl_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesus wain iatuheteso roe Anahatana ne numa mainisie nusue asi oyo iatinu oasau san rei, ianamana nioi mainae ata, “Omi oationaku na oanei Au reini mo, on supa. Areimo manisate. Ne uhokaku reini mo, pusu ruaku we maue mo, tewa. Ne uhokaku reini mo, Amaku sahoro iaisosiku. Omi oationai tewa. ");
INSERT INTO nxl_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ne Au mo, uationai. Tea mo, uhokaku reini mo, on roe Ia. Ia sahoro iaisosiku na uhokaku mai tuniai reini.” ");
INSERT INTO nxl_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Oatinui iasau ata Anahatana iaisosiki ihokai mai tuniai reini, sio onata onina arena na osota Yesus. Ne ia sia man arihon sio rei pusiso hanao rakahuui man tewa oi. Areimo, tau nene orase tewasi tau osotai. ");
INSERT INTO nxl_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ne arihon sio panesi wason noi rei mo, sio panesi oparisaa tanui. Oahata, “Ia seia man iuna kua sima-simana waron ratuhete ata ne kawasa arihon Anahatana panesi sani Ia onate reini tewa. Reiso, Ia onate reini mo, titue-tue Ia mo, Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau reini nea rei, tea!” ");
INSERT INTO nxl_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ne sio onata arihon akama Yahudiu oatinu sio panesi oarahuhu ata Yesus mo, Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau. Reiso okata sio imam no sio mainaya pusiso oeuso roe sio mamsaka Anahatana ne numa mainisie rei na oaisosiso oeu osota Yesus. ");
INSERT INTO nxl_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Reiso Yesus iasau osi sio panesi rei. Iahata, “Mka ukatamo potuina tewa nea. Nanie ununiku na urueku ukata Amaku wain iaisosiku uhokaku mai reini. ");
INSERT INTO nxl_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Omi mka oninaku ne osupuku tewa. Areimo tau omi mo, mka oeumo roe Au naniaku wan urueku rei mo, iake tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Oyo sio mainaya arihoni akama Yahudi rei pusiso oasau mai umau. Oahata, “Nanie ieui sui supan tu-tu ita mka isupui tewa? Kani nanie ieui sui niana-niana ikata sio Yahudiu wason orue oneka sio wason sio Yahudi tewa rei na iatuheteso te sae rei? ");
INSERT INTO nxl_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Iasau ata mka ininai ne isupu kuai tewa. Na iasau mka ieu noi naniai ikatai tewa. Iasau san rei nanie tau sae ano?” ");
INSERT INTO nxl_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nene onone wan tau muie, tau sio Yahudiu no karisaa wan oiki tau karisaa orueso sui wanana rei mo, onone wan mainae nai osa. Tau onone rei Yesus ihitio oyo ianamana nioi mainae. Iahata, “Ia seia man wain anoi kasae mo, ieu mai tanuku na ininu sae wan uruiki osiki na ininu. ");
INSERT INTO nxl_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Sio okanu tau Anahatana ne anamanaya rerihoni sio wason oparisaa tau Au ata, mka waena hunaya rania on pan anoo wan mka raunaso oamahaiso. ");
INSERT INTO nxl_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesus waimo ianamana rerihoni Anahatana ne Inaha. Sio wason oparisaa tau Yesus mo, mka Anahatana irui ne Inaha osiso. Ne Anahatana iruiki tewasi tau Yesus imatai na isaa isupu muiran manetane roe noiyaha tewasi.” ");
INSERT INTO nxl_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Sio umau oatinu Yesus iasau san rei oyo oahata, “Titue! Ia reini nea rei tea! Ia reini sahoro ia mamsima runa Anahatana ne maunauna wain ami anapa-napai rein, tea!” ");
INSERT INTO nxl_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Sio umau honu oasau ata, “Ia reini nea rei, tea! Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau rei, tea!” Ne sio umau honu oasau ata, “Tewa te sae rei? Ia Aia waini Anahatana Ihitiki na Iapuheu Mansiau mo, ihokai on poe otoe Galilea tewa, tea! ");
INSERT INTO nxl_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Sio okanu tau Anahatana ne anamanaya nea oi, tea! Okanu ata Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau mo, Ia aia Daud upui momoi wain iamrai pan kota Betlehem, ia aia Daud ne niane.” ");
INSERT INTO nxl_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Pusiso otuntana na umau noso Yesus. Sio umau oparisaa tau Yesus, ne sio umau mo, tewa. ");
INSERT INTO nxl_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sio umau nanie osotai, ne ia seia man hanai rekahuu man tewa oi. ");
INSERT INTO nxl_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sio mamsakaya wason osaka Anahatana ne numa mainisie rei onunso roe sio imam no sio mainaya runa sio onata arihon akama Yahudi wason oaisosiso rei. Oyo sio onata rei oasei tanso ata, “Ororiki mai tewa tau sae rei?” ");
INSERT INTO nxl_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Oyo sio mamsakaya rei oasau ata, “Rotu reini ami atinu ia sia man ianamana sani ia onate rei tewasi.” ");
INSERT INTO nxl_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Oyo sio onata arihon akama Yahudi rei oasau osiso honu ata, “Pene tu-tu iakarotamo oi te sae rei? ");
INSERT INTO nxl_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Masi onoo ia-ia ata ia isa arihoni re sio mainaya runa sio onata arihon akama Yahudi iparisaa tau Ia rei te tewa. Tewa, tea! ");
INSERT INTO nxl_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ne, sio panesi rei oparisaa tau Ia rei tau oanei Anahatana ne maunauna waron Musa ikanure rei tewa. Sio mo, mka Anahatana iapasanaso.” ");
INSERT INTO nxl_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ia isa arihon sio rei nanai Nikodemus. Ia mo, naone ieui noi Yesus tau pumono. Iasau osi sio wason ikataso rei ata, ");
INSERT INTO nxl_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“We amau. Ita mo, pusu Anahatana ne maunauna waron Musa ikanre rei kahurae iarinii ia isa ia-ia naone ee. Iasei tanui oyo iatinu tanui samatoro iapasanai sani resana.” ");
INSERT INTO nxl_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nikodemus iasau san rei oyo oasau osiki ata, “Ano reini mo, on pan otoe Galilea nooi sani ia hanaie reini oi te sae rei? Ano mo, arinii Anahatana ne maunauna ia-ia na anei ata Anahatana ne ia mamsima runa ne maunauna mo, ihokai on pani otoe Galilea tewa.”  ");
INSERT INTO nxl_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Oasau san rei suka, oyo pusiso onunso sakakau sui no numau. ");
INSERT INTO nxl_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ne Yesus ieui na roe Pupue Saitun. ");
INSERT INTO nxl_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Omnano tunne, imusui on roe pupue rei, oyo ieu honu roe Anahatana ne numa mainisie nusue. Mansia panesi ohoka oamanouso ohoriki, reiso irue iatuheteso. ");
INSERT INTO nxl_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Oyo sio matuhete Musa ne maunauna na sio onata arihon akama Yahudi orori ia pina isa na ounai iooi noi mansia hutue rei tihuo. Ia pina rei mo, osotai pannuhu inekei ikata ia hanaie wain sahai tanui tewa. ");
INSERT INTO nxl_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Oyo sio onata rei oasau osi Yesus. Oahata, “Ano Matuhetene! Ami asota ia pina rei pannuhu inekei ikata ia hanaie wain sahai tanui tewa. ");
INSERT INTO nxl_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Tau Anahatana ne maunauna waron Musa ikanure rei mo, iaisosima na arau ia pina wain san reini tau hatu rotu-tu imatai. Reiso pusu Ano mo, sapan?” ");
INSERT INTO nxl_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Oasei tau Yesus san rei nanie oreai na onoo ata Yesus iasau sapan na oapasanai iake. Ne Yesus iamaturui man. Ikanahata ikanu poe tuamane tau hanai nakate. ");
INSERT INTO nxl_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Sio onata rei oasei tau Yesus sui osa, oyo Yesus ihitioi roe, iasau osiso. Iahata, “Ia seia wain iahana ruai ipalalosa tewa nai osa mo, masi iakahuu hatu na irau ia pina rei naone.” ");
INSERT INTO nxl_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Iasau san rei pusi, ikanahata honu, ikanu poe tuamane honu. ");
INSERT INTO nxl_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ne sio onata rei oatinu Yesus iasau san rei, oyo oeuso arihon rei sana osa-osa. Sio mtuana oeuso arihoni rei naone, samatoro sio honua rotu-tu tau muie oimo, nesie Yesus na ia pina rei ruao man. ");
INSERT INTO nxl_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Oyo Yesus ihitio roe, iasei tau ia pina rei. Iahata, “Ina, sio rei wasunpa nea rei? Sio umau apasanaya tewa?” ");
INSERT INTO nxl_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Oyo ia pina rei iahata, “Tewa nea, Upu.” Oyo Yesus iasau osiki honu. Iahata, “Au iae uapasanaya tewa oi. Nunia nea ne pene apalalosa nea.” ");
INSERT INTO nxl_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesus ianamana osi sio panesi wason oamanouso roe Anahatana ne numa mainisie nusue rei honu. Iahata, “Au mo, noo sani manahane osi mansia pusiki mai tuniai reini anoo. Nooi sani manahane resita sae man wan noi pumono na inoo mosai. Ia sia man wain ipusu Au mo, mka ieu pusu pumono tewa. Ne ieu pusu manahane. Manahane rei retuhetei sapani na mka iamahaiki ikata Anahatana rotu-tu ria supan.” ");
INSERT INTO nxl_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Oyo sio onata arihon akama Yahudi oasau osiki. Oahata, “Wamo asima na ruam reiso kani ia sia nanie iparisaa tau Ano?” ");
INSERT INTO nxl_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesus iahata, “Masike usima na ruaku, ne sae wan uasau runai rei mo, pusire titue. Areimo, tau uanei ata Au mo, uhokaku on roe noiyaha. Na Au iae uanei ata mka ununiku roe rei honu. Ne omi mo, oanei tewa, Au on supa na mka ununiku sui supan. ");
INSERT INTO nxl_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Omi oarinii mansia pusu sae waron mansia onoore. Ne Au mo, Au wan rei na nanie uasau ata uarinii ia sia man mo, tewa. ");
INSERT INTO nxl_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ne sani uarinii mansia, sae waron uasau nnare mo, manisate. Areimo tau Au ruaku sahoro uariniiso mo, tewa. Au na Amaku wain iaisosiku rei, uama sahoro ariniiso. ");
INSERT INTO nxl_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Musa ikanu tau Anahatana ne maunauna waron orimere ata sani amanaru mansia mo, kahurae me sio ua wason onoo tau matao na kahurae no sou osa, samatoro oasau ata sae wani oasaui rei mo, titue. ");
INSERT INTO nxl_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Sio wason osima na Au iae, sio ua oi. Au usima osimo rerihon Au ruaku, na Amaku wain iaisosiku isima osimo rerihoni Au oi.” ");
INSERT INTO nxl_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Oyo sio onata rei oasei tau Yesus oahata, “Munata san rei mo, Amam wainpa?” Yesus iahata, “Oationa Au tewa reiso omi iae oationa Au amaku tewa oi. Sinana oationa Au, mka oationa Amaku oi.” ");
INSERT INTO nxl_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesus iatuhete rai pusire roe Anahatana ne numa mainisie nusue haineke peti maiinu kepen waron oruire osi Anahatana. Ne osotai tewa. Areimo, tau nene orase tau osotai tewasi. ");
INSERT INTO nxl_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesus ianamana honu osi sio panesi. Iahata, “Mka ueu arihonimo. Oyo reeu mai, mka oninaku, ne mka omatamo Anahatana isiru heu mo rosau tewa. Mka oeu okataku roe naniaku wan Au mka ueuku roe tanui rei tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Oyo sio onata Yahudiu oasei mai umau. Oahata, “Pene tu-tu nanie ihunu ruai te sae rei? Reiso sinasi iasau ata ieu ikatai roe naniai wan mka ieui roe tanui rei, ieu iake tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ne Yesus iahata, “Omi mo, oamrai mai tuniai reini. Ne Au mo, uhokaku on roe noiyaha. Naniamo mai tuniai reini. Ne Au mo, tewa. ");
INSERT INTO nxl_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Reiso sinasi uasau osimo ata mka ereeu mai, omatamo mo, Anahatana isiru heu mo rosau tewa. Sani oparisaa tewa ata Au mo, Au seia wain uasau runai osimo nea rei, mka omatamo ohana ruamo mo rosau.” ");
INSERT INTO nxl_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Reiso oasau osiki ata, “Ano ata kan Ano mo, Ano seia na asau san rei?” Oyo iahata, “Oni mataanoe uatuhete mo, uasau osimo nea rerihoni Au reini mo, Au sia. ");
INSERT INTO nxl_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nanie uasau osimo rerihoni mo rosau panesi asi. Ne, hasae nanie uasau rerihon sae waron Ia wain iaisosiku inina na uasau runare rei man. Sae waron iasau runare mo, titue. Usima osi sio mai tuniai reini runa sae waron uatinure arihoniki rei.” ");
INSERT INTO nxl_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ne oanei tewa ata Yesus wain ianamana rerihoni Amai wain roe noiyaha. Ia mo, ianamana rerihoni amai wain mai tuniai reini mo, tewa. ");
INSERT INTO nxl_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Reiso iahata, “Au Tumata Reini Anahatana Ihitiku mo, uhokaku on roe noiyaha. Ne tau ohunuku roe hini, samatoro mka oanei ata Au mo, Au sia. Omi iae mka oanei ata sae man wan unai mo, unai tau ruaku we kawasa tewa. Ne usima na sae waron Amaku iatuheteku tanre. ");
INSERT INTO nxl_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ia sahoro iaisosiki, ikata runaku sui osa. Ieu arihoniku tewa. Tea mo, Au una sae man pusu ne maue.” ");
INSERT INTO nxl_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Oatinu Yesus iasau rai pusire, sio panesi oparisaa tanui. ");
INSERT INTO nxl_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesus iasau osi sio Yahudiu wason oparisaa tanui nea rei. Iahata, “Sani munata opusu we maunauna, areimo titue-tue Au we mampusua tanumo. ");
INSERT INTO nxl_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Omi mka oanei Anahatana ne maunauna waron manisata. Maunauna rai sahoro mka raunamo osihamo arihoni mo rosau na pene ouna sani maniane tanre nea.” ");
INSERT INTO nxl_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ne sio umau ouni oahata, “Ami mo, Abraham ne upu momou. Ia sia man iunama tau ne maniane tewasi. Reiso sapan na Ano asau ata ami mka asihama?” ");
INSERT INTO nxl_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Oyo Yesus iasau ata, “Oatinu mai ia-ia, nanie uasau osimo. Ia sia ipalalosa sui osa, areimo ipusu ne hali wan ipalalosa rei man, nooi sani ia maniane kahurae ipusu upui man sui osa. ");
INSERT INTO nxl_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tumata maniane mo, iruei sui osa noi upui ne numa tewa. Ne upui anai hanaie man sahoro iruei noi numa sui osa rotu ria supan. ");
INSERT INTO nxl_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Reiso sani Au, Anahatana Anai reini, unamo sihamo arihoni mo rosau, areimo titue-tue osihamo nea. ");
INSERT INTO nxl_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Au uanei ata omi mo, Abraham ne upu momou. Ne onina arena nanie ohunuku tau openemo oatinu tau we maunauna. ");
INSERT INTO nxl_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Sae waron uatuhetere osimo reini mo, pusire unoo oni ukata Amaku. Omi iae, ouna sae waron oatinu arihoni mo ama.” ");
INSERT INTO nxl_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Oyo oasau osi Yesus ata, “Ami mo, ma upu tau Abraham.” Ne iasau ata, “Sani munata omi mo, Abraham ne upu momou, omi mo, kahurae mo hali kalakuan noo sani Abraham oi. ");
INSERT INTO nxl_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Au reini sahoro usima na sae waron manisata waron uatinure arihon Anahatana osimo. Ne omi onina arena sui osa nanie ohunuku. Aikee Abraham mo, iuna san rei tewa. ");
INSERT INTO nxl_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Reiso titue, omi mo, ouna sae waron mo ama tamene iunare.” Oahata, “Ami mo, ami ana hua tewa. Ami mo, mani Ama osa man. Ia mo, Anahatana ruai.” ");
INSERT INTO nxl_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesus iasau osi sio ona Yahudiu. Iahata, “Sani munata Anahatana mo, omi mo ama, areimo omi mka anomo na Au. Tea mo, uhokaku on roe Anahatana. Au wan reini mo, uhokaku pusu ruaku we maue tewa, ne uhokaku pusu Ia wain iaisosiki ne maue. ");
INSERT INTO nxl_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Omi mo, openemo tau we maunauna. Reiso oaneire tewa. ");
INSERT INTO nxl_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Omi mo, mo ama tau ia aia sakahatene. Reiso omi mo, mo suka tau pusu ne maue. Oni mataanoe asi, ia aia sakahatene mo, saka ihunu mansia. Ia mo, ipenei tau sae wan manisate. Areimo tau ia mo, ia makarota onate. Makarotana pusire rahoka arihon ia. ");
INSERT INTO nxl_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ne Au we maunauna mo, manisata. Reiso openemo oparisaa tau Au. ");
INSERT INTO nxl_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Upalalosa tewa reiso sia man arihon omi reini mka iatuhete we rosa isa wani unai tewa. Uatuhete sae wan manisate, reiso nanie oparisaa tanuku tewa tau sae? ");
INSERT INTO nxl_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ia sia wain iuna Anahatana ne mansia mo, mka iatinu Anahatana ne maunauna. Ne omi mo, Anahatana ne mansiau tewa, reiso oatinure tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Sio ona Yahudiu oasau osi Yesus honu. Oahata, “Sae wan ami asau rei mo, titue. Ano Samaria reini mo, amukea na sakahatene remasunia.” ");
INSERT INTO nxl_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesus iahata, “Au mo, sakahatene remasuniku tewa. Au mo, uamuira Amaku, ne omi oamuira Au tewa. ");
INSERT INTO nxl_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Au mo, unina na oamuiraku mo, tewa. Ne Ia isa wain inina na oamuiraku. Ia sahoro iarinii ia sia wain ia manisate, ia sia wain ia manisate tewa. ");
INSERT INTO nxl_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Oatinu mai ia-ia, nanie uasau osimo. Ia seia ipusu we maunauna, ia mo, mka imata rotu-tu ria supan tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Oyo sio ona Yahudiu rei oahata, “Mato anei ia-ia ata Ano mo, sakahatene remasunia. Ma upu Abraham imatai nea. Na sio mamsima runa Anahatana ne maunauna omataso nea oi. Ne Ano asau ata sio wason oatinu tau me maunauna mo, mka omata tewa. ");
INSERT INTO nxl_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ano reini mo, masike nai osa. Ano ata kan Ano mo, Ano mainae anesi ma upu Abraham. Ia mo, imatai nea. Na sio mamsima runa Anahatana ne maunauna iae omataso nea oi. Ano mo, auna ruam noo sani Ano mo, ano mainae anesi sio pusiso, reiso asau ata sio wason opusu me maunauna mka omata tewa?” ");
INSERT INTO nxl_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Oyo Yesus iahata, “Sani Au ruaku sahoro unina mansia na oamuiraku mo, oparisaa tanuku tewa iae, iake sinia. Ne ia wain iamuiraku mo, Amaku. Ia rei mo, Anahatana wain omi oasau ata oainisi ainaa nnai. ");
INSERT INTO nxl_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Omi oationai tewa, ne Au uationai. Sani uasau ata uationai tewa, areimo uakarota sani omi oi. Ne Au mo, uationai na upusu ne maunauna. ");
INSERT INTO nxl_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mo upu Abraham anoi mirike nai osa tau iatinu rerihoni sae waron Au mka unare mai tuniai reini. Noo sani inoore oni mataanoe asi, ikaumin nea.” ");
INSERT INTO nxl_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Oyo oasau ata, “Me musum hutu nima tewasi oimo, Ano asau ata anoo ma upu Abraham nea si?” ");
INSERT INTO nxl_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Oyo iahata, “Oatinu mai ia-ia, nanie uasau osimo. Abraham ain tewasi mo, Au wan naone nea.” ");
INSERT INTO nxl_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Oatinu Yesus iasau san rei, oyo oroma hatu na oraui na ohunui. Tau oata kani Yesus iuna ruai sani Ia mo, Anahatana. Ne Yesus iunaso onoo mosai tewa, oyo ihitio ieui mene-mene arihon Anahatana ne numa mainisie rei. ");
INSERT INTO nxl_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Taue isa, Yesus na ne mampusua wason oeu. Oyo inoo ia hanaie isa wain matai raputiso on iamrai asi. ");
INSERT INTO nxl_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Oyo ne mampusua oasei tanui ata, “Ano Matuhetene. Ia reini matai raputiso on iamrai reimo, tau inai na amai no rosau te ia ruai ne rosau?” ");
INSERT INTO nxl_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesus iahata, “Matai raputiso reimo, tau ruai ne rosau mo, tewa. Tau inai na amai no rosau iae, tewa oi. Ne matai raputiso rei mo, na mansiau onoo Anahatana ne kawasa noso isuisene ia rei. ");
INSERT INTO nxl_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","5","Oni Au wan tuniai reini asi, Au sahoro una mansiau oationa Anahatana. Reiso Au sani manahane. Manahane reuna mansia onoo sae wan noi pumono. Reiso oni manahane asi, Ita mo, kahurae ipakarian pusu Amaku wain iaisosiku ne maue. Tea mo, sani nanie imatata, areimo sani pumono nea oyo sia man mka ipakarian tewa nea.” ");
INSERT INTO nxl_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Iasau san rei pusi oyo, ihuto poe tuamane. Oyo inehu ne apana rai na tuamane rotu ranehu umau, samatoro ikusare roe ia mata putie rei matai usena. ");
INSERT INTO nxl_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Oyo iahata, “Eua poe waene wan nanae Siloam na auneua.” (Siloam tau sou Ibrani nene nohue mo, aisosi.) Reiso ia mata putie rei ieu iauneui poe waene rei. On poe inuni mai oimo, inoo mosa nea. ");
INSERT INTO nxl_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Sio mansiau sui ne numa nusue na sio wason naone saka onooi iai-iainisi kepen oasau ata, “Ia reini mo, ia wain naone saka irue iai-iainisi kepen rei si?” ");
INSERT INTO nxl_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sio umau oi oasau ata, “Titue, Ia rei tea!” Sio umau honu oasau ata, “Tewa! Ia rei tewa. Ia reimo ia isa wain uai anoe sani ia rei oi.” Ne ia ruai iahata, “Titue. Ia reimo, Au reini, tea!” ");
INSERT INTO nxl_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Oyo oasei tanui ata, “Reiso sapan tu-tu anoo mosa reini?” ");
INSERT INTO nxl_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Iahata, “Ia wain nanai Yesus ihuto poe tuamane oyo inehu ne apana rai na tuamane oyo inanai ikusare roe mataku usena. Oyo iaisosiku ueu uauneuku poe waene wan nanae Siloam. Reiso ueuku poe uauneuku oyo unoo mosa rei sirinia.” ");
INSERT INTO nxl_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Oasei tanui ata, “Reiso ia onate rei wain sui supan?” Iahata, “Uanei tewa” ");
INSERT INTO nxl_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Yesus isuisene ia mata putie oyo orori ia mata putie rei roe sio onata arihon akama Yahudi. ");
INSERT INTO nxl_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesus inehu ne apana na tuamane oyo isuisene ia mata putie rei pannuhu ranie hatae wan ami Yahudiu amuira Anahatana. ");
INSERT INTO nxl_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Reiso sio onata oasei tanui. Oahata, “Sapani na tu-tu anoo mosa rei?” Iahata, “Ia onate isa inehu ne apana na tuamane oyo inanai ikusare roe mataku usena. Oyo uauneuku oyo unoo mosa rei sirinia.” ");
INSERT INTO nxl_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Reiso sio onata arihon akama Yahudiu umau oasau ata, “Ia onate rei mo, Anahatana iaisosiki rei mo, tewa. Areimo tau ipakarian tau ranie hatae wan ita Yahudiu iamuira Anahatana.” Ne sio umau honu oasau ata, “Ne sio palalosaya mo, omaha ouna sima-simane wan retuhete ata no kawasa arihon Anahatana san reini tewa!” Reiso anoo osa tewa. ");
INSERT INTO nxl_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Oyo oasau osi ia wain naone matai raputiso rei. Oahata, “Ano sahoro isuisenea. Reiso pusu ano ruam mo, ia onate rei mo, ia seia?” Oyo iahata, “We amau. Sani pusu au ruaku mo, ia onate rei mo, ia mamsima runa Anahatana ne maunauna.” ");
INSERT INTO nxl_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ne sio onata rei oparisaa tewa sirinia ata ia hanaie reimo, matai raputiso on iamrai asi. Ne wain inoo nea. Reiso oaisosi ia isa ioi ia hanaie rei ne mansia mainaya. ");
INSERT INTO nxl_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Oyo oasei tau ne mansia mainaya. Oahata, “Ia reini mo, omi mo hehuke hanaie wain ata matai raputiso on iamrai rei si? Sani munata titue, reiso sapani na inoo mosa nea rei?” ");
INSERT INTO nxl_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ne mansia mainaya oasau ata, “Titue, ia reini mo, ami ma hehuke. Titue, ia mo, matai raputiso on iamrai asi. ");
INSERT INTO nxl_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ne ami anei tewa ata sapan na inoo mosa nea. Ami iae anei tewa ata ia seia isuisene matai usena rai. Nene iake mo, ruamo oasei tanui. Ia mainae nea, reiso ruai mka iasau osimo.” ");
INSERT INTO nxl_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Oasau san rei tau okaitau sio onata arihon akama Yahudi. Tea mo, sio onata ohunu sou na ia sia wain iasau ata Yesus mo, Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau mo, pene oheta sio Yahudiu no numa mananoune nea. ");
INSERT INTO nxl_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Erepusu rei, reiso oasau ata, “Ia mainae nea reiso oasei tau ruai.” ");
INSERT INTO nxl_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Reiso sio onata rei ooi ia wain naone matai raputiso rei honu. Oahata, “Anahatana wain iatinu reiso asau sae wan titue osima. Ami anei ata Yesus mo, ipalalosa.” ");
INSERT INTO nxl_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Oyo iahata, “We amau. Au uanei tewa ata Ia mo, ipalalosa te tewa. Hasae uanei mo, naone mataku usena raputiso, ne muie reini unoo mosa nea.” ");
INSERT INTO nxl_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Oyo oasei tanui honu. “Iuna sae tu-tu anoo mosa nea rei?” ");
INSERT INTO nxl_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Iahata, “Are! Uasau osimo on sinasi nea rei, ne openemo oatinu tanuku. Nanie oatinu uasau osimo honu tau sae? Pene tu-tu omi nanie ouna ne mampusua oi te sae rei omi?” ");
INSERT INTO nxl_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Oyo orati sohiki. Oahata, “Ano sahoro auna Ia ne mampusue. Ami mo, tewa. Ami mo, Musa ne mampusua. ");
INSERT INTO nxl_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ami anei nea ata Anahatana ianamana osi Musa. Ne Ia rei mo, ami anei tewa ata ihokai on supa.” ");
INSERT INTO nxl_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Iahata, “Ira oe! Areimo sapan? Ia onate rei isuisene mataku usena rotu unoo mosa nea. Ne omi oasau ata oanei tewa ata ihokai on supa! ");
INSERT INTO nxl_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Pusita ianei ata Anahatana mo, iatarima sio palalosaya no mainisia tewa. Anahatana mo, hasae iatarima sio wason oamuirai na sio wason opusu ne maue no mainisia man. ");
INSERT INTO nxl_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ia seia man iatinu tewasi ata ia wain matai raputiso on iamrai inoo nea sani au reini. Iatinu san rei tewasi on tuniai reini remrae rotu-tu reini. ");
INSERT INTO nxl_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Munata Ia onate rei ihokai on roe Anahatana tewa, mka imaha iuna sae isa tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Oatinu san rei oahata, “Oni amrai asi mo, me rosau panesi nea. Ano mo, ano seia na atuhete ami reini?” Oyo oneiki. ");
INSERT INTO nxl_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesus iatinu ata sio mainaya rei onei ia wain naone matai usena raputiso rei na pene iheta ami Yahudiu ma numa mainisie. Isupui oyo iasei tanui. Iahata, “Ano parisaa tau Tumata wain Anahatana Ihitiki te tewa?” ");
INSERT INTO nxl_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Oyo iahata, “Upu! Ia reimo, ia seia? Sima osiku mai na uparisaa tanui.” ");
INSERT INTO nxl_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesus iahata, “Anoo Ia rei nea. Ia rei mo, Ia wain anamana runaya reini.” ");
INSERT INTO nxl_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Oyo ia rei iahata, “Upu! Au uparisaa.” Oyo irike tune, iainisi iainaa nnai. ");
INSERT INTO nxl_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Oyo Yesus iasau honu. Iahata, “Uhokaku mai tuniai reini mo, nanie uarinii ia sia wain ia manisate, ia sia wain ia manisate tewa. Uatuhete arena osi sio wason oationa Anahatana tewa na oationai. Areimo noo sani una ia mata putie inoo. Ne sio wason oasau ata oationa Anahatana mo, Au mka uatuhete ata sio mo, oanei sae isa tewa. Areimo sani sio wason ata kani onoo mosa, oyo sira tau onoo mosa tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Sio onata arihon akama Yahudi umau wasumo oatinu san rei oyo oasei tau Yesus. Oahata, “Sae rei? Wamo asau reno mo, Ano ata kani ami mo, matama raputiso si?” ");
INSERT INTO nxl_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iahata, “Sani ruamo oamanaku ata matamo raputiso, areimo omi mo, opalalosa tewa. Ne omi wamo oasau ata omi mo, onoo mosa. Areimo omi ohana mo rosau asi.” ");
INSERT INTO nxl_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesus iasau ata, “Atinu mai ia-ia, nanie uasau osimo. Ia sia wain inusui pani rompau nene koka ne ipusu mitanunue tewa, ne isaai pusu koka iauhun mo, ia rei nanie ikimanaka rompau rai. ");
INSERT INTO nxl_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ne ia wain inusui pani rompau nene koka pusu mitanunue, ia reimo, ia mamsaka rompau. ");
INSERT INTO nxl_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ia wain isaka koka nene mitanunue ihuka mitanunue osi ia mamsaka rei. Ia mamsaka ioi nanaya sana osa-osa, rationa nioi. Pusi, oyo iautunure rahoka arihon koka. ");
INSERT INTO nxl_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ihoka pusi ne rompau arihon nene koka nea, oyo ieu roe uae sui osa iautunure. Rompau rai rationa nioi reiso raeu rapusu-pusui hae muie. ");
INSERT INTO nxl_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ne rompau rai raeu rapusu ia tamene wain rationai tewa. Ne mka rarumaso arihoni ia rei. Tea mo, rationa nioi tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesus iruni matieue rerihon ia mamsaka rompau rei ne olai kua Yesus anoi tewa sirinia. ");
INSERT INTO nxl_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Reiso iahata, “Oatinu mai ia-ia, nanie uasau osimo. Au reini mo, sani koka nene mitanunue wan rompau ranusu pan koka anoe. Tea mo, Au mo, mitanunue na mansiau oeuso mai Anahatana. ");
INSERT INTO nxl_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mansiau umau ohokaso oanaoneku na oasau ata sio mo, sio mamsaka rompau. Sio reimo, sio kimanakana. Ne rompau rai rapeneso rapusu sio. ");
INSERT INTO nxl_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Au reini mo, sani mitanunue. Mka Anahatana iapuheu ia sia man wain ihokai mai tanui inusu pusu Au. Mka inusu hoka sae isa remunai tewa sani rompa renusu hoka koka renina nene muaina mo, iake. ");
INSERT INTO nxl_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Sio kimanakana ohoka tau hasae okimanaka, ohunu, na ouna akahate. Ne Au mo, uhokaku mai tuniai reini na mansia oamahaiso okata Anahatana rotu-tu ria supan na urui iake osiso. ");
INSERT INTO nxl_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Au reini mo, Au sani mamsaka rompau wain isaka ne rompau ia-ia. Isaka ne rompau ia-ia mo, masike nanie imatai iae, hete sae ne rompau ramahaiso. ");
INSERT INTO nxl_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ne ia wain isupu seha-seha na inoo na rompau rai mo, noo sani mamsaka rompau rai tewa. Mamsaka rompau mo, rompau nene upue. Ia wain isupu seha-seha rei inoo asu wesie rehokai, oyo irumai arihoni rompau rai. Oyo asu wesie rei reoto rompa isa na nesia raruma rawena-wenaso. ");
INSERT INTO nxl_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ia wain isupu seha-seha rei irumai, areimo tau ia mo, hasae isupu seha-seha man. Reiso anoi runare tewa. ");
INSERT INTO nxl_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Au reini mo, Au sani mamsaka rompau wain isaka ne rompau ia-ia. Au sahoro unoo runare ia-ia. Masike mka umataku iae hete sae we rompa ramahaiso. Uationa we rompau. We rompau iae rationaku oi. Noo sani Amaku iationa Au na Au uationa Amaku oi. ");
INSERT INTO nxl_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Au iae we rompau tamena wason oamanouso tewasi na we rompau waron mai koka. Reiso Au iae kahurae urorire na uamanou pusire tau osa. Rompau tamena rai oi mka raatinu nioku. Rompau rai pusire mka ramanouso tau osa. Au mka una mamsakae tau pusire. ");
INSERT INTO nxl_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Amaku anoi runaku. Areimo tau urui ruaku na umataku hete sae we rompau ramahaiso. Ne umataku, mka uamahaiku honu. ");
INSERT INTO nxl_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ia isa ihunu Au mo, tewa. Ne Au ruaku sahoro urui ruaku na sio ohunuku. Au we kawasa urui ruaku na umataku runa we kawasa uamahaiku honu. Amaku iaisosiku na una san rei.” ");
INSERT INTO nxl_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Sio ona Yahudiu oatinu Yesus iasau san rei, oyo otuntana na umau honu. ");
INSERT INTO nxl_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Sio panesi oasau ata, “Sakahatene remasuniki reiso imukei. Pene atinu tau Ia!” ");
INSERT INTO nxl_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ne sio umau oasau ata, “Tumata waini sakahatene remasuniki mo, ianamana san rei tewa. Tumata wain sakahatene remasuniki mo, ne kawasa isuisene ia mata putie tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nene onone tau karisaa anoo rapeka runa oseka tau Anahatana ne numa mainisie wan no nisa iuna apaputiki roe kota Yerusalem. Tau rei mo, mahatane nanie. ");
INSERT INTO nxl_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesus ieu roe Anahatana ne numa mainisie ieu sui Salomo ne teune. ");
INSERT INTO nxl_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Oyo sio ona Yahudiu oo ohoriki. Oyo oahata, “Munata titue Ano mo, Ia Aia waini Anahatana Ihitiki na Iapuheu Mansiau mo, asau osima mai nea. Pene unama asei-asei pan anoma.” ");
INSERT INTO nxl_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Oyo Yesus iahata, “Uasau osimo nea rei. Ne oparisaa tanuku tewa. Au una sima-simana panesi osimo nea. Tea mo, Amaku irui kawasa osiku na una rai pusire nea. Sima-simana waroni unare reimo na ratuhete osimo ata Au reini Au seia. ");
INSERT INTO nxl_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ne oparisaa tanuku tewa. Tau omi mo, omi sani rompau waron nene mamsaka tamene. ");
INSERT INTO nxl_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Au we mansiau oatinu tanuku sani rompau oatinu tau no mamsaka rompau. Uationa we mansiau na opusuku. ");
INSERT INTO nxl_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Au unaso oamahaiso kata Anahatana rotu-tu ria supan. Reiso mka omata rotu-tu ria supan tewa. Ia seia man iwahuso arihoni hanaku anoe tewa. ");
INSERT INTO nxl_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Amaku sahoro iruiso osiku. Amaku mo, Ia mainae inesi ia seia man. Reiso ia seia man iwahuso arihon Amaku hanai anoe tewa. ");
INSERT INTO nxl_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Au na Amaku mo, uama osa.” ");
INSERT INTO nxl_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Oyo sio ona Yahudiu oroma hatu honu nanie oraui na ohunui. ");
INSERT INTO nxl_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ne Yesus iahata, “Omi onoo sima-simana panesi nea waron Amaku iaisosiku na unare. Reiso arihon sima-simana rai mo, sima-simane sae sahoro reunamo na nanie orauku tau hatu na ohunuku?” ");
INSERT INTO nxl_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Oyo oasau ata, “Araua tau hatu pusu sima-simana tewa. Ne Ano anamana sani Ano mo, Anahatana rei. Aikee Ano mo, Ano mansia sani ami oi. Ne auna ruam sani ano mo, Anahatana rei.” ");
INSERT INTO nxl_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Oyo Yesus iahata, “Sio okanu tau Anahatana ne anamanaya ata Anahatana iasau osi sio Yahudiu no sio mainaya ata, ‘Au uanamana osimo sani omi mo, mo hali noo sani Au ruaku oi.’ ");
INSERT INTO nxl_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Omi anei ata sae man waron sio okanure tau Anahatana ne anamanaya mo, pusire manisata. Reiso noo sani Anahatana ruai iasau ata sio wason osupu ne anamanaya mo, no hali sani Ia ruai. ");
INSERT INTO nxl_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Anahatana iromaku na iaisosiku uhokaku mai tuniai reini. Reiso, sani uasau ata, ‘Au mo, Anahatana Anai’, pene anomo rasaa. Pene oasau ata Au uanamana sani Au mo, Anahatana rei. ");
INSERT INTO nxl_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Sani Au una sae waron Amaku iunare tewa, areimo pene oparisaa tanuku. ");
INSERT INTO nxl_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ne sani Au una sae wan rehiti Amaku uai anoe rei, masike oparisaa tanuku tewa sirinia iae, kahurae oparisaa tau sima-simana waroni Au unare rei. Parisaare na oanei ia-ia ata Au na Amaku mo, uama osa.” ");
INSERT INTO nxl_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Oatinu Yesus iasau san rei, oyo osota rea Yesus honu. Ne Yesus ieui arihonso. ");
INSERT INTO nxl_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Oyo Yesus isipu toha Wae Yordan na ieui ria hae, oyo iruei ria rei. Naone Yohanis isohu mansiau ria rei na mansiau oanei ata oarihoni no rosau nea. ");
INSERT INTO nxl_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mansia panesi ohokaso mai tanui. Oahata, “Yohanis mo, iuna sima-simane wan retuhete ata ne kawasa arihon Anahatana isa man tewa oi. Ne sae waron iasau rerihon Ia onate reini mo, pusire manisata.” ");
INSERT INTO nxl_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Sio wason oeuso noi Yesus rei, sio panesi oparisaa tanui. ");
INSERT INTO nxl_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Ia hanaie isa wain nanai Lasarus. Ia mo, irue poe nia Betania. Iruei ikata ne hotau sio ua. Ne hotau rei nanao mo, Maria na Marta. Maria sahoro mka isona Upuri Yesus ain atua tau mina hau rihue samatoro ikusa Yesus ain atua tau ne huau. Taue isa Lasarus ikupui mtinte. ");
INSERT INTO nxl_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Reiso ne hotau ua rei oaisosi ia isa ieu isima osi Yesus rerihoni Lasarus. Hoka poe, iasau osi Yesus ata, “Upu, ia wain anom runai nai osa rei waipo ikupui.” ");
INSERT INTO nxl_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesus iatinu san rei, oyo iasau ata, “Kupue reimo, mka rehunui tewa. Ne, kupue reimo, mka reuna mansia onoo Anahatana ne kawasa wani mainae nai osa na mansiau oamuira Au, Anahatana Anai.” ");
INSERT INTO nxl_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesus anoi runa Maria, Marta, na Lasarus. ");
INSERT INTO nxl_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ne iatinu ata Lasarus ikupui, oyo iruei noi rei onona ua asi. ");
INSERT INTO nxl_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Iruei onona ua pusi, samatoro iasau osi ami, ne mampusua. Iahata, “Mai na inunta poe otoe Yudea honu.” ");
INSERT INTO nxl_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Atinu san rei ahata, “Ano Matuhetene. Mato-mato rei man sio ona Yahudiu poe rei nanie oraua tau hatu. Reiso nanie anunia poe rei honu tau sae?” ");
INSERT INTO nxl_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ne Yesus nanie iasau ata sani sae isa remunai, areimo pusu Amai ne maue. Reiso iahata, “Ranie hatae osa, ranie resita yam hutusa rahana ua. Reiso sani ieu tau ranie mo, mka iamasiru tewa tau inoo mosa arena. ");
INSERT INTO nxl_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ne ia seia ieu tau pumono mo, mka iamasiru tau manahane tewa, reiso inoo mosa arena tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesus iasau honu ata, “Re neta Lasarus mo, waipo inekei. Ne nanie ueu poe uhanui.” ");
INSERT INTO nxl_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Oyo ami, ne mampusua asau ata, “Upu, munata waipo inekei mo, mka ne kupue rei iake, tea!” ");
INSERT INTO nxl_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesus waimo iasau reimo, rerihoni Lasarus waipo panokoi nea. Ne ami ata kani Lasarus mo, waipo inekei man. ");
INSERT INTO nxl_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Reiso Yesus iasau iau-iauhun osima tewa. Iahata, “Lasarus mo, panokoi nea. ");
INSERT INTO nxl_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Panokoi tu-tuku tewa mo, tau omi mo iake. Tea mo, mka omi oparisaa tau Au ia-ia honu. Mai, na ieuta poe inooi.” ");
INSERT INTO nxl_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yesus ne mampusue isa wain nanai Tomas. Sio oiki tau Ia Iki Alaleka. Iahata, “Munata san reimo, mai na pusita ieu ikatai. Na pusita imatata ikatai oi.” ");
INSERT INTO nxl_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesus na ami, ne mampusua, ahokama poe nia Betania, samatoro anei ata Lasarus mo, sio atasiniki pan kupuro anoe onona ate nea. ");
INSERT INTO nxl_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Nia Betania mo, kilou tonu san rei arihon kota Yerusalem man. ");
INSERT INTO nxl_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Reiso, sio Yahudiu panesi on roe rei ohoka nanie ouna kuru Maria na Marta anoo tau no hota panokoi nea. ");
INSERT INTO nxl_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Taa Marta iatinu ata Yesus waimo haineke nea, oyo ieu inapai na isupui. Ne Maria mo, iru-ruei pan numa anoe man. ");
INSERT INTO nxl_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta iasau osi Yesus ata, “Upu, sinana tutua, hotaku panokoi tewa. ");
INSERT INTO nxl_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ne au iae uanei ata sae wan ainisiki arihon Anahatana mo, mka iruiki osia rei sirinia.” ");
INSERT INTO nxl_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesus iahata, “Marta. Hotam mo, mka iamahaiki honu.” ");
INSERT INTO nxl_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta iahata, “Ama, au iae uanei ata hotaku Lasarus mka iamahaiki honu tau Anahatana iuna sio matana oamahaiso honu tau tuniai reini repena.” ");
INSERT INTO nxl_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesus iahata, “Au sahoro una mansia oamahaiso honu na Au sahoro unaso oamahaiso okata Anahatana rotu-tu ria supan. Sio wason oparisaa tau Au, masike omataso nea iae, mka oamahaiso honu. ");
INSERT INTO nxl_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Na sio pusiso wason oamahaiso asi na oparisaa tau Au, sio mo, mka omataso rotu-tu ria supan tewa. Ano parisaa tau sae wani uasaui osia reini te tewa?” ");
INSERT INTO nxl_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Iahata, “E-e Upu. Uparisaa tanua, Upu. Uparisaa ata Ano mo, Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau. Ano mo, Anahatana Anai wain itotoe runai na ihokai mai tuniai reini.” ");
INSERT INTO nxl_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Oyo Marta inuniki poe ne numa nanie ioi Maria. Ne sio panesi wasupo numa anoe reiso iarahuhu osiki. Iahata, “Maria. Ia Ona Matuhetene wain ihokai nea. Wain iasei nnaya.” ");
INSERT INTO nxl_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria iatinu san rei, oyo ihitio ieui sisaa na isupu Yesus. ");
INSERT INTO nxl_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tau rei mo, Yesus inusu niane tewasi. Waimo naniai sinasi wan Marta isupui rei asi. ");
INSERT INTO nxl_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tau reimo sio Yahudiu wasumo Maria ne numa anoe ouna kuru anoi. Onoo Maria ihitio ieu ihokai sisaa reiso oeu pusui. Sio rei oeu pusui tau oata kani Maria nanie ieui irani ria Lasarus ne kupuro. ");
INSERT INTO nxl_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Taa Maria ihoka inoo Yesus, oyo irike tune mai Yesus uai anoe. Oyo iahata, “Upu. Sinana tutua mo, hotaku panokoi tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesus inoo Maria na sio Yahudiu rei oran oapunokoso, iahana anoi wakihi pusiki nai osa. ");
INSERT INTO nxl_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Oyo iasei, “Oeu oatasiniki sui supa?” Oasau ata, “Upu, mai na ruam aeu ria anoo mana.” ");
INSERT INTO nxl_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Matai waena. ");
INSERT INTO nxl_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Oyo sio Yahudiu umau wason noi rei oasau ata, “Masi onoo. Anoi runa Lasarus nai osa.” ");
INSERT INTO nxl_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ne sio umau honu oasau ata, “Ia onate reini sahoro ia wain isuisene ia mata putie rei, tea! Reiso nanie itapi Lasarus panokoi tau sae?” ");
INSERT INTO nxl_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesus anoi wakihi pusiki nai osa na Lasarus ne hotau uaso honu oyo ieui ria hatu nohue wan oatasini Lasarus rei. Hatu nohue rei mo, onete nene mitanunue tau hatu onate isa. ");
INSERT INTO nxl_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Hoka ria, oyo iasau ata, “Nea hatu rei.” Ne Lasarus hotai wain nanai Marta iahata, “Upu, hotaku Lasarus mo, panokoi onona ate nea. Reiso mka haui nea.” ");
INSERT INTO nxl_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesus iahata, “Anom repeka runa sae wan uasaui osia rei tewa? Munata aparisaa tanuku mo, mka anoo Anahatana ne kawasa rei.” ");
INSERT INTO nxl_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Onea hatu wan renete hatu nohue nene mitanunue rei. Oyo Yesus inoo na roe nante iahata, “Ama! Uainisi iake arihonia tau atinu tau we mainisie. ");
INSERT INTO nxl_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Uanei ata Ano mo, atinuku sui osa. Ne, uasau san reini na sio wason ooso mai rei oparisaa ata Ano ruam sahoro aisosiku mai tuniai reini.” ");
INSERT INTO nxl_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iainisi pusi oyo, iakapona nioi mainae ata, “Lasarus! Ahokaya!” ");
INSERT INTO nxl_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Sira tau Lasarus wain imatai nea rei ihokai rei sirinia. Hanai ain rakanihoo tau nipae wan opai tanui rei asi. Nipae iae rehehe unui asi oi. Oyo Yesus iaisosiso ata, “Nosu nipaya waron rakanihoo ne patane rei na ieu iake.” ");
INSERT INTO nxl_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Sio Yahudiu panesi wason ohokaso poe Maria onoo Yesus iuna Lasarus iamahaiki honu, reiso oparisaa tanui. ");
INSERT INTO nxl_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ne, sio umau oeu osima runa sae wan Yesus iunai rei osi sio onata arihon akama Yahudi. ");
INSERT INTO nxl_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Reiso, sio imam no sio mainaya na sio onata arihon akama Yahudi oamanou sio siniriu oyo oasau ata, “Nanie iuna sae? Wain iuna sima-simana panesi. ");
INSERT INTO nxl_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Sani itapiki iuna san rei sui osa mo, mka sio pusiso oparisaa tanui. Oyo sio tantara Romau mka ohoka okohu ita re numa mainisie na ita Yahudiu pusita.” ");
INSERT INTO nxl_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ia isa arihon sio wason oamanouso roe rei wain nanai Kayapas. Ia mo, iuna sio imam no ia mainae tau musum rei. Iasau osiso ata, “Oarirunemo nai osa! ");
INSERT INTO nxl_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Oanei tewa ata nene iake mo, sana osa imatai ikati mansia pusiki. Pene tu-tu ita Yahudiu imata pusita noso ia osa.” ");
INSERT INTO nxl_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayapas iasau ata ia osa kahurae imatai ikati sio panesi arihon ia ruai anoi tewa. Iasau san rei tau ia mo, sio imam no ia mainae tau musum rei. Ne, ianei tewa ata waimo isima runa Anahatana ne anamanae ata Yesus mo, mka imatai ikati sio Yahudiu. ");
INSERT INTO nxl_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yesus panokoi ikati sio Yahudiu man tewa. Ne, panokoi ikati Anahatana ne mansiau wason owena-wenaso mai tuniai rein. Na iamanou pusiso tau osa. ");
INSERT INTO nxl_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Reiso tau rei, sio siniriu oapamata sou nanie ohunu Yesus. ");
INSERT INTO nxl_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Reiso Yesus ieu ria nau sui sio Yahudiu tewa nea. Ieu iau-iauhuniki man. Ieu arihon kota Yerusalem ikata ami ne mampusua na pan niane isa wan nanae Epraim. Niane rei wapan haineke otoe huie isa, oyo aruema pan rei. ");
INSERT INTO nxl_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Haineke ami Yahudiu ma karisaa anori rapeka na Anahatana ihoka ma upu momou arihon otoe Mesir nea. Sio panesi arihon niana-niana ohokaso naone roe Yerusalem. Ohokaso naone na oseka tau ruao arihon no rosa repusu ami Yahudiu ma monne, na reeu mai karisaa mainae reimo, opusui iake nea. ");
INSERT INTO nxl_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Sio imam no sio mainaya na sio onata arihon akama Yahudi nanie osota Yesus. Reiso orui anamanae san rei, “Munata ia seia mani ianei Yesus wain sui supan mo, sima osima sansana.” Reiso sio wason ooso roe Anahatana ne numa mainisie nusue onina-nina Yesus. Oasau osi umau ata, “Pusu ano mo, sapan? Mka Yesus ieui mai karisaa reini te tewa?” ");
INSERT INTO nxl_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nesie onona nome samatoro ami Yahudiu ma karisaa anoma rapeka na Anahatana ihoka ma upu momou arihon otoe Mesir. Yesus inuniki poe nia Betania honu. Betania mo, Lasarus wain Yesus iunai iamahaiki honu ne niane. ");
INSERT INTO nxl_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Sio poe niane rei ouna nasa mainae tau nanie oamuira Yesus. Marta sahoro ireha muaina rai, oo Lasarus ikata sio wason orue oaiso okata Yesus. ");
INSERT INTO nxl_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Oyo Maria inana mina tunne. Mina rei mo, mina hau rihue wan nanae mur. Irori liter sama tihue. Mina reimo, hunonie mainae. Maria isona Yesus ain atua tanui oyo ikusa ain atua tau ne huau. Numa anoe rei mo, haue rihue nai osa tau mina rei. ");
INSERT INTO nxl_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yesus ne mampusue isa wain nanai Yudas. Ia on pan nia Kariot. Ia sahoro mka iahen Yesus. Iasau ata, “Pene! ");
INSERT INTO nxl_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Mina reimo, hunonie sani ia isa isupu kati tau musum osa. Nene iake mo, iaheniki na nene kepen, aruire osi sio mosokinia.” ");
INSERT INTO nxl_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yudas iasau san reimo, tau anoi runa sio mosokinia mo, tewa. Ne areimo, tau ia mo, ia tai onate wain saka ikimanaka kepen arihon kepen waron irime osi Yesus sio. ");
INSERT INTO nxl_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Reiso Yesus iasau osiso ata, “Ia ruai! Pene oakapuku tau ia pina rei. Iaheniki tewa na mka umataku, oyo oaunutuku, ia pina rei nanie isonaku tau mina na iseka tau we patane oni panokoku tewasi. ");
INSERT INTO nxl_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Sio mosokinia mo, okatamo sui osa. Reiso sui supan man omi oakahaiso pusu ruamo mo maue. Ne Au mo, urue ukatamo sui osa tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Sio Yahudiu panesi oatinu ata Yesus waipo nia Betania. Reiso oeuso poe rei nanie onooi. Na nanie onoo Lasarus oi. Lasarus mo, ia wain Yesus iunai iamahaiki honu rei. ");
INSERT INTO nxl_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Reiso sio imam no sio mainaya oapamata sou nanie ohunu Yesus na Lasarus oi. ");
INSERT INTO nxl_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Tea mo, sio Yahudiu panesi oatinu rerihon Lasarus oyo oparisaa tau Yesus. Opusu sio imam no sio mainaya tewa nea. ");
INSERT INTO nxl_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nene han roe san rei, sio panesi wason ohokaso roe kota Yerusalem tau ami Yahudiu ma karisaa. Oatinu ata Yesus waipo arena tihue nea nanie ieu roe kota rei. ");
INSERT INTO nxl_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Reiso, oeu onana ai sanaya oyo oeu hokaso arihon kota nanie onapa Yesus. Oakapona ata, “Ainaa na Anahatana! Arui iake osi Ia wain ihokai tau ma Upu Anahatana nanai. Arui iake osi ami Israel ma Aia reini.” ");
INSERT INTO nxl_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesus isupu keledai anae isa, oyo isaai. Iuna san reimo, noo sani sae waron Sakaria ikanu tau Anahatana ne anamanaya ata, ");
INSERT INTO nxl_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Omi Yerusalem, pene okaitau! Masi onoo! Omi mo Ia Aia wain ihokai nea. Isaa keledai anae isa.” ");
INSERT INTO nxl_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Mataanoe, ami ne mampusua, anei tewa ata ikanu rerihoni sia. Ne, tau Yesus panokoi, oyo Anahatana iapusaai na roe noiyaha samatoro anei ata sae wan ikanui reimo, rerihon Yesus na sae waron ounare osiki. ");
INSERT INTO nxl_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Sio wason onoo Yesus ioi Lasarus on pani hatu nohue oyo iunai iamahaiki honu rei, oeu oruni rerihoni Lasarus. ");
INSERT INTO nxl_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Reiso, sio panesi oatinu rerihoni Yesus nea ata Ia sahoro iuna sima-simane wan retuhete ata ne kawasa arihon Anahatana. Reiso ohoka arihon kota Yerusalem na nanie osupu Yesus. ");
INSERT INTO nxl_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Onoo san rei, sio onata arihon akama Yahudi oasau mai umau ata, “Masi onoo! Ita nanie inete na pene sio panesi opusui ne mansia panesi ohoka upusui nea rei.” ");
INSERT INTO nxl_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Karisaa ami Yahudiu anoma rapeka na Anahatana ihoka ma upu momou arihon otoe Mesir mo, mansia panesi oeuso roe kota Yerusalem na oainisi oainaa na Anahatana. Mansia panesi rei mo, sio umau mo, sio Yahudiu tewa. ");
INSERT INTO nxl_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ohokaso mai Pilipus. Ia mo, ne niane Betsaida pan otoe Galilea. Oyo oasau osiki ata, “Upu, ami nanie anamana na Yesus.” ");
INSERT INTO nxl_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pusi, oyo Pilipus ieu iasau osi Anreas oyo uaso oeu oasau osi Yesus. ");
INSERT INTO nxl_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Oyo Yesus iahata, “Nene orase nea tau Au, Tumata Reini mo, Anahatana Ihitiku umataku oyo Anahatana iamuiraku na iapusaaku na roe noiyaha. ");
INSERT INTO nxl_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Oatinu mai ia-ia nanie uasau osimo. Nooku sani gandum kanie. Sani orahu gandum kanie poe tuamane mo, mka rematai ee, samatoro reruhui honu oyo reuhua panesi. Ne sani remata tewa, mka gandum rei hasae kanie osa rei man. Resinena tewa. ");
INSERT INTO nxl_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Omi iae san rei oi. Ia seia wain ipusu ruai ne maue mai tuniai reini, ia mo, mka iamahaiki rotu-tu ria supan tewa. Ne ia seia wain iamanaku na imatai noso ipusu Au mo, mka pan muie rei iamahaiki ikata Anahatana rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ia seia man wain ianori na Au mo, kahurae ipusuku sui supan. Sui supan mana Au noi rei, ia iae waimo rei oi. Ia seia man ianori na Au, mka Amaku iamuirai. ");
INSERT INTO nxl_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Anoku wan mtinte nai osa. Nanie uainisi, ne kani uainisi sapan? Uasau ata, ‘Ama, nea siraka wan reunaku sinsaraku rei arihoniku si?’ Ne uainisi san rei mo, iake tewa. Tea mo, uhokaku mai tuniai reini mo, na sinsaraku. ");
INSERT INTO nxl_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Reiso hasae uainisi ata, ‘Ama, atuhete osi mansiau ata Ano mo, Ano mainae nai osa.’” Sira tau oatinu nioke isa on roe nante. Iasau ata, “Au uatuhete osi mansiau nea ata Au mo, Au mainae nai osa. Na Au mo, mka una mansia onoo we kawasa mainae honu.” ");
INSERT INTO nxl_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Sio panesi wason noi rei iae oatinu nioke rei oi. Reiso oasau ata, “Areimo tinaa tinunue.” Sio umau honu oasau ata, “Tewa, areimo, Anahatana ne maisosie on roe noiyaha wain ianamana runai.” ");
INSERT INTO nxl_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesus iahata, “Nioke wan sinasi oatinui rei mo, Anahatana nioi na iakahai omi. Nioi na iakahai Au tewa. ");
INSERT INTO nxl_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Areini mo, orase tau Anahatana iapasana sio mai tuniai reini. Orase reini oi iae Anahatana nanie inei ia aia sakahatene wain ne kawasa tau tuniai reini. ");
INSERT INTO nxl_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ne Au mo, mka osiuku roe hini on mai tuamane reini. Tau rei, mka uhuka arena osi ia sia man na oeuso mai tanuku.” ");
INSERT INTO nxl_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesus iasau san reimo, nanie isima na mka panokoi sapan. ");
INSERT INTO nxl_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Oyo ia isa arihon sio panesi rei iahata, “Upu, ami anei nea oi arihon Anahatana ne maunauna ata Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau mo, mka iamahaiki rotu-tu ria supan. Reiso, Ano nanie asau ata, Ia Tumata wain Anahatana Ihitiki mo, mka osiui roe hini tau sae? Reiso Ia Tumata wain Anahatana Ihitiki mo, ia seia?” ");
INSERT INTO nxl_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Oyo Yesus iahata, “Au sani Manahane. Mka ukatamo potuina tewa nea. Manahane rei wain ikatamo. Reiso, oni Manahane reini wain asi, oamahaimo pan Manahane rei. Pene tu-tu pumono renetemo. Areimo, tau ia seia wain ieu tau pumono mo, ianei mosa arena tewa. ");
INSERT INTO nxl_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Reiso oni Au wain ukatamo asi mo, oparisaa tau Manahane rei. Oparisaa na mo hali manahane.” Yesus iasau san rei pusi, oyo ieui arihon rei na iauhuniki arihonso. ");
INSERT INTO nxl_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Masike Yesus iuna sima-simana waron ratuhete ata ne kawasa arihon Anahatana panesi mai sio Yahudiu uao anoa iae, openeso oparisaa tanui sirinia. ");
INSERT INTO nxl_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Areimo reeu sani Anahatana ne ia mamsima runa ne maunauna wain nanai Yesaya iasau ata, “Upu, ami asima runaya, ne sio panesi oparisaa tewa. Masike Ano atuhete me kawasa, openeso oparisaa.” ");
INSERT INTO nxl_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Reiso oparisaa tewa. Tea mo, Yesaya iae iasau nea rerihon sio ata, ");
INSERT INTO nxl_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Anahatana iuna matao raputiso, reiso onoo mosa tewa. Ihuka anoo tewa, reiso oanei tewa. Reiso onuni oninai tewa. Sinana oninai, Anahatana itotoe nea, ‘Mka uapuheuso.’” ");
INSERT INTO nxl_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Naone Yesaya iasau san rei mo, areimo noo sani inoo Yesus ne kawasa mainae nea. Reiso isima nnai rei tea. ");
INSERT INTO nxl_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ne masike sio Yahudiu no sio mainaya panesi oparisaa tau Yesus tewa, sio umau oparisaa. Ne openeso osima. Tea mo, okaitau ata sio onata arihon akama Yahudi osoposo na pene oheta ami Yahudiu ma numa mananoune nea. ");
INSERT INTO nxl_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Onina na mansiau oamuiraso renesi onina na Anahatana iamuiraso. ");
INSERT INTO nxl_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesus iakapona nioi mainae osi sio panesi ata, “Ia seia wain iparisaa tau Au mo, iparisaa tau Au ruaku man tewa. Ne iparisaa tau Ia waini iaisosiku uhokaku mai tuniai rein oi. ");
INSERT INTO nxl_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Inoo Au, areimo inoo Ia wain iaisosiku rei oi. ");
INSERT INTO nxl_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Au wan uhokaku mai tuniai rein na uatuhete Anahatana ne arena osimo. Au sani manahane wan retuhete arena na onoo mosa. Uhokaku na ia seia wain iparisaa tau Au, mka irue iapumonoi tewa nea. ");
INSERT INTO nxl_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ne ia wain iatinu we maunauna ne ipusure tewa, Au mo, uapasanai tewa. Areimo tau uhokaku mai tuniai reini mo, na uapasana mansia mo, tewa. Ne uhokaku reini mo, na uapuheu mansiau na pene Anahatana iapasanaso. ");
INSERT INTO nxl_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ia seia wain ipenei tanuku na iatarima we maunauna tewa mo, Anahatana mka iapasanai. Sani tuniai nanie repena nea, mka iapasanaso pusu openeso tau Au we maunauna. ");
INSERT INTO nxl_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Areimo tau Au mo, uanamana pusu ruaku we maue tewa. Ne uanamana pusu Amaku ne maue. Ia sahoro iaisosiku. Ia sahoro iasau runa sae wan kahurae uasaui osimo. ");
INSERT INTO nxl_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Au uanei ata sae wani iaisosiku uasau runai osimo reimo, reuna mansiau oamahaiso okatai rotu-tu ria supan. Reiso Au mo, uasau runa sae man waron Amaku iaisosiku uasaure.” ");
INSERT INTO nxl_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nene hanroe nanie karisaa anoma rapeka na Anahatana ihoka ma upu momou arihon otoe Mesir. Yesus ianei nea ata nene orase nea tau ieui iarihon tuniai rein na inuniki roe Amai. Anoi runa ami, ne mampusua, wan akatai mai tuniai rein na nanie iatuhetema ata anoi runama rotu-tu imatai iarihonima. ");
INSERT INTO nxl_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ia aia sakahatene iakarema Yudas anoi nea. Yudas mo, Simon on pan nia Kariot anai rei. Reiso ia aia sakahatene iakarotai nanie iahen Yesus osi ne nisau. Ami mampusua wan aima akata Yesus. ");
INSERT INTO nxl_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesus ianei nea ata Amai irui kawasa osiki tau sae man. Ianei nea oi ata ihokai on roe Anahatana na mka inuniki roe Anahatana honu. ");
INSERT INTO nxl_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Reiso, wan arue aima, Yesus ihitio roe, oyo inosu ne papi naue. Oyo inana nipa sinte isa samatoro ikanihooi mai ahai. ");
INSERT INTO nxl_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Oyo iaiinu tihu tau parten isa samatoro isohu ami, ne mampusua, aima atua. Isohure pusi, oyo ikusa aima rai tau nipa sinte wan ikanihooi mai ahai rei. ");
INSERT INTO nxl_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ihoka pakarema Petrus wain sio oiki tau Simon oi. Iasau ata, “Upu, iake tewa tau Ano asohu aiku atua.” ");
INSERT INTO nxl_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesus iasau ata, “Petrus, sae wan Au unai reini mo, ano aneiki tewasi. Ne mka pani muie samatoro mka aneiki.” ");
INSERT INTO nxl_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ne Petrus iahata, “Pene, Upu! Masike rotu-tu umataku iae, upeneku utapia asohu au aiku.” Ne Yesus iahata, “Sani usohu aim atua tewa, areimo ano mo, auna Au we mampusue tewa nea.” ");
INSERT INTO nxl_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Oyo Petrus iasau osiki honu ata, “Upu, munata san rei mo, pene hasae aiku atua man ne hanaku na unuku oi.” ");
INSERT INTO nxl_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesus iahata, “Ia wain isohui nea mo, hasae isohu ain atua man. Areimo, tau ne patane mo, kitataie tewa nea. Om reini anomo kaia nea. Tea mo, Anahatana isiru heu mo rosau nea. Ne ia isa mo, tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesus iasau san rei tau ianei nea ata ia seia nanie iaheniki. Reiso, iasau ata pusiso anoo kaia tewa. ");
INSERT INTO nxl_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesus isohu ami, ne mampusua, aima atua pusi, oyo iausahu ne papi naue rei honu. Oyo iuni iru-ruei roe naniai honu. Oyo iasei tau pusima ata, “Pusimo oanei sae wan Au unai osimo sinasi rei te tewa? ");
INSERT INTO nxl_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Omi saka oiku tau Matuhetene na Upu. Areimo titue. Tau Au mo, omi mo Upu na mo Matuhetene rei tea. ");
INSERT INTO nxl_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Reiso masike Au mo, omi mo Matuhetene na mo Upu rei mo, urati ruaku usohu aimo atua sani Au maniane, omi iae kahurae osohu aimo atua ia isa na ia isa. ");
INSERT INTO nxl_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Areimo tau Au wan uatuhetei osimo nea. Reiso omi iae kahurae ouna sani sae wan Au unai osimo rei. ");
INSERT INTO nxl_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Oatinu mai ia-ia, nanie uasau osimo. Ia maniane mo, ia mainae inesi ne upu tewa. Ia maisosie mo, ia mainae inesi ia wain iaisosiki rei tewa. ");
INSERT INTO nxl_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Oanei pusi sae wan uasaure osimo nea rei. Reiso sani opusui mo, mka osupu iake.” ");
INSERT INTO nxl_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Yesus iasau osi ne mampusua ata, “Uasau ata osupu iake, ne uanamana rerihon omi pusimo tewa. Uromamo, uanei mo hali nea. Ne uroma ia isa wain mka iaheniku na iuna sui sae wan sio okanui tau Anahatana ne anamanaya. Okanu san rei, ‘We neta wain saka uama iai ikataku, iuna we nisa.’ ");
INSERT INTO nxl_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Usima osimo nea reini rerihoni ia isa wain iaheniku, na sani iaheniku nea, omi oparisaa ata Au reini mo, Aia wain Anahatana Ihitiku na Uapuheu Mansia. ");
INSERT INTO nxl_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Oatinu mai ia-ia, nanie uasau osimo. Ia seia iatarima ia wain uaisosiki, areimo iatarima Au nea oi. Ia seia wain iatarima Au, arei iae noo san iatarima Ia wain iaisosi Au.” ");
INSERT INTO nxl_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesus ianamana san rei pusi, oyo anoi mtinte nai osa. Iahata, “Atinu mai ia-ia, nanie uasau osimo. Ia isa arihon om reini mka iaheniku osi we nisau.” ");
INSERT INTO nxl_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ne mampusua, ami, anoo mai umau. Asira. Anei tewa Yesus ianamana rerihoni ia sia. ");
INSERT INTO nxl_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Au, ne mampusue wain sio oiku tau “ia wain Yesus anoi runai” urue haineke Yesus. ");
INSERT INTO nxl_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Oyo Simon Petrus irui kakinate osiku na iahata, “Asei tau Yesus. Ia sia sahoro mka iaheniki.” ");
INSERT INTO nxl_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Reiso ueu hai-hainekei na uasei ata, “Upu, ia seia sahoro mka iahenia?” ");
INSERT INTO nxl_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesus iahata, “Mka unono poroti reini poe sanaute, oyo uruiki osi ia rei.” Iasau san rei pusi, oyo inana poroti, inonoi poe sanaute, oyo iruiki osi Yudas. Yudas mo, Simon on pan nia Kariot anai. ");
INSERT INTO nxl_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Taa Yudas inana poroti rei, ia aia sakahatene iamasuniki. Oyo Yesus iasau osiki ata, “Sae wan nanie aunai mo, unai rapu nea.” ");
INSERT INTO nxl_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ne ami pusima wan arue ai akata umau rei, ia seia man ianei tewa ata nanie iasau osi Yudas san rei tau sae. ");
INSERT INTO nxl_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ne Yudas mo, ia wain irime ma kepen. Reiso sio umau oanei mo, Yesus waimo iaisosiki ieu ihane sae umau tau ma karisaa rei. Te nanie tau ieu irui sae isa osi sio mosokinia. ");
INSERT INTO nxl_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Taa Yudas inana poroti rei pusi, oyo ihitio ieu rei sirinia. Tau reimo, wapan pumono nea. ");
INSERT INTO nxl_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudas ihitio ihoka ieui, oyo Yesus iasau osi ami, ne mampusua, ata, “Nene orase tau sio oamuira Au, Tumata Reini mo, Anahatana Ihitiku nea. Mka oamuira Anahatana noso Au oi. ");
INSERT INTO nxl_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Sani oamuira Anahatana noso Au, Anahatana iae iunaso oamuira Au oi. Potuina tewa oi, oyo iunai nea. ");
INSERT INTO nxl_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","We hehuka, potuina tewa nea mka ukatamo tewa nea. Omi mka oninaku. Ne okataku roe rei iake tewa. Areimo, uasau runai osi sio onata arihon akama Yahudi naone nea. Oyo wan uasaui osi omi muie reini honu reini. ");
INSERT INTO nxl_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Reiso nanie uasau runa maunau honue osimo. Anomo na umau. Omi mo, kahurae anomo na umau noo sani Au anoku na omi. ");
INSERT INTO nxl_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Sani anomo na umau san rei, mka mansiau pusiso onoo ata omi mo, Au we mampusua.” ");
INSERT INTO nxl_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Oyo Simon Petrus iasei tanui ata, “Upu. Nanie aeua sui supa?” Yesus iasau ata, “Nanie ueuku roe naniaku wan ano mka aeu roe rei tewasi. Ne mka tau muie aeu roe naniake rei.” ");
INSERT INTO nxl_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petrus iasei honu ata, “Upu, upusua tewasi tau sae? Au mka umataku noso Ano.” ");
INSERT INTO nxl_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesus iasau osiki ata, “Ano nanie amataya noso Au si? Atinu mai ia-ia, nanie uasau osia. Oni on punanoe, manua ratunkeko tewasi oimo, ano auhaa ata ationaku. Auhaa nai tonu nea!” ");
INSERT INTO nxl_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesus iasau osi ne mampusua ata, “Pene anomo rauponu. Parisaa tau Anahatana sui osa na parisaa tau Au sui osa oi. ");
INSERT INTO nxl_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Roe Au Amaku ne numa mo, kakaranaya panesi. Sani munata titue tewa, uasau osimo. Nanie uanaone roe rei na useka tau naniaka osimo matane. ");
INSERT INTO nxl_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Uanaone roe rei na sani naniamo waruro nea, mka ununiku mai na unanamo na okataku roe rei. Unanamo na sui supan man Au noi rei, omi iae okataku noi rei oi. ");
INSERT INTO nxl_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Oanei arena wan reeu roe naniaku wani Au nanie ueuku roe tanui rei.” ");
INSERT INTO nxl_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas iasau osiki ata, “Upu, ami anei tewa ata nanie aeua sui supa. Reiso sapan na ami anei arena rei?” ");
INSERT INTO nxl_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesus iahata, “Au sahoro arena na oeu roe Amaku. Au sahoro uatuhete sae wan manisate rerihoni Anahatana. Au oi, sahoro una mansia oamahaiso okata Anahatana rotu-tu ria supan. Hasae Au sahoro una arena na oeu roe Amaku. ");
INSERT INTO nxl_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Munata omi oationaku ia-ia nea, areimo oationa Amaku nea oi. On rahata reipan, omi mo, oationai na onooi nea oi.” ");
INSERT INTO nxl_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Oyo Pilipus iahata, “Upu. Atuhete Amam osima mai. Na anoma kaia.” ");
INSERT INTO nxl_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ne Yesus iahata, “Pilipus ee. Ukatamo potuina rein nea rei! Ano mo, kahurae ationaku nea. Ia seia wain inoo Au nea, areimo inoo Amaku nea oi. Reiso ano nanie asau na uatuhete Amaku osimo tau sae? ");
INSERT INTO nxl_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Aparisaa tewa ata anoku osa na Amaku na Amaku anoi osa na Au? Maunauna waron uaunaure osimo rei mo, arihon Au ruaku tewa. Maunauna rai mo, arihon Amaku wain osa nnaku rei. Ia sahoro iunaku uaunaumo san rei runa una sima-simana waron iaisosiku na unare rei. ");
INSERT INTO nxl_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Omi mo, kahurae oparisaa ata Au na Amaku mo, anoma osa. Munata oparisaa tau sae wan uasaui reini tewa, hete sae oparisaa tau sima-simana waron unare nea rei. ");
INSERT INTO nxl_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Oatinu mai ia-ia, nanie uasau osimo. Ia seia man wain iparisaa tau Au mo, mka iuna sima-simana sani waron Au unare rei. Mka iuna sima-simana ranesi waron Au unare. Areimo tau nanie ueuku roe Amaku nea. ");
INSERT INTO nxl_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Sae man waron oainisire arihon Amaku tau Au nanaku, mka unare. Una san rei na mansiau oamuira Amaku noso sae wan Au, Anai, unai rei. ");
INSERT INTO nxl_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Sae man waron oainisi arihon Amaku tau Au nanaku, mka unare.” ");
INSERT INTO nxl_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesus iasau osi ne mampusua ata, “Sani anomo nnaku, omi mka opusu we maunauna. ");
INSERT INTO nxl_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Oyo mka uainisi na Amaku iauwatu Ia isa na iakahaimo ikati Au. Mka iruei ikatamo rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ia rei mo, Anahatana Ne Inaha. Ia mo, mka iatuhetemo rerihon Anahatana ne maunauna waron manisata. Ne sio mai tuniai reini wason oparisaa tau Anahatana tewa, openeso oatarimai. Tea mo, sio mo, oationai tewa. Onooi tewa. Ne omi mo, oationai. Areimo, tau Anahatana Ne Inaha rei ikata runamo na mka iruei pan anomo. ");
INSERT INTO nxl_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Au mo, mka ueu arihonimo sani sio iki sioiu tewa. Au mo, mka ununiku mai tanumo honu. ");
INSERT INTO nxl_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Wan haineke nea oyo sio mai tuniai reini wason Anahatana ne mansiau tewa, mka onooku tewa nea. Ne omi mo, mka onooku sinia. Tau Au mka uamahaiku honu, reiso omi iae mka oamahaimo honu oi. ");
INSERT INTO nxl_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Sani uamahaiku honu, samatoro omi oanei ata anoku osa na Amaku na Amaku anoi osa na Au. Omi iae oanei ata anomo osa na Au na Au anoku osa na omi. ");
INSERT INTO nxl_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ia seia ianei we maunauna na ipusure, ia rei sahoro anoi runaku. Ia wain anoi runa Au mo, mka Amaku anoi runai oi. Au iae mka anoku runai oi na uatuhete osiso ata Au mo, Au seia.” ");
INSERT INTO nxl_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Oyo Yesus ne mampusue isa wain nanai Yudas oi. Ne ia mo, Yudas on pan nia Kariot tewa. Iasau osi Yesus ata, “Upu, Ano hasae atuhete ata Ano mo, Ano seia osi ami man. Ne osi sio mai tuniai reini mo, tewa tau sae?” ");
INSERT INTO nxl_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesus iahata, “Ia seia wain anoi runaku mo, mka ipusu we maunauna. Amaku iae, mka anoi runai oi. Mka Au runa Amaku ahoka na akata runai. ");
INSERT INTO nxl_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ia seia wain anoi runaku tewa mo, mka ipusu we maunauna tewa. We maunauna rai waron oatinure nea mo, Au ruaku we maunauna mo, tewa. Ne maunauna rai mo, arihon Amaku wain iaisosiku. ");
INSERT INTO nxl_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Uasau rai pusire osimo oni wan ukatamo asi reini. ");
INSERT INTO nxl_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ne sani ununiku roe Amaku nea, mka Amaku irui ne Inaha, Ia sahoro iakahaimo. Mka ihokai runa Au we kawasa na iatuhetemo rerihon sae man. Na Ia iae mka iuna anomo rapeka runa maunauna waron uaunaure osimo nea rei. ");
INSERT INTO nxl_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nanie ueu arihonimo, ne mka una anomo kaia. Una anomo kaia noo sani sio mai tuniai rein tewa. Reiso pene anomo rauponu. Pene okaitau. ");
INSERT INTO nxl_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Uasau osimo nea ata, ‘Nanie ueu arihonimo. Ne mka ununiku mai tanumo honu.’ Sani munata anomo nnaku, areimo mka anomo mirika tau Au nanie ununiku roe Amaku. Ia mo, Ia mainae inesi Au. ");
INSERT INTO nxl_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Uasau osimo oni ueu tewasi ata mka ueu uarihonimo, na sani ueuku nea, oparisaa tau Au. ");
INSERT INTO nxl_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Au mka uanamana osimo potuina tewa nea. Tea mo, ia aia sakahatene wain ne kawasa tau tuniai reini wain nanie ihokai nea. Nanie ihokai imunaku. Ne ia mo, ne kawasa tau Au tewa. ");
INSERT INTO nxl_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ne sio mai tuniai rein mo, kahurae oanei ata Au mo, anoku runa Amaku, na Au una sae wan iaisosiku na unai. Mai, na ieuta arihon reini.” ");
INSERT INTO nxl_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesus iruni runa matieue isa osi ne mampusua ata, “Au mo, noo sani ai anggur wan manisate. Omi mo, ai anggur nene sanaya. Amaku mo, nooi sani ia mamsaka nisi anggur. ");
INSERT INTO nxl_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Sani ia mamsaka nisi iretu sanaya waron rauhua tewa mo, Amaku iae inea sio wason oasau ata anoo osa na Au ne oauhua tewa. Oauhua tewa, areimo no hali pannuhu na Anahatana anoi tewa. Sanaya waron rauhua, mka iseka tau nene totua na rahoka huaya panesi honu. ");
INSERT INTO nxl_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Omi mo, noo sani sanaya waron iseka tanre nea na nanie ohoka huaya nea. Tea mo, oparisaa tau maunauna waron uaunaumo tanure rei nea. ");
INSERT INTO nxl_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Omi mo, kahurae anomo osa na Au sui osa. Sani anomo osa na Au, mka Au iae anoku osa runa omi oi. Ai sanae wani oretui arihon nene tinaie nea mo, mka reuhua tewa nea. Omi iae san rei oi. Sani oamahaimo anomo osa runa Au tewa mo, mka oauhua tewa. Areimo, mo hali pannuhu na Anahatana anoi tewa. Reiso kahurae anomo osa na Au na oauhua. ");
INSERT INTO nxl_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Au reini mo, sani anggur nene tinaie. Omi mo, sani anggur nene sanaya. Ia seia wain anoi osa runa Au na Au anoku osa runa ia, mka iauhua. Areimo ne hali pannuhu na Anahatana anoi. Ne sani anomo osa na Au tewa, mka mo hali pannuhu na anoi tewa. ");
INSERT INTO nxl_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ia seia man wain iamahaiki anoi osa runa Au sui osa tewa, mka Anahatana ipesiki sani ia mamsaka nisi iretu anggur sanaya na nanie ipesire rei. Sani sanaya rai rakaimenso nea, iamanoure oyo ipesire pan usa na iakanupure. ");
INSERT INTO nxl_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ne sani oamahaimo anomo osa runa Au sui osa na orime kuru we maunauna sui osa mo, oainisi sae man wan oninai arihon Amaku, mka irui sae wan oainisiki rei osimo. ");
INSERT INTO nxl_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Sani mo hali pannuhu na Anahatana anoi, areimo oatuhete ata omi mo, titue-tue Au we mampusua. Areimo oamuira Amaku. ");
INSERT INTO nxl_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Anoku runamo nooi sani Amaku anoi runa Au. Reiso, omi mo, kahurae anomo osa runa Au sui osa na oanei ata Au mo, anoku runamo. ");
INSERT INTO nxl_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Sani opusu we maunauna, mka oanei ata anoku runamo. Au iae upusu Amaku ne maunauna na uanei ata anoi runaku. ");
INSERT INTO nxl_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Usima na pusire osimo reini na anomo mirika sani Au oi. Na anomo mirika ia-ia. ");
INSERT INTO nxl_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Areini mo, Au we maunaune osimo. Anomo runa umau, nooi sani Au anoku runa omi. ");
INSERT INTO nxl_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ia wain anoi runa ne netau nai osa, areimo ia wain nanie irui ruai na imatai ikatiso runa iapuheuso. ");
INSERT INTO nxl_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Sani opusu we maunauna, omi mo, Au we netau. ");
INSERT INTO nxl_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Uoimo tau manianeu tewa nea. Tea mo, ia maniane mo, ianei sae wan upui iunai tewa. Ne uoimo tau we netau. Tea mo, usima osimo nea rerihon sae man wan uatinure arihon Amaku. ");
INSERT INTO nxl_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Omi oroma Au tewa na ouna we mampusua. Ne Au ruaku sahoro uroma omi na una we mampusua. Uromamo na mo haliu pannuhu na Anahatana anoi sui osa. Mo haliu pannuhu na anoi, mka Amaku irui sae man wan oainisiki tau Au nanaku. ");
INSERT INTO nxl_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Reiso we maunaune osimo wan san rei. Kahurae anomo runa umau.” ");
INSERT INTO nxl_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesus iasau osi ne mampusua ata, “Sani sio mai tuniai openeso tau Anahatana, areimo openeso tau omi oi. Anomo rapeka ata sio mo, openeso tau Au naone nea. ");
INSERT INTO nxl_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Sinana omi anomo osa na sio mai tuniai reini wason openeso tau Anahatana mo, mka anoo runamo sani anoo runa no mansiau. Ne omi mo, anomo osa na sio rei tewa. Tea mo, uroma omi nea na pene okata sio mai tuniai reini. Reiso openeso tanumo. ");
INSERT INTO nxl_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Anomo rapeka na sae wan uasaui nnai osimo nea rei. Uasau ata, ‘Ia maniane mo, ia mainae inesi upui tewa.’ Reiso sani ouna sinsaraku nea, areimo omi iae mka sio ouna sinsaramo oi. Sani sio oatinu sae wan uatuheteso tanre, sio iae mka oatinu sae wan omi oatuheteso tanre rei oi. ");
INSERT INTO nxl_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mka ouna sinsaramo tau omi mo, Au we mansiau. Tea mo, oationa Ia wain iaisosi Au reini tewa. ");
INSERT INTO nxl_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Sinana uhoka tewa na uatuheteso tewa, areimo osana tewa. Tea mo, openeso tanuku tewa. Ne, muie reini, Au wan uhokaku uatuheteso nea, reiso sio mo, mka oasau tewa nea ata oanei tewa ata sae wan ounai rei mo, opalalosa. ");
INSERT INTO nxl_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ia seia wain ipenei tau Au, areimo ipenei tau Au Amaku oi. ");
INSERT INTO nxl_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Onoo Au una sima-simana waron ia seia man iuna kuare tewa. Ne openeso oparisaa tau Au sirinia. Sinana Au una sima-simana rai tewa, osana tewa. Ne masike onoo sima-simana rai nea iae, openeso tau Au runa Amaku sirinia. ");
INSERT INTO nxl_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ne openeso tanuma rei, areimo opusu waron sio okanure tau Anahatana ne maunauna. Okanu ata Anahatana iasau ata, ‘Openeso tanuku ne umunaso tewa.’ ");
INSERT INTO nxl_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Mka tau muie uaisosi Anahatana ne Inaha on roe Amaku na iakahaimo. Mka iatuhete maunauna waron manisata rerihon Anahatana osimo. Anahatana ne Inaha mka isima rerihoni Au. ");
INSERT INTO nxl_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Omi iae kahurae osima rerihoni Au oi. Tea mo, oni mato uanori mai tuniai rein mo, omi okataku nea.” ");
INSERT INTO nxl_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yesus ianamana osi ne mampusua ata, “Uasau osimo nea ata mka mansiau openeso tanumo na sani ouna sinsaramo mo, oparisaa tanuku sinia. ");
INSERT INTO nxl_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Mka sio osopomo na pene oheta ita Yahudiu re numa mananoune. Renesi rei, mka sio wason ohunumo oata kani wason opusu Anahatana ne maue. ");
INSERT INTO nxl_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Sio mka ouna san rei tau sio mo, oationa Au runa Amaku tewa. ");
INSERT INTO nxl_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mato uasau osimo nea na sani ouna sinsaramo mo, anomo rapeka ata Au uasau osimo nea. Uasau osimo naone tewa, tea mo, Au wan ukatamo asi.” ");
INSERT INTO nxl_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yesus ianamana honu osi ne mampusua ata, “Nanie ununiku roe Amaku wain iaisosiku uhokaku mai tuniai reini. Ne ia seia man arihon omi iasei ata nanie ueuku supan mo, tewa. ");
INSERT INTO nxl_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ne anomo rapunokoso tau uasau osimo ata nanie ununiku roe Amaku wain iaisosiku rei nea. ");
INSERT INTO nxl_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nanie uasau sae wan manisate osimo. Ne sani ununiku, areimo iake osimo. Areimo tau sani ununi tewa, mka Amaku ne Inaha ihoka tewa na iakahaimo tewa. Ne sani ununiku mo, mka uaisosi ne Inaha ihoka na iakahaimo. ");
INSERT INTO nxl_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Sani Anahatana ne Inaha ihokai, mka iuna sio mai tuniai reini oanei ata sio mo, opalalosa. Mka iatuheteso runa ia sia sahoro iamanisa mai Anahatana uai anoe. Ia iae mka iatuheteso rerihoni seiso sahoro Anahatana mka iapasanaso. ");
INSERT INTO nxl_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Mka iunaso oanei ata opalalosa sani oparisaa tau Au tewa. ");
INSERT INTO nxl_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nanie ununiku roe Amaku honu, reiso mka Anahatana ne Inaha iatuhete mansiau ata Au sahoro Au manisate. Omi mo, mka onooku tewa nea. ");
INSERT INTO nxl_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ia iae mka isima ata Anahatana nanie iapasana ia aia sakahatene wain ne kawasa tau tuniai reini nea. Reiso oanei ata mka iapasana sio oi. ");
INSERT INTO nxl_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nanie uasau panesi osimo asi, ne muie reini omi oatarimare ia-ia tewasi. ");
INSERT INTO nxl_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ne mka Anahatana ne Inaha ihokai. Oyo iatuhetemo rerihoni sae waron titue arihoni Anahatana. Mka iakahaimo na oanei sae man waron titue. Ruai ianamana tewa. Ne isima runa sae waron iatinure arihoni Amaku. Mka isima runa pan muie sapan. ");
INSERT INTO nxl_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Anahatana ne Inaha mka inana Au we maunaune na isima osimo. Reiso mka iuna mansiau oamuiraku. ");
INSERT INTO nxl_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Amaku ne sae man, areimo osi Au oi. Areiso uasau ata, Ne Inaha mka iasau osimo rerihon sae wani isupui arihon Au.” ");
INSERT INTO nxl_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesus iasau osi ne mampusua ata, “Potuina tewa nea oyo onoo Au tewa nea. Ne mka, potuina tewa honu, uhokaku honu.” ");
INSERT INTO nxl_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Oyo Yesus ne mampusua umau oasau mai umau ata, “Iasau ata potuina tewa nea oyo inooi tewa nea, ne potuina tewa honu ihokai honu. Oyo wani iasau ata nanie inuniki roe Amai. Areimo sapan?” ");
INSERT INTO nxl_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Oasei sui osa ata, “Iasau ata potuina tewa nea mo, areimo sapan? Ami anei mosa sae wani iasaui rei tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesus ianei ata nanie oasei tanui reiso iasau osiso ata, “Oasei tau umau rerihon sae wan uasaui sinasi rei si? Wamo oasei tau umau ata potuina tewa nea oyo onooku tewa nea. Ne, potuina tewa oi uhokaku honu tea? ");
INSERT INTO nxl_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Oatinu mai ia-ia, nanie uasau osimo. Omi mo, mka orani oasanoata. Ne sio mai tuniai reini mka anoo mirika. Mka anomo mtinta, ne mka anomo mirika honu. ");
INSERT INTO nxl_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Areimo noo sani ia pina isa iasanoata iahana reina nai osa tau nanie irue na anai. Ne, sani ia ikine iamrai nea, sinasi wan iasanoata iahana reina rei mo, anoi kanihue nnai nea. Anoi mirike tau anai iamrai nea. ");
INSERT INTO nxl_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Omi mo, noo sani ia pina wain nanie irue na anai rei. Nanie oapunokomo noso Au. Ne tau uhokaku honu mai tanumo, omi mka anomo mirika. Ia seia man iuna kua sae isa tewa na pene anomo mirika. ");
INSERT INTO nxl_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Tau rei mo, oasei sae isa arihon Au tewa nea. Atinu mai ia-ia, nanie uasau osimo. Sae man wan oainisiki arihon Amaku tau Au nanaku, mka iruiki osimo. ");
INSERT INTO nxl_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Rotu-tu reini, oainisi sae isa arihon Au Amaku tau Au nanaku tewasi. Oainisi, mka irui osimo. Na anomo mirika nai osa. ");
INSERT INTO nxl_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Uasau rai pusire osimo tau sou matieue, ne mka reeu mai tau nene orase na mka uanamana tau sou matieue tewa nea. Tau rei, mka uasau mai matamo rerihon Amaku. ");
INSERT INTO nxl_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tau rei, omi ruamo oainisi arihoni Amaku tau Au nanaku. Kahurae uainisi arihon Amaku osimo tewa nea. ");
INSERT INTO nxl_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tea mo, Amaku mo, anoi runamo tau omi anomo runa Au na oparisaa ata Au mo, uhokaku on roe Anahatana. ");
INSERT INTO nxl_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Uhokaku on roe Amaku mai tuniai reini. Ne nanie ueu arihon tuniai reini na ununiku roe Amaku.” ");
INSERT INTO nxl_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ne mampusua oatinu san rei oyo oahata, “Areini mato Ano anamanai matae. Anamanai tau sou matieue tewa nea. ");
INSERT INTO nxl_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Areini mato ami anei ata Ano anei pusire. Ano anina ia seia man tewa na iasei tau Ano rerihon sae man. Areimo tau Ano anei sae wan nanie aseiki naone nea. Areiso reunama aparisaa ata Ano mo, ahokaya on roe Anahatana.” ");
INSERT INTO nxl_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Oyo Yesus iahata, “Reiso mato oparisaa ata Au mo, uhokaku on roe Anahatana si? ");
INSERT INTO nxl_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ne oatinu mai. Potuina tewa nea oyo omi oruma pamanahun sui mo numau. Oarihon Au ruaku man. Ne Au mo, ruaku man tewa. Areimo tau Amaku wain ikata runaku. ");
INSERT INTO nxl_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Uasau raini pusire na anomo kaia noso anomo osa runa Au. Omi mo, mka sinsaramo mai tuniai reini. Ne omi mo, kahurae oapamese anomo. Tea mo, unesi sio wason onesiku mai tuniai reini nea.” ");
INSERT INTO nxl_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesus ianamana osi ne mampusua suka, oyo iarinaa na roe nante oyo iainisi. Iahata, “Ama, nene orase nea tau umataku. Uainisi arihonia na amuira Au, Anam reini, na Au iae uamuira Ano oi. ");
INSERT INTO nxl_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tea mo, arui kawasa tau mansia pusiki osiku nea na Au una sio pusiso wason aruiso osiku rei oamahaiso okataya rotu-tu ria supan. ");
INSERT INTO nxl_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mansia oamahaiso okataya rotu-tu ria supan mo, oationaya. Oationa Ano wan Anahatana wain manisate osa ruai. Na oationa Au, Yesus Kristus, wain Ano aisosiku uhokaku mai tuniai rein. ");
INSERT INTO nxl_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Uamuiraya mai tuniai rein. Tea mo, Au una pusire waron aisosiku unare nea rei. ");
INSERT INTO nxl_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Reiso Ama, uainisi arihonia na sani ukataya honu, amuiraku honu, noo sani naone ukataya oni tuniai reini wan tewasi.” ");
INSERT INTO nxl_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ama, uatuhete sio wason aruiso osiku rerihoni Ano nea. Naone opusu sio mai tuniai reini ne aruiso osiku nea. Sio rei mo, Ano me mansiau, ne aruiso osiku nea. Opusu me maunauna nea. ");
INSERT INTO nxl_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Muie rein oanei nea ata sae man waron uaunaure na unare rei mo, pusire on roe Ano. ");
INSERT INTO nxl_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tea mo, usima na maunauna waron Ano asau runare osiku rei nea. Na sio iae oatarimare nea. Sio iae oaneire ia-ia nea ata Au mo, uhokaku on roe Ano. Oparisaa ata Ano sahoro aisosiku uhokaku rein. ");
INSERT INTO nxl_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ama, uainisi osi we mampusua rei. Uainisi osi sio mai tuniai reini mo, tewa. Ne uainisi osi sio wason aruiso osiku rein. Tea mo, sio rei mo, Ano me mansiau. ");
INSERT INTO nxl_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Sio wason we mansiau rei mo, Ano me mansiau oi. Sio pusiso wason Ano me mansiau mo, Au we mansiau oi. Sio rei oamuiraku nea. ");
INSERT INTO nxl_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mka urueku mai tuniai reini potuina tewa nea. Areimo tau nanie ununiku roe tanua nea. Ne sio mo, wason mai tuniai reini asi. Ama, Ano wan manisate onate, sakaso na me kawasa wan aruiki osiku rei. Sakaso na pusiso anoo osa, nooi sani ita ua wan anori osa. ");
INSERT INTO nxl_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Oni ukataso asi mo, usakaso na we kawasa wan Ano aruiki osiku rei. Usaka runaso na okataya rotu-tu ria supan. Hasae ia osa man sahoro tewa. Ia rei mo, mka ikataya rotu-tu ria supan tewa na reeu san sae waron sio okanure tau me anamanaya. ");
INSERT INTO nxl_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ama, nanie ununiku roe tanua nea. Ne uasau raini pusire oni Au wan tuniai reini asi na we mampusua anoo mirika, nooi sani Au iae anoku mirike oi. ");
INSERT INTO nxl_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Usima na me maunauna osiso nea. Reiso sio wason oparisaa tau Au tewa mai tuniai rein openeso tanso. Tea mo, sio sani Au, anoo osa na sio mai tuniai wason oparisaa tanua tewa. ");
INSERT INTO nxl_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Uainisi na ananaso arihon tuniai reini mo, tewa. Ne uainisi na asakaso arihon ia aia sakahatene wain saka iuna kahatene rei. ");
INSERT INTO nxl_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Sio rei mo, anoo osa tewa na sio wason oparisaa tau Au tewa wason mai tuniai rein. Noo sani Au iae anoku osa na sio rei tewa. ");
INSERT INTO nxl_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Akahai we mampusua na ouna me mansiau wason opusu me maunauna man. Opusu me maunauna waron manisata sui osa. Sae man waron Ano asau runare reimo manisata. ");
INSERT INTO nxl_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Noo san Ano aisosi Au uhokaku mai tuniai reini, Au iae uaisosi sio mai tuniai reini pusiki oi. ");
INSERT INTO nxl_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Noso sio, urui ruaku na uanori runaya ia-ia nea na sio iae orui ruao oanori runaya ia-ia oi.” ");
INSERT INTO nxl_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ama, uainisi osi we mampusua reini man tewa. Ne uainisi osi ia sia man wason mka oparisaa tanuku noso oatinu sae waron we mampusua oatuheteso. ");
INSERT INTO nxl_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Uainisi na pusiso anoo osa, nooi sani ita ua anori osa oi. Uainisi na anoo osa na uata, na sio mai tuniai rein oparisaa ata Ano sahoro aisosiku. ");
INSERT INTO nxl_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Uamuira we mampusua nooi sani Ano amuira Au. Au una san rei na pusiso anoo osa, nooi san ita ua iae anori osa oi. ");
INSERT INTO nxl_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Au anoku osa na sio runa Ano anom osa runa Au. Uainisi na pusiso titue-tue anoo osa na sio mai tuniai rein oanei ata Ano aisosiku runa anom runaso, nooi san Ano anom runa Au oi. ");
INSERT INTO nxl_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ama. Unina na sio wason aruiso osiku nea rei okataku roe naniaku na onoo Ano amuiraku. Ano amuiraku, areimo tau anom runaku oni tuniai reini remrae tewasi. ");
INSERT INTO nxl_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ama, Ano ese hae osa man tewa. Masike sio mai tuniai rein mo, oationaya tewa, Au uationaya runa we mampusua oanei ata Ano sahoro aisosiku. ");
INSERT INTO nxl_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Au uatuheteso reiso oationaya nea. Mka uatuheteso san rei sui osa na anoo na umau, noo sani anom na Au runa anoku osa nnaso oi.” ");
INSERT INTO nxl_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesus iainisi suka oyo ieui arihon kota Yerusalem ikata ne mampusua. Oeuso poe wae ikine isa wani nanae Wae Kidron pan hae. Pan rei mo, nisi saitun isa wapan. Reiso Yesus sio oeuso pan rei. ");
INSERT INTO nxl_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudas wain iahen Yesus osi sio ohunui rei iae ianei nisi rei oi. Tea mo, Yesus saka ieui ikata ne mampusua pan rei. ");
INSERT INTO nxl_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Reiso Yudas ihoka iautunu sio Romau no tantarau polotu osa na sio mamsaka ami Yahudiu ma numa mainisie. Sio imam no sio mainaya na sio onata arihon akama Yahudi oaisosi sio mamsakaya rai. Ohoka orori kamana, tunua, na atiena. ");
INSERT INTO nxl_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ne Yesus ianei nea na sae wan mka reyari tanui. Reiso ieu isupuso oyo iasei tanso ata, “We amau, nanie onina ia seia?” ");
INSERT INTO nxl_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Oyo oasau ata, “Anina Yesus wain on pan nia Nasaret.” Oyo Yesus iahata, “Au ruaku rein.” Yudas wain iahen Yesus rei iae waimo iooi pan rei ikataso oi. ");
INSERT INTO nxl_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Taa Yesus iasau ata, “Au rein,” pusiso osuka hae muie oyo oamnohoso na poe tuamane. ");
INSERT INTO nxl_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Reiso Yesus iasei honu ata, “We amau, wan onina ia sia?” Oasau ata, “Anina Yesus wain on pan nia Nasaret.” ");
INSERT INTO nxl_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesus iahata, “Uasau osimo sinasi nea ata Au reini. Munata titue Au rein sahoro ia wain oninai mo, ne tapi we mampusua rein oeuso.” ");
INSERT INTO nxl_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yesus iasau san rei na sae wan iasaui naone rei reeu. Naone iasau ata, “Ia isa arihon sio pusiso wason aruiso osiku rei, usakaso na okatata rotu-tu ria supan.” ");
INSERT INTO nxl_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tau rei mo, Simon Petrus waimo irori tunue. Sira tau isaru tunue rei oyo ioto roha Malkus tinai ukune hae wanane warohai. Malkus mo, sio imam no ia mainae ne manorine isa. ");
INSERT INTO nxl_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Oyo Yesus iasau osi Petrus ata, “Nusu me tunue rei. Au mo, kahurae sinsaraku nea. Amaku iaunutui san rei osiku nea.” ");
INSERT INTO nxl_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Yesus ianamana runa Petrus pusi, oyo sio tantara Roma polotu osa runa no ia mainae na sio mamsaka sio Yahudiu no numa mainisie rei osota Yesus. Osotai samatoro okanihooi. ");
INSERT INTO nxl_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Oyo ororiki osi sio Yahudiu no sio imam no ia mainae wain nanai Hanas. Hanas mo, amai hanahanai tau Kayapas. Tau musum reimo, Kayapas mo, iuna sio imam no ia mainae. ");
INSERT INTO nxl_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayapas mo, naone iasau osi sio Yahudiu no sio mainaya ata, “Nene iake mo, sana osa imatai ikati mansia pusiki.” ");
INSERT INTO nxl_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Tau sio orori Yesus roe sio Yahudiu no sio imam no ia mainae mo, au na Simon Petrus uama aeu auhun tau muie pusu Yesus oi. Au uationa sio Yahudiu no sio imam no ia mainae rei. Reiso unusu kata Yesus oi pan sio Yahudiu no imam no ia mainae rei ne pakelo anoe. ");
INSERT INTO nxl_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ne Petrus mo, kahurae inapa pan mui pan pakelo mitanunue man. Ueu honu nau haineke pakelo mitanunue na uanamana na ia pina maniane isa wain isaka mitanunue rei. Oyo itapi Petrus inusui pani pakelo anoe. ");
INSERT INTO nxl_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Oyo iasau osi Petrus ata, “Ano mo, Ia wain sio oamanarui rein ne mampusue isa rei tea!” Petrus iahata, “Tewa! Au mo, tewa!” ");
INSERT INTO nxl_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tau pumono rei mo, mahatane. Reiso sio imam no ia mainae ne sio manianeu na sio mamsaka sio Yahudiu no numa mainisie umau oakanupu usa na ooso oasa ruao. Petrus ieu noi iooi iasa ruai noi rei oi. ");
INSERT INTO nxl_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sio imam no ia mainae iasei tau Yesus rerihon ne mampusua runa ne maunauna. ");
INSERT INTO nxl_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Oyo Yesus iasau ata, “Au mo, uanamana mai mansia hutue matao kahutua. Au mo, saka uatuhete mansiau sui numa mananouna na sui Anahatana ne numa mainisie nusue wan ita Yahudiu saka iamanouta noi rei. Au mo, uatuhete mansia mo, uauhun-uauhun tewa. ");
INSERT INTO nxl_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Reiso nanie asei tanuku san rei tau sae? Asei tau sio wason oatinu we maunauna nea rei. Sio rei mo, oanei sae wan uasaui osiso nea rei, tea!” ");
INSERT INTO nxl_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesus wain ianamana, sira tau ia mamsakae isa iasapana uai anoe. Iahata, “San rei si? Anamana na sio imam no ia mainae san rei si?” ");
INSERT INTO nxl_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ne Yesus iahata, “Sani munata sae wan uasaui rei mo, resana, areimo atuhete osiku mai ata resana sapan. Ne sani munata sae wan uasaui rei mo, manisate mo, pene asapanaku.” ");
INSERT INTO nxl_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Pusi, oyo Hanas iaisosiso orori Yesus roe sio imam no ia mainae wain nanai Kayapas. Onosu hanai waron okanihoore rei tewasi. ");
INSERT INTO nxl_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Petrus waimo iooi iasai asi. Oyo sio wason noi rei oasei tanui ata, “Ano mo, Ia hanaie rei ne mampusue si?” Ne Petrus iauhaa ata, “Tewa! Au mo, tewa!” ");
INSERT INTO nxl_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sio imam no ia mainae ne ia maniane isa waimo iooi noi rei. Ia rei mo, ia wain Petrus ioto roha tinai ukune hae ne mansia. Iasau osi Petrus ata, “Sinasi mo, noo sani unooa akata ia hanaie rei ria nisi saitun. Titue, tea?” ");
INSERT INTO nxl_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ne Petrus iauhaa honu. Iauhaa oyo sira tau manue retunkeko. ");
INSERT INTO nxl_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","On punano tunne asi oi mo, sio orori Yesus on poe Kayapas oeuso roe Pilatus ne numa aia. Pilatus mo, sio Romau no gubernur. Tau rei mo, sio Yahudiu wason oamanaru Yesus rei mo, openeso onususo pani Pilatus ne numa aia. Areimo tau Pilatus mo, ia Yahudi tewa. Sio Yahudiu no monne mo, resoposo na pene onusu sio wason sio Yahudiu tewa no numa. Sani onesi na onusu, areimo oapaputi ruao. Mka oaiso tau karisaa anoma rapeka na Anahatana ihoka ma upu momou arihon otoe Mesir tewa nea. ");
INSERT INTO nxl_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Reiso, Pilatus ihokai na isupuso. Oyo iasei mai tanso ata, “Iuna sana sae rotu-tu ororiki mai tanuku reini?” ");
INSERT INTO nxl_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Oyo sio rei oasau ata, “Ia reini mo, ia kahatene. Reiso aroriki mai tanua reini.” ");
INSERT INTO nxl_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Oyo Pilatus iahata, “Munata san rei mo, roriki na oapasanai pusu ruamo mo monna!” Ne oasau ata, “Ami ma kawasa tau apasana mansia rotu-tu imatai tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Oasau san rei na sae wan Yesus iasau rerihon mka imatai sapan rei reeu. ");
INSERT INTO nxl_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Oyo Pilatus inusui pani ne numa honu. Oyo ioi Yesus oyo iasei tanui ata, “Titue si? Ano mo, sio Yahudiu no Ia Aia si?” ");
INSERT INTO nxl_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesus iahata, “Asei san rei mo, arihon ruam te sio umau oaisosia asei tanuku san rei?” ");
INSERT INTO nxl_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Oyo Pilatus iahata, “Ano ata kan au rein mo, au Yahudi si? Sio wason ororia mai tanuku rei mo, ruam me mansiau na me sio imam no sio mainaya. Reiso asau mai, auna sana sae?” ");
INSERT INTO nxl_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Oyo Yesus iasau osiki ata, “Au una aia mo, sio mai tuniai reini ohitiku tewa. Ne sani Au una aia, sio mai tuniai rein ohitiku, sinasi we mampusua oanahitana oneteku na pene sio Yahudiu no sio mainaya osotaku. Ne tewa. Au una aia mo, sio mai tuniai reini ohitiku tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Oyo Pilatus iasei ata, “Munata san rei, Ano rein mo, Ano Aia, tea!” Oyo Yesus iahata, “Ano asau ata Au mo, Au Aia. Areimo titue. Uamrai mai tuniai na una Aia. Uhokaku mai tuniai rein na usima rerihoni sae wan manisate. Ia sia wain inina sae wan manisate mo, mka iatinu tau Au.” ");
INSERT INTO nxl_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Oyo Pilatus iasau osi Yesus ata, “Ita imaha tewa ianei sae wan manisate, tea!” Pilatus ianamana runa Yesus pusi, oyo ihokai nau mui na ianamana na sio Yahudiu wasun nau mui rei. Iasau osiso ata, “Uasei tanui nea ne usupu ne isanae isa tewa. ");
INSERT INTO nxl_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tau karisaa anomo rapeka na Anahatana ihoka mo upu momou arihon otoe Mesir, usaka uhoka ia isa arihon pui osimo. Reiso onina na uhoka ia wain oaoiki ‘natu tau omi Yahudiu’ osimo?” ");
INSERT INTO nxl_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Sio panesi rei oatinu Pilatus iasau san rei oyo oakapona oasau ata, “Pene, pene hoka Ia! Hoka Barabas osima man!” Barabas mo, inusu pui tau inesi sio Romau na pene orime sio Israel. ");
INSERT INTO nxl_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilatus ianamana runa sio Yahudiu pusi, oyo inusui na pan ne numa anoe. Oyo iaisosi ne sio tantarau. Iahata, “Oeu rori Yesus na osapui.” ");
INSERT INTO nxl_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Osapu Yesus pusi, oyo opepe awane unie wan nonae, samatoro oausahui roe unui. Oyo oausahu papi naue wan msinae sani sio aiau oausahui osiki. ");
INSERT INTO nxl_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Oahata sui osa, “Tapea. Natu sio Yahudiu.” Oasapana uai anoe. ");
INSERT INTO nxl_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatus ihokai arihon ne numa anoe honu. Oyo iahata, “Noo mai! Wan uhokai osimo na oanei ata usupu ne isanae isa man tewa oi.” ");
INSERT INTO nxl_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tau Yesus ihokai iausahu awane unia waron opepere roe unui na iausahu papi naue wan msinae, Pilatus iasau ata, “Noo mai, Ia reini!” ");
INSERT INTO nxl_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ne sio Yahudiu no sio imam no sio mainaya runa sio tantarau wason osaka sio Yahudiu no numa mainisie onoo Yesus, oyo oakapona. Oahata, “Rorui roe hini! Rorui roe hini!” Ne Pilatus iahata, “Om ruamo oeu ororui roe hiniu. Au mo, usupu ne isanae isa tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Sio ona Yahudiu rei oasau osi Pilatus. Oata, “Pusu Musa ne maunauna mo, kahurae hunui. Tea mo, iasau ata Ia mo, Anahatana Anai.” ");
INSERT INTO nxl_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatus iatinu oasau ata Ia mo, Anahatana Anai oyo ikaitau hun ruai. ");
INSERT INTO nxl_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Reiso inusui pan ne numa anoe honu. Oyo iaisosiso orori Yesus. Oyo iasei tanui ata, “Ano mo, ano on supa?” Ne Yesus iamaturui man. ");
INSERT INTO nxl_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Reiso Pilatus iahata, “Penea anamana na au? Aikee au we kawasa tau uhokaya te uaisosi sio ororua roe hini.” ");
INSERT INTO nxl_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Oyo Yesus iahata, “Ano me kawasa mo, Anahatana sahoro iruiki osia. Reiso ano me kawasa tau Au, hasae sani Anahatana iruiki. Reiso ia wain iruiku osia sahoro ne rosa mainae renesi ano.” ");
INSERT INTO nxl_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilatus iatinu san rei oyo inina arena na ialapasi Yesus. Ne sio ona Yahudiu rei oakapona sui osa oahata, “Ia seia man wain iasau ata ia mo, ia aia, areimo ia rei inesi ia Aia Mainae Roma. Reiso sani alapasi Ia reno, areimo anesi ia Aia Mainae oi.” ");
INSERT INTO nxl_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatus iatinu sio Yahudiu oasau san rei oyo iaisosi sio tantarau na orori Yesus. Ia ruai iruei tau ne katera wani iarinii parakanau. Katera rei mo, oaoiki tau Numano Hatu. Ne tau sou Ibrani mo, nanae Gabata. ");
INSERT INTO nxl_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tau rei mo, kani pannuhu ranie katopu. Ranie hatae rei mo, wasumo onana tau nanie ma karisaa anoma rapeka na Anahatana ihoka ma upu momou arihon otoe Mesir. Pilatus iasau osi sio ona Yahudiu ata, “Noo mai, mo Ia Aia reini!” ");
INSERT INTO nxl_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ne oakapona ata, “Hunui! Hunui! Rorui roe hini!” Pilatus iasei ata, “Onina na uroru mo Ia Aia roe hini si?” Ne sio imam no sio mainaya oahata, “Ami mo, ma aia tau Ia Aia Mainae Roma. Ma aia tamene isa tewa nea.” ");
INSERT INTO nxl_vpl VALUES ("JN19_16a","073_19_16a","JHN","19","16a","16a","Oyo tau muie Pilatus ipusu sio Yahudiu no maue. Iaisosi ne sio tantarau na ororu Yesus roe hini. ");
INSERT INTO nxl_vpl VALUES ("JN19_16b","073_19_16b","JHN","19","16b","16b","Pilatus irui Yesus osi sio tantara Romau na ororiki nanie ororui roe hini. ");
INSERT INTO nxl_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesus ruai ihana ne hini on ohokaso arihon kota Yerusalem nanie oeuso roe naniake isa wani nanae Unuke Kanie. Sou Ibrani reoiki tau Golgota. ");
INSERT INTO nxl_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hoka roe, oyo ororu Yesus roe hini samatoro oapuooi. Ororu sio kahatena ua tau hini oi. Ia isa oapuooi hae Yesus hanai wanane, ia isa honu oapuooi hae Yesus hanai pante. Reiso Yesus wain pakarema uaso tihue. ");
INSERT INTO nxl_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatus iaisosiso okanu tau ai inate isa na oaunutui roe Yesus unui roe ne hini rei. Okanu san rei, “Yesus, Ia Nasaret. Natu tau sio Yahudiu.” ");
INSERT INTO nxl_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Sio Yahudiu panesi ohatae tau sae wan okanui roe ai inate rei. Areimo tau, naniake rei mo, haineke kota. Na sae wan okanui rei iae, okanui tau sou Ibrani, Latin, na Yunani. ");
INSERT INTO nxl_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Reiso sio imam no sio mainaya oasau osi Pilatus ata, “Kati sae waron okanui rei. Pene kanu, ‘Natu tau sio Yahudiu.’ Ne kanu, ‘Ia reini iasau ata Ia mo, Natu tau sio Yahudiu.’” ");
INSERT INTO nxl_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ne, Pilatus ata, “Sae wan ukanui nea mo, rei man. Pene katiki nea!” ");
INSERT INTO nxl_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sio tantarau rei ororu Yesus suka, oyo onana ne apia tau tinain oyo osamare tau ate. Ia isa isupu osa. Ne ne papi naue mo, oneai. Papite rei mo, ohoniki tewa, ne orae pola on roe rurue tu-tu poe rurue. ");
INSERT INTO nxl_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Reiso oasau mai umau ata, “Nene iake mo, pene ikihai nea ne mai na irehi katoite na inoo ia sia sahoro isupui.” Rai pusire raeu sani sae waron naone okanure tau Anahatana ne anamanaya waron oasau san rei, “Osama-sama we apia osi umau. Orehi katoite tau we papi naue.” Reiso ouna san sae wan okanui tau Anahatana ne anamanaya rai. ");
INSERT INTO nxl_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tau rei, Yesus inai, inai wanin, Klopas sahai wain nanai Maria, na Maria on pan nia Makdalena pusiso wasumo ooso haineke Yesus ne hini rei. ");
INSERT INTO nxl_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesus inoo inai na au, ne mampusue wain anoi runaku, wan aooma noi rei. Iasau osi inai ata, “Ina, oni orase repan, ia mo, ano anam tau ia rei.” ");
INSERT INTO nxl_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Oyo Yesus iasau osiku ata, “Saka ia pina onate reini sani inam ruai.” Reiso oni orase reini uroriki poe we numa na usakai. ");
INSERT INTO nxl_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesus ianei nea ata tanei waron Anahatana iaisosiki iunare rei mo, iuna pusire nea. Ne ianei ata sio okanu tau Anahatana ne anamanaya reiso iasau ata, “Anoku kasae.” ");
INSERT INTO nxl_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Noi rei potone wan oaiinui tau tihu anggur wan maninue wamo rei oi. Reiso ia isa inana nokase sanae oyo ononoi poe anggur wan maninue rei, samatoro isipai tau ai hisop sanae oyo iruiki roe Yesus sihurui. ");
INSERT INTO nxl_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesus iahana tihu anggur wan maninue rei oyo iasau ata, “Au una pusire nea.” Oyo ikanahatai oyo watipusi nahai. ");
INSERT INTO nxl_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ranie hatae rei mo, ranie hatae wani ami Yahudiu anana ma tanei apia tau anapa ma ranie hatae wan ami amuira Anahatana. Ranie hatae wan amuira Anahatana rei mo, mon mainae. Tea mo, pannuhu ami Yahudiu ma karisaa anoma rapeka na Anahatana ihoka ma upu momou arihon otoe Mesir. Reiso, sio ona Yahudiu openeso tau otapi matana rakatana roe hini. Oyo, oeu oanamana runa Pilatus na iaisosi sio tantarau na okuparehi Yesus na sio kahatena ua rei aio atua, na opanokoso on sin. Opanokoso na rapu orati no tihana hataya arihon no hiniu rai. ");
INSERT INTO nxl_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Oyo, sio tantarau oeu okuparehi sio kahatena ua wason sio ororuso roe hini okata Yesus rei aio atua naone, ia isa pusi ia isa. ");
INSERT INTO nxl_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ne ohokaso mai Yesus, onoo wain ipanokoi nea. Reiso, okuparehi ain atua tewa nea. ");
INSERT INTO nxl_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ne ia tantara isa isipa Yesus nusui anae tau atiene. Oyo nasi wan renehu tihu on pan reana. ");
INSERT INTO nxl_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Au, Yohanis, ruaku unoo sio ohunu Yesus oyo wan usima. Sae waron usima nnare rei mo, pusire manisata. Uanei ata sae waron usima nnare rei mo, pusire manisata reiso usima osimo na omi iae oparisaa oi. ");
INSERT INTO nxl_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Sio tantarau rei okuparehi ain atua tewa. Areimo, ereeu san sae wan sio okanu tau Anahatana ne anamanaya san reini, “Ne unia isa tewa oi, okuparehiki tewa.” ");
INSERT INTO nxl_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Okanu san reini oi, “Mka sio onoo Ia wain osipai nea rei.” ");
INSERT INTO nxl_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ia isa wain ipusu Yesus nanai Yusup. Yusup mo, ia arihon nia Arimatea. Ne ipusu Yesus iauhun-iahunki man. Tea mo, ikaitau sio ona Yahudiu. Yesus panokoi, oyo Yusup ihokai ianamana runa Pilatus na inana Yesus ne tihane hatae. Oyo Pilatus iamanaku reiso irati Yesus ne tihane hatae on roe hini. ");
INSERT INTO nxl_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus ikatai. Nikodemus mo, ia wain naone ieu pan Yesus tau pumono rei. Tau rei, Nikodemus irori hau rihua nanie iauhene Yesus ne tihane hatae. Hau rihua rai mo, nanaya mur runa alalasie. Onehu uare tau osa nea. Nene mtinta kilo hutu tonu nesi. ");
INSERT INTO nxl_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Onana Yesus ne tihane hatae oyo uaso opai tau nipa ohie nene sinta na hau rihua rai pusire oi. Ouna san rei mo, repusu ami Yahudiu ma monne tau autotu matane. ");
INSERT INTO nxl_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Haineke sio ororu Yesus roe hini rei mo, nisi isa wamo. Pan nisi anoe rei mo, sio mato ouna hatu anoe isa. Hatu anoe rei mo, sio unai tau kupuro. Ne honue asi reiso oaunutu matane pan anoe tewasi. ");
INSERT INTO nxl_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Oatasin Yesus pan rei. Tea mo, haineke man samatoro ranie hatae rei mo, sio Yahudiu wason opatapariso oseka tau no muaina na oaunutu noi no numau na onapa no ranie hatae wani oamuira Anahatana tau ran manne nea. ");
INSERT INTO nxl_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tau ranie hatae wan mataanoe tau minku unue rei, nene on punano tunne, Maria on pan nia Makdalena ieui pan Yesus ne kupuro. Ihokai pan, sira tau hatu mainae wan renete kupuro rei nene mitanunue okamauniki nea. ");
INSERT INTO nxl_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Reiso, iruma inina Simon Petrus runa au, Yesus ne mampusue wain anoi runaku, na isima osima. Iahata, “Sio onana Upuri ne tihane hatae arihon kupuro anoe nea. Ne ami anei tewa ata sio oaunutui sui supa!” ");
INSERT INTO nxl_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Reiso au na Petrus aeuma pan kupuro rei. ");
INSERT INTO nxl_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Uama aruma na pan kupuro. Ne au mo, uruma rapu unesi Petrus. Reiso uhokaku pan kupuro naone. ");
INSERT INTO nxl_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Hoka pan, ukanahata oyo unoo na pan kupuro anoe. Unoo nipa ohie nene sinta-sinta waron sio opa Yesus tanre rei. Ne unusu pan kupuro anoe tewa. ");
INSERT INTO nxl_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Petrus ihoka tau muie, oyo ihuu inusui pan kupuro anoe rei. Inoo nipa ohie nene sinta-sinta waron sio opa Yesus tanre rei oi. ");
INSERT INTO nxl_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Inoo nipa ohie nene sinte wan ohehe Yesus unui tanui rei oi. Ne ia isa inokui nea. Rekata nipa sinta waron opa ne tihane hatae tanre rei tewa nea. ");
INSERT INTO nxl_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Oyo au, wan uhokaku mai kupuro naone, unusuku oi. Unusu unoo pusire rei, uparisaa ata Yesus mo, iamahaiki honu. ");
INSERT INTO nxl_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ami anei tewasi ata sae waron sio okanure tau Anahatana ne anamanaya waron oasaure ata, Yesus mo, kahurae iamahaiki honu. ");
INSERT INTO nxl_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Au na Simon Petrus anoo Yesus ne kupuro huie oyo anunima. ");
INSERT INTO nxl_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ne Maria Makdalena iooi haineke kupuro mai mui irani. Wain iran asi, oyo ikanahata na inoo pan kupuro rei anoe. ");
INSERT INTO nxl_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Sira tau inoo Anahatana ne maisosia ua on roe noiyaha. Uaso oausahu papi putia. Wasuro orueso roe naniake wan sio oaunutu Yesus ne tihane hatae rei. Ia isa iruei roe unui nahae, na ia isa honu iruei poe ain atua nahaya. ");
INSERT INTO nxl_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Oyo oasei tau Maria ata, “Ano pina onate, arani tau sae rei?” Maria iasau ata, “Sio onana Upuku ne tihane hatae arihon rein nea. Samatoro uanei tewa ata oaunutui sui supan.” ");
INSERT INTO nxl_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Iasau san rei pusi, oyo iuni inoo mo, Yesus waimo iooi pan rei. Ne ianei tewa ata Ia rei mo, Yesus. ");
INSERT INTO nxl_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Oyo Yesus iasau osiki ata, “Ano pina onate, arani tau sae rei? Anina ia seia?” Maria ata kan ia rei mo, ia mamsaka nisi rei. Reiso iasau ata, “Upu! Sani munata ano sahoro anana Upuku ne tihane hatae mo, asau osiku mai. Aunutui sui supa na ueu unanai.” ");
INSERT INTO nxl_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesus iasau ata, “Maria.” Maria iuni inoo Yesus oyo iasau ata, “Rabuni!” (Rabuni mo, sou Ibrani. Nene manarti mo, Ano Ona Matuhetene.) ");
INSERT INTO nxl_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Oyo Yesus iasau osiki ata, “Pene akahuu Au. Tea mo, ununiku roe Amaku tewasi. Ne eu na sima osi we kaka wani wason oparisaa tau Au ata Au nanie ununiku roe Amaku Anahatana wain uainaa nnai. Ia iae omi mo Ama na Anahatana wain oainaa nnai oi.” ");
INSERT INTO nxl_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Reiso Maria Makdalena inuniki isima runa sae wan Yesus iasau osiki rei osi ami, ne mampusua. Iasau ata, “Unoo Upuri nea!” Oyo isima runa sae wan Yesus iasau rei osi ami ne mampusua. ");
INSERT INTO nxl_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tau ranie hatae wan mataanoe tau minku unue rei wapan pumono nea. Ami ne mampusua amanouma tau numa isa. Akatunepa mitanunua pusire tau akaitau sio ona Yahudiu. Sira tau Yesus ihoka iooi kua pusima tihue oyo iasau ata, “Uainisi na Anahatana iunamo okarihuru oamahai!” ");
INSERT INTO nxl_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Oyo iatuhete ne apata nahaya mai hanai na poe nusui anae rei osima. Taa anoo ma Upu san rei, oyo anoma mirika. ");
INSERT INTO nxl_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesus iasau honu ata, “Uainisi na Anahatana iunamo okarihuru oamahai. Uaisosi omi oaunau sio mai tuniai reini noo sani Amaku iaisosi Au oi.” ");
INSERT INTO nxl_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Oyo iauhona ne nusete osima iahata, “Atarima Anahatana ne Inaha. ");
INSERT INTO nxl_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Sani anomo rasaa tewa tau ia sia man wain ipalalosa, Anahatana iae isiru heu ne rosau oi. Ne sani anomo rasaa sinia, Anahatana iae isiru heu rosau tewa oi.” ");
INSERT INTO nxl_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ia isa arihon Yesus ne mampusua hutusa rahana ua rei, nanai Tomas. Sio saka oiki tau Didimus oi. Didimus mo, nene manarti Ia Iki Alaleka. Tau Yesus iatuhete ruai osi ami ne mampusua rei mo, Tomas waimo ikatama tewa. ");
INSERT INTO nxl_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Reiso ami ne mampusua tamena rei asau osi Tomas ata, “Tomas! Ami anoo Upuri nea.” Ne Tomas iahata, “Uparisaa tanumo tewa. Kahurae ruaku unoo ne paku nahaya mai hanai. Kahurae uakahuu ne apate nahaya mai hanai na unusu hanaku noi apate nahae noi nusui anae rei.” ");
INSERT INTO nxl_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nene minku unue isa renikui nea, oyo ami ne mampusua rei amanouma honu pan numa rei. Tomas iae waimo ikatama oi. Akatunepa pusi mitanunua nea. Ne sira tau Yesus iooi mai pusima tihue. Iasau ata, “Uainisi na Anahatana iunamo okarihuru oamahai.” ");
INSERT INTO nxl_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Oyo iasau osi Tomas ata, “Tomas, mai na anoo we apata nahaya waron hanaku reini na akahuure na hanam nakata. Nusu hanam mai we apate nahae wan mai nusuku anae rein. Pene anom resama-samai, ne aparisaa!” ");
INSERT INTO nxl_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Oyo Tomas iahata, “Upuku! Anahatana wan uainaa nnaya!” ");
INSERT INTO nxl_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Oyo Yesus iahata, “Tomas, anooku nea, reiso aparisaa. Ne mka Anahatana irui iake osi sio wason onoo tewa ne oparisaa sinia.” ");
INSERT INTO nxl_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ami mampusua anoo Yesus iuna sima-simana panesi waron ratuhete ata ne kawasa arihon Anahatana warumo asi oi. Ne ukanu pusire mai surate rein tewa. ");
INSERT INTO nxl_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ne waron ukanure mo, ukanure na oparisaa ata Yesus mo, Ia Aia wain Anahatana Ihitiki na Iapuheu Mansiau. Ia mo, Anahatana Anai. Ukanu rain pusire oi na oparisaa. Oparisaa na oamahaimo okatai rotu-tu ria supan tau anomo osa nnai. ");
INSERT INTO nxl_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yesus iatuhete ruai osi ami ne mampusua suka, oyo iatuhete ruai nai osa honu osi ami umau haineke nakane wan nanae Tiberias. Areimo sani nanie uasau reini. ");
INSERT INTO nxl_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Au na kakaku Yakopis, Simon Petrus, Tomas wain sio oiki tau Didimus, Natanael arihon kota Kana wapan otoe Galilea, runa sio mampusua ua oi. ");
INSERT INTO nxl_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Oyo Simon Petrus iasau osi ami ata, “Nanie ueu upesi uete ee!” Oyo ami asau osiki ata, “Munata san rei mo, ami aeu akataya oi.” Reiso aeuma nau nakane na asaa arupai na aeu anina ikae. Ne asupu sae isa tewa nene onone hatae sepe-sepe. ");
INSERT INTO nxl_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nene omnanoe ranie on pan resaa nea, Yesus iooi haineke nakane. Ne ami ne mampusua ationai tewa. ");
INSERT INTO nxl_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesus iakapona ioima ata, “We netau, osupu ikae te tewa?” Asau ata, “Tewa!” ");
INSERT INTO nxl_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Oyo Yesus iahata, “Pesi mo uete rei hae arupai wanane! Mka osupu ikae.” Reiso, apesi ma uete rei hae wanane oyo asupu ikaya panesi nai osa rotu-tu anesa kua ma uete rei pan arupai anoe tewa. ");
INSERT INTO nxl_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ne au uationai reiso uasau osi Petrus ata, “Ia rei mo, Upuri Yesus!” Sinasi Petrus waimo ipakarian reiso inosu ne papi naue wan mui. Ne iatinu au uasau, “Ia rei mo, Upuri Yesus!”. Oyo iausahu ne papi naue honu, oyo isoman na poe waene, oyo ione na ria kaimenne. ");
INSERT INTO nxl_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ami mampusua tamena asaa arupai na ria kaimenne anesa uete wan taue na ikaya rai. Ami hainau arihon kaimenne tewa. Kani meter utun san rei. ");
INSERT INTO nxl_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ahokama ria kaimenne, anoo usa akena. Anoo ata ia isa wain ikotu ikaya poe usa akena rai. Anoo poroti wamo nea oi. ");
INSERT INTO nxl_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Oyo Yesus iahata, “Orori ikaya waron mato osupure rei use uasa te tonsa mai.” ");
INSERT INTO nxl_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Reiso Petrus isaa nau arupai oyo inesa uete rei na ria kaimenne. Uete rei mo, taue tau ika maina-mainaya. Pusire use 153. Ne masike asupu ikaya panesi san rei iae, ma uete rei wakiha tewa. ");
INSERT INTO nxl_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Oyo Yesus iahata, “Mai, na iaita!” Ia sia man ne hanaya na iasei tewa ata ia mo, ia seia. Areimo tau pusima anei ata ia rei mo, ma Upu Yesus. ");
INSERT INTO nxl_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesus ihoka inana poroti oyo irui osima ai. Inana ikae oi oyo irui osima ai oi. ");
INSERT INTO nxl_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Areimo, Yesus iatuhete ruai osi ami ne mampusua nai tonu nea tau iamahaiki honu nea rei. ");
INSERT INTO nxl_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Yesus runa ami ne mampusua aima pusi, oyo Yesus iasei tau Simon Petrus ata, “Simon, Yohanis anai. Ano mo, anom runa Au te tewa renesi me netau reini anoo nnaku?” Petrus iasau ata, “E-e, Upu! Ano anei ata au mo, anoku runaya.” Oyo Yesus iahata, “Munata san rei mo, apiara sio wason oparisaa tau Au rei ia-ia, nooi sani ia mamsaka rompau iapiara ne rompau.” ");
INSERT INTO nxl_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ita Yesus iasei honu ata, “Simon, Yohanis anai. Ano mo, anom runa Au ia-ia te tewa?” Petrus iasau ata, “E-e, Upu! Ano anei ata au mo, anoku runaya.” Ita Yesus iahata, “Munata san rei mo, apiara sio wason oparisaa tau Au rei ia-ia, nooi sani ia mamsaka rompau iapiara ne rompau.” ");
INSERT INTO nxl_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ita Yesus iasei tau Petrus nai osa honu. “Simon, Yohanis anai. Ano mo, anom runa Au te tewa?” Iatinu san rei oyo anoi rekahate pusiki. Tea mo, Yesus iasei tanui nai tonu nea ata anoi runai te tewa. Oyo iasau osi Yesus ata, “Upu, Ano anei pusire. Anei ata au mo, anoku runaya.” Ita Yesus iasau osiki honu ata, “Munata san rei mo, apiara we mansiau wason oparisaa tanuku ia-ia, noo sani ia mamsaka rompau iapiara ne rompau. ");
INSERT INTO nxl_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Atinu mai ia-ia, nanie uasau osia. Oni ano honue mo, ruam ausahu me apia. Oyo aeua sui supan man pusu ruam me maue. Ne tau akore-korea nea mo, mka arata kihem na sio okanihoo hanam oyo ororia roe naniake wan apenea eu roe tanui rei.” ");
INSERT INTO nxl_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesus iasau san rei mo, tau nanie iatuhete ata Petrus, mka sio ohunui sapan, na sapani na Petrus iamuira Anahatana. Iasau san rei suka, oyo iasau osi Petrus ata, “Mai, na pusu Au.” ");
INSERT INTO nxl_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petrus iuni inoo mo, au wan upususo. Au sahoro urue haineke Yesus tau naone arue ai karisaa ami Yahudiu anoma rapeka na ma upu momou oeu arihon otoe Mesir rei. Oyo uasei tau Yesus ata, “Upu, ia seia wain mka iahenia?” ");
INSERT INTO nxl_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petrus inooku oyo iasei tau Yesus rerihoni au ata, “Upu, oyo mka sapan na ia rei?” ");
INSERT INTO nxl_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ne Yesus iasau ata, “Ano pene unum reina na ia rei. Sani we maue mo, Yohanis ruai iamahaiki rotu-tu uhokaku honu te, tewa te, areimo ano mo, pene unum reina tau rei. Ne nene iake mo, ano apusu Au ia-ia man.” ");
INSERT INTO nxl_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Noso Yesus iasau san rei, oyo sio kaka wani wason oparisaa tau Yesus oeu oruni inamatane ria nau rotu-tu Yesus ne mampusua umau rei oatinu ata au mo, mka upanokoku tewa. Ne Yesus iasau tewa ata au mo, mka upanokoku tewa. Ia mo, hasae iasau ata, “Sani we maue na iamahaiki rotu-tu uhokaku honu te, tewa te, areimo, pene unum reina tau rei.” ");
INSERT INTO nxl_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Au rein mo, Yohanis, Yesus ne mampusue wain uruni rerihon sae man waron Yesus iunare nea rei. Au iae sahoro ukanu rai pusire tau surate reini. Au na we netau anei ata sae waron urunre reini mo, pusire manisata. ");
INSERT INTO nxl_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesus iuna panesi asi. Ne sani ukanu pusire mo, surata panesi nai osa. Mka tuniai reini reaiinu pusire tewa.");
INSERT INTO nxl_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teopilus, we neta. Tau we surate mataanoe usima runa pusire waron Yesus iunare runa iatuhetere ");
INSERT INTO nxl_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","rotu-tu Anahatana iapusaai roe noiyaha. Naone Yesus iaisosi ne maisosia wason ininiso na sio oakahaiki. Iaisosiso runa kawasa rerihoni Anahatana Ne Inaha. ");
INSERT INTO nxl_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yesus imatai, oyo tau onona hutu ate iatu-atuhete ruai osi ne maisosia na sio oanei ia-ia ata wain iamahaiki honu. Sio onooi, oyo ianamana rerihoni sapani na Anahatana irime ne mansiau. ");
INSERT INTO nxl_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Taue isa, tau Yesus wain iaiki ikataso, iaisosiso san rei, “Pene oeu oarihoni kota Yerusalem reini. Napa mai kota reini rotu-tu Anahatana irui sae wani itotoe iruiki sani naone uasau osimo rei. ");
INSERT INTO nxl_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohanis isohumo tau tihu na mansiau oanei ata oarihoni no rosau nea. Ne nesie onona ina oyo, Anahatana irui Ne Inaha osimo.” ");
INSERT INTO nxl_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Reiso tau sio wason okata Yesus, oasei tanui, “Upu. Ano nanie ahiti ia Israel tau aia sani masuae, na pene ia rakane isa irime ita nea?” ");
INSERT INTO nxl_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iahata, “Amaku ruai ihete umetene. Ne itapi omi oaneiki tewa. ");
INSERT INTO nxl_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ne mka osupu kawasa. Anahatana Ne Inaha mka ihokai tanumo, oyo osima runa au mai kota Yerusalem reini, sui otoe Yudea pusiki, poe otoe Samaria, rotu-tu tuniai reini nene rurue.” ");
INSERT INTO nxl_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Iasau san rei oyo, Anahatana iapusaai roe noiyaha noi sio mata kahutua. Oyo yahu renetei reiso onooi tewa nea. ");
INSERT INTO nxl_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Sio wason oamrou roe nante asi onooi isaai, oyo sira tau sio ua oausahu papi putia wason oooso mai nusuo. ");
INSERT INTO nxl_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Sio rei oasei, “He, omi rerihoni otoe Galilea. Omi wani ooomo oamrou roe nante, nanie taa hae? Yesus rei, Anahatana mato iapusaai roe noiyaha, mka ihokai mai tuniai reini honu sani sinasi omi onooi isaai rei tea.” ");
INSERT INTO nxl_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Sio maisosia onunso roe kota Yerusalem oarihoni pupue wani nanae Saitun. Pupue rei haineke kilo osa rerihoni Yerusalem. ");
INSERT INTO nxl_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ohoka roe Yerusalem oyo, ohokaso mai numa wani sio oararane tanui, samatoro osaaso roe kamar roe naue. Sio maisosia rei wason: Petrus, Yohanis, Yakobis, Andreas, Pilipus, Tomas, Bartolomeus, Mateos, Alpeus anai wain nanai Yakobis, Yakobis anai wain nanai Yudas, runa Simon. Ia rei ipenei tau sio rakana orime ne niane. ");
INSERT INTO nxl_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Sio oamanouso na oainisi tau Anahatana sui osa sio anoo osa. Oamanouso runa sio pinau umau sani Yesus inai wain nanai Maria. Yesus nea waniu okataso oi. ");
INSERT INTO nxl_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tau sio wason oamanouso, Petrus ihitioi roe, nanie ianamana osiso. Sio rei, sio utun hutu ua. Reiso Petrus iasau san rei, ");
INSERT INTO nxl_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Wea kakau, wea waniu. Masuae sio okanu tau Anahatana ne anamanaya ata Anahatana Ne Inaha iuna aia Daud isima runa pan muie mka sapan runa Yudas. Daud isima, oyo reeu sani iasau rei sirinia. Yudas sahoro iautunu sio oaresi Yesus. ");
INSERT INTO nxl_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudas, ia mo, naone ikata ita. Yesus ihitiki na ikata ita na pusita inana tanei osi Anahatana.” ");
INSERT INTO nxl_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Yudas isupu tuamane nea tau kepen waron sio oruire osiki tau ne kahatene rei. Poe tuamane rei, iamnahui, oyo imatai, tiai wapisai, oyo apui unue rehokai. ");
INSERT INTO nxl_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Sio pusiso sui Yerusalem oatinu tau rei, reiso oaoi tuamane rei tau Akeldama tau sio no sou. Nene nohue Tuama Nasi) ");
INSERT INTO nxl_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Oyo Petrus iasau honu, “Ia sahoro ikanu Sura Kapatau ikanu san rei, ‘Tapi ne numa huie. Pene ia isa iruei tanui.’ Ikanu honu ata, ‘Tapi ia tamene isa ikatiki.’ ");
INSERT INTO nxl_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Reiso kahurae inini ia isa na ikatata na isima ata inoo Yesus wain iamahaiki honu. Ia rei, kahurae naone ikata-kata ita tau ipusu Upuri Yesus. Kahurae ia rei ikatata on Yohanis isohuso na mansiau oanei ata oarihoni no rosau nea rotu-tu Anahatana iapusaa Yesus roe noiyaha rerihoni ita.” ");
INSERT INTO nxl_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Reiso oatinu tau rei, onini sio ua. Sio reimo wason Matias runa Yusup Barsabas, oaoiki tau Yustus oi. ");
INSERT INTO nxl_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Oyo oainisi san rei, “Upu. Ano anei pusiso anoo nea. Autuu na asima ia seia rerihoni sio ua reini sahoro ano aniniki ");
INSERT INTO nxl_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","na ikati Yudas. Ikatiki na iuna ia maisosie na inana tanei osia. Yudas iarihoniki nea. Ieui noi naniai nea.” ");
INSERT INTO nxl_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Oyo okanu uaso nanao tau hatu, samatoro oapataure pan kawei anoe. Apataure, samatoro okainisu kawei rei rotu-tu hatu isa rehokai. Hatu wani sio okanu Matias nanai rehokai, reiso oahata ia osa runa sio maisosia hutusa rahana osa tamena. ");
INSERT INTO nxl_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Tau umete mainae rei sio oaoiki tau Pentakosta oyo, sio wason oparisaa oamanouso tau numa osa. ");
INSERT INTO nxl_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sira tau oatinu tinunue on roe noiyaha. Tinunue rei sani ihu mainae rehoka. Sio wason orueso pan numa rei, oatinui sui numa anoe rei pusiki. ");
INSERT INTO nxl_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Oyo onoo sani usa nene itana waron rahori numa anoe rei. Rahori oyo, rakahuuso sana osa-osa. ");
INSERT INTO nxl_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Anahatana Ne Inaha irui kawasa osi pusiso, oyo oanamana tau sou waron sio ruao oaneire tewa. ");
INSERT INTO nxl_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tau muie reini sio Yahudiu panesi ohokaso on noi niana pusire mai tuniai reini. Sio wason oararane mai kota Yerusalem. Sio rei opusu Anahatana ne maunauna. ");
INSERT INTO nxl_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Sio panesi rei oatinu tinunue rei, oyo oamanouso. Taa oatinu sio wason oparisaa rei oanamana tau sio ruao no sou, osira. ");
INSERT INTO nxl_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Osira nai osa reiso oasau, “Ira oe. Sio wason oanamana san rei, sio pusiso on poe otoe Galilea tea. ");
INSERT INTO nxl_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Sapani na au uatinu sio oanamana tau ruaku we sou? Ne sio rei honu oatinu sio oanamana tau sio ruao no sou. ");
INSERT INTO nxl_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ita reini rerihoni: otoe Partia, otoe Media, otoe Elam, otoe Mesopotamia, otoe Yudea, otoe Kapadokia, otoe Pontus, otoe Asia, ");
INSERT INTO nxl_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","otoe Prigia, otoe Pampilia, otoe Mesir, otoa pan Libia haineke nia Kirene, sio umau wason okata ita rerihoni kota Roma oi. ");
INSERT INTO nxl_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Sio umau wason sio Yahudiu, sio umau tewa ne onusu Yahudi nea. Sio umau honu wason on nau nusa Kreta runa otoe Arab. Au uatinu sio oanamana tau ruaku we sou. Sio rei honu oatinu sio oanamana tau ruao no sou. Sio rei wason osima runa Anahatana iuna sae runa ne kawasa.” ");
INSERT INTO nxl_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Sio osira, reiso oasei tau umau, “Ira oe. Areini mo nene nohue sapan?” ");
INSERT INTO nxl_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ne sio umau honu oaumanso, reiso oahata, “Oninu, reiso omukeso.” ");
INSERT INTO nxl_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Petrus ihitioi roe ikata sio maisosia hutusa rahana osa tamena, oyo ianamana nioi mainae osi sio panesi rei. Iahata, “Omi Yahudiu. Pusimo utumo wani oruemo mai kota Yerusalem. Au nanie uatuhetemo tau rei, reiso oatinu ia-ia. ");
INSERT INTO nxl_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Omi oahata ami reini mo, amukema. Aikee amukema tewa. Ranie mato rehiti-hiti, reiso amukema tewa, tea. ");
INSERT INTO nxl_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ne areini sani masuae ia mamsima runa Anahatana ne anamanaya wain nanai Yoel isima runa pan muie mka sapan. Iasau sani Anahatana iasau san rei, ");
INSERT INTO nxl_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Mka tuniai reini haineke tihoniki, oyo urui-rui We Inaha osi sio pusiso. Reiso moa hehuka mka oaunauso tau we anamanaya, Sio honua onoo masasua rerihoni au, Au mka una sio mtuana oneke oamnii. ");
INSERT INTO nxl_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Osi we manorina iae, sio hanaia runa sio pinau pusiso, mka urui-rui We Inaha osiso tau umetene reinau na oaunauso tau we anamanaya. ");
INSERT INTO nxl_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mka au una sima-simana na sio osira. Mka onoore roe nante. Mka onoore poe tuamane. Mka au una sima-simana tau we kawasa mai tuniai reini na onoo nasi, usa, runa wenue kapitorone. ");
INSERT INTO nxl_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mka ranie repumonoi. Hunane, sio onooi msinae sani nasi, samatoro umete mainae rei rehokai. Tau umetene rei mka uatuheteso tau we kawasa mainae. Mka uapasana sio pusiso. ");
INSERT INTO nxl_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ne ia seia man iainisi na uapuhaiki, mka uapuhaiki sirinia. ");
INSERT INTO nxl_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Omi Israel! Oatinu tau we anamanaya rai! Anahatana iatuhete osi omi ata ihiti Yesus wain on pan nia Nasaret. Oaneiki nea tau Anahatana irui kawasa osiki na iuna sima-simana tau matamo kahutua. ");
INSERT INTO nxl_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Aikee orui Yesus osi sio umau ohunui, oyo omi otapi sio kahatena opakui roe hini wani renienei. Reiso omi ohunui. Ne areini erepusu Anahatana ne kaheute. Ianeiki naone. ");
INSERT INTO nxl_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Omi ohunui oyo, Anahatana iapuhaiki honu rerihoni sio matana. Inanai na pene sinsarai runa sio matana. Ia mka imatai rotu-tu ria supan tewa. ");
INSERT INTO nxl_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Masuae aia Daud isima runa ruai tewa. Ne isima runa pan muie mka Yesus iamahaiki honu. Iasau san rei, ‘Uno-noo Upuku haineke, wain ikataku. Reiso ukaitau tewa. ");
INSERT INTO nxl_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Akataku reiso anoku miri-mirike. Roe hohaku uainaa runaya. Unapa anoku kaie runa tinaiku. ");
INSERT INTO nxl_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Tau sae, ano atapiku tewa na mka umataku rotu-tu ria supan. Atapiku tewa na au wani au manisate onate, tinaiku rekopui. ");
INSERT INTO nxl_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ano atuheteku nea tau arena na uamahaiku rotu-tu ria supan. Anoku mirike mainae tau ano akata runaku.’ ");
INSERT INTO nxl_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Wea kakau, wea waniu. Unina na oanei ia-ia rerihoni upuri wain nanai aia Daud. Daud imatai, okaniki nea. Ia ne kupuro wani asi. ");
INSERT INTO nxl_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Masuae Anahatana itotoe osi Daud ata mka ihiti upui tau natu. Daud wain ia mamsima runa Anahatana ne anamanaya. ");
INSERT INTO nxl_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ianei mka Anahatana iuna sae on iunai tewasi. Reiso iaunutu anoi ata mka Ia Aia wain Anahatana Ihitiki na Iapuheu ne Mansiau imatai, oyo iamahaiki honu. Daud iasau san rei, ‘Anahatana itapiki na ikata sio matana rotu-tu potuina tewa. Itapiki rotu-tu tinain rekopui tewa.’ ");
INSERT INTO nxl_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesus rei, Anahatana iapuhaiki honu. Ami ruama anoo ata wain iamahaiki nea. ");
INSERT INTO nxl_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Anahatana iapusaai roe noiyaha. Wairo isupu muiran manetane rerihoni Anahatana nea, reiso wain iruei hae hanai wanane. Anahatana irui Ne Inaha osiki nea sani masuae itotoe. Oyo Yesus iruiki osima sani omi wani onoo runa oatinu reini. ");
INSERT INTO nxl_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Daud ruai isaa roe noiyaha tewa, reiso ianamana rerihoni ruai tewa. Ne iaunutu anoi rerihoni Yesus iasau san rei, ‘Anahatana iasau osi Upuku. Rue hae hanaku wanane ");
INSERT INTO nxl_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","rotu-tu aheta tau me nisau.’ ");
INSERT INTO nxl_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Reiso omi Israel pusimo utumo kahurae oanei manisate ata Yesus mo, omi opakui roe hini wani renienei, ne Anahatana ihitiki tau Upuri runa Ia Aia wain Anahatana Ihitiki na Iapuheu ne Mansiau nea.” ");
INSERT INTO nxl_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Sio panesi rei oatinu tau rei, oyo oatamisi. Reiso oasei tau Petrus runa sio maisosia tamena. “Mania kakau, mania waniu. Kahurae ami auna sae?” ");
INSERT INTO nxl_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Iahata, “Arihoni mo rosau, oyo ami asohumo na mansiau oanei ata oarihoni no rosau nea. Asohumo sana osa-osa na sio oanei ata anomo osa runa Yesus Kristus. Arihoni mo rosau na Anahatana iuna heure. Oyo asupu Anahatana Ne Inaha wain Anahatana iruiki osia. ");
INSERT INTO nxl_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tau sae, Anahatana itotoe nea. Nanie irui Ne Inaha osia runa mea upu runa sio wason hainau. Itotoe osi sio pusiso sahoro mka ianaha runaso.” ");
INSERT INTO nxl_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petrus iaunauso tau anamanaya panesi. Iaisosiso san rei, “Tapi Anahatana iapuheua na pene iapasanaya tau mka iapasana napisi sio wason no kahatene reini. Iapuheua na amahaia rotu-tu ria supan.” ");
INSERT INTO nxl_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Sio panesi oparisaa tau Petrus ne maunauna rai, reiso sio mampusua osohuso na mansiau oanei ata oarihoni no rosau nea. Tau ranie hatae rei, sio nihu tonu ouna osa runa sio wason oparisaa nea. ");
INSERT INTO nxl_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Sio opusu-pusu sio maisosia no maunauna, oama-amanouso tau osa. Oai poroti tau osa anoo rapeka runa Yesus imatai. Oainisi tau Anahatana tau osa. ");
INSERT INTO nxl_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Anahatana irui kawasa osi sio maisosia na ouna sima-simana sui osa, reiso sio pusiso osira. Okaitau. ");
INSERT INTO nxl_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Sio wason oparisaa rei, oamanouso tau osa sui osa. Osama no apia osi umau. ");
INSERT INTO nxl_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Reiso taue isa, oahen no tuamane isa te? No apia te? Oyo osama kepen waron osupure rei osi sio wason no apia tewa, no muaio tewa. ");
INSERT INTO nxl_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Anoo miri-mirika. Oamanane osama no muaina osi umau. Reiso oamanouso ranie hatae isa reeu mai poua tonu rei oamanouso honu sui osa pan Anahatana ne numa mainisie nusue oai poroti sui no numau tau osa anoo rapeka runa Yesus imatai. ");
INSERT INTO nxl_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Sio oainaa runa Anahatana. Mansia pusiso oahata sio iaka. Ranie hatae isa ereeu mai poua tonu rei Upuri iapuheu sio umau na oamahaiso rotu-tu ria supan. Reiso ouna osa runa sio wason oparisaa nea. ");
INSERT INTO nxl_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Petrus runa Yohanis wason oeuso roe Anahatana ne numa mainisie tau ranie manne pannuhu sio oainisi tau Anahatana. ");
INSERT INTO nxl_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Roe ne numa rei, onoo sio wason orori ia wain italae isa. Ia rei, italae on ia iamrai asi. Ranie hatae isa ereeu mai poua tonu rei oautuei haineke mitanunue wani nanae, “Mitanunu Iake” na iainisi kepen rerihoni sio wason onusu pan Anahatana ne numa mainisie nusue. ");
INSERT INTO nxl_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ia wain italae rei inoo ata Petrus runa Yohanis nanie onusu pan Anahatana ne numa nusue, oyo iainisi san rei, “Samaku tau kepen inate isa ee.” ");
INSERT INTO nxl_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Uaso ono-nooi, oyo Petrus iasau osiki, “Masi anoo mai.” ");
INSERT INTO nxl_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Reiso iariniiso iahata kani nanie orui kepen osiki. ");
INSERT INTO nxl_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Oyo Petrus iasau, “Au we kepen inate isa tewa. Ne nanie urui sae isa honu osia. Tau Yesus Kristus wain on pan nia Nasaret ne kawasa, masi ruam aeu.” ");
INSERT INTO nxl_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Oyo isota hanai wanane, iakahaiki ihitioi roe. Iakahaiki ihitioi roe oyo, mata hun tewa oyo, ia wain italae rei ain atua makaya nea. ");
INSERT INTO nxl_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Oyo isoman roe, samatoro ruai ieui suru ria, suru nau. Oyo inusui pan Anahatana ne numa mainisie ikata sio ua rei. Ieu isoman-soman iainaa runa Anahatana. Iahata, “Anahatana, ano mo, ano iake tunne nai osa. Ano asuiseneku nea rotu-tu ueu iake reini. Ano me kawasa mainae.” ");
INSERT INTO nxl_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Sio pusiso onoo ata wain ieui iainaa runa Anahatana. ");
INSERT INTO nxl_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Sio oationai tau ia iru-ruei iainisi kepen haineke Anahatana ne numa mainisie nene mitanunue wani nanae “Mitanunu Iake.” Reiso osira hun ruao onoo ia sapan nea rei. ");
INSERT INTO nxl_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ia wain naone italae rei wain ikata Petrus runa Yohanis asi, oyo sio pusiso oruma oamanouso mai tanso tau sio wason mai teune wani oaoiki tau “Salomo Ne Teune.” Sio pusiso osira. ");
INSERT INTO nxl_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petrus inooso, oyo iasau osiso san rei, “Omi Israel. Osira tau rei, nanie tahae? Oasumatama, nanie tahae? Oahata ia reini wain ieui tau ami ruama mani kawasa te? Tau ami manisata onate te? ");
INSERT INTO nxl_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Anahatana wain Abraham, Isak, Yakup, runa rea momou rea upu pusiso oainaa runai iuna mainae tau Yesus, ia ne manorine nea. Yesus rei, omi oruiki osi sio wason no kawasa ohunui. Pilatus nanie ialapasiki ne omi openemo. ");
INSERT INTO nxl_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ia rei, ia manisate. Ia manisate onate. Ne omi openemo tanui oyo oainisi na Pilatus ihoka ia mamhunue osimo. ");
INSERT INTO nxl_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Reiso ohunu ia wain iapuhaiso. Ne Anahatana iapuhaiki honu rerihoni sio matana. Ami anoo ata wain iamahaiki honu, reiso asima osimo. ");
INSERT INTO nxl_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Tau ami aparisaa tau Yesus, Yesus iuna ia wain naone italai iamkona nea wain omi onooi runa oationai. Tau ami aparisaa tau Yesus runa ne kawasa, isuisenei. Waini ieui iake nea inoo tau matari. ");
INSERT INTO nxl_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Wea kakau, wea waniu. Uanei nea ata omi runa sio ona Yahudiu ouna san reini mo, tau oanei tewa ata Yesus wain Ia Anahatana Iratiki Iapuheuso. ");
INSERT INTO nxl_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ne Anahatana itapi san rei sani naone sio mamsima runa Anahatana ne anamanaya oasau ata mka pan muie sapan. Oasau ata mka Ia Aia wain Anahatana Ihitiki na Iapuheu ne Mansiau sinsarai. ");
INSERT INTO nxl_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Reiso oarihoni mo rosau. Onunimo mai Anahatana na iuna heure, ");
INSERT INTO nxl_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","na Upuri ihokai tanumo na oahana mo inahau honua. Mka iaisosi Yesus ihokai tanumo honu. Yesus rei, wain Ia Aia wain Anahatana Ihitiki na Iapuheu ne Mansiau. Naone ihitiki nea. ");
INSERT INTO nxl_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kahurae iruei roe noiyaha rotu-tu Anahatana iuna pusire sani naone iuna sio mamsima runa ne anamanaya wason manisata onate oasau. ");
INSERT INTO nxl_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Oarihoni mo rosau. Tau sae, naone Musa iasau osi sio Israel san rei, ‘Upumo Anahatana mka iaisosi ia mamsima runa ne anamanaya isa osimo rerihoni ruamo mo mansiau. Ia rei, sani au sirinia. Saka oatinu tau ne anamanaya pusire waron iasau osimo. ");
INSERT INTO nxl_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Sio sahoro oatinu tau ia tewa, sio rei, sio osa runa Anahatana ne mansiau tewa nea.’ ");
INSERT INTO nxl_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Oarihoni mo rosau. Tewa mo, Samuel runa sio mamsima runa Anahatana ne anamanaya wason ohokaso tau muie pusiso osima na mka sapan pan muie runa napisi reini. ");
INSERT INTO nxl_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Sio mamsimaya oasau ata Anahatana itotoe irui Ia Waini Iratiki Iapuheuso. Osupui nea. Anahatana itotoe osi rea upu. Iruiki osi omi nea. Iasau osi Abraham san rei, ‘Pusu upumu, mka au urui iake osi sio pusiso mai tuniai reini.’ ");
INSERT INTO nxl_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Reiso Anahatana inini Yesus tau ne manorine, oyo iaisosiki ihokai mai tanumo naone na irui iake osimo. Irui iake rei tau iunamo oarihoni mo arena kahatena rai.” ");
INSERT INTO nxl_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petrus runa Yohanis wason oanamana osiso asi, oyo sio imam no ia polisi tau Anahatana ne numa mainisie runa sio Sadukiu umau ohokaso mai tanso. ");
INSERT INTO nxl_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Sio rei oakapuku tau sio ua rei tau sio wason oatuheteso rerihoni Yesus. Osima ata Yesus wain iamahaiki honu rerihoni sio matana. Arei nene nohue sio matana mka oamahaiso honu. ");
INSERT INTO nxl_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Reiso osotaso, samatoro onususo pan pui anoe. Pumono nea reiso osakaso pan pui anoe rotu-tu manahane. ");
INSERT INTO nxl_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ne sio panesi sahoro oatinu no maunauna oparisaa. Reiso sio nihu nima wason oparisaa nea. ");
INSERT INTO nxl_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Hanu roe oyo, sio imam no siniriu, sio matuhete Musa ne maunauna runa sio ona Yahudi nesia rei oamanouso mai kota Yerusalem. ");
INSERT INTO nxl_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Oamanouso runa sio imam no ia mainae wain nanai Hanas runa Kayapas, Yohanis, Aleksander, runa ia mainae rei ne enau umau honu. ");
INSERT INTO nxl_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Oyo orori sio ua rei oamananeso, samatoro oasei tanso san rei, “Ia seia irui kawasa osimo na osuisene ia wain naone italai rei? Ohete ia seia nanai?” ");
INSERT INTO nxl_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Oyo Petrus isupu kawasa rerihoni Anahatana Ne Inaha reiso iasau san rei, “Omi ona Yahudiu. ");
INSERT INTO nxl_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Omi wani oasei tanuma ranie hatae reini tau ami auna iake. Akahai ia wain naone italai rei. Reiso nanie oanei sapani na asuisenei rotu-tu ia iake nea. ");
INSERT INTO nxl_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Reiso kahurae omi runa sio Yahudiu pusimo oanei ata ia rei wain ioo iamananemo mai rei tinain iake nea, tau Yesus Kristus, ia wain on pan nia Nasaret rei, ne kawasa. Yesus reimo, omi orerei roe hini wani reniene. Ne Anahatana iapuhaiki honu. ");
INSERT INTO nxl_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesus rei, sio oanamana tanui tau Anahatana ne anamanaya san rei, ‘Hatu tinipae wani sio mamnana numa openeso tanui ereuna hatu mataanoe. Ereuna numa makae nea.’ ");
INSERT INTO nxl_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yesus ruai man bisa iapuheuta na iamahaita rotu-tu ria supan. Mai tuniai reini pusiki mo, ia isa iae ne kawasa iapuheu na iamahaita tewa. Hasae Yesus sahoro ne kawasa.” ");
INSERT INTO nxl_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Sio onata oatinu ata Petrus runa Yohanis uaso okaitau oanamana tewa. Masike sio mainaya tewa, okaitau tewa. Masike sio isikola tewa, okaitau tewa. Reiso osira. Oyo sio anoo rapeka runa naone uaso okata-kata Yesus. ");
INSERT INTO nxl_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ne sio mka oasau sapan? Ia wain naone italai rei wain ioo iamananeso ikata Petrus runa Yohanis. Ia wain ieui iake nea. ");
INSERT INTO nxl_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Reiso sio onata oaisosi uaso ohokaso onapa pan manahane na sio ruao oanamana osi umau. ");
INSERT INTO nxl_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Oyo oasei tau umau, “Kahurae ita iuna sae runa sio ua rei? Sio pusiso mai kota Yerusalem reini oanei nea ata sio ouna sima-simane rei. Sapan na ita iauhaa? ");
INSERT INTO nxl_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ne mai, ita iputa isauso na pene oanamana osiso ohete Yesus nanai nea na pene sima-simane rei, sio panesi oatinu rerihoniki honu.” ");
INSERT INTO nxl_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Reiso sio oanaha runa uaso na onususo honu, oyo osopo uaso na pene ohete Yesus nanai nea runa pene oatuheteso rerihoni Yesus. ");
INSERT INTO nxl_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ne Petrus runa Yohanis oasau san rei, “Ruamo oarinii. Nene manisate tau Anahatana matai usena wani sapan? Apusu omi mo maunaune te apusu Anahatana ruai ne maunauna? ");
INSERT INTO nxl_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ami arihoni iake tewa. Kahurae asima rerihoni ruama anoo sae runa atinu sapan.” ");
INSERT INTO nxl_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Sio onata rei osupu manaete isa tewa nea na oapasanaso. Reiso oputa osauso honu, oyo ohokaso. Tau sae, sio pusiso mka openeso tau rei. Sio wason oainaa runa Anahatana tau sima-simane rei. ");
INSERT INTO nxl_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ia wain naone italai rei wani ia iake nea tau sima-simane rei, ne musum hutu ate nesi nea. ");
INSERT INTO nxl_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Sio onata ohoka Petrus runa Yohanis arihoni pui anoe, samatoro uaso onunso pan no netau wason oparisaa rei. Hoka pan, oyo osima runa sio imam onata runa sio ona Yahudi nesia rei oasau sapan. ");
INSERT INTO nxl_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Satinu tau no anamanaya rai, oyo oainisi tau Anahatana anoo osa. Oahata, “Mania Upu. Ano ahaye tau nante, runa tuniai reini, runa nuae runa pusire waron. ");
INSERT INTO nxl_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tau Me Inaha, auna mania upu aia Daud, ia rei wain me manorine, aunai iasau san rei, ‘Sio wason oationa Anahatana tewa anoo ranuku-nuku ranaka-naka, nanie tahae? Sio tumatau ouna kaheuta nanie ohunui. Aikee kaheuta rai, raeu tewa, nanie tahae? ");
INSERT INTO nxl_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Sio aiau mai tuniai reini mo osaka nanie oapuoo manahitane. Sio onata oamanouso nanie onesi Upuri runa Ia Aia wain Anahatana Ihitiki na Iapuheu ne Mansiau.’ ");
INSERT INTO nxl_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Poe oyo, ereeu sani iasau rei sirinia. Herodes runa Pontius Pilatus oamanouso mai kota reini nea. Oamanouso runa sio wason oationa Anahatana tewa runa sio Israel oi. Oamanouso nanie otuntana runa me manorine, Yesus wain ia manisate onate rei. Ia rei, ano ahitiki tau Ia Anahatana Iratiki Iapuheuso nea. ");
INSERT INTO nxl_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Oamanouso na ouna pusire waron ano aunuture tau me kawasa runa me kaheute naone na ereeu san rei. ");
INSERT INTO nxl_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Reiso, Upu, muie reini mo, masi atinu sapani na oputa osauma. Akahaima, me manorina rei, na aunauso tau Sou Iake rerihoni Yesus na pene akaitau. ");
INSERT INTO nxl_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Atuheteso rerihoni me kawasa sapan. Asuisene sio kupua, auna sima-simana tau me kawasa runa sima-simana raasiraso runa kawasa rerihoni ahete Yesus nanai. Yesus me manorine wain manisate onate.” ");
INSERT INTO nxl_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Oainisi pusi oyo, naniao mananoune rei erekoka. Oyo Anahatana Ne Inaha irui kawasa osiso na osima runa Anahatana ne maunauna. Okaitau tewa. ");
INSERT INTO nxl_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Sio pusiso wason oparisaa, oarinii sani sio osa, anoo osa. Ia isa iasau tewa ata, “Au we apia rei, osi au ruaku man.” Ne osama no apia pusire osi umau. ");
INSERT INTO nxl_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tau kawasa mainae, sio maisosia osima osiso ata Yesus wain iamahaiki honu. Anahatana irui iake mainae osiso. ");
INSERT INTO nxl_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Waini ia isa tewa rerihoni sio rei wain ne apia tewa, ne muaine tewa. Tau sae, sio pusiso sahoro no tuamana, no numau, taue isa oahenre, oyo orori kepen waron osupure. ");
INSERT INTO nxl_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ororire oyo, oruire osi sio maisosia na osamare osi sio wason no apia tewa, sio wason no muaio tewa. ");
INSERT INTO nxl_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Sani rei oi runa Yusup. Sio maisosia oaoiki tau Barnabas (nene nohue Ia Sahoro Iaunau Sio Wasoni Anoo Mtinte). Ia ne ipane Lewi. Iamrai nau nusa wani nanae Siprus. ");
INSERT INTO nxl_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ia rei, iahen ne tuamane isa, oyo irori kepen waron isupure na iruire osi sio maisosia. Iruire na osamare osi sio wason no apia tewa, sio wason no muaio tewa. ");
INSERT INTO nxl_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ia hanaie isa wain nanai Ananias. Ia runa sahai, wain nanai Safira, uaso, oahen no tuamane otoe isa oi. ");
INSERT INTO nxl_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Kepeni waron isupure rai, inana umau osi ruai, umau honu iruire osi sio maisosia. Iuna san rei, sahai ianeiki oi. ");
INSERT INTO nxl_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Reiso Petrus iasei tanui, “Ananias, sapani na atapi ia aia sakahatene inusu anom pusiki rotu-tu akarota Anahatana Ne Inaha. Tewa mo, auhuni ata anana kepen umau waron asupure tau tuamane rei? ");
INSERT INTO nxl_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tuamane rei, ruam me tuamane on aheniki tewasi? Oyo aheniki ne kepen rai waron asupure rei, ano me kepen tea? Ruam apusu me maue tau kepen rai, iake. Auna kahatene rei nanie tahae? Ano akarota tumata tewa. Ne akarota Anahatana.” ");
INSERT INTO nxl_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias iatinu tau rei, oyo iamnohoi imatai. Reiso sio pusiso wason oatinu tau rei, okaitau hunu ruao. ");
INSERT INTO nxl_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Reiso sio honua umau ohokaso, oyo oopa Ananias ne hatae samatoro ororiki poe manahane. Ororiki poe manahane nanie okaniki. ");
INSERT INTO nxl_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Oyo yam tonu reniku nea oyo, Ananias sahai ihokai. Ianei tewasi ata sahai imatai nea. ");
INSERT INTO nxl_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petrus iasau osiki, “Masi asau, tuamane reimo wani oaheniki, osupu hunonie san rei sirinia?” Iahata, “E-e. Hunonie wani sani ano asau rei.” ");
INSERT INTO nxl_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Iahata, “Sapan na ano runa saham oheu, nanie orea Anahatana Ne Inaha? Atinu! Sio sahoro okani saham wason ohokaso nea. Mka orori ano poe manahane oi.” ");
INSERT INTO nxl_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Mata huni oyo, iamnohoi imatai mai Petrus uai anoe. Sio honua onususo, oyo osupui imatai nea. Reiso ororiki poe manahane samatoro okaniki. Okaniki poe sahai nusui. ");
INSERT INTO nxl_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Reiso sio pusiso wason oparisaa rei, runa sio tamena pusiso wason oatinu tau rei. Oatinu oyo, okaitau hunu ruao. ");
INSERT INTO nxl_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Sio panesi onoo sio maisosia ouna sima-simana waron ratuhete ata no kawasa rerihoni Anahatana panesi runa sima-simana waron raasiraso panesi. Sio pusiso wason oparisaa oamanouso anoo osa pan Salomo Ne Teune roe Anahatana ne numa mainisie. ");
INSERT INTO nxl_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Masike sio tamena okaitau oamanouso runa sio wason oparisaa rei, sio panesi oamuiraso. ");
INSERT INTO nxl_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Sio panesi honu oparisaa tau Yesus, oyo oamanouso runa sio wason sinasi rei. Tau sio panesi rei wason mansia hanaia runa sio pinau oi. ");
INSERT INTO nxl_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Reiso orori sio kupua roe naniao te roe no kinoa na oautueso sui arenau. Oautueso na munata Petrus ieui sui arena rei, onoi resahuso. ");
INSERT INTO nxl_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Mansia panesi ohokaso on noi niana waron haineke Yerusalem. Ohokaso orori sio kupua runa sio wason sakahatena rasuniso. Osuisene sio pusiso. ");
INSERT INTO nxl_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ne sio imam no ia mainae runa ne mansiau oanana. Ne mansiau reimo wason rerihoni sio tikane Sadukiu. ");
INSERT INTO nxl_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Reiso osota sio maisosia. Osotaso oyo, onususo pan pui osi sio kahatena. ");
INSERT INTO nxl_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ne nene pumono pan san rei oyo, Upuri ne maisosie on roe noiyaha isa iheka pui nene mitanunua pusire. Ihekare oyo, iautunu sio maisosia pan manahane. Anahatana ne maisosie on roe noiyaha rei iasau san rei, ");
INSERT INTO nxl_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Masi oeumo roe Anahatana ne numa mainisie, oyo oaunauso rerihoni sapani na Anahatana iapuhaiso rotu-tu ria supan.” ");
INSERT INTO nxl_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Reiso tau kinoke, ohokaso roe Anahatana ne numa rei, oyo oatuhete sani ia maisosie iaisosiso rei. Sio imam no ia mainae runa ne mansiau ohokaso nanie oapisara. Reiso oanaha runa sio siniriu. Areimo sio ona Yahudi nesia pusiso, samatoro oaisosi sio umau oeu onana sio maisosia na oasei tanso. ");
INSERT INTO nxl_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ne ohokaso poe pui, oyo osupu sio maisosia tewa nea. Osupuso tewa, reiso onunso roe sio onata, samatoro osima osiso san rei, ");
INSERT INTO nxl_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Ahokama poe pui, samatoro anoo ata sio okatunepa mitanunua pusire ia-ia nea. Sio mamsakaya wason osaka mitanunue. Ne aheka mitanunue rei oyo, asupu ia osa-sa pan pui anoe tewa nea. Pui rei huie nea.” ");
INSERT INTO nxl_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Sio imam onata runa no ia ona polisi oatinu san rei, oyo oasei pan anoo, “Tutuso tewa. Sio rei, kaneta wason sui supa, omi?” Anoo rauponu runa mka sapan. ");
INSERT INTO nxl_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Oyo ia isa ihokai iasau san rei, “Masi atinu. Sio rei, omi onususo pan pui, ne wasoro oatuhete roe Anahatana ne numa mainisie nea.” ");
INSERT INTO nxl_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Reiso ia ona polisi rei runa ne mansiau oeu onana sio maisosia rei. Ne otentene tanso tewa. Tewa mo, okaitau sio panesi roe rei. Mka sio rei orauso tau hatu nanie ohunuso. ");
INSERT INTO nxl_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Sio orori sio maisosia poe sio siniriu, oyo oaisosiso oo oamananeso. Oo oamananeso oyo, sio imam no ia mainae iaunauso san rei, ");
INSERT INTO nxl_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ami asopo na pene oatuhete rerihoni ia rei nea. Ne oatuhete sui Yerusalem pusiki. Samatoro nanie oapasanama oasau ata ami ahunui.” ");
INSERT INTO nxl_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Oyo Petrus runa sio maisosia tamena oasau san rei, “Anahatana mo, kahurae apusu ia naone. Apusu tumata tewa. ");
INSERT INTO nxl_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Anahatana wain rea upu oainaa runai iapuhai Yesus honu. Yesus rei, omi ohunui tau opakui roe hini wani reniene. ");
INSERT INTO nxl_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ia rei, Anahatana irui muiran manetane runa kawasa mainae osiki nea na iuna Natu runa Ia wain Iapuheu ne Mansiau. Iuna san rei na sio Israel oarihoni no rosau na Anahatana isiru 