﻿USE sofia;
DROP TABLE IF EXISTS sofia.nww_vpl;
CREATE TABLE nww_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nww_vpl WRITE;
INSERT INTO nww_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Agha ndo mahina gha lukolo lwa Yesu Kilisto ywa kibheleko kya Daudi, ywa kibheleko kya Abulahamu. ");
INSERT INTO nww_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abulahamu kakinlela Isaka, na Isaka kakinlela Yakobu, na Yakobu kakinlela Yuda na alongo bhake. ");
INSERT INTO nww_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda kakinlela Pelesi papamu na Zela, bhene mama ywabhe kakibhegha Tamali, na Pelisi kakinlela Esiloni, na Esiloni kakinlela Alamu, ");
INSERT INTO nww_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alamu kakinlela Aminadabu, na Aminadabu kakinlela Nashoni, na Nashoni kakinlela Salimoni, ");
INSERT INTO nww_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoni kakinlela Boasi, na mama ghwake Boasi kakibhegha Lahabu, Boasi kakibhegha tate ghwake Obedi na mama ghwake Obedi kakibhegha Luti, na Obedi kakinlela Yese. ");
INSERT INTO nww_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese kakinlela Mutwa Daudi. Daudi kakinlela Selemani, kwa yula nhumbu ywa Ulia ");
INSERT INTO nww_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Selemani kakinlela Lehoboamu, na Lehoboamu kakinlela Abiya, na Abiya kakinlela Asa. ");
INSERT INTO nww_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa kakinlela Yehoshafati, na Yohoshafati kakinlela Yolamu, na Yolamu kakinlela Usia. ");
INSERT INTO nww_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia kakinlela Yotamu, na Yotamu kakinlela Ahasi, na Ahasi kakinlela Hesekia. ");
INSERT INTO nww_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia kakinlela Manase, na Manase kakinlela Amoni, na Amoni kakinlela Yosia. ");
INSERT INTO nww_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia kakinlela Yekonia na alongo bhake, Mumanjubha gha kuhamihwa kughenda ku Babeli. ");
INSERT INTO nww_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mbole ya Akaayahudi kuhamihwa kughenda ku Babeli, Yekonia kakinlela Shealitieli, na Shealitieli kakinlela Selubabeli. ");
INSERT INTO nww_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Salubabeli kakinlela Abihudi, na Abihudi kakinlela Eliakimu na Eliakimu kakinlela Asoli. ");
INSERT INTO nww_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoli kakinlela Sadoki, na Sadoki kakinlela Akimo, na Akimo kakinlela Elihudi. ");
INSERT INTO nww_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elihudi kakinlela Eliasali, na Eliasali kakinlela Matani, na Matani kakinlela Yakobu, ");
INSERT INTO nww_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","naywo Yakobu kakinlela Yosefu ywakabheghite nngwana ghwa Malia mama ghwake Yesu, na Yesu ndo ywakakemwa Kilisto. ");
INSERT INTO nww_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Habhu, hibheleko hyoha kutandila Abulahamu mbaka Daudi kukibhegha hibheleko kumi na ncheche, kangi kutandila Daudi mbaka kihamo kila kya ku Babeli kukibhegha hibheleko hingi kumi na ncheche, na kangi kutandila kihamo kya ku Baneli mbaka Kilisto kukibhegha hibheleko hingi kumi na ncheche. ");
INSERT INTO nww_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kubhelekwa kwa Yesu Kilisto kukibhegha naha, Malia mama ywake Yesu kakitalikila kuhetwa na Yosefu, peni kukali na kughonja papamu, Malia kakibhonekana kabhegha na ndumbu kwa makakala gha Nhuki ywa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Naywo Yosefu nngwana ghwake, kiyaha kakibhegha mundu ywa maha, kakipala ng'obhe kumpegha honi Maliamu pakindabhanji, ndo kakilamula kunleka kwa mbwepo. ");
INSERT INTO nww_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Basi, pakabheghite mu kuwacha kutenda nnando aghwo, lihoka ywa Chapanga kakimbwitukila mumaloto na kakinng'ombela, “Yosefu mwana ywa Daudi, ghukotoke kuyoghopa kuntola Malia kabheghe nhumbu ghwako, kiyaha mata ghakamilite ndo kwa makakala gha Nhuki ywa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Katapapa mwana nnume, na ghwenga ghwanpegha mwana aywo lihina lyake Yesu, kiyaha mwene ndo kataalopoha bhandu kubhuka mu ulemwa ghwabhe.” ");
INSERT INTO nww_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Basi, agha ghoha ghabwitukila ngati ghatwihilike ghala ghakalongelite Bambo kwa njila ya mbuye ywa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Nnole, “Kamwalilinda katakamula ndumbo, naywo katapapa mwana nnume, Mwana aywo katakemwa lihina lyake Emanueli.” Fwambulo yake, “Chapanga papamu na twenga.” ");
INSERT INTO nww_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Naywo Yosefu pakayumukite mung'ono, kakitenda handa lihoka ywa Bambo pakanng'ombilite, kakintola nhumbu ywake. ");
INSERT INTO nww_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Peni kanatyanga naywo ng'obhe mbaka Malia pakapapite mwana nnume. Naywo Yosefu kakinkema yula mwana lihina lyake Yesu. ");
INSERT INTO nww_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu kakibhelekwa kumbwani ya Betelehemu, mu nkoa ghwa Yudea, manjubha agho Helode kakibhegha mutwa. Kamu, mbole ya kubhelekwa Yesu, bhanautendehi bha kumanya ndondwa kuhuma mbande ya ngeha bhakehika ku Yelusalemu ");
INSERT INTO nww_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","bhakikonya, “Kabhengha kwoki aywo mwana ywakabhelekitwe, ywakapala kubhegha Mutwa ywa Akaayahudi? Tuyibhona ndondwa yake payibwitukila kungeha, na twenga tuhika kumtundamila.” ");
INSERT INTO nww_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mutwa Helode pakayihwite nnando aghu kakibhaghaya, ywombe papamo na bhandu boha bhubho bha ku Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Basi kakiakema papamu mandundame akulu bhoha na ahunda bha Malaghilo gha Musa, kakiakonya “Kilisto katabhelekwa kwoki?” ");
INSERT INTO nww_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bhombe bhakinng'ombela, “Katabhelekwa kumbwani ya Betelehemu kunkoa ghwa Yudea,” Handa pakalembite mbuye ywa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Naghwenga Bethelehemu munnima ghwa Yudea, Ghwenga ghunndoko ng'obhe nkati ya hitami ihwadali hya ku Yudea; Mana, kwa ghwenga katabwituka kilongohi ywakapala kualongoha bhandu bhangu Akaaisilaeli.” ");
INSERT INTO nww_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Apo ndo Helode kakiakema pambwegha abho atendehi bha kumanya ndondwa, kakiakonya bhammanyihe nndaluko ghwa tela ghuubhonekanite yila ndondwa. ");
INSERT INTO nww_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mbole kakibhalaghila aghende Betelehemu pakiaghombela. “Nng'ende mukahingukihe maha mihalo ya mwana aywo. Mbole ya kummona mumuyihile mihalo yake, ngati na nenga ng'ende kuntundamila.” ");
INSERT INTO nww_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mbole ya kunnyihwa Mutwa, abho atendehi bha kumanya ndondwa bhakibhuka, na kamu yila ndondwa bhaayibhonite mbande ya ngeha yikialongoha, nabhombe bhakiyitughila mbaka payiyimite pakabheghite mwana. ");
INSERT INTO nww_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Paayibhonite yila ndondwa yiyima bhakiyelelwa na kulumbilila kwa uyelelo. ");
INSERT INTO nww_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Paayingilite unyumba bhakimmona mwana papamu na Malia mama ghwake, bhakichutama na bhakintundamila. Ndo bhakihughula hupo hyabhe, bhakinpegha mahabha na ubano na ntela ghwa bhana. ");
INSERT INTO nww_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mbole Chapanga kakiakinya mululoto bhakotoke kummuyila Helode, ndo bhakibhuya ukaya kwabhe kwa njila yingi. ");
INSERT INTO nww_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mbole ya bhala ahenja kubhuka, lihoka ywa Chapanga kakinbwitukila Yosefu mu maloto, na kunng'ombela, “Ghuyumuke na ghuntole mwana papamu na mama ghwake na mmutukile ku Misili. Ntame akwo mbaka panukughombela, kiyaha Helode kangupala kunkoma mwana ayu.” ");
INSERT INTO nww_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Habhu, Yosefu kakibhuka pakilo kakintola mwana papamu na mama ghwake, na bhakighenda ku Misili. ");
INSERT INTO nww_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bhakitama akwo mbaka pakahweghite Helode. Nnando aghu ghukibwituka ngati litwihilike lilagho lyakalongilite Bambo kwa ngulu ya mbuye, pakalongela, “Nikinkema mwana ghwangu kuhuma ku Misili.” ");
INSERT INTO nww_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Helode pakang'amulite kukita bhala atendehi bha kumanya ndondwa bhantindila kya luhunga, kakikalala muno. Kakikwilikiha bhana alumi bhoha mu kitami kya Betelehemu na mumbwegha mbwegha yake akomwe, kutandila bhala bhana bhoha bhaabheghite na ngungwa mbili mbaka hing'enya. Kakitenda habhu kubhukana na manjubha kupita kutandila pakakonganite na bhala atendehi bha kumanya ndondwa. ");
INSERT INTO nww_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ndo paghakitwihilikite malagho ghala ghaakambukitwe na mbuye Yelemia ");
INSERT INTO nww_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Lilobhe liyihwanika akwo Lama, Kililo na makukuliko matangalo. Laheli kangualilila bhana bhake; na kalema kukamulwa mabhoko, kiyaha bhoha bhahwegha.” ");
INSERT INTO nww_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mbole ya kuhwegha Helode, lihoka ywa Chapanga kakinbwitukila Yosefu mumaloto akwo Misili, ");
INSERT INTO nww_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","kakinng'ombela, “Ghuyumuke, ghuntole mwana papamu na mama ywake, ghubhuye kangi ku Isilaeli, kiyaha bhala bhaapalite kunkoma mwana ahwegha kala.” ");
INSERT INTO nww_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Basi, Yosefu kakiyimuka, kakintola mwana papamu na mama ywake, bhakibhuya mu nnima ghwa Isilaeli. ");
INSERT INTO nww_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Peni Yosefu kakiyoghopa kughenda akwo pakayihwite kukita Alikelao kaghuhala utabhala ghwa tate ghwake Helode. Mbole ya kukinywa na lihoka ywa Chapanga mu maloto, bhakighenda mbande ya ku Galilaya, ");
INSERT INTO nww_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","na kakighenda kutama kukitami kiikemitwe Nasaleti. Habhu ndo ghakitwihilika malagho ghaakambukitwe na mabuye, “Katakemwa mundu ywa Kunasaleti.” ");
INSERT INTO nww_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mumanjubha ghala Yohane yunakubatisa kakihika pakalandamiha mu kibhala kya Yudea, na kulongela, ");
INSERT INTO nww_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Nneke ulemwa ghwenu, kiyaha ghubhutwa ghwa kunane kwa chapanga ghuheghelela.” ");
INSERT INTO nww_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ayu ndo Yohane ywene ndo mbuye Isaya kakilondola ya kya ywombe pakalongela, “Lilobhe la mundu lingukema kukibhala, ‘Munntendekehele Bambo njila yake, nng'ololehe ndyangilo yake.’” ");
INSERT INTO nww_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohane kakihwala mapinda ghaatendekehitwe kwa mayuni gha nnyama ywaakemitwe ngamia, na nkungi ghwa liyula mu kibhuno kyake. Hilyo hyaki hikibhegha mapalala na bhuchi. ");
INSERT INTO nww_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bhandu bhakinng'endela kuhuma ku Yelusalemu, na mbande hyoha ya Yudea na mumilima ya mbwegha mbwegha ya lukemba lwa Yoludani. ");
INSERT INTO nww_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nabho bhakilipetula ulemwa ghwabhe, na kakiabatisa mulukemba lwa Yoludani. ");
INSERT INTO nww_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Peni pakaabhonite Akaafalisayo na Akasadukayo bhangung'endela ngati abatiswe, kakiaghombela, “Mwenga bhandu ahakata handa liyoka. Ndo ghani ywakaakinyite kukihepetuka kiyaghabhu kiipala kuhika? ");
INSERT INTO nww_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Basi, mulilahe kwa mandendelo kukita mulipetula, ");
INSERT INTO nww_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","na kangi nkotoke kuhwacha na kulongela, ‘Tati ywetu Abulahamu.’ Ninguaghombela hoto, Chapanga kaahotola kutendekeha kibheleko kya Abulahamu kuhuma mu malibho agha. ");
INSERT INTO nww_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hata naha, libhaghu libhikwa kala mu ngigha hya nkongo. Nkongo ghwohele ghwangali kupambika mapambiko gha maha, ghwaadumulwa na kutagwa mu mwoto. ");
INSERT INTO nww_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nenga nunguabatisa kwa machi kubhoneha kukita mulipetula. Peni ywakapala kuhika mbole ya nenga kabhegha na makakala kupitingana nenga, na yingunnogha ng'obhe hata kuyegha hilatu hyake. Mwene kataabatisa kwa Nhuki ywa Chapanga na kwa mwoto. ");
INSERT INTO nww_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ywombe kakamula mumabhoko ghake kipalo kya kupetela mbunje hyake, naywombe katakilima muno kibhanja kya kukubhatila, ngati kakungane ngano hyaki mu luhanja, na mayeyele kaghayoche kwa mwoto ghwangahimika.” ");
INSERT INTO nww_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mumanjubha agho Yesu kakihuma ku Galilaya na kakihika mu lukemba lwa Yoludani, ngati kabatiswe na Yohane. ");
INSERT INTO nww_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Peni Yohane kakiyigha kunkanikiha pakanng'ombela, “Nenga ningupala kubatiswa na ghwenga, na ghwenga ghunguhika kubatiswa na nenga!” ");
INSERT INTO nww_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Peni Yesu kakinnyanga, “Ghuyitikile yibheghe habhu kwa hinu. Mana habhu yingutunogha kutenda ghakaghapala Chapanga.” Habhu Yohane kakinnyitikila. ");
INSERT INTO nww_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Naywo Yesu pakabatiswite kala, kamu pakahumite mu machi, pindulu kunane kwa Chapanga kukihughuka, kakimmona Nhuki ywa Chapanga pakihuluka handa ngunda na kutula unani mwake. ");
INSERT INTO nww_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mbole lilobhe kuhuma kunane kwa Chapanga likilongela, “Ayu ndo Mwana ywangu mpalo, yunyelelwa naywo.” ");
INSERT INTO nww_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mbole Yesu kakilongohwa na Nhuki ywa Chapanga mbaka kukibhala ngati kakang'ehwe na Nchipila. ");
INSERT INTO nww_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kakilikunga manjubha mbinda mabhoko ncheche pamuhi na pakilo, kuuhiko yikimmina muno njala. ");
INSERT INTO nww_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mbole, Nchipila kakinhikila na kunng'ombela, “Handa ghwenga ndo Mwana ywa Chapanga, ghughakwilikihe maganga agha ghabheghe mangate.” ");
INSERT INTO nww_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Peni Yesu kakinnyanga, “Yityekwa mu Malembo gha Chapanga, ‘Mundu katalama ng'obhe kwa kulyegha lingate ghweka, ngati kwa kila lilagho liikambukwa kwa nngulo ya Chapanga.’ ” ");
INSERT INTO nww_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mbole Nchipila kakintola Yesu mbaka ku Yelusalemu, Kitami king'anyimo kakimmika kunane kukinembanemba kya Nyumba ya Chapanga, ");
INSERT INTO nww_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","na kakinng'ombela, “Handa ghwenga Mwana ywa Chapanga, ghuliponehe pahi, kiyaha yityekwa mumalembo, ‘Chapanga kataakwilikiha Mahoka bhake, na bhombe bhaakukingama mu mabhoko ghabhe, ghukotoke kuponekela mu liganga.’ ” ");
INSERT INTO nww_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu kakinnyanga, “Malembo mang'anyimo ghangulongela, ‘Ghukotoke kunng'eha Bambo Chapanga ghwako.’ ” ");
INSERT INTO nww_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Mbole Nchipila kakintola Yesu mbaka kukinemba kya kitumbi kitandamaho na kakinnaha ghubhutwa ghwoha ghwa nnima na unyanyi ghwake. ");
INSERT INTO nww_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kakinng'ombela Yesu, “Agha ghoha ndaghupegha handa ghwanjutamila mayughwa na kundundamila.” ");
INSERT INTO nww_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Peni Yesu kakinnyanga, “Ghubhuke muulongolo ghwangu, ghwenga Nchipila. Kiyaha malembo ghangulongela, ‘Ghuntundamile Bambo Chapanga ghwako, na ghuntumikile ywombe ghweka.’ ” ");
INSERT INTO nww_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Basi, Nchipila kakinneka, nabho mahoka bha Chapanga bhakihika kuntumikila. ");
INSERT INTO nww_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu pakayihwite kukita Yohane Yunakubatisa kahwindwa ku kibhopo, ywombe kakighenda akwo Galilaya. ");
INSERT INTO nww_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kakibhuka Nasaleti, kakighenda kutama ku Kapelinaumu kitami kiibheghiti mbwegha ya lihibha lya Galilaya, mu mbakilo ya kitami kya Sabuloni na Nafutali. ");
INSERT INTO nww_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ghakitendekwa habhu ngati lilagho lyakalongelite mbuye Isaya litwihilike kukita, ");
INSERT INTO nww_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Milima ya Sabuloni na ghwa Naftali, milima yiibheghite mu mbwegha ya njila yiighenda kulihibha kumwambo ya lukemba Yolodani, Galilaya, nnima ya bhandu bha milima yingi. ");
INSERT INTO nww_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bhandu bhala bhaatamite mulubhindu Bhalubhona lubhwelu lukulu. Nabho bhaatamiteghe mu nnima ghwa lubhindu na bhwaghalili ghwa kuhwegha lubhwelo lubhang'aliha.” ");
INSERT INTO nww_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kutandila apo, Yesu kakiyanda kulandamiha pakalongela, “Mulipetule, kiyaha Ghubhutwa ghwa kunane kwa Chapanga ghuheghelela.” ");
INSERT INTO nww_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu pakabheghite mukutyanga mumbwegha ya lihibha lya Galilaya, kakiabhona alongo abhili aghomeha homba, Simoni ywakakemwa Petili na Andelea ywakabheghite nnongo ghwake, paaghomeha homba kwa njaho. ");
INSERT INTO nww_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ndo Yesu kakiaghombela, “Mundughile, na nenga ndabhatenda munyeghele bhandu handa aghomeha pabhayegha homba mulubhagha lwabhe.” ");
INSERT INTO nww_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kamu bhakihileka njaho hyabhe na bhakintughila. ");
INSERT INTO nww_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Pabhaghendite paulogolo kya mandina, kakiabhona akalongo bhangi abhili, Yakobu na Yohane, bhana wa Sebedayo. Abha bhakibhegha nkati ya bhwato papamo na tati ghwabhe Sebedayo, paatandambuha njaho hghabhe. Ndo Yesu kakiakema, ");
INSERT INTO nww_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","kamu bhakighuleka bhwato papamu na tate ghwabhe, bhakintughila Yesu. ");
INSERT INTO nww_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu kakighenda mu hitami hyoha hya ku Galilaya, kakihunda mu hitutuhi ya kukonganikila Akaayahudi na kulandamiha Nhalo ghwa Maha ya kya ghubhutwa ghwa Chapanga, kakilamiha mihehemela nhanganganiko na matamwa ghaabheghite nagho bhandu. ");
INSERT INTO nww_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mihalo yake yikikwila mbande hyoha hya ku Silia, na atamwa bhoha bhaabheghite na matamwa nhanganganiko, na bhala bhaabheghite na himbamanda nhanganganiko, bhaakwelitwe na mandilu, bhaabheghite na kihilika na alelebhaho, bhakigheghwa kwa Yesu, naywo kakialamiha bhoha. ");
INSERT INTO nww_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Himati hitangalo hya bhandu bhakintughila, kuhuma ku Galilaya na Dekapoli na Yelusalemu na Yudea na kumwambo ya lukemba Yoludani. ");
INSERT INTO nww_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu pakahibhonite himati hya bhandu, kakikwela kukitumbi na kakitama, na ahundwa bhake bhaking'endela, ");
INSERT INTO nww_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","na ywombe kakiyanda kuahunda. ");
INSERT INTO nww_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Bhanonelwa bhoha bhaamanya kukita bhangumpala muno Chapanga mukutama kwabhe, kiyaha Ghubhutwa ghwa kunane kwa Chapanga ndo ghwabhe. ");
INSERT INTO nww_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bhanonelwa bhaakukulika, kiyaha bhaayonjokehwa mwoyo. ");
INSERT INTO nww_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bhanonelwa bhaabheghite apole kiyaha bhaapeghwa nnima ghwakaalaghite Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bhanonelwa bhaabhegha na njala na kilyakalyaka kya kutenda kila kyakakipala Chapanga kiyaha bhombe bhaayukutihwa. ");
INSERT INTO nww_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bhanonelwa bhaabheghite na lipyanda kiyaha bhaamokola lipyanda. ");
INSERT INTO nww_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bhanonelwa bhaabhegha na mwoyo ghwa maha, kiyaha bhombe bhatammona Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bhanonelwa bhala bhaalinganiha malobhe bhandu, mana bhaakemwa bhana bha Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bhanonelwa bhaapungwa kwa kutenda ghala ghakaghapala chapanga, kiyaha Ghubhutwa ghwa Kunani kwa Chapanga ndo ghwabhe.” ");
INSERT INTO nww_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Yesu kakighendelela kulongela, “Maanonelwa mwenga pala bhandu paabhakokela na kuakambukila uhakata ghwohele kwakya nenga. ");
INSERT INTO nww_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nnyelelwe kwa hilulu, kiyaha lilumbo lyenu ndo likulu kunane kwa Chapanga. Mana ndo ubhwabhu abhu ndo bhakiapamanda ambuye bha Chapanga bhaabheghite pakali ya mwenga.” ");
INSERT INTO nww_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mwenga ndo handa mwinyu ghwa nnima. Peni handa mwinyu ghwahobheha unogho ghwake ghwabhuyihwa bhuli kangi unogho ghwake? Ghungunogha kangi ng'obhe kwa kyohele, ngati ghwaataghwa panje ghulibhatwe na bhandu.” ");
INSERT INTO nww_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mwenga ndo lubhwelu lwa nnima. Kitami kiichengwite mu kitumbi kinguhotola ng'obhe kuhihika. ");
INSERT INTO nww_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ebu bhandu bhanguyakiha ng'obhe koloboi na kuyigubika na kipumbulu, ngati bhanguyibhika mu kindangabhala, ngati yibhang'alihe bhandu bhoha bhaabheghite unyumba. ");
INSERT INTO nww_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ubhwabhu abhu lubhwelu lwenu lung'alihe mu ulongolo ghwa bhandu, ngati amokole kughabhona mandendelo ghenu gha maha na bhantike Tate ghwenu ywakabheghite kunane.” ");
INSERT INTO nww_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nkotoke kuhwacha kukita hika kughabhuha malaghilo gha Musa na mahundo gha ambuye, hika ng'obhe kughabhuha ngati kughatengeleha. ");
INSERT INTO nww_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kulyaghila nunguaghombela, mbaka nnima na kunane payipala kupita, peni kahone hata kipalamande kichoko kya malaghilo gha Musa kiipala kubhuhwa, mbaka ghoha ghatwihilike. ");
INSERT INTO nww_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Basi, ywohele ywakakiluka yimu mu ngwiliho njoko kupitingana kwa hyoha, na kuahunda bhandu bhakatende habhu, kaabhegha nndokwa mu Ghubhutwa ghwa kunane kwa Chapanga, peni mundu ywakaghatenda malaghilo na kuahunda ayake, aywo kaabhegha nkulu mu Ghubhutwa ghwa kunane kwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ndo mana nunguaghombela yinguakwiliha mughayitikile Malaghilo gha Chapanga kwa kuchweha gumaha muno kupitingana ghula ghwa ahunda bha Malaghilo na Akaafalisayo. Hela bhubho maayingila ng'obhe mu Ghubhutwa ghwa kunane kwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yesu kakighendelela kulongela, “Nnyihwa kukita bhandu bha makachu paaghombelwa, ‘Ghukotoke kukoma mundu, na mundu ywohele ywakakoma mundu katanoghwa katoswe.’ ");
INSERT INTO nww_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Peni nenga ninguaghombela kukita, mundu ywohele ywakannyaghabhalila nnongo ghwake, katanoghwa katoswe. Ywakannyuyuha nnongo ghwake katayeghwa ku libalasa. Na ywohela ywakanng'ombela nnongo ghwake ‘Ghwenga mmughabhugha ghukotolwe.’ Katanoghwa toso ya kutaghwa mu mwoto ghwa kumambe. ");
INSERT INTO nww_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Basi, paghuyegha matulo ghako ku likuta na kunu paghukulungwa kukita nnongo ghwako kabhegha na nnando na ghwenga, ");
INSERT INTO nww_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ghuleke matulo ghako apo paulongolo ghwa likuta, ghughende huti ghukalingane malobhe na nnongo ghwako, mbole ghubhuye na ghutule matulo ghako.” ");
INSERT INTO nww_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kangi kakilonela, “Ghulingane malobhe nkokela ghwako kya kuyumbatika paghubhegha naywo munjila kughenda kulibalasa, ngati nkokela ghwako kakotoke kukukamuha mu mabhoko gha nlamula, naywo nlamula katakukamuha mumabhoko gha machonda, na ghwenga ghwaabhopwa mu kibhopo. ");
INSERT INTO nww_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kulyaghila nungukughombela, ghwaabhuka kata amwo, mbaka paghukamuha ligwala ya uhiko.” ");
INSERT INTO nww_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yesu kakighendelela kulongela, “Nnyihwa kukita bhandu bhakighombelwa, ‘Nkotoke kubhegha atyahe.’ ");
INSERT INTO nww_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Peni nenga nunguaghombela kukita, mundu ywohele ywakannolekeha nndala kwa uhongo ghwa kutyala naywo, aywo katyala naywo kala mumwoyo ghwake. ");
INSERT INTO nww_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Liho lyako lya kibhoko kya nnilo palighutenda ghutende uhokelo, mbaha ghulikolopole, kuliko mmili ghwoha kutaghwa mu mwoto ghwa kumambe. ");
INSERT INTO nww_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Handa kibhoko kyako kya nnilo pakighutenda ghutende uhokelo, mbaha ghukidumule, kuliko mmili ghwako ghwoha kutaghwa mu mwoto ghwa kumambe.” ");
INSERT INTO nww_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Bhubho yikikambukwa kukita, ‘Mundu ywohele ywakanneka nhumbu ghwake yingukwiliha kanpeghe lihamba lya kulekana.’ ");
INSERT INTO nww_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Peni nenga nunguaghombela, mundu kangunoghwa ng'obhe kunneka nhumbu ywake kwa uhokelo ghwohele, pangi kwa kutenda utyahe, na mundu ywakanneka nhumbu ghwake kwa uhokelo ghwohele ghula, kanguntenda kabheghe ntyahe. Na yula ywakantolela nndala ywakalekitwe, kangutenda utyahe.” ");
INSERT INTO nww_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kangi nnyihwa kukita bhandu bha makachu bhakighombelwa, ‘Ghukotoke kulaghila kulapa kwa uhwangi, ngati ghutwihilihe kilagho kyako kwa kighunnapilite Bambo.’ ");
INSERT INTO nww_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Peni nenga nunguaghombela, nkotoke kulapa yomoo, hangi kwa kunane kwa Chapanga, kiyaha ndo kiteho kya utabhala kya Chapanga, ");
INSERT INTO nww_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","hangi nkotoke kuulapila nnima, kiyaha nnima ndo pahala pamwene pakuyeghemela maghulu ghake, ebu kwa lihina lya Yelusalemu, kiyaha ndo kitami kya Mutwa nkulu. ");
INSERT INTO nww_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nkotoke kulapa kwa mitwe yenu, kiyaha ghwahotola ng'obhe kutenda luhwili lumu lubheghe lwambulete ebu lupili. ");
INSERT INTO nww_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Paghulongela ‘Ena’ Yibheghe ‘Ena’ Na paghulongela ‘Ng'obhe’ Yibheghe ‘Ng'obhe’ Kiyaha ghohele kuchweha kwa agha ghanguhuma kwa yula nhokelo.” ");
INSERT INTO nww_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nnyihwa kukita yikikambukwa, ‘Mundu pakalikuchumbula liho lyako na ghwenga ghunkuchumbule, na mundu pakaghutupula lino lyako na ghwenga ghuntupule lino lyake.’ ");
INSERT INTO nww_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Peni nenga nunguaghombela, nkotoke kummuyihila kibhuyiho kwa mundu nhakata. Mundu pakakubhakula kulikanja lyako lya nnilo, ghumghalambuhile na lingi. ");
INSERT INTO nww_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Handa mundu ywakapala kukukokela ngati katole lighwanda lyako, ghumpeghe na likoti bhubho. ");
INSERT INTO nww_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mundu pakaghulemelela ghupape nhigho ghwake mwanja ghwa maili yimu, ghuupape maili mbili. ");
INSERT INTO nww_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ghunpeghe ywakakuyupa, hangi ghukotoke kumdumbila kihogho ywakapala kukuyahika kilibhi.” ");
INSERT INTO nww_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nnyihwa kukita yikikambukwa, ‘Ghunpale ghanja ywako na ghunkalale myanja ywako.’ ");
INSERT INTO nww_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Peni nenga nunguaghombela, muapale amyanja bhenu na mubhayupile bhala bhaabhakalalila, ");
INSERT INTO nww_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ngati mmokole kubhegha bhana bha Tate ywenu ywakabheghite kunane. Kiyaha ywombe kanguang'aliha luchubha lwake bhandu ahokela na bhandu bha maha, naywo kanguakomela hula bhandu bhanakutenda ghanakunnoghela Chapanga na bhangali kutenda ghangali kunnoghela Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Pamuapala bhala bhanakuapala ghweka, maapata hupo yoki? Bhuli asumula sumu bhangutenda ng'obhe habhu? ");
INSERT INTO nww_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na handa munguatendela gha maha alongo bhenu ghweka, Bhuli mungutenda kyoki kupitingana kwa bhangi? Hata bhandu bhangali kummanya Chapanga bhangutenda ubhwabhu abhu. ");
INSERT INTO nww_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kya habhu mwenga mmeghe atwihiliko handa Tate ywenu ywa kunane pakabhegha ntwihiliko.” ");
INSERT INTO nww_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mulindakile, nkotoke kutenda milando ya maha muulongolo ghwa bhandu ngati bhabhatikile, mana pantenda handa habhu, mungumokola ng'obhe hupo kwa Tate ywenu ywakabheghite kunane.” ");
INSERT INTO nww_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Basi, pamuapegha hilibhi kapukwa, nkotoke kulandamiha handa paatenda afyangu mu nyumba hya kukongamila Akaayahudi na mu hindandabhanji, ngati atikilwe na bhandu. Kulyaghila nunguaghombela akingama kala hupo yabhe. ");
INSERT INTO nww_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Peni mwenga pamuapegha hilibhi bhandu kapukwa, mundu ywohele kakotoke kumanya kimukitenda. ");
INSERT INTO nww_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ngati matulo ghako ghabheghe gha lupwepo. Ndo Tate ywako ywa Kunane ywakabhona kwa lupwepo katakupeha hupo pakindandabhanji.” ");
INSERT INTO nww_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Pammegha munguyupa nkotoke kubhegha handa afyangu, kiyaha bhombe bhangupala kuyupa paayima mu nyumba hya kukonganila Ayahudi na mumbwegha ya njila ngati atikilwe na bhandu. Kulyaghila nunguaghombela, bhombe amokola kala hupo yabhe. ");
INSERT INTO nww_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Peni ghwenga paghuyupa, ghuyingile mu nyumbakati yako, ghutate nlyango na ghunnyupe Tate ywako ywakabheghite mulupwepo. Naywo Tate ywako ywakabhona mulupwepo katakupegha hupo yako.” ");
INSERT INTO nww_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Na mwenga pammegha mukuyupa, nkotoke kulongela malagho ghangamanyikwa handa paatenda bhandu bhangammanya Chapanga. Kiyaha bhombe bhanguhwacha kukita bhaayunilwa kwa malagho ghabhe matangalo. ");
INSERT INTO nww_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nkotoke kubhegha handa bhombe, kiyaha Tate ywenu kangumanya kila kimukipala kukali na kunnyupa. ");
INSERT INTO nww_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Habhu, ndo mungunoghwa kuyupa, ‘Tate ghwetu ghuubheghite kunane, Lihina lyako litikilwe, ");
INSERT INTO nww_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ghubhutwa ghwako ghuhike Lighulipala litendeke kunane na litendeke bhubho mu nnima. ");
INSERT INTO nww_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ghutupeghe lelo hilyo hyetu hya kila linjubha. ");
INSERT INTO nww_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ghutulekekehe ulemwa ghwetu, Handa patualekekeha bhala bhaatuhokela. ");
INSERT INTO nww_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ghukotoke kutuyingiha mu mayigho, peni ghutulopohe kuhuma kwa yula nhokelo. Kiyaha Ghubhutwa ndo ghwako na makakala na ukulu hata manjubha ghoha. Ayi mwika.’ ” ");
INSERT INTO nww_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Kiyaha pamualekekeha bhandu bhangi mahokelo ghabhe, Tate ywenu ywa Kunane naywo kataalekekeha mwenga bhubho. ");
INSERT INTO nww_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Peni handa pamualekekeha ng'obhe bhangi bhaabhahokela, na Tate ywenu ywa Kunane kutabhalekekeha ng'obhe uhokelo ghwenu.” ");
INSERT INTO nww_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Pamulikunga kulyegha hilyo, nkotoke kutenda handa afyangu, bhaalitenda bhangubhegha na mahyongololo na kukikinala hibhungi hyabhe, ngati abhonekane na bhandu kukita bhalikunga. Kulyaghila nunguaghombela bhombe bhakingama kala hupo yabhe. ");
INSERT INTO nww_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Peni pamulikunga kulyegha, nkuhe hibhungi hyenu mpakale mahuta mu mitwe hyenu, ");
INSERT INTO nww_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ngati kulikunga kwa mwenga kukotoke kulibhoneha kwa bhandu bhangi, ngati Tate ywenu ywakatama palupwepo, naywo Tate ywenu ywakabhona mu lupwepo kataapegha hupo yenu.” ");
INSERT INTO nww_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Nkotoke kulibhikila luhanja apa pannima, pahala pene hipuluputu na kutu bhanguhanjaghana, na bhanabhwihi bhangutungunyula na kuyibha. ");
INSERT INTO nww_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ngati mulibhikile mihanja hyenu kunane kwa Chapanga kwene hipuluputu na kutu bhanguhanjaghana ng'obhe, ebu bhanabhwihi bhangutungunyula kata na kuyibha. ");
INSERT INTO nww_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kiyaha palubheghite luhanja lwako, apo ndo mwoyo ghwako ghungubhegha.” ");
INSERT INTO nww_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Liho ndo limbamba lya mmili. Handa liho lyako lingubhona maha, mmili ghwako ghwoha ghwaabhegha na bhwelu. ");
INSERT INTO nww_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Peni handa liho lyako lya maha ng'obhe, mmili ghwako ghwabhegha na lubhindu. Kya habhu, handa bhwelu luubheghite mu nkati yako ndo lubhindu, alwo ndo lubhindu lwa totoloo!” ");
INSERT INTO nww_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Kabhone mundu ywakahotola kuatendela mahengo abambo abhili, Kiyaha katankalalila yumu na katanpala yula yungi, ebu katabhegha benibeni na yumu na kumpughana yungi. Maahotola ng'obhe kuntumikila Chapanga na utopelo.” ");
INSERT INTO nww_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Habhu nunguaghombela, nkotoke kubhegha na bhwaghalili yakya ubhumi ghwenu, maalyegha niki ebu maanywegha niki abu kwakya mmili ghwenu handa maahwala niki. Bhuli, ubhumi ghwenu ghwapitingana ng'obhe kwa hilyo na mmili kupitingana maghwanda! ");
INSERT INTO nww_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mubhalole hiyuni bha kubhwelo, bhombe bhangubhatika ng'obhe mbeyu ebu bhangubena ng'obhe ebu kubhika mbunje muluhanja, peni Tate ywenu ywa kunane kanguapegha hilyo. Bhuli, mwenga chepa bha utopelo kupitingana abho hibhumbe hya kunani? ");
INSERT INTO nww_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ndo ghani mu mwenga ywene kwa bhwaghalili katahotola kuliyonjokehela hata lisaa limu mu ubhumi ghwake?” ");
INSERT INTO nww_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Namwenga, kya bhuli mungughayila mapinda? Mughahwachile malubha gha kumighunda paghamela, ghangutenda lihengo ng'obhe ebu ghangulitendekehela ng'obhe mapinda ghabhe. ");
INSERT INTO nww_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Peni nunguaghombela, hata mutwa Sulemani mwene muukulu ghwake ghwoha kakihwalihwa ng'obhe maha handa limoo lya agha malubha. ");
INSERT INTO nww_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Basi, handa Chapanga kangughahwaliha habhu manyahi gha kunng'unda, ghene ghangubhegha lelo na kilabho ghangutaghwa mu mwoto, Mwenga bhandu bha uhyubhalilo nchoko! Bhuli Chapanga kataandendela ng'obhe mwenga kupitingana malubha agho?” ");
INSERT INTO nww_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Hinu nkotoke kubhegha na bhwaghalili, pannongela, ‘Twaalyegha niki?’ Ebu ‘Twaanywegha niki?’ Ebu ‘Twaahwala niki?’ ");
INSERT INTO nww_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mana bhandu bhangammanya Chapanga ndo bhangughayila agho, peni Tate ywenu ywa Kunani kangumanya kukita mungunoghwa kubhegha na ahyo hyoha. ");
INSERT INTO nww_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Peni mughupalahe huti Ghubhutwa ghwa Chapanga, na kughayitikila malaghilp ghake na ghangi ghoha maayonjokehelwa. ");
INSERT INTO nww_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Hino, nkotoke kughayila kilabho, kiyaha kilabho yalighayila yene. Yingunoghwa kwa kila linjubha libheghe na maghayo ghake.” ");
INSERT INTO nww_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Mbole Yesu kakilongela, “Ghukotoke kunng'ombela mundu ywohele kukita ghwenga ndo nhakata, paghutenda habhu Chapanga kataghughombela ghwenga ndo mundu nhakata, ");
INSERT INTO nww_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","mana kyabhula pamunng'ombela mundu yungi ndo nhakata, ndo bhubho Chapanga kataghughombela ghwenga ndo nhakata na kipimilo kilakila kighukitumila kwa yungi ndo Chapanga katakitumila kwa ghwenga. ");
INSERT INTO nww_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kyaniki ghungululola lukapi luubheghite mu liho lya nnongo ghwako, peni ghungulilola ng'obhe ghumwene libaku luubheghite mu liho lyako? ");
INSERT INTO nww_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ebu, ghunguhotola bhuli kung'ombela nnongo ghwako, ‘Ghuleke huti nulubhuhe lukapi luubheghite mu liho lyako, peni liho lyako libhegha na libaku?’ ");
INSERT INTO nww_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ghwenga nfyangu, ghulibhuhe huti ghumwene libaku liibheghite mu liho lyako, na mbole ghwahotola kubhona maha na kubhuha lukapi luubheghite mu liho lya nnongo ywako.” ");
INSERT INTO nww_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Nkotoke kuapegha galu hilibhi hing'anyimo, bhaaghalambuka na kuakwalambula mabhene, na nkotoke kuapegha maghulubhe hilibhi hya utopelo, kiyaha bhahilibhata.” ");
INSERT INTO nww_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Nnyupe kwa Chapanga, namwenga maapeghwa, mpalahe namwenga maamokola, nkong'onde nlyango na mwenga maahughulihwa nlyango. ");
INSERT INTO nww_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mana kila ywakayupa kangupeghwa, ywakapalaha kangumokola na yunakukong'onda nlyango kanguhughulighwa nlyango. ");
INSERT INTO nww_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Bhuli, kabhegha ywoheli mu mwenga ywene mwana ywake pakannyupa lingate katampegha libho? ");
INSERT INTO nww_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ebu, handa pakannyupa homba katampegha liyoka? ");
INSERT INTO nww_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Basi, handa mwenga mmegha maahokelo, mungumanya kuapegha bhana bhenu hilibhi hya maha, kulyaghila Tate ywenu ywabheghite Kunane kataapegha kyanalumu hilibhi hya maha bhala bhanakunnyupa.” ");
INSERT INTO nww_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Basi, ghoha ghamughapala kutendelwa na bhandu, na mwenga mubhatendele ubhwabhu abhu. Mana aghu ndo utwihiliko ghwa Malaghilo gha Musa na mahundo gha mambuye bha Chapanga.” ");
INSERT INTO nww_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Nnyingile kupitila nlyango ghuukepite, mana nlyango na njila yiighenda kuuhobhelo yikonda, na bhaaghenda mu njila ayi ndo atangalo. ");
INSERT INTO nww_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Peni njila yiighenda ku ubhumi yikepa, na nlyango ghwa kuyingilila amwo ndo ghukepa, ndo bhandu bhamandina bhaapala kuyibhona njila ayi.” ");
INSERT INTO nww_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mulindakile na ambuye ahwangi, bhanakuhika kwa mwenga kunu paahwala mpinda handa mene kwa panje, peni unyumba abhegha handa galu bha kunhitu. ");
INSERT INTO nww_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mutabhamanya kwa mapambika ghabhe ghene ndo mandendelo ghabhe. Bhuli, bhandu bhangunokola misabibu mu mihomi ebu tini mu mitunguluja? ");
INSERT INTO nww_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ubhwabhu abhu nkongo ghwa maha ghungupambika mapambika gha maha, na nkongo nhakata ghupambika mapambika mahakata. ");
INSERT INTO nww_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nkongo ghwa maha ghunguhotola kata kupambika mapambika mahakata na nkongo nhakata ghunguhotola kata kupambika mapambiko gha maha. ");
INSERT INTO nww_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nkongo ghwohele ghwangapambika mapambika gha maha ghwaadumulwa na kutaghwa mu mwoto. ");
INSERT INTO nww_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Habhu, mutabhamanya kwa ndendelo yabhe.” ");
INSERT INTO nww_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Chepa kila mundu ywakang'ombela, ‘Bambo, Bambo,’ katayingila mu ghubhutwa ghwa kunane, ngati ndo yula ywakatwihiliha ghanakunnoghela Tate ywangu ywa kunane. ");
INSERT INTO nww_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Linjubha alyo bhandu atangalo bhatanng'ombela, ‘Bambo, Bambo, tukilandamiha Lilagho lyako kwa lihina lyako na kubhuha mandilu na kutenda mihabho mitangalo!’ ");
INSERT INTO nww_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ndo ndabhaghombela, ‘Kulyaghila nikibhamanya ng'obhe. Mmuke kwa nenga, mwenga atenda mahokelo.’ ” ");
INSERT INTO nww_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Habhu, ywohele yunakuyihwa malagho ghangu na kughatenda, ndo handa mundu yunamahala ywakachengite nyumba yake mulitalabha. ");
INSERT INTO nww_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Hula yikikoma, na ngumbwa ya machi yikihika na liyegha likipula na kuyituta nyumba yila, peni yikighwegha ng'obhe kiyaha kitamiho kyake kikibhegha mu litalabha.” ");
INSERT INTO nww_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Peni ywohele yunakuyihwa malagho ghangu na kutenda kata, aywo ndo handa mundu mmughabhugha ywakachengiti nyumba yake mu nhanga. ");
INSERT INTO nww_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Hula yikikoma, na ngemba yikimema machi ngumbwa na liyegha lukipula na kuyituta nyumba yila, nayo yikighwegha na nging'indo yikibhegha ngulu.” ");
INSERT INTO nww_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu pakayomolite kulongela agho, lumati lwa bhandu lukikangahwa muno na mahundo ghake. ");
INSERT INTO nww_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kiyaha kakihunda handa mundu yunalikalama, hangi chepa handa ahunda bhabhe bha Malaghilo. ");
INSERT INTO nww_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu pakahulukite kukitumbi, lumati lukulu lwa bhandu lukintughila. ");
INSERT INTO nww_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Mundu yumu yunamaloha kakihika na kakinchutamila mayughwa paking'ombela, “Bambo, handa ghungupala, ghwahotola kunyoha.” ");
INSERT INTO nww_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu kakigholoha kibhoko kyake, kakinnyabhika pakalongela, “Nungupala ghuyoheke.” Kamu yula mundu kakilama maloha ghake. ");
INSERT INTO nww_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mbole Yesu kaking'ombela, “Ghuyihwe, ghukotoke kunng'ombela ywohele, ngati ghughende ghukalibhonehe kwa ndundame, na kutula matulo gha ghalaghilitwe na Musa ngati yibheghe ubhoneho kukita ghulamihwa.” ");
INSERT INTO nww_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu pakayingiliti ku Kapelinaumu, machonda yumu kilongohi kakinhikila pakinnyupa utangwo, ");
INSERT INTO nww_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","kakilongela, “Bambo, ndumitumi ghwangu kaghonja ukaya, ntamwa ghwa ulelebhalo kangi kangubhina munu.” ");
INSERT INTO nww_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu kakinng'ombela, “Ndahika na kunlamiha.” ");
INSERT INTO nww_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Peni yula kilongohi ywa machonda kakinng'ombela, “Bambo, nenga nungunoghwa ng'obhe kwa ghwenga kuyingila mu lubhagha lwangu. Peni ghukambuke lilagho ghweka, na nndumindumi ghwangu katalama. ");
INSERT INTO nww_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kiyaha na nenga ndo mundu numeghite na makakala, abhegha machonda pahi ya nenga. Panunng'ombela ayu ‘Ghughende,’ naywo kangughenda, na yungi panung'ombela ‘Ghuhike.’ Naywo kanguhika. Na panung'ombela nndumindumi ghwangu ‘Ghutende kilibhi aki.’ Naywo kangutenda.” ");
INSERT INTO nww_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu pakayihwite malagho ago kakikangacha, na kakiaghombela bhala bhandu bhaantughilite, “Kulyaghila nunguaghombela, nenga nangammona ng'obhe mundu ywohele hata mu Isilaeli, kabhegha na uhyubhalilo handa aghu. ");
INSERT INTO nww_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Basi, nunguaghombela kukita bhandu atangalo bhaahika kuhuma kungeha na kulutipikila luchubha, nabho bhaatama mu chekwa ya kulyegha papamu na Abulahamu na Isaka na Yakobu mu Ghubhutwa ghwa kunani kwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Peni bhala bhene Akaaisilaeli atangalo bhaahwacha ghubhutwa aghwo ndo ghwabhe, bhatataghwa panji mulubhindu, akwo bhaalila na kuhyagha mino.” ");
INSERT INTO nww_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mbole Yesu kakinng'ombela yula machonda kilongohi, “Ghughende ukaya kwako, na yibheghe handa paghuhyubhalila.” Na yula ndumindumi ywake kakilama lisaa lila lila. ");
INSERT INTO nww_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu pakahikite ukaya kwa Petili, kakimmona mama ywa nhumbu ywa Petili kaghonja paulili kangubhina nhehemela. ");
INSERT INTO nww_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kakinnyabhikila kibhoko aywo mama na utamwa ghukinleka, kakiyinuka na kuyanda kukeya kuntelekela. ");
INSERT INTO nww_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Payihikite makimuhi bhakinnyeghela bhandu atangalo bhaabheghite na mandilu. Naywo kakighabhuha ghala mandilu kwa lilagho lyake na kualamiha atamwa bhoha. ");
INSERT INTO nww_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Agha ghakitendeka ngati litwihilike lila lilagho liikambukitwe na mbuye Isaya handa, “Ywombe katola mihehemela yetu na katola matamwa gha twenga.” ");
INSERT INTO nww_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu pakabhonite lumati lwa bhandu paluntindila, kakiakwilikiha ahundwa bhake bhayomboke kumwambo ya lihibha. ");
INSERT INTO nww_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nhunda yumu ywa malaghilo kakinng'endela, pakinng'ombela, “Nhunda, nenga ndakutughila kwohele kughupala kughenda.” ");
INSERT INTO nww_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu kakinnyanga, “Mabhweha abhegha na mbako, na hiyuni abhegha na hiyumba, peni Mwana ghwa Mundu kabhegha ng'obhe na pakupumulila.” ");
INSERT INTO nww_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mundu yungi mu ahundwa bhake kakinng'ombela, “Bambo, ghundegheke huti nikankulile tate ghwangu.” ");
INSERT INTO nww_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Peni Yesu kakinng'ombela, “Ghundughile, ghubhaleke bhaaghweghite abhakulile bhala bhaaghweghite bhabhe.” ");
INSERT INTO nww_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu kakikwela mubhwato, na ahundwa bhake bhakintughila. ");
INSERT INTO nww_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Paabheghite mu mwanja, pindulu likibwituka likusi likulu mu lihibha mbaka bhwato ghukiyanda kudibala kwa mayukano, peni Yesu kakibhegha kaghonja ng'ono. ");
INSERT INTO nww_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ahundwa bhake bhaking'endela, bhakinnyumuha paalongela, “Bambo, ghutulopohe, tunguhwegha.” ");
INSERT INTO nww_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Naywo Yesu kakiaghombela, “Mwenga bhandu munakuhyubhalila kyamandina, kiyaha niki munguyoghopa?” Mbole kakiyinuka na kakililakalila lila likusi na lihibha, na kukibhegha tuli. ");
INSERT INTO nww_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bhala bhandu bhakikangacha, paalongela, “Ayu ndo mundu ywa kya bhuli mbaka likusi na lihibha hingunnyitikila!” ");
INSERT INTO nww_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu pakahikite kumwambo, ku nnima ghwa Akaagelasi, bhandu abhili bhaakwelitwe na mandilu bhakikongana na Yesu paahuma ku mandogholo. Bhandu abha bhakibhegha akalipa munu, mbaka kahone mundu ywakahotolite kupita mu njila yila. ");
INSERT INTO nww_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bhakituta kyobho paakilongela, “Ghubhegha na niki na twenga, Mwana ghwa Chapanga? Bhuli ghunguhika apa kutupamanda kukali ya linjubha liikwilikihitwe?” ");
INSERT INTO nww_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Patali pamandina kuhuma pahala paabheghite, kukibhegha na lumati lwa maghulubhe paluhakilwa. ");
INSERT INTO nww_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ghala mandilu ghakinnyupa Yesu, “Handa paghutubhuha, ghutuleke tughende, tuyingile mu lula lumati lwa maghulubhe.” ");
INSERT INTO nww_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kakiaghombela, “Nng'ende.” Habhu bhakiabhuka bhandu bhala. Lumati lwoha lwa maghulubhe likihulukila kwa lubhilo uhelelo nkulu ghwa kitumbi, likiyingila mu luhibha na likihwegha mumachi. ");
INSERT INTO nww_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bhala bhaabheghiti mu kuahakila maghulubhe bhakibhutuka lubhilo na bhakeyingila mu kitami, bhakighenda kuaghomela bhandu mihalo hyoha ya milando yiibhabwitukilite bhala bhandu bhaakwelitwe na mandilu. ");
INSERT INTO nww_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mbole bhandu bhoha bha nnima ghula bhakibhuka na kughenda kukongana na Yesu. Na paammonite bhakinnyupa kabhuke mu nnima ghwabhe. ");
INSERT INTO nww_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu kakikwela mubhwato, kakiyomboka lihibha na kuhika mu kitami kyabhe. ");
INSERT INTO nww_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Linjubha alyo alyo bhakinnyeghela mundu ywakalelebhalite, kaghonjekwa mu likahe. Yesu pakabhonitie kuhyubhalila kwabhe, kakinng'ombela yula ywakalelebhalite, “Ghukotoke kutunyuka mwoyo mwana ghwangu, ghulekekehwa ulemwa ghwako.” ");
INSERT INTO nww_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kwakya nnando aghwo, amoo bha ahunda bha malaghilo bhakiyanda kuhwacha mu myoyo yabhe, “Mundu ayu kangukundula.” ");
INSERT INTO nww_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Peni Yesu kakighamanya mahwacho ghabhe, kakiaghombela, “Kiyaha niki munguhwacha uhokelo mu myoyo yenu? ");
INSERT INTO nww_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kyoki kiibheghite kiyeyebhu, kulongela, ‘Ulemwa ghwako ghulekekehwa,’ ebu kulongela, ‘Ghuyime ghutyange?’ ");
INSERT INTO nww_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Peni nungupala mmanye kukita Mwana ywa Mundu kabhegha na makakala gha kulekekeha ulemwa mu nnima” Ndo kakinng'ombela yula mundu ywakalelebhalite, “Ghuyime ghutole likahe lyako na ghughende ukaya kwako.” ");
INSERT INTO nww_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Yula mundu kakiyima, na kakighenda ukaya kwake. ");
INSERT INTO nww_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Bhandu bhoha mulula lumati paabhonite agho bhakiyingilwa lyogha, bhakintika Chapanga, ywakaapeghite makakala ghala kwa bhandu. ");
INSERT INTO nww_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu pakabheghite mu kubhuka akwo, kakimmona mundu yumu lihina lyake Matayu katama pakusulumula sumu. Kakinng'ombela, “Ghundughile.” Matayu kakibhuka na kakintughila. ");
INSERT INTO nww_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu pakabheghite mulubhagha lya Matayu katama kulyegha hilyo, asumula sumu atangalo na bhanaulemwa bhakihika kutama papamu naywo na ahundwa bhake. ");
INSERT INTO nww_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Afalisayu paabhonite milando ayi, bhakiakonya ahundwa bhake, “Kiyaha niki nhunda ghwenu kangulyegha papamu na asumula sumu na bhanaulemwa?” ");
INSERT INTO nww_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Peni Yesu pakaghayihwite agho kakiaghombela, “Bhandu bhanga utamwa bhangumpomela ng'obhe nng'anga ngati bhala bhanautamwa bhangumpomela. ");
INSERT INTO nww_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Basi, nng'ende mukalihunde fwambulo ya malagho agha, ‘Ningupomela lipyanda, ngati chepa nyambi.’ Kiyaha hika ng'obhe kuakema bhaabheghiti bha maha, ngati bhanaulemwa.” ");
INSERT INTO nww_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ahundwa ghwa Yohane yunakubatisa bhakihika na kunkonya Yesu, “Kya bhuli twenga na Akaafalisayu tungulikunga, peni ahundwa bhako bhangulikunga ng'obhe?” ");
INSERT INTO nww_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu kakiayanga, “Bhuli, ahenja bha yunakutolela bhaahotola bhuli kukukulika paabhegha na yunakutolela? Linjubha lyahika pakabhuka bambo yunakutolela, apo ndo bhatalikunga.” ");
INSERT INTO nww_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Kahone mundu ywakapabhika kipabhiko kya hyono mu likama, kiyaha kila kipabhiko kyakakuka mu likama alyo na pala pakapabhikiti paayonjokeheka. ");
INSERT INTO nww_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ebu bhandu angubhika ng'obhe difwai ya hyono mu nhako ghwa liyula ghuuhakaliti. Handa paatenda naha ghula nhako ghwa liyula lwaabaluka na difwai ya yitika. Na nhako ghwa liyula lyakanjaghanika, peni difwai ya hyono yabhikwaha mu hibhigha ya liyula lya hyono, na hibhigha yaabhegha tela.” ");
INSERT INTO nww_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu pakabheghite kangulongela agho, kamu kakiyingila kilongohi ywa nyumba ya kukonganila Akaayahudi, kakinchutamila mayughwa muulongolo ghwake na kunng'ombela, “Nhinja ghwangu kahwegha hinu hinu. Peni ghughende na ghunnyabhikile kibhoko kyako naywo katalama.” ");
INSERT INTO nww_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu kakibhuka na kakilongohana naywo, ahundwa bhake nabho bhakintughila. ");
INSERT INTO nww_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Lisaa alyo alyo nndala yumu ywakabheghite na liholobhela kwa ngungwa kumi na ibhili, kakinhikila Yesu kya kuhyetu na kakilibyala lipinda lyake, ");
INSERT INTO nww_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kiyaha kakilighombela mumwoyo ghwake, “Handa ndalibyala lipinda lyake, ndaalama.” ");
INSERT INTO nww_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu kakikilibhuka, naywo pakammonitie kakinng'ombela, “Nhinja ghwangu, ghukotoke kutunyuka mwoyo, kuhyubhalila kwako kukulamiha.” Naywo yula nndala kakilama lisaa lilalila. ");
INSERT INTO nww_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu pakahikite kulubhagha lwa yula kilongohi ywa nyumba ya kukonganila Ayahudi, kakiabhona bhandu bhakipyemba filimbi na lumati lwa bhandu lukibhegha lungukukulika, ");
INSERT INTO nww_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","kakiaghombela, “Mmuke, kiyaha nhinja kahwegha ng'obhe ngati kaghonja.” Peni bhombe bhakinheka. ");
INSERT INTO nww_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mbole lumati lwa bhandu lukibhuhwa panje, Yesu kakiyingila unyumba na kakinkamula kibhoko, yula nhinja kakiyumuka. ");
INSERT INTO nww_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mihalo ayi yikikwila munnima ghula ghwoha. ");
INSERT INTO nww_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu pakabheghite mukubhuka pala, bhangabhona abhili bhakintughila, bhakiyobha kyobho na bhakilongela, “Mwana ywa Daudi ghutupeghe lipyanda.” ");
INSERT INTO nww_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu pakayingiliti munyumba bhala bhangabhona bhakinhikila. Naywo kakiakonya, “Munguhyubhalila kukita ndahotola kutenda nnando aghu?” Bhakinnyanga, “Ena Bambo.” ");
INSERT INTO nww_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ndo Yesu kakiabyala meho ghabhe na kulongela, “Na yibheghe kwa mwenga handa panhyubhalila.” ");
INSERT INTO nww_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Meho ghabhe ghakihughuka. Yesu kakiakanikiha, pakalongela, “Nnole, mundu ywohele kakotoke kughumanya nnando aghu.” ");
INSERT INTO nww_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Peni bhombe bhakighenda na kulandamiha mihalo ya Yesu mu nnima ghula ghwoha. ");
INSERT INTO nww_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bandu bhala abhili paabheghite bhangubhuka, mundu yumu ywakakwelitwe na mandilu na ywakabheghite ng'obhe na uhotolo ghwa kulongela kakiyeghwa kwa Yesu. ");
INSERT INTO nww_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kamu, palibhuhitwe lila lindilu, yula ywangahotola kulongela kakilongela. Lula lumati lwa bhandu lukikangacha na kulongela, “Nnando handa aghu ghunabhonekana ng'obhe mu Isilaeli.” ");
INSERT INTO nww_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Peni Afalisayu bhakilongela, “Aywo kangughabhuha mandilu kwa makakala gha nkulu ghwa mandilu.” ");
INSERT INTO nww_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu kakityangila muhitami hyoha na hijiji, pakahunda munyumba hyabhe hya kukonganila Akaayahudi, pakalandamiha Nhalo ghwa Maha ghwa Ghubhutwa ghwa Chapanga na kulamiha atamwa kwoha mu bhandu. ");
INSERT INTO nww_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pakaabhonita bhandu himati himati kakiabhonela luhungu kiyaha bhangughaya kyangali utangwo, handa mene bhangali na nhakila. ");
INSERT INTO nww_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Habhu kakiaghombela ahundwa bhake, “Mabeno ndo matangalo peni atendalihengo bhamandina, ");
INSERT INTO nww_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Basi, munnyupe Bambo ywa mabeno, ngati kabhalaghile atendalihengo bhabene mabeno ghake.” ");
INSERT INTO nww_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu kakiakema bhala ahundwa bhake kumi na abhili, kakiapegha makalama gha kughabhingabhinga mandilu na kulamiha matamwa ghoha. ");
INSERT INTO nww_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Agha ndo mahina ghabhe bhala ahundwa kumi na abhili, ghwa ulongohi ndo Simoni ywakakemitwe Petili na Andelea nnongo ghwake, Yakobu mwana ghwa Sebedayu na Yohane nnongo ghwake, ");
INSERT INTO nww_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo na Batolomayu, Tomasi na Matayu ywakabheghite nsumula sumu na Yakobu mwana ywa Alufayu na Tadei, ");
INSERT INTO nww_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni mundu ywakatutanilite nnima ghwake Yuda Isikaliyote ywakankilukite Yesu. ");
INSERT INTO nww_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu kakialaghila abho kumi na abhili na kuapegha malagho, “Nkotoke kughenda kwa bhandu bhaabheghite ng'obhe Ayahudi, hangi nkotoke kuyingila mu kitami kyohele kya Akaasamalila. ");
INSERT INTO nww_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Peni mbaha nngende kwa Akaisilaeli bhaahobhite handa mene. ");
INSERT INTO nww_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Panng'enda mukalandamihe pannongela, ‘Ghubhutwa ghwa kunane ghuheghelela.’ ");
INSERT INTO nww_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mualamihe atamwa, mukaahyuhe bhaahweghite, mubhayohe bhabheghite na maloha, mmuhe mandilu. Mpeghwa yaghi, na mwenga muapeghe yaghi. ");
INSERT INTO nww_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nkotoke kutola sahabu, ebu madini ghaakemwa fesa, ebu ngalabha mumihako ya mikungi yenu. ");
INSERT INTO nww_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nkotoke kutola nhako ghwa mu mwanja, ebu maghwanda mabhili, ebu makubasi ghangi, ebu nkongocho, kiyaha ntendalihengu kangunoghwa kukingama mulyo ghwake.” ");
INSERT INTO nww_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Pannyingila mu kitami ebu kijiji kyohele, mumpalahe mundu ywakapala kuakingama, na ntame kwa ywombe mbaka pampala kubhuka. ");
INSERT INTO nww_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pannyingila mu lubhagha, muajambuhe huti uhihimilo ghubheghe namwenga. ");
INSERT INTO nww_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Handa abhegha bhandu bha maha munyumba ayi Chapanga kabhanonele. Peni handa abhegha ng'obhe bhandu bha maha, Chapanga kataanonela ng'obhe bhandu abho. ");
INSERT INTO nww_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Handa mundu kanguakingama ng'obhe kubhayihwa mwenga. Basi, mpumunde lihu mumaghulu ghenu pammegha mu kubhuka mu nyumba ayo. ");
INSERT INTO nww_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kulyaghila nunguaghombela, linjubha lya toso, kitami akyo kyamokola kihyato kikulu kupitingana kila kyaakimokolite bhandu bha hitami hya Sodoma na Gomola.” ");
INSERT INTO nww_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nnole nungualaghila handa mene munkati ya galu bha kunhitu. Hinu mmeghe na malango handa liyoka na apole handa ngunda. ");
INSERT INTO nww_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mulindakile na bhandu, kiyaha bhatabhayegha mu njengakaya yabhe na kuatuta mu nyumba hyabhe hya ngonganilo. ");
INSERT INTO nww_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Maayeghwa kwa atabhala na abhatwa kwakya nenga, ngati mmokole muaghombele bhombe yakya nenga na kwa bhandu bhaabheghite ng'obhe Ayahudi. ");
INSERT INTO nww_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Peni paabhayegha munjengakaya, nkotoke kuhwacha kya kulongela, kiyaha maapeghwa kya kulongela lisaa alyo alyo. ");
INSERT INTO nww_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mana chepa mwenga mumpala kulongela, ngati Nhuki ywa Tate ywenu kutalongela kupitila mwenga.” ");
INSERT INTO nww_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nnongo katankiluka nnongo ywake kakomwe, na tate katankiluka mwana ywake, bhana bhataakiluka abhele bhabhe na kuatenda akomwe. ");
INSERT INTO nww_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bhandu bhataapala ng'obhe mwenga kwakya kuhyubhalila nenga. Peni yunakulimbilila mbaka kuuhiko aywo katalopohwa. ");
INSERT INTO nww_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bhandu paabhapamanda mukitami kimu nng'ende kitami kingi. Kulyaghila nunguaghombela, mayiyomola ng'obhe hitami hyoha hya ku Isilaeli kukali na kubhuya kwa Mwana ywa Mundu.” ");
INSERT INTO nww_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Nhundwa kaahotola ng'obhe kulikweha kwa nnhunda ywake ebu nndumitumi kaahotola ng'obhe kulikweha kwa bambo ywake. ");
INSERT INTO nww_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nhundwa kangunoghwa kubhegha handa nhunda ywake, na nndumindumi kangunoghwa kubhegha handa bambo ywake. Handa nenga ndo nkulu ywa nyumba yenu bhangungema Belisebuli, bhuli mwenga chepa bhaabhakema mahina mahakata kyanalumu!” ");
INSERT INTO nww_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Basi, nkotoke kubhayoghopa bhandu abho, kiyaha kahone kiigubikitwe kyene kyangagubutuligwa, na kila kiihihitwe kyaahumbulwa. ");
INSERT INTO nww_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Linuaghombela mwenga mu mbwepo, mwenga mulilongele pakindandabhanji, na lila linubhapwepwela, mulilandamihe ngati kila mundu kaliyihwe. ");
INSERT INTO nww_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nkotoke kubhayoghopa bhala bhanakughukoma mmili peni bhaahotola kata kuukoma nhuki. Mungunoghwa munnyoghope Chapanga ywakahotola kughukanjaghana nhuki na mmili mu mwoto ghwa kumambe. ");
INSERT INTO nww_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Bhuli, hidunduli abhili bhanguhemelwa ng'obhe kwa ligwala yimu ghweka? Peni kahone hata yumu ywabhe ywakapala kuponeka kyangali kummanya Tate ywenu. ");
INSERT INTO nww_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hata hwili hya mitwe hyenu Chapanga kahimanya mmalango ghwake. ");
INSERT INTO nww_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Habhu nkotoke kuyoghopa, kiyaha mwenga bha maha muno muulongolo ghwa Chapanga kupitingana hidunduli atangalo.” ");
INSERT INTO nww_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Mundu ywohele ywakanyitikila nenga muulongolo ghwa bhandu, na nenga ndannyitikila ywombe muulongolo ghwa Tate ywangu ywa kunane. ");
INSERT INTO nww_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Peni ywohele ywakangana nenga mu ulongolo ghwa bhandu, na nenga ndankana mu ulongolo ghwa Tate ywangu ywa kunane.” ");
INSERT INTO nww_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Nkotoke kuhwacha kukita nyegha uhihimilo mu nnima, nyegha ng'obhe uhihimilo ngati ngondo. ");
INSERT INTO nww_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kiyaha hika kuatenda tate na mwana ywake nnume abheghe amyanja, kangi nhinja na mama ywake abheghe amyanja, nakamwa na mama ywa nngwana ywake, ");
INSERT INTO nww_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","na amyanja bha mundu bhaabhegha bha mukaya yake.” ");
INSERT INTO nww_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Mundu ywohele ywakampala tate ywake ebu mama ywake kupitingana nenga, kangunoghwa ng'obhe kubhegha nhundwa ywangu. Na ywohele ywakampala mwana ywake ebu nhinja ywake kupitingana nenga, kangunoghwa ng'obhe kubhegha nhundwa ywa nenga. ");
INSERT INTO nww_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kangi mundu ywohele ywakatola ng'obhe lupingika lwake na kundughila, kangunoghwa ng'obhe kubhegha nhundwa ywanenga. ");
INSERT INTO nww_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ywombe ywakapala kuulamiha ubhumi ghwake kataghuhobheha, naywo ywombe ywakapala kuuhobheha ubhumi ghwake kwakya nenga kataulopoha.” ");
INSERT INTO nww_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Mundu ywohele ywakaatekula mwenga kangundekula nenga na ywohele kangundekula nenga, kanguntekula ywakalaghilite. ");
INSERT INTO nww_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mundu ywohele ywakantekula mbuye kiyaha aywo ndo mbuye, kaakingama hupo ya mbuye, na ywakantekula mundu ywa maha muulongolo ghwa Chapanga, kaakingama hupo ya mundu ywa maha muulongolo ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mundu ywohele ywakapala kumpegha nnobho ghwa machi, yumu ywa abha adoko kiyaha ndo ahundwa bhangu, kulyaghila nunguaghombela, katapeghwa hupo yake.” ");
INSERT INTO nww_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu pakayomolite kualaghila ahundwa bhake kumi na abhili, kakibhuka apo na kakighenda kulandamiha na kuhunda mu hitami hyabhe. ");
INSERT INTO nww_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohane yunakubatisa pakabheghite mu kibhopo, kakiyihwa mihalo yakatenditi Kilisto, kakialaghila ahundwa bhake, ");
INSERT INTO nww_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ngati bhakankonye, “Ghwenga ndo yula ywakapala kuhika, ebu tunlindilile yungi?” ");
INSERT INTO nww_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu kakiayanga, “Mmuye mukanng'ombele Yohane milando yimuyiyihwa na kuyibhona. ");
INSERT INTO nww_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bhangabhona bhangumokola kubhona, ngwabhengwabhe bhangutyanga, bhanamaloha bhanguyohwa, bhangayihwa bhanguyihwa, bhaahweghiti bhanguhyuhwa na kapukwa bhangulandamihwa Nhalo ghwa Maha. ");
INSERT INTO nww_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kanonelwa mundu yula ywakabheghite ng'obhe na bhwaghalili na nenga.” ");
INSERT INTO nww_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bhala ahundwa bha Yohane paabheghite mu kubhuka, Yesu kakiyanda kughomba na bhandu kwa kya Yohane Yunakubatisa. Kakiakonya, “Panng'endite ku kibhala, mukighenda kubhona niki? Nndenge paghupulwa na liyegha? ");
INSERT INTO nww_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Handa chepa, mukighenda kubhona niki? Mundu ywakahwaliti mapinda gha maha? Aka kaa, bhala bhaahwaliti mapinda gha maha bhangutama mu nyumba ya abhatwa! ");
INSERT INTO nww_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Basi, mukighenda kubhona niki? Bhuli, kummona mbuye ghwa Chapanga? Ena, kulyaghila mukighenda kummona ywakabheghite nkulu kupitingana mbuye ywa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Aywo ndo ywene mihalo yake yikityekwa, ‘Nnole nungunlaghila mjumbe ywa nenga kakulongolele muulongolo ghwako, ywakapala kuyitendekeha njila yako’ ");
INSERT INTO nww_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kulyaghila nunguaghombela, mu bhandu bhoha bhaabhelekitwe na adala, kanabwituka ng'obhe mundu ywakabheghite nkulu kupitingana Yohane Yunakubatisa, hata habhu, yula ywakabheghite nchoko mu ghubhutwa ghwa kunane, ndo nkulu kupitingana Yohane. ");
INSERT INTO nww_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kutandila manjubha gha Yohane Yunakubatisa mbaka hinu, Ghubhutwa ghwa kunane ghungupundangilwa kwa makakala, na bhabheghite na makakala bhanguyigha kughutola ghubhutwa aghwo. ");
INSERT INTO nww_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mana mambuye bhoha na malaghilo gha Musa mbaka manjubha gha Yohane Yunakubatisa, bhakilondola milando yiipala kubhegha manjubha agha. ");
INSERT INTO nww_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Handa mmegha kala kuyitikila ali, ywombe Yohana ndo Eliya ywakalondolitwe kukita katahika. ");
INSERT INTO nww_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ywakabheghite na makutu, kayihwe.” ");
INSERT INTO nww_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Peni kibheleko aki nikihwananihe na kilibhi ghani? Kingulihwana na bhana bhaatamite paligulio paabhakema ayabhe na kualongela, ");
INSERT INTO nww_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tukiahonela ng'oma, peni mukikina ng'obhe, tukiayimbila luyimbo lwa kibhembo peni mukikukulika ng'obhe.’ ");
INSERT INTO nww_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kiyaha Yohane yunakubatisa kakihika, kakilikunga na kakinywegha ng'obhe difwai, nabho bhakilongela, ‘Aywo kakwelwa na lindilu!’ ");
INSERT INTO nww_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana ywa Mundu kakihika, kakilyegha na kunywegha, nabho bhangulongela, ‘Nnole, ayu ndo nhukila na nlobhi, nng'anja ywa asumula sumu na bhanaulemwa.’ Peni malangu gha Chapanga ghangubhonehwa kubhegha gha maha kubhukana na mandendelo ghake.” ");
INSERT INTO nww_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mbole Yesu kakiyanda kuhikinya hitami hyakatendite mihabho mitangalo kupitingana kwingi, kiyaha bhandu bhake bhakilipetula ng'obhe. ");
INSERT INTO nww_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kimmone, mwenga mabhandu bha Kolazini na bha ku Betisaida. Kiyaha handa mihabho yiitendikite kwa mwenga, yingalitendekite kwa bhandu bha ku Tilo na bha ku Sidoni, bhandu abho bhangalipetulite kutandila makachu kwa kuhwala malobota na kulityelemeka malihu. ");
INSERT INTO nww_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Peni nunguaghombela, mu linjubha lya toso, mwenga maamokola toso ngulu kupitingana bhandu bha ku Tilo na bha ku Sidoni. ");
INSERT INTO nww_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Na mwenga mabhandu bha Kapelinaumu, bhuli, maakwehwa mbaka kunane kwa Chapanga? Aka kaa, maahuluhwa mbaka pahi munu. Mihabho yiitendikite kwa mwenga yingalitendekite kwa bhandu bha Sodoma, kitami kyabhe kingabheghite mbaka lelo. ");
INSERT INTO nww_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Peni nunguaghombela kukita, linjubha lya toso mwenga maamokola kihyato kikulu kupitingana kya bhandu bha Sodoma.” ");
INSERT INTO nww_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mumanjubha agho Yesu kakilongela, “Ningukulumba Tate, Bambo ghwa kunane na nnima, kiyaha ghukiyihiha mihalo ayi kwa bhanamalango na asomi, na ghughagubutula kwa bhaabheghite handa bhana hing'enya. ");
INSERT INTO nww_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ena Tate, ghukighatenda habho kiyaha yikikunogheha. ");
INSERT INTO nww_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tate ghwangu, kambegha hilibhi hyoha. Kahone mundu ywakammanya Mwana ngati Tate, ebu kahone ywakammanya Tate maha nga Mwana na ywohele yula mwene Mwana kapala kunhwimulila Tate ghwake.” ");
INSERT INTO nww_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Nhike kwa nenga mabhoha munng'ayaghaya na kutopehwa na mihigho, na nenga ndabhapumuliha. ");
INSERT INTO nww_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mulikunge kingongolo kyangu, mulihunde kwa nenga, kiyaha nenga ndo npole na yunauhwamo ghwa mwoyo, na myoyo yenu yaapumulila. ");
INSERT INTO nww_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kiyaha kingongolo kyangu kiyeyembhu, na nhigho ghunuapegha muupape ndo nnyeyebhu.” ");
INSERT INTO nww_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Linjubha limu, Yesu kakibhegha kangutyanga mu mighunda ya ngano Mulinjuba lya Kupumulila. Na ahundwa bhake bhakibhegha na njala, ndo bhakiyanda kughadunyula mahonjo gha ngano na kulyegha mbunje hyake. ");
INSERT INTO nww_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Peni Afalisayo paaghubhonite nnando agho, bhakinng'ombela Yesu, “Ghulole, ahundwa bhako bhangutenda nnando ghuukanikihwa Mulinjubha lya Kupumulila!” ");
INSERT INTO nww_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu kakiayanga, “Bhuli, munasoma ng'obhe kyakatendite Daudi na ayake paabheghite na njala? ");
INSERT INTO nww_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kakiyingila mu Nyumba ya Chapanga na kakilyegha mangati ghaabhikitwe muulongolo ghwa Chapanga, ywombe ebu abho ayake bhakinoghwa ng'obhe kughalyegha, maha bhakiteghekwa kulyegha andundame ghweka chabhe. ");
INSERT INTO nww_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ebu munasoma ng'obhe mu kitabho kya Malaghilo gha Musa kukita kila linjubha lya kupumulila andundame bhanguhokela Malaghilo mu Nyumba ya Chapanga peni angubhonekana ng'obhe kukita ahokela? ");
INSERT INTO nww_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nunguaghombela hoto kukita, ywakabheghite nkulu kupitingana Nyumba ya Chapanga kabhegha apa. ");
INSERT INTO nww_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Handa mungamanyite mana ya malagho agha, ‘Ningupala lipyanda, ngati ng'obhe nyambi,’ mangaatosite ng'obhe bhandu bhangauhokelo, ");
INSERT INTO nww_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","kiyaha Mwana ywa Mundu ndo Bambo ywa Linjubha lya Kupumulila.” ");
INSERT INTO nww_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu kakibhuka apo na kakiyingila munyumba yabhe ya kukonganila, ");
INSERT INTO nww_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Amwo kakibhegha mundu ywakalelebhalite kibhoko. Bhombe paakipalaha kihokonyo kya kunkokela Yesu, ndo bhakinkonya Yesu, “Bhuli yibhegha tela kulamiha mulinjubha lya Kupumulila?” ");
INSERT INTO nww_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu kakiayanga, “Ndo ghani mu mwenga ywakabheghite na mene ywake ywene kachumbukila mulibhumba Linjubha lya Kupumulila, katammuha ng'obhe? ");
INSERT INTO nww_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Peni mundu ywa utopelo kupitingana mene. Basi, yibhegha tela kutenda gha maha Mulinjubha lya kupumulila.” ");
INSERT INTO nww_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ndo kakinng'ombela yula mundu, “Kigholohe kibhoko kyako.” Kakikigholoha nakyo kikibhegha kyamaha handa kila kingi. ");
INSERT INTO nww_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Peni Akaafalisayo bhakibhuka panje na bhakighombana yakya kunkoma Yesu. ");
INSERT INTO nww_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Peni Yesu pakaghamanyite mahwacho ghabhe, kakibhuka pahala apo. Bhandu atangalo bhakintughila, naywo kakialamiha bhoha, ");
INSERT INTO nww_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","kakiaghombela bhala bhakaalamihite kukita akotoke kulongela ywombe ndo ghani. ");
INSERT INTO nww_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ngati litwihilike lila lilagho lyakakambukite mbuye Isaya pakilongela, ");
INSERT INTO nww_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ghulole nndumitumi ywangu yununhaghulite, npalo ghwangu yununhaghulite, nyelelwa naywo. Ndaabhika nhuki ghwangu kwa ywombe, Naywo katalandamiha ghala ghanuapala bhandu bhaghatende munnima hyoha. ");
INSERT INTO nww_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Katalimbana ng'obhe na bhandu ebu kuyobha kyobho, hangi kahone ywakapala kuyihwa lilobhe lyake mu njila. ");
INSERT INTO nww_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nndenge ghuubajanganite kataudumula ng'obhe, Ebu lutambi lututuma lyohi katauhima ng'obhe, Mbaka pakapala kutwihiliha toso ya ghala ghaapala kutendekwa yatabhale ");
INSERT INTO nww_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Na kwa ywombe bhandu bha milima hyoha yaabhika udumbilo ghwabhe.” ");
INSERT INTO nww_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bhandu bhakinnyeghela mundu ywakakwelitwe na lindilu, naywo ndo ywangabhona na ywangahotola kulongela, Yesu kakinlamiha naywo kakihotola kulongela na kubhona. ");
INSERT INTO nww_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Bhandu bhoha bhakikangacha na kulongela, “Bhuli, ayu chepa Mwana ywa Daudi?” ");
INSERT INTO nww_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Peni Afalisayu paayihwite nnando aghwo bhakilongela, “Mundu ayu kangughabhuha mandilu kwa makakala gha Belisebuli aywo ndo nkulu ywa mandilu.” ");
INSERT INTO nww_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu pakaghamanyite mahwacho ghabhe, kakiaghombela, “Ghubhutwa ghwohele ghuughabhanikite mu himati himati hinakupingikana, ghwaaghendelela kata kubhegha, na nnima ghwohele ebu lubhagha lwohele luughabhanika mu himati himati hinakupingikana ghwatengeleheka kata. ");
INSERT INTO nww_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Handa Nchipila kangumminga Nchipila, kangulipingika mwene. Basi, ubhutwa ghwake ghwatengelehwa bhuli? ");
INSERT INTO nww_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Na nenga handa nungughabhuha mandilu kwa makakala gha Belisebuli, bhuli afwasi bhenu angughabhuha mandilu kwa makakala gha ghani? Hinu naha, abho ndo bhataatosa mwenga. ");
INSERT INTO nww_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Peni handa nenga nungughabhuha mandilu kwa Nhuki ghwa Chapanga, ndo nmanye kukita Ghubhutwa ghwa Chapanga ghubhahikila.” ");
INSERT INTO nww_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ebu mundu katahotola bhuli kuyingila mu nyumba ya mundu yunamakakala na kughupoka utopelo ghwake handa kanammopa ng'obhe yula yuna makakala? Pakammopa kala, kulyaghila katahotola kumpoka utopelo ghwake.” ");
INSERT INTO nww_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ywoheli yunakubhegha ng'obhe papamu na nenga kangumbingikiha, na ywakakungana ng'obhe papamu na nenga, kangupwilinganya. ");
INSERT INTO nww_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Basi, nunguaghombela, bhandu bhaalekekehwa, ulemwa ghwohele na ngundulo, peni ywaankundula Nhuki ghwa Chapanga kaalekekehwa kata. ");
INSERT INTO nww_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mundu ywohele ywakakambuka lilagho kihyengo kya Mwana ghwa Mundu katalekekehwa, peni ywohele yaakambuka lilagho kihyengo kya Nhuki ghwa Chapanga kahone kulekekehwa, mu nnima aghu ebu mu nnima ghuupala kuhika.” ");
INSERT INTO nww_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ghuutende nkongo ghubheghe ghwa maha na mapambiko ghake ghaabhegha gha maha, ebu ghuutende nkongo ghubheghe nhakata na mapambika ghake ghaabhegha mahakata, kiyaha nkongo ghwaamanyikwa kwa mapambika ghake. ");
INSERT INTO nww_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mwenga kibheleko kya liyoka. Mahotola bhuli kukambuka mihalo ya mah, na mwenga malemwa? Kiyaha nnomo ghwa mundu ghwaakambuka ghala gha memiti mu mwoyo ghwake. ");
INSERT INTO nww_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mundu ywa maha ghuyibhuha mihalo ya maha kuhuma muluhanja lwa mwoyo ghwake, naywo mundu nhakata kangubhuha malagho mahakata kuhuma muluhanja lwa mwoyo ghwake.” ");
INSERT INTO nww_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Peni nunguaghombela, mulinjubha lya toso bhandu bhaabhuha mmalango mumalagho ghoha gha uhila mahala ghabhaghakambukite. ");
INSERT INTO nww_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kiyaha kwa malagho ghako ghwaabhalangwa kukita ghwangauhokelo muulongolo ghwa Chapanga, kwa malagho ghako ghwatoswa.” ");
INSERT INTO nww_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mbole amoo bha Afalisayo na ahunda bha malaghilo bhakinng'ombela Yesu, “Nhunda tungupala kubhona naho kuhuma kwa ghwenga.” ");
INSERT INTO nww_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Peni ywombe kakiayanga, “Kibheleko kihakata na kya utyahe kingupala naho. Peni kyaakamuhwa ng'obhe naho ywohele ngati nga yila ya mbuye Yona. ");
INSERT INTO nww_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kiyaha handa bhula Yona pakabheghite mulutumbo lwa homba Ywakakemwa nyangumi kwa manjubha mandatu pamuhi na pakilo, ubhwabhu abhu Mwana ywa Mundu katabhegha mu mwoyo ghwa nnima majubha mandatu, pamuhi na pakilo. ");
INSERT INTO nww_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Linjubha lya toso bhandu bha Ninawi bhaayima papamu na kibheleko aki na kukitosa, kiyaha bhombe bhakilipetula paalandamihitwe na Yona, hinu apa kabhegha nkulu kupitingana Yona. ");
INSERT INTO nww_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mutwa nndala ywa kusini katayima mu linjubha lya toso na katakitosa kibheleko aki, kiyaha mwene kakihika kuhuma ku uhiko ghwa nnima ngati kakaghayihwe mahala gha Solomoni na mu mwenga kabhegha nkulu kupitingana Solomoni.” ");
INSERT INTO nww_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Lindilu palimmuka mundu, lyabhyelabyela pahala paabheghite ng'obhe na machi pakipalaha ng'ebhu ya kupumulila, peni katamokola ng'obhe. ");
INSERT INTO nww_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Mbole lyaalongela, ‘Ndabhuya mu nyumba yangu yimukite’ Naywo pakabhuya kaayibhona yila nyumba ya yaghi, yipyaghilwa na kubhikwa maha. ");
INSERT INTO nww_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Mbole lyaaghenda na kubhayegha mandilu bhangi saba, ahakata kupitingana ywombe, nabho bhaayingila na kutama amwo. Na kuuhiko aywo mundu katabhegha tepatepa kupitingana kalongohi. Habhu ndo yabhegha kwa kibheleko aki kihakata.” ");
INSERT INTO nww_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu pakabheghite mukulongela na lumati lwa bhandu, mama ywake na alongo bhake bhakiyima panje bhakipala kuyobhela naywo. ");
INSERT INTO nww_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ndo mundu yumu kakinng'ombela Yesu, “Bambo, mama ywako na alongo bhako ayima panje, bhangupala kuyobhela na ghwenga.” ");
INSERT INTO nww_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Peni Yesu kakinnyanga na kunng'ombela yula mundu, “Mama ghwangu ndo ghani, na alongo bhangu ndo aghani?” ");
INSERT INTO nww_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Palapala, kakiakigholohela kibhoko kyake kuabhonea ahundwa bhake, pakilongela, “Abha ndo mama ywangu na alongo bhangu. ");
INSERT INTO nww_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kiyaha ywohele ywakatenda mapalo gha Tate ywangu ywa kunane, aywo ndo nnongo ywangu, nhacha ywangu na mama ywangu.” ");
INSERT INTO nww_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Linjubha alyo alyo Yesu kakihuma panje ya nyumba na kakitama pambweha ya Lihibha. ");
INSERT INTO nww_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Lumati lukulu munu lwa bhandu lukikwemukana pa lukintindila mbaka yikinkwiliha kayingile mu bhwato na kakitama amwo, na bhandu bhoha bhakeyima mu mbwegha ya luhibha. ");
INSERT INTO nww_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ndo kakiaghombela milando miyoloho kwa mihwano, pakalongela, “Nkanda lutupi kakighenda kukweta mbeyu hyaki kunng'unda. ");
INSERT INTO nww_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pakabheghite mu kukweta mbeyu ahyo, yingi yikiponeka umbwegha ya njila, hiyuni bhakiihonyola. ");
INSERT INTO nww_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mbeyu yingi yikiponeka mu malibho ghaabheghite na lutupi luchoko. Kamu, yikibhonekana yikimela kya kulopokela kiyaha lutupi lukibhegha luchoko. ");
INSERT INTO nww_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Peni luchubha paluhomokite, mimela yila yikiyuma kiyaha hikibhegha ng'obhe na ngigha ndali. ");
INSERT INTO nww_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mbeyu yingi yikiponeka mu mikongo ya mihomi, nahyo yikiyukwa na mihomi ahyo. ");
INSERT INTO nww_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mbeyu yingi yikiponeka mu lutupi lwa mbosela nayo yikimela na kupambika mapambika, yimu kwa mbinda mabhoko kumi, yingi kwa mbinda mabhoko sita na yingi kya mbinda mabhoko ndatu.” ");
INSERT INTO nww_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ndo Yesu kakiaghombela, “Yunamakutu na kayihwe.” ");
INSERT INTO nww_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ahundwa bhake Yesu bhaking'endela na bhaknkonya, “Kiyaha niki ghunguyobhela na bhandu kwa mihwano?” ");
INSERT INTO nww_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu kakiayanga, “Mwenga nnonelwa kuyimanya mbwepo ya Ghubhutwa ghwa kunane, peni abha bhanapeghwa ng'obhe kughamanya agha ghoha. ");
INSERT INTO nww_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mana mundu ywohele ywene kangumanya yakya ghubbhutwa ghwa kunane, Chapanga katannyokehela kumanya kyanalumu, peni yula ywakamanya kachoko yakya Ghubhutwa ghwa kunane, Chapanga katabhuha hata kila kichoko kyakakimanya. ");
INSERT INTO nww_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ndo mana nunguyobhela nabho kwa mihwano, kiyaha bhangulolekeha ghanughatenda peni handa bhangughabhona ng'obhe, bhanguyihwa ghanughalongela peni bhangughayihwa ng'obhe na bhangumanya ng'obhe. ");
INSERT INTO nww_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Habhu, kwa bhombe ghungutwihilika ulondohi ghwa mbuye Isaya pakalongelite, ‘Abha bhandu bhaayihwa na kuyihwa, peni bhaamanya ng'obhe, kulola bhaalola, peni bhaabhona ng'obhe. ");
INSERT INTO nww_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kiyaha mioyo ya bhandu abha yibhegha na unonopo, bhanguyihwa ng'obhe kwa makutu ghabhe na bhaghagubika meho ghabhe. Hela bhubo, bhangabhonite kwa meho ghabhe, bhangamanyiti kwa mahala ghabhe na kunkilibhukila na kualamiha, kalongela Bambo, na nenga ningabhalamihite.’ ” ");
INSERT INTO nww_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Peni mwenga nnonelwa, kiyaha Chapanga kabhatangatila mwenga mmone na machikilo ghenu ghanguyihwa. ");
INSERT INTO nww_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kulyaghila nungubhaghombela, Ambuye atangalo na bhandu bha maha bhakibhegha na uhongo ghwa kughabhona ghala ghamughabhona peni bhakighabhona ng'obhe, na bhakibhegha na uhongo ghwa kughayihwa ghala ghamughayihwa peni bhakighayihwa ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Basi, mwenga nnyihwe fwambulo ya nhwano ghwa yula mundu ywakaghendite kukweta mbeyu. ");
INSERT INTO nww_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mundu ywohele pakayihwa lilagho lya Ghubhutwa ghwa Chapanga kyanga kulimanya, ndo handa yila mbeyu yiiponikiti munjila, yula Nchipila katahika na kunyahula kila kiibheghite mumwoyo ghwake. ");
INSERT INTO nww_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Yila mbeyu yiiponikiti mu malibho luubheghite nalutupi luchoko ndo nhwano ghwa mundu ywakayihwa lilagho alyo na kamu kangulikingama kwa kuyelelwa. ");
INSERT INTO nww_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Peni kabhegha ng'obhe na ngigha mumwoyo ghwake, kataghendelela kulibhika kwa manjubha machoko na paghuhika nndaluko ghwa himbamanda na lung'ahi kwakya lilagho alyo, kamu kangudunyuka mwoyo. ");
INSERT INTO nww_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Yila mbeyu yiiponikite mu mikongo ya mihomi, ndo nhwano ghwa mundu ywakayihwa alyo lilagho, peni bhwaghalili ghwa nnima aghu na unyeghelehi ghwa utopelo ghunguliyuka lilagho alyo, nalyo kupambika kata. ");
INSERT INTO nww_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Peni yila mbeyu yiimelite mu lutupi lwa mbosela ndo nhwano ghwa mundu ywakayihwite lilagho alyo na kulimanya. Kulyaghila aywo kangupambika mapambika, paka pambika yimo mbinda mabhoko kumi, yingi mbinda mabhoko sita na yingi mbinda mabhoko ndatu.” ");
INSERT INTO nww_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu kakiaghombela bhandu nhwano ghungi pakalongela, “Ghubhutwa ghwa kunane ghungulihwana na mundu ywakakwetiti mbeyu ya maha munng'unda ghwake. ");
INSERT INTO nww_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Peni bhandu paaghonjite, nmyanja ywake kakihika na kakikweta masapi mumpunga ghula, na kakibhuka. ");
INSERT INTO nww_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Paghumelite mpunga na kusukuka, masapi nagho ghakibhonekana. ");
INSERT INTO nww_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Andumindumi bha yula nkolanng'unda bhaking'endela na kunng'ombela, ‘Nkulu, twenga tukikwenta mbeyu ya maha munng'unda ghwako. Hinu, masapi ghahuma kwoki?’ ");
INSERT INTO nww_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kakiayanga, ‘Nmyanja ndo ywakatendite nnando aghwo.’ Bhakinkonya, ‘Bhuli, ghungupala tughende tukaghatupule?’ ");
INSERT INTO nww_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Peni ywombe kakiayanga, ‘Ng'obhe, nkotoke kughatupulanga, kiyaha pamughatupula masapi maahotola kutupula na mpunga bhubho. ");
INSERT INTO nww_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nneke mpunga na misapi yikule papamu mbaka manjubha gha mabeno. Mumanjubha agho gha mabeno ndabhaghombela bhanakubena bhakakungane misapi huti, bhaghabhope hinginja hinginja ngati bhaghayoche mwoto, mbole bhakungane ngano na kuhiyegha mu luhanja lwangu.’ ” ");
INSERT INTO nww_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu kakiaghombela bhandu nhwano ghungi, “Ghubhutwa ghwa kunane ghungulihwana na mbeyu ya nkongo ghuukemwa haladali yiitolitwe na mundu yumu na kuyikweta munng'unda ghwake. ");
INSERT INTO nww_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mbeyu ayi ndo njoko munu kupitingana mbeyu hyoha, peni payimela kala yingubhegha ngulu kupitingana mimela hyoha. Na kangi yingukula na kubhegha nkongo, mbaka hiyuni ghwa kubhwelo bhanguhika na kuchenga hiyumba mu mapanyu ghake.” ");
INSERT INTO nww_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu kakiaghombela nhwano ghungi, “Ghubhutwa ghwa kunane ghungulihwana na amila yene nndala kakitola na kuyihangangana na ukobha hikapu hindatu mbaka ghwoha ghukitutumuka.” ");
INSERT INTO nww_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu kakiaghombela bhandu agha ghoha kwa nhwano. Kakiaghombela ng'obhe kyohele kyanga nhwano. ");
INSERT INTO nww_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ngati lilagho liikambukitwi na mbuye ywa Chapanga libwitukile, “Ndalongela nabho kwa mihwano; ndafwambula ghala ghahihitwe kutandila kubhumbwa kwa nnima aghu.” ");
INSERT INTO nww_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mbole Yesu kakialagha bhala bhandu, na kakiyingila mu nyumba. Ahunda bhake bhakinng'endela na bhakenng'ombela, “Ghutufwambulile ghula nhwano ghwa misapi kunng'unda.” ");
INSERT INTO nww_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu kakiaghombela, “Nkweta mbeyu ywa yila mbeyu ya maha ndo Mwana ywa Mundu. ");
INSERT INTO nww_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ghula nng'unda ndo nnima aghu. Yila mbeyu ya maha ndo bhala bhandu bhene ghubhutwa ndo ghwabhe. Peni yila misapi ndo bhala bhandu bha yula Nchipila. ");
INSERT INTO nww_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nmyanja ywakakwetite ghala misapi ndo Nhipila. Mabeno ndo uhiko ghwa nndaluko na bhanakubena ndo mahoka bha Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Handa bhula misapi payikunganwa na kuyochwa mwoto, ubhwabhu abhu ndo yabhegha manjubha gha uhiko, ");
INSERT INTO nww_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana ywa Mundu kataalaghila mahoka bha Chapanga, nabho bhataakungana kuhuma mu Ghubhutwa ghwake bhala bhoha bhanakuyambuha ulemwa, na bhanakutenda uhokelo, ");
INSERT INTO nww_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","na kubhatagha mu mwoto ghwa lihumbika, na akwo bhaalila na kuhyagha mino kubhukana na mabhino makalipa. ");
INSERT INTO nww_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mbole bhala bhandu bhaatenda ghanakunnogheha Chapanga handa luchubha mughubhutwa bha Tate ghwabhe. Yunamachikilo na kayihwe.” ");
INSERT INTO nww_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ghubhutwa ghwa kunani ghungulihwana na utopelo ghuhihitwe munng'unda, mundu yumu pakang'amulite kakighuhiha kangi. Kakiyelelwa munu mbaka kakighenda kuhemengana hyoha hyakabheghite nahyo, na kakighuhemela nng'unda ghula.” ");
INSERT INTO nww_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Kangi Ghubhutwa ghwa Chapangu ghungulihwana na mundu yumu nhemengana ywakapalaha madini gha lulu. ");
INSERT INTO nww_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pakapatite lulu yimu ya utopelo nkulu, kakighenda kuchuusa hyoha hyakabheghite nahyo na kakiihemela lulu yila.” ");
INSERT INTO nww_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Kangi, Ghubhutwa ghwa kunane kwa Chapanga ghungulihwana na njaho yiitaghitwe na aghomeha homba mulihibha, na yikighomeha homba nhanganganiko. ");
INSERT INTO nww_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Payimemite bhandu bhakiyikwemula pambweha ya lihibha, bhaketama na bhakeahaghula homba bha maha na bhakeabhika mu hikapu hyabhe na bhala bha maha ng'obhe bhakeatagha. ");
INSERT INTO nww_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Habhu ndo yaabhegha linjubha lya kuuhiko, bbaabwitukila mahoka bha Chapanga na bhataabhaghula bhandu ahakata na bhala bha maha, ");
INSERT INTO nww_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","na kuatagha bhala ahokelo mumwoto ghwa lihumbika. Akwo bhaalila na kuhyagha mino.” ");
INSERT INTO nww_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu kakiakonya, “Bhuli, muyimanya fwambulo ya agho ghoha?” Bhakinnyanga, “Ena tuyimanya.” ");
INSERT INTO nww_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ndo kakiaghombela, “Habhu, nhunda ywa Malaghilo gha Musa ywakabhegha nhundwa ywa Ghubhutwa ghwa kunane kwa Chapanga kangulihwana na nkolakaya ywakabhuha muuhanja lwake hilibhi hya hyono na hya makachu.” ");
INSERT INTO nww_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu pakayomolite kulongela mihwano ayi kakibhuka apo, ");
INSERT INTO nww_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","na kakighenda ku kijiji kyake. Akwo kakibhegha kanguahunda bhandu mu nyumba hya ngonganilo hyabhe mbaka bhakikangacha, bhakilongela, “Ayu kaghamokola kwoki malango na mihabho ayi? ");
INSERT INTO nww_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bhuli, ayu chepa yula mwana ywa ntendehi ywa uselemala? Bhuli, mama ywake chepa kangukemwa Malia? Na alongo bhake chepa Yakobu na Yosefu na Simoni na Yuda? ");
INSERT INTO nww_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na ahacha bhake chepa abha bhangutama papamu na twenga? Basi kaghamokola kwoki agha ghoha?” ");
INSERT INTO nww_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ndo bhakinlema. Peni Yesu kakiaghombela, “Mbuyi ywa Chapanga kanguhokamilwa kwoha, ngati chepa mu nnima ghwake mwene na mualongo bhake” ");
INSERT INTO nww_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kya habhu, kakitenda ng'obhe mihabho mitangalo kwakya kulepelwa kuhyubhalila kwab bhombe. ");
INSERT INTO nww_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mumanjubha agho, Mutwa Helode ywa ku Galilaya kakiyihwa mihalo ya Yesu. ");
INSERT INTO nww_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ndo kakiaghombela andumindumi bhake, “Aywo ndo Yohane Yunakubatisa, kahyuka, na makakala gha kutenda mihabho ghangutenda lihengo kwa ywombe.” ");
INSERT INTO nww_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Helonde ndo ywakankamulite Yohane, na kakimmopa na kakinnhwinda mukibbopo kwakya Helodia nhumbu ywa Filipo nnongo ghwake, ");
INSERT INTO nww_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","kiyaha Yohane kakinnongela Helode kukita, “Yingunoghelwa ng'obhe kwa ghwenga kuntola nndala aywo.” ");
INSERT INTO nww_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Helode kakipala kunkoma Yohane, peni kakiayoghopa bhandu kiyaha bhombe, bhakinng'amula kukita Yohane kakibhegha Mbuye ywa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Linjubha limu muchekwa ya kukulungwa kubhelekwa kwake Helode, nhinja ywa Helodia kakikina muulongolo ghwa bhandu mbaka Helode kakiyelelwa munu, ");
INSERT INTO nww_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","hata kakilagha kwa kulapa, kunpegha aywo nhinja kyohele kyakapala kukiyupa. ");
INSERT INTO nww_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Naywo kunu pa akinyeghelehwa na mama ywake, kakilongela, “Ghumbeghe mutwe ghwa Yohane Yunakubatisa mu kipalo.” ");
INSERT INTO nww_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mutwa kakihyongoloka muno, peni kubhukana kila kilapo kyakalapitie muulongolo ghwa bhandu, kakikwilikiha kukita kapeghwe nyupo yake. ");
INSERT INTO nww_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Basi, Helode kakikwilikiha Yohane Yunakubatisa kakadumulighwe mutwe mula mukibhopo. ");
INSERT INTO nww_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mutwe ghwake ghukiyeghwa mu kipalo, na bhakenpegha yula nhinja, naywo kakinnyeghela mama ywake. ");
INSERT INTO nww_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ahundwa bha Yohane bhakihika, na bhakiutola mmili ghwake na bhakighukulila. Mbole bhakighenda kunng'ombela Yesu. ");
INSERT INTO nww_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu pakayihwite mihalo ya kukomwa kwa Yohane, kakibhuka apo kwa bhwato na kakighenda pahala pangali bhandu ngati kabheghe ghweka. Peni bhandu paamanyite kwakaghendite bhakintughila kupitila kuluhingu kuhuma mu hitami. ");
INSERT INTO nww_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Basi, pakahulukiti pambwegha ya luhingu, kakilubhona lumati lukulu lwa bhandu, kakiabhonela luhungu na kakialamiha atamwa bhabhe. ");
INSERT INTO nww_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Payihikite makimuhi, ahundwa bhake bhakinng'endela na bhakinng'ombela, “Apa patubheghite kahone bhandu bhaatama, na luchubha lungutipika. Hinu ghubhalaghe bhandu ngati aghende muhijiji hyabhe bhakalihemelele hilyo.” ");
INSERT INTO nww_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu kakiaghombela, “Bhangunoghwa ng'obhe abhuke Mwenga muapeghe hilyo.” ");
INSERT INTO nww_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Peni bhombe bhakinng'ombela, “Tubhegha nagho mangati nhano ghweka na homba abhili.” ");
INSERT INTO nww_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu kakiaghombela, “Munyeghela apa.” ");
INSERT INTO nww_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kakiakwilikiha bhandu atame mumanyahi, mbole kakighatola ghala mangate nhano na bhala homba abhili, kakilolekeha kunane kwa Chapanga kakighanonela na kakighametulanga, mbole kakiapegha ahundwa bhake agho mangati na bhala homba, nabho ahundwa bhake bhakiapegha bhandu abho. ");
INSERT INTO nww_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bhandu bhoha bhakilyegha na bhakiyukuta. Mbole ahundwa bhakikungana mahighalo na bhakimemekeha hikapu kumi na hibhili. ");
INSERT INTO nww_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mmalango ghwa bhandu bhaalyeghite bhakibhegha alumi elfu nhano, kyanga mmalango ghwa adala na bhana. ");
INSERT INTO nww_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kamu, Yesu kakiakwilikiha ahundwa bhake ayingile mubhwato, bhalongolele kumwambo ya lihibha ywombe pakabheghite mukualagha himati hya bhandu. ");
INSERT INTO nww_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Mbole ya kubhalagha bhandu, kakikwela ku kitumbi ghweka chake kuyupa. Payibheghite makimuhi, ywombe kakibhegha akwo ghweka chake, ");
INSERT INTO nww_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Na mumasaa agho ghula bhwato ghukiheghelela kuhika pakati ya lihibha, peni yikibhegha mumapughwo kwakya liyegha lighuututite. ");
INSERT INTO nww_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pakilo ugheghela na kuchegha, Yesu kakiaghendela ahundwa bhake pakatyanga unani mwa machi. ");
INSERT INTO nww_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ahundwa bhake paammonite pakatyanga unani mwa machi bhakiyoghopa munu, bhakilongela, “Ndo lijini” Bhakiyobha kyobho kwa lyogha. ");
INSERT INTO nww_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kamu, Yesu kakilongela nabho, “Ntetebhale. Ndo nenga nkotoke kuyoghopa” ");
INSERT INTO nww_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petili kakinng'ombela, “Bambo, handa ndo ghwenga hoto, ghung'ombele hike kwaghwenga ndyange unani mwa machi.” ");
INSERT INTO nww_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu kakinng'ombela, “Ghuhike!” Basi, Petili kakihuluka mubhwato na kakityanga mumachi kakinng'endela Yesu. ");
INSERT INTO nww_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Peni pakabhonite likusi kakiyingilwa na lyogha, naywo kakiyanda kudibala, kunu pakayobha kyobho, “Bambo, ghunopohe.” ");
INSERT INTO nww_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kamu, yesu kakigholoha kibhoko kyake na kakinkamula na kakinng'ombela, “Ghwenga ghwa uhyubhalilo nchoko, kya bhuli ghukibhegha na lyogha?” ");
INSERT INTO nww_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Na paakwelite mu bhwato likusi likiyima. ");
INSERT INTO nww_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ndo bhoha bhaabheghite mubhwato bhakintundamila Yesu paalongela, “Kulyaghila ghwenga ndo Mwana ywa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bhakiyomboka lihibha na bhakihika ku nnima ghwa Genesaleti ");
INSERT INTO nww_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bhandu bha akwo pabhanmanyite kukita ndo Yesu, bhakikweha nhalo aghwo kwoha mu nnima aghwo. Habhu, bhakinnyeghela atamwa bhoha, ");
INSERT INTO nww_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bhakinnyupa kabhategheke anbyale nga lupindo lwa lipinda lyake, nabho bhoha bhaanbyalite bhakilamihwa. ");
INSERT INTO nww_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mbole, amoo bha Afalisayu na ahunda bha Malaghilo bhakihika kuhuma ku Yelusalemu, bhakinhikila Yesu na bhakinkonya. ");
INSERT INTO nww_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kyabhuli ahundwa bhako bhangughakiluka mahundo gha ahunda bhetu bha makachu? Mana bhombe bhangukuha ng'obhe muhinoghwa handa hitohe hyetu, kukali ya kulyegha.” ");
INSERT INTO nww_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu kakiayanga, “Kyabhuli na mwenga munguyitikila ng'obhe Malaghilo gha Chapanga kwakya mahundo gha aghohi bhenu? ");
INSERT INTO nww_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kiyaha Chapanga kakilongela, ‘Ghubhahokamile Tate na mama ywako na ywakanligha tate ebhu mama ywake, kakomwe.’ ");
INSERT INTO nww_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Peni mwenga munguhunda kukita, handa mundu abhegha na kilibhi kya kuntangatila tate ywake ebhu mama ghwake, peni kalongela, ‘Aki kya Chapanga.’ ");
INSERT INTO nww_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Basi, munguhunda ghungunoghwa ng'obhe kunhokamila tate ebhu mama ywako kwa kuntangatila kumpegha kilibhi akyo. Ndo pamuliyuyuha Lilagho lya Chapanga kwa kutughila mahundo ghenu mabhene. ");
INSERT INTO nww_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mwenga maafyangu. Isaya kakilondola tela yakya mwenga pakalongela, ");
INSERT INTO nww_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Chapanga kangulongela bhandu abha bhangulongela bhanguhokamila, peni myoyo yabhe yibhegha kutali na nenga ");
INSERT INTO nww_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kutundamila kwa bhombe kungutangatila ng'obhe kilibhi, bhanguhunda mahundo ghaayandihitwe na bhandu ghweka, na chepa mahundo gha nenga.’ ” ");
INSERT INTO nww_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu kakilukema lula lumati lwa bhandu na kakiaghombela, “Nnyihwanile na mmanye. ");
INSERT INTO nww_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kiintenda mundu kakotoke kuyitikilwa kubhegha muulongolo ghwa Chapanga, chepa kila kiinnyingila mu nnomo ghwake, ngati ndo malagho ghanakummuka munnomo ghwake.” ");
INSERT INTO nww_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Mbole ahundwa bhake bhakinng'endela na bhakinng'ombela, “Ghungumanya kukita akaafalisayo bhakekalala munu paayihwite mihalo yila yighuyikambukite?” ");
INSERT INTO nww_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Peni ywombe kakiayanga, “Mmela ghwohele ghuupanditwe ng'obhe na Tate ywangu ywa kunane, ghwatupulwa. ");
INSERT INTO nww_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mubhaleke bhene, mana bhombe ndo hilongohi bha bhangabhona, bhaabhalongoha bhangabhona ayabhe. Na handa ywangalbhona katanlongoha ywangabhona nnyaki, bhoha abhili bhaachumbukila mulibhumba.” ");
INSERT INTO nww_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petili kakilongela, “Ghutufwambulile mana ya nhwano agho.” ");
INSERT INTO nww_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu kakiakonya, “Hata mwenga nkali kang'amula? ");
INSERT INTO nww_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Bhuli, mungumanya ng'obhe kukita kyohele kiyingiliti mu nnomo kyaghenda mu lutumbo na mbole kyabhuhwa panje kupitila mumahi? ");
INSERT INTO nww_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Peni kila kihuma mu nnomo kinguhuma mu mwoyo, na akyo ndo kinguntenda mundu kakotoke kuyitikilwa muulongolo ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kiyaha mu mwoyo ghanguhuma mahwacho gha uhakata, kukoma, utyahe, ungongola, bhwihi, uyimiho ghwa uhwangi na maligho. ");
INSERT INTO nww_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Agho ndo ghanguntenda mundu kakotoke kuyitikilwa kubhegha muulongolo ghwa Chapanga, peni kulyegha kyangakuha mabhoko kunguntenda ng'obhe mundu kakotoke kuyitikilwa kubhegha muulongolo ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu kakibhuka pala na kakighenda ku milima yiibheghite ugheghela na mbande hya Tilo na Sidoni. ");
INSERT INTO nww_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Basi, nndala yumu ywa ku Kaanani ywakatamite ugheghela na mbande ahyo kakinhikila Yesu, kakiyobha kunu pakalongela, “Ghummonele luhungu Bambo, Mwana ywa Daudi, nhinja ywangu kakwelwa na lindilu na kangupamandika munu.” ");
INSERT INTO nww_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Peni Yesu kakiyanga ng'obhe lilagho. Ndo ahundwa bhake bhaking'endela paannyupa munu, bhakenng'ombela, “Ghunng'ombele kaghende kiyaha kangugendelela kutututila kyobho.” ");
INSERT INTO nww_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu kakiayanga, “Naghilwa kwakya kualopoha mene bha Chapanga bhaahobhite, bhandu bha Isilaeli.” ");
INSERT INTO nww_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Peni yula nndala kakihika, pakanchutama mayughwa mukulongolo ghwa Yesu, pakalongela, “Bambo ghundange.” ");
INSERT INTO nww_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu kakinnyanga, “Yibhegha maha ng'obhe kuhitola hilyo hya bhana na kuataghila galu.” ");
INSERT INTO nww_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yula nndala kakinnyanga, “Kulyaghila Bambo, peni hata galu bhangulyegha mahighalo ghaahighalo gha abambo bhabhe.” ");
INSERT INTO nww_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ndo Yesu kakinng'ombela, “Nndala, kuhyubhalo kwa ghwenga kubhegha kukulu, yabheghe kwa ghwenga handa mughupala.” Naywo nhinja ywake kakilama kutandila lisaa lila lila. ");
INSERT INTO nww_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu kakibhuka apo na kakighenda mumbweghambweha ya lihibha lya Galilaya, kakikwela kitumbi na kakitama. ");
INSERT INTO nww_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bhandu atangalo bhakinhikila, bhakiayegha atebhalo, ngwabhengwabhe, bhangbhonaa, bhangayihwa, na bhangi atangalo, bhakiatamika mu ulongolo ghwa maghulu ghake naywo Yesu kakialamiha. ");
INSERT INTO nww_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bhandu abho bhakikangacha muno paabhonite bhangalongela bhangulongela, atebhalo bhakilamihwa, ngwabhengwabhe bhangutyanga na bhangalola bhangubhona, bhakinkweha Chapanga ywakatundamilwa na Akaaisilaeli. ");
INSERT INTO nww_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Basi, Yesu kakiakema ahundwa bhake kakiaghombela, “Nungulubhonela luhungu lumati alu lwa bhandu, kiyaha abhegha na nenga kwa manjubha mandatu na abhegha ng'obhe na hilyo hyohele hiihighalite, na nenga mbala ng'obhe kubhalagha paabhegha na njala ngati akotoke kuhima mu njila.” ");
INSERT INTO nww_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ahundwa bhake bhakinkonya, “Apa tubhegha pangabhandu, twamokola kwoki hilyo hya kuakwila bhandu abha bhoha?” ");
INSERT INTO nww_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu kakiakonya, “Mmegha na mangati malingi?” Bhakinnyanga, “Mangate saba na hihomba hyamandina.” ");
INSERT INTO nww_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu kakilughombela lula lumati lwa bhandu atame pahi. ");
INSERT INTO nww_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kakighatola ghala mangate saba na hila hihomba hyamandina, kakinnumba Chapanga, kakihimetula na kakiapegha ahundwa bhake, nabho bhakiaghabhila bhandu. ");
INSERT INTO nww_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bhoha bhakilyegha na kuyukuta, mbole ahundwa bhake bhakikungana mahighalo na bhakimemekeha hikapu saba. ");
INSERT INTO nww_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bhala bhaalyeghiti bhakibhegha alumi elfu ncheche, kyanga kubhalangwa adala na bhana. ");
INSERT INTO nww_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ndo Yesu kakialagha bhandu, kakihubhuka mu bhwato na kakighenda ku mbande ya Magadani. ");
INSERT INTO nww_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Amoo bha Afalisayo na Asadukayo bhakinhikila Yesu na kung'eha kwa kunnyupa kabhatendele naho kuhuma kunane kwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Peni Yesu kakiayanga, “Payihika makimuhi mwenga mungulongela, ‘Kilabho kwaachegha maha, mana bhwelo lubhegha nkele.’ ");
INSERT INTO nww_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na malabhila mungulongela ‘Lelo kwabhegha na hula, kiyaha bhwelo lubhegha lukele na mahundi ghabhegha totolo.’ Basi, mwenga mungumanya muno kufwambula midaluko kwa kulola bhwelu, peni mungulepelwa kumanya mmoneho ghwa naho ghabhoneka manjubha agha. ");
INSERT INTO nww_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kibheleko kya bhandu ahokelo na kyangali kuhyubhalika kwa Chapanga! Kingupala naho, peni kyapeghwa ng'obhe naho yohele ngati kyapeghwa yila naho ya Yona ghweka.” Yesu kakialeka na kakibhuka. ");
INSERT INTO nww_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ahundwa bha Yesu pabhayombokite kumwambo ya lihibha, bhaking'amula kukita bhakilibhala kutola mangate. ");
INSERT INTO nww_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu kakiaghombela, “Mulindakile mulikingikihe na amila ya Afalisayo na Asadukayo.” ");
INSERT INTO nww_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bhombe bhakiyanda kughombana bhombe kwa bhombe, paalongela, “Kangulongela habhu kiyaha tutola ng'obhe mangate.” ");
INSERT INTO nww_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu kakimanya kyakabheghite mukulongela, ndo kakiaghombela, “Mwenga bhandu mummeghite na uhyubhalilo nchoko! Bhuli, mungughombana kyangali kutola mangate? ");
INSERT INTO nww_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Bhuli, nkali kumanya? Bhuli mungukulugwa ng'obhe pametulite ghala mangate nhano bhakelyegha bhandu elfu nhano? Bhuli, mukimemekeha mahighalo hikapu hilingi? ");
INSERT INTO nww_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ebu ghala mangate saba bhakeghabhilwa bhandu elfu ncheche, bhuli mukikungana mahighalo gha hikapu hilingi. ");
INSERT INTO nww_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Bhuli mukimanya ng'obhe kukita nikibhegha nungulongela ng'obhe na mwenga yakya mihalo ya mangate? Mulindakile na amila ya Afalisayo na Asadukayo. ");
INSERT INTO nww_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Apo ndo ahundwa bhakimanya kukita kangulongela ng'obhe kwakya amila ya kutendekeha mangate, ngati kwakya mahundo gha Afalisayo na Asadukayo.” ");
INSERT INTO nww_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu pakahikite mbande ya Kaisalia Filipi, kakiakonya ahundwa bhake, “Bhandu bhangulongela kukita Mwana ywa Mundu ndo ghani?” ");
INSERT INTO nww_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bhakinnyanga, “Bhangi bhangulongela kukita ndo Yohane Yunakubatisa, bhangi Eliya, bhangi Yelemia ebu yumoo ywa akaambuye.” ");
INSERT INTO nww_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesu kakiakonya, “Bhuli, mwenga mungulongela kukita nenga ndo ghani?” ");
INSERT INTO nww_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Petili kakinnyanga, “Ghwenga ndo Kilisto, Mwana ywa Chapanga ywakabheghite na ubhumi.” ");
INSERT INTO nww_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu kakilongela, “Mbaha ghwenga, Simoni mwana ywa Yona, kiyaha kahone mundu ywohele nhalo aghu, ngati Tate ywangu ywa Kunane ywakakubhonehite. ");
INSERT INTO nww_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na nenga ningukughombela, ghwenga ndo Petili na mulitalabha ali ndachenga ngwemuko lya bhandu bhanakunhyubhalila Kilisto, kangi makakala gha kiho ghatalihotola ng'obhe. ");
INSERT INTO nww_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ndakupegha kihughulilo kya Ubhutwa ghwa kunane, ngati lyohele lighulitata mu nnima, lyaatatwa na Kunane, na lyohele lighukihughula mu nnima, lyahughulighwa na Kunane bhubho.” ");
INSERT INTO nww_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mbole kakiaghombela ahundwa bhake akotoke kunng'ombela mundu ywohele kukita ywombe ndo Kilisto. ");
INSERT INTO nww_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kutandila manjubha agho Yesu kakiyanda kuaghombela ahundwa bhake kukita yingunkwiliha kughenda ku Yelusalemu, na kumokola hibamanda hitangalo kwa mayambuho gha aghohi, akulu bha andundame na ahunda bha malaghilo na kukita yaannogha kuhwegha na linjubha lya ndatu katahyuka. ");
INSERT INTO nww_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Apwo Petili kakintola pambwegha na kakiyanda kunlakalila, kakilongela, “Chapanga kaghatakulile kutali milando ayi, milando ayi yikotoke kukubwitukila.” ");
INSERT INTO nww_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu kakinng'alambukila kakinng'ombela Petili, “Ghubhuke muulongolo gwangu, Nchipila. Ghwenga ndo kipingiko kwanenga. Ghwenga ghunguhwacha ng'obhe gha Chapanga ngati gha anabhandu.” ");
INSERT INTO nww_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Mbole, Yesu kakiaghombela ahundwa bhake, “Mundu ywohele ywakapala kubhegha nfwasi ywangu, yingunkwiliha kalileme mwene, kalutole lupingika lwake na kandughile. ");
INSERT INTO nww_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kiyaha ywohele ywakapala kughulopoha ubhumi ghwake kataghuhobheha. ");
INSERT INTO nww_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Peni mundu ywakaghuhobheha ubhumi ghwake kwakya nenga kataghumokola. Bhuli, mundu katamokola niki handa pakaghumukola utopelo ghwoha ghwa unnima na kunu kanguhobheha ubhumimi ghwake? Ebu mundu katabhuha kilibhi ghani kihyengo kya ubhumi ghwake? ");
INSERT INTO nww_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kiyaha Mwana ywa Mundu katahika mu ukulu ghwa Tate ghwake papamu na mahoka bhake, na apo katankamuha kila mundu kubhukana na mandendelo ghake. ");
INSERT INTO nww_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nunguaghombela hoto, Abhegha bhangi bahapa apa bhene bhaahwegha ng'obhe kukali na kummona Mwana ywa Mundu pakahika mu Ghubhutwa ghwake.” ");
INSERT INTO nww_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mbole ya manjubha sita Yesu kakiatola Petili, na Yakobu na Yohane nnongo ghwake, kakighenda nabho mbaka kunane mwa kitumbi kitandamaho akwo akibhegha ghweka chabhe. ");
INSERT INTO nww_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Akowo Yesu kakighalambuka kibhungi muulongolo ghwabhe, kibhungi kyake kiking'ala handa lichubha na mapinda ghake ghakibhegha ghambulete handa lung'ali. ");
INSERT INTO nww_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kamu, bhala ahundwa andatu bhakiabhona Musa na Eliya, paayobhela na Yesu. ");
INSERT INTO nww_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Apwo Petili kakinng'ombela Yesu, Bambo, nungubhona maha twenga tutame apa. Na handa ghwapala ndachenga hibanda hindatu, kimu kyako, kingi kya Musa na kingi kya Eliya. ");
INSERT INTO nww_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pakabheghite kakali pakalongela agha lihundi liing'anyimiti, likiagubika na lilobhe likilongela kuhuma mulila lihundi, “Ayu ndo Mwana ywangu yunumpala, yunyelilitwi naywo munu, mu nnyihwe ywombe.” ");
INSERT INTO nww_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Bhala ahundwa paaghayihwite agha bhakeghwegha pahi makukama, na bhakeyingilwa na lyogha. ");
INSERT INTO nww_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Peni Yesu kakihika na kuabyala kakiaghombela, “Nkotoke kuyoghopa nnyinuke.” ");
INSERT INTO nww_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pabhayinulite meho ghabhe, bhakimmona ng'obhe mundu yungi ywohele ngati ndo Yesu ghweka. ");
INSERT INTO nww_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Paabheghite mukuhuluka ku kitumbi, Yesu kakialaghila, “Nkotoke kunng'ombela mundu ywohele mabhono agha ghamughabhonite, mbaka Mwana ghwa Mundu pakahyuka kuhuma mu kiho.” ");
INSERT INTO nww_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Bhala ahundwa bhakinkonya, “Kya bhuli ahunda bha malaghilo bhangulongela kukita yingunkwiliha Eliya kahike huti?” ");
INSERT INTO nww_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu kakiayanga, “Aywo ndo hoto, yingunkwiliha Eliya kahike huti kutendekeha milando hyoha. ");
INSERT INTO nww_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Peni nunguaghombela, Eliya kahika kala, nabho bhandu bhakimmanya ng'obhe, na bhakintendela ghoha ghabhaghapalite. Ubhwabhu abhu Mwana ywa Mundu katapamandwa mu mabhoko ghabhe.” ");
INSERT INTO nww_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ndo bhala ahundwa bhakimanya kukita kakibhegha kanguyobhela nabho mihalo ya Yohane Yunakubatisa. ");
INSERT INTO nww_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pabhahikite mu lumati lwa bhandu, mundu yumu kakinhikila Yesu na kunchutamila mayughwa muulongolo ghwake, ");
INSERT INTO nww_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","kakilongela, “Bambo, ghummonele luhungu mwana ywangu. Ywombe kanakihilika na kangubamandika munu. Maghenda maghenda kangughwegha mu mwoto ebhu mu machi. ");
INSERT INTO nww_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nikinnyegha kwa ahundwa bhako peni bhakelepelwa kunlamiha.” ");
INSERT INTO nww_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu kakiyanga, “Mwenga kibheleko kyanga kuhyubhalila na kiihobhite, ndaatama na mwenga mbaka pakiki? Munnyeghe nhongolo apa kwa nenga.” ");
INSERT INTO nww_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu kakililakalila lila lindilu, nalyo likimmuka yula nhongolona kakilama lisaa lila lila. ");
INSERT INTO nww_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mbole, ahundwa bhake bhaking'endela Pahala paabheghite bhombe ghweka chabhe, na bhakinnkonya, “Kiyaha niki twenga tukilepelwa kulibhuha lila lindilu?” ");
INSERT INTO nww_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu kakiayanga, “Kubhukana na kuyubhalila kwa mwenga kuchoko. Nunguaghombela hoto, pammegha na kuhyubhalila kuchoko handa mbunje ya nkongo nhaladali, maahotola kukighombela kitumbi aki, ‘Ghubhuke apa ghughende pala,’ nakyo kyaabhuka. Hangi kahone nnando ghwangahotoleka kwa mwenga. ");
INSERT INTO nww_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Lindilu handa ali, habhu lyabhuka kata kyangali kuyupa na kulikunga.” ");
INSERT INTO nww_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Linjubha limu paabheghite bhangutama papamu na ahundwa bhake akwo Galilaya, Yesu kakiaghombela, “Mwana ywa Mundu katakamuhwa mu mabhoko gha bhandu. ");
INSERT INTO nww_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nabho bhatankoma na linjubha lya ndatu katahyuka.” Ahundwa bhake bhakihyongoloka munu. ");
INSERT INTO nww_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mbole ya Yesu na ahundwa bhake kuhika ku Kapelinaumu, asumula sumu ya Nyumba ya Chapanga bhakinnhikila Petili na kunnkonya, “Bhuli, nhunda ywenu kanguhomba sumu ya Nyumba ya Chapanga?” ");
INSERT INTO nww_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petili kakiayanga, “Ena, ywombe kanguhomba.” Petili pakabhuyite ukaya kukali hata na kunng'ombela kilibhi, Yesu kakiyanda kunkonya, “Ghwenga ghungumanya niki Simoni? Abhatwa bha nnima bhangupongola mapongolo na sumu kuhuma kwa aghani? Bhuli, kuhuma kwa akola nnima bhabe ebu kwa ahenja?” ");
INSERT INTO nww_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petili kakinnyanga, “Kuhuma kwa ahenja.” Yesu kakinng'ombela, “Hinu akola nnima bhabhe bhalekekehwa. ");
INSERT INTO nww_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Peni ngati tukotoke kuakalaliha myoyo yabhe, ghughende ku lihibha ghukataghe ndoana. Ghuntole homba ywa ulongolo ghuunng'omeha, ghubakatule nnomo ghwake, amwo ghwayibhona ngalabha, ghuyitole ghukahombe sumu ya ghwenga na nenga.” ");
INSERT INTO nww_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mu manjubha ghala ahundwa bha Yesu bhaking'endela na bhakinkonya, “Ywoki ywakabhegha nkulu mu Ghubhutwa ghwa kunane?” ");
INSERT INTO nww_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu kakinkema mwana yumu, na kakinnyimiha pakati yabhe, ");
INSERT INTO nww_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","mbole kakilongela, “Nunguaghombela hoto, handa panng'alambuka ng'obhe kubhegha handa bhana, maayingila ng'obhe mu Ghubhutwa ghwa kunane. ");
INSERT INTO nww_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ywohele ywakalihuluha handa mwana ayu, aywo ndo kaabhegha nkulu mu Ghubhutwa ghwa kunane. ");
INSERT INTO nww_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ywohele yunakunkingama mwana nchoko handa ayu kwakya nenga, kangungingama nenga.” ");
INSERT INTO nww_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Handa mundu ywohele kangunnyambuha yumoo ywa bhana adoko abha bhaanakuhyubhalila nenga atende ulemwa, yingabheghite mbaha kwa ywombe kabhopwe libho likulu lya kuhyaghila mu nntandala ghwake na kadibahwe mu machi njulwa gha lihibha. ");
INSERT INTO nww_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mutakibhona bhandu bha nnima aghu kubhukana na milando ya yinakuyambuha bhandu bhangi atende ulemwa. Milando ayi mbaka yibheghe, peni kimmone yula ywakayiyambuha.” ");
INSERT INTO nww_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Handa kibhoko ebu kighulu kyako kingukuyambuha kutenda ulemwa, ghukidumule na ghukakitaghe kutali na ghwenga. Yibhegha mbaha kwa ghwenga kuyingila mu ubhumi paghubhegha ng'obhe na kibhoko kimu ebu kighulu kimo, peni chepa kutaghwa mu mwoto paghuhegha na mabhoko mabhili ebu maghulu mabhili. ");
INSERT INTO nww_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na liho lyako palikuyambuha ghutende ulemwa ghulikopole na kulitagha kutali. Yibha mbaha kwa ghwenga kuyingila mu ulami na liho limo, peni chepa kutaghwa mu mwoto gha manjubha ghoha ghwanga kuhimika paghubhegha na meho mabhili.” ");
INSERT INTO nww_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Mulindakile, nkotoke kumpughana yumoo ywa adoko abha. Nunguaghombela, mahoka bhabhe akwo kunane abhegha manjubha ghoha muulongolo ghwa Tate ywangu ywa kunane. ");
INSERT INTO nww_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kiyaha Mwana ywa Mundu kakihika kualopoha bhala bhaahobhite.” ");
INSERT INTO nww_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mungubhona bhuli? Handa mundu kabhegha na mene mia yimu, na yumu mubhala pakahobha, kataaleka ng'obhe bhala tisini na tisa ku kitumbi na kughenda kunnonda yula yumu ywakahobhite? ");
INSERT INTO nww_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nunguaghombela hoto pakammona, katayelelwa kyanalumu kwakya aywo mene yumu kupitingana kwa bhala tisini na tisa bhangahobha. ");
INSERT INTO nww_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ubhwabhu abhu Tate ywenu ywa kunane kangupala ng'obhe hata yumu mu abha adoko kahobhe.” ");
INSERT INTO nww_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Handa nnongo ywako kaghuhokela, ghughende ghukammonehe uhokelo ghwake pammegha abhili ghweka chenu. Handa katakuyihwa ghwammokola kangi nnongo ghwako. ");
INSERT INTO nww_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Handa kaghuyihwa ng'obhe, ghuntole mundu yumu ebu abhili papamu na ywombe, ngati kwa mahwacho gha bhandu abhili ebu andatu nnando ghwohele ghuyimihwe. ");
INSERT INTO nww_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Handa pakalema kuayihwa abho ghulighombele ngwemuko ya bhandu bhaanhyubhalila Kilisto na abho ayimiho abhili, handa pakalema kuliyihwa ngwemuko alyo, aywo kabheghe kwa ghwenga handa mundu ywangammanya Chapanga na nsumula sumu.” ");
INSERT INTO nww_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nunguaghombela hoto, kyohele kimukitata munnima, kyatatwa kunane, na kubhopa mu nnima kyabhopoleghwa kunane.” ");
INSERT INTO nww_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Kangi nunguaghombela, handa abhili mumwenga, bhaayitikilana munnando ghwohele ghwa kuyupa, bhaatendelwa na Tate ywangu ywa kunane. ");
INSERT INTO nww_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kiyaha pohele pala paakwemuka bhandu abhili ebu andatu kwakya nenga, nenga mmegha pakati yabhe.” ");
INSERT INTO nww_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mbole Petili kakinkonya Yesu, “Bambo, nnongo ghwangu kanhokele mala hilingi na nenga nunlekekehe? Bhuli, mala saba?” ");
INSERT INTO nww_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu kakinnyanga, “Nungukughombela ng'obhe mala saba ghweka, ngati saba mala sabini. ");
INSERT INTO nww_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kiyaha Ghubhutwa ghwa kunane ghungulihwana na mutwa yumu ywakapalite kukaghula mmalango ghwa ngalabha hyake na andumindumi bhake. ");
INSERT INTO nww_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pakayandite kutenda mmalango ghwa ngaabha hyake, mundu yumu ywakabheghite na lighambo lya hichako elfu kumi hya sahabu, kakiyeghwa kwa ywombe. ");
INSERT INTO nww_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kiyaha aywo mundu kakibhegha ng'obhe na kya kubhuyiha lila lighambo, bambo ywake kakikwilikiha kachuhuswe ywombe, nhumbu ywake, bhana bhake na hyoha hyakabheghite nahyo ngati lila lighambo libhuyihwe. ");
INSERT INTO nww_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Yula nndumindumi kakinchutamila mayughwa pakannyupa yula bambo pakalongela, ‘Nungukuyupa ghunimbilile, na nenga ndalibhuyiha lighambo ali’ ");
INSERT INTO nww_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Yula bambo ywa yula nndumindumi kakimmonela luhungu, na kakililekekeha lighambo lyake lyoha na kakinneka kaghende.” ");
INSERT INTO nww_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Peni yula nndumindumi pakabheghite mu kubhuka panje, kakikongana na nndumindumi nnyake ywakannyahikilite ligwala mia yimu ya madini gha fesa. Kakinkamula, kakintita ntandala na pakinng'ombela, ‘Ghummuyihile kila kinukuyahikiti.’ ");
INSERT INTO nww_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Yula nndumitumi nnyaki kakichutamila mayughwa, pakinnyupa, ‘Nungukuyupa ghunimbilile, na nenga ndakuhomba lighambo lyako lyoha.’ ");
INSERT INTO nww_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Peni kakilema. Kihyengo kyake, kakighenga kunhwinda mukibhopo mbaka pakabhuyiha lila lighambo. ");
INSERT INTO nww_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Andumindumi ayake paabhonite ghaabwitukilite, bhakikalala munu, nabho bhakighenda kunng'ombela bambo ghwabhe milando hyoha yiibwitukite. ");
INSERT INTO nww_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ndo yula bambo kakinnkema yula nndumindumi na kakinng'ombela, ‘Ghwenga nndumindumi nhakata. Nenga nikighulekekeha lighambo lyako lyoha paghunyupite. ");
INSERT INTO nww_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Bhuli, yikikungogha ng'obhe kunmonela luhungu nndumindumi nnyako handa nenga panughubhonilite luhungu?’ ");
INSERT INTO nww_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kwa kiyaghabhu yula bambo ghwake kakinkamuha yula nndumindumi ghwake kwa machonda bha kibhopo ngati kapamandwe mbaka pakahomba lighambo lyoha lyakayahikitwe.” ");
INSERT INTO nww_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu kakiyomolela pakalongela, “Habhu ndo Tate ywangu ywa kunane katantendela ywohele mu mwenga handa katanlekekeha ng'ohe nnongo ywake ywakanhokelite kuhuma mumwoyo.” ");
INSERT INTO nww_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu pakayomolite kulongela malagho agho, kakibhuka Galilaya na kakighenda ku Yudea, kumwambo ya lukemba lwa Yoludani. ");
INSERT INTO nww_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Lumati lukulu lwa bhandu lukinntughila, naywo Yesu kakialamiha ukwaku ako. ");
INSERT INTO nww_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Amoo bha Afaliayu bhaknhikila bhankonye kyakuntegha, “Bhuli, yibhegha tela kwa nngwana kumpegha nhumbu ywake lihamba lya kulekana kwa nnando ghwohele?” ");
INSERT INTO nww_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu kakiayanga, “Bhuli, mukisoma ng'obhe mumalemba gha Chapanga kukita kundandila makachu apo, Chapanga kakiabhumba mundu nngwana, na mundu nhumbu. ");
INSERT INTO nww_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Chapanga kakilongela, ‘Kya habhu, mundu katanneka tate ywake na mama ywake naywo bhaalungana na nhumbu ywake na abho abhili bhaabhegha mmili ghumu.’ ");
INSERT INTO nww_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Habhu, abho chepa abhili kangi, ngati abhegha mmili ghumu. Kya abhu kila kyakakilungite Chapanga, mundu kakotoke kughabhaniha.” ");
INSERT INTO nww_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Peni bhombe bhakinkonya, “Kiyaha niki Musa kakilaghila kukita mundu katanpegha nhumbu ywake lihamba lya kuleka na kunneka?” ");
INSERT INTO nww_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu kakiayanga, “Musa kakiategheka kualeka ahumbu bhenu kubhukana na unonopo ghwa myoyo yenu. Peni kutandila makachu yikibhegha habhu ng'obhe. ");
INSERT INTO nww_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nenga nunguaghombela, mundu ywohele ywakanneka nhumbu ywake, manipangi kwa kutenda utyahe ghweka, pakatolela nhumbu yungi aywo kangutenda utyahe. Naywo ywakatolela yula nhumbu ywakalekitwi kangutenda utyahe ubhwabhu abhu.” ");
INSERT INTO nww_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ahundwa bhake bhakinng'ombela, “Handa milando yene ndo habhu kwa nngwana na nhumbu, mbaha mundu kakotoke kutolela.” ");
INSERT INTO nww_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu kakiaghombela, “Chepa bhandu bhoha bhanakuhotola kulikingama lilagho ali, ngati kwa bhala ghweka bhanakutangatilwa na Chapanga kutenda habhu. ");
INSERT INTO nww_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mana kubhegha bhaaponekiliywe na lukuhu kiyaha abhelekwa habhu, bhangi atendwa habhu na bhandu, na bhangi bhalitenda habhu kwakya Ghubhutwa ghwa kunane. Ywombe ywakahotola kulikingama lilagho ali na kalikingame.” ");
INSERT INTO nww_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mbole, amoo bhandu bhakennyeghela Yesu bhana adoko ngati kabhayabhikile mabhoko ghake mu mitwe yabhe na kubhayupila. Peni ahundwa bhake bhakialakalila bhala bhaabhayeghite bhana. ");
INSERT INTO nww_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu kakilongela, “Mualekeke bhana adoko ahike kwa nenga, nkotoke kuakanikiha, kiyaha Ghubhutwa ghwa Kunane ndo ghwa bhala bhaabheghite handa bhana abha.” ");
INSERT INTO nww_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Naywo kakiayabhikila mabhoko ghake mu mitwe yabhe, mbole, kakibhuka akwo. ");
INSERT INTO nww_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mundu yumu kakinhikila Yesu na kakinkonya, “Nhunda ywa maha, ndende nnando ghani ghwa maha ngati mokole ubhumi ghwa manjubha ghoha kyanga uhiko?” ");
INSERT INTO nww_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu kakinng'ombela, “Kiyaha niki ghungungema ywa maha? Kahone ywakabhegha ywa maha nga Chapanga ghweka chake. Peni paghupala kuyingila mu ubhumi ghuyitikile ngwilikiho.” ");
INSERT INTO nww_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yula mundu kakinkonya, “Ngwilikiho hyoki?” Yesu kakinnyanga, “Kukoma kata, utyahe kata, kuyibha kata, uyimiho ghwa uhwangi kata, ");
INSERT INTO nww_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ghubhayitikile tate ywako na mama ywako, na ghunpale nnyako handa paghulipala ghumwene.” ");
INSERT INTO nww_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Yula nhongolo kakinng'ombela, “Agha ghoha nighakamula kala, ndende niki kangi?” ");
INSERT INTO nww_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu kakinng'ombela, “Handa paghupala kubhegha ntwihiiko, ghughende ghukahemengane hilibhi hyoha highubheghite nahyo na ngalabha ahyo ghukaapeghe kapukwa, na ghwabhegha na utopelo ghwa kunane kwa Chapanga, mbole ghuhike ghundughile.” ");
INSERT INTO nww_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yula nhongolo pakayihwite agho, kakighenda kunu pakahyongoloka, kiyaha kakibhegha na utopelo ntangalo. ");
INSERT INTO nww_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ndo Yesu kakiaghombela ahundwa bhake, “Kulyaghila nunguaghombela, yabhegha unonopo kwa yunautopelo kuyingila mu Ghubhutwa ghwa kunanie kwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nungubhuyila kuaghombela, yabhegha uyeyebhu kwa nnyama ywakakemwa ngamia kupita mu lilanga lya sasia peni chepa kwa yunautopelo kuyingila mu Ghubhutwa ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ahundwa bhake paayihwite agho bhakikangacha munu na bhakinkonya, “Ndo ghani hino kaahotola kulopoka?” ");
INSERT INTO nww_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Peni Yesu kakialolekeha na kakiaghombela. “Kwa anabhandu nnando aghu ghwaahotoleka kata, peni kwa Chapanga milando hyoha yinguhotoleka.” ");
INSERT INTO nww_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ndo Petili kakinnyanga, “Ghulole, twenga tuhileka hyoha na kughutughila ghwenga, twaamokola niki?” ");
INSERT INTO nww_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu kakiaghombela, “Kulyaghila nunguaghombela, Mwana ywa Mundu pakapala kutama mukiteho kyake kya Utabhala kya ukulu mu unnima ghwa hyono, mwenga mundughilite maatama mu hiteho kumi na ibhili pamuatosa kabila kumi na ibhili hya Isilaeli. ");
INSERT INTO nww_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na ywohele ywakalekite nyumba ebu nnongo ebu nhacha ebu tate ebu mama ghwake ebu bhana bhake ebu mighunda, kwakya nenga, katamokola mala mia yimu kuchweha, na katapeghwa ubhumi ghwa manjubha ghoha ghangapela. ");
INSERT INTO nww_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Peni atangalo bhaabheghite bha kalongohi bhaabhegha bha uhiko na bhaabheghite bha uhiko bhabhegha bha kalongohi.” ");
INSERT INTO nww_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ghubhutwa ghwa kunane ghungulihwana na mundu ywakabheghite na nng'unda ghwa misabibu, ywene kakibhuka malabhila putiputi kuabhika atendalihengo mu nng'unda ghwake. ");
INSERT INTO nww_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kakilingana nabho kuapegha ligwala limu lya madini gha fesa kwa linjubha, mbole, kakiayegha ku nng'unda ghwake ghwa misabibu. ");
INSERT INTO nww_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Payihikite musaa ndatu malabhila, kakiabhona bhandu bhangi bhaabheghite ng'obhe na lihengo lya kutenda, ayima mu ligulio. ");
INSERT INTO nww_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kakiaghombela, ‘Nng'ende mukatende lihengo munng'unda ghwangu ghwa misabibu, na nenga ndabhapegha kiibhanoghwa.’ ");
INSERT INTO nww_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Basi, bhakighenda. Aywo nkola nng'unda kakibhuka kangi payihikite saa sita na bhubho saa tisa kakitenda ubhwabhu habhu. ");
INSERT INTO nww_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hata payihikite saa kumi na yimu makimuhi, kakibhuka kangi, kakiabhona bhandu bhangi bhaayima pala paligulio. Basi, kakiakonya, ‘Kiyaha niki muyima apa leghi leghi tipi kyanga lihengo?’ ");
INSERT INTO nww_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bhakinnyanga, ‘Kiyaha kakibhegha ng'obhe mundu ywakatupeghite lihengo lya kutenda.’ Naywo kakiaghombela, ‘Nng'ende mukatende lihengo mu nng'unda ghwangu ghwa misabibu.’ ” ");
INSERT INTO nww_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Payihikite makimuhi, yula nkola nng'unda ghwa misabibu kakiaghombela nnyimiha ywake, ‘Ghubhakeme atendalihengo na ghubhahombe lihombo lyahabhe, ghutandile kwa bhala bhaninganite nabho kuuhiko na mbole kwa bhala bhaaninganite nabho kalongohi.’ ");
INSERT INTO nww_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Basi, atenda lihengo bhaakemitwe mu saa kumi na yimu, bhakikingama kila yumu ligwala yimu lya madini gha fesa. ");
INSERT INTO nww_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Habhu, bhala bha kalongohi paahikite bhakihwacha kukita bhaahombwa kyanalumu, peni kila yumu kakihombwa bhula bhula ligwala limu lya madini gha fesa. ");
INSERT INTO nww_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Paahombitwe kala ligwala lya madini gha fesa, bhakinhyongolekela yula nkola nng'unda, ");
INSERT INTO nww_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","paalongela, ‘abha bhandu bhaahikite kuuhiko bhatenda lihengo kwa lilaa limu ghweka, bhuli ghututendela tela na bhombe kunu twenga tulimbilila lihengo linakutopo, na leghi leghi tipi muluchubha?’ ” ");
INSERT INTO nww_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Yula nkola nng'unda kakinnyanga yumoo ywabhe, ‘Ghanja, nughupugha ng'obhe kilibhi. Bhuli, tukilingana ng'obhe nikuhombe lihombo lya ligwala limu kwa linjubha limu? ");
INSERT INTO nww_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ghutole lihmbo lyako, ghughende ukaya. Nungupala kunhomba ayu ywa kuuhiko handa panughupeghite ghwenga. ");
INSERT INTO nww_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Bhuli, nenga nungunoghwa ng'obhe kutenda kila kinukipala muutopelo ghwangu namwene? Bhuli, ghungubhona tama kiyaha nenga ndo mundu ywa maha?’ ” ");
INSERT INTO nww_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu kakiyomola kwa kulongela, “Ubhwabhu abhu ywa uhiko katabhegha ywa kalongohi na ywa kalongohi katabhegha ywa uhiko.” ");
INSERT INTO nww_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu papamu na ahundwa bhake atangalo bhakibhegha bhangughenda ku Yelusalemu, pakabheghite munjila, kakiatola bhala ahundwa bhake kumi na abhili, kakighenda nabho pambwegha, na kuyobhela nabho ghweka chabhe, kakiaghombela, ");
INSERT INTO nww_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nnyihwe. Tungughenda ku Yelusalemu, na akwo Mwana ywa Mundu kaayeghwa mumabhoko kwa mandundame akulu na ahunda bha Malaghilo, na akwo bhatantosa kakomwe, ");
INSERT INTO nww_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","mbole, bhatannyegha kwa bhandu bhaabheghite ng'obhe Ayahudi ahotole kunnyuyuha na kuntuta hinjupunjupu na kummamba mulupingika, peni linjubha lya ndatu katahyuhwa.” ");
INSERT INTO nww_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Apwo mama ywabhe bhana bha Sebedayo kakinhikila Yesu papamu na bhana bhake, kakichutamila mayughwa mu ulongolo ghwake na kunnyupa kilibhi. ");
INSERT INTO nww_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu kakinnkonya, “Ghungupala niki?” Aywo mama kaking'ombela, “Ghulaghe, kukita yumu ywa abha bhana bhangu abhili, yumu katame mu mbande yako ya nnilo na yungi mu mbande yako ya ngiya ku Ghubhutwa ghwako.” ");
INSERT INTO nww_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu kakinnyanga, “Mwenga mungukimanya ng'obhe kila kimukiyupa. Bhuli, manguhotola kunyweghela nnobho ghumbala kunyweghela nenga?” Bhakinnyanga, “Tunguhotola.” ");
INSERT INTO nww_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu kakiaghombela, “Kulyaghila nnobho ghwangu ghwa kimbamanda mutaghunywela, peni kutama mbande yangu ya nnilo ebu ya kungiya, ali lyanenga kata kuapegha. Tate ywangu kalamula kala ndo ghani kaatama ku nnilo ebu ku ngiya ya nenga.” ");
INSERT INTO nww_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bhala ahundwa bhangi mbinda mabhoko yimu paaghayihwite agho, bhakiakalalila abho alongo abhili. ");
INSERT INTO nww_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Habhu, Yesu kakiakema bhoha papamu, na kakiaghombela, “Mungumanya kukita atabhala bha nnima aghui bhanguatabhala bhandu kwa makakala, na hilongohi bhabhe bhanguatumikiha bhaabheghite mu utabhala ghwabhe. ");
INSERT INTO nww_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Peni kwa mwenga yikotoke kubhegha habhu, ngati ywakapala kubhegha nkulu mu mwenga kangunoghwa kabheghe ndumintumi ywa bhoha, ");
INSERT INTO nww_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","na kila ywakapala kubhegha ghwa kalongohi mu mwenga kangunoghwa kabheghe mmandwa ywenu. ");
INSERT INTO nww_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Handa bhula Mwana ywa Mundu kakihika ng'obhe kutumikilwa, ngati kuatumikkila na kuuhobhegha ubhumi ghwake kwa kuatenda bhandu atangalo ahotole kulopoka.” ");
INSERT INTO nww_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu na ahundwa bhake paabheghite bhangubhuka ku kitami kya ku Yeliko, lumati lukulu lwa bhandu lukintughila. ");
INSERT INTO nww_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Basi, kukibhegha na bhangalola abhili atama pambwegha ya njila. Pabhayihwite kukita Yesu kangupita apwo, bhakiyobha kyobho paghalongela, “Bambo, Mwana ghwa Daudi, ghutubhonele luhungu.” ");
INSERT INTO nww_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Lula lumati lwa bhandu lukialakalila na kualongela atame jii. Peni bhombe bhakichweha kuyobha kyobho, “Bambo, Mwana ywa Daudi, chonde ghutubhonele luhungu.” ");
INSERT INTO nww_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu kakiyima na kakiakema, kakiakonya “Mungupala nuatendele niki?” ");
INSERT INTO nww_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bhakinnyanga, “Bambo tungupala tuhotole kubhona.” ");
INSERT INTO nww_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu kakiabhonela luhungu, kakiabyala meho ghabhe, kamu bhakihotola kubhona, nabho bhakintughila. ");
INSERT INTO nww_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu na ahundwa bhake pabhaheghelelite kuhika ku Yelusalemu, bhakihika ku Betifage mukitumbi kya Miseituni, apo kakialaghila ahundwa bhake abhili, ");
INSERT INTO nww_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kakiaghombela, “Nng'ende mbaka ku kijiji kiibheghite muulongolo ghwenu, maammona kaputa kabhopwa, na mwana ywake kabhopwa pambwegha, muabhopole na mubhayeghe kwa nenga. ");
INSERT INTO nww_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Handa mundu pakabhakonya kiyaha niki munguatola, munnyange, ‘Bambo kanguapala,’ kamu, kataabhuyiha.” ");
INSERT INTO nww_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nnando aghu ghukitendekwa ngati ghatwihilike ghala ghaalongelitwe na mbuye, ");
INSERT INTO nww_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mukighombele kitami kya Sayuni, Nnole mutwa ywako kanguhika. Ndo mpole na ywakahika katama unane mwa kaputa, unane na mwa kaputa, mwana ywa kaputa.” ");
INSERT INTO nww_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Habhu, bhala ahundwa bhakighenda kutenda handa paalaghilitwe na Yesu. ");
INSERT INTO nww_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bhakinnyegha yula kaputa na mwana ywake, bhakiyalila ngubho hyabhe mu mighongo yabhe na Yesu kakitama kunane mwabhe. ");
INSERT INTO nww_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Lumati lukulu lwa bhandu lukiyalila ngubho hyabhe munjila, na bhandu bhangi bhakidumula hiputila gha mikongo na kuhiyalila munjila. ");
INSERT INTO nww_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Lumati lwa bhandu hiilongohanite na bhala bhaantughilite bhakikweha malobhe, “Katikilwe Mwana ywa Daudi. Yunakunemelwa ndo aywo ywakuhika kwa lihina lya Bambo. Tiko kwa Chapanga kunane.” ");
INSERT INTO nww_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu pakayingilite ku Yelusalemu, kitami kyoha kikibhegha na mbilingembilinge, bhandu bhakibhegha bhangukonya “Ayu ndo ghani?” ");
INSERT INTO nww_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Bhandu mulula lumati bhakilongela, “Ayu ndo Yesu, mbuye kuhuma ku Nasaleti kitami kya Galilaya.” ");
INSERT INTO nww_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Basi, Yesu kakiyingila pahala pa Nyumba ya Chapanga, na kakiabhingabhinga bhoha bhaabheghite mu kuhemela na kuchuhusa hilibhi mu Nyumba ya Chapanga, kakihipalangula hindambi hya bhala bhaabheghite mukuhemengana ngalabha na hiteho hya bhanakuhemengana ngunda. ");
INSERT INTO nww_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kakiaghombela “Yityekwa mu malembo gha Chapanga, ‘Nyumba yangu yibhegha nyumba kya kutundamila.’ Peni mwenga mukitenda kibheghe mbaku ya apoka.” ");
INSERT INTO nww_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bhangalola na bhanautebhalo bhakinng'endela ku Nyumba ya Chapanga, naywo Yesu kakialamiha. ");
INSERT INTO nww_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Basi, akulu bha andundame na ahunda bha Malaghilo paabhonite milando yakatendite Yesu, na kuayihwa bhana paalumbilila pahala pa Nyumba ya Chapanga paalongela, “Tuntike Mwana ywa Daudi.” Bhombe bhakikalala. ");
INSERT INTO nww_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bhakinkonya Yesu, “Bhuli, ghunguyihwa agho ghaaghalongela?” Yesu kakiaghombela, “Ena nunguyihwa! Bhuli, mukisoma ng'obhe Malembo gha Chapanga? ‘Kwa ngulo ya bhana adoko na hing'enya ghubhakwilikiha bhakutike kwa utwihiliko?’ ” ");
INSERT INTO nww_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Basi, kakialeka, kakibhuka panji ya kitami na kakighenda ku kijiji kya Betania na kakighonja akwo. ");
INSERT INTO nww_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesu pakabheghite kangubhuya kumbwani malabhila putiputi, njala yikimmina. ");
INSERT INTO nww_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kakighubhona nkongo ghuukemwa Ntini pambwegha ya njila, kakighughendela, peni ghukibhegha ng'obhe na mapambika ngati ghukibhegha na mahamba ghweka. Basi, kakighughombela ghula nkongo, “Ghukotoke kupambika mapambika kangi.” Pala pala ghula nkongo ghukinyaluka. ");
INSERT INTO nww_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ahundwa bhake paabhonite nnando aghu bhakikangacha, bhakinkonya, paalongela, “Yibhegha bhuli nkongo aghu ghwa ntini ghunyaluke kanongola?” ");
INSERT INTO nww_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu kakiaghombela, “Kulyaghila nunguaghombela, handa panhyubhalila na nkotoke kubhegha na bhwaghalili, maahotola, chepa ghweka kutenda habhu, ngati hata pamukighombela kitumbi aki, ‘Ghutupuke ghukalitaghe ku lihibha.’ Yaakitendeka habho. ");
INSERT INTO nww_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Na lyohele limulipala kuyupa mumayupo, malikingama.” ");
INSERT INTO nww_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu kakiyingila pahala pa Nyumba ya Chapanga, kakiyanda kuhunda, mandundame akulu na hilongohi bha aghohi bhakinhikila na bhakinkonya, “Ghungutenda milando ayi kwa makakala gha ghani? Na ghani ywakakupeghite makakala agha?” ");
INSERT INTO nww_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu kakiayanga, “Na nenga ndabhakonya likonyo limu, pamunyanga, na nenga ndabhaghombela ndo kwa likalama lyoki nungutenda milando ayi. ");
INSERT INTO nww_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ubatisa ghakihuma kwa ghani? Bhuli, ghakihuma kwa kunane ebu kwa bhandu?” Bhakiyanda kughombana bhombe kwa bhombe na kulongela, “Patulongela ghakihuma kunane katatukonya, ‘Kyabhuli mukinhyubhalila ng'obhe?’ ");
INSERT INTO nww_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Na patulongela, ‘Ghakihuma kwa bhandu.’ Yaabwituka bhulwa kiyaha bhandu abha bhoha bhanguhyubhalila kukita Yohane ndo mbuye ywa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Habhu, bhakinnyanga, “Twenga tungumanya ng'obhe.” Naywo Yesu kakiaghombela, “Nenga bhubho ndabhaghombela ng'obhe ndo kwa likalama lyoki nungutenda milando ayi.” ");
INSERT INTO nww_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Basi, mwenga munguhwacha niki? Mundu yumu kakibhegha na bhana abhili. Kakinng'endela yula ywa kalongohi na kunng'ombela, ‘Mwana ywangu, lelo ghughende ghukatende lihengo munng'unda ghwa misabibu.’ ");
INSERT INTO nww_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Yula mwana kakinnyanga, ‘Nenga ndaaghenda ng'obhe,’ mbole kakikilibhuha mahwacho ghake kakighenda kutenda lihengo. ");
INSERT INTO nww_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Yula tate kakinng'endela yula mwana ywa ubhili na kakinng'ombela bhula bhula. Ywombe kakinnyanga, ‘Ndaaghenda tate,’ peni kakighenda ng'obhe kutenda lihengo. ");
INSERT INTO nww_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ndo ywoki nkati ya abha abhili ywakannyitikilite kyakakipalite tate ywake?” Bhakinnyanga, “Yula ywa kalongohi.” Habhu, Yesu kakiaghombela, “Kulyaghila nenga nunguaghombela, asumula sumu na angongola bhataalongola kuyingila ku Ghubhutwa ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Mana Yohane yunakubatisa kakihika kwa mwenga kuabhoneha njila ya hoto ya kutama, mwenga mukinhyubhalila ng'obhe, peni asumula sumu na angongola bhakinhyubhalila. Hata payibhele mwenga pammonite agho ghoha mukilipetula ng'obhe na kunhyubhalila.” ");
INSERT INTO nww_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu kakiaghombela, “Nnyihwe nhwano ghungi, mundu yumu nkola nng'unda kakilima nng'unda ghwa misabibu, kakighutindihila kindupa, kakikimba libhumba lya kukamila difwai. Kakichenga kinala kya ukingikiho. Mbole, kakiayahikila bhanakulima bhamu nng'unda aghwo ghwa misabibu, mwene kakibhuka kakitenda mwanja kughenda ku nnima ghungi. ");
INSERT INTO nww_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Paghaheghelelite manjubha gha mabeno, kakialaghila andumindumi bhake kwa bhala akulima bhakaayahikilite, ngati apongole mafungu ghake gha mabeno. ");
INSERT INTO nww_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bhala bhaayahikilitwe bhakibhakamula bhala andumindumi, yumu bhakintuta, yungi bhakinkoma na yungi bhakintuta kwa malibho. ");
INSERT INTO nww_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nkola nng'unda aywo kakialaghila andumundumi bhangi atangalo kupitingana bha kalongohi, nabho bhala bhaayahikilitwe bhakiatendela bhula bhula. ");
INSERT INTO nww_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kuuhiko kakinlaghila mwana ywake kwa bhombe pakalongela, ‘Pangi bhatanhokamila mwana ywangu.’ ");
INSERT INTO nww_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Peni bhala bhaayahikilitwe paammonite mwana ywake bhakighombana bhombe kwa bhombe, ‘Ayu ndo yunakuhala. Hinu nhike na tunkome ngati tulitole lipala lyake.’ ");
INSERT INTO nww_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Habhu bhakinkamula, bhakinpiha panje ya nng'unda ghula na bhakinkoma.” ");
INSERT INTO nww_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu kaakonya, “Hinu, aywo nkola nng'unda ghwa misabibu pakapala kuhika katabhatenda niki bhala bhakaayahikilite nng'unda?” ");
INSERT INTO nww_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bhombe bhakinnyanga, “Kulyaghila katabhakoma bhandu abho ahokelo, mbole kataayahikila bhandu bhangi nng'unda aghwo bhene bhatampegha lusumulo lwake kwa nndaluko ghuutwihikilite.” ");
INSERT INTO nww_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Apo Yesu kakiaghombela, “Mukisoma ng'obhe nnando mu Malembo? ‘Libho lyaalilemite atendehi bha kuchenga Hinu lighalambuka na kubhegha libho likulu lya kitamiko Bambo ndo ywakatendite nnando aghwo naghwo ndo nnando ghwa kukangaha muno kwa twenga!’ ” ");
INSERT INTO nww_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kya habhu nunguaghombela, “Ghubhutwa ghwa Chapanga ghwaabhuhwa kwa mwenga na kupeghwa bhandu bhangi bhanakutenda milando yakayipala Chapanga Mughubhutwa ghwake.” ");
INSERT INTO nww_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yesu kakighendelela kulongela “Mundu ywakapala kughwegha mulibho ali kaadumuka hipalamande palamande, na libho alyo palimponekela mundu, mundu aywo kaahyaghika.” ");
INSERT INTO nww_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mandundame akulu na Akaafalisayo paayihwite mihwano ya Yesu, bhaking'amula kukita kanguaghombela bhombe. ");
INSERT INTO nww_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kya habhu, bhakipalaha kihokonyo kya kunkamula, peni bhakiayoghopa bhandu kiyaha bhakimmanya Yesu kukita ndo mbuye ywa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu kakilongela nabho kangi kwa mihwano, kakiaghombela, ");
INSERT INTO nww_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ghubhutwa ghwa kunane ghungulihwana na mutwa ywakantendekelehite mwana ywake mulyo ghwa chekwa ya kutolela. ");
INSERT INTO nww_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kakialaghila andumindumi bhake abhakema bhala bhaalalikitwe mu chekwa ya kutolela, peni bhakilema kuhika. ");
INSERT INTO nww_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mbole kakialaghila andumindumi bhangi pakalongela, ‘Mubhaghombele bhala bhaalalikitwi kukita chekwa yibhegha kala kwakya mwenga, njinja kala likambako lya senga na bhana bha senga bhanakuhata na hyakupechula.’ ");
INSERT INTO nww_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Peni bhombe bhakilema, na bhakighenda, ayu kunng'unda ghwake, na yungi ku utendehi ghwake, ");
INSERT INTO nww_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","amoo bhangi bhakiakamula bhala andumindumi bhake na bhakiatendela ndendelo ya honi na kuakoma. ");
INSERT INTO nww_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yula mutwa kakikalala muno, kakialaghila machonda bhake bhakaakanjaghane bhala bhanakukoma na kukiyocha mwoto kitami kyabhe. ");
INSERT INTO nww_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Mbole, kakiaghombela andumindumi bhake, ‘Chekwa ya kutolela yibhegha kala, peni bhala bhanualalikite bhakiyitikila ng'obhe kuhika. ");
INSERT INTO nww_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Basi, nng'ende mu ngongano ya njila na mukaalalike bhohele bhamubhabhona, bahahike mu mulyo ghwa chekwa ya kutolela.’ ");
INSERT INTO nww_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bhala andumindumi bhakighenda mu njila na bhakiakungana bhandu bhoha bhaakonganite nabho, bhandu bha maha na ahakata, na lubhagha lwoha lwa chekwa lukimema ahenja.” ");
INSERT INTO nww_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Peni mutwa pakayingilite unyumba ngati kabhabhone ahenja, amwo kakimmona mundu yumu kahwala ng'obhe lipinda liinoghwa mu chekwa ya kutolela. ");
INSERT INTO nww_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mutwa kakinkonya, ‘Ghanja, ghukiyingila bhuli amu kyanga kuhwala lipinda lya kutolela?’ Yula mundu kakitama jii. ");
INSERT INTO nww_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ndo mutwa kakiaghombela andumindumi bhake, ‘Mummope mabhoko na maghulu na mukantaghe panje mulubhindu. Akwo kwabhegha na kililo na kuhyagha mino.’ ” ");
INSERT INTO nww_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu kakiyomola pakilongela, “Kiyaha bhaalalikitwe atangalo, peni bhahaghulitwe bhamandina.” ");
INSERT INTO nww_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mbole, Akaafalisayo bhakibhuka panji, na bhakighambelana atende niki kwakya kung'omeha Yesu kwa malagho ghake. ");
INSERT INTO nww_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ndo bhakialaghila afwasi bhabhe papamu na bhandu bha kimati kya Helode nabho bhakinnkonya, “Nhunda, tungukumanya kukita ghwenga ndo mundu ywa maha, na kukita ghunguhunda njila ya Chapanga ya kutenda gha maha kyangali kummaghula mundu. ");
INSERT INTO nww_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Basi, ghutughombele, ghwenga ghunguhwacha bhuli? Tungunoghwa kunhomba sumu mutwa nkulu ywa Akaaloma ebu chepa?” ");
INSERT INTO nww_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Peni Yesu kakimanya mahwachilo ghabhe gha uhakata kakiaghombela, “Mwenga maafyangu, kiyaha niki mungupala kundegha? ");
INSERT INTO nww_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mummonehe ligwala lya kuhomba sumu.” Bhakinnyeghela ligwala liikemwa dinali, ");
INSERT INTO nww_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","naywo kakiakonya, “Kibhungi aki na lihina ali ndo lya ghani?” ");
INSERT INTO nww_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bhakinnyanga, “Lya mutwa nkulu ywa Akaaloma.” Ndo Yesu kakiaghombela, “Mumpeghe mutwa nkulu ywa Akaaloma ghaabheghite gha Ywombe, na gha Chapanga mumpeghe ghaabheghite gha Chapanga.” ");
INSERT INTO nww_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Paayihwite agho bhakikangacha, ndo bhakibhuka na bhakinneka. ");
INSERT INTO nww_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Linjubha alyo alyo Asadukayo, bhala bhaalongela kukita kahone kuhyuka kuhumu kwa bhaahweghite, bhakinhikila Yesu na kunkonya ngonyo paalongela, ");
INSERT INTO nww_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Nhunda, Musa kakilongela, ‘Handa mundu pakahwegha kyanga bhana, nnongo ghwake kantole aywo nhumbu nnekwa ngati kampeghe bhana aywo nnongo ghwake ywakahweghite.’ ");
INSERT INTO nww_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Hino, apa kwa twenga pakibhegha na alongo saba. Yula ywa kalongohi kakitolela nhumbu, naywo kakihwegha kyangali bhana, ndo nnung'una ywake kakinhala aywo nhumbu. ");
INSERT INTO nww_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Yikibhegha ubhwabhu abhu kwa yula nnongo ywa ubhili na ywa ndatu, mbaka bhoha saba. ");
INSERT INTO nww_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mbole, yula nhumbu naywo kakihwegha. ");
INSERT INTO nww_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Bhuli, linjubha lya kuhyuka, nhumbu aywo katabhegha nhumbu ywa ghani mu bhala alongo saba? Kiyaha bhoha bhakintola nhumbu aywo.” ");
INSERT INTO nww_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu kakiayanga, “Mwenga munguhokela kiyaha mungumanya ng'obhe Malembo ebu likalama lya Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kiyaha bhaahweghiti paapala kuhyuka bhaatolela kata ebu kutolelwa, ngati bhaabhegha handa mahoka bha Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Peni kwa ghula nnando ghwa bhandu kuhyuka mukisoma ng'obhe kila kyakalongilite Chapanga kukita, ");
INSERT INTO nww_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nenga ndo Chapanga ywa Iblahimu, Chapanga ywa Isaka, na Chapanga ywa Yakobu?’ Ywombe chepa Chapanga ywa bhaahweghite, ngati ndo Chapanga ywa bhaabheghite na ubhumi.” ");
INSERT INTO nww_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Lula lumati lwa bhandu paluyihwite agho, lukikangacha muno kwa mahundo ghake. ");
INSERT INTO nww_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Afalisayo paayihwite kukita Yesu kakianyamahia, bhala Asadukayo, bakikonganika papamu. ");
INSERT INTO nww_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yumoo ywa bhala ahunda bha Malaghilo, kakinkonya likonyo ngati kanteghe, pakalongela, ");
INSERT INTO nww_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Nhunda, ndo ngwilikiho yoki Mumalaghilo yiibheghite ngulu kupitingana hyoha?” ");
INSERT INTO nww_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu kakinnyanga, “Ghunpale Bambo Chapanga ywako kwa mwoyo ghwako ghwoha na kwa mwoyo ghwako ghwoha na kwa mahala ghako ghoha. ");
INSERT INTO nww_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ayi ndo Ngwilikiho yinakunoghwa na kangi ya ulongohi. ");
INSERT INTO nww_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na ya ubhili ndo handa ayi, nalyo ndo ali, ‘Ghumpale nndamani ywako handa paghughupala ntima ghwako.’ ");
INSERT INTO nww_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ngwilikiho ahi mbili hikamulilwa Mumalaghilo ghoha na ambuye bha Chapanga.” ");
INSERT INTO nww_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Afalisayo paakwemukiti papamu, Yesu kakiakonya, ");
INSERT INTO nww_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Munguhwacha niki kunninga Kilisto Nkombohi? Ywombe ndo Mwana ywa ghani?” Bbombe bhakinnyanga, “Ywombe ndo Mwana ywa Daudi.” ");
INSERT INTO nww_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu kakiaghombela, “Yibhegha bhuli aywo Daudi pakalongohitwe na Nhuki ywa Chapanga kangunkema Kilisto, ‘Bambo?’ Kiyaha kakilongela, ");
INSERT INTO nww_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Bambo kakinng'ombela Bambo ywangu, ghutame mu mbande yanenga ya nnilo, Mbaka paambala kubhahotola yomo amyanja bhako.’ ");
INSERT INTO nww_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Handa Daudi kangunkema Kilisto, ‘Bambo’ Yibhegha bhuli Kilisto kabheghe mwana ywa Daudi?” ");
INSERT INTO nww_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kahone mundu ywakahotolite kunnyanga lilagho. Kutandila linjubha alyo kahone mundu ywakayighite kunkonya kangi. ");
INSERT INTO nww_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mbole Yesu kakiaghombela bhala bhandu atangalo papamu na ahundwa bhake bhaabheghite apo, ");
INSERT INTO nww_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ahunda bha Malaghilo na Afalisayo ndo bhaakamuhitwe makakala gha kufwambula Malaghilo gha Musa, ");
INSERT INTO nww_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Habhu, mungunoghwa kuayitikila na kutenda kyohele kyaabhaghombela. Peni nkotoke kutenda ghala ghaaghatenda, kiyaha bhombe angutenda ng'obhe ghala ghaaghalandamiha. ");
INSERT INTO nww_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bhombe bhanguyibhopa mihiho mikulu na kuhibhika mu makombi gha bhandu, peni bhene angulema nga kuyikamula kwa hikonji ghabhe. ");
INSERT INTO nww_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bhombe bhangutenda ndendelo yabhe hyoha ngati abhonekane na bhandu, ghabhe bhanguhwala himatiko hinakubhegha na Malembo gha Malaghilo muhibhungi hyabhe na mumabhoko na kutaliha hihundo hya mapinda ghabhe. ");
INSERT INTO nww_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bhangupala kutama mu hiteho hya pahala pa kuhokamilwa muchekwa na muhila hiteho hya kuhokamilwa munu munyumba hya kukonganila, ");
INSERT INTO nww_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bhangupala kujambuhwa mumagulio na bhagupala bhandu bhaakeme ‘Nhunda.’ ");
INSERT INTO nww_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Peni bhandu akotoke kuakema mwenga ‘Nhunda.’ Kiyaha mabhoha mwenga ndo afwasi bhangu na nhunda ywenu ndo yumu ghweka. ");
INSERT INTO nww_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Na nkotoke kunkema ywohele ‘Tate’ mu nnima aghu kiyaha mmegha na Tate yumu, naywo kabhegha kunane. ");
INSERT INTO nww_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Bhandu akotoke kuakema mwenga ‘Hilongohi.’ Kiyaha mmegha naywo kilongohi yumu ghweka, naywo ndo Kilisto. ");
INSERT INTO nww_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ywombe ywakabhegha nkulu mu mwenga yibhegha mbaka kabheghe nndumitumi ywenu. ");
INSERT INTO nww_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kiyaha mundu ywohele ywakaliyinula katahuluhwa na mundu ywohele ywakalihuluha katayinulwa.” ");
INSERT INTO nww_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Kibhabhone mwenga ahunda bha Malaghilo na Afalisayo, maafyangu, kiyaha munguatatila bhandu nlyango ghwa Ghubhutwa ghwa kunane, kunu mabhene munguyingila ng'obhe, na bhala bhaapala kuyingila munguakanikiha. ");
INSERT INTO nww_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kibhabhone mwenga ahunda bha Malaghilo Afalisayo, maafyangu, mungulyegha munyumba ya adala alekwa, kunu mungulitenda handa bhamaha, na kwa ufyangu munguyupa mayupo mandandamaho. Habhu, maamokola kihyatu kikulu.” ");
INSERT INTO nww_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kibhabhone mwenga ahunda bha malaghilo na Afalisayo maafyangu, kiyaha mungutindila mu milima na kuyomboka mahibha ngati kuntenda mundu yumu kabheghe Nnyahudi, na pakatenda kala kubhegha mwana ywa kumambe mala mbili kyanalumu.” ");
INSERT INTO nww_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kibhabhone mwenga hilongohi maangabhona. Mwenga mungulongela, ‘Handa mundu pakalapa kwa lihina lya Nyumba ya Chapanga, kilapo akyo kyayaghi, peni pakalapa kwa lihina lya sahabu ya mu Nyumba ya Chapanga, mundu aywo kabhopwa mu kilapo akyo’ ");
INSERT INTO nww_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mwenga mangalola ahilamahala. Ndo kyoki kiibhegha kikulu kupitingana kingi, yila sahabu ebu yila Nyumba ya Chapanga yinakutenda ayo sahabu yibheghe ya Chapanga? ");
INSERT INTO nww_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kangi mungulongela, ‘Mundu pakalapa kwa kindambi kya kuyambikila, chepa kilibhi, peni pakalapa kwa nyambi yiibhegha mukila kindambi, mundu aywo kangubhopwa na kilapo akyo.’ ");
INSERT INTO nww_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mwenga mangabhona. Ndo kyoki kiibhegha kikulu mu ahyo, yila nyambi, ebu kila kindambi kya nyambi kiitenda ayo nyambi yibheghe ya Chapanga? ");
INSERT INTO nww_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Habhu, mundu ywakalapa kwa kindami, kangulapa kwa akyo kindambi na ghoha ghaabheghiti unane ghwake. ");
INSERT INTO nww_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Naywo mundu ywakalapa kwa Nyumba ya Chapanga, kangulapa kwa ayo Nyumba ya Chapanga na kwa aywo ywakatama mu Nyumba ayo. ");
INSERT INTO nww_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Naywo yunakulapa kwa kunane kwa Chapanga, kangulapa kwa kiteho kya Ghubhutwa ghwa Chapanga na kwa aywo yaakatama mu kiteho akyo.” ");
INSERT INTO nww_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kibhabhone mwenga ahunda bha malaghilo na Akaafalisayu, maafyangu. Kiyaha munguatenda bhandu atule matulo gha lifungu lya kumi hata kwa manyahi ghanakunungila nyanyi, bisali na lihambanyungu peni munguyileka milando mikulu ya Malaghilo, handa bhula kutenda gha maha muulongolo ghwa Chapanga, luhungu na kuhyubhalila. Agho ghanguakwiliha kughatenda kyanga kughalibhalila ghangi. ");
INSERT INTO nww_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mwenga hilongohi mangabhona, mungubhuha libhembe mukiywegho na mungummila nnyama ngamia.” ");
INSERT INTO nww_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kibhabhone mwenga ahunda bha malaghilo na Afalisayo, maafyangu, kiyaha mungughulula nnobho na kipumbulu kwa panje, peni nkati mmema hilibhi muyimokolite kwa upoka na ghwimi. ");
INSERT INTO nww_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mwenga maafalisayo mangabhona, ng'ulule huti nkati ya nnobho na hipumbulu, ndo panje paabhegha nyanyi.” ");
INSERT INTO nww_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kibhabhone mwenga ahunda bha Malaghilo na Afalisayu afyangu. Mungulihwana na mandogholo ghaalembitwe chokaa kya panje ghangubhonekana gha nyanyi peni nkati ghabhegha na mihupa ya bhaahweghite na hinyakali hyoha. ");
INSERT INTO nww_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ubhwabhu abhu, na mwenga kya panje mungubhonekana mmegha bha maha peni nkati mmema ufyangu na uhokelo.” ");
INSERT INTO nww_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kibhabhone mwenga ahunda bha malaghilo na Afalisayo maafyangu. Mungughachengela mandogholo gha ambuye na kughalemba mandogholo gha bhaabheghite bha maha. ");
INSERT INTO nww_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Na mungulongela, ‘Handa tungabheghite mumajubha gha aghohi bhetu, tungabheghite ng'obhe papamu nabho ng'obhe mu kuakoma ambuye.’ ");
INSERT INTO nww_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Habhu munguyilimiha mabhene kukita mwenga ndo bhana bha bhandu bhaabhakomiti ambuye. ");
INSERT INTO nww_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Basi, mughumemekehe nteko ghwa uhakata ghwa atate bhenu. ");
INSERT INTO nww_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mwenga kibheleko kya mayoka bhana lusungu, mayibhutuka bhuli toso ya mwoto ghwangahimika? ");
INSERT INTO nww_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kya habhu, nnole nunguayeghela ambuye na bhaabheghiti bha maha na bhaabheghite na malango na ahunda. Amoo bhangi matabhakoma na kubhabhamba, amoo bhabhe mutabhahyata hinjupunjupu mu nyumba hyenu hya kukonganila na amoo bhabhe mutabhabhingabhinga kuhuma mukitami kimu mbaka kitami kingi. ");
INSERT INTO nww_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Habhu, ghula mwahi ghwa bhaabheghite bha maha bhoha, ghuuyitikite munnima aghu, kutandila mwahi ghwa Abeli, ywakatendite ng'obhe uhakata, mbaka mwahi ghwa Sakaliya mwana ywa Balakia, yumunkomite pakati ya pakya Chapanga na kinambi kya lihabha, yabhahikila unani mwa mwenga. ");
INSERT INTO nww_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kulyaghila nunguaghombela agha ghoha ghaahika mukibheleko aki.” ");
INSERT INTO nww_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Mwenga mabhandu bha Yelusalemu, mubhakomiti ambuye na kuatuta kwa malibho bhala bhaalaghilitwe kwa mwenga. Pakiki nikilitumba kuakungana bhana bhako, handa bhula nguku pakungana bhana bhake mu mapabhatila yake, peni ghukilema. ");
INSERT INTO nww_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ghulole kaayileka Nyumba yenu yibheghe mang'obha. ");
INSERT INTO nww_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kiyaha nunguaghombela, mamona kangi ng'obhe mbaka lijubha lila panlongela, ‘Kanemelwa ywene yunakuhika kwa Lihina lya Bambo.’” ");
INSERT INTO nww_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu kakibhuka ku Nyumba ya Chapanga na pakabheghite kangughenda, ahundwa bhake bhaking'endela ngati bhakammonehe Machengo gha Nyumba ya Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ndo Yesu kakiaghombela, “Bhuli, mungughabhona agha ghoha? Kulyaghila nunguaghombela, kahone hata libho limu lyahighala kubhegha apa unane mwa libho lingi, ghoha ghaaboghoyolwa.” ");
INSERT INTO nww_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu pakabheghite katama ku kitumbi kya Miseituni, ahundwa bhake bhakinng'endela ngati abheghe ghweka chabhe, bhakinkonya, “Ghutughombele, milando ayi yaabwitukila pakiki? Na naho yoki yiipala kubhoneha kuhika kwa ghwenga na uhiko ghwa nnima?” ");
INSERT INTO nww_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu kakiayanga, “Mulindakile, mundu kakotoke kuakuluha. ");
INSERT INTO nww_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kiyaha bhandu atangalo bhaahika kwa kulitumila lihina lyangu pabhalongela, ‘Nenga ndo Kilisto Nkombohi.’ Nabho bhataakuluha bhandu atangalo. ");
INSERT INTO nww_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Maayihwa mihalo ya ngondo na mbwepo hya ngondo, mulindakile nkotoke kuyoghopa, kiyaha agho mbaka ghabwitukile, peni uhiko ghwene ghukali. ");
INSERT INTO nww_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bhandu bha nnima ghumu bhaatutana na bhandu bha nnima ghungi na bhandu bha ghubhutwa ghumu bhaatutana na bhandu bha ubhutwa ghungi. Kwaabhegha na lung'ahi lwa njala na milendemo ya lutupi munnima ghwoha. ");
INSERT INTO nww_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Agha ghoha ndo handa kutandandila kwa lihingili.” ");
INSERT INTO nww_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Yesu kakighendelela kulongela, “Manjubha agho mwenga maakilukwa, ngati mpamandwe na kukomwa, na mwenga maakalalihwa na bhandu bha milima hyoha kwakya kunhyubhalila nenga. ");
INSERT INTO nww_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mumanjubha agho, bhandu atangalo bhaaleka kunyubhalila, na bhaakilukana kila yumu na nnyake na bhaabhapala ng'obhe kiyaha munyubhalila nenga. ");
INSERT INTO nww_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mbole bhaabwituka ambuye atangalo ahwangi, na bhataakuluha bhandu atangalo. ");
INSERT INTO nww_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kangi upalo ghwa bhandu atangalo ghwaapungula, kubhukana na kuyonjokeheka kwa ulemwa, ");
INSERT INTO nww_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","peni yula ywakabhegha nglii mukunyubhalila nenga mbaka kuuhiko ndo katalopoka. ");
INSERT INTO nww_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Peni kukali nakuhika ghula uhiko, Nhalo ghwa Maha ghwa Ghubhutwa ghwa Chapanga ghwalandamihwa munnima ghwoha, ngati bhandu bhoha ghwaghumanye. Ndo ghula uhiko ghwaahika.” ");
INSERT INTO nww_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Pamughubhona nnando ghwa kuyoghoha, ghuuyegha uhanjaghano, ghuyima mu Nyumba ya Chapanga handa pakalongelite mbuye Danieli, yunakusoma kangunoghwa kaghumanye nnando agho, ");
INSERT INTO nww_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ndo bhala bhaabheghiti ku Yudea bhatughile ku hitumbi. ");
INSERT INTO nww_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Na yula ywakabhegha kulinyakaha lwa nyumba kakotoke kuhuluka ngati kakatole kyohele mu nyumba yake. ");
INSERT INTO nww_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ywakabheghegha kung'unda kakotoke kubhuya ukaya kutola ngubho yake. ");
INSERT INTO nww_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kibhabhone kwa bhala adala bhaabhegha na ndumbo na bhaabhegha na bhana hinonono mumanjubha agho. ");
INSERT INTO nww_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nnyupe ngati kutugha kwa mwenga kukote kubhegha mu manjubha gha malili ebu Linjubha lya Kupumulila. ");
INSERT INTO nww_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kiyaha mumanjubha agho kwabhegha na mapungwo makulu ghene ghanabwituka kata kuhuma kubhumbwa kwa nnima mbaka lelo, hangi ghaabwituka kangi ng'obhe. ");
INSERT INTO nww_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Peni Chapanga kaghupungula kala mmalango ghwa manjubha agho, handa kangatenda habho ng'obhe kahone nga mundu yumo ywakapala kulopoka, peni yakya bhandu bhakaahaghulite manjubha agho Chapanga kaghapungula.” ");
INSERT INTO nww_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Mumanjubha agho handa mundu ywohele kataaghombela, ‘Nnole, Kilisto Nkombohi kabhegha apa ebu kabhegha kula,’ nkotoke kuhyubhalila. ");
INSERT INTO nww_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kiyaha bhaabwituka makilisto ahwangi na ambuye ahwangi na bhaatenda naho ngulu na mihabho miyoloho ngati kuahokeha bhandu, payihotoleka mbaka bhala bhaahaghulitwe na Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mulindakile, nubhaghombela kala kukali na kubwituka kwa milando ayo.” ");
INSERT INTO nww_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Hinu mundu ywohela pakaaghombela, ‘Kilisito kabhegha kula ku kibhala,’ nkotoke kughenda akwo. Ebu pakalongela, ‘Killisito kabhegha mu nyumba kati,’ nkotoke kuhyubhalila. ");
INSERT INTO nww_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kiyaha handa bhula ndetelehe hya njahe payibwitukila kuhuma kungeha na kubhonekana mbaka kulutipikiti luchubha, habho ndo yaabhegha kuhika kwake Mwana ghwa Mundu.” ");
INSERT INTO nww_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Kiyaha pwohele paghubheghite ntumba, akwo ndo bhaakongana hiyuni bhaakemwa tai.” ");
INSERT INTO nww_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Pindulu mbole manjubha agho gha mapughwo paghakinda, Chapanga kataluughalambuha luchubha kubhegha lubhindu, lubhalamwehi nagho ghwaanga'aliha ng'obhe na ndondwa yaaponeka kuhuma kunane, na ubhwabhu abhu Chapanga ghaatingihika makakala gha kunane. ");
INSERT INTO nww_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ndo yabhonekana naho ya Mwana ghwa Mundu kubhwelo, na bhandu bhoha bha munnima bhaakukulika, nabho bhaammona Mwana ywa Mundu pakahika kubhwelo pakabhegha na makakala na ukulu nkulu. ");
INSERT INTO nww_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Naywo kataalaghila mahoka bhake kunu paapyemba lupalata, nabho bhataakungana ahaghulwa bhake kuhuma mu mbande hyoha ncheche ya nnima, kuhuma mu uhiko ghumu ghwa nnima mbaka uhiko ghungi.” ");
INSERT INTO nww_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Mulihunde kuhuma munkongo ghwa nkuyu, mapanyo ghake paghayanda kutomola mahamba, mungumanya kukita hula hibhegha ugheghela. ");
INSERT INTO nww_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ubhwabhu abhu, pammona milando hyoha yingubwituka, mmanye kukita, Mwana ghwa Mundu kabhegha ugheghela. ");
INSERT INTO nww_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kulyaghila nunguaghombela, kibheleko aki kyaakinda ng'obhe mbaka milando ayi hyoha yibwituke. ");
INSERT INTO nww_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kunani na nnima ghwaakinda, peni malagho ghangu ghaakinda ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Kwa nhalo ghwa linjubha lila na lisaa kahone ywakamanya, hata mahoka bha Chapanga, hangi Mwana, ngati nga Tate ghweka chake. ");
INSERT INTO nww_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mana handa payibheghite mumajubha gha Nuhu, ubhwabhu ndo ghabhegha kuhika kwa Mwana ghwa Mundu. ");
INSERT INTO nww_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kiyaha majubha ghala kukali na ngumbwa ngulu ya machi kughugubika nnima, bhandu bhakibhegha paakilyegha na kunywegha, paatolela na kutolelwa, mbaka mulinjubha lila Nuhu pakayingiliti mu ghula bhwato nkulu ghuukemwa, ");
INSERT INTO nww_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","na bhakimanya ng'obhe kyohele mbaka payihikite yila ngumbwa ngulu ya machi na kuakokobhola bhoha. Ndo yabhegha ubhwabhu pakapala kuhika Mwana ghwa Mundu. ");
INSERT INTO nww_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Bhandu abhili bhaabhegha kunng'unda, yumu katanyahulighwa na yungi katalekwa. ");
INSERT INTO nww_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Adala abhili bhaabhegha mu kuhyagha papamu, yumu kaanyahulighwa na yungi katalekwa. ");
INSERT INTO nww_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Hino, mulindakile kiyaha mungumanya ng'obhe linjubha lyoki lyaahika Bambo ghwenu. ");
INSERT INTO nww_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Peni mughumanye nnando aghu kukita, handa nkola kaya kangamanyite mu lisaa lyoki pakilo mwihi katahika, mundu aywo kangaghonjite ng'obhe na kuleka nyumba yake yiboghoyolwe. ");
INSERT INTO nww_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Habhu na mwenga yinguakwiliha kubha kala, kiyaha Mwana ghwa Mundu katahika mu lisaa limulimanyiti ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesu kakighendelela kulongela, “Ndo ywoki ywakabheghite ndumindumi ywa kuhyubhalika na yuna mahala mwene bambo ywake kaammika kuyimilila andumindumi bhangi mu lubhagha lwake, na kabhapeghe hilyo lisaa lya hilyo? ");
INSERT INTO nww_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Yabhegha tela nndumindumi yula ywene bambo ghwake pakabhuya katammona pakatenda habhu. ");
INSERT INTO nww_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kulyaghila nunguaghombela, katammika ndumindumi aywo kabheghe nnyimilila ghwa utopelo ghwake ghwoha. ");
INSERT INTO nww_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Peni handa aywo nndumindumi ndo nhakata, naywo pakalongela mu mwoyo ghwake, ‘Bambo gwangu kangukabhalila kubhuya,’ ");
INSERT INTO nww_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","mbole pakayanda kuatuta andumindumi ayaki na kuyanda kulyegha na kunywegha papamu na alobhi, ");
INSERT INTO nww_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","bambo ghwa nndumindumi aywo katahika linjubha lyakamanyiti ng'obhe na lisaa lyakalimanya ng'obhe. ");
INSERT INTO nww_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Bambo ywake atanhyata muno nndumindumi aywo na kunbhika mu ng'ebhu yimo na afyangu, akwo ndo katalila na kuhyanga mino.” ");
INSERT INTO nww_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesu kakighendelela kulongela, “Manjubha agho, Gubhutwa ghwa Kunani kwa Chapanga ghwabhegha handa akabhali kumi bhaatoliti mambamba ghabhe na kughenda kunkingama bambo yunakutolela. ");
INSERT INTO nww_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nhano mu bhombe bhakibhegha ahila mahala, na nhano bhakibhegha na mahala. ");
INSERT INTO nww_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bhala ahila mahala bhakitola mambamba ghabhe peni bhakitola ng'obhe na mahuta gha kuyonjokeha mu mambamba, ");
INSERT INTO nww_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","peni bhala bhaabheghite na mahala bhakitola mambamba ghabhe na mahuta ghangi mu kyupa. ");
INSERT INTO nww_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Yula bambo yunakutolela pakakabhalililte kuhika bhala akabhali bhoha bhakitopelwa ng'ono na bhakighonja.” ");
INSERT INTO nww_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kuuhiko, pakilo totolo pakibhegha na kyobho, ‘Nnole, bambo yunakutolela kanguhika, nng'ende panje mukankingame.’ ");
INSERT INTO nww_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ndo bhala akabhali bhoha bhakiyumuka na kughatendekeha mambamba ghabhe. ");
INSERT INTO nww_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bhala ahila mahala bhakiaghombela bhala bhaabheghite na mahala, ‘Mutupeghe mahuta ghenu kichoko, mambamba ghetu ghanguhimika.’ ");
INSERT INTO nww_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Peni bhala bhaabheghite na mahala bhakiayanga, ‘Kata, kiyaha ghangutukwila ng'obhe twenga na mwenga. Mbaha nng'ende kwa bhanakuhemengana mukahemele mahuta ghenu.’ ");
INSERT INTO nww_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Bhala akamwali abhughabhugha paabheghite bhangughenda kuhemela mahuta, bambo yunakutolela kakihika. Bhala akabhali bhaabheghite kala, bhakiyingila unyumba papamu naywo mu chekwa ya kutolela na nlyango ghukitatwa.” ");
INSERT INTO nww_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Mbole, bhala akabhali babhughabhugha nabho bhakihika, na bhakikema, ‘Bambo, Bambo, ghutuhughulile nlyango.’ ");
INSERT INTO nww_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Peni Bambo yunakutolela kakiayanga, ‘Kulyaghila nunguaghombela, nunguamanya ng'obhe.’ ” ");
INSERT INTO nww_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu kakiyomola pakalongela, “Hinu mulindakile, kiyaha mungumanya ng'obhe linjubha ebu lisaa.” ");
INSERT INTO nww_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kangi Yesu kakighendelela pakilongela, “Kangi, Ghubhutwa ghwa Kunani kwa Chapanga ndo handa mundu ywakapalite kughenda kumwanja, kakiakema andumindumi bhake na kuapegha utopelo ghwake. ");
INSERT INTO nww_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yumu kakinpegha mihako nhano ya magwala, na yungi mihako mibhili ya magwala, na yungi nhako ghumu ghwa magwala, bhoha bhakipeghwa kwa makakala ghabhe, mbole ywombe kakibhuka. ");
INSERT INTO nww_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mbole yula ywakapeghitwe mihako nhano ya ligwala kakighenda kuyitendela mahengo na kakimokola mihako yingi nhano ya magwala. ");
INSERT INTO nww_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ubhwabhu abhu yula ywakapeghitwe mihako mibhili ya maghwala kakimokola mihako yingi mibhili ya magwala. ");
INSERT INTO nww_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Peni yula nndumindumi ywakapeghitwe nhako ghumu ghwa magwala, kakighenda na kakibukula libhumba mulutupi na kakighuhiha ghula nhako ghwa magwala ya bambo ghwake.” ");
INSERT INTO nww_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Mbole ya manjubha matangalo yula bambo ywa bhala andumindumi kakibhuya kutenda mmalango na bhombe. ");
INSERT INTO nww_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yula nndumindumi ywakapeghitwe mihako nhano ya magwala kakihika, kakiyegha mihako mingi nhano ya magwala. Na kakilongela, ‘Bambo ghukimbegha mihako nhano ya magwala, ghulole njokeheka mihako yingi nhano.’ ");
INSERT INTO nww_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Bambo ghwake kakinng'ombela, ‘Ghutenda maha muno, nndumindumi ghwa maha na ghwa kuhyubhalika, ghutenda maha kwa hilibhi hichoko, ndaghubhika kubhegha nnyimilila ghwa hilibhi hitangalo. Ghuhike ghuyelelwe papamu na bambo ghwako.’ ” ");
INSERT INTO nww_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Mbole yula ywakapeghitwe mihako mibhili ya ligwala naywo kakihika. Na kakilongela, ‘Bambo, ghukimbegha mihako mibhili ya magwala. Ghulole nyonjokeha mihako yingi mibhili.’ ");
INSERT INTO nww_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Bambo ywake kakinyanga, ‘Ghutenda maha munu, nndumindumi ghwa maha na ghwa kuhyubhalika, ghutenda maha mu milando michoko, ndaghubhika kubhegha nnyimilila ghwa hilibhi hitangalo. Ghuhike ghuyelelwe papamu na bambo ywako.’ ” ");
INSERT INTO nww_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Mbole yula nndumindumi ywakapeghitwe nhako ghumu ghwa magwala kakihika na kakilongela, ‘Bambo, Ningumanya kukita ghwenga ndo mundu n'nonopo munu, ghungubena pala paghupanditi ng'obhe na ghungukungana pala paghukwetite ng'obhe mbeyu. ");
INSERT INTO nww_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Hinu nikiyoghopa kukita pangi ndaghahobheha maghwala ghako, ndo nikighukulila nhako ghwako mulutupi. Ghulole, nhako ghwako aghu apa ghuutole utopelo ghwako.’ ");
INSERT INTO nww_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Bambo ghwake kakinnyanga, ‘Ghwenga nndumindumi nhakata na ntotoho, ghukimanya kukita ningubena kila kimbatite ng'obhe na kukungana pala pangwetite ng'obhe mbeyu. ");
INSERT INTO nww_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Hinu, yikikukwiliha kughabhika magwala ghangu kwa bhanakubhuha liba, ngati pamuya ndole yiibheghiti yangu na mapongolo ghake. ");
INSERT INTO nww_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Habhu, mumpoke aghwo nhako ghwa magwala na mukanpeghe ywakabheghite na mihako mbinda mabhoko yimu. ");
INSERT INTO nww_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kiyaha ywohele ywakabhegha na kilibhi katapeghwa na kuyonjokehwa. Peni yula ywakabheghite ng'obhe na kilibhi na kila kyakabheghite nakyo katapokwa. ");
INSERT INTO nww_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na ayu nndumindumi nhakata muntaghe panje, mulubhindu, akwo kubhegha na kililo na kuhyagha mino.’ ” ");
INSERT INTO nww_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Pakahika Mwana ywa Mundu mu ukulu ghwake na mahoka bha Chapanga bhoha papamu naywo, apo ndo katatama mu kiteho kya utabhala kya ukulu ghwake. ");
INSERT INTO nww_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bhandu bha milima hyoha bhaakwemukana mu ulongolo ghwake, naywo kataabhika mbuhi ghweka na mene ghweka handa paatenda nhakila. ");
INSERT INTO nww_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kataabhika mene mu mbande yake ya nnilo na mbuhi mbande yake ya ngiya. ");
INSERT INTO nww_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ndo mutwa kataaghombela bhala bhaabheghite mu mbande yake ya nnilo, ‘Nhike mwenga muunemilitwe na Tate ghwangu, muumokole Ghubhutwa ghuutendikihitwe kwa kya mwenga kutandila kubhumbwa kwa nnima. ");
INSERT INTO nww_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kiyaha pammeghiti na njala mukimbegha hilyo, panyumilitwe, mwenga mukimbegha machi gha kunywegha, na pameghite nhenja mukinngingama, ");
INSERT INTO nww_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","pameghite uhula mukinhwaliha mapinda, pameghite ntamwa mukinlela, na pameghite mu kibhopo mukihika kuntyangila.’ ” ");
INSERT INTO nww_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ndo bhala bhaabheghite bha maha bhakinnyanga, ‘Bambo, ndo linjubha lyoki tukikubhona na njala na tukikulyegheha ebu ghuyumilwa ndo tukikunywegheha machi? ");
INSERT INTO nww_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Lijubha lyoki tukikubhona nhenja tukikukingama ebu uhula tukikuhwaliha? ");
INSERT INTO nww_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kangi lijubha lyoki tukikubhona ntamwa na twenga tukikubhika ebu paghubheghitea mu kibhopo tukikutyangila?’ ");
INSERT INTO nww_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Naywo Mutwa kataayanga, ‘Kulyaghila nunguaghombela, kyohele ki mubhatendilite yumoo ghwa abha akaafuasi bhangu adoko, ndo mukindendela nenga.’ ” ");
INSERT INTO nww_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Mbole kataaghombela bhala bhaabheghite mu mbande yake ya ngiya, ‘Mmukane kwa nenga mwenga munkotolitwe, nng'endi mu mwoto ghwa nga kuhimika ghuutendikihitwi kala kwakya Nchipila na andumitumi bhake. ");
INSERT INTO nww_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kiyaha pameghite na njala, mukimbegha ng'obhe hilyo, nikinyumilwa, mukimbegha machi ngo'bhe, ");
INSERT INTO nww_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nikibhegha nhenja peni mukingingama ng'obhe, nikibhegha uhula peni mukinhwaliha ng'obhe, na pameghite ntamwa kunlela kata na pameghite mu kibhopo mukindyangila ng'obhe.’ ");
INSERT INTO nww_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ndo bhene nabho bhaanyanga, ‘Bambo linjubha lyoki alyo tukikubhona paghubhegha na njala ebu ghuyumilwa ebu nhenja, ebu uhula ebu paghubhegha ntamwa na mukibhopo na tukikuleka?’ ");
INSERT INTO nww_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mutwa kataayanga, ‘Kulyaghila nunguaghombela, pala pannemite kubhatangatila yumu ywa abha akaafuasi bhangu adoko, ndo mukilema kundendela nenga.’ ");
INSERT INTO nww_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Hinu abho bhaayingila mukihyato kya manjubha ghoha kyanga uhiko, peni bhala bhaabheghite bha maha bhaayingila mu ubhumi ghwa manjubha ghoha kyanga uhiko.” ");
INSERT INTO nww_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu pakayomolite kughalongela malagho agho ghoha, kakiaghombela ahundwa bhake, ");
INSERT INTO nww_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mungumanya kukita mbole ya majubha mabhili yaabhegha Pasaka, naywo Mwana ywa Mundu katakilukwa ngati kabhangalilwe mulupingika.” ");
INSERT INTO nww_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ndo hilongohi bha andundame na aghohi bha bhandu bhakikwemukana mu nyumba ya utabhala ya Ndundame Nkulu, lihina lyake Kayafa. ");
INSERT INTO nww_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bhakighombana ngati bhankamule Yesu kwa lupwepo na kunkoma. ");
INSERT INTO nww_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Peni bhakilongela, “Yikotoke kubhegha muchekwa, hela bhubho yaabwitukila bhulwa mubhandu.” ");
INSERT INTO nww_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu pakabheghite ku Betania mulubhagha lwa Simoni ywakabheghite na maloha, ");
INSERT INTO nww_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","nndala yumu kakinhikila na kyupa kya libho lya alabasita, kiimemite mahuta gha kunungila munu ghaabheghite gha ngalabha ngulu, kakighapopoha mu mutwe ghwa Yesu pakabheghite kangulyegha hilyo. ");
INSERT INTO nww_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ahundwa bhake paabhonite agho bhakikalala, bhakilongela, “Kya niki tunguhobheha ghwa ngalabha ahi ngulu? ");
INSERT INTO nww_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mahuta agha ghangahemenganitwe kwa ngalabha ngulu na ligwala ayo bhangakamuhitwe makapukwa.” ");
INSERT INTO nww_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu kakighamanya mahwacho ghabhe, na kakiaghombela, “Kiyaha niki mungunng'aha nndala ayu? Ywombe kandendela nnando ghwa maha muno. ");
INSERT INTO nww_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bhandu kapukwa mmegha nabho manjubha ghoha, peni maabhegha ng'obhe na nenga manjubha ghoha. ");
INSERT INTO nww_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Pakambopokihiti agha mahuta mu mmili ghwangu, ngati kummika kala kwa kukulilwa kwa nenga. ");
INSERT INTO nww_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ninguaghombela hoto, kwohele paghulandamihwa Nhalo ghwa Maha munnima ghwoha, nnando aghu ghwakautendite nndala ayu ghwaakambukwa, kwa ukulungwo ghwake.” ");
INSERT INTO nww_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mbole Yuda Isikalioti, yumoo ywa bhala kumi na abhili, kakighenda kwa hilongohi bha mandundame ");
INSERT INTO nww_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","na kakikonya, “Mambegha niki handa ndankamuha Yesu kwa mwenga?” Bhakinkamuha hipalamande salasini hya madini gha fesa. ");
INSERT INTO nww_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kutandila lisaa alyo Yuda kakipalaha ng'ebhu ya maha ya kunkiluka Yesu. ");
INSERT INTO nww_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Linjubha lya ulongohi lya chekwa ya mangati ghanga amila, ahundwa bhake bhakinhikila Yesu na bhakinkonya, “Ghungupala tughutendekehele kwoki pakulyeghela Pasaka?” ");
INSERT INTO nww_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kakiyanga, “Nng'ende kwa nnume yumu akwo ku kitami, na mukanng'ombele, ‘Nhunda kalongela habhu, lisaa lyangu liheghelela, na mulubhagha lwako ndalyegha Pasaka papamu na ahundwa bhangu.’ ” ");
INSERT INTO nww_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ndo ahundwa bhake bhakitenda handa paaghombilitwe na Yesu, nabho bhakitendekeha Pasaka. ");
INSERT INTO nww_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Payihikite makimuhi Yesu kakitama pakulyeghela papamu na bhala ahundwa kumi na abhili. ");
INSERT INTO nww_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Na paabheghite bhangulyegha Yesu kakilongela, “Kulyaghila nunguaghombela yumu ywenu katangiluka.” ");
INSERT INTO nww_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Bhene bhakihyongoloka muno, bhakiyanda kukonya yomu mbole ya yungi, “Bhuli Bambo, ndo nenga?” ");
INSERT INTO nww_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu kakialongela, “Yula ywakachwikite lingate papamu na nenga mukipumbulu, ndo katangiluka. ");
INSERT INTO nww_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana ywa Mundu kangughenda handa payityekitwe mu Malembo. Peni kimmone yula ywakankiluka yaabhegha mbaha kwa ywombe kangakotokite kubhelekwa.” ");
INSERT INTO nww_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mbole, Yuda yula ywakankilukite Yesu kakilongela, “Bhuli nhunda, ndo nenga?” Yesu kakinnyanga, “Ghwenga ghulongela na kila kighukilongela ndo hoto.” ");
INSERT INTO nww_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pabhaabheghiti bhangulyegha, Yesu kakitola lingate kakilumetula, na kakinnumba Chapanga, kakiapegha ahundwa bhake pakalongela, “Ntole, nlyeghe, aghu ndo mmili ghwangu.” ");
INSERT INTO nww_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Mbole, kakighutola nnobho, kakilumba, kakiapegha pakalongela, “Nnyweghele mabhoha nnobho aghu. ");
INSERT INTO nww_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Aghu ndo mwahi ghwa nenga ghuubhoneha ninganilo lyangu ndo hoto, mwahi ghuuyitika kwakya kuabhuhila ulemwa bhandu atangalo. ");
INSERT INTO nww_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Peni nunguaghombela, kutandila hinu ndanywegha kangi ng'obhe difwai ayi ya nsabibu, mbaka linjubha lila pambala kunywegha difwai ya hyono papamu na mwenga mu Ghubhutwa ghwa Tate ghwangu.” ");
INSERT INTO nww_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mbole, paayomolite kuyimba lwimbo, bhakibhuka kughenda ku kitumbi kya Miseituni. ");
INSERT INTO nww_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Basi, Yesu kakiaghombela, “Lelo pakilo bhoha maamutuka na maaneka, kiyaha yityekwa mu Malembo, ‘Ndantuta yunakuhakila, na lumati lwa mene lwapwilinganika.’ ");
INSERT INTO nww_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Peni mbole ya nenga kuhyuka ndabhalongolela kughenda ku Galilaya.” ");
INSERT INTO nww_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petili kakiyanga, “Hata handa bhoha bhatakuleka, nenga ndakuleka ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu kakinng'ombela Petili, “Kulyaghila nungukughombela, mupakilo ya lelo kukali na njogholo kubhika, ghwangana pandatu.” ");
INSERT INTO nww_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peni Petili kakilongela, “Hata handa nungunoghwa kuhwegha papamu na ghwenga, ndakuleka ndwee.” Na ahundwa bhangi bhoha bhakilongela ubhwabhu abhu. ");
INSERT INTO nww_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mbole Yesu kakighenda papamu na ahundwa bhake mbaka ku kitogholo kiikemitwe Getisemane, ndo kakiaghombela, “Ntami apa nenga nungughenda pala kuyupa.” ");
INSERT INTO nww_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kakintola Petili papamu na bhala bhana abhili bha Sebedayu, naywo kakiyanda kuhyongoloka na kubhaghaya. ");
INSERT INTO nww_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Mbole kakiaghombela, “Megha na kuhyongoloka mumwoyo hata ugheghela na kuhwegha. Ntame apa papamu na nenga nkotoke kughonja.” ");
INSERT INTO nww_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kakighenda kutali kya mandina, kakighwegha makukama pakayupa, kakilongela, “Tate ywangu, handa yaahotoleka, nnobho aghu ghumbitile kutali, hangi yikotoke kubhegha handa mumbala nenga peni yibheghe handa paghupala ghwenga.” ");
INSERT INTO nww_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kakiaghendela bhala ahundwa bhake na kakiabhona aghonja kala. Kakinkonya Petili, “Yibhegha bhuli mwenga andatu nnepelwa kutama meho na nenga hata lisaa limo? ");
INSERT INTO nww_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nkotoke kughonja, ngati nnyupe nkotoke kuyingila mu mayigho. Kulyaghila nhuki ghubhegha kala, peni mmili ndo nnyoyoho.” ");
INSERT INTO nww_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu kakialeka kangi na kughenda kuyupa kya ubhili kuyupa, “Tate ywangu, handa yinguhotoleka ng'obhe kimbamanda aki kikulu kikotoke kumbitila, hino, ghutende mughupala.” ");
INSERT INTO nww_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pakabhuyite kangi, kakiakolela aghonja, kiyaha bhakitopelwa na ng'ono. ");
INSERT INTO nww_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Habhu kakialeka, kakighenda kangi kuyupa kya undatu paakilongela malagho ghaghala ghala. ");
INSERT INTO nww_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mbole, kakiabhuyila bhala ahundwa na kakiaghombela, “Nkali mungughonja na kupumulila? Nnole, lisaa lihika na Mwana ywa Mundu kangukamuhwa mu mabhoko gha bhandu bhanaulemwa. ");
INSERT INTO nww_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nnyinuke, tughende. Nnole yula ywakangiluka kanguheghelela.” ");
INSERT INTO nww_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu pakabheghitie kakali kangulongela, Yuda, yumu ywa bhala ahundwa kumi na abhili, kakihika pakalongohana na lumati lukulu lwa bhandu bhaabheghite na makechelo na hinduku bhaalaghilitwe na hilongohi bha andundame na hilongohi bha Akaayahudi. ");
INSERT INTO nww_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Basi, aywo ywakapala kunkiluka kakiapegha kala naho kukita, “Mwene yumbala kumjambuha kwa kunkumbatila ndo munkamule.” ");
INSERT INTO nww_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kamu, Yuda kakinhikila Yesu na kumjambuha, “Mwika Nhunda.” Mbole kakinkumbatila. ");
INSERT INTO nww_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu kakinng'ombela, “Ghanja, ghutende kila kighukihikilite.” Mbole bhala bhandu bhakinng'endela na bhakinkamula Yesu na kummopa. ");
INSERT INTO nww_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kamu, yumu ywa bhala bhaabheghite na Yesu pakabhonite agho, kakihomola kihimbi lwake, na kakintuta mmandwa ywa Ndundame Nkulu, na kunkechula lichikilo. ");
INSERT INTO nww_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu kakinng'ombela, “Ghubhuyihe kihimbi muhala yake, kiyaha bhoha bhanakukoma kwa kihimbi bhaakomwa kwa kihimbi. ");
INSERT INTO nww_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Bhuli, nungupala mmanye kukita ningahotolite kunnyupa Tate ywangu, naywo kanganyeghelite kyanalumu ya himati kumi na hibhili hya mahoka bhake bha kunane? ");
INSERT INTO nww_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Peni, handa pandenda habhu, bhuli Malembo gha Chapanga ghangatwihilikite bhuli ghaalongela agha mbaka ghabwituke?” ");
INSERT INTO nww_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mu lisaa alyo Yesu kakilughombela lula lumati lwa bhandu, “Muhikila na makechelo na himbongambonga ngati mungamule nenga handa mpoka, manjubha matangalo nikitama ku Nyumba ya Chapanga panuahunda, kiyaha niki mukinngamula ng'obhe? ");
INSERT INTO nww_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Peni agha ghoha ghabwitukila ngati Malembo ghaatyekitwe na ambuye ghatwihilike.” Ndo ahundwa bhake bhoha bhakibhutuka na bhakinneka. ");
INSERT INTO nww_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bhala bhaankamulite Yesu bhakinnyegha kwa Kayafa ywakabheghite Ndundame Nkulu. Na akwo bhakibhegha ahunda bha malaghilo na hilongohi bha Ayahudi. ");
INSERT INTO nww_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petili kakintughila kya kutali mbaka ku lubhigho lwa nyumba ya Ndundame Nkulu. Kakiyingila mulubhigho lwa nyumba na kakitama papamu na machonda ngati kabhone kiipala kubwituka. ");
INSERT INTO nww_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Basi, hilongohi bha Ayahudi, na andundame na libalasa lyoha likipalaha ayimiho bha uhwangi, ngati bhankome Yesu. ");
INSERT INTO nww_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Peni bhakimokola ng'obhe nnando ghwohele, hata payibhele ayimiho atangalo ahwangi bhakibwituka. Kuuhiko bhakibwituka ayimiho abhili bha uhwangi, ");
INSERT INTO nww_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","bhakilongela, “Mundu ayu kakilongela, ‘Ninguhotola kuyiboghoyola Nyumba ya Chapanga na kuyichenga kangi mu majubha mandatu.’ ” ");
INSERT INTO nww_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mbole, Ndundame Nkulu kakiyima na kunng'ombela Yesu, “Bhuli ghwenga ghubhegha ng'obhe na kyakuyanga? Bhandu abha anguyimiha niki kwa ghwenga?” ");
INSERT INTO nww_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Peni Yesu kakinyamala jii. Ndo Ndundame Nkulu kakinng'ombela, “Ghulape muulongolo ghwa Chapanga yunaubhumi, ghutughombele handa ghwenga ndo Kilisto, Mwana ywa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu kakiyanga, “Ena, handa mughulongela. Peni nunguaghombela bhoha, kutandila hinu maamona Mwana ywa Mundu pakatama mbande ya nnilo ya Chapanga yunamakakala, pakahika mu mahundi gha kunane.” ");
INSERT INTO nww_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ndo Ndundame nkulu kakilakatula mapinda ghake pakalongela, “Ayu kangukundula! Kiyaha niki tungupala uyimiho ghungi kangi? Nnole, hinu mwenga nnyihwa agho makundulo. ");
INSERT INTO nww_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mwenga mungulamila bhuli nnando aghu?” Bhakinnyanga, “Kangunoghwa kuhwegha.” ");
INSERT INTO nww_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mbole bhakinhunila mata ku kibhungi na bhangi bhakinbhakula mabhako, ");
INSERT INTO nww_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ghwenga Kilisto, “Ghulondole, ndo ghani ywakakubhakulite?” ");
INSERT INTO nww_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Lisaa alyo Petili kakitama mulubhigho. Nndumindumi yumu nndala ywa Ndundame Nkulu kakinhikila na kakinng'ombela, “Na ghwenga ghukibhegha papamu na Yesu ywa ku Galilaya.” ");
INSERT INTO nww_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Peni Petili kakikana muulongolo ghwa bhoha pakalongela, “Ningumanya ng'obhe kighukilongela.” ");
INSERT INTO nww_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pakabheghite kangubhuka panje kuhika panlyango, nndumindumi yungi nndala kakimmona, na kakiaghombela bhandu bhaabheghite pala, “Mundu ayu kakibhegha papamu na Yesu ywa ku Nasaleti.” ");
INSERT INTO nww_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petili kakikana kangi kwa kilapo pakalongela, “Nenga nungummanya ng'obhe mundu aywo.” ");
INSERT INTO nww_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mbole kya mandina bhala bhaayimite pala bhakinng'endela Petili na bhakinng'ombela, “Kulyaghila ghwenga ndo yumu ywabhe, kiyaha kuyobhela kwa ghwenga kungulihwana na bhombe.” ");
INSERT INTO nww_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ndo Petili kakiyanda kulikundula na kulapa, “Nenga nungummanya ng'obhe mundu aywo.” Kamu mbichi kakibhika. ");
INSERT INTO nww_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petili kakihwachila lila lilagho lyakalongilite Yesu, “Kukali na kubhika njogholo, ghwangiluka pandatu.” Kakibhuka panje pakalila kwa kuchwina. ");
INSERT INTO nww_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Malabhila putiputi hilongohi bha andundame bhoha na hilongo bha Ayahudi bhakikongan kangi, bhatende luhila lwa kunkoma Yesu. ");
INSERT INTO nww_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bhakimmopa lughoyi na bhakinnyegha kwa Pilato, ywakabheghite ntabhala ywa Akaaloma. ");
INSERT INTO nww_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mbole Yuda ywene ywakankilukite Yesu, pakabhonite kukita Yesu katoswa, kakihyongoloka munu, kakibhuyiha hipalamande salasini hya magwala hyakapeghitwe na hilongohi bha andundame na hilongohi bha Ayahudi. ");
INSERT INTO nww_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kakilongela, “Ndenda ulemwa, kiyaha nughukiluka mwahi ghuutendite ng'obhe uhokelo ghwa kukomwa.” Ndo bhakinnyanga, “Aghwo chepa nnando ghwa kughuhwachila twenga, habhu ghumanye ghumwene.” ");
INSERT INTO nww_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ndo Yuda kakihitagha hila hipalamande hya magwala ku Nyumba ya Chapanga, kakibhuka na kakighenda kulipopotola mwene. ");
INSERT INTO nww_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bhala andundame akulu bhakighatola ghala maghwala na bhakilongela, “Yingunoghwa ng'obhe kuhangangana magwala agha na magwala gha Nyumba ya Chapanga, kiyaha magwala agha ghahombwa ngati mundu kakomwe.” ");
INSERT INTO nww_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Basi, mbole ya kughombana, bhakilamula kuhemela nng'unda ghwa kingandu kya kubhumbila hyombo hya lutupi, ngati pabheghe pakuakulila ahenja. ");
INSERT INTO nww_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ndo mana mbaka lelo bhandu bhangughukema nng'unda aghwo nng'unda ghwa mwahi. ");
INSERT INTO nww_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ndo likitwihilika lila lilagho lya mbuye Yelemia kukita, “Bhakitola hipalamande salasini hya magwala, bei yakapangilitwe na bhandu bha Isilaeli, ");
INSERT INTO nww_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","bhakihemelela nng'unda ghwa kingandu kya kubhumbila hyombo hya lutupi, handa bhula Bambo pakakwilikihite.” ");
INSERT INTO nww_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Linjuba alyo alyo Yesu pakayimite muulongolo ghwa Pilato, nkulu ywa nkoa ywa Akaaloma, naywo kakinkonya Yesu, “Bhuli, Ghwenga ndo Mutwa ywa Akaayahudi?” Yesu kakinnyanga, “Ghwenga ghungulongela.” ");
INSERT INTO nww_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Peni hilongohi bha andundame na hilongohi bha Ayahudi paankokilite kakiyanga ng'obhe lilagho. ");
INSERT INTO nww_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ndo Pilato kakinkonya, “Bhuli, ghunguyihwa ng'obhe ngokelo ahyo highukokelwa?” ");
INSERT INTO nww_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Peni Yesu kakinnyanga ng'obhe hata kwa lilagho limu, kya habhu ntabhala kakikangacha munu. ");
INSERT INTO nww_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Basi, yikibhegha hitohe mulinjubha lya chekwa ntabhala ywa Aloma kummopola mmopwa yumu ywakahaghulitwe na lumati lwa bhandu. ");
INSERT INTO nww_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Manjubha agho kakibhegha mmopwa yumu nhakata, ywakakemitwe Balaba. ");
INSERT INTO nww_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Basi, lumati lwa bhandu palukonganite, Pilato kakiakonya, “Mungupala nubhabhopolele ywoki, Balaba ebu Yesu ywene ywakakemwa Kilisto?” ");
INSERT INTO nww_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kiyaha kakimanya kukita Yesu kakikamuhwa kwa ywombe kiyaha bhakimmonela tama. ");
INSERT INTO nww_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato pakatamite pa kiteho kyake kya toso, nhumbu ywake kakintaghila lilobhe ali, “Ghukotoke kuliyingiha mungokelo ywa mundu ayu ywa maha, kiyaha lelo mbamandika muno maloto kwakya ywombe.” ");
INSERT INTO nww_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Peni hilongohi bha andundame na aghohi bhakilunyegheleha lula lumati lwa bhandu kukita ayupe ngati kabhopolelwe Balaba na Yesu kakakomwe. ");
INSERT INTO nww_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nkulu ghwa nkoa kakiakonya kangi, “Ndo ywoki mu abha abhili mungupala nibhahughulilile?” Bhakiyanga, “Balaba.” ");
INSERT INTO nww_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato kakiaghombela, “Hinu, ndende niki kwa ayu ywakakemwa Kilisto?” Bhakinnyanga, “Ghummambe mulupingika.” ");
INSERT INTO nww_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato kakiakonya, “Kiyaha niki? Katenda uhokelo ghwoki?” Peni bhombe bhakighendelela kuyobha kyobho, “Ghummambe mulupingika.” ");
INSERT INTO nww_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato pakabhonite katahotola ng'obhe kutenda kyohele, na kukita bhulwa ghunguyonjokeheka, kakitola machi, kakikuha mabhoko ghake muulongolo ghwa lula lumati lwa bhandu, pakalongela, “Nenga megha ng'obhe munnando ghwa kiho kya mundu ayu, maamanya mabhene.” ");
INSERT INTO nww_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bhandu bhoha bhakiyanga, “Chapanga katuhyate twenga na bhana bhetu kwa kiho kya mundu ayu.” ");
INSERT INTO nww_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ndo, kakiabhopolela Balaba na mbole ya kukwilikiha kuntuta Yesu hinjupunjupu hya liyula lya ndomondo hiikwatilitwe ndoana, kakimmuha ngati kabhambwe. ");
INSERT INTO nww_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mbole, machonda bha Pilato, bhakinnyegha Yesu muludamu lwa utabhala, na machonda bhoha bhakintindila. ");
INSERT INTO nww_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bhakinhula mapinda ghake na bhakinhwaliha lipinda lya salabati, ");
INSERT INTO nww_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mbole, bhakitendekeha kilemba kya mihomi na bhakinhwika mumutwe ghwake. Bhakinpegha nhimbati mu kibhoko kyake kya nnilo, bhakichutama mayughwa muulongolo ghwake paalongela, “Mwika, Mutwa ywa Akaayahudi.” ");
INSERT INTO nww_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bhakinhunila mata, na bhakighutola ghula nhimbati mu mabhoko ghake na bhakintuta mu mutwe ghwake. ");
INSERT INTO nww_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mbole ya kuntendela agho, bhakinhula lila lipinda, bhakinhwaliha kangi lipinda lyake, na bhakintola ngati bhakammambe mulupingika. ");
INSERT INTO nww_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Paabheghite munjila, bhakikongana na mundu yumu ywa ku Kilene, lihina lyake Simoni, nabho machonda bhakinkwilikiha kalugheghe lula lupingika. ");
INSERT INTO nww_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bhakihika pahala paakemitwe Goligota, fwambulo yake pahala palihuhu lya mutwe. ");
INSERT INTO nww_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bhakinpegha difwai yiihanganganitwe na lusunga. Peni Yesu pakapahite kakilema kunywegha. ");
INSERT INTO nww_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Paammabite kala, bhakighabhana mapinda ghake kwa kutenda usimbi. ");
INSERT INTO nww_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Mbole, bhakitama ngati bhankingikihe. ");
INSERT INTO nww_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Unani mwa mutwe ghwake, mulupingika, bhaibhika lipapi liilembitwe, “AYU NDO YESU, MUTWA YWA AKAAYAHUDI.” ");
INSERT INTO nww_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mbole Apoka abhili bhakibhambwa papamu na ywobe kila mundu mulupingika lwake, yumu mbande yake ya nnilo na yungi mbande ya ngiya ya Yesu. ");
INSERT INTO nww_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bhandu bhaabheghite bhangupita ugheghela na apo, bhakinligha kunu paanokola mitwe yabhe na kunheka, paalongela, ");
INSERT INTO nww_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ghwenga, ghuupala kuboghoyola Nyumba ya Chapanga na kuchenga kwa manjubha mandatu, hinu ghulilopole ghumwene na ghuhuluke muupingika. Handa ghwenga ndo Mwana ywa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ubhwabhu abhu, hilongohi bha andundame na ahunda bha Malaghilo na aghohi bhakinhwangila, paalongela, ");
INSERT INTO nww_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Kakialopoha bhangi, peni kanguhotola ng'obhe kulilopoha mwene. Ywombe ndo Mutwa ghwa Isilaeli. Hinu, kahuluke kuhuma mulupingika ndo twaanhyubhalila. ");
INSERT INTO nww_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kakinndumbila Chapanga, hino, Chapanga kanlopole handa kangupala, kiyaha ywombe kakilongela, ‘Nenga ndo Mwana ywa Chapanga.’ ” ");
INSERT INTO nww_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Na bhala apoka bhaabhambitwe papamu na Yesu bhakinligha ubhwabhu abhu. ");
INSERT INTO nww_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kutandila saa sita mbaka saa tisa nnima ghwoha likbhegha lubhindu totoloo. ");
INSERT INTO nww_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Payihikite saa tisa Yesu kakilila kwa lilobhe likulu, “Eloi, Eloi lama Sabakitani?” Fwambulo yake, “Chapanga ywangu, Chapanga ywangu, bhuli ghunguneka?” ");
INSERT INTO nww_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Amoo bhandu bhaayimite pala paayihwite agho bhakilongela, “Kangunkema Eliya.” ");
INSERT INTO nww_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kamu, yumu ywabhe kakibhutuka lubhilo na kuyegha libhoya liihanganganitwe na siki, kakiyibhika muludenge na kakinpegha Yesu ngati kanyweghe. ");
INSERT INTO nww_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bhangi bhakilongela, “Munneke, ngati tubhone handa Eliya katahika kunlopoha.” ");
INSERT INTO nww_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mbole Yesu kakilila kangi lilobhe likulu, ndo kakihwegha. ");
INSERT INTO nww_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Lisaa alyo alyo, lipasia lya Nyumba ya Chapanga likibaluka hipalamande hibhili, kutandila kunane mbaka pahi. Nnima ghukilendema na matalabha ghakibaluka. ");
INSERT INTO nww_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mandogholo ghakigubutuka na mibhili ya bhandu bha maha yikihyuka. ");
INSERT INTO nww_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Mbole ya Yesu kuhyuka bhakubhuka mumandogholo na bhakiyingila ku kitami king'anyimo na kubhegha bhandu bha ayoloho. ");
INSERT INTO nww_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ndo yula machonda kilongohi na bhala bhaabheghite papamu naywo paakinkingikiha Yesu, paabhonite nnima ghungulendema na ghoha ghaabwitukilite, bhakiyoghopa na bhakilongela, “Kulyaghila ayu kakibhegha Mwana ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Apo pakibhegha na adala paalolekeha kya kutali. Abho bhakintughila Yesu kuhuma Galilaya ngati bhantumikile. ");
INSERT INTO nww_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mubhombe bhakibhegha Malia mundu ywa kuhuma ku Magidala, Malia mama ywabhe Yakobu na Yosefu na mama ywabhe bhana bha Sebedayo. ");
INSERT INTO nww_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Payihikite makimuhi, kakihika mundu yumu yunautopelo ywakakemitwe Yosefu, kuhuma ku Alimataya, na aywo kakibhegha nhundwa ywa Yesu, ");
INSERT INTO nww_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","kakinng'endela Pilato, kughuyupa mmili ghwa Yesu. Pilato kakikwilikiha kapeghwe. ");
INSERT INTO nww_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yosefu kakighutola ghula mmili ghwa Yesu, kakighubhilingiha sanda huhu mbulete, ");
INSERT INTO nww_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","kakighubhika mulindogholo lya hyono lyakalihonguliti mwene mulitabhala. Mbole, kakibingiliha libho likulu mu nlyango ghwa lindogholo na kakighenda. ");
INSERT INTO nww_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Malia ywa ku Magudala na yula Malia yungi bhakitama ugheghela ghwa lindogholo. ");
INSERT INTO nww_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kilabho yake, ndo linjubha lya kupumulila, hilongohi bha andundame na Afalisayu bhakinng'endela Pilato, ");
INSERT INTO nww_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","bhakilongela, “Nkulu, tungukulungwa kukita yula nkubhuhi, kukali ya kuhwegha kakilongela, ‘Mbole ya majubha mandatu ndaahyuka.’ ");
INSERT INTO nww_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Basi, ghukwilikihe ngati lindogholo likingikihwe mbaka linjubha lya ndatu. Hela bhubho, ahundwa bhake bhatahotola kughuyibha mmili ghwake na kuaghombela bhandu kukita kahyuka. Ukubhuhi aghwo ghwa uhiko ghwaabhegha nhakata kyanalumu kupitingana ghula ghwa kalongohi.” ");
INSERT INTO nww_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato kakiaghombela, “Mwenga mmegha na machonda akingikiha. Nng'ende mukalikingikihe lindogholo handa bhula mummanya.” ");
INSERT INTO nww_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kya habhu, bhakighenda na machonda ngati bhakalikingikihe lindogholo kwa makakala ghoa, bhakibhika mango mu lila lindogholo na kubhika ukingiki ho. ");
INSERT INTO nww_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mbole ya kupita Linjubha lya Kupumulila, na payihikite malabhila putiputi ya lijubha lya ulongohi lya juma, Malia ywa kuhuma ku Magudala na yula Malia yungi bhakighenda kulilolekeha lila lindogholo. ");
INSERT INTO nww_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kamu, pakibhegha na lulendemo lukulu lwa lutupi, kiyaha lihoka ywa Bambo kakihuluka kuhuma kunane na kakighenda kulindogholo, kakilibingiliha lila libho na kakilitamila. ");
INSERT INTO nww_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kibhungi kyake aywo lihoka ywa Chapanga kiking'alima na mapinda ghake ghakibhegha mahuhu mbuletee. ");
INSERT INTO nww_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bhala machonda bha lindogholo bhakiyoghopa muno, bhakiloghoya munu na bhakibhegha handa ahwegha. ");
INSERT INTO nww_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Yula lihoka ywa Chapanga kakiaghombela bhala adala, “Nkotoke kuyoghopa, kiyaha nungumanya kukita mungunpalaha Yesu ywakabhambitwe mulupingika. ");
INSERT INTO nww_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kabhegha ng'obhe apa, kahyuka, handa pakalongilite. Nhike mupalole pala pakaghonjihitwe. ");
INSERT INTO nww_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Basi, nngende kwa kuyumbatika mukaaghombele ahundwa bhake kukita, ‘Kahyuka, naywo kabhalongolela kughenda ku Galilaya. Akwo ndo mammona, nkotoke kulibhalila aki kinubhaghombela.’ ” ");
INSERT INTO nww_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Habhu, bhala adala bhakibhuka pala palindogholo, paabhegha na bhwaghalili peni bhakibhegha na uyelelo nkulu, bhakibhutuka lubhilo ngati bhakaaghombele ahundwa bhake mihalo ayo. ");
INSERT INTO nww_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Paabheghite bhangughenda, pindulu, Yesu kakikongana nabho, na kakilongela, “Mwika.” Bhala adala bhakinheghelela, bhakighakamula maghulu ghake na bhakintundamila. ");
INSERT INTO nww_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ndo Yesu kakiaghombela, “Nkotoke kuyoghopa. Nng'ende mukaaghombele alongo bhangu aghende ku Galilaya, akwo ndo bhamona.” ");
INSERT INTO nww_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bhala adala paabheghite bhangughenda, amoo bha machonda bhaabheghite bhangukingikiha lindogholo, bhakighenda ku kitami na bhakiaghombela hilongohi bha andundame milando hyoha yiibwitukite. ");
INSERT INTO nww_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mbole, bhala andundame bhakikongana na hilongohi bha Akaayahudi na mbole ya kughombana, bhakiapegha bhala machonda ngalabha nyoloho ");
INSERT INTO nww_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","bhakiaghombela, “Mwenga mukalongele naha, ‘Ahundwa bhake bhakihika pakilo, bhakihika kuuyibhammili ghwake, twenga patubheghite tungughonja.’ ");
INSERT INTO nww_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na handa nhalo aghu pakayihwa ntabhala ywa Akaaloma, twenga twaayobhela naywo kataahyata ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Habhu, bhala machonda bhakiyitola yila ngalabha na bhakitenda handa paaghombilitwe na andundame. Nhalo aghu ghukwila kwa Akaayahudi mbaka lelo. ");
INSERT INTO nww_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ndo bhala ahundwa kumi na yumu bhakighenda mbaka ku Galilaya ku kila kitumbi kyakaalaghilite na Yesu. ");
INSERT INTO nww_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Paammonite, bhakintundamila, peni amoo bhabhe bhakibhegha na bhwaghalili. ");
INSERT INTO nww_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu kakiahikila ugheghela na kakiaghombela, “Ngamuhwa makakala ghoha kunane kwa Chapanga na munnima. ");
INSERT INTO nww_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Basi, nng'ende mukaatende bhandu bha milima hyoha abheghe ahundwa bhangu, pamuabatisa kwa lihina lya Tate, na lya Mwana na lya Nhuki ywa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Na muahunde kuyighungilu milando hyoha yinibhakwilikihite mwenga. Kulyaghila nenga megha papamu na mwenga manjubha ghoha mbaka ku uhiko ghwa nndaluko.”");
INSERT INTO nww_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Aghu ndo ulongohi ghwa Nhalo ghwa Maha ghwa Yesu Kilisto, Mwana ghwa Chapanga ");
INSERT INTO nww_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ghukiyanda handa payityekwite mukitabho kya mbuye ghwa Chapanga ywakakemitwe Isaya, “Chapanga kakighomba ‘Nannlaghiha ndumitumi ghwangu muulongolo ghwako katayitendekeha njila yako.’ ");
INSERT INTO nww_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Lilobhe lya mundu lingukema kukibhala; ‘Muyitendekhe njila ya Bambo, muyighololehe ndyangilo yake.’ ” ");
INSERT INTO nww_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yohana kakibwitukila kukibhala, pakihingula na kubhalandamiha bhandu pakighomba, “Mulipetule kyakya ulemwa ghwenu na muhingulwe na mwene Chapanga kataghulekekeha ulemwa ghwenu.” ");
INSERT INTO nww_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bhandu ayoloho kuhuma ku nnima ghwa Yudea na bhoha bha kitami kya Yelusalemu bhakinng'endela na bhakilipetula uhokelo ghwabhe naywo kakiabatisa mulukemba lwa Yoludani. ");
INSERT INTO nww_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana kakihwala lipinda litendekehitwe kwa mayuni gha nnyama ywakakemitwe ngamia na nkungi ghwa liyula mukibhuno kyake. Hilyo hyaki hikibha mapalala na bhuchi. ");
INSERT INTO nww_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Naywo kakialandamiha bhandu pakighomba “Ywa apala kuhika mbole ya nenga kabha na makakala makulu kupitingana kwa nenga, yiteghekwa ng'obhe hokame na kulegheha ngoyi gha makobasi hyake. ");
INSERT INTO nww_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nenga ndabhabatisa kwa machi, peni ywombe kataabatisa kwa Nhuki ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mu masiku agho Yesu kakihika kuhuma Nasaleti kitami kya ku Galilaya naywo kakibatiswa na Yohana mulukemba lwa Yoludani. ");
INSERT INTO nww_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kamu Yesu pakahumite mumachi, kakibhona luhingu lukiyughuka na Nhuki ghwa Chapanga kakinhulukila unani ghwake handa ngunda. ");
INSERT INTO nww_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Lilobhe likiyihwanika kuhuma kuluhingu; “Ghwenga ndo! Mwana ghwangu yunughupala nungunoghelwa na ghwenga.” ");
INSERT INTO nww_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pala pala! Nhuki ghwa Chapanga kakinlongoha kughenda kukibhala ");
INSERT INTO nww_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kakitama akwo masiku mbinda mabhoko ncheche kunu kaking'ehwa na Nchipila akwo kakibha papamu na anyama bha kunhitu, nabho andumitumi ghwa kuluhingu bha Chapanga bhakinlela. ");
INSERT INTO nww_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohana pakabhopwite kukibhopo, Yesu kakighenda ku nnima ghwa Galilaya, kakiyanda kulandamiha Nhalo ghwa Maha ghwa Chapanga, ");
INSERT INTO nww_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","kunu pakaghomba, “Uhiko uhika kala, na Ghubhutwa ghwa Chapanga ghunguheghelela; Mulipetule na kuhyubhalila Nhalo ghwa Maha ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu pakabheghite mukutyanga mumbwegha ya lihibha lya Galilaya, kakiabhona Simoni na Andelea nnongo ghwake paatagha njaho hyabhe mulihibha; mana akibha aghomeha homba. ");
INSERT INTO nww_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu kakiaghombela, “Munhikile, na nenga ndabhahunda kunnyeghela bhandu handa aghomeha homba paayegha homba.” ");
INSERT INTO nww_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pala pala, bhakiyileka njaho hyabhe na bhakintughila. ");
INSERT INTO nww_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Pakatyangite kya mandina, kakiabhona Yakobu na Yohana, bhoha bhana bha Zebedayo. Nabho bhubho bhakibha mubhwato, paatandabhuha njaho hyabhe. ");
INSERT INTO nww_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pala pala, kakiakema, nabho bhakinleka tate ghwabhe Zebedayo mubhwato papamu na andumitumi bhabhe, bhakighenda na kuntughila Yesu. ");
INSERT INTO nww_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu na ahundwa bhake bhakilongohana mbaka ku Kapelinaumu, palihikite Lisiku lya Kupughwa Yesu kakiyingila mu kitutubhi kya kukonganila Akaayahudi, na kakiyanda kuhunda. ");
INSERT INTO nww_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bhandu bhakikangacha munu kya mahundo ghake, mana kakibha mukubhahunda handa mundu yuna makakala, kiyaha kakilihwana ng'obhe na ahunda bha malaghilo. ");
INSERT INTO nww_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Peni apo, pakibhegha mundu yunamandilo mu kitutubhi kya ngonganilo yabhe, naywo kakikyota kyobho ");
INSERT INTO nww_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ghuna niki na twenga Yesu ghwa Nasaleti? Ghuhika kutukanjaghana? Manya kukita ghwenga ndo! Ghani, Nng'anyimo ghwa Chapanga!” ");
INSERT INTO nww_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu kakinlakalila, pakighomba, “Ghunyamale, Na ghunneke mundu ayu.” ");
INSERT INTO nww_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ghala mandilu ghakinnyukayuka kakikyota kyobho na kakinmuka. ");
INSERT INTO nww_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bhandu bhoha bhakikangacha na kukonyekehana, “Ayi ndo mihalo ghani? Ndo Mahundo gha hyono? Kangi ghana makakala gha utabhala kanguakwilikiha mandilo nabho bhangu nnyitikila!” ");
INSERT INTO nww_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mihalo yake yikikwila kanongola nongola mumilima hyoha ya Galilaya. ");
INSERT INTO nww_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Bhakibhuka mu kitutubhi kya kukonganila bhakighenda papamu na Jakobu na Yohana mbaka kulubhagha lwa Simoni na Andelea. ");
INSERT INTO nww_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na ma ghwa nhumbu ghwa Simoni kakibha na nhehemela tepatepa paulili, bhakinkambukiha Yesu mihalo yake. ");
INSERT INTO nww_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ndo Yesu kakinng'endela, na kunkamula kibhoko na kunnyinula. Mbole nhehemela ghukinnekekeha, naywo kakiyanda kuakeyela. ");
INSERT INTO nww_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Payihikite makimuhi, na luchubha palutipikiti, akinng'eghela Yesu bhandu bhananhehemela na bhaakwelitwe na mandilo. ");
INSERT INTO nww_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bhandu bhoha bha kitami kila bhakikwemukila paulongolo ghwa kitutubhi kya Simoni. ");
INSERT INTO nww_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu kakialamiha atamwa ayoloho na bhana mihehemela nhanganganiko na kakiabhuha mandilo ayoloho, peni kakibhaleka ng'obhe ghala mandilu bhaghombe kiyaha bhakimanya kukita ywombe ndo ghani. ");
INSERT INTO nww_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Malabhila putiputi pangeha kukali na lubhindu, Yesu kakibhuka ngati kaghende panga bhandu kakan'tundamile Chapanga. ");
INSERT INTO nww_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni na ayake bhakighenda kunpalaha, ");
INSERT INTO nww_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Paammonite, bhakinng'ombela “Bhandu bhoha angughupalaha!” ");
INSERT INTO nww_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu kakiayanga, “Tughende pamoo pangi pa hitami hya nng'eghela, ngalandamihe na akwo nakwo, kiyaha akyo ndo kinikihikilite.” ");
INSERT INTO nww_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kakitindila Galilaya hyoha, kakilandamiha muhitutubhi ya kukonganikila Akaayahudi na kughabhuha mandilo. ");
INSERT INTO nww_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mundu yumu ywakabheghite na maloha kakinng'endela Yesu, kakinchutamila mayughwa na kunnyupa, na kung'ombela, “Paghupala, ghwahotola kunghulula!” ");
INSERT INTO nww_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu kakimmonela luhungu, kakigholoha kibhoko kyake kakinnyabhika kunu pakanng'ombela “Ningupala ghululika!” ");
INSERT INTO nww_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kamu maloha ghakinbhuka naywo kakighululika. ");
INSERT INTO nww_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Mbole ya kunkanikiha, Yesu kakinlekekeha kaghende kunu pakanng'ombela ");
INSERT INTO nww_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ghukotoo kunng'ombela mundu ywoheli yula mihalo ayi peni ghughende ghukalilahe kwa ndundame bha Chapanga na ghukatule matulo kya kughululikwa kwako handa pakakwilikihite Musa yibhe uyimiho kwa bhombe kukita ghulama.” ");
INSERT INTO nww_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Peni yula mundu kakibhuka kakiyanda kualubhulila bhandu mihalo ya kulamihwa kwa mwene kya nga uhiho. Hinu Yesu kakilepelwa kuyingila kangi mumilima kya nga uhiho, peni kakitama panje ya kitami mbande ya nga bhandu. Hata naha bhandu bhakintughila Yesu kuhuma mumbande hyoha. ");
INSERT INTO nww_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mbole ya masiku gha mandina, Yesu kakibhuya ku Kapelinaumu, bhandu bhakiyihwa kukita kakibha ukaya. ");
INSERT INTO nww_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Hino bhakikwemukana bhandu ayoloho, bhakimema kupitingana kunlyango mbaka paulongolo ghwa kitutubhi. Yesu kakibha pakialandamiha lilagho lyake. ");
INSERT INTO nww_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Lisaa lilalila bhandu ncheche bhakihika na bhakinng'egha mundu nlelebhaho kwa Yesu. ");
INSERT INTO nww_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kiyaha ya lumati lwa bhandu bhakilepelwa kunheghekeha pakabheghite Yesu. Hinu bhakihotola lunyakaha lubheghite unani pakabheghite Yesu, paahotolite kala bhakinhuluha aywo mundu pakaghonjite mulikahe. ");
INSERT INTO nww_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu pakabhoniti uhyubhalilo ghwabhe kakinng'ombela yula nlelebhaho “Mwana ghwangu, ‘ghulekekehwa ulemwa ghwako.’” ");
INSERT INTO nww_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Amoo bha ahunda bha malaghilo bhaatamite pautamo aghwo, bhakihwacha mumyoyo yabhe. ");
INSERT INTO nww_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Yibha bhuli mundu ayu kangughomba naha? Ayu kangunkundula Chapanga! Kahone mundu ywakulekekeha ulemwa maha nga Chapanga ghweka chake.” ");
INSERT INTO nww_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kamu Yesu kakighamanya mahwachilo gha myoyo yabhe, kakiakonya, “Bhuli munguhwacha habhu mumyoyo yenu? ");
INSERT INTO nww_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kingiki kya kunoghelwa muno, kunng'ombela mundu nlelebhaho, ‘Ghulekekehwa ulemwa ghwako ebu kunng'ombela ghuyinuke ghutole likahe lyako ghutyange?’ ");
INSERT INTO nww_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Hinu nungupala mmanye kukita Mwana ghwa Mundu kabhegha na makakala gha utabhala ghwa kualekekeha bhandu ulemwa ghwabhe munnima” Ndo Yesu kakinng'ombela yula nlelebhaho. ");
INSERT INTO nww_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ningughughombela ghuyime, ghutole likahe lyako ghughende ukaya kwako.” ");
INSERT INTO nww_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kamu, kakiyima na kakitola likahe lyake na kakibhuka. Bhandu bhoha bhakikangacha na kunkwiha Chapanga paakilongela, “Twenga tuyibhona ng'obhe mihalo handa ayi.” ");
INSERT INTO nww_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu kakighenda kangi mumbwegha bwegha ya lihibha lya Galilaya. Lumati lukulu lwa bhandu lukinhikila naywo kakiyanda kuahunda. ");
INSERT INTO nww_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pakabheghite mukutyanga kakinmona Lawi mwana ghwa Alufayu kakitama pakitutubhi kya lusumulo sumu, Yesu kakinng'ombela “Ghunndughile” Lawi kakiyimuka na kuntughila. ");
INSERT INTO nww_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mbole yake Yesu kakitama mukulyegha hilyo, mulubhagha lwa Lawi, kakibha papamu na bhanakusumula sumu ayoloho na bhana ulemwa bhakibhegha mukulyegha papamu na ahundwa bhake, mana kukibha na bhandu ayoloho bhaantughiliti ");
INSERT INTO nww_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Amoo ahunda bha malaghilo na Akaafalisayu paammonite pakalyegha papamu na asumula lusumu na bhanaulemwa bhakiakonya ahundwa bhake, “Kiyaha niki Yesu kangulyegha papamu na bhanakusumula sumu na bhana ulemwa?” ");
INSERT INTO nww_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu pakayihwite kakiaghombela, “Bhandu bha ngautamwa ampala ng'obhe nng'anga, maha atamwa. Hika ng'obhe kubhakema bhandu bha maha, ngati bhana ulemwa.” ");
INSERT INTO nww_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Hinu, ahundwa bha Yohana na ahundwa bha akaafalisayo bhakulikunga kulyegha. Amoo bhandu bhakinhikila Yesu kunkonyekeha, “Bhuli ahundwa bha Yohana na ahundwa bha Akaafalisayo bhangulikunga kulyegha, peni bhuli ahundwa bhako bhangulikunga kulyegha ng'obhe?” ");
INSERT INTO nww_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu kakiayanga “Ahenja bha bambo yuna chekwa ya kutolela bhahotola bhuli kulikunga kulyegha pala bambo yuna chekwa ya kutolela paabheghite papamo nabho? Kiyaha yuna chekwa ya kutolela lisiku alyo kabhegha papamu na bhombe kabhone kulikunga kulyegha. ");
INSERT INTO nww_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Peni lisiku lyahika kwa yuna chekwa ya kutolela kubhuhwa mubhombe; peniapwo ndo bhatahotola kulikunga kulyegha hilyo.” ");
INSERT INTO nww_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Bhandu apabhikagha ng'obhe kipabhiko kya hyono mulikama. Handa paatenda naha akyo kipabhiko kya hyono kyalakatukanga likama alyo nalyo lyakanjabhanika munu. ");
INSERT INTO nww_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na kabhone mundu yuna kubhika difwai ya hyono mu mihako ihakalite ya mayula handa paatenda naha yila difwai ya hyono yahibalula yila mihako ihakalite gha mayula kangi divai yayitika pahi na nhako ghula ghuhakalite ghwa metukana. Divai ya hyono yingubhikwa mu mihako hya hyono.” ");
INSERT INTO nww_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Lisiku limu lya Kupughwa, Yesu kakibha mukutyanga mumighunda ya mapemba. Paabheghite mukutyanga ahundwa bhake bhakiyanda kubena mahonjo gha mapemba. ");
INSERT INTO nww_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Akaafalisayo bhakinkonya Yesu, “Ghulole! Kiyaha niki ahundwa bhako angutenda nhalo ghwanga kunoghelwa lisiku lya kupughwa?” ");
INSERT INTO nww_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu kakiayanga, “Mukali kusoma ng'obhe yakatendite Daudi na ayake paabheghite na njala? ");
INSERT INTO nww_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Daudi kakiyingila mukitutubhi kya Chapanga, kakilyegha yila mangate yibheghite yakya Chapanga. Nhalo aghu ghukitendwa paabheghite Abitai ndundame nkulu. Na ndo andundame ghweka chabhe akiyeghekehwa kulyegha mangate ayo ya kya Chapanga. Peni Daudi kakilyegha, kangi kakiapegha ayake” ");
INSERT INTO nww_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu kakibhaghombela “Lisiku lya kupughwa likitendekwa kwa kya bhandu na ng'obhe bhandu kwa kya Lisiku lya kupughwa. ");
INSERT INTO nww_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Hila hila Mwana ghwa Mundu ndo Bambo ghwa Lisiku lya Kupughwa.” ");
INSERT INTO nww_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu kakiyingila kangi mu kitutubhi kya kukonganila Akaayahudi, na akwo pakibha na mundu yumo yunaulelebhaho ghwa kibhoko. ");
INSERT INTO nww_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Amwo, amoo bhandu bhangi bhakintyegha kanlamihe mundu ayo lisiku lya kupughwa apati ngupukiho ya kuntakila. ");
INSERT INTO nww_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu kakinng'ombela mundu yula ywakalelebhukite kibhoko, “Ghuhike apa paulongolo” ");
INSERT INTO nww_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mbole kakiakonya bhandu, “Hinu lyoki likunoghelwa kutendwa mu lisiku lya kupughwa, kutenda mihalo ya maha ebu mahakataho, kulopoha ubhumi ebu kukoma?” Peni bhombe akinyamala jii. ");
INSERT INTO nww_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu kakialolekeha bhoha kwa kiyaghabhu, na kakikukulika kwa hyeta ya myoyo yabhe, na kakinng'ombela yula mundu, “Ghugholohe kibhoko kyako!” Kakikigholoha kibhoko kyake na kikibha kya maha kangi. ");
INSERT INTO nww_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kamu Akaafalisayo bhakighenda panji kutenda ngokeho pamoo na bhandu bha kimati kya Helode bhakipalaha njila ya kunkanjaghana Yesu. ");
INSERT INTO nww_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu kakibhuka papamu na ahundwa bhake kakighenda kumbwegha ya lihibha Galilaya na bhandu ayoloho kuhuma kunnima ghwa Galilaya, ");
INSERT INTO nww_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ku Idumea kumwambo ya lukemba Yoludani, kiyaha bhakiyihwa mihalo miyoloho yakatendite, ");
INSERT INTO nww_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kiyaha ya kya lumati lukulu lwa bhandu Yesu kakiaghombela ahundwa bhake, bhanyeghele bhwato atame amwo ngati lumati lwa bhandu lukotoke kunnyuka. ");
INSERT INTO nww_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kiyaha Kakialamiha atamwa bha mahele, ndo bhala bhana utamwa bhakiyukana ngati anbyale. ");
INSERT INTO nww_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Bhandu bha abheghite na mandilo paanmonite Yesu bhakilitagha pahi pa ulongolo ghwa maghulu ghake na bhakikyota kyobho, “Ghwenga ndo Mwana ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Peni Yesu kakiakwilikiha ghala mandilu kwa lilakali bhakotoke kummanyiha kwa bhandu. ");
INSERT INTO nww_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu kakihubhuka kukitumbi, kakiakema bhala abhahaghulite nabho bhakighenda naywo. ");
INSERT INTO nww_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kakiahaghula mbinda mabhoko yimo na abhili ndo abha akiakema Andumitumi, ngati abheghe papamu na ywombe, kakaalaghihe kulandamiha ");
INSERT INTO nww_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","kangi abheghe na makakala gha kughabhinga bhinga mandilu. ");
INSERT INTO nww_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Abha ndo bhala mbinda mabhoko yimo na abhili akabhahaghuliti, Simoni ywene Yesu kakinpegha lihina lya Petili, ");
INSERT INTO nww_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobu na Yohani bhana bha Zebedayu, bhombe kakibhapegha lihina Boanelege, mana yake ndo bhana bha lulundumo, ");
INSERT INTO nww_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andelea na Filipi na Batolomayo na Matayo na Tomasi na Yakobu mwana ghwa Alufayo na Tadayo na Simoni Nkananayu na ");
INSERT INTO nww_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yuda Isikaliyoti, ywene ywakankilukite Yesu. ");
INSERT INTO nww_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mbole Yesu kakibhuya ukaya, lumati lwa bhandu lukikwemuka kangi, mbaka mwene na ahundwa bhake bhakilepelwa kulyegha hilyo. ");
INSERT INTO nww_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Paayihwite alongo bhake mihalo ayi bhakighenda kuntola, mana bhandu bhakighomba, “Kayingilwa na nng'uluka.” ");
INSERT INTO nww_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ahunda bha malaghilo bhakihika kuhuma ku Yelusalemu, bhakighomba, “Ayu kana Belisebuli! Kangi kangubhabhinga bhinga mandilo kwa makakala gha nkulu ghwa mandilo.” ");
INSERT INTO nww_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Hinu Yesu kakibhakema bhombe na kubhaghombela kwa mihwanu, “Nchipila katahotola bhuli kunbhinga bhinga Nchipila nnyake? ");
INSERT INTO nww_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Handa ghubhutwa ghumo ghumegheka mulumati hinakupingikana, ghubhutwa agwo ghwalama ng'obhe. ");
INSERT INTO nww_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na handa lubhagha lumo lutamegheka mulumati lumati lunakupingikana, lubhagha alwo lutatengeleheka ng'obhe. ");
INSERT INTO nww_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Na handa ghubhutwa ghwa nchipila ghutapwilinganika mu himati hichoko hichoko kabhone kuhotola na uhiko ghwake ghuhika.” ");
INSERT INTO nww_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Kabhone mundu ywohele yula ywakahotola kuyingila kukitutubhi kya mundu yuna makakala na kunpoka utopelo ghwake, mbaka kakantute na kammope mundu aywo, ndo katahotola kunpoka utopelo ghwake.” ");
INSERT INTO nww_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Kulyaghila nungubhaghombela gha hoto bhandu bhatalekekehwa ulemwa ghwabhe ghwoha na ngundulo hyabhe hyoha kwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Peni yunakunkundula Nhuki ghwa Chapanga kabhone kulekekehwa, kana nongwa ya ulemwa ghwa masiku ghoha.” ");
INSERT INTO nww_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu kakighomba habhu kiyaha bhombe bhakighomba, “Kana lindilo.” ");
INSERT INTO nww_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ma ghwake Yesu na alongo bhake bhakihika papamu na bhakiyima panji, bhakinlaghila mundu kankeme. ");
INSERT INTO nww_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lumati lwa bhandu lukibha palukintindila. Ndo, bhandu bhakinng'ombela, “Ma ghwako na alongo bhako bhabhegha panji, bhangukukema.” ");
INSERT INTO nww_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu kakiayanga, “Ma ghwangu na alongo bhangu ndo a ghani?” ");
INSERT INTO nww_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Apa kakialolekeha bhala bhandu bhaantindilite, na kakighomba, “Abha ndo ma ghwangu na ndo alongo bhangu. ");
INSERT INTO nww_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mundu ywohele ywakatenda ghakaghapala Chapanga, aywo ndo nlongo ghwangu na nhacha ghwangu na ndo ma ghwangu.” ");
INSERT INTO nww_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu kakiyanda kangi kuhunda mumbwegha ya lihibha lya Galilaya. Lumati lukulu lwa bhandu lukinkwemukila mbaka ywombe kakilamula kuhubhuka mubhwato ghuubheghite mulihibha na kakitama amo, lumati lwoha lukibhegha kuuyumu ya mbwegha ya lihibha. ");
INSERT INTO nww_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kakihunda mihalo miyoloho kwa ndambulo, mumahundo ghake kakilongela, ");
INSERT INTO nww_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nnyihwani! Pakibhegha nkweta mbeyu yumo kakighenda kukweta mbeyu hyaki. ");
INSERT INTO nww_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pakabheghite mukukweta mbeyu, yingi yikiponeka munjila, hiyuni akihika kuihonyola. ");
INSERT INTO nww_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yingi yikiponeka mumaganga pa nga lutupi nnyoloho, yikimela kwa kulopokeha, kiyaha lutupi lukibha luchoko. ");
INSERT INTO nww_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Luchubha paluyakiti yikiyuma mana ngigha hyake hikibha hupitaho hikinyaluka. ");
INSERT INTO nww_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yingi yikiponeka pamikongo yina mihomi, nayo yikikula na yikiyipepechula, nahyo hikipapa ng'obhe mapambika. ");
INSERT INTO nww_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yimoo yingi yikiponeka mulutupi lwa maha, yikimela, yikikula na yikipapa mapambika, yimu mbinda mabhoko ndatu, yimu mbinda mabhoko sita, na yimu mbinda mabhoko kumi.” ");
INSERT INTO nww_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Mbole kakiaghombela, “Ywakabhegite na makutu kakayihwe.” ");
INSERT INTO nww_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu pakabheghite pa ghweka chake, amoo bhangi bhaannyihwanilite bhakinng'endela papamo na bhala ahundwa mbinda mabhoko yimo na abhili, bhakinkonya kumanyika kya mandambulo ghala. ");
INSERT INTO nww_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu kakibhaghombela, “Mwenga mulekekehwa kumanya mbwepo ya ghubhutwa ghwa Chapanga, peni bhala bha abheghite panji bhataghombelwa kilibhi kyohele kwa mandambulo. ");
INSERT INTO nww_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ngati, ‘Kulola bhaayolola hoto, peni kahone kuyibhona. Kuyihwa baayihwanila, peni kahobhe kumanya. Hela bhumbho bhangankilibhukiliti Chapanga, naywo nge kabhalekekehite.’ ” ");
INSERT INTO nww_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mbole Yesu kakibhakonya, “Muyimanya ng'obhe ndambulo ayi? Mutaghamanya bhuli mandambulo mamoo ghangi? ");
INSERT INTO nww_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nkweta mbeyu aywo kakikweta lilagho lya Chapanga. ");
INSERT INTO nww_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bhandu bhangi ndo handa mbeyu yiponikite munjila; Kamu paaliyihwa lilagho, Nchipila kahika na kulibhuha lilagho lila liikwetitwe mumyoyo yabhe. ");
INSERT INTO nww_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bhandu bhangi ndo handa mbeyu yila yiponikite mumaganga. Kamu paayihwa lilagho alyo bhangulipokela kwa uyelelo. ");
INSERT INTO nww_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Peni lingubhayingila ng'obhe na kubhegha na ngigha mumyoyo yabhe. Bhahyatilagha behi ng'o, mbole ya mapungwo na luhuyu kya lilagho alyo, kamu bhangulileka lila lilagho. ");
INSERT INTO nww_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bhandu bhangi ndo handa hila mbeyu hiponikite mumikongo yina mihomi. Abha ndo nhwano ghwa bhala bhaaliyihwanila alyo lilagho, ");
INSERT INTO nww_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Peni bhwaghalili ghwa nnima aghu, tama ya utopelo na tama ya hyoheli hila payihika na kuliyuka lila lilagho na kulitenda likotoke kupapa. ");
INSERT INTO nww_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Peni amo bhangi abhegha handa mbeyu hikwetwite mulutupi lwa maha. Ndo bhandu bhayihwanilite lilagho alyo, na kulikingama na kupapa mapambika gha maha na bhangi mbinda ndatu bhangi mbinda mabhoko sita na bhangi mbinda mabhoko kumi.” ");
INSERT INTO nww_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kakiaghombela “Bhuli hino limbamba lyakwatwa na kugubikwa pahi mulijamanda ebu pahi palihungu lya ulili? Ng'obhe, lyakwatwa na kubhikwa kunane mwa kinyuta kyake. ");
INSERT INTO nww_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kiyaha kahobhe kilibhi kyoheli kila kinakuhihwa kya nga kuhwimulighwa, ebu nhalo ghwoheli ghwa lupwepo ghwangayeghwa pakindandabhanji. ");
INSERT INTO nww_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mundu yuna makutu gha kuyihwa, kayihwe.” ");
INSERT INTO nww_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kakiaghombela kangi, “Mmanye maha ghamuliyihwa, malaghilo ghala gha mumubhatosa bhangi, Chapanga kataatosa mwenga kangi na kupitingana. ");
INSERT INTO nww_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kiyaha yuna kilibhi katayonjokehwa kingi, naywo ywa nga kilibhi kangi, katapokwa hata kilibhi kichoko kyakabheghite nakyo.” ");
INSERT INTO nww_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu kakiaghombela “Ghubhutwa ghwa Chapanga ghulihwana na mundu ywakakwetite mbeyu munng'unda, ");
INSERT INTO nww_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mbole ya kukweta, pakabheghite mukughonja ebhu pakabheghite meho, mbeyu yikumela na kukula kya nga kumanya payikula. ");
INSERT INTO nww_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mana lutupi lunguyitenda mbeyu imele yibhe nmela; mbole lukibha lihonjo mbole mbunje mulihonjo. ");
INSERT INTO nww_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Peni mbeyu pa iyelite, kamu, nkweta mbeyu aywo katayingila mung'unda na kikwakwa kya kubenela mabeno.” ");
INSERT INTO nww_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu kakighomba kangi, “Tughulandanihe na niki Ghubhutwa ghwa Chapanga? Ebu tughukambuhe na nhwanu ghani? ");
INSERT INTO nww_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Gubhegha handa mbunje ya nhaladali, yene ndo njoko njoko munu kupitingana na mbeyu hyoha yinakukwetwa mulutupi. ");
INSERT INTO nww_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Peni payikwetwa kala, yingumela na ghubhegha nkongo nkulu kupitingana na mikongo hyoha ya mumighunda. Matambalilo ghake ghangubhegha makulu na hiyuni anguchenga hiyumba hyabhe mumatambaliho agho.” ");
INSERT INTO nww_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kwa mandambulo ghangi mayoloho, Yesu kakighomba nabho lilagho lyake handa pabhahotolite kuyihwa na kumanya. ");
INSERT INTO nww_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kakighomba ngo'bhe kyanga ndambulo, Peni pakabheghite na ahundwa bhake kakiahotolela hoto ya hilibhi hyoha ya ndambulo yila. ");
INSERT INTO nww_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lisiku alyo makimuhi, Yesu kakiaghombela ahundwa bhake, “Tuyomboke tughende kumwambo ya lihibha.” ");
INSERT INTO nww_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bhakiluleka lula lumati lwa bhandu, bhakibhuka naywo mumbwato ghwakabheghite. Kangi yikibhegha na mibhwato miyoloho yikintughila. ");
INSERT INTO nww_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kamu likibhegha liyegha likulu lukiyanda kupula, na liyuka lya machi likilututa bhwato ghula mbaka machi ghakiyanda kumema mubhwato. ");
INSERT INTO nww_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu kakibhegha kunyuma ya libhwato pakighonja munhaghamilo, ahundwa bhake bhakinnyumuha mung'ono na aking'ombela, “Nhunda, ghungubhona ng'obhe hamba tungupala kuhwegha?” ");
INSERT INTO nww_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu kakiyumuka na kakililakalila lila liyegha na kakilikwilikiha liyuka lya machi mulihibha “Ghuyime, ghutengeleke,” kamu kamu liyuka likiyima tuli na kukibha tuli maha muno. ");
INSERT INTO nww_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Mbole Yesu kakiaghombela ahundwa bhake, “Kiyaha niki mukuyoghopa? Nkali na uhyubhalilo ng'obhe?” ");
INSERT INTO nww_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nabho bhakiyoghopa muno, bhakikonyekeana, “Ayu ndo ghani? Mwene likusi na mayuka gha machi ghangunnyihwa!” ");
INSERT INTO nww_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu na ahundwa bhake bhakiyomboka kumwambo ya lihibha Galilaya na bhakihika kunnima ghwa Akaagelasi. ");
INSERT INTO nww_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu pakahulukite mubhwato kamu kakikongana na mundu yuna lindilu pakahuma kumandogholo. ");
INSERT INTO nww_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mundu ayo masiku ghoha kakitama akwo kumandogholo, kahone mundu ywakahotolite kunkanikiha ebhu kunmopa kwa nnyololo ");
INSERT INTO nww_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pipipi bhakimmopa nnyololo mumabhoko na kingongolo maghulu peni kakimetulanga akyo kingongolo mumaghulu ghake na kahone mundu yuna makakala gha kunkanikiha. ");
INSERT INTO nww_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pakilo na pamuhi kakibhegha kumandogholo na kuhitumbi pakakyota kyobho na kulikachanga kwa maganga. ");
INSERT INTO nww_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pakanmonite Yesu kya kutali, kakintughila na kakinchutamila mayughwa pakibhungi kyake. ");
INSERT INTO nww_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Kakikyota kyobho kwa makakala na pakighomba, “Ghuna niki na nenga, Yesu, Mwana ghwa Chapanga abheghite kunani muno? Nungukuyupa kwa Lihina lya Chapanga ghukotoke kumbamanda.” ");
INSERT INTO nww_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kakilongela naha kiyaha Yesu kakibha pakinng'ombela “Ghumbhuke ayo mundu ghwenga lindilu!” ");
INSERT INTO nww_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu kakinkonya “Lihina lyako ghani?” Mwene kakinnyanga “Lihina lyangu machonda, kiyaha tubhegha ayoloho” ");
INSERT INTO nww_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kakinnyupa muno Yesu kakotoke kubhatagha kutali na nnima ghula. ");
INSERT INTO nww_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ugheghela na pala pauhelelo ghwa kitumbi bhakibhegha maghulubhe ayoloho bhakihakilwa. ");
INSERT INTO nww_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ghala mandilu bhakinnyupa paaghomba, “Ghutuyeghe kwa bhala maghulubhe, ghutulekekehe tubhayingile.” ");
INSERT INTO nww_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu kakibhalekekeha. Ndo ghala mandilu ghakinbhuka yula mundu na kubhayingila bhala maghulubhe. Lula lumati lukibhegha na maghulubhe elufu ibhili, ndo lukihelela kungende na bhakidibala mu lihibha. ");
INSERT INTO nww_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bhala bhandu bhaabheghite mukuhakila bhala maghulubhe, bhakitughila kukitami na kuhijiji hyoha kulubhulila nnando agho. Bhandu bhakighenda kulola ghaghabwitukilite. ");
INSERT INTO nww_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bhakihika kwa Yesu na bhakinmona yula mundu ywakabheghite na lumati lwa mandilu, kakihwala lipinda, na luhala lwake lukimmuyila, bhandu bhoha kiyoghopa. ");
INSERT INTO nww_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bhala bha bhakabhonite nlando aghwo bhakiaghombela na bhandu amo bhangi, ghaabwitukilite kwa yula mundu ywakabheghite na mandilu na ghaghabwitukilite kwa lula lumati lwa maghulubhe. ");
INSERT INTO nww_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hinu, bhandu bhakiyanda kunyupa Yesu kabhuke munnima ghwabhe. ");
INSERT INTO nww_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu pakabheghite mukuyingila mubhwato, yula mundu ywakabheghite na mandilu kakinnyupa Yesu kaghende papamu naywo. ");
INSERT INTO nww_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu kakinkanikiha, ndo kakinng'ombela “Ghughende ukaya kwa aghanja bhako ghukaaghombele milandu mikulu yakakutendilite Bambo, na pakakubhonelite luhungu.” ");
INSERT INTO nww_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yula mundu kakighenda na kakiyanda kulandamiha ako ku Dekapoli, mana yake nnima ghuna hitami mbinda mabhoko yimo, ghala ghakatendelitwe na Yesu, na bhandu bhoha bhakikangacha. ");
INSERT INTO nww_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu pakayombokite kangi kwa bhwato kughenda kumwambo ya lihibha Galilaya. Bhandu ayoloho akikwemukala na mwene kakibhegha umbwegha ya lihibha. ");
INSERT INTO nww_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ndo kilongohi yumo ywa kitutubhi kyakukonganila Akaayahudi ywakakemitwe Jailu, kakinhikila pala, na pakanmonite Yesu kakichutamila mayughwa pakibhungi kyake, ");
INSERT INTO nww_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kannpembeleha pakalongela, “Nhinja ghwangu nndokwa kangutamwa tepatepa paulili, Ningughuyupa ghuhike na ghunnyabhike kibhoko kyako ngati kalame kabhe bha maha.” ");
INSERT INTO nww_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ndo Yesu kakighenda papamu naywo, bhandu ayoloho bhakinntughila na akinnyuka mbande hyoha. ");
INSERT INTO nww_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Apwo pakibhegha ndala yumu yuna liholobhela mungungwa mbinda libhoko yimo na hibhili. ");
INSERT INTO nww_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ndala aywo kakipungwa muno kwa kughenda kwa aghanga ayoloho. Na kakiyomola hilibhi hyoha hyakabheghite naywo, peni mbole ya kulama ndo utamwa ghukintopela muno. ");
INSERT INTO nww_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Naywo kakibhegha pakayihwite mihalo ya Yesu na kakinhikila Yesu kya kuhyetu ya lumati lwa bhandu na kakilibyala lipinda lyake, ");
INSERT INTO nww_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","kiyaha kakighomba mumwoyo ghwake, “Handa nda hotola kulibyala lipinda lyake, kulyaghila ndalama.” ");
INSERT INTO nww_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kamu, liholobhela lyake likiketuka, naywo kakighubhona mmili ghwake ghulama. ");
INSERT INTO nww_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Kamu, Yesu kakimanya kukita makakala ghake ghakinlamiha mundu. Kakilupilukila lula lumati na kakilukonyekeha, “Ndo ghani aywo ywakabyalite lipinda lyangu?” ");
INSERT INTO nww_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ahundwa bhake bhakinnyanga, “Ghumwene ghungubhona lumati lwa bhandu palighuyuka, hinu yibhegha bhuli ghungukonyekeha, ndo ghani aywo ywakakuyabyalite?” ");
INSERT INTO nww_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Peni Yesu kakilolekeha mbande hyoha ngati kammone aywo ywakanbyalite. ");
INSERT INTO nww_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Yula nndala kakimanya kila kinbwitukllite kakinyingilwa lyogha, kakiloghoya na kakighwila mumaghulu ghake na kakinlubhulila hyoha hyakanbwitukilite. ");
INSERT INTO nww_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu kakinng'ombela, “Nhinja, uhyubhalilo ghwako ghukulopoha. Ghughende kwa uhihimilo, na ghulame kulukulu utamwa ghwako.” ");
INSERT INTO nww_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Pakabheghite mukughomba, Bhandu bhakihika kuhuma kulubhagha lwa yula kilongohi ghwa kitutubhi kya kukonganika Akaayahudi bhakinng'ombela, “Nhinja ghwako kahwegha kala, kiyaha niki kunng'aha nhunda?” ");
INSERT INTO nww_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pakayihwite agho Yesu kakinng'ombela aywo nkulu ghwa kitutubhi kya kukonganikila Akaayahudi, “Ghukotoke kuyoghopa ghwenga ghuhyubhalile tu” ");
INSERT INTO nww_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kakinlekekeha ng'obhe mundu yumooyungi ywa kulongohana naywo maha nga Petili na Yakobu na Yohana nnongo ghwake Yakobu. ");
INSERT INTO nww_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pakahikite mulubhagha lwa yula kilongohi ghwa kitutubhi kya kukonganila Akaayahudi, Yesu kakibhona bhulwa, bhandu kwa bhakilila ngukuliko na kwa lilobhe likulu. ");
INSERT INTO nww_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pakayingilite munyumba kati, kakiaghombela, “Kiyaha niki mungutenda bhulwa na kulila? Nhinja kahwegha ng'obhe, ngati kaghonja hela.” ");
INSERT INTO nww_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Bhala bhandu bhakinheka kwa uyuyuho. Peni mwene kakiabhuha bhoa panje, kakibhatola tate na ma ghwa yula nhinja papamu na bhala ahundwa bhake andatu. Kakiyingila munyumbakati mbaka pala pakabheghite yula nhinja ");
INSERT INTO nww_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kakinkamula kibhoko yula nhinja na kaking'ombela, “Talita komu!” Mana hyaki “Nhinja nungughughombela yumuka.” ");
INSERT INTO nww_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kamu yula nhinja kakiyima, na kakiyanda kutyanga, aywo nhinja kakibhegha na ngungwa mbinda mabhoko yimo na hibhili. Bhandu paaghabhonite agha bhakikangacha muno ");
INSERT INTO nww_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu kakialaghila kwa lilakali bhakotoke kung'ombela mundu nhalo ghula, na kakiaghombela bhanpeghe yula nhinja hilyo. ");
INSERT INTO nww_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu kakibhuka akwo na kakighenda kukitami kyabhe, na ahundwa bhake bhakintughila. ");
INSERT INTO nww_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Palihikite lisiku lya kupughwa, kakiyanda kuhunda mu kitutubhi kya kukonganila Akaayahudi, na bhandu ayoloho paayihwite bhakikangacha. Bhakikonya, “Mundu ayu kayihopola kwoki mihalu ayi hyoha? Nnole ndo mahala gha bhuli ghakabheghite nagho? Nnole ndendelo ya mihabho ghakayitenda. ");
INSERT INTO nww_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Aywo ndo yula nhongola hilibhi hya mikongo ng'obhe? Mwana ghwa Malia? Alongo bhake ndo Yakobu na Yosefu, Yuda na Simoni ng'obhe? Ahacha bhake ndo abha ng'obhe tubhegha nabho papamu?” Nabho bhakiyaghabhihwa munu kwa kya ywombe bhakinhyula ");
INSERT INTO nww_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu kakiaghombela, “Mbuyi ghwa Chapanga kanguhokamilwa kwoha, ngati ng'obhe mukitami kyake na mu aghanja bhake na alongo bhake.” ");
INSERT INTO nww_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ndo kakitenda ng'obhe nhabho ghwoheli ghula, peni kakiayabhikila mabhoko atamwa bha mandina na kakialamiha. ");
INSERT INTO nww_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Na Yesu kakikangacha Muno kiyaha bhakihyubhalila ng'obhe? Mbole Yesu kakihityangila hijiji hya ugheghela pakiahunda bhandu. ");
INSERT INTO nww_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kakiakema bhala ahundwa mbinda mabhoko yimo na abhili, na kakialaghiha abhili abhili na kakiapegha makakala gha kughabhuha mandilu. ");
INSERT INTO nww_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kakialaghiha pakighomba, “Nkotoke kutola kyoheli mumwanja maha ntole lukongocho weka chake. Nkotoke kutola lingate, ebu nhako ghwa mapinda, ebhu ngalabha. ");
INSERT INTO nww_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nhwale tabhalanda, peni nkotoke kuhwala lipinda lingi.” ");
INSERT INTO nww_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kangi kakiaghombela, “Kitutubhi kyoheli kila kya abhakingama ntame apwo nkotoke kubhuka bhuka, mbaka lisiku lila lya kubhuka mukitami akyo. ");
INSERT INTO nww_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Handa poheli pala paabhalema kubhakingama ebu kubhayihwa, npumunde lihu mumaghulu ghenu ngati yibhe uyimiho kwa bhombe.” ");
INSERT INTO nww_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ndo bhakibhuka na kughenda kulandamiha bhandu ngati bhalipetule na kuleka ulemwa ghwabhe. ");
INSERT INTO nww_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bhakiabhinga bhinga mandilu mayoloho, na bhakiatyeka mahuta gha nzeituni atamwa ayoloho na kualamiha. ");
INSERT INTO nww_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Hinu mutwa Herode kakiyihwa mihalu ayi, kiyaha mihalu ya Yesu yikimanyikwa poheli. Bhandu bhangi bhakighomba, “Yohana yunakubatisa kakihyuka kuhuma kumambi ndo mana makakala ghake ghakutenda mihabho mu mwene!” ");
INSERT INTO nww_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bhandu bhangi bhakighomba, “Mundu ayu ndo! Eliya” na amoo bhandu bhakighomba, “Mundu ayu ndo mbuyi, handa mmoo yumo ghwa mambuye bha makachu.” ");
INSERT INTO nww_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Peni Helode pakayihitwe nhalu aghu, kakighomba, “Aywo ndo Yohana yunakubatisa, yununndumulite mutwe, hinu kahyuka!” ");
INSERT INTO nww_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kiyaha Helode kakikwilikiha Yohana yunakubatisa kakamulwe na kabhikwe mukibhopo. Kakitenda naha kiyaha kakintola Helodia nndala ghwa Filipo nnongo ghwake mwene Helode. ");
INSERT INTO nww_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohana kakinng'ombela Helode, “Yinoghela ng'obhe kwa ghwenga kuntola nndala ghwa nnongo ghwako.” ");
INSERT INTO nww_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ndo Helodia kakibha na kihyongololo na Yohana kakipala kunkoma. Peni kakihotola ng'obhe. ");
INSERT INTO nww_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kiyaha Helode kakinnyoghopa Yohana kakimanya kukita ndi mundu ghwa maha na nng'anyimo, kakinpingikiha. Herode kakinoghelwa kunnyihwanila Yohana peni kakihyononeka muno pakayomolite kunnyihwa. ");
INSERT INTO nww_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Lisiku limu Helodia kakipata ling'ebu muchekwa hwachilo ya lisiku lya kubhelekwa kwa Herode. Helode kakialalika aghohi bha libalasa lyake, alongohi ghwa machonda ghwa mikoha, na alongohi ghwa ako ku Galilaya. ");
INSERT INTO nww_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ndo nhinja ghwake Helodia kakiyingila kukina, na Helode kakiyelelwa papamu na bhandu bha abheghite mu hilyo. Mutwa Helode kaking'ombela yuna nhinja, “Ghunyupe kyoheli kighukipala na nenga ndaghupegha.” ");
INSERT INTO nww_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kangi kakinlapila yula nnhinja “Ndaghupegha lyoheli lila lyakapala kuyupa, hata ngabhee lihinda lya ghubhutwa ghwangu.” ");
INSERT INTO nww_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Yula nhinja kakighenda panji kunkonya ma ghwake, “Nyupe niki?” Maghwake kakinyanga, “Ghuyupe mutwe ghwa Yohana Yunakubatisa.” ");
INSERT INTO nww_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kamu yula nhinja kakibhuya kanongola kaking'ombela mutwa, “Mbala ghumbeghe hinu apa mutwe ghwa Yohana Yunakubatisa mukipalo.” ");
INSERT INTO nww_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mutwa kakihyononeka muno, peni kiyaha kakilapila muulongolo ghwa ahenja kakilepelwa kunkanila. ");
INSERT INTO nww_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kamu mutwa kakinlaghila yumoo ywa machonda na kakinkwilikiha kakangheghele mutwe ghwa Yohana. Kakighenda kukibhopo na kakinndumula mutwe ghwa Yohana Yunakubatisa. ");
INSERT INTO nww_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mbole yula lichonda kakiyegha mutwe mukipalo na kakinpegha yula nhinja, na yula nhinja kakinpegha ma ghwake. ");
INSERT INTO nww_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ahundwa bha Yohana paayihwite nhalo ghula, bhakighenda kughutola ntumba ghwake, bhakinkulila. ");
INSERT INTO nww_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Bhala andumitumi bha Yesu bhakibhuya na bhakinng'ombela mihalu hyoha yaatendite na kuhunda. ");
INSERT INTO nww_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Pakibhegha bhandu ayoloho muno bhaghenditeghe na kubhuka kwa Yesu mbaka Yesu na andumitumi bhake mbaka bhakilepelwa kulyegha, kakiaghombela ahundwa bhake, “Tughende pa nga bhandu, ngati makapughwe” ");
INSERT INTO nww_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ndo bhakibhuka ghweka chabhe mu mbhwato bhakighenda kutama pa nga bhandu. ");
INSERT INTO nww_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Peni bhandu ayoloho bhakiabhona paaghenda, na bhakipamanya paaghendite, nabho bhakighenda kwa maghulu kuhuma mu kila hitami, nabho bhakilongola kuhika. ");
INSERT INTO nww_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu pakahikite ku nnima nnyumu na kulubhona lula lumati lwa bhandu, kakiabhonela luhungu kiyaha bhakibhegha handa mene bha nga nhakila. Hino kakiyanda kubhahunda mihalo miyoloho. ");
INSERT INTO nww_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Makimuhi paghaheleliti, ahundwa bhake bhakinng'endela na bhakinng'ombela, “Apa patutamite ndo pakibhala na hinu lubhindu lunguyanda kuyingila. ");
INSERT INTO nww_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Hino ghualaghe bhandu aghende mumighunda na mu hijiji hya kubhwegha bhakahemele hilyo.” ");
INSERT INTO nww_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Peni Yesu kakiayanga “Mubhapeghe mwenga hilyo.” Bhakinnkonya, “Nhunda ghungubhona ng'obhe kukita yingutupala tubheghe na ngalabha nyoloho ndo twahotola kubhahemelela bhandu abha hilyo?” ");
INSERT INTO nww_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu kakiakonyekeha, “Ng'ende mukalolekehe yibhegha mangate milingi?” Bhakighenda na paabhuyite bhakinng'ombela, “Yibhegha mangate nhano na homba abhili.” ");
INSERT INTO nww_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ndo Yesu kakiakwilikiha bhaatamihe bhandu mu himati himati mumanyahi mabhihi. ");
INSERT INTO nww_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nabho bhakitama muhimati hya bhandu mbinda mabhoko kumi na bhangi mbinda mabhoko nhano. ");
INSERT INTO nww_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mbole Yesu kakiyitola yila mangate nhano na bhala homba abhili kakilolekeha kuluhingu, kakinnumba Chapanga, kakiyimetula yila mangate, na kakiapegha ahundwa bhake bhabhapeghe bhandu bhoha. Hila hila bhakiapegha bhandu bhoha bhala homba abhili. ");
INSERT INTO nww_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bhandu bhoha bhakilyegha na bhakiyukuta. ");
INSERT INTO nww_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ahundwa bhake bhakihiyola mahighalo gha hipalamande hya mangate na homba, na bhakimemekeha hikapu mbinda mabhoko yimo na hibhili. ");
INSERT INTO nww_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mbalango ya bhandu alumi bha alyeghite bhakibhegha elfu nhano. ");
INSERT INTO nww_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kamu, Yesu kakiakwilikia ahundwa bhake ayingile mu mbhwato bhalongole kughenda ku Betisaida kumwambo ya lihibha, mwene pakabheghite mukualagha lumati lula lwa bhandu. ");
INSERT INTO nww_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Mbole ya kualagha bhandu, mwene kakighenda kukitumbi kunntundamila Chapanga. ");
INSERT INTO nww_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Payihikite makimuhi ghula bhwato ghukibhegha pakati ya lihibha, na Yesu kakibhegha ghweka chake munnima nnyumu. ");
INSERT INTO nww_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kakiabhona ahundwa bhake mu bhwato akighayaghaya pa bhakibhyatula kwa makakala, kiyaha likibhegha liyegha likiapingika. Ugheghela na kuchegha Yesu kakiaghendela ahundwa bhake pakityanga unani mwa machi. Ywombe hamba kakapaliteghe kubhayomboka. ");
INSERT INTO nww_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Peni paanmonite pakityanga unani mwa machi bhakihwacha kakibha lihoka, bhakitula kyobho. ");
INSERT INTO nww_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kiyaha bhoha paanmonite bhakiyoghopa muno. Mbole Yesu kakighomba nabho, “Nkotoke kuyoghopa! Ndo nenga!” ");
INSERT INTO nww_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kakihubhuka mubhwato ghwa abheghite na lila liyegha likiyima! Bhala ahundwa bhakikangacha muno. ");
INSERT INTO nww_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kiyaha bhakimanya ng'obhe nhalo ghwa yila mangate abhalyeghitehe bhandu elfu n'hano, ndo mahala ghabhe ghakighubhanikwa. ");
INSERT INTO nww_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Paayombokiti lihibha, bhakihika nnima ghwa Genesaleti, bhakipaghika bhwato ghwabhe ");
INSERT INTO nww_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pabhahulukite kuhuma mu bhwato ghula, bhandu bhakinmanya Yesu, ");
INSERT INTO nww_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Bhakighenda mu nnima ghwoha kanongola nongola, bhakiayegha atamwa mumikahe yabhe na bhakiayegha kwoheli paayihwite kukita Yesu kakibhegha. ");
INSERT INTO nww_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na kwoheli kula pakaghendite Yesu, yibhe muhijiji na muhitami ebu mumighunda bhandu bhakiabhika atamwa bhabhe pa hindangabhanji na bhakinpembeleha kabhategheke bhabyale lipinda lyake na bhoha bhaanbyalite lipinda lyake bhakilama. ");
INSERT INTO nww_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Akaafalisayo na amoo bha Ahunda bha malaghilo bhaahumite ku Yelusalemu bhakikwemukila kuulongolo ghwa Yesu. ");
INSERT INTO nww_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bhakiabhona amoo bha ahundwa bha Yesu bhakilyegha hilyo kwa mabhoko ghabhe kya nga kukuha handa mughapalite malaghilo gha Akaayahudi. ");
INSERT INTO nww_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Akaafalisayo na Akaayahudi bhoha kahone kulyegha hilyo mbaka akuhe mabhoko ghabhe mbaka ku kingogho kiyaha angukamulila hitohe hya aghohi bhabhe. ");
INSERT INTO nww_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Paahuma ku hindandabhanji kahone kulyegha mbaka akuhe. Kangi yibhegha hitohe hingi hiyoloho hya ahalite handa bhula kughulula ndebho, hibhigha na hilibhi hya mahabha. ");
INSERT INTO nww_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Hino bhala ahunda bha malaghilo na Akaafalisayu bhakinkonya Yesu, “Yibha bhuli ahundwa bhako bhangutughila ng'obhe mihumu ya aghohi bhetu mbole yake angulyegha kwa mabhoko ghana kinyakali?” ");
INSERT INTO nww_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu kakiayanga, “Mbuye Isaya kakilondola hoto ya kya mwenga, mwenga maafyangu, handa pakatyekite, Chapanga kangulongela, ‘Bhandu abha bhangunyikitila kwa milomo yabhe, peni miyoyo yabhe yibhegha kutali na nenga. ");
INSERT INTO nww_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bhangundundamila yaghi, paakihunda hitohe hya anabhandu paakighomba agho ndo malaghilo gha Chapanga.’ ");
INSERT INTO nww_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mwenga muyileka malaghilo gha Chapanga na kuyikamula mihumu ya anabhandu.” ");
INSERT INTO nww_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu kakiaghombela, “Mwenga mmegha na njenjelo ya kuyilema ngwilikiho ya Chapanga ngati muyikamule mihumu yenu! ");
INSERT INTO nww_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kwa nhwano, Musa kakighomba, ‘Ghubhayikitile tate na ma ghwako’ na ‘ywoheli ywakanligha tate ghwake ebu ma ghwake kakomwe’ ");
INSERT INTO nww_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Peni mwenga mungughomba, mundu ywakanng'ombiliti tate ghwake ebu ma ghwake kukita, ‘Kila kya kukutanga ghwenga ndo Kolibani’ kukita kibhibhegha lilumbo lya kya Chapanga, ");
INSERT INTO nww_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mbole ya agha kangukwilika ng'obhe kuntanga tate ebu ma ghwake. ");
INSERT INTO nww_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kwa njenjelo ayi mwenga munguyuyuha lilagho lya Chapanga kwa mihumu yenu yimulibhikilite. Mwenga mukutenda mihalu miyoloho yakya njenjelo ayo.” ");
INSERT INTO nww_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu kakilukema kangi lula lumati lwa bhandu na kakiaghombela, “Nnyihwanile, bhoha na mmanye nlando aghu. ");
INSERT INTO nww_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kahone kilibhi kina kunyingiha mundu kakatende ulemwa kwa kya Chapanga, peni kina kummuka ndo kina kunbhika mundu kakatende ulemwa kwa kya Chapanga. ");
INSERT INTO nww_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Handa mundu ywoheli yuna makutu gha kuyihwa, na kayihwe.” ");
INSERT INTO nww_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pakalulekiti lula lumati lwa bhandu na kuyingila munyumba kati, ahundwa bhake bhakinkonya mana ya ndambulo yila. ");
INSERT INTO nww_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kakiayanga, “Na mwenga mmanya ng'obhe? Mmanya ng'obhe kukita kilibhi kinakunnnyingila kahone kunbhika mundu kakatende ulemwa kwa kya Chapanga? ");
INSERT INTO nww_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kiyaha mundu pakalyegha kilibhi kingunnyingila ng'obhe mu mwoyo maha mulutumbo, mbole kingummuka panji ya mmili bhake.” Kya kulongela naha Yesu kakihiteghekeha hilyo hyoha kukita hya maha kwa kulyeghwa. ");
INSERT INTO nww_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kakighendelela kughomba, “Kila kinakummuka mundu ndo kingunbhika kabhe na ulemwa kwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kiyaha kuhuma mumwoyo ghwa mundu kungubhuka, hwachilo ya mahakataho na utyahe na bhwihi na kukoma na ");
INSERT INTO nww_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","lumatamata na tama ya uhakata na ukiluko na uhwangi na tama ya utopelo na malili na maligho na lukilu na ubhughabhugha. ");
INSERT INTO nww_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mihalu ayi hyoha yinguhuma mu mwoyo ghwa mundu naywo na ndo yina kunbhika mundu kabhe nhokela.” ");
INSERT INTO nww_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ndo Yesu kakibhuka akwo na kakighenda ku nnima ghubheghite ugheghela na Tilo. Kakiyingila mu kitutubhi kimo, na mwene kakipala ng'obhe bhandu amanye kukita kabhegha amo. Peni kakihotola ng'obhe kulihiha. ");
INSERT INTO nww_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Peni nndala yumo ywakabheghite na nhinja nndokwa naywo kakibhegha na mandilu kakiyihwa mihalu ya Yesu na kakinhikila na kakichutamila mayughwa muulongolo ghwa Yesu. ");
INSERT INTO nww_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Hinu aywo nndala kakibhegha ng'obhe Nnyahudi, nkolannima ghwa ku Foinike ya akwo Silia. Kakinnyupa Yesu kakaghabhuhe mandilu kwa nhinja ghwake. ");
INSERT INTO nww_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu kaking'ombela, “Ghubhaleke bhana ayukute huti, yibhegha maha ng'obhe kutola hilyo ya bhana na kuataghila kabhwa.” ");
INSERT INTO nww_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Peni yula nndala kakinnyanga, “Bambo, na akabhwa abheghite pahi pakindangabhala alyeghagha mahighalo gha hilyo hya bhana.” ");
INSERT INTO nww_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ndo Yesu kakinnyanga, “Kiyaha ya kya liyango alyo, ghughende kulubhagha lwako na yula lindilu kammuka kala nhinja ghwako.” ");
INSERT INTO nww_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kakibhuya kulubhagha lwake na kakinmona nhinja ghwake kakighonja paulili, na lila lindilu likimmuka kala. ");
INSERT INTO nww_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mbole Yesu kakibhuka ako ugheghela na Tilo, kakipitila Sidoni mbaka Dekapoli nnima ghuna hitami mbinda mabhoko yimo mbaka kakihika kulihibha Galilaya. ");
INSERT INTO nww_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Akwo bhandu bhakinnyeghela mundu yumu ywa nga kuyihwa na kana kimama, bhakinnyupa kakannyabhikile kibhoko kyake ngati kakannlamihe. ");
INSERT INTO nww_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mbole Yesu kakinnyegha yula ywa nga kuyihwa kutali na bhandu, Yesu kakinnyingiha hikonji hyake mu makutu ghake, kakihuna mata muhikonji hyaki na kakilubyala lulimi lwa yula mundu. ");
INSERT INTO nww_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Mbole kakilolekeha kunani kuluhingo kakitweta kwa makakala kakinng'ombela, “Efata!” Mana yake “Hughuka.” ");
INSERT INTO nww_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kamu, makutu ghake ghakihughuka na lulimi lwake lukilekekehwa kakiyanda kulongela maha. ");
INSERT INTO nww_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu kakibhakwilikiha bhakotoo kunnongela mundu ywohele mihalo aywo. Peni paabhakanikihite ndo bhakiyonjokeha kulandamiha munu mihalu aywo. ");
INSERT INTO nww_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bhandu bhoha bhakikangacha munu, bhakilongela “Katenda mihalo hyoha yinakunoghela munu, kabhatangatila bha nga kuyihwa, kuyihwa, na bhana kimama bhalongele.” ");
INSERT INTO nww_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mumasiku agho, lumati lukulu lwa bhandu lukikwemuka kangi, na bhakibhegha ng'obhe na hilyo. Hino Yesu kakiakema ahundwa bhake na kakiaghombela, ");
INSERT INTO nww_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nungulubhonela luhungu lumati alu lwa bhandu, kiyaha hino bhabhegha na nenga kwa masiku mandatu na kibhahone kya kulyegha. ");
INSERT INTO nww_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Handa panialagha aghende ukaya kwabhe kya nga kulyegha, bha hima kwa njala munjila, mana amoo bhangi ahumila kutali.” ");
INSERT INTO nww_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ahundwa bhake bhakinkonya, “Apa pakibhala twahumbula kwoki mangati gha kukwila kulyegha lumati lwoha alu?” ");
INSERT INTO nww_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu kakiakonya, “Mubha na mangate milingi?” Ahundwa bhake akinnyanga, “Tubhegha na mangate saba.” ");
INSERT INTO nww_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kakiakwilikiha bhandu bhoha atami pahi. Ndo kakiyitola yila mangate saba, kakinnumba Chapanga kakiyimetulanga yila mangate, kakiapegha ahundwa bhake abhaghabhanikihe bhandu, nabho bhakiaghabhanikiha bhandu. ");
INSERT INTO nww_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Hilahila bhombe bhakibhegha na hihomba hya mandina, Yesu kakinnumba Chapanga kwa kya bhala homba na kakiakwilikiha ahundwa bhake abhapeghe bhandu ubwabhu abhu. ");
INSERT INTO nww_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Bhandu bhala bhakilyegha na kuyukuta na mbole yake ahundwa bhakikungana hipalamande hihighalite na bhakimemekeha hikapu nhano na ibhili. ");
INSERT INTO nww_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bhandu bha alyeghite akibhegha elfu ncheche. Ndo Yesu kakialagha. ");
INSERT INTO nww_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kamu kakihubhuka mubhwato papamo na ahundwa bhake na kakighenda ku kitami kya Dalumanuta. ");
INSERT INTO nww_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Amoo bha Akaafalisayo bhakinhikila Yesu, na bhakiyanda kughombana naywo kwa kunng'eha na bhakinpala katende nhabho ghwa kunmanyiha kwa bhene kukita makakala ghake ghakuhuma kwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Peni Yesu kakikukulika mumwoyo na kakiaghombela, “Kiyaha niki kibheleko aki kingupala nhabho? Kulyaghila, nungubhaghombela, kya kamuhwa ng'obhe nhabho ghwoheli.” ");
INSERT INTO nww_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Mbole kakibhaleka, kakihubhuka ku bhwato, na kakiyomboka kumwambo yingi ya lihibha. ");
INSERT INTO nww_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ahundwa bhake bhakilibhalila kuyegha mangate ya kukwila, na bhakibhegha na lingate limo mubhwato. ");
INSERT INTO nww_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu kakiatakilila, “Nhingukihe, na linjakamu lya Akaafalisayo na linjakamu lya Helode.” ");
INSERT INTO nww_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bhakiyanda kughombana bhene kwa bhene, bhakighomba, “Kangulongela naha kiyaha tuyegha ng'obhe mangate.” ");
INSERT INTO nww_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu kakighamanya maghombano ghabhe, na kakiakonya, “Kiyaha niki mungughombana nhalo ghwa nga kuyegha mangate? Nkali kundambula ebu kumanya ng'obhe? Yibha bhuli mioyo yenu yibha na unonopo naha? ");
INSERT INTO nww_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Bhuli mmegha na meho peni mungulepelwa kubhona! Bhuli mmegha na makutu peni mungulepelwa kuyihwa? Bhuli nde mungundambula ng'obhe? ");
INSERT INTO nww_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pala pametulite mangate nhano na kubhalyegheha bhandu Elfu nhano, mukikungana mahighalo gha hikapu hilingi?” Ahundwa akinnyanga, “Mbinda mabhoko yimo na hibhili.” ");
INSERT INTO nww_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Na pametulite yila mangate nhano na ibhili na kualyegheha bhandu elfu ncheche, mukikungana mahighalo gha mangate, hikapu hilingi himemekihitwe?” Akinnyanga “Nhano na ibhili.” ");
INSERT INTO nww_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ndo kakiakonya “Nde nkali kumanya?” ");
INSERT INTO nww_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu na ahundwa bhake bhakihika ku Betisaida, amoo bhandu bhakinnyegha mundu ywa nga kubhona, bhakinnyupa kakan'yabhike. ");
INSERT INTO nww_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu kakinkamula kibhoko ywa nga kubhona aywo, kakinnyegha panji ya kijiji. Kakinhunila mata mu meho ghake yula ywa nga kubhona na kunmikila mabhoko mu meho, kakinkonya “Ghungubhona kilibhi kyoheli?” ");
INSERT INTO nww_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yula ywa nga kubhona kakilola, kakilongela, “Ningubhona bhandu angubhonekana handa mikongo yinakutyanga.” ");
INSERT INTO nww_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu kakinmikila kangi mabhoko ghake mumeho yula ghwa nga kulola. Naywo kakihulutula meho, kubhona kwake hinu kukimmuyila, kakilola hilibhi hyoha telatela. ");
INSERT INTO nww_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu kakinlagha kabhuye ukaya kwake na kakinkwilikiha, “Ghukotoo kuyingila kukijiji.” ");
INSERT INTO nww_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu na ahundwa bhake bhakibhuka na kughenda nng'eghela mwa hijiji hya Kaisaliya Filipi. Paabheghite munjila, Yesu kakiakonya, “Bhandu angulongela nenga ndo ghani?” ");
INSERT INTO nww_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bhakinnyanga, “Amoo bhandu angulongela ghwenga ndo Yohana yunakubatisa, bhangi angulongela ghwenga ndo Eliya na bhangi angulongela ghwenga ndo yumoo yumo ywa mambuye ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesu kakiakonya, “Mwenga mungulongela nenga ndo ghani?” Petili kakinnyanga, “Ghwenga ndo Kilisto ywakahaghulitwe na Chapanga.” ");
INSERT INTO nww_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Mbole Yesu kakiakanikiha, “Akotoo kunlongelela mundu ywohele mihalo ya nenga.” ");
INSERT INTO nww_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Hino Yesu kakiyanda kuhunda ahundwa bhake, “Mwana ghwa Mundu katambamandwa na katalemwa na aghohi, na mandundame akulu na ahunda bha malaghilo. Kukita katakomwa, na mbole ya masiku mandatu katahyuka.” ");
INSERT INTO nww_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu kakilongela habhu kya nga uhiho. Ndo Petili kakinkemela pambwegha na kakiyanda kunlakalila. ");
INSERT INTO nww_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Peni Yesu kakikilibhuka na kualolekeha ahundwa bhake, kakinlakalila Petili na kakilongela. “Ghubhuke kughulongolo ghwangu Nchipila! Ghwenga ghwangahwacha gha Chapanga ngati gha anabhandu.” ");
INSERT INTO nww_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mbole kakilukema lula lumati lwa bhandu na ahundwa bhake, kakiaghombela, “Mundu ywohele ywakapala kundughila, mbaka kalileme mwene, kalutole lupingika lwake, kandughile nenga. ");
INSERT INTO nww_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mana mundu ywohele ywakapala kuulopoha ubhumii ghwake katauhobheha, peni mundu ywaka uhobheha ubhumi ghwake kwa kya nenga na kwa kya Mihalo ya Maha kataulopoha. ");
INSERT INTO nww_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mundu katamota niki handa kataghukamula nnima ghwoha na kuuhobheha ubhumi ghwake? Kabhone kumota kyoheli. ");
INSERT INTO nww_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ebu mundu katabhika kilibhi ghani kihegheke ubhumi ghwake? ");
INSERT INTO nww_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mundu ywoheli ywakanmonela honi nenga na mahundo ghangu mukibheleko kya utyahe na kya uhokelo. Mwana ghwa Mundu katammonela honi pakalonda kubhuya muukulu ghwa Tate ghwake papamu na Andumitumi ghwa kuluhingu ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu kakighendelela kubhaghombela, “Kulyaghila nungubhaghombela, amoo bhandu bhaayimite apa bhatahwegha ng'obhe mbaka paalonda kughubhona Ghubhutwa ghwa Chapanga paghuhika kwa makakala.” ");
INSERT INTO nww_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Mbole ya nhano na yimo, Yesu kakighenda papamu na Petili na Yakobu na Yohana mbaka kukitumbi kitandamaho kwa nga bhandu, kakighalambuka kibhungi mu ulongolo ghwabhe. ");
INSERT INTO nww_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Mapinda ghake ghaking'anyima ng'anyi, kahone mundu ywoheli ywa kahotola kung'anyihya handa bhula, pannima apa, ");
INSERT INTO nww_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","bhakibwitukila Eliya na Musa, bhakibha pa ayobhela na Yesu ");
INSERT INTO nww_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petili kakinng'ombela Yesu. “Nhunda, inoghela twenga tutame apa, tuchenge higubi hindatu, kimo kya ghwenga na kimo kingi kya Musa na kingi kangi kya Eliya.” ");
INSERT INTO nww_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petili na ayake bhakimanya ng'obhe kya kughomba kiyaha bhakiyoghopa muno. ");
INSERT INTO nww_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ndo likibwitukila lihundi likibhagubika na lilobhe likiyihwanika kuhuma mu lila lihundi palighomba, “Ayu ndo Mwana ghwangu yununpala munnyihwanile ywombe.” ");
INSERT INTO nww_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kamu paalyungite mehu kunu na kunu bhakimmona ng'obhe mundu ywoheli papamu naywo; ngati nga Yesu ghweka chake. ");
INSERT INTO nww_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Paabheghite mukuhelela kuhuma kukitumbi, Yesu kakiakwilikiha, “Nkotoo kunng'ombela mundu ywohele mihalu muyibhonite mbaka Mwana ghwa Mundu pakalonda kuhyuka.” ");
INSERT INTO nww_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bhakilikamula lilaghilo alyo na bhakighombana, “Akwo kuhyuka mana yake ndo niki?” ");
INSERT INTO nww_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bhakinkonya, “Bhuli ahunda bha malaghilo angulongela, Eliya kahiki huti?” ");
INSERT INTO nww_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu kakiayanga “Tela, Eliya katalongola huti kutengeleha mihalu hyoha. Bhuli hino yityekwa kukita Mwana ghwa Mundu inogha kambamandike muno na kuyuyuhwa? ");
INSERT INTO nww_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Peni nungunng'ombela, Eliya kahika kala nabho antendela bhaghapalite handa muyityekitwe ya kya ywombe.” ");
INSERT INTO nww_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pabhaahikiliti bhala ahundwa bhangi, bhakiabhona bhatindilwa na lumati lukulu lwa bhandu. Na amoo ahunda bha malaghilo bhakighombana na bhombe. ");
INSERT INTO nww_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kamu bhandu bhala paammonite Yesu bhakikangacha munu, bhakintughila annamuhe ");
INSERT INTO nww_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu kakiakonya ahundwa bhake, “Mungughombana nabho niki?” ");
INSERT INTO nww_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mundu yumo ywa mulumati kakinnyanga, “Nhunda nunnyegha kwa ghwenga mwana ghwangu kana lindilo lyakantendite kabhe ywa nga kulongela. ");
INSERT INTO nww_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Pipipi aywo lindilo pakankwehagha mwana ghwangu, kannghwihagha pahi na kuntenda kahumwe na lihuluhulu munnomo na kuhyagha meno, mbole mmili ghwake ghungukakama. Nikibhayupa ahundwa bhako bhammuhe aywo lindilu peni bhakilepelwa.” ");
INSERT INTO nww_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu kakiaghombela, “Mwenga kibheleko kya nga uhyubhalilo nda tama na mwenga mbaka pakiki? Ndabhalimbilila mbaka pakiki? Munnyeghe aywo nhongolo kwa nenga.” ");
INSERT INTO nww_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bhombe bhakinnghegha yula nhongolo Yesu. Kamu lila lindilu pakammonite Yesu kakinkweha kihilika naywo nhongolo kakighwegha pahi kakibingilika na kuhumiha lihuluhulu pa ngulu. ");
INSERT INTO nww_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu kakinkonya tate ghwa yula nhongolo “Nnando aghu ghuntandila pakiki?” Naywo kakinnyanga, “Kutandila pa ukakombo ghwake. ");
INSERT INTO nww_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Pipipi lindilu aywo likinnghwiha mumwoto na mumachi ngati kankanjaghane yomo, hinu handa ghwa hotola chonde ghutubhonele luhungu ghututange.” ");
INSERT INTO nww_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu kakinng'ombela, “Ena handa ghwa hyubhalila, mihalo hyoha yahotoleka kwa mundu yunakuhyubhalila.” ");
INSERT INTO nww_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kamu, tate ghwa yula nhongolo kakinlilila Yesu, “Ninguhyubhalila, peni uhyubhalilo ghwangu ukwila ng'obhe, ghundange.” ");
INSERT INTO nww_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu pakabhonite lumati lwa bhandu lukinkwemukila papamu kanongola, kakinkwlikiha yula lindilu, kakinng'ombela, “Ghwenga lindilu ghwanga kughomba na kuyihwa, nungughukwilikiha, ghummuke nhongolo ayu na ukotoo kunnyingila kangi.” ");
INSERT INTO nww_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yula lindilu kakikyota kyobho, kakinnghwiha, kakinloghoheya kwa makakala na kakimmuka. Yula nhongolo kakibhegha handa ntumba bhandu bhakilongela “Kahwegha!” ");
INSERT INTO nww_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Peni Yesu kakinkamula kibhoko yula kakombo, kakinnyinula naywo kakiyima. ");
INSERT INTO nww_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mbole, Yesu kakiyingila munyumba kati, ahundwa bhake bhakinkonyekeha mwa bhabheghite pa ghweka chabhe, “Bhuli twenga tukihotola ng'obhe kunmuha yula lindilu?” ");
INSERT INTO nww_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu kakiayanga, “Ndendo ya kya naha kahone kubhuka maha kwa kunnyupa Chapanga na kulikunga.” ");
INSERT INTO nww_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu na ahundwa bhake bhakibhuka akwo bhakipitila ku Galilaya. Yesu kakilema mundu ywohele kamanye kwa kabheghite. ");
INSERT INTO nww_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Kiyaha kakibha mu kuahunda ahundwa bhake. Kakiaghombela, “Mwana ghwa Mundu katakilukwa na kukamuhwa kwa bhandu nabho bhatankoma mbole ya lisiku lya ndatu katahyuka.” ");
INSERT INTO nww_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Peni, ahundwa bhake bhakimanya ng'obhe kila kyakaahundite, nabho bhakihyoghopa kunkonya. ");
INSERT INTO nww_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Hinu bhakihika ku Kapelinaumu mbole ya kuyingila mu kitutubhi Yesu kakiakonya ahundwa bhake, “Mukighombana kingiki munjila?” ");
INSERT INTO nww_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Peni bhene bhakinnyamala, kiyaha panjila pala bhakighombana ya kya ghani ndo nkulu mubhombe. ");
INSERT INTO nww_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu kakitama pahi na kakibhakema bhala ahundwa mbinda mabhoko yimo na abhili na kakiaghombela, “Handa mundu ywoheli ywakapala kubhegha kilongohi inogha kabheghe ghwa kundahe dokwa na kabhe ndumitumi ghwa bhoha.” ");
INSERT INTO nww_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Mbole kakintola mwana nndokwa kakinnyimiha pakati yabhe, kakinpakata na kakiaghombela, ");
INSERT INTO nww_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mundu hyowele ywakankemela yumoo, ywa abha bhana adokwa kwa lihina lyangu, kangungemela nenga. Naywo ywaka ngemela nenga kangunkema yula ywakanaghilite.” ");
INSERT INTO nww_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohana kaking'ombela “Nhunda, tunmona mundu kangubhua mandilo kwa lihina lyako, twenga tukinkanikiha kiyaha ywombe kabha mukimati kyetu ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu kakighomba, “Mangankanila, kahone ywohele ywakatenda mihabho kwa lihina lyangu mbole kahotole kukambuka lya uhakata kwa nenga. ");
INSERT INTO nww_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kiyaha ywakabhegha tela na twenga kabha mu mbande yatu. ");
INSERT INTO nww_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kulyaghila nunguaghombela, ywohele ywakanpegha mwenga nteko ghwa machi gha kunywegha kiyaha mwenga ndo bhandu bha Kilisto kulyaghila kahone kuhobha lilumbo lyake.” ");
INSERT INTO nww_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Mundu ywohele ywakannyegheleha yumoo ywa adokwa abha bhatenda ulemwa, yingunnoghela mundu aywo kabhopelwe liganga likulu lya kuhyagila muntandala ghwake na kuchumbukihwa mulihibha. ");
INSERT INTO nww_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kibhoko kyakyo pakighunyegheleha ghutende ulemwa ghukilumuhe. Mbaha ghuyingile mu ubhumi kya nga kibhoko kimo chepa kuyingila na mabhoko mabhili na kuchumbukihwa mumwoto ghwa masiku ghoha ghwa nga kuhimika. ");
INSERT INTO nww_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Amwo, mahinje ghake anguhwegha ng'obhe na mwoto ghwake ghwa nga kuhimika. ");
INSERT INTO nww_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na kighulu kyako pakighunnyegheleha kutenda ulemwa, ghukilumule, mbaha ghuyingile muulami kya nga kighulu kimo, chepa kuyingihwa na maghulu ghako ghoha mabhili na ghutaghwe mumwoto ghwa masiku ghoha ghwa nga kuhimika. ");
INSERT INTO nww_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Amwo, mahinye ghake kahone kuhwegha na mwoto ghwake ghwa nga kuhimika masiku ghoha. ");
INSERT INTO nww_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na liho lyako palighunyegheleha ghutende ulemwa, ghulitupule, mbaha ghuyingile mu Ghubhutwa ghwa Chapanga na liho limo ndu chepa kubhegha na meho ghoha mabhili na ghutaghwe mu mwoto ghwa masiku ghoha ghwa nga kuhimika. ");
INSERT INTO nww_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Amwo, ‘Mahinye ghake kahone kuhwegha na mwoto ghwake ghwa nga kuhimika.’ ” ");
INSERT INTO nww_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Mana mundu ywohele kaalungwa mwinyo kwa mwoto.” ");
INSERT INTO nww_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Mwinyo ntema ghwa maha peni handa payiluluka, ghwalungihwa na niki?” “Mmeghe na mwinyo mu mwenga, na ntame kwa uhihimilo nkati yenu.” ");
INSERT INTO nww_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu kakiyomboka lukemba lwa Yoludani na kakighenda ku nnma ghwa Yudea. Lumati lwa bhandu lukintughila, naywo kakibhahunda handa kitohe kyake. ");
INSERT INTO nww_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Hino Akaafalisayo bhakinng'endela kunng'eha na bhakinkonya, “Bhuli, malaghilo ghanguyegheka mundu nnume kunleka nndala ghwake?” ");
INSERT INTO nww_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu kakiayanga, “Musa kakiakwilikiha niki?” ");
INSERT INTO nww_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bhombe bhakinnyanga, “Musa kakitegheka kukita mundu katantyekela lihamba lya kunleka nndala ghwake na kunleka.” ");
INSERT INTO nww_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu kakiaghombela, “Musa kakityeka laghilo alyo lya kya unonopo ghwa myoyo yenu ");
INSERT INTO nww_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Peni kutandila ubhumbilo ghwa nnima, ‘Chapanga kakiabhumba mundu nnume na mundu nndala.’ ");
INSERT INTO nww_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Ndo nnume katanleka tate ghwake na ma ghwake naywo katalungana na nndala ghwake. ");
INSERT INTO nww_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Abha abhili bhatabhegha mmmili ghumo.’ Hinu abho abhili ng'obhe ngati mmili ghumo. ");
INSERT INTO nww_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Hinu, kyakakilungite Chapanga, anamundu kakotoo kupwilinganiha.” ");
INSERT INTO nww_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pakayingilite munyumba kati, ahundwa bhake bhakinkonya ya kya nhalo ghula. ");
INSERT INTO nww_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Mwene kakiaghombela, “Ywakanleka nndala ghwake na kutola yungi, kangutenda utyahe. ");
INSERT INTO nww_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na nndala ywakanleka nnume ghwake na kakatolelwa na nnume yungi, kangutenda utyahe.” ");
INSERT INTO nww_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bhandu bhakinnyeghela Yesu bhana adokwa ngati kabhayabhike mabhoko ghake unani mwabhe, ahundwa bhake bhakialakalila. ");
INSERT INTO nww_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu pakabhonite naha kakikalala na kakiaghombela ahundwa bhake, “Mubhategheke bhana ahike kwa nenga, nkotoke kuakanikiha, kiyaha Ghubhutwa ghwa Chapanga ndo ghwa bhandu bha abheghite handa abha.” ");
INSERT INTO nww_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kulyaghila nunguaghombela, mundu ywoheli ywa nga kukingama Ghubhutwa ghwa Chapanga handa bhana adokwa kahone kuyingila amwo. ");
INSERT INTO nww_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ndo kakiatola bhala bhana mu mabhoko ghake kakiapakata, kakiayabhika mabhoko ngati abhanonele. ");
INSERT INTO nww_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu pakabheghite mu kubhuka, mundu yumo kakintughila, kakitundamila mayughwa mu ulongolo ghwake na kakinkonya, “Nhunda ghwa maha, ndende niki nighuhale ubhumi ghwa masiku ghoha ghwa nga uhiko?” ");
INSERT INTO nww_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu kakinnyanga, “Kiyaha niki ghungungema ghwa maha? Kahone mundu ghwa maha, ngati nga Chapanga ghweka chake. ");
INSERT INTO nww_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ghungughamanya malaghilo, ‘Kukoma kata, utyahe kata, kuyibha kata, unyimiho ghwa uhwangi kata, ukubhuhi kata, ghubhayikitile tate ghwako na ma ghwako.’” ");
INSERT INTO nww_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mwene kakinnyanga, “Nhunda, malaghilo agha hyoha nikighakamula tangu pa meghite nhongolo.” ");
INSERT INTO nww_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu kakinlolekeha na kakinpala, ndo kakinng'ombela “Ghupelelwa na kilibhi kimo ghughende ghukahemengane hyoha hiubheghite nahyo na ghubhapeghe ngalabha ahyo bhandu kapukwa, ghwabhegha na utopelo nnyoloho ku luhingu, mbole ghundughile.” ");
INSERT INTO nww_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yula mundu pakayihwite agho, kakukulika muno na kakibhuka kunu pakahyononeka, kiyaha kakibha na utopelo nnyoloho. ");
INSERT INTO nww_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu kakilolekeha mbande hyoha, kakiaghombela ahundwa bhake, “Kya bhuli yabhegha unonopo kwa bhana utopelo kuyingila mu Ghubhutwa ghwa Chapanga!” ");
INSERT INTO nww_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ahundwa bhake bhakikangacha muno kwa malagho agho, Yesu kakiaghombela kangi, “Bhana bhangu, kya bhuli yabhegha unonopo mundu yuna kuhyubhalila utopelo kuyingila mu Ghubhutwa ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yabhegha unonopo kwa yunautopelo kuyingiha mu Ghubhutwa ghwa Chapanga mbaha ya nnyama ngamiha kuhotola kuyingila mu lilanga lya sasia.” ");
INSERT INTO nww_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ahundwa bhake bhakikangacha muno bhakikonyana, “Ndo ghani aywo ywakahotola kulopoka?” ");
INSERT INTO nww_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu kakiahulutulila meho na kakiayanga, “Kwa anamundu ali kahone, peni kwa Chapanga ng'obhe; hyoha kwa Chapanga yahotolwa.” ");
INSERT INTO nww_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petili kunng'ombela, “Twenga tuhileka hyoha na kughutughila ghwenga!” ");
INSERT INTO nww_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu kakiaghombela, “Kulyaghila nunguaghombela mundu ywohele ywakalekite lubhagha lwake ebu nnongo ghwake ebu nhacha ebu maghwake ebu tate ghwake ebu bhana bhake ebu mighunda kwa kya nenga na kwa kya Nhalo ghwa Maha, ");
INSERT INTO nww_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mwene katakamuhwa mala mbinda mabhoko kumi mu masiku agha, kitutubhi na nnongo ghwake na nhacha ghwake na Ma ghwake na tate ghwake na bhana bhake na mighunda papamo na himbamanda, mbole ndo ubhumi ghwa nga kupela munnima ghwalonda kuhika. ");
INSERT INTO nww_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Peni bhandu ayoloho bhabheghite kuulongolo bhaabhegha ghwa kundahe na bha kundahe bhaabhegha bha ulongolo.” ");
INSERT INTO nww_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu na ahundwa bhake bhakibhegha munjila kughenda ku Yelusalemu na Yesu kakialongolela. Ahundwa bhakibha na bhwaghalihi, na bhandu bhaatughilite bhakimememwa bhakiyoghopa. Yesu kakiatola kangi bhala ahundwa mbinda mabhoko yimo na abhili kya ghweka na lula lumati na kakiaghombela ghala ghaalonda kunhikila. ");
INSERT INTO nww_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kakighomba, “Nnyihwe tunguhubhuka kughenda ku Yelusalemu, na akwo Mwana ghwa Mundu katakilukwa na katakamuhwa kwa hilongohi bha andundame na ahunda bha malaghilo. Bhene bhatantosa kiho, na kunkamuha kwa bhandu abheghite ng'obhe Akaayahudi. ");
INSERT INTO nww_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bhene bhatanhyula, bhatanhunila mata, bhatantuta minjupuchupu na kunkoma. Peni lisiku lya ndatu kaahyuka.” ");
INSERT INTO nww_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ndo, Yakobu na Yohana, bhana bha Zebedayo, bhaking'endela Yesu na bhakinng'ombela, “Nhunda, tungupala ghututendele lyoheli lila litupala kukuyupa.” ");
INSERT INTO nww_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Naywo Kakibhaghombela, “Hinu, mungupala nibhatendele nhalo ghani?” ");
INSERT INTO nww_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bhakinng'ombela, “paghutama mu kitebho kyako kya ukulu kya Ghubhutwa ghwako tungupala ghututamihe yumu mbande yako ya nnilo na yungi mu mbande ya nngiya.” ");
INSERT INTO nww_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu kakiaghombela, “Mungumanya ng'obhe kimukiyupa. Kulyaghila mahotola kulimbilia kimbamanda kya kya nenga na mabhegha kala kwa kiho kya nonda kuhwegha nenga.” ");
INSERT INTO nww_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bhakinnyanga “Twahotola” Ndo Yesu kakiaghombela, “Nteko ghwa nlonda kuywegha nenga manywela na ubatiso ghwa kya nenga mabatisighwa, ");
INSERT INTO nww_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Peni kutama mbande yangu ya nnilo ebu ya ngiya, aghu ndo nnando ghwa nenga ng'obhe kuapegha ngati aghu ndo ya bhala bhaabhikilitwe kala na Chapanga.” ");
INSERT INTO nww_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Bhala ahundwa bhangi mbinda mabhoko yimo paayihwite nhalo agho bhakiyanda kubhayaghabhalila Yakobu na Yohana. ");
INSERT INTO nww_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu kakiakema ahundwa bhake papamu na kakiaghombela, “Mungumanya kukita atabhala bha bhandu bha milima yingi bhangubhatabhala bhandu kwa makakala, nabho akulu bhanguangwiliha bhandu bhabhe. ");
INSERT INTO nww_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Peni kwa mwenga kata. Mbole yake ywoheli ywakapala kubhegha nkulu mumabhene ndo yinguntama kabheghe nndumitumi ghwenu. ");
INSERT INTO nww_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na mundu ywoheli ywakapala kubhegha kilongohi, yinguntama kakaatumikile bhangi. ");
INSERT INTO nww_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kiyaha hata Mwana ghwa Mundu kakihika kutendelwa lihengo ng'obhe, ngati kakihika kutenda lihengo na kuubhuha ubhumi ghwake ghubheghe ukombohi kwa bhandu ayoloho.” ");
INSERT INTO nww_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ndo bhakihika Yeliko, pala Yesu pakabhukite mukitami na ahundwa bhake papamu na lumati lukulu lwa bhandu, ywangakubhona lihina lyake Balitimayu, mwana ghwa Timayu, kakitama mumbhwegha ya njila pakiyupa utangwo. ");
INSERT INTO nww_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Balitimayu pakayihwite kukita ndo Yesu ghwa ku Nasaleti ywakabheghite mukupita, kakiyanda kukweha lilobhe pakaghomba, “Yesu, Mwana ghwa Daudi, ghumonele luhungu!” ");
INSERT INTO nww_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bhandu ayoloho bhakinlakalila na kung'ombela kanyamale, peni mwene kakighendelela kukweha lilobhe pakighomba, “Mwana ghwa Daudi ghunmonele luhungu!” ");
INSERT INTO nww_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu kakiyima na kulongela, “Munkeme” Ndo bhakinkema yula ywanga kubhona bhaking'ombela, “Ghulikunge mwoyo, ghuyime, kangughukema.” ");
INSERT INTO nww_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kakilitagha lipinda lyake, na kakihumba na kung'endela Yesu. ");
INSERT INTO nww_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu kakinkonya, “Ghungupala nukutendele niki?” Yula ywanga kubhona kakinnyanga, “Nhunda ghwangu mbala kubhona.” ");
INSERT INTO nww_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu kaking'ombela, “Ghughende, hyubhalilo yako yikulamiha.” Kamu yula ywanga kubhona kakilola, naywo kakintughila Yesu na kakighenda naywo papamu. ");
INSERT INTO nww_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Pabhaheghelelite ku Yelusalem bhakihika ku hitami hya Betifage na ku Betania ugheghela na kitumbi kya Miseituni, Yesu kakibhalaghila abhili mu ahundwa bhake, ");
INSERT INTO nww_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","kakiaghombela, “Nng'ende mbaka kukitami kya kuulongolo ghwenu na kamu pannyingila pakitami akyo matammona mwanakaputa kabhopelelwa lughoyi, kakali na kutendelwa lihengo. Mummopole mung'eghele apa. ");
INSERT INTO nww_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Handa mundu ywohele pakabhakonya, bhuli mungunmopola? Munnyange, ‘Bambo kangunpala na hamba katammuyila.’ ” ");
INSERT INTO nww_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bhakighenda na bhakimmona mwanakaputa kabhopolelwa mumbwegha ya njila, ugheghela ghwa nlyango ghwa kitutubhi. ");
INSERT INTO nww_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pabhabheghite mukummopola bhandu bhaayimiti paugheghela bhakiakonya, “Yibha bhuli mungummopola mwanakaputa?” ");
INSERT INTO nww_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bhakiayanga handa bhula pakabhalaghiliti Yesu, nabho bhandu bhala bhakibhategheka. ");
INSERT INTO nww_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bhakinnyeghela Yesu yula mwanakaputa, bhakiyalila nghubho hyabhe pang'ongo ghwake naywo Yesu kakihubhuka. ");
INSERT INTO nww_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bhandu bha ayoloho bhakiyalila ngubho hyabhe munjila na amoo bhangi bhakiyalila hiputila hya mikongo bhayadumulite mumighunda ya kya kunhokamila. ");
INSERT INTO nww_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mbole bhala bhaalongolite kuulongolo na bhala bhaabheghite kukihongo unyuma bhakiyimba malobhe paaghombite, “Lilumbo! Kanonelwe mwene aywo ywakahika kwa lihina lya Bambo! ");
INSERT INTO nww_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ghunoneleghwa Ghubhutwa ghuupala kuhika ghwa tate ghwetu Daudi!” “Lilumbo kwa mwene ywakabheghite kunani kunani muno!” ");
INSERT INTO nww_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu kakighenda ku Yelusalemu na kakiyingila Kitutubhi kya Chapanga. Kakilolekeha hilibhi hyoha hiibheghite, peni kiyaha yikiyingila makimuhi, kakighenda ku Betania papamu na bhala mbinda mabhoko yimo na abhili. ");
INSERT INTO nww_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kilabho yake pabhabheghite mukubhuka ku Betania Yesu yikinbhina njala. ");
INSERT INTO nww_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Pakaghubhoniti nkongo ghwa ntini kya kutali ghubheghite na mahamba manyelemba, kakighughendela kakaghulole kukita ghukipambika, pakaghuhikiliti kakighabhona ngamahamba ghweka kiyaha yikibha kihuku kya nga kupambika. ");
INSERT INTO nww_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesu kakighughombela ghula nkongo ghwa ntini, “Kuyandila lelo mbaka masiku ghoha ghapala kuhika mundu ywohele katalyegha ng'obhe mapambiko kuhuma kwa ghwenga” Ahundwa bhake bhakiyihwa paakighomba agha. ");
INSERT INTO nww_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pakahikite ku Yelusalemu Yesu kakiyingila mu Kitutubhi kya Chapanga kakiyanda kubhabhinga bhinga bhala bhaabheghite mukuhemela na kuhemengana hilibhi munyumba kati ya Kitutubhi kya Chapanga. Kakihipalangula hindambi hya bhala bhaabheghite mukuhemengana ngalabha na hitebho hya bhanakuhemela ngunda. ");
INSERT INTO nww_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Hangi kakintegheka ng'obhe mundu ywohele kutola kilibhi kyoheli kupitila lubhigho lwa Kitutubhi kya Chapanga. ");
INSERT INTO nww_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Mbole kakibhahunda, “Yityekwa, ‘Kitutubhi kyangu kyaabhegha Kitutubhi kya kutundamila bhandu bha milima hyoha, peni mwenga mukitenda yibhe mbaku ya kuahiha apoka!’” ");
INSERT INTO nww_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Akulu bha mandundame na ahunda bha malaghilo pakayihwite mihalo ayi bhakiyanda kunpalahila luhila lwa kunkoma, peni bhakinnyoghopa, kiyaha bhandu bhohabhakikangacha kwa mahundo ghake. ");
INSERT INTO nww_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Payihikite makimuhi, Yesu na ahundwa bhake bhakibhuka mu kitami. ");
INSERT INTO nww_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Malabhila ghake, paabheghite mukutyanga mu njila, bhakighubhona ghula ntini ghunyaluka kala kuhumila kunani mbaka pa kitepo. ");
INSERT INTO nww_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petili kakighuhwachila na kaking'ombela Yesu, “Nhunda, ghulole ghula ntini ghu ghukotolite ghunyaluka!” ");
INSERT INTO nww_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu kakiayanga, “Munhyubhalile Chapanga.” ");
INSERT INTO nww_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kulyaghila ningubhaghombela mundu ywohele ywakalonda kukighombela kitumbi aki, ghutupuke ghukataghwe kulihibha, na kakotoo kubhona bhwaghalihi mumwoyo ghwake ngati kahyubhalile kukita ghatatendekwa, katatendeghwa nnando aghwo. ");
INSERT INTO nww_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ngati hino ningubhaghombela kyoheli kimukiyupa na kutundamila, nhyubhalile kukita maakingama nakyo kyabhegha kyenu. ");
INSERT INTO nww_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pammegha mukutundamila, munnekekehe mundu ywohele ywakabhatenditi uhokelo ghwoheli, ngati Tate ghwenu ywakabheghite kuluhingu kabhalekekehe ulemwa ghwenu. ");
INSERT INTO nww_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Peni pamubhalekekeha ng'obhe bhangi, hata Tate ghwenu ywakabheghite kuluhingu katabhalekekeha ng'obhe ulemwa ghwenu. ");
INSERT INTO nww_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu na ahundwa bhake bhakihika kangi ku Yelusalemu, pakabheghite mukutyanga ku Kitutubhi kya Chapanga, Akulu bha mandundame na ahunda bha malaghilo na aghoghi bhakinng'endela, ");
INSERT INTO nww_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Bhakinkonya, “Ghukitenda mihalo ayi kwa ngwiliho ya ghani? Na ywakakukamuhite makakala agha ndi ghani?” ");
INSERT INTO nww_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu kakiayanga, “Ndabhakonya ngonyo yimo, na nenga nda bhakambuha kukita ndi kwa makakala gha ghani ningutenda mihalo ayi. ");
INSERT INTO nww_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Mung'ombele, makakala gha Yohana yunakubatisa ghukihuma kuluhingo kwa Chapanga, ebu kwa anabhandu?” ");
INSERT INTO nww_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bhakighombana, pabhakighomba, “Handa patulongela, ghukihuma kuluhingu kwa Chapanga, katatukonya, mona mukighuhyubhalila ng'obhe? ");
INSERT INTO nww_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Peni patughomba, ‘ghukihuma kwa anabhandu.’” Bhakihyoghopa bhandu, mana bhandu bhoha bhakihyubhalila kukita Yohana kakibha ndo mbuye ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ngati hino, bhakinnyanga Yesu, bhakighomba, kukita “Tungumanya ng'obhe.” Yesu kakibhayanga “Hata nenga ndabhaghombela ng'obhe kukita nungughatenda agha kwa gwiliho ya ghani.” ");
INSERT INTO nww_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu kakiyanda kughomba nabho kwa mandambulo, pakibhaghombela, “Mundu yumo kakikanda nng'unda ghwa mizabibu, kakichenga lubhigho kughutindila ghula ng'unda, na kakitendekeha pa kukama difwai, hilahila kakichenga kilingo na kakiapegha bhandu bhanpeghe sumu, ywombe kakibhuka kughenda kunnima ghungi. ");
INSERT INTO nww_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mumasiku gha mabeno kakinlaghila nndumitumi ghwake kwa bhala akanda kanda bhake kakatole lusumulo lwake. ");
INSERT INTO nww_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bhala akandakanda bhakinkamula yula nndumitumi, bhakintuta na bhakinbhuyiha mabhoko gha yaghi kya nga kilibhi. ");
INSERT INTO nww_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kangi yula nkola nngunda kakinlaghila nndumitumi yungi kwa bhombe, bhala akandakanda bhakintuta mumutwe na kuntendela mihalo ya honi. ");
INSERT INTO nww_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kangi yula nkola nng'unda kakinlaghila nndumitumi yungi, aywo bhakinkoma. Kakialaghila andumitumi bhangi ayoloho, bhala akandakanda bhakiatuta bhala andumitumi na amoo bhangi bhakiakoma. ");
INSERT INTO nww_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nkolang'unda kakihighala na mundu yumo ndundundu ghwa kunlaghiha, aywo ndo mwana ywakanpaliti. Muuhiko kakinlaghila pakaghomba, ‘Bhatanhokamila mwana ghwangu.’ ");
INSERT INTO nww_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Peni bhala akandakanda bhakighombana, paakighomba, ‘Aywo ndo yunakuhala, nhiki tunkome, na lipala lyake lya bhegha lyetu.’ ");
INSERT INTO nww_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ndo bhakinkamula, bhakinkoma na kuntagha panje ya ghula ng'unda ghwa mizabibu.” ");
INSERT INTO nww_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu kakiakonya “Munguhwacha yula nkolang'unda katatenda niki? Katahika na kubhakoma bhala akandakanda, mbole katabhapegha akandakanda bhangi ghula ng'unda ghwa mizabibu. ");
INSERT INTO nww_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mukisoma ng'obhe malembo agha, ‘Liganga bhalilemite bhana utendehi ghwa kuchenga hinu libhegha liganga likulu lya pambwegha; ");
INSERT INTO nww_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Bambo kaghutenda nhalu aghu nayo ndo ngangahyo mumehu ghetu!’ ” ");
INSERT INTO nww_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Akulu bha mandundame, ahunda bha malaghilo na aghoyi pabhamanyite kukita kakighomba ndambulo yila kwa kya bhombe bhakipala kunkamula, peni bhakiluyoghopa lula lumati lwa bhandu. Bhakinneka na bhakibhuka. ");
INSERT INTO nww_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mbole, bhakialaghila Akaafalisayo na kimati kya Helode ngati bhanhikile Yesu bhantyeghe kwa mihalo yake. ");
INSERT INTO nww_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bhaking'endela Yesu bhakinng'ombela, “Nhunda, tungumanya kukita ghwenga ghu mundu ghwa kuyubhalilwa ghunakulongela hoto. Ghunguayoghopa ng'obhe ukulu ghwa bhene, peni ghwenga ghunguhunda hoto ya Chapanga telatela. Hinu yinguteghekwa kunpegha mutwa nkulu ghwa Akaaloma kodi ebu ng'obhe? Hinu tunpeghe ebu tukotoo kunpegha?” ");
INSERT INTO nww_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Peni Yesu kakimanya ufyangu ghwa bhombe na kakiakonya, “Bhuli mukupala kuntyegha? Munyeghele ayo ngalabha niyilole.” ");
INSERT INTO nww_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bhakinnyeghela ngalabha na mwene kakiakonya, “Kibhungi aki na lihina lityekitwe ali lya ghani?” Bhene akinnyanga “Ndi lya Mutwa nkulu ghwa Akaaloma.” ");
INSERT INTO nww_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ndo Yesu kakiaghombela, “Munmpeghe Mutwa nkulu ghwa Akaaloma hya kya mwene na Chapanga hya kya Chapanga.” Na bhene bhakibhughanikwa muno naywo. ");
INSERT INTO nww_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mbole, Akaasadukayu, bhala bhanakughomba kahone uhyuko bhakinhikila Yesu na bhakinkonya, ");
INSERT INTO nww_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Nhunda, Musa kakitutyekela kukita handa mundu pakahwegha na kunleka nndala kya nga mwana, ndo nlongo ghwake katantolela yula nndala nnekwa ngati kakanpapile nnongo ghwake bhana. ");
INSERT INTO nww_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ndo bhakibhegha alongo nhano na abhili. Yula ghwa ulongohi kakitolela nndala na kakihwegha kya nga mwana ywohele. ");
INSERT INTO nww_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ghwa ubhili kakinhala yula nnekwa peni naywo kakihwegha kya nga kunneka mwana ywoheli, yikibhegha ubhwabhu abhu kwa yula ghwa ndatu. ");
INSERT INTO nww_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ndo bhoha nhano na abhili muulongo ghula bhakighwegha kya nga kunneka mwana na muuhiko ghwa hyoha na yula nndala kakihwegha. ");
INSERT INTO nww_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ngati hino, palisiku lya bhandu kuhyuka, nndala yula katabhegha ghwa ghani kiyaha kakitolelwa na alongo bhoha nhano na abhili?” ");
INSERT INTO nww_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu kakiayanga, “Mwenga munguhokela kiyaha mungumanya ng'obhe Matyeko Mang'anyimo ebu ngwiliho ya Chapanga. ");
INSERT INTO nww_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bhaahweghite paalonda kuhyuka, kahone kutolela ebu kutolelwa kiyaha bhatabhegha handa andumitumi bha kuluhingu bha Chapanga. ");
INSERT INTO nww_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na kwa mihalo ya kya uhyuko ghwa bha aghweghite, nde nsoma ng'obhe mu kitabho kya Musa akwo Chapanga pakalongilite na Musa kuhuma mukiputila kiyakiteghe mwoto pakaghomba, ‘Nenga ndo Chapanga ghwa Ablahamu, na Chapanga ghwa Isaka na Chapanga ghwa Yakobu.’ ");
INSERT INTO nww_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Hinu, mwene ndo Chapanga ghwa aghweghite ng'obhe ngati ndo Chapanga ghwa bhanakukeka. Mwenga nhokela muno!” ");
INSERT INTO nww_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nhunda yumu ghwa malaghilo kakihika na kakiyihwa paaghombaniti. Kakibhona kukita Yesu kakiayanga tela bhala Akaasadukayo, naywo kakinkonya, “Mungwilikiho hyoha yibheghite ngulu ndo yoki?” ");
INSERT INTO nww_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu kakinnyanga. “Nnyihwanile mwenga bhandu bha Isilaeli, ngwiliho ngulu ndo ayi, Bambo Chapanga ghwetu, ndo Bambo yumo. ");
INSERT INTO nww_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ghunpale Bambo Chapanga ghwako kwa mwoyo ghwako ghwoha na kwa nhuki ghwako ghwoha na kwa mahala ghako ghoha na kwa makakala ghako ghoha. ");
INSERT INTO nww_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na ya kabhili ndi ayi, ghunpale nng'eghela ghwako handa mughulipala ghumwene, kahone ngwilikiho yingi ngulu kupitingana kwa ahi.” ");
INSERT INTO nww_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yula nhunda ghwa malaghilo kaking'ombela Yesu, “Kulyaghila nhunda ghuyanga maha kukita Chapanga ndo yumu kahone yungi ngati nga ywombe. ");
INSERT INTO nww_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kunpala Chapanga kwa mwoyo ghwoha na kwa mahala ghoha na makakala ghoha na kunpala nng'eghela ghwako handa mughulipala ghumwene ndi tela kya na lumu kulandana ng'obhe na kuyambika nyambi ya kuyocholela na matulo.” ");
INSERT INTO nww_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Naywo Yesu pakabhonite kukita kakiyanga kwa mahala, kaking'ombela, “Ghwenga ghubhegha kutali ng'obhe na Ghubhutwa ghwa Chapanga.” Kuyandila pala kahone mundu ywakayighite kunkonya Yesu nkonyo kangi. ");
INSERT INTO nww_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu pakabheghite mukuhunda akwo ku Kitutubhi kya Chapanga kakikonya, “Yibha bhuli ahunda bha malaghilo angulongela kukita Kilisto ywakahaghulitwe na Chapanga ndo Mwana ghwa Daudi? ");
INSERT INTO nww_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mana Daudi mwene kakikambuka pakalonguhitwe na Nhuki ghwa Chapanga pakighomba. ‘Bambo kaking'ombela Bambo ghwangu, ghutame mu kibhoko kyangu kya nnilo, mbaka panonda kubhabhika amyanja bhako pahi ya ngwiliho yako.’ ");
INSERT INTO nww_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daudi mwene kangunkema Kilisto ywakahaghulitwe na Chapanga, ‘Bambo’ yabhegha bhuli hino ywombe kabhe mwana ghwake?” Lula lumati lwoha lwa nbhandu bhakinnyihwa kwa uyelelo ");
INSERT INTO nww_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu pakabheghiteghe mu kuahunda, kakilongela, “Mulindakile na ahunda bha malaghilo. Bhombe apalagha kutyanga paahwala mapinda matandamaho na kulamuhwa kwa kuhokamilwa mu hindandabhanji, ");
INSERT INTO nww_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","na kutama muhitebho hya kuulongolo mu Kitutbhi kya kukonganila Akaayahudi na muhitebho hya ulongolo mu chekwa. ");
INSERT INTO nww_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Anguapugha ahumbu alekwa kunu bhangulikupukiha kulandulila malandulo matandamaho lisiku lya uhiko kyabhabhona kimbamanda kikulu!” ");
INSERT INTO nww_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Mbole Yesu kakitama ugheghela na kipalamande kya abhikiteghe matulo, kakilulolekeha lumati lwa bhandu pa abheghite mukubhika ngalabha mulijamanda lya kitutubhi kya Chapanga. Na bhana utopelo ayoloho bhakiyingiha ngalabha nyoloho. ");
INSERT INTO nww_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Peni nndala nlekwa yumo kapukwa, kakihika na kakibhika ngalabha ibhili njoko hya lihabha. ");
INSERT INTO nww_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu kakiakema ahundwa bhake kakiaghombela, “Kulyaghila nunguaghombela nndala nlekwa ayu kapukwa kabhika ngalabha nyoloho mulijamanda lya nyambi kupitingana kwa bhangi bhoha bhabhikiti. ");
INSERT INTO nww_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kiyaha bhangi bhoha bhakibhika uyonjokeho ghwa mota hyabhe, peni ayu nhumbu nlekwa mu ukapukwa ghwake kakitola hyoha hyakabheghite nahyo hata kila kyakakipalite nde kya kulama.” ");
INSERT INTO nww_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu pakabheghite mu kuhuma ku Kitutubhi kya Chapanga, yumoo ywa ahundwa bhake kakinng'ombela, “Nhunda, ghulole huti maganga agha mughabheghiti makulu na hitutubhi ahi muhinnyelembekite.” ");
INSERT INTO nww_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu kakinnyanga, “Ghuhibhona hitutubhi ahi muhibheghite ngulu? Kahone hata liganga limo lya kulonda kuhighala unani mwa liganga lingi, ghoha ghatahangulighwa.” ");
INSERT INTO nww_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu pakatamite ku Kitumbi kya Mizeituni paakilola Kitutubhi kya Chapanga Petili na Yakobu na Yohana na Andelea bhakinkonya mu lupwepo, ");
INSERT INTO nww_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Chonde, ghutughombele mihalu ayi yabhegha pakiki, na naho yake yabhegha bhuli payiheghelela kubwitukila?” ");
INSERT INTO nww_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu kakiaghombela, “Mulindakile, mundu ywoheli kakotoke kuakuluha. ");
INSERT INTO nww_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kiyaha ayoloho bhaahika kukambuka kwa lihina lyangu, paalongela, ‘Nenga ndo Kilisto’ nabho bhataahokeha bhandu ayoloho. ");
INSERT INTO nww_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pannyihwa kyobho ya mikoha paugheghela ebu mihalo ya mikoha kya kutali, nkotoo kubhegha na bhwagalili. Mihalu ayi mbaka yihumbuke peni uhiko ghwake ukali hela. ");
INSERT INTO nww_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mana bhandu bha nnima ghumo ghwatutana na bhandu bha nnima ghungi; na ghubhutwa ghwatutana na ghubhutwa ghungi. Kwabhegha na migwangwaliko mbande nhanganganiko lung'ahi lwa njala. Mihalu aywo yingulihwana na lihingila lya ulongohi.” ");
INSERT INTO nww_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Peni mwenga mulindakile, mana bhatabhakokela mu njengakaya, na kuatuta mu Hitutubhi ya kukonganila Akaayahudi; bhatabhayegha hilongohi na akaabhutwa kwa mihalo ya nenga ngati mubhaghombele Nhalo ghwa Maha. ");
INSERT INTO nww_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Peni mbaka Mihalo ya Maha yilandamihwe huti kwa bhandu bha milima hyoha kukali na kuhika ghula uhiko. ");
INSERT INTO nww_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nabho paabhakamula na kubhakokela mu njengakaya, nkotoo kubhegha na bhwaghalili ya kya kulongela; Uhiko pauhika, nnongele kyohele kya kya mukamuhitwe ngati mwenga ng'obhe munpala kulongela ngati Nhuki ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nnongo katankiluka nnongo ghwake ngati kakakomwe, na tate katankiluka mwana ghwake. Bhana bhataakiluka tate na ma ghwabhe na kuakoma. ");
INSERT INTO nww_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bhandu bhoha bhataakalalila mwenga kwa kya nenga. Peni yunakulimbilila kunhyubhalila mbaka kuuhiko katalopoka.” ");
INSERT INTO nww_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Pamulibhona ‘Kilibhi kinakunnyaghabhiha Chapanga’ kiyima pautamiho ghwake ng'obhe, yunakusoma kamanyeghe nhalo aghu, hino bhala bhaabheghite ku Yudea bhatughile ku hitumbi. ");
INSERT INTO nww_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ywakabheghite kulinyakaha ya kitutubhi kakotoho kuhuluka kuyingila munyumba kati mwaki kakatole kilibhi. ");
INSERT INTO nww_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Naywo ywakabheghite kunng'unda kakotoo kubhuya ukaya kutola kyoheli. ");
INSERT INTO nww_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Peni kibhabhone bhombe bhana ndumbo na bhanakuyongeha bhana masiku agho! ");
INSERT INTO nww_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nnyupe kwa Chapanga ngati mihalo ayi yikotoo kubwitukila pakipepo. ");
INSERT INTO nww_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mana mumasiku agho lutabhegha lung'ahe lukulu lwa nga kubhonekana, tangu ulongohi pala Chapanga pakabhumbite nnima mbaka lelo. Na kubhegha kangi ng'obhe mumasiku gha pala kuhika. ");
INSERT INTO nww_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Handa Bambo kangahupitahiti ng'obhe masiku agho, Kahone kulopoka mundu ywohele. Peni kwa kya bhandu ahaghulwa, bhakabhahaghulite, kaghahupia masiku agho.” ");
INSERT INTO nww_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Hinu mundu ywohele pakaaghombela, ‘Nnole, Kilisto ywakahaghulitwe na Chapanga kabhegha apa!’ Ebu, ‘Kabhegha kula’ mangahyubhalila. ");
INSERT INTO nww_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mana bha bwitukila akina kilisto bhanga kuhaghulwa na Chapanga na mambuye bha uhwangi. Nabho bhatatenda naho na mihabho ngati bhabhahokehe ahaghulwa bha Chapanga. ");
INSERT INTO nww_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Peni mwenga mulindakile, nenga niabhaghombela ghoha ghakali na kubwitukila.” ");
INSERT INTO nww_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Peni mumasiku agho, mbole ya lung'ahe alwo, luchubha lwayingihwa lubhindo, na lubhalamwehi kabhone kumulika, ");
INSERT INTO nww_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ndondwa hyaponeka kuhuma kunani na makakala gha kunani pamahundi ghatayukana. ");
INSERT INTO nww_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ndo bhandu bhatammona Mwana ghwa Mundu pakihika mumahundi kwa makakala mayoloho na ukulu. ");
INSERT INTO nww_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mbole katabhalaghiha andumitumi ghwake ghwa kuluhingu abhakwemukihe bhandu ahaghulwa bhake kuhuma mumbande hyoha ya nnima kuyandila kuuhiko ghwa n'nima mbaka kuuhiko ghwa luhingu.” ");
INSERT INTO nww_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Mughulole nkongo ghwa ntini na mulihunde ndambulo ayi; kamu pa mubhabhona mapanyo ghake paghatomola mahamba mmanye kukita pamabeno paheghela ");
INSERT INTO nww_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ubhwabhu abhu, pamuyibhona mihalu ayi payitendeka, mmanye kukita Kilisto ywakahaghulitwe na Chapanga kabha ugheghela mwa nlyango! ");
INSERT INTO nww_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kulyaghila nungubhaghombela, kibheleko aki kyapitingana ng'obhe mbaka mihalu ayi hyoha yibwituke. ");
INSERT INTO nww_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Luhingu na nnima hyapitingana, peni malagho ghangu kahone kupita kata.” ");
INSERT INTO nww_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Peni kwa mihalo ya lisiku lila na lisaa kahone ywa kumanya, hata andumitumi ghwa kuluhingu ghwa Chapanga, ebu Mwana, maha nga Tate ghweka chake ndo yunakumanya. ");
INSERT INTO nww_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mulindakile, mmeghe kala, kiyaha mmanya ng'obhe lisaa alyo lya hika pakiki. ");
INSERT INTO nww_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yabhegha handa mundu ywakabheghite mumwanja ywakabhalekiti andumitumi bhalulolekehe maha alwo lubhagha lwake kila mundu na lihengo lyake, naywo kakinkwilikiha lichonda ghwa ku nlyango ‘Ghukotoo kughonja.’ ");
INSERT INTO nww_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Hinu mbheghe kala mana, mmanya ng'obhe mabhuyo gha nkola lubhagha, kukita makimuhi, ebu pakilu pa pakati, ebu pangeha ya kubhika njogolo, ebu malabhila pakuchegha. ");
INSERT INTO nww_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Handa pakabhuya kwa kinunu kabhayitukite nng'onja. ");
INSERT INTO nww_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Na ali linibhaghombela mwenga, nungubhaghombela bhoha, mmbheghe kala!” ");
INSERT INTO nww_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yikibha masiku mabhili yikali na kuyingiha chekwa ya Pasaka na ya mangate ya nga kuyingihwa linjacha. Akaandundame akulu na ahunda bha malaghilo bhakipalaha njila ya kunkamula Yesu kwa njenjelo ngati bhankome. ");
INSERT INTO nww_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mana bhakighomba, “Tukotoo kunkamula lisiku lya chekwa ya Pasaka, kiyaha bhandu bhaatenda bhulwa.” ");
INSERT INTO nww_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu pakabheghite akwo ku Betania kulubhagha lwa Simoni ywakabheghite na maloha, pakabheghite mukindangabhala pakalyegha hilyo kakihika nndala yumo ywakabheghite na kyupa kya liganga lya alabasita kina mahuta ghanakunungila munu gha ngalabha ngulu, kakakimetula kila kyupa na kakinpopohela Yesu mumutwe ghwake ");
INSERT INTO nww_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bhandu amoo bhangi bhaabheghite pala bhakighombana bhene kwa mabhene, “Kiyaha niki mahuta aghangalabha ngulu ghangunyanyanganwa hela? ");
INSERT INTO nww_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mahuta agha ghangahemelitwe kwa ngalabha ngulu na ngalabha ahyo bhangabhapeghite kapukwa.” Bhakinlakalila munu yula nndala. ");
INSERT INTO nww_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Peni Yesu kakiaghombela, “Bhuli mungunng'aha? Munneke, kiyaha kanndendela nnando ghunakuhalala. ");
INSERT INTO nww_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Makapukwa mmegha nabho masiku ghoha na mahotola kubhatanga masiku ghoheli ghamughapalite. Peni nenga kahone kubhegha papamu masiku ghoha. ");
INSERT INTO nww_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nndala ayu kandendela kila kakahotolite, kalongolela kuntyelemeka mahuta mmili ghwangu kyakummika kala kya kungulila. ");
INSERT INTO nww_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kulyaghila nenga nungubhaghombela pohele pala pannima payilandamihwa Nhalo ghwa Maha, nnando aghu ghwakatendite nndala ayu ghwakambukwa kwa uhwacho ghwake.” ");
INSERT INTO nww_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ndo Yuda Isikaliyote yumoo ywa bhala ahundwa mbinda mabhoko yimo na abhili kakighenda kwa andundame akulu ngati kakankiluke Yesu. ");
INSERT INTO nww_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mandundame akulu pakayihwite nhalo aghwo bhakiyelelwa munu, bhakinnagha kunpegha ngalabha. Hinu Yuda kakiyanda kupalaha ling'ebu lya kunkiluka Yesu. ");
INSERT INTO nww_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lisiku lya ulongohi lya chekwa ya mangate ya nga kuyingihwa linjacha, lisiku paanhinjite mwana mene ahundwa bhake bhakinkonya Yesu, “Ghungupala tughutendekehele kwoki pakulyegha Pasaka?” ");
INSERT INTO nww_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Hinu Yesu kakialaghila abhili muahundwa bhake, kakiaghombela, “Nng'ende kukitami, na akwo ma mmona nnume yumo yunakuyegha kibhigha kya machi ndo muntughile, ");
INSERT INTO nww_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mbaka ku lubhagha lwakayingila munng'ombele yula nkola kaya pakayingiliti yula yuna kibhigha ‘Nhunda kangukonya, kyumba kati kyake kibhegha kwoki kya agheni kyene kikapala kulyegha Pasaka papamu na ahundwa bhangu?’ ");
INSERT INTO nww_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Naywo katabhalaha chumba kati kikulu muligholofa lyake na maabhona hilibhi hyoha hibhegha kala kwa kya twenga.” ");
INSERT INTO nww_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bhala ahundwa bhakibhuka, bhakighenda kukitami, na bhakibhona hilibhi hyoha tela tela handa Yesu pakaaghombilite na bhakitendekeha hilyo hya Pasaka amwo. ");
INSERT INTO nww_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Payihikite makimuhi, Yesu kakihika papamu na ahundwa bhake mbinda mabhoko yimo na abhili. ");
INSERT INTO nww_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Paabheghite mukulyegha hilyo Yesu kakiaghombela, “Kulyaghila nungubhaghombela yumoo ywenu yunakulyegha papamu na nenga katangiluka.” ");
INSERT INTO nww_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Apa ahundwa bhake bhakiyanda kuhyononeka, bhakinkonya yumu mbole ya yumu “Ngati nenga ng'obhe?” ");
INSERT INTO nww_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu kakiayanga, “Ndi yumoo ywenu mwenga mbinda mabhoko yimo na abhili, yuna kuchwika lingate papamu na nenga mukipumbulu. ");
INSERT INTO nww_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kiyaha Mwana ghwa Mundu katakomwa handa yityekitwe. Peni kimmone Mundu yula ywakankiluka mwana ghwa Mundu mbaha mundu aywo kangalepelitwe kubhelekwa!” ");
INSERT INTO nww_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Paabheghite mukulyegha Yesu kakitola lingate, kakilumba, kakilimetula na kuapegha ahundwa bhake pakighomba. “Mughutole nlyeghe aghu ndo mmili ghwangu.” ");
INSERT INTO nww_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mbole kakitola nteko ghwa difwai, Kakinnumba Chapanga na kakibhapegha bhoha bhakinyweghela nteko aghwo. ");
INSERT INTO nww_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kakiaghombela, “Aghu ndo mwahi ghwangu ghwa Ninganilo, ghuuchecheka kwa kya bhandu bha ayaloho. ");
INSERT INTO nww_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kulyaghila ningubhaghombela, nda nywegha kangi ng'obhe difwai ya lisabibu mbaka lisiku lila linonda kunywegha ya hyono mu Ghubhutwa ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Paayimbite kala nhambo, bhakibhuka bhakighenda kukitumbi kya Miseituni. ");
INSERT INTO nww_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu kakibhaghombela ahundwa bhake, “Mabhoha mwenga mataneka, Mana matyeko ghaghomba, ‘Ndantuta yunakuhakila, na mene nabho bhatapwilinganika.’ ");
INSERT INTO nww_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Peni mbole ya kuhyuka, ndabhalongolela kula ku Galilaya.” ");
INSERT INTO nww_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petili kakighombela Yesu, “Hata handa bhoha bhataghuleka, nenga ndaghuleka ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu kakinng'ombela Petili, “Kulyaghila ningughughombela uhiku aghu ghwanganila pandatu, ukakali na kubhika njogholo pabhili.” ");
INSERT INTO nww_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peni Petili kakighendelela kughomba, “Hata payinoghela kuhwegha papamu na ghwenga, ndaghuleka ng'obhe.” Nabho ahundwa bhangi bhoha bhakighomba bhu bhwabhu abho. ");
INSERT INTO nww_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bhakihika mukitogholo kya Getisemani, Yesu kakibhaghombela ahundwa bhake, “Ntame apa, nenga pang'enda kuyupa. ");
INSERT INTO nww_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Mbole kakibhatola Petili na Yakobu na Yohana. Naywo Yesu kakiyanda kuhyononeka na kughayaghaya.” ");
INSERT INTO nww_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kakibhaghombela, “Mwoyo ghwangu ghubha na luhyononeko ugheghela na kuhwegha. Ntami apa na nkilukihe.” ");
INSERT INTO nww_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kakighenda ulongolo pamandina, kakighwegha pahi makukama, kakiyupa kukita, handa yahotoleka kuyingila lisaa alyo lya kimbamanda linhyetuke. ");
INSERT INTO nww_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kakighomba, “Tate ghwangu, kwa ghwenga mihalo hyoha yinguhotoleka. Ghumuhile nteko aghu peni yikotoke kubhegha kimbala nenga ngati kila ghukipalite ghwenga.” ");
INSERT INTO nww_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kakibhuya kwa ahundwa bhake bhala andatu kakibhabhona akighonja, kakinkonya Petili, “Simoni, ghukighonja? Ghulepelwa kukiluha hata lisaa limu? ");
INSERT INTO nww_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nkiluhe na kuyupa mangayingila mumayigho. Nhuki ghungupala peni mmili ghubhegha nnelebhu.” ");
INSERT INTO nww_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kakighenda kangi kuyupa pakighomba malagho ghaghalaghala. ");
INSERT INTO nww_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Mbole kakibhuya kwa ahundwa bhake, kakibhabhona akighonja kangi kiyaha mehu ghabhe ghakitopelwa na ng'ono nabho bhakimanya ng'obhe kya kunng'ombela. ");
INSERT INTO nww_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kakibhabhuyila pandatu, na kakiakonya, “Nkali makaghonja na kupumulila? Hinu muyimuke, Lisaa lihika kala Mwana ghwa Mundu kangukamuhwa mumabhoko gha bhandu bhana ulemwa. ");
INSERT INTO nww_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nnyumuke tughende! Nnole, yula ywakunngiluka kaheghelela.” ");
INSERT INTO nww_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu pakabheghite akali mukughomba, Yuda, yumoo ywa bhala ahundwa mbinda mabhoko yimo na abhili, kakihika papamu na lumati lwa bhandu bhaabheghite na mikechelo na hinduku. Bhandu abho bhakilaghilwa na andundame akulu ahunda bha malaghilo na aghohi. ");
INSERT INTO nww_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuda Isikaliyote nkiluka kakibhapegha naho bhala bhandu kukita, “Yula yunonda kunhyubhatila, ndo mwene, munkamule na munng'eghe kindakila.” ");
INSERT INTO nww_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Hino Yuda pakahikite, kakinng'endela Yesu na kaking'ombela “Nhunda!” Mbole kakinhyubhatila. ");
INSERT INTO nww_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bhala bhandu bhakinkamula Yesu, na bhakinbhika kindakila. ");
INSERT INTO nww_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ndo yumoo ywa bhala bhaayimite apo papamu na Yesu kakihomola kikechelo kyake kakintuta ndumitumi ghwa Ndundame Nkulu na kakinkechula likutu. ");
INSERT INTO nww_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu kakiakonya, “Nhika na mikechelo na hinduku handa kukita nenga ndi npoka? ");
INSERT INTO nww_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Masiku ghoha nikibhegha papamu na mwenga panibhahunda mu Kitutubhi kya Chapanga, kya nga kungamula. Peni hino Matyeko ghanakung'anyima mbaka ghakamale.” ");
INSERT INTO nww_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ndo ahundwa bhake bhoha bhakinneka na kutukumbuka lubhilo. ");
INSERT INTO nww_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kakibha na nhongolo yumu ywakabheghite kanguntughila Yesu kakihwala nng'ololi nhuhu, nabho bhakiyigha kunkamula. ");
INSERT INTO nww_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Peni mwene kakityelembuka kakighuleka ghula nnghololi kakitugha kyanga lipinda. ");
INSERT INTO nww_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bhakinnyegha Yesu kwa Ndundame Nkulu nabho andundame akulu, aghohi na ahunda bha malaghilo bhakikongongana papamu. ");
INSERT INTO nww_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petili kakintughila Yesu kya kutalii, mbaka kulubhigho lwa Ndundame Nkulu. Akwo kakitama papamu na amachonda bha kupingikiha paakiyota mwoto. ");
INSERT INTO nww_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mandundame akulu na bhandu bhoha bha libalasa likulu bhakipalaha uyimiho ghwa kunkokeha Yesu ngati ankome, peni bhakilepelwa. ");
INSERT INTO nww_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bhandu ayoloho bhakighomba uyimiho ghwa uhwangi kwa kya Yesu, peni uyimiho ghwabhe ghukiponingana. ");
INSERT INTO nww_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ndo bhangi bhakiyima bhakilongela uyimiho ghwa uhwangi kwa kya ywombe pakilongela, ");
INSERT INTO nww_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tukinnyihwa mundu ayu pakalongela, ‘Ndakihalulanga kitutubhi lya Chapanga ali liichengitwe na bhandu na mumasiku mandatu ndalichenga lingi lya nga kuchengwa kwa mabhoko gha anabhandu’” ");
INSERT INTO nww_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Peni hata habhu unyimiho ghwabe ghukiponingana. ");
INSERT INTO nww_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ndundame Nkulu kakiyima nga paulongolo ghwabhe, kakinkonya Yesu, “Bhuli ghwenga ghuyanga ng'obhe? Ulemwa niki ghwaaghughombela?” ");
INSERT INTO nww_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Peni ywombe kakinyamala jii na kakighomba ng'obhe hata lilagho limo. Ndundame Nkulu kakinkonya kangi, “Ghwenga ndo Kilisto, Mwana ghwa Chapanga Nkwiho?” ");
INSERT INTO nww_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu kakiyanga. “Ena nenga ndo mwene, kangi matammona Mwana ghwa Mundu katama mukibhoko kya nnilo kya Chapanga yunamakakala, pakahika mumahundi gha kuluhingu.” ");
INSERT INTO nww_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ndundame Nkulu kakilikachula lipinda lyake pakilongela; “Tughupalaha uyimiho ghwoki kangi? ");
INSERT INTO nww_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mwenga munyihwa pakanlighite Chapanga npimaki?” Bhoha bhakilamula kukita yinnoghela kakomwe. ");
INSERT INTO nww_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Amoo bhangi bhakiyanda kunhunila mata, bhakinngubika mehu ghake na bhakintuta na kung'ombela “Ghulondole kukita ghani ywakakutulite!” Amachonda bhakintola na bhakintuta mambande. ");
INSERT INTO nww_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petili pakabheghiteghe pahi kulubhigho, yumoo ywa akaandumitumi nndala ghwa Ndundame Nkulu kakihika. ");
INSERT INTO nww_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Paka mmonite Petili pakayota mwoto, kakinnolekeha kaking'ombela, “Hata ghwenga ghukibha papamu na Yesu ghwa ku Nasaleti.” ");
INSERT INTO nww_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Peni Petili kakimaka pakighomba, “Nummanya ng'obhe hangi ghughaghomba nigughamanya ng'obhe.” Mbole kakibhuka kakighenda pakuyingilila. Apa njogholo kakibhika. ");
INSERT INTO nww_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Yula nndumitumi nndala pakammonite kangi Petili, kakiaghombela bhala ayimite nabho, “Mundu ayu ndi yumoo ywabhe.” ");
INSERT INTO nww_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petili kakimaka kangi. Mbole pamandina bhandu bha ayimite apwo bhakinng'ombela Petili, “Kulyaghila ghwenga ndi yumoo ywabhe, mana ghwenga ndi Nngalilaya.” ");
INSERT INTO nww_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Peni Petili kakiyanda kukotola na kulapa pakighomba, “Nenga nunmanya ng'obhe mundu aywo yumunnghomba mihalu yake.” ");
INSERT INTO nww_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Apa njogholo kakibhika paabhili, Petili kakihwachila kya aghombite Yesu “Ikali na njogholo kubhika paubhili ghwa nnganila pandatu” Petili kakilila munu kakipopoheka mahohi. ");
INSERT INTO nww_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Malabhila putiputi, akaandundame hilongohi, papamu na aghohi, na ahunda bha Malaghilo na aghoyi bha Libalasa lyoha bhakipatana kala malobhe, bhakinmopa Yesu na kunnyegha na kunkamuha kwa Pilato. ");
INSERT INTO nww_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato kakinkonya, “Ghwenga ndo Mutwa ghwa Akaayahudi?” Yesu kakinnyanga, “Ena yibha handa ghughombite.” ");
INSERT INTO nww_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Hilongohi bha Akandundame bhakinkokela Yesu kwa mihalo miyoloho. ");
INSERT INTO nww_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato kakinkonya kangi, “Bhuli, ghubhegha na kya kuyanga ng'obhe? Ghulole nongwa nyoloho bhaghuyegheliti ya kya ghwenga.” ");
INSERT INTO nww_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Peni Yesu kakiyanga ng'obhe kyoheli, ndo Pilato kakikangacha. ");
INSERT INTO nww_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Yikibhegha hitohe yabhe pachekwa ya Pasaka Pilato kunmopolela ywakabheghite mu kibhopo ywohele ywene bhandu bhaanpalite. ");
INSERT INTO nww_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mumasiku agho kakibhegha mundu yumo ywaankemiteghe Balaba ywakabhopitwe papamu na akiluka bhangi, bhakiakoma bhandu mu bhulwa nkulu. ");
INSERT INTO nww_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Lula lumati lwa bhandu lukihika kwa Pilato na lukipala kabhatendele handa muyibheghite hitohe hyaki. ");
INSERT INTO nww_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato kakiakonya, “Mungupala nibhahughulile ayu Mutwa ghwa Akaayahudi?” ");
INSERT INTO nww_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato kakilongela bhula kiyaha kakimanya kukita alongohi ghwa Andundame bhakinnyegha Yesu kwa mwene kwa luhila. ");
INSERT INTO nww_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Peni hilongohi bha andundame bhakilukokeha lula lumati lwa bhandu bhannyupe Pilato kabhabhopolele Balaba mbole ya Yesu. ");
INSERT INTO nww_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato kakiakonya kangi, “Hinu mungupala nintendele niki ayu yumunkema Mutwa ghwa Akaayahudi?” ");
INSERT INTO nww_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bhakituta kyobho kunu bhakighomba “Ghummangalile palupingika!” ");
INSERT INTO nww_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato kakiakonya, “Kiyaha niki? Katenda uhakata niki?” Peni bhene bhakituta kyobho kwa makakala makulu, pabhakighomba, “Ghummangalile!” ");
INSERT INTO nww_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato pakipala kulunogheha lula lumati lwa bhandu, kakibhahughulila Balaba, na mbole ya kuntegheka Yesu kututwa hinjupunjupu mbole kakinbhuha kabamandwe. ");
INSERT INTO nww_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Amachonda bhakinyegha Yesu mbaka kuludamu lwa nyumbakati lwa kitutubhi kya nkulu ghwa nnima ghwa Yudea, akwo bhakikongana kimati kyoha kya machonda. ");
INSERT INTO nww_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bhakinhwaliha Yesu lipinda lya salabati na kilemba kya ghubhutwa kipyokolitwe kwa mihomi na bhakinhwika mumutwe. ");
INSERT INTO nww_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bhakiyanda kunnjambuha kwa uyuyuho, “Mwika, Mutwa ghwa Akaayahudi.” ");
INSERT INTO nww_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bhakintuta nhimbati ghwa nndenge kumutwe, bhakinhunila mata, bhakichutama mayughwa mukibhungi kyake na bhakinhokamila. ");
INSERT INTO nww_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Paayomolite kuntendela lihwangila bhakinhula lila lipinda lya salabati na bhakinhwalia mapinda ghake. Mbole bhakinpiha panje bhakammangalile. ");
INSERT INTO nww_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mundu yumo kuhuma ku Kilene, lihina lyake Simoni, tate ghwabhe Alekisanda na Lufo, kakibha mumwanja kuhuma panje ya kitami, amachonda bhakinkwilikiha kulughegha lula lupingika lwa Yesu. ");
INSERT INTO nww_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ndo bhakinng'egha Yesu mbaka ku Goligota mana yake, pa Huhu ya Mutwe. ");
INSERT INTO nww_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nabho bhakinpegha bhwengu ghuhanganganikite na ntela ghukemitwe manemane, peni kinywegha ng'obhe. ");
INSERT INTO nww_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ndo bhakimmangalila mulupingika, na bhakighabhana mapinda ghake mumabhwombe kwa kutenda uhaghulo ngati ghani kapati kyoki. ");
INSERT INTO nww_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ndo yikibhegha malabhila ya saa ndatu paamangalite mulupingika. ");
INSERT INTO nww_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bhakityeka malembo gha nongwa yake, “Mutwa ghwa Akaayahudi.” ");
INSERT INTO nww_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Papamu na ywombe bhakibhangalilwa apoka abhili, yumoo mumbande yake ya nnilo na yungi mumbande ya ngiya kila mundu mulupingika lwake. ");
INSERT INTO nww_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Na matyeko mang'anyimo ghakitengeleheka ghaghombite “Kakibhalangwa papamu na bhanauhokelo.” ");
INSERT INTO nww_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bhandu bha apitite ugheghela na apwo bhakinokola mitwe yabhe kwa lihwangila na bhakinligha paakighomba “Aaah, ghwenga ghwakukikanjaghana Kitutubhi kya Chapanga na kukichenga mumasiku mandatu! ");
INSERT INTO nww_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Hino ghulilopohe ghumwene, ghuhuluke mulipingika.” ");
INSERT INTO nww_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ubhwabhu abhu Hilongohi bha andundame papamu na ahunda bha malaghilo bhakintendela lihwangila mubhombe paakighomba, “Ywene kakialopoha bhandu bhangi, peni kahotola ng'obhe kulilopoha mwene! ");
INSERT INTO nww_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Maka ayu, Kilisto ywakahaghulitwe na Chapanga, Mutwa ghwa Akaayahudi, kahuluke hinu kuhuma mulipingika, ngati tubhone na kuhyubhalila.” Bhala abhili bhaabhangalitwe papamu naywo nabho bhakinligha. ");
INSERT INTO nww_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Paihikite saa nhano na yimu mbaka saa nhano na nchehe pamuhi kukibhegha na lubhindu lukulu lukighubika nnima ghoha. ");
INSERT INTO nww_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mulisaa lya nhano na ncheche makimuhi Yesu kakilila kwa lilobhe likulu pakilongela “Eloi, Eloi, lama sabakitani?” Mana hyaki, “Eeeh Chapanga, Chapanga ghwangu bhuli ghunguneka?” ");
INSERT INTO nww_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bhandu amoo bhangi ayimite paugheghela paayihwite mihalo aywo bhakighomba, “Munnyihwe kangunkema Eliya.” ");
INSERT INTO nww_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mundu yumo kakitugha lubhilo, kaghenda kutola libhoya na kuchwika mu difwai yichachandikite, kakilibhika mulidenge, kakinpegha kanyweghe pakighomba, “Hinu, munleke, ngati tubhone kukita Eliya katahika kunhuluha apwo palupingika.” ");
INSERT INTO nww_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mbole Yesu kakilila kwa lilobhe likulu na kakighwegha. ");
INSERT INTO nww_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Na lipasia likulu lya kitutubhi kya Chapanga lukibaluka mbande hibhili kuhumila unani mbaka pahi yake. ");
INSERT INTO nww_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Hino yumoo ywa akulu bha amachonda ayimite apwo muulongolo ghwa lupingika ghwa Yesu, pakabhonine pakaghonjite ntumba, kakighomba, “Kulyaghila mundu ayu kakibhegha Mwana ghwa Chapanga!” ");
INSERT INTO nww_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Hilahila akibhegha adala ammoo bhangi kya kutali, na mubhene akibhegha, Malia mundu nndala ghwa ku Magidala, Malia ma ywabhe Yakobu nndokwa na Yosefu papamu na Salome. ");
INSERT INTO nww_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Adala abha ndo bhantughilite Yesu na kuntangatila paabheghite ku Galilaya. Kangi bhakibhegha adala bhangi ayoloho bhahikite papamu naywo ku Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Payihikite makimuhi, kiyaha likibhegha lisiku lya Makunganiko, lisiku limo kukali na kuhika Lisiku lya Kupughwa. ");
INSERT INTO nww_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yosefu ghwa Alimataya mundu ghwa kuhokamilwa mu njenga kaya ngulu ya Akaayahudi, naywo kakighupala muno Ghubhutwa ghwa Chapanga. Kaking'endela Pilato kya nga lyogha na kakighupala mmili ghwa Yesu. ");
INSERT INTO nww_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato kakikangacha pakayihwite kukita Yesu kahwegha kala. Ndo kakinkema yula kilongohi ghwa amachonda, na kakinkonya kukita handa Yesu kahwegha kala. ");
INSERT INTO nww_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilato pakayihwite nhalo ghwa kuhwegha kwa Yesu kuhuma kwa nkulu ghwa machonda, Pilato kakintegheka Yosefu kakaghutole ntumba aghwo. ");
INSERT INTO nww_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Apo Yosefu kakihemela sanda, kakighuhuluha mmili ghwa Yesu kuhuma mulupingika, mbole kakighunyengeleha sanda na kakimmika mulindogholo lihongolitwe mulitalabha na kakilibhilingiha liganga na kulitata lindogholo alyo. ");
INSERT INTO nww_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Malia mundu nndala ghwa ku Magidala na Malia ma ghwake Yosefu bhakipabhona apwo pakaghonjihitwe. ");
INSERT INTO nww_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Paliyomokite Lisiku lya Kupughwa, Malia mundu ndala ghwa ku Magidala, Malia maghwake Yakobu na Salome bhakihemela hilibhi hya kunungilila ngati bhaghutyeke mmili ghwa Yesu. ");
INSERT INTO nww_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Malabhila puti puti, lisiku lya ulongohi lya juma ndo Jumapili, kamu palubalikiti luchubha bhakighenda kulindogholo. ");
INSERT INTO nww_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Munjila bhakikonyana, “Ghani ghwa kutubhilingihila lila liganga panlyango ghwa lindogholo?” ");
INSERT INTO nww_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Peni paalolekihite, bhakilibhona lila liganga likulu munu, likibhilingihwa kala kuhuma panlyango ghwa lindogholo. ");
INSERT INTO nww_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Paabheghite mukuyingila mula mulindogholo, Bhakimmona nhongolo yumo ywakahwalite lighwanda lihuhu na kakitama mu mbande ya nnilo, nabho bhakibhughanikwa muno. ");
INSERT INTO nww_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Naywo kakiaghombela, “Nkoto kubhughanika. Mungunpalaha Yesu, ghwa Nasaleti ywakabhangalilitwe mulipingika. Kahyuka, Kabhegha ng'obhe apa, nnole apa paanng'onjihite. ");
INSERT INTO nww_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Hino nng'ende mukabhaghombele ahundwa bhake papamu na Petili, kukita, ‘Kabhalongolela kughenda ku Galilaya, akwo ndi bhatammona handa pakabhaghombilite.’ ” ");
INSERT INTO nww_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ndo bhakibhuka na bhakitugha lubhilo kuhuma mula mulindogholo bhakibha na bhwaghalihi nkulu na nkangacho, nabho bhaking'ombela ng'obhe mundu ywohele lilagho lyoheli kiyaha bhakiyoghopa munu. ");
INSERT INTO nww_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu pakahyukiti ngeha puti puti lisiku lya ulongohi lya juma, kakimbwitukila huti Malia mundu nndala ghwa Magidala, ywakabhuhitwe mandilu nhano na abhili na Yesu. ");
INSERT INTO nww_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Malia kakighenda kubhaghombela bhala bhaabhegite mu kulongohana na Yesu, abho akibha akali bhangukukulika na kulila; ");
INSERT INTO nww_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","peni paayihwite kukita Yesu kakali kangukeka na kukita Malia kakimmona, bhakinhyubhalila ng'obhe. ");
INSERT INTO nww_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mbole Yesu kakiabwitukila abhili muahundwa bhake paabheghite mukughenda panje ya kitami na kakibhegha mu kibhungi kingi. ");
INSERT INTO nww_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nabho bhakibhuya na kubhaghombela ayabhe. Peni nabho bhakihyubhalila ng'obhe. ");
INSERT INTO nww_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mbole Yesu kakiabwitukia bhala ahundwa bhake mbinda maboko yimo na yumo, paabheghite mukulyegha hilyo. Kakiandakila kwa ghwagahyubhalila ghwabhe na unonopo ghwa myoyo yabhe, Kiyaha bhakibhahyubhalila ng'obhe bhala bhammonite mbole ya kuhyuka. ");
INSERT INTO nww_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kakiaghombela, “Nng'ende kumilima hyoha, mukalandamihe Nhalo ghwa Maha kwa bhandu bhoha. ");
INSERT INTO nww_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ywohele ywakahyubhalila na kubatiswa katalopoka. Peni ywohele ywa nga kuhyubhalila katatoswa. ");
INSERT INTO nww_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nayo mihabho ayi yabhegha papamu na bhala bhanakuyubhalila. Kwa lihina lyangu bhabhuha mandilu, na bhayobhela kwa nongelo ya hyono, ");
INSERT INTO nww_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","handa paakamula mayoka, ebu paanywegha lusungu lwoheli, bhaatebhaha ng'obhe, bhatayabhika mabhoko ghabhe kwa atamwa nabho bhatalama.” ");
INSERT INTO nww_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mbole ya kughomba agha Bambo Yesu, kakitolwa kunani kuluhingu na kakitama mumbande ya nnilo ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ndo ahundwa bhake bhakibhuka, bhakilandamiha kwoha, naywo Bambo kakitenda lihengo papamu nabho na kutengelekeha nhalo ghwake kwa mihabho yilongohanite nabho.");
INSERT INTO nww_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ghanja Tofili. Bhandu bha mahele bhakilitumba kutyeka handa bhaatyekite luhumu lula lubwitukilite mutwenga. ");
INSERT INTO nww_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bhatyeka handa mutughombilitwe na bhaabhonite kwa meho ghabhe kuhuma ku ulongohi ghwa lihengo lya Yesu abho ndo andumitumi bhaayilandamihite mihalu ayo. ");
INSERT INTO nww_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mbole ya kughulolekeha maha nlando ghula kuhuma ku ulongohi ghwake, mmona ibhegha maha nighutyekele kwa nningo, ghwenga nnongo Tofili, ");
INSERT INTO nww_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ngati na ghwenga ghupate kumanya yila hoto ya ghala gha ghuhunditwe. ");
INSERT INTO nww_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Pala Helode pakabheghite mutwa ghwa nnima ghwa Yudea, pakibhegha ndundame yumu lihina lyake Sakalia, mwene kakihuma mu kimati kya mandundame ghwa Abiya. Elisabeti nhumbu ghwake nayo kakibha ghwa ubheleko ghwa ndundame Aluni. ");
INSERT INTO nww_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakalia na nhumbu ghwake Elisabeti bhoha abhili bhakitama kwa kughatughila ghakaghapala Chapanga paakighayitikila malaghilo na ngwiliho ya Bambo kyanga libhaya, ");
INSERT INTO nww_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","peni bhakibha na mwana ng'obhe, kiyaha Elisabeti kakibha ng'obhe na makakala gha kulela na abha abhili bhakibha aghohi muno. ");
INSERT INTO nww_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Linjubha limu payibheghite samu yake ya kutendekeha lihengo lya undundame mu Kitutubhi kya Chapanga, ");
INSERT INTO nww_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","bhakinhaghula kwa njunga handa yibheghite hitohe hya andundame, na kakiyingila mu Kitutubhi kya Chapanga, ngati kakantutumihe luhumba Bambo. ");
INSERT INTO nww_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pakabheghite mu lihengo lya kututumiha luhumba, lumati lwa bhandu lukibha lukinnyupa Chapanga panji. ");
INSERT INTO nww_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Hinu lihoka ghwa Chapanga kakinbwitukila Sakalia, kakiyima ku nnilo ghwa likuta lya kuntutumiha luhumba Bambo. ");
INSERT INTO nww_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakalia pakammonite kakiyituka na kakiyingilwa na lyogha, ");
INSERT INTO nww_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","peni yula lihoka lya Chapanga liking'ombela, “Ghukotoke kuyoghopa Sakalia nyupo hyako yiyihwanika, na nhumbu ghwako Elisabeti katapapa mwana nnume, na lihina lyake ankema Yohane. ");
INSERT INTO nww_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ghwenga ghwabhegha na chekwa na bhandu atangalo bhatayelelwa kwakya kubhelekwa kwa mwene. ");
INSERT INTO nww_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kiyaha katabhegha nkulu paulongohi ghwa Bambo, katanywegha ng'obhe difwai ebu ughimbi peni katamemekwa na Nhuki ghwa Chapanga kuhumila mulutumbo lwa ma ghwake. ");
INSERT INTO nww_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Na ywombe katabhabhuyiha bhandu atangalo bha Aisilaeli kwa Bambo Chapanga ghwabhe. ");
INSERT INTO nww_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Mwene katalongolela paulongolo ghwa Bambo munhuki na likalama lya Eliya, na katayitenda myoyo ya abhele yibhatendele bhana bhabhe gha maha, nabhanga kuyitika bhabhe na mahala gha kughatughila ghakaghapala Chapanga na katabhabhika kala bhandu kwakya Bambo.” ");
INSERT INTO nww_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakalia kakilighombela lila lihoka lya Chapanga, “Ndamanya bhuli kukita nnando aghwo ndo hoto? Kiyaha nenga na nhumbu ghwangu tubhegha twa aghohi.” ");
INSERT INTO nww_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Yula lihoka lya Chapanga likinnyanga, “Nenga ndo Gabilieli, nndumitumi ghwa Chapanga, naghilwa kwa ghwenga ngati nighughombele mihalo ya maha ayi. ");
INSERT INTO nww_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Hinu kiyaha, ghunguhyubhalila ng'obhe mihalu ayi yiipala kutulukila mung'ebhu yake, habhu ghwaabhegha ghwanga kulongela mbaka paghatulukila.” ");
INSERT INTO nww_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Peniapwo bhandu bhakibha bhangunnindila Sakalia panji, kunu paakangacha kya kukabhalila kuhuma mu kitutubhi kya Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pakahumite panji kakihotola ng'obhe kuyobhela nabho, kakiapegha naho kwa mabhoko, bhene bhakimanya kukita kabhona mabhono mu kitutubhi kya Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Hinu manjubha gha kutumikila mahengo gha undundame ghakipela na kakibhuya ukaya kwake. ");
INSERT INTO nww_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mbole ya manjubha ghala nndala ghwake Elisabeti kakiyima ndumbo, naywo kakibhuka ng'obhe ukaya kwake kwa myehi nhano. ");
INSERT INTO nww_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Kakilongela “Ali ndo lyakandendilite Bambo, kannola na kayibhuha honi ya nenga ya kulepelwa kupapa kwa bhandu.” ");
INSERT INTO nww_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mwehi ghwa sita mbole ya kuyima ndumbo Elisabeti, lihoka lya Chapanga lihina lyake Gabilieli likilaghilwa na Chapanga kaghende ku kitami kya Nasaleti mu nnima ghwa Galilaya ");
INSERT INTO nww_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kwa nhinja kamwali yumu ywakaluhitwe na mundu yumo lihina lyake Yosefu ghwa lukolo lwa Daudi. Lihina lya ayo nhinja likibhegha Malia. ");
INSERT INTO nww_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Na yula ndumitumi ghwa kunani ghwa Chapanga kakinhikila Malia na kakinng'ombela, “Mwika ghwenga ghunonelitwe na Bambo kabhegha papamu na ghwenga!” ");
INSERT INTO nww_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Malia kakibhughanika muno kwa kya nhalo ghula na kakilikonyekeha mwene mu mwoyo ghwake, “Jambuho ayi fwambulo yake niki?” ");
INSERT INTO nww_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ndo lihoka lya Chapanga likinnyanga, “Malia ghukotoke kuyoghopa, Kiyaha Chapanga kakupegha ghumaha ghwake. ");
INSERT INTO nww_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nnole, ghwayima ndumbo, na ghutalela mwana nnume na ghwankema lihina lyake Yesu. ");
INSERT INTO nww_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mwene katabhegha ywa kuhyubhalilwa na bhaankema Mwana ghwa Chapanga ywakabhegha unani mwa hyoha, Bambo Chapanga katantenda kabhe Mutwa kwa kummbegha kiteho kya ghubhutwa kya tate ghwake Daudi. ");
INSERT INTO nww_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Katakitabhala kibheleko kya Yakobu mumanjubha ghoha na Ghubhutwa ghwake ghwabhegha ghwa nga kupela.” ");
INSERT INTO nww_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Malia kakilikonyekeha lila lihoka lya Chapanga, “Yaabhegha bhuli mihalu ayi, kiyaha nenga ngali nhinja kamwali?” ");
INSERT INTO nww_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Lihoka lya Chapanga likinnyanga, “Nhuki ghwa Chapanga kataghuhikila, na likalama lya Chapanga ywakabhegha unani mwa hyoha lyaakugubika, hinu ywaapala kubhelekwa katabhegha Ywakabhaghulitwe kwakya Chapanga, Mwana ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ghumanye naha, nnongo ghwako Elisabeti kabha na ndumbo mu ughohi ghwake na hinu ndo mwehi ghwa sita kwa yula ywakamanyikwa kukita ywa nga kulela, ");
INSERT INTO nww_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","kiyaha kahone lilagho lyanga kuhotolwa kwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Malia kakilongela, “Nnole! Nenga ndo nbhandwa ghwa Bambo, ndendelwe tela na lilagho lyako.” Ndo lihoka ghwa Chapanga kakibhuka na kunneka. ");
INSERT INTO nww_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mbole ya manjubha gha mandina, Malia kakibha mumwanja na kakiyumbatika mbaka pa kitami kimo kuhitumbi hya Yudea. ");
INSERT INTO nww_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kakiyingila mu kitutubhi kya Sakalia na kunnjambua Elisabeti. ");
INSERT INTO nww_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabeti pakayihwite lilobhe lya Malia, mwana ywakabheghite mu lutumbo lwake kakilighalambula, ndo makakala gha Nhuki ghwa Chapanga ghakinhikila Malia. ");
INSERT INTO nww_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kakilongela kwa lilobhe likulu, “Ghunonelwa ghwenga kupitingana kwa adala bhoha naywo yughupala kumpapa kanonelwa! ");
INSERT INTO nww_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nenga ndo ghani, mbaka ma ghwa Bambo ghwangu kanhikile? ");
INSERT INTO nww_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kamu panyihwite lilobhe lyako lya kunnjambuha nonono ghwa mu lutumbo lwangu kakiyelelwa na kulighalambula. ");
INSERT INTO nww_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ghunonelwa ghwenga ghuhyubhalilite lila lyakaghombite Bambo kukita lyahotoleghwa.” ");
INSERT INTO nww_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Malia kakilongela, “Mwoyo ghwangu ghunguntika Bambo, ");
INSERT INTO nww_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Na nhuki ghwangu ghubhegha na chekwa kwa Chapanga ywakannopolite nenga, ");
INSERT INTO nww_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kiyaha kangulungwa nenga nbhandwa ghwake nndokwa, Hinu kutandila hinu bhandu bhoha bhanngema yunakunonelwa ");
INSERT INTO nww_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kiyaha Chapanga yunamakakala kanndendela mihalu mikulu, Lihina libhaghulitwe kwakya Chapanga ndo lihina lyanga kulihwana na mahina ghangi. ");
INSERT INTO nww_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Lipyanda lyako ghunguatendela bha aghutundamila, Kuhuma ubheleko mbaka ubheleko. ");
INSERT INTO nww_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kiyaha katenda mihalo ya mihabho kwa kibhoko kyake, Kabhapwilinganiha bhanaluhimba mumahala gha myoyo yabhe. ");
INSERT INTO nww_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kabhahuluha atabhala muhiteho hya ghubhutwa ghwabhe, peni kabhayinula bhala adokwa. ");
INSERT INTO nww_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kabhayukutiha bhaabheghite na njala kilibhi kya maha, na bhana utopelo kaabhuha kyanga kilibhi kwa mabhoko gha yaghi. ");
INSERT INTO nww_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kantangatila nndumitumi ghwake Isilaeli, pakikulungwa kuapegha lipyanda lyake, ");
INSERT INTO nww_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","kakulungwa kuabhoneha lipyanda kwa Abulahamu na ubheleko ghwake ghoha mbaka manjubha ghoha.” ");
INSERT INTO nww_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Malia kakitama na Elisabeti mu myehi mindatu, mbole kakibhuya ukaya kwake. ");
INSERT INTO nww_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Manjubha gha kupapa kwake Elisabeti ghakihika na kakipapa mwana nnume. ");
INSERT INTO nww_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Paayihwite agheghela na aghanja bhake kukita Bambo kanntendela lipyanda likulu, bhakiyelelwa papamu naywo. ");
INSERT INTO nww_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ndo linjubha lya nhano na ndatu bhakihika kudumula unyagho yula mwana, na bhakipala kunkema Sakalia, lihina lya tate ghwake. ");
INSERT INTO nww_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Peni ma ghwake kakilema, na kakilongela, “Ng'obhe, Lihina lyake kaakemwa Yohane.” ");
INSERT INTO nww_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bhene bhakinnyanga, “Kahone mundu yumo mu lukolo lwako yuna lihina alyo!” ");
INSERT INTO nww_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ndo bhakinntendela naho Sakalia tate ghwa yula mwana ngati bhamanye mwene katapala kunkema mwana lihina lyoki. ");
INSERT INTO nww_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Mwene kakiyupa lihamba lya kutyekela na kakityeka naha, “Lihina lyake Yohane.” Bhandu bhoha bhakikangacha. ");
INSERT INTO nww_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pindulu kakiyanda kukambuka kangi na kakinnonela Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Andamani bhake bhoha bhakiyingilwa na lyogha, na lilagho alyo ghukikwila munnima ghwoha ghwa hitumbi hya Yudea. ");
INSERT INTO nww_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ywoheli yula ywakayihwite mihalo ayi kakihwachila mu mwoyo ghwake na kakikonyekeha “Hinu mwana aywo katabhegha mundu ghwa kya bhuli?” Kiyaha makakala gha Bambo ghabhegha papamu naywo. ");
INSERT INTO nww_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sakalia tate ghwake yula mwana, kakiyingililwa na makakala gha Nhuki ghwa Chapanga na kakilondola naha, ");
INSERT INTO nww_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Tunnonele Bambo, Chapanga ghwa Akaisilaeli, Kiyaha kabhahika kuatangatila bhandu bhake na kuakombola. ");
INSERT INTO nww_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Mwene kakitupegha nlopohi yuna makakala kuhuma mu ubheleko ghwa nndumitumi ghwake Daudi, ");
INSERT INTO nww_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","kakilongela kwa ngulu ya ambuye bhakabhaghulitwe kwakya Chapanga kutandila makachu, ");
INSERT INTO nww_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kukita katatulopoha kwa amyanja bhetu na kutuhumiha mu makakala gha bhala bhoha bhaatulema. ");
INSERT INTO nww_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kakilongela kataabhonela lipyanda atate bhetu, na kaalikulungwa ninganilo liibhaghulitwe na Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kilapo kyakanlapilite Abulahamu hukulu ghwetu, ");
INSERT INTO nww_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kutulopoha kuhuma mu makakala gha amyanja bhetu ngati tuntumikile kyanga lyogha, ");
INSERT INTO nww_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ngati tubheghe bhakabhaghulitwe na Chapanga na ayitikila bha malaghilo ghake, mumanjubha ghoha gha ubhumi ghwetu. ");
INSERT INTO nww_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ghwenga mwana ghwangu, ghwakemwa mbuye ghwa Chapanga ywakabhegha unani ghwa hyoha kiyaha ghwabhegha pa ulongohi gwa Bambo na kutendekeha njila kwa kya Bambo. ");
INSERT INTO nww_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kubhalandamiha bhandu kukita bhatalopolehwa, kwa kulekekehwa ulemwa ghwabhe. ");
INSERT INTO nww_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Upalo ghwa Chapanga na lipyanda lyake lyatutenda tubheghe bhakabhaghulitwe na Chapanga, handa nkenge palutuyakila unani mwetu. ");
INSERT INTO nww_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kwa twenga tuutama mu kihwili kya lubhindu kya kiho, bhwelo alo lutubhutukila na kutulongoha mu ubhumi ghwa uhihimilo.” ");
INSERT INTO nww_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yula mwana kakikula na kuyonjokeheka makakala munhuki. Kakitama ku kibhala mbaka linjubha lila pakabwitukilite kwa Akaaisilaeli. ");
INSERT INTO nww_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mu manjubha ghala Mutwa nkulu ghwa Akaaloma ywaakemitwe Agustino, kakikwilikiha bhandu bhoha bha utabhala ghwa nnima ghwa Lumi abhalangwe. ");
INSERT INTO nww_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mmalango aghwo ghwa bhandu ndo ghwa ulongohi pakabheghite Kulenio Mutwa ghwa nnima ghwa Silia. ");
INSERT INTO nww_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Bhandu bhoha bhakighenda kubhalangwa kukitami pakabhelekwite. ");
INSERT INTO nww_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Naywo Yosefu bhubho kakiyanda mwanja kuhuma ku kitami kya Nasaleti yiibheghite mu nnima ghwa Galilaya, kiyaha kakibhegha ghwa ubheleko ghwa Daudi, kakighenda kumbwani Betelehemu ku nnima ghwa Yudea, pakabhelekite mutwa Daudi ");
INSERT INTO nww_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kakighenda akwo kubhalangwa papamu na Malia nndala ywakanluhite, naywo Malia kakibha na ndumbo, ");
INSERT INTO nww_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","pa bhabheghite ku Betelehemu, linjubha lya Malia lya kupapa likihika. ");
INSERT INTO nww_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kakilela mwana nnume ghwa ulongohi na kakinhwika mapinda gha kilembwe, na kaking'onjeka mwana mulikungwa lya kualyegheha senga kiyaha yikibha ng'obhe ng'ebu kukitutubhi kya ahenja. ");
INSERT INTO nww_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Munnima aghwo, pakibhegha ahakila anyama bha atamiteghe muihaka, paakihakila himati hyabhe hya anyama bha kuhuhwa pakilo. ");
INSERT INTO nww_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kamu nnole, lihoka lya Chapanga likiabwitukila, na ukulu ghwa Bambo ghukiang'alikiha mumbande hyoha, na bhakiyingilwa na lyogha muno nabho bhakiyoghopa, ");
INSERT INTO nww_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","peni lihoka lya Chapanga kakinng'ombela, “Nkotoke kuyoghopa! Kiyaha nnole, hika kubhaghombela nhalo ghwa maha ghwa kuayelela bhandu bhoha. ");
INSERT INTO nww_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lelo mukitami kya Daudi, kwakya mwenga kabhelekwa nlopohi ndo Kilisito Bambo! ");
INSERT INTO nww_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na ayi ndo naho kwa mwenga, mammona nonono kabhulungililwa mapinda gha king'enya na anng'onjeka mu likungwa lya kualyegheha senga.” ");
INSERT INTO nww_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kamu kukibha na lumati lukulu lwa hibhumbe bha kunani kwa Chapanga papamu na alyo lihoka lya Chapanga paakintika Chapanga paakilongela, ");
INSERT INTO nww_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kubheghe na ukulu akwo kunani kwa Chapanga, na uhihimilo ghubheghe munnima, kwa bhandu bha abhahaghulite.” ");
INSERT INTO nww_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Abho Mahoka bha Chapanga Pabhabhukite kungughenda kunani kwa Chapanga bhala ahakila anyama bhakighombana, “Tughende Kubetelehemu tukaghubhone lilagho alyo, ghwakatughombilite Bambo.” ");
INSERT INTO nww_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ndo bhakiyumbatika kughenda ku Betelehemu na bhakiahikila Malia na Yosefu na yula nonono kaghonjehwa mu likungwa lya kualyegheha senga. ");
INSERT INTO nww_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Paammonite yula nonono bhakialubhulila lila lilagho bhaaghombilitwe ghakya yula mwana. ");
INSERT INTO nww_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nabho bhoha bhaayihwite mihalo yaaghombilitwe na ahakila anyama bhakighakangacha, ");
INSERT INTO nww_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","peni Malia kakiyibhika malagho agho ghoha mumwoyo ghwake na kughahwachila muno. ");
INSERT INTO nww_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bhala ahakila mene bhakibhuya, kunu paakikweha na kuntikila Chapanga kwa mihalu hyoha ya ayiyihwite na kuyibhona, handa paaghombilitwe na andumitumi ghwa kunani ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mbole ya linjubha lya nhano na ndatu, ndo likibha linjubha lya kunndumula unyagho yula mwana, na bhakinkema Yesu, lihina lyakakambukite lihoka lya Chapanga, yikali na Malia kuyima ndumbo. ");
INSERT INTO nww_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Palihikite linjubha lya kuliyogha, Malia na Yosefu tela na malaghilo gha Bambo ghakankamuhite Musa, Malia na Yosefu bhakighenda na mwana Kuyelusalemu ngati bhakannumike mwana kwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Handa muyityekitwe mu Malaghilo gha Bambo, “Mwana nnume ywohele ywa ulongohi kaabhaghulwa kwakya Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bhakighenda kutendekeha nyambi handa muyityekitwe mumalaghilo gha Bambo, ngunda abhili ebu ngunda bhana abhili. ");
INSERT INTO nww_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Hino kakibhegha mundu yumo akwo ku Yelusalemu lihina lyake Simoni, mwene kakighatughila ghakaghapala Chapanga na kakibhegha ntundamila Chapanga, na kakibhegha pakighulindila kwa upalo nkulu ulopoho ghwa Akaisilaeli. Na Nhuki ghwa Chapanga kakibhegha pakinnyonjokeha mwoyo. ");
INSERT INTO nww_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nhuki ghwa Chapanga kakinlaghila kukita kaahwegha ng'obhe mbaka kammone Kilisito ywakabhaghulitwe na Bambo Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ndo, Nhuki ghwa Chapanga kakinlongoha Simoni kuyingila Mukitutubhi kya Chapanga. Malia na Yosefu paanng'eghite Yesu Mukitutubhi kya Chapanga kuntendela handa muyibheghite hitohe hya malaghilo gha Musa. ");
INSERT INTO nww_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ndo Simoni kakintola mwana mumabhoko ghake na kakinnonela kwakya Chapanga, pakilongela, ");
INSERT INTO nww_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Hinu Bambo, ghulihotola lilagho lyako ndo ghunlekekehe nbhandwa ghwako kaghende kwa uhihimilo. ");
INSERT INTO nww_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kiyaha kwa mehu ghangu nummona Nlopohi. ");
INSERT INTO nww_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ghuunhaghulite kabheghe Nlopohi ghwa bhandu bha milima hyoha. ");
INSERT INTO nww_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mwene kaabhegha lubhwelu lwa kuang'aliha bhandu bhaabheghite ng'obhe Ayahudi bhanmanye Chapanga, na ukulu kwa bhandu bhako Isilaeli.” ");
INSERT INTO nww_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ndo Yosefu na Malia bhakikangacha mihalo yila yakalongilite Simoni kwa kya aywo mwana. ");
INSERT INTO nww_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ndo Simoni kakianonela na kakinng'ombela Malia maghwake yula mwana, “Mwana ayu katabhegha nhokolo ghwa kuahobheha bhandu, na kuahyuha bhandu atangalo Muakaaisilaeli, mwene katabhegha naho yakulemwa na bhandu atangalo. ");
INSERT INTO nww_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Habhu mahwacho gha bhandu atangalo ghabhegha pa kindandabhanji, na kwa ghwenga lihingila handa kikechelo lyakuhoma mu mwoyo ghwako.” ");
INSERT INTO nww_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kakibhegha mbuye yumu nndala nng'ohi muno, lihina lyake Ana, biti Fanueli ywa likabila lya Asheli. Kakitolelwagha na kakitama na nnume ghwake ngungwa saba ndo nnume ghwake kakihwegha. ");
INSERT INTO nww_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Mwene kakibha nndala nnekwa na kakibhegha na ngungwa mbinda mabhoko nane na ncheche. Aywo kakibhukagha ng'obhe Mkitutubhi kya Chapanga pakilo ebu pamuhi pakantumikila Chapanga, kunu pakilikunga na kuyupa. ");
INSERT INTO nww_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Lisaa lila lila, Ana kakihika kakiyanda kuntika na kunnumba Chapanga na kakighomba mihalo ya aywo mwana, kwa bhandu bhoha bhaulindilite ukombohi ghwa Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yosefu na Malia paayomolite kutenda mihalo hyoha ya malaghilo gha Bambo, bhakibhuya kukitami kyabhe kya Nasaleti akwo Galilaya. ");
INSERT INTO nww_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwana yula kakikula na kuyonjokoheka makakala na pakimemekehwa mahala na ghumaha ghwa Chapanga ghukibhegha papamu naywo. ");
INSERT INTO nww_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kila ngungwa Yosefu na Malia bhakighendagha Kuyelusalemu kukikubhukubhu kubhu kya Pasaka. ");
INSERT INTO nww_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu pakabheghite na ngungwa mbinda mabhoko yimo na ibhili bhakighenda ku chekwa handa muyibheghite hitohe hyabhe. ");
INSERT INTO nww_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Paayomolite kikubhukubhu kubhu, Yosefu na Malia paabheghite mukubhuya ukaya, mwana ghwabhe Yesu kakihighala Kuyelusalemu. Peni abheli bhake bhakimanya ng'obhe. ");
INSERT INTO nww_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bhene bhakihwacha kukita kakibhegha mumwanja papamu na bhandu bhangi, bhakighenda mwanja ghwa linjubha lya nyima ndo bhakiyanda kumpalaha nkati ya alongo na aghanja bhabhe. ");
INSERT INTO nww_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kiyaha bhakimmona ng'obhe, ndo bhakibhuya ku Yelusalemu ngati anpalahe. ");
INSERT INTO nww_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Linjubha lya ndatu bhakimmona mu Kitutubhi kya Chapanga kakitama pakati ya ahunda bha malaghilo pakiayihwa na kuakonyekeha makonyo. ");
INSERT INTO nww_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bhoha bhaannyihwite bhakikangacha mahala ghake na mayango ghakaayangite. ");
INSERT INTO nww_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Yosefu na Malia paammonite Yesu bhakikangacha muno, maghwake kakinkonya, “Mwana ghwangu, bhuli ghungututenda naha? Nnole nenga na tate ghwako tungukupalaha kwa bhwaghalili ngulu.” ");
INSERT INTO nww_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesu kakiayanga, “Yibhegha bhuli mungumbalaha? Mukimanya ng'obhe kukita yingungwiliha kutama Mukitutubhi kya tate ghwangu?” ");
INSERT INTO nww_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Peni bhene bhakimanya ng'obhe fwambulo ya lila lilagho lyakaaghombilite. ");
INSERT INTO nww_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ndo kakighenda papamu na bhene mbaka Kunasaleti, naywo Yesu kakiayitikila kwa mihalo hyoha. Maghwake kakighendelela kukulungwa mumwoyo malagho agha ghoha. ");
INSERT INTO nww_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Naywo Yesu kakikula mumahala na utandamaho, ghumaha ghwa Chapanga ghukibhegha naywo na kakianoghea bhandu bhoha. ");
INSERT INTO nww_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mungungwa ya mbinda mabhoko yimo na nhano ya utabhala ghwa mutwa nkulu ghwa Akaaloma Tibelio, Pontio Pilato pakabheghite ntabhala ghwa Yudea, na Helode kakibhegha mutwa ghwa Galilaya, na Filipo nnongo ghwake kakibha ntabhala ghwa nnima ghwa Itulea na Tilakoniti, na Lisania kakibha ntabhala ghwa Abilene, ");
INSERT INTO nww_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","na Anasi na Kayafa bhakibha Andundame akulu ghwa Chapanga, ndo mumanjubha agho lilagho lya Chapanga likinhikila Yohane mwana ghwa Sakalia akwo ku kibhala. ");
INSERT INTO nww_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ndo Yohane kakighenda munnima ghwoha mumbwegha ya lukemba lwa Yoludani, pakalandamiha ubatiso ghwa kulipetula na kummuyila Chapanga, ngati Chapanga kabhalekekehe ulemwa ghwabhe. ");
INSERT INTO nww_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Handa muyityekitwe mukitabho kya Mbuye ghwa Chapanga ywaakemitwe Isaya, “Mundu kangukema kuhuma kukibhala, ‘Muyitendekehe njila ya Bambo, muyighololehe ndyangilo yake. ");
INSERT INTO nww_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Luluchi lwoheli lwa memekehwa, hitumbi hyabhegha telelele, na njila yinakupimbitala yaghololehwa panamigangalabhu patabhikwa maha. ");
INSERT INTO nww_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na bhandu bhoha bhaabheghite na mibhili bhataghubhona ulopoho ghughugheghitwe na Chapanga.’ ” ");
INSERT INTO nww_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ndo Yohane kakilughombela lula lumati lwa bhandu, lunhikilite ili kabhabatise, “Mwenga kibheleko kya liyoka, ndo ghani aywo ywakaakanikihite ngati mukibhutuke kiyaghabhu kiipala kuhika? ");
INSERT INTO nww_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Hinu ndendelo hyenu yibhe tela na kulipetula kwa mabhene, hinu nkotoke kuhwacha kukita Chapanga kataakingama handa pa mulikwina kukita hukulu ghwenu ndo Abulahamu. Kulyaghila nungubhaghombela hoto, Chapanga kanamakakala gha kughatendendekeha maganga agha ghabhe bhana bha Abulahamu. ");
INSERT INTO nww_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Habu, libhaghu libhegha kala mungiya ya nkongo, na nkongo ghwoheli ghula ghwanga kupapa mapambiko gha maha, ghwadumulighwa na kutaghwa mu mwoto.” ");
INSERT INTO nww_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Lula lumati lwa bhandu lukinkonya, “Hinu tutende niki?” ");
INSERT INTO nww_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohane kakiayanga, “Yula ywakabheghite na maghwanda mabhili kakanpeghe yula ywakabheghite nalyo ng'obhe, na yula ywakabheghite na hilyo kakatende ubhwabhu abhu!” ");
INSERT INTO nww_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Asumula sumu nabho bhakinhikila ngati kabhabatise, nabho bhakinkonya “Nhunda na twenga tutende niki?” ");
INSERT INTO nww_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Kakiayanga, “Nkotoke kutola nyonjokeho ya sumu yiilaghilitwe.” ");
INSERT INTO nww_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Amoo bha amachonda nabho bhakinkonya, “Bhuli na twenga yingutunogha tutende niki?” Kakiaghombela, “Nkotoke kutola mbiya kwa ywohele kwa makakala na ubhwabhu abhu nkotoke kunkokela ywohele kwa uhwangi, ngati nnyukutwe na hupu hyenu.” ");
INSERT INTO nww_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Bhandu bhakihyubhalila kilibhi kimoo, hinu bhakiyanda kulikonya mu mwoyo yabhe ya kya Yohane kukita pangi ywombe ndo Kilisito ywakahaghulitwe na Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Hinu Yohane kakiayanga pakiaghombela, “Nenga nungaabatisa kwa machi peni katahika yunamakakala kupitingana kwa nenga, yiteghekwa ng'obhe nenga hokame na kulegheha ngoyi hya makobasi ghake. Mwene kataabatisa kwa Nhuki ghwa Chapanga na kwa mwoto. ");
INSERT INTO nww_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ywombe kabhegha na kipalo kyake mumabhoko ghake, kabhegha kala kukilima kibhanja kya kuyebheha mbunje hyaki yibheghe ya nyanyi na kuyibhika muluhanja lwake, na mayeyele kataghayocha mumwoto ghwanga hima.” ");
INSERT INTO nww_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Hinu kwa kuayupa muno na kwa makinyo mangi matangalo Yohane kakialandamiha bhandu Nhalo ghwa Maha. ");
INSERT INTO nww_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Mbole yake Yohane pakanlakalilite mutwa Helode yakya kunpoka Helodia nndala ghwa nnongo ghwake na kuntenda kabhe ghwake, na mahakataho ghoha ghakaghatendite, ");
INSERT INTO nww_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Mbole Helode kakihangangana agha ghoha, kakimmopa Yohane ku kibhopo. ");
INSERT INTO nww_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mbole ya bhandu bhoha kubatiswa, Yesu naywo kakibatiswa, naywo pakabheghite mukunyupa Chapanga, kunani kwa Chapanga kukiyughuka. ");
INSERT INTO nww_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Na Nhuki ghwa Chapanga kakihuluka kwa mmili handa ghwa ngunda, na lilobhe likiyihwanika kuhuma kunani kwa Chapanga palilongela, “Ghwenga ndo mwana ghwa nenga Chapanga, ghunughupala, nnyelelwa na ghwenga muno.” ");
INSERT INTO nww_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu kakibhegha na Ngungwa mbinda mabhoko ndatu pakayandite lihengo lyake, na bhandu bhakihwacha kukita kakibha mwana ghwa Yosefu, mwana ghwa Heli, ");
INSERT INTO nww_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","na Heli kakibhegha mwana ghwa Matati, na Matati kakibhegha mwana ghwa Lawi, na Lawi kakibhegha mwana ghwa Meliki, na Meleki kakibhegha mwana ghwa Yanai, na Yanai kakibhegha mwana ghwa Yosefu, ");
INSERT INTO nww_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","na Yosefu kakibhegha mwana ghwa Matatia, Matatia kakibhegha mwana ghwa Amosi, na Amosi kakibhegha mwana ghwa Naumu, na Naumu kakibhegha mwana ghwa Esili, na Esili kakibhegha mwana ghwa Nagai, ");
INSERT INTO nww_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai kakibhegha mwana ghwa Maati, na Maati kakibhegha mwana ghwa Matatia, na Matatia kakibhegha mwana ghwa Semeini, na Semeini kakibhegha mwana ghwa Yoseki, na Yoseki kakibhegha mwana ghwa Yoda, ");
INSERT INTO nww_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda kakibhegha mwana ghwa Yoanani, na Yoanani kakibhegha mwana ghwa Lesa, na Lesa kakibhegha mwana ghwa Selubabeli, na Selubabeli kakibhegha mwana ghwa Shealitieli, na Shealitieli kakibhegha mwana ghwa Neli, ");
INSERT INTO nww_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","na Neli kakibhegha mwana ghwa Meliki, na Meliki kakibhegha mwana ghwa Adi, na Adi kakibhegha mwana ghwa Kosamu, na Kosamu kakibhegha mwana ghwa Elimadamu, na Mwana ghwa Eli, ");
INSERT INTO nww_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eli kakibhegha mwana ghwa Yoshua, na Yoshua kakibhegha mwana ghwa Elieseli, na Elieseli kakibhegha mwana ghwa Yolimu, na Yolimu kakibhegha mwana ghwa Matati, na Matati kakibhegha mwana ghwa lawi, ");
INSERT INTO nww_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","na Lawi kakibhegha mwana ghwa Simoni, na Simoni kakibhegha mwana ghwa Yuda, na Yuda kakibhegha mwana ghwa Yosefu, na Yosefu kakibhegha mwana ghwa Yonamu, na Yonamu kakibhegha mwana ghwa Eliakimu, ");
INSERT INTO nww_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","na Eliakimu kakibhegha mwana ghwa Melea, na Melea kakibhegha mwana ghwa Mena, na Mena kakibhegha mwana ghwa Matata, na Matata kakibhegha mwana ghwa Natani, na Natani kakibhegha mwana ghwa Daudi, ");
INSERT INTO nww_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daudi kakibhegha mwana ghwa Yese, na Yese kakibhegha mwana ghwa Obedi, na Obedi kakibhegha mwana ghwa Boasi, na Boasi kakibhegha mwana ghwa Salimoni, na Salimoni kakibhegha mwana ghwa Nashoni, ");
INSERT INTO nww_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","na Nashoni kakibhegha mwana ghwa Aminadabu, na Aminadabu kakibhegha mwana ghwa Adimini, na Adimini kakibhegha mwana ghwa Alini na Alini kakibhegha mwana ghwa Hesiloni, na Hesiloni kakibhegha mwana ghwa Pelesi, Pelesi kakibhegha mwana ghwa Yuda, ");
INSERT INTO nww_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda kakibhegha mwana ghwa Yakobu, na Yakobu kakibhegha mwana ghwa Isaka, na Isaka kakibhegha mwana ghwa Abulahamu, na Abulahamu kakibhegha mwana ghwa Tela, na Tela kakibhegha mwana ghwa Naholi, ");
INSERT INTO nww_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naholi kakibhegha mwana ghwa Salugi, na Salugi kakibhegha mwana ghwa Leu, na leu kakibhegha mwana ghwa Pelegi, na Pelegi kakibhegha mwana ghwa Ebeli, na Ebeli kakibhegha mwana ghwa Sala, ");
INSERT INTO nww_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","na Sala kakibhegha mwana ghwa Kenani, na Kenani kakibhegha mwana ghwa Alifakisadi, na Alifakisadi kakibhegha mwana ghwa Shemu, na Shemu kakibhegha mwana ghwa Nuhu, na Nuhu kakibhegha mwana ghwa Lameki, ");
INSERT INTO nww_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","na Lameki kakibhegha mwana ghwa Mesusela, na Mesusela kakibhegha mwana ghwa Enoki, na Enoki kakibhegha mwana ghwa Yaledi, na Yaledi kakibhegha mwana ghwa Mahalaleli, na Mahalaleli kakibhegha mwana ghwa Kainani, ");
INSERT INTO nww_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainani kakibhegha mwana ghwa Enoshi, na Enoshi kakibhegha mwana ghwa Seti, na Seti kakibhegha mwana ghwa Adamu, na Adamu kakibhegha mwana ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Pakabhuyite kuhuma kulukemba lwa Yoludani Yesu pakibhegha na makakala makulu gha Nhuki ghwa Chapanga na aywo Nhuki kakinlongoha ku kibhala, ");
INSERT INTO nww_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","akwo Nchipila kakinng'eha mu manjubha mbinda mabhoko ncheche. Mu manjubha agho ghoha kakilyegha ng'obhe kyohele, mbole ya agho manjubha yikinbhina njala. ");
INSERT INTO nww_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ndo Nchipila kakinng'ombela, “Handa ghwenga ndo Mwana ghwa Chapanga, ghughakwilikihe maganga agha ghabhe mangate.” ");
INSERT INTO nww_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu kakinnyanga paakinng'ombela, “Matyeko gha Chapanga ghangulongela, ‘Mundu katatama ng'obhe kwa mangate ghweka chake.’ ” ");
INSERT INTO nww_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mbole Nchipila kakinghegha mbaka kukitumbi kitandamaho munu na kakimmoneha ghubhutwa nhanganganiko ghwa nnima ghoha payimo. ");
INSERT INTO nww_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nchipila kakinng'ombela, “Ndaghutenda ghubheghe nkulu ghwa milima ayi hyoha na ghwatikilwa munu, kiyaha yibhegha mumakakala ghangu na nenga ndanpegha ywohele handa mumbalite. ");
INSERT INTO nww_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Handa ghwanndundamila, hilibhi hyoha yabhegha hyako.” ");
INSERT INTO nww_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu kakinnyanga, “Yityekwa mu matyeko mang'anyimo, ‘Ghundundamile Bambo Chapanga ghwako na ghundumikile kya kunhokamila mwene ghweka chake.’ ” ");
INSERT INTO nww_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Mbole Nchipila kakinnghegha mbaka ku Yelusalemu, na kakimmika unani ghwa nnala ghwa kitutubhi kya Chapanga, kakinng'ombela, “Handa ghwenga ndo Mwana ghwa Chapanga, ghulitaghe pahi, ");
INSERT INTO nww_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kiyaha yityekwa mumalembo gha Chapanga, ‘Kataghakwilikiha mahoka bha Chapanga ili akukingikihe.’ ");
INSERT INTO nww_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kangi, ‘Bhatakutola kwa mabhoko ghabhe ghukotoke kulikubhala kighulu kyako mu liganga.’ ” ");
INSERT INTO nww_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu kakinnyanga, “Yityekwa mumatyeko gha Chapanga, ‘Ghukotoke kunng'eha Bambo Chapanga ghwako.’ ” ");
INSERT INTO nww_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nchipila pakayomolite kunng'eha Yesu, kakinleka mbaka ng'ebu yingi. ");
INSERT INTO nww_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Mbole Yesu kakibhuya mbaka Kugalilaya, pakibha na likalama lya Nhuki ghwa Chapanga, na mihalo yake yikikwila mu mbande hyoha ya milima ya ugheghela. ");
INSERT INTO nww_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kakiyanda kuhunda muhitutubhi hya kukonganila Akaayahudi na bhoha bhakintika. ");
INSERT INTO nww_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu kakighenda Kunasaleti apwo pakalelilitwe, na Mulinjubha lya kupumulila kakighenda Kukitutubhi kya kukonganila handa muyibheghite kitohe kyake na kakiyima ngati kasomi malembo mang'anyima kwa lilobhe likulu, ");
INSERT INTO nww_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","kakikamuhwa kitabho kya mbuye ghwa Chapanga ywakakemitwe Isaya, kakikiyughula na kakibhona pa patyekwite, ");
INSERT INTO nww_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Nhuki ghwa Chapanga kabhegha nkati ya nenga, kiyaha kanhaghula na kundyeka mahuta ili nubhaghombele mihalo ya maha akapukwa. Bambo kannaghila kualandamiha abhopwa kuhughulighwa kwabhe na bha nga kubhona apati kubhona kangi, na kubhalopoha bha abheghite mu kimbamanda ");
INSERT INTO nww_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","na kulandamiha kukita manjubha ghahika, apwo Bambo kataalopoha bhandu bhake.” ");
INSERT INTO nww_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Mbole kakikigubika kitabho, kakikibhuyiha kwa nndumitumi na kakitama. Na mehu gha bhaabheghite mukitutubhi kya kukonganila ghakinlolekeha mwene. ");
INSERT INTO nww_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ndo kakiyanda kuaghombela, “Malembo agha ghatulukila lelo, pamughayihwite.” ");
INSERT INTO nww_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bhoha bhaayihwite bhakiyimiha na kukita bhakinoghelwa naywo na kughakangacha malagho ghake paghabheghite gha maha, paakikonyana, “Ayu ndo mwana ghwa Yosefu ng'obhe?” ");
INSERT INTO nww_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu kakiaghombela, “Kulyaghila maaghomba ndambulo ayi, ‘Ng'anga ghulilamihe ghumwene.’ Kangi maalongela, ‘Mihalo yila tuyiyihwite kukita ghukiyitenda akwo Kukapelinaumu, ghuyitende na apa kukitami kyako ghumwene.’ ” ");
INSERT INTO nww_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesu kakighendelela kulongela, “Kulyaghila nunguaghombela, Kahone mbuye ghwa Chapanga ywakakingamwa maha mu kitami kyake mwene. ");
INSERT INTO nww_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Peni ayi ndo hoto, pakibha na adala alekwa atangalo mu Isilaeli mu manjubha gha mbuye ghwa Chapanga akemitwe Eliya, pakabhopitwe kunani kwa Chapanga kwa ngungwa ndatu na mwehi sita na pakibha na njala ngulu munnima ghwoha. ");
INSERT INTO nww_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Hata habhu! Eliya kakilaghilwa ng'obhe kwa yumoo ywa adala alekwa abho, ngati nga kwa nndala nlekwa yumo ghwa Seleputa munnima ghwa Sidoni. ");
INSERT INTO nww_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kangi akibhegha bhana maloha atangalo Munnima ghwa Isilaeli, mumakachu gha mbuye ghwa Chapanga ywakakemitwe Elisha, peni kakibhegha ng'obhe yumoo yungi ywakaghululitwe, ngati nga Naamani mundu ghwa Kushamu.” ");
INSERT INTO nww_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bhandu bhoha mu kitutubhi kila kya kukonganila Akaayahudi paayihwite mihalu ayi bhakikalala muno. ");
INSERT INTO nww_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ndo bhakiyima na bhakimmuha panji ya kitami kila, kiichengitwe kunani ya kitumbi, ngati antaghe pahi mu ngende ya kitumbi akyo. ");
INSERT INTO nww_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Peni mwene kakikinda pakati yabhe na kakighenda. ");
INSERT INTO nww_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mbole Yesu kakighenda ku kitami kya Kapelinaumu, nnima ghwa ku Galilaya na mu linjubha lya kupumulila kakibhegha mu kuhunda. ");
INSERT INTO nww_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Bhandu bhakikangacha muno na mahundo ghake, kiyaha malagho ghake ghakibha na makakala. ");
INSERT INTO nww_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mukila kitutubhi kya kukonganila kukibha na mundu ywakakwehwitwe na lindilu linyakali, kakichobha kyobho pakilongela, ");
INSERT INTO nww_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Tubhegha na niki na ghwenga! Yesu ghwa Kunasaleti? Bhuli ghuhika kutukanjaghana? Nungughumanya ghwenga ndo ghuubhaghulitwe kwakya Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ndo Yesu kakilikwilikiha lila lindilu pakalongela, “Ghunyamale na ghummuke mundu aywo!” Lila lindilu likintagha pahi muulongolo ghwa bhoha na likimmuka kya nga kunkanjaghana. ");
INSERT INTO nww_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bhandu bhoha bhakikangacha na bhakighombana, “Ali ndo likalama lya kya bhuli? Kiyaha kwa makakala kangughakwilikiha mandilo ghabhuke, nagho ghangubhuka!” ");
INSERT INTO nww_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mihalu yake Yesu yikikwila kwoha ku nnima ghula. ");
INSERT INTO nww_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu kakibhuka kukitutubhi kya kukonganila Akaayahudi na kakighenda kulubhagha lwa Simoni. Ndo akwo kakimmona maghwa nndala ghwa Simoni kananhehemela muno, nabho bhakinnyupa Yesu kantange. ");
INSERT INTO nww_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ndo Yesu kakiyima ugheghela na mwene na kakighukwilikiha ghula nhehemela, naghwo ghukinleka, kamu yula nndala kakiyima na kuyanda kuakeyela. ");
INSERT INTO nww_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pambungamihe, bhandu bhoha bha abheghite na atamwa nhanganganiko bhakiaghegha kwa Yesu, naywo kakiayabhikila mabhoko ghake yumoo mbole ya yungi na kakialamiha. ");
INSERT INTO nww_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nagho mandilu ghakialeka bhandu atangalo, paghabhukite ghakiyobha kyobho paghalongela, “Ghwenga ndo Kilisito mwana ghwa Chapanga!” Peni Yesu kakighakwilikiha na kughakanikiha bhakotoke kulongela, kiyaha bhakinmanya kukita ywombe ndo Kilisto ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kilabho yake malabhila, Yesu kakighenda pa kya kighweka, bhandu atangalo bhakinpalaha kwoha, na paammonite, bhakipala kakotoke kabhuka kwabhe. ");
INSERT INTO nww_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Peni mwene kakiaghombela, “Yingunnogha ngaaghombele bhandu Nhalo ghwa Maha ghwa Ghubhutwa ghwa Chapanga muhitami hingi, kiyaha Chapanga kannaghila kwakya nhalu aghu.” ");
INSERT INTO nww_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Naywo kakighendelela kulandamiha mu hitutubhi hya kukonganila Akaayahudi nnima ghwa Yudea. ");
INSERT INTO nww_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Linjubha limu Yesu pakabheghite kumbwegha ya lihibha lya Genesaleti ubhwabhu lingumanyika handa lihibha Galilaya, na bhandu atangalo bhakiyukana kuntindila ngati bhayihwe lilagho lya Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ndo kakiyibhona mibhwato mibhili pambwegha ya lihibha yikilekwa apo na aghomeha homba bha abheghite mukutandambuaha njaho hyabhe. ");
INSERT INTO nww_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kakiyingila mughumoo bhwato ghuubheghite ghwa Simoni, na kakinnyupa Simoni kakanheghelehe mumachi kutali kya mandina kuhuma kuluhingo, mbole kakitama mubhwato aghwo na kakiyanda kuluhunda lula lumati lwa bhandu. ");
INSERT INTO nww_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pakayomolite kuahunda, Yesu kakinng'ombela Simoni, “Hinu ghuhole bhwato ghwako mbaka mu machi njulwa ya lihibha mbole ghuyihuluhe njaho hyenu na makaghomehe homba.” ");
INSERT INTO nww_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ndo Simoni kakinnyanga, “Bambo, tukitenda lihengo lya kutopa kilukilu ndaa! Na tukighomeha ng'obhe kyoheli. Peni kwa lilagho lyako nda huluha njaho.” ");
INSERT INTO nww_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Mbole ya kuhuluha njaho, bhakighomeha homba bha mahele muno, mbaka njaho hyabhe yikiyanda kulakatuka. ");
INSERT INTO nww_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Hinu ndo bhakiakema kunu paakiatendela naho kwa mabhoko aghomeha bhangi bha abheghite mubhwato ghungi ahike kuatangatila. Bhakihika na bhakimemekeha homba mibhwato hyoha mibhili mbaka yikiyanda kudibala. ");
INSERT INTO nww_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoni Petili pakabhonite aghwo ghaabwitukilite kakighwegha mumaghulu gha Yesu na kakinng'ombela, “Bambo ghubhuke kwa nenga, kiyaha nenga nnemwa!” ");
INSERT INTO nww_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoni na aghomeha ayake bhakikangacha muno kwa kya bhala homba bha mahele bhaabhamokolite. ");
INSERT INTO nww_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ubhwabhu abhu ayake Yakobu na Yohane, bhana bha Sebedayu bhakikangahwa munu. Ndo Yesu kaking'ombela Simoni, “Ghukotoke kuyoghopa, kiyaha kutandila hinu ghwanngheghela bhandu handa aghomeha homba paaghegha homba muhitutubhi hyabhe.” ");
INSERT INTO nww_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ndo bhakiyongeha mibhwato yabhe kuluhingo, na akileka hyoha hyaabheghite naywo na bhakintughila Yesu. ");
INSERT INTO nww_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu pakabheghite kukitami kimo, mundu yumu yuna maloha mummili ghwoha kakinhikila. Pakammonite Yesu kakighwegha makukama na kakinnyupa Yesu pakilongela, “Bambo, paghupala ghwaahotola kunnamiha ili ng'ululike.” ");
INSERT INTO nww_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu kakikigholoha kibhoko kyake na kakinnyabhika yula mundu, mbole kakinng'ombela, “Ningupala ghughululike!” Kamu kakilama ghala maloha. ");
INSERT INTO nww_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ndo Yesu kakinkwilikiha, “Ghukotoke kunng'ombela mundu ywohele, peni ghughende kwa ndundame ili kakayimihe kukita ghuyoghwa na ghukatule matulo ghakalaghilite Musa ngati bhandu amanye kukita ghughululwa.” ");
INSERT INTO nww_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Peni mihalo ya Yesu yikiyonjokeheka kuchweha mbande hyoha na bhandu lumati lumati bhakikwemukana kunnyihwa na kulamihwa matamwa ghabhe. ");
INSERT INTO nww_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Peni mwene pipipi kakighenda mu kumanyahi, akwo kakighenda kunnyupa Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Linjubha limu Yesu pakabheghite pakihunda, na apwo pakibhegha amoo Akaafalisayo na Ahunda bha malaghilo, kuhuma kuhijiji hya Galilaya na kuhuma Kuyudea na Yelusalemu. Na likalama lya Bambo ghakibhegha na Yesu kwakya kualamiha atamwa. ");
INSERT INTO nww_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bhakihika bhandu bhaanpapite ntamwa ghwa ulelebhalo ghwa mmili muulili. Bhakilitumba kunnyingila unyumba ngati ammike mu ulongolo ghwa Yesu. ");
INSERT INTO nww_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Peni bhakilepelwa kunnyingila mukitutubhi kila kubhukana na lumati lwa bhandu. Hinu bhakihubhuka kulunyakaa na bhakimatula himoo hipalamande hya hipumbulu na bhakinhuluha aywo ntamwa ghwa ulelebhalo mulikahe lyake pakati ya lula lumati lwa bhandu pakabheghite Yesu. ");
INSERT INTO nww_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu pakabhoniti kukita bhanguhyubhalila, kakinng'ombela yula ntamwa, “Ghanja, ghulekekehwa ulemwa ghwako.” ");
INSERT INTO nww_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Akaafalisayo na bhala ahunda bha malaghilo bhakiyanda kukonyana kya ufyangu, “Ndo ghani aywo ywakakambukite mihalo ya kunkundula Chapanga? Kahone mundu yuna makakala gha kulekekeha ulemwa maha nga Chapanga ghweka chake.” ");
INSERT INTO nww_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu kakighamanya mahwacho ghabhe ndo kakiakonya, “Kiyaha niki munguhwacha habhu mu myoyo yenu? ");
INSERT INTO nww_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Hinu lyoki lya nga unonopo, kunng'ombela mundu ayu ‘Ghulekekehwa ulemwa ghwako’ ebu kulongela ‘Ghuyime ghughende?’ ");
INSERT INTO nww_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Hinu, mbala mmanye kukita nenga Mwana ghwa Mundu megha na makakala gha kulekekeha ulemwa mu nnima aghu.” Habhu kaking'ombela mundu yula yunaulelebhalo, “Nungukughombela ghuyime, litole likahe lyako na ghughende ku lubhagha lwako.” ");
INSERT INTO nww_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kamu mundu aywo kakiyima kunu paankilola, kakitola likahe lyake na kakighenda kulubhagha lwake kunu pakintika Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bhandu bhoha bhakikangacha na kuyingilwa lyogha, na bhakintika Chapanga, paakikilongela, “Lelo tuyibhona mihalo ya mihabho.” ");
INSERT INTO nww_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mbole ya agha, Yesu kakibhuka na kakinmmona nsumula sumu yumu lihina lyake Lawi, pakitama mukitutubhi kya kukamuha sumu. Yesu kakinng'ombela, “Ghundughile.” ");
INSERT INTO nww_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Naywo Lawi kakighaleka ghoha ghakabheghite nagho na kakintughila. ");
INSERT INTO nww_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mbole Lawi kakintendela Yesu chekwa ngulu kulubhagha lwake, nalwo lumati lukulu lwa asumula sumu na bhandu bhangi bhakibha mukulyegha papamu nabho. ");
INSERT INTO nww_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Akaafalisayo na ahunda bha malaghilo bhakiakukulikila ahundwa bha Yesu, pa akilongela, “Kiyaha niki mungulyegha na kunywegha papamu na asumula sumu na bhana ulemwa bhangi?” ");
INSERT INTO nww_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu kakiayanga, “Bha nga utamwa bhanpala ng'obhe nng'anga ngati atamwa. ");
INSERT INTO nww_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ubhwabhu abhu hika ng'obhe kuakema bhandu bhaaghatughila ghakaghapala Chapanga ngati alemwa bhalipetule.” ");
INSERT INTO nww_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Amoo bhandu bhakinng'ombela Yesu, “Ahundwa bha Yohane na ahundwa bha Akaafalisayo pipipi angulikunga na kuyupa, peni kiyaha niki ahundwa bhako bhangughendelela kulyegha na kunywegha?” ");
INSERT INTO nww_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu kakiayanga, “Hinu maahotola bhuli kuatenda ahenja bha yunakutolela nndala bhalikunge pa abheghite papamu na aywo ntolela nndala pa ludamu lwa chekwa? ");
INSERT INTO nww_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Peni linjubha lyahika kwa mundu yunakutolela kubhuhwa, apa ndo bhatalikunga.” ");
INSERT INTO nww_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu kakiapegha ndambulo ayi, pakiaghombela, “Kahone bhandu bha kupabhika kipabhiko kya hyono na kutalasa mulikama. Handa paakatenda naha bhaakachula lila lighwanda lya hyono na kila kipabhiko kyalandana ng'obhe na lila likama. ");
INSERT INTO nww_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kahone mundu ywakabhikiti difwai hya hyono munhako ghwa liyula lihakalite. Handa katatenda naha ayo difwai ya hyono yitakibatulanga akyo nhako ghwa liyula na kuyitika pahi na nhako ghwa liyula kya hanganganika. ");
INSERT INTO nww_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Difwai ya hyono yibhikwagha mu nhako ghwa liyula lya hyono. ");
INSERT INTO nww_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na kahone mundu ywakapalite difwai ya hyono mbole ya kunywegha yila ya maha, kiyaha katalongela, ‘Mbaha yila ya makachu.’ ” ");
INSERT INTO nww_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mulinjubha limo lya kupumulila, Yesu na ahundwa bhake bhakibhegha mukutyanga mumighunda ya ngano. Ahundwa bhake bhakighatunyula mahonjo gha ngano na bhakipulula mbunje hyaki mumabhoko ghabhe na kulyegha. ");
INSERT INTO nww_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Amoo bha Akaafalisayo bhakiakonya, “Kiyaha niki mungughatughila ng'obhe malaghilo na mungutenda ghaakanikihitwe Mulinjubha lya kupumulila?” ");
INSERT INTO nww_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu kakiayanga, “Mwenga munasoma ng'obhe pakatendite Daudi na ayake pa abheghite na njala? ");
INSERT INTO nww_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Bhuli Daudi kakighatughila ng'obhe malaghilo pala pakayingilite Mukitutubhi kya Chapanga, na kuyitola yila mangate yibhuhitwe kwakya Chapanga, na kakiapegha na ayake, mangate ghaanoghwa kulyeghwa na andundame ghweka chabhe?” ");
INSERT INTO nww_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Habhu Yesu kakiaghombela, “Nenga Mwana ghwa Mundu ndo Bambo ghwa Linjubha lya Kupumulila.” ");
INSERT INTO nww_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mu Linjubha lingi lya Kupumulila Yesu kakiyingila mu kitutubhi kya kukonganila Akaayahudi na kakihunda bhandu, na akwo kakibhegha mundu yumo yuna ulelebhalo ghwa kibhoko kyake kya nnilo. ");
INSERT INTO nww_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Akaafalisayo na ahunda bha malaghilo gha Musa bhakipalaha kihokonyo kya kunkokelela Yesu, na ndo bhakilindila abhone handa kaanlamiha mundu Linjubha lya Kupumulila. ");
INSERT INTO nww_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Peni Yesu kakighamanya mahwacho ghabhe na kakinng'ombela yula mundu, “Ghuyime na ghuhike ghuyime pakati!” Yula mundu kakighenda kukiyima pakati yabhe. ");
INSERT INTO nww_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ndo Yesu kakiaghombela bhala ahunda bha Malaghilo na Akaafalisayo, “Nunguakonya mwenga, yingutukwiliha kughatughila ghoki mumalaghilo mu Linjubha lya Kupumulila? Kughatenda gha maha ebu gha mahakataho? Kulopoha na kulama ebu kuukanjaghana ubhumi?” ");
INSERT INTO nww_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesu kakialolekeha bhandu bhoha bhabheghite pala na ndo kakinng'ombela yula mundu, “Ghugholohe kibhoko kyako.” Naywo kakikigholoha kibhoko kyake nakyo kamu kikibha tela. ");
INSERT INTO nww_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Habhu bhombe bhakikalala munu, bhakighombana bhene kwa bhene lyoki lya kuntendela Yesu. ");
INSERT INTO nww_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mu manjubha agho Yesu kakighenda ku kitumbi kuyupa, na kakikilukiha akwo pakinnyupa Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pamalabhila kakiakema ahundwa bhake, na munkati yabhe kakiahaghula bhandu mbinda mabhoko yimo na abhili na ndo abho kakiakema andumitumi. ");
INSERT INTO nww_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simoni, yula Yesu ywakankemite Petili na Andelea nnongo ghwake Petili, Yakobu na Yohane na Filipo na Batulumayo, ");
INSERT INTO nww_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matayu na Tomasi na Yakobu mwana ghwa Alufayo na Simoni ywakakemitweghe Selote mundu ywakaghukomanilite nnima ghwake, ");
INSERT INTO nww_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda mwana ghwa Yakobu na Yuda Isikaliyote aywo ndo mbole kakibhagha nkiluka. ");
INSERT INTO nww_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu kakihuluka papamu na ahundwa bhake na bhakiyima pa telelele. Na apwo pakibhegha na ahundwa bhake atangalo na lumati lukulu lwa bhandu kuhuma mu mbande hyoha ya nnima ghwa Yudea na kitami kya Yelusalemu na kuhuma mu bwani ya hitami hya Tilo na Sidoni, ");
INSERT INTO nww_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","bhaahikite kunnyihwa na kulamihwa matamwa ghabhe. Bhala bhoha bhaabamanditwe na mandilo kakialamiha. ");
INSERT INTO nww_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bhandu bhoha bhakipala kunbyala, kiyaha likalama likibhegha lingummuka nkati yake na kualamiha bhandu bhoha. ");
INSERT INTO nww_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu kakialolekeha ahundwa bhake na kakilongela “Nnonelwa mwenga munmeghite makapukwa, kiyaha Ghubhutwa ghwa Chapanga ndo ghwenu. ");
INSERT INTO nww_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nnonelwa mwenga mummeghite na njala hinu, kiyaha mbole maayukuta, Nnonelwa mwenga mummeghite kililo hinu, kiyaha maaheka kwa uyelelo!” ");
INSERT INTO nww_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Nnonelwa mwenga bhandu paabhayaghabhalila, bhanmaghula na kualigha na kulilema lihina lyenu handa nhalo nhakataho, kwa kya nenga Mwana ghwa Mundu. ");
INSERT INTO nww_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Pamakachu apwo aghohi bhenu akiatendela ubhwabhu abhu ambuye ghwa chapanga. Hinu mihalu ayi payibwituka, nnyelelwe na kuhanga kwa kiheko, kiyaha lilumbo lyenu lyabhegha likulu kunani kwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Peni, npinguhi ghwa kyabhuli ghungualindila mwenga muubheghite na utopelo, na kiyaha hinu nnyonjokehwa mwoyo kala. ");
INSERT INTO nww_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Npinguhi ghwa kyabhuli ghungualindila mwenga muyukutite hinu, kiyaha maabhegha na njala. Kimmone mwenga mummeghite na kiheko hinu, kiyaha maakukulika na kulila.” ");
INSERT INTO nww_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Npinguhi ghwa kyabhuli ghwaabhalindila handa bhandu paabhatika, kiyaha aghohi bhabhe akiatika ambuye ghwa uhwangi ubhwabhu abhu.” ");
INSERT INTO nww_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Peni ninguaghombela mwenga bhaannyihwa, mubhapale amyanja bhenu. Mubhatendele gha maha bhala bhaabhakalalila. ");
INSERT INTO nww_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Munnyupe Chapanga abhanonele bhala bhaabhakotola mwenga na mubhayupile bhala bha abhatendela mahakataho. ");
INSERT INTO nww_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Handa Mundu kaghuhyatula likanja limo ghunpiluhile na lingi. Mundu pakatola lighwanda lyako ghunpeghe na lighwanda litandamaho bhubho. ");
INSERT INTO nww_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mundu pakakuyahika kilibhi na handa mundu kakupoka utopelo ghwako ghukotoke kupala kaghubhuyihile. ");
INSERT INTO nww_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mubhatendele bhangi handa bhula mpalite bhene abhatendele mwenga.” ");
INSERT INTO nww_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Handa pamuaapala bhala bhaabhapalite, maamokola lilumbo lyoki? Na bhana ulemwa anguapala bhaabhapalite. ");
INSERT INTO nww_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Hinu handa mungughatendela ghamaha bhala bha abhatendelite ghamaha ghweka chabhe, maamokola lilumbo lyoki? Na bhana ulemwa bhangutenda ubhwabhu abhu. ");
INSERT INTO nww_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kangi handa pamubhayahikila bhala mubhamanyite kukita bhatabhuyiha, maamokola lilumbo lyoki? Hata bhana ulemwa bhanguayahikila bhanaulemwa ayabhe paadumbila kubhuyihilwa. ");
INSERT INTO nww_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Peni mubhapale amyanja bhenu, mubhatendele ghamaha, mubhayahikile kyanga kudumbila kukita bhataabhuyihila kila kimubhayahikilite. Ndo litiko lyenu lyabhegha likulu, pantenda naha maabhegha handa payinoghela kutenda bhana bha Chapanga ywakabhegha unani mwa ghoha, kiyaha mwene ndo ghwa maha kwa bhandu bhangabhega na lilumbo na alemwa. ");
INSERT INTO nww_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mubhe na luhungu handa Tate ghwenu pakabheghite na lipyanda.” ");
INSERT INTO nww_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Nkotoke kuatosa bhangi, kiyaha Chapanga kataatosa mwenga. Nkotoke kulibhaya, kiyaha na mwenga maabhaywa. Nnekekehe, na mwenga maalekekehwa. ");
INSERT INTO nww_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Muakamuhe bhandu hilibhi, na mwenga maakamuhwa. Nteko ghwa kumemekehwa kumamatihwa na kuyukwa mbaka kuyitika, akyo ndo bhandu bhataabhuyiha mwenga. Kiyaha nteko ghughula ghula ghwa muatekela bhandu ndo maatekeghwa mwenga.” ");
INSERT INTO nww_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kangi kakiapegha ndambulo, “Ywanga kubhona katahotola bhuli kunlongoha ywa nga kubhona nnyake? Ng'obhe, bhoha abhili bhataghwegha mu lilindi. ");
INSERT INTO nww_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nhundwa kahone kunhotola nhunda ghwake, ngati yula ywakahotolite mahundo katahotola kubhegha handa nhunda ghwake.” ");
INSERT INTO nww_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Bhuli ghungululolekeha lukapi luubheghite mu liho lya nnongo ghwako na ghungubhona ng'obhe lutela luubheghite mu liho lyako mwene? ");
INSERT INTO nww_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ebu ghwa hotola bhuli kunng'ombela nnongo ghwako, ‘Nnongo ghuleke huti nulubhuhe lukapi luubheghite mu liho lyako,’ handa ghumwene ghungulubhona ng'obhe lutela mu liho lyako? Ghwenga nfyangu! Ghulubhuhe huti lutela mu liho lyako, ndo ghwabhona tela na ndo ghwahotola kulubhuha lukapi mu liho lya nnongo ghwako.” ");
INSERT INTO nww_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kahone nkongo ghwa maha ghupambikite mapambiko ghaahechukite, ebu nkongo nhakataho ghupambikite mapabhika gha maha. ");
INSERT INTO nww_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nkongo ghwoheli ghungumanyika kwa mapambiko ghake. Kiyaha bhandu bhangunuka ng'obhe mahuku mumihomi ebu sabibu mumihomanga. ");
INSERT INTO nww_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ubhwabhu abhu mumundu ghwamaha ghaahuma milando yamaha kuhuma luhanja lwa ghala ghaabheghite mumwoyo ghwake, na mumundu ghwa mahakataho ghaahuma mahakataho kuhuma mughala ghaamemite mumwoyo ghwake. Kiyaha mundu katakambuka kwa ngulu yake ghala ghamemite mu mwoyo ghwake.” ");
INSERT INTO nww_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Kiyaha niki mungunngema ‘Bambo Bambo,’ Na mwenga mungutenda ng'obhe ghala nighalaghilite? ");
INSERT INTO nww_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ndabhapegha ndambulo ya mundu yunakuhika kwa nenga na kuyihwa mihalo ya nenga na kuyitenda. ");
INSERT INTO nww_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Aywo ndo handa mundu ghwakachengite lubhagha, na kukumba pahi muno na kubhika kitamilo kya maganga mulutalabha. Ngumbwa ya machi yikihika, kamu machi ghakikituta kila kitutubhi peni kikihotolwa ng'obhe na machi, kiyaha kikichengwa unani mwa litalabha. ");
INSERT INTO nww_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Peni yunakuyihwa mihalo ya nenga na kutendekeha kata, ayo ndo handa mundu ywakachengite lubhagha unani mwalutupi kyanga kitamilo kya maganga unani mwa litalabha. Payihikite ngumbwa ya machi kila kitutubhi kamu kikighwegha na kuhaghunganika pechepeche.” ");
INSERT INTO nww_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Mbole pakayomolite kulongela malagho agha ghoha na bhandu paannyihwite kakiyingila ku kitami kya Kapelinaumu. ");
INSERT INTO nww_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Akwo kakibhegha nbhandwa yumu ghwa machonda kilongohi ghwa Akaalumi, mwene ywakannyelelitwe munu na nkulu ghwake, kakitopelwa utamwa na kakibhegha tepatepa paulili. ");
INSERT INTO nww_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kilongohi aywo ywa machonda pakayihwite mihalo ya Yesu, kakialaghila amoo akulu bha Akaayahudi kwa Yesu, ngati akannyupe kahike ngati kakanlamihe nbhandwa ghwa kilongohi aywo gwa amachonda. ");
INSERT INTO nww_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bhala hilongohi paahikite kwa Yesu bhakinnyupa kakanntangatile yula kilongohi ghwa amachonda paakilongela, “Mundu aywo yingunnogha kakatendelwe nnando aghwo, ");
INSERT INTO nww_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kiyaha kanguapala bhandu bhannima ghwetu, hila hila kakituchengela kitutubhi kyetu kya kukonganila.” ");
INSERT INTO nww_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Hinu Yesu kakilongohana nabho, peni pakabheghite kutali ng'obhe na lubhagha lwake, yula machonda kilongohi ghwa Akaaloma kakialaghila aghanja bhake kunng'ombela Yesu, “Bambo, ghukotoke kulighaha kiyaha nenga yingunnogha ng'obhe kwa ghwenga kuyingila payi ya lunyakaa lwangu. ");
INSERT INTO nww_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ndo nikilibhona yingunnogha ng'obhe kughuhikila. Peni ghukwilikihe lilagho ghweka chake na nndumitumi ghwangu kaalama. ");
INSERT INTO nww_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kiyaha nenga ndo mundu niibheghite pahi ya makakala, megha na machonda bha abheghiti pahi ya nenga. Pa nunng'ombela ayu ‘Ghughende!’ Naywo kaaghenda, na ayu ‘Ghuhike!’ Naywo katahika. Panunng'ombela nbhandwa ghwangu ‘Ghutende aki!’ Ywombe kaatenda.” ");
INSERT INTO nww_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu pakayihwite malagho agho kakinkangacha munu, kakilupilukila lula lumati lwa bhandu luuntughilite, na kakiaghombela, “Nenga niyibhona ng'obhe hyubhalilo ngulu handa ayi hata Muakaaisilaeli.” ");
INSERT INTO nww_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bhala bhandu paabhuyite mulubhagha lwa nkulu ghwabhe bhakimmona yula nbhandwa kalama kala. ");
INSERT INTO nww_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mbole kya mandina Yesu kakighenda ku kitami kimo kikemitweghe Naini. Nabho ahundwa bhake na lumati lukulu lwa bhandu bhakilongohana papamu naywo. ");
INSERT INTO nww_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pakabheghite ugheghela na nlyango nkulu ghwa kitami, bhakikongana na bhandu bha ayeghite ntumba paakibhuka kughenda panje ya kitami. Aywo ywakahweghite kakibhegha mwana ghwa kighweka ghwa nndala nnekwa. Lumati lukulu lwa bhandu bha kitami kila lukibhegha papamu na nndala aywo. ");
INSERT INTO nww_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bambo Yesu pakammonite yula nndala nnekwa, kakimmonela luhungu, kakinng'ombela, “Ghukotoke kulila.” ");
INSERT INTO nww_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Mbole kakiheghelela kuulongolo na kakikikamula kila kindanda kya kugheghela ntumba, na bhala bhandu bha alipapite bhakiyima jii. Yesu kakilongela, “Nhongolo, ningughughombela ghuyumuke.” ");
INSERT INTO nww_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yula nhongolo ywakahweghite kakitama na kakiyanda kuyobhela, naywo Yesu kakinkamuha kwa ma ghwake. ");
INSERT INTO nww_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bhandu bhoha bhakiyingilwa na lyogha lya Chapanga na bhakintika Chapanga paakilongela, “Mbuye nkulu ghwa Chapanga kabwituka kwa twenga, Chapanga kahika kubhalopoha bhandu bhake.” ");
INSERT INTO nww_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mihalu ayi yakayitendite Yesu yikikwila mu nnima ghwa Yudea hyoha na mu milima hyoha ya ugheghela. ");
INSERT INTO nww_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ahundwa bha Yohane yunakubatisa bhakinng'ombela Yohane mihalu ayi hyoha yakayitendite Yesu. Mbole Yohane kakiakema ahundwa bhake abhili, ");
INSERT INTO nww_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","na kakialaghila kwa Bambo Yesu ngati bhakankonye, “Bhuli, ghwenga ndo yula ywakapala kuhika ywene ywakankambukite Yohane, ebu tunlindilile yungi?” ");
INSERT INTO nww_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bhala ahundwa paahikite kwa Yesu bhakinng'ombela, “Yohane yunakubatisa katulaghila tughukonye, ‘Bhuli, ghwenga ndo yula ywakapala kuhika ebu tunlindile yungi?’ ” ");
INSERT INTO nww_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mulisaa alyo alyo, Yesu kakibhegha mukualamiha atamwa atangalo, na akwelitwe na mandilu, mandilu ghakialekekeha, ubhwabhu abhu bhangalola atangalo, kakiatenda abhone. ");
INSERT INTO nww_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ndo Yesu kakiayanga bhala bhaalaghilitwe, “Mmuye makanng'ombele Yohane ghoha ghamughabhonite na kughayihwa. Bhanga kubhona angubhona, ngwabhenghwabhe angutyanga, abheghite na maloha angughululwa, bhanga kuyihwa anguyihwa, bhaahweghite anguhyuka na akapukwa bhangughombelwa Nhalo ghwa Maha. ");
INSERT INTO nww_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Chapanga katannonela mundu yula ywakabheghite ng'obhe na nyengema na nenga.” ");
INSERT INTO nww_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pabhabhukite ahundwa bha Yohane, Yesu kakilughombela lula lumati lwa bhandu, mihalu ya kya Yohane, “Pamughendite kumanyahi nyahi mukighenda kulola niki? Bhuli, mukighenda kubhona lunyahi paluyukwa na liyegha? ");
INSERT INTO nww_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Handa ng'obhe, mukighenda kubhona niki? Akakaa bhandu ahwalite maghwanda na mapinda matandamaho na kutama ulami ghwa utyahe angutama mu hitutubhi hya ghubhutwa. ");
INSERT INTO nww_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Peni mukighenda kubhona niki? Mukighenda kummona mbuye? Kulyaghila ninguaghombela yunummonite kakibhegha kupitingana kwa mbuye ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kiyaha Yohane ndo mwene matyeko mang'anyimo ghangulongela kukita, ‘Nnole nungunlaghila nndumitumi ghwangu, kakaghulongolele kukutendekehela njila yako.’ ” ");
INSERT INTO nww_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesu kakiyomola kwa kulongela, “Nunguaghombela bhoha kukita mu anabhandu bhoha bha atamiteghe mu nnima kahone ywakabheghite nkulu kupitingana kwa Yohane, peni ywakabheghite nndokwa mu Ghubhutwa ghwa Chapanga aywo ndo nkulu kupitingana Yohane.” ");
INSERT INTO nww_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bhandu bhoha na asumula sumu paayihwite mihalo ya Yesu, bhakiyitikila kukita nnando ghwa Chapanga ghukibha ghwa maha, abho ndo bhala bhaayitikilite kubatiswa na Yohane. ");
INSERT INTO nww_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Peni, Akaafalisayo na ahunda bha malaghilo bhakighulema nnando ghwa Chapanga kwabhe, kiyaha bhakilema kubatiswa na Yohane. ");
INSERT INTO nww_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ndo Yesu kakighendelela kulongela, “Bhandu bha kibheleko aki nibhahwananihe na kilibhi kyoki? Ndo bhandu bha kya bhuli? ");
INSERT INTO nww_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bhene abhegha handa bhana bhaatamite mu ligulio. Paakemana bhene kwa bhene pa akilongela, ‘Tukiapyembela lupalata peni mukikina ng'obhe, tukiayimbila nhambo ghwa kuhyononeha peni mukilila ng'obhe’ ");
INSERT INTO nww_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kiyaha Yohane yunakubatisa kakibhegha pakalyeghagha ng'obhe lingate ebu kakinywegha difwai, mwenga mukilongela, ‘Kana lindilu!’ ");
INSERT INTO nww_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwana ghwa Mundu kahika kunu pakalyegha na kunywegha na mwenga mungulongela, ‘Nlole, nhukila aywo na nnobhi, nng'anja ghwa asumula sumu na bhana ulemwa bhangi!’ ");
INSERT INTO nww_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Hata habhu Malangu gha Chapanga ghangubhoneha uhoto kwa bhoha bhanakughakingama.” ");
INSERT INTO nww_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nfalisayo yumo kakinnyupa Yesu kaghende kulubhagha lwake kwakya hilyo, hinu Yesu kakighenda kulubhagha lwa nfalisayo aywo na kakitama kulyeghela hilyo. ");
INSERT INTO nww_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mukitami kila pakibhegha nndala yumo yunaulemwa, pakamanyite kukita Yesu kakibhegha mulubhagha lwa Nfalisayo, yula nndala kakitola kyupa kya liganga lya alabasita kimemikihitwe mahuta ghanakunungila maha munu. ");
INSERT INTO nww_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kakihika na kakiyima ugheghela na maghulu gha Yesu, pakalila, na mahohi ghake ghakinponekela Yesu mumaghulu ghake. Nndala aywo kakighapukuta maghulu gha Yesu kwa hwili hyake. Mbole kakighachwembula maghulu gha Yesu na kughatyeka ghala mahuta ghaanungila. ");
INSERT INTO nww_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yula Nfalisayo ywakanlalikite Yesu pakabhonite agho, kakihwacha mumwoyo ghwake, “Handa Mundu ayu kangabheghite mbuye ghwa Chapanga ghwa hoto kangamanyite kukita nndala ayu ghwa kya bhuli na kukita nndala ayu kanaulemwa.” ");
INSERT INTO nww_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu kaking'ombela aywo Falisayo, “Simoni, megha na nhalo ghwa kughughombela.” Simoni kakinnyanga, “Mwika Nhunda, ghung'ombele.” ");
INSERT INTO nww_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Pakibhegha na nkulu yumo yunakuayahikila ngalabha bhandu abhili, yumu kakinnyahika hipalamande hya ngalabha mbinda mabhoko kumi nhano na yungi hipalamande ya ngalabha mbinda mabhoko kumi. ");
INSERT INTO nww_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bhoha abhili bhakilepelwa kubhuyiha ngalabha yila, na yula mundu kakialekekeha bhoha. Hinu ndo ywoki mu abha abhili katampala munu yula nkulu?” ");
INSERT INTO nww_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni kakinnyanga, “Ninguhwacha katabhegha yula ywakalekekehitwe ngalabha ngulu.” Yesu kakinng'ombela, “Ghutosa maha.” ");
INSERT INTO nww_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Mbole Yesu kakinkilibhukila yula nndala na kakinng'ombela Simoni, “Hinu, ghungummona nndala ayu? Panyingilite mu lubhagha lwako ghukimbegha ng'obhe machi gha kukuha maghulu ghangu, peni nndala ayu kanng'ulula maghulu ghangu kwa mahohi ghake na kakighapukuta kwa hwili hyaki. ");
INSERT INTO nww_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ghukinamuha ng'obhe kya kunjwembula, peni nndala ayu kakileka ng'obhe kughachwembula maghulu ghangu kutandila pa hikite. ");
INSERT INTO nww_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ghukindyeka ng'obhe mahuta gha seituni mumutwe ghwangu, peni mwene kakighatyeka maghulu ghangu mahuta ghanakunungila. ");
INSERT INTO nww_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Hinu nungughughombela ulemwa ghwake ghuubheghite ghwa mahele ghulekekehwa, kiyaha kaghubhoneha upalo ghwa mahele. Peni yula ywakalekikihitwe kya mandina kaapala kya mandina.” ");
INSERT INTO nww_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mbole Yesu kakinng'ombela yula nndala, “Ghulekekehwa ulemwa ghwako.” ");
INSERT INTO nww_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Peni bhala bhaatamite papamu naywo mu hilyo, bhakiyanda kughombana bhene kwa bhene, “Mundu ayu ndo ghani mbaka kabhe na makakala gha kulekekeha ulemwa?” ");
INSERT INTO nww_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesu kakinng'ombela yula nndala, “Uhyubhalilo ghwako ghukulopoha, ghughende kwa uhihimilo.” ");
INSERT INTO nww_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mbole ya agha Yesu kakighenda muhitami nhanganganiko na hijiji pakilandamiha na kuaghombela bhandu Nhalo ghwa Maha ghwa Ghubhutwa ghwa Chapanga; na bhala ahundwa bhake mbinda maboko yimu na abhili bhakibhegha papamu naywo, ");
INSERT INTO nww_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ubhwabhu abhu amoo bha adala bhaabhuhitwe mandilu na kulamihwa utamwa, mubhene kakibhegha Malia ghwa Kumagadala, ywakabhuhitwe mandilu nhano na abhili, ");
INSERT INTO nww_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yoana nndala ghwa Chusa, ndumindumi nkulu ghwa mutwa Helode na Susana na amoo atangalo, abho bhankeyelagha kwa utopelo ghwabhe. ");
INSERT INTO nww_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Linjubha alyo bhandu bhakighendelela kunhikila Yesu kuhuma ku kitami kimu mbole ya kingi na pakibhegha na lumati lukulu lwa bhandu. Naywo Yesu kakiaghombela ndambulo ayi. ");
INSERT INTO nww_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mundu yumo kakighenda kukomolela mbeyu hyaki. Pakabheghite mukukweta mbeyu ahyo, yingi yikiponeka munjila bhandu bhakihilibhata na hiyuni bha kunani bhakiihonyola. ");
INSERT INTO nww_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mbeyu yingi yikiponeka mu lutupi luubheghite na mitalabha, na payimelite, yikiyuma kiyaha kukibha na kinyikilo ng'obhe. ");
INSERT INTO nww_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Na mbeyu yingi yikiponeka mu mikongo ya mihomi, yila mihomi yikikula papamu na kuhiyuka, ndo ayo mimela yikiyuma. ");
INSERT INTO nww_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mbeyu yingi yikiponeka mu lutupi luubheghite na mbosela, yikimela na kupapa mbunje mbinda mabhoko kumi kwa kila mbeyu.” Mbole ya kulongela agha, kakikweha lilobhe pakilongela, “Yuna makutu gha kuyihwa kakayihwe.” ");
INSERT INTO nww_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ahundwa bhake bhakinkonya fwambulo ya ndambulo ayi. ");
INSERT INTO nww_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Naywo kakiayanga, “Mwenga munemelwa kumanya hoto ya Ghubhutwa ghwa Chapanga ghwene pamakachu ghukimanyika ng'obhe, peni hinu ghungumanyika kwa mwenga, peni kwa bhangi nungulongela kwa mandambulo ngati paalolekeha akotoke kubhona, na paayihwa akotoke kumanya.” ");
INSERT INTO nww_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Fwambulo ya ndambulo ayo ndo ayi, Mbeyu ndo lilagho lya Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Yila yiponekite mu mbwegha ya njila, ndo bhala bha aliyihwite lilagho lya Chapanga, Nchipila kanguhika na kulibhuha mu myoyo yabhe, ngati akotoke kuhyubhalila na kulopoka. ");
INSERT INTO nww_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yila yiponikite mulutupi lwa mitabhala ndo bhala bhene paayihwite lilagho lya Chapanga angulikingama kwa uyelelo, peni abhegha ng'obhe na ngiya na lilagho alyo lingutengeleheka ng'obhe mumyoyo yabhe, anguhyubhalila kwa ng'ebhu mandina, peni mu mang'eho anguleka kuhyubhalila. ");
INSERT INTO nww_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Yila mbeyu yiiponekite mumihomi ndo nhwano ghwa bhala bhandu bhaayihwite, peni kamu paabhuka anguyukwa na bhwaghalili lya kutama kya kila linjubha, utopelo na utyahe, na uhyubhalilo ghwabhe ghungubhuha ng'obhe mihalo ya maha. ");
INSERT INTO nww_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Peni yila mbeyu ya mulutupi lwamaha ndo nhwano ghwa bhala bhaayihwite lilagho lya Chapanga kwa mwoyo ghwa nyitikilo, nabho kwa ulimbililo ghwa mahele angughendelela kuyitenda mihalo yinanogha Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Kahone mundu ywaakwata limbamba na kuligubika munkambo ebu pahi ya lihungu lya ulili. Ng'obhe, ngati lyakwatwa na kubhikwa kunane mwa kinyuta kyake ngati bhala bhaabheghiti munyumba abhone bhwelu.” ");
INSERT INTO nww_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Ubhwabhu kahone kilibhi kyoheli kila kinakuhihwa kya nga kuhwimulighwa, ebu nhalo ghwoheli ghwa lupwepo ghwa ngayeghwa pakindandabhanji.” ");
INSERT INTO nww_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Hinu, mulindakile pamuyihwa. Kiyaha ywohele ywakabheghite na kilibhi katayonjokehwa na ywohele ywa nga kilibhi na kila kyakahwachila kukita kabhegha nakyo, katapokwa.” ");
INSERT INTO nww_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ndo ma ghwa Yesu na alongo bhake bhakinng'endela, peni bhakihotola ng'obhe kunheghelela kwa kya lumati lwa bhandu. ");
INSERT INTO nww_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mundu yumo kakinng'ombela Yesu, “Ma ghwako na alongo bhako abhegha panji apo na angupala kughubhona.” ");
INSERT INTO nww_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Peni Yesu kakiaghombela bhandu bhoha, “Maghwangu na alongo bhangu ndo bhala bha aliyihwa lilagho lya Chapanga na kuliyitikila.” ");
INSERT INTO nww_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Linjubha limu Yesu kakihubhuka mu bhwato papamu na ahundwa bhake, kakiaghombela, “Tuyomboke lihibha tughendi mbaka kumwambo ya lihibha.” Ndo bhakiyanda mwanja. ");
INSERT INTO nww_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ndo paabheghite mu mwanja, Yesu kakitopelwa ng'ono, mbole kakighonja, kamu likusi likulu na nnyukano ghwa machi ghukiyanda mu lila lihibha, mbaka bhwato ghukiyanda kumemeka machi, nabho akibhegha ugheghela na kudibala. ");
INSERT INTO nww_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bhala ahundwa bhakinng'endela Yesu, bhakinnyumuha paakilongela, “Bambo, Bambo! Tunguhwegha.” Yesu kakiyumuka na kakilikwilikiha likusi liyime na nnyukano ghwa machi ghukipela. ");
INSERT INTO nww_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ndo kakiakonyekeha ahundwa bhake, “Hyubhalilo yenu yibha kwoki?” Peni bhene kya kuyoghopa na ngangahyo bhakighombana, “Ayu ndo mundu ghwa bhuli, ywene ywakakwilikiha likusi na nnyukano ghwa machi nahyo yingunnyitikila?” ");
INSERT INTO nww_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bhakighendelela na mwanja ndo bhakihika ku nnima ghwa Akaagelasi, ghuubheghite kumwambo ya lihibha kuhuma ku Galilaya, ");
INSERT INTO nww_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu pakahulukite kuluhingo, kakikongana na mundu yumu ywa kitami kila ywakakwelitwe na mandilu, naywo kwa manjubha matangalo kakihwala ng'obhe lighwanda ebu kutama mulubhagha ngati mu mandogholo. ");
INSERT INTO nww_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pakammonite Yesu kakituta kyobho, pakilitagha pahi mu ulongolo ghwake na kulongela kwa lilobhe likulu, “Ghwenga, Yesu Mwana ghwa Chapanga ghwakabhegha unani mwa ghoha Nkulu, ghubhegha na nhalo ghani na nenga? Nungukuyupa ghukotoke kumbamanda!” ");
INSERT INTO nww_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kakilongela naha kiyaha Yesu kakilighombela alyo lindilu limmuke mundu aywo. Pipipi lindilu alyo likinkwela mundu aywo, hata bhula bhandu paammonite kwa nnyololo mumabhoko na kingongolo mumaghulu ghake na kubhikwa mukibhopo, mwene kakinotola aghwo nnyololo na alyo lindilu likinnyegha kukibhala. ");
INSERT INTO nww_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu kakinkonya, “Lihina lyako ghani?” Mwene kakinnyanga, “Lumati” kiyaha kakiyingilwa na mandilu gha mahele. ");
INSERT INTO nww_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ghala mandilu ghakinnyupa muno Yesu kakotoke kuakwilikiha aghende kumambe. ");
INSERT INTO nww_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ugheghela na apwo kukibhegha lumati lukulu lwa maghulubhe paakihakila ku uhelelo ghwa kitumbi. Bhala mandilu bhakinnyupa Yesu abhakwilikihe abhayingile bhala maghulubhe, naywo Yesu kakiategheka. ");
INSERT INTO nww_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bhala mandilu paammukite yula mundu, bhakiayingila bhala maghulubhe, na lula lumati lwoha lwa maghulubhe lukipitila mu ngende na lukiyingila muluhibha na bhakihwegha mumachi. ");
INSERT INTO nww_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bhala bhandu bhaabheghite paahakila lula lumati lwa maghulubhe pabhabhonite ghaghabwitukilite, bhakitugha, na kulandamiha nhalo ghula mu kitami na mu hijiji. ");
INSERT INTO nww_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nabho bhandu bhakihika kughenda kubhona bhene gha ghabwitukilite. Paahikite apwo pakabheghite Yesu, bhakimmona yula mundu ywakabheghite na mandilu pakitama ugheghela na Yesu, kahwala ngubho na kanamahala ghake gha maha ndo bhakiyoghopa. ");
INSERT INTO nww_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bhala bhaabhonite nnando aghwo bhakialubhulila ayabhe kya yula mundu ywakabheghite na mandilu pakalopohitwe. ");
INSERT INTO nww_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ndo bhandu bhoha bha kitami kila kya Akaagelasi bhakinnyupa Yesu kabhuke kwabhe, kiyaha bhakimemekwa lyogha. Ndo Yesu kakihubhuka kangi mu bhwato ngati kakabhuke. ");
INSERT INTO nww_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Yula mundu ywakabhuhitwe mandilu kakinnyupa Yesu ngati kalongohane naywo. Peni Yesu kakintegheka ng'obhe, pakinng'ombela, ");
INSERT INTO nww_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ghubhuye ukaya kwako na ghukaaghombele mihalo mikulu yakakutendilite Chapanga.” Ndo yula mundu kakighenda na kakilandamiha mu kitami kyoha mihalo mikulu yakatendilitwe na Yesu. ");
INSERT INTO nww_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ndo Yesu pakabhuyite kumwambo ya lihibha lumati lukulu lwa bhandu lukinkingama kya kuyelelwa, kiyaha bhandu bhakinlindila. ");
INSERT INTO nww_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mbole mundu yumu lihina lyake Yailo, kilongohi ghwa kitutubhi kya kukonganila, kakihika na kakilitagha mu ulongolo ghwa Yesu, na kakinnyupa kaghende ku lubhagha lwake, ");
INSERT INTO nww_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kiyaha nhinja ghwake ghwa kighweka ywaabheghite na ngungwa mbinda mabhoko yimo na ibhili, kakibhegha mu njupula ya kuhwegha. Yesu pakabheghite mu kughenda, lumati lwa bhandu lukinnyuka mbande hyoha. ");
INSERT INTO nww_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mulumati alwo pakibhegha nndala yumo ywaahuma mwahi kiyaha kanaliholobhela kwa ngungwa mbinda mabhoko yimo na ibhili, kangi kakiyomola hilibhi hyoha hyakabheghite nahyo kwa aghanga, peni kakibhegha ng'obhe nng'anga ywakahotolite kunnamiha. ");
INSERT INTO nww_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Aywo nndala kakinhikila kya kuhyetu na kakilibyala lupindo lwa lighwanda lya Yesu, kamu ghula mwahi ghwa liholobhela lyake likiketuka. ");
INSERT INTO nww_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu kakikonya, “Ghani aywo ywakanbyalite?” Bhandu bhoha paalemite, Petili kakilongela, “Bambo, ndo alu lumati lwa bhandu lukutindilite na kukuyuka mbande hyoha!” ");
INSERT INTO nww_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Peni Yesu kakilongela, “Kabhegha mundu ywakanbyalite, kiyaha manya kukita ninlamiha mundu kwa likalama lyangu.” ");
INSERT INTO nww_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yula nndala pakamanyite kukita katahotola ng'obhe kulihiha, kakinhikila pakiloghoya kwa lyogha, kakichutamila mayughwa mu ulongolo ghwa Yesu, na kakilubhulila mu ulongolo ghwa bhandu bhoha kya niki kakinbyala na bhula mwakalamihitwe. ");
INSERT INTO nww_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu kakinng'ombela, “Nhinja, kuhyubhalila kwako kughulopoha. Ghughende kwa uhihimilo.” ");
INSERT INTO nww_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu pakabheghite akali kangulongela, kakihika ndumindumi kuhuma kulubhagha lwa Yailo, yula kilongohi ghwa kitutubhi kya kukonganila, kunng'ombela, “Nhinja ghwako kahwegha kala, ghukotoke kunng'aha kangi nhunda.” ");
INSERT INTO nww_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu pakayihwite nhalo aghwo, kakinng'ombela Yailo, “Ghukotoke kuyoghopa, ghuhyubhalile, naywo nhinja ghwako katalopoleghawa.” ");
INSERT INTO nww_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pabhahikite kulubhagha lwa Yailo, kakintegheka ng'obhe ywohele kayingile mukitutubhi papamu naywo ngati nga Petili na Yakobu na Yohane na tate na maghwa yula mwana. ");
INSERT INTO nww_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Lisaa alyo bhandu bhoha bhakibhegha paakilila na kuhyononeka kwa kya aywo nhinja. Yesu kakiaghombela, “Nkotoke kulila. Nhinja kahwegha ng'obhe ngati kaghonja.” ");
INSERT INTO nww_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nabho bhankiheka Yesu kwa kunnyuyuha kiyaha bhakimanya kukita nhinja kahwegha. ");
INSERT INTO nww_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Peni Yesu kakinkamula kibhoko yula nhinja na kukema, “Mwana, ghuyumuke!” ");
INSERT INTO nww_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kamu nhuki ghwake ghukimmuyila, naywo kakiyimuka. Yesu kakikwilikiha anpeghe kilibhi kyoheli kya kulyegha. ");
INSERT INTO nww_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Abhele bha yula nhinja bhakikangacha munu, peni Yesu kakiakanikiha akotoke kunng'ombela mundu ywohele ghaghabwitukiliti. ");
INSERT INTO nww_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu kakiakema bhala ahundwa mbinda mabhoko yimo na abhili papamu, na kakiapegha likalama na makakala gha kughabhuha mandilu ghoha na kualamiha atamwa bhoha, ");
INSERT INTO nww_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","mbole kakialaghila aghende kulandamiha bhandu Ghubhutwa ghwa Chapanga na kualamiha atamwa. ");
INSERT INTO nww_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kakialaghila pakilongela, “Pammegha mumwanja nkotoke kutola kilibhi kyohele, ebu nkongocho, ebu nhako, ebu hilyo, ebu mbiya, ebu lighwanda lya kuhemengana. ");
INSERT INTO nww_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Lubhagha lwohele lu muluyingila, ntame amwo mbaka panmpala kubhuka mu kitami akyo. ");
INSERT INTO nww_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Handa bhandu paabhalema kubhakingama, mmuke mukitami kyabhe, npumunde lihu mumaghulu ghenu ngati yibhe uyimiho na naho ya lukinyo kwa uhakata ghwabhe.” ");
INSERT INTO nww_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ndo bhala ahundwa bhakibhuka bhakighenda kijiji mbaka kijiji, paakiaghombela bhandu Nhalo ghwa Maha na kualamiha atamwa kwoha. ");
INSERT INTO nww_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ndo mutwa Helode, ntabhala ghwa Galilaya kakiyihwa mihalo hyoha yakatendite Yesu, kakiyingilwa na bhwaghalili kiyaha amoo bhandu akilongela kukita Yohane yunakubatisa kahyuka. ");
INSERT INTO nww_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bhangi bhakilongela kukita Eliya ywakabheghite mbuye ghwa Chapanga kabhabwitukila, na bhangi bhakilongela yumoo bha mambuye bha makachu kahyuka. ");
INSERT INTO nww_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Peni Helode kakilongela, “Yohane nikinndumula mutwe. Peni aywo ndo ghani niyiyihwite mihalo yake?” Ndo kakipala kummona. ");
INSERT INTO nww_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Bhala andumitumi bhake paabhuyite, bhaking'ombela Yesu hyoha hyaatendite. Yesu kakiatola na kakighenda nabho pa kighweka mbaka kitami kimo kiikemitwe Betisaida. ");
INSERT INTO nww_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Peni lumati lwa bhandu palumanyite paaghendite, lukintughila. Ndo Yesu akiakingama na kakiyobhela nabho ya kya Ghubhutwa ghwa Chapanga na kualamiha bhala bhoha bhaapalite kulamihwa. ");
INSERT INTO nww_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Payihegheghelite makimuhi, bhala ahundwa mbinda mabhoko yimo na abhili bhakinng'endela Yesu na bhakinng'ombela, “Ghululaghe lumati alu lwa bhandu lubhuke ngati aghende mu hijiji na mumighunda ya ugheghela, ngati bhakapalahe hilyo na ng'ebhu ya kughonja, kiyaha apa tubhegha pa manyahi.” ");
INSERT INTO nww_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Peni Yesu kakiaghombela, “Mubhapeghe mwenga hilyo.” Nabho bhakinnyanga, “Tubhegha na kyohele ng'obhe, ngati nga mangate nhano na homba abhili, pangi tughende tukahemele hilyo hya kukwila bhandu bhoha abha?” ");
INSERT INTO nww_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kiyaha akibhegha bhandu Elfu nhano. Ndo Yesu kakiaghombela ahundwa bhake, “Muaghombele bhandu atame mu himati hya bhandu mbinda mabhoko nhano.” ");
INSERT INTO nww_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ahundwa bhakitenda handa aghombilitwe na Yesu, bhakiatamiha pahi bhandu bhoha. ");
INSERT INTO nww_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Mbole Yesu kakighatola ghala mangate nhano na bhala homba abhili, kakilolekeha kunani pakinnumba Chapanga, kakiyinonela na kuyimetulanga, mbole kakiapegha ahundwa bhake alupeghe lula lumati lwoha lwa bhandu. ");
INSERT INTO nww_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bhandu bhoha bhakilyegha na akiyukuta. Ahundwa bhakikungana mahighalo ghahighalite, na ghakimema hikapu mbinda mabhoko yimo na hibhili. ");
INSERT INTO nww_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Linjubha limo Yesu pakabheghite mu kuyupa pakighweka, na ahundwa bhake bhakibhegha ugheghela. Ndo kakiakonyekeha, “Bhandu angulongela kukita nenga ndo ghani?” ");
INSERT INTO nww_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nabho bhakinnyanga, “Bhangi angulongela kukita ghwenga ndo Yohane yunakubatisa, bhangi angulongela kukita ghwenga ndo Eliya na bhangi angulongela, ghwenga ndo yumoo ywa ambuye bha makachu kahyuka kuhuma kwa bhaahweghite.” ");
INSERT INTO nww_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mbole kakiakonyekeha, “Bhuli mwenga, mungulongela kukita nenga ndo ghani?” Petili kakinnyanga, “Ghwenga ndo Kilisito ywakahaghulitwe na Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Mbole Yesu kakiakwilikiha akotoke kunng'ombela mundu ywohele nhalo aghu. ");
INSERT INTO nww_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesu kakighendelela kakilongela, “Yingunnogha Mwana ghwa Mundu kapati himbamanda hitangalo na kulemwa na aghohi, na andundame akulu na ahunda bha malaghilo naywo katakomwa na mu linjubha lya ndatu katahyuka.” ");
INSERT INTO nww_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mbole kakiaghombela bhoha, “Ywohele ywakapala kunndughila yingunnogha kalileme mwene, kakatole lupingika lwake manjubha ghoha na kakandughile. ");
INSERT INTO nww_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kiyaha ywohele ywakapala kughulopoha ubhumi ghwake kataghuhoha, peni ywohele ywakaghuhoha ubhumi ghwake kwa kya nenga, kataghulopoha. ");
INSERT INTO nww_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Hinu, yibhegha hupo yoki kwa mundu kughukamula nnima ghwoha, na kulikanjaghana mwene? ");
INSERT INTO nww_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Handa mundu ywohele ywakamonela honi nenga na malagho gha nenga, Mwana ghwa Mundu naywo katammonela honi mundu aywo paahika Muukulu ghwake na Muukulu ghwa Tate na ghwa mahoka bha Chapanga na bhaabhaghulitwe kwakya Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kulyaghila nunguaghombela hoto, amoo bhandu bha abheghite apa bhene bhatahwegha ng'obhe mbaka pakapala kughubhona Ghubhutwa ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ghakikinda manjubha nhano na ndatu mbole gha kughalongela ghala, Yesu kakiatola Petili, na Yakobu na Yohane kakighenda nabho ku kitumbi kunnyupa Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Pakabheghite mu kuyupa, mmonekano ghwa kibhungi kyake ghukighalambuka, maghwanda ghake ghaking'anyima mbuletee. ");
INSERT INTO nww_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kamu bhakiabhona bhandu abhili, Musa na Eliya paakiyobhela na Yesu, ");
INSERT INTO nww_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","bhala bha abwitukiliti akibhegha muukulu, paakilyobhela na Yesu yakya kuyomoka kwake kuupala kutulukila akwo Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petili na ayake akibhegha mung'ono ngulu, hata habhu kamu bhakiyimuka, bhakighubhona ukulu ghwa Yesu na bha bhala abhili bhaayimite papamu naywo. ");
INSERT INTO nww_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Musa na Eliya, paabheghite mu kubhuka, Petili kakinng'ombela Yesu, “Bambo yibha maha tubha apa! Hinu tuchenge matinga mandatu, limoo lyako, limoo lya Musa na limoo lingi lya Eliya” Peni Petili kakimanya ng'obhe kyakalongilite. ");
INSERT INTO nww_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petili pakabheghite kakali pakalongela likihuluka lihundi na likiagubika, nabho bhakiyoghopa paayingilite mu lila lihundi. ");
INSERT INTO nww_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lilobhe likiyihwanika kuhuma mulila lihundi palikilongela, “Ayu ndo mwana ghwangu npalo nenga Chapanga, yununhaghulitie, munnyihwe mwene.” ");
INSERT INTO nww_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mbole ya lilobhe alyo kuyihwanika, bhakimmona Yesu pakibhegha ghweka chake. Bhala ahundwa bhakinyamala jii na mumanjubha agho bhakinng'ombela ng'obhe mundu ywohele ghala ghaaghabhonite. ");
INSERT INTO nww_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kilabho yake, Yesu papamu na ahundwa bhake andatu paahulukite kuhuma ku kitumbi, kakikongana na lumati lukulu lwa bhandu. ");
INSERT INTO nww_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mundu yumu mu lula lumati lwa bhandu kakichobha kyobho paakilongela, “Nhunda, nungukuyupa ghunlolekehe mwana ghwangu, ndo mwana ghwangu ghwa kighweka. ");
INSERT INTO nww_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Pipipi lindilu lingunkwela na kuntenda kayobhe kyobho, mbole lingunng'wigha pahi na linguntenda kabhe na kihilika na lihuluhulu likimmuka mu ngulu yake. Alyo lindilu lingunbamanda muno na likinlekekeha ng'obhe kya kuyumbatika. ");
INSERT INTO nww_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nikiayupa ahundwa bhako alibhuhe alyo lindilu peni bhakilepelwa.” ");
INSERT INTO nww_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu kakiyanga pakilongela, “Mwenga kibheleko kya nga uhyubhalilo na kinakuhokela, nda tama na mwenga na kualimbilila mbaka pakiki?” Mbole kakinng'ombela yula mundu, “Ghunnyeghe mwana ghwako apa.” ");
INSERT INTO nww_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Yula nhongolo pakabheghite mukunhikila Yesu, lila lindilu likinng'wiha pahi, likinnyingiha kihilika. Peni Yesu kakilikwilikiha lila lindilu limmuke, kakinnamiha yula mwana na kakimmuyiha kwa tate ghwake ");
INSERT INTO nww_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bhandu bhoha bhakikangacha makakala makulu gha Chapanga. Bhala bhandu paabheghite akali angukangacha ghoha ghakatendite Yesu, mwene kakiaghombela ahundwa bhake, ");
INSERT INTO nww_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nkingikihee makutu ghenu, namuyiyihwe mihalu ayi, Mwana ghwa Mundu kangughenda kukilukwa na kukamuhwa mu mabhoko gha bhandu.” ");
INSERT INTO nww_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Peni bhombe bhakimanya ng'obhe fwamulo yake niki. Kiyaha fwambulo ya mihalu ayo yikihihwa kwabhe, habhu bhakighamanya ng'obhe, nabho bhakiyoghopa kunkonya fwambulo ya malagho agho. ");
INSERT INTO nww_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ghakibwituka maghombano mu bhala ahundwa bha Yesu gha kya ghani ywakapala kubhegha nkulu mu bhoha, ");
INSERT INTO nww_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","peni Yesu kakighamanya mahwacho gha myoyo yabhe, kakintola mwana nndokwa na kakinnyimiha mu ugheghela ghwake, ");
INSERT INTO nww_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","mbole kakiaghombela, “Mundu ywohele yunakunkingama mwana nndokwa kiyaha kanguliyitikila lihina lyangu, mudu aywo kangunngingama nenga, na ywohele ywakangingama nenga, kangunkingama yula ywakanaghilite, kiyaha yula ywakabheghite nndokwa kupitingana kwa bhoha mumwenga aywo ndo nkulu kupitingana bhoha.” ");
INSERT INTO nww_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohane kakilongela, “Bambo tummona mundu pakighabhua mandilu kwa bhandu kwa lihina lyako, twenga tunkanikiha, kiyaha mwene kabha yumoo ywetu ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu kakiaghombela, “Nkotoke kunkanikiha, kiyaha ywohele ywa nga kupingikana na mwenga kabhegha mu mbande yenu.” ");
INSERT INTO nww_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Manjubha paghaheghelelite kwa Yesu kutolwa kughenda kunani kwa Chapanga, mwene kakikamala kughenda ku Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Habhu kakialaghiha bhandu bhanlongolele, nabho bhakighenda na bhakiyingila mu kijiji kimo kya Akaasamalia kunkeyela hyoha, ");
INSERT INTO nww_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","peni akolannima bha kijiji kila bhakinkingama ng'obhe kiyaha kakibhegha mu mwanja ghwake kughenda ku Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ahundwa bhake ndo Yohane na Yakobu paabhonite agho, bhakilongela, “Bambo, ghupala tughukwilikihe mwoto ghuhuluke kuhuma kunani kwa Chapanga ghubhayoche?” ");
INSERT INTO nww_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Peni mwene Yesu kakikilibhuka na kualakalila. ");
INSERT INTO nww_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nabho bhakibhuka na bhakighenda ku kijiji kingi. ");
INSERT INTO nww_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pakabheghite munjila pakighenda, Mundu yumu kakinng'ombela Yesu, “Ndaghutughila kwohele kughughenda.” ");
INSERT INTO nww_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu kakinnyanga, “Mabweha abhegha na mbako na hiyuni hya kunani abhegha na hiyumba, peni Mwana ghwa Mundu kabhegha ng'obhe na pakulighonjeha.” ");
INSERT INTO nww_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Mbole Yesu kakinng'ombela mundu yungi, “Ghundughile.” Peni yula mundu kakinnyanga, “Bambo, ghundegheke huti ngankulile tate ghwangu.” ");
INSERT INTO nww_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu kakinng'ombela, “Ghualeke bhanakuhwegha mu myoyo yabhe abhakulile bhaahweghite bhabhe, ngati ghwenga ghughende ghukaghulandamihe Ghubhutwa ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mundu yungi kakinng'ombela, “Bambo, ndaghutughila peni ghundegheke huti ngaalaghe alongo bhangu.” ");
INSERT INTO nww_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu kakinng'ombela, “Mundu ywohele ywakapala kukanda lutupi, mbole kangulolekeha kuhyeto, kalemwa mu Ghubhutwa ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mbole ya agho Bambo Yesu kakiahaghula Afwasi bhangi mbinda mabhoko saba na abhili, kakialaghila abhili abhili bhannongolele kughenda kuhitami hyoha hyakapalite kughenda. ");
INSERT INTO nww_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kakiaghombela, “Mabeno ghabha matangalo peni bhanakubena abhegha bha mandina hino munnyupe Bambo ghwa mabeno, kabhalaghile bhanakubena munng'unda ghwake. ");
INSERT INTO nww_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Hinu! Nng'ende, na mmanyi kukita nungualaghila handa bhana bha mene bhanakughenda munkati ya akabhwa bha kunhitu. ");
INSERT INTO nww_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mangayegha nhako ghwa mbiya, ebu nchako, ebu makobasi; kangi nkote kunjambuha mundu ywohele mu njila. ");
INSERT INTO nww_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Na panyingila mu lubhagha lwoheli nnongele huti ‘Uhihimilo ubheghe mu lubhagha alu.’ ");
INSERT INTO nww_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Handa kabhegha mundu yunakupala uhihimilo, ndo uhihimilo ghwenu ghwabhegha mu ywombe, handa kabhegha ng'obhe yunakughupala uhihimilo, uhihimilo ghwenu ghwaabhuyila. ");
INSERT INTO nww_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ntami pa lubhagha alwo kunu pannywegha na kulyegha hyaabhapegha, kiyaha kila yunakutenda lihengo yinnogha matulo ghake, nkotoke kubhuka mu lubhagha alu na kughenda mu lubhagha lula. ");
INSERT INTO nww_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Handa panhika pakitami kyohele! Na bhandu paabhakingama nlyeghe hyaabhapegha. ");
INSERT INTO nww_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mubhalamihe atamwa bhaabheghiti akwo, na mubhaghombele bhandu, ‘Ghubhutwa ghwa Chapanga ghuheghelela.’ ");
INSERT INTO nww_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Peni pannyingila ku kitami kyoheli kila na bhandu paabhalema kuakingama, mmuke na pantyanga mu njila yabhe nnongele, ");
INSERT INTO nww_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Hata malihu ghaa kitami kyenu ghaamamatilite mu maghulu ghetu tungughapumunda yibhe naho ya makinyo kwa kya mwenga. Peni mmanyi kukita Ghubhutwa ghwa Chapanga ghuheghelela.’ ");
INSERT INTO nww_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kulyaghila nungubhaghombela, linjubha lila kitami akyo kyamokola toso ngulu kupitingana kya bhandu ahakata bha Sodoma.” ");
INSERT INTO nww_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Yaabhegha mipinguhi hya kyabhuli kwa ghwenga Kolasini na ghwenga Betisaida! Kiyaha mihabho yiitendikite kwa ghwenga yingatendikite kula Kutilo na Sidoni, bhandu bhake bhangalipetulite kya kuhwala maghwanda gha malobota na kulityelemeka lihu kuilaha kukita alipetula ulemwa ghwabhe. ");
INSERT INTO nww_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Hata naha, linjubha lya toso mwenga maamokola toso kikulu kupitingana kwa bhandu bha ku Tilo na Sidoni. ");
INSERT INTO nww_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mwenga ma bhandu bha ku Kapelinaumu, munguhwacha kukita maatikilwa mbaka kunani kwa Chapanga? Aka kaa, mahuluhwa mbaka kumambe.” ");
INSERT INTO nww_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mbole Yesu kakiaghombela ahundwa bhake, “Ywakabhayihwa mwenga, kangunyihwa nenga, na ywakalema kubhayihwa mwenga kangunema kungingama nenga. Na ywohele ywakalema kungingama nenga, kangulema kunkingama Chapanga ywakanlaghilite.” ");
INSERT INTO nww_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Mbole yake, bhala Afwasi mbinda mabhoko saba na abhili bhakibhuya kunu bhakibha na uyelelo na akilongela, “Bambo, Hata mandilu ghakituyitikila patughakwilikihite ghabhuke kwa lihina lyako.” ");
INSERT INTO nww_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu kakiaghombela, “Nikinmona Nchipila pakiponeka handa lumuli lwa njahe kuhuma kunani kwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nnole nibhapegha makalama gha kughalibhata mayoka na hipinini na makakala gha kunhotola yula nmyanja nhakata, na kahone kilibhi kya kubhatebhaha. ");
INSERT INTO nww_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Hata habhu, nkotoke kuyelelwa kiyaha mandilu ghakibhayitikila, ngati nnyelelwi kiyaha mahina ghenu ghatyekwa kunani kwa Chapanga ngati mmeghe bhandu bhake.” ");
INSERT INTO nww_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nga! Lisaa lila lila Yesu kakiyelelwa kwa makakala Nhuki ghwa Chapanga na kakilongela; “Ningughulumba ghwe Tate, Bambo ghwa kunani na nnima, kiyaha ghubhahiha bhanamahala na bhanamalango mihalo ayi, ngati ghubhayughulila bhana adokwa. Ena Tate kiyaha agha ndo ghanaghuhalala.” ");
INSERT INTO nww_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mbole kakilongela, “Tate ghwangu kangamuha hilibhi hyoha. Kahone mundu ywa kummanya Mwana ghwa Chapanga, maha nga Tate, kangi kahone Mundu ywakammanyite Tate maha nga Mwana, na ywohele yula ywakapala kunnyughulila.” ");
INSERT INTO nww_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Mbole kakiaghalambukila ahundwa bhake na kakiyobhela nabho mu lupwepo, “Bhanonelwa bhala bhaaghabhona ghala ghamughabhona mwenga! ");
INSERT INTO nww_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kulyaghila nungubhaghombela, mambuye atangalo na abhatwa bhakipala kughabhona ghamughabhona, peni bhakighabhona ng'obhe ebu kughayihwa gha mughayihwa.” ");
INSERT INTO nww_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mbole nhunda yumo ywa malaghilo kakiyima na kakinkonya kwa kuntyegha, “Nhunda, Ndende niki ngati mokole ubhumi ghwa nga kupela ghwa manjubha ghoha?” ");
INSERT INTO nww_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu kakinnyanga, “Yityekwa bhuli mu malaghilo? Ghangulongela niki?” ");
INSERT INTO nww_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kakinnyanga, “‘Ghunpale Bambo Chapanga ghwako kwa mwoyo ghwako ghwoha, kwa nhuki ghwako ghwoha, na kwa makakala ghako ghoha na kwa mahala ghako ghoha.’ Na ‘Ghunpale nhikila ghwako handa paghulipala ghumwene.’ ” ");
INSERT INTO nww_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu kakinng'ombela, “Ghuyanga tela. Ghukatende naha na ndo tama mumanjubha ghoha.” ");
INSERT INTO nww_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Peni aywo nhunda ghwa malaghilo kakipala kakalibhonehe kubha bha maha kwa Chapanga, Ndo kakinkonya Yesu, “Na nhikila ghwangu ndo ghani?” ");
INSERT INTO nww_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu kakinnyanga pakalongela, “Mundu yumu kakibha mu kubhuka ku Yelusalemu kughenda ku Yeliko, pakabheghite mu njila kakipukilwa na apoka, na bhakinpoka ngalabha hyaki na bhakintuta na bhakinleka pakaghonja njupula ya kuhwegha. ");
INSERT INTO nww_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Handa njuka naha! Ndundame yumu kakibha mu kukinda mu njila yiyila yila, pakammonite kakikindila kya kutali. ");
INSERT INTO nww_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ubhwabhu abhu Nlawi yumu, pakahikite pala, kakimmona peni kakikindila mbande yingi na kakinleka bahala pala. ");
INSERT INTO nww_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Peni Nsamalia yumu ywaabheghite mu mwanja, kakiheghelela mbaka pala pakabheghite yula ywakapokilitwe na pakammonite kakimmonela luhungu. ");
INSERT INTO nww_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kakinng'endela, kakinng'ulula hilonda hyaki na kuntyeka mahuta gha seituni na difwai, na kunbhilungila hilonda yake, mbole kakinhubhuha munng'ongo ghwa kaputa ghwake na kakinnyegha kukitutubhi kya kughonja ahenja kakinnwaha. ");
INSERT INTO nww_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kilabhu yake kakikamuha hipalamande hibhili hya ngalabha kwa nkola kitutubhi kya ahenja na kakinng'ombela, ‘Ghunnwahe mundu ayu na kyohele kiipala kuyonjokeheka ndaghuyeghela pamabhuya.’ ” ");
INSERT INTO nww_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Mbole Yesu kakinkonya, “Ghungulola bhuli ywoki ndo nndamani ghwake mu abha andatu? Kwa yula ywakapukilitwe na apoka?” ");
INSERT INTO nww_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yula nhunda ghwa malaghilo kakinnyanga, “Ndo yula ywakammonilite lipyanda.” Yesu kakinng'ombela “Ghughende ghukatende ubhwabhu abhu.” ");
INSERT INTO nww_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu na ahundwa bhake pabhabheghite mu mwanja kughenda ku Yelusalemu, bhakihika ku kijiji kimo, apa nndala yumu lihina lyake Malita, kakinkingama mu lubhagha lwake. ");
INSERT INTO nww_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Malita kakibha na nhacha ghwake ywakakemitwe Malia, ayu kakitama ugheghela na Bambo Yesu pakayihwa mahundo ghake. ");
INSERT INTO nww_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Peni Malita kakibha na mihalo mitangalo ya kukeyela, hino kakinng'endela Yesu na kakinng'ombela, “Bambo, ghungumona ng'obhe kukita nhacha ghwangu kangunnekela kutenda mahengo ghweka changu? Mbaha ghunkwilikihe kahike kanndangatile.” ");
INSERT INTO nww_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Peni Bambo Yesu kakinnyanga, “Malita, Malita, ghwenga ghungulighaha na kughaya kwa kya mihalo mitangalo. ");
INSERT INTO nww_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Peni kubhegha na nnando ghumu ghwa maha kupitingana hyoha na nnando aghwo ndo kunnyihwa. Na nnando aghwo ndo ghwakaghuhaghulite Malia.” ");
INSERT INTO nww_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Linjubha limu Yesu kakibhegha kumoo kumo pakinnyupa Chapanga. Pakayomolite kuyupa, yumoo ywa ahundwa bhake kakinng'ombela, “Bambo, tungughuyupa ghutuhunde kunnyupa Chapanga, handa bhula Yohane pakaahundite ahundwa bhake.” ");
INSERT INTO nww_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu kakiaghombela, “Pammegha mukunnyupa Chapanga nnongele naha, ‘Tate, ghwetu ghuubheghite kunani lihina lyako lihokamilwe, Ghubhutwa ghwako ghuhike. ");
INSERT INTO nww_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ghutupeghe nalelo hilyo hyetu hya kila linjubha. ");
INSERT INTO nww_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Gutulekekehe ulemwa ghwetu, kiyaha twenga tungualekekeha bhoha bhaatutendela uhokelo. Na ghukotoke kutuyingila mumang'eho.’ ” ");
INSERT INTO nww_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mbole Yesu kakiaghombela ahundwa bhake, “Tulongele yumoo ywenu ywakabheghite na nng'anja ghwake, na kakighenda ku lubhagha lwake pakilo, kakanng'ombele, ‘Ghanja, nje ghunnyahikile mangate mandatu chonde! ");
INSERT INTO nww_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kiyaha nng'anja ghwangu kanhikila pakibha mu mwanja ghwake na nenga mmegha nakyo ng'obhe kya kunpegha.’ ");
INSERT INTO nww_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Naywo nge kakannyangule kakali mu nyumba, ‘Ghukotoke kunng'aha ndata kala nlyango. Nenga na bhana bhangu tughonja kala ndayumuka ng'obhe kukupegha kilibhi.’ ");
INSERT INTO nww_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kulyaghila, nunguaghombela, mundu aywo katayumuka ng'obhe kunpegha aywo mangate kiyaha ndo ghanja ghwake, peni kiyaha yula mundu kaabhona ng'obhe honi, kughendelela kuyupa hinu aywo mundu katayimuka na kunpegha kilibhi kyohele kyakakipalite. ");
INSERT INTO nww_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Hinu ningubhaghombela, nnyupe na mwenga maakamuhwa, npalahe na mwenga matabhona, makatite hodi na mwenga maayughulighwa. ");
INSERT INTO nww_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kiyaha ywohele yunakuyupa kaakamuhwa yunakupalaha kaabhona na yula yunakutite hodi kaahughulighwa. ");
INSERT INTO nww_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Bhuli, kabhegha ywohele mu mwenga ywene mwana ghwake pakannyupite homba, kaanpegha liyoka kihyengo kya homba? ");
INSERT INTO nww_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ebu pakannyupa lihumbi kaanpegha kipinini? ");
INSERT INTO nww_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mwenga mabhandu bha mahakataho, mungumanya kuapeha bhana bhenu hilibhi hya maha, yabhegha bhuli kwa Tate ghwenu ghwa kunani katabhapegha ng'obhe mwenga Nhuki ghwake mwene Chapanga bhala bhaannyupa?” ");
INSERT INTO nww_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Hinu Yesu kakibhegha mu kulibhuha lindilu kuhuma kwa mundu ywanga kughomba. Lila lindilu pakammukite yula mundu ywanga kughomba kamu kakiyanda kuyobhela, nalo lumati lwa bhandu lukikangacha. ");
INSERT INTO nww_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Peni amoo bhandu bhakilongela, “Kangughabhuha mandilu kwa makakala ghakakamuhitwe na Belisebuli, yula kilongohi ghwa mandilu.” ");
INSERT INTO nww_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bhandu bhangi bhakinng'eha kwa kunpala kakatende naho kuhuma kunani kwa Chapanga, kubhoneha kukita kakiteghekwa na Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesu pakimanya mahwacho ghabhe, kakiaghombela, “Ghubhutwa ghwohele ghunakumetukana himati himati hinakupingikihana ghwakanjaghanika, ubhwabhu abhu lubhagha lwoheli luubheghite na bhulwa lwa pwilinganika. ");
INSERT INTO nww_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Handa ghubhutwa ghwa Nchipila naghwo ghungulikan ghwene, utabhala ghwabhe ghwatengeleheka bhuli? Nungubhaghombela naha mwenga kiyaha mwenga mungulongela kukita nungughabhingabhinga mandilu kwa makakala gha Belisebuli. ");
INSERT INTO nww_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Hinu, handa nenga nungughabhuha mandilu kwa makakala gha Belisebuli, hata ahundwa bhenu ubhwabhu angughabhuha kwa makakala ghake hinu ahundwa bhenu bhaadumula nongwa ayi ya nenga na mwenga kukita mmegha tela ng'obhe. ");
INSERT INTO nww_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Peni handa nenga nungughabhuha mandilu kwa makakala gha Chapanga, nmanyi kukita Ghubhutwa ghwa Chapanga ghubhahikila.” ");
INSERT INTO nww_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mundu yuna makakala pakakamula mikoha kulukingika lubhagha lyake, ghoha ghakabheghite naghwo ghaabhegha muuhihimilo. ");
INSERT INTO nww_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Peni pakahika mundu yuna makakala kupitingana kwa yombe aywo katanpukila na kuntuta na kunhotola mbole katanpoka mikoha yake hyoha yakayidumbilite na kuyitola hilibhi hyaki hyoha.” ");
INSERT INTO nww_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Mundu ywohele ywanga kubhegha papamu na nenga, kagumbingikiha, na ywohele ywa nga kukongoha papamu na nenga, kangupwilinganya.” ");
INSERT INTO nww_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Lindilu pakammuka mundu, kataghenda kuuyumu kupalaha pa kupumulila, peni handa kapabhona ng'obhe katalongela, ‘Ndabhuya ku kitutubhi kyangu kunhumite.’ ");
INSERT INTO nww_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Paabhuya na kukibhona kila kitutubhi kipyaghilwa na kulembwa maha, ");
INSERT INTO nww_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ndo kataghenda na kughatola mandilu ghangi nhano na abhili ahakata kupitingana kwa mwene nabho bhaayingila na kutama amwo. Ku uhiko njimba ya yula mundu yabhegha tepatepa kupitingana kya ulongohi.” ");
INSERT INTO nww_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu pakabheghite mu kulongela agha, nndala yumo ywakabheghite pakati ya lula lumati kakikweha lilobhe pakilongela, “Kanonelwa nndala ywakakupapite na kukunyongeha!” ");
INSERT INTO nww_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesu kakinnyanga, “Peni bhanonelwa muno bhala bhaaliyihwa lilagho lya Chapanga na kuliyitikila.” ");
INSERT INTO nww_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Lumati lwa bhandu palubheghite mu kuyonjokeheka, Yesu kakighendelela kuaghombela, “Aki ndo kibheleko kya uhakata, kingupalaha naho peni kya kamuhwa ng'obhe naho yohele ngati nga yila ya Yona. ");
INSERT INTO nww_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kiyaha handa bhula Yona pakabheghite naho kwa bhandu bha Ninawi, ubhwabhu abhu Mwana ghwa Mundu kaabhegha naho kwa kibheleko aki. ");
INSERT INTO nww_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Linjubha lya toso mutwa nndala ghwa Kusi katayima papamu na bhandu bha kibheleko aki, naywo pakiyimiha uhokelo ghwa kibheleko aki, kiyaha mwene kakibhegha mumwanja kuhuma kutali kahike kughayihwa malango gha Sulemani. Peni apa mmegha nkulu kupitingana Solomoni! ");
INSERT INTO nww_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Linjubha lya toso, bhandu bha Ninawi bhaayima papamu na kibheleko aki na kubhoneha kukita kibheleko aki kihakata, kiyaha bhene bhakilipetula paannyihwite Yona pakilandamiha. Peni apa mmegha nkulu kupitingana Yona!” ");
INSERT INTO nww_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Kahone mundu ywakakwatiti limbamba na kulihiha ebu kuligubika na nkambo, maha bhangulibhika pakinyuta kyake ngati bhandu bhoha bhalubhone lung'ali. ");
INSERT INTO nww_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Liho ndo limbamba lya mmili ghwako. Handa liho lyako lingubhona tela, mmili ghwako ghwoha ghwabhegha mu lung'ali. Peni handa liho lyako libhoho, mmili ghwako ghwoha ghwabhegha mu lubhindu. ");
INSERT INTO nww_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Hinu, ghulilolekee, lung'ali lughubheghite mu ghwenga ghukotoke kubhegha lubhindu. ");
INSERT INTO nww_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Hinu, handa mmili ghwako ghwoha ghukwila lung'ali, kya nga kipalamande kiibheghite mu lubhindu, ndo mmili aghwo ghwang'aliha tela handa bhula limbamba mulughung'aliha kwa lung'ali lwake.” ");
INSERT INTO nww_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu pakayomolite kuyobhela, nfalisayo yumu kakinnyupa Yesu kaghende kulubhagha lwake kwa kya hilyo. Yesu kakiyingila na kutama na kulyegha. ");
INSERT INTO nww_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yula Nfalisayo kakikangacha kukita Yesu kakikuha ng'obhe mabhoko ghake kukali na kulyegha hilyo, handa payibheghite hitohe yabhe. ");
INSERT INTO nww_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ndo Bambo kaking'ombela, “Mwenga makaafalisayo mungughulula nnobho na kipumbulu kya panje, peni mu mwenga yimema bhulwa na uhakata. ");
INSERT INTO nww_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mwenga ahila mahala! Mungumanya ng'obhe kukita Chapanga ywakabhumbite panje ndo aywo aywo ywakabhumbite nkati? ");
INSERT INTO nww_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Hinu, handa pamuapegha makapukwa himuyibheghite naywo, na hilibhi hyoha yimuyitendite yabhegha nyanyi kwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Peni yaabhegha mipinguhi ya kyabhuli kwa mwenga Makaafalisayo kiyaha mungunpegha Chapanga kimati kya mbinda mabhoko yimo kwa manyahi gha midadangala, na mahambanyungu na makolo gha manyahi matangalo, kangi munguakuluha bhandu na mungunpala ng'obhe Chapanga. Yinguanogha kuyilolekeha huti mihalo aywo kyanga kughabhaya na ghala ghangi ghaannogheha Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ghwaabhegha npinguhi ghwa kyabhuli kwa mwenga Makaafalisayo, kiyaha mwenga mungupala kutama mu hiteho hya kuulongolo pakuhokamilwa mu hitutubhi hya kukonganila, na kulamuhwa kwa kuhokamilwa mu ulongolo ghwa bhandu. ");
INSERT INTO nww_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Gwaabhegha npinguhi ghwa kyabuli kwa mwenga Makaafalisayo, kiyaha mwenga ndo handa mandogholo gha nga matumbila, ghene bhandu bhangughalibhata kya nga kumanya.” ");
INSERT INTO nww_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nhunda yumo ghwa malaghilo kakinnyanga pakilongela, “Pa ghulongela mihalo ayi ghungutuligha na twenga ubhwabhu.” ");
INSERT INTO nww_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu kakinnyanga, “Ghwabhegha npinguhi ghwakyabhuli kwa mwenga ahunda bha malaghilo kiyaha munguapapiha bhandu mihigho ya nga kuhotola kuyitola, na mwenga mungubhatangatila ng'obhe nga kwa kuyinula kikonji. ");
INSERT INTO nww_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Gwaabhegha npinguhi ghwa kyabhuli kwa mwenga, kiyaha munguachengela mandogholo ambuye bha Chapanga bha akomitwe na atate bhenu. ");
INSERT INTO nww_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Hinu, mwenga ndo ayimiho na munguyitikila ndendelo ya aghohi bhenu, kiyaha bhene bhakiakoma abho ambuye bha Chapanga na mwenga munguchengela mandogholo ghabhe. ");
INSERT INTO nww_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Hinu, Chapanga kakilongela naha mu malango ghake, ‘Ndabhayeghela ambuye na andumitumi, peni amoo bhangi mabhakoma na bhangi mamubhabamanda.’ ");
INSERT INTO nww_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Hinu kibheleko aki kyaatoswa kwakya mwahi ghwa ambuye bhoha bha Chapanga bhaakomitwe kutandila kuyimikwa kwa nnima aghu. ");
INSERT INTO nww_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kutandila mwahi ghwa Abeli mbaka Sakalia, ywakakomitwe pakati ya likuta na pakya Chapanga Mukitutubhi kya Chapanga. Kulyaghila nunguaghombela, kibheleko aki kyaatoswa kwa kya agho ghoha.” ");
INSERT INTO nww_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ghwaabhegha npinguhi ghwa kyabhuli kwa mwenga ahunda ghwa malaghilo, kiyaha mungukibhua kihughulo kya nlyango ghwa mahala gha kunmanya Chapanga. Mabhene munguyingila ng'obhe na bhala bha apalite kuyingila munguakanikiha.” ");
INSERT INTO nww_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu pakabheghite mukubhuka akwo, ahunda bha malaghilo na Akaafalisayo bhakiyanda kunpingikiha muno na kunnyuka kwa ngonyo tangalo, ");
INSERT INTO nww_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","apati kuntyegha na kunkamula pakilongela kyohele kihakata. ");
INSERT INTO nww_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Lumati lukulu lwa bhandu akaelufu kwa aelufu bhakinkwemukila mbaka bhakilibhatana, Yesu kakiyanda kulongela huti na ahundwa bhake, pakiaghombela, “Mulindakile na linjacha lya Akaafalisayo, ndo ufyangu ghwabhe. ");
INSERT INTO nww_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kahone nhalo ghwohele ghuugubikitwe ghwene ghwa nga kuhughulighwa ebu nhalo ghwa mbwepo ghwa nga kumanyikwa. ");
INSERT INTO nww_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Hinu, lyoheli limulikambuka palubhindu bhandu bhaaliyihwa paulangalo, na kila kinpwepite panga bhandu munyumba kati pantata nlyango, kyalandamighwa palunyakaa.” ");
INSERT INTO nww_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nunguaghombela mwenga maaghanja bhangu, nkotoke kubhayoghopa bhala bhaaukoma mmili na mbole ya alyo anguhotola ng'obhe kutenda nnando ghwohele. ");
INSERT INTO nww_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ndabhaghombela ghwa kunnyoghopa ndo ghani, munnyoghope yula mwene mbole ya kughukoma mmili, kana makakala gha kuatagha kumambe. Nunguaghombela kulyaghila munnyoghope aywo.” ");
INSERT INTO nww_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Mungumanya kukita njegheha nhano bhanguhemelwa kwa mbiya njoko munu, peni Chapanga kangunnibhalila ng'obhe hata nga yumo. ");
INSERT INTO nww_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hata mbalangwo ya hwili hya mitwe hyenu hikibhalangwa hyoha. Hinu, nkotoke kuyoghopa, mwenga ndo ghwa utopelo kupitingana njegheha atangalo.” ");
INSERT INTO nww_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nunguaghombela kukita ywohele yunakunnyitikila nenga muulongolo ghwa bhandu, Mwana ghwa Mundu naywo katannyitikila muulongolo ghwa mahoka bha Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Peni yula ywakangiluka muulongolo ghwa bhandu, Mwana ghwa Mundu naywo katankiluka muulongolo ghwa mahoka bha Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ywohele ywakakambuka lilagho lya uhakata kwa kya Mwana ghwa Mundu, Chapanga katalekekeha ulemwa ghwake, peni ywohele ywakantendela ufyangu Nhuki ghwa Chapanga, Chapanga katanlekekeha ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Paabhayegha na kuayingila mu hitutubhi hya kukonganila Akaayahudi, na muulongolo ghwa atabhala na bhana makakala ili kubhakokela, nkotoke kubhegha na bhwaghalili yakya kulongela ebu yakya kuyanga. ");
INSERT INTO nww_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kiyaha Nhuki ghwa Chapanga kataahunda mu lisaa alyo alyo kyene kiyinoghwa kukambukwa.” ");
INSERT INTO nww_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Habhu mundu yumo mulula lumati lwa bhandu kaking'ombela Yesu, “Nhunda, ghunkwilikihe nnongo ghwangu tukaghabhane lipala lyakatulekihite tate ghwetu.” ");
INSERT INTO nww_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Peni Yesu kaking'ombela, “Nng'anja, ndo ghani ywakandamite nenga meghe nndumula nongwa na nghabhanila utopelo nkati yenu?” ");
INSERT INTO nww_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ndo Yesu kakiaghombela, “Mulindakile na mulikingikihe na kila ughwimi ghwa utopelo. Kiyaha ubhumi ghwa mundu ghunguhuma ng'obhe mu utopelo ghwakabheghite naghwo.” ");
INSERT INTO nww_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ndo Yesu kakiaghombela ndambulo ayi, “Nng'unda ghwa mundu yumo yunautopelo ghukipambika muno. ");
INSERT INTO nww_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Naywo kakihwacha mumwoyo ghwake, ‘Luhanja lwangu ludokwa. Hinu ndatenda niki?’ ");
INSERT INTO nww_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ndo aywo yunautopelo kakilighombela, ‘Ndalupaghula luhanja lwangu lwa mbunje na kuchenga lungi lukulu na akwo ndaghabhika mabeno ghangu. ");
INSERT INTO nww_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Na nenga ndaghughombela mwoyo ghwangu, ghwenga ghubhegha na hilibhi hya maha hitangalalite hyene ghulibhikilite kwa ngungwa ndangalo. Hinu ghupughwe, na ghulyeghe, na ghunyweghe na ghuyelelwe.’ ");
INSERT INTO nww_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Peni Chapanga kakinng'ombela, ‘Ghwenga nmughabhugha mumwoyo! Uhiku aghu ghwaahwegha, hinu ahyo hilibhi ghuhibhikite hyabhegha hya ghani?’ ” ");
INSERT INTO nww_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu kakiyomola kughomba pakalongela, “Habhu ndo yibha kwa Mundu yunakulibhikila utopelo kwa kya ywombe, peni ywa nga utopelo mu ulongolo ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Mbole Yesu kakiaghombela ahundwa bhake, “Nkotoke kubhegha na bhwaghalihi yakya hilyo muhipalite kwa ubhumi ebu yakya mapinda mughapalite kwa kya mibhili yenu, ");
INSERT INTO nww_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","kiyaha ubhumi ndo ghwa maha kupitingana kwa hilyo na mmili ndo ghwa maha kupitingana kwa mapinda. ");
INSERT INTO nww_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mubhahwachile makungulu! Bhene angukanda kanda ng'obhe ebu abhegha na hihanja ng'obhe, peni Chapanga kangualyegheha. Mwenga ndo bha utopo kupitingana kwa hiyuni. ");
INSERT INTO nww_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ndo ghani aywo mu mwenga ywene kwa kulighaha katahotola kughuyonjokeha ubhumi ghwake nga kwa lisaa limo? ");
INSERT INTO nww_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Handa mungulepelwa kutenda nhalu nchoko handa habhu, hinu kiyaha niki kulighaha kwa kya ghangi? ");
INSERT INTO nww_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mughalolekehe malubha paghamela, ghangutenda lihengo ng'obhe ebu kupota mapinda, hata mwene Sulemani na ukulu ghwake ghwoha kakihwalihwa ng'obhe handa limoo lya malubha agho. ");
INSERT INTO nww_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Hinu handa Chapanga kangughahwaliha habhu manyahi gha kunng'unda ghene ghabhegha lelo na kilabho ghangutaghwa mumwoto, maha ng'obhe kwa mwenga kataahwaliha ng'obhe mwenga bha uhyubhalilo nchoko!” ");
INSERT INTO nww_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Hinu, nkotoke kulighaha mu myoyo yenu kukita maalyegha niki ebu maanywegha niki. Nkotoke kubhegha na bhwaghalili ya kya agha. ");
INSERT INTO nww_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Bhandu bhangabhegha ng'obhe Ayahudi na bhanga kunmanya Chapanga angulighaha munu kya hilibhi ahi hyoha hya munnima. Peni Tate ghwenu ghwa kunani kangumanya kukita munguhipala. ");
INSERT INTO nww_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Hinu mughughayighayile huti Ghubhutwa ghwa Chapanga na hilibhi hyoha kataapegha.” ");
INSERT INTO nww_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Nkotoke kuyoghopa mwenga kimati kichoko, kiyaha Tate ghwenu kabhona maha kuapegha mwenga Ghubhutwa. ");
INSERT INTO nww_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Muhemengane hilibhi yenu mukaapeghe makapukwa ahyo mbiya. Akwo ndo kulibhikila utepelo kunani kwa Chapanga kughubheghite na mihako ya mbiya yanga hakala, mukayibhikile utopelo ghwa nga kupela kunani kwa Chapanga, apwo mwihi kahika kata ebu hipuluputu ghwahika kata. ");
INSERT INTO nww_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kiyaha paghubheghite utopelo ghwako, ndo akwo na mwoyo ghwako ghwaabhegha.” ");
INSERT INTO nww_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mmeghe kala kunndendela lihengo kunu mambamba ghenu paghayaka. ");
INSERT INTO nww_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Handa andumindumi bhaanlindila bambo ghwabhe pakabhegha mu kubhuya kuhuma ku chekwa ya kutolana, ngati pa kahika na kughutiti nlyango kamu apati kunhughulila nlyango. ");
INSERT INTO nww_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bhaanonelwa bhala abhandwa bhene bambo ghwabhe pakahika kataabhona bhangaghonja. Kulyaghila ninguaghombela, katalibhika kala na kuakema mu hilyo, naywo katahika kuakeyela. ");
INSERT INTO nww_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bhaanonelwa kwa andumindumi abho bhene nkulu ghwabhe pakahika kaakongela bhangakughonja hata handa katahika pakilo muno, ebu ugheghela na malabhila. ");
INSERT INTO nww_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Peni mughumanye nnando aghu kukita, handa nkola kaya kangamanyite, lisaa lyoki mwihi kaahika, kangakilekite ng'obhe kitutubhi kyake kikanjaghanwe. ");
INSERT INTO nww_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Na mwenga yinguakwiliha mmeghe kala manjubha ghoha, kiyaha Mwana ghwa Mundu katahika lisaa lya nga kumanyika.” ");
INSERT INTO nww_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ndo Petili kakinkonya, “Bambo, ndambulo ayi ghungutughombela twenga ebu ghunguaghombela bhandu bhoha?” ");
INSERT INTO nww_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yesu kakinnyanga, “Ndo ywoki aywo nndumindumi ywa kuhyubhalika na yuna malango, ywene bambo ghwake katammika kubhegha nkola abhandwa mu abhandwa ayake ngati kabhapeghe hilyo mulisaa lya kulegha? ");
INSERT INTO nww_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kanonelwa nbhandwa aywo pala pakabhuya bambo ghwake katankonga kangutenda habho. ");
INSERT INTO nww_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nunguaghombela hoto, katanpegha utabhala mu hilibhi hyoha hyakabheghite nahyo. ");
INSERT INTO nww_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Peni handa yula nbhandwa kaahwacha mu mwoyo ghwake, bambo ghwake kangukabhalila kubhuya na kuyanda kuatuta bhala andumitumi alumi na adala ubhwabhu kangulyegha na kunywegha na kulobhela ughimbi, ");
INSERT INTO nww_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","bambo ghwake yula nbhandwa katahika mulinjubha lyangamanyikwa. Aywo bambo ghwake katantosa kyanga luhungu na kummika papamu na bhanga hyubhalika.” ");
INSERT INTO nww_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Nbhandwa yunakughamanya mapalo gha bambo ghwake peni kalibhike kala ng'obhe hangi kutenda handa ghaghannogha kutenda, aywo katatutwa hinjupunjupu ndangalo. ");
INSERT INTO nww_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Peni yula ywanga kumanya na kakatende ghala ghannogha kututwa, katatutwa kachoko. Ywohele ywakakamuhitwe hilibhi hitangala, kataghambwa hilibhi ndangalo na ywohele ywakakamuhitwe kutenda lihengo likulu kataghambwa nalumu.” ");
INSERT INTO nww_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Hika kukwata mwoto mu nnima, ningupala handa ghungabheghite ghuyaka kala! ");
INSERT INTO nww_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Peni megha na ubatiso ghungungwiliha nbatiswe, na nenga megha na himbamanda yingwilihite kukamuhwa na ndayendelela kubhegha na luhuyu mu mwoyo ghwangu mbaka ubatiso ghwangu ghutwihilike! ");
INSERT INTO nww_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Munguhwacha kukita hika kughuyegha uhihimilo mu nnima? Ng'obhe, hika kuyegha ulekano. ");
INSERT INTO nww_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kutandila hinu, mu lubhagha lumo lwa bhandu nhano lwaaghabhanika, andatu kwa abhili na abhili kwa andatu. ");
INSERT INTO nww_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tate kaasighana na mwana ghwake nnume na mwana nnume kwa tate ghwake, ma kwa nhinja ghwake na nhinja kwa ma ghwake, nkohano nndala kwa nndala ghwa mwana ghwake na nkohano kwa ma ghwa nndala ghwake.” ");
INSERT INTO nww_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ubhwabhu abhu Yesu kakilughombela lula lumati lwa bhandu, “Pamulibhona lihundi palihuma ku lutipikila luchubha, kamu mungulongela, hula yaakoma na kya hoto yaakoma. ");
INSERT INTO nww_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na pammona likusi kuhuma ku mbande ya kusini lingupula, mungulongela, kwaabhegha na lupyupo na kya hoto kwaabhegha lupyupo. ");
INSERT INTO nww_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mwenga maafyangu! Mungumanya nndaluko ghwa ngungwa kwa kughulolekeha nnima na kunani kubhwelo pakubheghite. Mungulepelwa bhuli kughumanya fwambulo ya mihalo yiitendikite hinu?” ");
INSERT INTO nww_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Kiyaha niki mungulepelwa kughatosa na kughatughila ghakaghapala Chapanga? ");
INSERT INTO nww_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Paghubhegha munjila na nmyanja ghwako kughenda kwa nndumula nongwa, mbaha ghulingane malobhe naywo munjila amwo ngati kakakulekekehe. Handa chepa katakughegha kwa nndumula nongwa, naywo nndumula nongwa katakutosa na katakukamuha kwa machonda naywo machonda katakutagha kukibhopo. ");
INSERT INTO nww_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ninguaghombela hoto, ghwabhuka ng'obhe amwo mbaka ghuyomole mbiya yako hyoha.” ");
INSERT INTO nww_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mu lisaa lilalila, akibhegha bhandu bhaanng'ombilite Yesu ya kya mihalo ya Akaagalilaya bha akomitwe na Pilato na mwahi ghwabhe ghukihanganganika na nyambi yabhe ya kuyochwa. ");
INSERT INTO nww_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu kakiakonya, “Munguhwacha kukita Akaagalilaya abho bhaakomitwe akibhegha na ulemwa kupitingana kwa Akaagalilaya bhangi bhoha? ");
INSERT INTO nww_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aka kaa, na mwenga handa malipetula ng'obhe maahwegha ubhwabhu abhu. ");
INSERT INTO nww_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ebu bhala bhandu mbinda mabhoko yimo na nane bha ahweghite kwa kuponekelwa na nnala akwo Siloamu, habhu munguhwacha kukita bhene akibhegha alemwa kupitingana kwa bhangi bhoha bhaatamiteghe ku Yelusalemu? ");
INSERT INTO nww_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nunguaghombela, aka kaa, na mwenga handa malipetula ng'obhe na kunbhuyila Chapanga, bhoha maakanjabhanika ubhwabhu abhu.” ");
INSERT INTO nww_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mbole Yesu kakiaghombela ndambulo ayi, “Mundu yumu kakibhegha na nkongo ghuukemitwe ntini ghuumelihitwe munng'unda ghwake ghwa misabibu, kakihika kupalaha tini munkongo ghwa tini, peni likinhobha ng'obhe na limo. ");
INSERT INTO nww_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Habhu kakinng'ombela nndumindumi ghwa nng'unda ghula, ‘Ghulole, kya ngungwa ndatu nikihika kupalaha mapambiko munkongo aghu ghwa tini, na likinhobha ng'obhe na limo. Hinu ghuudumule, kiyaha niki ghunguhanjaghana lutupi?’ ");
INSERT INTO nww_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Yula nndumindumi ghwa nng'unda kakinnyanga, ‘Bambo, ghuuleke kangi kwa ngungwa yimo, na nenga ndaghukimbulila lutupi na kughubhikila mbosela. ");
INSERT INTO nww_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Handa paghupambika mapambiko mu ngungwa yipala kuhika yabhegha maha, hela bhubho ghuudumule.’ ” ");
INSERT INTO nww_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mu Linjubha limo lya kupumulila, Yesu kakibha pakihunda Mukitutubhi kimo kya kukonganila Akaayahudi. ");
INSERT INTO nww_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mu lisaa alyo alyo kakihika nndala yumo ywakabheghite na lindilu, naywo kakipimbitala nng'ongo kwa ngungwa mbinda mabhoko yimo na nane kubhukana na lindilu alyo, hangi kakihotola ng'obhe kuligholoha. ");
INSERT INTO nww_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu pakammonite kakinkema na kakinng'ombela, “Nhumbu, ghulamihwa utamwa ghwako.” ");
INSERT INTO nww_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kakinnyabhikila mabhoko kamu mmili ghwake ghukigholoka kangi na kakiyanda kuntika Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Peni kilongohi ghwa kitutubhi kya kukonganila Akaayahudi kakikalala kiyaha Yesu kakinlamiha aywo nndala mu Linjubha lya Kupumulila. Hinu kakiaghombela bhala bhandu bha akwemukite pala, “Mmegha na manjubha nhano na yimo ya kutenda lihengo, mumanjubha agho ndo nhike kulamihwa, ngati ng'obhe mu Linjubha lya Kupumulila.” ");
INSERT INTO nww_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Peni Bambo kakinnyanga, “Mwenga maafyangu! Ndo ghani aywo munkati yenu mwene ywanga kulihughulila likambako lyake lya senga ebhu kaputa ghwake kuhuma mu lubhigho na kunng'egha pakulyegheha Mulinjubha lya Kupumulila? ");
INSERT INTO nww_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Hinu, ayu nndala, nhinja ghwa kibheleko kya Abulahamu, ywakabhopitwe na nchipila kwa ngungwa mbinda mabhoko yimo na nane, yikinoghela ng'obhe kuhughulighwa mu kibhopo akyo Linjubha lya Kupumulila?” ");
INSERT INTO nww_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu pakalongilite agha, amyanja bhake bhala bhaatamiteghe ulamo ghwa utyahe bhakibhona honi kiyaha bhandu bhakiyelelwa kwakya mihalo ya mihabho ghakaghatendite. ");
INSERT INTO nww_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Mbole Yesu kakikonya, “Ghubhutwa ghwa Chapanga ghungulihwana na niki? Na ndaghulandaniha na niki? ");
INSERT INTO nww_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ghulihwana na mbeyu yiikemitwe haladali yiibheghite njoko mumo, mundu yumu kakiyitola na kuyimeleha munng'unda ghwake. Naywo yikimela, yikibha nkongo nkulu na hiyuni hya kunani akichenga hiyumba yabhe mumapanyo ghake.” ");
INSERT INTO nww_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu kakiakonya kangi, “Ndaghuhwananiha Ghubhutwa ghwa Chapanga na niki? ");
INSERT INTO nww_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ghulihwana na linjacha, lyene nndala kakilitola na kulihangangana na hipalo indatu ya ukobha mbaka ghwoha ghukikwina.” ");
INSERT INTO nww_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu kakibhutukila mu hitami na hijiji pakilandamiha pakabheghite mu mwanja ghwake kughenda ku Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mundu yumo kakinkonya, “Bhuli Bambo, ndi bhandu bhaapala kulopoleghwa bhaabhegha bhamandina?” Yesu kakinng'ombela, ");
INSERT INTO nww_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mulitumbe kuyingila kya kupitila nlyango ghuukepite, kiyaha nunguaghombela, bhandu atangalo bhatalitumba kuyingila peni bhaahotola ng'obhe. ");
INSERT INTO nww_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Lisaa lya nkola kitutubhi pakapala kutata nlyango, maayima panje paankong'onda nlyango na pang'omba, ‘Bambo, Ghutuhughulile nlyango.’ Peni ywombe kataayanga, ‘Nubhamanya ng'obhe hangi kwoki kunhumite.’ ");
INSERT INTO nww_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Na mwenga matanng'ombela, ‘Ndo tukinywegha na kulyegha papamu na ghwenga, kangi ghukituhunda mu hijiji hyetu!’ ");
INSERT INTO nww_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Peni ywombe kataayanga, ‘Ninguamanya ng'obhe mwenga ebu kunhumite. Nmuke kwa nenga, mwenga atenda ulemwa!’ ");
INSERT INTO nww_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Apwo ndo maalila na kuhyagha mino, pannonda kummona Abulahamu na Isaka na Yakobu na ambuye bhoha bha Chapanga paakibhegha mu Ghubhutwa ghwa Chapanga, pala mwenga pantaghwa panji. ");
INSERT INTO nww_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bhandu bhaahika kuhuma kumbande hyoha ya nnima, kungeha na kulutipikila luchubha, na Kukaskazi na kukusi, nabho bhaatama muchekwa mu Ghubhutwa ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nnole bhala bhaabheghite bhaunyuma bhaabhegha bhaulongolo nabho bhaulongolo bhaabhegha bhaunyuma.” ");
INSERT INTO nww_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mu lisaa alyo amoo bha Akaafalisayo bhakinng'endela Yesu na bhaking'ombela, “Ghubhuke apa na ghughende pamoo pangi kiyaha Helode kangupala kughukoma.” ");
INSERT INTO nww_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu kakiayanga, “Nng'ende mukanng'ombele yula kibweha naha, ‘Ndaghabhingabhinga mandilu na kughalamiha atamwa lelo na kilabho, na mu linjubha lya ndatu ndaliyomolela lihengo lyangu.’ ");
INSERT INTO nww_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yingunnoghela kuyendelela na mwanja ghwangu lelo, kilabho na pamalabho, kiyaha yinoghela ng'obhe mbuye ghwa Chapanga kakomwe pa kitami kingi ngati nga pa Yelusalemu.” ");
INSERT INTO nww_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Mwenga ma bhandu bha ku Yelusalemu! Ghwenga ghuakomagha mambuye bha Chapanga na kuatuta maganga bhala bhaalaghilitwe kwa mwenga! Palingi mbaliteghe kuakwemula bhana bhako papamu handa kiyuni pakaayubhatila bhana bhake mumambapatilo ghake kwakya kuakingikiha, peni ghukilema! ");
INSERT INTO nww_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Hinu nnole, Kitutubhi kya Chapanga ghwenu kyalekwa mang'obha, nunguaghombela mamona kangi ng'obhe mbaka lisaa lila panmbala kulongela, ‘Kanonelwa aywo ywakalaghilitwe kwa lihina lya Bambo.’ ” ");
INSERT INTO nww_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Linjubha limo lya Kupumulila Yesu kakighenda kulyegha hilyo ku lubhagha lwa yumoo ywa kilongohi ghwa Akaafalisayo, na bhandu bhaakibhegha apwo bhangunhingukiha. ");
INSERT INTO nww_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Bahala pala mu ulongolo ghwake kakibhegha mundu ywakabheghite na utamwa wa kutupa mmili. ");
INSERT INTO nww_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu kakiakonya bhala Akaafalisayo na ahunda bha malaghilo, “Patughatughila malaghilo, bhuli ghangututegheka ebu ng'obhe kualamiha bhandu Mulinjubha lya Kupumulila?” ");
INSERT INTO nww_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Peni bhombe bhakitama nuu. Habhu Yesu kakinkamula kibhoko yula ntamwa na kakinlamiha, na kakintegheka kaghende ukaya kwake. ");
INSERT INTO nww_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mbole Yesu kakiakonya bhombe, “Handa yumoo ywenu kangabheghite na mwana ebu likambako lya senga ghwakachumbukilite mu kilibha Linjubha lya Kupumulila, bhuli, mangannekite kya nga kummuha?” ");
INSERT INTO nww_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Na bhandu abho bhakihotola ng'obhe kunnyanga. ");
INSERT INTO nww_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu pakabhonite bhala ahenja bhaalalikitwe anguhaghula hiteho hya kuulongolo pauhokamilo lisaa lya mulyo, ndo kakiaghombela ndambulo ayi. ");
INSERT INTO nww_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Mundu pakaghulalika ku chekwa ya kutolana, ghukotoke kutama pa kiteho kya kuulongolo, kiyaha pangi kanlalika mundu yungi ywa kuhokamilwa kupitingana kwa ghwenga, ");
INSERT INTO nww_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","handa pantenda naha yula ywakaalalikite mwenga maabhili, katahika na kughughombela, ‘Ghunlekele mundu ayu katame mu kiteho kyako.’ Ndo kwa honi yaghukwiliha kutama ku kiteho kya unyuma. ");
INSERT INTO nww_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mbole yake handa paghulalikwa, ghutame kukiteho kya unyuma ngati yula nkolakaya ghwako pakaghubhona katahika na kukughombela, ‘Ghanja ghwangu, ghuhike ghutame mung'ebhu ya akulu paulongolo.’ Apwo ndo ghwakwehwa mu ulongolo ghwa ahenja ayako bhoha. ");
INSERT INTO nww_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kiyaha mundu ywoheli ywakalikweha kaahuluhwa, na ywakalihuluha kaakwehwa.” ");
INSERT INTO nww_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mbole Yesu kakinng'ombela yula ywakaalalikite, “Paghutendekeha chekwa ya hilyo ya pamuhi ebu ya makimuhi, ghukotoke kualalikiha aghanja bhako ebhu alongo bhako bhaabheghite na utopelo ghweka chabhe. Handa paghutenda habhu na bhene bhaghukulalika kwabhe, na ghwenga ghwabhuyihilwa kila kighuatendilite na ghwamokola lilumbo lyako kala. ");
INSERT INTO nww_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kihyengo kyake handa paghutenda chekwa, ghubhalalike akapukwa, bhanautebhalo na bhangabhona, ");
INSERT INTO nww_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","na ghwenga ghwaanonelwa kiyaha abho abhegha nakyo ng'obhe kya kughubhuyihila. Chapanga kaghupegha lilumbo lyako pala bhandu bhaaghatughila ghala ghakaghapala Chapanga paahyuka.” ");
INSERT INTO nww_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Hino yumoo ywa bhala bhandu ywakatamite papamu na Yesu pakayihwite agha kaking'ombela Yesu, “Kanonelwa mundu yula ywakapalakulyegha mumulyo ghwa Ghubhutwa ghwa Chapanga!” ");
INSERT INTO nww_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu kakiaghombela bhombe, “Mundu yumu kakibhegha mu kutendekeha chekwa ngulu, kakialalika bhandu atangalo. ");
INSERT INTO nww_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Lisaa lya chekwa palihikite kakialaghila abhandwa bhake bhakaaghombele bhala bhakaalalikite, ‘Nhike, kiyaha kila kilibhi kibha kala.’ ");
INSERT INTO nww_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Peni bhoha yumu mbole ya yungi bhakiyanda kulongela kinlemikihite kuhika muchekwa. Ghwa ulongohi kakilongela, ‘Hemela nng'unda, na yingwiliha ng'ende kughubhona, chonde ketekete nughukuyupa ghunekekehe.’ ");
INSERT INTO nww_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mundu yungi kakilongela, ‘Hemela likambako lya senga mbinda libhoko yimo bha kukanda lutupi, hinaa nungughenda kubhayighihila kukanda, chonde ketekete nughukuyupa ghunekekehe’ ");
INSERT INTO nww_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Na mundu yungi kakilongela, ‘Ndolela nndala hinu hinu, habhu ndaahika kata.’ ");
INSERT INTO nww_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Yula nbhandwa kakibhuya, na kakinng'ombela bambo ghwake mihalo yila. Ndo yula nkola kaya kakikalala, kakinlaghila yula ndumindumi pakilongela, ‘Ghughende kya kuyumbatika mu njila na mu hijiji hyoha, ghubhayeghe apa makapukwa, angwabhengwabhe, bhangalola na atebhaho bhangi.’ ");
INSERT INTO nww_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mbole yula nbhandwa kakibhuya na pakilongela, ‘Bambo, ghala ghunaghilite nighatenda kala, peni yikali yihighala ng'ebu mu ludamu.’ ");
INSERT INTO nww_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ndo yula Bambo kaking'ombela nbhandwa bhake, ‘Ghughende munjila na hijiji hibheghite panje ya kitami na ghubhakwilikihe bhandu bhayingile ili lubhigho lwangu kimeme. ");
INSERT INTO nww_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Peni ninguaghombela, kahone hata yumu ywa bhala bhanialalikite ywaapaha hilyo hya Chekwa ya nenga.’ ” ");
INSERT INTO nww_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Lumati lukulu lwa bhandu lukibhegha lungulongohana na Yesu, naywo kakikilibhuka na kakilighombela, ");
INSERT INTO nww_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mundu ywohele ywakahika kwa nenga, kaahotola ng'obhe kubhegha nhundwa ghwangu handa katambala ng'obhe nenga kupitingana tate ghwake, ebu ma ghake, ebu nndala ghwake na bhana bhake, ebu alongo bhake, ebu ahacha bhake, ena, na hata ubhumi ghwake mweni. ");
INSERT INTO nww_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ywohele yunakutola ng'obhe lupingika lwake na kundughila nenga kaabhegha nhundwa bhangu kata. ");
INSERT INTO nww_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nleki huti nubhaghombele, ndo ghani mumwenga, mwene handa kapala kuchenga nnala, katatama ng'obhe pahi na kuyibhalanga utahuko ghwake kaghubhone kukita kabha na ngalabha hya kukiyomolela? ");
INSERT INTO nww_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Hela bhubho, mbole ya kuchenga kitamilo kya maganga na kulepelwa kuhotola kughuchenga nnala, bhandu bhoha bhaamona bhaayanda kunheka, ");
INSERT INTO nww_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","paalongela, ‘Mundu ayu kakiyanda kuchenga, peni kakihotola ng'obhe kuyomola.’ ");
INSERT INTO nww_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ebu ndo Mutwa ywoki ywakabhuka kughenda ku mikoha kututana na mutwa yungi, na kakotoke kuhwacha huti kahotola kututana mikoha na kukita handa kabhegha na machonda mbinda libhoko elufu kaahotola kuntuta yula ywakahika na machonda mbinda mabhoko ibhili elufu? ");
INSERT INTO nww_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Handa kaabhona katalepelwa, katabhalaghila atangatila bhake aghende kukongana na yula mutwa yungi, ayupe mihilo ya uhihimilo, pala yula mutwa yungi pakakali kutali. ");
INSERT INTO nww_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ubhwabhu abhu, kahone na yumu mu mwenga kaahotola kubha nhundwa ghwangu handa kataleka ng'obhe hyoha hyakabheghite naywo.” ");
INSERT INTO nww_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mwinyu ndo kilibhi kya maha, peni handa mwinyu paghululuka, kahone kya kutendelwa ngati yibhe kangi mwinyu. ");
INSERT INTO nww_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ghwanogha ng'obhe kwa lutupi ebu kwa mbosela, ngati ghwataghwa hela. Yunamakutu gha kuyihwa, kakayihwe.” ");
INSERT INTO nww_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Linjubha limo, asumula sumu na bhanaulemwa bhoha bhakighenda kunnyihwa Yesu. ");
INSERT INTO nww_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Peni Akaafalisayo na ahunda bha malaghilo bhakinkukulikila Yesu pakalongela, “Mundu ayu kanguakingama bhanaulemwa na kangulyegha papamu nabho!” ");
INSERT INTO nww_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ndo yesu kakiayanga kwa ndambulo ayi. ");
INSERT INTO nww_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Handa yumoo ywenu kana mene mbinda maboko kumi na pakamanya kukita yumoo ywabhe kahobha. Hinu, katabhaleka ng'obhe bhala mbinda maboko tisa na tisa mu manyahi na kughenda kunpalaha yula ywakahobhite mbaka kakanpate? ");
INSERT INTO nww_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Na mbole ya kunmona, katayelelwa na katanpapa mu makombi ghake, ");
INSERT INTO nww_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","na kughenda ku lubhagha lwake na kuakema aghanja bhake na agheghela na kuaghombela, ‘Nnyelelwe papamu na nenga, kiyaha nunmona mene ghwangu ywakahobhite.’ ");
INSERT INTO nww_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ubhwabhu abhu ninguaghombela, kwaabhegha na uyelelo munu kunani kwa Chapanga kwakya yunaulemwa yumu ywakalipetula, kupitingana kwa bhandu mbinda mabhoko tisa na tisa bhanakulidumbila kukita bhene ndo bhangughatughila ghakaghapala Chapanga, na bhanga kulipetula.” ");
INSERT INTO nww_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesu kakiaghombela ndambulo yingi, pakalongela, “Tulongele, nndala yumu kabha na njuluku mbinda mabhoko yimu, naywo kayihoha yimu, hinu kaatenda niki? Katakwata ng'obhe limbamba na kulupyaghila lubhagha na kuyipalaha mbaka kayibhone? ");
INSERT INTO nww_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na mbole ya kuyimokola, kataakema aghanja bhake na andamani bhake na kuaghombela, ‘Nnyelelwe papamu na nenga, kiyaha niyibhona yila njuluku yangu yiniihohite!’ ");
INSERT INTO nww_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ubhwabhu abhu nunguaghombela, kwaabhegha na uyelelo muulongolo ghwa mahoka bha Chapanga kwa yunaulemwa yumu ywakalipetula na kunbhuyila Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu kakighendelela kulongela, “Kukibhegha na mundu yumu ywakabheghite na bhana abhili alume. ");
INSERT INTO nww_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yula nndokwa kaking'ombela tate ghwake, ‘Tate, ghumbeghe kipalamande kyangu kya utopelo.’ Habhu kakiabhaghulila bhana bhake utopelo ghwake. ");
INSERT INTO nww_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mbole ya manjubha gha mandina, yula nndokwa kakikungana hilibhi hyoha hyakabheghite nahyo, na kakighenda kutama kunnima ghwa kutali na akwo kakighupwilingana utopelo ghwake kwa utyahe. ");
INSERT INTO nww_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Mbole ya kuyomola kutumila hilibhi yake hyoha hyakabheghite naywo, lukibwituka lung'ahe lwa njala mu nnima ghula ghwoha, naywo kakibhegha ng'obhe na kyohele. ");
INSERT INTO nww_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ndo kakighenda kuyupa lihengo kwa nkolannima yumu ghwa nnima ghula naywo kakinnyegha ku nng'unda mundu aywo kualyegheha maghulubhe. ");
INSERT INTO nww_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nhongolo yula kakibha na njala munu na kakipalagha kulyegha manganju ghaalyeghiteghe bhala maghulubhe, kiyaha kahone mundu ywakanpeghite kilibhi. ");
INSERT INTO nww_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Peni pakalihwachilite mumwoyo ghwake, kakilongela, ‘Bhabhegha andumindumi atangalo kwa tate ghwangu bhene angulyegha na bhanguleka mahighalo, na nenga nunguhwegha apa kwa njala! ");
INSERT INTO nww_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ndabhuka na kubhuya kwa tate ghwangu na kunng'ombela, Tate ndenda ulemwa kwa Chapanga kunani na nughuhokela ghwenga tate. ");
INSERT INTO nww_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yingunnoghela ng'obhe kukemwa mwana ghwako, ghundende handa yumoo ywa nndumindumi bhako.’ ");
INSERT INTO nww_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Hinu, kakiyinuka na kakiyanda kubhuya kwa tate ghwake.” “Peni pakabheghite kakali kutali, tate ghwake kakimmona, mwoyo ghwake ghukimemekwa luhungu, kakintughila, kakinnyubhatila kwa upalo. ");
INSERT INTO nww_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Yula mwana kaking'ombela tate ghwake, ‘Tate, ndenda ulemwa kwa Chapanga kunani na nighuhokela ghwenga. Yingunnogha ng'obhe kukekwa mwana ghwako kangi.’ ");
INSERT INTO nww_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Peni tate ghwake kakiaghombela abhandwa bhake, ‘Munnyeghele lighwanda litandamaho linyelembite kya kuyumbatika na munhwalihe, munhwike pete mukikonji kyake na makobasi mumaghulu ghake. ");
INSERT INTO nww_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Munnyeghe lyana lya senga ywakahatite na munhinje, ngati tubheghe na chekwa, tulyeghe na kuyelelwa. ");
INSERT INTO nww_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kiyaha ayu mwana ghwangu kakibhegha handa kahwegha, na hinu kangulama, kangi kakihobha, naywo kabhuya ukaya!’ Nabho bhakiyanda kutenda chekwa.” ");
INSERT INTO nww_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Mulisaa alyo yula mwana ghwake nkulu kakibhegha kunng'unda. Pakabheghite mukubhuya ugheghela na lubhagha lwabhe, kakiyihwa bhandu paayimba na kukina. ");
INSERT INTO nww_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kakinkema yumoo ywa andumitumi na kakinkonya, ‘Kubhegha na niki apa?’ ");
INSERT INTO nww_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yula ndumindumi Kakinnyanga, ‘Nnung'una ghwako kahika, naywo tate ghwako kanhinjila lyana lya senga ywakahatite kiyaha mwana ghwake kabhuya kakali kangulama.’ ");
INSERT INTO nww_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Yula mwana nkulu kakikalala na kakilema kuyingila mukitutubhi. Ndo tate ghwake kakighenda panje kunnyupa ngati kayingile munyumba. ");
INSERT INTO nww_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Peni ywombe kakinnyanga tate ghwake, ‘Nnole! Mungungwa ahi hyoha nikighutendela lihengo na kyanga linjubha lyene linemite lilaghilo lyako, peni ghukimbegha ng'obhe nga likambako lyana lya mbuhi ngati nyelelwe papamu na aghanja bhangu. ");
INSERT INTO nww_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Peni aywo nnung'una ghwangu mwana ghwako ywakapwilinganite utopelo ghwako kwa atyahe pakabhuyite ukaya ghwenga ghunhinjila lyana lya senga lyakahatite!’ ");
INSERT INTO nww_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tate ghwake kakinnyanga, ‘Mwana ghwangu, ghwenga ghubhegha na nenga manjubha ghoha na hyoha niibheghite nahyo ndo hyako. ");
INSERT INTO nww_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Peni yingutunogha kuyelelwa kwa hilulu kiyaha aywo nnung'una ghwako kakihwegha hinu kahyuka, kakihobha hinu kabhuya kutama ukaya.’ ” ");
INSERT INTO nww_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Mbole Yesu kakiaghombela ahundwa bhake, “Pakibhegha yunautopelo yumu ywakabheghite na nkola abhandwa ghwake. Bhandu bhakinkokehela aywo nnyimilila kwa nkulu ghwake kukita kangupwilingana utopelo ghwa ghwake. ");
INSERT INTO nww_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ndo aywo yunautopelo kakinnkema na kunkonya, ‘Ndo nnando ghwoki aghwo ghunighuyihwa ghwakya ghwenga? Hinu ghunmbeghe mbalango gha motelo na malyeghelo gha utopelo ghwangu, kiyaha yingukunoghela ng'obhe ghubhe nnyimila ghwangu kangi.’ ");
INSERT INTO nww_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yula nkola abhandwa kakilighombela mumwoyo ghwake, ‘Hinu ndatenda niki kangi? Bambo ghwangu kammuha mulihengu lyangu handa nnyimilila. Megha ng'obhe na makakala gha kukandakanda. Na kangi nungubhona honi kuyupayupa. ");
INSERT INTO nww_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ena, nungulimanya lya kutenda, ngati pamingwamingwa mulihengo lyangu lya kuyimilila bhandu bhangingame muhitutubhi yabhe.’ ");
INSERT INTO nww_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ndo yula nnyapala kakiakema aghambwa bhoha bha bambo ghwake yumo mbole ya yungi. Kakinkonya ghwa ulongohi, ‘Ghukiyahikwa kyoki na nkulu ghwangu?’ ");
INSERT INTO nww_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Naywo kakinnyanga, ‘Mapipa mia ya mahuta gha miseituni.’ Yula nnyapala kakinnyanga, ‘Ghutame pahi na ghutyeke kya kuyumbatika mapipa amsini.’ ");
INSERT INTO nww_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mbole kakinkonya nnghambwa yungi, ‘Ghwenga ghukiyahikwa hilingi?’ Naywo kakinnyanga, ‘Michako mia ya mbunje ya ngano.’ Yula nnyapala kakinng'ombela, ‘Ghutole lihamba lyako na ghutyeke michako mbinda mabhokao semanini ya ngano.’ ");
INSERT INTO nww_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ndo yula nkulu kakinnumba yula nkola abhandwa kwakya mahala ghake. Kiyaha bhandu bha nnima aghu atenda ulemwa na bhanga kunhyubhalila Bambo Chapanga angutenda mahengo ghabhe kwa mahala kupitingana kwa bhandu bhaanhyubhalaila Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ndo Yesu kakighendelela kulongela, “Nunguaghombela kukita, bhandu bhaamokola utopelo kwa mandendelo gha ulemwa. Peni bhaaghutumila utopelo aghwo kughatenda mandendelo gha maha kwa bhala bhaaghupala utangwo, apwo ndo bhaabhegha aghanja bhenu, na mulinjubha panhwegha bhandu abho bhaayelela kubhabhona mulitinga lya manjubha ghoha. ");
INSERT INTO nww_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ywohele yunakuhyubhalika kwa mihalo michoko, katahyubhalika kwa mihalu mikulu, naywo ywangahyubhalika kwa mihalo michoko kahone kuhyubhalika kwa mihalu mikulu. ");
INSERT INTO nww_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Handa maabhegha bhangahyubhalika kwa utopelo ghwa nnima aghu, ndo ghani aywo ywakaayubhalila mwenga mu mihalo ya utopelo ghwa hoto? ");
INSERT INTO nww_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na handa pa nhyubhalika ng'obhe kwa utopelo ghwa bhandu bhangi ndo ghani aywo kataakamuha utopelo ghwenu mabhene?” ");
INSERT INTO nww_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kahone nndumindumi ywakuhotola kubhatendela lihengo abambo abhili. Kiyaha nkalalila yumu na kunpala yungi ebu katantendela lihengo lya maha yumu na yungi katanyuyuha. Maahotola ng'obhe kuntendela lihengo Chapanga papamu na utopelo.” ");
INSERT INTO nww_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Peni Akaafalisayo paayihwite agho, bhakinnyuyuha Yesu kiyaha bhene akipalaha munu ngalabha. ");
INSERT INTO nww_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu kakiaghombela, “Mwenga mungulitumba kukita mmegha bha maha paulongolo ghwa anabhandu, peni Chapanga kanguyimanya myoyo yenu. Kiyaha hilibhi hiibhoneka hya maha kwa bhandu, Chapanga kanguhihyaghabhalila.” ");
INSERT INTO nww_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Malaghilo gha Musa na malembo gha ambuye ghwa Chapanga ghakialongoha mbaka kunndaluko ghwa Yohane yunakubatisa. Kuhuma apwo mungughombelwa Nhalo ghwa maha ghwa Ghubhutwa ghwa Chapanga, na bhandu bhoha angughombelwa kya kulitumba ayingile Mughubhutwa ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Peni yaabhegha yeyebhu munu kwa kunani kwa Chapanga na nnima aghu kuhobha, ngati ng'obhe nga kwa lilembo limo kubhuka mu malaghilo gha Musa kuhobha.” ");
INSERT INTO nww_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Handa mundu ywohele katantyekela nndala ghwake lihamba lya kunleka na mbole kakatole nndala yungi aywo kangutyaha, na nnume yunakuntola nndala ywakatyekihitwe lihamba lya kulekwa kangutyaha.” ");
INSERT INTO nww_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesu kakighendelela kulongela, “Pakibhegha na yunautopelo yumu ywakahwaliteghe mapinda gha ghalabha ngulu munu mapinda gha langi ya samalati na mapinda mahuhu, na pakitendekeha chekwa mumanjubha ghoha. ");
INSERT INTO nww_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pala pa nnlyango ghwake kakibha kapukwa yumu ywakayeghiteghwe apwo, lihina lyake Lasalo, ywakabheghite hilonda mu mmili ghwake ghwoha. ");
INSERT INTO nww_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Aywo Lasalo kakihyubhalila kulyegha mahighalo ghaaponikite ku kindangabhala kya aywo yunautopelo. Mbaka akabhwa bhakihika na kumyanga hilonda hyaki. ");
INSERT INTO nww_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Lisaa palikihikite, yula kapukwa kakihwegha, na mahoka bha Chapanga bhakintola na kunbhika kakatame papamu na Abulahamu. Yula yunautopelo naywo kakihwegha na bhakinkulila. ");
INSERT INTO nww_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Yula yunautopelo pakabheghite kumambe mukimbamanda, kakilolekeha kunani naywo kakimmona Abulahamu kya kutali, naywo Lasalo kakibhegha ugheghela naywo. ");
INSERT INTO nww_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Hino yula yunautopelo kakinkema, ‘Tate Abulahamu, ghunmonele luhungu, na ghunlaghile Lasalo kakichwike kikonji kyake mu machi ngati kalughupohe lulimi lwangu, kiyaha nungupungwa muno mu mwoto aghu.’ ");
INSERT INTO nww_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Peni Abulahamu kakinnyanga, ‘Mwana ghwangu, ghulikulungwe kukita paghubheghite kukali ghubhegha na ubhumi ghukihumbula mihalu ya maha, peni Lasalo kakimokola mihalu ya uhakata. Peni hinu nungunyonjokeha mwoyo apa na ghwenga ghubha na kibamanda kikulu. ");
INSERT INTO nww_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hata habhu, pakati yetu libhegha libhumba likulu, ngati bhala bhaapalite kubhuka akwo na kuhika kunu kakotoke ahotole, ebu mundu ywohele kakotoke kuyomboka kuhika kunu.’ ");
INSERT INTO nww_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ndo yula yunautopelo kakilongela, ‘Hinu, nungukuyupa, ghunlaghile Lasalo kaghende ku lubhagha lwa tate ghwangu, ");
INSERT INTO nww_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kiyaha mmegha na alongo nhano. Kakaakinye ngati akotoke kuhika kunu kuhimbamanda.’ ");
INSERT INTO nww_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Peni Abulahamu kakinnyanga, ‘Alongo bhako abhegha na malembo gha Musa na ambuye bhangi bha Chapanga, aghatughile agho.’ ");
INSERT INTO nww_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Yula yunautopelo kakilongela, ‘Ng'obhe, tate ghwangu Abulahamu, handa mundu kaahyuka kuhuma kumambe kataahikila, bhaalipetula ulemwa na kummuyila Chapanga.’ ");
INSERT INTO nww_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Peni Abulahamu kakinng'ombela, ‘Handa bhaayitikila ng'obhe malaghilo gha Musa na Ambuye bhangi bha Chapanga, bhaahotola ng'obhe kunnyihwa hata paanyeghelehwa mundu ahyukite kuhuma kumambe.’ ” ");
INSERT INTO nww_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu kakiaghombela ahunda ghwake kukita, “Milando yinakunyegeleha bhandu atende ulemwa ghabhegha manjubha ghoha. Peni kaabhegha na mipinguhi yakya bhuli mundu yula ywakayighegha mihalo ayi. ");
INSERT INTO nww_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yingabheghite mbaha mundu aywo kabhopolelwe liganga linakutopa lya kuhyaghila mun'tandala ghwake na kuchumbukihwa mulihibha ngati ng'obhe kunnyeghelegheha yumoo ywa bhandu bhaandughila kakatende ulemwa. ");
INSERT INTO nww_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Hinu naha, mulindakile!” “Handa nnongo ghwako katenda ulemwa ghunlakalile, handa pakalipetula, ghunlekekehe. ");
INSERT INTO nww_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Handa kaghutendela ulemwa pasaba kwa linjubha limo na pasaba pakaghuhikila na kughulongela ‘Nungulipetula.’ Ghunlekekehe.” ");
INSERT INTO nww_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Andumitumi bhake bhakinng'ombela Bambo, “Ghutuyonjekehe kunhyubhalila Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Bambo kakiayanga, “Handa mungabheghite na uhyubhalilo nndoko handa mbeyu njoko ya haladali, mungahotolite kughughombela nnkongo aghu ghwa nkuyu ‘Ghulitupuhe na ghukamele mulihibha,’ Naghwo ghungayitikilita.” ");
INSERT INTO nww_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Handa mundu yumo mumwenga kabhegha na nbhandwa ghwake ghwa kukandakanda munng'unda ebu kuhakila mene, bhuli, pakabhuya, katanng'ombela ng'obhe aywo nbhandwa, ‘Ghuhike apa kya kuyumbatika ngati ghulyeghe hilyo?’ ");
INSERT INTO nww_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Bhuli, kihyengo kyake katanng'ombela, ‘Ghungeyele huti hilyo, nnyeghe, ghuhwale mapinda ghako telatela, ghuyime apa mbaka pannyomola kulyegha na kunywegha, mbole ndo ghulyeghe na kunywegha?’ ");
INSERT INTO nww_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Bhuli aywo mundu katannumba nbhandwa ghwake kya kutenda ghala ghakankwilikihite? ");
INSERT INTO nww_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ubhwabhu abhu na mwenga pannyomola kutenda ghala gha nlaghilitwe, nnghombe, ‘Twenga ndo abhandwa hela, ndo mbaka tughatende ghala ghatukwilikihitwe kughatenda.’ ” ");
INSERT INTO nww_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu pakabheghite mu njila pakighenda ku Yelusalemu, kakikindila mu mbakilo ya Samalia na Galilaya. ");
INSERT INTO nww_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pakabheghite mu kuyingila mu kijiji kimo, bhandu mbinda mabhoko yimo bhaabheghite na maloha bhakikongana naywo, na bhakiyima kya kutali, ");
INSERT INTO nww_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","bhakikwiha lilobhe pa akiilongela, “Bambo Yesu, ghutubhonele luhungu!” ");
INSERT INTO nww_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pakaabhonite kakiaghombela, “Ng'endi makalibhonehe kwa andundame.” Nabho pa abheghiti mu njila paaghenda, bhakighululikwa. ");
INSERT INTO nww_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yumoo ywabhe pakabhonite kukita kakilama, kakibhuya kwa Yesu kunu pakintika Chapanga kwa lilobhe likulu. ");
INSERT INTO nww_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kakilitagha kuulongolo ghwa maghulu gha Yesu kunu pakinnumba. Na aywo mundu kakibhegha Nsamalia. ");
INSERT INTO nww_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu kakikonya, “Bhuli, bhakighululwa na kulamihwa ng'obhe bhoha mbinda mabhoko yimo? Abhegha kwoki bhala nhano na ncheche? ");
INSERT INTO nww_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bhuli, kahone na yumu ywakabhuyite ili kakanpeghe ukulu Chapanga maha nga ayu nhenja?” ");
INSERT INTO nww_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesu kakinng'ombela, “Ghuyime na ghughende, kuhyubhalila kwako kughulopoha.” ");
INSERT INTO nww_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mulinjubha limo Yesu pakakonyekihitwe na Akaafalisayo Ghubhutwa ghwa Chapanga ghwahika pakiki, ywombe kakiayanga, “Ghubhutwa ghwa Chapanga ghunguhika ng'obhe handa kilibhi kighuhotola kukibhona kwa meho, ");
INSERT INTO nww_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ebu bhandu bhatalongela ng'obhe, ‘Ghula pala’ ebu ‘Ghula kula’ Kiyaha Ghubhutwa ghwa Chapanga ghubha pa kati ya mwenga.” ");
INSERT INTO nww_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mbole Yesu kakiaghombela ahundwa bhake, “Manjubha ghanguhika na maapala kulibhona linjubha nga limo lya Mwana ghwa Mundu, peni malibhona ng'obhe. ");
INSERT INTO nww_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bhandu bhataaghombela, ‘Kabhegha kula!’ Ebu, ‘Kabhegha apa!’ Nkotoke kuatughila. ");
INSERT INTO nww_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nmanyi kukita Mwana ghwa Mundu pakapala kubhuya kuhuma kunani katahika handa lumuli lwa njahe palumulika kamu, palumulika mbande hyoha ya kubhwelo. ");
INSERT INTO nww_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Peni yingunkwiliha kambamandike munu na kulemwa na kibheleko aki. ");
INSERT INTO nww_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Handa payibheghite mumanjubha gha Nuhu, ndo yaabhegha ubhwabhu mumanjubha gha kuhika kwa Mwana ghwa Mundu. ");
INSERT INTO nww_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mumanjubha gha Nuhu bhandu bhakighendelela kulyegha na kunywegha, paakitolela na kutolwa mbaka mulinjubha lila Nuhu pakayingilite mubhwato nkulu ghuukemitwe Safina, ndo machi ngumbwa ghakimema mu nnima na kuakanjaghana bhoha. ");
INSERT INTO nww_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Yikibhegha ubhwabhu abhu mu manjubha gha Lutu, bhandu bhakighendelela kulyegha na kunywegha, paakihemela na kuhemengana, paakikweta mbeyu na kuchenga. ");
INSERT INTO nww_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Peni linjubha lila Lutu pakabhukite ku Sodoma, mwoto nkalipa ghukihuluka kuhuma kunani kwa Chapanga handa hula na ghukiakanjabhana bhoha. ");
INSERT INTO nww_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ubhwabhu abhu ndo yabhegha mu linjubha lila Mwana ghwa Mundu pakapala kugubutulighwa.” ");
INSERT INTO nww_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Mu linjubha alyo, mundu ywohele ywakabheghite unani mwa lunyakaa, kakotoke kuhuluka kutola hilibhi hyaki. Ubhwabhu abhu mundu ywakabhegha ku nng'unda kakotoke kubhuya ku lubhagha lwake kutola kyohele. ");
INSERT INTO nww_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mulikulungwe ghaghanbwitukilite nndala ghwa Lutu! ");
INSERT INTO nww_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mundu ywohele ywakapala kughubhika ubhumi ghwake kataghuhoha, na ywohele ywakaghuhohite ulami ghwake kataghulopoha. ");
INSERT INTO nww_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ninguaghombela, mu uhiku aghwo ghwa linjubha alyo bhandu abhili bhatabhegha pa akighonja papamu paulili ghumo, yumo katatolwa na yungi katalekwa. ");
INSERT INTO nww_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Adala abhili bhaabhegha paahyagha mbuje papamu, yumo katatolwa na yungi katalekwa. ");
INSERT INTO nww_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Alumi abhili bhaabhegha paakitenda lihengo lyabhe papamu munng'unda, yumo katatolwa na yungi katalekwa.” ");
INSERT INTO nww_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mbole ahundwa bhake bhakinnkonya, “Bambo, agho ghaabwitukila kwoki.” Yesu kakiayanga kwa nongelo pakalongela, “Pohele paghubheghite mmili ghwa ntumba, ndo paakonganika ndapu.” ");
INSERT INTO nww_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mbole Yesu kakiapegha ahundwa bhake ndambulo ngati kabhahunde kukita yinguakwilikiha kuyupa Chapanga kyanga kulumuka mwoyo. ");
INSERT INTO nww_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kakiaghombela, “Mukitami kimo kakibhegha nndumula nongwa ywanga kuntundamila Chapanga ebu kughayihwa gha bhandu. ");
INSERT INTO nww_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mukitami akyo akyo kakibhegha nndala nnekwa yumo ywene pipipi kakinhikila na kunnyupa, ‘Ketekete, ghumbeghe shaliya yangu kubhuka kwa nmyanja ghwangu.’ ");
INSERT INTO nww_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kya manjubha matangalo yula nndumula nongwa ywangatundamilagha kakilema kuntangatila aywo nndala nnekwa. Peni kuuhiko kakilighombela mumwoyo ghwake, ‘Hata handa nenga nangantundamila Chapanga ebu kughayihwa gha bhandu, ");
INSERT INTO nww_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","peni kiyaha ayu nndala nnekwa kangung'aha, ndanpegha shaliya yake ili kakotoke kunhechuha kwakya kunhikila pipipi!’ ” ");
INSERT INTO nww_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Hinu Bambo kakighendelela kulongela, “Nnyihwe kyakalongilite aywo nndumula nongwa ntenda ulemwa. ");
INSERT INTO nww_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Bhuli, Chapanga kaapegha ng'obhe shaliya bhakaahaghulite bhaanlilila pamuhi na pakilo? Bhuli, katakabhalila kuatendela gha maha? ");
INSERT INTO nww_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ninguaghombela, Chapanga kaapegha shaliya kya kulopokeha. Peni bhuli, Mwana ghwa Mundu pakapala kuhika mu nnima kataabona bhandu bhaanhyubhalila?” ");
INSERT INTO nww_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu kakiaghombela ndambulo ayi kwa bhala bhaalidumbite kukita bhombe ndo bhangughatughila ghala ghakaapala Chapanga na kuayuyuha bhangi. ");
INSERT INTO nww_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Bhandu abhili bhakighenda Kukitutubhi kya Chapanga kuyupa, yumo kakibha Nfalisayo na yungi nsumula sumu. ");
INSERT INTO nww_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Yula nfalisayo kakiyima ghweka chake kakiyupa abhu, ‘Chapanga, ningughulumba kiyaha nenga megha handa bhandu bhangi ng'obhe bhangahyubhalila, na apoka, na alemwa, na atyahe ebhu handa ayu nsumula sumu. ");
INSERT INTO nww_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nenga ningulikunga pabhili kwa lijuma, ningubhuha lifungu lya mbinda mabhoko yimo ya motelo yangu.’ ");
INSERT INTO nww_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Peni yula nsumula sumu kakiyima kya kutali, kyangayinula kibhungi kyake kulolekeha kunani kwa Chapanga, ngati kakighakamula mabhoko ghake na kuhokamila pakakukulika kunu pakilongela, ‘Chapanga ghumonele lipyanda, nenga nunmeghite na ulemwa.’ ");
INSERT INTO nww_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ninguaghombela, yula nsumula sumu kakibhuya ukaya pakalekekehwa ulemwa ghwake, ngati ng'obhe yula nfalisayo ywakalikwehite kwa Chapanga. Kiyaha ywohele ywakalihwachilite kukita nkulu katahuluhwa na ywohele ywakalihuluha katakwehwa.” ");
INSERT INTO nww_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Linjubha limu amoo bhandu bhakinnyeghela Yesu bhana adokwa ngati kabhayabhike hibhoko hyake ili kakaanonele. Ahundwa bhake paabhonite habhu bhakialakalila bhala bhandu. ");
INSERT INTO nww_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Peni Yesu kakiakema bhala bhana ahike kwa ywombe, kakilongela, “Mualeke bhana adokwa anhikile kwa nenga, hangi nkotoke kuakanikiha, kiyaha Ghubhutwa ghwa Chapanga ghubhegha ghwa bhandu abheghite handa abha bhana. ");
INSERT INTO nww_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Kulyaghila nunguaghombela, ywohele ywa nga kughukingama Ghubhutwa ghwa Chapanga handa mwana nndokwa, katayingila ng'obhe mughubhutwa aghwo.” ");
INSERT INTO nww_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kilongohi yumo kakinkonya Yesu, “Nhunda ghwa maha, ndende niki ngati nighumokole ubhumi ghwa manjubha ghoha kyanga uhiko?” ");
INSERT INTO nww_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu kakinnyanga, “Kyabhuli ghungunngema ghwa maha? Kahone mundu ghwa maha ngati nga Chapanga ghweka chake. ");
INSERT INTO nww_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ghungughamanya malaghilo gha Musa, ‘Utyahe kata, Kukoma kata, kuyibha kata, unyimiho ghwa uhwangi kata, ghubhayitikile tate ghwako na ma ghwako.’ ” ");
INSERT INTO nww_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ywombe kakiyanga, “Malaghilo agha ghoha nighakamula tangu pammbeghite kakombo.” ");
INSERT INTO nww_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu pakayihwite agha kakinng'ombela, “Ghupelelwa nnando ghumo. Ghughende ghukahemengane hyoha ghuhibheghite naywo na ghubhapeghe ngalabha ahyo bhandu kapukwa, kya kutenda habho ndo ghwabhegha na utopelo ntangalo kunani kwa Chapanga, mbole ghuhike na ghundughile.” ");
INSERT INTO nww_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pakayihwite lilagho alyo kakihyongoloka muno kiyaha kakibhegha na utopelo ntangalo. ");
INSERT INTO nww_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu pakammonite kanguhyongoloka habhu na kakilongela, “Nnole kya bhuli yabhegha kulimba kwa bhanautopelo kuyingila Mughubhutwa ghwa Chapanga! ");
INSERT INTO nww_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kulyaghila yabhegha yelebhu kwa nnyama ywakakemitwe ngamia kuyingila mulilanga lya sasia, chepa kwa bhanautopelo kuyingila mu Ghubhutwa ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bhandu paannyihwite malagho agha bhakinkonya, “Handa yilimba naha, ndo ywoki aywo ywakahotola kulopoka?” ");
INSERT INTO nww_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu kakiayanga, “Gha nga kuhotoleka kwa anabhandu kwa Chapanga ghanguhotoleka.” ");
INSERT INTO nww_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ndo Petili kakilongela, “Nnole tughaleka ghoha ghatubheghite nagho na tughutughila ghwenga!” ");
INSERT INTO nww_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu kakiyanga, “Kulyaghila nunguaghombela, mundu ywakalekite lubhagha lwake, ebu nnhumbu ghwake ebu alongo bhake, ebu tate na ma ghwake ebu bhana bhake kwa kya Ghubhutwa ghwa Chapanga ");
INSERT INTO nww_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kaakingamwa matangalo kupitingana ahyo munnima aghu na kuuhiko katakamuhwa ubhumi ghwa manjubha ghoha.” ");
INSERT INTO nww_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu kakiatola bhala ahundwa bhake mbinda mabhoko yimo na abhili kya kighweka na kakiaghombela, “Nnyihwe, tungughenda ku Yelusalemu na hyoha hityekitwe na ambuye bha Chapanga kwa kya Mwana ghwa Mundu hyaabwitukila. ");
INSERT INTO nww_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kiyaha kaagheghwa na kukamulwa na bhandu bhaabheghite ng'obhe Ayahudi, nabho bhatantendela mahakataho na bhatanhunila mata. ");
INSERT INTO nww_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bhatantuta kwa ndomondo na bhatankoma na mu linjubha lya ndatu katahyuka.” ");
INSERT INTO nww_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ahundwa bhake bhakighamanya ng'obhe malagho agho, kiyaha fwambulo yake yikihihwa kwa bhombe, nabho bhakimanya ng'obhe kyakalongilite Yesu. ");
INSERT INTO nww_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu pakabheghite kanguheghelela ku nnima ghwa Yeliko, mundu yumu ywangabhona kakibhegha katama mu bhwegha ya njila paakiyupa utangwo. ");
INSERT INTO nww_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mundu ywangabhona aywo pakayihwite mayobhe gha lumati lwa bhandu palukinda, kakikonya, “Kubhegha na niki?” ");
INSERT INTO nww_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bhala bhandu bhakinnyanga, “Yesu ghwa Nasaleti kangupita.” ");
INSERT INTO nww_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Yula mundu ywangabhona kakikweha lilobhe pakilongela, “Yesu! Mwana ghwa Daudi, ghumonele luhungu!” ");
INSERT INTO nww_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bhala bha abheghite ku ulongolo bhakinlakalila bhakinng'obhela kanyamale. Peni mwene kakighendelela kukweha lilobhe “Mwana ghwa Daudi, ghumonele luhungu!” ");
INSERT INTO nww_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu kakiyima na kakikwilikiha bhannyeghe mundu aywo kwa mwene. Pakabheghite ugheghela, Yesu kakinkonya, ");
INSERT INTO nww_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ghungupala nighutendele niki?” Ywombe kakiyanga, “Bambo, ningupala kubhona.” ");
INSERT INTO nww_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu kakinng'ombela, “Ghubhone, kuhyubhalila kwako kughulopoha.” ");
INSERT INTO nww_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kamu mundu yula kakibhona lisaa lila lila, na kakinntughila Yesu, kunu pakintikila Chapanga. Bhandu bhoha paabhonite mihalo ayi, nabho bhakintikila Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu kakiyingila kunkitami kya Yeliko, naywo kakipita pakati ya kitami akyo. ");
INSERT INTO nww_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mukitami akyo, pakibhegha mundu yumu lihina lyake Sakayo. Mundu aywo kakibhegha nkulu ghwa asumula sumu, kangi kakibhegha yuna utopelo. ");
INSERT INTO nww_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Mwene kakipalaha kammone Yesu mundu ghwa kya bhuli. Peni yakya lumati lukulu lwa bhandu kakilepelwa kiyaha kakibhegha nhupitaho. ");
INSERT INTO nww_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hinu kakilongoha kuulongolo ghwa lula lumati lwa bhandu kakihubhuka munkongo ghwa nkuyu ngati ammone Yesu, kiyaha nge kakinde mu njila yila. ");
INSERT INTO nww_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu pakahikite pahi ya ghula nkongo ghwa nkuyu, kakilolekeha kunani, na kakinng'ombela, “Sakayo ghuhuluke kya kuyumbatika, kiyaha lelo ndahwelekeha ku lubhagha lwako!” ");
INSERT INTO nww_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ndo Sakayo kakihuluka kya kuyumbatika, na kakinkingama Yesu mu lubhagha lwake kya uyelelo nkulu. ");
INSERT INTO nww_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bhandu bhoha bhaabhonite bhakiyanda kuhyongoloka paakilongela, “Kaghenda kubhegha nhenja ghwa mundu yunaulemwa.” ");
INSERT INTO nww_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Peni Sakayo kakiyima na kung'ombela Yesu, “Muyihwe, Bambo! Nenga ndaapegha lihinda lya utopelo ghwangu akapukwa, na handa nikighupoka utopelo ghwa mundu kwa makakala nda mmuyihila pancheche ya utopelo ghula.” ");
INSERT INTO nww_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ndo Yesu kakinng'ombela, “Lelo, ulopoho ghukihika mu lubhagha alu, kiyaha ayu naywo ndi kibheleko kya Abulahamu. ");
INSERT INTO nww_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kiyaha Mwana ghwa Mundu kahika kupalaha na kulopoha bhandu bhahobhite.” ");
INSERT INTO nww_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bhandu bhaannyihwite Yesu bhakihwacha kukita Ghubhutwa ghwa Chapanga ghunguhika masaa ghala ghala na akibhegha ugheghela na Yelusalemu ndo Yesu kakilongela ndambulo ayi. ");
INSERT INTO nww_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Pakibhegha mundu yumo ywa lukolo ghwa ghubhutwa, kakibhegha mu mwanja kughenda ku nnima ghwa kutali ngati kakakingame ulongohi ghwa ghubhutwa, mbole kakabhuye. ");
INSERT INTO nww_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kukali na kubhuka kakiakema mbinda libhoko yimo muabhandwa bhake na kakiapegha kila yumo kimati kya ngalabha pakilongela, ‘Makatende kyohele na mbiya aywo mbaka pambala kubhuya.’ ");
INSERT INTO nww_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Peni bhandu bha nnima ghwake bhakibha paakinnyaghabhalila ndo bhakialaghila ajumbe paakilongela, ‘Tungupala ng'obhe aywo kabhe mutwa ghwetu.’ ” ");
INSERT INTO nww_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Hata naha mundu aywo kakikamuhwa ghubhutwa na kakibhuya ku nnima ghwake. Mbole kakiakema bhala ndumindumi bhake ghwakaalekilite ngalabha ngati kakamanye kya amokolite kwa ndendelo hya kila yumoo. ");
INSERT INTO nww_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nndumitumi ghwa ulongohi kakihika pakilongela, ‘Bambo, kuhumila mukimati kimo ya ngalabha yighunekilite niyimokola mala mbinda mabhoko yimo.’ ");
INSERT INTO nww_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Yula Nkulu kakinnyanga, ‘Ghutenda maha nbhandwa ghwa maha, kiyaha ghuhyubhalika mumihalo midokwa, ndakupegha makakala mu hitami mbinda mabhoko yimo.’ ");
INSERT INTO nww_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ndumindumi ghwa ubhili naywo kakihika, pakilongela, ‘Bambo, mukimati kya ngalabha kighungamuhite kiyonnjokeheka mala nhano.’ ");
INSERT INTO nww_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Bambo ghwake kakinnyanga, ‘Na ghwenga ghwa bhegha nkulu muhitami nhano.’ ");
INSERT INTO nww_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mbole kakihika yula nbhandwa yungi pakilongela, ‘Bambo ghutole kimati kya ngalabha hyako. Kiyaha nikiyihiha maha mulipinda. ");
INSERT INTO nww_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nikiyoghopa kiyaha ghwenga ndo mundu nhakata. Ghwenga ghungutola hilibhi hibheghite hyako ng'obhe, na kunuka hila ghuyihimelihite ng'obhe.’ ");
INSERT INTO nww_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Bambo ghwake kakinnyanga, ‘Ningughutosa kwa kya lilagho lyako, ghwenga nbhandwa nhakata, ghukimanya kukita nenga nhakata yunakutola hilibhi hiibheghite hyangu ng'obhe na kunuka kyanga kuhimeleha, ");
INSERT INTO nww_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","kiyaha niki, ghukihibhika ng'obhe kimati kya ngalabha yangu kwa ayahika ngalabha ngati pamuya ntole yiibheghite yangu na yila yiiyonjokihite?’ ");
INSERT INTO nww_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ndo kakiaghombela bhala bhaayimite ugheghela, ‘Mumpoke kimati kya ngalabha yake na makanpeghe yula ywakabheghite na himati mbinda mabhoko yimo.’ ");
INSERT INTO nww_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bhakinng'ombela, ‘Bambo, aywo kabhegha kala na himati hya ngalabha mbinda mabhoko yimo!’ ");
INSERT INTO nww_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kakiayanga, ‘Ninguaghombela kukita, ywohele ywakabheghite na kilibhi, katayonjokehwa, na yula ywa nga kilibhi, hata kila kyakabheghite nakyo, katapokwa, ");
INSERT INTO nww_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","peni bhala amyanja bhangu bhene bha nga kupala mmeghe mutwa ghwabhe, maayeghe apa makaakome kunu nenga pannola.’ ” ");
INSERT INTO nww_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Mbole ya kughalongela agha Yesu kakilongola kughenda ku Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Naywo pakaheghelelite kuhika muhijiji hya Betifage na Betania ugheghele na kitumbi kiikemitwe kitumbi kya mikongo ya miseituni, kakialaghila ahundwa bhake abhili, ");
INSERT INTO nww_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","pakialongela, “Nng'endi mu kijiji kila kibheghite mu ulongolo ghwenu, pammegha mu kuyingila mu kijiji akyo, maamona mwana kaputa lyana lyanga kuhubhukwa na mundu ywohele, kabhopwa apwo. Munhughule na munnyeghele apa. ");
INSERT INTO nww_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Handa mundu kataakonya, ‘Bhuli mungunhughula?’ Munng'ombele, ‘Bambo kangunnyupa.’ ” ");
INSERT INTO nww_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bhala bha alaghilitwe bhakighenda, na bhakibhona hyoha hila hila handa bhula pakaaghombilitwe na Yesu. ");
INSERT INTO nww_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Paabheghite mukunhughula lila kaputa lyana, yula bambo ywakalihughite lila kaputa kakiakonya, “Bhuli mungunhughula alyo kaputa lyana?” ");
INSERT INTO nww_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bhala ahundwa bhakiayanga, “Bambo kangunpala.” ");
INSERT INTO nww_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bhakinnyegha kwa Yesu lilala kaputa lyana, na mbole ya kuyalika maha mapinda ghabhe munng'ongo ghwa mwana kaputa bhakinhubhuha Yesu mu nng'ongo ghwa mwana kaputa aywo. ");
INSERT INTO nww_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesu kakighendelela na mwanja ghwake na bhandu bhakiyalila mapinda ghabhe mu njila. ");
INSERT INTO nww_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pakabheghite ugheghela na Yelusalemu, muuhelelo ghwa kitumbi kya Mikongo ya Miseituni, lumati lwa lahundwa bhake luuntughilite bhakiyanda kuntika Chapanga kwa nnyelelo na kwa lilobhe likulu kwakya ndendelo ya mihabho bhaayibhonite. ");
INSERT INTO nww_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Paakilongela, “Kanonelwa Mutwa yunakuhika kwa lihina lya Bambo Chapanga! Uhihimilo kunani kwa Chapanga na ukulu akwo kunani munu.” ");
INSERT INTO nww_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Amoo bha Akaafalisayo bha abheghite mulula lumati lwa bhandu bhakinng'ombela Yesu, “Nhunda ghubhalakalile ahundwa bhako anyamale.” ");
INSERT INTO nww_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu kakiayanga, “Nunguaghombela, handa abha bhaanyamala, maganga agha ghaachobha kyobho.” ");
INSERT INTO nww_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu pakabheghite ugheghela na kitami kya ku Yelusalemu na pakakibhonite kitami, kakikililila, ");
INSERT INTO nww_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","pakilongela kwa kya bhandu bha kitami akyo, “Nikipalaha hata lelo mmanyi mihalo ya kutenda ngati mmeghe na uhihimililo, peni hinu ghuihihwa na mahotola ng'obhe kughubhona uhihimilo. ");
INSERT INTO nww_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kulyaghila manjubha ghaahika, na amyanja bhako bhaakuchengela kindupa kikangamalo kukitindila kitami kyako nabho bhaayanda kukututa kuhuma mumbande hyoha. ");
INSERT INTO nww_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bhatakubajanga ghwenga na bhana bhako mu hindupa hyako. Nabho bhataleka ng'obhe liganga limu kunani ya liganga lingi, kiyaha ghukilimanya ng'obhe lisaa lyakahikite Chapanga kukulopoha.” ");
INSERT INTO nww_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Mbole Yesu kakiyingila mulubhigho lwa kitutubhi kya Chapanga, na kakiyanda kuabhingabhinga bhala bhaabheghite mu kuhemengana hilibhi amwo. ");
INSERT INTO nww_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Naywo kakiaghombela, “Yikityekwa mumalembo gha Chapanga, Chapanga kakilongela, ‘Kitutubhi kya nenga Chapanga kyaabhegha kitutubhi kya nnyupo.’ Peni mwenga mungukitenda kibhe mbako ya apoka.” ");
INSERT INTO nww_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Mumanjubha ghoha Yesu kakibhegha pakihunda Pakitutubhi kya Chapanga. Peni andundame akulu na ahunda bha malaghilo na hilongohi bha bhandu bhakibhegha paakipalaha njila ngati ankome. ");
INSERT INTO nww_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Peni akihotola ng'obhe kiyaha bhandu bhoha bhakibhegha paakinnyihwa kya nga kutagha lilagho limo. ");
INSERT INTO nww_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mulinjubha limu Yesu pakabheghite pakihunda bhandu Kukitutubhi kya Chapanga na kuaghombela bhandu Nhalo ghwa Maha, andundame akulu, na ahunda bha malaghilo, papamu na aghohi bhakinhikila. ");
INSERT INTO nww_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Bhakinkonya, “Ghutughombele, ghunguntenda mihalu ayi kwa ngwiliho ya ghani? Na ndo yoki ywakakupeghite mwenga makakala agha?” ");
INSERT INTO nww_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu kakiayanga, “Na nenga nunguyupa munng'ombele, ");
INSERT INTO nww_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ubatiso ghwa Yohane ghukihuma kunani kwa Chapanga ebu kwa anabhandu?” ");
INSERT INTO nww_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bhakighombana bhene, paakighomba naha, “Handa patughomba, ‘Ghukihuma kunani,’ katatukonya ‘Yibha bhuli mukihyubhalila ng'obhe?’ ");
INSERT INTO nww_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Peni handa patulongela, ‘Ghukihuma kwa ana bhandu,’ bhandu abha bhoha bhatatututa kwa maganga, kiyaha abhegha na lidumbilo kukita Yohane kakibha mbuye ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Hinu bhakinnyanga, “Tungumanya ng'obhe kughuhumite.” ");
INSERT INTO nww_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ndo Yesu kakiaghombela, “Na nenga ndabhaghombela ng'obhe ningutenda mihalu ayi kwa makakala gha ghani.” ");
INSERT INTO nww_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ndo Yesu kakighendelela kuaghombela bhandu ndambulo ayi, “Mundu yumu kakikanda nng'unda ghwake ghwa misabibu, na kakiapegha akandakanda bhankamuhe sumu, mbole kakibhuka kwa manjubha matangalo. ");
INSERT INTO nww_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Manjubha gha mabeno mundu aywo kakinlaghila abhandwa bhake kwa bhala akandakanda bhaapeghite ghula nng'unda, ngati bhanpeghe kimati kya mambeno gha nng'unda ghwake ghwa misabibu. Peni bhala akandakanda bhakintuta, na kunbhingabhinga kyanga kilibhi kyohele. ");
INSERT INTO nww_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yula nkola nng'unda kakinlaghila kangi nbandwa yungi, na aywo bhakintuta, bhakintendela mihalu ya honi na bhakinbhingabhinga kyanga kilibhi. ");
INSERT INTO nww_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kangi kakinlaghila ndumindumi yungi ghwandatu, aywo ndo bhakinkechela hilonda na kuntagha panje ya nng'unda. ");
INSERT INTO nww_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ndo yula bambo nkola nng'unda ghwa misabibu kakilongela, ‘Nda tenda niki? Nda nlaghila mwana ghwangu yununpala, pangi bhatanhokamila.’ ");
INSERT INTO nww_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Peni bhala akandakanda bhaakamuhitwe ghula nng'unda, paanmmonite bhakighombana bhene kwa bhene, ‘Ayu ndo yunakuhala, hinu tunkome ngati tuhale twenga.’ ");
INSERT INTO nww_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Habhu, bhakinbhuha panje ya ghula nng'unda ghwa misabibu, na bhakinkoma.” Yesu kakiakonya, “Yula Bambo yunanng'unda ghwa misabibu kataatendela niki bhala akandakanda? ");
INSERT INTO nww_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Katahika na kubhakoma bhala akandakanda, na katabhapegha akandakanda bhangi ghula nng'unda ghwa misabibu.” Bhandu pabhayihwite agha bhakilongela, “Ng'obhe, nhalo aghu ghukotoke kubwitukila kwa twenga!” ");
INSERT INTO nww_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu kakibhahulutulila mehu mbole kakighomba, “Hinu, Malembo agha mang'anyimo fwambulo yake ndo niki? Liganga bhalilemite bhanautendehi ghwa kuchenga hinu libhegha liganga likulu lya pambwegha; ");
INSERT INTO nww_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mundu ywohele ywakaponekela mu liganga alyo katadunyuka dunyuka na ywoheli liinponekela katabajangika muno.” ");
INSERT INTO nww_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ahunda bha malaghilo na mandundame akulu bhakipalaha kihokonyo kya kunkamula pala pala pakabheghite kiyaha bhakimanya kukita kakikambuka ndambulo yila kwa kya bhombe. Peni bhakibhayoghopa bhandu. ");
INSERT INTO nww_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kya abhu akulu abho bhakinnyubhatila Yesu bhankamule. Hinu bhakianyegheleha bhandu kwa ngalabha na kualaghila aghende kunkonya Yesu makonyo, bhandu abho akilitenda bhangughatughila ghakaghapala Chapanga, kunu bhakipalaha ng'ebhu ya kunkamula na kunghegha mumakakala gha ntabhala bha Akaaloma. ");
INSERT INTO nww_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bhandu abho bhaalaghilitwe bhaking'ombela Yesu, “Nhunda, tungumanya kukita ghunguhunda gha hoto yakya bhuli bhandu yinguanogha kutama handa pakapalite Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Hinu ghutughombele patughatughila malaghilo, bhuli, yitukwiliha kunpegha sumu Mutwa Nkulu ghwa Akaaloma ebu ng'obhe?” ");
INSERT INTO nww_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Peni Yesu kakimanya ntyegho ghwabhe, habhu kakiaghombela, ");
INSERT INTO nww_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Munnangihe akyo kipalamande kya ngalabha, kibhungi aki na lihina ali lya ghani?” Bhakinnyanga, “Kya Mutwa nkulu ghwa Akaaloma.” ");
INSERT INTO nww_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesu kakiaghombela, “Hinu munpeghe Mutwa nkulu ghwa Akaaloma hiibheghite yake na munpeghe Chapanga hibheghite hya Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Hinu bhakihotola ng'obhe kunng'omeha kwa lilagho lyohele muulongolo ghwa bhandu na bhakinyamala nuu pakilikangacha liyango lyake. ");
INSERT INTO nww_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Amoo Akaasadukayo, bhala bhaalongela kukita kahone uhyuko ghwa bhaahweghite, bhakinhikila Yesu na bhakinkonya, ");
INSERT INTO nww_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Nhunda, Musa kakitutyekela kukita, handa nnongo ghwa mundu yumu kahwegha na kunneka nndala kyanga mwana, hinu nnongo ghwake yingunnogha kuntola aywo nndala ngati kanpapile nnongo ghwake. ");
INSERT INTO nww_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Hinu, bhakibhegha alongo saba, ywa ulongohi kakitolela na kakihwegha kyanga mwana. ");
INSERT INTO nww_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mbole, yula nnongo ghwa ubhili kakinhala yula nndala nnekwa, hata naha aywo naywo kakihwegha kyanga mwana. ");
INSERT INTO nww_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ghwandatu naywo kanhala naywo kakihwegha kyanga mwana. Yikibha ubhwabhu abhu kwa alongo bhoha saba kakinhala aywo nndala na bhoha bhakihwegha kyanga mwana. ");
INSERT INTO nww_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kuuhiko yula nndaala nnekwa naywo kakihwegha. ");
INSERT INTO nww_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Hinu naha, linjubha lya bhandu kuhyuhwa, aywo nndala katabhegha nndala ghwa ghani? Kiyaha kakitolelwa na alongo bhoha saba.” ");
INSERT INTO nww_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu kakiayanya, “Bhandu bhaalama hinu mu nnima aghu bhangutola na kutolelwa. ");
INSERT INTO nww_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Peni bhala bhaabhalangitwe na Chapanga kukita yibhanogha kumokola ling'ebhu mu nnima ghula na mu uhyuko ghwa bhaahweghite, kahone kutola ebu kutolelwa. ");
INSERT INTO nww_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bhene bhaabhegha handa andumitumi ghwa kunani ghwa Chapanga na bhaahwegha kangi ng'obhe. Bhene ndo bhana bha Chapanga, kiyaha bhaahyuka kuhuma kwa bhaahweghite. ");
INSERT INTO nww_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Peni nhalo aghu ghwa kuhyuka kwa bhaahweghite, hata Musa kakilongela agha mumalembo gha Chapanga pala mihomanga pakiyakite mwoto na apwo Bambo Chapanga kakilongela, ‘Ywombe ndo Chapanga ghwa Abulahamu, Chapanga ghwa Isaka na Chapanga ghwa Yakobu.’ ");
INSERT INTO nww_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mwene ndo Chapanga bha ahweghite ng'obhe ngati ghwa bhaabhatama, kiyaha bhoha kwa mwene bhangutama.” ");
INSERT INTO nww_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Amoo bha ahunda bha malaghilo bhakilongela, “Nhunda, ghuyanga tela tela!” ");
INSERT INTO nww_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mbole ya agha kahone mundu ywakayighite kukonya likonyo kangi. ");
INSERT INTO nww_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mbole Yesu kakiaghombela, “Yibha bhuli bhandu bhalongele kukita Kilisito ywakahaghulitwe na Chapanga ndo mwana ghwa Daudi? ");
INSERT INTO nww_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mwene Daudi kakityeka mu kitabho kya Sabuli, ‘Bambo kaking'ombela Bambo ghwangu, Ghutame mu kibhoko kyangu kya nnilo, ");
INSERT INTO nww_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mbaka pambala nighutende ghubhahotole amyanja bhako na kuatabhala.’ ");
INSERT INTO nww_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Handa Daudi mwene kangunngema Kilisto, ‘Bambo’ Hinu yibha bhuli kabhe mwana ghwake?” ");
INSERT INTO nww_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bhandu bhoha paabheghite pa akinnyihwa, Yesu kaiaghombela ahundwa bhake, ");
INSERT INTO nww_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mulindakile na ahunda bha malaghilo. Bhene apalagha kutyanga paahwala maghwanda matandamaho na kulamuhwa kwa kuhokamilwa mu hindandabhanji. Kunu pabhakitama mu hiteho ya ulongolo mu hitutubhi hya kukonganila Akaayahudi na kutama mu mang'ebhu ya ahenja bha kuhokamilwa mu chekwa. ");
INSERT INTO nww_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bhanguhipugha mibhagha hya adala alekwa, na ili abhonekane na bhandu kukita bhamaha bhangutundamila mayupo matali. Bhandu handa abho bhaakamuhwa toso ngulu.” ");
INSERT INTO nww_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Mbole Yesu pakayinulite meho ghake mumbande hyoha, kakiabhona bhanautopelo bhakibhika hilumbo hyabhe hya ngalabha mulijamanda lya Kitutubhi kya Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kangi kakimmona nndala yumo nnekwa kapukwa, pakibhika amwo mbiya ibhili ya lihabha. ");
INSERT INTO nww_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ndo Yesu kakilongela, “Kulyaghila nunguaghombela hoto, ayu nndala nnekwa kapukwa kakibhika litulo likulu kupitingana bhoha. ");
INSERT INTO nww_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kiyaha abha bhandu bhangi bhakibhuha matulo gha hilumbo njoko kwa Chapanga kuhuma muutangalo ghwa utopelo ghwabhe, peni ayu nndala nnekwa mu ukapukwa ghwake, kabhuha kila kyakuntangatila kwa kulama.” ");
INSERT INTO nww_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Amoo bha ahundwa bhake bhakibhegha mu kunnangiha Kitutubhi kya Chapanga kinyelembikitwe kwa maganga gha maha na hilibhi hibhuhitwe handa matulo kwa Chapanga. Peni Yesu kakiaghombela, ");
INSERT INTO nww_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Linjubha lyahika kwa agha ghoha gha mughabhona na mulinjubha alyo kahone liganga limo lya highala kunani mwa lingi, hyoha hya hyahaghunganika.” ");
INSERT INTO nww_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ndo ahundwa abho bhakinnyanga, “Nhunda! Mihalu ayi yaabhwituka pakiki? Na naho yoki yabhoneha kukita yinguheghelela kubhwituka?” ");
INSERT INTO nww_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu kakiayanga, “Mlindakile, mundu kakotoke kuakuluha. Kiyaha atangalo bha ahika kwa lihina lyangu, pakilongela, ‘Nenga ndo mwene Kilisto,’ kangi bhaalongela, ‘Uhiko ghwa nnima ghuheghelela.’ Nkotoke kuatughila. ");
INSERT INTO nww_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Peni pannyihwa mihalo ya mikoha na bhulwa, nkotoke kuyoghopa. Kiyaha agho ghanogha ghabwituke huti, peni uhiko ghwa nnima, ghukali.” ");
INSERT INTO nww_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Mbole kakiaghombela, “Nnima ghumo ghwaatutana na nnima ghungi, na ghubhutwa ghumo ghwaatutana na ghubhutwa ghungi. ");
INSERT INTO nww_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Pohele paabhegha na migwangwaliko ya lutupi, lung'ahi lwa njala na matamwa gha uhakata munu. Kwaabhegha na milando mikulu ya kuyoghoha handa naho kunani. ");
INSERT INTO nww_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Peni kukali na kubhwitukila agha ghoha, bhaabhakamula na kubhabamanda. Bhaabhaghegha kwa akulu ghwa hitutubhi hya kukonganila hya Akaayahudi, na kuabhopa muhibhopo, na maagheghwa kwa abhatwa na atabhala kiyaha mwenga mungulihyubalila lihina lyangu. ");
INSERT INTO nww_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Na aywo yaabhegha ng'ebhu yenu ya kunnyimiha kwa bhombe. ");
INSERT INTO nww_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Peni nkotoke kubhegha na bhwaghalihi mumwoyo kukita maalongela niki akwo. ");
INSERT INTO nww_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kiyaha ndabhapegha malagho na mahala, na kwa mahala agho kahone nmyanja ghwenu nga yumo katahotola kuapingikiha kwa malagho ghake. ");
INSERT INTO nww_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Maakilukwa na tate na ma ghwenu, na alongo bhenu na aghanja bhenu na amoo mu mwenga bha abhakoma. ");
INSERT INTO nww_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Maakalalighwa na bhandu bhoha kiyaha mwenga mungulihyubhalila lihina lya nenga. ");
INSERT INTO nww_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Peni kahone nga hwili yimo ya kuhobha mu mitwe hyenu. ");
INSERT INTO nww_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kya kulimbilila maayilopoha myoyo yenu.” ");
INSERT INTO nww_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Pammona kitami kya Yelusalemu pakitindilwa na machonda, ndo mmanye kukita kukanjaghanwa kwake kukiheghela. ");
INSERT INTO nww_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Apwo bhala bha abheghite kunnima gwa Yudea atughile kuhitumbi, na bhabheghite ku kitami kya Yelusalemu abhuke amwo na abheghite mumighunda akotoke kuyingila ku kitami. ");
INSERT INTO nww_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kiyaha manjubha agho ghabegha manjubha gha kimbamanda ili ghoha ghatyekitwe na ambuye bha Chapanga ghabheghe na shaliya. ");
INSERT INTO nww_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Bhaabhegha na mipinguhi yakyabhuli bhala bhaabheghite na ndumbo na bhala bhaayongea bhana mu manjubha agho! Kiyaha kwa bhegha na himbamanda hikulu mu nnima na kiyaghabhu kya Chapanga kwa kya bhandu abha. ");
INSERT INTO nww_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bhangi bhaahwegha kwa lukechelo, na bhangi bhaabhegha abhandwa mumilima yingi, na kitami kya Yelusalemu kyaatabhalilwa na bhandu bhangabhegha Ayahudi na kuambamanda bhandu bhake, mbaka ng'ebhu yabhe payipela.” ");
INSERT INTO nww_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kwaabhegha na naho muluchubha na mulubhalamwehi na mundondwa. Na pa nnima aghu kwabhegha na lung'ahe na lyogha kubhukana na lilobhe lya nyukano nkulu ghwa machi gha lihibha ");
INSERT INTO nww_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bhandu bhaahima kubhukana na lyogha likuku paakihwacha kyoki yaabwituka mu nnima, kiyaha makakala gha hilibhi hya kunani ku bhwelo hyaatingihikwa. ");
INSERT INTO nww_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mbole bhaammona Mwana ghwa Mundu paakihika kuhuma kumahundi papamo na likalama na ukulu nkulu. ");
INSERT INTO nww_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Payitandila kubwituka mihalu ayi, nnyime na kuyinula mitwe yenu kunani, kiyaha ulopoho ghwenu ghubha ugheghela.” ");
INSERT INTO nww_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mbole Yesu kakiaghombela ndambulo ayi, “Mughulolekehe nkongo ghwa tini, na mikongo mitangalo hyoha. ");
INSERT INTO nww_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Payitomolite mahamba, mungumanya kukita ndaluko ghwa mabeno yikiheghela. ");
INSERT INTO nww_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ubhwabhu abhu, pa mmona mihalu aywo yingubwituka, ndo maamanye kukita Ghubhutwa gwa Chapanga ghuheghelela.” ");
INSERT INTO nww_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Kulyaghila nunguaghombela, bhandu bha kibheleko aki kyaakinda ng'obhe mbaka agha ghoha ghabwituke. ");
INSERT INTO nww_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kunani kwa Chapanga na nnima ghwaakinda, peni malagho ghangu kukinda kata.” ");
INSERT INTO nww_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mulindakile, myoyo yenu yikotoke kutopelwa kwa uhukilo, ulobhi, na milando ya ubhumi aghu. Hela bhubho linjubha lila lyahika kwa kuyumbatika. ");
INSERT INTO nww_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kiyaha handa bhula ntyegho paghukamula, ndo ubhwabhu abhu linjubha lila lyahika kwa bhandu bhoha bha alamite mu kibhungi kya nnima aghu ghwoha. ");
INSERT INTO nww_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Hinu nkilukihe pamunnyupa Chapanga, ngati nlopoke na ghala ghoha ghaabwituka na kuyima mu ulongolo ghwa Mwana ghwa Mundu.” ");
INSERT INTO nww_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Manjubha ghoha pamuhi Yesu kakibhegha pakiahunda bhandu Mukitutubhi kya Chapanga, peni mumakimuhi kakighenda kukitumbi kya mikongo hya Miseituni na kakitamaha akwo kilu kilu nda! ");
INSERT INTO nww_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Na bhandu bhoha bhakihika ku Kitutubhi kya Chapanga putiputi ngati apati annyihwa Yesu. ");
INSERT INTO nww_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pakiheghelelite kikubhukubhu kya mangate yanga kubhikwa linjacha, yiikemiteghwe Pasaka. ");
INSERT INTO nww_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Andundame akulu na ahunda bha malaghilo bhakibha bhangupalaha kihokonyo kya kunkoma Yesu, peni bhakibhayoghopa bhandu. ");
INSERT INTO nww_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Hino, Nchipila kakinnyingila Yuda, ywaankemiteghe Isikaliyote, yumoo ywa bhala ahundwa kumi na mbili. ");
INSERT INTO nww_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuda kakighenda kwa andundame akulu na kwa mahofisa bha machonda bha kupingikiha Kitutubhi kya Chapanga, kakighombana nabho kwa kya bhuli bhangankamula Yesu. ");
INSERT INTO nww_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nabho bhakiyelelwa na bhakilingana kunpegha ngalabha. ");
INSERT INTO nww_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Naywo Yuda kakiyitikila, na kakiyanda kupalaha ng'ebhu ya maha ya kunkamuha Yesu kwa bhene, kya nga lwa bhandu kumanya. ");
INSERT INTO nww_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hinu likihika linjubha lya mangate yangabhikwa linjacha, alyo ndo linjubha lya kuliyambika lyana mene lya Pasaka. ");
INSERT INTO nww_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Habhu Yesu kakialaghila Petili na Yohane pakilongela, “Nng'ende mukabhike kala hilyo hya Pasaka ngati tulyeghe.” ");
INSERT INTO nww_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bhene bhakinkonya, “Ghungupala tuyitendekehe kwoki?” ");
INSERT INTO nww_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu kakiayanga, “Munnyihwe! Pammegha mukuyingila kukitami, maakongana na nnume yumu kaghegha kibhigha kya machi, muntughile mbaka ku lubhagha lwakapala kuyingila, ");
INSERT INTO nww_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Munng'ombele nkola lubhagha, ‘Nhunda kangukonya, kibhegha kwoki kyumba kya ahenja, kyene nenga na ahundwa bhangu twaalyegha kikubhukubhu kya Pasaka?’ ");
INSERT INTO nww_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kataalangiha kyumba kikulu kuligholofa, kiibhikitwe maha kala. Ntendekehe amwo.” ");
INSERT INTO nww_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bhakighenda na bhakibhona kila kilibhi kibhegha tela handa paaghombilitwe Yesu. Kya habhu bhakitendekeha mulyo ghwa Pasaka. ");
INSERT INTO nww_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Palihikite lisaa, Yesu kakitama pakulyegha hilyo papamu na andumitumi bhake. ");
INSERT INTO nww_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mbole kakiaghombela, “Nikinoghelwa muno kuilyegha Pasaka ayi papamu na mwenga kukali na kumbamandwa kwa nenga. ");
INSERT INTO nww_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Hinu nunguaghombela, ndaalyegha kangi ng'obhe Pasaka mbaka payitulukila Mughubhutwa ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Mbole Yesu kakitola nnobho, kakinnumba Chapanga pakilongela, “Ntole nnobho aghu nkingulani mabhoha. ");
INSERT INTO nww_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kiyaha nunguaghombela, kutandila hinu ndanywegha kangi ng'obhe difwai yiihuma munkongo ghwa nsabibu mbaka paghupalakuhika Ghubhutwa ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Mbole kakilitola lingate, kakinnumba Chapanga, kakilimetula na kakiapegha andumitumi bhake pakilongela, “Aghu ndo mmili ghwangu ghuubhuhwa kwakya mwenga, ntende naha kya kungulungwa nenga.” ");
INSERT INTO nww_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ubhwabhuabhu mbole ya kulyegha, kakighutola ghula nnobho ghwa difwai pakilongela, “Nnobho aghu ndo Ninganilo lya hyono liibhonihitwe kukita lya hoto kwa mwahi ghwangu, ghuuyitika kwakya mwenga.” ");
INSERT INTO nww_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Peni nnole, yula ywakapalakungiluka kabhegha bahapa apa pakulyeghela papamu na nenga. ");
INSERT INTO nww_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kulyaghila Mwana ghwa Mundu kangughenda kukomwa handa muyipanganitwe na Chapanga, peni ghwaabhegha npinguhi ghwakyabhuli kwa yula yunakunkiluka.” ");
INSERT INTO nww_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Andumitumi bhake bhakiyanda kukonyana bhene kwa bhene, ghani mu bhombe ywangahotolite katatenda nnhalo ghula. ");
INSERT INTO nww_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mbole ghakibwituka maghombano mu bhala ahundwa kukita ghani kanguhwachilwa kabhe nkulu kupitingana bhangi? ");
INSERT INTO nww_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu kakiaghombela, “Abhatwa bha bhandu bhaabheghite ng'obhe Ayahudi bhanguatabhala bhandu bhabhe kwa makakala, nabho bha abheghite na makakala angulikema aghanja bha bhandu bha abhatabhala. ");
INSERT INTO nww_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Peni mwenga nkotoke kulandana na bhombe, ngati yula ywaabhegha nkulu mumwenga, yingunkwiliha kabhe nndokwa kupitingana bhoha, na kilongohi mbaka kabhe kuakeyela ayake. ");
INSERT INTO nww_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Hino ndo ywoki ywaabheghite nkulu, yula ywakutama pakulyeghela hilyo, ebu yula ywakahikeyela hilyo? Kulyaghila ndo yula ywakatama pakulyeghela hilyo! Hata naha nenga megha apa mumwenga handa nndumindumi.” ");
INSERT INTO nww_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Mwenga mmegha papamu na nenga mu mayighilo ghangu ghoha. ");
INSERT INTO nww_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Na handa bhula Tate ghwangu pakangamuhite ghubhutwa, ubhwabhu abhu na nenga nunguakamuha mwenga ghubhutwa. ");
INSERT INTO nww_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mwenga maalyegha na kunywegha pakulyegheha pangu muutabhala ghwangu, na maatama muhiteho hya ghubhutwa pamubhatosa bhandu bha makabila kumi na mbili gha Isilaeli.” ");
INSERT INTO nww_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu kakilongela, “Simoni, Simoni ghuyihwe, ghumanye kukita Nchipila kalekekehwa na Chapanga ngati abhapalangule handa mundu paayebheha mbunje hya ngano. ");
INSERT INTO nww_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Peni nenga nughuyupila kwa Chapanga ghwenga Simoni, ngati kuhyubhalila kwako kukotoke kulepelwa, na paghumuyila ghuatengelehe alongo bhako.” ");
INSERT INTO nww_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petili kakinnyanga, “Bambo, nenga megha kala kughenda papamu naghwenga kukibhopo na kuhwegha.” ");
INSERT INTO nww_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu kakinnyanga, “Ningukughombela Petili, yikali na mbichi lelo pakilo, ghwangana paundatu kukita ghungunmanya ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Mbole Yesu kakiakonya ahundwa bhake, “Panubhaalaghilite kyanga lilobota ebu nhako ghwa mbiya ebu makobasi, mkipelelwa kilibhi kyohele?” Bhakinnyanga, “Aka kaa, tukipelelwa ng'obhe na kilibhi kyohele.” ");
INSERT INTO nww_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesu kakiaghombela, “Peni hinu, ywakabheghite na lilobota kakalitole na ywakabheghite na nhako ghwake ghwa mbiya ubhwabhu abhu. Na ywanga lukechelo, kakahemengane lighwanda lyake ngati kakahemele lukechelo. ");
INSERT INTO nww_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kiyaha yityekwa mu matyeko gha Chapanga, ‘Kakibhalangilwa papamu na alemwa.’ Mihalo ayi yikityekwa kwa kya nenga, nunguaghombela kukita mihalo ayi mbaka ndendelwe.” ");
INSERT INTO nww_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ahundwa bhake bhakinng'ombela, “Bambo, ghulole, apa tubhegha na makechelo mabhili.” Kakiayanga, “Hinu yikwila.” ");
INSERT INTO nww_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu kakibhuka na kakighenda ku kitumbi kya mikongo hya Miseituni handa payibheghite hitohe hyaki, na ahundwa bhake bhakintughila. ");
INSERT INTO nww_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pakahikite akwo, kakiaghombela ahundwa bhake, “Nnyupe ngati nkotoke kuyingila mumang'eho.” ");
INSERT INTO nww_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Mwene kakilibhaghula nabho kya ng'ebhu ya utali ghwa kutagha liganga, kakichutama mayughwa pakiyupa Chapanga, ");
INSERT INTO nww_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","pakilongela, “Tate handa ghupala ghuubhuhe nnobho aghu ghwa kimbamanda, peni yibhe ng'obhe handa mumbalite nenga, ngati lila lighulipatite ndo lihotolwe.” ");
INSERT INTO nww_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nndumitumi ghwa kunani ghwa Chapanga kakinbwitukila ngati kannyonjokehe makakala. ");
INSERT INTO nww_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Naywo pakabheghite mu lihingili likulu, kakiyupa kya kukangamala munu, na lihuki lyake likibha handa mandondogholo gha mwahi ghaaponekite mu lutupi. ");
INSERT INTO nww_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mbole ya kuyupa, kakiabhuyila ahundwa bhake, kakiabhona paakighonja, bhakibha bhakitotokela kubhukana na kuhyongoloka. ");
INSERT INTO nww_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Naywo kakiakonya, “Kiyaha niki mungughonja? Nnyumuke nnyupe, ngati nkotoke kuyingila mu mang'eho.” ");
INSERT INTO nww_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu pakabheghite mukulongela, lumati lukulu lwa bhandu lukinhikila, pa lukilongohwa na Yuda ywakabheghite yumoo ywa bhala ahundwa mbinda mabhoko yimo na abhili. Naywo Yuda kakinheghelela Yesu ngati kakannjambuhe kwa kunhumbatila. ");
INSERT INTO nww_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Peni Yesu kakinng'ombela, “Bhuli Yuda, ghungunkiluka Mwana ghwa Mundu kwa kunhumbatila?” ");
INSERT INTO nww_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ahundwa bha Yesu paabhonite ghaabhwitukilite bhakinng'ombela, “Bambo, tubhakechule kechule kwa makechelo ghetu?” ");
INSERT INTO nww_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yumoo ywa andumitumi ghwa Yesu, kakinkechula nndumindumi ghwa Ndundame Nkulu kwa lukechelo na kakilikechula likutu lyake lya mbande ya nnilo. ");
INSERT INTO nww_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Peni Yesu kakilongela, “Nneke!” Kakiliyabhika lila likutu lya yula Mundu na kakinlamiha. ");
INSERT INTO nww_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mbole yesu kakiaghombela andundame akulu, na hilongohi bha amachonda bha Kitutubhi kya Chapanga na hilongohi bhangi bha Akaaisilaeli bha anhikilite ngati ankamule, “Kiyaha niki, munhikila na makechelo na hindonga, npoka? ");
INSERT INTO nww_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Pameghite papamu na mwenga mumanjubha ghoha Pakitutubhi kya Chapanga mukingamula ng'obhe. Peni ali ndo lisaa lyenu, lisaa lya makakala gha lubhindu.” ");
INSERT INTO nww_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Mbole bhakinkamula Yesu, bhakintola na bhakighenda naywo mbaka ku lubhagha Ndundame Nkulu. Peni Petili kakiatughila kya kutali. ");
INSERT INTO nww_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bhandu bhala pabhahikite kala, bhakikwata mwoto pakati ya lubhigho lwa lubhagha lwa Ndundame Nkulu na kutama papamu na kuyota mwoto, naywo Petili kakitama papamu nabho. ");
INSERT INTO nww_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nndumitumi yumo nndala, pakammonite Petili pakitama pambhwegha ya mwoto, kakinhulutulila mehu pakilongela, “Mundu ayu naywo kakibhegha papamu na Yesu!” ");
INSERT INTO nww_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Peni Petili kakilema pakilongela, “Ndala! Nenga nungunmanya ng'obhe mundu aywo!” ");
INSERT INTO nww_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mbole kya mandina, mundu yungi kakimmona Petili na kakilongela, “Ghwenga ndo yumoo ywabhe.” Peni Petili kakinnyanga, “Ghwenga mundu ghwee! Nenga ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mbole ya lisaa limu, mundu yungi kakiyanda kakibhinilila, “Kulyaghila ayi ndo hoto mundu ayu naywo kakibhegha papamu na Yesu, kiyaha ywombe naywo ndi Nngalilaya.” ");
INSERT INTO nww_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petili kakiyanga, “Ghwenga mundu ghwee! Nenga nungumanya ng'obhe kighukilongela!” Bahala pala, pakabhegha akali mukulongela mbichi yikibhika. ");
INSERT INTO nww_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Naywo Bambo kakikilibhuka na kunlolekeha Petili. Petili kakighakulungwa ghala malagho gha Yesu ghakanng'ombilite, “Lelo yikali na mbichi ghwaangiluka pandatu.” ");
INSERT INTO nww_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Mbole Petili kakighenda panje na kakilila muno. ");
INSERT INTO nww_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bhala bhandu bha abheghite mu kunpingikiha Yesu bhakiyanda kunnyuyuha na kuntuta. ");
INSERT INTO nww_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bhakinmopa lipinda mumeho na bhakinkonya, “Ghulondole! Ndo ghani aywo ywakakututite?” ");
INSERT INTO nww_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na bhakighendelela kuntendela ufyangu kwa maligho matangalo. ");
INSERT INTO nww_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Paghucheghite, njenga kaya ya aghohi hilongohi bha Isilaeli yikitama, na andundame akulu na ahunda bha malaghilo nabho bhakibhegha. Yesu kakigheghwa mulibalasa alyo. ");
INSERT INTO nww_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Bhakinng'ombela, “Handa ghwenga ndo Kilisito ghutughombele.” Yesu kakiayanga, “Handa panubhaghombela maahyubhalila ng'obhe. ");
INSERT INTO nww_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Na handa panubhayupa kunnyanga ngonyo, mannyanga ng'obhe. ");
INSERT INTO nww_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Peni kutandila hinu Mwana ghwa Mundu katatama mumbande ya nnilo ya Chapanga Yunamakalama.” ");
INSERT INTO nww_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bhoha bhakikonya, “Hinu ghwenga ndo Mwana ghwa Chapanga?” Mwene kakiayanga, “Mwenga nnongela kukita nenga ndo ywene.” ");
INSERT INTO nww_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mbole bhakilongela, “Bhuli! Tungupala uyimiho ghwoki kangi? Twabhene tuyihwa pakilongela kwa nlomo ghwake mwene.” ");
INSERT INTO nww_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mbole lumati lwoha lwa bhandu lukiyima na kunnyegha Yesu kwa Pilato. ");
INSERT INTO nww_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nabho bhakiyanda kunkokela paakilongela, “Tukimmona mundu ayu kanguapotongana bhandu bha nnima ghwetu, kanguakanikiha bhandu akotoke kunpegha sumu Mutwa nkulu ghwa Akaaloma na kangulikema mwene ndo Kilisito, Mutwa.” ");
INSERT INTO nww_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ndo Pilato kakinkonya Yesu, “Ghwenga ndo mutwa ghwa Akaayahudi?” Yesu kakinmyanga, “Gwenga ghulongela.” ");
INSERT INTO nww_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ndo Pilato kakiaghombela andundame akulu na lumati lwa bhandu, “Nighubhona ng'obhe uhokelo ghwohele ghula kwa mundu ayu!” ");
INSERT INTO nww_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Peni bhene bhakikamala kulongela, “Kanguakolekeha bhandu kwa mahundo ghake mu nnima ghwoha ghwa Yudea. Kakiyanda ako Galilaya na hinu kahika aku.” ");
INSERT INTO nww_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato pakayihwite agha kakikonya, “Mundu ayu nkolannima ghwa ku Galilaya?” ");
INSERT INTO nww_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pakamanyite kukita Yesu kakihuma kunnima ghuubheghite mumakakala gha mutwa Helode, kakinyegha kwa Helode, ywene mumanjubha agho kakibhegha akwo ku Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helode kakiyelelwa muno pakammonite Yesu, kiyaha kwa manjubha matangalo kakiyihwa mihalo miyoloho yakya Yesu kakidumbila kummona. Kangi kakipala kummona pakitenda naho. ");
INSERT INTO nww_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Helode kakinkonya Yesu makonyo matangalo, peni Yesu kakinnyanga ng'obhe kyohele. ");
INSERT INTO nww_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Akaandundame akulu na ahunda bha malaghilo bhakihika kuulongolo, bhakinkokela Yesu kwa ukalipo munu. ");
INSERT INTO nww_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Helode na amachonda bhake bhakinkinila Yesu na kunbhikila ubhichi. Bhakinhwaliha lipinda lya kibhutwa na bhakinbhuyila kwa Pilato. ");
INSERT INTO nww_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kalongohi, Helode na Pilato bhakibha amyanja, peni kutandila linjubha alyo akibhegha aghanja. ");
INSERT INTO nww_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Hinu Pilato kakiakema akaandundame akulu, na hilongohi bha Akaayahudi na bhandu bhangi, ");
INSERT INTO nww_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","kakiaghombela, “Mwenga mungunnyegha mundu ayu kwa nenga pamunlongela kukita kanguakolekeha bhandu bhaghukiluke utabhala. Hinu nnyihwe! Mbole ya kuhingukiha nhalo agho paulongolo ghwenu nikighubhona ng'obhe uhokelo mungokelo yenu kwa mwene. ");
INSERT INTO nww_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ebhu Helode kakimmona ng'obhe na uhokelo ghwohele ndo mana kakimmuyila kwa nenga. Kulyaghila mundu ayu katenda ng'obhe kyohele kya kuntenda kahweghe. ");
INSERT INTO nww_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Hinu ningukwilikiha katutwe hindomondo na ndanlekekeha.” ");
INSERT INTO nww_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Mu kila kikubhukubhu kya Pakasa yikibha hitohe ya Palato kubhahughulila bhandu nbhopwa yumu. ");
INSERT INTO nww_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ndo bhandu bhoha bhakituta kyobho kwa papamu, “Ghunkome mundu aywo! Ghutuhughulile Balaba!” ");
INSERT INTO nww_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balaba kakibhopwa mu kibhopo kiyaha kakilongoha bhulwa ngulu mu kitami na kya kukoma. ");
INSERT INTO nww_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato kakipala kunlekekeha Yesu, ndo kakilongela nabho kangi. ");
INSERT INTO nww_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Peni bhene bhakiyendelela kututa kyobho pakilongela, “Ghunmangalile mulupingika! Ghunbhambe mulupingika!” ");
INSERT INTO nww_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kya pa ndatu Pilato kakiaghombela, “Katenda uhekelo ghani? Nenga ningughubhona ng'obhe uhokelo ghwohele kwa ywombe lya kuntenda kakomwe, hinu nda nntuta hindomondo mbole ndanlekekeha.” ");
INSERT INTO nww_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Peni bhene bhakiyendelela kututa kyobho kwa makakala muno, kukita yingunnogha kakamangalilwe. Mu uhiko malobhe ghabhe ghakikingamwa. ");
INSERT INTO nww_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Hinu Pilato kakilamula kukita kila bhaakipala bhandu kitendeke. ");
INSERT INTO nww_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kakimmopolela yula mundu bhaanpalite, ywakabheghite mu kibhopo, ywene ywakatendite bhulwa ngulu kwa utabhala na kukoma bhandu. Na kakinkamuha Yesu mu mabhoko ghabhe, ngati bhantendele handa mwaapalite. ");
INSERT INTO nww_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Amachonda pa abheghite mu kunnyegha ku Goligota, bhakikongana na mundu yumu ankemite Simoni ghwa Kulene, ywakabheghite mu kubhuya kuhuma panji ya kitami. Hinu bhakinkamula na bhakinpapiha lula lupingika kaluyeghe kuhyetu kwa Yesu. ");
INSERT INTO nww_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lumati lukulu lwa bhandu lukimmutukila, pakibhegha adala bhaabheghite mu kunlilila na kunhyononekela. ");
INSERT INTO nww_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu kakiaghalambukila, na kakiaghombela, “Mwenga makaadala ghwa Yelusalemu, nkotoke kunilila nenga ngati mulilile mabhene na bhana bhenu ");
INSERT INTO nww_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kiyaha kulyaghila manjubha ghatahika apo bhatalongela, ‘Bhanonelwa bhala adala bhangalela, ebu mabhele ghangayongeha.’ ");
INSERT INTO nww_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kiyaha mu manjubha agho bhandu bhatayanda kuhighombela hitumbi, ‘Mutughweghele!’ Na hitumbi hichoko hichoko, ‘Mutugubike’ ");
INSERT INTO nww_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kiyaha handa bhandu bhaghutendelaa bhabhu nkongo nmihi, kwa njilo yabhegha bhuli?” ");
INSERT INTO nww_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Machonda bhakintola Yesu papamu na ahakata abhili, ngati bhakabhambwe mulupingika. ");
INSERT INTO nww_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Paahikite pala apakemite Lihuhu lya Mutwe, apa ndo bhakinmangalila Yesu mulupingika, na bhala ahakata abhili bhakiabhamba kila yumo mulupingika lwake yumo mu mbande hyaki ya nnilo ya Yesu na yumo mumbande hyaki ya kungiya. ");
INSERT INTO nww_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu kakilongela, “Tate ghubhalekekehe kiyaha bhangumanya ng'obhe kila kyabhaatenda!” Mbole bhakigabhana mapinda ghake kwa kutenda simbi. ");
INSERT INTO nww_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bhandu bhakiyima apwo pa akinlolekeha, na hilongohi ghwa Akaayahudi bhakinbhicha Yesu pa akilongela. “Kakialopoha bhangi! Hinu kalilopohe mwene, handa mwene ndo Kilisito ywakahaghulitwe na Chapanga!” ");
INSERT INTO nww_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Amachonda nabho bhakihika, na bhakintendela ubhichi na kunkinila, bhakinyeghela kilobhi ili kakanyweghe. ");
INSERT INTO nww_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nabho bhakinng'ombela, “Handa ghwenga ndo Mutwa ghwa Akaayahudi, ghulilopohe ghumwene.” ");
INSERT INTO nww_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Hilahila unani mwa lupingika lwake bhakilubhika lupapi luutyekitwe malembo agha, “AYU NDO MUTWA GHWA AKAAYAHUDI.” ");
INSERT INTO nww_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yumoo ghwa bhala ahokelo bhaamangalilitwe papamu naywo kakintendela ufyangu pakalongele, “Ghwenga ndo Kilisito ng'obhe? Ghulilopohe ghumwene na ghutulopohe na twenga.” ");
INSERT INTO nww_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Yula nhokelo yungi kakinlakalila nnyake, pakilongela, “Ghwenga, bhuli ghungunnyoghopa ng'obhe Chapanga na ghubhegha mutoso ahyo ahyo? ");
INSERT INTO nww_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Twenga tutoswa kwa shaliya kiyaha tungunoghwa toso ya ndendelo yetu. Peni mundu ayu kakitenda ng'obhe kyohele kihakata.” ");
INSERT INTO nww_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mbole kakilongela, “Bambo Yesu, ghuhwachile nenga paghuyingila mu Ubhutwa ghwako.” ");
INSERT INTO nww_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu kakinnyanga, “Kulyaghila, nungughughombela hoto, lelo ghwabhegha papamu na nenga ku Paladiso.” ");
INSERT INTO nww_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Yikibhegha handa saa sita, kukibhegha na lubhindu mu nnima ghwoha mbaka saa tisa, kiyaha luchubha lukileka kubhuha bhwelo. ");
INSERT INTO nww_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Na lipasia liighabhanite pabhili Kitutubhi kya Chapanga likibaluka hipalamande hibhili. ");
INSERT INTO nww_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu kakilila kwa lilobhe likulu, “Tate, mu mabhoko ghako ningughubhika nhuki ghwangu.” Mbole ya kughalongela agha kakihwegha. ");
INSERT INTO nww_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yula machonda kilongohi pakabhonite agha, kakintika Chapanga pakilongela, “Kulyaghila mundu ayu kakighatughilagha ghala ghakaghapala Chapanga!” ");
INSERT INTO nww_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bhandu bhoha bhaaghendite kwakya nhalo agho, paabhonote agho ghaabwitukilite bhakibhuya ukaya kwabhe kunu bhaakilituta tuta mu hifubha hyabhe kubhoneha kukita bhakibhegha na hyononeko munu. ");
INSERT INTO nww_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Peni aghanja, alongo na bhoha bhaanmanyite Yesu, papamu na bhala adala bhantughilite kuhuma ku Galilaya, bhakiyima kya kutali paakilolekea nnando aghwo. ");
INSERT INTO nww_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Hinu, kukibha na mundu yumu ywa maha lihina lyake likibha Yosefu, ywakabheghite nkolannima ghwa Kualimataya akwo Yudea, kakibhegha mundu ywakaghatughila ghghapalite Chapanga na ywa kuhokamilwa. ");
INSERT INTO nww_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Alimatayu kakibhegha mukughulimbilila Ghubhutwa ghwa Chapanga. Mwene kakibhegha yumoo ywa bhandu bha munjengakaya ya Akaayahudi, peni mwene kakililunga nabho ng'ohe mutoso na ndendelo ya alongohi ayake, naywo kakibhegha mukughulindila Ghubhutwa ghwa Chapanga kwa upalo nkulu. ");
INSERT INTO nww_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yosefu kakighenda kwa Pilato kuyupa kakakamuhwe mmili ghwa Yesu. ");
INSERT INTO nww_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kakighuhuluha kuhuma kulupingika, kakighubhulungilila sanda na kughubhika mulindogholo lihongolitwe mulitalabha, mualyo lindogholo kakibhikwa ng'obhe mundu ywohele. ");
INSERT INTO nww_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Linjubha alyo, likibhegha linjubha lya utendekeho, na Linjubha la Kupumulila, likibhegha ugheghela kuyanda. ");
INSERT INTO nww_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Bhala adala bhaahikite papamu na Yesu kuhuma ku Galilaya, bhakintughila Yosefu, bhakilibhona lila lindogholo na bhuli bhuli Yosefu kakighughonjeha mmili ghwa Yesu. ");
INSERT INTO nww_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mbole bhakibhuya ukaya na bhakitendekeha luhumba lwa kunungila na mahuta ghaanungila gha kughutyeka mmili ghwake. Peni bhakipumulila Linjubha lya Kupumulila handa muyibheghite malaghilo gha Musa. ");
INSERT INTO nww_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mulinjubha lya ulongohi lya juma, malabhila putiputi, adala bhala akilutola luhumba lwa kunungila bhaalubhikite kala na bhakighenda kulindogholo. ");
INSERT INTO nww_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bhakilibhona lila liganga likulu liigubikite lindogholo libhilingihwa kala kuhuma mu lindogholo, ");
INSERT INTO nww_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Peni paayingilite mu lindogholo bhakighubhona ng'obhe mmili ghwa Bambo Yesu. ");
INSERT INTO nww_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Paabheghite mu kukangacha nhalo aghwo, kamu bhandu abhili bha ahwalite mapinda ghang'anyimite muno handa limuli lwa njahe, bhakiyima ugheghela nabho. ");
INSERT INTO nww_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bhala adala bhakiyingilwa lyogha munu na bhakihokama mbaka palutupi. Peni bhala bhandu bhakiaghombela, “Kiyaha niki mungunpalaha yunaubhumi paatama bhaahweghite? ");
INSERT INTO nww_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kabhegha ng'obhe apa kahyuka kala! Mughakulungwe ghala ghakaaghombilite pakabheghite na mwenga akwo Galilaya, ");
INSERT INTO nww_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","kukita, ‘Yikibhegha mbaka Mwana ghwa Mundu kakamuhwe mumabhoko gha bhandu bhanaulemwa, na ahakata, kabamangalilwe na linjubha lya ndatu kahyuke.’ ” ");
INSERT INTO nww_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kamu ndo bhakighakulungwa malagho ghabhaghombilitwe na Yesu. ");
INSERT INTO nww_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Paabhuyite kuhuma akwo kulindogholo, bhakiaghombela bhala ahundwa kumi na moja na bhangi mihalo aywo hyoha. ");
INSERT INTO nww_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Andumitumi bhaayeghite mihalu aywo akibhegha, Malia Magadalena, Yoana na Malia maghwake Yakobu papamu na bhangi bhaalongoanite nabho. ");
INSERT INTO nww_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Peni bhala bhaayihwite bhakihyubhalila ng'obhe, kiyaha malagho ghabhe ghakibhegha handa bhana uhila mahala. ");
INSERT INTO nww_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Hata naha Petili kakiyinuka na kughenda kula kulindogholo. Pakahokamite ngati kalolekehe mula mulindogholo, kakiyibhona sanda ghweka. Naywo kakibhuya ukaya kunu pakikangacha ghala ghabwitukilite. ");
INSERT INTO nww_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mulinjubha alyo alyo, ahundwa abhili bha Yesu bhakibhegha mumwanja kughenda kukijiji kiikemwa lihina lyake Emau, yikibha Maili saba kuhuma Kuyelusalemu. ");
INSERT INTO nww_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bhakibha bhangughombana bhene kwa bhene kya ghala ghabwitukilite. ");
INSERT INTO nww_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Pabhabheghite mukuyobhela, mwene Yesu kakiahikila na pakityanga papamu nabho. ");
INSERT INTO nww_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bhombe bhakimmona kwa meho ghabhe peni bhakimmanya chepa. ");
INSERT INTO nww_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu kakiakonya, “Ndo mihalo ghani ayi yimuyiyobhela kunu pamutyanga?” Bhombe bhakiyima, na bhakihyononeka muno. ");
INSERT INTO nww_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yumo ywabhe ywaankemite lihina lyake Kileopa, kakinkonya, “Yingubhonekana ghwenga ndo nhenja ghwa ghweka chako ghwanga kumanya ghala ghabwitukilite Yelusalemu mumanjubha agha?” ");
INSERT INTO nww_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu kakiakonya, “Mihalu yoki?” Bhombe bhakinnyanga, “Milando ya Yesu ghwa Kunasaleti. Mwene kakibha Mbuye ghwa Chapanga, na kakibhegha na makakala makulu mu malagho yake na ndendelo yake mu ulongolo ghwa Chapanga na anabhandu bhoha. ");
INSERT INTO nww_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Andundame akulu na hilongohi bhetu bhakinbhuha na bhakinntosa kuhwegha, nabho bhakimmangalila mulupingika. ");
INSERT INTO nww_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Twenga tukidumbila kukita mwene ndo nkombola ghwa Isilaeli. Peni hinu linjubha lya ndatu kuhuma paghabwitukilite agho. ");
INSERT INTO nww_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kangi, amoo bha adala bha kimati kyetu bhakitulilimuha munu. Bhakighenda kulindogholo lelo putiputi, ");
INSERT INTO nww_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","peni bhakighubhona ng'obhe mbhili ghwake. Na paabhuyite bhakilongela kukita bhakiabhona mahoka abhili bha Chapanga na abho bhakiaghombela kukita aywo Yesu kangutama. ");
INSERT INTO nww_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mbole amoo bha twenga bhakighenda kulindogholo na bhakibhona bhula bhula handa bhaalongilite bhala adala, Peni bhakimmona ng'obhe aywo Yesu.” ");
INSERT INTO nww_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Mbole Yesu kakiaghombela, “Mwenga muna uhila mahala ghwa bhuli, na atopo ghwa myoyo ya kuhyubhalila ghala ghaalongilitwe na ambuye bha Chapanga! ");
INSERT INTO nww_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bhuli, yikinkwiliha ng'obhe Kilisito ywakahaghulitwe na Chapanga kumbamandwa kwakya naha na mbole kakayingile mu ukulu ghwake?” ");
INSERT INTO nww_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kakifwambulila mihalu hyoha yakya mwene mu Malembo ghanakung'anyima kutandila mu hitabho ya Musa na mbaka mambuye bha Chapanga bhoha. ");
INSERT INTO nww_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nabho pabhabheghite ugheghela na kijiji kya aghendite, Yesu kakibhegha handa kangupala kughendelela mumwanja ghwake. ");
INSERT INTO nww_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Peni bhombe bhakinpembeleha muno katame papamu nabho, pakilongela, “Ghutame apa na twenga kiyaha ndo makimuhi na lubhindu linguyingila” Ndo kakiyingila mu kitutubhi na kakitama nabho. ");
INSERT INTO nww_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Pakatamite kulyegha hilyo papamu nabho, kakitola lingate, kakilinonela, na kakilimetula na kakiapegha. ");
INSERT INTO nww_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kamu mehu ghabhe ghakihughulighwa, na bhakinmanya kukita ndo Yesu, peni mwene kamu kakibhuka mu bhene. Na bhakimmona kangi ng'obhe. ");
INSERT INTO nww_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bhakikonyana bhene kwa bhene, “Bhuli, mioyo yetu yikiyaka ng'obhe kwa uyelelo pala pakabheghite mu kulongela na twenga mu njila na kutuhunda malembo?” ");
INSERT INTO nww_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kamu bhakibhuka na bhakibhuya ku Yelusalemu. Bhakihika kwa bhala ahundwa kumi na moja na bhala bhabheghite papamu nabho, bhakikunganika ");
INSERT INTO nww_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","bhakiaghombela bhala ahundwa abhili, “Kulyaghila Bambo kahyuka, naywo kakinbwitukila Simoni.” ");
INSERT INTO nww_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mbole bhala ahundwa abhili nabho bhakiaghombela ghala ghabhabwitukilite mu njila na kyabhuli bhakinmanya Yesu pakalimetulite lingate. ");
INSERT INTO nww_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pabhabheghite mukubhaghombela agho, mwene Yesu kakiyima pakati yabhe na kakiaghombela, “Ntame kya uhihimilo.” ");
INSERT INTO nww_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bhakililimuka na bhakiyoghopa na bhakihwacha kukita bhakighubhona nhuki. ");
INSERT INTO nww_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Peni Yesu kakiakonya, “Kiyaha niki munguyoghopa? Kiyaha niki mmegha na bhwaghalili mumyoyo yenu? ");
INSERT INTO nww_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mughalole mabhoko na maghulu ghangu ndo mmanye kukita ndo nenga. Mughubyale mmili ghwangu kiyaha nhuki ghubhegha ng'obhe na mmili ebu kihupa handa pamumumona.” ");
INSERT INTO nww_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Pakaghaghombite agha, kakiabhoneha mabhoko na maghulu ghake. ");
INSERT INTO nww_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bhakiyelelwa munu, kunu paakangacha mbaka bhakinhyubhalila ng'obhe kukita ghala ghaabhabhonite ndo hoto, ndo Yesu kakiakonya, “Mmegha na hilyo hyohele apa?” ");
INSERT INTO nww_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bhakinpegha kipalamande kya homba ghwa kubanika, ");
INSERT INTO nww_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","naywo kakikitola na kakilyegha mu ulongolo ghwabhe. ");
INSERT INTO nww_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Mbole kakiaghombela, “Ayi ndo fwambulo ya ghala ghanibhaghombilite pangali na mwenga, kukita ghoha ghatyekitwe yakya nenga Mumalaghilo gha Musa, na ambuye bha Chapanga na Saburi mbaka ghatulukile.” ");
INSERT INTO nww_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ndo kakighahughula malango ghabhe ngati bhabheghe na makakala gha kughamanya malembo gha Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kakiaghombela, “Agha ndo ghaatyekitwe, Kilisito ywakahaghulitwe na Chapanga katabamandwa na linjubha lya ndatu katahyuka kuhuma kubhaahweghite.” ");
INSERT INTO nww_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kangi kwa lihina lya Yesu bhandu bha milima hyoha kutandila Yelusalemu bhaalandamihwa kukita bhalipetule ulemwa ghwabhe ngati Chapanga kabhalekekehe ulemwa ghwabhe. ");
INSERT INTO nww_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Na mwenga ndo ayimiho bha mihalo ayi na yinguakwiliha kulandamiha ghoha ghamughabhonite. ");
INSERT INTO nww_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Nnole nenga ndanlaghila Nhuki ghwa Chapanga, ywene Tate kakilaghite kukita kataapegha. Peni nlindile apa pakitami mbaka pankingama lila likalama kuhuma kunani.” ");
INSERT INTO nww_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Mbole ya kualongoha ahundwa bhake panje ya kitami mbaka ku Betania, kakiyinula mabhoko ghake kunani na kubhanonela. ");
INSERT INTO nww_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Pakabheghite mu kuanonela kakialeka, kakitolwa kughenda kunani kwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mbole bhakichutamila mayughwa na kuntundamila na bhakibhuya Yelusalemu paakibhegha na uyelelo nkulu. ");
INSERT INTO nww_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bhakitama masaa ghoha Mukitutubhi kya Chapanga kunu paakintika Chapanga. Ayi mwika.");
INSERT INTO nww_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Paulongohi yikali ya kubhumbwa nnima pakibhegha lilagho, aywo lilagho kakibhegha kwa Chapanga, naywo lilagho kakibhegha Chapanga. ");
INSERT INTO nww_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kutandila kalongohi aywo Lilagho kakibhegha papamu na Chapanga. ");
INSERT INTO nww_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Hilibhi hyoha hikibhumbwa kupitila ywombe, hangi kya nga ywombe kahone kilibhi kyoheli kiibhumbwite. ");
INSERT INTO nww_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mu ywombe ndo muubheghiti ubhumi na ubhumi aghwo ghukiyegha lung'ali lwa bhandu. ");
INSERT INTO nww_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Na lung'ali alwo lung'anyima palubhindo, nalwo lubhindo lukiluhotola ng'obhe alwo lung'ali. ");
INSERT INTO nww_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kakibhegha mundu yumu ywakalaghilitwe na Chapanga, mundu aywo kakikemwa Yohane. ");
INSERT INTO nww_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yohane kakihika kuaghombela bhandu kulinga alwo lung'ali, ili bhandu bhoha bhaliyihwe lilagho lyake na bhahyubhalile. ");
INSERT INTO nww_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Aywo Yohane kakibhegha ng'obhe alwo lung'ali, ngati kakihika kuaghombela bhandu yakya alwo lung'ali. ");
INSERT INTO nww_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Alu ndo lung'ali menyu, lung'ali luuhika pannima, kubhang'alikiha bhandu bhoha. ");
INSERT INTO nww_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Hino, Lilagho kakibhegha paunnima na payibhele bhandu bha pannima bhakibhumbwa na ywombe, peni bhandu bhakinng'amula ng'obhe. ");
INSERT INTO nww_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Kakihika kwa bhandu bhake, peni bhombe bhakinkingama ng'obhe. ");
INSERT INTO nww_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Peni bhala bhaankingamite na kunnhyubhalila, kakiatenda kubhegha bhana bha Chapanga. ");
INSERT INTO nww_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Abha ndo bhala bhaabhelekitwe chepa kwa mabhumbo bhandu muabhelekwa, ebu kiyaha bhandu bhangupala kubhegha na bhana, ngati abhelekwa na Chapanga mwene. ");
INSERT INTO nww_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Naywo kakitendekwa mundu, kakitama na twenga, na twenga tukighubhona ukulu ghwake, ukulu handa ghwa Mwana ywa kighweka ywakahuma kwa Tate, kamemwa luhungu na uhoto. ");
INSERT INTO nww_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohane kakiaghombela bhandu mihalo yake. Kakikweha lilobhe, “Ayu ndo yunubhaghombilite kukita, ‘Ywombe ndo yunakuhika mbole ya nenga ndo nkulu kupitingana nenga, kiyaha kakibhegha yikali na nenga kubhelekwa.’” ");
INSERT INTO nww_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kubhukana na utangalo gha umaha ghwake katupegha unonelo ntangalo ngenju. ");
INSERT INTO nww_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kiyaha Malaghilo ghakikamuhwa kupitila kwa Musa, umaha ghwa Chapanga na uhoto ghuhika kukindila kwa Yesu Kilisito. ");
INSERT INTO nww_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kahone mundu ywakammonite Chapanga nndaluko ghwohele, maha nga Mwana ywa Chapanga ywa kighweka, kabhegha papamu na Tate, ndo ywakankambuhite kwa twenga. ");
INSERT INTO nww_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Hilongohi bha Ayahudi bha akwo Yelusalemu, bhakialaghila amoo Akaandundame na Akaalawi kwa Yohane kunkonya, “Ghwenga ndo ghani?” ");
INSERT INTO nww_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohane kakialongela hoto, “Nenga chepa Kilisito, Nkombohi ywkahaghulitwe na Chapanga.” ");
INSERT INTO nww_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bhakinkonya kangi, “Hinu ghwenga ndo ghani?” Ghutughombele, ghwenga ghu Eliya? Yohane kakiyanga, “Aka kaa, nenga ng'obhe.” “Ebu ghwenga ndo yula Mbuye?” Kakiyanga, “Ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ndo bhakinng'ombela, “Hinu ghutughombele ghwenga ghu ghani tuabhuyihile luyango bhala bhaatulaghihite. Ghwenga ghungulongela bhuli yakya ghumwene?” ");
INSERT INTO nww_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohane kakiayanga kwa malagho gha Mbuye Isaya, pakalongela, “Nenga ndo mundu yumu ywakakweha lilobhe kuhuma kukibhala. Muyigholelehe njila ya Bambo!” ");
INSERT INTO nww_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Hino, bhala bhandu bhakilaghilwa na Afalisayu, ");
INSERT INTO nww_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","bhombe bhakinkonya paalongela, “Handa ghwenga ndo kilisto ng'obhe, ebu Eliya ng'obhe na kukita yula mbuye ng'obhe, kya bhuli ghungubatisa?” ");
INSERT INTO nww_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohane kakiayanga, “Nenga nungubatisa kwa machi, peni munkati yenu kabhegha mundu yumu ywangakummanya. ");
INSERT INTO nww_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mbole yamanjubha ghaapala kuhika, kaahika ywombe, nunguhotola ng'obhe kubhopola ngoyi hya makubasi ghake.” ");
INSERT INTO nww_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Milando ayi yikitendekwa akwo Betania kumwambo ya lukemba lwa Yoludani, kwene Yohane kwakabheghite kangubatisa. ");
INSERT INTO nww_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kilabhu yake, Yohane kakimmona Yesu pakinhikila, na kakilongela, “Nnole, Mwanamene ywa Chapanga ywakatola ulemwa ghwa bhandu! ");
INSERT INTO nww_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ayu ndo yula yunubhaghombilite kukita ‘Kanguhika mundu mbole ya nenga, ywene ndo nkulu kwa nenga, kiyaha kakibhegha yikali ya kubhelekwa nenga.’ ");
INSERT INTO nww_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nenga numwene nikinmanya ng'obhe, peni nenga hika kubatisa kwa machi, ngati Akaaisilaeli ammanye.” ");
INSERT INTO nww_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Mbole Yohane kakilongela, “Nikimmona Nhuki pakihuluka kuhuma Kunani kwa Chapanga handa ngunda, naywo kakitama unani mwaki. ");
INSERT INTO nww_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nenga nikimmanya ng'obhe, peni ywombe ywakanaghilite batise bhandu kwa machi kaking'ombela, ‘Yula mundu yughupala kummona, Nhuki pakanhulukila na kutama unani mwake, aywo ndo ywakapala kubatisa kwa Nhuki ywangu nenga Chapanga.’ ” ");
INSERT INTO nww_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yohana kakighendelela kulongela, “Nenga numwene mona nnando aghu na nungulongela kukita ywombe ndo Mwana ywa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kilabhu yake, Yohane kakibhegha kangi akwo papamu na ahundwa bhake abhili. ");
INSERT INTO nww_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Pakammonite Yesu pakapita. Kakilongela “Ayu ndo Mwanamene ywa Chapanga!” ");
INSERT INTO nww_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Bhala ahundwa bhake abhili paannyihwite Yohane pakilongela agha, bhakintughila Yesu. ");
INSERT INTO nww_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu kakikilibhuka, kakiabhona bhala ahundwa paantughila na kakiakonya, “Mungupalaha niki?” Bhakinnyanga “Ghungutama kwoki, Labi?” Mu Kihebulania fwambulo ya lilagho Labi ndo “Nhunda.” ");
INSERT INTO nww_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu kakiayanga, “Nhike na mupabhone,” Hino bhakighenda na kupabhona pala pakatamiteghe, bhakitama naywo linjubha lila kiyaha yikibhegha saa kumi makimuhi. ");
INSERT INTO nww_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yumoo ywa bhala abhili bhaannyihwite Yohane pakalongila, na bhakintughila Yesu kakibhegha Andelea nnongo ywake Simoni. ");
INSERT INTO nww_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kamu Andelea kakighenda kumpalaha Simoni nnongo ywake na kunng'ombela kukita, “Tummona Masiya” Fwambulo yake, “Kilisito” ");
INSERT INTO nww_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Naywo kakinnyegha Simoni kwa Yesu. Yesu kakinnolekeha Simoni na kakinng'ombela, “Ghwenga ndo Simoni mwana ywa Yohane. Peni ghwaakemwa Kefa” kwa Kigiliki Petili fwambulo yake ndo “Litalabha.” ");
INSERT INTO nww_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kilabhu yake Yesu kakilamula kughenda ku Galilaya. Kakimmona Filipi na kakinng'ombela, “Ghundughile.” ");
INSERT INTO nww_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Naywo Filipi kakibhegha nkolannima ywa ku Betasaida, kitami kyaatamiteghe Andelea na Petili. ");
INSERT INTO nww_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipi naywo kakimmona Natanaeli na kakinng'ombela kukita, “Tummona ywombe ywene Musa kakityeka mihalo yake mu kitabho kya Malaghilo, naywo bhubho mambuye bhakityeka ya kya ywombe, naywo ndo Yesu ywa kitami kya Nasaleti Mwana ghwa Yosefu.” ");
INSERT INTO nww_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaeli kakinkonya Filipi, “Bhuli, kilibhi kya maha kyaahotola kubwitukila ku Nasaleti?” Filipi kakinnyanga. “Ghuhike na ghulole.” ");
INSERT INTO nww_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu pakammonite Natanaeli kanguntughila, kakilongela yakya ywombe, “Kulyaghila ayu ndo Nmundu ywa ku Isilaeli menyu, kahone ukubhuhi mu mwoyo ghwake!” ");
INSERT INTO nww_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaeli kakinkonya, “Ghumanya bhuli?” Yesu kakinnyanga, “Nikighubhona paghubheghiteghe pahi ya nkongo ghwa tini ikali Filipi kughukema.” ");
INSERT INTO nww_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaeli kakinng'ombela! “Nhunda, Ghwenga ndo Mwana ghwa Chapanga! Ghwenga ndo Mutwa ghwa Isilaeli!” ");
INSERT INTO nww_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu kakinng'ombela, “Ghunguhyubhalila kiyaha nikighughombela nikighubhona paghubhegheteghe pahi ya nkongo ghwa tini? Hino ghwabhona milando mikulu kyanalumu kupitingana alyo” ");
INSERT INTO nww_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ndo! Kakinng'ombela, “Kulyaghila ningubhaghombela, mwenga maabhona kunani kwa Chapanga paghuyughuka na mahoka bha Chapanga paakwela na kuhuluka unani mwa Mwana ywa Mundu.” ");
INSERT INTO nww_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Linjubha lya ndatu kukibhegha Chekwa ya kutolana mukitami kya Kana, ku nkoa ghwa Galilaya, naywo mama ywake Yesu kakibhegha akwo. ");
INSERT INTO nww_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu na ahundwa bhake bhakilalikwa bhubho kuchekwa ayo ya kutolana. ");
INSERT INTO nww_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Difwai payipelite mama ywake Yesu kakinng'ombela Yesu, “Bhapelelwa difwai.” ");
INSERT INTO nww_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu kakinnyanga, “Mama megha na niki na ghwenga? Lisaa lyangu likali kuhika.” ");
INSERT INTO nww_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mama ywake Yesu kakiaghombela bhala andumitumi, “Lyoheli lyakapala kubhaghombela mukitende.” ");
INSERT INTO nww_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Hino, hikibhegha hibhigha sita hya kubhikila machi, hiitendekehitwe kwa malibho kwakya kuliyogha kwa hitohe hya Akaayahudi, kila kibhigha kikikwila hijoba hibhili ebu hindatu. ");
INSERT INTO nww_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu kakiaghombela bhala andumindumi bhake, “Muhimemekehe machi hibhigha ahi.” Bhombe bhakihimemekeha ng'enang'ena. ");
INSERT INTO nww_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Mbole kakiaghombela, “Hinu nteke machi agha ghamandina, mukampeghe nkola chekwa.” Bhala andumindumi bhakitenda habhu. ");
INSERT INTO nww_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Yula nkola chekwa kakighapaha ghala machi ghaaghalambukite kubhegha difwai, kakimanya ng'obhe kuyihumite difwai yila. Peni bhala andumitumi bhaatekite machi, bhombe bhakimanya. Kakinkemela bambo ghwa chekwa pambwegha ");
INSERT INTO nww_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","na kakinng'ombela, “Bhandu bhoha apangagha huti difwai ya maha, mbole bhandu paanywegha muno na kukwila, bhangupanga difwai ya bhwakabhwaka, peni ghwenga ghuyibhika difwai ya maha mbaka hinu!” ");
INSERT INTO nww_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Aghu ndo yikibhegha naho ya kandahi ya Yesu ghakayitendite akwo Kukana ya Kugalilaya. Naha Yesu kakiyimiha ukulu ghwake na ahundwa bhake bhakinhyubhalila. ");
INSERT INTO nww_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Mbole ya agha, Yesu papamu na mama ywake na alongo bhake na ahundwa bhake, bhakighenda ku Kapelinaumu na bhakitama akwo kwa manjubha gha mandina. ");
INSERT INTO nww_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Payiheghelelite kikubhukubhu kya Pasaka yila ya Akaayahudi, Yesu kakighenda ku Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Hino, akwo kulubhigho lwa Kitutubhi kya Chapanga kakiabhona bhandu paahemela makambako gha senga na mene na ngunda, na bhangi bhakitama mu hindangabhala paahemengana ngalabha. ");
INSERT INTO nww_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kakitendekeha kighwechulo kya lughoyi, kakiabhingabhinga bhoha kubhuka panji ya lubhigho lwa Kitutubhi kya Chapanga, papamu na makambako gha senga na mene, kakighwiha hindangabhala hya bhala bhanakuhemengana ngalabha na kuhiyita ngalabha hyabhe, ");
INSERT INTO nww_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","kakiaghombela bhala bhanguchuusa ngunda, “Muhibhuhe ahi apa! Nkotoke kuyitenda Kitutubhi kya Chapanga Tate ghwangu kukita ndo ligulio!” ");
INSERT INTO nww_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Bhala ahundwa bha Yesu bhakikulungwa kukita Malembo gha Chapanga ghatyekwa, “Upalo ghwangu kwa Kitutubhi kyako Chapanga ghwanyocha handa mwoto nkati yangu, ghwenga Chapanga ywangu.” ");
INSERT INTO nww_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ndo Akaayahudi bhakinkonya, “Gwaahotola kutubhoneha naho yoki kutulaha kukita ghani kaghulaghila kughutenda nnando aghu?” ");
INSERT INTO nww_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu kakiayanga, “Nboghoyole kitutubhi aki kya Chapanga, na nenga ndayichenga kangi kwa manjubha mandatu.” ");
INSERT INTO nww_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Bhala Akaayahudi bhakilongela, “Kitutubhi aki kya Chapanga kichengwa kwa ngungwa kumi ncheche na sita! Ghwenga ghwahotola bhuli kuyichenga kwa manjubha mandatu?” ");
INSERT INTO nww_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Peni Yesu pakalongelite milando ya Kitutubhi kya Chapanga kakibhegha kangulubhulila ya kya mmili ghwake. ");
INSERT INTO nww_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Mbole ya Yesu kuhyuka, ahundwa bhake bhakikulungwa ghala ghakalongelite, ndo bhakihyubhalila Malembo na ghala malagho ghakalongelite Yesu. ");
INSERT INTO nww_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yikibhegha pala Yesu pakabheghite ku Yelusalemu kukikubhukubhu kya Akaayahudi lihina lyake Pasaka, bhandu atangalo bhakinhyubhalila pabhabhonite naho na mihabho yakayitendite. ");
INSERT INTO nww_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Peni Yesu kakiahyubhalila ng'obhe, kiyaha ywombe kakiyimanya mahwacho gha mumyoyo yabhe. ");
INSERT INTO nww_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yesu kakipalaha ng'obhe mundu ili kakanyimihe bhula paabheghite bhandu. Mwene kakimanya kala kila kiibheghite munkati ya kila mundu. ");
INSERT INTO nww_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Hino pakibhegha mundu yumu Nfalisayu, lihina lyake kakikemwa Nikodemu, kilongohi ghwa Akaayahudi. ");
INSERT INTO nww_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Aywo kakinng'endele Yesu pakilo na kunng'ombela, “Labi, tungumanya kukita ghwenga ghu nhunda ywakalaghilitwe na Chapanga, kiyaha kahone mundu yunakuhotola kutenda mihabho ayi yighuyitenda ghwenga, handa Chapanga kabhegha ng'obhe papamu na ywombe.” ");
INSERT INTO nww_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu kakinnyanga, “Kulyagila nenga ningughughombela, mundu ywohele ywangabhelekwa paubhili kaahotola ng'obhe kuyingila mu Ghubhutwa ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemu kakinkonya, “Mundu kaahotola bhuli kubhelekwa paubhili? Mundu nahota kaahotola ng'obhe kuyingila mu lutumbo lwa mama ywake pabhili na mbole kabhelekwe kangi!” ");
INSERT INTO nww_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu kakinnyanga, “Kulyaghila nenga ningughughombela, kahone mundu ywohele ywakahotola kuyingila mu Ghubhutwa ghwa Chapanga mbaka kabhelekwe kwa machi na Nhuki ywa Chapanga. ");
INSERT INTO nww_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Bhandu bhangubhelekwa kuhuma kwa abhele bhake, peni bhandu bhangughalambulwa kubhegha bhana bha Chapanga na Nhuki ywa Chapanga. ");
INSERT INTO nww_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Hino, ghukotoke kukangacha panughughombela ghungunoghwa ghubhelekwe kangi. ");
INSERT INTO nww_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Liyegha lingupula kughenda kwohele kuulipala, ghwayihwa lupulo lwake, peni kahone kulimanya kulihuma ebu kulighenda. Yibha ubhwabhu kwa mundu ywohele ywakabhelekwite kwa Nhuki.” ");
INSERT INTO nww_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemu kakinkonya, “Milando ayi yaahotoleka bhuli?” ");
INSERT INTO nww_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu kakinnyanga, “Ghwenga ghu nhunda nhwadali ywa Isilaeli, na ghwenga ghungumanya ng'obhe milando ayi? ");
INSERT INTO nww_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kulyaghila nenga ningughughombela, twenga tungukambuka ghatughamanya na kubhoneha lila litulibhona, peni mwenga mungulikana Lilagho lyetu. ");
INSERT INTO nww_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ningubhaghombela milando yiitendeka pannima, na mwenga mungunhyubhalila ng'obhe, manyubhalila bhuli panuaghombela milando ya kunani kwa Chapanga? ");
INSERT INTO nww_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kahone mundu ywohele ywakaghendite kunani kwa Chapanga maha nga ywombe ywakahulukite kuhuma kunani kwa Chapanga, ywene ndo Mwana ywa Mundu.” ");
INSERT INTO nww_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Handa bhula Musa pakannyinulite yula liyoka ywa lihabha kula kukibhala, ubhwabhu abhu Mwana ywa Mundu kangukangunoghwa kuyinulighwa kunani, ");
INSERT INTO nww_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ili mundu ywohele ywakanhyubhalila kabheghe na ubhumi ghwa manjubha ghoha ghwanga kupela. ");
INSERT INTO nww_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Kiyaha Chapanga kakighupala nnima mbaka kakimmuha Mwana ghwake ghwa kighweka, ngati kila mundu ywakanhyubhalila kakotoke kuhobha, ngati kabheghe na ubhumi ghwa manjubha ghoha ghanga pela!” ");
INSERT INTO nww_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kiyaha Chapanga kakinnaghila ng'obhe Mwana ghwake ngati kaghutose nnima, maha kaghulopohe nnima. ");
INSERT INTO nww_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mundu ywohele ywakanhyubhalila Mwana kaatoswa ng'obhe, peni mundu ywohele ywanga kunhyubhalila Mwana kaatoswa kala, kiyaha kakinhyubhalila ng'obhe Mwana ywa kighweka ywa Chapanga. ");
INSERT INTO nww_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na toso yene ndo ayi, kukita lung'ali luhika pannima, peni bhandu bhalupala lubhindo bhaghulema lung'ali, kwa ndendelo yabhe ya uhokelo. ");
INSERT INTO nww_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kila mundu ywakatenda uhokelo kangulukalalila lung'ali, kangi kanguhika ng'obhe palung'ali ngati mandendelo ghake gha uhokelo ghakotoke kung'alighwa. ");
INSERT INTO nww_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Peni bhala bhanakughungila gha hoto bhanguhika palung'ali, ili mandendelo ghabhe ghabhonekane paubhwelo kukita ghatendeka handa paapala Chapanga. ");
INSERT INTO nww_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mbole ya agho, Yesu na ahundwa bhake bhakighenda ku nnima ghwa Yudea, nabho bhakitama akwo manjubha gha mandina na bhakiabatisa bhandu. ");
INSERT INTO nww_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohane naywo kakibhegha kangubatisa akwo ku Ainoni ugheghela na kijiji kya Salimu kiyaha akwo kukibhegha na machi ngenju. Bhandu bhakinng'endela akwo ngati bhabatiswe. ");
INSERT INTO nww_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ayi yikibhegha yikali na Yohane kubhopwa kukibhopo. ");
INSERT INTO nww_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Linjubhalimu ghakihwimbuka malimbano muamoo bha ahundwa bha Yohane yunakubatisa na Nnyahudi yumu yakya luhumu lwa kitohe kya kukuha yikali ya kutundamila. ");
INSERT INTO nww_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bhala ahundwa bhakinng'endela Yohane na bhakinng'ombela, “Nhunda, yula mundu ywakabheghite na ghwenga kumwambo ya lukemba lwa Yoludani, ywene ghwenga ghukitughombela mihalo yake, hinu kangubatisa na bhandu atangalo bhangunng'endela.” ");
INSERT INTO nww_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohane kakiayanga, “Kahone mundu ywakahotola kumokola kilibhi kyohele, ngati mbaka kapeghwe na Chapanga. ");
INSERT INTO nww_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Na mwenga ndo ayimiho bha nenga kukita nikilongela, ‘Nenga nu Kilisto ng'obhe ywakahaghulitwe na Chapanga, ngati naghilwa ninnongolele ywombe.’ ");
INSERT INTO nww_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nndala yunakutolelwa ndo ywake bambo yunakutolela, peni ghanja ywake bambo yunakutola, kanguyelelwa munu pakaliyihwa lilobhe lya bambo yunakutolela. Hinu nunguyelelwa kyanalumu. ");
INSERT INTO nww_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ywombe yingunnogha kabheghe nkulu munu na nenga yingunnogha meghe nndoko.” ");
INSERT INTO nww_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ywombe ywakahika kuhuma kunani kabhegha kunani kwa bhandu bhoha. Na ywombe ywakabheghite pannima ndo ywa pannima naywo kanguyobhela milando ya pannima, ngati ywombe ywakahikite kuhuma kunani kwa Chapanga kabhegha nnkulu kwa bhandu bhoha. ");
INSERT INTO nww_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ywombe kanguaghombela bhandu ghala ghakaghabhonite na kughayihwa, peni kahone mundu ywakauyitikila uyimiho ghwake. ");
INSERT INTO nww_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Peni mundu ywohele ywakauyikitila uyimiho aghwo kanguyimiha kukita ghakalongela Chapanga ndo hoto. ");
INSERT INTO nww_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ywombe ywakalagihitwe na Chapanga kangulongela malagho gha Chapanga, kiyaha Chapanga kangunpegha Nhuki ywake ili kannongohe mundu aywo kwa milando hyoha. ");
INSERT INTO nww_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tate kangunpala Mwana, naywo kampegha hilibhi hyoha ili kahitabhale. ");
INSERT INTO nww_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mundu ywohele ywakanhyubhalila Mwana ywa Chapanga kangubhegha na ubhumi ghwa manjubha ghoha, peni mundu ywanga kunhyubhalila Mwana kataghubhona ng'obhe ubhumi, ngati kiyaghabhu kya Chapanga kyabhegha unani mwake kyanga uhiko. ");
INSERT INTO nww_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Afalisayo bhakiyihwa kukita Yesu kakibhegha kangumokola na kuabatisa ahundwa atangalo kupitingana Yohane. ");
INSERT INTO nww_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Peni Yesu mwene kakibatisa ng'obhe, ngati ahundwa bhake ndo bhakibatisa. ");
INSERT INTO nww_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu pakayihwite nhalo aghu, kakibhuka ku Yudea na kakibhuya kangi mbaka ku Galilaya, ");
INSERT INTO nww_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","mu mwanja aghwo yikinnogha kapitile pakati ya Samalia. ");
INSERT INTO nww_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Hino, kakihika kukitami kimu kya Samalia kiikemiteghwe Sikali, ugheghela na nng'unda ghula ghwene Yakobu kakinpegha mwana ywake Yosefu. ");
INSERT INTO nww_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Pahala apo pakibhegha na kilibha kya Yakobu, kubhukana na kutotokela na mwanja, Yesu kakitama pambwegha ya kilibha. Yikibhegha handa saa lya luchubha lwa londondohi. ");
INSERT INTO nww_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Hino, nndala yumu Nsamalia kakihika kuteka machi, na Yesu kakinng'ombela, “Ghumbeghe machi nyweghe.” ");
INSERT INTO nww_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Peneapo ahundwa bha Yesu bhakighenda ku mbwani kuhemela hilyo. ");
INSERT INTO nww_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Hino, yula nndala kakinnyanga, “Ghwenga ghu Nnyahudi na nenga nu nndala Nsamalia, ghunghotola bhuli ghunyupe machi?” Akaayahudi bhakibhegha bhangulihanga ng'obhe na Akaasamalia na kutenda kyohele papamu. ");
INSERT INTO nww_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu kakinnyanga yula nndala, “Handa ghungamanyite kilibhi kyene Chapanga kanguhotola kughupegha, na ywoki ywakakughombela ghumbeghe machi nyweghe, ghwenga ghungannyupite kaghupeghe machi ghaabheghite na ubhumi.” ");
INSERT INTO nww_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yula nndala kakinkonya, “Bambo, ghwenga ghubhegha ng'obhe na nteko ghwa kutekela machi, na kilibha aki kitandamahu. Agha machi ghaabheghite na ubhumi ghwaghapiha kwoki? ");
INSERT INTO nww_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Bhuli, ghwenga ghu unkulu kupitingana tate ywetu Yakobu ywene, ywakatupeghite kilibha aki. Kyene ywombe papamu na bhana bhake na anyama bhake bhakikitumila?” ");
INSERT INTO nww_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu kakinnyanga, “Mundu ywokele ywakanywegha machi agha katabona nyota kangi. ");
INSERT INTO nww_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Peni ywohele ywakaywegha machi gha nonda kunpegha nenga, kaabhona ng'obhe nyota manjubha ghoha. Machi gha nonda kunpegha ghaabhegha nkati mwaki na luhemuku lwa machi palupopoheka ubhumi ghwangapela ghwa manjubha ghoha.” ");
INSERT INTO nww_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Yula nndala kakinng'ombela Yesu, “Bambo, chonde ghumbeghe machi agho ngotoke kubhegha na nyota kangi, hangi ngotoke kuhika kangi apa kuteka machi.” ");
INSERT INTO nww_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu kakinng'ombela, “Ghughende ghukankeme nngwana ywako, ghuhike naywo apa.” ");
INSERT INTO nww_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Yula n'dala kakiyanga, “Nenga nanga nngwana.” Yesu kakinng'ombela, “Ghulongela hoto kukita ghwanga nngwana. ");
INSERT INTO nww_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Mana ghubhegha kala na angwana nhano, na nngwana yughubheghite naywo hinu chepa nngwana ywako. Apa ghulongela hoto.” ");
INSERT INTO nww_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Yula nndala kakilongela, “Bambo, nungubhona kukita ghwenga ghu mbuye. ");
INSERT INTO nww_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Akaatate bhetu Asamalia bhakitundamila pakitumbi aki, peni mwenga Makaayahudi mungulongela yingunoghwa tukatundamile akwo Yelusalemu.” ");
INSERT INTO nww_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu kakinnyanga, “Nndala, ghunyubhalile, linjubha lyahika lyena maantundamila ng'obhe Tate pa kitumbi aki, ebu akwo Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mwenga Makaasamalia mungutundamila kyanga kukimanya, peni twenga Twakaayahudi tungutundamila kitukimanya, kiyaha ulopohi ghunguhuma kwa Akaayahudi. ");
INSERT INTO nww_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Peni lisaa linguhika na libhegha kala, lyene bhandu bhanakutundamila kya uhoto bhatantundamila Tate mu nhuki na hoto, kiyaha Tate kanguapalaha bhandu bhaantundama kya habhu. ");
INSERT INTO nww_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Chapanga ndo nhuki, na bhoha bhanakuntundamila yibhanogha bhantundamile kwa nhuki na hoto.” ");
INSERT INTO nww_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yula nndala kakinng'ombela Yesu, “Ningumanya kukita Kilisto Nkombohi pakapala kuhika, katatufwambulila milando hyoha.” ");
INSERT INTO nww_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu kakinng'ombela yula nndala, “Nenga yunuyobhela na ghwenga, ndo Kilisto.” ");
INSERT INTO nww_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kamu ahundwa bha Yesu bhakibhuya, bhakikangacha paammonite pakayobhela na nndala. Peni kahone mundu ywakankonyite Yesu, “Ghungupala niki kwa ywombe?” Ebu “Yibheghaki ghunguyobhela na nndala ayu?” ");
INSERT INTO nww_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Yula nndala kakikileka kila kijoba kyake pala, kakibhuya kumbwani, na kualubhulila bhandu, ");
INSERT INTO nww_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Tughende mukanmone mundu ywakanubhulilite milando hyoha yiindendite. Pangi mani ndo Masihi Kilisto Nkombohi?” ");
INSERT INTO nww_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Hino bhandu bhakikwemuka kuhuma kumbwani na bhakinng'endela Yesu. ");
INSERT INTO nww_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Peniapo ahundwa bhake Yesu bhakibhegha bhangunpembeleha, “Nhunda ghulyeghe huti hilyo!” ");
INSERT INTO nww_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Peni Yesu kakiayanga, “Nenga megha na hilyo hyanga kuhimanya mwenga.” ");
INSERT INTO nww_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Hino ahundwa bhake bhakiyanda kukonyekehana, “Bhuli, kabhegha mundu ywakannyeghelite hilyo?” ");
INSERT INTO nww_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Peni Yesu kakiayanga, “Hilyo hyangu ndo kutenda ghakapala ywakanaghihite. ");
INSERT INTO nww_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mwenga mungulongela, ‘Yihighala mwehi ncheche kwaabhegha na mabeno’ Peni nenga nunguaghombela, nnyinule meho ghenu muyilolekehe mighunda, mapambiko ghabhegha kala kubenwa! ");
INSERT INTO nww_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Na yunakubena kapokela kala lifungu lyake naywo kangukungangana mbunje yakya ubhumi ghwa manjubha ghoha kyanga uhiko, ngati ywombe yunakukweta na ywombe yunakubena bhaayelelwa papamu. ");
INSERT INTO nww_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Habhu kula kulongela, ‘Yumu kangupanda, na yungi kangubena yibhegha hoto.’ ");
INSERT INTO nww_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nikialaghila mukabene mabeno mu mighunda manga kuyitendela mahengo, bhangi bhakitenda mahengo manonopo, peni mwenga mukibena motelo mu mapungwo ghabhe.” ");
INSERT INTO nww_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Akaasamalia ayoloho kuhuma ku kitami kila bhakinhyubhalila Yesu kubhukana na ghala ghakalongelite yula nndala ywakaaghombilite kukita, “Kang'ombela milando hyoha yiniyitendite.” ");
INSERT INTO nww_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Hino, bhala Akaasamalia paanhikilite Yesu, bhakinpembeleleha katami kwa bhombe. Naywo Yesu kakitama akwo manjubha mabhili. ");
INSERT INTO nww_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Na kubhukana na malagho ghake, bhandu bhakinhyubhalila. ");
INSERT INTO nww_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bhala bhandu bhakinng'ombela yula nndala, “Hinu tunguhyubhalila, chepa kiyaha ghwenga ghukitughombela malagho ghako, ngati kiyaha tunnyihwa twabheni twenga, na tungumanya hoto kukita ayu ndo Kilisto Nkombohi ghwa nnima.” ");
INSERT INTO nww_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mbole ya manjubha ghala mabhili, Yesu kakibhuka na kughenda ku Galilaya. ");
INSERT INTO nww_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kiyaha Yesu mwene kakilongela kukita mbuye kahokamilaghwa ng'obhe pannimama ghwake mwene. ");
INSERT INTO nww_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yesu pakahikite ku Galilaya, Akaagalilaya atangalo bhakinkingama kiyaha bhakibhona ghala ghakatendite akwo ku Yelusalemu mu kikubhukubhu ya Pasaka. Mana bhombe bhubho bhakibhegha mu kikubhukubhu akyo. ");
INSERT INTO nww_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Habhu Yesu kakihika kangi mbaka ku kitami kya Kana ya Galilaya, pala pakaghalambulite machi ghabheghe difwai. Akwo kukibhegha mundu yumu kilongohi, ywene mwana ywake kakibhegha ntamwa akwo ku Kapelinaumu. ");
INSERT INTO nww_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Aywo hofisa pakayihwite kukita Yesu kakihika ku Galilaya kuhumila ku Yudea, kakinng'endela Yesu na kunnyupa ngati kaghende kunnamiha mwana ywake, ywakabheghite tepatepa paulili. ");
INSERT INTO nww_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu kakinng'ombela yula kilongohi, “Mwenga bhandu kyanga kubhona naho na mihabho mahyubhalila ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Yula hofisa ghwa ghubhutwa kakinng'ombela Yesu, “Chonde Bambo, tughende ukaya kwangu yikali na mwana ghwangu kuuleka ulili.” ");
INSERT INTO nww_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu kakinng'ombela yula kilongohi, “Ghughende ukaya kwako, mwana ywako kangukeka!” Yula kilongohi kakihyubhalila ghala malagho ghakaghombelitwe na Yesu, kakibhuka na kakighenda ukaya kwake. ");
INSERT INTO nww_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Pakabheghite kakali kunjila kakibhonana na andumindumi bhake na bhakinng'ombela kukita, “Mwana ywako yughunng'endela kalama!” ");
INSERT INTO nww_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kakiakonya bhala andumitumi bhake lisaa kyakapatite upughwo mwana ywake, nabho bhakinnyanga, “Yikibha licho pamuhi lichubha lwa londondohi, utamwa ghukinneka.” ");
INSERT INTO nww_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ndo tate ywa yula mwana kakikulungwa kukita likibhegha ndo lisaa lilalila lyeni Yesu pakankambukilite, “Mwana ywako kalama.” Hino, ywombe na bhandu bhoha bha lubhagha lwake bhakinhyubhalila Yesu ndo Kilisto Nkombohi. ");
INSERT INTO nww_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ayi ndo yikibhegha naho ya ubhili yeni Yesu yakatenditi pakabhuyite Galilaya kuhumila ku Yudea. ");
INSERT INTO nww_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Mbole ya agha, kukibhegha na kikubhukubhu kya Akaayahudi, naywo Yesu kakighenda akwo Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Akwo Yelusalemu, pakibhegha litanda limo ugheghela na nlyango gwa mene, kwa likabila lya Akaaebulania likikemwa Betisata, lyene likitindilwa na mabanda nhano. ");
INSERT INTO nww_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mu mabanda agho pakibhegha na atamwa ayoloho, bhangabhona na angwabhengwabhe na bhana ulelebhaho paalindila machi ghabwangulighwe. ");
INSERT INTO nww_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kiyaha maghenda maghenda lihoka ywa Chapanga kakihuluka na kughabwangula machi gha litanda alyo, na yula ntamwa ywakabheghite ywa ulongohi kuyingila nkati mwa machi mbole ya kubwangulighwa, kakilama utamwa ghwake ghwoha ghwakabheghite naghwo. ");
INSERT INTO nww_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Hino, mundu yumu kakibhegha akwo ywene kakilwala kwa ngungwa salasini na nane. ");
INSERT INTO nww_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu pakammonite ntamwa aywo kaghonja, naywo kakimanya kukita katama apwo kwa manjubha matangalo, ndo kakinkonya, “Ghungupala kulamihwa?” ");
INSERT INTO nww_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yula ntamwa kakinnyanga, “Bambo, nenga nanga mundu ghwa kunyegha mulitanda pala machi paghabwangulighwa, pambala kuchumbukila mu litanda, kali nenga na kuyingila mundu yungi kangulopokela.” ");
INSERT INTO nww_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu kakinng'ombela, “Ghuyime, ghutole likahe lyako na ghughende.” ");
INSERT INTO nww_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kamu, yula mundu kakilama, kakitola likahe lyake na kakiyanda kutyanga. Nnando aghu ghukitendekwa linjubha lya Kupumulila, ");
INSERT INTO nww_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","kya habhu, hilongohi bha Akaayahudi bhakinng'ombela yula ywakalamihitwe, “Lelo ndo linjubha lya kupumulila, ghwenga ghungupapa likahe lyako, ghungukiluka mihilo ya linjubha lya kupumulila.” ");
INSERT INTO nww_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Yula mundu ywakalamihitwe kakiayanga, “Yula mundu ywakanamihite kaking'ombela ghutole likahi lyako na ghutyange.” ");
INSERT INTO nww_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Hino, Akaayahudi bhakinkonya, “Ndo mundu ywoki aywo ywakakughombilite ghuutole likahe lyako na ghutyange?” ");
INSERT INTO nww_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Peni yula ywakalamihitwe kakimmanya ng'obhe ndo ywoki ywakannamihite, kiyaha Yesu kakibhuka, kiyaha apo kukibhegha na lumati lukulu lwa bhandu. ");
INSERT INTO nww_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mbole ya agho, Yesu kakikongana na yula mundu ywakanlamihite mu Nyumba ya Chapanga na kakinng'ombela, “Ghuyihwe, hinu ghulama, ghukotoke kutenda ulemwa hela bhubho lyakutula lihakataho kyanalumu.” ");
INSERT INTO nww_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ndo yula ywakalamihitwe kakighenda kuaghombela hilongohi bha Akaayahudi kukita ndo Yesu ywakannamihite. ");
INSERT INTO nww_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kya habhu Akaayahudi bhakiyanda kunng'aha Yesu, kiyaha kakibhegha kangutenda milando ayo mulinjubha lya kupumulila. ");
INSERT INTO nww_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Peni Yesu kakiayanga, “Tate ywangu kangutenda lihengo manjubha ghoha, na nenga nungunoghwa kutenda lihengo kangapumulila.” ");
INSERT INTO nww_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Malagho agho ghakiayaghabhiha munu hilongohi bha Akaayahudi bhakiyigha kutenda kila njila yakya kunkoma Yesu mana kakimetula malaghilo gha linjubha lya kupumulila na kakinkema Chapanga Tate, habhu kakililinganiha ywombe tela na Chapanga. ");
INSERT INTO nww_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Hino Yesu kakiaghombela. “Kulyaghila nenga ninguaghombela, Mwana kanguhotola ng'bhe kutenda nnando ghwohele mwene, ngati nnando ghula ghwakammona Tate ywake kangutenda, ndo na Mwana kangutenda ubhuabhu abhu. ");
INSERT INTO nww_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kiyaha Tate kangumpala Mwana, naywo kangummoneha ghoha ghakaghatenda mwene. Kangi kantammoneha milando mikulu kyanalumu kupitingana agha, katammoneha ili mwenga npate kukangacha. ");
INSERT INTO nww_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kulyaghila handa bhula Tate pakabhahyuha bhaahweghite na kuapegha ubhumi, ubhwabhu abhu na Mwana kanguapegha ubhumi bhala bhakaapala. ");
INSERT INTO nww_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ebu Tate kanguntosa ng'obhe mundu ywohele, peni lihengo lyoha lya kutosa bhandu kampegha Mwana, ");
INSERT INTO nww_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ili bhandu bhoha bhanhokamile Mwana handa bhula pabhanhokamila Tate. Hino, mundu ywohele ywanga kunhokamila Mwana kangunhokamila ng'obhe Tate ywakannaghilite.” ");
INSERT INTO nww_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Kulyaghila nenga nunguaghombela hoto, mundu ywohele ywakaghayihwa malagho ghangu na kunhyubhalila ywombe ywakanaghihite, kabhegha naghwo ubhumi ghwanga pela ghwa manjubha ghoha, katatoswa ng'obhe, ngati katayomboka kala kuhuma kiho na kuyingila muubhumi ghwangapela. ");
INSERT INTO nww_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kulyaghila nenga nunguaghombela kangi, lisaa linguhika, nalyo lisaa lihika kala, pala bhaabheghite kutali na Chapanga paayihwa lilobhe lya Mwana ywa Chapanga, nabho bhaalonda kuyihwa bhaabhegha na ubhumi. ");
INSERT INTO nww_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Handa bhula ubhumi ghunguhuma kwa Tate, bhubho Tate katenda ubhumi ghuhume kwa Mwana. ");
INSERT INTO nww_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Naywo Chapanga kampegha Mwana ghwake makakala gha kutosa, kangi ywombe ndo Mwana ywa Mundu. ");
INSERT INTO nww_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nkotoke kukangacha pannyihwa nnando aghu, mana lisaa linguhika pala bhala bhaabheghite mumandogholo paayihwa lilobhe lyake. ");
INSERT INTO nww_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Nabho bhahwimukila panje ya mandogholo ghabhe, na bhala bhaatendite gha maha bhaahyuka bhamokole kutama, na bhala bhaatendite ulemwa bhaahyuka atoswe.” ");
INSERT INTO nww_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yesu kakighendelela kuaghombela “Nenga ndahotola ng'obhe kutenda kilibhi kyohele kwa likalama lyangu nimwene, nungutosa bhula panyihwa kuhuma kwa Chapanga, na toso yangu yibhegha ya maha, kiyaha nungupalaha ng'obhe ghanighapala nenga, ngati ghala ghakaghapalite ywakanaghihite.” ");
INSERT INTO nww_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Handa nunguaghombela mwenga milando ya numwene, ghala ghaniaghombela ghangabheghite ng'obhe hoto. ");
INSERT INTO nww_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Peni kabhegha mundu yungi kanguaghombela mwenga milando yangu na nenga ningumanya kukita ghakaaghombela kwakya nenga ndo hoto. ");
INSERT INTO nww_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mukialaghila bhandu aghende kwa Yohane yunakubatisa, naywo kakiaghombela abho bhandu ndo hoto. ");
INSERT INTO nww_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nenga nunguyitikila ng'obhe lyaalongela bhandu yakya nenga, peni nunglongela agha ngati mwenga bhandu npate kulopoleghwa. ");
INSERT INTO nww_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohane kakibhegha handa limbamba, liiyaka na kulangaha lung'ali, na mwenga mukibhegha kala kulumbalila lung'ali lwake kya mandina. ");
INSERT INTO nww_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Peni ghubhegha nnando nkulu liilangiha nenga kupitingana ghala ghakalongelite Yohana yunakubatisa. Nnando ghwene ndo ghala mahengo ghakambeghite Tate nighatende. Agha ghoha ghangulangiha kukita nenga ndo ghani, na ghangulangiha kukita Chapanga ndo kanaghila ndende mahengo ghake. ");
INSERT INTO nww_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Naywo Tate, ywakanaghilite kunongelela kukita nenga ndo ghani. Peni mwenga munayihwa ng'obhe lilobhe lyake ebu kummona ywombe mwakabheghite, ");
INSERT INTO nww_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","na lilagho lyake lingutama ng'obhe nkati yenu, kiyaha mukinhyubhalila ng'obhe ywombe ywakannaghilite. ");
INSERT INTO nww_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mwenga munguhingukiha muno Malembo gha Chapanga panhwachila kukita nkati mwaki maamokola ubhumi ghwa manjubha ghoha, na Malembo agho ndo ghangunongelela nenga. ");
INSERT INTO nww_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Peni mungulema kuhika kwa nenga ili mmokole ubhumi.” ");
INSERT INTO nww_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ningo yangu nenga nungulema kutikwa na bhandu. ");
INSERT INTO nww_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Peni ninguamanya mwenga, nungumanya kukita mmegha ng'obhe na upalo ghwa Chapanga mumyoyo yenu. ");
INSERT INTO nww_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nenga hika kwa ngwiliho ya Tate ghwangu, peni mungungingama ng'obhe, peni yungi pakahika kwa ngwiliho yake mwene, mankingama. ");
INSERT INTO nww_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mwenga mungupala kutikilana mabhene, peni mungupala ng'obhe kumokola tiko kuhuma kwa Chapanga mwene, hinu, maahotola bhuli kunyubhalila nenga? ");
INSERT INTO nww_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nkotoke kuhwacha kukita nenga ndabhakokela kwa Tate. Aywo musa yumundumbila ndo ywakapala kuakokela mwenga. ");
INSERT INTO nww_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Handa munganhyubhalilite hoto Musa, hino munganyubhalilite na nenga, kiyaha Musa kakityeka mihalo yakya nenga. ");
INSERT INTO nww_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Peni handa mungughahyubhalila ng'obhe ghala ghakatyekite Musa, maahyubhalila bhuli malagho ghangu ghanighalongela?” ");
INSERT INTO nww_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mbole ya agha, Yesu kakighenda kumwambo ya lihibha Galilaya, lyene bhubho bhandu bhngulikema lihibha Tibelia. ");
INSERT INTO nww_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Na lumati lukulu lwa bhandu lukighendelela kuntughila, kiyaha bhakibhona mihabho mitangalo yakatendite kwa kualamiha atamwa. ");
INSERT INTO nww_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Mbole Yesu kakikwela ku kitumbi na kakitama papamu na ahundwa bhake. ");
INSERT INTO nww_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na kikubhukubhu kya Akaayahudi kiikemwa Pasaka kikiheghelela kuhika. ");
INSERT INTO nww_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu pakakalolikihite kakilubhona lumati lukulu lwa bhandu paluntughila, kakinkonya Filipi, “Twahemela kwoki mulyo ghwa kuakwila bhandu bhoha abha ili alyeghe?” ");
INSERT INTO nww_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu kakikonya habhu kwa kuntegha Filipi, kiyaha kakimanya kya kukitenda. ");
INSERT INTO nww_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipi kakinnyanga, “Ngalabha hya kutenda mahengo kwa myehi mitangali, hyangakwilite ng'obhe kuhemela hilyo hya kukwila hata kwa kila mundu kamokole kulyegha kyamandina.” ");
INSERT INTO nww_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yumu ywa ahundwa bhake, ywakakemitwe Andelea, aywo kakibhegha nnongo ywake Simoni Petili, kakinng'ombela Yesu, ");
INSERT INTO nww_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Apa kabhegha nhongolo yumu kabhegha na mangate nhano na hihomba hichoko hibhili. Peni ahi hyakwila niki kwa lumati alu lwoha?” ");
INSERT INTO nww_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu kakilongela, “Muaghombele bhandu atame pahi,” Na penipala pakibhegha na manyahi gha lukomba. Hino, bhandu bhoha bhakitama pahi, na pakibhegha na handa bhandu alume elufu nhano. ");
INSERT INTO nww_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ndo Yesu kakighatola ghala mangate, kakinnumba Chapanga, na kakiaghabhila bhandu bhaatamite. Kakitenda ubhwabhu kwa bhala homba, na kila mundu kakimokola na kulyegha handa bhula pakapalite kulyegha. ");
INSERT INTO nww_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bhandu bhoha paayomolite kulyegha na kuyukuta, Yesu kakiaghombela ahundwa bhake, “Nkugane mahighalo ghoha gha hipalamande, kikotoke kuhobha hata kipalamande kimu.” ");
INSERT INTO nww_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Hino, bhakikungana hipalamande hyoha na kumemekeha hikapu mbinda mabhoko yimo na ibhili. ");
INSERT INTO nww_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bhandu paabhonite nhabho ghula ghwakaghutendite Yesu, bhakiyanda kulongela, “Kulyaghila mundu ayu ndo yula mbuye ywakahika munnima!” ");
INSERT INTO nww_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu kakimanya kukita bhandu bhangupala kuntenda kabheghe mutwa ywabhe kya lingakamiha, ndo kakibhuka na kughenda kangi ku kitumbi ghweka chake. ");
INSERT INTO nww_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Payihikite makimuhi, ahundwa bha Yesu bhakihelela kukitumbi na kughenda mbaka ku lihibha. ");
INSERT INTO nww_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Mbole bhakihubhuka mu bhwato, na bhakiyanda kuyomboka lihibha kughenda ku Kapelinaumu. Peniapo lubhindo lukiyingila kala, na Yesu kakibhegha kakali kuheghelela papamu na bhombe. ");
INSERT INTO nww_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Lihibha likibyaluka kiyaha kukibhegha na likusi lingubyaluha machi. ");
INSERT INTO nww_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bhala ahundwa bhakihola bhwato kya utali ghwa kilomita nhano ebu sita, bhakinmona Yesu pakatyanga unani mwa machi, kanguheghelela ku bhwato, ndo bhakiyoghopa munu. ");
INSERT INTO nww_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Peni Yesu kakiaghombela, “Nkotoke kuyoghopa, ndo Nenga!” ");
INSERT INTO nww_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ndo ahundwa bhakipala kuntekula Yesu mubhwato, kamu bhwato ghukihika paluhingo kula kwaabheghite bhangughenda. ");
INSERT INTO nww_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kilabho yake lula lumati lwa bhandu bhala bhaabheghite kula kumwambo ya lihibha bhaking'amula kukita, kukibhegha na bhwato ghumu ghweka. Na bhakimanya kukita Yesu kakiyingila ng'obhe mula mubhwato ghwaabhukite nabho papamu na ahundwa bhake, ngati ahundwa bhake bhakighenda ghweka chabhe. ");
INSERT INTO nww_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Peni yikihika mibhwato yingi kuhuma ku Tibelia, ugheghela na pala paalyeghite mangate mbole ya Bambo Yesu kunnumba Chapanga. ");
INSERT INTO nww_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Hino, lula lumati lwa bhandu lukimanya kukita Yesu kakibhegha ng'obhe pala, ebu ahundwa bhake nabho, ndo bhakihubhuka mu yila mibhwato, na bhakighenda akwo Kapelinaumu ngati bhakanpalahe Yesu. ");
INSERT INTO nww_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bhala bhandu paammonite Yesu kumwambo ya lihibha bhakinkonya, “Nhunda, ghuhika pakiki apa?” ");
INSERT INTO nww_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu kakiayanga, “Kulyaghila nenga nunguaghombela, mwenga mungumbalaha ng'obhe nenga kiyaha mukibhona mihabho yila, ngati mungumbalaha kiyaha mukilyegha yila mangate na mukiyukuta. ");
INSERT INTO nww_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nkotoke kutenda mahengo kwakya kumokola hilyo hinakupyokoka, ngati mmeghe mungutenda mahengo kwakya kumokola hilyo hiihighala mbaka muubhumi ghwangapela ghwa manjubha ghoha. Hilyo ahyo hyabhapegha ubhumi ghwa manjubha ghoha kuhuma kwa Chapanga. Mwana ywa Mundu ndo ywakapala kuapegha hilyo ahyo, kiyaha Tate Chapanga kampegha likalama lya kutenda habhu.” ");
INSERT INTO nww_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Hino bhakinkonya Yesu, “Tutende niki twenga ngati tumokole kughatenda mahengo gha Chapanga?” ");
INSERT INTO nww_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu kakiayanga bhala bhandu, “Nnando ghwene Chapanga kangupala mughutende, munyubhalile nenga yunaghilitwe na ywombe.” ");
INSERT INTO nww_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Habhu bhandu bhakinkonya, “Ghwatenda naho yoki ya nhabho ili tuyibhone na tughuhyubhalile? Ghwatenda nnando ghani? ");
INSERT INTO nww_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Atate bhetu bhakilyegha hilyo hiikemwa mana kula kukibhala, handa muyityekitwe mu Malembo, ‘Kakiapegha mangate kuhuma kunani kwa Chapanga ngati alyeghe.’ ” ");
INSERT INTO nww_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu kakiaghombela, “Kulyaghila nenga nunguaghombela, Musa kakiapegha ng'obhe hilyo hya mangate kuhuma kunani kwa Chapanga, ngati Tate ywangu ndo ywakaapegha mwenga hilyo hya lingate lya hoto liihuma kunani. ");
INSERT INTO nww_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kiyaha hilyo hya Chapanga ndo yula yunakuhuluka pahi kuhuma kunani kwa Chapanga ili kaapeghe bhandu bha nnima aghu ubhumi.” ");
INSERT INTO nww_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Hino bhakinng'ombela Yesu, “Bambo, kutandila hinu ghutupeghe lingate alyo manjubha ghoha.” ");
INSERT INTO nww_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Hino, Yesu kakiaghombela, “Nenga ndo lingate liabhapegha ubhumi, ywombe ywakahika kwa nenga na kunyubhalila katabhona ng'obhe njala hangi nyota. ");
INSERT INTO nww_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Hino, handa panuaghombilite kukita payibhele mumona peni mungunyubhalila ng'obhe. ");
INSERT INTO nww_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bhala bhandu bhoha bhakambegha Tate bhahika kwa nenga. Na mundu ywohele ywakahika kwa nenga ndantanga ng'obhe panje, ");
INSERT INTO nww_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kiyaha nenga huluka kuhuma kunani kwa Chapanga ili ngotoke kutenda ghambalite nenga, ngati ndende ghala ghakapalite Tate ywakanaghilite. ");
INSERT INTO nww_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tate ywakanaghilite kangupala habhu, ngotoke kunhobheha hata mundu yumu ywa bhala ghwakambeghite, ngati niahyuhe bhoha mulila linjubha lya uhiko. ");
INSERT INTO nww_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kiyaha kyakakipala Tate ghwangu ndo aki kukita kila ywakammona Mwana na kunyubhalila kabheghe na ubhumi ghwangapela ghwa manjubha ghoha. Na nenga ndabhahyuha linjubha lya uhiko.” ");
INSERT INTO nww_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Hino, Akaayahudi bhakiyanda kunkuhyongolekela Yesu kiyaha kakilongela, “Nenga ndo lingate kuhuma kunani kwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bhakilongela, “Mundu ayu chepa Yesu mwana ywa Yosefu? Tunguamanya tate na mama ywake. Yibha bhuli, hinu kanguyigha kulongela kukita kahuluka kuhuma kunani kwa Chapanga?” ");
INSERT INTO nww_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Habhu Yesu kakiaghombela, “Nneke kuhyongoloka mabhene. ");
INSERT INTO nww_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kahone mundu ywakahotola kuhika kwa nenga handa kannongoha ng'obhe na Tate ywakanaghilite, na nenga ndanhyuha linjubha lya uhiko. ");
INSERT INTO nww_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mukitabho kya Chapanga mbuye yumu kakityeka, ‘Bhandu bhoha bhatahundwa na Chapanga.’ Na mundu ywohele ywakannyihwa Tate na kulihunda kuhuma kwa ywombe, aywo katahika kwa nenga. ");
INSERT INTO nww_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kahone mundu ywohele ywakammonite Tate, ngati ywombe ywakahumite kwa Chapanga, ywombe ndo ghweka chake ywakammonite Tate. ");
INSERT INTO nww_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kulyaghila nenga nungunng'ombela, mundu ywakanyubhalila kabhegha naghwo ubhumi ghwangapela ghwa manjubha ghoha. ");
INSERT INTO nww_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nenga ndo lingate lya ubhumi. ");
INSERT INTO nww_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Atate bhenu bhakilyegha mana kula kukibhala, peni bhoha bhakihwegha. ");
INSERT INTO nww_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Peni apa kubhegha lingate liihulukite pannima kuhuma kunani kwa Chapanga ngati mundu ywohele ywakapala kulyegha kakotoke kuhwegha. ");
INSERT INTO nww_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nenga ndo lingate lya ubhumi, ghulala hihulukite kuhuma kunani kwa Chapanga. Mundu ywohele pakalyegha lingate alyo, katalama manjubha ghoha. Lingate ali ndo mmili ghwangu, ghwene ghumbala kubhapegha kwakya ubhumi ghwa unnima.” ");
INSERT INTO nww_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ndo Akaayahudi bhakiyanda kughombana bhene paalongela. “Ayu katahotola bhuli kutupegha mmili ghwake tuulyeghe?” ");
INSERT INTO nww_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Habhu Yesu kakiaghombela Akaayahudi, “Kulyaghila nenga nungunng'ombela, pankotoka kulyegha mmili ghwa Mwana ywa Mundu na kuunywegha mwahi ghwake, maabhegha ng'obhe na ubhumi ghwangapela nkati yenu. ");
INSERT INTO nww_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mundu ywohele ywakalyegha mmili ghwangu na kuuywegha mwahi ghwangu katabhegha na ubhumi ghwa manjubha ghoha, na nenga ndanhyuha linjubha lya uhiko. ");
INSERT INTO nww_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kiyaha mmili ghwangu ndo mulyo ghwa hoto na mwahi ghwangu ndo kiywegho kya hoto. ");
INSERT INTO nww_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mundu ywohele yunakulyegha mmili ghwangu na kunywegha mwahi ghwangu katatama nkati yangu, na nenga ndatama nkati yake. ");
INSERT INTO nww_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Handa bhula Tate ywakanaghilite mwakabheghite na ubhumi. Na nenga ningulama kupitila kwa Tate, habhu ywakalyegha mmili ghwa nenga katalama kupitila nenga. ");
INSERT INTO nww_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ali ndo lingate liihuluka kuhuma kunani kwa Chapanga, libhegha ng'obhe handa mana yaalyeghite akaatate bhenu, mbole bhakihwegha, peni ywohele yunakulyegha lingate ali katalama manjubha ghoha.” ");
INSERT INTO nww_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu kakilongela malagho agha pakabheghite kanguhunda mu Nyumba ya kukonganikila Akaayahudi akwo Kapelinaumu. ");
INSERT INTO nww_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Atangalo mu ahundwa bhake paayihwite nnando aghu bhakilongela, “Mahundo agha gghangumanyika ng'obhe yeghuyeghu. Ndo ghani ywakahotola kughakingama?” ");
INSERT INTO nww_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu kaking'amula mwene kyanga kughombelwa na mundu kukita ahundwa bhake bhakinhyongoleka yakya mahundo ghake, ndo kakiakonya, “Bhuli, nnando aghu ghunguayaghabhiha? ");
INSERT INTO nww_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yabhegha bhuli hinu pala pamummona Mwana ywa Mundu pakabhyela kughenda akwo kwakabheghite kandahi? ");
INSERT INTO nww_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nhuki ywa Chapanga ndo yunakuapegha bhandu ubhumi, mmili ndo kilibhi ng'obhe. Malagho agha ghaniaghombilite ndo ghanguhuma kwa Nhuki ywa Chapanga na kuapegha ubhumi. ");
INSERT INTO nww_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Peni amoo bhenu munguhyubhalila ng'obhe.” Kiyaha Yesu kakimanya ghoha kutandila kalongohi ndo aghani bhangunhyubhalila mu nkati yabhe na aghani bhangupala kunkiluka. ");
INSERT INTO nww_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Mbole Kakilongela kangi, “Ndo mana nikiaghombela kukita kahone mundu ywohele ywakapala kuhotola kunhikila kyangalongohwa na Tate ywangu.” ");
INSERT INTO nww_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kubhukana na nnando ghula kutandila pala, amoo ahundwa bhake bhakibhuya kihyengelenyuma bhakileka kulongohana na Yesu. ");
INSERT INTO nww_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Habhu Yesu kakiakonya bhala andumila bhake mbinda mabhoko yimo na abhili, “Bhuli, na mwenga mungupala kubhuka?” ");
INSERT INTO nww_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Petili kakinnyanga, “Bambo, tubhuke tughende kwoki? Ghwenga ghubhegha na malagho gha ubhumi ghwa manjubha ghoha. ");
INSERT INTO nww_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tunguhyubhalila na kumanya kukita ghwenga ndo Ywakahaghulitwe kuhuma kwa Chapanga yunaubhumi.” ");
INSERT INTO nww_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ndo Yesu kakiayanga, “Nikiahaghula mwenga mbinda mabhoko yimu na abhili. Peni yumu ywenu kangulongohwa na Nchipila!” ");
INSERT INTO nww_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Apa Yesu kakilongela agho yakya Yuda, mwana ghwa Simoni Isikaliote, mana aywo ndo ywakapala kunkiluka. Payibhele kakibhegha mu bhala ahundwa mbindamabhoko yimo na abhili. ");
INSERT INTO nww_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mbole ya milando ayi, Yesu kakighenda mu hijiji nhangangaiko hya ku Galilaya, kakilema kughenda kukitami kya Yudea kiyaha hilongohi bha Akaayahudi bhakipala kunkoma. ");
INSERT INTO nww_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Peniapo kikubhukubhu kya Akaayahudi kiikemitwe kikubhukubhu kya hibanda, kikiheghelela, ");
INSERT INTO nww_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Hino, alongo bhake Yesu bhakinng'ombela, “Ghubhuke apa, ghughende ku Yudea ili ahundwa bhako bhakabhone mihabho yighuyitenda. ");
INSERT INTO nww_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mundu ywakapala kumanyikwa na bhandu kangutenda ng'obhe milando yake kwa kihiho. Handa kiyaha ghungutenda milando ayi, hino, ghulibhonehe kwa bhoha ili bhandu bhakumanye!” ");
INSERT INTO nww_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Hata alongo bhake mwene bhakinhyubhalila ng'obhe. ");
INSERT INTO nww_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu kakiaghombela bhombe, kukita “Nndaluko ghwa nenga kughenda akwo ghukali kuhika. Peni kwa mwenga kila nndaluko ghungunoghwa. ");
INSERT INTO nww_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Bhandu bha nnima bhanguhotola ng'obhe kubhakalalila mwenga, peni bhangungalalila nenga kiyaha nunguaghombela kukita, mandendelo ghabhe ghoha ghabhegha mahakataho. ");
INSERT INTO nww_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mwenga nng'ende ku kikubhukubhu, peni nenga ndaaghenda ng'obhe ku kikubhukubhu aki, kiyaha nndaluko ghwangu ghunahika ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesu pakayomolite kulongela agho, kakihighala akwo ku nnima ghwa Galilaya. ");
INSERT INTO nww_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Alongo bhake paabhukite kughenda ku kikubhukubhu, na mbole Yesu kakighenda bhubho kwa kihiho. ");
INSERT INTO nww_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Akwo ku kikubhukubhu hilongohi bha Akaayahudi bhakibhegha bhangumpalaha na kuakonya bhandu. “Kabhegha kwoki aywo Yesu?” ");
INSERT INTO nww_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kukibhegha na mbwepwe ndangalo yakya Yesu mu lumati lwa bhandu paalongela. Amoo bhandu bhakilongela “Mundu aywo ywa maha,” Na bhangi bhakilongela. “Akakaa! Ywombe kanguapotoha bhandu.” ");
INSERT INTO nww_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Peni kahone mundu ywohele ywakayighite kulongela mihalo ya Yesu pakindandabhanji, kiyaha bhakiayoghopa hilongohi bha Akaayahudi. ");
INSERT INTO nww_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Payihikite pakati ya kikubhukubhu, Yesu kakighenda ku Nyumba ya Chapanga na kuahunda bhandu. ");
INSERT INTO nww_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ayahudi bhakikangahwa na mahundo ghake na bhakilongela, “Mundu ayu kahotola bhuli kumanya milando ayi kyangali kuhundwa?” ");
INSERT INTO nww_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu kakiayanga, “Mahundo ghanuahunda chepa gha numwene, ngati ghanguhuma kwa ywombe ywakanaghihite. ");
INSERT INTO nww_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mundu ywohele ywakapala kutenda ghakaghapala Chapanga, katamanya kukita mahundo ghangu ghanguhuma kwa Chapanga, ebu nungulongela gha nenga numwene. ");
INSERT INTO nww_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mundu ywakalongela malagho ghake mwene, kangupalaha kutikilwa mwene, kangutenda habhu kwa kupalaha ukulu ghwake. Peni yula ywakapalaha ukulu ghwa yula ywakannaghihite ndo ywa hoto, hangi kahone uhwangi nkati mwaki. ");
INSERT INTO nww_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Bhuli, Musa kakiapegha ng'obhe Malaghilo? Peni kahone hata mundu yumu mu mwenga ywakaghayitikila malaghilo. Kiyaha niki, mungupala kungoma?” ");
INSERT INTO nww_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Lula lumati lwa bhandu lukinnyanga, “Ghwenga ghubhegha na lindilo! Ndo ghani ywakapala kughukoma?” ");
INSERT INTO nww_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu kakiayanga, “Nikighutenda nhabho ghumu na mabhoha mukibhughanikwa. ");
INSERT INTO nww_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Peni kiyaha Musa kakiakwilikiha kudumula unyagho, aki kitohe kikihuma ng'obhe kwa Musa, ngati kwa ahukulu bhenu, peni mwenga munguadumula unyagho bhana bhenu hata linjubha lya kupumulila. ");
INSERT INTO nww_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Handa bhana munguadumula unyagho linjubha lya kupumulila ili kuyitikila malaghilo gha Musa, bhuli, mungungalalila kya kunnamiha mundu mmili ghwake linjubha lya kupumulila? ");
INSERT INTO nww_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nneke kutosa milando ya bhandu kyabhula muyibhonekana ghweka, maha ntose muyinoghwa.” ");
INSERT INTO nww_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Amoo bhandu bha ku Yelusalemu bhakilongela, “Bhuli ayu chepa yula ywakapalahitwe na hilongohi bhetu ili bhankome? ");
INSERT INTO nww_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nnole, hinu kanguyobhela pakindandabhanji na kahone kilongohi ywakanng'ombela hata lilagho, pangi hilongohi bhamanya kala uhoto kukita ayu ndo Kilisito. ");
INSERT INTO nww_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pakahika Kilisito Nkombohi, kahone mundu ywakapala kumanya kwakahumite, peni twenga tungumanya kwakahuma mundu ayu.” ");
INSERT INTO nww_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ndo Yesu kakikweha lilobhe pakahunda ku Nyumba ya Chapanga pakalongela, “Bhuli, mwenga mungumanya nenga na mungumanya kunukuhuma? Nenga hika ng'obhe kwa utabhala ghwangu. Ywombe ywakanaghilite ndo ywa kuhyubhalika na mwenga mungummanya ng'obhe. ");
INSERT INTO nww_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Peni nenga nungummanya, kiyaha huma kwa ywombe naywo ndo ywakanaghihite.” ");
INSERT INTO nww_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Hino, bhandu bhakipalaha kunkamula, peni kahone mundu ywohele ywakayighite kunkamula kiyaha lisaa lyake likibhegha likali kuhika. ");
INSERT INTO nww_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Na bhandu ayoloho bha mula mulumati bhakinnyubhalila na bhakilongela, “Bhuli, kilisto pakahika katatenda mihabho mikulu kyanalumu kupitingana yakayitenda ayu?” ");
INSERT INTO nww_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Afalisayu bhakiayihwa bhandu paapwepa yakya mihalo ya Yesu, ndo bhombe na hilongohi bha Mandundame bhakialaghila machonda bha Nyumba ya Chapanga bhakankamule Yesu. ");
INSERT INTO nww_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu kakilongela, “Nenga ndabhegha na mwenga kwa nndaluko ghwa mandina, mbole ndabhuya kwa ywombe ywakanaghilite. ");
INSERT INTO nww_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mambalaha peni mutamona ng'obhe, na kumbala kubhegha mwenga mahotola ng'obhe kuhika.” ");
INSERT INTO nww_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Akaayahudi bhakikonyana bhene, “Ayu kangupala kughenda kwoki kweni twenga kutuhotola ng'obhe kuhika? Ebu kangupala kughenda ku hitami hya Akaayahudi kakaahunde Akaagiliki bhaapwilinganite, na kuahunda Akaagiliki? ");
INSERT INTO nww_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Pakalongela malagho agha fwambulo yake niki, mambalaha peni mamona ng'obhe na akwo kumbala kughenda mwenga mahotola ng'obhe kuhika?” ");
INSERT INTO nww_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Linjubha lya uhiko lya kikubhukubhu, linjubha lya kindimba, Yesu kakiyima na kakilongela kya kukweha lilobhe, “Mundu ywohele yukabheghite na nyota kahike kwa nenga kanyweghe machi, ");
INSERT INTO nww_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","handa Malembo paghatyekitwe, ywohele ywakanyubhalila nenga, ‘Ngemba hya machi gha ubhumi ghaabhilibhita mu mwoyo ghwake.’ ” ");
INSERT INTO nww_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu kakilongela lilagho lila kwa mihalo ya Nhuki ywa Chapanga, ywene kwa bhala bhaanhyubhalilite bhangankingamite. Kiyaha Nhuki kakibhegha kakali kuhika kiyaha Yesu kakibhegha kakali kukwehwa mu Ukulu. ");
INSERT INTO nww_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Amoo bhandu mulumati lula paayihwite malagho agho, bhakilongela, “Kulyaghila mundu ayu ndo yula Mbuye yutunnindila!” ");
INSERT INTO nww_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bhandu bhangi bhakilongela, “Ayu ndo Kilisto Nkombohi!” Bhangi bhakilongela, “Bhuli, Kilisto Nkombohi katahumila ku Galilaya? ");
INSERT INTO nww_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Bhuli, Malembo gha Chapanga ghatyekwa ng'obhe kukita Kilisto kaahika kuhuma mulukolo lwa Daudi na kubhelekwa ku Betilehemu, ku kitami kyakatamite Mutwa Daudi ng'obhe?” ");
INSERT INTO nww_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kya habhu bhandu bhakighabhanika kwakya malagho gha Yesu. ");
INSERT INTO nww_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Amoo bhandu bhakipala kuyigha kunkamula, peni kahone mundu yumu ywakayighite kunkamula. ");
INSERT INTO nww_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mbole bhala machonda bhakibhuya kwa mandundame akulu na Afalisayo, na bhombe bhakiakonya, “Kyabhuli munankamula ng'obhe na kunnyegha?” ");
INSERT INTO nww_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Bhala machonda bhakiayanga, “Kanabhonekana ng'obhe mundu munnima aghu kangulongela milando mikulu handa pakalongela mundu ayu!” ");
INSERT INTO nww_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Afalisayo bhakiakonya bhala machonda, “Bhuli na mwenga, nkuluhwa?” ");
INSERT INTO nww_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Bhuli, “Kabhegha kilongohi ywohele yumummanyite ebu Afalisayo bhaannyubhalila? ");
INSERT INTO nww_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Peni lumati lwa bhandu lwangamanya Malaghilo gha Musa, bhombe bhakotolwa na Chapanga.” ");
INSERT INTO nww_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Mbole yumu ywa Afalisayo kakibhegha Nikodemu, yula ywakanng'endelite Yesu linjubha limu pakilo. Kakiakonya ayake, ");
INSERT INTO nww_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Bhuli, Malaghilo ghetu ghangututegheka twenga kuntosa mundu ywohele pakali kunnyihwa na kumanya kyoki kyakatendite?” ");
INSERT INTO nww_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bhombe bhakinnyanga, “Bbhuli, na ghwenga bhubho ghuhuma ku Galilaya? Ghulihunde Malembo gha Chapanga na ghwenga ghwabhona kukita kahone mbuye ywakahumite ku Galilaya.” ");
INSERT INTO nww_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mbole bhakibhuka, kila mundu kakibhuya ukaya kwake. ");
INSERT INTO nww_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Peni Yesu kakighenda ku Kitumbi kya Miseituni. ");
INSERT INTO nww_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kilabho yake malabhila Yesu kakibhuya ku Nyumba ya Chapanga. Bhandu bhoha bhakikwemuka, ywombe kakitama pahi kakiyanda kuhunda. ");
INSERT INTO nww_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ahunda bha Malaghilo na Afalisayo bhakinnyegha nndala yumu ywakakamulitwe mu kutyala, bhakinnyimika pakati ya lumati lwa bhandu bhoha. ");
INSERT INTO nww_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Mbole bhakinng'ombela Yesu, “Nhunda, nndala ayu tunkamula pakatenda utyahe. ");
INSERT INTO nww_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mu malaghilo gha Musa kakitukwiliha kuaguma malibho mbaka kahwghe adala handa abha. Ghwenga ghungulongela bhuli?” ");
INSERT INTO nww_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bheni akinkonya naha kya kuntegha Yesu, ngati apate kihokonyo kya kunkokela. Peni Yesu kakihokamila pahi kakiyanda kutyeka mu lutupi kwa kikonji kyake. ");
INSERT INTO nww_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Paachwehite kunkonyakonya makonyo, kakiyinuka na kakiaghombela, “Handa kabhegha mundu mu nkati yenu ywene ywangaulemwa kabhe ghwa ulongohi kuntaghila libho.” ");
INSERT INTO nww_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Mbole kakihokama kangi na kakighendelela kutyeka mulutupi kwa kikonji kyake. ");
INSERT INTO nww_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bhene paayihwite malagho agha, bhakiyanda kubhuka, yumu mbole ya yumu, aghohi ndo bhakibhegha bha kandahi kubhuka. Kuuhiko kakihighala Yesu ghweka chake, na yula nndala kayima ku ulongolo gwa Yesu. ");
INSERT INTO nww_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu kakiyinuka kakinkonya yula nndala, “Abhegha kwoki bhala bhandu? Bhuli kahone mundu ywakakutosite?” ");
INSERT INTO nww_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Yula nndala kakinnyanga, “Kahone nga yumu Bambo.” Yesu kakinng'ombela, “Nenga ndaghutosa ng'obhe. Ghughende, na ghukotoke kutenda ulemwa kangi.” ");
INSERT INTO nww_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Mbole Yesu kakiyobhela nabho kangi pakalongela, “Nenga ndo lung'ali lwa pannima. Mundu ywohele ywakandughila nenga katabhegha na lung'ali luunlongoha mu ubhumi nayo kaatyanga mu lubhindo ndwee.” ");
INSERT INTO nww_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Afalisayo bhakinng'ombela Yesu, “Ghwenga ghungulongela kwakya ghumwene, habho agho ghughughalongela ghwabhegha bhuli ghwa hoto?” ");
INSERT INTO nww_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu kakiayanga, “Hata handa nungulongela kwakya numwene, ghala ghanughalongela ndo gha hoto, kiyaha nungukumanya kunhumite na kunng'enda. Peni mwenga mungukumanya ng'obhe kunhumite nenga ebu kunng'enda. ");
INSERT INTO nww_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mwenga mungundosa nenga kubhukana na milando yiibhonekana, peni nenga nunguntosa ng'obhe mundu. ");
INSERT INTO nww_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Peni hata handa pandosa, tosa yangu yibhegha ya telatela, kiyaha nungutosa ng'obhe ghweka, ngati nenga papamu na Tate ywakanaghihite. ");
INSERT INTO nww_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yityekwa mu Malaghilo ghenu kukita, bhandu abhili pabhalubhulila ghughula ghula, hino, nnando aghwo ndo ghwa telatela. ");
INSERT INTO nww_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nenga nungulongela kwakya numwene, naywo Tate ywakanaghilite kangulongela bhubhula handa panulilongelela numwene.” ");
INSERT INTO nww_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ndo bhakinkonya Yesu, “Tate ghwako kabhegha kwoki?” Yesu kakiayanga, “Mwenga mungumanya ng'obhe nenga hangi Tate ghwangu mungunmanya ng'obhe, handa mungamanyite nenga, mungammanyite na Tate ghwangu.” ");
INSERT INTO nww_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu kakilongela malagho agha pakabheghite mu kuhunda ku Kitutubhi kya Chapanga ku kyumba kya luhanja. Peni kahone mundu ywakankamulite kiyaha lisaa lyake likibhegha likali kuhika. ");
INSERT INTO nww_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu kakiaghombela kangi, “Nenga nungughenda, peni mwenga mambalaha nenga na maahwegha mu ulemwa ghwenu. Na kumbala kughenda nenga mwenga mahotola ng'obhe kuhika.” ");
INSERT INTO nww_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Bhala hilongohi bha Ayahudi kulikonya mabhene, “Bhuli kangupala kulikoma? Kiyaha niki kangulongela kung'enda nenga mwenga mahotola ng'obhe kuhika?” ");
INSERT INTO nww_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu kakiayanga, “Mwenga muhuma pahi bahapa apa palutupi, peni nenga huma kunani. Mwenga muhuma munnima aghu, peni nenga ndo ywa nnima aghu ng'obhe. ");
INSERT INTO nww_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ndo mana nikibhaghombela kukita mahwegha mu ulemwa ghwenu, pannema kunyubhalila kukita ‘NENGA NDO MWENE.’ ” ");
INSERT INTO nww_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bhombe bhakinkonya Yesu, “Ghwenga ndo ghani?” Naywo Yesu kakiayanga, “Nenga ndo yula ywene yunuaghombelite kutandila kalongohi. ");
INSERT INTO nww_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Megha na mihalo mitangalo ya kulongela yakya mwenga na ya kuatosa. Peni ywombe ywakanaghihite ndo hoto, nungualongela bhandu bhoha ghala ghanughayihwite kuhuma kwa ywombe.” ");
INSERT INTO nww_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Bhombe bhakimanya ng'obhe kukita Yesu kanguakambukila yakya Tate ghwa kunani. ");
INSERT INTO nww_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Mbole Yesu kakiaghombela, “Pamunnyinula kala Mwana ghwa Mundu, ndo mamanya kukita ‘Nenga ndo mwene’ na mamanya kukita nenga ndo nunongilite kukita nungutenda ng'obhe nnando ghweka changu, maha ghala ghakanhundite Tate. ");
INSERT INTO nww_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ywombe Tate ywakanaghite kabhegha papamu na nenga, kananeka nenga ghweka changu, kiyaha nenga nungutenda ghala ghaaghapala ywombe manjubha ghoha.” ");
INSERT INTO nww_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Bhandu atangalo bhaannyihwite Yesu pakalongela malagho agha bhakinhyubhalila. ");
INSERT INTO nww_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Hino, Yesu kakiaghombela bhala Akaayahudi bhaanhyubhalilite, “Mwenga handa panng'ungila mahundo ghangu, maabhegha ahundwa bhangu bha hoto, ");
INSERT INTO nww_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ndo maghumanya uhoto, hino kwa njila ya aghwo uhoto Chapanga katabhalekekeha kuhuma mu ubhandwa.” ");
INSERT INTO nww_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bhombe bhakinkonya, “Twenga ndo kibheleko kya Abulahamu, tunabhegha ng'obhe abhandwa bha mundu ywohele. Kyabhuli, ghungulongela ‘twaalekekehwa kuhuma mu ubhandwa?’ ” ");
INSERT INTO nww_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu kakiaghombela, “Kulyaghila nenga nunguaghombela, Mundu ywohele ywakatenda ulemwa kabhegha mmandwa ywa ulemwa. ");
INSERT INTO nww_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mmandwa katamagha ng'obhe pakaya manjubha ghoha, Peni mwana katamagha ukaya manjubha ghoha. ");
INSERT INTO nww_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Habhu, handa Mwana pakaalekekeha kuhuma mu ubhandwa ghwa ulemwa, ndo maabhegha uhulu kya hoto. ");
INSERT INTO nww_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nungumanya kukita mwenga ndo kibheleko kya Abulahamu. Peni mungupala kungoma nenga, kiyaha mungughayitikila ng'obhe mahundo ghangu. ");
INSERT INTO nww_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nenga nungughalongela ghala ghanighabhonite kwa Tate ghwangu, peni mwenga mungughatenda ghala ghanng'ombelitwe na tate ywenu.” ");
INSERT INTO nww_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bhombe bhakinnyanga, “Tate ywetu ndo Abulahamu.” Yesu kakiaghombela, “Handa mungabheghite bhana bha Abulahamu mungatendite mihalo yila yakatendite Abulahamu. ");
INSERT INTO nww_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nenga nubhaghombela uhoto ghunuuyihwite kuhuma kwa Chapanga, peni hata habhu mwenga mungupala kungoma. Abulahamu kakitenda ng'obhe habhu! ");
INSERT INTO nww_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mwenga mungutenda milando yilayila yakayitendite tate ywenu.” Bhombe bhakinnyanga, “Twenga ndo bhana bha hoto bha Chapanga, na tubhegha Tate yumu ghweka naywo ndo Chapanga.” ");
INSERT INTO nww_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu kakiaghombela, “Handa Chapanga kangabheghite Tate ywenu, mungambalite, kiyaha nenga huma kwa Chapanga na hino mbegha apa. Hika ng'obhe kughatenda ghala ghanugha numwene, maha kwakya ywombe ywakanaghihite. ");
INSERT INTO nww_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mungumanya ng'obhe milando yinuyilongela, kiyaha mwenga mungulema kughayitikila mahundo ghangu. ");
INSERT INTO nww_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mwenga ndo bhana bha tate ywenu, ywene ndo Nchipila, na mungupala kutenda ghakaghapala Tate ghwenu. Ywombe kakibhegha nkoma bhandu kuyandila makachu bhubho kakilingana ng'obhe na uhoto mana kahone uhoto nkati mwake. Pakalongela gha uhwangi kiyaha aghwo ndo malema ghake, ywombe ndo nhwangi na tate ghwa aghwo uhwangi. ");
INSERT INTO nww_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Peni kiyaha ninguaghombela uhoto ndo mana mungunyubhalila ng'obhe. ");
INSERT INTO nww_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ghani nkati yenu ywakahotola kung'ombela kukita nenga mbegha na ulemwa? Handa nungulongela hoto, yibheghabhuli mwenga mungunhyubhalila ng'obhe? ");
INSERT INTO nww_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ywombe ywakabheghite ywa Chapanga kangughayihwa malagho gha Chapanga. Peni mwenga mungunyihwa ng'obhe kiyaha mwenga chepa bhandu bha Chapanga.” ");
INSERT INTO nww_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Akaayahudi bhakinnyanga Yesu, “Bhuli, tubhegha ng'obhe tela mutulongela kukita ghwenga ghu Nsamalia kangi ghubhegha na lindilu?” ");
INSERT INTO nww_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu kakiayanga, “Nenga megha ng'obhe na lindilu, ngati ningunhokamila Tate ywangu, peni mwenga munguhokamila ng'obhe nenga. ");
INSERT INTO nww_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nenga mbala ng'obhe bhandu bhandike, peni kabhegha yumu yuapala bhandu bhandike. Na aywo ndo ywaalamula kukita nungutenda ghanakunogha. ");
INSERT INTO nww_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kulyaghila nenga nunguaghombela. Ywoheli ywakaghungila mahundo ghangu katahwegha ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ndo Akaayahudi bhakinng'ombela Yesu, “Hinu tuhumbula hoto kukita ghwenga ghubhegha na lindilu! Abulahamu kakihwegha, na mambuye bhakihwegha bhubho, ghwenga ghungulongela kukita ywakaghaghungila mahundo ghako katahwegha ng'obhe. ");
INSERT INTO nww_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Bhuli, ghungulitenda ghu nkulu kuchweha kwa tate ghwetu Abulahamu ywene kakihwegha? Hata na mambuye bhakihwegha bhubho. Ghungulitenda ghwenga ndo ghani?” ");
INSERT INTO nww_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu kakiayanga, “Handa panulitika numwene, kulitika kunulutika ndo kilibhi ng'obhe. Kabhegha yumu ywakandika aywo ndo Tate ywangu, aywo ndo mwenga mungulongela ndo Chapanga ywenu. ");
INSERT INTO nww_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mwenga mungunmanya ng'obhe, peni nenga nungunmanya. Panongela nungunmanya ng'obhe, ndabhegha nhwangi handa mwenga. Peni nenga nungunmanya na nunguyitikila lilagho lyake. ");
INSERT INTO nww_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tate ghwenu Abulahamu kakilumbalila kukita kalibhone linjubha lyangu, naywo kakilibhona na kakiyelelwa.” ");
INSERT INTO nww_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Hino, Akaayahudi bhakinng'ombela Yesu, “Ghwenga ghuhika ng'obhe ngungwa mbinda mabhoko nhano, yibha bhuli ghungulongela ghummona Abulahamu?” ");
INSERT INTO nww_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu kakiaghombela Ayahudi, “Kulyaghila nenga nunguaghombela, kukali na kubhelekwa Abulahamu, ‘NENGA NIKIBHEGHA.’ ” ");
INSERT INTO nww_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Bhombe ndo bhakilokota malibho ngati bhatute, peni Yesu kakilihiha na kakibhuka ku Kitutubhi kya Chapanga. ");
INSERT INTO nww_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu pakabhegite kangutyanga, kakimmona mundu yumu ywangalola kutandila kubhelekwa. ");
INSERT INTO nww_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Hino, ahundwa bhake bhakinkonya Yesu, “Nhunda, ghani ywakatendite ulemwa, mundu ayu, ebu abhele bhake, mbaka kabhelekwe ywangalola?” ");
INSERT INTO nww_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu kakiayanga, “Nnando aghu likibhwatuka ng'obhe kubhukana na ulemwa ghwa mundu ayu ebu ghwa abhele bhake, ngati kakibhelekwa ywangalola ngati makakala gha Chapanga ghayimihwe mu ubhumi ghwake. ");
INSERT INTO nww_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yingungwiliha kughatenda mahengo ghake ywombe ywakanaghilite pakali pamuhi, uhiku ghunguhika, na kahone mundu ywakahotola kutenda lihengo. ");
INSERT INTO nww_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Pammegha ngali munnima, nenga ndo lung'ali lwa nnima.” ");
INSERT INTO nww_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mbole ya kuyomola kulonngela agho, Yesu kakihuna mata pahi kakitendekeha lindikali kakintyelemeka mumeho yula ywangalola, ");
INSERT INTO nww_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","mbole kakinng'ombela, “Ghughende ghukakuhe ku litanda lya Siloamu.” Fwambulo ya lihina ali ndo ywakalaghilitwe. Apa yula ywangalola kakighenda, kakikuha kibhungi kyake, mbole kakibhuya kunu pakalola. ");
INSERT INTO nww_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hino, andamani bhake, na bhandu bhaammanyite kukita kakibhegha kapukwa yuna luyupayupa, bhakilikonya, “Bhuli, ayu ndo yula ng'obhe, ywakabheghite kangutama na kuyupayupa?” ");
INSERT INTO nww_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Amoo bhabhe bhakilongela, “Ayu ndo ywombe,” Amoo bhangi bhakilongela, “Ayu chepa ywombe, ngati kalihwana naywo.” Peni ywombe ywakabhelekitwe ywangalola kakilongela, “Nenga ndo mwene.” ");
INSERT INTO nww_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Hino, bhakinkonya, “Meho ghako ghahughulwa bhuli?” ");
INSERT INTO nww_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ywombe kakiayanga, “Yula mundu ywakakemwa Yesu kakitendekeha lindika, kakindyelemeka mu meho ghangu, na kaking'ombela ng'ende ku litanda lya Siloamu na nikakuhe kibhungi kyangu. Ndo nenga nikighenda na nikilikuha, na nikihotola kubhona.” ");
INSERT INTO nww_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bhombe bhakinkonya, “Ywombe kabhegha kwoki?” Ywombe kakiayanga, “Nenga manya ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Mbole bhakinnyegha yula mundu ywakabheghite ywangalola kwa Afalisayo. ");
INSERT INTO nww_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Linjubha alyo Yesu lyakatendekehite lindika na kunhughula meho mundu aywo, likibhegha Linjubha lya Kupumulila. ");
INSERT INTO nww_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Hino, Afalisayo, nabho, bhakinkonya kangi yula mundu, kakilamihwa bhuli. Naywo kakiayanga, “Kakindyelemeka lindika mu meho ghangu, nikilikuha kibhungi kyangu, na hinu ningubhona.” ");
INSERT INTO nww_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Amoo bha Afalisayo bhakilongela, “Mundu ayu kahuma ng'obhe kwa Chapanga, kiyaha kangughayitikila ng'obhe Malaghilo gha Linjubha lya Kupumulila.” Bhangi bhakilongela, “Mundu yuna ulemwa kaahotola bhuli kutenda mihabho handa ayi?” Kukibhegha ng'abhano nkati yabhe. ");
INSERT INTO nww_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Afalisayo bhakinkonya kangi yula mundu ywakabheghite ywangalola, “Ghungulongela bhuli kunninga ywombe, kiyaha ghwenga ndo ghuhughulitwe meho?” Mwene kakiayanga, “Ywombe ndo mbuye ywa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Hilongohi bha Akaayahudi bhakinnyubhalila ng'obhe, kukita mundu aywo kakibhegha ywangalola apo makachu na hino kangubhona, mbaka paabhakemite abhele bhake, ");
INSERT INTO nww_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","na bhakiakonya, “Ayu ndo mwana ywene mwenga mukilongela kakibhelekwa ywangalola? Yibhegha bhuli hino kangubhona?” ");
INSERT INTO nww_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Abhele bhake bhakiyanga, “Tungumanya kukita ayu ndo mwana ywetu, kangi kakibhelekwa ywangalola. ");
INSERT INTO nww_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Peni twenga tungumanya ng'obhe kahotola bhuli kubhona, hangi tungummanya ng'obhe ywene ywakanhughulite meho. Munkonye mwene, kiyaha ywombe ndo nahota, na kaahotola kulilubhulila mwene!” ");
INSERT INTO nww_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Abhele bhake bhakilongela naha kiyaha bhakiayoghopa hilongohi bha Akaayahudi, kiyaha bhakipangana kukita mundu ywohele ywakapala kulongela kukita Yesu ndo Kilisito Nkombohi, kaabhingwabhingwa kubhuka mu kitutubhi kya kukonganila Akaayahudi. ");
INSERT INTO nww_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ndo mana abhele bhake bhakilongela, “Ywombe ndo nahota, munkonye mwene!” ");
INSERT INTO nww_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Afalisayo bhakinkema kangi yula ywakabhelekitwe ywangalola, na kunng'ombela, “Ghulongele hoto kwa Chapanga! Twenga tungumanya kukita mundu ayu ywakakulamihite ndi yunaulemwa.” ");
INSERT INTO nww_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ywombe kakiayanga, “Nenga ningumanya ng'obhe kukita kabhegha na ulemwa ebu chepa. Nughumanya nnando ghumu ghweka. Nikibhegha ywangalola, na hino nungubhona.” ");
INSERT INTO nww_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Hino bhakinkonya, “kakighutendela niki? Kakikufumbula bhuli meho ghako?” ");
INSERT INTO nww_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ywombe kakiayanga, “Nukibhalubhulila kala, hangi mukiyihwa ng'obhe. Kiyaha niki munupala kuyihwa kangi? Bhuli, na mwenga mungupala kubhegha ahundwa bhake?” ");
INSERT INTO nww_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Peni hilongohi bha Ayahudi bhakinnigha maligho na kunng'ombela, “Ghwenga ndo nhundwa ywake, ngati twenga twaahundwa bha Musa. ");
INSERT INTO nww_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Twenga tungumanya kukita Chapanga kakiyobhela na Musa, peni mundu ayu tungumanya ng'obhe kahumila kwoki!” ");
INSERT INTO nww_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Yula mundu kakiayanga, “Aghu ndo nnando ghwa kukangahya! Mwenga mungumanya ng'obhe kwakahumite, peni nenga kaghafumbula meho ghangu! ");
INSERT INTO nww_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tungumanya kukita Chapanga kanguayihwa ng'obhe bhandu bhanaulemwa, ngati kanguayihwa bhoha bhaantundamila na kunnyitikila. ");
INSERT INTO nww_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kutandila ulongohi ghwa nnima tuyihwa ng'obhe kukita mundu kalamiha meho gha mundu ywakabhelekitwe ywangalola. ");
INSERT INTO nww_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Handa mundu ayu kanahumila kwa Chapanga, kangahotolite ng'obhe kutenda agha ghoha.” ");
INSERT INTO nww_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bhombe bhakinnyanga, “Ghwenga ghubhelekwa na kukulila muulemwa, ghwaahotola bhuli kutuhunda twenga?” Bhakinpiha panji ya kitutubhi kya kukonganila Ayahudi. ");
INSERT INTO nww_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu pakayihwite kukita yula mundu ywangalola bhakinpiha panji, pakanmonite kakinkonya, “Bhuli ghwenga ghungunyubhalila Mwana ywa Mundu?” ");
INSERT INTO nww_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Yula mundu kakinnyanga Yesu, “Bambo ghung'ombele, ywombe ndo ghani, ngati mokole kunhyubhalila!” ");
INSERT INTO nww_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu kakinnyanga, “Ghummona kala, naywo ndo yughuyobhela naywo hinu.” ");
INSERT INTO nww_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Apo yula mundu kakilongela, “Nunguhyubhalila Bambo!” Naywo kakinchutamila mayughwa Yesu na kakintundamila. ");
INSERT INTO nww_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu kakilongela, “Nenga hika pannima apa kwakya kutosa, ili bhala bhangalola bhamokole kubhona, na bhala bhanakuhwacha bhombe bhangubhona abheghe bhangalola.” ");
INSERT INTO nww_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Amoo bha Afalisayo bhaabheghiti papamu naywo bhakiyihwa malagho agho bhakinkonya, “Bhuli, na twenga twangalola hilahila?” ");
INSERT INTO nww_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu kakiayanga, “Handa mungabheghite mangalola, mungabheghite ng'obhe na ulemwa, peni hinu mungulongela mungubhona, hino mmegha na uhokelo.” ");
INSERT INTO nww_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu kakiaghombela, “Kulyaghila nunguaghombela, ywohele ywakayingila ng'obhe mulubhigho lwa mene kwa kupitila palitatilo, peni pakayingila kwa kupitila pamoo pangi, aywo mwihi na mpoki. ");
INSERT INTO nww_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Peni mundu ywakayingilila kupitila palitatilo aywo ndo nhakila ywa mene. ");
INSERT INTO nww_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nkingikiha ywa litatilo kangunhughulila litatilo nhakila aywo, na mene bhanguyihwa lilobhe lyake, naywo kanguakema kila yumu na lihina lyake, na kuapiha panji ya lubhigho. ");
INSERT INTO nww_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Pakaapiha panji, kangulongola kuulongolo ghwabhe nabho mene bhanguntughila, kiyaha bhangulimanya lilobhe lyake. ");
INSERT INTO nww_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Peni Mene bhatantughila ng'obhe nhenja, ngati bhatantugha kiyaha bhangulimanya ng'obhe lilobhe lyake.” ");
INSERT INTO nww_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu kakiaghombela nhwano aghwo, peni bhombe bhakighumanya ng'obhe kila kyakakipalite kuaghombela. ");
INSERT INTO nww_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Hino, Yesu kakiaghombela kangi, “Kulyaghila nunguaghombela, nenga ndo litatilo lya mene. ");
INSERT INTO nww_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bhala bhangi bhoha bhaahikite pakali ya nenga ndo abhwihi na apoka, na mene bhakiayihwa ng'obhe. ");
INSERT INTO nww_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nenga ndo hando litatilo. Ywoheli ywakayingila kupitila kwa nenga katalopoka, kaayingila na kupita panji na katamokola kyohele kyakakipala. ");
INSERT INTO nww_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mwihi kanguhika kwa likaho lya kuyibha, kukoma na kuhanyanga. Nenga hika ngati mmeghe na ubhumi mbole mmeghe naghwo ngenyu.” ");
INSERT INTO nww_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nenga ndo nhakila ywa maha, Nhakila ywa maha kabhegha kala kuhwegha kwakya mene bhake. ");
INSERT INTO nww_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mundu ywakatenda lihengo lya kuhakila mene ili kahombwe ngalabha, ywene mene chepa bha ywombe, pakammona kabhwa bha kunhitu kanguhika katatugha, na kataaleka mene na kupwilinganika ku mbande hyoha. ");
INSERT INTO nww_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ywombe kangutugha kiyaha ndo mundu ywa kuhombwa ngalabha ghweka, hangi milando ya mene kwa ywombe ndo kilibhi ng'obhe. ");
INSERT INTO nww_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nenga ndo nhakila ywa maha, nunguamanya mene bhangu na mene bhangu bhangumanya nenga. ");
INSERT INTO nww_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Handa bhula Tate pakamanya nenga na nenga mununmanya Tate. Na mmegha kala kuhwegha ili mene bhakotoke kuhobha. ");
INSERT INTO nww_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kangi megha na mene bhangi bhene chepa bha lubhigho alu. Yingunogha nubhayeghe bhubho, nabho bhatayihwa lilobhe lyangu, mbole kwabhegha lumati lumu na nhakila yumu.” ");
INSERT INTO nww_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Tate ghwangu kangumbala kiyaha mmegha kala kuhwegha ili mbole hotole kubhegha na ubhumi kangi. ");
INSERT INTO nww_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kahone mundu ywa kumuhila ubhumi ghwangu, peni nenga mbala numwene kughubhuha ubhumi ghwangu. Nenga megha na makakala gha kuubhuha ubhumi ghwangu, kangi megha na makakala gha kuubhuyiha kangi. Ngwiliho ayi kambegha Tate ywangu niyitende.” ");
INSERT INTO nww_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Paayihwite malagho agha Akaayahudi bhakighabhanika kangi. ");
INSERT INTO nww_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ayoloho mu bhombe bhakilongela, “Ayu Kabhegha na lindilo! Kangi kabhegha na nng'uluka! Kiyaha niki mungunnyihwa?” ");
INSERT INTO nww_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bhangi bhakilongela, “Agha chepa malagho gha mundu ywakabhegha na lindilo, yuna lindilo kaahotola kuahughula bhangalola?” ");
INSERT INTO nww_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Akwo ku Yelusalemu kukibhegha na Kikubhukubhu kya kukulungwa kuyohwa Nyumba ya Chapanga, manjubha aghwo ghukibhegha nndaluko ghwa malili. ");
INSERT INTO nww_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Naywo Yesu kakibhegha kangutyanga ku nyumba ya Chapanga mu ludamu lwa Sulemani. ");
INSERT INTO nww_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Akaayahudi bhakintindila na kunkonya, “Ghungutuleka mu bhwaghalihi mbaka pakiki? Handa ghwenga ndo Kilisito Nkombohi, ghutughombele tumanye?” ");
INSERT INTO nww_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu kakiayanga, “Nikibhaghombela, peni mwenga mukinyubhalila ng'obhe. Mahengo ghanughatenda kwa likalama lya lihina lya Tate ywangu ghangubhoneha kukita nenga ndo ghani, ");
INSERT INTO nww_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","peni mwenga mungunyubhalila ng'obhe kiyaha mwenga ndo bhakimati kyangu ng'obhe kya mene. ");
INSERT INTO nww_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mene bhangu bhanguyihwa lilobhe lyangu, nunguamanya, na bhombe bhangundughila. ");
INSERT INTO nww_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nenga nunguapegha ubhumi ghwa manjubha ghoha, nabho bhahobha ng'obhe. Kahone mundu ywa kubhabhuha mumabhoko ghangu. ");
INSERT INTO nww_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tate ywangu ywakambeghite mene abha ndo nkulu kupitingana kwa bhoha, hangi kahone mundu ywakubhabhuha mu mabhoko gha Tate ghwangu. ");
INSERT INTO nww_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nenga na Tate ndo kilibhi kimu.” ");
INSERT INTO nww_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ndo Akaayahudi bhakilokota malibho ngati bhanng'ume na kunkoma. ");
INSERT INTO nww_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu kakiaghombela, “Nubhalaha mihabho miyoloho mikulu kuhuma kwa Tate ghwangu. Ndo nhabho ghwoki nkaki ya ayo ghunguatenda mungome?” ");
INSERT INTO nww_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ayahudi bhakinnyanga, “Tungughughuma ng'obhe malibho kwa mahengo gha maha, ngati kiyaha ghungukundula. Mana ghungulitenda ghwenga Chapanga kunu ghwenga ghu mundu handa bhandu bhangi.” ");
INSERT INTO nww_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu kakiayanga, “Yityekwa ng'obhe mu malaghilo kukita, Chapanga kakilongela ‘Mwenga ndo machapanga.’ ");
INSERT INTO nww_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Handa Chapanga kakiakema machapanga bhala bhakabhalaghilite lilagho lyake, na twenga tungumanya kukita manjubha ghoha malembo gha Chapanga ghangulongela hoto. ");
INSERT INTO nww_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Yibheghaki mungulongela kukita yula ywakahaghulitwe na Tate na kunnlaghila munnima kukita kangukundula? Bhuli, kiyaha nenga nikilongela ndo Mwana ywa Chapanga? ");
INSERT INTO nww_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Handa ningutenda ng'obhe lihengo lya Tate ywangu, hino nkotoke kunyubhalila. ");
INSERT INTO nww_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Peni handa nungutenda lihengo lya Tate ywangu, hata handa mungunyubhalila ng'obhe, hino mughahyubhalile agho mahengo, ili mmokole kumanya na kung'amula kukita Tate kabhegha nkati ya nenga na nenga megha nkati ya Tate.” ");
INSERT INTO nww_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bhakiyigha kangi kunkamula, peni Yesu kakihepetuka mumabhoko ghabhe. ");
INSERT INTO nww_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu kakighenda kangi kumwambo ya lukemba Yoldani, mbaka pala pakabheghite Yohane kangubatisa apo kandahi, naywo kakitama akwo. ");
INSERT INTO nww_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bhandu ayoloho bhakinng'endela na bhakilongela. “Yohane kakitenda ng'obhe nhabho ghwohele, peni milando hyoha yakalongilite Yohane kunninga mundu ayu yibhegha hoto.” ");
INSERT INTO nww_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Na bhandu ayoloho bhaabheghite kula bhakinnyubhalila Yesu. ");
INSERT INTO nww_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mundu yumu lihina lyake Lasalo, ywakatamite ku Betania, kakibhegha ntamwa. Ywombe Lasalo kakibhegha kangutama ku kijiji kyakatamiteghe Malia na Malita ahacha bhake. ");
INSERT INTO nww_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Malia ndo yula ywakanpopolehite Bambo mahuta gha kunungila na kakinpukuta maghulu kwa hwili hyake, na Lasalo ndo nhacha ywake ywakabheghite ntamwa. ");
INSERT INTO nww_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Hino, abho ahacha bhake Lasalo bhakilaghila lilagho kwa Yesu. “Bambo nng'anja ghwako kangubhina.” ");
INSERT INTO nww_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu pakayihwite agho, kakilongela, “Utamwa aghu chepa ghwa kuntenda Lasalo kuuleke ulili, ngati ghwabatenda bhandu bhankwehe Chapanga na kwa njila ayi Mwana ywa Chapanga katakwehwa bhubho.” ");
INSERT INTO nww_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu kakiapala muno Malita na Malia na nhacha ywabhe Lasalo. ");
INSERT INTO nww_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yesu pakayihwite kukita Lasalo kabhegha ntamwa, kakighendelela kukabhalila kwakabheghite kwa manjubha mabhili kyanalumu. ");
INSERT INTO nww_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mbole kakiaghombela ahundwa bhake, “Hinu tubhuye kangi ku nnima ghwa Yudea.” ");
INSERT INTO nww_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ahundwa bhake bhakinng'ombela, “Nhunda, lichanachana apa Akaayahudi bhakipala bhaghughume kwa malibho, hinu ghwenga ghungupala kubhuya kangi akwo?” ");
INSERT INTO nww_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu kakiayanga, “Bhuli, masaa gha pamuhi chepa kumi na mabhili mulinjubha? Bhanakutyanga pamuhi batalikubhala ng'obhe kiyaha bhangulubhona lung'ali lwa luchubha. ");
INSERT INTO nww_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Peni bhala bhanakutyanga pakilo bhatalikubhala kiyaha kahone lung'ali nkati mwa bhombe.” ");
INSERT INTO nww_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu pakayomolite kulongela malagho agha kakiaghombela, “Nng'anja ywetu Lasalo kaghonja, peni nenga ndaghenda kunnyumuha.” ");
INSERT INTO nww_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ahundwa bhake bhakinng'ombela, “Bambo, handa kaghonja ng'ono, katahotola kulama.” ");
INSERT INTO nww_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Bhombe bhakihwacha mihalo ya kughonja ng'ono, peni Yesu kakibhegha kanguyobhela yakya kuhwegha kwa Lasalo. ");
INSERT INTO nww_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ndo Yesu kakiaghombela pekupeku, “Lasalo kauleka ulili, ");
INSERT INTO nww_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","hata habu, nenga nunguyelelwa kiyaha nikibhegha ng'obhe akwo, ili mwenga mmokole kuhyubhalila nenga. Hinu tughende kwa ywombe.” ");
INSERT INTO nww_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ndo Tomasi, ywakakemitwe Pacha, kakiaghombela ahundwa ayake, “Tughende na twenga, ili tukahweghe papamu ywombe.” ");
INSERT INTO nww_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Hino, Yesu pakahikite akwo, kakikolela Lasalo kabhikwa kala ku lindogholo handa manjubha ncheche ghaapitite. ");
INSERT INTO nww_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kijiji kya Betania kikibhegha ugheghela na Yelusalemu, utali ghwa handa kilomita ndatu, ");
INSERT INTO nww_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Na Akaayahudi atangalo bhakihika kuakamula mabhoko Malita na Malia kwakya kibhembo kya nhacha ywabhe. ");
INSERT INTO nww_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ndo Malita pakayihwite kukita Yesu kanguhika, kakighenda kunkingama, peni Malia kakihighala ukaya. ");
INSERT INTO nww_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Malita kakinng'ombela Yesu, “Bambo, handa ghungabheghite apa, nhacha Ywangu kangalekite ng'obhe ulili. ");
INSERT INTO nww_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Peni hata hinu nungumanya kukita kyohele kighupala kunnyupa Chapanga kataghupegha.” ");
INSERT INTO nww_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu kakinng'ombela Malita, “Nhacha ywako katahyuka.” ");
INSERT INTO nww_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Malita kakinnyanga Yesu, “Nungumanya kukita katahyuka nndaluko ghwa uhyuko, mu linjubha lya uhiko.” ");
INSERT INTO nww_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu kakinng'ombela, “Nenga ndo uhyuko, yunubhahyuha bhandu na kuapegha ubhumi. Mundu ywohele ywakanyubhalila nenga katahwegha ng'obhe ngati kaabhegha na ubhumi, ");
INSERT INTO nww_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","na ywohele ywakatama na kuhyubhalila nenga, katahwegha ng'obhe manjubha ghoha. Bhuli, ghungughahyubhalila agha?” ");
INSERT INTO nww_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Malita kakinng'ombela, “Ena Bambo! Nenga nunguhyubhalila kukita ghwenga ndo Kilisito, Mwana ywa Chapanga, yula ywakahika pannima.” ");
INSERT INTO nww_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mbole ya kulongela agha, Malita kakighenda kunkema pambwegha Malia nkulu ywake, “Nhunda kabhegha apa, kangughukema” ");
INSERT INTO nww_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Naywo Malia pakayihwite habhu, kamu kakiyinuka na kakintughila Yesu kwakabheghite. ");
INSERT INTO nww_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu kakibhegha kakali kuyingila ku kijiji, ngati kakibhegha kakali palapala pakakonganite na Malita. ");
INSERT INTO nww_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Hino, bhala Akaayahudi bhaabheghite ukaya bhangunkamula mabhoko Malia, paabhonite bhula pakabhuka kanongola na kughenda panji. Bhakintughila, bhakihwacha kukita kangughenda ku lindogholo kulilila akwo. ");
INSERT INTO nww_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Malia pakahikite pala pakabheghite Yesu, kakichutama mayughwa mumaghulu gha Yesu na kulongela, “Bambo, handa ghungabheghite apa nhacha ywangu kangahweghite ng'obhe!” ");
INSERT INTO nww_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu pakammonite Malia kangulila, na bhala Akaayahudi bhaalongohanite naywo bhangulila bhubho, na kakihyononeka mu mwoyo ghwake na kakikukulika muno. ");
INSERT INTO nww_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Mbole kakiakonya, Mummika kwoki?” Bhakinng'ombela, “Bambo, ghuhike ghupalole.” ");
INSERT INTO nww_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu kakilila mahohi. ");
INSERT INTO nww_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ndo Akaayahudi bhakilongela, “Nnolekehe bhula pakanpalite Lasalo!” ");
INSERT INTO nww_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Peni amoo bhabhe bhakilongela, “Bhuli, ayu ndo ywakannamihite meho yula ywangalola ng'obhe? Bhuli, angahotolite ng'obhe kuntenda na ayu kakotoke kuhwegha?” ");
INSERT INTO nww_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu pakabheghite kakali kanguhyononeka muno, ndo kakighenda ku lindogholo, lindogholo lyene likibhegha mbaku lya litalabha na panlyango likihibhwa na lilibho. ");
INSERT INTO nww_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu kakilongela, “Mulibhuhe lilibho alyo!” Malita, nhacha ywake yula ywakahweghite, kakinnyanga, “Bambo, kangununga kiyaha kabhegha mulindogholo kwa manjubha ncheche!” ");
INSERT INTO nww_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu kakinng'ombela, “Bhuli, nikighughombela ng'obhe kukita paghuhyubhalila ghwaghubhona ukulu ghwa Chapanga?” ");
INSERT INTO nww_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ndo bhakilibhuha lila litalabha. Yesu kakilolekeha kunani na kulongela, “Nungughulumba ghwe Tate kiyaha ghungunyihwa nenga. ");
INSERT INTO nww_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nungumanya kukita ghungunyihwa manjubha ghoha, peni nungulongela agha yakya lumati alu luuyimite apa, ngati ahyubhalile kukita ghwenga ndo ghunaghihite.” ");
INSERT INTO nww_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mbole ya kulongela agha, Yesu kakikweha lilobhe lyake na kakikema, “Lasalo ghuhike kunu panji!” ");
INSERT INTO nww_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Yula mundu ywakahweghite kakihika panji kunu kakibhilingilwa sanda mummili ghwake ghwohana kakihwikwa kilemba mumutwe ghwake. Yesu kakiaghombela, “Mummopole na munneke kaghende.” ");
INSERT INTO nww_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Habhu Akaayahudi ayoloho bhaahikite kunkamula mabhoko Malia, paabhonite ghala ghakatendite Yesu, bhakinnyubhalila. ");
INSERT INTO nww_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Peni amoo bhabhe bhakighenda kwa Afalisayo kuaghombela ghala ghakatendite Yesu. ");
INSERT INTO nww_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Hino, mandundame akulu na Afalisayo bhakikema libalasa lya hilongohi bha Akaayahudi na bhakilongela, “Tutende niki? Mundu ayu kangutenda mihabho mitangalo! ");
INSERT INTO nww_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Patunneka kaghendelele ayu bhandu bhoha bhatannyubhalila, na aka Aloma bhaahika kukihanyanga Kitutubhi kya Chapanga na nnima ghwetu!” ");
INSERT INTO nww_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Yumoo ywabhe, ywakakemitwe Kayafa, ywene kakibhegha Ndundame Nkulu ngungwa ayo, kakilongela, “Mwenga ma nga kamanya kilibhi kyoheli! ");
INSERT INTO nww_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mungumanya ng'obhe kukita mbaha mundu yumu kahweghe, kihyengo kya kahanyangwa bhandu bha nnima ghwetu?” ");
INSERT INTO nww_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Na lilagho alyo ywombe kakilongela chepa kwa mahwacho ghake, ngati kiyaha kakibhegha ndundame nkulu ngungwa yila, kakilondola kukita Yesu katahwegha kwakya nnima aghwo, ");
INSERT INTO nww_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","hangi chepa kwa Akaayahudi ghweka chabhe, ngati bhubho kwakya bhana bha Chapanga bhaapwilinganite, na kuatenda bhabheghe bhamu. ");
INSERT INTO nww_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kutandila linjubha alyo hilongohi bha Ayahudi bhakipalaha njila ya kunkoma Yesu. ");
INSERT INTO nww_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kya habhu Yesu kakileka kutyanga pakindandabhanji mu Akaayahudi, kakighenda mbande yiibheghite ugheghela na kibhala, ku kitami kikemitwe Efulaimu, kakitama akwo na ahundwa bhake. ");
INSERT INTO nww_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Kikubhukubhu kya Akaayahudi ya Pasaka yikiheghelela, bhandu ayoloho bhakighenda ku Yelusalemu kuhumila muhitami hyabhe ngati bhaliyohe kukali Pasaka ayo ili bhayitikilwe na Chapanga. ");
INSERT INTO nww_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ndo bhombe bhakibhegha bhangumpalaha Yesu, na paakonganikite ku kitutubhi kya Chapanga, bhakikonyekehana, “Mungubhoana bhuli, Mundu ayu kaahika ng'obhe mukikubhukubhu aki?” ");
INSERT INTO nww_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Hilongohi bha Andundame na Afalisayo bhakibhika ngwiliho kukita mundu ywohele ywakamanya kwakabheghite Yesu, kabhaghombele ngati amokole kunkamula. ");
INSERT INTO nww_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Manjubha sita yikali na kikubhukubhu kya Pasaka, Yesu kakighenda ku Betania kwakatamiteghe Lasalo, ywene Yesu kakinhyuha. ");
INSERT INTO nww_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Akwo bhakintendekehela mulyo ghwa makimuhi, Malita kakibhegha kangunkeyela Yesu, Lasalo kakibhegha yumoo ywa bhala bhaatamite mu mulyo papamu na Yesu. ");
INSERT INTO nww_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mbole Malia kakitola kyupa kiibheghite na mahuta gha kunungila gha ngalabha ngulu ghaatendikihitwe kwa mmela ghwa nalido, kakinpopohela Yesu mumaghulu ghake na kakinpukuta kwa hwili hyake. Na kitutubhi kyoha kikinungila luhumba lwa mahuta. ");
INSERT INTO nww_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Hino, Yuda Simoni Isikaliyote, yumoo ywa ahundwa bhake ywene ywakapala kunkiluka Yesu, ndo kakilongela, ");
INSERT INTO nww_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Kya bhuli mahuta agha ghangatupeghite mbiya ngenju ya kunhomba mundu kwa ngungwa yimo, na ngalabha ahyo yangakamuhitwe kapukwa?” ");
INSERT INTO nww_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Naywo Yuda kakighalongela agha chepa kwa kuabhonela luhungu kapukwa, ngati kiyaha kakibhegha mwihi. Naywo ndo ywakakamulite nhaku ghwa mbiya na kuhitumila ghweka chake. ");
INSERT INTO nww_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu kakiayanga, “Nkotoke kunghaha nndala ayu! Munneke kiyaha kambopohela mahuta kwakya linjubha lya kukulilwa nenga. ");
INSERT INTO nww_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kiyaha kapukwa mmegha nabho manjubha ghoha peni nenga maabhegha ng'obhe papamu na nenga manjubha ghoha.” ");
INSERT INTO nww_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Akaayahudi ayoloho pabhayihwite kukita Yesu kakibhegha ku Betania, bhakihika chepa kwakya kummona Yesu ghweka chake, ngati na Lasalo ywene Yesu kakinhyuha. ");
INSERT INTO nww_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kya habhu hilongohi bha mandundame bhakitendekeha lukila lwa kunkoma Lasalo bhubho, ");
INSERT INTO nww_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kiyaha kubhukana na mihalo ya kuhyuhwa Lasalo, Akaayahudi ayoloho bhakialema hilongohi bhabhe, bhakintughila Yesu na kunyubhalila. ");
INSERT INTO nww_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kilabhu yake lumati lukulu lwa bhandu bhaahikite ku kikubhukubhu bhakiyihwa kukita Yesu kakibhegha munjila kuhika ku Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Hino bhakitola mapanyu gha misalisi bhakibhuka kughenda kunkingama kunu paakweha malobhe bhakilongela, “Tuntike Chapanga! Kanonelwe aywo yunakuhika kwa makakala gha Bambo. Kanonelwe Mutwa ghwa Akaaisilaeli!” ");
INSERT INTO nww_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu kakimmokola mwana kaputa, na kakihubhuka munng'ongo handa bhula malembo mughalongela. ");
INSERT INTO nww_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Nkotoke kuyoghopa, mabhandu bha ku Sayuni! Mulole Mutwa ghwenu kanguhika, kahubhuka mwana kaputa.” ");
INSERT INTO nww_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kalongohi ahundwa bhake Yesu bhakimanya ng'obhe milando ayi, peni Yesu pakanyahulitwe kala, ndo bhakikulungwa kukita milando ayi yikityekwa kwakya ywombe, na kukita bhandu bhakintendela ywombe. ");
INSERT INTO nww_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lumati lwa bhandu luubheghite papamu na Yesu pala pakankemite Lasalo kuhuma mu lindogholo, na kunhyuha, bhakighendelela kualongela bhangi kila kyakakitendite Yesu. ");
INSERT INTO nww_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kya habhu lumati alwo lwa bhandu lukinkingama, kiyaha bhakiyihwa kukita Yesu kakighutenda nhabho aghwo. ");
INSERT INTO nww_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Habhu Afalisayo bhakighombana bhombe kwa bhombe, “Mungubhona, kukita tunguhotola ng'obhe kutenda kilibhi kyohele kangi! Nnole, bhandu bhoha bhanguntuughila ywombe!” ");
INSERT INTO nww_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Apo ku Yelusalemu bhakihika bhubho amoo Akaagiliki kutundamila mu Kikubhukubhu kya Pasaka. ");
INSERT INTO nww_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Abho bhakinng'endela Filipi nkola nnima ghwa Betisaida ya ku Galilaya, bhakinng'ombela, “Bambo tungupala kummona Yesu.” ");
INSERT INTO nww_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipi kakighenda kunng'ombela Andelea, mbole bhoha abhili bhakighenda kunng'ombela Yesu. ");
INSERT INTO nww_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu kakiayanga, “Lisaa lya kukwehwa nenga Mwana ywa Mundu lihika kala. ");
INSERT INTO nww_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kulyaghila nunguaghombela. Lupunje lwa ngano kyanga kuponeka mu lutupi na kuhwegha lwahighala handa lupunje. Peni paluponeka na kuhwegha, lwapambika mbunje nyoloho. ");
INSERT INTO nww_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mundu ywohele ywakaghupala ubhumi ghwake kataghuhobheha, naywo ywakaghukalalila ubhumi ghwake mu nnima aghu kataghubhika kwakya ubhumi ghwanga kupela. ");
INSERT INTO nww_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mundu ywohele ywakapala kundumikila nenga yingunkwiliha kanndughile, ili kabheghe papamu na nenga pohele pambala kubhegha. Mundu ywohele yakandumikila nenga Tate ghwangu katantetekeha.” ");
INSERT INTO nww_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Hino mwoyo ghwangu ghungubhaghaya munu, hino nenga nongele niki? Peni yingunnogha ng'obhe kulongela, ‘Tate, ghunopole mulisaa ali’ Kiyaha kulyaghila nenga hika munnima aghu ili mbamatike. ");
INSERT INTO nww_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tate, lihina lyako likwehwe!” Ndo likihika lilobhe kuhuma kunani kwa Chapanga, “Nilikwiha kala, na ndalikweha kangi.” ");
INSERT INTO nww_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Lula lumati lwa bhandu luubheghite pala lukiyihwa. Nalwo lukilongela, ali lilobhe lya njahe, bhangi bhakilongela, “Ndumitumi ghwa kunani kwa Chapanga kanguyobhela naywo!” ");
INSERT INTO nww_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Peni Yesu kakiaghombela, “Lilobhe ali liyihwanika kwakya mwenga, na chepa kwakya nenga. ");
INSERT INTO nww_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Hinu ndo lisaa lya kutoswa nnima aghu, na nkulu ghwa nnima aghu katataghwa panji. ");
INSERT INTO nww_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nenga panyinulighwa kunani mwa nnima, ndabhahuta bhandu bhoha kwa nenga.” ");
INSERT INTO nww_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu kakilongela agha pakilaha kiho kya bhuli kyakalonda kuhwegha. ");
INSERT INTO nww_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Lula lumati lwa bhandu likinnyanga, “Tuyihwanila kuhuma mu malaghilo kukita Kilisito Nkombohi katalama manjubha ghoha ghangapela. Hinu ghungulongela bhuli ghwenga Mwana ghwa mundu katayinulighwa kunani mwa nnima? Aywo mwana ghwa mundu ndo ghani?” ");
INSERT INTO nww_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ndo Yesu kakiayanga, “Lung'ali lukali papamu na mwenga kyamandina, nnyendelele kutyanga nalwo lukali palung'aliha ili lubhindo lukotoke kubhahotola, kiyaha mundu ywakatyanga mu lubhindo kaamanya ng'obhe kwakaghenda. ");
INSERT INTO nww_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Muluyubhalile lung'ali alwo, pammegha papamu nalwo, ili mmeghe bhana bha mulung'ali.” Mbole ya kulongela agha Yesu kakibhuka, kakilihiha ili akotoke kummona. ");
INSERT INTO nww_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Hata mbole ya kutenda mihabho hyoha ayi mu ulongolo ghwabhe, bhombe bhakinyubhalila ng'obhe, ");
INSERT INTO nww_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ayi yikibha ili litwihilike lila lilagho lya mbuye Isaya lyakalongelite. “Bambo, ghani ywakalihyubhalilite nhalo ghuutughulongelite? Kangi Chapanga kammoneha ghani makakla ghake?” ");
INSERT INTO nww_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Habhu bhakinhyubhalila ng'obhe Yesu, kiyaha mbuye Isaya kakilongela pamoo pangi. ");
INSERT INTO nww_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Chapanga kabhapohola meho ghabhe na kabhapughaha mahala ghabhe, ili akotoke kubhona kwa meho ghabhe akotoke kumanya kwa mahala ghabhe, na akotoke kungilimbuka, ili hotole kualamiha, kangulongela Bambo.” ");
INSERT INTO nww_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Mbuye Isaya kakilongela agha kiyaha kakighubhona ukulu ghwa Yesu na kakilongela mihalo ya ukulu aghwo. ");
INSERT INTO nww_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hata naha, ayoloho bha hilongohi bha Akaayahudi bhakinhyubhalila Yesu, Peni bhakilongela ng'obhe pakindandabhanji kukita bhakinhyubhalila, kiyaha bhakiyoghopa Akaafalisayu kuabhinga mu nyumba hya ngonganilo. ");
INSERT INTO nww_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Hilongohi abho bha Akaayahudi bhakipala kutikilwa na bhandu na chepa kutikilwa na Chapanga. ");
INSERT INTO nww_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Mbole Yesu kakilongela kwa lilobhe likulu, “Mundu ywohele ywakanhyubhalila nenga, kangunhyubhalila ng'obhe nenga ghweka changu, ngati kangunhyubhalila yula ywakanaghihite bhubho. ");
INSERT INTO nww_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ywoheli ywakamona nenga kungummona na yula ywakanaghilite. ");
INSERT INTO nww_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nenga hika pa nnima handa lungali, ili mundu ywohele ywakanyubhalila kakotoke kuhighala mulubhindo. ");
INSERT INTO nww_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Na ywohele ywakaghayihwa malagho ghangu peni kangughakamulila ng'obhe, nenga ndantosa ng'obhe. Kiyaha hika ng'obhe kubhatosa bhandu bha munnima, ngati kubhalopola. ");
INSERT INTO nww_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Peni bhoha bhaanganite nenga na kulema malagho bhaatoswa mu linjubha lya toso kwa malagho gha hoto ghanighalongelite! ");
INSERT INTO nww_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ayi ndo hoto, kiyaha ningulongela ng'obhe kwa kulamula numwene, ngati Tate ywangu ywakanaghihite ndo ywakangwilikihite niki kya kulongela na mumbala kulongela. ");
INSERT INTO nww_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na nenga nungumanya kukita ngwiliho yake yingughegha ubhumi ghwangapela ghwa manjubha ghoha. Hino, nenga nungulongela ghala ghweka ghakanaghilite Tate nighalongele.” ");
INSERT INTO nww_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Likibhegha linjubha limu kali na kikubhukubhu kya Pasaka, Yesu kakimanya kukita lisaa lyake lya kubhuka pannima na kughenda kwa Tate likihika. Yesu kakiapala muno ahundwa bhake na kulyaghila kakiapala muno kyanga uhiko. ");
INSERT INTO nww_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Hino, Yesu na ahundwa bhake bhakitama kulyegha mulyo ghwa makimuhi. Naywo Nchipila kakinnyingila kala Yuda, mwana ywa Simoni Isikaliote mwoyo ghwa kunkiluka Yesu. ");
INSERT INTO nww_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Peni Yesu kakimanya kukita Tate kakimpegha makakala ghoha, na kakimanya kukita kakihuma kwa Chapanga na kangubhuya kwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Habhu kakibhuka mu mulyo, kakihula lipinda lyake lya panji lya lihengo, na kakilikunga kitambala mukibhuno. ");
INSERT INTO nww_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Mbole kakipopoha machi mu nkambo na kuyanda kuaghulula maghulu ahundwa bhake na kuapukuta kwa lila kitambala kyakalikungite handa nkungi. ");
INSERT INTO nww_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pakanhikilite Simoni Petili, Petili kakinng'ombela Yesu, “Bambo, bhuli, ghwenga ghwang'ulula maghulu ghangu?” ");
INSERT INTO nww_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu kakinnyanga, “Ghungumanya ng'obhe kinukitenda hinu, peni mbole ghwakimanya.” ");
INSERT INTO nww_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petili kakinng'ombela Yesu, “Akakaa, ghwenga ghwang'ulula ng'obhe nenga maghulu!” Yesu kakinnyanga, “Handa panughughulula ng'obhe, ghwenga ghwabhegha ng'obhe papamu na nenga kangi.” ");
INSERT INTO nww_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Petili kakinnyanga, “Bambo, ghung'ulule kangi chepa maghulu ghweka, ngati papamu na mabhoko ghangu na mutwe bhubho!” ");
INSERT INTO nww_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu kakinng'ombela, “Mundu ywakayoghite kala kangunoghwa kukuha maghulu ghweka, kiyaha mmili ghwake ghoha ghubhegha nyanyi, peni ndo mabhoha ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu kakimmanya yula ywakapala kunkiluka, ndo mana kakilongela, “Mwenga nng'ululika, peni mabhoha ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu pakayomolite kuaghulula maghulu ghabhe, kakihwala kangi lipinda lyake, kakibhuya kutama pakulyegheha na kakiakonya. “Mungumanya agha ghanuatendelite? ");
INSERT INTO nww_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mwenga mungungema nenga Nhunda na Bambo, ayi tela, kiyaha ndo numeghite. ");
INSERT INTO nww_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Hino, handa nenga Bambo na Nhunda ghwenu nubhaghulula maghulu, na mwenga bhubho mungunoghwa kulighulula maghulu mabhene kwa mabhene. ");
INSERT INTO nww_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nubhapegha nhwano aghu, ngati na mwenga bhubho ntende handa munuatendela. ");
INSERT INTO nww_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kulyaghia nunguaghombela, nndumindumi chepa nkulu kupitingana kwa bambo ghwake, hangi yunakulaghilwa nkulu ng'obhe kupitingana kwa ywakannaghilite. ");
INSERT INTO nww_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Hino, handa mungughamanya agha, maanonelwa!” ");
INSERT INTO nww_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Nungulongela ng'obhe kwa mabhoha, kiyaha nenga nunguamanya bhanibhahaghulite. Peni mbaka ghatwihilike Malembo gha Chapanga ghaalongela, ‘Yula ywakalyeghite mulyo papamu na nenga, kabhegha mmyanja ywangu.’ ");
INSERT INTO nww_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nenga ningubhaghombela mihalo ayi hinu yikali na kubwitukila, ngati paghabwituka mmokole kuhyubhalila kukita ‘Nenga mwene.’ ");
INSERT INTO nww_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kulyaghila nunguaghombela, ywohele ywakankingama yula yununnaghilite kangungingama nenga, na ywakangingama nenga kangunkingama yula ywakanaghilite.” ");
INSERT INTO nww_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Pakayomolite kulongela agha, Yesu kakibhaghaya muno mumwoyo ghwake, na kakilongela pekupeku, “Kulyaghila nunguaghombela, yumu ywenu katangiluka.” ");
INSERT INTO nww_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ahundwa bhake bhakilolekehana kyangamanya kukita kangunninga ghani. ");
INSERT INTO nww_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nhundwa yumu, ywene Yesu kakibhegha kangunpala muno, kakibhegha kangutama ugheghela na Yesu. ");
INSERT INTO nww_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Hino, Simaoni Petili kakinnahila kibhoko na kakinng'ombela, “Ghunkonye kangunninga ghani?” ");
INSERT INTO nww_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Habhu nhundwa aywo kakiheghelela ugheghela na Yesu na Kakinkonya, “Bambo, ndo ghani aywo?” ");
INSERT INTO nww_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu kakinnyanga, “Yula yumbala kunpegha kipalamande kya lingate mbole ya kukichwika mu bakuli, ndo yuywayu.” Habhu kakikitola kipalamande kya lingate, kakikichwika mukiluki na kakinpegha Yuda, mwana ghwa Isikaliote. ");
INSERT INTO nww_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yuda pakakingamite kila kipalamande kya lingate, Nchipia kakinnyingila. Hino, Yesu kakinng'ombela, “Kighukipala kukitenda ghukitende kanongola!” ");
INSERT INTO nww_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Peni kahone hata yumu ywa bhala bhaatamite mu mulyo ywakamanyite kiyaha niki Yesu kakinng'ombela habhu. ");
INSERT INTO nww_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kiyaha Yuda kakibhegha mmika ngalabha, amoo bha ahundwa bhakihwacha kukita Yesu kakinng'ombela kakahemela hilibhi hya kikubhukubhu, ebu kakinng'ombela kakaapeghe makapukwa hilibhi hyohele. ");
INSERT INTO nww_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Hino, Yuda pakakikingamite kala kila kipalamande kya lingate, kakibhuka unyumba kanongola. Nayo yikibhegha lubhindo. ");
INSERT INTO nww_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Mbole ya Yuda kubhuka unyumba, Yesu kakilongela, “Lisaa lihika kwa ukulu ghwa Mwana ywa Mundu ghwabhonekana pakindandabhanji, naywo Chapanga katakwehwa kwa ywombe. ");
INSERT INTO nww_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Mwana katabhoneha bhula Chapanga paghubheghite nkulu. Mbole Chapanga katantola Mwana na kubhabhoneha bhandu bhula pakabheghite nkulu, katatenda habhu kwa kulopokela. ");
INSERT INTO nww_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Bhana bhangu, megha papamu na mwenga kwa nndaluko ghwa mandina hela. Maambalaha, peni hinu nungaaghombela ghala ghanibhaghombilite hilongohi bha Akaayahudi, ‘Kung'enda nenga, mwenga mahotola ng'obhe kughenda.’ ");
INSERT INTO nww_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nungubhapegha ngwiliho ya hyona, nlipale. Mulipale handa nenga panubhapalite. ");
INSERT INTO nww_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Panpalana, bhandu bhoha bhaamanya kukita mwenga ndo ahundwa bha nenga.” ");
INSERT INTO nww_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Petili kakinkonya Yesu, “Bambo ghungughenda kwoki?” Yesu kakinnyanga Petili, “Kung'enda nenga ghwahotola ng'obhe kundughila hinu, peni ghwandughila mbole yake.” ");
INSERT INTO nww_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petili kakinkonya kangi Yesu, “Bambo kya bhuli nenga ndahotola ng'obhe kughutughila hinu? Nenga Megha kala mbaka kuhwegha kwakya ghwenga!” ");
INSERT INTO nww_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu kakinnyanga Petili, “Bhuli, ghwenga ghwaghubhuha ubhumi ghwako kwakya nenga? Kulyaghila nungughughombela, yikali na mbichi kubhika, ghwangana pandatu kukita ghungumanya ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu kakiaghombela, “Nkotoke kubhaghaya mu myoyo yenu Mungunhyubhalila Chapanga munyubhalile na nenga bhubho. ");
INSERT INTO nww_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ukaya kwa Tate ghwangu kubhegha na hyumba ndangalo hela bhubho ningabhaghombilite, kiyaha nungughenda kuatendekehela lubhagha. ");
INSERT INTO nww_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na mbole ya kughenda na kuatendekehela pahala, ndaabhuya na kuatola, ngati mwenga mmeghe pala pameghite nenga. ");
INSERT INTO nww_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Munguyimanya njila ya kughenda akwo kung'enda nenga.” ");
INSERT INTO nww_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi kakinkonya, “Bambo twenga tungukumanya ng'obhe kughughenda, hinu twayimanya bhuli ayo njila?” ");
INSERT INTO nww_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu kakinnyanga, “Nenga ndo njila na hoto na ubhumi, kahone mundu ywakahotola kughenda kwa Tate, ngati kupitila nenga. ");
INSERT INTO nww_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Handa mungamanyite nenga, munganmanyite na Tate ghwangu bhubho, na kuyandila hinu mungunmanya Tate kangi mummona kala.” ");
INSERT INTO nww_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipi kakinng'ombela, “Bambo ghutubhonehe Tate ghwe kando kitukipala.” ");
INSERT INTO nww_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu kakinnyanga, “Ndama na mwenga manjubha ghoha agha, ghwenga Filipi ghungummanya ng'obhe Tate? Ywakamonite nenga kammona na Tate, hino ghungulongela bhuli, ‘Ghutubhonehe Tate?’ ");
INSERT INTO nww_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Bhuli, Filipi ghunguhyubhalila ng'obhe, kukita nenga megha nkati ya Tate na Tate kabhegha nkati yangu? Malagho ghanuaghombela, nunguyobhela ng'obhe handa mumbala mwene, ngati Tate ywakabheghite nkati yangu ndo kangutenda mahengo ghake. ");
INSERT INTO nww_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Munyubhalile kukita nenga megha nkati ya Tate, naywo Tate kabhegha nkati yangu, handa Chepa, nhyubhalile kubhukana na mahengo ghala ghanughatenda. ");
INSERT INTO nww_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kulyaghila nunguaghombela. Ywakanyubhalila nenga katatenda milando yiniyitenda nenga, kulyaghila, kataghatenda makulu kuchweha, kiyaha nenga nungughenda kwa Tate. ");
INSERT INTO nww_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na kyoheli kimukiyupa kwa makakala gha lihina lyangu akyo ndakitenda, ili Mwana kannyeghele uhokamo Tate. ");
INSERT INTO nww_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Handa pamunyupa lilagho lyohele kwa makakala gha lihina lyangu ndabhatendela.” ");
INSERT INTO nww_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Handa hoto mungumbala, maayitikila ngwiliho hyangu. ");
INSERT INTO nww_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nenga ndannyupa Tate, naywo kataapegha Ntangatila yungi ili katame na mwenga mu manjubha ghoha, ");
INSERT INTO nww_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nhuki aywo kataahwimulila bhandu uhoto. Bhandu bhene bhangunnema Chapanga bhahotola ng'obhe kunkingama Nhuki aywo, kiyaha bhangummona ng'obhe, kangi bhangunmanya ng'obhe. Peni mwenga mungummanya Nhuki ywa Chapanga kiyaha kangutama papamu na mwenga, kangi kangubhegha nkati yenu.” ");
INSERT INTO nww_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ndabhaleka ng'obhe mwenga mmeghe ghweka chenu, ngati ndahika kangi kwa mwenga. ");
INSERT INTO nww_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mbole ya manjubha gha mandina bhandu bha nnima bhamona kangi ng'obhe, peni mwenga mamona, kiyaha nenga ndabhegha na ubhumi, na mwenga maabhegha na ubhumi bhubho. ");
INSERT INTO nww_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Linjubha alyo palihika, maamanya kukita nenga megha nkati ya Tate ywangu, na mwenga mmegha nkati ya nengu na nenga megha nkati ya mwenga.” ");
INSERT INTO nww_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ywoheli ywakakingama ngwiliho yangu na kuyitikila, aywo ndo kangumbala nenga. Na Tate ywangu katammpala yula ywakambala nenga, na nenga ndammpala na ndalibhoneha kwa ywombe.” ");
INSERT INTO nww_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ndo Yuda, Chepa yula Isikaliote, kakinng'ombela Yesu, “Bambo, yahotoleka bhuli ghwenga kulibhoneha kwa twenga na chepa kwa bhandu bha ghanga kughuhyubhalila ghwenga?” ");
INSERT INTO nww_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu kakinnyanga, “Mundu pakambala, kaayitikila lilagho lyangu. Naywo Tate ywangu katampala, nenga na Tate twaahika kutama na ywombe. ");
INSERT INTO nww_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mundu ywohele ywakambala ng'obhe katayitikila ng'obhe lilagho lyangu, na mahundo ghanubhapeghite chepa gha nenga, ngati gha Tate, ywakanaghilite.” ");
INSERT INTO nww_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nungubhaghombela agha ghoha pameghitie ngali papamu na mwenga. ");
INSERT INTO nww_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Peni Ntangatila, ndo Nhuki ywa Chapanga, ywene Tate katannaghila kwa makakala gha lihina lyangu, kataahunda milando hyoha, nayo kataatangatila kukulungwa ghoha ghanubhaghombela.” ");
INSERT INTO nww_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nungubhalekela uhihimilo, ndo uhihimilo ghuuhuma kwa nenga numwene. Chepa uhihimilo ghuuhuma kwa bhandu bha nnima. Nkotoke kubhaghaya ku myoyo yenu hangi nkotoke kuyoghopa. ");
INSERT INTO nww_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mukinyihwa panongela, ‘Nungughenda, peni ndabhuya kangi kwa mwenga.’ Handa mungambalite mungayelelitwe kiyaha nungughenda kwa Tate, kiyaha ywombe ndo nkulu kupitingana nenga. ");
INSERT INTO nww_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nungubhaghombela milando ayi hyoha ikali na kubwitukila, ngati payilonda kubwitukila mmokole kunyubhalila. ");
INSERT INTO nww_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ndayobhela ng'obhe na mwenga kangi milando mitangalo, kiyaha ntabhala ywa nnima aghu kanguhika. Peni kabhegha ng'obhe na makakala kwa nenga, ");
INSERT INTO nww_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","peni bhandu bha mu nnima bhangunoghwa bhamanye kukita nungumpala Tate, na handa bhula Tate pakang'ombelite.” “Haya nnyime, tubhuke apa.” ");
INSERT INTO nww_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu kakighendelela kulongela, “Nenga ndo nsabibu ywa hoto, na Tate ywangu ndo nkulima. ");
INSERT INTO nww_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Lipanyu lyohele munenga lyangapambika, Tate ywangu kangulidumula, na lipanyu lyohele linakupambika mapambiko kangulipyetulila. ");
INSERT INTO nww_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mwenga mmegha kala nyanyi kubhukana na ghula nhalo ghunuaghombilite. ");
INSERT INTO nww_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ntame nkati ya nenga, na nenga ndaatama nkati ya mwenga. Handa bhula lipanyu mulihotola ng'obhe kupambika mapambiko kyanga kubhegha mu nsabibu, ubhwabhuabhu na mwenga mahotola ng'obhe kutenda ghala ghakaghapala Chapanga kyanga kutama nkati ya nenga.” ");
INSERT INTO nww_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nenga ndo nsabibu, na mwenga ndo mapanyu. Ywakatama nkati ya nenga, na nenga ndaatama nkati yake, aywo kaapambika mapambiko matangalo, kiyaha kyanga nenga mahotola ng'obhe kutenda nnando ghwohele. ");
INSERT INTO nww_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mundu ywohele ywangatama nkati ya nenga katataghwa panji handa lipanyu na kuyuma, bhandu bhatalikungana na kulitagha mumwoto, na lyahyoka. ");
INSERT INTO nww_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mwenga pantama nkati ya nenga na malagho ghangu paghatama nkati yenu, munnyupe Tate kyoheli kimukipala, na mwenga maapeghwa. ");
INSERT INTO nww_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kya habhu bhandu bhaamanya kukita Tate ywangu pakabheghite nkulu, handa mwenga maatenda ghala ghakaghapala Chapanga na mabhegha ahundwa bhangu hoto hoto. ");
INSERT INTO nww_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Handa bhula Tate pakambalite nenga, habhu nenga nunguapala mwenga. Hinu ntame mu upalo ghwangu. ");
INSERT INTO nww_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Pannyitikila ngwiliho hyangu, nenga ndaaghendelela kuapala, handa bhula Tate ywangu pakaghendelela kumbala.” ");
INSERT INTO nww_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nubhaghombela milando ayi ili mwenga nngendelele kunyeleha nenga, na nenga nng'endelele kuayelela mwenga. ");
INSERT INTO nww_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ayi ndo ngwiliho yangu mulipale handa munuapalite mwenga. ");
INSERT INTO nww_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Njila ngulu ndo ya kuabhoneha upalo ndo kubhegha kala kuhwegha kwakya bhombe. ");
INSERT INTO nww_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mwenga maabhegha ghanja bhangu handa pantenda ghala ghanubhakwilikihite. ");
INSERT INTO nww_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nenga nungubhakema kangi ng'obhe mwenga abhandwa, ngati nunguakema aghanja kiyaha abhandwa bhangumanya ng'obhe kyakakitenda bambo ywabhe. Ngati mwenga nungubhakema mwenga ghanja, kiyaha nubhaghombela kala milando hyoha yiniyiyihwite kuhuma kwa Tate ywangu ");
INSERT INTO nww_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Chepa mwenga mukihaghula nenga, peni nenga ndo yunubhahaghulite mwenga na kubhalagha ngati nng'ende mukabhatende bhandu bhangi bhanyubhalile nenga, na mapambika ghenu ghakamale. Na kukita kyoheli kimukiyupa kwa makakala gha lihina lyangu, Tate ywangu katabhapegha. ");
INSERT INTO nww_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Hino, ayi ndo ngwiliho yangu, nungaalaghila kila mundu kampale nnyake. ");
INSERT INTO nww_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Handa Bhandu bha nnima paabhapala ng'obhe mwenga, nkulungwe kukita bhakimbala ng'obhe nenga ikali na kuapala ng'obhe mwenga. ");
INSERT INTO nww_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Handa mungabheghite bhandu bha nnima aghu, bhandu bha nnima bhangabhapalite handa bhula paabhapala ayabhe. Peni kya bhula mwenga chepa bhandu bha nnima aghu, ngati nenga nubhahaghula mwenga kuhuma munnima, kya habhu bhandu bha nnima bhanguapala ng'obhe. ");
INSERT INTO nww_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nkulungwe lila lilagho linubhaghombilite, ‘Kahone ndumindumi ywakabhegha nkulu kupitingana bambo ywake.’ Handa bhandu bhambamanda nenga, bhataapamanda na mwenga bhubho, na handa bhatalikingama lilagho lyangu, bhatalikingama na lilagho lyenu bhubho. ");
INSERT INTO nww_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Peni bhatabhatendela mwenga agha ghoha kubhukana na kunyubhalila nenga, kiyaha bhangunmanya ng'obhe ywakanaghilite nenga. ");
INSERT INTO nww_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Handa ningahikite ng'obhe na kuyobhela nabho, bhangabheghite ng'obhe na uhokelo, peni hino bhaahotola ng'obhe kulikingikiha kukita abhegha ng'obhe na ulemwa. ");
INSERT INTO nww_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mundu ywohele ywakambala ng'obhe nenga, kangumpala ng'obhe Tate ywangu bhubho. ");
INSERT INTO nww_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Niyitenda mihabho yene kabhone ywakatendite yikali ya nenga. Handa bhangamonite ng'obhe panuyitenda mihabho ayo, ndo bhangabheghite ng'obhe na ulemwa. Peni hinu bhamona nenga panuyitenda mihabho ayo na bhakali bhangumbala ng'obhe nenga na Tate ywangu bhubho. ");
INSERT INTO nww_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Bhangutenda habhu ili litwihilike lila lilagho liityekitwe mu Malaghilo kukita, ‘Bhakimbala ng'obhe nenga yunumeghite ngo'obhe na ghwoheli.’ ” ");
INSERT INTO nww_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ndabhalaghila Nhuki ywa Chapanga ywakahuma kwa Tate, kataabhoneha uhoto, Nhuki aywo kataatangatila na kuaghombela ghaniapala nenga. ");
INSERT INTO nww_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Na mwenga ubhwabhu mannyimiha nenga, kiyaha mukibegha na nenga kutandila kalongohi.” ");
INSERT INTO nww_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nubhaghombela milando ayi ngati nkotoke kuleka kunyubhalila. ");
INSERT INTO nww_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bhandu bhataabhingabhinga mu nyumba hyabhe hya kukonganila, kangi nndaluko ghunguhikaghwene ywohele ywakapala kuakoma katahwacha kukita kangutenda lihehengo lya Chapanga. ");
INSERT INTO nww_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nabho bhatabhatendela milando ayi kiyaha bhangummanya ng'obhe Tate hangi bhangumanya ng'obhe nenga. ");
INSERT INTO nww_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Peni nubhaghombela milando ayi, ili palilonda kuhika lisaa lya kutendeka agho, maakulungwa kukita nikibhaghombela.” “Nikibhaghombela ng'obhe milando ayi kutandila kalongohi, kiyaha nikibhegha papamu na mwenga. ");
INSERT INTO nww_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Peni hinu nenga nungughenda kwa ywombe Ywakanaghilite, na kahone yumu ywenu ywakangonya nungughenda kwoki ");
INSERT INTO nww_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kiyaha nubhaghombela milando ayi, hinu mwenga mungukukulika. ");
INSERT INTO nww_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nungubhaghombela gha hoto, Mbaha kwa mwenga, nenga muke, handa kyangabhuka nenga, aywo Nhuki ywa Chapanga katahika ng'obhe kwa mwenga. Peni pang'enda, ndo ndannaghila kwa mwenga ");
INSERT INTO nww_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Naywo paahika kala, kataabhoneha bhandu bha nnima kukita bhanguhokela yakya mihalo ya ulemwa na bhanguhokela yakya ghanakunoghela na bhanguhokela yakya toso ya Chapanga. ");
INSERT INTO nww_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Bhanguhokela kwa mihalo ya ulemwa, kiyaha bhangunhyubhalila ng'obhe nenga, ");
INSERT INTO nww_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","bhanguhokela kwa mihalo ya kunnogheha Chapanga, kya habhu, nungughenda kwa Tate na mwenga mamona ng'obhe kangi, ");
INSERT INTO nww_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","bhanguhokela kwa mihalo ya toso yanganoghela, kiyaha yula nkulu ywa bhandu bha nnima aghu, ywene ndo Nchipila katoswa kala.” ");
INSERT INTO nww_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ngali megha na milando miyoloho ya kualubhulila, peni mahotola ng'obhe kuyimanya hinu. ");
INSERT INTO nww_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Peni pakapala kuhika aywo Nhuki ywa hoto, kaalongoha ku hoto hyoha ya Chapanga, ywombe kaalongela ng'obhe mihalo yake mwene, ngati katakambuka ghala ghakaghayihwite, na kuaghombela milando yipala kuhika. ");
INSERT INTO nww_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ywombe katabhabhoneha nega mumeghite nkulu, kiyaha kaaghatola ghala ghanighalongela na kuaghombela mwenga. ");
INSERT INTO nww_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Hyoha hyakabheghite nahyo Tate ndo hyangu, ndo mana nongela kukita aywo Nhuki katabhaghombela ghala ghoha ghakaghayihwite kuhuma kwa nenga.” ");
INSERT INTO nww_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ghakali manjubha gha mandina ndabhuka na maamona ng'obhe, na mbole ya manjubha gha mandina maamona kangi.” ");
INSERT INTO nww_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Apwo amoo ahundwa bhake bhakiyanda kukonyana, “Fwambulo ya agha ghaaghalongela ndo yoki? Kangutughombela kukita yikali manjubha gha mandina maamona ng'obhe, na kangi mbole ya manjubha gha mandina twaammona, kangi kabhegha na mana yoki pakalongela, ‘Kiyaha nugughenda kwa Tate.’ ");
INSERT INTO nww_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Hino, bhakighendelela kukonyana mana yake ndo yoki paalongela, ‘Yikali manjubha gha mandina?’ Tungumanya ng'obhe Kyakalongela!” ");
INSERT INTO nww_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu kakimanya kukita bhakipala kunkonya yakya nnando aghwo, habhu kakiaghombela, “Bhuli, mungukonyana mabhene ya kya ghala ghanighalongilite? Ghakali manjubha gha mandina matamona ng'obhe, na mbole ya manjubha gha mandina matamona kangi.” ");
INSERT INTO nww_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kulyaghila nungaaghombela, mwenga maalila na kukukulika, peni bhandu bha munnima bhatayelelwa, mwenga maabhona machwingo peni uchwingo ghwenu ghwakilibhuka uyelelo. ");
INSERT INTO nww_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Yabhegha handa bhula nndala pakaheghelela mu manjubha gha kupapa, peni pakabhelekwa kala mwana kangulibhalila mabhino kubhukana na uyelelo ghwa kubhelekwa mwana munnima. ");
INSERT INTO nww_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Na mwenga hinu mmegha na mabhino, peni mbole yake mamona kangi, ndo maayelelwa, na kabhone mundu ywakapala kuabhuhila uyelelo ghwenu. ");
INSERT INTO nww_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Mu linjubha alyo maanyupa ng'obhe kyohele. Kulyaghila nunguaghombela, Tate kataapegha mwenga kyohele kimukiyupa kwa makakala gha lihina lyangu. ");
INSERT INTO nww_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mbaka hinu nnyupa ng'obhe nnando ghwoheli kwa makakala ghangu, kangi nnyupe ili nnyelelwe muno.” ");
INSERT INTO nww_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nubhaghombela milando ayi kwa mihwano. Lisaa linguhika lyeni ndaalongela ng'obhe na mwenga kwa mihwano, peni ndabhaghombela hotohoto yakya Tate. ");
INSERT INTO nww_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Linjubha alyo palihika, maayupa kwa likalama lya lihina lyangu, na ndabhaghombela ng'obhe kukita ndannyupila kwa Tate, ");
INSERT INTO nww_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","kiyaha Tate mwene kanguapala mwenga. Kanguapala mwenga kiyaha mungumbala nenga na munguhyubhalila kukita huma kwa ywombe. ");
INSERT INTO nww_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nenga huma kwa Tate, na hika apa pannima, na hinu nungubhuka pannima na nungughenda kwa Tate.” ");
INSERT INTO nww_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ndo ahundwa bhake bhakilongela, “Hinu ghungulongela pekupeku kyanga kutumila mihwano. ");
INSERT INTO nww_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Muuhiko tungumanya kukita ghwenga ghungumanya milando hyoha, na tubhegha ng'obhe na kihokonyo kwa mundu ywohele kaghukonye. Habhu tunguhyubhalila kukita ghuhuma kwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu kakiayanga, “Bhuli, hinu munguhyubhalila? ");
INSERT INTO nww_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Lisaa linguhika, na kangi lihika kala, pala mabhoha pampala kupwilinganika, na kila yumu ywenu kataghenda mu njila yake, na kuneka ghweka changu. Peni nenga megha ng'obhe ghweka changu, kiyaha Tate kabhegha na nenga. ");
INSERT INTO nww_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nubhaghombela milando ayi ngati mmokole kubhegha na uhihimilo mu kulilunga na nenga. Munnima bhandu bhatabhatenda npamandike, peni muliyonyokehe mwoyo, nenga nughuhotola kala nnima!” ");
INSERT INTO nww_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Mbole ya Yesu kulongela agha, kakilolekeha kunani kakilongela, “Tate, lisaa lihika kala. Ghunkwehe Mwana ywako ngati mwana ywako naywo kaghukwehe ghwenga. ");
INSERT INTO nww_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mana ghumpegha likalama mu bhandu bhoha, ngati kabhapeghe ulami ghwa manjubha ghoha kyanga uhiko, bhoha bhaghumbeghite. ");
INSERT INTO nww_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Na ulami ghwa manjubha ghoha ndo aghu, Bhaghumanye ghwenga ghuubheghite ghweka chako Chapanga ghwa hoto, na Yesu Kilisto yughunnaghilite. ");
INSERT INTO nww_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nenga nubhabhoneha bhandu ukulu ghwako, kupitila lihengo lila lighumbeghite nilitende. ");
INSERT INTO nww_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Hinu Tate! Ghubhabhonehe bhandu ukulu ghwako, kwa ghula ukulu ghumeghite naghwo pakali ya kubhumbwa nnima.” ");
INSERT INTO nww_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nughutenda ghumanyike kwa bhoha bhaghumbeghite kuhuma pannima. Bhombe bhakibhegha ghwenga chabhe, na ghukimbegha nenga, nabho bhaliyitikila lilagho lyako, ");
INSERT INTO nww_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","hinu bhangumanya kukita hilibhi hyoha highumbegite hihuma kwa ghwenga. ");
INSERT INTO nww_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nenga nubhapegha nhalo ghua ghuumbeghite, na bhombe bhaghukingama, bhangumanya kukita hoto huma kwa ghwenga, na bhanguhyubhalila kukita ghwenga ndo ghunaghilite.” ");
INSERT INTO nww_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nunguayupila bhombe. Nunguyupa ng'obhe kwakya bhandu bha nnima, kangi bhandu bhoha bhaabheghite bha nenga, ndo bha ghwenga. ");
INSERT INTO nww_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Hyoha hiimeghite nahyo ndo hya ghwenga, na hyoha ghuubheghite nahyo ndo hya nenga, na ukulu ghwangu ghubhonekana kukindila bhombe. ");
INSERT INTO nww_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na hinu nunguhika kwa ghwenga, megha ng'obhe kangi pannima, peni bhombe abhegha mu nnima. Tate Chapanga! Kwa likalama lya lihina lyako lighumbeghite, ketekete ghubhabhike maha kwa makakala gha lihina lyako lighumbeghite, ngati abheghe kilibhi kimu, handa nenga na ghwenga mutubheghite bhamo. ");
INSERT INTO nww_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Pameghite papamu na bhombe, nikibhabhika maha kwa likalama lya lihina lighumbeghite. Nenga nibhakingikiha, kahone yumu ywabhe ywakahobhite, maha nga yula mwana nhobheho, ngati Malembo ghabhonekane hoto. ");
INSERT INTO nww_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Hinu nunguhika kwa ghwenga, na nongela nhalo aghu ngali pamegha mu nnima ili ayelelwe muno. ");
INSERT INTO nww_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nubhapegha nhalo ghwako, nabho bhandu bha mu nnima bhabhapala ng'obhe, kiyaha bhombe bhaakuhhyabhalilite ndo chepa bhandu bha nnima aghu, handa bhula nenga mumebheghite ng'obhe ywa nnima aghu. ");
INSERT INTO nww_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nunguyupa ng'obhe kukita ghuabhuhe mu nnima, ngati nunguyupa ghubhakingikihe na yula Nhokelo. ");
INSERT INTO nww_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bhombe chepa bhandu bha nnima aghu handa nenga munubheeghite ng'obhe ywa nnima aghu. ");
INSERT INTO nww_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kulyaghila Tate, nungukuyupa ghubhatetnde abheghe bhandu bhako menyu, mu uhoto ghwako, kiyaha nhalo ghwako ndo hoto. ");
INSERT INTO nww_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Handa bhula paghunaghilite nenga mu nnima, na nenga bhubho nungubhalaghila bhombe mu nnima. ");
INSERT INTO nww_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nilibhuha numwene kwakya Chapanga, ili bhombe amokole kuyitikilwa mu kughutumikila ghwenga. ");
INSERT INTO nww_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Nunguayupila ng'obhe abha ghweka chabhe, peni nunguayupila na bhala bhoha bhaapala kunhyubhalila kupitila lilagho lyabhe. ");
INSERT INTO nww_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Bhoha abheghe na ughumo. Tate, nunguyupa ngati bhombe abheghe nkati yetu, handa bhula ghwenga paghubheghite nkati yangu na nenga nkati yako. Nunguyupa abheghe bhamo ili bhandu bha mu nnima bhahyubhalile kukita ghwenga ndo ghunaghilite. ");
INSERT INTO nww_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ukulu ghula ghuumbeghite nenga nibhapegha bhombe, ngati bhabheghe na ughumo handa twenga mutubheghite na ughumo. ");
INSERT INTO nww_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nenga megha nkati yabhe na ghwenga ghubhegha nkati yangu, ili abheghe atwihiliko muughumo na unnima ghumanye kukita ndo ghwenga ghunaghilite, na nenga nunguapala handa paghumbalite nenga.” ");
INSERT INTO nww_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tate! Ghwenga ndo ghuumbeghite bhandu abha, na nenga nungupala abha bhaghumbeghite abheghe papamu na nenga pala pambala kubhegha, ngati bhaghubhone ukulu ghwangu ghuumbeghite, kiyaha ghumbala ikali na kubhumbwa nnima. ");
INSERT INTO nww_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tate nkola umaha! Bhandu bha mu nnima bhangukumanya ng'obhe, peni nenga nungukumanya, na abha bhangumanya kukita ghunaghila. ");
INSERT INTO nww_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nenga nughutenda ghumanyike kwa bhombe na ndaghendelela kutenda habhu, ili upalo ghumbalite naghwo kwa nenga ghubheghe nkati yabhe, na nenga meghe nkati yabhe.” ");
INSERT INTO nww_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu pakayomolite kuyupa, kakibhuka papamu na ahundwa bhake bhakiyomboka kumwambo ya lukemba Kediloni. Akwo kukibhegha kitogholo, ndo Yesu kakiyingila amwo papamu na ahundwa bhake. ");
INSERT INTO nww_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Naywo Yuda, yula nkiluka kakipamanya pala, kiyaha Yesu kakibhegha kangughenda na ahundwa bhake akwo maghenda maghenda. ");
INSERT INTO nww_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Habhu Yuda kakighenda ku kitogholo, pakilongoha kimati kya machonda bha Akaaloma na amoo bha mahofisa bhaahumite kwa hilongohi bha andundami na Afalisayu, pabhabhegha na mambamba na mikoha. ");
INSERT INTO nww_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu kakimanya ghala ghoha ghaapala kuntulukila, kakilibwitukiha mu ulongolo ghwabhe na kakiakonya, “Mungunpalaha ghani?” ");
INSERT INTO nww_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bhombe bhakinnyanga “Yesu ywa ku Nasaleti.” Yesu kakiaghombela, “Ndo nenga.” Naywo Yuda ywakankilukite Yesu kayima papamu nabho. ");
INSERT INTO nww_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu pakaaghombilite, “Ndo nenga.” Bhombe bhakibhuya kihengele nyuma na kughwegha pahi. ");
INSERT INTO nww_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu kakiakonya kangi, “Mungumpalaha ghani?” Bhombe bhakinnyanga, “Yesu ywa ku Nasaleti.” ");
INSERT INTO nww_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu kakiaghombela, “Nenga nubhaghombela kala kukita ndo nenga, kya habhu handa mungumbalaha nenga mubhaleke abha bhandu bhaghende.” ");
INSERT INTO nww_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yesu kakilongela habhu ili ghabhonekane ghala ghakalongelite, “Bhala bhaghumbeghite nunhobheha ng'obhe hata yumu.” ");
INSERT INTO nww_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Hino, Simoni Petili kakibhegha na lukechelo, kakiluhomola na kakinndumula lichikilo lya kunnilo ndumindumi ywa Ndundame Nkulu, na nndumidumi aywo kakikemwa lihina lyake Maliko. ");
INSERT INTO nww_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu kakinng'ombela Petili. “Ghulubhuyile lijambia lyako munchako ghwake! Bhuli, nnobho ghwakambeghite Tate, nenga ngotoke kughunyweghela?” ");
INSERT INTO nww_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Hino, bhala machonda bha Akaaloma na kilongohi ywabhe na akingikiha bha Akaayahudi bhakinkamula Yesu, bhakimmopa, ");
INSERT INTO nww_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","kalongohi bhakinnyegha kwa Anasi. Aywo Anasi kakibhegha nkohano ywake Kayafa, ywene ywakabheghite Ndundame Nkulu ywa manjubha ghala. ");
INSERT INTO nww_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa ndo yula ywakaapeghite unyeghelehi Akaayahudi kukita yinnogha mundu yumu kahweghe kwakya bhandu. ");
INSERT INTO nww_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Petili papamu na nhundwa yungi bhakintughila Yesu. Aywo nhundwa yungi kakibhegha kangumanyikwa kwa Ndundame Nkulu, habhu kakiyingila papamu na Yesu mbaka mu ludamu lwa Ndundame Nkulu. ");
INSERT INTO nww_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peni Petili kakiyima panje ugheghela na nlyango. Hino aywo nhundwa yungi kakibhuya kuyobhela na ndumindumi nhinja ywakalindila kuhughula nlyango kantegheke Petili kayingile unyumba. ");
INSERT INTO nww_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Yula nhinja ywakalindila kuhughula nlyango kakinkonya Petili, “Na ghwenga ndo chepa yumu ywa ahundwa bhake mundu ayu?” Petili kakiyanga, “Chepa nenga.” ");
INSERT INTO nww_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Limjubha alyo kukibhegha na malili, andumindumi na akingikiha bhakiyaha mwoto na bhakiyima na kuyotela mwoto. Naywo Petili kakiyima papamo na bhombe kanguyotela mwoto. ");
INSERT INTO nww_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Hino, Ndundame Nkulu kakinkonya Yesu kulinga mihalo ya ahundwa bhake na mahundo ghake. ");
INSERT INTO nww_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu kakinnyanga, “Nikibhegha panyobhela manjubha ghoha na bhandu bhoha pakindandabhanji maghenda maghenda, na nikihunda nyumba hya kukonganila Ayahudi na ku Nyumba ya Chapanga, kwene kwaakonganite Akaayahudi bhoha. Hangi nikilongela ng'obhe nhalo ghwohele kwa kihiho. ");
INSERT INTO nww_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kya bhuli ghungungonya nenga? Ghubhakonye bhala bahaanyihwite ghala ghaniaghombilite, bhombe bhangumanya ghaniaghombilite.” ");
INSERT INTO nww_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pakayomolite kulongela agha, yumu ywa machonda ywakayimite ugheghela naywo kakimbhakula mbande Yesu mu kibhungi, na kakilongela, “Ghungunnyanga Ndundame nkulu?” ");
INSERT INTO nww_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu kakinnyanga, “Handa nongela nnando nhakato, ghulongele aghwo uhakata ghunongelite. Peni handa nongela ghaghabheghite hoto, bhuli ghumakula nenga?” ");
INSERT INTO nww_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hino, Anasi kakinnyegha Yesu kwa Ndundame Nkulu Kayafa, kakibhegha kakali kabhopwa. ");
INSERT INTO nww_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Lisaa alyo Simoni Petili kakiyima apo kanguyotela mwoto. Amu ywa bhala bhaayimite pala kakinkonya, “Bhuli, na ghwenga chepa yumu ywa ahundwa bhake?” Ywombe kaking'aka na kulongela, “Aka kaa, nenga chepa” ");
INSERT INTO nww_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Yumu ywa andumindumi bha Ndundame Nkulu, nnongo ywake yula mundu ywene Petili kakinkechula lichikilo, kakinkonya, “Ghwenga nikighubhona ng'obhe kula ku kitogholo papamu na Yesu?” ");
INSERT INTO nww_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petili kaking'aka kangi pa ubhili, kamu mbichi kakibhika. ");
INSERT INTO nww_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mbole Akaayahudi bhakintola Yesu kuhuma kwa Kayafa mbaka ku nyumba kya ntabhala ywa Akaalumi, nayo yikibha malabhila putiputi, peni bhombe bhakiyingila ng'obhe munyumba ayo, bhakiyoghopa kiyaha bhalemwe kuyitikilwa kkuntundamila Chapanga na kulyegha kikubhukubhu kya Pasaka. ");
INSERT INTO nww_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kya habhu Pilato kakiaghendela panji na kakiakonya, “Katenda uhokelo ghani mundu ayu mbaka nhike kunkokela kwa nenga?” ");
INSERT INTO nww_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bhombe bhakinnyanga, “handa mundu ayu kakabheghite ng'obhe na uhokelo, twenga tungannyeghite ng'obhe kwa ghwenga.” ");
INSERT INTO nww_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Hino, Pilato kakiaghombela, “Hino muntole mwenga, mukantose kubhukana na Malaghilo ghenu.” Bhombe Akaayahudi bhakinnyanga, “Twenga Malaghilo ghetu ghangutukanikiha kuntosa mundu ywohele kuhwegha.” ");
INSERT INTO nww_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Akaayahudi bhakilongela habhu ili ghala malagho ghakalongilite Yesu kulinga kiho kyakapala kuhwegha ghatwihilike. ");
INSERT INTO nww_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato kakiyingila kangi unyumba na kakinkema Yesu, na kakinkonya. “Bhuli, ghwenga ndo Mutwa ywa Akaayahudi?” ");
INSERT INTO nww_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu kakinnyanga Pilato, “Ghwenga ghungukonya naha kwa mahwacho ghako ebu ghubhayihwa bhandu bhangi bhaghughombela mihalo yangu?” ");
INSERT INTO nww_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato kakiyanga, “Bhuli, nenga nu Nnyahudi? Bhandu bha nnima ghwako ghumwene na hilongohi bha mandundame ndo bhaghuyegha kwa nenga. Ghutenda uhokelo ghani?” ");
INSERT INTO nww_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu kakilongela, “Ghubhutwa ghwangu chepa ghwa nnima aghu, handa ghubhutwa ghwangu ghungabheghite ghwa nnima aghu, andumitumi bhangu bhangangomanilite, ili ngotoke kuyingihwa mu makakala gha Akaayahudi. Aka kaa, ghubhutwa ghwangu chepa ghwa apa!” ");
INSERT INTO nww_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Hinu Pilato kakinkonya Yesu, “Kya habhu ghwenga ndo mutwa?” Yesu kakiyanga, “Ghwenga ghungulongela kukita nenga ndo mutwa. Nenga nikibhelekwa na kuhika pa nnima kwakya agha, na kwakya agha nikihika pannima ili nuaghombele uhoto bhandu bha nnima. Bhandu bhoha bhaabheghite bha uhoto bhanguyihwa lilobhe lyangu.” ");
INSERT INTO nww_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato kakinkonya Yesu, “Uhoto ndo niki?” Mbole ya kulongela agha, Pilato kakighenda kangi panji na kakiaghombela bhala hilongohi bha Akaayahudi, “Nughubhona ng'obhe uhokelo kwa mundu ayu. ");
INSERT INTO nww_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Peni kwa mwenga Makaayahudi mmegha na mahyobhelelo ghenu, kukita mu kikubhukubhu kya Pasaka nubhahughulile mmopwa yumu. Bhuli, mungupala nubhahughulile mutwa ywa Akaayahudi?” ");
INSERT INTO nww_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Habhu Akaayahudi bhakiyobha kyobho paalongela, “Aka kaa, chepa ayu, tungunpala Balaba!” Naywo Balaba kakibhegha mpoka. ");
INSERT INTO nww_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Hino, Pilato kakikwiliha kukita Yesu katolwe na katutwe hingwechungwechu kya ndomondo. ");
INSERT INTO nww_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nabho machonda bhakipota kilemba kya mihomi, bhakinhwika Yesu mu mutwe na bhakinhwika lijoho litandamaho lya salabati ");
INSERT INTO nww_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","na bhakihika pa ulongolo ghwa Yesu na kunng'ombela, “Mwika Mutwa ywa Akaayahudi!” Bhakinbhakula mbande. ");
INSERT INTO nww_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato kakipita kangi panji na kakiaghombela bhala bhandu, “Nungunyegha panje mundu ayu, peni npati kumanya kukita nenga nungubhona ng'obhe uhokelo kwa ywombe.” ");
INSERT INTO nww_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Habhu Yesu kakihuma panji, pakihwala kilemba kya mihomi na lijoho litandamaho lya salabati. Pilato kakiaghombela, “Munnole mundu ayu!” ");
INSERT INTO nww_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ndo hilongohi bha mandundame na hilongohi paammonite bhakikweha malobhe, paalongela, “Ghummambe! Ghummambe!” Pilato kakiaghombela, “Muntole mabhene, mukammambe, kiyaha nenga nighubhona ng'obhe uhokelo ghwohele kwa mundu ayu.” ");
INSERT INTO nww_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Akaayahudi bhakinnyanga Pilato, “Twenga tubhegha na malaghilo na kubhukana na malaghilo agho kangunoghwa kuhwegha, kiyaha ywombe kakilikema Mwana ywa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Hino, pilato pakayihwite malagho agho, kakiyoghopa kyanalumu. ");
INSERT INTO nww_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kakiyingila kangi ku nyumba lya ubhutwa na kakinkonya Yesu, “Ghwenga ghuhuma kwoki?” Peni Yesu kakiyanga ng'obhe kyohele. ");
INSERT INTO nww_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Habhu Pilato kakinng'ombela, “Ghwenga ghungulema kuyobhela na nenga? Ghungumanya ng'obhe kukita nenga megha na makakala gha kughulekekeha na kughubhamba?” ");
INSERT INTO nww_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu kakinnyanga, “Ghwenga ghungabheghite ng'obhe na makakala kwakya nenga handa ghukamuhwa na Chapanga. Kya habhu, yula ywakanyeghite kwa ghwenga kabhegha na ulemwa nkulu kyanalumu.” ");
INSERT INTO nww_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kutandila apwo, Pilato kakipala njila ya kummopola, peni Akaayahudi bhakiyobha kyobho, paalongela, “Paghummopola mundu ayu, ghwenga ndo ghanja ng'obhe ywa Mutwa nkulu ywa Akaaloma! Kiyaha mundu ywohele ywakalitenda mutwa kangunpingikiha Mutwa nkulu ywa Akaaloma, naywo ndo Kaisali!” ");
INSERT INTO nww_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Hino, Pilato pakayihwite malagho agha, kakinpiha Yesu panji na kakitama mukiteho kya toso, paapakema “Palukilimo lwa malibho.” Na kwa Kibulania pangukemwa “Gabata.” ");
INSERT INTO nww_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nayo yikibhegha ugheghela na linjubha lya kutendekeha Pasaka handa saa sita pamuhi naha. Pilato kakiaghombela Akaayahudi, “Munnole ayu ndo Mutwa ywenu!” ");
INSERT INTO nww_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Akaayahudi bhakikweha malobhe, paalongela, “ Ghunkome! Ghunkome! Ghummambe mulupingika!” Pilato kakiakonya Akaayahudi, “Bhuli, mungupala mummambe Mutwa ywenu?” Bhala hilongohi bha mandundame bhakinnyanga Pilato, “Twenga tubhegha ng'obhe na mutwa yungi ngati nga Mutwa Nkulu ywa Akaaloma!” ");
INSERT INTO nww_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kuuhiko Pilato kakiapegha bhombe bhantole Yesu ili kabhambwe mulupingika. Habhu, machonda bhakintola Yesu na bhakighenda naywo. ");
INSERT INTO nww_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesu kakilupapa lupingika lwake, kakibhuka na kughenda paapakemiteghe “lihuhu lya mutwe,” kwa Kibulania, bhangupakema “Goligota.” ");
INSERT INTO nww_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Apo ndo paammambite Yesu mulupingika, papamu naywo bhakibhambwa bhandu bhangi abhili kila mundu mulupingika lwake, yumu mbande ya nnilo ya Yesu na yungi mbande ya ngiya, na Yesu kakibhegha pakati yabhe. ");
INSERT INTO nww_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato kakikwilikiha ghatyekwe malembo mulipapi na kubhikwa unani mwa lupingika lwa Yesu. Nalwo lukityekwa naha, “YESU YWA KU NASALETI, MUTWA YWA AKAAYAHUDI.” ");
INSERT INTO nww_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Akaayahudi atangalo bhakilisoma lula lupapi, kiyaha pala pakabhambitwe Yesu pakibhegha ugheghela na kitami, nagho matyeko ghakityekwa kwa Kiebulania, na nongelo ya Kilatini na ya Kigiliki. ");
INSERT INTO nww_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Hino, hilongohi bha mandundame bhakinng'ombela Pilato, “Ghukotoke kutyeka, ‘Mutwa ywa Akaayahudi,’ Ngati ghutyeke mundu ayu kakilikema, ‘NENGA NDO MUTWA YWA AKAAYAHUDI.’” ");
INSERT INTO nww_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato kakiayanga, “Kinikityekite kala nikityeka.” ");
INSERT INTO nww_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Machonda paammambite kala Yesu mulupingika, bhakighatola mapinda ghake na bhakighaghabha mafungu ncheche, kila machonda na kifungu kyake. Ngati bhakiyitikilana bhakotoke kulikachula lila lijoho lyake kiyaha likitalaswa ng'obhe ngati likikwatalilwa kutandila kunani mbaka pahi. ");
INSERT INTO nww_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Machonda bhakighombelana bhene, “Tukotoke kulikachula ngati tulitendele usimbi ili kulamula ghani kalitole.” Nnando aghu ghukitendekwa habhu ili ghatwihilike malembo ghaalongela. “Bbhombe bhakighabhana mapinda ghangu na lijoho lyangu bhakilitendela usimbi.” Habhu ndo bhakitenda machonda. ");
INSERT INTO nww_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ugheghela na lupingika lwa Yesu bhakiyima Malia mama ywake Yesu, na nnung'una ywa mama ywa Yesu na Malia nhumbu ywa Kilopa na Malia ywa kuhuma ku Magidala. ");
INSERT INTO nww_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu pakammonite mama ywake na nhundwa ywake ywakanpalite muno bhayima pala, kakinng'ombela mama ywake, “Nhumbu, ayu apa ndo mwana ghwako.” ");
INSERT INTO nww_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Mbole kakinng'ombela yula nhundwa ywake, “Ghulole, ayu ndo mama ywako.” Kutandila lisaa lila yula nhundwa kakintola mama ywake Yesu na kutama naywo ukaya kwake. ");
INSERT INTO nww_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Mbole ya agho, Yesu pakimanya kukita kayomola milando yake hyoha, ili malembo ghabheghe gha hoto, kakilongela, “Nyumilwa nyota.” ");
INSERT INTO nww_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Apo pakibhegha kimbundi kiimemite difwai yiichakamukite, kya habhu bhakichwika libhoya mu kimbundi akyo, bhakibhika munndenge bhakinnyinulila mu nnomo ghwa Yesu. ");
INSERT INTO nww_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Mbole ya kupaha ayo siki, Yesu kakilongela, “Ghapela!” Mbole kakihokamiha mutwe ghwake na kayomoka. ");
INSERT INTO nww_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Likibhegha linjubha lya kutendekeha linjubha lya kupumulila, Akaayahudi bhakipala ng'obhe mibhili ihighale mulupingika linjubha lya kupumulila, kiyaha linjubha alyo lingabheghite linjubha likulu kwa Akaayahudi. Bhakinnyupa Pilato kakwilikihe ghatunyulwe maghulu gha bhala bhaabhambitwe mumipingika na mibhili yibhuhwe mumipingika. ");
INSERT INTO nww_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kya habhu machonda bhakighenda na kughatunyula maghulu gha yula ywakabhambitwe kalongohi ugheghela na Yesu na yula yungi ywa ubhili. ");
INSERT INTO nww_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Peni paanheghelelite Yesu, bhakibhona kukita kahwegha kala, kya habhu bhakintunyula ng'obhe maghulu ghake. ");
INSERT INTO nww_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Machonda yumu kakinhoma mulubhaho kwa nkoha, na kamu ghukipopoheka mwahi na machi. ");
INSERT INTO nww_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Naywo ywakabhonite nnando ghula kakilongela agha, na ghakaghabhonite ndo hoto, naywo kangumanya kukita kangulongela hoto ngati mwenga mmokole kuhyubhalila. ");
INSERT INTO nww_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nnando aghwo ghukitendekwa ngati matyeko gha Chapanga ghatwihilike, “Kahone nhupa ghwake hata ghumu ghuupala kutunyulwa.” ");
INSERT INTO nww_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Bhubho ghabhegha malembo ghangi ghangulongela, “Bhandu bhatahika bhannolekeha yula ywakanhomite.” ");
INSERT INTO nww_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Mbole ya agha, Yosefu nkolannima ywa ku Alimataya, kaking'endela kunyupa Pilato kughutola mmili ywa Yesu. Aywo Yosefu kakibhegha nhundwa ghwa Yesu, peni kya kihiho, kiyaha kakiayoghopa hilongohi bha Akaayahudi. Hino, Pilato kakintegheka kaghutole mmili, habhu Yosefu kakighenda, kakighuhuluha mmili ghwa Yesu na kughutola. ");
INSERT INTO nww_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Naywo Nikodemu ywene apo kalongohi kinng'endela yesu pakilo, kakihika kunu pakibhegha na nhanganganiko ghwa mahuta gha kunungila na ukobha ghwa ubani ghuutopite kilo salasini. ");
INSERT INTO nww_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Hino, abho bhandu abhili bhakighutola mmili ghwa Yesu, bhakighubhilingiha sanda papamu na lula luhumba, kubhukana na hitobhe hya Akaayahudi hya kukulila. ");
INSERT INTO nww_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Pala pakabhambitwe Yesu pakibhegha na kitogholo, na mukitogholo akyo likihongolwa lindogholo lya hyono mulitalabho likali kubhikwa mundu unyumba. ");
INSERT INTO nww_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Hino, kubhukana na kukibhegha matendekeho gha Akaayahudi gha linjubha lya kupumulila na kya bhula lindogholo lila likibha ugheghela, bhakibhika mmili ghwa Yesu mulindogholo alyo. ");
INSERT INTO nww_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Malabhila putiputi kukali na lubhindo linjubha lya ulongohi lya juma jumapili, Malia ywa kuhuma ku Magidala kakighenda ku lindogholo na kakilibhona lila libho libhingilighwa kala kuhuma mulindogholo. ");
INSERT INTO nww_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Hino kakighenda lubhilo mbaka kwa Simoni Petili na kwa yula nhundwa yungi, ywene Yesu kakimpala muno, na kakiaghombela, “Bhammuha Bambo kuhuma mulindogholo, na tungumanya ng'obhe kwammikite!” ");
INSERT INTO nww_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kamu Petili papamu na yula nhundwa yungi bhakighenda ku lindogholo. ");
INSERT INTO nww_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bhakighenda lubhilo bhoha abhili, Peni yula nhundwa yungi kakitugha kanongola kupitingana kwa Petili na kakilongolela kuhika kulindogholo. ");
INSERT INTO nww_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kakihokama na kulolekeha nkati kakibhona mapinda gha sanda, peni kakiyingila ng'obhe unyumba. ");
INSERT INTO nww_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Hino, Simoni Petili naywo kakihika, kakiyingila mu lindogholo. Kakighabhona ghala mapinda gha sanda ghabhegha, ");
INSERT INTO nww_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","na kila kilemba kiibheghite ku mutwe ghwa Yesu, kinyengwa maha patali ghweka chake. ");
INSERT INTO nww_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mbole ndo kakiyingila na yula nhundwa yungi ywakalongolite kuhika kulindogholo kakiyingila bhubho mulindogholo, kakibhona na kakihyubhalila. ");
INSERT INTO nww_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kiyaha mbaka lisaa alyo bhakibhegha akali kughang'amula ghala malembo kukita Yesu kangannoghitwe kahyuke. ");
INSERT INTO nww_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Mbole bhala ahundwa bhakibhuya ukaya kwabhe. ");
INSERT INTO nww_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Peni yula Malia kakiyima panji ya lindogholo. Kakibhegha kakali kangulila, Kakihokama na kulolekeha mulindogholo, ");
INSERT INTO nww_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","naywo kakiabhona mahoka abhili bha Chapanga bhaahwalite mapinda mahuhu gha mbuletee, bhakitama pala paaghughonjite mmili ghwa Yesu, yumu ku mutwe na yungi ku maghulu. ");
INSERT INTO nww_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bhombe bhakinkonya, “Nndala, kya bhuli ghungulila?” Ywombe kakiayanga, “Nungulila kiyaha bhantola Bambo ghwangu na nungukumanya ng'obhe kwaammikite!” ");
INSERT INTO nww_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Mbole ya kulongela agha kakikilibhuka unyuma na kakimmona Yesu kayima apo, peni ywombe kakimanya ng'obhe kukita kakibhegha Yesu. ");
INSERT INTO nww_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu kakinkonya, “Mama, kya bhuli ghungulila? Ghungumpalaha ghani?” Malia kakihwacha kukita nnolekeha ywa kitogholo, ndo kakinng'ombela, “Bambo, handa ghuntola ghwenga, ghunng'ombele kughummikite, nenga ndaaghenda kuntola.” ");
INSERT INTO nww_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu kakinkema, “Malia!” Naywo Malia kakinkilibhukila Yesu na kulongela naywo kwa Kibulania, “Laboni” fwambulo yake “Nhundwa.” ");
INSERT INTO nww_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu kakinng'ombela, “Ghukotoke kungamula kiyaha ngali kughenda kwa Tate. Peni ghughende kwa alongo bhangu ghukaaghombele nungughenda kwa Tate ywangu naywo ndo Tate ywa mwenga, na Chapanga ywangu naywo ndo Chapanga ywenu.” ");
INSERT INTO nww_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kya habhu Malia ywa ku Magidala kakighenda kuaghombela ahundwa bha Yesu kukita nummona Bambo na kukita kang'ombela hila hyabhaghombelitwe. ");
INSERT INTO nww_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Yikibhegha makimuhi ya linjubha alyo lya ulongohi lya juma, ahundwa bha Yesu bhakikongana papamu munyumba, na nlyango bhakiitata kiyaha bhakiayoghopa Akaayahudi. Ndo Yesu kakiabwitukila na kakiyima pakati yabhe na kakiaghombela, “Uhihimilo ghubheghe na mwenga.” ");
INSERT INTO nww_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mbole ya kulongela agha, kakialaha mabhoko ghake na lubhaho lwake. Na ahundwa bhake bhakiyelelwa muno paamonite Bambo. ");
INSERT INTO nww_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu kakiaghombela kangi, “Uhihimilo ghubheghe na mwenga. Handa bhula Tate pakanaghilite nenga, na nenga bhubho nungualaghila mwenga.” ");
INSERT INTO nww_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Naywo pakayomolite kulongela agha kakiapulilila uhuki na kuaghombela, “Nkingame Nhuki ywa Chapanga. ");
INSERT INTO nww_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Pamualekekeha bhandu ulemwa ghwabhe Chapanga naywo katabhalekekeha, na handa pamubhalekekeha ng'obhe, nabho Chapanga kataalekekeha ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Peni Tomasi, ywaankemite Pacha, yumu ywa bhala ahundwa bhake kumi na abhili kakibhegha ng'obhe pakahikiteghe Yesu. ");
INSERT INTO nww_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Hino bhala ahundwa bhangi bhakinng'ombela, “Tummona Bambo.” Peni Tomasi kakiaghombela, “Nenga ndahyubhalila ng'obhe kukita Yesu kangulama kangi pangi mbaka nummone numwene. Nungupala kubhona mabhanga gha msumali na nyingihe kikonji kyangu mu mabhoko ghake na kikonji kyangu kibheghe nkati ya mmili ghwake, pangi apwo ndo ndahyubhalila.” ");
INSERT INTO nww_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Mbole ya manjubha manane, ahundwa bha Yesu bhakikongana kangi papamu unyumba, naywo Tomasi kakibhegha papamu nabho. Pindulu Yesu kakihika kakiyima pakati yabhe na milyango yikitatwa na kakilongela, “Uhihimilo ghubhe na mwenga.” ");
INSERT INTO nww_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mbole kakinng'ombela Tomasi, “Ghubhike kikonji kyako apa na ghulolekehe mabhoko ghangu, ghugholohe kibhoko kyako na ghukibhike mu lubhaho lwangu, ili ghukotoke kubhegha na bhwaghalili, ngati ghuhyubhalile.” ");
INSERT INTO nww_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi kakinng'ombela “Bambo ywangu na Chapanga ywangu!” ");
INSERT INTO nww_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu kakinng'ombela Tomasi, “Ghunguhyubhalila kiyaha ghumona? Bhanonelwa bhala bhene bhanguhyubhalila kyanga kumona.” ");
INSERT INTO nww_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu kakitenda mihabho yingi mitangalo muulongolo ghwa ahundwa bhake, yangatyekwa mu kitabho aki. ");
INSERT INTO nww_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Peni agha ghatyekwa kwa ningo nhotole kuhyubhalila kukita Yesu ndo Kilisto Nkombohi, Mwana ywa Chapanga, na kwa kuhyubhalila mmeghe na ubhumi ghwa manjubha ghoha ghwanga uhiko. ");
INSERT INTO nww_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Mbole ya agho, Yesu kakiabwitukila kangi ahundwa bhake mu mbwegha ya lihibha Tibelia. Habhu ndo muyibheghite. ");
INSERT INTO nww_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni Petili na Tomasi ywakakemitwe Pacha, na Natanaeli nkolannima ghwa kitami kya Kana ya ku Galilaya, na bhana abhili bha Sebedayu na ahundwa bhake abhili bhakibhegha bhoha papamu. ");
INSERT INTO nww_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Petili kakiaghombela ayake, “Nenga nungughenda kughomeha homba.” Nabho bhakinng'ombela, “Twaalongohana papamu na ghwenga,” Hino bhakighenda bhakiyingila mu bhwato, peni pakilo bhakimokola ng'obhe kyohele. ");
INSERT INTO nww_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Malabhila putiputi, Yesu kakiyima mu mbwegha ya lihibha, peni ahundwa bhake bhakimmanya ng'obhe kukita kakibhegha Yesu. ");
INSERT INTO nww_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Mbole, Yesu kakiakonya, “Maaghanja bhangu ng'omeha ng'obhe hata na homba yumu?” Bhombe bhakinnyanga, “Kahone kilibhi.” ");
INSERT INTO nww_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesu kakiaghombela, “Muyitaghe njaho yenu ku nnilo ghwa bhwato ghwenu na mwenga maaghomeha homba.” Hino bhakitagha njaho peni hino bakihotola ng'obhe kukwakwaha njaho mu bhwato kubhukana na uyoloho ghwa homba. ");
INSERT INTO nww_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yula nhundwa ywakapalitwe na Yesu kakinng'ombela Petili, “Ayu ndo Bambo!” Naywo Simoni Petili pakayihwite kukita ndo Bambo, kakihwala lipinda lyake kiyaha kakibhegha uhula, na kakilitagha mumachi. ");
INSERT INTO nww_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Peni bhala ahundwa bhangi bakihika kwa bhwato kunu paakwakaha njaho yabhe yiimemiteghe homba, bhakibhegha ng'obhe kutali na luhingu ngati bhakibhegha utali ghwa mita hamsini kumi kuhuma ku lukingo. ");
INSERT INTO nww_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Hino paahikite kuluhingo bhakibhona mwoto ghwa makala ghukolehwa kala na unani mwake pakibhikwa homba na mangate. ");
INSERT INTO nww_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu kakiaghombela, “Mubhayeghe apa amoo homba bhamubhaghomehite hinu.” ");
INSERT INTO nww_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoni Petili kakiyingila mu bhwato na kakikwakaha yila njaho yiimemite homba mbaka kuluhingo, na mu njaho ahyo bhakibhegha homba mia na hamsini na tatu. Hata payibhele homba bhakimema muno, peni yila njaho yikikakuka ng'obhe. ");
INSERT INTO nww_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu kakiaghombela, “Nhiki tulyeghe.” Kahone na yumoo yumu ywabhe ywakayighite kunkonya, “Ghu ghani ghwenga?” Kiyaha bhakimanya kukita kakibhegha Bambo. ");
INSERT INTO nww_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu kakihika kakitola lila lingate, kakiapegha, kakitenda ubhwabhu abhu na kwa bhala homba. ");
INSERT INTO nww_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ayi yikibhegha pandatu Yesu kuabwitukila ahundwa bhake mbole ya kuhyuka. ");
INSERT INTO nww_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pabhayomolite kulyegha, Yesu kakinkonya Simoni Petili, “Bhuli, Simoni mwana ywa Yohane, ghwenga ghungumbala kupitingana abha?” Naywo kakinnyanga, “Ena Bambo, ghwenga ghungumanya kukita nungughupala.” Yesu kakinng'ombela, “Ghubhalele mene bhangu.” ");
INSERT INTO nww_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesu kakinkonya kangi paubhili, “Simoni mwana ywa Yohane, bhuli ghungumbala hoto?” Petili kakinnyanga, “Ena Bambo ghwenga ghungumanya kukita nungughupala.” Yesu kakinng'ombela, “Ghubhalele mene bhangu.” ");
INSERT INTO nww_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu kakinkonya kangi paundatu, “Simoni mwana ywa Yohane, ghungumbala hoto?” Apa Petili kakibhaghaya kiyaha kakinkonya paundatu, “Bhuli ghungumbala?” Petili kakinng'ombela, “Bambo ghwenga ghungumanya ghoha, ghungumanya kukita nungughupala!” Yesu kakinng'ombela, “Ghubhalele mene bhangu. ");
INSERT INTO nww_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kulyaghila nungughughombela, paghubheghite nhongolo ghukihyobhelela kuhwala lukungi na kughenda kwoheli kughukupalite, peni paghubhegha nng'ohi ghwagholoha mabhoko ghako na mundu yungi kataghuhwaliha na kughuyegha kwanga kughupala ghwenga.” ");
INSERT INTO nww_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu Kakilongela habhu, pakalaha bhula kiho kyoki mukipala kuyegha ukulu ghwa Chapanga. Mbole kakinng'ombela, “Ghundughile!” ");
INSERT INTO nww_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petili kakikilibhuka na kakimmona yula nhundwa yungi, ywakapalitwe na Yesu, ndo aywo ywakayeghamite mu kihubha kya Yesu pa mulyo ghwa makimuhi, kakinkonya Yesu, “Bambo ghani ywakapala kughukiluka?” ");
INSERT INTO nww_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ndo Petili kakimmona aywo nhundwa, kakinkonya Yesu, “Bambo, bhuli mundu ayu?” ");
INSERT INTO nww_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu kakinnyanga, “Handa pambala kalame mbaka pambala kubhuya, ayo yabhegha na ningo yoke kwa ghwenga? Gwenga ghundughile nenga!” ");
INSERT INTO nww_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Hino, nhalo aghu ghukitapakala mu nkati ya alongo kukita nhundwa aywo katahwegha ng'obhe. Peni Yesu kakilongela ng'obhe kukita katahwegha, ngati kakilongela, “Handa pambala kalame mbaka panonda kubhuya, ayi yabhegha na fwambulo yoki kwa ghwenga?” ");
INSERT INTO nww_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Aywo ndo yula nhundwa ywakalubhulilite agha, na ywakatyekite milando ayi, na tungumanya kukita uyimiho ghwake ndo ghwa hoto. ");
INSERT INTO nww_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yibhegha milando yingi mitangalo yakatendite Yesu, ghene handa yingatyekitwe hyoha yimu mbole ya yimu, nunguhwacha kukita nnima ghwoha ghungakwilite ng'obhe pakubhika hitabho hyene hingatyekitwe.");
INSERT INTO nww_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kwa ghwenga ghanja Tofili. Mukitabho kila kinyanditi kutyeka, nikityeka mihalo hyoha ya Yesu yakatenditi na kuhunda kutandila ulongohi ghwa lihengo lyake, ");
INSERT INTO nww_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mbaka linjubha lila lyakanyahulitwe kunane kwa Chapanga. Pakali na kutolwa kunane kwa Chapanga, kakialaghila kwa Nhuki ghwa Chapanga bhala andumitumi bhakaahaghulite. ");
INSERT INTO nww_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mbole ya kiho kyake kakililaha kwa bhombe na kuliyimiha patangalo kwa ahundwa bhake kukita mwene kangulama, kwa manjubha mbinda mabhoko ncheche, bhakinmmona na kakibhaghombela mihalo ya Ghubhutwa ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Linjubha limu pakakonganite papamu nabho kakibhakwilikiha habhu, “Nkotoke kubhuka pa Yelusalemu, ngati mulilindile lila lilumbo lyakalaghilite Tati, lyeni mukiyihwa kala panongela mihalo yake. ");
INSERT INTO nww_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohana kakiabatisa kwa machi, peni mbole ya manjubha gha mandina ghaapala kuhika, mwenga maabatiswa kwa Nhuki ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Linjubha limo, andumitumi pabhakonganite papamu, bhakinkonya Yesu, “Bhuli Bambo, hinu ndo manjubha gha kubhabhuyihila ghula ghubhutwa kwa Akaisilaeli?” ");
INSERT INTO nww_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu kakibhaghombela, “Agha gha mwenga ng'obhe kughamanya manjubha na nndaluko ghwa ngungwa, agha ghabhegha mu utabhala ghwa Tate ghwangu. ");
INSERT INTO nww_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Peni Nhuki ghwa Chapanga pakabhahikila mwenga, maakingama makakala na maabhegha mayimiho bha nenga mu Yelusalemu, nnima ghwoha ghwa ku Yudea na ghwa ku Samalia, na kuuhiko ghwa milima.” ");
INSERT INTO nww_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pakayomolite kulongela agha, bhoha kunu pabhalolekeha kunani kwa Chapanga, Yesu kakitolwa kunane kwa Chapanga na lihundi likin'gubika na kakibhonekana kangi ng'obhe. ");
INSERT INTO nww_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Paabheghite akali bhanguhulutula meho kulolekeha kunane kubhwelu pakaghenda, kamu bhandu abhili bhaahwalite mapinda ghambuletee bhakiyima pabhwegha yabhe ");
INSERT INTO nww_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","na bhakilongela, “Mwenga ma bhandu bha ku Galilaya, bhuli munguyima apa kunu pan'nolekeha kunane ku bhwelo? Aywo Yesu ywakatolitwe kubhuka kwa mwenga kughenda kunane kwa Chapanga kaabhuya kangi ubhwabhu abhu handa pamumonite pakatolwa kughenda kunane kwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mbole andumitumi bhakibhuya ku Yelusalemu kuhuma kukitumbi kya Miseituni kiibheghite utali ghwa kilomita yimo kuhuma ku kitami kya Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pabhahikite ku mjini Yelusalemu bhakighenda ku kyumba kya kuligholofa kwene bhakibha bhangutama. Nabho bhakibha Petili na Yohana na Yakwobu na Andelea. Filipo na Tomasi na Batolomayo na Matayo mwana ghwa Alufayo na Simoni Zaloti, na Yuda mwana ghwa Yakwobu. ");
INSERT INTO nww_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Abho bhoha bhakighendelela kukwemukana papamu kuyupa. Papamu nabho bhakibhegha amoo bha adala, na Maliamu ma ghwake Yesu na alongo bhake Yesu. ");
INSERT INTO nww_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Linjubha limo mu manjubha agho, Petili kakiyima pakati ya bhandu bhaanhyubhalilite Kilisito bhoha bhaakwemukite na mmalango ghwake bhakibha bhandu mbinda mabhoko kumi na mabhili, ");
INSERT INTO nww_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Petili kakilongela, “Maalongo bhangu, yikibha mbaka matyeko ghanakung'anyima ghatengeleheke. Ghala ghene Nhuki ghwa Chapanga ghakaghalondolite kukindila kwa Daudi kwa kya mihalo ya Yuda pakabhalongohite bhala bhaankamulite Yesu. ");
INSERT INTO nww_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda kakibha nnyetu, kiyaha mwene kakihaghulighwa na Yesu kalilunge mulihengo lyetu.” ");
INSERT INTO nww_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Hinu Yuda kakihemela nng'unda kwa ngalabha hyakamokoliti kwa uhakata, kakighwegha pahi makukama akwo ku nng'unda kakibwaluka na matumbu ghake ghakikwepuka panji. ");
INSERT INTO nww_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bhandu bhoha bha Ku yelusalemu bhakiyihwa nhalu aghwo, na habhu apwo bhakipakema “Akelidama” fwambulo yake ndo “Nng'unda ghwa Mwahi.” ");
INSERT INTO nww_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Petili kangi kakilongela, “Handa payityekwitwe mukitabho kya Sabuli; ‘Kukaya kwake pabhe mang'obha, kahone mundu ghwa kutama amwo.’ Kangi yityekwa ‘Mundu yungi kayitole ng'ebhu yake ya utendehi.’ ” ");
INSERT INTO nww_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Kya habhu yingutunogha tunhaghule mundu yungi mu nkati ya bhala bhaabheghite papamu na twenga patubheghiti papamu na Bambo Yesu. ");
INSERT INTO nww_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Aywo yingunkwiliha kabhe mundu ywakabheghite na twenga kutandila Yohana pakabheghite mu kubatisa mbaka linjubha lyakatolitwe Yesu kuhuma kwa twenga kughenda kunani kwa Chapanga. Kiyaha aywo yingunnogha kalilunge na twenga ngati kabhe nnyimiho ghwa uhyuko ghwa Yesu.” ");
INSERT INTO nww_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Hino, bhakighalinga mahina gha bhandu abhili, Yosefu ywakakemitweghe Balisaba ebu bhubho kakimayikwa Yusito na yungi Matia. ");
INSERT INTO nww_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Mbole bhakinnyupa Chapanga, “Bambo, ghwenga ghuyimanya myoyo ya bhandu bhoha. Hinu ghutulahe mu abha abhili ywoki ghunhaghulite, ");
INSERT INTO nww_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ngati kakatole ng'ebhu ya utendehi ghwa undumitumi ghwakaghulekite Yuda ngati kaghende mu ng'ebhu yiyinnoghite.” ");
INSERT INTO nww_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mbole bhakiatendela usimbi, na kakihaghulwa Matia, naywo kakiyonjokehwa mu bhala Andumitumi mbinda mabhoko yimo na yumo. ");
INSERT INTO nww_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Palihikite linjubha lya kikubhukubhu kya Pendekositi, bhaanhyubhalilite Yesu bhoha bhakikwemukana papamu. ");
INSERT INTO nww_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Pindulu lilobhe likiyuhwanika kuhuma kunane kubhwelo, lilobhe liibheghite handa lya liyegha lya likusi, lukiikwiniha mula mu nyumba hyoha yabhatamite. ");
INSERT INTO nww_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Mbole hikiabwitukila hilibhi handa ndetelehe ya mwoto na hikipwilinganika na kutula unane mwa kila mundu. ");
INSERT INTO nww_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Bhoha bhakimemekehwa Nhuki ghwa Chapanga na bhakiyanda kuyobhela mu nongelo nhanganganiko handa Nhuki ghwa Chapanga pakabhahotolite. ");
INSERT INTO nww_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na akwo ku Yelusalemu bhakibha Akaayahudi bhandu bhaantundamilite na kunnyitikila Chapanga, bhahumite kumilima hyoha ya munnima. ");
INSERT INTO nww_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pabhayuhwite lilobhe alyo, lumati lukulu lwa bhandu lukikwemukana papamu. Bhandu bhoha bhakibhughanikwa kiyaha kila yumo ywabhe kakiayuhwa pabhalongela mu nongelo yake yakabhelekitwi nayo. ");
INSERT INTO nww_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bhakibhughanikwa na kukangacha paakilongela, “Abha bhandu bhatubhayuhwa pabhalongela habhu ndo akolannima bha ku Galilaya chepa? ");
INSERT INTO nww_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Yibha bhuli twabhoha tungubhayihwa pabhalongela kila mundu kwa nongelo yake yakabhelekitwe nalyo? ");
INSERT INTO nww_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Twaamoo bhetu tuhuma ku Apati na ku Amedi na ku Aelamu; bhangi akolannima kuhuma ku Mesopotamia na ku Yudea na ku Kapodokia na ku Ponto na ku Asia, ");
INSERT INTO nww_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ku Filigia na ku Pamfilia na ku Misili na mu mbande ya ku Libiya ugheghela na ku Kilene na amoo bhangi ahenja kuhuma ku Loma. ");
INSERT INTO nww_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Akaayahudi na bhandu bhangi bhaalilungite na dini ya Akaayahudi, bhangi ahuma ku Kelete na ku Alabia. Twabhoha tunguayihwa bhandu abha paalongela mihalo mikulu ya Chapanga kwa nongelo yetu twabhene!” ");
INSERT INTO nww_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bhoha bhakibhughanikwa na kubhaghaya kunu paakwonyana, milando ayi fwambulo yake niki? ");
INSERT INTO nww_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Peni bhangi bhakibhayuyuha paakilongela, “Bhandu abha alobhela ughimbi!” ");
INSERT INTO nww_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Peni Petili kakiyima papamu na bhala andumitumi mbinda mabhoko yimo na yumo na kakiyanda kualandamiha bhandu kwa lilobhe likulu pakiaghombela, “Maalongo bhangu Akaayahudi na mabhoha mwenga munntama apa pa Yelusalemu, mughayihwe maha malagho ghambala kulongela. ");
INSERT INTO nww_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kulyaghila bhandu abha bhalobhelana ng'obhe handa pamubhahwachila, kiyaha yibha malabhila muno ya saa ndatu. ");
INSERT INTO nww_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ngati nnando aghu ndo ghula ghuulondolitwe na mbuyi ghwa Chapanga ywakakemitwe Yoheli, pakilongela.” ");
INSERT INTO nww_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Bambo kalongela, ‘Mu manjubha gha uhiko, Ndabhapegha anabhandu bhoha Nhuki ghwangu. Bhana bhenu alume na ahinja bhaalondola mihalo yangu, Ahongolo bhenu bhaabhona mabhono, Aghohi bhenu bhaalota maloto. ");
INSERT INTO nww_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Hata andumindumi bhangu adala kwa alume, Ndabhapegha Nhuki ghwangu manjubha agho, nabho bhaalandamiha lilagho lyangu. ");
INSERT INTO nww_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ndatenda mihabho kunane kubhwelo na mang'eha pannima, kwaabhegha mwahi na mwoto na lyohi linakutopa. ");
INSERT INTO nww_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Luchubha lyayingihwa lubhindu, na mwehi ghwabhegha nkele handa mwahi yikali na kuhika linjubha likulu lya ukulu ghwa Bambo. ");
INSERT INTO nww_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Na apwo, ywoheli ywapala kuyupa kwa lihina lya Bambo, katalopoleghwa.’ ” ");
INSERT INTO nww_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Petili kakighendelela kulongela, “Mwenga ma bhandu bha ku Isilaeli nnyihwe malagho agha mahamaha! Chapanga kakibhalangiha mwega kukita kangutenda lihengo maha kwa kukindila Yesu ghwa ku Nasaleti. Mabhene mungumanya kukita kwa kukindila Yesu kakitenda naho ndangalo kwa mwenga. ");
INSERT INTO nww_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kubhukana na unyakatiho ghwake mwene Chapanga kakilamula kwa kumanya kukita Yesu kangapukilitwe mumabhoko ghenu, mwenga mukinkoma kwa kualekela bhandu ahakata bhankome bhammambe. ");
INSERT INTO nww_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Peni Chapanga kakinhyuha Yesu kuhuma kwa bhaahweghite kakimmuha mu ubhabho ghwa ntumba, kiyaha yingahotolitwi ng'obhe kukamulighwe na makakala gha kiho. ");
INSERT INTO nww_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kiyaha Daudi kakilongela kwa kya Yesu.” “ ‘Nikimmona Bambo muulongolo ghwangu manjubha ghoha, Kiyaha kabhegha mukibhoko kyangu kya nnilo, ndaghaluka ng'obhe. ");
INSERT INTO nww_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kya habhu, mwoyo ghwangu ghunguyelelwa, na ninguyelelwa kwa ngulu yangu. Na mmili ghwangu ghwatama mu uhyubhalilo. ");
INSERT INTO nww_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kiyaha ghwaghuleka ng'obhe uhuki ghwangu kumambe, ebu ghwannekeha ng'obhe nng'anyimo ghwakwo kabhole kulindogholo. ");
INSERT INTO nww_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ghunangiha ndyangilo ya kulama, Na ghwandenda nyelelwe paamegha papamu na ghwenga!’ ” ");
INSERT INTO nww_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Maalongo bhangu Makaaisilaeli, nungupala nibhaghombele hoto kukita tati ghwetu Daudi kakihwegha, na kukulilwa na lindogholo lyake libhegha apa mbaka lelo. ");
INSERT INTO nww_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Peni kiyaha Daudi kakibha Mbuye ghwa Chapanga na kakimanya kukita Chapanga kakinlagha kwa kilapo kukita katantenda yumoo ywa ubheleko ghwake pakiteho kyake kya utabhala. ");
INSERT INTO nww_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daudi kakibhona kya kutali mihalo yaghenda kutenda Chapanga, na habhu kakikambuka ya kya uhyuko ghwa kilisto. ‘Kukita kaalekwa ng'obhe kumambe, na mmili gwake ghwabhola ng'obhe kulindogholo.’ ” ");
INSERT INTO nww_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Hinu, Chapanga kukinhyuha Yesu na twabhoha twenga ndo mayimiho bha ndendelo ayi. ");
INSERT INTO nww_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mbole ya Tate Chapanga kunkweha ngati katabhale papamu naywo, kakikingama Nhuki ghwa Chapanga kubhuka kwa Tate, katugheghela Nhuki ghwa Chapanga ywene Chapanga kakilagha ndo agha ghamughabhona na kughayihwa. ");
INSERT INTO nww_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kiyaha Daudi kakiyinulighwa ng'obhe kughenda kunane kwa Chapanga, peni mwene kakilongela.” “ ‘Bambo kakinng'ombela Bambo ghwangu. Ghutame mumbande yangu ya nnilo, ");
INSERT INTO nww_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ndabhabhika amyanja bhakwo bhalibhatwe pahi ya maghulu ghakwo.’ ” ");
INSERT INTO nww_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Petili kakighendelela kulongela “Hinu bhandu bhoha bha ku Isilaeli amanye nhalo aghu kukita. Chapanga kanntenda aywo Yesu, ywa yunbamanditi, kabhe Bambo na Kilisito Nkombohi.” ");
INSERT INTO nww_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Hinu bhandu paayihwite mihalo ayi, bhakihomwa mumyoyo yabhe, bhakinkonya Petili na andumitumi bhangi, “Maalongo bhetu, hinu tutende niki?” ");
INSERT INTO nww_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petili kakiayanga, “Kila mundu kalipetule na kaghuleke ulemwa na kabatiswe kwa lihina lya Yesu kilisto, ngati mmokole ulekekeho ghwa ulemwa ghwenu, na mwenga maakamuhwa lilumbo lya Nhuki ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kiyaha naghilo ayi yikibha ya kya mwenga na bhana bhenu, na bhandu bhoha bhaatama kutali na mundu ywoheli ywakakemwa na Bambo Chapanga ghwetu.” ");
INSERT INTO nww_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kwa nganikiho ndangalo Petili kakiakanikiha pakilongela, “Mulilopohe na kibheleko aki kihakata!” ");
INSERT INTO nww_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Linjubha lila bhandu atangalo bhakighayitikila malagho ghake na bhakibatiswa. Bhandu handa elufu ndatu bhakiyonjokeheka mulumati lula luunhyubhaliliti Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Abha bhoha bhakighendelela kulihunda kwa andumitumi bha Yesu, kutama papamu kiulongo, kulyegha hilyo papamu na kunnyupa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Andumitumi bhakitenda mihabho na naho ndangalo mbaka bhandu bhoha bhakikangacha muno na kunhokamila Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bhaanhyubhaliliti Chapanga bhoha bhakighendelela kutama papamu, na hilibhi hyabhe bhakitangatilana. ");
INSERT INTO nww_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bhakihemela hilibhi hyabhe na utopelo ghwabhe na bhakinng'abhila kila mundu handa pakapelelitwe. ");
INSERT INTO nww_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Bhakighendelela kukongana papamu manjubha ghoha mu Kitutubhi kya Chapanga. Peni mu lisaa lya kulyegha hilyo, bhakikongana mu hitutubhi hyabhe na bhakililunga mu hilyo ahyo kwa uyelelo na mwoyo ghwa nga kingaka, ");
INSERT INTO nww_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","paakintika Chapanga, na kuanogheha bhandu bhoha. Kila linjubha Bambo kakiayonjokehela bhandu bha alopohitwe. ");
INSERT INTO nww_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Linjubha limo pasaa tisa ya pamuhi, Petili na Yohani bhakighenda ku Kitutubhi kya Chapanga, lisaa alyo likibha ndo lisaa lya kuntundamila Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Na akwo ku Kitutubhi kya Chapanga pakibhegha mundu yumo ywakabheghite ngwabhengwabhe kutandila kubhelekwa kwake. Kila linjubha kakigheghwa na kubhikwa munyumba ya Chapanga panlyango ghuukemitwe “Nlyango ghwa maha,” ghwa Kitutubhi kya Chapanga manjubha ghoha ngati kakapembelehe kuyupe utango kwa bhandu bhaayingiliti. ");
INSERT INTO nww_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Mundu ayu pakaabhonite Petili na Yohana paaheghelela kuyingila mu Kitutubhi kya Chapanga kakiayupa bhampeghe kilibhi kyohele kila. ");
INSERT INTO nww_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Bhene bhakinhulutulila mehu, mbole Petili kakinng'ombela, “Ghutulole.” ");
INSERT INTO nww_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Yula mundu kakialolekeha kunu pakihyubhalila pangi kaakingama kilibhi kyohele kuhuma kwa bhombe. ");
INSERT INTO nww_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Habhu, Petili kakinng'ombela, “Megha ng'obhe na madini gha ngalabha, chepa nga maganga gha mahabha, peni kimmeghite nakyo ndaghupegha. Kwa lihina lya Yesu Kilisito ghwa ku Nasaleti ghuyime na ghutyange!” ");
INSERT INTO nww_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Mbole Petili kakinkamula kwa kibhoko kyake kya nnilo na kakinnyinula, kamu hihundo hya maghulu ghake hikikangamala. ");
INSERT INTO nww_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Kakihumbahumba na Kakiyima kakiyanda kutyanga. Kakiyingila mu Kitutubhi kya Chapanga papamu na Petili na Yohana pakityanga kunu pakihumba na kunntika Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bhandu bhoha bhaabheghiti apwo bhakimmona paakityanga na kunntika Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Bhandu bhaking'amula kukita ndo yula ywakatamiteghe panji ya nlyango ghukemitweghe “Nlyango ghwa maha” ghwa Nyumba ya Chapanga, pakayupa utango, nabho bhakikangacha kwa ghala ghaanbwitukiliti. ");
INSERT INTO nww_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Yula mundu ngwabhengwabhe ywakalamihitwe pakabheghite mu kulongohana na Petili na Yohana, bhandu bhoha bhakikangacha munu, bhakiabhutukila mbaka ku ludamu lwa Solomoni. ");
INSERT INTO nww_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Hino Petili pakaabhonite bhandu abho akwemukana kakiaghombela, “Mwenga Makaaisilaeli kiyaha niki mungughukangacha nhalo aghu? Bhuli mungutuhulutulila meho kwa ngangacho handa bhula twenga tunntenda mundu ayu katyange kwa makakala na umaha ghwetu? ");
INSERT INTO nww_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Chapanga ghwa tate bhetu Abulahamu na Isaka na Yakwobu, kankwiha Yesu ndumitumi ghwake peni mwenga mukinkamula ngati kakwomwe na mukinlema muulongolo ghwa Pilato hata handa Pilato kakipala kannekekeha. ");
INSERT INTO nww_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kakibha nng'anyimo na ywa maha, peni mwenga mukinnema na mukinpala mundu yungi ywakabheghite nhakata kalekekehwe. ");
INSERT INTO nww_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mukinkoma ywaabheghite kihina kya ubhumi peni Chapanga kakinhyuha kuhuma kwa ahweghiti, na twenga ndo ayimiho ghwa mihalo ayi. ");
INSERT INTO nww_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Lihina lya Yesu na uhyubhalilo mu lihina alyo ndo himpegha makakala mundu ayu yumummona na kunng'amula. Uhyubhalilo ghwake kwa Yesu ndo ghuunnamihite kyanalumu mundu ayu handa pamummona mabhoha.” ");
INSERT INTO nww_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Hinu maalongo bhangu, nungumanya kukita mukitenda agho kya nga kumanya handa paatendite hilongohi bhenu. ");
INSERT INTO nww_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Peni Chapanga kahotola kila kyakalondoliti kwa ngulu ya ambuye bhake bhoha, kukita yingwiliha Kilisito ghwake kabamandwe. ");
INSERT INTO nww_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Hinu, mulipetule na mummuyile Chapanga, ngati mwene kaabhuhile ulemwa ghwenu. ");
INSERT INTO nww_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nntende naha ngati Chapanga kaapeghe nndaluko ghwa chekwa mu mwoyo ghwenu na kuagheghela Kilisito ywakanhaghulilite mwenga ywene ndo Yesu. ");
INSERT INTO nww_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ywombe yingwiliha kahighale akwo kunani kwa Chapanga mbaka paghuhika nndaluko ghwa kutengelekehwa hilibhi hyoha, handa pakalongiliti Chapanga kwa ngulu ya Ambuye bhake bhoha kutandila makachu. ");
INSERT INTO nww_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kiyaha Musa kakilongela, ‘Bambo Chapanga ghwenu kaabhapegha mwenga mbuyi kuhuma mu nkati yenu handa pakang'eghite nenga, yibhakwiliha kunnyitikila aywo kwa kila nnando ghwakabhaghombela. ");
INSERT INTO nww_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mundu ywohele yula ywakalema kunnyitikila mbuye aywo, kaabhikwa pambwegha na bhandu bha Chapanga na kaakanjaghanwa.’ ");
INSERT INTO nww_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Hilahila Mambuye bhoha bha Chapanga kutandila kwa Samweli na bhala bha mbole yake, bhakilondola mihalo yiitendeka mu manjubha agha. ");
INSERT INTO nww_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Chapanga kakiapegha mwenga naghilo kukindila ambuye bhake kwa kya mwenga na mwenga mungulilunga na lila ninganilo lyakatendite Chapanga na hukulu bhenu, handa pakannongilite Abulahamu, ‘Kukindila ubheleko ghwakwo aghanja bhoha bha nnima bhaanonelwa.’ ");
INSERT INTO nww_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Chapanga kakinhyuha Yesu nndumitumi ghwake, kakinlaghila kwa mwenga huti, ngati kabhayeghele nonelo kwa kuatenda kila yomo ywenu kalekane nalumu na uhokelo ghwake.” ");
INSERT INTO nww_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petili na Yohana paabheghite akali bhangualandamiha bhandu, amoo bha mandundame akulu na kilongohi ghwa machonda ghwa kukingikiha Nyumba ya Chapanga na Akaasadukayo bhakihika. ");
INSERT INTO nww_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bhakikalala muno, kiyaha andumitumi abho bhakibha bhangualandandamiha bhandu kukita Yesu kakihyuka, nnando ghuulangihite kukita bhaahweghite bhaahyuka. ");
INSERT INTO nww_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Hino bhakiakamula Petili na Yohana bhakiabhika mukibhopo mbaka kilabho yake kiyaha yikibhegha makimuhi. ");
INSERT INTO nww_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Peni bhandu atangalo bhaayuhwite nhalo ghuulandamihitwe na Petili na Yohana bhakihyubhalila, na mmalango ghwabhe ghukibha handa bhandu elufu nhano. ");
INSERT INTO nww_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kilabho yake hilongohi bha Akaayahudi, aghohi na ahunda bhamalaghilo bhakikwemukana papamu akwo ku Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Mulibalasa alyo pakibhegha na Ndundame Nkulu Anasi na Kayafa na Yohane na Alekisanda na bhangi bhaabheghite mu ubheleko ghwa ndundame nkulu. ");
INSERT INTO nww_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Paabhayimihiti Petili na Yohani mu ulongolo ghwabhe, bhakiakwonya, “Mwenga mungutenda nnando aghu kwa utabhala ghwa ghani, na kwa lihina lya ghani?” ");
INSERT INTO nww_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Apwo Petili kunu pakilongohwa na Nhuki ghwa Chapanga kakiaghombela, “Mwenga hilongohi na aghohi bha bhandu, ");
INSERT INTO nww_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","handa lelo taakwonywa kya nnando ghwa maha ghwakatendelitwe yula ngwabhengwabhe na bhula pakalamihitwe, ");
INSERT INTO nww_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","hino mwenga na bhandu bhoha bha ku Isilaeli mungunoghwa kumanya kukita, mundu ayu kanguyima muulongolo ghwenu lelo ywa maha telatela, kwa makakala gha lihina lyake Yesu ghwa ku Nasaleti ywene mwenga mukimmamba mulupingika, peni Chapanga kakinhyuha kuhuma mu bhaahweghite. ");
INSERT INTO nww_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ayu Yesu ndo matyeko mang'anyimo ghangulongela. ‘Lila liganga limulilemite mwenga maatendehi, hino libhegha liganga likulu lya lukingi lya kitamiko kya kuchengela.’ ");
INSERT INTO nww_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ulopohi ghungumokoleghwa kwa lihina lya Yesu, kiyaha kahone lihina lingi munnima lihikamuhitwe kwa anabhandu lyene twahotola kulopoleghwa kwa lyene.” ");
INSERT INTO nww_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bhala hilongohi na aghohi bha libalasa paaghubhonite ukangamalo ghwa Petili na Yohana na bhakiamanya kukita ndo bhandu bhaasomite ng'obhe, bhakikangacha muno na bhaking'amula kukita bhakibha papamu na Yesu. ");
INSERT INTO nww_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Peni paammonite yula mundu ywakalamihitwi kayima papamu na Petili na Yohana bhakilepelwa kulongela kyohele kila. ");
INSERT INTO nww_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Hino bhombe bhakiakwilikiha bhaghende panji ya libalasa likulu, na bhene bhakihighala unyumba paakighombana bhene kwa bhene. ");
INSERT INTO nww_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Bhakikonyana, “Tubhatende niki bhandu abha? Kila mundu mu Yelusalemu kangumanya nhabho aghu ghwa ngangacho ghutendeka, na twenga twahotola ng'obhe kughukana nnando aghu. ");
INSERT INTO nww_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Peni ngati kukanikiha nnando aghu ghukotoke kukwila mu bhandu, inogha tubhakinye bhandu abha akotoke kuyobhela kangi kwa mundu ywoheli kwa lihina lya Yesu.” ");
INSERT INTO nww_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Mbole bhakiakema kangi munyumba na kuakwilikiha akotoke kulongela na kuhunda kwa lihina alyo lya Yesu. ");
INSERT INTO nww_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Peni Petili na Yohana bhakiayanga, “Nlamule mwenga mabhene handa yibha tela muulongolo gwa Chapanga, kuayitikila mwenga kihyengo kya Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kiyaha twenga twaleka ng'obhe kulongela ghala ghatughabhonite na kughayihwa.” ");
INSERT INTO nww_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Hino libalasa likiakinya kwa ulakalo, mbole bhakialekekeha bhabhuke, bhakilepelwa kuatosa, kiyaha bhandu bhoha akibhegha bhanguntika Chapanga kwa kila kiibwitukite. ");
INSERT INTO nww_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yula mundu ywakalamihitwe kakibha na ngungwa kupitingana mbinda mabhoko ncheche. ");
INSERT INTO nww_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kamu petili na Yohana paalekekehitwe, bhakibhuya kwa ayabhe na kuaghombela mihalo hyoha yaaghombilitwe na andundame akulu na aghohi. ");
INSERT INTO nww_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nabho bhaanhyubhalilite Chapanga paayuhwite agho, bhakililunga papamo na kunnyupa Chapanga paakilongela “Bambo, ghwenga ghubhumba kunani na nnima na mahibha na hilibhi hyoha hibheghite! ");
INSERT INTO nww_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ghwenga ghukintenda nndumitimi ghwakwo, tate ghwetu Daudi kalongele kwa makakala gha Nhuki ghwa Chapanga, ‘Bhuli bhandu bhaabheghite Akaayahudi ng'obhe bhanguyaghabhala, Na makabila gha bhandu ghanguhwacha mihalo ya uhokelo? ");
INSERT INTO nww_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Abhatwa bha nnima bhalibhika kala, na atabhala akongana papamo, kunpingika Bambo na Kilisito ywakahaghulitwe na Chapanga.’ ");
INSERT INTO nww_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kiyaha kulyaghila Helode na Ponto Pilalato na bhandu bha bhaabheghite ng'obhe Akaayahudi na Akaasilaeli, bhakikwemukana bahapa apa pa kitami aki kya Yelusalemu kunpingikiha mwana ghwakwo Yesu, Nndumitumi Nng'anyimo, Kilisito ghughunhaghulite. ");
INSERT INTO nww_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kulyaghila bhene bhakikongana ngati bhatende milando yila yighuyipalite na kuyipanga kutandila makachu kwa makakala ghakwo handa paghupalite ghwenga. ");
INSERT INTO nww_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Hinu Bambo, ghulolekehe hilindimuho hyabhe, na ghututange twenga twandumitumi bhakwo kulilandamiha lilagho lyakwo kyanga kuyoghopa. ");
INSERT INTO nww_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Gwenga ghulangihe makakala ghakwo gha kualamiha bhadu, na ghututange ngati tutende mihabho nhanganganiko kwa lihina lya Yesu Nndumitumi ghwakwo nng'anyimo.” ");
INSERT INTO nww_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Paayomolite kunnyupa Chapanga, pala paakwonganite pakitingihika, na bhoha bhakihikilwa na Nhuki ghwa Chapanga, bhakiyanda kulandamiha lilagho lya Chapanga kyanga lyogha. ");
INSERT INTO nww_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Lumati lwoha lwa bhaanhyubhalilite Yesu lukibha na mwoyo ghumu na mahwacho ghamo. Hangi kahone mundu yumu ywakalongeliti k kyakabheghite nakyo ndo kyake mwene ghweka, peni bhakighabhana hilibhi hyoha hyaabheghiti naywo. ");
INSERT INTO nww_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Andumitumi bhakighendelela kuaghombela kwa ukangamalo nkulu bhandu bhangi kuhyuka kwa Bambo Yesu na Chapanga kakianemela muno bhoha. ");
INSERT INTO nww_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kahone mundu ywohele ywakapelelitwi na kilibhi, kiyaha bhaabheghiti na mighunda ebu hitutubhi bhakiihemela bhakighegha ngalabha hyoha hyaahemenganiti, ");
INSERT INTO nww_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","bhakihikamuha ngalabha ahyo kwa andumitumi, na ahyo ngalabha hikigabhanihwa kwa kila mundu kubhukana na kyakapalite mwene. ");
INSERT INTO nww_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Pakibhegha mundu yumu Nlawi lihina lyake Yosefu, mmbhelekwa ghwa ku Kipulo yweni andumindumi bhakinkema Balinaba, fwambulo yake, “Mundu ghwa kutwihilikiha mwoyo,” ");
INSERT INTO nww_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Hila hila mwene kakibhegha na nng'unda ghwake, kakihemela nng'unda aghwo, na kakighegha ngalabha na kuakamuha andumitumi. ");
INSERT INTO nww_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pakibha na mundu yumu lihina lyake Anania na nhumbu ghwake Safila bhaahemilite nng'unda ghwabhe. ");
INSERT INTO nww_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Peni Anania na Nhumbu gwake bhakilingana malobhe kuhiha kimati kya ngalabha na kughegha ngalabha yingi yiihighalite kwa andumitumi. ");
INSERT INTO nww_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Hinu Petili kakinkonya, “Anania, kiyaha niki ghunneka nchipila kaghuyingile mwoyo gwakwo na kunkuluha Nhuki ghwa Chapanga, na ghuhiha himoo hya ngalabha hiumokoliti kwa kuhemengana nng'unda? ");
INSERT INTO nww_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Bhuli, ikali kuhemela aghwo nng'unda ghukibha ghwakwo ng'obhe? Na mbole ya kuhemela, ngalabha hiumokoliti hikibha hyakwo ng'obhe? Kya bhuli hinu ghuhwacha lukila alu mu mwoyo ghwakwo kutenda nnando handa aghu? Ghunkuluha mundu ng'obhe, ngati Chapanga!” ");
INSERT INTO nww_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pala pala Anania pakayuhwite malagho agha kakighwegha pahi na kuhwegha. Bhandu bhoha bhaayuhwite nnando aghu ghuubwitukiliti bhakiyingilwa lyogha likulu. ");
INSERT INTO nww_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ahongolo bhakihika bhakighugubika mmili ghwake kwa nnekano, bhakighughegha panji na bhakinkulila. ");
INSERT INTO nww_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mbole ya handa masaa mandatu, nhumbu ghwake Anania kakihika, na kyanga kughamanya ghaghabwitukite. ");
INSERT INTO nww_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petili kakinkonya yula nhumbu, “Ghung'ombele mukihemela nng'unda kwa ngalabha ahi ghweka?” Mwene kakiyanga, “Ena ihyahi ayi.” ");
INSERT INTO nww_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ndo Petili kakinkonya yula nhumbu, “Yibha bhuli nningane na nnume ghwakwo kunkuluha Nhuki ghwa Bambo? Ghulole, ahongolo bhaankulilite nnume ghwakwo hinu abhegha pa nlyango na bhaaghutola na kukupiha panji na gwenga hilahila.” ");
INSERT INTO nww_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kamu Safila kakighwegha pahi ya maghulu gha Petili na kuhwegha. Bhala ahongolo paayingilite munyumba bhakimmona kahwegha kala, bhakinnyahula na bhakighenda kunkulila pambwegha ya lindogholo lya nnume ghwake. ");
INSERT INTO nww_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Lyogha likulu likiitula ngwemuko hyoha ya bhaanhyubhalilite Chapanga na bhandu bhoha bhaayihwite agha. ");
INSERT INTO nww_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Andumitumi bhakitenda naho na mihabho mitangala nkati ya bhandu. Nabho bhala bhoha bhaanhyubhalilite Yesu bhakikongana papamu pa ludamu lwa Solomoni ");
INSERT INTO nww_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Bhandu bhanga kunhyubhalila Yesu bhakiatika munu. Hata naha, kahone mungu ywakayighite kuatughila, kubhukana na kuyoghopa. ");
INSERT INTO nww_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Hata habhu bhandu bhaanhyubhalilite Bambo, bhakiyonjokeheka muno na muno alume kwa adala. ");
INSERT INTO nww_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kubhukana na ghala ghaaghatendite andumitumi bhandu bhakiaghegha atamwa mu mbwegha ya njila na kuaghonjeha mu hindanda na mu mikahe, ngati Petili pakityanga kihighi kyake kibhahikile. ");
INSERT INTO nww_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Bhandu atangalo bhakihika kuhuma ku milima ya mumbwegha ya Yelusalemu, paakiaghegha atamwa bhabhe na bhandu bhaabambanditwe na mandilu, na bhoha bhakilama. ");
INSERT INTO nww_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Mbole Ndundame Nkulu na ayake bhoha bhaabheghite papamu naywo bhene bhaabheghite mukimati kya Masadukayo, bhakiabhonela tama andumitumi. ");
INSERT INTO nww_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Hinu, bhakiakamula andumitumi na kuahwidika mu kibhopo. ");
INSERT INTO nww_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Peni pakilo ndumitumi ghwa kunani ghwa Chapanga kakihika na kuhughula milyango mikulu ya kibhopo kakiapiha panji bhala andumitumi na kakiaghombela, ");
INSERT INTO nww_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Nng'ende mukayime ku libalasa lya Nyumba ya Chapanga na mukaaghombele bhandu malagho ghoha gha ulami aghu.” ");
INSERT INTO nww_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ndo andumitumi bhakighenda ku Nymba ya Chapanga malabhila putiputi na bhakiyanda kuahunda bhandu. Mbole Ndundame Nkulu na ayake paahikite, kakilikema libalasa lyoha na aghohi bha Akaayahudi, bhakialaghila akingika kibhopo bhakaagheghe bhala andumitumi bhaabheghite mukibhopo. ");
INSERT INTO nww_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Peni bhala apingika kibhopo pabhahikite akwo, bhakiabhona ng'obhe bhala andumitumi. Na bhombe bhakibhuya kulibalasa na kualubhulila, ");
INSERT INTO nww_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","bhakilongela, “Tuyibhona milyango ya kibhopo yitatwa telatela na machonda bha kibhopo bhayima pamilyango, peni patuhughulite milyango, tukimmona ng'obhe mundu ywoheli mula unyumba.” ");
INSERT INTO nww_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Hino nkulu ghwa akingika Nyumba ya Chapanga na andundame bhala paayihwite nhalo aghu, bhakibhaghaya na bhakikonyana nnando aghu ghwabhegha bhuli? ");
INSERT INTO nww_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Mbole kakihika mundu yumu na kakiaghombela, “Nnyuhwani! Bhala bhandu bhamuabhopite kukibhopo, hino abhegha ku Kitutubhi kya Chapanga na bhanguahunda bhandu!” ");
INSERT INTO nww_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Apwo yula nkulu gwa apingika kakighenda ku Kitutubhi kya Chapanga papamo na apingika bhake kuabhuyiha bhala andumitumi, peni bhakiakamula kya kulindakila kiyaha bhakiayoghopa bhandu kuaguma maganga. ");
INSERT INTO nww_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Paabhaabhuyihite bhala andumitumi bhakiakwilikiha bhayime mu ulongolo ghwa libalasa, Ndundame nkulu kakiakwonya, ");
INSERT INTO nww_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Tukiakanikiha nkotoke kuhunda kwa lihina ali lya Yesu, peni mwenga mughakwiha mahundo ghenu mu Yelusalemu hyoha na kangi nninga kutukwalila mwoto ghwa kiho kya mundu ayu kwa twenga!” ");
INSERT INTO nww_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petili na andumitumi ayake bhakiyanga, “Yingutukwiliha tunnyitikila Chapanga, chepa kwa mwenga anabhandu. ");
INSERT INTO nww_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Chapanga ghwa hukulu bhetu kakinhyuha Yesu kuhuma mu bhaahweghite, ywene mwenga mukinkoma kwa kumbhangalila mu lupingika. ");
INSERT INTO nww_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Chapanga kakinkwiha Yesu, kakintenda kabhe kilongohi na nlopohi, ngati kabhapeghe bhandu Akaaisilaeli upetulo ghwa ulekekeho ghwa ulemwa. ");
INSERT INTO nww_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Twenga tuyibhona milando ayi kwa meho ghetu, naywo Nhuki Yunakung'anyima ywene Chapanga kabhapegha lilumbo kwa bhoha bhanakunnyitikila.” ");
INSERT INTO nww_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bhala ajumbe bha libalasa paayihwite agha, bhakiyaghabhala muno mbaka bhakipala kuakoma bhala andumitumi. ");
INSERT INTO nww_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Peni Nfalisayu yumu, lihina lyake Gamalieli ywakabheghite nhunda ghwa malaghilo, na ywakahokamilitwi munu na bhandu bhoha kakiyima mu ulongolo ghwa libalasa, na kakikwilikiha bhala andumitumi bhabhuhwe panje huti kya mandina, ");
INSERT INTO nww_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","mbole kakilighombelala lila libalasa, “Makaaislaeli ayangu, mulindakile muno kwa ghamughapala kuatendela bhandu abha. ");
INSERT INTO nww_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kiyaha mu ngungwa ihyahi ahi kakiyinuka mundu yumu lihina lyake Teuda, ywene kakilidumba kukita ndo mundu nhwadali na kakiamokola afwasi elfu ncheche bhaalilungite na mwene. Peni kakikomwa, na akaafuasi bhake bhoha bhakipwilinganika na lihengo lyake likipelela apwo. ");
INSERT INTO nww_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kangi kakinbwitukila Yuda Nngalilaya makachu ghala ghakutyekwa mmbalango ghwa bhandu, ywombe kakikilongoha kimati kya bhandu akiluka. Hilahila na ywombe kakikomwa, na afwasi bhake bhoha bhakipwilinganika. ");
INSERT INTO nww_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kya habhu mihalu ya nnando aghu nunguahigha, mualeke bhandu abha aghende. Kiyaha handa nningo ghwabhe na ndendelo yabhe yihuma kwa anabhandu yahotolwa kata, ");
INSERT INTO nww_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","peni handa lilagho ali lihuma kwa Chapanga twaahotola kata kuakanikiaha bhandu abha, mbole yake malibhona mungututana na Chapanga.” Libalasa likiyitikila uhigho ghwa Gamalieli. ");
INSERT INTO nww_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kya habhu bhakiakema bhala andumitumi unyumba, bhakikwilikiha bhatutwe hinjupunjupu, mbole bhakiakinya akotoke kuyobhela kangi kwa bhandu kwa lihina lya Yesu, mbole bhakialeka abhuke. ");
INSERT INTO nww_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bhala andumitumi bhakibhuka mulibalasa alyo kwa uyelelo, kiyaha yikianogha kuyuyuhwa kwa kya lihina lya Yesu. ");
INSERT INTO nww_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Bhakileka ng'obhe kuhunda bhandu na kulandamiha Nhalo ghwa Maha kukita Yesu ndo Kilisito, mumanjubha ghoha ku Kitutubhi kya Chapanga na mu hitutubhi hya bhandu. ");
INSERT INTO nww_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mumanjubha agho mmbalango ghwa afwasi ghukiyonjokeheka kukwila, kukibwituka ngukuliko mu nkati ya bhaanhyubhalilite Yesu bhaalongilite Kigiliki na bhala bhaalongilite Kiblania, bhala bhaalongilite Kigiliki bhakikukulika kukita adala alekwa bhabhe bhakilibhalilwa mu nng'abhano ghwa hilyo hya kila linjubha. ");
INSERT INTO nww_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Hino bhala andumitumi mbinda mabhoko yimo na abhili ahundwa bhoha papamu na bhakiaghombela, “Inoghelwa ng'obhe kya twenga kuleka kulandamiha lilagho lya Chapanga ngati tutengelekehe ughabhano ghwa hilyo. ");
INSERT INTO nww_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Hino, maalongo bhetu, muahaghule bhandu bha maha saba mu nkati yenu, bhaalongohitwe na Nhuki ghwa Chapanga na bhana mahala, ngati tubhakamuhe lihengo alyo lya kughabha hilyo. ");
INSERT INTO nww_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Peni twenga twaabhegha na lihengo lya kunnyupa Chapanga na kulilandamiha lilagho Chapanga.” ");
INSERT INTO nww_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ghala ghaalongelite ghakianoghela bhandu bhoha, nabho bhakinhaghula Stefano mundu ywakamemitwe na uhyubhalilo na Nhuki ghwa Chapanga papamu na Filipo na Polokolo na Nikanoli na Timoni na Palumena na Nikolao ghwa kuhumila ku Antiokia nlopokela ghwa dini ya Akaayahudi. ");
INSERT INTO nww_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bhakiabhika muulongolo ghwa andumitumi, nabho bhakiayabhikila mabhoko unane mwabhe bhakiayupila. ");
INSERT INTO nww_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Na hino lilagho lya Chapanga likighendelela kukwila, na mmalango ghwa bhaanhyubhalilite Yesu ghukiyonjoheka munu mu Yelusalemu, nalumati lukulu lwa andundame bhakikingama uhyubhalilo. ");
INSERT INTO nww_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Chapanga kakinnemelela munu Stefano, na kakinpegha makakala makulu na kakibha pakitenda mihabho na mang'eha mu nkati ya bhandu. ");
INSERT INTO nww_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Peni bhandu bhamo bhakibwituka ngati bhalimbane na Sitefano. Amoo bha bhandu abho bhakibha bha nyumba ya kutundamila Akaayahudi yikemitwe ngonganilo ya bhandu bha kindimba, nabho bhakihuma ku Kilene na bha ku Iskandalia, na bhangi kuhuma ku Kilikia na ku Asia. ");
INSERT INTO nww_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Peni bhakinhotola ng'obhe kwa mahala ghake kiyaha kakilongohwa na Nhuki ghwa Chapanga pakabheghite mu kuyobhela. ");
INSERT INTO nww_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ndo kwa lupwepo bhakiapegha swinda amoo bhandu alongele, “Tunnyuhwa Stefano paakilongela malagho gha kunkundula Musa papamu na Chapanga!” ");
INSERT INTO nww_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Habhu bhakiakwokeha bhandu, na aghohi na ahunda bha malaghilo, ndo bhaking'endela kunkamula Stefano na bhakinghegha muulongolo ghwa njengakaya ngulu. ");
INSERT INTO nww_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bhakiayimiha mu njengakaya ayo, ayimiho bha ughwangi paakilongela, “Mundu ayu kalekagha ng'obhe kulongela ngambuko ya kukundula apa Nyumba ayi ng'anyimo ya Chapanga na malaghilo gha Musa. ");
INSERT INTO nww_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kiyaha tukinnyuhwa pakilongela kukita ayo Yesu ghwa ku Nasaleti katakikanjaghana Kitutubhi kya Chapanga na kughalambula hitohe hyoha hitukamuhitwe na Musa!” ");
INSERT INTO nww_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bhandu bhoha bhaabheghite apwo panjengakaya ayo bhakinhulutulila meho Stefano, na bhakikibhona kibhungi kyake kingung'anyima handa kibhungi kya nndumitumi ghwa kunani kwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Hino, Ndundame Nkulu kakinkonya Stefano, “Bhuli nongwa ayi ya kya mwenga ndo hoto?” ");
INSERT INTO nww_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stefano kakiyanga, “Makaalongo bhangu na tate bhangu munnyihwe nenga! Hukulu ghwetu Abulahamu kukali na kughenda kutama ku Halani, Ukulu ghwa Chapanga ghukinbwitukila akwo ku Mesopotamia. ");
INSERT INTO nww_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Chapanga kakinng'ombela, ‘Ghubhuke ku nnima ghwakwo na ghubhaleke bhandu bha nnima ghwako, ghughende ku nnima ghumbala kughulangiha.’ ");
INSERT INTO nww_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kya habhu, Abulahamu kakibhuka ku nnima ghwa Akaakalidayo, kakighenda kutama ku Halani. Mbole ya kuhwegha tate ghwake, Chapanga kakimmuha akwo ku Halani na kakinghegha kutama pa nnima aghu ghumuutama hino. ");
INSERT INTO nww_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Chapanga kikinpegha kata kata nga kipalamande kyoheli kya nnima aghu kibheghe kyake, hata habhu kakinlagha kaampegha nnima aghu ghubhe ghwake na ghwa ubhelekwa ghwake, hata manjubha agho kakibha ywa nga mwana. ");
INSERT INTO nww_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Chapanga kakinng'ombela habhu, ‘kibheleko kyakwo kyaghenda mu nnima ghwa kuuhenja, nabho bhaabhegha abhandwa na kutendelwa mahakataho mu ngungwa mbinda mabhoko kumi ncheche. ");
INSERT INTO nww_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Peni nenga ndaghutosa nnima ghula ghughubhatenda abhandwa bhandu bhako, mbole bhaahika mu nnima aghwo na kundundamila nenga apa.’ ");
INSERT INTO nww_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ndo kakimpegha Abulahamu ninganilo lya kulumula unyagho. Naywo Abulahamu kakimpapa Isaka na kumlumula linjubha lya nhano na ndatu mbole ya kubhelekwa kwake. Mbole yake Isaka ubhwabhu abhu kakinndumula unyagho Yakobu mwana ghwake, naywo Yakobu kakiapapa bhala aghohi bhetu kumi na abhili na kakialumula unyagho bhula bhula.” ");
INSERT INTO nww_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Bhala ahukulu bhetu bhakimmonela tama Yosefu nlongo ghwabhe, bhakinhemela handa nbhandwa akwo ku Misili. Peni Chapanga kakibha papamu naywo, ");
INSERT INTO nww_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kakinlopoha mu himbamanda hyaki hyoha, naywo Chapanga kakinpegha Yosefu mahala pakayimite mu ulongolo ghwa Falao Mutwa ghwa ku Misili, naywo kakimmika kabhe ntabhala ghwa Misili na ghwa kitutubhi kyoha kya ghubhutwa. ");
INSERT INTO nww_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Mbole, kukibwituka njala ngulu ku nnima ghwoha ghwa Misili na ku Kanani, hikiyambuha lung'ahi lwa njala, nabho ahukulu bhetu bhakipelelwa hilyo. ");
INSERT INTO nww_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakobu pakayihwite kukita kumisili kukibhegha na hilyo, kakialaghila ahukulu bhetu, nabho bhakighenda akwo kya kutandila. ");
INSERT INTO nww_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Paaghenditi kya ubhili Yosefu kakilikambuha kwa alongo bhake, na mutwa Falao ghwa ku Misili kakikambuhwa alongo bha Yosefu. ");
INSERT INTO nww_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ndo Yosefu kakialaghiha bhandu bhannyeghe Yakwobu tati ghwake na aghanja bhake bhoha, mmalango ghwabhe yikibha bhandu mbinda mabhoko saba na nhano. ");
INSERT INTO nww_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Habhu Yakwobu kakighenda Kumisili na hukulu bhetu na bhakihwila ukwaku. ");
INSERT INTO nww_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Mitumbahi yabhe yikigheghwa mbaka ku Shekemu na yikikulilwa Mulindogholo liihemelitwe na Abulahamu kwa ngalabha kwa bhana bha Hamoli.” ");
INSERT INTO nww_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Peni manjubha paghatwihilikite Chapanga kayitwihilihe naghilo yakanpeghite Abulahamu, mmalango ghwa bhandu ghukiyonjokeheka kala na kubha nkulu muno. ");
INSERT INTO nww_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ndo mutwa yungi ywanga kumanya kyohele kya Yosefu kakitabhala Misili. ");
INSERT INTO nww_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mutwa aywo kakiatendela bhandu bhetu uhakata na kuabamanda atate bhetu kya kuangakamiha bhabhataghe bhana bhabhe hing'enya ngati bhabhakome. ");
INSERT INTO nww_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Mu manjubha agho Musa kakibhelekwa, naywo kakibha mwana yunakuhalala munu. Na bhakinlela na kukula pakaya kwa tate ghwake kwa myehi mindantu. ");
INSERT INTO nww_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Pabhalepelitwe kunhiha, bhakimmika pambwegha ya lukemba na biti Falao kakintola na kunlela handa mwana ghwake mwene. ");
INSERT INTO nww_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa kakihundwa mahala ghoha gha Akaamisili, kakibha mundu nhwadali kwa malagho na ndendelo.” ");
INSERT INTO nww_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Musa pakabheghite na ngungwa mbinda mabhoko ncheche kakilamula kubhatyangila alongo bhake Akaisilaeli. ");
INSERT INTO nww_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kakinmona yumoo ywa alongo bhake pakatutwa na Nmisili, kakighenda kuntangatila, na kwa kibhuyiho kakintuta yula Nmisili mbaka kakinkoma. ");
INSERT INTO nww_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa kakihwacha kukita alongo bhake bhaamanya kukita Chapanga kanguntumila ngati kakaalopohe, peni bhombe bhakimanya ng'obhe. ");
INSERT INTO nww_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kilabho yake Musa kakiabhona Akaaislaeli abhili paakitutana, kakiyigha kuahigha pakiaghombela, ‘Mwenga maalongo menyu, yibha bhuli mungupala kutendelana uhakata?’ ");
INSERT INTO nww_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Peni yula mundu ywakantutite nnyake kakintakula Musa pambwegha na kakinkonya, ‘Ndo ghani ywakakubhikite ghwenga ghubhe nkulu na nlamula ghwetu? ");
INSERT INTO nww_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Bhuli, ghungupala kungoma handa paghunkomite yula Nmisili lichu?’ ");
INSERT INTO nww_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa pakayihwite malagho agho, kakitila na kakighenda kutama ku nnima ghwa ku Media handa nhenja, na akwo kakipapa bhana alumi abhili.” ");
INSERT INTO nww_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Hino mbole ya ngungwa mbinda mabhoko ncheche kuyomoka, nndumitumi ghwa Chapanga kakinbwitukila Musa kukibhala ugheghela na kitumbi kya Sinai mu kiputila kiibheghite mukiyaka mwoto. ");
INSERT INTO nww_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa kakikangacha muno kubhona nnando aghu na pakaheghelelite ngati kalole maha kya ugheghela, ndo kakiyihwa lilobhe lya Bambo palikilongela. ");
INSERT INTO nww_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nenga ndo Chapanga ghwa akaahukulu bhakwo, Chapanga ghwa Abulahamu, na Isaka na Yakobu.’ Musa kakiloghoya kwa lyogha na kakiyigha ng'obhe kulola kangi. ");
INSERT INTO nww_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Bambo kaking'ombela, ‘Ghuhule makubasi ghakwo, kiyaha apa paghuyimite ndo pang'anyimo. ");
INSERT INTO nww_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kulyaghila nighabhona mapungwo gha bhandu bhangu akwo ku Misili. Nyihwa kililo kyabhe kya ubhabho, na nenga huluka ngati nubhalopohe. Hino ndaghulaghila ku Misili.’ ” ");
INSERT INTO nww_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Aywo ndo Musa bhandu bha ku Isilaeli bhakinlema paakilongela, ‘Ndo ghani ywakakutendite ghwenga ghubhe nkulu na nlamula ghwetu?’ Ndo Musa aywo aywo Chapanga kakinlaghila kabhe kilongohi na nlopohi ghwetu kwa njila ya ndumitumi ghwa kunane ghwa Chapanga ywakanbwitukilite mu kiputila kiiyakite mwoto. ");
INSERT INTO nww_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Aywo ndo ywakaalongohite bhana bha Isilaeli kubhuka ku Misili na kutenda naho na mihabho mitangalo akwo Misili na mu Lihibha lya Shamu na kwa ngungwa mbinda mabhoko ncheche mu kibhala. ");
INSERT INTO nww_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ywene Musa ndo ywakaaghombelite bhandu bha Isilaeli, ‘Chapanga kabhayinulila mbuye, mu nkati ya alongo bhenu.’ ");
INSERT INTO nww_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Musa kakibhegha papamu na ahukulu bhetu mu ngwemuko yila kukibhala, ywene ywakalongilite na nndumitumi ghwa kunani kwa Chapanga ku kitumbi cha Sinai na kakikingama malagho gha ubhumi ngati katupeghe twenga.” ");
INSERT INTO nww_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Peni aghohi bhetu bhakilema kunnyitikila Musa, mbole yake bhakinlema na bhakipala kubhuya kangi ku Misili. ");
INSERT INTO nww_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Bhakinng'ombela Haluni, ‘Ghututendekehele machapanga bhangi bha kutulongoha, kiyaha tungumanya ng'obhe kiinbwitukilite aywo Musa ywakatulongohite kuhuma ku Misili.’ ");
INSERT INTO nww_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Agho ndo manjubha ghaatendekehite ling'omung'omu lya mwana senga, bhakiliyambikila nyambi na kulitendela chekwa kilibhi kyene ndo lihengo lyaalitendite kwa mabhoko ghabhe bhene. ");
INSERT INTO nww_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Peni Chapanga kakibhuka nkati yabhe, kakibhaleka bhayitundamile ndondwa hya kunane handa payityekitwe mu kitabho kya Ambuye, ‘Ma mwenga bhandu bha ku Isleli! Mukimbegha ng'obhe nenga nyambi ya anyama bhenu mu ngungwa mbinda mabhoko ncheche ku kibhala! ");
INSERT INTO nww_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mwenga mukikighegha kigubi kya chapanga ghwa uhwangi Moleki, na ling'omung'omu lya ndondwa ya chapanga ghwenu ghwa uhwangi Lefani, ming'omung'omu hyamuyitendekehite ndo hyamuhitundamilite. Kya habhu, ndabhaghegha kutali kupitingana Babeli.’ ” ");
INSERT INTO nww_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Kula kukibhala aghohi bhetu bhakibhegha na kila kigubi kiilangihite ubhegho ghwa Chapanga. Kigubi akyo kikitendekehwa handa Chapanga pakanng'ombilite Musa kalitende na nhwano twihiliko ghwakalangihitwe. ");
INSERT INTO nww_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Mbole, aghohi bhetu paakikingamite kigubi akyo kwa kuyangana paakilongohwa na Yoshua, muutabhala ghula nnima kuhuma mu yila milima ya bhandu bhaabhingibhingitwe na Chapanga mu hibhungi kyabhe, nakyo kigubi akyo kikitama mu nnima aghu mbaka mu manjubha gha Daudi. ");
INSERT INTO nww_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daudi kakinhalala Chapanga, naywo Daudi kakinnyupa Chapanga kakanlekekehe ngati kakanchengele kitutubhi mwene Chapanga ghwa Yakwobu. ");
INSERT INTO nww_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Peni Sulemani ndo ywakahotolite kunchengela Chapanga kitutubhi.” ");
INSERT INTO nww_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Hata habhu, Chapanga ghwa kunane muno kangutama ng'obhe mu hitutubhi hichengitwe na anabhandu handa pakalongelite mbuye ghwake: ");
INSERT INTO nww_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Bambo kangulongela naha, Kunane kwa Chapanga ndo kiteho kyangu kya ghubhutwa, Na nnima ndo pakughabhika maghulu ghangu. Maanjengela nyumba yakya bhuli, ng'ebhu yangu ya kupumulilila yabhegha kwoki? ");
INSERT INTO nww_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ndo nenga ng'obhe nundendite hilibhi hyoha?’ ” ");
INSERT INTO nww_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Mwenga bhandu ahakata akulu, myoyo na makutu ghenu ndo handa gha bhandu bhaammanyite ng'obhe Chapanga. Mwenga ndo handa hukulu bhenu. Manjubha ghoha mungunpingika Nhuki ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Bhuli, kabhegha mbuyi ywoki ghwa Chapanga ywene akaatate bhetu bhakikotoka kummbamanda? Bhakiakoma bhala bhaalondolite mihalo ya kya kuhika kwake yula yunashaliya. Na hino, mwenga munkiluka na mukinkoma. ");
INSERT INTO nww_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mwenga ndo munkingamite malaghilo gha Chapanga, ghaagheghitwe na nndumitumi ghwa kunani kwa Chapanga, Peni mukiyitikila ng'obhe!” ");
INSERT INTO nww_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Bhala aghohi bha njengakaya paayihwite agho, bhakihomwa mu myoyo, bhakiyaghabhala na bhakinkikinalila hibhungi Stefano. ");
INSERT INTO nww_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Peni Stefano kunu pakilongohwa na Nhuki ghwa Chapanga, kakihulutula meho kulolekeha kunane kwa Chapanga na kakighubhona ukulu ghwa Chapanga na Yesu kakamuhwa uhokamo nkulu ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kakilongela, “Nnole! Ningubhona kunane kwa Chapanga kuhughuka na wana ghwa Mundu katama mumbande ya nnilo kwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Peni bhene bhakilema kuyihwa, bhakiyobha kyobho kwa lilobhe likulu na bhakihibha makutu, bhakinhumbila Stefano. ");
INSERT INTO nww_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Bhakimmuha panji ya kitami, bhakintuta kwa maganga. Kukali na kuntuta kwa maganga bhala mayimiho bhakihula maghwanda ghabhe na bhakighabhika kaghalolekehe nhongolo yumu ywaakemitweghe Shauli. ");
INSERT INTO nww_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Paabheghite mukuntuta maganga, Stefano kakinnyupa Chapanga, “Bambo Yesu, ghuukingame uhuki ghwa nenga.” ");
INSERT INTO nww_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Mbole kakichutamila mayughwa, kakilila kwa lilobhe likulu paakilongela, “Bambo ghukotoke kuabhalanga ulemwa aghu.” Mbole ya kulongela agho kakiyomoka. ");
INSERT INTO nww_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Naywo Shauli kakibhegha pala na kakibhona tela kukomwa kwa Stefano. Linjubha alyo ngwemuko lya bhandu bhaanhyubhalilite Kilisito akwo ku Yelusalemu likiyanda kubamandwa kiuhakataho, bhaanhyubhalilite Kilisito bhoha, chepa nga andumitumi ndu, bhakipwilinganika na kutughila ku Yudea na ku Samalia. ");
INSERT INTO nww_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bhandu bhaantundamilite Chapanga bhakinkulila Stefano ku lindogholo na bhakinkukulikila muno. ");
INSERT INTO nww_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Peni Shauli kakiyigha kukanjaghana Ngwemuko ya bhandu bha Chapanga, kakiyingila kitutubhi kwa kitutubhi, na kuapiha panji bhandu bhaanhyubhalilite Kilisito alume kwa adala na kakiakwindika ku kibhopo. ");
INSERT INTO nww_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bhala bhandu bhaapwilinganite, bhakilandamiha lilagho lya Chapanga poheli paaghendite. ");
INSERT INTO nww_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipo kakiyingila ku nnima ghwa ku Samalia na kakialandamiha bhandu Nhalo ghwa Maha ghwa Kilisito. ");
INSERT INTO nww_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Lumati lwa bhandu paannyihwite na kubhona naho na mihabho yakatendite Filipo, bhoha bhakiyanda kuyihwa maha kila kyakalongilite. ");
INSERT INTO nww_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mandilu ghaakweliti bhandu atangalo bhakiabhuka na bhakiyobha kyobho, bhandu alelebhalo na ngwabhengwabhe bhakilamihwa. ");
INSERT INTO nww_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Hinu bhandu bha kitami kila bhakibha na uyelelo nkulu. ");
INSERT INTO nww_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Hino kukibha na mundu yumu lihina lyake Simoni, ywakatenditeghe uhabhi mu manjubha matangalo na kuakangahya bhandu bhoha bha ku nnima ghwa Samalia. Kakilidumba kukita mwene ndo mundu nhwadali. ");
INSERT INTO nww_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Bhandu bhoha achoko kwa akulu bhakinnyihwa maha na bhakilongela, “Simoni ndo makakala gha Chapanga ghaakemitwe ‘Makakala Makulu.’ ” ");
INSERT INTO nww_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bhandu bhakinoghehwa muno kiyaha kwa manjubha matangalo kakiakangahya bhandu kwa uhabhi ghwake. ");
INSERT INTO nww_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Peni paaulihyubhalilite lilagho lya Filipi kwa kya Nhalo ghwa maha ghwa ghubhutwa ghwa Chapanga na lihina lya Yesu kilisito, bhakibatiswa alume na adala. ");
INSERT INTO nww_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Naywo Simoni kakihyubhalila na kakibatiswa. Kakintughila Filipo kwoheli kwaghendite, kakibhughanikwa pakabhonite naho na mihabho mikulu yiitendekite. ");
INSERT INTO nww_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bhala andumitumi bhaabheghite kula ku Yelusalemu paayihwite kukita akolannima bha akwo ku Samalia bhakilihyubhalila lilagho lya Chapanga, bhakialaghila akwo Petili na Yohana bhabhaghendele akwo ku Samalia. ");
INSERT INTO nww_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Paahikite bhakiayupila kwa Chapanga abho bhandu bhaanhyubhalilite Kilisito ngati bhannkingame Nhuki ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kiyaha Nhuki ghwa Chapanga kakibha kaakali kuahulukila hata yumu ywabhe, maha bhakibatiswa ghweka kwa lihina lya Bambo Yesu. ");
INSERT INTO nww_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Hinu Petili na Yohana bhakiayabhikila mabhoko ghabhe unani mwabhe na kuayupila, nabho bhakinkingama Nhuki ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simoni pakaabhonite bhandu bhakingama Nhuki ghwa Chapanga kwa kuyabhikilwa mabhoko mu mitwe yabhe na andumitumi. Kakiyigha kakiapegha ngalabha Petili na Yohana, ");
INSERT INTO nww_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","kakilongela, “Mumbeghe na nenga makakala agha ngati mundu ywoheli yunumpala kunyabhikila mabhoko ghangu unane mwake kakingame Nhuki ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Peni Petili kakinnyanga, “Ghuhobhelele kutali na ngalabha hyako, kiyaha ghungughwacha ghwahotola kuhemela makakala gha Chapanga kwa ngalabha! ");
INSERT INTO nww_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ghwenga ghubhegha ng'obhe papamu na twenga mulihengo ali, kiyaha mwoyo ghwakwo ghubhegha tela ng'obhe na Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kya habhu ghulipetule huti uhokelo ghwakwo na, ghunnyupe Bambo pangi kaghulekekehe mahwacho ghaghubheghite naghwo mu mwoyo ghwakwo. ");
INSERT INTO nww_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kulyaghila nenga nungukubhona ghumemwa tama muno na mbhandwa ghwa ulemwa.” ");
INSERT INTO nww_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simoni kakiyanga, “Ketaketa munnyupile kwa Bambo, ngati likotoke kundula lyoheli mu agha ghamughakambukite.” ");
INSERT INTO nww_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Paayomolite kulangiha ubhoneho na kulandamiha lilagho lya Bambo, bhakibhuya ku Yelusalemu. Paabheghite bhangubhuya bhakialandamiha bhandu Nhalo ghwa Maha mu hijiji hitangalo hya akwo ku Samalia. ");
INSERT INTO nww_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Linjubha limu Ndumitumi ghwa kunane kwa Chapanga kakinng'ombela Filipo, “Ghughenda mbande ya kusi njila yiikindilite ku kibhala yiihulukite kuhuma ku Yelusalemu kughenda ku Gaza.” ");
INSERT INTO nww_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Hino Filipo kakiyanda mwanja. Pakabheghite mu njila kakikongana na mundu yumu ywakaponelitwe na lukuhu, mundu aywo kakibhegha mmika utopelo ghwa utabhala ghwa mutwa nndala Kandake ghwa ku Esiopia, pakabhuya ukaya mumutuka ya kukwakwaghwa na anyama. Mundu aywo, kakibha kangubhuya kuhuma ku Yelusalemu kuntundamila Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Naywo pakabheghite mumutuka yake kubhuya ukaya, kakibha kangulisomela kitabho kya mbuyi ghwa Chapanga ywakakemitweghe Isaya. ");
INSERT INTO nww_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nhuki ghwa Chapanga kaking'ombela Filipo, “Gughende kumutuka yila ghubheghe pambwegha yake na ghulongoane nalyo.” ");
INSERT INTO nww_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipo kakilitughila mutuka lila na kakinnyihwa yula mundu pakasoma kitabho kya Mbuyi ghwa Chapanga ywakakemitweghe Isaya. Habhu Filipo kakinkonya, “Bhuli ghungumanya agha ghaghughasoma?” ");
INSERT INTO nww_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Yula nkulu kakilongela, “Ndamanya bhuli kya nga mundu ywakunfwambulila?” Apwo yula nkulu kakinnyupa Filipi kayingile mumutuka na katame papamo naywo. ");
INSERT INTO nww_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kipalamande kya matyeko mang'anyimo kyakasomiteghe nkulu aywo ndo aki: “Kakilongohwa kughenda kumahinjo handa mene, na handa bhula mwana mene pakinyamala jii pakakeketwa mayuni, ubhwabhu abhu naywo kakilongela ng'obhe kyohele. ");
INSERT INTO nww_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kakiyuyuhwa na bhakimmonela. Ndo ghani ywakahotola kulubhulila kibheleko kyake, kiyaha ulami ghwake ghubhuhwa pannima.” ");
INSERT INTO nww_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Aywo ywakaponelitwi na lukuhu kakinkonya Filipo, “Chonde ghung'ombele, agha matyeko gha mbuyi ghwa Chapanga ghangulongela mihalo ghani? Ghangulongela mihalo ya kya mwene ebu mihalo ya kya mundu yungi?” ");
INSERT INTO nww_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Peni Filipo kakiyanda kunfwambulila kipalamande akyo kya Matyeko Mang'anyimo, na kakinlubhulila Nhalo ghwa Maha ghwa Yesu. ");
INSERT INTO nww_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Paabheghite mumwanja ghwabhe bhakihika paghabheghiti machi, yula nkulu kaking'ombela Filipo, “Ghulole, machi agha apa, kilibhi ghani kya kunganikiha ngotoke kubatiswa?” ");
INSERT INTO nww_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipo kaking'ombela yula nkulu, “Handa ghuhyubhalila kwa mwoyo ghwakwo yinguholwa kubatiswa.” Yula nkulu kakiyanga, “Nunguhyubhalila kukita Yesu Kilisito ndo Mwana ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ndo yula nkulu kakikwilikiha mutuka iyime. Hinu bhoha abhili bhakihuluka na kakighen mu machi, na Filipo kakimbatisa. ");
INSERT INTO nww_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Paabhukite mu machi, kamu Nhuki ghwa Bambo kakinnyahula Filipo, na yula nkulu kakimmona kangi ng'obhe, peni kakighendelela na mwanja ghwake kwa uyelelo. ");
INSERT INTO nww_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipo kakilimanya kabha ku nnima ghwa Azoto, paakityanga na kulandamila Nhalo ghwa Maha mu milima hyoha mbaka pala pakahikite ku Kaisalia. ");
INSERT INTO nww_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Mumanjubha agho Shauli, kakiyonjokeha hiyighoho hya kuakoma afwasi bha Bambo. Kakinng'endela Ndundame Nkulu ");
INSERT INTO nww_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","naywo kakinnyupa Ndundame Nkulu kampeghe lihamba lya kummanyiha mu nyumba ya kutundamilila Akaayahudi akwo ku Dameski, ngati handa pakaabhona alume ebu adala bhaaghutughila uhyubhalilo aghwo kahotole kabhakamule na kuaghegha ku Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Peni pakabheghite mu mwanja ghwake, ugheghela na kuhika ku Dameski; pindulu lung'ali kuhuma kubhwelo lukimmulika mbande hyoha. ");
INSERT INTO nww_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Kakighwegha pahi na kakiyihwa lilobhe palikinng'ombela, “Shauli, Shauli! Kiyaha niki ghungumbamanda?” ");
INSERT INTO nww_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Shauli kakikonya, “Ghwenga ndo ghani Bambo?” Na lila lilobhe likiyanga, “Nenga ndo Yesu yula yughummbamanda. ");
INSERT INTO nww_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Hino ghuyinuke na ghuyingile kumbwani, akwo kabhegha mundu ghwa kughughombela gha kughatenda.” ");
INSERT INTO nww_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bhala bhandu bhaabheghite mumwanja ghumu na Sauli bhakinyamala jii, kiyaha bhakiliyihwa lila lilobhi, peni bhakinmona ng'obhe mundu ywakalongela. ");
INSERT INTO nww_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Shauli kakiyima pala pahi na kakiyigha kughahughula meho ghake, peni kakihotola ng'obhe kubhona kyoheli kila. Ndo bhakinkamula kibhoko na bhakinnongoha mbaka ku Dameski. ");
INSERT INTO nww_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Naywo Shauli kwa manjubha mandatu kakibha ywangalola, kakilyegha ng'obhe hangi kunywegha kyoheli. ");
INSERT INTO nww_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Akwo ku Damasikati kakibhegha nhundwa ghwa Kilisito yumu lihina lyake Anania. Pakabheghite mu mabhono, Bambo kakinkema, “Anania!” Anania kakiyitika. “Mwika Bambo.” ");
INSERT INTO nww_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Bambo kakinng'ombela, “Ghubhuke ghughende ku njila yiikemwa njila ng'ololeho, na mu lubhagha lwa Yuda, ghukankonye mundu ghwa ku Taliso, lihina lyake Shauli. Hinu kangunnyupa Chapanga, ");
INSERT INTO nww_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","na mumabhono ghake Shauli kammona mundu ywakakemwa Anania kanguhika na kunnyabhikila mabhoko ngati kahotole kubhona kangi.” ");
INSERT INTO nww_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Peni Anania kakiyanga, “Bambo, nyihwa mihalo ya mundu aywo kuhuma kwa bhandu atangalo, nyihwa ya kya mihakatahu yakabhatendelite bhandu bhako bha ku Yerusalemu. ");
INSERT INTO nww_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Naywo kahika apa pa Damesikati pakibhegha na makakala gha kuhuma kwa hilongohi bha andundame ngati kabhakamule bhandu bhoha bhaalikambuka lihina lyako.” ");
INSERT INTO nww_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Peni Bambo kakinghombela Anania, “Ghughende! Kiyaha mundu ayu nunhaghula, ngati kalilandamihe lihina lyangu kwa bhandu bhaabheghite ng'obhe Akaayahudi na muabhatwa bhabhe na kwa Akaaisilaeli. ");
INSERT INTO nww_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nenga nimwene ndammoneha yiinnogha kubamandika kwa kya lihina lyangu.” ");
INSERT INTO nww_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hino Anania kakighenda, kakiyingila mula munyumba yakyabheghite Shauli. Mbole kakinnyabhikila mabhoko kunu paakilongela, “Nlongo Sauli, Bambo Yesu ywakakubwitukilite pa njila paghubheghite mu kuhika apa, ndo ywakanlaghilite kwa ghwenga ngati ghumokole kubhona kangi na ghulongohwe na Nhuki ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kamu hilibhi handa mapalapatilo gha homba ghakinponeka kuhuma mu meho ghake, na kakihotola kubhona kangi. Kakiyima na kakibatiswa. ");
INSERT INTO nww_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Mbole ya kulyegha hilyo, makakala ghake ghakimmuyila kangi. Shauli kakitama mu manjubha gha mandina na akaafuasi ghwa akwo ku Damesiki. ");
INSERT INTO nww_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kamu kakiyingila mu nyumba ya kutundamila Akaayahudi na kualandamiha bhandu kukita Yesu ndo Mwana ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Bhandu bhoha bhannyihwite Shauli bhakikangacha na bhakilongela, “Bhuli, ayu ndo mundu yula ng'obhe, ywakabheghite kanguakoma bhandu bhaanhyubhalilite Yesu kula ku Yerusalemu? Na kangi kakihika apa ngati kaakamule na kuaghegha kwa mandundame akulu?” ");
INSERT INTO nww_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Hinu Shauli kakighendelela kubha nhwadali na kubhabhoneha Akaayahudi bha ku Demsiki kukita Yesu ndo Kilisito. ");
INSERT INTO nww_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Mbole ya manjubha matangalo, Akaayahudi bhakikwemukana ngati aghombane ya kya kunkoma Shauli. ");
INSERT INTO nww_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Peni nnando ghwabhe ghukimanyika kanongola kwa Shauli. Akaayahudi bhakibha mu kupingikiha milyango hyoha ya kuyingila pa mbwani, pamuhi na pakilo ngati ahotole kunkoma. ");
INSERT INTO nww_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Peni afwasi bhake bhakintola pakilo na kunhuluha paakibha mulukapu kukindila palilanga lubheghite pa kindupa kya kitami. ");
INSERT INTO nww_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Shauli pakahikite ku Yelusalemu kakiyigha kulilunga na ahundwa bha Yesu, peni bhoha bhakinntila, kiyaha bhakihyubhalila ng'obhe kukita ywene kakibhegha nfwasi. ");
INSERT INTO nww_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Apwo Balinaba kakihika kuntola na kakinghegha kwa andumitumi. Kakialubhulila kya bhula Sauli pakammonite Bambo, na kya bhula Bambo pakalongilite naywo na kya bhula pakalandamihite kwa ukangamalo kwa lihina lya Yesu akwo ku Dameski. ");
INSERT INTO nww_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Hinu Shauli kakililunga nabho, kakityanga ku Yelusalemu paakilandamiha lilagho lya Bambo kwa lihina lya Yesu kwa ukangamalo. ");
INSERT INTO nww_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kakighombana na Akaayahudi bha Kiyunani, peni bhombe bhakipala kunkoma. ");
INSERT INTO nww_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bhala bhanhyubhalilite Kilisito paayuhwite nhalo aghwo bhakintola mbaka ku Kaisalia, na bhakinneka kaghende ku Taliso. ");
INSERT INTO nww_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ndo mu manjubha agho ngwemuko ya bhandu bhaanhyubhalilite Kilisito bhakibha na uhihimilo mu Uyahudi hyoha, na Galilaya na Samalia. Bhakighendelela kutengeleheka na kunnyitikila Bambo na mbalango yabhe yikiyonjokeheka kwa utangwo ghwa Nhuki ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petili pakabheghite mu mwanja kughenda kwoheli kula, lisiku limu kakighenda kuatyangila bhandu bha Chapanga bhaatamiteghe ku Lida. ");
INSERT INTO nww_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Akwo kakinkolela mundu yumu ywakakemitwe Ainea, aywo kakibha nlelebhalo kwa ngungwa nane kya nga kuyinuka pa ulili. ");
INSERT INTO nww_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Hinu, Petili kaking'ombela, “Ainea, Yesu Kilisito kaghulamiha, ghuyinuke na ghuyalule likahe lyakwo.” Kamu, Ainea kakiyinuka. ");
INSERT INTO nww_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Bhandu bhaatamite ku Lida na luluchi lya ku Shaloni bhoha bhakinkilibhukila Bambo. ");
INSERT INTO nww_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Akwo ku Yopa kakibha nhyubhalila yumu ndala lihina lyake Tabita, kwa Kiyunani Dolkasi fwambulo yake nnyma yunakukemwa mbabhala, nndala aywo kakibha kangutenda gha maha na kakiatanga bhandu kapukwa manjubha ghoha. ");
INSERT INTO nww_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mumanjubha agho kukibha kakilwala na kuyomoka. Bhandu bhakighuyoha mmili ghwake, na bhakighughonjeha ku kyumba kya ku ligholofa. ");
INSERT INTO nww_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yopa kukibha ugheghele na ku Lida, bhandu bhaanhyubhalilite Kilisito paayuhwite kukita Petili kabhegha akwo, bhakialaghila bhandu abhili kwa Petili ngati bhakanyupe, “Ketaketa ghuhike kya nga kukabhalila.” ");
INSERT INTO nww_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Hinu Petili kakilongohana nabho, pakahikite bhakinnongoha mbaka ku kyumba kya kunane ya ligholofa pakaghonjehitwe Dolikasi. Adala alekwa atangalo bhakintindila Petili kunu paalila na kunnangiha maghwanda matandamahu na mapinda ghangi ghaatalaswite na Dolkasi pakabeghite na ubhumi. ");
INSERT INTO nww_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petili kakiabhuha bhoha panji, kakichutama mayughwa, pakiyupa. Mbole kakighulola ghula ntumba pakilongela, “Tabitha ghuyumuke.” Naywo Tabita kakihughula meho ghake, na pakanmonite Petili, kakitama. ");
INSERT INTO nww_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petili kakinkamula kibhoko kakinnyinula, ndo kakiakema bhaanhyubhalilite Yesu na bhala adala alekwa, mbole kakiakamuha kwa bhene kunu pakakeka. ");
INSERT INTO nww_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mihalo ayi yikikwila kwoha ku Yopa na bhandu atangalo bhakinhyubhalila Bambo. ");
INSERT INTO nww_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petili kakitama ku Yopa mu manjubha matangalo papamu na Simoni ntendehi ghwa kutendekeha hilibhi hya mayula. ");
INSERT INTO nww_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ku nnima ghwa ku Kaisalia kakibhegha mundu yumu lihina lyake Kolineli, ywene kakibha machonda nhwadali ghwa kimati kimanyikitwe handa “Kimati kya Kiitalia.” ");
INSERT INTO nww_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Mwene kakibha nhyubhalila ghwa Chapanga papamu na bha kulubhagha lwake lwoha. Na kakitendagha matangalo kuatangatila makapukwa na kunnyupa Chapanga mu manjubha ghoha. ");
INSERT INTO nww_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Linjubha limu pasaa tisa ya makimuhi, kakibhona mabhono gha peku peku, ndumitumi ghwa kunane ghwa Chapanga kakinhikila na kung'ombela, “ Kolineli!” ");
INSERT INTO nww_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kolineli kakinkwenjulila meho aywo ndumitumi ghwa kunane kwa lyogha, kakinng'ombela, “Kubhegha niki Bambo?” Ndumitumi ghwa kunani kwa Chapanga kakinnyanga, “Mayupo ghako na matulo ghako, ghalibhalilwa ng'obhe kwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Hino, ghubhalaghile bhandu ku Yopa, bhakankeme Simoni, ywaakemitwe Petili. ");
INSERT INTO nww_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Mwene kangutama ku lubhagha lwa Simoni ntendehi ghwa kutendekeha hilibhi hya mayula, na nyumba yake kibhegha ugheghela na lihibha.” ");
INSERT INTO nww_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Yula ndumitumi ghwa kunani ghwa Chapanga pakabhukite, Kolineli kakiakema akandumindumi bhake abhili papamu na machonda ghwake yumu nhyubhalila ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kakialubhulila mihalo hyoha yiibwitukilite, mbole kakialaghila aghende ku Yopa. ");
INSERT INTO nww_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kilabhu yake handa pa saa sita pamuhi, bhala bhandu andatu pabhaabheghite akali mu mwanja ugheghela na kukihikila kitami kya Yopa, Petili kakikwela kunane kukitutubhi ngati kannyupe Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pakabheghite mu kunnyupa Chapanga njala yikimmina, na kakipala kulyegha hilyo, peni pabhaabheghite mu kuteleka hilyo ng'ono yikintopela na kakibhona mabhono. ");
INSERT INTO nww_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kakibhona kunane kwa Chapanga kuyughuka na kilibhi handa lipinda likulu pa likihuluhwa pahi likikamulwa mu mbande hyake ncheche, ");
INSERT INTO nww_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mula mu lila lipinda kukibhegha na anyama nhanganganiko: Anyama bhaabheghite na maghulu ncheche, bhaakwabha na hiyuni hyoha hya kunhitu. ");
INSERT INTO nww_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Mbole lilobhe liking'ombela, “Petili, ghuyinuke ghuhinje na ghulyeghe.” ");
INSERT INTO nww_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Peni Petili kakiyanga, “Aka kaa, Bambo, kulyaghila kutandila makachu nenga ninalyegha ng'obhe kyoheli kilibhi kikanikihitwi na Chapanga na kulyeghwa.” ");
INSERT INTO nww_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Lila lilobhe likilongela kangi paubhili, “Ghukotoke kuhikema hingunoghwa ng'obhe kulyeghwa hilibhi hyakatendite Chapanga kukita hingunoghwa kulyeghwa.” ");
INSERT INTO nww_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Nndo aghu ghukibwituka pa ndatu, mbole lila lipinda likibhuya kunane kwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petili pakabheghite kangukangacha ghala ghakabhonihitwe na Chapanga, bhala bhandu bhaalaghilitwe na Kolineli bhakikibhona nyumba ya Simoni Ntendehi ghwa kutendekeha hilibhi hya mayula, na bhakiyima paulongolo ghwa nlyango. ");
INSERT INTO nww_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bhakikema na bhakikonya, “Bhuli, kabhegha nhenja yumu ywaakemwa Simoni ebu lihina lyake lingi Petili kangutama apa?” ");
INSERT INTO nww_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petili pakabheghite akali kanguhwacha ghala ghakabhonehitwe na Chapanga, bahala pala Nhuki ghwa Chapanga kakinng'ombela, “Simoni, bhabhegha bhandu andatu bhangukupalaha. ");
INSERT INTO nww_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ghuhuhuluke kanongola apa unani ghwa kitutubhi na ghukotoke kumaka kughenda papamu nabho, kiyaha ndo nenga nibhalaghilite.” ");
INSERT INTO nww_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Hino Petili kakihuluka na kuaghombela bhala bhandu bhaalaghilitwe kuhuma kwa Kolineli, “Nenga ndo mwene yumumpalaha. Nhikila niki?” ");
INSERT INTO nww_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bhala bhandu bhakinnyanga, “Tulaghilwa na machonda kilongihi ghwa bhandu mbinda mabhoko kumi ywakakemwa Kolinelio mwene ndo mundu ywa maha muno, yunakuntundamila Chapanga na kutikilwa na Akaayahudi bhoha. Mwene kalaghilwa na nndumitumi ghwa kunani ghwa Chapanga kakulalike ghwenga ukaya kwake, ngati kayihwe malagho ghughapala kunng'ombela.” ");
INSERT INTO nww_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Hinu Petili kakiakingama na kakilongohana nabho mu nyumba kati kakiapegha pa kughonja. Kilabhu yake Petili kakibhuka na kulongohana na bhala bhandu na amoo alongo kuhuma Yopa. ");
INSERT INTO nww_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pamalabho yake bhakihika ku Kaisalia, na Kolnelio kakibhegha paakialindila, kunu pakibha na ngwemuko ngulu ya alongo na aghanja bhake. ");
INSERT INTO nww_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petili pakabheghite mu kuyingila mu lubhagha, Kolinelio kakinyahuka kunkingama, kakinhokamila ngati kakantundamile. ");
INSERT INTO nww_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Peni Petili kakinnyinula, paking'ombela, “Ghuyime kiyaha na nenga ndo mundu hela.” ");
INSERT INTO nww_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petili pakabheghite mu kuyobhela naywo Kolinelio, kakiyingila nkati na kakiabhona bhandu atangalo bhakwemukana. ");
INSERT INTO nww_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Petili kakiaghombela, “Mwenga mungumanya yomo kukita yibha kihyengo na malaghilo ghetu Akaayahudi katame na mundu ghwa nga kubhegha Nnyahudi, kangi hata kuntyangila, peni Chapanga kang'ombela ngotoke kunhwachila mundu ywoheli kukita kangulemwa na Chapanga ebu kabha ghwa nyanyi ng'obhe. ");
INSERT INTO nww_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kwa kya agha, pamungemiteghe hika kya nga kulema. Hinu ningubhakwonya, nhalo ghani ghumunngemilite?” ");
INSERT INTO nww_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kolineli kakilongela, “Handa manjubha ncheche ghakindite, nikibhegha mukuyupa ukaya lisaa handa ali lya saa tisa makimuhi, kamu nikinmmona mundu kayima muulongo ghwangu kaghwala mapinda gha mbuletee, ");
INSERT INTO nww_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","na kakilongela, ‘Kolnelio, mayupo ghako ghayihwanika na matulo ghako ghakingamwa na Chapanga kwa kya bhandu kapukwa. ");
INSERT INTO nww_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ghubhalaghile bhandu bhaghende ku Yopa bhakankeme Simoni, ywaakemitweghe Petili. Mwene ndo nhenja mu nyumba ya Simoni Ntendehi ghwa kutendekeha hilibhi hya mayula, na nyumba yake kibhegha mubwegha ya lihibha.’ ");
INSERT INTO nww_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kamu nikialaghila bhandu kwa ghwenga, na ghutenda maha kuhika. Hinu twabhoha tubhegha paulongolo ghwa Chapanga kughayihwa ghoha ghakakukwilikihite Bambo kutughombela.” ");
INSERT INTO nww_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ndo Petili kakiyanda kulongela, “Kulyaghila hino nungumanya kya hoto kukita Chapanga kabha na ubhaghulo ng'obhe. ");
INSERT INTO nww_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Mundu ghwa nnima ghwohele ywakantundamila Chapanga na kutenda ghannoghite kaayitikilwa naywo. ");
INSERT INTO nww_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Munnyihwe mwenga mungumanya kukita Chapanga kakialaghila bhandu bhake kualandamiha Akaaisilaeli Nhalo ghwa Maha kukita amokole uhihimilo kwa kupitila Yesu Kilisito ywene ndo Bambo ghwa bhandu bhoha. ");
INSERT INTO nww_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mwenga Mungughamanya ghala ghabwitukilite ku nnima ghwoha ghwa Yudea kutandila ku Galilaya, Yohana pakayomolite kualandamiha bhandu nhalo ghwake ghwa Ubatiso. ");
INSERT INTO nww_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Kya bhula Chapanga pakanhaghulite aywo Yesu ghwa Kunasaleti kya kunpegha Nhuki na makakala ghake, naywo kakighenda akwo na kula pakitenda gha maha na kubhalamiha bhoha bhaabheghite mukupungwa na makakala gha Nchipila, kulyaghila Chapanga kakibhegha papamu naywo. ");
INSERT INTO nww_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Twenga ndo bhandu tubhonite kwa meho ghetu twabhene mihalo hyoha yiitendikitwe kwoha ku Yudea na Yelusalemu, bhakinkoma na kwa kya kummangalila mu lupingika. ");
INSERT INTO nww_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Peni mu linjubha lya ndatu Chapanga kakinhyuha na kakintenda kabhonekane, ");
INSERT INTO nww_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","kakibhonekana kwa bhandu bhoha ng'obhe, peni kwa twenga tuuhaghulitwe na Chapanga tubheghe mayimiho tuubhonite kwa meho ghetu, na ndo tukilyegha na kunywegha naywo mbole ya kuhyuka kwake. ");
INSERT INTO nww_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Kakitukwilikiha tubhalandamihe Nhalo ghwa Maha kwa handu bhoha, na kubhaghombela ywene ndo ywakahaghulitwe na Chapanga kabheghe nndumula noghwa kwa kya bhaabheghite na ukeko na bhaahweghite. ");
INSERT INTO nww_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Mambuyi bhoha bha Chapanga bhakiyobhela ya kya ywombe kukita mundu ywoheli yunakunhyubhalila kaalekekehwa ulemwa ghwake ghwoha kwa mu lihina lyake.” ");
INSERT INTO nww_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petili pakabheghite mukulongela malagho agho, Nhuki ghwa Chapanga kakiahulukila bhoha bhaaliyihwite lilagho lila. ");
INSERT INTO nww_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Na bhala adumula unyagho bhaahyubhalilite bhakihika papamu na Petili kuhuma ku Yopa bhakikangacha kubhona Chapanga kabhapopohela lilumbo lya Nhuki ghwake kwa bhandu bhaabheghite ng'obhe Akaayahudi bhubho. ");
INSERT INTO nww_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kiyaha bhakibhayuhwa pabhayobhela mu nongelo nhanganganiko kunu pakinkweha Chapanga. Ndo apwo Petili kakilongela, ");
INSERT INTO nww_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Bhandu abha bhakingama Nhuki ghwa Chapanga handa bhula twenga patunkingamite. Bhuli, kubhegha na mundu ywoheli bha kubhakanikiha bhandu abha akotoke kubatiswa kwa machi?” ");
INSERT INTO nww_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Habhu kakikwilikiha bhabatiswe kwa lihina lya Yesu Kilisito. Mbole bhakinnyupa katame nabho kwa manjubha gha mandina. ");
INSERT INTO nww_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Andumitumi na bhaahyubhalilite Yesu akwo ku Yudea bhakiyuhwa kukita bhandu bhaabheghite ng'obhe Akaayahudi bhakikingama lilagho lya Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Hinu Petili pakabhuyite ku Yelusalemu, bhala Akaayahudi ahyubhalila bhaalemelelite bhandu bha nga kubhegha Ayahudi bhalumulwe unyagho, bhakiabhayila, paakilongela, ");
INSERT INTO nww_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ghwenga ghukighenda kwa bhandu bha nga kulumulwa unyagho na mbaka ghukilyegha nabho!” ");
INSERT INTO nww_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Apwo Petili kakiyanda kualubhulila tela tela ya kya ghala ghaabwitukilite kutandila kalongohi. ");
INSERT INTO nww_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Kakilongela “Linjubha limo nikibhegha ku nnima ghwa ku Yopa pa nikiyupa, kamu, Chapanga kakimmoneha mabhono. Kukibha na kilibhi handa ng'olole nkulu likihuluka pala pammeghite kuhuma kunane kwa Chapanga, palikamulwa mu mbande hyake ncheche. ");
INSERT INTO nww_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Panolekehite unyumba mwaki kya ugheghela nikiabhona anyama bhaabheghite na maghulu ncheche, anyama bha kunhitu, bhaakwabha na hiyuni bha kunhitu. ");
INSERT INTO nww_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mbole nikiyuhwa lilobhe paling'ombela, ‘Petili ghuyumuke ghuhinje na ghulyeghe!’ ");
INSERT INTO nww_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Peni nenga nikilongela, ‘Aka kaa, Bambo, kulyaghila nenga ninalyegha ng'obhe kilibhi kyohele kiikanikihitwe na Chapanga kulyeghwa.’ ");
INSERT INTO nww_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Lila lilobhe likiyuhwanika kangi kuhuma kunane kwa Chapanga kya ubhili, palikilongela, ‘Ghukotoke kuhikema hingunoghwa ng'obhe kulyeghwa hilibhi hyakatendite Chapanga kukita hingunoghwa kulyeghwa.’ ");
INSERT INTO nww_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Nnando aghu ghukibwituka pa ndatu, na kuuhiko hyoha hikibhuyihwa kunane kwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kamu bhandu andatu bhaalaghilitwe kuhuma ku Kaisali bhakihika ku nyumba ya ndamiteghe paakilongela. ");
INSERT INTO nww_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Nhuki ghwa Chapanga kaking'ombela ghughende nabho kya nga ubhaghulo munkati ya twenga na bhombe, abho alongo sita bhaanhyubhalilite Chapanga bhakilongohana na nenga, akwo tukiyingila mu lubhagha lwa Kolineli. ");
INSERT INTO nww_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kolineli kakitughombela bhula pakammonite ndumitumi ghwa kunane kwa Chapanga pakayima mu nyumba yake na kunng'ombela, ‘Ghubhalaghile bhandu bhaghende ku Yopa kwa Simoni, kwa lihina lingi Petili. ");
INSERT INTO nww_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ywombe kaakupegha mihalo ya kughulopoha ghwenga na bha mulubhagha lwakwo.’ ");
INSERT INTO nww_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Na pandandite kulongela, Nhuki ghwa Chapanga kakiahulukila handa pakatuhulukihite twenga kandahi. ");
INSERT INTO nww_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Mbole nikikulungwa ghala malagho gha Bambo ghakalongilite, ‘Yohana kakibatisa kwa machi, peni mwenga maabatiswa kwa Nhuki ghwa Chapanga.’ ");
INSERT INTO nww_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Hinu handa Chapanga kabhapegha lilumbu lila lila lyakatupeghite bhandu bhaabheghite ng'obhe Akaayahudi, handa lila lila tupeghitwe twenga patunhyubhalilite Bambo Yesu Kilisito, bhuli nenga ndo ghani, mbaka nyighe kunkanila Chapanga?” ");
INSERT INTO nww_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Paayuhwite malagho agha, bhakileka kulimbana naywo, bhakinkwiha Chapanga paakilongela, “Chapanga kabhapegha bhandu bhaabheghite ng'obhe Akaayahudi ng'ebhu ya kulipetula bhamokole ubhumi!” ");
INSERT INTO nww_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kubhukana na kimbamanda kibhabwitukilite manjubha gha Sitefano pakakomitwe, amoo bhaanhyubhalilite Kilisito bhakipwinganika. Bhangi bhakighenda mbaka ku Foinike na ku Kipulo na ku Antiokia paakilandamiha lila lilagho kwa Akaayahudi ghweka chabhe. ");
INSERT INTO nww_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Peni amoo bhaanhyubhalilite Kilisito bhakihuma ku Kipulo na ku Kilene, bhakighenda ku Antiokia na kualandamiha bhandu bhaabheghite ng'obhe Akaayahudi, na kuaghombela Nhalo ghwa Maha ghwa Bambo Yesu. ");
INSERT INTO nww_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Bambo kakiatangatila, na mmalango nkulu ghwa bhandu bhakihyubhalila na kunkilibhukila Bambo. ");
INSERT INTO nww_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nhalo ghwa nnando aghu ghukiyuhwanika mu ngwemuko ya bhandu bhaanhyubhalilite Kilisito ya ku Yelusalemu, Habhu bhakinnaghila Balinaba kaghende ku Antiokia. ");
INSERT INTO nww_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Balinaba pakahikite na kulibhoneha mwene kya bhula Chapanga pakaanemelilite, mwoyo ghwake ghukihekelela na kakiayonjokeha mwoyo aghendelele na kubhegha na uhyubhalilo kwa Bambo mu myoyo yabhe hyoha. ");
INSERT INTO nww_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Balinaba kakibhegha mundu ywa maha, ywakalongohitwe na Nhuki ghwa Chapanga na yunauhyubhalilo, bhandu atangolo bhakiyonjokeheka kwa Bambo. ");
INSERT INTO nww_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mbole Balinaba kakibhuka na kakighenda ku Taliso kunpalaha Shauli. ");
INSERT INTO nww_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Pakanmmonite kakibhuya naywo ku Antiokia. Habhu kwa ngungwa yimu hyoha Balinaba na Shauli bhakitama na ngwemuko ya bhandu bhaanhyubhalilite Kilisito na bhakiahunda bhandu atangalo. Na yikibhegha mu ngwemuko ya bhandu bhaanhyubhalilite Kilisito akwo ku Antiokia ahundwa bhakikemwa Akilisito kya ulimbulo. ");
INSERT INTO nww_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mu manjubha agho agho amoo bha mambuye bha Chapanga bhakihika ku Antiokia kuhuma ku Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Yumoo ywabhe, lihina lyake Agabo kakiyima na kakilondola kwa kulongohwa na Nhuki ghwa Chapanga kukita kwabhegha lung'ahe lwa njala mu milima hyoha. Njala handa ayo yikibwituka mu utabhala ghwa Kilaudi. ");
INSERT INTO nww_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Bhala ahundwa bhakilamula kukita kila mundu kwa kyakabheghite nakyo kahotole kubhuha utango kwa alongo bhaabheghite ku Yudea. ");
INSERT INTO nww_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Hinu bhakitenda habhu na bhakiapegha Balinaba na Shauli utango ghwabhe ngati bhaukamuhe kwa aghohi ghwa ngwemuko ya bhandu bhaanhyubhalilite Kilisito. ");
INSERT INTO nww_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mu manjubha agho agho, Mutwa Helodi Agilipa kakiyanda kuakamula na kuabamanda amoo bha bhandu bhaanhyubhalilite Kilisito. ");
INSERT INTO nww_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Kakinkoma kwa lukechelo Yakobu nnongo ghwake Yohane. ");
INSERT INTO nww_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Pakabhonite nnando aghwo ghubhayeleha Akaayahudi, kakighendelela, kakinkamula Petili bhubho. Nnando aghwo ghukibwituka manjubha gha kikubhukubhu kya mangate ya nga kubhikwa linjakamu. ");
INSERT INTO nww_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Mbole ya kunkamula Petili na kunhwinda ku kibhopo, kakimmika mu ukingiko ghwa himati ncheche hya machonda na kila kimo kikibhegha na machonda ncheche. Helodi kakihwacha kuntosa Petili muulongolo ghwa bhandu mbole ya kikubhukubhu kya Pasaka. ");
INSERT INTO nww_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kya habhu, Petili kakibhikwa ku kibhopo, peni ngwemuko ya bhandu bhaanhyubhalilite Kilisito bhakibhegha bhangunnyupila muno kwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Hino pakilo kukali na kuhika linjubha lyakalingite Helode Agilipa kuntosa Petili muulongolo ghwa bhandu, Petili kakibhegha pakighonja pakati ya machonda abhili na kakibhopwa minyololo mibhili, na machonda bhangi bhakibha bhangukingika pa nlyango nkulu ghwa kibhopo. ");
INSERT INTO nww_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Pindulu ndumitumi ghwa kunane kwa Bambo kakiyima ugheghela naywo na lulangalo lukimulika kyumba kila kya kibhopo. Yula ndumitumi kakintingilihia mulubhaho na kunyumuha pakilongela, “Ghuyime kanongola!” Kamu minyololo yikimetuka na kuponeka pahi kuhuma mumabhoko gha Petili. ");
INSERT INTO nww_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Yula nndumitumi ghwa kunane kwa Chapanga kakinng'ombela, “Ghulikunge nkungi ghwakwo na ghuhwale makwobasi ghakwo.” Petili kakitenda habhu. Mbole yula nndumitumi kakinng'ombela, “Ghulibhope lighwanda lyakwo na ghundughile.” ");
INSERT INTO nww_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Hinu, Petili kakintughila na kakibhuka panje ya kibhopo. Mwene kakimanya ng'obhe kukita ghaatendikite na yula ndumitumi ghwa kunane kwa Chapanga ghakibha ndo gha hoto. Kakihwacha kukita pangi Chapanga kangummoneha mabhono. ");
INSERT INTO nww_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Petili na nndumitumi aywo bhakikinda pa amachonda bhaabheghite mu kughukingikiha paulongohi na paubhili bhakihika panlyango ghwa kyuma ghwa kubhukila ku kibhopo na kuyingila kubwani, nlyango agho ghukihughuka ghwene bhakibhuka panje. Bhakityanga mu njila yimo, na kamu yula nndumitumi ghwa kunani kwa Chapanga kakinneka Petili. ");
INSERT INTO nww_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Apwo ndo Petili kaking'amula ghaghanbwitukilite, na kakilongela, “Hinu nungumanya hoto, kulyaghila Bambo kanlaghila nndumitumi ghwake kantangatile kuhuma mu mabhoko gha Helode Agilipa kwa mihalo hyoha na kuhuma mu malindilo gha bhandu bha Akaayahudi.” ");
INSERT INTO nww_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Petili pakang'amulite ali kakighenda ku lubhagha lwa Malia ma ghwake Yohane, lihina lyake lingi Maliki, bhandu atangalo bhakikongana amwo kwa kya kunnyupa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petili kakikong'onda nlyango ghwa panje, na nndumindumi yumu nhinja lihina lyake Loda, kakighenda kunnyihwa. ");
INSERT INTO nww_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Aywo nhinja pakaling'amulite lilobhe kukita lya Petili kakiyelelwa munu, na pakali ya kuhughula ghula nlyango kakibhuya lubhilo unyumba na kualubhulila kukita “Petili kayima panji ya nlyango!” ");
INSERT INTO nww_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bhombe bhakinng'ombela yula nhinja, “Ghuna nng'uluka.” Pakabhinililite kulongela kukita ndo hoto, bhakilongela, “Aywo ndo nndumitumi ghwake kahuma kunani kwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Peni Petili kakighendelela kukong'onda nlyango, nabho pabhahughulite nlyango na kummona Petili, bhakibhughanika muno. ");
INSERT INTO nww_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petili kakialaha kwa kibhoko kyake ngati bhatame jii, kakialubhulila bhula Bambo pakammuhite ku kibhopo, Mbole kakiaghombela, “Mukang'ombele Yakobu na bhangi bhanhyubhalilite Kilisito mihalo yiinbwitukiliti.” Ndo kakibhuka na kughenda kumoo kungi. ");
INSERT INTO nww_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Paghucheghite, bhakibha na mmaghayo nkulu nkati ya bhala machonda, ya kya Petili ");
INSERT INTO nww_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Helode kakikwilikiha kahakwe, peni bhakihotola ng'obhe kunmmona. Kya habhu kakiakwonya bhala machonda na kakikwilikiha bhakwomwe. Mbole Petili kakibhuka ku Yudea na kakighenda ku Kaisalia kwene kakitama kwa mandina. ");
INSERT INTO nww_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Mutwa Helode kakiayaghabhalila muno bhandu bha ku Tilo na ku Sidoni. Habhu bhandu bha hitami ahyo hibhili bhakililunga mu kimati papamu kughenda kubhonana naywo. Nabho bhakimokola huti kunnyegheleha Bulasito ywakabheghite ugheghela na mutwa naywo kakibha mmika utopelo nkulu ghwa Kitutubhi kya mutwa. Ndo bhakighenda kwa mutwa kunyupa kukita kubheghe na malingano malobhe gha uhihimilo, kiyaha nnima ghwabhe ghukihyubhalila nnima ghwa mutwa kumokola hilyo. ");
INSERT INTO nww_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Hinu, linjubha lihaghulitwe Helodi kakihwala mapinda ghake gha kibhutwa, kakitama mu kiteho kyake kya utabhala na kualandamiha bhandu. ");
INSERT INTO nww_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Bhandu bhaakwemukite bhakiyobha kyobho kwa uyelelo, pakilongela, “Ali lilobhe lya Chapanga, ndo lilobhe lya anamundu ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kamu, kiyaha Herode Agilipa kakinpegha ng'obhe ukulu Chapanga, Ndumitumi ghwa kunane kwa Chapanga kakintuta, kakilyeghwa na mahinye, na kakihwegha. ");
INSERT INTO nww_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Lilagho lya Bambo likighendelela kukwila. ");
INSERT INTO nww_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Balinaba na Shauli pabhayomolite kutengelekeha lihengo lyabhe, bhakibhuka ku Yelusalemu papamu na Yohana lihina lyake lingi Maliki. ");
INSERT INTO nww_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mu nkati ya ngwemuko ya bhandu bhaanhyubhalilite Kilisito lya ku Antiokia pakibhegha mambuye bha Chapanga na ahunda handa Balinaba na Simoni, Simoni lihina lyake lingi Mpili, Lukio ywakahumite ku Kilene, Manaeni ywakalelitwe na Mutwa Helode na Shauli. ");
INSERT INTO nww_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Paabheghite mu kunnyupa Chapanga na kulikunga, Nhuki ghwa Chapanga kakilongela, “Mumaghulile Balinaba na Shauli kwa kya lihengo linibhakemelite.” ");
INSERT INTO nww_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ndo mbole ya kulikunga na kuyupa bhakiayabhikila mabhoko unani mwabhe na kualagha. ");
INSERT INTO nww_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Hino, Balinaba na Shauli paalaghilitwe na Nhuki ghwa Chapanga, bhakighenda ku Seleukia na kuhuma akwo bhakikwela bhwato mbaka ku kigunguli kya Kipulo. ");
INSERT INTO nww_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Paahikite ku kitami kya Salami, bhakilandamiha lilagho lya Chapanga mu nyumba ya kutundamila Akaayahudi. Yohana Maliki kakibheghe ntangatila ghwa lihengo lyabhe. ");
INSERT INTO nww_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Pabhatyangite mu nnima ghwoha ghwa Kipulo, bhakihika kitami kimo kiikemitweghe Pafo. Akwo bhakimmona Nnyahudi yumo nhabhi mbuye ghwa uhwangi, lihina lyake kakikemwa Baliyesu. ");
INSERT INTO nww_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Mundu aywo kakibha ntangatila ghwa Seligio Paulo, mundu yunamahala na kangi kakibha ntabhala ghwa kigunguli kila, Seligio Paulo kakiakema Balinaba na Shauli ngati kayuhwe lilagho lya Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Peni Baliyesu yula Nhabhi ywene lihina lyake kwa Kigiliki kakikemwa Elima, kakiyigha kuapingikiha Balinaba na Shauli kunu pakiyigha kunhobheha yula nkulu ghwa kigunguli kila kakotoke kuhyubhalila mahundo ghabhe gha kya Yesu. ");
INSERT INTO nww_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Peni Shauli, ywene lihina lyake lingi likibha Paulo pakamemekihitwe Nhuki ghwa Chapanga kakinhulutulila mehu Elima yula nhabhi. ");
INSERT INTO nww_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Kakilongela, “Ghwenga mwana ghwa Nchipila nmyanja ghwa hoto ghoha ghuumemikihitwe uhwangi na njenjelo ya kuakuluha bhangi, bhuli ghunguleka ng'obhe kuyihobheha njila ya Bambo yighololite? ");
INSERT INTO nww_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Hinu, Bambo katakulandamula, ghwabhegha ghwangalola, ghwabhona ng'obhe lubhwelu lwa luchubha kwa manjubha gha mandina.” Kamu lyohi na lubhindu hikinngubika naywo kakighenda akwo na kula pakipalaha mundu ywa kunkamula kibhoko ngati kanlongohe. ");
INSERT INTO nww_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Yula nkulu ghwa kila kigunguli pakabhonite ghala ghaabwitukite, kakinhyubhalila Bambo kiyaha kakikangahwa na mahundo gha Bambo. ");
INSERT INTO nww_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Mbole Paulo na ayake bhakibhuka kuhuma ku Pafo na bhakihika Peliga ku Pamufilia, peni Yohana ywakakemitweghe Maliki kakialeka akwo na kakibhuya Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Peni bhombe bhakighendelela na mwanja mbaka ku Antiokia ya ku Pisidia. Linjubha lya Kupumulila Akaayahudi bhakiyingila mu nyumba ya kutundamila Akaayahudi na bhakitama pahi. ");
INSERT INTO nww_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mbole ya kusoma mukitabho kya malaghilo gha Musa na mumatyeko gha ambuye bha Chapanga, akulu ghwa yila nyumba ya kutundamila Akaayahudi bhakiataghila lilobhe paakilongela, “Maalongo! Handa mungupala kulongela lilagho lya kuayonjokeha makakala bhandu abha ketaketa nnongele.” ");
INSERT INTO nww_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Hino Paulo kakitandamuka, kakiapukila kibhoko, pakilongela. “Mwenga Makaaisilaeli ayangu, na mwenga munmeghite ng'obhe Akaayahudi, muunnyitikila Chapanga kubhoneha kukita bhatame jii, nnyihwanile! ");
INSERT INTO nww_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Chapanga ghwa bhandu abha bha ku Isilaeli kakiahaghula ahukulu bhetu, na kakibhatenda bhabhe nnima nkulu pabhaabheghite ku uhenja kula ku Misili. Chapanga kukibhabhuha ku nnima ghula na kakialongoha kwa makakala makulu. ");
INSERT INTO nww_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kakialimbilila mu ngungwa mbinda mabhoko ncheche paabhegha mukibhala. ");
INSERT INTO nww_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Na mbole ya kuhikanjaghana milima saba ya Kanaani ndo kakiapegha bhandu bhake ghula nnima ghubhe ghwabhe. ");
INSERT INTO nww_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Agha ghoha ghakitendekwa kwa ngungwa mbinda mabhoko kumi ncheche na nhano.” “Mbole ya agho Chapanga kakiapegha alamula ngati bhabhalongohe mbaka mu manjubha gha mbuye ghwa Chapanga ywakakemitwe Samweli. ");
INSERT INTO nww_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ndo bhandu bhakiyupa bhakamuhwe mutwa, naywo Chapanga kakiapegha Shauli mwana ghwa Kishi ghwa likabila lya Benjamini, ywakaalongohite kwa ngungwa mbinda mabhoko ncheche. ");
INSERT INTO nww_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Mbole ya kummua Shauli mu ghubhutwa, Chapanga kakimmika Daudi kabhe mutwa ghwabhe, ywene bhubho Chapanga kakimmoneha pakilongela, ‘Nummona Daudi mwana ghwa Yese, mundu ywakalingana na mwoyo ghwangu, na yunakughatenda mapalu ghangu ghoha.’ ");
INSERT INTO nww_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kuhuma mu ubheleko ghwa mundu aywo, Chapanga kabhayeghela Akaasilaeli Nlopohi ndo Yesu, handa pakalaghite. ");
INSERT INTO nww_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Pakali na Yesu kuyanda lihengo lyake, Yohana kakinlongoha pakilandamia bhandu bha Isilaeli kukita yinguakwiliha kulipetula na kubatiswa. ");
INSERT INTO nww_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yohana pakabheghite mu kuyomolela lihengo lyake, kakiaghombela bhandu, ‘Mwenga munguhwacha kukita nenga ndo ghani? Nenga ndo mwene ng'obhe yumunlindila. Peni, ywene yunakuhika mbole ya nenga, yaanoghelwa ng'obhe nenga mopole ngoyi hya makwobasi gha maghulu ghake.’ ” ");
INSERT INTO nww_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Ma aghanja bhangu Makaaislaeli, kibheleko kya Iblahimu na bhoha munnyitikila Chapanga, lilagho ali lya ulopohi liyeghwa kwa twenga. ");
INSERT INTO nww_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Mana akolannima bha ku Yelusalemu na hilingohi bhabhe bhakinnnamula ng'obhe kukita ywombe ndo nkombohi, hangi bhakimanya ng'obhe malagho gha mambuye ghaasomitwe mu kila Linjubha lya Kupumulila. Hata habhu, bhakitenda malagho gha mambuye ghatwihilike kya kuntosa kiho. ");
INSERT INTO nww_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Hata bhula bhakimokola ng'obhe nhokolo ghwa kuntosa kiho peni bhakinnyupa Pilato kakwilihe kakwomwe. ");
INSERT INTO nww_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Pabhayomolite kutenda ghala ghoha ghatyekitwe ya kya Yesu, bhakinhuluha ku lupingika na kunbhika mulindogholo. ");
INSERT INTO nww_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Peni Chapanga kakinhyuha. ");
INSERT INTO nww_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Naywo mu manjubha matangalo kakiabwitukila bhala bhaalongohanite papamu naywo kuhuma ku Galilaya mbaka ku Yelusalemu. Na hinu abho ndo bhala bhaabhonite na kuaghombela bhandu bha ku Isilaeli. ");
INSERT INTO nww_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Na twenga tuhika apa kubhayeghela Nhalo ghwa Maha. Nnando ghula Chapanga ghwakaalaghiliti ahukulu bhetu, ");
INSERT INTO nww_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","hinu kaghatwihiliha kwa twenga bhana bhabhe kwa kunhyuha Yesu handa payityekitwe mu Sabuli ya ubhili, ‘Ghwenga ndo mwana ghwangu, lelo megha Tate ghwakwo.’ ");
INSERT INTO nww_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kiyaha Chapanga kakin'hyuha Yesu, ngati kakotoke kubhola, pakilongela malagho agha, ‘Kulyaghila ndakupegha ghwenga nonelo yangu ya ung'anyimo, yila yinunnaghilite Daudi.’ ");
INSERT INTO nww_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Handa payityekitwe pamo pangi mukitabho kya Sabuli ‘Ghwanneka ng'obhe nndumitumi ghwakwo ghwa maha kabhole.’ ” ");
INSERT INTO nww_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Hinu, Daudi pakayomolite kutenda handa pakapalite Chapanga kwa bhandu bha nndaluko ghwake, kakihwegha na kakikulilwa ugheghela na atate bhake na mmili ghwake ghukibhola. ");
INSERT INTO nww_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Peni yula ywakayuhitwe na Chapanga kachu kikibhola. ");
INSERT INTO nww_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Kya habhu maalongo bhangu Akaaisilaeli, nungupala mmanye kukita kukindila kwa ayu Yesu ulekekeho ghwa ulemwa ghungulandamihwa kwa mwenga, ");
INSERT INTO nww_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","kukita kukindila kwa ywombe, ywoheli ywaanhyubhalila Yesu kaabhalaghwa kubha na shalia mu hilibhi hyoha ya nga kubhalangwa shaliya mu malaghilo gha Musa ");
INSERT INTO nww_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Habhu, mulindakile ngati ghala ghaalongelitwe na maambuye ghwa Chapanga ghakotoke kuatula: ");
INSERT INTO nww_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Nnolekehe mwenga maabhichi, mukakangache na kuhwegha, kiyaha ndatenda nnando mu manjubha ghenu, lyene maahyubalila ng'obhe hata handa mundu pakaaghombela.’ ” ");
INSERT INTO nww_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulo na Balinaba paabheghite mu kubhuka mu nyumba ya kutundamilila Akaayahudi bhandu bhakiayupa ahike kangi linjubha lya kupumulila akaayahudi liipala kuhika bhabhalandamihe kangi. ");
INSERT INTO nww_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mbole ya kupwilinganika kwa ngwemuko ya Akaayahudi, Akaayahudi atangalo na ahyubhalila bha dini ya Akaayahudi bhakiatughila Paulo na Balinaba paakiyobhela nabho na andumitumi bhakiapegha mwoyo aghendelele kutama mu umaha ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Linjubha lya kupumulila lya ubhili, handa bhandu bhoha bha kitami akyo bhakihika kuyunila lilagho lya Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Peni Akaayahudi pabhalubhonite lula lumati lukulu lya bhandu bhakimemwa tama, ndo bhakikambuka ngambuko ya ngundulo ya kya ghala ghaalongilitwe na Paulo. ");
INSERT INTO nww_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Habhu Paulo na Balinaba bhakiyobhela kwa ukangamalo, paakilongela, “Yikitunoghela kulongela lilagho lya Bambo kwa mwenga huti. Peni kiyaha mungulilema na mungulibhona kukita mungunoghwa ng'obhe kukamuhwa ubhumi ghwa nga kupela, hinu tungualeka na tungubhaghendela bhandu bha nga kubhegha Akaayahudi. ");
INSERT INTO nww_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kiyaha Bambo kakitulaghila pakilongela habhu, ‘Nubhatenda mwenga mubhe lung'ali kwa bhandu bhaabheghite ng'obhe Akaayahudi, Ngati mmokole kubhayeghela bhandu bha milima ulopohi ghwa nga kupela.’ ” ");
INSERT INTO nww_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Bhandu bhaabheghite ng'obhe Akaayahudi payuhwite agha bhakiyelelwa na bhakilikwiha lilagho lya Bambo, na bhoha bhaalingitwe ulami aghu ghwa nga kupela bhakihyubhalila. ");
INSERT INTO nww_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Lilagho la Bambo likikwila mu nnima ghula ghwoha. ");
INSERT INTO nww_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Peni Akaayahudi bhakiakolekela adala bhaahokamilitwe bhaabheghite ng'obhe Akaayahudi bhene bhaayitughilite dini ya Akaayahudi, na bhubho alume ahwadali bha kitami kila. Nabho bhakiyanda kubhabamanda Paulo na Balinaba na bhakiabhingabhinga bhabhuke mu nnima ghwabhe. ");
INSERT INTO nww_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Hinu, Paulo na Balinaba kakipumunda liho mu maghulu ghabhe ngati kupingikiana nabho mbole bhakighenda ku Ikonio. ");
INSERT INTO nww_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Hinu bhala ahundwa bha ku Antiokia bhakimemwa na uyelelo na Nhuki ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Hino akwo ku Ikonio, Paulo na Balinaba bhakiyingila papamu mu kitubhi kya kutundamila Akaayahudi handa payibheghite hitohe hyabhe. Bhakilandamiha kwa ukangamalo nkulu mbaka Akaayahudi atangalo na Akaagiliki bhakihyubhalila. ");
INSERT INTO nww_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Peni amoo bha Akaayahudi bhaalemite kuhyubhalila, bhakiakolekela bhandu bhaabheghite ng'obhe Ayahudi, bhakiayaghabhiha mu myoyo yabhe ngati bhabhapingike bhandu abho. ");
INSERT INTO nww_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Paulo na Balinaba bhakighendelela kutama akwo kwa manjubha matangalo pabhakilandamiha kwa ukangamalo lilagho lya Bambo, naywo Bambo kakibhoneha uhoto ghwa lilagho lyaalilandamihite kwa umaha ghwake, kwa kubhatangatila kutenda naho na mihabho. ");
INSERT INTO nww_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Peni bhandu bha kitami kila bhakimeghekana, bhangi bhakilingana na Akaayahudi na bhangi bhakilingana na Andumitumi. ");
INSERT INTO nww_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Hinu amoo bhandu bhaabheghite ng'obhe Akaayahudi na Akaayahudi, papamu na hilongohi bhabhe, bhakililunga kuatendela Andumitumi uhakata kwa kubhaghuma maganga. ");
INSERT INTO nww_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Andumitumi paamanyite nnando aghwo, bhakitughilila ku Lisitila na Delibe, mu hitami hya Likaonia na mu mbande hya ugheghela ghwake. ");
INSERT INTO nww_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Bhakitama akwo paakilandamiha Nhalo ghwa Maha. ");
INSERT INTO nww_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Pakibhegha mundu yumu ku kitami kya Lisitila, ywene kakibha ngwabhengwabhe kutandila pakabhelekitwe na kakiyigha ng'obhe kutyanga. ");
INSERT INTO nww_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mundu aywo kakinnyihwa Paulo pakilandamiha. Paulo pakanlolekehite kakimmona kana uhyubhalilo ghwa kulamihwa, ");
INSERT INTO nww_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Paulo kakilongela kwa lilobhe likulu, “Ghuyime ghwima kwa maghulu ghakwo!” Kamu yula mundu kakiyima kanongola na kakinyotoka na kutyanga. ");
INSERT INTO nww_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Lula lumati lwa bhandu pabhabhonite ghala ghakatendelite Paulo, bhakiyobha lilobhe kya nongelo ya likabila lyabhe lya Kilikaonia pa bhakilongela, “machapanga bhatuhikila mu libhumbo lya anabhandu.” ");
INSERT INTO nww_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bhakinkema Balinaba, Zeu na Paulo bhakinkema Helime kiyaha mwene ndo ywakabheghite ywa kulongela. ");
INSERT INTO nww_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Naywo ndundame ghwa nyumba ya Zeu ywene kitami kyake kikibha patali kya mandina ya kitami, kakiyegha njonga ywa Senga na hilemba hya malubha mu nlyango nkulu ghwa kitami, kiyaha mwene na lula lumati lwa bhandu lukipala kuayambikila. ");
INSERT INTO nww_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Peni Balinaba na Paulo paayuhwite nhalo aghwo bhakighalakatula mapinda ghabhe na kulitughila lula lumati lwa bhandu kwa kulopokela, bhakiyobha lilobhe likulu, pabhakilongela, ");
INSERT INTO nww_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Maalongo mwenga, kiyaha niki mungutenda nhalo aghu? Twenga twa anabhandu handa mwenga! Tungubhayeghela Nhalo ghwa Maha, pa tukiaghombela kukita mpiluke mughaleke agha ming'omong'omo ghweka na muntughile Chapanga ywakabheghite na ulami, yunakubhumba kunani na milima na mahibha na hyoha hibheghite nkati yake. ");
INSERT INTO nww_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Pamakachu Chapanga kakialeka bhandu bhaabheghite ng'obhe Akaayahudi aghendelele kutyanga mu ghala ghaaghapalite bhene. ");
INSERT INTO nww_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Hata habhu Chapanga kakileka ng'obhe kulibhoneha kwa milando ya maha yakabhatendelite. Kwa kuakomela hula kuhuma ku bhwelo kangubhapegha mabeno kwa nndaluko ghwake, na kuyimemekeha myoyo yenu uyelelo.” ");
INSERT INTO nww_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hata habhu Andumitumi bhakibhinilila kuakanikiha bhandu bhakotoke kubhayambikila nyambi, peni bhakihotola ng'obhe. ");
INSERT INTO nww_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Peni amoo bha Akaayahudi bhakihika kuhumila ku Antiokia na Ikonio kubhakwokeha bhandu bhala, nabho bhakintuta Paulo kwa maganga na bhakinkulubhula mbaka panje ya kitami, bhakihwacha kukita kahwegha kala. ");
INSERT INTO nww_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Peni mbole ya bhaanhyubhalilite Yesu kukwemuka kuntindila kakiyinuka na kakibhuya ku mbwani. Kilabho yake ywombe na Balinaba bhakibhuka kughenda ku Delibe. ");
INSERT INTO nww_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Mbole ya Paulo na Balinaba kulandamiha Nhalo ghwa Maha mu kitami kya Delibe na kuatenda bhandu atangalo bhabhe afwasi bha Kilisito, bhakibhuya ku Listila, kangi bhakibha na mwanja ghungi kughenda ku Antiokia kukindila ku Lustila na Ikonio. ");
INSERT INTO nww_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Bhakibhatengelekeha bhaanhyubhalilite Kilisito bha hitami ahyo na kubhapegha makakala gha mwoyo kukita bhatami maha mu uhyubhalilo. Bhakibhaghombela, “Yitunogha kuyingila mu ghubhutwa ghwa Chapanga kwa kukindila himbamanda hitangalo.” ");
INSERT INTO nww_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Bhakiahaghula akulu mu kila ngwemuko ya bhandu bhaanhyubhalilite Kilisito kwa kuyupa na kulikunga, na mbole bhakibhakamuha kwa Bambo bhaanhyubhalilite. ");
INSERT INTO nww_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Mbole bhakikindila ku Pisidia na bhakihika ku Pamfilia. ");
INSERT INTO nww_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Na mbole ya kililandamiha lilagho lya Chapanga akwo ku Peliga, bhakighenda ku Atalia. ");
INSERT INTO nww_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kubhukila akwo ku Atalia bhakityanga kwa bhwato kubhuya ku Antiokia kwene kandahi bhakiyupilwa unemelo kwa kya kulitenda lihengo lya Chapanga lyene hino bhakilitwihilikia. ");
INSERT INTO nww_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Paahikite ku Antiokia bhakiikema ngwemuko ya bhandu bhaanyubhalilite Kilisito papamu, na kubhalubhulila ghala ghoha ghaatendelitwe na Chapanga kukindila kwa bhombe na kya bhula pakahughulite nlyango ghwa uhyubhalilo kwa bhandu bhaabheghite ng'obhe Akaayahudi. ");
INSERT INTO nww_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Bhakitama akwo papamu na bhala bhaanhyubhalilite Kilisito manjubha matangalo. ");
INSERT INTO nww_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Amoo bhandu kuhuma ku Yudea bhakihika ku Antiokia, bhakiahunda alongo bhaanhyubhalilite Kilisito kukita, “Handa malumulwa ng'obhe unyagho kubhukana na hitohe hyakahundite Musa, maalopoleghwa ng'obhe.” ");
INSERT INTO nww_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Mbole ya Paulo na Balinaba kulema kulingana nabho malobhe, kukibwituka mapingikano makulu, Paulo na Balinaba na amoo bhangi bhaanhyubhalilite Kilisito kuhuma Antiokia bhakihaghulighwa aghende ku Yelusalemu ngati bhakaghombe nnando aghu na andumitumi na aghohi. ");
INSERT INTO nww_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Hinu, ngwemuko ya bhandu bhaanhyubhalilite Kilisito bha ku Antiokia bhakialaghila Paulo na ayake, nabho paabheghite mu mwanja kukindila ku Foenike na Samalia bhakibhalubhulila bhandu bhula bhandu bhaabheghite ng'obhe Akaayahudi pabhanhyubhalilite Yesu. Mihalo ayi yikianogheha muno alongo bhoha. ");
INSERT INTO nww_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Paahikite ku Yelusalemu, bhakikingamwa na ngwemuko ya bhandu bhaanhyubhalilite Yesu na andumitumi na aghohi, ndo Paulo na Balinaba bhakibhalubhulila kila kilibhi Chapanga kyakatendite papamu nabho. ");
INSERT INTO nww_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Peni amoo bhandu bhaanhyubhalilite Kilisito bha kimati kya Akaafalisayu bhakiyima, paakilongela, “Inogha mbaka bhandu bhaabheghite ng'obhe Akaayahudi alumulwe unyagho na bhahundwe kutughila malaghilo gha Musa.” ");
INSERT INTO nww_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Andumitumi na aghohi bhakikongana papamu ngati bhahingukihe nnando aghwo. ");
INSERT INTO nww_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Mbole ya maghombano matangalo, Petili kakiyima na kulongela, “Maalongo bhangu, mwenga mungumanya kukita kalongohi Chapanga kakinhaghula nenga mumwenga hotole kulandamiha Nhalo ghwa Maha kwa bhandu bhaabheghite ng'obhe Akaayahudi ngati bhayihwe lilagho na kuhyubhalila. ");
INSERT INTO nww_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Naywo Chapanga ywakamanya myoyo ya bhandu, kakilaha kukita kabhayitikila kwa kuapegha lilumbo lya Nhuki ghwake handa pakatupeghite twenga. ");
INSERT INTO nww_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Chapanga kakibhika ubhaghulo ng'obhe mu nkati ya twenga na bhombe, ngati kakiyighulula myoyo yabhe kwa uhyubhalilo. ");
INSERT INTO nww_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Hinu kiyaha niki munguyigha kunng'eha Chapanga kwa kubhapapiha mihigho abho bhaanhyubhalila Kilisito yene hukulu bhetu hangi twenga tukihotola ng'obhe kuyighegha? ");
INSERT INTO nww_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Peni yikotoke kubhegha habhu, ngati twenga tunguhyubhalila kukita, twenga handa bhombe, twalopolehwa kwa njila ya umaha ghwa Bambo Yesu.” ");
INSERT INTO nww_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ngwemuko hyoha ya bhandu bhaanhyubhalilite Chapanga yikinyamala jii, paakiayihwa Balinaba na Paulo pakilubhulila mihabho na mang'eha ghakayitendite Chapanga kwa kukindila bhombe kwa bhandu bhaabheghite ng'obhe Akaayahudi. ");
INSERT INTO nww_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pabhayomolite kuyobhela, Yakobu kakilongela, “Maalongo bhangu, munyihwe nenga. ");
INSERT INTO nww_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni katulubhulila kala bhula Chapanga pakaayighayighayilite bhandu bhaabheghite ng'obhe Akaayahudi makachu apwo, kakiahaghula amoo mu bhombe abheghe bhandu bhake. ");
INSERT INTO nww_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Malagho gha Ambuye bha Chapanga ghangulandana na nhalo aghu, handa payityekitwe, ");
INSERT INTO nww_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Bambo kangulongela, ‘Mbole ya mihalo ayi ndaabhuya, na kuchenga kangi nyumba ya Daudi kiiboghoyokiti, ndatendekeha kangi uhyono mang'obha, na ndakitenda hitengeleke kangi, ");
INSERT INTO nww_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ngati bhandu bhangi bhoha amokole kuntughila Bambo, Na bhandu bhoha bhaabheghite ng'obhe Akaayahudi bhaabhakemite bhabhe bhake bhaanpalaha Bambo. ");
INSERT INTO nww_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Kangulongela Bambo, ywakaghatendite agho ghoha kutandila makachu.’ ” ");
INSERT INTO nww_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakobu kakighendelela kulongela, “Kya habhu, ulamulo ghwa nenga ndo aghu, tukotoke kubhaghaha bhandu bhaabheghite ng'obhe Akaayahudi bhaanng'alambukila Chapanga kwa hitohe hyetu. ");
INSERT INTO nww_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kihyengo kyake, tubhatyekele lihamba kukita bhalindakile na kulyegha hilibhi hiikanikihitwe na Chapanga kwa kuyambikila ming'omong'omo ya machapanga bhangi, bhalindakile na ungongola na bhakotoke kulyegha hiponge hya anyama bhapopotolitwi na bhakotoke kunywegha mwahi. ");
INSERT INTO nww_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kiyaha kwa ngungwa ndangalo malagho gha Musa ghakilandamihwa mu milima hyoha na kusomwa mu hitutubhi hya kutundamila Akaayahudi kila linjubha lya kupumulila.” ");
INSERT INTO nww_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Akaandumitumi na akulu papamu na bhandu bhoha bha ngwemuko ya bhandu bhaanhyubhalilite Kilisito bha Ku Yelusalemu, bhakiahaghula amoo bha bhandu na kualaghila ku Antiokia papamu Paulo na Balinaba. Bhakinhaghula Yuda ywakemitwe Balisaba na Sila, bhoha bhakimanyikwa na bhakibhegha akulu munu nkati ya alongo, ");
INSERT INTO nww_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","na bhakilaghilwa na bhakiapegha lihamba liityekitwe habhu, “Twenga ndo twaandumitumi na aghohi bha ngwemuko ya bhandu bha anhybhalilite Kilisito ghwa ku Yelusalemu, akaalongo bhenu, tungubhajambua mwenga maalongo mummeghite ng'obhe Akaayahudi mummeeghiti akwo ku Antiokia, Silia na ku Kilikia. ");
INSERT INTO nww_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kiyaha tuyihwa kukita amoo bhandu kuhumila kwa twenga bhakihika kwa mwenga na bhabhatindingana kwa malagho ghabhe kya nga kulaghilwa na twenga. ");
INSERT INTO nww_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Habhu tulamula twabhoha kubhahaghula bhandu bhamandina na kualaghila kwa mwenga papamu na apalo bhetu Balinaba na Paulo, ");
INSERT INTO nww_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","bhene bhaalibhikite kala kuhwegha kwa kya Bambo ghwetu Yesu Kilisito. ");
INSERT INTO nww_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kya habhu tungualaghila Yuda na Sila kwa mwenga, abha bhaabhaghombela kwa ngulu yabhe ghala ghatughatyekite, ");
INSERT INTO nww_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","kiyaha yinnogha Nhuki ghwa Chapanga na twenga tukotoke kuatwika nhigho ghwoheli kupitingana kwa milando ayi yiinoghwa kutendekwa. ");
INSERT INTO nww_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Nkotoke kulyegha hilyo hyaayambikilitwe machapanga, nkotoke kunywegha mwahi ebu hipongi hya anyama bhaapopotolitwe na mulindakile na ungongola. Matenda gha maha handa panntyegha kutenda milando ayi. Mwika.” ");
INSERT INTO nww_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Habhu bhakilaghwa bhala ajumbe, bhakighenda ku Antiokia, mbole ya kuatamiha papamu ngwemuko ya bhandu bhaanhyubhalilite Kilisito, bhakiapegha lila lihamba. ");
INSERT INTO nww_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bhandu pabhasomite, bhakiyelelwa munu kya lila lilagho lya kuamemekeha mwoyo. ");
INSERT INTO nww_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda na Sila, bhene nabho bhakibha mambuye bha Chapanga bhakikambuka malagho matangalo gha kubhamemekeha mwoyo na kubhatengeleha mu uhyubhalilo kwa bhala alongo bhaanhyubhalilite Kilisito. ");
INSERT INTO nww_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Mbole ya kutama akwo ku Antiokia manjubha gha mandina, bhandu bhaanhyubhalilite Kilisito bha akwo bhakialagha kwa uhihimilo abhuye kula kwaalaghilitwi. ");
INSERT INTO nww_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Peni Sila kakibhona maha katame ukwako akwo. ");
INSERT INTO nww_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Peni Paulo na Balinaba bhakihighala akwo Antiokia pakiahunda na kulilandamiha lilagho lya Bambo papamu na bhandu bhangi atangalo. ");
INSERT INTO nww_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mbole ya manjubha gha mandina, Paulo kakinng'ombela Balinaba “Tubhuye tukaatyangile alongo bhaanhyubhalilite Chapanga mu hitami hituhilandamihite lilagho lya Bambo tukabhalole kya paaghendelela” ");
INSERT INTO nww_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Balinaba kakipala bhantole Yohana ywakakemitwe Maliki bhaghende papamu. ");
INSERT INTO nww_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Peni paulo kakilema kughenda na Maliki kiyaha kandahi kakialeka paabheghite akwo ku Pamufilia, na kakilema kutenda lihengo papamu nabho. ");
INSERT INTO nww_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Bhakilandana ng'obhe malobhe Paulo na Balinaba kya nhalo aghwo, habhu bhakilekana. Balinaba kakintola Maliki na bhakikwela bhwato na bhakighenda ku Kipulo kukindila njila ya mulihibha. ");
INSERT INTO nww_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Peni Paulo kakinhaghula Sila na kakibhuka naywo, mbole ya alongo bhaanhyubhalilite Kilisito kuayupila umaha ghwa Bambo ghubhe papamu nabho. ");
INSERT INTO nww_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Paulo kakikindila ku milima ya Silia na Kilikia, pakatengelekeha ngwemuko ya bhandu bhaanhyubhalilite Kilisito. ");
INSERT INTO nww_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo kakihika ku Delibe na mbole ku Lisitila, kwene kukibha na nhyubhalila ghwa Kilisito yumu lihina lyake Timotheo, ywene ma ghwake kakibha Nnyahudi ywakahyubhalilite, peni tate ghwake kakibha N'giliki ");
INSERT INTO nww_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timotheo kakitikwa munu na bhala bhaanhyubhalilite Kilisito bha ku Lisitila na bha ku Ikonio. ");
INSERT INTO nww_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo kakinpala Timoteo kalongohane naywo, habhu kakintola na kunlumula unyagho kiyaha Akaayahudi bhaatamite pala bhoha bhakimmanya kukita tate ghwa Timoteo kakibha N'giliki. ");
INSERT INTO nww_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Hinu pabhatyangiteghe mu hitami kwa hitami bhakiapegha bhandu bhaanhyubhalilite Kilisito malaghilo ghaakamuhitwe na andumitumi na aghohi bha ngwemuko ya bhandu bhaanhyubhalilite Kilisito bha akwo ku Yelusalemu ngati bhaghakamulile. ");
INSERT INTO nww_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Habhu, ngwemuko ya bhandu bhaantughilite Kilisito yikichweha kutengeleheka muuhyubhalilo na kuyonjokeheka mummalango manjubha ghoha. ");
INSERT INTO nww_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Mwanja ghwa Paulo na ayake ghukikindila mbande ya ku Filigia na ku Galatia, kunu pabhakikanikihwa na Nhuki ghwa Chapanga kukita bhakotoke kulandamiha Lilagho akwo ku Asia. ");
INSERT INTO nww_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pabhahikite ku mbakilo ya Misia, bhakiyigha kuyingila ku Bitinia peni Nhuki ghwa Yesu kakibhategheka ng'obhe. ");
INSERT INTO nww_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Hinu, bhakighololela kukindila ku Misia bhakighenda mbaka ku Toloa. ");
INSERT INTO nww_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Pakilo Chapanga kakimmoneha Paulo kilibhi kukita mundu ywa ku Mekodonia kayima pakimpembeleha na kunng'ombela, “Ghuyomboke ghuhike ku Mekodonia ngati ghututange!” ");
INSERT INTO nww_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Mbole ya Paulo kubhona mabhono agho, kamu tukilibhika kala kubhuka kughenda ku Mekodonia patuhyubhalila kukita kulyaghila Chapanga katukema kulandamiha Nhalo ghwa Maha akwo. ");
INSERT INTO nww_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kubhuka ku Toloa tukibha na mwanja ghwa mulihibha kwa bhwato mbaka ku Samotalake, na kilabho yake tukihika ku Neapoli. ");
INSERT INTO nww_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Na kuhumila apwo tukighenda mbaka ku Filipi, kitami kihwadali kya ku Mekodonia nnima ghuutabhalitwe na Akaaloma, na tukitama apwo pamanjubha gha mandina. ");
INSERT INTO nww_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Linjubha lya kupumulila tukighenda panji ya kitami mu mbwegha ya lukemba, tukihyubhalila pangi twapakolela pakuntundamila Chapanga. Tukitama na kuyanda kuyobhela na amoo adala bhaakwemukite akwo. ");
INSERT INTO nww_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Yumoo ywa bhala adala bhaatuyuhwite lihina lyake kakikemwa Lidia ntundamila ghwa Chapanga, Nchuhusa mapinda ya salabati na nkolannima bha kitami kya ku Tiatila. Bambo kakighuhughula mwoyo ghwake na kakighakingama malagho ghakaghalongiliti Paulo. ");
INSERT INTO nww_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Mbole ya ywombe na bhalubhagha lyake lwoha kubatiswa, kakitulalika ku lubhagha lwake na kulongela, “Handa hoto mmona nu hyubhalila ghwa Bambo, nunguayupa tughende mukatame ku lubhagha lwangu,” Naywo kakitunyegheleha. ");
INSERT INTO nww_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Linjubha limu patubheghite tungughenda pakunnyupa Chapanga, tukikongana na mbhandwa yumu nhinja yunalindilu lya ulondohi. Na akangwana bhake bhakimokola mapongolo matangalo gha ngalabha kwa kya ulondohi ghwake. ");
INSERT INTO nww_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Hino, nhinja aywo kakintughila Paulo na twenga kunu pakiyobha kyobho, pakilongela, “Bhandu abha ndo andumitumi bha Chapanga ywa Kunani Munu, bhombe bhangualandamiha mihalo ya njila ya ulopohi.” ");
INSERT INTO nww_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Kakighendelela kutenda habhu mumanjubha matangalo, kuuhiko Paulo kakiyaghabhala munu, kakighalambuka na kunng'ombela yula lindilu “Nungukukwilikiha kwa lihina lya Yesu Kilisito, ghummuke nhinja aywo!” Kamu lila lindulu likimmuka yula nhinja. ");
INSERT INTO nww_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Angwana bhake pabhabhonite kukita nyubhalilo yabhe ya kumokola ngalabha lihobha, bhakiakamula Paulo na Sila, bhakiaghegha mbaka kuligulio mu ulongolo ghwa akulu bha kitami. ");
INSERT INTO nww_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Mbole ya kuaghegha mu ulongolo ghwa adumula nongwa bhakiakokela paakilongela, “Bhandu abha ndo Akaayahudi na bhangughegha bhulwa mukitami kyetu. ");
INSERT INTO nww_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bhanguhunda hitohe hyene twenga Akolannima bha Kuloma tunguteghekwa ng'obhe kuhiyitikila na kuhitughila.” ");
INSERT INTO nww_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Lumati lwa bhandu lukililunga mukuapukila Paulo na Sila. Na bhala adumula nongwa bhakikwilikiha bhahulwe mapinda ghabhe na ahyatwe hinjupunjupu. ");
INSERT INTO nww_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Mbole ya kubhahyata munu bhakibhahwinda ku kibhopo na bhakinkwilikiha nkulu ghwa kibhopo kaakingikihe maha. ");
INSERT INTO nww_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kubhukana na ngwilikiho ahyo, yula nkulu ghwa kibhopo kakibhakwinda mu kyumba kya nkati munu mwa kila kibhopa na kakiabhopa maghulu ghabhe kwa ngimiko ngulu. ");
INSERT INTO nww_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Payihegheghelite pakilu kati, Paulo na Sila bhakibha bhanguyupa na kunyimba miyimbo ya kuntika Chapanga, na abhopwa bhangi bhakibhegha paabhayuhwa. ");
INSERT INTO nww_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Pindulu pakibwituka ngwangaliko ngulu ya lutupi na kutikiha ndamiko ya kibhopo. Kamu milyango ya kibhopo yikihughuka na yila minyololo ya bhoha yikibhopoka. ");
INSERT INTO nww_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Yula nkingikiha kibhopo pakalilimukiti mu ng'ono na kubhona milyango ya kibhopo yikibhegha lipala, kakipala kulikoma kwa ngechelo yake, kiyaha mwene kakihwacha kukita abhopwa bhoha bhakinyelembuka. ");
INSERT INTO nww_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Peni Paulo kakikema kwa lilobhe likulu, “Ghukotoke kulikoma kiyaha twabhoha twenga tubhegha bahapa.” ");
INSERT INTO nww_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Yula machonda ghwa kila kibhopo kakilaghila liyeghwe limbamba, na kakiyingila mula nkati ya kila kyumba kya kibhopo, na kakiachutamila mayughwa Paulo na Sila kunu pakaloghoya. ");
INSERT INTO nww_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Mbole kakiabhuha panji pakilongela, “Maabambo bhangu, ndende niki ngati mbate kulopoka?” ");
INSERT INTO nww_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bhombe bhakinnyanga, “Ghunhyubhalile Bambo Yesu Kilisito, ghwenga na bhalubhagha lwakwo lwoha maalopolehwa.” ");
INSERT INTO nww_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Hino, bhakinlandamiha lilagho lya Bambo mwene papamu na bhandu bhangi bha mulubhagha lwake. ");
INSERT INTO nww_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Lisaa lilalila lya pakilo yula machonda ghwa kibhopo kakiatola na kakiaghulula mabhanga ghabhe, mbole kakibatiswa ywombe papamu na bhoha bhaabheghite mu lubhagha lwake kya nga kukabhalila. ");
INSERT INTO nww_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Mbole kakiatola Paulo na Sila kulubhagha lwake, kakiakeyela hilyo, mwene papamu na lubhagha lwake lwoha bhakiyelelwa munu kiyaha bhangunhyubhalila Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pakucheghite bhala adumula nongwa bhakialaghila akulu bhabhe kwa nkingikiha ghwa kibhopo paakilongela, “Mubhabhopole bhala bhandu, na mualeke aghende.” ");
INSERT INTO nww_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Yula nkingikiha ghwa kibhopo kakinng'ombela Paulo, “Adumula nongwa bhanngwilikiha nibhalekekehe, habhu mmuke kwa uhihimilo.” ");
INSERT INTO nww_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Peni Paulo kaking'aka, “Bhatututa pa kindandabhanji na kutuhwinda kukibhopo kya nga kututendela nongwa yetu ebu kutukonya, hata patubhele twenga twaakolannima bha ku Loma. Na hinu bhangupala kutubhuha mukibhopo kwa mbwepo! Ng'obhe! Inogha mbaka bhene ahike apa bhatubhuhe amu mukibhopo.” ");
INSERT INTO nww_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Bhala akulu bha akingika kibhopo bhakibhuya na kuaghombela bha adumula nongwa malagho ghala, nabho paayihwite kukita Paulo na Sila bhakibha akolannima bha ku Loma bhakiyoghopa. ");
INSERT INTO nww_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Habhu, bhakighenda kulipetula, bhakiabhuha mukibhopo na bhakibhayupa abhuke mukitami kila. ");
INSERT INTO nww_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Mbole ya Paulo na Sila kubhuka mu kibhopo bhakighenda kulubhagha lwa Lidia, akwo bhakikongana na alongo bhaanhyubhalilite Kilisito, na bhakiyobhela nabho malagho gha kuayonjokeha mwoyo, ndo bhakibhuka. ");
INSERT INTO nww_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulo na Sila bhakikindila ku Amfipoli na ku Apolonia mbole bhakihika ku Sesalonike, na akwo kukibhegha na nyumba ya kutundamila Akaayahudi. ");
INSERT INTO nww_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Handa payibheghite kitohe kya Paulo, kakiyingila mu nyumba ya kutundamila Akaayahudi, mu kila linjubha lya kupumulila mu nnongoano ghwa majuma mandatu kakighombana nabho ya kya matyeko gha Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Kakialubhulila pekupeku kubhoneha kukita yikinkwiliha Kilisito kubamandwe huti na mbole kuhyuka, kakiaghombela, “Aywo Yesu yunubhaghombela mihalo yake, ywombe ndo Kilisito.” ");
INSERT INTO nww_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Amoo Akaayahudi bhakihyubhalila, bhakililunga papamu na Paulo na Sila, ubhwabhu mmalango nkulu ghwa Akaayunani bhaannyitikilite Chapanga papamu na adala atangalo ahwadali, bhakililunga nabho. ");
INSERT INTO nww_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Peni Akaayahudi bhanhyubhalilite ng'obhe Kilisito bhakiyingilwa na tama, bhakighenda mu ligulio na kuakoka bhandu ahakata, bhakiakungana bhandu atangalo, mbole bhakiyanda kutenda bhulwa mu kitami kyoha. Bhakilupukila lubhagha lwa Yasoni kuapalaha Paulo na Sila ngati bhabhagheghe pakindandabhanji. ");
INSERT INTO nww_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Peni bhakibhakolela ng'obhe na habhu bhakinkwakaha Yasoni na bhandu bhangi bhaanhyubhalilite Kilisito mbaka kwa atabhala bha kitami kunu paachobha kyobho, “Bhandu abha abhegha bhangutindingana nnima ghwoha na hino ahika apa pakitami, ");
INSERT INTO nww_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","naywo Yasoni kakiakingama mu lubhagha lwake. Abha bhoha bhanguyikiluka ngwilikiho ya Kaisali, paakilongela kabhegha mutwa yungi, lihina lyake Yesu.” ");
INSERT INTO nww_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Pabhayihwite agho, atabhala bha kitami na lumato lya bhandu bhakiyingihwa bhwaghalili. ");
INSERT INTO nww_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Bhakiatosa lihombo Yasoni na ayake, mbole bhakialekekeha aghende. ");
INSERT INTO nww_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Payihikiti pakilo, bhala alongo bhaanhyubhalilite Kilisito bhakialaghila Paulo na Sila aghende ku Beloya. Pabhahikite akwo bhakighenda ku nyumba ya kuntundamila Akaayahudi. ");
INSERT INTO nww_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Akaayahudi abho bha ku Beloya makutu ghabhe ghakibha kala kuyihwa kupitingana kwa bhandu bha ku Sesalonike, kiyaha bhakilikingama lila lilagho kwa unogho nkulu na kughahingukiha matyeko manjubha ghoha ngati kubhona ghakalongelite Paulo na Sila ghabha gha hoto. ");
INSERT INTO nww_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Akaayahudi atangalo bhakihyubhalila papamu na adala ahwadali Ayunani na alume bhubho. ");
INSERT INTO nww_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Peni bhala Akaayahudi bha ku Sesalonike paayihwite kukita Paulo kangulandamiha lilagho lya Chapanga akwo ku Beloya, bhakighenda ukwaku na kuyanda kutenda bhulwa na kuakolekeha himato hya bhandu. ");
INSERT INTO nww_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kya kuyumbatika bhala bhandu bhaanhyubhalilite Kilisito bha ku Beloya bhakinlongoha Paulo kaghende kumbwegha ya lihibha, peni Sila na Timoteo bhakihighala ku Beloya. ");
INSERT INTO nww_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bhala bhaanlongohite Paulo bhakighenda naywo mbaka ku Asene, mbole bhakibhuya ku Beloya paakibha na malaghilo kuhuma kwa Paulo kukita Sila na Timotheo bhanntughila kanongola kya kulopokela. ");
INSERT INTO nww_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulo pakabheghite mu kualindila Sila na Timoteo akwo ku Asene, mwoyo ghwake ghukiyaghabhala muno pakabhonite nnima ghula ghumema ming'omung'omu ya machapanga. ");
INSERT INTO nww_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Hino kakighombana nabho bhala bhakakonganite nabho Akaayahudi na bhandu bhaabheghite ng'obhe Akaayahudi bhaantundamilite Chapanga kila linjubha na munyumba ya kutundamila Akaayahudi na mu hindandabhanji. ");
INSERT INTO nww_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bhandu bhangi Bhaamayikite Aepikuleo na Aesitoiki bhakipingikihana naywo. Bhangi bhakilongela, “Aywo kangupala kulongela niki? Yunakukwayuka.” Bhangi bhakilongela, “Yibha handa kangulandamiha mihalo ya machapanga ahenja.” Bhakilongela agha kiyaha Paulo kakibha kangulandamiha Nhalo ghwa Maha ghwa Yesu na uhyuko ghwa bhaahweghite. ");
INSERT INTO nww_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Hinu bhakinng'egha Paulo mu libalasa lya Aleopago, na bhakinkonya, “Bhuli twahotola kughamanya mahundo agha gha hyono ghaghughahunda ndo niki? ");
INSERT INTO nww_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ghwenga ghughegha mihalo ya hyono mumakutu ghetu, habhu ghutufwambulile fwambulo yake ndo niki?” ");
INSERT INTO nww_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Kiyahabhandu bha ku Asene na akolannima bha bhoha bhaatamite amwo bhakitendagha ng'obhe nnando ghungi maha nga kulubhulila na kuyihwa milando yiibheghite ya hyonohyono. ");
INSERT INTO nww_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ndo Paulo kakiyima pakati ya libalasa lya Aleopago na kakilongela, “Mwenga akolannima bha ku Asene! Nenga nunguabhona kukita mwenga ndo bhandu bha dini muno. ");
INSERT INTO nww_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kiyaha pameghite mukutyanga kunu na kula na kubhinilila kulolekeha hilibhi himuhitundamila, nikibhona akwo lukuta lumu luutyekitwe, ‘KWA CHAPANGA YWA NGA KUMANYIKWA.’ Hinu kila kimukitundamila kyanga kukimanya, akyo ndo kinikilandamiha. ");
INSERT INTO nww_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Chapanga ywakabhumbite nnima na ghoha ghaabheghite nkati yake, ywene ndo Bambo ghwa kunane na ghwa ku nnima, ywene katama ng'obhe mu Nyumba ya kutundamila yiichengitwe kwa mabhoko gha anabhandu. ");
INSERT INTO nww_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Kiyaha mwene kakighabhumba ghoha, habhu kangupala ng'obhe kilibhi kyohele kiitendikihitwe kwa mabhoko gha anabhandu kiyaha mwene ndo ywakaapegha ulami hibhumbe hyoha, kanguapegha kukeka na kuapegha hilibhi hyoha. ");
INSERT INTO nww_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kuhuma kwa mundu yumu, kakiabhumba bhandu bha milima hyoha ngati bhayitamile milima hyoha, naywo kakibhika nndaluko ghwa kutama. ");
INSERT INTO nww_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Kakitenda habhu ngati bhandu bhanpalahe, na pangi bhanhikila kwa njila ya kupapaha papaha. Hata habhu Chapanga kabha ng'obhe kutali na kila yumoo ywetu. ");
INSERT INTO nww_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Handa pakalongite mundu yumo, ‘Kiyaha mu ywombe, tungulama, tungutyanga, na kubhegha handa mutubheghiti Na handa ahumbula miyimbo bhenu paalongelite, Twenga ndo twabhana bhake.’ ");
INSERT INTO nww_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Hinu, twenga tu bhana bha Chapanga, yinoghelwa ng'obhe kughuhwachila Ghuchapanga ghwake ghubha handa ling'omung'omu lya lihabha, ebu ngalabha ebu liganga lihongolitwe, agho mang'omu ng'omu ghangutendekehwa kwa utendehi ghwa anabhandu. ");
INSERT INTO nww_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Pamakachu ghala gha ubhughabhugha Chapanga kakilitenda handa bhula kangubhona ng'obhe, peni hinu kanguakwilikiha bhandu bhoha kwoheli bhalipetule na kughuleka ulemwa. ");
INSERT INTO nww_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kiyaha kalibhika linjubha lya kuatosa bhandu bha milima hyoha kwa umaha kukindila kwa mundu yumu ywakanhaghulite. Kwa kya ywombe Chapanga kabhayimiha bhandu bhoha kwa kunhyuha Kilisito kuhuma kwa bhaahweghite.” ");
INSERT INTO nww_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Paayihwite nhalo ghwa uhyuko ghwa bhaahweghite, amoo bhabhe bhakinnyuyuha, peni bhangi bhakilongela, “Tungupala tughuyihwe kangi ya kya nnando aghu.” ");
INSERT INTO nww_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Habhu, Paulo kakibhuka na kualeka apwo pa libalasa ");
INSERT INTO nww_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Peni amoo bhabhe bhakililunga naywo bhakinhyubhalila, mu bhene akibhegha Deonisio ghwa libalasa lya Aleopago, na nndala yumu lihina lyake Damali na bhangi atangalo. ");
INSERT INTO nww_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Mbole ya agho, Paulo kakibhuka ku Asene na kakighenda ku Kolinto. ");
INSERT INTO nww_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Akwo ku Kolinto kakikongana na Nnyahudi yumu, nkolannima ghwa ku Ponto lihina lyake Akila, mwene kakihumila ku Italia papamu na nhumbu ghwake Pilisila, kiyaha Kilaudio kakikwilikiha Akaayahudi bhoha bhabhuke ku Loma. Paulo kakighenda kuabhona, ");
INSERT INTO nww_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","naywo kiyaha kakibha ntendehi ghwa kutendekeha mahema handa bhombe, Paulo kakitama na kakitenda lihengo papamu nabho. ");
INSERT INTO nww_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kila linjubha lya kupumulila Paulo kakighombana nabho na kakikakalika kuahuta Akaayahudi na Akaayunani. ");
INSERT INTO nww_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Mbole ya Sila na Timoteo kuhika kuhumila ku nnima ghwa Makedonia, Paulo kakighatola masaa ghake ghoha kwa kya kulandamiha, kakibhaghombela Akaayahudi kukita Yesu ndo Kilisito. ");
INSERT INTO nww_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Peni Akaayahudi Paampingite na kuyanda kunligha, kakighapumunda mapinda ghake mu hibhungi hyabhe pakilongela, “Panhobha, mani mabhene nenga megha na ubhayo ng'obhe kwa nhalo aghu. Na kutandila hinu ndabhaghendela bhandu bhaabheghite ng'obhe Akaayahudi.” ");
INSERT INTO nww_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Hinu, kakibhuka apwo na kakighenda kutama ku lubhagha lwa Tito Yusito ywakabheghite ng'obhe Nnyahudi, ngati kakibha mundu yunakuntundamila Chapanga. Nyumba yake yikibha ugheghela na Nyumba ya kutundamila Akaayahudi. ");
INSERT INTO nww_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kilisipo, n'kulu ghwa nyumba ayo ya kutundamila Akaayahudi, mwene papamu na lubhagha lwake lwoha bhakin'hyubhalila Bambo. Nabho Akaakolinto atangalo bhaaghuyuhwite Nhalo aghwo bhakinhyubhalila Kilisito na kubatiswa. ");
INSERT INTO nww_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Pakilo pamu Bambo kakimmoneha Paulo kilibhi pakilongela, “Ghukotoke kuyoghopa, ghughendelele kulandamiha kya nga kudumuka mwoyo, ");
INSERT INTO nww_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Kiyaha nenga megha papamu na ghwenga. Kahone mundu ywa kughupukila na kughuteluha kiyaha apa pa mbwani pabhegha bhandu atangalo bha mbande ya nenga.” ");
INSERT INTO nww_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Hinu, Paulo kakitama akwo kwa ngungwa yimu na myehi sita, pakihunda lilagho lya Chapanga mu bhombe. ");
INSERT INTO nww_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Peni Galio pakabhegite nkulu ghwa nkoa ghwa ku Akaya, Akaayahudi bhakililunga bhakinpukila na bhakinkamula Paulo na kunng'egha ku libalasa. ");
INSERT INTO nww_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Bhakinkokela paakilongelela, “Mundu ayu kanguanyegheleha bhandu bhantundamile Chapanga kihengele nyuma na malaghilo.” ");
INSERT INTO nww_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pakali na kulongela Paulo, Galio kakiaghombela Akaayahudi, “Nnyuhwe mwenga Makaayahudi, handa munkokela mundu ayu kwa kya ukiluko ebu uhokelo, apwo yingabheghite tela kwa nenga kubhayihwa. ");
INSERT INTO nww_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Peni handa nongwa yeni yibha mbingiko ya malagho na mahina na malaghilo ghenu, nlamule mabhene. Nenga mbala ng'obhe meghe nlamula ghwa nhalo aghu!” ");
INSERT INTO nww_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ndo kakiabhingabhinga abhuke mula mu libalasa. ");
INSERT INTO nww_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ndo bhoha bhakinkamula Sositene ywakabheghite kilongohi ghwa nyumba ya kutundamila Akaayahudi, bhakintuta palapala paulongolo ghwa libalasa. Peni Galio kakibhayuyuha kwa nnando aghwo kakiabhughana. ");
INSERT INTO nww_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo kakitama na bhala bhaanhyubhalilite Kilisito bha akwo ku Kolinto kwa manjubha matangalo. Mbole kakialagha, kakikwela bhwato kakighenda ku Silia papamu na Pilisila na Akila. Paahikite ku Kenkelea Paulo kakimogha hwili hyake kwa kya kutwihilikiha kilapo kyake mu ulongolo ghwa Bambo. ");
INSERT INTO nww_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Paahikite ku Efeso, Paulo kakialeka Plisila na Akila akwo, peni ywombe kakiyingila mu nyumba ya kutundamila Akaayahudi na pakighombana nabho Akaayahudi. ");
INSERT INTO nww_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bhandu bhakinnyupa katame nabho kwa manjubha matangalo peni ywombe kakilema. ");
INSERT INTO nww_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Peni pakabheghite mukubhuka, kakilongela, “Handa pakapala Chapanga Ndaabhuya kangi.” Kakibhuka ku Efeso kwa bhwato. ");
INSERT INTO nww_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Na pakahikite ku Kaisalia, Paulo kakighenda ku Yelusalemu kuyijambua ngwemuko ya bhandu bhaanhyubhalilite Kilisito, mbole bhakighenda ku Antiokia. ");
INSERT INTO nww_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Mbole ya kutama akwo kwa manjubha gha mandina, kakibhuka kughenda kuatengelekeha ahundwa bha nnima ghwa ku Galatia na Fuligia. ");
INSERT INTO nww_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nnyahudi yumu ywakakemitwe Apolo, mmelekwa ghwa ku Alekisandilia kakihika ku Efeso, kakibha mundu yunamakakala makulu gha kuyobhela na kangi nhwadali ghwa kughamanya matyeko gha Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Kakihundwa njila ya Bambo, naywo kakibha kangukakalikila mu Nhuki, kakihunda telatela ya kya Yesu hata payibheghite kakighumanya nga ubatiso ghwa Yohana ndu. ");
INSERT INTO nww_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolo kakiyanda kuyobhela kwa ukangamalo nkulu mu nyumba ya kutundamila Akaayahudi. Peni Pilisila na Akila paannyuhwite bhakinlalika kulubhagha lwabhe na bhakinhunda njila yakailahite Chapanga kwa umaha nalumu. ");
INSERT INTO nww_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolo pakalamuliti kughenda ku Akaya, alongo bha ku Efeso bhakintangatila kwa kunpegha lihamba ngati bhankingame. Pakahikite akwo kakiatangatila muno bhala bhene kubhukana na umaha ghwa Chgapanga bhakinhyubhalila Kilisito. ");
INSERT INTO nww_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kiyaha kwa uhwadali nkulu kakighendelela kuadangula Akaayahudi muhindandabhanji pakilaha kwa matyeko mang'anyimo kukita Yesu ndo Kilisito. ");
INSERT INTO nww_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolo pakabheghite ku Kolinto, Paulo kakighenda ku nnima ghwa Asia, na kakihika ku Efeso na akwo kakiabhona ahundwa bha mandina. ");
INSERT INTO nww_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Kakiakonya, “Bhuli, pamunhyubhalilite Kilisito mukinkingama Nhuki ghwa Chapanga?” Nabho bhakinnyanga, “Aka kaa! Tunayihwa ng'obhe kukita kabhegha Nhuki ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Kangi Paulo kakiakonya, “Hinu mukibatiswa ubatiso ghwoki?” Bhombe bhakinnyanga, “Tukibhatiswa ubatiso ghwa Yohana.” ");
INSERT INTO nww_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paulo kakilongela, “Ubatiso ghwa Yohana ghukibha ghwa kulaha kukita bhandu bhalipetula. Na kakiaghombela bhandu kukita bhanhyubhalile yula ywakapala kuhika mbole ya mwene, aywo ndo Yesu.” ");
INSERT INTO nww_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Paayihwite agho, bhakibatiswa kwa lihina lya Bambo Yesu ");
INSERT INTO nww_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Hinu, Paulo kakiayabhikila mabhoko unane mwa mitwe ya bhandu bhala, na Nhuki ghwa Chapanga kakiahulukila, bhakiyanda kulongela kwa nongelo ya hyono na kulandami Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Mmalango ghwa bhandu bhaabheghite pala bhakibha alumi kumi na abhili. ");
INSERT INTO nww_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Kwa myehi mindatu Paulo kakibha pakiyingila mu nyumba ya kutundamila Akaayahudi pakibha na maghombano gha kuahuta ngati bhaghuhyubhalile milando ya kya Ghubhutwa ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Peni bhangi kwa ngakataho bhakilema kuhyubhalila pakililigha lilagho lyake mu lumati lwa bhandu, peni Paulo kakilekana nabho kakiatola ahundwa na kughombana nabho manjubha ghoha mu lidalasa lya kuhundila lya mundu yumo ywakakemitwe Tilano. ");
INSERT INTO nww_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Kakighendelela kutenda habhu mu ngungwa ibhili mbaka bhandu bhoha bha ku Asia, papamo na Akaayahudi na bhandu bhaabheghite ng'obhe Akaayahudi bhakiyihwa lilagho lya Bambo. ");
INSERT INTO nww_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Chapanga kakitenda mihabho mikulu kwa kukindila Paulo. ");
INSERT INTO nww_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Mbaka hilemba na mapinda ghangi ghaakamulitwe na Paulo hikibhikwa unani mwa atamwa nabho bhakilama utamwa ghwabhe na mandilu ghakiabhuka. ");
INSERT INTO nww_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Bhakibhegha Akaayahudi bhamo bhanakupungila mandilu, bhakikinda akwo na akwo paayigha kukambuka lihina lya Bambo Yesu kwa bhala bhaakwelitwe na mandilu, paakilongela, “Kwa lihina lya Yesu yula ywakalandamihwa na Paulo, nungughukwilikiha ghubhuke.” ");
INSERT INTO nww_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Bhangi bhaatenditeghe habhu bhakibhegha bhana alume saba bha Sikewa, yumoo ywabhe ywa akulu bha andundame bha Akaayahudi. ");
INSERT INTO nww_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Peni linjubha limu mandilu bhakiayanga bhana bha Sikewa, palikilongela, “Yesu tungunmanya na Paulo ubhwabho, peni mwenga ndo akina ghani?” ");
INSERT INTO nww_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Mbole yula mundu ywakakwelitwe na mandilu kakiahumbila na kakiahotola makakala. Na bhakibhuka panji ya yilala nyumba paakitugha lubhilo ngelenge kunu bhakibha na mabhanga. ");
INSERT INTO nww_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Nhalo ghwo ghukimanyikwa kwa Akaayahudi bhoha na Akaayunani bhaatamiteghe ku Efeso, bhoha bhakimemwa lyogha na bhakilikweha lihina lya Bambo Yesu. ");
INSERT INTO nww_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bhandu atangalo bhaanhyubhalilite Kilisito bhakilibhoneha mu hindandabhanji pa bhakilipetula uhakata ghwabhe. ");
INSERT INTO nww_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Mmalango nkulu ghwa bhala bhaatendite mihalo ya ughanga, bhakihiyegha hitabho hyabhe na bhakihichunja mwoto mu hindandabhanji. Paatendite mmalango ghwa utopelo ghwa hitabho ghukibha nkulu munu ghuubheghite handa hipalamande elufu mbinda mabhoko nhano hya madini gha ngalabha. ");
INSERT INTO nww_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Habhu, lilagho lya Bambo likikwila kwoha na kubhegha na makakala kyanalumu. ");
INSERT INTO nww_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Mbole ya mihalo ayi kutulukila, Paulo kakilamula kughenda ku Yelusalemu kukindila ku Makedonia na ku Akaya. Kakilihwachila mu mwoyo ghwake, “Mbole ya kuhika akwo, yannogha kughenda ku Loma bhubhos.” ");
INSERT INTO nww_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Habhu kakialaghila bhandu abhili mu atangatila bhake, nabho bhakibha Timotheo na Elasito, bhanlongolele kughenda ku Mekodonia, mwene kakihighala kwa manjubha gha mandina akwo ku Asia. ");
INSERT INTO nww_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Nndaluko aghwo ndo ghukibwituka bhulwa nkulu akwo ku Efeso ya kya njila yila ya Bambo. ");
INSERT INTO nww_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Bulwa aghwo ghukiyandihwa na Mundu yumu mbhatula ngalabha ywaakemwa Demetilio, ywakabheghite na lihengo lya kutendekeha ming'omung'omu yiihwananite na nyumba ya chapanga ghwabhe nndala ywakakemitwe Alitemi. Na lihengo alyo likiapegha atendehi bhake ngalabha ndangalo. ");
INSERT INTO nww_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetilio kakiakungana bhala atenda lihengo bhake pamoo na bhangi bhaatendite lihengo handa alyo, pakiaghombela, “Ma bhandu mwenga, mungumanya kukita utopelo ghwetu ghunguhuma mu utendehi aghu. ");
INSERT INTO nww_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Hinu maahotola kuyihwa na kulibhonela mabhene mihalo yakatenda Paulo, chepa nga ku Efeso ghweka, ngati bhubho kwoha mu Asia hyoha. Mwene kanguanyegheleha bhandu na kuapiluha bhandu bhayitikile kukita machapanga bhala bhaatendekihitwe na bhandu ndo machapanga chepa. ");
INSERT INTO nww_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Habhu, kwabhegha ngondo ya kulitenda lihengo lyetu liyuyuhwe papamo na nyumba ya chapanga nndala Alitemi nkulu ywaatundamilwa mu Asia hyoha na milima hyoha, uhwadali ghwa ghuchapanga ghwake ghwahobha.” ");
INSERT INTO nww_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Paayihwite agho, bhakiyaghabhala, bhakiyobha kyobho, “Alitemi ghwa ku Efeso ndo nkulu!” ");
INSERT INTO nww_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kamu nnima ghwoha ghukimema bhulwa. Bhakiapukila Gayo na Alisitaliko, akolannima bha ku Mekodonia, bhene bhakibha mu mwanja ghumu papamu na Paulo. Bhakibhutuka nabho mbaka ku kibhanja kya makinilo. ");
INSERT INTO nww_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo kakipala kuyingila pakati ya lumati lwa bhandu peni bhala ahundwa bhakinkanikiha. ");
INSERT INTO nww_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Hata amoo bha atabhala bha mbande ya Asia, bhaabheghite aghanja bhake Paulo nabho bhakintaghila lilobhe paakinkinya kakotoke kughenda ku kibhanja kya makinilo. ");
INSERT INTO nww_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Lisaa alyo kila mundu kakikwayuka malobhe, bhangi bhangulongela habhu na amoo bhangulongela habhu, mbaka lila ngonganiko likitindinganika. Atangalo bhakimanya ng'obhe kihokonyo kyaakunganikilite papamo. ");
INSERT INTO nww_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Kiyaha Akaayahudi bhakintakulila Alekisanda paulongolo ghwa lumati lwa bhandu, amoo bhandu mu lumati lula bhakinng'ombela gha kughalongela, ndo Alekisanda kakiapegha naho kwa mabhoko ghake ngati bhanyamale kalongele gha kulikingiha. ");
INSERT INTO nww_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Peni pabhang'amulite kukita ywene ndo Nnyahudi, bhandu bhoha kwa papamu bhakiyobha kyobho, “Alitemi ghwa ku Efeso ndo ndi nkulu!” ");
INSERT INTO nww_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Kuuhiko ntyeka nkulu ghwa nnima kakilunyamaliha lula lumati lwa bhandu na kulongela, “Ma bhandu bha Kuefeso, bhandu bhoha bhangumanya kukita nnima aghu ghwa Efeso ndo ngingiko ya nyumba ya chapanga Alitemi na ngingiko ya lila ling'omung'omu liiponikite kuhuma kunane kwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Hinu kahone ywakuhotola kukanikiha milando ayi. Habhu naha, ntame nu, nkotoke kutenda kyoheli kwa kinduteni. ");
INSERT INTO nww_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Mubhaghegha bhandu abha apa, kunu bhanayibha ng'obhe kyohele mu nyumba ya chapanga ebu kunligha chapanga ghwetu n'dala. ");
INSERT INTO nww_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Hinu, Demetilio na atendehi bhako handa mmegha na nnando ghwa kunkokela mundu ywohele, ghabhegha mabalasa na atangatila bha kuntangatila ntabhala, bhaahotola kukokelana akwo. ");
INSERT INTO nww_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Handa mmegha na milando yingi, muyigheghe mu ghwemuko yinakumanyika. ");
INSERT INTO nww_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Mana tungabheghite na ngondo ya kukokelwa kwa kunyegheleha bhulwa ghwa lelo, kiyaha tubhegha ng'obhe na nhokonyo ghwa kutenda nnyukano aghu.” ");
INSERT INTO nww_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Mbole ya kulongela agha, kakibhaghombela bhoha bhabhuke. ");
INSERT INTO nww_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Mbole yakuyomoleka bhulwa ghwa ku Efeso, Paulo kakiakema papamu bhandu bhoha bhaanhyubhalilite Kilisito na kuatengelekeha. Mbole kakialagha na kakighenda ku Mekodonia. ");
INSERT INTO nww_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Kakikindila mbande ya milima yila pakiayonjokeha bhandu mwoyo kwa malagho matangalo. Mbole kakihika ku Uyunani, ");
INSERT INTO nww_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","kweni kakitama myehi mindatu. Pakabheghite mu kulibhika kala kwa mwanja ghwa kughenda ku Silia kwa njila ya lihibha, kaking'amula kukita Akaayahudi bhakibhegha bhangupala kuntendela uhakata, habhu kakilamula kubhuya kwa kukindila njila ya ku Makedonia ");
INSERT INTO nww_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Paulo kakilongohana na Sopatilo, mwana ghwa Piliho, kuhuma ku Belea, bhubho kakilongohana na Alistaliko na Sekundo ghwa kuhuma ku Sesalonike, Gayo ghwa kuhuma ku Delibe, Timoteo na Tukiko na Tilofimo ghwa kuhuma ku mbande ya ku Asia. ");
INSERT INTO nww_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Bhandu abho bhakitulongola na bhakitulindila kula ku Tuloa. ");
INSERT INTO nww_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Peni twenga mbole ya kikubhukubhu kya mangate ya nga kubhikwa linjacha, tukiyingila mu bhwato kuhuma ku Filipi na mbole ya manjubha nhano tukihika ku Tuloa kwene tukitama kwa manjubha saba. ");
INSERT INTO nww_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Hino, linjubha lya ulongohi lya juma, tukikwemukana papamu kwa kya kulyegha hilyo. Paulo kakiyobhela na bhandu mbaka pakilo munu, kiyaha kilabho yake kakihwachila kubhuka. ");
INSERT INTO nww_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Mu kyumba kya ligholofa kitubheghite kukibha na mimbamba mitangalo payiyaka. ");
INSERT INTO nww_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Paulo pakabheghite mu kulandamiha, nhongolo yumu lihina lyake Eutiko kakitama palidilisha, nhongolo aywo yikintopela muno ng'ono, naywo kakiponeka kuhuma ku ligholofa lya ndatu mbaka pahi. Bhakintola pakabheghite kehwegha. ");
INSERT INTO nww_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paulo kakihuluka pahi, na kakilighonjeha unani ghwa yula nhongolona, kilongela, “Nkotoke kubhegha na bhwaghalili kiyaha kubhegha na ubhumi nkati mwaki.” ");
INSERT INTO nww_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Mbole kakihubhuka kangi ku ligholofa, kakilyegha mulyo, kakiyobhela nabho mbaka malabhila putiputi ndo kakibhuka ");
INSERT INTO nww_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bhandu bhakimmuyiha yula nhongolo mbaka ku lubhagha lwabhe pakibha ghwa maha nabho myoyo yabhe yikikeka. ");
INSERT INTO nww_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Peni twenga tukiyingila mu bhwato tukilongolela kughenda ku Aso, kwene tukihwacha kuntola Paulo. Paulo kakitulaghila habhu kiyaha ywombe kakibha kangughenda akwo kwa maghulu. ");
INSERT INTO nww_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Paulo pakatubhonite ku Aso, kakiyingila mu bhwato na tukighenda papamu ku Mitilene. ");
INSERT INTO nww_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Kuhuma akwo tukighendelela kwa njila ya lihibha na kilabho yake tukihika ku Kio. Linjubha lya ubhili tukiyomboka kughenda ku Samo na kilabho yake tukihika ku Mileto. ");
INSERT INTO nww_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo kakihwachila kughenda Efeso kwa bhwato ngati kakotoke kukabhalila ku Asia kakibhegha pakilopokeha kuhika ku Yelusalemu yikali na kuyingila linjubha lya kikubhukubhu kya Pentekoste. ");
INSERT INTO nww_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Paulo pakabheghite ku Mileto kakililaghila lilagho ku Efeso kuakema aghohi bha ngwemuko ya bhandu bhaanhyubhalilite Kilisito ngati bhakwongane naywo. ");
INSERT INTO nww_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Bhala aghohi paahikite kwa ywombe kakiaghombela, “Mwenga mabhene mungumanya kya bhuli nikitama na mwenga kutandila linjubha lya ulongohi panyingilite apa pa Asia. ");
INSERT INTO nww_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mungumanya kya bhula panuntendelite lihengo Bambo kwa utekulo ghoha, kwa mahohi npanimbilila mapungwo na mbyupila na mambingiko ghaandulitwe kubhukana na lukila lwa Akaayahudi. ");
INSERT INTO nww_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mungumanya kukita niking'aka ng'ohe kulandamiha nnando ghwohele gha kuatangatila mwenga, peni nikihunda mu hindandabhanji na mu lubhagha kwa lubhagha. ");
INSERT INTO nww_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nikiakinya bhoha Akaayahudi, na bhandu bhaabheghite ng'obhe Akaayahudi, kukita kila mundu kalipetule ulemwa na bhampilukile Chapanga na kunhyubhalila Bambo ghwetu Yesu Kilisito. ");
INSERT INTO nww_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Hinu, Nhuki ghwa Chapanga kangunongoha ng'ende ku Yelusalemu, na nenga manya ng'obhe kimbala kunbwitukila akwo. ");
INSERT INTO nww_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Kinikimanyite ndo kukita Nhuki ghwa Chapanga kangunyimiha mu hitami hyoha kukita hibhopo na himbamanda hingunindila. ");
INSERT INTO nww_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Peni hata handa ndahwegha kwa nenga kilibhi ng'obhe, maha nga kuyomola lihengo lyangu lya undumitumi linilikingamite kwa Bambo Yesu, kulandamiha Nhalo ghwa Maha kwa umaha ghwa Chapanga.” ");
INSERT INTO nww_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ndyanga akwo na akwo munkati yenu bhoha panandamiha Ghubhutwa ghwa Chapanga. Hinu nungumanya kukita kutandila lelo kabhone yumoo ywenu ywakapala kumona kangi. ");
INSERT INTO nww_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Lelo nenga nunguaghombela pekupeku kukita handa pakahobha mundu ywohele mu mwenga kahone mundu ghwa kummayila. ");
INSERT INTO nww_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kiyaha niking'aka ng'obhe kubhalandamiha mapalo ghoha gha Chapanga ");
INSERT INTO nww_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mulindakile njimba yenu, na mughingingikihe ngwemuko hyoha yene Nhuki ghwa Chapanga kakiabhika mwenga mubhe alela. Muyihakile ngwemuko ya bhandu bha Kilistito lyene Chapanga kakilihemela kwa mwahi ghwa Mwana ghwake. ");
INSERT INTO nww_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nungumanya kukita mbole ya kubhuka nenga, kabhwa bha kunhitu akalipa bhatabhapukila na bhabhegha na luhungu ng'obhe kwa lumati alwo. ");
INSERT INTO nww_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Hata kuhuma mu mwenga bhaabwituka bhandu na kulongela mihalo ya uhwangi ngati amokole kubhahobheha bhandu na kuatenda ahundwa bhabhatughile bhombe. ");
INSERT INTO nww_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Hinu, mulindakile, Mulikulungwe kukita mu ngungwa ndatu pakilo na pamuhi nikitotekela kata kuakinya kila mmonga kwa mahohi.” ");
INSERT INTO nww_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Hinu, Nenga nunguabhika, ntame mumabhoko gha Chapanga na mu lilagho lya umaha ghwake, lyene lina makakala gha kubhachenga na kuapegha lipala papamu na bhandu bhangi bha Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nenga nikiyidokolela ng'obhe ngalabha, ebu lihabha, ebu mapinda gha mundu ywoheli, ");
INSERT INTO nww_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mabhene mungumanya kukita ndenda lihengo kwa mabhoko ghangu mwene ngati mokele hilibhi hya kunndangatila mwene na bhala bha mmeghite nabho. ");
INSERT INTO nww_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mu ghoha gha nighatendite nikibhegha nungulaha kukita yingutukwiliha kutenda lihengo lya lihuki twabhene ngati tuhotole kuatangatila bhaabheghite na kya kupala. Patutendite habhu tughakulungwe malagho ghakalongilite mwene Bambo Yesu, ‘Mbaha kubhuha kupitingana kukingama.’ ” ");
INSERT INTO nww_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paulo pakayomolite kuyobhela, kakichutama mayughwa, na kakiyupa papamo nabho bhoha. ");
INSERT INTO nww_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Bhoha bhakilila munu na bhakinlagha kwa kunhumbatila na bhakinnonela. ");
INSERT INTO nww_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Nnando ghuahyononihite muno ndo kila kya kyaghombite kukita bhaagkibhona kangi ng'obhe ndo bhakilongohana naywo mbaka ku bhwato. ");
INSERT INTO nww_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Patualaghite kala, tukihubhuka mu bhwato na tukighenda mbaka ku Kosi. Kilabho yake tukihika ku Lodo na kuhuma apwo tukighenda ku Patala. ");
INSERT INTO nww_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Na apwo ku Patala tukighubhona bhwato ghuughendite ku Foinike ndo tukihubhuka mu bhwato na tukighenda. ");
INSERT INTO nww_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Patukibhonite kigunguli kya ku Kipulo, tukikileka kungiya na tukighenda ku Silia. Tukighupaghika bhwato ku Tilo kiyaha bhakibhegha mu kuhuluha mihigho yiigheghitwe. ");
INSERT INTO nww_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Akwo tukiabhona bhandu bhaanhyubhalilite Kilisito na tukitama nabho mumanjubha saba. Bhala ahundwa paakilongohwa na Nhuki ghwa Chapanga, bhaking'ombela Paulo, kakotoke kughenda ku Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Manjubha gha kutama na bhene ghakipela, na tukighendelela na mwanja ghwetu. Bhala ahundwa papamu na adala na bhana bhabhe bhakitutwaha mbaka panje ya kitami. Patubheghite pabhweha ya lihibha bhoha tukichutamila mayughwa patukinnyupa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Mbole ya kulaghana, tukihubhuka mu bhwato na bhene bhakibhuya ukaya kwabhe. ");
INSERT INTO nww_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ndo tukighendelela na mwanja ghwetu kwa bhwato kuhuma ku Tilo na tukihika ku Tolemai, apwo tukibhajambuha bhandu bhaanhyubhalilite Kilisto na kutama nabho kwa linjubha limu. ");
INSERT INTO nww_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kilabho yake tukibhuka na kuhika ku Kaisalia. Akwo tukighenda ku lubhagha lwa Filipo nlandamiha ghwa Nhalo ghwa Maha, ywakabheghite yumoo ywa bhala bhandu saba bhaahaghulitwe akwo ku Yelusalemu na tukitama kwa mwene. ");
INSERT INTO nww_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Filipo kakibha na ahinja ncheche kabhali linda na abho bhakibha na umbuye ghwa mhalo ghwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Mbole ya kutama akwo kwa manjubha gha mandina, kakihika mbuyi yumu ghwa Chapanga ywakakemitwe Agabo kuhuma ku nnima ghwa Yudea. ");
INSERT INTO nww_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Pakahikite Agabo kakiutola nkungi ghwa Paulo, kakilibhopa mwene mabhoko na maghulu ghake pakilongela, “Nhuki ghwa Chapanga kangulongela habhu, ‘Habhu ndo Akaayahudi bha ku Yelusalemu bhammopa naha mundu yunankungi aghu nabho bhaankamuha kwa bhandu bhaabheghite ng'obhe Akaayahudi.’ ” ");
INSERT INTO nww_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Patuyihwite malagho agho twenga na alongo bhangi tukinhigha munu Paulo akotoke kughenda ku Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Peni Paulo kakituyanga, “Kiyaha niki mungulila na kunndunyula mwoyo? Nenga megha kala maha nga kubhopwa ghwenga ngati hata kuhwegha akwo ku Yelusalemu kwa kya lihina lya Bambo Yesu.” ");
INSERT INTO nww_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Patulepelitwe kunnyegheleha ngati kakotoke kughenda ku Yelusalemu tukinneka, patulongela, “Tunguyupa kukita upalo ghwa Bambo ghutendeke.” ");
INSERT INTO nww_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Mbole gha agha, tukilibhika kala kwa mwanja, tukibhuka na kughenda ku Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Amoo afwasi bha Kaisalia bhakilongohana na twenga na bhakitughegha ku lubhagha lwa mundu ywakakemitwe Mnasoni, kutama kwa ywombe. Mwene kakibhegha nkolannima ghwa ku Kipulo yumo ywa ahundwa bha makachu. ");
INSERT INTO nww_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Patuhikite ku Yelusalemu, alongo bhaanhyubhalilite Kilisito bhakitukingama maha munu. ");
INSERT INTO nww_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kilabho yake Paulo kakighenda na twenga kunnjambuha Yakobu na aghohi bhoha bha ngwemuko ya bhandu bha bhaanhyubhalilite Kilisito bhakibhegha apwo bhubho. ");
INSERT INTO nww_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Mbole ya kuajambuha, Paulo kakitula lilobhe kwa ghoha ghakatendite Chapanga kwa bhandu bhaabheghite ng'obhe Akaayahudi kwa undumitumi ghwake kwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Paayihwite mihalo ayi bhakinkweha Chapanga. Mbole bhaking'ombela Paulo, “Nnongo, ghwenga ghungumanya kukita Akaayahudi atangalo hinu bhangunhyubhalila Kilisito na abho bhoha bhangughatughila malaghilo gha Musa kwa ulyaghilo. ");
INSERT INTO nww_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bhayihwa kukita ghunguahunda Akaayahudi bhoha bhaatamite mumilima yiibheghite ng'obhe ya Akaayahudi kukita akotoke kughatughila malaghilo gha Musa, paghubhahunda kukita akotoke kuayingia unyagho bhana bhabhe kangi akotoke kuhitughila hitohe hyetu ya Akaayahudi. ");
INSERT INTO nww_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Hinu tutende niki? Kiyaha kulyaghila bhaayihwa kukita ghutahika ku Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Hinu, ghutende handa mutughughombela. Abhegha bhandu ncheche apa bhaalilungite kwa kubhika naghilo kwa Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ghulilunge papamu na bhandu abho, na mukatendekehe kikubhkubhu kya kuliyoha papamu nabho na ghukatule mapongolo gha kuliyoha kwabhe ngati bhamoghwe hwili hyabhe. Habhu bhandu bhoha bhaamanya kukita mihalu hyoha yaayiyuhwite yikibha uhwangi na kukita ghwenga ghungughatughila malaghilo gha Musa. ");
INSERT INTO nww_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Peni kwa kya bhandu bhaanhyubhalilite Kilisito bha milima mingi, tubhatyekela kala mahamba pa tukiaghombela kukita bhakotoke kulyegha kilibhi kyoheli kiibhuhitwe handa nyambi kwa machapanga bhangi, kunywegha mwahi, ebu kulyegha maponge gha anyama apopotolitwe, papamu na ungongola.” ");
INSERT INTO nww_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Kilabho yake, Paulo kakiatola bhala bhandu ncheche na bhakitendekeha hitohe hya kuliyoha papamu nabho. Mbole kakiyingila ku lubhigho lwa Kitutubhi kya Chapanga kunlandulila ndundame kwa kya lijubha lya kuyomola kuliyoha na pakiki bhaabhuha nyambi kwa kya kila yumo. ");
INSERT INTO nww_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Paghaheghelelite kupela manjubha saba, amoo bha Akaayahudi kuhuma ku Asia bhakimmona Paulo mu Kitutubhi kya Chapanga. Hinu, bhakilukokela lumati lwa bhandu nabho bhakinkamula Paulo. ");
INSERT INTO nww_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Bhakikweha lilobhe paakilongela, “Mayetu Makaaislaeli, mututange! Ayu ndo yula mundu ywakabhahunda bhandu mu milima hyoha kihengelenyuma na bhandu bha Isilaeli na malaghilo gha Musa na ya apa pa Kitutubhi kya Chapanga. Kangi kabhayingiha Akaagiliki mu Kitutubhi aki kya Chapanga na kupatenda pabhe panakinyakali.” ");
INSERT INTO nww_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Bhakilongela naha kiyaha bhakimmona Tilofilo ghwa ku Efeso pakabheghite ku mbwani papamu na Paulo, bhakinhwachila Paulo kakinnyingiha mu Kitutubhi kya Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ndo nnima ghwoha ghukimema bhulwa, bhandu bhakihika kuhuma mu mbande hyoha kunkamula Paulo, bhakinkwakwaha panji ya Kitutubhi kya Chapanga na bhakitata kya kulopokela milyango ya lubhigho ya Kitutubhi kya Chapanga. ");
INSERT INTO nww_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Bhandu abho paapaliteghe kunkoma Paulo, nhalo aghwo ghukinhikila kilongohi ghwa machonda ghwa Akaaloma kukita kitami kyoha kya Yelusalemu kimema bhulwa. ");
INSERT INTO nww_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kamu yula kilongohi ghwa machonda kakiatola na ayimilila bha machonda na bhakighenda ku bhulwa. Bhala bhaatendite bhulwa paammonite yula kilongohi nkulu ghwa machonda na lumati lwa machonda paahika bhakileka kuntuta Paulo. ");
INSERT INTO nww_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Yula kilongohi ghwa machonda kaking'endela Paulo, kakinkamula na kukwilikiha kabhopwe minyololo mibhili. Mbole kakiakwonya, “Ayu ndo ghani na katenda niki.” ");
INSERT INTO nww_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Amoo bhandu mu lula lumati bhakichobha kyobho, bhangi paakilongela aki na bhanga kila. Yula kilongohi ghwa machonda pakabhonite kukita kaahotola ng'obhe kumanya hoto ya nhokolo ghwene kwa kya ghula bhulwa, ndo kakikwilikiha Paulo kagheghwe ku kambi ya machonda. ");
INSERT INTO nww_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Paulo pakahikite mu ngwelelu machonda bhakibhona mbaha bhanbikule kiyaha kukibha na bhulwa ngulu. ");
INSERT INTO nww_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Kiyaha lumati lwa bhandu lukibha pa lukintughila kunu pa lukiyobha kyobho, “Kakwomwe aywo!” ");
INSERT INTO nww_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Machonda paabheghite mu kunnyingiha Paulo muliboma lyabhe, kaking'ombela yula kilongohi ghwa machonda, “Bhuli nda hotola kughughombela kilibhi kimu?” Yula kilongohi ghwa machonda kakinnyanga, “Ghungumanya kuyobhela Kigiliki? ");
INSERT INTO nww_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Bhulu ghwenga ndo yula Nmisili ng'obhe ghuuyandihiti ukiluko na kualongoha akiluka Elufu ncheche bhaabheghite na mikoha mbaka kukibhala?” ");
INSERT INTO nww_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulo kakiyanga, “Nenga nu Nnyahudi nbhelekwa ghwa ku Taliso nnima ghwa ku Kilikia, nkolannima ghwa kitami kikulu ghunakumanyikwa, chonde ghunndegheke nnyobhele na bhandu.” ");
INSERT INTO nww_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Yula kilongohi ghwa Machonda kakintegheka kayobhele. Ndo Paulo kakiyima unane ghwa ngwelelo na kakiapungila kibhoko kyake bhala bhandu na pabhanyamilite jii, kakiyanda kuyobhela nabho kwa nongelo ya Akaaebulania. ");
INSERT INTO nww_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Makaalongo bhangu na makaatate bhangu, munyihwe hinu panyobhela kwa kulikingikiha!” ");
INSERT INTO nww_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Paayihwite pakalongela nabho kwa nongelo ya Kibulania, bhakitama nuu kyanalumu. Naywo Paulo kakighendelela kulongela. ");
INSERT INTO nww_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Nenga Nnyahudi nbhelekwa ghwa Taliso nnima ghwa ku Kilikia. Peni ngulila mu nnima aghu ghwa ku Yelusalemu, nikibha nhundwa ghwa Gamalieli. Nikihundwa telatela kya kughatughila na kukamula malaghilo gha aghohi bhetu. Nikilibhuha kwa mwoyo ghumu kwa kya Chapanga handa mwenga pa mmeghite habhu lelo. ");
INSERT INTO nww_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nikiapegha nikiabamanda bhandu mbaka kuakoma bhoha bhaatughilite njila ayi. Nikibhakamula alume kwa adala na kuabhopa mu hibhopo. ");
INSERT INTO nww_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ndundame nkulu kangughumanya nnando aghu na aghohi bha libalasa ndo mayimiho bhangu, kiyaha bhakingamuha lihamba kuhuma kwa bhene lya kughenda kwa Akaayahudi bha ku Dameski, na nenga nikighenda akwo ngati nikaagheghe bhandu abho mbaka ku Yelusalemu handa mmopwa ngati ahyatulwe.” ");
INSERT INTO nww_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Pameghiti mu njila kughenda ku Dameski, na yikibhegha handa saa sita pamuhi, kamu lung'ali lukulu kuhuma kunane kwa Chapanga lukining'aliha mu mbande hyoha. ");
INSERT INTO nww_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nikighwegha pahi, na nukiyihwa lilobhe pa likinng'ombela, ‘Shauli, Shauli, kiyaha niki ghungumbamanda?’ ");
INSERT INTO nww_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nenga nikiyanga, ‘Ghwenga ndo ghani Bambo’ Naywo kakinlongela, ‘Nenga ndo Yesu ghuyunyaghabhiha’ ");
INSERT INTO nww_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bhandu bhaabheghiti papamu na nenga bhakilubhona lula lung'ali, peni bhakimanya ng'obhe lilobhe lya yula mundu ywakalongilite na nenga. ");
INSERT INTO nww_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ndo nikikonya, ‘Ndende niki Bambo.’ Naywo Bambo kakinng'ombela, ‘Ghuyinuke ghughende ku Dameski, akwo ghwaaghombelwa mihalo yiikunogheliti kuyitenda.’ ");
INSERT INTO nww_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kiyaha nikihotola ng'obhe kulola yakya lula lung'ali, ayangu bhakingamua kibhoko na kunnongoha mbaka Kudamesiki.” ");
INSERT INTO nww_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Mundu yumu nnyitikila ghwa Chapanga na ywaakamuhite muno malaghilo ghetu, lihina lyake Anania, kakihika kunmona, na ywombe kakihokamilwa muno na Akaayahudi bhaatamite akwo ku Dameski. ");
INSERT INTO nww_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Kakihika kwa nenga na kakiyima ugheghela kakilongela, ‘Nnongo Shauli, ghuhotole kubhona kangi!’ Lisaa lila lila nikihotola kubhona kangi, na nikihotola kummona. ");
INSERT INTO nww_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Anania kakilongela, ‘Chapanga ghwa hukulu bhetu kaghuhaghula ghwenga ngati ghughumanye upalo ghwake, ghummone mwene ywakabheghite na shaliya na ghumokole kuyuhwa malagho kuhuma mu ngulu yake. ");
INSERT INTO nww_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kiyaha ghwabhegha nlongela ghwake kwa bhandu bhoha kwa kya kila ghukibhonite na kukiyihwa. ");
INSERT INTO nww_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Hinu naha kiyaha niki kukabhalila? Ghuyinuke, ghukabatiswe na ulemwa ghwakwo ghwa ghululighwa, paghulikema lihina lyake.’ ” ");
INSERT INTO nww_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Mbole ya kubhuya ku Yelusalemu, pameghite mu kuyupa mu Kitutubhi kya Chapanga, kamu Chapanga kakimmoneha kilibhi, ");
INSERT INTO nww_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","nikimmona Yesu pakinng'ombela, ‘Ghuyumbatike ghubhuke ku Yelusalemu, kiyaha bhandu bha apa baaghuyitikila ng'obhe kughayihwa ghala gha ghughabhonite kwa kya nenga.’ ");
INSERT INTO nww_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Na nenga nikinnyanga, ‘Bambo, bhene bhangumanya kya bhula pang'endite mu hitutubhi nhanganganiko hya kutundamila Akaayahudi ngati kuabhika mu kibhopo na kuatuta bhala bhaakuhyubhalilite. ");
INSERT INTO nww_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Pakakwomitwe nndumindumi ghwakwo Stefano na nenga nikiyima pa mbwegha, panyitikila ndendelo ayo na kughabhika maha maghwanda gha bhala bhaankomiteghe.’ ");
INSERT INTO nww_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ndo Bambo kakinng'ombela, ‘Ghughende kiyaha ndakulaghila kutali, kwa bhandu bhaabheghite ng'obhe Akaayahudi.’ ” ");
INSERT INTO nww_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Lula lumati lwa bhandu lukinnyihwa Paulo mbaka pakalongilite lilagho alyo, ndo bhakiyobha kyobho paakilongela, “Mummuhe mu nnima kiyaha yingunnogha ng'obhe kulama.” ");
INSERT INTO nww_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Paabheghite mu kuyobha kyobho paakighapumunda maghwanda ghabhe na kutikula malihu kunane, ");
INSERT INTO nww_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Yula machonda kilongohi kakikwilikiha Paulo kayingihwe mu kitutubhi kikulu kya amachonda. Kakilaghila kakatutwe hinjupunjupu na kukonywa ngati amanye kiyaha niki bhandu akibhegha mu kuyobha kyobho kya abho. ");
INSERT INTO nww_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Peni paamopite kala kwa ngoyi ya liyula ngati bhantute hinjupunjupu, Paulo kakinng'ombela nnyimilila machonda ywakayimite pala ugheghela na mwene, “Bhuli yibha tela kwa mwenga kuntuta nkolannima ghwa ku Loma kya nga kutoswa na malaghilo?” ");
INSERT INTO nww_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Yula machonda pakayihwite agho malagho, kakinng'endela yula kilongohi ghwa Machonda na kunng'ombela, “Ghungupala kutenda niki? Kiyaha mundu aywo ndo nkolannima ghwa ku Loma.” ");
INSERT INTO nww_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Yula kilongohi nkulu ghwa machonda kakighenda kunkonya Paulo, “Ghung'ombele ghwenga ghu nkolannima ghwa Loma?” Paulo kakiyanga, “Ena.” ");
INSERT INTO nww_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ndo yula kilongohi ghwa machonda kakilongela, “Nenga yikimmuka ngalabha ngulu kubha nkolannima ghwa Loma.” Paulo kakilongela, “Peni nenga nkolannima ghwa ku Loma ghwa kubhelekwa.” ");
INSERT INTO nww_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Kamu bhala bhaapalite kunkonya bhakibhuka kya kuyumbatika na yula kilongohi ghwa machonda kakiyingila kwa kuyoghopa, pakamanyite kukita Paulo kakibha nkolannima ghwa ku Loma kangi kakimmopa kwa minyololo. ");
INSERT INTO nww_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Kilabho yake, kiyaha yula kilongohi ghwa machonda kakipala kumanya yibha bhuli kangukokelwa na Akaayahudi, kakimmopola na kakilaghila hilongohi bha Andundame na libalasa lyoha likongane. Mbole kaking'egha Paulo na kakinnyimiha mu ulongolo ghwabhe. ");
INSERT INTO nww_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo kakiahulutulila mehu bhandu bha libalasa, paakilongela, “Alongo bhangu, mwoyo ghwangu ghunyengemala ng'obhe mu ulongolo ghwa Chapanga mbaka lelo.” ");
INSERT INTO nww_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Apwo ndo Ndundame Nkulu Anania kakiakwilikiha bhala bhaatamite ugheghela na Paulo bhanhyatule mbalamande munnomo ghwake. ");
INSERT INTO nww_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ndo Paulo kakinng'ombela, “Chapanga kaakuhyata ghwenga kindupa handa kityekitwe chokaa Ghwenga ghutama apwo ngati ghuntose kwa malaghilo, peni ghu mwene ghungughakiluka malaghilo kwa kya kukwilikiha nhyatwe kya nga shaliya!” ");
INSERT INTO nww_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bhandu bhaayimite pala bhakinng'ombela Paulo, “Ghwenga ghungunligha Ndundame Nkulu ghwa Chapanga?” ");
INSERT INTO nww_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulo kakiyanga, “Alongo bhangu, nikimanya ng'obhe kukita ywombe ndo Ndundame Nkulu. Kiyaha yityekwa abhu, ‘Ghukotoke kukambuka gha uhakata kwa ntabhala ghwa bhandu bhakwo.’ ” ");
INSERT INTO nww_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paulo pakamanyiti kukita amoo bhabhe akibhegha Akaasadukayu na bhangi Akaafalisayu, kakitagha lilobhe mu libalasa lila, pakilongela, “Alongo bhangu, nenga ndo Falisayu, mwana ghwa Falisayu. Na apa ngokelwa kwa kuhyubhalila kukita bhaahweghiti bhaahyuka.” ");
INSERT INTO nww_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Kamu pakalongiliti agho, ghukibwituka bhulwa mu Akaafalisayu na Akaasadukayu na libalasa lyoha likimegheka. ");
INSERT INTO nww_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Kiyaha Akaasadukayu bhangulongela kukita kahone uhyuko, ebu kahone andumitumi ghwa kunani kwa Chapanga ebu nhuki peni Akaafalisayu bhanguhyubhalila agho ghoha mandatu. ");
INSERT INTO nww_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Pakibhegha na maghombano makulu, na amoo ahunda bha malaghilo bhaabheghiti Afalisayu, bhakiyima na bhakituta kyobho kwa makakala paakilongela, “Tungughubhona ng'obhe ulemwa ghwohele kwa mundu ayu! Pangi nhuki ebu nndumitumi ghwa kunani ghwa Chapanga kakilongela naywo.” ");
INSERT INTO nww_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Maghombano ghakibha makulu mbaka yula machonda kilongohi kakihyoghopa kukita bhangankachula Paulo hipalamande hipalamande, kakikwilikiha himati ya amachonda hikammuhe Paulo pa kati yabhe kwa makakala na kunng'egha mu liboma lya amachonda. ");
INSERT INTO nww_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Lisiku alyo pakilo, Bambo kakiyima ugheghela naywo pakinng'ombela, “Ghukotoke kudunyuka mwoyo! Handa bhula pa ghunnyimihite apa pa Yelusalemu, ubhwabhu abhu yingukukwiliha kunnyimiha akwo ku Loma.” ");
INSERT INTO nww_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Paaghucheghite amoo Akaayahudi bhakighombana kwa lupwepo na bhakitenda kilapo kukita bhaalyegha ng'obhe ebu kunywegha mbaka paahotola kunkoma Paulo. ");
INSERT INTO nww_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bhakibhegha bhandu kupitingana mbinda mabhoko ncheche bhaalilungite kughatenda aghwo. ");
INSERT INTO nww_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bhakiaghendela hilongohi bha andundame na aghohi paakilongela, “Twenga tulapa kukita twaalyegha ng'obhe ebu kunywegha mbaka tuhotole kunkoma Paulo. ");
INSERT INTO nww_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Hinu, mwenga papamu na balasa, munnyupe kilongohi ghwa machonda kabhayeghele Paulo mulitende handa mungupala kumanya kuyimanya maha maha mihalu yi munkokilite, na twenga tubha kala kunkoma kukali na kuhika apa.” ");
INSERT INTO nww_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Peni mwipwa ghwake Paulo pakayihwite ya kya mbwepo ayo ya uhakata, kakighenda kula ku liboma lya machonda na kakinng'ombela Paulo. ");
INSERT INTO nww_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ndo Paulo kakinkema yumoo ywa nnyimila machonda na kakinng'ombela, “Ghunng'eghe nhongolo ayu kwa kilongohi ghwa amachonda, kiyaha kananhalo ghwa kung'ombela.” ");
INSERT INTO nww_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Habhu yula nnyimila ghwa machonda kakinng'egha yula nhongolo kwa kilongohi ghwa machonda na kakinng'ombela, “Yula mmopwa Paulo, kakinngema na kunnyupa nunng'eghe nhongolo ayu kwa ghwenga, kiyaha kana lilagho lya kughughombela.” ");
INSERT INTO nww_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Yula kilingohi ghwa machonda kakinkamula kibhoko yula nhongolo, kakinng'egha pa nga bhandu na kakinkonyekeha, “Ghungupala kunng'ombela niki?” ");
INSERT INTO nww_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Yula nhongolo kaking'ombela, “Akaayahudi bhalingana malobhe bhakuyupe ghunng'ghe Paulo mu libalasa yabhe kilabho kwa kikupukiho bhangupala kunhingukiha maha maha kya kya ngokeho yake. ");
INSERT INTO nww_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Peni ghukotoke kuayitikila kiyaha bhandu kupitingana mbinda mabhoko ncheche bhaabheghiti kala kunpukila, bhene bhalikunga kwa kilapo akotoke kulyegha ebu kunywegha mbaka paahotola kunkoma, nabho mbaka hinu abhegha kala paakililindila ulamulo ghwakwo.” ");
INSERT INTO nww_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Yula kilongohi ghwa amachonda kakinlekekeha yula nhongolo kaghende kunu pakinkanikiha, pakinng'ombela, “Ghukotoke ghunng'ombela mundu ywohele kukita ghunng'ombela nenga mihalu ayi.” ");
INSERT INTO nww_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Mbole yula kilongohi ghwa machonda kakiakema ayimila abhili bha machonda na kakiaghombela, “Ng'ende ku Kaisalia saa ndatu pakilo ya lelo kughenda ku Kaisalia papamu na machonda mbinda mabhoko kumi ibhili, akwela nnyama falasi mbinda mabhoko saba na bhandu bhaabheghiti na mikoha mbinda mabhoko kumi ibhili. ");
INSERT INTO nww_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Kangi muabhike kala na anyama falasi kwa kya Paulo, na munng'eghe maha mbaka kwa ntabhala Felikisi.” ");
INSERT INTO nww_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Mbole ghutyeki lihamba kwa Felikisi handa abhu, ");
INSERT INTO nww_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Kwa nhokamilwa Ntabhala Felikisi, nungukujambuha nenga Kilaudio Lisia, ");
INSERT INTO nww_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Akaayahudi bhakinkamula mundu ayu na bhakibhegha njupula ya kunkoma, peni nikihika na himati hyangu hya machonda na kunlopoha, kiyaha nikimanyihwa lilagho kukita mwene ndo mundu ghwa nnima ghwa Loma. ");
INSERT INTO nww_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nikipala kumanya nnando ghwaankokela, habhu nikinng'egha mu ulongolo ghwa libalasa likulu lya Akaayahudi. ");
INSERT INTO nww_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ndo niking'amula kukita bhakinkokela kwa milando ya malaghilo ghabhe bhene, na nikighubhona ng'obhe nnando ghughunnoghiliti kuhwegha ebu kubhopwa. ");
INSERT INTO nww_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Pang'ombilitwi kukita pakibhegha na mbwepo ya kunkoma mundu ayu, ndo nikinngegha kwa ghwenga kanongola, kangi nikialaghila bhala bhaankokilite agheghe ngokelo yabhe kwa ghwenga. ");
INSERT INTO nww_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Habhu machonda bhakintola Paulo handa paalaghilitwi, bhakinng'egha pakiloghulaghula na kunng'egha mbaka ku Antipatili. ");
INSERT INTO nww_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Kilabho yake malabhila bhakialeka bhala akwela nnyama ywakakemitwe falasi bhaghendelele na mwanja papamu na Paulo peni bhala machonda bhaatyangite kwa maghulu bhakibhuya kuliboma lyabhe. ");
INSERT INTO nww_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Paahikitiku ku Kaisalia bhakinpegha lila lihamba yula ntabhala, na kangi bhakinkamuha Paulo kwa ywombe. ");
INSERT INTO nww_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Felikisi pakasomiti kala lila lihamba kakiakwonya machonda, kukita Paulo kakibhegha mundu ghwa kwoki. Pakamanyiti kukita kakibhegha ghwa Kukilikia, ");
INSERT INTO nww_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","kakilongela, “Ndayihwa ngokeho yako paahika apa bhala bhaakukokiliti.” Mbole kakikwilikiha Paulo kakabhikwe mu ukingiko ghwa boma lya mutwa Helode. ");
INSERT INTO nww_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Mbole ya manjubha nhano Nduname Nkulu Anania kakighenda ku Kaisalia papamu na amoo bha aghohi na mwana malaghilo yumo ywakakemitwe Telitulo. Bhakinng'endela ntabhala ghwa nnima Felikisi na bhakinng'ombela malagho ghaankokilite Paulo. ");
INSERT INTO nww_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Hinu Paulo pakakemwitwe kayingile unyumba, Telitulo kakiyanda kunsomela ngokeho pakilongela. “Nhokamilwa ntabhala Felikisi, tuyeyelwa kulama kwa uhihimilo kwa manjubha matangalo mu utabhala ghwakwo na mihalo mitangalo yiinoghite kutendekwa kwa kya nnima ghwetu. ");
INSERT INTO nww_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Tughukingama nnando aghu kwa uyelelo kwa manjubha ghoha na kubhuha numbo ndangalo kwa ghwenga kukwoheli pala na kwa njila yohele. ");
INSERT INTO nww_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Peni ngotoke kukutotokeha, tungukuhigha kwa umaha ghwakwo, ghuyihwe nandulo ghwetu hupitaho. ");
INSERT INTO nww_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tung'amula kukita mundu ayu kangughaha munu. Ywombe ghuyandiha bhulwa munkati ya Akaayahudi bhaabheghite mu milima hyoha na bhubho ndo kilongohi ghwa kimati kya Wanazaleti. ");
INSERT INTO nww_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Kangi kakiyigha kukitenda Kitutubhi kya Chapanga kikotoke kubhegha handa pakapalite Chapanga, habhu tukinkamula na tukipala kuntosa kwa malaghilo ghetu. ");
INSERT INTO nww_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Peni kilongohi ghwa machonda ywakemitwi Lisia, kakituhikila na kakinnyahula kwa twenga kwa makakala makulu, ");
INSERT INTO nww_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Handa paghunkonya mundu ayu ghumwene ghwahotola kumanya mihalo hyoha yitunkokilite.” ");
INSERT INTO nww_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Kangi bhala Akaayahudi bhakinlunga kibhoko paakilongela kukita ngokeho ayo hyoha yibha ya hoto. ");
INSERT INTO nww_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ntabhala Felikisi pakannangihite Paulo kibhoko ngati kalipingikihe, mwene kakiyanga, “Nungumanya kukita ghwenga ghubha nlamula ghwa nnima aghu kwa ngungwa ndangalo, habhu nungulipingikiha kwa nyelelo. ");
INSERT INTO nww_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ghwahotola kuyimanya hoto kukita kukali na kukinda manjubha mbinda mabhoko yimo na ibhili nikighenda kutundamila ku Yelusalemu. ");
INSERT INTO nww_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Akaayahudi bhakinkolela kata panikighombana na mundu ywohele, na kangi bhakimmona kata panikiakwokela bhandu mu Kitutubhi kya Chapanga, ebu mu hitutubhi hya kutundamila Akaayahudi yabhe, ebu papohele pala mu mbwani yabhe. ");
INSERT INTO nww_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Na kahone mundu ghwa kubhoneha ngokeho ayi yaankokihite kwa kya nenga. ");
INSERT INTO nww_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Peni ninguyitikila kukita nenga ninguntundamila Chapanga ghwa akaatate bhetu nungutughila njila yila yene bhombe bhanguikema dini ya mahundo gha uhwangi. Kangi nunguhyubhalila hyoha yaatyekitwe mu hitabho ya malaghilo na ambuye ");
INSERT INTO nww_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nenga nungunhyubhalilila Chapanga, handa bhombe paanhyubhalila kukita kwaabhegha na uhyuko ghwa bhaahweghite, kwa bhoha bhaabheghiti bha maha na ahakata. ");
INSERT INTO nww_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Habhu nungulitumba manjubha ghoha kubhegha mwoyo nyanyi muulongolo ghwa Chapanga na anabhandu.” ");
INSERT INTO nww_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Hinu, mbole ya ngungwa kwa ngungwa ya mandina nikibhuya pa Yelusalemu ngati kuayeghela bhandu kapukwa bha nnima ghwangu utango na kutendekeha nyambi. ");
INSERT INTO nww_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Pameghiti mu kughatenda agho ndo bhakingolela ku Kitutubhi kya Chapanga, pandenda hitohe hya kuliyoha. Nikibha ng'obhe na lumati lwa bhandu ebu nikitenda ng'obhe bhulwa. ");
INSERT INTO nww_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Peni pakibhegha amoo Akaayahudi kuhuma ku nnima ghwa ku Asia, abho ndo yingibhanogha kubhegha apa pa ulongolo ghwakwo na kukokeha ngokeho yabhe handa abhegha na kyohele kya kulongela kwa kya nenga. ");
INSERT INTO nww_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ebu ghubhaleke bhandu abha bhaabheghiti apa bhalongele ndo uhokelo ghwoki ghwaaghubhoniti paanyimiti mu ulongolo ghwa libalasa lyabhe likulu, ");
INSERT INTO nww_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","hela bhubho malagho agha ghanighalongiliti, ‘Mungundosa lelo kiyaha nunguhyubhalila kukita bhaahweghiti bhaayuhwa!’” ");
INSERT INTO nww_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Hinu Felikisi, ywene kakimanya maha mihalo ya Njila Yila, kakighonjeha nongwa yila pakilongela, “Ndadumula toso kwa nongwa ayi pakalonda kuhika apa Lusia kilongohi ghwa amachonda.” ");
INSERT INTO nww_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ndo Felikisi kakinkwilikiha yula nnyimiha ghwa machonda kammike Paulo mu makakala peni kampeghe kindimba kya mandina na kabhategheke aghanja bhake bhankeyele. ");
INSERT INTO nww_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Mbole ya manjubha gha mandina, Felikisi kakihika papamu na Dulusila nndala ghwake, ywaabheghite Nnyahudi, kakilaghila kakakemwe Paulo na kakinnyihwa pakaghombiti ya kya uhyubhalilo mu Yesu Kilisito. ");
INSERT INTO nww_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Peni Paulo pakabheghite mu kulongela ya kya shaliya, kubhegha na uyukuto