﻿USE sofia;
DROP TABLE IF EXISTS sofia.nwi_vpl;
CREATE TABLE nwi_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nwi_vpl WRITE;
INSERT INTO nwi_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","In e nhag rɨp Yesu Kristo mɨnə, kɨrik e King Deved, kɨni kɨrik mɨn e Ebraham. ");
INSERT INTO nwi_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Mərɨg rɨp Yesu yame rəkupən, Ebraham. Kɨni Ebraham in rɨm Aesak, kɨni Aesak in rɨm Jekob, kɨni Jekob in rɨm Juda mɨne naorahini mɨnə, ");
INSERT INTO nwi_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","kɨni Juda in rɨm Peres mɨne Zera, nɨsɨnriu e Tamara, kɨni Peres in rɨm Hesron, kɨni Hesron in rɨm Ram, ");
INSERT INTO nwi_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","kɨni Ram in rɨm Aminadab, kɨni Aminadab in rɨm Nason, kɨni Nason in rɨm Salmon, ");
INSERT INTO nwi_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","kɨni Salmon in rɨm Boas, e nɨsɨni e Rehab, kɨni Boas in rɨm Obed e, nɨsɨni e Rut, kɨni Obed in rɨm Jese, ");
INSERT INTO nwi_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","kɨni Jese in rɨm King Deved. Kɨni King Deved in rɨm Solomon e nɨsɨni e piraovɨn kape Uria kupan, ");
INSERT INTO nwi_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","kɨni Solomon in rɨm Rehoboam, kɨni Rehoboam in rɨm Abia, kɨni Abia in rɨm Asa, ");
INSERT INTO nwi_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","kɨni Asa in rɨm Jehosafat, kɨni Jehosafat in rɨm Jehoram, kɨni Jehoram in rɨp Usia, ");
INSERT INTO nwi_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","kɨni Usia in rɨm Jotam, kɨni Jotam in rɨm Ahas, kɨni Ahas in rɨm Hesekia, ");
INSERT INTO nwi_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","kɨni Hesekia in rɨm Manase, kɨni Manase in rɨm Amon, kɨni Amon in rɨm Josaea, ");
INSERT INTO nwi_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","kɨni Josaea in rɨm Jehoeakin mɨne piauni mɨnə, kɨni kwasɨg ikɨn, nəmə Babilonia kɨmnhavən apa Isrel, mhavəh-si ta nəmə Isrel tuk tanə atuatuk kapəriə, mhapɨk əriə mhavən apa Babilonia. ");
INSERT INTO nwi_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kɨni in e nhag rɨp Yesu mɨnə, rɨrikakun ye nɨpɨg yame kwənərəus mɨnə kape Isrel kɨmnɨsarə Babilonia. Jehoeakin in rɨm Sealtiel, kɨni Sealtiel in rɨp Serubabel, ");
INSERT INTO nwi_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","kɨni Serubabel in rɨm Abiud, kɨni Abiud in rɨm Eliakim, kɨni Eliakim in rɨm Asor, ");
INSERT INTO nwi_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","kɨni Asor in rɨm Jadok, kɨni Jadok in rɨm Aki, kɨni Aki in rɨm Eliud, ");
INSERT INTO nwi_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","kɨni Eliud in rɨm Eleasara, kɨni Eleasara in rɨm Matan, kɨni Matan in rɨm Jekob, ");
INSERT INTO nwi_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","kɨni Jekob in rɨm Josef e yerman kape Meri. Kɨni Meri in rɨmɨrəh Yesu, kɨni kamokrən kɨn In kɨmə Kristo yame Kughen rɨmɨni mə tukrher-pə kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ror məkneikɨn mə rɨrikakun ye Ebraham mamuə meriaji-pə King Deved, kaha hah mɨnə kape Yesu, kɨmɨrai nhagriə, iriə fotin. Kɨni rɨrikakun ye King Deved, muə meriaji-pə kwənərəus kape Isrel kɨmnɨsarə Babilonia, nhagriə e, iriə m-fam fotin. Kɨni rɨrikakun mɨn ye kwənərəus kape Isrel kɨmnɨsarə Babilonia, meriaji-pə Kristo yame Kughen rɨmɨni mə tukrher-pə kɨn, nhagriə e, iriə m-fam fotin. ");
INSERT INTO nwi_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","In e nəvsaoyen kɨn narhayen kape Yesu Kristo. Nɨsɨn Yesu, nhagɨn e Meri. Kɨmɨrpen-ta mə tukrəri-pən kwən kɨrik, nhagɨn e Josef. Mərɨg kɨrɨpəh hanə nɨwarə-kwisien, kɨni Josef rɨpəh napɨr-pənien tukun, mərɨg Nanmɨn kape Kughen rɨmnor Meri ror tɨpɨn. Kɨni narmamə kwəsəm mə Meri rɨnor tɨpɨn. ");
INSERT INTO nwi_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kɨni kafan yerman Josef rɨmə tukrəpəh in, mərɨg in yemə atuatuk, mɨpəh norkeikeiyen mə tukror Meri raurɨs ye nɨmrɨ narmamə, rɨkin raməsɨk mə tukrəpəh apɨs-apɨs əmə Meri. ");
INSERT INTO nwi_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mərɨg nɨpɨg rɨkin rɨmoh mə tukror məknakɨn, kɨni rəmrərhav, məm agelo kɨrik kape Kughen Yermaru rɨmauə tukun mɨmə, “Josef, mɨkɨp Deved. Takpəh nɨgɨnien tuk nɨkɨrien Meri, meinai kwajikovə yame ramarə iran, in rɨmasɨ-pən əmə tuk Nanmɨn kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kɨni Meri tukrɨrəh tɨni kɨrik yerman, kɨni takhen-pən nhagɨn mə Yesu, meinai In tukrɨrɨsɨn kafan narmamə mɨnə ye norien has kapəriə.” ");
INSERT INTO nwi_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Narɨmnar mɨnə fam a kɨmnhatərhav-pə, kasor Nəgkiarien kape Kughen Yermaru ruauə mɨnor nəfrakɨsien kɨn, yame rɨmɨni-ərhav tuk profet kupan kɨrik mɨmə, ");
INSERT INTO nwi_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Piakəskəh kɨrik yame yerman rɨpəh hanə nɨvənien tukun, tukror tɨpɨn. Kɨni mɨrəh tɨni kɨrik yerman, Kɨni tukhen-pən nhagɨn kɨmə Emanuel.” (Nɨpran e ramni mɨmə, “Kughen ramarə kɨtawə min.”) ");
INSERT INTO nwi_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josef rɨmnəm-ta nəmrərhavyen a, kɨni məri-pən nəgkiarien yame agelo kape Kughen Yermaru rɨmɨni, kɨni mɨvən, mɨkɨr Meri rəmhen kɨn kafan piraovɨn, mɨravən iman yerkwanu. ");
INSERT INTO nwi_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mərɨg in rɨpəh nɨvənien tukun meriaji Meri rɨmneiməkɨn tɨni yerman. Kɨni Josef rhen-pən nhagɨn mɨmə Yesu. ");
INSERT INTO nwi_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu rɨmnarha-pə apa Betlehem, ye tanə Judia. Ye nɨpɨg a, King Herod rɨmnamarmaru iran. Kɨni ai nəmehuə mɨnə tɨksɨn khasɨ-fiak isok mhauə Jerusalem. Kharkun huvə nar tuk nəmien nɨmtətien ye kəmhau mɨnə. Kɨni mhauə mɨsaiyoh mhamə, ");
INSERT INTO nwi_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“?Kwajikovə a In hiə, yame rɨmnarha-pə? In king kape nəmə Isrel. Kafan kəmhau rɨmnhaktə, yaksəm apa fiak; kɨni yakamhauə mə jakhavəh-si haktə In.” ");
INSERT INTO nwi_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mərɨg King Herod rɨmnərɨg nəgkiarien a, iriə nəmə Jerusalem, kɨmɨsərɨg raha. ");
INSERT INTO nwi_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kɨni rɨmnofugɨn hae pris mɨnə mɨne nəmhajoun mɨnə kape Loa kape Moses, maiyoh əriə mə, “?Kristo yame Kughen rɨmɨni mə tukrher-pə kɨn, In tukraməkeikei marha-pə apa hiə?” ");
INSERT INTO nwi_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kɨni khani-pən tukun mhamə, “In tukrarha-pə apa Betlehem, ye tanə e Judia. Meinai profet kupan kɨrik kape Kughen rɨmɨrai məknakɨn mɨmə, ");
INSERT INTO nwi_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Eh. Betlehem, ye tanə Judia. Tukhapəh nɨsəm-əhuyen əmiə mə nəmehuə mɨnə ye taon mɨnə tɨksɨn apa Judia kɨsapita əmiə, meinai yemehuə kɨrik tukrɨsɨ-pre irəmiə. Kɨni In tukrəm huvə kafak narmamə mɨnə e nəmə Isrel, rəmhen kɨn yame yermamə ramarha huvə tuk sipsip mɨnə.’” ");
INSERT INTO nwi_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Məkneikɨn King Herod rokrən kɨn narmamə yamə mɨne kharkun huvə nar khauə, rofugɨn apɨs-apɨs əriə. Maiyoh əriə mə kəmhau a rɨmnhaktə atuatuk ye naha nɨpɨg. Kɨni kɨmnhani-əsah-pən tukun. ");
INSERT INTO nwi_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kɨni in rɨmɨni-pən tuk əriə mɨmə, “Havən Betlehem, mɨsarha-kɨn huvə kwajikovə a. Kɨni tukmə naksəm, nakhani-əsah-pə iran, pəh yo mɨn yakvən mɨvəh-si haktə In.” ");
INSERT INTO nwi_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Mərɨg nɨpɨg kɨmɨsərɨg nəgkiarien a, khatərhav, mhavən, mɨsəm mɨn kəmhau kupan yame kɨmɨsəm apa fiak, rɨkiriə ragien pɨk. Kɨni kəmhau a rɨkɨr əriə mɨvən mimhen atuatuk a kwajikovə raməmɨr ikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kɨni khavən a imə, masəm kwajikovə a iriu nɨsɨni Meri. Kɨni mɨsənɨmkur ye nɨmrɨ Yesu mhavəh-si haktə In. Mhavəhsi-ərhav narɨmnar kapəriə yame nɨmrɨn rhaktə pɨk, mhavəh-si pən gol kɨmin, mɨne nɨmar nar kɨrik mɨn yame nəmiovɨn rhuvə, kamni kɨmə frangkinsens, mɨne pomad yame nəmiovɨn rhuvə, kamni kɨmə mir. ");
INSERT INTO nwi_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kɨni kwasɨg ikɨn, kɨmɨsəmrərhav mɨsəm Kughen ramor kwirɨg kɨmi əriə mɨmə, “Takhapəh nharerɨg-pənien tuk King Herod, mhakurao-pən ye swatuk pɨsɨn, mharerɨg-pən iməmiə ikɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kɨni kwənhatərhav-ta, məkneikɨn Josef rɨmnamrərhav məm agelo kɨrik kape Kughen Yermaru rɨmatərhav-pə tukun mɨmə, “!Ǝrer aihuaa! Mɨrəh kwajikovə e iriu nɨsɨni mɨrhap mɨrhuvɨn apa Ijip. Kɨni mɨrharə aikɨn mɨrheriaji Yo əmə jakni-pre tuk ik mə takrherɨg-pə mɨn. Meinai pəh nien mə tuk tu, King Herod tukruə marha kɨn kwajikovə e mə tukrhopni.” ");
INSERT INTO nwi_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ror pən, yenpɨg, Josef rarar, mɨrəh kwajikovə irisɨr nɨsɨni mɨrhap mɨrhuvɨn Ijip. ");
INSERT INTO nwi_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kɨni kɨmɨrharə ye tanə a mɨrheriaji-pən King Herod rɨmamhə. Kɨmɨrharə Ijip rəri-pən əmə Nəgkiarien kape Kughen Yermaru yame rɨmɨni-ərhav tuk profet kupan kɨrik mɨmə, “Yɨmnokrən kɨn narɨk yerman mə tukrɨtərhav Ijip.” ");
INSERT INTO nwi_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kɨni ye nɨpɨg King Herod ruɨrkun mə narmamə yamə mɨne kamhavəh nɨrkunien huvə tuk nəmien nɨmtətien ye kəmhau mɨnə kwənhakurao ye nərɨgien kafan, məkneikɨn niemha rhai pɨk. Kɨni mher-pən kɨn kafan mobael mɨnə mə tukhavən Betlehem mɨne ikɨn mɨnə fam ipakə tukun masarha kɨn kwajikovə narman yamə mɨne kapəriə newk rɨpəh napitayen kɨraru, mə tukshopni-hopni fam əriə. In rɨmɨrpen newk kɨraru meinai rɨkin raməsɨk mə ye nɨpɨg atuatuk a in a nəmə mɨnə a kɨmɨsəm kəmhau iran. ");
INSERT INTO nwi_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nar a rɨmɨtərhav-pə ror Nəgkiarien kape Kughen Yermaru ruauə mɨnor nəfrakɨsien kɨn, yamə rɨmɨni-ərhav tuk profet Jeremaea kupan mɨmə, ");
INSERT INTO nwi_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Narmamə ipakə tuk Betlehem kɨmɨsərɨg piraovɨn kɨrik ramasək pɨk, meinai ramərɨg raha pɨk. Piraovɨn a in Rejel. In ramasək tuk kafan kwajikovə mɨnə. Rɨpəh nɨpəhyen mə narmamə tuksəgkiar huvə kɨmin, meinai kafan kwajikovə narman mɨnə kwənhamhə fam.” ");
INSERT INTO nwi_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mərɨg nɨpɨg Josef mɨne Meri mɨne kwajikovə kɨrharə apa Ijip, King Herod rɨmhə. Kɨni Josef rɨmnamrərhav məm agelo kɨrik kape Kughen Yermaru rɨni-pən tukun ");
INSERT INTO nwi_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","mɨmə, “Josef. Hekɨmter. Mɨrəh kwajikovə e mɨne nɨsɨni, mɨrherɨg-pən ye tanə Isrel, meinai narmamə yamə mɨnə khamə tukshopni kwajikovə a, iriə kwənhamhə ta.” ");
INSERT INTO nwi_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ror pən, Josef rarar, mɨrəh kwajikovə a mɨne nɨsɨni, mɨrherɨg-pən mɨn ye tanə a Isrel. ");
INSERT INTO nwi_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mərɨg nɨpɨg Josef rɨmnərɨg mə kwən a Akeleas rɨmɨvəh tamhek rɨmni King Herod, mamarmaru ye Judia, kɨni in rɨgɨn mɨn kɨn nɨrerɨg-pənien tanə a Judia. Kɨni maməmrərhav məm Kughen rɨmnor kwirɨg kɨmin mɨmə tukrɨpəh nɨvənien Judia. Kɨni rɨmatərhav mɨvən ikɨ pɨsɨn ye provins a Galili, ");
INSERT INTO nwi_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","kɨni kɨrhuvɨn mɨrharə ye taon kɨrik, nhagɨn e Nasaret. Nar a rɨtərhav-pə ror nəgkiarien kape profet mɨnə kupan ruauə mɨnor nəfrakɨsien kɨn, yamə kɨmnhani mhamə, “Tukamni kɨmə in yemə Nasaret.” ");
INSERT INTO nwi_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Newk mɨnə tɨksɨn ruauə muavən ta, kɨni Jon Baptaes rɨtərhav-pə, maməvsao-ərhav kɨn Nəgkiarien kape Kughen apa ye tɨpəvsɨk apa Judia, ");
INSERT INTO nwi_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","mamni mɨmə, “Sarar ye nərɨgien kapəmiə tuk təvhagə has kapəmiə meinai nɨpɨg yame Kughen tukrarmaru ye narmamə mɨfam ruauə ipakə.” ");
INSERT INTO nwi_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon Baptaes e, in yermamə yame Aesea, profet kupan kape Kughen, rɨmɨni-ta mɨmə, “Kwən kɨrik ramokrapomh ye tɨpəvsɨk mamni mɨmə, ‘Kɨmiə, taksor əpnəpeinə tuk Yermaru, kɨni mɨsor kafan swatuk ratuatuk.’” ");
INSERT INTO nwi_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon rapəh nɨvəhsi-pənien neipən huvə kɨrik. Kafan kot kɨmnor kɨn tɨki narmɨragh kɨrik, kamni kɨmə kamel. Kɨni kafan kətəut kɨmnor kɨn tɨki kau. Kɨni nan nəvɨgɨnien kəvraiyuk əmə mɨne sukapak. ");
INSERT INTO nwi_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kɨni narmamə khapsaah kɨmnhasɨ-pən Jerusalem mɨne iku pɨsɨn ye tanə Judia mɨne ikɨn mɨnə ipakə tuk nu e Jodan. Kɨmnhauə mə tuksəm-ru Jon. ");
INSERT INTO nwi_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kɨni mamhani-ərhav-pən norien has mɨnə kapəriə. Kɨni in rɨmnor baptaes irəriə ye nu a Jodan. ");
INSERT INTO nwi_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mərɨg nɨpɨg Jon rɨmnəm mə narmamə ye khwen mir e Farisi mɨne Sadusi khapsaah kɨmnhauə mə in tukror baptaes irəriə, kɨni rɨni-pən tuk əriə mɨmə, “!Ah! !Kɨmiə naksahas rəmhen əmə kɨn snek yamə mɨne kasərhkwopah! Pəh nien mə tuktu, Kughen ror niemhaa mɨvəhsi-pən narpɨnien kɨmi narmamə. ?Mərɨg, pa ramni mə to kɨmiə nakharkun nɨsaptayen kɨn? ");
INSERT INTO nwi_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sor narɨmnar tɨksɨn yamə rhuvə mə tuksəm mə nakwəsəpəh əfrakɨs norien has mɨnə kɨni mhavən tuk Kughen. ");
INSERT INTO nwi_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nəfrakɨsien mə kɨmiə kwənərəus kape Ebraham, mərɨg rɨkimiə tukrɨpəh nəsɨkien mə Kughen tukraməkeikei mɨvəh mɨragh əmiə mhawor kɨmiə kwənərəus kape Ebraham. !Nɨkam, in nar apnapɨg əmə! Yakamni-pre tuk əmiə mə Kughen rɨrkun nor-mɨn-ien kapier apnapɨg ruə rəmhen kɨn kwənərəus kape Ebraham. ");
INSERT INTO nwi_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kɨni taktəkun ai, Kughen rɨnərer matuk ta mə tukrərəru nuknei nai. Kɨni tukmə nai kɨrik rɨpəh nɨkuəyen kɨn kwənkwan yame rhuvə, In tukrərəru marakikɨn-pən ye nap. ");
INSERT INTO nwi_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Yo yakamor baptaes irəmiə kɨn nu yame ramhajoun mə nakwəsarar ye nərɨgien kapəmiə tuk təvhagə has. Mərɨg yermamə kɨrik tukruə kwasɨg irak, yame kafan nəsanɨnien mɨne nehuəyen rapita yo. Kɨni yo ye tanə əgkəp; yakpəh nəmhenien mə to yakrap kafan sandel. Kɨni In tukror baptaes irəmiə ye Nanmɨn kape Kughen mɨne nap. ");
INSERT INTO nwi_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","In ramərer matuk tuk nəmien norien kape narmamə maməwhai əriə, nəmə huvə mɨnə mɨne nəmə has mɨnə. Rəmhen əmə kɨn yame yeməsim kɨrik ravəh safel tuk nəspir-tayen tɨki kwənkwai wit mə tukrɨpɨk nɨmitɨn yame rhuvə. Narmamə yamə mɨne khahuvə kɨsəmhen kɨn nɨmit wit yame rɨpɨk əriə mamvən yerkwanu; mərɨg narmamə has kɨsəmhen kɨn tɨki kwənkwai wit, yame ramarakikɨn-pən əriə ye nap ehuə yame ramuək rerɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kɨni Yesu rɨmɨtərhav Galili muə ye nu e Jodan, mə Jon tukror baptaes iran. ");
INSERT INTO nwi_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Mərɨg Jon rɨmɨni-əhu skai In mɨni-pən tukun mɨmə, “Ratuatuk mə Ik takor baptaes irak. ?Rhawor nakamuə mə jakor baptaes iram?” ");
INSERT INTO nwi_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mərɨg Yesu rɨni-pən tukun mɨmə, “Nɨkam. Takpəh nəpəhyen. Kughen rɨmɨni mə ratuatuk mə takor baptaes irak.” Kɨni Jon rɨmneighan kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kɨni mor baptaes ye Yesu. Kɨni nɨpɨg Yesu rɨmneiwaiyu mhekɨmter mɨn ye tame nu, məkneikɨn napuə rəkwaag, kɨni rəm Nanmɨn kape Kughen reiwaiyu-pə rəmhen kɨn mak ye tanə, maməkwətə-pən iran. ");
INSERT INTO nwi_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kɨni nəgkiarien kɨrik rɨsɨ-pən ye neai mamni mɨmə, “In e narɨk, yame yakorkeikei pɨk. Rɨkik ragien pɨk tukun.” ");
INSERT INTO nwi_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kɨni Nanmɨn kape Kughen rɨmɨkɨr Yesu mɨvən ye tɨpəvsɨk, mə Setan tukrɨvəhsi-pən vəhsi-pən kɨmin. ");
INSERT INTO nwi_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kɨni Yesu rɨmnəpəh nəvɨgɨnien kape nɨpɨg foti, yeraan mɨne yenpɨg, kɨni məmkərəv pɨk. ");
INSERT INTO nwi_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kɨni Setan ruə mɨvəhsi-pən vəhsi-pən kɨmi Yesu mɨni-pən tukun mɨmə, “Tukmə Ik Ji Kughen əfrah, ni-pən tuk kapier mɨnə e pəh khaukrekɨn mhauə mɨsor bred kɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mərɨg Yesu rhorpɨn nəgkiarien mɨmə, “Nɨkam. Kɨmɨrai ye Nəkwəkwə kape Kughen kɨmə, ‘Narmamə to khapəh nhamragh-əmə-yen ye nəvɨgɨnien. Mərɨg kamhamragh mɨn ye nəgkiarien mɨnə fam yame ramsɨ-pən tuk Kughen.’” ");
INSERT INTO nwi_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kɨni Setan rɨmɨkɨr Yesu mɨvən apa Jerusalem, mərɨp In ye Nimə Ehuə kape Kughen apa yerpɨrɨg əgkəp. ");
INSERT INTO nwi_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kɨni mɨni-pən tukun mɨmə, “Tukmə Ik ji Kughen əfrakɨs, iv-ərhav-ru ikɨn e, meinai kɨmɨrai ye Nəkwəkwə kape Kughen kɨmə, “‘In tukrher-pə kɨn agelo mɨnə kafan khauə masarha huvə tuk Ik. Tukharaptərəkɨn Ik kɨn kwermɨriə mə takpəh nowhan-pənien nɨhum ye kapier kɨrik.’” ");
INSERT INTO nwi_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mərɨg Yesu rhorpɨn kafan nəgkiarien mɨmə, “Nɨkam. Nəkwəkwə kape Kughen ramni mɨn mɨmə, ‘Takhapəh nɨsəm-əsaahyen kapəmiə Kughen Yermaru mə ramarha huvə əfrakɨs tuk əmiə uə nɨkam.’” ");
INSERT INTO nwi_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Məkneikɨn Setan rɨkɨr Yesu mɨvən apa ye tukwas apomh kɨrik, kɨni mhajoun In kɨn kantri mɨnə fam ye tokrei tanə, mɨne nehuəyen kapəriə, ");
INSERT INTO nwi_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","kɨni mɨni-pən tukun mɨmə, “Tukmə nakəhuak kɨmi yo, yakvəhsi-pre narɨmnar m-fam e kɨmik.” ");
INSERT INTO nwi_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mərɨg Yesu rɨni-pən tukun mɨmə, “!Setan, əta irak! Meinai Nəgkiarien kape Kughen ramni mɨmə, ‘Taksəhuak əmə kɨmi kapəmiə Yermaru Kughen, mɨsəri-pən əmə kafan nərɨgien.’” ");
INSERT INTO nwi_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kɨni ai Setan rəta iran, kɨni agelo mɨnə kɨmnhauə mɨsasitu iran. ");
INSERT INTO nwi_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","13","Kɨni ye nɨpɨg a, kɨmnharaptərəkɨn Jon Baptaes, kɨrəhsi-pən ye kalabus. Kɨni nɨpɨg Yesu rɨmnərɨg nəvsaoyen kɨn, kɨni mɨvən apa yerkwanu kɨrik ye provins Galili, nhagɨn e Nasaret. Mamarə apaikɨn, mɨtərhav, mɨvən apa taon kɨrik e Kapaneam, ipakə tuk lugun e Galili, mamarə apaikɨn. Kwənmhaan a in kwənmhaan kape kwənərəus mir kape Isrel e Sebulun mɨne Naftali. ");
INSERT INTO nwi_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nar a rɨtərhav-pə ror nəgkiarien kape profet kupan e Aesea ruauə mor nəfrakɨsien kɨn, yame rɨmɨni mɨmə, ");
INSERT INTO nwi_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Kwənmhaan kape nəmə Sebulun mɨne Naftali, kawərer ye swatuk ramvən apa ye lugun ehuə e Galili, ye nɨkar tanə pən ye nu e Jodan. In e provins e Galili - ime narmamə yamə mɨne pəh nien mə kwənərəus kape nəmə Isrel. ");
INSERT INTO nwi_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nəmə aikɨn a kɨmɨsarə ye nəpɨgnəpien, kɨni mɨsəm nɨkhakien kɨrik. Kɨni rɨnamraan. Nɨkhakien ehuə rɨmnəsia-pen əriə yamə mɨne kɨmnɨsarə ye nəpɨgnəpien kape nɨmhəyen e yame ramhotərəkɨn əriə ye nɨpɨg mɨfam.” ");
INSERT INTO nwi_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kɨni rɨrikakun ye nɨpɨg a, Yesu rɨnamni-ərhav nəgkiarien kape Kughen mamni mɨmə, “Sarar ye nərɨgien kapəmiə tuk norien has mɨnə, meinai nɨpɨg yame Kughen tukramarmaru ye narmamə ruauə pakə.” ");
INSERT INTO nwi_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu raməriwək ye nɨkar lugun ehuə e Galili kɨni məm kwərə mir kɨraru. Iriu piauni. Andru mɨne Saemon (yame nhagɨn mɨn kɨrik e Pita). Iriu kwarukɨn net apa ye lugun, meinai iriu yermamə mir kape nɨviyen kəmam. ");
INSERT INTO nwi_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kɨni Yesu rɨni-pən tuk əriu mɨmə, “Rauə mɨrakwasɨg kɨn Yo, mɨrauə kafak yermamə mir. Yo jakor əmiru nakrauə yermamə mir kape nɨviyen narmamə.” ");
INSERT INTO nwi_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Məkneikɨn, iriu kɨmɨwəpəh kapəriu net mɨrakwasɨg kɨn in. ");
INSERT INTO nwi_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kɨni Yesu rəriwək kəskəh mɨn, məm kwərə mir kɨraru mɨn, iriu piauni. Nhagriu e Jemes mɨne Jon, ji Sebedi mir. Kawkwətə ye nəkwai bot irisɨr rɨmriu, marhajir əsɨgɨn kapərisɨr net. Kɨni Yesu rɨmnokrən kɨn əriu mə tukrauə, ");
INSERT INTO nwi_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","məkneikɨn kwərer, mwəpəh bot, mɨne rɨmriu, kɨni mɨrakwasɨg kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kɨni Yesu raməriwək ikɨn mɨnə ye provins e Galili, mamhajoun narmamə ye nəkwai nimə kape nofugɨnien kape nəmə Isrel, maməvsao-ərhav kɨn nəvsaoyen huvə kape narmaruyen kape Kughen, kɨni mamor huvə narmamə yamə mɨne kamhamhə ye nəmhəyen pɨsɨn pɨsɨn. ");
INSERT INTO nwi_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kɨni nəvsaoyen kɨn Yesu rarkurao fam ye provins e Siria. Kɨni narmamə kɨmnhapɨk narmamə m-fam yamə mɨne kamhamhə, mhauə tuk Yesu. Kapəriə nəmhəyen ror məkneikɨn: Tɨksɨn kamhamhə; tɨksɨn, nɨprairiə rɨmamhə; tɨksɨn, nanmɨn has ramərer-pən irəriə; tɨksɨn, nɨkəvaan ramor əriə; kɨni tɨksɨn, nɨprairiə fam rɨmhə. Mərɨg Yesu rɨmnor huvə fam əriə. ");
INSERT INTO nwi_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kɨni nəmə Galili khapsaah, mɨne nəmə Dikapolis, mɨne nəmə Jerusalem, mɨne nəmə Judia, mɨne nəmə ikɨn mɨnə apa nɨkarɨn pən apa ye nu e Jodan khapsaah kɨmnhakwasɨg kɨn In. ");
INSERT INTO nwi_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nɨpɨg Yesu rɨmnəm nukwhao ehuə yame ramkwasɨg kɨn, kɨni In rhaktə fiak ye tukwas kɨrik, kɨni məkwətə. Kɨni kafan narmamə mɨnə khakwasɨg kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Kɨni In rɨmɨrikakun mhajoun əriə mɨmə, ");
INSERT INTO nwi_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Narmamə yamə mɨne kamhavəhsi-əhu atuk əriə masətɨgtə əmə ye Kughen, iriə e kɨsarə ye nɨhuvəyen əfrakɨs meinai iriə narmamə kape Kughen, kɨni In ramarmaru irəriə. ");
INSERT INTO nwi_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Narmamə yamə mɨne kɨsasək, kɨni rɨkiriə raməmhə, iriə e kɨsarə ye nɨhuvəyen əfrakɨs meinai Kughen tukrəgkiar vi vi kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Narmamə yamə mɨne khapəh nhavəh-si-haktə-atukien əriə, iriə e kɨsarə ye nɨhuvəyen əfrakɨs meinai Kughen tukrɨvəhsi-pən tokrei tanə e kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Narmamə yamə mɨne kɨsorkeikei pɨk yerkiriə m-fam mə nɨmraghien kapəriə tukratuatuk ye nɨmrɨ Kughen, iriə e kɨsarə ye nɨhuvəyen əfrakɨs meinai Kughen tukror nɨmraghien kapəriə in ratuatuk. ");
INSERT INTO nwi_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Narmamə yamə mɨne rɨkiriə rehuə tuk narmamə, iriə e kɨsarə ye nɨhuvəyen əfrakɨs, meinai Kughen rɨkin rehuə tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Narmamə yamə mɨne rɨkiriə ratuatuk, iriə e kɨsarə ye nɨhuvəyen əfrakɨs meinai tuksəm Kughen. ");
INSERT INTO nwi_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Narmamə yamə mɨne kasərəhu nəmərinuyen, iriə e kɨsarə ye nɨhuvəyen əfrakɨs meinai tukokrən kɨn əriə kɨmə ji Kughen mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Narmamə yamə mɨne kamuh əriə tuk norien atuatuk, iriə e kɨsarə ye nɨhuvəyen əfrakɨs meinai Kughen ramarmaru irəriə. ");
INSERT INTO nwi_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nakasarə ye nɨhuvəyen əfrakɨs nɨpɨg narmamə kasor nahasien kɨmi əmiə meinai kɨmiə narmamə kafak mɨnə. In e tukhani hah əmiə, mɨsoriah əmiə, mɨseikuə irəmiə mamhani nəgkiarien hah mɨsoriah əmiə kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nəfrakɨsien, narmamə kɨmɨsor mɨn məknakɨn ye profet mɨnə kupan rəmhen kɨn yame kasor irəmiə ai taktakun. Ror pən, sagien pɨk, meinai nərokien ehuə kapəmiə ramarə apa ye rao ye neai.” ");
INSERT INTO nwi_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Kɨni Yesu ramni mɨn mɨmə, “Kɨmiə naksəmhen kɨn nɨgər kape narmamə m-fam ye tokrei tanə. Kɨni mərɨg tukmə nɨgar rəhiu pɨk, ?tukhawor kor rhekɨn mɨn? Rɨpəh nəmhenien tuk nar kɨrik. Tukarakikɨn əmə. ");
INSERT INTO nwi_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kɨmiə naksəmhen kɨn laet kape narmamə m-fam ye tokrei tanə. Keinein nerkwaigien kɨn taon yame kɨmɨvhirəkɨn yerpɨrɨg ye tukwas. ");
INSERT INTO nwi_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kɨni yermamə kɨrik rɨkək yame to rəsia-pən ye laet kɨni mɨvai-pən ye nɨtɨp. Nɨkam. Nɨpɨg tukmə rəsiə-pən ye laet tukraməkeikei mukrai-haktə pən ikɨn kamukrai-pən laet ikɨn, mə laet tukrɨsia-pen fam narmamə apa imə. ");
INSERT INTO nwi_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kɨni ye norien kɨrikianə əmə mɨn, sor laet rəsiə ye nɨmraghien kapəmiə pəh narmamə tuksəm wok huvə yamə mɨne nakasor, kɨni mhavəhsi-haktə nhag Rɨmɨmiə Kughen yame ramarə ye rao ye neai.” ");
INSERT INTO nwi_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Kɨni Yesu ramni mɨn mɨmə, “Rɨkimiə tukrɨpəh nuhyen mə yɨmauə mə jakarakikɨn Loa kape Kughen uə nəgkiarien kape profet kupan mɨnə. Nɨkam. Pəh nien mə yɨmauə mə jakarakikɨn əriə, mərɨg yɨmauə mə jakor nəgkiarien mɨnə a khauə mɨsor nəfrakɨsien kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","!Nəfrah! Yakamni-pre tuk əmiə mɨmə nɨpɨg tokrei tanə mɨne neiai kwarə, kɨni Loa, in mɨn tukramarə. To nar kɨrik rɨpəh nɨrkəkien iran. Nar apnapɨg in leta kwakwə əmə, kɨni Loa tukrərer mor wok meriaji-pən nəgkiarien mɨnə fam kape Loa tukhauə mɨsor nəfrakɨsien kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ror pən, narmamə yamə mɨne kɨsəpəh loa, mɨshajoun narmamə mə iriə mɨn tuksəpəh, nar apnapɨg mə nəgkiarien kəskəh əmə kɨrik ye loa kape Moses, tukokrən kɨn əriə kɨmə iriə yetanə əgkəp ye rao ye neai. Mərɨg narmamə yame mɨne kasor loa mɨnə a, mɨshajoun narmamə kɨn, tukokrən kɨn əriə kɨmə iriə yerpɨrɨg əgkəp ye rao ye neai. ");
INSERT INTO nwi_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yakamni məknakɨn tuk əmiə meinai kapəmiə norien tukraməkeikei matuatuk huvə əgkəp ye nɨmrɨ Kughen rapita norien kape Farisi mɨnə mɨne nəmhajoun mɨnə kape Loa, yame khamə ta mə iriə kɨsatuatuk huvə. Mərɨg tukmə kapəmiə norien rɨpəh natuatuk-huvə-yen ye nɨmrɨ Kughen, to nakhapəh nhavənien mɨsarə apa ye rao ye neai.” ");
INSERT INTO nwi_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Kɨni Yesu ramni mɨn mɨmə, “Kɨmiə nakwəsərɨg ta nəgkiarien yame nəmhajoun kɨmnhani-pən tuk rɨpmiə mɨnə, mhamə, ‘Takhapəh nɨshopniyen yermamə’ kɨni, ‘yermamə yame ramhopni yermamə, in tukraməkeikei mərer ye nɨmrɨ mɨrh mɨvəh narpɨnien.’ ");
INSERT INTO nwi_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mərɨg Yo yakamni-pre tuk əmiə mə, tukmə yermamə kɨrik, niemha rhai in tuk nar kɨrik yame piauni rɨmnor, ratuatuk mə kwən a yame niemha ramhai in tukrərer ye nɨmrɨ mɨrh mɨvəh narpɨnien. Kɨni tukmə yermamə kɨrik rɨmnhek piauni, ratuatuk mə in tukrərer ye nɨmrɨ kaonsel. Kɨni tukmə yermamə kɨrik raməko-pən yarmhə kɨmi in kɨrik, ratuatuk mə yermamə yame rɨmɨni nəgkiarien a tukrɨvən ye nap ehuə. ");
INSERT INTO nwi_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Kɨni tuk norien a, tukmə nakamvən ye tebol ye Nimə Ehuə Kape Kughen mə takvəhsi-pən nar kɨrik kɨmi Kughen, mərɨg aikɨn a, tukmə rɨkim raməsɨk piam yame rɨmnor niemha kɨmik, uə ik nɨmnor nar kɨrik kɨmin yame rɨpəh nəmhenien, ");
INSERT INTO nwi_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","pəh pi pom kafam nɨvəhsi-pənien, kɨni mɨvən məm piam mwərəhu huvə nətərɨgien kapəmiru, mɨrəpəh nɨworien tɨkmɨr, mɨwor kɨrikianə, kɨni ai, mɨpivən mɨpivəhsi-pən nar kɨrik kɨmi Kughen ye tebol. ");
INSERT INTO nwi_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Tukmə yermamə kɨrik rɨmə tukrərɨp ik ye nɨmrɨ mɨrh, kɨni tukmə nakramə takwəriwək kwis mɨravən ye nɨmrɨ mɨrh, rhuvə mə takaməkeikei məkupən mərəhu nəmərinuyen tuk əmiru mɨnə, tamə rəukəkin ik mɨvən ye nɨmrɨ mɨrh. Kɨni yamehuə kape kot reighan-pən kɨn ik ye kwermɨ polis. Kɨni polis rɨrəh ik mɨvən mətapɨg əsɨgɨn ik ye kalabus. ");
INSERT INTO nwi_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kɨni yakamni-pre nəfrakɨsien tuk ik, mə tukmə ror məknakɨn, to nakpəh nap-tayen ye kalabus meriaji mor infamien ye narpɨnien kafam.” ");
INSERT INTO nwi_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Kɨni Yesu ramni mɨn mɨmə, “Kɨmiə nakwəsərɨg nəgkiarien e mə, ‘Kɨmiə yamə mɨne nakwəsarkurək ta, takhapəh nɨsəkrəhyen kɨn piraovɨn. ");
INSERT INTO nwi_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mərɨg Yo yakamni-pre tuk əmiə mə tukmə yerman rəm piraovɨn pɨsɨn kɨni rɨkin raməkrəh kɨn, in rɨnor ta təvhagə has yerkin, rəmhen kɨn yame rɨmnəkrəh əfrakɨs kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kɨni tukmə nɨmrɨm matuk ror nakamor təvhagə hah, rhuvə mə takɨkum ierɨg ta marakikɨn. Rhuvə pɨk mə takpəh nɨmrɨm kɨrikianə, rapita yame takvən ye nap ehuə kɨn nɨpram piəpiə. ");
INSERT INTO nwi_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kɨni tukmə kwermɨm matuk ror nakamor təvhagə hah, rhuvə mə takərəru ta marakikɨn. Rhuvə pɨk mə takpəh kwermɨm kɨrikianə, rapita yame takvən ye nap ehuə kɨn nɨpram piəpiə.” ");
INSERT INTO nwi_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Kɨni Yesu ramni mɨn mɨmə, “Kɨmiə nakwəsərɨg ta nəgkiarien e yame ramni mɨmə, ‘Yermamə yame raməpəh kafan piraovɨn, in tukraməkeikei mɨvəhsi-pən nəkwəkwə kɨrik kɨmin yame ramhajoun mə rɨmnəpəh.’ ");
INSERT INTO nwi_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mərɨg yakamni-pre tuk əmiə mə tukmə yermamə kɨrik raməpəh kafan piraovɨn yame rɨpəh nɨvən-hanəyen tuk yerman pɨsɨn kɨrik, kɨni pian a rarar mɨkwasɨg kɨn yerman pɨsɨn, rəmhen kɨn mə piraovɨn a rɨmnor təvhagə hah, mərɨg təvhagə has a rɨmɨrikakun ye yerman hanə kafan. Kɨni tukmə kwən kɨrik rɨkɨr piraovɨn a, in rəmhen kɨn yame rɨmnəkrəh kɨn piraovɨn a.” ");
INSERT INTO nwi_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Kɨni Yesu ramni mɨn mɨmə, “Nakwəsərɨg ta nəgkiarien kɨrik mɨn yame nəmhajoun mɨnə kɨmnhani-pən tuk rɨptawə mɨnə mhamə, ‘Tukmə nɨmnhani nhag yermamə kɨrik mə tukror kafam nəgkiarien tukror nəfrakɨsien kɨn, takhapəh nɨsakapɨrien nəgkiarien kapəmiə. Kɨni tukmə nɨmnhani-pən nəgkiarien kɨrik kɨmi Kughen Yermaru, sor.’ ");
INSERT INTO nwi_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mərɨg Yo yakamni-pre tuk əmiə mɨmə, takhapəh nhaniyen nhag yermamə kɨrik mə tukror kafam nəgkiarien tukror nəfrakɨsien kɨn. Takhapəh nhaniyen nhag rao ye neai, meinai Kughen ramkwətə ikɨn mamarmaru. ");
INSERT INTO nwi_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mhapəh nhaniyen nhag tokrei tanə, meinai Kughen ramarmaru ikɨn. Mhapəh nhaniyen nhag Jerusalem, meinai in taon kape King Ehuə. ");
INSERT INTO nwi_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mhapəh nɨshajounien kapəmia kapə mə kafam nəgkiarien tukror nəfrakɨsien kɨn, meinai kapəmiə nəsanɨnien rɨkək tuk nukreikɨnien nɨkwənemiə mə tukrhawən uə tukrapɨg. ");
INSERT INTO nwi_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mərɨg taksəfrakɨs nɨpɨg m-fam. Tukmə nakseighan kɨn nar kɨrik, sor. Kɨni tukmə naksəpəh, hapəh. Mərɨg Setan in ramherer narmamə mə tukhani nhag nar kɨrik mə tukror nəgkiarien kapəriə ror nəfrakɨsien kɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Kɨni Yesu ramni mɨn mɨmə, “Kɨmiə nakwəsərɨg ta nəgkiarien kɨrik ramni mɨmə, ‘Tukmə yermamə kɨrik rhapɨs nɨmrɨ yermamə kɨrik, tukaməkeikei khopɨs mɨn nɨmrɨn. Kɨni tukmə yermamə kɨrik rhopɨr kweru yermamə kɨrik, tukaməkeikei khopɨr mɨn kwerun.’ ");
INSERT INTO nwi_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mərɨg Yo yakamni-pre tuk əmiə mɨmə, takhapəh nɨsarpɨnien tai təvhagə has yame kamor-pre kɨmi əmiə. Kɨni tukmə yermamə kɨrik rərɨp nɨkapɨm matuk, kɨni nakukreikɨn-pən mɨn nɨkarɨn pəh rərɨp. ");
INSERT INTO nwi_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kɨni tukmə yermamə kɨrik rɨvəh-si-pən ik ye kot maməkeikei kɨmik mə takvəhsi-pən kafam sot kɨmin mə tukrərəhu huvə nətərɨgien kapəmiru, vəhsi-ta mɨn kafam kot mɨvəhsi-pən kɨmin. ");
INSERT INTO nwi_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kɨni tukmə mobael kɨrik raməkeikei kɨmik mə takrur kafan nɨtɨp məriwək rəmhen kɨn kilomita kɨrikianə, takrɨpɨn məriwək meriaji kilometa kɨraru. ");
INSERT INTO nwi_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Vəhsi-pən naha nhagɨn kɨmi yermamə yame ramaiyoh ik kɨn. Kɨni takpəh nɨni-əhuyen yermamə kɨrik yame rɨmə tukrɨvəh kafam kɨrik nar kɨrik mɨvən, kɨni mɨrerɨg-pə mɨn mɨrəhsi-pre mɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Kɨni Yesu ramni mɨn mɨmə, “Nakwəsərɨg ta mə, ‘Takasəkeikei mɨsorkeikei kɨmiə mɨnə tɨksɨn, kɨni masəməkɨn kapəmiə tɨkmɨr mɨnə.’ ");
INSERT INTO nwi_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mərɨg Yo yakamni-pre tuk əmiə mə taksorkeikei kapəmiə tɨkmɨr mɨnə, kɨni masəhuak tuk narmamə yamə mɨne kasor ahas pre kɨmi əmiə, ");
INSERT INTO nwi_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","kɨni norien a ramhajoun mə kɨmiə ji Kughen Rɨmɨmiə, yame ramarə apa ye rao ye neai. Kɨni sor məknakɨn meinai Kughen ramor mɨrh raməsia-pen nəmə huvə mɨnə mɨne nəmə has mɨnə. Kɨni In mamor nəhig rɨp mamuh nəmə atuatuk mɨne narmamə yamə mɨne khapəh nɨsatuatukien. ");
INSERT INTO nwi_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mərɨg tukmə naksorkeikei əmə narmamə yamə mɨne kasorkeikei əmiə, Kughen to rɨpəh nərokien əmiə iran, meinai nar apnapɨg mə nəmə has mɨnə rəmhen kɨn narmamə yamə mɨne kasərer tuk mane kape takis, mərɨg iriə mɨn kasorkeikei narmamə yamə mɨne kasorkeikei əriə. ");
INSERT INTO nwi_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kɨni tukmə nakhavəh əmə kɨmiə mɨnə tɨksɨn mɨsəgkiar kɨmi əmiə mɨnə, pa rɨmə nakasor nar kɨrik rhuvə rapita narmamə mɨnə tɨksɨn. Nakharkun mə nar apnapɨg narmamə yamə mɨne khapəh nharkunien Kughen, mərɨg iriə mɨn kasəgkiar kɨmi əriə mɨnə tɨksɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kɨni Yesu ramni mɨn mɨmə, “Rɨmɨmiə Kughen In ratuatuk, ror pən, norien kapəmiə tukraməkeikei matuatuk mɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Kɨni Yesu ramni mɨn mɨmə, “Tukmə naksor nar atuatuk, takhapəh nɨsorien mə tukəm kəgnəgɨn əmiə tukun, tamə Rɨmɨmiə ye rao ye neai rɨpəh nərokien əmiə iran. ");
INSERT INTO nwi_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ror məkneikɨn, tukmə nakhavəh-si-pən nar kɨrik kɨmi yavən has mɨnə mə taksasitu irəriə, hapəh nɨsorien ye norien kape narmamə yame norien kapəriə rhuvə mərɨg rɨkiriə rahas. In e, nɨpɨg kɨsasitu ye yavən has mɨnə, masher naiyuk, mhani-ərhav ye nimə kape nofugɨnien mɨne ye nəkwai swatuk, mə narmamə tuksəm khasiai əriə tukun. Mərɨg yakamni nəfrakɨsien tuk əmiə mɨmə iriə kasor məknakɨn, mɨnhavəh ta nərok piəpiə kapəriə in e nɨsiaiyen kape narmamə. ");
INSERT INTO nwi_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mərɨg kɨmiə, tukmə nakhavəh-si-pən nar kɨrik kɨmi yavən has mɨnə mə taksasitu irəriə, takhapəh nɨsəpəhyen mə narmamə tuksəm. Nar apnapɨg mə kwermɨm matuk, mərɨg takpəh nəpəhyen mə tukrəm. ");
INSERT INTO nwi_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Sor məkneikɨn mə narmamə tukseinein norien huvə mɨnə kapəmiə, kɨni Rɨmɨmiə yame raməm norien apɨsapɨs kapəmiə mɨnə, In tukrərok əmiə tuk kapəmiə norien huvə mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Kɨni Yesu ramni mɨn mɨmə, “Nɨpɨg naksəhuak, hapəh nɨsəri-pənien norien kape narmamə yame kapəriə norien rhuvə mərɨg rɨkiriə rəmkɨmɨk. In e, kɨsorkeikei mə tuksərer ye nimə kape nofugɨnien, mɨne ye swatuk pɨsiək, masəhuak mə narmamə tuksərɨg əriə. Yakamni əfrakɨs tuk əmiə mɨmə iriə kasor məknakɨn, mɨnhavəh ta nərok piəpiə kapəriə- in e nɨsiaiyen kape narmamə. ");
INSERT INTO nwi_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mərɨg tukmə nakhamə taksəhuak, havən apa ye nəkwai nimə kapəmiə, mɨsətapɨg, masəhuak kɨmi Rɨmɨmiə yame kɨpəh nəmien In. Kɨni Rɨmɨmiə, yame raməm kapəmiə norien apɨsapɨs mɨnə, tukrərok əmiə tuk kapəmiə norien huvə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Kɨni tukmə naksəhuak, takhapəh nɨsəwhai-kəjiyen nəgkiarien rɨpsaah yame nɨpran rɨkək, rəmhen kɨn yame narmamə yamə mɨne kaseinein Kughen kasor. Iriə khamə ta mə kapəriə kughen mɨnə tuksərɨg əriə tuk nəgkiarien mɨnə khapsaah yamə mɨne kasəhuak mamhani. ");
INSERT INTO nwi_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Hapəh nɨsorien rəmhen kɨn əriə, meinai, kwasɨg ikɨn naksaiyoh kɨn nar kɨrik, Rɨmɨmiə In ruɨrkun ta naha nhagɨn yame naksəkwakwə kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kɨni ror məkneikɨn, tukmə nakhamə taksəhuak, səhuak məkneikɨn: “‘Rɨmtawə ye neai, nhagɨm rəmrhakə, pəh narmamə tukhasiai Ik. ");
INSERT INTO nwi_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pəh kafam narmaruyen tukruə mamarə, Kɨni pəh nar yame Ik nakorkeikei in tukruə mor nəfrakɨsien kɨn ikɨn e tokrei tanə rəmhen əmə kɨn apa ye rao ye neai. ");
INSERT INTO nwi_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nɨpɨg mɨ-fam, vəh-si pə nəvɨgɨnien kɨmi əmawə rəmhen tuk nɨpɨg e towei. ");
INSERT INTO nwi_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","13","Pəh nɨpəhyen əmawə mə Setan tukrɨvəhsi-pə vəh-si-pə kɨmi əmawə tamə yakhamɨr. Kɨni vəhsi-ta əmawə tuk kwermɨ Setan. Kɨni vəh-si ta narpɨnien kape təvhagə hah kapəmawə mɨnə meinai kɨmawə yakhapəh nharaptərəkɨn tɨm-tɨmien norien has yame narmamə kasor irəmawə.’ ");
INSERT INTO nwi_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Səhuak məknakɨn meinai tukmə nakhapəh nɨsarpɨnien tai norien has yamə mɨne narmamə kasor irəmiə, Rɨmɨmiə ye rao ye neai tukrɨpəh narpɨnien kapəmiə norien has mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mərɨg tukmə naksarpɨn norien has yame narmamə kasor irəmiə, Rɨmɨmiə mɨn tukrəkeikei marpɨn norien has yame nakasor.” ");
INSERT INTO nwi_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Kɨni Yesu ramni mɨn mɨmə, “Tukmə nakhamə taksəpəh nəvɨgɨnien tuk nəhuakien, hapəh nɨsorien nɨmrɨmiə rəpou rəmhen əmə kɨn narmamə yamə mɨne kapəriə norien rhuvə mərɨg yerkiriə rəmkɨmɨk. Iriə kasor nɨmrɨriə ror pɨsɨn, mə narmamə tuksəm əriə mə nɨkumhə raməs əriə, khasiai əriə tukun. Yakamni əfrah mə iriə kwənhavəh ta nərok piəpiə kapəriə- in e nɨsiaiyen kape narmamə. ");
INSERT INTO nwi_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mərɨg nɨpɨg naksəpəh nəvɨgɨnien, mɨsəhuak kɨmi Kughen, saikwas ye nɨmrɨmiə, mɨsətei huvə ye nɨkwənemiə, ");
INSERT INTO nwi_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","mə narmamə tuksəm əmiə khapəh nharkunien mə naksəpəh nəvɨgɨnien tuk nəhuakien. Kɨni Rɨmɨmiə, yame kɨpəh nəmien In, In pɨsɨn əmə tukrəm mɨrkun. Kɨni Rɨmɨmiə yame raməm kapəmiə norien apɨsapɨs mɨnə, tukrərok əmiə tuk kapəmiə norien huvə mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Kɨni Yesu ramni mɨn mɨmə, “Takhapəh nɨsəwhai-kəjiyen kapəmiə nautə ye tokrei tanə e mə tukrɨpsaah. Ye tokrei tanə e, ɨvn mɨnə mɨne nəmtəyen raməs narɨmnar ikɨn, kɨni yəkrəh mɨnə kɨsat-pən imə, mɨsəkrəh kɨn narɨmnar. ");
INSERT INTO nwi_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mərɨg taksor nɨtɨp kapəmiə apa rao ye neai. Kɨni ikɨn aikɨn a, to ɨvn mɨnə mɨne nəmtəyen rɨpəh nəsien narɨmnar aikɨn, kɨni to yəkrəh mɨnə khapəh nɨsat-pənien aikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yakamni məkneikɨn meinai, ikɨn pukhaa kapəmiə narɨmnar huvə mɨnə kamhaswin ikɨn, rɨkimiə tukrɨvən mɨn aikɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Kɨni Yesu ramni mɨn mɨmə, “Nəkwai nɨmrɨm in rəmhen kɨn laet yame ravəhsi-pre nɨkhakien ye nɨpram. Tukmə nəkwai nɨmrɨm mir kɨrahuvə, rəmhen kɨn mə nɨpram rukwar kɨn nɨkhakien. ");
INSERT INTO nwi_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mərɨg tukmə nɨkwai nɨmrɨm mir kwahas, rəmhen mə nɨpram rukwar kɨn nəpɨgnapien. !Kɨni tukmə nɨkhakien ye nɨpram rəmhen əmə kɨn nəpɨgnapien, in rəmhen kɨn yame nakamarə əfrakɨs aikɨn rəpɨgnəp ikɨn! ");
INSERT INTO nwi_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Yermamə rɨkək yame to ror slef kape yemehuə mir kɨraru. To ramor məknakɨn, tukraməkeikei morkeikei kɨrik, maməməkɨn kɨrik; uə tukraməkeikei mor nəkwai kɨrik, məpəh kɨrik. To nakhapəh nɨsor-kwis-kwisien wok kɨmi Kughen mɨne mane.” ");
INSERT INTO nwi_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Kɨni Yesu ramni mɨn mɨmə, “Tuk nar a, yakamni-pre tuk əmiə mə, takhapəh nɨsətərɨg-pɨkien tuk nɨmraghien kapəmiə mə taksən naha, mhanɨm naha, uə mə takvəhsi-pən naha neipən. ?Nakharkun mə nɨmraghien kapəmiə rapita nəvɨgɨnien, kɨni nɨpraimiə rapita neipən? ");
INSERT INTO nwi_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Səm-ru man mɨnə ye nɨmago-ago. Khapəh nɨsəsimien, mhapəh nɨsarha-kɨnien nəvɨgɨnien, mhapəh nɨsətu-yen nəriə nəvɨgɨnien ye nəkwai nimə. Mərɨg Rɨmɨmiə ye rao ye neai raməvɨgɨn əriə. !Mərɨg nakharkun mə In rorkeikei pɨk əmiə rapita man mɨnə! ");
INSERT INTO nwi_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","?Tukmə nakətərɨg pɨk tuk nɨmraghien apomh kafam, nakɨrkun mə to rasitu iram nakarə mɨn rəpomh uə? !Nɨkam! Norien kape nətərɨg-pɨkien to rɨpəh nəsɨk-əpnis-pən-ien aoa kɨrikianə ye nɨmraghien kapəmiə. ");
INSERT INTO nwi_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“?Kɨni rhawor e naksətərɨg pɨk tuk neipən? Səm-ru jihi nai yamə mɨne kamhavus. Iriə khapəh nɨsorien wok, mhapəh nhajirien kapəriə neipən. ");
INSERT INTO nwi_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mərɨg yakamni-pre tuk əmiə mə King Solomon kupan, kafan nautə rehuə pawk, kafan neipən rhuvə pawk, mərɨg rɨpəh nɨhuvə-pɨkien mapita jihi nai mɨnə a. ");
INSERT INTO nwi_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jihi nai mɨnə kɨshaktə tuk nɨpɨg kwakwə əmə, kəni rɨkwamer kɨn, kɨvaan əriə ye nap. Mərɨg Kughen ramor əriə kamhavəh-si-pən neipən huvə. ?Mərɨg kɨmiə nakharkun mə Kughen tukrɨvəhsi-pre neipən kɨmi əmiə uə nɨkam? !Ǝwəh! Kafak narmamə mɨnə. Kapəmiə nhatətəyen in rəkəskəh əmə. ");
INSERT INTO nwi_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ror pən, takhapəh nɨsətərɨg-pɨkien mhani mhamə, ‘?Jaksən naha?’ uə ‘?Jakhanɨm naha?’ uə ‘?Jakhavəhsi-pən naha neipən?’ ");
INSERT INTO nwi_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Meinai narmamə yamə mɨne khapəh nɨshatətəyen ye Kughen, rɨkiriə ramvən tuk narɨmnar mɨnə a. Mərɨg Rɨmɨmiə rɨrkun narɨmnar yamə mɨne naksəkwakwə kɨn ye nɨmraghien kapəmiə. ");
INSERT INTO nwi_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mərɨg taksor mə narmaruyen kape Kughen mɨne nɨmraghien atuatuk, pəh iriu tukwərer əkupən ye nɨmraghien kapəmiə, kɨni Kughen tukrɨvəhsi-pre narɨmnar kape nɨmraghien e ye tokrei tanə kɨmi əmiə. ");
INSERT INTO nwi_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ror məkneikɨn, takhapəh nɨsətərɨg-pɨkien tuk narɨmnar yamə mɨne tukianəkwamer nakhavəh, meinai narɨmnar kape tikianəkwamer, iriə kape tuknəkwamɨr. Nɨmraghien kape towei in rəutən pɨk, takpəh norien narkutien kɨmik mamətərɨg tuk narɨmnar kape tikianəkwamer.” ");
INSERT INTO nwi_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Kɨni Yesu rɨmɨni mɨn mə, “Takpəh nəm-pənien nar has ye narmamə, tamə Kughen mɨn rəm-pre nar has irəmiə. ");
INSERT INTO nwi_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Meinai nəgkiarien skai yame nakamhani hah yermamə kɨrik, Kughen tukrɨni əmə mɨn iram rəmhen kɨn yame nɨmɨni. Tukmə nakəkir narmamə ye norien yame ratuatuk, Kughen tukrəkir ik ye norien yame ratuatuk. Mərɨg tukmə nakəkir oror narmamə ye norien yame rɨskai, Kughen tukror əmə mɨn iram rəmhen kɨn yame ik nɨmnor. ");
INSERT INTO nwi_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“?Rhawor nakamhani nɨmoptanə yame ramswin-pən ye nɨmrɨ piaumiə; mərɨg nakhapəh nɨsərɨgien nai ehuə yame ramhai nɨmrɨmiə? ");
INSERT INTO nwi_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tukmə nakhapəh nɨsərɨgien nai ehuə yame ramhai nɨmrɨmiə, ?takshawor pən iran mɨne mhasur ta nɨmoptanə ye nɨmrɨ piaumiə? ");
INSERT INTO nwi_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kɨmiə naksəmhen kɨn narmamə yamə mɨne kamhani nar mhapəh nɨsorien. Taksəkupən mhavəh-si ta nai ehuə ye nɨmrɨmiə, kwasɨg ikɨn, nakharkun nɨsəm-huvəyen nɨmoptanə yame ramswin-pən ye nɨmrɨ piaumiə mɨpihasur-ta.” ");
INSERT INTO nwi_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kɨni Yesu rɨmɨni mɨn mə, “Hapəh nhavəhsi-pənien narɨmnar kape Kughen kɨmi narmamə yamə mɨne kɨsahas rəmhen kɨn kuri mɨnə, tamə kɨsarar mɨsəs əmiə. Kɨni mhapəh nɨsarakikɨn-pənien nar huvə mɨnə kapəmiə kɨmi narmamə yamə mɨne kɨsəmkɨmɨk rəmhen kɨn pukəh mɨnə, tamə kasəriwək əsuun.” ");
INSERT INTO nwi_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Kɨni Yesu rɨmɨni mɨn mə, “Saiyoh Kughen kɨn narɨmnar, kɨni In tukrɨvəhsi-pre kɨmi əmiə. Sarha kɨn, mɨsəm. Səsɨk-əsɨk tapɨg, kɨni tapɨg tukrəhitə tuk əmiə. ");
INSERT INTO nwi_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Yakamni məknakɨn meinai narmamə m-fam yamə mɨne kɨsaiyoh, tukhavəh. Kɨni narmamə yamə mɨne kasarha kɨn, tuksəm mɨn. Kɨni yamə mɨne kɨsəsɨk-əsɨk tapɨg, tapɨg tukrəhitə tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“?Yermamə kɨrik aikɨn irəmiə yame tukmə tɨni raiyoh kɨn bred, mərɨg in tukrɨvəhsi-pən kapier uə, nɨkam? !Nɨkam! ");
INSERT INTO nwi_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","?Uə tukmə nɨpɨg raiyoh kɨn kəmam, mərɨg in tukrɨvəhsi-pən snek uə? !Nɨkam! ");
INSERT INTO nwi_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kɨmiə naksahas pawk, mharkun nhavəhsi-pənien narɨmnar huvə mɨnə kɨmi jimiə mɨnə. Mərɨg Rɨmɨmiə ye neai, kafan norien rhuvə pɨk rapita norien kapəmiə. Kɨni nəfrakɨsien mə In tukrɨvəhsi-pən nar huvə mɨnə kɨmi narmamə yamə mɨne kɨsaiyoh kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Kɨni sor huvə pən kɨmi narmamə m-fam ye norien mɨnə fam yame naksorkeikei mə narmamə tuksor mɨn kɨmi əmiə, meinai norkeikeiyen raməpkəfugɨn nəgkiarien fam ye loa kape Moses mɨne profet kupan mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Kɨni Yesu rɨmɨni mɨn mə, “Kɨmiə takasəkeikei mhakurao ye kwəruə yame rəkəskəh, meinai kwəruə yame rehuə, mɨne swatuk yame rɨmar, ramkɨr-pən narmamə ye nap ehuə. Kɨni narmamə khapsaah tukhakurao-pən ye kwəruə a. ");
INSERT INTO nwi_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mərɨg kwəruə yame rəkəskəh, mɨne swatuk yame rəutən, ramkɨr-pən narmamə ye nɨmraghien rerɨn. Kɨni narmamə kwatɨksɨn əmə tuksəm.” ");
INSERT INTO nwi_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Kɨni Yesu ramni mɨn mə, “Takasərɨg əmiə tuk profet eikuə mɨnə. Iriə tukhauə tuk əmiə mɨsəpou rəmhen kɨn sipsip; mərɨg rɨkiriə rəmhen kɨn kuri aparu yamə mɨne kasəkwəpah. ");
INSERT INTO nwi_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Narmamə kasəm kwənkwan ye nɨmraghien kape profet mɨnə, kharkun mə khahuvə uə kɨsahas. Kwənurkəsɨk to rɨpəh nɨkuəyen kɨn kwənkwai grep; kɨni kapɨriapɨr to rɨpəh nɨkuəyen kɨn kwənkwai fig. ");
INSERT INTO nwi_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ye norien kɨrikianə mɨn, nai huvə tukramkuə kɨn kwənkwai nai huvə; kɨni nai hah tukramkuə kɨn kwənkwai nai hah. ");
INSERT INTO nwi_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nəpgɨn kɨrik rɨrkək yame ramkuə kɨn kwənkwan yame kɨpəh nənien. Kɨni to nai has rɨpəh nɨkuəyen kɨn kwənkwan yame rhuvə. ");
INSERT INTO nwi_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nai mɨnə fam yamə mɨne khapəh nhakuəyen kɨn kwənkwairiə yame rhuvə, tukərəpɨr-pɨr, karakə-pən kɨn ye nap. ");
INSERT INTO nwi_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ror məkneikɨn mə narmamə kasəm kwənkwan ye nɨmraghien kape profet mɨnə, kharkun mə khahuvə uə kɨsahas. ");
INSERT INTO nwi_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Nar apnapɨg mə narmamə kasokrən kɨn Yo mə Yermaru, mərɨg pəh nien mə iriə m-fam tukhavən mɨsarə ye narmaruyen kape Kughen. Mərɨg yamə mɨne kasor nəkwai Rɨmɨk yame ramarə ye rao ye neai, iriə en tukhavən mɨsarə ye narmaruyen kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ye nɨpɨg yame Kughen tukrəkir narmamə mɨfam iran, narmamə khapsaah tukhani-pə tuk Yo mhamə, ‘!Yermaru! !Yermaru! ?Rhawor? ?Nakɨrkun əmawə uə nɨkam? Kɨmawə yɨmnhani-ərhav nəgkiarien kafam yame nɨmɨvəhsi-pə kɨmi əmawə. Kɨni mɨsəko-ta nanmɨn has ye nhagɨm. Kɨni masor nɨmtətien mɨnə.’ ");
INSERT INTO nwi_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mərɨg Yo jakni-pən atuatuk tuk əriə mɨmə, ‘!Ah! !Yakpəh hanə nɨrkunien əmiə! !Havən isok tuk Yo! Kɨmiə yor təvhagə has mɨnə.’” ");
INSERT INTO nwi_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Kɨni mɨni mɨn mɨmə, “Ror məkneikɨn meinai narmamə yamə mɨne khauə tuk Yo, kɨni mɨsətərɨg kɨn nəgkiarien kafak, masarar, mɨsor narɨmnar yame yakməni, narmamə en kɨsəmhen əmə kɨn yermamə yame kafan nɨrkunien rehuə, tukmə rɨmə tukror kafan nimə, tukrəkupən mɨkɨr nɨmoptanə, meiwaiyu məspir kapier apɨg, mor pən nimə iran. ");
INSERT INTO nwi_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kɨni nɨpɨg tukmə nəhig rɨp kɨni yapiwən raiyu, kɨni nɨmətag ramuh nimə, to rapəh nɨmɨrien, meinai nɨhun ramərer tɨm tɨm ye kapier. ");
INSERT INTO nwi_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Mərɨg narmamə yamə mɨne kasərɨg nəgkiarien kafak, mhapəh nɨsorien, iriə kɨsəmhen kɨn yermamə yame kafan nɨrkunien rɨkək. Tukmə rɨmə tukror kafan nimə, ravhirəkɨn haktə əmə ye nɨpakɨr. ");
INSERT INTO nwi_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kɨni nɨpɨg tukmə nəhig rɨp, kɨni yapiwən raiyu, kɨni nɨmətag ramuh nimə, rəusərku, mowhan əpɨr-pɨr.” ");
INSERT INTO nwi_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kɨni Yesu rɨmnor infamien ye kafan nəvhagien, nukwhao ehuə a kɨsərɨg kafan nhajounien, kɨsakur ");
INSERT INTO nwi_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","meinai rɨmnhajoun əriə, kɨsəm mə rɨpəh nəmhenien kɨn nəmhajoun mɨnə kape Loa kape Moses, meinai nəgkiarien kafan, nanmɨn aikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kɨni Yesu rɨmasɨ-pən ye tukwas meiwaiyu-pə, kɨni narmamə khapsaah khakwasɨg kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kɨni kwən kɨrik yame ravəh nəmhəyen əutən kɨrik e leprosi raməmɨr ye tɨkin ruə meiwaiyu, mənɨmkur-pən tukun, mɨni-pən tukun mɨmə, “Yermaru, tukmə nakɨrkun mə to nakor huvə yo, or huvə yo, məspir ta nəmkɨmɨk irak.” ");
INSERT INTO nwi_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kɨni Yesu rərao-pən mɨrap kwən a, mɨmə, “Ǝwəh. Yakorkeikei mə jakor. !Ǝsanɨn!” Kɨni taktəkun əmə nəmhəyen e leprosi rɨkək iran. ");
INSERT INTO nwi_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kɨni Yesu rɨmɨni-əhu in mɨmə, “Takpəh nɨni-ərhavyen narɨmnar mɨnə e kɨmi narmamə. Mərɨg yuvən məm pris kɨrik pəh in rəm mə nɨpram rɨnor məknen. Kɨni or sakrefaes kɨmi Kughen rəri-pən Loa kape Moses, pəh narmamə tukharkun mə nəfrakɨsien nakwahuvə, kɨni kafam nəmkɨmɨk ruɨrkək.” ");
INSERT INTO nwi_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kɨni Yesu rɨmavən mɨtərhav-pən taon Kapaneam, kɨni yamehuə kɨrik kape Mobael kape Rom rɨmauə məm Yesu, maiyoh kɨn nasituyen, mɨmə, ");
INSERT INTO nwi_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Yermaru. Kafak yorwok ramhə, kɨni mamapɨr apa ye nimə kafak, nɨpran fam rɨmhə. Kɨni ramərɨg pɨk nəmhəyen.” ");
INSERT INTO nwi_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kɨni Yesu rɨmɨni-pən tukun mɨmə, “Ǝwəh. Jakurə mor huvə in.” ");
INSERT INTO nwi_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mərɨg yamehuə kape mobael rɨmɨni-pən tukun mɨmə, “Yermaru, yakpəh nəmhenien mə takuə imak ikɨn. Ik yerpɨrɨg mərɨg yo ye tanə əmə. Mərɨg, takəgkiar əmə, pəh kafak slef tukrəsanɨn mɨn. ");
INSERT INTO nwi_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yakɨrkun mə nɨmhəyen a tukraməkeikei mor nəkwam, meinai yo mɨn, kafak nəmehuə mɨnə aikɨn yame kasehuə irak, kɨni yakamor nəkwairiə. Kɨni mobael mɨnə tɨksɨn aikɨn yame yo yakamehuə irəriə. Tukmə yakni-pən tuk kɨrik mɨmə, ‘Yuvən,’ kɨni tukraməkeikei mɨvən. Kɨni tukmə yakni-pən tuk kɨrik mɨmə, ‘Yuə,’ tukraməkeikei muə. Kɨni tukmə yakni-pən tuk kafak slef mɨmə, ‘Or nar e,’ tukraməkeikei mor.” ");
INSERT INTO nwi_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu rɨmnərɨg nəgkiarien e, rakur pɨk kɨn. Kɨni marar mɨni-pən tuk narmamə khapsaah yamə mɨne khakwasɨg kɨn In mɨmə, “Yakamni əfrakɨs tuk əmiə mə, nar apnapɨg kwən e pəh nien mə yemə Isrel, mərɨg yakpəh nəm-hanəyen yemə Isrel kɨrik yame kafan nhatətəyen rehuə rəmhen kɨn in. ");
INSERT INTO nwi_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yakamni-pre tuk əmiə mə narmamə khapsaah tukhasɨ-pən ye kantri pɨsɨn pɨsɨn mɨnə, mhauə mɨsəvɨgɨn kwis ye tebol iriə Ebraham mɨne Aesak mɨne Jekob apa ye rao ye neai. ");
INSERT INTO nwi_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mərɨg kɨmiə kwənərəus kape Isrel yame Kughen rɨmnəkupan mɨrpen əmiə mə In tukrarmaru irəmiə, In tukrarak-ərhav kɨn əmiə iruə ye nəpɨgnəpien. Kɨni aikɨn a narmamə tuksasək, mɨsəkwəruə meinai kɨsərɨg nəmhəyen ehuə.” ");
INSERT INTO nwi_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kɨni Yesu rarar mɨni-pən tuk yemehuə kape mobael mə, “Yuvən. Kafam yorwok tukrɨhuvə rəmhen kɨn yame nakwəni nəfrakɨsien mə Kughen tukror.” Kɨni ye nɨpɨg atuatuk a, yorwok kafan rɨmnəsanɨn mɨn. ");
INSERT INTO nwi_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Aikɨn, Yesu rarar, mɨvən apa nimə kape Saemon Pita. Ye nɨpɨg a, kuhu Saemon ramhə maməpan-əpan pɨk, kɨni Yesu rɨmavən məm, ");
INSERT INTO nwi_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","məker-pən ye kwermɨn, məkneikɨn nəpan-əpanien rəta. Kɨni piahwaru a rərer, mɨvən mɨruk ta nəriə nəvɨgɨnien. ");
INSERT INTO nwi_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kɨni nɨpɨg mɨrh natukrivə, narmamə khapɨk narmamə khapsaah yamə mɨne nanmɨn has ramərer-pən irəriə, kɨni Yesu rɨmnəgkiar əmə maməko ta nanmɨn has mɨnə, mor huvə narmamə yamə mɨne kamhamhə. ");
INSERT INTO nwi_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nar a rɨmɨtərhav-pə ror Nəgkiarien kape profet kupan e Aesea ruauə mɨnor nəfrakɨsien kɨn, yame rɨmɨni mɨmə, “In rɨmɨvəh-si ta nəmhəyen mɨnə kapətawə, kɨni mor nɨpraitawə yamə mɨne kamhamhə, kwənhahuvə mɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kɨni nɨpɨg Yesu rəm nukwhao kɨsərer ərkurao kɨn, kɨni rɨmɨni-pən tuk kafan narmamə mə, “Takhavən ye nɨkar lugun pən.” ");
INSERT INTO nwi_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aikɨn yemhajoun kɨrik kape loa ruə mɨni-pən tukun mɨmə, “Yhajoun. Yo jakɨkwasɨg kɨn Ik ikɨn hiə takvən ikɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mərɨg Yesu rɨni-pən tukun mɨmə, “Kuri aparu mɨnə, kapəriə nəpəəg rarə yame kasapɨr ikɨn. Kɨni man mɨnə, nimairiə rarə yame kasapɨr ikɨn. Mərɨg Yo, Ji Yermamə, kafak nimə rɨrkək tuk napɨrien.” ");
INSERT INTO nwi_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kɨni yermamə kɨrik kafan rɨni-pən tukun mɨmə, “Yermaru. Pəh pi pom. Eighaan kɨn yo pəh yakvən mɨnɨm rɨmɨk.” ");
INSERT INTO nwi_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mərɨg Yesu rɨni-pən tukun mɨmə, “Nɨkam. Apəh-pən, mɨkwasɨg kɨn Yo. Narmamə yamə mɨne khapəh nhavəhyen nɨmraghien pəh khavən mhanɨm nəmə mhə mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kɨni ai, Yesu rat-pən ye bot, kɨni kafan narmamə mɨnə khakwasɨg kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Məkneikɨn, nɨmətag ehuə kɨrik rɨmnəvi nu, kɨni nu rɨnamakətənɨm kɨn bot. Mərɨg Yesu ramapɨr. ");
INSERT INTO nwi_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kɨni narmamə kafan kɨmnhavən mhasɨg In, mhamə, “!Yemehuə! !Yemehuə! !Vəh mɨragh ətawə! !Kɨnasəmnɨm!” ");
INSERT INTO nwi_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kɨni Yesu raiyoh-pən əriə mɨmə, “?Nakashawor mamhagɨn məkneikɨn? ?Nhatətəyen hiə kapəmiə?” Kɨni rarar, mɨni-əhu nɨmətag mɨne peao-peao ehuə. Nɨmətag reiwaiyu. Nu reiwaiyu mamərinu mɨn. ");
INSERT INTO nwi_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Mərɨg nəmə mɨnə a kɨsakur, mɨsaiyoh əriə mɨnə mhamə, “!Eh! ?Naha e yermamə? !Nar apnapɨg mə nɨmətag mɨne nu, mərɨg tukmə raməgkiar kawor nəkwan!” ");
INSERT INTO nwi_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kɨmnhavi-pirə bot mhavən mhavhiak apa kwənmhaan a kamni kɨmə Gedara. Məkneikɨn, yermamə kɨraru yamə mir nanmɨn has ramərer-pən irəriu kɨrasɨ-pən ye nəpəəg kapier yame kamnɨm narmamə ikɨn. Iriu karoh narmamə, narmamə kamhagɨn-pən aikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Kɨrauə mɨwəm Yesu kɨrəmə, “!Eh! !Ji Kughen! ?Nakmə takhawor əmru? ?Nakwauə mə takor narpɨnien kɨmi əmru yame rɨpəh hanə norien nɨpɨg tukun, uə?” ");
INSERT INTO nwi_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ikɨn aikɨn a, pukəh mɨnə khapsaah kasəruk ikɨn, mərɨg isok kəskəh tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kɨni nanmɨn has mɨnə kɨmɨsaiyoh-pən skai kɨmi Yesu mhamə, “!Aweh! Tukmə nakmə takəko ta əmawə, əta-pən irəmawə yerki pukəh mɨnə a.” ");
INSERT INTO nwi_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “!Havən!” Məkneikɨn, nanmɨn has mɨnə a kɨmnhatərhav ye kwərə mir a mhavən yerki pukəh mɨnə. Kɨni pukəh mɨnə a, iriə fam kɨmɨsaiyu mɨseiwaiyu ye nəpatu, mhavi-ərhav mɨsəmnɨm ye tahik. ");
INSERT INTO nwi_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kɨni ai, narmamə yamə mɨne kasəvɨgɨn pukəh mɨnə a kɨmɨsaiyu, mhavən apa ye taon mɨsəvsao-pən kɨn narɨmnar fam, mɨne narɨmnar yame Yesu rɨmnor kɨmi kwərə mir yamə mir a nanmɨn has rɨmamərer-pən irəriu. ");
INSERT INTO nwi_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kɨni narmamə mɨ-fam yamə mɨne kasarə apa taon khatərhav, mhauə tuk Yesu masəkeikei kɨmin mə tukrɨtərhav aikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kɨni Yesu rat-pən ye bot mukurao-pən ye nɨkar nu, mɨtərhav-pən iman ikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kɨni narmamə tɨksɨn kharəh yermamə kɨrik mhavən kɨmin. Nɨpran rɨmamhə. Ramapɨr ye kafan nɨkaokao. Kɨni Yesu rɨmnəm kapəriə nhatətəyen, kɨni mɨni-pən tuk yemə ramhə mɨmə, “Narɨk, pəh nɨgɨnien. Yakwərəh-si ta fam ta narpɨnien kape təvhagə has kafam.” ");
INSERT INTO nwi_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kɨni nəmhajoun mɨnə tɨksɨn kape Loa kape Moses kɨmɨsərɨg nəgkiarien a, mhani-pən tuk əriə mɨnə mhamə, “!Ah! !Nəgkiarien a rahas! Kwən a raməgkiar məknakɨn mamni mə in Kughen.” ");
INSERT INTO nwi_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mərɨg Yesu In ruɨrkun ta kapəriə nətərɨgien, kɨni mɨni-pən tuk əriə mɨmə, “?Rhawor e nətərɨgien kapəmiə ramahas məkneikɨn? ");
INSERT INTO nwi_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","?Jakni-pən naha tuk yermamə a, kɨni kɨmiə nakasəm mə nəgkiarien kafak rəfrakɨs? ?Mə jakni-pən tukun mə yakwərɨsɨn ta narpɨnien kape kafan təvhagə hah? ?Uə mə jakni-pən tukun mə tukrhekɨmter məriwək mamvən? ");
INSERT INTO nwi_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mərɨg yakorkeikei mə jakor Yo mə takharkun mə Yo, Ji Yermamə, yakvəh nehuəyen ye tokrei tanə tuk nɨvəhsi-tayen narpɨnien kape təvhagə has.” Kɨni marə mɨni-pən tuk kwən a mɨmə, “Yakamni-pre tuk ik mə, ‘Takhekɨmter, mɨrəh kafam nɨkaokao məriwək mamvən imam yerkwanu.’” ");
INSERT INTO nwi_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kɨni taktəkun əmə, kwən a rhekɨmter, məriwək mamvən iman ikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kɨni narmamə m-fam kɨsəm kɨsakur pɨk kɨn, masəgnəgɨn Kughen yame ravəhsi-pən nehuəyen kɨmi yermamə mə tukror məknakɨn. ");
INSERT INTO nwi_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kwasɨg ikɨn ye narɨmnar mɨnə e, Yesu rɨtərhav maməriwək mamvən, kɨni məm kwən kɨrik yame ramərer tuk mane kape takis, nhagɨn e Matiu. Ramkwətə ikɨn kamərok takis ikɨn. Kɨni Yesu rɨmɨni-pən tukun mɨmə, “Yuə, mɨkwasɨg kɨn Yo.” Məkneikɨn Matiu rərer, mɨkwasɨg kɨn Yesu. ");
INSERT INTO nwi_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kɨni Yesu rɨmavən məvɨgɨn ye nimə kape Matiu, kɨni narmamə khapsaah yamə mɨne kasərer tuk mane kape takis, mɨne yor təvhagə has pɨsɨn pɨsɨn mɨnə kɨmnhauə mɨsəkwətə mɨsəvɨgɨn iriə Yesu mɨne kafan narmamə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mərɨg nɨpɨg Farisi mɨnə kɨmɨsəm nar a, khani-pən tuk narmamə kape Yesu mɨnə mhamə, “!Ah! ?Rhawor e yhajoun kapəmiə raməvɨgɨn iriə narmamə yamə mɨne kasərer tuk mane kape takis mɨne yor təvhagə has mɨnə?” ");
INSERT INTO nwi_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mərɨg Yesu rɨni-pən tuk əriə mɨmə, “Pəh nien mə narmamə yamə mɨne kɨsəsanɨn khamhavən mɨsəm dokta. Mərɨg narmamə yamə mɨne kamhamhə, tukasəkeikei mhavən mɨsəm dokta. ");
INSERT INTO nwi_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mərɨg havən mɨsarha-kɨn nɨprai nəgkiarien e ye Nəkwəkwə kape Kughen yame ramni mə, “‘Nar kɨrik ror rɨkik ramagien, in e mə rɨkimiə tukrehuə tuk narmamə, mərɨg rɨkik rɨpəh nagienien tuk kapəmiə sakrefaes mɨnə.’” Kɨni Yesu rɨrpɨn nəgkiarien mɨmə, “Yakamni məkneikɨn meinai pəh nien mə Yo yɨmauə mə jakokrən kɨn narmamə yamə mɨne khamə ta mə kwəsatuatuk ta. Nɨkam. Yɨmauə mə jakokrən kɨn yor təvhagə has mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kɨni narmamə kape Jon Baptaes kɨmnhauə mɨsəm Yesu mhani-pən tukun mhamə, “Ǝm-ru. Farisi mɨnə mɨne kɨmawə yaksəpəh nəvɨgɨnien tuk nəhuakien kɨmi Kughen. ?Mərɨg rhawor kafam narmamə mɨnə khapəh nɨsəpəhyen nəvɨgɨnien tuk nəhuakien?” ");
INSERT INTO nwi_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Mərɨg Yesu rɨni-pən tuk əriə mɨmə, “Nɨpɨg kɨmiə nɨmɨsor nəvɨgɨnien kape yerman yame rɨmnarkurək pə pə, ?mərɨg nakhamə ta mə in mɨnə tɨksɨn tuksasək ye nɨpɨg a uə? !Nɨkam! Mərɨg tukrɨpior nɨpɨg yame narmamə tukhavəhsi-ta Yerman e yame rɨmnarkurək pə pə tuk In mɨnə tɨksɨn. Kɨni ye nɨpɨg a in a, In mɨnə tɨksɨn tuksəpəh nɨsəvɨgɨnien iran. ");
INSERT INTO nwi_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“To yermamə kɨrik rɨpəh nɨvəhyen kwonmut neipən vi kɨrik kɨni mɨjir-pən ye neipən mətɨt kafan yame rɨmneikus. To ror məknakɨn, kwonmut neipən yame rɨvi to reikus neipən mətɨt, kɨni reikus ehuə. ");
INSERT INTO nwi_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kɨni to yermamə kɨrik rɨpəh nɨvəhyen waen wi kɨni mɨvi-pən ye tɨki waen mətɨt. To ramor məknakɨn, kɨni waen a ye tɨki waen mətɨt tukrəməteih, kɨni waen tukraiyu. Nɨkam, kɨpəh norien məknakɨn. Tukaməkeikei kɨvi-pən waen wi ye tɨki waen wi. Kɨni waen mɨne tɨki waen tukawəmɨr huvə.” ");
INSERT INTO nwi_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nɨpɨg Yesu raməgkiar hanə kɨmi əriə, yemehuə kɨrik ruə mənɨmkur-pən tuk Yesu mɨmə, “Eh. Kafak piakəskəh rɨpimhə ai taktakun əmə. Mərɨg yuə, mərəhu-pən kwermɨm iran, pəh ramragh mɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kɨni Yesu rɨmnərer iriə kafan narmamə mɨnə, mhakwasɨg kɨn kwən a mamhavən. ");
INSERT INTO nwi_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Məkneikɨn pian kɨrik aikɨn yame ravəh nəmhəyen kape nɨpiraovɨn, mɨvəh newk twelef. Kɨni rukurao-pən ye nɨmetai Yesu ikɨn, mərao-pən mɨrap nəpəəg nɨmrɨ kot kafan. ");
INSERT INTO nwi_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ye nərɨgien kafan rɨmə, “Tukmə yakrap əmə kafan kot, kɨni jakəsanɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kɨni Yesu rukreik marha-pən məm pian a mɨni-pən tukun mɨmə, “Piakəskəh kafak. Pəh nɨgɨnien. Kafam nhatətəyen rɨmnor ik nakwahuvə mɨn.” Kɨni ye nɨpɨg a, pian a rɨmnəsanɨn. ");
INSERT INTO nwi_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kɨni nɨpɨg Yesu rɨmauə mɨtərhav-pə ye nimə kape yemehuə a, kɨni mɨvən imə, məm narmamə kɨsher tərhenao masəni nɨpei kape nɨmhəyen. Kɨni narmamə kɨmnhauvrɨg-uvrɨg pɨk. ");
INSERT INTO nwi_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Kɨni Yesu rɨmɨni-pən tuk əriə mɨmə, “Sap mhatərhav. Piakəskəh e rapəh nɨmhəyen; ramapɨr əmə.” Mərɨg narmamə kɨsarh iakei iran. ");
INSERT INTO nwi_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mərɨg narmamə kɨmnhatərhav mhavən iruə, kɨni Yesu rɨvən imə, mɨrao-pən mɨvəh kwermɨ piakəskəh a, kɨni rhekɨmter. ");
INSERT INTO nwi_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kɨni nəvsaoyen kɨn rɨmnaiyu markurao fam ye tanə a. ");
INSERT INTO nwi_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu rɨmatərhav aikɨn a, kɨni lnɨmrɨn pɨs mir kɨraru karakwasɨg kɨn, mwokrən apomh mɨrəmə, “Mɨkɨp King Deved. !Rɨkim tukrehuə tuk əmru!” ");
INSERT INTO nwi_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kɨni Yesu rɨmavən apa imə, kɨni nɨmrɨn pɨs mir a kɨrauə tukun. Kɨni Yesu rɨni-pən tuk əriu mɨmə, “?Kɨmiru nakwhatətə irak mə to yakor huvə nɨmrɨmiru uə nɨkam?” Kɨni iriu kɨrəni-pən tukun mɨrəmə, “Ǝwəh, Yermaru.” ");
INSERT INTO nwi_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kɨni Yesu rɨmɨrap nɨmrɨriu mɨni-pən tuk əriu mə, “Kughen tukror huvə nɨmrɨmiru meinai nakwhatətə irak.” ");
INSERT INTO nwi_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kɨni nɨmrɨriu rhuvə, kɨnəwəm nar. Kɨni Yesu rɨni-pən skai tuk əriu mɨmə, “Takrapəh nəvsaoyen kɨn narɨmnar mɨnə e kɨmi narmamə.” ");
INSERT INTO nwi_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mərɨg iriu kɨmɨratərhav mɨravən mwəvsao-ərhav kɨn Yesu, mɨravən ikɨn mɨnə fam ye tanə a. ");
INSERT INTO nwi_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nɨpɨg kwərə mir a kwəratərhav, narmamə kharəh yermamə kɨrik yame reinein nəgkiarien, mhauə tuk Yesu. Kwən a in reinein nəgkiarien meinai nanmɨn has ramərer-pən iran. ");
INSERT INTO nwi_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kɨni Yesu rɨmnəko ta nanmɨn hah ye kwən a, kɨni rɨmnəgkiar. Kɨni nukwhao ehuə kɨsəm, kɨsakur pɨk tukun, mhani mhamə, “Kɨpəh nəm-hanəyen nar kɨrik ror məkneikɨn ikɨn e Isrel.” ");
INSERT INTO nwi_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mərɨg Farisi mɨnə khani mhamə, “!Nɨkam! Rɨrkun nəko-tayen nanmɨn has mɨnə meinai rɨkwasɨg kɨn Setan, yemehuə kape nanmɨn has mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kɨni Yesu rɨmnəriwək mamvən ye taon mɨne yerkwanu mɨnə fam, maməwhag ye nəkwai nimə kape nofugɨnien, mamni-ərhav nəvsaoyen huvə kape narmaruyen kape Kughen. Mamor huvə narmamə m-fam yamə mɨne kamhamhə, mɨne narmamə m-fam yamə mɨne nɨprairiə raha, kamhahuvə. ");
INSERT INTO nwi_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nɨpɨg rɨmnəm narmamə kwənhapsaah, kɨni rɨkin raməmhə pɨk tuk əriə meinai kɨmɨsarə ye nɨpɨg əutən mɨnə, mɨseinein nɨsasitu-atukien irəriə ye kapəriə nɨmraghien rəmhen kɨn sipsip yamə mɨne yermamə rɨkək tuk narha-huvəyen tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kɨni rɨni-pən tuk kafan narmamə mɨnə mə, “!Səm-ru! Nəvɨgɨnien rɨnehuə apa ye nəsimien yame kwənhamruə. Mərɨg yorwok kwatɨksɨn əmə yame kamhavəh. ");
INSERT INTO nwi_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kɨni səhuak-pən kɨmi Yemasur kape nəsimien mhamə In tukrher-pən kɨn yorwok mɨnə khapsaah mə tukhavən mhavəh nəsimien kafan.” ");
INSERT INTO nwi_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Kɨni Yesu rɨmnokrən kɨn narmamə twelef kafan khauə kɨrikianə, kɨni rɨvəh-si-pən nəsanɨnien kɨmi əriə tuk nəkotayen nanmɨn has ye narmamə, mɨne tuk nor-huvəyen nəmhəyen mɨnə fam. ");
INSERT INTO nwi_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nhag aposol twelef kape Yesu mɨnə, iriə e: yame raməkupan, Saemon, nhagɨn kɨrik e Pita; mɨne naorahini Andru; mɨne Jemes mɨne Jon, ji Sebedi mir; ");
INSERT INTO nwi_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","mɨne Filip; mɨne Batalomiu; mɨne Tomas; mɨne Matiu, yermamə kape nɨvəhyen mane kape takis; mɨne Jemes ji Alfeas; mɨne Tadeas; ");
INSERT INTO nwi_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","mɨne Saemon Selot; mɨne Judas Iskariot, yame rɨmneighan-pən kɨn Yesu ramvən ye kwermɨ tɨkmɨr mɨnə kafan. ");
INSERT INTO nwi_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Kwasɨg ikɨn Yesu rher-pən kɨn kafan narmamə twelef mə tukhavən mɨsor wok, mɨni-pən tuk əriə mɨmə, “Takhapəh nhavənien mɨsarə kɨmiə narmamə yamə mɨne pəh nien mə kwənərəus kape Isrel; kɨni mhapəh nhavənien ye taon kɨrik kape nəmə Sameria, ");
INSERT INTO nwi_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","mərɨg takhavən mɨsarə kɨmiə nəmə Isrel yamə mɨne kɨsəmhen kɨn sipsip yamə mɨne kaserwei. ");
INSERT INTO nwi_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kɨni nɨpɨg takamhavən, takasəkeikei mamhani-ərhav mhamə, ‘Nɨpɨg yame Kughen tukrarmaru ye narmamə mɨfam ruauə ipakə.’ ");
INSERT INTO nwi_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kɨni kɨmiə takasəkeikei mɨsor huvə narmamə yamə mɨne kamhamhə. Kɨni takasəkeikei mɨsor huvə narmamə yamə mɨne kwənhamhə ta mə tukhamragh mɨn. Kɨni narmamə yamə mɨne leprosi ramor tɨkiriə, takasəkeikei mɨsor nɨprairiə ruə mɨhuvə mɨn. Kɨni narmamə yamə mɨne nanmɨn has ramərer-pən irəriə, takasəkeikei mɨsəko ta əriə. Kɨni tukmə naksasitu ye yermamə kɨrik, tukrɨpəh nərokien əmiə iran, meinai nɨmnhapəh nhavəhyen nɨmrɨ nɨrkunien tuk nor huvəyen narmamə. ");
INSERT INTO nwi_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Tukmə nakamhavən, takhapəh nhavəhyen mane, ");
INSERT INTO nwi_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","mhapəh nharurien nɨtɨp mɨnə. Mhapəh nhavəhyen neipən kɨraru kɨraru. Mhapəh nhavəhsi-pənien sandel, mhapəh nhavəhyen kaskɨn. Yakamni məkneikɨn meinai ratuatuk əmə mə narmamə yamə mɨne kɨmiə taksasitu irəriə tuksasitu mɨn irəmiə ye napɨrien mɨne nəvɨgɨnien. ");
INSERT INTO nwi_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Nɨpɨg takhavən ye taon kɨrik uə yerkwanu kɨrik, taksəkeikei mɨsarha-kɨn yermamə kɨrik yame rɨkin ragien mə takhavən mɨsarə kɨmiə min, kɨni mɨsarə aikɨn mɨseriaji nɨpɨg yame takhatərhav yerkwanu a. ");
INSERT INTO nwi_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tukmə nɨpɨg takamhavən mɨsarə ye nimə kɨrik, takasəkeikei mɨsəgkiar huvə kɨmi əriə mhamə, ‘Pəh nəmərinuyen tukraməmɨr tuk əmiə.’ ");
INSERT INTO nwi_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kɨni tukmə narmamə kɨsəhitə ye nimə kapəriə tuk əmiə, kɨni pəh kapəmiə nəgkiarien kape nəmərinuyen tukraməmɨr tuk əriə. Mərɨg tukmə kɨsəpəh, nəhuakien kapəmiə ye nɨkarɨn kape nəmərinuyen tukrurə əmə ye nɨmraghien kapəmiə. ");
INSERT INTO nwi_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mərɨg tukmə narmamə tɨksɨn khapəh nɨsəhitəyen ye nimə kapəriə tuk əmiə, uə khapəh nɨsətərɨgien kɨn nəgkiarien kapəmiə, takhatərhav ye nimə kapəriə, uə yerkwanu kapəriə, mɨsarpita-arpita nɨmokrur ye sandel kapəmiə. ");
INSERT INTO nwi_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yakamni əfrakɨs tuk əmiə mə ye nɨpɨg yame Kughen tukrəkir narmamə iran, narpɨnien kape nəmə aikɨn a tukrɨskai pɨk rapita narpɨnien yame nəmə Sodom mɨne Gomora kɨmɨsarə iran kupan.” ");
INSERT INTO nwi_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Kɨni Yesu ramni mɨmə, “Takasəkeikei mharkun mə Yo yakamher-pən kɨn əmiə mə takhavən mɨsarə mar yerki nəmə has mɨnə rəmhen kɨn sipsip yamə mɨne kasəriwək yerki kuri aparu yamə mɨne kasəkwəpah. Takasəkeikei mhavəh nɨrkunien tuk niko-ikoyen rəmhen əmə kɨn snek; mɨsarə mar rəmhen əmə kɨn mak ye tanə. ");
INSERT INTO nwi_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Takasərɨg əmiə tuk narmamə; meinai iriə tuksərɨp-ərhav əmiə ye nɨmrɨ mɨrh, mɨsərkɨs-ərkɨs əmiə ye nəkwai nimə kape nofugɨnien kapəriə. ");
INSERT INTO nwi_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Meinai kɨmiə kafak narmamə mɨnə, taksəkeikei mɨsərer ye nɨmrɨ namasur kape gavman mɨne ye nɨmrɨ nəmasur kapəmiə tuk nɨni-ərhavyen Nəgkiarien Huvə kape Kughen kɨmi əriə mɨne narmamə yamə mɨne pəh nien mə kwənərəus kape Isrel. ");
INSERT INTO nwi_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mərɨg nɨpɨg tukharaptərəkɨn əmiə, takhapəh nɨsətərɨg-pɨkien mə takshawor-pən iran mɨne mɨshorpɨn nəgkiarien kapəriə, meinai ye nɨpɨg atuatuk a, Nanmɨn kape Kughen tukrhajoun əmiə kɨn naha nəgkiarien yame takasəkeikei mhani-ərhav. ");
INSERT INTO nwi_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Takhapəh nhagɨnien meinai pəh nien mə kɨmiə atuk naksəgkiar, mərɨg Nanmɨn kape Rɨmɨmiə Kughen tukrɨvəhsi-pre nəgkiarien kɨmi əmiə, takhani-ərhav. ");
INSERT INTO nwi_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ye nɨpɨg a, piauni tukreighaan kɨn piauni kamhopni. Kɨni yerman tukreighaan kɨn kafan kwajikovə kamhopni. Kɨni kwajikovə mɨnə tukhani hah rɨmriə mɨnə mɨne nɨsɨnriə mɨnə, mɨseighan kɨn əriə khopni əriə. ");
INSERT INTO nwi_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Narmamə tuksəməkɨn əmiə, mɨsor ahas pre kɨmi əmiə meinai kɨmiə nakamhavəh nhagɨk. Mərɨg narmamə yamə mɨne kasərer tɨmtɨm mɨseriaji nɨpɨg kwasɨg, Kughen tukrɨvəh mɨragh əriə. ");
INSERT INTO nwi_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tukmə kɨsor ahas pre kɨmi əmiə ye taon kɨrik, sap, mhavən ye taon pɨsɨn kɨrik. Yakamni əfrah tuk əmiə mə to nakhapəh nhavən-fam-ien ye taon mɨnə kape Isrel, yo Ji Yermamə jakrerɨg-pə mɨn. ");
INSERT INTO nwi_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Studen mɨnə to khapəh nɨsehuəyen ye yhajoun kapəriə. Kɨni slef mɨnə to khapəh nɨsehuəyen ye yemehuə kapəriə. ");
INSERT INTO nwi_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","“Narmamə tukasəkeikei mɨsəm-pən studen mɨnə mə kɨsəmhen əmə kɨn yhajoun kapəriə. Kɨni tukasəkeikei mɨsəm-pən slef mɨnə mə kasəmhen əmə kɨn yamehuə kapəriə. Kɨni ye norien kɨrikianə əmə mɨn, Yo yemehuə kape nimə. Kɨni narmamə tɨksɨn khani hah yo mə yo Bielsebul, yamehuə kape yarmhə mɨnə. Ror məkneikɨn mə tukasəkeikei mɨsor mɨn ye kafak yor wok yamə mɨne kasor wok ye nəkwai nimə kafak.” ");
INSERT INTO nwi_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Kɨni Yesu ramni mɨmə, “Ror məkneikɨn, takhapəh nhagɨnien kɨn narmamə. Tukmə nar erkwaig, tukaməkeikei kəm. Tukmə kuvrɨg əpɨs, kɨni mərɨg tukraməkeikei mier-pə ikɨn rhakak ikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Narɨmnar yame yakamni-pre tuk əmiə ye nəpɨgnapien, takasəkeikei mhani-ərhav yeraan; kɨni narɨmnar yame yakaməsiwən kɨn, takasəkeikei mhani-ərhav ye nɨmrɨ narmamə khapsaah. ");
INSERT INTO nwi_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Takhapəh nhagɨnien kɨn narmamə, meinai kharkun əmə nɨsoriahyen nɨpraimiə, mərɨg kaseinein nɨshopniyen nanmɨmiə. Mərɨg hagɨn kɨn Kughen meinai In rɨrkun narakikɨn-pən-ien nɨprai jir mɨne nanmɨn apa ye nap ehuə. ");
INSERT INTO nwi_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Nar apnapɨg keihap in rɨkəskəh pɨk, kavəh nɨmrɨn kwaji mane əmə, mərɨg Kughen ramarha huvə tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Kɨni nɨmraghien kapəmiə rapita nɨmraghien kape keihap. Kɨni tukmə Kughen ramarha huvə tuk keihap ramhajoun pən mə tukraməkeikei mamarha huvə tuk əmiə rapita. Nəfrakɨsien, nar apnapɨg mə nɨmar nɨkwənemiə in nar kəskəh, mərɨg Kughen raməvhuekɨn fam muɨrkun ta mə kuvhuun. Ror pən, takhapəh nhagɨnien tuk nɨmraghien kapəmiə. ");
INSERT INTO nwi_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Tukmə yermamə kɨrik ramni-ərhav nhagɨk ye nɨmrɨ narmamə, Yo mɨn jakni-ərhav nhagɨn ye nɨmrɨ Rɨmɨk Kughen ye neai mə in kafak yermamə. ");
INSERT INTO nwi_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mərɨg tukmə yermamə ramni-ərhav ye nɨmrɨ narmamə mə reinein Yo, Yo jakni-ərhav mɨn ye nɨmrɨ Rɨmɨk Kughen ye neai mə yakeinein mɨn in. ");
INSERT INTO nwi_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Pəh rɨkimiə tukrɨpəh nəsɨkien mə ta mə yɨmauə mə jakərəhu nəmərinuyen ye tokrei tanə. Pa rɨmə yɨmauə mə jakərəhu nəmərinuyen, mərɨg yɨmauə mə jakor narmamə kasarowagkəp. ");
INSERT INTO nwi_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yakamni məkneikɨn meinai yɨmauə mə jakor “‘Yerman tukror tɨməht iriu rɨmni, mɨne piakəskəh tukror tɨməht iriu nɨsɨni, mɨne yasuni tukror tɨməht iriu kuhuni. ");
INSERT INTO nwi_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kɨni narmamə tuksor tɨkmɨr kɨmi iriə atuk mɨnə tɨksɨn.’ ");
INSERT INTO nwi_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Kɨni yermamə yame rorkeikei pɨk rɨmni mɨne nɨsɨni rapita Yo in rɨpəh nəmhenien mə tukruə kafak yermamə. Kɨni yermamə yame rorkeikei pɨk kafan pɨkwarien uə piakəskəh rapita Yo in rɨpəh nəmhenien mə tukruə kafak yermamə. ");
INSERT INTO nwi_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tukmə yermamə rɨmə tukrɨkwasɨg kɨn Yo, tukraməkeikei məta ye nərɨgien kafan, kɨni tukmə ramərɨg pawk nəmhəyen rəmhen kɨn nəmhəyen ye nɨmhəyen ye nai kamarkwao kɨn, mərɨg tukrɨkwasɨg kɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yermamə yame ramgɨn tuk kafan nɨmraghien, tukraməkeikei mɨmhə. Mərɨg yermamə yame tukuh tuk nɨkwasɨgien kɨn Yo, tukrarə ye nɨmraghien rerɨn. ");
INSERT INTO nwi_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Kɨni yermamə yame ravəh əmiə yerkin agien, in rəmhen əmə kɨn yame ravəh Yo yerkin agien. Kɨni yermamə yame ravəh Yo yerkin agien, in rəmhen əmə kɨn yame ravəh mɨn yermamə yame rɨmnher-pə kɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kɨni yermamə yame ravəh profet kape Kughen yerkin agien, meinai in rɨrkun mə in profet kape Kughen, in tukrɨvəh nərokien iran, rəmhen kɨn yame profet mɨnə kɨmnhavəh. Kɨni yermamə yame ravəh yemə atuatuk yerkin agien meinai in rɨrkun mə in yemə atuatuk, in tukrɨvəh nərokien iran rəmhen kɨn yame nəmə atuatuk tukhavəh. ");
INSERT INTO nwi_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nəfrakɨs, yermamə yame ravəh nu okiei ye pənkɨn, mɨvəhsi-pən kɨmi yermamə kɨrik kafak e, meinai in rɨrkun mə in kafak yermamə, nar apnapɨg mə kafak yermamə in ye tanə, kɨni kwən en, tukraməkeikei mɨvəh əfrakɨs nərokien iran.” ");
INSERT INTO nwi_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kɨni Yesu rɨmnəvhag ta kɨmi kafan narmamə twelef, marar, mɨtərhav aikɨn, mɨvən apa ye taon mɨnə apa Galili, maməvhag mamni-ərhav nəgkiarien kape Kughen aikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ye nɨpɨg a, Jon Baptaes rɨmnamarə ye kalabus, kɨni mamərɨg nəvsaoyen kɨn wok yame Yesu rɨmnor. Kɨni mher-pən kɨn narmamə tɨksɨn kafan khavən mɨsəm In mhamə, ");
INSERT INTO nwi_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“?Rhawor? ?Ik e Kristo kɨmɨni ta mə takuə, uə kɨmawə jakamhawhin yarmə kɨrik tukrɨpiuə?” ");
INSERT INTO nwi_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Məkneikɨn, Yesu rɨni-pən tuk əriə mə, “Harerɨg, mhavən mhani-pən narɨmnar mɨnə fam yamə mɨne nɨmɨsərɨg mɨsəm tuk Jon. ");
INSERT INTO nwi_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nɨmrɨn pɨs mɨnə khapsaah kɨmɨsəm nar. Kɨni narmamə yamə mɨne nɨhuriə rahas kɨmɨseriwək. Kɨni narmamə yamə mɨne kamhavəh nəmhəyen ye tɨkiriə, tɨkiriə ruahuvə. Kɨni narmamə yamə mɨne nɨmətɨrgɨriə rəru, kɨni taktəkun ai, kɨmɨsərɨg nar. Kɨni narmamə yamə mɨnə kɨmnhamhə, kwənhamragh mɨn. Kɨni yavən hah mɨnə, taktəkun ai kwən kɨrik rɨnamni-ərhav-pən nəvsaoyen huvə tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kɨni hani-pən tuk Jon mə narmamə yamə mɨne kapəriə nhatətəyen irak rɨpəh nɨmɨrien, iriə tuksarə ye nɨhuvəyen əfrakɨs.” ");
INSERT INTO nwi_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nɨpɨg narmamə a yame Jon rɨmnher pən kɨn əriə kratərhav, kɨni Yesu rɨmɨrikakun maməgkiar kɨn Jon kɨmi nukwhao ehuə. Mɨmə, “?In apa kupən kɨmiə nɨmnhavən apa ye tɨpəvsɨk mə taksəm naha nhagɨn? ?Nɨmnhavən mə taksəm əmə yermamə apnapɨg kɨrik yame in rəmhen kɨn nuwig yame ramərer ye nɨmrɨ nµmətag? !Nɨkam! ");
INSERT INTO nwi_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","?Tukmə nɨkam, kɨni nɨmnamhavən mə taksəm pa? ?Yermamə kɨrik yame ramvən ye neipən huvə yame nɨmrɨn rəutən uə? !Nɨkam! Narmamə yamə mɨne kamhavən ye neipən huvə kɨsarə ye nimə huvə mɨnə rəmhen kɨn kape king. ");
INSERT INTO nwi_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","?Kɨni naha nhagɨn a nɨmnhavən mə taksəm? ?Profet kɨrik uə? Ǝwəh, nəfrakɨsien. Mərɨg yakamni-pre tuk əmiə mə Jon in yerpɨrɨg rapita profet. ");
INSERT INTO nwi_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Meinai kwən e in e Nəkwəkwə kape Kughen rɨmɨni-ta mɨmə, “‘Səm-ru. Yakamher-pre kɨn kafak yermamə yame tukrɨvəh kafak nəgkiarien. In tukrəkupən kɨn ik mor apnəpeinə ye kafam swatuk.’ ");
INSERT INTO nwi_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Yakamni-pre tuk əmiə mə narmamə yamə mɨne kɨmɨsarha-pə ye tokrei tanə, kɨrik rapəh nuəyen yame rapita kwən e Jon. Mərɨg yermamə yame in ye tanə əmə ye narmaruyen kape Kughen, in yerpɨrɨg mɨn rapita Jon. ");
INSERT INTO nwi_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ye nɨpɨg Jon Baptaes rɨmɨrikakun mamni-ərhav nəgkiarien kape Kughen meriaji-pə taktakun, narmaruyen kape Kughen ramskai mə tukrɨtərhav-pə. Kɨni narmamə yamə mɨne khaskai mɨsarkut pɨk mə tukhauə pəh Kughen rarmaru irəriə. ");
INSERT INTO nwi_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yakamni məknakɨn meinai apa kupan əgkap muə meriaji-pə nɨpɨg kape Jon, nəgkiarien kape Loa yame Kughen rɨmɨvəhsi-pən kɨmi Moses mɨne nəgkiarien kape profet kape Kughen mɨnə kɨmnhani-ərhav narmaruyen kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kɨni tukmə rɨkimiə ragien mə takhavəh nətərɨgien e, jakni mə Jon in Elaeja yame profet kupan mɨnə kɨmnhani mə tukruə. ");
INSERT INTO nwi_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tukmə kɨmiə narmamə yame nɨmətɨrgɨmiə rarə, sətərɨg huvə kɨn nəgkiarien e. ");
INSERT INTO nwi_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“?Kɨni Yo jakni mə narmamə yamə mɨne kɨsarə ai taktəkun, mə norien kapəriə rəmhen kɨn naha? Iriə kɨsəmhen əmə kɨn kwajikovə yamə mɨne nar kɨrik rɨrkək yame tukror əriə, rɨkiriə ragien. Mɨsəkwətə masəukɨr ikɨn kamor maket ikɨn, mashek əriə mɨnə mhamə, ");
INSERT INTO nwi_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘!Ah! Kɨmawə yɨmnhauh gita, mərɨg kɨmiə nakhapəh nɨsorien danis. Kɨni yaksarar mɨseikuə kɨn nasəkien tuk nɨmhəyen, mərɨg kɨmiə nɨmnhapəh nɨsasəkien kɨtawə-m kɨmiə.’ ");
INSERT INTO nwi_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yakamni məknei meinai ye nɨpɨg Jon Baptaes rɨmauə, məpəh nəvɨgɨnien mə tukrəhuak nɨpɨg rɨpsaah, mɨpəh nɨnɨmien waen. Mərɨg narmamə kamhani mhamə, ‘Kwən a, nanmɨn has kɨrik raməmɨr iran.’ ");
INSERT INTO nwi_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kɨni Yo, Ji Yermamə, yɨmauə maməvɨgɨn, mamnɨm waen, mərɨg narmamə kamhani mɨn mhamə, ‘!Ah! Kwən a in yermamə kape nəvɨgɨn-pɨkien, mɨne napɨsien kɨn waen. Kɨni mamor norkeikeiyen kɨmi yor təvhagə has mɨnə mɨne narmamə yame kasərer tuk mane kape takis.’ Mərɨg narmamə əfrakɨs kape Kughen mɨnə tukasəkeikei mharkun mə kɨmru Jon yakawor narɨmnar ye nɨrkunien əfrakɨs.” ");
INSERT INTO nwi_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kɨni Yesu rɨmnəgkiar skai kɨmi narmamə ye taon yame mɨne In rɨmnor nɨmtətien rɨpsaah aikɨn ye nɨmrɨriə. Raməgkiar skai məknakɨn meinai iriə khapəh nɨsararien ye nərɨgien kapəriə tuk kapəriə norien has mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Kɨni In mɨmə, “!Ah! !Kɨmiə yamə mɨne nakɨsarə apa Korasin! Nəmhəyen ehuə tukrurə tuk əmiə. !Ah! !Kɨmiə nəmə Betsaeda! Nəmhəyen ehuə tukrurə tuk əmiə, meinai yɨmnor pawk nɨmtətien rɨpsaah ye taon mir kapəmiə. Kɨni tokmə yakpior nɨmtətien mɨnə a apa Taea mɨne Saedon kupən, narmamə a to kɨpisarar ye nərɨgien kapəriə tuk təvhagə has mɨpihavən ye neipən has, mɨsəsok-əsok ye nɨmrawk ror nɨmtətien mə kɨsərɨg rahas pɨk tuk kapəriə norien has mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mərɨg ye nɨpɨg a yame Kughen tukror narpɨnien kapəmiə, in tukrɨskai pɨk rapita narpɨnien yame tukror kɨmi narmamə yamə mɨne kɨmnɨsarə apa Taea mɨne Saedon kupən. ");
INSERT INTO nwi_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kɨni kɨmiə nəmə Kapeneam. ?Kɨmiə nakhamə ta mə Kughen tukrɨvəh-si haktə əmiə ye kwənmhaan kape nɨsiaiyen ye rao ye neai uə? !Nɨkam! Kughen tukrɨvəh-si-əhu əmiə naksweiwaiyu pɨk əgkəp, ye kwənmhaan kape narpɨnien. Kɨni tokmə yakpior nɨmtətien mɨnə a apa Sodom kupan, to taon a rɨpipəh nɨrkəkien. ");
INSERT INTO nwi_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mərɨg yakamni-pre tuk əmiə mə nɨpɨg a yame Kughen tukror narpɨnien kapəmiə, in tukrɨskai pɨk rapita narpɨnien yame tukror kɨmi narmamə yamə mɨne kɨmnɨsarə apa Sodom kupən.” ");
INSERT INTO nwi_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kɨni ye nɨpɨg a Yesu rɨmə, “Tatə Kughen. Ik Yermaru kape narɨmnar fam- yerpɨrɨg ye neai, mɨne ye tokrei tanə. Yakəgnəgɨn Ik meinai Ik nɨmnerkwaig kɨn nɨprai narɨmnar mɨnə e ye nɨmrɨ narmamə yamə mɨne kharkun nar. Kɨni mor əpu kɨmi narmamə yamə mɨne kɨsəmhen əmə kɨn kwajikovə mɨnə mə iriə e tukharkun nar. ");
INSERT INTO nwi_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tatə, in a norien yame Ik nakorkeikei.” ");
INSERT INTO nwi_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kɨni Yesu rɨrpɨn mamni-ərhav mɨmə, “Rɨmɨk rɨmneighan-pə ta kɨn narɨmnar fam ye kwermɨk. Kɨni Rɨmɨk pɨsɨn əmə rɨrkun Tɨni. Kɨni Tɨni əmə mɨne narmamə kafan mɨnə, iriə əmə kharkun Tatə Kughen. Iriə e narmamə yamə mɨne Tɨni rɨmɨrpen ta əriə mə In tukror əpu Tatə Kughen kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Hauə tuk Yo, kɨmiə yamə mɨne nakasor pɨk wok kɨni mɨsəpəu kɨn najipəyen kɨn nar pam mɨnə, pəh yakvəhsi-pre napɨsien. ");
INSERT INTO nwi_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Yakamni məkneikɨn meinai Yo yemə mar, kɨni kafak nətərɨgien in ye tanə. Kɨni hauə tuk Yo mhavəh napɨsien ye kapəmiə nɨmraghien. Taksajipə kɨn kafak nɨtɨp meinai in rəruvəruvə, kɨni kafak wok yame jakvəhsi-pre kɨmi əmiə in rɨmar.” ");
INSERT INTO nwi_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kɨni ye Sabat kɨrik, Yesu mɨne kafan narmamə mɨnə kɨmɨsəriwək mhavən yerki wit tɨksɨn, kɨni kafan narmamə mɨnə kɨsəmkərəv. Khavən mɨsətɨm wit tɨksɨn, masən kwənkwan. ");
INSERT INTO nwi_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mərɨg Farisi mɨnə tɨksɨn kɨmɨsəm mhani-pən tukun mhamə, “!Eh! Sabat e towei, mərɨg kafam narmamə kasor wok masakapɨr Loa kape Moses. ?Rhawor e kasor məknakɨn?” ");
INSERT INTO nwi_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mərɨg Yesu rɨmɨni-pən tuk əriə mɨmə, “Tukmə ror nakhapəh nɨsəvheikɨnien nəvsaoyen ye Nəkwəkwə kape Kughen yame raməvsao kµn norien yame King Deved rɨmnor kupən, yame in mɨne kafan narmamə mɨnə kɨmɨsəmkərəv. ");
INSERT INTO nwi_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Mərɨg, Deved rɨmavən ye Nimə Ehuə kape Kughen mən bred yame pris mɨnə kwənhavəhsi-pən ta kɨmi Kughen. Mərɨg bred ai, ye Loa kape Moses ramni mə narmamə apnapɨg tukhapəh nɨsənien. Mərɨg pris mɨnə əmə kharkun nɨsənien. ");
INSERT INTO nwi_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Uə tukmə ror nakhapəh nɨsəvheikɨnien ye loa mə nɨpɨg mɨnə fam ye Sabat, pris mɨnə apa ye Nimə Ehuə Kape Kughen kasor wok kapəriə masakapɨr loa kape Sabat, mərɨg Kughen raməm mə nar a in ratuatuk əmə. ");
INSERT INTO nwi_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mərɨg yakamni-pre tuk əmiə mə kwən kɨrik eikɨn e In yerpɨrɨg rapita Nimə Ehuə kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ye Nəkwəkwə kape Kughen In ramni mə, “‘Nar kɨrik ror rɨkik ramagien, in e mə rɨkimiə tukrehuə tuk narmamə, mərɨg rɨkik rɨpəh nagienien tuk kapəmiə sakrefaes mɨnə.’” Kɨni Yesu rɨrpɨn nəgkiarien mamni-pən tuk Farisi mɨnə mɨmə, “To nakpiharkun nɨprai nəgkiarien e, mɨpiharkun narmamə yamə mɨne kɨsatuatuk, to nakpihapəh nɨsəm-pəniən nar has kɨrik ye narmamə kafak mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yakamni məkneikɨn meinai Yo, Ji Yermamə, Yo yakamarmaru ye Sabat.” ");
INSERT INTO nwi_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kɨni Yesu rɨtərhav aikɨn a məriwək mamvən ye nəkwai nimə kape nofugɨnien kapəriə. ");
INSERT INTO nwi_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kɨni ikɨn a, kwən kɨrik aikɨn, kwermɨn rɨmhə, rɨpəh nɨhuatukien kɨn. Kɨni kɨsaiyoh-pən Yesu mə, “?Rhawor? ?Ratuatuk ye loa mə to nakor huvə yermamə yame ramhə ye Sabat, uə nɨkam?” Iriə kɨmɨsaiyoh-pən məknakɨn Yesu meinai kɨsarkut mə tuksəm-pən nar has kɨrik iran. ");
INSERT INTO nwi_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Kɨni Yesu rɨmɨni-pən tuk əriə mɨmə, “?Tukmə kɨmiə kɨrik, kafan sipsip rivə-ərhav pɨkɨn ye nəkwai nɨmɨr ehuə ye Sabat, kɨni in tukrhawor? In tukraməkeikei mɨvən mɨrəh-si haktə aihuaa əmə. ?Pa e irəmiə in to rɨpəh norien məkneikɨn? Rɨrkək. ");
INSERT INTO nwi_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mərɨg nɨmraghien kape yermamə rapita sipsip. Kɨni in ratuatuk əmə ye loa mə tukamor nar huvə ye Sabat.” ");
INSERT INTO nwi_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kɨni rɨni-pən tuk kwən a mɨmə, “Huatuk kɨn kwermɨm.” Kɨni rɨhuatuk kɨn kwermɨn, rhuvə əgkəp rəmhen kɨn kwermɨn nɨkarɨn. ");
INSERT INTO nwi_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mərɨg Farisi mɨnə a kɨmnhavən, mamharai mhun mə tukshopni Yesu. ");
INSERT INTO nwi_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kɨni Yesu rɨmɨrkun mə Farisi mɨnə kɨsarkut mə tukshopni In, mɨtərhav aikɨn a. Kɨni narmamə khapsaah khakwasɨg kɨn In. Kɨni In rɨmnor huvə nəmhəyen fam kapəriə, ");
INSERT INTO nwi_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","mɨni-əhu əriə mə tukhapəh nhani-ərhavyen In tuk narmamə. ");
INSERT INTO nwi_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nar a rɨtərhav-pə ror nəgkiarien kape profet kupan e Aesea ruauə mɨnor nəfrakɨsien kɨn, yamə rɨmɨni mɨmə, ");
INSERT INTO nwi_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“In e yorwok kafak yame yɨmɨrpen ta yakorkeikei pɨk In, kɨni rɨkik ragien pɨk tukun. Kɨni Yo jakor mə Nanmɨn kafak tukrurə mukwar iran. Kɨni In tukrɨni-ərhav norien atuatuk kafak mɨne nɨvəh-mɨraghien kafak ye nɨmrɨ narmamə tanə pɨsɨn pɨsɨn mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","To In rɨpəh nuhyen əjir, mɨpəh nokrən-apomhien; Mɨpəh nəgkiar-pɨkien ikɨn narmamə kasofugɨn əriə mɨnə ikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","In yemə mar, kɨni In tukror huvə-pən kɨmi narmamə yamə mɨne kasəpəu kɨni kapəriə nəsanɨnien rɨkək. Tukror məkna meriaji-pən In tukror norien yame ratuatuk tukror win ye norien yame rahas. ");
INSERT INTO nwi_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kɨni narmamə yamə mɨne pəh nien mə kwənərəus kape Isrel, iriə tuksərəhu-pən tɨm tɨm kapəriə nərɨgien iran, mə In tukrɨvəh mɨragh əriə.” ");
INSERT INTO nwi_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kɨni narmamə kɨmnharəh kwən kɨrik mhavən kɨmi Yesu. Kwən a, nɨmrɨn rɨpɨs, rɨpəh nəgkiarien, meinai nanmɨn has ramərer-pən iran. Kɨni Yesu rɨmnor huvə mɨn, kɨni kwən a rɨmnəm nar, məgkiar. ");
INSERT INTO nwi_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kɨni narmamə m-fam kɨsəm kɨsakur pɨk kɨn mhamə, “Tukmə ror Kwən e in e Mɨkɨp King Deved yame Kughen rɨmə tukrher-pə kɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mərɨg Farisi mɨnə kɨmɨsərɨg, kamhani mhamə, “Nɨkam. Tukmə ror In raməko-ta nanmɨn has ye nəsanɨnien kape yarmhə e Bielsebul yame in yamehuə kape yarmhə mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Mərɨg Yesu ruɨrkun ta nətərɨgien kapəriə kɨni mɨmə, “Nɨkam. Tukmə narmamə ye kantri kɨrik kasəwhai əriə mɨnə, mɨsarə kɨraru, kɨni tuksoriah kapəriə narəyen, kantri tukrɨmɨr. Kɨni rəmhen mɨn kɨn yerkwanu kɨrik. Tukmə narmamə kwəsəwhai əriə mɨnə, mɨsarə kɨraru, rukwanu a to rɨpəh narə-huvəyen. ");
INSERT INTO nwi_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kɨni rəmhen mɨn kɨn narmamə kape Setan mɨnə, tukmə iriə kasəwhai əriə mɨnə, mɨsarə kɨraru, tukseikus-eikus mɨn nimə kape Setan. Norien kape Setan tukrɨpəh nɨskaiyen. Tukrəsaah-əsaah mɨrkək. ");
INSERT INTO nwi_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kɨni kɨmiə mɨnə mɨn tɨksɨn kasəko-ta nanmɨn has mɨnə rəmhen kɨn yame yakamor. Mərɨg pa rɨmə kɨsəko ta nanmɨn has mɨnə e ye nəsanɨnien kape Bielsebul. Rhuvə mə iriə tukhani neikuəyen ye nəgkiarien yame nakamhani mhamə yakaməko ta nanmɨn has ye nəsanɨnien kape Bielsebul. ");
INSERT INTO nwi_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mərɨg tukmə Yo yakaməko-ta nanmɨn has mɨnə ye nəsanɨnien kape Nanmɨn kape Kughen, ramhajoun mə narmaruyen kape Kughen ruauə ta tuk əmiə. ");
INSERT INTO nwi_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kɨni mamhen mɨn kɨn yame to yermamə kɨrik nagheen rehuə rɨvən, mətu kafan narɨmnar, maməmɨr, yermamə pɨsɨn kɨrik to rɨpəh nɨvənien məkrəh kɨn. Tukmə yermamə rɨmə tukrɨvən məkrəh kɨn kafan narɨmnar, kɨni tukrɨrkwəji yermamə ai nagheen rehuə. Kɨni ai mɨrkun nɨvənien məkrəh kɨn kafan narɨmnar. ");
INSERT INTO nwi_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Yermamə yame rɨpəh nɨkwasɨgien kɨn Yo, in kafak tɨkmɨr. Kɨni yermamə yame rɨpəh nofugɨnien narmamə mɨnə kafak, in raməko-ta əriə kɨsaiyu rik rik. ");
INSERT INTO nwi_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ror pən, yakamni-pre əfrakɨs tuk əmiə, mə Kughen rɨrkun nɨvəhsi-tayen narpɨnien ye nahasien mɨnə fam yame nakasor, uə nɨni-hasien yame nakasor iran. Mərɨg tukmə nakhani has Nanmɨn kape Kughen, to Kughen rɨpəh nɨvəhsi-tayen narpɨnien iran tuk nɨpɨg kɨrik. ");
INSERT INTO nwi_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tukmə yermamə ramni hah Yo, Ji Yermamə, kɨni Kughen tukrəru-kɨn mɨpəh narpɨnien. Mərɨg yermamə yame ramni hah Nanmɨn kape Kughen, Kughen to rɨpəh nəru-kɨnien tuk nɨpɨg kɨrik, ye nɨpɨg e uə ye nɨpɨg yame tukrɨpiuə. ");
INSERT INTO nwi_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Tukmə nai huvə, kwənkwan tukrhuvə; tukmə nai has, kwənkwan tukrahas. Ror məkneikɨn meinai kɨmiə takasəm əmə kwənkwai nai mə nai a in rhuvə uə rahas. ");
INSERT INTO nwi_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","!Ah! Kɨmiə naksəmhen kɨn snek yame ramor norien iko iko. Kɨmiə nəmə has mɨnə. To nakhapəh nhaniyen nar huvə kɨrik, meinai narmamə kamhani əmə naha nhagɨn yame raməmɨr yerkiriə. ");
INSERT INTO nwi_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yermamə yame nərɨgien rhuvə rukwar yerkin, nɨpɨg m-fam in ramni nar yame huvə. Kɨni yermamə yame nərɨgien has rukwar yerkin, nɨpɨg m-fam in ramni nar has. ");
INSERT INTO nwi_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Yakamni-pre tuk əmiə mə, ye nɨpɨg yame Kughen tukrəkir narmamə iran, narmamə tukasəkeikei mhani-ərhav-pən tukun mə rhawor iriə kɨmnhani nəgkiarien has apnapɨg mɨnə fam kapəriə. ");
INSERT INTO nwi_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ror məkneikɨn In tukrəkir fam nəgkiarien pɨsɨn mɨnə kapəmiə, mə kɨmiə nəmə atuatuk mɨnə uə nəmə has mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kɨni nəmhajoun mɨnə tɨksɨn kape Loa kape Moses mɨne Farisi mɨnə kɨmnhani-pən tukun mhamə, “Yhajoun. ?To nakor nɨmtətien əpsɨpɨs kɨrik yaksəm?” ");
INSERT INTO nwi_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kɨni Yesu rɨmɨni-pən tuk əriə mɨmə, “Kɨmiə narmamə e towei mɨne, kɨmiə naksor pɨk təvhagə has mhaukreikɨn-pən nɨmeitaimiə kɨmi Kughen, masorkeikei mə taksəm nɨmtətien pɨsɨn kɨrik. Mərɨg tukmə ror Kughen tukrɨpəh norien nɨmtətien kɨrik ye nɨmrɨmiə. Mərɨg tukror əmə nɨmtətien kɨrikianə əmə yame rɨmnor kupən ye nɨmraghien kape Jona. ");
INSERT INTO nwi_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona rɨmnaməmɨr ye tɨp kəməəm ehuə kape nɨpɨg kɨsisər, yenpɨg mɨne yeraan. Kɨni ye norien kɨrikianə əmə mɨn, Yo, Ji Yermamə, jakaməmɨr ye nəkwai nɨmɨr kape nɨpɨg kɨsisər, yenpɨg mɨne yeraan. ");
INSERT INTO nwi_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kɨni ye nɨpɨg yame Kughen tukrəkir narmamə iran, nəmə Nineve mɨn tuksərer mhani hah narmamə yamə mɨne kɨsarə e towei mɨne. Meinai nəmə Nineve a kupan kɨmɨsərɨg nəgkiarien kape Jona, mɨsarar ye nərɨgien kapəriə tuk təvhagə has. Mərɨg Yo yakapita Jona, mərɨg kɨmiə nakhapəh nɨsətərɨgien kɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kɨni in apa kupən, kwin kape kantri e Shipa, rɨmasɨ-pən isok muə mə tukrɨvəh nɨrkunien kape King Solomon kupən. Mərɨg Yo yakmauə, nɨrkunien kafak rapita King Solomon. Mərɨg kɨmiə nakhapəh nɨsətərɨgien kɨn Yo. Mə tukmə nɨpɨg Kughen tukrəkir narmamə iran, kwin a kape Shipa tukrərer mɨni-hah yamə mɨne kɨsarə e towei mɨne. ");
INSERT INTO nwi_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nɨpɨg nanmɨn has raməta ye yermamə kɨrik, in ramavən ye tɨpəvsɨk, mamarha-kɨn ikɨn tukrapɨs ikɨn, mərɨg rɨpəh nəmien. ");
INSERT INTO nwi_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Kɨni in mamni mɨmə, ‘Pəh yakrerɨg-pən ye kafak nimə yame yɨmnamarə ikɨn.’ Nɨpɨg in rɨrerɨg-pə məm kafan nimə, yermamə rɨkək iran, kɨmnahiə rɨpiə huvə, narɨmnar m-fam kamhaswin huvə. ");
INSERT INTO nwi_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kɨni in ramvən mɨkɨr mɨn nanmɨn has mɨnə iriə seven yamə mɨne kɨsahas pɨk mɨn rapita in. Kɨni khavən mɨn imə mɨsarə mɨn ye nɨmraghien kape yermamə a. Kɨni yermamə a, in apa kupən, kafan nɨmraghien rahas; mərɨg taktəkun ai rɨmnahas pɨk rapita yame in kupən. Kɨni kɨsəmhen əmə kɨn əmiə, nəmə has yamə mɨne nakasarə e taktakun.” ");
INSERT INTO nwi_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nɨpɨg Yesu raməgkiar hanə kɨmi narmamə, kɨni nɨsɨni mɨne piauni mɨnə kasərer apa iruə mhamə tuksəgkiar kɨmin. ");
INSERT INTO nwi_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kɨni yermamə kɨrik rɨni-pən tuk Yesu mɨmə, “Yemasur, nɨsɨnɨm, mɨne naorahim mɨnə khamə tuksəm-ru Ik apa iruə.” ");
INSERT INTO nwi_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mərɨg Yesu rɨmə, “?Pa e nɨsɨnɨk? ?Mɨne nɨpa e piak mɨnə?” ");
INSERT INTO nwi_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kɨni In mamhajoun-pən kafan narmamə mɨnə mɨmə, “Kɨmiə e nɨsɨnɨk mɨnə mɨne naorahik mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Meinai yermamə yame ramor narɨmnar yame Rɨmɨk Kughen rorkeikei, in ai naorahik, in ai nɨsɨnɨk, mɨne in ai nowinɨk.” ");
INSERT INTO nwi_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ye nɨpɨg atuatuk a, Yesu rɨtərhav mɨvən məkwətə apa ye nɨkar-kar nu apa Galili. ");
INSERT INTO nwi_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Meinai narmamə khapsaah kɨmnhauə mɨsərer rarkurao kɨn Yesu, In rɨmavən ye bot kɨrik mamkwətə. Kɨni narmamə kɨsərer fiak. ");
INSERT INTO nwi_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kɨni In rɨni-ərhav-pən narɨmnar rɨpsaah kɨmi əriə ye nuhpɨkɨnien mɨnə. Mamni mɨmə, “Yəsim kɨrik rɨmavən mə tɨkrɨsuv kweru nai apa ye nəsimien. ");
INSERT INTO nwi_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mɨpɨk mɨvitəg-ətəg fam. Kɨni tɨksɨn rəsaah-əsaah-pən ye swatuk, kɨni man mɨnə khauə mɨsən fam. ");
INSERT INTO nwi_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kɨni kweru nai tɨksɨn rəsaah-pən ye tokrei kapier, nɨmoptanə rɨkəskəh ikɨn. Kɨni rurə aihuaa əmə meinai nɨmoptanə rɨkəskəh. ");
INSERT INTO nwi_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mərɨg nɨpɨg mɨrh rhaktə, kɨni mhen, kɨsaukei fam meinai nuairiə rɨpəh neiwaiyu-pɨkien. ");
INSERT INTO nwi_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kɨni kweru nai tɨksɨn rəsaah-əsaah-pən yerki kwənurkəsɨk. Kɨni mhaktə mehuə. Məknekɨn, kwənurkəsɨk rerko əsuun. ");
INSERT INTO nwi_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kɨni tɨksɨn rəsaah-əsaah-pən ye nɨmoptanə huvə, kɨni mhaurə, mɨseihuə, kɨni tɨksɨn khakuə kɨn kwənkwairiə wan handred, tɨksɨn sikisti, kɨni tɨksɨn toti.” ");
INSERT INTO nwi_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kɨni Yesu rɨmə, “Tukmə kɨmiə narmamə yame nɨmətɨrgɨmiə rarə, sətərɨg huvə kɨn nəgkiarien e.” ");
INSERT INTO nwi_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kɨni narmamə kape Yesu khauə mɨsaiyoh In mhamə, “?Rhawor nakaməgkiar kɨmi narmamə ye nuhpɨkɨnien?” ");
INSERT INTO nwi_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Kɨni Yesu rɨmɨni-pən tuk əriə mə, “Yakamni məkna meinai Kughen rɨmnəhitə ye swatuk tuk əmiə mə takharkun nəgkiarien məniwən kape narmaruyen kape Kughen. Mərɨg narmamə apnapɨg mɨnə, Kughen rɨpəh nəhitəyen ye swatuk məknakɨn tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Narmamə yame mɨne kɨsəri-pən kafak nəgkiarien, Kughen tukrɨvəhsi-pən mɨn nɨrkunien kɨmi əriə. Mərɨg narmamə yamə mɨne kɨsərɨg kafak nəgkiarien kɨni mɨsor nar apnapɨg iran, Kughen tukrɨvəhsi-ta nɨrkunien kəskəh kapəriə. ");
INSERT INTO nwi_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yakaməgkiar kɨmi əriə ye nuhpɨkɨnien meinai kɨsərɨg pawk, mhapəh nharkunien; kɨni iriə kɨsarhakɨn pawk, mhapəh nɨsəmien nɨpran. ");
INSERT INTO nwi_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nɨmraghien kapəriə ror nəgkiarien kape Profet Aesea ruauə mɨnor nəfrakɨsien kɨn yame ramni mə, “‘Iriə tuksarhakɨn, mɨsarhakɨn pawk, mərɨg to khapəh nɨsəmien nɨpran. Iriə to kɨsərɨg pawk, mərɨg to khapəh nharkunien. ");
INSERT INTO nwi_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ror məkneikɨn meinai kaparia kapə ruauə muɨskai, kɨni kwəsəpou kɨn nətərɨgien kɨn nar, kɨni mɨsətapɨg kɨn nɨmrɨriə. To kɨpihapəh nɨsorien məknakɨn, kɨpisəm nar kɨn nɨmrɨriə, mɨpisərɨg nar kɨn nɨmətɨrgɨriə, mɨpiharkun nar yerkiriə, mɨpisarar ye nərɨgien kapəriə tuk təvhagə has, kɨni to Yo yakpivəh mɨragh əriə.’ ");
INSERT INTO nwi_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Mərɨg kɨmiə e, Kughen rɨmnautə-pre kɨn kafan nɨhuvəyen kɨmi əmiə, kɨni tukmə naksarha-kɨn, taksəm; kɨni tukmə naksərɨg, takharkun nɨpran. ");
INSERT INTO nwi_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yakamni-pre əfrakɨs tuk əmiə mə profet mɨnə khapsaah mɨne nəmə atuatuk mɨnə khapsaah kɨmɨsorkeikei mə tuksəm naha nhagɨn yame nakwəsəm ai taktakun, mərɨg kɨmnhapəh nɨsəmien. Kɨni mɨsorkeikei pɨk mə tuksərɨg naha nhagɨn yame nakwəsərɨg ai taktakun, mərɨg kɨmnhapəh nɨsərɨgien. ");
INSERT INTO nwi_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Kɨmiə sətərɨg huvə kɨn nɨprai nuhpɨkɨnien kape yəsim. ");
INSERT INTO nwi_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kweru nai yame rɨmnəsaah-pən ye swatuk, in rəmhen kɨn yermamə yame rɨmnərɨg nəgkiarien kape narmaruyen kape Kughen, mərɨg rɨpəh nɨrkunien. Kɨni Setan ravəhsi-ta aihuaa əmə nərɨgien yame rɨmavən yerkin. ");
INSERT INTO nwi_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kɨni kweru nai yame raməsaah-pən ye nɨmoptanə yame kapier ipakə ikɨn, in rəmhen kɨn yermamə yame rɨmnərɨg nəgkiarien kape Kughen, məkneikɨn ravəh yerkin agien, ");
INSERT INTO nwi_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","mərɨg nuan rɨpəh neiwaiyu-pɨkien. Kɨni ramərer əmə tuk nɨpɨg kwakwə əmə. Tukmə nɨpɨg əutən uə nahasien kɨrik ruə ye nɨmraghien kafan tuk nəgkiarien a, taktakun əmə rɨmɨr ye kafan nhatətəyen. ");
INSERT INTO nwi_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kɨni kweru nai yame rɨmnəsaah-pən yerki kwənurkəsɨk, in rəmhen kɨn yermamə yame rɨmnərɨg nəgkiarien kape Kughen, mərɨg kafan nətərɨgien ramvən pɨk tuk narɨmnar kape tokrei tanə, kɨni in rorkeikei mə kafan nautə tukrɨpsaah, kɨni nətərɨgien mɨnə a kaserko əsuun nəgkiarien kape Kughen. Kɨni nəgkiarien a rɨpəh nɨkuəyen kɨn kwənkwan. ");
INSERT INTO nwi_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mərɨg kweru nai yame rəsaah-pən ye nɨmoptanə huvə, in rəmhen kɨn yermamə yame rərɨg nəgkiarien kape Kughen, kɨni mɨrkun nɨpran. Kɨni ye nɨmraghien kafan, rɨkuə kɨn kwənkwan. Tɨksɨn khakuə kɨn kwənkwairiə wan handred, tɨksɨn sikisti, tɨksɨn toti.” ");
INSERT INTO nwi_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kɨni Yesu rɨmɨni-ərhav-pən mɨn nuhpɨkɨnien kɨrik kɨmi əriə mɨmə, “Narmaruyen kape Kughen, in rəmhen kɨn yermamə kɨrik yame rɨməvitəg-ətəg kweru nai ye kafan nəsimien. ");
INSERT INTO nwi_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Yenpɨg, kɨsapɨr iriə kafan narmamə mɨnə, məkneikɨn kafan kɨrik tɨkmɨr ruə mɨvitəg-ətəg mənvhirɨk has ye kafan nəsimien, map. ");
INSERT INTO nwi_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kɨni kweru nai huvə mɨnə kɨshaktə, mɨsehuə, mɨsor kwənkwairiə. Mərɨg ye nɨpɨg a, mənvhirɨk has rhaktə mɨn, mehuə. ");
INSERT INTO nwi_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Kɨni slef mɨnə kape kwən a khauə mɨsəm, mhani-pən tukun mhamə, ‘Yemehuə. ?Nɨmɨsuv kweru nai huvə in əmə in əmə, uə nɨkam? ?Mənvhirɨk has rɨsɨ-pkaa?’ ");
INSERT INTO nwi_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Kɨni yamehuə a rɨni-pən tuk əriə mɨmə, ‘Tɨkmɨr kɨrik kafak rɨmnor nar en.’ “Kɨni kafan slef mɨnə khani-pən tukun mhamə, ‘?Mərɨg nakmə jakhavən mɨsəkwai ta mənvhirɨk has a uə?’ ");
INSERT INTO nwi_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Rɨni-pən tuk əriə mɨmə, ‘Nɨkam. Hapəh. To nakasəkwai ta mənvhirɨk has mɨnə a, masor mɨsəkwai ta pɨkɨn kwənkwai nai huvə. ");
INSERT INTO nwi_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pəh iriu kwhaktə kwis əmə mɨravən mwəriaji kwənkwai nai huvə rɨmruə. Ye nɨpɨg a in a, jakni-pən tuk kafak narmamə yamə mɨne tukharhi kwənkwai nai mə tukhavən mɨsəkupan mɨsəkwai ta mənvhirɨk has, mhapɨk, mɨsarakikɨn-pən ye nap. Kwasɨg ikɨn, khapɨk kwənkwai nai huvə mɨnə mhauə ye nəkwai nimə kafak yame kamətu-pən nəvɨgɨnien ikɨn.’” ");
INSERT INTO nwi_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Kɨni Yesu rɨmɨni-pən mɨn nuhpɨkɨnien kɨrik tuk əriə mɨmə, “Narmaruyen kape Kughen in rəmhen kɨn kwənkwai mastad, yame yermamə rɨmɨvəh mɨvən mɨsuv ye kafan nəsimien. ");
INSERT INTO nwi_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kwənkwai mastad a in rarkəskəh pɨk, mərɨg nɨpɨg in tukrurə mehuə rəmhen kɨn nai ehuə kɨrik. Kɨni man mɨnə yamə mɨne kamhaivə yerpɨrɨg tukhauə mɨsor nimairiə ye kwerəgrəgɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kɨni Yesu rɨmɨni-pən mɨn nuhpɨkɨnien kɨrik tuk əriə mɨmə, “Narmaruyen kape Kughen in rəmhen kɨn yis yame piraovɨn kɨrik ramarap ye flaoa rɨpsaah yame ramor-pən ye besin ehuə, kɨni rher-əpu flaoa rəsiis, mehuə.” ");
INSERT INTO nwi_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Narɨmnar mɨnə fam, Yesu ramni əmə nuhpɨkɨnien iran kɨmi narmamə, to rɨpəh nɨni-atuatuk-əməyen. ");
INSERT INTO nwi_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nar a rɨtərhav-pə ror nəgkiarien kape profet kupan ruauə mɨnor nəfrakɨsien kɨn, yame rɨmɨni mɨmə, “Nɨpɨg tukmə yakaməgkiar, jakni əmə nuhpɨkɨnien. Jakamni-ərhav narɨmnar yame yɨmnerkwaig kɨn rɨrikakun ye nɨpɨg yɨmnor tokrei tanə meriaji-pə e taktəkun.” ");
INSERT INTO nwi_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kɨni Yesu rəta ye narmamə, mɨvən ye nəkwai nimə kɨrik. Kɨni kafan narmamə mɨnə khavən mɨsəm, mɨsaiyoh-pən mhamə, “Hoprai-pə ru nuhpɨkɨnien ye mənvhirɨk has yame raurə ye nəsimien.” ");
INSERT INTO nwi_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kɨni Yesu rɨmɨni-pən tuk əriə mɨmə, “Yo e, Ji Yermamə, Yo e yermamə yame yɨmnəvi-ətəg-ətəg kwənkwai nai ye nəsimien. ");
INSERT INTO nwi_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kɨni nəsimien in tokrei tanə. Kɨni kwənkwai nai huvə, iriə e ji Kughen yamə mɨne In ramarmaru irəriə. Kɨni mənvhirɨk has mɨnə, iriə e ji Setan. ");
INSERT INTO nwi_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kɨni tɨkmɨr yame rɨmavən mɨvitəg-ətəg mənvhirɨk has a in Setan. Kɨni nɨpɨg yame tukrhi kwənkwai nai, in e Nɨpɨg Kwasɨg. Kɨni narmamə yamə mɨne kamharhi kwənkwan, iriə e agelo mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tukhapɨk mənvhirɨk has mɨsəhi-pən ye nap. Norien a rəmhen kɨn Nɨpɨg Kwasɨg. ");
INSERT INTO nwi_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yo, Ji Yermamə, jakher-pre kɨn agelo mɨnə kafak tukhavən ikɨn yakamarmaru ikɨn, mɨsəkwai ta yor təvhagə has mɨnə fam, mɨne narɨmnar mɨnə fam mɨne yame kamhavi-pən narmamə tuk norien təvhagə has mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Iriə tuksarakikɨn-pən əriə ye nap ehuə. Kɨni aikɨn a, narmamə tuksasək mɨsəkwəruə. ");
INSERT INTO nwi_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kɨni narmamə yamə mɨne kɨsatuatuk tuksəsiə ye rao ye neai, rəmhen kɨn mɨrh. Tukmə kɨmiə narmamə yame nɨmətɨrgɨmiə rarə, sətərɨg huvə kɨn nəgkiarien e.” ");
INSERT INTO nwi_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kɨni Yesu rɨrpɨn nəgkiarien kafan mamni mɨmə, “Narmaruyen kape Kughen in rəmhen kɨn bokis mane kɨrik yame ramerkwaig ye nɨmoptanə. Kɨni yermamə kɨrik rɨmavən, məm, kɨni rarə mɨnɨm mɨn ye nɨmoptanə. Rɨkin rɨmnagien pɨk, kɨni rɨvən mor salem kɨn narɨmnar fam kafan, mɨvəh mane iran, mɨvən mɨvəh nɨmrɨ nɨmoptanə a kɨmnerkwaig kɨn bokis mane ikɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kɨni Yesu rɨrpɨn nəgkiarien kafan mamni mɨmə, “Narmaruyen kape Kughen in rəmhen kɨn sto kipa yame ramarhakɨn kapier huvə mɨnə e nɨmrɨn rhaktə, kamni kɨmə perel, mə tukrɨpɨk mɨvən mor salem kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tukmə rəm perel kɨrik yame rhuvə pɨk, kɨni marar mɨvən mor salem fam kɨn kafan narɨmnar, kɨni mɨvəh mane iran, mɨvən mɨvəh perel a kɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Kɨni Yesu rɨrpɨn nəgkiarien kafan mamni mɨmə, “Narmaruyen kape Kughen in rəmhen kɨn nɨpɨg narmamə kɨsarko-pən kɨn net apa ye lugun mamhavi kəmam pɨsɨn pɨsɨn iran. ");
INSERT INTO nwi_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nɨpɨg net rukwar kɨn kəmam, kɨni khavi-haktə net, kɨni masəwhai kəmam mɨnə mhavai-pən kəmam huvə mɨnə ye nɨtɨp ehuə mɨnə kapəriə, mɨsarakikɨn kəmam yamə mɨne kɨsahas. ");
INSERT INTO nwi_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kɨni ye norien kɨrikianə əmə mɨn, tuk Nɨpɨg Kwasɨg, agelo mɨnə tukhauə mhavəhsi-ta narmamə yamə mɨne kɨsahas tuk narmamə yamə mɨne kɨsatuatuk, ");
INSERT INTO nwi_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","mɨsarakikɨn-pən əriə ye nap ehuə- ikɨn narmamə kɨsasək mɨsəkwəruə ikɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Kɨni Yesu raiyoh-pən kafan narmamə mɨnə mə, “?Kɨmiə nakharkun narɨmnar mɨnə a uə nɨkam?” Kɨni iriə khamə, “Ǝwəh.” ");
INSERT INTO nwi_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kɨni rɨni-pən tuk əriə mɨmə, “Ror məkneikɨn, nəmhajoun mɨnə fam kape loa yamə mɨne kwənhauə ye narmaruyen kape Kughen, kɨmɨsofugɨn-pən nəgkiarien wi kafak mɨne nəgkiarien akwas kape Moses rəmhen kɨn yame yemehuə kape nimə kɨrik ramofugɨn-pən narɨmnar huvə yamə mɨne khawi mɨne narɨmnar huvə yamə mɨne ramswin hanə ye nimə kafan.” ");
INSERT INTO nwi_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kɨni Yesu rɨmɨni ta nuhpɨkɨnien mɨnə a, marar, mɨtərhav. ");
INSERT INTO nwi_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Muə iman ikɨn, mɨrikakun maməvhag kɨmi narmamə ye nəkwai nimə kape nofugɨnien. Kɨsərɨg nəgkiarien kafan, kɨsakur, mɨsaiyoh əriə mɨnə mhamə, “!Man! ?In ravəh hiə nɨrkunien e? ?Rhawor mor nɨmtətien mɨnə e? ");
INSERT INTO nwi_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kɨtawə kwənharkun ta kwən e. In kwajikovə əmə kape yermamə yame ravhirəkɨn nai. Nɨsɨni e Meri; kɨni naorahini mɨnə e Jemes, mɨne Josef, mɨne Judas, mɨne Saemon. ");
INSERT INTO nwi_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kɨni nowini mɨnə kasarə mɨn e kɨtawə miriə. ?Ravəh hiə nɨrkunien e?” ");
INSERT INTO nwi_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kɨni iriə kɨnasəməkɨn In. Mərɨg Yesu rɨni-pən tuk əriə mə, “Tukmə profet kɨrik kape Kughen, narmamə tukhasiai In. Kɨni mərɨg, narmamə iman ikɨn, mɨne kwənərəus kafan mɨnə, iriə pɨsɨn əmə to khapəh nhasiaiyen In.” ");
INSERT INTO nwi_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","In a ye kwənmhaan a, rɨpəh nor-pɨkien nɨmtətien, meinai kapəriə nhatətəyen rɨkək iran. ");
INSERT INTO nwi_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ye nɨpɨg a, King Herod Antipas yame rɨmnamarmaru ye tanə Galili rɨmnərɨg nəvsaoyen kɨn Yesu. ");
INSERT INTO nwi_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kɨni mɨni-pən tuk kafan yorwok mɨnə mə, “!Eh! !Kwən e in Jon Baptaes, ruɨmragh mɨn ye nɨmhəyen! Ror pən ravəh nəsanɨnien tuk norien nɨmtətien mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herod rɨkin raməsɨk məknakɨn meinai nɨpɨg kɨrik, in rɨmɨkɨr ta piraovɨn kape Filip e piauni. Pian a, nhagɨn e Herodias. Kɨni Jon rɨmɨni-əhu mɨmə, “Kɨmɨni-əhu mə takpəh nɨkɨr-tayen piraovɨn e.” Jon ramni-əhu Herodias, Herodias raməməkɨn in tukun. Kɨni Herod rɨmɨvəhsi-pən Jon ye kalabus. ");
INSERT INTO nwi_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kɨni Herod rɨmə tukrhopni Jon tukun, mərɨg ruagɨn kɨn narmamə, meinai rɨkiriə rɨmnəsɨk mə Jon in profet kɨrik. ");
INSERT INTO nwi_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mərɨg nɨpɨg kɨrik, Herod rɨmnor nəvɨgɨnien ehuə kɨrik mamor nɨpɨg kafan yame rɨmnarha iran. Kɨni piakəskəh e ji Herodias rɨmnor danis ye nɨmrɨ narmamə. Rɨmnor danis, Herod rəm rorkeikei, ");
INSERT INTO nwi_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","mɨni-pən tuk piakəskəh a mə, “Yakamni kwəsu əgkəp mə nar yame ik nakorkeikei mamaiyoh yo kɨn, yakɨrkun nɨvəhsi-preyen.” ");
INSERT INTO nwi_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Mərɨg Herodias rɨmnaməkeikei kɨmi piakəskəh ai mə tukrɨni-pən tuk Herod mɨmə, “Yakorkeikei mə taktəkun əmə takrəh kapən kapə Jon Baptaes, mukrai-pən ye tikiplet, mɨrəh muə kɨmi yo pəh yakəm.” ");
INSERT INTO nwi_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nəgkiarien ai ror King Herod rərɨg rahas pɨk, meinai rɨmnor nəgkiarien əutən ye nɨmrɨ in mɨnə tɨksɨn. To rɨpəh nəpəhyen. Kɨni rɨmə tuksor nəkwai piakəskəh ai. ");
INSERT INTO nwi_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Mher-pən kɨn narmamə tɨksɨn khavən ye kalabus mɨsərəru-ta kapən kapə Jon, ");
INSERT INTO nwi_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","mhaukrai-pən ye tikiplet, mhavəh mhavən mhavəhsi-pən kɨmi ji Herodias. Kɨni in rɨvəh-si-pən kɨmi nɨsɨni. ");
INSERT INTO nwi_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kɨni narmamə kape Jon kɨmnhavən mharəh nɨpran, mhavən mhanɨm. Mɨsarar mhavən mɨsəvsao kɨn kɨmi Yesu. ");
INSERT INTO nwi_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nɨpɨg Yesu rɨmnərɨg nəvsaoyen a, kɨni rat-pən ye bot kɨrik mɨvən apa ikɨn ruhiko ikɨn. Mərɨg nukwhao kɨmnharkun aikɨn ramvən ikɨn, mhatərhav ye kapəriə rukwanu mɨnə mɨsəriwək mhakurao mamhavən mɨsəm. ");
INSERT INTO nwi_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kɨni Yesu rɨmɨvhiak məm narmamə khapsaah aikɨn, kɨni rɨkin reiwaiyu tuk əriə. Kɨni rɨmavən mor huvə narmamə yamə mɨnə kamhamhə. ");
INSERT INTO nwi_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Rɨnamenaiyu, narmamə kape Yesu khauə mɨsəm In, mhamə, “Kwənmhan əkwak ikɨn e, kɨni rɨnamenaiyu. Takher rik rik kɨn narmamə mɨnə e, pəh kamhavən apa yerkwanu ipakə mɨnə mhavəh nəriə kɨrik nəvɨgɨnien.” ");
INSERT INTO nwi_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Mərɨg Yesu rɨni-pən tuk əriə mɨmə, “Rhuvə mə tukhapəh nɨsaiyu-rik-rik-ien. Kɨmiə taksəvɨgɨn əriə.” ");
INSERT INTO nwi_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Mərɨg iriə khani-pən tukun mhamə, “?Jakshawor? Nɨpar bred kɨrkɨrɨp əmə mɨne kəmam kɨraru.” ");
INSERT INTO nwi_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kɨni Yesu rɨni-pən tuk əriə mə, “Havəh mhauə.” ");
INSERT INTO nwi_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kɨni mɨni-pən tuk narmamə mə tuksəkwətə huvə yerki mənvhirɨk. Kɨni mɨvəh bred ai kɨrkɨrɨp mɨne kəmam kɨraru, mɨvaag haktə mɨni vi vi Kughen tukun, mhapu bred, mɨpɨk-pən kɨmi kafan narmamə mɨmə, “Takhapɨk mɨsəvɨgɨn narmamə mɨnə a kɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kɨni iriə kɨmɨsəvɨgɨn tupriə rəsiis mɨsəpəh nɨpərpər bred mɨne kəmam. Kɨni kafan narmamə mɨnə kɨmnhavai-pən ye nɨtɨp twelef khakuar mɨn. ");
INSERT INTO nwi_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Narmamə ai kɨmɨsəvɨgɨn, kɨmɨvəh əmə nɨhupɨn ye narman, iriə fam rəmhen kɨn faef taosen. Mərɨg kɨpəh nəvhuekɨnien nɨpiraovɨn mɨne kwajikovə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Məkneikɨn, Yesu rɨmɨni-pən tuk kafan narmamə mə tukhavən ye bot mɨsəkupan mhavən ye nɨkar nu, mərɨg In raməmɨr əmə mə tukrher-pən kɨn narmamə kamhavən iməriə ikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Rher-pən ta kɨn narmamə ai, kɨni marar mhaktə fiak mɨvən ye tukwas kɨrik In pɨsɨn əmə, mə tukrəhuak. Rɨnamenaiyu, Yesu pɨsɨn əmə aikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Mərɨg bot ravirə ta ye nu, mɨrəhpɨkɨn nɨmətag. Peao-peao ramuh bot. ");
INSERT INTO nwi_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kɨni ye kwəsum-nɨraanien, Yesu rarar məriwək ye nɨmar-mar nu mamuə tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kɨni narmamə kafan mɨnə kɨmɨsəm rəriwək mamuə ye nɨmar-mar nu, kamhagɨn pɨk. Mɨsokrapomh mhamə, “!Eh! !Yarhmə kɨrik apa!” ");
INSERT INTO nwi_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Məkneikɨn, Yesu rɨni-pən tuk əriə mə, “Takhapəh nhagɨnien. Mə Yo əmə e.” ");
INSERT INTO nwi_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kɨni Pita rɨmə, “Yermaru. Tukmə Ik əfrah, okrən mɨn kɨn yo pəh yakəriwək mɨn ye nɨmar-mar nu murə.” ");
INSERT INTO nwi_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Kɨni Yesu rɨmɨni-pən tukun mɨmə, “Yuə.” Kɨni Pita rəvi-ərhav ye nəkwai bot, məriwək ye nɨmar-mar nu mɨvən tuk Yesu. ");
INSERT INTO nwi_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Məm peao-peao, kɨni rɨgɨn pɨk, kɨni mɨnaməmnɨm. Masək-pən tuk Yesu mɨmə, “!Yermaru, vəh mɨragh yo!” ");
INSERT INTO nwi_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Məkneikɨn, Yesu rərao-pən mɨrəh, mɨni-pən tukun mɨmə, “Kafam nhatətəyen rəkəskəh pɨk. ?Rhawor e nakpəh nɨniyen nəfrakɨsien irak?” ");
INSERT INTO nwi_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kɨni kwat-pən mɨn ye bot, məknekɨn nɨmətag reiwaiyu. ");
INSERT INTO nwi_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kɨni narmamə mɨnə a ye nəkwai bot kasəgnəgɨn In mhamə, “!Nəfrah! Ik Ji Kughen.” ");
INSERT INTO nwi_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kɨni kɨmnhavən ye nɨkar lugun pən, mhavhiak ye tanə Genesaret. ");
INSERT INTO nwi_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kɨni narmamə aikɨn khauə mɨsəm Yesu, mɨnharkun In, mɨsher-pən nəgkiarien kɨmi narmamə rarukrao ye rukwanu mɨnə fam aikɨn a. Kɨni khapɨk mɨn kapəriə narmamə yamə mɨne kamhamhə mhavən tuk Yesu, ");
INSERT INTO nwi_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","mɨsəkeikei kɨmin mhamə iriə yamə mɨnə kamhamhə, tukharap əmə nəpag nɨmrɨ neipən kafan, kɨni iriə fam yamə mɨne kɨmnharap In mɨsəsanɨn. ");
INSERT INTO nwi_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nəmhajoun tɨksɨn kape loa kape Moses iriə Farisi mɨnə khasɨ-pən apa Jerusalem mhauə mɨsəm Yesu mɨsaiyoh In mhamə, ");
INSERT INTO nwi_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“?Rhawor kafam narmamə khapəh nɨsəri-pənien kapətawə natuakəmien yame kaha mɨnə kɨmnəsəvhag kɨn kɨmi ətawə? Kafam narmamə mɨnə kasəvɨgɨn mhapəh nɨsəravyen rəri-pən natuakəmien kapətawə.” ");
INSERT INTO nwi_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mərɨg Yesu rɨni-pən tuk əriə mɨmə, “!Mərɨg kɨmiə nakwəsəpəh loa kape Kughen mɨnamhakwasɨg əmə kɨn narəyen kape kaha mɨnə! ");
INSERT INTO nwi_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ǝmru, Kughen rɨmɨni kupən mɨmə, ‘Takhasiai nɨsɨnmiə mɨne rɨmɨmiə.’ Kɨni mɨmə, ‘Yermamə yame ramni hah nɨsɨni uə rɨmni tukhopni.’ ");
INSERT INTO nwi_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mərɨg kɨmiə nakhani-əhu narmamə mə tukhapəh nɨsasituyen ye nɨsɨnriə mɨne rɨmriə, mhamə tukhani-pən tuk əriə mhamə, ‘Eh. Yakeinein nɨvəhsi-preyen nar kɨrik meinai yakvəhsi-pən ta fam kɨmi Kughen, kɨni yo to yakpəh nɨvəhsi-ta-mɨnien mɨvəhsi-pre kɨmik.’ ");
INSERT INTO nwi_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nakasəvhag kɨmi narmamə məknekɨn mamhani əswasɨg kɨn nasituyen yame narmamə tuksor kɨmi nɨsɨnriə mɨnə mɨne rɨmriə mɨnə. Ror pən narəyen kapəmiə yame nakasəvhag kɨn kɨmi narmamə ramor təkun nəgkiarien kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nɨniyen kapəmiə rhuvə mərɨg norien kapəmiə rahas. In apa kupən, profet e Aesea, rɨmnəfrakɨs ye nɨkarɨn kapəmiə mɨrai mamni mə, ");
INSERT INTO nwi_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Nəmə mɨnə, kamhani apnapɨg əmə nəfrakɨsien irak ye nheriə, mərɨg rɨkiriə raməmɨr isok pɨk tuk Yo. ");
INSERT INTO nwi_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kasəhuak mərɨg kasəhuak təkun əmə. Kɨni ye kapəriə nəvhagien kamhani mhamə nəgkiarien e kape Kughen, mərɨg rəmhen əmə kɨn nərɨgien kape yermamə.’” ");
INSERT INTO nwi_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kɨni Yesu rɨmnokrən kɨn narmamə mə tukhauə mɨsəm. Mɨni-pən tuk əriə mə, “Sətərɨg-ru, mharkun nar e. ");
INSERT INTO nwi_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nar raməmɨr iruə, tukmə rɨvən yerki yermamə, to rɨpəh norien rəmkɨmɨk ye nɨmrɨ Kughen. Nar ramtərhav ye nəkwai yermamə ramor nəmkɨmɨk ye nɨmrɨ Kughen.” ");
INSERT INTO nwi_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kɨni kafan narmamə mɨnə khauə mɨsəm mɨsaiyoh-pən mhamə, “?Mərɨg nakɨrkun mə Farisi mɨnə kɨmɨsərɨg nəgkiarien e kafam, rɨkiriə raha?” ");
INSERT INTO nwi_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Kɨni rɨni-pən tuk əriə mə, “Nai mɨnə fam yame Rɨmɨk apa ye neai rɨmɨpəh nɨhuyen, In tukrɨvi-haktə piəpiə iriə nuan mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Səpəh əriə. Iriə kamhakɨr narmamə, mərɨg nɨmrɨriə rɨpɨs. Tukmə nɨmrɨn pɨs rɨkɨr nɨmrɨn pɨs, kɨni iriu tukawəkeikei mɨrəivə ye nəkwai nɨmɨr.” ");
INSERT INTO nwi_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kɨni Pita rɨni-pən tukun mɨmə, “?Hoprai-pə ru nɨprai nuhpɨkɨnien en kɨmi əmawə?” ");
INSERT INTO nwi_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “?Rhawor? ?Kɨmiə mɨn nakseinein? ");
INSERT INTO nwi_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","?Nakharkun mə narɨmnar yame kamən ramvən ye tɨp jir mamtərhav mɨn? ");
INSERT INTO nwi_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mərɨg narɨmnar yame ramsɨ-pən yerki yermamə kɨni mamtərhav ye tɨkinherɨn, ramor yermamə raməmkɨmɨk ye nɨmrɨ Kughen. ");
INSERT INTO nwi_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Meinai in ai yerki yermamə, nərɨgien hah rɨpsaah, rəmhen kɨn nhopniyen yermamə, nəkrəhyen kɨn piraovɨn, nor-apnapɨgien nar, nəkrəhyen, neikuəyen, mɨne nɨniyen nɨkar jir. ");
INSERT INTO nwi_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Norien has mɨnə a kamhasɨ-pən yerki yermamə masor in raməmkɨmɨk ye nɨmrɨ Kughen. Mərɨg tukmə yermamə kɨrik rɨpəh nəravyen, pa rɨmə rəmkɨmɨk ye nɨmrɨ Kughen.” ");
INSERT INTO nwi_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kɨni Yesu rɨtərhav aikɨn a mɨvən ye taon kɨraru e Taea mɨne Saedon. ");
INSERT INTO nwi_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kɨni pian kɨrik yame pəh nien mə kwənərəus kape Isrel ramarə ye kwənmhan a rɨmauə məm, mamasək apomh mɨmə, “Yermaru. Mɨkɨp King Deved. !Rɨkim tukreihuə tuk yo! Nanmɨn has kɨrik ramərer-pən ye piakəskəh kafak, mamoriah pɨk in.” ");
INSERT INTO nwi_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mərɨg Yesu rɨpəh nɨniyen nar kɨrik tukun. Kɨni kafan narmamə khauə masəkeikei kɨmin mhamə, “Her-pən kɨn pəh ramvən, meinai in ramasək apomh mamkwasɨg kɨn ətawə.” ");
INSERT INTO nwi_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Mərɨg Yesu rɨni-pən tuk əriə mɨmə, “Kughen rɨmnher-pə kɨn Yo mə jakvən əmə tuk sipsip mɨnə kape kwənərəus kape Isrel yamə mɨne kaserwei.” ");
INSERT INTO nwi_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mərɨg pian a ruə mənɨmkur ye nɨmrɨ Yesu mamni mɨmə, “Yermaru, asitu irak.” ");
INSERT INTO nwi_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Mərɨg Yesu rɨni-pən tukun mə, “Rapəh natuatukien mə tɨkvəh nəvɨgɨnien ne kwajikovə mɨnə karakikɨn-pən kɨmi kuri mɨnə kapəriə.” ");
INSERT INTO nwi_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mərɨg piraovɨn ai rɨni-pən tukun mə, “Yemasur, nəfrakɨs. Mərɨg kuri mɨnə kharkun nɨsənien nɨmsɨmsɨ nəvɨgɨnien ne kwajikovə mɨnə yame raməsaah-pən ye nəpəəg tebol kape yamehuə kapəriə.” ");
INSERT INTO nwi_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kɨni Yesu rhorpɨn nəgkiarien kafan mɨmə, “Piraovɨn. Kafam nhatətəyen rehuə. Naha nhagɨn yame nakorkeikei, tukruə mor nəfrakɨsien kɨn.” Kɨni taktakun əmə, piakəskəh kafan rɨmnəsanɨn mɨn. ");
INSERT INTO nwi_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kɨni Yesu rɨtərhav aikɨn a maməriwək ye nɨkar-kar lugun Galili. Mhaktə fiak mɨvən ye tukwas kɨrik mamkwətə. ");
INSERT INTO nwi_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kɨni nukwhao ehuə khauə mɨsəm. Mhapɨk narmamə yamə mɨne nɨhuriə rarpəvɨn mɨne nɨmrɨn pɨs mɨnə, mɨne yamə mɨne nɨprairiə rɨmhə, mɨne yamə mɨne kaseinein nəgkiarien, mɨne yamə mɨne kɨmnhavəh nəmhəyen pɨsɨn pɨsɨn. Mɨsətu-pən əriə ipakə tuk Yesu, kɨni In ror huvə əriə. ");
INSERT INTO nwi_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kɨni narmamə mɨnə a kɨmɨsəm mə narmamə yame kaseinein nəgkiarien kɨmɨsəgkiar, mɨne yamə mɨne nɨprairiə rɨmhə kɨmɨsəsanɨn, mɨne yamə mɨne nɨhuriə rahas kɨmɨsəriwək, mɨne nɨmrɨn pɨs mɨnə kɨmɨsəm nar, kɨni kɨsakur pɨk kɨn, mhani vi vi Kughen kape Isrel. ");
INSERT INTO nwi_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ye nɨpɨg a, Yesu rɨmnokrən kɨn kafan narmamə mɨnə mɨmə, “Rɨkik reiwaiyu pɨk tuk narmamə mɨnə e. Kɨtawə miriə kɨmɨsəmɨr nɨpɨg kɨsisər, kɨni nəriə nəvɨgɨnien rɨrkək. To yakher-pən kɨn əriə yerkwanu, kamhavən kɨrik rəmkərəv ye swatuk, nɨmrɨn rapɨg, kɨni rɨmɨr.” ");
INSERT INTO nwi_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kɨni narmamə kafan mɨnə khani-pən tukun mhamə, “?Tukhavəh hiə nəvɨgɨnien rəmhen tuk nukwhao ehuə e? Ikɨn eikɨn e kwənmhan əkwak.” ");
INSERT INTO nwi_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Kɨni Yesu raiyoh əriə mə, “?Mərɨg bred kuvhuun en?” Khamə, “Bred seven. Mɨne kwaji kəmam tɨksɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kɨni Yesu rɨni-pən tuk narmamə ai mə, “Taksəkwətə.” ");
INSERT INTO nwi_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kɨni mɨvəh nɨpar bred ai mɨne kəmam, mɨni vi vi Kughen tukun, kɨni makapɨr-pɨr, məhi-pən kɨmi kafan narmamə mɨnə mə tuksəvɨgɨn narmamə ai kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kɨni kɨsəvɨgɨn, tupriə rəsiis fam. Kɨni narmamə kafan mɨnə khavən mhapɨk nɨpərpər nəvɨgɨnien, mhavai-pən ye kəmeiru ehuə seven. ");
INSERT INTO nwi_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Narmamə mɨnə ai kɨmɨsəvɨgɨn, kɨmɨvəh əmə nɨhupɨn ye narman, iriə fam rəmhen kɨn fo taosen. Mərɨg kɨpəh nɨsəvhuekɨnien nɨpiraovɨn mɨne kwajikovə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kɨni Yesu rher rik rik kɨn əriə. Mat-pən ye bot, mɨvən apa kwənmhan ehuə kɨrik, nhagɨn e Magadan. ");
INSERT INTO nwi_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kɨni ai, Farisi tɨksɨn mɨne Sadusi tɨksɨn khauə masəni-əhu Yesu mə to rɨpəh norien nɨmtətien kɨrik ye nɨmrɨriə yame ramhajoun mə nəsanɨnien kafan ramsɨ-pən ye neai. ");
INSERT INTO nwi_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kɨni Yesu rɨni-pən tuk əriə mə, “Nɨpɨg mɨrh natukrivə, nakhamə, ‘Tikianakwamer rukweiha tukravən meinai napuə raməwhao.’ ");
INSERT INTO nwi_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kɨni yenpɨgyenpɨg iran, nakhamə, ‘Nəhig tukrɨp, meinai napuə rəwhao markurao.’ Nakharkun nɨniyen nɨprai nɨmtətien ye nɨmar napuə, mərɨg nakseinein nɨniyen nɨprai nɨmtətien yame yakamor ai taktakun. ");
INSERT INTO nwi_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kɨmiə e taktakun mɨne, naksahas. Kɨmiə nəmə Isrel nɨmɨsəpəh kapəmiə nhatətəyen ye Kughen rəmhen kɨn piraovɨn kɨrik yame rapəh kafan yerman məri-pən kwən pɨsɨn. Kɨni taktakun naksorkeikei mə jakor nɨmtətien kɨrik yame tukrhajoun mə yɨmasɨ-pən ye Kughen. Mərɨg Kughen tukror nɨmtətien kɨrikianə əmə, in e nɨmtətien kape Jona kupan.” Yesu rɨmnəgkiar fam ai məpəh əriə. ");
INSERT INTO nwi_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kɨni ai Yesu mɨne kafan narmamə mɨnə khavən ye bot, mɨsəviəfugɨn ye nu apa Galili. Mɨsəru-kɨn nɨpər bred nəriə. ");
INSERT INTO nwi_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kɨni Yesu rɨmnor kwirɨg kɨmi əriə mɨmə, “Takasərɨg əmiə tuk ‘yis’ kape Farisi mɨnə, mɨne Sadusi mɨnə.’ ");
INSERT INTO nwi_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kɨni kɨnəsaiyoh əriə mɨnə kɨn nɨpran, mhamə, “?Tukmə ror kwən e rɨmə kɨtawə kɨmnhapəh nhavəhyen bred uə?” ");
INSERT INTO nwi_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Mərɨg Yesu ruɨrkun ta nərɨgien kapəriə. Mɨni-pən tuk əriə mə, “Kapəmiə nhatətəyen rɨkəskəh. ?Nakshawor e masəm əmiə mɨnə mə bred rɨkək? ");
INSERT INTO nwi_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","?Rhawor e rɨkimiə rɨpəh nəsɨkien kɨni nakhapəh nharkun-huvəyen mə nɨpɨg yɨmɨvəh nɨpar bred kɨrkɨrɨp, məhi-pən kɨmi narman faef taosen kɨsən, kɨni kɨmɨsəpəh nɨpərpər nəvɨgɨnien, ?nakhavai-pən ye nɨtɨp kuvhuun? ");
INSERT INTO nwi_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kɨni nɨpɨg yɨmɨvəh nɨpər bred seven, məhi-pən kɨmi narman fo taosen, kɨni mhapəh nɨpərpərɨn, ?nakhavai-pən ye kəmeiru kuvhuun? ");
INSERT INTO nwi_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","?Rhawor kɨmiə nakhapəh nharkunien mə yakpəh nəgkiarien kɨn bred? Takasərɨg əmiə tuk ‘yis’ kape Farisi mɨnə mɨne Sadusi mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kɨni ye nɨpɨg a, iriə kɨmnharkun mə pəh nien mə raməgkiar kɨn yis yame kamor bred kɨn, mə tukasərɨg əriə tukun. Mərɨg tukasərɨg əriə tuk nhajounien kape Farisi mɨnə mɨne Sadusi mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kɨni ai Yesu mɨne kafan narmamə khavhiak mhatərhav-pən ye kwənmhan e kamni kɨmə Sisaria Filipae. Kɨni Yesu raiyoh əriə mə, “?Mərɨg narmamə kamhani mə Yo, Ji Yermamə, Yo e pa?” ");
INSERT INTO nwi_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kɨni khani-pən tukun mhamə, “Tɨksɨn khamə Ik e Jon Baptaes; tɨksɨn khamə Ik e Elaeja tu; kɨni tɨksɨn khamə Ik e Jeremaea uə profet kupən pɨsɨn kɨrik kape Kughen.” ");
INSERT INTO nwi_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mərɨg In raiyoh əriə mə, “?Mərɨg rhawor irəmiə? ?Nakhamə Yo e pa?” ");
INSERT INTO nwi_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Mərɨg əmə Saemon Pita rɨmə, “Ik e Kristo, ji Kughen yame Ramragh.” ");
INSERT INTO nwi_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kɨni Yesu rɨmɨni-pən tukun mə, “Saemon Jona, Kughen rɨmnautə-pre kɨn nɨhuvəyen kafan kɨmik, meinai pəh nien mə yermamə kɨrik rɨmnor əpu nar e kɨmik; mərɨg Rɨmɨk apa ye rao ye neai, In rɨmnor əpu nar e kɨmik. ");
INSERT INTO nwi_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kɨni yakamni-pre tuk ik mə ik Pita, nɨpran ramni mə kapier yame jakvhirəkɨn-pən niməhuak kafak iran. Kɨni to nəsanɨnien kape nɨmhəyen rɨpəh napitayen kafak narmamə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Jakvəhsi-pre ki kɨmik kape narmaruyen kape Kughen. Tukmə nakəhitə ye naha tapɨg ye tokrei tanə, tukrəhitə ye rao ye neai. Tukmə nakətapɨg ye naha tapɨg ye tokrei tanə, tukrətapɨg ye rao ye neai.” ");
INSERT INTO nwi_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kɨni mɨni-əutən-pən tuk kafan narmamə mɨnə mə tukhapəh nhani-pənien tuk yermamə kɨrik mə In Kristo yame Kughen rɨmɨni mə tukrher-pə kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Rɨrikakun ye nɨpɨg a, Yesu rɨmɨni-pən tuk kafan narmamə mɨnə mə tukraməkeikei mɨvən Jerusalem, kɨni nəwharu mɨnə Isrel, mɨne jif pris mɨnə, mɨne namhajoun kape loa kape Moses, tuksor nəmhəyen kɨmin, mhani mə tukraməkeikei mɨmhə. Mərɨg ye nɨpɨg yame ror kɨsisər kɨn, tukramragh mɨn ye nɨmhəyen kafan. ");
INSERT INTO nwi_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Məknekɨn Pita rɨkɨr In, mwapta irəriə, kɨni mamni-əhu In mɨmə, “!Nɨkam, Yermaru! Tukrɨpəh norien rəmhen kɨn yame nakamni.” ");
INSERT INTO nwi_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Mərɨg Yesu rarar, mɨni-pən skai tuk Pita mɨmə, “!Setan! !Ap ikɨn e! Ik nakamərer əswasɨg kɨn Yo. Nərɨgien kafam rɨpəh nəmhenien kɨn nərɨgien kape Kughen. Nərɨgien əmə kape yermamə.” ");
INSERT INTO nwi_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kɨni Yesu rɨmɨni-pən tuk kafan narmamə mɨnə mə, “Tukmə yermamə rɨmə tukrɨkwasɨg kɨn Yo, tukraməkeikei məta ye nərɨgien kafan, kɨni tukmə rərɨg pawk nəmhəyen rəmhen kɨn nəmhəyen ye nɨmhəyen ye nai kamarkwao kɨn, mərɨg tukrɨkwasɨg kɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Meinai yermamə yame ramgɨn tuk kafan nɨmraghien, tukraməkeikei mɨmhə. Mərɨg yermamə yame tukhopni tuk nɨkwasɨgien kɨn Yo, tukrarə ye nɨmraghien rerɨn. ");
INSERT INTO nwi_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tukmə yermamə kɨrik kafan nautə rehuə pɨk ye tokrei tanə e, mamarakikɨn kafan nɨmraghien tukun, nanmɨn tukrerwei. Mərɨg nar kɨrik rɨrkək mɨn tuk nɨvəhyen nɨmrɨ nɨmraghien kafan. ");
INSERT INTO nwi_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ror məknakɨn meinai Yo Ji Yermamə jakpiuə kɨmawə agelo mɨnə ye nəsanɨnien ehuə mɨne nɨkhakien kape Rɨmɨk, kɨni jakpivəhsi-pən nərokien kɨmi narmamə mfam tuk wok yame kɨmɨsor. ");
INSERT INTO nwi_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yakamni əfrakɨs tuk əmiə mə narmamə tɨksɨn kasarə ikɨn e to khapəh nhamhəyen mɨseriaji nɨpɨg narmamə tuksəm Yo Ji Yermamə yakavəh nehuəyen tuk narmaruyen ye narmamə.” ");
INSERT INTO nwi_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nɨpɨg sikis ruauə muavɨn, Yesu rɨkɨr Pita, Jemes mɨne piauni Jon mɨshaktə fiak ye tukwas apomh kɨrik. Irisɨr pɨsɨn əmə kɨmɨrhkwasɨg kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Aikɨn, nɨprai Yesu rukrekɨn muə mor pɨsɨn. Nɨmrɨn rakhak rəmhen kɨn nɨkhakien kape mɨrh. Kɨni neipən kafan rhawən pɨk. ");
INSERT INTO nwi_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kɨni yemasur kupən mir kɨraru, Elaeja mɨne Moses, kratərhav-pə mɨn, marhəgkiar irisɨr Yesu. ");
INSERT INTO nwi_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kɨni Pita rɨni-pən tuk Yesu mə, “Yermaru, rhuvə mə kɨmasɨr jakəhrarə əmə eikɨn e. Pəh yakrharkwopək nimə kɨsisər. Kafam kɨrik, kape Moses kɨrik, kɨni kape Elaeja kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita raməgkiar hanə, məknekɨn napuə hawən kɨrik reiwaiyu, muvrɨg əpɨs əriə. Kɨni nəgkiarien kɨrik rɨsɨ-pən ye napuə mɨmə, “In e Narɨk keikei yakorkeikei pɨk. Rɨkik ragien pɨk tukun.” ");
INSERT INTO nwi_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kɨmɨrhərɨg nəgkiarien a, kɨrhɨgɨn pɨk, mɨrhənɨm-pən nɨmrɨrisɨr ye nɨmoptanə. ");
INSERT INTO nwi_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mərɨg Yesu ruə mɨrap ərisɨr mɨmə, “Rhekɨmter. Mɨrhɨpəh nɨrhɨgɨnien.” ");
INSERT INTO nwi_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Məknekɨn, krharharha, mrhɨpəh mɨn nɨrhəmien əriu. Yesu pɨsɨn əmə ramərer. ");
INSERT INTO nwi_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kɨni khasɨ-faktə ye tukwas, Yesu rɨmɨni-əhu əutən pən tuk ərisɨr mɨmə, “Takrhɨpəh nɨrhəvsaoyen kɨn mɨrheriaji Yo, Ji Yermamə, jakɨmragh mɨn ye nɨmhəyen kafak.” ");
INSERT INTO nwi_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kɨni krhaiyoh mɨrhɨmə, “?Mərɨg rhawor e nəmhajoun kape loa mɨnə kamhani mhamə Elaeja tukraməkeikei məkupan ye Kristo muə?” ");
INSERT INTO nwi_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Kɨni Yesu rɨmə, “Nəfrakɨsien mə Elaeja tukraməkeikei məkupan muə mə tukrətu huvə narɨmnar fam. ");
INSERT INTO nwi_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mərɨg yakamni-pre tuk əmisɨr mə Elaeja ruərerɨg ta, mərɨg narmamə khapəh nharkunien in; mɨsor ahas pən kɨmin. Ye norien kɨrikianə mɨn, tuksor Yo, Ji Yermamə, jakərɨg nəmhəyen.” ");
INSERT INTO nwi_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ramni məknakɨn, kafan narmamə mɨnə kharkun mə In raməgkiar ye Jon Baptaes. ");
INSERT INTO nwi_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kɨni khatərhav-pə tuk nukwhao ehuə. Kɨni yermamə kɨrik ruə mənɨmkur-pən tuk Yesu mɨmə, ");
INSERT INTO nwi_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Yermaru. Pəh rɨkim tukrehuə tuk pɨkwarien kafak. Nɨkəvaan ramor pɨk in. Ramarə ye nɨpɨg əutən. Nɨpɨg rɨpsaah ramɨmɨr-pən ye nap mɨne ye nu. ");
INSERT INTO nwi_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kɨni yo yɨmɨrəh mɨvən kɨmi kafam narmamə mɨnə, mərɨg kɨseinein nor-huvəyen.” ");
INSERT INTO nwi_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “!Kəsi! Kɨmiə e taktakun mɨne, nhatətəyen kapəmiə rɨrkək. Kɨni kapəmiə nətərɨgien rapəh natuatukien. ?Kɨtawəm kɨmiə tuksarə mɨseriaji naha nɨpɨg takpishatətə irak?” Kɨni mamni mɨn mɨmə, “Harəh pɨkwarien en mhauə.” ");
INSERT INTO nwi_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kɨni Yesu rɨmnəgkiar skai kɨmi nanmɨn has maməko-ta. Məkneikɨn mor huvə pɨkwarien a. ");
INSERT INTO nwi_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kɨni ai kafan narmamə khauə iriə pɨsɨn əmə mɨsəm Yesu mɨsaiyoh-pən mhamə, “?Rhawor e kɨmawə yakwəseinein nəkotayen nanmɨn has a?” ");
INSERT INTO nwi_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Kɨni Yesu rɨni-pən tuk əriə mə, “Meinai nhatətəyen kapəmiə rɨkəskəh əmə. Kɨni nanmɨn has yamə mɨne kɨsor məknekɨn, to nakpəh nəvɨgɨnien məhuak mɨrkun nəkotayen əriə. Mərɨg yakamni-pre əfrakɨs tuk əmiə mə to nhatətəyen kapəmiə rɨkəskəh pawk rəmhen kɨn kwənkwai mastad, mərɨg takharkun nhani-pənien tuk tukwas e mhamə, ‘Ǝta ikɨn e mɨvən aikɨn a,’ kɨni tukror nəkwaimiə. Kɨni takharkun nɨsorien narɨmnar fam.” ");
INSERT INTO nwi_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kɨni kɨmnhauə kɨrikianə apa Galili, kɨni Yesu rɨni-pən tuk əriə mə, “Kwən kɨrik tukreighaan-pən kɨn Yo, Ji Yermamə, ye kwermɨ tɨkmɨr mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Narmamə tukshopni Yo, kɨni ye nɨpɨg yame ror kɨsisər kɨn, Kughen tukrɨvəh mɨragh Yo ye nɨmhəyen.” Kɨni kafan narmamə mɨnə rɨkiriə rəpou pɨk tuk nəgkiarien a. ");
INSERT INTO nwi_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kɨni ai Yesu mɨne kafan narmamə mɨnə kɨmnhatərhav apa Kapaneam. Kɨni narmamə yame kasərer tuk mane kape takis kape Nimə Ehuə kape Kughen khauə tuk Pita mhamə, “?Rhawor? ?Yhajoun kafam ramərok-pən takis kɨn mane kape Nimə Ehuə kape Kughen, uə nɨkam?” ");
INSERT INTO nwi_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Kɨni Pita rɨmə, “Ǝwəh. Ramərok.” Kɨni Pita rɨvən ye nəkwai nimə, Yesu rəkupən maməgkiar mamni nuhpɨkɨnien kɨrik mɨmə, “Saemon. ?Nakmə rhawor? ?King mɨnə kape tokrei tanə kamhavəh takis tuk nɨpa? ?Kamhavəh tuk kapəriə narmamə mɨnə, uə tuk nəmə tanə pɨsɨn yamə mɨne kɨmɨsapita əriə ye narowagkəpien?” ");
INSERT INTO nwi_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Mərɨg Pita rɨmə, “Kamhavəh tuk nəmə tanə pɨsɨn yamə mɨne kɨmɨsapita əriə ye narowagkəpien.” Kɨni Yesu rɨmə, “Nəfrah. Narmamə kape king khapəh nɨsərokien takis.” ");
INSERT INTO nwi_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kɨni Yesu rɨrpɨn mɨmə, “Mərɨg kɨtawə khapəh nɨsorkeikeiyen mə tuksor niemha rhai əriə tuk ətawə. Kɨni ror məknei, rhuvə mə ik takvən apa ye lugun, maruk kɨn string, mɨvi kəmam. Kəmam yame takvi məkupan, meikus nəkwan, məm mane kɨrik rəmhen tuk nərokien takis. Vəh mane en, mɨvən, mɨvəhsi-pən kɨmi əriə tuk nərokien takis kapərao.” ");
INSERT INTO nwi_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ye nɨpɨg a, narmamə kape Yesu kɨmnhauə mɨsaiyoh-pən mhamə, “?Pa in yerpɨrɨg ye narmaruyen kape Kughen?” ");
INSERT INTO nwi_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kɨni Yesu rokrən kɨn kwajikovə kɨrik, ruə mərer ye kwerkwan irəriə. ");
INSERT INTO nwi_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kɨni mɨmə, “Yakamni-pre əfrakɨs tuk əmiə mə tukmə nakhapəh nɨsararien irəmiə mhauə rəmhen kɨn kwajikovə, to nakhapəh nhavənien mɨsarə ye narmaruyen kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ror məkneikɨn, tukmə yermamə ravəhsi-əhu atuk in rəmhen kɨn kwajikovə e, in yerpɨrɨg ye narmaruyen kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Yermamə yame ravəh nhagɨk, mamasitu kɨn ye kwajikovə kɨrik rəmhen kɨn yame, nasituyen e in e tukror mɨn kɨmi Yo. ");
INSERT INTO nwi_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Mərɨg Kughen tukror narpɨnien ehuə kɨmi narmamə yamə mɨne kamhavi-pən kwajikovə yamə mɨne kɨshatətə irak, mə tuksor təvhagə has. Kɨni narpɨnien a tukrɨskai rapita yame tukruk-pən kapier kɨrik ye nɨpətək nuan, karkw-ərhav-pən kɨn apa ye tame tahik mə tukrəmnɨm. ");
INSERT INTO nwi_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“!Kəsi! Nəmhəyen ehuə tukruə tuk narmamə kape tokrei tanə e yame kamhavəh-si-pən vəhsi-pən kɨmi narmamə mə tuksor təvhagə hah. Nɨvəhsi-pən vəhsi-pənien mɨnə a tukraməkeikei muə. !Mərɨg, kəsi! Nəmhəyen ehuə tukruə tuk yermamə yame in ramor swatuk tuk nahasien a. ");
INSERT INTO nwi_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kɨni tukmə kwermɨm uə nɨhum ramor ik nakamor təvhagə hah, rhuvə mə takərəru ta marakikɨn. Rhuvə pɨk mə takpəh kwermɨm uə nɨhum nɨkarɨn mamragh kɨn kape rerɨn. Yame rhuvə pɨk rapita yame takvən ye nap ehuə kɨn kwermɨm kwis mir uə nɨhum kwis mir. ");
INSERT INTO nwi_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kɨni tukmə nɨmrɨm ramor ik nakamor təvhagə hah, rhuvə mə takɨkum ierɨg ta marakikɨn. Rhuvə pɨk mə takpəh nɨmrɨm kɨrikianə mamragh kɨn kape rerɨn. Rapita yame takvən ye nap ehuə kɨn nɨmrɨm kwis mir.” ");
INSERT INTO nwi_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Kɨni Yesu rɨmə, “Takasəkeikei mharkun huvə mə takhapəh nɨsəm-əhuyen narmamə mɨnə kafak yamə kɨsəmhen kɨn kwajikovə, meinai yakamni-pre tuk əmiə mə agelo yamə mɨne kasəm əriə, nɨpɨg mɨfam iriə kasərer ye nɨmrɨ Rɨmɨk apa ye rao ye neai, mamhani-ərhav pən nhagriə tukun. ");
INSERT INTO nwi_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kɨni Yo, Ji Yermamə, yɨmauə mə jakarhakɨn narmamə yamə mɨne kwəserwei, mɨvəh mɨragh əriə. ");
INSERT INTO nwi_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Tukmə yermamə kɨrik, kafan sipsip wan handred, kɨni kɨrikianə ramerwei. ?Mərɨg nakɨrkun mə tukrhawor? In tukraməkeikei mɨpəh kafan naenti naen sipsip kasərer ye tukwas, kɨni in mɨvən marhakɨn yame rɨmnerwei. ");
INSERT INTO nwi_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kɨni yakamni-pre əfrakɨs tuk əmiə mə nɨpɨg tukrəm, rɨkin tukragien tuk sipsip kɨrikianə əmə rapita nagienien tuk naenti naen e khapəh nɨserweiyen. ");
INSERT INTO nwi_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","“Ye norien kɨrikianə əmə mɨn, Rɨmɨmiə apa ye rao ye neai, In rɨpəh norkeikeiyen mə kafan kɨrik kwajikovə tukrerwei.” ");
INSERT INTO nwi_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Kɨni Yesu rɨmə, “Tukmə piam kɨrik ror nahasien kɨmik, yuvən kɨmiru pɨsɨn əmə, mhajoun-pən naha nhagɨn yame rɨmnor rɨpəh nəmhenien. Tukmə rərɨg ik, kafam nəgkiarien tukror rɨkin rɨrerɨg-pə mɨn, nakawor huvə əmiru mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mərɨg tukmə rɨpəh nərɨgien ik, takvəh mɨn yermamə kɨrikianə uə kɨraru, mə tukɨrkun mə nəgkiarien fam yame takhani in nəfrakɨsien. ");
INSERT INTO nwi_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kɨni tukmə rɨpəh nərɨgien əmiə, hani-ərhav kɨmi niməhuak. Kɨni tukmə rɨpəh nərɨgien niməhuak, səm in rəmhen kɨn yemə iruə, uə yemə has rəmhen kɨn yermamə yame ramərer tuk mane kape takis. ");
INSERT INTO nwi_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Yakamni-pre əfrakɨs tuk əmiə mə tukmə naksəhitə ye naha tapɨg ye tokrei tanə, tukrəhitə ye rao ye neai. Tukmə nakasətapɨg ye naha tapɨg ye tokrei tanə, tukrətapɨg ye rao ye neai. ");
INSERT INTO nwi_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Kɨni yakamni-pre mɨn tuk əmiə mə, tukmə kɨmiru kɨraru nakrani kwis mə takwaiyoh kɨn nar kɨrik, kɨni Rɨmɨk apa ye rao ye neai tukror naha nhagɨn yame nakawaiyoh kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ror məkneikɨn meinai ikɨn hiə yermamə kɨraru uə kɨsisər kɨrhuə kɨrikianə ye nhagɨk, kɨmawə miriə.” ");
INSERT INTO nwi_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kɨni Pita rɨmauə tuk Yesu maiyoh-pən In mɨmə, “Yermaru. ?Tukmə piak ramor ahas pə kɨmi yo mamrɨpɨn, nakmə jakaməkeikei mor fogivim iran m-kɨvhuun? ?Mɨ-seven rəmhen uə nɨkam?” ");
INSERT INTO nwi_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Kɨni Yesu rɨmə, “Yakamni-pre tuk ik mə, pəh nien mə takor fogivim iran m-seven əmə, mərɨg takor m-seventi seven. ");
INSERT INTO nwi_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Takaməkeikei mor məknai meinai narmaruyen kape Kughen rəmhen əmə kɨn yame king kɨrik rorkeikei mə tukrəm-ru kaon yamə mɨne kafan narmamə kasor kɨmin, mə iriə tukasəkeikei mɨsarpɨn. ");
INSERT INTO nwi_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nɨpɨg rɨmɨrikakun mə tukrɨvəh tai mane, kharəh kafan kɨrik yorwok yame ramor kaon rəmhen kɨn milian vatu khapsaah, mhavən kɨmin. ");
INSERT INTO nwi_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kwən a reinein narpɨnien; king rɨmə tukor salem kɨn yor wok a mɨne kafan piraovɨn mɨne kafan kwajikovə mɨnə mɨne kafan narɨmnar mɨnə fam pəh rarpɨn kafan kaon. ");
INSERT INTO nwi_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Məkneikɨn kafan yorwok rənɨmkur-pən tukun, maməkeikei mamni-pən tukun mə, ‘!Aweh! ?Nakɨrkun nɨvəhsi-pə-mɨnien nɨpɨg kwakwə kɨmi yo pəh yakarpɨn fam kafak kaon uə?’ ");
INSERT INTO nwi_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kɨni kafan yemehuə rɨkin rehuə tukun, kɨni məpəh fam kafan kaon mə tukrɨpəh mɨn narpɨnien, meighaan kɨn mə tukramvən. ");
INSERT INTO nwi_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Mərɨg nɨpɨg yorwok a rɨmavən, məm yermamə kɨrik yame rɨmnor kaon kɨmin rəmhen kɨn wan handred taosen vatu əmə. Iriu kwis yorwok mir kape king. Kɨni yorwok yame king rɨmnəru-kɨn kafan kaon, rarar mɨraptərəkɨn yermamə yame ramor kaon kɨmin, mɨrəh nɨpətək nuan, məvɨt, mamni mɨmə, ‘!Arpɨn kafam kaon yame nɨmnor kɨmi yo!’ ");
INSERT INTO nwi_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Kɨni yorwok a yame rɨmnor kaon kɨmin reiwaiyu mənɨmkur maməkeikei kɨmin mɨmə, ‘!Aweh! ?Nakɨrkun nɨvəhsi-pəyen nɨpɨg kwakwə kɨmi yo pəh yakarpɨn fam kafak kaon uə?’ ");
INSERT INTO nwi_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Mərɨg in rɨmə, ‘Nɨkam.’ Kɨni mɨvən mə tukrɨvəh kwən a kavən kɨvəhsi-pən ye kalabus meriaji rarpɨn fam mane yame rɨmnor kaon kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Nɨpɨg yorwok mɨnə tɨksɨn kɨmɨsəm nar a, rɨkiriə rəmhə pɨk tukun. Kɨsarar mhavən mhani-əsah-pən fam narɨmnar yamə mɨne kɨmɨsəm tuk king. ");
INSERT INTO nwi_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Kɨni king rɨmnokrən kɨn yorwok a ruə rɨni-pən tukun mə, ‘Ik yorwok has kɨrik. Yɨmnəpəh fam kafam kaon, meinai ik nɨmnəkeikei kɨmi yo tukun. ");
INSERT INTO nwi_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","?Mərɨg rhawor e rɨkim rɨpəh nehuəyen tuk yermamə yame nakawor wok kɨmiru min, rəmhen kɨn yame rɨkik rehuə tuk ik?’ ");
INSERT INTO nwi_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kɨni niemha rhai king a, kɨni rɨmə tukrəh kavən kɨrəhsi-pən ye kalabus mə yemə ramarha tuk kalabus tukror nəmhəyen kɨmin meriaji rarpɨn fam mane yame ramor kaon kɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu rɨmɨni-ta nuhpɨkɨnien a, mɨni-pən tuk əriə mə, “Tukmə kɨmiə nakhapəh nɨsəru-kɨnien norien has yame piaumiə mɨnə kasor irəmiə, Rɨmɨk apa ye rao ye neai tukrɨvəhsi-pre mɨn narpɨnien rəmhen kɨn yame king a rɨmnor kɨmi kafan yorwok.” ");
INSERT INTO nwi_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kɨni Yesu rəgkiar ta, mɨtərhav Galili mɨvən ye provins e Judia, mɨvən maməmɨr apa nɨkar nu Jodan pən. ");
INSERT INTO nwi_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kɨni narmamə khapsaah khakwasɨg kɨn. Kɨni In rɨmnor huvə narmamə aikɨn yamə mɨne kamhamhə, kasəsanɨn. ");
INSERT INTO nwi_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kɨni Farisi tɨksɨn khauə masaiyoh Yesu kɨn naiyohyen əutən kɨrik mə tuksəm-ru mə tukrɨni nəgkiarien kɨrik yame rɨpəh nəmhenien. Mhani-pən tukun mhamə, “?Loa rameighan kɨn mə yerman rɨrkun nəpəhyen kafan piraovɨn tuk nərɨgien apnapɨg əmə kɨrik kafan uə nɨkam?” ");
INSERT INTO nwi_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Kɨni Yesu rɨni-pən tuk əriə mə, “Tukmə ror kɨmiə nakhapəh nɨsəvheikɨnien ye Nəkwəkwə kape Kughen mə nɨpɨg Kughen rɨmnərəhu nɨmoptanə, ‘In mor mɨn yerman mɨne piraovɨn.’ ");
INSERT INTO nwi_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kɨni mɨmə yerman tukrəta ye rɨmni mɨne nɨsɨni, kɨni iriu piraovɨn mwarə kɨrikianə. ‘Iriu tukrauə nɨprairiu kɨrikianə.’ ");
INSERT INTO nwi_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kɨni iriu kwis tukwarə kɨrikianə. Meinai Kughen rɨməviəfugɨn məknakɨn əriu, yermamə to rɨpəh nakapɨrien narəyen kapəriu.” ");
INSERT INTO nwi_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kɨni iriə kɨsaiyoh-pən In mhamə, “?Tukmə ror məknakɨn, rhawor e Moses rɨmneighan kɨn mə yerman rɨrkun nɨraiyen nəkwəkwə tuk nəpəhyen kafan piraovɨn mɨvəhsi-pən kɨmin, kɨni məpəh in?” ");
INSERT INTO nwi_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Kɨni Yesu rɨni-pən mɨn tuk əriə mɨmə, “Moses rɨmneighan kɨn əmiə mə taksəpəh kapəmiə nɨpiraovɨn mɨnə meinai kapəmia kapə rɨskai pɨk. Mərɨg in apa kupan rɨpəh norien məknakɨn. ");
INSERT INTO nwi_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mərɨg yakamni-pre tuk əmiə mə tukmə yerman kɨrik, kafan piraovɨn rɨpəh nɨvən-hanəyen tuk yerman pɨsɨn kɨrik, kɨni tukmə yerman a rarar mɨvən tuk yarmə, rəmhen kɨn mə in rɨmnəkrəh kɨn piraovɨn a.” ");
INSERT INTO nwi_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kafan narmamə kɨsərɨg, kɨsakur, mhani-pən tukun mhamə, “Tukmə narəyen kape yerman mɨne piraovɨn rɨskai pɨk məkneikɨn, rhuvə mə tukpəh əmə norien kape mared.” ");
INSERT INTO nwi_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “Pəh nien mə narmamə m-fam kharkun nɨsorien nəgkiarien e; mərɨg əmə yamə mɨne Kughen rɨmɨvəhsi-pən nɨrkunien kɨmi əriə, kapəriə pɨsɨn əmə. ");
INSERT INTO nwi_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ror məknakɨn meinai narmamə tɨksɨn to khapəh nɨsorien mared tuk nərɨgien pɨsɨn pɨsɨn mɨnə. Tɨksɨn tukhapəh nɨsorien mared meinai nɨprairiə rahas ror hanə. Kɨni tɨksɨn tukhapəh nɨsorien mared meinai kərai rəmhen kɨn kao karman. Kɨni tɨksɨn kamhani atuk əmə mə tukhapəh nɨsorien mared mə tuksor wok kape narmaruyen kape Kughen. Yermamə yame rɨrkun nɨvəhyen nəgkiarien e, tukraməkeikei mɨvəh.” ");
INSERT INTO nwi_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kɨni narmamə tɨksɨn khapɨk kapəriə kwajikovə mɨnə, mhauə mɨsəm mɨn Yesu, mə In tukrərəhu-pən kwermɨn irəriə, maməhuak tuk əriə. Mərɨg narmamə mɨnə kape Yesu kɨmnhani-əhu əriə. ");
INSERT INTO nwi_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kɨni Yesu rɨmə, “Takhapəh nhani-əhuyen kwajikovə mɨnə. Səta irəriə pəh khauə tuk Yo. Meinai Kughen tukramarmaru ye narmamə yamə mɨne kɨsəmhen kɨn kwajikovə mɨnə en.” ");
INSERT INTO nwi_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kɨni In mɨpɨk kwajikovə mɨnə a mərəhu-pən kwermɨn irəriə, mɨvəhsi-pən nɨhuvəyen kɨmi əriə, mɨtərhav aikɨn a. ");
INSERT INTO nwi_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kɨni tamaruə kɨrik ruə məm Yesu, maiyoh In mɨmə, “Yhajoun. ?Nakmə jakaməkeikei mor naha nhagɨn yame rhuvə, mə jakamarə rerɨn?” ");
INSERT INTO nwi_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Kɨni Yesu rɨmə, “?Nakhawor mamaiyoh Yo kɨn nar yame rhuvə? Yermamə kɨrik rapəh nɨhuvəyen. Kughen əmə In rhuvə. Tukmə nakmə takarə ye nɨmraghien rerɨn, əri-pən loa.” ");
INSERT INTO nwi_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mərɨg kwən a rɨmə, “?Naha loa yame nakamni?” Kɨni Yesu rɨmə, “Takpəh nhopniyen yermamə. Kɨni mɨpəh napɨr-pənien tuk piraovɨn pɨsɨn. Kɨni mɨpəh nəkrəhyen. Kɨni mɨpəh nɨni-apnapɨgien nar meikuə kɨn ye yermamə kɨrik. ");
INSERT INTO nwi_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tuk nɨpɨg mɨnə fam takamsiai rɨmɨm mɨne nɨsɨnɨm. Kɨni morkeikei mɨn ik mɨnə tɨksɨn rəmhen kɨn yame nakorkeikei atuk ik.” ");
INSERT INTO nwi_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kɨni tamaruə ai rɨni-pən tukun mɨmə, “Yhajoun. Loa mɨnə en, yakaməri-pən fam. ?Mərɨg naha nhagɨn raməmɨr yame yakpəh hanə norien?” ");
INSERT INTO nwi_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Kɨni Yesu rɨmə, “Tukmə nakmə kafam nɨmraghien tukratuatuk, yuvən, məvrai rik rik kafam narɨmnar, mɨvəh mane iran, kɨni mɨvəhsi-pən kɨmi narmamə yavən has mɨnə. Kɨni kafam narɨmnar tukrɨpsaah apa ye neai. Kɨni ik muə, mɨkwasɨg kɨn Yo.” ");
INSERT INTO nwi_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nɨpɨg tamaruə ai rɨmnərɨg nəgkiarien yame Yesu rɨmɨni, rɨkin rəpou, meinai kafan nautə rɨpsaah. ");
INSERT INTO nwi_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kɨni Yesu rɨni-pən tuk kafan narmamə mɨnə mɨmə, “!Nəfrakɨs! Rɨskai pɨk tuk narmamə yamə mɨne kapəriə nautə rehuə tuk nɨvənien ye narmaruyen kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kɨni yakamni-pre mɨn tuk əmiə mə, ?Nakasərɨg mə nar mɨragh ehuə kɨrik rəmhen kɨn kamel, to rauru-pən ye kwəruwei nidil uə? Nɨkam, rəutən pɨk. Rəmhen əmə mɨn kɨn yermamə yame kafan nautə rehuə, rəutən pɨk tukun tuk nətayen aikɨn a muə Kughen ramarmaru iran.” ");
INSERT INTO nwi_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kɨni narmamə kafan mɨnə kɨsərɨg, kɨsakur, mɨnəsaiyoh mhamə, “!Eh! ?Mərɨg tukmə ror məknekɨn, kɨtawə pa in tukramarə ye nɨmraghien rerɨn?” ");
INSERT INTO nwi_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Mərɨg Yesu rəm tɨm tɨm əriə mɨni-pən tuk əriə mə, “Nar e, to yermamə rɨpəh norien. Kughen pɨsɨn əmə In rɨrkun norien. Meinai In rɨrkun norien narɨmnar fam.” ");
INSERT INTO nwi_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kɨni Pita rɨni-pən tukun mɨmə, “?Mərɨg kɨmawə jakhavəh naha nhagɨn? Yɨməsəpəh fam kapəmawə narɨmnar, mhauə, mhakwasɨg kɨn Ik.” ");
INSERT INTO nwi_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kɨni Yesu rɨni-pən tukun mə, “Yakamni əfrah tuk əmiə mə, ye nɨpɨg yame narɨmnar fam tukhaukreikɨn mhauə mhawi, kɨni Yo, Ji Yermamə, jakəkwətə ye kafak jea kape king yame rhakak pɨk, kɨni kɨmiə e yame nɨmnhakwasɨg kɨn Yo, taksəkwətə-pən mɨn ye jea kape king iriə m-fam twelef, kɨni masarmaru ye kwənərəus twelef kape Isrel. ");
INSERT INTO nwi_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kɨni narmamə m-fam yamə mɨne kɨmɨsəpəh kapəriə nimə mɨnə, uə piauriə mɨnə, uə nowinriə mɨnə, uə rɨmriə mɨnə, uə nɨsɨnriə mɨnə, uə jiriə mɨnə, uə kapəriə nɨpiraovɨn, uə nɨmoptanə kapəriə tuk nhagɨk, Kughen tukrɨvəh-sipən narɨmnar mɨnə a rehuə pɨk kɨmi əriə, mɨvəhsi-pən nɨmraghien rerɨn kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mərɨg, narmamə mɨnə e kasəkupən tukpihamakwasɨg, kɨni yamə mɨne kamhakwasɨg tukpihauə mɨpisəkupən.” ");
INSERT INTO nwi_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kɨni Yesu rɨmə, “Ror məkneikɨn mə narmaruyen kape Kughen rəmhen kɨn yemehuə kɨrik kape nəsimien. Rɨmatərhav yenpɨg-enpɨg əgkap marha-kɨn narmamə mə tukhauə mɨsor wok ye plantesen kape grep. ");
INSERT INTO nwi_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kɨni mɨni mə tukrərok əriə kɨrikianə kɨrikianə wan taosen vatu. Marar mher-pən kɨn əriə khavən mɨsəsim. ");
INSERT INTO nwi_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ipakə tuk naen klok yenpɨg-enpɨg, rɨtərhav, mamvən ye maket, məm narmamə tɨksɨn kasərer apnapɨg. ");
INSERT INTO nwi_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Rɨni-pən tuk əriə mə, ‘Kɨmiə havən mɨsəsim apa plantesen kape grep kafak. Kɨni jakərok əmiə kɨn mane yame ratuatuk.’ ");
INSERT INTO nwi_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kɨni kɨmnhavən. “Kɨni yerkweiha, rɨmatərhav mor nar kɨrikianə mɨn, kɨni mor mɨn ye tri klok yenaiyu. ");
INSERT INTO nwi_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kɨni ipakə tuk faef klok yenaiyu, rɨtərhav mɨvən məm narmamə tɨksɨn kasərer apnapɨg əmə. Kɨni rɨni-pən tuk əriə mə, ‘?Rhawor nakasərer ikɨn e kape nɨpɨg piəpiə kɨrik mhapəh nɨsorien nar kɨrik?’ ");
INSERT INTO nwi_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Mərɨg khani-pən tukun mhamə, ‘Meinai yermamə kɨrik rɨpəh nɨvəhsi-pəyen wok kɨrik kɨmi əmawə.’ “Kɨni rɨni-pən tuk əriə mə, ‘Kɨmiə havən mɨsəsim apa plantesen kape grep kafak.’ ");
INSERT INTO nwi_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kɨni yenaiyu, yemehuə kape plantesen kape grep rɨni-pən tuk manaja mə, ‘Okrən kɨn yorwok mɨnə khauə, nakvəhsi-pən nərok kapəriə. Takrikakun mamərok narmamə yamə mɨne kɨmnhauə mhakwasɨg, mamvən meriaji-pən narmamə yamə mɨne kɨmnhauə mɨsəkupan.’ ");
INSERT INTO nwi_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Kɨni yorwok yamə mɨne kɨmnhauə mɨsor wok ye faef klok, manaja rɨmnərok əriə wan taosen vatu. ");
INSERT INTO nwi_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ror pən, narmamə yamə mɨne kɨmɨsəkupən mɨsor wok, khamə ta mə tukhavəh rapita yamə mɨne kɨmɨsor wok mhakwasɨg. Mərɨg iriə kɨrikianə kɨrikianə kɨmnhavəh əmə wan taosen vatu. ");
INSERT INTO nwi_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nɨpɨg kɨmnhavəh mane, mɨsat-munmun mhani hah yemehuə kape plantesen. ");
INSERT INTO nwi_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Mhani-pən tukun mhamə, ‘Nəmə yamə mɨne kɨmɨsor wok mhakwasɨg, kɨmɨsor əmə wok ye aoa kɨrikianə əmə, mərɨg ik nɨmnərok əmawə miriə rəm nəmhen əmə. Mərɨg kɨmawə yɨmɨsor wok ehuə yerkweiha ehuə, nɨpɨg piəpiə.’ ");
INSERT INTO nwi_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Mərɨg yemehuə rɨni-pən tuk əriə mə, ‘Yo kɨrik. Pa rɨmə yɨmnoriah ik. Nakneighaan ta kɨn mə jakvəhsi-pre wan taosen vatu. ");
INSERT INTO nwi_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Vəh kafam mane mamvən. Yakorkeikei mə jakərok yermamə yame rɨmɨkwasɨg rəmhen əmə kɨn ik. ");
INSERT INTO nwi_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kafak e mane. Yakɨrkun norien naha nhagɨn kɨn mane kafak. ?Nakamor jalus meinai yakamor huvə pən kɨmi əriə uə?’” ");
INSERT INTO nwi_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kɨni Yesu rɨmɨni-ta nuhpɨkɨnien mɨni-pən tuk əriə mə, “Narmamə mɨnə e kamhakwasɨg tukpisəkupan, kɨni yamə mɨne kasəkupən tukpihakwasɨg.” ");
INSERT INTO nwi_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kɨni Yesu mɨne kafan narmamə kɨshaktə mhavən Jerusalem. Kɨni Yesu rokrən mɨn kɨn kafan narmamə twelef mə tukhauə ye tamhekɨn kɨrikianə. Kɨni mɨni-pən mɨmə, ");
INSERT INTO nwi_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Taktəkun ai tukshaktə mhavən Jerusalem. Kɨni ye kwənmhaan aikɨn a, narmamə tɨksɨn tuksərəhu-pən Yo, Ji Yermamə, ye kwermɨ jif pris mɨne nəmhajoun kape loa kape Moses. Kɨni iriə tukhauh Yo mə Yo jakaməkeikei mɨmhə. ");
INSERT INTO nwi_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kɨni tukseighan-pən kɨn Yo kɨmi narmamə mɨnə e pəh nien mə nəmə Isrel, mə tuksarh iakei irak, mɨsərkɨs-ərkɨs Yo, kɨni mɨsəsɨk-pən yo ye nai kamarkwao kɨn. Kɨni mərɨg jakamragh mɨn ye nɨpɨg yame ror kɨsisər kɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kɨni piraovɨn kape Sebedi rɨkɨr tɨni mir muə mənɨmkur-pən tuk Yesu maiyoh In kɨn nar kɨrik. ");
INSERT INTO nwi_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kɨni Yesu rɨmɨni-pən tukun mə, “?Nakorkeikei naha?” Kɨni pian a rɨmə, “Pəh kafak kwajikovə mir kɨrik tukrəkwətə ye nɨkarɨm matuk, kɨni kɨrik tukrəkwətə ye nɨkarɨm mawor, nɨpɨg Ik takvəh nehuəyen kape narmaruyen.” ");
INSERT INTO nwi_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Mərɨg Yesu rɨni-pən tuk kwərə mir a mə, “Nakawaiyoh-pə kɨn nar kɨrik yame nakweinein. ?Kɨmiru nakramə nakwəmhen mə takwərɨg mɨn nəmhəyen ye nɨpraimiru rəmhen kɨn yame Yo jakərɨg uə?” Kɨni iriu kramə, “Ǝhə. Kɨmru yakwəmhen.” ");
INSERT INTO nwi_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Kɨni Yesu rɨni-pən mə, “Nəfrakɨs. Kɨmiru takwərɨg nəmhəyen rəmhen kɨn yame Yo jakərɨg. Mərɨg nar yame nakwaiyoh kɨn, mə kɨrik tukrəkwətə ye nɨkarɨk matuk, kɨrik ye nɨkarɨk maor, yo yakeinein nɨvəhsi-preyen. Mərɨg Rɨmɨk Kughen rɨmɨvəhsi-pən kwənmhan mir e kɨmi narmamə yamə mɨne In rɨmɨrpen ta mɨmə iriə tuksəkwətə ikɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nɨpɨg narmamə mɨnə tɨksɨn kape Yesu, iriə ten, kɨsərɨg nəvsaoyen kɨn, niemha rhai əriə tuk Jemes mɨne Jon. ");
INSERT INTO nwi_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kɨni Yesu rokrən kɨn əriə mə tukhauə mɨsəm. Kɨni mɨni-pən tuk əriə mə, “Kɨmiə nakwənharkun ta norien kape nəmehuə yamə mɨne pəh nien mə nəmə Isrel. Iriə kasor əutən pɨk tuk kapəriə narmamə mɨnə. Kɨni kapəriə nəmehuə mɨnə kasəviətərəkɨn-əhu pɨk əriə mhamə tukamhakwasɨg əmə kɨn əriə. ");
INSERT INTO nwi_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mərɨg rɨpəh natuatukien mə kɨmiə taksor məknakɨn. Tukmə kɨmiə kɨrik rorkeikei mə tukrɨvəh nehuəyen rapita əmiə, nərɨgien kafan tukreiwaiyu muə mə in yor atuə kɨn kɨrik kapəmiə. ");
INSERT INTO nwi_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kɨni tukmə kɨmiə kɨrik rorkeikei mə tukrəkupən mamkɨr əmiə, in mɨn tukruə rəmhen kɨn yasitu kapəmiə fam ");
INSERT INTO nwi_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","rəmhen kɨn yame Yo mɨn, Ji Yermamə, pəh nien mə Yo yɨmauə mə narmamə tuksor atuə kɨn kafak. Yɨmauə mə jakor atuə kɨn kapəriə, kɨni moriah kafak nɨmraghien marpɨn nɨmraghien kɨn kape narmamə khapsaah.” ");
INSERT INTO nwi_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kɨni Yesu mɨne kafan narmamə khauə yerkwanu kɨrik nhagɨn e Jeriko. Mɨsarə, mhatərhav mɨn, narmamə khapsaah kɨmnhakwasɨg kɨn əriə. ");
INSERT INTO nwi_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kɨni nɨmrɨn pɨs mir kwəkwətə ye nɨkar swatuk. Kɨni nɨpɨg kwərɨg mə Yesu e ramuə, kwokrən kɨn In mɨrəmə, “!Yermaru! !Kwənərəus kape King Deved! Yakworkeikei mə rɨkim tukrehuə tuk əmru.” ");
INSERT INTO nwi_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kɨni narmamə khapsaah kɨsəgkiar-pən skai kɨmi əriu, mhamə, “!Ah! Rapim.” Mərɨg iriu karərpɨn əmə ye nokrənien. Mɨrəmə, “!Yermaru! !Kwənərəus kape King Deved! Yakworkeikei mə rɨkim tukreihuə tuk əmru.” ");
INSERT INTO nwi_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kɨni Yesu rarar, mokrən kɨn əriu mɨmə, “?Nakramə jakor naha nhagɨn kɨmi əmiru?” ");
INSERT INTO nwi_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kɨni krəni-pən tukun mɨrəmə, “Yermaru. Yakworkeikei mə nɨmrɨmru tukrarha, pəh yakwəm nar.” ");
INSERT INTO nwi_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kɨni Yesu rɨkin rehuə tuk əriu, mərao-pən mɨrap nɨmrɨriu. Məknekɨn nɨmrɨriu rarha. Kɨni kwəm nar. Kɨni ai iriu mɨrakwasɨg kɨn Yesu. ");
INSERT INTO nwi_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kɨnəmhavən pakə tuk Jerusalem, mhatərhav-pən yerkwanu e Betfas, ipakə tuk tukwas kɨrik nhagɨn e Olif. Kɨni Yesu rher-pən kɨn yermamə kɨraru kafan, ");
INSERT INTO nwi_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","mɨmə “Takravən yerkwanu a nakaravaag-pən ikɨn. Kɨni mwəm dongki kɨrik, mɨne tɨni, kɨmɨrkwəji əriu. Nakararɨsɨn əriu, mwəsɨg mɨrauə. ");
INSERT INTO nwi_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kɨni tukmə yermamə kɨrik raiyoh-pre tuk əmiru mə takweihe kɨn, takrani-pən tukun mɨrəmə, ‘Yermaru rɨmə tukrəsuə ye dongki mir e.’ Kɨni taktakun əmə tukreighaan kɨn dongki mir a kɨmi əmiru.” ");
INSERT INTO nwi_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nar a rɨtərhav-pə ror nəgkiarien kape profet kupan ruauə mɨnor nəfrakɨsien kɨn, yamə rɨmɨni mɨmə, ");
INSERT INTO nwi_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Hani-pən tuk nɨpian Saeon mhamə, ‘Səm-ru kapəmiə king ruauə tuk əmiə, maməsuə ye dongki. Maməsuə ye ji dongki. Kɨni king a In yemə mar.’” ");
INSERT INTO nwi_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kɨni kafan yermamə mir kwor naha nhagɨn yame Yesu rɨmɨni. ");
INSERT INTO nwi_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Kɨravən mɨrarəh dongki mɨne tɨni mɨrauə mwəm Yesu. Mɨravəhsi-ta kot kapəriu mawəpeinə-pən kɨn ye nɨmetai dongki. Kɨni Yesu rəsuə iran. ");
INSERT INTO nwi_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Narmamə khapsaah kɨsətu kot kapəriə mɨmhahuvə-pən kɨn kɨmi swatuk; kɨni mɨsərai nɨmar nai mɨsətu-pən mɨn ye swatuk. ");
INSERT INTO nwi_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Narmamə yamə mɨne kasəkupən kɨn Yesu kɨni mɨne yamə mɨne kɨmnhakwasɨg kɨn kasokrən apomh mamhani mhamə, “!Səgnəgɨn Mɨkɨp King Deved! Pəh kɨvəh-si haktə Kwən e ramuə ye nhag Yermaru. !Səgnəgɨn Kughen yerpɨrɨg!” ");
INSERT INTO nwi_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu rɨmatərhav-pə Jerusalem, narmamə m-fam aikɨn, rɨkiriə rɨmnakur mamhani nəgkiarien rɨpsaah mɨsaiyoh-pən əriə mɨnə mhamə, “?Pa e?” ");
INSERT INTO nwi_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kɨni narmamə khamə, “Yesu e. In profet kɨrik rɨmasɨ-pən apa Nasaret ye provins a Galili.” ");
INSERT INTO nwi_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kɨni Yesu rɨvən ye nimə ehuə kape Kughen. Kɨni maməko yerhav narmamə yamə mɨne kasəvrai narɨmnar mamhavəh mane iran, mɨne yamə mɨne kasəvrə. Kɨni mərakita kɨn narɨmnar yame ramswin ye tebol kape narmamə yamə mɨne kasərai mane ikɨn; kɨni məsuə kɨn jea kape narmamə yamə mɨne kasor salem kɨn mak ye tanə. ");
INSERT INTO nwi_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kɨni mor kwirɨg kɨmi əriə mɨmə, “Kɨmɨrai ye Nəkwəkwə kape Kughen kɨmə, “‘Nimə kafak, in nimə kape nəhuakien.’ Mərɨg kɨmiə nakasor rəmhen kɨn ‘nimə yame yəkrəh mɨnə kaserkwaig ikɨn.’” ");
INSERT INTO nwi_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kɨni nɨmrɨn pɨs mɨnə mɨne yamə mɨne nɨhuriə rarpəvɨn kɨmnhavən tuk Yesu apa ye Nimə Ehuə kape Kughen, kɨni ror huvə əriə. ");
INSERT INTO nwi_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kɨni kwajikovə mɨnə kasokrən apomh ipakə tuk Nimə Ehuə kape Kughen mamhani mhamə, “!Səgnəgɨn Mɨkɨp King Deved!” Mərɨg jif pris mɨnə mɨne nəmhajoun kape Loa kɨmɨsəm Yesu ramor narɨmnar huvə mɨnə, mɨsərɨg mə kwajikovə mɨnə a kasəgnəgɨn In, niemhaa rhai əriə. ");
INSERT INTO nwi_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Khani-pən tuk Yesu mhamə, “?Nakərɨg nəgkiarien yame kwajikovə mɨnə e kamhani iram uə?” Kɨni Yesu rɨmə, “Ǝhə. Mərɨg tukmə ror nakhapəh nɨsəvheikɨnien nəgkiarien ye Nəkwəkwə kape Kughen yame ramni mə, “‘Ik nɨmnor mə kwajikovə mɨnə, mɨne kwajikovə əmtəmtə mɨnə tuksəgnəgɨn Ik ye tɨkinheriə.’” ");
INSERT INTO nwi_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kɨni rəgkiar ta, məpəh əriə mɨtərhav Jerusalem mamvən Betani, mapɨr ikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kəni rɨkwamer kɨn, yenpɨg-yenpɨg əgkap, iriə khatərhav mɨn Betani, mharerɨg-pən Jerusalem, kɨni Yesu rɨnəmkərəv. ");
INSERT INTO nwi_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kɨni məm nai kɨrik, kɨmə figtri, ramərer ye nɨkar swatuk. Rəriwək mɨvən pakə tukun, məm nɨmarɨn in əmə e in əmə. Kɨni Yesu rəgkiar-pən kɨmi figtri ai mɨmə, “Yermamə tukrɨpəh mɨn nənien kwənkwam tuk nɨpɨg kɨrik.” Məkneikɨn nai a rɨmnaukei. ");
INSERT INTO nwi_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kɨni narmamə kafan mɨnə kɨmɨsəm, kɨsakur. Mhamə, “!E-he-o! !Nai e raukei ahuaa əmə!” ");
INSERT INTO nwi_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Kɨni Yesu rɨni-pən tuk əriə mə, “Yakamni-pre əfrakɨs tuk əmiə mə tukmə nakshatətə ye Kughen, kɨni kapəmiə nhatətəyen rɨpəh norien kɨraru, nakharkun nɨsorien nar yame yɨmnor ye figtri. Mərɨg pəh nien mə in əmə a, mərɨg nakharkun nhani-pənien tuk tukwas a mhamə, ‘Ǝta eikɨn e mɨvən məmnɨm apa ye tahik’ kɨni tukror nəkwaimiə. ");
INSERT INTO nwi_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tukmə nakshatətə, nakharkun nhavəhyen naha nhagɨn yame naksəhuak tukun.” ");
INSERT INTO nwi_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kɨni Yesu rɨvən ye nəkwai Nimə Ehuə kape Kughen maməvhag kɨmi narmamə. Kɨni jif pris mɨnə mɨne nəmehuə kape kwənərəus kape Isrel mɨnə, khauə mɨsəm In. Masaiyoh In mhamə, “?Nakamhawor narɨmnar mɨnə e? ?Pa nhagɨn rɨmɨvəhsi-pre nehuəyen mə takor narɨmnar məknekɨn?” ");
INSERT INTO nwi_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Kɨni Yesu rɨni-pən tuk əriə mə, “Rhuvə. Jakaiyoh kɨn naiyohyen kɨrik kɨmi əmiə. Tukmə nakhani atuatuk, jakni-pre tuk əmiə mə Pa nhagɨn rɨmɨvəhsi-pə nehuəyen kɨmi Yo tuk norien narɨmnar. ");
INSERT INTO nwi_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Hanipə-ru tuk Yo mə ?Pa rɨmɨvəhsi-pən nehuəyen kɨmi Jon mə tukror baptaes ye narmamə? ?Kughen uə yermamə?” Kɨni kɨnasəsiwən-əsiwən kɨmi əriə mɨnə mhamə, “?Tukshaw ni e? Tukmə kɨtawə khani mə, ‘Kughen rɨmɨvəhsi-pən nehuəyen kɨmi Jon,’ mərɨg Yesu tukrɨmə, ‘?Tukmə Kughen rɨmɨvəhsi-pən nehuəyen kɨmin, rhawor e kɨmiə nakhapəh nhaniyen nəfrakɨsien iran?’ ");
INSERT INTO nwi_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mərɨg to khapəh mɨn nhaniyen mhamə, ‘Yermamə əmə rɨmɨvəhsi-pən nehuəyen kɨmin,’ meinai kɨtawə khagɨn kɨn narmamə mɨnə e meinai iriə kamhani mə Jon in profet əfrakɨs.” ");
INSERT INTO nwi_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ror pən iriə kɨmnhani-pən tuk Yesu mhamə, “Yakseinein.” Kɨni Yesu rɨni-pən tuk əriə mɨmə, “Ǝhə. Mərɨg Yo mɨn to yakpəh nɨni-pre-yen mə Pa nhagɨn rɨmɨvəhsi-pə nehuəyen kɨmi Yo mə jakor narɨmnar.” ");
INSERT INTO nwi_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kɨni Yesu rɨmɨni-pən mɨn nuhpɨkɨnien tuk əriə mɨmə, “Kwən kɨrik, tɨni yerman kɨraru. Kɨni rɨvən mɨni-pən tuk irehuə mɨmə, ‘Narɨk, yuvən məsim ye plantesen kape grep.’ ");
INSERT INTO nwi_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mərɨg rɨmə, ‘Ah. Yakapəh.’ Kɨni marə, marar mɨn ye nərɨgien kafan mɨvən məsim. ");
INSERT INTO nwi_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kɨni tatə kapəriu rɨmavən məm yame rəkəskəh, mɨni-pən mɨn əmə nar kɨrikianə. Kɨni rɨmə, ‘Rhuvə, pəh yakvən.’ Meikuə, məpəh.” ");
INSERT INTO nwi_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kɨni Yesu raiyoh əriə mɨmə, “?Kwərə mir a, pa nhagɨn rɨmnor nəkwai rɨmni?” Kɨni khamə, “Irehuə.” Kɨni Yesu rɨni-pən tuk əriə mɨmə, “Ratuatuk. Kɨni yakamni-pre əfrakɨs tuk əmiə mə nəmə has rəmhen kɨn narmamə yamə mɨne kasərer tuk mane kape takis, mɨne nɨpiraovɨn kape swatuk kɨmnhauə ye narmaruyen kape Kughen kwasɨg ikɨn kɨmiə. ");
INSERT INTO nwi_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Meinai Jon Baptaes rɨmauə tuk əmiə mə tukrhajoun swatuk kape norien atuatuk, kɨni mərɨg kɨmiə nɨmnhapəh nhaniyen nəfrakɨsien iran. Mərɨg yor təvhagə has mɨnə rəmhen kɨn narmamə yamə mɨne kasərer tuk mane kape takis, mɨne nɨpiraovɨn kape swatuk, iriə kɨmnhani nəfrakɨsien iran. Mərɨg kɨmiə naksəm pawk nar a, mhapəh nɨsararien ye nərɨgien kapəmiə mhapəh nhaniyen nəfrakɨsien iran.” ");
INSERT INTO nwi_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kɨni Yesu rɨmə, “Kɨni sərɨg mɨn ru nuhpɨkɨnien kɨrik. Yermamə kɨrik rɨmnəsim kɨn kafan plantesen kɨn grep, markoparɨn-pən. Kɨni mɨkɨr kwətəgtap kɨrik kape nəviəsɨs-pənien kwənkwai grep iran. Mə nehen tukraiyu, kɨvəh kor waen kɨn. Kɨni in mor nimə apomh kɨrik mə tukramərer ikɨn mamarha huvə tuk kafan plantesen. Kɨni in mərəhu plantesen ai ye kwermɨ narmamə tɨksɨn, tukhapɨk nəriə tɨksɨn, mhavəh-si-pən nan kɨrik rəmhen kɨn nərokien. Marə, mɨtərhav mɨn aikɨn mɨvən ye tanə pɨsɨn. ");
INSERT INTO nwi_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kɨni kwənkwai grep rɨmhiak, kɨni yemehuə kape plantesen rher-pən kɨn kafan tɨksɨn manaja mə tukhavən mɨsəm narmamə yamə mɨne kɨsəsim aikɨn mə tukhavəhsi-pən grep nan, rəmhen kɨn nərok kafan. ");
INSERT INTO nwi_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mərɨg iriə kɨsarar, mhauh kɨrik, mɨshopni kɨrik, mɨsarkwhopni kɨrik. ");
INSERT INTO nwi_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kɨni yamehuə ai rarə mher-pən mɨn kɨn kafan tɨksɨn narmamə kɨsapita yamə mɨnə apa kupan. Khavən, kɨni narmamə yame kasəsim kɨmɨsor rahas pən mɨn kɨmi əriə rəmhen kɨn yame kɨmɨsor kupan. ");
INSERT INTO nwi_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kɨsor məknaikɨn mamhavən, yamehuə kape plantesen rher-pən kɨn tɨni rɨvən tuk əriə. Ye nərɨgien kafan rɨmə, ‘Tukmə ror tuksəm kafak kwajikovə, kɨni tukhasiai.’ ");
INSERT INTO nwi_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mərɨg iriə kɨsəm khamə, ‘Kwajikovə atuatuk e kape yamehuə kape plantesen. Pəh kɨshopni pəh plantesen e tukror kapətawə kɨn.’ ");
INSERT INTO nwi_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Məknekɨn kharaptərəkɨn, mɨsarkwərhav kɨn ye plantesen mɨshopni.” ");
INSERT INTO nwi_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kɨni Yesu raiyoh narmamə yame kasətərɨg kɨn, mɨmə, “?Rɨkimiə raməsɨk mə nɨpɨg yemehuə kape plantesen tukruə, kɨni tukrhawor-pən iran mɨne narmamə yamə mɨne kɨmɨsəsim ye plantesen kafan?” ");
INSERT INTO nwi_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kɨni khani-pən tukun mhamə, “Tukroriah-oriah nəmə has mɨnə a, mhopni əriə. Kwasɨg ikɨn, tukreighaan pən kɨn kafan plantesen kɨmi narmamə pɨsɨn mɨnə. Kɨni ye nɨpɨg atuatuk yame grep tukrɨmhiak, iriə tukhavəhsi-pən kwənkwan kɨmin.” ");
INSERT INTO nwi_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kɨni Yesu rɨmə, “Tukmə ror kɨmiə nakhapəh nɨsəvhekɨn-hanə-yen nəgkiarien yame Nəkwəkwə kape Kughen rɨmɨni mɨmə, “‘Nai yame narmamə kape nɨvhirəkɨnien nimə kɨmnhavəh kɨni mɨnəsarakikɨn. Mərɨg nai ai rehuə, taktəkun ai Kughen rɨmnherɨg mɨn, mor səpag apomh kɨn. Nar e Kughen Yermaru rɨmnor. Rɨkitawə ragien pɨk tukun.’ ");
INSERT INTO nwi_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ror pən, yakamni-pre tuk əmiə mə tukvəh-si ta narmaruyen kape Kughen tuk əmiə, kɨvəhsi-pən kɨmi narmamə yamə mɨne kasor narmaruyen kape Kughen ramkuə kɨn kwənkwan. ");
INSERT INTO nwi_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tukmə yermamə kɨrik rɨrəh-pɨkɨn səpaag e, tukrowhan əgkap. Kɨni tukmə səpaag a ruh yermamə kɨrik, tukrhosɨs-hosɨs in.” ");
INSERT INTO nwi_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kɨni jif pris mɨnə mɨne Farisi mɨnə kɨmɨsərɨg nuhpɨkɨnien yamə mɨne Yesu rɨmɨni, kharkun mə In raməgkiar irəriə. ");
INSERT INTO nwi_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kɨni mɨsarha kɨn swatuk mə tukhavəhsi-pən Yesu ye kalabus. Mərɨg kɨmnhagɨn kɨn narmamə, meinai narmamə kamhani mhamə In profet kɨrik. ");
INSERT INTO nwi_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Kɨni Yesu rɨmɨni mɨn nuhpɨkɨnien tɨksɨn tuk əriə mɨmə, ");
INSERT INTO nwi_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Narmaruyen kape Kughen in rəmhen kɨn king kɨrik yame ramor apnəpeinə ye nəvɨgɨnien ehuə tuk narkurəkien kape tɨni. ");
INSERT INTO nwi_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kɨni mher-pən kɨn kafan yorwok mɨnə mə tukhavən mhavi-pə narmamə yame rɨmnokrən-ta kɨn əriə mə tukhauə tuk nəvɨgɨnien. Mərɨg iriə m-fam kɨmɨsəpəh-pən, mhamə to iriə khapəh nhavənien. ");
INSERT INTO nwi_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Kɨni rher-pən kɨn kafan yorwok tɨksɨn mɨn, mɨni-pən tuk əriə mə, ‘Havən mhani-pən tuk narmamə yamə mɨne yɨmnokrən ta kɨn əriə mə tukhauə mhamə yaknor apnəpeinə ye nəvɨgɨnien. Yɨmoh kafak kau yamə mɨne kɨsəsis-əsis huvə. Narɨmnar fam rɨnəmhen. Hauə ye nəvɨgɨnien kape narkurəkien.’ ");
INSERT INTO nwi_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Mərɨg khapəh nɨsərɨgien yor wok mɨnə a. Kɨrik ramvən ye kafan nəsimien; kɨrik ramvən ye kafan stoa. ");
INSERT INTO nwi_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kɨni tɨksɨn kharaptərəkɨn yorwok mɨnə a mɨsor ahas-pən irəriə, mɨshopni əriə. ");
INSERT INTO nwi_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kɨni king, niemha rhai pɨk. Kɨni rher-pən kɨn mobael kafan mɨnə khavən mɨshopni narmamə yamə mɨne kɨmɨshopni kafan yorwok mɨnə. Kɨni mhasiai-pən nap ye taon kapəriə. ");
INSERT INTO nwi_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Kɨni mɨni-pən tuk kafan yorwok mɨnə mə, ‘Kɨnor apnəpeinə ta ye nəvɨgɨnien kape narkurəkien. Mərɨg narmamə yame yɨmnokrən kɨn əriə, norien kapəriə rɨpəh nəmhenien mə tukhauə. ");
INSERT INTO nwi_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Havən apa ye swatuk mɨnə mhani-pən tuk narmamə apnapɨg mɨnə fam yamə mɨne nakasəm, mə tukhauə ye nəvɨgɨnien.’ ");
INSERT INTO nwi_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Kɨni yorwok mɨnə kɨmnhavən apa ye swatuk mɨnə, mɨsofugɨn narmamə mɨ-fam yamə mɨne kɨmɨsəm əriə, yamə mɨne khahuvə mɨne yamə mɨne kɨsaha, kɨni narmamə kɨmnhakuar aikɨn kaməvɨgɨn ikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Mərɨg nɨpɨg king rɨmauə məm narmamə, məm yermamə kɨrik aikɨn rɨpəh nɨvənien ye neipən kape lafet kape narkurəkien. ");
INSERT INTO nwi_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kɨni king rɨni-pən tukun mə, ‘Yo kɨrik, nɨmɨpəh nɨvəhsi-pənien neipən kape lafet kape narkurəkien. ?Rhawor e nakuə imə?’ Mərɨg kwən a reinein nhorpɨnien nəgkiarien kafan. ");
INSERT INTO nwi_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Kɨni king rɨni-pən tuk kafan narmamə mɨnə mə tuksərkɨs-ətərəkɨn kwermɨn mir mɨne nɨhun mir, kɨni mɨsarakikɨn-pən ye nəpɨgnəpien, ikɨn kamasək ikɨn, kaməkwəruə ikɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kɨni Yesu rɨrpɨn nəgkiarien mɨmə, “Ror məkneikɨn, narmamə khapsaah yame kɨmnokrən kɨn əriə, mərɨg kwatɨksɨn əmə yamə mɨne kɨmɨrpen əriə mə tukhauə imə.” ");
INSERT INTO nwi_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kɨni Farisi mɨnə kɨmnhatərhav mamharai mhun mə tuksor Yesu rɨni nəgkiarien kɨrik yame rɨpəh nəmhenien. ");
INSERT INTO nwi_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mɨsher-pən kɨn narmamə tɨksɨn kapəriə, mɨne nukwao kape King Herod, khauə mɨsəm Yesu. Mhani-pən tukun mhamə, “Yhajoun. Yakharkun mə Ik yermamə atuatuk. Nakpəh nɨgɨnien kɨn yermamə mə to rɨvi kafam nərɨgien, meinai rɨkim rapəh nəsɨkien mə yermamə kɨrik rehuə uə yermamə kɨrik reiwaiyu; mərɨg nakaməfrakɨs əmə. Kɨni nəwhagien kafam raməri-pən əmə norien yame Kughen rorkeikei. ");
INSERT INTO nwi_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kɨni yaksorkeikei mə jakharkun nərɨgien kafam mə, ?Ratuatuk ye loa kapətawə mə tukasərok-pən takis kɨmi Sisa, yamehuə kape Rom, uə nɨkam?” ");
INSERT INTO nwi_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Mərɨg Yesu rɨrkun mə kamhani nəgkiarien e, mhamə tuksor nar has kɨrik. Kɨni mɨni-pən tuk əriə mə, “!Ah! Kapəmiə nɨniyen in rhuvə mərɨg rɨkimiə rəmkɨmɨk. ?Nakshawor e mɨsarkut mə taksapita Yo? ");
INSERT INTO nwi_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Havən-ru mharəh mane yame rəmhen tuk nərokien takis.” Kɨni khavən, mhavəh sɨren, mhauə. ");
INSERT INTO nwi_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kɨni raiyoh-pən əriə mə, “?Nanmɨ pa e? ?Kɨni nhag pa e?” ");
INSERT INTO nwi_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Khamə, “Nanmɨ Sisa. Kɨni mɨne nhagɨn mɨn.” Məknekɨn Yesu rɨni-pən tuk əriə mə, “Nəmhen. Nar kape Sisa, havəhsi-pən kɨmi Sisa. Mərɨg nar kape Kughen, havəhsi-pən kɨmi Kughen.” ");
INSERT INTO nwi_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yesu rhorpɨn məkneikɨn nəgkiarien kapəriə, kɨsərɨg, kɨsakur pɨk kɨn. Məkneikɨn kɨsəta ye Yesu mamhavən. ");
INSERT INTO nwi_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ye nɨpɨg a, Sadusi mɨnə tɨksɨn khauə mɨsəm Yesu. Sadusi mɨnə ai khamə ta mə tukmə yermamə rɨmhə to rɨpəh nɨmragh-mɨnien ye rao ye neai. ");
INSERT INTO nwi_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Kɨni kɨsaiyoh pən Yesu mhamə, “Yhajoun. Moses rɨmɨrai ye Loa mɨmə, ‘Tukmə yerman rɨmhə-tan kɨn piraovɨn kafan, kɨni kapəriu kwajikovə rɨrkək, naoraih yerman ai tukraməkeikei mɨkɨr piraovɨn ai tukreimək.’ Ye nərɨgien a, iriu kɨrɨrkun nɨrəraptərəkɨnien nhag piauni yame rɨmhə. ");
INSERT INTO nwi_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tukmə narmamə seven, iriə piauriə mɨnə. Nɨmrɨn nupan ror mared, kɨni mɨpəh nɨrəhyen kafan kɨrik kwajikovə, mɨmhə. Kɨni yame rɨkwasɨg kɨn rɨkɨr pian a. ");
INSERT INTO nwi_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kɨni mɨmhə, mɨpəh nɨvəhyen tɨni. Kɨni naorahini yame ror kɨsisər kɨn ror əmə mɨn nar kɨrikianə kɨn, meriaji iriə fam a seven kɨmnhakɨr piraovɨn a, kɨni mhamhə fam, mhapəh nɨseiməkien. ");
INSERT INTO nwi_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kɨni en piraovɨn ai rɨmhə mɨn. ");
INSERT INTO nwi_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kɨni ye nɨpɨg kape narmamə tukhamragh mɨn iran, iriə ai seven iriə piauriə mɨnə, ?piraovɨn ai tukror piraovɨn kɨn kape pa nhagɨn?” ");
INSERT INTO nwi_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “Nakamhani-əro kɨn en meinai tukmə ror nakseinein nəgkiarien ye Nəkwəkwə kape Kughen, mɨseinein mɨn nɨrkunien kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tukmə narmamə yamə mɨne khamhə mamragh mɨn to khapəh nɨsorien mared. Norien kape mared rɨmnor infamien, rəmhen kɨn narəyen kape agelo mɨnə apa rao ye neai. ");
INSERT INTO nwi_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kɨni ye nɨkarɨn kape nɨmragh-mɨnien, tukmə ror nakhapəh nɨsəvheikɨnien nəgkiarien yame Kughen rɨmɨni mɨmə, ");
INSERT INTO nwi_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Yo Yo Kughen yame Ebraham, Aesak mɨne Jakob karhəgnəgɨn hanə Yo.’ !Kɨtawə kharkun mə irisɨr kɨrharə iriə Kughen meinai nar apnapɨg kwərhɨmhə ta tu mɨrhəkupən Moses, mərɨg Kughen ramni mə karhəgnəgɨn hanə In. !Kɨni pa rɨmə narmamə mhə mɨnə kasəgnəgɨn Kughen, mərɨg narmamə yamə mɨne kamhamragh!” ");
INSERT INTO nwi_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nɨpɨg narmamə mɨnə a kɨmɨsərɨg nəgkiarien kafan, kɨsakur pɨk kɨn nhajounien kafan. ");
INSERT INTO nwi_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farisi mɨnə kɨmɨsəm mə Yesu rɨmɨvəhsi-əhu Sadusi mɨnə ye kafan nəgkiarien, khauə kɨrikianə mharai mhun mə tuksaiyoh-pən Yesu kɨn naiyohyen əutən kɨrik. ");
INSERT INTO nwi_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kɨni iriə kɨrik, yame in yhajoun kape loa rɨni-pən nəgkiarien kɨrik kɨmi Yesu mə tukrəm-ru mə Yesu tukror nar kɨrik yame rɨpəh nəmhenien. Kɨni mɨmə, ");
INSERT INTO nwi_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Yhajoun. ?Naha loa in rehuə pɨk rapita tɨksɨn, kɨni mɨhuvə pɨk tuk nəri-pənien?” ");
INSERT INTO nwi_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Kɨni Yesu rɨmə, “Loa yame rehuə pɨk rapita tɨksɨn in e ramni məknekɨn, ‘Taksəkeikei mɨsorkeikei pɨk Kughen ai In Yermaru kapəmiə ye rɨkimiə fam, mɨne ye narəyen fam kapəmiə, mɨne ye nərɨgien fam kapəmiə.’ ");
INSERT INTO nwi_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","In e loa yame rəkupən kɨni in yerpɨrɨg. ");
INSERT INTO nwi_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Loa yame ror kɨraru kɨn, ipakə əmə kwəm nəmhen. In e ramni mə ‘Taksorkeikei narmamə yamə mɨne kasarə ipakə tuk əmiə mɨsor huvə pən tuk əriə, rəmhen kɨn yame kɨmiə naksorkeikei atuk əmiə.’ ");
INSERT INTO nwi_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Loa mir e kawəpkəfugɨn nəgkiarien fam yame loa mɨne profet kamhani.” ");
INSERT INTO nwi_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kɨni nɨpɨg Farisi mɨnə kɨmɨsofugɨn əriə mɨnə, Yesu rɨmɨni-pən tuk əriə mɨmə, ");
INSERT INTO nwi_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“?Rhawor ye nərɨgien kapəmiə ye Kristo? ?Nakhamə In mɨkɨp pa?” Kɨni khamə, “In mɨkɨp King Deved.” ");
INSERT INTO nwi_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Kɨni rɨni-pən tuk əriə mɨmə, “?Tukmə ror məkneikɨn, rhawor e Nanmɨn Imərhakə rɨmɨvəhsi-pən nɨrkunien kɨmi Deved mə tukrokrən kɨn Kristo mə ‘Yermaru’? Yakamaiyoh məkneikɨn meinai Deved rɨmə, ");
INSERT INTO nwi_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘Kughen Yermaru rɨmɨni-pən tuk Yermaru kafak mɨmə, “Ǝkwətə ye kwermɨk matuk Meriaji nɨpɨg jakor ik takehuə ye tɨkmɨr kafam mɨnə.” ’ ");
INSERT INTO nwi_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","?Tukmə Deved rɨmnokrən kɨn Kristo mə ‘Yermaru,’ rhawor e kamni kɨmə Kristo in mɨkɨp King Deved?” ");
INSERT INTO nwi_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kɨni yermamə kɨrik rɨrkək yame to rhorpɨn nəgkiarien kape Yesu. Kɨni rɨrikakun ye nɨpɨg a mamvən, kɨmnhagɨn kɨn naiyoh-mɨn-ien kɨn nəgkiarien skai kɨrik kɨmin. ");
INSERT INTO nwi_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kɨni Yesu rɨmɨni-pən tuk nukwhao ehuə mɨne kafan narmamə mɨnə mə, ");
INSERT INTO nwi_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Nəmhajoun kape loa mɨnə mɨne Farisi mɨnə kamhavəh nehuəyen mə tukhani-ərhav Loa kape Moses kɨmi əmiə. ");
INSERT INTO nwi_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ror pən, takasəkeikei mɨsəri-pən, mɨsor narɨmnar fam yame kamhani-pre tuk əmiə. Mərɨg norien kapəmiə tukrɨpəh nəmhenien kɨn norien kapəriə. Meinai iriə khapəh nɨsorien naha nhagɨn yame iriə kamhani. ");
INSERT INTO nwi_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Iriə kasəkeikei kɨmi narmamə mhamə tuksəri-pən loa yame in rəmhen kɨn kajipə pam, mərɨg to khapəh nhavəhsi-pənien kwermɨriə mə tuksasitu irəriə. ");
INSERT INTO nwi_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Narɨmnar fam yame kasor, iriə kasor əmə mə narmamə tuksəm. Neipən yame narmamə kamhavən iran yame ramhajoun-pən mə kamhasiai Kughen, rəmhen kɨn kwaji bokis yame kɨvai-pən nəkwəkwə iran, mɨne nərəus yame raməker-pən ye neipən, Farisi mɨnə mɨne nəmhajoun kape loa mɨnə kamhavəh narɨmnar mɨnə e yame rehuə mapomh. ");
INSERT INTO nwi_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kɨni tukmə khavən ye nimə kape nofugɨnien, mɨsorkeikei mə tukasəkwətə əkupən. Kɨni tukmə khavən ye lafet, mɨsorkeikei mə tuksəkwətə ye kwənmhaan kape nɨsiaiyen. ");
INSERT INTO nwi_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kɨni tukmə khavən apa ye maket, mɨsorkeikei pɨk mə narmamə mɨnə fam tukhani vi vi əriə mɨsokrən kɨn əriə mə, ‘Yemehuə.’ ");
INSERT INTO nwi_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Mərɨg kɨmiə takhapəh nɨsorien mə narmamə tuksokrən kɨn əmiə mə ‘Yemehuə.’ Meinai kapəmiə yermaru kɨrikianə əmə. Kɨmiə m-fam piaumiə mɨnə mɨne kaka mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kɨni hapəh nɨsokrənien kɨn yermamə kɨrik ye tokrei tanə e mə ‘Tatə.’ Meinai kapəmiə tatə kɨrikianə əmə. In apa ye rao ye neai. ");
INSERT INTO nwi_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kɨni hapəh nɨseighanien kɨn narmamə mə tuksokrən kɨn əmiə mə ‘Yhajoun.’ Meinai kapəmiə yhajoun kɨrikianə əmə. In e Kristo. ");
INSERT INTO nwi_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yermamə irəmiə yame in yerpɨrɨg, in yorwok kapəmiə. ");
INSERT INTO nwi_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Meinai yermamə yame ravəh-si haktə atuk in, Kughen tukrɨvəh-si əhu in; kɨni yermamə yame ravəhsi-əhu atuk in, Kughen tukrɨvəh-si haktə. ");
INSERT INTO nwi_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Man, nəmhajoun mɨnə kape loa, mɨne Farisi mɨnə. Nəmhəyen ehuə tukruə tuk əmiə. Kapəmiə nɨniyen in rhuvə, mərɨg rɨkimiə rəmkɨmɨk. Nakasətapɨg kɨn swatuk tuk narmamə tuk nhavənien ye narmaruyen kape Kughen. Mɨne kɨmiə mɨn to nakhapəh nhavənien. Mhapəh nɨseighanien kɨn narmamə mə tukhavən aikɨn, nar apnapɨg mə kɨsorkeikei mə tukhavən. ");
INSERT INTO nwi_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Man, nəmhajoun mɨnə kape loa, mɨne Farisi mɨnə. Nəmhəyen ehuə tukruə tuk əmiə. Kapəmiə nɨniyen in rhuvə, mərɨg rɨkimiə rəmkɨmɨk. Tukmə piahwaru yame kɨmnamhə-tan kɨn, kɨni naksəkrəh kɨn kafan nautə. Kɨni masəhuak apomh mɨn mə narmamə tukhasiai əmiə. Nəmhəyen kapəmiə tukrɨskai rapita. ");
INSERT INTO nwi_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Man, nəmhajoun mɨnə kape loa, mɨne Farisi mɨnə. Nəmhəyen ehuə tukruə tuk əmiə. Kapəmiə nɨniyen in rhuvə, mərɨg rɨkimiə rəmkɨmɨk. Rɨkimiə ramagien əmə mə takhavirə ye rao mhavən isok, uə mə taksəriwək əmə mhavən ye tanə pɨsɨn pɨsɨn mɨnə mə takhavi-pə yermamə kɨrikianə əmə ye nəhuakien kapəmiə. Mərɨg nɨpɨg yermamə kɨrik rɨvəh norien mɨnə a kapəmiə, in tukruə yemə has rapita əmiə. Kɨni nɨmɨsor mə in tukraməkeikei mɨvəh narpɨnien kape nap ehuə rapita əmiə. ");
INSERT INTO nwi_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“!Man! Nəmhəyen ehuə tukruə tuk əmiə yamə mɨne nakamhakɨr narmamə mərɨg nɨmrɨmiə rɨpɨs. Kɨmiə nakamhani mhamə, ‘Tukmə yermamə kɨrik rɨvəh kwəsu ye nhag Nimə Ehuə kape Kughen mə tukror kafan nəgkiarien rɨpam, kɨni marar mɨpəh norien nəgkiarien yame ruɨni ta, in nar apnapɨg əmə.’ Mərɨg nakhamə, ‘Tukmə yermamə kɨrik rɨvəh kwəsu ye mane yame kɨvəhsi-pən ye Nimə Ehuə kape Kughen, kɨni in tukraməkeikei mor naha nhagɨn yame rɨmɨni.’ ");
INSERT INTO nwi_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","!Kɨmiə naksətəwao, nɨmrɨmiə rɨpɨs! Takasəkeikei mharkun mə Nimə Ehuə kape Kughen in yerpɨrɨg rapita mane yame kɨvəhsi-pən ikɨn, meinai Nimə e in ramor mane ramərhakə. ");
INSERT INTO nwi_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nakamhani mɨn mhamə ‘Tukmə yermamə kɨrik rɨvəh kwəsu ye nhag tebol ye Nimə Ehuə kape Kughen, in nar apnapɨg əmə. Mərɨg tukmə ravəh kwəsu ye sakrefaes yame ramswin-pən iran, kɨni in tukraməkeikei mor naha nhagɨn yame rɨmɨni.’ ");
INSERT INTO nwi_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","!Kɨmiə nɨmrɨn pɨs mɨnə! Takasəkeikei mharkun mə tebol in yerpɨrɨg rapita sakrefaes, meinai tebol ramor sakrefaes ramərhakə. ");
INSERT INTO nwi_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ror məkneikɨn, yermamə yame ravəh kwəsu ye nhag tebol kape Nimə Ehuə kape Kughen, ravəh kwəsu əfrakɨs ye tebol mɨne narɨmnar fam yame ramswiin aikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kɨni yermamə yame ravəh kwəsu ye nhag Nimə Ehuə kape Kughen, ravəh kwəsu əfrakɨs ye Nimə kape Kughen mɨne Yermamə yame ramarə aikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kɨni yermamə yame ravəh kwəsu ye nhag rao ye neai, ravəh kwəsu əfrakɨs ye nhag jea kape king, kɨni mɨvəh kwəsu ye nhag Yermamə yame ramkwətə aikɨn mamarmaru. ");
INSERT INTO nwi_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“!Man! Kɨmiə Farisi mɨnə mɨne nəmhajoun mɨnə kape loa. !Nəmhəyen ehuə tukruə tuk əmiə! Kapəmiə nɨniyen in rhuvə, mərɨg rɨkimiə rəmkɨmɨk. Kɨmiə nakasəri-pən huvə loa yamə mɨne khamar əmə tuk əmiə tuk nəri-pənien, rəmhen kɨn in e naksəri-pən loa yame ramni mə takasəkeikei mhavəh kwesrɨs mɨne onion ye nəsimien vi mhavəhsi-pən kɨmi Kughen. Mərɨg nakwəsəpəh Loa yamə mɨne kasəkupən. Iriə e: nakhapəh nɨsorien nar yame ratuatuk kɨmi narmamə, rɨkimiə rɨpəh nehuəyen tuk narmamə. Kɨni keinein nɨniyen nəfrakɨsien irəmiə. Rhuvə mə to nakpisəri-pən loa yamə mɨne kasəkupən, mɨpisəri-pən mɨn Loa mɨnə tɨksɨn. ");
INSERT INTO nwi_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kɨmiə nakamhakɨr narmamə, mərɨg nɨmrɨmiə rɨpɨs. Kɨmiə nakhavəh-si ta man-man ye nəmiə nəvɨgɨnien, tamə naksəmkɨmɨk ye nɨmrɨ Kughen; mərɨg naksətɨgai piəpiə nar yame rəmkɨmɨk, mɨsəmkɨmɨk ye nɨmrɨ Kughen. ");
INSERT INTO nwi_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“!Man! Kɨmiə Farisi mɨnə mɨne nəmhajoun mɨnə kape loa. !Nəmhəyen ehuə tukruə tuk əmiə! Kapəmiə nɨniyen in rhuvə, mərɨg rɨkimiə rəmkɨmɨk. Kɨmiə naksəmhen kɨn besin mɨne kap yame kamrai-ta nəmkəmɨkien e iruə mərɨg apa ye nəkwairiə kɨsəmkɨmɨk. Nəmkɨmɨkien rukwar irəmiə, meinai naksəptɨg kɨn nar, mɨsor əmə narɨmnar yame nɨpraimiə rorkeikei. ");
INSERT INTO nwi_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisi mɨnə, kɨmiə imrɨn pɨs mɨnə. Takasəkeikei mɨsaikwas yerkimiə, kɨni narɨmnar fam apa iruə tukshawən mɨn. ");
INSERT INTO nwi_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“!Man! Kɨmiə Farisi mɨnə mɨne nəmhajoun kape loa. !Nəmhəyen ehuə tukruə tuk əmiə! Kapəmiə nɨniyen in rhuvə, mərɨg rɨkimiə rəmkɨmɨk. Naksəmhen kɨn suranə ye yermamə yame kɨmoh kɨn pen hawən apa iruə, narmamə kɨsəm, khamə rhuvə. Mərɨg in apa imə, rukwar kɨn nɨkəkri narmamə yamə mɨne kwənhamhə, mɨne narɨmnar fam yame rəmkɨmɨk. ");
INSERT INTO nwi_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ye norien kɨrikianə əmə mɨn, apa iruə, narmamə kasəm norien kapəmiə, khamə rhuvə. Mərɨg yerkimiə, rukwar kɨn nahasien, meinai nakhapəh nɨsorien naha nhagɨn yame nakamhani, masor pɨk təvhagə has. ");
INSERT INTO nwi_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“!Man! Kɨmiə Farisi mɨnə mɨne nəmhajoun mɨnə kape loa. !Nəmhəyen ehuə tukruə tuk əmiə! Kapəmiə nɨniyen in rhuvə, mərɨg rɨkimiə rəmkɨmɨk. Kɨmiə nakhavhirəkɨn suranə kape profet kape Kughen mɨnə masor huvə pən marə marə ye təwk ye nəmə atuatuk mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kɨni mhani mhamə, ‘Tukmə yɨmnɨsarə ye nɨpɨg kape kaha mɨnə kapəmawə, to yakpihapəh nɨsasituyen ye kaha yamə mɨne kɨmɨshopni profet mɨnə.’ ");
INSERT INTO nwi_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Naksəgkiar məknakɨn, mamhani hah atuk əmə əmiə, mhani-ərhav mə kɨmɨə kwənərəus atuatuk mɨnə kape rɨpmiə kupan yamə mɨne kɨmɨshopni profet mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kɨni rhuvə əmə- kɨmiə takasəkeikei mɨsərkin təvhagə has yame rɨpɨmiə mɨnə kɨmnharikakun. ");
INSERT INTO nwi_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“!Kɨmiə snek mɨnə, mɨne nɨpnət snek mɨnə! ?Rɨkimiə ramuh mə ta mə to naksap ta kɨn narpɨnien ye nap ehuə uə? Nɨkam. ");
INSERT INTO nwi_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ror pən, yakamher-pre kɨn profet mɨnə, mɨne narmamə yamə mɨne kharkun nar, mɨne nəmhajoun mɨnə. Kɨni nakharuk haktə tɨksɨn ye nai kamarkwao kɨn mɨshopni əriə; naksarkɨs-arkɨs tɨksɨn mhauh əriə apa ye nimə kape nofugɨnien kapəmiə; kɨni masəko ta tɨksɨn mamharpəhu əriə mhavən apa ye taon mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ror pən, kɨmiə takhavəh narpɨnien kape narmamə yame kashopni narmamə m-fam yamə mɨne kɨsatuatuk; rɨrikakun ye Ebel yame in yemə atuatuk muə meriaji-pə Sekaraea ji Berekia, yame kaha kapəmiə mɨnə kɨmɨshopni in ye Nimə Ehuə kape Kughen ye kwenɨmrhei tebol mɨne kwənmhaan rhakə. ");
INSERT INTO nwi_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yakamni-pre əfrakɨs tuk əmiə mə narpɨnien mɨnə fam e tukruə tuk nəmə Isrel yame kɨsarə ai taktakun mɨne. ");
INSERT INTO nwi_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“!Aweh, nəmə Jerusalem, nəmə Jerusalem! Kɨmiə nakashopni profet mɨnə kape Kughen. Kɨni narmamə yamə mɨne Kughen rɨmnher-pre kɨn əriə tuk əmiə, nakasarkwhopni əriə kɨn kapier apɨg. Nɨpɨg rɨpsaah yakorkeikei mə jakəpkəfugɨn əmiə maməm əmiə rəmhen kɨn yame man ramauu tɨni mɨnə, mərɨg kɨmiə nakasəpəh. ");
INSERT INTO nwi_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Səm-ru. Kughen rɨmnəpəh əmiə; nahasien tukrɨrəh-pɨkɨn nimə kapəmiə; nar kɨrik rɨkək iran, ");
INSERT INTO nwi_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","meinai, yakamni-pre tuk əmiə mə to nakhapəh nɨsəm-mɨnien Yo mɨseriaji takhani mhamə, ‘Pəh kɨvəh-si haktə Kwən en ramuə ye nhag Yermaru.’” ");
INSERT INTO nwi_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kɨni ai, Yesu rɨmɨtərhav ye Nimə Ehuə kape Kughen, mameriwək mamvən, kɨni narmamə kafan kɨsəgkiar kɨn Nimə Ehuə kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kɨni Yesu rɨmɨni-pən tukun mɨmə, “Ǝmru. Nimə ehuə mɨnə e, tukohtəg-ətəg ta kapier iran, kɨpəh nɨpəhyen kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kɨni kwasɨg ikɨn, Yesu rɨmnəriwək iriə kafan narmamə mɨnə mhavən apa ye tukwas e Olif, mɨsəkwətə. Kɨni kafan narmamə pɨsɨn mɨnə əmə kɨmnhavən mɨsəm, mhani-pən tukun mhamə, “Takni-ru mə ?narɨmnar mɨnə e tukhauə ye naha nɨpɨg? ?Kɨni naha nɨmtətien yame tukror əpu mə Nɨpɨg Kwasɨg rɨnamuə ipakə?” ");
INSERT INTO nwi_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “Takasərɨg huvə, tamə yermamə kɨrik reikuə irəmiə. ");
INSERT INTO nwi_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Meinai narmamə khapsaah tukhavəh nhagɨk, kɨni mhauə mhani mə iriə e, Kristo. Tukseikuə ye narmamə khapsaah mhavi nərɨgien kapəriə. ");
INSERT INTO nwi_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kɨni nɨpɨg naksərɨg mə narmamə kamhauh əriə mɨnə, uə naksərɨg nəvsaoyen kɨn nuhyen əjir mɨnə, takhapəh nɨsakur-akurien, mhapəh nhagɨnien. Narɨmnar mɨne tukruə məkupən, mərɨg pəh nien mə Nɨpɨg Kwasɨg a. ");
INSERT INTO nwi_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kwənərəus kɨrik tukruh kwənərəus kɨrik. Kɨni narmamə ye tanə kɨrik tukhavən tanə pɨsɨn mhauh narmamə ikɨn. Kɨni nɨmnɨmien tukravən ye tanɨmtanə. Kɨni sweiwei tukruh narmamə. ");
INSERT INTO nwi_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mərɨg narɨmnar mɨnə e in nɨrikakunien əmə kape nɨpɨg əutən, rəmhen kɨn piraovɨn yame rɨnamərɨg nəmhəyen tuk neiməkien. ");
INSERT INTO nwi_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ye nɨpɨg a, tukseighan-pən kɨn əmiə kɨmi tɨkmɨr mɨnə, tuksor ahas-pre kɨmi əmiə. Mɨshopni əmiə. Kɨni nəmə kantri pɨsɨn pɨsɨn mɨnə tuksəməkɨn əmiə meinai nakamhavəh nhagɨk. ");
INSERT INTO nwi_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ye nɨpɨg mɨnə a, narmamə khapsaah tuksəpəh kapəriə nhatətəyen, mɨseighan-pən kɨn əriə mɨnə ye kwermɨ tɨkmɨr mɨnə kapəriə, kɨni masəməkɨn əriə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kɨni profet eikuə mɨnə tukhauə mɨseikuə ye narmamə khapsaah. ");
INSERT INTO nwi_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Meinai nahasien tukrehuə, ipakə narmamə mɨfam, norkeikeiyen kapəriə tukrɨrkək. ");
INSERT INTO nwi_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mərɨg yermamə yame ramərer tɨmtɨm meriaji Nɨpɨg Kwasɨg, Kughen tukrɨvəh mɨragh in. ");
INSERT INTO nwi_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kɨni Nəvsaoyen Huvə kape narmaruyen kape Kughen, tukni-ərhav ikɨn mɨnə fam ye tokrei tanə, mə kwənərəus mɨnə fam tukharkun nɨsərɨgien, kɨni ai, Nɨpɨg Kwasɨg ruə.” ");
INSERT INTO nwi_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","(Kɨni pəh narmamə tuksəvhuekɨn nəkwəkwə e mharkun). Yesu rɨni-pən tuk əriə mɨmə, “Kɨni nɨpɨg kɨmiə takhavən ye nəkwai Nimə Ehuə kape Kughen masəm nar a kamni kɨmə ‘Nar has yame roriah pɨk nar,’ yame profet Daniel rɨmɨni-ərhav, ");
INSERT INTO nwi_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","kɨmiə e Judia taksap mɨserkwaig ye tukwas. ");
INSERT INTO nwi_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tukmə yermamə ramapɨs iruə ye nimə kafan to rɨpəh nɨvənien imə tuk nɨpɨkien narɨmnar kafan, mərɨg pəh rap. ");
INSERT INTO nwi_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tukmə yermamə raməmɨr yerki nəsimien kafan, to rɨpəh nɨvənien yerkwanu tuk nɨvəhyen kafan neipən, mərɨg pəh rap. ");
INSERT INTO nwi_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","!Man! Rɨskai pɨk tuk nɨpiraovɨn yamə mɨne khasiai nar, kɨni mɨne yamə mɨne jiriə mɨnə kasəmaah hanə, meinai tuksərɨg rahas pɨk. ");
INSERT INTO nwi_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Taksəhuak tuk nahasien e mə tukrɨpəh nuəyen mɨrəh əmiə ye Sabat, uə ye nɨpɨg kape nokieiyen, ");
INSERT INTO nwi_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","meinai nahasien ehuə yame tukruə, yermamə rɨpəh nəm-hanəyen rɨrikakun ye nɨpɨg Kughen rɨmnərəhu nɨmoptanə meriaji-pə taktəkun mɨne. Kɨni nahasien kɨrik to rɨpəh nuə-mɨnien nɨpɨg kɨrik rəmhen kɨn nahasien a. ");
INSERT INTO nwi_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mərɨg Kughen tukrərai ta nɨpɨg kape nahasien a yame tukruə iran. Tamə, narmamə m-fam khamhə tukun. Mərɨg In rɨmnərai nɨpɨg a mə tukrɨvəh mɨragh narmamə yamə mɨne In rɨmɨrpen əriə mə kafan narmamə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Nɨpɨg a, tukmə kɨrik rɨmə, ‘Səmru. Kristo e,’ uə yermamə kɨrik rɨmə, ‘Səmru, Kristo en,’ mərɨg kɨmiə to nakhapəh nhaniyen nəfrakɨsien iran. ");
INSERT INTO nwi_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Meinai profet eikuə mɨnə khapsaah tukhauə mhasɨgəvɨn Kristo mɨsor nɨmtətien mə tukseikuə ye narmamə. Kɨni mɨsarkut tuk nɨsəmien swatuk tuk nɨvi-tayen narmamə yamə mɨne Kughen rɨmɨrpen əriə. ");
INSERT INTO nwi_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Rɨkimiə tukraməkeikei maməsɨk huvə nəgkiarien yame yɨmɨni-ta tuk əmiə, kwasɨg ikɨn narɨmnar mɨnə e khauə mɨsor nəfrakɨsien kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ror pən, tukmə yermamə kɨrik rɨni-pre tuk əmiə mə, ‘Kristo apa ye tɨpəvsɨk,’ takhapəh nhavənien mə taksəm. Uə tukmə yermamə kɨrik rɨmə, ‘In apa ye nəkwai nimə,’ takhapəh nhaniyen nəfrakɨsien iran, ");
INSERT INTO nwi_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","meinai nɨpɨg Yo, Ji Yermamə, jakrerɨg-pə mɨn, jakuə aihuaa əmə, kɨni narmamə m-fam tuksəm Yo, rəmhen kɨn yame karuəruə ramaroapɨg pirə, narmamə fiak kɨsəm. ");
INSERT INTO nwi_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Rəmhen əmə mɨn kɨn nɨpɨg ligkai mɨnə kamhaivə yerpɨrɨg mɨseiwaiyu masərɨp tahik, nakharkun mə kəməəm mɨnə apaikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Kɨni nɨpɨg kape nahasien ruə mor infamien, ‘Mɨrh tukrɨpɨs, kɨni makuə to rapəh mɨn nəsiəyen; kɨni kəmhau mɨnə tuksəsaah, kɨni mɨne narɨmnar fam ye nɨmago-ago tukhakiu-kiu.’ ");
INSERT INTO nwi_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kwasɨg ikɨn, Yo, Ji Yermamə, jaktərhav-pə ye napuə. Kɨni kwənərəus mɨnə fam ye tanɨmtanə tuksəm tuksasək. Kɨni narmamə tuksəm Yo, Ji Yermamə, jaksɨ-pən ye napuə mɨvəh nehuəyen mɨne nɨkhakien. ");
INSERT INTO nwi_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kɨni ai, tukher naiyuk, kher-pən kɨn agelo kafak mɨnə mə tukhavən mɨsarkurao ye tanɨmtanə, mɨne ikɨn pukaa ye neai mɨsofugɨn narmamə yamə mɨne yɨmɨrpen-ta əriə. ");
INSERT INTO nwi_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Sərɨg mɨn nuhpɨkɨnien kɨn nai e kamni kɨmə figtri. Nakharkun mə nɨpɨg kape figtri rɨmnəpɨr-pɨr, mɨne nɨpɨg kape nəsimien kɨrauə kwis. ");
INSERT INTO nwi_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Rəmhen əmə kɨn yame tukmə nahasien ramuə, takharkun mə Yo Ji Yermamə, yaknamuə ipakə, mɨnamərer ipakə əmə tuk kwəruə ye nimə kapəmiə. ");
INSERT INTO nwi_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","“Yakamni əfrakɨs tuk əmiə mə narmamə yamə mɨne kamhamragh ai taktakun, to khapəh nhamhə-famien kwasɨg ikɨn narɨmnar mɨne e tukpihatərhav-pə. ");
INSERT INTO nwi_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Napuə mɨne nɨmoptanə tukawəkeikei mɨrarkək; mərɨg nəgkiarien kafak to rɨpəh nɨrkəkien tuk nɨpɨg kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Kɨni Yesu rɨmə, “Yermamə kɨrik rɨpəh nɨrkunien nɨpɨg uə aoa atuatuk kape narɨmnar mɨnə a. Agelo mɨnə apa ye neai kaseinein, kɨni Yo mɨn, Ji yermamə, yakeinein. Mərɨg Tatə Kughen əmə In rɨrkun nɨpɨg atuatuk a. ");
INSERT INTO nwi_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ye nɨpɨg yo Ji Yermamə jakuə iran, tukrəmhen kɨn nɨpɨg kape Noa kupan, yame narmamə khapəh nɨsor-apnəpənəyen iran. ");
INSERT INTO nwi_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ye nɨpɨg a, yapiwən rɨpəh hanə naiyuyen, narmamə kasəvɨgɨn, mamhanɨm, masor nəvɨgɨnien kape narkurəkien, in e narɨmnar fam yame kɨmɨsor ye nɨmraghien kapəriə, mɨseriaji-pə Noa rɨmavən ye nəkwai rao kafan, ");
INSERT INTO nwi_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","kɨni iriə kɨmɨseinein naha nhagɨn yame tukruə mɨseriaji-pən yapiwən rɨmnaiyu mɨpɨk əriə fam. In e tukror rəmhen əmə kɨn nɨpɨg yame Yo Ji Yermamə jakurə iran. ");
INSERT INTO nwi_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yermamə kɨraru ye nəsimien, kɨni jakvəh kɨrik, məpəh kɨrik. ");
INSERT INTO nwi_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Piraovɨn kɨraru kaokwətə kwis mawor nəvɨgɨnien, kɨni jakvəh kɨrik məpəh kɨrik. ");
INSERT INTO nwi_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Ror pən, takasəkeikei mɨsarha, meinai nakseinein naha nɨpɨg yame kapəmiə Yermaru tukruə iran. ");
INSERT INTO nwi_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mərɨg takasəkeikei mharkun nar e. Tukmə yemehuə kape nimə rɨrkun nɨpɨg atuatuk yenpɨg yame yəkrəh tukruə iran, kɨni tukraməkeikei mamarha huvə mə yəkrəh tukrɨpəh neikusien nimə mɨvən imə. ");
INSERT INTO nwi_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kɨni kɨmiə mɨn takasəkeikei masərer matuk meinai Yo, Ji Yermamə, jakuə ye nɨpɨg yame rɨkimiə tukrɨpəh nuhyen. ");
INSERT INTO nwi_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Rɨkimiə tukraməkeikei maməsɨk huvə norien kape manaja yame rɨrkun nar, yame ramraptərəkɨn wok kafan mɨpəh nəpəhyen. Yermaru kafan rɨmnərəhu mə tukror wok a mamehuə ye kafan yorwok mɨnə fam mɨvəhsi-pən nəriə nəvɨgɨnien ye nɨpɨg atuatuk. ");
INSERT INTO nwi_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kɨni tukmə yermaru ruə məm manaja kafan, maməm mə ramor huvə wok kafan, kɨni manaja a tukrarə ye nɨhuvəyen. ");
INSERT INTO nwi_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yakamni əfrakɨs mə yermaru a tukrərəhu in ramehuə ye narɨmnar fam kafan. ");
INSERT INTO nwi_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mərɨg tukmə manaja a in yemə has, kɨni rɨkin raməsɨk mə, ‘To kafak yermaru rɨpəh nurə-aihuaa-yen,’ ");
INSERT INTO nwi_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kɨni marar mamvən, mamuh yorwok mɨnə tɨksɨn, kɨni mɨvən maməvɨgɨn, mamnɨm iriə nəmə kɨsapɨs. ");
INSERT INTO nwi_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kɨni yermaru kape manaja a tukruə ye nɨpɨg mɨne aoa yame manaja rɨkin rɨpəh nəsɨkien mə kafan yermaru tukruə iran. ");
INSERT INTO nwi_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Yermaru a tukror narpɨnien ehuə kɨmi manaja a, marakikɨn-pən ikɨn kwənmhaan kape narmamə yamə mɨne kapəriə nɨniyen rhuvə mərɨg rɨkiriə rəmkɨmɨk. Ikɨn a, narmamə kɨsasək pɨk mɨsəkwəruə ikɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kɨni Yesu rɨni-pən tuk əriə mə, “Ye Nɨpɨg Kwasɨg, narmaruyen kape Kughen tukror məkneikɨn. Nɨpiraovɨn, iriə ten. Kamhatərhav yenpɨg, mhamə tukhavən ye narkurəkien kɨrik. Kɨni maseito kɨn kwən a yame rɨmnarkurək pə pə əmə tukruə mɨkɨr kafan piraovɨn mhavən ye nimə kamor lafet ikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nɨpiraovɨn mɨnə a, kɨrkɨrɨp irəriə kɨsarmar, kɨni kɨrkɨrɨp irəriə kharkun nar. ");
INSERT INTO nwi_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Iriə kɨrkɨrɨp yamə mɨne kɨsarmar, kɨmnhavəh kapəriə laet mɨnə, mərɨg khapəh nhavəhyen kerosin rəmhen tuk nɨvi-pənien ye laet. ");
INSERT INTO nwi_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mərɨg nɨpiraovɨn kɨrkɨrɨp yamə mɨne kharkun nar, kamhavəh kapəriə laet kɨni mhavəh mɨn kerosin rəmhen tuk nɨvi-pənien ye laet. ");
INSERT INTO nwi_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kɨni kwən a yame tukror mared rɨpəh nuə-aihuaayen. Kɨni napɨrien ravəh nɨpiraovɨn mɨnə a, kamhavi kəviəm, mɨsapɨr. ");
INSERT INTO nwi_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kɨni yenpɨg-əru, kwən kɨrik rokrən apomh mɨmə, ‘Kwən yame tukror mared rɨnamuə. !Hauə mɨsəm!’ ");
INSERT INTO nwi_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Kɨni nɨpiraovɨn iriə ten kɨmɨsarha, mhaukrakin laet kapəriə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mərɨg nipiraovɨn yamə mɨne kɨsarmar khani-pən tuk nɨpiraovɨn yamə mɨne kharkun nar mhamə, ‘!Awi! Havəhsi-pə kerosin rəmhen meinai kapəmawə kerosin ruɨrkək, kɨni laet mɨnə natukhapɨs.’ ");
INSERT INTO nwi_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Mərɨg nɨpiraovɨn yamə mɨne kharkun nar khani-pən tuk əriə mə, ‘Nɨkam. Kerosin e rɨpəh nəmhenien tuk ətawə m-fam. Mərɨg harerɨg mhavən mhavəh nɨmrɨ kapəmiə kerosin rəmhen apa ye stoa.’ ");
INSERT INTO nwi_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Mərɨg nɨpɨg nɨpiraovɨn yamə mɨne kɨsarmar kasəriwək, mhavən mə tukhavəh kerosin, kɨni kwən a yame tukror mared ruauə. Kɨni nɨpiraovɨn yamə mɨne kasərer matuk kɨmnhavən iriə min ye nəvɨgɨnien kape mared. Mhavən imə, kɨni kətapɨg. ");
INSERT INTO nwi_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Kwasɨg ikɨn, nɨpiraovɨn yamə mɨne kɨsarmar kɨmnharerɨg-pə, mhamə, ‘!Yemehuə! !Yemehuə! Ǝhitə, pəh yakhaurə imə.’ ");
INSERT INTO nwi_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Mərɨg kwən a yame tukror mared rɨni-pən tuk əriə mə, ‘Yakamni əfrakɨs mə yo yakeinein əmiə.’” ");
INSERT INTO nwi_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kɨni Yesu rɨni ta nuhpɨkɨnien, mɨni-pən tuk əriə mə, “Ror məkneikɨn, kɨmiə takasəkeikei mɨsərer matuk, meinai nakseinein nɨpɨg mɨne aoa yame kapəmiə Yermaru tukruə iran.” ");
INSERT INTO nwi_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kɨni Yesu rɨmɨni nuhpɨkɨnien kɨrik mɨn mɨmə, “Yakamni mɨn mə narmaruyen kape Kughen tukror məkneikɨn. Yemehuə kɨrik rɨmnor apnəpeinə mə tukrɨvən ye tanə pɨsɨn kɨrik isok. Kɨni mokrən kɨn kafan yorwok misɨr kɨrhuə. Kɨni rərəhu-pən mane ye kwermɨrisɨr mə tukrhor wok kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Mɨvəhsi-pən mane kɨmi ərisɨr rəmhen tuk nɨrkunien kapərisɨr. Mɨvəhsi-pən nɨtɨp kɨrkɨrɨp kɨmi yermamə kɨrik; kɨni mɨvəhsi-pən nɨtɨp kɨraru kɨmi yermamə kɨrik; kɨni mɨvəhsi-pən nɨtɨp kɨrikianə kɨmi kɨrik. Kɨni marar mɨtərhav mamvən ye kafan nəriwəkien. ");
INSERT INTO nwi_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kɨni yorwok yame rɨmɨvəh nɨtɨp kɨrkɨrɨp rɨmavən mor aihuaa əmə bisnes kɨn, kɨni mor win ye kɨrkɨrɨp mɨn. ");
INSERT INTO nwi_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kɨni ye norien kɨrikianə əmə mɨn, yorwok yame rɨmɨvəh nɨtɨp kɨraru rɨmavən mor bisnes kɨn mor win ye kɨraru mɨn. ");
INSERT INTO nwi_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mərɨg yorwok yame rɨmɨvəh nɨtɨp kɨrikianə in rɨmavən mɨkɨr nɨmoptanə mɨnɨm nɨtɨp kape yemehuə kafan. ");
INSERT INTO nwi_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Kɨni newk rɨpsaah ruə mɨvən. Yemehuə a kape yorwok mɨnə a rɨrerɨg-pə kɨni mokrən kɨn ərisɨr mə tukrəm-ru mə kɨmɨrhawor-pən ye kafan mane. ");
INSERT INTO nwi_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yorwok yame rɨmɨvəh nɨtɨp kɨrkɨrɨp rɨmavən mɨvəh nɨtɨp kɨrkɨrɨp mɨn yame rɨmnor win iran mɨmə, ‘Yemehuə. Apa kupan, nɨmɨvəhsi-pə nɨtɨp kɨrkɨrɨp, kɨni yɨmnor bisnes kɨn, mor win ye yame rəkwakw nɨtɨp kɨrkɨrɨp mɨn.’ ");
INSERT INTO nwi_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Kɨni yemehuə rɨni-pən tukun mə, ‘Nɨmnor huvə, kɨni ik yorwok huvə yame nakamraptərəkɨn huvə wok kafam kɨni mɨpəh nəpəhyen. Nɨmnor huvə məkna, ye narɨmnar tɨksɨn, kɨni jakərəhu ik nakehuə ye narɨmnar rɨpsaah. !Yuə imə pəh rɨkirau ragien!’ ");
INSERT INTO nwi_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Yorwok yame rɨmɨvəh nɨtɨp kɨraru ruə məm yemehuə kafan mɨni-pən tukun mɨmə, ‘Yemehuə. Apa kupan, nɨmɨvəhsi-pə nɨtɨp kɨraru, kɨni yɨmnor bisnes kɨn, mor win ye yame rəkwakw nɨtɨp kɨraru mɨn.’ ");
INSERT INTO nwi_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Kɨni yemehuə rɨni-pən tukun mɨmə, ‘Nɨmnor huvə, kɨni ik yorwok huvə yame nakamraptərəkɨn huvə wok kafam kɨni mɨpəh nəpəhyen. Nɨmnor huvə məkna, ye narɨmnar tɨksɨn, kɨni jakərəhu ik nakehuə ye narɨmnar rɨpsaah. !Yuə imə pəh rɨkirau ragien!’ ");
INSERT INTO nwi_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Mərɨg yorwok yame rɨmɨvəh nɨtɨp kɨrikianə ruə mɨni-pən tukun mə, ‘Yemehuə. Yakɨrkun mə kafam norien rəutən. Ik nakampɨk nəvɨgɨnien yame ik nɨmɨpəh nəsimien ikɨn, kɨni mampɨk kwənkwai nai yame ik nɨmɨpəh nəmənəyen ikɨn. Ror pən, yɨmɨgɨn kɨn ik, ");
INSERT INTO nwi_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","mamvən, mɨkɨr nɨmɨr merkwaig kɨn mane. Ǝm-ru, mane en kafam.’ ");
INSERT INTO nwi_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Kɨni yemehuə a rɨni-pən tukun mɨmə, ‘!Ik yorwok has kɨrik! Nakamarpah pɨk. Nakwɨrkun ta mə yakampɨk nəvɨgɨnien yame yɨmɨpəh nəsimien ikɨn, kɨni mampɨk kwənkwai nai yame yɨmɨpəh nəmənəyen ikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Rhuvə mə to nakpivəh kafak mane mɨvən mərəhu-pən ye bang, pəh nɨpɨg yame jakrerɨg iran, jakɨrkun nɨvəhyen kafak mane iriu yame rəkwakw.’ ");
INSERT INTO nwi_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Kɨni yemehuə rɨni-pən tuk kafan yorwok mɨnə tɨksɨn mɨmə, ‘Havəh-si ta mane tukun mɨvəhsi-pən kɨmi yorwok e yame rɨmɨvəh nɨtɨp ten, ");
INSERT INTO nwi_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","meinai yermamə yame ravəh nar kɨrik, tukpivəhsi-pən mɨn tɨksɨn kɨmin. Mərɨg yermamə yame kafan nar kɨrik rɨrkək, tukpivəh-si ta fam kafan narɨmnar mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kɨni arakikɨn-pən yorwok e yame ramarpah, meinein norien nar huvə kɨrik ye nəpɨgnəpien- ikɨn kamasək ikɨn, kaməkwəruə ikɨn.’” ");
INSERT INTO nwi_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kɨni Yesu rɨmɨni mɨmə, “Nɨpɨg Yo Ji Yermamə jakuə ye nɨkhakien mɨne nəsanɨnien kafak, kɨmawə agelo mɨnə fam, Yo King, jakwəkwətə ye kafak jea mamarmaru ye nəsanɨnien mɨne nɨkakien kafak. ");
INSERT INTO nwi_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Narmamə m-fam ye kantri mɨnə fam tuksofugɨn əriə mɨnə ye nɨmrɨk, kɨni jakor narɨmnar rəmhen kɨn yermamə yame ramarha tuk sipsip mɨnə, maməwhai sipsip mɨnə mɨne nəni mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Jakəwhai sipsip mɨnə tukhavən ye kwermɨk matuk; kɨni nəni mɨnə tukhavən ye kwermɨk mawor. ");
INSERT INTO nwi_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Kɨni Yo, King, jakni-pən tuk yamə mɨne kasərer ye kwermɨk matuk mə, ‘Hauə. Kɨmiə e yamə mɨne Rɨmɨk Kughen rɨmnautə-pre kɨn kafan nɨhuvəyen kɨmi əmiə. Hauə mhavəh naha nhagɨn yame Kughen rɨmnərəhu karɨn mə kapəmiə. Hauə mɨsarə əfrakɨs ye narmaruyen kafan yame rɨmnor əpnəpeinə iran mə kapəmiə kwasɨg ikɨn ror tokrei tanə. ");
INSERT INTO nwi_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Hauə mhavəh, meinai nɨpɨg yɨmnəmkərəv, nɨmnhavəhsi-pə nəvɨgɨnien; kɨni nɨpɨg yɨmnəkwakwə, nɨmnhavəhsi-pə nu; kɨni nɨpɨg yɨmaurə rəmhen kɨn yepsɨpɨs, nɨmnhakɨr Yo mhavən ye kapəmiə rukwanu; ");
INSERT INTO nwi_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","kɨni nɨpɨg kafak neipən rɨmɨkək, nɨmnhavəhsi-pə neipən kɨmi yo; kɨni nɨpɨg yɨmnamhə, nɨmɨsəm huvə Yo; kɨni nɨpɨg yɨmnamarə ye kalabus, nɨmnhauə mhavaag-pə kɨn Yo.’ ");
INSERT INTO nwi_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Kɨni nəmə atuatuk mɨnə tukhani-pə tuk Yo mhamə, ‘Yermaru. ?Naha nɨpɨg yɨmɨsəm Ik nɨmnəmkərəv, kɨni yaksəvɨgɨn Ik? ?Uə naha nɨpɨg nɨmnəkwakwə, yakhavəhsi-pre nu kɨmik? ");
INSERT INTO nwi_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","?Kɨni naha nɨpɨg yɨmɨsəm Ik yepsɨpɨs kɨni yakhakɨr ik mhavən yerkwanu? ?Uə naha nɨpɨg kafam neipən rɨmɨrkək kɨni yakhavəhsi-pre neipən kɨmik? ");
INSERT INTO nwi_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","?Kɨni naha nɨpɨg yɨmɨsəm nakamhə uə nɨmnamarə ye kalabus, kɨni yɨmnhaurə mhavaag-pre kɨn Ik?’ ");
INSERT INTO nwi_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Kɨni Yo, King, jakni-pən tuk əriə mə, ‘Yakamni əfrakɨs mə naha nhagɨn yame nɨmɨsor kɨmi piak kɨrik, nar apnapɨg mə in yermamə apnapɨg əmə, mərɨg nɨmɨsor kɨmi Yo.’ ");
INSERT INTO nwi_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Kɨni ai, jakni-pən tuk yamə mɨne kasərer ye kwermɨk mawor mə, ‘Havən isok tuk Yo. Kughen rɨnərəhu ta kapəmiə narpɨnien. Havən ye nap ehuə yame ramuək rerɨn, yame kɨmnor kape Setan mɨne yarmhə mɨnə kafan. ");
INSERT INTO nwi_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Havən isok meinai nɨpɨg yɨmnəmkərəv, nɨmnhapəh nhavəhsi-pəyen nəvɨgɨnien kɨmi Yo. Kɨni nɨpɨg yɨmnəkwakwə, nɨmnhapəh nhavəhsi-pəyen nu kɨmi Yo. ");
INSERT INTO nwi_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Kɨni nɨpɨg yɨmaurə rəmhen kɨn yepsɨpɨs, nɨmnhapəh nhakɨrien Yo mhavən yerkwanu. Kɨni nɨpɨg kafak neipən rɨkək, nɨmnhapəh nhavəhsi-pəyen neipən kɨmi Yo. Kɨni nɨpɨg yɨmnamhə, mɨne nɨpɨg yɨmnamarə ye kalabus, nɨmnhapəh nhaurəyen mhavaag-pə kɨn Yo.’ ");
INSERT INTO nwi_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Kɨni iriə mɨn tukhani-pə tuk Yo mhamə, ‘Yermaru. ?Naha nɨpɨg yɨmɨsəm Ik nɨmnəmkərəv iran, uə nɨmnəkwakwə iran, uə Ik nɨmauə yepsɨpɨs, uə kafam neipən rɨkək, uə nɨmnamhə, uə nɨmnɨmarə ye kalabus, kɨni yakhapəh nhaurəyen mhavaag-pre kɨn Ik?’ ");
INSERT INTO nwi_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Kɨni jakni-pən tuk əriə mə, ‘Yakamni əfrakɨs tuk əmiə mə tukmə nakhapəh nɨsasituyen ye piak kɨrik, nar apnapɨg mə in yermamə apnapɨg əmə, mərɨg nakhapəh nɨsasituyen irak.’ ");
INSERT INTO nwi_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Kɨni iriə tukhavən mhavəh narpɨnien yame infamien rɨkək. Mərɨg nəmə atuatuk tukhavəh nɨmraghien rerɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kɨni Yesu rəgkiar ta, mɨni-pən tuk kafan narmamə mɨnə mə, ");
INSERT INTO nwi_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nakharkun mə tuknahu ror nɨpɨg kape lafet kape Pasova. Kɨni tukeighan-pən kɨn Yo, Ji Yermamə, kəsɨk haktə Yo ye nai kamarkwao kɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kɨni jif pris mɨnə mɨne nəmehuə kape nəmə Isrel kɨmɨsofugɨn əriə mɨnə ye nimə kape hae pris, nhagɨn e Kaeafas. ");
INSERT INTO nwi_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Mamharai mhun mə tukharaptərəkɨn apɨs-apɨs Yesu mɨshopni. ");
INSERT INTO nwi_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mamhani mhamə, “Mərɨg to khapəh nɨsorien ye nɨpɨg kape nəvɨgɨnien ehuə, tamə narmamə khauh apnapɨg əmə əriə mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kɨni Yesu ramarə apa Betani, imei kwən kɨrik nhagɨn e Saemon, yame apa kupən rɨmɨvəh nɨmhəyen əutən ye tɨkin. ");
INSERT INTO nwi_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Kɨni Yesu raməvɨgɨn, məkneikɨn piraovɨn kɨrik ruə mɨvəh botel senta kɨrik kɨmnor kɨn kapier kɨrik nhagɨn e alabasta. Senta a, nɨmrɨn rhaktə pɨk. Kɨni in ruə mətəg-pən senta ye kapan kapə Yesu. ");
INSERT INTO nwi_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Mərɨg narmamə kafan mɨnə niemha rhai əriə khamə, “?Rhawor pian e ramoriah senta e? ");
INSERT INTO nwi_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Rhuvə pɨk mə to in ror salem kɨn; mɨrkun nɨvəhyen mane ehuə kɨn tuk nɨvəhsi-pənien kɨmi yavən has mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mərɨg Yesu ruɨrkun nərɨgien kapəriə, mɨmə, “!Ei! Hapəh pian en. ?Rhawor nakashek in? In ramor nar huvə kɨrik kɨmi Yo. ");
INSERT INTO nwi_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yavən has mɨnə tukasəmɨr kɨmiə miriə nɨpɨg fam. Mərɨg Yo jakpəh nəmɨrien kɨtawə-m kɨmiə nɨpɨg fam. ");
INSERT INTO nwi_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Piraovɨn e ravi-təgpən senta ye nɨprak mapnəpenə ye nɨprak mə tuknɨm Yo. ");
INSERT INTO nwi_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yakamni əfrakɨs tuk əmiə mə ikɨn pukaa ye tokrei tanə yame kamni-ərhav Nəgkiarien Huvə ikɨn, tukaməvsao mɨn kɨn norien kape pian e, pəh narmamə rɨkiriə tukraməsɨk in.” ");
INSERT INTO nwi_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kɨni Judas Iskariot, in yermamə kɨrik ye narmamə twelef kape Yesu, rɨvən məm jif pris mɨnə ");
INSERT INTO nwi_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","maiyoh əriə mɨmə, “?Takhavəhsi-pə naha nhagɨn kɨmi yo tukmə yakeighan-pre kɨn Yesu kɨmi əmiə?” Kɨni kɨshen-pən fiftin taosen vatu kɨmin. ");
INSERT INTO nwi_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kɨni rɨrikakun ye nɨpɨg a, Judas rɨmnamərɨg nɨpɨg yame tukreighaan-pən kɨn Yesu kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kɨni ye nɨrikakunien kape nɨpɨg kape lafet e kamni kɨmə Bred yame Yis Rɨrkək iran, kɨni narmamə kape Yesu kɨsaiyoh-pən In mhamə, “?Nakmə jakhaukaa mɨsor apnəpenə ye nəvɨgɨnien kape Pasova?” ");
INSERT INTO nwi_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kɨni Yesu rɨmɨni-pən tuk əriə mə, “Havən apa ye taon, kɨni masəm yermamə kɨrik mhani-pən tukun mhamə, ‘Yhajoun ramni mə nɨpɨg yame Kughen rɨmɨrpen ta mə kafan, ruauə ipakə. Kɨni tukror nəvɨgɨnien kape Pasova iriə kafan narmamə mɨnə ye kafam nimə.’” ");
INSERT INTO nwi_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kɨni narmamə kape Yesu mɨnə khatərhav, mɨsor naha nhagɨn yame Yesu rɨmɨni mə tuksor tuk nor-əpnəpənəyen ye nəvɨgɨnien kape Pasova. ");
INSERT INTO nwi_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Yenpɨg, Yesu ruə iriə narmamə twelef kafan mɨsofugɨn mɨsəvɨgɨn ye tebol. ");
INSERT INTO nwi_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kɨni Yesu rɨni-pən tuk əriə mə, “Yakamni əfrakɨs tuk əmiə mə kɨmiə kɨrik tukreighaan-pən kɨn Yo kɨmi tɨkmɨr mɨnə kafak.” ");
INSERT INTO nwi_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kɨni narmamə kafan mɨnə rɨkiriə reiwaiyu, kɨni iriə kɨrikianə kɨrikianə kɨsaiyoh-pən In mhamə, “?Yermaru, pa? Pəh nien mə yo.” ");
INSERT INTO nwi_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “Kɨmiə kɨrik yame yakaweires kwis bred ye supsup ye bol tukreighaan-pən kɨn Yo kɨmi kafak tɨkmɨr mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yo Ji Yermamə jakaməkeikei mɨmhə rəmhen kɨn yame Nəkwəkwə kape Kughen rɨmɨni kupən. !Kɨni mərɨg rahas pɨk tuk yermamə yame tukreighaan-pən kɨn Yo ye kwermɨriə! !Kwən a tukrɨvəh narpɨnien ehuə!” ");
INSERT INTO nwi_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kɨni Judas e yame natukreighan-pən kɨn Yesu ye kwermɨ kafan tɨkmɨr mɨnə rɨmnaiyoh mɨmə, “?Pa ai? ?Yo?” Mərɨg Yesu rɨni-pən tukun mɨmə, “Ǝwəh. Ik atuk nɨmɨni.” ");
INSERT INTO nwi_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kɨni kasəvɨgɨn hanə, Yesu rɨvəh bred məhuak mɨni vi vi Kughen tukun, makapɨr mɨvəhsi-pən kɨmi kafan narmamə mɨnə mɨmə, “Sən. In e nɨprak.” ");
INSERT INTO nwi_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kɨni mɨvəh kap waen mɨni vi vi Kughen tukun, mɨvəhsi-pən mɨn kɨmi əriə, kɨni mɨmə, “Kɨmiə m-fam hanɨm. ");
INSERT INTO nwi_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nɨtawɨk e. Ramor nərɨgien kape Kughen tuk nɨvəh-mɨraghien narmamə tuk nuəyen məmɨr-ərhav. Tukraiyu mɨrɨsɨn ta təvhagə has kape narmamə khapsaah. ");
INSERT INTO nwi_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yakamni-pre əfrakɨs tuk əmiə mɨmə to yakpəh nɨnɨm-mɨnien waen meriaji mɨnɨm mɨn waen ye narmaruyen kape Rɨmɨk.” ");
INSERT INTO nwi_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kɨni kɨmɨsəni nɨpei əhuak kɨrik, mhatərhav mhavən ye tukwas Olif. ");
INSERT INTO nwi_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kɨni Yesu rɨni-pən mɨn tuk əriə mə, “Tuk yenpɨg əmə e, taksəm naha nhagɨn yame tukor irak tukrɨtərhav-pə, nhatətəyen kapəmiə mɨfam tukrɨmɨr, meinai kɨmɨrai ye Nəkwəkwə kape Kughen kɨmə, “‘Jakuh yermamə yame ramarha huvə tuk sipsip mɨnə, kɨni sipsip kafan mɨnə tuksaiyu rik rik.’” ");
INSERT INTO nwi_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kɨni Yesu rɨrpɨn nəgkiarien mɨmə, “Mərɨg nɨpɨg jakɨmragh mɨn, jakəkupən kɨn əmiə mɨvən apa Galili.” ");
INSERT INTO nwi_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Mərɨg Pita rɨmɨni-pən tukun mɨmə, “Tukmə ror nhatətəyen kapəriə tɨksɨn tukrɨmɨr; mərɨg nhatətəyen kafak to rapəh nɨmɨrien.” ");
INSERT INTO nwi_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kɨni Yesu rɨni-pən tukun mɨmə, “Yakamni-pre əfrakɨs tuk ik mə man tukrɨpəh nəkakə-hanəyen, ik takni m-kɨsisər mə nakeinein Yo.” ");
INSERT INTO nwi_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Mərɨg Pita rarə mɨni-pən skai mɨn mɨmə, “!Nar apnapɨg tukmə khamə tukshopni ərau mik, to yakpəh nɨniyen mə yakeinein Ik!” Kɨni iriə fam khani əmə mɨn nəgkiarien ai. ");
INSERT INTO nwi_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kɨni ai Yesu mɨne kafan narmamə mɨnə khavən yerkwanu kɨrik, nhagɨn e Getsemane. Kɨni Yesu rɨni-pən tuk əriə mɨmə, “Kɨmiə taksəkwətə eikɨn e. Pəh yakvən aikɨn a maməhuak.” ");
INSERT INTO nwi_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kɨni In mɨkɨr Pita mɨne ji Sebedi mir, irisɨr min. Rɨkin rərhakɨs pɨk. ");
INSERT INTO nwi_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kɨni mɨni-pən tuk ərisɨr mɨmə, “Rɨkik rərhakɨs pɨk ipakə yakmhə. Takarhəmɨr eikɨn e, marharha-huvə kɨtawə-m kɨmiə.” ");
INSERT INTO nwi_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kɨni In rəriwək mɨvən kəskəh əmə mənɨmkur mənɨm-pən nɨmrɨn ye nɨmoptanə maməhuak. Maiyoh Kughen mɨmə, “!Aweh! Rɨmɨk, tukmə rɨkim ragien, vəhsi-ta nəmhəyen yamə mɨne tukpihauə. Mərɨg takpəh norien ye nərɨgien kafak; mor əmə ye kafam nərɨgien.” ");
INSERT INTO nwi_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kɨni ai, In rɨrerɨg-pən mɨn tuk ərisɨr, məm kwərhapɨr yeru. Kɨni rɨni-pən tuk Pita mə, “!Eh! ?Rhawor nakrhapɨr? ?To naksarha huvə kɨtawə-m kɨmiə kape nɨpɨg kwakwə uə? ");
INSERT INTO nwi_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kɨmiə takasərɨg əmiə. Takasəkeikei masəhuak mə nar kɨrik tukrɨpəh norien əmiə nakhamɨr. Rɨkimiə rəsanɨn mərɨg nɨpraimiə rəpou.” ");
INSERT INTO nwi_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kɨni ai In mɨrerɨg mɨn maməhuak yame ror kɨraru kɨn. Mɨmə, “Rɨmɨk, tukmə jakaməkeikei mɨvəh nəmhəyen yame tukruə, kɨni pəh ror nəkwam.” ");
INSERT INTO nwi_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kɨni ai mɨrerɨg-pən mɨn, məm irisɨr kwərhapɨr yeru mɨn, meinai napɨrien rɨmɨvəh nɨmrɨrisɨr. ");
INSERT INTO nwi_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kɨni ai In rɨmnəpəh mɨn ərisɨr mɨvən maməhuak yame ror kɨsisər kɨn mamni nəgkiarien yame rɨmɨni ta. ");
INSERT INTO nwi_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Marə muə mɨn tuk kafan narmamə mɨnə mɨmə, “?Rhawor? ?Nakarhapɨr hanə? !Nəmhen! Nɨpɨg ruauə pakə ta yame yermamə tukreighaan-pən kɨn Yo, Ji Yermamə, jakvən ye kwermɨ narmamə hah mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Rhekɨmter, pəh kamhavən. !Yermamə yame tukreighaan-pən kɨn Yo ye kwermɨ tɨkmɨr mɨnə kafak ruauə ta ipakə!” ");
INSERT INTO nwi_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nɨpɨg Yesu raməgkiar hanə, məknekɨn Judas, yermamə kɨrik ye narmamə twelef kape Yesu rɨtɨrhav-pə. Nukwhao ehuə kamhakwasɨg kɨn. Mamhapɨk nau nisə mɨne kwətavhə kapəriə. Jif pris mɨnə mɨne nəmehuə mɨnə kape nəmə Isrel, kɨmɨsher-pən kɨn nukwhao a. ");
INSERT INTO nwi_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas ruɨni-pən ta tuk əriə mɨmə, “Yermamə yame jakəturəm-pən iran, yermamə e in en takharaptərəkɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas ruə məm Yesu mɨni-pən tukun mɨmə, “!Rhuvə, Yhajoun!” Məturəm-pən kɨmin. ");
INSERT INTO nwi_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kɨni Yesu rɨni-pən tukun mə, “Yo kɨrik, or nar yame nɨmauə mə takor.” Kɨni narmamə mɨnə a khauə mharaptərəkɨn Yesu. ");
INSERT INTO nwi_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kɨni yermamə kɨrik kape Yesu rɨvən mɨrəh nau nisə kafan, mowhan mərəru ta nɨmətərgɨ slef kɨrik kape hae pris. ");
INSERT INTO nwi_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kɨni Yesu rɨni-pən tukun mɨmə, “!Ah! Vai-pən kafam nau ye tamhekɨn, meinai narmamə yamə mɨne kasərai əjir kɨn nao, tukpiərəpni mɨn əriə kɨn nao. ");
INSERT INTO nwi_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Rɨkimiə raməsɨk mə yakɨrkun nokrənien kɨn Rɨmɨk, taktakun əmə tukrher-pə kɨn agelo mɨnə taosen taosen tukhauə mɨsasitu irak. ");
INSERT INTO nwi_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mərɨg to yapior məknakɨn, to nəgkiarien kape Kughen rɨpipəh nuəyen mor nəfrakɨsien kɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ye nɨpɨg a, Yesu rɨmɨni-pən tuk nukwhao mɨmə, “?Rhawor? ?Kɨmiə nakhamə ta Yo yermamə kape nəkrəhyen uə nhopniyen yermamə, nakamhapɨk nau nisə mɨne kwətavhə mamhauə mə takharaptərəkɨn Yo? Nɨpɨg fam kɨtawə-m kɨmiə kasəmɨr ye Nimə Ehuə kape Kughen, yakaməwhag. Mərɨg nakhapəh hanə nharaptərəkɨnien Yo. ");
INSERT INTO nwi_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mərɨg nəmhen. Naha nhagɨn yame Nəkwəkwə kape Kughen rɨmɨni tukraməkeikei muə mor nəfrakɨsien kɨn.” Kɨni kafan narmamə mɨnə kɨmɨsəpəh In mɨsap. ");
INSERT INTO nwi_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kɨni khakɨr Yesu mhauə kɨmi hae pris, nhagɨn e Kaeafas. Nəmhajoun kape loa kape Moses, mɨne nəmehuə mɨnə kape nəmə Isrel kwəsofugɨn ta əriə mɨnə aikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Kɨni Pita rɨkwasɨg kɨn əriə, mɨpəh nɨvən-pakəyen tuk Yesu. Nɨpɨg ruauə pakə tuk nimə kape hae pris, kɨni mɨvən mamkwətə iriə mobael mɨnə kape hae pris, mə tukrəm-ru mə tukhawor Yesu. ");
INSERT INTO nwi_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kɨni jif pris mɨnə mɨne narmamə kape kaonsel kasarha-kɨn narmamə tɨksɨn yame tukhauə mɨseikuə mamhani hah Yesu, ai khauh mɨshopni Yesu tukun. ");
INSERT INTO nwi_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nar apnapɨg narmamə khapsaah khauə mɨseikuə iran mamhani hah In, narmamə kape kaonsel khapəh nɨsəm-pəniən nar has kɨrik iran. Kasəgkiar mamhavən yermamə kɨraru kwhekɨmter, ");
INSERT INTO nwi_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","mɨrəni mɨrəmə, “Kwən e rɨmɨni mɨmə, ‘Yo jakəvitəg-ətəg Nimə ehuə kape Kughen; mərɨg kwasɨg ikɨn ye nɨpɨg kɨsisər, jakərɨp yame rɨvi.’” ");
INSERT INTO nwi_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kɨni ai, hae pris rərer mɨni-pən tuk Yesu mɨmə, “?Rhawor nakpəh nəgkiarien? ?Rhawor ye nəgkiarien mɨne kamhani-pre iram?” ");
INSERT INTO nwi_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mərɨg Yesu rərer əmə mapnapɨg. Kɨni hae pris rarar maiyoh mɨn mɨmə, “?Rhawor? Ik takaməkeikei mɨvəh kwəsu ye nhag Kughen yame ramragh, mɨni-pə tuk əmawə mə ?Ik e Kristo, ji Kughen uə nɨkam?” ");
INSERT INTO nwi_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Kɨni Yesu rɨmə, “Rəmhen əmə kɨn yame nakamni. Kɨni yakamni-pre tuk əmiə mə, tuk nɨpɨg kɨrik, takpisəm Yo, Ji Yermamə, jakəkwətə ye kwermɨ Kughen matuk yame nagheen rehuə. Kɨni takpisəm mɨn Yo jaksɨ faktə ye napuə meiwaiyu-pə.” ");
INSERT INTO nwi_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kɨni hae pris reikus neipən kafan meinai niemhaa rɨmnhai pɨk. Mɨmə, “!Raməgkiar məkneikɨn mamni hah Kughen! ?Rhawor e kɨtawə kasarha-kɨn hanə yermamə yame tukrɨni hah in? Nakwəsərɨg ta mə rɨmɨni hah Kughen. ");
INSERT INTO nwi_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","?Rɨkimiə ramhaw əsɨk? ?Tukshawor In?” Kɨni khamə, “In rɨmnor nar has kɨrik yame tukraməkeikei mɨmhə tukun.” ");
INSERT INTO nwi_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kɨni kɨsərɨg-əvhin nɨmrɨ Yesu, mɨsəsɨk In kɨn kwermɨriə, kɨni tɨksɨn kɨmɨsərɨp In. ");
INSERT INTO nwi_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Kɨni tɨksɨn kɨsərkɨs nɨmrɨn mɨsərɨp In mhamə, “!Eh! Kristo. Tukmə ik profet, ni-ru mə pa e ramuh Ik.” ");
INSERT INTO nwi_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kɨni Pita raməmɨr ipakə tuk nimə ehuə kape hae pris, kɨni piraovɨn kɨrik, yor wok kape hae pris, ruə mɨni-pən tukun mɨmə, “Eh, kɨmiru Yesu yemə Galili nɨmnawəriwək.” ");
INSERT INTO nwi_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mərɨg Pita rɨni-əhu ye nɨmrɨriə, mɨmə, “Nɨkam. Yo yakeinein əfrakɨs nar en nakamni.” ");
INSERT INTO nwi_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Mɨtərhav meiwaiyu mɨn maməmɨr ye kwəruə kape rukwanu ai. Kɨni piakəskəh pɨsɨn kɨrik ruə məm in. Mɨnamni-pən tuk narmamə mɨnə aikɨn mɨmə, “Kwən e, iriu Yesu yemə Nasaret kɨmnawəriək.” ");
INSERT INTO nwi_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mərɨg Pita rɨvəh kwəsu mə pian a rameikuə; kɨni mɨmə, “Yakeinein kwən a.” ");
INSERT INTO nwi_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kasəkwətə mamhavən, narmamə yamə mɨne kasəmɨr aikɨn khani-pən mɨn tuk Pita mhamə, “Nəfrakɨs, ik əfrakɨs kɨrik mɨn a. Nakəgkiar, yaksərɨg mə kɨmiru Yesu nɨmɨrasɨ-pən ye tamhekɨn kɨrikianə.” ");
INSERT INTO nwi_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kɨni Pita rɨmə “Yo yakeinein yermamə en yame nakamhani. To yakameikuə, Kughen tukror narpɨnien kɨmi yo.” Məknekɨn, man rəkakə. ");
INSERT INTO nwi_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kɨni Pita, rɨkin raiyu məsɨk nəgkiarien yame Yesu rɨmɨni mɨmə, “Man tukrɨpəh hanə nɨkakəyen, kɨni takni m-kɨsisər mə ik nakeinein Yo.” Kɨni rɨtərhav; rɨkin rərhakɨs mamasək. ");
INSERT INTO nwi_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yenpɨg-enpɨg əgkap, jif pris mɨnə fam mɨne nəmehuə kape nəmə Isrel kɨmnhauə kɨrikianə mhani kɨrikianə mə tukhopni Yesu. ");
INSERT INTO nwi_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kɨni mharkwəji In, mhakɨr mhavən kɨmi Paelat e, gavman kape Rom. ");
INSERT INTO nwi_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nɨpɨg Judas e yame rɨmneighan-pən kɨn Yesu kɨmi kafan tɨkmɨr mɨnə, rɨmnəm mə kɨmnhavi-ərhav Yesu mhamə tukrɨmhə, rɨkin rɨmhə pɨk tuk naha nhagɨn yame in atuk rɨmnor, kɨni mɨvəhsi-pən fiftin taosen vatu a rɨrerɨg-pən mɨn tuk jif pris mɨnə mɨne nəmehuə kape nəmə Isrel. ");
INSERT INTO nwi_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kɨni mɨmə, “Yɨmnor təvhagə has, meighan-pən kɨn kwən kɨrik yame rɨpəh norien nar has kɨrik kɨmi kafan tɨkmɨr mɨnə, mə tukshopni in.” Kɨni khamə, “Kafam atuk. Kapəmawə kɨrik nar kɨrik rɨkək.” ");
INSERT INTO nwi_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Məkneikɨn Judas raraka-pən kɨn mane ye Nimə Ehuə kape Kughen mɨtərhav. Mamvən, mɨjir-əpni atuk in. ");
INSERT INTO nwi_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kɨni jif pris mɨnə khapɨk mane mhamə, “Rapəh natuatukien ye loa kapətawə mə tuksərəhu-pən mane e iriə mane kape Nimə Ehuə kape Kughen, meinai kɨmɨvəh nɨmrɨ yermamə kɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kɨni kɨmnhani mhamə tukhavəh mane a mhavəh nɨmrɨ nɨmoptanə kɨrik apa “Kamor sospen ikɨn.” Nɨmoptanə a, kɨmɨnɨm yepsɨpɨs mɨnə aikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tuk nar e, ruə meriaji-pə ai taktakun, kamni kɨmə nɨmoptanə a, “Nɨtə rɨmnaiyu ikɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nar a rɨtərhav mor nəgkiarien kape Jeremaea ruauə mɨnor nəfrakɨsien kɨn yame rɨmɨni mə, “Nəmə Isrel khamə mane ye kwən a fiftin taosen vatu. Kɨni kɨmnhavəh mane a, ");
INSERT INTO nwi_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","mhavən, mhavəh nɨmrɨ nɨmoptanə e ‘Kamor sospen ikɨn.’ Kɨsor rəmhen kɨn yame Kughen rɨmɨni-pə tuk yo mə tuksor.” ");
INSERT INTO nwi_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kɨni Yesu rɨnamərer ye nɨmrɨ gavman kape Rom e Paelat. Kɨni Paelat raiyoh-pən In mɨmə, “?Ik king kape nəmə Isrel uə?” Kɨni Yesu rɨni-pən tukun mɨmə, “Rəmhen əmə kɨn yame ik nakamni.” ");
INSERT INTO nwi_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kɨni jif pris mɨnə mɨne nəmehuə mɨnə kape Isrel kɨmnhani hah In, mərɨg In rɨpəh nəgkiarien. ");
INSERT INTO nwi_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kɨni Paelat raiyoh mɨn In mə, “?Rhawor? ?Nakpəh nərɨgien əriə kamhani nəgkiarien rehuə iram uə?” ");
INSERT INTO nwi_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mərɨg Yesu rapnapɨg əmə, mɨpəh nhorpɨnien nəgkiarien yame kamhani. Kɨni Paelat rɨmnəm rakur. ");
INSERT INTO nwi_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ye newk mɨnə fam, nɨpɨg kape nəvɨgɨnien kape Pasova, nəmə Isrel kharkun nhaniyen nhag yermamə kɨrik kɨvəhsi-pən ta in ye kalabus, kɨni gavman tukraməkeikei mɨrɨsɨn in ramvən. ");
INSERT INTO nwi_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kɨni ye nɨpɨg a yemə has kɨrik ye kalabus, narmamə m-fam kharkun. Nhagɨn e Barabas. ");
INSERT INTO nwi_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kɨni kuwhen ai rofugɨn, kɨni Paelat raiyoh əriə mə, “?Nakhamə jakrɨsɨn pa nhagɨn rɨrerɨg-pre tuk əmiə? ?Barabas, uə Yesu yame kamni kɨmə Kristo?” ");
INSERT INTO nwi_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ramaiyoh məknaikɨn meinai in rɨmnəm ta mə jif pris mɨnə kɨmɨsərəhu-pən Yesu ye kwermɨn meinai kasəməkɨn Yesu tuk yamai mə narmamə m-fam kɨmɨsorkeikei In. ");
INSERT INTO nwi_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kɨni Paelat rəkwətə-pən ye jea kape nəkirien nəgkiarien, məkneikɨn kafan piahuaru rher-pən kɨn nəgkiarien kɨmin, mɨmə, “Kafam kɨrik nar kɨrik rɨkək takor ye kwən en. In yemə atuatuk. Yɨmnəm nəmrərhavyen kɨrik iran e taktakun, yakərɨg rahas pɨk tukun.” ");
INSERT INTO nwi_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mərɨg jif pris mɨnə mɨne nəmehuə kape Isrel kɨmnhani mhani-pən tuk kuwhen ai mhamə, “Taksaiyoh gavman mə tukrɨrɨsɨn Barabas, mhopni Yesu.” ");
INSERT INTO nwi_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kɨni Paelat raiyoh-pən əriə mə, “?Iriu pa nhagɨn jakrɨsɨn rɨrerɨg-pre tuk əmiə?” Khamə, “!Barabas!” ");
INSERT INTO nwi_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mərɨg Paelat rɨmə, “?Mərɨg jakhawor ye Yesu e kamni kɨmə Kristo?” Khamə, “!Ǝsɨk haktə ye nai kamarkwao kɨn!” ");
INSERT INTO nwi_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mərɨg Paelat raiyoh əriə mɨmə, “?Tuk naha? ?Rɨmnakapɨr naha loa?” Mərɨg kɨsokrən apomh pɨk mɨn mhamə, “!Ǝsɨk haktə ye nai kamarkwao kɨn!” ");
INSERT INTO nwi_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kɨni Paelat rəm mə to rɨpəh nɨni-əhuyen nəgkiarien kapəriə, kɨni iriə kɨnasərer matuk tuk nhauhyen əriə mɨnə. Məkneikɨn rɨvən mərav ye nɨmrɨ narmamə ror nɨmtətien mə kafan kɨrik nar kɨrik rɨkək. Kɨni mɨmə, “Tukmə nɨtawɨn raiyu, pəh nien mə yo yɨmnor. Raməmɨr irəmiə.” ");
INSERT INTO nwi_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kɨni narmamə mɨ-fam kɨmnhani mhamə, “Pəh nɨtawɨn tukraməmɨr irəmawə mɨne kapəmawə kwajikovə mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kɨni Paelat rɨrɨsɨn Barabas rɨrerɨg-pən tuk əriə. Kɨni mɨmə tukuh Yesu, kɨkɨr kavən, kəsɨk haktə ye nai kamarkwao kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kɨni mobael tɨksɨn kape gavman khakɨr Yesu mhavən ye nimə ehuə kape Paelat kɨni mɨsokrən kɨn nukwhao kape mobael mɨnə mə tukhauə. ");
INSERT INTO nwi_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kɨni khavəhsi-ta kafan neipən, mharəh kot kɨrik rəwhao, rəmhen kɨn kot kape yermaru, mɨsarkaoh-pən kɨn kɨmin. ");
INSERT INTO nwi_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kɨni mharəh nərəus kɨrik ror nirhɨn, mɨsor kəvəvhao kɨn, rəmhen kɨn kəvəvhao kape yermaru, mhaukrai-pən ye kapən kapə. Mhavəhsi-pən kaskɨn kɨrik ye kwermɨn matuk, mɨsənɨmkur ye nɨmrɨn mhamə kamhasiai In. Kɨni mɨsarh iakei iran mamhani mhamə, “Ik e yermaru kape nəmə Isrel. !Kɨmawə yakamhasiai Ik!” ");
INSERT INTO nwi_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kɨni masərɨg-əvhin, mharəh kaskɨn a mhauh kapən kapə kɨn mɨ-khapsaah. ");
INSERT INTO nwi_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kɨni mɨsarh iakei fam iran, mharəhsi-ta mɨn kot əwhao mhavəhsi-pən kafan neipən. Mhakɨr mhatərhav, mhavən mə tukharuk haktə ye nai kamarkwao kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nɨpɨg kamhauə ye swatuk, mɨsəm yemə Saerin kɨrik, nhagɨn e Saemon. Kɨni khani-əhu masəkeikei kɨmin mə tukrɨrəh nai kamarkwao kɨn kape Yesu. ");
INSERT INTO nwi_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kɨni iriə mhakɨr Yesu mhavən ikɨn kɨrik nhagɨn e Golgota (yame nɨpran rɨmə, kwənmhaan kape kerhə irə jir). ");
INSERT INTO nwi_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ikɨn aikɨn a, kɨmɨvəhsi-pən waen kɨmi Yesu ikɨn yame kɨmnəvɨt-pən nar əukəh kɨrik iran tuk nɨni-əhuyen nəməmhəyen. Mərɨg Yesu rɨnɨm əsɨgəvɨn əmə, mɨpəh nɨnɨmien. ");
INSERT INTO nwi_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kɨni kɨmnharuk haktə In ye nai kamarkwao kɨn. Kɨni mɨsəwhai kafan neipən masəukɨr tukun, mə tukmə yame rapita, kɨni in ravəh kafan. Nar e rɨtərhav-pə mor nəgkiarien kupan kape profet ruauə mɨnor nəfrakɨsien kɨn yame ramni mə, “Kɨmɨsəwhai neipən kafak mɨsarukɨn daes tukun.” ");
INSERT INTO nwi_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kɨni mɨsəkwətə aikɨn masarha tukun. ");
INSERT INTO nwi_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kɨni kɨrai-pən nəgkiarien kɨrik ye nai kɨrik ramni mə kɨmɨsəm-pən nar has kɨrik iran mɨmə, “In e Yesu, King kape nəmə Isrel.” Kɨni kɨsarkwətərəkɨn-pən a kapən kapə ikɨn yerpɨrɨg. ");
INSERT INTO nwi_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kɨni mharəh yeməkrəh mir kɨraru, mharuk haktə mɨn əriu irisɨr Yesu. Kɨrik ye matuk, kɨrik ye mawor. ");
INSERT INTO nwi_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kɨni narmamə yamə mɨne kasəriwək ye swatuk kɨsarha-pən mɨsəm, kɨsarh iakei iran. Kasəwhan-əwhan kapəriə kapə, ");
INSERT INTO nwi_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","mhamə, “!Eh! !Ik yermamə kape natmətəg-ətəgien Nimə Ehuə kape Kughen mɨne nor-mɨnien ye nɨpɨg kɨsisər əmə! Ɨntah. Tukmə Ik Ji Kughen əfrah, eiwaiyu-ru ye nai kamarkwao kɨn mɨvəh mɨragh atuk Ik.” ");
INSERT INTO nwi_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kɨni ye norien kɨrikianə əmə mɨn, jif pris mɨnə mɨne nəmhajoun mɨnə kape loa kasarh iakei mɨn iran. ");
INSERT INTO nwi_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Mamhani-pən tuk əriə mɨnə mhamə, “In rɨvəh mɨragh ta narmamə khapsaah. Mərɨg rɨpəh nəmhenien tuk nɨvəh-mɨragh-atuk-ien In. Rhuvə mə king kape nəmə Isrel tukreiwaiyu ye nai kamarkwao kɨn pəh kɨsəm, kɨni mhani nəfrakɨsien iran. ");
INSERT INTO nwi_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","In rhatətə ye Kughen. Tukmə Kughen rorkeikei, pəh rɨvəh-si ta In. Meinai In ramni mə In Ji Kughen.” ");
INSERT INTO nwi_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kɨni ye norien kɨrikianə əmə mɨn, yeməkrəh mir yame kɨmɨruk haktə ərisɨr Yesu kawarpakwə kɨmin. ");
INSERT INTO nwi_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yerkweiha əmə, mərɨg nəpɨgnəpien ruə muvrɨg əpɨs tanɨmtanə meriaji tri klok. ");
INSERT INTO nwi_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kɨni ye tri klok, Yesu rokrən apomh mɨmə, “Elae, Elae. ?Lama sabaktani?” Nɨpran rɨmə, “!Kughen kafak! !Kughen kafak! ?Rhawor nakamapitan kɨn Yo?” ");
INSERT INTO nwi_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kɨni narmamə tɨksɨn yamə mɨne kasərer aikɨn mɨsərɨg nəgkiarien ai mhamə, “Sərɨgru. In ramokrən kɨn Elaeja.” ");
INSERT INTO nwi_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Məkneikɨn, kwən kɨrik raiyu ətkin mɨvən mɨrəh nɨpar-par neipən meires ye waen əkwahir. Mərkɨs-pən ye nai apomh kɨrik kɨni mɨvəhsi-haktə pən kɨmi Yesu mə tukrɨnɨm. ");
INSERT INTO nwi_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kɨni narmamə mɨnə tɨksɨn khamə, “Apəh. Pəh kɨsəm ru mə to Elaeja ruə mɨvəh mɨragh in, uə?” ");
INSERT INTO nwi_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mərɨg Yesu rarar mokrən ehuə mɨn. Kɨni ai kafan neihagien rɨtərhav. ");
INSERT INTO nwi_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kafan neihagien rɨtərhav aikɨn, kɨni nəkwai Nimə Ehuə kape Kughen, kɨruk neipən kɨrik yame kɨmnətapɨg kɨn Kwənmhan yame Rəmrhakə Məmrhakə pɨk. Neipən a rəhipu nɨpərɨn kɨraru. Rəhipu apa yerpɨrɨg əgkəp meiwaiyu. Nɨmnɨmien ramavən, kɨni kapier mɨnə kɨsakapɨr-pɨr. ");
INSERT INTO nwi_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Kɨni suranə yamə mɨne kɨmnor ye nɨpəg kapier kɨmɨsakapɨr-pɨr mɨsəkwag; kɨni nɨprai nəmə atuatuk yamə mɨne kwənhamhə, khamragh mɨn. ");
INSERT INTO nwi_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kɨshaktə ye nəkwai nɨmɨr, kɨni kwasɨg ikɨn, nɨpɨg Yesu rɨmɨmragh mɨn ye nɨmhəyen kafan, iriə kɨmnhavən Jerusalem mhatərhav-pən tuk narmamə khapsaah. ");
INSERT INTO nwi_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kɨni yamehuə kape mobael iriə narmamə yamə mɨne kasərer masarha tuk Yesu, kɨmɨsəm nɨmnɨmien a ramavən, mɨne narɨmnar mɨnə a, kɨmnhagɨn pɨk, masokrən pɨk mhamə, “Nəfrakɨsien. Kwən e In Ji Kughen.” ");
INSERT INTO nwi_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kɨni nɨpiraovɨn khapsaah kasərer isok masəm. Apa kupan kɨmnhatərhav Galili mhakwasɨg kɨn Yesu mɨsasitu iran ye nar pɨsɨn pɨsɨn mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Iriə tɨksɨn, kɨrik e Meri pian Magdala, mɨne Meri mamə kape kwərə mir e Jemes mɨne Joses, mɨne mamə kape ji Sebedi mir. ");
INSERT INTO nwi_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ipakə mɨrh rivə, yemə Aramatia kɨrik rɨtərhav-pə. Nhagɨn e Josef. Kafan nautə rehuə. In yermamə kɨrik kape Yesu. ");
INSERT INTO nwi_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Rɨvən məm Paelat, kɨni maiyoh-pən mə tukreighaan kɨn nɨprai Yesu. Kɨni Paelat rɨmə tukrɨrəhsi-pən nɨprai Yesu kɨmin. ");
INSERT INTO nwi_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kɨni Josef rɨvən mɨrəh nɨprai Yesu, muvrɨg kɨn neipən hawən kɨrik nhagɨn e linen. ");
INSERT INTO nwi_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Kɨni mɨrəh mɨvən mərəhu-pən ye nəpag kapier kɨrik yame kɨmɨkɨr wi əmə kɨmə kafan. Kɨni məpər-pər pən kɨn kapier ehuə kɨrik mətapɨg kɨn nəpag kapier. Kɨni in mamvən. ");
INSERT INTO nwi_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ye nɨpɨg a, Meri, pian Magdala, mɨne nɨfnagni, iriu kaokwətə ipakə tuk nəpag kapier. ");
INSERT INTO nwi_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kəni rɨkwamer kɨn, ye Sabat, jif pris mɨnə mɨne Farisi mɨnə kɨmnhavən mɨsəm Paelat. ");
INSERT INTO nwi_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Mhamə, “Yemehuə. Rɨkimawə raməsɨk mə nɨpɨg kwən a, yermamə kape neikuəyen rɨmnamragh hanə, mɨmə, ‘Nɨpɨg kɨsisər tukruə mɨvən, jakɨmragh mɨn ye nɨmhəyen kafak.’ ");
INSERT INTO nwi_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ror pən, yaksaiyoh ik mə takher-pən kɨn kafam tɨksɨn mobael tukhavən masarha tuk nəpag kapier mɨseriaji-pən nɨpɨg kɨsisər ruauə mɨvən ta. Tamə, kafan narmamə mɨnə khauə mɨsəkrəh kɨn nɨpran, mhani-ərhav mhamə ruɨmragh mɨn ye nɨmhəyen kafan. Neikuəyen a tukrahas pɨk rapita fam nhajounien eikuə yame Yesu rɨnamor.” ");
INSERT INTO nwi_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kɨni Paelat rɨmə, “Hakɨr mobael mɨnə, mhavən mɨsor naha nhagɨn yame nakharkun mə taksor mɨsarha huvə tuk nəpag kapier.” ");
INSERT INTO nwi_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kɨni khavən mɨsor, masarha huvə tuk nəpag kapier. Mɨsor mak kɨn nehe kandel ye kapier mə tukmə kəsuə ta kɨn kapier, nehe kandel tukrakapɨr, kɨni mɨsətu mobael mɨnə tukun. ");
INSERT INTO nwi_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kɨni Sabat rɨnamor infamien. Kɨni Sande, yenpɨg-yenpɨg əgkap, Meri, pian Magdala, mɨne Meri, mama kape Jemes mɨne Joses, kravən apa ye nəpag kapier. ");
INSERT INTO nwi_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Məkneikɨn, nɨmnɨmien ehuə kɨrik ravən, meinai agelo kɨrik kape Kughen Yermaru rɨmasɨ faktə ye neiai mɨvən ye nəpag kapier, məsuə ta kɨn kapier mamkwətə aikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kafan neipən rhawən, nɨpran raməsiə rəmhen kɨn naroapɨgien. ");
INSERT INTO nwi_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mobael mɨnə kɨmɨsəm, khagɨn kɨn, mɨsətəmnɨmɨn. Mhamɨr masəmɨr rəmhen kɨn yermamə yame ruamhə. ");
INSERT INTO nwi_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kɨni agelo a rɨni-pən tuk nɨpiraovɨn mɨnə a mɨmə, “Takrapəh nɨragɨnien. Yakɨrkun mə nakawarhakɨn Yesu e, yame kɨmɨruk haktə In ye nai kamarkwao kɨn. ");
INSERT INTO nwi_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mərɨg In rɨrkək ikɨn e. Ruəmragh ta, rəmhen kɨn yame rɨmɨni. Rauə mɨwəm tamhekɨn e kɨmnərəhu ikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Takwhai mɨren əmə mɨravən mɨrani-ərhav-pən tuk narmamə kafan mɨnə mɨrəmə, ‘In ruɨmragh mɨn ye nɨmhəyen kafan, mɨnəkupən ta kɨn əmiə muavən apa Galili. Nakharkun nɨsəmien In aikɨn.’ Ɨnta, nəgkiarien en yakwəni-pre ta tuk əmiru.” ");
INSERT INTO nwi_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kɨni pia mir a kwaiyu pɨk mɨratərhav. Mragɨn pɨk, mərɨg rɨkiriu ragien. Mɨravən mə tukrəni-ərhav pən tuk narmamə kape Yesu mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kɨmɨravən hanə, məkneikɨn Yesu ruə məm əriu, mɨmə, “Rhuvə.” Kɨni kɨrauə tuk Yesu, mawəker-pən ye nɨhun, mawəgnəgɨn In. ");
INSERT INTO nwi_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kɨni Yesu rɨni-pən tuk əriu mɨmə, “Rapəh nɨragɨnien. Ravən, mɨrəni-pən tuk piak mɨnə mə tukhavən apa Galili mɨsəm Yo apaikɨn.” ");
INSERT INTO nwi_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nɨpɨg pia mir a kɨmɨrarerɨg mɨravən, mobael mɨnə a tɨksɨn khavən ye taon mhani-ərhav fam tuk jif pris mɨnə kɨn naha nhagɨn yame rɨmatərhav-pə. ");
INSERT INTO nwi_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kɨni jif pris kɨmnhauə mɨsəm nəmehuə mɨnə kape nəmə Isrel, mharai mhun mə tukshawor. Kɨni mhavəhsi-pən mane ehuə kɨmi mobael mɨnə ");
INSERT INTO nwi_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","mhani-pən tuk əriə mhamə, “Takhani-pən tuk narmamə mə, ‘Kafan narmamə mɨnə kɨmnhauə yenpɨg, nɨpɨg kɨmawə yɨmɨsapɨr, mɨsəkrəh kɨn nɨpran, mharəh mɨsap.’ ");
INSERT INTO nwi_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tukmə gavman rərɨg nəvsaoyen kɨn, kɨmawə jakhavən mɨsərəhu huvə kɨmawə min. Kɨmiə takhapəh nhavəhyen narpɨnien iran.” ");
INSERT INTO nwi_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ror pən, mobael mɨnə a kɨmnhavəh mane a, masor naha nhagɨn yame kɨmnhani. Kɨni nəmə Isrel kasərɨg nəvsaoyen eikuə a mɨseriaji-pə ai taktakun. ");
INSERT INTO nwi_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kɨni narmamə leven kape Yesu kɨmnhavən Galili, mhavən ye tukwas kɨrik yame Yesu rɨmɨni ta tuk əriə mə tukhavən ikɨn. ");
INSERT INTO nwi_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nɨpɨg kɨsəm In, kɨni kɨsəgnəgɨn In. Mərɨg tɨksɨn, kapəriə nərɨgien ror kɨraru. ");
INSERT INTO nwi_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kɨni Yesu ruə tuk əriə, mɨni-pən tuk əriə mə, “Kughen rɨmɨvəhsi-pə nehuəyen mɨnə fam kape narmaruyen ye rao ye neai mɨne ye tokrei tanə. ");
INSERT INTO nwi_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ror pən, yakamher-pre kɨn əmiə mə takhavən mhavi narmamə ye kantri mɨnə fam ye tokrei tanə mə tukhauə kafak narmamə, kɨni mɨsor baptaes irəriə ye nhag Tatə Kughen mɨnə Tɨni, mɨne Nanmɨn Imərhakə. ");
INSERT INTO nwi_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Kɨni mɨshajoun əriə mə tuksəri-pən fam nəgkiarien yame yɨmɨni-pre tuk əmiə. Kɨni nəfrakɨsien mə jakamarə kɨtawə-m kɨmiə ye nɨpɨg m-fam meriaji Nɨpɨg Kwasɨg.” ");
INSERT INTO nwi_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","In e Nəgkiarien Huvə kape Yesu Kristo, Ji Kughen. ");
INSERT INTO nwi_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Profet kupən kɨrik kape Kughen, nhagɨn e Aesea, rɨmnəvsao kɨn mɨni-ərhav mə, “Kughen rɨmə, “‘Yakamher-pre kɨn yermamə kɨrik tuk nəvsaoyen kɨn kafak nəgkiarien. In tukror apnəpenə ye swatuk kafam.’ ");
INSERT INTO nwi_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","‘Yermamə kɨrik ramok-rapomh ye tɨpəvsɨk, mamni mə, “Taksor apnəpenə ye swatuk kape Kughen, yame in Yermaru kapətawə.” ’” ");
INSERT INTO nwi_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kɨni ai kwən kɨrik, nhagɨn e Jon, rɨmauə ye tɨpəvsɨk, kɨni mor baptaes ye narmamə mə tukror nɨmtətien mə kwəsarar ye nərɨgien kapəriə tuk təvhagə has, kɨni mɨmə, “Taksarar ye nərɨgien kapəmiə, mɨsarakikɨn təvhagə hah, kɨni mɨsor baptaes.” ");
INSERT INTO nwi_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kɨni ai narmamə fam ye yerkwanu a Judia mɨne Jerusalem khavən mɨsəm in. Mamhani-ərhav-pən təvhagə has kapəriə. Kɨni Jon ror baptaes irəriə ye nu apa Jodan. ");
INSERT INTO nwi_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon rɨpəh nɨvəhsi-pənien neipən huvə kɨrik. Kafan kot kɨmnor kɨn tɨki narmɨragh kɨrik, kamni kɨmə kamel. Kɨni kafan kətəut kɨmnor kɨn tɨki kau. Kɨni nan nəvɨgɨnien kəvraiyuk əmə mɨne sukapak. ");
INSERT INTO nwi_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kɨni in ramni-ərhav pən tuk narmamə mə, “Kwasɨg irak, yermamə kɨrik e tukruə In yerpɨrɨg rapita yo. Yo yakpəh nəmhenien mə to yakənɨmkur kɨni mɨrɨsɨn-ta nərəus ye kafan sandel. ");
INSERT INTO nwi_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mərɨg yo yɨmnor əmə baptaes irəmiə kɨn nu; kɨni mərɨg In tukror baptaes irəmiə kɨn Nanmɨn Rhakə.” ");
INSERT INTO nwi_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ye nɨpɨg a, Yesu rɨmasɨ-pən Nasaret, yerkwanu kɨrik ye Galili. Muə e Jon raməmɨr ikɨn. Kɨni ai Jon rɨmnor baptaes iran ye nu apa Jodan. ");
INSERT INTO nwi_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nɨpɨg Yesu rɨmneiwaiyu mhekɨmter mɨn ye tame nu, In məm məknekɨn mə napuə rɨmnəkwag. In rəm Nanmɨn kape Kughen rɨsɨ-pən aikɨn meiwaiyu-pə tukun rəmhen kɨn mak ye tanə. ");
INSERT INTO nwi_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kɨni ai, nəgkiarien kɨrik rɨmasɨ-pən ye rao ye neai mamni mɨmə, “Ik Narɨk yame yakorkeikei. Rɨkik ragien pɨk tuk Ik.” ");
INSERT INTO nwi_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Məknekɨn, Nanmɨn kape Kughen rɨmnəkeikei kɨmi Yesu kɨni mɨkɨr mɨvən apa ye tɨpəvsɨk. ");
INSERT INTO nwi_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Aikɨn, Setan ramarkut mə tukrukrao ye nərɨgien kafan kape nɨpɨg foti. Yesu ramarə iriə nar mɨragh aparu mɨnə. Kɨni mərɨg agelo mɨnə kɨmɨsarha huvə tukun. ");
INSERT INTO nwi_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kɨni kɨrəhsi-pən Jon ye kalabus. Kwasɨg ikɨn, Yesu rɨpivən Galili, mamni-ərhav Nəgkiarien Huvə kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Mɨmə, “Taktəkun ai, rɨnor atuatuk nɨpɨg. Narmaruyen kape Kughen ruauə-ta. Taksarar ye nərɨgien kapəmiə tuk təvhagə hah kapəmiə, mhani nəfrakɨsien ye Nəgkiarien Huvə kape Kughen.” ");
INSERT INTO nwi_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kɨni ai, Yesu rɨmnəriwək ye nɨkar lugun Galili, kɨni məm kwərə mir kɨraru, nhagriu e Saemon mɨne naorahini Andru. Iriu kwarukɨn net, meinai iriu yermamə kape nɨviyen kəmam. ");
INSERT INTO nwi_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Kɨni Yesu rɨni-pən tuk əriu mɨmə, “Rauə mɨrakwasɨg kɨn Yo. Pəh yakor əmiru yermamə mir kape nɨviyen narmamə.” ");
INSERT INTO nwi_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Məknekɨn krəpəh kapəriu net, mwarar, mɨrakwasɨg kɨn. ");
INSERT INTO nwi_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kɨni Yesu rəriwək mɨvən kəskəh əmə mɨn, kɨni məm kwərə mir kɨraru. Kwajikovə mir kape Sebedi. Nhagriu e Jemes mɨne Jon. Kaokwətə ye nəkwai bot kapəriu, kɨni marajir əsɨgɨn net kapəriu. ");
INSERT INTO nwi_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Məknekɨn Yesu rokrən kɨn əriu. Kɨni ai iriu kwərer mwəpəh rɨmriu Sebedi raməmɨr ye nəkwai bot iriə kafan narmamə mɨnə. Kɨni iriu mɨrakwasɨg kɨn Yesu. ");
INSERT INTO nwi_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu mɨne narmamə kafan kɨmnhavən apa yerkwanu kɨrik, nhagɨn e Kapaneam. Kɨni ye Sabat mɨn kɨrik, Yesu rɨvən apa niməhuak kape nəmə Isrel, kɨni mamhajoun narmamə. ");
INSERT INTO nwi_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Narmamə kɨmɨsərɨg kafan nəgkiarien, kɨsakur, meinai kafan nəgkiarien nanmɨn aikɨn, rɨpəh nəmhenien kɨn nəgkiarien kape nəmhajoun kape Loa kape Moses. ");
INSERT INTO nwi_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ye nɨpɨg a, yermamə kɨrik, nanmɨn has ramərer-pən iran. Kɨni in ruə mɨn ye nofugɨnien kapəriə. Kɨni mok-rapomh kɨn Yesu mɨmə, ");
INSERT INTO nwi_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“!Eh! !Yesu, yemə Nasaret! ?Nakamuə ikɨn e mə takhawor əmawə? Tukmə ror Ik nɨmauə mə takoriah əmawə.” Kɨni mamni mɨn mɨmə, “Yo yakwɨrkun-ta mə Ik e Ik Yemə Imərhakə kape Kughen.” ");
INSERT INTO nwi_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Mərɨg Yesu rɨmnəgkiar skai pən kɨmi nanmɨn has ai, mɨmə, “!Eh! Pim. Ǝta ye yermamə e.” ");
INSERT INTO nwi_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Məknekɨn, nanmɨn has ai ror nɨprai yermamə rətəmnɨmɨn pɨk kɨni mokrən ehuə, məta iran, mɨvən isok. ");
INSERT INTO nwi_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kɨni narmamə mɨnə aikɨn kɨsəm kɨsakur, mɨsaiyoh əriə mɨnə mhamə, “!Eh! ?Rhawor e? Nəgkiarien vi kɨrik e. Kwən e kafan nəgkiarien, nanmɨn aikɨn. Tukmə In rəgkiar kɨmi nanmɨn has mɨnə kasor nəkwan.” ");
INSERT INTO nwi_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Məkneikɨn, nəvsaoyen kape Yesu rɨtərhav markurao ye Galili. ");
INSERT INTO nwi_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Məknekɨn Yesu mɨne Jemes, Saemon mɨne Andru kɨmnhatərhav ye nimə kape nofugɨnien kape nəmə Isrel mhavən atuatuk ye nəkwai nimə kape Saemon mɨne Andru, ");
INSERT INTO nwi_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","mɨsəm kuhu Saemon ramokie-okie mamapɨr. Kɨni kɨrhəvsao-pən kɨn kɨmi Yesu. ");
INSERT INTO nwi_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu rɨvən, mɨvəh kwermɨn, mɨvi haktə, kɨni rhekɨmter. Kɨni ai nokie-okieyen a ror infamien. Kɨni piahwaru ai rɨvən, mɨvəhsi-pən nəvɨgɨnien kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kɨni rɨnamenaiyu, narmamə yamə mɨne kɨmnhamhə, mɨne narmamə yamə mɨne nanmɨn has raməmɨr irəriə, iriə mɨnə tɨksɨn kɨmnhakɨr-pə əriə tuk Yesu. ");
INSERT INTO nwi_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Narmamə mɨnə fam a yerkwanu aikɨn, kasofugɨn əriə mɨnə ye kwəruə ye nimə Yesu ramarə ikɨn. ");
INSERT INTO nwi_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kɨni Yesu ror huvə narmamə khapsaah yamə mɨne kɨmnhavəh nəmhəyen pɨsɨn pɨsɨn. In maməko ta mɨn nanmɨn hah mɨnə ye narmamə, mamni-əhu nanmɨn has mɨnə mə tukhapəh nɨsəgkiarien, meinai iriə kwənharkun-ta In. ");
INSERT INTO nwi_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kəni rɨkwamer kɨn, yenpɨg-enpɨg əgkəp, Yesu rarar mɨvən apa ikɨn narmamə kharkək ikɨn maməhuak. ");
INSERT INTO nwi_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kɨni ai, Saemon mɨne in mɨnə tɨksɨn khavən masarha-kɨn In. ");
INSERT INTO nwi_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kɨsəm In, khani-pən tukun mhamə, “Narmamə fam kasarha-kɨn Ik.” ");
INSERT INTO nwi_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mərɨg Yesu rɨmə, “Nɨkam. Pəh khavən apa yerkwanu pɨsɨn pɨsɨn, ipakə tuk ətawə. Pəh yakni-ərhav nəgkiarien aikɨn, meinai Yo yɨmauə tukun.” ");
INSERT INTO nwi_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kɨni ai In rəriwək markurao ye Galili, mamni-ərhav Nəgkiarien Huvə kape Kughen ye nimə kape nofugɨnien kape nəmə Isrel. Maməkota nanmɨn hah mɨnə ye narmamə. ");
INSERT INTO nwi_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kɨni yermamə kɨrik yame rɨmɨvəh nɨmhəyen əutən ye tɨkin, in rɨmauə məm Yesu, kɨni mənɨmkur ye nɨmrɨn mamasək. Mamaiyoh kɨn nasituyen, mɨmə, “Tukmə nakorkeikei, nakɨrkun nor-huvəyen yo.” ");
INSERT INTO nwi_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kɨni Yesu, rɨkin rewaiyu tukun. Mərəhu-pən kwermɨn iran, kɨni mɨmə, “Yakorkeikei mə takhuvə mɨn. !Ǝsanɨn!” ");
INSERT INTO nwi_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Məknekɨn nɨprai yermamə ai rhuvə mɨn, nəmhəyen ai rɨrkək mɨn iran. ");
INSERT INTO nwi_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Kɨni Yesu rəgkiar skai pən kɨmin, mɨmə, “Takpəh nəvsaoyen kɨn kɨmi narmamə. Mərɨg takvən mərer ye nɨmrɨ pris, pəh in rəm mɨn ik. Kɨni ik mɨvən, məhuak mɨvəhsi-pən narɨmnar kɨmi Kughen rəmhen kɨn yame Moses rɨmɨni mə takor, pəh narmamə kɨsəm mə naknəsanɨn.” ");
INSERT INTO nwi_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mərɨg yermamə ai rɨmɨtərhav məvsao kɨn kɨmi narmamə. Ror pən, Yesu rɨmə to rɨpəh mɨn nɨvənien yerkwanu mɨnə məriwək ye nɨmrɨ narmamə, meinai iriə kamhaku-pən pɨk In. Kɨni mərɨg In raməmɨr əmə apa ikɨn ruhiko ikɨn. Narmamə fam khavən masəm In aikɨn. ");
INSERT INTO nwi_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nɨpɨg tɨksɨn ruə mɨvən, Yesu rɨrerɨg-pən mɨn yerkwanu e Kapaneam. Kɨni narmamə kwəsərɨg mə In aikɨn. ");
INSERT INTO nwi_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kɨni ai, narmamə khapsaah khavən aikɨn, mhavən imə, kwənmhaan rɨmərkəskəh. Nimə rukwar meriaji kwəruə rɨsisəg. Kɨni ai Yesu ramni-əhrav-pən Nəgkiarien kape Kughen tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mərɨg nɨpɨg raməgkiar hanə, narmamə kuas kharəh yermamə kɨrik. Nɨpran rɨmamhə. ");
INSERT INTO nwi_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nimə rukwar kɨn narmamə, ror pən, iriə to khapəh nharəhyen yermamə ai mhavən ipakə tuk Yesu. Mərɨg khavən mɨshaktə apa tokrei nimə, mɨsəhipu ta nɨkar nimə kɨrik, kɨni mharəh nɨkaokao yermamə ramapɨr-pən iran, mhavi, reiwaiyu-pən. ");
INSERT INTO nwi_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu rəm nhatətəyen kapəriə, mɨni-pən tuk yermamə ai nɨpran rɨmamhə, mɨmə, “Kafak kwajikovə. Yo yakwərəhsi-ta ta narpɨnien kape təvhagə has kafam.” ");
INSERT INTO nwi_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mərɨg namhajoun tɨksɨn kape Loa kape Moses kasəkwətə, mɨsəm norien a, mɨnəsaiyoh əriə mɨnə tukun, ");
INSERT INTO nwi_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","mhamə, “!Ah. !Kwən e ramni hah Kughen! Nəgkiarien e rahas. Kughen pɨsɨn əmə In rɨrkun nɨrəhsitayen narpɨnien kape təvhagə hah kape narmamə. ?Pa mɨn to rɨrkun nɨvəhsi-tayen?” ");
INSERT INTO nwi_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mərɨg Yesu ruɨrkun-ta nərɨgien kapəriə. Kɨni mɨni-pən tuk əriə, mɨmə, “?Rhawor e nakasərɨg məknekɨn? ");
INSERT INTO nwi_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","?Jakni-pən naha tuk yermamə a, kɨni kɨmiə nakasəm əfrakɨs? ?Mə jakni-pən tuk yermamə a mə kafan təvhagə hah yakwərɨsɨn ta? ?Uə mə jakni mə in tukrhekɨmter mɨrəh kafan nɨkaokao məriwək mamvən? ");
INSERT INTO nwi_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Səm-ru, Yo yakorkeikei mə jakor Yo mə takharkun mə Yo, Ji Yermamə, yakavəh nehuəyen ye tokrei tanə e tuk nɨvəhsi-tayen narpɨnien kape təvhagə hah kape narmamə.” Məkneikɨn marar mɨni-pən tuk yermamə nɨpran rɨmamhə mɨmə, ");
INSERT INTO nwi_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Yakamni-pre tuk ik mə takhekɨmter, mɨrəh kafam nɨkaokao, meriwək, mamvən apa imam yerkwanu.” ");
INSERT INTO nwi_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Yesu raməgkiar hanə, kɨni yermamə ai rhekɨmter, mɨrəh kafan nɨkaokao ye nɨmrɨriə, məriwək mamvən. Məknekɨn narmamə kɨmɨsəm kɨsakur. Mɨsəgnəgɨn Kughen, mhamə, “!Eh! Kɨtawə khapəh nɨsəm-hanə-yen nar kɨrik ror məknekɨn.” ");
INSERT INTO nwi_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Mərɨg Yesu rarə meiwaiyu-pən mɨn ye nɨkar lugun, narmamə khapsaah khauə masəm In. Kɨni In rɨmnəvhag kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kɨni ai, in rɨmnəriwək mɨvən kəskəh əmə, məm Livae, kwajikovə kape Alfeas. Kwən ai rɨmnamərer tuk mane kape takis. Kɨni Yesu rɨni-pən tukun mɨmə, “Yuə, mɨkwasɨg kɨn Yo, muə ik kafak yermamə.” Məknekɨn, yermamə ai rhekɨmter kɨni mɨkwasɨg kɨn. ");
INSERT INTO nwi_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kɨni ai, Yesu ruvən apa imei Livae, masəvɨgɨn kwis iriə narmamə mɨnə kape nɨvəhyen mane kape takis, mɨne narmamə tɨksɨn mɨn kamni kɨmə “yor təvhagə has mɨnə,” mɨne kafan narmamə mɨnə- meinai narmamə khapsaah kɨmnhakwasɨg kɨn. ");
INSERT INTO nwi_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ye nɨpɨg a, nəmhajoun mɨnə tɨksɨn kape Loa kape Moses kɨmɨsəm Yesu. Iriə tɨksɨn a Farisi mɨnə, kasəm Yesu raməvɨgɨn iriə yor təvhagə has mɨnə, kɨni kɨnɨsaiyoh-pən narmamə kape Yesu mhamə, “?Rhawor e kwən e raməvɨgɨn iriə yor təvhagə has mɨnə e?” ");
INSERT INTO nwi_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mərɨg Yesu rɨmnərɨg nəgkiarien kapəriə, mɨni-pən tuk əriə mɨmə, “Pəh nien mə narmamə yamə mɨne kasəsanɨn khamhavən mɨsəm dokta. Mərɨg narmamə yamə mɨne kamhamhə tukasəkeikei mhavən mɨsəm dokta. Pəh nien mə Yo yɨmauə mə jakokrən kɨn narmamə yamə mɨne kwəsatuatuk ta. Nɨkam. Yɨmauə mə jakokrən kɨn narmamə yamə mɨne kɨsaha.” ");
INSERT INTO nwi_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kɨni, ye nɨpɨg a, narmamə mɨnə kape Jon Baptaes, mɨne Farisi mɨnə kwəsəpəh nəvɨgɨnien mɨsatuakəm tuk nəhuakien, raməri-pən loa kape Moses. Kɨni narmamə mɨnə tɨksɨn khauə mɨsaiyoh Yesu, mhamə, “Ǝm-ru. Narmamə mɨnə kape Jon, mɨne Farisi mɨnə mɨn, kharkun nɨsəpəhyen nəvɨgɨnien. ?Mərɨg rhawor e kafam narmamə mɨnə khapəh nɨsorien məknakɨn?” ");
INSERT INTO nwi_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Kɨni Yesu rɨni-pən tuk əriə, mɨmə, “Tukmə yermamə yame kɨmnərkurək kafan, kɨni nagienien iran ramvən hanə, in mɨnə tɨksɨn to khapəh nɨsəpəhyen nəvɨgɨnien. ");
INSERT INTO nwi_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mərɨg tukrɨpior nɨpɨg kape narmamə tukhauə mharəh Yermamə yame kɨmnərkurək kafan, mhavən isok tuk In mɨnə tɨksɨn. Ye nɨpɨg a in a, In mɨnə tɨksɨn kharkun nɨsəpəhyen nəvɨgɨnien iran.” ");
INSERT INTO nwi_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kɨni mɨmə, “To yermamə kɨrik rɨpəh nɨvəhyen kwonmut neipən vi kɨrik kɨni mɨjir-pən ye neipən mətɨt kafan yame rɨneikus ta. To ror məknakɨn, kwonmut neipən yame rɨvi to reikus neipən mətɨt, kɨni reikus ehuə. ");
INSERT INTO nwi_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kɨni to yermamə kɨrik rɨpəh nɨvəhyen waen vi kɨni mɨvi-pən ye tɨki waen mətɨt. To ramor məknakɨn, kɨni waen a ye tɨki waen mətɨt reikus, kɨni waen raiyu fam. Mərɨg yermamə a tukrɨvi-pən waen vi ye tɨki waen vi.” ");
INSERT INTO nwi_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nɨpɨg kɨrik ye Sabat, Yesu mɨne kafan narmamə mɨnə kasəriwək mamhavən mhatərhav-pən yerki wit tɨksɨn. Kɨni narmamə kafan mɨnə kharhi kwənkwai wit nəriə. ");
INSERT INTO nwi_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kɨni Farisi mɨnə khani-pən tukun mhamə, “!Eh! Sabat e towei, mərɨg iriə kasor wok masakapɨr Loa kape Moses. ?Rhawor kafam narmamə kasor məknakɨn?” ");
INSERT INTO nwi_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Mərɨg Yesu rɨni-pən tuk əriə mɨmə, “Tukmə ror nakhapəh nɨsəhvekɨnien ye Nəkwəkwə kape Kughen norien yame King Deved rɨmnor kupən, yame in mɨne kafan narmamə mɨnə, nəriə nəvɨgɨnien ramrɨrkək, kɨsəmkərəv. ");
INSERT INTO nwi_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nɨpɨg e in a, Abiata in hae pris kape Kughen. Kɨni mərɨg, Deved rɨmavən ye Nimə Ehuə kape Kughen mamən bred yame pris mɨnə kwənhavəhsi-pən ta kɨmi Kughen. Kɨni mərɨg Deved rɨmɨvəhsi-pən mɨn kɨmi kafan narmamə, kɨni kɨsən. Kɨni mərɨg bred ai, ye Loa kape Moses ramni mə narmamə apnapɨg tukhapəh nɨsənien. Mərɨg pris mɨnə əmə kharkun nɨsənien.” ");
INSERT INTO nwi_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kɨni Yesu rɨni-pən mɨn tuk əriə mɨmə, “Səmru, Sabat rɨpəh nɨkɨrien narmamə. Mərɨg narmamə kamhakɨr Sabat. ");
INSERT INTO nwi_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ror pən Yo Ji Yermamə Yo yakamarmaru ye narɨmnar fam mɨne Sabat.” ");
INSERT INTO nwi_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu rɨmavən mɨn ye nimə kape nofugɨnien kape nəmə Isrel. Nɨpɨg ai, yermamə kɨrik, kwermɨn rɨmnarpəvɨn. ");
INSERT INTO nwi_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mərɨg narmamə tɨksɨn kɨmɨsarkut mə tuksəm-ru naha nhagɨn yame tukhani hah Yesu iran, mɨsarha-əterɨk mə tuksəm-ru mə Yesu to ror huvə kwən a ye Sabat uə nɨkam. ");
INSERT INTO nwi_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kɨni Yesu rɨni-pən tuk yermamə a yame kwermɨn rɨmnarpəvɨn mɨmə, “Yuə marer ye nɨmrɨ narmamə.” ");
INSERT INTO nwi_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kɨni mɨni-pən tuk əriə mə, “?Loa kape Moses ramni mə nakharkun nɨsorien naha ye Sabat? ?Ramni mə takasor norien huvə uə takasor norien has? ?Mə takshopni yermamə uə takhavəh mɨragh yermamə?” Kɨni kɨsəkwətə mɨsapnapɨg əmə. ");
INSERT INTO nwi_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kɨni Yesu rarha mərarao irəriə. Niehmaa rhai in. Kɨni mərɨg rɨkin rarə meiwaiyu mɨn tuk əriə, meinai kapəria kapə rɨskai pɨk. Kɨni mɨni-pən tuk kwən a mɨmə, “Huatuk kɨn kwermɨm.” Kɨni ai, kwən ai rhuatuk kɨn kwermɨn, ruahuvə əgkəp. ");
INSERT INTO nwi_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mərɨg Farisi mɨnə kɨmɨsəm norien a, kɨsap, mhavən mɨsəm nukwhao kape King Herod, mharai mhun nəgkiarien tukun mə tukshopni. ");
INSERT INTO nwi_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Kɨni Yesu mɨne kafan narmamə mɨnə khatərhav mɨn aikɨn, mɨseiwaiyu-ərhav ye nɨkar lugun. Kɨni narmamə mɨnə Galili khapsaah kɨmnhakwasɨg kɨn əriə. ");
INSERT INTO nwi_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Narmamə mɨn aikɨn kɨmɨsərɨg nəvsaoyen kɨn Yesu, kɨni mamhauə mə tuksəm. Khatərhav iku pɨsɨn pɨsɨn mɨnə. Tɨksɨn kɨmnhasɨ-pən apa Judia. Tɨksɨn khasɨ-pən apa Jerusalem. Kɨni tɨksɨn khasɨ-pən apa Idumia, tɨksɨn khasɨ-pən ye nɨkar nu Jodan, mɨne ye kwənmhaan mɨnə yame ipakə tuk Taea mɨne Saedon. ");
INSERT INTO nwi_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Narmamə khapsaah pɨk. Yesu rɨmnamni-pən tuk kafan narmamə, mɨmə, “Taksor apnəpenə ye bot kɨrik, pəh yakat-pən aikɨn, meinai narmamə kamhakuh-pə Yo.” ");
INSERT INTO nwi_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","In ramni məknakɨn meinai In rɨmnor huvə ta narmamə khapsaah yamə mɨne kɨmnhamhə. Kɨni narmamə yamə mɨne kɨmnhamhə aikɨn kɨsarkut mə tukhavən pakə tukun mharap mɨsəsanɨn. ");
INSERT INTO nwi_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kɨni narmamə yamə mɨne nanmɨn hah ramərer-pən irəriə, tukmə kɨsəm əmə Yesu, khamɨr ye nɨmrɨn. Kɨni masokrən ehuə kɨn, mhamə, “!Ik Ji Kughen!” ");
INSERT INTO nwi_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mərɨg Yesu rəgkiar skai pən kɨmi nanmɨn hah mɨnə, mətapɨg kɨn əriə mə tukhapəh nhani-əpuyen In. ");
INSERT INTO nwi_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kɨni Yesu mɨne kafan narmamə kɨshaktə fiak ye tukwas kɨrik. Kɨni rokrən mɨn kɨn kafan tɨksɨn narmamə yame In rɨmnorkeikei, mə tukhauə pakə. Kɨni iriə khauə pakə. ");
INSERT INTO nwi_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kɨni ai In rɨrpen kafan narmamə twelef. Mɨfəhsi-pən nehuəyen kɨmi əriə, kɨmə, Aposol mɨnə, mə iriə tukasəmɨr ipakə tukun tuk nɨni-ərhavyen Nəgkiarien Huvə kape Kughen ");
INSERT INTO nwi_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","kɨni mhavəh nɨrkunien tuk nəkotayen nanmɨn hah ye narmamə. ");
INSERT INTO nwi_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nhag namasur twelef e ror məknekɨn: Saemon (yame Yesu rhen-pən nhagɨn vi mə Pita); ");
INSERT INTO nwi_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","mɨne Jemes; mɨne piauni Jon (yame kwajikovə mir kape Sebedi. Yesu rhen-pən mɨn nhagriu mə, Boanejes. Kɨni nɨpran rɨmə, Pɨkwarien mir kape Karuəruə); ");
INSERT INTO nwi_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","mɨne Andru; mɨne Filip; mɨne Batalomiu; mɨne Matiu; mɨne Tomas; mɨne Jemes, kwajikovə kape Alfeas; mɨne Tadeas; mɨne Saemon Selot ");
INSERT INTO nwi_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","mɨne Judas Iskariot, yame kwasɨg ikɨn reighan-pən kɨn Yesu kɨmi nəmə hah mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu rɨrerɨg-pə yerkwanu. Kɨni ai narmamə khapsaah khauə masəm mɨn In. Mamhauə, mhauə, kɨni kwənmhaan kape napɨsien ramrɨrkək tuk əriə. Nɨpɨg kape nəvɨgɨnien ramrɨrkək mɨn. ");
INSERT INTO nwi_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nɨpɨg famle kafan mɨnə kɨmɨsərɨg, məknakɨn khauə mə tukhani-əhu, mhakɨr, mɨsap, meinai nəmə aikɨn kɨmnhani mhamə kapan kapə rameno-eno. ");
INSERT INTO nwi_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mərɨg namhajoun tɨksɨn kape Loa kape Moses kɨmnhatərhav Jerusalem, mhauə, mamhani mhamə, “!Nɨkam! Rɨrkun nəko-tayen nanmɨn has mɨnə meinai Bielsebul, yemehuə kape nanmɨn has mɨnə, ramərer-pən iran.” ");
INSERT INTO nwi_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kɨni Yesu rokrən kɨn narmamə mɨnə ai khauə ipakə tukun. Kɨni rɨni nuhpɨkɨnien kɨrik tuk əriə, mɨmə, “Nɨkam. ?Nakharkun mə Setan rɨrkun nəkotayen Setan uə? Nɨkam. ");
INSERT INTO nwi_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tukmə narmamə ye kantri kɨrik kasəwhai əriə mɨnə, mɨsarə kɨraru, kɨni tuksoriah kapəriə narəyen, kantri tukrɨmɨr. ");
INSERT INTO nwi_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kɨni rəmhen mɨn kɨn yerkwanu kɨrik. Tukmə narmamə kasəwhai əriə mɨnə, mɨsarə kɨraru, rukwanu a to rɨpəh narə-huvəyen. ");
INSERT INTO nwi_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Rəmhen mɨn kɨn narmamə kape Setan mɨnə, tukmə iriə kasəwhai narəyen kapəriə ror kɨraru, kwəseikus-eikus nimə en kape Setan. Kɨni norien kape Setan to rɨpəh nərer-tɨmtɨm-ien. Tukrəsaah-əsaah mɨrkək. ");
INSERT INTO nwi_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Kɨni mamhen mɨn kɨn yame to yermamə kɨrik nagheen rehuə rɨvən mətu kafan narɨmnar, kɨni in maməmɨr, yermamə pɨsɨn kɨrik to rɨpəh nɨvənien məkrəh kɨn. Tukmə yermamə kɨrik rɨmə tukrəkrəh kɨn, tukrəkupən mɨrkwəji yermamə ai nagheen rehuə. Kɨni ai mɨrkun nɨvənien məkrəh kɨn kafan narɨmnar. ");
INSERT INTO nwi_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ror pən, yakamni-pre əfrakɨs tuk əmiə, mə Kughen rɨrkun nɨvəhsi-tayen nahasien mɨnə fam yame nakasor, uə nɨni-hasien yame nakasor iran. ");
INSERT INTO nwi_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mərɨg tukmə nakhani has Nanmɨn kape Kughen, to Kughen rɨpəh nɨvəhsi-tayen nɨpɨg kɨrik. Təvhagə hah a tukraməmɨr kape rerɨn.” ");
INSERT INTO nwi_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu raməgkiar məknakɨn meinai in apa kupən kɨmnhani mhamə nanmɨn hah kɨrik raməmɨr iran. ");
INSERT INTO nwi_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kɨni ai, piau Yesu mɨnə, mɨne nɨsɨni khatərhav-pən mɨn. Kɨni masəmɨr iruə. Kɨni mɨsher-pən kɨn kɨrik mə tukrɨvən mokrən-pən kɨn. ");
INSERT INTO nwi_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Narmamə khapsaah kasəkwətə imə mɨsarkurao ye Yesu. Kɨni mamhani-pən tukun, mhamə, “Yemasur, nɨsɨnɨm, mɨne piam mɨnə mɨne kafam kakə mɨnə kɨsorkeikei mə tuksəm-ru Ik apa iruə.” ");
INSERT INTO nwi_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mərɨg Yesu rɨni-pən mə, “?Pa e nɨsɨnɨk? ?Mɨne nɨpa e piak mɨnə?” ");
INSERT INTO nwi_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kɨni In marha mərərao ye narmamə yamə mɨne kɨsəkwətə mɨsarkurao kɨn, mɨni-pən tuk əriə mə, “Kɨmiə e nɨsɨnɨk mɨnə mɨne piak mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Meinai yermamə yame ramor narɨmnar yame Kughen rorkeikei, in e piak, in e nɨsɨnɨk, mɨne in e kafak kakə.” ");
INSERT INTO nwi_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ye nɨpɨg a, Yesu rarə meiwaiyu-pə mɨn ye nɨkar nu. Narmamə khapsaah khauə masəm In. Kɨni Yesu ruvən ye bot mamkwətə aikɨn maməvhag kɨmi narmamə. Kɨni narmamə kasəkwətə i-fiak masətərɨg kɨn. ");
INSERT INTO nwi_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","In rɨmnəwhag kɨmi əriə kɨn narɨmnar khapsaah ye nuhpɨkɨnien mɨnə. Kɨni mɨmə, ");
INSERT INTO nwi_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“!Sərɨg-ru! Yermamə kɨrik rɨmavən mə tɨkrɨsuv kweru nai apa ye nəsimien. ");
INSERT INTO nwi_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kɨni mərɨg in rɨmavən mə tɨkrɨsuv kweru nai, mɨpɨk mɨvitəg-ətəg fam, kɨni tɨksɨn rəsaah-əsaah-pən ye swatuk, kɨni man mɨnə khauə mɨsən fam. ");
INSERT INTO nwi_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kɨni kweru nai tɨksɨn rəsaah-pən ye tokrei kapier yame nɨmoptanə rɨkəskəh ikɨn, murə aihuaa əmə. ");
INSERT INTO nwi_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kɨni mərɨg mɨrh rhaktə mhen əpni fam. Kɨsaukei fam meinai nuairiə rɨpəh neiwaiyu-pɨkien. ");
INSERT INTO nwi_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kɨni kweru nai tɨksɨn rəsaah-pən yerki kwənurkəsɨk. Kɨni mhaktə mehuə. Məknekɨn, kwənurkəsɨk rerko əsuun, kɨni kweru nai rurə mɨpəh nɨkuəyen. ");
INSERT INTO nwi_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kɨni tɨksɨn rəsaah-pən ye nɨmoptanə huvə, kɨni mhaurə, mɨseihuə, mhakuə kɨn kwənkwairiə khapsaah. Tɨksɨn kɨmnhakuə kɨn kwənkwairiə toti, kɨni tɨksɨn kɨmnhakuə kɨn sikisti, kɨni tɨksɨn kɨmnhakuə kɨn wan handred.” ");
INSERT INTO nwi_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kɨni Yesu rɨni-pən mɨn tuk əriə, mɨmə, “Tukmə kɨmiə narmamə yame nɨmətɨrgɨmiə rarə, sərɨg huvə nəgkiarien e.” ");
INSERT INTO nwi_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kɨni Yesu rɨvən In pɨsɨn, kɨni kafan narmamə twelef, iriə narmamə tɨksɨn mɨn khavən mɨnɨsaiyoh-pən kɨn nɨprai nuhpɨkɨnien mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kɨni In rɨmni-pən tuk əriə mɨmə, “Narmaruyen kape Kughen, in nar erkwaig; mərɨg yakwəni-ərhav-pre ta tuk əmiə. Kɨni mərɨg Yo yakamni-ərhav-pən əmə nuhpɨkɨnien tuk narmamə yamə mɨne kasəmɨr iruə, ");
INSERT INTO nwi_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","rəmhen kɨn yame Profet Aesea rɨmɨni mə, “‘Iriə tuksarhakɨn, mɨsarhakɨn pawk, mərɨg to khapəh nɨsəmien nɨpran. Iriə to kɨsərɨg pawk, mərɨg to khapəh nharkunien. Tamə iriə kɨsərɨg mharkun, kɨni mɨsarar ye nərɨgien kapəriə, pəh Kughen tukrɨvəhsita narpɨnien kape təvhagə hah kapəriə.’” ");
INSERT INTO nwi_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kɨni Yesu rɨmɨni-pən tuk kafan narmamə mɨnə, mɨmə, “?Rhawor e? ?Nakaseinein hanə nɨprai nuhpɨkɨnien e? Tukmə ror məkne, ?takshawor pən iran mɨne mharkun mɨn nɨprai nuhpɨkɨnien mɨnə mɨn tɨksɨn? ");
INSERT INTO nwi_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nuhpɨkɨnien e, nɨpran ramni məknekɨn: Yermamə yame rɨmɨsuv kweru nai, in rəmhen kɨn yermamə yame ramni-ərhav nəgkiarien kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Narmamə tɨksɨn yame kɨsərɨg nəgkiarien a, kɨsəmhen kɨn kweru nai yame rɨmnəsaah-pən ye swatuk. Rəmhen kɨn yame kɨmɨsərɨg nəgkiarien kape Kughen, taktəkun əmə Setan rɨvəhsi-ta mɨn. ");
INSERT INTO nwi_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kɨni narmamə tɨksɨn kɨsəmhen kɨn kweru nai yame rɨmnəsaah-pən yerki kapier kɨni murə aihuaa əmə. Rəmhen kɨn yame kɨsərɨg nəgkiarien kape Kughen, rɨkiriə ragien tukun, ");
INSERT INTO nwi_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","mərɨg khapəh nhavəhs-huvəyen nəgkiarien yerkiriə, masərer kape nɨpɨg kwakwə əmə. Kɨni tukmə kharəhpɨkɨn nɨpɨg əutən, uə narmamə kɨsor ahas pən kɨmi əriə tuk Nəgkiarien Huvə kape Kughen, məknekɨn kamhamɨr. ");
INSERT INTO nwi_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kɨni narmamə tɨksɨn yame kɨsərɨg nəgkiarien kɨsəmhen kɨn kweru nai yame rɨmnəsaah-pən yerki kwənurkəsɨk. Kɨsərɨg nəgkiarien e, ");
INSERT INTO nwi_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mərɨg kasətərɨg pɨk tuk narɨmnar kape nɨmraghien kapəriə. Kɨni nautə reikuə irəriə, mɨvi əriə, ror rɨkiriə ramvən əmə tuk mane. Norien a roriah nəgkiarien kape Kughen, rɨpəh norien kwənkwan. ");
INSERT INTO nwi_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kɨni narmamə tɨksɨn kɨsəmhen kɨn kweru nai yame rɨmnəsaah-pən ye nɨmoptanə huvə. Kɨsərɨg nəgkiarien a, mharkun. Kɨni mhavəh kwənkwai nəgkiarien a ye narəyen kapəriə. Iriə tɨksɨn kamhavəh kwənkwan rəmhen kɨn toti; tɨksɨn kamhavəh sikisti; kɨni tɨksɨn kamhavəh kwənkwan wan handred ye narəyen kapəriə.” ");
INSERT INTO nwi_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kɨni əmə ai, Yesu rɨni-pən tuk əriə mɨmə, “To kɨpəh nɨvəhyen laet kɨrik kukrai-pən ye nəkwai baket, uə ye nəpag bed. Nɨkam. Tukaməkeikei kɨruk haktə. ");
INSERT INTO nwi_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tukmə nar erkwaig, tukaməkeikei kəm. Tukmə kuvrɨg əpɨs, kɨni mərɨg tukraməkeikei mier-pə ikɨn rhakak ikɨn. ");
INSERT INTO nwi_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tukmə kɨmiə narmamə yame nɨmətɨrgɨmiə rarə, sətərɨg huvə kɨn nəgkiarien e.” ");
INSERT INTO nwi_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kɨni Yesu rɨni-pən mɨn tuk əriə mɨmə, “Nəgkiarien e nakasərɨg, takasəkeikei mɨsərɨg huvə. Narmamə yame mɨne kɨsərɨg kafak nəgkiarien kɨni mhapəh nɨsəripən-huvəyen, to khapəh nharkun-huvəyen. Mərɨg narmamə yamə mɨne kɨsərɨg kafak nəgkiarien kɨni mɨsəri-pən huvə, tukhavəh nɨrkunien mɨn rhaktə haktə. ");
INSERT INTO nwi_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Narmamə yame mɨne kɨsəri-pən kafak nəgkiarien, Kughen tukrɨvəhsi-pən mɨn nɨrkunien kɨmi əriə. Mərɨg narmamə yamə mɨne kɨsərɨg nəgkiarien e kɨni mɨsor nar apnapɨg iran, Kughen tukrɨvəhsi-ta nɨrkunien kəskəh yame rɨkiriə raməsɨk mə iriə kharkun.” ");
INSERT INTO nwi_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kɨni Yesu rɨni-pən mɨn tuk əriə mɨmə, “Narmaruyen kape Kughen rəmhen kɨn kweru nai yame yermamə ramsuv yerki nəsimien. ");
INSERT INTO nwi_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tukmə yenpɨg, ramapɨr. Mə yeraan, in raməriwək mamavən. Mərɨg kweru nai in ramhaktə atuk əmə mamehuə. Mərɨg kwən a reinein mə rhawor e mamor məknekɨn. ");
INSERT INTO nwi_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nɨmoptanə əmə ror kweru nai ramhaktə, mamor nɨmarɨn, kɨni mavus jihin, kɨni mamkuə kɨn kwənkwan. ");
INSERT INTO nwi_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kɨni nɨpɨg tukmə kwənkwan rɨmruə, kɨni yermamə ai rɨvən mamrhi meinai neriaji nɨpɨg kafan.” ");
INSERT INTO nwi_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kɨni Yesu rɨmə, “?Narmaruyen kape Kughen in rəmhen kɨn naha nhagɨn? ?Jakni naha nhagɨn rimhen? ");
INSERT INTO nwi_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","In rəmhen kɨn kwənkwai nai kɨrik kamni kɨmə mastad. Kwənkwai mastad rarkwəskwə rapita kwənkwai nai mɨnə fam. ");
INSERT INTO nwi_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mərɨg tukmə rəsaah, in murə mamehuə pɨk, mapita nai mɨnə tɨksɨn. Mamtɨkɨmkɨmɨn man yerpɨrɨg mɨnə khauə masor-pən nimairiə ye rəgrəgɨn.” ");
INSERT INTO nwi_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nɨpɨg fam, Yesu raməvhag kɨmi narmamə khapsaah kɨn nəgkiarien ye nuhpɨkɨnien, reriaji atuatuk nɨrkunien kapəriə. ");
INSERT INTO nwi_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","In raməgkiar kɨmi narmamə apnapɨg ye nuhpɨkɨnien əmə. Mərɨg tukmə In mɨne kafan narmamə mɨnə, ramhoprai-pən nɨprai nəgkiarien kafan kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kɨni ye nɨpɨg a, mɨrh rɨnameiwaiyu, Yesu rɨni-pən tuk kafan narmamə mɨnə mɨmə, “Pəh khavən apa nɨkar lugun pən.” ");
INSERT INTO nwi_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kɨni kɨsapta ye narmamə, mɨsat-pən ye bot yame Yesu ramkwətə iran, mhavirə. Kɨni bot mɨnə tɨksɨn kɨmnhakwasɨg mɨn kɨn əriə. ");
INSERT INTO nwi_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mhavirə, mhavirə, nɨmətag ehuə kɨrik ravən kɨni tahik rehuə pɨk, ipakə rakətənɨm kɨn bot. ");
INSERT INTO nwi_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mərɨg Yesu ramapɨr maməsawə huvə ye nəkwai bot. Mərɨg narmamə kafan mɨnə kɨmnhasɨg In, mhamə, “Yhajoun, !Ǝmru! !Natuksəmnɨm, mərɨg Ik nakpəh nərɨgien!” ");
INSERT INTO nwi_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Məkneikɨn Yesu rhekɨmter məgkiar kɨmi nɨmətag mɨne tahik mɨmə, “Rapəhrə.” Kɨni ai nɨmətag rewaiyu, tahik reiwaiyu; mamərinu mɨn. ");
INSERT INTO nwi_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kɨni Yesu rɨni-pən tuk kafan narmamə mɨnə mɨmə, “?Nakshawor mamhagɨn məknekɨn? ?Nhatətəyen kapəmiə rɨrkək hanə uə?” ");
INSERT INTO nwi_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mərɨg iriə kwənhagɨn pɨk. Mamhani-pən tuk əriə mɨnə mhamə, “?Naha e yermamə? !Nar apnapɨg mə nɨmətag mɨne tahik, mərɨg kawor nəkwan!” ");
INSERT INTO nwi_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kɨni ai, iriə khatərhav-pən mɨn ye nɨkar lugun a, kɨni mhavhiak mhavən ye kwənmhaan kɨrik kape nəmə Gerasa. ");
INSERT INTO nwi_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Kɨmnhatərhav ye nəkwai bot, kɨni yermamə kɨrik rarə mɨsɨ-pən mɨn ikɨn kamnɨm narmamə ikɨn, mamuə mɨrəhpɨkɨn Yesu. Kwən a ramarə ikɨn kamnɨm narmamə ikɨn. Nanmɨn has raməmɨr iran, keinein narkɨs-ətərəkɨn-ien kɨn nərəus uə jen. ");
INSERT INTO nwi_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nɨpɨg rɨpsaah kɨsarkɨs ətərəkɨn nɨhun mɨne kwermɨn kɨn jen, mərɨg in ramakapɨr-pɨr. Nagheen rehuə, narmamə kaseinein nharaptərəkɨnien. ");
INSERT INTO nwi_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tukmə yenpɨg uə yeraan, raməmɨr apa ikɨn kamnɨm narmamə ikɨn uə apa ye tukwas kɨni mamətəpar apomh, kɨni mamərəteih-ərəteih nɨpran kɨn kapier. ");
INSERT INTO nwi_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nɨpɨg Yesu raməmɨr hanə isok, yermamə ai rəm, kɨni raiyu ətkin muə mənɨmkur ye nɨmrɨn. ");
INSERT INTO nwi_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yesu rɨni-pən tukun mɨmə, “!Nanmɨn has, əta!” Kɨni nanmɨn has ai rokr-apomh mɨmə, “!Eh! Yesu, Ji Kughen yame In yerpɨrɨg pɨk. ?Nakmə takhawor yo e? Yakamaiyoh ik ye nhag Kughen mə takpəh norien nəmhəyen kɨmi yo.” ");
INSERT INTO nwi_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kɨni Yesu raiyoh-pən kɨn nhagɨn. Mərɨg rɨmə, “Nhagɨk e, Nukwao Ehuə, meinai kɨmawə e khapsaah.” ");
INSERT INTO nwi_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Məknekɨn ramasək ətgɨn Yesu m-rɨpsaah mə tukrɨpəh nəkota-pənien əriə apa isok. ");
INSERT INTO nwi_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kɨni ikɨn a, pukəh mɨnə khapsaah ikɨn. Kasəruk ye nɨhu tukwas a. ");
INSERT INTO nwi_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kɨni nanmɨn has mɨnə ai kɨsasək mhani-pən tuk Yesu mhamə, “Takəta-pən irəmawə yerki pukəh mɨnə e.” ");
INSERT INTO nwi_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kɨni Yesu reighan kɨn əriə kamhavən. Kɨsəta ye yermamə ai, kɨni mhavən yerki pukəh mɨnə. Pukəh mɨnə ai khapsaah ipakə tuk tu taosen. Kɨsaiyu mɨseiwaiyu ye nəpatu, mhavi-ərhav mɨsəmnɨm ye tahik. ");
INSERT INTO nwi_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Narmamə kape nəvɨgɨnien pukəh mɨnə kasərer aikɨn masəm pukəh mɨnə kasəmnɨm, kɨni kɨsaiyu mhavən apa iməriə ikɨn mɨnə, kɨni mɨsəvsao kɨn. Kɨni mɨsəvsao apnapɨg kɨn yerkwanu mɨnə ipakə tuk əriə. Kɨni narmamə ai khavən tukun mɨsəm. ");
INSERT INTO nwi_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Khauə mɨsəm Yesu, mɨsəm yermamə ai, nukwao ehuə kape nanmɨn has rɨmnaməmɨr iran kupən. Mɨsəm ramkwətə mɨvəhsi-pən neipən. Kɨni nɨrkunien kafan ruahuvə. Narmamə mɨnə ai kɨsəm khagɨn. ");
INSERT INTO nwi_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kɨni nəmə mɨnə kɨmɨsəm Yesu rɨmnəkota nanmɨn has kɨsəvsao kɨn yermamə yame nanmɨn has rɨmnaməmɨr iran kupan, mɨne pukəh. ");
INSERT INTO nwi_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kɨni nəmə aikɨn kɨsaiyoh-pən skai Yesu mə tukrɨtərhav a iməriə ikɨn. ");
INSERT INTO nwi_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kɨni ai Yesu ratpən ye bot. Yermamə yame nanmɨn has rɨmnaməmɨr iran ramaiyoh-pən In mə iriu min. ");
INSERT INTO nwi_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mərɨg Yesu rɨməni-əhu, mɨmə, “Nɨkam. Takvən apa imam yerkwanu kɨmiə kafam narmamə mɨnə, kɨni məvsao kɨn narɨmnar yame Kughen rɨmnor kɨmik, meinai rɨkin rɨmneiwaiyu pɨk tuk ik.” ");
INSERT INTO nwi_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kɨni kwən ai rɨtərhav mɨvən kwənmhan kɨrik nhagɨn e Dikapolis, kɨni maməvsao kɨn norien yame Yesu rɨmnor iran. Kɨni narmamə fam kɨsərɨg, kɨsakur kɨn. ");
INSERT INTO nwi_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kɨni Yesu rɨvəh bot məviəfugɨn ye nɨkar lugun mɨvhiak. Mɨvhiak hanə, narmamə khapsaah khauə mɨsərer kurao kɨn. ");
INSERT INTO nwi_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yamehuə kɨrik kape niməhuak kape nəmə Isrel, nhagɨn e Jaeras, ruə məm Yesu, mənɨmkur ye nɨmrɨn ");
INSERT INTO nwi_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kɨni masək ətgɨn, mɨmə, “Yhajoun, piakəskəh kafak nɨmhəyen rɨneriaji. Yuə-ru mərəhu-pən kwermɨm iran, pəh in rəsanɨn.” ");
INSERT INTO nwi_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kɨni Yesu rɨvən iriu min. Kɨni narmamə khapsaah kɨmnhakwasɨg kɨn əriu. Mamhasɨg-sɨg əriə mɨnə, mɨsarkurao ye Yesu. ");
INSERT INTO nwi_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Piraovɨn kɨrik aikɨn rɨmɨvəh nəmhəyen kape piraovɨn. Rɨmɨvəh nɨmhəyen ai meriaji newk twelef, nəmhəyen rapəh nɨrkəkien. ");
INSERT INTO nwi_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nɨpɨg mɨnə fam, ramərɨg nəmhəyen. Kɨni rɨvən məm dokta mɨnə, moriah fam kafan mane ye nəmhəyen kafan. Mərɨg nəmhəyen rɨpəh neiwaiyuyen; ramor pɨk. ");
INSERT INTO nwi_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Nɨpɨg rɨmnərɨg nəvsaoyen kɨn Yesu, kɨni rɨkin rəsɨk mə, “To yakpirap neipən kafan, mɨpiəsanɨn.” Kɨni mɨvən mɨkwasɨg kɨn narmamə yamə mɨne kɨmnhakwasɨg kɨn Yesu, kɨni mərao-pən mɨrap neipən kape Yesu. ");
INSERT INTO nwi_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nɨpɨg rɨmɨrap əmə neipən kafan, məsanɨn. In mɨrkun mə to rɨpəh mɨn nərɨgien nəmhəyen. ");
INSERT INTO nwi_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Məknekɨn, Yesu rərɨg yerkin, mɨrkun mə nanmɨn kafan ror huvə yermamə kɨrik. Kɨni rarharha maiyoh əriə mə, “?Pa e rɨmɨrap Yo?” ");
INSERT INTO nwi_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Narmamə kafan khani-pən tukun mhamə, “!Ǝmru! Kɨtawə khahum. ?Rhawor e nakamaiyoh mə pa e rɨmɨrap Ik?” ");
INSERT INTO nwi_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mərɨg Yesu rarharha mamarhakɨn yermamə yame rɨmɨrap In. ");
INSERT INTO nwi_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Məknekɨn, piraovɨn ai rərɨg mɨrkun naha nhagɨn yame rɨmnor in, kɨni muə məm Yesu, mənɨmkur ye nɨmrɨn. Mɨgɨn pawk, mɨni fam ye nəfrakɨsien kafan. ");
INSERT INTO nwi_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Mərɨg Yesu rɨni-pən tukun mə, “Piakəskəh, nhatətəyen kafam rɨmnor ik naknəsanɨn. Takamvən ye nəmərinuyen. Kafam nəmhəyen ruɨrkək.” ");
INSERT INTO nwi_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu raməgkiar hanə, narmamə tɨksɨn khasɨ-pən apa imei Jaeras, yamehuə kɨrik kape niməhuak kape nəmə Isrel, mhatərhav-pə. Mhani-pən tuk Jaeras mhamə, “Takpəh norien narkutien kɨmi Yhajoun mɨkɨr mɨvən. Kafam piakəskəh ruamhə ta.” ");
INSERT INTO nwi_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kɨni Yesu rɨmnərɨg nəgkiarien a, mɨni-pən tuk Jaeras mə, “Takpəh nɨgɨnien. Hatətə əmə irak.” ");
INSERT INTO nwi_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kɨni Yesu rɨni-əhu narmamə mə tukhapəh nhakwasɨgien kɨn. Kɨni mɨkɨr əmə Pita, mɨne Jemes, mɨne Jon, piau Jemes irisɨr min. ");
INSERT INTO nwi_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Khatərhav-pə imei yemehuə a. Yesu rəm mə narmamə khapsaah aikɨn. Kɨsasək mamhauvrɨg-uvrɨg pɨk. ");
INSERT INTO nwi_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Rauru-pən imə mɨni-pən tuk əriə mə, “?Rhawor nakamhauvrɨg-uvrɨg pɨk a? Piakəskəh rɨpəh nɨmhəyen, mərɨg ramapɨr əmə.” ");
INSERT INTO nwi_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kɨsərɨg, kɨsarh iakei iran. Məknekɨn Yesu rher-yerhav kɨn əriə apa iruə, mɨpəh əmə rɨm piakəskəh a, mɨne nɨsɨni mɨne kwərə misɨr ai yame karhɨkwasɨg kɨn In. Khavən mɨsəm piakəskəh a. ");
INSERT INTO nwi_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kɨni Yesu rɨvəh kwermɨn mɨni-pən tukun mə, “Talita kum.” (Ye nəgkiarien kapəriə, nɨpran rɨmə, “Piakəskəh, yakamni-pre tuk ik mə, ‘Hekɨmter’.”) ");
INSERT INTO nwi_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Məknekɨn, piakəskəh a rhekɨmter məriwək. (Kafan newk twelef əmə.) Kɨmɨsəm norien ai Yesu rɨmnor, kɨsakur pɨk kɨn. ");
INSERT INTO nwi_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kɨni Yesu rɨni-pən tuk əriə mə, “Takhapəh nɨsəvsaoyen kɨn norien e kɨmi narmamə. Kɨni havəhsi-pən nəvɨgɨnien kɨrik kɨmin pəh rən.” ");
INSERT INTO nwi_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Kɨni Yesu rɨtərhav mɨn aikɨn, mɨvən apa iman ikɨn. Narmamə kafan mɨnə kɨmnhakwasɨg kɨn. ");
INSERT INTO nwi_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabat yame ramuə, In rɨmnəvhag kɨmi narmamə apa niməhuak kape nəmə Isrel. Narmamə khapsaah aikɨn. Kɨni kɨsərɨg kafan nəgkiarien, kɨsakur pɨk kɨn. Mamhani mhamə, “Man, ?In ravəh hiə nɨrkunien e? ?Ramhawor mɨvəh nɨrkunien? ?Rhawor mor nɨmtətien mɨnə e? ");
INSERT INTO nwi_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kɨtawə kwənharkun ta kwən e. In kwajikovə əmə kape yermamə yame ravhirəkɨn narɨmnar kɨn nai. Nɨsɨni e Meri; kɨni naorahini mɨnə e Jemes, mɨne Josef, mɨne Judas mɨne Saemon. Kɨni kafan kakə mɨnə kasarə mɨn e kɨtawə miriə.” Kɨni narmamə mɨnə a kasəməkɨn In. ");
INSERT INTO nwi_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mərɨg Yesu rɨni-pən tuk əriə mə, “Tukmə profet kɨrik kape Kughen, narmamə tukhasiai in. Kɨni mərɨg, narmamə iman ikɨn, mɨne kwənərəus kafan mɨnə, iriə pɨsɨn əmə khapəh nhasiaiyen in.” ");
INSERT INTO nwi_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","In a kwənmhaan a, rɨpəh nor-pɨkien nɨmtətien. Mərɨg In rərəhu-pən kwermɨn ye narmamə kwatɨksɨn yamə mɨne kamhamhə, kɨni mor huvə əriə. ");
INSERT INTO nwi_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mərɨg Yesu rɨmnəm mə narmɨnə iman ikɨn kapəriə nhatətəyen rɨrkək, rakur. Kɨni ai, Yesu rəriwək mamarkurao yerkwanu mɨnə aikɨn maməvhag kɨmi narmamə. ");
INSERT INTO nwi_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kɨni mokrən kɨn narmamə twelef kafan mə tukhauə, kɨni mɨvəhsi-pən nehuəyen kɨmi əriə tuk nəkotayen nanmɨn has ye narmamə. ");
INSERT INTO nwi_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kɨni mɨmə, “Tukmə nakamhavən ye swatuk, mhapəh nhavəhyen nar kɨrik. Takhapəh nhavəhyen bred, uə nɨtɨp uə mane. Takhavəh əmə kaskɨn. ");
INSERT INTO nwi_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kɨni mhavəhsi-pən sandel, mərɨg takhapəh nhavəhyen neipən kɨraru kɨraru.” ");
INSERT INTO nwi_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mɨni-pən mɨn tuk əriə mɨmə, “Nɨpɨg tukmə nakhavən yerkwanu kɨrik, mɨsarə ye nimə kɨrik, nimə a in a taksarə əmə ikɨn mɨseriaji mhatərhav ikɨn mamhavən. ");
INSERT INTO nwi_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mərɨg tukmə yerkwanu kɨrik rɨpəh norkeikeiyen əmiə mə takhavən iməriə ikɨn, mhapəh nɨsətərɨgien kɨn əmiə, takhatərhav iməriə ikɨn, mɨsarpita-arpita nɨmokrur ye sandel kapəmiə. Norien e tukror nɨmtətien mə narmamə yerkwanu a kɨmɨsor nar kɨrik rapəh nəmhenien.” ");
INSERT INTO nwi_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kɨni ai iriə khatərhav, mhavən, mhani-pən tuk narmamə mə tuksarar ye nərɨgien kapəriə tuk təvhagə hah. ");
INSERT INTO nwi_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kɨni masəkota nanmɨn hah mɨnə ye narmamə khapsaah. Kɨni masətəg-pən nehe kwənkwai olif ye kapən kapə narmamə khapsaah yamə mɨne kamhamhə, kɨni khahuvə. ");
INSERT INTO nwi_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kɨni nəvsaoyen kɨn Yesu rɨtərhav, kɨni king kape nar aikɨn, nhagɨn e Herod, rərɨg. Narmamə tɨksɨn khamə, “Mə Jon Baptaes a. Mə rɨməmragh mɨn kɨni mamor pɨk nɨmtətien.” ");
INSERT INTO nwi_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mərɨg narmamə tɨksɨn khamə, “Nɨkam. Mə Elaeja.” Kɨni mərɨg tɨksɨn khamə, “Mə profet pɨsɨn kɨrik. Rəmhen kɨn profet kupən kape Kughen.” ");
INSERT INTO nwi_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mərɨg Herod rɨmnərɨg, mɨmə, “Nɨkam. Mə Jon Baptaes e, yame yɨmnərəru ta nɨpətək nuan. Yakmə rɨmɨmragh mɨn.” ");
INSERT INTO nwi_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herod rɨkin rɨmnəsɨk məknekɨn meinai in apa kupən, rɨmɨrəhsi-pən Jon Baptaes ye kalabus meinai piauni Filip rɨnamkɨr piraovɨn kɨrik, nhagɨn en Herodias; kɨni en, Herod rɨkɨr-ta mɨn. ");
INSERT INTO nwi_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Mərɨg Jon rɨmɨni-pən tuk Herod mə, “Kamni-əhu mə takpəh nɨkɨr-tayen piraovɨn kape piam.” ");
INSERT INTO nwi_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kɨni niemha rhai Herodias tukun, mə tukrhopni Jon, mərɨg rɨneinein ");
INSERT INTO nwi_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","meinai Herod rɨmɨsiai Jon, mɨrkun mə in yermamə atuatuk kape Kughen, kɨni maməm vi vi in. Nɨpɨg Jon raməgkiar mukrekɨn kapan kapə Herod, kɨni Herod rorkeikei mə tukrərɨg mɨn. ");
INSERT INTO nwi_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mərɨg nɨpɨg kɨrik, Herodias rɨmɨvəh kwənmhaan tuk nhopniyen Jon. Herod rɨmnor nəvɨgɨnien ehuə kɨrik mamor nɨpɨg kafan yame rɨmnarha iran. Kɨni mokrən kɨn gavman kafan, mɨne namehuə mɨnə kape mobael, mɨne namehuə mɨnə tɨksɨn apa Galili; khauə ye nəvɨgɨnien kafan. ");
INSERT INTO nwi_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kɨni piakəskəh kape Herodias rɨvən mɨn aikɨn, mamor danis ye nɨmrɨriə. Nɨpɨg Herod mɨne in mɨnə tɨksɨn kɨmɨsəm, rɨkiriə ragien tukun. Kɨni Herod rɨni-pən tuk piakəskəh ai mə, “Tukmə nakorkeikei naha nhagɨn, yakɨrkun nɨvəhsi-preyen kɨmik. ");
INSERT INTO nwi_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yakamni kwəsu əgkəp mə nar yame nakorkeikei mamaiyoh yo kɨn, yakɨrkun nɨvəhsi-preyen. Nar apnapɨg tukmə rehuə pawk, yakɨrkun nɨvəhsi-preyen kɨm ik.” ");
INSERT INTO nwi_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kɨni ai piakəskəh ai rɨtərhav maiyoh nɨsɨni mɨmə, “?Nɨsɨnɨk, jakaiyoh-pən kɨn naha nhagɨn tuk rɨmɨk?” Kɨni ai rɨni-pən tukun mə, “Takvən maiyoh kɨn kapən kapə Jon Baptaes.” ");
INSERT INTO nwi_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Məknekɨn, piakəskəh ai raiyu, mɨvən məm yermaru, kɨni mɨmə, “Yakorkeikei mə taktəkun əmə takrəh kapən kapə Jon Baptaes, mukrai-pən ye tikiplet, mɨrəh muə kɨmi yo pəh yakəm.” ");
INSERT INTO nwi_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nəgkiarien ai ror King Herod rərɨg rahas pɨk, meinai rɨmnor nəgkiarien əutən ye nɨmrɨ in mɨnə tɨksɨn. To rɨpəh nəpəhyen. ");
INSERT INTO nwi_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ror pən, rher-pən kɨn mobael kɨrik mə tukrɨvən mɨkɨsəru nɨpətək nuai Jon, mɨrəh kapan kapa muə. Kɨni mobael ai rɨvən apa kalabus, mɨkɨsəru ta nɨpətək nuai Jon, ");
INSERT INTO nwi_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","mərəhu-pən kapan kapa ye tikiplet. Mɨvəhsi-pən kɨmi piakəskəh ai, mə tukrɨvəh mɨvən kɨmi nɨsɨni. ");
INSERT INTO nwi_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mərɨg narmamə kape Jon Baptaes kɨmɨsərɨg nəvsaoyen kɨn, khavən mharəh nɨpran, mhavən mɨsərəhu-pən ye nəpəəg kapier. ");
INSERT INTO nwi_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kɨni aposol mɨnə kape Yesu khasɨ-pən mɨn yerkwanu yamə mɨne Yesu rɨmnher-pən kɨn əriə ikɨn, mamhauə mɨsəvsao-pən kɨn norien kapəriə mɨne nəvhagien kapəriə kɨmin. ");
INSERT INTO nwi_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mərɨg narmamə khapsaah kɨmnhauə masəm In, kɨni iriə kafan narmamə mɨnə kapəriə nɨpɨg rɨrkək tuk nəvɨgɨnien. Kɨni rɨni-pən tuk kafan narmamə mɨnə mə, “Hauə, pəh khavən apa ikɨn narmamə kharkək ikɨn kɨni mɨsapɨs.” ");
INSERT INTO nwi_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kɨni ai Yesu mɨne kafan narmamə mɨnə khavən ye bot mhatərhav mhavən ikɨn narmamə kharkək ikɨn. ");
INSERT INTO nwi_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mərɨg narmamə khapsaah kɨsəm Yesu mɨne kafan narmamə mɨnə kɨnamhavən, kɨni kharkun əriə. Kɨni khatərhav iməriə yerkwanu mɨnə, mɨsaiyu əkupən kɨn əriə. ");
INSERT INTO nwi_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mərɨg Yesu rɨmɨvhiak məm narmamə khapsaah aikɨn, kɨni rɨkin rewaiyu tuk əriə meinai iriə kɨsəmhen kɨn sipsip mɨnə tɨksɨn yame yermamə rɨkək yame ramarha huvə tuk əriə. Kɨni In raməvhag kɨmi əriə mamni narɨmnar rɨpsaah. ");
INSERT INTO nwi_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Rɨnamenaiyu, narmamə kape Yesu khauə mɨsəm In. Mhani-pən tukun mhamə, “Kwənmhan əkwak eikɨn e, kɨni rɨnamenaiyu. ");
INSERT INTO nwi_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Takher rik rik kɨn narmamə mɨnə e, pəh khavən apa yerkwanu ipakə mɨnə mhavəh nəriə kɨrik nəvɨgɨnien.” ");
INSERT INTO nwi_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mərɨg In rɨni-pən tuk əriə mɨmə, “Rhuvə mə kɨmiə əmə taksəvɨgɨn əriə.” Mərɨg iriə khani-pən tukun mhamə, “?Jakshawor? ?Nakmə jaksoriah apnapɨg əmə tu handred taosen vatu ye bred, mhawəhsi-pən kɨmi əriə?” ");
INSERT INTO nwi_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mərɨg raiyoh əriə mɨmə, “?Nakhavəh bred kuvhuun? Havən-ru mɨsəm.” Khavən mɨsəm nɨpar bred kɨrkɨrɨp əmə mɨne kəmam kɨraru. ");
INSERT INTO nwi_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kɨni Yesu ruh rɨkiriə mɨmə, “Takhani-pən tuk narmamə mɨnə en khavən yerki mənvhirɨk yame rhuvə, mɨsəkwətə ye nɨmrɨn nɨmrɨn.” ");
INSERT INTO nwi_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nɨmrɨn tɨksɨn wan handred. Kɨni nɨmrɨn tɨksɨn fifti. ");
INSERT INTO nwi_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kɨni ai Yesu rɨvəh bred a kɨrkɨrɨp mɨne kəmam a kɨraru, mɨvaag haktə mɨni vi vi Kughen tukun, mhapu-hapu bred mɨne kəmam, mɨpɨk-pən kɨmi kafan narmamə mə tukhapɨk mɨsəvɨgɨn narmamə mɨnə a kɨn. ");
INSERT INTO nwi_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kɨni iriə kɨsəvɨgɨn tupriə rəsiis ");
INSERT INTO nwi_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","mɨsəpəh nɨpərpər bred mɨne kəmam. Kɨni kafan narmamə mɨnə kɨmnhavai-pən ye nɨtɨp twelef khakwar mɨn. ");
INSERT INTO nwi_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Narmamə ai kɨmɨsəvɨgɨn, narman əmə, kɨsəmhen kɨn faef taosen. ");
INSERT INTO nwi_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Məknekɨn Yesu rɨni-pən tuk kafan narmamə mə tukhavəh bot kapəriə, mɨsəviəfugɨn mɨsəkupən mamhavən apa ye nɨkar lugun, mhavən yerkwanu kɨrik, nhagɨn e Betsaeda. Pəh In raməmɨr, mher rik rik kɨn narmamə pəh kamhavən iməriə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yesu raowiə kɨn əriə, mapitan kɨn əriə, mhaktə mɨvən ye takwar kɨrik maməhuak. ");
INSERT INTO nwi_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Rɨnəpɨgnəp, bot ai raməmɨr hanə apa ye tame lugun. Mərɨg Yesu In raməmɨr pɨsɨn apa fiak. ");
INSERT INTO nwi_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","In maməm əriə kasəsuə ye bot, mɨsəm rəutən meinai nɨmətag ramuh əriə. Kɨsərɨg rahah mɨsəsuə ye bot ipakə reraan, kɨni Yesu rəriwək ye nɨmar mar tahik mɨvən pakə tuk əriə. Natukrapita əriə, ");
INSERT INTO nwi_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","mərɨg iriə kɨmɨsəm raməriwək ye nɨmar mar tahik, khamə ta yarmhə. Kɨsətəpar mhagɨn pɨk. Mərɨg Yesu rɨni-pən tuk əriə mə, “Takhapəh nhagɨnien. Mə Yo əmə e.” ");
INSERT INTO nwi_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kɨni ratpən ye bot, nɨmətag ror infamien. Kɨsəm kɨsakur rɨkiriə ragien. ");
INSERT INTO nwi_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mərɨg kapəria kapə rɨskai hanə. Kɨmɨsəm pawk Yesu rɨmnəvɨgɨn narmamə khapsaah kɨn bred, məpəh irəkwak ramswin, mərɨg kɨmnhapəh nharkunien mə In pa. ");
INSERT INTO nwi_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kɨni iriə kɨsəviəfugɨn ye lugun ai mhavhiak ye kwənmhaan kɨrik nhagɨn e Genesaret. Mhavi-tərəkɨn kapəriə bot aikɨn. ");
INSERT INTO nwi_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kɨni mhavhiak, narmamə mɨn aikɨn kɨmɨsəm Yesu kɨni kharkun In. ");
INSERT INTO nwi_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kɨni kɨsaiyu mhavən apa iməriə mɨnə mhapɨk narmamə yamə mɨne kɨmnhamhə ye nɨkaokao mhavən ikɨn pukaa Yesu ramvən ikɨn. ");
INSERT INTO nwi_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ikɨn mɨnə fam Yesu ramvən ikɨn, yerkwanu ehuə, mɨne yerkwanu kwəskwəh, narmamə mɨnə khapɨk narmamə mɨnə kamhamhə, masərer əswasɨg kɨn ye swatuk pɨsiək. Kɨni mɨsasək ətgɨn mə tukreighaan kɨn narmamə kamhamhə pəh kharap əmə nɨpeihage neipən kafan. Kɨni narmamə mɨ-fam yamə mɨne kɨmnharap, kɨmɨsəsanɨn. ");
INSERT INTO nwi_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Namhajoun tɨksɨn kape loa kape Moses iriə Farisi mɨnə khasɨ-pən Jerusalem mhauə mɨsofugɨn-pən tuk Yesu ");
INSERT INTO nwi_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","kɨni mɨsəm mə narmamə tɨksɨn kape Yesu kasəvɨgɨn mamhavəh nəmkɨmɨk kɨrik meinai khapəh nɨsəravyen rəri-pən natuakəmien kape nəmə Isrel. ");
INSERT INTO nwi_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Farisi mɨnə, mɨne nəmə Isrel mɨnə fam kamhakwasɨg kɨn narəyen kupən kapəriə. Tukmə khapəh nɨsəravyen rəri-pən norien kapəriə, to khapəh nɨsəvɨgɨnien. ");
INSERT INTO nwi_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kɨni, tukmə khasɨ-pən apa maket, mhauə yerkwanu, kɨni mhapəh nɨsəravyen, to khapəh mɨn nɨsəvɨgɨnien. Kapəriə natuakəmien rɨpsaah ye nɨkarɨn kape nəspir-tayen nəmkɨmɨk ye pənkɨn, mɨne sospen mɨne besin kapəriə). ");
INSERT INTO nwi_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kɨni Farisi mɨnə mɨne namhajoun kape loa kape Moses kɨnəsaiyoh Yesu mhamə, “?Rhawor kafam narmamə khapəh nɨsəri-pənien kapətawə natuakəmien yame kaha mɨnə kɨmnəsəvhag-pə kɨn kɨmi ətawə? Kafam narmamə mɨnə kasəvɨgɨn mhapəh nɨsəravyen rəri-pən natuakəmien kapətawə.” ");
INSERT INTO nwi_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “Eh. Kapəmiə nɨniyen rhuvə, mərɨg kapəmiə norien in rahas. In apa kupən, profet kɨrik kape Kughen, nhagɨn e Aesea, rɨmnəfrakɨs ye nɨkarɨn kapəmiə mɨrai mamni mə, “‘Nəmə mɨnə a kamhani apnapɨg əmə nəfrakɨsien irak ye nheriə, mərɨg rɨkiriə raməmɨr isok pɨk tuk Yo. ");
INSERT INTO nwi_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kasəhuak mərɨg kasəhuak təkun əmə. Kɨni kapəriə nəvhagien kamhani mhamə nəgkiarien e kape Kughen, mərɨg ror əmə nərɨgien kɨn kape yermamə.’” ");
INSERT INTO nwi_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kɨni Yesu rɨni-pən tuk əriə mə, “Kɨmiə nakwəsəpəh loa yame Kughen rɨmɨvəhsi-pre, kɨni mɨnamhakwasɨg əmə kɨn nərɨgien kape yermamə.” ");
INSERT INTO nwi_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kɨni mɨni-pən mɨn tuk əriə mə, “?Kɨmiə nakhamə nakharkun pɨk nar? !Mərɨg nakwəsəpəh loa kape Kughen mɨnamhakwasɨg əmə kɨn narəyen kape kaha mɨnə! ");
INSERT INTO nwi_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Səm-ru, Moses rɨmɨni kupən mɨmə, ‘Takhasiai nɨsɨnmiə mɨne rɨmɨmiə.’ Kɨni mɨmə, ‘Yermamə yame ramni hah nɨsɨni uə rɨmni tukhopni.’ ");
INSERT INTO nwi_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mərɨg kɨmiə nakhani-əhu narmamə mə tukhapəh nɨsasituyen ye mamə mɨne tatə kapəriə, mhamə tukhani-pən tuk əriə mhamə, ‘Eh. Yakeinein nɨvəhsi-preyen nar kɨrik meinai yakvəhsi-pən ta fam kɨmi Kughen, kɨni to yakpəh nɨvəhsi-ta-mɨnien mɨvəhsi-pre kɨmik.’ ");
INSERT INTO nwi_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nakasəvhag kɨmi narmamə məknekɨn mɨsətapɨg kɨn nasituyen yame narmamə tuksor kɨmi nɨsɨnriə mɨne rɨmriə. ");
INSERT INTO nwi_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ror pən narəyen kapəmiə yame nakasəvhag kɨn kɨmi narmamə ramor təkun nəgkiarien kape Kughen. Kɨni masor narɨmnar khapsaah ror məknekɨn.” ");
INSERT INTO nwi_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kɨni Yesu rokrən kɨn narmamə mə tukhauə mɨn. Mɨni-pən tuk əriə mə, “Taksətərɨg huvə, mɨsərɨg mharkun. ");
INSERT INTO nwi_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nar raməmɨr iruə, tukmə rɨvən yerki yermamə, to rɨpəh norien rəmkɨmɨk ye nɨmrɨ Kughen. Nar ramtərhav yerki yermamə ramor nəmkɨmɨk ye nɨmrɨ Kughen. ");
INSERT INTO nwi_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Yermamə yame nɨmətergɨn rarə, tukrərɨg huvə nəgkiarien e.” ");
INSERT INTO nwi_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kɨni Yesu rəta mɨn ye narmamə ai, mɨvən imə. Kɨni narmamə kafan kɨsaiyoh kɨn nɨprai nuhpɨkɨnien yame in rɨmɨni. ");
INSERT INTO nwi_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kɨni rɨni-pən tuk əriə mɨmə, “?Rhawor? ?Kɨmiə mɨn nakseinein? Takharkun mə narɨmnar yame kamən to rapəh norien yermamə rəmkɨmɨk ye nɨmrɨ Kughen. ");
INSERT INTO nwi_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Narɨmnar yame ror məknakɨn to rɨpəh nɨvənien yerkin. Mɨvən ye tɨpeuə en mɨpitərhav hanə mɨn.” (Nəgkiarien a kape Yesu rɨni huvə fam nəvɨgɨnien mɨnə ye nɨmrɨ Kughen). ");
INSERT INTO nwi_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kɨni In mɨmə, “Mərɨg narɨmnar yame ramsɨ-pən yerki yermamə in en ramor yermamə raməmkɨmɨk ye nɨmrɨ Kughen. ");
INSERT INTO nwi_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Meinai yerki yermamə, nərɨgien hah rɨpsaah, rəmhen kɨn nəkrəhyen kɨn piraovɨn, nhopniyen yermamə, napɨr-pənien tuk piakwənahin, nəkrəhyen, ");
INSERT INTO nwi_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nəptɨgien kɨn nautə, norien has, nor-apnapɨgien nar, neikuəyen, nɨniyen nɨkar jir, nanipɨnien, nəgkiar-ausitien, mɨne nətəwaoyen. ");
INSERT INTO nwi_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Norien has mɨnə a kamhasɨ-pən yerki yermamə mor yermamə raməmkɨmɨk ye nɨmrɨ Kughen.” ");
INSERT INTO nwi_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kɨni Yesu rɨtərhav mɨn aikɨn meiwaiyu ərhav kwənmhaan ehuə kɨrik, nhagɨn e Taea. Maiyu apɨs-apɨs pawk, mɨvən imə, mərɨg narmamə a kharkun mə In eikɨn e. ");
INSERT INTO nwi_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Kɨni piraovɨn kɨrik, nanmɨn has rɨmnəmɨr ye kafan piakəskəh. Pian ai pəh nien mə kwənərəus kape Isrel. In rɨmnarha apa Fonisia, ye provins a Siria. Kɨni rɨmnərɨg nəvsaoyen kɨn Yesu, kɨni ruə, mənɨmkur ye nɨmrɨn masək ətgɨn mə tukrəko ta nanmɨn has ye kafan piakəskəh. ");
INSERT INTO nwi_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mərɨg Yesu rɨni-pən nuhpɨkɨnien kɨrik tukun mɨmə, “Pəh kwajikovə mɨnə əmə tuksəvɨgɨn tupriə rəsiis. Rɨpəh natuatukien mə tukvəh nəvɨgɨnien ne kwajikovə karakikɨn-pən kɨmi kuri mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mərɨg piraovɨn ai rɨni-pən tukun mə, “Yemasur, nəfrakɨs. Mərɨg kuri mɨnə kharkun nɨsənien nɨmsɨmsɨ nəvɨgɨnien ne kwajikovə mɨnə yame raməsaah-pən ye nəpəəg tebol.” ");
INSERT INTO nwi_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kɨni Yesu rɨni-pən mɨn mə, “Nɨmnhorpɨn məknen nəgkiarien, rhuvə. Nanmɨn has ruatərhav ta ye kafam piakəskəh. Rerɨg-pən imam yerkwanu.” ");
INSERT INTO nwi_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Piraovɨn ai rɨrerɨg-pən iman yerkwanu məm kafan piakəskəh ramapɨr huvə ye nɨkaokao. Nanmɨn has ruatərhav iran. ");
INSERT INTO nwi_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kɨni ai, Yesu rɨtərhav mɨn provins a Taea, kɨni meiwaiyu-pə mapita provins a Saedon, muə e Galili, mɨvən kwənmhan ehuə kɨrik nhagɨn e Dikapolis. ");
INSERT INTO nwi_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kɨni kharəh kəru kɨrik yame rɨpəh nəgkiarien, mhauə kɨmin. Mɨsaiyoh-pən Yesu mə tukrərəhu-pən kwermɨn ye yermamə ai, pəh rhuvə. ");
INSERT INTO nwi_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kɨni Yesu rɨvəh yermamə ai, mɨravən isok tuk narmamə, mɨvəhsi-pən kwənkwai kwermɨn ye nɨmətərgɨ yermamə ai, məjai kwənkwai kwermɨn, kɨni mɨrap neramɨ yermamə ai. ");
INSERT INTO nwi_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kɨni marha faktə ye neai, mərɨg kafan nərɨgien rɨpam, kɨni meihagh əpɨr. Kɨni mɨni-pən tuk yermamə ai mə, “!Efata!” (Nɨpran rɨmə, “!Ǝkwag!”). ");
INSERT INTO nwi_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Məknekɨn, nɨmətərgɨ yermamə ai rəkwag, kɨni neramɨn rɨhuatuk, məgkiar huvə. ");
INSERT INTO nwi_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kɨni Yesu rɨni-əhu əutən tuk narmamə mə tukhapəh nɨsəvsaoyen kɨn norien a. Mɨni-əhu əutən pawk, mərɨg iriə kɨsəvsao kɨn mamharpɨn. ");
INSERT INTO nwi_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kɨni iriə kɨsakur pɨk kɨn nɨmtətien a, mamhani mhamə, “Man. Kwən a rapita. Rɨrkun nar əfrakɨs. Ramor huvə kəru mɨnə mɨne narmamə khapəh nɨsəgkiarien.” ");
INSERT INTO nwi_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ye nɨpɨg a, narmamə khapsaah khauə mɨn mɨsəm Yesu. Iriə, nəriə nəvɨgɨnien rɨrkək. Ror pən Yesu rɨni-pən tuk kafan narmamə mɨnə mə, ");
INSERT INTO nwi_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Rɨkik reiwaiyu pɨk tuk narmamə mɨnə e. Kɨtawə miriə kasəmɨr nɨpɨg kɨsisər, kɨni nəriə nəvɨgɨnien rɨrkək. ");
INSERT INTO nwi_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","To yakher-pən kɨn əriə yerkwanu kamhavən, kɨrik rəmkərəv ye swatuk, nɨmrɨn rapɨg, kɨni rɨmɨr, meinai tɨksɨn kɨmnhasɨ-pən isok.” ");
INSERT INTO nwi_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kɨni narmamə kafan mɨnə khani-pən tukun mhamə, “?Tukhavəh hiə nəriə nəvɨgɨnien? Ikɨn eikɨn e kwənmhan əkwak.” ");
INSERT INTO nwi_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Kɨni Yesu raiyoh əriə mə, “?Mərɨg bred kuvhuun en?” Khamə, “Bred seven.” ");
INSERT INTO nwi_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kɨni Yesu rɨni-pən tuk narmamə ai mə, “Taksəkwətə.” Kɨni mɨvəh nɨpar bred ai, mɨni vi vi Kughen tukun, kɨni makapɨr-pɨr, məhi-pən kɨmi kafan narmamə mə tuksəvɨgɨn narmamə kɨn aikɨn. Kɨni ai iriə kɨsor. ");
INSERT INTO nwi_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kwaji kəmam tɨksɨn mɨn aikɨn. Yesu rɨni vi vi Kughen tukun, mɨni mə tukhavəhsi-pən mɨn kɨmi narmamə ai. ");
INSERT INTO nwi_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kɨni kɨsəvɨgən, tupriə rəsiis fam. Mɨsəpəh nɨpərpərɨn mhavai-pən ye kəmeiru ehuə seven. ");
INSERT INTO nwi_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Iriə kɨməsəvɨgən, narman əmə, rəmhen kɨn fo taosen. Kɨni Yesu rher rik rik kɨn əriə. ");
INSERT INTO nwi_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kɨni ai iriə kafan narmamə mɨnə, mhavən ye bot, mhavən apa kwənmhan ehuə kɨrik, nhagɨn e Dalmanuta. ");
INSERT INTO nwi_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kɨni ai, Farisi tɨksɨn khauə masəni-əhu Yesu mə to rapəh norien nɨmtətien kɨrik ye nɨmrɨriə ye nəsanɨnien kape Nanmɨn kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kɨni Yesu rɨkin rəpou, meihagh əpɨr, mɨni-pən tuk əriə mə, “?Rhawor e kɨmiə narmamə nakəsarə ye rao e, nakhamə taksəm nɨmtətien kɨrik? Yakamni-pre əfrakɨs tuk əmiə mə taktəkun ai, to nakhapəh nɨsəmien nɨmtətien kɨrik ror məknenkɨn.” ");
INSERT INTO nwi_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kɨni Yesu rəpəh namhajoun mɨnə a, matpən mɨn ye bot, məviəfugɨn-pən ye nɨkar lugun. ");
INSERT INTO nwi_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kɨni ai Yesu mɨne kafan narmamə mɨnə khavən ye bot, mɨsəru kɨn bred mhavəh əmə nɨpər bred kɨrikianə əmə. ");
INSERT INTO nwi_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kɨni Yesu rɨmnor kwirɨg kɨmi əriə ye nuhpɨkɨnien mɨmə, “Takasərɨg əmiə tuk ‘yis’ kape Farisi mɨnə, mɨne Herod.” ");
INSERT INTO nwi_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kɨni kɨnəsaiyoh əriə mɨnə kɨn nɨprai nuhpɨkɨnien a, mhamə, “?Tukmə ror kwən e rɨmə kɨmnhapəh nhavəhyen bred uə?” ");
INSERT INTO nwi_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Mərɨg Yesu ruɨrkun ta nərɨgien kapəriə. Mɨni-pən tuk əriə mə, “?Rhawor e nakasəm əmiə mɨnə mə bred rɨkək? ?Nakshawor mhapəh nɨsəm-huvəyen? ?Mɨshawor mhapəh nɨsərɨg-huvəyen? Kapəmia kapə rɨskai pɨk. ");
INSERT INTO nwi_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nɨmrɨmiə pawk əmə eikɨn, mərɨg nakhapəh nɨsəmien. Nɨmətərgɨmiə pawk əmə eikɨn, mərɨg nakhapəh nɨsərɨgien. Tukmə ror nakwəsərukɨn fam narɨmnar yame kɨtawə kɨmɨsor. ");
INSERT INTO nwi_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nɨpɨg yɨmɨvəh nɨpar bred kɨrkɨrɨp, makapɨr-pɨr, məhi-pən kɨmi narman faef taosen kɨsən, mərɨg kɨmɨsəpəh nɨpərpər nəvɨgɨnien, ?nakhavai-pən ye nɨtɨp kuvhuun?” Khamə, “Twelef.” ");
INSERT INTO nwi_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Kɨni rarə maiyoh mɨn əriə mə, “Nɨpɨg yɨmɨvəh nɨpər bred seven, məhi-pən kɨmi narman fo taosen kɨsən, kɨni mhapəh nɨpərpərɨn, ?nakhavai-pən ye kəmeiru kuvhuun?” Khamə, “Seven.” ");
INSERT INTO nwi_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Mərɨg əmə rɨni-pən tuk əriə mə, “?Mərɨg rhawor? ?Nakaseinein hanə Yo?” ");
INSERT INTO nwi_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kɨni ai khauə mhavhiak mɨn yerkwanu kɨrik nhagɨn e Betsaeda. Kɨni narmamə tɨksɨn kharəh nɨmrɨn pɨs kɨrik mhauə kɨmi Yesu mə tukrərəhu-pən kwermɨn iran. ");
INSERT INTO nwi_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kɨni Yesu rɨwəh kwermɨ yermamə ai mɨkɨr mɨravən isok tuk yerkwanu. Kɨni ai, rəjai nɨmrɨn, kɨni mərəhu-pən kwermɨn iran, mɨmə, “?Nakarha maməm nar uə nɨkam?” ");
INSERT INTO nwi_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Məknekɨn, yermamə ai rəm nar. Kɨni mɨmə, “Nəfrah, yakaməm narmamə kaseriwək. Mərɨg kɨsəm nəmhen əmə iriə nai mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kɨni Yesu rarə mərəhu-pən kwermɨn ye nɨmrɨn, kɨni ai yermamə ai rarha huvə. Kɨni nɨmrɨn rəmtɨr, məm huvə nar. ");
INSERT INTO nwi_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kɨni Yesu rher-pən kɨn mamni mɨmə, “Takvən apa imam ikɨn, mərɨg takpəh nɨvənien yerkwanu e nɨmasɨ-pən ikɨn.” ");
INSERT INTO nwi_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kɨni ai Yesu mɨne kafan narmamə khatərhav mɨn mhavən yerkwanu mɨnə ipakə tuk kwənmhan ehuə kɨrik nhagɨn e Sisaria Filipae. Kɨsəriwək mamhavən ye swatuk, Yesu ramaiyoh əriə mə, “?Mərɨg narmamə kamhani mə Yo e pa?” ");
INSERT INTO nwi_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kɨni khani-pən tukun mhamə, “Tɨksɨn khamə Ik e Jon Baptaes; tɨksɨn khamə Ik e Elaeja tu; kɨni tɨksɨn khamə Ik e profet kupən kɨrik kape Kughen.” ");
INSERT INTO nwi_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kɨni In raiyoh əriə mə, “?Mərɨg kɨmiə nakamhani mə Yo e pa?” Mərɨg əmə Pita rɨmə, “Ik e Kristo.” ");
INSERT INTO nwi_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kɨni ai Yesu rɨni-əhu əutən pən tuk əriə mə tukhapəh nhani-pənien tuk narmamə. ");
INSERT INTO nwi_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kɨni Yesu rɨrikakun maməvhag kɨmi kafan narmamə mɨnə mɨmə, “Yo, Ji Yermamə, jakərɨg nəmhəyen ye narɨmnar khapsaah. Nəmehuə kape nəmə mɨnə Isrel, mɨne jif pris mɨnə, mɨne namhajoun kape loa kape Moses, tuksəməkɨn Yo mhani mə Yo jakmhə. Mərɨg nɨpɨg kɨsisər tukruə mɨvən, kɨni Yo jakɨmragh mɨn.” ");
INSERT INTO nwi_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Rɨni-ərhav-pən huvə tuk əriə, məknekɨn Pita rɨkɨr In, mwapta irəriə, kɨni mamniəhu-pən nəgkiarien yame Yesu rɨmɨni. ");
INSERT INTO nwi_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mərɨg Yesu rarar, məm kafan narmamə mɨnə, mɨni-pən skai tuk Pita mɨmə, “!Setan! !Ap ikɨn e! Nərɨgien kafam rɨpəh nəmhenien kɨn nərɨgien kape Kughen. Nərɨgien əmə kape yermamə.” ");
INSERT INTO nwi_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesu rokrən kɨn narmamə mɨfam aikɨn a, mɨne narmamə kafan, khauə kɨni rɨni-pən tuk əriə mɨmə, “Tukmə yermamə rɨmə tukrɨkwasɨg kɨn Yo, tukraməkeikei məta ye nərɨgien kafan, kɨni tukmə rərɨg pawk nəmhəyen rəmhen kɨn nəmhəyen ye nɨmhəyen ye nai kamarkwao kɨn, mərɨg tukrɨkwasɨg kɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yermamə yame ramgɨn tuk kafan nɨmraghien, tukraməkeikei mɨmhə. Mərɨg yermamə yame tukhopni tuk nɨkwasɨgien kɨn Yo, tukrarə ye nɨmraghien rerɨn. ");
INSERT INTO nwi_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tukmə yermamə kɨrik kafan nautə rehuə pɨk ye tokrei tanə e, mərɨg in ramarakikɨn kafan nɨmraghien tukun, nanmɨn tukrerwei. ");
INSERT INTO nwi_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mərɨg nar kɨrik rɨrkək mɨn tuk nɨvəhyen nɨmrɨ nɨmraghien kafan. ");
INSERT INTO nwi_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Narmamə yame kasarə ye rao e kwəsəpəh Kughen masor pɨk təvhagə has. Tukmə nakaurɨs kɨn nɨni-ərhavyen nhagɨk mɨne nəgkiarien kafak ye nɨmrɨ mɨrh, Yo mɨn jakaurɨs kɨn nɨni-ərhavyen nhagɨm nɨpɨg Yo, Ji Yermamə, jakrerɨg-pə mɨn kɨmawə agelo rhakə mɨnə ye neihuəyen kape Rɨmɨk.” ");
INSERT INTO nwi_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kɨni Yesu rɨni-pən mɨn, “Yakamni-pre əfrakɨs tuk əmiə mə narmamə tɨksɨn kasarə ikɨn e to khapəh nhamhəyen mɨseriaji nɨpɨg narmamə tuksəm Kughen ravəh nehuəyen tuk narmaruyen ye narmamə.” ");
INSERT INTO nwi_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nɨpɨg sikis ruə mɨvən, Yesu rɨkɨr Pita, Jemes mɨne Jon mɨshaktə fiak ye tukwas apomh kɨrik. Irisɨr pɨsɨn əmə kɨmɨrhkwasɨg kɨn. Kharərer mhrəm mə nɨprai Yesu rukrekɨn muə mor pɨsɨn. ");
INSERT INTO nwi_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Neipən kafan rhawən pɨk. Kɨni to yermamə kɨrik ye tokrei tanə e rɨpəh norien neipən kɨrik rhawən məsiə məknakɨn. ");
INSERT INTO nwi_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kɨni yermamə misɨr ai kafan kɨrhəm yemasur kupən mir kape Kughen kɨraru, Elaeja mɨne Moses, kratərhav-pə mɨn, mawəgkiar irisɨr Yesu. ");
INSERT INTO nwi_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kɨni Pita rɨni-pən tuk Yesu mə, “Yhajoun, rhuvə mə kɨmasɨr jakrharə əmə ikɨn e. Pəh yakrharkwopək nimə kɨsisər: Kafam kɨrik, kape Moses kɨrik, kɨni kape Elaeja kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Khrɨgɨn, kɨni Pita rɨmnəgkiar apnapɨg əmə). ");
INSERT INTO nwi_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Məknekɨn napuə kɨrik reiwaiyu, muvrɨg əpɨs əriə. Kɨsərɨg nəgkiarien kɨrik rɨsɨ-pən ye napuə mɨmə, “In e Narɨk keikei yakorkeikei pɨk. !Taksətərɨg kɨn In!” ");
INSERT INTO nwi_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Məknekɨn, krharhaha, mrhɨpəh mɨn nɨrhəmien əriu. Yesu pɨsɨn əmə ramərer. ");
INSERT INTO nwi_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kɨni khasɨ-faktə ye tukwas, Yesu rɨmɨni-əhu əutən pən tuk ərisɨr mɨmə, “Takrhɨpəh nɨrhəvsaoyen kɨn mɨrheriaji Yo, Ji Yermamə, jakɨmragh mɨn ye nɨmhəyen kafak.” ");
INSERT INTO nwi_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kɨni irisɨr kɨmɨrhɨvəh tɨm tɨm nəgkiarien kape Yesu, mərɨg irisɨr atuk əmə kɨrhaiyoh ərisɨr mɨnə mɨrhɨmə, “?Nəgkiarien e ramni, tukrɨmhə mɨmragh mɨn, nɨpran ramni naha?” ");
INSERT INTO nwi_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kɨni kɨnɨrhaiyoh Yesu mɨrhɨmə, “?Rhawor nəmhajoun kape loa kape Moses khamə Elaeja tukraməkeikei muə məkupən kɨn Kristo?” ");
INSERT INTO nwi_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Kɨni Yesu rɨmə, “Nəfrakɨs. Elaeja rɨmnəkupən muə tuk nətu-huvəyen narɨmnar fam. ?Mərɨg rhawor Nəkwəkwə kape Kughen rɨmə ‘Narmamə tuksəməkɨn Ji Yermamə kɨni tukrərɨg nəmhəyen ye narɨmnar rɨpsaah?’ ");
INSERT INTO nwi_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mərɨg yakamni-pre tuk əmiə mə Elaeja ruauə ta. Kɨni narmamə kasəri-pən nərɨgien kapəriə mɨsor ahas pən tukun, rəmhen kɨn yame Nəkwəkwə kape Kughen rɨmɨni.” ");
INSERT INTO nwi_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Irisɨr krhuə iriə narmamə mɨnə kape Yesu, mɨsəm mɨn narmamə khapsaah. Namhajoun kape loa kape Moses, mɨne narmamə kape Yesu kasotgoh kɨmi əriə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Məknekɨn mɨsəm Yesu, kɨsakur, kɨni mɨsaiyu mhavən tukun mɨsətərum-pən iran. ");
INSERT INTO nwi_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kɨni Yesu raiyoh kafan narmamə mɨmə, “?Nakasotgoh kɨmi nəmə mɨnə e tuk naha?” ");
INSERT INTO nwi_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kɨni mərɨg yermamə kɨrik ruə mɨni-pən tukun mə, “Yhajoun, yo yɨmɨrəh kafak pɨkwarien muə mə jakəm Ik, meinai nanmɨn has raməmɨr iran, mamor in reinein nəgkiarien. ");
INSERT INTO nwi_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tukmə nanmɨn has rərer-pən pɨk iran, kɨni maməsuə kɨn, ramɨmɨr-pən ye nɨmoptanə. Nehe nəkwan ramtərhav, mamoh kwəruə, kɨni nɨpran rɨkɨmkɨm pɨk. Kɨni yakaiyoh-pən kafam narmamə mə tuksəko-ta nanmɨn has, mərɨg kaseinein.” ");
INSERT INTO nwi_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kɨni Yesu rɨni-pən tuk əriə mə, “!Kəsi! Kɨmiə yamə mɨne naksarə e towei, nhatətəyen kapəmiə rɨrkək. ?Kɨtawəm kɨmiə tuksarə mɨseriaji naha nɨpɨg nakpishatətə irak? Harəh pɨkwarien en mhauə.” ");
INSERT INTO nwi_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kɨni kharəh mhauə kɨmin. Nɨpɨg nanmɨn has rɨmnəm Yesu, məkneikɨn ror pɨkwarien a rətəmnɨmɨn, maməsok-əsok ye nɨmoptanə. Kɨni nehe nəkwan ramtərhav rhawən. ");
INSERT INTO nwi_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kɨni Yesu raiyoh-pən rɨm pɨkwarien mə, “?Rɨmnor məknekɨn m-kɨvhuun ai taktəkun?” Kɨni rɨni-pən tukun mə, “Rɨmnamarkəskəh mɨrikakun. ");
INSERT INTO nwi_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nɨpɨg rɨpsaah nanmɨn has raməsuə-pən kɨn ye nap uə ye nu, mamarkut mə tukrɨmhə. Tukmə nakɨrkun nasituyen, rɨkim reiwaiyu tuk əmawə, kɨni masitu.” ");
INSERT INTO nwi_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Kɨni Yesu rɨni-pən tukun mə, “?Nakhawor mamaiyoh mə yakɨrkun nasituyen uə? Yakɨrkun norien narɨmnar fam kɨmi narmamə yamə mɨne kashatətə irak.” ");
INSERT INTO nwi_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Məknekɨn, rɨm pɨkwarien ai rok-rapomh mɨni mə, “Yakamhatətə, mərɨg kafak nhatətəyen rarkəskəh. !Takor yo mə jakhatətə pɨk mɨn iram!” ");
INSERT INTO nwi_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kɨni Yesu rəm mə narmamə kamhauə ipakə tukun, kɨni rəgkiar pən skai kɨmi nanmɨn has mɨmə, “Ik nanmɨn hah. Nɨmətərgɨm rəru. Nakeinein nəgkiarien. Yakamni-pre tuk ik mə takəta ye pɨkwarien e, mɨpəh mɨn nuəyen tukun.” ");
INSERT INTO nwi_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Məknekɨn nanmɨn ai rok-rapomh mor nɨprai pɨkwarien ai rətəmnɨmɨn kɨni məta iran. Kɨni iriə kɨsəm nɨprai pɨkwarien ai mamhani mhamə, “Ruamhə əgkəp.” ");
INSERT INTO nwi_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mərɨg Yesu rɨvəh kwermɨn, mɨvi haktə, kɨni rhekɨmter. ");
INSERT INTO nwi_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kɨni Yesu rauru-pən mɨn imə, iriə pɨsɨn əmə kafan narmamə mɨnə kɨnh kɨsaiyoh In mhamə, “?Kɨmawə yakshawor mɨseinein nəkotayen nanmɨn has a?” ");
INSERT INTO nwi_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Kɨni Yesu rɨmə, “Nanmɨn has yamə mɨne kɨsor məknekɨn, nəhuakien pɨsɨn əmə rɨrkun nəkotayen əriə.” ");
INSERT INTO nwi_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kɨni khatərhav-pən mɨn aikɨn mamhavən mɨsapita yerkwanu mɨnə e Galili. Mərɨg Yesu rɨpəh norkeikeiyen mə narmamə tukharkun kwənmhaan yame In ramarə ikɨn, ");
INSERT INTO nwi_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","meinai In raməwhag kɨmi kafan narmamə mɨnə mamni mə, “Yermamə kɨrik tɨkreighan-pən kɨn Yo, Ji Yermamə, ye kwermɨ tɨkmɨr mɨnə kafak. Mərɨg tukshopni pawk Yo, tukreriaji nɨpɨg kɨsisər, Kughen tukror mɨn Yo yakɨmragh.” ");
INSERT INTO nwi_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mərɨg narmamə mɨnə kafan khapəh nharkunien nɨprai nəgkiarien a. Mhagɨn mɨn kɨn naiyohyen kɨn nɨpran. ");
INSERT INTO nwi_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kɨni khatərhav-pə mɨn ye yerkwanu kɨrik, nhagɨn a Kapaneam, mhavən ye nəkwai nimə. Kɨni Yesu rɨmnaiyoh kafan narmamə mɨmə, “?Naksəriwək ye swatuk, masotgoh kɨmi əmiə mɨnə tuk naha?” ");
INSERT INTO nwi_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kɨni iriə khapəh nhaniyen nar kɨrik tukun meinai kɨmnamhauə ye swatuk masotgoh mə iriə pa nhagɨn in rehuə rapita əriə mɨnə tɨksɨn. ");
INSERT INTO nwi_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kɨni Yesu rɨtei-əhu məkwətə mokrən kɨn kafan narmamə twelef khauə, kɨni mɨni-pən tuk əriə mə, “Tukmə kɨmiə kɨrik rɨmə tukreihuə mapita narmamə, kafan nərɨgien tukraməkeikei meiwaiyu əgkəp. Kɨni mamor atuə kɨn əmə kape narmamə.” ");
INSERT INTO nwi_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kɨni rɨrəh kwajikovə kɨrik mərɨp in ye kwerkwan irəriə. Mɨrəh-si haktə, mɨni-pən tuk əriə mɨmə, ");
INSERT INTO nwi_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Yermamə yame ravəh nhagɨk, mamasitu kɨn ye kwajikovə kɨrik rəmhen kɨn yame, nasituyen e in e tukror mɨn kɨmi Yo. Kɨni pəh nien mə ramasitu əmə irak, mərɨg ramor mɨn kɨmi Yermamə yame rɨmnher-pə kɨn Yo.” ");
INSERT INTO nwi_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kɨni Jon rɨni-pən tuk Yesu mə, “Yhajoun. Yermamə kɨrik e yakasəm rawəh nhagɨm maməkota nanmɨn has kɨn ye narmamə. Kɨni yakhani-əhu meinai rɨpəh nien mə kɨtawə kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Mərɨg Yesu rɨni-pən tukun mə, “Takhapəh nhani-əhuyen. Yermamə yame rawəh nhagɨk mamor nɨmtətien kɨn, to rɨpəh narar-mɨnien mɨni has nhagɨk. ");
INSERT INTO nwi_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yermamə yame rɨpəh nɨni-hasien ətawə, in kɨtawə kɨrik. ");
INSERT INTO nwi_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nəfrakɨs, yermamə yame ravəh nu ye pənkɨn, mɨvəhsi-pre kɨmi əmiə meinai kafak e kɨmiə, kɨni Yo e Kristo, kɨni kwən en, tukrɨvəh əfrakɨs nərokien iran.” ");
INSERT INTO nwi_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kɨni Yesu rɨni mɨn mə, “ Mərɨg tukmə yermamə kɨrik ravi-pən kwajikovə kɨrik yame rhatətə irak, mə tukror təvhagə has, kɨni yermamə a, Kughen tukror narpɨnien ehuə kɨmin. Kɨni narpɨnien a tukrɨskai rapita yame kɨruk-pən kapier kɨrik ye nɨpətək nuan, karkwərhao kɨn apa ye tame tahik mə tukrəmnɨm. ");
INSERT INTO nwi_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kɨni tukmə kwermɨm ramor nakamor təvhagə hah, rhuvə mə takərəru ta. Rhuvə pɨk mə takpəh kwermɨm kɨrikianə mamragh kɨn kape rerɨn. Yame rhuvə pɨk rapita yame takvən ye nap ehuə kɨn kwermɨm kwis mir, yame nap to rapəh nɨpɨsien. ");
INSERT INTO nwi_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","In aikɨn, sɨrət mɨnə to khapəh nhamhəyen, kɨni nap mɨn to rapəh nɨpɨsien. ");
INSERT INTO nwi_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kɨni tukmə nɨhum ramor nakamor təvhagə hah, rhuvə mə takərəru ta. Rhuvə pɨk mə takpəh nɨhum kɨrikianə, mamragh kɨn kape rerɨn. Rapita yame takvən ye nap ehuə kɨn nɨhum kwis mir. ");
INSERT INTO nwi_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","In aikɨn, sɨrət mɨnə to khapəh nhamhəyen, kɨni nap mɨn to rapəh nɨpɨsien. ");
INSERT INTO nwi_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kɨni tukmə nɨmrɨm ramor nakamor təvhagə hah, rhuvə mə takɨkum ierɨg ta. Rhuvə pɨk mə takpəh nɨmrɨm kɨrikianə mɨvən kɨn apa ye rao ye neai. Rapita yame takvən ye nap ehuə kɨn nɨmrɨm kwis mir. ");
INSERT INTO nwi_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","In aikɨn “‘Sɨrət mɨnə to khapəh nhamhəyen, Kɨni nap mɨn to rapəh nɨpɨsien.’ ");
INSERT INTO nwi_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Nap tukrəsaah-əsaah pən ye narmamə fam rəmhen kɨn yame kaməviətəg-pən nɨgar ye nəvɨgɨnien. ");
INSERT INTO nwi_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nɨgar in nar huvə kɨrik. Kɨni mərɨg tukmə nɨgar rəhiu pɨk, ?tukhawor kor rhekɨn mɨn? Pəh narəyen kapəmiə tukrheikən, kɨni takasarə ye nəmərinuyen.” ");
INSERT INTO nwi_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kɨni Yesu rarə mɨtərhav mɨn aikɨn mɨvən provins e Judia, mɨvən maməmɨr apa nɨkar nu kɨrik nhagɨn e Jodan. Kɨni narmamə khapsaah kɨmnhauə mɨn masəm In. Kɨni In raməvhag kɨmi əriə, rəmhen kɨn yame In ramor rerɨn. ");
INSERT INTO nwi_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kɨni Farisi tɨksɨn khauə masaiyoh Yesu kɨn naiyohyen əutən kɨrik mə tuksəm-ru mə tukrɨni nəgkiarien kɨrik rapəh nəmhenien. Mhani-pən tukun mhamə, “?Rhawor tukmə yerman rəpəh kafan piraovɨn? ?Ramakapɨr loa uə nɨkam?” ");
INSERT INTO nwi_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Kɨni Yesu raiyoh-pən əriə mɨmə, “?Naha e loa Moses rɨmɨvəhsi-pre kɨmi əmiə məkupən?” ");
INSERT INTO nwi_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kɨni iriə khamə, “Moses rɨmneighan kɨn mə yerman rɨrkun nɨraiyen nəkwəkwə tuk nəpəhyen kafan piraovɨn mɨvəhsi-pən kɨmin, kɨni məpəh in.” ");
INSERT INTO nwi_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “Moses rɨmɨrai loa en meinai kapəmia kapə rɨskai pɨk. ");
INSERT INTO nwi_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mərɨg kupən, nɨpɨg Kughen rɨmnərəhu nɨmoptanə, ‘In mor mɨn yerman mɨne piraovɨn.’ ");
INSERT INTO nwi_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ror məknakɨn mə yerman tukrəta ye rɨmni mɨne nɨsɨni, kɨni iriu piraovɨn mwarə kɨrikianə. ");
INSERT INTO nwi_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","‘Tukwarə mə nɨprairiu kɨrikianə.’ Kɨni iriu kwis tukwarə kɨrikianə. ");
INSERT INTO nwi_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Meinai Kughen rɨməviəfugɨn məknakɨn əriu, yermamə to rɨpəh nakapɨrien narəyen kapəriu.” ");
INSERT INTO nwi_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kɨni ai, Yesu mɨne kafan narmamə kharerɨg-pə yerkwanu, kɨni iriə kɨsaiyoh-pən mɨn kɨn. ");
INSERT INTO nwi_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kɨni In rɨni-pən mɨn tuk əriə mɨmə, “Yerman yame rapəh kafan piraovɨn mamvən mamarkurək-pən mɨn ye piraovɨn pɨsɨn, ramor təvhagə hah ye kafan hanə piraovɨn. ");
INSERT INTO nwi_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kɨni piraovɨn yame rəpəh kafan yerman, kɨni mɨvən mamarkurək-pən mɨn ye yerman pɨsɨn, in mɨn ramor təvhagə has ye kafan hanə yerman.” ");
INSERT INTO nwi_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kɨni narmamə tɨksɨn khapɨk kapəriə kwajikovə mɨnə, mhauə mɨsəm Yesu, mə In tukrərəhu-pən kwermɨn irəriə, mɨvəhsi-pən nɨhuvəyen kɨmi əriə. Mərɨg narmamə mɨnə kape Yesu kɨmnhani-əhu əriə. ");
INSERT INTO nwi_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kɨni Yesu rəm, niemhaa rhai In, kɨni məgkiar skai pən kɨmi əriə mɨmə, “Takhapəh nhani-əhuyen kwajikovə mɨnə. Səta irəriə pəh khauə tuk Yo. Meinai Kughen tukramarmaru ye narmamə yamə mɨne kɨsəmhen kɨn kwajikovə mɨnə en. ");
INSERT INTO nwi_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yakamni-pre əfrakɨs tuk əmiə mə yermamə yame rɨkin rɨpəh nagienien tuk nɨvəhyen kafan nərɨgien rewaiyu rəmhen kɨn kwajikovə, to rapəh nɨvənien ye Rao ye Neai.” ");
INSERT INTO nwi_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kɨni In mɨpɨk kwajikovə mɨnə kɨni mərəhu-pən kwermɨn irəriə, kɨni mɨvəhsi-pən nɨhuvəyen kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kɨni Yesu rarə, mapitan kɨn əriə, kɨni yermamə kɨrik raiyu muə məm. Kɨni mənɨmkur ye nɨmrɨn. Mɨni-pən tukun mɨmə, “Yhajoun huvə. ?Nakmə jakaməkeikei mor naha mɨne yakamarə rerɨn?” ");
INSERT INTO nwi_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Kɨni Yesu rɨmə, “?Nakhawor mamni mə Yo yakhuvə? Yermamə kɨrik rapəh nɨhuvəyen. Kughen əmə In rhuvə. ");
INSERT INTO nwi_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ik nakwɨrkun ta loa yame Moses rɨmɨni mə, ‘Takpəh nhopniyen yermamə. Kɨni mɨpəh napɨr-pənien tuk piraovɨn pɨsɨn. Kɨni mɨpəh nəkrəhyen. Kɨni mɨpəh nɨni-apnapɨgien nar meikuə kɨn ye yermamə kɨrik. Kɨni mɨpəh neikuəyen kɨn nəkrəhyen. Tuk nɨpɨg mɨnə fam takamsiai rɨmɨm mɨne nɨsɨnɨm.’” ");
INSERT INTO nwi_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kɨni kwən ai rɨni-pən tukun mɨmə, “Yhajoun. Loa mɨnə en, yakaməri-pən fam ye nəkəskəhyen kafak, muə meriaji-pə.” ");
INSERT INTO nwi_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Kɨni Yesu rəm tɨm tɨm kwən ai, kɨni morkeikei pɨk. Mɨni-pən tukun mɨmə, “Nar kɨrikianə əmə ik nakpəh nor-hanəyen. Takvən, məvrai rik rik kafam narɨmnar, mɨvəh mane iran, kɨni mɨvəhsi-pən kɨmi yavən has mɨnə. Kɨni kafam narɨmnar tukrɨpsaah apa ye rao ye neai. Kɨni ik muə, mɨkwasɨg kɨn Yo.” ");
INSERT INTO nwi_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nɨpɨg kwən ai rɨmnərɨg nəgkiarien yame Yesu rɨmɨni, rɨkin rəpou, meinai kafan nautə rɨpsaah. Rarar map ta ye Yesu. ");
INSERT INTO nwi_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kɨni Yesu rarha-pən məm kafan narmamə kɨni mɨni-pən tuk əriə mɨmə, “!Man! Rɨskai pɨk tuk narmamə yamə mɨne kapəriə nautə rehuə tuk nɨvənien pəh Kughen rarmaru irəriə.” ");
INSERT INTO nwi_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kɨni kafan narmamə kɨsakur kɨn nəgkiarien ai. Kɨni in rarə mɨni-pən mɨn tuk əriə mɨmə, “Kwajikovə kafak mɨnə, rəutən pɨk tuk yermamə tuk nɨvənien pəh Kughen rarmaru iran. ");
INSERT INTO nwi_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","?Nakasərɨg mə narmɨragh ehuə kɨrik, kamni kɨmə kamel, to rauru-pən ye kwəruwei nidil uə? Nɨkam, rəutən pɨk. Rəmhen əmə mɨn kɨn yermamə yame kafan nautə rehuə, rəutən pɨk tukun tuk nətayen aikɨn a pəh Kughen ramarmaru iran.” ");
INSERT INTO nwi_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kɨni narmamə kafan mɨnə kɨsakur, mɨnəsaiyoh əriə mɨnə, mhamə, “!Eh! ?Mərɨg tukmə ror məknekɨn, kɨtawə pa in tukramarə ye nɨmraghien rerɨn?” ");
INSERT INTO nwi_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Mərɨg Yesu rəm tɨm tɨm əriə mɨni-pən tuk əriə mə, “Nar e, to yermamə rɨpəh norien. Kughen pɨsɨn əmə In rɨrkun norien. Meinai In rɨrkun norien narɨmnar fam.” ");
INSERT INTO nwi_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kɨni Pita rhekɨmter maiyoh mɨn mɨmə, “?Mərɨg rhawor irəmawə? Yɨməsəpəh fam kapəmawə narɨmnar, mhauə, mhakwasɨg kɨn Ik.” ");
INSERT INTO nwi_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Kɨni Yesu rɨni-pən tukun mə, “Yermamə yame in ravəh əkupən Yo, kɨni maməta ye kafan narɨmnar rəmhen kɨn nimə, uə piauni, uə kafan kakə, uə rɨmni mɨne nɨsɨni, uə kafan kwajikovə, uə nəsimien kafan tuk nɨni-ərhavyen Nəgkiarien Huvə kape Kughen, ");
INSERT INTO nwi_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","narɨmnar a to khapəh nharkək-mɨn-ien tukun. Yermamə ai, tukrɨvəh tain ye tokrei tanə e rəmhen kɨn wan handred, rəmhen kɨn nimə, mɨne piauni, mɨne nɨsɨni, mɨne kafan kakə, mɨne kafan kwajikovə, mɨne nəsimien kafan (mərɨg tukhauh mɨn in). Kɨni ye narəyen vi kafan, tukrarə ye nɨmraghien rerɨn. ");
INSERT INTO nwi_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mərɨg, narmamə mɨnə e kasəkupən tukpihamakwasɨg, kɨni yamə mɨne kamhakwasɨg tukpihauə mɨpisəkupən.” ");
INSERT INTO nwi_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kɨni Yesu mɨne kafan narmamə kɨshaktə mhavən Jerusalem. Yesu rɨkɨr əriə mhavən. Kɨni kafan narmamə kɨsakur pɨk. Kɨni narmamə apnapɨg tɨksɨn yamə mɨne kɨmnhakwasɨg kɨn əriə, kɨmnhagɨn mɨn. Kɨni Yesu rokrən kɨn kafan narmamə twelef mə tukhauə kɨrikianə. Kɨni mɨni-ərhav narɨmnar yame tukrɨtərhav-pən tukun. ");
INSERT INTO nwi_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kɨni mɨni-pən mɨmə, “Taksərɨg-ru. Taktəkun ai kamhavən Jerusalem. Kɨni ikɨn aikɨn a, narmamə tɨksɨn tuksərəhu-pən Yo, Ji Yermamə, ye kwermɨ Jif Pris mɨne namhajoun kape loa kape Moses. Kɨni iriə tukhauh Yo mə tukshopni Yo. Mɨseighan-pən kɨn Yo kɨmi narmamə mɨnə e pəh nien mə nəmə Isrel, ");
INSERT INTO nwi_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","pəh tuksarh iakei irak, kɨni mɨsərɨg-əvhin əpəs Yo, mɨsərkɨs-ərkɨs Yo, kɨni mɨshopni Yo. Kɨni mərɨg jakamragh mɨn ye nɨpɨg yame ror kɨsisər kɨn.” ");
INSERT INTO nwi_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kɨni ai, Jemes mɨne Jon, kwajikovə mir kape Sebedi, kɨrauə mwəm Yesu, mɨrəni-pən tukun mɨrəmə, “Yhajoun, yakworkeikei nar kɨrik mə takor kɨmi əmru.” ");
INSERT INTO nwi_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Kɨni Yesu raiyoh mə, “?Nakworkeikei naha?” ");
INSERT INTO nwi_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kɨni krəmə, “Yakworkeikei mə kɨmru kɨrik tukrəkwətə ye nɨkarɨm matuk, kɨni kɨrik tukrəkwətə ye mawor, nɨpɨg Ik takvəh nehuəyen kape narmaruyen.” ");
INSERT INTO nwi_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Mərɨg Yesu rɨni-pən tuk əriu mə, “Kɨmiru nakawaiyoh-pə kɨn nar kɨrik yame nakweinein. ?Kɨmiru nakramə nakwəmhen mə takwərɨg mɨn nəmhəyen ye nɨpraimiru rəmhen kɨn yame Yo jakərɨg uə? ?Uə nakramə kɨmiru nakwəmhen mə takwarə ye nɨpɨg əutən rəmhen kɨn yame Yo jakarə iran?” ");
INSERT INTO nwi_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Kɨni iriu kramə, “Ǝhə. Kɨmru yakwəmhen.” Kɨni Yesu rɨni-pən mə, “Nəfrakɨs. Kɨmiru nakrarkun nɨwərɨgien nəmhəyen rəmhen kɨn yame Yo jakərɨg. Kɨni kɨmiru nakrarkun mɨn narəyen ye nɨpɨg əutən rəmhen kɨn yame Yo jakarə iran. ");
INSERT INTO nwi_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mərɨg nar yame nakwaiyoh kɨn, mə kɨrik tukrəkwətə ye nɨkarɨk matuk, kɨni kɨrik ye mawor, Yo yakeinein nɨvəhsi-preyen. Mərɨg Kughen rɨmɨvəhsi-pən kwənmhan mir e kɨmi narmamə yamə mɨne In rɨmɨni-ta mɨmə iriə tuksəkwətə ikɨn.” ");
INSERT INTO nwi_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nɨpɨg narmamə mɨnə tɨksɨn kape Yesu, iriə ten, kɨsərɨg nəvsaoyen kɨn nar yame Jemes mɨne Jon kwaiyoh kɨn, niemhaa rhai əriə tukun. ");
INSERT INTO nwi_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kɨni Yesu rokrən kɨn əriə mə tukhauə mɨsəm. Mɨni-pən tuk əriə mə, “Kɨmiə nakwənharkun ta norien kape nəmehuə yamə mɨne pəh nien mə nəmə Isrel. Iriə kasor əutən pɨk tuk kapəriə narmamə mɨnə. Kɨni kapəriə nəmehuə mɨnə kasəviətərəkɨn-əhu pɨk əriə mhamə tukamhakwasɨg əmə kɨn əriə. ");
INSERT INTO nwi_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mərɨg rɨpəh natuatukien mə kɨmiə taksor məknakɨn. Tukmə kɨmiə kɨrik rorkeikei mə tukrɨvəh nehuəyen rapita əmiə mɨnə tɨksɨn, nərɨgien kafan tukreiwaiyu muə mə in yor atuə kɨn kɨrik kapəmiə. ");
INSERT INTO nwi_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kɨni tukmə kɨmiə kɨrik rorkeikei mə tukramkɨr əmiə maməkupən, in mɨn tukruə rəmhen kɨn yasitu kapəmiə fam ");
INSERT INTO nwi_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","meinai Yo mɨn, Ji Yermamə, pəh nien mə yɨmauə mə narmamə tuksor atuə kɨn kafak. Mərɨg yɨmauə mə jakor atuə kɨn kapəriə, kɨni moriah kafak nɨmraghien marpɨn nɨmraghien kɨn kape narmamə fam.” ");
INSERT INTO nwi_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kɨni Yesu mɨne kafan narmamə khauə yerkwanu kɨrik nhagɨn e Jeriko. Mɨsarə, mhatərhav mɨn, narmamə khapsaah kɨmnhakwasɨg kɨn. Kɨni nɨmrɨn pɨs kɨrik ramkwətə ye nɨkar swatuk. Nhagɨn e Batimeas. (In kwajikovə kape Timeas). Nɨpɨg fam in ramawə-pən kɨn mane tuk narmamə. ");
INSERT INTO nwi_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kɨni nɨpɨg in rɨmnərɨg mə Yesu, yemə Nasaret, ramuə, ramokrən kɨn mamni mə, “!Yesu! !Kwənərəus kape King Deved! Yakorkeikei mə rɨkim tukreihuə tuk yo.” ");
INSERT INTO nwi_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kɨni narmamə khapsaah kɨsəgkiar-pən skai kɨmin, mhamə, “!Ah! Pim.” Mərɨg in ramrɨrpɨn əmə ye nokrənien. Mamni mə, “!Kwənərəus kape King Deved! Yakorkeikei mə rɨkim tukreihuə tuk yo.” ");
INSERT INTO nwi_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kɨni Yesu rarar, mɨni-pən tuk əriə mɨmə, “Hani-pən tukun mə ruə.” Kɨni iriə khavən mɨsokrən kɨn nɨmrɨn pɨs ai, mhamə, “Eh. Agien. Yuvən. Ramokrən kɨn ik.” ");
INSERT INTO nwi_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kɨni nɨmrɨn pɨs a rarar məknekɨn məpəkiək-ta kɨn kafan kot, kɨni mɨvən məm Yesu. ");
INSERT INTO nwi_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Kɨni Yesu rɨni-pən tukun mə, “?Nakmə jakor naha nhagɨn kɨmik?” Kɨni rɨni-pən tukun mə, “Yhajoun. Yakorkeikei mə nɨmrɨk tukrarha, pəh yakəm nar.” ");
INSERT INTO nwi_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kɨni Yesu rɨni-pən tukun mə, “Rhuvə əmə. Takamvən. Nhatətəyen kafam rɨmnor ik nakwahuvə mɨn.” Məknekɨn nɨmrɨn rarha. Kɨni rəm nar. Kɨni ai in mɨkwasɨg kɨn Yesu. ");
INSERT INTO nwi_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kɨnəmhavən pakə tuk Jerusalem, mhatərhav-pən yerkwanu mir kɨraru, nhagriu e Betfas mɨne Betani, ipakə tuk tukwas kɨrik nhagɨn e Olif. Kɨni Yesu rher-pən kɨn yermamə kɨraru kafan, mɨmə ");
INSERT INTO nwi_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Takravən yerkwanu a nakaravaag-pən ikɨn. Mwəm kwaji dongki kɨrik kɨpəh nəsuə-hanəyen iran, kɨmɨrkwəji. Nakrarsɨn, mwəsɨg mɨrauə. ");
INSERT INTO nwi_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kɨni tukmə yermamə kɨrik raiyoh-pre əmiru mɨmə, ‘?Nakwhawor mawor məknekɨn?’ Nakrani-pən tukun mɨrəmə, ‘Yermaru rɨmə tukrəsuə ye dongki e. Pəh nien mə tuk tu, rarpɨn-pre mɨn.’” ");
INSERT INTO nwi_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kɨni ai, kɨravən mwəm kwaji dongki ai ramərer ye nɨkar swatuk. Kɨmɨrkwəji ipakə tuk kwəruə ye nimə kɨrik. Kɨni kɨrarsɨn, ");
INSERT INTO nwi_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","narmamə tɨksɨn kasərer aikɨn mɨnəsaiyoh əriu mhamə, “Eh. Kwərə mir. ?Nakwhawor marɨrsɨn dongki e?” ");
INSERT INTO nwi_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kɨni iriu krəni-pən nəgkiarien yame Yesu ruɨni-pən ta tuk əriu. Kɨni nəmə mɨnə ai kɨseighan kɨn. ");
INSERT INTO nwi_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kɨrarəh dongki ai mɨrauə mwəm Yesu. Mɨravəhsi-ta kot kapəriu mawəpeinə-pən ye nɨmetai dongki. Kɨni Yesu rəsuə iran. ");
INSERT INTO nwi_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Narmamə khapsaah kɨsətu kot kapəriə mɨmhahuvə-pən kɨn kɨmi swatuk; kɨni mɨsərai nɨmar nai mɨsətu-pən mɨn ye swatuk. ");
INSERT INTO nwi_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Narmamə yamə mɨne kasəkupən kɨn Yesu kɨni mɨne yamə mɨne kɨmnhakwasɨg kɨn kasokrən ehuə mamhani, “!Səgnəgɨn Kughen! Pəh khawəhsi-haktə Kwən e ramuə ye nhag Yermaru. ");
INSERT INTO nwi_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Narmaruyen kupən kape kapətawə kaha Deved ruauə mɨn. !Səgnəgɨn Kughen yerpɨrɨg!” ");
INSERT INTO nwi_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kɨni Yesu rɨtərhav-pən Jerusalem mɨvən ye nimə ehuə kape Kughen, kɨni mamətamə. Rɨnenaiyu ta, iriə kafan narmamə twelef, kharerɨg-pən mɨn yerkwanu kɨrik, nhagɨn e Betani. ");
INSERT INTO nwi_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kəni rɨkwamer kɨn, iriə khatərhav mɨn Betani, kɨni Yesu rɨmnəmkərəv. ");
INSERT INTO nwi_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kɨni məm nai e figtri, ramərer, nɨmarɨn rɨpsaah. Rəriwək mɨvən pakə tukun, məm nɨmarɨn in əmə e in əmə. Rɨmə-ta tukrəm kwənkwan kɨrik, mərɨg kwənkwan rɨrkək, meinai rɨpəh neriaji-hanəyen nɨpɨg tukrɨkuə iran. ");
INSERT INTO nwi_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kɨni Yesu rəgkiar-pən kɨmi figtri a mɨmə, “Yermamə tukrɨpəh mɨn nənien kwənkwam tuk nɨpɨg kɨrik.” Narmamə kafan mɨnə kɨsərɨg nəgkiarien ai. ");
INSERT INTO nwi_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nɨpɨg khatərhav-pən Jerusalem, Yesu rɨvən ye nimə ehuə kape Kughen. Kɨni mɨnaməko yerhav narmamə yamə mɨne kasor salem kɨn narɨmnar, mɨne yamə mɨne kasəvrə. Kɨni mərakita kɨn narɨmnar yame ramswin haktə ye tebol kape narmamə yamə mɨne kasor jenis ye mane; kɨni məsuə kɨn jea kape narmamə yamə mɨne kasor salem kɨn mak ye tanə. ");
INSERT INTO nwi_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kɨni mɨni-əhu mə narmamə tukhapəh nhapɨkien narɨmnar mhavən ye Nimə Ehuə kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kɨni mor kwirɨg kɨmi əriə mɨmə, “Kɨmɨrai ye Nəkwəkwə kape Kughen kɨmə, ‘Nimə Ehuə kape Kughen, nimə kape nəhuakien kape narmamə mɨnə fam rarkurao ye tanɨmtanə.’ Mərɨg kɨmiə naksor ruə rəmhen kɨn ‘nimə yame yəkrəh mɨnə kaserkwaig ikɨn.’” ");
INSERT INTO nwi_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yesu rɨnaməgkiar, kɨni narmamə kɨsakur kɨn, mɨsagien tukun. Ror pən, jif pris mɨnə, mɨne nəmhajoun kape loa kape Moses, kɨmnhagɨn kɨn, masarhakɨn swatuk tuk nhopniyen. ");
INSERT INTO nwi_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mərɨg rɨnamenaiyu, Yesu mɨne kafan narmamə mɨnə khatərhav mɨn aikɨn. ");
INSERT INTO nwi_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kɨni rɨkwamer kɨn, yenpɨg-enpɨg, kɨsəri-pən mɨn swatuk ai, mhauə mɨsəm nai ai figtri. Rɨnaukei mɨnəriaji nuan mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Kɨni Pita, rɨkin raiyu məsɨk nəgkiarien kape Yesu. Mɨni-pən tukun mə, “!Yhajoun, əmru! Nai e nɨmɨni has, rɨnaukei.” ");
INSERT INTO nwi_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Kɨni Yesu rɨni-pən tuk əriə mə, “Takshatətə ye Kughen. ");
INSERT INTO nwi_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yakamni-pre əfrakɨs tuk əmiə, mə tukmə kɨmiə kɨrik rhatətə huvə ye Kughen, mɨni-pən tuk tukwas e mə tukraiyu məsok pirə ye tahik məmnɨm, mɨpəh nɨniyen ye rɨkin kɨraru, mhatətə əmə ye Kughen, kɨni nar en tukror əfrakɨs. ");
INSERT INTO nwi_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ror pən, yakamni-pre tuk əmiə mə tukmə naksəhuak, narɨmnar nakasaiyoh kɨn kɨmi Kughen, takhani nəfrakɨsien iran mə takhavəh, kɨni en mhavəh. ");
INSERT INTO nwi_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tukmə naksəhuak, mərɨg tukmə yermamə kɨrik rɨmnor nar kɨrik rɨpəh nəmhenien kɨmi əmiə, takhapəh nɨsarpɨnien tai kafan təvhagə. Kɨni Kughen, Rɨmɨmiə ye Neai, In tukrɨpəh mɨn narpɨnien tai təvhagə hah kapəmiə. ");
INSERT INTO nwi_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kɨni mərɨg tukmə kɨmiə nakasor tai təvhagə hah, Kughen mɨn tukrarpɨn mɨn tai təvhagə hah kapəmiə.” ");
INSERT INTO nwi_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kɨni Yesu mɨne kafan narmamə mɨnə khatərhav-pə mɨn Jerusalem. Kɨni Yesu rəriwək mɨvən ye Nimə Ehuə kape Kughen. Kɨni jif Pris mɨnə mɨne nəmhajoun kape loa kape Moses mɨne nəmehuə kape kwənərəus kape Isrel, khauə mɨsəm In. Masaiyoh In mhamə, ");
INSERT INTO nwi_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“?Nakamhawor narɨmnar mɨnə e? ?Pa nhagɨn rɨmɨvəhsi-pre nehuəyen mə takor narɨmnar məknekɨn?” ");
INSERT INTO nwi_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Kɨni Yesu rɨni-pən tuk əriə mə, “Rhuvə. Jakaiyoh kɨn naiyohyen kɨrik kɨmi əmiə. Tukmə nakhani atuatuk, jakni-pre tuk əmiə mə Pa nhagɨn rɨmɨvəhsi-pə nehuəyen kɨmi Yo tuk norien narɨmnar mɨnə e. ");
INSERT INTO nwi_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","?Hani-pə ru tuk Yo mə pa rɨmɨvəhsi-pən nehuəyen kɨmi Jon mə tukror baptaes ye narmamə? ?Kughen uə yermamə?” ");
INSERT INTO nwi_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kɨni kɨnasəsiwən-əsiwən kɨmi əriə mɨnə mhamə, “?Tukshaw-ni e? Tukmə kɨtawə khani mə, Kughen rɨmɨvəhsi-pən nehuəyen kɨmi Jon, mərɨg Yesu tukrɨmə, ‘?Tukmə Kughen rɨmɨvəhsi-pən nehuəyen kɨmin, rhawor e kɨmiə nakhapəh nhaniyen nəfrakɨsien iran?’ ");
INSERT INTO nwi_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mərɨg to khapəh mɨn nhaniyen mə, yermamə əmə rɨmɨvəhsi-pən nehuəyen kɨmin, meinai narmamə mɨnə e kamhani mə Jon in profet əfrakɨs.” ");
INSERT INTO nwi_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ror pən khani-pən tuk Yesu mhamə, “?Hei? Yakseinein.” Kɨni Yesu rɨni-pən tuk əriə mɨmə, “Ǝhə. Mərɨg Yo mɨn to yakpəh nɨnipre-mɨn-ien mə Pa nhagɨn rɨmɨvəhsi-pə nehuəyen kɨmi Yo mə jakor narɨmnar mɨnə e.” ");
INSERT INTO nwi_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yermamə kɨrik rɨmnəsim kɨn grep ye kafan plantesen, markoparɨn-pən. Kɨni mɨkɨr kwətəgtap kɨrik kape nəviəsɨs-pənien kwənkwai grep ikɨn. Mə nehen tukraiyu, kɨvəh kor waen kɨn. Kɨni in mor nimə apomh kɨrik mə tukramərer aikɨn mamarha huvə tuk kafan plantesen. Kɨni in mərəhu plantesen ai ye kwermɨ narmamə tɨksɨn, tukhapɨk nəriə tɨksɨn, mhavəh-si-pən nan kɨrik rəmhen kɨn nərokien. Marə, mɨtərhav mɨn aikɨn mɨvən ye tanə pɨsɨn. ");
INSERT INTO nwi_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kɨni kwənkwai grep rɨmhiak, kɨni yemehuə kape plantesen rher-pən kɨn kafan manaja mə tukrɨvən məm narmamə yamə mɨne kɨsəsim aikɨn mə tukhavəhsi-pən grep ne yamehuə kape plantesen, rəmhen kɨn nərok kafan. ");
INSERT INTO nwi_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mərɨg iriə kɨsarar, mharaptərəkɨn manaja ai, mɨsərkɨs-ərkɨs, mɨsher-pən kɨn mə tukrɨrerɨg, mhapəh nhavəhsi-pənien nar kɨrik kɨmin. ");
INSERT INTO nwi_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kɨni yamehuə ai rarə mher-pən mɨn kɨn kafan kɨrik yermamə. Rɨvən, kɨni khauh kapən kapə, mɨsor ahas pən tukun. ");
INSERT INTO nwi_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ǝmaikɨn, yamehuə kape plantesen rher-pən mɨn kɨn yermamə kɨrik mɨn. Mərɨg khauh mɨn mɨshopni. Kɨni mərɨg yemehuə ai kape plantesen rher-pən mɨn kɨn kafan tɨksɨn narmamə khavən; narmamə mɨnə ai kɨsor ahas pən mɨn tuk əriə. Tɨksɨn kasərkɨs-ərkɨs əriə; kɨni tɨksɨn kɨmuh əriə, khopni əriə. ");
INSERT INTO nwi_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kɨsor məknaikɨn mamhavən, yamehuə kape plantesen, kafan narmamə kwənharkək. Kafan yermamə kɨrikianə əmə: Tɨni keikei. Rher-pən mɨn kɨn mə tukrɨvən. Ye nərɨgien kafan rɨmə, ‘Tukmə ror tuksəm kafak kwajikovə, khasiai.’ ");
INSERT INTO nwi_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mərɨg iriə kɨmɨsəm khamə, ‘Kwajikovə atuatuk e kape yamehuə kape plantesen. Pəh kɨshopni pəh plantesen e tukror kapətawə kɨn.’ ");
INSERT INTO nwi_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Məknekɨn kharaptərəkɨn, mɨshopni, mharəh nɨpran mɨsarkwərhav kɨn ye nəkwai plantesen.” ");
INSERT INTO nwi_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu rɨni-pən tuk nəmehuə mɨnə ai mə, “?Yamehuə kape plantesen ehuə tukrhawor mɨn? Tukrɨvən mhopni-hopni narmamə mɨnə a, mərəhu-pən plantesen ye kwermɨ narmamə pɨsɨn. ");
INSERT INTO nwi_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Tukmə ror kɨmiə nakhapəh nɨsəvhekɨn-hanə-yen nəgkiarien yame Nəkwəkwə kape Kughen rɨmɨni mɨmə, “‘ ‘Səpaag e, yame narmamə kape nəvhirəkɨnien nimə kɨmɨsarakikɨn, mərɨg Kughen rɨmnor in ruauə Səpaag huvə yame tukrəkɨr məkupən. ");
INSERT INTO nwi_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nar e Kughen Yermaru rɨmnor. Rɨkitawə ragien pɨk tukun.’” ");
INSERT INTO nwi_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Kɨni nəmasur mɨnə ai kɨmɨsorkeikei mə tukharaptərəkɨn Yesu, meinai kharkun mə kafan nuhpɨkɨnien ramni hah əriə. Mərɨg iriə kɨmnhagɨn kɨn narmamə, mɨsap. ");
INSERT INTO nwi_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kɨni nəmehuə mɨnə tɨksɨn kɨsher-pən kɨn Farisi mɨnə, mɨne nukwhao kape King Herod, khauə mɨsaiyoh Yesu kɨn naiyohyen əutən kɨrik mə tuksəm-ru mə tukrɨni nəgkiarien kɨrik rɨpəh nəmhenien. ");
INSERT INTO nwi_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kɨni ai iriə khauə mɨsəm In, mhani-pən tukun mhamə, “Yhajoun. Yakharkun mə Ik yermamə atuatuk. Nakpəh nɨgɨnien kɨn yermamə mə to rɨvi kafam nərɨgien, meinai rɨkim rɨpəh nəsɨkien mə yermamə kɨrik rhaktə uə yermamə kɨrik reiwaiyu, mərɨg nakaməfrakɨs əmə, kɨni nəvhagien kafam raməri-pən əmə norien yame Kughen rorkeikei. Kɨni yaksorkeikei mə jakharkun mə, ?Ratuatuk ye loa kapətawə mə tukasərok-pən takis kɨmi Sisa, yamehuə kape Rom, uə nɨkam? ");
INSERT INTO nwi_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","?Tukasəkeikei mɨsərok takis uə nɨkam?” Mərɨg Yesu ruɨrkun mə iriə narmamə kape neikuəyen mɨnə tɨksɨn. Kɨni mɨni-pən tuk əriə mə, “?Nakshawor mɨsarkut mə taksapita Yo? Havən-ru mharəh siren kɨrik mhauə pəh yakəm.” ");
INSERT INTO nwi_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kɨni khavən, mhavəh siren, mhauə. Kɨni raiyoh-pən əriə mə, “?Nanmɨ pa e? ?Kɨni nhag pa e?” Khamə, “Nanmɨ Sisa. Mɨne nhagɨn.” ");
INSERT INTO nwi_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Məknekɨn Yesu rɨni-pən tuk əriə mə, “Namhen. Nar kape Sisa, havəhsi-pən kɨmi Sisa. Mərɨg nar kape Kughen, havəhsi-pən kɨmi Kughen.” Kɨsərɨg nəgkiarien kape Yesu, kɨsakur pɨk kɨn. ");
INSERT INTO nwi_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kɨni Sadusi mɨnə tɨksɨn khauə mɨsəm Yesu. Sadusi mɨnə a khamə ta mə tukmə yermamə rɨmhə to rɨpəh nɨmragh-mɨnien ye rao ye neai. ");
INSERT INTO nwi_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Kɨni kɨsaiyoh kɨn nərɨgien kɨrik kɨmi Yesu mhamə, “Yhajoun. Moses rɨmɨrai ye Loa mɨmə, ‘Tukmə yerman rɨmhə-tan kɨn piraovɨn kafan, kɨni kapəriu kwajikovə rɨrkək, piau yerman ai tukraməkeikei mɨkɨr piraovɨn ai tukreimək.’ Ye nərɨgien a, iriu kɨrɨrkun nɨraptərəkɨnien nhag piauni yame rɨmamhə. ");
INSERT INTO nwi_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tukmə narmamə seven, iriə piauriə mɨnə. Nɨmrɨn nupan rarkurək kɨni mɨpəh nɨrəhyen kafan kɨrik kwajikovə, mɨmhə. ");
INSERT INTO nwi_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kɨni tukmə yame rɨkwasɨg kɨn rɨkɨr piraovɨn kape piauni yame rɨmamhə, kɨni mɨpəh neiməkien, kɨni mɨmhə mɨn. Kɨni naorahini yame ror kɨsisər kɨn ror əmə mɨn nar kɨrikianə kɨn ");
INSERT INTO nwi_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","meriaji iriə fam a seven kɨsarkurək ye piraovɨn a, kɨni mhamhə fam, mhapəh nɨseiməkien. Kɨni en piraovɨn a rɨmhə mɨn. ");
INSERT INTO nwi_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kɨni ye nɨpɨg kape narmamə tukhamragh mɨn iran, iriə a seven iriə piauriə mɨnə, ?piraovɨn a tukror piraovɨn kɨn kape pa nhagɨn?” ");
INSERT INTO nwi_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “Nakamhani-əro kɨn en meinai tukmə ror nakseinein nəgkiarien ye Nəkwəkwə kape Kughen, mɨseinein mɨn nɨrkunien kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tukmə narmamə yamə mɨne khamhə mamragh mɨn to khapəh nɨsarkurəkien. Norien kape narkurəkien rɨmnor infamien, rəmhen kɨn narəyen kape agelo mɨnə ye rao ye neai. ");
INSERT INTO nwi_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kɨni ye nɨkarɨn kape nɨmragh-mɨnien, tukmə ror nakhapəh nɨsəhuekɨnien nəkwəkwə yame Moses rɨmɨrai tu, mə Moses rɨmnəm nai kɨrik ramuək. Aikɨn, Kughen rɨmnamni-pən tukun mɨmə, ‘Ik Ik Kughen yame Ebraham, Aesak mɨne Jakob karhəgnəgɨn hanə Ik.’ ");
INSERT INTO nwi_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","!Kɨtawə kharkun mə irisɨr kɨrharə iriə Kughen meinai nar apnapɨg kwərhɨmhə ta tu mɨrhəkupən Moses, mərɨg Kughen ramni mə karhəgnəgɨn hanə In. !Kɨni pa rɨmə narmamə mhə mɨnə kasəgnəgɨn Kughen, mərɨg narmamə yamə mɨne kamhamragh! !Kɨmiə naksətəwao əfrakɨs!” ");
INSERT INTO nwi_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kɨni yhajoun kɨrik kape loa kape Moses rɨmnərɨg nəgkiarien mɨnə ai, mə Yesu ramhoprai huvə, kɨni ruə mɨnamaiyoh pən In mɨmə, “?Naha loa in rehuə pɨk rapita tɨksɨn, kɨni mɨhuvə pɨk tuk nəripənien?” ");
INSERT INTO nwi_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Kɨni Yesu rɨni-pən tukun mɨmə, “Loa yame rehuə pɨk rapita tɨksɨn in e ramni mɨmə, “‘!Kɨmiə nəmə Isrel! !Taksərɨg huvə! Kughen in Yermaru kapətawə. Kɨni In pɨsɨn əmə In Kughen. ");
INSERT INTO nwi_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Taksəkeikei mɨsorkeikei pɨk Kughen ai In Yermaru kapəmiə ye rɨkimiə fam, mɨne ye narəyen kapəmiə, mɨne ye nərɨgien kapəmiə, mɨne ye nəsanɨnien kapəmiə.’ ");
INSERT INTO nwi_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Loa yame rɨkwasɨg kɨn ramni mɨmə, “‘Taksorkeikei narmamə yamə mɨne kasarə ipakə tuk əmiə mɨsor huvə pən tuk əriə, rəmhen kɨn yame kɨmiə naksorkeikei atuk əmiə.’ Loa kɨrik mɨn rɨrkək yame in rapita yamə mir e.” ");
INSERT INTO nwi_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kɨni yhajoun kape loa kape Moses a rɨni-pən tukun mɨmə, “Yhajoun. Nakaməfrakɨs mə Kughen pɨsɨn əmə In Yermaru. ");
INSERT INTO nwi_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kɨni tukasəkeikei mɨsorkeikei In ye rɨkitawə fam, mɨne ye nərɨgien kapətawə, mɨne ye nəsanɨnien kapətawə. Kɨni mɨsorkeikei mɨn narmamə yamə mɨne kasarə ipakə tuk ətawə mɨnə rəmhen kɨn yame kasorkeikei atuk ətawə mɨnə. Nəri-pənien loa mir e rapita nuhyen narmɨragh mɨvaan tuk nɨvəhsi-pənien kɨmi Kughen.” ");
INSERT INTO nwi_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kɨni Yesu rəm mə nəgkiarien kape kwən a rhuvə pɨk, kɨni mɨni-pən tukun mɨmə, “Ik nakuauə pakə ta tuk narmaruyen kape Kughen.” Ǝmə aikɨn, narmamə kɨnɨsaurɨs kɨn naiyohyen Yesu kɨn nəgkiarien skai kɨrik. ");
INSERT INTO nwi_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kɨni Yesu rɨvən apa ye nimə ehuə kape Kughen, maməvhag kɨmi narmamə, mamaiyoh əriə mɨmə, “?Rhawor e nəmhajoun kape loa kape Moses kamhani mə Kristo In kwənərəus əmə kape Deved? ");
INSERT INTO nwi_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mərɨg, səmru, Nanmɨn kape Kughen rɨmɨvəhsi-pən nɨrkunien kɨmi Deved mə tukrɨni mə, “‘Kughen Yermaru rɨmɨni-pən tuk Yermaru kafak mɨmə, “Ǝkwətə ye kwermɨk matuk Meriaji nɨpɨg jakor Ik takehuə ye tɨkmɨr mɨnə kafam.” ’” ");
INSERT INTO nwi_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kɨni Yesu rɨrpɨn mɨmə, “Ye nəgkiarien e, Deved rɨmnokrən kɨn Kristo mə ‘Yermaru.’ ?Mərɨg nakshawor mamhani mə Kristo in kwənərəus əmə kape Deved?” Yesu rəgkiar aikɨn, narmamə khapsaah kɨsərɨg kɨsagien. ");
INSERT INTO nwi_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Kɨni Yesu rɨmnor kwirɨg kɨmi əriə, mɨmə, “Kɨmiə takasərɨg əmiə tuk nəmhajoun kape loa kape Moses. Iriə rɨkiriə ramagien tuk nɨvəhsi-pənien neipən huvə. Kɨni tukmə khavən apa ye maket, mɨsorkeikei pɨk mə narmamə mɨnə fam tuksaowiə kɨn əriə mhasiai əriə. ");
INSERT INTO nwi_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kɨni tukmə khavən ye nimə kape nofugɨnien, mɨsorkeikei mə tukasəkwətə əkupən, kɨni tukmə khavən ye lafet, mɨsorkeikei mə tuksəkwətə ye kwənmhaan kape nɨsiaiyen. ");
INSERT INTO nwi_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kɨni tukmə piahwaru yame kɨmnamhə-tan kɨn, kɨni iriə kasəkrəh kɨn kafan narɨmnar. Kɨni masəhuak apomh mɨn mə narmamə mɨnə tukhasiai əriə. !Ah! Narpɨnien kapəriə tukrɨskai rapita.” ");
INSERT INTO nwi_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kɨni Yesu ramkwətə ye nəkwai nimə ehuə kape Kughen, ipakə tuk kwənmhan yame kɨvəhsi-pən mane kape Kughen ikɨn. Kɨni maməm narmamə kamhavəhsi-pən mane kapəriə. Narmamə khapsaah, kapəriə mane rehuə, kamhavəh-si-pən mane ehuə. ");
INSERT INTO nwi_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kɨni piahwaru kɨrik kɨmnamhə-tan kɨn ruə, kafan mane rɨrkək. Kɨni in rɨvəhsi-pən əmə sɨren kɨraru. ");
INSERT INTO nwi_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kɨni Yesu rokrən kɨn narmamə kafan mɨnə khauə. Kɨni rɨni-pən tuk əriə mɨmə, “Yakamni-pre əfrakɨs tuk əmiə mə piahwaru e kɨmhə tan kɨn, kafan mane rɨrkək, mərɨg in rɨmɨvəhsi-pən mane kɨmi Kughen rapita fam mane yame narmamə mɨnə tɨksɨn kɨmnhavəhsi-pən. ");
INSERT INTO nwi_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Narmamə ai kɨmnhavəhsi-pən əmə nɨpar mane, mamhapəh nɨpərɨn. Mərɨg piahwaru e kafan mane rɨrkək pawk, mərɨg rɨmɨvəhsi-pən fam mane yame tukrɨvəh nɨmrɨ nəvɨgɨnien kɨn nan.” ");
INSERT INTO nwi_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kɨni ai, Yesu rɨmɨtərhav ye nimə ehuə kape Kughen, yermamə kɨrik kafan rɨni-pən tukun mɨmə, “Yhajoun, əmru. Nimə ehuə kape Kughen kɨmnor kɨn kapier ehuə, kɨni nimə mɨnə e khahuvə pɨk.” ");
INSERT INTO nwi_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mərɨg Yesu rɨni-pən tukun mɨmə, “Ǝmru. Nimə ehuə mɨnə e, tukoh-ətəg-ətəg kapier iran, kɨpəh nɨpəhyen kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kɨni Yesu rɨmnəkwətə ye nɨhu takwar kɨrik, nhagɨn e Olif, mɨvag-əhu kɨn nimə ehuə kape Kughen. Kɨni Pita mɨne Jemes mɨne Jon mɨne Andru khauə mɨsəm In. ");
INSERT INTO nwi_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Mɨsaiyoh-pən In mhamə, “Yaksorkeikei mə takni-pə tuk əmawə mɨmə ?narɨmnar mɨnə e tukruə ye naha nɨpɨg?” ");
INSERT INTO nwi_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kɨni rɨni-pən tuk əriə mɨmə, “Takasərɨg huvə, tamə yermamə reikuə irəmiə. ");
INSERT INTO nwi_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Narmamə khapsaah tukhavəh nhagɨk, kɨni mhauə mhani mə iriə e, Kristo. Tukseikuə ye narmamə khapsaah mhavi nərɨgien kapəriə. ");
INSERT INTO nwi_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kɨni nɨpɨg naksərɨg mə narmamə kamhauh əriə mɨnə, uə naksərɨg nəvsaoyen kɨn nuhyen əjir mɨnə, takhapəh nɨsakur-akurien, mhapəh nhagɨnien. Narɨmnar mɨnə e tukruə məkupən, mərɨg pəh nien mə Nɨpɨg Kwasɨg a. ");
INSERT INTO nwi_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Narmamə tukhauh əriə mɨnə. Kɨni narmamə ye tanə kɨrik tukhavən apa tanə pɨsɨn mhauh əriə mɨnə. Kɨni nɨmnɨmien tukravən ye tanɨmtanə. Kɨni sweiwei tukruh narmamə. Mərɨg narɨmnar mɨnə e in nɨrikakunien əmə kape nahasien, rəmhen kɨn piraovɨn yame ramərɨg nəmhəyen ye nɨpɨg kape neiməkien. ");
INSERT INTO nwi_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Mərɨg takasərɨg əmiə. Tukeighan kɨn əmiə naksərer ye nɨmrɨ mɨrh. Kɨni tukərkɨs-ərkɨs əmiə ye nəkwai niməhuak kapəriə. Meinai kɨmiə kafak narmamə mɨnə, takasəkeikei mɨsərer ye nɨmrɨ nəmasur kape gavman mɨne ye nɨmrɨ nəmasur kapəmiə tuk nɨni-ərhavyen Nəgkiarien Huvə kape Kughen kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tɨkni-ərhav Nəgkiarien Huvə kape Kughen ikɨn mɨnə fam rarkurao ye tokrei tanə, kwasɨg ikɨn Nɨpɨg Kwasɨg tukrɨpiruə. ");
INSERT INTO nwi_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mərɨg tukmə kɨvəh əmiə mə taksərer ye nɨmrɨ mɨrh, rɨkimiə tukrɨpəh nəpouyen. Mhapəh nɨsərɨgien mə, ‘?Jakhawni-pən tuk əriə?’ Takhani-ərhav nəgkiarien yame Nanmɨn kape Kughen rɨmɨvəhsi-pre kɨmi əmiə meinai pəh nien mə kɨmiə nakasəgkiar, mərɨg Nanmɨn Imərhakə tukrəgkiar ye tikinhermiə. ");
INSERT INTO nwi_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ye nɨpɨg a, piauni tukreighaan kɨn piauni kamhopni. Kɨni yerman tukreighaan kɨn kafan kwajikovə kamhopni. Kɨni kwajikovə mɨnə tukhani hah rɨmriə mɨnə mɨne nɨsɨnriə mɨnə, mɨseighan kɨn əriə kamhopni əriə. ");
INSERT INTO nwi_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Narmamə tuksəməkɨn əmiə, mɨsor ahas pən kɨmi əmiə meinai kɨmiə nakamhavəh nhagɨk. Mərɨg narmamə yamə mɨne kasərer tɨmtɨm mɨseriaji nɨpɨg kwasɨg, Kughen tukrɨvəh mɨragh əriə.” ");
INSERT INTO nwi_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kɨni pəh yermamə yame raməvhuekɨn nəkwəkwə e tukrɨrkun. Yesu rɨni-pən tuk əriə mɨmə, “Kɨni nɨpɨg kɨmiə naksəm nar a kamni kɨmə ‘Nar has yame roriah pɨk nar,’ ramərer ye kwənmhan yame rɨpəh nien mə tukramərer ikɨn, kɨmiə e Judia taksap mɨserkwaig ye takwar. ");
INSERT INTO nwi_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tukmə yermamə ramapɨs iruə ye nimə kafan to rɨpəh nɨvənien imə tuk nɨpɨkien narɨmnar kafan. ");
INSERT INTO nwi_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tukmə yermamə raməmɨr yerki nəsimien kafan, to rɨpəh nɨvənien yerkwanu tuk nɨwəhyen kafan neipən. ");
INSERT INTO nwi_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","!Man! Rɨskai pɨk tuk nɨpiraovɨn yamə mɨne kɨsor tɨpriə, kɨni mɨne yamə mɨne jiriə mɨnə kasomaah hanə, meinai tuksərɨg rahas pɨk. ");
INSERT INTO nwi_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Taksəhuak tuk nahasien e mə tukrɨpəh nuəyen mɨrəh əmiə ye nɨpɨg kape nəhig ");
INSERT INTO nwi_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","meinai nahasien ehuə yame tukruə, yermamə rɨpəh nəm-hanəyen rɨrikakun ye nɨpɨg Kughen rɨmnərəhu nɨmoptanə meriaji-pə ai taktəkun mɨne. Kɨni nahasien kɨrik to rɨpəh nuə-mɨnien nɨpɨg kɨrik rəmhen kɨn nahasien a. ");
INSERT INTO nwi_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mərɨg Kughen rɨmnəraita nɨpɨg kape nahasien a yame tukruə iran. Tamə, narmamə to khapəh nhamraghien tukun. Mərɨg In rɨmnərai nɨpɨg a mə tukrɨvəh mɨragh narmamə yamə mɨne In rɨmɨrpen əriə mə kafan narmamə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Nɨpɨg a, tukmə kɨrik rɨmə, ‘Səmru. Kristo e,’ uə yermamə kɨrik rɨmə, ‘Səmru, Kristo en,’ mərɨg kɨmiə takhapəh nhaniyen nəfrakɨsien iran. ");
INSERT INTO nwi_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Meinai profet eikuə mɨnə khapsaah tukhauə mhasɨgəvɨn Kristo mɨsor nɨmtətien mə tukseikuə ye narmamə. Kɨni mɨsarkut tuk nɨsəmien swatuk tuk nɨvi-tayen narmamə yamə mɨne Kughen ruɨrpen əriə. ");
INSERT INTO nwi_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mərɨg kwasɨg ikɨn narɨmnar a ruə, yakamni-pre ta tuk əmiə mə takasərɨg əmiə. ” ");
INSERT INTO nwi_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Kɨni Yesu rɨrpɨn mamni-pən tuk əriə mɨmə, “Kɨni nɨpɨg kape nahasien tukruə mor infamien, “‘Mɨrh tukrɨpɨs, Kɨni makuə to rɨpəh mɨn nəsiəyen; ");
INSERT INTO nwi_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kɨni kəmhau mɨnə tuksəsaah, Kɨni mɨne narɨmnar fam ye nɨmago-ago tukhakiu-kiu.’” ");
INSERT INTO nwi_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kɨni Yesu rɨrpɨn mɨmə, “Kɨni en, kwasɨg ikɨn, narmamə tukpisəm Yo, Ji Yermamə, jaksɨ-pən ye napuə mɨvəh nehuəyen mɨne nɨkakien. ");
INSERT INTO nwi_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kɨni ai, jakher-ərhav kɨn agelo kafak mɨnə mə tukhavən mɨsarkurao ye tanɨmtanə, mɨne ikɨn pukaa ye neai mɨsofugɨn narmamə yamə mɨne yɨmɨrpen-ta əriə. ");
INSERT INTO nwi_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Sətərɨg mɨn kɨn nuhpɨkɨnien kɨn nai a figtri. Tukmə nɨpɨg yame kwermɨn rɨnaurə kɨni nɨmarɨn rɨnəmhaier, kɨmiə nakharkun mə kwənhauə ipakə tuk nəsimien en. ");
INSERT INTO nwi_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Rəmhen əmə kɨn yame tukmə naksəm narɨmnar məknekɨn, takharkun mə Yo Ji Yermamə, yaknamuə ipakə, mɨnamərer ipakə əmə tuk kwəruə ye nimə kapəmiə. ");
INSERT INTO nwi_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yakamni-pre əfrakɨs tuk əmiə mə narmamə yamə mɨne kasarə ye rao e to khapəh nhamhə-famien kwasɨg ikɨn narɨmnar mɨne rɨtərhav-pə. ");
INSERT INTO nwi_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Napuə mɨne nɨmoptanə tukawəkeikei mɨrarkək, mərɨg nəgkiarien kafak to rɨpəh nɨrkəkien tuk nɨpɨg kɨrik. ");
INSERT INTO nwi_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Mərɨg narmamə fam kɨseinein nɨpɨg kape narɨmnar mɨnə e tukruə iran. Agelo mɨnə ye neai, mɨne Yo Ji Kughen, kɨmawə yakseinein mɨn. Mərɨg Rɨmɨk pɨsɨn əmə In rɨrkun. ");
INSERT INTO nwi_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“!Takasərɨg əmiə! !Mhapəh nɨsapɨrien! Meinai kɨmiə nakseinein nɨpɨg yame narɨmnar mɨnə e tukruə iran. ");
INSERT INTO nwi_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tukrəmhen kɨn yermamə kɨrik yame rɨtərhav iman yerkwanu mamvən yerkwanu pɨsɨn. Kwasɨg ikɨn rɨtərhav, rəhi-pən kafan narɨmnar kɨmi narmamə pɨsɨn mɨnə mə tukasəm vi vi, kɨni mərəhu wok pɨsɨn pµsµn kɨmi əriə. Kɨni mɨni-pən tuk yermamə yame ramərer tuk kwəruə mɨmə, ‘Takamarha.’ ");
INSERT INTO nwi_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Rəmhen əmə mɨn kɨn kɨmiə takasərɨg əmiə meinai nakseinein nɨpɨg yame Yamehuə kape nimə tukruə iran. Tukmə ror tukruə yenaiyu. Uə tukruə yenpɨg əru, uə tukruə yenpɨg-yenpɨg, uə tukruə yerkweiha. ");
INSERT INTO nwi_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tukmə In ramuə ye naha nɨpɨg, pəh In tukrɨpəh nəmien mə kɨmiə nakasapɨr. ");
INSERT INTO nwi_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yakamni-pre tuk əmiə, mamniərhav-pən mɨn tuk narmamə mə takasərɨg əmiə nɨpɨg fam.” ");
INSERT INTO nwi_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kɨni nɨpɨg a, tukharaptərəkɨn nəvɨgɨnien ehuə kɨn bred yame yis rɨrkək iran tukhani nahu kɨn. Jif pris mɨnə mɨne nəmhajoun kape loa kape Moses kɨnasarhakɨn swatuk mə tukharaptərəkɨn apɨs-apɨs Yesu mɨshopni. ");
INSERT INTO nwi_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Iriə kɨmnhani mhamə, “Pəh khapəh nharaptərəkɨnien In ye nɨpɨg kape nəvɨgɨnien ehuə, tamə narmamə niemhaa rhai əriə kɨni khauh apnapɨg əmə əriə mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kɨni Yesu rɨvən Betani mɨvən ye nəkwai nimə kape Saemon. Kwən ai kupən rɨmɨvəh nɨmhəyen əutən ye tɨkin. Kɨni Yesu raməvɨgɨn hanə, piraovɨn kɨrik ruə mɨvəh botel kɨrik kɨmnor kɨn kapier kɨrik nhagɨn e alabasta. Botel ai, senta aikɨn kamni kɨmə nad: nɨmrɨn rhaktə pɨk. Kɨni piraovɨn a rəsɨkta botel, mətəg-pən senta ye kapan kapə Yesu. ");
INSERT INTO nwi_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mərɨg narmamə tɨksɨn niemhaa rhai əriə khamə, “?Rhawor pian e roriah senta e? ");
INSERT INTO nwi_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Rhuvə pɨk mə to in rəvrai əmə; mɨrkun nɨvəhyen mane rəmhen kɨn tri handred taosen vatu kɨn tuk nɨvəhsi-pənien kɨmi yavən has mɨnə.” Kɨni kɨshek pian a. ");
INSERT INTO nwi_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mərɨg Yesu rɨni-pən tuk əriə mə, “!Ei! Hapəh pian en. ?Rhawor nakashek in? In ramor nar huvə kɨrik kɨmi Yo. ");
INSERT INTO nwi_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yavən has mɨnə tukasəmɨr kɨmiə miriə nɨpɨg fam. Kɨni tukmə nakhamə taksasitu irəriə nakharkun nɨsasituyen irəriə nɨpɨg fam. Mərɨg Yo jakpəh narəyen kɨtawə-m kɨmiə nɨpɨg fam. ");
INSERT INTO nwi_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Piraovɨn e rɨmnor huvə-pə kɨmi Yo ye nɨrkunien kafan. Mavi-təg-pə senta ye nɨprak mapnəpenə ye nɨprak mə tuknɨm Yo. ");
INSERT INTO nwi_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yakamni-pre əfrakɨs tuk əmiə mə ikɨn pukaa ye tokrei tanə yame kamni-ərhav Nəgkiarien Huvə ikɨn, tukaməvsao mɨn kɨn norien kape pian e, pəh narmamə rɨkiriə tukraməsɨk in.” ");
INSERT INTO nwi_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kɨni Judas Iskariot, in yermamə kɨrik ye narmamə twelef kape Yesu, rɨvən məm jif pris mɨnə tuk norien swatuk tuk neighan-pənien kɨn Yesu ye kwermɨriə. ");
INSERT INTO nwi_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Rɨvən məm əriə, rɨkiriə ragien, kɨni kɨmnhani mə tukhavəhsi-pən mane kɨmin. Kɨni Judas rɨvən, mamarə, mawhin nɨpɨg tuk neighan-pənien kɨn Yesu kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kɨni nɨpɨg kape nəvɨgɨnien e kamni kɨmə Bred yame Yis Rɨrkək iran ruauə ipakə, kɨni lafet a rɨrikakun ye nɨpɨg kape nəvɨgɨnien e kamni kɨmə Pasova. Kɨni narmamə tukasəkeikei mhauh kwaji sipsip kɨrik mɨsor nəvɨgɨnien ai kɨn. Kɨni narmamə kape Yesu kɨsaiyoh-pən mhamə, “?Ik nakmə jakhavən hiə mɨsor apnəpenə ye nəvɨgɨnien kape Pasova?” ");
INSERT INTO nwi_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kɨni Yesu rher-pən kɨn kafan yermamə kɨraru mɨmə, “Tukmə nakratərhav-pən Jerusalem, mwəm kwən kɨrik ramrəh jag ehuə kɨrik kɨmɨruk-pən nu iran. Kɨni takrakwasɨg kɨn in ");
INSERT INTO nwi_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mɨrhuvən ye nimə kɨrik yame in ramvən ikɨn. Kɨni mɨrəni-pən tuk yemehuə kape nimə mɨrəmə, ‘Yhajoun rɨmher-pə kɨn əmru mə jakrauə mwaiyoh-pre ik mə ?kwənmhaan a in hiə yame in mɨne kafan mɨnə narmamə tukhavən mɨsor nəvɨgɨnien kape Pasova?’ ");
INSERT INTO nwi_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kɨni in tukrɨkɨr əmiru nakrhuvən ye kwənmhaan ehuə apa yerpɨrɨg ye nimə yame kɨmnətu huvə ta narɨmnar m-fam kape nəvɨgɨnien aikɨn. Kɨni takwor apnəpeinə ye nəvɨgɨnien aikɨn.” ");
INSERT INTO nwi_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kɨni kratərhav mɨravən Jerusalem mwəm narɨmnar rəmhen kɨn yame Yesu ruɨni ta. Kɨni iriu kwor apnəpenə fam ye nəvɨgɨnien kape Pasova. ");
INSERT INTO nwi_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Yenpɨg, Yesu ruə iriə narmamə twelef kafan ");
INSERT INTO nwi_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","mɨsofugɨn ye tebol mɨsəvɨgɨn. Kɨni Yesu rɨni-pən tuk əriə mə, “Yakamni-pre əfrakɨs tuk əmiə mə kɨmiə kɨrik tukreighan-pən kɨn Yo kɨmi tɨkmɨr mɨnə kafak. Kɨmiə kɨrik e kɨtawə kasəkwətə.” ");
INSERT INTO nwi_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kɨni narmamə kafan mɨnə rɨkiriə reiwaiyu mɨnəsaiyoh əriə mɨnə mhamə, “?Pa? ?Yo?” ");
INSERT INTO nwi_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kɨni Yesu rɨni-pən tuk əriə mə, “Kɨmiə kɨrik ye narmamə twelef kafak yame yakaweires kwis bred ye supsup ye pənkɨn. ");
INSERT INTO nwi_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Yo Ji Yermamə jakaməkeikei mɨmhə rəmhen kɨn yame Nəkwəkwə kape Kughen rɨmɨni kupən. !Kɨni mərɨg rahas pɨk tuk yermamə yame tukreighan-pən kɨn Yo ye kwermɨriə! !Kwən a tukrɨvəh narpɨnien ehuə!” ");
INSERT INTO nwi_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kɨni kɨməsəvɨgɨn ta, Yesu rɨvəh bred məhuak mɨni vi vi Kughen tukun. Kɨni ai mhapu-hapu mɨvəhsi-pən kɨmi əriə. Mɨni-pən tuk əriə mɨmə, “Sən. In e nɨprak.” ");
INSERT INTO nwi_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kɨni mɨvəh kap waen mɨni vi vi Kughen tukun, mɨvəhsi-pən mɨn kɨmi əriə, kɨni kɨmnhanɨm. ");
INSERT INTO nwi_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kɨni rɨni-pən tuk əriə mɨmə, “Nɨtawɨk e. Ramor əpu nərɨgien kape Kughen tuk nɨvəh-mɨraghien narmamə tuk nuəyen məmɨr-ərhav. Tukraiyu mɨvəh mɨragh narmamə rehuə. ");
INSERT INTO nwi_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yakamni-pre əfrakɨs tuk əmiə mɨmə to yakpəh nɨnɨm-mɨnien waen meriaji mɨnɨm mɨn ye rao ye neai.” ");
INSERT INTO nwi_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kɨni iriə kɨmɨsəni nɨpe kɨrik, kwasɨg ikɨn khatərhav mhavən ye takwar kɨrik nhagɨn e Olif. ");
INSERT INTO nwi_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kɨni Yesu rɨni-pən mɨn tuk əriə mə, “Nhatətəyen kapəmiə mɨfam tukrɨmɨr, meinai kɨmɨrai ye Nəkwəkwə kape Kughen kɨmə, “‘Jakuh yermamə yame raməm huvə sipsip mɨnə, kɨni sipsip kafan mɨnə tuksaiyu rik rik.’” ");
INSERT INTO nwi_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kɨni Yesu rɨrpɨn mɨmə, “Mərɨg nɨpɨg jakɨmragh mɨn, jakəkupən kɨn əmiə mɨvən apa Galili.” ");
INSERT INTO nwi_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Mərɨg Pita rɨni-pən tukun mɨmə, “Tukmə ror nhatətəyen kapəriə tɨksɨn tukrɨmɨr; mərɨg nhatətəyen kafak to rɨpəh nɨmɨrien.” ");
INSERT INTO nwi_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Kɨni Yesu rɨni-pən tukun mɨmə, “Yakamni-pre əfrakɨs tuk ik mə man tukrɨpəh nəkakə-hanəyen mɨkɨraru, ik takni m-kɨsisər mə nakeinein Yo.” ");
INSERT INTO nwi_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mərɨg Pita rarə mɨni-pən skai mɨn mɨmə, “Tukmə khamə tukshopni ərau, to yakpəh nɨniyen mə yakeinein Ik.” Kɨni iriə fam khani əmə mɨn nəgkiarien kɨrikianə. ");
INSERT INTO nwi_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kɨni ai iriə khavən mɨn apa yerkwanu kɨrik, nhagɨn e Getsemane. Kɨni Yesu rɨni-pən tuk kafan narmamə mɨmə, “Kɨmiə taksəkwətə ikɨn e. Pəh yakvən maməhuak.” ");
INSERT INTO nwi_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kɨni In mɨkɨr Pita mɨne Jemes mɨne Jon, irisɨr min. Rɨkin rərhakɨs pɨk. ");
INSERT INTO nwi_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kɨni rɨni-pən tuk ərisɨr mɨmə, “Rɨkik rərhakɨs pɨk ipakə yakmhə tukun. Takarhəmɨr eikɨn e, marharha-huvə.” ");
INSERT INTO nwi_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kɨni In rəriwək mɨvən kəskəh əmə mənɨmkur maməhuak. Mamaiyoh Kughen mɨmə, “Rɨmɨk, tukmə nakeighan kɨn, nəmhəyen en tukrɨrkək tuk Yo.” ");
INSERT INTO nwi_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kɨni mɨmə, “Tatə, tukmə rɨkim ragien, aweh, vəhsi-ta nəmhəyen yamə mɨne tukpihauə. Mərɨg takpəh norien ye nərɨgien kafak; mor əmə ye kafam nərɨgien.” ");
INSERT INTO nwi_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kɨni ai In rɨrerɨg-pə mɨn tuk ərisɨr. Məm irisɨr krhapɨr yeru. Kɨni rɨni-pən tuk Pita mə, “Eh, Saemon, ?Rhawor nakamapɨr? ?To nakpəh narhayen kape nɨpɨg kwakwə uə? ");
INSERT INTO nwi_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kɨmiə takasərɨg əmiə. Takasəkeikei masəhuak mə nar kɨrik tukrɨpəh norien əmiə nakhamɨr. Rɨkimiə rəsanɨn mərɨg nɨpraimiə rəpou.” ");
INSERT INTO nwi_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kɨni ai In mɨrerɨg mɨn maməhuak. Mɨni-pən əmə mɨn nəgkiarien a. ");
INSERT INTO nwi_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kɨni ai mɨrerɨg-pə mɨn, məm irisɨr kwərhapɨr yeru mɨn, meinai napɨrien rɨmɨvəh nɨmrɨrisɨr. Mərɨg irisɨr kwərhaurɨs mɨrheinein nar yame tɨkrhɨni-pən tukun. ");
INSERT INTO nwi_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kɨni ai In rɨvən mɨn. Marə muə mɨn yame ror kɨsisər kɨn. Rɨni-pən tuk ərisɨr mə, “?Rhawor? ?Nakarhapɨs hanə? !Infamien! Nɨpɨg ruauə pakə ta yame yermamə tukreighan-pən kɨn Yo, Ji Yermamə, jakvən ye kwermɨ nəmə has mɨnə. ");
INSERT INTO nwi_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Rhekɨmter, pəh kamhavən. !Rhəmru! Yermamə yame rɨkin rɨmnagien tuk neighan-pənien kɨn Yo ye kwermɨ tɨkmɨr mɨnə kafak ruauə ipakə ta.” ");
INSERT INTO nwi_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu raməgkiar hanə, məknekɨn Judas, yermamə kɨrik ye narmamə twelef kape Yesu, rɨtɨrhav-pə. Nukwhao ehuə kamhakwasɨg kɨn, mamhapɨk nau nisə mɨne kwətavhə kapəriə. Jif pris mɨnə mɨne nəmhajoun mɨnə kape loa kape Moses, mɨne nəmehuə kape nəmə Isrel, kɨmɨsher-pən kɨn nukwhao a. ");
INSERT INTO nwi_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas ruɨni-pən ta tuk əriə mɨmə, “Yermamə yame jakəturəm-pən iran, yermamə e in en. Takharaptərəkɨn, mhakɨr mhavən, mhapəh nɨsorien rap.” ");
INSERT INTO nwi_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas ruə məm Yesu mɨni-pən tukun mɨmə, “Yhajoun,” məturəm-pən kɨmin. ");
INSERT INTO nwi_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kɨni ai iriə khauə mharaptərəkɨn Yesu. ");
INSERT INTO nwi_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mərɨg yermamə kɨrik ramərer ipakə tukun, rəvi kafan nau nisə mərəru ta nɨmətərgɨ yor atuə kɨn kape hae pris. ");
INSERT INTO nwi_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “?Rhawor? ?Kɨmiə nakhamə ta yo yermamə kape nəkrəhyen uə nhopniyen yermamə? ?Rhawor nakamhapɨk nau nisə mɨne kwətavhə mamhauə mə takharaptərəkɨn Yo? ");
INSERT INTO nwi_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nɨpɨg fam kɨtawə-m kɨmiə kasəmɨr ye nimə ehuə kape Kughen, yakaməwhag. Mərɨg nakhapəh hanə nharaptərəkɨnien Yo. Mərɨg nəmhen. Naha nhagɨn yame Nəkwəkwə kape Kughen rɨmɨni tukraməkeikei mor nəfrakɨsien kɨn.” ");
INSERT INTO nwi_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kɨni mərɨg narmamə kafan kɨsap ta iran. ");
INSERT INTO nwi_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mərɨg yermamə kɨrik yame rɨmɨkwasɨg kɨn Yesu rətəut əmə. Kɨni nɨpɨg kharaptərəkɨn kwən a, ");
INSERT INTO nwi_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","rəta ye neipən kafan maiyu kopiə kopiə əmə map. ");
INSERT INTO nwi_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kɨni khakɨr Yesu mhauə kɨmi hae pris. Jif pris mɨnə mɨne nəmehuə kape nəmə Isrel mɨnə mɨne nəmhajoun kape loa kape Moses, kwəsofugɨn ta əriə mɨnə aikɨn. ");
INSERT INTO nwi_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Kɨni Pita rɨkwasɨg kɨn əriə, mərɨg rɨpəh nɨvən-pakəyen tuk Yesu. Nɨpɨg ruə pakə tuk nimə ehuə kape hae pris, kɨni mɨvən məkwətə iriə narmamə kape hae pris mɨnə masərkəp. ");
INSERT INTO nwi_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kɨni jif pris mɨnə mɨne narmamə kape kaonsel kɨmɨsarha kɨn narmamə tɨksɨn yame tukhauə mɨseikuə ye Yesu, ai khauh mɨshopni. Mərɨg khapəh nɨsəmien yermamə kɨraru yamə mir tɨkrani nəgkiarien kɨrikianə. ");
INSERT INTO nwi_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Narmamə khapsaah kɨshekɨmter maseikuə ye Yesu, mərɨg nəgkiarien kapəriə rɨpəh nəm-nəmhenien. ");
INSERT INTO nwi_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kɨni narmamə tɨksɨn kɨshekɨmter mhani nəgkiarien eikuə ramvən tukun mhamə, ");
INSERT INTO nwi_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Yakasərɨg ramni mə, ‘Yo jakatmətəgətəg Nimə ehuə kape Kughen yame narmamə kɨmɨsor; mərɨg kwasɨg ikɨn ye nɨpɨg yame ror kɨsisər kɨn, jakərɨp yame rɨvi yame to yermamə rɨpəh nɨvhirəkɨnien.’” ");
INSERT INTO nwi_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Iriə kamhani mhani mərɨg nəgkiarien kapəriə rɨpəh nəm-nəmhenien. ");
INSERT INTO nwi_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kɨni ai, hae pris rərer ye nɨmrɨriə mɨni-pən tuk Yesu mɨmə, “?Rhawor nakpəh nəgkiarien? ?Rhawor e kamhani məkneikɨn nəgkiarien iram?” ");
INSERT INTO nwi_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mərɨg Yesu rərer əmə mamapnapɨg. Kɨni hae pris rarar maiyoh mɨn mɨmə, “?Rhawor? ?Ik e Kristo? ?Kughen yame kamni vi vi In, Ik kafan e kwajikovə uə?” ");
INSERT INTO nwi_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Kɨni Yesu rɨmə, “Yo en. Takpisəm Yo, Ji Yermamə, jakəkwətə ye kwermɨ Kughen matuk yame nagheen rehuə. Kɨni takpisəm mɨn Yo jaksɨ-faktə ye napuə meiwaiyu-pə.” ");
INSERT INTO nwi_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kɨni hae pris reikus neipən kafan meinai niemha rɨmnhai ni. Mɨni mə, “?Rhawor kɨtawə kasarha kɨn hanə narmamə yame tukhani hah In? ");
INSERT INTO nwi_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nakwəsərɨg ta mə rɨmɨni hah Kughen. ?Rɨkimiə ramhaw-əsɨk? ?Tukshawor In e?” Kɨni khamə tukraməkeikei mɨmhə. ");
INSERT INTO nwi_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kɨni tɨksɨn kɨshekɨmter masərɨg-əwhin. Tɨksɨn kɨsarkɨs-ətərəkɨn nɨmrɨn mir, mhauh mhani-pən tukun mhamə, “!Eh, profet! !Ni-ru mə pa e rɨmuh Ik!” Kɨni narmamə mɨnə kape hae pris kɨsəsɨk In mhakɨr. ");
INSERT INTO nwi_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kɨni Pita raməmɨr ipakə tuk nimə ehuə kape hae pris, kɨni piraovɨn kɨrik, yasitu kape hae pris, ruə. ");
INSERT INTO nwi_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Məm Pita ramərkəp. Rəm tɨm tɨm kɨni mɨmə, “Eh, ik mɨn kɨrik. Nakamkwasɨg kɨn yemə Nasaret e Yesu.” ");
INSERT INTO nwi_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mərɨg Pita rɨmə, “Nɨkam. Yo yakeinein əfrakɨs nar en nakamni.” Mɨtərhav meiwaiyu mɨn maməmɨr ye kwəruə kape rukwanu a. Kɨni man kɨrikianə rəkakə. ");
INSERT INTO nwi_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kɨni yasitu a kape hae pris rarə muə mɨn. Mɨnamni-pən tuk narmamə mɨnə aikɨn mə, “Kwən e, in kɨrik mɨn a.” ");
INSERT INTO nwi_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mərɨg Pita rɨmɨni neikuəyen iran. Rapəh norien tu, narmamə yamə mɨne kasəmɨr aikɨn khani-pən tuk Pita mhamə, “Nəfrakɨsien, ik əfrakɨs kɨrik mɨn a. Meinai ik mɨn yemə Galili.” ");
INSERT INTO nwi_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mərɨg Pita rɨni-pən skai tuk əriə mɨmə, “Yo yakeinein yermamə en yame nakamhani. Tukmə yakameikuə, Kughen tukror narpɨnien kɨmi yo.” ");
INSERT INTO nwi_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Məknekɨn, man rəkakə mɨkɨraru. Pita, rɨkin raiyu məsɨk nəgkiarien yame Yesu rɨmɨni mɨmə, “Man tukrɨpəh hanə nɨkakəyen mɨkɨraru, takni m-kɨsisər mə ik nakeinein Yo.” Kɨni rərɨg rahas pɨk; rɨkin rərhakɨs masək. ");
INSERT INTO nwi_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Yenpɨg-enpɨg əgkəp, jif pris, mɨne nəmehuə kape nəmə Isrel, mɨne nəmhajoun kape loa kape Moses, mɨne narmamə tɨksɨn mɨn kape kaonsel kape nəmə Isrel kaharaih mhun nəgkiarien kɨrik. Mhani-pən tuk narmamə tɨksɨn mə tuksərkɨs-ərkɨs Yesu. Kɨni mhakɨr In mhauə mhakɨr-pən kɨmi Paelat, yamehuə kɨrik kape Rom. ");
INSERT INTO nwi_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kɨni ai Paelat raiyoh In mɨmə, “?Ik e Ik Yermaru kape yemə Isrel uə?” Kɨni Yesu rɨni-pən tukun mɨmə, “Nəfrakɨsien e nakamni.” ");
INSERT INTO nwi_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kɨni jif pris mɨnə khani-ərhav neikuəyen rehuə yame kɨmɨsəm-pən ye Yesu. ");
INSERT INTO nwi_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kɨni Paelat raiyoh mɨn In mə, “?Rhawor nakpəh nəgkiarien? Ǝmru. Kamhani nəgkiarien rehuə iram.” ");
INSERT INTO nwi_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kɨni Paelat rɨmnəm mə Yesu rɨpəh nɨniyen nar kɨrik, rakur. ");
INSERT INTO nwi_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ye newk mɨnə fam, ye nɨpɨg kape Pasova, nəmə Isrel kharkun nhaniyen nhag yermamə kɨrik kwəvəhsi-pən ta ye kalabus, kɨni yamehuə rɨrɨsɨn kɨrik ramvən. ");
INSERT INTO nwi_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kɨni narmamə tɨksɨn kasəmɨr ye kalabus meinai khamə tukhauh gavman, kɨni mɨshopni narmamə tɨksɨn. Iriə kɨrik, nhagɨn e Barabas. ");
INSERT INTO nwi_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kɨni nəmə Isrel kɨmnhauə mɨsəm Paelat mamaiyoh-pən in mə tukror norien yame ramor rerɨn mɨrɨsɨn yermamə kɨrik ye kalabus. ");
INSERT INTO nwi_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kɨni Paelat raiyoh əriə mə, “?Naksorkeikei mə jakrɨsɨn Yermaru kape nəmə Isrel uə?” ");
INSERT INTO nwi_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","In ramaiyoh məknaikɨn meinai in rɨmnəm ta mə jif pris mɨnə kɨmɨsərəhu-pən Yesu ye kwermɨn meinai kasəməkɨn Yesu tuk yamai mə narmamə fam kɨsorkeikei In. ");
INSERT INTO nwi_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kɨni jif pris mɨnə kɨmnhani mhani-pən tuk kuwhen a mhamə tukhapəh nɨseighanien kɨn Yesu mə tukrɨtərhav, mərɨg mə tukseighaan kɨn Barabas. ");
INSERT INTO nwi_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kɨni Paelat raiyoh-pən mɨn əriə mɨmə, “?Mərɨg jakhawor kwən yame kɨmiə nakamhani mə In Yermaru kape nəmə Isrel?” ");
INSERT INTO nwi_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kɨni iriə kɨsokrən ehuə mhamə, “!Ǝsɨk-haktə in ye nai kamarkwao kɨn!” ");
INSERT INTO nwi_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mərɨg Paelat raiyoh-pən mɨn əriə mə, “?Tuk naha? ?Naha norien yame rɨmnor rahas?” Mərɨg iriə kɨsokrən ehuə pɨk mɨn mhamə, “!Ǝsɨk-haktə In ye nai kamarkwao kɨn!” ");
INSERT INTO nwi_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kɨni Paelat rɨmnorkeikei mə tukror rɨkiriə, meighaan kɨn Barabas rɨtərhav ye kalabus. Kɨni rɨmə tukərkɨs-ərkɨs Yesu, kɨkɨr In kavən kɨruk haktə In ye nai kamarkwao kɨn. ");
INSERT INTO nwi_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kɨni mobael tɨksɨn khakɨr Yesu mhavən ye nimə ehuə kape Paelat kɨni mɨsokrən kɨn nukwao kape mobael mɨnə mə tukhauə. ");
INSERT INTO nwi_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kɨni kharəh kot kɨrik rəwhao, rəmhen kɨn kot kape yermaru, mɨsarkaoh-pən kɨn kɨmin. Kɨni mharəh nərəus kɨrik ror nhirɨn, mɨsor kəvəvhao kɨn, rəmhen kɨn kəvəvhao kape yermaru, mhaukrai-pən ye kapən kapə. ");
INSERT INTO nwi_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kɨni masokrən kɨn mamhani mhamə, “Ik e yermaru kape nəmə Isrel. !Kɨmawə yakamhasiai Ik!” ");
INSERT INTO nwi_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kɨni mamhauh kapən kapə kɨn nai, masərɨg-əwhin, kɨni mɨsənɨmkur ye nɨmrɨn mhamə kamhasiai In. ");
INSERT INTO nwi_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kɨni mɨsarh iakei fam iran, mharəhsi-ta mɨn kot əwhao mhavəhsi-pən kafan neipən. Mhakɨr mhatərhav, mhavən mə tukharuk haktə In ye nai kamarkwao kɨn. ");
INSERT INTO nwi_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kamhauə ye swatuk, mɨsəm yemə Saerin kɨrik, nhagɨn e Saemon. In rɨm Aleksanda mɨne Rufas. In ramvən apa Jerusalem, kɨni khani-əhu mɨsarkut kɨmin mə tukrɨrəh nai kamarkwao kɨn kape Yesu. ");
INSERT INTO nwi_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kɨni iriə mhakɨr Yesu mhavən ikɨn kɨrik nhagɨn e Golgota (yame nɨpran rɨmə, kwənmhaan kape kerhə irə jir). ");
INSERT INTO nwi_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kɨni ye kwənmhaan a khavəhsi-pən waen kɨmi Yesu yame kəvɨt-pən nɨmar nai kɨrik kamni kɨmə “mir”. Mərɨg Yesu rɨpəh nɨnɨmien. ");
INSERT INTO nwi_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Rampɨgpɨg hanə, kɨmnharuk haktə In ye nai kamarkwao kɨn. Kɨni mɨsəwhai kafan neipən masarukɨn daes tukun, mə tukmə yame rapita, kɨni in ravəh kafan. ");
INSERT INTO nwi_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kɨni kɨrai-pən nəgkiarien kɨrik ye nai kɨrik ramni mə kɨmɨsəm-pən nar has kɨrik iran mɨmə, “In e Yermaru kape nəmə Isrel.” Kɨni mɨsarkwətərəkɨn-pən ye nai kamarkwao kɨn. ");
INSERT INTO nwi_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kɨni mharəh yeməkrəh mir kɨraru, mharuk haktə mɨn əriu irisɨr Yesu. Kɨrik ye matuk, kɨrik ye mawor. ");
INSERT INTO nwi_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Məknekɨn, nəgkiarien ye Nəkwəkwə kape Kughen ruauə, yame rɨmə, “Kɨməsəvheikɨn In iriə nəmə has mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kɨni narmamə yamə mɨne kasəriwək ye swatuk kasarh iakei pən iran. Masəwhan-əwhan kapəria kapə. Kɨni mamhani mhamə, “!In en! !Ik yermamə kape natmətəg-ətəgien nimə ehuə kape Kughen mɨne nor-mɨnien ye nɨpɨg kɨsisər əmə! ");
INSERT INTO nwi_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ɨntah. Ǝta-ru ye nai kamarkwao kɨn meiwaiyu, mɨvəh mɨragh atuk ik.” ");
INSERT INTO nwi_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kɨni jif pris mɨnə mɨne nəmhajoun mɨnə kasarh mɨn iran. Mamhani-pən tuk əriə mɨnə mhamə, “In rɨvəh mɨragh ta narmamə khapsaah. Mərɨg rɨpəh nəmhenien tuk nɨvəh-mɨraghien In. ");
INSERT INTO nwi_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Rhuvə mə Kristo e, In yermaru kape nəmə Isrel, tukreiwaiyu ye nai kamarkwao kɨn pəh kɨsəm, kɨni mhani nəfrakɨsien iran.” Kɨni kwərə mir yame kɨmɨruk haktə ərisɨr Yesu kwarpakwə kɨmi Yesu. ");
INSERT INTO nwi_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Yerkweiha əmə, mərɨg nəpɨgnəpien ruə muvrɨg əpɨs tanɨmtanə meriaji tri klok. ");
INSERT INTO nwi_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kɨni ye tri klok, Yesu rokrən ehuə mɨmə, “!Elae! !Elae! ?Lama sabaktani?” Nɨpran rɨmə, “!Kughen kafak! !Kughen kafak! ?Rhawor nakamapitan kɨn Yo?” ");
INSERT INTO nwi_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kɨni narmamə tɨksɨn yamə mɨne kasərer aikɨn mɨsərɨg nəgkiarien ai mhamə, “Sərɨg-ru. In ramokrən kɨn Elaeja.” ");
INSERT INTO nwi_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kɨni kwən kɨrik raiyu ətkin mɨvən mɨrəh nɨpərpər neipən meires ye waen əkwahir. Mərkɨs-pən ye nai apomh kɨrik kɨni mɨvəhsi-haktə pən kɨmi Yesu mə tukrɨnɨm. Kɨni mɨmə, “?Pəh kɨsəm-ru mə to Elaeja ruə masitu iran uə?” ");
INSERT INTO nwi_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mərɨg Yesu rarə mokrən ehuə mɨn kɨni ai kafan neihagien rɨtərhav. ");
INSERT INTO nwi_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kafan neihagien rɨtərhav aikɨn, kɨni nəkwai nimə ehuə kape Kughen, kɨmɨruk haktə neipən kɨrik yame kɨmnətapɨg kɨn Kwənmhan yame Rəmərhakə Məmərhakə pɨk. Neipən a rəhipu nɨpərɨn kɨraru. Rəhipu apa yerpɨrɨg əgkəp meiwaiyu. ");
INSERT INTO nwi_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kɨni yamehuə kape mobael yame ramərer ipakə tuk Yesu məm nɨmhəyen kape Yesu kɨni mɨmə, “Nəfrakɨsien. Kwən e In Ji Kughen.” ");
INSERT INTO nwi_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kɨni Meri, pian Magdala, mɨne Salome, mɨne Meri nɨsɨn kwajikovə mir nhagriu Jemes mɨne Joses, karharer isok, iriə nɨpiraovɨn tɨksɨn masəm In. ");
INSERT INTO nwi_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nɨpɨg Yesu rɨmavən Galili, irisɨr ai karhɨkwasɨg kɨn In, mɨrhasitu iran. Kɨni nɨpiraovɨn apnapɨg mɨnə khapsaah apaikɨn, kɨmnhatərhav-pən Jerusalem iriə min mhauə. ");
INSERT INTO nwi_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nɨpɨg a, kamni kɨmə napnəpenəyen meinai tɨkəni rɨkwamer kɨn nɨpɨg kape Sabat. Ipakə mɨrh rivə, ");
INSERT INTO nwi_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josef, yemə Aramatia kɨrik, rɨtərhav-pə. In yermamə kɨrik kape kaonsel kapəriə, yame yermamə kamhasiai in. Kɨni in mɨn rawhin narmaruyen kape Kughen mə tukruə. Ramgɨn pawk, mərɨg rɨmnarar mɨvən məm Paelat, maiyoh in mə tukreighaan kɨn nɨprai Yesu. ");
INSERT INTO nwi_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Paelat rɨmnərɨg mə Yesu rɨmamhə aihuaa əmə, rakur pɨk kɨn. Kɨni mokrən kɨn yamehuə kape mobael maiyoh in mɨmə, “?Yesu ruamhə əfrakɨs uə?” ");
INSERT INTO nwi_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kɨni yamehuə ai reighan kɨn. Kɨni Paelat reighan kɨn Josef mə tukrɨvən mɨrəh nɨprai Yesu. ");
INSERT INTO nwi_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Kɨni Josef rɨvən mɨrəhsi-əhu nɨpran ye nai kamarkwao kɨn, mɨvən mɨvəh nɨmrɨ neipən huvə kɨrik muə muvrɨg nɨpran kɨn neipən a. Kɨni mɨrəh mɨvən mərəhu ye nəpag kapier kɨrik yame kɨnor huvə ta. Kɨni mətapɨg əswasɨg kɨn kapier ehuə kɨrik. ");
INSERT INTO nwi_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ye nɨpɨg a, Meri, pian Magdala, mɨne Meri nɨsɨn Joses, iriu kɨmawəm kwənmhaan yame rɨmnərəhu-pən Yesu ikɨn. ");
INSERT INTO nwi_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Rɨnamenaiyu, nɨpɨg kape Sabat rɨnamor infamien, Meri, pian Magdala, mɨne Salome, mɨne Meri, nɨsɨn Jemes, krhɨvən mɨrhɨvəh nɨmrɨ nɨmar nai tɨksɨn yame nəmiovɨn rapien huvə. Mɨrhɨvən mə tukrhor-pən ye nɨprai Yesu. ");
INSERT INTO nwi_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kəni rɨkwamer kɨn, ye Sande, yenpɨg-enpɨg əgkəp, krhɨvən ikɨn nɨprai Yesu raməmɨr ikɨn. Mɨrh rɨrikakun mamhaktə, ");
INSERT INTO nwi_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","karhɨvən hanə ye swatuk, marhɨni-pən tuk ərisɨr mɨrhɨmə, “?Pa tukrasitu irətasɨr tuk nəsoktayen kɨn kapier yame kɨmnhaukrai əswasɨg pən tuk Yesu?” ");
INSERT INTO nwi_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Irisɨr kɨrhɨni məknaikɨn meinai kapier a in rehuə pɨk, mərɨg karhɨni hanə marharha-pən, mɨrhəm mə kɨnəsok ta kɨn kapier a. ");
INSERT INTO nwi_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Karhɨvən imə ye nəpag kapier ai, mɨrhəm pɨkwarien kɨrik, kafan kot rəpomh mhawən. Ramkwətə ye kwermɨrisɨr matuk. Kɨrhəm, kɨrhakur. ");
INSERT INTO nwi_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mərɨg rɨni-pən tuk ərisɨr mɨmə, “Takrhɨpəh nɨrhɨgɨnien. Yakɨrkun mə nakarharhakɨn Yesu yemə Nasaret, yame kɨmɨruk haktə ye nai kamarkwao kɨn. Mərɨg In rɨrkək eikɨn e. Ruɨmragh ta. Rhuəru mɨrhəm. Tamhekɨn e kɨmnərəhu ikɨn. ");
INSERT INTO nwi_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Takrhɨvən mɨrhɨni-ərhav-pən tuk narmamə mɨne Pita mɨrhɨmə, ‘In rɨnəkupən ta kɨn əmiə muavən apa Galili. Nakharkun nɨsəmien In aikɨn, rəmhen kɨn yame In ruɨnɨ-pre ta tuk əmiə.’” ");
INSERT INTO nwi_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kɨni pia misɨr a krhɨtərhav, meinai kɨmɨrhɨgɨn pɨk, kɨni marhətəmnɨmɨn. Ror pən krhɨpəh nɨrhɨni-əsah-pənien tuk narmamə. ");
INSERT INTO nwi_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu rarə mɨmragh mɨn ye Sande yenpɨg-enpɨg əgkəp. Aikɨn mɨtərhav-pə tuk Meri, pian Magdala yame Yesu rɨmnəkota nanmɨn has seven iran kupən. ");
INSERT INTO nwi_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kɨni pian ai rɨvən məm narmamə yamə mɨne kɨmnəmhakwasɨg kɨn Yesu, yame kasərɨg rahas pɨk tukun, mɨsasək. Məvsao-pən kɨn kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mərɨg nɨpɨg kɨmɨsərɨg mə Yesu rɨmɨmragh mɨn kɨni Meri mɨn rɨmnəm, iriə khapəh nhanien nəfrakɨsien iran. ");
INSERT INTO nwi_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kɨni ai, yermamə mir kɨraru kape Yesu kaweriwək ye swatuk, Yesu rɨtərhav-pən tuk əriu. Nɨpran rukrekɨn pɨsɨn. ");
INSERT INTO nwi_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kɨni kɨrarerɨg mɨravən mwəvsao kɨn kɨmi narmamə mɨnə kafan; mərɨg khapəh nhaniyen nəfrakɨsien iran. ");
INSERT INTO nwi_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kasarə mamhavən, narmamə leven kape Yesu kasəvɨgɨn, Yesu rɨtərhav-pən mɨn tuk əriə; kɨni məgkiar-pən skai kɨmi əriə meinai iriə khapəh nɨshatətəyen iran. Kɨni kaparhia kapə rɨskai pɨk. In rɨmnəgkiar skai pən tuk əriə meinai khapəh mɨn nhaniyen nəfrakɨsien ye nəgkiarien kape narmamə mɨnə tɨksɨn yame kɨmɨsəm In, mamhani-ərhav mə rɨmɨmragh mɨn. ");
INSERT INTO nwi_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kɨni rɨni-pən tuk kafan narmamə mɨnə mɨmə, “Taksəkeikei mhavən mɨsarkurao ye tanɨmtanə mhani-ərhav nəgkiarien huvə kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yermamə yame rhatətə irak, kɨni mor baptaes, Kughen tukrɨvəhsi-pən nɨmraghien rerɨn kɨmin. Mərɨg yermamə yame rɨpəh nɨniyen nəfrakɨsien irak, Kughen tukrɨni mə tukrɨvəhsi-pən narpɨnien kɨmin mə tukrɨvən apa ye nap ehuə. ");
INSERT INTO nwi_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kɨni narmamə yamə mɨne kɨshatətə irak, Kughen tukror nɨmtətien tɨksɨn ye nɨmraghien kapəriə. Tukharkun nɨsəkotayen nanmɨn has ye narmamə ye nhagɨk; mharkun mɨn nɨniyen nəgkiarien pɨsɨn pɨsɨn; ");
INSERT INTO nwi_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","mharkun nɨrəhyen snek, mərɨg snek to rɨpəh nəsien əriə; mharkun nɨnɨmien kakonə, mərɨg to khapəh nhamhəyen kɨn; mharkun nərəhu-pənien kwermɨriə ye narmamə yamə mɨne kamamhə, kɨni tuksəsanɨn.” ");
INSERT INTO nwi_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yesu Yermaru raməgkiar infamien, Kughen rɨvəh In mhaktə mɨvən ye rao ye neai. Taktəkun ai, In ramkwətə ye kwermɨ Kughen matuk. ");
INSERT INTO nwi_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kɨni narmamə kafan kɨmnhatərhav mɨsəvsao kɨn Nəgkiarien Huvə ikɨn mɨnə fam. Kɨni In ramasitu irəriə. Kɨni mamor nɨmtətien rɨpsaah ye nɨmraghien kapəriə mə narmamə tukhani nəfrakɨsien iran. ");
INSERT INTO nwi_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Teofilas, ik yamehuə kɨrik, kamsiai ik. Narmamə khapsaah kɨmɨsəm narɨmnar kɨn nɨmrɨriə yame Yesu rɨmnor ye nɨpɨg rɨmnamarə ye tokrei tanə. Iriə kɨmnɨsarə ye nɨpɨg kape nɨrikakunien kape narɨmnar mɨnə a, kɨni mɨsarkut pɨk mə tuksərəhu atuatuk nəvsaoyen kape narɨmnar mɨnə a. Kɨmnharai ta narɨmnar yamə mɨne narmamə tɨksɨn kɨmnhani, kɨni mhani-ərhav. Kɨni yo yɨmɨwəs huvə nəgkiarien iran mɨnə mə jakɨrkun huvə narɨmnar mɨnə a ye nɨrikakunien kafan. Kɨni taktəkun ai, kafak nərɨgien rɨmə jakrai atuatuk narɨmnar m-fam mher-pre kɨn. Jakrai atuatuk yamə mɨnə kɨmɨsəkupən, mɨne yamə mɨne kɨmnhakwasɨg. ");
INSERT INTO nwi_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Yɨmnorkeikei mə jakni narɨmnar mɨnə e tuk ik mə takɨrkun atuatuk nəfrakɨsien kape nəvsaoyen yame kɨnhajoun ta ik kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ye nɨpɨg king kape provins e Judia, nhagɨn e Herod Ehuə, pris kɨrik aikɨn, nhagɨn e Sekaraea. In kɨrik ye pris mɨnə kamokrən kɨn əriə kɨmə, “Pris mɨnə kape kwənərəus kape Apia,” yame rɨmasɨ-pən ye kwənərəus kape Eron kupən. Kafan piahwaru, nhagɨn e Elisabet, rɨmasɨ-pən mɨn ye kwənərəus kape pris e Eron. ");
INSERT INTO nwi_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kɨni iriu kwətuatuk ye nɨmrɨ Kughen, mawəri-pən huvə norien kape Loa kape Moses, mɨne nəgkiarien mɨnə iran; mɨrapəh nɨwəsɨkien kɨrik. ");
INSERT INTO nwi_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mərɨg jiriu rɨrkək meinai Elisabet ror siə kɨn ror hanə, mɨnəpiahuaru, kɨni Sekaraea mɨn rɨnəhuaru. ");
INSERT INTO nwi_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kɨni ruauə atuatuk ye nɨpɨg yame Sekaraea mɨne kwhen kafan kasor wok kapəriə ye Nimə Ehuə kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Khamə tuksəm-ru mə pa nhagɨn tukrauru-pən ye Nimə Kape Kughen mɨvaan insens nəmiovɨn rapien huvə mamvən tuk Kughen. Kɨni ye norien kape pris mɨnə kape nɨrpenien yermamə yame tukrɨvən imə, kɨmnharai-pən nhagriə ye kwaji kapier kɨrik mhawhan. Kɨmnhawhan, kapier yame kɨmnharai-pən nhag Sekaraea iran rukreikɨn haktə. ");
INSERT INTO nwi_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Məkneikɨn rɨməpəh narmamə khapsaah iruə kasofugɨn masəhuak, kɨni rɨmauru-pən imə mɨvaan insens. ");
INSERT INTO nwi_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Məkneikɨn agelo kɨrik kape Kughen Yermaru rɨtərhav-pə marer ye nɨkar tebol matuk ye kwənmhaan yame rɨvaan insens ikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kɨni Sekaraea rəm rakur, mɨgɨn pɨk. ");
INSERT INTO nwi_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mərɨg agelo a rɨni-pən tukun mɨmə, “Sekaraea, pəh nɨgɨnien, meinai Kughen rɨmnərɨg kafam nəhuakien. Kafam piahwaru Elisabet tukrɨrəh tɨni kɨrik yerman. Kɨni takaməkeikei mhen-pən nhagɨn mə Jon. ");
INSERT INTO nwi_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kɨni takərɨg rhuvə, magien tukun, kɨni narmamə khapsaah tuksagien tuk nɨmraghien kafan, ");
INSERT INTO nwi_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","meinai in tukruə yamehuə kɨrik ye nɨmrɨ Kughen Yermaru. Kɨni to in rɨpəh nɨnɨmien waen, mɨne nɨnɨmien skai mɨnə. Kɨni Nanmɨn kape Kughen tukrɨkwar ye nɨmraghien kafan, rɨrikakun ye nɨpɨg raməmɨr apa ye tɨp nɨsɨni, mamvən, infamien rɨrkək. ");
INSERT INTO nwi_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kɨni in tukrɨvi-pə nəmə Isrel khapsaah kharerɨg-pə tuk Yermaru kapəriə e Kughen. ");
INSERT INTO nwi_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kɨni in tukruə məkupən kɨn Yermaru ye nanmɨn mɨne nəsanɨnien kape Elaeja kupən, mə in tukrukreikɨn rɨki tatə mɨnə khrerɨg-pən mɨn tuk kapəriə kwajikovə mɨnə; kɨni in tukrukreikɨn mɨn narmamə yamə mɨne kasəsɨk nəkwai Kughen khauə mɨn ye nɨrkunien kape nəmə atuatuk mɨnə. Ye norien a, in tukror apnəpeinə ye nɨmraghien kape narmamə tuk nuəyen kape Yermaru.” ");
INSERT INTO nwi_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Məkneikɨn, Sekaraea rɨni-pən tuk agelo mɨmə, “?Jakhawor pən iran mɨne mɨrkun mə nar e tukruə mor nəfrakɨsien kɨn? Meinai yo yaknəhuaru ta; kɨni kafak piraovɨn rɨnəpiəhuaru mɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mərɨg agelo a rɨni-pən tukun mɨmə, “Yo, nhagɨk e Gabriel, kɨni yo yakamərer ye nɨmrɨ Kughen ye nɨpɨg m-fam. Kɨni In rɨmnher-pə kɨn yo mə jakuə məgkiar kɨmik, mɨni-pre nəvsaoyen huvə e. ");
INSERT INTO nwi_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","!Ǝtərɨg-ru! Neramɨm tukrərpəvɨn kɨni takeinein nəgkiarien meriaji nɨpɨg takəm nɨprai nəgkiarien e, meinai nɨmɨpəh nɨniyen nəfrakɨsien ye kafak nəgkiarien. In tukruə mor nəfrakɨsien kɨn ye nɨpɨg atuatuk kafan.” ");
INSERT INTO nwi_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kɨni ye nɨpɨg a, narmamə kɨmɨseito kɨn Sekaraea, mɨsərɨg mə rhawor ramor məkna tan pən ye nəkwai Nimə kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kɨni rɨmatərhav-pə, meinein nəgkiarien. Ror məkneikɨn iriə kɨmnharkun mə in rɨmnəm nəmrərhavyen kɨrik imə. Raməgkiar əmə kɨn kwermɨn mamvən, neramən rɨmnarpəvɨn. ");
INSERT INTO nwi_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kɨni nɨpɨg rɨmnor infamien ye wok kape pris ye nəkwai Nimə kape Kughen, in rɨrerɨg-pən yerkwanu. ");
INSERT INTO nwi_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kɨni rɨpəh norien tu, kafan piahwaru ror tɨpɨn, mamerkwaig əmə yerkwanu meriaji makuə kɨrkɨrɨp, ");
INSERT INTO nwi_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","mamni mɨmə, “Nar e Kughen Yermaru rɨmnor ruə irak. Apa kupən, narɨk rɨrkək, yakaurɨs. Mərɨg taktəkun ai, Kughen rɨmnor rhuvə-pə kɨmi yo, kɨni rɨkik ragien mə jakrəh kwajikovə kɨrik, mɨpəh mɨn naurɨsien kɨn nɨmrɨ jir.” ");
INSERT INTO nwi_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kɨni nɨpɨg Elisabet ror tɨpɨn mɨvəh makuə sikis, Kughen rɨmnher-pə kɨn agelo kɨrik kafan, nhagɨn e Gabriel, rɨvən apa yerkwanu kɨrik nhagɨn e Nasaret, ye provins e Galili. ");
INSERT INTO nwi_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","In mɨvəh nəgkiarien kɨrik mamvən kɨmi piraovɨn kɨrik nhagɨn e Meri. Yerman rɨpəh hanə nɨvənien tukun, mərɨg kɨmɨrpen ta kɨmə tukɨkɨr pən kɨmi kwən kɨrik, nhagɨn e Josef, yame in kwənərəus kɨrik kape King Deved. ");
INSERT INTO nwi_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kɨni agelo a raji-ərhav pən tukun, mɨni-pən tukun mɨmə, “Rhuvə, Meri. Kughen rɨmnərəhu kafan nɨhuvəyen kɨmik, kɨni mamarə kɨmiru min.” ");
INSERT INTO nwi_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mərɨg tɨpɨr ramuh Meri tuk nɨprai nəgkiarien a, mɨmə, “?Rhawor e mamni vi vi məkneikɨn yo?” ");
INSERT INTO nwi_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mərɨg agelo a rɨni-pən tukun mɨmə, “Takpəh nɨgɨnien, Meri, meinai Kughen rɨmɨrpen mə tukrautə-pre kɨn kafan nɨhuvəyen kɨmik. ");
INSERT INTO nwi_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ror məkneikɨn, takaməkeikei mor tɨpɨm. Takaməkeikei mɨrəh kwaji kɨrik yerman, mhen-pən nhagɨn mə Yesu. ");
INSERT INTO nwi_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","In tukruə mamor yemə huvə pɨk kɨn. Tukaməkeikei kokrən kɨn In kɨmə In Ji Kughen Yerpɨrɨg. Kɨni Kughen Yermaru tukror In ruə king rəmhen əmə kɨn rɨpni kupən e Deved. ");
INSERT INTO nwi_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kɨni In tukramarmaru ye kwənərəus yamə mɨne khasɨ-pən ye Jekob, kɨni kafan narmaruyen tukramarə kape rerɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kɨni Meri rɨni-pən tuk agelo mɨmə, “?Jakhawor-pən iran mɨne mɨrəh kwajikovə kɨrik tukmə yakpəh nəri-pən-hanəyen yerman?” ");
INSERT INTO nwi_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mərɨg agelo rɨni-pən tukun mɨmə, “Nanmɨn kape Kughen tukrurə marə iram, kɨni nəsanɨnien kape Kughen Yerpɨrɨg tukrhen ik. Kɨni in e kwajikovə yame takrəh, in ratuatuk pɨk, tukamokrən kɨn In kɨmə Ji Kughen. ");
INSERT INTO nwi_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kɨni, əmru, kuhum e Elisabet rɨnəpiəhuaru pawk, mərɨg rɨnor ta tɨpɨn kɨn kwaji yerman kɨrik. Kɨmɨni in kɨmə piahwaru yame ror siə kɨn, mərɨg taktəkun ai rɨnor tɨpɨn mɨvəh makuə sikis. ");
INSERT INTO nwi_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Narɨmnar mɨnə e kashajoun-pən mə nar kɨrik rɨpəh norien neineinien tuk Kughen.” ");
INSERT INTO nwi_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Məkneikɨn Meri rɨni-pən tukun mɨmə, “Ǝwəh. Yo yorwok əmə kape Kughen Yermaru. Pəh In tukror naha nhagɨn kɨmi yo yame ik nakamni.” Kɨni agelo rəta iran, mamvən. ");
INSERT INTO nwi_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kwasɨg ikɨn ye narɨmnar mɨnə a, rɨpəh norien tu, Meri rɨmnarar iman ikɨn, mhai mɨren nar mɨvən apa yerkwanu kɨrik ye nɨkar tukwas mɨnə ye provins e Judia, ");
INSERT INTO nwi_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","mauru-pən imei Sekaraea mɨne Elisabet. Magien tuk Elisabet, ");
INSERT INTO nwi_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","kɨni nɨpɨg Elisabet rərɨg Meri raməgkiar, məknakɨn kwajikovə a ye tɨpɨn rakur mɨkiu; kɨni Nanmɨn kape Kughen rɨmnor Elisabet ");
INSERT INTO nwi_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","rok-rapomh mɨmə, “!Kughen ramor rhuvə-pre kɨmik rapita nɨpiraovɨn mɨnə fam, kɨni In tukror huvə-pən kɨmi kwaji yerman yame takrəh! ");
INSERT INTO nwi_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mərɨg yakpəh nɨrkunien mə rhawor e Kughen ramor huvə pə məkneikɨn kɨmi yo mə nɨsɨn Yermaru kafak tukruə məm yo. ");
INSERT INTO nwi_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yakamni məkneikɨn meinai nɨpɨg yɨmnərɨg kafam nəgkiarien, kwajikovə e yame raməmɨr e ye tɨpɨk ramagien mamkiu. ");
INSERT INTO nwi_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kɨni Kughen tukror rhuvə pre kɨmik meinai nɨmɨni nəfrakɨsien ye nəgkiarien yame Kughen Yermaru rɨmɨni-pre tuk ik.” ");
INSERT INTO nwi_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Məkneikɨn Meri rɨmə, “Ye nɨmraghien mɨnə fam kafak, yakaməgnəgɨn Kughen Yermaru, ");
INSERT INTO nwi_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","kɨni rɨkik ramagien pɨk tuk Kughen kafak yame ravəh mɨragh yo, ");
INSERT INTO nwi_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","meinai yo yorwok əmə kafan yame yo yermamə apnapɨg əmə, mərɨg rɨkin raməsɨk yo. Kɨni taktəkun ai mamvən, narmamə m-fam tukhani mə Kughen rɨmnor huvə pə kɨmi yo. ");
INSERT INTO nwi_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Meinai Kughen e nəsanɨnien kafan in rehuə, In rɨmnor narɨmnar rehuə kɨmi yo. Kɨni nhagɨn ramərhakə. ");
INSERT INTO nwi_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kɨni rɨkin rehuə tuk narmamə yamə mɨne kamhasiai In, iriə e narmamə yamə mɨne kɨmɨsəkupən mɨsarə mɨne yamə mɨne tukpihauə kwasɨg ikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","In rɨmnor nar apsɨpɨs mɨnə ye nəsanɨnien ye kwermɨn. Mher yerhav kɨn narmamə yamə mɨne kɨsausit ye nətərɨgien kapəriə. ");
INSERT INTO nwi_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mɨvəh-si-əhu namehuə mɨnə ye kapəriə neihuəyen, kɨni mɨvəhsi-haktə narmamə yamə mɨne kapəriə nətərɨgien reiwaiyu. ");
INSERT INTO nwi_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Narmamə yamə mɨne nɨkumhə raməs əriə, In raməvɨgɨn əriə kɨn nəvɨgɨnien yame rhuvə, kɨni narmamə yamə mɨne kapəriə nautə rehuə, In rɨmnher yerhav kɨn əriə, nar rɨmɨrkək tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","In rɨmnasitu ye kwənərəus kape Isrel, iriə e yorwok mɨnə kafan. Rɨkin raməsɨk mə rɨkin tukraməkeikei mamehuə tuk əriə, ");
INSERT INTO nwi_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","rɨrikakun ye Ebraham kupən mɨne kwənərəus kafan, mamvən kape rerɨn, rəri-pən nəgkiarien yame rɨmɨni-pən ta tuk kaha mɨnə kapətawə.” ");
INSERT INTO nwi_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kɨni Meri ramarə iriu Elisabet mɨvəh makuə kɨsisər, kɨni ai, mɨpirerɨg-pən iman ikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kɨni nɨpɨg atuatuk kape Elisabet rɨmauə mə tukreimək iran, kɨni rɨmɨrəh tɨni yerman. ");
INSERT INTO nwi_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kɨni narmamə yamə mɨne kasarə ipakə tukun mɨne kafan kwənərəus mɨnə kɨmɨsərɨg nəvsaoyen a mə Kughen Yermaru rɨkin rehuə tukun mor rhuvə pən məknakɨn kɨmin, kɨni iriə kɨmnhauə mɨsor kɨrikianə iriə min mə tuksagien kwis. ");
INSERT INTO nwi_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kɨni nɨpɨg pɨkwarien a rɨmɨvəh nɨpɨg eit, kɨni iriə khauə mhavəh nao kɨm in. Kɨni ipakə əmə kɨshen-pən nhagɨn mə nɨfnhag rɨmni e Sekaraea, ");
INSERT INTO nwi_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","mərɨg nɨsɨni rɨmɨni-pən mɨmə, “Nɨkam. Pəh kɨshen-pən nhagɨn mə Jon.” ");
INSERT INTO nwi_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mərɨg iriə khani-pən tukun mhamə, “?Rhawor? Ye kwənərəus kapəmiru, nhag e Jon rɨrkək iran.” ");
INSERT INTO nwi_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kɨni masəgkiar kɨn kwermɨriə mɨsaiyoh-pən Sekaraea mhamə in rorkeikei mə tukshen-pən nhagɨn mə pa. ");
INSERT INTO nwi_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kɨni in raiyoh-pən əriə mə tukharəh-sipən nar kɨrik pəh tukrɨrai-pən nəgkiarien kɨrik aikɨn, mɨrai-pən mɨmə, “Nhagɨn e Jon.” Kɨsəm kɨsakur pɨk kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Məkneikɨn, neramɨn rɨhuatuk, məgkiar mamni vi vi Kughen. ");
INSERT INTO nwi_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kɨni narmamə m-fam yamə mɨne kɨsarə ipakə tukun kɨsakur kɨn. Kɨni narmamə kɨmnhani narɨmnar mɨnə a rarkurao ikɨn mɨnə fam ye nɨkar tukwas mɨnə ye provins e Judia. ");
INSERT INTO nwi_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kɨni narmamə mɨfam yamə mɨne kɨmnhavəh nəvsaoyen a, mɨsətərɨg kɨn, mɨsaiyoh əriə mɨnə mhamə, “Man. ?Keinein mə kwajikovə e tukreihuə mor naha?” Kɨmnhani məknaikɨn meinai kɨmɨsəm mə nəsanɨnien kape Kughen Yermaru ramarə iran. ");
INSERT INTO nwi_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Məkneikɨn Nanmɨn kape Kughen rɨmnor rɨki Sekaraea, ramni-ərhav nəgkiarien yame Kughen rɨmɨvəhsi-pən kɨmin mɨmə, ");
INSERT INTO nwi_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Pəh khani vi vi Yermaru, In Kughen kape nəmə Isrel, meinai In rɨmauə mə tukrasitu ye kafan narmamə mɨnə, kɨni mɨpɨk ta əriə ye kwermɨ tɨkmɨr mɨnə kapəriə. ");
INSERT INTO nwi_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","In rɨmɨvəh-si haktə yemə əsanɨn yame ravəh mɨragh ətawə, yame ramsɨ-pən ye kwənərəus kape yorwok kafan e Deved kupən ");
INSERT INTO nwi_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","raməri-pən əmə nəgkiarien yame rɨmɨvəhsi-pən kɨmi kafan profet kupən mɨnə mɨmə ");
INSERT INTO nwi_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","tukrɨvəhsita ətawə tuk tɨkmɨr mɨnə kapətawə mɨne tuk kwermɨ narmamə mɨfam yamə mɨne kasəməkɨn ətawə. ");
INSERT INTO nwi_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kɨni mɨmə rɨkin tukreihuə tuk rɨptawə mɨnə, kɨni rɨkin tukraməsɨk promes atuatuk ");
INSERT INTO nwi_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","yame In rɨmɨni-pən ta tuk rɨptawə e Ebraham mɨmə ");
INSERT INTO nwi_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","tukrɨrəh-si ta ətawə ye kwermɨ tɨkmɨr mɨnə kapətawə, mə nɨpɨg mɨfam ye nɨmraghien kapətawə, kɨtawə tukharkun nɨsorien wok kafan ye nɨmrɨ Kughen, mhapəh nhagɨnien, ");
INSERT INTO nwi_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kɨtawə kɨsəmərhakə mɨsatuatuk ye nɨpɨg mɨfam.” ");
INSERT INTO nwi_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kɨni Sekaraea rarar mɨni-pən tuk tɨni mɨmə, “Kɨni ik, narɨk, tukokrən kɨn ik kɨmə ik pris kape Kughen Yerpɨrɨg; meinai Ik takəkupən kɨn Yermaru mor apnəpeinə ye swatuk kafan, ");
INSERT INTO nwi_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","mamni-ərhav tuk kafan narmamə mɨnə mə Kughen tukrəspir ta təvhagə has kapəriə, mɨvəh mɨragh əriə. ");
INSERT INTO nwi_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","In tukraməkeikei mor məknakɨn meinai rɨkin rehuə tuk ətawə, mamor huvə pə kɨmi ətawə. Rɨkin rehuə tuk ətawə, Kristo tukruə tuk ətawə rəmhen əmə kɨn yame mɨrh ramhaktə mamvən ye neai ");
INSERT INTO nwi_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","mɨsia-pen ətawə yamə mɨne kasarə ye nəpɨgnapien mɨne apa ikɨn nəsanɨnien kape nɨmhəyen ramhen narmamə ikɨn, kɨni mamkɨr-pən nɨhutawə ye swatuk kape nəmərinuyen.” ");
INSERT INTO nwi_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kɨni pɨkwarien a nɨpran ramehuə, kɨni mamehuə mɨn ye nanmɨn kape Kughen. Kɨni nɨpɨg mɨfam in ramarə apa ye tɨpəvsɨk mameito kɨn nɨpɨg atuatuk yame tukrɨrikakun wok iran ye nɨmrɨ nəmə Isrel. ");
INSERT INTO nwi_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ye nɨpɨg a, yemə Rom kɨrik, nhagɨn e Sisa Ogastas, in ramarmaru ye tanə mɨnə fam kape Rom. In mamərəhu loa kɨrik mɨmə tukəvheikɨn fam narmamə yamə mɨne kɨsarə aikɨn a. ");
INSERT INTO nwi_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(In e nəvheikɨnien narmamə yame kɨmnəkupən kor. Ye nɨpɨg a, kwən e Kwaerinias in gavman kɨrik kape provins e Siria). ");
INSERT INTO nwi_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kaməvheikɨn narmamə, narmamə tukasəkeikei mharerɨg-pən mhavən hanə iməriə mɨnə ikɨn mə tukəvheikɨn əriə. ");
INSERT INTO nwi_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ror pən kwən a Josef mɨn rɨtərhav yerkwanu e Nasaret ye provins e Galili, mɨvən apa provins a Judia, yerkwanu kɨrik kamni kɨmə Betlehem, imei King Deved kupən. Rɨmavən aikɨn a meinai in kwənərəus kɨrik kape King Deved. ");
INSERT INTO nwi_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kwerpen ta Josef mɨne pian e Meri mə tukwarkurək; kɨni Meri natukreimək kɨn kwajikovə. Kɨni iriu kɨmɨravən apa Betlehem mə tukəvheikɨn mɨn əriu. ");
INSERT INTO nwi_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Kɨni kratərhav Betlehem, mɨrapəh nɨwəmien kwənmhan tukwapɨr ikɨn, mwarə ye nimə kape nar mɨragh. Mwarə hanə apaikɨn, kɨni rɨnor nɨpɨg kape kwajikovə tukrarha, kɨni reimək kɨn nɨmrɨn nupan kafan, yerman. Muvrɨg kɨn neipən, mərəhu-pən əmə in ye tɨkirao yame nar mɨragh mɨnə kasəvɨgɨn-pən iran. ");
INSERT INTO nwi_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kɨni ipakə əmə tuk yerkwanu e Betlehem, narmamə yamə mɨne kasəvɨgɨn sipsip mɨnə kasarə yerki mənvhirɨk masarha tuk sipsip mɨnə yenpɨg. ");
INSERT INTO nwi_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Məkneikɨn agelo kɨrik kape Kughen Yermaru rɨtərhav-pə tuk əriə, nɨkhakien kape Kughen Yermaru rɨsia-pen əriə, khagɨn pɨk. ");
INSERT INTO nwi_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mərɨg agelo a rɨmɨni-pən tuk əriə mɨmə, “Hapəh nhagɨnien. Meinai yo yakwauə mə jakni-pre nəvsaoyen huvə tuk əmiə, yame tukror rɨki narmamə ragien pɨk. Kɨni Nəvsaoyen a ramvən tuk narmamə mɨfam. ");
INSERT INTO nwi_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Taktəkun əmə, yermamə kɨrik rɨmnarha-pə ye taon kape King Deved. In ravəh mɨragh narmamə, kɨni In Kristo yame Kughen rɨmɨni-ta kupən mə tukrher-pə kɨn tuk əmiə. Kɨni In Yermaru. ");
INSERT INTO nwi_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kɨni taksəm kwajikovə en kɨmuvrɨg kɨn neipən, kərəhu-pən ye tikirao, ror nɨmtətien kɨmi əmiə mə kwajikovə a in a yakməni.” ");
INSERT INTO nwi_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Məkneikɨn, agelo mɨnə khapsaah khatərhav-pə masərer iriə min, masəgnəgɨn Kughen, mhani mhamə, ");
INSERT INTO nwi_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Pəh khani vi vi Kughen apa yerpɨrɨg ye neai. Kɨni narmamə ye tokrei tanə yamə mɨne rɨki Kughen ramagien tuk əriə, pəh kɨsarə ye nəmərinuyen.” ");
INSERT INTO nwi_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Məkneikɨn agelo mɨnə kɨmɨsəta ye yorwok ye sipsip mɨnə, mharerɨg-pən apa ye rao ye neai, kɨni yorwok ye sipsip mɨnə kɨmnhani tuk əriə mɨnə mhamə, “Pəh khavən apa Betlehem, mɨsəm-ru nar e Kughen Yermaru rɨmɨni-pə tuk ətawə.” ");
INSERT INTO nwi_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kɨshai mɨren mhavən mɨsəm Meri mɨne Josef mɨne kwajikovə yame ramapɨr-pən ye tikirao. ");
INSERT INTO nwi_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nɨpɨg kɨmɨsəm, kɨmnhani ərhav nəgkiarien yame agelo rɨmɨni ye kwajikovə, ");
INSERT INTO nwi_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","kɨni narmamə mɨfam yamə mɨne kɨmɨsərɨg nəgkiarien yame yorwok ye sipsip mɨnə kɨmnhani-pən tuk əriə, kɨsakur pɨk kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mərɨg Meri rɨmnətərɨg əmə kɨn narɨmnar mɨnə e, markut tuk nərɨgien nɨpran. ");
INSERT INTO nwi_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mərɨg yorwok ye sipsip mɨnə kɨmnharerɨg, mhavəhsi-haktə nhag Kughen, mhani vi vi In tuk narɨmnar m-fam yamə mɨne kɨmɨsəm mɨsərɨg; rəmhen əmə kɨn yame agelo rɨmɨni-ta tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kwajikovə a rɨmnarha, mɨvəh nɨpɨg eit, kɨni kɨmɨvəh nao kɨmin rəri-pən əmə loa kapəriə, kɨni khen-pən nhagɨn kɨmə Yesu, nhag yame agelo rɨmɨni-pən ta tuk Meri nɨpɨg in rɨmnor tɨpɨn. ");
INSERT INTO nwi_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Ye nɨpɨg a, tukmə kwajikovə kɨrik rarha, rɨmni mɨne nɨsɨni tukawəkeikei mwor sakrefaes kape nəspirien mamə, rəri-pən Loa kape Moses, kɨni ruauə atuatuk ye nɨpɨg kape Josef mɨne Meri mə tukwor məkna. Ror pən kɨrərəh Yesu mɨrhuvən Jerusalem, mɨravəh mak ye tanə kɨraru uə yəkwi-nətuən kɨraru kɨni mwhopni, rəri-pən əmə loa yame Kughen Yermaru rɨmɨni. Kɨni kɨmɨravəhsi-pən kwajikovə a kɨmi Kughen Yermaru. Nar a raməri-pən Nəgkiarien kape Kughen yame ramni mɨmə, “Nɨmrɨn nupan mɨnə yerman, tukaməkeikei kɨvəhsi-pən əriə kɨmi Kughen Yermaru mə kafan mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kɨni huaru kɨrik ramarə apa Jerusalem, nhagɨn e Simeon. Kafan nɨmraghien in ratuatuk huvə, kɨni nɨpɨg mɨfam in raməri-pən nəgkiarien kape Kughen. Kɨni in rameito kɨn nuəyen kape Kristo yame In tukruə mɨvəh mɨragh nəmə Isrel. Kɨni Nanmɨn kape Kughen ruə mɨkuar yerkin. ");
INSERT INTO nwi_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nanmɨn kape Kughen ruɨni-pən ta tukun mɨmə tukrɨpəh nɨmhəyen meriaji tukrəm Kristo yame Kughen Yermaru rɨmɨni mə tukrher-pə kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kɨni Nanmɨn kape Kughen rɨmnor rɨkin mə tukrauru-pən ye Nimə Ehuə kape Kughen. Kɨni Josef mɨne Meri kɨmɨrərəh Yesu mwaru-pən ye Nimə kape Kughen mə iriu tukwor narɨmnar fam yame Loa kape Moses ramni. ");
INSERT INTO nwi_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Məkneikɨn Simeon rɨmnəm Yesu, kɨni mɨrəh kɨn kwermɨn, kɨni mamni vi vi Kughen mamni-pən tukun mɨmə, ");
INSERT INTO nwi_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Kughen Yermaru, promes yame Ik nɨmɨni tuk yo, naknor əfrakɨs. Kɨni taktəkun ai, eighaan kɨn yo, yorwok e kafam, pəh yakmhə ye nəmərinuyen, ");
INSERT INTO nwi_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","meinai yaknəm kwajikovə e kɨn nɨmrɨk yame tukrɨwəh mɨragh narmamə. ");
INSERT INTO nwi_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ik nɨmnor apnəpeinə mə In tukrɨvəh mɨragh narmamə, kɨni narmamə m-fam tukharkun nar a. ");
INSERT INTO nwi_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","In tukruə rəmhen kɨn laet, mhajoun swatuk kɨn nəmə ye kantri pɨsɨn pɨsɨn mɨnə, Kɨni narmamə tukhavəhsi-haktə nəmə Isrel tukun.” ");
INSERT INTO nwi_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kɨni rɨm kwajikovə a mɨne nɨsɨni kwakur pɨk kɨn nəgkiarien yame Simeon rɨmɨni iran. ");
INSERT INTO nwi_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kɨni Simeon rəhuak mɨmə, “Pəh nɨhuvəyen kape Kughen tukrurə tuk əmiru.” Kɨni mɨni-pən tuk Meri, nɨsɨn kwajikovə a, mɨmə, “!Ǝrɨg-ru! Kughen rɨmɨrpen ta kwajikovə e mə tukror nəmə Isrel khapsaah tukhamɨr, kɨni mə tukror mɨn əriə khapsaah khavəh nɨmraghien. Kughen rɨmɨrpen pawk In mə In ror nɨmtətien kɨrik, mərɨg narmamə tukhani hah In. ");
INSERT INTO nwi_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ror pən tukəm əpu nərɨgien has kape narmamə khapsaah. Kɨni, Meri, rɨkim tukrəmhə tukun rəmhen kɨn yame yermamə kɨrik ramhai rɨkim kɨn nau nisə.” ");
INSERT INTO nwi_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kɨni piahwaru kɨrik ramarə aikɨn, nhagɨn e Ana. In profet kɨrik. In ji Fanuel, kwənərəus kape Aser kupən. Rɨnəpiahuaru əgkəp. Nɨpɨg rɨmnamətamaruə əmə, məri-pən kafan yerman. Mwarə kwis kape newk seven əmə, kwən a rɨmhə. ");
INSERT INTO nwi_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Rɨmnarə pɨsɨn əmə məknakɨn meriaji mɨpiəhuaru. Kɨni taktəkun ai kafan newk eiti fo. Nɨpɨg mɨfam in raməmɨr ye Nimə kape Ehuə Kughen maməhuak, yenpɨg mɨne yeraan. Matuakəm mɨpəh nəvɨgɨnien mə tukrəhuak kɨmi Kughen. ");
INSERT INTO nwi_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kɨni in rɨmauə atuatuk ye nɨpɨg yame Simeon raməgkiar kɨn kwajikovə a. Kɨni piahwaru ai rɨmɨni vi vi Kughen tukun, kɨni maməgkiar ye kwajikovə e kɨmi narmamə mɨfam yamə mɨne kamhawhin mə Kristo tukrɨrɨsɨn nəmə Jerusalem. ");
INSERT INTO nwi_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kɨni Josef mɨne Meri kɨmɨwor narɨmnar fam yame Loa kape Kughen Yermaru ramni, kɨni mərhɨrerɨg-pən imərisɨr ikɨn Nasaret ye provins e Galili. ");
INSERT INTO nwi_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kwajikovə a rɨnehuə muɨskai, muɨrkun huvə nar, kɨni nɨpɨg m-fam nɨhuvəyen kape Kughen rukwar ye kafan nɨmraghien. ");
INSERT INTO nwi_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ye newk mɨnə fam, rɨm Yesu mɨne nɨsɨni kɨmɨravən apa Jerusalem mə tukwor lafet kape Pasova. ");
INSERT INTO nwi_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kɨni nɨpɨg Yesu rɨmɨvəh newk twelef, kɨmɨwor norien yame kawor hanə, kɨni Yesu rɨkwasɨg kɨn əriu mɨrhɨvən apa faktə ye lafet a. ");
INSERT INTO nwi_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kɨni lafet rɨnor infamien, kɨni kafan mɨnə kɨmnharerɨg mhavən iməriə ikɨn; mərɨg tamaruə Yesu In rɨpəh nɨkwasɨgien kɨn rɨmni mɨne nɨsɨni, maməmɨr əmə apa Jerusalem. Kɨni iriu kweinein. ");
INSERT INTO nwi_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Krəmə-ta mə ramkwasɨg kɨn əriə. Kɨni kɨmɨsəriwək mamhavən tuk nɨpɨg piəpiə kɨrik. Mɨpirərikakun mwarha-kɨn yerki kwənərəus kapəriu mɨne iriu mɨnə tɨksɨn. ");
INSERT INTO nwi_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mərɨg kɨrapəh nɨwəmien In, mwarha-kɨn, mɨrarerɨg mɨravən Jerusalem. ");
INSERT INTO nwi_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kwarha-kɨn In nɨpɨg kɨsisər, kɨni mɨpiwəm apa ye Nimə Ehuə kape Kughen. Ramkwətə iriə nəmhajoun mɨnə, mamətərɨg kɨn əriə. Kɨni mamaiyoh əriə kɨn narɨmnar tɨksɨn. ");
INSERT INTO nwi_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kɨni narmamə mɨfam kɨmɨsərɨg In, kɨsakur tuk kafan nɨrkunien mɨne nhorpɨnien nəgkiarien mɨnə kafan. ");
INSERT INTO nwi_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kɨni rɨmni mɨne nɨsɨni kɨmɨwəm In, kwakur pɨk kɨn. Kɨni nɨsɨni rɨmɨni-pən tukun mɨmə, “Narɨk. ?Nɨmnhawor mor məkneikɨn irəmru? !Ǝrɨg-ru! !Kɨmru rɨmɨm, rɨkimru rəmhə pɨk tuk ik, kɨni yakwarha-kɨn pɨk ik!” ");
INSERT INTO nwi_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mərɨg In rɨni-pən tuk əriu mɨmə, “?Nakawarha-kɨn Yo tuk naha? Tukmə ror nakrapəh nɨrarkunien mə Yo jakaməkeikei maməmɨr ye Nimə kape Rɨmɨk.” ");
INSERT INTO nwi_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mərɨg iriu kɨrəpəh nɨrarkunien nɨprai nəgkiarien yame rɨmɨni-pən tuk əriu. ");
INSERT INTO nwi_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kɨni In rɨkwasɨg kɨn əriu, mɨrheiwaiyu mɨrhɨvən apa Nasaret. Kɨni In rɨmɨsiai əriu mamor nəkwairiu. Mərɨg nɨpɨg mɨfam nɨsɨni ramətərɨg kɨn narɨmnar mɨnə fam a. ");
INSERT INTO nwi_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Kɨni Yesu nɨpran ramehuə, kɨni kafan nɨrkunien ramhaktə pɨk. Kɨni ye nɨpɨg mɨfam, Kughen mɨne narmamə, rɨkiriə ragien əmə tukun. ");
INSERT INTO nwi_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kwasɨg ikɨn ye narɨmnar mɨnə a, yemə Rom kɨrik, nhagɨn e Taebirias Sisa, in ramehuə ye provins mɨnə fam kape Rom. Kɨni ye nɨpɨg in rɨnamarmaru meriaji newk fiftin, kɨni kwermɨn mɨnə tɨksɨn e: Herod Antipas ramehuə ye provins e Galili; mɨne piauni Filip in ramehuə ye provins mir e Ituria mɨne Trakonaetas, mɨne Lisanias ramehuə ye provins e Abilin, mɨne Ponjes Paelat in gavman kape provins e Judia. ");
INSERT INTO nwi_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","In e ye nɨpɨg atuatuk kape Anas mɨne Kaefas yame iriu jif pris mir. Ye nɨpɨg a, Jon, ji Sekaraea, yame rɨnehuə ta ai, mamarə apa ikɨn ruhiko ikɨn, kɨni Kughen rɨmɨvəh-sipən nəgkiarien kɨrik kɨmin. ");
INSERT INTO nwi_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kɨni in rɨmnokrən apomh pən ikɨn mɨnə ipakə tuk nu apa Jodan maməvsao-ərhav kɨn nəgkiarien kape Kughen. In mamni-pən mɨmə narmamə tukasəkeikei mɨsarar ye nərɨgien kapəriə tuk təvhagə has, kɨni mhavən tuk Kughen mə In tukrəspir norien has mɨnə kapəriə. Kɨni mə nɨmtətien kɨrik e, tukor baptaes irəriə. ");
INSERT INTO nwi_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","In rəri-pən əmə nəgkiarien yame Aesea rɨmɨrai kupən ye nəkwəkwə kafan mɨmə, “Kwən kɨrik ramokrən ehuə apa ikɨn ruhiko ikɨn mamni mɨmə, ‘Kɨmiə taksor apnəpeinə ye swatuk kape Yermaru, kɨni mɨsor kafan swatuk ratuatuk. ");
INSERT INTO nwi_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nɨkwətanə mɨnə fam tuksuun huvə, kɨni tukwas mɨnə mɨne nahawk mɨnə fam tuksətən-ətən, kɨni swatuk iko iko mɨnə tukərəhu atuatuk, kɨni swatuk yame rapəjiapət tukəkeikei kor rɨpiə. ");
INSERT INTO nwi_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kɨni narmamə mɨfam tuksəm swatuk kape Kughen tuk nɨvəh-mɨraghien narmamə.’” ");
INSERT INTO nwi_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kɨni ye nɨpɨg a, narmamə khapsaah kɨmnhavən tuk Jon mə in tukror baptaes irəriə; mərɨg rɨni-pən tuk əriə mɨmə, “!Kɨmiə naksahas rəmhen əmə kɨn snek yamə mɨne kasərhkwopah! Pəh nien mə tuktu, Kughen ror niemhaa mɨvəhsi-pən narpɨnien kɨmi narmamə. ?Mərɨg, pa ramni mə to kɨmiə nakharkun nɨsaptayen kɨn? ");
INSERT INTO nwi_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sor narɨmnar tɨksɨn yamə rhuvə mə tuksəm mə nakwəsəpəh əfrakɨs norien has mɨnə kɨni mhavən tuk Kughen. Nəfrakɨsien mə kɨmiə kwənərəus kape Ebraham, mərɨg rɨkimiə tukrɨpəh nəsɨkien mə Kughen tukraməkeikei mɨvəh mɨragh əmiə mhawor kɨmiə kwənərəus kape Ebraham. !Nɨkam, in nar apnapɨg əmə! Yakamni-pre tuk əmiə mə Kughen rɨrkun nor-mɨn-ien kapier apnapɨg ruə rəmhen kɨn kwənərəus kape Ebraham. ");
INSERT INTO nwi_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kɨni taktəkun ai, Kughen rɨnərer matuk ta mə tukrərəru nuknei nai. Kɨni tukmə nai kɨrik rɨpəh nɨkuəyen kɨn kwənkwan yame rhuvə, kɨni tukrərəru marakikɨn-pən ye nap.” ");
INSERT INTO nwi_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kɨni kwhen ehuə a kɨmɨsaiyoh Jon mhamə, “?Mərɨg, naha nhagɨn kɨmawə jakasəkeikei mɨsor?” ");
INSERT INTO nwi_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Kɨni Jon rɨni-pən tuk əriə mɨmə, “Tukmə kafam neipən kɨraru, vəhsi-pən kɨrik kɨmi yermamə yame kafan rɨrkək. Kɨni tukmə nam nəvɨgɨnien rarə, əhi-pən tɨksɨn kɨmi narmamə yamə mɨne nəriə rɨrkək.” ");
INSERT INTO nwi_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kɨni narmamə tɨksɨn yamə mɨne kasərer tuk mane kape takis kɨmnhauə mə Jon tukor baptaes irəriə, kɨn mɨsaiyoh in mhamə, “?Naha e nhagɨn kɨmawə jakasəkeikei mɨsor?” ");
INSERT INTO nwi_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Kɨni Jon rɨni-pən tuk əriə mɨmə, “Takhapəh nhavəh-sitayen mane tuk narmamə rapita yame rəmhen mə takhavəh.” ");
INSERT INTO nwi_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kɨni mobael mɨnə tɨksɨn kɨmɨsaiyoh mɨn mhamə, “?Mərɨg rhawor irəmawə? ?Naha e nhagɨn kɨmawə jakasəkeikei mɨsor?” Kɨni in rɨni-pən tuk əriə mɨmə, “Takhapəh nhaviyen nɨgɨnien kɨmi narmamə mhamə, ‘Tukmə nakhapəh nhavəh-si-pəyen mane, kɨni jaksor nəmhəyen kɨmi əmiə, uə jaksor əmiə naksarer ye nɨmrɨ mɨrh kɨni yakhani hah əmiə.’ Mərɨg rɨkimiə tukraməkeikei mamagien əmə tuk nərok atuatuk kapəmiə.” ");
INSERT INTO nwi_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kɨni narmamə mɨnə a kasəm mɨsəm, rɨkiriə ruh mə tukmə ror Jon in Kristo yame Kughen rɨmɨni mə tukrher-pə kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mərɨg Jon rhorpɨn nətərɨgien kapəriə mɨmə, “Yo yakamor baptaes irəmiə kɨn nu, mərɨg yermamə kɨrik tukrɨpiuə yame kafan nəsanɨnien mɨne nehuəyen rapita yo. Kɨni yo ye tanə əgkəp; yakpəh nəmhenien mə to yakənɨmkur mɨrɨsɨn ta nərəus ye kafan sandel. Kɨni In tukror baptaes irəmiə ye Nanmɨn kape Kughen mɨne nap. ");
INSERT INTO nwi_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","In ramərer matuk tuk nəmien norien kape narmamə maməwhai əriə, nəmə huvə mɨnə mɨne nəmə has mɨnə. Rəmhen əmə kɨn yame yeməsim ravəh safel tuk nəspir-tayen tɨki kwənkwai wit mə tukrɨpɨk nɨmitɨn yame rhuvə. Narmamə yamə mɨne khahuvə kɨsəmhen kɨn nɨmit wit, rɨpɨk əriə mamvən yerkwanu. Mərɨg narmamə has kɨsəmhen kɨn tɨki kwənkwai wit, ramarakikɨn-pən əriə ye nap ehuə yame ramuək rerɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kɨni Jon ramni-ərhav nəgkiarien rɨpsaah mamor kwirɨg kɨn kɨmi narmamə mə tukrɨvi-pə nətərɨgien kape narmamə khauə tuk Kughen. ");
INSERT INTO nwi_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ye nɨpɨg a, Herod Antipas rɨmɨkɨr ta Herodias in e piahwaru kape piauni, kɨni mamor narɨmnar rɨpsaah yame rahas. Mərɨg Jon rokrən skai kɨmin tukun. ");
INSERT INTO nwi_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ror pən Herod rɨmnəsɨk əpnis pən mɨn ye norien has kafan mɨvəhsi-pən Jon ye kalabus. ");
INSERT INTO nwi_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mərɨg kwasɨg ikɨn Jon rɨvən ye kalabus, kɨni in rɨnamor baptaes ye narmamə, kɨni Yesu mɨn rɨmavən, Jon ror baptaes iran. Kɨni nɨpɨg Yesu rɨmnaməhuak, Kughen rɨmnəhitə ye neai, ");
INSERT INTO nwi_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","kɨni Nanmɨn kape Kughen rɨsɨ-faktə meiwaiyu iran, nɨpran rəmhen kɨn mak ye tanə, kɨni nəgkiarien kɨrik rɨsɨ-pən ye rao ye neai mamni mɨmə, “Ik narɨk keikei; rɨkik ragien pɨk tuk ik.” ");
INSERT INTO nwi_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nɨpɨg Yesu rɨmɨrikakun kafan wok, kafan newk rəmhen kɨn toti. Narmamə khamə ta mə in ji Josef. Kɨni Josef in ji Heli, ");
INSERT INTO nwi_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli in ji Matat, Matat in ji Livae, Livae in ji Melki, Melki in ji Janae, Janae in ji Josef ");
INSERT INTO nwi_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josef in ji Matatias, Matatias in ji Amos, Amos in ji Neham, Neham in ji Esli, Esli in ji Nangae, ");
INSERT INTO nwi_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nangae in ji Mahat, Mahat in ji Matatias, Matatias in ji Semein, Semein in ji Josek, Josek in ji Joda, ");
INSERT INTO nwi_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda in ji Joanan, Joanan in ji Resa, Resa in ji Serubabel, Serubabel in ji Sealtiel, Sealtiel in ji Neri, ");
INSERT INTO nwi_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri in ji Melki, Melki in ji Adi, Adi in ji Kosam, Kosam in ji Elmadam, Elmadam in ji Ere, ");
INSERT INTO nwi_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ere in ji Josua, Josua in ji Eliesa, Eliesa in ji Jorim, Jorim in ji Matat, Matat in ji Livae, ");
INSERT INTO nwi_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livae in ji Simeon, Simeon in ji Juda, Juda in ji Josef, Josef in ji Jonam, Jonam in ji Eliakim, ");
INSERT INTO nwi_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim in ji Melea, Melea in ji Mena, Mena in ji Matataha, Matataha in ji Natan, Natan in ji Deved, ");
INSERT INTO nwi_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Deved in ji Jese, Jese in ji Obed, Obed in ji Boas, Boas in ji Salmon, Salmon in ji Nason, ");
INSERT INTO nwi_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason in ji Aminadab, Aminadab in ji Admin, Admin in ji Ani, Ani in ji Hesron, Hesron in ji Peres, Peres in ji Juda, ");
INSERT INTO nwi_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda in ji Jekob, Jekob in ji Aesak, Aesak in ji Ebraham Ebraham in ji Teraha, Teraha in ji Neho ");
INSERT INTO nwi_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neho in ji Serug, Serug in ji Rehu, Rehu in ji Peleg, Peleg in ji Eba, Eba in ji Sela, ");
INSERT INTO nwi_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela in ji Kenan, Kenan in ji Apaksad, Apaksad in ji Sem, Sem in ji Noa, Noa in ji Lamek, ");
INSERT INTO nwi_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek in ji Metusela, Metusela in ji Inok, Inok in ji Jared, Jared in ji Mahalalel, Mahalalel in ji Kenan, ");
INSERT INTO nwi_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan in ji Enos, Enos in ji Set, Set in ji Adam, kɨni Adam in ramsɨ-pən tuk Kughen. ");
INSERT INTO nwi_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nanmɨn kape Kughen rɨmɨkuar ye nɨmraghien kape Yesu, kɨni ye nɨpɨg ruasɨ-pən ye nu apa Jodan, Nanmɨn kape Kughen rɨkɨr In mɨvən apa ikɨn ruhiko ikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Aikɨn, Setan ramarkut mə tukrukrao ye nərɨgien kafan kape nɨpɨg foti. Ye nɨpɨg mɨnə fam a, In rapəh nəvɨgɨnien, kɨni ye nɨpɨg infamien, nɨkumhə rəs pɨk. ");
INSERT INTO nwi_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kɨni Setan rɨni-pən tukun mɨmə, “Tukmə ik Ji Kughen əfrah, ni-pən tuk kapier e mə rukreikɨn muə mor bred kɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mərɨg Yesu rhorpɨn mɨmə, “Kɨmɨrai ye Nəkwəkwə kape Kughen kɨmə, ‘Yermamə rɨpəh nɨmraghien əmə ye nəvɨgɨnien.’” ");
INSERT INTO nwi_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Məkneikɨn Setan rɨkɨr Yesu mɨvən apa ye tukwas apomh kɨrik, kɨni taktəkun əmə, rhajoun In kɨn kantri mɨnə fam ye tokrei tanə, ");
INSERT INTO nwi_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","kɨni mɨni-pən tukun mɨmə, “Yo jakərəhu-pre narmaruyen ye tanɨmtanə ye kwermɨm, mɨne nautə kapəriə mɨnə fam, meinai narɨmnar mɨfam a raməmɨr ye kwermɨk, kɨni yakɨrkun neighan-pənien kɨn kɨmi naha yermamə yame yakorkeikei mə jakvəhsi-pən kɨmin. ");
INSERT INTO nwi_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kɨni tukmə nakəhuak kɨmi yo, narɨmnar m-fam ai ik takor kafam kɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mərɨg Yesu rhorpɨn kafan nəgkiarien mɨmə, “Nəkwəkwə kape Kughen ramni mɨmə, ‘Taksəhuak əmə kɨmi kapəmiə Yermaru Kughen, mɨsəri-pən əmə kafan nərɨgien.’” ");
INSERT INTO nwi_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Məkneikɨn Setan rɨkɨr In mərɨp In apa Jerusalem mhaktə ye tokrei Nimə Ehuə kape Kughen apa yerpɨrɨg əgkəp. Kɨni mɨni-pən tukun mɨmə, “Tukmə ik Ji Kughen əfrakɨs, iv-ərhav-ru ikɨn e, ");
INSERT INTO nwi_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","meinai kɨmɨrai kɨmə, “‘In tukrher-pə kɨn agelo mɨnə kafan khauə masarha huvə tuk ik. ");
INSERT INTO nwi_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tukharaptərəkɨn ik kɨn kwermɨriə mə takpəh nowhan-pənien nɨhum ye kapier kɨrik.’” ");
INSERT INTO nwi_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mərɨg Yesu rhorpɨn kafan nəgkiarien mɨmə, “Mərɨg Nəkwəkwə kape Kughen ramni mɨmə, “Takhapəh nɨsəm-əsaahyen kapəmiə Kughen Yermaru mə ramarha huvə əfrakɨs tuk əmiə uə nɨkam.’ ” ");
INSERT INTO nwi_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kɨni Setan ror infamien ye nɨvəhsi-pən vəhsi-pənien kɨmi Yesu; məkneikɨn, mapitan kɨn Yesu mawhin nɨpɨg huvə yame tukruə mɨn tukun. ");
INSERT INTO nwi_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kɨni ai, Yesu rɨmɨrerɨg-pən Galili, kɨni nəsanɨnien kape Nanmɨn kape Kughen rɨmɨkuar ye nɨmraghien kafan. Kɨni kɨmnəvsao kɨn In rarkurao ye tanə a. ");
INSERT INTO nwi_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kɨni Yesu rɨmnhajoun ye nimə kape nofugɨnien mɨnə, kɨni narmamə m-fam khani vi vi In. ");
INSERT INTO nwi_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kɨni Yesu rɨmauə Nasaret, aikɨn rɨmnehuə ikɨn kupən. Kɨni ye Sabat kɨrik, In rɨmavən ye nimə kape nofugɨnien rəmhen əmə kɨn yame ramor hanə. Kɨni mərer mə tukrəvheikɨn Nəkwəkwə kape Kughen, ");
INSERT INTO nwi_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","kɨni kɨvəhsi-pən nəkwəkwə yame kɨmnarpəvɨn-arpəvɨn yame profet Aesaea rɨmɨrai kupən. Kɨni ruhatukɨn nəkwəkwə məm nəgkiarien yame Aesaea rɨmɨrai yame ramni mɨmə, ");
INSERT INTO nwi_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Nanmɨn kape Kughen ramarə irak meinai In rɨmɨrpen yo, jakəvsao-ərhav kɨn nəgkiarien huvə kɨmi yavən hah mɨnə. Kɨni In rher-pə kɨn yo mə jakvən mamni-pən tuk narmamə yamə mɨne kɨvəhsi-pən əriə ye kalabus mə tukɨrɨsɨn əriə, kɨni mɨni-pən tuk nɨmrɨn pɨs mɨnə mə tuksəm mɨn nar. Kɨni rher-pə kɨn yo mə jakrɨsɨn narmamə yamə mɨne kasəmɨr ye kwermɨ narmamə pɨsɨn masərɨg rahah, ");
INSERT INTO nwi_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","mamni-ərhav mə nɨpɨg ruauə ta yame Kughen Yermaru tukrhajoun kafan nɨhuvəyen mɨvəh mɨragh narmamə.” ");
INSERT INTO nwi_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu rɨmnəhueikɨn ta nəkwəkwə a, kɨni meiwaiyu mɨvəhsi-pən mɨn kɨmi yermamə yame ramarha huvə tuk nəkwəkwə mɨnə, kɨni mamkwətə mə tukrəvhag kɨmi narmamə. Kɨni narmamə m-fam ye nimə kape nofugɨnien kasarha tɨm tɨm iran. ");
INSERT INTO nwi_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kɨni In raməgkiar kɨmi əriə mamni mɨn mɨmə, “Taktəkun ai, ye nɨpɨg yame nɨmɨsərɨg Nəkwəkwə e Kape Kughen, nɨniyen a ruauə mɨnor nəfrakɨsien kɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kɨni narmamə mɨfam kasəgnəgɨn In, kɨni kɨsakur pɨk tuk nəgkiarien huvə yamə mɨne ramni, kɨni mɨsaiyoh əriə mɨnə mhamə, “?Mərɨg kwən e In ji Josef əmə uə?” ");
INSERT INTO nwi_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “Yakɨrkun mə takpihani nəgkiarien akwas e tuk yo yame ramni mɨmə, ‘Dokta, or huvə atuk-ru nɨpram,’ mhani mɨn mhamə, ‘Narɨmnar yamə mɨne yɨmɨsərɨg mə nɨmnor ta apa Kapaneam, rhuvə mə takuə mor mɨn e, imam ikɨn.’ ");
INSERT INTO nwi_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nəfrakɨsien, yakamni tuk əmiə mə narmamə to khapəh nhasiaiyen profet kɨrik yame ramsɨ-pən irəriə. ");
INSERT INTO nwi_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ye nɨpɨg kape Elaeja, nəhig rɨpəh nɨpien newk kɨsisər mɨne makuə sikis, kɨni nɨkumhə ravən ikɨn mɨnə fam, nəvɨgɨnien rɨrkək. Kɨni yakni nəfrakɨsien tuk əmiə mɨmə, ye nɨpɨg a nɨpiahuaru kɨmhə tan kɨn əriə khapsaah e Isrel, ");
INSERT INTO nwi_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","mərɨg pəh nien mə Kughen rher-pə kɨn Elaeja mə tukrɨvən masitu irəriə. Nɨkam. In rher-pə kɨn mə tukrasitu əmə ye piahwaru kɨrik yerkwanu Jarefat apa ye provins e Saedon. Mərɨg piahwaru a pəh nien mə pian Isrel. ");
INSERT INTO nwi_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kɨni ye nɨpɨg kape profet e Elisa, narmamə khapsaah kɨmnɨsarə Isrel yamə mɨne kamhawəh nəmhəyen e ‘leprosi’ mərɨg Elisa rɨpəh nor-huvəyen kɨrik. Mərɨg in rɨmnor huvə əmə kwən Siria e Neman, yame pəh nien mə yemə Isrel.” ");
INSERT INTO nwi_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Narmamə ye nimə kape nofugɨnien kɨmɨsərɨg nəgkiarien a, niemhaa rhai pɨk əriə m-fam. ");
INSERT INTO nwi_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kɨni kɨsarar mharəh In, mɨsəukəkin mhatərhav yerkwanu, mhavən mɨsokrig ye tukwas yame kɨmnor taon ikɨn, mə tuksarkwərhav kɨn apa ikəutən. ");
INSERT INTO nwi_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mərɨg Yesu rɨvən-pən ta ye kwənɨmrheriə, map. ");
INSERT INTO nwi_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kɨni Yesu rɨmneiwaiyu apa Kapaneam, taon kɨrik ye provins e Galili. Kɨni ye Sabat kɨrik, In raməvhag kɨmi narmamə. ");
INSERT INTO nwi_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kɨni narmamə kɨmɨsərɨg nəgkiarien kafan, kɨmɨsakur kɨn, meinai nəgkiarien kafan, nanmɨn aikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kɨni ye nəkwai nimə kape nofugɨnien, kwən kɨrik aikɨn yame nanmɨn has ramərer-pən iran. Kɨni in rokr-apomh mɨmə, ");
INSERT INTO nwi_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“!Eh, Yesu, yemə Nasaret! ?Rhawor? ?Nɨmauə mə takoriah əmawə uə? Yakwɨrkun ta ik. !Ik yemə rhakə kape Kughen!” ");
INSERT INTO nwi_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mərɨg Yesu rɨmnəgkiar skai kɨmin mɨmə, “!Ah, pim! !Ǝta ye kwən e!” Kwən a ramərer ye kwerkwan irəriə, məkneikɨn nanmɨn hah a rəsuə kɨn reiwaiyu mowhan ye nɨmoptanə, map ta iran, kɨni mɨpəh noriahyen in. ");
INSERT INTO nwi_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kɨni narmamə m-fam aikɨn a kɨsakur kɨn, mhani-pən tuk əriə mɨnə mhamə, “!Eh! Nəgkiarien pɨsɨn kɨrik e. Kwən a kafan nəgkiarien nanmɨn aikɨn. Tukmə In rəgkiar kɨmi nanmɨn has mɨnə, kasəta ye narmamə.” ");
INSERT INTO nwi_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kɨni nəvsaoyen kape Yesu rɨtərhav markurao ye tanə a. ");
INSERT INTO nwi_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Aikɨn, Yesu rarar, mɨtərhav ye nimə kape nofugɨnien mɨvən apa nimə kape Saemon Pita. Ye nɨpɨg a, kuhu Saemon ramhə maməpan pɨk, kɨni iriə kɨsaiyoh-pən Yesu mə tukror huvə. ");
INSERT INTO nwi_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Kɨni Yesu rərer ipakə tukun, məgkiar skai kɨmi nəpanien, nəpanien rəta. Taktəkun əmə piahwaru a rərer, mɨvən mɨruk ta nəriə nəvɨgɨnien. ");
INSERT INTO nwi_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kɨni nɨpɨg mɨrh natukrivə, narmamə kɨmnhapɨk narmamə m-fam yamə mɨne kamhamhə, mhavən tuk Yesu. Kɨni In rərəhu-pən kwermɨn irəriə kɨrikianə kɨrikianə, kɨni iriə m-fam kɨsəsanɨn. ");
INSERT INTO nwi_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kɨni yarmhə mɨnə mɨn kamhatərhav mɨsap ye narmamə khapsaah, mɨsokrən apomh mhamə, “!Ik Ji Kughen!” Mərɨg Yesu rəgkiar skai kɨmi əriə mətapɨg kɨn əriə tuk nəgkiarien meinai iriə kwənharkun ta mə In Kristo yame Kughen rɨmnher-pə kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kəni rɨkwamer kɨn, Yesu rɨtərhav aikɨn a, mɨvən apa ikɨn kɨrik. Mərɨg narmamə kɨmɨsarha-kɨn In, kɨni nɨpɨg kɨmɨsəm, khauə tukun mɨsarkut mhamə tukhani-əhu mhamə In tukrɨpəh nəpəhyen əriə. ");
INSERT INTO nwi_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mərɨg əmə Yesu rɨni-pən tuk əriə mɨmə, “Nɨkam. Yo jakaməkeikei mɨvən yerkwanu pɨsɨn pɨsɨn mɨnə, mɨni-ərhav Nəvsaoyen Huvə kape narmaruyen kape Kughen, meinai Kughen rɨmnher-pə kɨn yo mə jakor məkneikɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kɨni In rɨmavən mameriwək ye tanə Judia mamni-ərhav nəgkiarien kape Kughen ye nimə kape nofugɨnien mɨnə. ");
INSERT INTO nwi_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nɨpɨg kɨrik, Yesu rərer ye nɨkar-kar nu ehuə kamni kɨmə Galili, kɨni narmamə khapsaah kɨmnhauə mɨsərer rarkurao iran mhamə tuksərɨg nəgkiarien kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kɨni In rɨmnəm kwaji rao kɨraru yame narmamə kape nɨviyen kəməəm kɨmnhapəh kawərer ye nɨpakɨr mɨsaikwas ye kapəriə net mɨnə. ");
INSERT INTO nwi_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Məkneikɨn Yesu ratpən ye rao kape Saemon Pita, mɨni-pən tukun mə tukrɨvi-pirə rao. Saemon rɨvi-pirə rao, kɨni Yesu rəkwətə-pən aikɨn maməvhag kɨmi narmamə. ");
INSERT INTO nwi_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yesu rɨmnəgkiar infamien, kɨni mɨni-pən tuk Saemon mɨmə, “Saemon, əsuə. Pəh khavən apa ikəmnɨm, pəh naksaruk kɨn net mɨnə mhavi kəməəm tɨksɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Mərɨg Saemon rɨni-pən tukun mɨmə, “Yemehuə, yenpɨg, yɨmɨsarkut pɨk tuk nar e mɨseriaji reraan, mərɨg yɨmnhapəh nɨviyen kəməəm kɨrik. Mərɨg ik nakmə tukhavən mɨn, ror pən, pəh khavən mɨsaruk mɨn kɨn net mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Khavhirə, mɨsaruk kɨn net mɨnə, mhavi kəməəm khapsaah pɨk, ror net mɨnə kapəriə khakwar huvə kɨn kəməəm, mharikakun mɨseikus net mɨnə. ");
INSERT INTO nwi_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kɨni iriə kɨsokrən-pən kɨn iriə mɨnə tɨksɨn ye rao mɨn kɨrik mhamə tukhauə mɨsasitu irəriə. Kɨni khauə mɨsarakə-pən kɨn kəməəm ye rao mir a kwəkrig, ipakə əmə rao mir kwəmnɨm. ");
INSERT INTO nwi_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kɨni Saemon Pita rɨmnəm, kɨni rənɨmkur-pən tuk Yesu mamni mɨmə, “Yermaru. !Yuvən isok tuk yo, meinai yo yakpəh nəmhenien! Yo yor təvhagə hah kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","In rɨmnəgkiar məknaikɨn meinai in mɨne narmamə mɨnə a ye rao mir, kɨmɨsakur pɨk kɨn kəməəm khapsaah yamə mɨne kɨmnhavi. ");
INSERT INTO nwi_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Kɨni Jemes mɨne Jon, ji Sebedi mir, yamə mir e kawor wok irisɨr Saemon, iriu mɨn kɨmɨwakur pɨk kɨn. Mərɨg Yesu rɨni-pən tuk Saemon mɨmə, “Pəh nɨgɨnien. Ik yermamə kape nɨviyen kəməəm. Mərɨg taktəkun ai mamvən, ik takvi-pə narmamə.” ");
INSERT INTO nwi_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ror pən, kɨmnhavi-fiak kapəriə rao mɨnə, mɨsəpəh narɨmnar mɨ-fam mhakwasɨg əmə kɨn Yesu, kɨni mhauə kafan narmamə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nɨpɨg kɨrik, Yesu rɨmneriwək mɨvən yerkwanu kɨrik, kɨni kwən kɨrik yame ravəh nəmhəyen e leprosi, kɨni nɨmhəyen ai rɨvəh fam nɨpran. Kɨni rəm Yesu, rəriwək muə tukun, meiwaiyu, mənɨm-pən nɨpəghigɨn ye nɨmoptanə, kɨni mamasək ətgɨn Yesu mɨmə, “Yermaru, tukmə nakɨrkun mə to nakor huvə yo, or huvə yo, məspir ta nəmkɨmɨk irak.” ");
INSERT INTO nwi_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kɨni Yesu rərao-pən mɨrap kwən a, mɨmə, “Ǝwəh. Yakorkeikei mə jakor. !Ǝsanɨn!” Kɨni taktəkun əmə nəmhəyen e leprosi rəta. ");
INSERT INTO nwi_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mərɨg Yesu rɨmɨni-əhu in mɨmə, “Takpəh nɨni-ərhavyen narɨmnar mɨnə e kɨmi narmamə. Mərɨg yuvən məm pris kɨrik pəh in rəm mə nɨpram rɨnor məknen. Kɨni or sakrefaes kɨmi Kughen rəri-pən yame Loa kape Moses rɨmɨni ye yermamə kɨrik yame kafan leprosi ruɨrkək, pəh narmamə tukharkun mə nəfrakɨsien nakwahuvə, kɨni kafam nəmkɨmɨk ruɨrkək.” ");
INSERT INTO nwi_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mərɨg nəvsaoyen kape Yesu ramtərhav mamvən ikɨn mɨnə fam, kɨni narmamə khapsaah kamhauə mə tuksətərɨg kɨn kafan nəgkiarien kɨni mhamə In tukror huvə nəmhəyen mɨnə kapəriə. ");
INSERT INTO nwi_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mərɨg, nɨpɨg rɨpsaah, In ramvən pɨsɨn əmə apa ikɨn kɨrkək ikɨn, maməhuak. ");
INSERT INTO nwi_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nɨpɨg kɨrik, Yesu rɨmnhajoun apa nimə kɨrik, kɨni Farisi mɨnə, mɨne nəmhajoun mɨnə kape Loa kape Moses, iriə kasəkwətə mɨn aikɨn. Kɨmnhasɨ-pən apa yerkwanu mɨnə apa provins mir e Galili, mɨne Judia, mɨne Jerusalem. Kɨni nəsanɨnien kape Kughen Yermaru ramarə tuk Yesu mə tukror huvə narmamə yamə mɨne kamhamhə. ");
INSERT INTO nwi_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ye nɨpɨg a, narmamə tɨksɨn kɨmnharəh kwən kɨrik mhauə yame ramapɨr-pən əmə ye nɨkaokao, meinai nɨpran rɨmhə. Kɨni iriə kɨsorkeikei mə tukharəh mɨsərəhu-pən ye nɨhu Yesu. ");
INSERT INTO nwi_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mərɨg kɨseinein mə tukshawor mhavən imə, meinai narmamə khapsaah aikɨn. Kɨni kɨmnhavən apa ye tokrei nimə, mɨsəhipu ta nɨkar nimə kɨrik, mharəh nɨkaokao yermamə ramapɨr-pən iran, mhavi, reiwaiyu-pən ye kwerkwan ye narmamə, ipakə əmə tuk Yesu. ");
INSERT INTO nwi_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kɨni Yesu rəm nhatətəyen kapəriə mɨni-pən tuk kwən a mɨmə, “Yo kɨrik. Kafam norien has mɨnə, yakwərəh-si ta fam narpɨnien iran.” ");
INSERT INTO nwi_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mərɨg nəmhajoun kape Loa kape Moses mɨne Farisi mɨnə, rɨkiriə rəsɨk mɨmə, “?Kwən e raməgkiar məkne, mamni hah Kughen. Kughen pɨsɨn əmə In rɨrkun nɨvəh-sitayen narpɨnien kape norien has kape narmamə. ?Pa mɨn to rɨvəh-si ta?” ");
INSERT INTO nwi_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mərɨg Yesu In ruɨrkun ta əmə kapəriə nətərɨgien, kɨni mɨni-pən tuk əriə mɨmə, “?Rhawor e nakasətərɨg məkneikɨn? ");
INSERT INTO nwi_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","?Jakni-pən naha tuk yermamə a, kɨni kɨmiə nakasəm əfrakɨs? ?Mə jakni-pən tukun mə narpɨnien kape kafan təvhagə hah yakwərəhsi-ta ta? ?Uə mə jakni-pən tukun mə tukrhekɨmter meriwək mamvən? ");
INSERT INTO nwi_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mərɨg yakorkeikei mə jakor yo mə takharkun mə yo, Ji Yermamə, yakvəh nehuəyen ye tokrei tanə tuk nɨvəhsi-tayen narpɨnien kape təvhagə has.” Kɨni marə mɨni-pən tuk kwən a mɨmə, “Yakamni-pre tuk ik mə, takhekɨmter, mɨrəh kafam nɨkaokao mamvən imam yerkwanu.” ");
INSERT INTO nwi_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kɨni taktəkun əmə, kwən a rhekɨmter, mɨrəh kafan nɨkaokao məriwək maməgnəgɨn Kughen mamvən. ");
INSERT INTO nwi_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kɨni iriə m-fam kɨsakur pɨk kɨn, masəgnəgɨn Kughen. Khagɨn, mhamə, “Man, kɨmɨsəm əfrakɨs nar apsɨpɨs mɨnə e towei.” ");
INSERT INTO nwi_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kwasɨg ikɨn ye narɨmnar mɨnə e, Yesu rɨtərhav maməriwək mamvən, kɨni məm kwən kɨrik yame ramərer tuk mane kape takis, nhagɨn e Livae. Ramkwətə ikɨn kamərok takis ikɨn. Kɨni Yesu rɨmɨni-pən tukun mɨmə, “Yuə, mɨkwasɨg kɨn Yo.” ");
INSERT INTO nwi_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Məkneikɨn rɨmnəpəh narɨmnar fam kafan, mərer, mɨkwasɨg kɨn Yesu. ");
INSERT INTO nwi_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kɨni ai, Livae rɨmaraptərəkɨn nəvɨgɨnien ehuə kɨrik kape Yesu ye nimə kafan. Kɨni narmamə khapsaah yamə mɨne kasərer tuk mane kape takis, mɨne narmamə apnapɨg mɨnə, kɨmnhavən mɨsəkwətə iriə min, mə tuksəvɨgɨn kwis. ");
INSERT INTO nwi_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mərɨg Farisi mɨnə mɨne narmamə mɨn tɨksɨn irəriə yamə mɨne iriə nəmhajoun kape Loa kape Moses, rɨkiriə rapəh nagienien, kɨni mhani-pən tuk narmamə kape Yesu mɨnə mhamə, “?Rhawor e nakasəvɨgɨn kwis kɨmiə narmamə yamə mɨne kasərer tuk mane kape takis mɨne yor təvhagə has mɨnə?” ");
INSERT INTO nwi_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mərɨg Yesu rɨni-pən tuk əriə mɨmə, “Pəh nien mə narmamə yamə mɨne kɨsəsanɨn khavən masəm dokta. Mərɨg narmamə yamə mɨne kamhamhə, tukasəkeikei mhavən mɨsəm dokta. ");
INSERT INTO nwi_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Pəh nien mə Yo yɨmauə mə jakokrən kɨn narmamə yamə mɨne kwəsatuatuk ta. Nɨkam. Yɨmauə mə jakokrən kɨn yor təvhagə has mɨnə, mə tuksarar ye kapəriə nərɨgien.” ");
INSERT INTO nwi_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kɨni iriə kɨmnhani-pən tuk Yesu mhamə, “Ǝmru. Narmamə kape Jon Baptaes, nɨpɨg rɨpsaah kɨsəpəh nəvɨgɨnien masəhuak kɨmi Kughen; mɨne Farisi mɨnə mɨn. ?Mərɨg rhawor kafam narmamə mɨnə kasəvɨgɨn əmə mamharpɨn?” ");
INSERT INTO nwi_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mərɨg Yesu rɨni-pən tuk əriə mɨmə, “?Nɨpɨg kɨmiə nakmasor nəvɨgɨnien kape yerman yame rɨmnarkurək pə pə, mərɨg nakhani-əhu in mɨnə tɨksɨn mə tukhapəh nɨsəvɨgɨnien uə? !Nɨkam! ");
INSERT INTO nwi_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mərɨg tukrɨpior nɨpɨg yame narmamə tukhawəhsi-ta Yerman e yame rɨmnarkurək pə pə tuk In mɨnə tɨksɨn. Kɨni ye nɨpɨg a in a, In mɨnə tɨksɨn tuksəpəh nəvɨgɨnien iran.” ");
INSERT INTO nwi_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kɨni Yesu rɨmɨni mɨn nuhpɨkɨnien kɨrik tuk əriə mɨmə, “To yermamə kɨrik rɨpəh nɨwəhyen kwonmut neipən vi kɨrik kɨni mɨjir-pən ye neipən mətɨt kafan yame rɨmneikus. To ror məknakɨn, kɨni tukroriah kwonmut neipən yame rɨvi, kɨni neipən vi tukrɨpəh nəmɨr-pən-tɨm-tɨm-ien ye neipən mətɨt. ");
INSERT INTO nwi_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kɨni to yermamə kɨrik rɨpəh nɨvhyen waen vi kɨni mɨvi-pən ye tɨki waen mətɨt. To ramor məknakɨn, kɨni waen a ye tɨki waen mətɨt tukrəməteih, kɨni waen tukraiyu. ");
INSERT INTO nwi_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nɨkam. Waen vi tukaməkeikei kɨvi-pən ye tɨki waen vi. ");
INSERT INTO nwi_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kɨni yermamə yame ruɨnɨm ta waen, in rɨpəh norkeikeiyen mə tukrɨnɨm waen vi, mərɨg in ramni mɨmə, ‘Waen akwas in rhuvə rapita.’” ");
INSERT INTO nwi_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kɨni ye Sabat kɨrik, Yesu mɨne kafan narmamə mɨne kɨmɨseriwək mhavən yerki wit tɨksɨn, kɨni kafan narmamə mɨne kɨmɨsətɨm wit tɨksɨn mɨsəkwai-əkwai, masən kwənkwan. ");
INSERT INTO nwi_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mərɨg Farisi mɨnə tɨksɨn kɨmnhani mhamə, “!Eh! Sabat e towei, mərɨg iriə kasor wok masakapɨr Loa kape Moses. ?Rhawor kafam narmamə kasor məknakɨn?” ");
INSERT INTO nwi_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Mərɨg Yesu rɨmɨni-pən tuk əriə mɨmə, “Tukmə ror nakhapəh nɨsəvheikɨnien nəvsaoyen ye Nəkwəkwə kape Kughen yame raməvsao kµn norien yame King Deved rɨmnor kupən, yame in mɨne kafan narmamə mɨnə, nəriə nəvɨgɨnien ramrɨrkək, kɨsəmkərəv. ");
INSERT INTO nwi_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Mərɨg, Deved rɨmavən ye Nimə Ehuə kape Kughen mən bred yame pris mɨnə kwənhawəhsipən-ta kɨmi Kughen. Kɨni mərɨg Deved rɨmɨvəhsi-pən mɨn kɨmi kafan narmamə kɨsən mɨn. Kɨni mərɨg bred a, ye Loa kape Moses ramni mə narmamə apnapɨg tukhapəh nɨsənien. Mərɨg pris mɨnə əmə kharkun nɨsənien.” ");
INSERT INTO nwi_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kɨni Yesu rɨmɨni-pən tuk əriə mɨmə, “Yo, Ji Yermamə, Yo yakamarmaru ye Sabat.” ");
INSERT INTO nwi_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kɨni ye Sabat mɨn kɨrik, Yesu rɨmavən ye nəkwai nimə kape nofugɨnien, maməwhag kɨmi narmamə. Kɨni aikɨn a, kwən kɨrik aikɨn yame kwermɨn matuk rɨmhə mɨrpəvɨn. ");
INSERT INTO nwi_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kɨni nəmhajoun kape Loa kape Moses mɨnə mɨne Farisi mɨnə kɨmɨsarkut mə tuksəm-ru naha nhagɨn yame tukhani hah Yesu iran, mɨsarha əterɨk mə tuksəm-ru mə Yesu to ror huvə kwən a ye Sabat uə nɨkam. ");
INSERT INTO nwi_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mərɨg Yesu ruɨrkun ta nərɨgien kapəriə, kɨni mɨni-pən tuk yermamə yame kwermɨn rɨmhə mɨrpəvɨn mɨmə, “Yuə, mərer ye nɨmrɨ narmamə m-fam.” Kɨni rɨvən mərer əkupən. ");
INSERT INTO nwi_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kɨni Yesu rɨmɨni-pən tuk əriə mɨmə, “?Loa kape Moses ramni mə nakharkun nɨsorien naha nhagɨn ye Sabat? ?Ramni mə takasor norien huvə uə takasor norien has? ?Mə takshopni yermamə uə takhavəh mɨragh yermamə?” ");
INSERT INTO nwi_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Kɨni rɨmnarha mərərao irəriə, mɨni-pən tuk kwən a mɨmə, “Huatuk kɨn kwermɨm.” Kɨni ruhuatuk kɨn kwermɨn, rhuvə əgkəp. ");
INSERT INTO nwi_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mərɨg niemhaa rhai pɨk narmamə mɨnə a, kɨmnhavən, mhani-pən tuk əriə mɨnə mə tukshawor pən iran mɨne ye Yesu. ");
INSERT INTO nwi_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kɨni ye nɨpɨg a, Yesu rɨmnhaktə fiak ye tukwas kɨrik maməhuak, kɨni maməhuak kɨmi Kughen meriaji reraan. ");
INSERT INTO nwi_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kɨni yenpɨg-enpɨg, rɨmnokrən kɨn kafan narmamə mɨnə mə tukhauə masəm In. Kɨni mɨrpen narmamə twelef irəriə mɨvəhsi-pən nehuəyen kɨmi əriə mɨmə “aposol mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nhag namasur twelef e ror məknekɨn: Saemon (yame Yesu rɨmnhen-pən nhagɨn vi mə Pita), mɨne piauni Andrew, mɨne Jemes, mɨne Jon, mɨne Filip, mɨne Batalomiu, ");
INSERT INTO nwi_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","mɨne Matiu, mɨne Tomas; mɨne Jemes ji Alfeas, mɨne Saemon Selot, ");
INSERT INTO nwi_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","mɨne Judas ji Jemes; mɨne Judas Iskariot, yame kwasɨg ikɨn rɨmnor kəut kəsuə kɨn Yesu kɨmi nəmə has mɨnə. ");
INSERT INTO nwi_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kɨni Yesu mɨne kafan narmamə mɨnə kɨmnhasɨ-faktə mhauə ikɨn rətən-ətən ikɨn, mɨsəm narmamə khapsaah aikɨn- kɨmnhasɨ-pən yerkwanu mɨnə ye provins e Judia, mɨne Jerusalem, mɨne ye nɨkar-kar tahik apa taon mir e Taea mɨne Saedon. ");
INSERT INTO nwi_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Kɨmnhauə mə tuksərɨg nəgkiarien kape Yesu kɨni mə tukror huvə nəmhəyen mɨnə kapəriə. Kɨni In rɨmnor huvə narmamə yamə mɨnə nanmɨn has mɨnə kɨmɨsoriah əriə. ");
INSERT INTO nwi_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kɨni narmamə yamə mɨne kɨmɨsərer rao rao kɨn, mɨsarkut mə tukharap In meinai nəsanɨnien ramsɨ-pən iran mamor huvə fam narmamə. ");
INSERT INTO nwi_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Kɨni Yesu rarha-pən məm kafan narmamə mɨnə, mɨni-pən tuk əriə mɨmə, “Kɨmiə e yavən has mɨnə, nakasarə ye nɨhuvəyen əfrakɨs. In nɨhuvəyen əfrakɨs meinai, kɨmiə narmamə kape Kughen, kɨni In ramarmaru irəmiə. ");
INSERT INTO nwi_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kɨmiə yamə mɨne naksəmkərəv ai taktakun, nakasarə ye nɨhuvəyen əfrakɨs. In nɨhuvəyen əfrakɨs meinai, takpisəvɨgɨn rəmhen. Kɨmiə yamə mɨne naksasək ai taktəkun, nakasarə ye nɨhuvəyen əfrakɨs. In nɨhuvəyen əfrakɨs meinai, takpisarh. ");
INSERT INTO nwi_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nakasarə ye nɨhuvəyen əfrakɨs ye nɨpɨg narmamə tuksəməkɨn əmiə, kɨni mhapəh nɨseighanien kɨn əmiə mə taksor narɨmnar kɨmiə miriə, kɨni mhani hah əmiə, kɨni masoriah nhagmiə mhamə kɨmiə narmamə kape yarmhə mɨnə, kɨni iriə tuksor məknakɨn irəmiə meinai yo e yo Ji Yermamə, kɨni kɨmiə, kafak narmamə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Kɨni rɨpriə mɨnə kɨmɨsor məknakɨn ye profet mɨnə kupən. Mərɨg ye nɨpɨg narɨmnar a ramuə tuk əmiə, taksagien, mhavi-haktə-haktə meinai nərokien kapəmiə ramarə apa ye rao ye neai. ");
INSERT INTO nwi_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“!Kəsi! Mərɨg nəmhəyen ehuə tukrurə tuk əmiə yamə mɨne kapəmiə nautə rehuə ai taktəkun, meinai nakwənhavəh nar huvə, mərɨg tukrɨpior infamien. ");
INSERT INTO nwi_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","!Kəsi! Nəmhəyen ehuə tukrurə tuk əmiə yamə mɨnə nakasəvɨgɨn tɨpɨmiə raməsiis, meinai takpisəmkərəv. !Kəsi! Nəmhəyen ehuə tukrurə tuk əmiə yamə mɨnə nakasarh ai taktəkun, meinai, takpisasək rɨkimiə rəmhə. ");
INSERT INTO nwi_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","!Kəsi! Nəmhəyen ehuə tukrurə tuk əmiə nɨpɨg narmamə kamhavəh-si haktə nhagmiə meinai, rɨpriə mɨnə kupən kɨmnhavəh-si haktə nhag profet eikuə mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Kɨni Yesu rɨmɨni mɨn mɨmə, “Mərɨg yakamni-pre tuk əmiə yamə mɨnə nakasərɨg Yo mɨmə takasəkeikei mɨsorkeikei kapəmiə tɨkmɨr mɨnə, kɨni masor huvə-pən kɨmi narmamə yamə mɨne kasəməkɨn əmiə, ");
INSERT INTO nwi_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","kɨni nɨpɨg narmamə kamhani hah əmiə, mərɨg kɨmiə taksaiyoh Kughen mə tukrɨwəhsi-pən kafan nɨhuvəyen kɨmi əriə, kɨni masəhuak tuk narmamə yamə mɨne kasor-ahas-pre kɨmi əmiə. ");
INSERT INTO nwi_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tukmə yermamə kɨrik rərɨp nɨkapɨm, kɨni nakukreikɨn-pən mɨn nɨkarɨn pəh rərɨp. Kɨni tukmə yermamə kɨrik rɨrəhsi-ta kafam kot, takpəh nɨni-əhuyen mə tukrɨpəh nɨrəhsita-mɨnien kafam sot. ");
INSERT INTO nwi_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Vəh-sipən naha nhagɨn kɨmi yermamə yame ramaiyoh ik kɨn. Kɨni tukmə yermamə kɨrik rɨrəhsi-ta kafam kɨrik nar kɨrik, takpəh nɨniyen mə tukrarpɨn. ");
INSERT INTO nwi_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kɨni taksor huvə pən kɨmi narmamə mɨfam ye norien mɨfam yamə naksorkeikei mə narmamə tuksor mɨn kɨmi əmiə. ");
INSERT INTO nwi_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“?Mərɨg tukmə naksorkeikei əmə narmamə yamə mɨne kasorkeikei əmiə, nakhamə ta mə norien a ramor əmiə nakhahuvə uə? Nɨkam. Yor təvhagə hah mɨnə mɨn kɨsorkeikei narmamə yamə mɨne kɨsorkeikei əriə. ");
INSERT INTO nwi_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","?Kɨni tukmə naksor rhuvə pən əmə kɨmi narmamə yamə mɨne kasor huvə pre kɨmi əmiə, nakhamə ta mə nakhahuvə tukun uə? Nɨkam. Yor təvhagə has mɨnə mɨn kasor əmə nar kɨrikianə. ");
INSERT INTO nwi_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","?Kɨni tukmə nakseighan-pən əmə kɨn narɨmnar kɨmi narmamə yamə mɨne kharkun nhavəhsi-preyen tain, nakhamə ta mə nakhahuvə tukun uə? Nɨkam. Yor təvhagə has mɨnə mɨn kaseighan-pən kɨn narɨmnar kɨmi narmamə yamə mɨne tuk nɨpɨg kɨrik tukpihawəh-sipən mɨn tain rəmhen. ");
INSERT INTO nwi_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mərɨg takasəkeikei mɨsorkeikei kapəmiə tɨkmɨr mɨnə. Masor rhuvə pən kɨmi əriə. Mhavəhsi-pən narɨmnar kɨmi əriə mhapəh nɨsaiyohyen kɨn tain. Tukmə naksor məknekɨn, nərokien ehuə tukrurə tuk əmiə, kɨni takpihauə ji Kughen mɨnə yame In Yerpɨrɨg, meinai In mɨn ramor huvə pən kɨmi nəmə has mɨnə, mɨne narmamə yamə mɨne khapəh nhani-vi-vi-yen In. ");
INSERT INTO nwi_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Rɨkimiə tukreihuə tuk narmamə rəmhen kɨn yame Rɨmɨmiə Kughen rɨkin rehuə tuk narmamə.” ");
INSERT INTO nwi_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Kɨni Yesu rɨmɨni mɨmə, “Takpəh nəm-pənien nar has ye narmamə, tamə Kughen mɨn rəm-pre nar has iram. Takpəh nɨni-pənien narpɨnien ye narmamə, tamə Kughen rɨni-pre narpɨnien iram. Takpəh norien tai təvhagə has yame narmamə kasor pre kɨmik, kɨni tukpəh norien tai təvhagə has kafam. ");
INSERT INTO nwi_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Vəhsi-pən narɨmnar, kɨni tukwəhsi-pre mɨn narɨmnar kɨmik. Narɨmnar khapsaah yame kɨvai-pən, kəsian-əsian, rhaktə mukwar tukhaswin ye kwermɨm. Tukmə nakvəhsi-pən narɨmnar rɨpsaah, tukwəhsi-pre narɨmnar rɨpsaah kɨmik; mərɨg tukmə nakvəhsi-pən rɨkəskəh, tukhavəhsi-pre rɨkəskəh kɨmik.” ");
INSERT INTO nwi_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kɨni Yesu rɨmɨni nuhpɨkɨnien mɨn kɨrik kɨmi əriə mɨmə, “?Nɨmrɨn pɨs to rɨkɨr nɨmrɨn pɨs kɨrik uə, to reinein? Nɨkam, tamə kɨrəviə ye nəkwai nɨmɨr. ");
INSERT INTO nwi_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kɨni studen mɨnə to khapəh nɨsarmaruyen ye yhajoun kapəriə. Mərɨg narmamə yamə mɨne kasətərɨg huvə kɨn yhajoun kapəriə, mhavəh fam nəgkiarien kafan, iriə tukhauə mɨsəmhen kɨn yhajoun kapəriə. ");
INSERT INTO nwi_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","?Rhawor nakamhani nɨmoptanə yame ramswin-pən ye nɨmrɨ piaumiə; mərɨg nakhapəh nɨsərɨgien nai ehuə yame ramərer-pən ye nɨmrɨmiə? ");
INSERT INTO nwi_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tukmə nakhapəh nɨsərɨgien nai ehuə yame ramhai nɨmrɨmiə, ?takshawor pən iran mɨne mhavəh-si ta nɨmoptanə ye nɨmrɨ piaumiə? Kɨmiə nəmarpəkao eikuə mɨnə. Taksəkupən mhavəh-si ta nai ehuə ye nɨmrɨmiə, kwasɨg ikɨn, nakharkun nɨsəm-huvəyen nɨmoptanə yame ramswin-pən ye nɨmrɨ piaumiə.” ");
INSERT INTO nwi_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kɨni Yesu rɨmɨni mɨmə, “Kɨni nəpgɨn kɨrik rɨrkək yame ramkuə kɨn kwənwkan yame kɨpəh nənien. Kɨni to nai has rɨpəh nɨkuəyen kɨn kwənkwan huvə. ");
INSERT INTO nwi_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Meinai narmamə kasəm kwənkwan, kharkun mə nhag nai mɨnə a. Kapɨriapɨr to rɨpəh nɨkuəyen kɨn kwənkwai fig; kɨni kwənurkəsɨk to rɨpəh nɨkuəyen kɨn kwənkwai grep; . ");
INSERT INTO nwi_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Yermamə huvə, rɨkin rukwar kɨn narɨmnar huvə mɨnə; kɨni in ramor əmə narɨmnar yame rhuvə. Kɨni yermamə has, rɨkin rukwar əmə kɨn nar has mɨnə, kɨni mamor əmə norien has. Meinai tukmə rəgkiar, nar has mɨnə yerkin khatərhav-pə.” ");
INSERT INTO nwi_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kɨni Yesu rɨmɨni mɨmə, “?Rhawor e naksokrən kɨn Yo mhamə, ‘Yermaru, Yermaru,’ mərɨg nakhapəh nɨsəri-pənien nəgkiarien kafak? ");
INSERT INTO nwi_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Pəh yakhajoun əmiə kɨn norien kape yermamə kɨrik yame ramuə tuk yo, kɨni mətərɨg kɨn nəgkiarien kafak, marar, mor narɨmnar yame yakməni. ");
INSERT INTO nwi_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yermamə a in a in rəmhen əmə kɨn yermamə yame, tukmə rɨmə tukror kafan nimə, tukrəkupən mɨkɨr nɨmoptanə, meiwaiyu məspir kapier apɨg, mor pən nimə iran. Kɨni nɨpɨg tukmə yapiwən raiyu, mɨrəhpɨkɨn nimə, to rapəh nəusarkuyen, meinai rɨmnəvhirəkɨn tɨm tɨm. ");
INSERT INTO nwi_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mərɨg yermamə yame ramərɨg nəgkiarien kafak, mɨpəh norien, in rəmhen kɨn yermamə yame tukmə rɨmə tukror kafan nimə, ravhirəkɨn haktə əmə ye nɨmoptanə. Kɨni nɨpɨg tukmə yapiwən raiyu, mɨrəhpɨkɨn nimə, tukrɨmɨr mowhan əsɨs.” ");
INSERT INTO nwi_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nɨpɨg Yesu rɨmnəgkiar ta kɨmi narmamə mɨnə a, kɨni mɨvən mɨn apa ye taon Kapeneam. ");
INSERT INTO nwi_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kɨni ikɨn aikɨn a, yamehuə kɨrik kape mobael kape nəmə Rom ramarə ikɨn, kɨni slef kɨrik kafan aikɨn, yame in rorkeikei pɨk. Mərɨg slef a ramhə pɨk, ipakə rɨmhə. ");
INSERT INTO nwi_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kɨni nɨpɨg yamehuə a rɨmnərɨg nəvsaoyen ye Yesu, kɨni in rher-pən kɨn nəmehuə tɨksɨn kape nəmə Isrel mɨmə tukhavən mhani-pən tuk Yesu mə tukruə mor huvə kafan slef. ");
INSERT INTO nwi_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kɨni nɨpɨg nəmasur mɨnə a kɨmnhavən mɨsəm Yesu, mɨsəkeikei kɨmin mhamə, “Eh, ratuatuk əmə mə takasitu ye yamehuə a ");
INSERT INTO nwi_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","meinai in rorkeikei pɨk ətawə nəmə Isrel, kɨni in rɨmɨvhirəkɨn nimə kape nofugɨnien kapətawə.” ");
INSERT INTO nwi_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kɨni Yesu rɨkwasɨg kɨn əriə. Kɨni nɨpɨg kwənhauə ipakə tuk nimə, yamehuə kape mobael rher-pən kɨn kafan mɨnə narmamə mə tukhavən mɨsəm Yesu mhani-pən mhamə, “Yermaru, takpəh norien narkutien tuk nuəyen, meinai yakpəh nəmhenien mə takuə imak ikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kɨni ror məkneikɨn, yɨmɨpəh nuəyen məm ik. Ik yerpɨrɨg mərɨg yo yetanə əmə. Mərɨg, takəgkiar əmə, pəh kafak slef tukrəsanɨn mɨn. ");
INSERT INTO nwi_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Yakɨrkun mə nɨmhəyen a tukraməkeikei mor nəkwam, meinai yo mɨn, kafak nəmehuə mɨnə kasehuə irak, kɨni yakamor nəkwairiə. Kɨni mobael mɨnə tɨksɨn aikɨn yame yo yakamehuə irəriə. Tukmə yakni-pən tuk kɨrik mɨmə, ‘Yuvən,’ kɨni tukraməkeikei mɨvən. Kɨni tukmə yakni-pən tuk kɨrik mɨmə, ‘Yuə,’ tukraməkeikei muə. Kɨni tukmə yakni-pən tuk kafak slef mɨmə, ‘Or nar e,’ tukraməkeikei mor.” ");
INSERT INTO nwi_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nɨpɨg Yesu rɨmnərɨg nəgkiarien e, rakur pɨk kɨn. Kɨni marar mɨni-pən tuk narmamə khapsaah yamə mɨne khakwasɨg kɨn In mɨmə, “Yakamni tuk əmiə mə, pəh nien mə kwən e in yemə Isrel. Kɨni nar apnapɨg kwənərəus mɨnə Isrel, mərɨg yakpəh nəm-hanəyen kɨrik irəriə yame kafan nhatətəyen rehuə rəmhen kɨn in.” ");
INSERT INTO nwi_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kɨni ye nɨpɨg narmamə yamə mɨne yamehuə kape mobael rɨmnher-pən kɨn əriə kɨmnharerɨg-pə imə, mɨsəm mə slef a rɨnəsanɨn ta. ");
INSERT INTO nwi_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kɨni kwasɨg ye narɨmnar mɨnə e, rɨpəh norien tu, Yesu rɨmavən ye taon kɨrik, nhagɨn e Nain, iriə narmamə khapsaah yamə mɨne khakwasɨg kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kɨmnəsɨk kəupə rarkurao ye taon a, kɨni nɨpɨg Yesu rɨmauə ipakə tuk kwəruə, kɨni məm narmamə tɨksɨn khasɨ-pən ye taon a mamharəh yemə mhə kɨrik mamhauə. In pɨkwarien kape piraovɨn yame kɨmhə tan kɨn, tɨni yerman kɨrikianə əmə. Kɨni narmamə khapsaah khasɨ-pən ye taon a mamhauə iriə pian a. ");
INSERT INTO nwi_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Məkneikɨn Yesu Yermaru rɨmnəm pian a, rɨkin rəpou pɨk tukun, kɨni mɨni-pən tukun mɨmə, “Pəh nasəkien.” ");
INSERT INTO nwi_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kɨni mɨvən mɨrap nɨkaokao yame kamharəh kwən a kɨn rɨmamhə, məkneikɨn kɨsərer. Kɨni Yesu rɨmɨni-pən tukun mɨmə, “!Pɨkwarien! !Yakamni-pre tuk ik mɨmə, hekɨmter!” ");
INSERT INTO nwi_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Məkenikɨn yemə mhə a rɨmragh, mhekɨmter, kɨni mɨrikakun məgkiar. Kɨni Yesu rɨvəhsi-pən mɨn pɨkwarien a kɨmi nɨsɨni. ");
INSERT INTO nwi_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Iriə m-fam kɨmnhagɨn, mɨsətəmnɨmɨn, mhani-vi vi Kughen mhamə, “!Profet ehuə kɨrik ramarə kɨtawə min ai taktəkun! !Kughen e ruauə mə tukrasitu ye kafan narmamə mɨnə!” ");
INSERT INTO nwi_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kɨni nəvsaoyen kɨn Yesu rɨmnarkurao ikɨn mɨnə fam ye tanə Judia mɨne yamə mɨne ipakə tukun. ");
INSERT INTO nwi_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Narmamə kape Jon Baptaes kɨmɨsəvsao-pən Jon kɨn narɨmnar mɨnə fam yame Yesu ramor. Kɨni rɨmnokrən kɨn kafan yermamə kɨraru kɨrauə mwəm, ");
INSERT INTO nwi_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","kɨni rher-pən kɨn əriu mə tukravən mɨwəm Yesu Yermaru mwaiyoh-pən ru mɨrəmə, “?Rhawor? ?Ik e Kristo kɨmɨni ta mə tukruə, uə kɨmawə jakamhawhin yarmə kɨrik tukrɨpiuə?” ");
INSERT INTO nwi_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kɨni kwərə mir a kɨmɨravən mwəm Yesu, mɨrəni-pən tukun mɨrəmə, “Jon Baptaes rɨmnher-pə kɨn əmru mə jakrauə mwəm ik yakwaiyoh-ru ik mɨrəmə, ‘ ?Ik e yermamə yame Kughen rɨmɨni ta mə tukruə, uə kɨmawə jakamhawhin yarmə kɨrik tukrɨpiuə?’” ");
INSERT INTO nwi_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kɨni ye nɨpɨg atuatuk a, Yesu rɨmnor huvə narmamə khapsaah yamə mɨne kamhamhə. Tɨksɨn kɨmnhavəh nəmhəyen mɨnə pɨsɨn pɨsɨn; tɨksɨn nanmɨn has raməmɨr irəriə. Kɨni iriə khapsaah nɨmrɨriə rɨpɨs. Mərɨg Yesu rɨmnor huvə əriə. ");
INSERT INTO nwi_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Məkneikɨn, Yesu rɨni-pən tuk əriu mə, “Rarerɨg, mɨravən mɨrəni-pən narɨmnar mɨnə fam tuk Jon, yamə mɨne nɨmɨwərɨg kɨni mwəm. Nɨmrɨn pɨs mɨnə khapsaah kɨmɨsəm nar. Kɨni narmamə yamə mɨne nɨhuriə rahas kɨmɨseriwək. Kɨni narmamə yamə mɨne kamhavəh nəmhəyen ye tɨkiriə, tɨkiriə ruahuvə. Kɨni narmamə yamə mɨne nɨmətɨrgɨriə rəru, kɨni taktəkun ai, nɨmətɨrgɨriə rɨnərɨg nar. Kɨni narmamə yamə mɨnə kɨmnhamhə, kwənhamragh mɨn. Kɨni yavən hah mɨnə, taktəkun ai kwən kɨrik rɨnamni-ərhav pən nəvsaoyen huvə tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kɨni kɨmiru, takravən mɨrəni-pən tuk Jon mɨrəmə narmamə yamə mɨne kapəriə nhatətəyen irak rɨpəh nɨmɨrien, iriə tuksarə ye nɨhuvəyen əfrakɨs.” ");
INSERT INTO nwi_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nɨpɨg kwərə mir a yame Jon rɨmnher pən kɨn əriu kratərhav, kɨni Yesu rɨmɨrikakun maməgkiar ye Jon kɨmi nukwao ehuə. Mɨmə, “?In apa kupən kɨmiə nɨmnhavən apa ye tɨpəvsɨk mə taksəm naha nhagɨn? ?Nɨmnhavən mə taksəm əmə yermamə apnapɨg kɨrik yame in rəmhen kɨn nuwig yame nɨmətag ramuh mamowhan-owhan? !Nɨkam! ");
INSERT INTO nwi_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","?Tukmə nɨkam, kɨni nɨmnamhavən mə taksəm pa? Yermamə kɨrik yame ramvən ye neipən huvə yame nɨmrɨn rəutən uə? !Nɨkam! Narmamə yamə mɨne kamhavən ye neipən huvə mɨsagien əmə tuk kapəriə nautə, iriə kɨsarə ye nimə huvə mɨnə rəmhen kɨn kape king. ");
INSERT INTO nwi_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","?Kɨni naha nhagɨn a nɨmnhavən mə taksəm? ?Profet kɨrik uə? Ǝwəh, nəfrakɨsien. Mərɨg yakamni-pre tuk əmiə mə Jon in yerpɨrɨg pɨk rapita profet. ");
INSERT INTO nwi_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kwən e in e Nəkwəkwə kape Kughen rɨmɨni-ta mɨmə, “‘Səm-ru. Yakamher-pre kɨn kafak yermamə yame tukrɨvəh kafak nəgkiarien. In tukrəkupən kɨn ik mor apnəpeinə ye kafam swatuk.’ ");
INSERT INTO nwi_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yakamni-pre tuk əmiə mə narmamə yamə mɨne kɨmɨsarha-pə ye tokrei tanə, kɨrik rapəh napitayen kwən e Jon. Mərɨg yermamə yame in ye tanə əmə ye narmaruyen kape Kughen, in yerpɨrɨg mɨn rapita Jon.” ");
INSERT INTO nwi_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nɨpɨg narmamə apnapɨg, mɨne narmamə yamə mɨne kasərer tuk mane kape takis kɨmɨsərɨg nəgkiarien kape Yesu, iriə khamə swatuk kape Kughen in swatuk atuatuk. Kɨmnhani məkna meinai Jon rɨmnor ta baptaes irəriə. ");
INSERT INTO nwi_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mərɨg Farisi mɨnə mɨne nəmhajoun kape Loa kape Moses, iriə kɨmnhapəh nɨseighanien kɨn Jon mə tukror baptaes irəriə. Kɨni mhaukreikɨn pən nɨmeitairiə ye swatuk kape Kughen ye nɨmraghien kapəriə. ");
INSERT INTO nwi_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kɨni Yesu rɨmnəgkiar mɨn mɨmə, “?Kɨni Yo jakni mə narmamə yamə mɨne kɨsarə ai taktəkun, mə norien kapəriə rəmhen kɨn naha? ?Mə naha nhagɨn nətərɨgien kapəriə? ");
INSERT INTO nwi_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Iriə kɨsəmhen əmə kɨn kwajikovə yamə mɨne nar kɨrik rɨrkək yame tukror əriə, rɨkiriə ragien. Mɨsəkwətə masəukɨr ikɨn kamor maket ikɨn, mashek əriə mɨnə mhamə, ‘!Ah! Kɨmawə yɨmnhauh gita, mərɨg kɨmiə nakhapəh nɨsorien danis. Kɨni yaksarar mɨseikuə kɨn nasəkien tuk nɨmhəyen, mərɨg kɨmiə nɨmnhapəh nɨsasəkien kɨtawə-m kɨmiə.’ ");
INSERT INTO nwi_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yakamni məknei meinai ye nɨpɨg Jon Baptaes rɨmauə, mamatuakəm, məpəh nəvɨgɨnien nɨpɨg rɨpsaah tuk nəhuakien, mɨpəh nɨnɨmien waen. Mərɨg kɨmiə nakamhani mhamə, ‘Kwən a, nanmɨn has kɨrik raməmɨr iran.’ ");
INSERT INTO nwi_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kɨni Yo, Ji Yermamə, yɨmauə maməvɨgɨn, mamnɨm waen, mərɨg kɨmiə nakamhani mɨn mhamə, ‘!Ah! Kwən a in yermamə kape nəvɨgɨn-pɨkien, mɨne napɨsien kɨn nɨnɨmien. Kɨni mamor norkeikeiyen kɨmi narmamə kape nərerien tuk mane kape takis, mɨne yor təvhagə has mɨnə.’ ");
INSERT INTO nwi_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mərɨg kwajikovə əfrakɨs kape Kughen mɨnə tukasəkeikei mharkun mə kɨmru Jon yakawor narɨmnar ye nɨrkunien əfrakɨs.” ");
INSERT INTO nwi_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Kɨni Farisi kɨrik, nhagɨn e Saemon, raiyoh-pən Yesu mɨmə tukrɨvən ye nəkwai nimə kafan məvɨgɨn kwis. Kɨni Yesu rɨmavən yerkwanu, mɨvən ye nəkwai nimə kape Farisi a, məkwətə mə tukrəvɨgɨn. ");
INSERT INTO nwi_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kɨni piraovɨn kɨrik ye taon a in yor təvhagə hah, rɨmnərɨg mə Yesu raməvɨgɨn apa imei Farisi. Kɨni rɨmavən mɨwəh botel kɨrik kɨmnor kɨn kapier kɨrik nhagɨn e alabasta. Nɨmrɨn rhaktə. Botel a, senta aikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kɨni in rɨmauə ipakə tuk Yesu mərer ye nɨkar nɨhun, mamasək. Nehe nɨmrɨn rətəg-pən ye nɨhu Yesu, mokwi nɨhun. Kɨni mamrai-ta nehe nɨmrɨn kɨn nɨkwənen ye nɨhu Yesu, mənɨm-pən nɨmrɨn ye nɨhu Yesu, mətəg-pən senta ye nɨhun mir. ");
INSERT INTO nwi_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mərɨg Farisi e yame rɨmnokrən kɨn Yesu mə tukrəvɨgɨn iriu mɨn, nɨpɨg rɨmnəm narɨmnar mɨnə e, rɨkin ruh mə, “To kwən e profet əfrakɨs, rɨpirkun norien kape piraovɨn a yame ramrap nɨhun, mɨpirkun mə in yor təvhagə has.” ");
INSERT INTO nwi_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kɨni Yesu rɨmɨni-pən tukun mɨmə, “Saemon, yakmə jakni-pre nar kɨrik tuk ik.” Kɨni Saemon rɨmə, “Yhajoun, ni.” ");
INSERT INTO nwi_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Kɨni Yesu rɨmɨni mɨmə, “Yermamə kɨraru, kapəriu mane rapəh nəmhenien, kɨni yamehuə kɨrik rɨvəhsi-pən mane kɨrik kɨmi əriu, mə tuk nɨpɨg kɨrik iriu tukwarpɨn kafan mane. Kɨrik rɨmɨwəh faef handred taosen vatu; kɨni kɨrik rɨwəh fifti taosen vatu. ");
INSERT INTO nwi_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kɨni mwarə mɨravən, mweinein narpɨnien mane a. Kɨni yamehuə rɨmɨni-pən tuk əriu mɨmə, ‘Nəmhen. Wəpəh narpɨnien mane yame nɨmɨrəvəh tuk yo.’ ?Kɨni, pa nhagɨn irəriu tukrorkeikei pɨk yamehuə a rapita?” ");
INSERT INTO nwi_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Kɨni Saemon rɨni-pən tukun mɨmə, “Rɨkik raməsɨk mə yermamə yame rɨmɨvəh mane ehuə, kɨni yamehuə a rɨpəh naiyohyen kɨn tain.” Kɨni Yesu rɨmɨni-pən tukun mɨmə, “Nakamni əfrah.” ");
INSERT INTO nwi_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kɨni Yesu rarar marha-pən məm pian a, mɨni-pən tuk Saemon mɨmə, “Saemon. ?Nakaməm pian e uə? Nɨpɨg yɨmauə imam ikɨn, ik nakpəh nɨwəhsi-pəyen nu kɨrik tuk naikwasien ye nɨhuk. Mərɨg pian e in rɨmnəkwi nɨhuk kɨn nehe nɨmrɨn, məspir kɨn nɨkwənen. ");
INSERT INTO nwi_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kɨni nɨpɨg yɨmauə, ik nɨmɨpəh nəturəm-pəyen kɨmi yo. Mərɨg pian e, ravəhsi-pə nɨsiaiyen kɨmi yo mɨpəh nɨpəhyen. ");
INSERT INTO nwi_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ik nɨmɨpəh nhawkien kapək kapə kɨn nehe olif, mərɨg pian e rɨmnətəg pən senta ye nɨhuk yame nɨmrɨn rhaktə pɨk. ");
INSERT INTO nwi_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kɨni ror məkneikɨn yakamni-pre tuk ik mə yɨmnəspir ta fam kafan təvhagə has yame rehuə pɨk. Ror məkneikɨn mə in rorkeikei pɨk yo. Mərɨg tukmə yakaspir təvhagə has kape yermamə yame təvhagə has kafan rəkəskəh əmə, kɨni, rorkeikei mar əmə Yo.” ");
INSERT INTO nwi_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kɨni Yesu rɨmɨni-pən tuk pian a mɨmə, “Yakwərəh-si ta ta narpɨnien kape təvhagə has kafam.” ");
INSERT INTO nwi_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kɨni narmamə mɨnə tɨksɨn yamə mɨne kasəvɨgɨn iriə mɨn, khani tuk əriə mɨnə mhamə, “?Naha e yermamə yame In ramni mə ravəhsi-ta narpɨnien kape təvhagə has kape narmamə?” ");
INSERT INTO nwi_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mərɨg Yesu rɨni-pən tuk pian a mɨmə, “Kughen rɨmɨvəh mɨragh ik meinai nɨmnhatətə irak. Amvən ye nəmərinuyen.” ");
INSERT INTO nwi_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kwasɨg ikɨn ye narɨmnar mɨnə a, Yesu In rɨmneriwək mamvən ye taon mɨnə mamtərhav mamvən yerkwanu mɨnə, maməvsao-ərhav kɨn nəgkiarien huvə kape narmaruyen kape Kughen. Ye nɨpɨg a, aposol mɨnə twelef kafan kɨmnhakwasɨg kɨn, ");
INSERT INTO nwi_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","mɨne nɨpiraovɨn tɨksɨn yamə mɨne kupən kɨmnhavəh nəmhəyen pɨsɨn pɨsɨn, uə nanmɨn has mɨnə kɨmnasəmɨr irəriə, mərɨg Yesu rɨmnəko-ta əriə irəriə, mor huvə kapəriə nəmhəyen. Nhag nɨpiraovɨn mɨnə e: Meri, pian Magdala yame Yesu rɨmnəko-ta nanmɨn hah seven iran; ");
INSERT INTO nwi_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","mɨne Joana, piahwaru kape Jusa yame in ramarmaru ye nimə kape King Herod Antipas; mɨne Susana; mɨne nɨpiraovɨn khapsaah. Nɨpiraovɨn mɨnə e kɨmnhavəh-sipən mane kapəriə tuk nɨvəhyen nɨmrɨ narɨmnar tuk nasituyen ye Yesu mɨne kafan mɨnə. ");
INSERT INTO nwi_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Narmamə khapsaah khasɨ-pən ye taon mɨnə khapsaah mhauə tuk Yesu. Nɨpɨg kɨmnhauə masərer rarkurao iran, kɨni rɨmɨni nuhpɨkɨnien kɨrik tuk əriə, mɨmə, ");
INSERT INTO nwi_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Yermamə kɨrik rɨmavən mə tɨkrɨsuv kweru nai apa ye nəsimien. Mɨpɨk mɨvitəg-ətəg fam, kɨni tɨksɨn rəsaah-əsaah-pən ye swatuk, kəvi-əpni, kɨni man mɨnə khauə mɨsən fam. ");
INSERT INTO nwi_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kɨni kweru nai tɨksɨn rəsaah-pən ye tokrei kapier, murə aihuaa əmə. Kɨni mərɨg kwəsaukei fam meinai ikɨn rəusɨk ikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kɨni kweru nai tɨksɨn rəsaah-əsaah-pən yerki kwənurkəsɨk. Kɨni mhaktə mehuə. Məknekɨn, kwənurkəsɨk rerko əsuun, kɨni kweru nai rurə mɨpəh nɨkuəyen. ");
INSERT INTO nwi_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kɨni tɨksɨn rəsaah-əsaah-pən ye nɨmoptanə huvə, kɨni mhaurə, mɨseihuə, mhakuə kɨn kwənkwairiə wan handred.” Kɨni Yesu rɨmɨni ta nəgkiarien e, mokrən apomh mɨmə, “Tukmə kɨmiə narmamə yame nɨmətɨrgɨmiə rarə, sətərɨg huvə kɨn nəgkiarien e.” ");
INSERT INTO nwi_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mərɨg narmamə kape Yesu mɨnə kɨsaiyoh-pən In mhamə, “Hoprai-pə nɨprai nəgkiarien e kɨmi əmawə.” ");
INSERT INTO nwi_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kɨni rɨni-pən tuk əriə mɨmə, “Narmaruyen kape Kughen nar erkwaig, mərɨg yakwəni-ərhav-pre ta kɨmi əmiə; kɨni mərɨg Yo yakamni-ərhav əmə nuhpɨkɨnien kɨmi narmamə mɨnə tɨksɨn, rəmhen kɨn yame Profet Aesaea rɨmɨni mə, “‘Iriə tuksarhakɨn, mɨsarhakɨn pawk, mərɨg to khapəh nɨsəmien nɨpran. Iriə to kɨsərɨg pawk, mərɨg to khapəh nharkunien.’ ");
INSERT INTO nwi_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Nɨprai nuhpɨkɨnien e ror məkneikɨn. Kweru nai, in e Nəgkiarien kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kɨni yamə mɨne kɨsəsaah-pən ye swatuk iriə kɨsəmhen kɨn narmamə yamə mɨne kɨsərɨg nəgkiarien kape Kughen, məkneikɨn Setan ravəhsi-ta yerkiriə, mamətapɨg kɨn əriə mə tukhapəh nhaniyen nəfrakɨsien ye Kughen, kɨni In to rɨpəh nɨvəh-mɨraghien əriə. ");
INSERT INTO nwi_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kɨni yamə mɨne kɨsəsaah-pən yerki kapier kɨsəmhen kɨn narmamə yamə mɨne kɨsərɨg nəgkiarien kape Kughen, rɨkiriə ragien tukun, mərɨg nuairiə rɨpəh neiwaiyu-pɨkien, kɨni nhatətəyen kapəriə ramarə kape nɨpɨg kwakwə, mərɨg tukmə nəsəsaoyen uə nahasien ramuə tuk əriə, tukhamɨr ye kapəriə nhatətəyen. ");
INSERT INTO nwi_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kɨni yamə mɨne kɨsəsaah-pən yerki kwənurkəsɨk, kɨsəmhen kɨn narmamə yamə mɨne kɨsərɨg nəgkiarien kape Kughen, mərɨg narɨmnar khapsaah kɨseruk nɨmraghien kapəriə, in e, kasətərɨg pɨk kɨn narɨmnar kape nɨmraghien kapəriə, uə, kɨsorkeikei nautə rɨpsaah, uə kɨsorkeikei mə tukasərɨg rhuvə ye nɨprairiə. Khapəh nɨshaktə-huvəyen ye nɨmraghien yame Kughen rorkeikei. ");
INSERT INTO nwi_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mərɨg yamə mɨne kɨsəsaah pən ye nɨmoptanə huvə, iriə kɨsəmhen kɨn narmamə yamə mɨne kɨsərɨg nəgkiarien kape Kughen, kɨni rɨkiriə ratuatuk mɨhuvə, mamharaptərəkɨn nəgkiarien kape Kughen rɨskai yerkiriə. Kɨni iriə masərer tɨm tɨm mhavən, mhakuə kɨn nɨmraghien huvə.” ");
INSERT INTO nwi_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kɨni Yesu rɨmɨni mɨmə, “To kɨpəh nəsiə-pənien ye laet kukrai-pən ye nəkwai baket uə ye nəpəəg tebol. Nɨkam. Tukaməkeikei kɨruk haktə pəh narmamə kɨsəm nar. ");
INSERT INTO nwi_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tukmə nar erkwaig, tukaməkeikei kəm. Tukmə yermamə kɨrik ruvrɨg nar kɨrik, kɨni mərɨg tukraməkeikei mier-pə ikɨn rhakak ikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ror pən, nəgkiarien e yamə nakasərɨg, sətərɨg huvə kɨn. Narmamə yame mɨne kɨsəri-pən kafak nəgkiarien, Kughen tukrɨvəhsi-pən mɨn nɨrkunien kɨmi əriə. Mərɨg narmamə yamə mɨne kɨsərɨg nəgkiarien kɨni mɨsor nar apnapɨg iran, Kughen tukrɨvəhsi-ta nɨrkunien kəskəh yame rɨkiriə raməsɨk mə iriə kwənhavəh ta.” ");
INSERT INTO nwi_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kɨni ye nɨpɨg a, nɨsɨn Yesu mɨne piauni mɨnə kɨmnhauə mə tuksəm In, mərɨg kɨseinein nhavənien ipakə tukun, meinai narmamə khapsaah kɨsərer rarkurao kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kɨni yermamə kɨrik rɨni-pən tukun mɨmə, “Eh. Nɨsɨnɨm mɨne piam mɨnə kasərer apa iruə mhamə tuksəm ik.” ");
INSERT INTO nwi_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mərɨg In rɨni-pən tukun mɨmə, “Narmamə m-fam yamə mɨne kɨsərɨg nəgkiarien kape Kughen kɨni mɨsəri-pən, iriə e kafak narmamə mɨnə, mɨne nɨsɨnɨk, mɨne piak mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nɨpɨg kɨrik, Yesu rɨmɨni-pən tuk kafan narmamə mɨnə mɨmə, “Pəh khavən apa nɨkar lugun a.” Məkneikɨn kɨsatpən ye bot mhavi pirə. ");
INSERT INTO nwi_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bot ramaiyu mavirə, Yesu rapɨr. Kɨni nɨmətag ehuə kɨrik rɨmnəvi nu, kɨni nu rɨnamakətənɨm kɨn bot; ipakə iriə kɨsəmnɨm. ");
INSERT INTO nwi_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kɨni narmamə kape Yesu kɨmnhavən mhasɨg In, mhamə, “!Yemehuə! !Yemehuə! !Natuksəmnɨm!” Kɨni Yesu rarha, mɨni-əhu nɨmətag mɨne peao-peao ehuə. Nɨmətag reiwaiyu. Nu reiwaiyu mamərinu mɨn. ");
INSERT INTO nwi_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kɨni Yesu raiyoh-pən kafan narmamə mɨnə mɨmə, “?Mərɨg nhatətəyen hiə kapəmiə?” Mərɨg iriə kɨsakur mhagɨn, mɨsaiyoh əriə mɨnə mhamə, “!Eh! ?Naha e yermamə? !Nar apnapɨg mə nɨmətag mɨne tahik, mərɨg kawor nəkwan!” ");
INSERT INTO nwi_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kɨmnhavi-pirə bot mhavən mhavhiak nɨkar Galili pən, apa kwənmhaan a kamni kɨmə Gerasa. ");
INSERT INTO nwi_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu rəviə-fiak, məkneikɨn yermamə kɨrik ruə məm In. Kwən a, nanmɨn has mɨnə kasəmɨr iran. In rɨmɨpəh nɨvənien ye neipən, mɨpəh napɨrien imə, ramarə əmə ikɨn kamnɨm narmamə ikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Apa kupən, nɨpɨg rɨpsaah, nanmɨn has mɨnə a kɨmɨsor in ramarmar pɨk, kɨni narmamə kɨmnharkwəji kwermɨn mɨne nɨhun ye jen mə tukharaptərəkɨn tɨm tɨm pəh rɨpəh noriahyen narɨmnar. Mərɨg nɨpɨg m-fam raməvi-əru jen mɨnə. Kɨni nanmɨn has mɨnə kasəkeikei kɨmin mə tukhakɨr mɨsap mhavən apa ikɨn kɨrkək ikɨn. Kɨni nɨpɨg kwən a rɨmnəm Yesu ruə mənɨmkur-pən ye nɨhun. Kɨni Yesu rɨmɨni mə nanmɨn has tukrier map ye kwən a. Kɨni kwən a rok-rapomh mɨmə, “Yesu, Ji Kughen Yerpɨrɨg. ?Nakmə takhawor yo? !Aweh! !Yakamaiyoh ik mɨmə takpəh norien nəmhəyen kɨmi yo!” ");
INSERT INTO nwi_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Kɨni Yesu rɨmnaiyoh-pən nanmɨn has mɨmə, “?Nhagɨm pa?” Kɨni in rɨmə, “Nhagɨk e Nukwao Ehuə.” Rɨmɨni məknakɨn meinai nanmɨn has khapsaah kasəmɨr iran. ");
INSERT INTO nwi_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kɨni nanmɨn has mɨnə kɨmɨsaiyoh-pən skai m-rɨpsaah kɨmi Yesu mhamə, “Takpəh nher-pəyen kɨn əmawə ye nəpəəg e yame reiwaiyu pɨk, imei narpɨnien rerɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kɨni ikɨn a, pukəh mɨnə khapsaah ikɨn. Kasəruk a ye nɨhu tukwas a. Kɨni nanmɨn has mɨnə kɨmɨsasək mhani-pən tuk Yesu mhamə, “!Awe! Ǝta-pən irəmawə yerki pukəh mɨnə a.” Kɨni Yesu reighan-pən kɨn əriə kamhavən. ");
INSERT INTO nwi_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kɨni nanmɨn has mɨnə a kɨmnhatərhav ye kwən a mhavən yerki pukəh mɨnə. Kɨni pukəh mɨnə a, iriə fam kɨmɨsaiyu mɨseiwaiyu ye nəpatu, mhaviərhav mɨsəmnɨm ye nu. ");
INSERT INTO nwi_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mərɨg nɨpɨg narmamə yamə mɨne kasəvɨgɨn pukəh mɨnə a kɨmɨsəm nar a, kɨmɨsaiyu mhatərhav, mhavən mɨsəvsao-pən kɨn ye taon mɨne ikɨn mɨnə fam rarkurao aikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kɨni narmamə kɨmnhatərhav ye taon mhavən mə tuksəm nar a. Kɨni mhavən masəm Yesu, kɨni mɨsəm kwən a yame nanmɨn has mɨnə kɨmɨsəta iran ramkwətə yetanə, ipakə tuk Yesu. Kɨni mɨnɨpəh narmərien, muavən ye neipən. Kɨni narmamə ye taon a kɨmnhagɨn. ");
INSERT INTO nwi_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kɨni narmamə yamə mɨne kɨmɨsəm atuatuk nar a kɨn nɨmrɨriə kɨmɨsəvsao mɨn kɨn kɨmi narmamə tɨksɨn mhamə Yesu rɨmnhawor mor huvə kwən a yame in apa kupən nanmɨn has mɨnə kɨmnasəmɨr iran. ");
INSERT INTO nwi_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kɨni narmamə mɨ-fam yamə mɨne kasarə apa Gerasa kɨmnhani-pən tuk Yesu mə tukrɨtərhav aikɨn, meinai kɨmɨsəm khagɨn pɨk kɨn. Məkneikɨn, Yesu ratpən ye bot mə tukrɨtərhav. ");
INSERT INTO nwi_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mərɨg kwən a yame nanmɨn has mɨnə kɨmɨsəta iran, raiyoh-pən Yesu mɨmə, “!Eh! Pəh kɨrau.” Mərɨg Yesu rɨmɨni-pən tukun mɨmə, ");
INSERT INTO nwi_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Rerɨg-pən imam ikɨn, mɨvən mɨni-ərhav naha nhagɨn Kughen rɨmnor kɨmik.” Kɨni kwən a rɨmavən ikɨn mɨnə fam ye taon iman ikɨn mamni-ərhav narɨmnar m-fam yame Yesu rɨmnor kɨmin. ");
INSERT INTO nwi_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nɨpɨg Yesu rɨmɨrerɨg-pə mɨn ye nɨkar lugun pə, narmamə kɨmɨsagien tukun, meinai iriə kɨmnaseito kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kɨni yermamə kɨrik, rɨmauə məm In, nhagɨn e Jaeras. In ramehuə ye nimə kape nofugɨnien. Rɨmauə, mənɨmkur-pən tuk Yesu, maməkeikei kɨmin mə iriu tukravən apa iman ikɨn ");
INSERT INTO nwi_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","meinai kafan kwajikovə piraovɨn kwənkwan kɨrikianə ramhə pɨk, nɨmhəyen rɨneriaji. Kɨni kafan newk twelef əmə. Kɨni Yesu rɨmneriwək mɨvən tuk piakəskəh a, kɨni narmamə khapsaah khakwasɨg kɨn mamhasɨg-sɨg In. ");
INSERT INTO nwi_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kɨni piraovɨn kɨrik aikɨn yame rawəh nəmhəyen kapəriə nɨpiraovɨn, nɨtawɨn rɨmnaiyu mɨvəh newk twelef. Rɨmavən məm dokta mɨnə, moriah fam kafan mane ye nəmhəyen kafan, mərɨg yermamə kɨrik to rɨpəh nor-huvəyen. Kɨni ruə məm Yesu, ");
INSERT INTO nwi_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","mukurao-pən ye nɨmetain, mɨrap nəpəəg nɨmrɨ neipən kafan, taktəkun əmə, kafan nəmhəyen ror infamien. ");
INSERT INTO nwi_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Kɨni Yesu rɨmə, “!Eh! Pa e rɨrap Yo?” Kɨni iriə m-fam khamə kɨseinein. Mərɨg Pita rɨmə, “!Yhajoun, narmamə khapsaah e kamhasɨg-sɨg Ik.” ");
INSERT INTO nwi_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mərɨg Yesu rɨmɨni mɨmə, “Nɨkam. Yakɨrkun mə yermamə kɨrik e rɨmɨrap Yo, meinai yɨmnərɨg mə nanmɨn kafak rɨmnor huvə yermamə kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kɨni piraovɨn a ruɨrkun mə in to rɨpəh mɨn nerkwaigien, rɨmauə mənɨmkur ye nɨhu Yesu makur pɨk kɨn. Kɨni ye nɨmrɨ narmamə m-fam rɨni-ərhav-pən nar yame rɨmɨrap Yesu tukun. Kɨni mɨni-ərhav mɨn mə ye nɨpɨg atuatuk yame rɨmɨrap In, taktəkun əmə, rɨmnəsanɨn mɨn. ");
INSERT INTO nwi_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kɨni Yesu rɨni-pən tukun mɨmə, “Kafak piakəskəh, nhatətəyen kafam rɨmnor ik naknəsanɨn. Amvən ye nəmərinuyen.” ");
INSERT INTO nwi_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu raməgkiar hanə, məkneikɨn, yermamə kɨrik rɨsɨ-pən apa imei Jaeras, yamehuə kape nimə kape nofugɨnien, muə, mɨni-pən tuk Jaeras mə, “Kafam piakəskəh ruamhə ta. Takpəh norien narkutien kɨmi Yhajoun e mə takɨkɨr mɨvən.” ");
INSERT INTO nwi_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mərɨg Yesu rɨmnərɨg nəgkiarien e, mɨni-pən tuk Jaeras mə, “Takpəh nɨgɨnien. Hatətə əmə irak, piakəskəh kafam tukramragh mɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kɨni ye nɨpɨg Yesu rɨmauə mɨtərhav-pə ye nimə kape Jaeras, mɨni-əhu narmamə mə tukhapəh nhakwasɨgien kɨn. Kɨni mɨkɨr əmə Pita, mɨne Jon, mɨne Jemes, mɨne rɨm piakəskəh e mɨne nɨsɨni, iriə min. ");
INSERT INTO nwi_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Narmamə m-fam kəsasək apomh tuk piakəskəh a mamhauvrɨg-uvrɨg pɨk. Mərɨg Yesu rɨni-pən tuk əriə mɨmə, “Hapəh nɨsasəkien. Piakəskəh e rɨpəh nɨmhəyen; ramapɨr əmə.” ");
INSERT INTO nwi_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mərɨg iriə kɨmɨsarh iakei iran meinai iriə kharkun mə piakəskəh a in ruamhə ta. ");
INSERT INTO nwi_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mərɨg Yesu rərao-pən, mɨvəh kwermɨ piakəskəh a, mɨni-pən tukun mə, “Piakəskəh kafak. Hekɨmter.” ");
INSERT INTO nwi_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kɨni taktəkun əmə nanmɨn rɨrerɨg-pə, in mhekɨmter. Kɨni Yesu rɨni-pən tuk əriə mə, “Havəh-sipən nəvɨgɨnien kɨrik pəh rən.” ");
INSERT INTO nwi_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kɨni rɨmni mɨne nɨsɨni kawakur pɨk kɨn; mərɨg Yesu rɨni-pən tuk əriu mɨmə, “Takrapəh nɨwəvsaoyen kɨn nar e kɨmi narmamə.” ");
INSERT INTO nwi_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Kɨni ai, Yesu rɨmnofugɨn kafan aposol twelef, mɨvəhsi-pən neihuəyen mɨne nəsanɨnien kɨmi əriə tuk nəko-tayen nanmɨn has ye narmamə, mɨmə iriə tuksor huvə mɨn nəmhəyen mɨnə. ");
INSERT INTO nwi_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kɨni Yesu rɨmnher-pən kɨn əriə mə tukhani-ərhav narmaruyen kape Kughen, kɨni mɨmə iriə tuksor huvə mɨn narmamə yamə mɨne kamhamhə. ");
INSERT INTO nwi_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kɨni mamni-pən tuk əriə mə, “Tukmə nakamhavən ye swatuk, mhapəh nhavəhyen nar kɨrik rəmhen kɨn kaskɨn, uə nɨtɨp, uə nəvɨgɨnien, uə mane, kɨni mhapəh nhavəhyen neipən kɨraru kɨraru. ");
INSERT INTO nwi_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nɨpɨg tukmə nakamhavən yerkwanu kɨrik, mɨsarə ye nimə kɨrik, nimə e in a taksarə əmə ikɨn mɨseriaji mhatərhav ikɨn mamhavən. ");
INSERT INTO nwi_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kɨni ikɨn pukhaa takhavən ikɨn, tukmə narmamə rɨkiriə rɨpəh nagienien mə takhauə mɨsarə kɨmiə miriə, taksarpita-arpita nɨmokrur ye sandel kapəmiə. Norien e tukror nɨmtətien mə narmamə yerkwanu a kɨmɨsor nar kɨrik rapəh nəmhenien.” ");
INSERT INTO nwi_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kɨni iriə kɨmnhatərhav mɨseriwək mamhavən yerkwanu mɨnə, masəvsao-ərhav kɨn nəvsaoyen huvə, kɨni ikɨn mɨnə fam kɨmnhavən ikɨn, kɨmɨsəhuak tuk narmamə khapsaah yamə mɨne kamhamhə, kɨni kasəsanɨn. ");
INSERT INTO nwi_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kɨni King Herod Antipas, yame in ramarmaru ye nəmə Galili, in rɨmɨwəh nəvsaoyen kɨn, kɨni mətərɨg kɨn meinein apomh, meinai narmamə tɨksɨn khamə Jon Baptaes a in a rɨmamragh mɨn. ");
INSERT INTO nwi_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Kɨni narmamə tɨksɨn kamhani mhamə Elaeja a ruauə mɨn. Kɨni narmamə tɨkɨsn kamhani mhamə in profet kupən kɨrik kape Kughen yame rɨmamragh mɨn. ");
INSERT INTO nwi_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mərɨg Herod Antipas rɨmə, “Jon e, yɨmɨkɨs əru nɨpətək nuan. ?Mərɨg pa e nhagɨn yakamərɨg nəvsaoyen kɨn?” Kɨni in morkeikei mə tukrəm Yesu. ");
INSERT INTO nwi_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kɨni aposol mɨnə kape Yesu kharerɨg-pə mɨn tukun, mhani-pən narɨmnar m-fam yame kɨmɨsor. Kɨni In rɨkɨr əriə mɨsəta ye narmamə, mhavən apa taon kɨrik, nhagɨn e Betsaeda. ");
INSERT INTO nwi_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mərɨg nɨpɨg narmamə kɨmɨsərɨg mə Yesu rɨmauə, kɨni khauə, mhakwasɨg kɨn. Kɨni Yesu rɨmnəm əriə, rɨkin ragien əmə. Kɨni mamhajoun əriə kɨn narmaruyen kape Kughen, mamor huvə narmamə yamə mɨne kamhamhə. ");
INSERT INTO nwi_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kɨni rɨnamenaiyu, narmamə twelef kape Yesu khavən tukun, mhani-pən tukun mhamə, “Yermaru. Her-pən kɨn narmamə mɨfam e kamhavən apa yerkwanu mɨnə mə tuksarhakɨn kwənmhan huvə kɨrik kape napɨrien, mɨne nəvɨgɨnien. Meinai ikɨn e kɨtawə kasəmɨr ikɨn, kwənmhaan əkwak.” ");
INSERT INTO nwi_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mərɨg əmə rɨni-pən tuk əriə mɨmə, “Rhuvə əmə. Kɨmiə səvɨgɨn əriə.” Mərɨg iriə khamə, “?Rhawor? Kɨmawə yakamhawəh əmə bred faef mɨne kəməəm kɨraru. ?Nakmə jakhavən mhawəh nɨmrɨ nəvɨgɨnien ne nukwao e uə?” ");
INSERT INTO nwi_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kɨmnhani məknakɨn meinai narmamə khapsaah khapsaah kwənhauə ikɨn a, tukmə kəvheikɨn əmə narman, rəmhen kɨn faef taosen. Mərɨg Yesu rɨmɨni-pən tuk kafan narmamə mɨnə mɨmə, “Havən mhani-pən tuk əriə mə tuksəkwətə fifti fifti ye nɨmrɨn mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Məkneikɨn kafan narmamə mɨnə kɨmɨsəwhai məknakɨn əriə, kasəkwətə. ");
INSERT INTO nwi_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Kɨni Yesu rɨmɨvəh bred a faef mɨne kəməəm kɨraru, mɨvaag haktə mɨni vi vi Kughen tukun, mhapu-hapu bred mɨne kəməəm, mɨpɨk-pən kɨmi kafan narmamə mɨnə mə tukhapɨk mɨsəvɨgɨn narmamə mɨnə a kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kɨmɨsəvɨgɨn tɨpriə rəsiis, mɨsəpəh nɨpərpər bred mɨne kəməəm. Kɨni kafan narmamə mɨnə khavai-pən ye kəmeiru twelef khakwar mɨn. ");
INSERT INTO nwi_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nɨpɨg kɨrik, Yesu rɨmnaməhuak iriə pɨsɨn əmə kafan narmamə mɨnə. Kɨni raiyoh-pən əriə mɨmə, “Mərɨg narmamə mɨnə a kamhani mə Yo e pa?” ");
INSERT INTO nwi_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kɨni khani-pən tukun mhamə, “Tɨksɨn kamhani mə ik Jon Baptaes. Kɨni tɨksɨn kamhani mə ik profet Elaeja. Kɨni tɨksɨn kamhani mə ik profet kupən kɨrik kape Kughen yame ruəmragh mɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mərɨg Yesu raiyoh-pən əriə mɨmə, “?Mərɨg kɨmiə nakhamə Yo e pa?” Mərɨg əmə Pita rɨmə, “Ik e Kristo yame Kughen rɨmɨni mə tukrher-pə kɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Mərɨg Yesu rɨmɨni-əutən-pən tuk əriə mə tukhapəh nhani-pənien tuk narmamə. ");
INSERT INTO nwi_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kɨni In rɨmɨni-pən mɨn mɨmə, “Nar kɨrik yame tukraməkeikei muə mor nəfrakɨsien kɨn. Mə Yo, Ji Yermamə, jakərɨg nəmhəyen tuk narɨmnar khapsaah. Kɨni nəmehuə kape nəmə Isrel, mɨne jif pris mɨnə, mɨnə nəmhajoun kape Loa kape Moses, iriə tukhaukreikɨn-pə nɨmeitairiə kɨmi Yo, mɨshopni Yo. Mərɨg nɨpɨg yame ror kɨsisər kɨn, Kughen tukror Yo jakamragh mɨn ye nɨmhəyen kafak.” ");
INSERT INTO nwi_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kɨni Yesu rɨni-pən tuk kafan narmamə mɨnə mɨmə, “Tukmə yermamə rɨmə tukrɨkwasɨg kɨn Yo, in tukraməkeikei məta ye nərɨgien kafan, kɨni tukmə rərɨg pawk nəmhəyen rəmhen kɨn nəmhəyen ye nɨmhəyen ye nai kamarkwao kɨn, mərɨg tukrɨkwasɨg kɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yermamə yame ramgɨn tuk kafan nɨmraghien, tukraməkeikei mɨmhə. Mərɨg yermamə yame tukhopni tuk nɨkwasɨgien kɨn Yo, tukrarə ye nɨmraghien rerɨn. ");
INSERT INTO nwi_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tukmə yermamə kɨrik kafan nautə rehuə pɨk ye tokrei nɨmoptanə e, mərɨg ramarakikɨn kafan nɨmraghien tukun, nanmɨn tukrerwei. ");
INSERT INTO nwi_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tukmə nakaurɨs kɨn nɨni-ərhavyen nhagɨk mɨne nəgkiarien kafak ye nɨmrɨ mɨrh, Yo mɨn jakaurɨs kɨn nɨni-ərhavyen nhagɨm nɨpɨg Yo, Ji Yermamə, jakrerɨg-pə mɨn kɨmawə agelo rhakə yamə mɨne tukhauə ye neihuəyen kape Rɨmɨk. ");
INSERT INTO nwi_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mərɨg yakamni nəfrakɨsien tuk əmiə mə, kɨmiə tɨksɨn e nakasərer ikɨn e, kwasɨg ikɨn nakhamhə, taksəm narmaruyen kape Kughen.” ");
INSERT INTO nwi_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu rɨmnəgkiar ta, nɨpɨg eit ruə mɨvən, kɨni rɨkɨr Pita, mɨne Jon mɨne Jemes mɨshaktə mhavən ye tukwas kɨrik mə tuksəhuak. ");
INSERT INTO nwi_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nɨpɨg raməhuak hanə, nɨmrɨn rukreikɨn muə mor pɨsɨn. Kɨni neipən kafan raməsiə rəmhen kɨn naroapɨgien kape karuəruə. ");
INSERT INTO nwi_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Məkne, Moses mɨne Elaeja ");
INSERT INTO nwi_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","kratərhav-pə, nɨkhakien rarkurao irəriu. Kwarer mwəgkiar irisɨr Yesu. Marhɨni nɨmhəyen kape Yesu apa Jerusalem yame tukror nəgkiarien kape profet mɨnə kape Kughen tukruə mor nəfrakɨsien kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mərɨg Pita mɨne in mir kɨraru, napɨrien rɨmɨvəh nɨmrɨrisɨr, kɨmɨrhapɨr kape nɨpɨg kwakwə. Mərɨg nɨpɨg kɨmɨrharha, mɨrhəm nɨkhakien rarkurao ye Yesu, mɨrhəm mɨn Moses mɨne Elaeja kawərer irisɨr Yesu. ");
INSERT INTO nwi_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kɨni nɨpɨg kwərə mir a kɨmɨravən, Pita rɨni-pən tuk Yesu mə, “Yermaru. Rhuvə mə kɨmasɨr jakarharə ikɨn e. Pəh jakrharkwopək nimə kɨsisər- kafam kɨrik, kape Moses kɨrik, mɨne kape Elaeja kɨrik.” (Mərɨg in rɨmnəgkiar əmə mɨpəh nɨrkunien nar yame ramni). ");
INSERT INTO nwi_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","In raməgkiar hanə, napuə kɨrik reiwaiyu muvrɨg əpɨs əriə. Napuə rɨmnhorukɨn əriə, kɨrhɨgɨn pɨk. ");
INSERT INTO nwi_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kɨrhərɨg nəgkiarien kɨrik rɨsɨ-pən ye napuə mamni mɨmə, “!In e Narɨk yame yɨmɨrpen; taksətərɨg kɨn In!” ");
INSERT INTO nwi_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kɨmɨsərɨg ta nəgkiarien yame Kughen rɨmɨni, kɨni Pita mɨne Jon mɨne Jemes kɨmɨrharha-pən mɨrhəm Yesu ramərer pɨsɨn əmə. Ye nɨpɨg mɨnə a, kɨmɨrhɨpəh nɨrhɨni-ərhavyen narɨmnar mɨnə a kɨmi narmamə; mɨrhɨpəh nɨrhɨniyen narɨmnar a yame kɨmɨrhəm. ");
INSERT INTO nwi_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kəni rɨkwamer kɨn, kɨsəta ye tukwas mɨseiwaiyu-pə, mɨsəm narmamə khapsaah kamhauə mə tuksəm Yesu. ");
INSERT INTO nwi_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kɨni yermamə kɨrik ramokrən apomh kɨn Yesu mɨmə, “Yhajoun. Yakorkeikei pɨk mə takuə masitu irak. Kwajikovə kafak yerman kwənkwan kɨrikianə əmə. ");
INSERT INTO nwi_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nɨpɨg nanmɨn hah kɨrik ramərer-pən iran, mor in ramətəpar pɨk, nɨpran ramətəmnɨmɨn mamor ghan əmə. Nehe nəkwan ramaiyu rhawən. Nanmɨn has a ramoriah pɨk in; mamraptərəkɨn in, mɨpəh nɨpəhyen. ");
INSERT INTO nwi_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kɨni yo yɨmnəkeikei kɨmi kafam narmamə mɨnə mə tuksəko ta nanmɨn has e, mərɨg kɨseinein.” ");
INSERT INTO nwi_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “!Kəsi! Kɨmiə yamə mɨne naksarə e towei mɨne, nhatətəyen kapəmiə rɨrkək. Kɨni kapəmiə nətərɨgien rapəh natuatukien. ?Kɨtawəm kɨmiə tuksarə mɨseriaji nɨpɨg pukaa nakpishatətə irak?” Kɨni rɨni-pən tuk rɨm kwajikovə ai mɨmə, “Harəh pɨkwarien en mhauə.” ");
INSERT INTO nwi_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kɨni pɨkwarien a ruə tuk Yesu, məkneikɨn nanmɨn has rəsuə kɨn reiwaiyu mowhan, mamətəmnɨmɨn. Mərɨg Yesu rɨmnəgkiar skai kɨmi nanmɨn has məko-ta. Kɨni mor huvə pɨkwarien a. Meighan-pən kɨn pɨkwarien a kɨmi nɨsɨni mɨne rɨmni. ");
INSERT INTO nwi_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kɨni iriə m-fam kɨsakur, rɨkiriə ragien tuk nəsanɨnien kape Kughen. Mərɨg nɨpɨg narmamə kɨmɨsakur pɨk kɨn narɨmnar m-fam yame Yesu rɨmnor iriə miriə, kɨni In rɨni-pən tuk kafan narmamə mɨnə mɨmə, ");
INSERT INTO nwi_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Havəh tɨm tɨm nəgkiarien e yerkimiə: Yermamə kɨrik tukreighaan pən kɨn Yo, Ji Yermamə, ye kwermɨ tɨkmɨr mɨnə kafak.” ");
INSERT INTO nwi_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mərɨg kafan narmamə mɨnə kɨmɨseinein nɨprai nəgkiarien e meinai Kughen rɨmnerkwaig kɨn nɨprai nəgkiarien e mə iriə tukhapəh nharkunien; kɨni iriə khagɨn mɨn kɨn naiyoh-pən-ien kɨn nɨpran. ");
INSERT INTO nwi_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kɨni narmamə kape Yesu kɨsotgoh kɨmi əriə mɨnə mhamə, “?Pa irətawə in ravəh nehuəyen, yame rhuvə mapita?” ");
INSERT INTO nwi_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mərɨg Yesu rɨmɨrkun kapəriə nətərɨgien, kɨni mɨvən mɨkɨr kwajikovə kɨrik mərɨp ye nɨkarɨn, ");
INSERT INTO nwi_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","mɨni-pən tuk əriə mɨmə, “Tukmə yermamə kɨrik ravəh nhagɨk, mamasitu kɨn ye kwajikovə kɨrik rəmhen kɨn yame, nasituyen e in e tukror mɨn kɨmi Yo. Kɨni pəh nien mə ramor əmə irak, mərɨg ramor mɨn kɨmi Yermamə yame rɨmnher-pə kɨn Yo. Meinai tukmə yermamə rɨvəh-si əhu atuk in yetanə, in tukruə mamehuə mapita.” ");
INSERT INTO nwi_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Kɨni Jon rɨmɨni mɨmə, “Yermaru. Kɨmawə yɨmɨsəm kwən kɨrik ravəh nhagɨm, maməkota nanmɨn has mɨnə kɨn, mərɨg yakhamə jakhani-əhu, meinai kwən a, pəh nien mə kɨtawə kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mərɨg Yesu rɨmɨni-pən tuk əriə mɨmə, “Hapəh nhani-əhuyen in. Meinai, tukmə yermamə kɨrik rɨpəh norien tɨkmɨr kɨtawə min, in kɨtawə kɨrik en.” ");
INSERT INTO nwi_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kɨni ruauə ipakə tuk nɨpɨg yame Kughen tukrɨwəh Yesu iran mɨvən apa ye rao ye neai. Kɨni Yesu rɨkin rɨmnəsɨk mə tukraməkeikei mɨvən apa Jerusalem, nar kɨrik rɨrkək yame tukrərer əswasɨg kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kɨni In rher-pən kɨn yəgkiar tɨksɨn khavən apa yerkwanu kɨrik apa Sameria, mə tuksor apnəpeinə tukun. ");
INSERT INTO nwi_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mərɨg narmamə aikɨn a, khapəh nɨsorkeikeiyen mə In tukrɨvən marə a iməriə ikɨn, meinai iriə kwənharkun huvə mə In ramvən mɨn Jerusalem. ");
INSERT INTO nwi_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kɨni kafan yermamə mir e Jemes mɨne Jon kɨmɨwəm mə narmɨnə Sameria khapəh nɨsorkeikeiyen əriə, krəmə, “Yermaru. ?Nakorkeikei mə jakwokrən kɨn nap rɨsɨ-faktə ye neai meiwaiyu məs əriə, uə?” ");
INSERT INTO nwi_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mərɨg Yesu rarha-pən məm əriu mɨni-əhu. ");
INSERT INTO nwi_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kɨni khatərhav mhavən mɨn yerkwanu pɨsɨn mɨn kɨrik. ");
INSERT INTO nwi_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kɨni Yesu mɨne kafan narmamə mɨnə kɨmɨseriwək ye swatuk, kɨni kwən kɨrik rɨni-pən tukun mɨmə, “Yo jakɨkwasɨg kɨn ik ikɨn hiə takvən ikɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Kɨni Yesu rɨni-pən tukun mɨmə, “Kuri aparu mɨnə, kapəriə nəpəəg rarə yame kasapɨr ikɨn. Kɨni man mɨnə, nimairiə rarə yame kasapɨr ikɨn. Mərɨg Yo, Ji Yermamə, kafak nimə rɨrkək tuk napɨrien.” ");
INSERT INTO nwi_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kɨni Yesu rɨni-pən mɨn tuk kwən kɨrik mɨmə, “Yuə, kɨrau mik, muə kafak kɨrik yermamə.” Mərɨg kwən a rɨni-pən tukun mɨmə, “Rhuvə, Yermaru. Mərɨg eighaan kɨn yo yakvən pi pom mɨnɨm rɨmɨk.” ");
INSERT INTO nwi_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mərɨg Yesu rɨni-pən tukun mɨmə, “Nɨkam. Apəh-pən. Narmamə yamə mɨne khapəh nhavəhyen nɨmraghien pəh khavən mhanɨm nəmə mhə mɨnə. Mərɨg ik, yuvən mɨni-ərhav narmaruyen kape Kughen.” ");
INSERT INTO nwi_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kɨni kɨrik mɨn rɨni mɨmə, “Yermaru, jakɨkwasɨg kɨn ik muə yermamə kɨrik kafam. Mərɨg, awhin yo, pəh yakrerɨg mɨvən imak ikɨn mawiə kɨn yo mɨnə tɨksɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mərɨg Yesu rɨni-pən tukun mɨmə, “Yermamə yame rɨmə tukror wok kape Kughen, mərɨg rɨkin ramvən tuk nar pɨsɨn, rapəh nəmhenien mə to ruə Kughen ramarmaru iran.” ");
INSERT INTO nwi_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kwasɨg ye narɨmnar mɨnə a, Yesu Yermaru rɨmɨrpen ta narmamə kafan seventi tu, kɨni mher-pən kɨn əriə kɨraru kɨraru kɨsəkupən kɨn In mhavən ye taon mɨnə mɨne ikɨn mɨnə tɨksɨn yamə mɨne Yesu tukrɨpikwasɨg mɨpivən mɨn ikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kɨni rɨmɨni-pən tuk əriə mɨmə, “!Səm-ru! Nəvɨgɨnien rehuə apa ye nəsimien yame kwənhamruə. Mərɨg yorwok kwatɨksɨn əmə yame kamhavəh. Kɨni səhuak-pən kɨmi Yemasur kape nəsimien mhamə In tukrher-pə kɨn yorwok mɨnə khapsaah mə tukhavən mhavəh nəsimien kafan. ");
INSERT INTO nwi_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","!Havən! Mərɨg takasəkeikei mharkun mə Yo yakamher-pən kɨn əmiə mə takhavən rəmhen kɨn kwaji sipsip yamə mɨne kaseriwək mhavən yerki kuri aparu mɨnə, yame kasəs narmamə. ");
INSERT INTO nwi_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Takhapəh nharurien kwaji nɨtɨp kape mane, mɨne nɨtɨp apnapɨg mɨn, mhapəh nhavəhsi-pənien sandel, mhapəh nɨsapɨsien ye swatuk mɨsəgkiar apap kɨmi narmamə. ");
INSERT INTO nwi_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Naha nimə yame taksapɨr ikɨn, taksokupən mhani-ərhav mhamə, ‘Pəh nəmərinuyen tukramarə eikɨn e.’ ");
INSERT INTO nwi_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tukmə narmamə aikɨn, iriə narmamə kape nəmərinuyen, kafam nəhuakien tukruə mor nɨpran, nəmərinuyen tukraməmɨr tuk əriə. Mərɨg tukmə narmamə kape nəmərinuyen rɨrkək aikɨn, kwənkwai nəhuakien kafam tukrɨrerɨg-pre mɨn tuk ik. ");
INSERT INTO nwi_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Taksapɨr əmə ye nimə a, mhapəh nɨsapɨrien ye nimə pɨsɨn pɨsɨn. Kɨni taksən naha nəvɨgɨnien yame tukvəhsi-pre kɨmi əmiə, mhanɨm naha nɨnɨmien yame tukvəhsi-pre kɨmi əmiə. Meinai ratuatuk mə narmamə yamə mɨne kasor wok tukhavəh nərokien iran. ");
INSERT INTO nwi_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Tukmə nakhavən ye taon kɨrik, kɨni narmamə rɨkiriə ragien tuk əmiə, sən naha nəvɨgɨnien yame tukvəhsi-pre kɨmi əmiə, ");
INSERT INTO nwi_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","mɨsor huvə narmamə aikɨn yamə mɨne kamhamhə. Mhani-ərhav tuk əriə mhamə, ‘Narmaruyen kape Kughen ruauə ipakə tuk əmiə.’ ");
INSERT INTO nwi_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mərɨg tukmə nakhavən ye taon kɨrik, kɨni narmamə rɨkiriə rɨpəh nagienien tuk əmiə, havən mɨseriwək ye swatuk ehuə mamhani mhamə, ");
INSERT INTO nwi_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Yaksarpita-arpita nɨmokrur ye taon kapəmiə yamə ramswin-pən ye nɨhumawə, ramor nɨmtətien mə nɨmɨsor nar kɨrik rapəh nəmhenien. Kɨni Kughen rɨmnəpəh əmiə. Mərɨg takasəkeikei mharkun mə narmaruyen kape Kughen ruauə pakə ta.’ ");
INSERT INTO nwi_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kɨni yakamni-pre əfrakɨs tuk əmiə mə Kughen tukror narpɨnien ehuə kɨmi əriə rapita narpɨnien yame rɨmnor ye taon has a Sodom kupən. ");
INSERT INTO nwi_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“!Kɨmiə nəmə Korasin! !Kəsi! Nəmhəyen ehuə tukruə tuk əmiə. Kɨmiə nəmə Betsaeda, kəsi, nəmhəyen ehuə tukruə tuk əmiə, meinai yɨmnor pawk nar apsɨpɨs rehuə ye taon mir kapəmiə. Kɨni tokmə yapior narɨmnar mɨnə a apa Taea mɨne Saedon kupən, narmamə a to kɨpisarar ye nərɨgien kapəriə tuk təvhagə has mɨpihavən ye neipən has, mɨpisəsok-əsok ye nɨmrawk ror nɨmtətien mə kɨsərɨg rahas pɨk tuk kapəriə norien has mɨnə. ");
INSERT INTO nwi_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mərɨg ye nɨpɨg a yame Kughen tukror narpɨnien kapəmiə, in tukrɨskai pɨk rapita narpɨnien yame tukror kɨmi narmamə yamə mɨne kɨmɨsarə apa Taea mɨne Saedon kupən. ");
INSERT INTO nwi_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kɨni kɨmiə nəmə Kapeneam. ?Kɨmiə nakhamə ta mə Kughen tukrɨvəh-si haktə əmiə ye kwənmhaan kape nɨsiaiyen ye rao ye neai? Nɨkam. Kughen tukrɨvəh-si-əhu əmiə naksweiwaiyu pɨk əgkəp, ye kwənmhaan kape narpɨnien.” ");
INSERT INTO nwi_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kɨni Yesu rɨni-pən tuk kafan mɨnə mɨmə, “Narmamə yamə mɨne kasətərɨg kɨn əmiə, kasərɨg Yo. Kɨni narmamə yamə mɨne kamhaukreikɨn-pən nɨmetairiə kɨmi əmiə, khaukreikɨn-pə mɨn nɨmetairiə kɨmi Yo, kɨni narmamə yamə mɨne kamhaukreikɨn-pə nɨmetairiə kɨmi Yo, kamhaukreikɨn-pən nɨmeitairiə kɨmi Yermamə yame rɨmnher-pə kɨn Yo.” ");
INSERT INTO nwi_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kɨni narmamə seventi tu kape Yesu kharerɨg-pə mɨn, rɨkiriə ramagien, mhani-pən tuk Yesu mhamə, “Yermaru. !Nar apnapɨg mə nanmɨn has mɨnə, mərɨg kɨmawə yaksəgkiar ye nhagɨm, kɨni iriə kasor nəkwaimawə!” ");
INSERT INTO nwi_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “Yo yɨmnəm Setan rɨsɨ-pən ye neai meiwaiyu rəmhen kɨn yame naroapɨgien reiwaiyu mowhan. ");
INSERT INTO nwi_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Sətərɨg-ru. Yo yakvəhsi-pre ta nəsanɨnien kɨmi əmiə. In a nakharkun nɨsəvi-əpniyen snek mɨnə mɨne milped mɨnə. Kɨni nəsanɨnien yame yakavəh-si-pre kɨmi əmiə in rapita nəsanɨnien kape tɨkmɨr kapətawə e Setan. Kɨni to nar kɨrik rɨpəh noriahyen əmiə. ");
INSERT INTO nwi_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","In e nəfrakɨsien. Mərɨg tukmə naksagien, pa rɨmə naksagien mə nanmɨn has mɨnə kasor nəkwaimiə, mərɨg taksagien mə kwərai-pən ta nhagmiə ye nəkwəkwə ye rao ye neai.” ");
INSERT INTO nwi_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kɨni ye nɨpɨg a, Yesu, rɨkin ramagien pɨk ye nagienien yame ramsɨ-pən ye Nanmɨn kape Kughen, kɨni In raməhuak mamni mɨmə, “Tatə Kughen. Ik Yermaru kape narɨmnar fam- yerpɨrɨg ye neai, mɨne ye tokrei tanə. Yakəgnəgɨn Ik meinai Ik nɨmnerkwaig kɨn nɨprai narɨmnar mɨnə e ye nɨmrɨ narmamə yamə mɨne kharkun nar. Kɨni mor əpu kɨmi narmamə yamə mɨne kɨsəmhen əmə kɨn kwajikovə mɨnə mə iriə e tukharkun nar. Ǝwəh. Tatə. In e nar yame nakorkeikei.” ");
INSERT INTO nwi_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kɨni Yesu rɨrpɨn nəgkiarien mɨni-ərhav mɨmə, “Rɨmɨk rɨmneighan-pə ta kɨn narɨmnar fam ye kwermɨk. Kɨni Rɨmɨk pɨsɨn əmə rɨrkun Tɨni. Kɨni Tɨni əmə mɨne narmamə kafan mɨnə, iriə əmə kharkun Rɨmni. Iriə e narmamə yamə mɨne Tɨni rɨmɨrpen ta əriə mə In tukror əpu Rɨmni tuk əriə.” ");
INSERT INTO nwi_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kɨni Yesu rarar məgkiar əmə kɨmi kafan narmamə mɨnə mɨmə, “Kɨmiə nakasarə ye nɨhuvəyen əfrakɨs meinai kɨmiə nakasəm narɨmnar mɨnə e ye nɨmrɨmiə. ");
INSERT INTO nwi_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Yakamni-pre tuk əmiə mə apa kupən, profet mɨnə khapsaah, mɨne king mɨnə khapsaah, kɨmɨsorkeikei pɨk mə tuksəm narɨmnar mɨnə e yame kɨmiə nakasəm ai taktəkun. Mərɨg kɨmnhapəh nɨsəmien. Kɨni iriə kɨmɨsorkeikei mə tuksərɨg narɨmnar yamə mɨne nakasərɨg, mərɨg kɨmnhapəh nɨsərɨgien.” ");
INSERT INTO nwi_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nɨpɨg kɨrik, yemhajoun kɨrik kape Loa kape Moses ruə mɨni naiyohyen kɨrik kɨmi Yesu mə tukrəm-ru mə Yesu rɨrkun nar uə nɨkam. Mɨmə, “Yhajoun. ?Jakhawor pən iran mɨne mɨvəh nɨmraghien rerɨn?” ");
INSERT INTO nwi_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Kɨni Yesu rɨni-pən tukun mɨmə, “?Mərɨg Loa kape Moses ramni naha nhagɨn? ?Nɨpɨg nakəvheikɨn, kɨni nɨpran ramni naha nhagɨn tuk ik?” ");
INSERT INTO nwi_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kɨni kwən a rɨni-pən mɨmə, “Takaməkeikei morkeikei Kughen Yermaru kafam yerkim fam, mɨne ye nɨmraghien mɨ-fam kafam, mɨne ye nəsanɨnien fam kafam, mɨne ye nətərɨgien fam kafam. Kɨni morkeikei mɨn ik mɨnə tɨksɨn rəmhen kɨn yame nakorkeikei atuk ik.” ");
INSERT INTO nwi_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Kɨni Yesu rɨni-pən tukun mɨmə, “In atuatuk en. Tukmə nakor məknakɨn, kɨni ik takvəh nɨmraghien rerɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mərɨg kwən a, in rorkeikei əmə mə tukrhajoun mə in yemə atuatuk, kɨni maiyoh-pən Yesu mɨmə, “?Mərɨg, nɨ-pa mɨnə e yo mɨnə tɨksɨn?” ");
INSERT INTO nwi_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Kɨni Yesu rɨni-pən tukun mɨmə, “Yemə Isrel kɨrik rɨmatərhav Jerusalem meriwək mamvən apa Jeriko. Mamvən ye swatuk, yəkrəh mɨnə tɨksɨn kɨmnharaptərəkɨn mhapɨk ta kafan narɨmnar, kɨni mhauh, rɨmhə rhaih, mɨsap ta kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mərɨg ye nɨpɨg atuatuk a, pris kɨrik rəri-pən swatuk a mamuə. Mərɨg nɨpɨg in rɨmnəm kwən a, rəurək kɨn mamvən. ");
INSERT INTO nwi_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kɨni Lifaet kɨrik rəri-pən mɨn swatuk a mamuə. Kɨni nɨpɨg rɨmnəm kwən a raməmɨr, in rɨmnor əmə nar kɨrikianə kɨn məurək kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Mərɨg yemə Sameria kɨrik yame kasor tɨkmɨr iriə nəmə Isrel, in mɨn rəri-pən swatuk a mamuə, kɨni məm kwən a raməmɨr. Nɨpɨg rɨmnəm, rɨkin rɨmhə tukun. ");
INSERT INTO nwi_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kɨni meriwək mɨvən pakə tukun. Maməkwi kafan nɨmap mɨnə kɨn nehe olif mɨne waen, muvrɨg kafan nɨmap mɨnə. Kɨni mɨrəh-si haktə kwən a mərəhu-haktə ye kafan dongki, kɨni mɨrəh mɨravən apa ye hotel, mamarha huvə tukun aikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kəni rɨkwamer kɨn, in rɨvəh mane tɨksɨn, mɨvən mɨvəhsi-pən kɨmi yamehuə kape hotel, mɨni-pən tukun mɨmə, ‘Takamarha huvə tuk kwən en. Kɨni tukmə nakəvrə kɨn kafam kɨrik mane, tukmə yakrerɨg-pə, nakni tuk yo pəh jakarpɨn.’” ");
INSERT INTO nwi_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kɨni Yesu rɨmɨni-ta nuhpɨkɨnien a, marar maiyoh-pən yemhajoun kape Loa kape Moses mɨmə, “?Ye kafam nərɨgien, nakɨrkun mə kwərə misɨr a, pa nhagɨn rɨmnor huvə pən kɨmi kwən a kɨmoh, rəmhen kɨn mə in kɨrik?” ");
INSERT INTO nwi_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Kɨni yemhajoun kape Loa kape Moses rɨmɨni-pən tukun mɨmə, “Yermamə yame rɨkin rehuə tuk kwən a.” Kɨni Yesu rɨni-pən tukun mə, “Ita. Ik yuvən mor mɨn rəmhen kɨn yame kwən a rɨmnor.” ");
INSERT INTO nwi_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kɨni nɨpɨg Yesu mɨne kafan narmamə mɨnə kaseriwək ye swatuk, mhatərhav-pən yerkwanu kɨrik. Kɨni piraovɨn kɨrik, nhagɨn e Mata, rɨkɨr Yesu yerkin agien mɨravən ye kafan nimə. ");
INSERT INTO nwi_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Pian a, naorahini e Meri. Kɨni Meri ruə məkwətə-pən ipakə tuk nɨhu Yesu Yermaru, mamətərɨg kɨn nəgkiarien mɨnə kafan. ");
INSERT INTO nwi_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mərɨg Mata, kafan nətərɨgien ramvən pɨk tuk norien nəvɨgɨnien. Kafan wok rɨmoh in. Kɨni rɨvən mɨni-pən tuk Yesu mɨmə, “Yermaru. ?Rhawor? ?Rɨkim raməsɨk mə ratuatuk uə nɨkam mə pian e naorahik rapəh nasituyen irak tuk norien wok e, kɨni yo pɨsɨn əmə yakamor. Her-pə kɨn pəh ruə masitu irak.” ");
INSERT INTO nwi_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mərɨg Yesu Yermaru rɨni-pən tukun mɨmə, “Eh, Mata. Takpəh nərɨg-pɨkien narɨmnar rɨpsaah məknei. ");
INSERT INTO nwi_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mərɨg nar kɨrikianə əmə in nar keikei. Kɨni Meri rorkeikei nar yame rhuvə rapita, kɨni to yakpəh mɨn nɨvəhsi-tayen.” ");
INSERT INTO nwi_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nɨpɨg kɨrik, Yesu rɨmnaməhuak apa ikɨn kɨrik. Kɨni nɨpɨg rɨmnəhuak ta, kafan kɨrik yermamə raiyoh In mə, “Yermaru, hajoun-ru əmawə kɨn nəhuakien rəmhen kɨn yame Jon Baptaes rɨmnhajoun kafan mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “Nɨpɨg nakahamə taksəhuak, takhani mhamə, “‘Rɨmtawə ye neai, nhagɨm rəmərhakə, pəh narmamə tukhasiai Ik. Pəh kafam narmaruyen tukruə mamarə. ");
INSERT INTO nwi_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nɨpɨg mɨ-fam, vəh-si pə nəvɨgɨnien kɨmi əmawə rəmhen tuk nɨpɨg e towei. ");
INSERT INTO nwi_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kɨni vəh-si ta narpɨnien kape təvhagə hah kapəmawə meinai kɨmawə yakhapəh nharaptərəkɨn tɨm-tɨmien norien has yame narmamə kasor irəmawə. Pəh nɨpəhyen əmawə mə Setan tukrɨvəhsi-pə vəh-si-pə kɨmi əmawə tamə yakhamɨr.’” ");
INSERT INTO nwi_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Kɨni rɨni-pən tuk əriə mə, “?Tukmə yermamə kɨrik ruə imam ikɨn yenpɨg, tukmə nakəm nəvɨgɨnien rɨrkək, kɨni takhawor pən iran mɨne? Takvən imei ik kɨrik, mɨni-pən mɨmə, ‘Yo kɨrik, vəh-si-pə nəvɨgɨnien kɨrik, pəh yakvən məvɨgɨn yermamə kɨrik kɨn yame rɨmasɨ-pən isok mɨtərhav-pə imak ikɨn yenpɨg. Mərɨg nəvɨgɨnien rɨrkək yame jakəvɨgɨn in kɨn.’ ");
INSERT INTO nwi_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kɨni ik kɨrik tukrhorpɨn nəgkiarien kafam mɨmə, ‘!Ah! Amvən. Pəh nɨsɨgien əmawə. Yaknəsapɨr kɨmawə kwajikovə mɨnə. To yakpəh nərerien mɨvəhsi-pre nəvɨgɨnien kɨmik.’ ");
INSERT INTO nwi_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yakamni-pre tuk əmiə mə, nar apnapɨg mə in ik əgkəp kɨrik, mərɨg kwən a rɨpəh norkeikeiyen mə tukrɨvəh-si-pre nəvɨgɨnien kɨmik. Mərɨg yakamni əfrakɨs mə tukmə nakamharpɨn ye naiyohyen, in tukraməkeikei mərer mɨvəh-si-pre narɨmnar fam kɨmik yame nakorkeikei. ");
INSERT INTO nwi_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kɨni ror məknakɨn, yakamni-pre tuk əmiə mə, saiyoh Kughen kɨn narɨmnar, kɨni In tukrɨvəh-sipre kɨmi əmiə. Sarha kɨn, mɨsəm. Səsɨk-əsɨk kwəruə, kɨni pəh kwəruə tukrəhitə tuk əmiə. ");
INSERT INTO nwi_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Yakamni məknakɨn meinai narmamə m-fam yamə mɨne kɨsaiyoh, tukhavəh. Kɨni narmamə yamə mɨne kasarha kɨn, tuksəm mɨn. Kɨni yamə mɨne kɨsəsɨk-əsɨk kwəruə, kwəruə tukrəhitə tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Kɨni, kɨmiə tatə mɨnə. Yermamə kɨrik aikɨn irəmiə yame tukmə tɨni raiyoh kɨn kəməəm, mərɨg ravəhsi-pən snek uə, nɨkam? !Nɨkam! ");
INSERT INTO nwi_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","?Uə tukmə nɨpɨg raiyoh kɨn kwənəhr man, mərɨg ravəhsi-pən milped uə? !Nɨkam! ");
INSERT INTO nwi_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kɨmiə naksahas pawk, mharkun nhavəh-si-pənien narɨmnar huvə mɨnə kɨmi jimiə mɨnə. Mərɨg Rɨmtawə Kughen ye neai, kafan norien rhuvə pɨk rapita norien kapəmiə, kɨni nəfrakɨsien, In tukrɨvəh-si-pre Nanmɨn Kafan kɨmi narmamə yamə mɨne kɨsaiyoh kɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kɨni nɨpɨg kɨrik, kwən kɨrik aikɨn yame nanmɨn has raməmɨr iran, mamor in rameinein nəgkiarien. Kɨni Yesu rɨmnəko-ta nanmɨn has a iran, kɨni kwən a rɨrikakun maməgkiar, kɨni narmamə kɨsakur pɨk kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mərɨg narmamə tɨksɨn kɨmnhani mhamə, “!Nɨkam! Rɨrkun nəko-tayen nanmɨn has mɨnə meinai rɨkwasɨg kɨn Setan, yemehuə kape nanmɨn has mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mərɨg narmamə mɨnə mɨn tɨksɨn aikɨn khamə tukharkun-ru mə nəsanɨnien kafan ramsɨpkaa, kɨni mɨsaiyoh In mə tukror nɨmtətien kɨrik ye nəsanɨnien yame ramsɨpən ye rao ye neai. ");
INSERT INTO nwi_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mərɨg Yesu ruɨrkun ta nətərɨgien kapəriə kɨni mɨmə, “Nɨkam. Tukmə narmamə ye kantri kɨrik kasəwhai əriə mɨnə, mɨsarə kɨraru, kɨni tuksoriah kapəriə narəyen, kantri tukrɨmɨr. Kɨni rəmhen mɨn kɨn yerkwanu kɨrik. Tukmə narmamə kasəwhai əriə mɨnə, mɨsarə kɨraru, rukwanu a to rɨpəh narə-huvəyen. ");
INSERT INTO nwi_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kɨni rəmhen mɨn kɨn narmamə kape Setan mɨnə, tukmə iriə kasəwhai əriə mɨnə, mɨsarə kɨraru, tukseikus-eikus mɨn nimə kape Setan. Norien kape Setan tukrɨpəh nɨskaiyen. Tukrəsaah-əsaah mɨrkək. Yakamni məkneikɨn meinai kɨmiə nakamhani mə yakaməko ta nanmɨn has ye nəsanɨnien kape Bielsebul. ");
INSERT INTO nwi_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kɨni kɨmiə mɨnə mɨn tɨksɨn nakasəko-ta nanmɨn has mɨnə rəmhen kɨn yame yakamor. Mərɨg pa rɨmə kɨsəko ta nanmɨn has mɨnə e ye nəsanɨnien kape Bielsebul. Rhuvə mə iriə tukhani neikuəyen ye nəgkiarien yame nakamhani mhamə yakaməko ta nanmɨn has ye nəsanɨnien kape Bielsebul. ");
INSERT INTO nwi_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mərɨg Yo yakəko-ta nanmɨn has mɨnə ye nəsanɨnien kape Kughen, ramhajoun mə narmaruyen kape Kughen ruauə ta tuk əmiə. ");
INSERT INTO nwi_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nɨpɨg yermamə yame nagheen rehuə, ravəhsi-pən neipən kape narowagɨnien, mamərer matuk mamarha huvə tuk kafan nimə, in, kafan narɨmnar ramswin huvə əmə. ");
INSERT INTO nwi_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mərɨg tukmə yermamə mɨn kɨrik nagheen rehuə rapita mɨn kwən a, ruə, mɨroh əriu mɨnə, mɨravən, mərɨg yermamə nagheen rehuə, in tukraməkeikei mapita, mɨvən, mɨpɨk ta neipən kape narowagɨnien yame kwən a rɨmnəkupən mɨvən iran, mamətɨgtə iran, mɨpɨk ta mɨn kafan nautə mɨvən məwhai kɨmi kafan narmamə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Yermamə yame rɨpəh nɨkwasɨgien kɨn yo, in kafak tɨkmɨr. Kɨni yermamə yame rɨpəh nofugɨnien narmamə mɨnə kafak, in raməko-ta əriə kɨsaiyu rik rik. ");
INSERT INTO nwi_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Nɨpɨg nanmɨn has raməta ye yermamə kɨrik, in ramavən ye tɨpəvsɨk, mamarha kɨn ikɨn tukrapɨs ikɨn, mərɨg rɨpəh nəmien. Kɨni in mamni mɨmə, ‘Pəh yakrerɨg pən ye kafak nimə yame yɨmnamarə ikɨn kupan.’ ");
INSERT INTO nwi_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nɨpɨg in rɨrerɨg-pə məm kafan nimə, kɨmnahiə rɨpiə huvə, narɨmnar m-fam kamhaswin huvə. ");
INSERT INTO nwi_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kɨni in ramvən mɨkɨr mɨn nanmɨn has mɨnə iriə seven yamə mɨne kɨsahas pɨk mɨn rapita in. Kɨni khavən mɨn imə mɨsarə mɨn ye nɨmraghien kape yermamə a. Kɨni yermamə a, in apa kupən, kafan nɨmraghien rahas, mərɨg taktəkun ai rɨmnahas pɨk rapita yame in kupən.” ");
INSERT INTO nwi_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu raməgkiar hanə, məkneikɨn, piraovɨn kɨrik rokrən apomh mɨmə, “Pəh Kughen tukrautə-pən kɨn kafan nɨhuvəyen kɨmi piraovɨn yame rɨmneimək kɨn ik, mɨvəhsi-pre nah kɨmik.” ");
INSERT INTO nwi_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kɨni Yesu rɨmə, “Nəfrakɨs. Mərɨg Kughen tukrautə-pən kɨn kafan nɨhuvəyen rapita kɨmi narmamə yamə mɨne kasərɨg kafak nəgkiarien masor.” ");
INSERT INTO nwi_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kɨni narmamə kɨmnhauə mə tuksərɨg nəgkiarien kape Yesu; iriə khapsaah. Kɨni Yesu rɨmə, “Kɨmiə narmamə e towei mɨne, kɨmiə naksor pɨk təvhagə has. Kɨmiə naksorkeikei mə taksəm nɨmtətien pɨsɨn kɨrik. Mərɨg tukmə ror Kughen tukrɨpəh norien nɨmtətien kɨrik irəmiə. Mərɨg tukror əmə nɨmtətien kɨrikianə əmə yame rɨmnor kupən ye nɨmraghien kape Jona. ");
INSERT INTO nwi_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Rəmhen əmə kɨn yame nɨmraghien kape Jona rɨmnor nɨmtətien ye nəsanɨnien kape Kughen kɨmi nəmə Nineve kupən. Ye norien a, in əmə mɨn e, Yo, Ji Yermamə, nɨmraghien kafak tukror nɨmtətien ye nəsanɨnien kape Kughen kɨmi narmamə e towei mɨne. ");
INSERT INTO nwi_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","In apa kupən, kwin kape kantri e Shipa, rɨmasɨ-pən isok muə mə tukrɨvəh nɨrkunien kape King Solomon kupən. Mərɨg yo yakmauə, nɨrkunien kafak rapita King Solomon. Mərɨg kɨmiə nakhapəh nɨsətərɨgien kɨn Yo. Mə tukmə nɨpɨg Kughen tukrəkir narmamə iran, kwin a tukrərer mɨni-hah yamə mɨne kɨsarə e towei mɨne. ");
INSERT INTO nwi_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kɨni ye nɨpɨg yame Kughen tukrəkir narmamə iran, nəmə Nineve mɨn tuksərer mhani hah narmamə yamə mɨne kɨsarə e towei mɨne. Meinai iriə kɨmɨsərɨg nəgkiarien kape Jona, mɨsarar ye nərɨgien kapəriə tuk təvhagə has. Mərɨg Yo yakapita Jona, mərɨg kɨmiə nakhapəh nɨsətərɨgien kɨn Yo.” ");
INSERT INTO nwi_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kɨni Yesu rɨmɨni mɨmə, “Yermamə kɨrik to rɨpəh nəsiə-pənien ye laet, kɨni merkwaig kɨn, uə məskəmnaan kɨn besin. Nɨkam. Tukmə yermamə rəsiə pən ye laet, tukraməkeikei mɨruk haktə ye kwənmhaan kape laet, mə narmamə yamə mɨne tukhauə ye nəkwai nimə masəm nar. ");
INSERT INTO nwi_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Nɨkwai nɨmrɨm in rəmhen kɨn laet yame rawəhsi-pre nɨkhakien ye nɨpram. Tukmə nɨkwai nɨmrɨm mir kɨrahuvə, rəmhen kɨn mə nɨpram rukwar kɨn nɨkhakien. Mərɨg tukmə nɨkwai nɨmrɨm mir kwahas, rəmhen kɨn mə nɨpram rukwar kɨn nəpɨgnapien. ");
INSERT INTO nwi_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kɨni ror məkneikɨn mə ik takaməkeikei mamarha huvə tuk nɨkhakien ye nɨmraghien kafam, mə takpəh nɨvənien ye nəpɨgnapien. ");
INSERT INTO nwi_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kɨni tukmə kafam nɨmraghien in rukwar huvə kɨn nɨkhakien, nəpɨgnapien tukrɨrkək əfrakɨs iram, kɨni nɨkhakien in raməsia-pen huvə fam kafam nɨmraghien rəmhen kɨn yame nɨkhakien kape laet raməsia-pen ik.” ");
INSERT INTO nwi_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kɨni Yesu rɨmnəgkiar ta, kɨni Farisi kɨrik ruə mɨni-pən tukun mɨmə tukravən məvɨgɨn ye kafan nimə. Kɨni Yesu rauru-pən imə, məkwətə-pən ye nɨkar tebol tuk nəvɨgɨnien. ");
INSERT INTO nwi_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kɨni Farisi rəm mə Yesu rɨpəh nəravyen tuk nəvɨgɨnien, rakur. ");
INSERT INTO nwi_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kɨni Yesu Yermaru rɨni-pən tukun mə, “Kɨmiə Farisi mɨnə nakhamə ta mə tukmə naksaikwas ye narɨmnar, rəmhen kɨn kap mɨne tikiplet mə kɨmiə takhahuvə, nəmkɨmɨk rɨrkək irəmiə. Mərɨg in apa imə, nəptɨgien kɨn nar mɨne nahasien rukwar irəmiə. ");
INSERT INTO nwi_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","!Kɨmiə naksarmar pɨk! ?Rɨkimiə raməsɨk uə nɨkam mə Kughen e yame rɨmnor nɨprai yermamə iruə rɨmnor mɨn rɨki yermamə imə, uə? !Ǝwəh! ");
INSERT INTO nwi_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mərɨg havəhsi-pən narɨmnar kɨmi yavən has mɨnə yerkin agien, kɨni narɨmnar fam apa iruə irəmiə mɨne in apa imə tuksatuatuk mhahuvə. ");
INSERT INTO nwi_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Mərɨg, !awi, kɨmiə Farisi mɨnə! !Nəmhəyen ehuə tukruə tuk əmiə! Kɨmiə nakasəri-pən huvə loa yamə mɨne khamar əmə tuk əmiə tuk nəri-pənien, rəmhen kɨn in e naksəri-pən loa yame ramni mə takasəkeikei mhavəh kwesrɨs mɨne onion ye nəsimien vi mhavəhsi-pən kɨmi Kughen. Mərɨg naksəpəh Loa yamə mɨne kasəkupən, iriə e, nakhapəh nɨsorien nar yame ratuatuk mɨnə kɨmi narmamə, kɨni mhapəh nɨsorkeikeiyen Kughen. To nakpisəri-pən Loa yamə mɨne kasəkupən a, mɨpisəri-pən mɨn Loa mɨnə tɨksɨn. ");
INSERT INTO nwi_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kɨmiə Farisi mɨnə, nəmhəyen ehuə tukruə tuk əmiə meinai naksorkeikei mə takhavən mɨsəkwətə əkupən əmə ye nimə kape nofugɨnien. Mɨne in apa ye maket, naksorkeikei mə narmamə tuksaowiə kɨn əmiə ye nɨsiaiyen. ");
INSERT INTO nwi_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Kɨmiə Farisi mɨnə, naksəmkɨmɨk rəmhen kɨn suranə ye yermamə yame rɨkinar rhorukɨn. Narmamə kasəriwək əsuun, mɨseinein kɨmnhavən ye kwənmhaan kape nɨmhəyen.” ");
INSERT INTO nwi_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kɨni yemhajoun kɨrik kape Loa kape Moses rɨni-pən tuk Yesu mɨmə, “Yhajoun. Nakni nəgkiarien mɨnə e, mamoriah mɨn əmawə kɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Mərɨg Yesu rɨmə, “!Kɨmiə namhajoun kape Loa kape Moses! Nəmhəyen ehuə tukrurə tuk əmiə meinai kɨmiə nakhapɨk-pən nar pam mɨnə kɨmi narmamə mə tukhapɨk. Mərɨg nakhapəh nhawəsi-pənien kwermɨmiə mə taksasitu irəriə tuk nɨpɨkien. ");
INSERT INTO nwi_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nəmhəyen ehuə tukrurə tuk əmiə. Meinai kɨmiə nakasor huvə pən marə marə ye suranə kape profet kape Kughen mɨnə, mərɨg rɨpmiə mɨnə atuatuk kɨmɨshopni əriə. ");
INSERT INTO nwi_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Naksor-pən huvə marə marə ye suranə kape profet kape Kughen mɨnə, ramhajoun mə rɨkimiə ragien tuk nar yame rɨpmiə mɨnə kɨmɨsor, in e kɨmɨshopni profet mɨnə. ");
INSERT INTO nwi_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kɨni tuk nar e, Kughen yame nɨrkunien kafan rehuə, ramni mɨmə, ‘Yo jakher-pən kɨn kafak profet mɨnə mɨne aposol mɨnə tukhavən mɨsəgkiar kɨmi əriə, kɨni mərɨg iriə tuksor nəmhəyen kɨmi tɨksɨn, mɨshopni tɨksɨn.’ ");
INSERT INTO nwi_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ror məknakɨn mə Kughen tukrəkir əmiə rəmhen kɨn mə kɨmiə atuk nɨmɨshopni profet mɨnə m-fam kafan. Kɨni In tukror narpɨnien kɨmi əmiə tuk nɨmhəyen kapəriə. Iriə yame mɨne kɨmɨsarə ye nɨrikakunien kape tokrei tanə meriaji-pə ai taktəkun- ");
INSERT INTO nwi_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","profet mɨnə fam yame kɨmnhopni əriə rɨrikakun ye Ebel muə meriaji-pə Sekaraea, yame rɨmamhə ye Nimə Ehuə kape Kughen ye kwenɨmrhei tebol mɨne kwənmhaan rhakə. Nəfrakɨsien mə kɨmiə e towei mɨne Kughen tukror narpɨnien kɨmi əmiə. ");
INSERT INTO nwi_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kɨmiə nəmhajoun kape Loa kape Moses. Nəmhəyen ehuə tukrurə tuk əmiə, meinai kɨmiə nakharkun pawk swatuk yame Kughen rorkeikei, mərɨg nakhapəh nɨsəri-pənien, masərer əswasɨg kɨn narmamə yamə mɨne khamə tuksəri-pən.” ");
INSERT INTO nwi_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kɨni Yesu rɨtərhav ye nimə a, meriwək mamvən, kɨni nəmhajoun kape Loa mɨnə mɨne Farisi mɨnə, niemhaa rhai əriə. Rɨrikakun ye nɨpɨg a, kɨmɨsor tɨkmɨr iriə min. Mɨsaiyoh-pən kɨn naiyohyen skai rehuə kɨmin ");
INSERT INTO nwi_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","mə tuksəm nəgkiarien kɨrik kafan yame tukhani hah In iran. ");
INSERT INTO nwi_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kɨni ye nɨpɨg a, narmamə khapsaah kɨmnhauə kɨrikianə, to kɨpəh nəhueikɨn-famien əriə. Mərɨg narmamə kwənhapsaah pɨk, kɨni mhasɨg-ta-sɨg-ta əriə mɨnə. Kɨni Yesu rɨrikakun maməgkiar kɨmi kafan narmamə mɨnə, mɨmə, “Kɨmiə, takasərɨg əmiə tuk yis kape Farisi mɨnə, yis e in e nəgkiarien kapəriə rhuvə mərɨg nərɨgien kapəriə rəmkɨmɨk. ");
INSERT INTO nwi_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tukmə nar erkwaig, tukaməkeikei kəm. Tukmə kuvrɨg əpɨs, kɨni mərɨg tukraməkeikei mier-pə ikɨn rhakak ikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nəgkiarien yame nakhani yenpɨg, tukərɨg yeraan. Nəgkiarien yame nakhani ye nəkwai nimə, tukni-ərhav ye swatuk.” ");
INSERT INTO nwi_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Kɨni Yesu rɨmə, “Kafak narmamə mɨnə, yakamni-pre tuk əmiə mə takhapəh nhagɨnien kɨn narmamə yamə mɨne kharkun nhopniyen nɨpraimiə, meinai kwasɨg ikɨn, to khapəh nɨsor-has-preyen nar kɨrik kɨmi əmiə. ");
INSERT INTO nwi_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mərɨg yakamni-ərhav yermamə e kɨmi əmiə mə ratuatuk mə takhagɨn kɨn. Takasəkeikei mhagɨn kɨn Kughen, meinai tukmə In rhopni yermamə kɨrik, In rɨrkun narakikɨn-pən-ien in apa ye nap ehuə. Ǝwəh, nəfrakɨsien, yakamni-pre tuk əmiə mə takasəkeikei mhagɨn kɨn Kughen. ");
INSERT INTO nwi_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nar apnapɨg keihap in rɨkəskəh pɨk, kɨvəh nɨmrɨn kwaji mane əmə, mərɨg Kughen ramarha huvə tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kɨni nɨmraghien kapəmiə rapita nɨmraghien kape keihap. Kɨni tukmə Kughen ramarha huvə tuk keihap ramhajoun pən mə tukraməkeikei mamarha huvə əmiə rapita. Nəfrakɨsien, nar apnapɨg nɨmar nɨkwənemiə in nar kəskəh, mərɨg Kughen raməvheikɨn fam muɨrkun ta mə kuvhuun. ");
INSERT INTO nwi_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Kɨni yakamni-pre tuk əmiə mə tukmə yermamə kɨrik ramni-ərhav nhagɨk ye nɨmrɨ narmamə, Yo, Ji Yermamə, yo mɨn jakni-ərhav nhagɨn ye nɨmrɨ agelo mɨnə kape Kughen mə in kafak yermamə. ");
INSERT INTO nwi_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mərɨg tukmə yermamə ramni-ərhav ye nɨmrɨ narmamə mə reinein Yo, Yo jakni-ərhav mɨn ye nɨmrɨ agelo mɨnə kape Kughen mə yakeinein mɨn in. ");
INSERT INTO nwi_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kɨni yermamə yame ramni hah Yo, Ji Yermamə, Kughen rɨrkun nɨvəh-si tayen narpɨnien ye kafan təvhagə hah. Mərɨg yermamə yame ramni hah Nanmɨn kape Kughen, Kughen to rɨpəh nɨvəhsi-tayen narpɨnien kape kafan təvhagə has. ");
INSERT INTO nwi_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Kɨni tukmə kərɨp-ərhav əmiə ye nimə kape nofugɨnien, uə ye nɨmrɨ nəmehuə mɨnə, uə ye nɨmrɨ narmaru mɨnə, mə tukharuk-pre nəgkiarien has irəmiə, pəh kɨmiə takhapəh nɨsətərɨg-pɨkien mə takshawor-pən iran mɨne mɨshorpɨn nəgkiarien kapəriə, ");
INSERT INTO nwi_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","meinai ye nɨpɨg atuatuk a, Nanmɨn kape Kughen tukrhajoun əmiə kɨn naha nəgkiarien yame takasəkeikei mhani-ərhav.” ");
INSERT INTO nwi_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kɨni nəmə mɨnə a kɨrik rɨni-pən tuk Yesu mɨmə, “Yhajoun. Rɨmɨk ruamhə ta. Aweh. Uh rɨki piak mə tukrəwhai narɨmnar kape rɨmɨmru, mɨvəhsi-pə yame rɨmɨmru ruɨni ta mə kafak.” ");
INSERT INTO nwi_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mərɨg Yesu rɨmɨni-pən tukun mɨmə, “Kafak yermamə. Yakɨrkək ye nətərɨgien e kapəmiru tuk nəwhaiyen kapəmiru narɨmnar.” ");
INSERT INTO nwi_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kɨni mɨni-pən tuk əriə mɨmə, “!Takasərɨg əmiə! Taksətapɨg kɨn əmiə mə takhapəh nɨsəptɨgien kɨn nar. To yermamə kafan nautə rehuə pawk, mərɨg pəh nien mə nautə in nuknei nɨmraghien.” ");
INSERT INTO nwi_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kɨni rɨmɨni nuhpɨkɨnien kɨrik mɨmə, “Yermamə kɨrik, kafan nautə rɨpsaah. Kɨni kafan nəsimien ramor kwənkwan rehuə. ");
INSERT INTO nwi_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kɨni rɨkin raməsɨk mɨmə, ‘?Jakhawor pən iran mɨne? Meinai kafak nimə rɨpəh nəmhenien mə to yakətu-pən kafak nəsimien aikɨn.’ ");
INSERT INTO nwi_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kɨni rarar mɨmə, ‘Rhuvə mə jakor məkneikɨn. Jakpɨk ta nimə mɨnə e mɨwhirəkɨn mɨn nimə tɨksɨn yame rehuə pɨk mɨn, mətu-pən kafak nəsimien aikɨn, mɨne kafak nautə. ");
INSERT INTO nwi_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Aikɨn, rɨkik tukraməsɨk mə kafak narɨmnar rɨpsaah rəmhen tuk newk rɨpsaah. Kɨni jakapɨs kɨn norien narɨmnar, məvɨgɨn, mamnɨm, mamərɨg əmə nagienien mamvən.’ ");
INSERT INTO nwi_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mərɨg Kughen rɨni-pən tukun mɨmə, ‘!Ik nakeno-eno! Taktəkun əmə, tuk yenpɨg, nakmhə. ?Kɨni rhawor ye kafam narɨmnar e yame nɨmnəwhai kəji?’ ");
INSERT INTO nwi_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Kughen tukror məknakɨn kɨmi narmamə yamə mɨne kasəwhai kəji nautə rɨpsaah mə kapəriə əmə, mərɨg rɨkiriə rɨpəh nəsɨk-pɨkien norien huvə yamə mɨne Kughen rorkeikei.” ");
INSERT INTO nwi_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kɨni Yesu rɨmɨni-pən tuk kafan narmamə mɨnə mɨmə, “Tuk nar a, yakamni-pre tuk əmiə mə, takhapəh nɨsətərɨg-pɨkien tuk nɨmraghien kapəmiə mə taksən naha. Kɨni takhapəh nɨsətərɨg-pɨkien tuk narɨmnar kape nɨpraimiə mə ‘?Yakwəseinein mə jakhawəhsi-pən naha?’ ");
INSERT INTO nwi_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Takhapəh nɨsətərɨg-pɨkien tuk narɨmnar mɨnə e, meinai nɨmraghien kapəmiə rapita nəvɨgɨnien, kɨni nɨpraimiə rapita neipən. ");
INSERT INTO nwi_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Səm-ru man mɨnə. Khapəh nɨsəsimien, mhapəh nɨsarhakɨnien nəvɨgɨnien, mhapəh nɨsətu-yen nəriə nəvɨgɨnien ye nəkwai nimə. Mərɨg Kughen raməvɨgɨn əriə. !Mərɨg Kughen rorkeikei pɨk əmiə rapita yame rorkeikei man mɨnə! ");
INSERT INTO nwi_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","?Tukmə nakətərɨg pɨk tuk nɨmraghien apomh kafam, nakɨrkun mə to rasitu iram nakarə mɨn rəpomh uə? !Nɨkam! Norien kape nətərɨg-pɨkien to rɨpəh nəsɨk-əpnis-pən-ien aoa kɨrikianə ye nɨmraghien kapəmiə. ");
INSERT INTO nwi_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","?Mərɨg tukmə nakseinein norien nar kəskəh a, mərɨg rhawor e nakasətərɨg pɨk tuk narɨmnar pɨsɨn pɨsɨn ye nɨmraghien kapəmiə? ");
INSERT INTO nwi_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Rɨkimiə tukraməsɨk jihi nai yamə mɨne kamhavus. Iriə khapəh nɨsorien wok, mhapəh nhajirien kapəriə neipən. Mərɨg yakamni-pre tuk əmiə mə King Solomon kupən, kafan nautə rehuə pawk, kafan neipən rhuvə pawk, mərɨg rɨpəh nɨhuvə-pɨkien mapita jihi nai mɨnə a. ");
INSERT INTO nwi_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jihi nai mɨnə a kashaktə tuk nɨpɨg kwakwə əmə, kəni rɨkwamer kɨn, kɨvaan əriə ye nap. Mərɨg Kughen ramor əriə kamhavən ye neipən huvə. ?Mərɨg kɨmiə nakharkun mə Kughen tukrɨvəhsi-pre neipən kɨmi əmiə uə nɨkam? !Ǝwəh! Kafak narmamə mɨnə. Kapəmiə nhatətəyen in rəkəskəh əmə. ");
INSERT INTO nwi_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Rɨpəh nɨhuvəyen mə rɨkimiə tukrɨvən pɨk tuk nəvɨgɨnien mɨne nɨnɨmien. Takhapəh nɨsətərɨg-pɨkien tukun, ");
INSERT INTO nwi_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","meinai narmamə yamə mɨne khapəh nɨshatətəyen ye Kughen, rɨkiriə ramvən tuk narɨmnar mɨnə a. Mərɨg Rɨmɨmiə rɨrkun narɨmnar yamə mɨne takamhavəh tuk nɨmraghien kapəmiə. ");
INSERT INTO nwi_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mərɨg taksor mə narmaruyen kape Kughen, pəh in tukrərer əkupən ye nɨmraghien kapəmiə, kɨni Kughen tukrɨvəhsi-pre narɨmnar kape nɨmraghien e ye tokrei tanə kɨmi əmiə. ");
INSERT INTO nwi_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kɨmiə e sipsip mɨnə kafak, kɨmiə kwatɨksɨn əmə, mərɨg takhapəh nhagɨnien meinai Rɨmɨmiə rɨkin ragien pɨk mə In tukramarmaru irəmiə, mamarha huvə tuk əmiə. Kɨni kɨmiə mɨn taksarmaru kɨmiə min. ");
INSERT INTO nwi_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Taksor salem kɨn kapəmiə narɨmnar, mhavəhsi-pən mane iran kɨmi yavən has mɨnə. Tukmə naksor məknakɨn, rəmhen mə naksor nɨtɨp kapəmiə yame to rɨpəh nɨmətɨtien tuk nɨpɨg kɨrik. Mɨsərəhu-pən nətərɨgien kapəmiə ye narɨmnar yame rhuvə apa ye rao ye neai. Kɨni ikɨn aikɨn a, to yəkrəh mɨnə khapəh nhavən-pakəyen ikɨn, kɨni to ɨvn mɨnə khapəh nɨsəsien narɨmnar aikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yakamni məkneikɨn meinai, ikɨn pukhaa kapəmiə narɨmnar huvə mɨnə kamhaswin ikɨn, rɨkimiə tukrɨvən ikɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Kɨni Yesu rɨmə, “Takasərer matuk nɨpɨg mɨfam, rəmhen kɨn yame nakamhawəhsi-pən neipən mɨnə kape wok, uə rəmhen kɨn yame nakasarha huvə tuk kapəmiə laet mɨnə mə tukamhauək ye nɨpɨg mɨfam. ");
INSERT INTO nwi_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Takasəkeikei mɨsəmhen kɨn yorwok mɨnə kape yemehuə kɨrik yame ramsɨ-pən ye lafet kape mared yame kɨmnor pə pə əmə. Tukmə rɨrerɨg-pən iman yerkwanu, məsɨk-əsɨk tapɨg, taktəkun əmə kafan yorwok mɨnə tuksəhitə ye tapɨg mhamə tukruə imə. ");
INSERT INTO nwi_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Yorwok mɨnə kafan yamə mɨne kasarha masərer matuk ye nɨpɨg yame yamehuə kapəriə ramuə, iriə tuksərɨg huvə. Nəfrakɨsien, yakamni tuk əmiə mə, yamehuə a in tukreiwaiyu mɨvəhsi-pən neipən kape yorwok əmə kɨrik, mokrən kɨn əriə mə tukhauə mɨsəkwətə, kɨni in rarha huvə tuk əriə maməvɨgɨn əriə rəmhen kɨn mə in yorwok kapəriə. ");
INSERT INTO nwi_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kɨni tukmə yamehuə ramuə pawk yenpɨg, uə ye kwəsum-nɨraanien, mərɨg yorwok mɨnə kafan kasərer matuk əmə, kɨni in tukror huvə-pən pɨk kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Kɨni kɨmiə takasəkeikei mharkun mə, tukmə yermamə kɨrik rɨrkun nɨpɨg atuatuk yame yəkrəh tukruə ye kafan nimə mə tukrəkrəh, kɨni in to rɨpəh napɨrien, mərɨg tukramərer matuk mamarha huvə tuk kafan nimə mə yəkrəh tukrɨpəh nɨvənien imə. ");
INSERT INTO nwi_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kɨni kɨmiə, nɨpɨg mɨ-fam, takasəkeikei mɨsərer matuk meinai Yo, Ji Yermamə, jakrerɨg pə mɨn ye nɨpɨg yame kɨmiə nakseinein.” ");
INSERT INTO nwi_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Kɨni Pita rɨmɨni-pən tukun mɨmə, “Yermaru. ?Nakamni-pə nuhpɨkɨnien e kapəmawə əmə, uə kape narmamə mɨ-fam?” ");
INSERT INTO nwi_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kɨni Yesu Yermaru rɨmə, “?Pa e yorwok yame rɨrkun nar, kɨni mamor kafan wok ye nɨpɨg m-fam ye norien yame rhuvə? ?Kɨni yemehuə kɨrik to rɨvəh-si haktə pa nhagɨn mə in tukrameihuə ye yorwok mɨnə kafan, mɨvəh-si-pən kapəriə nərokien, in e nəriə nəvɨgɨnien? ");
INSERT INTO nwi_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ǝwəh. Nɨpɨg yemehuə kape kwən a ramtərhav-pə, kɨni məm mə in ramor huvə kafan wok, kɨni in tukror huvə-pən kɨmi yorwok a. ");
INSERT INTO nwi_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nəfrakɨsien, yakamni-pre tuk əmiə mə yemehuə in tukrɨvəhsi-haktə yorwok a mə tukruə mamehuə ye narɨmnar m-fam kafan. ");
INSERT INTO nwi_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","?Mərɨg rhawor? Tukmə ror yorwok a rɨkin tukruh mɨmə, ‘Kafak yamehuə ramor tan pən tuk nuəyen.’ Kɨni mɨrikakun mamuh yorwok mɨnə nɨpiraovɨn mɨne narman, mamvən, maməvɨgɨn, mamnɨm, mamapɨs. ?Kɨni yamehuə kafan tukrhawor? ");
INSERT INTO nwi_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Yemehuə kape kwən a tukrɨtərhav-pə tukun ye nɨpɨg kɨrik yame in to rɨpəh nɨrkunien mɨpəh nərer matukien tukun. Kɨni Yermaru tukrərəpni, mərəsɨs-ərəsɨs, marakikɨn-pən imei narmamə yamə mɨne khapəh nhaniyen nəfrakɨsien iran. ");
INSERT INTO nwi_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Yorwok a yame ruɨrkun ta nəgkiarien kape yamehuə kafan, mərɨg rɨpəh norkeikeiyen mə tukrarer matuk mamor wok mɨnə a, tukuh in, rərɨg nəmhəyen. ");
INSERT INTO nwi_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mərɨg yorwok yame rɨpəh nɨrkun-huvəyen nəgkiarien kape yamehuə, kɨni mamor narɨmnar yame rɨpəh natuatukien, yame tukraməkeikei mɨvəh narpɨnien iran, tukuh mar əmə in. Tukuh mar əmə yorwok e meinai yermamə yame Kughen rɨvəhsi-pən narɨmnar rɨpsaah kɨmin, in tukraməkeikei mor narɨmnar rɨpsaah. Kɨni yermamə yame kərəhu-pən narɨmnar rɨpsaah ye kwermɨn, tukaiyoh-pən kɨn narɨmnar rehuə tukun.” ");
INSERT INTO nwi_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Kɨni Yesu rɨmɨni mɨmə, “Yo yakwauə mə jakərəhu-pən nap ye tanɨmtanə, kɨni taktəkun ai, nap a to rɨpiuək ta; rɨkik rɨpiagien. ");
INSERT INTO nwi_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mərɨg nɨpɨg əutən kɨrik tukruə ye kafak nɨmraghien, kɨni rɨkik rəmhə tukun meriaji nɨpɨg yame tukror infamien iran. ");
INSERT INTO nwi_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","?Rɨkimiə raməsɨk mə jakərəhu əmə nəmərinuyen ye tanɨmtanə uə? !Nɨkam! Pəh nien mə yɨmauə mə jakərəhu nəmərinuyen, mərɨg yɨmauə mə jakor narmamə kasəwhai əriə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kɨni taktəkun ai, tukmə narmamə kɨrkɨrɨp yerkwanu kɨrik, kɨni tuksəwhai əriə mɨnə, kɨsisər kɨrhek kɨraru, kɨni kɨraru kawhek kɨsisər. ");
INSERT INTO nwi_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Rɨm narman tukshek nɨpɨkwarien mɨnə kapəriə; kɨni nɨpɨkwarien mɨnə tukshek rɨmriə mɨnə; kɨni nɨsɨn nɨpiraovɨn mɨnə tukshek nɨpiakwəskwəh mɨnə kapəriə; kɨni nɨpiakwəskwəh mɨnə tukshek nɨsɨnriə mɨnə; kɨni kuhu nɨpiraovɨn mɨnə tukshek yasunriə mɨnə. Kɨni yasunriə mɨnə tukshek kuhuriə mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kɨni Yesu rɨmɨni-pən tuk nukwao ehuə mɨmə, “Tukmə nakasəm napuə rərer, nakharkun mə nəhig natukrɨp. ");
INSERT INTO nwi_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kɨni tukmə nakasəm mə nuwig ravus jihin, nakharkun mə nɨpɨg kape nəpan-əpanien ruauə pakə. ");
INSERT INTO nwi_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","!Eh! !Kɨmiə nəmarpəkao has mɨnə! Kɨmiə nakhamə nakharkun pɨk nar, mharkun nɨprai nɨmtətien ye tokrei tanə mɨne ye neai, rəmhen kɨn napuə, uə jihi nai mɨnə. Mərɨg nakhapəh nharkunien nɨprai nɨmtətien e yame Kughen ramor kɨmi əmiə ai taktəkun. ");
INSERT INTO nwi_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Takasəkeikei mɨsəri-pən swatuk yame ratuatuk mə taksəri-pən. ");
INSERT INTO nwi_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tukmə yermamə kɨrik rɨmə tukrərɨp ik ye nɨmrɨ mɨrh, kɨni tukmə nakramə takwəriwək kwis mɨravən ye nɨmrɨ mɨrh, rhuvə mə takawəkeikei mwəkupən mwərəhu nəmərinuyen tuk əmiru mɨnə, tamə, rəukəkin ik mɨvən ye nɨmrɨ mɨrh. Kɨni yamehuə kape kot reighan-pən kɨn ik ye kwermɨ polis. Kɨni polis rɨrəh ik mɨvən mətapɨg əsɨgɨn ik ye kalabus. ");
INSERT INTO nwi_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kɨni yakamni-pre tuk ik mɨmə, tukmə ror məknakɨn, to nakpəh napien ye kalabus meriaji takarpɨn fam.” ");
INSERT INTO nwi_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kɨni ye nɨpɨg a, narmamə tɨksɨn kɨmnhauə mhani-pən tuk Yesu mə nəmə Galili tɨksɨn kamhauh nar mɨragh mɨnə mhamə tuksor sakrefaes kɨn kɨmi Kughen, kɨni aikɨn, mobael mɨnə kape gavman e Paelat kɨmnhauə mɨshopni əriə. ");
INSERT INTO nwi_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kɨni Yesu rɨni-pən mɨmə, “?Rhawor? ?Nakhamə ta mə nɨmhəyen skai a yame rɨmɨvəh əriə ramhajoun pən mə iriə nəmə has rapita narmamə apnapɨg mɨnə apa Galili uə? ");
INSERT INTO nwi_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nɨkam. Yakamni-pre tuk əmiə mə rɨpəh norien məknakɨn. Mərɨg tukmə nakhapəh nɨsararien ye nətərɨgien kapəmiə ye norien has mɨnə kapəmiə, kɨni kɨmiə fam takpiasəkeikei mhamə. ");
INSERT INTO nwi_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Uə jakni mɨn ye narmamə iriə m-fam 18 yamə mɨne nimə apomh a yame kamni kɨmə Saeloam rɨmamɨr mohtərəkɨn əriə, khamhə. ?Nakhamə ta mə nɨmhəyen skai yame rɨmɨvəh əriə ramhajoun-pən mə iriə kɨsahas rapita narmamə apnapɨg mɨnə apa Jerusalem uə? ");
INSERT INTO nwi_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nɨkam. Yakamni-pre tuk əmiə mə rɨpəh norien məknakɨn. Mərɨg tukmə nakhapəh nɨsararien ye nətərɨgien kapəmiə ye norien has mɨnə kapəmiə, kɨni kɨmiə fam takpiasəkeikei mhamə.” ");
INSERT INTO nwi_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kɨni Yesu rɨmoh nuhpɨkɨnien kɨrik mɨmə, “Yermamə kɨrik rɨmɨhu nai kɨrik e figtri, apa ye kafan nəsimien. Kɨni newk mɨnə tɨksɨn ruə mɨvən, kɨni kwən a ramaiyu-pən məsiəkun, məm rɨpəh nɨkuəyen. ");
INSERT INTO nwi_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kɨni mɨni-pən tuk yermamə yame ramarha tuk nəsimien mɨmə, ‘Ǝm-ru. Yɨmauə məsiəkun kwənkwai figtri e mɨwəh newk kɨsisər, mərɨg yakpəh nəmien kwənkwai nai kɨrik. Ǝrəru ta. Rɨpəh nəmhenien mə tukrərer əswasɨg kɨn nɨmoptanə ye nəsimien.’ ");
INSERT INTO nwi_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kɨni kwən yame ramarha tuk nəsimien rhorpɨn nəgkiarien mɨmə, ‘Yemasur. Pəh rɨvəh mɨn ru newk kɨrikianə, pəh jakɨkɨr-pən nɨmoptanə huvə kɨmin. ");
INSERT INTO nwi_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kɨni tukmə ramkuə ye newk aikɨn, kɨni rhuvə əmə. Mərɨg tukmə rɨpəh nɨkuəyen, pəh kərəru ta.’” ");
INSERT INTO nwi_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kɨni ye Sabat kɨrik, Yesu rɨnaməvhag kɨmi narmamə apa ye nəkwai nimə kɨrik kape nofugɨnien. ");
INSERT INTO nwi_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kɨni piraovɨn kɨrik aikɨn yame nanmɨn has rɨmnəmɨr-pən iran mɨvəh newk 18. Mor nɨmeitaan ramɨrpəvɨn ye nɨpɨg mɨfam, to rɨpəh nərer-atuatuk-ien. ");
INSERT INTO nwi_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kɨni Yesu rəm in, rokrən kɨn mə tukrərer kupən ye narmamə, mɨni-pən tukun mɨmə, “Piraovɨn. Yo yakwərɨsɨn ta kafam nəmhəyen, to rɨpəh nɨraptərəkɨn-mɨnien ik.” ");
INSERT INTO nwi_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kɨni Yesu rərəhu-pən kwermɨn mir iran, məkneikɨn rərer atuatuk mɨhuvə, kɨni maməgnəgɨn Kughen. ");
INSERT INTO nwi_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Niemhaa rhai yermamə yame ramehuə ye nimə kape nofugɨnien, meinai Yesu rɨmnor huvə pian a ye Sabat. Kɨni mɨni-pən tuk narmamə mɨnə mɨmə, “Nɨpɨg sikis kape norien wok kapəmiə. Nakharkun nhauəyen ye nɨpɨg mɨnə a pəh In ror huvə əmiə. Mərɨg ye Sabat, takhapəh nhauəyen mə In tukror huvə əmiə.” ");
INSERT INTO nwi_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kɨni Yesu Yermaru rɨni-pən tuk əriə mɨmə, “!Kɨmiə nəmarpəkao hah mɨnə. ?Kɨmiə pa nhagɨn ramrɨsɨn kafan dongki mɨne kao ye Sabat, mə tukrəsɨg mɨvən mə tukrɨnɨm nu? Mə kɨmiə m-fam naksor wok məkna. ");
INSERT INTO nwi_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kɨni ye norien əmə a in a, ratuatuk əmə mə yo jakrɨsɨn pian e ye nəmhəyen kafan, mɨvəh mɨragh in ye Sabat. Pian a, in kwənərəus kɨrik kape Ebraham, kɨni Setan rɨmɨrkwəji ətərəkɨn in kape newk 18.” ");
INSERT INTO nwi_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu raməgkiar məknei, kafan tɨkmɨr mɨnə kɨmɨsaurɨs. Kɨni narmamə mɨfam, rɨkiriə ragien tuk wok huvə yamə mɨne Yesu ramor irəriə. ");
INSERT INTO nwi_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kɨni Yesu rɨmɨni mɨmə, “?Narmaruyen kape Kughen in rəmhen kɨn naha nhagɨn? ?Jakni naha nhagɨn riumhen? ");
INSERT INTO nwi_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Narmaruyen kape Kughen in rəmhen kɨn kwənkwai mastad, kɨni yermamə kɨrik rɨmɨvəh mɨhu ye kafan nəsimien. Kɨni kwerun rhaktə mehuə, kɨni man yerpɨrɨg mɨnə kamhauə masor-pən nimairiə ye rəgrəgɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kɨni mamni mɨn mɨmə, “Jakamhajoun narmaruyen kape Kughen mɨmə riumhen naha? ");
INSERT INTO nwi_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","In rəmhen kɨn yis kɨrik yame piraovɨn kɨrik ramərap-pən ye flaoa yame kamor-pən ye besin ehuə, kɨni rher əpu fam flaoa raməsiis mamehuə.” ");
INSERT INTO nwi_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kɨni nɨpɨg Yesu rɨmnəriwək mamvən Jerusalem, maməwhag kɨmi narmamə ye taon ehuə mɨnə mɨne yerkwanu mɨnə. ");
INSERT INTO nwi_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kɨni kwən kɨrik raiyoh-pən In mɨmə, “Yermaru. ?Kughen tukrɨvəh mɨragh narmamə kwatɨksɨn əmə uə?” Kɨni Yesu rɨni-pən tuk əriə mɨmə, ");
INSERT INTO nwi_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Yakamni-pre tuk əmiə mə kɨmiə takasəkeikei mɨsarkut pɨk mhamə takhavən mɨsauru-pən ye kwəruə yame rəkəskəh, meinai narmamə khapsaah kɨsarkut mhamə tukhavən imə, mərɨg to khapəh nhavənien. ");
INSERT INTO nwi_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mərɨg tukmə Yermamə, yame kafan a nimə, tukrərer mətapɨg ye kwəruə kafan, kɨni kɨmiə yamə mɨne nakhapəh nɨsauru-pən-hanəyen ye kwəruə, takasərer iruə masəsɨk-əsɨk tapɨg mhamə, ‘Yermaru. Ǝhitə ye kwəruə tuk əmawə.’ Mərɨg əmə jakni mɨmə, ‘!Ah! Yakeinein əgkəp əmiə.’ ");
INSERT INTO nwi_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kɨni kɨmiə taksokrən mhamhə, ‘Yermaru. Kɨtawə kɨmɨsəvɨgɨn kwis. Kɨni Ik nɨmnhajoun əmawə apa iməmawə ikɨn.’ ");
INSERT INTO nwi_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mərɨg Yo jakni mɨmə, ‘Yo yakamni-pre tuk əmiə mɨmə, yakeinein əgkəp əmiə. Kɨmiə m-fam yor təvhagə has mɨnə. !Havən isok tuk Yo!’ ");
INSERT INTO nwi_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ye nɨpɨg a, kɨmiə taksəm Ebraham mɨne Aesak mɨne Jakob mɨne profet kupən mɨnə kasarə ye rao ye neai ikɨn Kughen ramarmaru ikɨn, mərɨg kɨmiə takasərer iruə, kɨni tukarak-ərhav kɨn əmiə, takasasək, mɨsokwəruə, masərɨg rahah. ");
INSERT INTO nwi_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kɨni narmamə tukhasɨ-pirə, mhasɨ-fiak, mhasɨ-prah, mhasɨ-pihiu, mhavən mɨsəkwətə mɨsəvɨgɨn ye rao ye neai yame Kughen ramarmaru ikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kɨni rhuvə mə takharkun mhamə narmamə mɨnə e kasəkupən tukpihauə mhakwasɨg, kɨni yamə mɨne kamhakwasɨg tukpihauə mɨpisəkupən.” ");
INSERT INTO nwi_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kɨni ye nɨpɨg a, Farisi mɨnə tɨksɨn kɨmnhauə mhani-pən tuk Yesu mhamə, “!Eh! Rhuvə mə takɨtərhav eikɨn e mamvən, meinai Herod rorkeikei mə tukrhopni Ik.” ");
INSERT INTO nwi_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “Herod in yor kiko iko rəmhen kɨn kuri aparu yame ramən nar mɨrə. Takhavən mhani-pən tukun mə Yo yakmə, ‘Ǝm-ru. Nɨpɨg kwakwə əmə aikɨn ramarə, yame Yo jakəko ta nanmɨn has mɨnə ye narmamə, kɨni mor huvə nɨmhəyen kape narmamə. Kɨni nɨpɨg kɨsisər ror infamien, kɨni jakərkin kafak wok.’ ");
INSERT INTO nwi_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nar apnapɨg əmə Herod rɨmə tukrhopni yo, mərɨg Yo jakaməkeikei məri-pən kafak swatuk mamvən ai taktəkun mɨne tikianakwamer mɨne tuknahu mɨvən mɨtərhav-pən Jerusalem, meinai ikɨn əmə aikɨn a kamhopni profet kape Kughen mɨnə ikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","!Aweh, nəmə Jerusalem, nəmə Jerusalem! Kɨmiə nakashopni profet mɨnə kape Kughen. Kɨni narmamə yamə mɨne Kughen rɨmnher-pre kɨn əriə tuk əmiə, nakwəsarkwhopni fam əriə kɨn kapier apɨg. Nɨpɨg rɨpsaah yakorkeikei mə jakəpkəfugɨn əmiə maməm huvə əmiə rəmhen kɨn yame man ramauu tɨni mɨnə, mərɨg kɨmiə nakasəpəh. ");
INSERT INTO nwi_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mərɨg kɨmiə nakharkun mə Kughen rɨmnəpəh əmiə. Kɨni yakamni-pre tuk əmiə mə to nakhapəh nɨsəm-mɨnien Yo mhavən mɨseriaji takhani mhamə, ‘Pəh kɨvəh-si haktə Kwən en ramuə ye nhag Yermaru.’” ");
INSERT INTO nwi_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Ye Sabat kɨrik, Yesu rɨmavən ye nəkwai nimə kape yemehuə kɨrik kape Farisi mɨnə mə tuksəvɨgɨn. Kɨni apa Yesu ramkwətə ikɨn, kwən kɨrik ramhə kɨn nəmhəyen e kəsis ramkwətə ipakə tukun. Kɨni narmamə kɨmɨsəm Yesu mə tukrhawor. ");
INSERT INTO nwi_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kɨni Yesu raiyoh-pən nəmhajoun mɨnə kape Loa kape Moses mɨne Farisi mɨnə mɨmə, “?Rhawor? ?Loa rameighan kɨn mə yermamə kɨrik rɨrkun nɨvəh-mɨraghien narmamə yamə mɨne kamhamhə kamhamragh mɨn ye Sabat uə nɨkam?” ");
INSERT INTO nwi_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mərɨg iriə khapəh nɨsəgkiarien. Kɨni Yesu rɨrap kwən a mor huvə mɨn nɨpran, mher-pən kɨn ramvən. ");
INSERT INTO nwi_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kɨni mɨni-pən tuk əriə mɨmə, “?Tukmə kɨmiə kɨrik, kafan kwajikovə, uə kafan kau rivə-ərhav pɨkɨn ye nəkwai nɨmɨr ehuə ye Sabat, kɨni tukrhawor? In tukraməkeikei mɨvən mɨrəh-sihaktə aihuaa əmə. ?Pa e irəmiə in to rɨpəh norien məkneikɨn? Rɨrkək.” ");
INSERT INTO nwi_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kɨni nəgkiarien kapəriə rɨrkək. ");
INSERT INTO nwi_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kɨni Yesu rɨmnəm narmamə tɨksɨn yame kɨmnokrən kɨn əriə tuk nəvɨgɨnien a, kɨni khauə imə mɨsorkeikei mə tuksəkwətə kupən ye narmamə, ye kwənmhaan kape nɨsiaiyen. Kɨni Yesu rɨni-pən nuhpɨkɨnien tuk əriə mɨmə, ");
INSERT INTO nwi_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Tukmə yermamə rokrən kɨn ik mə takvən tuk nəvɨgɨnien kɨrik kape narkurəkien, takpəh nɨvənien məkwətə kupən ye kwənmhaan kape nɨsiaiyen. Tamə yermamə kɨrik in yerpɨrɨg pɨk rapita ik ruə, ");
INSERT INTO nwi_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","kɨni yamehuə kape nimə tukrɨni-pre tuk ik mɨmə, ‘Ǝta. Pəh kwən e tukrəkwətə-pre ikɨn en.’ Kɨni takaurɨs meinai takaməkeikei mɨvən məkwətə yetanə, ikɨn kɨpəh nɨsiaiyen əjir ikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mərɨg tukmə yermamə kɨrik ramokrən kɨn ik mə takvən məvɨgɨn ye lafet kɨrik, kɨni rhuvə mə takvən məkwətə-pən ikɨn kɨpəh nɨsiaiyen əjir ikɨn. Tukmə ror yamehuə kape nimə tukruə mɨni-pre tuk ik mɨmə, ‘Yo kɨrik, yuvən məkwətə kupən ye narmamə, ye kwənmhaan kape nɨsiaiyen.’ Ramni-pre məkneikɨn tuk ik, mɨvəhsi-haktə nhagɨm ye nɨmrɨ narmamə mɨ-fam apa imə. ");
INSERT INTO nwi_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yakamni-pre məknai meinai yermamə yame ravəhsi-haktə atuk in mə tukreihuə, Kughen tukrɨvəhsi-əhu in. Mərɨg yermamə yame ravəhsi-əhu atuk in, Kughen tukrɨvəh-sihaktə in tukreihuə.” ");
INSERT INTO nwi_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kɨni Yesu rɨmɨni-pən tuk yemehuə kape nimə mɨmə, “Kɨni tukmə nakamor nəvɨgɨnien ehuə kɨrik yenpɨg uə yeraan, takpəh nokrənien kɨn ik mɨnə tɨksɨn, mɨne piam mɨnə, mɨne kafam kwənərəus mɨnə, mɨne narmamə yamə mɨne kapəriə nautə rehuə yame mɨne kɨsarə ipakə tuk ik. Tamə, iriə kɨsokrən mɨn kɨn ik mə takvən məvɨgɨn kɨmiə miriə, mɨsarpɨn tai nar yame nɨmnor irəriə. ");
INSERT INTO nwi_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mərɨg tukmə nɨpɨg nakmə takor lafet kɨrik, takaməkeikei mamokrən kɨn yavən has mɨnə, mɨne narmamə yamə mɨne nɨkariə rɨmhə, mɨne nɨmrɨn pɨs mɨnə, mə tukhauə nakasəvɨgɨn kwis kɨmiə miriə. ");
INSERT INTO nwi_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Iriə to khapəh nɨsarpɨn-preyen tai norien a, mərɨg Kughen tukrautə-pre kɨn kafan nɨhuvəyen kɨm ik. Kɨni ye Nɨpɨg Kwasɨg, nɨpɨg narmamə yamə mɨne kɨsatuatuk tukhamragh mɨn, kɨni Kughen tukrərok ik iran.” ");
INSERT INTO nwi_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kɨni iriə kɨrik aikɨn raməvɨgɨn, mamərɨg nəgkiarien a, kɨni mɨni-pən tuk Yesu mɨmə, “!Nar huvə kɨrik e, nɨvənien apa ye rao ye neai, ikɨn Kughen ramarmaru ikɨn, maməvɨgɨn ye lafet ehuə kafan!” ");
INSERT INTO nwi_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mərɨg Yesu rɨmɨni-pən tukun mɨmə, “Nɨpɨg kɨrik, yermamə kɨrik rɨmə tukror nəvɨgɨnien ehuə kɨrik kafan, kɨni markupɨg, mɨni-pən tuk narmamə khapsaah mə tukhauə mɨsəvɨgɨn kwis iriə min. ");
INSERT INTO nwi_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kɨni rɨnor ta nɨpɨg kape nəvɨgɨnien, mher-pən kɨn kafan kɨrik yorwok mə tukrɨvən mɨni-ərhav pən tuk narmamə yame rɨmnokrən-ta kɨn əriə mɨmə, ‘Hauə mɨsəvɨgɨn, meinai yaknor apnəpeinə ta ye nəvɨgɨnien.’ ");
INSERT INTO nwi_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Mərɨg iriə m-fam kɨmɨsəpəhs-pən, mhamə to iriə khapəh nhavənien. Kɨrik rɨmnəkupən mɨni-pən tukun mɨmə, ‘Eh. Ni-pən tuk kafam yemehuə mə to yakpəh nurəyen. Yɨmɨvəh nɨmrɨ nɨmoptanə kɨrik, kɨni jakaməkeikei mɨvən məsiəkun.’ ");
INSERT INTO nwi_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Kɨni kɨrik mɨn rɨmə, ‘Eh. Ni-pən tuk kafam yemehuə mə to yakpəh nurəyen. Yɨmɨvəh nɨmrɨ kau ten, kɨni jakaməkeikei mɨvən məm pi pom wok mɨnə kapəriə.’ ");
INSERT INTO nwi_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Kɨni kɨrik mɨn rɨmə, ‘Eh. Ni-pən tuk kafam yemehuə mə yɨmnarkurək pə pə əmə, to yakpəh nurəyen.’ ");
INSERT INTO nwi_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Kɨni yorwok rɨmauə mɨni-əsah pən tuk kafan yemehuə. Kɨni yemehuə ai rɨkin rəmhə pɨk, kɨni mɨni-pən tuk kafan yorwok mɨmə, ‘Ita. Yuvən aihuaa, apa ye swatuk mɨne ikɨn mɨnə tɨksɨn ye taon a məm yavən has mɨnə, mɨne narmamə nɨkariə rɨmhə, mɨne nɨmrɨn pɨs mɨnə, mɨne yamə mɨne nɨhuriə rahas, mɨkɨr əriə, mhauə.’ ");
INSERT INTO nwi_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kɨni in ror nar a yame yemehuə rɨmɨni-pən tukun, kɨni mɨrerɨg-pə mɨni-pən mɨmə, ‘Yemehuə. Narɨmnar fam yame nɨmɨni, yo yaknor fam. Mərɨg nəvɨgɨnien rehuə aikɨn, kɨni nimə rəmhen mɨn tuk narmamə tɨksɨn.’ ");
INSERT INTO nwi_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kɨni yemehuə rɨmɨni-pən tuk yorwok mɨmə, ‘Ita. Yuvən ye swatuk, mɨne ikɨn mɨnə fam iruə ye taon. Yuvən məkeikei kɨmi narmamə mə tukhauə imə. Nimə e kafak tukraməkeikei mukwar huvə. ");
INSERT INTO nwi_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mərɨg yakamni-pre tuk ik mə narmamə yamə mɨne yɨmnokrən kɨn əriə maməkupən, iriə to khapəh nɨsən-əsɨgəvɨnien nəvɨgɨnien kɨrik kafak.’” ");
INSERT INTO nwi_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Narmamə khapsaah pɨk kamhakwasɨg kɨn Yesu ye swatuk, kɨni In rarar mɨni-pən tuk əriə mɨmə, ");
INSERT INTO nwi_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Tukmə yermamə kɨrik rorkeikei mə tukrɨkwasɨg kɨn Yo, tukraməkeikei mɨvəh Yo yakəkupən ye kafan nɨmraghien. In tukraməkeikei morkeikei Yo rapita rɨmni mɨne nɨsɨni, mɨne kafan piraovɨn, mɨne tɨni mɨnə, mɨne piauni mɨnə, mɨne nowini mɨnə, mɨne in atuk. Tukmə rɨpəh norien məkneikɨn, in rɨpəh nəmhenien mə tukruə rəmhen kɨn kafak yermamə. ");
INSERT INTO nwi_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kɨni tukmə yermamə rɨpəh neighanien kɨn mə tukhopni in tuk nhagɨk, uə rɨpəh norien nəkwak, in rɨpəh nəmhenien mə tukruə rəmhen kɨn kafak yermamə. ");
INSERT INTO nwi_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Tukmə kɨmiə kɨrik rorkeikei mə tukrɨvhirəkɨn nimə apomh kɨrik, in tukraməkeikei mokupən məkwətə, mɨrkun huvə mane ye narɨmnar mɨnə, məm-ru mə kafan mane rəmhen uə nɨkam. ");
INSERT INTO nwi_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tamə rɨrikakun mor nuknen, meinein norien infamien iran, narmamə tuksarh iakei iran ");
INSERT INTO nwi_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","mhamə, ‘Ǝm-ru. Kwən a rɨmɨrikakun əmə kafan nimə. Mərɨg reinein norien infamien iran.’ ");
INSERT INTO nwi_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Kɨni tukmə king kɨrik, kafan mobael, iriə ten taosen əmə, tukmə rərɨg nəvsaoyen mə king pɨsɨn kɨrik mɨn yame kafan mobael mɨnə twenti taosen kamhauə mə tuksarowagɨn iriə min, kɨni in to rɨpəh nɨvən-aihuaayen ye narowagɨnien. Kwasɨg ikɨn ramvən tuk narowagɨnien, tukraməkeikei məkwətə, mɨrkun huvə mə in rɨrkun napitayen tɨkmɨr mɨnə a uə nɨkam. ");
INSERT INTO nwi_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tukmə rɨrkun mə to rɨpəh napitayen, tukraməkeikei mher-pən kɨn narmamə tɨksɨn khavən masəm kafan tɨkmɨr mɨnə tɨksɨn nɨpɨg khapəh hanə nhauəyen ipakə tukun, mɨsərəhu nəmərinuyen. ");
INSERT INTO nwi_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kɨni ye norien kɨrikianə əmə mɨn, kɨmiə takasəkeikei mɨsəkwətə mɨsəm huvə nɨmraghien kapəmiə. Tukmə yermamə kɨrik rɨpəh norkeikeiyen mə tukrəpəh narɨmnar fam kafan mɨkwasɨg kɨn Yo, in rɨpəh nəmhenien mə tukruə rəmhen kɨn kafak yermamə. ");
INSERT INTO nwi_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Nɨgar in nar huvə kɨrik. ?Kɨni mərɨg tukmə nɨgar rəhiu pɨk, tukhawor kor rhekɨn mɨn? ");
INSERT INTO nwi_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Rɨpəh nəmhenien tuk nar kɨrik. Tukarakikɨn əmə. Tukmə kɨmiə narmamə yame nɨmətɨrgɨmiə rarə, sətərɨg huvə kɨn nəgkiarien e.” ");
INSERT INTO nwi_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ye nɨpɨg a, narmamə khapsaah yamə mɨne kasərer tuk mane kape takis, mɨne yor təvhagə has khapsaah kɨmnhauə mə tuksərɨg nəgkiarien kape Yesu. ");
INSERT INTO nwi_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kɨni Farisi mɨnə mɨne nəmhajoun kape Loa kape Moses kɨmnhani hah Yesu mhamə, “Ah. Kwən a, rɨkin rorkeikei mə yor təvhagə hah mɨnə tukhavən mɨsəm, kɨni mɨsəvɨgɨn kwis.” ");
INSERT INTO nwi_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ror pən, Yesu rɨmɨni nuhpɨkɨnien kɨrik mɨmə, ");
INSERT INTO nwi_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“?Kɨmiə pa nhagɨn, kafan sipsip wan handred, kɨni kɨrikianə ramerwei, mərɨg rɨkin rapəh nəsɨkien? Tukmə kɨmiə kɨrik kafan sipsip rɨmɨrkək məknakɨn, kɨni in tukraməkeikei mɨpəh kafan naenti naen sipsip kasən mənvhirɨk masərer apa rɨpiəpiə ikɨn, kɨni in tukrɨvən marhakɨn yame rɨmnerwei meriaji məm. ");
INSERT INTO nwi_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kɨni nɨpɨg tukrəm, kɨni rɨrəhsi-haktə mərəhu-pən ye nuran, kɨni rɨkin tukragien. ");
INSERT INTO nwi_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kɨni nɨpɨg tukmə rajiərhav-pə yerkwanu, in tukraməkeikei mokrən kɨn in mɨnə tɨksɨn, mɨne narmamə yamə mɨne kasarə ipakə tukun, kɨni mɨni-pən tuk əriə mɨmə, ‘Hauə, kɨsagien kwis, meinai yɨmnəm mɨn kafak sipsip yame rɨmnerwei.’” ");
INSERT INTO nwi_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kɨni Yesu ramrɨpɨn nəgkiarien mɨmə, “Yakamni-pre tuk əmiə mə, rəmhen əmə kɨn apa ye rao ye neai. Tukmə yor təvhagə hah kɨrikianə rarar ye kafan nərɨgien mɨvən tuk Kughen, kɨni nagienien apa ye rao ye neai tuk kwən a in rehuə, rapita nagienien tuk narmamə naenti naen yamə mɨne kɨsatuatuk mhapəh nɨsorien nar has kɨrik yame tukasəkeikei mɨsarar ye nərɨgiein kapəriə tukun.” ");
INSERT INTO nwi_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kɨni Yesu rarə mɨni mɨn mɨmə, “Tukmə piraovɨn kɨrik kafan silva mane ten, kɨni kɨrik rɨrkək. ?Kɨni tukrhawor? Tukrəsiə pən ye laet mahiə marhakɨn huvə apa imə mɨvən meriaji məm. ");
INSERT INTO nwi_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kɨni nɨpɨg tukrəm mane a, in tukrokrən kɨn in mɨnə tɨksɨn mɨne narmamə yamə mɨne kɨsarə ipakə tukun, mɨni mə, ‘Hauə kɨsagien kwis, meinai yaknəm mane apa kafak yame rɨmɨrkək.’” ");
INSERT INTO nwi_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kɨni nɨpɨg Yesu rɨmnor infamien ye nɨniyen nuhpɨkɨnien, mɨni-pən tuk əriə mɨmə, “Kɨni yakorkeikei mə jakni-pre tuk əmiə mə, ye norien kɨrikianə əmə mɨn, agelo mɨnə kape Kughen kɨsagien pɨk ye nɨpɨg yor təvhagə has kɨrikianə ramarar ye kafan nərɨgien mamvən tuk Kughen.” ");
INSERT INTO nwi_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kɨni Yesu ramrɨrpɨn nəgkiarien mamni mɨmə, “Yermamə kɨrik, tɨni yerman kɨraru. ");
INSERT INTO nwi_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kɨni yame rəkəskəh iran rɨni-pən tuk rɨmriu mɨmə, ‘Rɨmɨk. Ǝwhai nautə mɨnə kafam, mɨvəhsi-pə kafak ai taktəkun.’ Kɨni rɨmriu rəwhai kafan narɨmnar mɨvəhsi-pən kɨmi əriu. ");
INSERT INTO nwi_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kɨni rapəh norien tu, tɨni yame rəkəskəh rɨrəh kafan, mɨvən, mor salem kɨn, kɨni mɨvəh mane ye nautə mɨnə a, mɨtərhav iməriə ikɨn, mɨvən ye tanə pɨsɨn kɨrik mɨn isok. Kɨni aikɨn a rɨmnoriah kafan mane ehuə ye norien yamə mɨne ravi nərɨgien kafan, mamvən mamvən. ");
INSERT INTO nwi_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kɨni nɨpɨg kafan mane rɨmɨrkək fam, nɨkumhə ehuə rɨmavən piəpiə ye tanə a. Kɨni nɨkumhə rɨnaməs mɨn kwən a; nan nəvɨgɨnien ruɨrkək. ");
INSERT INTO nwi_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kɨni rɨvən mamor wok kɨmi kwən kɨrik aikɨn, kɨni kwən a rher-pən kɨn mə tukrɨvən maməvɨgɨn kafan pukəh mɨnə. ");
INSERT INTO nwi_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kɨni nɨkumhə rɨmnəs pɨk, rɨkin rɨvən tuk nəvɨgɨnien ne pukəh mɨnə, mərɨg yermamə kɨrik rɨrkək mə to rɨwəhsi-pən nəvɨgɨnien kɨrik kɨmin. ");
INSERT INTO nwi_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kɨni rɨkin rarə mɨn, mamətərɨg mə, ‘Eh. Taktəkun ai, yorwok mɨnə kape rɨmɨk, nəriə nəvɨgɨnien rehuə rapita, mərɨg yo yakamarə ikɨn e, pəh nien mə tuktu, yakəmkərəv mɨmhə. ");
INSERT INTO nwi_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Pəh yaktərhav ikɨn e, mɨrerɨg-pən tuk rɨmɨk, kɨni mɨni-pən tukun mɨmə, “Tatə. Yo yɨmnor təvhagə has kɨmik mɨne Kughen. ");
INSERT INTO nwi_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Taktəkun ai, yakpəh nəmhenien mə takokrən kɨn yo mə narɨm e yo. Mərɨg okrən kɨn yo rəmhen əmə kɨn yo yorwok əmə kɨrik kafam.” ’ ");
INSERT INTO nwi_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kɨni rarar, meriwək, mamvən mə tukrəm kafan tatə. “Kɨni ramuə hanə isok, kafan tatə rɨmnarha-pən məm, kɨni rɨkin rehuə tukun, raiyu, mɨvən məutəru, mamagien tukun. ");
INSERT INTO nwi_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mərɨg tɨni rɨni-pən tukun mɨmə, ‘Tatə. Yo yɨmnor təvhagə has kɨmik mɨne Kughen. Taktəkun ai yakpəh nəmhenien mə takokrən kɨn yo mə narɨm e yo.’ ");
INSERT INTO nwi_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Mərɨg kafan tatə rokrən kɨn kafan yorwok mɨnə mɨni-pən tuk əriə mɨmə, ‘!Eh! Havən aihuaa mhavəh kot yame rhuvə pɨk rapita, mhauə mɨsarkaoh-pən kɨmin, kɨni mhavəh ring mhauə mhavəsi-pən ye kwermɨn. Kɨni mhavəh sandel mhauə mhavəsi-pən ye nɨhun. ");
INSERT INTO nwi_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kɨni mharəh kau e yame rəsiis-əsiis, mhauə mhauh, pəh kɨsor kwis lafet kɨn kɨtawə narɨk, ");
INSERT INTO nwi_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","meinai narɨk e, rəmhen kɨn mə ruamhə ta, mərɨg taktəkun ai in ruəmragh mɨn. In rɨmnerwei, mərɨg yaknəm mɨn in.’ Kɨni iriə kɨsor lafet. ");
INSERT INTO nwi_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Kɨni ye nɨpɨg a, tɨni yame rehuə, in apa yerki nəsimien. Kɨni ye nɨpɨg ramuə muə ipakə tuk yerkwanu, kɨni mərɨg narmamə kasəni nɨpe, masor danis. ");
INSERT INTO nwi_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kɨni rokrən kɨn yorwok kɨrik ruə maiyoh in mɨmə, ‘!Eh! ?Naha e narmamə kasor?’ ");
INSERT INTO nwi_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kɨni rɨni-pən tukun mɨmə, ‘Naorahim ruauə, kɨni kafam tatə rɨmoh kau kɨrik yame rəsiis-əsiis, meinai naurahim rɨrerɨg-pə mɨn, kɨni in rəsanɨn əmə.’ ");
INSERT INTO nwi_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Kɨni piauni yame rehuə, rɨkin rɨmhə, kɨni mɨmə, ‘To yakpəh nɨvənien imə.’ Kɨni kafan tatə rɨtərhav-pə iruə maməkeikei kɨmin mə tukrɨvən imə. ");
INSERT INTO nwi_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mərɨg rɨni-pən tuk kafan tatə mɨmə, ‘Ǝmru. Kɨmwarə newk rɨpsaah, kɨni yakamor wok ikɨn e rəmhen kɨn yorwok kɨrik kafam, kɨni mɨpəh nəsɨkien nəkwam. ?Mərɨg rhawor, tatə? Nɨmɨpəh nɨvəsi-pəyen nar kəskəh kɨrik kɨmi yo rəmhen kɨn nəni, mə jakor nəvɨgɨnien kɨrik kɨmawə yo mɨnə tɨksɨn. ");
INSERT INTO nwi_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mərɨg narɨm a yame rɨmnoriah fam kafam nautə tuk nərokien piraovɨn kape swatuk, kɨni nɨpɨg rɨrerɨg-pə yerkwanu, kɨni nakarar muh kau kɨrik yame rəsiis-əsiis mamor lafet kɨn kafan.’ ");
INSERT INTO nwi_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Kɨni kafan tatə rɨni-pən mɨmə, ‘Narɨk. Nɨpɨg m-fam kɨrau mik kwarə. Kɨni narɨmnar kafak kafam. ");
INSERT INTO nwi_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mərɨg ratuatuk əmə mə tuksor lafet e mɨsəvɨgɨn meinai naorahim e rəmhen mə ruamhə ta, mərɨg taktəkun ai in ruɨmragh mɨn. In rɨmneirwei, mərɨg taktəkun ai kwəsəm in.’” ");
INSERT INTO nwi_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nɨpɨg kɨrik, Yesu rɨni-pən tuk kafan narmamə mɨnə mɨmə, “Yermaru kɨrik, kafan nautə rɨpsaah, kɨni in mɨvəh manaja kɨrik muə yame ramehuə ye kafan yorwok mɨnə. Kɨni yorwok mɨnə tɨksɨn khauə mharuk-pən nəgkiarien has ye manaja a kɨmi yermaru mhamə, ‘!Eh! Kwən a ramoriah kafam narɨmnar.’ ");
INSERT INTO nwi_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kɨni rokrən kɨn kwən a ruə raməgkiar kɨmin mɨmə, ‘!Eh! ?Naha nəgkiarien yakərɨg kamni iram? Yakorkeikei mə takvəh fam nəgkiarien mɨnə kape wok kafam, muə, meinai taktəkun ai jakher ye-rhav kɨn ik.’ ");
INSERT INTO nwi_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Kɨni manaja a rɨmavən, mamətərɨg kɨn mɨmə, ‘Aweh. Kafak yermaru rorkeikei mə tukrher ye rhav kɨn yo, kafak wok tukrɨrkək. ?Kɨni jakhawor pən iran mɨne? Nagheek rɨpəh nəmhenien mə to yakɨkɨr nɨmoptanə mɨvəh mane iran, kɨni yakaurɨs pɨk tuk nawəyen kɨn mane tuk narmamə. ");
INSERT INTO nwi_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","!Eh! Taktəkun ai yakɨrkun naha nhagɨn yame jakor, pəh narmamə tukhakɨr yo mhavən iməriə ikɨn masarha huvə tuk yo nɨpɨg kafak yermaru tukrher ye-rhav kɨn yo.’ ");
INSERT INTO nwi_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Kɨni manaja rɨmavən mokrən kɨn narmamə yamə mɨne kasor kaon kɨmi yermaru khauə kɨrikianə kɨrikianə. Kɨni rɨni-pən tuk yermamə yame rɨmnəkupən muə mɨmə, ‘?Ik nɨmnor kaon kɨmi yermaru ye naha?’ ");
INSERT INTO nwi_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Kɨni kwən a rɨni-pən tukun mɨmə, ‘Yɨmɨpɨk dram kape nehe olif iriə m-fam wan handred.’ Kɨni yemehuə rɨni-pən tuk kwən a mɨmə, ‘In əmə e nəkwəkwə kape kaon kafam. Ǝkwətə aihuaa əmə ru, mɨrai-pən əmə fifti dram ye kafam nəkwəkwə.’ ");
INSERT INTO nwi_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Kɨni rɨni-pən mɨn tuk kwən kɨrik mɨmə, ‘?Ik nɨmnor kaon kɨn naha?’ Kɨni rɨmə, ‘Yɨmnor kaon kɨn wan taosen bag wit.’ Kɨni manaja rɨmə, ‘Vəh nəkwəkwə kape kaon kafam, kɨni mɨrai-pən əmə eit handred bag wit.’ ");
INSERT INTO nwi_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Kɨni kwasɨg ikɨn, yermaru kape manaja aperə rɨmnərɨg nəvsaoyen kɨn, marar məgnəgɨn in tuk kafan norien kape neikuəyen mə in tukrəm huvə atuk in. Norien e ramhajoun mə narmamə ye tokrei tanə, kharkun norien bisnes irəriə mɨnə, mərɨg narmamə kape nɨkakien khapəh nharkun-huvəyen norien mɨnə kape tokrei tanə. ");
INSERT INTO nwi_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Kɨni yakamni-pre tuk əmiə mə, sasitu huvə ye narmamə kɨn mane kape tokrei tanə mə iriə tukhauə kɨmiə mɨnə tɨksɨn. Kɨni nɨpɨg mane kape tokrei tanə tukrɨrkək, kɨni Kughen tukrɨvəh əmiə mɨvən apa ye rao ye neai yame ramarə kape rerɨn. ");
INSERT INTO nwi_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Tukmə yermamə yame rɨrkun narha-huvəyen tuk nar kəskəh kɨrik rɨrkun narha-huvəyen tuk nar ehuə kɨrik. Kɨni yermamə yame ramor norien yame rapəh natuatukien ye nar kəskəh kɨrik, in tukror norien yame rapəh natuatukien ye nar ehuə kɨrik. ");
INSERT INTO nwi_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","?Ror məknakɨn mə tukmə kɨmiə nakhapəh nɨsarha-huvəyen tuk mane kape tokrei tanə e, yermamə rɨrkək yame tukreighaan kɨn əmiə mə takhawəh nar huvə əfrakɨs, in e narɨmnar kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kɨni tukmə kɨmiə nakhapəh nɨsarha-huvəyen tuk narɨmnar kape yermamə mɨn kɨrik, kɨni pəh rɨkimiə tukrɨpəh nəsɨkien mə tukvəhsi-pre mɨn kɨmi əmiə kapəmiə atuk narɨmnar, meinai, kɨrkun mə takhapəh nɨsarha-huvə-mɨnien tuk narɨmnar mɨnə a. ");
INSERT INTO nwi_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Yermamə rɨkək yame to ror slef kape yemehuə mir kɨraru. To ramor məknakɨn, tukraməkeikei morkeikei kɨrik, maməməkɨn kɨrik; uə tukraməkeikei mor nəkwai kɨrik, məpəh kɨrik. To nakhapəh nɨsor-kwis-kwisien wok kɨmi Kughen mɨne tuk mane.” ");
INSERT INTO nwi_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisi mɨnə kɨsorkeikei pɨk mane, kɨni nɨpɨg kɨmɨsərɨg nəgkiarien mɨnə a, kɨni mɨsarh iakei ye Yesu. ");
INSERT INTO nwi_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mərɨg In rɨmɨni-pən tuk əriə mɨmə, “Kɨmiə nakasor norien yamə mɨne kasor narmamə rɨkiriə raməsɨk mə naksatuatuk. Mərɨg Kughen rɨrkun mə rɨkimiə rahas. Yakamni məkneikɨn meinai naha nhagɨn yame narmamə khavəh-si haktə mə in nar ehuə, mərɨg ye nɨmrɨ Kughen in nar apnapɨg əmə.” ");
INSERT INTO nwi_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Kɨni Yesu rɨmə, “Kamni-ərhav Loa mɨne nəgkiarien kape profet kape Kughen mɨnə meriaji-pə Jon Baptaes, kɨni kwasɨg ikɨn, kamni-ərhav nəvsaoyen huvə kape narmaruyen kape Kughen, kɨni narmamə m-fam kɨsarkut mə tukhavən mɨsarə aikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mərɨg kɨpəh nɨniyen kɨmə wok kape Loa mɨne nəsanɨnien kafan ruɨrkək. Nɨkam. Nəgkiarien m-fam kafan kasəmɨr- yame rehuə mɨnə meriaji-pən yame rəkəskəh əgkəp mɨnə. Loa tukrarə rerɨn rapita neai mɨne tokrei tanə. ");
INSERT INTO nwi_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Tukmə yermamə kɨrik rɨpəh kafan hanə piraovɨn, kɨni mamkɨr piraovɨn pɨsɨn kɨrik mɨn mwarə, in ramor təvhagə has. Kɨni tukmə yermamə kɨrik rɨkɨr piraovɨn kɨrik yame kafan yerman rɨmnəpəh, kɨni kwarə kwis, kɨni in ramor təvhagə has meinai in raməkrəh kɨn piraovɨn kape yermamə pɨsɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kɨni Yesu rɨmɨni mɨmə, “Kwən kɨrik, kafan nautə rehuə rɨvən ye neipən huvə mɨnə, nɨmrɨn rhaktə, kɨni nɨpɨg mɨfam ramən pɨk nəvɨgɨnien huvə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kɨni yavən has kɨrik, nhagɨn e Lasaros, nɨpran rəmhir-əmhir. Kɨni kɨrəh kavən apa ye kwəruə kape yerkwanu . ");
INSERT INTO nwi_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","In rorkeikei pɨk mə tukrən nɨsɨmsɨ nəvɨgɨnien yame raməsaah-əsaah-pən ye nəpəəg tebol kape yamehuə a. Kɨni nar kɨrik rahas mɨn, kuri mɨnə mɨn khauə masəpaih-əpaih nɨmap mɨnə kafan. ");
INSERT INTO nwi_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Kɨni yavən has a rɨmamhə, kɨni agelo mɨnə khavəh mhavən apa ye nɨkar Ebraham, kwənmhaan kape nɨsiaiyen. Kwən a kafan nautə rehuə, in mɨn rɨmamhə, kɨni kɨnɨm. ");
INSERT INTO nwi_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kɨni in rɨvən apa ye nap ehuə, mamərɨg nəmhəyen ehuə, marha-faktə, maməm Ebraham apa isok, Lasaros apa ye nɨkarɨn. ");
INSERT INTO nwi_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kɨni mokrən apomh mɨmə, ‘Tatə Ebraham. !Aweh! Pəh rɨkim tukreihuə tuk yo. Her-pən kɨn Lasaros mə tukreires kwənkwai kwermɨn ye nu kɨni mɨvəh muə mɨrap neramɨk kɨn pəh rokiei, meinai yakamərɨg nəmhəyen ehuə eikɨn e ye nap ai taktəkun.’ ");
INSERT INTO nwi_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Mərɨg Ebraham rɨmə, ‘Narɨk, rɨkim tukraməsɨk ru kafam nɨmraghien apa kupən. Ik nɨmnavəh narɨmnar huvə kafam rɨpsaah, mərɨg Lasaros rɨmnamərɨg nəmhəyen ehuə ye nɨpran. Mərɨg taktəkun ai, in ramərɨg rhuvə ikɨn e. Kɨni ik, nakamərɨg nəmhəyen ehuə ye nɨpram. ");
INSERT INTO nwi_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kɨni nar kɨrik mɨn. Ye kwerkwan irətawə, nəkwai nɨmɨr ehuə yame raməwhai ətawə. Ik en, kɨni kɨmawə e. Tukmə kɨmawə kɨrik rɨmə tukrurə məm əmiə, mərɨg to rɨpəh nurəyen. Kɨni tukmə kɨmiə kɨrik rɨmə tukruə məm əmawə, mərɨg to rɨpəh nuəyen.’ ");
INSERT INTO nwi_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Kɨni yermamə yame kafan nautə rehuə rɨmɨni mɨmə, ‘Tatə. Yakaməkeikei kɨmik. !Aweh! Her-pən kɨn Lasaros rɨvən ye nimə kape kafak tatə ");
INSERT INTO nwi_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","meinai piak kɨrkɨrɨp aikɨn. Rhuvə mə in tukrɨvən mor kwirɨg kɨmi əriə pəh tukasərɨg əriə mə tukhapəh nhauə-mɨnien ikɨn yakamərɨg pɨk nəmhəyen ikɨn.’ ");
INSERT INTO nwi_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Mərɨg Ebraham rɨmə, ‘Nɨkam. Iriə kharkun nɨsəvheikɨnien Nəkwəkwə kape Moses mɨne profet kupən mɨnə kape Kughen. Pəh piam mɨnə tuksərɨg nəgkiarien mɨnə a.’ ");
INSERT INTO nwi_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Kɨni yermamə yame kafan nautə rehuə ramni mɨmə, ‘Nɨkam, Tatə Ebraham. Rɨpəh nəmhenien. Mərɨg tukmə yemə mhə kɨrik rɨrerɨg-pən mɨni əsaah pən tuk əriə, iriə tuksarar ye nərɨgien kapəriə, mɨsəpəh norien has mɨnə kapəriə.’ ");
INSERT INTO nwi_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Mərɨg Ebraham rɨmə, ‘Tukmə khapəh nɨsərɨgien nəgkiarien kape Moses mɨne profet mɨnə kape Kughen, kɨni in nar apnapɨg tukmə kwən kɨrik ramragh mɨn ye nɨmhəyen kafan, kɨni mɨvən məgkiar kɨmi əriə, mərɨg tukhapəh nhaniyen nəfrakɨsien iran.’” ");
INSERT INTO nwi_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kɨni Yesu rɨni-pən tuk kafan narmamə mɨnə mɨmə, “Nəfrakɨsien. Nɨvəhsipən-vəhsipənien kape təvhagə has yamə mɨne kamhavi-pən narmamə ye nahasien, iriə tukhauə. Mərɨg narpɨnien ehuə ramvən tuk yermamə yame ravəhsi-pən vəh-sipən kɨmi narmamə, uə yame in swatuk kape nɨwəhsi-pən wəhsi-pənien. ");
INSERT INTO nwi_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mərɨg tukmə yermamə kɨrik ravi-pən kwajikovə kɨrik yame rhatətə irak, mə tukror təvhagə has, kɨni yermamə a, Kughen tukror narpɨnien ehuə kɨmin. Kɨni narpɨnien a tukrɨskai rapita yame kɨruk-pən kapier pam kɨrik ye nɨpətək nuan, karkw-ərhav-pən kɨn ye tame tahik mə tukrəmnɨm. ");
INSERT INTO nwi_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kɨni ror məkneikɨn mə takasəkeikei masarha huvə tuk kapəmiə nɨmraghien.” Kɨni Yesu rɨmə, “Kɨni tukmə piam ramor təvhagə has kɨmik, ni-pən kafan norien has ye nɨmrɨn, kɨni tukmə ramarar ye kafan nərɨgien, kɨni əru kɨn kafan norien has mɨpəh nɨvəh-tɨmtɨmien yerkim. ");
INSERT INTO nwi_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kɨni nar apnapɨg in ramor təvhagə has kɨmik m-seven ye nɨpɨg kɨrikianə, kɨni muə m-seven mɨni-pre tuk ik mɨmə, ‘Kəsi. Yɨmnor təvhagə has kɨmik. Jakarar ye kafak nərɨgien mɨpəh kafak təvhagə has,’ kɨni ik takaməkeikei mərukɨn kafan norien has mɨnə, kɨni mɨpəh nɨwəh-tɨm-tɨmien yerkim.” ");
INSERT INTO nwi_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kɨni aposol mɨnə kɨmɨsaiyoh Yesu Yermaru mhamə, “Or kapəmawə nhatətəyen rɨskai məmhen mɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kɨni Yesu Yermaru rɨmə, “To nhatətəyen kapəmiə rɨkəskəh pawk rəmhen kɨn kwənkwai mastad, mərɨg nakharkun nhani-pənien tuk tukwas e mə, ‘Ǝvi atuk ik, kɨni mɨvən mɨviə pən apa ye tahik,’ kɨni tukror nəkwaimiə.” ");
INSERT INTO nwi_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kɨni Yesu rɨmə, “Hani-ru. ?Tukmə yermamə kɨrik, kafan yorwok ramasim, uə ramarha tuk sipsip mɨnə, kɨni mɨrerɨg-pə yerkwanu, kɨni rɨkimiə raməsɨk mə yamehuə kafan tukrɨni pən tukun mɨmə, ‘!Eh! Yuə aihuaa məkwətə mən nəvɨgɨnien a.’? !Nɨkam! ");
INSERT INTO nwi_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mərɨg in tukrɨni-pən tuk kafan yorwok mɨmə, ‘Yuvən mor nak nəvɨgɨnien, kɨn yuvən mɨwəhsi-pən kafam neipən huvə, kɨni mɨwəhsi-pə nak nəvɨgɨnien mɨne nik nɨnɨmien. Nɨpɨg nɨmnor fam kafam wok, nakɨrkun nɨvənien məvɨgɨn mɨnɨm.’ ");
INSERT INTO nwi_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","?Kɨni rɨkimiə raməsɨk mə yemehuə, in tukrɨni-pən tenkiu kɨmi kafan yorwok tuk wok ehuə kafan yame in tukraməkeikei mor uə nɨkam? !Nɨkam! ");
INSERT INTO nwi_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kɨni kɨmiə en, naksəmhen əmə kɨn yorwok mɨnə kape Kughen. Nɨpɨg nɨmɨsor fam narɨmnar yame Kughen rɨmɨni-pre tuk əmiə mə takasəkeikei mɨsor, takasəkeikei mhani əmə mhamə, ‘Kɨmawə yor wok mɨnə əmə. Rɨpəh nəmhenien mə tukni vi vi əmawə. Yakasor əmə wok yame kɨmawə jakasəkeikei masor.’” ");
INSERT INTO nwi_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nɨpɨg Yesu rɨmneriwək mamvən Jerusalem, In rɨmavən-pən ye kwerkwan ye provins mir e Sameria mɨne Galili. ");
INSERT INTO nwi_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kɨni nɨpɨg rɨmatərhav-pən ye yerkwanu kɨrik, narmamə ten yamə mɨne kamhavəh nəmhəyen e leprosi kɨmnhauə mɨsərer isok kwənmopɨn, ");
INSERT INTO nwi_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","kɨni mɨsokrən kɨn In mhamə, “!Yesu Yermaru! !Pəh rɨkim tukreihuə tuk əmawə!” ");
INSERT INTO nwi_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kɨni nɨpɨg Yesu rɨmnəm əriə, mɨni-pən tuk əriə mɨmə, “Havən, mɨsəm pris, pəh in tukrəm nɨpraimiə.” Kɨni nɨpɨg kɨmɨseriwək ye swatuk, kɨni mhahuvə, nəmhəyen a rɨrkək irəriə. ");
INSERT INTO nwi_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kɨni iriə kɨrik rəm mə leprosi kafan rɨrkək. Kɨni rarar mɨrerɨg-pən tuk Yesu mamokrən apomh mɨmə, “!Yakamni vi vi Kughen! !Yakamni vi vi Kughen!” ");
INSERT INTO nwi_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kɨni in rɨmneiwaiyu mənɨmkur-pən ye nɨhu Yesu, mɨni vi vi In tuk nor-huvəyen kafan nəmhəyen. Kwən a in yemə Sameria. ");
INSERT INTO nwi_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kɨni Yesu rɨmɨni mə, “?Nəfrakɨsien mə yɨmnor huvə narmamə ten maikwas ta ye kapəriə nəmhəyen, uə nɨkam? ?Mərɨg naen hiə? ");
INSERT INTO nwi_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kwən a in yepsɨpɨs əmə, mərɨg in pɨsɨn əmə rɨmɨrerɨg-pə mamni vi vi Kughen.” ");
INSERT INTO nwi_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kɨni Yesu rɨnɨ-pən tuk kwən a mə, “Ǝrer meriwək mamvən. Kafam nhatətəyen rɨmnor huvə ik.” ");
INSERT INTO nwi_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nɨpɨg kɨrik, Farisi mɨnə kɨmɨsaiyoh-pən Yesu mhamə, “Tuk nagheen narmaruyen kape Kughen ruə?” Kɨni In rɨni-pən tuk əriə mɨmə, “To narmamə khapəh nɨsəmien Narmaruyen kape Kughen yame ramuə kɨn nɨmrɨriə. ");
INSERT INTO nwi_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kɨni yermamə kɨrik rɨrkək yame tukrɨni mə, ‘Hauə-ru mɨsəm, in apa,’ uə ‘Hauə mɨsəm. In apa.’ Meinai narmaruyen kape Kughen ruauə ta maməmɨr yerkimiə.” ");
INSERT INTO nwi_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kɨni Yesu rɨni-pən tuk kafan narmamə mɨnə mɨmə, “Nɨpɨg mɨnə kɨmnhauə yame naksorkeikei mhamə taksəm nɨpɨg mɨnə kape Ji Yermamə, mərɨg to nakhapəh nɨsəmien. ");
INSERT INTO nwi_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kɨni narmamə tukhani-pre tuk əmiə mhamə, ‘!Hauə-ru mɨsəm, in apa!’ uə ‘Hauə, in apa!’ Mərɨg takhapəh nhakwasɨgien kɨn əriə, ");
INSERT INTO nwi_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","meinai ye nɨpɨg Yo, Ji Yermamə, jakurə iran, in tukrəmhen əmə kɨn naroapɨgien yame raməsiə ye neai ye nɨkarɨn kɨrik muə meriaji-pən nɨkarɨn kɨrik mɨn. Kɨni narmamə m-fam tuksəm mharkun. ");
INSERT INTO nwi_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mərɨg kwasɨg ikɨn ye narɨmnar mɨnə a, jakaməkeikei mamərɨg nəmhəyen ehuə, kɨni narmamə yamə mɨne kɨsarə ai taktəkun, kamhaukreikɨn-pə nɨmeitairiə masəpəh Yo. ");
INSERT INTO nwi_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ye nɨpɨg Yo, Ji Yermamə, jakuə iran, tukrəmhen əmə kɨn narəyen kupən ye nɨpɨg kape Noa. ");
INSERT INTO nwi_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ye nɨpɨg a, narmamə kasəvɨgɨn, mamhanɨm, masor nəvɨgɨnien kape narkurəkien, in e narɨmnar m-fam kasor ye nɨmraghien kapəriə, mɨseriaji-pə ye nɨpɨg yame Noa ruavən imə ye nəpəəg nəkwai rao ehuə kafan. Kɨni nəhig rɨmap, yapiwən ehuə rɨmauə maiyu makatənɨm fam kɨn narmamə yamə mɨne khapəh nhavənien ye nəkwai rao. ");
INSERT INTO nwi_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“In rəmhen əmə mɨn kɨn narəyen kupən ye nɨpɨg kape Lot. Narmamə kɨmnasəvɨgɨn, mhanɨm, masor salem kɨn narɨmnar, mamhawəh nɨmrɨ narɨmnar, masəsim, mhavhirəkɨn nimə mɨnə, in e narɨmnar fam kɨmɨsor ye nɨmraghien kapəriə. ");
INSERT INTO nwi_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mərɨg ye nɨpɨg yame Lot rɨmatərhav-pən ye taon a Sodom, kɨni nap mɨne kapier yame kamhawək mhasɨ-faktə ye neai masəkwəpni əriə m-fam apa ye taon. ");
INSERT INTO nwi_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Kɨni rəmhen əmə kɨn nɨpɨg Yo Ji Yermamə jakuə mɨn iran. Kɨni Kughen tukror əpu Yo kɨmi narmamə. ");
INSERT INTO nwi_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ye nɨpɨg a, tukmə yermamə kɨrik ramkwətə iruə ye kafan nimə, pəh in tukrap mɨpəh nɨvən-mɨnien a ye nimə mə tukrɨpɨk kafan narɨmnar. Kɨni tukmə yermamə kɨrik apa ye kafan nəsimien, pəh in tukrap, mɨpəh nuə-mɨnien ye yerkwanu. ");
INSERT INTO nwi_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","!Takhapəh nɨsəru-kɨnien piahwaru kape Lot! ");
INSERT INTO nwi_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yermamə yame rorkeikei mə in tukramraptərəkɨn kafan nɨmraghien ye tokrei tanə e, mɨpəh nɨkwasɨgien kɨn Yo, in tukrɨpəh nɨ-wəhyen nɨmraghien rerɨn. Mərɨg yermamə yame raməpəh narɨmnar kape nɨmraghien kape tokrei tanə e, mɨkwasɨg kɨn Yo, in tukrɨvəh nɨmraghien rerɨn. ");
INSERT INTO nwi_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Yakamni-pre tuk əmiə mə, ye nɨpɨg a, yenpɨg, yermamə kɨraru tukawapɨr ye bed kɨrikianə əmə, kɨni jakvəhsi-ta kɨrikianə, mɨpəh kɨrikianə. ");
INSERT INTO nwi_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kɨni piraovɨn kɨraru tukawor nəvɨgɨnien, kɨni jakvəhsi-ta kɨrikianə, mɨpəh kɨrikianə. ");
INSERT INTO nwi_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Yerman kɨraru tukawasim, kɨni jakrəhsi-ta kɨrik, mɨpəh kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kɨni kafan narmamə mɨnə kɨmnhani-pən tukun mhamə, “Yermaru, takɨtərhav-pə hiə?” Kɨni In rɨmɨni-pən tuk əriə mɨmə, “Takharkun əmə. Rəmhen kɨn nɨpɨg ligkai mɨnə kamhaivə yerpɨrɨg mɨseiwaiyu masərɨp tahik, nakharkun mə kəməəm mɨnə apaikɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kɨni Yesu rɨmɨni nuhpɨkɨnien kɨmi əriə maməvhag kɨn kɨmi əriə mə tukasəkeikei masəhuak nɨpɨg mɨfam mhapəh nɨsəpəhyen, mhapəh nɨsorien mə rɨkiriə tukreiwaiyu. ");
INSERT INTO nwi_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","In rɨmɨni mɨmə, “Yerkwanu kɨrik, yeni kɨrik aikɨn kape nərəhuyen nəgkiarien mɨnə. Kɨni rɨpəh nɨsiaiyen Kughen, kɨni mɨpəh nɨsiai-mɨnien narmamə. ");
INSERT INTO nwi_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kɨni ye yerkwanu a, piraovɨn kɨrik kɨmnamhə tan kɨn aikɨn, kɨni nɨpɨg mɨfam ramuə mamaiyoh yeni a mɨni-pən tukun mɨmə, ‘Aweh. Asitu irak mərəhu atuatuk nahasien yame kafak tɨkmɨr ramor irak.’ ");
INSERT INTO nwi_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mərɨg yeni a ramor pɨk tan pən tuk nəgkiarien mə tukror huvə aihuaa nahasien kape pian a. Mərɨg pian a rɨmnaiyoh-pən kwən a ye nɨpɨg mɨfam. Kɨni yeni a ramətərɨg mɨmə, ‘Nar apnapɨg mə yakpəh nɨsiaiyen Kughen, mɨpəh nɨsiai-mɨnien narmamə, ");
INSERT INTO nwi_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","mərɨg jakaməkeikei mɨvən mərəhu atuatuk kafan nahasien kɨni mərəhu nɨhuvəyen. Meinai pian a ramni nar kɨrikianə mamərɨk mɨtə yo tuk kafan nəgkiarien mamrɨpɨn. Kɨni tukmə yakamor tan pən tukun, kɨni in tukruə mamokrən-okrən kɨn yo, kɨni yakəpkəs kɨn.’” ");
INSERT INTO nwi_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kɨni Yesu Yermaru ramrɨpɨn nəgkiarien mɨmə, “Sətərɨg kɨn Yo. Nəgkiarien kape yeni apa rahas pɨk. ");
INSERT INTO nwi_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","?Mərɨg rhawor ye Kughen? In rɨmɨrpen kafan narmamə mɨnə, kɨni iriə kɨsasək ətgɨn In nɨpɨg mɨ-fam yenpɨg-enpɨg mɨnə mɨne yenpɨg mɨnə fam. ?Kɨni rɨkimiə raməsɨk mə In tukrɨni-pən tuk əriə mɨmə, ‘Takhawhin pi pom’? Nɨkam. ?Kɨmiə nakhamə ta mə In ramor tan pən tuk nasituyen ye kafan mɨnə uə? Nɨkam. ");
INSERT INTO nwi_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yakamni-pre tuk əmiə mə nəfrakɨsien, In tukrasitu aihuaa əmə ye kafan mɨnə, kɨni mərəhu atuatuk nahasien yame ramuə tuk əriə. ?Mərɨg nɨpɨg Yo, Ji Yermamə, jakrerɨg-pə mɨn iran ye tokrei tanə, jakəm mə narmamə tɨksɨn aikɨn yamə mɨne kɨshatətə ye Kughen uə kharkək?” ");
INSERT INTO nwi_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kɨni Yesu rɨmɨni nuhpɨkɨnien kɨrik kɨn narmamə tɨksɨn yamə mɨne khamə ta mə kɨsatuatuk rapita narmamə mɨnə tɨksɨn, masəm-əhu narmamə mɨnə fam. ");
INSERT INTO nwi_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","In rɨmɨni mɨmə, “Kwərə mir kɨraru kɨmɨravən apa ye Nimə Ehuə kape Kughen mə tukwəhuak. Kɨrik, in Farisi. Kɨni kɨrik in ramərer tuk mane kape takis. ");
INSERT INTO nwi_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Kɨni Farisi ramərer mamsɨgəvɨn nəhuakien, maməgkiar atuatuk iran mɨmə, ‘Kughen, yakamni vi vi Ik meinai yakor pɨsɨn ye narmamə apnapɨg mɨnə, yamə mɨne kɨsorkeikei pɨk mane, maseikuə mə tuksəkrəh kɨn, masor rahas, mɨsəkrəh kɨn piraovɨn kape yermamə pɨsɨn. Kɨni yo yakpəh norien rəmhen kɨn kwən e yame ramərer tuk mane kape takis. ");
INSERT INTO nwi_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nɨpɨg kɨraru ye wik kɨrikianə, yo yakamatuakəm maməpəh nəvɨgɨnien tuk nəhuakien. Kɨni tukmə yakvəh narɨmnar ten, yakvəhsi-pre kɨrikianə.’ ");
INSERT INTO nwi_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Mərɨg kwən a yame ramərer tuk mane kape takis, in ramərer isok, kɨni mamaurɨs, mɨpəh narha-faktəyen ye neai maməhuak. Kɨni rɨkin rarkwopɨr, mamasək, mamərɨp nɨmagen mɨmə, ‘Kughen. Yo yemə has. !Pəh rɨkim tukreihuə tuk yo!’” ");
INSERT INTO nwi_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kɨni Yesu ramrɨpɨn nəgkiarien mɨmə, “Yakamni-pre tuk əmiə mə nɨpɨg kwərə mir e tukrarerɨg-pən yerkwanu, yermamə yame ramərer tuk mane kape takis, Kughen tukrəm mə kafan nɨmraghien in ratuatuk. Mərɨg Farisi rapəh natuatukien, meinai yermamə yame ravəh-si haktə atuk in, Kughen tukrɨvəh-si əhu; mərɨg yermamə yame ravəhsi-əhu atuk in, Kughen tukrɨvəh-si haktə.” ");
INSERT INTO nwi_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kɨni narmamə tɨksɨn kɨmnhapɨk kapəriə kwajikovə əmtəmtə mɨnə mhavən masəm Yesu mə In tukrərəhu-pən kwermɨn irəriə, mɨvəhsi-pən nɨhuvəyen kɨmi əriə. Mərɨg narmamə mɨnə kape Yesu kɨmnhani-əhu əriə. ");
INSERT INTO nwi_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mərɨg Yesu rɨmnokrən kɨn kwajikovə mɨnə mə tukhavən ipakə tukun. Kɨni mɨmə, “Takhapəh nhani-əhuyen kwajikovə mɨnə. Səta irəriə pəh khauə tuk Yo. Meinai Kughen tukramarmaru ye narmamə yamə mɨne kɨsəmhen kɨn kwajikovə mɨnə e. ");
INSERT INTO nwi_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yakamni əfrakɨs tuk əmiə mə yermamə yame rɨkin rɨpəh nagienien tuk nɨvəhyen kafan nərɨgien reiwaiyu rəmhen kɨn kwajikovə, to rɨpəh nɨvənien ye Rao ye Neai.” ");
INSERT INTO nwi_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kɨni yemehuə kɨrik ruə mɨni-pən tuk Yesu mɨmə, “Yhajoun huvə. ?Nakmə jakaməkeikei mor naha mamarə rerɨn?” ");
INSERT INTO nwi_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Kɨni Yesu rɨmə, “?Nakhawor mamni mə Yo yakhuvə? Yermamə kɨrik rapəh nɨhuvəyen. Kughen əmə In rhuvə. ");
INSERT INTO nwi_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ik nakwɨrkun ta loa yame Moses rɨmɨni mɨmə, ‘Takpəh nhopniyen yermamə. Kɨni mɨpəh napɨrpən-apnapɨg-ien tuk piraovɨn pɨsɨn. Kɨni mɨpəh nəkrəhyen. Kɨni mɨpəh nɨni-apnapɨgien nar meikuə kɨn ye yermamə kɨrik. Tuk nɨpɨg mɨnə fam takamsiai rɨmɨm mɨne nɨsɨnɨm.’” ");
INSERT INTO nwi_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kɨni kwən ai rɨni-pən tukun mɨmə, “Yhajoun. Loa mɨnə en, yakaməri-pən fam ye nəkəskəhyen kafak, muə meriaji-pə.” ");
INSERT INTO nwi_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kɨni Yesu rɨmnərɨg nəgkiarien a, mɨni-pən tuk kwən a mɨmə, “Nar kɨrikianə əmə ik nakpəh nor-hanəyen. Takvən, məvrai rik rik fam kafam narɨmnar, mɨvəh mane iran, kɨni mɨvəhsi-pən kɨmi yavən has mɨnə. Kɨni kafam narɨmnar tukrɨpsaah apa ye neai. Kɨni ik muə, mɨkwasɨg kɨn Yo.” ");
INSERT INTO nwi_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nɨpɨg kwən ai rɨmnərɨg nəgkiarien yame Yesu rɨmɨni, rɨkin rəpou, meinai kafan nautə rɨpsaah. ");
INSERT INTO nwi_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Kɨni Yesu rarha-pən mɨni-pən tukun mɨmə, “!Man! Rɨskai pɨk tuk narmamə yamə mɨne kapəriə nautə rehuə tuk nɨvənien pəh Kughen rarmaru irəriə. ");
INSERT INTO nwi_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","?Nakhamə ta mə narmɨragh ehuə kɨrik, kamni kɨmə kamel, to rauru-pən ye kwəruwei nidil uə? Nɨkam, rəutən pɨk. Rəmhen əmə mɨn kɨn yermamə yame kafan nautə rehuə, rəutən pɨk tukun tuk nətayen aikɨn a muə Kughen ramarmaru iran.” ");
INSERT INTO nwi_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Kɨni narmamə yamə mɨne kɨmɨsərɨg nəgkiarien yame Yesu rɨmɨni kɨnasaiyoh əriə mɨnə, mhamə, “!Eh! ?Mərɨg tukmə ror məknekɨn, kɨtawə pa in tukramarə ye nɨmraghien rerɨn?” ");
INSERT INTO nwi_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Mərɨg Yesu rɨmɨni mə, “Narɨmnar yame narmamə kɨseinein nɨsorien, Kughen rɨrkun norien.” ");
INSERT INTO nwi_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kɨni Pita rɨni-pən tukun mɨmə, “?Mərɨg rhawor irəmawə? Yɨməsəpəh fam kapəmawə narɨmnar, mhauə, mamhakwasɨg kɨn Ik.” ");
INSERT INTO nwi_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Kɨni Yesu rɨni-pən tukun mɨmə, “Yermamə yame in ravəh əkupən Yo, kɨni maməta ye kafan narɨmnar rəmhen kɨn nimə, uə piraovɨn, uə piauni, uə kafan kakə, uə rɨmni mɨne nɨsɨni, uə kafan kwajikovə mə tukruə ye Narmaruyen kape Kughen, ");
INSERT INTO nwi_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kɨni yermamə a, ye tokrei tanə e, tukraməkeikei mɨvəh narɨmnar rɨpsaah məknakɨn rapita narɨmnar yamə mɨne rɨmnəpəh kupən. Kɨni ye narəyen vi kafan, tukrarə ye nɨmraghien rerɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Narmamə khapsaah, kɨni Yesu rokrən kɨn kafan narmamə twelef, mɨsəkwətə karɨn, kɨni rɨni-pən tuk əriə mɨmə, “Sətərɨg ru. Taktəkun ai, tukhavən apa faktə, Jerusalem. Kɨni narɨmnar yame profet kape Kughen mɨnə kupən kɨmnhani irak, Ji Yermamə, tukhauə mɨsor nəfrakɨsien kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tukeighan-pən kɨn Yo ye kwermɨ nəmə Rom, kɨni tuksarh iakei irak, mɨsərkɨs-ərkɨs Yo, mɨsərɨg-əvhin Yo. ");
INSERT INTO nwi_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tukrəh Yo, kavən, khopni Yo. Mərɨg ye nɨpɨg yame ror kɨsisər kɨn, jakamragh mɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mərɨg narmamə twelef kafan kɨmnhapəh nharkunien nɨprai nəgkiarien kafan, meinai Kughen rɨmnerkwaig kɨn nɨprai narɨmnar mɨnə a, kɨni kɨmnhapəh nharkunien mə raməgkiar ye naha. ");
INSERT INTO nwi_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nɨpɨg Yesu ramuə ipakə tuk taon a Jeriko, nɨmrɨn pɨs kɨrik aikɨn ramkwətə ye nɨkar swatuk. Nɨpɨg mɨ-fam in ramawə-pən kɨn mane kɨmi narmamə. ");
INSERT INTO nwi_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kɨni nɨpɨg nɨmrɨn pɨs rɨmnərɨg mə narmamə khapsaah kaseriwək ye swatuk, kɨni raiyoh-pən mə, “?Naha nhagɨn narmamə kasor?” ");
INSERT INTO nwi_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Narmamə khani-pən tukun mhamə, “Yesu e. Yemə Nasaret. Rameriwək ye swatuk.” ");
INSERT INTO nwi_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kɨni rokrən apomh mɨmə, “!Yesu! !Kwənərəus kape King Deved! !Rɨkim tukreihuə tuk yo!” ");
INSERT INTO nwi_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kɨni narmamə e kaseriwək mɨsəkupən kɨn Yesu khani-pən tukun mhamə, “!Ah! !Pim!” Mərɨg ramrɨpɨn əmə ye nokrənien, mamni mə, “!Kwənərəus kape King Deved! !Rɨkim tukrehuə tuk yo!” ");
INSERT INTO nwi_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kɨni Yesu rərer mɨni-pən tuk əriə mɨmə, “Harəh mhauə.” Kɨni kɨmnharəh mhauə ipakə, Yesu raiyoh-pən mɨmə, ");
INSERT INTO nwi_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“?Nakmə jakor naha nhagɨn kɨmik?” Kɨni in rɨmə, “Yermaru, yakorkeikei mə jakəm nar.” ");
INSERT INTO nwi_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kɨni Yesu rɨni-pən tukun mɨmə, “Arha məm nar. Kafam nhatətəyen rɨmnor huvə ik.” ");
INSERT INTO nwi_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Məkneikɨn, rarha məm nar, kɨni mɨkwasɨg kɨn Yesu, mamni vi vi Kughen. Kɨni nɨpɨg narmamə m-fam kɨmɨsəm nar a, iriə mɨn kɨmnhani vi vi Kughen. ");
INSERT INTO nwi_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Kɨni Yesu reriwək mamvən mə tukrɨtərhav-pən Jeriko. ");
INSERT INTO nwi_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kɨni ye taon a, kwən kɨrik aikɨn, nhagɨn e Sakias. In yemehuə kɨrik kape narmamə yamə mɨne kasərer tuk mane kape takis. Kɨni kafan nautə rɨpsaah. ");
INSERT INTO nwi_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kɨni in rorkeikei mə tukrəm-ru mə Yesu In pa. Mərɨg reinein nəmien, meinai in rarkwakwə. Kɨni narmamə kasərer əswasɨg kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kɨni Sakias raiyu əkupən mɨvən mhaktə ye tokrei nai kɨrik e kamni kɨmə sikamo, mə tukrəm Yesu ye nɨpɨg In tukrukurao-pən aikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kɨni nɨpɨg Yesu rɨmauə atuatuk a in ikɨn, marha faktə məm in. Kɨni mɨni-pən tukun mɨmə, “Sakias. Eiwaiyu aihuaa. Meinai taktəkun ai, jakaməkeikei mɨvən apa imam yerkwanu kafam mamarə.” ");
INSERT INTO nwi_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Məkneikɨn Sakias rɨmneiwaiyu, mɨkɨr Yesu mɨravən apa iman ikɨn yerkin agien. ");
INSERT INTO nwi_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mərɨg nɨpɨg narmamə kɨmɨsəm narɨmnar mɨnə a, kɨni kɨsəsiwən-əsiwən kɨn norien mɨnə a, mamhani nɨkar Yesu mhamə, “!Ah! Kwən a ramvən imei yor təvhagə has mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kɨni nɨpɨg kɨmnhavən ye nəkwai nimə kape Sakias, in rərer mɨni-pən tuk Yesu mə, “Yermaru. Ǝrɨg-ru yo. Jakəwhai kafak narɨmnar mvwəhsi-pən nɨpərɨn kɨmi yavən has mɨnə, mɨpəh nɨpərɨn kafak. Kɨni narɨmnar yame yɨmnəkrəh kɨn, yo jakarpɨn-pən mɨ-kuas.” ");
INSERT INTO nwi_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kɨni Yesu rɨni-pən tukun mə, “Taktəkun Kughen rɨvəh mɨragh ik mɨne kafam mɨnə. Meinai ik mɨn nɨmnhatətə ye Kughen, kɨni ik nɨmauə kwənərəus əfrakɨs kɨrik kape Ebraham. ");
INSERT INTO nwi_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kɨni Yo, Ji Yermamə, yɨmauə mə jakarhakɨn narmamə yamə mɨne kwəserwei, mɨwəh mɨragh əriə.” ");
INSERT INTO nwi_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nɨpɨg Yesu rɨnamuə ipakə tuk Jerusalem, narmamə rɨkiriə rɨmnəsɨk mə narmaruyen kape Kughen pəh nien mə tuktu ruə. Kɨni Yesu ramrɨpɨn nəgkiarien kafan mamni nuhpɨkɨnien kɨrik kɨmi əriə ");
INSERT INTO nwi_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","mɨmə, “Yemehuə kɨrik rɨmə tukrɨvən apa kantri pɨsɨn kɨrik isok, mə tukvəh-si haktə in mə in king kɨrik. ");
INSERT INTO nwi_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kwasɨg ikɨn rɨtərhav, in rɨmnokrən kɨn kafan yorwok ten, məwhai mane mɨvəhsi-pən kɨrikianə kɨrikianə kɨmi əriə. Kɨni mɨni-pən tuk əriə mɨmə, ‘Kɨmiə takasəkeikei masor wok kɨn mane, pəh ramehuə, mɨseriaji yo jakrerɨg-pə mɨn.’ ");
INSERT INTO nwi_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Mərɨg iriə apa iman ikɨn kɨmɨsəməkɨn kwən a, kɨni mɨsher-pən nəgkiarien mhamə, ‘Yakhapəh nɨsorkeikeiyen mə kwən a tukrarmaru irəmawə.’ ");
INSERT INTO nwi_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mərɨg kɨvəh-si haktə in kɨnor king kɨn, kɨni in rɨrerɨg-pə mɨn. Kɨni mokrən kɨn kafan yorwok yame mɨne rɨmnəwhai kafan mane irəriə. Rɨmə tukrɨrkun-ru mə kɨmɨsor win ye naha mane ye nɨpɨg rɨmnamarə isok. ");
INSERT INTO nwi_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Kɨni yame raməkupən rɨmauə mɨni-pən tukun mɨmə, ‘Yemehuə. Nɨmnərəhu-pə mane kɨrik ye kwermɨk, kɨni yɨmnor win mɨn ye irəkwak ten.’ ");
INSERT INTO nwi_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kɨni kafan yemehuə rɨmɨni-pən tukun mə, ‘Ik nɨmnor wok yame rhuvə, meinai nɨmnor wok huvə tuk nəm-huvəyen nar yame rɨkəskəh, kɨni taktəkun ai, yakeighan kɨn ik mə takarmaru ye taon iriə m-fam ten.’ ");
INSERT INTO nwi_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Kɨni yame ramkwasɨg kɨn ruə mɨni-pən mə, ‘Yemehuə. Nɨmnərəhu-pə mane kɨrikianə ye kwermɨk, kɨni yɨmnor win mɨn ye irəkwak kɨrkɨrɨp.’ ");
INSERT INTO nwi_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Kɨni yemehuə rɨmɨni-pən tukun mɨmə, ‘Ik takamarmaru ye taon iriə m-fam kɨrkɨrɨp.’ ");
INSERT INTO nwi_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Mərɨg yorwok mɨn kɨrik ruə mɨni-pən tukun mə, ‘Yemehuə. Mane e kafam. Yɨmnərkɨs ətərəkɨn kɨn neipən merkwaig huvə kɨn ");
INSERT INTO nwi_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","meinai yakamgɨn kɨn ik, meinai kafam norien rəutən. Ik nakawəh narɨmnar yame pəh nien mə kafam, kɨni mampɨk nəvɨgɨnien ye nəsimien yame pəh nien mə kafam.’ ");
INSERT INTO nwi_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Kɨni yemehuə a rɨni-pən tukun mɨmə, ‘!Ik yorwok has! Nəgkiarien əmə kafam ramhajoun mə nɨmnoriah əgkəp. Nakwɨrkun ta mə yo yemə əutən, kɨni yakavəh narɨmnar yame pəh nien mə kafak, kɨni mampɨk nəvɨgɨnien ye nəsimien yame pəh nien mə nəsimien kafak. ");
INSERT INTO nwi_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","?Rhawor nɨmɨpəh nɨvəhyen kafak mane mɨvən mərəhu-pən ye bang, pəh nɨpɨg yame jakrerɨg iran, jakɨrkun nɨvəhyen kafak mane iriu profit kafan?’ ");
INSERT INTO nwi_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Kɨni yamehuə a rarar mɨni-pən tuk narmamə yamə mɨne kasərer ipakə, mɨmə, ‘Havəhsita mane yame yɨmɨvəhsi-pən kɨmin, mhavəhsi-pən kɨmi kwən a kafan mane ten.’ ");
INSERT INTO nwi_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Kɨni iriə kɨmnhani mhamə, ‘Yamehuə. Rapəh natuatukien meinai ruɨvəh-ta mane ten.’ ");
INSERT INTO nwi_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Kɨni yemehuə a rɨni-pən tuk əriə mɨmə, ‘Yakamni-pre tuk əmiə mə, yermamə yame rawəh nar kɨrik, tukpivəhsi-pən mɨn tɨksɨn kɨmin. Mərɨg yermamə yame kafan nar kɨrik rɨrkək, tukpiwəh-sita fam kafan narɨmnar mɨnə. ");
INSERT INTO nwi_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kɨni taktəkun ai, kafak tɨkmɨr yamə mɨne khapəh nɨsorkeikeiyen mə jakuə king kapəriə, takhakɨr əriə mhauə, mɨshopni əriə ye nɨmrɨk.’” ");
INSERT INTO nwi_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kɨni nɨpɨg Yesu rɨmnəgkiar ta, kɨni In rɨmneriwək məkupən mamvən Jerusalem, kɨni narmamə kɨmnhakwasɨg kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nɨpɨg kɨmnhauə ipakə tuk yerkwanu mir a Betfas mɨne Betani ye tukwas a kamni kɨmə Olif, kɨni In rɨmɨni-pən tuk kafan yermamə mir kɨraru mɨmə, ");
INSERT INTO nwi_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Takravən apa yerkwanu yame nakaravaag-pən ikɨn. Ikɨn a, takwəm kwaji dongki kɨrik yame kɨpəh hanə nəsuəyen iran. Nakrarɨsɨn mwəsɨg mɨrauə. ");
INSERT INTO nwi_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kɨni tukmə yermamə kɨrik raiyoh-pre əmiru mɨmə, ‘?Nakararɨsɨn dongki a tuk naha?’ Kɨni takrani-pən tukun mɨrəmə, ‘Yermaru kapətawə rɨmə tukrəsuə iran.’” ");
INSERT INTO nwi_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kɨni kɨmɨravən mwəm naha nhagɨn yame Yesu rɨmɨni. ");
INSERT INTO nwi_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kɨni nɨpɨg kɨmɨrarɨsɨn kwaji dongki, kɨni narmamə kapəriə a dongki kɨmɨsaiyoh əriu mhamə, “!Eh! ?Nakararɨsɨn dongki a tuk naha?” ");
INSERT INTO nwi_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kɨni iriu kɨrəni-pən tuk əriə mɨrəmə, “Yermaru rɨmə tukrəsuə iran.” ");
INSERT INTO nwi_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kɨni kɨmwəsɨg mɨravən kɨmi Yesu, mawəpeinə-pən kɨn kapəriu kot ye nɨmetai dongki, kɨni mwasitu ye Yesu rhaktə məsuə ye kwaji dongki a. ");
INSERT INTO nwi_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nɨpɨg rɨmnəsuə iran mamvən, kɨni kafan narmamə kɨsəpəkiək ta kɨn kapəriə kot mɨsətu mɨmhahuvə-pən kɨn kɨmi swatuk. ");
INSERT INTO nwi_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kɨni nɨpɨg Yesu rɨnamuə ipakə tuk Jerusalem, maməsuə ye dongki a, mamuə ye tukwas e kamni kɨmə Olif. Kɨni narmamə mɨnə kafan khapsaah kɨmnhauə. Rɨkiriə m-fam ragien, kharikakun mamhani vi vi Kughen masokrən apomh tuk nɨmtətien yamə mɨne kɨmɨsəm In ramor. ");
INSERT INTO nwi_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kɨni mamhani mhamə, “Pəh kɨvəh-si haktə Kwən en ramuə ye nhag Yermaru! Pəh nəmərinuyen tukrarə apa ye rao ye neai. Kɨni apa yerpɨrɨg əgkəp ye rao ye neai, pəh kɨvəh-si haktə nhag Kughen Yermaru.” ");
INSERT INTO nwi_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kɨni Farisi mɨnə tɨksɨn yamə mɨne kasərer aikɨn khani-pən tukun mhamə, “Yhajoun. Ni-əhu kafam narmamə mɨnə mə tukhapim əmə.” ");
INSERT INTO nwi_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mərɨg Yesu rɨmɨni-pən tuk əriə mɨmə, “Tukmə narmamə mɨne e khapim, kapier mɨnə e tuksokrən-okrən.” ");
INSERT INTO nwi_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kɨni nɨpɨg Yesu rɨmauə ipakə məm taon a Jerusalem, kɨni mamasək tuk narmamə mɨnə aikɨn a. ");
INSERT INTO nwi_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Mamni mɨmə, “!Eh! Nar apnapɨg mə nɨmɨsəpəh narɨmnar yame ravəhsi-pə nəmərinuyen kɨmi əmiə mɨseriaji-pə ai təkun, mərɨg tokmə nakpiharkun əriə ai taktəkun, kɨni Kughen rɨpivəhsi-pre kɨmi əmiə. Mərɨg nɨkam. Narɨmnar mɨnə a kaserkwaig to nakhapəh nɨsəmien. ");
INSERT INTO nwi_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mərɨg nɨpɨg mɨnə e yame ramuə tuk əmiə, kapəmiə tɨkmɨr mɨnə tukhauə mɨsərer rukrao irəmiə, tukhakɨr nɨmoptanə mhakɨr ihaktə kor kəsɨk kəupə kɨn ye kapəmiə taon, mɨsor əswasɨg kɨn tuk əmiə. ");
INSERT INTO nwi_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kɨni iriə tuksoriah fam nimə mɨnə ye taon kapəmiə, to kapier kɨrik ye kapəmiə nimə mɨnə rɨpəh nərerien. Kɨni tukshopni əmiə mɨfam mɨne kapəmiə kwajikovə mɨnə. Narɨmnar mɨnə fam e tukruə meinai kɨmiə nakseinein nɨpɨg e towei yame Kughen rɨmauə mə tukrɨvəh mɨragh əmiə iran.” ");
INSERT INTO nwi_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kɨni Yesu rɨmavən ye Nimə Ehuə kape Kughen, maməko yerhav narmamə yamə mɨne kasor maket aikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kɨni In rɨmɨni-pən tuk əriə mə, “Kɨmɨrai-pən ye Nəkwəkwə kape Kughen kɨmə, ‘Kafak nimə, in nimə kape nəhuakien,’ mərɨg kɨmiə naksor ruə rəmhen kɨn ‘nimə kɨrik yame yəkrəh mɨnə kaserkwaig ikɨn.’” ");
INSERT INTO nwi_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kɨni kwasɨg ikɨn, ye nɨpɨg m-fam, Yesu rɨmnəwhag apa ye nəkwai Nimə Ehuə kape Kughen. Kɨni jif pris mɨnə mɨne nəmhajoun kape Loa kape Moses, mɨne nəmehuə mɨnə kape kwənərəus kape Isrel, kasarhakɨn swatuk mə tukshopni Yesu, ");
INSERT INTO nwi_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","mərɨg khapəh nɨsəmien, meinai nɨpɨg m-fam narmamə khapsaah iriə min, meiani kɨsorkeikei pɨk mə tukasərɨg nəgkiarien mɨnə kafan, kɨni nəgkiarien kafan ramuh kapəriə nətərɨgien. ");
INSERT INTO nwi_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nɨpɨg kɨrik, Yesu rɨmnaməvhag kɨmi narmamə apa ye Nimə Ehuə Kape Kughen, mamni-ərhav nəvsaoyen huvə kape Kughen kɨmi narmamə. Kɨni jif pris mɨnə mɨne nəmhajoun kape Loa kape Moses mɨne nəmehuə mɨnə kape kwənərəus kape Isrel kɨmnhauə masəm In. ");
INSERT INTO nwi_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Mɨsaiyoh mhamə, “?Nakamhawor narɨmnar mɨnə e? ?Pa nhagɨn rɨmɨvəhsi-pre nehuəyen mə takor narɨmnar məknekɨn?” ");
INSERT INTO nwi_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Kɨni Yesu rɨni-pən tuk əriə mə, “Rhuvə. Jakaiyoh kɨn naiyohyen kɨrik kɨmi əmiə. Tukmə nakhani atuatuk, jakni-pre tuk əmiə mə Pa nhagɨn rɨmɨwəhsi-pə nehuəyen kɨmi Yo tuk norien narɨmnar. ");
INSERT INTO nwi_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Hanipə-ru tuk Yo mə ?Pa rɨmɨvəhsi-pən nehuəyen kɨmi Jon mə tukror baptaes ye narmamə? ?Kughen uə yermamə?” ");
INSERT INTO nwi_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kɨni kɨnasəsiwən-əsiwən kɨmi əriə mɨnə mhamə, “?Tukshaw ni e? Tukmə kɨtawə khani mə Kughen rɨmɨvəhsi-pən nehuəyen kɨmi Jon, mərɨg Yesu tukrɨni mɨmə, ‘?Tukmə Kughen rɨmɨvəhsi-pən nehuəyen kɨmin, rhawor e kɨmiə nakhapəh nhaniyen nəfrakɨsien iran?’ ");
INSERT INTO nwi_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mərɨg to khapəh mɨn nhaniyen mə, ‘Yermamə əmə rɨmɨvəhsi-pən nehuəyen kɨmin,’ meinai narmamə mɨnə e kamhani mə Jon in profet əfrakɨs.” ");
INSERT INTO nwi_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kɨni kɨshorpɨn mhamə, “Kɨmawə yakseinein mə pa rɨvəhsi-pən neihuəyen kɨmin.” ");
INSERT INTO nwi_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kɨni Yesu rɨmɨni-pən tuk əriə mə, “Kɨni Yo mɨn, to yakpəh nɨniyen mə Pa rɨmɨvəhsi-pə neihuəyen kɨmi Yo mə jakor narɨmnar mɨnə e.” ");
INSERT INTO nwi_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kɨni Yesu rɨmɨni nuhpɨkɨnien kɨrik kɨmi narmamə mɨmə, “Yermamə kɨrik rəsim kɨn kafan plantesen kape grep. Kɨni in mərəhu plantesen a ye kwermɨ narmamə tɨksɨn, marə, mɨtərhav ye tanə pɨsɨn marə kape nɨpɨg apomh. ");
INSERT INTO nwi_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kɨni kwənkwai grep rɨmhiak, kɨni yemehuə kape plantesen rher-pən kɨn kafan tɨksɨn manaja mə tukhavən mɨsəm narmamə yamə mɨne kɨsəsim aikɨn mə tukhavəhsi-pən grep nan, rəmhen kɨn nərok kafan. Mərɨg iriə kɨsarar, mharaptərəkɨn kwən ai, mɨsərkɨs-ərkɨs, mɨsher-pən kɨn mə tukrɨrerɨg, mhapəh nhavəhsi-pənien mane kɨrik kɨmin. ");
INSERT INTO nwi_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kɨni yamehuə ai rarə mher-pən mɨn kɨn kafan kɨrik yermamə. Mərɨg iriə kɨmnhauh mɨn mɨsor naurɨsien kɨmin, mɨsher-pən kɨn mə tukrɨrerɨg, mhapəh nhavəhsi-pənien mane kɨrik kɨmin. ");
INSERT INTO nwi_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ǝmaikɨn, yamehuə kape plantesen rher-pən mɨn kɨn yermamə kɨrik mɨn. Kɨmnhauh in, mɨsəko yerhav in. ");
INSERT INTO nwi_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kɨni yamehuə kape plantesen a rɨmə ‘?Jakhawor ai taktəkun? Rhuvə mə jakher-pən kɨn narɨk keikei, tukmə ror iriə tukhasiai in.’ Kɨni rher-pən kɨn ruvən. ");
INSERT INTO nwi_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Mərɨg iriə kɨsəm khamə, ‘Kwajikovə atuatuk e kape yamehuə kape plantesen. Pəh kɨshopni pəh plantesen e tukror kapətawə kɨn.’ ");
INSERT INTO nwi_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Məknekɨn kharaptərəkɨn, mɨsarkw-ərhav kɨn ye nəkwai plantesen, mɨshopni. ?Yamehuə kape plantesen a tukrhawor mɨn? ");
INSERT INTO nwi_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tukrɨvən mhopni-hopni narmamə mɨnə ai, mərəhu-pən plantesen a ye kwermɨ narmamə pɨsɨn.” Kɨni nɨpɨg narmamə kɨmɨsərɨg nəgkiarien a khamə, “Pəh nar a tukrɨpəh norien nəfrakɨsien kɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mərɨg Yesu rɨmnarha tɨm tɨm irəriə mɨmə, “Nəkwəkwə kape Kughen ramni mə, “‘Səpaag e, yame narmamə kape nəvhirəkɨnien nimə kɨmɨsarakikɨn, mərɨg Kughen rɨmnor in ruauə Səpaag huvə yame tukrəkɨr məkupən.’ “?Mərɨg nəgkiarien e nɨpran naha? ");
INSERT INTO nwi_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mə narmamə mɨfam yamə mɨne kamharəh pɨkɨn səpaag a, nɨkɨkririə tukrakapɨr. Kɨni yermamə yame səpaag a tukrɨmamɨr, mhopni, mhosɨs.” ");
INSERT INTO nwi_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kɨni nəmhajoun kape Loa kape Moses mɨne jif pris mɨnə kɨmnharkun mə nuhpɨkɨnien mɨnə a ramni irəriə; ror məkneikɨn, kɨmɨsarha-kɨn swatuk mə tukharaptərəkɨn aihuaa əmə In, mhawəhsi-pən ye kalabus, mərɨg kɨmɨsəpəh meinai kɨmnhagɨn kɨn narmamə. ");
INSERT INTO nwi_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kɨni nəmhajoun kape Loa kape Moses, mɨne jif pris mɨnə kɨmɨsarha tɨm tɨm ye Yesu mɨsorkeikei mə tukharuk-pən nəgkiarien kɨrik iran tuk nəgkiarien kafan, mhawəhsi-pən in ye kwermɨ gavman kape Rom. Kɨni mɨsarar mɨsher-pən kɨn narmamə tɨksɨn mə tukhavən masor kəut kəsuə kɨmin. ");
INSERT INTO nwi_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kɨni kəut kəsuə mɨnə kɨmnhavən mɨsaiyoh Yesu mhamə, “Yhajoun. Yakharkun mə Ik yermamə atuatuk. Nakpəh nɨgɨnien kɨn yermamə mə to rɨvi kafam nərɨgien, meinai rɨkim rapəh nəsɨkien mə yermamə kɨrik rehuə uə yermamə kɨrik reiwaiyu, mərɨg nakaməfrakɨs əmə, kɨni nəvhagien kafam raməri-pən əmə norien yame Kughen rorkeikei. ");
INSERT INTO nwi_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ni-ru tuk əmawə mə, ?Ratuatuk mə tukasərok-pən takis kɨmi Sisa, yamehuə kape Rom, uə nɨkam?” ");
INSERT INTO nwi_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mərɨg Yesu ruɨrkun mə kɨmnhani əmə naiyohyen a mə in tukrɨni nəgkiarien kɨrik yame tukhani hah in tukun. ");
INSERT INTO nwi_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Kɨni mɨni-pən tuk əriə mə, “Havən-ru mhawəh mane kɨrik mhauə pəh yakəm. ?Mə nanmɨ pa raməmɨr-pən aikɨn? ?Mɨne nhag pa?” ");
INSERT INTO nwi_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Khamə, “Nanmɨ Sisa, mɨne nhagɨn.” Məknekɨn Yesu rɨni-pən tuk əriə mə, “Namhen. Nar kɨmɨni kɨmə kape Sisa, havəhsi-pən kɨmi Sisa. Mərɨg nar kape Kughen, hawəhsi-pən kɨmi Kughen.” ");
INSERT INTO nwi_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kɨni kɨsakur pɨk kɨn nəgkiarien yame Yesu rɨmɨrpen, mɨseinein nhawəhsi-əhuyen Yesu ye nɨmrɨ narmamə kɨn naiyohyen. Mhapəh nhaniyen nar kɨrik. ");
INSERT INTO nwi_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kɨni Sadusi mɨnə tɨksɨn kɨmnhauə tuk Yesu. Iriə khamə ta mə narmamə yamə mɨne kwənhamhə, to khapəh nhamragh-mɨnien ye rao ye neai. ");
INSERT INTO nwi_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Kɨni kɨmɨsaiyoh-pən kɨn nəgkiarien kɨrik kɨmi Yesu mhamə, “Yhajoun. Moses rɨmɨrai-pən ye Loa kapətawə mə tukmə kwən kɨrik rɨmhə-tan kɨn kafan piraovɨn, mərɨg kɨrɨpəh hanə nɨweiməkien kɨn kwajikovə kɨrik, kɨni piauni kɨrik tukraməkeikei mɨkɨr pian a tukaweimək, kɨni kwajikovə mɨnə tukharaptərəkɨn mɨn nhag yermamə yame rɨmamhə. ");
INSERT INTO nwi_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tukmə narman seven, iriə piauriə mɨnə. Nɨmrɨn nupan rarkurək kɨni mɨpəh nɨrəhyen kafan kɨrik kwajikovə, mɨmhə. ");
INSERT INTO nwi_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Kɨni tukmə yame rɨkwasɨg kɨn rɨkɨr piraovɨn kape piauni yame rɨmamhə, kɨni mɨpəh neiməkien, kɨni mɨmhə mɨn. Kɨni naorahini yame ror kɨsisər kɨn ror əmə mɨn nar kɨrikianə kɨn meriaji iriə fam a seven kɨsarkurək ye piraovɨn a, kɨni mhamhə fam, mhapəh nɨseiməkien. ");
INSERT INTO nwi_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kɨni en piraovɨn ai rɨmhə mɨn. ");
INSERT INTO nwi_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kɨni ye nɨpɨg kape narmamə tukhamragh mɨn iran, iriə ai seven iriə piauriə mɨnə, ?piraovɨn ai tukror piraovɨn kɨn kape pa nhagɨn?” ");
INSERT INTO nwi_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Mərɨg Yesu rɨmɨni-pən tuk əriə mɨmə, “Ye tokrei tanə e, narman mɨne nɨpiraovɨn kɨsarkurək. ");
INSERT INTO nwi_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Mərɨg ye nɨpɨg kape narəyen vi, narmamə yame Kughen rɨkin ragien tuk əriə mə tukhamragh mɨn ye nɨmhəyen kɨni mɨvəh əriə mɨvən kɨsarə ye narəyen vi, to iriə khapəh nɨsarkurəkien. ");
INSERT INTO nwi_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kɨni iriə to khapəh nhamhəyen meinai tuksəmhen əmə kɨn agelo mɨnə. Kɨni iriə ji Kughen mɨnə meinai In rɨmnor əriə kamhamragh mɨn ye nɨmhəyen. ");
INSERT INTO nwi_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kɨni Moses ramhajoun ye nəkwəkwə kafan mə narmamə tukhamragh mɨn ye nɨmhəyen kapəriə, mamni mə nɨpɨg in rɨmnəm nai kɨrik ramuək; aikɨn, Moses rokrən kɨn Kughen mɨmə Ik, ‘Ik Ik Kughen yame Ebraham, Aesak mɨne Jakob karhəgnəgɨn hanə Ik.’ ");
INSERT INTO nwi_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","!Kɨtawə kharkun mə irisɨr kɨrharə iriə Kughen meinai nar apnapɨg kwərhɨmhə ta tu mɨrhokupən Moses, mərɨg Kughen ramni mə karhəgnəgɨn hanə In. !Kɨni pa rɨmə narmamə mhə mɨnə ksəgnəgɨn Kughen, mərɨg narmamə yamə mɨne kamhamragh!” ");
INSERT INTO nwi_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kɨni Farisi tɨksɨn kɨmhani-pən tuk Yesu mhamə, “Yhajoun, nɨmɨrpen huvə nəgkiarien.” ");
INSERT INTO nwi_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kɨni iriə m-fam kɨmnhagɨn kɨn naiyoh-pən-mɨnien nəgkiarien kɨrik kɨmin. ");
INSERT INTO nwi_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kɨni Yesu ramaiyoh-pən əriə mɨmə, “?Rhawor e kamni kɨmə, ‘Mesaea in kwənərəus əmə kape Deved?’ ");
INSERT INTO nwi_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mərɨg, səmru, Deved rɨmɨrai-pən ye Ol Sam mɨmə, “‘Kughen Yermaru rɨmɨni-pən tuk Yermaru kafak mɨmə, “Ǝkwətə ye kwermɨk matuk ");
INSERT INTO nwi_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Meriaji nɨpɨg jakor ik takehuə ye tɨkmɨr kafam mɨnə.” ’ ");
INSERT INTO nwi_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Ye nəgkiarien e, Deved rɨmnokrən kɨn Mesaea mə ‘Yermaru.’ ?Mərɨg nakshawor mamhani mə Mesaea in kwənərəus əmə kape Deved?” ");
INSERT INTO nwi_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nɨpɨg narmamə kɨsətərɨg kɨn, In rɨmɨni-pən tuk kafan narmamə mɨmə, ");
INSERT INTO nwi_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kɨmiə takasərɨg əmiə tuk namhajoun kape loa kape Moses. Iriə rɨkiriə ramagien tuk nɨvəhsi-pənien neipən huvə. Kɨni tukmə khavən apa ye maket, mɨsorkeikei pɨk mə narmamə mɨnə fam tuksaowiə kɨmi əriə mhasiai əriə. Kɨni tukmə khavən ye nimə kape nofugɨnien, mɨsorkeikei mə tukasəkwətə əkupən, kɨni tukmə khavən ye lafet, mɨsorkeikei mə tuksəkwətə ye kwənmhaan kape nɨsiaiyen. ");
INSERT INTO nwi_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kɨni tukmə piahwaru yame kɨmnamhə-tan kɨn, kɨni iriə kasəkrəh kɨn kafan nautə. Kɨni masəhuak apomh mɨn mə narmamə mɨnə tukhasiai əriə. Narpɨnien kapəriə tukrɨskai rapita.” ");
INSERT INTO nwi_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kɨni Yesu ramkwətə ipakə tuk kwənmhan yame kɨvəhsi-pən mane kɨmi Kughen ikɨn, mɨvaag haktə məm narmamə kapəriə nautə rehuə kamhavəhsi-pən mane kapəriə. ");
INSERT INTO nwi_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kɨni məm mɨn piahwaru kɨrik kɨmnamhə-tan kɨn ruə; kafan mane rɨrkək. Kɨni in mɨwəhsi-pən əmə sɨren kɨraru. ");
INSERT INTO nwi_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kɨni Yesu rɨmə, “Yakamni əfrakɨs tuk əmiə. Piahwaru e kɨmhə tan kɨn, kafan mane rɨrkək, mərɨg in rɨmɨvəhsi-pən mane kɨmi Kughen rapita fam mane yame narmamə mɨnə tɨksɨn kɨmnhavəhsi-pən. ");
INSERT INTO nwi_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Narmamə ai kɨmnhavəhsi-pən əmə nɨpar mane, mamhapəh nɨpərɨn. Mərɨg piahwaru e kafan mane rɨrkək pawk, mərɨg rɨmɨvəhsi-pən fam mane yame tukrɨvəh nɨmrɨ nəvɨgɨnien kɨn nan.” ");
INSERT INTO nwi_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kɨni kafan tɨksɨn narmamə kasəgkiar ye Nimə Ehuə kape Kughen yame kafan kapier ehuə mɨnə khahuvə, mɨne narɨmnar huvə mɨnə a imə yame narmamə kamhavəh-sipən kɨmi Kughen. Kɨni Yesu rɨni mɨmə, ");
INSERT INTO nwi_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nimə e nakasəm ai taktakun, mərɨg nɨpɨg ramuə yame narmamə tuksatmətəg-ətəg kapier mɨnə kape nimə e, kapier kɨrik to rɨpəh nərerien a ikɨn ramərer ikɨn taktəkun.” ");
INSERT INTO nwi_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kɨni kɨsaiyoh-pən In mhamə, “Yhajoun. ?Narɨmnar mɨnə e tuk nagheen ruə? ?Kɨni naha nɨmtətien tukrhajoun mə pəh nien mə tuktu narɨmnar mɨnə e tukhatərhav pə?” ");
INSERT INTO nwi_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Kɨni Yesu rɨmə, “Takasəkeikei masərɨg əmiə mə yermamə kɨrik tukrɨpəh neikuəyen irəmiə mɨvi əmiə. Meinai narmamə khapsaah tukhauə mhamə, ‘Yo, yo e Kristo’ kɨni tɨksɨn tukhani mhamə, ‘Nɨpɨg kape narɨmnar mɨnə e rɨnamuə ipakə.’ Mərɨg takhapəh nhakwasɨgien kɨn əriə. ");
INSERT INTO nwi_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kɨni nɨpɨg takasərɨg nəvsaoyen kɨn mə narmamə kasarowagɨn, uə narmamə kasərer mashopni gavman kapəriə, mərɨg takhapəh nhagɨnien. Narɨmnar mɨnə a tuksəkupən kɨn, mərɨg pəh nien mə Nɨpɨg Kwasɨg a.” ");
INSERT INTO nwi_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kɨni Yesu ramrɨpɨn nəgkiarien mɨmə, “Kwənərəus mɨnə tɨksɨn tukhauh mɨn kwənərəus pɨsɨn mɨnə tɨksɨn. Kɨni gavman kɨrik tukruh gavman kɨrik. ");
INSERT INTO nwi_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kɨni mig ehuə mɨnə tuksavən. Kɨni nɨkumhə tukravən ikɨn mɨnə khapsaah ye tokrei tanə, kɨni nəmhəyen skai mɨnə tukhavəh narmamə ye tokrei tanə. Kɨni apa yerpɨrɨg ye nɨmago-ago, narɨmnar tukhauə mɨsor rɨki narmamə khagɨn. Kɨni tuksəm nɨmtətien ehuə mɨnə ye neai. ");
INSERT INTO nwi_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Mərɨg kwasɨg ikɨn narɨmnar mɨnə a tukrɨtərhav, narmamə tukharaptərəkɨn əmiə, mhauh əmiə, mɨsərɨp əmiə ye nimə kape nofugɨnien kapəriə, mhavəhsi-pən əmiə ye kalabus. Mɨsərɨp əmiə ye nɨmrɨ king mɨnə, mɨne nəmehuə mɨnə kape gavman meinai kɨmiə nakamhavəh nhagɨk mamhani nəfrakɨsien irak. ");
INSERT INTO nwi_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","In a nɨpɨg atuatuk yame takhani-ərhav nəvsaoyen huvə kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mərɨg takhapəh nɨsətərɨg-kupənien mə naha nəgkiarien takhani-pən tuk əriə, ");
INSERT INTO nwi_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","meinai Yo jakvəhsi-pre nəgkiarien atuatuk kɨmi əmiə kɨni mɨvəhsi-pre nɨrkunien kɨmi əmiə, kɨni mor kapəmiə nəgkiarien rəsanɨn, kɨni kapəmiə tɨkmɨr mɨnə tukhapəh nɨshorpɨnien nəgkiarien, mhapəh nhaniyen mə kɨmiə nakseikuə. ");
INSERT INTO nwi_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kɨni kapəmiə tatə mɨnə mɨne mamə mɨnə mɨne piaumiə mɨnə mɨne kapəmiə kwənərəus mɨnə mɨne kɨmiə mɨnə tɨksɨn tukseighan-pən kɨn əmiə ye kwermɨ tɨkmɨr mɨnə kapəmiə. Kɨni mɨshopni əmiə tɨksɨn. ");
INSERT INTO nwi_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Narmamə m-fam tuksəməkɨn əmiə meinai nakamhani nəfrakɨsien irak. ");
INSERT INTO nwi_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mərɨg kɨmiə taksarə huvə əfrakɨs, to kɨmiə kɨrik rɨpəh nerweiyen. ");
INSERT INTO nwi_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tukmə naksərer tɨm tɨm, mɨshatətə irak ye nɨpɨg əutən yamə mɨne kamhauə ye kapəmiə nɨmraghien, takhavəh nɨmraghien rerɨn. ");
INSERT INTO nwi_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Mərɨg tukmə naksəm mobael mɨnə khapsaah khauə mɨsərer kurao ye taon e Jerusalem, kɨni kɨmiə takasəkeikei mharkun mə pəh nien mə tuktu kɨni kɨsoriah əgkəp taon a. ");
INSERT INTO nwi_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kɨni kɨmiə yamə mɨne nakasarə ye Judia, takasəkeikei mɨsaiyu mɨsap mhavən mɨserkwaig apa ye tukwas mɨnə. Kɨni kɨmiə yamə mɨne nakasarə ye taon a, takasəkeikei mɨsap. Kɨni kɨmiə yamə mɨne nakasarə ikɨn mɨnə rarkurao ye taon a, takhapəh nhavənien imə ye taon a, ");
INSERT INTO nwi_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","meinai nɨpɨg a in nɨpɨg kape Kughen tukror narpɨnien kɨmi narmamə yamə mɨne kasor norien has. Kɨni nəgkiarien yame kɨmɨrai-pən ye Nəkwəkwə kafan tukruə mor nəfrakɨsien kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","!Aweh! Nəmhəyen ehuə tukruə tuk nɨpiraovɨn yamə mɨne kɨsor tɨpriə, mɨne yamə mɨne kahavəhsi-pən nah kɨmi kwajikovə, meinai nahasien ehuə tukruə ye tanɨmtanə. Kɨni Kughen tukror niemhaa mɨne narpɨnien kɨmi nəmə Isrel mɨnə fam. ");
INSERT INTO nwi_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kɨni tukshapni narmamə kɨn nau, kɨni nɨpɨg kapəriə tɨkmɨr mɨnə kɨsapita əriə, tukhakɨr əriə mhavən ye kantri pɨsɨn pɨsɨn mɨnə mɨsor əriə rəmhen kɨn slef mɨnə kapəriə. Kɨni narmamə yamə mɨne pəh nien mə kwənərəus kape Isrel tuksəvi-əsɨs Jerusalem mhavəh-si əhu narmamə yamə mɨne kɨsarə aikɨn, mɨsarmaru irəriə mhavən mɨseriaji nɨpɨg kapəriə tukror infamien. ");
INSERT INTO nwi_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kɨni nɨmtətien tɨksɨn tukhauə ye mɨrh mɨne makuə mɨne kəmhau mɨnə. Kɨni eikɨn e ye tokrei tanə. Kɨni tahik tukrəsəsao, peao-peao mɨnə tukhavi pɨk, narmamə m-fam tukhagɨn kɨn, rukreikɨn kapəriə kapə. ");
INSERT INTO nwi_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Narmamə tukhagɨn pɨk, nɨmrɨriə rəpɨgnap kɨn nahasien ehuə yamə mɨne tukhauə ye tokrei tanə meinai narɨmnar kape neai kasərer tɨm tɨm pawk, mərɨg Kughen tukrɨkiu-kiu irəriə. ");
INSERT INTO nwi_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kɨni ye nɨpɨg a, tuksəm Ji Yermamə tukreiwaiyu-pə ye nɨmar napuə kɨrik ye nəsanɨnien, nɨkhakien ehuə tukrarkurao iran. ");
INSERT INTO nwi_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kɨni nɨpɨg narɨmnar mɨnə a kharikakun mhauə mɨsor nəfrakɨsien kɨn, sərer mɨsarha faktə ye neai, meinai pəh nien mə tuktu kapəmiə Kristo tukruə mɨrɨsɨn əmiə.” ");
INSERT INTO nwi_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kɨni In rɨmɨni nuhpɨkɨnien kɨrik kɨmi əriə mɨmə, “Nakharkun-ru nai e fig mɨne nai mɨnə tɨksɨn. ");
INSERT INTO nwi_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tukmə nɨmariə rəsaah, mhapɨr-pɨr mɨn, ramor nɨmtətien mə in nɨpɨg kape nəsimien. ");
INSERT INTO nwi_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ye norien kɨrikianə əmə mɨn, tukmə naksəm narɨmnar mɨnə a ror məknakɨn, ramor nɨmtətien mə pən nien mə tuktu narmaruyen kape Kughen tukruə. ");
INSERT INTO nwi_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Yakamni əfrakɨs tuk əmiə mə narmamə yamə mɨne kasarə ye rao e to khapəh nhamhə-famien kwasɨg ikɨn narɨmnar mɨnə fam e tukrɨtərhav-pə. ");
INSERT INTO nwi_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Napuə mɨne nɨmoptanə tukawəkeikei mɨrarkək, mərɨg nəgkiarien kafak to rɨpəh nɨrkəkien tuk nɨpɨg kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Kɨni Yesu ramrɨpɨn nəgkiarien mɨmə, “Takasəkeikei mɨsərɨg əmiə. Takhapəh nɨsoriahyen nɨpɨg kapəmiə tuk norien əmə lafet, mɨsapɨs kɨn nɨnɨmien, mɨsətərɨg pɨk kɨn narɨmnar kape tokrei tanə, tamə Nɨpɨg Kwasɨg tukruə mor kakur kɨmi əmiə rəmhen kɨn yame kwənməkuru ramhotərəkɨn əmiə, naksakur. ");
INSERT INTO nwi_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Meinai nɨpɨg a tukruə mɨwəh fam narmamə kape tokrei tanə. ");
INSERT INTO nwi_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mərɨg nɨpɨg mɨfam takasəkeikei mɨsərer matuk, kɨni masəkeikei masəhuak mə takhavəh nəsanɨnien rəmhen mə takasərer tɨm tɨm əmə ye nɨpɨg narɨmnar m-fam a tukruə, kɨni in a rɨki Ji Yermamə tukragien tuk əmiə ye nɨpɨg taksərer ye nɨmrɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kɨni nɨpɨg m-fam Yesu raməvhag kɨmi narmamə apa ye Nimə Ehuə kape Kughen, kɨni yenpɨg mɨnə In rɨtərhav mɨvən apa tukwas a kamni kɨmə Olif, mamapɨr aikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kɨni yenpɨg-enpɨg mɨnə fam, narmamə kamhauə mɨsətərɨg kɨn kafan nəgkiarien apa ye nəkwai Nimə Ehuə kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kɨni nɨpɨg kape nəvɨgɨnien e kamni kɨmə Bred yame Yis Rɨrkək iran ruauə ipakə, kɨni lafet a rɨrikakun ye nɨpɨg kape nəvɨgɨnien e kamni kɨmə Nəviərokɨnien. ");
INSERT INTO nwi_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kɨni hae pris mɨnə mɨne nəmhajoun kape Loa kape Moses kasarhakɨn məniwən swatuk tuk nhopniyen Yesu. Kasarhakɨn məniwən swatuk meinai kamhagɨn kɨn narmamə. ");
INSERT INTO nwi_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kɨni Setan rɨmavən yerki Judas, nhagɨn mɨn kɨrik e Iskariot, in yermamə twelef kɨrik kape Yesu. ");
INSERT INTO nwi_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kɨni in rɨmavən məgkiar kɨmi hae pris mɨnə mɨne nəmehuə mɨnə kape mobael kape Nimə Ehuə Kape Kughen, mamharai mhun mə tukreighan-kɨn Yesu rɨvən ye kwermɨriə. ");
INSERT INTO nwi_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kɨni rɨkiriə ragien, kɨni kɨmɨseighan kɨn mə tukhawəh-si pən mane kɨmin. ");
INSERT INTO nwi_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Kɨni Judas reighan kɨn nəgkiarien kapəriə, mə tukror, kɨni mamawhin nɨpɨg yame narmamə tukharkək iran, kɨni reighan-pən kɨn Yesu rɨvən ye kwermɨriə. ");
INSERT INTO nwi_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kɨni nɨpɨg kape lafet e kamni kɨmə Bred Yame Yis Rɨrkək Iran ruauə, kɨni ye nɨpɨg a, narmamə tukasəkeikei mhauh kwaji sipsip tuk nəvɨgɨnien e kamni kɨmə Nəviərokɨnien. ");
INSERT INTO nwi_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kɨni Yesu rɨmnokrən kɨn Pita mɨne Jon, mɨni-pən tuk əriu mə, “Ravən kɨni mwor əpnəpeinə ye nəvɨgɨnien kape Nəviərokɨnien apa ikɨn tukhavən mɨsəvɨgɨn ikɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Kɨni kɨrəni-pən tukun mɨrəmə, “?Nakorkeikei mə kɨmru jakravən hiə mwor apnəpeinə ye nəvɨgɨnien?” ");
INSERT INTO nwi_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Kɨni rɨni-pən tuk əriu mɨmə, “Wətərɨg huvə ru. Nɨpɨg kɨmiru nakratərhav-pən Jerusalem, kɨni takwəm kwən kɨrik ramrəh jag ehuə kɨrik kɨmɨruk pən nu iran. Kɨni takrakwasɨg kɨn mɨrhuvən ye nimə kɨrik yame in ramvən ikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kɨni takrani-pən tuk yemehuə kape nimə mɨrəmə, ‘Yhajoun rɨmnher-pə kɨn əmru mə jakrauə mwaiyoh-pre ik mə ?kwənmhaan a in hiə yame In mɨne kafan mɨnə narmamə tukhavən mɨsor nəvɨgɨnien kape Nəviərokɨnien?’ ");
INSERT INTO nwi_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kɨni in tukrɨkɨr əmiru nakrhuvən apa yerpɨrɨg ye nimə yame kɨmnətu huvə ta narɨmnar kape nəvɨgɨnien aikɨn. Kɨni takwor apnəpeinə ye nəvɨgɨnien aikɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kɨni kɨmɨravən mwəm narɨmnar m-fam rəmhen kɨn yame Yesu rɨmɨni. Kɨni kwor apnəpeinə ye nəvɨgɨnien kape Nəviərokɨnien. ");
INSERT INTO nwi_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kɨni ye nɨpɨg kape nəvɨgɨnien, kɨni Yesu rɨmavən məkwətə-pən ye tebol iriə kafan aposol mɨnə. ");
INSERT INTO nwi_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kɨni mɨni-pən tuk əriə mə, “Pəh nien mə tuktu, kor nəmhəyen kɨmi Yo. Mərɨg yakorkeikei pɨk mə tuksəkupən mɨsor kwis nəvɨgɨnien kape Nəviərokɨnien. ");
INSERT INTO nwi_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yakorkeikei pɨk mə kɨtawə tuksəvɨgɨn məkneikɨn meinai, jakpəh nən-mɨn-ien nəvɨgɨnien kape Nəviərokɨnien meriaji-pən nɨprai nəvɨgɨnien e tukruə mor nəfrakɨsien kɨn ye narmaruyen kape Kughen.” ");
INSERT INTO nwi_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kɨni Yesu rɨmɨwəh kap waen mɨni-vi-vi Kughen tukun, kɨni mɨmə, “Kɨmiə fam havəh mhanɨm, ");
INSERT INTO nwi_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","meinai taktəkun ai yakamni-pre tuk əmiə jakpəh nɨnɨm-mɨnien waen meriaji-pən nɨpɨg Narmaruyen kape Kughen tukruə.” ");
INSERT INTO nwi_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kɨni mɨwəh bred mɨni-vi-vi Kughen tukun, kɨni mhapu, məwhai kɨmi kafan narmamə mɨnə, mɨmə, “In e nɨprak yame yakavəh-sipre kɨmi əmiə. Nɨpɨg nakasən bred e, rɨkimiə tukraməsɨk Yo.” ");
INSERT INTO nwi_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kɨni ye norien kɨrikianə əmə, nɨpɨg kɨmɨsəvɨgɨn ta, Yesu rɨmɨvəh kap waen kɨni mɨni-pən tuk əriə mə, “Kap waen e in nɨtawɨk yame tukraiyu tuk əmiə, kɨni ramhajoun promes vi yame Kughen ramor kɨmi narmamə. ");
INSERT INTO nwi_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Mərɨg taksətərɨg-ru. Kwən kɨrik ikɨn e kasəvɨgɨn kɨtawə min e ye tebol, kɨni in tukreighan-pən kɨn Yo ye kwermɨ tɨkmɨr mɨnə kafak. ");
INSERT INTO nwi_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yo, Ji Yermamə, jakaməkeikei mɨmhə rəri-pən nərɨgien kape Kughen. !Mərɨg, awe! Narpɨnien ehuə tukrɨvən tuk yermamə yame rameighan-pən kɨn Yo ye kwermɨ tɨkmɨr mɨnə kafak.” ");
INSERT INTO nwi_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kɨni kɨnɨsaiyoh əriə mɨnə mhamə, “?Kɨtawə pa tukror norien a?” ");
INSERT INTO nwi_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kɨni nar mɨn kɨrik, iriə kɨmɨsotgoh kɨmi əriə mɨnə mhamə pa nhagɨn irəriə in yerpɨrɨg pɨk rapita əriə. ");
INSERT INTO nwi_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Mərɨg Yesu rɨmɨni-pən tuk əriə mɨmə, “King mɨnə kape tokrei tanə kasarmaru ye narmamə ye kapəriə nəsanɨnien, mamhawəhsi-haktə atuk əriə mə iriə ‘narmamə kape nasituyen.’ ");
INSERT INTO nwi_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mərɨg kɨmiə, takhapəh nɨsorien məknakɨn. Tukmə kɨmiə kɨrik in yerpɨrɨg, in tukrəhsi-əhu in rəmhen kɨn kwajikovə. Kɨni tukmə kɨmiə kɨrik ramərer kupən, kɨni in tukruə rəmhen əmə mə yorwok əmə kɨrik. ");
INSERT INTO nwi_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","?Pa e in yerpɨrɨg pɨk, yermamə yame raməvɨgɨn ye tebol uə yorwok yame ravəh nəvɨgɨnien mamuə? Nakharkun mə yermamə yame raməvɨgɨn ye tebol in yerpɨrɨg rapita. Mərɨg Yo, yemehuə kapəmiə, nɨpɨg yɨmnamarə kɨtawə-m kɨmiə, yakəmhen əmə kɨn yorwok əmə kɨrik. ");
INSERT INTO nwi_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Kɨmiə e, nɨpɨg mɨfam nakasarə ipakə tuk Yo ye nɨpɨg yakamarə ye nɨpɨg əutən mɨnə. ");
INSERT INTO nwi_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kɨni rəmhen əmə kɨn mə Rɨmɨk rawəhsi-haktə Yo mə jakuə king, kɨni Yo mɨn yakawəhsi-haktə əmiə mə takhauə rəmhen kɨn king mɨnə, ");
INSERT INTO nwi_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","mə takhauə mɨsəkwətə kɨtawə, masəvɨgɨn kwis ye nɨpɨg yame jakuə rəmhen kɨn king. Kɨni ye nɨpɨg a, kɨmiə mɨn taksəkwətə ye jea kape king mɨnə, kɨni kɨmiə takhauə mɨsərer kupən ye kwənərəus mɨnə twelef kape Isrel masəkir əriə masarmaru irəriə.” ");
INSERT INTO nwi_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kɨni Yesu rɨni-pən tuk Saemon Pita mə, “Kəsi. Saemon. Setan rɨnaiyoh-pən ta Kughen mə tukreighaan kɨn in pəh in ruə mɨvəhsi-pən vəhsi-pən kɨmi əmiə mor nahasien kɨmi əmiə mə tukəm-ru mə nhatətəyen kapəmiə rɨskai uə nɨkam. ");
INSERT INTO nwi_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mərɨg Saemon, yɨmnəhuak tuk ik mə kafam nhatətəyen tukrɨpəh nɨmɨr-əgkəp-ien. Kɨni nɨpɨg nakamarar ye kafam nətərɨgien mamrerɨg-pə mɨn, ik takaməkeikei mor nətərɨgien kape piam mɨnə tukhaskai.” ");
INSERT INTO nwi_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Mərɨg Saemon Pita rɨmɨni-pən tukun mɨmə, “Yermaru. Yakamərer matuk mə kɨrau mik. Tukvəhsi-pən pawk ərau ye kalabus uə tukhopni pawk ərau.” ");
INSERT INTO nwi_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Mərɨg Yesu rɨni-pən tukun mɨmə, “Pita. Yakamni-pre tuk ik mə tuk yenpɨg, kwasɨg ikɨn man rəkakə, kɨni takni m-kɨsisər mə nakeinein Yo.” ");
INSERT INTO nwi_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kɨni Yesu rɨni-pən tuk əriə mə, “Apa kupən, yɨmnamher-pən kɨn əmiə yerkwanu mɨnə, nɨmnhapəh nhawəhyen mane mɨne nɨtɨp mɨne bag mɨne sandel. ?Mərɨg rhawor irəmiə? ?Nɨmɨsəkwakwə kɨn nar kɨrik uə nɨkam?” Kɨni khani-pən tukun mhamə, “Nɨkam.” ");
INSERT INTO nwi_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kɨni rɨni-pən tuk əriə mə, “Mərɨg taktəkun ai, tukmə kafam mane aikɨn ye nɨtɨp, kɨni takaməkeikei mɨwəh mɨne bag. Kɨni tukmə kafam nau nisə rɨrkək, takaməkeikei mor salem kɨn kafam kot mɨwəh nɨmrɨ nau nisə. ");
INSERT INTO nwi_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Yakamni-pre tuk əmiə mə nəgkiarien e ye Nəkwəkwə Kape Kughen yame raməgkiar irak, tukraməkeikei mor nəfrakɨsien kɨn, e ramni mə, ‘Narmamə khamə-ta mə in yemə-akapɨr loa.’ Ǝwəh, nəgkiarien e ruə mɨnor nəfrakɨsien kɨn ai taktəkun.” ");
INSERT INTO nwi_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kɨni iriə kamhani mhamə, “Yermaru. Ǝmru. Nau nisə kɨraru apa.” Kɨni In rɨmɨni-pən tuk əriə mə, “Ah, nəmhen.” ");
INSERT INTO nwi_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kɨni Yesu rɨmatərhav ye taon mɨvən apa ye tukwas e kamni kɨmə Olif rəmhen kɨn yame ramor nɨpɨg mɨfam. Kɨni kafan narmamə mɨnə khakwasɨg kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kɨni kɨshaktə aikɨn a, rɨni-pən tuk əriə mə, “Takasəkeikei masəhuak mə nar kɨrik to rɨpəh nɨvəh-si-pən vəhsi-pənien kɨmi əmiə mor kapəmiə nhatətəyen rɨmɨr.” ");
INSERT INTO nwi_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kɨni In rɨmɨpəh əriə mɨvən isok kəskəh əmə, mənɨmkur maməhuak mamni mɨmə, ");
INSERT INTO nwi_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tatə, tukmə rɨkim ragien, aweh, vəhsi-ta nəmhəyen yamə mɨne tukpihauə. Mərɨg takpəh norien ye nərɨgien kafak; or əmə ye kafam nərɨgien.” ");
INSERT INTO nwi_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kɨni agelo kɨrik rɨmasɨ-pən ye neai muə mɨvəhsi-pən nəsanɨnien kɨmin. ");
INSERT INTO nwi_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Meinai rɨkin rɨmhə pɨk, kɨni ramətərɨg pɨk, kɨni maməhuak skai. Nəmnhawkien rarkwəməteih iran maiyu rəmhen kɨn yame nɨtaw jir ramaiyu məsɨk nɨmoptanə. ");
INSERT INTO nwi_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nɨpɨg rɨmnəhuak ta, mərer mɨrerɨg-pə mə tukrəm kafan narmamə mɨnə. Kɨni məm əriə kwəsapɨr yeru. Kwəsəpou meinai rɨkiriə raməmhə. ");
INSERT INTO nwi_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kɨni rɨni-pən tuk əriə mɨmə, “?Rhawor nakasapɨr? Sarha, mɨsəhuak mhamə nar kɨrik tukrɨpəh nɨwəhsi-pən wəhsi-pənien kɨmi əmiə mə tukror nhatətəyen kapəmiə tukrəta irak.” ");
INSERT INTO nwi_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nɨpɨg Yesu raməgkiar hanə, kwhen ehuə rɨtərhav-pə tukun, kɨni kwən a Judas, in yermamə kɨrik ye narmamə twelef kape Yesu, in rɨmɨkɨr əriə mhauə. Kɨni rɨmauə ipakə tuk Yesu mə tukrəturəm-pən iran. ");
INSERT INTO nwi_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mərɨg Yesu rɨmɨni-pən tukun mə, “Judas. Yo Ji Yermamə. ?Mərɨg rhawor nakamuə mə takaturɨm-pə irak mameighan-pən kɨn Yo kɨmi tɨkmɨr mɨnə?” ");
INSERT INTO nwi_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kɨni nɨpɨg narmamə kape Yesu kɨmɨsəm narɨmnar mɨnə a, mharkun naha nhagɨn tukor, mhani-pən tukun mhamə, “Yermaru. ?Jakshawor? ?Jaksərai əriə kɨn nau, uə?” ");
INSERT INTO nwi_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kɨni iriə kɨrik rɨmnərai nɨmətɨrgɨ slef kɨrik kape jif pris kɨn nau. ");
INSERT INTO nwi_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mərɨg Yesu rɨmə, “!Ah! !Nəmhen! Səpəh əmə!” Kɨni In rɨrap nɨmətɨrgɨ kwən a kɨni mor huvə mɨn. ");
INSERT INTO nwi_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kɨni Yesu rɨmnəgkiar kɨmi hae pris mɨnə mɨne nəmehuə mɨnə kape mobael kape Nimə Ehuə kape Kughen, mɨne nəmehuə mɨnə kape kwənərəus kape Isrel, yame kɨmnhauə mə tukharaptərəkɨn In. Mɨni-pən tuk əriə mə, “!Eh! ?Nakhamə ta mə Yo yermamə kape narowagɨnien, kɨni nakamhapɨk nau nisə mɨne kwətavhə mɨnə mamhauə mə takharaptərəkɨn Yo uə? ");
INSERT INTO nwi_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nɨpɨg mɨfam yakamarə kɨtawə-m kɨmiə ye Nimə Ehuə kape Kughen. ?Mərɨg rhawor nakhapəh nharaptərəkɨnien Yo aikɨn? Mərɨg taktəkun ai, in nɨpɨg atuatuk kapəmiə- nɨpɨg yame nəpɨgnapien in ramehuə.” ");
INSERT INTO nwi_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kɨni khauə mharaptərəkɨn Yesu mharəh mhavən imei jif pris. Kɨni Pita rɨkwasɨg kɨn əriə, mərɨg rɨpəh nɨvən-pakəyen tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Narmamə mɨnə a kɨmɨsher nap kɨrik ipakə tuk nimə kape hae pris, kɨni mɨsəkwətə rao rao kɨn nap. Kɨni Pita rɨvən məkwətə iriə miriə. ");
INSERT INTO nwi_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kɨni piakəskəh kɨrik yame in yorwok kɨrik rɨmauə məm Pita ramkwətə, nəmrhawənien kape nap rɨsia-pen in. Kɨni pian a rarha tɨm tɨm iran, mɨni-pən tukun mɨmə, “Kwən mɨn e in e iriu Yesu kɨmnaweriwək.” ");
INSERT INTO nwi_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mərɨg Pita rɨmɨni-pən tuk pian a mə, “Pian apa, yakeinein kwən en.” ");
INSERT INTO nwi_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kɨni kwasɨg ikɨn, rɨpəh norien tu, kwən mɨn kɨrik ruə mɨni-pən tuk Pita mə, “Eh. Ik mɨn kɨrik yermamə kafan.” Mərɨg Pita rɨmə, “Eh. Pəh nien mə yo yermamə kafan.” ");
INSERT INTO nwi_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kwasɨg ikɨn, aoa kɨrik ruə muavən ta, kɨni kwən kɨrik raməgkiar skai kɨmi əriə mɨmə, “Yakamni əfrakɨs mə kwən e rɨnaməriwək iriu Yesu, meinai in mɨn in yemə Galili.” ");
INSERT INTO nwi_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mərɨg Pita rɨmə, “Kwən apa, yakpəh-nɨrkun-əgkəpien nəgkiarien e nakamni.” Kɨni Pita raməgkiar hanə, man rəkakə. ");
INSERT INTO nwi_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kɨni Yesu Yermaru rarar mɨvaag-pən məm Pita. Kɨni Pita, rɨkin ruh nəgkiarien kape Yermaru yame rɨmɨni iran mɨmə, “Tuk yenpɨg əmə e, kwasɨg ikɨn man rəkakə, takni m-kɨsisər mə nakeinein Yo.” ");
INSERT INTO nwi_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kɨni Pita rɨmatərhav iruə, rɨmnasək rɨmnasək. ");
INSERT INTO nwi_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kɨni ye nɨpɨg a, narmamə yamə mɨne kɨmnharaptərəkɨn Yesu kɨmɨsarh iakei iran, mamhauh. ");
INSERT INTO nwi_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Mɨsarkɨs ətərəkɨn nɨmrɨn kɨni mhauh, mhani-pən mhamə, “!Eh! !Profet! Ni-ru mə pa ramuh ik!” ");
INSERT INTO nwi_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kɨni kɨmnhani nəgkiarien hah rehuə iran mɨsoriah In. ");
INSERT INTO nwi_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kɨni yenpɨg-yenpɨg kɨn, nəmehuə kape kwənərəus kape Isrel, mɨne hae pris mɨnə, mɨne nəmhajoun kape Loa kape Moses khauə mɨsofugɨn ye kaonsel kapəriə. Kɨni narmamə kharəh Yesu mhauə rərer ye nɨmrɨ kaonsel a. Kɨni narmamə kape kaonsel kɨmnhani-pən tukun mhamə, ");
INSERT INTO nwi_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ni-ru tuk əmawə mə ik e Kristo yame Kughen rɨmɨrpen uə nɨkam.” Mərɨg Yesu rɨni-pən tuk əriə mə, “To yakni pre tuk əmiə, nakhapəh nhaniyen nəfrakɨsien irak. ");
INSERT INTO nwi_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Kɨni to yakaiyoh əmiə, nakhapəh nɨshorpɨnien. ");
INSERT INTO nwi_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mərɨg rɨrikakun ai taktəkun, Yo, Ji Yermamə, Yo jakvən məkwətə ye kwənmhaan kape nəsanɨnien mɨne nɨsiaiyen, in e ye nɨkar Kughen matuk yame Rəsanɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kɨni iriə m-fam kɨsaiyoh-pən tuk Yesu mhamə, “?Rhawor? Ik Ji Kughen uə?” Kɨni Yesu rɨmɨni mə, “Nakamhani məknen, nəfrakɨsien.” ");
INSERT INTO nwi_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kɨni khamə, “To khapəh nhawhinien yermamə mɨn kɨrik mə tukruə mɨni-hah in, meinai kɨmɨsərɨg atuatuk nəgkiarien a ye nherɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kɨni narmamə m-fam kape kaonsel kɨmɨsarar mhakɨr Yesu mhavən kɨmi Paelat. ");
INSERT INTO nwi_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kɨni mharuk-pən nəgkiarien iran mhamə, “Yɨmɨsəm mə kwən e in e ramkɨr kapətawə narmamə mɨnə mamor əriə kasarmər, kɨni mamarar ye nərɨgien kapəriə kasor tɨkmɨr iriə gavman kape Rom, mamni-əhu əriə mə tukhapəh nɨsərokien takis kɨmi Sisa yame ramarmaru ye tanə e. Kɨni in mamni-ərhav mə in Kristo yame Kughen rɨmɨrpen ta mə In king kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kɨni Paelat raiyoh-pən mɨmə, “?Rhawor? ?Ik king kape nəmə Isrel uə?” Mərɨg Yesu rɨmɨni-pən tukun mɨmə, “Nakamni əfrah.” ");
INSERT INTO nwi_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kɨni Paelat rɨni-pən tuk jif pris mɨnə mɨne narmamə m-fam mə, “Yakpəh nəm-pənien nar has kɨrik iran yame ramni mə In rɨmnakapɨr loa kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mərɨg iriə kɨsokr-apomh mamhani mhamə, “Nɨkam. Kwən e raməriwək apnapɨg mamhajoun narmamə mɨfam ikɨn mɨnə ye Judia, rɨrikakun Galili muə meriaji-pə eikɨn e, kɨni mamor nətərɨgien kapəriə kaserwei mɨsarmər.” ");
INSERT INTO nwi_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kɨni nɨpɨg Paelat rɨmnərɨg nəgkiarien a, raiyoh mə, “?Rhawor? ?Kwən e in yemə Galili?” ");
INSERT INTO nwi_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kɨni rɨmnərɨg mə Yesu rɨmatərhav ikɨn a Herod Antipas ramarmaru ikɨn, in mher-pən kɨn Yesu mə tukrɨvən mamərer ye nɨmrɨ Herod, meinai ye nɨpɨg a, Herod mɨn in ramarə Jerusalem. ");
INSERT INTO nwi_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kɨni nɨpɨg Herod Antipas rɨmnəm Yesu, rɨkin rɨmnagien pɨk, meinai rɨmnorkeikei mə tukrəm In ror tu. Herod rɨmnərɨg əmə nəvsaoyen kɨn, kɨni morkeikei mə tukrəm Yesu tukror nɨmtətien kɨrik. ");
INSERT INTO nwi_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kɨni rɨmnaiyoh kɨn nəgkiarien rɨpsaah kɨmi Yesu, mərɨg Yesu ramapnapɨg əmə mɨpəh nhorpɨnien kafan nəgkiarien. ");
INSERT INTO nwi_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kɨni jif pris mɨnə mɨne nəmhajoun kape Loa kape Moses kɨmɨsərer ye nɨmrɨ Herod mamharuk-pən nəgkiarien rɨpsaah ye Yesu. ");
INSERT INTO nwi_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kwasɨg ikɨn, Herod Antipas mɨne kafan mobael mɨnə kɨmɨsarh iakei ye Yesu. Kɨni Herod rɨni-pən tuk kafan mobael mɨnə mə tuksarkaoh-pən kɨn kot huvə kɨrik kɨmin, kɨni mhakɨr mhavən mɨn kɨmi Paelat. ");
INSERT INTO nwi_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kupan ikɨn, Herod Antipas mɨne Paelat kɨmawor tɨkmɨr kɨmi əriu mɨnə. Mərɨg ye nɨpɨg a, iriu kɨmɨrauə kɨrikianə. ");
INSERT INTO nwi_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Kɨni Paelat rɨmnokrən kɨn jif pris mɨnə mɨne nəmehuə mɨnə kape nəmə Isrel, mɨne narmamə m-fam, kɨni iriə mɨfam kɨmnhauə kɨrikianə. ");
INSERT INTO nwi_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Kɨni in rɨmɨni-pən tuk əriə mɨmə, “Kwən e, nɨmnharəh mhauə ramərer ye nɨmrɨk, kɨni nakamhani mhamə ramarar ye nərɨgien kape narmamə kapəmiə, kasor tɨkmɨr kɨmi gavman. Mərɨg yaknəkir ta nərɨgien a ye nɨmrɨmiə, kɨni mɨpəh nəmien mə rɨmnakapɨr loa kɨrik. Nəgkiarien yamə mɨne nakamharuk-pən iran rɨpəh norien nəfrakɨsien kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Kɨni Herod Antipas mɨn, in rɨnəkir mɨn məm mə rɨpəh norien nar has kɨrik. Ror məkneikɨn in rɨmnher-pə mɨn kɨn kɨmi ətawə, kɨni rɨmar əmə tuk nəmien mə kwən a in rɨpəh norien nar has kɨrik mə to khopni in tukun. ");
INSERT INTO nwi_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Pəh kafak mobael mɨnə kɨsərkɨs-ərkɨs əmə in kɨni ai mɨsher-yerhav kɨn pəh ramvən.” ");
INSERT INTO nwi_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ye nɨpɨg kape lafet kape Nəviərokɨnien, Paelat tukraməkeikei mɨrɨsɨn kapəriə kɨrik yermamə rɨtərhav ye kalabus. ");
INSERT INTO nwi_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mərɨg iriə m-fam kɨsokr-apomh mhamə, “!Kɨr ərhav kwən en pəh khopni! !Mərɨg rɨsɨn Barabas rɨrerɨg-pə tuk əmawə!” ");
INSERT INTO nwi_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Kwən e Barabas, kɨmɨvəhsi-pən in ye kalabus meinai in rɨmnor narmamə kamhauh mobael mɨnə kape gavman ye taon a, kɨni in yhopni yermamə). ");
INSERT INTO nwi_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Mərɨg Paelat rorkeikei mə tukrɨrɨsɨn Yesu ramvən, kɨni in məgkiar mɨn kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mərɨg iriə kɨsokr-apomh pɨk mɨn mhamə, “!Ǝsɨk-haktə in ye nai kamarkwao kɨn! !Ǝsɨk-haktə in ye nai kamarkwao kɨn!” ");
INSERT INTO nwi_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mərɨg Paelat rɨmnəgkiar mɨn kɨmi əriə yame ror kɨsisər kɨn, mɨmə, “?Rhawor? ?Kwən a In rɨmnor naha nhagɨn yame rahas? Yo yakpəh nəmien mə In rɨmnor nar has kɨrik yame ratuatuk mə tukhopni In tukun. Mərɨg pəh kafak mobael mɨnə tuksərkɨs-ərkɨs əmə In, kɨni ai mɨsher-yerhav kɨn ramvən.” ");
INSERT INTO nwi_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mərɨg iriə kasəkeikei mɨsəgkiar skai, kɨni masokrən apomh ye Paelat mhamə tukrəsɨk haktə pən ye nai kamarkwao kɨn. Kɨni mɨsokrən apomh mamhavən, mhakurao ye nərɨgien kape Paelat. ");
INSERT INTO nwi_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kɨni Paelat rɨmɨni-ərhav mə Yesu tukraməkeikei mɨmhə rəri-pən nəgkiarien kapəriə. ");
INSERT INTO nwi_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kɨni meighan-pən kɨn ramvən ye kwermɨ kafan mobael mɨnə mə tukharəh mhavən mɨsor nərɨgien kape narmamə mɨnə a. Mərɨg Paelat rɨmɨrɨsɨn Barabas e kupən kɨmɨvəhsi-pən ye kalabus tuk nuhyen mobael kape gavman mɨne nhopniyen yermamə. ");
INSERT INTO nwi_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kɨni nɨpɨg mobael mɨnə kɨmnhakɨr Yesu mhatərhav ye taon, mɨsəm yemə Saerin kɨrik, nhagɨn e Saemon. In rɨmasɨ-pən isok meriwək mamuə ye taon. Kɨni kharaptərəkɨn, mɨsərəhu-pən nai kamarkwao kɨn kape Yesu ye nuran mhamə tukrɨrəh. Kɨni mhani-pən tukun mhamə, “Kwasɨg kɨn Yesu.” ");
INSERT INTO nwi_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kɨni narmamə khapsaah kɨmɨseriwək mamhakwasɨg kɨn Yesu ye swatuk. Kɨni nɨpiraovɨn khapsaah kɨmnhakwasɨg kɨn əriə, mɨsasək, masokrən kɨn Yesu. ");
INSERT INTO nwi_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mərɨg Yesu rarar marha-pən məm əriə, kɨni mɨni-pən tuk əriə mɨmə, “Nɨpian Jerusalem, takhapəh nɨsasəkien tuk Yo; mərɨg sasək atuk tuk əmiə mɨne jimiə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sətərɨg kɨn Yo. Nɨpɨg ramuə tukpini kɨmə ‘Sagien kɨmiə nɨpiraovɨn yamə mɨne naksor siə kɨn əmiə, mɨne yamə mɨne nakhapəh nhavəhsi-pənien nah.’ ");
INSERT INTO nwi_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ye nɨpɨg a, narmamə tukhani-pən tuk tukwas ehuə mhamə, ‘!Aweh! !Ǝkwətəsɨs əmawə!’ Mhani-pən tuk nahak mɨnə mhamə, ‘Ǝkwətəsuun əmawə.’ ");
INSERT INTO nwi_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“?Mərɨg tukmə nap ramuək məkna nɨpɨg nai ramrəmrə, kɨni tukrhawor ye nɨpɨg yame nai ramsiə?” ");
INSERT INTO nwi_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kɨni mobael mɨnə kɨmnharəh kwərə mir kɨraru yamə mir kɨmawəkəpɨr loa mhamə tukshopni ərisɨr Yesu. ");
INSERT INTO nwi_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kɨni kɨmnhauə ikɨn kɨrik e, nhagin e Kerhə Irə Jir. Aikɨn a, kɨmnharuk haktə Yesu ye nai kamarkwao kɨn. Kɨni mharuk haktə mɨn yemə-akapɨr loa mir kɨraru aikɨn, kɨrik ye nɨkar Yesu matuk, kɨni kɨrik ye nɨkarɨn mawor. ");
INSERT INTO nwi_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kɨni Yesu rɨmə, “Tatə, takpəh narpɨn-pənien tai norien has yame kasor irak, meinai kɨseinein naha nhagɨn yame kasor.” Kɨni kɨmɨsəwhai kafan narɨmnar masarukɨn daes tukun. ");
INSERT INTO nwi_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kɨni narmamə yamə mɨne kasərer aikɨn kasəm narɨmnar mɨnə a. Mərɨg nəmehuə mɨnə kape kwənərəus kape Isrel kasarh iakei mɨn ye Yesu mamhani mhamə, “In ruəvəh mɨragh ta narmamə khapsaah. Mərɨg tukmə in Kristo yame Kughen rɨmɨrpen, mɨne in Yemə Kughen Rɨmnher-pə kɨn, pəh rɨvəh mɨragh atuk ru In.” ");
INSERT INTO nwi_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kɨni mobael mɨnə, iriə mɨn kɨsarh iakei ye Yesu, kɨni mhavən ipakə tukun masaiyoh mə rorkeikei waen. (Mərɨg waen a rəukəh pɨk). ");
INSERT INTO nwi_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Mamhani-pən tukun mhamə, “!Tukmə Ik king əfrakɨs kape kwənərəus kape Isrel, vəh mɨragh atuk Ik ai təkun!” ");
INSERT INTO nwi_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kɨni kɨmɨrai-pən nəgkiarien kɨrik ye tənkar nai kɨrik, kəsɨk-pən yerpɨrɨg ye nai kamarkwao kɨn yame ramni mɨmə, “In e king kape nəmə Isrel.” ");
INSERT INTO nwi_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kɨni yemə-akapɨr loa kɨrik yame kɨmarkwətərəkɨn-pən in ye nai kamarkwao kɨn, rɨmnəgkiar has pən kɨmi Yesu mamni mɨmə, “!Eh! ?Ik Kristo yame Kughen rɨmnher-pə kɨn Ik uə nɨkam? Tukmə ror məknenkɨn, vəh mɨragh Ik kɨni mɨvəh mɨragh mɨn əmru.” ");
INSERT INTO nwi_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mərɨg yemə-akapɨr loa kɨrik mɨn rɨmɨni-pən tuk in kɨrik, mɨni-əhu mɨmə, “?Rhawor? Natakmhə pawk, mərɨg nakpəh nɨsiaiyen Kughen. Narpɨnien e kapətasɨr in rəm nəmhen əmə. ");
INSERT INTO nwi_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mərɨg ratuatuk əmə mə kɨrau tukrɨmhə tuk kapərau norien has yame mɨne kɨmɨwor. Mərɨg kwən a rɨpəh norien nar has kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kɨni mɨni-pən tuk Yesu mɨmə, “Yesu, ye nɨpɨg takuə mor king iran, pəh rɨkim tukraməsɨk yo.” ");
INSERT INTO nwi_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Kɨni Yesu rɨmɨni-pən tukun mɨmə, “Yakamni-pre əfrakɨs tuk ik, mə towei əmə, kɨrau mik tukwarə apa ye rao ye neai.” ");
INSERT INTO nwi_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Kɨni ipakə tuk twelef klok yerkweiha, mɨrh rɨpəh nəsiəyen, kɨni nəpɨgnapien rɨmneiwaiyu-pə məmɨr meriaji-pən tri klok yenaiyu. Kɨni ye nəkwai Nimə Ehuə kape Kughen, kɨmɨruk haktə neipən kɨrik yame kɨmnətapɨg kɨn Kwənmhan yame Rəmərhakə Məmərhakə pɨk. Neipən a rəhipu nɨpərɨn kɨraru. ");
INSERT INTO nwi_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kɨni Yesu rɨmnokrən apomh mɨmə, “Tatə. Yakamərəhu-pre nɨmraghien kafak ye kwermɨm.” Nɨpɨg rɨmnəgkiar ta, kɨni kafan neihagien rɨtərhav. ");
INSERT INTO nwi_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kɨni nɨpɨg yemehuə kape mobael mɨnə kape nəmə Rom rɨmnəm narɨmnar mɨnə a, rəgnəgɨn Kughen mamni mɨmə, “!Nəfrakɨsien, kwən a In yemə atuatuk!” ");
INSERT INTO nwi_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kɨni narmamə yamə mɨne kɨmnhauə aikɨn a mhamə tuksəm, nɨpɨg kɨmɨsəm narɨmnar mɨnə a, kɨmnhavən mɨsərɨg rahah yerkiriə, kɨni mɨsərɨp nɨmagɨriə. ");
INSERT INTO nwi_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Kɨni narmamə tɨksɨn kape Yesu, mɨne nɨpiraovɨn yamə mɨne kɨmnhasɨ-pən Galili, mamhakwasɨg kɨn Yesu mamhauə, iriə kɨmɨsərer isok kəskəh, masəm narɨmnar mɨnə a. ");
INSERT INTO nwi_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Kɨni yemə Aramatia kɨrik aikɨn, nhagɨn e Josef. Aramatia in taon kɨrik apa Isrel, kɨni kwən a in yermamə kɨrik kape kaonsel kape nəmə Isrel. In yemə huvə, kafan nɨmraghien ratuatuk, kɨni in yermamə kɨrik yame rɨmnawhin mə tukrəm narmaruyen kape Kughen. Kɨni in rɨmɨpəh neighanien kɨn nəgkiarien kape kaonsel yame kɨmɨseighan-pən kɨn Yesu mə tukhopni. ");
INSERT INTO nwi_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kɨni in rɨmavən məm Paelat maiyoh-pən in mə tukreighaan kɨn nɨprai Yesu pəh rɨrəh. ");
INSERT INTO nwi_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kɨni Josef rɨmavən mɨrəhsi-əhu nɨprai Yesu ye nai kamarkwao kɨn, mɨrəh mɨvən muvrɨg kɨn neipən huvə kɨrik e kamni kɨmə linen. Kɨni mɨrəh mɨvən mərəhu-pən ye nəpəəg kapier yame kɨnɨrai ta tuk norien suranə ikɨn, mərɨg kɨpəh hanə nɨnɨmien yermamə kɨrik aikɨn. ");
INSERT INTO nwi_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","In a ye nɨpɨg yame nəmə Isrel kasor apnəpeinə iran tuk Sabat, kɨni ipakə Sabat rɨrikakun. ");
INSERT INTO nwi_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kɨni nɨpiraovɨn yamə mɨne kɨmnhasɨ-pən Galili mamhakwasɨg kɨn Yesu, kɨmnhakwasɨg kɨn kwən a, mhavən mɨsəm nəpəəg kapier a. Kɨni mɨsəm mə Josef rɨmnhawor pən iran mɨne mərəhu nɨprai Yesu. ");
INSERT INTO nwi_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kɨni ai, nɨpiraovɨn mɨnə a kɨmnharerɨg-pən yerkwanu mə tuksor apnəpeinə ye nɨmar nai mɨnə tɨksɨn mɨne pomad yame nəmiovriə rapien huvə mə tuksor-pən ye nɨprai Yesu. Mərɨg ye Sabat, iriə kɨsapɨs rəri-pən loa. ");
INSERT INTO nwi_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kɨni Sande, yenpɨg-enpɨg əgkəp, nɨpiraovɨn mɨnə kɨmnhavən apa ye nəpəəg kapier, mhapɨk nar pien-pien yamə mɨne nəmiovriə rapien huvə, yamə mɨne kwəsor apnəpeinə ta iran. ");
INSERT INTO nwi_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nɨpɨg kɨmnhauə ipakə tuk nəpəəg kapier, mɨsəm kapier yame kɨmnətapɨg kɨn ye nəpəəg kapier, mərɨg kɨnəsuə ta kɨn. ");
INSERT INTO nwi_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kɨni kɨmɨsauru-pən imə ye nəpəəg kapier, mhapəh nɨsəmien nɨprai Yesu Yermaru. ");
INSERT INTO nwi_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kɨni mɨseinein apomh masətərɨg kɨn narɨmnar mɨnə a. Məkneikɨn, yermamə kɨraru kratərhav-pə, mwərer iriə miriə. Mɨravən ye neipən yame rhawən maməsiə. ");
INSERT INTO nwi_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kɨni nɨpian mɨnə a kɨmnhagɨn pɨk, mɨsənɨmkur. Kɨni kwərə mir a krəmə, “?Rhawor nakasarha kɨn yemə ruəmragh ta e imei nəmə mhə mɨnə? ");
INSERT INTO nwi_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","In ruɨrkək eikɨn e. !In ruəmragh mɨn! Rɨkimiə tukraməkeikei maməsɨk-ru nəgkiarien yame rɨmɨni-pre tuk əmiə ye nɨpɨg yame rɨnamarə apa Galili mɨmə, ");
INSERT INTO nwi_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Narɨmnar mɨnə e tukasəkeikei mhauə mɨsor nəfrakɨsien kɨn. Tukeighan-pən kɨn Yo, Ji Yermamə, yakvən ye kwermɨ yor təvhagə has mɨnə, kɨni tukruk haktə Yo ye nai kamarkwao kɨn kɨni jakmhə. Mərɨg nɨpɨg yame ror kɨsisər kɨn, jakaməkeikei mamragh mɨn.’” ");
INSERT INTO nwi_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kɨni rɨkiriə rɨmnaməsɨk nəgkiarien a kape Yesu. ");
INSERT INTO nwi_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Mhatərhav ye nəpəəg kapier, mhavən mhani-pən narɨmnar mɨnə a tuk narmamə leven kape Yesu, mɨne kafan mɨnə m-fam. ");
INSERT INTO nwi_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kɨni nɨpiraovɨn yamə mɨne kɨmnhani-ərhav narɨmnar mɨnə a kɨmi aposol mɨnə, iriə e Meri Magdala, Joana, Meri nɨsɨn Jemes, mɨne nipiraovɨn mɨnə mɨn tɨksɨn yamə mɨne kɨmnhavən ye nəpəəg kapier. ");
INSERT INTO nwi_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mərɨg aposol mɨnə kɨmɨsərɨg nəgkiarien a, khamə nəgkiarien armər kɨrik yame nɨpran rɨrkək, mhapəh nhaniyen nəfrakɨsien iran. ");
INSERT INTO nwi_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mərɨg Pita rərer maiyu mɨvən apa ye nəpəəg kapier, məmrəmɨr mɨvaag-pən məm əmə neipən yame kɨmuvrɨg nɨprai Yesu kɨn, mərɨg nar mɨn kɨrik rɨrkək. Kɨni in rarar mɨrerɨg mɨvən yerkwanu, kɨni mamətərɨg pɨk kɨn norien a. ");
INSERT INTO nwi_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ye nɨpɨg əmə in a, yermamə kɨraru kape Yesu kɨmaweriwək mɨravən yerkwanu kɨrik, nhagɨn e Emeas. Yerkwanu a isok tuk Jerusalem rəmhen kɨn leven kilometa. ");
INSERT INTO nwi_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kɨni ye nɨpɨg iriu kweriwək mɨravən, kɨni marəni narɨmnar yamə mɨne rɨmatərhav-pə. ");
INSERT INTO nwi_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mwəgkiar hanə, kɨni Yesu rɨvən ipakə tuk əriu, mɨrhəriwək kwis marhɨvən. ");
INSERT INTO nwi_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mərɨg kɨrɨpəh nɨrhɨrkunien mə pa irisɨr miriu krhəriwək, meinai Kughen rɨmnətapɨg kɨn ye nərɨgien kapəriu. ");
INSERT INTO nwi_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kɨni Yesu rɨmɨni-pən tuk əriu mɨmə, “Kwərə mir. ?Naha e nakarəni?” Məkneikɨn kwərer, rɨkiriu rəpou. ");
INSERT INTO nwi_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kɨni iriu kɨrik, nhagɨn e Kleopas, rɨmɨni-pən tukun mɨmə, “Tukmə ror Ik yepsɨpɨs əmə kɨrik e Jerusalem, yame reinein narɨmnar yamə mɨne rɨmatərhav-pə ye nɨpɨg yamə mɨne ruauə ta muavən.” ");
INSERT INTO nwi_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kɨni raiyoh əriu mɨmə, “?Naha mɨnə e?” Kɨni kɨrəni-pən tukun mɨrəmə, “Narɨmnar yamə mɨne kɨmnor ye Yemə Nasaret e Yesu. In profet kɨrik kape Kughen, kɨni kafan wok rəsanɨn huvə mɨne kafan nəgkiarien mɨnə khapam. Kɨni rɨki Kughen mɨne rɨki narmamə ragien tukun. ");
INSERT INTO nwi_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mərɨg kapəmawə hae pris mɨnə mɨne nəmhajoun kape Loa kape Moses kɨmnharəhsi-pən In ye kwermɨ nəmə Rom mə tuksəkir mɨsəm mə In tukrɨmhə. Kɨni kɨmɨsəsɨk haktə In ye nai kamarkwao kɨn, kɨni rɨmhə. ");
INSERT INTO nwi_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Narɨmnar a rɨnor ta ruəvəh nɨpɨg kɨsisər. Mərɨg kɨmawə yɨmɨsərəhu-pən pawk kapəmawə nərɨgien skai iran mə In tukrɨrɨsɨn əmawə kwənərəus mɨnə kape Isrel ye kwermɨ tɨkmɨr mɨnə kapəmawə. ");
INSERT INTO nwi_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nar kɨrik mɨn, nɨpiraovɨn tɨksɨn irəmawə kɨmɨsor əmawə yaksakur tuk nəgkiarien kɨrik. Towei, yenpɨg-enpɨg əgkəp, kɨmnhavən apa ye nəpəəg kapier yame kɨmɨnɨm Yesu ikɨn, ");
INSERT INTO nwi_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","mhapəh nɨsəmien nɨpran. Mharerɨg-pə mhani mhamə, ‘Yɨmɨsəm nəmrərhavyen kɨrik. In e agelo mir kɨraru kɨrəni-pə tuk əmawə mɨrəmə, “Yesu ramragh.” ’ ");
INSERT INTO nwi_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kɨni kapəmawə narmamə tɨksɨn kɨmnhavən ye nəpəəg kapier, masəm narɨmnar fam əgkəp ratuatuk rəmhen kɨn yame nɨpiraovɨn mɨnə a kɨmnhani. Mərɨg khapəh nɨsəmien Yesu.” ");
INSERT INTO nwi_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kɨni In rɨni-pən tuk əriu mɨmə, “Kwərə mir. Kapəmiru kapə rɨrkək. Naksor pɨk kəmar tuk nɨniyen nəfrakɨsien ye nəgkiarien yame profet mɨnə kape Kughen kɨmnhani. ");
INSERT INTO nwi_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","?Nakrarkun uə nɨkam mə Kristo yame Kughen rɨmɨrpen tukraməkeikei mamərɨg nəmhəyen ye nɨpran, kɨni kwasɨg ikɨn, In tukrɨpivən apa ye rao ye neai mɨvəh nhag kape nɨsiaiyen?” ");
INSERT INTO nwi_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kɨni Yesu rɨmnhoprai-pən Nəkwəkwə kape Kughen kɨmi əriu yame raməgkiar iran, rɨrikakun ye nəkwəkwə mɨnə kape Moses muə meriaji-pə nəkwəkwə mɨnə kape profet mɨnə kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kɨni kɨnarhuə ipakə tuk yerkwanu yame kwərə mir a kɨravən ikɨn, mərɨg kwəm mə rameriwək mamvən. ");
INSERT INTO nwi_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kɨni iriu kawəkeikei kɨmin mɨrəmə, “Eh. Rhuvə mə takaməmɨr kɨtasɨr, meinai rɨnəpɨgnəp ta. Pəh nien mə tuktu mɨrh rivə.” Kɨni rɨmavən məm əriu marhəkwətə. ");
INSERT INTO nwi_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kɨni kɨnarhəkwətə mə tukrhəvɨgɨn, kɨni In rɨvəh bred mɨni vi vi Kughen tukun, kɨni mhapu mɨgəhsi-pən kɨmi əriu. ");
INSERT INTO nwi_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Məkneikɨn Kughen rɨmnor kɨrarkun mə In Yesu. Taktəkun əmə rɨrkək mɨn, kɨrəpəh nɨwəmien In. ");
INSERT INTO nwi_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kɨni kɨrəni-pən tuk əriu mɨrəmə, “Eh. Nəfrakɨsien mə nɨpɨg In rɨmnamhoprai-pə huvə Nəgkiarien kape Kughen kɨmi ərau ye swatuk, kɨni kwərɨg huvə kɨn, rɨkirau ramagien pɨk.” ");
INSERT INTO nwi_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kɨni taktəkun əmə mɨn kɨmɨwərer mɨratərhav aikɨn a mɨrarerɨg mɨn mɨravən Jerusalem. Kɨni ikɨn a, iriu kɨmɨwəm nəmə leven kape Yesu mɨne narmamə tɨksɨn mɨn kafan kwənhauə mɨsofugɨn ta mɨsəkwətə. ");
INSERT INTO nwi_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Mamhani-pən tuk əriə mhamə, “Nəfrakɨsien. Yesu Yermaru rɨmɨmragh mɨn, kɨni Saemon Pita rɨnəm ta.” ");
INSERT INTO nwi_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kɨni iriu kɨrəni-pən fam narɨmnar yame rɨmatərhav-pə tuk əriu ye swatuk, kɨni mɨrəni-pən nɨpɨg yame iriu kɨmɨrarkun Yesu iran, ye nɨpɨg yame In rɨmnhapu bred mɨvəhsi-pən kɨmi əriu. ");
INSERT INTO nwi_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kɨni nɨpɨg kɨrəni nəgkiarien a, Yesu ruə mərer ye kwerkwan irəriə mamni-pən tuk əriə mə, “Pəh nəmərinuyen tukramarə tuk əmiə.” ");
INSERT INTO nwi_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mərɨg iriə kɨsakur pɨk kɨn, kɨni mhagɨn kɨn. Khamə ta mə yarmhə. ");
INSERT INTO nwi_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mərɨg In rɨni-pən tuk əriə mɨmə, “?Rhawor nakamhagɨn məkneikɨn? ?Rhawor kapəmiə nətərɨgien ramor kɨraru? ");
INSERT INTO nwi_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Taksəm-ru kwermɨk mir mɨne nɨhuk mir. Yo əmə e. Sərao-pə mharap nɨprak kɨni mharkun mə Yo e. Nanmɨ yermamə nɨpran mɨne nɨkəkrin rɨrkək, rɨpəh norien məkneikɨn. Nakasəm Yo, nɨprak mɨne nɨkəkrik aikɨn.” ");
INSERT INTO nwi_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Rɨmɨni nəgkiarien a, mhajoun kwermɨn mir mɨne nɨhun mir kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Iriə khapəh nhani-əgkəpien nəfrakɨsien iran, meinai rɨkiriə rɨmnamagien pɨk, kɨni kɨsakur pɨk kɨn. Mərɨg In rɨmnaiyoh əriə mɨmə, “Havəhsi-pə-ru nəvɨgɨnien kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kɨni kɨmɨvəhsi-pən kəməəm kɨrik yame kɨmnhavaan ye nap kɨmin. ");
INSERT INTO nwi_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Kɨni rən ye nɨmrɨriə. ");
INSERT INTO nwi_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kɨni Yesu rɨmɨni-pən tuk əriə mɨmə, “In apa kupən, nɨpɨg yɨmnamarə kɨtawə-m kɨmiə, yɨmɨni nəgkiarien e tuk əmiə mə, ‘Narɨmnar mɨnə fam yame kamhani irak ye Nəkwəkwə kape Kughen, tukraməkeikei muə mor nəfrakɨsien kɨn. In e nəgkiarien mɨnə ye nəkwəkwə mɨnə kape Moses mɨne nəkwəkwə kape profet mɨnə kape Kughen, mɨne Ol Sam.’” ");
INSERT INTO nwi_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kɨni In rəhitə ye nərɨgien kapəriə mə tukharkun nɨprai nəgkiarien ye Nəkwəkwə kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Mɨni-pən tuk əriə mɨmə, “Nəgkiarien yame raməmɨr ye Nəkwəkwə kape Kughen ramni mə ‘Narmamə tuksor ahas pən kɨmi Kristo yame Kughen rɨmɨrpen. Masor rərɨg nəmhəyen ye nɨpran meriaji mɨmhə. Mərɨg ye nɨpɨg yame ror kɨsisər kɨn, In tukramragh mɨn ye nɨmhəyen.’ ");
INSERT INTO nwi_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kɨni ye nhagɨk, narmamə tukasəkeikei mhani-ərhav nəgkiarien a mhamə narmamə tukasəkeikei mɨsarar ye nərɨgien kapəriə tuk təvhagə has, kɨni Kughen tukrɨpəh narpɨnien tai təvhagə hah kapəriə, kɨni məru-kɨn kapəriə norien has mɨnə. Nəgkiarien e tukraməkeikei mɨvən kɨmi kwənərəus mɨnə fam apa ikɨn mɨnə fam. Rɨrikakun Jerusalem, mɨvən meriaji pən ikɨn mɨnə fam ye tanɨmtanə. ");
INSERT INTO nwi_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kɨmiə nɨmɨsəm narɨmnar mɨnə e, kɨni takhani-ərhav atuatuk nəgkiarien mɨnə iran. ");
INSERT INTO nwi_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mərɨg taksəmɨr ye taon e mamhawhin mɨseriaji takhavəh nəsanɨnien kape Nanmɨn kape Kughen, kɨni tukrɨkwar ye nɨmraghien kapəmiə. Yo jakher-pən kɨn In rəmhen kɨn yame Rɨmɨk rɨmɨrpen ta mə tukror.” ");
INSERT INTO nwi_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kɨni Yesu rɨmɨkɨr əriə mhatərhav ye taon, mhavən yerkwanu a Betani. Kɨni rɨmɨvəhsi-haktə kwermɨn mir maməhuak mɨvəhsi-pən nɨhuvəyen kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kɨni nɨpɨg raməhuak hanə, mɨpəh əriə. Kughen rɨvəh In mamhaktə ye neai. ");
INSERT INTO nwi_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kɨni kasəgnəgɨn In, mharerɨg pən Jerusalem, rɨkiriə ragien. ");
INSERT INTO nwi_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kɨni nɨpɨg mɨnə fam kamhavən ye Nimə Ehuə kape Kughen mamhani vi vi Kughen. ");
INSERT INTO nwi_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Apa kupan əgkap, ye nɨrikakunien, Nəgkiarien rɨmnəmɨr ta. Nəgkiarien e rɨmnamarə iriu Kughen. Kɨni Nəgkiarien e, in Kughen. ");
INSERT INTO nwi_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nɨpɨg Kughen rɨpəh hanə norien narɨmnar, in rɨnarə rerɨn ta iriu Kughen. ");
INSERT INTO nwi_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kɨni Kughen rɨmnor narɨmnar fam ye nəgkiarien a, kɨni narɨmnar fam yame Kughen rɨmnor, nar kɨrik mɨn rɨkək yame Nəgkiarien a rɨmɨpəh norien. ");
INSERT INTO nwi_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","In e, in Nuknei nɨmraghien, kɨni nɨmraghien e, in nɨkakien yame raməsia-pen narmamə mɨfam. ");
INSERT INTO nwi_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nɨkakien a raməsia-pen nəpɨgnəpien, kɨni nəpɨgnəpien to rɨpəh napitayen. ");
INSERT INTO nwi_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yermamə kɨrik yame Kughen rher-pə kɨn mə tukruə, nhagɨn e Jon Baptaes. ");
INSERT INTO nwi_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","In rɨmnərer-ərhav mə tukrɨni-ərhav-pən nɨkakien a kɨmi narmamə, pəh iriə m-fam tukhani nəfrakɨsien iran. ");
INSERT INTO nwi_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Pəh nien mə Jon in nɨkakien, mərɨg in rɨmauə əmə mə tukrɨni-ərhav nɨkakien a kɨmi narmamə m-fam. ");
INSERT INTO nwi_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nəgkiarien a rɨmauə ye tokrei tanə, kɨni in nɨkakien əfrakɨs, yame raməsia-pen narmamə m-fam ye tokrei tanə. ");
INSERT INTO nwi_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nar apnapɨg mə Kughen rɨmnor tokrei tanə ye Nəgkiarien a, kɨni rɨmnamarə ye tokrei tanə e, mərɨg narmamə kape tokrei tanə kɨmɨseinein In. ");
INSERT INTO nwi_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Rɨmauə ye tanə yame in kafan əmə tanə, mərɨg narmamə yame In rɨmɨrpen əriə kɨmnhaukreikɨn-pən nɨmeitairiə kɨm In, mhapəh nɨsorkeikeiyen In. ");
INSERT INTO nwi_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mərɨg narmamə m-fam yamə mɨne kamhavəh In yerkiriə, rɨkiriə ragien tukun, mɨshatətə ye nhagɨn, kɨni In rameighan kɨn əriə mə tukhauə kwajikovə mɨnə kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Pəh nien mə kwajikovə mɨnə a kape Kughen kasarha-pə rəmhen kɨn yame kwajikovə mɨnə kape tokrei tanə kasarha. Pəh nien mə nərɨgien kape yermamə, uə kape tatə, yame kasarha iran. Mərɨg kasarha wi mɨn ye Kughen, ye kafan nəsanɨnien. ");
INSERT INTO nwi_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nəgkiarien a rɨmauə yermamə mamarə kɨtawə min. Kɨmawə yɨmɨsəm kɨn nɨmrɨmawə nehuəyen kafan. In e, in nehuəyen kape Kwənkwan kɨrikianə Ǝmə, yame rɨmasɨ-pən ye Tatə Kughen. In rukwar kɨn nɨhuvəyen yame ramautə-pə kɨn kɨmi ətawə, kɨni rukwar mɨn kɨn nəfrakɨsien. ");
INSERT INTO nwi_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon rɨmnərer-ərhav mamokrən apomh mɨmə, “Yermamə e in e yame yɨmnamni mɨmə, ‘Yo jakəkupən, kɨni kwən kɨrik mɨn aikɨn yame tukrɨpikwasɨg kɨn yo. Mərɨg In yerpɨrɨg rapita yo. Meinai nɨpɨg yɨmɨpəh hanə narhayen, mərɨg In rɨnarə rerɨn ta.’” ");
INSERT INTO nwi_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kɨni In rukwar kɨn nɨhuvəyen yame ramautə-pə kɨn kɨmi ətawə, kɨni nɨpɨg m-fam In ravəhsi-pə nɨhuvəyen kafan kɨmi ətawə. ");
INSERT INTO nwi_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ror məkneikɨn meinai Moses in swatuk kupan yame Kughen rɨmɨvəhsi-pə loa kɨmi ətawə, mərɨg Yesu Kristo in swatuk yame Kughen ramautə-pə kɨn kafan nɨhuvəyen mɨne nəfrakɨsien kɨmi ətawə. ");
INSERT INTO nwi_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Narmamə to khapəh nɨsəmien Kughen. Mərɨg Tɨni Kwənkwan Kɨrikianə Ǝmə, yame ramərer ye nɨkar Kughen, in Kughen. In rɨmnor əpu Kughen kɨmi ətawə kɨni kɨtawə kharkun In. ");
INSERT INTO nwi_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kɨni nəmehuə mɨnə tɨksɨn ye kwənərəus kape Isrel yamə mɨne kɨmnɨsarə Jerusalem, kɨsher-pən kɨn pris tɨksɨn mɨne Lifaet tɨksɨn mə tukhavən mɨsəm Jon Baptaes mɨsaiyoh in mhamə, “Eh. ?Ik naha yermamə?” Ror məkneikɨn, Jon rɨmɨni-ərhav in. ");
INSERT INTO nwi_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nɨpɨg kɨmɨsaiyoh in mə in pa, in rɨpəh nerkwaigien kɨn, mərɨg rɨmɨni-pən atuatuk əmə in tuk əriə mɨmə, “Pəh nien mə yo Kristo yame Kughen rɨmɨni mə tukrher-pə kɨn.” ");
INSERT INTO nwi_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kɨni iriə kɨmnhani mhamə, “?Tukmə pəh nien mə ik Kristo, kɨni ik pa? ?Ik Elaeja uə?” Mərɨg Jon rɨmə, “Nɨkam. Pəh nien mə yo Elaeja.” Kɨni iriə kɨmɨsaiyoh mɨn in mhamə, “?Tukmə pəh nien mə ik Elaeja, kɨni ik pa? ?Ik profet kape Kughen yame kɨmɨni kupan mə tukruə uə?” Mərɨg Jon rɨmə, “Nɨkam.” ");
INSERT INTO nwi_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kɨni iriə kɨmnhani mhamə, “Ik takaməkeikei mɨni-ərhav ik kɨmi əmawə, pəh kɨmawə jakhavən mhani-əsah-pən kɨmi narmamə yamə mɨne kɨmɨsher-pə kɨn əmawə.” ");
INSERT INTO nwi_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Kɨni rɨni-pən tuk əriə mɨmə, “Yo e yermamə yame profet Aesea rɨmɨni-ərhav ta kupan mə, “‘Yermamə kɨrik tukrokrən apomh apa ye tɨpəvsɨk mamni mɨmə, “Kɨmiə taksor huvə swatuk kape Kughen Yermaru.” ’” ");
INSERT INTO nwi_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Kɨni Farisi mɨnə kɨmɨsher-pən kɨn narmamə tɨksɨn mɨn khauə apaikɨn, ");
INSERT INTO nwi_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","mɨsaiyoh-pən Jon mhamə, “?Tukmə pəh nien mə Ik Kristo, kɨni pəh nien mə ik Elaeja, kɨni pəh nien mə ik profet a yame kɨmɨsəvsao kɨn kupan, kɨni rhawor e nakamor baptaes ye narmamə?” ");
INSERT INTO nwi_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Kɨni Jon rhorpɨn nəgkiarien kapəriə mɨmə, “Yo yakamor baptaes ye narmamə ye nu, mərɨg yermamə kɨrik ramərer ye kwerkwan irəmiə yame nakseinein In. ");
INSERT INTO nwi_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yo yakaməkupan, kwən a tukrɨkwasɨg, mərɨg In yerpɨrɨg, kɨni yo yetanə əmə. Yakpəh nəmhenien tuk nɨrɨsɨn-tayen sandel kafan.” ");
INSERT INTO nwi_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Narɨmnar a rɨmnor əfrakɨs apa yerkwanu kɨrik, kamni kɨmə Betani. In apa nɨkar nu Jodan pən- apa ikɨn Jon rɨmnor baptaes ye narmamə ikɨn. ");
INSERT INTO nwi_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kəni rɨkwamer kɨn, Jon rɨmnəm Yesu raməriwək mamuə, kɨni rɨni-ərhav mɨmə, “!Ei! !Səm-ru! Kwən e in e in rəmhen kɨn kwaji sipsip kape Kughen, meinai in tukrɨrɨsɨn ta narpɨnien kape norien has mɨnə kape narmamə ye tokrei tanə. ");
INSERT INTO nwi_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yermamə e in e yɨmnaməvsao kɨn kɨmi əmiə mɨmə, ‘Yo jakəkupən, kɨni kwən kɨrik mɨn aikɨn tukrɨkwasɨg kɨn yo. Mərɨg In yerpɨrɨg rapita yo. Meinai nɨpɨg yɨmɨpəh hanə narhayen, In rɨnarə rerɨn ta.’ ");
INSERT INTO nwi_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nɨpɨg yo yɨmnaməvsao kɨn In, kɨni yo mɨn meinein mə In pa; mərɨg yɨmauə mor baptaes ye narmamə ye nu mə jakor əpu kwən a kɨmi kwənərəus mɨnə kape Isrel.” ");
INSERT INTO nwi_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Kɨni ai, Jon rɨmnərer-ərhav mamni mɨn mɨmə, “Kughen rɨmnher-pə kɨn yo mə yo jakor baptaes ye narmamə kɨn nu, kɨni nɨpɨg yɨmnaməvsao kɨn in, yo mɨn yɨmneinein mə kwən ai in a. Mərɨg Kughen rɨmɨni-pə tuk yo mɨmə, ‘Takəm Nanmɨn kafak tukreiwaiyu mərer-pən ye yermamə kɨrik. Kɨni kwən e In e In tukror baptaes ye narmamə kɨn Nanmɨn Rhakə.’ Kɨni ai, yɨmnəm Nanmɨn Kape Kughen rɨsɨ-faktə ye neiai rəmhen kɨn mak meiwaiyu məkwətə-pən ye yermamə kɨrik. ");
INSERT INTO nwi_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yɨmnəm atuatuk nar a, kɨni mərer-ərhav mamni-ərhav mɨmə, ‘Kwən e in e, in Ji Kughen əfrakɨs.’” ");
INSERT INTO nwi_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kəni rɨkwamer kɨn, Jon rɨmavən mɨn apaikɨn irisɨr yermamə kɨraru kafan. ");
INSERT INTO nwi_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kɨni məm Yesu raməriwək ye swatuk mamuə, kɨni rɨni-pən tuk əriu mɨmə, “!Eh! !Wəm-ru! Kwən e In e in Kwaji sipsip kape Kughen.” ");
INSERT INTO nwi_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kafan yermamə mir kɨmɨwərɨg nəgkiarien a, mwərer, mɨrakwasɨg kɨn Yesu. ");
INSERT INTO nwi_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Kɨni Yesu rarar məm kwərə mir a karakwasɨg kɨn In, kɨni In rɨmə, “!Eh! Kwərə mir. ?Nəkawarha-kɨn naha?” Kɨni iriu krəmə, “Rabae. ?Nakamarə hiə?” (Nəgkiarien e rabae, nɨpran ramni mə “yhajoun”). ");
INSERT INTO nwi_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Kɨni Yesu rɨmɨni-pən tuk əriu mɨmə, “Pəh krhɨvən, nakwəm-ru ikɨn yakamarə ikɨn.” Kɨni iriu kɨmɨrakwasɨg kɨn, mɨrhuvən, kɨni mwəm ikɨn ramarə ikɨn. Ipakə mɨrh rivə, irisɨr min kɨmnarhəmɨr mɨrheriaji rəpɨgnəp. ");
INSERT INTO nwi_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Kwərə mir a kɨrik rɨmnərɨg nəgkiarien yame Jon rɨmɨni marar mamkwasɨg kɨn Yesu, nhagɨn e Andru, naorahi Saemon Pita. ");
INSERT INTO nwi_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Məkneikɨn, Andru rɨmavən məm piauni Saemon, rɨkɨr mɨrauə, kɨni mɨni-pən tukun mɨmə, “!Eh! Yaknəm ta Mesaea.” (Nəgkiarien e Mesaea, nɨpran rɨmə “Kristo,” yame Kughen rɨmɨrpen mə tukrher-pə kɨn). ");
INSERT INTO nwi_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kɨni Andru rɨkɨr Saemon mɨravən mɨwəm Yesu. Kɨni Yesu rəm in, mɨmə, “Ik e Saemon, kwajikovə kape Jon. Mərɨg taktakun ai, tukokrən kɨn ik kɨmə ‘Kefas.’” (Nhag e Kefas, nɨpran ramni mə kapier. Ye nəgkiarien kape nəmə Gris kamni kɨmə Pita). ");
INSERT INTO nwi_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kəni rɨkwamer kɨn, Yesu rɨkin raməsɨk mə tukrɨvən apa Galili. Kɨni məm kwən kɨrik, nhagɨn e Filip, mɨni-pən tukun mɨmə, “Yuə mɨkwasɨg kɨn Yo.” ");
INSERT INTO nwi_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip in yemə Betsaeda, imei Andru mɨne Pita. ");
INSERT INTO nwi_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Kɨni Filip rɨvən məm Nataniel mɨmə, “Kɨmawə yakwəsəm kwən apera, yame Moses rɨmnaməvsao kɨn ye nəgkiarien kape loa, In yermamə yame profet mɨnə kɨmɨsəvsao kɨn, kɨni In yemə Nasaret, ji Josef. Nhagɨn e Yesu.” ");
INSERT INTO nwi_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Mərɨg əmə Nataniel rɨmə, “?Rhawor? Nar huvə kɨrik to rɨpəh nɨsɨ-pənien a Nasaret.” Mərɨg Filip rɨmə, “Ita. Yuə məm-ru.” ");
INSERT INTO nwi_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kɨni Yesu rɨmnəm Nataniel raməriwək mamuə, kɨni rɨni-ərhav mɨmə, “Kwən e, in kwənərəus atuatuk kape Isrel. In reinein neikuəyen.” ");
INSERT INTO nwi_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ǝmaikɨn, Nataniel raiyoh Yesu mɨmə, “?Rhawor nakɨrkun yo?” Kɨni Yesu rɨni-pən tukun mɨmə, “Yɨmnəm ik nakamkwətə ye tɨkɨmkɨmɨ nai, kwasɨg ikɨn Filip rokrən kɨn ik.” ");
INSERT INTO nwi_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Kɨni Nataniel rɨmə, “Yhajoun. !Ik Ji Kughen! !Ik King kape kwənərəus kape Isrel!” ");
INSERT INTO nwi_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Kɨni Yesu rɨmɨni-pən tukun mɨmə, “?Nakamni nəfrakɨsien irak meinai yakməni əmə mə yaknəm ta ik, nɨpɨg nɨmnamkwətə ye tɨkɨmkɨmɨ nai? Ik takpiəm nar ehuə mɨnə rapita yame.” ");
INSERT INTO nwi_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kɨni mɨni mɨn mɨmə, “Yakamni əfrakɨs tuk əmiə mə, takpisəm napuə tukrəkwag, kɨni agelo mɨnə kape Kughen tukshaktə mhavən ye neiai, mɨseiwaiyu-pə tuk Yo, Ji Yermamə.” ");
INSERT INTO nwi_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kəni nahu kɨn, kɨmnor narkurəkien kɨrik apa Kena, yerkwanu kɨrik apa Galili. Kɨni mama kape Yesu rɨmavən ye narkurəkien a. ");
INSERT INTO nwi_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Kɨni kɨmnokrən mɨn kɨn Yesu mɨne kafan narmamə mɨnə mə tukhavən mɨn ye narkurəkien a. ");
INSERT INTO nwi_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ǝmaikɨn, narmamə kɨmnhanɨm fam waen, kɨni mama kape Yesu rɨmɨni-pən tukun mɨmə, “Nitawə waen ruɨkək.” ");
INSERT INTO nwi_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Mərɨg Yesu rɨmə, “Piahuaru apə. ?Rhawor nakamaiyoh-pə kɨn nar e kɨmi Yo? Rɨpəh hanə norien nɨpɨg kafak.” ");
INSERT INTO nwi_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mərɨg kafan mama rɨmɨni-pən tuk yorwok mɨnə aikɨn mɨmə, “Takasor naha nhagɨn yame kwən e ramni.” ");
INSERT INTO nwi_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kɨmnətu jag ehuə sikis aikɨn, tukvi-pən nu iran, mə nəmə Isrel tuksərav ikɨn, mə tukhapəh nɨsəmkəmɨkien ye nɨmrɨ Kughen. Kɨmnor jag mɨnə a kɨn kapier. Kɨrkun nɨvi-pənien galon twenti faef ye kɨrikianə kɨrikianə. ");
INSERT INTO nwi_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Kɨni Yesu rɨni-pən tuk yorwok mɨnə mə, “Havi-pən nu ye tikikwipɨr mɨnə e.” Kɨmnhavən mhavi-pən nu irəriə kɨsokrig huvə. Kɨni rɨni-pən tuk əriə mɨmə, “Havi-ta nu tɨksɨn, mhavəh, mhavən, mhavəhsi-pən kɨmi yemehuə kape nəvɨgɨnien.” ");
INSERT INTO nwi_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kɨni kɨmnhavən masor. ");
INSERT INTO nwi_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kɨni yemehuə kape nəvɨgɨnien rɨmɨnɨm əsɨgəvɨn, mərɨg nu rɨnor ta waen kɨn. Kɨni reinein mə kɨmɨvəhs hiə waen e. Mərɨg narmamə yamə mɨne kɨmnhavi-ta nu a mhavəh mhavən, iriə əmə kharkun. Kɨni yemehuə kape nəvɨgɨnien rɨmnokrən kɨn yermamə yame rɨmnarkurək pə pə əmə, ");
INSERT INTO nwi_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","mɨni-pən tukun mɨmə, “Tukmə nəvɨgɨnien ehuə kɨrik, narmamə kasəkupən mhavəhsi-ərhav waen yame rhuvə pɨk, kɨni narmamə kamhanɨm rɨpsaah, mɨsapɨs kɨn, kɨni ai, kɨpivəhsi-ərhav yame rɨpəh nɨhuvə-pɨkien. Mərɨg yakaməm mə ik nɨmnərəhu karɨn yame rhuvə rapita, raməmɨr meriaji nakpihavəhsi-ərhav ai taktakun.” ");
INSERT INTO nwi_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kɨni nɨmtətien yame Yesu rɨmnor apa Kena ye Galili in nɨmtətien yame In rɨmnəkupan mor rhajoun-pən nehuəyen kafan, kɨni kafan narmamə mɨnə kɨmɨshatətə tɨmtɨm iran. ");
INSERT INTO nwi_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kɨni ai, Yesu rɨmneiwaiyu mɨvən ye taon a Kapaneam iriə kafan mama mɨne naorahini mɨnə mɨne kafan narmamə mɨnə. Mɨsarə kape nɨpɨg kwakwə əmə aikɨn. ");
INSERT INTO nwi_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kɨni nɨpɨg kape nəvɨgɨnien kape nəmə Isrel e kamni kɨmə Pasova ruauə ipakə, kɨni Yesu rɨmnhaktə mɨvən Jerusalem. ");
INSERT INTO nwi_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mamvən ye Nimə Ehuə kape Kughen, məm narmamə kasor salem kɨn kau mɨnə, mɨne sipsip mɨnə, mɨne mak ye tanə mɨnə. Məm narmamə tɨksɨn kasor jenis ye mane. ");
INSERT INTO nwi_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ǝmaikɨn Yesu rɨmavən mɨrəh təvrə kɨrik, mərər mamarkɨs kau mɨne sipsip mɨnə kɨn, maməko ərhav narmamə ye Nimə Ehuə kape Kughen. Kɨni mahiə-ərhav kɨn mane kape narmamə yame kasor jenis ye mane kape kantri pɨsɨn pɨsɨn mɨnə ruə ye mane kape Jerusalem, mei-əhu tebol mɨnə kapəriə. ");
INSERT INTO nwi_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kɨni mamhek narmamə yamə mɨne kasor salem kɨn mak ye tanə mɨmə, “Hapɨk narɨmnar mɨnə e mhatərhav. Hapəh nɨsorien Nimə kape Rɨmɨk rəmhen kɨn nimə kape norien maket.” ");
INSERT INTO nwi_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Narmamə kape Yesu mɨnə kɨmɨsəm nar a, rɨkiriə raməsɨk nəgkiarien kɨrik ye Nəkwəkwə kape Kughen yame ramni mə, “Narmamə tuksəməkɨn Yo, meinai Yo yakorkeikei pɨk kafam Nimə, kɨni mamarkut pɨk mə narɨmnar m-fam aikɨn tukratuatuk.” ");
INSERT INTO nwi_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kɨni nəmehuə kape nəmə Isrel kasəkeikei kɨmin mhamə, “!Ah! Pa nhagɨn rɨmɨvəh-si-pre nehuəyen kɨmik mə takor narɨmnar mɨnə e? Or-ru nɨmtətien kɨrik, pəh yaksəm-ru mə nəfrakɨsien kafam nəsanɨnien ramsɨ-pən ye rao ye neai.” ");
INSERT INTO nwi_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Mərɨg Yesu rɨmə, “Ita. Taksoriah Nimə Ehuə Kape Kughen, kɨni ye nɨpɨg yame ramor kɨsisər kɨn, jakherɨg mɨn mərɨp.” ");
INSERT INTO nwi_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kɨni nəmehuə kape nəmə Isrel khamə, “Kəsi. Narmamə kɨmnhavhirəkɨn nimə e mhavəh newk foti sikis. ?Takhawor pən iran mɨne mɨvhirəkɨn mɨn ye nɨpɨg kɨsisər əmə?” ");
INSERT INTO nwi_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","(Mərɨg nɨpɨg Yesu ramni Nimə Ehuə kape Kughen, In raməgkiar atuk əmə iran. ");
INSERT INTO nwi_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kɨni kwasɨg ikɨn, nɨpɨg In rɨmamhə kɨni mamragh mɨn, kafan narmamə mɨnə rɨkiriə raməsɨk nəgkiarien e yame ramni ye Nimə Ehuə kape Kughen. Kɨni iriə kɨmnhani nəfrakɨsien ye Nəkwəkwə kape Kughen mɨne nəgkiarien yame Yesu rɨmɨni-ərhav). ");
INSERT INTO nwi_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Mərɨg nɨpɨg Yesu rɨmnamarə apa Jerusalem, ye nɨpɨg kape nəvɨgɨnien kape Pasova, narmamə khapsaah kɨmɨsəm In rɨmnor nɨmtətien tɨksɨn, kɨni khani nəfrakɨsien iran. ");
INSERT INTO nwi_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mərɨg Yesu rɨmɨpəh nɨniyen nəfrakɨsien irəriə, meinai In ruɨrkun nərɨgien kapəriə. ");
INSERT INTO nwi_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yermamə kɨrik to rɨpəh nɨni-pənien nərɨgien kafan tukun, mərɨg In ruɨrkun ta narɨmnar fam yame ramswiin yerki narmamə. ");
INSERT INTO nwi_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kɨni Farisi kɨrik aikɨn, nhagɨn e Nikodimas. In yemehuə kɨrik ye kaonsel kape nəmə Isrel. ");
INSERT INTO nwi_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kɨni nɨpɨg kɨrik, yenpɨg, in rɨmavən mə tukrəgkiar iriu Yesu, mɨmə, “Yhajoun. Kɨmawə yakharkun mə ik yhajoun kɨrik yame Kughen rɨmnher-pə kɨn ik nakuə, meinai Kughen rɨpipəh nəmɨrien tuk Ik, nakpipəh norien nɨmtətien mɨnə e.” ");
INSERT INTO nwi_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Kɨni Yesu rhorpɨn nəgkiarien kafan mɨmə, “Yakamni əfrakɨs tuk ik mə, tukmə yermamə rɨpəh narhayen yame ror kɨraru kɨn, to rɨpəh narəyen ye narmaruyen kape Kughen.” ");
INSERT INTO nwi_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimas rɨnərɨg nəgkiarien a, rakur, maiyoh In mɨmə, “?Yermamə tukrhawor-pən iran mɨne marha yame ror kɨraru kɨn? To rɨpəh nɨrerɨg-pən-mɨnien ye tɨp mama, marha mɨn.” ");
INSERT INTO nwi_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Kɨni Yesu rɨmɨni-pən tukun mɨmə, “Yakamni əfrakɨs tuk ik mə tukmə yermamə rɨpəh narhayen ye nu mɨne ye Nanmɨn kape Kughen, tukrɨpəh nɨvənien mamarə ye narmaruyen kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Yermamə rameimək əmə kɨn yermamə mor nɨpran ramragh; mərɨg Nanmɨn kape Kughen əmə rɨrkun norien nanmɨ yermamə ramragh. ");
INSERT INTO nwi_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Takpəh nakurien tuk nəgkiarien kafak yame yɨmɨni-pre tuk ik mə, ‘Takaməkeikei marha wi mɨn.’ ");
INSERT INTO nwi_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Rəmhen əmə kɨn nɨmətag. Nɨmətag ramavən, mamvən ikɨn yame rorkeikei mə tukrɨvən-pən ikɨn. Nakərɨg nɨmətag ramavən, nakeinein mə ramsɨpkaa, uə ramvən hiə. Kɨni ye norien kɨrikianə əmə mɨn, narmamə khapəh nɨsəmien Nanmɨn kape Kughen, mərɨg kasəm əmə wok kafan ye nɨmraghien kape narmamə yamə mɨne kasarha wi mɨn.” ");
INSERT INTO nwi_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Mərɨg Nikodimas rɨmɨni-pən tuk Yesu mɨmə, “Nar e nakamni rəutən pɨk. ?Tukrhawor pən iran mɨne mɨtərhav-pə?” ");
INSERT INTO nwi_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Kɨni Yesu rɨmə, “Ik yhajoun kɨrik kape nəmə Isrel. ?Rhawor nakeinein narɨmnar mɨnə e? ");
INSERT INTO nwi_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yakamni əfrakɨs tuk ik mə kɨmawə kafak narmamə mɨnə yakharkun narɨmnar mɨnə mamhani-ərhav, mɨsəvsao kɨn narɨmnar yamə yakwəsəm ta. Mərɨg kɨmiə nakhapəh nhaniyen nəfrakɨsien ye nəgkiarien kapəmawə. ");
INSERT INTO nwi_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yo yakamni pawk əmə narɨmnar kape tokrei tanə, mərɨg kɨmiə nakhapəh nhaniyen nəfrakɨsien ye kafak nəgkiarien. Tukmə ror məkneikɨn, to nakhapəh nhaniyen nəfrakɨsien ye kafak nəgkiarien ye nɨkarɨn kape narɨmnar kape rao ye neai. ");
INSERT INTO nwi_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mərɨg yermamə kɨrik rɨkək yame ruavən ta apa ye rao ye neai. Mərɨg Yo pɨsɨn əmə, Ji Yermamə, yaksɨ-pən ye rao ye neai meiwaiyu-pə, mɨrkun nəvsaoyen kɨn. ");
INSERT INTO nwi_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Apa kupan, Moses rɨmnamarə ye tɨpəvsɨk, mɨruk haktə nar yame rɨmnor mɨsɨgovɨn snek kɨn, mɨruk haktə ye nai. Kɨni ye norien kɨrikianə əmə mɨn, tukruk haktə mɨn Yo, Ji Yermamə, ");
INSERT INTO nwi_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","mə narmamə m-fam yamə mɨne kamhani nəfrakɨsien irak tukhavəh nɨmraghien rerɨn. ");
INSERT INTO nwi_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ror məkneikɨn meinai Kughen rorkeikei narmamə m-fam ye tanɨmtanə mher-pə kɨn Yo, Tɨni kwənkwan kɨrikianə əmə, mə narmamə yamə mɨne kashatətə irak, tukhapəh nhamhəyen, mərɨg tukhavəh nɨmraghien rerɨn. ");
INSERT INTO nwi_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pəh nien mə Kughen rɨmnher-pə kɨn Yo Tɨni mə jakuə mɨvəhsi-pən narpɨnien kɨmi narmamə. Mərɨg rɨmnher-pə kɨn mə Yo jakuə mor swatuk tuk nɨvəh-mɨraghien narmamə ye tanɨmtanə. ");
INSERT INTO nwi_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Narmamə yamə mɨne kɨshatətə irak, Kughen tukrɨpəh nɨvəhsi-pənien narpɨnien kɨmi əriə; mərɨg narmamə yamə mɨne khapəh nɨshatətəyen irak, Kughen ruɨni ta narpɨnien kapəriə, meinai khapəh nhaniyen nəfrakɨsien irak, Ji Kughen Kwənkwan kɨrikianə əmə. ");
INSERT INTO nwi_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kughen tukrɨvəhsi-pən narpɨnien kɨmi əriə meinai nɨkakien ruauə ta ye tokrei tanə, mərɨg iriə khapəh nɨsorkeikeiyen nɨkakien. Kasorkeikei əmə nəpɨgnəpien, meinai nɨpɨg m-fam, norien kapəriə ramahas. ");
INSERT INTO nwi_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Narmamə yamə mɨne kasor norien has kasəməkɨn nɨkakien. To khapəh nhavənien aikɨn rakhak ikɨn, meinai khapəh nɨsorien mə nɨkakien tukrəsia-pen norien kapəriə. ");
INSERT INTO nwi_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","“Mərɨg narmamə yamə mɨne kɨsəri-pən swatuk kape nəfrakɨsien tukasərer aikɨn rakhak ikɨn, mə nɨkakien a tukrəsia-pen norien kapəriə, mhajoun mə naha nhagɨn yame kasor, kasor ye nəsanɨnien əmə kape Kughen.” ");
INSERT INTO nwi_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kɨni ai, Yesu mɨne kafan narmamə mɨnə kɨmnasəriwək mɨsavən apa Judia, mɨsarə iriə nəmə aikɨn. Kɨni In rɨmnor baptaes ye narmamə. ");
INSERT INTO nwi_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Mərɨg ye nɨpɨg a, Jon rɨmnor baptaes ye narmamə apa Aenon, ipakə əmə tuk taon a Salim. Rɨmnor baptaes ye narmamə apaikɨn meinai nu rehuə aikɨn. Kɨni narmamə kɨmnhauə pɨk mə Jon tukror baptaes irəriə. ");
INSERT INTO nwi_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ye nɨpɨg a, kɨpəh hanə nɨvəhsi-pənien Jon ye kalabus. ");
INSERT INTO nwi_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kɨni narmamə tɨksɨn kape Jon kɨmasotgoh iriə yemə Isrel kɨrik, ye nɨkarɨn kape nəravyen mə tukror narmamə khapəh nɨsəmkəmɨkien ye nɨmrɨ Kughen. ");
INSERT INTO nwi_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kɨni kɨmnhavən mɨsəm Jon mhamə, “Yhajoun. Ik nakɨrkun kwən a kupan kɨmiru min apa nɨkar nu Jodan pən. Kɨni ik nɨmnərer-ərhav mɨni-ərhav pən In tuk narmamə. Taktakun ai, In ramor baptaes ye narmamə. Kɨni narmamə m-fam kamhavən masəm.” ");
INSERT INTO nwi_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Kɨni Jon rɨmɨni-pən tuk əriə mɨmə, “Narmamə kharkun əmə nɨsorien narɨmnar yame Kughen ravəhsi-pən nəsanɨnien kɨmi əriə tuk norien. ");
INSERT INTO nwi_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kɨmiə e nakasərer tuk yo. Kɨmiə nakharkun huvə mə yakməni mɨmə, ‘Pəh nien mə Yo Kristo.’ Mərɨg Kughen rɨmnher-pə kɨn yo mə jakəkupən muə, kɨni Kristo tukrɨpikwasɨg. ");
INSERT INTO nwi_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yakmə jakni-pre nuhpɨkɨnien kɨrik. Yermamə yame tukrarkurək ye piraovɨn kɨrik, piraovɨn a tukrəri-pən əmə in. Kɨni kwən a, in mɨnə tɨksɨn kaseito kɨn in mə tukruə ye lafet kape narkurəkien, kɨni rɨkiriə ragien tukun, kasərer masarha-kɨn in mə tukruə ye swatuk. Kɨni nɨpɨg tuksəm in ramuə, rɨkiriə tukragien. Kɨni yermamə yame tukrarkurək, yo e in kɨrik yame yakamərer mameito kɨn, mamarha-kɨn in mə jakravən ye nəvɨgɨnien kape narkurəkien. Kɨni taktakun ai, yɨmnərɨg nəvsaoyen kɨn Kristo mə ruauə ta, kɨni rɨkik ragien pɨk. ");
INSERT INTO nwi_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","In tukraməkeikei muə mə In yerpɨrɨg rapita yo; kɨni yo jakaməkeikei meiwaiyu. ");
INSERT INTO nwi_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Yermamə yame ramsɨ-pən ye Rao ye Neai In yerpɨrɨg rapita narmamə m-fam. Yermamə yame ramsɨ-pə əmə ye tokrei tanə, in yermamə kape tokrei tanə, kɨni rɨrkun əmə nɨniyen narɨmnar kape tokrei tanə. Mərɨg yermamə yame ramsɨ-pən ye rao ye neai In yerpɨrɨg rapita narmamə m-fam. ");
INSERT INTO nwi_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","In mamərer-ərhav tuk nɨni-ərhavyen narɨmnar yame rɨmnəm mɨnərɨg ta, mərɨg narmamə khapəh nhaniyen nəfrakɨsien iran. ");
INSERT INTO nwi_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kɨni mərɨg yermamə yame ravəh kafan nəgkiarien kɨni mamni nəfrakɨsien iran, in ramni-ərhav mə nəgkiarien yame Kughen ramni, in nəfrakɨsien. ");
INSERT INTO nwi_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ror məkneikɨn meinai yermamə yame Kughen rɨmnher-pə kɨn mə tukruə, In ramni-ərhav nəgkiarien kape Kughen. Kɨtawə kharkun mə In ramni-ərhav əmə nəgkiarien kape Kughen meinai Nanmɨn kape Kughen rehuə pɨk iran. ");
INSERT INTO nwi_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tata Kughen In rorkeikei pɨk Tɨni, kɨni mərəhu-pən narɨmnar fam əgkap ye kwermɨn. ");
INSERT INTO nwi_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Narmamə yamə mɨne kamhani nəfrakɨsien ye Ji Kughen e, iriə tukhavəh nɨmraghien rerɨn. Mərɨg narmamə yamə mɨne kasəpəh In to khapəh nhavəhyen nɨmraghien rerɨn, meinai Kughen tukror niemhaa kɨmi əriə kape rerɨn.” ");
INSERT INTO nwi_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisi mɨnə kɨmɨsərɨg nəgkiarien mə Yesu ravi-pə narmamə khapsaah kamhauə tukun, kɨni In mamor baptaes irəriə khapsaah. Namba irəriə rɨpsaah rapita narmamə kape Jon mɨnə. ");
INSERT INTO nwi_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Mərɨg nəfrakɨsien mə pəh nien mə Yesu rɨmnor baptaes irəriə, mərɨg narmamə kafan mɨnə kɨmɨsor baptaes ye narmamə.) ");
INSERT INTO nwi_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Kɨni nɨpɨg Yesu rɨmnərɨg mə Farisi mɨnə kɨmɨsərɨg nəvsaoyen kɨn, rɨmɨtərhav Judia mɨrerɨg-pən apa Galili. ");
INSERT INTO nwi_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Rɨmə tukruvɨn apa Galili, mərɨg provins e Sameria ramərer əkupan. ");
INSERT INTO nwi_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kɨni rɨtərhav-pə ye taon kɨrik ye Sameria, kamni kɨmə Saeka. Taon a, ipakə tuk tanə kɨrik yame Jekob rɨmɨvəhsi-pən kɨmi tɨni a Josef apa kupan. ");
INSERT INTO nwi_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ikɨn aikɨn a, huaru Jekob rɨmɨkɨr kwətɨg nu kɨrik kafan. Yesu rɨmnəriwək rapomh ikɨn mɨnəpəu, kɨni muə məkwətə-pən ye nɨkar kwətɨg nu a, mamapɨs, yerkweiha. ");
INSERT INTO nwi_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Kɨni kafan narmamə mɨnə kɨmnhavən apa taon, mə tukhavəh nɨmrɨ nəvɨgɨnien. Kɨni pian Sameria kɨrik ramuə mə tukrɨruk nu. Kɨni Yesu rɨni-pən tukun mɨmə, “Eh. Ruk nu mɨvəhsi-pə kɨmi Yo.” ");
INSERT INTO nwi_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kɨni pian Sameria a rɨni-pən tukun mə, “!Eh! Ik yemə Isrel, kɨni yo pian Sameria. ?Rhawor e nakaməgkiar kɨmi yo?” Ramni məknakɨn meinai nəmə Isrel kapəriə kɨrik nar kɨrik rɨkək tuk nar Sameria. ");
INSERT INTO nwi_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kɨni Yesu rɨni-pən tukun mə, “Ik nakeinein naha nhagɨn yame Kughen rorkeikei mə tukrɨvəhsi-pre kɨmik. Kɨni ik nakameinein mɨn Yo. Yo e, yakamaiyoh-pre nu kɨmik. To nakpirkun, nakpiaiyoh-pə kɨn nu tuk Yo. Kɨni yakpivəhsi-pre nu mɨragh.” ");
INSERT INTO nwi_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kɨni pian a rɨni-pən tukun mɨmə, “Yemehuə. Ik kafam tikikwipɨr rɨkək, kɨni kwətɨg nu e reiwaiyu pɨk. ?Takhawor-pən iran mɨne mɨruk nu mɨragh e yame nakamni? ");
INSERT INTO nwi_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Apa kupan, rɨptawə Jekob rɨmnamruk nu eikɨn e nin mɨne ni kafan kwajikovə mɨnə, mɨne ni kau mɨnə kafan, kɨni ai, meighan-pə kɨn kwətɨg nu e mə nitawə. ?Mərɨg rhawor? ?Nakmə ik nakehuə rapita rɨptawə Jekob, uə?” ");
INSERT INTO nwi_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Kɨni Yesu rɨmɨni-pən tukun mə, “Narmamə yamə mɨne kamhanɨm nu ye kwətɨgɨn e, tukasəkeikei mɨsəkwakwə mɨn. ");
INSERT INTO nwi_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Mərɨg narmamə yamə mɨne tukhanɨm nu mɨragh yame yakvəhsi-pən kɨmi əriə, to khapəh nɨsəkwakwə-mɨn-ien tuk nɨpɨg kɨrik. Nu yame jakvəhsi-pən kɨmi əriə, in rəmhen kɨn nɨmrɨ nu kɨrik yame ramkwor-kwor apa yerkin nɨpɨg m-fam mamaiyu, mɨvəh-si-pən nɨmraghien rerɨn kɨmin.” ");
INSERT INTO nwi_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kɨni pian a rɨni-pən tukun mɨmə, “Yemehuə. Vəh-si-pə-ru nu en kɨmi yo, mə jakpəh nəkwakwə-mɨn-ien, pəh jakpəh nuə-mɨnien ikɨn e mɨruk nu ye kwətɨgɨn e.” ");
INSERT INTO nwi_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Kɨni Yesu rɨni-pən tukun mɨmə, “Yuvən mokrən kɨn kafam huaru, mɨrauə.” ");
INSERT INTO nwi_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kɨni pian a rɨni-pən tukun mə, “Ah. Kafak huaru rɨkək.” Mərɨg Yesu rɨni-pən tukun mə, “Nakaməfrakɨs mə kafam huaru rɨkək. ");
INSERT INTO nwi_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Meinai ik, naknəri-pən ta narman kɨrkɨrɨp, kɨni yerman yame nakwarə kwis ai taktakun, pəh nien mə kafam atuatuk yerman. Nakwəni mə kafam yerman rɨkək, nəfrakɨs.” ");
INSERT INTO nwi_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kɨni pian a rɨni-pən tukun mə, “Yemehuə, yakwɨrkun mə ik profet kɨrik kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Rɨptawə mɨnə kupan, iriə kɨmɨshaktə-pə ye tukwas e kɨrau kawərer ikɨn, masəhuak kɨmi Kughen. Mərɨg kɨmiə nəmə Isrel nakamhani mə tukaməkeikei kavən əmə apa Jerusalem kaməhuak.” ");
INSERT INTO nwi_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Mərɨg Yesu rɨni-pən tukun mə, “Piahuaru. Ik takaməkeikei mɨni nəfrakɨsien ye kafak nəgkiarien. Nɨpɨg aikɨn tukruə yame narmamə m-fam takhapəh nɨsəhuak-əmə-yen kɨmi Tatə Kughen ikɨn e ye tukwas e, mhapəh nɨsəhuak-əmə-yen apa Jerusalem. ");
INSERT INTO nwi_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kɨmiə nəmə Sameria, naksəhuak pawk kɨmi Kughen, mərɨg nakseinein In. Mərɨg kɨmawə nəmə Isrel yakasəhuak kɨmi Kughen, mharkun In, meinai swatuk yame Kughen tukrɨvəh mɨragh narmamə iran, ramsɨ-pə irəmawə. ");
INSERT INTO nwi_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nɨpɨg ramuə - kɨni ruauə ta - yame Nanmɨn kape Kughen tukrasitu ye nəməhuak əfrakɨs mɨnə, mor əriə tukharkun huvə Kughen, mə in Kughen əfrakɨs, mamor əriə tuksəhuak kɨmin yerkiriə mɨfam. Meinai Tatə Kughen In rorkeikei nəməhuak yamə mɨne kasəhuak əfrakɨs kɨmin. ");
INSERT INTO nwi_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kughen rɨpəh norien rəmhen kɨn nɨprai yermamə. In nanmɨn. Ror pən, narmamə yamə mɨne khamə tuksəhuak kɨmin tukasəkeikei masəhuak kɨmin yerkiriə m-fam, ye norien yame Nanmɨn kape Kughen ramasitu irəriə, mə tukharkun mə In Kughen əfrakɨs.” ");
INSERT INTO nwi_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kɨni pian a rɨni-pən tukun mɨmə, “Yo yakwɨrkun mə Mesaea tukraməkeikei muə. In e, kamokrən kɨn In kɨmə Kristo. Kɨni nɨpɨg yame In tukruə iran, In tukrhoprai fam nɨprai nəgkiarien mɨnə kɨmi ətawə.” ");
INSERT INTO nwi_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Kɨni Yesu rɨmɨni-pən tukun mə, “Yo e yakaməgkiar kɨmik, Yo e Kristo.” ");
INSERT INTO nwi_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Məkneikɨn, narmamə kafan mɨnə kɨmnharerɨg-pə mɨn tukun. Masəm raməgkiar kɨmi piraovɨn kɨrik, kɨsakur. Mərɨg khapəh nɨsaiyohyen Yesu mə rhawor maməgkiar kɨmi pian a, mə rorkeikei naha. ");
INSERT INTO nwi_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kɨni pian a, rəpəh kafan tikikwipɨr, marar mamvən apa ye taon. Maməvsao kɨn kɨmi narmamə mɨmə, ");
INSERT INTO nwi_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Eh. Havən-ru mɨsəm kwən kɨrik aikɨn a, In ruɨrkun ta norien has mɨnə fam yamə mɨne yɨmnamor ye nɨmraghien kafak mamni-pə tuk yo. ?Tukmə ror in Kristo, uə?” ");
INSERT INTO nwi_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kɨni narmamə khatərhav ye taon, mhavən mə tuksəm Yesu. ");
INSERT INTO nwi_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ye nɨpɨg a, narmamə kape Yesu mɨnə kasəkeikei kɨmin mhamə, “Yhajoun, əvɨgɨn.” ");
INSERT INTO nwi_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mərɨg In rɨni-pən tuk əriə mə, “Yo, nak aikɨn nəvɨgɨnien yame kɨmiə nakseinein.” ");
INSERT INTO nwi_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Məkneikɨn, kafan narmamə mɨnə kɨmɨsaiyoh əriə mɨnə mhamə, “?Rhawor? ?Tukmə ror yermamə kɨrik rɨvəhsi-pən nan kɨrik nəvɨgɨnien uə?” ");
INSERT INTO nwi_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Mərɨg Yesu rɨni-pən tuk əriə mə, “Kughen rɨmnher-pə kɨn Yo yakuə, kɨni nəvɨgɨnien nak ror məkneikɨn, mə jakamor narɨmnar fam yame Kughen rorkeikei. Kɨni yakamor fam wok yamə mɨnə In rɨmnher-pə kɨn Yo mə jakor, mor naunin ye kafan wok. ");
INSERT INTO nwi_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Sətərɨg-ru kɨn nɨprai nuhpɨkɨnien yame jakni-pre tuk əmiə mə, ‘Makuə kuas tukruə mɨvən, ror nɨpɨg kape nɨvəhyen nəsimien.’ Mərɨg Yo yakamni-pre tuk əmiə mə sarha-pən ru, mɨsəm-ru nəsimien. Ruəmruə ta. ");
INSERT INTO nwi_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","“Tukmə nakhavəh kafak nəgkiarien, jakvəhsi-pre nərokien kɨmi əmiə rəmhen kɨn yame yemehuə kape nəsimien tukrərok narmamə yamə mɨne kasor wok ye nəsimien kafan. Nɨpɨg nakasor wok, naksasitu ye narmamə mə tukhavəh nɨmraghien rerɨn. Yakamni-ərhav nəgkiarien kape Kughen rəmhen əmə kɨn yame yermamə ramsuv kweru nai. Kɨni kɨmiə naksasitu ye narmamə mə tukhavəh nəgkiarien kafak, rəmhen kɨn yame kavəh nəvɨgɨnien ye nəsimien. Nɨpɨg tukmə narmamə tukhavəh nəgkiarien kafak, kɨtawə kwis tuksagien. ");
INSERT INTO nwi_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Rəmhen kɨn nəgkiarien kɨrik kamni kɨmə, ‘Yermamə kɨrik ramsuv kweru nai, kɨni yermamə pɨsɨn kɨrik ravəh kwənkwan.’ ");
INSERT INTO nwi_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yakamher-pre kɨn əmiə mə taksasitu ye narmamə mə tukhavəh nəgkiarien kafak. Mərɨg pəh nien mə kɨmiə nɨmnhasuv kweru nai. Nəmə pɨsɨn kɨmɨsəkupən masəmnhakw tuk nɨsuvyen kweru nai. Kɨmiə takharhi kwənkwai nəvɨgɨnien ye nəsimien yame iriə kɨmnhasuv.” ");
INSERT INTO nwi_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Pian a rɨmɨni-ərhav mə Yesu ruɨrkun ta norien has mɨnə fam yame ramor ye nɨmraghien kafan, kɨni nəmə Sameria khapsaah ye taon a kɨmɨsərɨg, mhani nəfrakɨsien ye Yesu. ");
INSERT INTO nwi_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kɨni nɨpɨg nəmə Sameria kɨmnhavən mɨsəm In, masəkeikei kɨmin mə iriə min. Kɨni Yesu rɨvən iriə miriə mɨsarə kape nɨpɨg kɨraru. ");
INSERT INTO nwi_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kɨni In raməgkiar kɨmi əriə, narmamə khapsaah khani nəfrakɨsien iran. ");
INSERT INTO nwi_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mhani-pən tuk pian a mhamə, “Apa kupan, kɨmawə yɨmnhani nəfrakɨsien iran tuk nəvsaoyen yame ik nɨmɨni-əsah-pə tuk əmawə. Mərɨg taktakun ai, yakamhani nəfrakɨsien iran meinai yɨmɨsərɨg kafan nəgkiarien, kɨni mharkun əfrakɨs mə in Yermamə yame tukrɨvəh mɨragh narmamə ye tanɨmtanə.” ");
INSERT INTO nwi_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu rɨmnamarə mɨvəh ta nɨpɨg kɨraru, kɨni ai mɨtərhav mɨvən iman ikɨn apa provins Galili. ");
INSERT INTO nwi_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Mərɨg apa kupan in rɨmnamni mə, “Tukmə profet kɨrik kape Kughen, narmamə iman ikɨn tukhapəh nhasiaiyen In.”) ");
INSERT INTO nwi_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kɨni nɨpɨg Yesu rɨtərhav-pə Galili, narmamə aikɨn kɨmnhani vi vi In meiani in apa kupan iriə min kɨmnhavən Jerusalem masor lafet kape Pasova, kɨni mɨsəm narɨmnar yame In rɨmnor aikɨn. ");
INSERT INTO nwi_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ror pən, rɨmavən mɨn apa taon e Kena, ye provins Galili. Ikɨn a kupan, In rɨmnor nu rukreikɨn muə mor waen kɨn. Kɨni yemehuə kɨrik ramarə apa taon pɨsɨn kɨrik e Kapaneam, kafan kwajikovə ramhə. ");
INSERT INTO nwi_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kɨni yemehuə a rɨmnərɨg mə Yesu ruatərhav Judia mamuə e Galili, məkneikɨn rɨvən məm Yesu, maməkeikei kɨmin mə tukrɨvən apa Kapaneam mor huvə kafan kwajikovə. Meinai kafan kwajikovə, nɨmhəyen rɨneriaji. ");
INSERT INTO nwi_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Kɨni Yesu rɨni-pən tuk kwən a mɨmə, “!Ah! !To nakpihapəh nɨsəmien nɨmtətien, to nakpihapəh nhaniyen nəfrakɨsien irak!” ");
INSERT INTO nwi_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kɨni kwən a rɨmə, “Yemehuə. Pəh kwhai mɨren əmə mɨravən mɨwəm tamə rɨmhə.” ");
INSERT INTO nwi_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Kɨni Yesu rɨni-pən tukun mɨmə, “Ita. Rerɨg-pən tukun. Kafam kwajikovə rɨnəsanɨn ta.” Kɨni kwən a rɨmɨni nəfrakɨsien ye nəgkiarien kape Yesu, mɨrerɨg-pən tuk kafan kwajikovə. ");
INSERT INTO nwi_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nɨpɨg raməriwək hanə ye swatuk, məm kafan yorwok mɨnə, kɨni iriə khani-pən tukun mhamə, “Kafam kwajikovə rɨnəsanɨn.” ");
INSERT INTO nwi_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kɨni in raiyoh-pən əriə mɨmə, “?Rɨmnəsanɨn ye naha nɨpɨg atuatuk?” Khani-pən tukun mhamə, “Nəpan-əpanien rɨemniwaiyu e niəv, ye wan klok, mɨrh rɨnəkəkin.” ");
INSERT INTO nwi_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kɨni kwən a ruɨrkun mə ye nɨpɨg atuatuk a, Yesu rɨnamni-pən tukun mə, “Kafam kwajikovə rɨnəsanɨn.” In mɨne kafan narmamə mɨnə kɨmnhani nəfrakɨsien ye Yesu. ");
INSERT INTO nwi_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","In e nɨmtətien yame ror kɨraru kɨn yame Yesu rɨmnor apa Galili, nɨpɨg rɨmasɨ-pən apa Judia. ");
INSERT INTO nwi_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kasarə mamhavən, Yesu rɨmnhaktə mɨvən apa Jerusalem, meinai kasor lafet kɨrik kape nəmə Isrel. ");
INSERT INTO nwi_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ipakə tuk kwəruə kɨrik kape Jerusalem, kamni kɨmə “Kwəruə kape Sipsip” nu ehuə kɨrik aikɨn, narmamə kasar aikɨn. Ye nəgkiarien kape nəmə Isrel, kamhani mə Betsata. Nimə kɨrik ramərer ipakə tuk nu a. Nimə a, nɨpərɨn kɨrkɨrɨp iruə ikɨn narmamə kasəkwətə ikɨn. ");
INSERT INTO nwi_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Narmamə khapsaah yamə mɨne kamhamhə, kasəkwətə aikɨn. Tɨksɨn, nɨmrɨriə rɨpɨs. Tɨksɨn, nɨhuriə rahas. Tɨksɨn nɨkariə rɨmhə. Kasəkwətə aikɨn mamhawhin nu mə tukrɨkiu, ");
INSERT INTO nwi_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","meinai nɨpɨg kɨrik, agelo kape Kughen ramuə, meiwaiyu ye nu, mamor ramkiu. Ye nɨpɨg a, yermamə yame raməkupan mamar ye nu a, nar apnapɨg mə ravəh naha nəmhəyen, mərɨg tukrəsanɨn. ");
INSERT INTO nwi_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kɨni kwən kɨrik aikɨn, ramhə mɨvəh newk toti eit. ");
INSERT INTO nwi_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Kɨni Yesu rəm kwən a raməmɨr, rɨrkun mə kwən a rɨmɨvəh ta nəmhəyen tu. Kɨni raiyoh in mɨmə, “?Nakmə takəsanɨn?” ");
INSERT INTO nwi_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Kɨni kwən a yame ramhə rɨni-pən tukun mɨmə, “Yemehuə. Yermamə kɨrik rɨkək yame tukrɨrəh yo meiwaiyu ye nəkwai nu nɨpɨg tukramkiu-kiu. Nɨpɨg m-fam yakamarkut pɨk mə jakəkupən mar ye nu, mərɨg narmamə tɨksɨn kasəkupən kɨn yo, mɨsar.” ");
INSERT INTO nwi_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kɨni Yesu rɨni-pən tukun mɨmə, “!Ǝrer! Mərpəvɨn-ərpəvɨn nɨmhakuə kafam mɨrəh mamvən.” ");
INSERT INTO nwi_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kɨni taktakun əmə kwən ai ruahuvə mɨn. Mərpəvɨn-ərpəvɨn kafan nɨmhakuə mɨrəh mamvən. Nar a kɨmnor ye Sabat. ");
INSERT INTO nwi_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kɨni nəmehuə kape nəmə Isrel kɨmɨshek kwən a yame rɨmnəsanɨn, mhamə, “Ah. Sabat e towei; kɨni rɨpəh natuatukien ye loa kapətawə mə takrəh kafam nɨmhakuə ye nɨpɨg e taktakun.” ");
INSERT INTO nwi_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kɨni in rɨni-pən tuk əriə mə, “Mərɨg kwən a yame rɨmnor huvə yo rɨmɨni-pə mə jakarpəvɨn-arpəvɨn nɨmhakuə kafak mameriwək mamvən.” ");
INSERT INTO nwi_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Kɨni iriə kɨmɨsaiyoh in mhamə, “?Pa rɨmɨni-pre tuk ik mə takarpəvɨn-arpəvɨn kafam nɨmhakuə mɨrəh mameriwək mamvən?” ");
INSERT INTO nwi_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mərɨg kwən a rɨmneinein nhag Yesu, meinai narmamə khapsaah aikɨn a, kɨni Yesu rɨmnap ta irəriə. ");
INSERT INTO nwi_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kɨni kwasɨg ikɨn, Yesu rɨmnəm mɨn kwən a ramkwətə ye Nimə Ehuə kape Kughen, kɨni rɨni-pən tukun mə, “!Eh! !Ǝm-ru! Naknəsanɨn ta. Mərɨg takamərɨg ik mə takəpəh nor-mɨnien təvhagə has, tamə, nəmhəyen kɨrik tukruə tuk ik yame rahas rapita.” ");
INSERT INTO nwi_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Məkneikɨn kwən ai rɨmavən mɨni-əsahpən tuk nəmehuə kape nəmə Isrel mɨmə, “Kwən e yame rɨmnor huvə yo, nhagɨn e Yesu.” ");
INSERT INTO nwi_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ror məkneikɨn, nəmə Isrel kɨmɨsor ahas pən kɨmi Yesu, meinai kɨmɨsəm mə In rɨmnor wok ye Sabat. ");
INSERT INTO nwi_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Mərɨg Yesu rɨni-pən tuk əriə mɨmə, “Rɨmɨk Kughen ramor wok nɨpɨg m-fam, kɨni Yo mɨn yakamor wok ye nɨpɨg m-fam.” ");
INSERT INTO nwi_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesu raməgkiar məkna, nəmehuə kape nəmə Isrel kɨmɨsarkut pɨk mə tukshopni In. Meinai kɨmɨsəm mə rɨmnakapɨr Sabat kɨni mor nar kɨrik mɨn yame rahas rapita, in e, rɨmɨni mə Rɨmni atuatuk e Kughen, kɨni In mɨn Kughen. ");
INSERT INTO nwi_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kɨni Yesu rɨmɨni-pən tuk əriə mə, “Yakamni-pre əfrakɨs tuk əmiə mə, Ji Kughen reinein norien nar kɨrik ye kafan atuk nətərɨgien. Rɨrkun əmə norien narɨmnar yamə mɨne Tatə Kughen ramor, meinai narɨmnar fam yame Tatə Kughen ramor, Tɨni mɨn tukraməkeikei mamor. ");
INSERT INTO nwi_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Meinai Tatə Kughen rorkeikei pɨk Tɨni, kɨni mamhajoun In kɨn narɨmnar fam yame In tukror. Kɨni tukrɨpihajoun mɨn narɨmnar yamə mɨne khahuvə mɨsapita, taksəm naksakur. ");
INSERT INTO nwi_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ror məkneikɨn meinai Tatə Kughen rɨrkun norien narmamə yamə mɨne kamhamhə khamragh mɨn. Ye norien kɨrikianə əmə mɨn, Tɨni rɨrkun nɨvəhsi-pənien nɨmraghien kɨmi narmamə yame rɨkin ragien mə tukrɨvəhsi-pən kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Meinai pəh nien mə Kughen tukrəkir narmamə; mərɨg Tatə Kughen rɨmɨvəh-si pən nehuəyen kɨmi Tɨni mə In tukrəkir narmamə, ");
INSERT INTO nwi_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","mə narmamə m-fam tukhasiai Tɨni, rəmhen əmə kɨn yame kamhasiai Tatə Kughen. Yermamə yame rɨpəh nɨsiaiyen Tɨni, to rɨpəh nɨsiaiyen Tatə Kughen e yame rɨmnher-pə kɨn Tɨni. ");
INSERT INTO nwi_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Yakamni-pre əfrakɨs tuk əmiə mə yermamə yame ramərɨg kafak nəgkiarien, kɨni mamhatətə ye Kughen yame rɨmnher-pə kɨn Yo mə jakuə, in ruɨvəh ta nɨmraghien rerɨn. Nɨpɨg tukrərer ye nɨmrɨk, jakpəh nɨvəhsi-pənien narpɨnien kɨmin. Rɨnap ta ye kwənmhaan kape nɨmhəyen muauə ime nɨmraghien. ");
INSERT INTO nwi_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Narmamə yamə mɨne kɨmɨsərwei kɨsəmhen kɨn narmamə yamə mɨne kwənhamhə ta; mərɨg yakamni-pre əfrakɨs tuk əmiə mə nɨpɨg ramuə - kɨni ruauə ta - yame iriə tuksərɨg nəgkiarien kafak e Yo Ji Kughen; kɨni yamə mɨne kamhavəh nəgkiarien kafak tukhavəh nɨmraghien rerɨn. ");
INSERT INTO nwi_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tatə Kughen In nuknei nɨmraghien. Ye norien kɨrikianə əmə mɨn, In ramor mə Yo Tɨni, Yo mɨn nuknei nɨmraghien. ");
INSERT INTO nwi_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kɨni In mərəhu-pən nəsanɨnien mɨne nehuəyen ye kwermɨk e Tɨni mə yo jakəkir narmamə, meinai Yo Ji Yermamə. ");
INSERT INTO nwi_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Yakaməgkiar məkneikɨn, naksərɨg, takhapəh nɨsakurien. Meinai nɨpɨg yame ramuə, narmamə yamə mɨne kwənhamhə ta tuksərɨg nəgkiarien kafak e Yo Ji Kughen. ");
INSERT INTO nwi_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Kɨni iriə tukhatərhav-pə ye nəkwai nɨmɨr mɨnə kapəriə. Yamə mɨne kɨmɨsor norien yame ratuatuk tukasəkeikei mɨsərer mɨn mamhavəh nɨmraghien rerɨn. Mərɨg yamə mɨne kɨmɨsor norien has mɨnə tukasəkeikei mɨsərer mɨn ye nɨmhəyen masərer ye nɨmrɨk e Ji Kughen, kɨni jakni-ərhav kapəriə narpɨnien. ");
INSERT INTO nwi_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Mərɨg Yo to yakpəh norien nar kɨrik ye nəsanɨnien əmə kafak. Yo jakəkir narmamə meinai yakamor əmə naha nhagɨn yame Tatə ramni-pə tuk Yo mə jakor. Kɨni nɨpɨg jakaməkir norien mɨnə kape narmamə, yakɨrkun mə jakor ye norien yame ratuatuk, meinai yakpəh narkutien mə jakor əmə ye kafak nəsanɨnien. Mərɨg Yo, jakaməkeikei mamor əmhen ye nətərɨgien kape Kughen yame rɨmnher-pə kɨn Yo.” ");
INSERT INTO nwi_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kɨni Yesu rɨmə, “Tukmə Yo atuk əmə yakvəh-si haktə Yo, narmamə rɨkiriə tukrəsɨk mə nəgkiarien kafak rɨpəh norien nəfrakɨsien. ");
INSERT INTO nwi_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mərɨg kwən mɨn kɨrik aikɨn yame ramərer-ərhav mamor əpu Yo. Kɨni yakɨrkun mə nəgkiarien yame ramni irak in nəfrakɨsien. ");
INSERT INTO nwi_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Apa kupan, nɨmɨsher-pən narmamə tɨksɨn khavən mɨsəm Jon Baptaes mɨsaiyoh-pən in mə Yo pa. Kɨni in rɨmɨni nəgkiarien əfrakɨs irak. ");
INSERT INTO nwi_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mərɨg yakpəh nətərɨgien kɨn nəgkiarien kape yermamə kɨrik mə tukrɨni mə Yo pa. Mərɨg yakamor nɨkwənemiə kɨn nəgkiarien kape Jon, mə takhani nəfrakɨsien iran pəh Kughen tukrɨvəh mɨragh əmiə. ");
INSERT INTO nwi_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Nhajounien kape Jon in rəmhen kɨn laet. Raməsiə makak huvə. Kɨni rɨkimiə ragien tukun kape nɨpɨg kwakwə. ");
INSERT INTO nwi_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Mərɨg kafak wok ror nɨrkunien mə Yo e pa, rapita yame Jon rɨmnor. Rɨmɨk rɨmɨvəhsi-pə wok e kɨmi Yo, mə jakor infamien iran. Kɨni wok e kafak, ramni-ərhav Yo, mamor əpu Yo mə Rɨmɨk rɨmnher-pə kɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kɨni Rɨmɨk yame rɨmnher-pə kɨn Yo, In mɨn ramni-ərhav Yo. Ramni-ərhav pawk Yo, nakhapəh hanə nɨsərɨgien nəkwan. Kɨni nakhapəh hanə nɨsəmien nɨmrɨn nɨpɨg kɨrik. ");
INSERT INTO nwi_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nəgkiarien kafan rɨrkək yerkimiə, meinai kɨmiə nakhapəh nɨshatətəyen irak - Yo e yemə Kughen rɨmnher-pə kɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Kɨmiə nakasəvheikɨn pɨk nəgkiarien mɨnə ye Nəkwəkwə kape Kughen, mamhani nəfrakɨsien iran, meinai naksorkeikei mə tukrɨvəhsi-pre nɨmraghien rerɨn kɨmi əmiə. Mərɨg sərɨg-ru, nəgkiarien mɨnə ye Nəkwəkwə kape Kughen kasəgkiar irak kɨni mamhani-ərhav Yo. ");
INSERT INTO nwi_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Mərɨg kɨmiə nakasəpəh nhauəyen tuk Yo, mə takhavəh nɨmraghien rerɨn. ");
INSERT INTO nwi_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Yakpəh nərɨgien mə narmamə kasəgnəgɨn Yo uə nɨkam. ");
INSERT INTO nwi_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mərɨg Yo yakɨrkun huvə əmiə. Kɨni yakɨrkun huvə mə norkeikeiyen kape Kughen rɨkək yerkimiə. ");
INSERT INTO nwi_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yakməvəh nehuəyen kape Rɨmɨk muə, mərɨg kɨmiə nakhapəh nhavəhyen Yo yerkimiə, kɨni rɨkimiə rɨpəh nagienien tuk Yo. Mərɨg tukmə yermamə kɨrik ruə ye nəsanɨnien əmə kafan, takhavəh in, rɨkimiə ragien tukun. ");
INSERT INTO nwi_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nɨpɨg m-fam əgkap kɨmiə naksorkeikei mə narmamə tukamhani vi vi əmiə, mərɨg nakhapəh nɨsarkutien tuk norien yamə mɨne Kughen, yame In pɨsɨn əmə In Kughen, tukrɨni vi vi əmiə tukun. Tukmə nakasərɨg əmə nərɨgien kape narmamə, to nakhapəh nhaniyen nəfrakɨsien irak. ");
INSERT INTO nwi_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Mərɨg pəh rɨkimiə tukrɨpəh nəsɨkien mə yakamni hah əmiə ye nɨmrɨ Rɨmɨk Kughen. Nɨkam. Mərɨg Moses e naksərəhu-pən tɨm tɨm nərɨgien kapəmiə iran, in e ramni hah əmiə ye nɨmrɨ Kughen, ");
INSERT INTO nwi_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","meinai to kɨmiə nakpihani nəfrakɨsien ye Moses, mɨpihani mɨn nəfrakɨsien irak, meinai Moses rɨmnəvsao kɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mərɨg kɨmiə nakhapəh nhaniyen nəfrakɨsien ye nəgkiarien yame in rɨmɨrai; ror pən, ror neineinien tuk əmiə tuk nhaniyen nəfrakɨsien irak.” ");
INSERT INTO nwi_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kwasɨg ikɨn ye narɨmnar mɨnə a, Yesu rɨmnəviəfugɨn ye nu apa Lugun Galili e kamni kɨmə Lugun Taebirias. ");
INSERT INTO nwi_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kɨni narmamə khapsaah kɨmnhakwasɨg kɨn, meinai kɨmɨsəm nɨmtətien rɨpsaah yamə mɨne In ramor tuk nor-huvəyen narmamə yamə mɨne kamhamhə. ");
INSERT INTO nwi_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kɨni Yesu rɨmnhaktə fiak ye tukwas, mɨsəkwətə iriə kafan narmamə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ye nɨpɨg a, lafet kɨrik kape nəmə Isrel, kamni kɨmə Pasova, ruauə pakə. ");
INSERT INTO nwi_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kɨni Yesu rɨvaag pirə məm narmamə khapsaah kamhauə. Kɨni raiyoh Filip mɨmə, “?Tukhavəh hiə nɨmrɨ bred rəmhen tuk narmamə mɨnə a?” ");
INSERT INTO nwi_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu raməgkiar məknakɨn mə tukrəm-ru nhatətəyen kape Filip, mərɨg ruɨrkun ta naha nhagɨn yame tukrɨpior. ");
INSERT INTO nwi_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Kɨni Filip rɨni-pən tukun mə, “!Eh! To kɨsarakikɨn pawk tu handred taosen vatu ye bred, to rɨpəh nəmhen-hanəmə-yen kɨn narmamə.” ");
INSERT INTO nwi_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Kɨni yermamə kɨrik kape Yesu, naorahi Saemon Pita, nhagɨn e Andru, rɨni-pən tuk Yesu mə, ");
INSERT INTO nwi_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kwajikovə kɨrik e ravəh bred kɨrkɨrɨp kɨmnor kɨn bale, mɨne kəmam kɨraru. Mərɨg to rɨpəh nəmhen-əgkəp-ien kɨn narmamə mɨnə e.” ");
INSERT INTO nwi_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Kɨni Yesu rɨmə, “Hani-pən tuk narmamə kɨsəkwətə.” Ikɨn aikɨn a, mənvhirɨk rɨpsaah ikɨn, kɨni iriə kɨsəkwətə. Narman əmə aikɨn, ipakə tuk faef taosen. ");
INSERT INTO nwi_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kɨni Yesu rɨmɨvəh bred, mɨni vi vi Kughen tukun. Mɨvəh-si-pən kɨmi narmamə yamə mɨne kasəkwətə. Kɨni mor mɨn nar kɨrikianə əmə ye kəmam, məhi-pən kɨmi narmamə. Kɨsən rəmhen kɨn yame iriə kɨsorkeikei mə tuksən. ");
INSERT INTO nwi_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kɨmɨsəvɨgɨn ta, tupriə rəsiis, Yesu rɨni-pən tuk kafan narmamə mɨmə, “Havən mhavai-pən nɨpərpər nəvɨgɨnien yame rakwak, tamə rahas.” ");
INSERT INTO nwi_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Apa kupan, bred yame kɨmnor kɨn bale, iriə fam kɨrkɨrɨp, mərɨg kɨmnhapsaah. Narmamə kɨmɨsən mɨsəpəh tɨksɨn. Kɨni narmamə kape Yesu mɨnə kɨmnhavən mɨsəwhai nɨpərpər nəvɨgɨnien, mhavai-pən ye kəmeiru twelef rokrig huvə. ");
INSERT INTO nwi_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Narmamə kɨmɨsəm nɨmtətien yame Yesu rɨmnor, khani mhamə, “Nəfrakɨsien. Profet əfrakɨs e kape Kughen yame profet mɨnə kɨmnhani kupan mə Kughen tukrher-pə kɨn ye tokrei tanə.” ");
INSERT INTO nwi_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kɨni Yesu ruɨrkun mə narmamə mɨnə a tukhauə mɨsarkut kɨmin mə In tukror king kɨn kapəriə. Kɨni rap, mɨrerɨg-faktə mɨn ye tukwas, maməmɨr In pɨsɨn əmə. ");
INSERT INTO nwi_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nɨpɨg mɨrh rivə, narmamə kafan mɨnə kɨmnhavirə mhavən ye lugun. ");
INSERT INTO nwi_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kɨni rɨnəpɨgnəp, mərɨg Yesu rɨkək. Məkneikɨn, kɨsat-pən ye bot kɨrik, mɨsəsuə mhavirə ye lugun, mhamə tuksəviəfugɨn-pən ye Kapaneam. ");
INSERT INTO nwi_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kɨni nɨmətag ehuə kɨrik rərer mher-əpu nu, peao-peao rehuə. ");
INSERT INTO nwi_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kasəsuə mamhavən raməhen kɨn kilometa faef uə sikis, kɨni mɨsarha-pən mɨsəm Yesu raməriwək ye nɨmar-mar nu, mamuə ipakə tuk bot. Kɨni khagɨn pɨk. ");
INSERT INTO nwi_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Mərɨg In rɨni-pən tuk əriə mɨmə, “Hapəh nhagɨnien. Yo əmə e.” ");
INSERT INTO nwi_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kɨni rɨkiriə ragien mhamə tukrɨvən ye bot. Nɨpɨg Yesu rɨmnat-pən ye bot, kɨni kɨsakur əmə mɨsəm kwənhavhiak apa ikɨn kɨmnhamə tukhavhiak ikɨn. ");
INSERT INTO nwi_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kəni rɨkwamer kɨn, narmamə tɨksɨn yamə mɨne kɨmnasəmɨr iriə Yesu ye nɨkar lugun kwənharkun mə bot kɨrikianə əmə rɨmnamərer ifiak e niəv. Kɨni mharkun mə narmamə kape Yesu mɨnə kɨmnhavən ye bot a, mərɨg Yesu rɨmɨpəh nɨvənien iriə miriə. ");
INSERT INTO nwi_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kɨni narmamə tɨksɨn kɨmnhasɨ-pən ye taon e Taebirias, mɨsəsuə ye bot mɨnə tɨksɨn, mhavhiak ikɨn Yesu Yermaru rɨmɨni vi vi Kughen tuk bred məhi-pən kɨmi narmamə ikɨn. ");
INSERT INTO nwi_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kɨni narmamə kɨmɨsəm mə Yesu mɨne kafan narmamə mɨnə kwənharkək aikɨn. Məkneikɨn kɨsat-pən ye bot mɨnə tɨksɨn, mhavən apa Kapaneam, mə tuksarha-kɨn Yesu. ");
INSERT INTO nwi_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Narmamə mɨnə a kɨmɨsəviəfugɨn ye lugun, mɨsəm Yesu, mɨsaiyoh In mhamə, “Yhajoun. ?Nɨmnhawor-pən iran mɨne muə eikɨn e?” ");
INSERT INTO nwi_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Mərɨg Yesu rɨmɨni-pən tuk əriə mɨmə, “Yakamni-pre əfrakɨs tuk əmiə mə pəh nien mə nakasarha-kɨn Yo meinai Yo yakamor nɨmtətien, mərɨg naksarha-kɨn Yo meinai nɨmɨsən bred, tɨpmiə rəsiis. ");
INSERT INTO nwi_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mərɨg rɨpəh nɨhuvəyen mə kapəmiə nəsanɨnien tukrɨrkək tuk nɨvəhyen bred yame pəh nien mə tuk tu tukrahas mɨrkək. Kɨmiə takasəkeikei masəmnhakw tuk nɨvəhyen bred yame ramarə rerɨn. Bred e in e, Yo Ji Yermamə na-jakvəhsi-pre kɨmi əmiə. Yo e Ji Yermamə, Tatə Kughen, rɨmnhajoun mə rɨkin ragien tuk Yo.” ");
INSERT INTO nwi_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kɨni iriə kɨmɨsaiyoh In mhamə, “?Naha norien yamə mɨne Kughen rorkeikei mə kɨmawə jakasor?” ");
INSERT INTO nwi_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Kɨni Yesu rɨni-pən tuk əriə mə, “Kɨmiə takasəkeikei mɨshatətə irak, mə Kughen rɨmnher-pə kɨn Yo. Nar e in e Kughen rorkeikei.” ");
INSERT INTO nwi_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kɨni iriə kɨmɨsaiyoh mɨn In mhamə, “?Mərɨg Ik takor naha nɨmtətien mə kɨmawə jaksəm kɨni yakshatətə iram tukun? ?Ik takor naha nhagɨn? ");
INSERT INTO nwi_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nɨpɨg rɨptawə mɨnə kupən kɨmɨseriwək ye tɨpəvsɨk, iriə kɨmɨsən ‘mana.’ Nəgkiarien kɨrik ye Nəkwəkwə kape Kughen ramni mɨmə, “‘In rɨmɨvəhsi-pən bred yame ramsɨ-pən ye rao ye neai mə iriə tukasən.’ ");
INSERT INTO nwi_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Mərɨg Yesu rɨmɨni-pən tuk əriə mɨmə, “Yakamni-pre əfrakɨs tuk əmiə mə, pəh nien mə Moses atuk e rɨmɨvəhsi-pre nəvɨgɨnien yame ramsɨ-pən ye rao ye neai, mə taksən. Kafak Tata e in e ravəhsi-pre nəvɨgɨnien əfrakɨs yame ramsɨ-pən ye rao ye neai, mə kɨmiə takasən. ");
INSERT INTO nwi_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mərɨg in ai bred kape Kughen, in e yermamə yame ramsɨ-pən ye rao ye neai mameiwaiyu-pə ye tokrei tanə. Kɨni bred e in e ravəhsi-pən nɨmraghien kɨmi narmamə ye tanɨmtanə.” ");
INSERT INTO nwi_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Kɨni iriə kɨmnhani-pən tukun mhamə, “Yemasur, vəh-sipəh bred e kɨmi əmawə kape nɨpɨg m-fam.” ");
INSERT INTO nwi_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kɨni Yesu rɨmɨni-pən tuk əriə mɨmə, “Yo e, yo Bred yame ravəhsi-pən nɨmraghien. Narmamə yamə mɨne kamhauə tuk Yo, to khapəh mɨn nɨsəmkərəvyen. Kɨni narmamə yamə mɨne kashatətə irak, to khapəh mɨn nɨsakwəkwəyen. ");
INSERT INTO nwi_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mərɨg Yo yɨmɨni-pre ta tuk əmiə mə nakasəm pawk Yo, mərɨg nakhapəh nɨshatətəyen irak. ");
INSERT INTO nwi_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Narmamə yamə mɨnə kafak Tatə ravəhsi-pə əriə kɨmi Yo, iriə tukhauə tuk Yo. Kɨni narmamə yamə mɨne tukhauə tuk Yo, to yakpəh nher-yerhav-yen kɨn əriə tuk nɨpɨg kɨrik. ");
INSERT INTO nwi_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","“Meinai pəh nien mə Yo yɨmasɨ-pən ye Rao ye Neai meiwaiyu-pə ye tokrei tanə mə jakor əmə narɨmnar yame yo yakorkeikei. Mərɨg yɨmauə mə jakor narɨmnar mɨnə e yame kafak Tatə rɨmnher-pə kɨn Yo tukun. ");
INSERT INTO nwi_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Kɨni In rɨpəh norkeikeiyen mə jakəpkərhav ye narmamə yamə mɨnə In rɨmnəhi-pə əriə kɨmi Yo. In rorkeikei mə, ye Nɨpɨg Kwasɨg, Yo jakor narmamə mɨnə e tukhamragh mɨn ye nɨmhəyen kapəriə. ");
INSERT INTO nwi_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Mərɨg in ai kafak Tatə In rorkeikei mə narmamə m-fam yame kamhavaag-pə tuk Yo e Tɨni, mɨshatətə irak, tukhavəh nɨmraghien rerɨn. Kɨni ye Nɨpɨg Kwasɨg, yo jakor narmamə mɨnə e tukhamragh mɨn ye nɨmhəyen.” ");
INSERT INTO nwi_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nəmehuə kape Isrel kɨmɨsərɨg nəgkiarien yame Yesu ramni mə In Bred yame ramsɨ-pən ye rao ye neai, meiwaiyu-pə ye tokrei tanə, kɨni kamhani hah In tukun, ");
INSERT INTO nwi_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","mhani-pən tuk əriə mɨnə mhamə, “Ah. Kwən e in Yesu, ji Josef. Kɨtawə kharkun kafan tatə mɨne mamə. ?Rhawor e ramni məkneikɨn mə In rɨmasɨ-pən ye rao ye neai meiwaiyu-pə ye tokrei tanə?” ");
INSERT INTO nwi_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Kɨni Yesu rɨmɨni-pən tuk əriə mə, “Rɨkimiə tukrɨpəh nəsɨkien məknenkɨn. ");
INSERT INTO nwi_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tatə Kughen yame rɨmnher-pə kɨn Yo, to rɨpipəh nɨvi-pəyen yermamə kɨrik ramuə tuk Yo, yermamə to rɨpəh nuəyen tuk Yo. Yermamə to rɨpəh nuə-atukien tuk yo mə jakor in ramragh mɨn ye nɨmhəyen, ye nɨpɨg kwasɨg. ");
INSERT INTO nwi_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nəgkiarien yame profet mɨnə kɨmnharai kupan ye Nəkwəkwə kape Kughen ramni məkneikɨn mə, “‘Kughen tukrhajoun narmamə m-fam.’ Yermamə yame ramətərɨg kɨn nhajounien kape Tatə Kughen, in tukramuə tuk Yo. ");
INSERT INTO nwi_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Yermamə kɨrik rɨkək yame rɨmnəm Tatə Kughen kɨn nɨmrɨn. Yermamə kɨrikianə əmə rɨmnəm, Yermamə e in e rɨmasɨ-pən tuk Kughen. ");
INSERT INTO nwi_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Yakamni-pre əfrakɨs tuk əmiə mə narmamə yamə mɨne kamhani nəfrakɨsien irak kwənhavəh ta nɨmraghien rerɨn. ");
INSERT INTO nwi_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yo e bred kape nɨmraghien rerɨn. ");
INSERT INTO nwi_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nar apnapɨg mə rɨpmiə mɨnə kɨmɨsən bred e ‘mana’ ye tɨpəvsɨk, mərɨg kwənhamhə. ");
INSERT INTO nwi_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mərɨg bred yame ramsɨ-pən ye rao ye neai mameiwaiyu-pə ai taktakun, in ror pɨsɨn. Bred e, rameiwaiyu-pə mə narmamə m-fam yamə mɨne kasən tukhapəh nhamhəyen. ");
INSERT INTO nwi_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yo e, Yo bred mragh, yame ramsɨ-pən ye rao ye neiai mameiwaiyu-pə ye tokrei tanə. Yermamə yame tukrən bred e, in tukramragh rerɨn. Kɨni Bred e, yame jakvəhsi-pre kɨmi narmamə ye tokrei tanə, in e, nɨprak.” ");
INSERT INTO nwi_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nəgkiarien a rɨmnor nəmehuə kape nəmə Isrel kasərer masotgoh kɨmi əriə mɨnə mhamə, “?Rhawor? ?Tukrhawor pən iran mɨne mɨvəhsi-pə nɨpran mə tuksən?” ");
INSERT INTO nwi_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “Yakamni-pre əfrakɨs tuk əmiə mə nakpihapəh nɨsənien nɨprak e Ji Yermamə, mɨpihapəh nhanɨmien nɨtawɨk, to nakpihapəh nhavəhyen nɨmraghien rerɨn. ");
INSERT INTO nwi_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Narmamə yamə mɨne tuksən nɨprak, mhanɨm nɨtawɨk tukhavəh nɨmraghien rerɨn. Kɨni ye Nɨpɨg kwasɨg, jakor əriə kamhamragh mɨn ye nɨmhəyen. ");
INSERT INTO nwi_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yakaməgkiar məkneikɨn meinai ratuatuk mə narmamə tukasəkeikei mɨsən nɨprak mhanɨm nɨtawɨk. ");
INSERT INTO nwi_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Narmamə yamə mɨne tuksən nɨprak, mhanɨm nɨtawɨk, tukharpɨn-pə ye nɨmraghien kafak. Kɨni Yo jakrɨpɨn-pən mɨn ye nɨmraghien kapəriə. ");
INSERT INTO nwi_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Kafak Tatə rɨmnher-pə kɨn Yo yakuə, In nuknei nɨmraghien. Kɨni Yo yakvəh nɨmraghien tukun. Ye norien kɨrikianə əmə mɨn, narmamə yamə mɨne tuksən nɨprak tukhavəh nɨmraghien iran. ");
INSERT INTO nwi_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yo e bred əfrakɨs, yame ramsɨ-pən ye Rao ye Neai, mameiwaiyu-pə ye tokrei tanə. Bred e rɨpəh nəmhenien kɨn bred kupan yame rɨpmiə mɨnə kɨmɨsən ye tɨpəvsɨk. Nar apnapɨg mə iriə kɨmɨsən bred a, mərɨg kwənhamhə ta. Mərɨg narmamə yamə mɨne kasən bred e, iriə tukhavəh nɨmraghien rerɨn.” ");
INSERT INTO nwi_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu rɨmɨni-ərhav nəgkiarien e nɨpɨg rɨmnhajoun narmamə apa ye nimə kape nofugɨnien apa Kapaneam. ");
INSERT INTO nwi_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Narmamə khapsaah kape Yesu kɨmɨsərɨg nəgkiarien e yame Yesu rɨmɨni, mhamə, “!E-he-o! Nəgkiarien e rɨskai pɨk. ?Pa e to rɨni nəfrakɨsien ye kafan nəgkiarien?” ");
INSERT INTO nwi_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Kafan narmamə mɨnə kɨsəsiwən-əsiwən, mərɨg In ruvɨrkun ta nərɨgien kapəriə, mɨni-pən tuk əriə mɨmə, “?Rhawor? ?Nətərɨgien kapəmiə rɨmneiwaiyu tuk nhajounien e kafak uə? ");
INSERT INTO nwi_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","?Mərɨg tukmə naksəm Yo Ji Yermamə yakamrerɨg faktə ye rao ye neai ikɨn yɨmasɨ-pən ikɨn kupan, takhani nəfrakɨsien irak uə nɨkam? ");
INSERT INTO nwi_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nanmɨn kape Kughen əmə rɨrkun nɨvəhsi-pənien nɨmraghien rerɨn kɨmi narmamə. Yermamə to rɨpəh nɨvəhyen nɨmraghien rerɨn ye nəsanɨnien əmə kafan. Nəgkiarien mɨnə e yakamni-pre tuk əmiə, iriə nəgkiarien yamə mɨne kamhasɨ-pən ye Nanmɨn kape Kughen yame ravəhsi-pən nɨmraghien kɨmi narmamə. ");
INSERT INTO nwi_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mərɨg kɨmiə tɨksɨn eikɨn e, nakhapəh nɨshatətəyen irak.” (Yesu ramni məkneikɨn meinai In ruɨrkun ta ye nɨrikakunien mə nɨ-pa mɨne khapəh nhaniyen nəfrakɨsien iran, muɨrkun mə iriə pa nhagɨn tukreighaan-pən kɨn In ye kwermɨ tɨkmɨr mɨnə kafan). ");
INSERT INTO nwi_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kɨni Yesu rɨmə, “Tuk nar e in e, yakwəni-ta tuk əmiə mə Tatə Kughen to rɨpipəh nɨvi-pəyen yermamə kɨrik ramuə tuk Yo, yermamə to rɨpəh nuəyen tuk Yo.” ");
INSERT INTO nwi_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ye nɨpɨg a, narmamə kape Yesu khapsaah kɨmɨsəpəh In, mhapəh nhakwasɨgien kɨn. ");
INSERT INTO nwi_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kɨni Yesu rɨmnaiyoh kafan narmamə twelef mɨmə, “?Rhawor irəmiə? ?Kɨmiə mɨn nɨmnhamə taksəpəh Yo uə?” ");
INSERT INTO nwi_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Mərɨg Saemon Pita rɨmɨni-pən tukun mə, “Yermaru. ?Tukmə yaksəpəh Ik, jakhavən tuk pa? Mə ik əmə. Kafam əmə nəgkiarien ravəhsi-pə nɨmraghien rerɨn. ");
INSERT INTO nwi_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kɨni kɨmawə yakshatətə iram, mɨnharkun ta mə Ik Yemə Rhakə kape Kughen.” ");
INSERT INTO nwi_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Kɨni Yesu rɨmɨni-pən tuk əriə mə, “Kɨmiə e narmamə twelef kafak. Yo e yɨmɨrpen əmiə. Mərɨg kɨmiə kɨrik in yarmhə.” ");
INSERT INTO nwi_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(In ramni Judas, ji Saemon Iskariot, meinai in mɨn kɨrik ye narmamə twelef kape Yesu, mərɨg kwasɨg ikɨn, rɨmneighan-pən kɨn In ye kwermɨ tɨkmɨr mɨnə kafan.) ");
INSERT INTO nwi_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kwasɨg ikɨn ye narɨmnar mɨnə a, Yesu rɨpəh norkeikeiyen mə tukrɨvən yerkwanu mɨnə ye Judia tuk norien kafan wok, meinai nəmehuə kape nəmə Isrel apaikɨn kamharai mhun apsapɨs tukun mə tukshopni. Kɨni rɨrerɨg mɨn mɨvən ye provins Galili. ");
INSERT INTO nwi_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mərɨg nɨpɨg ruauə ipakə tuk norien lafet kɨrik kape nəmə Isrel, kamni kɨmə “lafet kape nɨvəhsi-haktəyen nimə tapolen mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Kɨni naorahi Yesu mɨnə kɨmnhani-pən tukun mhamə, “Rhuvə mə taktərhav eikɨn e mamvən apa Judia, pəh narmamə kafam mɨnə apaikɨn tuksəm nɨmtətien yamə mɨne Ik nakamor. ");
INSERT INTO nwi_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Yuvən apaikɨn meinai yermamə yame rorkeikei mə narmamə tukharkun In, to rɨpəh nerkwaigien kɨn kafan wok. Mərɨg tukmə nakɨrkun norien nɨmtətien mɨnə, yuvən, mor əpu Ik ye nɨmrɨ narmamə khapsaah ye nɨpɨg kape lafet, pəh narmamə ye tanɨmtanə tuksəm.” ");
INSERT INTO nwi_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kasəgkiar məknakɨn meinai nar apnapɨg mə iriə naorahini atuatuk mɨnə, mərɨg khapəh nhaniyen nəfrakɨsien iran. ");
INSERT INTO nwi_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kɨni Yesu rɨni-pən tuk əriə mə, “Rɨpəh hanə norien nɨpɨg kafak. Mərɨg kɨmiə nakharkun nɨsorien nar ye nɨpɨg apnapɨg əmə. ");
INSERT INTO nwi_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Narmamə kape tokrei tanə e, iriə to khapəh nɨsəməkien əmiə. Mərɨg iriə tukasəkeikei masəməkɨn Yo, meinai Yo yakamni-ərhav mə kapəriə norien rɨpəh natuatukien. ");
INSERT INTO nwi_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kɨmiə havən ye lafet, mərɨg Yo to yakpəh nɨvənien, meinai rɨpəh hanə norien nɨpɨg kafak.” ");
INSERT INTO nwi_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Raməgkiar məknakɨn kɨni In maməmɨr əmə apa Galili. ");
INSERT INTO nwi_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kɨni naorahi Yesu mɨnə kɨmɨsəkupən mhavən ye lafet a, kwasɨg ikɨn, Yesu rɨpivən. Mərɨg In rɨmnaiyu apɨsapɨs əmə, mə narmamə tukhapəh nɨsəmien. ");
INSERT INTO nwi_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Kɨni nəmehuə kape nəmə Isrel khapsaah kɨmnhavən ye lafet a masarhakɨn In, mɨsaiyoh apnapɨg əmə narmamə mhamə, “?Kwən e in pukaa?” ");
INSERT INTO nwi_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ikɨn a, narmamə khapsaah kɨsəsiwən-əsiwən mamhani In. Tɨksɨn khamə, “In yemə huvə kɨrik;” mərɨg tɨksɨn khamə, “Nɨkam. In rameikuə ye narmamə.” ");
INSERT INTO nwi_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mərɨg iriə khapəh nɨsəvsao-ərhavyen kɨn Yesu, meinai kamhagɨn mə ta mə nəmehuə kape nəmə Isrel kɨsərɨg nəgkiarien yame kamhani. ");
INSERT INTO nwi_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Lafet a ramvən hanə, Yesu rɨmavən apa ye Nimə Ehuə kape Kughen, maməvhag kɨmi narmamə. ");
INSERT INTO nwi_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nəmehuə kape nəmə Isrel kɨmɨsərɨg nəgkiarien kafan, kɨsakur, mhamə, “?Kwən e rɨmnhawor mɨrkun narɨmnar mɨnə e ye Nəkwəkwə kape Kughen? Yemehuə kɨrik kapətawə rɨmɨpəh nhajounien In.” ");
INSERT INTO nwi_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Kɨni Yesu rɨni-pən tuk əriə mə, “Nəgkiarien yame yakamhajoun narmamə kɨn, pəh nien mə kafak. Ramsɨ-pən tuk Tatə Kughen yame rɨmnher-pə kɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Narmamə yamə mɨne nətərɨgien kapəriə ramskai mə tuksor narɨmnar yame Kughen rorkeikei, tukharkun mə nəgkiarien kafak ramsɨ-pən tuk Kughen; pəh nien mə kafak atuk əmə. ");
INSERT INTO nwi_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Narmamə yamə mɨne kasəgkiar atuk əmə ye kapəriə nehuəyen, iriə kasor əmə mə narmamə tukhavəh-si haktə əriə. Mərɨg Yo yakorkeikei mə narmamə tukhavəh-si haktə nhag yermamə yame rɨmnher-pə kɨn Yo. Yo yermamə kape nɨniyen nəfrakɨsien. To yakəpəh neikuəyen. ");
INSERT INTO nwi_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Moses rɨmɨvəhsi-pre loa kɨmi əmiə, mərɨg yermamə kɨrik rɨkək irəmiə raməri-pən fam loa mɨnə e. ?Rhawor e kɨmiə naksarkut mə takshopni Yo?” ");
INSERT INTO nwi_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kɨni narmamə khapsaah kɨmnhani-pən tukun mhamə, “!Man! ?Tukmə ror nanmɨn has ramərer-pən iram uə, mamor Ik nakamni nəgkiarien ətəwao uə? ?Pa e rɨmə tukrhopni Ik?” ");
INSERT INTO nwi_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Kɨni Yesu rɨmɨni-pən tuk əriə mɨmə, “Yo yɨmnor nɨmtətien kɨrikianə əmə ye Sabat, nɨmɨsəm, niemhaa ramhai əmiə fam tukun. ");
INSERT INTO nwi_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mərɨg kɨmiə mɨn nakasor wok ye Sabat, mamhavəh nao kɨmi kwajikovə mɨnə, raməri-pən loa kape Moses. (Mərɨg nəfrakɨsien mə pəh nien mə Moses rɨmɨrikakun norien kape nɨvəhyen nao kɨmi narmamə, mərɨg kaha mɨnə apa kupan kɨmnharikakun). ");
INSERT INTO nwi_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","?Mərɨg tukmə nakharkun nɨvəhyen nao kɨmi kwajikovə mɨnə ye Sabat, rəri-pən loa kape Moses, rhawor e niemha ramhai əmiə nɨpɨg yakamor huvə nɨprai yermamə kɨrik ye Sabat? ");
INSERT INTO nwi_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Takhapəh nɨsəkirien wok yame yakamor ye nərɨgien əmə kapəmiə, mərɨg taksəkir kafak wok ye nərɨgien yame ratuatuk.” ");
INSERT INTO nwi_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Kɨni ye nɨpɨg a, nəmə Jerusalem kɨmɨsaiyoh əriə mɨnə mhamə, “?Rhawor? ?Kwən e In e nəmehuə mɨnə kapətawə khamə tukshopni In uə? ");
INSERT INTO nwi_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mərɨg səm-ru. In ramni-ərhav nəgkiarien ye nɨmrɨ narmamə, mərɨg nəmehuə mɨnə khapəh nhani-pənien nar kɨrik tukun. ?Tukmə ror nəmehuə mɨnə kwənharkun ta mə In Kristo, uə? ");
INSERT INTO nwi_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mərɨg kɨtawə kharkun rukwanu kwən e rɨmasɨ-pən ikɨn. Mərɨg nɨpɨg Kristo tukramuə, narmamə tukseinein mə rɨsɨpkaa.” ");
INSERT INTO nwi_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ye nɨpɨg a, Yesu rɨnamərer ye Nimə Ehuə kape Kughen maməvhag kɨmi narmamə, kɨni mamokr-apomh mɨmə, “Kɨmiə nakharkun Yo, mharkun ikɨn yɨmasɨ-pən ikɨn. Mərɨg nəfrakɨsien mə pəh nien mə yɨmauə atuk əmə ye nərɨgien kafak. Mərɨg Kughen rɨmnher-pə kɨn Yo. Kɨni Kughen In nəfrakɨsien. Kɨmiə nakseinein In, ");
INSERT INTO nwi_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","mərɨg Yo yakɨrkun In, meinai yɨmasɨ-pən iran. Kɨni In rɨmnher-pə kɨn Yo.” ");
INSERT INTO nwi_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yesu raməgkiar məknakɨn, khamə tukharaptərəkɨn In. Mərɨg yermamə kɨrik rɨkək yame tukraptərəkɨn In, meinai rɨpəh hanə norien nɨpɨg kafan. ");
INSERT INTO nwi_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mərɨg narmamə khapsaah kɨmnhani nəfrakɨsien iran mhamə, “Tukmə ror Yesu in Kristo yame Kughen rɨmɨrpen mə tukrher-pə kɨn, meinai kɨmɨni mə nɨpɨg Kristo tukramuə, tukror nɨmtətien khapsaah. Kɨni yermamə rɨkək yame rɨrkun norien nɨmtətien rɨpsaah rapita In.” ");
INSERT INTO nwi_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Kɨni Farisi mɨnə kɨmɨsərɨg narmamə khapsaah kɨsəsiwən-əsiwən masəvsao kɨn Yesu. Kɨni Farisi mɨnə mɨne jif pris mɨnə kɨmɨsher-pən kɨn mobael yamə mɨne kasarha tuk Nimə Ehuə kape Kughen mə tukharaptərəkɨn Yesu. ");
INSERT INTO nwi_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kɨni Yesu rɨmə, “Yo jakamarə kɨtawə-mkɨmiə kape nɨpɨg kwakwə əmə. Kwasɨg ikɨn, jakrerɨg-pən mɨn tuk Yermamə yame rɨmnher-pə kɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ye nɨpɨg a in a, taksarha-kɨn Yo mərɨg to nakhapəh nɨsəmien Yo; meinai ikɨn yakamvən ikɨn, kɨmiə to nakhapəh nhavənien ikɨn.” ");
INSERT INTO nwi_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Kɨni nəmə Isrel kɨmɨsaiyoh əriə mɨnə mhamə, “?In rɨmə tukrɨvən hiə, mə to kɨtawə khapəh nɨsəmien In? ?Rɨmə tukrɨvən məm kwənərəus kape nəmə Isrel yamə mɨne kɨsarə iriə nəmə Gris apa tanə pɨsɨn pɨsɨn mɨnə, mamhajoun mɨn nəmə Gris uə? ");
INSERT INTO nwi_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","In rɨmɨni mə ye nɨpɨg a, kɨtawə tuksarha-kɨn In, mhapəh nɨsəmien In, meinai kwənmhan yame In tukrɨvən ikɨn, to kɨtawə khapəh nhavənien ikɨn. ?Nəgkiarien e, nɨpran ramni mə naha?” ");
INSERT INTO nwi_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Lafet natukror infamien, kamor nəvɨgɨnien yame in rehuə rapita nəvɨgɨnien tɨksɨn kape lafet. Kɨni ye nɨpɨg a, Yesu rɨmnərer ye nɨmrɨ narmamə mamokrən apomh mɨmə, “Yermamə yame rɨnəkwakwə, pəh in ruə tuk Yo, mɨnɨm nu. ");
INSERT INTO nwi_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Meinai Nəkwəkwə kape Kughen ramni mə, “‘Yermamə yame rhatətə irak, rəmhen kɨn nɨmrɨ nu yame ravəhsi-pən nɨmraghien ramkwor-kwor mhaktə mokrig yerkin mamaiyu.’” ");
INSERT INTO nwi_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu ramni nuhpɨkɨnien a, maməgkiar ye Nanmɨn kape Kughen yame kwasɨg ikɨn tukrɨpivəhsi-pən kɨmi narmamə yamə mɨne kashatətə iran. Mərɨg ye nɨpɨg a, Nanmɨn kape Kughen rɨpəh hanə nuəyen tuk narmamə, meinai Yesu rɨpəh hanə nɨvənien ye nɨkakien kafan ye rao ye neai. ");
INSERT INTO nwi_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yesu raməgkiar məknakɨn, narmamə kɨmɨsərɨg, kɨni tɨksɨn kamhani mhamə, “Kwən e in profet kape Kughen yame profet mɨnə kɨmnhani mə tukruə.” ");
INSERT INTO nwi_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Kɨni tɨksɨn khamə, “Kwən e in Kristo.” Mərɨg tɨksɨn khamə, “Nɨkam. ?Nakhamə ta mə Kristo tukrɨsɨ-pən apa Galili uə? ");
INSERT INTO nwi_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nəkwəkwə kape Kughen ramni mə Kristo tukraməkeikei mɨsɨ-pən ye kwənərəus kape King Deved, ye taon e Betlehem, imei Deved kupan.” ");
INSERT INTO nwi_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ror məkneikɨn, narmamə kɨmɨsəwhai kwhen kapəriə tuk Yesu. ");
INSERT INTO nwi_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tɨksɨn khamə tukharaptərəkɨn In; mərɨg yermamə kɨrik rɨkək yame tukrɨraptərəkɨn In. ");
INSERT INTO nwi_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kɨni mobael mɨnə kɨmnhavən mɨsəm jif pris mɨnə mɨne Farisi mɨnə. Kɨni nəmehuə mɨnə a kɨmɨsaiyoh mobael mɨnə mhamə, “?Rhawor e nɨmnhapəh nharaptərəkɨnien Yesu mhakɨr mhauə?” ");
INSERT INTO nwi_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Kɨni mobael mɨnə khani-pən tuk əriə mhamə, “Yɨmnhapəh nharaptərəkɨnien In meinai yermamə kɨrik rɨpəh hanə nhajounien rəmhen kɨn In.” ");
INSERT INTO nwi_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Kɨni Farisi mɨnə kɨmnhani-pən tuk əriə mhamə, “?Rhawor? ?In rɨmɨvi əmiə kɨn nekuəyen kafan uə? ");
INSERT INTO nwi_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","?Kapətawə kɨrik yemehuə rɨkək mɨne Farisi kɨrik yame ramni nəfrakɨsien iran. ");
INSERT INTO nwi_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Narmamə apnapɨg əmə yamə mɨne kaseinein əgkap loa kape Moses kamhani nəfrakɨsien iran. Pəh iriə tukasarə ye narpɨnien kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Kɨni Nikodimas e, in Farisi kɨrik. Kɨni in a iriə min. Kwən a, apa kupan rɨmavən maməgkiar kɨmi Yesu. Kɨni rarar mɨni-pən tuk əriə mɨmə, ");
INSERT INTO nwi_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“?Rhawor? Loa kapətawə ramni mə kwasɨg ikɨn tukhani-əhrav narpɨnien kape yermamə kɨrik, tukasəkeikei mɨsəkupan mhavən, mɨsətərɨg kɨn nəgkiarien kafan, mɨsəm atuatuk naha nhagɨn yame rɨmnor.” ");
INSERT INTO nwi_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Kɨni khani-pən tukun mhamə, “?Rhawor? ?Ik mɨn ik yemə Galili, uə? Yuvən-ru məvheikɨn Nəkwəkwə kape Kughen, məm atuatuk mə profet a kape Kughen to rɨpəh nɨsɨ-pənien ye Galili.” ");
INSERT INTO nwi_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kɨni narmamə kɨmnharerɨg-pən yerkwanu mɨnə kapəriə. ");
INSERT INTO nwi_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Mərɨg Yesu rɨmnhaktə fiak ye tukwas e kamni kɨmə Olif. ");
INSERT INTO nwi_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kəni rɨkwamer kɨn, Yesu rɨrerɨg-pən mɨn ye Nimə Ehuə kape Kughen. Kɨni narmamə khapsaah kɨmnhauə, masərer ərkurao iran, kɨni In rəkwətə maməvhag kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kɨni nəmhajoun mɨnə kape loa, mɨne Farisi mɨnə khakɨr piraovɨn kɨrik mhauə tukun, mɨsərɨp-ərhav in ye nɨmrɨ narmamə. Narmamə kɨmɨsəm əpu mə pian a rɨmnapɨr iriu yerman pɨsɨn. ");
INSERT INTO nwi_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kɨni iriə kɨmnhani-pən tuk Yesu mhamə, “Yhajoun. Narmamə kɨmɨsəm əpu mə pian e rɨmnapɨr iriu yerman pɨsɨn. ");
INSERT INTO nwi_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moses rɨmnərəhu loa kɨrik ye loa kapətawə mamni mə tukmə piraovɨn yame ramapɨr-pən apnapɨg tuk yerman, tukaməkeikei karkwhopni in. ?Mərɨg ik nakmə rhawor?” ");
INSERT INTO nwi_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iriə kɨmɨsaiyoh məknakɨn masor kiko-iko, mə Yesu tukrɨni nəgkiarien kɨrik yame rɨpəh nəmhenien, pəh kɨsəm-pən nar has kɨrik iran, mhavəhsi-pən narpɨnien kɨmin. Mərɨg Yesu rapnapɨg əmə, məmrəmɨr, mamrai-pən nar ye nɨmoptanə kɨn kwənkwai kwermɨn. ");
INSERT INTO nwi_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mərɨg iriə kasəkeikei mɨsaiyoh In. Kɨni In rərer, mɨni-pən tuk əriə mə, “Nəmhen. Tukmə kɨmiə kɨrik e ikɨn e kafan norien has rɨkək, pəh in tukrəkupən markwhopni pian e.” ");
INSERT INTO nwi_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kɨni In məmrəmɨr mɨn mamrai-pən nar ye nɨmoptanə. ");
INSERT INTO nwi_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kɨni iriə kɨmɨsərɨg nəgkiarien kafan, mɨsəriwək kɨrikianə kɨrikianə mɨsap, rɨrikakun ye nəwharu mɨnə meriaji nɨtamaruə. Iriə kɨmɨsap, mhapəh əmə Yesu mɨne pian ai kawəmɨr. ");
INSERT INTO nwi_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kɨni Yesu rhekɨmter mɨn mɨni-pən tuk pian ai mɨmə, “Pian əpə. ?Narmamə mɨnə apa kwənhaukaa? ?Yermamə ruɨkək yame tukrɨni-ərhav kafam narpɨnien uə?” ");
INSERT INTO nwi_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Kɨni pian a rɨmɨni-pən tukun mɨmə, “Yemehuə. Yermamə rɨkək yame to rɨvəhsi-pə narpɨnien kɨmi yo.” Kɨni Yesu rɨni-pən tukun mə, “Ror pən Yo mɨn to yakpəh nɨvəhsi-preyen narpɨnien kɨmik. Mərɨg amvən, məpəh əmə norien yame mɨne rahas.” ");
INSERT INTO nwi_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kɨni Yesu rɨni-pən mɨn tuk əriə mɨmə, “Yo e, yo Nɨkhakien kape narmamə m-fam ye tokrei tanə. Narmamə yamə mɨne kamhakwasɨg kɨn Yo to khapəh nɨseriwəkien ye nəpɨgnəpien, mərɨg tukhavəh nɨkakien yame ravəhsi-pən nɨmraghien kɨmi əriə.” ");
INSERT INTO nwi_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kɨni Farisi mɨnə kɨmnhani-pən tukun mhamə, “Ik nakamni-əhrav məknakɨn Ik, mərɨg yermamə kɨrik rɨkək yame tukrərer-ərhav mamni əfrakɨs mə kafam nəgkiarien raməfrakɨs. To kafam nəgkiarien rɨpəh nərerien.” ");
INSERT INTO nwi_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Kɨni Yesu rɨni mɨmə, “Ǝwəh. Nəfrakɨsien mə Yo atuk əmə yakamni-ərhav Yo. Mərɨg nəgkiarien kafak in tukramərer tɨmtɨm, meinai Yo yakɨrkun aikɨn yɨmasɨ-pən ikɨn. Kɨni mɨrkun mɨn aikɨn yakamvən ikɨn. Mərɨg kɨmiə nakseinein aikɨn yakamvən ikɨn mɨne ikɨn yɨmasɨ-pən ikɨn. ");
INSERT INTO nwi_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kɨmiə e naksəkir norien kape narmamə ye nətərɨgien əmə kape yermamə. Mərɨg Yo yakpəh nəkirien norien kape narmamə məknakɨn. ");
INSERT INTO nwi_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mərɨg tukmə yakəkir norien kape yermamə, yakamor ye norien yame ratuatuk. Mərɨg pəh nien mə yakaməkir ye nətərɨgien əmə kafak, mərɨg kɨmru Tatə Kughen yame rɨmnher-pə kɨn Yo, kapəmru nəkirien kɨrikianə əmə. ");
INSERT INTO nwi_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kɨmɨrai ye loa kapəmiə kɨmə, “Tukmə yermamə kɨraru karəni nar kɨrikianə əmə, pəh narmamə tukharkun mə nəgkiarien kapəriu raməfrakɨs.” ");
INSERT INTO nwi_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Kɨni taktakun ai, Yo yakamni-ərhav Yo, mərɨg Rɨmɨk yame rɨmnher-pə kɨn Yo, ramor nəgkiarien kafak ramərer tɨmtɨm.” ");
INSERT INTO nwi_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kɨni kɨmɨsaiyoh In mhamə, “?Mərɨg kafam hiə tatə?” Kɨni In rɨmə, “Kɨmiə nakseinein Yo, mɨseinein mɨn Tatə kafak. Nakpiharkun Yo, to nakpiharkun mɨn kafak Tatə.” ");
INSERT INTO nwi_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu rɨmɨni nəgkiarien a nɨpɨg in rɨmnamhajoun narmamə apa ikɨn kamərəhu-pən mane ikɨn ye Nimə Ehuə kape Kughen. Mərɨg kwən kɨrik rɨkək yame to rɨvən mɨraptərəkɨn In meinai rɨpəh hanə norien nɨpɨg kafan. ");
INSERT INTO nwi_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Kɨni Yesu rɨmɨni-pən mɨn tuk əriə mɨmə, “Tuk nɨpɨg kɨrik, jakɨrkək, kɨni kɨmiə taksarha kɨn Yo. Mərɨg nɨpɨg takhamhə, narpɨnien kape təvhagə has kapəmiə tukraməmɨr irəmiə. Kɨmiə nakseinein nhavənien aikɨn yakamvən ikɨn.” ");
INSERT INTO nwi_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nɨpɨg rɨmɨni məknakɨn, mukreikɨn kapən kapə nəmehuə kape nəmə Isrel. Khamə, “?Rhawor e kɨtawə kaseinein nhavənien aikɨn ramvən ikɨn? ?Tukmə ror tukrhopni atuk In uə?” ");
INSERT INTO nwi_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Mərɨg Yesu rɨrpɨn nəgkiarien mɨmə, “Kɨmiə, iməmiə eikɨn e. Mərɨg Yo yakmasɨ-pən apa ye rao ye neai meiwaiyu-pə. Tokrei tanə e pəh nien mə imak ikɨn. ");
INSERT INTO nwi_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ror məkneikɨn, yakamni-pre tuk əmiə mə kɨmiə takhamhə, narpɨnien kape təvhagə has kapəmiə tukraməmɨr irəmiə. Tukmə nakhapəh nhaniyen nəfrakɨsien mə yo e Kristo, nɨpɨg takhamhə, narpɨnien kape təvhagə has kapəmiə tukraməmɨr irəmiə.” ");
INSERT INTO nwi_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kɨni iriə kɨmnhani-pən tukun mhamə, “!Eh! ?Ik pa en?” Kɨni In rɨmɨni-pən tuk əriə mə, “Yo e yakaməvsao kɨn Yo ye nɨpɨg yame yɨmɨrikakun nhajounien kafak meriaji-pə e taktakun. ");
INSERT INTO nwi_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yakɨrkun nɨniyen narɨmnar rehuə irəmiə, mɨvəhsi-pre narpɨnien ehuə kɨmi əmiə. Mərɨg jakamni əmə nəgkiarien yame Yermamə yame rɨmnher-pə kɨn Yo ramni-pə tuk Yo. Nəgkiarien yame In ramni raməfrakɨs. Kɨni yakamni-ərhav pən nəgkiarien kɨmi narmamə fam ye tokrei tanə yame In ramni-pə tuk Yo.” ");
INSERT INTO nwi_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Mərɨg iriə khapəh nharkunien mə Yesu raməgkiar ye Rɨmni Kughen. ");
INSERT INTO nwi_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ror pən, In rɨni-pən tuk əriə mə, “Nɨpɨg kɨmiə takpiharuk haktə Yo, Ji Yermamə, mɨpiharkun mə nəgkiarien yame yakamni irak in raməfrakɨs. Kɨni mɨpiharkun mɨn mə yakpəh norien nar kɨrik ye nətərɨgien əmə kafak, mərɨg yakamni əmə nəgkiarien yame Rɨmɨk ramni-pə tuk Yo. ");
INSERT INTO nwi_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yermamə yame rɨmnher-pə kɨn Yo ramarə kɨmru min. In rɨpəh nəpəhyen Yo yakəriwək Yo pɨsɨn. Meinai nɨpɨg m-fam yakamor naha nhagɨn yame In rorkeikei.” ");
INSERT INTO nwi_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesu ramni nəgkiarien e, narmamə khapsaah khani nəfrakɨsien iran. ");
INSERT INTO nwi_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kɨni Yesu rɨmnəgkiar kɨmi nəmehuə kape nəmə Isrel yamə mɨne kɨmnhani nəfrakɨsien iran mɨmə, “Tukmə nakharaptərəkɨn tɨm tɨm nəgkiarien yame yakamni-pre tuk əmiə, kɨmiə atuatuk e narmamə kafak mɨnə. ");
INSERT INTO nwi_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kɨni kɨmiə takharkun nəfrakɨsien. Kɨni nəfrakɨsien en tukrɨrɨsɨn əmiə nakhapiəpiə.” ");
INSERT INTO nwi_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Kɨni iriə kɨmnhani-pən tukun mhamə, “!Ah! Kɨtawə e kwənərəus kape Ebraham. Kɨtawə khapəh nɨsor-atuə-kɨnien kape yermamə kɨrik. ?Rhawor e nakamni mə nar kɨrik tukraməkeikei mɨrɨsɨn əmawə yakhapiəpiə?” ");
INSERT INTO nwi_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Kɨni Yesu rɨni-pən tuk əriə mə, “Yakamni-pre əfrakɨs tuk əmiə mə narmamə yamə mɨne kasor norien has, norien has ramarmaru irəriə, mamraptərəkɨn əriə mamor əriə kamhauə yorwok mɨnə kafan. ");
INSERT INTO nwi_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kɨni nakharkun mə yorwok kɨrik, kafan yemehuə to rɨpəh neighanien kɨn in mə tukramarə ye nimə kafan. Mərɨg yemehuə rameighan əmə kɨn tɨni mə tukramarə ye nimə kape yamehuə kape nɨpɨg m-fam. ");
INSERT INTO nwi_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ror pən, tukmə Yo Ji Kughen yakamrɨsɨn əmiə, jakrɨsɨn əfrakɨs əmiə nakhapiəpiə. ");
INSERT INTO nwi_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yakɨrkun mə kɨmiə kwənərəus kape Ebraham. Mərɨg nakasarha-kɨn swatuk tuk nhopniyen Yo, meinai nakhapəh nɨsorkeikeiyen mə taksətərɨg kɨn kafak nəgkiarien. ");
INSERT INTO nwi_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yo yakamni narɨmnar mɨnə e yame yɨmnəm kafak Tatə ramor. Mərɨg kɨmiə nakasor narɨmnar yame kapəmiə tatə mɨnə kɨmnhani-pre tuk əmiə.” ");
INSERT INTO nwi_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Kɨni iriə kɨmnhani-pən tukun mhamə, “Mərɨg rɨmtawə e Ebraham.” Kɨni Yesu rɨmɨni-pən tuk əriə mɨmə, “To rɨpi mə kɨmiə kwənərəus atuatuk kape Ebraham, to norien kapəmiə rɨpiəmhen kɨn norien kape Ebraham kupan. ");
INSERT INTO nwi_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yo yakamni-pre nəgkiarien əfrakɨs tuk əmiə yame Kughen rɨmɨni-pə tuk Yo. Mərɨg kɨmiə nakhamə takshopni Yo. Mərɨg to Ebraham rɨpəh norien məknenkɨn. ");
INSERT INTO nwi_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kɨmiə nakasor əmə norien kape tatə atuatuk kapəmiə.” Kɨni iriə kɨmnhani-pən tukun mhamə, “Pəh nien mə kɨmawə e kwajikovə kape swatuk. Kughen pɨsɨn əmə In rɨmɨmawə.” ");
INSERT INTO nwi_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “To rɨpi mə kapəmiə əfrakɨs e tatə Kughen, to nakpisorkeikei Yo, meinai Yo yɨmasɨ-pən iran, muə eikɨn e. Pəh nien mə yɨmauə ye kafak nərɨgien. Mərɨg yɨmauə meinai In rɨmnher-pə kɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","?Mərɨg rhawor e nakhapəh nharkunien nɨprai nəgkiarien kafak? Meinai nakhapəh nɨsorkeikeiyen mə taksərɨg nəgkiarien kafak. ");
INSERT INTO nwi_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kɨmiə, norien kapəmiə rəmhen əmə kɨn rɨmɨmiə e Setan. Kɨni nɨpɨg m-fam naksorkeikei mə takasor nəkwan. Norien kafan yame in rɨmɨrikakun mamor, ramor hanə. In yermamə kape nhopniyen yermamə. In raməməkɨn nəfrakɨsien, meinai nəfrakɨsien rɨkək iran. In rameikuə məknakɨn meinai in a norien hanə kafan. In yeikuə, mɨne tatə kape neikuəyen. ");
INSERT INTO nwi_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mərɨg Yo yakamni-pre əmə nəgkiarien əfrakɨs tuk əmiə. Ror pən, nakhapəh nhaniyen nəfrakɨsien ye kafak nəgkiarien. ");
INSERT INTO nwi_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yo yakpəh hanə norien norien has; ror pən kɨmiə kɨrik rɨpəh hanə nəm-pə-yen nar has kɨrik irak. Yakamni-pre nəgkiarien əfrakɨs tuk əmiə. ?Rhawor e nakhapəh nhaniyen nəfrakɨsien irak? ");
INSERT INTO nwi_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Narmamə kape Kughen kasor nəkwai Kughen; mərɨg pəh nien mə kɨmiə kwajikovə mɨnə kape Kughen, nakhapəh nɨsorien nəkwan.” ");
INSERT INTO nwi_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Kɨni nəmehuə kape nəmə Isrel kɨmɨshek In mamhani mhamə, “!Man! Yakwəsəm əpu ik, mharkun mə ik pa. Ik nakəmhen kɨn yemə Sameria kɨrik yame nanmɨn has ramərer-pən iran.” ");
INSERT INTO nwi_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Mərɨg Yesu rɨmə, “Nanmɨn has rɨkək irak. Mərɨg yakamsiai Rɨmɨk; kɨni kɨmiə nakhapəh nhasiaiyen Yo. ");
INSERT INTO nwi_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yo yakpəh narkutien mə nhagɨk tukrehuə; mərɨg yermamə kɨrik aikɨn yame ramarkut mə nhagɨn tukrehuə. Kɨni In tukrɨpiəkir narmamə m-fam. ");
INSERT INTO nwi_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Yakamni-pre əfrakɨs tuk əmiə mə yermamə yame ramor kafak nəgkiarien to rɨpəh nɨmhəyen tuk nɨpɨg kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Kɨni nəmehuə kape nəmə Isrel kɨmnhani-pən tukun mhamə, “!Yakwənharkun ai taktakun mə nanmɨn has ramərer-pre iram! Meinai Ebraham rɨmamhə, kɨni profet mɨnə kɨmnhamhə mɨn, mərɨg Ik nakamni mə yermamə yame ramor nəkwam to rɨpəh nɨmhəyen tuk nɨpɨg kɨrik. ");
INSERT INTO nwi_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","?Nakmə Ik nakehuə rapita Ebraham e rɨptawə yame ruamhə ta, mɨne profet yamə mɨne kwənhamhə ta? ?Nakmə ik e pa?” ");
INSERT INTO nwi_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “To yakvəhsi-haktə atuk Yo mamor nhagɨk ramehuə, kafak nəgkiarien in ror nar apnapɨg əmə kɨn. Mərɨg kafak Tatə e yame kɨmiə nakamhani mə In Kughen kapəmiə In ravəhsi-haktə Yo, mamor nhagɨk ramehuə. ");
INSERT INTO nwi_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kɨmiə nakseinein pawk In; mərɨg Yo yakɨrkun In. To yakpini mə yakeinein In, mɨpiuə yeikuə rəmhen kɨn yame kɨmiə nəmeikuə mɨnə. Mərɨg yakɨrkun In mamor nəkwan. ");
INSERT INTO nwi_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Rɨpmiə e Ebraham rɨkin ramagien pɨk mə tukrɨpiəm nɨpɨg kafak yame tukrɨpiuə. Kɨni nɨpɨg in ruɨrkun mə nɨpɨg kafak rɨnamuə, kɨni rɨkin ramagien əmə tukun.” ");
INSERT INTO nwi_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kɨni nəmehuə kape Isrel kɨmnhani-pən tukun mhamə, “!Man! Ik tamaruə əmə kɨrik, kafam newk rɨpəh hanə neriaji-pənien fifti. ?Rhawor e nakamni mə nɨmnəm yemə tu e Ebraham?” ");
INSERT INTO nwi_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Kɨni Yesu rɨmə, “Yakamni-pre əfrakɨs tuk əmiə mə Ebraham rɨpəh hanə narhayen, Yo yaknarə ta.” ");
INSERT INTO nwi_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Məkneikɨn khapɨk kapier asur mɨnə mə tuksarkwhopni In kɨn. Mərɨg Yesu rɨmnerkwaig, map ta irəriə ye Nimə Ehuə kape Kughen mamvən. ");
INSERT INTO nwi_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nɨpɨg kɨrik, Yesu rɨnaməriwək mamavən, kɨni məm kwən kɨrik nɨmrɨn rɨmapɨs hanə. ");
INSERT INTO nwi_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Kɨni narmamə kape Yesu khauə mhani-pən tukun mhamə, “Yhajoun. Kwən kɨrik e rɨmnarha, nɨmrɨn ruapɨs ta. Takni-ru mə rhawor ror məknakɨn. ?Ravəh narpɨnien ye norien has kape tatə uə mamə kafan, uə ravəh narpɨnien ye norien has kɨrik kafan yame rɨmnor?” ");
INSERT INTO nwi_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Mərɨg Yesu rɨmə, “Nɨmrɨ kwən e ramahas, mərɨg pəh nien mə ravəh narpɨnien ye norien has kɨrik kafan, uə kape tatə uə mamə. Mərɨg nɨmrɨn ramapɨs məkneikɨn mə Kughen tukrhajoun kafan wok ye nɨmraghien kafan. ");
INSERT INTO nwi_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kɨtawə kasarə ye nɨpɨg kape nɨkakien, tukasəkeikei masor wok kape Yermamə yame rɨmnher-pə kɨn Yo. Mərɨg nɨpɨg kape nəpɨgnəpien tukruə, tukseinein nɨsorien wok ye nɨpɨg a. ");
INSERT INTO nwi_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nɨpɨg yakamarə ye tokrei tanə e, Yo nɨkakien kape narmamə m-fam ye tokrei tanə.” ");
INSERT INTO nwi_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu rɨni-ta nəgkiarien a, mɨvəh nɨmoptanə mərɨg-əvhin, rəptɨg, mərəhu-pən ye nɨmrɨ yermamə a. ");
INSERT INTO nwi_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Mɨni-pən tukun mɨmə, “Takvən mar ye nu apa Saeloam.” (Nhag e Saeloam, nɨpran ramni mə, “Kher-pən kɨn.”) Kɨni ai rɨmavən, mar ye nu, kɨni marha maməm nar, mɨrerɨg-pən iman yerkwanu. ");
INSERT INTO nwi_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kɨni nəmə iman ikɨn, mɨne narmamə yamə mɨne kharkun in, mə in yermamə kɨrik yame nɨpɨg m-fam ramaiyoh-pən kɨn mane, kɨmɨsəm in, kɨsakur. Mɨsaiyoh-pən əriə mɨnə mhamə, “!Eh! ?Kwən e in e yermamə yame nɨpɨg m-fam in ramkwətə mamaiyoh-pən kɨn mane kɨmi narmamə, uə nɨkam?” ");
INSERT INTO nwi_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Kɨni tɨksɨn khamə, “Ǝwəh. Mə in.” Mərɨg tɨksɨn khamə, “Nɨkam. To nakəm, nakmə in. Mərɨg pəh nien mə in.” Mərɨg kwən a rɨmə, “!Mə yo e!” ");
INSERT INTO nwi_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kɨni iriə kasəkeikei kɨmin mə tukrɨni mə rɨmnhawor nɨmrɨn rhuvə. ");
INSERT INTO nwi_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Kɨni in rɨmə, “Kwən e, nhagɨn e Yesu, in rɨmɨvəh nɨmoptanə mərɨg-əvhin rəptɨg, mərəhu-pən ye nɨmrɨk mir, mɨni-pə tuk yo mə jakvən ye nu apa Saeloam, mar. Kɨni yakvən mar. Məkneikɨn məm nar.” ");
INSERT INTO nwi_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Kɨni iriə kɨsaiyoh-pən mɨn in mhamə, “?Mərɨg kwən en ramarə hiə?” Kɨni in rɨmə, “?Hei? Yakeinein.” ");
INSERT INTO nwi_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kɨni khakɨr in mhauə kɨmi Farisi mɨnə. ");
INSERT INTO nwi_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nɨpɨg Yesu rɨmɨvəh nɨmoptanə mərɨg əvhin rəptɨg mərəhu-pən ye nɨmrɨn mir, nɨpɨg a ye Sabat. ");
INSERT INTO nwi_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ror pən, Farisi mɨnə mɨn kɨsaiyoh-pən kwən a mhamə, “?Rhawor nɨmrɨm rhuvə?” Kɨni kwən a rɨni-pən tuk əriə mɨmə, “Yesu rɨmnor-pən nɨmtəgei ye nɨmrɨk, kɨni yɨmavən mar, kɨni nɨmrɨk rhuvə.” ");
INSERT INTO nwi_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kɨni Farisi mɨnə kɨmɨsəwhai kwhen kɨraru kapəriə tuk nəgkiarien a. Tɨksɨn kɨmnhani mhamə, “Tukmə ror məkneikɨn, Yesu rɨpəh nɨsɨ-pənien ye Kughen, meinai In rɨmnakapɨr Sabat.” Mərɨg tɨksɨn khamə, “Nɨkam. Ramsɨ-pən ye Kughen. Meinai yor təvhagə has to rɨpəh norien nɨmtətien mɨnə məknakɨn.” ");
INSERT INTO nwi_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kɨni iriə kɨsaiyoh mɨn kwən a nɨmrɨn ramapɨs kupan, mhamə, “?Kwən a rɨmnor huvə nɨmrɨm, nakmə In naha yermamə? ?Kɨni rɨkim ramhaw-əsɨk?” Kɨni in rɨni-pən tuk əriə mɨmə, “In profet kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mərɨg nəmehuə mɨnə kape nəmə Isrel khapəh nhaniyen nəfrakɨsien iran mə in apa kupan kwən a nɨmrɨn rɨmapɨs, mərɨg taktakun ai raməm nar. Ror pən, kɨsokrən kɨn rɨmni mɨne nɨsɨni kɨrauə. ");
INSERT INTO nwi_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Kɨsaiyoh-pən əriu mhamə, “?Rhawor? ?Kapəmiru e kwajikovə uə? ?Rɨmnarha nɨmrɨn rɨpɨs uə nɨkam? ?Rɨmnhawor nɨmrɨn rhuvə?” ");
INSERT INTO nwi_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Kɨni rɨmni mɨne nɨsɨni krəmə, “Yakrarkun mə kapəmru e kwajikovə. Nɨpɨg rɨmnarha, nɨmrɨn rɨpɨs. ");
INSERT INTO nwi_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mərɨg yakweinein mə rɨmnhawor nɨmrɨn rhuvə. Maweinein mə pa nhagɨn rɨmnor huvə nɨmrɨn. Saiyoh in. Mə rɨkin rɨnarə ta. In rɨrkun nəvsaoyen kɨn in.” ");
INSERT INTO nwi_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Karəni məknakɨn meinai krəgɨn kɨn nəmehuə mɨnə kape nəmə Isrel, meinai nəmə Isrel kɨmnhani əutən mə tukmə yermamə kɨrik ramni-ərhav mə Yesu in Kristo, tukhapəh nɨseighanien kɨn rauru-pən ye nimə kape nofugɨnien. ");
INSERT INTO nwi_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ror pən, rɨmni mɨne nɨsɨni kɨrəni mɨrəmə, “Saiyoh in. Mə rɨkin rɨnarə ta.” ");
INSERT INTO nwi_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kɨni kɨsokrən mɨn kɨn kwən a yame kupan nɨmrɨn rɨmapɨs, mə tukruə mərer ye nɨmrɨriə. Kɨni kashek in mhamə, “Ni əfrakɨs əmə, mɨvəhsi-haktə nhag Kughen. Kɨtawə kharkun mə Yesu In yor təvhagə has əmə.” ");
INSERT INTO nwi_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mərɨg kwən ai rɨmə, “Yo yakeinein mə kwən a in yor təvhagə has uə nɨkam. Nar kɨrikianə əmə yame yo yakɨrkun. Apa kupan, nɨmrɨk rɨmapɨs. Mərɨg taktakun ai, yaknaməm nar.” ");
INSERT INTO nwi_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kɨni kɨsaiyoh-pən mɨn in mhamə, “?Rɨmnhawor ik? ?Rɨmnhawor mor huvə nɨmrɨm?” ");
INSERT INTO nwi_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mərɨg in rɨmə, “Yakwəni-pre ta tuk əmiə, mərɨg kɨmiə nakhapəh nɨsətərɨgien kɨn yo. ?Rhawor nakhamə jakəvsao mɨn kɨn? ?Kɨmiə mɨn nakhamə takhauə narmamə kape Yesu mɨnə, uə?” ");
INSERT INTO nwi_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kɨni iriə kashek in, mamhani hah in, mhamə, “!Ah! !Ik e kafan kɨrik yermamə! Mərɨg kɨmawə narmamə kape Moses. ");
INSERT INTO nwi_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kɨmawə yakharkun huvə mə Kughen rɨmnəgkiar kɨmi Moses; mərɨg kɨmawə yakseinein mə kwən en rɨmasɨpkaa.” ");
INSERT INTO nwi_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kɨni kwən ai rɨmə, “!Nəfrakɨsien! Kwən a rɨmnor huvə nɨmrɨk, mərɨg kɨmiə nakseinein mə rɨmasɨpkaa. ");
INSERT INTO nwi_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kɨtawə kharkun mə Kughen rɨpəh nətərɨgien kɨn yor təvhagə mɨnə. Mərɨg yermamə yame ramsiai Kughen, mamor nəkwan, kɨni Kughen ramətərɨg kɨn! ");
INSERT INTO nwi_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Yermamə kɨrik rɨkək yame rɨrkun nor-huvəyen yermamə rɨmnarha əmə nɨmrɨn rɨpɨs. ");
INSERT INTO nwi_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","To Yesu rɨpipəh nɨsɨ-pənien ye Kughen, to rɨpipəh norien nar kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Kɨni iriə kɨmɨshek mɨn in mhamə, “!Kəsi! Ik yermamə kape norien has nɨpɨg mɨfam, rɨrikakun ye nɨpɨg yame nɨmnarha-pə, muə meriaji-pə ai taktakun. ?Rhawor e nakmə takhajoun əmawə?” Kɨni kɨsher-ye-rhav kɨn In ye nimə kape nofugɨnien. ");
INSERT INTO nwi_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Kɨni Yesu rɨmnərɨg nəvsaoyen kɨn, mə kɨmnher-ye-rhav kɨn kwən ai ye nimə kape nofugɨnien. Kɨni rɨvən mɨvaag-pən kɨn, maiyoh-pən in mɨmə, “?Ik nakamni nəfrakɨsien ye Ji Yermamə?” ");
INSERT INTO nwi_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Kɨni kwən a rɨmə, “Yemehuə. ?Ji Yermamə e pa? Ni-pə huvə tuk yo, pəh jakni nəfrakɨsien iran.” ");
INSERT INTO nwi_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Kɨni Yesu rɨni-pən tukun mɨmə, “Ik naknəm ta In. Yo e yakaməgkiar kɨmik ai taktakun.” ");
INSERT INTO nwi_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kɨni kwən ai rɨmə, “Yermaru. Yo yakamhatətə iram.” Kɨni in mənɨmkur maməhuak kɨmin. ");
INSERT INTO nwi_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Kɨni Yesu rɨni-pən tukun mɨmə, “Yo yɨmauə ye tokrei tanə mə jakəkir narmamə. Mor narmamə yamə mɨne khapəh nɨsəm-huvəyen nar, kɨsəm huvə nar. Mamor narmamə yamə mɨne kasəm huvə nar, iriə tukhapəh nɨsəmien nar.” ");
INSERT INTO nwi_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Kɨni Farisi mɨnə tɨksɨn kɨmɨsərɨg nəgkiarien kafan mhamə, “?Rhawor? ?Nakmə nɨmrɨmawə rɨpɨs mɨn uə?” ");
INSERT INTO nwi_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “To nakpihani-ərhav mə nakhapəh nɨsəm-huvəyen nar, to nakpihapəh nhavəhyen narpɨnien tuk təvhagə has kapəmiə. Mərɨg kɨmiə nakhamə ta mə naksəm huvə nar, kɨni narpɨnien kape təvhagə has kapəmiə raməmɨr hanə irəmiə.” ");
INSERT INTO nwi_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Kɨni Yesu rɨmə, “Yakamni-pre əfrakɨs tuk əmiə mə tukmə yəkrəh kɨrik rɨmə tukrɨvən məkrəh kɨn sipsip, to rɨpəh nukuraoyen ye kwəruə; mərɨg tukrɨviəro kɨn kəupə. ");
INSERT INTO nwi_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Mərɨg yermamə yame ramarha tuk sipsip in tukrukurao-pən ye kwəruə. ");
INSERT INTO nwi_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Yermamə yame ramarha tuk kwəruə, nɨpɨg m-fam in raməhitə ye kwəruə tuk kwən a, kɨni sipsip mɨnə kharkun rɨkin. Nɨpɨg m-fam in ramokrən kɨn nhagriə kɨrikianə kɨrikianə, kɨni kamhatərhav. ");
INSERT INTO nwi_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mokrən fam kɨn sipsip mɨnə kafan, maməkupən; sipsip mɨnə kafan kamhakwasɨg kɨn, meinai kharkun rɨkin. ");
INSERT INTO nwi_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mərɨg to khapəh nhakwasɨgien kɨn yermamə apnapɨg. Nɨkam. Tukmə yermamə apnapɨg, kɨsapta iran, meinai kaseinein rɨkin.” ");
INSERT INTO nwi_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu ramni nuhpɨkɨnien, mərɨg narmamə kaseinein nɨprai nəgkiarien kafan. ");
INSERT INTO nwi_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kɨni əmə ai, Yesu rɨni-pən tuk əriə mɨmə, “Yakamni-pre əfrakɨs tuk əmiə mə Yo e, yo kwəruə yame sipsip mɨnə tukhakurao-pən ikɨn. ");
INSERT INTO nwi_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Narmamə yamə mɨne kɨmɨsəkupən irak, iriə yeməkrəh mɨnə. Sipsip mɨnə khapəh nɨsətərɨgien kɨn əriə. ");
INSERT INTO nwi_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yo e yo kwəruə. Narmamə yamə mɨne tukhakurao-pə yakamərer ikɨn, Kughen tukrɨvəh mɨragh əriə. Tukhauə imə masəriwək mɨsavən masən mənvhirɨk yame rhuvə. ");
INSERT INTO nwi_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mərɨg yəkrəh ramuə imə tuk nar kɨrikianə əmə. Ramuə tuk nəkrəhyen, mɨne tuk nhopniyen, mɨne tuk noriahyen nar. Mərɨg Yo yakamuə mə takhavəh nɨmraghien. Kɨni nɨmraghien e in rukwar kɨn nɨhuvəyen mɨnə fam. ");
INSERT INTO nwi_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Yo e Yermamə huvə kape narha-huvəyen tuk sipsip mɨnə. Yermamə huvə kape narha-huvəyen tuk sipsip mɨnə, in rameighan kɨn kafan nɨmraghien mə tukrɨvəh mɨragh əriə. ");
INSERT INTO nwi_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mərɨg yorwok yame ramor əmə wok tuk nərok, sipsip mɨnə pəh nien mə kafan. Kɨni nɨpɨg tukmə rəm kuri aparu mɨnə kamhauə, in rap, mɨpəh sipsip mɨnə. Kɨni kuri aparu mɨnə tukhauə mɨsəs sipsip mɨnə, mɨsəko rik rik əriə. ");
INSERT INTO nwi_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Yorwok a tukrap meinai in ramor əmə wok tuk nərok. Rɨpəh nərɨg-pɨkien sipsip mɨnə. ");
INSERT INTO nwi_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Yo e, Yo Yermamə huvə kape narha-huvəyen tuk sipsip mɨnə. Tata Kughen rɨrkun Yo, kɨni yakɨrkun In. Ye norien kɨrikianə əmə mɨn, Yo yakɨrkun kafak sipsip mɨnə, kɨni iriə kharkun mɨn Yo, kɨni yakeighaan kɨn nɨmraghien kafak tuk nɨvəh-mɨraghien əriə. ");
INSERT INTO nwi_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kɨni kafak mɨn tɨksɨn aikɨn sipsip, yamə mɨne khapəh nɨsəmɨrien ye kəupə e. Iriə mɨn, tuksərɨg rɨkik. Kɨni iriə fam tukhauə kɨrikianə. Yo pɨsɨn əmə jakamarha huvə tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Kafak Tatə In rorkeikei pɨk Yo meinai yakeighaan kɨn kafan nɨmraghien tuk nɨvəh-mɨraghien sipsip mɨnə kafak. Kɨni kwasɨg ikɨn jakamragh mɨn. ");
INSERT INTO nwi_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Yermamə kɨrik rɨkək yame to rɨvəhsi-ta nɨmraghien kafak. Yo pɨsɨn əmə yakavəh nehuəyen tuk nɨvəhsi-pən-ien kafak nɨmraghien, mɨne tuk nɨmragh-mɨnien. Kafak Tatə rɨmɨni-pə tuk Yo mə jakor məknakɨn.” ");
INSERT INTO nwi_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kɨni nəmehuə kape nəmə Isrel mɨnə kɨmɨsəwhai mɨn kwhen kapəriə tuk nəgkiarien a. ");
INSERT INTO nwi_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Iriə khapsaah kɨmnhani mhamə, “Kwən a, nanmɨn has kɨrik ramərer-pən iran. Kapən kapə rətəwao. ?Nakshawor masətərɨg kɨn In?” ");
INSERT INTO nwi_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mərɨg tɨksɨn khani mhamə, “Nəgkiarien a pəh nien mə nəgkiarien kape yermamə yame nanmɨn has yame ramərer-pən iran. ?Rɨkimiə raməsɨk mə ta mə nanmɨn has rɨrkun nor-huvəyen nɨmrɨn pɨs rarha mɨn, uə?” ");
INSERT INTO nwi_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ruauə ye nɨpɨg yame nəmə Isrel kasor lafet kɨrik kamni kɨmə “Dedekesen” apa Jerusalem. Nɨpɨg a, nɨpɨg kape nokieiyen. ");
INSERT INTO nwi_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Kɨni Yesu rɨnaməriwək ye nɨkar Nimə Ehuə kape Kughen, ye kwənmhan kɨrik kamni kɨmə “Vranda Kape King Solomon.” ");
INSERT INTO nwi_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Kɨni nəmehuə kape nəmə Isrel tɨksɨn kɨmnhauə mɨsarkurao iran. Mɨsaiyoh In mhamə, “?Rhawor nakpəh norien Ik ror nɨrkunien ye nərɨgien kapəmawə mə Ik pa? Tukmə Ik Kristo, ni-pə huvə tuk əmawə.” ");
INSERT INTO nwi_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Kɨni Yesu rɨni-pən tuk əriə mə, “Yo yakwəni-pre ta tuk əmiə, mərɨg nakhapəh nɨshatətəyen irak. Nɨmtətien yamə mɨne yakamor ye nhag Tatə kafak, iriə kasor kafak nəgkiarien mə in raməfrakɨs. ");
INSERT INTO nwi_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mərɨg kɨmiə nakhapəh nɨshatətəyen irak, meinai kɨmiə pəh nien mə kafak sipsip mɨnə. ");
INSERT INTO nwi_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kafak sipsip mɨnə kasərɨg rɨkik mharkun Yo. Kɨni yakɨrkun huvə əriə. Kɨni iriə kamhakwasɨg kɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Kɨni Yo yakvəhsi-pən nɨmraghien rerɨn kɨmi əriə. To iriə khapəh nhamhəyen tuk nɨpɨg kɨrik. Kɨni yermamə kɨrik rɨkək yame to rɨvəhsi-ta əriə ye kwermɨk. ");
INSERT INTO nwi_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Kafak Tatə yame ravəhsi-pə əriə kɨmi Yo, In yerpɨrɨg rapita narɨmnar fam. Kɨni yermamə kɨrik rɨkək yame to rɨvəhsi-ta əriə ye kwermɨn. ");
INSERT INTO nwi_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Kɨmru kafak Tatə, kɨmru kɨrikianə əmə.” ");
INSERT INTO nwi_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Raməgkiar məknakɨn, nəmehuə kape nəmə Isrel kɨmnhapɨk kapier apɨg mhamə tuksarkwhopni In. ");
INSERT INTO nwi_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Mərɨg Yesu rɨmɨni-pən tuk əriə mə, “Kafak Tatə rɨmɨvəhsi-pə nəsanɨnien kɨmi Yo, yakamor nɨmtətien huvə mɨnə rɨpsaah ye nɨmrɨmiə. ?Yɨmnor naha nɨmtətien rahas nakhamə taksarkwhopni Yo tukun?” ");
INSERT INTO nwi_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Kɨni iriə khamə, “Pa rɨmə yakhamə jaksarkhwopni Ik tuk nɨmtətien kɨrik yame Ik nɨmnor. Mərɨg yakhamə jaksarkhwopni Ik meinai nəgkiarien kafam ramni hah Kughen. Ik yermamə apnapɨg əmə kɨrik, mərɨg nakamni mə Ik Kughen.” ");
INSERT INTO nwi_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Kɨni Yesu rɨni-pən tuk əriə mə, “In apa kupan, kɨmɨrai-pən ye loa kapəmiə mə Kughen rɨmɨni-pən tuk əriə mə, ‘Kɨmiə naksəmhen kɨn kughen mɨnə.’ ");
INSERT INTO nwi_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kɨni kɨtawə kharkun huvə mə Nəkwəkwə kape Kughen to rɨpəh nukreikɨnien. ?Tukmə Kughen rɨmɨni-pən tuk narmamə tɨksɨn apa kupan mə iriə kɨsəmhen kɨn Kughen, ");
INSERT INTO nwi_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","rhawor e nakashek Yo mamhani mə yakamni hah Kughen meinai yakamni mɨmə Yo Kwajikovə kafan? Tatə Kughen rɨmnərəhu karɨn Yo mə Yo pɨsɨn əmə e Kafan, mher-pə kɨn Yo ye tokrei tanə. ");
INSERT INTO nwi_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","To yakpipəh norien nɨmtətien yamə mɨne Kafak Tatə ramni-pə tuk Yo, to nakhapəh nhaniyen nəfrakɨsien irak. ");
INSERT INTO nwi_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mərɨg nar apnapɨg nakhapəh nhaniyen nəfrakɨsien ye nəgkiarien kafak, mərɨg takhani nəfrakɨsien irak meinai yakamor nɨmtətien mɨnə kɨni nɨmtətien mɨnə a kasor əpu Yo, mə takharkun mə nɨmraghien kape Tatə Kughen raməmɨr irak, nɨmraghien kafak raməmɨr ye Tatə.” ");
INSERT INTO nwi_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yesu raməgkiar məknakɨn, khamə tukharaptərəkɨn In. Mərɨg In rapta irəriə. ");
INSERT INTO nwi_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kɨni mɨvən məviəfugɨn ye nu apa Jodan, mamvən ikɨn Jon rɨmnor baptaes ye narmamə ikɨn kupan. Kɨni mamarə apaikɨn. ");
INSERT INTO nwi_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Kɨni narmamə khapsaah kɨmnhavən mɨsəm In, mhani-pən tuk əriə mɨnə mhamə, “!Man! Jon rɨpəh nor-pawk-əyen nɨmtətien kɨrik, mərɨg nəgkiarien yame in rɨmnamni ye kwən e ruauə mɨnor nəfrakɨsien kɨn.” ");
INSERT INTO nwi_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kɨni narmamə khapsaah aikɨn a kɨmnhani nəfrakɨsien ye Yesu. ");
INSERT INTO nwi_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","3","Kɨni yemə Betani kɨrik, nhagɨn e Lasaros. Betani e yerkwanu imei Meri mɨne Mata. Meri a in a kwasɨg ikɨn rəvɨt-pən senta ye nɨhu Yesu Yermaru kapətawə, mɨrəh nɨkwənen mamrai nɨhun kɨn. Kɨni Lasaros ramhə, məkneikɨn, nowini mir kwher-pən nəgkiarien tuk Yesu mə, “Yermaru, ik kɨrik yame nakorkeikei pɨk, in ramhə.” ");
INSERT INTO nwi_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu rɨmnərɨg nəgkiarien a, mɨmə, “Lasaros ramhə, mərɨg nɨmhəyen tukrɨpəh nɨvəhyen in. Nəmhəyen a kafan tukror nɨmtətien ye nəsanɨnien kape Kughen. Kɨni nəmhəyen kafan in swatuk tuk Kughen tuk nɨvəhsi-haktəyen Yo e kafan kwajikovə.” ");
INSERT INTO nwi_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu rorkeikei pɨk Mata mɨne naorahini, mɨne kapəriu kakə Lasaros. ");
INSERT INTO nwi_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mərɨg nɨpɨg rɨmnərɨg pawk mə Lasaros rɨmamhə, In rɨmnarə Jodan mɨvəh nɨpɨg kɨraru mɨn. ");
INSERT INTO nwi_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kɨni mɨni-pən tuk kafan narmamə mɨnə mə, “Pəh kharerɨg-pən mɨn ime Lasaros ye provins Judia.” ");
INSERT INTO nwi_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mərɨg kafan narmamə mɨnə kɨmnhani-pən tukun mhamə, “Yhajoun. Taktakun əmə kwuse, nəmehuə kape nəmə Isrel apa Judia kɨmnhamə tuksarkwhopni Ik kɨn kapier apɨg. ?Mərɨg Ik nakmə tukharerɨg-pən mɨn aikɨn?” ");
INSERT INTO nwi_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Kɨni Yesu rɨmɨni-pən nuhpɨkɨnien kɨrik kɨmi əriə mɨmə, “Kɨmiə nakharkun mə nɨpɨg rarə kape nɨraanien rəmhen tuk norien wok kɨrik. To yermamə kɨrik raməriwək yeraan, to rɨpəh nhapitətərien, meinai rhakak. ");
INSERT INTO nwi_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mərɨg tukmə raməriwək yenpɨg, in mɨrkun nhapitətərien. Meinai rəpɨgnəp.” ");
INSERT INTO nwi_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu rɨmɨni-ta nuhpɨkɨnien mamni-pən tuk kafan narmamə mɨnə mə, “Kɨtawə kɨrik e Lasaros rɨnapɨr yeru ta. Mərɨg yakmə jakvən mɨsɨg in pəh rarha.” ");
INSERT INTO nwi_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Kɨni kafan narmamə mɨnə khani-pən tukun mhamə, “Yermaru. To rɨmə in ramapɨr əmə, tukrɨpiəsanɨn mɨn.” ");
INSERT INTO nwi_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Mərɨg nəgkiarien kape Yesu, nɨpran ramni mə Lasaros ruamhə ta. Mərɨg kafan narmamə mɨnə, rɨkiriə raməsɨk mə Lasaros ramapɨr əmə. ");
INSERT INTO nwi_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kɨni Yesu rɨmɨni-pən huvə mɨmə, “Lasaros ruamhə ta. ");
INSERT INTO nwi_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kɨni rɨkik ragien mə yakpəh nɨwəmɨr-kwis-ien kɨmru min. Meinai nar e yame jakor tukrasitu irəmiə takshatətə irak. Nəmhen, pəh khavən mɨsəm in.” ");
INSERT INTO nwi_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kɨni Tomas e kamni kɨmə Didimas, rɨni-pən tuk narmamə mɨnə tɨksɨn kape Yesu mɨmə, “Rhuvə. Pəh kɨtawə mɨfam khavən apa Judia. Pəh tɨkmɨr mɨnə tukhauh ətawə, pəh kɨtawə tukhamhə kwis kɨtawə min.” ");
INSERT INTO nwi_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kɨni Yesu rɨmatərhav-pən Betani, kɨni mərɨg mə kɨmnerkwaig ta kɨn nɨprai Lasaros, rɨvəh nɨpɨg kuas. ");
INSERT INTO nwi_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Rukwanu a Betani in ipakə əmə tuk Jerusalem. Rɨpəh norien isok rapita kilometa kɨsisər. ");
INSERT INTO nwi_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Kɨni nəmə Isrel khapsaah kɨmnhasɨ-pən Jerusalem mhauə mɨsəm Mata mɨne Meri mhavəh-si haktə nərɨgien kapəriu, meinai kapəriu kakə ruamhə. ");
INSERT INTO nwi_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kɨni Mata rɨmnərɨg mə Yesu ramuə, kɨni rərar, mɨvən məm. Mərɨg Meri, in ramkwətə əmə apa imə. ");
INSERT INTO nwi_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Kɨni Mata rɨmɨni-pən tuk Yesu mə, “Yermaru. To kɨtawə kɨpisarə, to kafak kakə rɨpipəh nɨmhəyen. ");
INSERT INTO nwi_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mərɨg yo yakɨrkun mə tukmə nakaiyoh Kughen kɨn naha nhagɨn, kɨni In tukraməkeikei mɨvəhsi-pre kɨmik.” ");
INSERT INTO nwi_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Kɨni Yesu rɨmɨni-pən tukun mə, “Kafam kakə tukrɨpiamragh mɨn.” ");
INSERT INTO nwi_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Kɨni Mata rɨmə, “Yakɨrkun mə Lasaros tukramragh mɨn ye Nɨpɨg Kwasɨg, ye nɨpɨg yame narmamə mɨ-fam tukhamragh mɨn iran.” ");
INSERT INTO nwi_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Kɨni Yesu rɨmɨni-pən tukun mə, “Yo e, yo nuknei nɨmragh-mɨnien ye nɨmhəyen. Kɨni Yo e, yo nuknei nɨmraghien. Narmamə yamə mɨne kashatətə irak, nar apnapɨg tukmə khamhə, mərɨg tukasəkeikei mhamragh mɨn. ");
INSERT INTO nwi_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kɨni narmamə yamə mɨne kamhani nəfrakɨsien irak kɨni masarə hanə, tukhapəh nhamhə-əgkəpien tuk nɨpɨg kɨrik. ?Nakamni nəfrakɨsien ye kafak nəgkiarien uə nɨkam?” ");
INSERT INTO nwi_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Kɨni Mata rɨni-pən tukun mɨmə, “Ǝwəh, Yermaru. Yakamni nəfrakɨsien iram mə Ik Kristo, Ji Kughen. Ik e, yermamə yame profet mɨnə kɨmnamhani kupan mə takuə ye tokrei tanə.” ");
INSERT INTO nwi_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata rɨmɨni-ta nəgkiarien ai, mɨvən mokrən kɨn naorahini Meri rɨkɨr ta mɨravən iriu pɨsɨn, mɨni-pən tukun mɨmə, “Meri, Yhajoun ruauə, morkeikei mə tukrəm ik.” ");
INSERT INTO nwi_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Meri rərɨg, mərer aihuaa əmə, mɨvən mə tukrəm Yesu. ");
INSERT INTO nwi_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","31","Kɨni nɨpɨg nəmə Isrel yamə mɨne kɨmnasəkwətə ime Meri, mhavəh-si haktə nərɨgien kafan, kɨmɨsəm Meri ramərer aihuaa əmə imə mamtərhav, khakwasɨg kɨn. Rɨkiriə raməsɨk mə ramvən apa suranə mə tukrasək. Yesu rɨpəh hanə nɨvənien ye rukwanu a; In raməmɨr hanə aikɨn Mata rɨmavən məm In ikɨn. ");
INSERT INTO nwi_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Kɨni Meri rɨtərhav mɨvən məm Yesu, meiwaiyu mənɨmkur-pən ye nɨhun, mɨmə, “Yermaru. To nakpiamarə kɨtasɨr, to kafak kakə rɨpipəh nɨmhəyen.” ");
INSERT INTO nwi_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu rəm pian a mɨne narmamə yamə mɨne kɨsarə iriə min mɨsasək, rɨkin rəmhə pɨk. ");
INSERT INTO nwi_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kɨni raiyoh-pən əriə mə, “?Nɨmnhanɨm hiə kwən en?” ");
INSERT INTO nwi_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Məkneikɨn mamasək. ");
INSERT INTO nwi_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kɨni nəmə Isrel tɨksɨn khamə, “Səm-ru. Kwən e rɨmnorkeikei pɨk kwən a kupan.” ");
INSERT INTO nwi_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mərɨg tɨksɨn kɨmnhani mhamə, “Kwən e In e kupan rɨmnor huvə yɨmrɨn pɨs kɨrik. ?Rhawor e rɨpəh nɨni-əhuyen Lasaros mə tukrɨpəh nɨmhəyen?” ");
INSERT INTO nwi_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu rɨmnərɨg rahas pɨk tuk Lasaros. Kɨni mɨvən apa ye suranə. Kwənmhan yame kɨmɨrəhu ikɨn ye nɨpəg kapier, yame kɨmɨsisɨgɨn kɨn kapier. ");
INSERT INTO nwi_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Kɨni Yesu rɨmə, “Səsuə-ta ru kɨn kapier.” Mərɨg Mata e nowin Lasaros rɨmɨni-pən tukun mɨmə, “Yermaru. In rɨnapien ta. Kɨmɨserkwaig ta kɨn rɨvəh nɨpɨg kuas.” ");
INSERT INTO nwi_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Mərɨg Yesu rɨmɨni-pən tukun mɨmə, “?Rhawor? ?Naknərukɨn ta mə yakməni-pre tuk ik mə tukmə nakhatətə irak, takəm nəsanɨnien ehuə kape Kughen, uə?” ");
INSERT INTO nwi_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Məkneikɨn, kɨsəsuə ta kɨn kapier. Kɨni Yesu rɨvaag faktə mɨmə, “Tata. Yakamni vi vi ik meinai nɨmnərɨg kafak nəhuakien. ");
INSERT INTO nwi_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kɨni yakɨrkun mə nɨpɨg m-fam, nakamərɨg Yo. Mərɨg yakaməgkiar məkneikɨn mə narmamə yamə mɨne kasərer rarkurao irak tukhani nəfrakɨsien mə nɨmnher-pə kɨn Yo.” ");
INSERT INTO nwi_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesu rɨni-ta nəgkiarien a, mokrən apomh mɨmə, “!Lasaros! Ǝrer mɨtərhav-pə.” ");
INSERT INTO nwi_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kɨni yermamə mhə ai rɨmnhekɨmter, mɨpɨk neipən yame kɨmnhatuapɨs kapən kapə kɨn, meriaji nɨpran mɨne yamə mɨne kɨmnərkɨs nɨhun kɨn, məriwək mɨtərhav-pə. Kɨni Yesu rɨni-pən tuk əriə mə, “Havəhsi-ta neipən kape yermamə mhə, pəh ramvən yerkwanu.” ");
INSERT INTO nwi_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nəmə Isrel khapsaah yamə mɨne kɨmnɨsarə iriə Meri masəm nar yame Yesu rɨmnor kɨni kɨshatətə iran. ");
INSERT INTO nwi_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Mərɨg iriə tɨksɨn kɨmnhavən mɨsəm Farisi mɨnə, mhani-ərhav-pən fam narɨmnar yame Yesu rɨmnor kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Məkneikɨn, Farisi mɨnə mɨne jif pris mɨnə kɨmɨsofugɨn ye kaonsel kapəriə. Mhamə, “?Tukshawor iran mɨne kwən e? Rɨnamor nɨmtətien rɨpsaah. ");
INSERT INTO nwi_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","To khapəh əmə ramor əmə məknakɨn, kɨni narmamə m-fam tukshatətə iran. Kɨni nəmə Rom tukhauə mɨsoriah kapətawə nimə e Nimə Ehuə kape Kughen, mhavəhsi-ta kwənmhaan kapətawə tuk ətawə.” ");
INSERT INTO nwi_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kɨni iriə kɨrik, nhagɨn e Kaeafas, in ramor wok kape hae pris ye newk a. Rɨmɨni mɨmə, “!Nakseinein əgkap nar! ");
INSERT INTO nwi_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Rhuvə əmə tuk əmiə mə yermamə kwənkwan kɨrikianə əmə tukrɨmhə tuk narmamə. Nar a rhuvə rapita yame narmamə ye kantri piəpiə tukhamhə.” ");
INSERT INTO nwi_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","(Ramni nəgkiarien a, mərɨg pəh nien mə nərɨgien kafan. Mərɨg in ramni-ərhav nəgkiarien yame Kughen rɨmɨvəhsi-pən kɨmin, meinai in ramor wok kape hae pris ye newk a. Kɨni in ramni mə Yesu tukrɨmhə tuk nɨvəh-mɨraghien nəmə Isrel. ");
INSERT INTO nwi_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Mərɨg pa rɨmə tukrɨmhə əmə tuk nəmə Isrel mərɨg tukrɨmhə tuk ji Kughen yamə mɨne kɨsarə rarkurao ye tanɨmtanə, mamor əriə kamhauə kɨrikianə.) ");
INSERT INTO nwi_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ror məkneikɨn, ye nɨpɨg a, nəmehuə kape nəmə Isrel kɨmnharai mhun mhamə tukshopni In. ");
INSERT INTO nwi_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ror məkneikɨn, rɨrikakun ye nɨpɨg a, Yesu rɨpəh nəriwəkien ye nɨmrɨ nəmə Isrel. Map aikɨn a, mɨvən ye taon kɨrik, nhagɨn e Efrem. Taon a in ipakə əmə tuk tɨpəvsɨk. Kɨni In mamarə aikɨn iriə kafan narmamə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Rɨnamuə ipakə tuk nɨpɨg kape lafet kape nəmə Isrel kamni kɨmə Pasova. Kɨni narmamə khapsaah khasɨ-pən ikɨn pɨsɨn pɨsɨn mɨnə mhauə Jerusalem mhamə tuksor narɨmnar mɨnə pəh mɨshawən ye nɨmrɨ Kughen, mɨpihavən ye lafet. ");
INSERT INTO nwi_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Kɨni narmamə mɨnə a kɨmɨsarha-kɨn Yesu. Mɨsofugɨn ye Nimə Ehuə kape Kughen, mɨsaiyoh əriə mɨnə mhamə, “?Keinein mə Yesu tukruə ye lafet e uə nɨkam?” ");
INSERT INTO nwi_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mərɨg ye nɨpɨg a, jif pris mɨnə mɨne Farisi mɨnə kɨmnhani nəgkiarien kɨrik mə tukmə yermamə kɨrik rɨrkun ikɨn Yesu ramarə ikɨn, tukraməkeikei muə mɨni-əsah pən tuk əriə, pəh mobael mɨnə tukhavən mharaptərəkɨn. ");
INSERT INTO nwi_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nɨpɨg sikis əmə raməmɨr ai tukpisor lafet kape Pasova. Kɨni Yesu rɨrerɨg-pən mɨn Betani a imei Lasaros e yame Yesu rɨmnor ramragh mɨn ye nɨmhəyen. ");
INSERT INTO nwi_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kɨni nəmə ikɨn a kɨmɨsor nəvɨgɨnien kɨrik tuk nɨvəhsi-pənien nɨsiaiyen kɨmi Yesu. Kɨni Mata rɨmɨvəh nəvɨgɨnien muə. Kɨni Lasaros mɨn raməmɨr aikɨn iriə Yesu mɨne, kasəkwətə ye tebol masəvɨgɨn. ");
INSERT INTO nwi_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kɨni Meri rɨvəh botel ehuə kɨrik rukwar kɨn senta e kamni kɨmə nad; nɨmrɨn rhaktə pɨk. Kɨni məvɨt-pən ye nɨhu Yesu, mɨvəh nɨmar nɨkwənen, mamrai-ta kɨn. Nəmiəv senta rɨmnapien huvə ye nəkwai nimə mɨnə fam. ");
INSERT INTO nwi_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mərɨg yermamə kɨrik kape Yesu, nhagɨn e Judas Iskariot, kwasɨg ikɨn rɨpieighaan-pən kɨn Yesu ye kwermɨ tɨkmɨr mɨnə kafan, rɨmɨni-əhu, mamni mɨmə, ");
INSERT INTO nwi_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Rhuvə pɨk mə to in ror salem əmə kɨn; mɨrkun nɨvəhyen mane ehuə kɨn tuk nɨvəhsi-pənien kɨmi yavən has mɨnə. Senta e nɨmrɨn rəmhen kɨn tri handred taosen vatu.” ");
INSERT INTO nwi_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","In ramni məknakɨn, mərɨg pa rɨmə rɨkin rehuə tuk yavən has mɨnə. Mərɨg ramni əmə meinai in yəkrəh. In ramərer tuk nɨtɨp kapəriə, kɨni nɨpɨg kɨrik in raməkrəh kɨn. ");
INSERT INTO nwi_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Mərɨg Yesu rɨmə, “!Ei! Hapəh pian en. Piraovɨn e ravi-təgpən senta ye nɨprak mamor apnəpenə ye nɨprak mə tukrɨhuvə ye nɨpɨg yame tuknɨm Yo. ");
INSERT INTO nwi_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yavən has mɨnə tukasəmɨr kɨmiə miriə nɨpɨg fam. Mərɨg Yo jakpəh nəmɨrien kɨtawə-m kɨmiə nɨpɨg fam.” ");
INSERT INTO nwi_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ye nɨpɨg a, nəmə Isrel khapsaah kɨmɨsərɨg mə Yesu ramarə Betani, kɨni kɨnəmhavən tukun. Mərɨg pa rɨmə kɨmnhavən mə tuksəm əmə Yesu, mərɨg kɨmnhavən mɨn mə tuksəm-ru Lasaros e yame rɨmamhə mərɨg Yesu rɨmnor in ramragh mɨn. ");
INSERT INTO nwi_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Məkneikɨn, jif pris mɨnə kɨmnharai mhun mə tukshopni mɨn Lasaros, ");
INSERT INTO nwi_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","meinai nəmə Isrel khapsaah kɨmɨsəm Lasaros ramragh mɨn, kɨmɨshatətə ye Yesu, mhaukreikɨn-pən nɨmeitairiə kɨmi jif pris mɨnə. ");
INSERT INTO nwi_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kəni rɨkwamer kɨn, narmamə khapsaah kɨmnhauə Jerusalem mhamə tuksor lafet kape Pasova. Kɨni mɨsərɨg mə Yesu raməriwək mamuə ipakə tuk taon. ");
INSERT INTO nwi_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Məkneikɨn iriə khatərhav ye taon a, mhapɨk nɨmar nəmɨr mhavən mə tuksəm Yesu. Masokrən apomh mhamə, “!Səgnəgɨn Kughen!” “!Pəh kɨvəhsi-haktə Kwən en ramuə ye nhag Yermaru!” “!Pəh kɨvəhsi-haktə king kape nəmə Isrel!” ");
INSERT INTO nwi_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Kɨni Yesu rɨmnəm kwaji dongki kɨrik, məkwətə-pən iran mamvən. Nar e raməri-pən profesi kɨrik yame ramni mə, ");
INSERT INTO nwi_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Nɨpian Saeon. Hapəh nhagɨnien. Səm-ru kapəmiə king ruauə tuk əmiə, maməsuə ye dongki. Maməsuə ye ji dongki mamuə.” ");
INSERT INTO nwi_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ye nɨpɨg a, narmamə kape Yesu mɨnə kɨmɨseinein nɨprai nar a. Mərɨg kwasɨg ikɨn, nɨpɨg Yesu rɨmɨmragh mɨn ye nɨmhəyen, kɨni Kughen rɨmnor əpu nehuəyen kape Yesu, kɨni rɨkiriə rɨpiəsɨk mə Nəkwəkwə kape Kughen rɨmnəvsao kɨn narɨmnar yame tukrɨpitərhav-pə ye nɨmraghien kape Yesu. Kɨni narmamə kɨmɨsor narɨmnar mɨnə a, ror nəgkiarien kape Kughen ruauə mɨnor nəfrakɨsien kɨn. ");
INSERT INTO nwi_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Kupan, nɨpɨg Yesu rɨmnokrən kɨn Lasaros, kɨni Lasaros rhekɨmter ye nəpəg kapier mɨtərhav-pə ye nɨmrɨ narmamə khapsaah. Kɨni ai, iriə kɨmnhatərhav mɨsərer-ərhav mamhani-ərhav nar a yame Yesu rɨmnor. ");
INSERT INTO nwi_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ǝmə məkneikɨn, narmamə khapsaah kɨmɨsərɨg nəgkiarien mə In rɨmnor nɨmtətien a, kɨni khauə masəm Yesu aikɨn a. ");
INSERT INTO nwi_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kɨni Farisi mɨnə kɨmnhani-pən tuk əriə mɨnə mhamə, “Səm-ru. Kɨtawə kɨseinein nhani-əhuyen kwən a. !Taktakun ai, narmamə m-fam ye tanɨmtanə kɨnamhakwasɨg kɨn In!” ");
INSERT INTO nwi_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kɨni nɨpɨg narmamə kɨmnhavən Jerusalem mə tuksəhuak ye nɨpɨg kape lafet e, kɨni nəmə Gris tɨksɨn kɨmnhavən mɨn mə tuksəhuak. ");
INSERT INTO nwi_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Mhavən mɨsəm Filip e yemə Betsaeda, yerkwanu kɨrik apa Galili. Mhani-pən tukun mhamə, “Yemehuə. Yaksorkeikei mə jaksəm Yesu.” ");
INSERT INTO nwi_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Kɨni Filip rərer mɨvən, mɨni-əsaah-pən tuk Andru, kɨni iriu kɨmɨravən mɨrəni-əsaah-pən tuk Yesu. ");
INSERT INTO nwi_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “Taktakun ai, Yo, Ji Yermamə, kafak nɨpɨg ruauə ta, mə Kughen tukror əpu kafak nehuəyen. ");
INSERT INTO nwi_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Yakamni-pre əfrakɨs tuk əmiə mə tukaməkeikei kɨnɨm-pən kweru nai ye nɨmoptanə. To kɨpipəh nɨnɨm-pənien ye nɨmoptanə, to rɨpipəh nurəyen mhaktə mamor kwənkwan khapsaah. Mərɨg tukmə kɨnɨm-pən ye nɨmoptanə, tukraməkeikei murə mamor kwənkwan rɨpsaah. ");
INSERT INTO nwi_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Yermamə yame ramətərɨg pɨk tuk kafan nɨmraghien kape tokrei tanə, in tukraməkeikei məpkərhav iran. Mərɨg yermamə yame rɨkin rɨpəh nəsɨk-pɨkien kafan nɨmraghien kape tokrei tanə, in tukraməkeikei mamraptərəkɨn huvə nɨmraghien kafan kape rerɨn. ");
INSERT INTO nwi_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yermamə yame rorkeikei mə tukror wok kafak, in tukraməkeikei mɨkwasɨg kɨn Yo. Ikɨn pukaa yakamvən ikɨn, kɨmru min. Kɨni Rɨmɨk Kughen tukrɨsiai yor wok kafak mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Kɨni Yesu rɨmɨni-pən tuk əriə mɨmə, “Taktakun ai, rɨkik rəmhə pɨk. ?Mərɨg jakhawor pən iran mɨne? To yakpəh nɨni-pənien tuk kafak Tatə mɨmə, ‘Takvəhsi-ta nəmhəyen yame ramuə tuk Yo.’ Nɨkam, to yakpəh nɨniyen məknakɨn meinai narɨmnar mɨnə a, yakmauə tukun.” ");
INSERT INTO nwi_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kɨni In maməhuak mɨmə, “Tatə, vəh-si haktə atuk nhagɨm.” Məkneikɨn nəgkiarien kɨrik rɨsɨ-pən ye rao ye neai mamni mɨmə, “Yo yakwərəhsi-haktə ta nhagɨk, kɨni taktakun ai, jakrəh-si haktə mɨn.” ");
INSERT INTO nwi_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kɨni narmamə yamə mɨne kɨmnasərer ipakə tukun kɨmɨsərɨg nəgkiarien a, kɨni iriə tɨksɨn khamə, “!Eh! ?Naha e? ?Karuəruə kɨrik, uə?” Mərɨg tɨksɨn khamə, “Nɨkam. Agelo kɨrik raməgkiar kɨmin.” ");
INSERT INTO nwi_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Mərɨg Yesu rɨni-pən tuk əriə mɨmə, “Nəgkiarien ramsɨ-pən ye rao ye neai pəh nien mə kafak; mərɨg kapəmiə, tukrasitu irəmiə. ");
INSERT INTO nwi_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Taktakun ai rɨmnor nɨpɨg yame Kughen tukrəkir narmamə ye tanɨmtanə. Kɨni taktakun ai, in tukrɨvəh-si-əhu əgkap nəsanɨnien kape Setan e yame ramarmaru ye tokrei tanə. ");
INSERT INTO nwi_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nɨpɨg tukaməsɨk haktə Yo, kɨni yakvi-pə narmamə m-fam tukhauə tuk Yo.” ");
INSERT INTO nwi_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","In raməgkiar məknakɨn kɨmi əriə mamhajoun mə tukshawor-pən iran mɨne mɨshopni In. ");
INSERT INTO nwi_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kɨni narmamə khani-pən tukun mhamə, “Kɨmawə yakwəsərɨg ta ye loa kapətawə mə Kristo tukraməkeikei mamarə kɨtawə min kape rerɨn. ?Mərɨg rhawor e nakamni mə narmamə tukasəkeikei mɨsəsɨk haktə Ji Yermamə? ?Nəgkiarien e ‘Ji Yermamə,’ nɨpran ramni mə naha?” ");
INSERT INTO nwi_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Kɨni Yesu rɨni-pən tuk əriə mə, “Nɨkakien e, ramarə tuk əmiə kape nɨpɨg kwakwə əmə. Kɨni nɨpɨg nɨkakien tukraməmɨr tuk əmiə, taksəriwək iran. Tamə, nəpɨgnəpien ruvrɨg əpɨs əmiə. Kɨni narmamə yamə mɨne kasəriwək ye nəpɨgnəpien, kaseinein ikɨn kamhavən ikɨn. ");
INSERT INTO nwi_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nɨpɨg nɨkakien tukraməmɨr tuk əmiə, kɨmiə taksəkeikei mɨshatətə ye nɨkakien, mə kɨmiə takharkun nhauəyen kwajikovə mɨnə kape nɨkakien.” Yesu rɨmɨni-ta nəgkiarien a, kɨni map-ta irəriə, mɨvən merkwaig. ");
INSERT INTO nwi_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nar apnapɨg mə In rɨmnor ta nɨmtətien rɨpsaah ye nɨmrɨ nəmə Isrel, mərɨg khapəh nhaniyen nəfrakɨsien iran. ");
INSERT INTO nwi_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nar a rɨtərhav-pə ror Nəgkiarien kape profet Aesaea kupan ruauə mɨnor nəfrakɨsien kɨn, yame ramni mɨmə, “Ah. Yermaru. Narmamə kwatɨksɨn əmə kamhani nəfrakɨsien ye nəgkiarien kapəmawə. Nar apnapɨg mə nakamor nɨmtətien ye nəsanɨnien kafam, mərɨg to khapəh nhaniyen nəfrakɨsien iram.” ");
INSERT INTO nwi_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kɨni iriə to khapəh nhaniyen nəfrakɨsien iran rəri-pən nəgkiarien yame Aesea ruɨni-ta kupan mɨmə, ");
INSERT INTO nwi_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Kughen rɨmnor əriə mə nɨmrɨriə tukrɨpɨs. To nɨmrɨriə rɨpipəh nɨpɨsien, to iriə kɨpisəm, mɨpiharkun. Kɨni In rɨmnor rɨkiriə rɨpəh narəyen. To rɨkiriə rɨpiarə, to kɨpisarar ye nərɨgien kapəriə, kɨni mɨshatətə iran, kɨni rɨpior nɨmraghien kapəriə rɨpihuvə mɨn.” ");
INSERT INTO nwi_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Profet Aesea kupan rɨmnaməgkiar mamni məknakɨn meinai in rɨmnəm nəsanɨnien kape Yesu, maməvsao kɨn. ");
INSERT INTO nwi_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kɨni mərɨg, ye nɨpɨg a, nəmehuə mɨnə rɨpsaah kwənmopɨn, iriə mɨn kɨmɨshatətə ye Yesu. Mərɨg iriə kɨmnhapəh nhani-ərhavyen mə kwəshatətə iran, meinai kɨmnhagɨn kɨn Farisi mɨnə, mə tamə kɨsher ye rhav kɨn əriə ye nimə kape nofugɨnien, ");
INSERT INTO nwi_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","meinai nəmehuə mɨnə a kɨmɨsorkeikei pɨk mə narmamə tukhavəh-si haktə əriə, rapita yame kɨsorkeikei mə Kughen rɨkin tukragien tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kɨni Yesu rokr-apomh mɨmə, “Narmamə yamə mɨne kɨshatətə irak, pəh nien mə kɨshatətə pɨsɨn əmə irak, mərɨg kɨshatətə mɨn ye Kughen yame rɨmnher-pə kɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kɨni narmamə yamə mɨne kasəm Yo, pəh nien mə kasəm əmə Yo, mərɨg kasəm mɨn Kughen yame rɨmnher-pə kɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yo e nɨkakien. Yakmauə ye tokrei tanə e mə narmamə yamə mɨne kɨshatətə irak tukhapəh nɨsarəyen ye nəpɨgnəpien. ");
INSERT INTO nwi_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Narmamə yamə mɨne kasərɨg kafak nəgkiarien, mhapəh nɨsorien, to yakpəh nɨni-ərhavyen kapəriə narpɨnien, meinai pəh nien mə yakmauə ye tokrei tanə e mə jakni-ərhav narpɨnien kape narmamə. Mərɨg yakmauə mə jakvəh mɨragh əriə. ");
INSERT INTO nwi_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mərɨg Yermamə kɨrik aikɨn yame tukrɨvəhsi-pən narpɨnien kɨmi narmamə yamə mɨne kamhaukreikɨn-pən nɨmeitairiə kɨmi Yo, mhapəh nhavəhyen kafak nəgkiarien. Tuk nɨpɨg yame Kughen tukrəkir narmamə iran, Kughen tukrɨvəhsi-pən narpɨnien kɨmi əriə, meinai kɨmɨsəpəh nəgkiarien yame yɨmɨni-pən tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Meinai nəgkiarien yame yakamni, pəh nien mə kafak pɨsɨn əmə, mərɨg Tata Kughen yame rɨmnher-pə kɨmi Yo, In rɨmɨni-pə tuk Yo mə jakaməkeikei mɨni məknakɨn. ");
INSERT INTO nwi_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kɨni Yo yakwɨrkun ta mə nəgkiarien kafan rɨrkun nɨvi-pənien narmamə ye nɨmraghien rerɨn. Ror pən, nəgkiarien yamə mɨne yakamni, Tata Kughen ravəhsi-pə kɨmi Yo, kɨni yakamni.” ");
INSERT INTO nwi_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Rɨnor nɨpɨg atuatuk kape nəmə Isrel tuk norien lafet kape Pasova. Kɨni Yesu ruɨrkun mə kafan nɨpɨg ruauə ta mə tukrəpəh kafan nɨmraghien ye tokrei tanə mɨvən mamarə iriu Rɨmni Kughen. Nɨpɨg m-fam In rorkeikei pɨk kafan narmamə yamə mɨne kɨsarə ye tokrei tanə, kɨni mərɨg taktakun ai in ramhajoun norkeikeiyen mɨnə fam kafan kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Rɨnamenaiyu, kɨni Yesu mɨne kafan narmamə mɨnə kɨnasəvɨgɨn. Kɨni Setan rɨmɨvəhsi-pən vəh-si-pən ta kɨmi Judas ji Saemon Iskariot, mə tukreighaan-pən kɨn Yesu ye kwermɨ tɨkmɨr mɨnə kafan. ");
INSERT INTO nwi_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu rɨmɨrkun mə Tata Kughen rɨmnərəhu-pən ta narɨmnar fam ye kwermɨn, kɨni muɨrkun mɨn mə In rɨmasɨ-pən ye Kughen, kɨni tukrɨpirerɨg-pən mɨn tuk Kughen. ");
INSERT INTO nwi_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Məkneikɨn, rhekɨmter, mɨrəhsi-ta kafan kot, kɨni mətəut kɨn neipən kɨrik. ");
INSERT INTO nwi_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kɨni mɨrəh besin kɨrik, mɨruk-pən nu iran. Kɨni mɨvən mokwi nɨhu kafan kɨn narmamə mɨnə. Məspir nɨhuriə kɨn neipən yame rɨmnətəut kɨn. ");
INSERT INTO nwi_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Mor məknakɨn, mɨvən meriaji-pən Saemon Pita, kɨni Pita rɨni-pən tukun mɨmə, “Yermaru. ?Rhawor? Rɨpəh nəmhenien mə Ik takəkwi nɨhuk kɨn nu.” ");
INSERT INTO nwi_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Mərɨg Yesu rɨni-pən tukun mɨmə, “Ik nakpəh nɨrkunien nɨprai nar e yakamor ai taktakun. Mərɨg tuk nɨpɨg kɨrik, takpirkun nɨpran.” ");
INSERT INTO nwi_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Kɨni Pita ramni-əhu In mɨmə, “Nɨkam. To nakpəh nəkwi-əfrakɨsien nɨhuk tuk nɨpɨg kɨrik.” Mərɨg Yesu rɨmə, “To yakpipəh nəkwiyen nɨhum, ik nakpəh nuəyen kafak yermamə.” ");
INSERT INTO nwi_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Kɨni Saemon Pita rɨni-pən tukun mɨmə, “Yermaru. Tukmə ror məkneikɨn, kɨni takpəh nəkwi-əməyen nɨhuk, mərɨg əkwi mɨn kapək kapə mɨne kwermɨk.” ");
INSERT INTO nwi_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Mərɨg Yesu rɨni-pən tukun mɨmə, “Nɨkam. Narmamə yamə mɨne kwəsar ta, kwəshawən. To khapəh nɨsar-mɨn-ien. Mərɨg Yo jakaməkeikei məkwi əmə nɨhum. Kɨmiə nakwəshawən ta. Mərɨg pəh nien mə kɨmiə fam. ");
INSERT INTO nwi_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu ruɨrkun mə iriə pa nhagɨn tukreighaan-pən kɨn in ye kwermɨ tɨkmɨr mɨnə kafan. Ror pən, In rɨmɨni mɨmə, “Pəh nien mə kɨmiə fam nakwəshawən.” ");
INSERT INTO nwi_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kɨni Yesu rɨmnəkwi fam əriə, mɨvən mɨvəh-si-pən kafan kot, mɨvən məkwətə-pən ye kwənmhaan yame rɨnamkwətə-pən ikɨn. Mamaiyoh əriə mɨmə, “?Kɨmiə nakharkun nɨprai nar e yɨmnor irəmiə ai taktakun uə? ");
INSERT INTO nwi_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kɨmiə naksokrən kɨn Yo mə Yhajoun mɨne Yermaru, kɨni ratuatuk. Meinai nəfrakɨsien mə Yo Yhajoun kapəmiə mɨne kapəmiə Yermaru. ");
INSERT INTO nwi_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Meinai nar apnapɨg Yo e kapəmiə Yermaru mɨne Yhajoun kapəmiə, mərɨg yɨmnəkwi nɨhumiə, kɨni ye norien kɨrikianə əmə mɨn, kɨmiə mɨn takasəkeikei masəkwi nɨhumiə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yo yɨmnor mhajoun əmiə kɨn, mə takasor əmə norien kɨrikianə əmə irəmiə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Yakamni-pre əfrakɨs tuk əmiə mə yorwok kɨrik to rɨpəh nehuəyen rapita kafan yemehuə; kɨni yermamə yame ravəh nəgkiarien mameriwək to rɨpəh napitayen yermamə yame ravəhsi-pən nəgkiarien kɨmin. ");
INSERT INTO nwi_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Taktakun ai, kɨmiə nakwənharkun huvə nar e. Ror pən, tukmə nakasor məkneikɨn irəmiə mɨnə, Kughen tukrɨvəhsi-pre nɨhuvəyen kɨmi əmiə. ");
INSERT INTO nwi_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Mərɨg pa rɨmə yakamni əmiə m-fam. Yakɨrkun əmiə mə nɨ-pa mɨnə e yakmɨrpen əriə. Mərɨg nəgkiarien e kape Nəkwəkwə kape Kughen tukraməkeikei muə mor nəfrakɨsien kɨn yame ramni mə, “‘Yermamə yame jakwən kwis bred kɨmru min, in tukrukreikɨn-pə nɨmeitaan kɨmi Yo, muə tɨkmɨr kafak.’ ");
INSERT INTO nwi_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Yakamni-pre tuk əmiə, mə narɨmnar mɨnə e rɨpəh hanə nɨtərhav-pəyen; mərɨg nɨpɨg tukmə khatərhav-pə, takhani nəfrakɨsien irak, mə Yo e Kristo. ");
INSERT INTO nwi_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","“Yakamni-pre əfrakɨs tuk əmiə mə tukmə yakher-pən kɨn yermamə kɨrik tuk nəvsaoyen kɨn kafak nəgkiarien kɨmi narmamə, kɨni narmamə rɨkiriə ragien tukun, rəmhen əmə kɨn yame rɨkiriə ramagien tuk Yo. Kɨni tukmə narmamə rɨkiriə ragien tuk Yo, rəmhen əmə kɨn yame rɨkiriə ragien tuk Yermamə yame rɨmnher-pə kɨn Yo.” ");
INSERT INTO nwi_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nɨpɨg Yesu rɨmɨni nəgkiarien a, rɨkin rəmhə, kɨni In mɨmə, “Yakamni-pre əfrakɨs tuk əmiə mə kɨmiə kɨrik irətawə tukreighaan-pən kɨn Yo ye kwermɨ tɨkmɨr mɨnə kafak.” ");
INSERT INTO nwi_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kɨni kafan narmamə mɨnə kɨsarha-pən mɨsəm əriə mɨnə. Rɨkiriə raməsɨk mə, “?Ramni pa?” ");
INSERT INTO nwi_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Kɨni iriə kɨrik, yame Yesu rorkeikei pɨk, ramkwətə ipakə əmə tukun. ");
INSERT INTO nwi_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Kɨni Saemon Pita rəsiwən-apsapɨs-pən kɨmin mɨmə, “Aiyoh-pən-ru In mə pa nhagɨn e ramni.” ");
INSERT INTO nwi_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kɨni kwən a rɨmneiwaiyu-pən ipakə tuk Yesu maiyoh In mɨmə, “Yermaru. ?Pa e nhagɨn?” ");
INSERT INTO nwi_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Kɨni Yesu rɨmə, “Kwən a in e yame jakakapɨr bred meires ye sup mɨvəh-si-pən kɨmin.” Məkneikɨn In rəkapɨr bred, meires ye sup, mɨvəh-si-pən kɨmi Judas, ji Saemon Iskariot. ");
INSERT INTO nwi_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kɨni Judas rɨvəh bred ai. Məkneikɨn Setan rɨvən yerkin. Kɨni Yesu rɨmɨni-pən tukun mɨmə, “Nar e nakmə takor, yuvən aihuaa əmə mor.” ");
INSERT INTO nwi_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mərɨg narmamə mɨnə kape Yesu kɨsəkwətə rarkurao ye tebol masəvɨgɨn, kɨmnhapəh nharkunien nɨprai nəgkiarien kape Yesu. ");
INSERT INTO nwi_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas, in ramərer tuk nɨtɨp kapəriə, kɨni iriə tɨksɨn, rɨkiriə rəsɨk mə Yesu rɨmɨni-pən tukun mə tukrɨvən mɨvəh nɨmrɨ nəvɨgɨnien kɨrik nəriə kape lafet, uə mə tukrɨvən mɨvəh-si-pən mane tɨksɨn kɨmi yavən has mɨnə. ");
INSERT INTO nwi_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Rɨnəpɨgnəp ta. Kɨni nɨpɨg Judas rɨvəh bred, kɨni mərer, mɨtərhav. ");
INSERT INTO nwi_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas ruatərhav, kɨni Yesu rɨmə, “Taktakun ai, Kughen tukrɨvəhsi-haktə nhagɨk e Ji Yermamə. Kɨni Yo, Ji Yermamə, yakvəhsi-haktə nhag Kughen. ");
INSERT INTO nwi_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Mərɨg nɨpɨg Yo, Ji Yermamə, jakor əpu nehuəyen kape Kughen, kɨni Kughen pɨsɨn əmə tukror əpu atuk nehuəyen kafak. Kɨni In tukror aihuaa əmə. ");
INSERT INTO nwi_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Kafak kwajikovə mɨnə, kɨtawə to khapəh nɨsəmɨr kwisien ror tu. Kɨni kɨmiə takpisarha-kɨn Yo. Mərɨg Yo yakamni-pre nəgkiarien kɨrikianə əmə kɨmi əmiə yame yakwəni-pən ta tuk nəmehuə kape nəmə Isrel, mɨmə, ‘Ikɨn yakamvən ikɨn, kɨmiə to nakhapəh nhavənien ikɨn.’ ");
INSERT INTO nwi_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Yakamərəhu-pre natuakəmien vi kɨrik kɨmi əmiə mə takasəkeikei mɨsorkeikei əmiə mɨnə. Yɨmnorkeikei əmiə, kɨni ye norien kɨrikianə əmə mɨn, kɨmiə takasəkeikei mɨsorkeikei əmiə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kɨni tukmə naksorkeikei məknakɨn əmiə mɨnə, narmamə mɨfam tukharkun mə kɨmiə kafak narmamə mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Kɨni Saemon Pita rɨmnaiyoh In mɨmə, “Yermaru. ?Nakmə takvən hiə?” Kɨni Yesu rɨni-pən tukun mə, “Ik to nakpəh nɨkwasɨgien kɨn Yo ai taktakun, kɨravən ikɨn yakamvən ikɨn. Mərɨg tuk nɨpɨg kɨrik, nakpivən.” ");
INSERT INTO nwi_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Kɨni Pita raiyoh-pən mɨmə, “Yermaru. ?Jakpəh nɨkwasɨgien kɨn ik tuk naha? Yakmə jakɨkwasɨg kɨn Ik nar apnapɨg tukmə kɨmə tukhopni Ik, tukhopni kwis ərau.” ");
INSERT INTO nwi_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Mərɨg Yesu rɨmɨni-pən tukun mɨmə, “?Ik nakmə takɨkwasɨg kɨn Yo nar apnapɨg tukmə kɨmə tukhopni kwis ərau? Yakamni-pre əfrakɨs tuk ik mə, man tukrɨpəh nəkakə-hanəyen, ik takni m-kɨsisər mə nakeinein Yo.” ");
INSERT INTO nwi_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Kɨni Yesu rɨni-pən tuk əriə mə, “Rɨkimiə tukrɨpəh nəmhəyen. Shatətə ye Kughen, mɨshatətə mɨn irak. ");
INSERT INTO nwi_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ye nimə kape Tatə kafak, kwənmhaan rɨpsaah. To rɨpipəh norien məknakɨn, to yawəni-əsaah pre ta iran tuk əmiə. Taktakun ai, yakamvən aikɨn tuk nor-əpnəpənəyen ye kwənmhaan kapəmiə. ");
INSERT INTO nwi_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Meinai jakvən mor apnəpeinə ta ye kwənmhaan kapəmiə, kɨni mɨrerɨg-pə mɨn mɨkɨr əmiə, khavən mɨsarə kɨtawə-m kɨmiə, mə kɨmiə takasarə aikɨn yakamarə ikɨn. ");
INSERT INTO nwi_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ikɨn a yakamvən ikɨn, kɨmiə nakwənharkun ta swatuk yame ramvən ikɨn.” ");
INSERT INTO nwi_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Mərɨg Tomas rɨni-pən tukun mə, “Yermaru, kɨmawə yakseinein aikɨn nakamvən ikɨn. ?Jakshawor-pən iran mɨne mharkun swatuk yame ramvən apaikɨn?” ");
INSERT INTO nwi_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Kɨni Yesu rɨni-pən tukun mɨmə, “Yo e, yo swatuk. Kɨni Yo e, nuknei nəfrakɨsien, kɨni Yo e nuknei nɨmraghien. Yermamə yame rɨpəh nuəyen tuk Yo to rɨpəh nɨvənien tuk Rɨmɨk. ");
INSERT INTO nwi_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tukmə nakharkun Yo, nakharkun mɨn Rɨmɨk. Ror pən, rɨrikakun ai taktakun, nakwənharkun ta In, mɨsəm ta In.” ");
INSERT INTO nwi_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Kɨni Filip rɨni-pən tukun mɨmə, “Yermaru. Hajoun-ru Tata Kughen kɨmi əmawə. In əmə a kɨmawə yaksorkeikei.” ");
INSERT INTO nwi_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Kɨni Yesu rɨni-pən tukun mə, “Filip, Yo yɨmnarə pawk kɨtawə-m kɨmiə rapomh. ?Mərɨg ik nakeinein hanə Yo uə? Yermamə yame raməm Yo, raməm mɨn Tatə Kughen. ?Rhawor e ik nakamni mə jakhajoun Tata Kughen kɨmi əmiə? ");
INSERT INTO nwi_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","?Nakamni nəfrakɨsien irak mə nɨmraghien kafak, ramarə iriu Tatə Kughen, kɨni nɨmraghien kafan ramarə irak? Nəgkiarien e yakamni, pəh nien mə kafak əmə. Nɨpɨg m-fam, Tatə Kughen ramarə irak, mamor wok ye nɨmraghien kafak. ");
INSERT INTO nwi_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Hani nəfrakɨsien irak mə nɨmraghien kafak raməmɨr ye Tatə Kughen, kɨni nɨmraghien kafan raməmɨr irak. Mərɨg tukmə nakhapəh nɨshatətəyen irak məknenkɨn, takhani nəfrakɨsien irak tuk nɨmtətien yamə mɨne yakamor. ");
INSERT INTO nwi_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Yakamni-pre əfrakɨs tuk əmiə mə narmamə yamə mɨne kamhani nəfrakɨsien irak, iriə tukasor narɨmnar yamə mɨne Yo yakamor. Nəfrakɨsien mə iriə tuksor nɨmtətien rɨpsaah rapita yame Yo yakamor, meinai Yo yaknəpəh tokrei tanə e, mɨnamrerɨg-pən tuk Tatə Kughen. ");
INSERT INTO nwi_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Yo Ji Kughen, kɨni tukmə naksaiyoh Kughen kɨn naha nhagɨn ye nhagɨk, Yo jakaməkeikei mor, mə wok e kafak - Yo kwajikovə kape Kughen - tukrɨvəhsi-haktə nhag Tatə Kughen. ");
INSERT INTO nwi_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kɨni tukmə naksaiyoh Yo kɨn nar kɨrik ye nhagɨk, jakaməkeikei mor.” ");
INSERT INTO nwi_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kɨni Yesu rɨmnəgkiar mɨrpɨn nəgkiarien kafan mɨmə, “Tukmə kɨmiə naksorkeikei Yo, takasəkeikei masor nəgkiarien kafak. ");
INSERT INTO nwi_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kɨni Yo, jakaiyoh Tatə Kughen mə In tukrher-pre kɨn Yasitu mɨn kɨrik rurə tuk əmiə. Kɨni In tukramarə rerɨn kɨmiə min. ");
INSERT INTO nwi_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yasitu a in Nanmɨn kape Nəfrakɨsien. Narmamə kape tokrei tanə tukhapəh nhavəhyen In yerkiriə, meinai iriə khapəh nɨsəmien In, maseinein In. Mərɨg kɨmiə nakwənharkun ta In, meinai In ramarə kɨmiə min. Kɨni In tukraməmɨr yerkimiə kape nɨpɨg m-fam. ");
INSERT INTO nwi_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nɨpɨg Yo jaktərhav, to yakpəh nəpəhyen əmiə naksarə pɨsɨn əmə, rəmhen kɨn kwajikovə yame khamhə tan kɨn. Yo jakpirerɨg-pə mɨn tuk əmiə. ");
INSERT INTO nwi_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Pəh nien mə tuktu, narmamə kape tokrei tanə tukhapəh nɨsəm-mɨnien Yo. Mərɨg kɨmiə takasəm Yo kape nɨpɨg m-fam. Yo jakamragh mɨn ye nɨmhəyen kafak, kɨni kɨmiə mɨn takhamragh mɨn ye nɨmhəyen kapəmiə. ");
INSERT INTO nwi_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ye nɨpɨg kape narɨmnar mɨnə e, kɨmiə takharkun mə nɨmraghien kafak raməmɨr ye Tatə Kughen. Kɨni nɨmraghien kapəmiə raməmɨr irak, kɨni nɨmraghien kafak raməmɨr irəmiə. ");
INSERT INTO nwi_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Yermamə yame ravəhs-huvə nəgkiarien kafak, kɨni mamor, norien a ramhajoun pən mə in rorkeikei Yo. Kɨni yermamə yame rorkeikei Yo, Tatə Kughen rorkeikei mɨn in. Kɨni Yo mɨn jakorkeikei in. Mor əpu yo kɨmin, mə in tukrɨrkun huvə Yo.” ");
INSERT INTO nwi_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Məkneikɨn, Judas e (pəh nien mə Judas Iskariot, mərɨg nɨfnagni kɨrik), rɨmnaiyoh In mɨmə, “Yermaru. ?Nakhawor mor əpu əmə Ik kɨmi əmawə, kɨni mɨpəh nor-əpu-yen Ik kɨmi narmamə m-fam ye tokrei tanə?” ");
INSERT INTO nwi_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Mərɨg Yesu rɨni-pən tukun mɨmə, “Yermamə yame rorkeikei Yo, in tukraməkeikei mamor kafak nəgkiarien. Kɨni Kafak Tatə tukrorkeikei in. Kɨni kɨmru kafak Tatə, jakrauə mwarə kɨmasɨr min. ");
INSERT INTO nwi_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yermamə yame rɨpəh norkeikeiyen Yo, in to rɨpəh norien nəgkiarien kafak. Nəgkiarien yamə mɨne nɨmɨsərɨg yakamni, pəh nien mə yakamni atuk əmə. Mərɨg yɨmɨvəh nəgkiarien mɨnə a tuk kafak Tatə yame rɨmnher-pə kɨn Yo yakuə. ");
INSERT INTO nwi_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Yo yakamni-ərhav-pre nəgkiarien mɨne kɨmi əmiə ye nɨpɨg kɨtawə-m kɨmiə. ");
INSERT INTO nwi_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mərɨg Nanmɨn kape Kughen yame in Yasitu, yame Tatə Kughen tukrher-pre kɨn ye nhagɨk, In tukrhajoun əmiə kɨn narɨmnar mɨnə fam. Kɨni mor əmiə mə rɨkimiə tukraməsɨk narɨmnar yame yakamni-pre tuk əmiə, mə takhapəh nɨsəru-kɨnien. ");
INSERT INTO nwi_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Pəh nien mə tuktu, yakəpəh əmiə, kɨni mərəhu-pre nəmərinuyen kafak ramarə tuk əmiə. Kɨni nəmərinuyen e yame jakvəhsi-pre kɨmi əmiə, ror pɨsɨn ye nəmərinuyen yame narmamə kape tokrei tanə kasərəhu. Rɨkimiə tukrɨpəh nəpouyen, mhapəh nhagɨnien. ");
INSERT INTO nwi_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kɨmiə nakwəsərɨg ta nəgkiarien kafak yame yɨmɨni-pre tuk əmiə mɨmə, ‘Yo jakpiəpəh əmiə, kwasɨg ikɨn, mɨpirerɨg-pə mɨn tuk əmiə.’ Tukmə naksorkeikei əfrakɨs Yo, rɨkimiə tukragien əmə mə taksəm Yo yakamvən tuk kafak Tatə, meinai In yerpɨrɨg rapita Yo. ");
INSERT INTO nwi_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Yo yakwəni-pre ta narɨmnar mɨnə e tuk əmiə ai taktakun, yamə mɨne tukpihatərhav-pə, mə nɨpɨg tukhauə mɨsor nəfrakɨsien kɨn, kɨmiə takhani nəfrakɨsien irak. ");
INSERT INTO nwi_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","To yakpəh nəgkiar-pɨkien kɨtawə-m kɨmiə, meinai Setan e yermaru kape tokrei tanə rɨnamuə. Nəsanɨnien kafan rɨkək tuk napitayen Yo, ");
INSERT INTO nwi_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","mərɨg yakamor atuatuk əmə nəgkiarien kape Tatə Kughen, mə narmamə kape tokrei tanə tukharkun mə Yo yakorkeikei In.” Kɨni Yesu rɨmə, “Ita. Pəh kɨsərer mɨsap eikɨn e.” ");
INSERT INTO nwi_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kɨni Yesu rɨmɨni mɨmə, “Yo e nuknei nai əfrakɨs. Rɨmɨk In yəsim. ");
INSERT INTO nwi_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kɨni kwermɨ nai mɨnə fam yamə mɨne khapəh nhakuəyen, In tukrərəru ta əriə. Kɨni kwermɨ nai mɨnə fam yamə mɨne kamhakuə, In tukrəspir əriə mə tukhakuə kɨn kwənkwairiə rɨpsaah. ");
INSERT INTO nwi_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kɨni kɨmiə naksəmhen kɨn kwermɨ nai. Yakaməspir huvə əmiə kɨn nəgkiarien yame yakamni-pre tuk əmiə. ");
INSERT INTO nwi_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Səpit-pə irak, kɨni jakəpit-pre irəmiə. To kwermɨ nai rɨpəh nəpit-pənien ye nɨpran, to rɨpəh nɨkuəyen. Ye norien kɨrikianə əmə mɨn, tukmə nakhapəh nɨsəpit-pəyen irak, to nɨmraghien kapəmiə rɨpəh norien kwənkwan. ");
INSERT INTO nwi_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Yo e nuknei nai. Kɨni kɨmiə rəgrəgɨn mɨnə. Yermamə yame rəpit-pə irak, kɨni jakəpit-pən iran, nɨmraghien kafan tukror kwənkwan rɨpsaah. Mərɨg tukmə naksəpəh Yo, to nakhapəh nɨsorien nar kɨrik. ");
INSERT INTO nwi_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Yermamə yame rɨpəh nəpit-pəyen irak in rəmhen kɨn kwermɨ nai yame kərəru, kamarakikɨn, ramswiin mɨmsiə. Kwermɨ nai yamə mɨne kɨsor məknakɨn, kampɨk, kamarakikɨn-pən ye nap, kavaan əru. ");
INSERT INTO nwi_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Tukmə naksəpit-pə tuk Yo, kɨni nəgkiarien kafak raməmɨr irəmiə, naha nhagɨn yame kɨmiə naksorkeikei mɨsaiyoh kɨn, Kughen tukrɨvəhsi-pre kɨmi əmiə. ");
INSERT INTO nwi_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nɨmraghien kapəmiə tukror kwənkwan rɨpsaah; nar a tukravəh-si haktə nhag Tatə, kɨni mamhajoun mə kɨmiə kafak mɨnə narmamə. ");
INSERT INTO nwi_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Tatə Kughen In rorkeikei pɨk Yo. Kɨni ye norien kɨrikianə əmə mɨn, Yo yakorkeikei əmiə. Haraptərəkɨn tɨm tɨm kafak norkeikeiyen. ");
INSERT INTO nwi_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tukmə nakasor kafak nəgkiarien, takamharəh tɨm tɨm kafak norkeikeiyen, rəmhen əmə kɨn yame yakamor nəgkiarien kape Tatə Kughen, mamraptərəkɨn tɨm tɨm norkeikeiyen kafan. ");
INSERT INTO nwi_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Yo yɨmnamni-ərhav-pre nəgkiarien e tuk əmiə mə rɨkimiə tukragien, rəmhen kɨn yame Yo, rɨkik ramagien. Kɨni rɨkimiə tukragien magien pɨk. ");
INSERT INTO nwi_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yakamərəhu-pre natuakəmien kɨrik kɨmi əmiə mə takasəkeikei mɨsorkeikei əmiə mɨnə, rəmhen kɨn yame Yo yakorkeikei əmiə. ");
INSERT INTO nwi_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Yermamə yame rameighan-pən kɨn kafan nɨmraghien mə tukrɨvəh mɨragh in mɨnə tɨksɨn, norkeikeiyen kafan rehuə rapita norkeikeiyen kape narmamə mɨnə tɨksɨn. ");
INSERT INTO nwi_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tukmə nakasor kafak nəgkiarien, ramhajoun-pən mə kɨmiə kafak tɨksɨn fren mɨnə. ");
INSERT INTO nwi_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","To yakpəh nokrən-mɨnien kɨn əmiə mə yorwok mɨnə kafak, meinai yorwok ramor əmə wok meinein nərɨgien kape yamehuə kafan. Mərɨg taktakun ai, yakamokrən kɨn əmiə mə kafak mɨnə fren, meinai yakamni-ərhav-pre fam nəgkiarien yame Tatə Kughen ramni-pə tuk Yo. ");
INSERT INTO nwi_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Pəh nien mə kɨmiə nɨmnharpen Yo; mərɨg Yo yɨmɨrpen əmiə. Kɨni Yo yakamɨrpen əmə mə takhavən masor wok, kɨni pəh wok kapəmiə tukror kwənkwan. Kɨni kwənkwai wok kapəmiə tukraməmɨr kape rerɨn. Kɨni ai, tukmə naksaiyoh kɨn naha nhagɨn kɨmi Tatə Kughen ye nhagɨk, kɨni In tukrɨvəhsi-pre kɨmi əmiə. ");
INSERT INTO nwi_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Yakamərəhu-pre natuakəmien kɨrik kɨmi əmiə mə takasəkeikei mɨsorkeikei əmiə mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Kɨni Yesu rɨni-pən mɨn tuk əriə mɨmə, “Tukmə narmamə kape tokrei tanə kasəməkɨn əmiə, rɨkimiə tukraməkeikei maməsɨk mə apa kupan, iriə kɨmɨsəməkɨn məkneikɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","To rɨpi mə kɨmiə narmamə kape tokrei tanə, to narmamə kape tokrei tanə kɨsorkeikei əmiə; mərɨg pəh nien mə kɨmiə narmamə kape tokrei tanə e. Yo yakwɨrpen ta əmiə, kɨni mɨvəh-si ta əmiə tuk narmamə kape tokrei tanə. Ror pən, narmamə kape tokrei tanə kasəməkɨn əmiə. ");
INSERT INTO nwi_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Rɨkimiə tukraməkeikei məsɨk nəgkiarien yame yakwəni-pre ta tuk əmiə mə, ‘Yorwok kɨrik to rɨpəh nehuəyen rapita kafan yemehuə.’ Kɨni tukmə narmamə kape tokrei tanə kasor ahas pə pɨk kɨmi Yo, ye norien kɨrikianə əmə mɨn, iriə tukasəkeikei masor ahas pre tuk əmiə. To iriə kɨpisor nəgkiarien kafak, to kɨpisor mɨn nəgkiarien kapəmiə. ");
INSERT INTO nwi_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Iriə tuksor məknakɨn irəmiə, meinai kɨmiə kafak mɨnə narmamə, kɨni iriə kaseinein Kughen yame rɨmnher-pə kɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“To yakpipəh nuəyen məgkiar kɨmi əriə, to kɨpəh nəm-pənien nar kɨrik irəriə. Mərɨg taktakun ai, yakwauə ta; to khapəh nɨserkwaigien kɨn təvhagə has kapəriə. ");
INSERT INTO nwi_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yermamə yame raməməkɨn Yo, In raməməkɨn mɨn Rɨmɨk. ");
INSERT INTO nwi_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Yɨmauə mor nɨmtətien mɨnə e ye nɨmrɨriə, yame to yermamə pɨsɨn kɨrik rɨpəh norien. Ror pən, iriə kharkun mə Yo e pa. Kharkun pawk Yo, mərɨg kasəməkɨn Yo, masəməkɨn mɨn Rɨmɨk. Kɨni taktakun ai, tuksəm-pən nar has irəriə. ");
INSERT INTO nwi_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mərɨg narɨmnar mɨnə e tukasəkeikei mɨsor məknakɨn, mor mə nəgkiarien yame kɨmnharai ta ye nəkwəkwə kape Loa kapəriə tukruə mor nəfrakɨsien kɨn, yame ramni mə, “‘Yɨmɨpəh nor-pawk-əyen nar has kɨrik irəriə, mərɨg iriə kasəməkɨn Yo.’ ");
INSERT INTO nwi_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Mərɨg nɨpɨg Yasitu tukruə, in tukrɨni-ərhav Yo. Nanmɨn kape Nəfrakɨsien tukrɨsɨ-pən tuk Tatə Kughen. Kɨni Yo jakher-pre kɨn rurə tuk əmiə. ");
INSERT INTO nwi_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kɨni kɨmiə mɨn, takasəkeikei mhani-ərhav Yo, meinai kɨtawə-m kɨmiə kɨmnɨsarə kwis ye nɨrikakunien ye wok kafak muə meriaji-pə ai taktakun. ");
INSERT INTO nwi_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Yo yakamni-ərhav-pre narɨmnar mɨnə e tuk əmiə mə kapəmiə nhatətəyen tukrɨpəh nɨmɨrien. ");
INSERT INTO nwi_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Iriə tukpisher ta kɨn əmiə ye nimə kape nofugɨnien kapəriə; kɨni nəfrakɨsien əgkap mə nɨpɨg yame ramuə, tukshopni əmiə, mhamə ta mə nar yame kasor, rɨki Kughen ramagien tukun. ");
INSERT INTO nwi_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Iriə kasor narɨmnar mɨnə a meinai iriə kaseinein Tatə Kughen maseinein mɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mərɨg Yo yakaməkupan mamni-ərhav-pre narɨmnar mɨnə e tuk əmiə. Kɨni nɨpɨg tukmə nakwəsəm narɨmnar mɨnə a kɨnamor irəmiə, rɨkimiə tukraməsɨk mə Yo yakwəni-ta narɨmnar mɨnə a tuk əmiə. Kɨni Yesu rɨmə, “Mərɨg Yo yɨmnəpəh nɨniərhav-pre-yen narɨmnar mɨnə e tuk əmiə apa kupan, meinai kɨtawə-m kɨmiə kɨmnasəmɨr, nahasien mɨnə a ramuə əmə tuk Yo. ");
INSERT INTO nwi_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mərɨg taktakun ai, jakrerɨg-pən tuk Yermamə yame rɨmnher-pə kɨn Yo. Kɨni kɨmiə kɨrik rɨmnəpəh naiyohyen Yo mə yakamvən hiə. ");
INSERT INTO nwi_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Yakamni-ərhav-pre narɨmnar yamə mɨne tukrɨpitərhav-pə tuk əmiə, rɨkimiə rəpou. ");
INSERT INTO nwi_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mərɨg yakamni-pre əfrakɨs tuk əmiə mə rhuvə pɨk tuk əmiə mə jakəpəh əmiə. Meinai to yakpipəh nəpəhyen əmiə, to Yasitu rɨpipəh nəmɨrien tuk əmiə. Mərɨg tukmə yakəpəh əmiə mamvən, kɨni jakher-pre kɨn Yasitu tukruə marə kɨmiə min. ");
INSERT INTO nwi_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kɨni nɨpɨg In tukruə, mhajoun narmamə kape tokrei tanə mə iriə yor təvhagə has mɨnə, kɨni nətərɨgien kapəriə rɨpəh nəmhenien mə iriə tuksor nar ratuatuk ye nɨmrɨ Kughen. Kɨni nətərɨgien kapəriə rɨpəh nəmhenien tuk nəkirien norien kape narmamə. ");
INSERT INTO nwi_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nanmɨn e tukrhajoun əriə mə iriə yor təvhagə has mɨnə meinai khapəh nhaniyen nəfrakɨsien irak. ");
INSERT INTO nwi_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kɨni tukrhajoun əriə mə nətərɨgien kapəriə rɨpəh nəmhenien mə tuksor nar yame ratuatuk ye nɨmrɨ Kughen, meinai jakrerɨg-pən tuk kafak Tatə, kɨni iriə tukhapəh nɨsəm-mɨnien Yo. ");
INSERT INTO nwi_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kɨni tukrhajoun əriə mə nətərɨgien kapəriə rɨpəh nəmhenien tuk nəkirien norien kape narmamə, meinai Kughen in rɨnəkir ta yermaru kape tokrei tanə e Setan mɨmə tukrɨvəh-si-pən narpɨnien kɨmin. ");
INSERT INTO nwi_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Yakmə jakni-pre narɨmnar rɨpsaah mɨn tuk əmiə. Mərɨg to nakhapəh nhapɨk-famien əriə, meinai iriə khaskai pɨk tuk əmiə. ");
INSERT INTO nwi_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mərɨg nɨpɨg Nanmɨn kape Nəfrakɨsien tukruə, In tukrɨkɨr əmiə, mor əmiə takharkun nəfrakɨsien mɨnə fam. In to rɨpəh nɨni-atuk-əməyen kafan nəgkiarien. Mərɨg In tukramni-ərhav əmə narɨmnar yamə mɨne In ravəh tuk Tatə Kughen. Kɨni mamni-ərhav-pre tuk əmiə narɨmnar fam yame tuk nɨpɨg kɨrik kɨpihauə. ");
INSERT INTO nwi_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","In tukrɨvəh nəgkiarien əfrakɨs tuk Yo mɨni-ərhav-pre tuk əmiə. Tukror norien a, mɨvəh-si haktə Yo. ");
INSERT INTO nwi_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Narɨmnar fam kape Tatə Kughen, kafak. Ror məkneikɨn, Yo yakamni mə Nanmɨn e tukrɨvəh nəgkiarien əfrakɨs tuk Yo, mamhoprai-pre kɨmi əmiə.” ");
INSERT INTO nwi_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Kɨni Yesu rɨmɨni-pən tuk əriə mɨmə, “Pəh nien mə tuktu, takhapəh nɨsəm-mɨnien Yo; kwasɨg ikɨn, taksəm mɨn Yo.” ");
INSERT INTO nwi_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kɨni narmamə tɨksɨn kafan kɨsaiyoh əriə mɨnə mhamə, “?Nəgkiarien e nɨpran rɨmə naha? In ramni-pə tuk ətawə mɨmə, ‘Pəh nien mə tuktu, takhapəh nɨsəm-mɨnien Yo; kwasɨg ikɨn, taksəm mɨn Yo,’ kɨni In rɨmɨni mɨn mɨmə, ‘Yakamvən jakəm Tatə Kughen.’ ");
INSERT INTO nwi_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","?Nəgkiarien e rɨmɨni mə, ‘pəh nien mə tuktu’ nɨpran ramni mə naha? Kɨtawə kɨseinein nəgkiarien e In ramni.” ");
INSERT INTO nwi_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Kɨni Yesu ruɨrkun ta mə iriə kasorkeikei mə tuksaiyoh In kɨn nɨprai nəgkiarien kafan, kɨni In rɨmɨni-pən tuk əriə mə, “?Rhawor? Yo yakamni mə, ‘Pəh nien mə tuktu, takhapəh nɨsəm-mɨnien Yo; kwasɨg ikɨn, taksəm mɨn Yo.’ ?Kɨni taktakun ai naksaiyoh əmiə mɨnə mə takharkun nɨprai nəgkiarien e uə? ");
INSERT INTO nwi_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yakamni-pre əfrakɨs tuk əmiə mə rɨkimiə tukrəmhə, taksasək pɨk. Mərɨg narmamə kape tokrei tanə, rɨkiriə tukragien. Kɨmiə taksərɨg rahas pɨk, mərɨg nəmhəyen kapəmiə tukrukreikɨn muə nagienien. ");
INSERT INTO nwi_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Tukmə ruauə ipakə mə piraovɨn kɨrik tukreimək kɨn kwajikovə kafan, tukraməkeikei mərɨg rahas; meinai rɨnor nɨpɨg kafan mə tukreimək. Mərɨg kwasɨg ikɨn, tukmə tɨni rarha, rɨkin tukrɨpəh nəsɨk-mɨnien nəmhəyen kafan. Rɨkin tukragien əmə meinai tɨni rɨmnarha-pə ye tokrei tanə. ");
INSERT INTO nwi_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ye norien kɨrikianə əmə mɨn, naksərɨg rahas pawk ai taktakun, mərɨg kwasɨg ikɨn, jakəm mɨn əmiə, kɨni rɨkimiə tukragien pɨk; to yermamə kɨrik rɨpəh nor-mɨnien əmiə naksərɨg rahas. ");
INSERT INTO nwi_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ye nɨpɨg a, to nakhapəh nɨsaiyoh-mɨnien Yo kɨn nɨprai nəgkiarien kɨrik. “Yakamni-pre əfrakɨs tuk əmiə mə tukmə naksaiyoh Tatə Kughen kɨn nar kɨrik ye nhagɨk, kɨni In tukrɨvəh-si pre kɨmi əmiə. ");
INSERT INTO nwi_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nakhapəh nɨsaiyoh-hanəyen kɨn nar kɨrik ye nhagɨk. Mərɨg saiyoh kɨn, mhavəh, pəh rɨkimiə tukragien pɨk.” ");
INSERT INTO nwi_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Kɨni Yesu rəgkiar mamni mɨmə, “Yo yɨmɨni-pre nuhpɨkɨnien ye narɨmnar mɨnə e tuk əmiə. Mərɨg nɨpɨg ramuə yame jakpəh nɨni-pre-əmə-yen nuhpɨkɨnien mɨnə tuk əmiə, mərɨg jakəgkiar atuatuk kɨn Tatə Kughen kɨmi əmiə, mə takharkun huvə In. ");
INSERT INTO nwi_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ye nɨpɨg a, to yakpəh nəgkiar-atuə-kɨnien kapəmiə, mərɨg taksəgkiar atuatuk kɨmiə Tatə Kughen mɨsaiyoh In kɨn narɨmnar ye nhagɨk. ");
INSERT INTO nwi_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Meinai Tatə Kughen In rorkeikei pɨk əmiə, meinai kɨmiə naksorkeikei Yo, mamhani nəfrakɨsien irak mə yɨmasɨ-pən ye Kughen. ");
INSERT INTO nwi_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yɨmasɨ-pən ye Tatə Kughen muə ye tokrei tanə. Kɨni pəh nien mə tuktu, jaktərhav mɨn ye tokrei tanə, mɨrerɨg-pən mɨn tuk Tatə Kughen.” ");
INSERT INTO nwi_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kɨni narmamə kafan mɨnə kɨmnhani mhamə, “!In en! Taktakun ai ik nakpəh nɨni-əməyen nuhpɨkɨnien, mərɨg nakamhoprai atuatuk əmə nəgkiarien. ");
INSERT INTO nwi_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Taktakun ai yakwənharkun ta mə to yermamə kɨrik rɨpəh hanə nɨni-pre-yen nəgkiarien kɨrik, kɨni ik nakwɨrkun ta nərɨgien kafan. !Nar e ramhajoun-pən mə Ik nɨmasɨ-pən ye Kughen!” ");
INSERT INTO nwi_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Kɨni Yesu rɨni-pən tuk əriə mə, “Nakamhani nəfrakɨsien irak ai taktakun. ");
INSERT INTO nwi_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mərɨg sətərɨg-ru. Nɨpɨg ramuə, kɨni nəfrakɨsien mə ruauə ta- yame narmamə tuksəko ye rhav əmiə taksaiyu rik rik, mamhavən iməmiə mɨnə ikɨn, mɨsəpəh pɨsɨn əmə Yo yakaməmɨr. Mərɨg Yo yakpəh nəmɨrien Yo pɨsɨn, meinai nɨpɨg m-fam Kafak Tatə raməmɨr kɨmru min. ");
INSERT INTO nwi_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Yo yakwəni-ərahv-pre ta narɨmnar mɨnə e tuk əmiə, mə takhapəh nɨsətərɨg-pɨkien tukun, mɨsarə ye nəmərinuyen meinai nɨmraghien kapəmiə raməmɨr irak. Nɨpɨg tukmə naksarə ye tokrei tanə e, takasəkeikei mɨsarə ye nəmhəyen. Mərɨg takhapəh nhagɨnien, masərer tɨm tɨm, meinai Yo yɨmnapita nəsanɨnien kape tokrei tanə.” ");
INSERT INTO nwi_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu rɨnamni narɨmnar mɨnə a, mɨvaag haktə ye neai, mamni mɨmə, “Kafak Tatə. Nɨpɨg ruauə ta. Vəh-si haktə nhagɨk pəh rehuə, mə Yo mɨn jakvəh-si haktə nhagɨm pəh rehuə, ");
INSERT INTO nwi_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","meinai Ik nɨmɨvəhsi-pə nəsanɨnien mɨne nehuəyen kɨmi Yo e kafam Kwajikovə; mə jakamarmaru ye narmamə mɨnə fam, kɨni mɨrkun mɨn nɨvəhsi-pənien nɨmraghien rerɨn kɨmi narmamə yamə mɨne nɨmɨvəhsi-pə əriə kɨmi Yo. ");
INSERT INTO nwi_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kɨni nɨmraghien rerɨn e, nɨpran e mə narmamə tukharkun Ik, yame Ik pɨsɨn əmə Ik Kughen əfrakɨs, mharkun Yo, Yesu Kristo, yame Ik nɨmnher-pə kɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Yo yɨmnavəh-si haktə nhagɨm ye tokrei tanə e, kɨni mɨnor ta infamien ye wok yame Ik nɨmɨvəhsi-pə kɨmi Yo mə jakor. ");
INSERT INTO nwi_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tatə, taktakun ai, takvəh Yo yakurə mamarə kɨrau mik. Vəh-si haktə Yo mɨvəhsi-pə nehuəyen kɨmi Yo, rəmhen əmə kɨn yame yakwəvəh ta kupan nɨpɨg tokrei tanə e rɨmnamrɨkək hanə. ");
INSERT INTO nwi_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Narmamə yamə mɨne Ik nɨmɨvəh-si ta əriə ye tokrei tanə mɨvəh-si pə kɨmi Yo, Yo yakamhajoun əriə kɨn Ik. Kupan, iriə kafam narmamə mɨnə; mərɨg taktakun ai, Ik nakamərəhu-pən əriə ye kwermɨk, mə iriə kafak mɨnə narmamə. Iriə kasəri-pən kafam nəgkiarien, ");
INSERT INTO nwi_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","kɨni taktakun ai, iriə kharkun mə narɨmnar yame nɨmɨvəhsi-pə kɨmi Yo, ramsɨ-pre əmə tuk Ik. ");
INSERT INTO nwi_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Iriə kharkun narɨmnar mɨnə e meinai Ik nakwəni-pə ta nəgkiarien iran kɨmi Yo, kɨni Yo yakməni-ərhav-pən tuk əriə, kɨni iriə kamhavəh yerkiriə, mharkun mə nəfrakɨsien əgkap mə Yo yɨmasɨ-pre tuk Ik, mamhani nəfrakɨsien mə Ik nɨmnher-pə kɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Yo yakaməhuak tuk əriə. Yakpəh nəhuakien tuk narmamə kape tokrei tanə. Yakaməhuak əmə tuk narmamə yamə mɨne Ik nɨmɨvəh-si-pə əriə kɨmi Yo, meinai iriə kafam narmamə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Narmamə mɨnə e yɨmɨpɨk əriə, iriə fam mɨne e, iriə kafam narmamə mɨnə. Kɨni narmamə mɨfam e nɨmɨpɨk əriə, kafak mɨnə fam. Kɨni Ik nɨmnor narmamə mɨnə e mə nɨmraghien kapəriə ravəh-si haktə nhagɨk. ");
INSERT INTO nwi_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Taktakun ai, yaknauvrə tuk Ik, kɨni pəh nien mə tuktu, jakpəh narə-mɨnien ye tokrei tanə e. Mərɨg narmamə mɨnə e kasarə hanə ye tokrei tanə e. Tatə, Ik nakatuatuk əgkap. Takəpkətərəkɨn narmamə mɨnə e pəh tukasarə huvə ye nəsanɨnien kafam, yame Ik nɨmɨvəh-si pə kɨmi Yo, mə iriə tukasarə kɨrikianə əmə, rəmhen kɨn yame kɨrau kwarə kɨrikianə. ");
INSERT INTO nwi_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nɨpɨg yɨmnamarə kɨmawə miriə, kɨni yɨmnarha huvə tuk əriə ye nəsanɨnien kafam yame Ik nɨmɨvəhsi-pə kɨmi Yo. Yɨmnaməm huvə əriə, mɨpəh nəpəhyen kɨrik. Iriə kɨrikianə əmə rɨmnerwei, yermamə e in e yame tukraməkeikei mɨvəh narpɨnien. Nar a rɨmatərhav-pə mor nəgkiarien ye Nəkwəkwə Imərhakə ruə mor nəfrakɨsien kɨn. ");
INSERT INTO nwi_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Taktakun ai, yaknavruə tuk Ik, mərɨg yakamarə hanə ye tokrei tanə mamni nəgkiarien mɨnə e, mə narmamə mɨnə e tukhavəh fam nagienien e raməmɨr yerkik. ");
INSERT INTO nwi_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Yo yɨmɨni-ərhav-pən kafam nəgkiarien kɨmi əriə. Kɨni ror məkneikɨn, narmamə kape tokrei tanə kasəməkɨn əriə, meinai iriə pəh nien mə narmamə kape tokrei tanə, rəmhen kɨn yame pəh nien mə Yo yermamə kape tokrei tanə. ");
INSERT INTO nwi_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Pəh nien mə yakamaiyoh Ik mə takvəh-si ta əriə ye tokrei tanə. Mərɨg yakorkeikei mə Ik takərer əswasɨg kɨn yemə has e Setan, mə in tukrɨpəh nuəyen moriah əriə. Ik takamarha huvə tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Pəh nien mə Yo yermamə kape tokrei tanə. Ror pən, iriə mɨn, pəh nien mə narmamə kape tokrei tanə. ");
INSERT INTO nwi_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kafam nəgkiarien raməfrakɨs. Ik takor kafam nəgkiarien pəh ramor wok ye nɨmraghien kapəriə mə iriə tukhauə narmamə əfrakɨs mɨnə kafam, mɨsəmərhakə mɨsatuatuk. ");
INSERT INTO nwi_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ik nɨmnher-pə kɨn Yo yakuə ye tokrei tanə e; kɨni ye norien kɨrikianə əmə mɨn, Yo yakamher-ərhav kɨn əriə mə tuksarkurao ye tanɨmtanə. ");
INSERT INTO nwi_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kɨni Yo yakvəh-si pre atuk Yo mə jakamərhakə, mə jakasitu ye narmamə mɨnə e, mə iriə mɨn tuksəmərhakə mɨsatuatuk, mə iriə tukhauə narmamə əfrakɨs kafam. ");
INSERT INTO nwi_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Pəh nien mə yakaməhuak əmə tuk narmamə kafak mɨnə, mərɨg yakaməhuak mɨn tuk narmamə tɨksɨn mɨn yamə mɨne kafak narmamə mɨnə tukhani-ərhav pən kafak nəgkiarien kɨmi əriə, pəh iriə tukshatətə irak. ");
INSERT INTO nwi_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tatə, yakaməhuak tuk əriə, mə iriə m-fam tukhauə kɨrikianə əmə, rəmhen əmə kɨn yame kɨrau kwarə kɨrikianə əmə. Kafak nɨmraghien raməmɨr iram, kɨni kafam nɨmraghien raməmɨr irak. Yakaməhuak tuk əriə mə tukhauə kɨrikianə kɨtawə mik, mə narmamə kape tokrei tanə tukhani nəfrakɨsien irak mə nɨmnher-pə kɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ik nakwəvəh-si-pə ta nehuəyen kɨmi Yo, kɨni Yo yakamautə-pən kɨn kafak nehuəyen kɨmi əriə, mə iriə tuksarə kɨrikianə rəmhen kɨn yame kɨrau kwarə kɨrikianə. ");
INSERT INTO nwi_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kafak nɨmraghien raməmɨr yerkiriə; kɨni kafam nɨmraghien raməmɨr irak. Ror pən, yakaməhuak mə iriə tukhauə kɨrikianə ye narɨmnar fam, mə narmamə kape tokrei tanə tuksəm əriə, kharkun mə Ik nɨmnher-pə kɨn Yo, mharkun mə Ik nakorkeikei kafam narmamə mɨnə rəmhen əmə kɨn yame Ik nakorkeikei Yo. ");
INSERT INTO nwi_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tatə. Ik nɨmnərəhu-pə əriə ye kwermɨk mə iriə kafak narmamə mɨnə. Kɨni Yo yakorkeikei mə iriə tukharkun nɨvənien aikɨn Yo yakamvən ikɨn, mə iriə tuksəm nehuəyen kafak yame jakpivəh. Nehuəyen e, Ik nɨmɨvəhsi-pə kɨmi Yo, meinai Ik nɨmnorkeikei Yo məkupan, nɨpɨg tokrei tanə rɨmnamrɨkək hanə. ");
INSERT INTO nwi_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Tatə. Ik nakatuatuk pɨk. Narmamə kape tokrei tanə, iriə kɨseinein Ik, mərɨg Yo yakɨrkun Ik. Kɨni narmamə kafak mɨnə, iriə kharkun mə Ik nɨmnher-pə kɨn Yo. ");
INSERT INTO nwi_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Yo e yɨmnor əpu Ik kɨmi əriə, mə iriə tukharkun huvə Ik, kɨni Yo, jakaməkeikei mamor əpu Ik mamrɨpɨn, mə norkeikeiyen kafam tukramarə yerkiriə, mə Yo mɨn jakamarə yerkiriə.” ");
INSERT INTO nwi_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu rɨmnəhuak ta, mɨtərhav ye taon a, mukurao-pən ye kwenɨmrhe tukwas mir, ye nɨkwətanə kɨrik kamni kɨmə Kedron, mhaktə ye tukwas, mɨvən aikɨn kaməsim ikɨn. Kɨni Yesu mɨne kafan narmamə mɨnə kɨmnhavən yerki nai mɨnə a. ");
INSERT INTO nwi_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Kɨni Judas e kwasɨg ikɨn rɨmneighan-pən kɨn Yesu kɨmi tɨkmɨr mɨnə kafan, in ruɨrkun ta kwənmhaan a, meinai nɨpɨg kɨrik, Yesu mɨne kafan narmamə mɨnə iriə kasofugɨn əriə mɨnə aikɨn. ");
INSERT INTO nwi_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kɨni jif pris mɨnə mɨne Farisi mɨnə kɨmɨsher-pən kɨn mobael mɨnə tɨksɨn kape nəmə Rom mɨne mobael mɨnə tɨksɨn yamə mɨne kasarha tuk Nimə Ehuə kape Kughen, khauə mɨsəm Judas. Kɨni Judas rɨkɨr əriə mhavən yerki nəsimien a. Iriə kɨmnhapɨk kwensiə, mɨne laet, mɨne narɨmnar kape narowagɨnien. ");
INSERT INTO nwi_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Kɨni Yesu ruɨrkun ta naha nhagɨn yame tukor iran. Mərɨg rɨmnəriwək, mɨvən tuk əriə, maiyoh əriə mɨmə, “?Nakasarha-kɨn pa?” ");
INSERT INTO nwi_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Kɨni iriə khani-pən tukun mhamə, “Yakasarha-kɨn yemə Nasaret kɨrik, nhagɨn e Yesu.” Kɨni In rɨni-pən tuk əriə mə, “Yo e.” (Kɨni Judas e yame rɨmnheighan-pən kɨn Yesu ye kwermɨriə, in ramərer iriə min). ");
INSERT INTO nwi_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kɨni nɨpɨg Yesu rɨmɨni mɨmə, “Yo e,” iriə kɨmɨsəriwək kɨn nɨmeitairiə mharerɨg, mɨseiwaiyu, mhamɨr. ");
INSERT INTO nwi_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kɨni Yesu rarə maiyoh mɨn əriə mɨmə, “?Kɨmiə nakasarha-kɨn pa en?” Kɨni iriə khamə, “Yemə Nasaret kɨrik, nhagɨn e Yesu.” ");
INSERT INTO nwi_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Kɨni Yesu rɨmə, “Yakwəni-pre ta tuk əmiə mə ‘Yo e.’ Tukmə nakasarha-kɨn əmə Yo, səta ye narmamə mɨnə en pəh kamhavən.” ");
INSERT INTO nwi_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","In rɨmɨni məknakɨn mə nəgkiarien yame ruɨni ta tukruə mor nəfrakɨsien kɨn, yame rɨmɨni mɨmə, “Tatə, narmamə yame nɨmnərəhu-pən əriə ye kwermɨk, yɨmnamarha huvə tuk əriə, mɨpəh nəpəhyen kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Kɨni Saemon Pita, kafan kɨrik aikɨn nao nisə. Məkneikɨn rɨrəhsi-ərhav, mərəru ta nɨmətərgɨ slef kɨrik matuk kape hae pris. (Nhag slef e Malkas). ");
INSERT INTO nwi_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Mərɨg Yesu rɨmɨni-pən tuk Pita mə, “!Vai-pən nao nisə kafam ye tamhekɨn! Ik takaməkeikei mɨrkun mə Yo yakaməkeikei mamarə ye nəmhəyen yame Tatə Kughen ravəhsi-pə kɨmi Yo.” ");
INSERT INTO nwi_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kɨni mobael mɨnə kape nəmə Rom mɨne yemehuə kapəriə, mɨne mobael yamə mɨne kasarha tuk Nimə Ehuə kape Kughen kɨmnharəh Yesu mɨsarkɨs ətərəkɨn. ");
INSERT INTO nwi_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kɨmɨsəkupən mharəh In ramərer ye nɨmrɨ Anas. Anas e mɨrei Kaeafas. Kɨni Kaefas a ramor wok kape hae pris ye newk a. ");
INSERT INTO nwi_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","In apa kupan rɨmɨni-pən tuk nəmehuə kape nəmə Isrel mə, “Rhuvə əmə tuk əmiə mə yermamə kwənkwan kɨrikianə əmə tukrɨmhə tuk narmamə. Nar a rhuvə rapita yame narmamə ye kantri piəpiə tukhamhə.” ");
INSERT INTO nwi_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Yermamə mɨn kɨrik kape Yesu, hae pris rɨrkun huvə in. Kɨni iriu Saemon Pita karakwasɨg kɨn Yesu, mhavən ipakə tuk nimə kape hae pris. ");
INSERT INTO nwi_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Mərɨg Pita to rɨpəh nɨvənien imə, mamərer əmə ye kwəruə. Mərɨg yermamə a kape Yesu yame hae pris rɨrkun huvə in, rɨsɨ-pən imə, mɨtərhav-pə ye kwəruə, maməgkiar kəskəh kɨmi piraovɨn yame ramərer tuk kwəruə, kɨni reighan kɨn Pita mə tukrɨvən imə. ");
INSERT INTO nwi_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Məkneikɨn pian a yame ramərer tuk kwəruə rarha-pən məm Pita, maiyoh in mɨmə, “Eh. ?Ik mɨn yermamə kɨrik kape Yesu?” Mərɨg Pita rɨmə, “Nɨkam. Pəh nien mə yo yermamə kɨrik kafan.” ");
INSERT INTO nwi_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kɨni nɨpɨg a, nɨpɨg kape nokieiyen. Kɨni yor wok mɨnə kape hae pris, mɨne mobael mɨnə kɨmnasarkəp. Kɨni Pita ramərer iriə miriə, masərkəp. ");
INSERT INTO nwi_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ye nɨpɨg a, hae pris rɨmnaiyoh Yesu kɨn narmamə mɨnə kafan, mɨne naha nhagɨn yame In ramhajoun. ");
INSERT INTO nwi_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Kɨni Yesu rɨni-pən tukun mə, “Yo yɨmnamni-ərhav kafak nəgkiarien ye nɨmrɨ narmamə ye tokrei tanə. Nɨpɨg m-fam, yakamhajoun narmamə ye nimə kape nofugɨnien, mɨne apa ye Nimə Ehuə kape Kughen, ikɨn nəmə Isrel kasofugɨn ikɨn. Yakpəh nerkwaigien kɨn nar kɨrik. ");
INSERT INTO nwi_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","?Rhawor nakamaiyoh məkneikɨn Yo? Rhuvə pɨk mə takvən maiyoh-pən narmamə yamə mɨne kɨmnasərɨg kafak nəgkiarien. Iriə kharkun huvə narɨmnar yame yakməni-pən tuk əriə.” ");
INSERT INTO nwi_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu rəgkiar məknakɨn, mobael kɨrik yame ramərer tuk Nimə Ehuə kape Kughen ramərer ipakə tukun, marar mərɨp nɨkapɨn, mɨmə, “Nəgkiarien e nakamni-pən tuk hae pris rɨpəh nəmhenien.” ");
INSERT INTO nwi_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Kɨni Yesu rɨni-pən tukun mə, “?Rhawor e yakamni əmə nəgkiarien yamə mɨne kɨsatuatuk kɨni nakamərɨp nɨkapɨk tukun? Tukmə nakasəm mə yakməni nar kɨrik rɨpəh nəmhenien, hani.” ");
INSERT INTO nwi_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Məkneikɨn Anas rher-pən Yesu rɨvən məm hae pris e Kaeafas. Kɨpəh nɨrɨsɨn-ta-hanə-yen nərəus ye kwermɨn mir. ");
INSERT INTO nwi_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Kɨni Saemon Pita ramərkəp hanə, kɨni kɨsaiyoh-pən in mhamə, “Eh. Ik mɨn e ik yermamə kɨrik kafan uə?” Mərɨg Pita rɨmə, “Nɨkam. Pəh nien mə yo yermamə kɨrik kafan.” ");
INSERT INTO nwi_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Məkneikɨn, yorwok kɨrik kape hae pris, in kwənərəus kɨrik kape kwən a yame Pita rɨmnərəru-ta nɨmətɨrgɨn, rɨmɨni-pən tukun mə, “Rɨkik raməsɨk mə yɨmnəm əmiru min apa yerki nəsimien.” ");
INSERT INTO nwi_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Mərɨg Pita rɨmɨni-pən tukun mɨmə, “Pəh nien mə yo.” Ǝmə məkneikɨn, man rəkakə. ");
INSERT INTO nwi_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kɨni yenpɨg-enpɨg əgkap, kharaptərəkɨn Yesu mhatərhav ye nimə kape Kaeafas, mhavən ipakə tuk nimə kape Paelat. Paelat in gavman kape Rom, pəh nien mə yemə Isrel kɨrik. Kɨni nəmehuə kape nəmə Isrel kasəri-pən loa kapəriə, mhapəh nhavənien ye nəkwai nimə kape yermamə yame pəh nien mə yemə Isrel, tamə kɨsəmkɨmɨk, mɨseinein nənien nəvɨgɨnien kape Pasova. ");
INSERT INTO nwi_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","To khapəh nhavənien imei Paelat, Paelat rɨtərhav-pə, maiyoh əriə mɨmə, “?Naksəm-pən naha nhagɨn rahas ye kwən e?” ");
INSERT INTO nwi_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kɨni iriə khani-pən tukun mhamə, “To rɨmə kwən e rɨpəh norien nar has, to yakhapəh nhakɨrien mhauə kɨmik.” ");
INSERT INTO nwi_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Mərɨg Paelat rɨni-pən tuk əriə mɨmə, “Nɨkam. Rhuvə mə takhakɨr in mhavən. Rhuvə mə kɨmiə səkir norien kafan rəri-pən natuakəmien kapəmiə, mhavəhsi-pən narpɨnien kɨmin.” Mərɨg iriə kɨmnhani-pən tukun mhamə, “Mərɨg loa kape nəmə Rom ramni mə nəmehuə əmə kape Rom kharkun nhavəhsi-pənien narpɨnien kɨmi yermamə mə tukraməkeikei mɨmhə.” ");
INSERT INTO nwi_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Apa kupan, Yesu rɨmɨni mə In tukrɨmhə məknakɨn; kɨni narɨmnar mɨnə a rɨtərhav-pə mor nəgkiarien kafan ruə mor nəfrakɨsien kɨn). ");
INSERT INTO nwi_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Məkneikɨn Paelat rɨvən mɨn imə, mokrən kɨn Yesu mə tukruə mərer ye nɨmrɨn, kɨni raiyoh In mɨmə, “?Rhawor? ?Ik king kape nəmə Isrel uə?” ");
INSERT INTO nwi_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Kɨni Yesu raiyoh In mɨmə, “?Nərɨgien en kafam nakamni, uə narmamə kamhani-pre tuk ik?” ");
INSERT INTO nwi_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Kɨni Paelat rɨmɨni-pən tukun mɨmə, “!Ah! Pəh nien mə yo yemə Isrel kɨrik. Narmamə imam ikɨn əmə mɨne jif pris mɨnə kafam, iriə kɨmɨseighan-pə kɨn Ik ye kwermɨk. ?Naha e nɨmnor?” ");
INSERT INTO nwi_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Kɨni Yesu rɨmə, “Narmaruyen kafak rɨpəh nəmhenien kɨn narmaruyen kape tokrei tanə əmə. To rɨpimə narmaruyen kafak in kape tokrei tanə e, kafak narmamə mɨnə kɨpihaoh mobael mɨnə tuk Yo, mɨsərer əswasɨg kɨn nəmehuə kape nəmə Isrel mə tukhapəh nharaptərəkɨnien Yo. Mərɨg narmaruyen kafak ror pɨsɨn ye narmaruyen kape tokrei tanə.” ");
INSERT INTO nwi_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Kɨni Paelat rɨni-pən tukun mə, “Ɨnta. Ik nakamni mə Ik king kɨrik.” Kɨni Yesu rɨmə, “Tukmə ik nakamni mə Yo king, nəfrah. Yo yɨmnarha-pə ye tokrei tanə tuk nar kɨrikianə əmə, mə jakərer-ərhav mamni-ərhav nəfrakɨsien. Kɨni narmamə yamə mɨne kɨsorkeikei mə tuksərɨg nəfrakɨsien tukasəkeikei mɨsərɨg nəgkiarien kafak.” ");
INSERT INTO nwi_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Mərɨg Paelat rɨni-pən tukun mɨmə, “?Naha e nhagɨn nəfrakɨsien?” Kɨni Paelat rɨtərhav mɨn mɨvən məm nəmehuə kape nəmə Isrel, mɨni-pən tuk əriə mɨmə, “Yo yakpəh nəmien norien has kɨrik ye kwən e, yame ramni mə rɨmnakapɨr loa. ");
INSERT INTO nwi_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mərɨg ye norien kapəmiə, ye newk mɨnə fam, ye nɨpɨg kape Pasova, yakamrɨsɨn yermamə kwənkwan kɨrikianə ye kalabus. ?Kɨni rhawor ye nərɨgien kapəmiə? ?Nakhamə jakrɨsɨn king e kape nəmə Isrel uə?” ");
INSERT INTO nwi_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kɨni iriə kɨsokrən apomh mhamə, “!Nɨkam! Takpəh nɨrɨsɨnien. !Rɨsɨn Barabas!” (Barabas e rɨmɨkwasɨg kɨn narmamə tɨksɨn mamhauh mobael kape gavman). ");
INSERT INTO nwi_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kɨni Paelat reighan-pən kɨn Yesu ye kwermɨ mobael mɨnə, kɨni iriə kɨsərkɨs-ərkɨs In. ");
INSERT INTO nwi_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kɨni khapɨk nərəus kɨrik yame ror nhirɨn, mhakuh kəvəvhao kɨn, yame ramsɨgovɨn kəvəvhao kape king, kɨni mhaukrai-pən ye kapən kapə. Mɨsarkaoh-pən kɨn kot əwhao kɨrik yame ramsɨgovɨn kot kape king. ");
INSERT INTO nwi_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Kɨni masərer tukun, mɨsarh iakei iran, mamhani mhamə, “Ik e king kape nəmə Isrel. Kɨmawə yakamhavəhsi-pre nɨsiaiyen kɨmik.” Kɨni mɨsarar mɨsərɨp nɨkapɨn. ");
INSERT INTO nwi_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Kɨni Paelat rɨsɨ-pən imə mɨtərhav mɨni-ərhav mɨmə, “Eh. Narmamə. Yakamkɨr ye-rhav kwən e mə kɨmiə taksəm mə yakpəh nəm-pənien nar has kɨrik iran.” ");
INSERT INTO nwi_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kɨni Yesu rɨsɨ-pən imə mɨtərhav. Məvəvhao kɨn kəvəvhao yame kɨmnor kɨn nərəus yame ror nirhɨn, markaoh kɨn kot kape king, kɨni Paelat rɨni-pən tuk əriə mɨmə, “Səm-ru, kwən e ramuə.” ");
INSERT INTO nwi_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mərɨg jif pris mɨnə mɨne mobael yamə mɨne kasarha tuk Nimə Ehuə kape Kughen kɨmɨsarha-pən mɨsəm, masokrən apomh mamhani mhamə, “!Ǝsɨk-pən ye nai kamarkwao kɨn! !Ǝsɨk-pən ye nai kamarkwao kɨn!” Kɨni Paelat rɨmɨni-pən tuk əriə mə, “Nɨkam. Kɨmiə atuatuk hakɨr mhavən, mɨsəsɨk-pən In ye nai kamarkwao kɨn. Mərɨg Yo yakpəh nəm-pənien nar has kɨrik iran.” ");
INSERT INTO nwi_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Mərɨg iriə khamə, “Kapəmawə loa ramni mə In tukraməkeikei mɨmhə, meinai In ramni mə In Ji Kughen.” ");
INSERT INTO nwi_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Paelat rɨmnərɨg nəgkiarien a, rɨgɨn pɨk. ");
INSERT INTO nwi_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kɨni marar mɨvən mɨn imə, maiyoh Yesu mɨmə, “?Ik yemə hiə?” Mərɨg Yesu rɨpəh nhorpɨnien nəgkiarien kafan. ");
INSERT INTO nwi_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kɨni Paelat rɨni-pən tukun mɨmə, “?Rhawor e nakpəh nhorpɨnien nəgkiarien kafak? ?Nakɨrkun uə nɨkam mə yakavəh nehuəyen tuk nɨrɨsɨnien Ik uə tuk nəsɨk-pənien Ik ye nai kamarkwao kɨn?” ");
INSERT INTO nwi_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Kɨni Yesu rɨni-pən tukun mɨmə, “To Kughen rɨpipəh nɨvəhsi-preyen nehuəyen kɨmik, to nakpipəh nɨvəhyen nehuəyen tuk nəkirien Yo. Mərɨg hae pris rɨmneighan-pə kɨn Yo ye kwermɨm. Ror pən, Kughen tukrɨni mə in rɨmnor ta təvhagə has kɨrik rehuə rapita yame ik nɨmnor.” ");
INSERT INTO nwi_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kɨni rɨrikakun ye nɨpɨg a, Paelat rorkeikei mə tukrɨrɨsɨn Yesu. Mərɨg nəmehuə mɨnə kape nəmə Isrel kɨsokrən apomh mhamə, “Tukmə nakrɨsɨn kwən en ramvən, pəh nien mə ik yermamə əfrakɨs kɨrik kape King Sisa, meinai tukmə yermamə kɨrik ramni mɨmə in king, in tɨkmɨr kape Sisa.” ");
INSERT INTO nwi_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Paelat rɨmnərɨg nəgkiarien a, kɨni mɨkɨr Yesu mɨratərhav. Mɨvən ye kwənmhan kɨrik kamni kɨmə Kapier Ǝtən-ətən Ikɨn. (Ye nəgkiarien kape nəmə Isrel, kamni kɨmə Gabata). Kɨni məkwətə-pən ye jea kape nəkirien nəgkiarien. ");
INSERT INTO nwi_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ipakə yerkweiha, ye nɨpɨg kape nor-əpnəpənəyen ye nəvɨgɨnien kape Pasova. Kɨni Paelat rɨni-pən tuk nəmehuə kape nəmə Isrel mɨmə, “!Kapəmiə e king!” ");
INSERT INTO nwi_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Mərɨg iriə kasokr-apomh mamhani mhamə, “!Hakɨr ye-rhav! !Hakɨr ye-rhav! !Ǝsɨk-pən In ye nai kamarkwao kɨn!” Kɨni Paelat rɨni-pən tuk əriə mɨmə, “?Nəfrah? ?Kɨmiə naksorkeikei mə jakarkwətərəkɨn-pən king kapəmiə ye nai kamarkwao kɨn uə?” Kɨni jif pris mɨnə khamə, “Sisa pɨsɨn əmə in king kapəmawə.” ");
INSERT INTO nwi_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kɨni Paelat rɨmneighan-pən kɨn Yesu rɨvən ye kwermɨriə, mə mobael mɨnə kape Rom tuksarkwətərəkɨn-pən In ye nai kamarkwao kɨn. Kɨni kharəh Yesu mhavən. ");
INSERT INTO nwi_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","In atuk rɨnamrəh nai kamarkwao kɨn, mhatərhav mhavən ikɨn kɨrik, kamni kɨmə Kerhə irə jir. (Ye nəgkiarien kape nəmə Isrel, kamni kɨmə Golgota). ");
INSERT INTO nwi_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ye kwənmhaan atuatuk a in a, kɨmɨsarkwətərəkɨn haktə Yesu ikɨn ye nai kamarkwao kɨn. Mɨsarkwətərəkɨn mɨn yermamə kɨraru. Kɨrik ye nɨkarɨn matuk; kɨrik ye mawor. Kɨni Yesu rɨmnəker ye kwerkwan. ");
INSERT INTO nwi_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Kɨni Paelat rɨni, kɨrai ta nəgkiarien kɨrik, karkwətərəkɨn haktə ye nai kamarkwao kɨn. Nəgkiarien a ramni mə, “Yesu, Yemə Nasaret. In King kape nəmə Isrel.” ");
INSERT INTO nwi_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Kɨni nəmə Isrel khapsaah kɨmɨsəvheikɨn nəgkiarien a, meinai ikɨn a, kɨmɨsarkwətərəkɨn haktə Yesu ikɨn, ipakə əmə tuk taon. Kɨni nəgkiarien a kɨmɨrai ye nəgkiarien kape nəmə Isrel, mɨne ye nəgkiarien kape nəmə Rom, mɨne ye nəgkiarien kape nəmə Gris. ");
INSERT INTO nwi_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kɨni jif pris mɨnə kape nəmə Isrel kɨmnhavən mhani-pən tuk Paelat mhamə, “Takpəh nɨraiyen mə ‘In e king kape Isrel.’ Rhuvə mə takrai mə, ‘Kwən e in ramni mə in king kape nəmə Isrel.’” ");
INSERT INTO nwi_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Mərɨg Paelat rɨmə, “Nɨkam. Yakwərai, yakwərai.” ");
INSERT INTO nwi_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kɨni nɨpɨg mobael mɨnə kwəsəkwətərəkɨn-pən ta Yesu ye nai kamarkwao kɨn, kɨni mhapɨk kafan narɨmnar, kɨni mɨsəwhai narɨmnar mɨsətu nɨmrɨn kuas, meinai iriə kuas. Mərɨg kɨmnhapəh nɨsəwhaiyen kot apomh kafan. Nɨpərɨn əmə, yame kɨpəh nɨjirien. ");
INSERT INTO nwi_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Mhani-pən tuk əriə mɨnə mhamə, “To khapəh nɨseikusien. Pəh kɨsəsɨk daes tukun. Yermamə yame rapita, kafan e kot.” Nar e rɨtərhav-pə mor nəgkiarien ye nəkwəkwə kape Kughen ruə mor nəfrakɨsien kɨn, yame ramni mə, “Iriə tukhapɨk ta kafak neipən mɨsəwhai irəriə mɨnə. Kɨni mɨsarukɨn daes tukun.” Ror məkneikɨn, mobael mɨnə kɨmɨsor əfrakɨs məknakɨn. ");
INSERT INTO nwi_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Kɨni nɨpiraovɨn kuas kɨmnasərer ipakə tuk nai kamarkwao kɨn kape Yesu. Iriə e: Mamə kape Yesu, mɨne piauni, mɨne Meri kɨrik mɨn, yame in piraovɨn kape Kleopas, mɨne Meri pɨsɨn kɨrik, yame in pian Magdala. ");
INSERT INTO nwi_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kɨni Yesu rarha-pən məm kafan mamə, mɨne yermamə kɨrik kafan yame in rorkeikei pɨk, kawərer ipakə tukun, kɨni rɨni-pən tuk kafan mamə mə, “Pian əpə, kafam en kwajikovə.” ");
INSERT INTO nwi_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Mɨni-pən tuk kwən a mɨmə, “Kafam en mamə.” Kɨni rɨrikakun ye nɨpɨg a, yermamə a kape Yesu raməm huvə pian a rəmhen kɨn mamə atuatuk kafan. ");
INSERT INTO nwi_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kɨni kwasɨg ikɨn ye narɨmnar mɨnə a, Yesu ruɨrkun mə In rɨnərkin wok yame rɨmauə tukun mə tukror. Kɨni mɨmə “Yaknəkwakwə.” Rɨmɨni məkneikɨn mə tukror nəgkiarien kɨrik ye Nəkwəkwə kape Kughen tukruə mor nəfrakɨsien kɨn. ");
INSERT INTO nwi_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kɨni kwaji besin kɨrik aikɨn ramkwətə, kwəvi-pən ta waen əkwahir iran. Kɨni iriə kharəh neipən kɨrik, mɨseires waen kɨn, mɨsarkɨs-pən ye nai kɨrik kamni kɨmə ‘hisop’ mhavəh-si haktə mhavəhsi-pən ipakə tuk tɨkinher Yesu, mə tukrɨnɨm. ");
INSERT INTO nwi_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kɨni rəpaih əsɨgəvɨn waen, mɨni mɨmə, “Rɨnor infamien.” Kɨni rɨvaag-əhu, meighan-pən kɨn nɨmraghien kafan, kɨni mɨmhə. ");
INSERT INTO nwi_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ruauə ye nɨpɨg kape napnəpenəyen, tukəni rɨkwamɨrkɨn, Sabat. (Sabat a in nɨpɨg ehuə kɨrik). Kɨni nəmehuə kape nəmə Isrel kɨmnhapəh nɨsorkeikeiyen mə nɨprai yermamə tukraməker ye nai kamarkwao kɨn meriaji-pən Sabat. Ror pən, iriə tɨksɨn kɨmnhavən mɨsaiyoh Paelat mhamə tukrher-pən kɨn mobael mɨnə khavən mɨshoprɨr-hoprɨr nɨhurisɨr, pəh irisɨr tukrhɨmhə aihuaa əmə. Kɨni nəmə Isrel tukharəh-si ta nɨprairisɨr ye nai kamarkwao kɨn. ");
INSERT INTO nwi_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kɨni mobael mɨnə kɨmɨsəkupən mɨshoprɨr-hoprɨr nɨhu yermamə mir e kawəker ipakə tuk Yesu. ");
INSERT INTO nwi_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Mhauə ipakə tuk Yesu, mɨsəm mə In ruamhə ta, mhapəh nɨshoprɨrien nɨhun. ");
INSERT INTO nwi_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Mərɨg iriə kɨrik rɨmnhai əmə nɨkarɨn kɨn kwenhao. Ǝmə aikɨn, nɨtawɨn mɨne nunu iran, iriu kwis kɨmɨwaiyu mɨratərhav ye nɨkarɨn. ");
INSERT INTO nwi_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Kɨni kwən kɨrik rɨnamərer ipakə tukun, məm narɨmnar mɨnə e kɨn nɨmrɨn. Kɨni mamni-ərhav nəgkiarien yamə mɨne raməfrakɨs. Mamrai-pən ye nəkwəkwə e mə kɨmiə mɨn takhani nəfrakɨsien iran). ");
INSERT INTO nwi_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Narɨmnar mɨnə e kɨmnhatərhav-pə mɨsor nəgkiarien kɨrik ye Nəkwəkwə kape Kughen ruauə mor nəfrakɨsien kɨn, yame ramni mə, “To iriə khapəh nɨshopɨr-pɨrien nɨkəkrin kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kɨni nəgkiarien kɨrik mɨn ye Nəkwəkwə kape Kughen ramni mə, “Iriə tuksarha-pən mɨsəm yermamə yame kɨmɨshai.” ");
INSERT INTO nwi_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kɨni ai, yemə Aramatia kɨrik, nhagɨn e Josef, in yermamə kɨrik kape Yesu. Mərɨg ramerkwaig kɨn mə tukpəh nɨrkunien mə in yermamə kafan, meinai ramgɨn kɨn nəmehuə kape nəmə Isrel. Kɨni in rɨmavən məm Paelat, maiyoh in mə tukreighaan kɨn nɨprai Yesu. Kɨni Paelat reighan kɨn, kɨni Josef rɨvən mɨrəhsi-əhu. ");
INSERT INTO nwi_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Kɨni Nikodimas e kupan rɨmavən yenpɨg məm Yesu, in rɨkwasɨg kɨn Josef. Mamrur nɨtɨp kɨrik rukwar kɨn monar pien pien mir e ‘mir’ mɨne ‘alos.’ Nɨtɨp a rɨpam rəmhen kɨn toti fo kilo. ");
INSERT INTO nwi_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kɨni iriu kɨrərəhsi-ta nɨprai Yesu, mɨrəuvrɨg kɨn neipən kɨrik e ‘linen.’ Kɨni mɨwor-pən monar pien pien ye nɨpran, raməri-pən əmə norien kape nəmə Isrel tuk nɨnɨmien yermamə. ");
INSERT INTO nwi_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kɨni ikɨn a kɨmɨruk haktə Yesu ikɨn, ipakə tuk nəsimien kɨrik. Ye kwənmhaan a, kɨmnəpnəpeinə ta ye nɨpəg kapier tuk nɨnɨmien yermamə, mərɨg kɨpəh hanə nɨnɨm-pənien yermamə kɨrik aikɨn. ");
INSERT INTO nwi_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Meinai tukəni rɨkwamer kɨn, Sabat kape nəmə Isrel, Josef mɨne Nikodimas kwhai mɨren nar, mɨrəmə tukrɨnɨm aihuaa əmə. Kɨni nɨpəg kapier a yame kamnɨm yermamə ikɨn ipakə əmə. Ror pən, iriu kwərəhu-pən nɨprai Yesu aikɨn. ");
INSERT INTO nwi_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ye Sande, yenpɨg-enpɨg əgkap, rampɨgpɨg hanə, Meri e pian Magdala rɨmavən ye nəpag kapier, kɨn məm mə kapier ehuə yame kɨmukrai əswasɨg-pən nɨpəg kapier kɨn, kɨnəsok ta kɨn. ");
INSERT INTO nwi_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Məkneikɨn, raiyu, mɨrerɨg mɨvən tuk Saemon Pita mɨne yermamə mɨn kɨrik kape Yesu, yame Yesu rorkeikei pɨk in. Kɨni mɨni-pən tuk əriu mɨmə, “Yermamə kɨrik ruɨrəhsi-ərhav nɨprai Yesu Yermaru ye nɨpəg kapier. Kɨni yakeinein mə rɨmnərəhu hiə nɨpran.” ");
INSERT INTO nwi_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kɨni Pita mɨne yermamə kɨrik mɨn kape Yesu, kɨmɨratərhav mɨravən mə tukwəm nəpag kapier. ");
INSERT INTO nwi_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kɨmɨwaiyu pɨk mɨravən, mərɨg kwərə mir a kɨrik rɨmnaiyu məkupan mapitan kɨn Pita, mɨvən ye nəpag kapier. ");
INSERT INTO nwi_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kɨni mamrəmɨr, mɨvaag-pən imə, məm neipən huvə mɨnə e kamni kɨmə ‘linen,’ yame kɨmuvrɨg Yesu kɨn kəkupən ramswiin. Mərɨg rɨpəh nɨvənien imə. ");
INSERT INTO nwi_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kɨni Saemon Pita rarə muə mɨn, kɨni mauru-pən apa ye nɨpəg kapier, məm neipən mɨnə a ramswiin. ");
INSERT INTO nwi_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Kɨni məm mɨn neipən yame kɨmuvrɨg kapən kapə Yesu kɨn kupan. Neipən a, rɨpəh nəmɨr-pənien tuk neipən tɨksɨn yame kɨmuvrɨg Yesu kɨn; mərɨg kɨmnarpəvɨn-arpəvɨn huvə, kukrai-pən ikɨ-pɨsɨn. ");
INSERT INTO nwi_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kɨni ai yermamə kape Yesu yame rɨmnaiyu məkupan ye Pita, in mɨn rɨmnauru-pən ye nɨpəg kapier, məm narɨmnar mɨnə a, mamni nəfrakɨsien mə Yesu rɨmɨmragh mɨn ye nɨmhəyen. ");
INSERT INTO nwi_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Ye nɨpɨg a, iriu kɨrapəh nɨrarkun-hanə-yen nɨprai nəgkiarien ye Nəkwəkwə kape Kughen yame ramni mə Yesu tukraməkeikei mamragh mɨn ye nɨmhəyen). ");
INSERT INTO nwi_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kɨni yermamə mir e kape Yesu kɨmɨrarerɨg mɨravən iməriu ikɨn, ");
INSERT INTO nwi_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","mərɨg Meri in rɨmnərer ipakə tuk nɨpəg kapier mamasək. Mamasək əmə məkneikɨn, məmrəmɨr, mɨvaag-pən ye nəpag kapier, ");
INSERT INTO nwi_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","məm agelo mir kɨraru apa imə. Neipən kapəriu rhawən pɨk. Iriu kaokwətə aikɨn kɨmnərəhu-pən nɨprai Yesu ikɨn. Kɨrik ramkwətə-pən a kɨmɨrəhu kapən kapə rɨvən pən ikɨn; kɨni kɨrik ramkwətə-pən a kɨmnərəhu nɨhun rɨvən pən ikɨn. ");
INSERT INTO nwi_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Kɨni iriu kwaiyoh Meri mɨrəmə, “Pian əpə. ?Nakamasək tuk naha?” Kɨni in rɨni-pən tuk əriu mɨmə, “Kwərəhsi-ta nɨprai Yermaru kafak, kɨni yakneinein mə kɨmɨrəhu-pən hiə.” ");
INSERT INTO nwi_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ruɨni-ta nəgkiarien a, marar, marha-pən məm Yesu ramərer aikɨn. Mərɨg in rɨpəh nɨrkunien mə Yesu. ");
INSERT INTO nwi_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Kɨni Yesu raiyoh in mɨmə, “Pian əpə. ?Nakamasək tuk naha? ?Nakamarha-kɨn pa?” Mərɨg Meri, rɨkin raməsɨk mə ta mə yəsim kɨrik, rɨni-pən tukun mɨmə, “Yemehuə. Tukmə ik nɨmɨrəh nɨpran, mərəhu ikɨn pukaa, hajoun kɨn yo pəh yakvən mɨrəh.” ");
INSERT INTO nwi_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Kɨni Yesu rɨni-pən tukun mə, “Meri.” Məkneikɨn Meri rarha-pən, məm, mokrən apomh mɨmə, “Raboni.” (Ye nəgkiarien kape nəmə Isrel, nɨpran rɨmə, “Yhajoun kafak”). ");
INSERT INTO nwi_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Kɨni Yesu rɨni-pən tukun mə, “Takpəh nɨrapien Yo, meinai yakpəh hanə nɨvənien tuk kafak Tatə Kughen. Mərɨg ik, yuvən, məm naorahik mɨnə mɨni-əsahpən tuk əriə mə Yo yaknamrerɨg-pən apa ye rao ye neai tuk kafak Tatə, kɨni In mɨn kapəmiə Tatə. In Kughen kafak, kɨni In mɨn kapəmiə Kughen.” ");
INSERT INTO nwi_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kɨni Meri pian Magdala rɨmavən məm narmamə kape Yesu mɨnə, mɨni-pən tuk əriə mɨmə, “!Nəmə mɨnə əpə! Yɨmnəm Yermaru.” Kɨni məvsao kɨn naha nhagɨn yame Yesu rɨmɨni-pən tukun. ");
INSERT INTO nwi_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ye Sande, yenaiyu, narmamə kape Yesu mɨnə kɨmɨsofugɨn əriə mɨnə apa ye nimə kɨrik, kɨni mɨsətapɨg tɨm tɨm, meinai kɨmnhagɨn kɨn nəmehuə mɨnə kape nəmə Isrel. Məkneikɨn, Yesu rɨmauə mərer ye kwerkwan irəriə, kɨni mɨni-pən tuk əriə mə, “Nəmərinuyen tukramarə tuk əmiə.” ");
INSERT INTO nwi_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kɨni mhajoun kwermɨn kɨn əriə, mɨne nɨkarɨn. Kɨmɨsəm Yesu Yermaru, rɨkiriə ragien pɨk. ");
INSERT INTO nwi_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kɨni Yesu rɨni-pən mɨn tuk əriə mə, “Nəmərinuyen tukramarə tuk əmiə. Kafak Tata rɨmnher-pə kɨn Yo, kɨni ye norien kɨrikianə əmə mɨn, Yo yakamher-ərhav kɨn əmiə mə takhatərav mhavən ikɨn mɨnə ye tanɨmtanə.” ");
INSERT INTO nwi_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Rɨmɨni ta nəgkiarien e, mher əpu əriə, mɨmə, “Havəh Nanmɨn kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Tukmə nakharɨsɨn narmamə tuk təvhagə has kapəriə, Kughen mɨn tukrɨvəh-si ta narpɨnien kapəriə. Kɨni tukmə nakhapəh nharɨsɨnien narmamə tuk təvhagə has kapəriə, Kughen tukrɨpəh nɨvəhsi-tayen narpɨnien kapəriə.” ");
INSERT INTO nwi_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Kɨni yermamə kɨrik ye narmamə twelef kape Yesu, nhagɨn e Tomas. Kamokrən kɨn in kɨmə Didimas. In rɨmɨrkək yenɨpɨg Yesu rɨmatərhav-pə tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kɨni in mɨnə tɨksɨn kɨmnhani-pən tukun mhamə, “Eh. Yɨmɨsəm Yesu Yermaru.” Mərɨg Tomas rɨni-pən tuk əriə mə, “Tukmə yakəm tamhek nil kɨn nɨmrɨk mɨrap, kɨni mɨrap tamhek kwenhao ye nɨkarɨn, mɨpini nəfrakɨsien iran. Mərɨg tukmə yakpəh nəmien, to yakpəh nɨniyen nəfrakɨsien iran.” ");
INSERT INTO nwi_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kɨni nəhuakien kɨrikianə ruə mɨvən, narmamə kape Yesu mɨnə kɨmnasəkwətə kwis iriə Tomas ye nəkwai nimə kɨrik. Mɨsətapɨg tɨm tɨm pawk, mərɨg Yesu rɨtərhav-pə mərer ye kwerkwan irəriə mɨmə, “Nəmərinuyen tukramarə tuk əmiə.” ");
INSERT INTO nwi_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kɨni mɨni-pən tuk Tomas mɨmə, “Yuə mɨrap tamhek nil ye kwermɨk. Mɨrap tamhek kwenhao ye nɨkarɨk kɨn kwermɨm. Ni əmə nəfrakɨsien irak. Nərɨgien kafam tukrɨpəh norien kɨraru.” ");
INSERT INTO nwi_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Kɨni Tomas rɨni-pən tukun mə, “Ik kafak Yermaru, mɨne Ik kafak Kughen.” ");
INSERT INTO nwi_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kɨni Yesu rɨni-pən tukun mə, “Ik nɨmɨni nəfrakɨsien irak meinai ik nɨmnəm Yo. Mərɨg yamə mɨne khapəh nɨsəmien Yo, mamhani nəfrakɨsien irak, iriə tukasarə ye nɨhuvəyen əfrakɨs.” ");
INSERT INTO nwi_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu rɨmnor nɨmtətien mɨnə rɨpsaah ye nɨmrɨ kafan narmamə, yame kɨmnəpəh nɨraiyen ye nəkwəkwə e. ");
INSERT INTO nwi_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Mərɨg kɨmɨrai narɨmnar ye nəkwəkwə e mə kɨmiə takhani nəfrakɨsien mə Yesu in Kristo, mɨne in Ji Kughen. Kɨmɨrai nəkwəkwə e mə kɨmiə takhani nəfrakɨsien iran, mamhavəh nɨmraghien rerɨn. ");
INSERT INTO nwi_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kwasɨg ikɨn ye narɨmnar mɨnə e, Yesu rɨtərhav-pə mɨn tuk kafan narmamə mɨnə apa ye nɨkar-kar tahik apa Lugun Galili. Kɨni mamor əpu In. ");
INSERT INTO nwi_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ye nɨpɨg a, narmamə mɨnə kape Yesu kɨmnasəriwək kɨrikianə. Saemon Pita, mɨne Tomas e kamokrən kɨn kɨmə Didimas, mɨne Nataniel e yemə Galili, rukwanu kafan kamni kɨmə Kena, mɨne ji Sebedi mir, mɨne yermamə mir kɨraru mɨn kape Yesu. ");
INSERT INTO nwi_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saemon Pita rɨni-pən tuk əriə mə, “Yo yakamvən jakaruk kɨn net.” Kɨni khamə, “Inta. Pəh kɨtawə khavən.” Kɨni iriə fam kɨmɨsəsok pirə ye bot kɨrik. Mɨsaruk kɨn net a mɨseriaji reraan. Mərɨg khapəh nhaviyen kəmam kɨrik. ");
INSERT INTO nwi_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kɨni rɨnamraan, Yesu ruə mamərer i-fiak; mərɨg kafan narmamə mɨnə khapəh nharkunien mə Yesu. ");
INSERT INTO nwi_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Kɨni In raiyoh əriə mə, “Ah. ?Nakhavi kəmam kɨrik, uə?” Mərɨg iriə khamə, “Nɨkam. Kəmam rɨkək.” ");
INSERT INTO nwi_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kɨni In rɨni-pən mɨn tuk əriə mɨmə, “Intə. Sarko-pən ru kɨn net e ye matuk, mhavi kəmam tɨksɨn.” Məkneikɨn, kɨsarko-pən kɨn net, mhapɨk kəmam rɨpsaah, rɨpsaah, to khapəh nhavi-haktəyen net. ");
INSERT INTO nwi_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kɨni yermamə yame Yesu rorkeikei pɨk in, rɨni-pən tuk Pita mɨmə, “Eh. Yermamə e in en, Yesu Yermaru.” Pita rərɨg nəgkiarien a, mətəut aihuaa əmə, (meinai ye nɨpɨg a rɨmnamaiyu kopiə kopiə) meiwaiyu ye bot, meiai məsok fiak. ");
INSERT INTO nwi_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Kɨni narmamə kape Yesu mɨnə kɨmnhavi fiak bot, mɨsəukəkin fiak net yame rukwar kɨn kəmam, meinai bot ramərer ipakə əmə tuk nɨməkrəkɨr, rəmhen kɨn wan handred meta. ");
INSERT INTO nwi_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kɨni mɨsəsok fiak mɨsəm kher nap, kɨni kwənəmtarhe nap ramuək. Kɨni mɨsəm kɨmnəpir kəmam kɨrik. Kɨni bred mɨn apaikɨn. ");
INSERT INTO nwi_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “Hapɨk kəmam tɨksɨn yamə mɨne nɨmnhavi, mhapɨk mhauə.” ");
INSERT INTO nwi_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kɨni Saemon Pita rɨmavən ye bot, kɨni məukəkin net məsok fiak. Net a rukwar kɨn kəmam ehuə mɨnə, iriə m-fam wan handred fifti tri. Net a rukwar pawk kɨn kəmam, mərɨg rɨmɨpəh neikus-eikusien. ");
INSERT INTO nwi_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Kɨni Yesu rɨni-pən tuk əriə mɨmə, “Hauə, pəh kɨsəvɨgɨn kwis.” Kɨni iriə kɨrik rɨkin rɨpəh nəsɨkien mə tukraiyoh In mə, “?Ik pa?” meinai iriə m-fam kwənharkun ta mə In Yesu Yermaru. ");
INSERT INTO nwi_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Kɨni Yesu rɨmɨvəh bred mɨvəh-si-pən kɨmi əriə, mɨvəh-si pən mɨn kəmam. ");
INSERT INTO nwi_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nɨpɨg Yesu rɨmamhə mamragh mɨn, kɨni in a nɨpɨg yame ror kɨsisər kɨn yame In rɨmatərhav-pə tuk kafan narmamə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kɨmɨsəvɨgɨn ta, kɨni Yesu raiyoh Saemon Pita mɨmə, “Saemon, ji Jon. ?Norkeikeiyen kafam tuk Yo rapita norkeikeiyen kape narmamə mɨnə tɨksɨn, uə?” Kɨni Pita rɨni-pən tukun mɨmə, “Ǝwəh. Yermaru, Ik nakwɨrkun ta mə yakorkeikei pɨk Ik.” Kɨni Yesu rɨni-pən tukun mɨmə, “Inta. Ik takaməvɨgɨn kwaji sipsip mɨnə kafak.” ");
INSERT INTO nwi_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kɨni marar maiyoh mɨn in mɨmə, “Saemon, ji Jon. ?Nakorkeikei Yo?” Kɨni in rɨni-pən tuk Yesu mɨmə, “Ǝwəh Yermaru. Ik nakɨrkun mə yakorkeikei pɨk Ik.” Kɨni Yesu rɨni-pən tukun mɨmə, “Inta. Takamarha huvə tuk kafak sipsip mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kɨni marar maiyoh mɨn yame ror kɨsisər kɨn mɨmə, “Saemon, ji Jon. ?Ik nakorkeikei Yo?” Kɨni Pita, rɨkin rəmhə, meinai Yesu rɨmnaiyoh in m-kɨsisər mɨmə, “?Ik nakorkeikei Yo?” Kɨni rɨni-pən tukun mɨmə, “Yermaru. Ik nakɨrkun narɨmnar m-fam. Ik nakɨrkun mə yo yakorkeikei ik.” Kɨni Yesu rɨni-pən tukun mɨmə, “Ita. Ik takaməvɨgɨn kafak sipsip mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kɨni Yesu rɨrpɨn nəgkiarien mɨni-pən tuk Pita mɨmə, “Yakamni-pre əfrakɨs tuk ik mə, apa kupan, nɨpɨg nɨmnamatamaruə, nɨmɨvəhsi-pən atuk kafam neipən, mameriwək, mamvən aikɨn mɨnə fam yame ik nakorkeikei mə takvən ikɨn. Mərɨg tukmə naknəhuaru, takhuatuk kɨn kwermɨm, kɨni yarmə kɨrik tukrɨvəhsi-pre atuə kɨn kafam neipən, kɨni mɨkɨr ik nakravən aikɨn ik nakpəh norkeikeiyen mə takvən ikɨn.” ");
INSERT INTO nwi_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Nəgkiarien e Yesu rɨmnəkupan mamni-ərhav nɨmhəyen kape Pita, kɨni kafan nɨmhəyen in tukrɨvəh-si haktə nhag Kughen. Kɨni Yesu rɨmnarar mɨni-pən tukun mə, “Ita, kwasɨg kɨn Yo.” ");
INSERT INTO nwi_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Kwəriwək mɨravən, kɨni Pita rarar marha-pən məm yermamə kɨrik kape Yesu, yame Yesu rorkeikei pɨk, ramkwasɨg kɨn əriu. (Kwən a in a, yame apa kupan, ye nɨpɨg kape Pasova, rɨmneiwaiyu mɨni-pən tuk Yesu mɨmə, “Yermaru. ?Pa nhagɨn tukreighaan-pən kɨn Ik ye kwermɨ tɨkmɨr mɨnə kafam?”) ");
INSERT INTO nwi_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nɨpɨg Pita rɨmnəm yermamə e kape Yesu, kɨni raiyoh Yesu mɨmə, “Yermaru. ?Rhawor ye kwən e?” ");
INSERT INTO nwi_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Kɨni Yesu rɨmɨni-pən tukun mə, “Tukmə Yo yakorkeikei mə in tukramragh əmə mamrɨrpɨn meriaji jakrerɨg-pə mɨn, ik to nakpəh nətərɨg-pɨkien tukun. Mərɨg ik, takaməkeikei mɨkwasɨg kɨn Yo.” ");
INSERT INTO nwi_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yesu rɨmɨni-pən məknakɨn tuk Pita, kɨni nəvsaoyen kɨrik rəvirh-əvirh ye nəməhuak mɨnə mə yermamə a kape Yesu tukrɨpəh nɨmhəyen. Mərɨg pəh nien mə Yesu rɨmɨni mə tukrɨpəh nɨmhəyen. Rɨmɨni-pən əmə tuk Pita mɨmə, “Tukmə Yo yakorkeikei mə in tukramragh əmə mamrɨrpɨn meriaji jakrerɨg-pə mɨn, ik to nakpəh nətərɨg-pɨkien tukun.” ");
INSERT INTO nwi_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yermamə e kape Yesu, in yermamə kɨrikianə əmə yame ramni-ərhav narɨmnar mɨnə e, kɨni mɨrai-pən narɨmnar mɨnə e ye nəkwəkwə e. Kɨni kɨtawə kharkun mə nəgkiarien mɨnə e kasəfrakɨs. ");
INSERT INTO nwi_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kɨni Yesu rɨmnor narɨmnar rɨpsaah mɨn. Tukmə narmamə khamə tukharai fam narɨmnar yame In rɨmnor, nəgkiarien rɨpsaah, tukreriaji nəkwəkwə rɨpsaah rɨpsaah rɨpsaah. Kwənmhan ye tokrei tanə e to rɨpəh nəmhenien tuk nətu-pənien nəkwəkwə mɨnə e aikɨn. ");
INSERT INTO nwi_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofilas, kafak yermamə, yɨmnəvsao ta kɨn Yesu ye nəkwəkwə yame yɨmɨrai ta. Yɨmnəvsao kɨn nəwhagien mɨne norien kafan ");
INSERT INTO nwi_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","muə meriaji-pə Kughen rɨvəh In mɨvən apa ye neai. Kwasɨg ikɨn rɨvən apa ye neai, Nanmɨn Rhakə rɨmavən iran, In rɨwəhsi-pən nəgkiarien infamien kɨmi kafan aposol mɨnə yame In rɨmɨrpen ta əriə. ");
INSERT INTO nwi_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kɨni mərɨg, nɨpɨg kɨmoh Yesu khopni, kɨni ai rɨmɨmragh mɨn ye nɨmhəyen kafan, kɨni marə mɨn iriə kafan narmamə mɨnə meriaji nɨpɨg foti. Nɨpɨg a, rɨmnərer ye nɨmrɨriə nɨpɨg rɨpsaah mamor əpu In mə tukharkun mə rɨmamragh əfrakɨs ye nɨmhəyen kafan. Iriə kɨsəm In, In raməvsao kɨn narmaruyen kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nɨpɨg ramarə hanə iriə min, In rɨvəhsi-pən nəgkiarien kɨrik kɨmi əriə mɨmə, “Takhapəh nɨsətayen taon e Jerusalem. Masəmɨr mamawhin Nanmɨn Rhakə yame Rɨmɨk rɨmɨrpen mə tukrɨvəhsi-pre kɨmi əmiə, rəmhen kɨn yame Yo mɨn yɨmnəvsao ta kɨn kɨmi əmiə. ");
INSERT INTO nwi_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Mərɨg in ai kupən, Jon Baptaes rɨmnor baptaes irəmiə kɨn nu, kɨni rɨpəh norien tu, Kughen tukror baptaes irəmiə kɨn Nanmɨn Rhakə.” ");
INSERT INTO nwi_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ye nɨpɨg a, aposol mɨnə kɨmnhauə kɨrikianə iriə Yesu, mɨsaiyoh In mhamə, “Yermaru. ?Rɨnor nɨpɨg ai taktəkun mə Ik takor ətawə tuksarmaru ye tanə kapətawə e Isrel, uə nɨkam?” ");
INSERT INTO nwi_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Kɨni Yesu rɨmɨni-pən tuk əriə mə, “Rɨmɨk pɨsɨn əmə In ravəh nehuəyen tuk nərəhuyen nɨpɨg mɨnə a. Mamerkwaig kɨn tuk əmiə, mor əmiə mə takhapəh nharkunien. ");
INSERT INTO nwi_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kɨni mərɨg nɨpɨg Nanmɨn Rhakə tukruə irəmiə, takhavəh nəsanɨnien, mhani-ərhav nhagɨk e Jerusalem, mhavən yerkwanu mɨnə fam ye Judia mɨne Sameria, mhavən yerkwanu mɨnə fam ye tanɨmtanə.” ");
INSERT INTO nwi_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesu ruɨni ta, nɨpɨg iriə kɨsarha-pən hanə masəm In, Kughen rɨvəhsi ta In kɨni mɨvəh in mhaktə mamvən ye neai. Aikɨn, napuə ruvrɨg əpɨs In. ");
INSERT INTO nwi_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kasarha-əterɨk ye napuə, məkneikɨn, mɨsəm yermamə mir kɨraru neipən kapəriu rhawən kɨrauə mawərer iriə miriə. ");
INSERT INTO nwi_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Marəni mɨrəmə, “Nəmə Galili. ?Rhawor nakasərer məkneikɨn masarha faktə ye napuə? Yesu e, Kughen rɨvəhsi-ta In, mɨvəh In muavən ye rao ye neai. In tukrɨrerɨg-pə mɨn rəmhen əmə kɨn yame In rɨmnhaktə ai taktəkun.” ");
INSERT INTO nwi_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Aposol mɨnə kɨsəta ye takwar Olif, mɨsəriwək kəskəh əmə, mharerɨg mɨn mhavən Jerusalem. ");
INSERT INTO nwi_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Mhavən Jerusalem, kɨni mɨsauru-pən ye nimə kɨrik mɨshaktə mhavən ye kwənmhaan kɨrik yame kɨmnasəmɨr ikɨn kupən. Narɨmnə a: Pita, mɨnə Jon, mɨne Jemes, mɨne Andru, mɨne Filip, mɨne Tomas, mɨne Batalomiu, mɨne Matiu, mɨne Jemes, kwajikovə kape Alfeas, mɨne Saemon Selot, mɨne Judas, kwajikovə kape Jemes. ");
INSERT INTO nwi_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Iriə nɨpiraovɨn tɨksɨn mɨne Meri, nɨsɨn Yesu, mɨne naorahi Yesu mɨnə tɨksɨn, iriə kasofugɨn iriə miriə. Rɨkiriə kɨrikianə əmə. Nɨpɨg mɨnə fam, kasəhuak. ");
INSERT INTO nwi_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nɨpɨg tɨksɨn ruauə muavən, narmamə yamə mɨne kɨshatətə ye Yesu kɨmnhauə kɨrikianə. Iriə khapsaah kɨsəmhen kɨn 120. Aikɨn, Pita rərer maməgkiar kɨmi əriə, mamni mɨmə, ");
INSERT INTO nwi_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Kafak narmamə mɨnə, nəgkiarien kape Kughen tukraməkeikei muə mor nəfrakɨsien kɨn. Apa kupən, Nanmɨn kape Kughen rɨmɨvəhsi-pən nəgkiarien kɨmi King Deved. King a rɨmɨrkun məkupən mɨni-ərhav mə kwən e Judas tukrɨkɨr narmamə mhavən kharaptərəkɨn Yesu. Kɨni nəgkiarien e ruauə ai taktəkun mɨnor nəfrakɨsien kɨn. ");
INSERT INTO nwi_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Apa kupən, Judas in kɨtawə kɨrik; mamor wok kape Kughen kɨtawə min. ");
INSERT INTO nwi_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Mərɨg rɨmnarar meighan-pən kɨn Yesu, mɨvəh mane iran, kɨni en mɨvən mɨvəh nɨmrɨ nɨmoptanə kɨrik kɨn. Ikɨn aikɨn a, in rɨməviə məwhan əteih tɨpɨn nɨsinavɨn rɨtərhav. ");
INSERT INTO nwi_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kɨni nəmə Jerusalem kɨsərɨg nar a, kɨshen-pən nhag nɨmoptanə a mhamə, ‘Akeldama.’ Ye nəgkiarien kapəriə nɨpran ramni mɨmə ‘Nɨtə.’” ");
INSERT INTO nwi_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kɨni Pita rɨmɨni mɨn mə, “Ye Ol Sam nəgkiarien kɨrik ramni mɨmə, “‘Pəh kwənmhaan kafan tukraməmɨr apnapɨg əmə; Pəh yermamə kɨrik tukrɨpəh nəmɨrien aikɨn.’ “Kɨni nəgkiarien kɨrik mɨn ramni məkneikɨn mɨmə, “‘Pəh yarmə kɨrik tukruə mɨvəh tamhekɨn mɨvəh nehuəyen.’” ");
INSERT INTO nwi_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Kɨni Pita rɨni mɨrpɨn mɨn mɨmə, “Ror məkneikɨn mə tukasəkeikei mhavəh-si haktə yermamə mɨn kɨrik yame rɨmnəm kɨn nɨmrɨn mə Yesu Yermaru rɨmamragh mɨn ye nɨmhəyen kafan mə tukrɨni-ərhav mə Yesu In rɨmnərer mɨn ye nɨmhəyen kafan. Yermamə a in yermamə kɨrik yame rɨmnaməriwək kɨmawə min kupən, ye nɨpɨg yame Yesu rɨmnaməriwək kɨmawə min. In rɨmnəm norien mɨnə a rɨrikakun ye nɨpɨg Jon Baptaes rɨmnamni-ərhav nəgkiarien, muə meriaji-pə nɨpɨg yame Kughen rɨmɨvəhsi-ta Yesu tuk ətawə, mɨvəh In mhaktə.” ");
INSERT INTO nwi_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kɨni iriə khani-ərhav nhag yermamə kɨraru. Kɨrik, nhagɨn e Josef, kamni kɨmə Basabas, kɨni kamni mɨn kɨmə Jastas. Kɨrik mɨn nhagɨn e Matias. ");
INSERT INTO nwi_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Kɨni iriə mɨsəhuak mhani mhamə, “Kughen, Ik nakɨrkun rɨkimawə fam. Ik takasitu irəmawə mɨni mə pa e nhagɨn yermamə mir e Ik nɨmɨrpen ta kɨrik ");
INSERT INTO nwi_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","mə in tɨkrɨvəh neihuəyen kape aposol yame Judas in rɨmnəpəh məri-pən swatuk ahas- in a kwənmhaan atuatuk kafan.” ");
INSERT INTO nwi_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kɨni kɨmɨsəhuak ta, mharai-pən nhagriu ye kapier kɨraru mhawhan, mhamə tukharkun mə pa tukrɨvəh neihuəyen a “aposol.” Kɨni nhag Matias rukreikɨn. Kɨni iriə kɨmnhavəhsi-haktə Matias rəmhen kɨn aposol. Kɨni taktəkun ai rɨnor mɨn aposol iriə fam twelef. ");
INSERT INTO nwi_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kɨni ai, ye nɨpɨg kape nəvɨgɨnien ehuə kɨrik kamni kɨmə Pentekos, narmamə yamə mɨne kɨshatətə ye Yesu kɨmnhauə kɨrikianə. ");
INSERT INTO nwi_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Məkneikɨn, kɨsərɨg nar kɨrik rɨmasɨ-pən ye napuə rəmhen kɨn nɨmətag ramavən mɨvən apa imə a kasəmɨr ikɨn. ");
INSERT INTO nwi_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Aikɨn, iriə kɨsəm nar kɨrik rəmhen kɨn nap raməsiə, məwhai neram nap reiwaiyu irəriə m-fam. ");
INSERT INTO nwi_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Iriə m-fam, Nanmɨn kape Kughen rukwar irəriə. Kɨni mɨvəhsi-pən nɨrkunien kɨmi əriə kasəgkiar ye nəgkiarien ye tanə pɨsɨn pɨsɨn. ");
INSERT INTO nwi_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kɨni ye nɨpɨg a, nəmə Isrel tɨksɨn yame kamhasiai Kughen kɨmnhasɨ-pən ikɨn mɨnə fam ye tokrei tanə, mhauə mɨsofugɨn e Jerusalem. ");
INSERT INTO nwi_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nɨpɨg kɨmɨsərɨg əriə kasəgkiar ye nəgkiarien ye tanə pɨsɨn pɨsɨn, narmamə khapsaah khauə mɨsəm kɨsakur meinai narmamə mɨnə fam kasərɨg kamhani nəgkiarien atuatuk kapəriə. ");
INSERT INTO nwi_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kɨsakur pɨk kɨn nar a mhamə, “!Eh! Narmamə yamə mɨne kasəgkiar məkneikɨn, mərɨg iriə nəmə Galili əmə. ");
INSERT INTO nwi_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","?Rhawor e kɨtawə m-fam kɨsərɨg kasəgkiar ye nəgkiarien pɨsɨn pɨsɨn kapətawə? ");
INSERT INTO nwi_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kɨtawə narmamə ikɨn pɨsɨn pɨsɨn. Ikɨn e taktəkun narmamə Patia, mɨne narmamə Media, mɨne narmamə Elam, mɨne narmamə Mesopotemia, mɨne nəmə Judia, mɨne nəmə Kapadosia, mɨne nəmə Pontas, mɨne nəmə Tarki, ");
INSERT INTO nwi_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","mɨne nəmə Frijia, mɨne nəmə Pamfilia, mɨne nəmə Ijip, mɨne nəmə Libia ipakə tuk Saerin, mɨnə nəmə Rom ");
INSERT INTO nwi_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(yame iriə tɨksɨn nəmə Isrel atuatuk, kɨni tɨksɨn kɨmnhasɨ-pən ye tanɨmtanə mɨnə mɨsəpəh narəyen kape nar iməriə ikɨn, mhauə mɨsəhuak kɨmi Kughen); mɨne nəmə Krit, mɨne nəmə Arebia. !Mərɨg kɨtawə m-fam kɨmɨsərɨg əriə kasəgkiar ye nəgkiarien mɨnə fam kapətawə mamhani norien ehuə mɨnə yame Kughen ramor kɨmi ətawə!” ");
INSERT INTO nwi_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Iriə kɨmɨsərɨg kɨsakur pɨk kɨn rukrekɨn kapəriə kapə mɨsaiyoh əriə mɨnə kɨn nɨpran. ");
INSERT INTO nwi_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mərɨg narmamə tɨksɨn kɨsarh irəriə mhamə, “Nɨkam. ?Kɨsapɨs kɨn waen uə?” ");
INSERT INTO nwi_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Aikɨn, Pita rɨmnərer iriə aposol mɨnə, iriə fam leven. In mokrən ehuə mɨni-pən tuk narmamə mɨnə mɨmə, “Nəmə Isrel, mɨne kɨmiə mɨnə fam yamə mɨne nakasarə e Jerusalem, taksətərɨg huvə kɨn yo. Pəh yakhoprai-pre norien mɨnə e kɨmi əmiə. ");
INSERT INTO nwi_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Narmamə mɨnə a khapəh nɨsapɨsien kɨn waen, rəmhen kɨn yame kɨmiə nakamhani. Ramraan əmə- pəh nien mə nɨpɨg kape nɨnɨmien waen. ");
INSERT INTO nwi_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nar yame nakasəm ai taktəkun rəmhen əmə kɨn yame profet kape Kughen, nhagɨn e Joel, rɨmɨni ta kupən mɨmə, ");
INSERT INTO nwi_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“‘Kughen rɨmɨni-ta mɨmə, “Nɨpɨg Kwasɨg tukruə ipakə, Yo jakher-pre kɨn Nanmɨn Kafak tuk narmamə mɨnə fam. Kwajikovə kapəmiə mɨnə tukharkun nɨni-ərhavyen nəgkiarien kafak. Tamaruə kapəmiə mɨnə mɨne nəwharu kapəmiə mɨnə tuksəmrərhav ye nəfrakɨsien. ");
INSERT INTO nwi_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jakvəhsi-pən Nanmɨn Kafak kɨmi yasitu mɨnə kafak- narman mɨne nɨpiraovɨn, pəh tukharkun nɨni-ərhavyen nəgkiarien kafak. ");
INSERT INTO nwi_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Yo jakor nɨmtətien tɨksɨn ye napuə mɨne ye tokrei tanə: Nɨtə tukraiyu, nap tukruək, nehenap tukramənah. ");
INSERT INTO nwi_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mɨrh tukrɨpɨs, makuə tukrəwhao rəmhen kɨn nɨtə; kwasɨg ikɨn, Nɨpɨg Ehuə Pɨk kape Yermaru tukruə. ");
INSERT INTO nwi_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ye nɨpɨg a, narmamə yamə mɨne kasokrən kɨn Yo, Kughen Yermaru, Yo jakvəh mɨragh əriə.” ’” ");
INSERT INTO nwi_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Kɨni Pita rɨmə, “!Kɨmiə nəmə Isrel! Taksətərɨg kɨn nəgkiarien e. Kɨmiə nakharkun huvə nɨmtətien mɨnə pɨsɨn pɨsɨn yame Yesu rɨmnor ye nəsanɨnien kape Kughen, yame kɨmiə nɨmɨsəm. Narɨmnar mɨnə e ramhajoun-pən mə Kughen e In e rɨmnher-pə kɨn Yesu ruə. ");
INSERT INTO nwi_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kughen rɨmɨrkun məkupən mə tukuh In, kərəhu-pən In ye kwermɨmiə. Kɨni kɨmiə nɨmnhauh In mɨsərəhu-pən In ye kwermɨ nəmə has mɨnə, iriə kɨsəsɨk-pən In ye nai kamarkwao kɨn, mɨshopni. ");
INSERT INTO nwi_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Mərɨg Kughen In rɨmɨrɨsɨn Yesu ye nəmhəyen kape nɨmhəyen, mor In rɨmragh mɨn; meinai nɨmhəyen rɨpəh nəutənien mə to rɨraptərəkɨn tɨm tɨm Yesu. ");
INSERT INTO nwi_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Rəmhen kɨn nəgkiarien kɨrik yame King Deved rɨmɨni kupən. Rɨmnəgkiar iran mamni mɨmə, “‘Nɨpɨg mɨnə fam yakaməm Kughen ramarə kɨmru min. Nar kɨrik rɨrkək tukror yo yakmɨr. ");
INSERT INTO nwi_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ror pən, rɨkik ramagien pɨk mavəhsi haktə In. Kɨni rɨkik ramərinu meinai yakɨrkun mə Kughen tukrɨvəh mɨragh nɨprak. ");
INSERT INTO nwi_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Mərɨg In rɨpəh nɨpəhyen yo mə jakaməmɨr rerɨn ye nəkwai nɨmɨr. Rɨpəh nɨpəhyen nɨprak ramətɨt mapien, mərɨg in ai Yo, yemə rhakə kafan. ");
INSERT INTO nwi_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","In rɨmnhajoun ta swatuk kɨn yo; yame tuk nɨvənien mamarə huvə, kɨni mor yo rɨkik ramagien. Mərɨg in ai In ramarə kɨmru min.’” ");
INSERT INTO nwi_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Kɨni Pita rɨmə, “Yo mɨnə tɨksɨn, jakhoprai-pre nəgkiarien e kɨmi əmiə. Kaha kapətawə a, King Deved, ruamhə ta tu, kɨmɨnɨm in. Təwk iran raməmɨr imətawə ikɨn maməmɨr təvɨr. ");
INSERT INTO nwi_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","In profet kɨrik kape Kughen, kɨni rɨmɨrkun mə Kughen rɨmɨrpen ta mə kwənərəus kɨrik kafan tukruə mɨn yermaru kɨrik rəmhen kɨn In. ");
INSERT INTO nwi_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Deved rɨmnəm nar a tukraməkeikei muə mor nəfrakɨsien kɨn. In rɨmɨni mə Kristo, yame Kughen rɨmɨni mə tukrher-pə kɨn, In tukror ramragh mɨn ye nɨmhəyen, kɨni tukrɨpəh nɨpəhyen nanmɨn kafan raməmɨr rerɨn ye nəkwai nɨmɨr, kɨni nɨpran tukrəpəh nɨmətɨtien. ");
INSERT INTO nwi_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Kughen rɨmnor Yesu ramragh mɨn. Kɨni kɨmawə fam yɨmɨsəm kɨn nɨmrɨmawə, mamhani-ərhav nar a. ");
INSERT INTO nwi_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kughen e In Rɨmni, in rɨmɨvəhsi haktə Yesu mə tukrəkwətə ye nɨkarɨn, mɨvəhsi-pən Nanmɨn Rhakə kɨmin, rəmhen kɨn yame rɨmɨrpen ta kupən. Kɨni narɨmnar yame nakasəm mɨne yame nakasərɨg, Nanmɨn Rhakə ramor kɨmi ətawə. ");
INSERT INTO nwi_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","King Deved in rɨmɨpəh nɨvənien ye neai, mərɨg in əmə rɨmɨni nəgkiarien e mə, “‘Kughen Yermaru rɨmɨni-pən tuk Yermaru kafak mɨmə, “Ǝkwətə-pən ye kwermɨk matuk ");
INSERT INTO nwi_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Meriaji nɨpɨg jakor Ik takehuə ye tɨkmɨr kafam mɨnə.” ’” ");
INSERT INTO nwi_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Kɨni Pita rɨrpɨn mɨmə, “Pəh kɨtawə nəmə Isrel, tukharkun huvə mə Yesu e nɨmɨsəsɨk-pən In ye nai kamarkwao kɨn In a Kughen rɨmnor In mə In Yermaru kapətawə, mɨne Kristo mɨn.” ");
INSERT INTO nwi_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pita raməgkiar məkneikɨn, rɨkiriə rərhakɨs. Aikɨn, kɨsaiyoh Pita mɨne aposol mɨnə mhamə, “Yo mɨnə tɨksɨn ?jakshawor-pən iran mɨne?” ");
INSERT INTO nwi_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Kɨni Pita rɨmɨni-pən tuk əriə mɨmə, “Kɨmiə taksarar ye nərɨgien kapəmiə tuk norien hah kapəmiə, kɨni mɨsor baptaes ye nhag Yesu Kristo, mɨsarakikɨn təvhagə hah, pəh Kughen tukrɨvəhsi-pre nɨhuvəyen a Nanmɨn Rhakə kɨmi əmiə. ");
INSERT INTO nwi_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kughen rɨmɨrpen ta əmiə mɨne kwajikovə mɨnə kapəmiə, mɨne mukupmiə mɨnə yamə mɨne tukpihauə. Nɨrpenien e raməmɨr ye narmamə yamə mɨne Kughen Yermaru rɨmnokrən kɨn əriə.” ");
INSERT INTO nwi_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kɨni Pita rɨmɨni-ərhav mɨn nəgkiarien rɨpsaah kɨmi əriə maməgkiar skai kɨmi əriə mɨmə, “!Takasəkeikei mɨsəta ye nəmə hah yamə mɨne kɨsarə ye tokrei tanə ai taktakun, pəh Kughen tukrɨpəh nɨvəhsi-preyen narpɨnien kɨmi əmiə!” ");
INSERT INTO nwi_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Kɨni narmamə yamə mɨne kɨmnhani nəfrakɨsien iran, kɨmɨsor baptaes. Ye nɨpɨg a, narmamə rəmhen kɨn tri taosen kɨmnhauə mhakwasɨg kɨn narmamə yame mɨnə kɨshatətə ye Yesu. ");
INSERT INTO nwi_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nɨpɨg mɨnə fam narmamə yamə mɨne kɨshatətə ye Yesu kasarə kɨrikianə mɨsətərɨg kɨn nəvhagien kape aposol mɨnə, mamhavəh Nəvɨgɨnien Rhakə, mɨsəhuak. Rɨkiriə rɨskai mə tukasəkeikei mɨsor narɨmnar mɨnə a. ");
INSERT INTO nwi_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kɨni Kughen rɨvəhsi-pən nehuəyen kɨmi aposol mɨnə tuk norien nɨmtətien rɨpsaah. Narmamə kɨsəm kɨsakur pɨk kɨn. ");
INSERT INTO nwi_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Narmamə yamə mɨne kɨshatətə ye Yesu, nɨpɨg mɨnə fam kasofugɨn kɨrikianə. Iriə fam rɨkiriə ragien tuk nəvraiyen kapəriə nautə kɨmi iriə mɨnə tɨksɨn, ");
INSERT INTO nwi_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","rəmhen kɨn tukmə yermamə kɨrik kafan nar kɨrik rɨrkək, kɨni kɨrik rəvrai kafan nautə, mɨvəh mane iran, kɨni masitu iran. ");
INSERT INTO nwi_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nɨpɨg mɨnə fam iriə kasofugɨn ye Nimə Ehuə kape Kughen, rɨkiriə kɨrikianə. Kasəvɨgɨn ye nəkwai nimə kapəriə, mamhavəh Nəvɨgɨnien Rhakə rəmhen kɨn Yesu rɨmɨni. Nɨpɨg mɨnə fam, nərɨgien kapəriə reiwaiyu, kɨni masagien, ");
INSERT INTO nwi_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","masəgnəgɨn Kughen. Kɨni narmamə kamhani vivi əriə tuk norien kapəriə. Kɨni nɨpɨg mɨnə fam Kughen ravəh mɨragh narmamə mamofugɨn əriə ye kwhen kapəriə. ");
INSERT INTO nwi_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nɨpɨg kɨrik, ye nɨpɨg kape nəhuakien, ye tri klok yenaiyu, Pita mɨnə Jon iriu kɨmɨweriwək mɨravən ye nəkwai Nimə Ehuə kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Yermamə kɨrik raməmɨr aikɨn, nɨhun rahas rɨmnor hanə. Nɨpɨg mɨnə fam in mɨnə tɨksɨn kharəh in mamhavən ye kwəruə kape Nimə Ehuə kape Kughen. Kwəruə a kamni kɨmə “Rhuvə pɨk.” In ramawə-pən kɨn mane kɨmi narmamə yamə mɨne kɨsauru-pən ye nəkwai nimə. ");
INSERT INTO nwi_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nɨpɨg in rəm Pita mɨne Jon kaweriwək mɨravən mə tukwauru-pən ye nəkwai nimə, in rɨmnaiyoh əriu kɨn mane. ");
INSERT INTO nwi_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Aikɨn, Pita mɨne Jon kwarha-pən mwəm kwən a. Kɨni Pita rɨni-pən tuk kwən a mɨmə, “Arha-pə atuatuk məm əmru.” ");
INSERT INTO nwi_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","In rarha-pən məm əriu, rɨkin rəsɨk mə tɨkrɨvəh mane kɨrik. ");
INSERT INTO nwi_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Mərɨg Pita rɨni-pən tukun mɨmə, “Yo, kafak mane rɨrkək. Mərɨg nar kɨrik yame yo yakavəh, jakvəhsi-pre kɨmik. Ye nhag Yesu Kristo, yemə Nasaret, yakamni-pre tuk ik mə takhekɨmter məriwək.” ");
INSERT INTO nwi_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kɨni Pita rɨvəh kwermɨn matuk, masitu iran mə tukrərer, taktəkun əmə nɨhun mir kɨrahuvə. ");
INSERT INTO nwi_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Rɨviə haktə, məriwək mamavən. Mamkwasɨg kɨn əriu, irisɨr mɨrhauru-pən ye nəkwai Nimə Ehuə kape Kughen. In rɨmnəriwək, mavihaktə-vihaktə, maməgnəgɨn Kughen. ");
INSERT INTO nwi_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kɨni narmamə fam kɨsəm kwən a rameriwək, maməgnəgɨn Kughen, ");
INSERT INTO nwi_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","kharkun mə kwən ai nɨpɨg m-fam ramawə kɨn mane ye kwəruə ye Nimə Ehuə kape Kughen. Kɨsakur pɨk tuk kwən a. ");
INSERT INTO nwi_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kwən a ramrəh tɨm tɨm hanə kwermɨ Pita mɨne Jon, narmamə kɨmɨsəm, kɨsakur pɨk kɨn, mɨsaiyu mhauə a karharer ikɨn, ye kwənmhaan kɨrik kamni kɨmə Vranda kape King Solomon. ");
INSERT INTO nwi_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kɨni Pita rəm narmamə mɨnə a, mɨni-pən tuk əriə mɨmə, “Nəmə Isrel. ?Rhawor naksakur pɨk kɨn nar e? ?Rhawor naksətamə pɨk irəmru? ?Kɨmiə nakhamə ta kɨmru yerpɨrɨg kɨni mɨrarkun nor-huvəyen yermamə e raməriwək ye nəsanɨnien əmə kapəmru uə? !Nɨkam! ");
INSERT INTO nwi_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kughen kape kaha mɨnə tu, Ebraham mɨne Aesak mɨne Jekob, In a rɨmnor nar e. In pɨsɨn əmə rɨmɨvəh-si haktə yor atuə kɨn kafan e Yesu. In e Yesu əmə e nɨmnhavəhsi-pən In rərer ye nɨmrɨ namasur mɨnə kape gavman. Ye nɨpɨg ai, Paelat rɨmnamni pawk mə tukrɨrɨsɨn In, mərɨg nɨmɨsəkeikei kɨmi Paelat mə tukhopni In. ");
INSERT INTO nwi_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Nakwənhaukrekɨn-pən nɨmetaimiə kɨmi Yesu e yame ratuatuk mamərhakə, kɨni mɨsaiyoh Paelat mə tukrɨrɨsɨn əmə yermamə kɨrik yame ramhopni yermamə. ");
INSERT INTO nwi_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ye nərɨgien a, kɨmiə nɨmɨshopni yermamə a in nuknei nɨmraghien. Mərɨg kwasɨg ikɨn, Kughen rɨmnor In rɨmragh mɨn. Kɨni kɨmawə yɨmɨsəm mamhani-ərhav mhamə nar a in nəfrakɨsien. ");
INSERT INTO nwi_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kwən e kɨmiə nakasəm mharkun in, in rɨnəsanɨn meinai kɨmawə yakshatətə ye Yesu. In nəsanɨnien kape Yesu, mɨne nhatətəyen yame Kughen rɨmɨvəhsi-pə kɨmi əmawə yame rɨmnor huvə yermamə e, kɨmiə nakasəm. ");
INSERT INTO nwi_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Yo mɨnə tɨksɨn, yakɨrkun mə nɨmɨsor narɨmnar mɨnə e kɨmiə namehuə kapəmiə mɨnə ye nətəwaoyen kapəmiə. ");
INSERT INTO nwi_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ror pən, nəgkiarien yame Kughen rɨmɨni kupən, ruauə mɨnor nəfrakɨsien kɨn. Nəgkiarien kape profet kafan mɨnə kupən rɨmɨni ta mɨmə kafan Kristo tukraməkeikei mamərɨg nəmhəyen. ");
INSERT INTO nwi_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","!Eh! Kɨmiə takasəkeikei mɨsarar ye nərɨgien kapəmiə tuk təvhagə hah kapəmiə. Kɨni mhakwasɨg kɨn Kughen, pəh In tukrɨvəhsi ta narpɨnien kape təvhagə hah kapəmiə kɨni mətu-pən əmiə imei napɨsien. ");
INSERT INTO nwi_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Kɨni In tukrher-pə mɨn kɨn Kristo tukrɨrerɨg-pə mɨn, yame Kughen rɨmɨrpen ta kupən. Yakamni Kristo e, Yesu. ");
INSERT INTO nwi_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Mərɨg Yesu tukraməmɨr ye neai meriaji nɨpɨg yame Kughen tukror huvə narɨmnar fam rəmhen kɨn yame Kughen rɨmɨni ta tuk profet rhakə kafan mɨnə kupən, ");
INSERT INTO nwi_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","meinai Moses rɨmɨni mɨmə, “‘Kughen Yermaru tukrɨvəh-si haktə profet kɨrik kapəmiə rəmhen kɨn yo. Profet a in kɨmiə kɨrik; takasəkeikei masətərɨg huvə kɨn nəgkiarien kafan mɨsor nəkwan. ");
INSERT INTO nwi_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Narmamə yamə mɨne khapəh nɨsətərɨgien kɨn nəgkiarien kafan, Kughen tukror narpɨnien ehuə kɨmi əriə.’” ");
INSERT INTO nwi_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Kɨni Pita rɨrpɨn nəgkiarien mɨmə, “Kɨni profet mɨnə mɨn tɨksɨn kɨmnhani mɨn nəgkiarien a. Rɨrikakun ye Profet Samuel, muə meriaji-pə ai taktəkun. Mərɨg iriə kasəgkiar kɨn narɨmnar mɨnə ai taktəkun. ");
INSERT INTO nwi_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nɨrpenien yame Kughen rɨmɨni kupən tuk profet kafan mɨnə, promes a kapəmiə. Kɨmiə naksəmɨr ye promes yame Kughen rɨmɨni ta tuk kaha mɨnə kapəmiə kupən. Nəgkiarien yame Kughen rɨmɨvəhsi-pən kɨmi Ebraham mɨmə, “‘Kwənərəus kafam tukrɨvəhsi-pən nɨhuvəyen kɨmi narmamə fam ye tanɨmtanə.’ ");
INSERT INTO nwi_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","“Rəri-pən nəgkiarien a, Kughen rɨmnher-pə kɨn Yesu, yor atuə kɨn kafan, kɨmi əmiə tuk nɨvəhsi-preyen nɨhuvəyen kɨmi əmiə məkupən, mɨmə taksarar ye nərɨgien kapəmiə tuk təvhagə hah.” ");
INSERT INTO nwi_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita mɨne Jon kawəgkiar hanə kɨmi narmamə, kɨni pris mɨnə, mɨne yamehuə kape mobael yamə mɨne kasarha tuk Nimə ehuə kape Kughen, mɨne Sadusi mɨnə, khauə mhatərhav-pə. ");
INSERT INTO nwi_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Iriə, niemha rhai pɨk əriə meinai iriu kɨmɨraniərhav-pən tuk narmamə mə Yesu rɨmamhə mɨmragh mɨn mor swatuk mə narmamə yamə mɨne kwənhamhə ta tukhamragh mɨn ye nɨmhəyen kapəriə. ");
INSERT INTO nwi_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Məkneikɨn, kharaptərəkɨn əriu, mərɨg rɨnenaiyu ta, kɨni kharəhsi-pən əriu ye kalabus mhamə tɨkəni rɨkwamer kɨn tuksəm əpu əriu. ");
INSERT INTO nwi_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kɨni mərɨg, narmamə khapsaah kɨsərɨg nəgkiarien kapəriu, mamhani nəfrakɨsien iran. Nəməhuak mɨnə kɨmnhapsaah, iriə fam rapita faef taosen. ");
INSERT INTO nwi_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kəni rɨkwamer kɨn, namehuə mɨnə kape nəmə Isrel, mɨne nəwharu mɨnə kapəriə mɨnə, mɨne namhajoun kape loa kape Moses, kɨmɨsofugɨn apa Jerusalem. ");
INSERT INTO nwi_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Mɨsofugɨn iriə hae pris kapəriə, nhagɨn a Anas, mɨne Kaeafas, mɨne Jon, mɨne Aleksandra, mɨne narmamə tɨksɨn yame iriə kwənərəus kape hae pris. ");
INSERT INTO nwi_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mɨsor Pita mɨne Jon kawərer ye nɨmrɨriə, mɨsaiyoh əriu mhamə, “?Nakaravəh nhag pa e mawor huvə yermamə e kɨn?” ");
INSERT INTO nwi_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Aikɨn, Nanmɨn Rhakə reiwaiyu-pən ye Pita. Kɨni Pita rɨni-pən tuk əriə mɨmə, “Namehuə kape nəmə Isrel, mɨne nəhuaru mɨnə, ");
INSERT INTO nwi_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","tukmə ror kɨmiə naksarkut mə taksarhakɨn-pə ru irəmru mə kwən yame nɨhun rɨmnahas rɨmɨvəh hiə nɨhuvəyen- mə yɨmɨwhawor-pən iran mɨne mawor huvə nɨhun. ");
INSERT INTO nwi_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kɨni kɨmiə nəmə Isrel mɨnə fam takasəkeikei mharkun mə kwən e yame nɨhun ruahuvə ta, ramərer əkupən irəmiə ye nəsanɨnien əmə ye nhag Yesu Kristo, yemə Nasaret. In e Yesu yame kɨmiə nɨmɨsəsɨk-pən In ye nai kamarkwao kɨn. In rɨmhə, mərɨg Kughen rɨmɨvəh mɨragh mɨn In. ");
INSERT INTO nwi_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu a In a Nəkwəkwə kape Kughen rɨmɨni ta mɨmə, “‘Səpaag e, yame narmamə kape nəvhirəkɨnien nimə kɨmɨsarakikɨn, mərɨg Kughen rɨmnor in ruauə Səpaag huvə yame tukrəkɨr məkupən.’ ");
INSERT INTO nwi_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Kɨni yermamə kɨrik rɨrkək ye tokrei tanə e yame rɨrkun nɨvəh-mɨraghien ətawə, meinai Kughen tukraməkeikei mɨvəh mɨragh ətawə ye nhag Yesu Kristo pɨsɨn əmə.” ");
INSERT INTO nwi_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Narmamə kape kaonsel mɨnə kɨmɨsəm mə Pita mɨne Jon yermamə apnapɨg mir əmə, kɨmɨrapəh nɨwor-pawk-ien skul, mərɨg kɨmɨwətgha kɨn nəgkiarien. Kɨni iriə kɨsakur kɨn nɨrkunien kapəriu, kɨni mharkun mə iriu kɨmɨwəriwak irisɨr Yesu. ");
INSERT INTO nwi_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kɨni iriə to khapəh nhaniyen nar kɨrik mərɨg in ai kɨmɨsəm yermamə a yame nɨhun ruahuvə ta, ramərer ye nɨmrɨriə. ");
INSERT INTO nwi_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kɨni iriə khani-pən tuk ərisɨr mhamə irisɨr tukrhap a ye kwənmhaan kape kaonsel pəh iriə əmə tuksəgkiar. ");
INSERT INTO nwi_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Kɨni iriə kɨmnhani tuk əriə mɨnə mhamə, “?Tukshawor nar mir a? Nəmə Jerusalem kwənharkun ta norien a nar mir a kɨmɨwor ye kwən a. In rehuə pɨk; kɨtawə to khapəh nhaniyen mə neikuəyen. ");
INSERT INTO nwi_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pəh khani-əhu nəvsaoyen kɨn, kɨni mɨsor kwirɨg kɨmi nar mir a mə tukrɨpəh nɨrɨni-mɨnien nhag Yesu.” ");
INSERT INTO nwi_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kɨni ai, narmamə kape kaonsel mɨnə kɨsokrən kɨn Pita mɨne Jon mə tukravən mɨn imə. Kɨni mhani-əhu əriu mə tukrɨpəh mɨn nɨraniyen nhag Yesu, mɨne nɨwhajounien narmamə kɨn. ");
INSERT INTO nwi_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kɨni iriu krəni-pən tuk əriə mɨrəmə, “Nɨkam. Kɨmiə taksəkir mə ratuatuk ye nɨmrɨ Kughen mə jakwor nəkwai Kughen, uə mə jakwor nəkwaimiə. ");
INSERT INTO nwi_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mərɨg kɨmru jakrapəh nɨwapnapɨgien. Kɨmru jakawəkeikei mɨrəni-ərhav narɨmnar a yame kɨmru yɨmɨwəm ye nɨmrɨmru, mɨne yame yɨmwərɨg kɨn nɨmətɨrgɨmru.” ");
INSERT INTO nwi_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kɨni kaonsel rɨmɨni-pən mɨn tuk Pita mɨne Jon mə iriə tukhavəhsi-pən narpɨnien kɨrik kɨmi əriu tukmə iriu kawəkeikei mə tukarani-ərhav Yesu kɨmi narmamə; kɨni tuksher yerhav kɨn əriu. Kɨmɨsher yerhav kɨn əriu meinai kwəseinein mə tukshawor əriu. Kɨmnharkun mə narmamə apnapɨg mɨnə rɨkiriə tukrɨmhə tukmə iriə khavəhsi-pən narpɨnien kɨmi əriu, meinai narmamə fam khavəh-si haktə Kughen tuk nɨmtətien yame rɨmnor ");
INSERT INTO nwi_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ye kwən a yame nɨhun rahas rɨmnor hanə meriaji-pə aitaktəkun, kɨni kafan newk rɨnapita ta foti. ");
INSERT INTO nwi_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kaonsel a rher-yerhav kɨn Pita mɨne Jon kɨravən, taktəkun əmə iriu kɨrarerɨg-pən mɨn tuk kapəriu narmamə mɨnə. Kɨni mawəvsao kɨn nəgkiarien kape jif pris mɨnə mɨne nəhuaru mɨnə kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kɨni iriə kɨsərɨg nəgkiarien a, iriə m-fam khauə kɨrikianə mɨsəhuak kɨmi Kughen mhani mhamə, “Kughen. Ik nɨmnor neai mɨne nɨmoptanə mɨne tahik, mɨne narɨmnar mɨnə fam yame kasəmɨr ye tokrei tanə. ");
INSERT INTO nwi_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kɨni kaha kapəmawə a Deved, yor atuə kɨn kafam, rɨmɨni-ərhav nəgkiarien e ye Nanmɨn Kafam mɨmə, “‘?Rhawor nəmə tanɨmtanə mɨnə niehmaa ramhai əriə? ?Rhawor narmamə mɨnə a kamharai mhun mə tuksor nahasien mɨnə e? Kamharai mhun təkun əmə nəgkiarien. ");
INSERT INTO nwi_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Namehuə kape tokrei tanə kasor apnəpenə tuk nuhyen, mɨne namehuə mɨnə khauə mɨsofugɨn mamhani hah Kughen kɨni mamhani hah mɨn Kristo yame In rɨmɨrpen In.’” ");
INSERT INTO nwi_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kɨni iriə mhamə, “Kughen, nəgkiarien e nəfrakɨs. Herod mɨne Ponjes Paelat mɨne nəmə Isrel, kɨmɨsofugɨn iriə nəmə tanə pɨsɨn pɨsɨn mɨnə, mharai mhun nəgkiarien mə tukshopni Yesu, yame In kafam yor atuatuk yame nɨmɨrpen. ");
INSERT INTO nwi_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kɨmnharai mhun nəgkiarien rəri-pən atuatuk əmə kafam nəgkiarien yame Ik nɨmɨni ta ye nəsanɨnien mɨne nɨrkunien kafam kupən. ");
INSERT INTO nwi_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Mərɨg Kughen, taktəkun ai, takaməkeikei mamərɨg nəgkiarien skai yame kamhani-pə tuk əmawə. Kɨmawə yor atuə kɨn kafam mɨnə. Takaməkeikei masitu irəmawə mə kɨmawə jakhani-ərhav nəgkiarien kafam. Mə kɨmawə jaksətgah kɨn nɨni-ərhavyen nəgkiarien kafam. ");
INSERT INTO nwi_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Takaməkeikei mərav-pə mhajoun nəsanɨnien kafam, mor huvə narmamə yamə mɨne kamhamhə, kɨni mor nɨmtətien pɨsɨn pɨsɨn ye nhag Yesu yame In kafam yor atuatuk.” ");
INSERT INTO nwi_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kɨmɨsəhuak ta, nimə yame kɨmnasəmɨr ikɨn rɨkiu-kiu. Kɨni Nanmɨn Rhakə reiwaiyu-pən irəriə m-fam. Kasətgha tuk nɨni-ərhav-yen nəgkiarien kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Narmamə yamə mɨne kamhani nəfrakɨsien ye Yesu, rɨkiriə kɨrikianə əmə. Yermamə kɨrik to rɨpəh nɨniyen mə, “Nar e kafak.” Tukmə nautə kɨrik, kapəriə m-fam. ");
INSERT INTO nwi_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nəgkiarien kape aposol mɨnə, nanmɨn aikɨn. Kɨni iriə kɨmnhani-ərhav mhamə, “Yesu in Yermaru kapətawə. In rɨmɨmragh mɨn ye nɨmhəyen kafan.” Kɨni Kughen rɨvəhsi-pən nɨhuvəyen kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Yermamə rɨrkək ye kwhen kapəriə yame kafan nautə rɨrkək, meinai narmamə yamə mɨne kapəriə aikɨn nɨmoptanə, uə kapəriə aikɨn nimə, kasəvrai mamhavəh mane iran, ");
INSERT INTO nwi_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","mhauə, mhavəhsi-pən kɨmi aposol mɨnə. Kwasɨg ikɨn, aposol mɨnə kɨsəwhai-pən mane a kɨmi narmamə m-fam yamə mɨne kamhani nəfrakɨsien ye Yesu, yamə mɨne kapəriə nar kɨrik rɨrkək. ");
INSERT INTO nwi_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kɨni kwən kɨrik, nhagɨn e Josef, in kwənərəus kape Livae, in rɨmnarha apa tanə kɨrik kamni kɨmə Saepras. Aposol mɨnə kɨmɨshen-pən mɨn nhagɨn kɨrik mhamə, “Banabas.” (Nɨpran rɨmə, “Yermamə kape nəgkiar-vi-vi-yen.”) ");
INSERT INTO nwi_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Kwən a rɨmnəvrai kafan nɨmoptanə, mɨvəh mane iran, muə mɨvəhsi-pən kɨmi aposol mɨnə. ");
INSERT INTO nwi_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kwən kɨrik, Ananaes iriu kafan piahwaru, Safaera, iriu mɨn kɨmɨwor salem kɨn kapəriu nɨmoptanə. ");
INSERT INTO nwi_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Kwən a rɨmɨvəh nɨpar mane muə mɨvəhsi-pən kɨmi aposol mɨnə. Merkwaig kɨn nɨpərɨn mɨmə kafan. Kɨni kafan piahwaru rɨmɨrkun. ");
INSERT INTO nwi_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kɨni Pita rɨni-pən tukun mɨmə, “Ananaes. ?Nakhawor mameighan kɨn yarmhə e Setan raurə yerkim, kɨni ik mameikuə ye Nanmɨn Rhakə, mamraptərəkɨn nɨpar mane yame nɨmɨvəh ye nɨmoptanə a? ");
INSERT INTO nwi_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kwasɨg ikɨn nɨpior salem kɨn nɨmoptanə a, kafam pɨsɨn əmə. Kɨni nɨpɨg nɨmnor salem kɨn, mane iran raməmɨr əmə ye kwermɨm. ?Mərɨg rhawor nakameikuə məkneikɨn? Pa rɨmə nakameikuə ye yermamə, mərɨg nakameikuə ye Kughen.” ");
INSERT INTO nwi_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kɨni Ananaes rərɨg nəgkiarien a, taktəkun əmə rɨsɨ-faktə meiwaiyu mowhan mɨmhə əgkəp. Kɨni narmamə kɨsərɨg, kɨsakur pɨk kɨn. ");
INSERT INTO nwi_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Kɨni nɨtamaruə mɨnə tɨksɨn khauə, mhauvrɨg əpɨs nɨpran, mharəh, mhatərhav, mhanɨm. ");
INSERT INTO nwi_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kɨni aoa kɨsisər ruə mɨvən, Safaera, piahwaru kape kwən ai, ruə imə. Mɨpəh nɨrkunien mə kafan yerman ruamhə ta. ");
INSERT INTO nwi_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Kɨni Pita raiyoh-pən in mɨmə, “Takni-pə tuk yo mə, ?mane hanə əme e in e yame nɨmɨravəh ye nɨmoptanə uə?” Kɨni pian a rɨni-pən tukun mɨmə, “Ǝhə. Mane hanəmei en.” ");
INSERT INTO nwi_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kɨni Pita rɨni-pən tukun mɨmə, “?Rhawor nakawor məknenkɨn? !Kɨmiru nɨmɨrəmə takwəvi niehmaa kape Kughen! ?Nakamərɨg narmamə kasəriwək mamhauə ye kwəruə? Iriə kwənhanɨm ta kafam yerman. !Kɨni iriə tukharəh mɨn ik mhavən mhanɨm ik!” ");
INSERT INTO nwi_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Taktəkun əmə mɨn, rɨsɨ-faktə meiwaiyu mowhan a ye nɨhu Pita mɨmhə. Nɨtamaruə mɨnə a khauə imə, mɨsəm mə ruamhə mɨn, kharəh mhatərhav mhavən, mhanɨm-pən mɨn ye nɨkar yerman kafan. ");
INSERT INTO nwi_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nəməhuak mɨnə mɨne narmamə mɨn tɨksɨn kɨsərɨg nəvsaoyen a, khagɨn pɨk. ");
INSERT INTO nwi_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Kɨni, aposol mɨnə kɨmɨsor nɨmtətien rɨpsaah ye nɨmrɨ narmamə. Nɨpɨg mɨnə fam narmamə yamə mɨne kamhani nəfrakɨsien ye Yesu kɨmɨsofugɨn apa kwənmhaan kɨrik apa ye Nimə Ehuə kape Kughen, kamni kɨmə, “Vranda kape King Solomon.” ");
INSERT INTO nwi_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Narmamə yamə mɨne khapəh nhaniyen nəfrakɨsien ye Yesu, kamhasiai pawk əriə mərɨg kamhagɨn kɨn nɨsofugɨn-pənien tuk əriə. ");
INSERT INTO nwi_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kamhagɨn, mərɨg nɨpɨg m-fam, narman mɨne nɨpiraovɨn khapsaah khauə mamhani nəfrakɨsien ye Yesu. ");
INSERT INTO nwi_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Aposol mɨnə kɨmɨsor nɨmtətien rɨpsaah. Narmamə khapɨk kapəriə narmamə yamə mɨne kamhamhə, mamhauə. Kɨni mɨsərəhu-pən əriə ye təvheitə kapəriə ye nɨkar swatuk mhapəh mhamə tukmə Pita rukrao ye swatuk, nanmɨn tukrɨrəh-pɨkɨn əriə tɨksɨn, kɨsəsanɨn. ");
INSERT INTO nwi_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kɨni narmamə khapsaah mɨn yerkwanu mɨnə ipakə tuk Jerusalem, kɨmnhapɨk narmamə yamə mɨne kamhamhə, mɨne yamə mɨne nanmɨn has raməmɨr irəriə, mhapɨk əriə mhauə, kɨni aposol mɨnə kɨsor huvə əriə. ");
INSERT INTO nwi_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kɨni hae pris mɨne in mɨnə tɨksɨn ye kwhen kape “Sadusi” kɨmɨsor tɨmət kɨmi aposol mɨnə. ");
INSERT INTO nwi_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Mɨsarar mharaptərəkɨn aposol mɨnə, mharəhsi-pən əriə ye kalabus. ");
INSERT INTO nwi_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kɨni yenaiyu, agelo kɨrik kape Kughen ruə məhitə ye kwəruə ye kalabus, mɨkɨr əriə mhatərhav. ");
INSERT INTO nwi_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Mɨni-pən tuk əriə mɨmə, “Kɨmiə takhavən apa Nimə Ehuə kape Kughen, mɨsəvsao kɨn nɨmraghien rerɨn kɨmi narmamə.” ");
INSERT INTO nwi_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Aikɨn, aposol mɨnə kɨsor nəkwan. Yenpɨg-enpɨg əgkəp, khavən apa ye Nimə Ehuə kape Kughen, mɨsəwhag kɨmi narmamə. Kɨni hae pris mɨne in mɨnə tɨksɨn kɨsokrən kɨn nəwharu mɨnə kape nəmə Isrel, khauə mɨsofugɨn mɨsəkwətə ye kaonsel kape nəmə Isrel. Kɨni mɨsher nəgkiarien rɨvən apa kalabus mə tukher-pə kɨn aposol mɨnə mə tukhauə mɨsərer ye nɨmrɨriə. ");
INSERT INTO nwi_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mərɨg nɨpɨg mobael mɨnə kɨmnhavən apa ye kalabus, mɨsəm mə aposol mɨnə kwənharkək. Kharerɨg mhauə ye kaonsel, mamhani-əsah pən iran tuk əriə, mhamə, ");
INSERT INTO nwi_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Yɨmnhavən apa ye kalabus, mɨsəm yakhamə tapɨg rətapɨg tɨm tɨm. Kɨni mobael mɨnə kape kalabus kasarha huvə tukun. Mərɨg nɨpɨg yɨmɨsəhitə, mɨsəm yermamə rɨrkək a imə.” ");
INSERT INTO nwi_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Yamehuə kape mobael mɨnə kape Nimə Ehuə kape Kughen, mɨne jif pris, kɨsərɨg nəgkiarien a, rukreikɨn kapəriə kapə, khani-pən tuk əriə mhamə, “?Naha nhagɨn tukruə mɨn?” ");
INSERT INTO nwi_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kɨni yermamə kɨrik rɨtərhav-pə, mɨni-pən tuk əriə mɨmə, “!Eh! !Narmamə mɨnə e nɨmnhapɨk-pən əriə ye kalabus, kwənhavən ta apa ye Nimə Ehuə kape Kughen; masəvhag kɨmi narmamə apaikɨn!” ");
INSERT INTO nwi_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Məkneikɨn, yamehuə kape mobael mɨnə rɨmɨkɨr kafan narmamə mɨnə, mhavən mhapɨk aposol mɨnə mhauə. Mərɨg kɨmnhapəh nɨsəukəkinien əriə, meinai khamə ta tukmə kɨsəukəkin əriə, narmamə apnapɨg kɨsəsɨk əriə kɨn kapier apɨg. ");
INSERT INTO nwi_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Kɨmnhapɨk aposol mɨnə, mhavən imə, mhani-pən mə tuksərer ye nɨmrɨ kaonsel. Kɨni hae pris rɨmnaiyoh əriə mɨmə, ");
INSERT INTO nwi_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“?Rhawor? Yakwənhani-pre ta mhamə takhapəh nhaniyen nhag kwən a Yesu. ?Mərɨg rhawor e kɨmiə naksor nəgkiarien kapəmiə rehuə e Jerusalem? Kɨni kɨmiə naksor narmamə kamhani mhamə kɨmawə yɨmɨshopni Yesu.” ");
INSERT INTO nwi_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Aikɨn, Pita mɨne aposol mɨnə khamə, “Kɨmawə jakasəkeikei mɨsor nəkwai Kughen. Kɨmawə yakhapəh nɨsorien nəkwai yermamə. ");
INSERT INTO nwi_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Kɨmiə nakwəsəsɨk-pən ta Yesu ye nai kamarkwao kɨn mɨshopni. Mərɨg Kughen kape kaha mɨnə tu rɨmnor In rɨmragh mɨn. ");
INSERT INTO nwi_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kɨni Kughen rɨmɨvəhsi-haktə In ramkwətə ye nɨkarɨn matuk. Mə In Yemehuə, In Kristo kapətawə. Kughen rɨmnor məknakɨn mə tukror swatuk mə kɨtawə nəmə Isrel tukharkun nɨsararien ye nərɨgien kapətawə tuk təvhagə hah, kɨni In tukrɨrəh-si ta narpɨnien kape təvhagə hah kapətawə. ");
INSERT INTO nwi_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yakamhani-ərhav nar a yame yɨməsəm, mɨne Nanmɨn Rhakə yame Kughen rɨvəhsi-pə ta kɨmi narmamə yamə mɨne kasor nəkwai Kughen.” ");
INSERT INTO nwi_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Narmamə kape kaonsel mɨnə kɨsərɨg nəgkiarien a, nəgkiarien a raməvi pɨk niemhaa kapəriə, kɨni khamə aposol mɨnə tukasəkeikei mhamhə. ");
INSERT INTO nwi_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kɨni iriə kɨrik, nhagɨn e Gamaliel, in Farisi kɨrik, in yemhajoun kɨrik kape Loa kape Moses, yame narmamə kamhasiai in, ramərer ye nɨmrɨ kaonsel, mɨni-pən tuk mobael mɨnə mɨmə, “Takhapɨk ta aposol mɨnə mhatərhav.” ");
INSERT INTO nwi_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kɨni mɨni-pən tuk kaonsel mɨmə, “Kafak narmamə mɨnə. Pəh kɨsərɨg huvə mə tukshawor-pən iran mɨne narɨmnə a. ");
INSERT INTO nwi_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Pəh nien mə tu əgkap e, kwən e Tudas rɨmnarar, mamni-ərhav mɨmə in yamehuə kɨrik. Narmamə tɨksɨn rəmhen kɨn fo handred kɨmnhakwasɨg kɨn in. Mərɨg kɨmnhopni in, kəko rik rik kafan narmamə mɨnə. Kwhen kafan ruɨrkək ta. ");
INSERT INTO nwi_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kwasɨg, Judas, yemə Galili, rɨtərhav-pə ye nɨpɨg gavman rɨmnaməvheikɨn narmamə mɨnə. In mɨn ravi narmamə kamhakwasɨg kɨn. Mərɨg kɨmnhopni mɨn in, kəko rik rik kafan narmamə mɨnə. ");
INSERT INTO nwi_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","In e ye nɨrkunien kafak: Pəh khapəh narmamə mɨnə e. Mharɨsɨn əriə khatərhav. Nar a kasor, to kape yermamə əmə, tukrɨrkək. ");
INSERT INTO nwi_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Mərɨg tukmə rɨmasɨ-pən ye Kughen, keinein nɨni-əhuyen. Tukmə khani-əhu, tuksəm əmə mə kɨtawə Kughen kasotgoh.” Narmamə kape kaonsel mɨnə kɨsərɨg, kɨseighan kɨn kafan nəgkiarien. ");
INSERT INTO nwi_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kɨni kɨsokrən kɨn aposol mɨnə khauə mɨn imə. Khani-pən tuk mobael mɨnə mə tuksərkɨs-ərkɨs əriə. Mɨsəgkiar-pən skai kɨmi əriə mhamə tukhapəh nhani-mɨn-ien nhag Yesu. Mɨsher yerhav kɨn əriə. ");
INSERT INTO nwi_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Khatərhav ye kaonsel, aposol mɨnə rɨkiriə ragien maməsɨk mə nar huvə kɨrik mə Kughen rɨmnəm-pən əriə mə iriə kɨsəmhen mə tuksərɨg nəmhəyen tuk nhaniyen nhag Yesu. ");
INSERT INTO nwi_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nɨpɨg mɨnə fam, khavən ye Nimə Ehuə kape Kughen, mɨne nimə apnapɨg mɨnə, masəvhag kɨmi narmamə, mhani-ərhav Nəgkiarien Huvə, mhamə Yesu In Kristo yame Kughen rɨmɨrpen. ");
INSERT INTO nwi_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kɨni ai, narmamə kape Yesu mɨnə kamhapsaah. Iriə tɨksɨn kwənərəus kape Isrel yamə mɨne kɨmnhasɨ-pən ye tanə pɨsɨn pɨsɨn; mərɨg iriə tɨksɨn, kwənərəus kape Isrel yamə mɨne kasarə rerɨn Isrel. Kɨni yamə mɨne khasɨ-pən ye kantri pɨsɨn pɨsɨn mɨnə kɨmnhani nɨkar yamə mɨne kasarə rerɨn apa Isrel, mhamə, “Nɨpɨg fam, nɨpɨg kaməwhai mane mɨne nəvɨgɨnien, kɨpəh nɨsarha-huvəyen tuk nɨpiəwharu kapəmawə yamə mɨne khamhə-tan kɨn əriə.” ");
INSERT INTO nwi_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ror pən, aposol mɨnə twelef kɨmɨsokrən kɨn narmamə kape Yesu mɨnə khauə kɨrikianə, mhani-pən tuk əriə mhamə, “Kɨtawə mɨnə tɨksɨn. Rɨpəh nəmhenien mə jaksəpəh nɨni-ərhavyen nəgkiarien kape Kughen mhauə mɨsowhai əmə narɨmnar. ");
INSERT INTO nwi_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Rhuvə mə takshajoun narmamə seven irəmiə yamə mɨne Nanmɨn Rhakə rukwar irəriə, kɨni nɨrkunien kapəriə rehuə. Pəh kɨmawə jakhavəh-si haktə əriə tukasarha huvə tuk nar a; ");
INSERT INTO nwi_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","kɨni pəh kɨmawə jakharkun nəhuakien mɨne nɨni-ərhavyen nəgkiarien kape Kughen.” ");
INSERT INTO nwi_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kɨsərɨg nəgkiarien a aposol mɨnə khani, rɨkiriə ragien. Kɨmɨshajoun Steven, kwən kɨrik yame kafan nhatətəyen rehuə, kɨni Nanmɨn Rhakə rukwar iran. Mɨshajoun mɨn Filip, mɨne Prokoras, mɨne Nikano, mɨne Timon, mɨne Pamenas, mɨne Nikolas, yemə Antiok kɨrik, yame rɨmnəpəh narəyen kape nəmə iman ikɨn, muə mɨkwasɨg kɨn nəhuakien kape nəmə Isrel. ");
INSERT INTO nwi_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Kɨni iriə khakɨr nəmə mɨnə a iriə seven, mhauə mɨsərer ye nɨmrɨ aposol mɨnə. Kɨni aposol mɨnə kasərəhu-pən kwermɨriə ye kapərhia kapə, mɨsəhuak-pən irəriə. ");
INSERT INTO nwi_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kɨni narmamə kape Yesu kɨmnhani-ərhav nəgkiarien kape Kughen kɨmi narmamə, kɨni narmamə kape Yesu e Jerusalem kɨmnhapsaah. Ye nəmə mɨnə a, pris mɨnə khapsaah kɨmɨshatətə ye Yesu. ");
INSERT INTO nwi_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Kɨni Steven, in kwən kɨrik yame Kughen rɨvəhsi-pən nəsanɨnien mɨne nɨhuvəyen kɨmin, kɨni in ramor pɨk nɨmtətien ye nɨmrɨ narmamə. ");
INSERT INTO nwi_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mərɨg nəmə Isrel tɨksɨn kape nukwao kɨrik kamni kɨmə “Friman,” kasəməkɨn Steven. Iriə a nəmə Saerin mɨne nəmə Aleksandra, mɨne nəmə Silisia mɨne nəmə Tarki, kɨmnhauə mɨsotgoh kɨmi Steven. ");
INSERT INTO nwi_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mərɨg Nanmɨn Rhakə rɨvəhsi-pən nɨrkunien kɨmi Steven. Nɨpɨg in rəgkiar, iriə to khapəh nɨsapitayen in. ");
INSERT INTO nwi_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kasəməkɨn in, mhavən mɨsərok narmamə tɨksɨn mhamə tukseikuə iran, mhamə iriə kɨmɨsərɨg kwən a raməgkiar has pən kɨmi Moses mɨne Kughen. ");
INSERT INTO nwi_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kɨni nəgkiarien kapəriə rɨmnor narmamə mɨnə aikɨn, mɨne nəhuaru mɨnə, mɨne nəmhajoun kape loa kape Moses, kɨsəməkɨn mɨn Steven. Kɨmnhavən mharaptərəkɨn in. Mharəh mhauə mɨsərer ye nɨmrɨ kaonsel. ");
INSERT INTO nwi_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Mhakɨr mɨn narmamə tɨksɨn mhauə mə tukhani nəgkiarien eikuə ye Steven. Iriə kɨmnhani mhamə, “Nɨpɨg mɨnə m-fam kwən e ramni hah Nimə Ehuə kape Kughen mɨne Loa kape Moses. ");
INSERT INTO nwi_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Yɨmɨsərɨg mɨn ramni mɨmə, ‘Yesu e, yemə Nasaret, tukratmətəg-ətəg Nimə Ehuə kape Kughen, kɨni mukreikɨn narəyen yame Moses rɨmnərəhu kɨmi ətawə apa kupən.’” ");
INSERT INTO nwi_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kamhani hah Steven, iriə fam yamə mɨne kasəkwətə ye kaonsel kɨmɨsarha-pən mɨsəm Steven meinai nɨmrɨn rukreikɨn məmhen kɨn nɨmrɨ agelo. ");
INSERT INTO nwi_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kɨni ai, hae pris raiyoh-pən Steven mɨmə, “?Rhawor? ?Nəgkiarien e nəfrakɨsien?” ");
INSERT INTO nwi_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Kɨni Steven rɨni-pən mɨmə, “Tatə mɨnə, mɨne yo mɨnə tɨksɨn, sətərɨg kɨn yo. Kughen yame yerpɨrɨg In rɨmauə tuk kaha kapətawə Ebraham. Aikɨn, Ebraham rɨmɨpəh nɨvən-hanəyen marə apa ye tanə a Haran; mərɨg in ramarə hanə ye tanə apa Mesopotemia. ");
INSERT INTO nwi_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Kɨni Kughen rɨni-pən tukun mɨmə, ‘Takapta ye kafam narmamə mɨnə mɨne rukwanu kafam, mɨvən apa ye kwənmhan kɨrik yame Yo jakhajoun kɨn ik.’ ");
INSERT INTO nwi_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Məkneikɨn, Ebraham rəta apa Koldia mɨvən marə apa Haran. Nɨpɨg ramarə aikɨn a, kɨni rɨmni rɨmhə, kɨni Kughen rɨkɨr in muə ye tanə e kɨtawə kɨsarə ikɨn mhauə mɨseriaji-pə ai taktəkun. ");
INSERT INTO nwi_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ebraham rɨmauə aikɨn, mərɨg Kughen rɨpəh hanə nəraiyen nɨmoptanə kɨrik kɨmin. Kafan nɨmoptanə rɨrkək pawk, mərɨg Kughen rɨmɨni ta mə tukrɨpiaməkeikei mɨvəhsi-pən fam nɨmoptanə e kɨmin. Kɨni rɨmə, ‘Nɨmoptanə fam e kafam mɨne kape kwənərəus kafam.’ Mərɨg ye nɨpɨg a, Ebraham, tɨni rɨrkək. ");
INSERT INTO nwi_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nəgkiarien yame Kughen rɨmɨni-pən tukun rɨmɨni mɨmə, ‘Mərɨg kwənərəus kafam mɨnə tukhavən mɨsarə ye tanə pɨsɨn. Iriə yor atuə kɨn əmə kape nəmə ye tanə a. Tuksərɨk mɨtə əriə mhavən mɨseriaji newk fo handred. ");
INSERT INTO nwi_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mərɨg Yo, jakor narpɨnien kɨmi nəmə kasərɨk mɨtə əriə. Kɨni ai, kwənərəus kafam mɨnə tuksəta ye tanə a, mharerɨg mhauə eikɨn e, mɨsəhuak kɨmi Yo.’” ");
INSERT INTO nwi_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kɨni Steven rɨrpɨn nəgkiarien mɨmə, “Kughen rɨmɨrpen Ebraham mɨmə In tukrarha huvə tuk əriə. Kɨni mɨni-pən tukun mə tukrəsɨg-pən nɨpɨkwarien, ror nɨmtətien kɨn mə iriə narmamə kape Kughen. Ror pən, nɨpɨg Ebraham rɨrəh kwajikovə kafan Aesak, kɨni ye nɨpɨg yame ror eit kɨn, rəsɨg-pən. Kwasɨg ikɨn, Jekob rəsɨg-pən kwajikovə kafan mɨnə, iriə fam twelef yamə mɨne iriə kaha kapətawə.” ");
INSERT INTO nwi_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Kɨni Steven rɨrpɨn mɨmə, “Kaha tu mɨnə kapətawə kɨmɨsəməkɨn naorahiriə e Josef, mɨseighan-pən kɨn in kɨmi nəmə Ijip mə tukror atuə kɨn kape nəmə Ijip. Mərɨg Kughen rɨmnarha huvə tukun, ");
INSERT INTO nwi_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kɨni mɨvəh mɨragh in ye narə-ororien kafan. Kɨni mɨvəhsi-pən nɨrkunien kɨmin. Nɨpɨg Josef rərer ye nɨmrɨ yermaru kape nəmə Ijip, yermaru a rorkeikei in, mɨvəhsi-haktə in mɨmə in yamehuə kɨrik. Mə tukramarha huvə tuk nəmə Ijip mɨne nautə kafan. ");
INSERT INTO nwi_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nɨpɨg a, sweiwei ramuh nəmə Ijip mɨne Kenan. Kaha kapətawə mɨnə, nəriə nəvɨgɨnien rɨmɨrkək, kasərɨg raha. ");
INSERT INTO nwi_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kɨni mərɨg rɨmriə Jekob rərɨg mə nəvɨgɨnien apa Ijip, kɨni rher-pən kɨn kaha kapətawə mɨnə khavən aikɨn, in e nɨrikakunien kapəriə kɨmnhavən Ijip. ");
INSERT INTO nwi_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kɨni, kwasɨg ikɨn, iriə khavən mɨn, Josef rəsɨk əpu in kɨmi piauni mɨnə. Kɨni yermaru kape nəmə Ijip rəm rɨrkun kwənərəus kape Josef. ");
INSERT INTO nwi_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kɨni Josef rher-pən nəgkiarien kɨmi rɨmni Jekob mɨne kafan mɨnə tɨksɨn tukhauə mɨsarə iriə min. Iriə fam seventi faef. ");
INSERT INTO nwi_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Məkneikɨn Jekob rəsok pihiu mɨvən apa Ijip. Kasarə mamhavən, in mɨne kaha kapətawə mɨnə kɨmnhamhə aikɨn. ");
INSERT INTO nwi_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kwasɨg ikɨn, kɨmɨrəh nɨkɨkririə kɨrerɨg khavən apa Sekem, kərəhu-pən əriə ye nəpag kapier yame Ebraham ruɨvəh-ta nɨmrɨn tuk kwənərəus kape kwən a Hamor.” ");
INSERT INTO nwi_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Kɨni Steven rarar mɨni mɨn mɨmə, “Kɨmɨsarə mamhavən, ruə ye nɨpɨg yame nəgkiarien yame Kughen rɨmɨvəhsi-pən kɨmi Ebraham tukruə mor nəfrakɨsien kɨn. Ye nɨpɨg a, kaha kapətawə mɨnə kɨmnhauə mhapsaah apa Ijip. ");
INSERT INTO nwi_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kɨmɨsarə mamhavən, yermamə pɨsɨn kɨrik yame reinein Josef ruə rəmhen kɨn yermaru kape nəmə Ijip. ");
INSERT INTO nwi_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","In mamor has pən pɨk kɨmi kaha tu mɨnə kapətawə mameikuə irəriə. Mamarkut kɨmi əriə mə tukmə kɨseimək, mɨsapitan kɨn kapəriə kwajikovə mɨnə, pəh khamhə. ");
INSERT INTO nwi_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Ye nɨpɨg atuatuk a, Moses rɨmnarha. Mor kwən huvə kɨn. Rɨmni mɨne nɨsɨni kwerkwaig kɨn ye nəkwai nimə, mawarha huvə tukun mweriaji makuə kɨsisər. ");
INSERT INTO nwi_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Mərɨg nɨpɨg iriu kwapitan kɨn in mə tukrɨmhə, piakəskəh kape yermaru kape nəmə Ijip rəm in, kɨni mɨrəh mɨvən, mamrhi rəmhen kɨn tɨni atuatuk. ");
INSERT INTO nwi_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kɨni kɨmnhajoun in kɨn nɨrkunien kape nəmə Ijip. Kɨni in raməgkiar huvə, mamor nar huvə. ");
INSERT INTO nwi_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Kɨni nɨpɨg Moses kafan newk foti, rɨkin raməsɨk mə tukrɨvən məm narɨmnə iman e nəmə Isrel. ");
INSERT INTO nwi_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Rarar mɨvən məm yemə Ijip kɨrik ramor aha-pən kɨmi yemə iman ikɨn kɨrik. Kɨni Moses rɨmavən, masitu ye yemə iman; mɨvəhsi-pən tai norien mhopni yemə Ijip ai. ");
INSERT INTO nwi_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","(Moses, rɨkin rɨmoh məta nəmə iman ikɨn tuksəm kharkun mə Kughen rɨmnher-pən kɨn in mə tukrɨpɨk ta əriə ye nəmhəyen yame kamor irəriə; mərɨg iriə kɨsəm, khapəh nharkunien). ");
INSERT INTO nwi_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kəni rɨkwamer kɨn, Moses ruə məm yemə Isrel mir kɨraru karauh əriu mɨnə. Kɨni in rɨvən mə tukrɨni-əhu əriu mɨmə, ‘!Ah! Kɨmiru piaumiru mɨnə əmə. ?Nakwhawor mawor rahah irəmiru mɨnə?’ ");
INSERT INTO nwi_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Mərɨg əmə kwən e yame ramor hah kɨmi in kɨrik rəsuə ta kɨn Moses mɨni-pən tukun mɨmə, ‘?Rhawor? ?Nakmə takarmaru irəmawə mɨvəhsi-pə narpɨnien kɨmi əmawə uə? ");
INSERT INTO nwi_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","?Nakmə takhopni mɨn yo rəmhen kɨn yame nɨmnhopni yemə Ijip a e niəv uə?’ ");
INSERT INTO nwi_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nɨpɨg Moses rərɨg nəgkiarien a, rɨgɨn, marar map. Map a Ijip mɨvən mamarə apa Midian rəmhen kɨn yepsɨpɨs kɨrik. Kɨni mɨrəh kwajikovə kafan mir aikɨn a. ");
INSERT INTO nwi_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Newk foti ruə mɨvən, nɨpɨg kɨrik, Moses rarar mɨvən apa ye tɨpəvsɨk ipakə tuk tukwas kɨrik kamni kɨmə ‘Sinae.’ Mɨvən aikɨn, məm nap ramuək ye kwaji nai kɨrik, kɨni agelo kɨrik kape Kughen rɨtərhav-pə tukun aikɨn. ");
INSERT INTO nwi_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses rəm rakur. Kɨni mɨvən ipakə tuk nai a mə tukrəm huvə. Məkneikɨn mərɨg nəgkiarien kape Kughen ramni mɨmə, ");
INSERT INTO nwi_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Yo Kughen kape kafam kaha misɨr kupən: Ebraham, mɨne Aesak, mɨne Jekob.’ Moses rɨmnərɨg nəgkiarien a, rətəmnɨmɨn, mɨgɨn pɨk kɨn nɨvag-pənien. ");
INSERT INTO nwi_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Kɨni Kughen rɨni-pən tuk Moses mɨmə, ‘Moses. Takrəh-si ta sandel kafam, mərɨg in ai kwənmhan e nakamərer ikɨn in ramərhakə. ");
INSERT INTO nwi_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yo yaknəm ta mə kafak narmamə mɨnə apa Ijip kasərɨg raha pɨk. Kɨni yakamərɨg mə kasasək; kɨni yakamuə mə jakpɨk-ta əriə ye nəmhəyen kapəriə. Yuə. Yakamher-pən kɨn ik takrerɨg mɨvən apa Ijip.’” ");
INSERT INTO nwi_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Kɨni Steven rɨrpɨn mɨmə, “Moses e in e, yermamə e nəmə Isrel kɨmɨsəpəh mɨseinein in mhamə, ‘Ah. ?Nakmə takarmaru irəmawə mɨvəhsi-pə narpɨnien kɨmi əmawə uə?’ Mərɨg Kughen rɨmɨvəh-si haktə in mə tukrarmaru irəriə. Kughen rɨmnher-pə kɨn agelo yame rɨmɨtərhav-pə tuk Moses ye nai yame nap ramuək iran, mə tukrɨvəh-si haktə in mə in tukrarmaru irəriə, mɨvəh mɨragh əriə. ");
INSERT INTO nwi_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses a rɨmnor nɨmtətien mɨnə tɨksɨn nɨpɨg rɨmnamkɨr nəmə Isrel mɨsap-ta Ijip mɨsəviəfugɨn ye tahik a kamni kɨmə Red Si, mamhauə ye tɨpəvsɨk. ");
INSERT INTO nwi_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“In e Moses mɨn yame rɨmɨni-pən tuk nəmə Isrel mɨmə, ‘Kughen tukrɨpivəh-si haktə profet kɨrik kapəmiə rəmhen kɨn yame rɨmɨvəh-si haktə yo. Profet a in kɨmiə əmə kɨrik.’ ");
INSERT INTO nwi_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moses əmə e in e rɨmnamarə iriə nəmə Isrel nɨpɨg kɨmɨseriwək kɨrikianə ye tɨpəvsɨk. In rɨmnamarə iriə kaha tu mɨnə kapətawə; ye nɨpɨg a agelo kɨrik kape Kughen rɨmauə məgkiar kɨmin ye tukwas e kamni kɨmə Sinae. Kɨni Kughen rɨmɨvəhsi-pən əmə nəgkiarien mɨragh kɨmin, mə tukruə mɨvəhsi-pə kɨmi ətawə. ");
INSERT INTO nwi_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Mərɨg kaha mɨnə kapətawə kɨmnhapəh nɨsorkeikeiyen mə tuksərɨg in. Mhapəh nɨsorkeikeiyen mə tukhakwasɨg kɨn. Ye nərɨgien kapəriə kɨmɨsorkeikei mə tukharerɨg-pən mɨn apa Ijip. ");
INSERT INTO nwi_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ror pən kɨmɨsəkeikei kɨmi Eron mamhani mahmə, ‘Ah. Takvhirəkɨn kapətawə tɨksɨn kughen, pəh iriə tukhakɨr ətawə. Mərɨg in a Moses e rɨmɨpɨk ta ətawə apa Ijip, mə tukhauə eikɨn e, mərɨg kɨtawə khapəh nharkunien mə in hiə ai taktəkun.’ ");
INSERT INTO nwi_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kɨni ye nɨpɨg a, iriə kɨmnhavhirəkɨn nanmɨ kwaji kau kɨrik rəmhen kɨn kughen kɨrik kapəriə. Mhavən mhauh nar mɨragh mhavaan əru mɨsəhuak-pən kɨmi kau a. Kɨni mɨsor nəvɨgɨnien ehuə kɨrik, rɨkiriə rɨmnagien tuk nar yame iriə kɨmnhavhirəkɨn. ");
INSERT INTO nwi_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Məkneikɨn, Kughen rukreikɨn-pən nɨmeitaan kɨmi əriə, meighan-pən kɨn əriə khavən mɨsəhuak kɨmi kəmhau mɨnə. Rəmhen kɨn yame Nəkwəkwə kape Kughen rɨmɨni ye nəkwəkwə kape profet mɨnə mɨmə, “‘!Nəmə Isrel! Kɨmiə nɨmɨsarə ye tɨpəvsɨk kape newk foti, mamhauh nar mɨragh mhavaan əru tuk nəhuakien, ?mə naksəhuak-pə kɨn kɨmi Yo uə? !Nɨkam! ");
INSERT INTO nwi_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nɨpɨg mɨnə fam kɨmiə nakamharəh nimə tapolen yame kaməhuak kɨmi Kughen Yermaru ikɨn, mərɨg yerkimiə naksəhuak kɨmi kughen eikuə e Molek, mamhavəh-si haktə nanmɨ kəmhau kape kughen kapəmiə Refan. Nakhamə kughen mir e kapəmiə. Ror məkneikɨn, jakher-ərhav kɨn əmiə takasarə apa isok,’ taksarə apa Babilon, ye nɨkarɨn pən.” ");
INSERT INTO nwi_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Kɨni Steven rarar mɨni-pən tuk əriə mɨmə, “Nɨpɨg kaha tu mɨnə kapətawə kɨmnɨsarə ye tɨpəvsɨk, kapəriə kɨrik aikɨn nimə tapolen yame kaməhuak kɨmi Kughen ikɨn. Nimə a, Kughen rɨmɨni-pən tuk Moses mə tukrɨvhirəkɨn; kɨni Moses rɨmnor atuatuk ye nɨrkunien yame Kughen rɨmɨvəhsi-pən kɨmin. ");
INSERT INTO nwi_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kwasɨg ikɨn, nɨpɨg Josua rɨmɨkɨr kaha kapətawə mɨnə mhauə mɨsəkota nəmə Kenan mharəhsi-ta tanə ye kwermɨriə, iriə mharəh nimə tapolen a mhauə iriə min. Nimə tapolen a rɨmnəmɨr meriaji-pə nɨpɨg kape King Deved. ");
INSERT INTO nwi_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Kughen rɨmnorkeikei pɨk King Deved. Kɨni Deved rɨni-pən tuk Kughen mɨmə, ‘Ik Kughen kape kaha tu Jekob. Takaməkeikei mɨpəh yakor nimə kɨrik kafam, pəh Ik takamarə ikɨn.’ ");
INSERT INTO nwi_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Mərɨg nimə ai, King Deved rɨmɨpəh nɨvhirəkɨnien. Mərɨg King Solomon əmə e in rɨmɨvhirəkɨn. ");
INSERT INTO nwi_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Mərɨg Kughen, In yerpɨrɨg pɨk. Rɨpəh narəyen ye nimə yame yermamə əmə ravhirəkɨn. Rəmhen kɨn nəgkiarien kape profet yame rɨmɨni mɨmə, ");
INSERT INTO nwi_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“‘Kughen ramni mə “Yo yakamarmaru ye neai mɨne tokrei tanə. ?Nakharkun mə taksor naha nimə yame Yo jakamarə ikɨn? ?Nakharkun mə taksor naha kwənmhan yame jakvən mapɨs ikɨn? ");
INSERT INTO nwi_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Hani-pə tuk Yo. ?Pa rɨmnor narɨmnar fam? Yo pɨsɨn əmə yɨmnor narɨmnar fam ye tokrei tanə.” ’” ");
INSERT INTO nwi_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Kɨni Steven rarar mɨni-pən tuk əriə mɨmə, “!Ah! Kapəmia kapə rɨskai pɨk. Kapəmiə nərɨgien rəpɨgnap rəmhen kɨn nəmə khapəh nɨsəhuakien. Kɨmiə nakhapəh nɨsorkeikeiyen mə taksor nəkwai Kughen. Kɨmiə naksəmhen kɨn kaha kapəmiə mɨnə kupən. Nakasətapɨg əmə kɨn Nanmɨn Rhakə nɨpɨg mɨnə fam. ");
INSERT INTO nwi_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Profet mɨnə kupən kɨmnhani-ərhav nəgkiarien kape Kughen, mərɨg kaha kapəmiə mɨnə kɨmɨsor has pən kɨmi əriə fam. Mɨshopni mɨn profet mɨnə kupən yamə mɨne kɨmnhani-ərhav kupən mə Yemə Atuatuk kape Kughen natukruə. Kɨni taktəkun ai kɨmiə mɨn nakaseikuə mhakurao-pən ye nɨmetai Yemə Atuatuk a kɨni mhauh In mɨshopni. ");
INSERT INTO nwi_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kɨmiə nakwənharkun-ta Loa a kape Kughen yame agelo mɨnə kwənhavəhsi-pə ta, mərɨg kɨmiə nakhapəh nɨsorien nəkwan.” ");
INSERT INTO nwi_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Steven rɨmnəgkiar fam, narmamə kape kaonsel mɨnə kɨmɨsərɨg, niemhaa rhai əriə, kasarkwəruə tukun. ");
INSERT INTO nwi_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mərɨg Steven, Nanmɨn kape Kughen rukwar iran. Kɨni in marha faktə apa ye neai, məm nɨkhakien kape Kughen; kɨni məm mɨn Yesu ramkwətə ye nɨkarɨn matuk. ");
INSERT INTO nwi_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kɨni mɨni-pən tuk əriə mɨmə, “Səmru. Yakaməm napuə rɨmnəkwag, mə Ji Yermamə ramərer ye nɨkar Kughen matuk.” ");
INSERT INTO nwi_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kɨni namehuə kape kaonsel mɨnə khasisɨgɨn nɨmətɨrgɨriə kɨni mɨsokrən iran. Mɨsarar, iriə fam mɨsaiyu mhauə tukun. ");
INSERT INTO nwi_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Mharaptərəkɨn in, mhaukəkin mhatərhav-pən apa yerkwanu mə tuksarkwhopni In. Kɨni narmamə yamə mɨne kɨmnhani hah Steven kɨmɨsəpəkiək ta kɨn sot kapəriə mɨsəhi-pən kɨmi tamaruə kɨrik nhagɨn e Sol, kɨni ai mɨsəsɨk Steven kɨn kapier apɨg. ");
INSERT INTO nwi_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kasəsɨk Steven kɨn kapier, raməhuak mamni mɨmə, “Yesu Yermaru, yakamərəhu-pən nanmɨk ye kwermɨm.” ");
INSERT INTO nwi_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Mənɨmkur mokrən ehuə mɨmə, “Yermaru, takpəh narpɨnien tai təvhagə has kapəriə.” Kɨni rɨmɨni fam nəgkiarien a, kɨni mɨmhə. ");
INSERT INTO nwi_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Kɨni Sol ramərer əmə rɨkin ragien mə iriə kɨmɨshopni Steven. Kɨni nəməhuak mɨnə tɨksɨn khauə mharəh nɨprai Steven mharəh mhavən mhanɨm, kɨni mɨsasək pɨk tukun. Rɨrikakun ye nɨpɨg a, Sol mɨne in mɨnə tɨksɨn kɨsarar masor ahas pən kɨmi nəməhuak mɨnə apa Jerusalem. Mɨsəkota əriə kɨsap mhavən mɨsarə apa yerkwanu mɨnə tɨksɨn apa Judia mɨne Sameria. Mərɨg aposol mɨnə əmə kɨsarə apa Jerusalem. ");
INSERT INTO nwi_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mərɨg Sol ramarkut pɨk mə tukroriah nəməhuak mɨnə. In mamvən ye nimə mɨnə mampɨk yerhav narman mɨne nɨpiraovɨn yamə mɨne kamhani nəfrakɨsien ye Yesu. Rɨpɨk əriə mɨvən mampɨk-pən əriə apa kalabus. ");
INSERT INTO nwi_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mərɨg Sol mɨne kafan narmamə mɨnə kɨmɨsəkota narmamə yamə mɨne kamhani nəfrakɨsien ye Yesu, kɨsaiyu kɨrikianə kɨrikianə, mhavən apa ikɨn mɨnə mamhani-ərhav Nəgkiarien Huvə kape Yesu. ");
INSERT INTO nwi_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Kɨni Filip rəsok-prah mɨvən yerkwanu kɨrik ye Sameria, kɨni maməvsao kɨn Kristo yame Kughen rɨmɨrpen. ");
INSERT INTO nwi_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kɨni nəmə aikɨn kɨsərɨg, mɨsəm mə Filip ramor nɨmtətien mɨnə, khauə kɨrikianə mɨsətərɨg huvə kɨn in. ");
INSERT INTO nwi_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Narmamə khapsaah, nanmɨn has mɨnə kɨmɨsəta irəriə. Nɨpɨg kɨsəta irəriə, mɨsətəpar. Mɨne narmamə yamə mɨne nɨkariə rəpou, mɨne yamə mɨne nɨhuriə rahas, iriə khapsaah khahuvə mɨn. ");
INSERT INTO nwi_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ror pən nəmə Sameria rɨkiriə ragien pɨk. ");
INSERT INTO nwi_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Yerkwanu a, kwən kɨrik, nhagɨn e Saemon, nɨpɨg m-fam in ramor nɨmtətien ye norien kape yarmhə mɨnə, ye nɨmrɨ nəmə Sameria, kɨni kasəm kɨsakur pɨk kɨn. In ravəh-si haktə in mɨmə in yamehuə kɨrik. ");
INSERT INTO nwi_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nəmə ikɨn, nəmapnapɨg mɨnə, mɨne namehuə mɨnə, iriə m-fam kasətərɨg kɨn in. Mamhani mhamə, “In ravəh nəsanɨnien a kamni kɨmə ‘Nɨsanɨnien kape Kughen.’” ");
INSERT INTO nwi_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Iriə kɨmnhakwasɨg kɨn mərɨg in ai nɨpɨg rɨpsaah in ramor əriə kɨsakur kɨn nɨmtətien yamə mɨne in ramor. ");
INSERT INTO nwi_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Mərɨg nɨpɨg kɨsərɨg Filip ruə mɨni-ərhav nəgkiarien kape Narmaruyen kape Kughen, mɨne nhag Yesu Kristo, khani nəfrakɨsien ye nəgkiarien a. Narman mɨne nɨpiraovɨn yamə mɨne khani nəfrakɨsien ye Yesu, Filip ror baptaes irəriə. ");
INSERT INTO nwi_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Kɨni ai, Saemon mɨn rɨni nəfrakɨsien ye Yesu; marar mɨvən kor baptaes iran. Ikɨn pukaa Filip ramvən ikɨn, Saemon rakwasɨg kɨn. Kɨni məm nɨmtətien yamə mɨne Filip rɨmnor ye nəsanɨnien kape Kughen kɨni rakur pɨk kɨn. ");
INSERT INTO nwi_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nɨpɨg Aposol mɨnə apa Jerusalem kɨsərɨg nəvsaoyen mə nəmə Sameria kamhani nəfrakɨsien ye nəgkiarien kape Kughen, kɨni iriə kɨsher-pən kɨn Pita mɨne Jon mə tukravən mwəm əriə. ");
INSERT INTO nwi_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nɨpɨg kɨmɨravən mratərhav-pən tuk əriə, iriu mwəhuak-pən ye nəmə mɨnə e mə tukhavəh Nanmɨn kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","(Mərɨg in apa kupən, kɨmnor baptaes əmə irəriə ye nhag Yesu Yermaru; mərɨg Nanmɨn Rhakə rɨpəh hanə neiwaiyu-pənien tuk əriə). ");
INSERT INTO nwi_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kɨni Pita mɨne Jon kwərəhu-pən kwermɨriu ye kaparia kapə, məkneikɨn iriə khavəh Nanmɨn kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kɨni Saemon rɨmnəm mə Nanmɨn kape Kughen rɨmavən ye nɨmraghien kape narmamə nɨpɨg aposol mir a kwərəhu-pən əmə kwermɨriu irəriə mwəhuak-pən irəriə, məkneikɨn Saemon rɨpɨk yerhav mane mə tukrɨvəhsi-pən kɨmi əriu ");
INSERT INTO nwi_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","maməkeikei kɨmi əriu mɨmə, “Takravəhsi-pə mɨn nɨrkunien en kɨmi yo. Pəh jakərəhu-pən kwermɨk ye narmamə, khavəh Nanmɨn kape Kughen.” ");
INSERT INTO nwi_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Mərɨg Pita rəgkiar-pən skai kɨmin mɨmə, “!Mane en kafam tukraməkeikei mɨrkək kɨmiru min takravən ye nap ehuə! ?Nakmə nakɨrkun nɨvəhyen nɨmrɨ nɨhuvəyen a yame Kughen ravhsi-pən apnapɨg əmə kɨmi narmamə uə? ");
INSERT INTO nwi_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tukor ik nakpəh norien norien mɨnə e kapəmawə, meinai rɨkim rapəh natuatukien ye nɨmrɨ Kughen. ");
INSERT INTO nwi_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Takaməkeikei marar ye nərɨgien kafam tuk təvhagə has, maiyoh Kughen pəh tukrəspir ik tuk nərɨgien has kafam. ");
INSERT INTO nwi_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Yakaməm nɨpɨg mɨnə fam nakəməkɨn narmamə, morkeikei əmə ik; norien has rɨmnəruk əutən ik.” ");
INSERT INTO nwi_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Aikɨn, Saemon rɨni-pən tuk əriə məkeikei kɨmi əriə mɨmə, “Kɨmiru takwəhuak kɨmi Kughen tuk yo; mə jakpəh nɨvəhyen narpɨnien yame nakarani-pə tuk yo.” ");
INSERT INTO nwi_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Aposol mir a kɨrani-ərhav fam nəgkiarien kape Yesu Yermaru, mɨne narɨmnar yame In rɨmnor, kɨni ai mwarar, mratərhav Sameria, mweriwək mrarerɨg mɨravən Jerusalem. Nɨpɨg kɨravən, mɨrani-ərhav Nəgkiarien Huvə kape Kughen apa yerkwanu mɨnə kape nəmə Sameria. ");
INSERT INTO nwi_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nɨpɨg kɨrik, agelo kɨrik kape Kughen reiwaiyu-pə tuk Filip mɨni-pən tukun mɨmə, “Takhekɨmter, məri-pən swatuk e ye tɨpəvsɨk, yame rɨpɨs e Jerusalem muə mɨpɨs apa Gasa.” ");
INSERT INTO nwi_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Aikɨn, Filip rhekɨmter məriwək mamvən. Məm yamehuə kɨrik kape pianehuə kape nəmə Itiopia, nhagɨn a Kandas. Kwən a in Yunik kɨrik; in ramarha huvə tuk mane kape pianehuə ai. In ruavən ta apa Jerusalem mɨnəhuak. ");
INSERT INTO nwi_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Rɨmavən məhuak-ta apa Jerusalem, mɨrerɨg mɨnamvən apa iman ikɨn. Mamkwətə ye nar kɨrik kamni kɨmə “kat” yame hos ravi. Mamkwətə maməvheikɨn nəkwəkwə yame Profet Aesea rɨmɨrai. ");
INSERT INTO nwi_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Kɨni Nanmɨn Rhakə ruvən ye Filip mɨmə, “Takvən məriwək ipakə tuk kat a.” ");
INSERT INTO nwi_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Məkneikɨn, Filip raiyu mɨvən ipakə tukun, kɨni məm kwən a raməvheikɨn nəkwəkwə yame Profet Aesea rɨmɨrai. Kɨni Filip raiyoh-pən in mɨmə, “Yamehuə. ?Nakɨrkun nɨprai nəgkiarien e nakaməvheikɨn uə nɨkam?” ");
INSERT INTO nwi_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Kɨni yamehuə a rɨmə, “Tukmə yermamə kɨrik rhoprai-pə kɨmi yo, jakɨrkun.” Kɨni raiyoh-pən Filip mə tukrat-pən ye kat məkwətə iriu min. ");
INSERT INTO nwi_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nəgkiarien ye Nəkwəkwə kape Kughen yame kwən a raməvheikɨn mamni mɨmə, “In rəmhen kɨn sipsip kɨrik, kɨmɨrəh khopni. Məmhen kɨn kwaji sipsip əmə kɨrik yame rapəh nasəkien nɨpɨg kɨmnəkɨs nɨmrɨn Mərɨg in rapəh nəgkiarien. ");
INSERT INTO nwi_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kɨmnor naurɨsien kɨm in, kɨvəhsi-pən narpɨnien kɨrik kɨmin yame rɨpəh natuatukien. Kafan kwajikovə rɨrkək, mərɨg in ai kɨvəhsi-ta nɨmraghien kafan ye tokrei tanə e.” ");
INSERT INTO nwi_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kɨni yamehuə a raiyoh Filip mə, “?Profet e raməvsao kɨn pa nhagɨn? ?Raməvsao atuk kɨn in, uə raməvsao kɨn yermamə pɨsɨn kɨrik?” ");
INSERT INTO nwi_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kɨni Filip rɨmɨrikakun ye nəgkiarien kɨrikianə əmə yame rɨnaməvheikɨn mɨnamni-pən Nəgkiarien Huvə kape Yesu kɨmin. ");
INSERT INTO nwi_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Iriu kwəri swatuk a, mɨrauə mwəm nu kɨrik, kɨni yamehuə a rɨni-pən tuk Filip mɨmə, “Ǝm-ru nu apa. ?To nakor baptaes irak eikɨn e uə nɨkam?” ");
INSERT INTO nwi_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Kɨni Filip rɨni-pən tukun mɨmə, “Tukmə nakhatətə ye Yesu, yerkim m-fam, nakɨrkun norien baptaes.” Kɨni in rɨni-pən tuk Filip mɨmə, “Yo yakamni nəfrakɨsien ye Yesu mə In Ji Kughen.” ");
INSERT INTO nwi_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Məkneikɨn rɨni-əhu kat a, kɨni mweiwaiyu iriu Filip, kɨni Filip ror baptaes iran. ");
INSERT INTO nwi_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kweiwaiyu mwərer mɨn ye tame nu, məkneikɨn Nanmɨn kape Kughen rɨvəh-si ta Filip kɨni yamehuə a rɨpəh mɨn nəmien, marar aikɨn a, məri swatuk mamvən, rɨkin ragien. ");
INSERT INTO nwi_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Mərɨg Filip rakur məm ramərer apa yerkwanu a Asdod. Kɨni mɨvən apa yerkwanu mɨnə mamni-ərhav Nəgkiarien Huvə kape Yesu, mɨvən mɨvən meriaji-pən apa Sisaria. ");
INSERT INTO nwi_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ye nɨpɨg a, Sol rɨmnamni has hanə narmamə kape Yesu mɨnə mə tukraməkeikei mhopni əriə. Marar, mɨvən məm hae pris ");
INSERT INTO nwi_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","maiyoh-pən in mə tukrɨrai nəkwəkwə kɨrik rɨvən kɨmi nəmə Isrel apa Damaskes, mɨmə tukmə ruvən aikɨn məm narmamə kɨsəri-pən Swatuk kape Yesu, nar apnapɨg narman uə nɨpiraovɨn, tukrɨraptərəkɨn əriə, mɨpɨk əriə mhauə apa Jerusalem. ");
INSERT INTO nwi_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nɨpɨg Sol ruavən ipakə tuk Damaskes, taktəkun əmə rəm nɨkhakien rɨsɨ-pən ye napuə məsia-pen in. ");
INSERT INTO nwi_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","In rɨmamɨr, mərɨg nəgkiarien kɨrik ramni mɨmə, “!Sol! !Sol! ?Rhawor nakamor ahah pə məkneikɨn kɨmi Yo?” ");
INSERT INTO nwi_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Kɨni Sol rɨni-pən tukun mɨmə, “Yermaru. ?Ik pa en?” Kɨni In rɨni-pən tukun mə, “Yo Yesu e, yame ik nakamor ahah pə kɨmi Yo. ");
INSERT INTO nwi_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Mərɨg takhekɨmter, mɨvən apa yerkwanu. Aikɨn en, tukni-pre tuk ik mə takhawor-pən iran mɨne.” ");
INSERT INTO nwi_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Narmamə yamə mɨne kamhakwasɨg kɨn Sol kasərer, kɨsakur pɨk, mɨsapnapɨg meinai kɨsərɨg pawk nəgkiarien a, mərɨg khapəh nɨsəmien yermamə kɨrik. ");
INSERT INTO nwi_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Kɨni Sol rhekɨmter mɨn, mərha, məm rɨpəh nəmien nar. Ror pən khavəh kwermɨn mhakɨr in mhavən apa Damaskes. ");
INSERT INTO nwi_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kɨni raməmɨr nɨpɨg kɨsisər, nɨmrɨn rɨpəh narhayen, mɨpəh nəvɨgɨnien, kɨni mɨpəh nɨnɨmien nar kɨrik. ");
INSERT INTO nwi_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kɨni yermamə kɨrik kape Yesu ramarə apa Damaskes, nhagɨn e Ananaeas. Yesu Yermaru rɨmnokrən kɨn ye nəmrərhavyen kɨrik mɨmə, “Ananaeas.” Kɨni Ananaeas rɨmə, “O-o, Yermaru.” ");
INSERT INTO nwi_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Kɨni Yesu Yermaru rɨni-pən tukun mɨmə, “Takəri-pən swatuk a kamni kɨmə ‘Ratuatuk’ mɨvən mauru-pən imei Judas maiyoh kɨn yemə Tasas kɨrik nhagɨn e Sol. Taktəkun ai in raməhuak. ");
INSERT INTO nwi_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","In rɨmnəm nəmrərhavyen kɨrik məm mɨmə ik nakvən ye nəkwai nimə a mamərəhu-pən kwermɨm iran mə nɨmrɨn tukrɨhuvə mɨn.” ");
INSERT INTO nwi_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Kɨni Ananaeas rɨni-pən tukun mɨmə, “Yermaru. Narmamə khapsaah kwəsəvsao-ta kɨmi yo kɨn kwən en. Mamhani-ərhav norien has kafan yame in ramor-pən kɨmi narmamə yamə mɨne kashatətə iram apa Jerusalem. ");
INSERT INTO nwi_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Kɨni in ruauə ta eikɨn e, jif pris mɨnə kwəseighan-ta kɨn mə in tukrɨraptərəkɨn narmamə mɨnə e kasəhuak kɨmik.” ");
INSERT INTO nwi_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Mərɨg Yesu Yermaru rɨni-pən tukun mɨmə, “Yuvən. Yo yakwɨrpen ta in mə in tukrɨni-ərhav nhagɨk kɨmi narmamə ye tanə pɨsɨn pɨsɨn mɨnə, mɨne namehuə mɨnə, mɨne nəmə Isrel mɨn. ");
INSERT INTO nwi_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Kɨni Yo jakpihajoun in mə tukraməkeikei mɨvəh nəmhəyen tuk nhagɨk.” ");
INSERT INTO nwi_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Məkneikɨn, Ananaeas rɨvən ye nəkwai nimə a. Mərəhu-pən kwermɨn ye Sol mɨmə, “Piak Sol, Yesu Yermaru rɨmnher-pə kɨn yo eikɨn e mə jakuə mor huvə mɨn nɨmrɨm, kɨni pəh Nanmɨn Rhakə rukwar iram. In e Yesu yame In rɨmɨtərhav-pə tuk ik ye swatuk nɨpɨg nɨmnamuə eikɨn e.” ");
INSERT INTO nwi_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Taktəkun əmə, nar kɨrik rəmhen kɨn nɨrɨgəvi kəmam rier ta ye nɨmrɨ Sol, kɨni in rarha mɨn məm nar. Kɨni ye nɨpɨg a kor mɨn baptaes iran. ");
INSERT INTO nwi_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kɨni məvɨgɨn ta, marə mɨvəh mɨn nəsanɨnien. Kɨni Sol rarə mɨn nɨpɨg tɨksɨn apa Damaskes iriə narmamə kape Yesu mɨnə. ");
INSERT INTO nwi_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kɨni nɨpɨg ruauə Damaskes, mɨvən ye nimə kape nofugɨnien kape nəmə Isrel, mamni-ərhav mə Yesu in Ji Kughen. ");
INSERT INTO nwi_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Aikɨn, narmamə kɨsərɨg kɨsakur pɨk kɨn mhamə, “Ah. ?Rhawor? Kwən a in apa kupən in rɨmnamuh nəmə Jerusalem yamə mɨne kamhani nəfrakɨsien ye Yesu. Khamə ta mə ramuə mɨn eikɨn e mə tukrɨpɨk narmamə kape Yesu mɨnə, mɨvən kɨmi jif pris.” ");
INSERT INTO nwi_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Mərɨg nəgkiarien kape Sol ramhaktə mamskai mapita nəgkiarien kape nəmə Isrel. Mamhajoun huvə mə Yesu in Kristo yame Kughen rɨmɨrpen. ");
INSERT INTO nwi_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Sol ramni-əhrav Yesu, nəmə Isrel kamharai mhun nəgkiarien mə tukshopni in, ");
INSERT INTO nwi_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","mərɨg Sol ruɨrkun ta nərɨgien kapəriə. Nɨpɨg fam, yenpɨg-yenpɨg yenaiyu, iriə kɨmɨsərer əswasɨg ye kwəruə ye yerkwanu ai, mə tukshopni Sol. ");
INSERT INTO nwi_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Mərɨg yenaiyu kɨrik, narmamə kape Sol mɨnə khakɨr in mhavən mhavai-pən in ye nɨtɨp ehuə kɨrik, mharuk-pən nərəus iran, mhavi reiwaiyu ye nɨkar kəupə ye yerkwanu a, kɨni Sol rap mamvən. ");
INSERT INTO nwi_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol rap mɨvən apa Jerusalem, mamarkut mə tukrɨkwasɨg kɨn narmamə kape Yesu mɨnə. Mərɨg rɨkiriə rɨmnəsɨk mə rameikuə irəriə mə in yermamə kape Yesu, kɨni kɨmnhagɨn kɨn. ");
INSERT INTO nwi_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kɨni kwən kɨrik, nhagɨn e Banabas, ruə masitu iran, mɨkɨr in mɨvən mwəm aposol mɨnə. Mɨni-pən tuk əriə mə Sol rɨmnəm Yesu Yermaru ye swatuk rəgkiar kɨmin. Kɨni Banabas rɨni-ərhav mɨmə Sol rɨmɨpəh nɨgɨnien tuk nɨni-ərhavyen nhag Yesu apa Damaskes. ");
INSERT INTO nwi_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kɨni Sol rɨmnamarə iriə miriə mamvən yerkwanu mɨnə ye Jerusalem mamətgha kɨn nɨni-ərhavyen nhag Yesu. ");
INSERT INTO nwi_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kɨni maməgkiar kɨmi nəmə Isrel yamə mɨne kamhani nəgkiarien kape nəmə Gris, kɨni masotgoh; kɨni iriə khamə tukhauh in mɨshopni. ");
INSERT INTO nwi_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nɨpɨg in mɨnə tɨksɨn kɨsərɨg, khakɨr Sol mɨsəsok pirə mhavən apa yerkwanu kɨrik nhagɨn e Sisaria, mɨsher-pən kɨn mə tukrɨvən isok apa yerkwanu a Tasas. ");
INSERT INTO nwi_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kwasɨg ikɨn, nəməhuak mɨnə fam rarkurao ikɨn mɨnə Judia mɨne Galili mɨne Sameria, kasarə ye nəmərinuyen. Kɨni Nanmɨn Rhakə ramasitu irəriə, mamor əriə kamhaskai, mamor əriə kamhapsaah. Kɨni iriə kamhasiai Yesu Yermaru. ");
INSERT INTO nwi_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Mərɨg Pita rɨmnəriwək mamvən ikɨn mɨnə; nɨpɨg kɨrik rɨvən mamarha-pən kɨn nəməhuak mɨnə apa Lida. ");
INSERT INTO nwi_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Aikɨn a, rɨmnəm yermamə kɨrik nɨkarɨn rɨmhə. Kwən a reinein nəriwəkien. In rɨmnapɨr əmə meriaji newk eit. Kwən ai nhagɨn e Aeneas. ");
INSERT INTO nwi_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Kɨni Pita rɨni-pən tukun mɨmə, “Aeneas. Taktəkun ai, Yesu Kristo tukror huvə mɨn nɨpram, ik takhuvə mɨn. Takhekɨmter mərpəvɨn-ərpəvɨn kafam nɨmakuə məriwək mamvən.” Taktəkun əmə Aeneas rhekɨmter. ");
INSERT INTO nwi_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kɨni nəmə Lida mɨne Saron kɨsəm in, kɨsarar ye nərɨgien kapəriə mamhakwasɨg kɨn Yesu Yermaru. ");
INSERT INTO nwi_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yerkwanu a Jopa, piraovɨn kɨrik aikɨn ramni nəfrakɨsien ye Yesu, nhagɨn e Tabita Dokas. Pian a, nɨpɨg fam ramor nar huvə, masitu ye yavən hah mɨnə. ");
INSERT INTO nwi_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Nɨpɨg a, rɨmɨvəh nɨmhəyen kɨrik, kɨni mɨmhə. Kəkwi, kor huvə nɨpran kɨrəh kərəhu-pən ye nimə ye kwənmhan apa yerpɨrɨg əgkəp. ");
INSERT INTO nwi_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ikɨn a Jopa ipakə əmə tuk Lida, ror pən, nɨpɨg narmamə kape Yesu mɨnə apa Jopa kɨsərɨg mə Pita raməmɨr apa Lida, kɨsher-pən kɨn yermamə kɨraru kɨravən mwəm in. Mɨweikeikei kɨmin mɨrəmə, “Ǝriwak aihuaa muə.” ");
INSERT INTO nwi_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kɨni Pita rarar mɨkwasɨg kɨn əriu. Kɨni rɨvən mɨtərhav-pən tuk əriə, khakɨr in mɨshaktə mhavən ye kwənmhaan apa yerpɨrɨg əgkəp. Kɨni nɨpiahuaru mɨnə khamhə-tan kɨn əriə, iriə fam khauə, mɨsərer rao rao kɨn. Mɨsasək, mɨshajoun Pita kɨn neipən yame Dokas rɨmɨjir nɨpɨg rɨmnamragh. ");
INSERT INTO nwi_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Kɨni Pita rher-ərhav kɨn əriə, kɨni mənɨmkur məhuak. Mɨwag-pən məm pian ai ruamhə ta mɨni-pən tukun mə, “Tabita, hekɨmter.” Məkneikɨn pian ai rarha-pən məm Pita, kɨni mhekɨmter məkwətə. ");
INSERT INTO nwi_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kɨni Pita rasitu iran mɨvi haktə in, ai rərer. Kɨni Pita rokrən kɨn narmamə yamə mɨne kamhani nəfrakɨsien ye Yesu mɨne nɨpiahuaru yamə mɨne khamhə-tan kɨn əriə khauə, kɨni rhajoun əriə kɨn pian a mə ruəmragh mɨn. ");
INSERT INTO nwi_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kɨni nəvsaoyen kɨn norien a rarkurao fam ye Jopa. Kɨni narmamə khapsaah khauə mɨshatətə ye Yesu Yermaru. ");
INSERT INTO nwi_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Kɨni Pita rarə mɨn apa Jopa ror tu, iriu yermamə kɨrik nhagɨn e Saemon, yame kafan e wok in ramor apnəpeinə ye tɨki kau mə tukjir kor narɨmnar kɨn. ");
INSERT INTO nwi_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Yermamə kɨrik, nhagɨn e Konilias, ramarə apa Sisaria. In yamehuə kɨrik kape mobael mɨnə kamni kɨmə “Mobael kape Itali.” ");
INSERT INTO nwi_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","In mɨne kafan mɨnə iriə kamhasiai pɨk Kughen kape nəmə Isrel. Kɨni in mɨvəhsi-pən mane ehuə kɨmi yavən hah mɨnə. Kɨni nɨpɨg m-fam, raməhuak kɨmi Kughen. ");
INSERT INTO nwi_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nɨpɨg kɨrik, ipakə tuk tri klok yenaiyu, ye nɨpɨg atuatuk kape nəhuakien, rɨmnəm nəmrərhavyen kɨrik, məm huvə mə agelo kɨrik kape Kughen rɨmauə tukun mɨmə, “!Konilias!” ");
INSERT INTO nwi_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kɨni Konilias rɨgɨn pɨk marha-əterɨk iran, mɨni-pən tukun mɨmə, “Ǝwəh, Yermaru. ?Rhawor?” Kɨni agelo a rɨni-pən tukun mɨmə, “Kughen rɨnərɨg ta nəhuakien kafam. Mɨnəm ta norien mɨnə kafam, mə ik nɨmnasitu ye yavən hah mɨnə. Kɨni In ramərɨg ik. ");
INSERT INTO nwi_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Taktəkun ai, ik takher-pən kɨn narmamə tɨksɨn khavən apa yerkwanu a Jopa, mhakɨr yermamə kɨrik mhauə ikɨn e. Yermamə a, nhagɨn əgkəp e Saemon Pita. ");
INSERT INTO nwi_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","In ramarə iriu yermamə kɨrik nhagɨn e Saemon yame in yermamə kape norien narɨmnar kɨn tɨki kau. Nimə kafan ramərer ye nɨkar-kar tahik.” ");
INSERT INTO nwi_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Kɨni agelo a rəgkiar fam, mapta iran. Məkneikɨn Konilias rokrən kɨn kafan yasitu mir kɨraru mɨne mobael kɨrik yame ramsiai Kughen kape nəmə Isrel, mamasitu mɨn iran, mə irisɨr tukrhuə mɨrhəm. ");
INSERT INTO nwi_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","In rhoprai-pən nəmrərhavyen a kɨmi ərisɨr. Kɨni mher-pən kɨn ərisɨr kɨrhɨvən apa Jopa. ");
INSERT INTO nwi_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kəni rəkwamɨr kɨn, yerkweiha, nɨpɨg kwərə misɨr a karhəriwak hanə marhɨvən ye swatuk, ipakə əmə krhɨtərhav-pən apa Jopa, kɨni Pita rhaktə mɨvən apa ye tokrei nimə mə tukrəhuak. ");
INSERT INTO nwi_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Maməhuak mamvən, mɨnəmkərəv pɨk. Kɨni nɨpɨg kamavaan hanə nan, in rəm nəmrərhavyen kɨrik. ");
INSERT INTO nwi_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Məm mə napuə rɨmnəkwag. Rəm nar kɨrik rəmhen kɨn tapolen ehuə rameiwaiyu-pə ye tokrei tanə; kavi rameiwaiyu ye nɨkarɨn mɨnə. ");
INSERT INTO nwi_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Kɨni nar mɨragh mɨnə pɨsɨn pɨsɨn kape tokrei tanə kasərer-pən ye tapolen a: yamə mɨne kaserko, mɨne yamə mɨne kasəriwək, mɨne man mɨnə pɨsɨn pɨsɨn. ");
INSERT INTO nwi_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kɨni rərɨg nəgkiarien kɨrik ramni mɨmə, “Pita. Hekɨmter, muh nar mɨragh mɨnə a kɨrik mən.” ");
INSERT INTO nwi_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Kɨni Pita rɨni-pən tukun mɨmə, “Yermaru. !Yakapəh! To yakpəh nənien narɨmnar mɨnə e yame rəmkɨmɨk ye nɨmrɨm.” ");
INSERT INTO nwi_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kɨni mərɨg nəgkiarien a rɨmə, “Takpəh nɨniyen mə nar kɨrik rəmkɨmɨk yame Yo, Kughen, yakamni mə rhuvə əmə, rɨpəh nəmkɨmɨkien.” ");
INSERT INTO nwi_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Kɨmɨwəgkiar tuk narɨmnar mɨnə a m-kɨsisər; kwasɨg ikɨn, kɨrəhsi-ta tapolen a, rhaktə mɨvən ye neai. ");
INSERT INTO nwi_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Kɨni Pita ramarkut hanə mə tɨkrɨrkun nɨprai nəmrərhavyen yame in rɨmnəm, mərɨg kwərə misɨr yamə misɨr e Konilias rɨmnher-pən kɨn ərisɨr, kɨrhuə. Mɨrhaiyoh kɨn nimə kape Saemon, mɨrhuə, mɨrhəm. Kɨni marhərer ye kwəruə ye nimə kafan. ");
INSERT INTO nwi_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Kɨni mɨrhokrən mɨrhɨmə, “!Ei! ?Yermamə kɨrik eikɨn e nhagɨn e Saemon Pita uə?” ");
INSERT INTO nwi_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Kɨni Pita ramətərɨg hanə kɨn nɨprai nəmrərhavyen kafan, mərɨg Nanmɨn Rhakə rɨni-pən tukun mɨmə, “!Ei! Ǝrɨg-ru. Kwərə misɨr kɨsisər e karharha kɨn ik. ");
INSERT INTO nwi_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Hekɨmter, meiwaiyu mɨvən məm ərisɨr. Mərɨg rɨkim tukrɨpəh nəsɨkien mə to nakpəh nɨkwasɨgien kɨn ərisɨr, mərɨg in ai Yo e yɨmnher-pə kɨn ərisɨr mə tukrhurə.” ");
INSERT INTO nwi_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Məkneikɨn Pita reiwaiyu mɨvən mɨni-pən tuk ərisɨr mə, “Yo e yermamə yame kɨmisɨr nakarharhakɨn. ?Nakrhɨmə rhawor?” ");
INSERT INTO nwi_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Kɨni kɨrhɨmə, “Yamehuə kɨrik kape mobael, nhagɨn e Konilias, rɨmnher-pə kɨn əmasɨr. In yemə atuatuk kɨrik; ramsiai Kughen kape nəmə Isrel. Kɨni nəmə Isrel kharkun mə in ror məkna. Agelo kɨrik kape Kughen ruə mɨni-pən tukun mə tukrokrən kɨn ik, takvən apa iman yerkwanu. Pəh in rərɨg nəgkiarien kafam.” ");
INSERT INTO nwi_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Məkneikɨn Pita rɨkɨr ərisɨr mhavən ye nəkwai nimə. Yenaiyu, kɨsapɨr aikɨn. Kəni rɨkwamer kɨn, Pita rarar mɨkwasɨg kɨn kwərə misɨr a. Kɨni nəməhuak mɨnə mɨn tɨksɨn ye yerkwanu a Jopa, khakwasɨg mɨn kɨn. ");
INSERT INTO nwi_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Kəni rɨkwamer mɨn kɨn, rɨvən mɨtərhav pən yerkwanu a Sisaria. Kɨni aikɨn a, Konilias mɨne kafan mɨnə, mɨne kafan narmamə yamə mɨne in rɨmnokrən kɨn əriə, kaseito kɨn Pita. ");
INSERT INTO nwi_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nɨpɨg Pita rɨmavən yerkwanu kape Konilias, Konilias ruə mənɨmkur ye nɨhu Pita mɨvəhsi-pən nɨsiaiyen kɨmin. ");
INSERT INTO nwi_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Mərɨg Pita rɨvəh-si haktə mɨn in, mɨni-pən tukun mɨmə, “Hekɨmter. Yo mɨn yo yermamə əmə.” ");
INSERT INTO nwi_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kwəgkiar, mɨravən apa imə, kɨni Pita rəm mə narmamə khapsaah kwənhauə ta aikɨn. ");
INSERT INTO nwi_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kɨni Pita rɨni-pən tuk əriə mɨmə, “Kɨmiə m-fam nakharkun huvə mə natuakəmien kapəmawə ramni-əhu mə nəmə Isrel tukhapəh nhavənien ye nəkwai nimə yamə mɨne pəh nien mə kwənərəus kape nəmə Isrel kɨni mhapəh nɨsəriwak-kwisien. Mərɨg Kughen rɨmnhajoun yo mə jakpəh nɨniyen mə narmamə tɨksɨn kɨsəmkɨmɨk ye nɨmrɨn uə kɨsahas. ");
INSERT INTO nwi_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ror pən, nɨpɨg naksokrən kɨn yo mə jakuə eikɨn e, yakpəh nɨpəhyen, yakarar əmə mamuə. Mərɨg yakmə jakaiyoh əmiə mɨmə, ‘?Kɨmiə nɨmɨsokrən kɨn yo tuk naha?’” ");
INSERT INTO nwi_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɨni Konilias rɨni-pən tukun mɨmə, “Nɨpɨg kɨsisər ruə mɨvən, ye tri klok yenaiyu, ror məkneikɨn taktəkun, yo yɨmnaməhuak ye nəkwai nimə kafak. Taktəkun əmə yermamə kɨrik yame kafan neipən raməsiə, rɨmatərhav-pə, mərer ye nɨmrɨk. ");
INSERT INTO nwi_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Mɨni-pə tuk yo mɨmə, ‘Konilias. Kughen rɨnərɨg ta nəhuakien kafam. Rɨmnəm ta norien mɨnə kafam, mə ik nɨmnasitu ye yavən hah mɨnə. ");
INSERT INTO nwi_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Taktəkun ai, ik takher-pən kɨn narmamə tɨksɨn khavən apa yerkwanu a Jopa, mhakɨr yermamə kɨrik mhauə eikɨn e. Yermamə a, nhagɨn əgkəp e Saemon Pita. In ramarə iriu yermamə kɨrik nhagɨn e Saemon yame kafan e wok nor-apnəpəneiyen ye tiki kau tuk nɨjirien mor narɨmnar kɨn. Nimə kafan ramərer ye nɨkar-kar tahik.’ ");
INSERT INTO nwi_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ror pən taktəkun əmə yɨmnher-pre kɨn kwərə misɨr e, mə tukrhɨkɨr ik mɨrhuə. Kɨni rhuvə pɨk mə nakuauə. Taktəkun ai kɨmawə fam yaksərer ye nɨmrɨ Kughen, mamhawhin əmə mə jaksərɨg naha nəgkiarien yame Kughen rɨmɨvəhsi-pre kɨm ik mə ik takni tuk əmawə.” ");
INSERT INTO nwi_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kɨni Pita raməgkiar mamni mɨmə, “Taktəkun yakwɨrkun mə Kughen ramor rəm nəmhen kɨmi nəmə kantri pɨsɨn mɨnə fam, ");
INSERT INTO nwi_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","kɨni rɨkin ragien tuk narmamə ikɨn mɨnə fam yamə mɨne kamhasiai In, kɨni mɨsor nar yame ratuatuk. ");
INSERT INTO nwi_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","“Kɨmiə nakwənharkun ta nəgkiarien yame Kughen rɨmɨvəhsi-pən kɨmi nəmə Isrel. Nəgkiarien Huvə a ramni-ərhav mə narmamə tukhavəh nəmərinuyen tuk nhatətəyen ye Yesu Kristo, yame In Yermaru kape narmamə mɨnə fam. ");
INSERT INTO nwi_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kɨni kɨmiə nakharkun narɨmnar yame rɨmatərhav-pə e Judia. Jon Baptaes rɨmɨni-ərhav baptaes, kwasɨg ikɨn, narɨmnar mɨnə a rɨpirikakun. ");
INSERT INTO nwi_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Rəmhen kɨn Kughen rɨmnher-pə kɨn Nanmɨn Rhakə kɨmi Yesu, mɨvəhsi-pən nəsanɨnien kɨmin. Kɨni ai, Yesu rɨmnarkurao, mamor huvə pən kɨmi narmamə. Kɨni narmamə yamə mɨne kasəmɨr ye kwermɨ Setan, Yesu rɨvəh-si ta əriə, mor huvə əriə, meinai Kughen ramarə iran. ");
INSERT INTO nwi_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Kɨni kɨmawə yɨmɨsəm narɨmnar yame rɨmnor apa Jerusalem mɨne yerkwanu mɨnə tɨksɨn apa Judia. Kɨni yɨmɨsəm mɨn mə kɨmɨsarkwətərəkɨn-pən In ye nai kamarkwao-kɨn, kɨni rɨmhə. ");
INSERT INTO nwi_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Mərɨg ye nɨpɨg yame ror kɨsisər kɨn, Kughen rɨmnor In rɨmragh mɨn. Kɨni mor əpu In kɨmi narmamə mə tuksəm mə In rɨmɨmragh mɨn. ");
INSERT INTO nwi_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Pəh nien mə narmamə mɨnə fam kɨmɨsəm In, mərɨg narmamə əmə iriə e yame Kughen rɨmɨrpen ta əriə mə tuksəm. Kɨmawə e yɨmɨsəvɨgɨn mhanɨm kwis kɨmawə min nɨpɨg rɨmɨmragh mɨn ye nɨmhəyen. ");
INSERT INTO nwi_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Kɨni Yesu a in a rɨmɨni-pə tuk əmawə mɨmə jakasəkeikei mhani-ərhav nhagɨn, mhani-ərhav mə Kughen rɨmɨvəh-si haktə In mə In tukrəkir narmamə yamə mɨne kamhamragh, mɨne yamə mɨne kwənhamhə ta. ");
INSERT INTO nwi_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Kɨni profet mɨnə kupən kɨmnhani ta In, mhamə narmamə mɨnə fam yamə mɨne kashatətə ye Kughen, Kughen tukrɨvəh-si ta narpɨnien kape təvhagə hah kapəriə ye nhagɨn.” ");
INSERT INTO nwi_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita raməgkiar hanə, Nanmɨn Rhakə reiwaiyu ye narmamə yamə mɨne kasətərɨg kɨn in. ");
INSERT INTO nwi_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Kɨni nəmə Isrel yamə mɨne kamhani nəfakɨsien ye Yesu yamə mɨne kɨmnhatərhav apa Jopa iriə Pita, mhauə, mɨsəm, kɨsakur pɨk mə Kughen rɨvəhsi-pən ta nɨhuvəyen a Nanmɨn Rhakə kɨmi narmamə yamə mɨne pəh nien mə nəmə Isrel. ");
INSERT INTO nwi_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kɨsakur pɨk kɨn meinai kɨmɨsərɨg narmamə mɨnə a kasəgkiar ye nəgkiarien kape tanə pɨsɨn pɨsɨn mɨnə, masəgnəgɨn Kughen. Kɨni Pita rɨni-pən tuk əriə mɨmə, ");
INSERT INTO nwi_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Narmamə mɨnə e kwənhavəh ta Nanmɨn kape Kughen rəmhen kɨn yame kɨtawə kɨmnhavəh. ?Pa nhagɨn tukrətapɨg kɨn əriə mɨmə tukhapəh nɨsorien baptaes ye nu?” ");
INSERT INTO nwi_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Kɨni in rɨmə iriə tuksor baptaes ye nhag Yesu Kristo. Kɨni iriə kɨmɨsaiyoh-pən in mhamə in tukrarə kəskəh mɨn iriə mɨn. ");
INSERT INTO nwi_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Kɨni aposol mɨnə mɨne nəməhuak mɨnə ye yerkwanu mɨnə ye Judia kɨmɨsərɨg nəvsaoyen mə nəmə mɨnə a pəh nien mə nəmə Isrel iriə mɨn kamhani nəfrakɨsien ye nəgkiarien kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kɨni Pita rɨvhiak mɨvən Jerusalem, mərɨg nəməhuak yamə mɨne khani mhamə tukaməkeikei kɨvəh nao kɨmi narmamə, iriə kɨmnhani nɨkarɨn, ");
INSERT INTO nwi_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","mhani mhamə, “?Rhawor e ik nɨmavən ye nimə kape nəmə kɨpəh nɨvəhyen nao kɨmi əriə, maməvɨgɨn kɨmiə miriə?” ");
INSERT INTO nwi_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kɨni Pita rɨmnəvsao kɨmi əriə kɨn narɨmnar fam yame rɨmnəm apa Sisaria. ");
INSERT INTO nwi_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Mamni mɨmə, “Nɨpɨg yɨmnaməmɨr apa Jopa, maməhuak məm nəmrərhavyen kɨrik. Məm nar kɨrik rəmhen kɨn tapolen rɨmneiwaiyu-pə ye tokrei tanə; kavi rameiwaiyu ye nɨkarɨn mɨnə reiwaiyu ipakə tuk yo. ");
INSERT INTO nwi_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Yakarha-pən huvə a tapolen a, kɨni məm nar mɨragh mɨnə pɨsɨn pɨsɨn kape tokrei tanə kasərer: yamə mɨne kaserko, masəriwək, mɨne man mɨnə pɨsɨn pɨsɨn. ");
INSERT INTO nwi_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kɨni yɨmnərɨg nəgkiarien kɨrik ramni mɨmə, ‘Pita. Hekɨmter, muh nar mɨragh mɨnə a kɨrik mən.’ ");
INSERT INTO nwi_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mərɨg yo yakmə, ‘Yermaru. !Yakapəh! To yakpəh nənien narɨmnar mɨnə e yamə mɨne kɨsəmkɨmɨk ye nɨmrɨm.’ ");
INSERT INTO nwi_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Kɨni yɨmnərɨg mɨn nəgkiarien a rɨsɨ-pən apa ye rao ye neai mɨmə, ‘Takpəh nɨniyen mə nar kɨrik rəmkɨmɨk yame Yo, Kughen, yakamni mə rhuvə əmə, rɨpəh nəmkɨmɨkien.’ ");
INSERT INTO nwi_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Yɨmawəgkiar tuk narɨmnar mɨnə a m-kɨsisər; kwasɨg ikɨn, kɨrəh-si ta tapolen a, rhaktə mɨvən ye neai. ");
INSERT INTO nwi_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Ye nɨpɨg atuatuk əmə a, kwərə misɨr kɨsisər krhɨtərhav-pə ye nəkwai nimə yame yakasəmɨr ikɨn. Iriə apa Sisaria kɨmɨsher ta kɨn ərisɨr mə tukrhuə mɨrhɨkɨr yo mɨrhuvən apa Sisiria. ");
INSERT INTO nwi_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Kɨni Nanmɨn kape Kughen rɨmɨni-pə tuk yo mɨmə, ‘Rɨkim tukrɨpəh nəsɨkien mə to nakpəh nɨkwasɨgien kɨn ərisɨr.’ Kɨni piautawə mɨnə iriə sikis kɨmnhakwasɨg kɨn yo, mhavən, mɨsauru-pən ye nəkwai nimə kape Konilias. ");
INSERT INTO nwi_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kɨni in rɨni-pə tuk əmawə mə in rɨmnəm agelo kɨrik ruə marer ye nəkwai nimə kafan mɨni-pən tukun mɨmə, ‘Takher-pən kɨn narmamə tɨksɨn khavən apa Jopa tuk kwən kɨrik yame nhagɨn əgkəp e Saemon Pita. ");
INSERT INTO nwi_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","In tukrɨni-pre nəgkiarien kɨrik tuk əmiə, pəh Kughen tukrɨvəh mɨragh ik mɨne kafam narmamə mɨnə kɨn.’ ");
INSERT INTO nwi_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Kɨni nɨpɨg yɨmɨsəgkiar hanə, Nanmɨn kape Kughen rɨmneiwaiyu ye nəmə tanə pɨsɨn pɨsɨn mɨnə rəmhen kɨn yame rɨmauə irətawə e nəmə Isrel kupən. ");
INSERT INTO nwi_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kɨni rɨkik raməsɨk nəgkiarien kape Yermaru kapətawə yame rɨmɨni kupən mɨmə, ‘Jon rɨmnor baptaes irəmiə kɨn nu; mərɨg tukrɨpəh norien tu, Kughen tukror baptaes irəmiə kɨn Nanmɨn Rhakə.’ ");
INSERT INTO nwi_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kɨni tukmə Kughen rɨvəhsi-pən nɨhuvəyen a Nanmɨn Rhakə kɨmi nəmə tanə pɨsɨn pɨsɨn mɨnə rəmhen kɨn yame rɨmɨvəhsi-pə kɨmi ətawə nɨpɨg kɨtawə kɨmnhani nəfrakɨsien ye Yermaru Yesu Kristo, rhuvə əmə. Yo yermamə əmə, to yakpəh nɨni-əhuyen Kughen tuk naha nhagɨn yame In rorkeikei mə tukror mɨn kɨmi nəmə tanə pɨsɨn pɨsɨn mɨnə.” ");
INSERT INTO nwi_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nɨpɨg iriə kɨsərɨg nəgkiarien a kape Pita, kɨsapnapɨg. Mɨsəgnəgɨn Kughen, mhani mhamə, “Tukmə ror Kughen rɨmnor ta swatuk tuk narmamə yamə mɨne pəh nien mə nəmə Isrel, iriə mɨn kharkun nɨsararien ye nərɨgien kapəriə tuk təvhagə hah kapəriə, pəh Kughen tukrɨvəh mɨragh əriə.” ");
INSERT INTO nwi_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kɨni mərɨg, kupən, nɨpɨg Sol mɨne in mɨnə tɨksɨn kɨmɨshopni Steven, mɨsarar masor-ahas-pən mɨn kɨmi narmamə yamə mɨne kɨshatətə ye Yesu, kɨsap, mhavən isok. Iriə tɨksɨn kɨsap mhavən apa Fonisia, tɨksɨn apa Saepras, kɨni tɨksɨn khauə apa Antiok. Kɨni mamhani-ərhav Nəgkiarien Huvə kape Yesu. Kɨni mərɨg kasəgkiar əmə kɨmi nəmə Isrel. ");
INSERT INTO nwi_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Mərɨg tɨksɨn, iriə nəmə Saepras, mɨne Saerin, kɨmnhauə apa Antiok, kɨni mamhani-ərhav mɨn Nəgkiarien Huvə kape Yesu Yermaru tuk nəmə Gris. ");
INSERT INTO nwi_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kɨni Kughen rɨmnasitu irəriə, narmamə khapsaah kɨsarar ye nərɨgien kapəriə, mamhani nəfrakɨsien ye Yesu. ");
INSERT INTO nwi_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nəməhuak mɨnə apa Jerusalem kɨmɨsərɨg nəvsaoyen kɨn, kɨni kɨsher-pə kɨn yermamə kɨrik nhagɨn e Banabas ruə e Antiok. ");
INSERT INTO nwi_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Banabas ruə mɨtərhav-pə, məm mə Kughen ruɨvəhsi-pən ta nɨhuvəyen kɨmi nəmə aikɨn, kɨni Banabas, rɨkin ragien pɨk. Mamor kwirɨg kɨmi əriə mə tukasəkeikei mhavəh tɨm tɨm Yesu Yermaru yerkiriə m-fam. ");
INSERT INTO nwi_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas in yemə huvə kɨrik. Nanmɨn kape Kughen rukwar iran. Kɨni nhatətəyen kafan rɨskai. In ravi narmamə khapsaah kamhakwasɨg kɨn Yesu Yermaru. ");
INSERT INTO nwi_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kɨni kwasɨg ikɨn, Banabas rɨvən apa Tasas mamarha-kɨn Sol. ");
INSERT INTO nwi_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nɨpɨg rɨmnəm Sol, rɨkɨr, iriu mɨravən apa Antiok mwarə apaikɨn kape newk kɨrikianə. Mwofugɨn iriə nəməhuak mɨnə aikɨn, mawəvəhwag kɨmi narmamə khapsaah. Ikɨn a Antiok, kɨmɨrikakun kɨni narmamə kape Yesu Kristo mɨnə kɨmə, “Kristin.” ");
INSERT INTO nwi_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ye nɨpɨg a, profet mɨnə tɨksɨn khatərhav a Jerusalem mhavirə mhavən Antiok. ");
INSERT INTO nwi_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Iriə kɨrik, nhagɨn e Akabus, Nanmɨn Rhakə ramarə iran, rɨmɨrkun məkupən mɨmə sweiwei ehuə kɨrik tukruh narmamə m-fam. (Kɨni profesi e rɨmauə mɨnor nəfrakɨsien kɨn ye nɨpɨg yame Klodias rɨmnamehuə ye nəmə Rom). ");
INSERT INTO nwi_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kɨni narmamə kape Yesu mɨnə apa Antiok kɨmɨsorkeikei mə tuksasitu ye narmamə kape Yesu mɨnə apa Judia, mɨsher-pən kɨn mane kɨrikianə kɨrikianə yame ratuatuk ye nɨrkunien kapəriə. ");
INSERT INTO nwi_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Kɨsor məknakɨn, mɨsərəhu-pən mane a ye kwermɨ Banabas mɨne Sol mə tukravən mwərəhu-pən ye kwermɨ elda mɨnə ye niməhuak apa Jerusalem. ");
INSERT INTO nwi_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ye nɨpɨg a, king kape nəmə Rom, nhagɨn e Herod, rɨmɨraptərəkɨn nəməhuak mɨnə tɨksɨn mɨmə tukruh əriə. ");
INSERT INTO nwi_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Mɨni-pən tuk kafan narmamə mɨnə mə tukhavən mharaptərəkɨn Jemes, piau Jon, mɨsərəru-ta kapən kapə. ");
INSERT INTO nwi_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kɨni rɨmnhopni-ta Jemes məm mə nəmə Isrel, rɨkiriə ragien tukun, rarə mɨni-pən mɨn tuk kafan narmamə mɨnə mə tukharaptərəkɨn mɨn Pita. Kɨraptərəkɨn Pita ye nɨpɨg kape nəvɨgɨnien ehuə e kamni kɨmə “Nənien Bred yame yis rɨrkək iran.” ");
INSERT INTO nwi_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kharaptərəkɨn Pita, mhrəhsi-pən ye kalabus. Kɨni Herod rɨmɨni mə mobael 16 tuksərer əswasɨg kɨn, kuas kuas ye aoa mɨnə fam, yenpɨg mɨne yeraan. Herod rɨkin raməsɨk mɨmə nɨpɨg nəvɨgɨnien ehuə tukror infamien, in tukrɨkɨr Pita muə ramərer ye nɨmrɨ mɨrh. ");
INSERT INTO nwi_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Mərɨg nɨpɨg Pita raməmɨr hanə ye kalabus, nəməhuak mɨnə kasəhuak əusɨk-əusɨk tukun. ");
INSERT INTO nwi_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Kɨni tɨkəni rəkwamɨr kɨn, Herod rɨmə ta mə tukrərɨp Pita ye nɨmrɨ mɨrh. Mərɨg yenpɨg, Pita raməmɨr ye kalabus mamapɨr ye kwerkwan ye mobael mir kɨraru. Karkwəji in kɨn jen kɨraru: kɨrik raməker-pən ye kwermɨ mobael kɨrik, kɨrik raməker-pən ye kɨrik. Kɨni mobael kɨraru kawarer ye kwəruə mawarha tukun. ");
INSERT INTO nwi_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Taktəkun əmə, agelo kape Kughen rɨtɨrhav-pə tukun. Kɨni məsiə rakhak ye nəkwai kalabus. Kɨni agelo a rɨnhai kwerkwai Pita mɨmə, “Ei. !Ǝrer aihuaa!” Taktəkun əmə jen mir yame e kawəker-pən ye kwermɨ Pita kɨmɨraier-ta atuk. ");
INSERT INTO nwi_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kɨni agelo ai rɨni-pən tukun mɨmə, “Vəhsi-pən kafam sot mɨne sandel.” Kɨni Pita ror nar yame agelo rɨmɨni. Kɨni agelo a rɨni-pən tukun mə, “Takvəhsi-pən kafam kot, mɨkwasɨg kɨn yo.” ");
INSERT INTO nwi_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Kɨni Pita rɨkwasɨg kɨn, mɨratərhav ye nəkwai kalabus. Mərɨg in rɨpəh nɨrkunien mə nar yame agelo a ramor iran ror nəfrakɨsien kɨn; rɨkin rəsɨk mə ta mə in raməmrərhav əmə. ");
INSERT INTO nwi_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Kɨni iriu kɨrauə mwapita mobael yame ramərer əkupən mamarha, kɨni mɨrauə mwapita yame ror kɨraru kɨn. Kwasɨg ikɨn, kɨrauə mɨratərhav-pə ye kwəruə yame kɨmnor kɨn aean. Kwəruə a kamtərhav-pən ikɨn, kamavən Jerusalem. Kɨni ye nɨpɨg a, kwəruə ai rəhitə atuk, kɨni iriu kɨratərhav. Mawəriwak ye swatuk mɨravən. Taktəkun əmə agelo ai rəta ye Pita mamvən. ");
INSERT INTO nwi_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Məkneikɨn, Pita, rɨkin rarə, kɨni rɨmə, “Ei. Yakəm yakɨrkun mə nar e in ror nəfrakɨsien kɨn. Yesu Yermaru rɨmnher-pə kɨn agelo kafan mə tɨkrɨrəh-si ta yo ye kwermɨ King Herod mɨne narɨmnar mɨnə yame nəmə Isrel khamə tuksor irak.” ");
INSERT INTO nwi_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pita rəm rɨrkun mə Kughen ruɨrɨsɨn in, taktəkun əmə, rɨvən imei Meri, nɨsɨn Jon Mak. Narmamə khapsaah kwənhauə ta ye nəkwai nimə a masəhuak. ");
INSERT INTO nwi_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kɨni Pita rəsɨk-əsɨk tapɨg ye nimə a. Kɨni yasitu kɨrik, nhagɨn e Roda, ruə mə tukrəhitə. ");
INSERT INTO nwi_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kɨni in mərɨg rɨki Pita, ruɨrkun mə Pita a; kɨni rɨkin ragien pɨk tukun, kɨni mərukɨn nəhitəyen, kɨni maiyu əmə mɨvən mɨni-əsah-pən iran mɨmə, “!Ei! Narɨmnə əpə. Pita ramərer ye kwəruə apa iruə.” ");
INSERT INTO nwi_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Kɨni iriə khani-pən tukun mhamə, “Nɨkam. Nakeno-eno.” Kɨni raməkeikei mamni mɨmə, “Nɨkam. Yo yakamni əfrakɨs.” Kɨni iriə khani-pən tukun mhamə, “Nɨkam. ?Tukmə ror agelo əmə kafan uə?” ");
INSERT INTO nwi_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Mərɨg Pita ramərer hanə iruə maməsɨk-əsɨk tapɨg. Kɨni iriə khavən mɨsəhitə, mɨsəm in, kɨsakur kɨn. ");
INSERT INTO nwi_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Kɨni Pita rɨmɨni-əhu əriə mə tukhapim. Kɨni maməvsao kɨn Yesu Yermaru rɨmɨvəhsi-ərhav in ye kalabus. Kɨni mɨmə, “Taksəvsao kɨn kɨmi Jemes mɨne kɨtawə mɨnə tɨksɨn.” Rəgkiar ta kɨni map. ");
INSERT INTO nwi_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kəni rɨkwamer kɨn, yenpɨg-yenpɨg, mobael yamə mɨne kasarha tuk Pita ye kalabus kasaiyoh-aiyoh əriə mɨnə kɨn, mərɨg kɨseinein mə naha nhagɨn rɨmnor Pita. ");
INSERT INTO nwi_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Kɨni King Herod rɨni-pən tuk əriə mə tukhavən mɨsarhakɨn Pita; mərɨg khapəh nɨsəmien. Kɨni ai, King Herod rərɨp mobael mɨnə a ye nɨmrɨ mɨrh, mɨvəhsi-pən narpɨnien kɨmi əriə mə tukasəkeikei mhamhə. Kwasɨg ikɨn, King Herod rɨmatərhav Judia, məsok pirə, mɨvən apa kwənmhan kɨrik kamni kɨmə, Sisaria. ");
INSERT INTO nwi_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ye nɨpɨg a, narmamə ye taon mir e Taea mɨne Saedon kɨmɨsotgoh iriə min, kɨni rɨni-əhu nəvɨgɨnien mə tukrɨpəh nherpən-ien kɨn. Kɨni iriə kɨmɨsaiyoh nasituyen kɨn Blastus, yame in ramehuə ye nautə kape King Herod. Kɨmnhavi nərɨgien kafan mə tukrokrən kɨn Herod ruə, pəh kɨsərəhu nəmərinuyen iriə min, mə tukrəta mɨn ye nəvɨgɨnien rɨvən mɨn kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Kɨni kwənhauə ye nɨpɨg yame Herod rɨmɨni mə tukrəm əriə iran, kɨni rɨvəhsi-pən neipən huvə kafan yame ramhajoun mə in ramarmaru; mɨvən məkwətə ye kwənmhan kape king, mɨvəhsi-pən nəgkiarien kafan kɨmi əriə. ");
INSERT INTO nwi_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Kɨni iriə kɨsokrən apomh mhamə, “Yermamə e raməgkiar, pəh nien mə yermamə əmə, mərɨg in kughen kɨrik.” ");
INSERT INTO nwi_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Mərɨg Herod rɨpəh nɨvəhsi-haktəyen Kughen, məkneikɨn, Kughen rher-pə kɨn kafan agelo ror Herod rɨmɨr. Kɨni wom mɨnə kɨsən tɨpeiwə iran, rɨmhə. ");
INSERT INTO nwi_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ye nɨpɨg a, nəgkiarien kape Kughen rarkurao. Narmamə khapsaah khani nəfrakɨsien iran. ");
INSERT INTO nwi_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Kɨni Banabas mɨne Sol kwəgkiar fam apa Jerusalem, mɨrarerɨg-pə Antiok, mɨrəkɨr kwən kɨrik nhagɨn e Jon Mak irisɨr min. ");
INSERT INTO nwi_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ye niməhuak apa Antiok, profet mɨnə mɨne nəmhajoun mɨnə kasarə aikɨn. Iriə e: Banabas, mɨne Sol, mɨne Simeon (yame kamni kɨmə yemapɨg), mɨne Lusias yemə Saerin, mɨne Manaen (apa kupan in yermamə kɨrik kape King Herod Antipas). ");
INSERT INTO nwi_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Kasarə, kɨni nɨpɨg kɨrik, kɨsəpəh nəvɨgɨnien masəhuak kɨmi Kughen. Kɨni Nanmɨn Rhakə ruə mɨni-pən tuk əriə mɨmə, “Yakorkeikei mə takhavəh-si haktə Banabas mɨne Sol pəh iriu tukwor nar yame yakamokrən kɨn əriu mə tukwor.” ");
INSERT INTO nwi_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kɨmɨsor infamien ye nəhuakien mɨne nɨpəhyen nəvɨgɨnien, kɨni mɨsərəhu-pən kwermɨriə ye kapəriu kapə tuk nɨwəhsihaktəyen əriu. Kɨni mɨsher-pən kɨn əriu mə tukravən. ");
INSERT INTO nwi_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Nanmɨn Rhakə rɨvəhsihaktə-ta Banabas mɨne Sol, kɨni kwəsok pirə mɨravən apa Selusia, kɨni mɨwat-pən ye nəkwai rao ehuə kɨrik, mɨravən apa kwaji tanə kɨrik kamni kɨmə “Saepras.” ");
INSERT INTO nwi_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Mɨravən mɨratərhav-pən apa Saepras, mɨravən mɨrəvhiak apa yerkwanu kɨrik kamni kɨmə “Salamis.” Ikɨn aikɨn a, karəni-ərhav nəgkiarien kape Kughen ye nəkwai nimə kape nofugɨnien mɨnə kape nəmə Isrel. Kɨni Jon Mak rɨmnasitu irəriu. ");
INSERT INTO nwi_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kɨni irisɨr kɨrharkurao ye tanə a, mɨrhɨvən mɨrhatərhav-pən mɨn yerkwanu a Pafos. Kɨni ikɨn aikɨn a, kɨrhəm kleva kɨrik, nhagɨn e Bajisas. In yemə Isrel, yame in profet eikuə kɨrik. ");
INSERT INTO nwi_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Kleva a, in yasitu kɨrik kape gavman kape tanə a. Yamehuə a, nhagɨn e Sejas Polas, nɨrkunien kafan rehuə. Kɨni in rokrən kɨn Banabas mɨne Sol mə tukrauə mwəm in, meinai in rorkeikei mə tukrərɨg nəgkiarien kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Mərɨg kleva a, Bajisas, ramni hah Banabas mɨne Sol. (Nhag kleva a, ye nəgkiarien kape nəmə Gris, kamni kɨmə “Elimas, ” nɨpran ramni mə “kleva.”) Ramarkut mə tukrukreikɨn nərɨgien kape yamehuə a, mə tukrɨpəh nɨniyen nəfrakɨsien ye Yesu. ");
INSERT INTO nwi_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Kɨni Sol, yame nhagɨn mɨn kɨrik kamni kɨmə Pol, Nanmɨn kape Kughen ramarə iran. Rarha-pən məm kleva a Elimas, ");
INSERT INTO nwi_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","mɨni-pən tukun mɨmə, “Ik kwajikovə atuatuk kape Setan. Ik nakamni hah narɨmnar fam yame rhuvə. Ik yermamə kape təvhagə hah mɨne neikwəyen. Nɨpɨg m-fam nakaukreikɨn swatuk atuatuk kape Kughen. ");
INSERT INTO nwi_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Taktəkun əmə, kwermɨ Kughen tukrɨrap ik, nɨmrɨm tukrɨpɨs. Takpəh nəm-pipom-ien nɨkhakien.” Taktəkun əmə kleva ai rəm nətokien rəpɨgnap muə muvrɨg əpɨs nɨmrɨn. Kɨni in rɨmnəriwək mamərav-ərhav əmə mamarkut mɨmə yermamə kɨrik tɨkrɨvəh kwermɨn mɨkɨr in. ");
INSERT INTO nwi_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kɨni gavman a rəm nar a rɨmnor, rakur pɨk kɨn nəvhagien kape Pol mɨne Banabas, kɨni mamni nəfrakɨsien ye nəgkiarien kape Yesu Yermaru. ");
INSERT INTO nwi_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Kɨni Pol mɨne in mɨnə tɨksɨn kɨmnhavən apa Pafos, mhavən ye rao ehuə kɨrik, mhavən apa kwənmhan kɨrik kamni kɨmə Pamfilia. Mhavən mhavhiak ye yerkwanu kɨrik kamni kɨmə Pega. Ikɨn aikɨn a, Jon Mak rɨmnəpəh əriə ikɨn mɨrerɨg mamvən apa Jerusalem. ");
INSERT INTO nwi_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Kɨni iriə kɨsarar apa Pega, mɨseriwək mamhavən apa yerkwanu kɨrik kamni kɨmə Antiok, apa Pisidia. Ye nɨpɨg kape Sabat, khavən ye nəkwai niməhuak kape nəmə Isrel, mɨsəkwətə. ");
INSERT INTO nwi_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kəvheikɨn nəkwəkwə kape Loa kape Moses mɨne nəkwəkwə kape profet mɨnə kupən, kɨni kwasɨg ikɨn, namehuə kape niməhuak mɨnə kɨsaiyoh əriə mhamə, “Yo mɨnə tɨksɨn. Tukmə kɨmiə nakamhavəh nəgkiarien kɨrik tuk nərɨp-tɨm-tɨmien nəmə iku, hani-ərhav.” ");
INSERT INTO nwi_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Kɨni Pol rhekɨmter, mɨni-əhu əriə mə tukhapim, kɨni mɨmə, “Nəmə Isrel, mɨne nəmə iku pɨsɨn pɨsɨn mɨnə yamə mɨne nakhasiai Kughen kape nəmə Isrel, kɨmiə fam taksətərɨg kɨn nəgkiarien kafak. ");
INSERT INTO nwi_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Kupən, Kughen kape nəmə Isrel rɨmɨrpen kaha kapəmawə mɨnə, kɨni nɨpɨg kɨmɨsarə rəmhen kɨn yepsɨpɨs mɨnə Ijip, Kughen rɨvəh-si haktə əriə mor əriə khauə mhapsaah. Ye nəsanɨnien ehuə kafan, In rɨrəhsi-ta əriə ye kwermɨ nəmə Ijip. ");
INSERT INTO nwi_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kɨni khavən mɨsarə ye kwənmhan əkwak mɨseriaji newk foti, masor təvhagə hah; mərɨg Kughen rapəh nɨpəhyen əriə. ");
INSERT INTO nwi_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","In rɨmnor narmamə mɨnə kape nəmə Isrel kamhauh gavman mɨnə kape tanə seven yamə mɨne kasarə ye tanə a Kenan; kɨni mɨvəhsi-pən tanə a kapəriə kɨmi rɨpmawə mɨnə, mə kapəriə. ");
INSERT INTO nwi_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Narɨmnar a rɨmnor rɨvəh nɨpɨg rəmhen kɨn newk 450. “Kwasɨg ikɨn, Kughen rɨvəh-si haktə namehuə kapəriə mɨnə mə tuksarmaru irəriə, mhauə mɨseriaji nɨpɨg kape profet kɨrik nhagɨn e Samuel. ");
INSERT INTO nwi_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nɨpɨg a in a, kɨmɨsaiyoh Kughen mhamə iriə kɨsorkeikei mə tukhavəhsi-haktə king kɨrik kapəriə. Kɨni Kughen rɨvəh-si haktə yermamə kɨrik nhagɨn e Sol, kwajikovə kape Kis. In kwənərəus kape Benjamin. Sol rɨmnehuə irəriə rəmhen kɨn king kapəriə kape newk foti. ");
INSERT INTO nwi_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kɨni ai Kughen rɨrəhsi-əhu Sol, kɨni mɨvəhsi-haktə Deved mor king kɨn kapəriə. Kughen rəgnəgɨn King Deved mɨmə, ‘Yakəm yakɨrkun mə Deved e, kwajikovə kape Jese, norien kafan ratuatuk ye rɨkik. In yermamə kɨrik in ramor rɨkik.’ ");
INSERT INTO nwi_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Kɨni taktəkun ai, Kughen ruəvəh-si haktə mɨkɨp King Deved kɨrik, nhagɨn e Yesu, mə tukrɨvəh mɨragh narmamə, rəmhen kɨn yame Kughen rɨmɨrpen-ta kupan. ");
INSERT INTO nwi_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Mərɨg kwasɨg ikɨn Yesu ruə mɨrikakun kafan wok, Jon Baptaes rɨmnamni-ərhav tuk nəmə Isrel mɨmə, ‘Taksarar ye nərɨgien kapəmiə tuk təvhagə hah kapəmiə, mɨsor baptaes.’ ");
INSERT INTO nwi_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kɨni nɨpɨg kape Jon Baptaes ruə ipakə tuk nərkinien kafan wok, kɨni rɨmɨni-pən tuk əriə mɨmə, ‘?Kɨmiə nakharkun mə yo pa? Pəh nien mə yo e yermamə Kughen rɨmɨni ta. Takasətərɨg kɨn yo. Yermamə kɨrik e ramuə, yo yakpəh nəmhenien mɨmə yo jakrɨsɨn ta nərəus ye kafan sandel.’ ");
INSERT INTO nwi_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Yo mɨnə tɨksɨn, kɨmiə kwənərəus kape Ebraham, mɨne kɨmiə nəmə tanə pɨsɨn pɨsɨn mɨnə e nakamhasiai Kughen kape nəmə Isrel. Kughen rɨmɨvəhsi-pə Nəgkiarien kape swatuk yame tukrɨvəh mɨragh narmamə iran. ");
INSERT INTO nwi_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nɨpɨg Yesu rɨmatərhav-pə əmə, nəmə Jerusalem mɨne namehuə kɨmɨseinein mə In a In yermamə yame Kughen rɨmɨrpen. Kɨni mɨseinein nəgkiarien kape profet mɨnə kupən yame kaməvheikɨn ye Sabat mɨnə fam. Məkneikɨn, kɨmɨshopni Yesu rəri-pən nəgkiarien kape profet mɨnə kupən. ");
INSERT INTO nwi_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Kɨni iriə khapəh nɨsəm-pawk-ien mə In rɨmnor norien has kɨrik yame ratuatuk mə tukrɨmhə tukun, kɨni kɨsarar, mɨsəkeikei kɨmi Paelat, yamehuə kape nəmə Judia, mə tukhopni Yesu. ");
INSERT INTO nwi_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kɨmɨsor fam narɨmnar a rəri-pən nəgkiarien kape profet mɨnə kupən. Kɨmnharəh-si-əhu nɨpran ye nai kamarkwao kɨn, mharəh mhavən, mɨsəru-pən ye nəpəəg kapier. ");
INSERT INTO nwi_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Mərɨg Kughen rɨmnor In ramragh mɨn ye nɨmhəyen. ");
INSERT INTO nwi_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kɨni rɨmɨmragh mɨn, mɨtərhav-pə tuk narmamə kafan mɨnə. Narmamə mɨnə a, kɨmɨseriwək kwis iriə Yesu kupən. Kharikakun Galili, mhauə mɨseriaji-pə ye Jerusalem. Kɨni taktəkun ai, narmamə mɨnə a kamhani-ərhav-pən kɨmi piautawə mɨnə e, nəmə Isrel, mə iriə kɨmɨsəm əfrakɨs Yesu, mhani mhamə In rɨmɨmragh əfrakɨs. ");
INSERT INTO nwi_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Kɨni kɨmawə yɨmnhauə ikɨn e tuk nɨni-ərhavyen Nəgkiarien Huvə kɨmi əmiə. Nɨrpenien yame Kughen rɨmɨni-pən tuk kaha kapətawə mɨnə kupən, ");
INSERT INTO nwi_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ruɨni-ta tuk ətawə, nɨmɨkɨpriə. Rɨmnor Yesu rɨmragh mɨn ye nɨmhəyen, rəri-pən nəgkiarien ye Ol Sam japta tu yame ramni mɨmə, “‘Ik kafak kwajikovə. Yɨmɨrəh Ik e towei.’ ");
INSERT INTO nwi_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Kughen ruɨni-ərhav ta ye Nəkwəkwə kape Kughen mɨmə tukror Yesu ramragh mɨn ye nɨmhəyen kafan, mərɨg In tukrɨpəh mɨn nɨmhəyen; nɨpran to rapəh nəmətɨtien. Kɨni mamni mɨmə, “‘Yo jakvəhsi-pre nɨhuvəyen kɨmik rəmhen kɨn yame yɨmɨrpen-ta mə jakwəhsi-pən kɨmi King Deved.’ ");
INSERT INTO nwi_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Kɨni nəgkiarien pɨsɨn kɨrik ye Nəkwəkwə kape Kughen ramni mɨmə, “‘Ik to nakpəh nɨpəhyen mə nɨprai yemə rhakə kafam tukrəmətɨt.’ ");
INSERT INTO nwi_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Nɨpɨg King Deved rɨmamragh, in mamor narɨmnar yame Kughen rorkeikei. Kwasɨg ikɨn, rɨmhə. Kɨnɨm in iriə kafan kaha mɨnə. Kɨni nɨpran ruəmətɨt ta. ");
INSERT INTO nwi_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Mərɨg nɨprai Yesu yame Kughen rɨmnor rɨmragh mɨn ye nɨmhəyen, in rɨpəh nəmətɨtien. ");
INSERT INTO nwi_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","“Ror pən, yo mɨnə tɨksɨn, takasəkeikei mharkun huvə nəgkiarien yame kɨmawə yakamhani-ərhav-pre tuk əmiə mhamə Yesu r