﻿USE sofia;
DROP TABLE IF EXISTS sofia.nvm_vpl;
CREATE TABLE nvm_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nvm_vpl WRITE;
INSERT INTO nvm_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Suar igi izeg Jesu Kuraison saifarif iji bu e Eburamon ijia uinve roke e Devidon ijia usem roke Jesu nafenva ijin. ");
INSERT INTO nvm_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Regavo e uij iji bu uinve ruainva iji bu ijeg. E Eburam fu farifuon e Aisek nafega Aisek fu uri farifuon e Jekaf nafen. Fu Jekaf nafega fu uri e Juda ga uviaifijaf iji nafen. ");
INSERT INTO nvm_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Areme Juda fu uri am nokarok (2) e Ferez ko e Zera nafen gavo asie buon iji bara Tama. E Ferez fu uri farifuon e Eziron nafega Eziron fu uri farifuon e Ram nafen. ");
INSERT INTO nvm_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","6","E Ram fu uri farifuon e Aminadab nafega Aminadab fu uri farif fuon e Nason nafen. E Nason fu uri farifuon e Sarmon nafega Sarmon fu uri farifuon e Boaz nafen. E Boazon asie iji bara Reab. E Boaz fu uri bara Rut abene e Obed nafen. E Obed fu uri farifuon e Jesi nafega Jesi fu uri farifuon Devid e iji fu Kin renma iji nafen. Areme Devid fu uri farifuon e Soromon nafen revo asei fuon iji fu e Uraiaon barak. ");
INSERT INTO nvm_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","10","E Soromon fu uri farifuon e Reoboam nafega Reoboam fu uri farifuon e Abija nafen. Abija fu uri farifuon e Asa nafega Asa fu uri farifuon e Jeosofat nafega Jeosofat fu uri farifuon e Jeoram nafen. Jeoram fu uri farifuon e Uzaraia nafega Uzaraia fu uri farifuon e Jotam nafega Jotam fu uri farifuon e Eas nafen. Eas fu uri farifuon e Esekaia nafega Esekaia fu uri farifuon e Manasa nafega Manasa fu uri farifuon e Amon nafen. ");
INSERT INTO nvm_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","14","Amon fu uri farifuon e Josaia nafega Josaia fu uri farifuon e Jekonaia ga diaifarifuon iji nafen. Areme e Babironko ijieb usem Jerusarem mai iji arafirime uri e Isrerko iji bun aferdiame una ar buon Babiron ijia vain. Areme rad e Jekonaia fu uri farifuon e Sirtir nafega Sirtir fur uri farifuon e Zerubaber nafen. E Zerubaber fu uri farifuon e Abiud nafega Abiud fu uri farifuon e Eriakim nafega Eriakim fu uri farifuon e Azo nafen. Azo fu uri farifuon e Zadok nafega Zadok fu uri farifuon e Akim nafega Akim fu uri farifuon e Eriud nafen. ");
INSERT INTO nvm_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","17","E Eriud fu uri farifuon e Eriasa nafega Eriasa fu uri farifuon e Matan nafen. E Matan fu uri farifuon e Jekaf nafega Jekaf fu uri farifuon e Josof bara Merion baru iji nafen. Bara Merir Jesu e iji bu kua Kuraisno kuavo e iji fu e fok karauniakafa ruainma ijin nafen. Ijefuon e Eburam ijia roke e Devid bu nafenva ijia e uij iji buka e fotin (14) ijeg. Regavo una madu e Devidon uifarif ijia roke tavan iji e Babironko bu usem Jerusarem mai iji arafirime e Isrerko bu aferdia Babiron vainva ijia e uij bu madu e fotin (14) ijeg. Regavo una tavan iji bu aferdia Babiron vainva ijia roke e iji God fu abe enuvuon E Bomana renma iji bu nafenva ijia e uij bu madu e fotin (14) ijeg. ");
INSERT INTO nvm_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ijegvo Jesu Kurais bu nafenva iji fu ijeg. Bara Meri Jesuon asie iji bu e Josof jakfuon kuain. Regavo fu vek naise ba baruna nainma ijia fu fuon ganamigak fu Kaven Akai ijefuon daro ijia fu e fudienma fu iji gain. ");
INSERT INTO nvm_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Regavo e Josof fuka e mado fuba una Meri e iji fu fudienma iji afeme dab kuaimgakfuon iji fuba ijeg ren. Ijefuon fum oifuon ijia Meri fu abekfuon iji fu isuar ijia arekafa fu ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","21","Fu ijeg vierafeoga E Bomana ijefuon anera ijar ari naka kuardame kua, Josof e Devidon uifarif ige bara Meri a abekafa jumo iji fu bano abene. Regavo am iji fu fudienma iji fu Kaven Akai ijefuon daro ijia fudiedo fu am farif nafekma a abe ime Jesuno kuak. Ijefuon maiji fur efuon ijiebuon ise iji bu reoijo ijia karauniakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ijegvo ire uruvana bu renva iji fun izeg E Bomana fu usuibe Aisaia e vuak fuon vierafe kuaimon ijefuon oij ijia vierafe mamga fu kuainma fun ijekma aresrekro fu iji ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Regavo vuak iji fu kuainma iji bu ijeg isoi, Bara naise be fuba baruna naino fu e fudieme am farif be nafega bu e Imanuerno kuak. (Regavo if ijefuon ma iji God fu nona). ");
INSERT INTO nvm_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ijefuon Josof fun naine suok urine izeg E Bomana ijefuon anera fu kuardainma ijeg fun bara Meri aben. ");
INSERT INTO nvm_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Fu aben gavo fuba fusik besum naikoga fun vake amfuon amur iji nafen. Fu nafega Josof fu abe ime Jesuno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bu tavan iji bu Jesu ar Betriem moik Judia guf ijia nafenva ijia fu e Erodri e bomana rene moik iji samuamo. Ijegrekoga rad e nokbek (3) bun ar tavan ajiemo nak ijia roke Jerusarem usen. Regavo e iji ruainva iji bu karine mujur ijia anf sumakin kafo nisaivo ijieb ruain. ");
INSERT INTO nvm_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Bu useme e iji kia, Am ukak iji fu rad e Jiusbuon e bomana rekfuon iji bu izia nafen. No anf fuon sumakin be ire mujur ijar ar tavan ajiemo nak ijia ajie roka no gain. Ijefuon no fuon sirimamene kurituamajakuai ruainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Bu ijeg kuardiaoijga e Erod ga e uruvana mai Jerusarem guf ijia karinva bu vuak iji faiva buka bomana deajidiain. ");
INSERT INTO nvm_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ijefuon Erod fun urine e Godon isuf baroijo ijiebuon e mamkanuk ijigam e vuak akai nijaidiavo iji kumega bu una besum afuin. Bu afuivga fu kia, E iji God fu kuaga fu ruakno kuainva iji ja vierafega bu ar izia ijia nafenvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Fu ijeg kuardiamga bu kua, Godon buk akai bu usuibe isoinva ijia fu kua, Am iji bu ar Betriem moik Judia guf ijia nafek. Ijefuon maiji Maika e Godon vuak vierafene kuaimon iji fu ijeg isoime kuai, ");
INSERT INTO nvm_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ai Judia guf ijia mai mamkanuk roin iji bu karinva ijiebuon kafar ijia mai Betriem aiji aka mai ma ukakbe bakin. Ijefuon maiji rad ar am farif be mai ijia nafek. A am iji nafega fur rad e bomana rene e Isrerko nun fok samuagdiakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Bu ijeg kuardavga Erod fun e nokbek (3) iji mujur ijia anf nisaivo iji ruainva ijin kiavga bu isuar aferdia ar fuon ijia vain. Bu vakga fu uri tavan iji bu ivez mujur iji fu ajiema bu gainva ijefuon kuardiain. ");
INSERT INTO nvm_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Fu kuardiame uri kia, Nin va am iji amarigia nisaimoine ja gakva nika migegare una ro na kuardief. Ja kuardiega nak va fu kurituamajame fuon sirimamejno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Erod fu ijeg kuardiamga bun vakuai vake unam gafia una madu mujur besum iji bu ar tavan ajiemo nak fu ajiema bu gainva ijin gain. Mujur iji fu amur vakok bu gavknum ja vake ka ar iji am fu namo ijia usen. ");
INSERT INTO nvm_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bu usem mujur iji manino ijin gavga buka ma uruvana igia oimadiain. ");
INSERT INTO nvm_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ijegreare bun aru vaga am iji fu asiefuon Merik ijia karija bu giain. Bu aru giame uri fuon ato same sirimamen. Rene bun uri kamui buon ijia ire gord ga ire udi mukor urino nokarok (2) bu kua frenkinsens ga meno kuavo ijin kege am iji vajain. ");
INSERT INTO nvm_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ijegreare bun naoinva ijia God fu naka ijia kuardiame kia, Jab una Erod fino ijia vakvano kiamga bun uri unam be ijia una ar buon ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","E mujur davo nokbek (3) iji bun una vakga Josof fu nainmaga E Bomana ijefuon anera ijar arime naka kuardain. Fu kua, Migegare urine am gureko asiefuon ijin aferdiame ni uri ko gamia ar Ijift ijia ari va figa nar kuaga ni una rokne. Ijefuon maiji e bomana Erod moik samuamo iji fu am iji kanakafa nisaimoino kuain. ");
INSERT INTO nvm_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ijefuon Josof fun ve ufrenma ijia urine am ijiga asiefuon iji aferdiame bun Ijift vain. ");
INSERT INTO nvm_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bun va ijia karine e Erod fun fine guakoga bu rad una ruain. Regavo iji bu ijegrenva iji bu izeg Osia e Godon vuak vierafene kuaimon fu usuibe isoime kuainma ijekma aresrekro fu iji ijeg ren. Regavo vuak iji bu ijeg isoi, Na e iji bu ai Ijift guf ijia karinva iji uf ijia am farinun iji kumejga fu keko ruain. ");
INSERT INTO nvm_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Regavo tavan iji Erod fu vierafega e iji mujur ijia anf nisaivo iji bu biesuainvaga fuka uruvana igia deajin. Ijefuon fun uri e bijaivo fuon uruvana kia, Ni va ar Betriem ijia am farif ukakna juaivasia besum (1) vo nokarok (2) barenva iji fok kaniaf. Regavo madu ni va ar ukakna Betriem samaij ijia ga juar bu menva ijia oknum am ukakna fok kania barefno kiain. Ijefuon maiji bun e ijieb ivez mujur iji fu mani sanama bu gainva iji kuardainva ijefuon fu am ijekin iji kaniamno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ijefuon iji bu ijegrenva iji bu izeg Jerimaia e Godon vuak vierafene kuaimon fu usuibe isoinma ijekma aresrekro bu iji ijeg ren. Regavo vuak fu kuainma iji bu ijeg isoime kuai, ");
INSERT INTO nvm_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ar Rama guf ijia e be niraima na fain revo e iji bara Resor afijaf ijiebuon niraim. Regavo fu erar ifejdakma bakin ijefuon maiji am uruvana bun aoim barenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ijegreare e Erod fun guakoga E Bomana ijefuon anera iji fun una Ijift ijia arime Josof naka kuardame ijeg kuardain. ");
INSERT INTO nvm_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Fu kua, Nin am ijiga asiefuon iji aferdiame una uri ar Isrer ijia vakne. Ijefuon maiji e iji bu am iji kanakuai nisaimoijo iji bun aoim barevano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ijefuon Josof fun am ijiga asie fuon iji aferdiame una urine Isrer ajie vain. ");
INSERT INTO nvm_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","23","Fu una Judia ijia fivako ijia fu e Akeras fu asoifuon Erodon ar iji abene e bomana rene ai Judia samuamo iji fain. Fu iji faima fuka bomana jumga E Bomana ijefuon anera iji fu una arime Josof izeg fu rekfuon fok fuka naka ijia kuardain. Ijefuon fu ar Judia fu ijia areme va Nasaret ai Gareri ijia ar fuon same ijia fin. Regavo ijeg fu renma iji fu izeg e Godon vuak vierafe kuaimon fu isoinma ijekma aresrekro fu iji ijeg ren. Regavo vuak iji bu ijeg isoime kuai, E iji God fu kuaga fu ruakfuon iji fu e ar Nasaretkono kuain. ");
INSERT INTO nvm_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ijegreare tavan ijia Jon e do ruardiamo iji fu moik Judia guf ai moikum namo ijia uri anerene e iji bu fuon roko iji vuak nijaidiam. ");
INSERT INTO nvm_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Fu vuak nijaidiaoknum e iji kuardiame kia, Unam jon ka ise iji ja nakikmazak reoijo iji arega una unam ma ijia keof. Ijefuon maiji tavan iji God fu efuon ijiebuon oij iji samuagdiakfuon iji fuka samaij igijarno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Regavo e iji fu ijeg kuainma iji e Aisaia e Godon vuak vierafene kuaimon ijar fuifuon usuibe ijeg kuai, E be fu ai moikum namo ijia fine kume, E Bomana ijefuon unam iji amarigia arir amarme samuake fu rokno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Regavo e Jon sinuom fuon fu samon iji fu fanuf kamer jau ijia amardiain gavo madar fuon iji fu madu fanuf surif ijia amaren. Regavo duok fuon fu ino iji fu kuamutu ga muni rif iji ino. ");
INSERT INTO nvm_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jon fu ijegreoga e uruvana ai Jerusarem karinva abevo ai Judia karinva iji bu biom fuon ruain. Bu ijegrekoga e ar ukakna do Jodan irif ijia karinva iji bu vuak fu kuaimon iji faikuai ruain. ");
INSERT INTO nvm_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bu biom fuon ruaknum ise buon iji fu kuardakoga fu aferdiame do Jodan ijia do ruardiain. ");
INSERT INTO nvm_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","8","Regavo una e Feresis ijiga e Sejusis uruvana bu do ruaikuai fuon rokga fu giame uri kia, E gari ka isema vierafeoknum aroikaraoijo garie, Ja vierafero jan ma reoido God fuba rad ja kam arafiriakro ja ijeg vierafej. Jon izeg ja e biesiaoknum aroikaravo iji aref. Regavo ni una asume amarigia reoga e fok bu vierafero ja ise jon ja rejo iji jan arenvaro bu ijeg vierafef. ");
INSERT INTO nvm_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Regavo jab kuaik no sai nuvuon Eburamon uifarifdo God fuba nuigafuokro ijeg jab kuaik. Regavo igia faif. God fu e darokido fu mun guri kege una e Eburamon afijaf amarega bur ai jon abekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Jon fu ijeg kuardiame uri vuak be ijeg bijame kuardiain. Fu kia, E bu in kafo buba sunin kiraga bu giavo iji buka mua kam um ataseme mian javo. Ijegvo jak ja unam ma iji jaba kegokva God fu ja kam mian iji naino ijia kozega ja ijia naoik. ");
INSERT INTO nvm_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Regavo eraneb ja unam ise jon fok ja reoijo iji jan arenva iji na aferdia do ijia ja ruardiak. Regavo e iji fu rad jajie roko ijar ruakma fur kafut uruvana oijon ijia naoivo iji kaname mian ja vo Kaven Akai iji kege ja uniafdiak. Fur fu ma E Bomana gavo naiji nam e ukakbe. Naba aresredo na dia surif fuon iji fu sainma iji azokfuon. ");
INSERT INTO nvm_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","E iji fu rad rodo fu ruakma fur e igi ja kam ataken. Fu kam atame eraneb bu unam ise iji areme una unam ma ijia kegoijo iji fu kege be uniak. Regavo eraneb ja unam ise ijia kegoijo iji fu kege una mian iji tavan bog naine vako ijia uniakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Areme ve iji Jon fu ijegreoinon ijia Jesu fu ar Gareri ijia uri vake do Jodan Jon fu e do ruardiamo ijia kekoin. Fu vierafe Jonri fu do ruardakafa fu ijefuon vain. ");
INSERT INTO nvm_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Fu vakga Jon fu uri kuai, Na a do ruardakfuon iji na vierafega fuka ba maren revo na vierafe ar na do ruardiemne kuain. ");
INSERT INTO nvm_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Fu ijeg kuardamga Jesu fu kua, Iji an ma kuaim gavo na vierafe aba arekga a na do ruardiek. No ijegrenki no tavan bog irerag God fu kuarduomo iji kafo noba uzagavo noka tavan bog fu igame kegokno kuain. Fu ijeg kuardamga Jon fu vierafega fun magame fu uri Jesu do ruardain. ");
INSERT INTO nvm_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ijegreare Jesu fun do iji areme ajie roko ijia ai nairekoga daro iji fu e karauniakfuon iji fu Jesuon ruain. Regavo daro iji fu Godon Kaven ijar um guaf igeg arime Jesuon nigen ijia kiren. ");
INSERT INTO nvm_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Areme bu faik vuak be varur gufia kume, E iji fu Farinun na oijmavo ijin. Na unam fu kegoino iji na gaga fuka oimadiemno kumen. ");
INSERT INTO nvm_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ijegreare ve ijia Godon Kaven iji fun uri Jesu afeme dab ai moikum namo ijia vakga Setan fu biesuain. ");
INSERT INTO nvm_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesu fun va ai moikum namo ijia duok karome oko naki foti (40) ga tavan foti (40) ijeg barekoga fuka vasiaguain. ");
INSERT INTO nvm_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Fu vasiaguainma ijia Setan fu kekome kua, A ma Godon fariga ni urine mun guri naoivo iji kiaga bu una duok rega a kege ine kuain. ");
INSERT INTO nvm_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Fu ijeg kuamga Jesu fu una kua, Usuibe Godon vuak bu buk akaij ijia isoinva iji fu ijeg kuai, Barubara buba tavan bog duok ijesugin iogavo buka Godon vuak iji vierafene reok. ");
INSERT INTO nvm_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jesu fu ijeg kuardamga Setan fun una madu afeme ar mai Jerusarem ijia ajie vain. Fu afeme ajie vake ar bomana bu sirimamejo ijefuon azan gafia unain. ");
INSERT INTO nvm_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Areme Setan fun uri Jesu kua, A ma Godon farikma ni ijia manine furikome moik gamia arimne. Ijefuon maiji usuibe buk akaij ijia bu ijeg isoime kuai, Godri anera fuon uruvana kiaga bur a samuagak. Regavo a furik akozekma bur a dabe ari vake moik ijia unakva aba arime oi kananamikvo madu diak on iji aba kege nizukdiakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Fu ijeg kuardamga Jesu fu una kua, Godon vuak bu usuibe isoinva ijia fu madu ijeg kuai, Jab E Bomana God jon ma iji abe biesuavno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ijegreare Setan fun una madu Jesu afeme uruor makaf ijia ajie vain. Bu ijia ajie useme Setan fun uri ar iror fok nijaime madu uri ire ni mukor uruvana moik ijia naoivo ijin nijain. ");
INSERT INTO nvm_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Fu ijeg nijaime uri kua, Kam ijia ga. A ivia igia na ato same na sirimamekma na ire fok a giainma iji una a vajakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Regavo Jesu fu una roin kua, Setan gareg va. A vuak iji bu usuibe buk akaij ijia isoime kuai, Jaka E Bomana God jon ma ijesugin fuonkua sirimamekgavo jab una e roin igiavno kuainva iji abe vierafenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Regavo Setan fun ijia areme vakoga anera ijieb arime Jesu ifejdaknum samuain. ");
INSERT INTO nvm_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ijegreare rad Jesu fu faik e bu Jon dab dibur unava fu faime fun una uri ai Gareri ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Fu va Nasaret keko gavo fuba ijia fin revo fu asime va ai Kafoniam ijia fin. Regavo ar iji fu do Gareri nafuinma samaij ijia gavo fu ar Zeburun ko Nafetari guf ijia. ");
INSERT INTO nvm_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Regavo Jesu iji fu uri vainma fun izeg usuibe Aisaia e Godon vuak vierafene kuaimon ijar usuibe isoinma ijekma aresrekro fu ijin ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Regavo vuak iji fu kuainma iji bu ijeg isoime kuai, E moik Zeburun ko Nafetaribuon uifarif iji bu do Jodan gara unam iji saofnak vainma iji irif ijia karin. Regavo e ijiebuon moik iji bu kua Gareri kuavo ga moik iji e Jius bakin iji buka uruvana ijia karin. ");
INSERT INTO nvm_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","E iji bu unam ise nakinma ijia karioijo ga rad E Bomana ijefuon unam ikin ma iji sanainma iji bu gak. Regavo madu e iji bu unam ise nakinma ijia kegoijo kaven buon iji buka aoinva iji bu madu sanainma iji bu gak. ");
INSERT INTO nvm_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ijegreare tavan ijia Jesu fun uri anerene e iji vuak nijaidiain. Fu nijaidiaknum kia, Tavan iji God fu oijon iji samuagdiakfuon iji fuka samairen. Ijefuon oij iji ja ire ise kafokafo moik igefuon vierafejo iji arega una oi karoime Godon ruafno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Areme tavan be Jesu fu do Gareri daturaiko nafuinma irif ijia oin. Fu oinon ijia fu e kimai savo nokarok (2) no diaikin e Saimon e iji bu madu kua Fitano kuavo ijiga uviaifuon e Edru iji biedien. Regavo e nokarok (2) iji bu ugie buon iji kege kijum karav. ");
INSERT INTO nvm_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesu fu biediame kia, Ni ire iji ja reoijo iji arega na jajief. Ja na jajiega na kijum iji ja karavo ijeg unam nijaidiaga ja e aferdiafno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Fu ijeg kuardiamga buba ir fuon abe akozen revo bum migegare uri ugie buon ijin ijia areme uri fu ja vain. ");
INSERT INTO nvm_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jesu fun aferdiame vake una madu no diaikin e Jeims ko Jon e Zebedin afijaf iji giain. E nokarok (2) iji bu asoibuon Zebedina vanag ijia karine ugie buon iji amarev. ");
INSERT INTO nvm_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Bu ijegrejo ijia Jesu fu kumega e nokarok (2) iji bun migegare uri vanag buon ijiga asoibuon iji ijia areme ari Jesuna vain. ");
INSERT INTO nvm_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Areme Jesu fun ve ijia urine ai Gareri guf ijia ar ukakna e Jius bu afuime vuak kuaivo ijia arume oknum vuak nijaidiaoin. Fu vuak nijaidiaknum e uruvana vuak ma iji God fu izeg oibuon iji samuagdiakfuon iji kuardiaoin. Fu ijegrejknum madu e zazaikin uruvana adam abeknum vo aikirariainva iji karauniain. ");
INSERT INTO nvm_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Fu ijegreokogame e bu vuak fuon iji dab kuaime ai Siria guf ijia oin. Ijefuon e uruvana ijia karinva iji bu vuak iji faime uri e adam ise kafokafo ga vajai fian abejo ga e kaven ise urasdiainva ga e iji bu ir sabatenva ijin aferdiame fuon ruain. Bu madu e vajai garadiainva iji aferdiame rokga fu amardiamga bu una madiain. ");
INSERT INTO nvm_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Fu ijegreoga e ka uruvana bu uri fu jame dab arafiri vain. E ar Gareriko iji abevo e mai ten (10) guf ijia karinva ijieb uri fu ja vain. Regavo madu e mai Jerusarem ijia karinva iji abevo e moik Judia karinva abevo e do Jodan gara karinva uruvana ijieb uri fu dab arafiri vain. ");
INSERT INTO nvm_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Areme tavan be Jesu fu giak e uruvana bu fuon rokga fu giame uri uruor ijia ajie vain. Fu uruor makaf ijia ajie vakoga e vuak fuon faivo bu ijia usem kari ameoine arekoga fu uri anerene vuak nijaidiain. ");
INSERT INTO nvm_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Jesu fu vuak nijaidiame kia, Eraneb bu oibuon ijia vierafega buka God gakuai vierafeoijo iji buka oimarkfuon. Ijefuon maiji bu e ijekin ijieb e iji God fu oibuon iji samuagdiafo ijiena mazik. ");
INSERT INTO nvm_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Regavo eraneb bu tavan bog ise buon ijiga e kafobuon ise ijiebuon oifian abeoijo e iji buka oimarkfuon. Ijefuon maiji e ijegreoijo iji Godri rad oifian buon iji dasumdiaga bu nido iji bu abeoijo iji bu arek. ");
INSERT INTO nvm_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Regavo eraneb bu tavan bog Godon nifak ijia kabuaikabuaikin karioijo iji buka oimarkfuon. Ijefuon maiji e ijekin iji God fu rad ire ma iji fu vajiakno kiainma iji fu kege bu vajiak. ");
INSERT INTO nvm_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Regavo eraneb bu tavan bog oibuon ijekma vierafega buka God irerag fu vierafemiamo ijesugin igame reokuai vierafeoijo iji buka bomana oimarkfuon. Ijefuon maiji e ijeg vierafeoijo iji Godri ire fok nidosiake bum tavan bog ijia oimarknum karivak. ");
INSERT INTO nvm_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Regavo eraneb bu tavan bog una e roin vierafeoknum buon oifian abe ifejdiafoijo iji buka bomana oimarkfuon. Ijefuon maiji e ijegreoijo iji Godri vef una buon oifian abene ifejdiak. ");
INSERT INTO nvm_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Regavo eraneb tavan bog oibuon buka maturainva iji buka bomana oimarkfuon. Ijefuon maiji e ijekin iji bur God gak. ");
INSERT INTO nvm_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Regavo eraneb bu tavan bog e moik igia karinva iji unam afuime karijo iji abe nijaidiaga bu afurve karijo iji buka bomana oimarkfuon. Ijefuon maiji e ijegreoijo iji Godri kega bu una afijaf rek. ");
INSERT INTO nvm_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Regavo eraneb bu tavan bog irerag God fu vierafe vajiamo ijesugin kegoko e buka vuak ise buisina kuaiknum bu kam unam ise bu vajai fian abekfuon ijia kegoijo iji buka bomana oimarkfuon. Ijefuon maiji bu ijeg vajai fian abeoijo iji bu e iji God fu oibuon iji samuagdiamo ijiena besum mazik. ");
INSERT INTO nvm_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","Regavo madu jak jan una e vuak nun faivo iji ren ijefuon e buka vuak ise joisina kuaiknum ja kam unam ise ijia arafiriak. Bu ijegrega jaka vajia fian abene isejavaikfuon. Regavo bu ijegrekva nika uruvana igia oimaref. Ijefuon maiji God fu iji ja ijeg kegoijo ijefuon fun vef roin ire ma iji fok joifuon varur ijia kanafuido ja iji kekfuon. Regavo igia faif. Usuibe e Godon vuak vierafene kuaivo iji e bu unam besum ijia bu kam ijeg arafiriainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesu fu vuak ijeg kuardiame vake uri vuak be ijeg bijame kuardiain. Fu kia, Eraneb ja na jajivo iji ja e moikigia oinva ijiebuon kujan iji bu duok same iga madiavo igekin. E bu kujan abe duok same ikva marien iji fuka mukor. Regavo kujan marien fuon iji fu bakrekma iji fun ma bado bu dab akozga e bu ijia datuaimok. Ijegvo ja na jajioga fuka aimiaga ja ijia arekva iji ik ja nuifuon reoijo iji fuka mukor barekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Regavo madu eraneb ja na jajivo iji jaiji ja e moikigia karinva ijiebuon rait igekin. Izeg e bu mai be uruor makaf ijia karinva ijefuon rait iji samakaf giavo ijegvo e buka jon rait iji giak. ");
INSERT INTO nvm_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Regavo madu igia faif. Fu erar rait abe saname sauikma bakin gavo buka abe samakaf abede fu sanake e bu karik. ");
INSERT INTO nvm_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Unam besum ijegvo ja uri unam nun ma iji na nijaidiainva ijin reoknum karivaga e bu ijia giaf. Bu unam ma iji ja kegoijo iji giame una Asoijon varur gufia fino iji dab aroifno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jesu ijeg kuardia vake kia, Ja na ruainva iji jab oi isema vierafek. Jab vierafero na akai usuikor ijiga e Godon vuak vierafene kuaivo ijiebuon vuak bu usuibe isoinva ja giaknum karijo na iji kuriaire ja arekro na ijefuon ruainvaro jab ijeg kuaik. Regavo na ruainva iji nam vuak buon bu isoime nijaidiainva ijiebuon maiji fuka ijekma aresrekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Naka ma kuardiavo igia faif. Na moik igeko varur iji bu vek naoivo iji na vierafega naba vuak akaij ijiga vuak bu usuibe isoinva iji na besum be ba asik. Regavo na vierafega naka ire fok bu usuibe kuaim ruainva ijiebuon maiji besubesum ka reoga buka ijekma aresre barekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ijefuon erar akai fok bu isoinva ijia akai ukakbe be ba igiaknum una kaifijaf roin nijaidiaga buk ijegrejo e iji fuka ba marem. Ijefuon fu rad guamo ijia fu e iji God fu oibuon iji samuagdiamo ijia fuba e ikin rek. Regavo eraneb bu akai fok igiaknum una kaifijaf roin nijaidiaga buk ijegrejo iji fun mukor reoin. Ijefuon fu guakma fu e iji God fu oibuon iji samuagdiamo ijiena mazik. ");
INSERT INTO nvm_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ijefuon igia faif. E be erar e akai nijaidiavo ijiga e Ferisisbuon unam bu kegoijo iji fuba asidiame amarigia kegoino e iji fuka ba aresredo fuba e iji God fu oibuon ijia samuagdiamo ijiena mazik. ");
INSERT INTO nvm_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesu vuak ijeg kuardiame uri kia, E iji bu akai nijaidiavo bu kuai, Jab e kania bu aoivno kuainva iji jan fain. Ijefuon erar e kana fu guamo e iji bu afeme kot rene dab arafirikfuon. ");
INSERT INTO nvm_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Regavo na kuardiako ni faif. Erar fu uviaifuon iji ziegafamo iji bu madu afeme kot rene dab vajai fian makfuon. Regavo madu erar fu uviaifuon be kua aka e omiseno kuamo e iji bu afeme dab e mamkanuk sos akai samuavo ijiebuon vaga bu dab vajai fian makfuon. Regavo erar fu uviaifuon be kuak aka mukor reno bano kuamo e iji fun koikfuon unam amarme ar ise mian naino ijia vak. ");
INSERT INTO nvm_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Ijefuon ja ire kafo kege Godon ar guf fata ijia isuf barokuai vako ijia ni mukoi vierafekfuon. A vierafega kaion be fu osik zienamiga ni ire a kege vako iji fata samaij ijia name una migegare kekome va. Ni una va kaion iji fusik afuime oimarme ni una isuf on iji kege God baroida. ");
INSERT INTO nvm_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Regavo igia fai. A kaion befuon ire ise be renma fu ijefuon a aferda kot rekafa vierafekma nivek iji jaba e kot faimo iji fino ijia usenva ijia ni migegare una fusik vuak iji kuaim iraseme imut kenami. Regavo bakma fu a aferdame dab e kot faimo ijefuon vaga a nifak fuon ijia vuak on iji kuaik. A kuaiga fu vuak on iji faime fu una foris kiaga bu a dab dibur abesek. ");
INSERT INTO nvm_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Regavo madu igia fai. Bu a dab dibur una a ijia fiknum mon izeg bu kuainva a ijin kime barme ijar ason una kekokno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesu fu ijeg kuardiame kia, E iji bu akai nijaidiavo bu kuain, Jab ebuon bara turakno kuainva iji jan fain. ");
INSERT INTO nvm_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Regavo na kuardiakrejo ni faif. E be erar bara be game fum isuar oifuon ijia bara ijek naikafa ijeg vierafeno e iji fun bara ijek naino igekin ijefuon fun ise ren. ");
INSERT INTO nvm_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ijefuon a vierafega niom on maink besum ijar rekok a ise rejga ni kunaim jafe akoze. Fu niom on besum ijar ise rene vajat on fok fun dab ar ise mian naino ijia akozekredo a ijegrekma iji fuka marek. ");
INSERT INTO nvm_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Regavo madu a vierafega imut on maink besum ijar ire ise kuniaikok a ise rega ni kanafu akoze. Fu imut on besum ijar ise rene vajat on iji fok fun dab ar ise mian naino ijia akozekredo a ijegrekma iji fuka markno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Regavo madu bu kuai, Erar fu bara fuon be abe vo rad fu rotkurakafa vierafekma fuka fefa ukakbe ijefuon isoim mamne kuain. ");
INSERT INTO nvm_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Regavo na kuardiakrejo ni faif. E be erar fu bara be abe ga bara iji fu ebuon baru turamo ijefuon fu rotkuriakma iji fun maren. Regavo bara iji fuba ebuon baru turain gavo baru fuon fum rotkurakma fu una va baru be jakma bara iji fun isema rene ebuon baru turam. Regavo baru erar fu una va bara iji bu abe unainva iji abeno iji fun isema rene ebuon bara turamno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Regavo madu e iji bu akai nijaidiavo bu kuai, Ja Godon if ijia kurame vuak kuaikva jab arek nika irerag ja kuainva iji ka refno kuainva jan fain. ");
INSERT INTO nvm_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Regavo na kuardiakrejo ni faif. Ja vuak ijeg kuaimokva jab e if ijeg kuriame vuak kuaik. Jab varur gufefuon if ijia ga moik igefuon ire kafobuon if ijia kuriame vuak kuaik. Ijefuon maiji varur gufi God fu ijia fino ga moikigi diak fuon iji fu igia kore fino. Regavo jab mai Jerusarem kurak ijefuon maiji mai iji fu God Kin ka ikin ijefuon ar. ");
INSERT INTO nvm_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Regavo madu jab nigen jon ijia kanakanaknum kuaik ijefuon maiji ja daro bado ja izeg nigen jau jon kiaga bu abaiki ga kazin tavuakfuon. ");
INSERT INTO nvm_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ijefuon a vuak kuaiga e bu kua, Vuak iji abe ma kuaimno kuakva ni keno kia. Regavo a vierafega a kufuimega ni bano kiamne. Regavo a feme una madu vuak kafo buin ijia vierafene kuaimon iji a Setanri vierafe vajaga a iji dab kuaimno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jesu fu ijeg kuardiame kia, E iji bu vuak akai nijaidiavo bu kuardiame kia, Ja e be fu on ise rega asik una roib ise reno kuaiva iji jan fain. ");
INSERT INTO nvm_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Regavo na kuardiakrejo ni faif. E kafo bu jon ise rekva jab una roib bu ise rek. Ijefuon e be erar fu keko sano on maink ijia kanakma ni areke fu una madu roin ijia kana. ");
INSERT INTO nvm_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Regavo madu fu set on a mon ukakbe ijia kimenma iji abekafa fu uri a aferda dab kot rekma ni madu ugon on ma iji a azan abesmo iji a mon bomana kimenma iji abe ma. ");
INSERT INTO nvm_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Regavo madu ebe fu a kuriaireme kua, In nun guri abe samaij gafia miemne kuakma ni abe biom va aibe ijia ma. ");
INSERT INTO nvm_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Regavo e be fu ro ire kafofuon kuakma ni zinunba abe ma. Regavo fu kuak ire on iji mie na vaikin una abe mamne kuakma ni oimarknum abe maga fu va. ");
INSERT INTO nvm_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jesu fu ijeg kuardiame kia, E iji bu vuak akai nijaidiavo bu kuardiame kia, Kaifjon ma ijesugin oijmiagavo e ani jon iji ka ziegafiavno kuainva iji jan fain. ");
INSERT INTO nvm_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Regavo na kuardiakrejo ni faif. E ani jon iji amarigia oijmiavo e iji bu jon ise rejknum vajai fian vajiavo iji ni buon sirimamef. ");
INSERT INTO nvm_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ja ijegrenki ja una God Asoijon varur gufia fino ijefuon afijaf rekfuon. Ijefuon maiji fur veni iji kuaga fu e ise ga ma iji oijo ijiebuon azan ijia sanafiako bu oij. Regavo madu fu ve iji kuaga fu e ise ga ma kegoijo ijiebuon dam. ");
INSERT INTO nvm_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Regavo ja uri e iji bu ja oijmiavo ijesugin oijmiakva iji God fu irerafuon unam ma kafo jon rediak? Unam iji bu e ise takes abeoijo ijieb ijeg kegoijo. ");
INSERT INTO nvm_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Regavo ja uri kaifjon ja vierafenva ijesugin anadiavo iji ja unam mukor sumakin kafo kege una e roin nijaidiavo bakin. Regavo unam ijeg kegoijo iji bu e iji God ma vierafenva bakin ijieb ijeg kegoijo. ");
INSERT INTO nvm_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ijefuon jak nika maturaime unam ma ijesugin keof. Ijefuon maiji Asoijon varur gufia fino iji fuka maturainma ijefuon jak nika ijeg amarigia e roin oijmiaknum kariofno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesu fu ijeg kuardiame kia, Ja ik jon ma iji ja reoijo ijia jab vierafero bu eb kam arorduovoro uri e nifak ijia aroikarame ik reoijo. Regavo ja ijeg kegokva God Asoijon varur gufia fino iji fuba unam ma kafo jon rek. ");
INSERT INTO nvm_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ijefuon ja e ire bakin iji ire kafo vajiakva jab aramame e nifak ijia vajiak. Regavo ja ifejdiakuai vierafekva ni isuar sauime ifejdiaf. Regavo jab uri e iji bu unam ijia ga ar e bu afuivo ijia vuak ijia mareoijo iji matiavo. E ijegreoijo iji bu kuai, Are e garieb no kam arorduovoro bu ijefuon ijeg reoij ga na igi kuardiakrejo faif. E ijeg kegoijo iji bun ema ijieb siban arordiav. Ijefuon God fu irerafuon una vef unam ma kafo e ijekin ijiebuon rediak. ");
INSERT INTO nvm_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Regavo ja oine e zazaikin ijekin iji ifejdiakva iji nika sauime ifejdiaikin kaifjon jana besum oijo iji bu irerag ja rejo iji buba giame vierafekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ja isuar ijeg sauime rekin God Asoijon fu unam sauivkin ja rejo iji giakma fu rad vef ijefuon unam ma kafo jon rediakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesu fu ijeg kuardiame kia, Ja oine Godon sirimamekva jab e i kufuikin iji matiame buonak sirimamek. Bu tavan bog Godon ar ijia arume vierafero are eb faivoro buka uri arir ireme jaoijmana sirimamej. Regavo madu buka usem makaf ijia ijeg vierafeoknum sirimameoij. Regavo na kuardiakrejo ni faif. E iji ijeg kegoijo iji bun ema ijieb siban arordiav. Ijefuon God fu irerafuon rad una unam ma kafo vef ijefuon buon rediakma bakin. ");
INSERT INTO nvm_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ijefuon ja oine sirimamekva jab buonak vak. Regavo nin isuar jonkua va ar guf jon ijia arume vien kam bijume ijia karine Asoijon iji e bu gavo bakin ijefuon sirimamef. Ja ijegrenki Asoijon fu iji ja sauim sirimameko fu giamo iji fu unam ma kafo jon rediak. ");
INSERT INTO nvm_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Regavo ja oine sirimamekva jab e God ba ma vierafejo iji matiame buon ma bakin iji bu kukma sirimamejo ijeg sirimamek. Bu vierafero bu ijeg jaoijmana sirimamega God fuka faikro bu ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ijefuon jab bu rejo ijeg kegoijo ijefuon maiji Asoijon iji fu irerag ja fu kuakuai vierafenva iji fun usuibe giame vierafen. ");
INSERT INTO nvm_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Regavo ja sirimamekva ni ijeg sirimamef. God Asoinuvuon kaf gufi samuamo. No if on akaij iji aroiken. ");
INSERT INTO nvm_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","No vierafega a ro oinuvuon igi samuaguokfuon. No vierafega izeg varur gufia bu rejo ijeg e moikigia karinva iji bu irerag a vierafeno ijia keok. ");
INSERT INTO nvm_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ivia duok no nakikmazak iokfuon iji vajuo. ");
INSERT INTO nvm_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Regavo ni izeg e kafobuon ise iji no giame arevo ijeg ni ise nuvuon guome are. ");
INSERT INTO nvm_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Regavo ab no aferduome una unam ise ijia biesuok. Regavo ni ifejduoga no kaven ise Setanon daro ijia no karioijo iji no areme vak. ");
INSERT INTO nvm_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Jesu fu ijeg sirimame nijaidiame kia, Ja ebuon ise giame arekva God Asoijon kaf gufia fino iji fuk ise jon fu giame arek. ");
INSERT INTO nvm_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Regavo ja ebuon ise iji jaba giame arekva God Asoijon kaf gufia fino iji fu ise jon ja renva iji fuba giame arekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Fu ijeg kuardiame areme kia, Ja oine duok kafo karokuai vierafekva jab uri e i kufuikin bu kegoijo ijeg rejo. Bu kuai are e roib giakuai bu usem e nifak ijia buka vasia abenva igeg oij. Regavo na igi kuardiakrejo faif. E iji bu ijeg kegoijo iji bun ema ijieb siban iji giame arordiav. Ijefuon God fu irerafuon una bu kam arordiakma bakin. ");
INSERT INTO nvm_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Ijefuon ja ire kafo ijeg karokva nin dazme do ruaime nigen bijame oimarknum of. Ja ijegrenki e roin buba ire iji ja karomoijo iji giame vierafekfuon. Regavo fun God Asoijon kaf gufia fino ijar fuonkua unam iji ja jonkua isuar vierafene reoijo iji giakma fu ire ma kafo jon rekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Regavo madu igia faif. Jab moik igefuon sinuom ga mon uruvana kege karik. Ijefuon maiji sinuom mukor fok rad buka muture ga ire farat ijieb ufuseknum vo dedirik revo madu buka e niekib niesak. ");
INSERT INTO nvm_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ijefuon sinuom moik igefuon iji ja uruvana vierafejo iji arega una varur gufefuon sinuom ijieb uruvana vierafeknum ijefuon ikre. Sinuom iji bu ire farat buba ufuse vo madu buba dedirime iserek. Regavo madu e niekin buba arume niesa ga buba muture ga bujame iserek. ");
INSERT INTO nvm_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ijefuon tavan bog nika oijon iji fu izer ire jon bu naoivo ijia naoikfuon. ");
INSERT INTO nvm_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Regavo madu igia faif. Niom jon iji fu vajai jon fok ijefuon rait igekin. Ijefuon niom jon iji fu makma vajai jon fok fu mukor sanakfuon. ");
INSERT INTO nvm_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Regavo niom jon fu ise iji ja vierafejo ijar okurakma vajai jon fok iji fuka nakikfuon. Ijefuon vajai jon fok ijefuon sanainma iji fu garekma iji fuka mukor nakido ja izeg una giriesame unam ma iji ja abekfuon iji nisaikva bakin. ");
INSERT INTO nvm_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Regavo madu igia faif. E besum fu izeg uri oifuon fok ijekma e mamkanuk nokarok (2) ijiebuon ikrekma bakin. Regavo fu ikrekma iji fu e be fuka mukor oijmagavo una be iji fuba mukor ifejdak. Regavo madu tavan bog e be iji fuka amarigia fuifuon ikreknum igak gavo una e be iji fum ni iken gaok. Ijefuon ja moik igefuon sinuom ijiga mon iji uruvana oijmiaknum vierafekva iji ja izeg una amarigia God igame tavan bog fuifuon ikrekva bakin. ");
INSERT INTO nvm_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ijefuon na igi kuardiakrejo ni mukoi faif. Jab tavan bog uri vajai surif ijefuon duok ga do ja ik ga ugon ja sakfuon iji uruvana vierafeok. Ijefuon maiji duok ijiga sinuom iji bu ikin bakin. Regavo vajai jon ijiga jon ja karivakfuon ijar fuka ma ire bomana ijefuon ja ijar bomana vierafekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Regavo madu nin um ukakna gufi bu oijo iji giaf. Buiji bu ire uij abejknum ga kanafui navo bakin ga fun Asoijon varur gufia fino ijar bu fuka amarigia samuagdiam. Regavo jaiji ja um iji God fu oijmiamo ijekin bakin ijefuon maiji jaiji ja Godon nifak ijia jaka ma ikin. ");
INSERT INTO nvm_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ijefuon erar fu vajai surif ijefuon ire iji uruvana vierafeoino iji fu juaivasia fuon iji abe biom jiamana abedeme fivakma bakin. ");
INSERT INTO nvm_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Regavo madu jab karine ugon ja sakfuon ga kekfuon ijefuon uruvana vierafek. Regavo madu ni sinar tarar gamia irenva iji giaf. Buiji bu ikrene koikbuon ugon buon bu savo iji amariavo bakin ga bum ijia ireme ni buon ka mukor iji irav. ");
INSERT INTO nvm_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Regavo igia faif. E bomana moik samuamo ga ka sinuom zarainma be e Soromon fuka ugon uruvana ni mukor kafokafo iji ken. Regavo ugon ni mukor fuon iji bu sinar ijiebuon ni kafokafo bu iravo ijar ugon ni iji fuka ma asidiain. ");
INSERT INTO nvm_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Regavo madu igia faif. Garas iji bu ivia ijia irega e bu giav revo niar bu karajavori bun naoime barev. Ire garas iji buka ire ukakna ga God fuka vek bu samuagdiam. Ijefuon e guri ka ma vierafeoijo bakin gurie jaiji ja garas ijekin bano oifian ja abeoijo iji aref. God ja fuka ma amarigia samuagdiam ijefuon jaka fu ma vierafekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Regavo jab uri duok ga do ga sinuom ijiebuon kari uruvana igia vierafero note izia ire fok karekro karine ijeg vierafek. ");
INSERT INTO nvm_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Unam ijeg ja karine sinuom ga duok ga do ijiebuon uruvana vierafeoijo iji bu e iji God ma vierafejo bakin ijieb ijeg rejo. Regavo jaiji fu Asoijon varur gufia fino iji fu irerag fok ja kege karivakfuon iji fun amur giame vierafen. ");
INSERT INTO nvm_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ijefuon ni izeg God fu oijon iji samuagdiakfuon iji bomana vierafe vo unam fuon ma iji fu vierafenma ijar abe amur vierafene keof. Ja ijegrejknum kariokva fur koikfuon una madu ire iji ja kege karivakfuon iji kafo ifejdiak. ");
INSERT INTO nvm_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ijefuon afikin niarfuon iji jab karine uruvana vierafek. Ijefuon maiji fu God Asoijon ijar afikin niar ja abekfuon iji fur ifejdiak. Ijefuon ni isuar oij asusame afikin iji fu tavan kafokafo ijia roko iji besubesum giaknum kariofno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesu fu ijeg kuardiame kia, Ja e kafobuon ise iji jaba giame kuaikva God fuba vef ise jon iji giame una ijefuon kiak. ");
INSERT INTO nvm_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ijefuon maiji God fu unam izeg ja e kafobuon ise iji giame kuaivo ijeg fu vef ise jon iji giame una ijefuon kiak. Regavo madu unam izeg ja una e roin ijiebuon ja rejo God fu una vef ja ijeg rediak. ");
INSERT INTO nvm_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ijefuon a irerafuon uviaion ijefuon kafut ukakbe fu ni fuon ijia namo iji game kuagavo una kafut bomana iji fu ni on iji namo iji aba gam? ");
INSERT INTO nvm_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","A ni on kafut iji fu vek ijia namo iji a izeg una uviaion kua, Uviainu ro na ni kafut guraiji sadainma iji kedavno kuak. E guri ka iti kufuikin gure amur ni on ijia kafut bomana iji sadainma iji ke akorme ni ijar una kafut ukakbe iji fu uviaion ijefuon ni ijia namo iji game ke akozemne. A ni on kafut iji aba ke akozekma ab una uviaion ijefuon iji game kuaik. ");
INSERT INTO nvm_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Regavo na kuardiainva ijeg jab Godon vuak akaij iji abe va e iji bu vuak ma iji faikuai uzavo ijin kuardiak. E iji bu ire mon igi bu kege maf iji vajiavo igekin. Maf iji bu ire mon iji kege irerag abekfuon iji bu vierafenva bado bu kam datuaik. Ijegvo jaba mukor giaknum vuak nun ma iji abe va e iji buba oimarknum faikuai vierafenva iji kuardiakva buka uzak. Buka ada bijume una vuak jon bu ke karoime una buon ijia kuardiaknum kam kania arafiriakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesu fu ijeg kuardiame kia, Ja ire kafo vierafekva nika Asoijon varur gufia fino iji kuardaf. Ja kuardakva fu irerag ja kuavo iji fuka vajiak. Regavo ja ire be nisaikva nika giriesame magaga nisaikva God fu nijaidiaga ja gak. Regavo madu ja ire kafo vierafene ar fuon vien ijia kanakanakva fu vien dajame ifejdiak. ");
INSERT INTO nvm_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ijefuon maiji eraneb ja God tavan bog ire kafofuon kuavo iji ja karekfuon. Regavo eraneb ja nisaikva ja giak. Regavo madu eraneb ja vien ijia kanakanavo iji fu vien dajame ifejdiak. ");
INSERT INTO nvm_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Regavo igia faif. A ebe erar farifon iji fu iro fuon kuakma abe una mun abe mak? ");
INSERT INTO nvm_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Regavo fu kijumfuon kuakma abe una tabar abe mak? Iji fuka ma bakin. ");
INSERT INTO nvm_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Jaiji ja e ise rejo ga amjon bu ijeg ire kafofuon kiakva jaka uri ire ma iji bu kiavo iji kam vajiakfuon. Ijegvo Asoijon iji varur gufia fino iji fu eraneb bu kuakva fu ire ma iji vajiak. ");
INSERT INTO nvm_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Regavo ja e kiaga bu joifuon ire kafo rediakva iji ni jasik una vef buifuon izeg bu joifuon renva ijeg rediakfuon. Ijefuon maiji akaij iji e Mosis ga e Godon vuak vierafene kuaivo bu usuibe isoinva iji no ijeg kegokuai bu ijefuon isoinvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Jesu fu e vuak fuon faivo iji vuak kuardia vake kia, Ja unam ma iji ma karivako iji abekuai vierafekva ni vien ukak ijia aru vaf. Regavo unam iji fuka ma ukakbe ijefuon bu e sibank ijia vak. Regavo unam iji bu ar zuarunam ijia vako iji fuka ma bomana ijefuon e uruvana buka ijia vakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jesu fu ijeg kuardiame kia, Ja okva ni e i kufuikin iji bu vuak nun abe kuaimoijo iji mukor giaknum of. Bu ja karinva ijia roko iji buka e ma ga mukoi kego igekin. Regavo oibuon ijia izeg bu vierafeoijo iji buka siroij kuriai igekin. Bu jon ja ma vierafejo iji kam arafiriakuai reoij. ");
INSERT INTO nvm_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Regavo izeg ja bu ma vierafekfuon iji ja unam buon bu kegoijo ijia giakfuon. Regavo igia faif. In ifuor iji fube manine sunin ma iji bu ijo iji kirak? Regavo madu ja vierafe ufien ise gurogino kuavo juar ijia irenva iji bube sunin ma iji e bu ijo iji kirak? Iji fuka bakin. ");
INSERT INTO nvm_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Regavo in mukor iji fuka manine sunin fuon ka mukor ijesugin kirak vevo fuba sunin ise ijekma kirak. Regavo in ise iji fuba sunin ise kiraknum ga sunin ma iji kirak. ");
INSERT INTO nvm_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ijefuon in iji bu ireme sunin ma iji ba kiravo iji bu ufu karose mian jaga fu ijia nai barek. ");
INSERT INTO nvm_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ijefuon e i kufuikin iji bu vuak nun abe kuaimoijo iji ja unam buon iji bu kegoijo ja ijia giame vierafek. ");
INSERT INTO nvm_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Regavo igia faif. E fok bu na kie, E Bomanakono kiev. Regavo na vierafega e fok buka una e iji God fu oibuon iji samuagdiamo ijia buna mazikva bakin. Regavo bun e iji bu Asoinun iji varur gufia fino ijefuon ik iji fu vierafeno iji reoijo ijieb Godon e ijiena mazik. ");
INSERT INTO nvm_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Regavo vake tavan ka bomana ijia e uruvana bu uri kiek, E Bomana no if on ijia Godon vuak abe e kuardiainvano kiek. Regavo madu bu kiek no if on ijia kaven ise rotkuriaknum unam sumakin kafo renvano kiek. ");
INSERT INTO nvm_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Areme na uri samakaf kiak, E guri ka God igavo bakin gurie, Jaiji naka ba vierafenvano gareg vafno kiak. ");
INSERT INTO nvm_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ijefuon igia faif. Eraneb bu vuak nun igi mukor faime igiavo iji bu e iji fu mukor vierafeknum ar fuon iji munuag azan ijia sainma ijekin. ");
INSERT INTO nvm_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Fu munuag azan ijia ar same arekoga ve dame do firame ar iji abekafa arafirikoga buibur bomana ufime ar iji aben. Regavo ar iji fuba tuame bujain gavo fuka giremanin. Ijefuon maiji e iji ar fuon iji fuka munuag ka gigikin ijefuon azan ijia sain. ");
INSERT INTO nvm_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Regavo e fok eraneb bu vuak nun igi faime ba mimatavo iji bu e iji fuba mukor vierafene ar fuon iji abe jier azan ijia sainma ijekin. ");
INSERT INTO nvm_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","E iji fu ar fuon jier azan ijia same areko ve buikma dame uri do firain. Fu firame keko ar iji bijamga fuka tua dijeme bujase iserenmano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesu fu vuak fok ijeg kuardiame barekoga e fok ijia karinva iji bu vuak fuon iji faiva buka oiserdiain. ");
INSERT INTO nvm_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ijefuon maiji fu ebuon vuak akai nijaidiavo ijekin iji fu bakin gavo fuka e daro bomana abenma igeg nijaidiain. ");
INSERT INTO nvm_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ijegreare Jesu fun e iji funa oijo ijiena uruor iji areme una ari vako e ka uruvana bun uri fu jain. ");
INSERT INTO nvm_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Bu ijeg ja vako ijia e be adam kasi igekin bu kua refrosi kuavo iji abenma ijar kekome Jesu vako ijia ruain. Fu ijia keko ato same kua, E Bomana a oimarkma ni vajai nun igi amardiega na una madiemno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Fu ijeg kuamga Jesu fu imut akozme niriaknum kua, Na amardakro vierafenvano kuain. Fu ijeg kuardako ve ijia adam refrosi iji fu bakiten. ");
INSERT INTO nvm_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesu fu uri kua, Ab va e kafo irerag na on renva iji kuardiagavo nin amur va e God isuf baroidamon iji vajat on iji abe fu nijai. Areme ni ire kafo kege e Mosison akaij iji fu kuainma ijeg una God isuf baroga e bu ijia game vierafero adam on iji fun barenmaro bu ijeg vierafekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Ijegreare tavan be Jesu fun roke ar Kafoniam kekomga e Romkobuon e bomana be ijia fino ijar kekome fu bien. Fu vierafega Jesu fuka fu ifejdakro fu ijeg vierafen. Ijefuon fu keko Jesu dab soisoime kua, E Bomana enun ik reno be fu adam bomana abene fuka vajai gareme ar gafia nam. Regavo fuka vajai fian bomana abene isejavaimno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Fu ijeg kuardamga Jesu fu kua, Iji fun mardo na vua amardaga fu una maikno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Jesu fu ijeg kuardamga e iji fu kua, E Bomana na e ma bado a ar nun ijia aba vuak. Regavo nin ir on ijia kuaike enun ik reno iji fu una maimne. Na ma vierafega a vuak irerag ir on ijia kuaikma ire iji fuka rek. ");
INSERT INTO nvm_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ijefuon maiji nak na enun mamkanuk vuak irerag bu kuardievo na ijia kegoijo. Regavo madu e bijaivo roin bu rotit nun ijia ikrejo. Ijefuon na e be kua vakne kuakva fu vak. Regavo na be kua rokne kuakva fu ruak. Regavo na una enun ikreno iji be kua ire igi rene kuakva fu rekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","E iji fu ijeg kuardamga Jesu fu vuak ijin faima fuka uruvana igia oiseren. Ijefuon fu una dakaroim e iji bu fu ja vako iji kia, Na ar Isrer guf igia e kafo bu e igi fu ma vierafenma ijeg ma vierafenva iji kafo naka ba giain. ");
INSERT INTO nvm_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Regavo naka ma kuardiavo igia faif. Bu e Jius ijesugin bakigavo buka e uifarif kafokafo ar iror fok igi tavan ajiemo ga koino ijia e ma vierafejo uruvana e igekin iji bu e iji God fu oibuon iji samuagdiamo ijiena mazikfuon. Bu e Eburam ga Aisek ga Jekaf ijiena fata ijia karine duok ik. ");
INSERT INTO nvm_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Regavo e Eburamon uifarif iji bu vierafega bu e iji God fu oibuon iji samuagdiamo ijiena besum karine duok ikfuon iji God fu rotkuriaga bu usek. Bu usem makaf nakinman ijia niraime ubai jakinamikno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesu fu ijeg kuardiame una e iji kua, A na ma vierafenma ijefuon irerag a kuardienma iji na ifejdakno ni una vakne kuain. Jesu fu e iji ijeg kuardamga efuon ikreno iji fu ve ijia una main. ");
INSERT INTO nvm_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Areme Jesu fu e Fitan ar ijia aru vagak Fitan barak ijefuon asiej iji fu vajai vuaturiga fu ijia nam. ");
INSERT INTO nvm_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Fu ijia namga Jesu fu arume imut kega vajai vuat iji urino iji fun baren. Fun baremga bara iji fu uri duok vajiaknum bu samuagdiain. ");
INSERT INTO nvm_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Areme tavan fun nakisrenma ijia e uruvana bun uri e iji bu kaven ise ninarukiainva ijin aferdiame Jesuon ruain. Bu rokga Jesu fu kaven ise iji kuriaireme kiamga bu e iji areme usem vaknum e uruvana adam abejo iji amardiamga bu una madiain. ");
INSERT INTO nvm_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jesu fu ijegrega vuak iji Aisaia e Godon vuak vierafene kuaimon fu usuibe kuainma iji fuka ijekma aresren. Regavo vuak iji fu ijeg isoime kuai. Fu koikfuon adam nuvuon fok kafokafo fur kiaga bu barekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Areme tavan be Jesu fu giak buka e uruvana fu fino ijia zaraivga fu giain. Ijefuon fu uri e vuak fuon faivo iji kiamga bun uri do iji daturaiko nafuinma iji vajame gara vain. ");
INSERT INTO nvm_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Bun ik vakrejo ijia e vuak akai nijaidiamon be fu roke Jesu fino ijia kekoin. Fu kekome Jesu kuai, E nijaidiamon nan samuaido a izia vakma na osik ijia vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Fu ijeg kuardamga Jesu fu una roin kua, Iji a ma kuaim ga igia fai. Siroij taraiko foksno kuavo ijiga um iji bu mako ga nait buon bu amarenva bu ijia kariknum oijo. Regavo ema igiebuon farif igi naiji na ar nun na ijia fiknum ga nai fu madiega na una uri ik reokfuon iji na bano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Fu ijeg kuardakoga e vuak fuon faimo be fuk kekome Jesu kuai, E Bomana na a jakafie vierafen. Regavo ni areke na va asoinun samua fu guaga na abe mako rume una javno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Fu ijeg kuardamga Jesu fu una roin kua, E iji ba Godon vuak faivo iji bun aoinva igekin ijefuon nin are bur e iji aoivo iji kege mako ruf. Regavo aiji ani uri na jajiemne kuain. ");
INSERT INTO nvm_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Areme Jesu fun vanag be ijia ajiemgame e vuak fuon faivo iji bun funa ijia ajien. ");
INSERT INTO nvm_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bu ijia ajiekoga migegare buibur ka bomana ijar ijia ufikok do iji fuka firame foikoga vanag iji dab dakaroikafa ren. Regavo Jesu fuiji fun ni nain. ");
INSERT INTO nvm_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Buibur iji fu ijegrega e vuak fuon faivo iji bu uri Jesu saknum kua, E Bomana noiji noka aoikuai rejno ifejduomne kuain. ");
INSERT INTO nvm_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Bu ijeg kuardavga Jesu fu uri kia, E guri ka ba bomana ma vierafejo gurie jaiji ja irerafuon juvno kiain. Fu ijeg kuardiame uri buibur ijiga do iji firame foino iji ir fuon ijia kuriaireme bijuin. Fu bijumga do ijiga buibur iji bun ijia arekogame do iji fun una izeg ur fu nainma ijeg nain. ");
INSERT INTO nvm_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Fu ijegrega e vanag ijia karinva iji bu ire iji renma ijin gava buka oiserdiain. Buka oiserdiamga bu uri bui kuai, E iji fu e izekido fu buibur ijiga saof guri bijukuriamga buka fu igainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Areme Jesu fu vake moik Gadara do gara ijia kekoin. Fu ijia kekomga e nokarok (2) kaven ise ijieb ninarukiainva ijieb munua tit iji bu e aoiga bu ke uniavo ijia usem ruain. E nokarok (2) iji buka e ise ga ka e darokin ijefuon e bu ar iji bu karijo samaij ijia bu vako bakin. ");
INSERT INTO nvm_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ijefuon bu Jesu vakga bu uri biumame kume, Godon Farif gafe a noiji a kege irerag abekafa vierafen. Iviakma tavan igi fu tavan ma bakin ijefuon ab no kege arafiruomno kumen. ");
INSERT INTO nvm_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Regavo ar iji bu irenva samaij ijia buka maf uruvana ijia kunuimoij. ");
INSERT INTO nvm_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ijefuon kaven ise nokarok (2) iji bun uri Jesu soisoime kua, E-e ni kuoga no usem maf gafi ajiemdiavno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ijefuon Jesu fu uri kia, Ja iviakma e iji areme usem vafno kiain. Fu ijeg kiamga kaven ise iji bun e nokarok (2) iji areme usem maf iji ajiemdiain. Bu usem ajiemdiavga migegare maf iji bun subinai uruor ka ise ijia arime do ijia urame do ine aoim baren. ");
INSERT INTO nvm_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","34","Maf iji bu ijegrejga e iji maf samuagdiavo bu ire iji renma iji game bun subinai una mai bomana ijia vain. Bu va gafia useme ire iji renma ijin e fok kuardiain. Bu maf iji bu renva iji kuardiame madu uri e nokarok (2) iji bu kaven ise ijieb bu kam ninarukiavo iji izeg bu renva iji kuardiain. Ijefuon e fok mai guf ijia karinva iji bun uri Jesu biekuai useme vain. Bu usem va Jesu bieme uri soisoime kuavga fu mai iji areme una ar be ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Areme Jesu fun vanag abe do iji vajame una gara ar fuon ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Fu ijia vakga e roin bu e vajai garenma iji dab fata ijia uname abe fuon ruain. Bu afeme fuon rokga Jesu fu uri izeg e iji bu fu ma vierafenva iji giain. Ijefuon fu uri e iji kua, Farinu a mamoimo ijia giriesamne. Ise on iji nan game arenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jesu fu ijegrega e vuak akai nijaidiavo roin bu iji game una isuar bui kuai, E iji erar fu God asikro fu vuak ijeg kuaimno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Bu ijeg isuar karine bui kuaivga fun giame uri kia, Ja irerafuon isema vierafene karine kuaiv? ");
INSERT INTO nvm_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ja vierafega naba e igi kuaga fu suf fuon kara tuame uri vak? Nabe kuak ise on iji nan game arenvano kuak. Vuak nokarok (2) iji na izar e guri kuardaga ja ijia gieme na ma vierafekfuon? ");
INSERT INTO nvm_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ja naba ma vierafejo ijefuon na nijaidiaga ja ijia game ma vierafek. Ja ijia vierafero Emabuon Farif igi na daro abedo na moikigia ebuon ise iji na giame arevro ja ijeg vierafek. Fu ijeg kuardiame uri e vajai garenma iji kuai, Ni uri suf on iji kara tuame ar vakne kuain. ");
INSERT INTO nvm_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Fu ijeg kuamga e iji fu uri suf fuon iji karatuame fun ar vain. ");
INSERT INTO nvm_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Fun vako e fok bu iji gava buka dejufdiamga bu uri God dab aroin. Ijefuon maiji God fu e moikigia oijo iji daro miaga bu ire sumakin ijekin iji rej. ");
INSERT INTO nvm_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ijegreare Jesu fun ar iji areme vako ijia fu e Metiu e takes abeoinon iji bien. Fu ar fu fine ikreno ijia bieme kua, Ik on iji a reno iji areme na jajiemne kuain. Jesu fu ijeg kuamga Metiu fun ve ijia uri ire iji fu reno iji fuka ijia areme uri Jesu jame vain. ");
INSERT INTO nvm_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ijegrene rad Jesu fun va e Metiun ar ijia kekome fusik fine duok in. Fu ijia fusik duok ikogame e takes abesvo ijiga e ise reoijo uruvana bu usem Jesuga e vuak fuon faivo ijiena karine besum duok in. ");
INSERT INTO nvm_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bu ijegrejga e Ferisis roin bu giame una e Jesuon vuak faivo iji kia, Ja ejon e vuak nijaidiamon iji fu irerafuon e takes abejo ijiga e ise reoijo ijiena duok ino kiain. ");
INSERT INTO nvm_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Bu ijeg kuardiavga Jesu fun faime uri vuak be ijeg bijame kia, E adam bakin iji fuba e adam giamo iji vierafek ijefuon maiji fu adam bakin. Regavo fu e adagin ijar e adam giamo iji kuaga fu ifejdaga adam fuon fu una maik. ");
INSERT INTO nvm_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ijegvo ni e Osea vuak be fu usuibe kuainma iji nisaim dame vuak ma iji gaf. Regavo vuak iji bu ijeg isoime kuai, Naiji e bu fanuf ijia kania isuf baroijo iji na bomana vierafejo bakin. Regavo na e iji bu una kai kafobuon oifian abejo ijar naka bomana vierafejno kuain. Ijefuon na ruainva iji na e iji bu maturainva ijiebuon ruainva bakin. Regavo na e iji bu ise reoijo iji karauniakro ruainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Areme Jon e do ruardiamo ijefuon e vuak fuon faivo iji bu roke Jesu fino ijia useme kua, Noiji e Ferisis ijiena tavan uruvana no duok karovo. Regavo eon vuak faivo iji buba ijeg duok karov revo buka duok ijno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Bu ijeg kuardavga Jesu fu una vuak be ijeg bijame kuardiain. Fu kia, Tavan iji barubara bu sanamikuai duok ijo ijia e baru iji fu ijia fike bu e ruainva iji kia bu ire karome karine una oifiaigma vakva bakin. Buka oimarknum karine besum duok ik. Regavo buson rad tavan be baru iji fu bara iji afeme ai be vakma ijia e iji bu ijiason buifuon oifian abene duok karokno kiain. Unam besum ijegvo naiji na e iji fu bara abekreno igekin ijefuon na vek e vuak nun faivo iji buna fioijo ijia no besum oimarknum duok besum ik. Regavo tavan rad e ani nun iji bu na aferdiefe kaniga na guakva ijia bu nuifuon oifian abene duok karokno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jesu fu ijeg kuardiame uri vuak be izeg e Ferisis ijiebuon unam usuikor ijiga unam fuon iviamkor iji buba kege besum arunamikfuon ijefuon bijame kuardiain. Fu kia, E be fu erar ugon iviamkor be abe una usuikor ijekma sigukma bakin. Ijefuon maiji fu ijegrekma ugon usuikor iji fuka bomana bujakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Unam besum ijegvo fu erar vuain iviamkor iji abe una kamuij usuikor iji bu fanuf surif ijia amarenva ijia usekma bakin. Regavo fu ijegrekma kamuij usuikor iji fuka sisuikene bujaga vuain iviamkor iji fuk fuka usekma iji ire nokarok (2) iji buka iserek. Ijefuon vuain iviamkor iji buka kege una kamuij iviamkor ijia usekin ire nokarok (2) iji buka markno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesu fu vek vuak iji kuardiamo ijia e bomana be e Jiusbuon ar ukakna bu afuime vuak kuaivo iji samuamo iji fu roke ijia kekoin. Fu kekome Jesu manino nifak ijia atosame kua, Na kabainun iji iviakma fuka guain. Regavo na vierafega aka nosik vaikin a imut on ijia vajai fuon iji niriaga fu una uri oino kuain. ");
INSERT INTO nvm_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ijefuon Jesu fun uri fusik vako e vuak fuon faivo iji bu uri buna vain. ");
INSERT INTO nvm_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Regavo bara be fu ijia buna vako iji fu ise fi roke fun juaivasia tuer (12) ijeg baren. Regavo kavuan iji arimo iji fuba baren. Bara iji fu Jesuon nuon ijia ja vaknum vierafero fu Jesuon ugon buin ijia niriakma adam fuon fuka barekro fu ijeg vierafene uri ugon buin ijia niriain. ");
INSERT INTO nvm_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Bara iji fu ijegreko Jesu fun faime una dakaroim kua, Kabainu gufe a jumo iji arega giriesamne. On a ma vierafenma ijar adam on iji fun mukor barenmano kuain. Fu ijeg kuardako migegare bara iji fun ijia una main. ");
INSERT INTO nvm_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ijegreare Jesu fun e bomana ijefuon ar ijia aru vaga e uruvana bu ijia karine niraiknum mario foiknum ka uruvana irovajav. ");
INSERT INTO nvm_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Bu karine ijegrejga fu arume kia, Bara ukak iji fuba guain revo fum ninainmano ja niraivo arega ni usem makaf gafia vafno kiain. Jesu fu ijeg kuardiamga e fok bu uri fu dab varaimene kijdain. ");
INSERT INTO nvm_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Fun ijeg kiamga e fok bun usem makaf ijia vakga Jesu fun bara ukak iji namo ijia aru vain. Fu arume imut kega bara ukak iji gua namo iji fu una urin. ");
INSERT INTO nvm_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Fu ijegrega e fok ar mai samaij ijia karioinva bu ire sumakin iji renma iji fain. ");
INSERT INTO nvm_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Areme Jesu fun mai iji areme una ar be vakro vakgame e nizuriaigin nokarok (2) bu usem fu jame dab arafiri vain. E nokarok (2) iji bu ja vaknum kume, E Devidon uifarif gafe a no guoga oifiadaga ni ifejduomne kumen. ");
INSERT INTO nvm_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ijegrene Jesu fun vake ar ijia kekome ijia aru vakgame e ni zuriaigin nokarok (2) iji buk bun ijia jame aru vain. Bu aru vakga fu uri kia, Ni jon iji na amardiaga bu una marek gavo jabe na ma vierafekno kiain. Fu ijeg kiamga bu una kua, E Bomana no ma vierafega a aresredo a ni nuvuon igi una amarduokno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Areme Jesu fun uri ni buon ijia niriakdiaknum kia, Jon izeg ja ma vierafenva ijar ni jon iji bu una naravno kiako ni buon iji bu ijia una narain. ");
INSERT INTO nvm_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Bun ni naraga Jesu fu kuriairene kia, Ja vakva e kafo ire iji na rediainva iji jab kuardiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Fu ijeg kuriaire gavo buka magaga Jesuon vuak iji dab ai mai samaij ijia karioinva ijia kuaime vain. ");
INSERT INTO nvm_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ijegrene e nokarok (2) bun usem vakoga bu una madu e be afeme Jesuon ruain. Regavo e iji fu kaven ise ijar niroinma fu vuak kuaimon bakin. ");
INSERT INTO nvm_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Bu e iji afeme rokga Jesu fu migegare kaven ise iji kuamga fu e iji areme keko vako e iji fu ijia una vuak kuain. Fu una vuak kuaimga e fok buka oiserdiamga bu kuai, No usuibe ar Isrer igia ire ijekin be noka ba gainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Regavo e Ferisis roin bu kuai, E iji fu kaven ise ijiebuon e bomana ijefuon daro iji abenma ijefuon fu iji kaven ise iji kiaga bu i fuon iji faime usem vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ijegrene Jesu fun ar besubesum Gareri guf ijia ura giaoknum va e Jiusbuon ar ukakna bu afuime vuak kuaivo ijia arume vuak nijaidiaoin. Fu ijegrejknum e iji vuak ma iji God fu izeg oibuon iji samuagdiamo ijefuon vuak iji kuardiain. Fu ijegreknum e iji bu kavek kafokafo abejo ijigam adam abejo iji amardiain. ");
INSERT INTO nvm_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jesu fu ijegrejknum uri e uruvana bu unam kafokafo ijia oifiaigma oijo iji giama fuka bomana oifiain. Ijefuon maiji e iji buka unam kafokafo maf-sif iji bu e samuagdiamo bakin igeg buka oifian ga afikin abeoijo fu iji giain. ");
INSERT INTO nvm_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ijefuon Jesu fu una dakaroim e vuak fuon faivo iji kia, Godon juar ijia ire iji na giamga buka uruvana duin. Regavo e iji bu juar iji masime ire ijin kanafum ar ma ijia nakfuon iji buka sibank. ");
INSERT INTO nvm_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ijefuon uri sirimame God juar iji samuamo iji kuardaga fu una e juar ijia ikrekfuon iji kafo kega bu juar ijia ire iji masime una ar ma ijia nafno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesu fun e vuak fuon faivo tuer (12) iji kiamga bu rokga fu daro fuon iji miain. Fu daro iji bu abe kaven ise kiaga bu e iji areme vakfuon ga e adam abejo iji amardiakfuon iji miain. ");
INSERT INTO nvm_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","3","Regavo e vuak fuon abe oijo tuer (12) if buon iji igin. Amur iji e Saimon e iji bu kua Fitano kuavo ijiga uviaifuon e Edru ijin ken. Areme ura nokarok (2) iji fu e Zebedin afijaf nokarok (2) no uviaiki e Jeims ko Jon ga ura e Firif ko Batoromiu iji ken. Areme ura e Tomas ko Metiu e iji takes karmo ijiga e Arfiason farif Jeims ko e Tadias iji ken. ");
INSERT INTO nvm_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Areme ura e Saimon e iji bu kua Serotno kuavo ijiga Judas e iji bu kua Iskariotno kuavo e iji fu Jesu abe una e ise rejo iji miainma ijin ken. ");
INSERT INTO nvm_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesu fu e tuer (12) e iji ik fuon rekfuon ijin kege ar guf ijia uniame vuak ijeg kuardiamga bu vain. Fu kia, Ja vakva jab e Jius bakin ijiebuon moik ijia vako revo madu e Sameriakobuon mai ijia kafo jab aru vak. ");
INSERT INTO nvm_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Regavo ja vakva nin e Isrerko iji bu maf-sif igeg sauime ka isema karioinva ijiebuon ar ijia vaf. ");
INSERT INTO nvm_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Va bu karinva ijia vuak igi kuardiame kia, Tavan iji God fu efuon ijiebuon oij iji samuagdiakfuon iji fun samairenmano kiaf. ");
INSERT INTO nvm_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ja va vuak iji kuardiaknum vo e adagin iji amardia bu una madiaknum vo e aoivo iji kia bu una urif. Regavo madu e iji bu adam refrosi abejo iji amardia bu una madiav. Regavo madu ni e iji bu kaven ise ijieb ninarukiainva ijin kuriaireme kiaga bu e iji areme usem vaf. Regavo igia faif. Daro nun igi na vajiainva iji ja mon kime kenva bakin. Ijefuon irerag ja va kegoijo iji jab una vef ijefuon ire kafo karekuai vierafek. ");
INSERT INTO nvm_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Regavo madu igia faif. Jab ire gord ga sirva ga mon kavuan kafo kege ok. ");
INSERT INTO nvm_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Regavo madu jab e iji bu ire kafofuon ninamivo iji matiame kamuij mamkanuk kege ok. Regavo jab ugon ja savo iji uruvana ke ok ga jab diak surif ja savo ga guduar ja bijuasamoijo iji kafo kege ok. Ijefuon maiji irerag fok e ikreoijo bu kekfuon iji bu e iji bu ifejdiavo ijieb samuagdiaknum ifejdiak. ");
INSERT INTO nvm_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Regavo madu igia faif. Ja oine mai mamkanuk kafo ijia vakva ni giamga e be erar fu ja oimardiaknum aferdiaga ni ijia funa karif. Ja ijia funa karine vo nin ar iji areme vaf. ");
INSERT INTO nvm_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","13","Regavo ja gire be ijia ajiekva ni e ijia karinva iji mukor anadiame oimardiaf. Regavo ja ijia ajie vaga bu ja oimardiaknum aferdiaga ni ifejdiame sirimame God kuaga fu bu samuagdia. Regavo buba ijeg ja oimardiame aferdiaga jab sirimame God kuaga fu bu samuagdiamo. ");
INSERT INTO nvm_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ja afuime ar guf ijia oga e buba ja oimardiame aferdiakva ni ar ga mai iji areme vaf. Regavo madu ni uri diak surif jon ja savo iji azome kuotuvat iji kaniaseme ni ar iji areme vaf. Ja ijegrekin e mai ijia karinva bu giame vierafero ja bu jan mukor magiainvaro bu ijeg vierafek. ");
INSERT INTO nvm_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Regavo vuak igi naka ma kuardiav, Tavan radkma iji God fu una moikigia e ise kegoijo iji kege mazim giakma ijia ar Sodom ko Gomora iji fum sibank kege arafiriaken. Regavo una e iji eraneb bu ja nuigafiavo iji fuka kam unam ise ijia arafiriaga bu vajai fian abek. ");
INSERT INTO nvm_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Regavo igia faif. Jaiji na um kukoro igeg kege e ise siroij kuriai e jakiavo igekin uf ijia uniaga ja vak. Ijefuon ja va ik reokva ni amarigia jon samuanamiknum oij asusame kabuaikabuaikin ik jon ma ijesugin reof. Regavo jab uri bijaiknum vo ire ise kafo rega bu ja kam arafiriak. ");
INSERT INTO nvm_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Regavo ja okva ni e iji mukor giaknum of. E iji buka oine ja tofdiame kam e kot faivo ijiebuon vakfuon. Regavo madu buka e Jiusbuon ar ukakna bu vuak kuaivo guf ijia fijiakfuon. ");
INSERT INTO nvm_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Regavo madu ja nuifuon ik reoijo ijefuon e bu ka ja tofdia kam e kin kafo ga e Romkobuon e mamkanuk ijiebuon vakfuon. Bu aferdia ijia vaga ja e mamkanuk iji abevo e Jius bakin ijiebuon nifak ijia ireme Godon vuak ma iji kuardiakfuon. ");
INSERT INTO nvm_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Bu ja ijeg tofdiame aferdia vaga jab uri oiserdiamo. Regavo madu jab vuak irerag ja bu kuardiakfuon iji ga madu izeg ja kuardiakva ijefuon oifian abek. Ja tavan ijekin iji biediavo ijia vuak irerag ja una bu kuardiakfuon iji jam jar vierafekva bakin. Regavo vuak iji fu Asoijon ijefuon Kaven Akai ijar vif vajiaga ja kuardiakfuon. ");
INSERT INTO nvm_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Regavo vake tavan iji e bu uri e nuifuon ikrejo iji kania bu aoivo ijia e buka uri uviaifijaf ga afijaf iji koikbuon kege una foris vajiaga bu kania bu aoik. Regavo madu am iji bu una karoime eofijaf iji koikbuon sivisaga foris bu va kania bu aoik. ");
INSERT INTO nvm_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ja nuifuon ikrejo ijefuodo e fok buka ja ziegafiakfuon. Regavo eraneb bu giriesa magaga nuifuon ikre vake buin ijia usevo e iji God fu karauniak. ");
INSERT INTO nvm_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Regavo madu ja mai be ijia vaga e bu ja kaniaknum unam ise kafo jon rekva ni mai iji areme una be ijia vaf. Regavo igia faif. Mai fok ar Isrer guf ijia karioinva iji roin vuak nun jaba abe kuardiame barenva ijia Emabuon Farif igi na una ruakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Jesu fu ijeg kuardiame vake kia, E iji fu sikur reno iji fu efuon fu nijaimo ijefuon nigen iji fu fur asinma bakin. Regavo madu e monfuon ikreno bakin iji fu e bomana fuon iji fu fur asikma bakin. ");
INSERT INTO nvm_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ijefuon e iji fu sikur reno ijiga e iji fuba monfuon ikreno iji bu e mamkanuk buon matiame buonak kegokva iji fun marek. Regavo e iji na bu kiev aiji a Setan e kaven ise ijiebuon e bomanano kiev. Ijefuon bu E Bomana jon igi na bu izeg kiekva iji na vierafe ijefuon jak buka kam ma if ise ijia ifdiakfuon. ");
INSERT INTO nvm_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ijefuon e ise bu ire ise kafokafo jon rega jab giame juk. Ijefuon maiji unam ise buon fok kafokafo bu isuar nuriet reoijo iji rad God fu kege una e fok ijiebuon nifak ijia samafrega bu giak. ");
INSERT INTO nvm_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Regavo vuak irerag na naki kuardiavo iji ni jasik maza ijia useme dab e fok kuardiaf. Regavo vuak irerag no isuar nuvuonkua kuaimoinva iji nika abe useme ar iror fok kuardiame vaf. ");
INSERT INTO nvm_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Regavo jab e iji bu kaven jon iji buba kaniagavo bum vajai surif jon ijesugin kaniakrejo iji giame juk. Regavo e iji ja jukfuon iji nika God iji fu vajai surif abevo kaven iji kege mian iji tavan bog ijia naivako ijia kozega ja naoime barekfuon ijin juf. ");
INSERT INTO nvm_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Regavo igia faif. E bu um ukakna (um sfaro) roin kege una e kafobuon kimekva buka mon ukakna kafo kekfuon. Ijegvo God Asoijon iji fu fuon vierafenma ijia fu ire ka ukakna ijekin iji fu nuigafiamo bakin gavo fuka oijmiaknum samuagdiamon. ");
INSERT INTO nvm_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Regavo madu nigen jau jon izeg bu ijia irenva iji God fun vierafen. ");
INSERT INTO nvm_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Regavo um ukakna ijiga nigen jau iji buka ire ukakna gavo God fu fuon vierafenma ijia ire iji fu vek mukor samuagdiam. Ijefuon jak jaka Godon ire ikin kafo fu oijmiamo ijefuon ja fuka ijeg amarigia samuagdiamno jab juk. ");
INSERT INTO nvm_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Regavo erar fu e nifak ijia oknum kuai na Jesuon agano kuaimon iji nasik varur ijia Asoinun iji kua e iji fu e nuno kuak. ");
INSERT INTO nvm_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Regavo erar fu e nifak ijia na uzamo iji nasik varur ijia Asoinun ijefuon nifak ijia manine kua e iji fu enun bano kuakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","35","Jesu fu ijeg kuardiame kia, Moikigia na ruainva iji na e igi aferdia una besum afuikro ruainva bakigavo na e igi dab atakro ruain. Na e dab atasega e roin bu uri na igieme una nun ruakevo roin buka na nuigafiek. Bu ijegrene farif fu uri asoifuon ziegafake kabai fu uri asiefuon ziegafak. Regavo saifuon fu uri saifuon ziegafak. ");
INSERT INTO nvm_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Regavo iji bu ijegrekva iji bu e garerb kafo ijieb buna ijegrekva bakin. Regavo buka e gire besum karijo ijieb una buon ziegafanamime uri buon karijo iji dab iserek. ");
INSERT INTO nvm_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Regavo madu e be erar fu asoifuon ga asiefuon ijin uruvana oijmiagavo na fum sibank oijmiemo e iji fuba aresredo fu izeg kua na Jesuon agano kuaik. Regavo madu erar fu farifuon ga kabaifuon iji uruvana oijmagavo una na fu sibank oijmiemo e iji fuba aresredo fu izeg kua na Jesuon agano kuaikfuon. ");
INSERT INTO nvm_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Regavo erar fuba na oijmieme uri makai nun ijia jajieme vajai fian abeoino e iji fuka ba aresredo fuba e vuak nun faimo rek. ");
INSERT INTO nvm_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Regavo erar fu moikigia tavan bog fuon vierafenma iji oijmaknum kegoino iji rad fu una izeg unam ma karivako iji abekma bakin. Regavo erar fu moikigia tavan bog fuon ma fivakfuon iji fuka dazmevo una e roin vierafeknum oijmiame ifejdiafoino e iji fu rad unam ma karivako iji abek. ");
INSERT INTO nvm_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Regavo igia faif. Erar fu ja oimardiaknum aferdiamo iji fu madu na oimardieknum aferdiem. Regavo erar fu na oimardieknum aferdiemo iji fu madu e iji fu kiemga na ruainva iji oimardaknum afem. ");
INSERT INTO nvm_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Regavo madu erar fu e iji Godon vuak vierafene kuaimo iji amarigia giame oimardiaknum aferdiame samuagdiamo iji fun maren. Fu ijegreno ijefuon fu ire ma iji God fu bu vajiamo iji roin kekfuon. Regavo madu erar fu e iji Godon unam ma ijesugin kegoino iji amarigia game oimardaknum afeme samuagdamo iji fun maren. Fu ijegreno ijefuon fu ire ma iji God fu e iji vajamo iji roin kekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Regavo igia faif. E be erar fu vierafero jaiji ja e vuak nun faivo ijiro fu uri ire ukakna kafo ifejdiamo iji God fuka rad unam ma kafo fuon rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesu fun e vuak fuon faivo iji vuak ijeg nijaidiame fun uri ai Gareri guf ar ukakna ijia oknum e ijin vuak nijaidiain. Fu ijia vuak nijaidiaknum e ijin vuak ma iji abe kuardiamoin. ");
INSERT INTO nvm_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Fu ijegreokoga Jon fu dibur fine Kurais irerag fu reoinon iji fain. Fu vuak ijin faime uri e vuak fuon faivo roin kiamga bu fu kuagakuai vain. ");
INSERT INTO nvm_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Bun vake fu fino ijia useme kua, Aiji a e iji God fu kua fu ruakno kuainma ijin vo a baga no una e be samuakno kuain? ");
INSERT INTO nvm_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Bu ijeg Jesu kuardavga fu kia, Nin una va Jon irerag fok ja faivknum giainva ijin kuardaf. ");
INSERT INTO nvm_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Regavo ja kuardakva ni kua, E iji bu ni zuriainva iji bun una ni naraknum ga e aikirariainva iji bun una uri oij. Regavo e iji bu adam refrosi abenva iji bun una madiakok e ada bijukin iji bun una vuak faivno kuaf. Regavo madu ni kua e iji bu aoinva iji bun una urikok nan vuak ma iji dab e kavekin iji kuardiav. ");
INSERT INTO nvm_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Regavo kua, Erar fu ire igi na reoijo iji fuba faime dazga fum zinunba na ma vierafeno iji funika oimaremne kuaf. ");
INSERT INTO nvm_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","8","Jesu fu e Jonon vuak faivo iji ijeg kuardiame bun vakoga fu una dakaroim e fok bu afuinva ijin Jonsina kuardiain. Fu kia, Ja Jon fu ai moikum namo ijia oina ja faime usem gakuai vainva iji ja irerag iji gakuai vain? Jakafu e zazaikin be fu buibur asif abeno igekin ja iji gakuai vain. Ni irerag ja ijia gakuai vainva ni kuardie na fai. Regavo baga na vierafega jakafu ja e be fu ugon ni mukor same ijia oinon ja iji gakuai vierafene vain. Regavo iji fu bakigavo e ijeg ugon mukor savo iji bu e mamkanuk moik samuavo ijiebuon ar ma ijia karijo. ");
INSERT INTO nvm_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Regavo ja vainva iji ja irerag iji gakuai vain? Ja e Godon vuak vierafene kuaimon iji gakuai vainki ja eraiji gakuai usem vain? Ni kuardie na fai. Regavo na vierafega e iji ja gakuai vainva iji fun ma e Godon vuak vierafene kuaimon be. E iji fuka ma e ikin fur e Godon vuak vierafene kuaivo iji fu asidiain. ");
INSERT INTO nvm_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ijefuon maiji God fu usuibe buk akaij iji bu isoinva ijia fu e Jonon fu ijeg kuai, Na e vuak nun abe oinon be kuaga fu amur vuak. Fur amur unam jon iji amarme vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Regavo vuak igi naka ma kuardiavo faif. E mamkanuk roin bu ur kari ruainva iji bu e Jon e do ruardiamo ijekin bakin. E Jonri fuka ma e ikin fur bu asidiain. Regavo e iji God fu oibuon iji samuagdiamo ijiebuon uf ijia e be erar una e ukakbe reno e ijar fuka ma Jon asime e ikin rek. ");
INSERT INTO nvm_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Regavo tavan iji Jon fu uri anerene Godon vuak ma iji fu abe kuardiainma ijia roke iviakma igi Godon e iji fu samuagdiamo iji buka ma e uruvana rej. E uruvana bun ise bu reoijo iji areme una God e iji fu samuagdiamo ijiena mazikuai buka giriesav. ");
INSERT INTO nvm_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Regavo tavan iji e Godon vuak vierafene kuaivo bu karinva ijia ga e Mosison akai bu ik abenva ijia e iji buka karine tavan iji God fu ivez efuon ijiebuon oij iji samuagdiakfuon ijin dab karine kuaimoin. Bu vuak iji dab ijeg karine kuaime roke Jon e do ruardiamo ijefuon tavan ijia usen. ");
INSERT INTO nvm_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Regavo ja vuak buon iji jan ma vierafekuai samuainvaga e Jon ja gainva iji fu e Eraija e iji bu kuai fu ruakno kuainva ijin. ");
INSERT INTO nvm_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ijefuon ja adakiga ni vuak igi amarigia faime ma vierafekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Regavo na be bijame kuardiakrejo ni faif. E igi iviakma karine vuak ma iji ba mukoi faivo iji buka am ukakna igi bu ar iji e uruvana bu afuime ire kimejo ijia afuivo ijekin. ");
INSERT INTO nvm_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Am ukakna roin bu una roin kia, No joifuon zaij vajaga jaba dua uruv. Regavo no sise bijadiaga jaba oifian abe niraivo bu ijekin. ");
INSERT INTO nvm_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","E mamkanuk jon iji buk buka karine ijeg rej. Bu Jon fu tavan kafo ire karoknum ga do kugi iji ba iknum vo madu tavan iji fu uri Godon vuak ma iji abe kuardiamo iji bu game buka uzav. Bu kuai, E iji fuka kaven ise ijar niroinmano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Regavo una Emabuon Farif igi na keko duok iknum do vuain ijo bu una madu ijin uzav. Bu uzame kuai, Jam e guraiji gaf fu ire fok fuka abe i barme uri do vuain nibe ino gaf. Regavo madu fuka e iji takes abesvo ijiga e ise rejo ijiena kaikaraimoino kuaiv. Regavo igia faif. E ma vierafejo iji bu Jon ik irerag fu reoino ga na kegoijo iji bun guome vierafen. Bu vierafega God irerag fu vierafene reno iji fun amarigia renoro bu ijeg vierafejno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ijefuon Jesu fu ve ijia uri mai kafo fu amur oknum unam sumakin fok e ijiebuon nifak ijia reoinma ijin kam arafiriakafa buisina kuain. Ijefuon maiji e ijia karinva iji bu ire ise bu rejo iji buba areme una oi karoime fu ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ijefuon fu uri e iji kia, E iji ar Korazin ko Besaida karinva iji na vierafega ire ka ma ise be fu jon rekno nika juf. Ja unam sumakin na nifak jon ijia reoinva iji na una e ar Taia ko Saidon karinva ijiebuon rebatie e iji buka una ise buon ijefuon oifian abekfuon. Bu oifian abe niraime duok karoga e bu ijia giame vierafero bun una oi karoinvaro bu ijeg vierafek. ");
INSERT INTO nvm_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Regavo vuak igi naka ma kuardiavo igia faif. Vake rad tavan iji God fu una e moikigia ise rejo iji kege arafiriamo ijia e ar Taia ko Saidon karinva iji fum sibank arafiriaken. Regavo una e iji ar Besaida ko Korazin karinva iji ja fuka kam unam ma ise ijia arafiriakfuon. ");
INSERT INTO nvm_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Regavo una e ar Kafoniamko iji jaiji jab vierafero God fu ja fuka kege arordiame kam kaf gufia uniakro jab ijeg vierafek. Jaiji God fuka kam una ar ise mian naino ijia korekfuon. Ja unam sumakin iji na ni jon ijia kegoija ja gienva iji na ur e ar Sodom karinva ijia renvabatie e iji bun usuibe oi karoinvado God fuba amur fu kege arafiriaima ijeg fuba arafiriaken. ");
INSERT INTO nvm_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Regavo igia faif. Rad tavan iji God fu e fok igiebuon ise fu kege mazim giamo ijia fu e ar Sodom karinva iji fum kege sibank arafiriaken. Regavo una e ar Kafoniamko iji jaiji fuka amarigia kege unam ise ijia arafiriakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jesu fu tavan ijia ijeg kuardiame una dakaroim Asoifuon sirimame kua, God asoinun moik igeko varur gufi samuamo naka bomana on oimarev. Ijefuon maiji a e iji bu moikigia vuak mukoi vierafene kegoijo iji vuak ma iji a izeg ire kafokafo reno iji aka kege bu nisauikuriain. A bu ijegrene vuak ma iji aka dab una e ukakna iji bu vierafe ukakna kenva iji samafrediain. ");
INSERT INTO nvm_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ijefuon Asoinun unam ijeg a vierafene kenma iji an on izeg a rekafa vierafenma a ijia kenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jesu fu ijeg sirimamene una e iji kia, Ire fok na vierafeknum kegoijo iji fun Asoinun ijar kuardienma na ijia vierafeknum reoij. Regavo fu erar na amarigia gieme vierafekma bakin revo fun Asoinun ijar fuonkua na fun vierafen. Regavo madu fu erar Asoinun iji game vierafenma bakin revo nan farifuon igi nar nunkua fu nan game vierafen. Regavo nar koiknun na era vierafekva na iji amarigia ifejdaga fu Asoinun iji mukor game vierafekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Jesu fu ijeg kuardiame kia, Erar ire afikin uruvana kege oko aimaiga ni una nun roga na dasumda. ");
INSERT INTO nvm_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Na vierafega naka ja samuagdiakro vierafen ijefuon ni una agan nun iji na samuagdiavo ijiena mazif. Regavo uri unam nun iji abeknum vo na igief. Ijefuon maiji naiji naka e oi soigin ga naka kabuaikabuaiki kegoijo. Ja nana mazikva kaven jon iji bu dasu karikfuon. ");
INSERT INTO nvm_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ijefuon unam ma iji nun iji fuka mukor ga ik iji ja reokfuon iji na vajiavo iji fuka gigikin bakin. ");
INSERT INTO nvm_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jesu fu ijeg kuardiame tavan be fun e vuak fuon faivo ijiena va ire vuit juar ijia urame oin. Regavo tavan Sabat (Satade) iji bu isuar karine God sirimameknum oimardavo. Regavo e Jesuon vuak faivo iji buka vasiaordiainma ijefuon bun uri ire vuit garin iji kafo tuame imut tat ijia dakumume surif iji fuas koreknum ioij. ");
INSERT INTO nvm_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Regavo e Ferisis roin bu iji giame una Jesu kua, Tavan Sabat (Satade) igi noka isuar karijo. Regavo e vuak on faivo bu ire ijegreoijo iji buka tavan iji no isuar karine God sirimamejo ijefuon akaij iji dab tuasevno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Bu ijeg kuardavga Jesu fu una kia, Regavo ja buk akaij ijia Kin Devid fu efuon ijiena Godon ar ijia arume irerag abenva iji jabe dame vierafen? Bu vasiaordiainma ijefuon bu aru bred iji karme in. Regavo bred iji bu kege inva iji fuka akaij ijefuon e maikava bu ijo bakin. Regavo bun e iji God isuf baroijo ijieb buonkua bred iji ijo. ");
INSERT INTO nvm_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Regavo madu ja e Mosison akai fu isoinma ja ijia dame gabatie ja gia e iji bu God isuf baroijo iji bu tavan Sabat (Satade) uruvana buka tavan iji e bu isuar karijo ijefuon akaij iji dab tuaseme una ikrejo iji ja giak. Regavo iji bu rejo iji bu Godon nifak ijia ise rejo bakin. ");
INSERT INTO nvm_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Vuak igi naka ma kuardiav. Ik iji God fu kiemga na rekro ruainva ijar fuka ma ikin ga una ik iji bu Godon ar ijia rejo iji fum sibank ukakbe. ");
INSERT INTO nvm_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Regavo madu usuibe buk akai bu isoinva ijia God fu ijeg kuai, Naiji fanuf iji bu kania isuf baroidievo iji naba oimadiem. Regavo na e iji bu una e kafobuon oifian abene ifejdiavo na iji bomana oimarevno kuain. Regavo ja vuak iji mukor game vierafebatie ja e iji bu ise kafo ba rejo iji ja irerafuon ire ise kafo kege una bu namdiakva bakin. ");
INSERT INTO nvm_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ijefuon maiji Ema igiebuon Farif igi naiji fun Godri daro mieme ire fok kiemga na samuagdiav. Ijefuon tavan Sabat (Satade) iji ja isuar karijo ijefuon akaij iji ja javo iji nar kuardiaga ja faivknum kegokno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesu fu ijeg kuardiame fun vake e Jiusbuon ar ukakbe bu afuime vuak kuaivo ijia aruin. ");
INSERT INTO nvm_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Regavo ar guf ijia e be ij abe kirainma ijar ijia fin gavo madu e roin buk bu ijia afuime karin. Bu vierafega buka Jesu fu ire kafo isema rega bu iji gakuai vierafene nikajain. Ijefuon bu uri Jesu kua, A vierafega fube maredo a tavan Sabat (Satade) akai igi bu isuar karijo ijia e adagin iji una amardiakno kuain? ");
INSERT INTO nvm_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Bu ijeg kuardavga Jesu fu una kia, Ja e be erar a maf-sif be dabenma fu va tavan Sabat (Satade) iji isuar karijo ijia mako urakma a izeg rek? Abe ijia magake fu mako ijia manine vajai fian abek? Na vierafe a ijegrekma bakin gavo aka va keunaga fu ajiekek vakfuon. ");
INSERT INTO nvm_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Regavo maf-sif iji bum mafdo a ijegrekma iji fun marek. Regavo ema iji fu ijeg vajai fian abeke am ni ijesugin gakma iji fuka ba markfuon. Ijefuon no tavan Sabat (Satade) akai isuar karijo ijia no e ifejdiakva iji no akai tuasekva bakigavo no ma rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jesu fu ijeg kuardiame una dakaroim e iji ij abe kirainma iji kua, Eko ij on iji akozemne kuain. Ijefuon e iji fun ij fuon iji akozemga fuka una ij fuon ma iji be ijekin ren. ");
INSERT INTO nvm_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jesu fu ijegrega e Ferisis roin bu una usem makaf ijia unam izeg bu fu kanakfuon iji isuar buon kuaime uijuinamin. ");
INSERT INTO nvm_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Bu ijegreoijga Jesu fun giame uri ar iji areme una ai be vain. Fu vakgame e ka uruvana bu fu jame dab arafirime vakga fu adam buon fok kafokafo iji amardiama bu una madiain. ");
INSERT INTO nvm_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Fu amardiame kia, Ja vaga eb ja giame kia ja erar ja amardiaimano kiaga jab kuardiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Regavo Jesu iji fu kuriairenma iji fuka izeg e Godon vuak vierafene kuaimon E Asaia fu usuibe kuainma ijekma aresren. ");
INSERT INTO nvm_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Regavo vuak iji fu kuainma iji bu ijeg isoime kuai, E iji God nar kuaga fu nuifuon ikreoin. Fuiji naka bomana oijmavo ga fu nuifuon ikreko na gaga fuka oimadiem. Ijefuon na Kaven nun iji fu unafdaga fu e Jius bakin iji vuak nun abe kuardiak. Fu kuardiaga e fok buka izeg God nar rad bu karauniakfuon bu iji mukoi faime vierafekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Regavo fu vuak kuardiakma fuba uri uruvana kuriaireme kuardiak. Regavo fuba ena musikuaik ga vuak aramame kuaimok. Regavo madu fu unam ijia vuak kuaimoino iji e buba faik. ");
INSERT INTO nvm_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Regavo e iji bu unam ma iji reokuai zazaivo iji fuba kuriaikuriaiki kuardiaknum ifejdiak. Regavo madu fu e iji bu buon ma vierafejo ijia zazaivo iji fu ifejdiaga bu una giriesame izeg God nar rad karauniakfuon iji ma vierafekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Fu ijegrekega e ai moik fok karioinva iji buka una fu ma vierafe barekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Areme e kafo bu uri e be ni zuriaigin fu vuak kuaimo bakin iji afeme Jesuon ruain. Regavo e iji fu kaven ise ijar ninarume dab arafirimo ijefuon fu vuak kuaim vo ni narame e giamo bakin. Bu e iji afeme Jesuon rokga fu uri kaven ise iji kuriairemga fun e iji areme keko vain. Fu vakoga e iji fun ijia una vuak kuaiknum ni narame nisain. ");
INSERT INTO nvm_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","E iji fu ijegrega e fok bu unam sumakin iji Jesu fu renma iji gava buka oiserdiain. Buka oiserdiamga bu una bui kuai, Ja vierafega e iji kafu e Devidon uifarif iji fu ruakno kuainva ijino kuain. ");
INSERT INTO nvm_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Bu ijeg kuaimoijga e Ferisis iji bu faime una kia, E iji fu kaven ise Setan E Birzibabno kuavo ijefuon e. Ijefuon fur daro maga fu kaven ise iji kuriairega bu faime e iji areme usem vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Regavo Jesu fun oibuon ijia izeg bu vierafenva iji fun giainma ijefuon fu uri vuak be ijeg bijame kuardiain. Fu kia, E moik besum ijia karijo iji bu uri ata roinroin rene bui bijaikva iji bu izeg amarigia karikva bakin. Regavo madu mai be ga agan be bu una bui nigaraiknum karikva iji buon ma karijo iji fuka iserekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ijegvo Setanon ar fu samuamo ijia kaven ise bu uri una buon nigaraikva fuka mukor iserekfuon. Bu buon nigaraikva iji bun abe atavo ijefuon bu izeg una mukoi karikva bakin. ");
INSERT INTO nvm_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ja kuai na Setan e Birzibabno kuaivo ijar daro miega na kaven ise iji kuriairega bu usem vakno kuaiv. Regavo ja vierafega e vuak jon faivo iji bube Setanon daro ijia kaven ise iji nisarediaga bu usem vak? Na vierafe iji fu bakin. Ijefuon vuak izeg ja nuisina kuaivo iji jaka mukoi vierafene kuaivo bakin. ");
INSERT INTO nvm_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Regavo giega na Godon daro ijia kaven ise iji kuriaireme rotkuriaga ja vierafek. Ja ijia giame vierafero tavan iji God fu una anerene efuon iji samuagdiakfuon iji fun igijaro ja ijeg vierafekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Regavo madu igia faif. E be fu erar va e darokin be ijefuon ar ijia ajieme sinuom fuon iji niesakma bakin. Regavo fu niesakafa vierafekma fuka e kuriai iji kunaim dab tome fuson sinuom fuon iji niesamdakfuon. ");
INSERT INTO nvm_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Regavo e be erar fuba na oimardiemo e iji fu enun bakin. Regavo madu erar fuba ifejdieme e aferdia una Godon roko e iji fuimve e kuriaireme nisaremdiaga bu atase vak. ");
INSERT INTO nvm_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ijefuon na kuardiako faif. Godri fuonkua ema ijiebuon ise bu rejo ga vuak ise bu kuaivo iji fu giame arek. Regavo erar bu vuak ise una Kaven Akai iji fuisina kuaivo iji God fuba giame arekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Regavo madu erar fu vuak ise kafo una Emabuon Farif igi na nuisina kuaimo iji God fu giame arek. Regavo erar bu vuak ise kafo una Kaven Akai iji fuisina kuaimo iji God fuba giame arek. Fu iviakma igi ga tavan bog fuka ijeg navakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jesu fu e Ferisis iji ijeg kuardiamo ijia fu madu vuak be ijeg bijame kuardiain. Fu kia, Ja in ma be fu manina ja gainva iji ja vierafero fu sunin ma iji kirakro ja ijeg vierafek. Regavo in ise ijar manikma iji ja vierafero fu sunin ise iji kirakro ja ijeg vierafek. Ijefuon in iji fu ma vo fu ise iji ja sunin fuon fu kiramo ja ijia game vierafek. ");
INSERT INTO nvm_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","E guri ka ise tabar gurie, Iviakma vuak igi na bijame kuardiainva jaiji ijekin. Ja e guri ka ise reoijo iji ja izeg una vuak ma kuaimok? Ijefuon maiji e ijiebuon oij ijia irerag bu vierafejo iji bu ir ijia kuaimoij. ");
INSERT INTO nvm_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Regavo e iji fu oifuon ijia ire ma ijesugin vierafeoino iji ir fuon iji fun vuak ma ijesugin kuaimoin. Regavo e iji fu oifuon ijia ire ise vierafeoino iji ir fuon iji fun vuak ise ijesugin kuaimoin. ");
INSERT INTO nvm_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Regavo igia faif. Rad tavan iji God fu una e moikigia ise reoijo iji kege mazim giamo ijia fu e fok vuak ise iji bu kuaimoinva ijefuon kiaga bu irerafuon kuainva bu iji kuardaga fu faik. ");
INSERT INTO nvm_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ijefuon maiji God fu ir on ijia vuak irerag a kuaimoinma ijia jame ise on iji gaga an mukor kegoijga fu iji gak. Regavo fu gaga a isema kegoiga fu ijia samakaf kuaga a faikno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jesu fu ijeg kuardiamga e vuak akai nijaidiamo roin ga e Ferisis roin bu uri una kua, E nijaidiamon no vierafe aka ire sumakin be rega no ijia game a ma vierafekfuon. No ijia ma vierafero an ma Godri kuamga a ruainmaro no ijeg vierafekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Bu ijeg kuardavga fu una kia, E guri ka God mukoi vierafejo bakin ka ise reoijo gurie jar ire sumakin giakuai vierafen. Regavo na vierafe iviakma ire sumakin be naba rek. Regavo nason rad ire sumakin besum fu e Jona e Godon vuak vierafene kuaimon ijefuon renma ijekin be ja gakfuon. ");
INSERT INTO nvm_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","E Jona fu tavan nokbek (3) ga naki nokbek (3) fu kijum ka bomana be ijefuon defok ijia fin. Ijefuon Ema igiebuon Farif igi nak na moik guf ijia tavan nokbek (3) ga naki nokbek (3) na ijia nak. ");
INSERT INTO nvm_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Regavo vake rad tavan iji God fu e moikigia ise reoijo ijiebuon ise iji kege mazim giamo ijia e mai Ninevako iji buka una vuak ise e igi ja iviakma karinva iji joisina kuaikfuon. Ijefuon maiji bu e Jona vuak iji fu kuardiainma iji faime buka una oi karoime ire ise fok bu nuigafiain. Regavo e Jona fuiji fum e moik igeko ga e Ninevako buka vuak fuon amarigia faime igain. Regavo ivia naiji naka E Bomana gavo vuak nun igi jaka ba faiv. ");
INSERT INTO nvm_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Regavo madu bara Kuin moik Sibako iji fuka rad tavan iji God fu e moikigiebuon ise iji kege mazim giamo ijia fu e igi ja fuka kam arafiriame vuak ise joisina kuaik. Bara iji fuka moik buin roin ijia fino ga fuka uri Kin Soromonon uguar ma iji fu vierafene kuaimon iji ifejdakro ruain. Regavo e Soromon iji fum sibank e ukakbe gavo nar naka ma e ikin be na iga manine vuak kuardiav. Regavo vuak nun igi jaka ba mukoi faivknum vo na ma vierafejo bano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesu fu ijeg kuardiame kia, Na e unam ise rejo buba oi karoigakva bu izegrekfuon na iji be bijame kuardiako ni faif. Tavan iji e bu kaven ise iji kuriaireme rotkuraga fu e iji areme vako iji fu va ai moikum namo ijia ar fu fikfuon iji nisaimok. ");
INSERT INTO nvm_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Fu nisaimoga bakma fu una fui kuaik, Nan ka una ar na ur fine ruainva ijia vakno kuaik. Ijefuon fun una roga ar iji fuka mukor iviamkor kafut ga ire kafo bakin ga fu ro gak. ");
INSERT INTO nvm_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Areme fun una madu va kaven ise seven (7) ka ma ise ijin aferdia una ro ar ijia arume karik. Bu una ro e iji fu ur fu ire ise sibank keoinma iji niroikva rad fuka una biom ka ma ise iji keok. Ijefuon e zazaikin guri ja iviakma karijo iji jaiji jaka ijekin. Na ire sumakin be nifak jon ijia rekva janim surif jon ijesugin ma reokfuon. Regavo ja una oijon ijekma ma vierafeknum kegokva bakin. Ja ijegreoijo ijefuon ise iji fu oijon ijia namo iji rad fuka bomana rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesu fu vek e fok vuak kuardiamo ijia asiefuon ijiga uviaifijaf iji bu roke vien ijia useme fu samuame iren. ");
INSERT INTO nvm_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ijefuon e be fu uri Jesu kua, Asieon ijiga uviaifon iji bu a vuak kuardakuai ruainva vien gufa samuagdame irenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Bu ijeg kuardavga Jesu fu una kua, Regavo ja vierafega asienun ijiga uviaifnun iji erano kiain? ");
INSERT INTO nvm_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jesu fu ijeg kuardiame una dakaroim e vuak fuon faivo iji imut bijiame kia, Uviaifnun ga asiefnun ma iji e igi ja karinva ijin. ");
INSERT INTO nvm_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ijefuon maiji erar fu irerag fok Asoinun varur gufia fino fu vierafenma ijia kegoino e ijar fu uviainun ga makinun ga asienuno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jesu tavan besum ijia ijeg kuardiamevo fun ar iji areme una kekome do Gareri nafuinma irif ijia va ijia fin. ");
INSERT INTO nvm_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Fu fine vuak nijaidiaknum giak buka e uruvana usem dab kirakuravga fu uri vanag be ijia namo ijia ajien. Jesu fu vanag ijia ajieme abe sibank biom do ijia abedeme fikoga e iji vainva bu irif ijia iren. ");
INSERT INTO nvm_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Bu ijia irekoga fu ijia uri vuak fuon fok fuka ke bijiame kuardiain. Fu kia, Ni e be juar meno fu kekome juar fuon ijia uij dajaikafa vainma iji vierafef. ");
INSERT INTO nvm_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","E iji fun va uij koremoko uij roin bu uduime unam iji e bu oijo irif ijia ariva bun um ijieb ari kare in. ");
INSERT INTO nvm_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","Regavo roin bu uduime munuag azan ijia arime buka tavuain revo gireg buon iji buba uruvana sain. Ijefuon maiji sakin maiji fu ukakbe ijefuon bu tavua ajievo fun ve keko kaniama buka sairen. ");
INSERT INTO nvm_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Regavo uij roin bu uduime ufien gurogin uf ijia ariva fun ijar tavuame uij ma iji fun okuriain. ");
INSERT INTO nvm_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Regavo uij roin bu uduime moik mukor safikin ijia arime buka mukor tavuame sunin kirain. Sunin roin buka uruvana adred (100) ijeg kirakoga roin bu sibank siksti (60) ijeg kirako roin bu teti (30) ijeg kirain. ");
INSERT INTO nvm_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ijegvo erar fu adakiga ni vuak igi amarigia faifno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Areme e Jesuon vuak faivo bu uri ro Jesu kua, Vuak on fok a bijiame e guri kuardiainma iji a irerafuon ijeg kuardiainma ni kuarduo no faivno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Bu ijeg kuardavga Jesu fu una kia, Na unam sauivkin izeg God fu efuon ijiebuon oij iji samuagdiamo iji nan e iji ja na jajievo iji kuardiame nijaidiain. Regavo una e roin iji naba samakaf nijaidiagavo nam ijeg bijame kuardiak. ");
INSERT INTO nvm_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ijefuon erar fu vuak ijefuon maiji roin fun faime vierafenma iji God fu una ifejdaga fu madu vuak fuon ma iji kafo faivknum fivak. Regavo erar fu Godon vuak ijefuon maiji fuba amarigia faikro vierafeno iji God fum una vierafe sibank iji fu vierafeno iji fuka kamazaga fum ijia ijeg fivak. ");
INSERT INTO nvm_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ijefuon maiji e igi iviakma karinva iji bu vuak fok na kuardiaknum izeg na kege nijaidiavo iji buka giavknum faiv. Regavo buka ba faim vo giainva igeg karioij. ");
INSERT INTO nvm_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ijefuon na vierafe vuak iji Aisaia e Godon vuak vierafene kuaimon fu usuibe kuainma iji fuka ma kuain. Regavo vuak iji fu kuainma iji bu ijeg isoi, E iji vuak faivo iji jan faik revo anej ma iji jaba mukoi vierafekfuon. Regavo ja nisaivo iji jan nisaik ga ja ire be gakva bakin. ");
INSERT INTO nvm_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ijefuon maiji e ijiebuon nigen iji buka mukoi gigikin ga ada bu vuak faikfuon iji bun koikbuon bijukuriain. Regavo ni buon iji buka nisuinvado bu ire kafo giavo bakin. Regavo buba ijegrevabatie bu unam ma iji giaknum vo vuak ma iji faik. Regavo madu bu nigen samafrega bu vierafene una nun roga nar amardiak. ");
INSERT INTO nvm_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Regavo una e guri ja na jajievo iji fun Godri ifejdiaga ja vuak nun faiv. Regavo madu fur ni jon mukor narakdiaga ja amarigia gieme vierafero na ma Godon farifro ja ijeg vierafek. ");
INSERT INTO nvm_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Regavo naka ma kuardiavo igia faif. E Godon vuak vierafene kuaivo fok ga madu e fok bu Godon unam ma ijesugin kegoinva iji buka vuak ma igi faikuai karine ijefun ren. Regavo madu buka irerag igi ja iviakma giavo ijefuon buka bomana karine ijefun ren. Regavo nibuon ijia be buka bagain vo fain. ");
INSERT INTO nvm_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ijefuon ni vuak iji na abe e iji fu uij dajaioinma ijia bijame kuardiainva ijefuon ma iji mukor vierafeke na kuardiaf. ");
INSERT INTO nvm_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ire uij roin bu uduime unam ijia ariva um ijieb kare inva ijefuon maiji fu ijeg. E roin bu Godon vuak ma igi na izeg God fu oibuon iji samuagdiamo iji na kuardiavo bun fain. Regavo bu vuak ma iji buba abe oijbuon ijia abedev. Bu ik faiko fun Setanri kekome vuak ma iji fun abe vak. ");
INSERT INTO nvm_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Regavo uij roin iji bu uduime munuag azan sakin ukakbe namo ijia arinva iji e iji bu oimarknum vuak iji migegare faivo ijin. ");
INSERT INTO nvm_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Bu vuak iji fai gavo buba abe oibuon ijia gigikin vierafej. Ijefuon bu Godon vuak iji abe oine ga e binob ise kafo buon rejknum kam unam ise ijia arafiriaga bu vajai fian abejo ijia buon vierafejo iji buka migegare ijia arev. ");
INSERT INTO nvm_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Regavo uij roin bu uduime gurogin uf ijia ariva ufien ijieb okuriainma iji e iji bu vuak ma iji faiknum ga una izeg bu moik igia oi marknum kariokfuon iji vierafejo ijin. Bu ijegrejknum buka sinuom ga mon uruvana oij miaknum uruvana vierafejo ijar vuak ma iji bu fainva iji buka rubdiam. Ijefuon vuak ma iji bu fainva iji fu oijbuon ijia tavuame ajie sunin kiramo bakin. ");
INSERT INTO nvm_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Regavo uij iji bu uduime sakin ma ijia arinva iji e iji bu vuak ma iji faime abe ma gigikin vierafejo ijin. Bu vuak ma iji fu oijbuon ijia tavuame sunin kiramga buka uri unam ma iji ma uruvana reoko roin bu sibank uruvana reko roin bu sibank ren. ");
INSERT INTO nvm_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesu fu ijeg kuardiame fun una madu vuak be abe bijame ijeg kuardiain. Fu kia, Unam izeg God fu efuon ijiebuon oij iji fu samuagdiamo iji fu e be juar fuon ijia uij mukor iji abe dajaimoine fun una ar vainma ijekin. ");
INSERT INTO nvm_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Fun una vakoga naki be e fok bun ni naoikoga e ani be fu isuar kekome uij be ka ise iji abe uij ma kafar ijia dajaimoine fun vain. ");
INSERT INTO nvm_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Fu vakoga uij ma iji fun tavuame ajie sunin fuon ma iji kirakafa reno ijia e bu ijiason uri uij ise ijin giain. ");
INSERT INTO nvm_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ijefuon efuon ikrejo iji bu useme kua, E bomana juar on aka uij ma iji abe dajain. Regavo ufien nibe guri fu unam izer ijia ro ijia tavuainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Bu ijeg kuavga fu kia, Unam iji bu e ani nun ijieb renvano kiain. Fu ijeg kuardiamga bu una roin kua, Regavo abe kuoga no va ufien iji fok ka jafene kare korekno kuain? ");
INSERT INTO nvm_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","30","Bu ijeg kuardavga fu kia, Ja ufien mekva jaka uij ma ijekma jafekno ni ijia are bu besum tavua. Bu ijia besum tavuake no vake tavan iji no uij afurvejo ijia nason giak. Na tavan ijia e ire uij afurvejo iji kiaga buka amur ufien ise ijar jafe ufame kam mian ja bu naoik. Bu jame fu naike bu uij ma iji kanafume una ar nun ma ijia namdiekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesu fu ijeg kuardiame una madu vuak be madu bijame kuardiain. Fu kia, God izeg fu efuon ijiebuon oij iji fu samuagdiamo iji fu ire uij ka ukakbe in sira sunin igekin e be fu abe oinma ijekin. ");
INSERT INTO nvm_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","E iji ire uij iji fuka ukakbe ga fu abe juar ijia oga fu tavuame in ka bomana um fok bu ro ijia nait abejo ijekin. Unam besum ijegvo iviakma Godon e iji bu sibank uruvana rej gavo rad e ma uruvana buka una efuon rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesu fu ijeg kuardiame una vuak be bijame ijeg kuardiain. Fu kia, Iviakma unam izeg God fu efuon ijiebuon oij iji samuagdiamo iji fuka ire ist igi fu reno ijeg ren. Bara iji fu ire farava bomana dis ijia useme ire ist ukakbe abe farava ijekma davaruaime abedekma fuka ma bomana buofoi urikno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesu vuak fuon fok fu e uruvana kuardiainma iji kafo fuba una vuak ma ijekma kuardiain. Regavo vuak fok fuka ke bijiame ijia kuardiain. ");
INSERT INTO nvm_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ijefuon vuak izeg e Aisaia e Godon vuak vierafene kuaimon fu usuibe kuainma iji fun ijekma aresren. Regavo vuak fu kuainma iji bu ijeg isoi, Na e iji vuak kuardiakva naba vuak ijiebuon maiji samakaf kuardiagavo vuak fok naka ke bijiame kuardiak. Na vuak ma iji fok sauivkin iji God fu ik ire fok igi ba amardiainma ijia bu sauime naoivo iji naka kuardiame nijaidiaga e bu faikno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Areme Jesu fun e iji ijia uniakome fun una ar ijia aru vakga e vuak fuon faivo iji bun ijia jame aru vain. Bu aru ijia useme kua, Ni vuak iji a abe ufien iji bu juar ijia tavuavo ijia bijame kuainma ijefuon ma iji kuarduo no faivno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Bu ijeg kuavga fu una kia, E iji fu uij ma iji dajainma iji Emabuon Farif igi nar. ");
INSERT INTO nvm_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Regavo juar iji moik fok gavo uij ma iji Godon e iji bu unam ma ijia kegoijo ijin. Regavo ufien iji Setanon e iji ise reoijo ijin. ");
INSERT INTO nvm_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Regavo e ani iji fu ufien dajaimo iji Setan. Regavo tavan iji uij afurvejo iji tavan radkma ijin gavo e iji uij afurvejo iji Godon anera ijin. ");
INSERT INTO nvm_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Regavo ufien iji bu jafene anuse mian javo iji tavan radkma ijia fu ijeg rekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tavan ijia Emabuon Farif igi nar anera nun iji kia bu moikazan fok igia oknum e kege atak. Bu ijia oknum ufien igi bu jafene mian javo ijeg bu ga e iji bu enun iji arafiriavo fok bu kam mian ijia jaken. ");
INSERT INTO nvm_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Bu e ijin kam ar ise mian naino ijia jaga bu ijia naoim niraime ubai jakinamik. ");
INSERT INTO nvm_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Areme e iji bu Godon unam ma iji abenva iji bu God Asoibuon ijefuon ar fu samuamo ijia karik. Regavo vajai buon iji buka tavan iji fu sanamon ijeg sanake bu ijia karik. Ijefuon erar ja adakiga ni vuak igi mukoi faime vierafeofno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesu fu ijeg kuardiame kia, God izeg fu efuon ijiebuon oij iji fu samuagdiamo iji fu ire gord be bu abe juar kafar be ijia mako rume sauinva ijekin. Bu abe sauivga e be fu ijia juai meoine uri gord iji game fusik una sakin atame okurame ijia aren. E iji fu ire iji gama fuka oimaimga fu una ar ijia kekome sinuom fuon fok fu karme una e kafobuon kimen. Areme fun mon ijin kege una va e ar kafar iji samuamo iji kimene fun moik kafar iji fuon aben. ");
INSERT INTO nvm_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Regavo madu God efuon ijiebuon oij iji fu samuagdiamo iji fu e iji fu mun ka ni mukor iji kimekafa nisaimoino ijekin. ");
INSERT INTO nvm_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","E iji fu mun ijekin iji nisaimoine be gakma fuka oimarek. Fu oimarme una va sinuom fuon fok kege una e kafobuon kimene mon abe una mun mukor iji kimekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Regavo madu igia faif. God izeg fu efuon ijiebuon oij iji fu samuagdiamo iji fu ugie iji e do oijo bu abe do gamia oine kijum kafokafo karavo ijekin. ");
INSERT INTO nvm_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bu ugie iji abe oine kijum bu ijia iviame irtoijekma e iji bu dakara dab irif ijia abedek. Areme bun karine kijum iji karame ma iji bu kamuij ijia kegavo ise iji bu kare korek. ");
INSERT INTO nvm_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Ijefuon vake tavan radkma ijia unam ijekin iji fu rek. Godri anera iji kiaga bu arime moik fok igia oknum e kege atak. Bu atame e ise renva iji bu be uniagavo e iji unam ma ijia kegoinva iji bu be uniak. Bu ijeg atame e iji ise renva iji bu kam ar ise mian naino ijia jaga bu ijia naoime niraiknum ubai jakinamikno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesu fu e vuak fuon faivo ijin vuak ijeg bijame kuardiame kia, Ja vuak fok na kuardiainva iji jan fainvano kiamga bu kua keno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ijefuon fu una kia, E iji erar fu Mosison akai bu nijaidiainva iji fai vo iviakma fu una vuak igi God izeg fu efuon ijiebuon oij iji fu samuagdiamo iji mukoi faime vierafeno iji fu e ar koikin igekin. E iji fu gire fuon ijia sinuom fuon fok iviamkor ga usuikor iji fuka karme keko e fok nijaidiakfuon. Unam besum ijegvo jaka va e fok Godon vuak ma usuikor ijiga vuak nun iviamkor iji kege fok nijaidiafno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Jesu fu vuak ijeg bijame kuardiame barme fun una ar fuon ijia vain. Fu ijia kekome va e Jiusbuon ar ukakna bu afuime vuak kuaivo ijia arume e iji vuak nijaidiain. Fu vuak nijaidiamga e bu vuak fuon iji faiva buka oiserdiain. Ijefuon bu una bui kuai e iji fu unam izeg vierafe ijiga daro iji fu abe unam sumakin iji reoinon iji abenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bu ijeg kuaiknum kuai e iji fu Josof e iji ar samon ijiga bara Meri iji non vierafenva ijiebuon farif. Regavo madu fu e Jeims ga Josof ga Saimon ga e Judas iji non giavo ijiebuon uviaij. ");
INSERT INTO nvm_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","57","Regavo makifijaf iji bu nona igia oijo iji non vierafen. Regavo ire fok fu reoinon iji fu izeg iji reoinon kuaime buka fu uzain. Rega Jesu fu kia, E ar kafokafo ijieb e iji Godon vuak vierafene kuaimon ijefuon vuak iji bu mukor faime una fu igain. Regavo una e aganfuon ga e ar fuon iji buka una fu nuigafainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ijefuon Jesu fu ar fuon ma ijia fu unam sumakin kafo fuba uruvana ren. Ijefuon maiji efuon iji buba fu ma vierafenva ijefuon fu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Jesu fu ijegreokoga tavan ijia e Erod moik Gareri samuamo iji fu vuak ijin fain. ");
INSERT INTO nvm_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Fu faime uri efuon ikrejo iji kia, Ire ijekin iji fu erar igia reokma bakin. Ijefuon na vierafe e iji fuka e Jon e do ruardiamo ijar una urinman ijefuon fur ire sumakin darokin iji reno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Regavo iji fu ijeg kuardiainma ijefuon maiji fu Erodri ur kiamga bu Jon kunaim tome afem dab dibur unain. Ijefuon maiji Erod fu uviaifuon Firifon barak Erodias abega Jon fu kua, Aka isema remano kuamga fu ijefuon dab dibur unain. ");
INSERT INTO nvm_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Fu kuardame kua, Unam iji a una uviaion ijefuon bara iji abenma iji aka akai tuasen. ");
INSERT INTO nvm_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Regavo Erod fuiji fu vierafe fuka kia bu Jon kanaga fu guakro fu ijeg vierafene fu una e Jius iji juin. Ijefuon maiji e Jius iji bu ma vierafega e Jon fu ma e Godon vuak vierafene kuaimon be ijefuon fu iji vierafen. ");
INSERT INTO nvm_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Areme tavaibe e Erodon tavan bu nafenva iji rokga e bu besum afuime duok in. Bu duok ikoga bara Erodiason kabaij iji fu uri e fok ijiebuon nifak ijia dua urumgame Erod fuka oimain. ");
INSERT INTO nvm_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ijefuon Erod fuka uri e fok karinva ijiebuon nifak ijia bara iji kua, A irerag be vierafene kiekman naka ke vajakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Erod fu ijeg kuardamga bara iji fun izeg asiefuon Erodias fu ur kuardainma ijeg kuardain. Fu kua, Na vierafega aka iviakma igia e kia bu va Jon e do ruardiamo iji kaname nigen fuon iji kanafume abe ter ijia abedeme igia miega na vierafero fu ma guainmaro na ijeg vierafekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Fu ijeg kuardamga Erod fuka bomana oifiaimga fu arekafa vierafen. Regavo fuka e fok duok ijo nifak ijia kua, A irerag kafo kiekma na ke vajakno kuainma ijefuon fum ijia ren. Ijefuon Erod fun e bijaivo fuon iji kia, Ni va dibur ijia aru Jon kaname nigen fuon iji kanafume abe una igia ruafno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ijefuon e bijaivo iji bun vake dibur ijia useme Jon kaname nigen fuon iji kanaufuin. Bu kanaufume abe ter ijia abedeme abe usem aru bara iji mavga fun abe una asiefuon iji main. ");
INSERT INTO nvm_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ijegrekoga rad e Jonon vuak faivo iji bun va dibur ijia usem e ma iji abe usem mako ruin. Areme bun vake Jesu fino ijia usem vuak fok izeg bu renva iji kuardain. ");
INSERT INTO nvm_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ijefuon Jesu fu vuak iji faime fun uri e vuak fuon faivo ijiena vanag abe ar iji areme bun ai e bakin ijia vain. Bun vakga e fok bun vuak iji faime uri ar buon iji areme bun roin diak ar fu vakafa vako ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Bu vake ijia useme karijga Jesu fu rad vanag abe do uf ijia urame vake ijia kekoin. Jesu fu ijia ari kekome e fok bu afuinva iji giama fuka oifiain. Ijefuon fu uri e adagin uruvana roin bu vainva iji adam buon iji ifejdiame amardiamga buka una madiain. ");
INSERT INTO nvm_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Jesu fu e ijin ijeg ifejdiakok tavan fuka kokafa ren. Ijefuon e vuak fuon faivo iji bu useme kuai, Ar igi fuka ai e bakin ga tavan gari fun gara kokafa vak. Ijefuon ni e guri kiaga bu mazak va ar gafia duok bu ikfuon iji kafo nisaime kimejno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Bu ijeg kuardain rega Jesu fu una kia, E iji na vierafe buba vakgavo ni jar duok kafo asaimgia vajiaga bu ijno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Fu ijeg kuardiamga bu una kua, No duok iji fu bakigavo no bred imut roin (5) ga kijum nokarok (2) ijeg igaijar ke ruainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Bu ijeg kuardavga fu kia, Ni duok iji kare igia vajiefno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jesu fu ijeg kuardiame una dakaroim e fok imut ijia bijukuriamga bun garas azan ijia ari karin. Bun ari karikoga fun uri bred imut roin (5) ijiga kijum nokarok (2) iji ken. Fu kege kaf ijia kuniaime gafeg Asoifuon iji oimardame kege ukakna tuasen. Areme fun kege e vuak fuon faivo iji vajiamga bu karme e fok ijia karinva iji vajiain. ");
INSERT INTO nvm_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bu vajiavga e fok buka defiamga ukur iji bu e vuak fuon faivo ijieb karen. Bu karme ter ka uruvana mamkanuk tuer (12) ijeg anusen. ");
INSERT INTO nvm_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Regavo e fok iji bu duok inva iji e baru ijesugin bu dainva iji fuka ma uruvana faiv taosen (5,000) ijeg. Regavo bara ijiga am ukakna iji buba dain. ");
INSERT INTO nvm_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Areme Jesu fun migegare e vuak fuon faivo iji kiamga bun vanag be ijia ajieme bun ur do iji nafuinma ijia ura gara vain. Bun vakoga Jesu fun roin uri e fok vainva iji kiamga bun una ar buon ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bun vakoga fu roin una fuonkua uruor be ijia ajieme sirimamekafa vain. Fun va ijia fuonkua fine sirimameko fun ve nakim. ");
INSERT INTO nvm_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Regavo e vuak fuon faivo iji buiji bun vanag abene buka do uf garia vain. Regavo madu buka buibur bomana iji ufimo ijia vako ijefuon do iji fuka foine vanag iji dab dakaroikro ren. ");
INSERT INTO nvm_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Areme Jesu fu ve ik afarkreno ijia fun uruor iji areme una arime do azan ijia vuim una e vuak fuon faivo bu vako ijiebuon ruain. ");
INSERT INTO nvm_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Fu do azan ijia rokga bu game ka bomana juin. Bu vierafero kafu zuar rokoro buka uri jume kumen. ");
INSERT INTO nvm_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Buka juvga Jesu fu migegare kia, Na narno jaib jukgavo giriesafno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Areme Fita fu una roin kua, E Bomana aiji an ma arga ni kiega na do azan guria vuim vuakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Fu ijeg kuamga Jesu fu una roin kua, Ni do azan ijia vuim rokne kuain. Ijefuon Fita fun arime anere do azan ijia vuim Jesu manino ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Regavo Fita fu una buibur bomana iji fu ufiko do iji fu foinon iji game fuka bomana juin. Fu ijeg juko ijia fun anerene gama arimga fu una Jesu kume, E Bomana na ifejdiemne kumen. ");
INSERT INTO nvm_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Rega Jesu fun migegare ij akozme Fita imut kene kua, E ige on a na ma vierafeno iji fuka ukakbe. Ire fok nar rejo ijefuon na ma vierafegavo iji a uri jume zazaimo iji aremne kuain. ");
INSERT INTO nvm_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bu ijegrene bun una vanag ijia ajiekoga buibur iji fu ufimo fun ijia aren. ");
INSERT INTO nvm_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Areme e fok vanag guf ijia karinva iji buka uri fu ato same sirimamene kua, No vierafega aka Godon Farifno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Areme bun vanag abe ijia ura vake do irif gara ar Genesaret kuavo ijia arin. ");
INSERT INTO nvm_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bu ijia arivga e ijia karinva iji Jesu bun game vierafedo bun uri e iji bu ar ukakna samaij ijia karioinva iji vuak nijiain. Bu vuak nijiavga e fok bun uri e adagin iji ijia karioinva iji darume Jesuon ruain. ");
INSERT INTO nvm_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bu usem Jesu soisoime kuaga fu kia bum ugon fuon buin ijia niriaga bu una madiakno kuain. Ijefuon eraneb bu uri Jesuon ugon buin ijia niriainva iji adam buon iji fuka migegare una madiain. ");
INSERT INTO nvm_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Areme e Ferisis roin ga e vuak akai nijaidiavo iji bun Jerusarem ijia uri roke Jesu fino ijia usen. ");
INSERT INTO nvm_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Bu useme kua, E vuak on faivo iji bu irerafuon bu unam usuikor saifnuvuon iji bu kegoijo iji no jajiavo iji buba ijia jajiav. No saifnuvuon iji bu duok ijo buka imut do some duok ijo. Regavo eon iji buba ijegrejno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Bu ijeg kuardavga Jesu fu una kia, Regavo jak ja irerafuon Godon vuak iji jaka magaga una unam jon usuikor iji reoij. ");
INSERT INTO nvm_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ijefuon maiji God fu kuain, Am iji asiefjon ijiga asoifjon iji igiafno kuain. Regavo madu erar fu vuak ise kafo una asoifuon ga asiefuon kuardakma e iji ka kana fu guamno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Regavo jar nijaidiavo iji ja kuai, E be erar fu mon fuon kafo fu duok kime eofijaf vajiakafa nainma iji fub mon iji kege una God vajakno kuain. Ijefuon fu ijegreno iji fu asoifuon igamo bakin. Ja ijegrejo ijia ja Godon vuak iji fu ja kuardiamo iji jaka faime magaga una unam jon ijia reoij. ");
INSERT INTO nvm_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","E guri ka i kufuikin vuak ijia mareoijo gurie, Na vierafe Aisaia e Godon vuak vierafene kuaimon vuak irerag fu usuibe joifuon kuainma iji fuka ma. ");
INSERT INTO nvm_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Regavo vuak fu kuainma iji bu ijeg isoi, E iji bum ir ijesugin kuai no God aroivo kuaigavo bu oibuon ijekma aroivo bakin. ");
INSERT INTO nvm_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Regavo madu buon bu sirimamene na vierafeoijo iji ma iji fuka bakin. Ijefuon maiji bu Godon akaij iji e nijaidiavo bakigavo bu ema ijiebuon akaij iji kege e nijaidiavno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Areme Jesu fun e fok kumega bu fuon rokga fu uri kia, Vuak igi na kuardiakrejo iji amarigia faime vierafef. ");
INSERT INTO nvm_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","E iji fu oine duok ino iji fu duok ijar fu abe Godon nifak ijia ise reno bakin. Regavo fu vuak irerag fu oifuon ijia vierafene kuaimoino iji fu vuak isekma ijar e iji fuka Godon nifak ijia fuba maturainmano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Rega e vuak fuon faivo iji bu uri kua, No vierafega vuak iji a kuainma iji e Ferisis iji bu kafu ka oifiadiainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Bu ijeg kuardavga Jesu fu una vuak be ijeg bijame e iji kuardiain. Fu kia, E Ferisis iji bu uij iji Asoinun varur gufia fino ijar oinma bakin ijekin. Ijefuon rad bu uij ijin gireg gamekma jafek. ");
INSERT INTO nvm_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ijefuon ja buifuon jab bomana vierafek. E Ferisis iji bu oknum una e roin aferdiame unam buon ijia vako iji buka e ni zuriaigin. Ijefuon maiji e be fu una be imut ke vakma bu busik buka mako urakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Fu ijeg bijame kuardiamga Fita fu una kua, Ni vuak ijefuon ma iji kuarduoga no faivno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Fu ijeg kuardamga Jesu fu kia, Ja e fok jaka non giako e vuak nun faivo iji buk buka vek non giav. ");
INSERT INTO nvm_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Regavo ni igia faif. E iji duok fu ino iji fu ir ijia iga fu ari defok ijia kekome na vak. ");
INSERT INTO nvm_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Regavo vuak irerag fu oifuon ijia vierafeno ijar fu ir ijia kuaimon. Ijefuon ijar e iji fu Godon nifak ijia fuka ba mukoi reoin. ");
INSERT INTO nvm_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","E iji fu oifuon ijia ire ise vierafeno iji fu e kaniaga bu aoiknum ebuon bara turaknum ebuon sinuom niesamo ijin. Regavo madu vuak kufuimeknum una e kafobuon vuak ise buisina kuaivo ijin. ");
INSERT INTO nvm_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","E ire ijegreoijo ijieb bu Godon nifak ijia buka maturainva bakin. Regavo iji una imut do ba some duok ijo iji fu Godon nifak ijia fu iserenma bano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesu fu ijeg kuardiame fun e vuak fuon faivo ijiena ar Genesaret areme bun una uri ar Taia ko Saidon samaij ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Bu ijia vakga bara Keinanaitko be ar ijia fino ijar kekome Jesu biumaknum ruain. Fu ruaknum kume, E Bomana e Devidon uifarif gafe a nuifuo oifiadakma ni ifejdiemne. Na kabainun fuka kaven ise ijar dab arafiriko fuka mukorigia vajai fian abeno kumen. ");
INSERT INTO nvm_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Fu ijeg kumega Jesu fuba una vuak kafo kuardain. Ijefuon e vuak fuon faivo iji bu useme Jesu soisoime kua, Bara iji fuka biumaknum ruako noka iseduomno kua fu vakne kuain. ");
INSERT INTO nvm_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Bu ijeg kuardaga Jesu fu una kia, God fu kiemga na ruainva iji na e Isrerko ijesugin ifejdiakro ruain. Na e Isrerko iji buka maf-sif igeg bu e iji bu samuagdiamo iji buka unakome buonkua oifiaigma oijo na iji ifejdiakafie ruainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Fu ijeg manine kuardiamo ijia bara iji fu kekome Jesu ato same kua, E Bomana ifejdiemne kuain. ");
INSERT INTO nvm_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Fu ijeg kuamga Jesu fu una roin kua, No am ukakna ijiebuon duok bu ijo iji no kamaziame ke una siroij iji vajiakva fuka ba markno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Jesu fu bara iji ijeg kuardamga fu una kua, Iji a ma kuardiem. Gavo siroij iji bu ebuon mamkanuk ijiebuon fata rotit ijia duok ukur iji uduime arivo iji buka ijin ikno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ijefuon Jesu fu una roin kua, Bara gure on a na ma vierafenma iji fuka ma bomana ijefuon irerag a vierafenma iji na ifejdakno kuain. Jesu fu tavan ijia bara iji ijeg kuardakoga tavan besum ijia kabaifuon ijefuon adam iji fuka bakiteme una main. ");
INSERT INTO nvm_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Areme Jesu fun ar iji areme uri e vuak fuon faivo ijiena uri do Gareri nafuinma irif ijia amedakiem vain. Jesu fu ijia ame vako ijia fu uruor be ajieme vake makaf ijia kekoin. ");
INSERT INTO nvm_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Fu ijia ajie kekome fikoga e ka uruvana bu e adam kafokafo kenva iji aferdiame fuon ruain. Bu e iji aikirariainva ga ni zuriainva ga vua ba kuaivo ga adam abenva ijin aferdia ijia ruain. Bu aferdiame usem Jesu manino ijia uniavga fu amardiama bu una madiain. ");
INSERT INTO nvm_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jesu fu ijeg amardiamga e iji ai kirariainva iji bun una uri oko e iji ni zuriadiainva iji bu una ni narakoga e iji vua ba kuaivo iji bu una vuak kuain. Fu ijegrena e fok bu iji gava buka oiserdiamga bu uri e Isrerkobuon God ijin dab aroin. ");
INSERT INTO nvm_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Areme Jesu fun uri e vuak fuon faivo iji kiamga bun una besum afuivga fu kia, Na e guri bu afuinva iji giaga naka bomana oifiadiem. Ijefuon maiji bu tavan nokbek (3) bu nana igia karin ijefuon na vierafe buka duok bakin. Regavo na duok kafo ba vajiaga nam kia bu una ar buon ijia vakva iji fuka ba marek. Bu vasiakma una vakva bu izeg daro abekva bado buka nizigdiame ari kaniakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jesu fu ijeg kuardiamga e vuak fuon faivo iji bu una kua, Noka ai moikum namo duok bakin igia karij. Ijefuon no izia duok kege e fok guri gormiakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Bu ijeg kuardavga Jesu fu kia, Regavo ja bred izeg nainvano kiain. Fu ijeg kiamga bu kua, No bred seven (7) ga kijum ukakna sibank nainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Bu ijeg kuardavga Jesu fun e fok kiamga bu moik ijia ari karin. ");
INSERT INTO nvm_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Areme fun uri bred seven (7) ijiga kijum iji kege una Asoifuon oimardain. Areme fun ke tuaseme una e vuak fuon faivo iji vajiamga bu karme una e iji vajiain. ");
INSERT INTO nvm_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bu vajiavga e fok bu ija buka defiamga ukur roin bu iremiren. Areme e Jesuon vuak faivo iji bun uri duok ukur ijin karme ter mamkanuk seven (7) ijeg anuin. ");
INSERT INTO nvm_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Regavo e fok bu ijia duok inva iji e baru ijesugin buka e fo taosen (4,000) ijeg. ");
INSERT INTO nvm_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesu fun uri e fok kiamga bun una ar buon ijia vakoga fu roin uri vanag abe fun moik Magedan ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Areme tavan be e Ferisis ijiga e Sejusis roin bu Jesu biesuakuai ruain. Bu roke fu fino ijia useme kua, A vierafega an ma Godri kuamga a ruaiga ni unam sumakin be nifak nuvuon ijia rega no game una a ma vierafejno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Bu ijeg kuardavga Jesu fu una vuak be ijeg bijame kuardiain. Fu kia, Ja oine ga fu tavan nakisrene varur garia kavuaimo iji ja kuai fu tavan markreno kuaiv. ");
INSERT INTO nvm_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Regavo suok iji fu varur garia kaziga ja kuai fu ve bomana dakreno kuaiv. Ijefuon ja tavan gari fu ve dakre vo bakin iji jan varur garia izeg fu reno iji game vierafek. Ijegvo ire sumakin kafo na igaijar reoko jan giev ga ja ire ijiebuon maiji jaka ba mukoi vierafej. ");
INSERT INTO nvm_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","E guri ka isema rejknum God ma vierafejo bakin gurie jar ire sumakin iji giakuai vierafen. Regavo na vierafe God fuba kiega na unam sumakin be rega ja gakfuon. Regavo nason rad ire sumakin besum iji fu e Jona e Godon vuak vierafene kuaimon iji fuon renma ijekin be ja gakno kiain. Jesu fu ijeg kuardiamevo fun e iji ijia uniakome fun vain. ");
INSERT INTO nvm_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Fu vakoga e Jesuon vuak faivo iji bu uri vanag be abene bun do iji nafuinma irif gara vain. Regavo iji bu vainva iji buka rubdiamga bu bred kafo bu ikfuon iji buka ba ke vain. ");
INSERT INTO nvm_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ijefuon bu isuar buon karine una ijefuon kuaiv. Bu ijeg karine kuaiva Jesu fu giame uri kia, Ja okva ni e Ferisis ijiga e Sejusis buon ire ist iji bu bred amardiavo iji mukorigia akariaknum ofno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jesu fu ijeg kuardiamga bu vierafekuai fu kafu bred buba ke vainva ijefuon kuaimoro bum isuar karine una bui kuaiv. ");
INSERT INTO nvm_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Regavo Jesu fun giame uri kia, E gurie jon ma vierafejo iji fuka ma ukakbe. Nan ma bred jaba ke ruainva ijefuon kuardiavo bakigavo ja irerafuon una ijin dab siguv. ");
INSERT INTO nvm_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Jaiji jaka nana besum oin gavo jaka vek ba na ma vierafen. Ja bred faiv (5) sibank iji na ke tuaseme e fok faiv taosen (5,000) iji na gormiainva iji jabe vierafen? Regavo ja bu iga ukur arevga ja karme ter izeg anuinva iji jabe vierafen? ");
INSERT INTO nvm_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Regavo madu ja bred seven (7) iji na ke tuaseme e fo taosen (4,000) iji na gormiainva iji jabe vierafen? Regavo madu ire ukur iji ja ter izeg anuinva iji jabe vierafen? ");
INSERT INTO nvm_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ja unam iji jan giain gavo ja irerafuon jaka ba ma vierafen? Regavo bred iji bu ire ist ijekma amarenva iji na kuardiainva iji na ma ijefuon kuardiainva bakin. Gavo na e Ferisis ijiga e Sejusis buon unam ka ise bu kegoijo na ijefuon abe ijeg ire ist ijia bijame kuardiain. Ijefuon iji vierafene mukorigia giaknum ogavo jab una unam buon ka ise bu vierafene kegoijo ijia jajiavno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Areme e vuak fuon faivo iji bu ijiason una vuak ma iji vierafen. Bu ijia vierafero fu ma ire ist ijefuon kuainma bakigavo fu bur e Ferisis ijiga e Sejusis buon unam bu nijaidiavo iji agordiakro kuainmaro bu ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ijegreare Jesu fun e vuak fuon faivo ijiena vake ai Sesaria Firifai samaij ijia kekoin. Fu ijia kekome uri kia, Ja vierafega e bu Emabuon Farif igi na giekva bu era vierafekno kiain? ");
INSERT INTO nvm_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Fu ijeg kuardiamga e vuak fuon faivo iji bu una kua, No vierafega e roin bu a gakva bu vierafero aiji a e Jon e iji fu e do ruardiamo ijinro bu ijeg kuain. Regavo roin bu vierafero aiji a e Eraija ga roin bu kuai a e Jerimaia vo baga a e Godon vuak vierafene kuaimon bero bu ijeg vierafenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Bu ijeg kuardavga Jesu fu una kia, Regavo jaiji ja izeg vierafenvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Fu ijeg kuardiamga e Saimon Fita fu una kua, Na vierafega aiji aka God iji tavan bog ijia fivako ijefuon Farif. E iji bu usuibe kuai fu ruakno kuainma ijino kuain. ");
INSERT INTO nvm_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Fu ijeg kuardamga Jesu fu una kua, E Saimon e Jonan farif gare na vierafega fun Godri a mardain. Ijefuon maiji bu e kafob nijaidainva bakigavo fun Asoinun varur gufia fino ijar oion ijia vuak iji vierafe maga ijefuon a ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","19","Ijefuon igia fai. Aiji iviakma if on na Fita kuak, Regavo if ijefuon maiji tuar ka gigikin ijin. Ijefuon na enun bu na jajievo iji na kege a uniafdaga ar samuagdiaga buon ma vierafejo iji fuka gigikin rek. Regavo Setanon e iji buiji bu daro bado bu unam on a kegoino iji buba bijukurak. Regavo nar a daro maga a Godon unam ma iji abe e fok kuardiame nijaidiaknum samuagdiak. Regavo irerag kafo e bu moikigia reoijo iji a giamga bu isega a kuriaireme bijukuriamo iji God varur gufia fino iji fuk fu ijeg kuriaireme bijukuriak. Regavo irerag kafo bu moikigia reoijo a giamga bun ma a oimadako bu reoijo iji God varur gufia fino fuk fu ijeg oimardiakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Areme Jesu fu uri e vuak fuon faivo iji fuka kuardiame kia, Jab va e roin kia na Kurais e iji bu kuai fu ruakno kuainva ijino kuardiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Areme Jesu fun tavan ijia anerene uri fu guakfuon iji fuka samakaf visume e vuak fuon faivo iji kuardiain. Fu kia, Na vierafe naka Jerusarem ijia e mamkanuk nuvuon ga e akai nijaidiavo ga e Godon isuf baroijo iji karinva ijia vak. Na ijia vaga bu na dab unam ise kafokafo ijia arafirieme vajai fian vajiega naka vajai fian uruvana igia abene isejavaik. Na isejavaime vake buka kaniega na guame naki nokbek (3) barke God fu kiega na una madu urikno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Fu ijeg kuardiamga Fita fun uri Jesu imut ke va fuonkua manine kua, E Bomana vuak iji kuaimo iji fuba maren. Na vierafe God fuba ire ise ijekin iji kuaga fu on rekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Fu ijeg kuardamga Jesu fu una dakaroime Fita kua, Setan gareg va. Na gaga aka ik iji God fu kie na rekro ruainva a iji bijukuriem. Ijefuon maiji vuak iji a vierafene kuardiemo iji fu Godri vierafe mako a kuardiemo bakin. Regavo vuak iji am ema ar vierafene kuardiemno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Areme Jesu fun una e vuak fuon faivo iji kia, E be erar fu diak makai nun ijia jajiekafa vierafekma ni ire fuon fok moik igefuon iji ka nuigafiakfuon. Fu ijegrevo uri vajai fian kafokafo bu fuon roko iji ka ijia magiaga nuifuon ikrekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ijefuon maiji erar fu una fuon izeg fu ma fivakfuon iji uruvana vierafeno iji rad fuba unam ma karivako iji abek. Regavo erar fu tavan bog una e roin oijmiame ifejdiamo iji rad fu unam ma karivako iji abek. ");
INSERT INTO nvm_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Regavo erar fu moik igefuon sinuom iji oijmiagavo God fu uzamo iji kaven fuon iji fun abe aberem. Regavo madu fu moik igefuon sinuom ijieb ifejdaga fu Godon ar ma ijia aru vakma bakin. ");
INSERT INTO nvm_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ijefuon maiji Emabuon Farif igi nar tavan radkma ijia anera nun ijiena una Asoinun ijefuon sanainma ijekma ruak. Na una kekome uri e besubesum izeg bu kegoinva ijia giaknum una vef ijefuon unam ma iji ga ise kafo buon rediakfuon. ");
INSERT INTO nvm_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Regavo vuak igi naka ma kuardiavo faif. Iviakma e guri ja karinva ijia e roin ja aoim barekfuon. Regavo roin ja nivek karinva ijia ja Emabuon Farif fu una Kin rene e fok samuagdiakro roga ja giakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Areme tavan siks (6) ijeg baremga Jesu fun uri Fita ga no uviaiki e Jeims ko Jon aferdiame bun buonkua uruor ka jaoijmanako be ijia ajie vain. ");
INSERT INTO nvm_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Bu ijia ajieme ire gakoga Jesuon vajat fok fu ijia una nibe ren. Uikinik fuon iji fuka veni igeg sanakoga ugon fuon iji buka abarme ire bivar iji bu abe veni ijia karavo ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Fu ijegrekoga ijia e Jesuon vuak faivo nokbek (3) bu gak e Mosis ko Eraija bun migegare iji bu irenva ijia Jesuna ireme vuak kuaiva bu giain. ");
INSERT INTO nvm_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ijefuon Fita fu uri Jesu kua, E Bomana aka magoi no aferduo igia ruain. Ijefuon a vierafega fu markma ni kiega na ar muvua nokbek (3) be on ga be Mosison ga be Eraijaon ijeg igia savno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Fita fu vek ijeg mani kuaimon ijia vana ka abaikin ijar e fok bu irenva ijia fuka okuriain. Vana fu ijeg okuriakoga kua be fu vana guf ijia kume, E iji fu Farinun ma na fu bomana oijmavo. Na ik fu reoino iji gaga naka bomana oimadiemno vuak fuon iji mukoi igia faifno kumen. ");
INSERT INTO nvm_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","E Jesuon vuak faivo nokbek (3) bu vuak iji faiva buka dejufdiamga bu tuame moik ijia dijeme uikinik buon iji kam sauin. ");
INSERT INTO nvm_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Bu ijegrejga Jesu fu kekome imut karamdiaknum kia, Ja juvo aregavo urifno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Fu ijeg kiamga bu asarajie ga e bino iji bu bakigavo fu Jesur fuonkua ijia manina bu gain. ");
INSERT INTO nvm_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Areme bun una uruor ijia ari vako ijia Jesu fu uri kia, Ja ire gufi fu rena ja gainva iji jab va e roin kuardiak. Janim areke Emabuon Farif igi na guame una uriga ni ijar e kuardiafno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Fu ijeg kuardiamga e vuak fuon faivo bu una kua, E vuak akai nijaidiavo iji bu kua, Fu e Eraijar ur una ruakno kuainva iji bu irerafuon ijeg kuainvano kuain? ");
INSERT INTO nvm_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Bu ijeg kuardavga Jesu fu una kia, Ke iji ja ma kuaiv. Fu e Eraijar amur ro ire fok amarigia kanafum una arir nakfuon. ");
INSERT INTO nvm_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Gavo igia faif. E Eraija aikin be fun amur ruain gavo e buba fu amarigia game vierafen. Regavo buka uri ire ise fok kafokafo bu vierafenva iji fuon ren. Ijegvo Emabuon Farif igi nak madu buka dab ijeg ire ise kafokafo nun rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ijegreare e vuak fuon faivo iji bu tavan ijiason vierafero fu Jon e do ruardiamo ijefuon kuaimro bu ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Bun ijeg kuaiknum una ari roke e gumi bu afuinva ijia usevga e be fu migegare kekome Jesu manino nifak ijia ato sain. ");
INSERT INTO nvm_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Fu ato same kua, E Bomana a farinun ijefuon oifiadakma nin ifejda. Fu kaven ise ijar niroime dab arafirikok fuka ir simaiknum isejavaim. Fu ijegrejknum vo tavan kafo fu kaven ise ijar dab mian ijia akozga fu mian naiknum vo tavan kafo fuka do uramon. ");
INSERT INTO nvm_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ijefuon na afeme e vuak on faivo iji nijaidiaga bu ifejdakrega buka ba aresrenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Fu ijeg kuardamga Jesu fu uri kia, E guri ka nonamimoknum God ba ma vierafejo gurie igia faif. Ja vierafega na juaivasia izeg jana fioke ja ijia una God ma vierafek? Am iji afeme igia roga na gavno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesu fu ijeg kuardiamga e iji fun am iji afeme rokga Jesu fu uri kaven ise iji kuriaireme rotkurain. Fu ijeg rotkuramga kaven ise iji fun am iji areme keko vakoga migegare am iji fu ijia una main. ");
INSERT INTO nvm_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Rega e Jesuon vuak faivo iji bun isuarigia una ro Jesu kua, Kaven ise iji nor amur rotkurain gavo fu irerafuon ba keko vainmano kuain? ");
INSERT INTO nvm_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Bu ijeg kuardavga Jesu fu una kia, Ijefuon maiji God jaka bomana vierafejo bakin. Naka ma kuardiavo igia faif. Jon ja God ma vierafejo iji fuka ukakbe in sira sunin ijekin iji ja aresredo ja uri nafar iji kua, Ni jafe biom garia manine kuakva fu jafe biom vak. Regavo fu irerag ijar ja girekma bano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Regavo kaven ise ijekin iji bu e iji buba areme usem vakfuon. Regavo jaka ijefuon sirimame duok karokva bu ijar usem vakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Areme e vuak fuon faivo iji bun una Gareri ijia besum afuin. Bu besum afuivga Jesu fu uri kia, Iviakma igem e bu Emabuon Farif igi na tofdieme dab una e ise iji miak. Bu na abe e iji miaga bur na dab kaniega na guak revo tavan nokbek (3) barke God fu kiega na una madu urikno kiain. Fu ijeg kuardiamgame e vuak fuon faivo iji buka oi bijukuriain. ");
INSERT INTO nvm_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Areme Jesu fun e vuak fuon faivo ijiena roke ar Kafoniam ijia usen. Bu usevga e iji Godon ar bomana ijefuon mon iji e bu abese bu abeoijo iji roin bu ijia usen. Bu useme Fita kua, A vierafega eon iji e nijaidiamo iji fube mon iji bu Godon ar bomana ijefuon abesvo fube ifejdia abesemno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Bu ijeg Fita kuavga fu kia, Ke iji mon fu abesemno kiain. Fita fu e iji ijeg kuardiame fun ar ijia aru vain. Fu ik aru vakoga Jesu fu gafa uri kua, Fita e vuak gafi bu kuainva iji aiji a izeg vierafenmano kuain. A vierafega e mamkanuk moikigi samuavo mon iji bu kiaga e bu oknum kareoijo iji bu erafon mon iji karemoij? A vierafega bu ebuon ijiebuon mon vo bu e ai kafoko ijiebuon mon iji karevno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Jesu fu ijeg kuamga Fita fu kua, Mon iji buka e moik kafoko ijiebuon mon iji karevno kuain. Fu ijeg kuardamga Jesu fu una kua, Ke iji aka ma kuaim. Ijefuon na vierafe afijaf iji buba una karoime buifuon mon takes abesekfuon. Ijegvo nak na ma Godon Farif ijefuon na irerafuon una ar fuon ijefuon mon abesekfuon? ");
INSERT INTO nvm_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Regavo noba mon abesekva na vierafe e takes abeoijo iji bu kafu buka no ziegafuokfuon. Ijefuon ni va saof ijia kimai same kijum kafo kara. A kijum be amur kekma a ir fuon ijia mon be gakfuon. Regavo a mon ijin gakma ni abe va takes abese. Regavo mon iji na vierafe fun takes on ga nun iji fun sibank aresrekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jesu fu ijeg kuardiamevo tavan ukakbe barekoga e vuak fuon faivo iji bu una uri kua, A vierafega e iji God fu oibuon samuagdiamo ijia e iji erar fuka e bomanano kuain? ");
INSERT INTO nvm_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","3","Bu ijeg kuardavga Jesu fu uri kiamga bu am ukakbe iji afeme rokga fu e fok ijiebuon nifak ijia manin. Fu ijia manikoga Jesu fu uri kia, E besubesum ja irerafuon e ikin rekuai vierafen? Naka ma kuardiavo faif. Ja unam ise jon fok ja kegoijo iji jaba areme una am ukakbe igi fu kabuaikabuaiki kegoino ijeg kegokva ja God e iji fu oijbuon iji samuagdiamo ijiena mazikva bakin. ");
INSERT INTO nvm_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ijefuon e iji God fu oibuon iji samuagdiamo ijiebuon araf ijia e ikin rekfuon iji e iji fu una am ukakbe igi fu manino ijeg kabuaikabuaiki reoino e ijar fuka e fok asidiame e ikin rek. ");
INSERT INTO nvm_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ijefuon erar fu enun kafo am igekin iji if nun ijia oimardiavo iji fu madu nak oimardiamno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Regavo erar fu e iji bu oij asusame am ukakna igeg na ma vierafejo iji kam arafiriaga bu una ise reokva e iji nika mun bomana be dab uro fuon ijia kira saof uf ijia akozga fu urame do ikfuon. ");
INSERT INTO nvm_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Regavo e moikigia oijo iji esenia. Ijefuon maiji e ise reoijo iji buka una e roin biesiakok buka unam ma iji areme una unam ise iji reoij. Regavo igia faif. E iji bu ijeg ise reoijo iji tavan rad God fuka bu kam unam ise ijia arafiriakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Areme Jesu fu uri vuak kafo ijeg bijiame kuardiain. Fu kia, E be erar a vierafega fu imut on vo diatat on ijieb a aferda dab ise rega na vierafe aka kafo kaniaufu korekfuon. A vierafe aka Godon unam ma iji abekafa vierafekma ni vajat on roin bu ise reoijo iji kege ijeg kaniaufu. A ijegrekma iji fuka markfuon. Regavo aba ijegrekma vajat on fok iji fuka ar ise mian naino ijia vak. ");
INSERT INTO nvm_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Regavo madu a vierafega ni on ijar a aferdame ise rega ni niom on be jafe akoze. A ijegrekma iji fuka markfuon. Regavo aba ijegrekma ni niom ijar a dab ar ise mian naino ijia akozga a ijia vajai fian abekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jesu fu ijeg kuardiavake kia, E iji bu am ukaknak igeg na ma vierafejo iji jab oknum ni iken giavo. Ijefuon maiji na kuardiakrejo faif e ijekin ijiebuon anera iji bu samuagdiavo iji buk buka Godon nifak ijia oijo. Ijefuon unam izeg ja bu kam kafokafo reoijo iji mukor vierafeknum reokfuon. ");
INSERT INTO nvm_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ijefuon maiji Emabuon Farif igi na ruainva iji na e iji bu Godon unam ma iji areme aibe ijia oijo ijin karauniakro ruain. ");
INSERT INTO nvm_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","13","Regavo na vuak be bijame kuardiakrejo ni faif e be fu maf-sif fuon uruvana vuan adred (100) ijeg samuagdiamo. Regavo tavan be maf-sif iji irenva ijia besum fu oine sauikma e iji ja vierafe fu izeg rekfuon? Fube kuaik iji fun marenmano are fu ijia oine guamne kuaik? Fu ijegrekma bakin revo fuka maf-sif roin nainti nain (99) iji fu ijia uniagavo fu va besum iji subinma iji nisaimoine gakma fuka bomana oimarkfuon. Regavo una roin iji buba sauinva iji fum sibank oimarkfuon. ");
INSERT INTO nvm_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ijegvo Asoijon iji varur gufia fino iji fu e iji bu e ukakna igeg na ma vierafejo iji buiji fuka ijeg vierafen. Fu e ijekin besum fu va subikfuon iji fuka ba oimarkno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesu fu e fok vuak ijeg kuardiame vake kia, A uviaion be fu osik Jesu ma vierafeno ijar ise be afak rekma ni isuar oimarknum va fusik besum karine ise irerag fu afak renma iji kuaime amaref. A va ijeg fine kuaiga uviaion iji fun una oimarknum vuak a kuaimon iji faikma iji jan una besum agan igeg oimarknum ok. ");
INSERT INTO nvm_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Regavo a kuardaga fuba una osik oimarknum vuak on iji faikma ni va e besum (1) vo baga nokarok (2) ijeg aferdia una va ga. A ijeg e nokarok (2) aferdia vaikin bu vuak izeg a fusik kuaimon iji bur ifejdiame kuaik. ");
INSERT INTO nvm_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Regavo fu madu e ijiebuon vuak iji fuba oimarknum faikma ni va e iji God ma vierafejo iji giakfuon. Regavo gaga fu ijekma ba oimarkma nika kuriaireme kuaga fu va e iji God ba ma vierafejo ijiena fioine kiain. ");
INSERT INTO nvm_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Jesu fu ijeg kuardiavako ijia fu madu kia, Vuak igi naka ma kuardiav, Irerag e bu moikigia reoga a vierafero fu ise ro a bijukuriamo iji God varur ijia fino iji fuk fu ijeg kuriaireme bijukuriak. Regavo irerag bu reoga a giame vierafero fu maro a oimardiako bu reoijo iji God varur gufia fino iji fuk fu besum ijeg oimardiak. ");
INSERT INTO nvm_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Regavo madu igia faif. Ja e nokarok (2) ja moikigia oine ire kafofuon oi besum vierafene sirimamene kuakva Asoinun varur gufia fino iji fu ifejdiak. ");
INSERT INTO nvm_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ijefuon maiji e nokarok (2) vo nokbek (3) bu besum karine vuak kuaime nun sirimamekva na ijia buna fiknum buon bu sirimamejo iji faikno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Areme Fita fu uri Jesu kua, E Bomana uviainun be fu nosik Jesu ma vierafeno fu ire ise be nun rekma na game arek. Regavo fu vek magiaga tavan bog nun ise rekma nabe tavan seven (7) ijeg game arekno kuain? ");
INSERT INTO nvm_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Fita fu ijeg kuardamga Jesu fu una kua, Uviaion iji fu afak ise rega a tavan seven (7) ijesugin game arekma iji na vierafega fuka ba maren. Regavo madu a tavan seventi (70) ijeg game arekma iji madu fuka ba markfuon. Regavo fu tavan bog fuka magaga una afak ijeg ise reunaikma nin game oion ijia aregavo ab una iji bomana vierafemne kuain. ");
INSERT INTO nvm_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jesu fu ijeg kuardiame uri vuak be ijeg bijame kuardiain. Fu kia, God izeg fu efuon ijiebuon oij iji fu samuagdiamo iji fu ijekin. E kin be fu tavan be vierafe fuka efuon ikrejo iji kiaga bu funa besum afuim karine sinuom roin bu kenva ijin kuaime amarekro fu iji vierafen. ");
INSERT INTO nvm_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ijefuon fun uri ijegrekoga bu e be iji fu sinuom ka mon ma bomana ijeg kenma ijin afeme fuon ruain. ");
INSERT INTO nvm_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Fu kekome uri sinuom iji fu kenma ijefuon mon iji una e kin ijin kimekrega fuka ba aresrega fu ijia aren. Ijefuon e kin iji fu uri efuon ikrejo roin kia, E guriga agbarak ga sinuom fuon fok ka kege una e kafobuon kimekfuon. Ja kege kimega bu mon ijefuon vajiaga ni kege ro sinuom igi fu karenma iji kimejno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Fu ijeg kuaimga e iji fu vuak iji faima fuka bomana oifiaimga fu uri e kin ijefuon nifak ijia ato same soisoin. Fu soisoime kua, E-e ni isuar oi dasume fike na oga mon kafo biediekva na una ro vajakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Fu ijeg kuardamga e kin iji fu vierafena fuka bomana oifiaima fu kuamga fuba kimen revo fum ijia areme keko vain. ");
INSERT INTO nvm_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Rega fun va oine una kaifuon be fu ur mon fuon ukakbe kuama fu vajainma iji bien. Fu bieme keko uro ijia kunaime kua, Eko iviakma migegare mon nun a inma iji una vef vajiemne kuain. ");
INSERT INTO nvm_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Fu ijeg kuardamga kaifuon iji fu una kua, Kainu e-e ni isuar oi dasume fike na oga mon kafo biediekma na una ro vajavno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Regavo e iji fuba una kaifuon ijefuon oifian aben revo fuka magaga kunaim dab dibur unain. Fu dab dibur uname kua, Ni ijia fiknum mon nun a inma ijin una kime barme nin keko vakne kuain. ");
INSERT INTO nvm_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","E iji fu ijegrega e kaifijaf roin bu gava buka oifiadiain. Ijefuon bun una va e iji izeg fu renma ijin e kin iji kuardain. ");
INSERT INTO nvm_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Bu ijeg kuardavga e kin iji fu kiamga bu e iji afeme rokga fu uri kua, E gurie aka e ma bakin aka e ise. A mon nun bomana ar in ga na ijefuon kuavga aka soisoimga na kuava a ijia areme vain. ");
INSERT INTO nvm_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Naiji a oifiadienma ijefuon na kuavga aba una na kimen revo a ijia areme vain. Regavo a irerafuon una uviaion iji izeg na renva ijeg aba fuon oifian abenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Rega e kin iji fuka uruvana deajin ijefuon fu kiamga bu e iji kunaim dab dibur unavga fu ijia fine vajai fian aben. Fu ijia fiknum mon fuon iji fu inma iji una kime baremne kiain. ");
INSERT INTO nvm_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesu fu vuak ijeg bija kuardiame barekro kia, Ja e fok ja e ise iji fu kenma ijeg jaba kaifjon ijiebuon ise iji isuar giame oijon ijia arekva fuka ba marek. Ja ijegrekva God Asoinun varur gufia fino iji fuk fu ise jon iji fuba giame arekgavo fuka kam unam ma ise ijia arafiriakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesu fu vuak fok kuardiame barme fun uri Gareri areme una ar Judia guf do Jodan ruvainma irif gara ijia vain ");
INSERT INTO nvm_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Fu ijia vakoga e uruvana bu jame ijia vaka fu bu karauniain. ");
INSERT INTO nvm_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Fu ijegreoino ijia e Ferisis roin bu ro usem Jesu bisuame kua, A vierafega akai nuvuon fu kuainma ijeg e be fu bara fuon fu ire kafokafo ba fu oimaikfuon ijia kegokma fube datura unaga fu vakno kuain? ");
INSERT INTO nvm_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Bu ijeg kuavga Jesu fu una roin kia, Regavo ja buk kafar be bu isoime kua, Ik anej ijia God iji ire fok amardiainma ijar baru ga barak amardiainmano kuainma iji jabe dame gain? ");
INSERT INTO nvm_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Regavo madu buk kafar be ijia bu ijeg isoime kua, Efarif iji fu uri asoifuon ijiga asiefuon iji areme una bara fuon abek. Bu ijeg sanamime besum karioijo ijia bu una busik vajai besum rekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ijefuon bu busik bu nokarok (2) bakin gavo buka vajai besum. Ijefuon bara iji Godri abe efarif ijek besum kamainma iji e kafo buba ke atase kafokafo uniakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jesu fu ijeg kuaimga e Ferisis iji bu uri kua, Regavo irerafuon Mosis fu kua, E be fu bara fuon datura una fu vakma fu fefa be isoime kua ivia aiji a bara nun bano kuame abe maga fu vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Bu ijeg kuardavga Jesu fu uri kia, Vuak iji Mosis fu isoime kuai ja barafjon tura uniakno kuainma ijefuon maiji oijon fuka ma gigikin. Regavo iji ja kuaivo iji ik anej ijia buba ijegrene ruain. ");
INSERT INTO nvm_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Regavo na kuardiakrejo faif. E be fu bara fuon abe uname una bara be abekma e iji fu bara ijin daturam. Regavo bara fuon iji fu amur ba e be daturainma gakma baru iji fu bara iji unako fu vakma iji fuka ba markno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jesu fu ijeg kuardiamga e vuak fuon faivo iji bu uri kua, Regavo gaga unam iji bara kege uniaga bu vako iji fuka gigikin gakma iji no vierafe barubara sanamivo iji ka ijia arefno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Bu ijeg kuardavga Jesu fu uri kia, Ke iji fun maren gavo na vierafe e fok bu vuak iji ja kuainva bu ijeg vierafeokva bakin. Regavo bun e iji eraneb Godri kiaga bu ijeg amunamun oijo ijieb ijeg reok. ");
INSERT INTO nvm_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Regavo irerafuon efarif iji buba bara kego ijefuon anej maiji bu kafokafo. E roin bun ijeg nafediain revo roin iji bun emab ke ijeg amardiain. Regavo e roin buba bara kego iji bu Godon ikreokuai bu ijefuon akaim oij. Regavo e be erar fu vierafega fu aresredo fu ijeg kegokma iji ni are fu ijeg kegoino kiain. ");
INSERT INTO nvm_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Areme e roin bu vierafe bu afijaf iji aferdiame Jesuon roga fu bu imut nigen namdiaknum buifuon sirimamekuai ruain. Regavo e vuak fuon faivo iji buka ba oimarenva ijefuon bu uri e iji afijaf aferdia roko iji kuriairen. ");
INSERT INTO nvm_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Bu kuriairevga Jesu fu uri kia, Ja am ukakna iji jab kuriairek revo are bu aferdia nun ruaf. Ijefuon maiji e iji eraneb bu am ukakna iji bu asoibuon iji ma vierafejo ijeg bu na ma vierafekva God fu e ijekin iji samuagdiakro vierafenmano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Fu ijeg kuardiame uri am ukakna ijin imut nigen namdiaknum buon sirimamene fun ar iji areme vain. ");
INSERT INTO nvm_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Areme e be fu ro kekome Jesu kua, E nijaidiamon na irerag iji rekva na ma karivako iji abekno kuain? ");
INSERT INTO nvm_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Fu ijeg kuardamga Jesu fu uri una roin kua, A irerafuon ire maiji rekro bomana vierafene kiem? Fu e be erar fuka e ma bakin gavo fun e besum Godri fuonkua fu e ma. Ijefuon a unam iviamkor ma karivako iji abekro vierafekma ni Godon akaij iji igiamne kuain. ");
INSERT INTO nvm_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","19","Jesu fu ijeg kuardamga e iji fu una kua, Regavo akaij iji na izin igiakno kuain? Fu ijeg kuamga Jesu fu uri roin kua, Ab e kafo kaniaknum e kafobuon bara turaknum vo e kafobuon ire niesaknum vo e kafobuon vuak kufuimene kuaimon. Regavo madu nika asoion ijiga asieon iji igiaknum izeg a koikon on oijmanamimo ijeg una e roin oijmiamne kuain. ");
INSERT INTO nvm_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Fu ijeg kuardamga e iji fu una kua, Akai fok iji naka igiav. Regavo na una ire be iji na irerag iji rekno kuain? ");
INSERT INTO nvm_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Fu ijeg Jesu kuardamga Jesu fu una kua, A vierafega aka maturaiga ni va sinuom on fok ke kime mon abe e sinuom bakin iji vajiame ni uri na jajie. A ijegrekma a unam iji tavan bog ma karivako ijin abekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ijefuon e nivek iji fu vuak iji faima fuka bomana oifiaimga fu oifiaigma vain. Ijefuon maiji fu vierafega fuka sinuom ma uruvana zarain. ");
INSERT INTO nvm_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Areme Jesu fu uri e vuak fuon faivo iji kia, Vuak igi na ma kuardiav. E be erar fu sinuom uruvana iji fu agan iji God fu samuagdiamo ijia buna besum mazikfuon iji fuka ma gigikin. ");
INSERT INTO nvm_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Regavo igia faif. Fanuf kamer iji fu ma bomana ga siem tit iji fuka ukakbe ijefuon fu tit ijia aru vakma fuka ma gigikin. Unam besum ijegvo e iji sinuom zarainma iji fu izeg e iji God fu samuagdiamo ijia buna besum mazikfuon iji fuka ma gigikino kiain. ");
INSERT INTO nvm_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ijefuon e vuak fuon faivo bu vuak iji faiva buka oiserdiamga bu uri uruvana vierafeknum bui kuai, Fu erar aresredo fu e iji God fu oibuon iji samuagdiamo ijiena besum mazik? ");
INSERT INTO nvm_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Bu ijeg kuaivga Jesu fu kia, E kafo erar fum fuon vierafega unam fuon fu kegoino ijia fu aresrenma bakin. Regavo fun Godri aresredo fu ire fok rekfuon. Regavo fu fuonkua era fu vierafenma iji kuaga fu e iji God fu oibuon iji samuagdiamo ijia buna besum mazikno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Fu ijeg kuardiamga Fita fu una kua, No ire fok non ijia areme uri a jame ruain. Ijefuon no ire ma iji no irerag iji abekno kuain? ");
INSERT INTO nvm_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Bu ijeg kuardavga Jesu fu una kia, Vuak igi na ma kuardiav. Tavan iji ire fok bu una iviamkor rejo ijia Emabuon Farif igi na fata nun ma iji sanainma ijia ajie fijo ijia e iji eraneb ja na jajievo iji jak ja fata ma iji tuer (12) kege karik. Ja fata iji kege ijia karine e agan tuer (12) Isrerkobuon ise iji kege mazim giak. ");
INSERT INTO nvm_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Regavo erar fu ar fuon ga uviaifijaf ga makifijaf ga eofijaf ga afijaf ga juar fuon iji nuifuon aremo e iji fu una madu ire ma uruvana kafo kekfuon. Regavo madu fu unam ma karivako iji abe ijia fivak. ");
INSERT INTO nvm_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Regavo igia faif. E uruvana bu amur irenva iji bu una rad ireken. Regavo eraneb iviakma rad irevo bu una amur ireken. Ijefuon maiji e sinuom zarainva iji iviakma bu e mamkanuk gavo rad bu una e ukakna rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ijefuon e iji God fu oibuon iji samuagdiamo iji fu e juar koikin iji fu suok nakitu gamia kekome va e kiaga bu fuifuon ikredake fu mon vajiakma igekin. ");
INSERT INTO nvm_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ijefuon e iji fu vierafe fu e kafo kega bu fuifuon ikrekfuon iji fu vierafega fun maren. Ijefuon fu va e iji kia, Ja tavan besum nuifuon ikrekva na mon sunin ijia e besubesum ka afurvene vajiakno kiain. Fu ijeg kiamga bun oimarvga fun kiama bun juar fuon ijia ikrekuai vain. ");
INSERT INTO nvm_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Bun vakoga fun tavan ajie ruainma ijia una madu ar bu ire kimejo ijia vaga e roin bu ijia iremoija fu giain. ");
INSERT INTO nvm_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ijefuon fu kia, Jak na vierafe ja va juar nun ijia ikreke na mon besum afurvene vajiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Fu ijeg kuardiamga bun vako fu una tavan uk manino ijia roke una tavan ura gura manino ijia fu una ire besum fu renma ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Fu una va fivake tavan fun kokreno ijia una vaga e roin bu ijia iremoija fu giain. Fu giame uri kia, Ja irerafuon tavan igi ja abe ire kafo ba rega jam igia iremoijno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Fu ijeg kiamga bu una roin kua, Ijefuon maiji e kafo buba no buifuon ikrekfuon kuinvano kuain. Bu ijeg kuardavga fu uri kia, Jak nin va kof juar nun ijia ikrefno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Areme tavan fun nakisrega e iji juar koikin iji fun uri e iji nigen rene e ikrejo iji samuagdiamo iji kua, E iji ikrejo iji kume bu roga mon buon vajiamne. Regavo mon a vajiakma ni e iji eraneb bu rad ikrek ruainva ijia anerene vajiajame una gafeg baremne kuain. ");
INSERT INTO nvm_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Regavo e iji rad tavan kokreno ijia ikrekuai vainva iji bu mon sunin besum (1) ijeg e besubesum fu aben. ");
INSERT INTO nvm_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Regavo e iji bu amur ikrekuai ruainva iji buka bur mon sibank bomana abekuai vierafen. Regavo e besubesum buka mon sunin besum ijeg aben. ");
INSERT INTO nvm_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bu mon buon abe una e iji kof juar fuon menma ijiena zienamin. ");
INSERT INTO nvm_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Bu uri kua, E guri a rad kiainma iji bum tavan ukakbe ik ren. Regavo noiji noka suok anerene ruako tavan kanuin. Regavo a irerafuon mon noiji a buna besum afurvene vajuinmano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Bu ijeg kuardavga e iji juar koikin iji fu uri e iji vuak kuaimon iji kua, Kainu na ja biesiainva bakin. Regavo na vuak irerag na ja kuardiainva nan ijegrene mon jon iji nan afurve vajiav. ");
INSERT INTO nvm_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ijefuon ni mon on abe vake na e roin bu rad ikrenva iji mon izeg a abenma na ijeg una bu vajiav. ");
INSERT INTO nvm_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ijefuon maiji na daro namo ijefuon mon nun iji na kege na vierafejo ijia rek. Regavo a ziemo iji akafu igi na e suaiki rene mon afurve vajiainva ijefuon ziem. ");
INSERT INTO nvm_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jesu fu vuak ijeg kuardia barekafa kia, Unam besum ijeg e iji bu rad gamia roko iji vef bur amur ruak. Regavo e iji bu amur roko iji vef bur una rad gamia ruakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesu fu e vuak fuon faivo tuer (12) ijiena bun Jerusarem vakuai vako ijia fu unam ijia izeg e bu Jerusarem ijia fu dab izegrekfuon ijin isuar kuardiain. ");
INSERT INTO nvm_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Fu kia, Igia faif no vake Jerusarem usevo ijia Emabuon Farif igi naiji bu abe e isuf baroijo ijiebuon e mamkanuk ijigam e vuak akai nijaidiavo iji miaga bur na tofdieme ise nun kuaime dab arafirikfuon. ");
INSERT INTO nvm_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","E ijieb na bu abe una e Jius bakin iji miaga bur na abe anu baroiknum juvit foimadieknum fijieme abe kuros kaniek. Regavo naki nokbek (3) barekma God fu kiega na una uri nivek fivakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Areme rad e Zebedin barak ijar afijaf ijiena Jesu fino ijia vain. Bara iji fu ire be vierafenma ijefuon fu va Jesu manino nifak ijia ato same uri ire befuon kuain. ");
INSERT INTO nvm_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Fu ijeg kuamga Jesu fu uri kua, Regavo a irerag vierafenmano kuain? Jesu fu ijeg kuardamga bara iji fu una roin kua, E-e ni iviakma igia kuardiekin tavan iji a una E Bomana rene Godon e iji samuagdiakro roko ijia am afnun nokarok (2) igi be fu imut on maink ijia fikevo be fu imut on aizinak ijia fikno kiemne. ");
INSERT INTO nvm_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesu fu una afijaf nokarok (2) iji kia, Vuak iji ja na kuardievo iji jaba vierafe gavo jam ijia kuardiev. Ja vierafero ire igi na vajai fian abekrejo iji jan aresredo fu jon rekro ja iji vierafenvano kiain? Fu ijeg kuardiamga bu una roin kua, No vierafe no aresredo no rekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Bu iji kuardavga Jesu fu uri kia, Ire iji e bu nun rega na vajai fian abekrejo iji jak madu fu jon rega ja ijeg vajai fian abek. Regavo e iji bu ar ij nun maink ga azinainak ijia karikfuon iji na nar kekva bakin. Regavo ar iji fu e iji Asoinun fu karmo ijiebuon arno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ijegrene tavan ijia e ten (10) Jesuon vuak faivo iji bu vuak iji faiva buka deajidiamga bu uri no uviaikin iji ziegafiain. ");
INSERT INTO nvm_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ijefuon Jesu fu uri e vuak fuon faivo iji kiama bu besum afuivga fu kia, Jan vierafe e Jius bakin ijiebuon e mamkanuk iji bu ebuon kege una daro buon rotit ijia uniav. Regavo madu e aiko ijiebuon e mamkanuk iji bu daro buon ijia e aiko buon iji samuagdiav. ");
INSERT INTO nvm_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","28","Regavo igia faif. Unam ijeg jab arega fu jon rek. Erar fu vierafe fu joifuon e bomana rekma e iji fuka ja ifejdiaknum vo joifuon ikreokfuon. Regavo erar fu joifuon e nigen rekro vierafekma e iji fuka e be joifuon ikreno igeg reok. Unam besum ijegvo Emabuon Farif igi na ruainva iji na e bomana rekro ruainva bakin. Regavo nam e be fu e befuon ikreno na ijegrekro ruain. Regavo madu na ruainva iji na kuros ijia guame kavuan nun ijia useme e fok karauniakafie na iji ruain. ");
INSERT INTO nvm_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Areme Jesu fun e vuak fuon faivo ijiena ar Jeriko areme usem vakoga e ka uruvana bu usem jajiame buna vain. ");
INSERT INTO nvm_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Regavo e ni zuriaigin nokarok (2) bu unam irif ijia karido bu faik Jesu fu ijia asidiame ruvaka bu fain. Bu faime uri kume, E Bomana e Devidon uifarif gare abe nuvuifuon oifian abene ifejduokno kumen? ");
INSERT INTO nvm_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Bu ijeg kumejga e ijia roko ijieb uri kuriaireme kia, Isuar karifno kiain. Rega buka uri ma uruvana igia biumame kume, E Bomana e Devidon uifarif gare abe nuvuifuon oifian abene ifejduokno kumen. ");
INSERT INTO nvm_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Bu ijeg kumejga Jesu fu roke ijia kekome uri kia, Na irerag joifuon rekro ja iji vierafenvano kiain? ");
INSERT INTO nvm_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Fu ijeg kiamga bu una roin kua, E Bomana no vierafe a ni nuvuon iji amarduoga no una ni naravno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Bu ijeg kuardavga Jesu fu buifuon oifian abene uri ni buon ijia niriakiamga tavan ijia bu una ni narame bun uri fu jame vain. ");
INSERT INTO nvm_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Areme Jesu fun e vuak fuon faivo ijiena Jerusarem vakuai roke ar Betifas uruor Orivs kuavo samaij ijia usen. Areme Jesu fun uri e vuak fuon faivo iji nokarok (2) vuak igin kuardiain. Fu kia, Va ar gafia usem gaga bu maf-donki be kirainva fu uka fuon ijekma ijia maniga iji irame afem una igi na fijo igia ruaf. ");
INSERT INTO nvm_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ja va iraga e be fu kia, Ja irerafuon maf-donki iji iravno kiaga ni kua, No E Bomana ijar vierafega no ijin iravno kuaf. Ja ijeg kuarda fu areke ja afem ruak. ");
INSERT INTO nvm_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Regavo ire iji renma iji fun izeg e iji Godon vuak vierafene kuaimon fu usuibe kuainma ijekma aresren. ");
INSERT INTO nvm_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Regavo vuak iji bu ijeg isoi, E Jerusaremko iji E Bomana jon fu jon rok. Fu maf-donki azan ijia ajie fine ruakfuon. Regavo fu e bijaimoijo ijiebuon e bomana bakin ijefuon fuba maf-os ijia ajie fik revo fum maf-donki uka ijia ajie fine ruak. ");
INSERT INTO nvm_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ijefuon e vuak fuon faivo nokarok (2) iji bun va vuak irerag Jesu fu kuardiainma ijia jame ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Areme bun va maf-donki ijiga uka fuon iji aferdiame una roke Jesu fino gumia usen. Areme bun uri ugon buon bu azan savo iji azome maf-donki azan ijia riedavga Jesu fu ijia ajie fin. ");
INSERT INTO nvm_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bu ijegrekoga e fok bu funa ruainva iji buk bun uri ugon buon roin bu azan sainva ijin azome unam ijia riesdakoga e roin bu uri anam kiak iji mukiene unam ijia riesdain. ");
INSERT INTO nvm_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ijegrene e fok bun roinroin ireme ruako Jesu fu uf ijia ruain. Fu ijia ruakoga e fok bu biumaknum kume, No e Devidon Farif igi dab aroiv. No vierafe Godri E Bomana ijefuon if ijia fu daro mak. Regavo noka Godon bomana oimarvno kumen. ");
INSERT INTO nvm_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Bu ijegrejknum Jesu afeme vake Jerusarem usen. Regavo e fok mai ijia karinva iji buka oiserdiamga bu uri kuai, E iji kafu erarno kuain? ");
INSERT INTO nvm_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Bu ijeg kuaivga e fok Jesuna vako ijieb uri kume, E igi fu Jesu e iji Godon vuak vierafene kuaimon ijin. Regavo fu ar Nasaret Gareri guf ijekorno kumen. ");
INSERT INTO nvm_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Bu ijegrene Jesu fun Godon ar bu sirimamejo makaf ijia e iji bu ijia arume ire kafokafo kare kimejo iji kuriairema bu usen. Bu useme subiko fu uri e iji bu karine mon dame vajuinamivo ijigam e iji um kimejo ijiebuon fata ijigam sinuom buon iji kam karoidiain. ");
INSERT INTO nvm_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Fu ijegrene uri kia, Buk akaij iji bu usuibe isoinva ijia God fu kuai, Ar nun iji bu ijia arume sirimamejo gavo jar arume abe e niesavobuon ar igeg amarvno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jesu fu ijeg kuardiame rad e ni zuriaigin ijigam e aikirariainva iji bu Godon ar ijia rokga fu karauniain. ");
INSERT INTO nvm_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Regavo e mamkanuk Godon isuf baroijo ijiebuon e mamkanuk ijigam e vuak akai nijaidiavo iji bu unam ka mukor iji Jesu fu reno bu iji giava buka deajidiain. Regavo madu bu giak am ukakna iji buka Godon ar ijia arume biumame kume, E Devidon Farif gari aroifno kumen. ");
INSERT INTO nvm_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ijefuon bu uri Jesu kua, Am ukakna iji bu vuak irerag kuaivo iji abe fainmano kuain? Bu ijeg kuavga Jesu fu una roin kia, Vuak irerag bu kuaivo iji nan fainvano kiain. Fu ijeg kuardiame fu madu uri kia, Ja buk akaij ijia vuak igi bu isoinva iji jabe dame vierafen? Regavo vuak iji bu ijeg isoi, Godri am ukakna iji mukorigia vierafe vajiaga bu fu aroikno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesu fu ijeg kuardiame fun ijia areme una Beteni naikafa vain. ");
INSERT INTO nvm_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Bu va ijia naoinva nakitu Jesu fun una e vuak fuon faivo ijiena una Jerusarem ruakuai roko ijia fuka vasiaguain. ");
INSERT INTO nvm_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Fu vasiaguamga fu in durim igekin be bu kua figno kuavo iji be unam irif ijia manina fu gain. Fu game ura vaga in iji fu sunin ba kirain revo fum ma ijesugin. Ijefuon fu uri in iji kuai, Aiji aba una sunin kirakno kuamga in iji tavan ijia fuka sairen. ");
INSERT INTO nvm_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","21","Fu ijeg e vuak fuon faivo iji bu in iji sairenma iji gava buka oiserdiain. Ijefuon bu uri kua, In iji kafu izeg migegare sairenmano kuain. Bu ijeg kuardavga Jesu fu uri kia, Vuak igi naka ma kuardiav. Ja ire ijekin iji jaba giame zazaik gavo jam uri ma vierafekva ja in guri na kuavga fu sairenma ijeg ja ire ijekin kafo rek. Ja ire ijekin ijesugin rekva bakigavo ja madu uruor bomana be kuak koikon tuame saof ijia arimne kuakva fu ir jon abek. ");
INSERT INTO nvm_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Regavo madu ja ma vierafekva irerag ja sirimamene Asoijon kuavo iji fu vajiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Areme Jesu fun e vuak fuon faivo ijiena una Godon ar bu sirimamejo makaf ijia vain. Fu ijia vuak nijaidiamo ijia e Godon isuf baroijo ijiebuon e mamkanuk ijigam e Jiusbuon e mamkanuk ijieb useme Jesu kua, Ire iji a reno iji daro iji a izia abe ren? Regavo a daro iji erar mainmano kuain? ");
INSERT INTO nvm_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Bu ijeg kuardavga Jesu fu una roin kia, Na duna besum ja kiaga ja una roib kuardiekva na ijar daro igi na erafon abe ire igin reoijo na iji kuardiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Fu ijeg kuardiame uri kia, Ja vierafega Jon e do ruardiamo daro iji fu abe e do ruardiamo iji fu Godri main ki fu emab mainvano kiain? Fu ijeg kuardiamga bu uri dab bui kuaime siguknum kuai, Nokafu una izeg roib kuardak? No uri kuak fu Godri mainmano kuakva fu una kuok revo ja irerafuon ba Jon ma vierafenvano kuok? ");
INSERT INTO nvm_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Regavo no kuak Jon daro iji fu emab mainvano kuakva e guri bu izegrekfuon no iji vierafega fuka dejufduom. Ijefuon maiji e fok bu ma vierafega e Jon fun ma e Godon vuak vierafene kuaimon beno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ijefuon bu una Jesu kua, Noba vierafenvano kuain. Rega fu uri kia, Ijekido daro igi na izia abe ire igin reoijo iji naba kuardiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesu fu ijeg kuardiame una kia, Iviakma vuak igi na kuardiakrejo iji ja izeg vierafej? E be fu am farif nokarok (2) nafen. Regavo fun uri va farifuon amur iji kua, Ivia ni va juar gafia ikreno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Fu ijeg kuamga farifuon amur iji fu kua, Na isediemno kuamevo rad fu una oi dakaroime fun una juar ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Areme asoifuon iji fun madu va farifuon diar iji kua, Aiji ivia va juar gafia ikrene kuain. Fu ijeg kuamga farifuon fu kua, Ke asoinun na ijegrekno kuagavo fuba vain. ");
INSERT INTO nvm_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Regavo ja vierafega am nokarok (2) ijia erar fu asoifuon fu vierafenma ijia kegoinmano kiain? Fu ijeg kiama bu kua, Farif amur ijarno kuain. Bu ijeg kuavga Jesu fu kia, Ni vuak igi na kuardiakrejo iji faif e iji takes abeoijo ijigam bara iji ebuon baru turaoijo iji bur ja asidiame e iji God fu oibuon iji samuagdiamo ijiena besum mazik. ");
INSERT INTO nvm_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Regavo e Godon vuak vierafene kuaimon Jon e do ruardiamo iji fun ro ja karinva ijia kekome unam ma iji ja vakfuon iji fun nijaidiain. Gavo vuak fuon iji jaba mukor faikoga bu e takes abeoijo ijigam bara iji ebuon baru turavo ijieb vuak fuon iji bu faime ma vierafen. Ja iji jan giain gavo jaka ba oijon karoime una vuak fuon faime ma vierafenvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ijegreare Jesu fu una kia, Ni una vuak be na bijame kuardiako faif. E be fu moik fuon ijia juar meneare fak kira ameoine aren. Areme guf ijia fu ar be madu bu ijia karine juar samuakfuon iji same uri e kafo kega bu juar iji samuakoga fun ar aibe vain. ");
INSERT INTO nvm_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Fu va ijia fiko in fuon bun sunin kirame duinva fu fain. Ijefuon fu efuon ik reoijo iji kiamga bu va in sunin roin fuifuon turakuai vain. ");
INSERT INTO nvm_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bu vake gafia usevga e iji in samua karinva ijieb uri e iji kuniaime e be bu dab fijakoga be bu dab kanava fu guain rega be bu mun karme kanain. ");
INSERT INTO nvm_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Bu ijegrejga e iji fun una efuon ikrejo uruvana kiamga bu madu una vain. Bu vakga e iji juar ijia in iji samua karinva iji bun madu e iji vainva iji kam unam besum iji bu renva ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Bu ijegrejga e iji fun una fui kuai, Na farinun kuaga fur vakma buba fu kanaken. Regavo bum fu agoime vuak fuon abekno kuaime fun farifuon kuamga radkma iji fur vain. ");
INSERT INTO nvm_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Fu vakoga e iji juar samuame karinva iji bun game uri bui kuai, E guri fu e iji juar igi menma ijefuon farif ijin. Ijefuon no fu kaname asoifuon ijefuon juar fok iji nor abekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Bun ijeg kuaime uri farifuon kunain dab juar fak gufa akozme usem kanavga fu guainmano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesu fu ijeg kuardiame kia, Bu ijeg ren gavo e iji juar koikin iji fu una ruakma fu e iji juar iji samuainva ijiebuon fu izegarekno kiain? ");
INSERT INTO nvm_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Fu ijeg kuardiamga e iji bu una kua, Fu ruakma fu uri e ise ijin kaniagavo e ma iji juar fuon mukor samuainva iji fu kege uniaikin bur juar fuon ijia in sunin iji kiriavo iji turame kafo fui namdakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Bu ijeg kuardavga Jesu fu una kia, Regavo ja Godon vuak bu usuibe isoinva iji jabe dame gain? Regavo vuak iji bu ijeg isoi, E ar savo iji bu mun ma iji fu ar uf ijia manine girekfuon iji bu game vierafero fu isero bu dab akozen. Regavo E Bomana iji fu mun iji una abenma ijefuon iviakma mun iji fu ar uf iji biekudieme manino iji fuka ikin. Regavo iji fuka ma fun E Bomana ijar koikfuon ire iji rena non gaga fuka ma. ");
INSERT INTO nvm_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ijefuon igia faif jaiji ja e ise iji bu juar ba mukorigia samuagdiavo ijekin. Ja na uzainva ijefuon God fu ik iji ja efuon samuagdiamo fu miainma iji fu kamaziame una e Jius bakin iji bu ik mukor rejo iji miak. Fu miaga bur vuak fuon ma iji abe kuaimoga e fok bu ma vierafene una e iji God fu oibuon iji samuagdiamo ijiena besum mazim kari vak. ");
INSERT INTO nvm_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ijefuon naiji na mun bomana ijin ijefuon e be erar fu ari kanaga fu mun azan ijia arikma buka buaseme iserek. Regavo madu e be erar fu mun ijar ari kanakma fuka una kuotuvat igegrekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Fu ijeg kuardiamga e mamkanuk isuf baroijo ijigam e Ferisis iji bu Jesu vuak iji fu bijame kuaimon iji faime vierafero fu buisina kuaimoro bu ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ijefuon bu uri Jesu kunaime tokuai vierafen. Gavo e fok ijia ruainva iji bu vierafega Jesu fuka ma e iji Godon vuak vierafene kuaimon ijin. Ijefuon e mamkanuk iji buka jume ire kafo buba fuon ren. ");
INSERT INTO nvm_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","2","Areme Jesu fu una madu vuak be ijeg bijame kuardiain. Fu kia, E iji God fu oibuon iji samuagdiamo iji fu e kin be fu moik samuamo iji fu farifuon ijar bara abekrega fu iro bomana be ikafa kanafuinma igekin. ");
INSERT INTO nvm_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kin iji fu iro iji kanafume fun efuon ikrejo iji kiamga bu va e iji bu iro fuon sarekfuon kiainma iji kiamga bu iro fuon iji sarekuai vain. Bun va e iji kiamoij ga e iji bu uzame ba iro ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ijefuon e kin iji fun una madu vuak igin efuon ikrejo ijin kuardiain. Fu kia, Ni va e iji kia, Maf-kau ma iji saruigin iji bun kaniame buaseme akozen ijefuon nan iro ikro samuain. Ijefuon ni migegare iro nun sarekno ruafno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Fu ijeg kuardiamga bun va e fok vuak ijin kuardiain. Ijegrene e iji buba una vuak iji fain gavo bun una ire buon kafokafo bu vierafenva iji reokuai vain. Be fu juar mekafa vain revo be fu monfuon ikrekafa vain. ");
INSERT INTO nvm_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Regavo e roin bu uri e iji vuak abe vainva iji kuniaime kam unam ise kafo buon reknum kaniavga bun aoin. ");
INSERT INTO nvm_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Bu ijegrejga e kin iji fu vuak iji faima fuka deajimga fu uri e azi kegoijo fuon kiamga bu va e iji kaniavga bu aoiknum uri ar buon kara java bu naoin. ");
INSERT INTO nvm_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Areme kin iji fun una efuon ikrejo iji kumena bu rokga fu kia, Iro nun fuka samairen gavo e iji na kiainva iji bu isema vierafene buba iro sarekuai ruain. ");
INSERT INTO nvm_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ijefuon iviakma ni una va mai mamkanuk unam ijia oknum e kafo ja giakva iji uruvana kia bu iro nun igi sarevno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Fu ijeg kiamga bun va unam ijia oknum e ise abevo ma iji uruvana kiavga bu iro iji sarekuai ruain. Bu roke ar gufi bu sanamikrejo iji fuka e ijar mame irtoijen. ");
INSERT INTO nvm_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","12","Areme e kin iji fun arume e fok gia vake gak e be fu ugon bu same e sanamivo ijia roko iji fuba same ruainmaga fu gain. Fu game uri e iji kua, Eko a izegarega a ugon iji bu same e sanamivo ijia vako iji aba same ruainmano kuain. E kin iji fu ijeg kuamga e iji fuba una roin kuardain. ");
INSERT INTO nvm_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ijefuon e kin iji fu una efuon ikrejo iji kia, E guri kunaim dab dia ga imut fuon iji tome abe ai makaf nakinma ijia akozef. Abe ijia akozga fu ijia fine vajai fian abeknum niraime ubai jakiknamikno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Areme Jesu fu vuak fuon kuaim vake barekafa uri kia, Unam besum ijegvo God fu vierafe buka e uruvana una aganfuon ijiena besum mazikfuon fu iji vierafene kumen. Regavo buka e sibank vuak fuon faime una aganfuon ijiena mazivno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Areme rad e Ferisis roin bun useme va unam izeg bu Jesu biesuame duna kuakfuon iji kuaima maren. ");
INSERT INTO nvm_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bun kuaime uri e vuak buon faivo roin ga e Erodon e roin kiavga bun Jesu fino ijia vain. Bu va ijia useme Jesu kua, E nijaidiamon no vierafega vuak irerag a kuaimon iji aka vuak ma ijesugin kuaim. Regavo e iji a vuak kuardiamo iji bukafu e mamkanuk ga e ukakna iji a juvknum kuardiamo bakin. Regavo aka vuak ma iji izeg God fu e igiebuon fu vierafenma a ijin dab e ijin nijaidiam. ");
INSERT INTO nvm_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ijefuon a vierafega akai nuvuon ijia no e Sisa e Romkobuon e bomana iji fuon takes abesvo iji kafu maren vo fuba marega ni ar kuarduoga no faivno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Bu ijeg kuardain gavo Jesu fu vuak buon ka kufui iji fun giain ijefuon fu uri kia, E guri ka ir kufuikin gurie ja era biesuakuai vierafene vuak kufui iji ke ruainvano kiain? ");
INSERT INTO nvm_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","20","Fu ijeg kuardiame kia, Ni mon sunin iji ja takes rekfuon iji abe nijaidie na gavno kiain. Fu ijeg kiamga bu uri mon sunin abe mavga fu abe nijaidiaknum kia, Ja igi jan gain. Ja gaga uikinik igeko if iji isoinva iji bu erafono kiain? ");
INSERT INTO nvm_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Fu ijeg kuardiamga e mamkanuk iji bu uri kua, Fu e Sisan uikinikno kuain. Bu ijeg kuardavga fu kia, Ijefuon ni giamga irerag iji bu e bomana Sisan kuaikva ni kege una fu vajaf. Regavo irerag iji ja giaga bu Godon kuaikva ni kege una God vajafno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Fu ijeg kuardiamga bu vuak iji faiva buka oiserdiamga bu Jesu areme vain. ");
INSERT INTO nvm_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","24","Areme tavan besum ijia e Sejusis roin bu Jesu fino ijia ruain. (Regavo e iji ruainva iji bu e iji aoime una urijo iji buba ma vierafej). Ijefuon bu useme Jesu duna ijeg kua, E nijaidiamon Mosis fu kuo, E be erar fu bara abe fu am kafo ba tuanaga fu guakma uviaifuon iji fuka bara amun iji fusik abe fuifuon am tuanakno kuin. ");
INSERT INTO nvm_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ijegvo e agan besum ijia bu efarif seven (7) ijeg bu igia nona karij. Ijefuon e bo buon iji fun bara aben gavo am kafo fuba tuanain gavo fum guain. Fu guamga uviaifuon iji fusik bara iji aben gavo fuk fuba am kafo tuanain gavo fum guain. ");
INSERT INTO nvm_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Fu guakoga uviaifijaf fok buk ijegrene vake efarif diar ijia baren. ");
INSERT INTO nvm_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Bu ijegrene rad bara ijar guain. ");
INSERT INTO nvm_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Regavo bara iji e fok bu abenva iji tavan iji e bu aoime una uri nivek kari vako ijia bara iji fu erafon barakno kuain? ");
INSERT INTO nvm_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Bu ijeg kuardavga Jesu fu una kia, Jaiji jaka ba mukor vierafen. Ijefuon maiji ja Godon vuak iji jaba fain ga daro fuon ijia fu ire kafokafo reno iji jaba vierafen. ");
INSERT INTO nvm_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ijefuon maiji tavan iji e bu aoime una uri nivek karijo ijia bara baru buba una sanamik. Gavo buka una anera iji bu varur gufia karijo igegrekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Regavo ja God e iji bu aoime una urijo ijefuon fu buk akai ijia kuainma iji jabe dame gain? ");
INSERT INTO nvm_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Regavo vuak iji bu isoinva iji God fu ijeg kuai, Naiji na e Eburam ga e Aisek ga e Jekafbuon Godno kuain. Ijefuon maiji fu e iji nivek karijo ijiebuon God. Regavo fu e iji buka mukor aoivo ijiebuon God bano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Fu ijeg kuardiamga e fok bu vuak fuon iji faiva buka oiserdiain. ");
INSERT INTO nvm_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Regavo e Ferisis iji bu faik fun Jesur vuak fuon ijia e Sejusis buon vuak iji fuka kaniatuama bu faime bun una besum afuin. ");
INSERT INTO nvm_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","36","Bu besum afuikoga e vuak akai nijaidiamon be fu uri Jesu biesuakafa kua, E nijaidiamon akai fok bu nainva ijia akai izar fuka ma bomanano kuain? ");
INSERT INTO nvm_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Fu ijeg kuardamga Jesu fu una roin kua, Akai ma bomana iji igin, Nika oion fok ga kaven on ga vierafe on fok iji nika God on iji oijmamne. Akaij ijar fuka bomana ga fuka ma ikin. ");
INSERT INTO nvm_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Regavo madu akai be ka ma bomana ijefkin iji, Nika izeg a on oijmanamimo ijeg una kaifon roin oijmiamne. ");
INSERT INTO nvm_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ijefuon maiji e fok Godon vuak vierafene kuaivo ijiebuon vuak ijiga Mosison akai fok bu akai nokarok (2) ijieb bu biduakiakok e bu ijia kegoinvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Regavo e Ferisis iji bu vek ijia afuinva ijia Jesu fu uri kia, E iji God kuama fu ruainma iji ja vierafega fu erafon uifarifno kiain? Fu ijeg kuardiamga e Ferisis iji bu una roin kua, No vierafe fu e Devidon uifarifno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Bu ijeg kuardavga Jesu fu una madu kia, Regavo irerafuon Kaven Akai iji fu Devidon oij ijia vierafe mamga fu e iji kua E Bomanano kuain? Ijefuon maiji fun Devidiri kua, God E Bomana ijar una e bomana nun iji kuak, Ni igi ij maink igia fi. A ijia fike na e ani on bu ana nigaraioijo iji nar kege kaniame ke diak rotit on ijia uniamno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Regavo Devid fu e iji God kuama fu ruainma iji kuak E Bomanano kuakma iji Devid fu izeg una e iji kuak, Aiji a uifarif nuno kuakno kiain? ");
INSERT INTO nvm_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Fu ijeg kuardiame barekoga rad e be fuba una Jesuon vuak iji roib kuardain vo una duna kafo fu kuardain. Regavo madu buba vierafero Jesu vuak iji fu kuardienma iji fu fuifuon kuainmaro buba ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Areme Jesu fu uri e fok abevo e vuak fuon faivo iji afuinva iji vuak nijaidiame kuardiain. ");
INSERT INTO nvm_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Fu kia, E akai nijaidiaoijo ijigam e Ferisis iji bu Godri akaij iji abe e Mosis mama fu abe miamga bu iji abe nijaidiaoij. ");
INSERT INTO nvm_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ijefuon jaka irerag fok bu kuardiavo iji ka igiame reof. Regavo jaib unam buon bu mimatame kegoijo ijia jajiak. Ijefuon maiji irerag bu kuaimoijo iji bu ma ijekma mimatame kegoijo bakin. ");
INSERT INTO nvm_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Regavo buka uri akai uruvana kege vajiavo iji buka in mug ka ma afirenma igeg kege kam faraf kamudiav. Regavo bu koikbuon una ja ifejdiaga ja akaij iji igiakfuon iji buba vierafen. ");
INSERT INTO nvm_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Regavo ire fok bu kegoijo iji bum ema ijieb giakuai bu ijin reoij. Buka uri buk akaij ijia vuak kafar kafo kege isoiseme kam mavua ukakna iji bu i fat ijia amardiainva ijia isoime kam faraf ga variatar buon ijia kiriamoij. Bu ijegrene buka uri ugon buon iji kam mukorigia amarme samoijo iji e bu giame kuai e iji buka e mamkanukno kuaivo. ");
INSERT INTO nvm_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bu ijegreoknum ar bu iro ijo ijia buka ar ma ijia kariknum ga ar bu afuime vuak kuaivo ijia buka bur e ikin rene fata ma iji kege karioijo. ");
INSERT INTO nvm_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bu vierafe e buka ar bu afuime ire kafokafo kimejo ijia bu mukorigia anadiakuai bu ijeg vierafej. Regavo madu e buka bu mukorigia agordiaknum kia jaiji jaka e nijaidiavno kiakuai bu ijeg vierafekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Jesu fu ijeg kuardiame kia, Ja koikjo jab kuaik noiji no e nijaidiavo ijino kuaik. Ijefuon maiji e nijaidiamo jon iji fun e besum ijesugin ga e fok iji bu uviaifjon. ");
INSERT INTO nvm_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Regavo madu jab e moik igeko igia e be kua, Ateno kuak. Ijefuon maiji Asoijon fun e besum iji varur gufia fino ijin. ");
INSERT INTO nvm_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Regavo jab areke e bu kia jaiji ja e nijaidiavo ijino kiak. Ijefuon maiji e nijaidiamo jon iji fun Kurais nar nunkua. ");
INSERT INTO nvm_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Regavo kafar jon ijia e iji erar fu e bomana rekma e iji na vierafe fuka una e ikreno igeg rekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ijegvo erar fu koikfuon abe e bomana reno iji God fu e iji abe una e ukakbe rek. Regavo erar fu una e ukakbe rene adumaduigin oino iji Godri fu dab una e ikin rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Regavo e vuak akai nijadiaoivo ijiga e Ferisis i kufuikin iji jaka juf. Ijefuon maiji ja e iji bu Godon e rekuai roko iji jaka jar unam buon iji bijukuriaknum vo jaka koikjo unam jon bijuv. ");
INSERT INTO nvm_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Regavo e iji vuak akai nijaidiavo ijigam e Ferisis i kufuikin iji jaka juf. Ijefuon maiji ja bara amun iji jaka mukorigia biesiame uri sinuom ga ar buon iji kamaziav. Jaka ijeg isema reoijknum vo una e nifak ijia jaka aroikarame jaoijmana sirimamej. ");
INSERT INTO nvm_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Regavo e vuak akai nijaidiavo ijigam e Ferisis i kufuikin iji jaka juf. Ijefuon maiji jaka jar sisim kege ar aibe ijia oknum e iji bu una jana rekfuon iji nisaimoijo. Ja nisaidiame e aferdiaga bu una unam jon ja reoijo ijia ifejdiav. Regavo iji bu ijeg ifejdiavo ijia buka ise jon iji asidiame ma ise rejo ijefuon bu iji buka jana besum maziv. ");
INSERT INTO nvm_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ijefuon jaka juf ijefuon maiji jaka e nizuriaigin igeg e iji jan aferdiame kam una unam ise ijia nijaidiaoij. Ijefuon God fuka ja kege arafiriak. Ja kuai e be erar fu Godon ar iji kurame akai kafo nakma fu ijar ire be rekma bano kuaiv. Regavo erar fu ire gord bu amarme ar bu sirimamejo guf ijia nainva ijia kurame akai kafo nakma irerag fu kuaimon iji fu markno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","E guri ka e buzegin nizuriaigin gurie. Ire gord iji fu akai bakin gavo fum tavan iji bu abe Godon ar ijia aru sirimamene abe God mavo ijia fu akai ren. ");
INSERT INTO nvm_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Regavo madu ja kuai, E be erar fu fata iji bu isuf baroijo ijia kurame akai be abedekma fu ijar irerag rekma bano kuaiv. Regavo erar fu ire iji bu karme isuf baroijo ijia kurame akai kafo nakma iji fu markno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","E guri ka ni zuriaigin gurie. Isuf iji fu akai bakin revo bum tavan iji bu kege isuf baroijo ijia isuf iji fu akai ren. ");
INSERT INTO nvm_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ijefuon eraneb bu fata iji bu isuf baroijo ijia kurame akai kafo navo iji buka ire fok fata azan ijia naoivo ijiebuon fok kuaiv. ");
INSERT INTO nvm_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Regavo madu erar fu Godon ar ijia kurame akai kafo namo iji fu ar ijesugin kurame kuaimon bakin. Regavo fu God madu kurame kuaim ijefuon maiji God fu ar ijia fin. ");
INSERT INTO nvm_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Regavo madu e be erar fu varur gufefuon if ijia kurame kuaimon iji fu Godon fata ma iji ga e iji ijia ajie fino ijefuon if ijia kuaim. ");
INSERT INTO nvm_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Regavo e vuak akai nijaidiavo ijiga e Ferisis gurie ka i kufuikin guri jaka juf. Ijefuon maiji ja juar jon ijia ire isaf ukakna minit ijigam diri ga kamin kuavo ja iji masivo iji jaka roin kege God vajaf. Regavo ire iji bum ukakna ga ja ijegrejo iji fun maren. Gavo una vuak ka mamkanuk iji fu akaij ijia kuai e oimardiaknum e ifejdiaknum e roin ma vierafejno kuainva iji jaka reoijo bakin. Ja ire ijin kege mimatame kegoknum vo una ire ukakna igi na kuainva iji madu kegokva iji fuka marek. ");
INSERT INTO nvm_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","E guri ka nizuriaigin gurie. Akai ukakna iji jaka kege mukorigia agordiav. Regavo una akai mamkanuk iji jaka nuigafiavno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Jesu fu ijeg kuardiame uri kia, E guri vuak akai nijaidiavo gurie ga e Ferisis gurie ka i kufuikin gurie. Ja vajai surif jon iji jaka kam mukorigia samuagdiav. Regavo oijon guf ijia jaka ire kafokafo ja jonkua vierafene kegoijo ijar fuka raren. ");
INSERT INTO nvm_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","E Ferisis nizuriaigin gurie, Amur ni oijon guf iji amare bu marke vajai jon fok bu mardiamno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Jesu fu ijeg kuardiame madu uri e iji vuak akai nijaidiavo iji abevo e Ferisis iji kia, E gurie ka i kufuikin gurie janika juf. Ijefuon maiji jaiji jaka e mako vien iji buka mukorigia amaren gavo guf iji fuka e an burarenva ijieb ijia naoivo ja ijekin. ");
INSERT INTO nvm_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ijegvo madu ja e fok ijiebuon nifak ijia oijo iji jaka e mukor. Gavo oijon guf ijia jaka ebuon vuak ise kuaiknum ise reoijno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Jesu fu ijeg kuardiame madu uri e vuak nijaidiavo iji abevo e Ferisis iji kia, E guri ka i kufuikin gurie janika juf. Ijefuon maiji ja e iji Godon vuak vierafene kuaivo ijiebuon mako vien iji jaka mukorigia amarev. Ja ijegrene kuros amare saknum sinar abedev. Regavo madu jaka e iji bu unam mukor reoijo bu aoinva ijiebuon mako vien ijin kam mukorigia amarev. ");
INSERT INTO nvm_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Regavo madu ja kuai, No saifnuvuon bu usuibe kari ruainva no ijia buna karivabatie noba bu renva ijeg una e iji Godon vuak vierafene kuaivo iji kaniakno kuaik. ");
INSERT INTO nvm_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ja ijeg kuaivo iji jaiji jaka saifjon iji bu e Godon vuak vierafene kuaivo iji bu kaniainva ja ijekin. Ijefuon maiji vuak jon izeg ja kuaivo ijia jan koikjon iji visume kuaiv. ");
INSERT INTO nvm_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ijefuon ni uri saifjon izeg bu kegoinva iji buin ijia ifejdiame rene vafno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Jesu fu ijeg kuardiame uri kia, E guri e biesiaoijo gurie jaiji jaka tabar nafediainma igekin. Ja mian iji fu naine ja jakiakreno iji ja izeg subinai usem vakva bakin. ");
INSERT INTO nvm_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ijefuon igia faif. Vuak igi na ma kuardiav. Na e Godon vuak vierafene kuaivo ijigam e Godon vuak iji mukor vierafejo ijigam e iji e nijaidiavo iji kiaga bu jon vuak. Na kia bu vuaga jar e roin ja kania bu aoiknum kam kuros kaniakfuon. Regavo roin bu ar jon ja sirimamejo guf ijia ga mai besubesum ijia vuakva jaka fijiaknum kaniame kam arafiriaok. ");
INSERT INTO nvm_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ijefuon maiji bun ik anej gamia anerene roke ivia igia ruainva ijia e iji maturainva iji God fu kiamga bu ruainva iji bun saifjon ijieb kaniain. Regavo e iji amur bu e Ebor kaname ura e Berekaian farif e Zekaraia kanain. E iji ja Godon ar bu sirimamejo ijefuon fata akaij iji samaij ijia kaniain. ");
INSERT INTO nvm_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ijefuon vuak igi naka ma kuardiav, Godri ire fok iji rene ruainma ijefuon e uifarif buon igi ja iviakma karinva iji fok fur kam arafiriaga jaka ma vajai fian abekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","O Jerusarem Jerusarem ar e iji Godon vuak vierafene kuaivo iji kaniain. Regavo madu ar e iji vuak abe oijo iji God fu kege uniamga bu jon vuainva iji mun tuame kaniain. Regavo nar afon iji na ja oijmiainva iji nakafu tavan izeg oijmiain. Na buiji naka um kukoro iji fu ukafijaf aferdia daf fuon ijia irame nakariamo ijeg na ij nun akozme afjon okuriain. Regavo na jaka ba bomana vierafej. ");
INSERT INTO nvm_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ijefuon jaiji ja ar iji e bu same ba ijia karijo igeg God fu ja ijeg areme unia vakfuon. Regavo e ani ga ire ise kafo bu jon rekva God fuba ifejdiak. ");
INSERT INTO nvm_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Regavo vuak igi naka ma kuardiav. Ja na jaba una giek revo ja vake tavan iji ja na oimardieme kie, No vierafe Godri e iji fu E Bomana ijefuon if ijia roko iji daro maga fu roko kuaivo ijia jason una na giekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Areme Jesu fun Jerusarem Godon ar iji areme kekome vako ijia e vuak fuon faivo iji bu usem ar ni mukor bu sainva iji kuardame nijain. ");
INSERT INTO nvm_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Bu ar ijefuon kuardavga Jesu fu kia, Iji fuka ma gavo ni ire iji bu kege ar iji sainva iji mukorigia giaf. Regavo na kuardiako faif. Mun besubesum guri bu kege ar guri sainva iji rad buba iji bu name ajienva ijeg naoime vak. Regavo mun fok buka uduime arikno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesu fu ijeg kuardiame fun va uruor be bu kua Orivsno kuavo ijia fikoga e vuak fuon faivo iji bu buonkua isuarigia fu fino ijia ruain. Bu useme kua, Nin Godon ar bu tavan ivez buja korekfuon iji a kuarduinma iji kuarduo no fai. Regavo madu no anf irerag ijia game vierafero tavan on a una roko iji fun samairenmaro no ijeg vierafek. Regavo madu moikigi fun barekafa buin ijia rokoro no ijeg vierafekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Bu ijeg kuardavga Jesu fu uri kia, Ni vuak igi na kuardiavo iji mukorigia gavknum of. Regavo jab e iji bu vuak kufui kuaimoijo ijiebuon vuak iji faime jajiak. ");
INSERT INTO nvm_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ijefuon maiji e uruvana bu useme biesiame kiak naiji na Kuraisno kiakva e uruvana buka uri bu jajiakfuon. ");
INSERT INTO nvm_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Regavo madu e buka ai samaij ja karinva ijia vo baga aibe ijia buon bijaimoga ja faik. Regavo igia faif. Ja vuak iji faikva jab uri juk. Ire ijekin iji buka rekfuon. Regavo jab vierafero moik igi fun iviakma barekro jab ijeg vierafek. ");
INSERT INTO nvm_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ijegvo moik mamkanuk roin bu uri buon bijaikega moik ukakna iji bu uri buon bijaik. Regavo madu moik kafokafo ijia fuka vasia kekokega moik fu urak. ");
INSERT INTO nvm_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Regavo ire ise kafokafo bu ijeg anerekva ni vierafero ire ise ka ma uruvana ijekin iji bu rad rekro ja iji vierafekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Rega e ise iji bu ja tofdia kam arafiria vo kaniaga ja aoik. Regavo madu e buka ja uzak ijefuon maiji ja nuifuon ikreoijo ijefuon bu ijeg rekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Regavo tavan ijia e roin bu buon ma vierafejo iji bun ijia areme una e roin oi isema vierafek. Bu ijegrene uri buon sivisanamiknum uri koikbuon kege una e ani buon vajiak. ");
INSERT INTO nvm_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Areme e roin bu usem biesiame kiak noiji no e Godon vuak vierafene kuaivo ijino kiame uri vuak kufui ijia kuardiame ja aferdiak. ");
INSERT INTO nvm_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Regavo fun unam ise ijieb moikigia rarekva e ma vierafejo iji bun kaifijaf bu oijmiavo iji bu ijia arekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Regavo e iji erar fu fuon ma vierafeno ijia fuka giriesame ifejdame vake buin ijia kekomo e iji God fu keunak. ");
INSERT INTO nvm_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Regavo vuak nun ma iji God izeg fu efuon ijiebuon oij iji samuagdiamo iji bu enun ik reoijo ijieb abe ar iror fokigia e fok kuardiak. Areme ijarson ire fok bu ijia barekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","Jesu fu ijeg kuardiame kia, Ja ar bu sirimamejo guf ijia vo fata akaij iji bu isuf baroijo ijia ire ise be fu ijia rega ja gak. Ja gakva ni Danier e Godon vuak vierafe kuaimon fu usuibe kuai, Ire ise be fu rekno kuainma iji vierafef. Ja ire iji gakva ni e fok Judia guf ijia karinva iji kiaga bu migegare subinaime uruor mamkanuk iji irevo irif ijia vaf. ");
INSERT INTO nvm_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Regavo e iji fu ar fuon azan ijia ajie fino iji fub una arime ar guf ijia sinuom fuon karekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Regavo e be fu juar fuon ijia ikreoino iji fub una ar fuon ijia ugon fuon fu azan samo iji karekafa vak. ");
INSERT INTO nvm_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Regavo tavan ijia bara iji bu e fudienva ijigam bara iji eraneb am gatkin aferdia oijo iji buka oifian abek. ");
INSERT INTO nvm_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","21","Ijefuonvo ni God sirimamekin jaba tavan iji iduan ufino ijiga tavan iji bu isuar karine God sirimamejo ijia subime vakfuon. Ijefuon maiji tavan ise iji ja oifian abekfuon iji fuka ma ise ijar rekfuon. Regavo ire ka ma ise ijekin be fu ik anej ijia roke iviakma igi be fuba ijeg ren. Regavo rad ire ka ma ise ijekin be fuba una rekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Regavo God tavan iji fuba ufume una ari ruainmabatie fu e be erar nivek fivakma bakin. Regavo fun Godri e iji fu imut bijiainma iji bu vierafenma ijefuon fu buifuon tavan iji abe ufume una arik. ");
INSERT INTO nvm_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ijefuon e be fu uri kiak e iji God fu kuamga fu no karaunuokafa ruainma iji fu gafa rokno gafno kiakma jab uri fu ma vierafek. ");
INSERT INTO nvm_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ijefuon maiji tavan ijia e kafo bu useme ja biesiame kiak, Naiji na e iji God fu kiemga na ruainva ijino uri na jajiefno kiak. Regavo roin bu usem biesiame kiak, Naiji na e Godon vuak vierafene kuaivo ijino kiak. Bu ijeg kuardiame uri anf ga ire sumakin kafokafo iji rene e ijiebuon oi ga buon ma vierafejo iji kam iserek. Regavo bu giriesakva bu e iji Godri imut bijiame kenma ijiebuon oij iji kam iserediak. ");
INSERT INTO nvm_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Regavo igia faif. Na vuak igi na amur kuardiaikin rad tavan iji ruakma ja giame vierafek. ");
INSERT INTO nvm_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Regavo madu igia faif. Ja e kafob kuardiame kiak e iji fu ai moikum namo gafa vo ar gafijano kiaga jab ma vierafene usem vak. ");
INSERT INTO nvm_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ijefuon maiji tavan iji Emabuon Farif igi na una roko iji na varur iji fu kaf gufia vebui karaga e fok ai moikigia karijo bu gavo na ijeg una roga e fok bu na giek. ");
INSERT INTO nvm_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Regavo ja um kafo bu kaf ijia ram oga ja giakva ni vierafero ire mutur be fu moikigia namoro ja ijeg vierafek. Unam besum ijegvo ja ire iji na kuardiainva ijekin kafo giakva ni vierafero Emabuon Farif iji nan una rokoro ja ijeg vierafekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Regavo tavan iji ja ire ka ise iji biediame barke rad tavan iji fuka una nakikega asam fuba una sanak. Regavo ire fok varur gufia girme naoivo iji buka katime uduime arikega mujur iji buk buka varur gufia jafeksa arik. ");
INSERT INTO nvm_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Rega tavan ijia Emabuon Farif ijefuon anf iji nar varur gufia reke e moik igeko bu gieme niraik. Bu ijegrejknum gieke Emabuon Farif igi na daro nun ga sanainma nun ka ma bomana ijekma vana araf ijia ari ruak. ");
INSERT INTO nvm_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ijegreare veg ka mamkanuk ijieb ijia foikega na ijia anera nun kege uniaga bu moik igefuon buin ijia ga varur gufefuon buin ijia e iji bijukuriak. Areme bur enun iji bu moik kafokafo igia karioinva iji na imut bijiainva ijin aferdiame una besum afuikno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jesu fu ijeg kuardiame uri in makam ijia bijame kia, Nin in makam iji game vierafef. Tavan iji in makam fu a kanamon iji ja game vierafero tavan iji juar mejo iji fun samairenmaro ja ijeg vierafej. ");
INSERT INTO nvm_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Unam besum ijegvo tavan iji ire fok ja giakva ja vierafero tavan iji na ruakfuon iji fuka samairenvo fun ijia anerenro ja ijeg vierafek. ");
INSERT INTO nvm_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Regavo vuak igi naka ma kuardiav, Ire fok na kuardiavo iji e aganjon igi bu iviakma kari roko iji bu vek karine giame rad son aoik. ");
INSERT INTO nvm_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Regavo varur gufeko moikigi buka bakrek gavo vuak nun fuba barekgavo fu tavan bog ijia navakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jesu fu ijeg kuardiame kia, Tavan iji na una roko iji Godon anera varur gufia karijo iji abevo Godon Farif igi nak naka ba vierafen. Regavo fun Godri fuonkua tavan iji vierafen. ");
INSERT INTO nvm_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Regavo tavan iji Emabuon Farif igi na una ruakfuon iji fun unam besum izeg fu e Noan renma fu una ijeg rekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Usuibe do fuba firainma ijia e iji buka do kugi ine uri duok ine baru bara buon sanamiknum ijegre vake ka Noar sisim ijia ajikoga bu ijia aren. ");
INSERT INTO nvm_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","41","Bu ijegreogavo irerag iji rekreno iji buka ba vierafen. Buba vierafenva ijia do iji fum ijia firame keko e ga ire fok numume vain. Regavo tavan ijia e nokarok (2) bu juar ikreoijo ijia Godon anera iji bu arime e besum afegavo be bu ijia areme vak. Regavo bara nokarok (2) bu duok nifiejo ijia anera bu arime bara besum afegavo be bu ijia areme vak. Unam besum ijegvo tavan iji Emabuon Farif na una roko iji fu ijeg rekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ijefuon ni mukorigia gavknum karif. Ijefuon maiji ja tavan ivez E Bomana jon igi na una roko iji jaiji jaba vierafen. ");
INSERT INTO nvm_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Regavo madu igia faif. E niesamo be fu tavan ivez e befuon ar bujakafa ruakreno iji e ar koikin iji fun vierafekma iji fuba ninaikfuon. Regavo fu uri ijia fino ijefuon e niesamo iji fu izeg ar fuon iji bujame ajiekma bado fu ijia arek. ");
INSERT INTO nvm_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ijefuon jak nika tavan bog samuaknum of. Ijefuon maiji Emabuon Farif igi na una roko iji jaba vierafenva ijia na ruakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Areme Jesu fu uri kia, Tavan iji na una vainva ijia janika ma vierafene e iji fu mukorigia vierafene kegoino igeg ikreof. E iji fu mukorigia vierafene reoke efuon bomana fu iji gakma fu kuaga fur una e iji funa ikreoijo iji samuagdiak. Fur samuagdiaga tavan bu duok ijo iji abekma fur migegare duok buon kege ro vajiak. ");
INSERT INTO nvm_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","47","Fu ijegreokega e bomana fuon fu una ar roke keko gakma fuka bomana fuon oimarek. Ijegreare fu e iji kuaga fur uri ire fuon fok samuagdiakfuon. ");
INSERT INTO nvm_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","50","Regavo e iji fu kegoknum samuaba uri kuaik enun bomana igi na vierafe fuba migegare una ruakno kuaik. Fu ijeg kuaime uri e iji fu samuagdiamo iji fijiaknum uri e ise ijiena duok ioknum do kugi iok. Fu ijegrene efuon bomana iji fuka rume ba una fu vierafeoino ijia fu una ruak. ");
INSERT INTO nvm_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Fu una kekome e iji fijame dab kaname kuaga fu ar iji e i kufuikin bu niraiknum ubai jakiknamivo ijia buna fikno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesu fu ijeg kuardiame uri vuak be ijeg bijame kuardiain. Fu kia, Tavan iji God fu una efuon ijiebuon oij iji samuagdiakfuon iji fu bara naise imut roin (5) ga roin (5) bu rait buon kege e bara abenma iji biekuai vainva igeg rek. ");
INSERT INTO nvm_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bara imut roin (5) bu mukor vierafen gavo bara imut roin (5) buba mukor vierafen. ");
INSERT INTO nvm_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ijefuon bara iji isema vierafenva iji bum uri rait buon ijesugin ke gavo kiresini kafo bu rad usekfuon iji kafo buba kuniaime vain. ");
INSERT INTO nvm_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Regavo bara imut roin (5) iji mukor vierafenva iji bun butor kege kiresini buon kafo veseme rait buon ijekma kuniaime vain. ");
INSERT INTO nvm_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Bara imut roin (5) ga roin (5) iji bun va gak e iji fu isuar tavan ufrenma ijia saroime ruakrega bu va vien ijia samuame karin. Bu ijia samuame kari vake ninadiamga bun ninaoin. ");
INSERT INTO nvm_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Areme tavan ufrenma ijia bu faik e be fu kumen, E iji bara abekreno iji fun rokno ni uri fu biefno kumen. ");
INSERT INTO nvm_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Fu ijeg kumega bara iji bun uri rait buon kege sanakuai urin. ");
INSERT INTO nvm_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Regavo bara imut roin (5) iji mukor vierafene kiresini vese kuniaime ruainva iji bun uri kiresini buon kege rait ijia vesen. Ijegreare bun vakuairejga bara iji ba mukor vierafenva iji bun uri kia, Rait nuvuon bu kiresini bakin ijefuon ni kiresini jon roin rait nuvuon ijia veseduovno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Bu ijeg kiavga bara iji mukoi vierafenva iji bu una kia, Kiresini igi fuka ba aresren. Ijefuon non kege rait nuvuon ijia vesenva fun aresren. Ijefuon ni una va sitova gafia kiresini jon kafo kimefno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Bu ijeg kiavga bun una kiresini kimekuai vako e iji bara abekreno iji fun rokga bara imut roin (5) iji mukoi vierafenva iji bun samuainvado bun funa aru vain. Bu arume ar iji bu sanamikrejo ijia duok ikuai vakoga bun vien dab bijukurain. ");
INSERT INTO nvm_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ijegrekoga rad bara iji ba mukoi vierafenva iji bun una roke ijia usen. Bu useme e iji bara abekreno iji anaiknum kua, E bomana E bomana ni kuoga no ijia aru vuakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Bu ijeg kuardavga e iji bara abekreno iji fu una roin kia, Naiji ja naba vierafenvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ijegreare Jesu fu vuak fuon kuaim barekafa uri kia, Ni mukorigia nisaiknum karif. Ijefuon maiji ja ivez ga tavan ivez na una ruakrejo iji jaba gainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesu fu ijeg kuardiame uri vuak be ijeg bijame kuardiain. Fu kia, Tavan iji God fu izeg efuon ijiebuon oij iji samuagdiakfuon iji fu e be fu aibe ijia vakafa uri efuon ikrejo nokbek (3) mon fuon atame vajiame vako bu fuifuon samuagdiainva igekin. ");
INSERT INTO nvm_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","E iji fu uri e be fu amur rokga fu uri mon faiv taosen (5,000) ijeg main. Regavo be fu mon tu taosen (2,000) ijeg main. Rega be fu vuan taosen (1,000) ijeg main. Regavo mon iji fu e besubesum vajiainma iji fu buon izeg mukoi vierafeknum kegoijo ijia giaknum vajiain. ");
INSERT INTO nvm_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Areme fun vakoga e iji fu mon faiv taosen (5,000) mainma iji fun mon iji abe va ikreoin. Fu ikreoine fusik una faiv taosen (5,000) be abe ijekma mazin. ");
INSERT INTO nvm_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Fu ijegrekoga e iji fu tu taosen (2,000) abe mainma iji fu madu mon iji abe ikreoine fusik una mon tu taosen (2,000) ijeg abe ijekma mazin. ");
INSERT INTO nvm_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Regavo e iji fu mon vuan taosen (1,000) ijeg mainma iji fun uri e bomana fuon ijefuon mon iji abe va mako rume ijia sauin. ");
INSERT INTO nvm_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Areme tavan jaoikin barekoga rad e bomana iji fun una roke gufia kekoin. Fu kekome e iji fu mon vajiainma iji kumega bu mon iji karme rokga fun mon iji bu karme ikrenva iji buna kuaim amaren. ");
INSERT INTO nvm_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Regavo e iji mon faiv taosen (5,000) ijeg abenma iji fun ro kekome e bomana fuon kuain. E bomana mon a mienma iji na abe va ikrene nasik una mon be abe ijekma mazime ruainva igijano ni gamne kuain. ");
INSERT INTO nvm_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Fu ijeg kuardamga e bomana fuon fu una roin kua, Ire sibank igi a kege mukorigia samuagdiainma ijefuon na kuaga ar ire fok samuagdiak. A ijegrenma ijefuon ni ro nosik besum oimarknum fioine kuain. ");
INSERT INTO nvm_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Areme e iji mon tu taosen (2,000) ijeg abenma iji fuk fun kekome kua, E bomana mon on a mienma iji na abe va ikrene nasik una be abe ijekma mazime ruainva igijano ni gamne kuain. ");
INSERT INTO nvm_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Fu ijeg kuardamga e bomana fuon fu uri kua, A ire sibank igi a mukor samuagdiainma ijefuon na kuaga ar ire fok samuagdiak. A ijegrenma ijefuon ni ro nosik besum oimarknum fioine kuain. ");
INSERT INTO nvm_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ijegreare e iji mon vuan taosen (1,000) ijeg abenma iji fun ro kekome kua, E bomana na vierafega aka e giki be. Regavo irerag kafo ar ba oinma iji am ijia kiaga bu kege vajav. ");
INSERT INTO nvm_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ijefuon naka dejufdiemga mon on na abe va mako rume ijia sauinva iji na abe ruainva igijano ni gamne kuain. ");
INSERT INTO nvm_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Fu ijeg kuardamga e bomana fuon fu kua, Aiji aka nuifuon ik mukorigia reoino bakin revo aka e nuon gikin. Regavo igia fai. Irerag na imut nun ijia ba oijo iji na kiaga bu kege vajievo iji an vierafen. ");
INSERT INTO nvm_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ijefuonvo a ijeg vierafekma ni mon nun iji abe va ar bu mon navo ijia abedega na una igeg ajie abekva a irerafuon ba ijegrenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Areme fu uri mon iji kamazame abe una e iji mon ten taosen (10,000) ijeg abenma iji main. ");
INSERT INTO nvm_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ijefuon igia faif. Erar fu tavan bog ire kafo bu vajavo ijia ma ijesugin kegokma fu una ire uruvana kafo madu kekfuon. Regavo erar fu tavan bog ire kafo bu vajavo iji kege ba mukorigia reoinon e iji bu una ire sibank iji bu vajainva iji buka kamazak. ");
INSERT INTO nvm_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ijefuon ni uri e ise iji kunaime dab makaf nakinma ijia akozga fu e iji bu ijia oifian abe niraiknum ubai jakiknamivo ijiena fino kiain. ");
INSERT INTO nvm_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","32","Areme Jesu fu madu uri kia, Tavan iji Emabuon Farif igi na una Kin igeg varur gufefuon sanainma ijiga Godon anera ijiena una roko ijia na fata ma ijia ajie fike e agan besubesum moikigia karioinva iji bu nifak nun ijia afuik. Bu nifak nun ijia karikega na e iji maf-sif samuagdiamo fu maf-sif ga maf-gout iji fu kanafum kafokafo uniamo na ijeg rek. Na uri e ma reoijo iji ke ata be uniaga e ise reoijo iji na ke be uniak. ");
INSERT INTO nvm_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Na ijegrene uri e ma reoijo iji na kege ij maink nun ijia uniagavo e ise reoijo iji na kege ij azinak ijia uniak. ");
INSERT INTO nvm_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Areme rad E Bomana nar uri e maturainva iji ij maink nun ijia karinva iji kiak, Jaiji fun Asoinun ijar daro miain. Ijefuon ni ro ar ma iji sanainma God fu ik anej fu moik ga varur igi ba amarenma ijia fu joifuon amardiainma iji abe karifno kiak. ");
INSERT INTO nvm_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ijefuon maiji na vasiaordien ga do kafiemga jar do ga duok vajieva na in. Regavo na jaka ba vierafe gavo jam kievga na ar jon ijia jana naioin. ");
INSERT INTO nvm_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Regavo madu na ugon bakin oijga jar ugon kafo vajien ga adam abejga jar samuagdien ga dibur fijga jar vua na gienvano kiak. ");
INSERT INTO nvm_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Rega e iji maturainva iji bu uri kiek, E Bomana no ivez a vasiakma oga no game duok vajain ga do kafamga no do main? ");
INSERT INTO nvm_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Regavo no ivez ba a game vierafe ga nom kuavga a nona nain ga detabar oga no sinuom vajainvano kieken? ");
INSERT INTO nvm_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Regavo madu a ivez adam aben vo dibur figa no ifejdaknum gak vuainvano kieken? ");
INSERT INTO nvm_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Bu ijeg kuardiekva na E Bomanabuon igi na uri kiak, Vuak igi naka ma kuardiav, Ire fok ja kaifnun igi e ikin bakin igiebuon ja renva iji ja nun renvano kiak. ");
INSERT INTO nvm_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Areme na una e ise iji ij azinak ijia irenva iji kiak, Jaiji na isediemo gareg vaf. Jaiji jan koikjo tavan bog unam ise iji oifian abeokfuon ja ijia kegoinva ijefuon ni mian iji naine vako iji God fu Setan ga anera fuon ijiebuon fu kanafuinma ijia vaf. ");
INSERT INTO nvm_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ijefuon maiji na vasiaordien ga do kafiemga jaba duok ga do vajieva na invano kiak. ");
INSERT INTO nvm_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Regavo naiji jaba na gieme vierafe ga jaba aferdieva na ar jon ijia jana naioin. Regavo madu na ugon bakin oijga jaba ugon kafo vajien. Regavo na adam abejga jaba ifejdien ga dibur figa ja madu ba vua gienvano kiak. ");
INSERT INTO nvm_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Na ijeg kuardiagakva bu una uri kiek, E Bomana a ivez vasiaordain ga do kafamga noba ifejdain? Regavo no izia ba game vierafevo ba aferda ar nuvuon ijia naoin? Regavo a izia ugon bakin oga noba ugon vajain vo adam abeknum dibur figa noba gavknum ifejdainvano kieken? ");
INSERT INTO nvm_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Bu ijeg kuardiega Kin igi na uri kiak, Vuak igi naka ma kuardiav. Tavan iji ja e ikin bakin igi uzame ba ifejdiainva iji ja na uzame ba ifejdien. ");
INSERT INTO nvm_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jaba ijeg e roin ifejdiainva ijefuon ni ar iji ja tavan bog ijia oifian abe vakfuon ijia vafno kiak. Regavo e iji maturainva iji bu ar iji e bu tavan bog ijia ma karivako ijia vafno kiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","2","Jesu fu vuak fok kuardiame barme fu uri e vuak fuon faivo iji kia, Tavan iji e Jius bu iro Fasova bu ikfuon iji fun naki nokarok (2) namo iji jan vierafen. Ijefuon igia faif. Bu tavan ijia Emabuon Farif igi na bu abe e ani iji miaga bu abe kuros ijia kaniekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Areme e Godon isuf baroijo ijiebuon e mamkanuk ijigam e Jiusbuon e mamkanuk roin bun e Godon isuf baroijo ijiebuon e bomana e Kaiafason ar ijia afuin. ");
INSERT INTO nvm_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","5","Bu ijia afuime isuar sauime izeg bu Jesu kanakfuon ijin kuain. Bu kuaime kuai, Noba tavan iji no iro ijo ijia kanaken. Ijefuon maiji e igia ruainva iji buka deajidiakma bu una no kanuokno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Areme rad Jesu fun ar Beteni e Saimon e iji matan kasi igekin iji abene una mainma ijefuon ar ijia fin. ");
INSERT INTO nvm_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jesu fu ijia fino ijia bara be fu ire udi mukor urino bu kege mon mamkanuk kimejo iji be saror ijia useme abe fu fino ijia ruain. Fu keko gak Jesu fu duok iga bara iji fu ire iji dab nigen fuon ijia ruardain. ");
INSERT INTO nvm_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Fu ijegrega e vuak fuon faivo iji bu ire iji fu reno iji gava buka deajidiain. Ijefuon bu kua, Irerafuon ire maigari fum dab nisem. Fu ire mukor iji arega abe kimene mon bomana abe una e sinuom bakin iji vajiakma fu arenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Bu ijeg kuaivga Jesu fun giame uri kia, Bara garefuon vierafe iji ja irerafuon dab arafirime oifian mav. Irerag fur renma iji fuka ire mukor iji nuifuon ren. ");
INSERT INTO nvm_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ijefuon maiji e iji sinuom bakin iji bu tavan bog igia jana karik. Regavo naiji naba tavan bog igia jana fiokfuon. ");
INSERT INTO nvm_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Regavo irerafuon fu ire udi mukor urino igi fu abe na ruardienma iji fu vek igi naba mako arinva ijia fu abe usemdieme amardiek. ");
INSERT INTO nvm_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Regavo vuak igi naka ma kuardiav, Ar iror izerkin bu vuak ma igi abe kuaimoijo ijia irerag bara igi fu renma iji bu abe ijia kuaimoijknum fu vierafekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Areme e tuer (12) Jesuon vuak faimo be if fuon iji Judas Iskariot iji fun va e isuf baroijo ijiebuon e mamkanuk iji karinva ijia kekoin. ");
INSERT INTO nvm_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","16","Fu kekome kia, Na Jesu abe una ja miakva ja irerag iji abe na miekno kiain. Judas fu ijeg kuardiamga bu ijefuon uri mon sunin teti (30) ijeg kege vajain. Ijegreare tavan ijia fun uri unam izeg fu Jesu abe miaga bu kanakfuon iji nisaimoin. ");
INSERT INTO nvm_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Areme tavan iji bu bred iriaikin ba istkma baroijo ijefuon tavan amur iji bu anerene duok ikfuon iji rokga e iji Jesuon vuak faivo iji bun useme Jesu kua, A vierafe no izia oifuon duok kanafuga a iro Fasova iji ikno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Bu ijeg kuardavga Jesu fu kia, Ni va Jerusarem useme aru vaga e be fu na ma vierafeno fu ijia figa iji gaf. Ja gakva kua, E Bomana iji fu kume tavan nun fun samairen. Ijefuon na vierafe na e vuak nun faivo ijiena ar on ijia iro Fasova iji ine oimarkno kuafno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ijefuon e iji Jesuon vuak faivo iji bun vuak irerag fok Jesu fu kuardiainma ijia jame va useme iro Fasova ijefuon duok kanafuin. ");
INSERT INTO nvm_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Bu ijegreoine tavan nakisrega Jesu fun e tuer (12) vuak fuon faivo ijiena fata irif ijia kari ameoine duok in. ");
INSERT INTO nvm_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bu karine duok ijo ijia Jesu fu uri kia, Vuak igi naka ma kuardiav. E igi ja nana karinva ijia e be fu na abe una e ani iji miaga bu kaniega na guakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jesu fu ijeg kuardiamga e vuak fuon faivo iji buka oifiadiain. Ijefuon e besubesum bu uri Jesu kua, E Bomana a vierafega kafu nar ijegrek vo na bano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Bu ijeg dab kuaivga Jesu fu uri kia, E iji fu bred fuon iji imut fuon ijia abe nosik dis guria abesmo e ijar na abe e ani iji miak. ");
INSERT INTO nvm_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Emabuon Farif igi naiji na bu izeg buk akaij ijia bu isoime nuisina kuainva ijeg bu na dab kaniega na guak. Regavo e iji erar fu na abe una e ani iji miakfuon iji naka fuifuon bomana oifiadiem. Ijefuon maiji Godri e iji fu dab unam ise ijia arafirik. Regavo asiefuon iji fuba fu nafenmabatie iji fun markno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jesu fu ijeg kuardiamgavo Judas e iji Jesu abe una e ani iji miaga bu kanakfuon iji fu uri Jesu kua, E Bomana a narno kuain. Fu ijeg kuamga Jesu fu una roin kua, Ke ire iji ar rekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ijegreare bu vek karine duok ijo ijia Jesu fu uri bred abe Godon sirimamene oimaren. Areme fu abe tuaseme ke e vuak fuon faivo iji vajiaknum kia, Bred igi fu vajai surif nun igekino ni kege if. ");
INSERT INTO nvm_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","28","Areme fu madu una kafus iji abe Godon sirimamene oimarme abe miaknum kia, Ire iji fu kavuan nun igekino abe if. Kavuan nun na usevo ijefuon duadok ijia God fu e fok ijiebuon ise iji giame arek. Regavo ise iji fu giame aremo ijia fu unam iviamkor iji amarek. ");
INSERT INTO nvm_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Regavo igia faif. Naiji na iviakma igia una gafeg naba una jana do vuain igi ik. Regavo nason rad Godon ar maijia jana ikno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jesu fu ijeg kuardiame barme bun uri dua uruknum usem uruor Orivs kuavo ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Bun va ijia usevga Jesu fu uri kia, Ivia naki e fok ja subinai vaga na ja ijia areme vak. Ijefuon maiji bun buk akai ijia isoime kuai, Bu e iji maf-sif samuagdiamo iji kanaga maf-sif fuon bu dab ataseme vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Regavo rad God fu kiega na una uri nar amur Gareri vake ja rad vuakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Jesu fu ijeg kuardiamga Fita fu uri kua, E guri roinb bu a uname subinai vak gavo naiji naba a uname kovakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Fita fu ijeg kuardamga Jesu fu uri kua, Vuak igi naka ma kuardavno mukor igia faimne. Ivia naki kukoro fuba kumeke ijia e bu nuifuon kuakva a tavan nokbek (3) kiak na e iji naba vierafenvano kiake kukoro fu ijia kumekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Jesu fu ijeg kuardamga Fita fu una kua, Na vierafe bu kaniega na osik guakva iji naba kiak aiji naba vierafenvano kiak. Fita fu ijeg kuardamga e iji Jesuon vuak faivo iji buk bu uri vuak besum ijeg Jesu kuardain. ");
INSERT INTO nvm_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Areme Jesu fun e vuak fuon faivo ijiena juar Getsemenino kuavo ijia vain. Bun va ijia useme Jesu fun uri e vuak fuon faivo iji kia, Janin igia karike na va gafia sirimamejno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Areme fun uri e nokbek (3) Fita ga e Zebedion afijaf nokarok (2) e Jeims ko Jon ijin aferdiame funa vain. Regavo fuka uruvana igia oifiaime ka ma oiseren. ");
INSERT INTO nvm_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ijefuon fu uri kia, Naiji oinun iji fuka uruvana igia oifiadiedo na bagain nakafu guakfuon. Ijefuon jaka igia karine na samuagdiefno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Fu ijeg kuardiame fun fuonkua sibank biom aibe ijia tuame moik ijia dijeme sirimamen. Fu sirimamene kua, Asoinun a vierafe fun markma ni vajai fian igi na abekrejo ijiga na guakrejo iji fub nun rekfuon. Regavo baga ni on vierafenma ijia rene kuain. ");
INSERT INTO nvm_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jesu fu ijeg sirimamene barme una rogak e vuak fuon faivo nokbek (3) iji bun ninaoin. Bu ni naoivga fu giame keko Fita kua, Fita ja e nokbek (3) iji ja irerafuon ni naoiv? Ja izegrenva ijefuon jaba tavan ivuankbe uri ni narame nana karij? ");
INSERT INTO nvm_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Uri koikjo samuanamime sirimameknum kariga kaven ise Setan fu ja biesiakma jaba zazaikno kiain. Fu ijeg kuardiame kia, Vuak igi naka ma kuardiav. Oijon buka sirimamekuai vierafe gavo vajai jon ijieb buka zazaivno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Fu ijeg kuardiame fun una fuonkua madu sirimamekafa vain. Fu va sirimamene kua, God Asoinun vajai fian igi na abekrejo iji ab areke na vajai fian abe vake guakva iji na vierafe fun vierafeon ijia ren ijefuon fuka rekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Fu ijeg sirimamene una madu rogak e iji buka nitubaidiamga bun ninaoin. ");
INSERT INTO nvm_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ijefuon fun ijia magiame una madu va besum fu amur sirimamenma ijeg una sirimamen. ");
INSERT INTO nvm_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Areme fun una kekome e vuak fuon faivo iji kia, Jaiji ja vek ijeg ninan abej. Ja ninan abejo ijefuon ni gaf tavan iji Emabuon Farif igi bu na abe una e ise reoijo iji miaga bu kaniekfuon iji fun samairen. ");
INSERT INTO nvm_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Regavo e iji fu na abe e ani nun miakfuon iji fun iga rokno uriga no vakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesu fu vek manine vuak kuardiamo ijia e vuak fuon faimo be e Judasno kuavo iji fun ijia kekoin. Fun e azi kegoijo iji ga e isuf baroijo ijiebuon e mamkanuk ijigam e Jiusbuon e mamkanuk bu uniafdainva ijiena kakigam jua magu kege ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Regavo Judas fun vek ijia ujuriame kia, Ja giega na va e izin abe ui mikva ja e ijin kunaime tofno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ijefuon Judas fun migegare kekome Jesu manino ijia manine kua, E nijaidiamon afurvejo iji fu osikno kuame fu kunaime uimin. ");
INSERT INTO nvm_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Fu uimimga Jesu fu uri kua, Kainu migegare irerag a vierafenma iji rene kuain. Jesu fu ijeg kuardako ijia e ani iji bu ijia useme Jesu kunaime dab toin. ");
INSERT INTO nvm_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Regavo e iji Jesuna oijo be fun uri kaki fuon darume dab e be e bomana isuf baroino ijefuon ikreno ijefuon ada iji kana daturain. ");
INSERT INTO nvm_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Fu ijegrega Jesu fu uri kua, Kaki on iji abe una surif fuon ijia abesemne. Ijefuon maiji e iji eraneb bu kaki buon ijia kege e kaniavo iji kaki ijieb una bu kaniakfuon. ");
INSERT INTO nvm_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Regavo igia faif. Na Asoinun iji kua fu anera fuon ka ma uruvana kiaga bu iviakmaigia migegare na ifejdiebatie na vierafega na ijeg rekfuon. ");
INSERT INTO nvm_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Regavo na ijegrekva na vierafe Godon vuak iji bu buk akai ijia isoime nuisina kuainva iji fuba aresrekfuon. Ijefuon ni areke irerag fu kuainma iji fu reno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jesu fu ijeg kuardiame una e fok ruainva iji kia, Ja vierafero na e kuriai e kaniavo ijefuon jaka kakigam jua magu iji kege na okurieme tofdiekuai ruain. Na tavan bog naka e Jiusbuon ar bu sirimamejo ijia aru fine vuak nijaidiain gavo jaba ijia arume na tofdien. ");
INSERT INTO nvm_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Regavo na vierafe ire fok iviakma reno iji fuka vuak irerag fok e Godon vuak vierafene kuaivo bu buk akaij ijia isoinva iji fu ijekma aresrekno kiain. Jesu fu ijeg kuardiako ijia e vuak fuon faivo fok bu ijia uname bun uri subinai vain. ");
INSERT INTO nvm_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ijegrene e iji Jesu kunaime toinva iji bun fu afeme e Kaiafason ar ijia vain. Ijefuon maiji e vuak akai nijaidiavo ijigam e mamkanuk iji bu ijia besum afuin. ");
INSERT INTO nvm_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Bu Jesu afeme vakga Fita fu aibe gamia giaknum jajia roke e isuf baroijo ijiebuon e bomana ijefuon ai makaf ijia kekoin. Fu ijia kekome aru va e iji juo karijo ijiena fin. Fu ijia fine gia are bu Jesu abe izegre fu giakro fu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Regavo e isuf baroijo ijiebuon e mamkanuk ijigam e mamkanuk fok kot faivo iji bun uri vuak kufui kafo Jesusina kuaime nisain. Bu nisaiga fu ise kafoga bu abe kuros kanakuai bu ijefuon ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Regavo bu vuak ise fuon kafo buba fain. Regavo madu buka e uruvana arume Jesuon vuak kufui ijin ijia kuain gavo bu vuak ise kafo buba fain. Bu ijegrejo ijia e nokarok (2) bu arume kia, E guri fu kuai na aresredo na Godon ar bu sirimamejo iji buzakorega naki nokbek (3) barke na una same barekno kuainmano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Bu ijeg kuaivga e isuf baroijo ijiebuon e bomana iji fu uri una Jesu kua, A vuak guri bu oisina kuaivo iji abe una vef kuardiak vo a bano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Fu ijeg kuardamga Jesu fu vuak kafo ba una roin kuardain. Fu vuak ba kuardiamga fu una kua, Naka God iji fu ijia fivako iji kurainvano a vierafega an ma Godon farif e iji fu kuamga fu ruainma ijiga ni ijeg kuarduomne kuain. ");
INSERT INTO nvm_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Fu ijeg kuardamga Jesu fu una roin kua, Vuak iji an koikon ija kuaim ijefuon naiji na e ijin. Regavo na igi kuardiakrejo ni faif. Ivia igia una gafeg vako ijia Emabuon Farif igi naiji na God e darokin ijefuon ij maink ijia fik. Regavo rad na varur gufia una vana araf ijia ari roga ja giekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Fu ijeg kuardiamga e isuf baroijo ijiebuon e bomana iji fu vuak iji faima fuka deajimga fu uri ugon fuon fu sainma iji kuniai bujain. Fu ijegrene uri e iji kot faivo iji kia, Fun koikfuon ija kuaima non fain. Ijefuon na vierafe no una vuak irerag iji faikva bakin revo madu no una e kafo erane kiaga bu vuak ise fuon kafo kuarduoga no faikva bakin. Regavo vuak ise kafo fun Godsina kuaimon jan fain ijefuon fuiji ja dab izegarekno kiain? ");
INSERT INTO nvm_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Fu ijeg kuardiamga e fok bu uri roin kuain. E iji fu kuai, Fu Godk besumno kuainma ijefuon no vierafe noka dab kana fu guakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Areme e iji kot faivo iji bun uri ugon fat be abe Jesuon nikuik ijia kiramdame uri uikinik fuon ijia juvit foisdaknum kanain. Regavo roin bu uri kua, A kume naiji na Kurais e iji God fu kuamga fu ari ruainma ijino kumen. Ijefuon ni e iji erar a kanamo iji kura no vierafero an ma e iji God fu kuamga fu ari ruainma ijinro no ijeg vierafejno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Regavo Fita fu Kaiafason ar makaf fak gufa ijia fin. Regavo bara be ijia ikreno ijar keko game kua, Na vierafega a e be Jesu e Gareriko ijek oina na gainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Bara iji fu ijeg kuamga Fita fuka uri e fok ruainva ijiebuon nifak ijia fen. Fu feme kia, Na e iji ja kuaivo iji naka ba vierafenvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Fu ijeg kuardiamevo fun una kekome Kaiafason ai makaf vien ijia vain. Fu ik keko vako ijia bara be ijia ikreno ijar game uri e iji irenva iji kia, E igi fu Jesu e Nasaretko ijek oina na gainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Bara iji fu ijeg kuaimga fu madu una feme kia, Naka God kuraido e iji naka ba vierafenvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Areme tavan sibank barko e be samaij ijia manino ijar kekome Fita kua, Bara iji fuka ma kuaim. Aiji ak a ebe fusik oinon ijin. Regavo madu ir on no faiga aka e be buna oino ijino kuain. ");
INSERT INTO nvm_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Bu ijeg kuardavga Fita fu uri God kurame kia, Na kufuimekva Godri na abe arafiriek. Regavo nan ma kuardiav. E iji naka ba vierafenvano kiain. Fu ijeg kuardiako kukoro fu ijia kumen. ");
INSERT INTO nvm_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Fita fu ijia una vuak iji Jesu fu ur kuardame kua, A kukoro fuba kumeke a ijia tavan nokbek (3) fekno kuainma fu iji vierafen. Rega fuka uruvana igia oifiaimga fu kekome makaf ijia ka bomana nirain. ");
INSERT INTO nvm_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Areme suok nakitu tavan ik abaisako ijia e isuf baroijo ijiebuon e mamkanuk ijigam e Jiusbuon e mamkanuk iji bun unam izeg bu Jesu kanaga fu guakfuon iji kuaime ujuinamin. ");
INSERT INTO nvm_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Areme bun Jesu bu toinva ijekma afeme una usem Fairet e Romkobuon e bomana ijefuon vain. ");
INSERT INTO nvm_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Bu Jesu afem vakoga Judas e iji fu Jesu abe una e ani iji miainma iji fu giak bun Jesu abe kanaga fu guak ijefuon fu tavan ijia oi dakaroin. Fu ijia oi dakaroime mon sunin teti (30) iji fu kenma iji ke una va e isuf baroijo ijiebuon e mamkanuk ijigam e Jiusbuon e mamkanuk iji karinva iji vajiakafa vain. ");
INSERT INTO nvm_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Fu va ijia kekome kia, Naka e iji fu ise kafo ba renma iji abe e ani iji miainvado bun kanaga fu guak. Ijefuon na vierafe naka ma ise renvano ni mon jon igi una karefno kiain. Fu ijeg kuardiame mon iji abe miamga bu uri kua, Regavo mon iji no abe irerag abek? Unam iji no nor renva bakin gavo an ar koikon renma ijefuon afikin iji fu on no kuain. ");
INSERT INTO nvm_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Bu ijeg kuardavga Judas fu uri mon iji dab ar bu afuime God sirimamejo guf ijia akoziame keko va iki guain. ");
INSERT INTO nvm_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Regavo e isuf baroijo ijiebuon e mamkanuk iji bu uri mon sunin iji abe kuai, Mon igi bu abe e kimene kanain ijefuon noba abe una mon iji no God vajavo ijekma abedekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","8","Ijefuon bu uri mon iji abe izegrekfuon iji kuaime bun mon iji abe e ai kafoko bu aoiga bu kege makorukfuon iji kimen. Regavo moik iji bu e saror amardiavo ijiebuon moik. Ijefuon iviakma igia moik if iji bu kua, Moik iji bu mon iji e kimene kanavga fu guainma ijia abe kimenvano kuavo. ");
INSERT INTO nvm_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Bu ijeg kuainva ijia vuak irerag Jerimaia e Godon vuak vierafene kuaimon fu ma usuibe kuainma iji fun ijekma aresren. Regavo vuak iji fu kuainma iji bu ijeg isoi, Mon iji e Isrerko bu abe fu kimekfuon iji bu kuaime abe marenva iji bu mon sunin teti (30) ijeg. Regavo mon iji bu abe e iji saror amardiamo ijefuon moik iji kimekno kuain. Regavo vuak iji fun Godri kuardiainma bu ijegrenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Areme e mamkanuk iji bun Jesu afeme e Romkobuon e bomana Fairet nifak ijia unava fu ijia manin. Fu manikoga Fairet fu uri Jesu kua, A vierafega aiji an ma e Jiusbuon kin ijino kuain. Fu ijeg kuamga Jesu fu uri una roin kua, Ke vuak iji a kuaimon iji an ma kuaimno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Rega e isuf baroijo ijiebuon e mamkanuk ijigam e Jiusbuon e mamkanuk bu uri unam ise kafo fu kegoinma ijefuon kuardavga Jesu fuba una vef vuak kafo kuardiain revo fuka ir bijuin. ");
INSERT INTO nvm_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ijefuon Fairet fu madu una uri Jesu kua, A vuak fok bu oisina kuaivo iji an faigavo a irerafuon vuak kafo aba una vef kuardiamno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Regavo Jesu fuba una vuak kuaikafa vierafen ijefuon e Romkobuon e bomana iji fu iji gama fuka bomana oiseren. ");
INSERT INTO nvm_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Regavo juaivasia besubesum ijia bu iro Fasova iji ijo ijia e fok bu e Romkobuon e bomana iji kuaga fu e dibur karijo ijia e be bu vierafejo iji keunaga fu keko vako. ");
INSERT INTO nvm_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ijefuon tavan ijia e be ka ma ise reoinon fu ijia dibur fino iji e fok bun game vierafenva if fuon Barabas. ");
INSERT INTO nvm_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ijefuon e fok bun besum afuivga Fairet fun uri kume, Ja vierafega na e Barabas keunak vo na Jesu e iji bu kua Kuraisno kuavo iji keunaga fu vakno kumen. ");
INSERT INTO nvm_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Regavo Fairet fun vierafega bu Jesu oi isema vierafeknum funa nigaraioijo ijefuon bu fu afeme fuon ruain. ");
INSERT INTO nvm_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Regavo tavan iji Fairet fu fata iji bu ijia ajie karine kot faivo ijia fino ijia bara fuon ijar vuak abedeme kume, Ab fine e iji ka ise kafo ba renma iji abe ire kafo fuon rek. Ijefuon maiji na naki naka ise be naine fu gainvano kumen. ");
INSERT INTO nvm_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Regavo e isuf baroijo ijiebuon e mamkanuk ijigam e mamkanuk roin bu uri e fok soisoime kia, Jaka E Romkobuon e bomana iji ijeg kua, No vierafe a Barabas keunaga fu vak. Regavo Jesu iji no kanaga fu guakno kuafno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ijefuon bu irevga Fairet fu uri kumen. E nokarok (2) igi ja vierafe na era joifuon kua fu keko vakno kumen. Fu ijeg kuardiamga bu una roin kua, No vierafe aka Barabas kuaga fu keko vakno kumen. ");
INSERT INTO nvm_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Bu ijeg kumejga Fairet fu una madu uri kia, Regavo ja Jesu e guri bu kuai fu Godri kuamga fu ruainma kuainva iji na abe izegrekno kiain? Fu ijeg kuardiamga e fok buka uri una roin kume, Abe kuros kanafno kumen. ");
INSERT INTO nvm_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Regavo Fairet fu una kia, Regavo fu ise irerag iji renma ijefuon ja abe kuros kanakrejno kiain. Fu ijeg kuardiamga buka uri uruvana igia biumame kume, Abe kuros kanafno kumen. ");
INSERT INTO nvm_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Bu ijeg kumejga Fairet fun giame vierafero fu una vuak kafo kuaikma buka bijaikro fu uri do jiame abe e fok ijiebuon nifak ijia imut soin. Fu imut do some kia, E igi kanakfuon iji na nar kiaga ja rekva bakin. Regavo ja e igi ise renma bakin iji kanakva afikin iji jan jar abek. ");
INSERT INTO nvm_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Fu ijeg kuardiamga e fok ijia irenva bu una kume, Iji aka ma kuaim. Ijefuon ni a e iji no fu kanaga fu vajai fian abene guakma iji nor afnuvuon ijiena afikin iji abekno kumen. ");
INSERT INTO nvm_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Areme Fairet fun uri Barabas buifuon kuamga fu keko vakga fu uri Jesu abe e azi keoijo iji miamga bu fijame afem kuros kanakuai vain. ");
INSERT INTO nvm_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Areme Faireton e iji azi keoijo iji bun uri Jesu afeme dab usem una Faireton ar mai makaf ijia ruain. Bu afeme ijia rokga e azi keoijo fok bu useme Jesu dab kirakurain. ");
INSERT INTO nvm_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Areme bun uri ugon fuon fu sainma iji rusdame uri ugon jaraikin kavuan iji be dab abesdain. ");
INSERT INTO nvm_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bu ijegreare uri kiej ufume abe ateveme dab Jesuon nigen ijia abesdain. Areme bun uri guduar abe maga fu imut maink ijia kunaim manikoga bun nifak fuon ijia ato saknum kua, E igi fu e Jiusbuon Kin fu tavan bog ijia fivako ijino kuain. Regavo ire fok bu ijegrenva iji bu ma vierafene renva bakin revo bum Jesu dab varaimenva ijefuon bu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bu ijegrene dab juvit foimadiknum guduar iji fu kunainma iji dab kiej fu abesenma azan ijia nizuin. ");
INSERT INTO nvm_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bu dab ijeg varaimene barme uri ugon kavuan bu abe abesdainva iji kunaim irain. Areme bun una ugon fuon ma iji kege samdame bun afeme usem kuros kanakuai vain. ");
INSERT INTO nvm_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Bun useme afem unam ijia vako ijia bu e Sairinko be if fuon Saimon ijin bien. Bu e iji bieme kuriairevga fu uri Jesu ifejdame kuros ijin dab dabein. ");
INSERT INTO nvm_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Fun kuros iji abe dabemga bun roke ar Gorgotano kuavo ijia usen. (Regavo if Gorgota ijefuon ma iji uruor iji fu e nigen an igekin). ");
INSERT INTO nvm_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bu ar ijia useme do vuain abe inak kugi kafo ijekma amarme abe maga fu ine fuba vajai fian abekro bu ijeg ren gavo fu sira faime fuka uzain. ");
INSERT INTO nvm_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Areme e azi kegoijo iji bun uri Jesu dab kuros ijia kanain. Bu dab kuros kaname rad bun uri Jesuon ugon iji kam name kas dab akoze arega are erar kegaro bu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Bu ijegrejknum karine Jesu fu kuros kaf ijia kiramo ijin nikajain. ");
INSERT INTO nvm_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Regavo in bu Jesu abe kuros kanainva buin ijia bu vuak be ijeg fuisina isoime kanain. Regavo vuak iji bu ijeg isoime kua, E igi Jesu fu e Jiusbuon Kin ijino kuain. ");
INSERT INTO nvm_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Areme madu bun e niekin nokarok (2) kam Jesuna kuros ijia kaniain. Be bu abe ij maink ijia kanaga be bu abe ij aizinak ijia kanain. ");
INSERT INTO nvm_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Regavo e roin bu unam iji bu Jesu abe kuros kanainva samaij ijefuon roko iji bu usem game nigen katikatiknum dab varaimene kuai, A kume a Godon ar bu sirimamejo iji buja kore gavo naki nokbek (3) a una same barekno kumen. Ijefuon ni koikon keunanamimne. Regavo madu an ma Godon Fariga ni kuros iji areme una ari roga no gavno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bu ijeg kumekoga e iji isuf baroijo ijiebuon e mamkanuk ijigam e vuak akai nijaidiavo ijigam e mamkanuk roin iji buk bu Jesu dab unam besum ijeg varaimen. ");
INSERT INTO nvm_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Bu dab varaimeknum kuai, Fu e roin karauniain gavo fu izeg una koikfuon keunanamikma bakin. Regavo madu fuka e Isrerkobuon Kin bomanakono kuainma ijefuon ni are fu koikfuon kuros kaf ijia iviakma ari roga no game una fu ma vierafej. ");
INSERT INTO nvm_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Regavo madu fuka God ma vierafeknum kuai fu Godon Farifno kuaimon. Ijefuon ni areke God fu iviakma fu keuna vo fu baga no iji gavno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Regavo madu e niekin nokarok (2) iji bu ke funa kuros kaniainva iji buk bu unam besum ijeg una Jesusina vuak ise kafo kuain. ");
INSERT INTO nvm_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","46","Bu ijegrene roke tavan uk maniko ijia vana o ruakoga ai fok fuka tavan nakime vake tavan una gara manin. Areme Jesu fuka ijia uruvana igia biumame kume, Irai Irai rama sabatanino kumen. Regavo vuak ijefuon ma iji God nun God nun a irerafuon na unieko vain? ");
INSERT INTO nvm_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Fu ijeg kumega e kafo ijia irenva iji bu faime kuai, Iji fu e Eraija kumeno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Regavo e be fuka una kukume keko atebu be abe in buin ijia utime abe do vuain ijia abesme Jesuon ir ijia azirda are fu iga fu gakafa fu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Regavo e roin bu uri kuai, Areke no irem gaga Eraija fu ro fu keuna no gavno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ijegrekoga Jesu fuka una uruvana igia biumame arekoga kaven fuon fu ijia unako vako fu guain. ");
INSERT INTO nvm_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Fu guako ijia ugon iji bu abe Godon ar sirimamejo guf ijia kirainva iji fu dab uf ijia bujame ari roke buin gumia kekoin. Fu ijegrekoga moik urame munuag iji bu kam uf ijia visuseme roinroin ren. ");
INSERT INTO nvm_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Fu ijeg urakoga mako vien iji buka kam visu korekoga Godon e akaij iji bu aoinva bu kege mako ruinva iji Godri e fok fuka karauniama bu una uri nivek karin. ");
INSERT INTO nvm_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bu mako iji areme ajie usekoga rad Jesu fu guame una uriga bu una Jerusarem mai akaij ijia aru vakoga e fok bu e iji giain. ");
INSERT INTO nvm_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Regavo e azi kegoijo ijiga ebuon bomana iji bu karine Jesu nikajavo iji bu moik iji uramo ijiga ire fok bu rejo iji giava buka bomana dejufdiain. Bu dejufdiamga bu uri bui kuai, E guri no vierafe fuka ma Godon Farifno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Regavo bara uruvana eraneb bu Gareri gamia Jesu jame ifejdaknum ruainva iji buka aibe gafia ireme giain. ");
INSERT INTO nvm_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Regavo bara iji buna ruainva iji bara Meri Megdarin ga Meri e Jeims ko Josofbuon asie ijiga e Zebedin bara ijieb ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ijegrene fun tavan nakisrenma ijia e sinuom zarainma be ar Arimatiako if fuon iji Josof fu ijia ruain. Regavo fuk fu e Jesuon vuak faimo be. ");
INSERT INTO nvm_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ijefuon fun va Faireton nifak ijia kekome Jesuon vajat surif jafe arikafa kuain. Fu kuamga Fairet fu kua, Fun marenmano ni va surif fuon kunaim jafene kuain. ");
INSERT INTO nvm_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ijefuon Josof fun una va Jesuon surif kunaim jafene ugon iviamkor ijia abe anuin. ");
INSERT INTO nvm_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Areme fu abe va munua be fur koikfuon iviakma kajuame amarenma ijia unain. Fu abe ijia uname uri mun bomana be mako vien ijia namo iji vajame dab munua vien iji bijukurame fun vain. ");
INSERT INTO nvm_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Fun vakoga bara Meri Megdarin ko bara be if fuon Meri iji bu mako vien iji samuame karin. ");
INSERT INTO nvm_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ire fok renma iji fu tavan Fraide ijia ijeg ren. Regavo afarma iji fu e Jiusbuon tavan Sabat (Satade) bu isuar karine Godon sirimamejo ijin. Ijefuon e isuf baroijo ijiebuon e mamkanuk ijiga e Ferisis iji bun Fairet vuak kuardakuai vain. ");
INSERT INTO nvm_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Bun va useme kua, E bomana e ir kufuikin iji fu vek fioinma ijia fu kuai, Na naki nokbek (3) bareke na una uri fivakno kuainma iji no vek vierafen. ");
INSERT INTO nvm_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ijefuon ni kuoga no e roin kega bu va mako vien iji samua vake tavan nokbek (3) iji fu kuainma iji asimno kuain. Regavo noba ijegrekva e vuak fuon faivo ijieb ro vajai surif fuon niesame abe va e biesiame kia Jesu fun una uri nivek fino kiak. Ijefuon maiji fu ur vuak kufuimene kuai, Na Godon Farifno kuain. Regavo bu una madu kufuimene kuai fun una urinmano kuaikva ijar fuka ma iserkno kuain. ");
INSERT INTO nvm_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Bu ijeg Fairet kuardavga fu una roin kia, Ijekino ni una va mako vien ijin ka mukorigia samuafno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Fairet fu ijeg kuardiamga bun una va e azikeoijo roin karevga bu mako vien ijia ire ameoine ijia samua karin. Bun ijegrene uri mun abe vien bijukurainva ijia anf oine e juo karijo iji kiavga bu mako iji mukorigia samuame karin. ");
INSERT INTO nvm_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Areme afarma Sade suok tavan ik irasemo ijia bara Meri Megdarin ga bara Meri be iji bun una mako gafi gakuai vain. ");
INSERT INTO nvm_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Bu vake mako vien ijia usekoga migegare moik bomana urako E Bomana ijefuon anera fu varur ijia arin. Fu ari kekome mun bomana iji bu abe vien bijuinva iji dab biom iken ijia abedeme azan ijia ajie fin. ");
INSERT INTO nvm_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Regavo uikinik fuon iji fuka varur igeg karame ugon fu sainma iji fuka ma abaren. ");
INSERT INTO nvm_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ijefuon e iji mako vien ijia juo karinva iji bu fu gava buka uruvana dejufdiame simardiamga buka e aoinva igeg tuame moik ijia dijen. ");
INSERT INTO nvm_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Regavo anera iji fu una bara iji kia, Jab juk. Na vierafe ja Jesu e iji bu abe kuros kanainva iji nisaimoij. ");
INSERT INTO nvm_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Regavo e iji igi fu bakin revo e iji fun izeg ur fu kuainma ijeg fun una urinmano ni gufi fu nainma ijin gaf. ");
INSERT INTO nvm_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ja iji gavo nin migegare una va e vuak fuon faivo iji kuardiame kia, Jesu fun una urinmano kiaf. Regavo madu kia, Fun ar Gareri ijia ja biediakafa fun amur vakno kiaf. Regavo vuak igi na kuardiavo iji jab rubdiavo nika mukor vierafefno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Anera iji fu ijeg kuardiamga bara nokarok (2) iji bun mako iji areme bun migegare igia una ar vain. Buka juin gavo bu oimarknum una kukubijame e vuak fuon faivo iji kuardiakuai vain. ");
INSERT INTO nvm_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Bu ijeg una vako ijia Jesu fun migegare una iji bu vako ijia keko biediame anadiain. Fu ijeg anadiamga bu usem fu manino ijia ato same diak fuon niriakiaknum fuon sirimamen. ");
INSERT INTO nvm_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Areme Jesu fun una kia, Jab jukgavo nin oimarknum va uviaifnun iji kia bu Gareri ijia vua na biedievno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Areme bara iji bu vek isuar vakoga e iji mako vien juo karinva roin bun migegare va mai ijia useme e mamkanuk iji Godon isuf baroijo ijin vuak fok fu izegrenma bu giainva iji kuardiain. ");
INSERT INTO nvm_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Areme e mamkanuk Godon isuf baroijo iji bun vuak iji faime uri e mamkanuk roin mai ijia karinva ijiena besum afuime izeg bu rekfuon ijin kuain. Bu kuaime uri mon ka mamkanuk ijeg kara uri e iji bu mako vien iji juo karinva iji kimen. ");
INSERT INTO nvm_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Bu kimene kia, Ja unam gami izeg fu rena ja giainva iji jab abe uruvana kuaim bomana rek. Regavo ja e roin kuardiakva ni kia, No naki nitubaiduoga no ni naoikoga bu e vuak fuon faivo ijieb isuar useme surif fuon iji abe vainvano kiaf. ");
INSERT INTO nvm_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Regavo E Romkobuon Gaman iji fu vuak iji faikma iji nor funa vuak kuaim amarega fuba ja ise kafo rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ijefuon e iji mako vien iji juo karinva iji bun mon iji bu kimenva iji ke e bun e mamkanuk bu kuardiainva ijeg ren. Ijefuon iviakma igi e Jius fok bu Jesu fu una urinma iji bu kuai fu e vuak fuon faivo ijieb isuar ro surif fuon niet abe vainvano kuaimoij. ");
INSERT INTO nvm_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Areme e Jesuon vuak faivo ireven (11) iji bun ai Gareri uruor iji Jesu fu kia ja ijia vua na biediefno kiainma ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bu va ijia useme gak Jesu fun ma una urinma game e roin bu ijia una fuon sirimamen revo e roin bu Jesu fu una urinma iji buka vek ba ma vierafen ijefuon buka nonamin. ");
INSERT INTO nvm_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ijefuon Jesu fu roke iji bu karijo ijia kekome kia, Ire fok varur gufia ga moikigia naoivo iji nar daro nun iji Asoinun fu mienma ijia samuagdiav. ");
INSERT INTO nvm_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","20","Ijefuon uri ar iror igia vuak nun iji abe e fok kuardiame aferdiaga bu una e vuak nun faivo iji rej. Ja aferdiakva ni kege God Asoi ga God Farif ga God Kaven ijiebuon if ijia do ruardiaf. Regavo madu jaka vuak nun fok ja rekfuon na kuardiainva ijin e nijaidiaga bu igiame ijia keof. Regavo igia faif. Naiji naba ja uniakok revo naka tavan bog jana fivake ka tavan radkma ijia kekokno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","2","Vuak igefuon anej ma iji Jesu Kurais fu Godon Farif. Regavo vua fuon iji bun izeg Asaia e iji Godon vuak vierafene kuaimon fu kuainma iji bu ijeg isoi, God fu Farifuon kume, Vuak nun iji faimne kumen. Nar e vuak nun abe oinon be kuaga fu amur unam on iji amarekega a rad vak. ");
INSERT INTO nvm_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Fu va ai moikum namo ijia fine kume, E Bomana iji fu ruakreno jaka fuifuon unam kara mukorigia asu arir amarefno kumen. ");
INSERT INTO nvm_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ijefuon Jon e do ruardiamo fu ai moikum namo ijia oijknum e ijia fuon roko iji kia, Unam ise iji ja kegoijo iji nika arega una oi karoime Godon roga fu ise jon giame arega na ja do ruardiafno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Fu ijeg kuardiaknum reokoga e fok Judia samaij ijia karinva iji abevo e Jerusaremko iji bu Jonon vuak iji faime fuon ruain. Bu ro do Jodan ijia useme ise buon visu God kuardavga Jon fu bu aferdiame do ruardiain. ");
INSERT INTO nvm_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Regavo Jon ugon fu samon iji fu fanuf kamer surif ijia amarenva iji samon. Regavo madar fuon iji fu fanu surif ijia amaren. Regavo duok fu inon iji fu kuamutu ga muni safik iji inon. ");
INSERT INTO nvm_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jon fu vuak nijaidiame kuardiaknum kia, E be fu rad jajie roko iji daro fuon fuka ma darokin revo naiji daro nun iji fuim sibank ukakbe. Ijefuon na fuifuon ik rekfuon iji na vierafe naka ba aresren. ");
INSERT INTO nvm_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ijefuon maiji nam ja do ijesugin ruardiak gavo fur ro Godon Kaven iji uniafdiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Rene tavai besum ijia Jesu fu ar Nasaret areme vake do Jodan ijia kekomga Jon fu uri Jesu abe do ruardain. ");
INSERT INTO nvm_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Fu do ruardame Jesu fu ik do iji areme irif ijia ajie roko ijia ar nairekoga Jesu fu gako ijia daro iji fu e karauniakfuon iji fu fuon ruain. Regavo daro iji fu Godon Kaven ijar um guaf igeg ari Jesun nigen ijia kirem fin. ");
INSERT INTO nvm_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Fu ijegrekoga varur gufia vuak be ijeg kume, Fariknu game na a gavo fuka oimadienmano kumen. ");
INSERT INTO nvm_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Fu ijeg kumekoga tavai besum ijia Godon Kaven ijar Jesu afeme ar e bakin ai moikum namo ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Fu va ijia naki foti (40) ga maza foti (40) ijeg ijia fikoga Setan fu Jesu biesuain. Fu ijegre oinon ijia bu fanu taraikor ijieb funa ijia okoga anera ijieb ari fu ifejdain. ");
INSERT INTO nvm_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ijegreare bu Jon abe dibur unakoga rad Jesu fu ar Gareri ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Fu va ijia kekome e Gareriko iji Godon vuak ma ijin nijaidiame kia, Tavan iji God fu una anerene oijon iji samuagdiakfuon iji fun samairenmano kiain. Ijefuon ise jon ja re oijo iji nika aregavo una oi karoime vuak ma iji ma vierafefno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Areme tavan be Jesu fu do daturaiko nafuinma bu kua Gareri kuavo irif ijia uraoinon ijia fu e kimai savo nokarok (2) no diaikin iji biediain. Bogaf ijefuon if iji Saimon ga diar ijefuon if iji Edru. E nokarok (2) iji bu do iji daturaiko nafuinma ijia kimai saoij. ");
INSERT INTO nvm_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Bu kimai saoijga Jesu fu biediame kia, Ni ire iji ja reoijo iji aregam na jajifno kiain. Ja na jajiekva na kijum iji ja karavo ijeg unam nijaidiaga ja ijeg e aferdiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Fu ijeg kiamga bu migegare ugie buon iji ijia arega uri Jesu jame vain. ");
INSERT INTO nvm_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesu fun buna vako ijia fu samaij ijia madu una no diaikin Jeims ko Jon e Zebedin afijaf ijin giain. Bu vanag buon ijia karine ugie buon iji amarvo ijia fu biediain. ");
INSERT INTO nvm_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesu fu giame uri kumega bu asoibuon Zebedi ga ebuon ikrejo iji bu vanag ijia uniame uri Jesu jame vain. ");
INSERT INTO nvm_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesu fun e vuak fuon faivo ijiena roke ar Kafoniam kuavo ijia usebijain. Regavo afarma tavan Sabat (Satade) iji e bu isuar karijo ijia Jesu fun e Jiusbuon ar iji bu afuim vuak kuaivo ijia arume anerene vuak nijaidiain. ");
INSERT INTO nvm_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Fu vuak nijaidiamga e fok bu vuak fuon iji faivga buka oiserdiain. Ijefuon maiji vuak fuon fu nijaidiamo iji fu e Jius bu vuak akai nijaidiavo ijiebuon vuak ijekin iji fuka bakin. Regavo vuak fuon iji fuka ma darokin nijaidiain. ");
INSERT INTO nvm_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Regavo e be kaven ise niroinma ijar ar ijia aru uruvana igia kume, ");
INSERT INTO nvm_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Jesu e Nasaretko gare a noiji a kege izegrekafa ruain? Akafu a no kege kam arafiruokafa ruain? Regavo aiji a Godon e Akai iji nan vierafenvano kumen. ");
INSERT INTO nvm_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Fu ijeg kumega Jesu fu uri kaven ise iji kuriairene kua, Vuak iji a kuaimon iji arega ibijume kek gareg vakne kuain. ");
INSERT INTO nvm_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jesu fu ijeg kuamga kaven ise iji fun e iji dab uruvana igia simain. Fu dab simaifiriknum uruvana kakurime areme fun e iji areme kek vain. ");
INSERT INTO nvm_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jesu fu ijeg kaven ise iji kiamga e fok buka oiserdiain. Ijefuon bu anerene uri bui kuai, E iji fu e izekido fuka vuak sumakin be abe darokma nijaiduom. Fu ijegrekok kaven ise iji buka ifuon iji faime fu i gavno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jesu fu ijegrega vuak fuon iji fuka migegare ifene vakoga e ar Gareri guf ijia karinva iji buka faim baren. ");
INSERT INTO nvm_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesu fun e Jiusbuon ar bu afuim vuak kuaivo iji areme e Jeims ko Jon aferdia bun Saimon ko Edruk buon ar ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Bu va ijia usevga e iji buka migegare usem Saimonon barak ijefuon asiej fu vajai vuaturime fu adam abe namo iji kuarain. ");
INSERT INTO nvm_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ijegrejga Jesu fun vake bara iji namo ijia kekome idkena fu uriga adam vajai vuaturimo iji fuka ijia barein. Fun barga bara iji fu uri bu samuagdiaknum ire vajiain. ");
INSERT INTO nvm_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Areme tavan nakisrenma ijia e uruvana bun e adagin ijiga e kaven ise ijieb ninarukdiainva ijin aferdia Jesuon ruain. ");
INSERT INTO nvm_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","E ar Kafoniam karinva ijieb e adagin iji aferdia ar vien ijia afuinva fuka ma uruvana. ");
INSERT INTO nvm_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Areme Jesu fun e iji adam kafokafo abenva iji karauniaknum e iji kaven ise ijieb nirokiavo iji uruvana karauniain. Fu ijegreknum kaven ise iji ba unam arediaga bu vuak kafo kuain. Ijefuon maiji kaven ise iji bun Jesu ga vierafen ijefuon bun ibijume usem vain. ");
INSERT INTO nvm_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jesu fun naine suok nakitu ve ba iraskin ijia uri ar iji fu nainma iji arega fun ai e bakin ijia sirimamekafa vain. ");
INSERT INTO nvm_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Fu vakga Saimon ga e vuak fuon faivor iji bun fu nisaime ja ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bu nisaime vake fu bieme uri kua, E uruvana buka a nisaidavno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Bu ijeg kuardavga fu kia, Roga noka ar kafo samaij ijia va. No ijia vainki na e iji vuak nijaidiak ijefuon maiji naiji na ijefuo ruainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ijefuon Jesu fu moik Gareri guf ijia oijknum e Jiusbuon ar bu afuim vuak kuaivo ijia aru vuak nijaidiain. Fu vuak nijaidiaknum kaven ise iji bu e rosdiavo iji kuriairemga bu e iji areme usem vain. ");
INSERT INTO nvm_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jesu fu ijeg vuak nijaidiamoine e be adam kasi igekin bu kua refrosi kuavo iji abenma ijar Jesuon ruain. Fu kekome Jesuon nifak ijia ato same uri soisoime kuain. A vierafega a vajai nun igi amardiega fu una madiekman ni ijegrene kuain. ");
INSERT INTO nvm_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Fu ijeg kuardamga Jesu fu iji faima fuka bomana oifiain ijefuon fu ij fuon akozme e mataigin iji kunain. Fu kunaime kua, Na amardakafie vierafenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Fu ijeg kuardako tavan ijia adam refrosi iji fu bakitemga e iji fu migegare una main. ");
INSERT INTO nvm_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Areme Jesu fun uri vuak gigikin kuardame kua, Ire igi na renva iji ab va e kafo kuardiak. Regavo nin migegare va e Godon isuf baroijo iji vajat on abe nijaidiamne. Areme ni ire kafo kege e Mosison akaij iji fu kuainma ijeg una Godon isuf baroine. A ijegrega e bu ijia game vierafero adam on iji fun barenmaro bu ijeg vierafekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Regavo e iji fu faime fuka vuak iji dab e uruvana kuardiame nijaidiain. E iji fu vuak iji dab uruvana igia kuardiame samafrega Jesu fuba kekome una ar samakaf ijia oijknum vuak nijaidiain. Fu ai e bakin ijia fikoga e uruvana bu ar kafokafo ijia fuon rokga fu vuak nijaidiain. ");
INSERT INTO nvm_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Naki sibank barekoga Jesu fu una madu Kafoniam rokga vuak iji fu ifene vakga e uruvana bu fain. ");
INSERT INTO nvm_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","3","Ijefuon e uruvana bun una vuak faikuai Jesu fino ijia ruain. Bu ro ijia afuime ar fu fino guf ga vien makaf iji buka irtoijen. Regavo Jesu fu ijia mani vuak ma iji nijaidiamo ijia e baru nokarok ga nokarok (4) bu e vajai garenma iji gieme Jesuon ruain. ");
INSERT INTO nvm_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Regavo bu izeg ar guf ijia arume vakva bakin ijefuon maiji ar fun e fok ijieb bijukurain. Ijefuon bu e iji gieme dab ar azan ijia ajieme abe Jesu fu manine vuak kuaimon ijia umaij iji bujain. Bu bujame e iji abe fata ijekma kajek kiriame dab Jesu manino ijia abesen. ");
INSERT INTO nvm_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Bu ijegrejga Jesu fu e iji bu fu ma vierafenva iji giain. Ijefuon fu una dakaroim e vajai garenma iji kua, Fariknu gure ise on iji nan giame oinun ijia dazenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Fu ijegrega Jius e mamkanuk akai nijaidiavo iji bu ijia karinvado bu iji game una buon kuai, ");
INSERT INTO nvm_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","E gari fu irerafuon vua ijeg kuaim? E be moikigia fu erar e kafobuon ise iji giame arekma bakin. Regavo fun Godri fuonkua revo fu irerafuon vua ijeg kufuimene kuaimno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","E iji bu ijeg vierafejga Jesu fun giain. Ijefuon fu uri kia, Ja irerafuon vua kafokafo ijeg karine oijon ijia vierafej? ");
INSERT INTO nvm_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ja vierafe vuak nokarok (2) igi izar fu samakafdo na e vajai garenma guri kuak? Naba kuak eko ise on iji nan game arenvano ni uri vakne kuak vo na kuak nin suf on iji ke datome uri vakne kuakno kiain? ");
INSERT INTO nvm_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Fu ijeg kuardiame kia, Ja naba ma vierafejo ijefuon na nijaidiaga ja ijia game ma vierafek. Ja ijia vierafero Ema ijiebuon Farif igi na daro abedo na moikigia ebuon ise iji na giame arevro ja ijeg vierafekno kiain? Fu ijeg kuardiame uri e vajai garenma iji kua, Ni uri suf on iji kara tuame ar vakne kuain. ");
INSERT INTO nvm_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Areme e uruvana bu vek ijia ireme nikajakoga e iji vajai garenma iji fun migegare uri suf fuon ke datome fun vain. Fu vakoga e fok bu iji gavga buka oiserdiamga bu una Godon oimaren. Bu oimarknum buon kuai, Ire iji fu renma iji fuka ma sumakin gavo madu ire ijekin kafo ur noka ba giainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesu fun ijegreare fun una Gareri do daturaiko nafuinma irif ijia vain. Fu ijia vakoga e uruvana bu fu jame ijia vakga fu vuak nijaidiain. ");
INSERT INTO nvm_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Fu vuak nijaidiame fun do irif ijia amedakiem vako ijia fu e Arfiason farif Rivai iji bien. Regavo Rivain ik iji fu takes abeoinon ijefuon fu ar fuon fu ikreno ijia figa fu iji bien. Fu biem kua, Ni uri na jajiemne kuamga Rivai fu uri Jesu jame vain. ");
INSERT INTO nvm_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Regavo tavan besum ijia Jesu fun una Rivain ar ijia fusik duok ikafa vain. Fu vakoga e takes abeoijo ijiga e ise reoijo uruvana bun fu jame ijia vain. Bun va fata ijia ari karine Jesuga e vuak fuon faivo ijiena besum duok in. ");
INSERT INTO nvm_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bu duok iko ijia e Ferisis roin vuak akai nijaidiavo iji bu ijia buna karine duok ij. Ijefuon bu uri e iji Jesuon vuak faivo iji kia, E jon bomana iji fu irerafuon e guri ise reoijo ijiga e takes abeoijo ijiena duok ino kiain? ");
INSERT INTO nvm_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Bu ijeg kuaivga Jesu fun giame uri vua be ijeg bijame kuardiain. Fu kia, E iji adam abenva ijieb bu e adam giavo iji vierafev. Regavo e iji buba adam abejo iji buba e adam giavo iji vierafekno kiain. Ijegvo na ruainva iji na e iji bu mareoijo ijiebuon ruainva bakin revo na e iji bu ise reoijo iji karauniakro ruainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Areme tavan be e Jonon vuak faivo ijigam e Ferisis iji bu duok karoin. Bu duok karovga e kafo bu ro usem Jesu kua, E Jonon vuak faivo ijiga e Ferisis bu duok karov. Regavo e vuak on faivo iji bu irerafuon ba duok karovno kuain? ");
INSERT INTO nvm_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","20","Bu ijeg kuardavga Jesu fu una vuak be ijeg bijame kuardiain. Fu kia, Tavan iji barubara bu sanamikuai duok ijo ijia e baru iji fu ijia fike bu e ruainva iji kia bu duok karome karine una oifiaigma vakva bakin. Regavo buka oimarknum karine besum duok ik. Regavo vake son rad baru iji fu bara iji afeme ai be vakma e iji bu ijiason buifuon oifian abe duok karok. Unam besum ijegvo naiji na e iji fu bara abekreno igekin. Ijefuon e vuak nun faivo iji bu na vek igia buna oijo iji no besum oimarknum duok ij. Regavo tavan rad e ani nun bu na aferdieme kanie na guakva ijia bu nuifuon oifian abe duok karokno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Fu ijeg kuardiame uri vuak be bu izeg e Ferisis ijiebuon unam usuikor ijiga unam fuon iviamkor iji buba kege besum mazikfuon ijefuon bijame kuardiain. Fu kia, E be fu erar ugon fuon usuikor fu bujaga fu una ugon iviamkor buin abe ijia abedeme sigukma bakin. Regavo fu ijegrekma ugon iviamkor ijar usuikor iji dab jijukman fuka bomana bujak. ");
INSERT INTO nvm_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Unam besum ijegrevo fu e be erar vuain iviamkor iji abe una kamuij usuikor iji bu fanuf surif ijia amarenva ijia usekma bakin. Regavo fu ijegrekma iji kamuij usuikor iji fuka sisuikene bujaga vuain iviamkor iji fu usek. Bu ijegrekva ire nokarok (2) iji buka iserek. Ijefuon bu vuain iviamkor iji buka kege una kamuij iviamkor ijia usega ire nokarok (2) iji buka markno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Areme tavan Sabat (Satade) iji e Jius bu isuar karijo ijia Jesu fu e vuak fuon faivo ijiena juar bu vuit ire rais igekin iji oinva ijia urame oin. Bu va ijia oijo ijia e vuak fuon faivo ijieb uri ire vuit garin iji kafo tuame imut tat ijia dakumume surif iji fuas korevknum ioin. ");
INSERT INTO nvm_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Bu ijegreoijga e Ferisis iji bu giame uri Jesu kua, E vuak on faivo iji bu irerafuon akai nuvuon abe tuaseme tavan Sabat (Satade) iji no isuar karijo ijia vuit iji tuame ijno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Bu ijeg kuardavga Jesu fu una kia, Regavo ja tavan iji Devid fu efuon ijiena vasiaordiamga bu duok ikuai vierafenva iji jabe dame gain? Bu tavan iji e Abiata fu vek Godon isuf baroinon ijia Devid fu vasiaguamga fu Godon ar ijia arume vain. Fu ijia arume bred iji Abiata fu Godon isuf baroinma iji fuka ire akai regavo e Devid fu iji abe iga efuon iji vajiainma iji jan vierafenvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Fu ijeg kuardiame uri e Ferisis iji kia, Tavan Sabat (Satade) iji ja isuar karijo iji Jesu nar amaren. Ijefuon na koiknun na aresredo na tavan ijia e kiaga bu ire kafo rekva iji fu marek. ");
INSERT INTO nvm_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ijefuon Ema ijiebuon Farif igi naiji na tavan Sabat (Satade) iji e bu isuar karijo ijefuon E Bomana ijino kiain. ");
INSERT INTO nvm_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ijegreare tavan be Jesu fu madu una e Jiusbuon ar bu afuime vua kuaivo ijia arume vaga e imut abe kirainma iji fu ijia fin. ");
INSERT INTO nvm_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Regavo e roin ijia karinva iji buka Jesu nikajain. Bu vierafe buka nikajaoga fu tavan Sabat (Satade) iji e bu isuar karijo ijia e iji imut abe kirainma be keunaga bu abe kotrekuai vierafen. ");
INSERT INTO nvm_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Bu ijeg vierafene karinva ijia Jesu fu e iji imut abe kirainma iji kua, uri igia rokne kuain. ");
INSERT INTO nvm_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Areme Jesu fun uri e ijia karijo iji kia, Tavan Sabat (Satade) akaij iji no isuar karijo ijia e ijekin iji no kege izeg rek? Nobe bu ifejdiak vo no buon ise rek? Regavo madu nobe kaniak vo no bu karauniakno kiain? Fu ijeg kuardiamga e iji buba una vua kafo kuardain revo bum isuar igia katibitene karin. ");
INSERT INTO nvm_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesu fu uri e iji giama fuka deajin. Regavo madu fu giamga oibuon iji buka gigikin ijefuon fuka bomana oifiain. Ijegreare fun uri e iji imut abe kirainma iji kuama fu imut akozemga imut fuon fu una maren. ");
INSERT INTO nvm_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Fu ijegrega e Ferisis iji bu iji game bun ar iji bu afuim vuak kuaivo iji areme usem e iji bu Erodon vuak faivo ijiena izeg bu Jesu kanakfuon iji kuaime ujuinamin. ");
INSERT INTO nvm_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ijegrene Jesu fun uri e vuak fuon faivo ijiena fun una do daturaiko nafuinma ijia vakoga e Gareriko ka ma uruvana bu uri bu jajia vain. ");
INSERT INTO nvm_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Regavo madu buka e uruvana ar kafokafo ijia karioinva iji bukmadu ijia ruain. Bu e ar Judia ga mai Jerusarem ga Aidumia guf ijia karioinva ijieb ruain. Regavo madu e kafo buk do Jodan ruvainma gara karioinva ijigam e ar Taia ga Saidon ijia karioinva ijieb uri ruain. Ijefuon maiji bu irerag Jesu fu reoino iji fainva ijefuon bu ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Buka e uruvana rokga Jesu fu uri e vuak fuon faivo iji kiamga bu sisim ukakbe fuifuon abe ruain. Buka e uruvana afuime fu dab utikurakrejga fu ijia ajieme vuak kuardiakafa kiamga bu abe ruain. ");
INSERT INTO nvm_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ijefuon maiji fun amur e uruvana karauniainma ijefuon e roin adam abenva iji buka fu kunaimgakuai vierafen. ");
INSERT INTO nvm_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Regavo kaven ise iji rosdiainva ijieb Jesu gavo iji buka uri e iji kam rosdiame Jesu manino ijia ato sav. Bu ato same biumame kume, Aiji anka ma Godon farifno kumej. ");
INSERT INTO nvm_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Bu ijeg kumejga Jesu fu uri kaven ise iji kuriairene kia, Ja if nun jab abe samafrekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","15","Ijegreare Jesu fun uruor ijia ajie va kekome uri e fu vierafenma iji kumega bu fuon ruain. Bu ijia fuon rokga Jesu fu e tuer (12) imut bijiame kia, Jaiji ja e afasor nun rek. Na ijeg ifdiaga ja nana oijknum vua nun abe e kuardiak. Regavo madu na daro miaga ja e iji kaven ise rosdiainva iji kiaga bu e iji areme usem vakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","17","Regavo e iji fu imut bijiame kenma ijiebuon if iji ijeg e Saimon e iji Jesu fu una Fita kuainma ijin. Regavo e Jeims ga Jon e Zebedion afijaf ijin. (Regavo madu Jesur una ifdiafe kia Boanegis kiainma ijin. Regavo if ijefuon ma iji e varur igeg kumejo ijin). ");
INSERT INTO nvm_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Regavo be iji Edru ga be iji Firif ga be iji Batoromiu ga be iji Metiu ga be iji Tomas ga Jeims e Afiason farif ijin. Regavo be iji Tadias ga Saimon e iji fu e mamkanuk ijiena vua gigikin kuaimon iji rega be iji Judas Iskariot e iji Jesu abe e ani miamga bu kanainva ijin ken. ");
INSERT INTO nvm_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ijegreare Jesu fun una ai be ijia ajie vakga e fok bu madu usem ijia afuin. Ijefuon Jesu ga e vuak fuon faivo iji bu duok ikrega fuka tavan bakin. ");
INSERT INTO nvm_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Regavo e roin bu kuai Jesu fu nigen iserenma kuaivo ijefuon aganfuon bu vuak iji faime Jesu afekuaim ruain. ");
INSERT INTO nvm_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Regavo e vuak akai nijaidiavo roin bu Jerusarem ijia ruainva ijieb kuai Jesu fu kaven ise Setan bu kua Birzibubno kuavo ijar oifuon ijia arinmano kuain. Regavo e roin bu kuai fu kaven ise ijiebuon e bomana Setanri daro maga fu kaven ise iji kiaga bu usem vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Bu ijeg kuavga Jesu fu vuak iji faime e iji kumega bu rokga fu uri vuak be ijeg bijame kuardiain. Fu kia, Kaven ise Setan fuba koikfuon una fuon nisarenamikno kiain? ");
INSERT INTO nvm_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","25","Fu ijeg kuardiame uri madu kia, Ai be fu uri una ata roinroin rene una buon bijaikva fu tavan jiamanak ijia na vakma bakin. Ijefuon madu e agan be bu uri ata roinroin rene una buon musikuaiknum karivakva bu tavan jiamanak kari vakva bakin. ");
INSERT INTO nvm_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ijegvo Setanon e iji fu samuagdiamo iji bu uri buon ata roinroin rene bijaikva buba tavan jiamanak karikva bakin. Regavo buka migegare darobitedia barek. ");
INSERT INTO nvm_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Regavo madu e darokin ijefuon ar iji fu erar bujame aru sinuom fuon niesame karekma bakin. Regavo fuka amur e darokin iji kunaim tome rad fu son sinuom fuon niesak. ");
INSERT INTO nvm_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Regavo vuak igi naka ma kuardiav. Ema igiebuon ise iji ga vuak ise uruvana bu kuaimoijo iji God fu giame arekfuon. ");
INSERT INTO nvm_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Regavo erar fu Godon Kaven Akai iji fuisina vuak ise kafo kuaikma God fuba ga arek. Ijefuon maiji ise ijekin fu renma iji fu tavan uruvana ijia navakfuon. ");
INSERT INTO nvm_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesu vuak iji fu kuainma iji bu e roinb kuai fu kaven ise ijar oifuon ijia arinmano kuaivo ijefuon fu iji kuardiain. ");
INSERT INTO nvm_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesu fu vek vuak iji kuardiamo ijia asiefuon ijiga uviaifijaf bu ijia usen. Bu ro makaf ijia useme irega e be kuavga fu arume Jesu kuakafa vain. ");
INSERT INTO nvm_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Regavo buka e fok ijieb dab kirakura ameoine fu uf ijia manino ijia bu arume kua, Asieon ijiga uviaifon bu a nisaime ro makaf gufa irenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Bu ijeg kuavga Jesu fu una kia, Asienun ijiga uviaifnun iji eranebno kiain? ");
INSERT INTO nvm_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Areme fu uri e ijia karinva iji giaoine kia, Asienun ijiga uviaifnun iji bu iga nana karin. ");
INSERT INTO nvm_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ijefuon maiji erar fu irerag fok Asoinu fu vierafenma ijia kegoino e ijar fu uviainun ga makinun ga asienuno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Areme Jesu fu una madu do Gareri daturaiko nafuinma irif ijia anerene vuak nijaidiain. Fu ijia vuak nijaidiakoga e ka ma uruvana bu una ijia fu dab kirakurain. Ijefuon fu uri vanag ijia ajie biom do azan ijia fikoga e fok ruainva iji bu do irif ijia iren. ");
INSERT INTO nvm_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","4","Bu ijia karikoga fu uri vuak fok fuka ke bijame nijaidiain. Fu vuak nijaidiame kia, Igia faif. Tavan be e be fun va uij dajaiko uij roin bu uduime unam iji e bu oijo ijia ariva bun um ijieb arime kare in. ");
INSERT INTO nvm_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Regavo roin bu uduime munuag azan ijia arime buka tavuan revo gireg buon iji buba uruvana sain. Ijefuon maiji sakin ma iji fu ukakbe ijefuon bu tavua ajievga fun tavan kek kaniamga buka sairen. ");
INSERT INTO nvm_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Regavo uij roin bu ufien gurogin uf ijia arivga fu ufien ijar name raremga buba sunin kirain. ");
INSERT INTO nvm_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Regavo roin bu sakin ma ijia ari tavuame sunin kirain. Regavo sunin bu kirainva iji roin bu sunin siban (30) ijeg kirain revo roin bu igeg sibank uruvana (60) ijeg kirain revo roin buka ma uruvana (100) ijeg kirain. ");
INSERT INTO nvm_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Fu ijeg kuardiame kia, Ja adakikva ni vuak igi na kuardiavo iji mukor faifno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Areme tavan be Jesu fu fuonkua fino ijia e roin vuak iji faivo ijieb e vuak fuon faivo ijiena fuon ruain. Bu useme Jesu kuai, Nin vuak iji a bijame kuarduinma ijefuon maiji visume samakaf kuarduomne kuain. ");
INSERT INTO nvm_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Bu ijeg kuardavga Jesu fu una kia, Na unam sauivkin God fu izeg efuon ijiebuon oij iji samuagdiamo iji nan e iji ja na jajievo iji kuardiame nijaidiain. Regavo e iji buba na jajievo iji vuak iji na ke bijame kuardiak. ");
INSERT INTO nvm_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Na ijeg bijame kuardiaikin vuak irerag e Asaia fu kuainma iji fu ijekma aresrek. Regavo vuak iji fu kuainma iji bu ijeg isoi, Bu vuak ijefuon ma iji nisaik revo buba ma iji gak. Regavo madu bu tavan uruvana vuak iji kukma faik revo buba amarigia faim vierafek. Regavo bu vuak iji amarigia faim vierafebatie bu ise buon ijia oi karoiga God fu ise buon giame arekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesu fu ijeg kuardiame kia, Ja vuak igi na bijame kuardiavo iji jaba amarigia faikva ja izeg una vuak kafo bu ijeg bijame kuainva iji mukor faime vierafek. ");
INSERT INTO nvm_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Vuak na bijame kuardiavo ijefuon ma iji igin. E iji uij dajainma iji fu e iji Godon vuak abe e kafo kuardiamo ijekin ijin. ");
INSERT INTO nvm_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Regavo e roin bu uij iji bu uduime unam ijia arinva ijekin. Bu vuak nun faiv revo Setanri migegare ro vuak nun bu faime abe oibuon ijia abedevo iji fu kare vak. ");
INSERT INTO nvm_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Regavo uij roin bu uduime munuag azan sakin ukakbe namo ijia arinva iji e iji bu oimarvknum vuak iji migegare faivo ijin. Bu vuak iji migegare faiv revo buba abe oibuon ijia gigikin vierafej. Ijefuon bu Godon vua iji abe oibuon ijia abedeme oijo ijia e kafob ise kafo buon rejknum kam unam ise ijia arafiriaga bu vajai fian abejo ijia buon ma vierafejo iji buka migegare ijia arevo ijin. ");
INSERT INTO nvm_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Regavo uij roin bu uduime gurogin uf ijia ariva ufien ijieb okuriainma iji e iji bu vua ma iji faivknum vo una izeg bu moikigia oimarvknum kareokfuon iji vierafejo ijin. Bu ijegrejknum buka sinuom ga mon uruvana oijmiaknum ire kafokafo uruvana vierafejo ijar vua ma iji bu fainva iji buka rubdiav. Ijefuon vua ma iji bu fainva iji fu oibuon ijia tavuame ajie sunin kiramo bakin. ");
INSERT INTO nvm_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Regavo uij iji sakin ma ijia arinva iji bu e iji vua nun iji faime amarigia abejo ijin. E ijieb vuak ma iji fu oibuon ijia tavuame sunin kirain. Roin bu sibank abeko roin bu sibank uruvana abekoga roin buka ma uruvana abejo ijino kiain. ");
INSERT INTO nvm_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Fu ijeg kuardiame madu uri kia, Fu e be erar rait fuon abe datome ar fuon guf fata rotit ijia sauim abedekma bakin. Regavo fuka abe ar fuon guf kaf ijia kira abesga fu ai guf fok sana barek. ");
INSERT INTO nvm_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ire iji sauim naoivo iji buson rad samafrega bu giakfuon. Ijegvo vuak nun iji fu ijekin. Ijefuon vuak irerag na bijame kuardiavo iji anej ma iji buson faikfuon. ");
INSERT INTO nvm_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ijefuon ja adakiga ni vuak igi mukor faifno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesu fu ijeg kuardiame kia, Vuak igi na kuardiakrejo iji amarigia vierafef. Erar fu ada amarigia irame Godon vuak iji faimo e ijar fu amarigia faime vierafekfuon. Regavo Godri madu una vua maiji kafo madu nijaidiak. ");
INSERT INTO nvm_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Regavo e iji erar fu Godon vuak iji amarigia faime ke mimataoino e iji God fu una madu ifejdaga fu vuak fuon ma iji kafo madu vierafeken. Regavo e iji erar fu Godon vuak iji fuba oimarvknum faim vo fum sibank faimo iji God fu una vuak fuon ma iji oifuon ijia naoivo iji fu kamazakfuon. ");
INSERT INTO nvm_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesu fu ijeg kuardiame madu kia, Unam izeg God fu efuon ijiebuon oij iji fu samuagdiamo iji fu e iji fu juar fuon ijia uij dajainma ijekin. ");
INSERT INTO nvm_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","E iji fu uij dajaime tavan bog nakikmazak fu nai urino iji fu uij bu tavuame ajie vo bu izegrejo iji fuka ba vierafen. ");
INSERT INTO nvm_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Fu va fiokoga uij bum koikbuon ijia tavuame ajie kiak atame sunin kirain. ");
INSERT INTO nvm_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Bun kira vake i sunin fok buka duime barekoga e juar koikin iji fun i sunin fok turame kanafuikafa ruain. Ijefuon maiji tavan iji fun juar masivo ijefuon tavan ijino kiain. ");
INSERT INTO nvm_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesu fu ijeg kuardiame kia, Unam izeg God fu efuon ijiebuon oij iji fu samuagdiamo iji fu izekin iji no izeg kuaik? Regavo madu no abe irerag ijia bijame kuaiga fu samafrediak? ");
INSERT INTO nvm_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Igia faif. Unam izeg God fu efuon ijiebuon oij iji fu samuagdiamo iji fu uij ka ukakbe in sira sunin fu rekfuon igekin. E be fu i sunin ukak iji abe juar ijia oga tavan sibank barko fuka tavuame bomana ren. Fu bomana rene kiak fuon mamkanuk atame ire fok juar ijia oinva iji fuka asidiamga um bu ijia nait abejo ijekino kiain. ");
INSERT INTO nvm_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesu fu vuak ijefkin kafo madu ke bijame kuardiako bu vuak iji faime vake buka aresrega fu ijia aren. ");
INSERT INTO nvm_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Regavo vua fuon fok fu e iji kuardiainma iji fuka ke bijame kuardiain. Regavo vuak ijefuon anej ma iji fu fuonkua e vuak fuon faivo ijiena fioinma ijia kuardiain. ");
INSERT INTO nvm_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Areme tavan besum iji nakifuon ijia Jesu fu uri e vuak fuon faivo iji kia, Roga no do vajame gara vakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ijefuon e vuak fuon faivo iji bun uri e fok ijia areme Jesu afeme funa vanag ajieme bun vain. Regavo madu vanag kafo bu madu buna vain. ");
INSERT INTO nvm_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bu vako ijia buibur ka ma darokin ijar ufikoga saof iji fuka foine vanag ijia arin. Fu foine ijia arikok vanag iji fuka irtoijekafa ren. ");
INSERT INTO nvm_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Regavo Jesu fu vanag nuon ijia anum abe nigen abedeme fun ninain. Fu ninaiko e vuak fuon faivo iji bu uri same kua, E Bomana noka oifian abe do urame aoikrejo abe guome ifejduokafa vierafenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Bu ijeg kuavga Jesu fu uri buibur iji biju vo uri saof iji foinon iji kua, Sibano ni areme isuar namne kuain. Fu ijeg kuamga buibur iji fu bakite vako saof fu una isuar katibitene una fu nainma ijeg nain. ");
INSERT INTO nvm_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Fu isuar namga Jesu fu una dakaroim e vua fuon faivo iji kia, Ja izegrekuai juv? Ja God jabe ma vierafen vo ja bano kiain? ");
INSERT INTO nvm_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Fu ijeg kiamga buka bomana dejufdiainma ijefuon bu uri kua, E iji kafu erar? E iji noka ba vierafenva ijar buibur guri ga saof guri kiamga buka vuak fuon faime arenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Areme bun vanag abe vake do Gareri gara ar e Gerasako karinva ijia usen. ");
INSERT INTO nvm_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Bu vake ijia useme Jesu fun vanag iji areme ajie roko ijia e be kaven ise ijieb dab rosemokok fu mun tit iji bu e aoiga bu ke uniavo ijia naioino ijar kaven ise ijiena usem Jesuon ruain. Regavo e iji fuka e ise e darokin ijefuon bu izeg fu kunaime sen kam tokva bakin. ");
INSERT INTO nvm_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","E buka tavan bog sen kam diak fuon ijiga imut iji kam tovo iji fuka giriesame kam turasega bu uduim arivo. Regavo fu erar daro mene fu kunaikma bakin ijefuon bu ijia arev. ");
INSERT INTO nvm_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ijefuon nakikmazak fu mun tit ijia ga uruor ijia biumavknum koikfuon vajai fuon dab mun ijia kania buaseko fuka kavuanariko fu ijia oino. ");
INSERT INTO nvm_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","7","Fu ijia oine Jesu fu vakga fu aibe gafia manine game kukum roke ijia kekoin. Fu kekome Jesu ato same uruvana biumame kua, Jesu God E Bomana kaf gufia fino ijefuon Farif gure a irerag iji nun rekro vierafen? Ni Godon if ijia kuraga na vierafero a na aba abe arafiriekro na ijeg vierafekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Fu ijeg kuainma ijefuon maiji Jesur kaven ise iji kua e iji areme keko vakne kuainma ijefuon fu iji ijeg kuardain. ");
INSERT INTO nvm_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Fu ijeg kuamga Jesu fu kua, Regavo if on iji erano kuain? Jesu fu ijeg kuamga e iji fu una roin kua, Na if nuvuon bu kuo Uruvanano kuovo ijefuon maiji noka kaven uruvana oifuon guf ijia karinvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Fu ijeg kuardame una madu Jesu soisoime kua, Ab kuoga no ar igi no karijo iji areme usem ai be vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Regavo uruor samaij ijia maf uruvana bu ijia ireme duok ioij. ");
INSERT INTO nvm_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ijefuon kaven ise iji bu maf ijiebuon oij ijia arikuaim vierafene uri Jesu soisoime kua, E-e ni kuoga no useme maf gariebuon oij ijia arivno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Bu ijeg kuavga fu kia, Ni ijegrefno kiamga kaven ise iji bu e iji areme usem una maf ijiebuon oij ijia arin. Regavo maf buka ma uruvana tu taosen (2,000) ijeg. Ijefuon bu usem subinai uruor igegamekin ijia arime do urame aoin. ");
INSERT INTO nvm_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bu ijegrejga e iji maf samuagdiamo iji bu giame usem subinai e iji bu juar mene samuagdia karijo ijigam e iji mai guf ijia karioinva ijin vuak iji dab kuardiame vain. Bu ijeg kuardia vakoga e iji bu vuak iji faime usem Jesu ire iji fu renma iji gakuai ruain. ");
INSERT INTO nvm_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bu useme e iji kaven ise ijieb fu dab niroimoijo iji gain. Bu ga fu ire iji fu reoinon iji fun dasume dab akozga una e ma rene ugon fuon same fina bu gava buka dejufdiain. ");
INSERT INTO nvm_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Areme e iji bu ire iji kaven ise iji ga maf ijiebuon renma iji giainva ijieb una e iji ruainva iji kuardiain. ");
INSERT INTO nvm_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Bu kuardiavga e iji ijia ruainva iji bu vuak iji faime uri Jesu dab kuakuavknum kua, Nika ar nuvuon igi areme vakne kuain. ");
INSERT INTO nvm_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Bu ijeg kuavga Jesu fun una vanag ajiekrega e iji kaven ise ijieb dab niroimoijo iji fu kekome Jesu kua, Nabe osik vakno kuain? ");
INSERT INTO nvm_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Fu ijeg kuamga Jesu fu faime kua, Ni una ar on ijia va irerag E Bomana fu on renma iji aganon iji kuardiamne. Regavo madu izeg E Bomana fu on oifian abene ifejdainma ijin kuardiamne kuain. ");
INSERT INTO nvm_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jesu fu ijeg kuardamga e iji fun una va ai Dikaforis ijia oijknum irerag Jesu fu fuon renma iji kuardiaoin. Fu ijeg kuardiafga e fok bu vuak fuon faiva buka oiserdiain. ");
INSERT INTO nvm_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Areme Jesu fun sisim abe una do daturaiko nafuinma iji gara vain. Regavo do gara ijia bu e uruvana fu samuame afuim karinva fu vake ijia kekomga bu usem dab kirakurain. ");
INSERT INTO nvm_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Regavo e iji ar bu afuime vuak kuaivo ijefuon e bomana if fuon Jairas fuk fu ijia ruain. Fu ijia ruainmado fu kek Jesu game uri fu manino ijia ato same uri Jesu kua, Kabainun fuka guakafaren. Ijefuon e-e ni ro imut nigen abedega adam fuon fu barga fu una uri oino kuain. ");
INSERT INTO nvm_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Fu ijeg kuamga Jesu fun fusik vain. Regavo buka e uruvana Jesuna vako ijefuon buka buon ajiefirainamiknum vain. ");
INSERT INTO nvm_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Regavo bara be buna vako iji fu ise fi ruako fuka juaivasia tuer (12) ijeg baren. Regavo kavuan fu arimo iji fuba baren. ");
INSERT INTO nvm_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Fu juaivasia uruvana fuka oifian abe va e mamkanuk adam giavo iji giame mon fuon fok karme kimega bu ifejdain. Bu ifejdavo iji adam fuon fuba maim revo fuka una ma bomana ren. ");
INSERT INTO nvm_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Barak ijar Jesuon vuak iji faime fu e fok roko ijia jajiame Jesuon ugon fu sainma iji niriain. ");
INSERT INTO nvm_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Fu vierafero fu ugon iji niriakma fu maikro fu ijefuon ijfuon akozme Jesuon ugon buin ijia kunain. ");
INSERT INTO nvm_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Fu ugon fuon ijia kunaimga kavuan fu arimo iji fuka migegare bakren. Bara iji fu koikfuon vajai fuon ijia faik adam ijigam iji fu oifian abeno iji fuka barema fu fain. ");
INSERT INTO nvm_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Fu ijegreko ijia Jesu fuk fun faik daro fuon kafo bun useva fu fain. Fu faime una dakaroime e fok bu jame vako iji kia, Erar ugon nun igia kunainmano kiain? ");
INSERT INTO nvm_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Fu ijeg kiamga e vuak fuon faivo iji bu uri una roin kua, Igia gamne buka e uruvana a dab kirakurakoga a ijia kia erar ugon nun kunainmano kiam. ");
INSERT INTO nvm_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Regavo Jesu fuka e iji erar fu ugon fuon kunainma iji gakafa nisain. ");
INSERT INTO nvm_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Regavo bara iji fu vierafega fun fur Jesuon ugon iji niriain. Ijefuon fuka bomana juvknum va Jesu ato same irerag fu renma fok visume kuardain. ");
INSERT INTO nvm_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Fu ijeg kuardamga Jesu fu una kua, Kabainu on a ma vierafenma ijar adam on iji fu keunain. Ijefuon adam on a abeno iji fun madainmano ni va mukorigia fioine kuain. ");
INSERT INTO nvm_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesu fu vek vuak iji bara iji kuardamo ijia e kafo bu e Jairason ar ijia ruainva ijieb useme Jairas kua, Kabaion fun guain ijefuon e guri E Nijaidiamo iji a afekro vierafeno iji aremne kuain. ");
INSERT INTO nvm_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Bu ijeg kuavga Jesu fu vuak buon fum faim dazga una Jairas kua, Ab vuak ijar oifiadagavo nin ma vierafemne kuain. ");
INSERT INTO nvm_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Areme Jesu fun uri Fita ga Jeims ga Jon e Jeimson uviai iji aferdiame funa vaga e roin fu kiamga bu ijia aren. ");
INSERT INTO nvm_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","39","Bun vake Jairason ar ijia usem giak e uruvana buka uruvana igia niraime iseknevknum biumaoij. Bu ijegreoijga Jesu fu na ar guf ijia aru manine kia, Ja irerafuon oifian abe niraiv. Am igi fuba guain revo fum ninainmano kiain. ");
INSERT INTO nvm_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Fu ijeg kiamga bun uri fu dab anu baroine kijdain. Bu dab kijdavga fu uri e fok kuriairemga bu usem vakoga fu am ijefuon asie ijiga asoij iji ga e vuak fuon faivo nokbek (3) iji aferdiame ar guf bara ukak fu namo ijia aru vain. ");
INSERT INTO nvm_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Bun aru irekoga Jesu fun bara iji imut kene isama fuon ijia kua, Tarita kumino kuain. (Regavo vuak ijefuon ma iji bara ukak igi nar kuavo ni una urimne.) ");
INSERT INTO nvm_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Fu ijeg kuamga bara ukak iji fu uri ar guf ijia oin. Regavo bara ukak iji juaivasia fuon tuer (12) ijeg. Jesu fu bara iji keunamga e uruvana bu iji gavga buka bomana oiserdiain. ");
INSERT INTO nvm_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Fu ijegreare uri kuriaireme kia, Jab irerag igi na renva iji e roin kuardiakno kiain. Areme fu madu uri kiamga bu ire kafo kege bara ukak iji vajavga fu kege in. ");
INSERT INTO nvm_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ijegreare Jesu fun ar iji areme una uri ar fuon ijia vakoga e vuak fuon faivo iji bu uri funa vain. ");
INSERT INTO nvm_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Bun va Nasaret useme bun tavan Sabat (Satade) iji e bu isuar karijo iji rokga Jesu fun e Jiusbuon ar bu afuime vuak kuaivo ijia arume vuak nijaidiain. Regavo buka e fok ijia karine vuak fuon faiv ijefuon buka oiserdiamga bu uri kua, E iji fu erar vuak iji nijainvo vierafe vajam? Regavo madu fu izia iji kege kuaimoijknum ire sumakin kafokafo iji reoinon kuain? ");
INSERT INTO nvm_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Regavo madu bu kuai, E iji fum e be ar samon ijin revo madu fu barak Merion farif ijin. Regavo uviaifijaf iji e Jeims ga Josof ga Judas ga e Saimon ijin. Regavo madu makifijaf bun igia karijo iji non vierafenvano kuain. Bu ijeg kuaime vierafega buka jufdiamga bu ijefuon fu uzain. ");
INSERT INTO nvm_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Bu fu uzavga Jesu fu uri kia, E Godon vuak vierafene e kuardiamo ijefuon vuak iji bu e ar roib faime ma vierafev. Regavo una aganfuon ma iji buba vuak fuon ma vierafekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Fu ijeg kuardiame vo fuba una ijia ire sumakin kafo ren. Regavo fum e sibank adam abenva iji imut nigen namdiame karauniain. ");
INSERT INTO nvm_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Fu e roin karauniain revo e fok buka vek ba fu ma vierafejga fu iji giamo fuka bomana oiseren. Areme Jesu fun uri ar ukaknak besubesum ijia oijknum vuak nijaidiaoin. ");
INSERT INTO nvm_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Fu ijia vuak nijaidiaoino ijia fu e tuer (12) vuak fuon faivo iji kumega bu fuon ruain. Bu fuon ruainki fu daro miaga bu e iji kaven ise ijieb rosdiainva iji kuriairega bu usem vakuai bu iji ruain. Bu rokga fun uri kia, Ja e nokarok (2) ga nokarok (2) ijeg mazime use vakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Fu ijeg kuardiame madu uri vuak kafo nijaidiame kia, Ja ire uruvana jab kege ok. Regavo nin tamag jon ke same vo guduar jon ke kuniaime vakgavo jab bred ga kamui ga mon ga set kafo keme vak. ");
INSERT INTO nvm_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Regavo ja mai be ijia vaga e be fu ja aferdiakma ni ar fuon ijesugin karine tavan iji ja vako ijia areme vaf. ");
INSERT INTO nvm_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Regavo ja ar guf ijia oga e buba ja oimardiame aferdiakva ni mai iji areme vaf. Regavo madu ni uri diak surif jon iji azome kuotuvat iji kaniaseme ni ar iji areme vaf. Ja ijegrenki e mai ijia karinva bu giame vierafero ja bu jan mukor magiainvaro bu ijeg vierafekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Areme bu usem oijknum vuak iji e bu ise buon ijia oi karoime una God ma vierafekfuon ijin abe kuardiaoin. ");
INSERT INTO nvm_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bu kuardiaoijknum kaven ise iji kuriaireme nisarerdiaga bu e iji areme usem vaknum e iji adam abejo iji safi nameriaknum karauniaknum ijeg reoin. ");
INSERT INTO nvm_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Regavo Kin Erod fu vuak irerag fok Jesu fu reoinon iji fun fain. Ijefuon maiji irerag Jesu fu reoinon iji e fok bun faime if fuon bun abe ma vierafen. Regavo e roin bu kuai, Fu e Jon e iji e do ruardiamo iji guainma ijar una urinman ijefuon fu daro abene ire sumakin iji reoinon kuain. ");
INSERT INTO nvm_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Regavo e roin bu kuai, Fu e Eraijarno kuain. Regavo e roin bu kuai, Fu e iji usuibe Godon vuak vierafene kuaimoinva ijekin kafono kuain. ");
INSERT INTO nvm_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Regavo Erod fu vuak iji faime fu kuai, E iji fu e Jon e iji na abe uro ufuinva fu guainma ijar una urinmano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Regavo iji fu ijeg kuardiainma ijefuon maiji fu Erodri amur kiamga bu Jon kunaim tom afem dab dibur unain. Ijefuon maiji fu uviaifuon Firifon barak Erodias abega Jon fu kua, Aka isenma renmano kuamga fu ijefuon dab dibur unain. Fu kuardame kua, Unam iji a una uviaion ijefuon barak iji abenma iji aka akai tuasemano kuardumo ijefuon fu iji ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Ijefuon Erodias fuka vuak ijar deajiemga fu una oi ise Jon vierafene Jon kanakvega Erodri unam fuon bijukurain. Erod fuka juin ijefuon maiji fu vierafega Jon fu e ma ga fuka e akai ijefuon fuba ire ise kafo fuon rekafa vierafen. Regavo tavan ijia Erod fu Jonon vuak iji faimo iji fu oimarvknum fain revo fu vuak ijefuon maiji fuba vierafen. ");
INSERT INTO nvm_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Regavo tavan be Kin Erod fun tavan fuon bu nafenva iji rokga bara fuon Erodias fun unam izeg Jon kanakfuon iji fun vierafen. Rega Erod fun tavan fuon ijefuon e mamkanuk fuon ikrejo ijigam e azikegoijo ijiebuon e mamkanuk ijigam e mamkanuk kafo ar Gareri guf ijia karinva ijiebuon duok kanafuin. ");
INSERT INTO nvm_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Areme bun karine duok ijo ijia Erodiason kabaij iji fu arume uf ijia mani dua urumga Erod ga e iji funa karinva iji bu gavga buka oimadiain. Ijefuon Erod fu uri bara iji kua, A irerag vierafekma ni kiega na abe mavno kuain. Na god nun ijefuon if ijia irerag a vierafene kiekma na kege vajak. Regavo madu ire fok na samuavo iji a vierafekma na ke ata roin a vajakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ijefuon bara iji fun kek va asiefuon kua, A vierafe fu kiekma na izeg kuakno kuain? Fu ijeg kuardamga asiefuon fu kua, A vaga fu kuakma kua na Jon e do ruardiamo ijefuon nigen iji vierafenvano kuamne kuain. ");
INSERT INTO nvm_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Fu ijeg kuardamga bara iji fu migegare kukum una gumia kek Erod kua, Na vierafe aka iviakma igia e kia bu va Jon e do ruardiamo iji kanak. Bu kaname nigen fuon iji kanafu ter ijia anume abe igia miega na vierafero fu ma guainmaro na ijeg vierafekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Fu ijeg kuardamga Kin Erod fuka bomana oifiain. Regavo fun e fok ruainva ijiebuon nifak ijia god fuon kuardainma ijefuon fuba arek. ");
INSERT INTO nvm_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ijefuon fuka migegare uri e iji juo karijo iji kiamga bu Jonon nigen iji kanafume makuai vain. E iji bun va dibur ijia useme Jon kaname nigen fuon iji kanafuin. ");
INSERT INTO nvm_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ijegreare bun abe ter ijia abedeme abe bara iji mavga fu abe una asiefuon main. ");
INSERT INTO nvm_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Areme e iji Jonon vuak faivo roin bu vuak iji faime va gafia usem surif fuon abe mako ruin. ");
INSERT INTO nvm_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Rekoga afasor iji Jesu fu kiamga bu usem vainva iji bun una irerag bu nijaidiaknum reoinva ijin Jesu kuardain. ");
INSERT INTO nvm_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bu ijegrejo ijia e uruvana bu ijia giame una vaknum ijegreko tavan iji bu duok ikfuon iji fuka baren. Ijefuon Jesu fu uri e vuak fuon faivo iji kia, No nuvuonkua ai e bakin ijia va isuar karike ja madiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Fu ijeg kiamga bun uri buonkua vanag abe ai e bakin ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bun vanag abe vakrejga e uruvana ar kafokafo ijia ruainva iji bun giame vierafen. Ijefuon bun uri amur do irif ijia diak amedakie vake gafia usekoga Jesu fu e vuak fuon faivo ijiena rad kekoin. ");
INSERT INTO nvm_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Bu va ijia usevga Jesu fun uri e fok ijia afuinva iji giama fuka oifiain. Ijefuon maiji e iji buka maf-sif iji bu e samuagdiamo bakin igeg oija fu iji giain. Ijefuon fun uri anerene vuak nijaidiain. ");
INSERT INTO nvm_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Fu vuak nijaidiako fun ve nakikreko e vuak fuon faivo iji bu uri ro Jesu kua, Noka ai e bakin igia ruain revo fun ve nakikren. Ijefuon ni e guri kia bu una va mai ga ar samaij ijia duok bu ikfuon iji kafo kime ijno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Bu ijeg kuavga Jesu fu uri kia, Ni jar uri duok kafo nisaime vajia bu ijno kiain. Bu una madu uri kua, No buifuon duok kimekva iji noka e iji fu asam eit (8) ijeg fu ikrene mon iji fu abeno no ijeg abe duok kimek. Regavo a vierafega nobe mon izeg abe duok kime e igi vajiaga bu ikno kuain? ");
INSERT INTO nvm_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Bu ijeg kuardavga fu kia, Va e iji giamga bu bred izeg ke ruainvagia iji giafno kiain. Fu ijeg kiamga bun va e iji ruainva iji giame una ro Jesu kua, Bu bred imut roin (5) ga kijum nokarok (2) ijeg kege ruainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Areme Jesu fun e vuak fuon faivo iji kiamga bu e iji ruainva iji kiavga bu garas azan ijia atame kafokafo karioin. ");
INSERT INTO nvm_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","E roin bu atame vuan adred (100) ijeg kariko roin bu atame fifti (50) ijeg karioin. ");
INSERT INTO nvm_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Bu ijeg karioine arekoga Jesu fun uri bred imut roin (5) ijiga kijum iji kege gafeg varur gufia gavknum Godon sirimamen. Ijegreare fun uri bred imut roin (5) ijiga kijum iji ke tuaseme e vuak fuon faivo iji vajiamga bu kege e fok ijia karinva iji vajiain. ");
INSERT INTO nvm_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","43","Bu kege vajiavga e fok bu duok iji ijga buka defiavga e vuak fuon faivo iji bu uri duok ukur karme una ter tuer (12) ijeg anusen. ");
INSERT INTO nvm_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Regavo e fok bu ijia duok inva iji e baru ijesugin buka faiv taosen (5,000) ijeg. ");
INSERT INTO nvm_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","46","Areme Jesu fun e vuak fuon faivo iji kiamga bu vanag ajieme abe do ijia urame gara ar Besaida ijia vain. Bun vako fu uri e fok ijia karinva iji kia, Ni una ar jon ijia vafno kiamga bun vakoga fu una ajie uruor ijia sirimamekafa vain. ");
INSERT INTO nvm_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Regavo ve nakinma ijia e vuak fuon faivo iji bu vek vanag abe do uf ijia vak. Regavo Jesu fu vek fuonkua iror ijia sirimamen. ");
INSERT INTO nvm_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","50","Fu ijia sirimameknum giak e vuak fuon faivo iji buka vek vanag dab do azan ijia zazaimoij. Ijefuon maiji buibur ka bomana ijar bu vako ijia ufim. Ijefuon Jesu fun ve ik afarekreno ijia do azan ijia vuim buon ruain. Fun ijia asidia ruvakga bun game vierafero kafu zuar oinoro buka juin. Regavo e fok bun fu gainva ijefuon buka bomana dejufdiamga bu uri kumen. Bu juvga Jesu fu migegare uri kia, Na narno jab jukgavo nika giriesafno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Areme fun vanag ijia ajie buna fikok buibur iji fu bakitemga e vuak fuon faivo iji buka oiserdiain. Ijefuon maiji irerag fu reno ijefuon anej ma iji buba amarigia vierafen. Regavo madu Jesu fu daro fuon ijia bred ukaknak imut roin (5) iji kege e ka ma uruvana iji gormiava e vuak fuon faivo iji buka ba game vierafen. Ijefuon maiji nigen buon fuka ma gigikin. ");
INSERT INTO nvm_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","54","Bun do ijia urame vake Genesaret ijia usen. Bu ijia useme ariko vanag iji bu dab do irif ijia kirain. Regavo e ijia karinva iji bu Jesuon uikinik iji bun amur gainva ijefuon bun vierafen. ");
INSERT INTO nvm_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ijefuon bu usem kukubija mai kafokafo ijia oijknum e iji adam abejo iji aferdiame fata ijia uniame ke Jesu fina bu fainva ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Regavo Jesu fu mai ukaknak ga mamkanuk ijia vo ar kafokafo ijia fu vakon e iji buka e adam abejo iji aferdia ar bu duok kimejo makaf ijia uniain. Bu aferdia ijia uniame Jesu soisoime kua fu kiaga e adagin bu ugon buin fuon ijia niriakuai bu ijeg ren. E iji bu uri ugon fuon buin gamia kuniaivga adam buon iji buka una madiain. ");
INSERT INTO nvm_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tavan be e Ferisis iji ga e iji vuak akai nijaidiavo roin bu Jerusarem ijia ruainva iji bu va Jesu fino ijia kari ameoine aren. ");
INSERT INTO nvm_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bu ijia kariknum giak e Jesuon vuak faivo roin buba imut do soin revo bum duok ij. Bu unam e Ferisis bu imut do some duok ijo ijeg buba rej. ");
INSERT INTO nvm_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Usuibe saifijaf bu duok ikrejo bu imut do sovo ijefuon e Ferisis ijigam e Jius iji bu madu buka ijeg rejo. ");
INSERT INTO nvm_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Regavo ire be bu rejo iji bu va duok kimene una roko iji buka imut do so vo ire iji karme do some ijiason duok ijo. Regavo madu bu unam besum ijeg kafus ga firet ga saror iji do sovo. Regavo unam iji bu rejo iji bu saifijaf ijieb ijegrenva ijefuon bu madu bu ijeg rej. ");
INSERT INTO nvm_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ijefuon e Ferisis ijigam e vuak akai nijaidiavo iji bu uri Jesu kua, E vuak on faivo iji bu irerafuon ba saifnuvuon ijiebuon akaij ijia jajiame revo bum imut muigma duok ijno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Bu ijeg kuavga Jesu fu una roin kia, E guri ka i kufuikin gurie amur e Asaia buk kafarbe ijia vuak be fu joifuon kuainma iji fuka ma kuain. Regavo vuak iji bu ijeg isoin, E iji bum ir ijia kuai no God aroivo kuaigavo bu oibuon ijekma aroivo bakin. Regavo madu bu sirimamene na vierafeoijo iji maiji fuka bakin. Ijefuon maiji bu Godon akaij iji e nijaidiavo bakigavo bum ema ijiebuon akaij iji kege e nijaidiavno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Jesu fu ijeg kuardiame uri kia, Ja God akaij iji fu nainma iji jan areme uri ema ijiebuon akaij iji kege e nijaidiavno kiain. Areme fu kia, Ja ijegreoknum ja Godon akaij iji ja izeg jakva iji jaka amarigia vierafen. Regavo jaka vuak iji bu ema ijieb vierafene amarenva iji ke nijainamime ijesugin vierafeoij. ");
INSERT INTO nvm_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ijefuon maiji e Mosis fu akai fuon fu isoinma ijia fu kuai, Asoion ijiga asieon iji mukor igiaf. Regavo madu erar fu asiefuon ga asoifuon iji vuak ise kafo buisina kuardiakma e iji nika kana fu guamne kuain. ");
INSERT INTO nvm_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Regavo jar nijaidiavo iji ja kuai, E be fu mon fuon fu ire kime eofijaf vajiakafa nainma iji fuka aremne kuain. Ijefuon maiji mon iji fun amur kuai fu kege God vajakno kuain. Ja ijeg kuaimoijo ijia jaka izeg fu asie vo asoifuon iji ifejdakma ijia jaka kuriairev. ");
INSERT INTO nvm_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Regavo madu saifjon ijiebuon unam iji ja kege ijeg e nijaidiaoijo ijar fu Godon vuak ijek nibijaim. Regavo madu jaka ire kafo ijekin uruvana rejno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","15","Fu ijeg kuardiame fun uri e fok kumega bu samaij ijia rokga fu kia, E fok ni na fadieke na vuak igi kuardiaga amarigia faif. E iji fu oine duok ino iji fu duok ijar fu abe Godon nifak ijia e ise reno bakin. Regavo fun vuak irerag ise fu oifuon ijia vierafene kuaimoino ijar e iji fuka Godon nifak ijia fuba mukoi reoin. ");
INSERT INTO nvm_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ijefuon ja adakiga ni vuak igi na kuardiavo iji amarigia faifno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Areme Jesu fun e iji afuim karinva iji areme ar guf ijia aru vakga e vuak fuon faivo iji bu uri kua, Ni vuak iji a bijame kuarduinma ijefuon ma iji kuarduomne kuain. ");
INSERT INTO nvm_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Bu ijeg kuavga fu kia, E fok buka non giaga ja e vuak nun faivo iji jak jaka non giain. E be fu ire be abe ikma fu ire ijar fu dab ise rekma bakin. Regavo ire iji fu ino iji fu oifuon guf ijia arivakma bakin. Regavo fum defok ijia arime una vajai fuon ijia keko vak. (Regavo Jesu vuak ijeg fu kuainma iji duok fok no ijo iji fu iseno kuainma bakin revo buka ma ijesugin). ");
INSERT INTO nvm_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jesu fu ijeg kuardiame una madu kia, E iji vuak irerag fu oifuon ijia vierafeno iji fu ir ijia kuaimon. Ijefuon ijar e iji fu Godon nifak ijia fuka ba mukoi kegoin. ");
INSERT INTO nvm_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","23","Ijefuon maiji e iji fu ire ise kafokafo fu oifuon ijia vierafenon. Ijefuon fun ise iji fu oifuon guf ijia vierafeno ijar urino ijefuon fun va ire ise kafokafo ren. Regavo ire ise iji barubara oijo ijigam e kaniavo ijigam ebuon bara turavo ijin. Regavo madu sinuom uruvana kekafa vierafeno ijigam kai roin oij isema vierafejo ijigam vuak kufuimejo ijigam ise reoknum ba juf abejo ijin. Regavo madu e kafobuon sinuom karekuai vierafejo ijigam e kafobuon vuak ise kuaivo ijigam aroikaravo ijigam unam ise e ba juf abejo ijia kegoijo ijin. Ire ise ijekin ijieb e ijefuon oij ijia useko fu va ise reoino kiain. ");
INSERT INTO nvm_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesu fu ijeg kuardiame fun uri vake ai Taia samaij ijia kekoin. Fu ijia kekome gire be ijia ajie sauikafa vierafen gavo e roin bu fu izia fino iji bun vierafen. ");
INSERT INTO nvm_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Rega bara be fu kabaifuon kaven ise ijar niroinma ijefuon fu Jesu ruainma iji fain. Ijefuon fun vake fu fino ijia keko nifak fuon ijia ato sain. ");
INSERT INTO nvm_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Regavo bara iji fu bara Grik rega bu fu ar Siriafonisia ijia nafen. Bara iji fu keko ato same Jesu soisoime kua, Ni kaven ise igi kuaga fu kabainun igi areme keko vakne kuain. ");
INSERT INTO nvm_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Regavo e Jius iji bu vierafero bu buonkua Godon e revo e kafo bum siroij igekinro bu ijeg vierafen. Ijefuon Jesu fu uri kuai, No amur am ijiebuon duok iji vajiame rad noson siroij iji vajiak. Regavo am ijiebuon duok iji no amur ke siroij iji vajiakva fuba marek. ");
INSERT INTO nvm_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Regavo bara iji fu magaga kua, Vuak iji aka ma kuaim. Regavo siroij iji bu vek am ijiebuon duok ukur iji buka ikno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Fu ijeg kuamga Jesu fu kua, Iji a ma kuardiem ijefuon ni vakgavo kaven ise iji fu kabaion iji fun areme vainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jesu fu ijeg kuamga bara iji fu una va ai fuon gafia kekome gak am iji fun ninain. Ijefuon maiji kaven ise iji fun am iji areme keko vain. ");
INSERT INTO nvm_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Areme Jesu fu ar Taia samaij ijia fioine areme fun vake ar Saidon asime vake do Gareri Dekaforisi guf ijia kekoin. ");
INSERT INTO nvm_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Fu ijia kekomga e roin bu uri e ada bijukurainma vuak ba kuaimo iji afeme ro Jesu fino ijia usem soisoime kuaga fu e iji imut nigen abedekuai ruain. ");
INSERT INTO nvm_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ijefuon Jesu fun fuonkua e iji afeme va e iji ni sauikuriame imut fuon ijia e ijefuon ada ijia uniame juvit foine imut fuon ijia azime e ijefuon miane ijia kunain. ");
INSERT INTO nvm_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Areme fun gafeg varur ijia nisaiknum oij foine kua, Efafatano kuain. (Regavo vuak ijefuon maiji nin ada ira vo ir ako). ");
INSERT INTO nvm_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jesu fu ijeg kuamga fun ada fuon ijia faime fun uri anere vuak kuain. ");
INSERT INTO nvm_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Areme Jesu fu uri e fok uruvana igia kuriaireme kia, Ire igi na renva iji jab e kafo kuardiakno kiain. Regavo e iji buka magaga uri e roin kuardiain. ");
INSERT INTO nvm_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bu kuardiavga e fok bu vuak iji faiva buka oiserdiamga bu kuai, E iji ire uruvana fuka amarigia reoin. Regavo madu fuka e ada bijukuriainma iji kiaga bu una vuak faiknum vo e vua ba kuaivo iji kiaga bu una vuak kuaivno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Ijegrene afarma bun una madu ka e uruvana ijia afuin. Regavo duok bu ikfuon iji fuka bakin ijefuon Jesu fu uri e vuak fuon faivo iji kumega bu ruain. Bu rokga fu kia, Naka e igiebuon oifiadiem ijefuon maiji bu naki nokbek (3) nona karinva ijefuon iviakma duok bu ikfuon iji fuka bakin. ");
INSERT INTO nvm_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Regavo na duok ba vajiaga nam kiaga bu una ar vakva buka vasiaoriak rega nizigdiame ari kaniak. Ijefuon maiji e roin buka aibe ijia ruainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Fu ijeg kuardiamga e vuak fuon faivo iji bu uri kua, Regavo a vierafega no ai moikum namo igia no izeg bred karme e igi vajiaga bu iga bu defiakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Bu ijeg kuardavga Jesu fu uri kia, Ja bred izeg nainvano kiamga bu kua, No bred seven (7) nainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Bu ijeg kuavga fu uri e fok kiamga bu ari karikoga fu bred seven (7) iji kege Godon oimaren. Areme fun ke tuaseme e vuak fuon faivo iji vajiamga bu kege e fok ijia karinva iji vajiain. ");
INSERT INTO nvm_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Regavo madu bu kijum ukaknak sibank kafo madu nainva ijefuon Jesu fun uri iji ke madu Godon oimarme kiamga bu kege e fok vajiain. ");
INSERT INTO nvm_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Areme e fok bu duok iji ijga bun defiain. Rega e Jesuon vuak faivo iji bun uri duok ukur iji karme ter seven (7) ijeg anuin. ");
INSERT INTO nvm_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","10","Regavo e ijia ruainva ijia efarif ijesugin bu e fo taosen (4,000) ijeg. Areme Jesu fun e fok kiamga bu vakoga fu uri e vuak fuon faivo ijiena vanag ijia ajieme bun una ar Damanuta ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bun va ar Damanuta ijia usevga e Ferisis roin bu Jesu biesuakuai ruain. Bu usem Jesu kua, Ni ire sumakin be rega no game vierafero an ma Godon daro ijia reoinro no ijeg vierafekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Bu ijeg kuavga Jesu fu uruvana igia aduime kia, Irerafuon e igi iviakma karijo iji bu ire sumakin kafo giakuai kiev. Regavo vuak igi naka ma kuardiav na ire sumakin kafo naba rega ja giakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Fu ijeg kuardiame fun una vanag abe do gara vain. ");
INSERT INTO nvm_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Regavo e vuak fuon faivo iji bu rubdiamga ire kafo buba kege vain gavo bum bred besum (1) abe vain. ");
INSERT INTO nvm_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ijefuon Jesu fu uri kia, Ja oijo iji ni e Ferisis ijigam e Erod ijiebuon ire ist iji amarigia akariaknum ofno kiain. (Regavo Jesu vuak iji fu ire ist ijefuon fu kuardiainma iji fu e Ferisis ijigam e Erod ijiebuon unam bu kegoijo fu ijefuon kuain). ");
INSERT INTO nvm_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Regavo e vuak fuon faivo iji bu vuak fuon fu kuaimon iji buba mukoi fain. Ijefuon bu vierafekuai fukafu bred buba ke ruainva ijefuon kuaimro bum isuar karine una bui kuaiv. ");
INSERT INTO nvm_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Regavo Jesu fu vuak irerag bu kuaivo iji fun gia vierafenma ijefuon fu uri kia, Ja irerafuon bred iji jaba ke ruainva ijefuon dab kuaiv? Ja vuak igi na kuardiavo iji jaka ba mukoi faim vierafen. Ja oijon iji fuka vek gigikin. ");
INSERT INTO nvm_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Ja nikin revo jaka ba giav revo madu jaka adakin revo jaka ba faiv. Ja amur bred imut roin (5) iji na ke tuaseme e faiv taosen (5,000) ijeg vajiainva iji jabe vierafen? Regavo madu ja ter izeg duok ukur iji anusenva iji jabe vierafenvano kiain? Fu ijeg kiamga bu kua, No ter tuer (12) ijeg anusenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Bu ijeg kuavga Jesu fu una kia, Regavo ja madu bred seven (7) iji na ke tuaseme e fo taosen (4,000) ijeg vajiainva ijia duok ukur iji ja ter izeg anusenvano kiain? Fu ijeg kuardiamga bu kua, No ter seven (7) ijeg anusenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Areme Jesu fu uri kia, Ja ire sumakin nokarok (2) iji na renva iji jan giain. Regavo jaka vek ba vierafero na aresredo na ire kafo ja karekuai vierafejo iji na vajiakro ijeg jaka vierafenva bano kiain. ");
INSERT INTO nvm_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Areme bun roke ar Besaida ijia usevga e roin bu e nizuriaigin iji afeme usem Jesu soisoime kua are fu e nizuriaigin iji niriamoro. ");
INSERT INTO nvm_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Bun usem soisoivga Jesu fu uri e nizuriaigin iji afeme ar iji areme keko makaf ijia vain. Fu va ijia keko juvit foine e ijefuon uikinik ijia azime imut nigen abedeme kua, A iviakma abe una ire kafo giamno kuain? ");
INSERT INTO nvm_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Fu ijeg kuamga e iji fu una asarajie gaknum kua, Na e iji nan giain revo bu in igeg oijno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Fu ijeg kuamga Jesu fu una e ijefuon ni iji kunaimga fuka ni narame uri ire fok amarigia giain. ");
INSERT INTO nvm_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Areme Jesu fun e iji vuak nijaime kua, Ni una ar on ijia vagavo ab una mai gafia va irerag na renva ijin e kuardiamne kuain. ");
INSERT INTO nvm_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Areme Jesu fun e vuak fuon faivo ijiena mai ukaknak kafo Sesaria Firifai guf ijia vako unam ijia fu uri kia, Ja vierafega e iji bu na gievo iji bu era vierafejno kiain? ");
INSERT INTO nvm_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Fu ijeg kiamga bu kua, E roin bu kuai aiji a e Jon e do ruardiamo ijin. Regavo roin bu kuai, A e Eraija ga roin bu kuai, Aiji a e be Godon vuak vierafene kuaimon ijino kuain. ");
INSERT INTO nvm_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Bu ijeg kuavga fu una kia, Regavo jaiji ja vierafega naiji na erano kiain? Rega Fita fu uri kua, Aiji a Kurais e iji God fu kuamga fu ari ruainma ijino kuain. ");
INSERT INTO nvm_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Fita fu ijeg kuamga Jesu fu kuriairene kua, Vuak iji jab e kuardiavno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Areme Jesu fu uri e vuak fuon faivo iji vuak nijaidiame kia, Ema ijiebuon Farif igi naiji bu e mamkanuk ijigam e Godon isuf baroijo ijigam e vuak akai nijaidiavo ijieb na buka uzame kaniega na vajai fian abene guak. Regavo naki nokbek (3) barke na una urikno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesu fuka samakaf ijeg kuardiamga Fita fuka uri Jesu imut ke vain. Fu imut ke va fuonkua kekome vuak iji Jesu fu ijeg kuainma ijefuon zieme una Jesu kuriairen. ");
INSERT INTO nvm_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Fu ijeg kuriaireme kuardamga Jesu fu dakaroime una e vuak fuon faivo iji giame una Fita kuriaireme kua, Setan gareg va. A Godon vierafe iji a bakin revo am emabuon vierafe ijia kuardiemno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Areme Jesu fun uri e fok ijigam e vuak fuon faivo iji kumega bu samaij ijia ruain. Bu ijia rokga fu uri kia, E be erar fu dia makai nun ijia jajiekro vierafekma e iji ni ire fuon fok moik igefuon iji ka nuigafiakfuon. Fu ijegreare vo uri vajai fian kafokafo bu fuon roko iji ka ijia giriesame magaga nuifuon ikrekfuon. ");
INSERT INTO nvm_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ijefuon maiji erar fu una fuon izeg fu moikigia ma fivakfuon iji uruvana vierafeokma rad fuba unam ma karivako iji abek. Regavo erar fu tavan bog if nun ijia una e roin oijmiame ifejdiaknum vo vuak nun abe kuaimokma e iji fu rad unam ma karivako iji abek. ");
INSERT INTO nvm_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","Regavo erar fu moik igefuon sinuom iji oijmiagavo God fu nuigafakma e iji kaven fuon iji fun abe aberem. Regavo madu fu moik igefuon sinuom ijieb fu ifejdaga fu Godon ar ma ijia aru vakma bakin. ");
INSERT INTO nvm_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Regavo e be erar fu e vuak nun faimo rekro jumo ga vuak nun abe e ise rejknum God ba vierafejo iji nijaidiakro jumo iji Ema ijiebuon Farif igi na una Godon sanainma ijiga anera akaij ijiena una roko ijia nasik una bu giame jukno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesu fu ijeg kuardiame kia, Vuak igi naka ma kuardiavno mukoi faif. E fok guri ja karinva ijia e roin ja nivek karinva ijia ja tavan iji God fu efuon ijiebuon oij iji samuagdiakro fuka darokma roga ja ni jon ijia gak. ");
INSERT INTO nvm_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Areme tavan siks (6) ijeg barekoga Jesu fun Fita ga Jeims ga Jon ijin aferdiame bun buonkua uruor kaf ijia ajieme vain. Bu va ijia usem ireme gakoga Jesuon vajat iji fun migegare una nibe ren. ");
INSERT INTO nvm_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Fu ijegrekoga ugon fuon iji buka mukoi saname abaren. Ugon iji bu abarenva iji bu e moikigia ugon soga bu abarvo ijekin iji fuka bakin revo fuka ma abaren. ");
INSERT INTO nvm_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Bu iji ireme gavo ijia e Mosis ko Eraija e iji usuibe aoinva ijieb bum ijia usem Jesuna ireme vuak kuain. ");
INSERT INTO nvm_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Bu ireme vuak kuaivga Fita fu uri Jesu kua, E nijaidiamo igi no ruainva iji fuka maren. Na vierafe noka ai muvuakar nokbek (3) be on ga be Mosison ga be Eraijaon ijeg igia sakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Regavo Fita ga e nokarok (2) iji bu ire iji renma iji gavga buka uruvana dejufdiame i girdiain ijefuon Fita fu izeg kuaikma baga fum ijia manine giain). ");
INSERT INTO nvm_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Areme vana ijar utime ari e iji ka fok okuriakoga vua be vana araf ijia ijeg kume, E iji fu farinun ma na fu bomana oijmavo. Ijefuon vuak fuon iji amarigia faime igafno kumen. ");
INSERT INTO nvm_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Bu vuak iji faime migegare una karoime nisaimga e iji fu baki gavo fu Jesur vek fuonkua buna ijia manina bu gain. ");
INSERT INTO nvm_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bu ijegrene bun uruor iji areme una ari roko ijia Jesu fu uri kia, Ja una vakva irerag igi fu rena ja gainva iji jab e kafo kuardiak. Janim areke Ema ijiebuon Farif igi na guame una urike ni ijiason kuardiafno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Fu ijeg kuardiamga bun uri fu igame isuar oibuon ijia aren. Regavo bu una buon kuaime kuai fu guame una urikno kuinma iji fu irerafuon ijeg kuainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bu buon ijeg kuaime una Jesu kua, E vuak akai nijaidiavo iji bu irerafuon kuai fu Eraijar amur una ruakno kuain? ");
INSERT INTO nvm_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Bu ijeg kuardavga Jesu fu una kia, Fu Eraijar amur una ro ire fok amardiame kanafukno kuainva iji bu ma kuain. Regavo Godon buk akaij ijia vuak iji bu isoime kuai, Ema ijiebuon Farif iji fuka vajai fian abek ga madu e fok buka fu uzakno kuainva iji bu irerafuon ijeg isoinvano kuain? ");
INSERT INTO nvm_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Vuak igi naka ma kuardiav, E Eraija fun amur ruain. Fun rokga e iji bun uri izeg Godon vuak akaij ijia bu buifuon isoime kuainva ijeg buka fu dab buon bu vierafenva ijia ren. ");
INSERT INTO nvm_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesu fun e vuak fuon faivo nokbek (3) ijiena una ari vake gami e vuak fuon faivo roin bu karinva ijia usen. Bu usem giak e ka ma uruvana bu ijia karioine areko e vuak akai nijaidiavo roin bu e Jesuon vuak faivo roin ijiena musikuaiv. ");
INSERT INTO nvm_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Bu ijegrejo ijia Jesu fu rokga buka oiserdiamga bu kukubija usem bieme anain. ");
INSERT INTO nvm_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Areme fu uri e vuak fuon faivo iji kia, Ja vuak igi irerag iji buna kuaime dab siguvno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Fu ijeg kiamga ebe fu e uf ijia uri kume, E nijaidiamo na farinun fuka vua ba kuaimo na iji afeme on ruain. Ijefuon maiji fu kaven ise ijar niroinma fu vuak kuaimon bakin. ");
INSERT INTO nvm_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kaven ise iji fu farinun iji niroime kana dab akozemga fu sakinazan ijia dijeme itatan arime ubai jakiknamiknum vajai garem. Na fu afeme ro e vuak on faivo iji kia, Kaven ise iji kuaga fu amnun iji areme vakno kiain gavo bu amarega fuka iseremno kumen. ");
INSERT INTO nvm_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","20","Fu ijeg kumega Jesu fu una roin kua, E guri nivek karinva gurie jon ma vierafejo iji fuka ma ukaknak. Na tavan izeg jana fiknum vuak nijaidiaga ja ijia mukorigia ma vierafek? Am iji afeme roga na gavno kiamga bu afeme Jesu fino ijia ruain. Bu afem rokga kaven ise iji fu Jesu game keko vakafa uri am iji kana dab akozemga fu moik ijia dijeme jiekeknum itatan arin. ");
INSERT INTO nvm_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","22","Fu ijegrega Jesu fu una dakaroim asoifuon iji kua, Farifon iji fu iviakma ijegren vo fun usuibe ijegrene ruainmano kuain. Fu ijeg kuamga am ijefuon asoij iji fu kua, Fu vek ukakbe ijia ijegrene ruain. Kaven ise iji fu ijegrene fuka kanaga fu guakafa fuka tavan bog kana dab do ijia abeseknum dab mian baroin. Regavo a vierafega an aresrega ni oifian nuvuon iji guome ifejduomne kuain. ");
INSERT INTO nvm_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Fu ijeg kuardamga Jesu fu una kua, A irerafuon kie a aresga ni ifejduomne kiem? Erar fu ma vierafekma iji fu aresredo fu ire kafokafo rekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Jesu fu ijeg kuardamga am ijefuon asoij iji fu uri kume, Na a ma vierafen revo vierafe nun fu ma ukakbe. Ijefuon ni una madu ifejdiega na una biom ma ka gigikin a ma vierafejno kumen. ");
INSERT INTO nvm_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ijegrene Jesu fu gak buka vek e uruvana rokga fu uri kaven ise iji kuriaireme kua, Kaven ada bijukin vuak ba kuaimo gure na a kuavo ni e iji areme kek vakne. Rega ab una ro fu niroimne kuain. ");
INSERT INTO nvm_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jesu fu ijeg kuamga kaven ise iji fu kekokafa uri am iji dab niroimga fu guafaruime kakurime keko vain. Fu keko vakoga am iji fuka daro baremga fun ijia zazaime ajuaremga e fok bu game vierafero fun guainmaro bu ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Regavo Jesu fu uri ifejdame imut kega fu una urin. ");
INSERT INTO nvm_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ijegreare rad Jesu fun una ar ijia aru vakoga e vuak fuon faivo iji bu isuar jame aru Jesu kua, Kaven ise iji nor rotkurain revo fu irerafuon ba e iji areme keko vainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Bu ijeg kuardavga Jesu fu kia, Ire ijekin iji jaka sirimame God kuardakva fu rekfuon. Regavo una unam kafo iji ja irerag ijia rene kaven ise iji kuriairega bu usem vakva bano kiain. ");
INSERT INTO nvm_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Areme bun ar iji areme una ar Gareri ijia urame vain. Regavo Jesu fu vierafe fuka e iji ni sauikuriame vakafa fu ijeg vierafene vain. Ijefuon maiji fu e vuak fuon faivo iji izeg fu rad guame una urikfuon fu ijin kuardiain. Fu kia, Rad Ema ijiebuon Farif igi na bu dab e ise rejo iji miaga bu kaniega na guaken. Regavo rad naki nokbek (3) barga na una urikno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Regavo e vuak fuon faivo iji bu Jesu vuak iji fu irerafuon ijeg kuardiamo iji buka ba mukorigia faime vierafen. Regavo madu bu juinva ijefuon buba una Jesu duna kuardain. ");
INSERT INTO nvm_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Areme bun vake ar Kafoniam useme gire be ijia ajie karinva ijia Jesu fu uri e vuak fuon faivo iji kia, Ja unam gafi ja vuak irerag iji kuaime dab siguinvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Jesu fu ijeg kuardiamga e vuak fuon faivo iji buba una roin kuardain. Ijefuon maiji bu unam ijia erar fu e ikin rekfuon ijefuon kuaime dab sigunamin. ");
INSERT INTO nvm_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Areme Jesu fun ari fine e tuer (12) vuak fuon faivo iji kiamga bu rokga fu kia, Erar vierafega fu e ikin rekma amur funika una e ukakbe rene e fokbuon ikrene kiain. ");
INSERT INTO nvm_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Fu ijeg kuardiame uri am ukakbe be afeme uf ijia unain. Areme fu uri kaivene una dakaroi e vuak fuon faivo iji kia, E iji eraneb ja if nun ijia am ukak igekin iji anadiavo iji bu na anadiev. Regavo eraneb bu na anadievo iji bu na nunkua anadievo bakin gavo bu e iji fu kiemga na ari ruainva bu e iji madu anaivno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Areme Jon fu uri kua, E nijaidiamo e be fu if on ijia kaven ise iji kuriairena fu keko vaka no game kuavga fu aren. Ijefuon maiji fu nona oinon bano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","40","Bu ijeg kuardavga Jesu fu uri kia, E iji fu ijegreoinon iji jab bijukurak. Ijefuon maiji erar fu if nun ijia ire sumakin be rekma fuba una nuisina vuak ise kafo kuaikfuon. Regavo madu erar fuba nona nibijaimo e iji fu nona ren. ");
INSERT INTO nvm_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Rega vuak igi naka ma kuardiavo faif. E be erar fu vierafero aiji a Kuraison e ro fu ijeg vierafeknum ire ukakbe do gaikin ijekin iji a ifejdakma iji Godri unam ma iji kafo fuon redakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesu fu ijeg kuardiame una madu kia, Erar fu e iji bu oij asusame am ukaknak igeg na ma vierafejo iji kam arafiriaga bu una ise reokva na vierafega e iji fuka mun bomana be dab uro fuon ijia kira saof uf ijia akozga fu do ikfuon. ");
INSERT INTO nvm_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Regavo madu a vierafega bu imut on ijieb a aferdame ise kafo rekva na vierafega aka kanafu akozek. A ijegrekma iji fun mardo a imut roibknum ar ma karivako ijia vak. Regavo aba imut on nokarok (2) iji be kanafu akozekma iji bun imut on ijieb aferdame ar ise iji mian fu naine udaremo bakin ijia vak. ");
INSERT INTO nvm_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Regavo madu a vierafega bu diak on ijieb a aferdame unam ise ijia vakoga ni diak ijin be kanafu akoze. A ijegrekma iji fuka mardo a diak besum e aikirainma igeg ar iji ma karivako ijia vak. Regavo aba diak on be kanafume akozekma iji bu diak on nokarok (2) ijieb a dab mian ise iji fu tavan bog ijia naino ijia akozga a vajai fian abek. ");
INSERT INTO nvm_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Regavo madu a vierafega bu ni on nokarok (2) ijieb a aferdame ise reoga ni niom on iji be jafe akozemne. A ijegrekma iji fuka mardo a ni roibknum ar iji ma karivako ijia vak. Regavo aba ijegrekma iji bu niom on ijieb a dab ar ise mian naino ijia akozga a ijia vajai fian abekfuon. ");
INSERT INTO nvm_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Regavo vuak iji ar ise mian naino ijefuon iji fun e Asaiar usuibe ijeg kuainma bu ijeg isoime kuai, Ar ise ijia ire nifun iji buba aoik ga mian iji ijia naine vako iji fuba udarkno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ijegvo fu Godri ik jon fok ja reoijo iji fu kege mian ijia jagiame ise iji fu ke kozega ma iji fu arekfuon. ");
INSERT INTO nvm_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Regavo madu tavan iji no mit abe duok savo iji fuka marien mukor. Regavo marien fuon fuba markma iji no izegrega marien fuon iji fu una markma bakin. Ijefuon ni vuak nun iji mit igekin iji tavan bog oijon ijia vierafene reknum jon afuime kariofno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Areme Jesu fun ar iji areme una Judia guf ijia do Jodan ruvainma irif gara ijia vain. Fu ijia vakga e uruvana bu una fuon rokga fu amur fu renma ijeg fu una madu vuak nijaidiain. ");
INSERT INTO nvm_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fu vuak nijaidiamo ijia e Ferisis roin bu Jesu biesurakuai ruain. Bu usem kua, A vierafega akai nuvuon ijia fu kuainma ijeg e be fube bara fuon datura unaga fu vakno kuain? ");
INSERT INTO nvm_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Bu ijeg kuavga Jesu fu uri kia, Regavo Mosis akai fuon iji fu abe miainma iji fu akai irerag iji abe miainmano kiain? ");
INSERT INTO nvm_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Fu ijeg kiamga bu uri kua, Mosis fu kuo, E be fu bara fuon datura unako fu vakma fuka fefa be isoime kua, Ivia a bara nun bano kuame abe maga fu vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Bu ijeg kuardavga Jesu fu uri kia, Vuak iji Mosis fu isoime kuai ja barafjon tura uniakno kuainma ijefuon maiji oijon fuka ma gigikin. ");
INSERT INTO nvm_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","9","Regavo ik anej iji God fu moikigi amarenma ijia fu kuai, God fu efarif amareme vo bara amaren. Ijefuon efarif iji fu uri asoifuon ijiga asiefuon areme una bara fuon ijek fiok. Bu ijeg karioijo ijia bu una busik vajai besum rek. Ijefuon bu busik bu nokarok (2) bakin revo buka vajai besum. Ijefuon bara iji God fu abe efarif ijek besum kamainma iji e kafo buba ke ata kafokafo uniakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Areme rad bun una va ar ijia karinva ijia e vuak fuon faivo iji bu uri Jesu vuak iji fu kuardiainma ijefuon duna kuain. ");
INSERT INTO nvm_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","12","Ijefuon Jesu fu uri kia, E be fu bara fuon abe uname una bara rir iji abekma e iji fu bara ijin daturam. Regavo madu bara be fu baru fuon iji ijia areme una baru rir iji jakma fu baru ijin daturamno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Regavo e roin bun afijaf iji aferdiame Jesuon roga fu bu imut nigen namdiaknum buifuon sirimamekuai ruain. Regavo e vuak fuon faivo iji buka ba oimarenva ijefuon bu uri e iji afijaf aferdia ruainva iji bijukuriain. ");
INSERT INTO nvm_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Regavo Jesu fuka deajin ijefuon fu uri e vuak fuon faivo iji kia, Ja am ukaknak iji jab bijukuriakgavo areke bu aferdia nun ruaf. Ijefuon maiji e iji eraneb bu am ukaknak iji bu asoibuon iji ma vierafejo ijeg bu na ma vierafekva God fu e ijekin iji samuagdiak. ");
INSERT INTO nvm_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ijefuon ni vuak igi na kuardiakrejo iji amarigia faif. Erar fu am ukaknak igi bu na ma vierafejo ijeg God ma vierafekma fu Godon e iji fu oibuon ijia samuagdiamo ijiena mazikfuon. Regavo fu bakma fu izeg buna mazikma bano kiain. ");
INSERT INTO nvm_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Fu ijeg kuardiame uri am ukaknak iji imut fuon ijia kamudiame imut nigen namdiaknum God kuamga fu bu daro miain. ");
INSERT INTO nvm_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Areme Jesu fun e vuak fuon faivo ijiena una unam ijia roko ijia e be fu kukum ruain. Fu kekome Jesu roko nifak ijia ato same kua, E maiguri e nijaidiamon na ire ma iji na irerag iji rega na unam ma karivako iji abekno kuain? ");
INSERT INTO nvm_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Fu iji kuamga Jesu fu una kua, A irerafuon na kie e maigurieno kien? Fu e be fu erar e ma bakin revo fun e besum Godri fuonkua e ma. ");
INSERT INTO nvm_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Regavo duna iji a kienma iji Godon akaij iji fu kua, Ab e kafo kaniaknum e kafobuon bara turaknum ga e kafobuon ire niesaknum e kafobuon vuak kufuimene kuaiknum e kafo biesiame sinuom buon karek. Regavo madu nika asoion ijiga asieon igiamne kuainma iji an vierafenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jesu fu ijeg kuardamga e nivek iji fu uri kua, E nijaidiamon na vek e ukakbe gamia vuak irerag a kuardiemo iji nan ijeg kegoijknum igia ruainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Fu ijeg kuardamga Jesu fu uri e iji game oijmaknum kua, Ire uruvana an rena fun maren. Regavo nin ire besum igin va re. Va sinuom on uruvana ke kime mon iji abe una e sinuom bakin iji vajiame ni uri na jajiemne kuain. ");
INSERT INTO nvm_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ijefuon e nivek iji fu vuak iji faima fuka bomana oifiaimga fu oifiaigma vain. Ijefuon maiji fu vierafega fuka sinuom ma uruvana zarain. ");
INSERT INTO nvm_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Areme Jesu fu una dakaroime e vuak fuon faivo iji giame kia, E iji sinuom zarainva bu sinuom ijia biduame karijo iji bu Godon e iji fu oibuon iji samuagdiamo ijiena besum mazikfuon iji fuka ma gigikino kiain. ");
INSERT INTO nvm_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Fu ijeg kuardiamga e vuak fuon faivo iji bu vuak iji faiva buka oiserdiain. Ijefuon Jesu fu una kia, Afnun gurie unam iji e bu Godon e iji fu oibuon iji samuagdiamo ijiena mazikfuon iji fuka ma gigikin. ");
INSERT INTO nvm_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Regavo igia faif. Fanuf kamer iji fu ma bomana ga siem tit iji fuka ukakbe ijefuon fu ijia aru vakma fuka gigikin. Unam besum ijegvo e sinuom zarainma iji fu Godon e iji fu oibuon iji samuagdiamo ijiena mazikma fuka ma gigikino kiain. ");
INSERT INTO nvm_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ijefuon e vuak fuon faivo bu vuak iji faiva buka oiserdiamga bu uri buon kuai, Fu erar aresredo fu e iji God fu oibuon iji samuagdiamo ijiena besum mazikno kuain? ");
INSERT INTO nvm_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Bu ijeg kuardavga Jesu fu kia, E kafo erar fum fuon vierafenma ijia ga unam fuon fu kegoino ijia fu aresrenma bakin. Regavo fun Godri fuonkua fu aresredo fu ire fok rekfuon. Regavo madu fun koikfuon era fu vierafenma iji kuaga fu Godon e iji fu oibuon iji samuagdiamo ijia buna besum mazikno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Areme Fita fu una kua, Noiji ire nuvuon fok iji non ijia areme uri a jame ruainva iji guomne kuain. ");
INSERT INTO nvm_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Fu ijeg kuardamga Jesu fu uri kua, Vuak iji a ma kuain revo ni igia fai. Erar fu ar fuon ga uviaifijaf ga makifijaf ga asoi asie ga afijaf ga juar fuon iji nuifuon Godon vuak ma iji fu kuaimoino ijefuon nuigafiakma fuka marek. Fu ijegrekma rad God fu ifejdaga fuka ire fok fu kenma ijefuon azan ijia una ire ma kafo madu uruvana kekfuon. Regavo ire iji fu rad kekfuon iji ar ga uviaifijaf ga makifijaf ga asie asoi ga afijaf ga juar ijin. Regavo madu fu na jajiekma fuka unam ise uruvana kafo biediakfuon. Regavo Godri rad unam ma karivako iji abe maga fu ijia fivak. ");
INSERT INTO nvm_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Regavo e uruvana iji amur irevo iji bu una rad ireken. Regavo eraneb iviakma rad irevo bu una amur irekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Areme bun una Jerusarem ajie vakuai unam ijia vak. Regavo Jesu fu amur vako e vuak fuon faivo iji buka oiserdiamga bum ijia jame vaknum bomana vierafej. Regavo e roin ijia ja vako iji bu madu buka bomana juin. Areme Jesu fun una madu e tuer (12) vuak fuon faivo iji aferdiame va buonkua useme fun uri uniaibe rad fuon rekfuon iji kuardiain. ");
INSERT INTO nvm_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","34","Fu uri kia, Igia faif no vake Jerusarem usevo ijia Ema ijiebuon Farif igi na bu abe e isuf baroijo ijiebuon e mamkanuk ijigam e vuak akai nijaidiavo iji miakfuon. Bu abe miaga bur na tomdieme ise nun kuaime dab arafirikfuon. E ijieb na bu abe una e Jius bakin iji miaga bur na abe varai meknum juvit foimadieknum fijieme abe kuros kaniek. Regavo naki nokbek (3) barga God fu kiega na una uri nivek fivakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Areme Zebedion afijaf nokarok (2) e Jeims ko Jon bu ro Jesu fu manino ijia useme kua, E nijaidiamon no vierafega aka ire be nuvuifuon rekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Bu ijeg kuavga Jesu fu una kia, Ja vierafega na irerag iji joifuon rekno kiain? ");
INSERT INTO nvm_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Fu ijeg kuardiamga bu uri kua, E Bomana no vierafega a tavan iji a una e bomana rene fata on ma iji sanainma ijia fine e fok samuagdiamo ijia a no kuoga no ana ij maink ga aizinan on ijia karijno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Bu ijeg kuavga Jesu fu uri kia, Vuak iji ja kuardievo iji jaka ba amarigia vierafen. Na vajai fian bomana abekro rejo ja vierafega jabe aresredo jak ja vajai fian iji abek? E iji bu na buka dab vajai fian mikrej revo ja vierafega jak jabe ijeg vajai fian abekno kiain? ");
INSERT INTO nvm_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Fu ijeg kuardiamga bu uri kua, No vierafega no aresredo no rekno kuain. Bu ijeg kuardavga Jesu fu uri kia, Na vierafega e buka ire ise iji bu nun rega na vajai fian abekrejo iji bu madu jak jon rega ja ijeg vajai fian abek. ");
INSERT INTO nvm_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Regavo e iji bu ij nun maink ga aizinan ijia karikfuon iji na nar aferdiakva bakin. Regavo ar iji fun e iji Asoinun ijar kenma ijiebuon arno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Regavo tavan ijia e ten (10) iji Jesuon vuak faivo iji bu vuak iji faiva buka deajidiamga bu uri Jeims ko Jon ziegafiain. ");
INSERT INTO nvm_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ijefuon Jesu fu uri e vuak fuon faivo iji kiamga bu besum afuivga fu kia, Ja e Jius bakin ijiebuon e mamkanuk bu ebuon iji bu daro buon ijia samuagdiavo iji jan vierafen. Regavo madu e aiko ijiebuon e mamkanuk iji bu e aiko buon iji daro buon ijia samuagdiavo iji jan vierafen. ");
INSERT INTO nvm_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","45","Regavo igia faif. Unam ijeg kegoijo iji jab arega fu jon ijeg rek. Regavo erar vierafega fu joifuon e bomana rekma e iji fuka ja ifejdiaknum vo joifuon ikrekfuon. Regavo erar fu joifuon e nigen rekro vierafekma e iji fuka e be joifuon ikreno igeg reok. Unam besum ijegvo Ema ijiebuon Farif igi na ruainva iji na e bomana rekro ruainva bakin. Regavo na ruainva iji nam e be fu e befuon ikreno na ijegrekro ruain. Na ruainva iji na kuros ijia guame kavuan nun ijia useme e fok karauniakro na iji ruainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesu fu ijeg Jeims ga Jon kuardiaknum roke mai Jeriko ijia usen. Jesu fun e vuak fuon faivo ijiga e fok buna roko ijiena bun Jeriko useme bun nanusem vakuai roko ijia bu e Timiason farif e Batimias bien. E iji fu e ni nizuriaigin fu unam irif ijia fine e uruvana bu asime vako iji duofuon nimdiam. ");
INSERT INTO nvm_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ijefuon fu fine faik Jesu e Nasaretko iji fu roka fu faime uri uruvana igia kume, E Bomana e Devidon uifarif gari abe nuifuon oifian abene ifejdiek? ");
INSERT INTO nvm_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Fu ijeg kumen revo e ijia roko ijieb uri bijume kua, Isuar igia fine kuain. Regavo fuka uri ma uruvana igia biumame kume, E Bomana E Devidon uifarif gare abe nun oifian abene ifejdiekno kumen. ");
INSERT INTO nvm_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Fu ijeg kumega Jesu fun faime fu vako iji fu ijia areme maniga e iji kia, E gami kume fu rokne kiain. Ijefuon bu e nizuriaigin iji kume, Jesu fu a kumeno ni uri oimarvknum rokne kumen. ");
INSERT INTO nvm_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bu ijeg kumejga e nizuriaigin iji fu uri ugon fuon fu nakaim fino iji ke dab akozme migegare uri Jesuon vain. ");
INSERT INTO nvm_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Fu vakga Jesu fu kua, Na irerag iji redakro a iji vierafenmano kuain? Fu ijeg kuamga e nizuriaigin iji fu uri kua, E nijaidiamo na vierafega a ni nun iji amardiega na una ni naravno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Fu ijeg kuamga Jesu fu uri kua, On a ma vierafeno ijar a keunainmano ni oimarvknum vakne kuamga ni fuon iji fun migegare naramga fun uri Jesu jame unam ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Areme Jesu fun e vuak fuon faivo ijiena bun Jerusarem vakuai roke ar Befas ga Beteni uruor Orivs kuavo samaij ijia usen. Areme Jesu fun uri e vuak fuon faivo iji nokarok (2) vuak igin kuardiain. Fu kia, Va mai gafia useme gaga bu maf-donki be bu abe oijo bakin iji ijia kiraiga iji irame afeme una igi na fijo igia ruaf. ");
INSERT INTO nvm_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Regavo ja iraga e be fu giame kia, Ja irerafuon maf-donki iji iravno kiakma ni kua, No E Bomana ijar tavan ivuankbe vierafenma ijefuon no iji iravdo no una afeme ruakno kuafno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Ijefuon bun va gafia useme gak maf-donki iji bu abe ar vien iji bu aruvo ijia kirainva bu gain. Bu game iravga e iji vien samaij ijia irenva ijieb uri giame kia, Ja erar kiaga ja maf-donki iji iravno kiain? ");
INSERT INTO nvm_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bu ijeg kuardiavga e vuak fuon faivo nokarok (2) iji bu uri vuak izeg Jesu fu kuardiainma ijeg una e iji kuardiavga bu arekoga bu irame una vain. ");
INSERT INTO nvm_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bun irame una Jesu fino ijia useme uri ugon buon bu azan sainva iji rume maf-donki azan ijia riedame arekoga Jesu fu ijia ajie fin. ");
INSERT INTO nvm_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Fun ijia ajie fikoga e fok bu uri ugon buon bu azan savo iji rume unam ijia rieme vain. Bu ijegrekoga e roin bu inak ma iji bu juar buon ijia oinva iji ufuseme unam ijia riesdakoga fu ijia vuim vain. ");
INSERT INTO nvm_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","E roin bu amur vako roin bu rad ja vaknum kume, No Godon if iji abe aroiken. Godri e igi fu E Bomana ijefuon if ijia roko iji daro maken. Fu amur Devid fu saifnuvuon fu samuagdiainma ijeg e igi fu no samuagduokro roko iji daro mak. No God E Bomana kaf ijia fino ijefuon if iji abe ajiekno kumen. ");
INSERT INTO nvm_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Bu ijeg kumejknum Jesu afeme roke Jerusarem ijia useme Jesu fun arime Godon ar bu sirimamejo ijia arume ire fok giamoin. Areme fun ve nakikirega fun uri e vuak fuon faivo ijiena una Beteni ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Areme bun va ijia naoiva suok una roko ijia Jesu fu unam ijia vasiaguain. ");
INSERT INTO nvm_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Fu vasiaguamga fu aibe gamia ruaknum in durim igekin iji bu kua figno kuavo iji be akma manino iji gain. Ijefuon fu urame gaga in fu sunin kirainmaro fu urame vain. Regavo fu ura va gak in iji fum ak ijesugin manin. Ijefuon maiji in iji fu sunin kirakfuon tavan iji fuba ruain. ");
INSERT INTO nvm_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ijefuon Jesu fu uri in iji kua, Aiji a una sunin kiraga e bu ijia tura ikva bano kuain. Fu ijeg kuamga e vuak fuon faivo bu vuak iji fain. ");
INSERT INTO nvm_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","16","Areme bun una roke Jerusarem usekoga Jesu fun name Godon ar bu sirimamejo ijia aruin. Fu arume e iji bu ire kafokafo karme kimejo iji kania kuriairemga bu usen. Fu ijegrene uri e iji mon dame vajuinamivo ijigam e iji um guaf kege kimejo ijiebuon fata iji kam karoidiain. Fu madu uri e iji bu sinuom buon kege Godon ar guf ijia oijo ijin kuriairemga bu aren. ");
INSERT INTO nvm_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Fu ijegrene uri e iji vuak nijaidiame kia, Usuibe Godon vuak ijia bu isoinva iji bu ijeg isoi, Ar nun bu e fok ai kafokafo ijia karioinva iji bu ijia arume Godon sirimamekfuon. Regavo jar ijia aru karine dab e niesavobuon ar igeg amarevno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Fu ijeg kuardiamga e isuf baroijo ijiebuon e mamkanuk ijigam e vuak akai nijaidiavo iji bu vuak ijin fain. Ijefuon bu uri unam izeg bu Jesu kanakfuon iji nisain. Bu unam kuaime nisain revo buka juin ijefuon maiji e fok bu vuak fuon faiva buka oiserdiamga bu oimarvknum vuak fuon faiv. ");
INSERT INTO nvm_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Bu ijegre vake ve nakikrega Jesu fun uri e vuak fuon faivo ijiena mai iji areme vain. ");
INSERT INTO nvm_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Bun va naoiva suok una unam ijia ruaknum in iji Jesu fu amur kuainma iji gak fun sairen. Fu a fuon iji ga kiak fuon fok fuka saire vake gireg gamia kekoin. ");
INSERT INTO nvm_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Regavo Fita fu irerag Jesu fu amur renma iji fun vierafenma ijefuon fu uri Jesu kua, E nijaidiamon garia ga. In gari a kuainma iji fun sairenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Fita fu ijeg kuamga Jesu fu uri e vuak fuon faivo iji kia, Jaka God ma vierafef. Naka ma kuardiav erar fu oifuon ijia ba none ga fum oi besum ma vierafene uruor gari kua, Ni koikon tuame saof gamia uramne kuakma fu rega ja gak. ");
INSERT INTO nvm_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ijefuon igia fai. A ire befuon God sirimame kuakma nin oion ijia ire iji an abenma igeg vierafene sirimamekma ire a kuamo iji a abek. ");
INSERT INTO nvm_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Regavo ja Godon sirimamejo ijia ja ire ise kafo ja kaifjon ijiebuon renva iji vierafekva ni oijon ijia dazme aref. Ja ijegrekva God Asoijon varur gufia fino iji fu ise jon ja renva iji fu giame arek. ");
INSERT INTO nvm_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Regavo ja e kafobuon ise iji jaba giame oijon ijia dazekva God Asoijon varur gufia fino iji fu ise jon ja reoinva iji fuba giame arekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","28","Jesu fu ijeg kuardia barme bun una uri vake Jerusarem usen. Areme Jesu fun una madu va Jerusarem ijia Godon ar bu sirimamejo ijia arume oin. Fu ijia aru oinon ijia e mamkanuk Godon isuf baroijo ijigam e vuak akai nijaidiavo ijigam e mamkanuk kafo bu uri kua, Ire iji a reno iji daro iji a izia abe ren? Regavo erar daro iji a mainmano kuain? ");
INSERT INTO nvm_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Bu ijeg kuardavga Jesu fu una roin kia, Na duna besum kiaga ja una roib kuardiekva na ijarson daro iji na izia abe ire igin reoijo na iji kuardiak. ");
INSERT INTO nvm_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ja vierafega Jon e do ruardiamo daro iji fu abe e do ruardiamo iji fu God o fu emab maiga ni kuardie na faivno kiain? ");
INSERT INTO nvm_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Fu ijeg kuardiamga bu uri dab bui kuaime siguknum kuai, Note una izeg roib kuardak. No uri kuak fu Godri mainmano kuakva fu una kuok revo ja irerafuon ba Jon ma vierafenvano kuok. ");
INSERT INTO nvm_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Rega no kuak daro iji fu emab mainvano kuakva e guri bu izegrekfuon iji no vierafega fuka jufduom. Ijefuon maiji e fok bu ma vierafega e Jon fun ma e Godon vuak vierafene kuaimon be. ");
INSERT INTO nvm_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ijefuon bu una Jesu kua, Noba vierafenvano kuain. Areme fu uri kia, Ijekido na daro igi na izia abe ire igin reoijo iji naba kuardiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Areme Jesu fun uri anerene vuak kafo bijame kuardiain. Fu kia, E be fu moik fuon ijia juai mene fak kira ameoine aren. Rega guf ijia fu ar be madu bu ijia karine juar samuakfuon iji same uri e kafo karga bu juar samuakoga fun ar aibe ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Fu va ijia fine faik i sunin fun kira duinfai fu faime fun efuon ik rejo be kuamga fu i sunin roin fuifuon karekafa vain. ");
INSERT INTO nvm_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Fu vake gafia kekomga e iji in samua karinva ijieb uri e iji kunaime dab fijame arevga fu imut kiriasame una ruain. ");
INSERT INTO nvm_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Areme e iji fun una efuon ikreno be kuamga fu una vain. Fu vakga e iji juar samua karinva iji bu madu e iji vainma iji nigen ijia kaname ka ire ma ise iji fuon ren. ");
INSERT INTO nvm_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Bu ijegrejga e juar koikin iji fu madu una e be kuamga fu vaka bu kanavga fu guain. Bu ijegrejga fu una madu unam besum izeg e roin kiamga bu vakga e roin bu fijiaknum roin bu kaniava bu aoin. ");
INSERT INTO nvm_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Regavo e juar koikin iji fu e radkma iji fu kuaga fu vakfuon iji fu farifuon ma besum fu oijmamo ijin. Ijefuon fu una fuon kuai, Na farinun kuaga fur vakma buba fu kanaken. Regavo bu fu agoime vuak fuon abekno kuaime fun farifuon kuamga radkma iji fur vain. ");
INSERT INTO nvm_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Regavo e iji juar samuame karinva iji bu fu vakga bun game uri bui kuai, E guri fu e juar igi menma ijefuon farif ijin. Ijefuon noka fu kaname asoifuon ijefuon juar fok nor abekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ijefuon bun uri farifuon iji kunaime kanavga fu guamga bun dab juar fak gama akozenvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jesu fu ijeg kuardiame uri kia, E juar koikin iji fu vuak iji faikma fu irerag abek? Fu faikma fu ro kekome e iji juar samua karijo iji kania bu aoiga juar fuon fu una e roin kiaga bur samuakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Areme Jesu fu uri kia, Regavo ja Godon vuak bu usuibe isoinva iji ja davo iji jabe vierafen? Vuak iji bu isoime kuai, E ar savo iji bu kudie ma iji fu manine girekfuon iji bu game vierafero fu isero bu dab akozen. Regavo E Bomana iji fu kudie iji una abenma ijefuon iviakma kudie iji fu ar uf iji biduame manino iji fuka ikin. Regavo iji fuka ma fun E Bomana ijar koikfuon ire iji rena non gainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jesu fu vuak ijin kuardiamga bu ijefuon uri Jesu kunaime tokuai vierafen. Ijefuon maiji bu vierafega vuak iji fu bijame kuaimon iji fu buisina kuaim. Regavo buka e uruvana ijia ruainva iji juinva ijefuon buba ire be fuon ren gavo bu ijia areme vain. ");
INSERT INTO nvm_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ijegrene rad bun e Ferisis roin ga e Erodon e roin iji kiavga bu Jesu biesuame duna kafo kuardakuai ruain. ");
INSERT INTO nvm_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","15","Bu va usem kua, E nijaidiamon no vierafega vuak irerag a kuaimon iji aka vuak ma ijesugin kuaim. Regavo e iji a vuak kuardiamo iji bu e mamkanuk ga e ukaknak iji a juvknum kuardiamo bakin. Regavo aka vuak ma iji izeg God fu e igiebuon vierafenma a ijin e igi nijaidiam. Ijefuon a vierafega akai nuvuon ijia no Sisa e Romkobuon e bomana iji fuon takes abesvo iji kafu maren ki fuba maren? Regavo nobe takes abesek ga no arekfuon iji ni ar kuarduoga no faivno kuain? Regavo Jesu fu vuak kufui buon fun giame vierafen ijefuon fu kia, Ja irerafuon na biesiekuai rej? Ni mon sunin iji abe nijaidie na gavno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Fu ijeg kiamga bu uri mon sunin iji be abe main. Bu abe mavga fu abe nijaidiaknum kia, Igia gaf. Ja gaga uikinik igeko if iji isoinva iji bu erafono kiain? Rega e mamkanuk iji bu uri kua, Fu e Sisaon kuain. ");
INSERT INTO nvm_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Bu ijeg kuardavga fu kia, Ijefuon irerag ja giamga bu e bomana Sisan ga iji ni kege una va fu vajaf. Regavo irerag iji bu Godon ga iji ni kege una God vajafno kiain. Jesu fu vuak mukor ijin kuardiama e fok bu vuak iji faiva buka oiserdiain. ");
INSERT INTO nvm_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Areme e Sejusis roin bu ro Jesu fino ijia usen. Regavo e iji ruainva ijieb kuaiv e iji aoivo iji buba una urijno kuaiv. ");
INSERT INTO nvm_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ijefuon bu usem Jesu duna ijeg kuain, E nijaidiamon Mosis fu kuo, E be fu uviaifuon ijar bara abe am kafo ba tuanaga fu guakma uviaifuon iji fuka bara amun iji abekin fur uviaifuon ijefuon am tuanakno kuin. ");
INSERT INTO nvm_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Regavo tavan be bu e agan besum ijia buka e agan seven (7) ijeg karin. Ijefuon bo buon iji fun bara abene am kafo ba tuanain rega fum guain. ");
INSERT INTO nvm_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","22","Fu guamga uviaifuon ijar fusik bara iji aben gavo fuk fuba am kafo tuanain gavo fum guain. Bu ijegrene am diaifarif fok bu madu bun besum ijegrene vake am diar gamia usen. Am farif seven (7) uruvana bu bara besum iji aben revo bu am kafo ba tuanakoga radkma ijia bara iji fun guain. ");
INSERT INTO nvm_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Regavo a vierafe e uruvana bu bara iji abenva iji tavan iji e aoi vo una uri nivek karijo ijia bara iji fu erafon barakno kuain? ");
INSERT INTO nvm_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Bu ijeg kuardavga Jesu fu una kia, Jaiji jaka ba mukor vierafejo bakin. Ijefuon maiji ja Godon vuak iji jaka ba faiv ga madu ja daro fuon iji fu ire kafokafo reno iji jaba vierafen. ");
INSERT INTO nvm_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ijefuon maiji tavan iji e bu aoime una uri nivek karijo ijia bara baru buba una sanamik. Regavo buka anera iji varur gufia karijo igegrekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Regavo ja e iji bu aoime una urijo ijefuon vuak iji Mosis fu tarar iji mian nainma ijefuon fu isoinma iji jabe dame gain? Mosis vuak iji fu isoinma ijia God fu ijeg kuai, Naiji na e Eburam ga e Aisek ga e Jekaf ijiebuon Godno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Regavo vuak ijefuon maiji God fu e iji aoivo ijiebuon God bakin revo fu e iji bu nivek karijo ijiebuon God ijin. Regavo jaiji jaka ma isema vierafenvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Areme e vuak akai nijaidiamon be fu ijia fido fu faik e iji bu vuak iji dab bui karine kuaiva fu fain. Fu faik Jesu fun e Sejusis ijiebuon duna bu kuainva iji fun una amarigia kuardiama fu fain. Ijefuon fu uri duna be Jesu kuai, A vierafega akaij iji bu nainva ijia akai izar fuka ma bomanakono kuain? ");
INSERT INTO nvm_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","30","Fu ijeg kuardamga Jesu fu uri kua, Akai ma bomana iji igin, E Isrerko iji akai ma bomana iji igino faif. God E Bomana nuvuon iji fun God besum ijesugin fuka E Bomana. Ijefuon jaka oijon ma ijekma ga kaven jon ga vierafe jon ga daro jon fok ijekma God jon iji oijmiafno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Regavo madu akai be ka ma bomana ijefkin iji, Nika izeg a on oijmanamimo ijeg una kaifon roin oijmia. Ijefuon maiji akai nokarok (2) ijieb buka akai mamkanuk bur akai roin bu asidiainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jesu fu ijeg kuardamga e iji fu uri kua, E nijaidiamon vuak iji a kuainma iji anka mukorigia vierafene kuain. Regavo vuak iji a kuai God kafo fu bakin gavo fu God besum ijesugino kuainma iji anka ma kuain. ");
INSERT INTO nvm_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ijefuon noka God ijin oinuvuon ga vierafe nuvuon ga ka daro nuvuon ijekma oijmakfuon. Regavo madu izeg no nuvuon oijmanamivo ijeg no una e roin oijmiakva ijar fuka ma ikin. Akai nokarok (2) ijieb ire fok no kege isuf baroijo iji fuka ma asidiainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Fu ijeg kuaiga Jesu fu gak fuka mukorigia una roin kuardamga fu uri kua, Aiji na gaga anka e iji God fu oibuon iji samuagdiamo ijiena besum mazikafa samairenmano kuain. Jesu fu ijeg kuardiamga e kafo buba una duna kafo kuardain. ");
INSERT INTO nvm_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesu fu vek Godon ar ijia vuak nijaidiamon ijia fu uri e ijia karinva iji duna be kuardiain. Fu kia, E iji vuak akai nijaidiavo iji bu izeg game vierafenva ijefuon bu kuaiv e iji God fu kuaga fu ruakma iji fum e Devidon uifarif ijiano kuaiv? ");
INSERT INTO nvm_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Fun Godon Kaven ijar una Devidon oij ijia vierafe mamga fu kuai, God E Bomana ijar una e bomana nun iji kuak, Ni ro igi ij maink igia fi. A ijia fike na e ani on bu ana nigaraioijo iji kege kaniame ke diak rotit on ijia uniamno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ijefuon Devid fu kokfuon e iji God kuamga fu ruainma iji kua E Bomanakono kuain. Regavo Devid fu izeg una e iji kuak, Aiji a uifarif nuno kuak. Jesu fu ijeg kuardiamga e fok ijia afurvenva buka oimarvknum vuak iji fain. ");
INSERT INTO nvm_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Bu karine faimdakoga fu vuak nijaidiame vake kia, E iji vuak akai nijaidiavo ijiebuon unam bu kegoijo iji amarigia giaknum of. Bu vierafe buka ugon jaoijmana same ar bu duok kimejo ijia oga e bu giame mukorigia agordiame anadiakuai bu iji vierafen. ");
INSERT INTO nvm_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bu ijegreoknum buka ar bu afuime vuak kuaivo ijia fata ma iji kege kariknum ar bu iro ijo ijia fata ma iji kege karioij. ");
INSERT INTO nvm_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bu ijegrejknum bara amun iji biesiame sinuom buon niesamdiaknum buka e nifak ijia jaoijor sirimamega e bu giame arordiakuai bu ijeg reoij. Regavo e ijegreoijo iji God fu kam unam gigikin ijia vajai fian miaga bu vajai fian abekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","42","Ijegrene Jesu fun Godon ar ijia fine giakoga e fok bu ro mavua iji bu mon abesvo ijia mon abesev. E sinuom zarainva uruvana iji bu ro useme mon mamkanuk abese gavo bara amun sinuom bakin iji fu ro mon ukakna nokarok (2) iji kege mavua ijia sain. ");
INSERT INTO nvm_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Fu kege ijia samga Jesu fu game uri e vuak fuon faivo iji kumega bu rokga fu kia, Vuak igi naka ma kuardiav. Bara amun sinuom bakin igar mon iji fu mavua garia sainma ijar e fokigiebuon mon bu sainva iji asidiain. ");
INSERT INTO nvm_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ijefuon maiji e roin bu mon uruvana zarain revo bu mon sibank kege mavua ijia sain. Regavo bara amun gari fu mon ukak fu duok fuon kimekafa na fino iji fun kege mavua ijia sainmano kiain. ");
INSERT INTO nvm_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesu fu Jerusarem ijia Godon ar bomana bu afuime sirimamejo iji areme keko vako ijia e vuak fuon faimo be fu uri kua, E nijaidiamo ar garia ga. Buka mun ma ijia kege ar gari dab mukorigia sainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Fu ijeg kuamga Jesu fu uri kia, Mun besubesum guri bu kege ar guri sainva iji rad buba iji bu name ajienva ijia ijeg naoime vak. Regavo mun fok bu eb bujaga buka uduime arikno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesu fu ijeg kuardiame fun va gara uruor be bu kua Orivsno kuavo ijia fikoga Fita ga Jeims ga Jon ga Edru ijieb isuarigia buonkua fu fino ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Bu ro useme kua, E Bomana ni tavan ivez bu ar iji buja korekfuon iji kuarduo no faiv. Regavo unerag rega no ijia giame vierafero vuak igi a kuarduomo iji fun rekro no ijeg vierafekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Bu ijeg kuardavga Jesu fu uri kia, Ni vuak igi na kuardiavo iji amarigia gavknum of. Jab e iji bu vuak kufui kuaimoijo ijiebuon vuak iji faime jajiak. ");
INSERT INTO nvm_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ijefuon maiji e uruvana bu usem biesiame kia, Naiji na Kurais narno kiaga e uruvana bu uri bu jajiakfuon. ");
INSERT INTO nvm_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Regavo e bu ar samaij ja karinva ijia ga aibe gamia bu bijaimoke ja faik. Regavo igia fai. Ja vuak iji faikva jab uri juk. Ire ijekin iji buka rekfuon. Regavo jab vierafero moikigi fun iviakma barekro jab ijeg vierafek. ");
INSERT INTO nvm_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ijegrekega moik mamkanuk roin bu uri bui bijaik ga ar ukaknak iji bu uri bui bijaik. Regavo ar kafokafo ijia fuka vasia kekome uri moik urak. Regavo ire ise kafokafo ijieb ijeg anerekva iji ni vierafero ire ise ka mamkanuk ijieb rad rekfuon. ");
INSERT INTO nvm_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Regavo madu jaka amarigia jon samuanamiknum of. Ijefuon maiji e kafo bu ro ja tomdiame va e mamkanuk kot samuavo ijiebuon kot rejknum buka ar e Jius bu afuime vuak kuaivo ijia ja kaniak. Regavo madu ja na jajievo ijefuon e mamkanuk moik samuavo ijigam e kin ijiebuon nifak ijia irek. Ja irevo ijia ja vuak ma iji na nijaidiainva ja ijin bu kuardiakfuon. ");
INSERT INTO nvm_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Regavo amur iji enun bu Godon vuak ma iji abe e iji ar iror ijia karioinva iji kuardiaoine barke son rad moikigi fu barekfuon. ");
INSERT INTO nvm_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Regavo tavan iji bu ja aferdiame kot rekvako ijia jab uri vuak ja izeg kuaikfuon iji bomana vierafek. Ijefuon maiji vuak iji ja jar vierafene kuaikva bakin revo fu Godon Kaven ijar vierafe vajiaga ja kuaik. ");
INSERT INTO nvm_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Regavo madu e roin bu uri uviaifijaf aferdiame una e ani buon iji vajiaga bu kania bu aoik. Regavo madu asoifijaf bu uri afijaf kege ijegrekega afijaf iji bu madu uri eofijaf nuigafiame kam una e ani buon vajia bu kaniaga bu aoik. ");
INSERT INTO nvm_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Regavo e fok buka ja amarigia uzak ijefuon maiji ja nuifuon ik reoijo ijefuon bu ijeg rek. Regavo erar fuka giriesame ma vierafene vake buin ijia kekomo e iji God fu keunaga fu ijia ma fivak. ");
INSERT INTO nvm_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Regavo tavan iji ja ar bu sirimamejo guf ijia ire ka ma ise be fu ar iji fu fuon bakin gavo fum ijia manino ja iji gakva ni e Godon vuak vierafene kuaimon e Danier fu kuainma iji vierafef. Ja ire iji gakva ni e uruvana Judia guf ijia karinva iji kiaga bu migegare subinai uruor mamkanuk iji irenva irif ijia vaf. ");
INSERT INTO nvm_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Regavo e iji fu ar fuon azan ijia fino iji fub una arime ar guf ijia sinuom fuon karek. ");
INSERT INTO nvm_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Regavo e be fu juar fuon ijia ikreoino iji fub una ugon fuon fu azan samon iji karekafa vak. ");
INSERT INTO nvm_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Regavo tavan ijia bara iji bu e fudienva ijigam bara iji eraneb bu am gatkin aferdiaoijo iji buka oifian abek. ");
INSERT INTO nvm_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","19","Ijefuon ni God sirimamekin tavan iji iduan urino ijia jaiba subinai vakfuon. Ijefuon maiji tavan ise iji ja vajai fian abekfuon iji fuka ma ise ijar rekfuon. Regavo igia faif. Ire ka ma ise ijekin be fu ik God moikigi amarenma ijia roke iviakma igia fuba ijeg ren. Regavo madu rad ire ka ma ise ijekin be fuba una rekfuon. ");
INSERT INTO nvm_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Regavo tavan iji God fuba una ufume aribatie fu e be erar ni vek fivakma bakin. Regavo fun Godri e iji fu imut bijiainma iji vierafeno ijefuon fu buifuon tavan iji abe ufu una arin. ");
INSERT INTO nvm_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ijefuon e be fu uri kia e iji God fu kuamga fu no karaunuokafa ruainma iji fu gafa roko gafno kiakma jab fu ma vierafek. ");
INSERT INTO nvm_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ijefuon maiji tavan ijia e kafo bu useme ja biesiame kia, Noiji no e iji God fu kuomga no ruainma ijino uri no jajuofno kiak. Rega roin bu usem biesiame kia, Noiji no e Godon vuak vierafene kuaivo ijino kiak. Bu ijeg kuardiame uri anf ga ire sumakin kafokafo rene e ijiebuon oij ga buon ma vierafejo iji buka kam iserek. Regavo bu giriesakva bu e iji Godri imut bijiame kenma ijiebuon oij iji kam iserdiak. ");
INSERT INTO nvm_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Regavo igia faif. Vuak igi na amur kuardiainki rad tavan ijefuon ruakma ja game vierafekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","Regavo tavan iji ja ire ka ise iji biediame barke rad tavan iji fuka una nakikega asam fuba una sanak. Regavo ire uruvana varur gufia girme naoivo iji bu katime uduim arikega mujur iji bu madu varur gufia uduime arik. Regavo ire uruvana varur gufia girenamime naoivo iji buka katikatik. ");
INSERT INTO nvm_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Areme tavan ijia Ema ijiebuon Farif igi na una vana uf ijia daro ga sanainma nun ijekma roga ja giek. ");
INSERT INTO nvm_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ja giakega na anera iji kiaga bu moik igefuon buin ijia ga varur gufefuon buin ijia e iji God fu imut bijiainma iji kanafume afuik. ");
INSERT INTO nvm_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jesu fu ijeg kuardiame uri in makam ijia bijame kia, Nin in makam iji game vierafef. Tavan iji in makam fu a kanamon iji ja game vierafero tavan juar mejo iji fun samairenmaro ja ijeg vierafej. ");
INSERT INTO nvm_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Unam besum ijegvo tavan iji ja ire fok bu rejo iji giakva ja vierafero tavan iji na una ruakfuon iji fuka samaire vo fun ija anerenro ja ijeg vierafek. ");
INSERT INTO nvm_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Regavo vuak igi naka ma kuardiav ire fok na kuardiavo iji e aganjon igi bu iviakma kari roko iji bu vek karike fu rega bu giame radson aoik. ");
INSERT INTO nvm_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Regavo varur gufiga moikigi buka barek revo vuak nun fuba barekgavo fu tavan bog ijia navakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Jesu fu ijeg kuardiame una kia, Tavan iji na una roko iji Godon anera varur gufia karijo iji abevo Godon Farif igi nak madu naka ba vierafen. Regavo fun Godri fuonkua tavan iji vierafen. ");
INSERT INTO nvm_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ijefuon ni uri ni narame nisaiknum karif. Ijefuon maiji ja tavan iji fu ivez rekfuon iji jaka ba vierafen. ");
INSERT INTO nvm_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Regavo na una roko iji na e iji fu ai jaoijor be vakafa uri e fuon ikrejo iji aferdiame ik buon irerag e besubesum bu rekfuon iji nijaidiainma ijekin. Fu nijaidiame vaga e iji vien samuakfuon iji kua, Aiji vien iji samua fiknum ire fok samuagdiake na vaikin una rokno kuame fun vakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ijefuon ni jak ijeg samuame kariof. Ijefuon maiji na ivez una roko iji jaka ba vierafen. Nate nakifuon vo baga ve ufrenma ijia vo baga kukoro kumeno ijia vo baga ve irasemo na ijia ruakfuon iji jaba vierafen. ");
INSERT INTO nvm_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","37","Ijefuon ni amarigia samuame kariof. Na una roga ja vek ni naoinva na giakfuon iji naka isediek. Regavo vuak igi na ja jonkua kuardiavo bakin gavo na e fok kuardiavno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Regavo tavan iji bu iro Fasova ijiga bred iriaikin ire ist bakin iji bu ine una God fu usuibe saifijaf karauniainma iji vierafejo iji fu naki nokarok (2) ijeg vek nam. Ijefuon e mamkanuk iji Godon isuf baroijo ijigam e vuak akai nijaidiavo iji bu isuar sauime Jesu kanakuai vuak kuaime unam nisain. Bu kuai, No tavan iji no iro ijo ijia noba kanaken ijefuon maiji e igia ruainva iji buka deajidiaido bu una no kanuokno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Regavo rad Jesu fun va ar Beteni ijia kekome Saimon e iji ire kasi igekin iji abe barenma ijefuon ar ijia fin. Fu ijia fino ijia bara be fu ire udi mukor urino bu kege mon mamkanuk kimejo iji be abe saror ijia usiame abe fu fino ijia ruain. Fu keko gak Jesu fu duok iga bara iji fu duok iji dab nigen fuon ijia usiamdain. ");
INSERT INTO nvm_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","Fu ijegrega e roin bu ire iji fu reno iji gava buka deajidiain. Ijefuon bu kua, Bara gari fu irerafuon ire maigari fum dab nisem. Fu ire mukor iji fuka arekin abe kime mon bomana abe una e sinuom bakin iji vajiakma fu arenmano kuaime buka fu ziegafain. ");
INSERT INTO nvm_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ijefuon Jesu fu uri e iji kia, Bara garefuon vierafe iji ja irerafuon dab arafirime oifian mav. Irerag fur renma iji fuka nuifuon ire mukor iji ren. ");
INSERT INTO nvm_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ijefuon maiji e iji sinuom bakin iji bu tavan bog igia jana karik. Ijefuon tavan kafo ja bu ifejdiakuai vierafekva iji ja ifejdiak. Regavo naiji naba tavan bog igia jana fiokfuon. ");
INSERT INTO nvm_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ijefuon bara iji fu irerag fu vierafenma fu ijeg ren. Fu ire udi mukor urino igi fu abe na ruardienma iji fu vek igi naba mako arinva ijia fu abe usemdieme amarek. ");
INSERT INTO nvm_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Regavo vuak igi naka ma kuardiav, Ar iror izerkin bu vuak ma igi abe kuaimoijo ijia irerag bara igi fu renma iji bu abe ijia kuaimoijknum fu vierafeokno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Areme e tuer (12) Jesuon vuak faivo ijia e be e Judas Iskariot kuavo iji fu Jesu afeme e ani miakafa vierafen. Ijefuon fun e isuf baroijo ijiebuon e mamkanuk iji karinva ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","E mamkanuk iji bu vuak fuon faiva buka oimadiamga bu kua, No mon a vajakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Regavo tavan iji bu bred iriaikin ire ist bakin javo iji roko ijia e Jius bu iro be bu kua Fasovano kuavo iji ijo. Bu tavan iji roko ijia e Jius bu maf-sif uka iji kania isuf baroijo. Ijefuon e iji Jesuon vuak faivo iji bu tavan ijia useme Jesu kua, A vierafega no izia oifuon duok kanafuga a iro Fasova iji ikno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","14","Bu ijeg kuavga Jesu fu uri e vuak fuon faivo nokarok (2) iji kia, Ni va Jerusarem ijia arume e be fu do jia roko iji bief. Ja biekva nin e iji jame ar guf ijia arume e ai koikin iji kua, E Bomana nuvuon fu a kume ar na enun ijiena iro ikfuon no izia ikno kumenmano kuaf. ");
INSERT INTO nvm_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ja ijeg kuaga fu ar no iro ikfuon iji nijaidiaga ni iro iji no ikfuon iji ijia amarefno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Fu ijeg kuardiamga bun uri vake mai ijia useme irerag Jesu fu kuardiainma iji game ijia jame iro Fasova ijefuon duok kanaufuin. ");
INSERT INTO nvm_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ijegrene fun ve nakisrega Jesu fun e tuer (12) vuak fuon faivo ijiena vake ar ijia usen. ");
INSERT INTO nvm_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Areme bun karine duok ijo ijia Jesu fu uri kia, Vuak igi naka ma kuardiav. E igi ja nana karine duok ijo igia e be fu na abe una e ani iji miaga bu kanie na guakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jesu fu ijeg kuardiamga e vuak fuon faivo iji buka oifiadiain. Ijefuon e besubesum bu uri Jesu kua, E Bomana a vierafega nakafu nar ijegrek ki na bano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Bu ijeg dab kuaivga Jesu fu uri kia, E tuer (12) igi ja nana karinva ijia e besum fu bred fuon abe nosik dis guria abesmo e ijar na abe e ani iji miak. ");
INSERT INTO nvm_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ema ijiebuon Farif igi naiji bu buk akaij ijia bu isoime nuisina kuainva ijeg na bu dab kaniekfuon. Regavo e iji erar fu na abe una e ani iji miakfuon iji naka fuifuon bomana oifiadiem. Ijefuon maiji Godri e iji fu dab unam ise ijia arafirik. Regavo asiefuon iji bu fuba nafebatie iji fuka markno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Areme bu vek karine duok ijo ijia Jesu fu uri bred abe Godon sirimamene oimaren. Areme fu abe tuaseme ke e vuak fuon faivo iji vajiaknum kia, Bred igi fu vajai surif nun igekino ni kege if. ");
INSERT INTO nvm_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Areme fu madu una kafus iji abe Godon sirimame oimarme abe miamga bu in. ");
INSERT INTO nvm_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Bu ijga Jesu fu kia, Ire iji fu kavuan nun igekin. Kavuan nun ijar usega God fu ijia unam iviamkor iji fu e fok ijiebuon ise iji giame arekro kuainma iji fu kavuan nun azan ijia e fok ijiebuon ise iji somdia korekfuon. ");
INSERT INTO nvm_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Vuak igi naka ma kuardiav naiji na iviakma igia gavo una gafeg naba una jana do vuain igi ik. Regavo nason rad tavan iji Godri koikfuon una efuon igi samuagdiakfuon ijia na ar iviamkor ijia jana ikno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jesu fu ijeg kuardiame barekoga bun uri dua rene bun usem uruor Orivs kuavo iji manino ijia vain. ");
INSERT INTO nvm_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Bun va ijia usevga Jesu fu uri kia, Ivia naki e fok ja subinai vaga na ja ijia areme vak. Ijefuon maiji bun buk akai ijia isoime kuain, Bu e iji maf-sif samuagdiamo iji kanaga maf-sif fuon bu dab ataseme vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Regavo rad God fu kiega na una urijo ijia na amur Gareri vake ja rad vuakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Jesu fu ijeg kuardiamga Fita fu uri kua, E guri roin bu a uname subinai vakva naiji naba a uname kovak. ");
INSERT INTO nvm_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Fita fu ijeg kuardamga Jesu fu uri kua, Vuak igi naka ma kuardavo mukoi faif. Ivia naki kukoro fuba kumenma ijia e bu nuisina kuakva a tavan nokbek (3) kia na e iji naba vierafenvano kiake kukoro fu ijiason kumekno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Fu ijeg kuamga Fita fu una darokma kua, Na vierafe bu kanie na osik guakva naba kia aiji naba vierafenvano kiak. Fita fu ijeg kuardamga e iji Jesuon vuak faivo iji bu madu bu uri vuak besum ijeg Jesu kuardain. ");
INSERT INTO nvm_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Areme bun ar bu kua Getsemenino kuavo ijia vain. Bu ijia useme Jesu fun uri e vuak fuon faivo iji kia, Jan igia karike na sirimamejno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Areme fun uri e nokbek (3) Fita ga Jeims ga Jon iji aferdiame vain. Regavo fuka uruvana igia oifiain ga madu fuka oiseren. ");
INSERT INTO nvm_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ijefuon fu uri kia, Oinun iji fuka uruvana igia oifiadiemo iji nakafu na guakfuon. Ijefuon janika igesugin karine na samuagdiefno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Fu ijeg kuardiame are fun fuonkua sibank biom aibe ijia tuame moik ijia dijeme sirimame God kuaga ire afikin fu abekreno iji fuba fuon rekro fu vain. ");
INSERT INTO nvm_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Fun va sirimamene kua, God Asoinun a vierafe fu markma ni vajai fian igi na abekrejo ijigam na guakrejo iji ab arega fu nun roko. Regavo ire iji na nar vierafenva bakin gavo fun on vierafe ijia rekma ni areke fu ren. ");
INSERT INTO nvm_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jesu fu sirimame barme una roga e vuak fuon faivo iji bun ninaoin. Bu ninaoivaga fu giame keko Saimon Fita kua, Saimon a irerafuon ninain? A irerarenma ijefuon aba tavan ivuankbe uri ni narame na samuagdien? ");
INSERT INTO nvm_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Uri koikjo samuanamime sirimameknum kariga kaven ise Setan fu ja biesiakma jaba zazaik. Fu ijeg kuardiame kia, Vuak igi naka ma kuardiav kaven jon iji buka sirimamekuai vierafen revo vajai jon ijieb buka zazaivno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Fu ijeg kuardiame fun una amur fu sirimamenma ijeg sirimamekafa vain. ");
INSERT INTO nvm_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Fu sirimame barme una roga e iji bu ninadiaga ijefuon buka ninaoinva fu giain. Regavo bu uri Jesu gain revo bu vuak irerag kuardakfuon iji buka ba vierafen. ");
INSERT INTO nvm_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Areme fu madu una ro giame kia, Jaiji ja irerafuon vek ninan abej. Jan siban ninaoinva urif. Tavan iji Ema ijiebuon Farif iji na bu abe una e ise reoijo iji miaga bu kaniekfuon iji fun ruain. ");
INSERT INTO nvm_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Regavo e iji fu na abe e ani nun miakfuon iji fun iga roko uriga no vakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesu fu vek manine vuak kuardiamo ijia e vuak fuon faimo be e Judasno kuavo iji fu ijia kekoin. Fu e azikegoijo iji ga e isuf baroijo ijiebuon e mamkanuk ijigam e Jiusbuon e mamkanuk iji bu uniafdainva ijiena kakigam jua magu kege ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Regavo Judas fun vek ijia ujuriame kia, Ja giega na va e izin abe ui miga ja e ijin kunaime amarigia tome afem vafno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Areme Judas fun migegare kekome Jesu manino ijia manine kuai, E nijaidiamo kuame kunaime uimin. ");
INSERT INTO nvm_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Judas fu ijeg kuardako ijia e ani iji bun ijia usem Jesu kunaime toin. ");
INSERT INTO nvm_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Regavo e be ijia manino ijar uri kaki fuon iji darume dab e be e bomana isuf baroino ijefuon ikreno iji ada fuon kana daturain. ");
INSERT INTO nvm_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Rega Jesu fu uri kia, A na e niekiga ja ijefuon jua magu abe na tomdiekuai ruain? ");
INSERT INTO nvm_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Na tavan bog naka e Jiusbuon ar bu sirimamejo ijia aru fine vuak nijaidiaoij revo jaba ijia arume na tofdien. Regavo na vierafe ire fok igi iviakma reno iji fu Godon buk akaij ijia vuak irerag bu nuifuon isoime kuainva iji fuka aresrekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Areme e vuak fuon faivo iji bu ijia magame subinai vain. ");
INSERT INTO nvm_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Regavo e nivek Jesu jaoijo be iji fu ugon fat be dab iruainmado bu usem niriavga ugon fuon iji fu jafekoga fu ijia areme detabar ko vain. ");
INSERT INTO nvm_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","E iji Jesu kunaime toinva iji bun fu afeme e Godon isuf baroijo ijiebuon e bomana e Kaiafason ar ijia vain. Ijefuon maiji e Godon isuf baroijo ijiebuon e mamkanuk ijigam e vuak akai nijaidiavo ijigam e aiko ijiebuon e mamkanuk iji bu ijia besum afuin. ");
INSERT INTO nvm_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Bu Jesu afeme vako Fita fu giaknum aibe gamia jajia roke Kaiafason ar makaf ijia kekoin. Fu ijia e iji juo karijo ijiena mian irua fin. ");
INSERT INTO nvm_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Regavo e isuf baroijo ijiebuon e mamkanuk ijigam e mamkanuk fok kot faivo iji bun uri vuak kufui kafo Jesusina kuaime nisain. Bu kuaime nisaimga fu ise kafo rega bu abe kuros kanakuai ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Regavo buka e uruvana arume Jesuon vuak kufui fuisina kuain revo vuak buon buba abe maren. ");
INSERT INTO nvm_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","59","Areme e roin bu uri vuak kufui igin fuisina kuaime kuai no fai fu kuai na ar igi emab sainva iji bujakore ga naki nokbek (3) barga na una ar be emab sainva bakin iji sakno kuain. Regavo vuak buon bu kuaivo iji buka vek ba abe maren. ");
INSERT INTO nvm_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bu ijeg kuaivga e Kaiafas fu e ijiebuon nifak ijia uri Jesu kua, A vuak igi bu oisina kuaivo ijia a vuak kafo kuak o bano kuain? ");
INSERT INTO nvm_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Fu ijeg kuardamga Jesu fu vuak kafo ba una roib kuardain. Ijefuon e Kaiafas fu una madu kua, Aiji abe ma Godon Farif e iji God fu kuamga fu ruainma ijino kuain? ");
INSERT INTO nvm_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Fu ijeg kuamga Jesu fu kua, Ke iji naiji na ma e ijin. Regavo Ema ijiebuon Farif igi naiji na God e darokin ijefuon ij maink ijia fik. Regavo rad na varur gufia una vana araf ijia ari roga ja giekno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Fu ijeg kuardiamga e Kaiafas fu uri ugon fuon fu sainma iji kuniaim bujain. Areme fu uri kia, Vuak fuon iji non siban fain revo no irerafuon una madu e kafo kiaga bu vuak ise fuon kafo kuarduok? Regavo ja vuak ise kafo fu Godsina kuainma iji jan fain ijefuon ja fu izegarekno kiain? Fu ijeg kiamga e fok bu uri kua, E iji fu kuai fu Godk bu besumno kuaimon ijefuon noka dab kana fu guakno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Regavo e roin bu uri juvit foimadime ugon fat be dab uikinik fuon ijia kiramdame uri imut anume uikinik ijia kanaknum kua, Ni e igi erar a kanainma iji kuramne kuain. Bu ijegrene e juo karijo iji bun usem Jesu afeme dab fijain. ");
INSERT INTO nvm_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Regavo Fita fu Kaiafason ar makaf fak gufa manino ijia barak be Kaiafason ikreno ijar gak Fita fu mian iruame manin. Fu manina bara iji fu game uri kua, Na vierafega a e be Jesu e Nasaretko ijek oinon na gainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Rega Fita fuka feme kua, Na vuak iji a kuaimon iji naka ba fain vo vierafenvano kuame fun kekome vien samaij ijia vako kukoro fu ijia kumen. ");
INSERT INTO nvm_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Regavo bara besum ijar una ijia game uri e ijia irenva iji kia, E igi fu e be Jesuk oina na gainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Rega Fita fuka una madu fen. Areme tavan sibank barko e kafo ijia irenva ijieb uri Fita kua, Eko ak e be fusik oinon ijefuon maiji a e Garerikono kuain. ");
INSERT INTO nvm_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Rega Fita fuka uri God kurame kia, Na ma kufui mekva God fu na abe arafiriek. Regavo nan ma kuardiav e iji naba vierafenvano kiain. ");
INSERT INTO nvm_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Areme tavan iji Fita fu vuak ijeg kuaiko ijia kukoro fu ijia kumen. Areme Fita fu ijia vuak iji Jesu fu amur kuardafe kua a kukoro fuba tavan nokarok (2) kumeke a ijia nokbek (3) kuai na e iji naba vierafenvano kiakno kuainma iji vierafek. Areme fuka uruvana igia oifiaimga fu kekome makaf ijia ka bomana nirain. ");
INSERT INTO nvm_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Areme tavan ik abaisamo ijia e isuf baroijo ijiebuon e mamkanuk ijigam e Jiusbuon e mamkanuk ijigam e vuak akai nijaidiavo ijigam e mamkanuk kot faivo iji bun vuak izeg bu Jesu kana fu guakfuon iji kuaime abe maren. Bu Jesu kunaime dab tome afem una usem Faireton vain. ");
INSERT INTO nvm_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Areme Fairet fu uri Jesu kua, A vierafega aiji an ma e Jiusbuon Kin ijino kuain. Rega Jesu fu uri una roin kua, Ke vuak iji a kuaimon iji an ma kuaim. ");
INSERT INTO nvm_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","4","Fu ijeg kuardiamga e isuf baroijo ijiebuon e mamkanuk iji bu uri vuak ise fuisina uruvana kuain. Ijefuon Fairet fu madu uri Jesu kua, Buka vuak ise uruvana oisina kuaiv gavo abe una roin kuardiak? ");
INSERT INTO nvm_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Rega Jesu fuba una vuak ijefuon roib kuardakafa vierafega Fairet fu iji gama fuka oiseren. ");
INSERT INTO nvm_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Regavo juaivasia besubesum ijia iro Fasova iji bu ijo ijia e Romkobuon e bomana iji fu e aiko bu dibur ijia era bu vierafene kuavo fu ijin kiaga bu usem vako. ");
INSERT INTO nvm_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","8","Regavo e roin bu e Romko ijiena bijaime e roin kaniainva iji bu dibur ijia karij. Regavo e iji dibur karijo ijia e be if fuon iji Barabas. Ijefuon e uruvana ijia afuinva iji bun uri va Fairet fu juaivasia besubesum ijia izegreno ijin kuardain. ");
INSERT INTO nvm_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Bu ijeg kuardavga Fairet fun uri kume, Ja vierafega na Jesu e Isrerkobuon Kin iji keunaga fu vakno kumen? Regavo Fairet fun vierafega bu Jesu oisema vierafene funa nigaraioijo ijefuon bu fu afeme fuon ruain. ");
INSERT INTO nvm_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Regavo e isuf baroijo ijiebuon e mamkanuk iji bu uri e uruvana soisoi kuardiame kia, Jaka e Romkobuon e bomana iji kua no vierafe a e Barabas keunaga fu vakno kuaf. ");
INSERT INTO nvm_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Bu ijeg kuavga Fairet fu una madu uri kia, Regavo ja e guri ja kume fu e Jiusbuon Kin no kumenva iji fuiji na abe izeg rek? ");
INSERT INTO nvm_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","14","Fu ijeg kiamga bu kume, Abe kuros kanafno kumen. Rega Fairet fu una kia, E igi fu ise irerag iji renma ijefuon ja abe kuros kanakrejno kiain. Rega buka uri uruvana igia biumame kume, Abe kuros kanafno kumen. ");
INSERT INTO nvm_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Rega Fairet fu vierafe fu irerag e uruvana oimardiakfuon ijia rek. Ijefuon fu Barabas buifuon kuama fu vakoga fu uri e azikeoijo iji kiamga bu Jesu dab fijame afem usem abe kuros kanakuai vain. ");
INSERT INTO nvm_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Areme e azikeoijo iji bun uri Jesu afeme dab usem una Faireton ar mai makaf bu kua Faitoriamno kuavo ijia ruain. Areme bu uri e azikeoijo uruvana kumejga bu besum afuin. ");
INSERT INTO nvm_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","18","Bu besum afuime uri ugon jaraikin kavuan iji dab abesdame uri kiej ufu abe atevene dab Jesuon nigen ijia abesdain. Areme bu uri kua, Aiji a e Jiusbuon Kin bomana ijefuon no if on abe ajiev! ");
INSERT INTO nvm_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bu ijegrene uri guduar dab nigen ijia kukma kanaknum juvit foimadime ato same kurituamajain. ");
INSERT INTO nvm_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bun dab varaimene barme uri ugon kavuan bu abe abesdainva iji kunaim darumdame una ugon ma fuon iji kege samdain. Areme bun afeme usem kuros kanakuai vain. ");
INSERT INTO nvm_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Bu Jesu afeme unam ijia vako ijia bu Saimon e Sairinko iji fu ar fuon areme una Jerusarem roko iji bieme kuriairevga fu Jesuon kuros iji abe dabe vain. (Regavo e Saimon fu Areksedako Rufasbuon asoij). ");
INSERT INTO nvm_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Fun kuros iji abe dabemga bun afeme roke ar Gorgota kuaivo ijia usen. (Rega if Gorgota ijefuon maiji uruor iji fu e nigen an igekin.) ");
INSERT INTO nvm_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bu ar ijia useme uri do vuain iji abe inak kugi kafo amarme abe maga fu inkin fuba vajai fian abekro bu ijeg ren gavo fuba in. ");
INSERT INTO nvm_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Areme e azikeoijo bun uri Jesu dab kuros kaname uri Jesuon ugon iji kam name kas dab akozga are erar kega bu gakuai ijefuon bu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Regavo veni iji fun ajie kaf garia ruainma ijia bu Jesu abe kuros kanain. ");
INSERT INTO nvm_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Regavo vuak iji bu fuisina kuaime isoinva iji bu ijeg isoi, E igi fu e Jiusbuon Kin ijino kuain. ");
INSERT INTO nvm_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Regavo madu bu e niekin nokarok (2) kege Jesuna kuros kaniain. Be bu abe ij maink ijia kanaga be bu abe ij azinak ijia kanain. ");
INSERT INTO nvm_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Bu ijegrejga vuak iji bu usuibe buk akaij ijia isoime kuai, Fuiji bu abe e ise reoijo ijiena kamainvano kuainva iji fuka ijekma aresren. ");
INSERT INTO nvm_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Regavo e roin bu unam iji bu Jesu abe kuros kanainva samaij ijefuon roko. Ijefuon bu usem game nigen kativknum dab varaimene kuain. E gare ar kuaim a Godon ar bu sirimamejo iji bujame vo naki nokbek (3) una same barekno kuain. Ijefuon ni koikon keunanami kuros iji areme una ari roga no gavno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Unam besum ijeg e iji isuf baroijo ijiebuon e mamkanuk ijigam e vuak akai nijaidiavo ijieb buon afuime Jesu dab ijeg varaimene kuai, Fu e roin karauniain gavo fu koikfuon keunanamikfuon iji fuka ba aresrenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Regavo bu madu kuai, Ni arekega e gari God kuamga fu ari ruainma iji ga E Isrerkobuon Kin iji fu kuros ijia ari roga no game ma vierafejno kuain. Regavo e niekin nokarok (2) iji bu ke funa kuros kaniainva iji buk bu unam besum ijeg una Jesusina vuak ise kuain. ");
INSERT INTO nvm_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","34","Bu ijegrene roke tavan uk maniko ijia vana utime okoga ar fok fuka ve naki vake tavan ura gura manin. Fu gura manino ijia Jesu fuka uruvana igia biumame kume, Irai Irai rama sabatanino kumen. (Regavo vuak ijefuon maiji God nun God nun a irerafuon na unieko vain). ");
INSERT INTO nvm_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Fu ijeg kumega e kafo ijia irenva iji bu iji faime kuai, Iji fu e Eraija kumeno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Regavo e be fu una kukum keko atebu abe in buin ijia bijame abe do vuain ijia abesme abe Jesuon ir ijia aziga are fu iga fu gakafa. Areme fu uri kua, Ni arekega Eraija fu ro fu keunaga no gavno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Fu ijeg kuaikoga Jesu fu una uruvana igia biumame arekoga kaven fuon fu ijia uname vakoga fu guain. ");
INSERT INTO nvm_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Fu guako ijia ugon iji bu abe ar bu sirimamejo guf ijia arume kirainva iji fu dab uf ijia bujame ari roke buin gumia kekoin. ");
INSERT INTO nvm_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Rega e azikeoijo ijiebuon e bomana iji fu ijia manine Jesu nikajamo iji fu Jesu fu kumeno iji faimevo izeg fu guainma iji game kuai, E guri fuka ma Godon Farifno kuain. ");
INSERT INTO nvm_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Regavo bara uruvana bu aibe gafia ireme giav. Regavo bara iji ruainva iji bara Meri Megdarinko ga bara Sarom ga bara Meri e Jeims e ukak ijiga Josof buon asie ijieb ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Regavo bara ijieb amur gamia Gareri Jesu jame oijknum samuaoin. Regavo madu buka bara uruvana gamia Jerusarem jame ruainva iji bu ijia buna iren. ");
INSERT INTO nvm_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Areme fun tavan nakikreno ijia e Josof e Arimatiako iji fu ruain. E iji fu e ikin be ga fu e Jiusbuon e mamkanuk ijiena fino. Regavo madu fuka tavan iji God fu una efuon ijiebuon oij iji samuagdiakfuon iji samuaoino ijin. Regavo nakifuon iji bu tavan Sabat (Satade) iji bu isuar karine God sirimamejo ijefuon duok kanaufuvo. Ijefuon Josof fu Jesuon vajat surif jafe arikafa fun zinunba Fairet kuakafa vain. ");
INSERT INTO nvm_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Regavo Fairet fu Jesu fu guainma iji faime fuka ba ma vierafen ijefuon fu e azikeoijo ijiebuon e bomana iji kumena fu rokga fu kua Jesu fube ma guainmano kuain? ");
INSERT INTO nvm_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Fu ijeg kuamga e iji fu kua, Ke Jesu fun ma guainmano kuain. Ijefuon Fairet fu Josof kua, Ni va Jesuon surif jafe arimne kuain. ");
INSERT INTO nvm_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Fu ijeg kuardamga Josof fu va Jesuon surif kunaim jafene ugon iviamkor ijia abe utin. Areme fu abe va munuag be bu kajuame amarenva ijia unain. Fu abe ijia uname uri mun bomana be mako vien ijia namo iji vaja dab vien iji bijukurain. ");
INSERT INTO nvm_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Regavo bara Meri ar Megdarinko ijiga Meri e Josofon asie ijieb Jesu bu abe unainva iji gain. ");
INSERT INTO nvm_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ijegrene tavan Sabat (Satade) iji bu isuar karine God sirimamejo iji fun barekoga bara Meri ar Megdarinko ijiga bara Sarom ga e Jeimson asie Meri iji bun inak udi mukor urino iji kafo Jesuon vajat surif iji azirdakuai kimen. ");
INSERT INTO nvm_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","3","Areme Sade suok tavan ik abaisamo ijia bun Jesu bu mako ruinva ijia vain. Bu unam ijia vaknum bui kuai, Erar mun gami bu abe mako vien iji bijukurainva ijin biom iken abededuokno kuain? ");
INSERT INTO nvm_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","5","Regavo bu vake ar Jesu bu mako ruinva ijia usem gak mun ka bomana iji bun biom dab iken abedenvaga bu name mako guf ijia aruin. Bu arume gak e nivek ugon abaikin sainma ijar mako guf iji imut maink ijia fina bu game ka juin. ");
INSERT INTO nvm_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","7","Buka juvga fu kia, Bara gurie jab juk. Na vierafe ja Jesu e Nasaretko iji bu abe kuros kanainva iji nisaimoij. Regavo ar igi bu fu abe unainva igia gaf. Fu igia fu bakin revo fun una urin. Ijefuon ni una va e vuak fuon faivo iji ga Fita iji kia fun amur fu kuardiainma ijeg fun Gareri vakno ni va ijia biefno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ijefuon bara iji buka oiserdiame dejufdiamga bu usem kukume una vain. Regavo irerag bu gainva iji buka ba e kafo kuardiain ijefuon maiji buka dejufdiain. ");
INSERT INTO nvm_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesu ik fu urinma iji fu bara Meri ar Megdarinko iji fu kaven ise seven (7) bu fu niroivga fu kuriairemga bu bara iji areme usem vainva iji bien. ");
INSERT INTO nvm_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Fu biemga bara iji fun va e iji bu funa oinva iji bu oifian abeknum niraivo ijin kuardiain. ");
INSERT INTO nvm_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Fu kuardiame kia, Jesu fun una uri nivek fina na gainvano kiamga e iji bu vuak fuon iji faime buka ba ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","13","Areme rad Jesuon uikinik fu una nibe rene e nokarok (2) bu ai be vakuai unam ijia vako fu iji biediame buna vuak kuaiknum vain. Regavo e nokarok (2) ijieb una ro usem e vuak fuon faivo roin iji Jesuon vuak iji kuardiain gavo buka ba vuak buon ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Regavo rad e ireven (11) vuak fuon faivo iji bu karine duok ijo ijia Jesu fu ijia ruain. Fu ijia kekome vuak kuriaikuriaiki kuardiain ijefuon maiji fuka tavan bog fu guame una uri nivek fivakfuon vuak iji fun kuardiain gavo buka vek ba ma vierafen. Regavo fu madu uri e iji bu fu bieme una ro bu kuardiavo buba ma vierafenva ijefuon vuak kuriaikuriaiki kuardiain. ");
INSERT INTO nvm_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","16","Areme Jesu fu uri kia, Va ar iror ijia vuak nun ma iji abe e fok kuardiaof. Erar fu oi dakaroime na ma vierafene do ruaikma e iji God fu keunak. Regavo erar fuba na ma vierafekma God fu e iji abe vajai fian mak. ");
INSERT INTO nvm_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","Regavo e iji eraneb bu na ma vierafejo iji buka ire sumakin kafo rek. Bu if nun ijia kaven ise iji kiaga bu usem vak vo madu buka isama kafokafo kuaik. Regavo madu tabar jakia vo bu imag ikva iji buba aoik. Regavo e iji eraneb bu na ma vierafejo e ijieb bu e iji adam abejo iji imut nigen namdiaga bu madiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","20","Jesu fu vuak ijin kuardiame rad fu uri varur ijia va Godon ij maink ijia fin. Regavo e vuak fuon faivo iji bun usem ai kafokafo ijia Jesuon vuak ma iji abe e fok kuardiaoin. Bu kuardiavga e fok buka Jesu ma vierafen ijefuon maiji bu buonkua ikreoinva bakin gavo fu E Bomana ijar ifejdiako bu ire sumakin uruvana reoin. ");
INSERT INTO nvm_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Eko Tiofiras e uruvana bun giriesame ire iji igia nuvuon renma iji bun isoin. ");
INSERT INTO nvm_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Regavo vuak iji bu isoime no kuarduinva iji bu e gami bu ik amur ijia ire ma iji giame abe kuarduo ruainva ijieb isoin. ");
INSERT INTO nvm_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ijefuon e bomana Tiofiras na vek ik amur ijia unam iji nan amarigia gain. Ijefuon na vierafega naka izeg Jesu fu reoknum nijaidiaoinma na iji abe amarigia isoime a nijav. ");
INSERT INTO nvm_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Rega fas iji na ijeg isoinva iji na vierafero na ijeg isoikin a unam ma iji bu nijaidiainva iji a ma vierafekro na iji isoin. ");
INSERT INTO nvm_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ijegreare tavan iji Erod fu e Judiakobuon e bomana renma ijia Zekaraia fu e Godon isuf baroino iji rene e Abijan uifarif ijiena ik ren. Regavo bara fuon Erisabet fuk fu e Eronon uifarif be. ");
INSERT INTO nvm_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bu busik besum E Bomana God fu oimarkfuon ijia karioknum vo buka akai fuon iji ga vuak fuon fok mukor igame karioin. ");
INSERT INTO nvm_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","No barakin iji bu am bakin ijefuon maiji Erisabet fun abiten gavo madu bun eoradiain. ");
INSERT INTO nvm_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Regavo ve be Zekaraia fu tavan fuon fu ikrekfuon iji rokga fun Godon ar ijia ik ren. ");
INSERT INTO nvm_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","10","Regavo izeg bu akai buon ijia bu e karevo ijeg bun fu aben. Ijefuon fuiji ik fuon iji fu ire udi mukor urino iji kege fata ijia baroinon. Ijefuon fu E Bomana Godon ar guf ijia arume vain. Fu arume ire udi mukor urino iji kege jako e uruvana bu makaf ijia karine sirimamen. ");
INSERT INTO nvm_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Fu ijegreno ijia fu E Bomana ijefuon anera iji gain. Anera iji fu fata iji bu ire udi mukor urino iji javo imut maink ijia manin. ");
INSERT INTO nvm_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Fu ijia manina Zekaraia fu gama fuka oisereme ka bomana juin. ");
INSERT INTO nvm_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Fu jumga anera iji fu uri kua, Zekaraia jumo aremne kuain. Ijefuon maiji God fun on a sirimameno iji fain ijefuon barakon Erisabet fu oifuon am farif be nafega if fuon a Jon kuak. ");
INSERT INTO nvm_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Barak on iji fu am iji nafekma ja ga e uruvana jaka ma bomana oimarkfuon. ");
INSERT INTO nvm_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Regavo Godon nifak ijia fuiji fuka ma e bomana reken. Fu vuain ga do kugi kafo fuba ik. Regavo tavan iji bu fu nafekva ijia fuka Kaven Akai ijar oifuon ijia rareken. ");
INSERT INTO nvm_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Fur efuon Isrerko uruvana aferdiame una E Bomana God buon ijefuon ruak. ");
INSERT INTO nvm_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Fu usuibe Eraija e Godon vuak vierafene kuaimon fu e darokin renma ijeg fu daro abene amur E Bomana ijefuon unam iji amarme vak. Regavo fur am ijigam asoifijaf iji aferdiame una agan besum rek. Regavo madu fur e iji bu God ba igavo iji aferdiame una unam ma ijia uniak. Rega fur E Bomana ijefuon e uruvana aferdiame ke amardiaga bu una E Bomana iji samuakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Anera ijar ijeg kuardamga Zekaraia fu una kua, Naiji nan eorega bara nun fuk fuka ma barasrenma kuain. Regavo ire iji a kuaimon iji fu izegrekno kuain? ");
INSERT INTO nvm_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Regavo anera iji fu urine kua, Naiji na Gebrior anera iji Godon nifak ijia manino iji nar. Godri na kiega na vuak ma iji abe igia a kuardakro ruain. ");
INSERT INTO nvm_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Regavo a vuak nun igi na kuardavo iji aba ma vierafeno ijefuon iviakma a vuak kafo aba kuaik. Regavo am isuar fivake bu am iji nafekva ijia ason una vuak kuaik. ");
INSERT INTO nvm_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Zekaraia fu ijegreko e iji bu samua karinva iji bu vierafero fute Godon ar guf ijia aru irerag abenoro bu ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Fu ijegreare fu kekome ba vuak kafo kuardiama bu vierafero kafu Godon ar guf ijia ire be nimamaime gainmaro bu ijeg vierafen. Regavo Zekaraia fu vuak kuardiakrena fuka iseremga fum imut ijia kuardiain. ");
INSERT INTO nvm_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ijegreare fu Godon ar ijia ik fuon fu reno iji fun baremga fun una ar fuon ijia vain. ");
INSERT INTO nvm_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ijegrene naki sibank barko ijia bara fuon Erisabet fu e fudiene ar fuon ijia fikok vake asam imut roin (5) baren. ");
INSERT INTO nvm_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ijefuon fu uri kuai, Iviakma E Bomana ijar na ifejdieme unam ijin ren. God fun na mardienma ijefuon na e uruvana ijiebuon nifak ijia na e fudienva iji na jukfuon iji fun fur abe vainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Erisabet fu e fudiene fivake asam imut roin ga nikit (6) ijeg barko ijia God fu anera Gebrior kuamga fu ar Nasaret vain. Rega ar iji fu moik Gareri guf ijia. ");
INSERT INTO nvm_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Regavo iji fu vainma fu bara be fuba baruna naino iji bu e Josof kuainva ijefuon vuak abe vain. Rega e Josof iji fu Devidon uifarif revo bara ijefuon if iji Meri. ");
INSERT INTO nvm_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ijefuon anera iji fun va kekome Meri kua, Makarijo iji fu osik. E bomana iji fu osik fino ijefuon fur daro mame unam ma ijin on renmano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Regavo Meri fu vuak iji anera ijar kuardainma iji faime uri bomana vierafero anera fu irerafuon izeg anadiamro fu iji vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ijefuon anera iji fun uri Meri kua, Ab juk aiji fun Godri oi fuon ijekma a mainma ijefuon fur a oijmame mardain. ");
INSERT INTO nvm_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Aiji ason rad e fudiene am farif be nafek ga if fuon a Jesu kuak. ");
INSERT INTO nvm_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Regavo fuiji fuka E Bomana rene vo bu fu kua E Bomana God kaf gufia fino ijefuon Farifno kuak. Rega E Bomana God fu izeg saifuon Devid fu e bomana renma ijeg fu kuaga fur E Bomana rek. ");
INSERT INTO nvm_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Regavo fur ka ma E Bomana rene e Jekafon uifarif iji samuagdiaknuvo fur ire fok samuagdiame ijia fivak. ");
INSERT INTO nvm_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Anera ijar ijeg kuardamga Meri fu una kua, Naiji naba baruna naijo gavo vuak iji a kuardiemon iji fu izeg nun rekno kuain? ");
INSERT INTO nvm_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Meri fu ijeg kuamga anera iji fu una roin kua, Godon Kaven iji fu a nirokame daro maga a daro abek. Ijefuon am akaij iji a nafekma fu Godon Farif rek. ");
INSERT INTO nvm_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Regavo igia fai. Aganon be bara Erisabet fuiji e bu kua fu e uibitenmano kuain. Fuiji fuka ma barasren gavo iviakma fun asam imut roin ga nikit (6) ijeg e fudien. ");
INSERT INTO nvm_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Regavo God fu ire besum revo ire kafo fu aremo bakin revo fuka e ire uruvana reno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Anera fu ijeg kuardamga Meri fu una kua, Na tavan uruvana God vuak irerag fu kuardiemon iji na rejo ijefuon vuak irerag a kuardiemon iji na vierafega fuka nun rekno kuain. Fu ijeg kuardamga anera iji fu ijia areme vain. ");
INSERT INTO nvm_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ijegreare tavan ijia Meri fun migegare sinuom fuon kanafume fun mai be bu uruo kaf ijia karinva ijia vain. Regavo mai iji fu ai Judia guf ijia. ");
INSERT INTO nvm_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Fu va ijia kekome Zekaraian ar ijia ajie Erisabet anain. ");
INSERT INTO nvm_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Meri fu Erisabet anaiko am ijar Erisebeton defok ijia katin. Regavo Erisabet fuka Kaven Akai ijar oifuon iji samuamo ijefuon fun uri uruvana igia kume, Aiji aka bara uruvana ijiebuon araf ijia if on fuka ma bomana rekfuon. Regavo amon iji fuk if fuon fuka ma bomana reken. ");
INSERT INTO nvm_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","A E Bomana ijefuon asie iji ar na giekafa ruain. Regavo irerafuon ire ka ma sumakin igi fu nun ren? ");
INSERT INTO nvm_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","A na giekafa ruainma ijia na faik am igi fu ijia katin. ");
INSERT INTO nvm_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Rega iviakma aiji anka oimarek ijefuon maiji a irerag God fu rekno kuainma iji aka ma vierafenma ijefuon ire iji fuka on rekno kumen. ");
INSERT INTO nvm_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Areme Meri fu uri kuai, Naiji na oinun ijekma E Bomana God nuvuon fu no karaunuinma ijefuon oimardaknum fuon oimaren. ");
INSERT INTO nvm_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Regavo madu if nun fu ma ukakbe gavo fun Godri na imut bijienma ijefuon ire ka bomana iji fu nun ren. Ijefuon rad e uruvana bu ire ma iji God e darokin iji fu nun renma ijefuon bu na kiek bara oimarmo ijino kieken. Ijefuon vo tavan uruvana Godon if akaij iji dab aroik. ");
INSERT INTO nvm_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","E uij kafokafo ijia Godon ma rediamon iji fu e iji bu fu juvknum igavo ijin nijaidiamon. ");
INSERT INTO nvm_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Regavo fur daro fuon ijia ire mamkanuk ijin re vo madu fur e aroikaraoijo ijiebuon vierafe iji kam karoimon. ");
INSERT INTO nvm_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Fu ijegrene uri e iji bu e mamkanuk moik samuagdiavo iji ke arigavo e oi naiki ga e ma iji kege ajie uniain. ");
INSERT INTO nvm_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Fu ijegrene uri e iji bu vasia oriainva iji duok ma iji vajiaga e iji ire uruvana zarainva iji fum kiamga bu imut kiriasame vain. ");
INSERT INTO nvm_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Fu usuibe Eburam ga uifarif fuon vuak ma iji fu ifejdiakro kiainma iji fun ijekma aresredo fu bu ifejdiak. Regavo fum efuon Isrerko ijiebuon oifian abene mardiain. Ijefuon maiji fu Eburam ga uifarif fuon iji fu ifejdiakafa kiainma ijefuon fu buon oifian abene tavan uruvana bu mardiaknum ifejdiak. ");
INSERT INTO nvm_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meri fu asam nokbek (3) Erisabetk fine fun una ai fuon ijia vain. ");
INSERT INTO nvm_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ijegreare Erisabet fun tavan iji fu amfuon nafekfuon iji rokga fun am farif nafen. ");
INSERT INTO nvm_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Fu am iji nafega e ai samaij ijia karinva iji abevo kaifijaf uruvana bu ire mukor iji E Bomana fu bara Erisabeton renma iji faime buka fuon bomana oimaren. ");
INSERT INTO nvm_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ijegreare fun naki eit (8) barekoga bun am iji abe vajai fuon ijia anf abedeme abe asoifuon Zekaraia nabui kuai vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Bu ijeg vierafen gavo asiefuon ijar uzame kia, Na if fuon iji na Jon kuakro vierafenvano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Fu ijeg kuardiamga bu una kua, E uifarifon ijia if iji fu bano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ijegreare bu uri asoifuon imut ijia nijaime kua, A vierafega no am igi no era kuakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Bu ijeg kuardavga Zekaraia fu uri imut ijia nijaidiame fefafuo kiamga bu abe mavga fu ijia isoime kia, If fuon Jon no kiama e uruvana buka oiserdiain. ");
INSERT INTO nvm_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Areme tavan ijia Zekaraia fu una vuak kuaime uri Godon if abe ajieme fu oimardain. ");
INSERT INTO nvm_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ijegrekoga e ar samaij ijia karioinva iji buka oiserdiamga bu uri vuak iji abe Judia guf ijia kuardiame vain. ");
INSERT INTO nvm_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Rega e uruvana bu vuak iji faime dab karine vierafeknum kuai, Am iji kafu rad irerag abek? Ijefuon maiji no samakaf gaga Godon daro iji fun fusikno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jonon asoi Zekaraia fu Godon Kaven ijar oifuon ijia arimga fu uri Godon vuak ma igi kuai. ");
INSERT INTO nvm_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","No E Bomana ga e Isrerkobuon God ijefuon oimare vo ifuon abe ajiek! Fur efuon bu ise ijar kuniaim girenma ijia ifejdiaknum karauniakafa ruain. ");
INSERT INTO nvm_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Godri nuvuifuon e darokin iji fur no karaunuokfuon iji kuamga fu ruain gavo fuiji fu e Devid e Godon ikreno ijefuon uifarif. ");
INSERT INTO nvm_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Regavo usuibe e akai Godon vuak vierafene kuaivo iji bu ijeg kuain. ");
INSERT INTO nvm_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Fur e ani iji bu nuvuon isemareknum ziegafuovo iji fur karaunuokno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Regavo Godri sai nuvuon Eburam ujuime kua, Nar unam akai iviamkor ja nana besum rekfuon iji vierafene kuainvado na uifarif on iji oijmiame ifejdiakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Regavo madu fu una ujurduome kuo, Na e ani iji bu ja isemareknum ziegafiavo ijia karauniakno kuain ijefuon noba juvknum ik fuon rek. Regavo madu noka e akai rene una unam fuon ma ijia tavan bog ijia karivak. ");
INSERT INTO nvm_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","77","Aiji a farinun ga aiji bu kua E Bomana God kaf gufia fino ijefuon vuak vierafene kuaimon ijino kuak. Regavo ar amur vaknum E Bomana ijefuon unam iji amarme vaken. Regavo ar efuon iji kuardiame kia, Ja ise jon iji areme una oi karoigakva fu giame ja karauniak. ");
INSERT INTO nvm_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Ijefuon God nuvuon fu e ifejdiamo ga oijmiamon. Ve nakinman ijia tavan fu kekome ijia sanaga nakinman iji fu iraseme vakon ijeg e no karaunuokfuon iji fu ijeg ruak. Regavo noiji no ise nuvuon ijefuon nakinman ijia karin. Regavo non aoikuai juvo ijia E Bomana nuvuon ijar nakinman no karijo ijia unam iviamkor no afurvene ma karivakfuon iji amarme no karaunuin. ");
INSERT INTO nvm_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Jon fun ofrene e darokin renma ijia unam fuon fu God ma vierafeno iji fuk bomana rene darokin ren. Ijegreare fu ai moikum namo ijia fine una e Isrerko ijia anerene Godon vuak ma iji kuardiame oin. ");
INSERT INTO nvm_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Areme tavan iji e Ogastas fu e bomana renma ijia fu kiamga bu moik kafokafo iji e Romko bu samuagdiavo ijia e dame vain. ");
INSERT INTO nvm_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Regavo tavan iji bu e damoinva ijia e Kuirinias fu e Siriakobuon e bomana ren. ");
INSERT INTO nvm_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ijefuon e uruvana bu mai buon bu nafediainva ijia va ifbuon vajiaga bu isoikuai vain. ");
INSERT INTO nvm_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Ijefuon e mamkanuk e daoijo iji bu usem Josof kua, Aiji a e Devidon uifarif be ijefuon ni una va Betriem ar bu sat on Devid nafenva ijia if on isoimne kuain. Ijefuon Josof fun bara Meri kaifuon iji afeme Nasaret Gareri guf iji areme una Betriem Judia guf ijia vain. Regavo bara Meri e Josof fu abekno kuainva iji fun fudien. ");
INSERT INTO nvm_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Regavo bu vek Betriem karinva ijia am fu nafekfuon tavan iji fun ruain. ");
INSERT INTO nvm_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Bu ijia vain gavo ar bu naoikfuon iji fuka ba aresren ijefuon bu kiavga bu una mabuon ar ijia vain. Ijegreare rad bara Meri fun am farifuon amur iji nafene abe ugon ijia anume abe mavua guf iji bu maf-kau duok vajiavo ijia unain. ");
INSERT INTO nvm_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Rega tavan ijia e maf-sif samuagdiavo iji buk bu ar ijia naki maf-sif iji bu kege fak kirakuriainva iji samuagdiaoij. ");
INSERT INTO nvm_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bu ijegreoijo ijia E Bomana ijefuon anera be fu bu oijo ijia ruakoga E Bomana ijefuon sanainma iji fu ijia sanama buka bomana juin. ");
INSERT INTO nvm_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Bu ijeg juvga anera iji fu uri kia, Jab juk igi na ruainva iji na joifuon vuak ma iji abe ruain. Regavo e uruvana bu vuak maigi faikva buka oimarek. ");
INSERT INTO nvm_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ijefuon ivia e Devidon mai ijia e iji e karauniakfuon iji bun nafen revo e iji fu E Bomana Kurais. ");
INSERT INTO nvm_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Regavo ja izeg fu game ma vierafekfuon iji ijeg am iji bu abe ugon ijia anume abe mavua bu maf-kau duok vajiavo ijia unainva iji ja gakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Anera iji fu vuak ijeg kuardiame barekoga migegare bu gak anera ma uruvana bu Godon dua oimarvo iji uruknum varur ijia ari roka bu giain. ");
INSERT INTO nvm_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Regavo anera iji bu dua be ijeg roin, No God e iji kaf gufia fino iji abe aroiv gavo God fu efuon iji fu oimardiamo iji ifejdiame samuagdiaga bu afuim kariok. ");
INSERT INTO nvm_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ijegreare Godon anera iji bun areme una varur gufia ajie vakoga e iji maf-sif samuagdiavo iji bu una bui kuai, Ruano va Betriem usem ire iji renma E Bomana fu kuarduinma iji gavno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","17","Bu ijeg kuaime bun migegare vake Meri ko Josof biediame gak am iji fu mavua bu maf-kau duok vajiavo ijia nam. Fu ijia namga bu game urine am ijefuon vuak iji Godon anera fu kuardiainma iji Meri ko Josof kuardiame uri e uruvana Betriem karinva iji kuardiain. ");
INSERT INTO nvm_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","19","Ijegreare e uruvana bu vuak iji faiva buka oiserdiain revo Meri fuk uri ire uruvana iji renma iji fum oifuon ijia vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Rega e iji maf-sif samuagdiavo iji bun vuak irerag Godon anera bu kuardiako bu faivknum giainva ijefuon dua oimarvo iji uruknum God aroime if fuon abe ajieknum bun una vain. Ire fok bu faiknum giainva iji anera ijieb kuardiainva ijin. ");
INSERT INTO nvm_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ijegreare vuik besum barekoga bu am iji abe vajai surif fuon iji kana ufume anf abeden. Bun ijegrene uri if fuon iji fuba nafeko ijia Godon anera iji bu ime kua Jesuno kuainva ijin in. ");
INSERT INTO nvm_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Areme Josof ko Meri bun tavan buon rokga bun e Mosison akaij iji fu kuainma ijeg bun ire fok reoine baren. Ijegreare bun uri am iji afeme abe E Bomana God makuai Jerusarem vain. ");
INSERT INTO nvm_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Regavo iji fun buk akaij ijia kuai, Am farif amur ja nafekva iji kege E Bomana God vajafno kuainma ijefuon bun ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Regavo madu bu vainva iji bu E Bomana ijefuon akai fu kuainma ijeg bu um nokarok (2) kege isuf barokuai vain. ");
INSERT INTO nvm_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Regavo ar Jerusarem ijia eof be if fuon Simion fu ijia fin. Fu e mukor ga fu Godon vuak mukor vierafeknum Godon unam ma ijia jamon. Regavo madu fuka e iji God fu kua fu e Isrerko karaunia ruakno kuainma iji samuame fino ijin. Regavo Godon Kaven Akai iji fu fusik oinon. ");
INSERT INTO nvm_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ijefuon Godon Kaven fu kua, Aiji a e iji God fu kuaga fu e Isrerko iji karauniak ruakno kuainma a iji game son guakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Godon Kaven ijar Simion afeme sos ijia arume vakoga Jesuon eofijaf iji bun Jesu afeme izeg Godon Akai iji fu kuainma ijegrekuai ijia aru vain. ");
INSERT INTO nvm_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","32","Simion fu uri imut fuon ijia am iji dabeme abe God oimardame ijeg kuardai, E Bomana na guakva iji na oimarknum guaken. Ijefuon maiji nan e iji a kie fu e moikazan igia oinva iji karauniakfuon iji a kie na gakno kienma iji nan gain. Regavo fur e Jius bakin ijiebuon sanainma ijin ga fu ruainma iji fur e Isrerkobuon if iji dab bomana rekno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jesuon asoij ijiga asiefuon bu vuak irerag fok Simion fu am ijefuon kuaimon bu iji faiva buka oiserdiain. ");
INSERT INTO nvm_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","E Simion fu daro miame uri asiefuon Meri kua, Am igi God fu kuamga fu ruainma ijin revo fur e Isrerko iji kege atasek. Ijefuon maiji fun oibuon bu vierafejo ijin kam atasega e roin bu fu abega fu bu karauniakfuon. Regavo roin bu fu uzavo iji bu koikbuon kege vajai fian manamik. Regavo fur Godon anf igeg rega e uruvana bu fuisina kuaikfuon. ");
INSERT INTO nvm_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Rega fur ise irerag buon bu isuar sauime vierafeoijo iji kege e uruvana ijiebuon nifak ijia samafrekfuon. Regavo rad oion bu kunaime jafega a oifian abekno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Regavo barak Godon vuak vierafene kuaimon be bara Ana fu e Fanveron kabaij ga fu e Asan agan be. Fu baru fuon ijek juaivasia imut roin ga nikit nokarok (7) ijeg fine roke baru fuon fu guain. Bara iji fu baru fuon guakoga rad fu fi ruainma iji fu juaivasia uruvana eiti fo (84) barko fu barasren. Fu Godon ar bu ijia arume sirimamejo iji fuba aren. Regavo fu nakik mazak fu duok karoknum Godon sirimamenon. ");
INSERT INTO nvm_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Areme Simion fu Meri ko Josof vuak kuardiamo ijia bara Ana fuk tavan besum ijia kekome Godon oimaren. Rega fu uri e uruvana Jerusarem ijia karine e iji God fu kuaga fu bu karauniakafa kuainma iji samuavo iji kuardiame kia, E iji no karaunuokfuon iji fun ruainmano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Areme Josof ko Meri bun E Bomana Godon akai fu kuainma ijeg bu ire fok reoine barme bun una ai Nasaret ar Gareri guf ijia vain. ");
INSERT INTO nvm_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ijegrene am iji fun Godon daro ijekma bomanare revo fuon vierafenma iji fuka ma bomana rekoga Godon ma rediamon iji fun abe fu main. ");
INSERT INTO nvm_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Juaivasia besubesum guf ijia Jesuon eofijaf bu Jerusarem ijia iro Fasova iji ijo. Regavo iro iji bu ijo ijefuon maiji bu saifarif iji bu ar Ijift ijia vajai fian abeknum e ijiebuon ikreoijo ijia God fu karauniainma iji vierafejo. Ijefuon Jesu fu juaivasia tuer (12) ijeg barekoga eofijaf bu una iro iji ikuai vain. ");
INSERT INTO nvm_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Bu va iro iji ine barme e fok bun una ar buon ijia vako Jesu fu Jerusarem ijia fin. Regavo eofijaf bu Jesu fu vek Jerusarem ijia fiko bu ruainva iji buba vierafen. Bu vierafero kafu fu e uruvana ijiebuon kafar ijia oinoro naki besum barekoga bu uri ebuon ga kaifijaf bu oijo ijia fu nisain. ");
INSERT INTO nvm_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","46","Bu nisaimoga fu bakiga bu nisaime una Jerusarem vain. Ijegreare tavan nokbek (3) barko ijia bu vaga fu Godon ar ijia arume Jius e mamkanuk ijiena ijia fine vuak bu kuaivo iji faiknum duna kafokafo kuardiam. ");
INSERT INTO nvm_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","48","Rega e uruvana ijia karinva bu vuak fuon ma iji fu vierafeknum kuaimon iji faiva buka oiseradiain. Rega eofijaf buk fu gavga buka oiserdiain. Ijefuon asiefuon fu uri kua, Farinu a irerafuon ijegreko no a nisaime oko noka oifiaduinmano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","50","Bu ijeg kuardavga Jesu fu uri kia, Ja irerafuon na nisaidieoij? Naiji na asoinun ijefuon ar ijia ik fuon rekno kuainva iji jabe vierafenvano kiain? Jesu fu vuak ijeg eofijaf kuardiagavo eofijaf bu vuak fuon iji buba mukoi faime vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Rega Jesu fun uri una eofijaf ijiena Nasaret ijia kekome ire uruvana bu fu kuardavo iji igiain. Regavo Meri fu irerag uruvana Jerusarem ijia renma iji tavan uruvana fum oifuon ijia vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Regavo Jesu fu ofrenma iji fu fuon mukoi vierafeno ijekma ofren revo ire uruvana fu reoinma iji fu God abevo ema iji bu oimardiakfuon ijia reoin. ");
INSERT INTO nvm_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Juaivasia fiftin (15) abenma ijia e Taibirias fu Gaman bomana ren. Regavo tavan besum ijia e Fontias Fairet ijar e Judiabuon Gaman rekoga Erod fu e Gareriko samuagdiakoga uviaifuon Firif fu ar Ituria ko Trakonaitis iji samuagdiain. Regavo Risanias fu e Abirinko samuagdiain. ");
INSERT INTO nvm_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Regavo Anas ko Kaiafas bu e Godon isuf baroijo ijiebuon e mamkanuk renva ijia e Zekaraian farif Jon fuk fu tavan besum ijia ai moikum namo ijia figa God fu Jon vuak kuardain. ");
INSERT INTO nvm_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ijefuon Jon fu kekome do Jodan ruvainma ijia oknum e iji vuak kuardiame kia, Ise jon arega una do ruaiga God fu ise jon giame arekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","6","Regavo vuak iji Jon fu ijeg kuainma iji fun e Asaia Godon vuak vierafene kuaimon ijar buk akaij ijia isoin. Fu isoime kuai, Ebe fu ai moikum namo ijia fine kume, E Bomana ijefuon unam iji amardake fu ijia rokno kumen. Regavo ar amaramar iji nika amarega bu una ajie ruaf revo madu uruor ga nafar iji nika amarega bu una besum arir ref. Regavo unam giekin iji nika kara asume arir amarega unam ise iji amarigia amaref. Ijegrekin e iji bu God e iji fu kuaga fu e fok karauniakafa roko iji bu mukoi game vierafefno kumen. ");
INSERT INTO nvm_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ijefuon e uruvana bu Jonon roga are fur do ruardiakafa bu iji ruain. Bu rokga Jon fu uri kia, E ise guri ka tabar igegreoijo gurie ja ise jon jaka ba aren. Ja vierafero na ja do ruardiaga God fu e ise rejo iji fu kege arafiriakfuon iji jan amasuainvaro ja ijeg vierafek. ");
INSERT INTO nvm_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Amur nika va unam ma ijesugin reoga e fok bu giame vierafero jan ise jon ja kegoijo iji jan arenvaro. Regavo jab kuaik noiji sainuvuon Eburamon uifarifdo God fuba nuigafuokro ijeg jab kuaik. Regavo igia faif. Jaba ise jon arekva God fu e darokido fu mun guri kege una e Eburamon afijaf amardiaga bur ar jon abekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Jon fu ijeg kuardiame fun uri vuak be ijeg bijame kuardiain. Fu kia, E be fu mua uikin be abe in anej ijia samuain. Fun samuaido in iji bu sunin ba mukoi kirakma fu gireg gamia um mian jaken. ");
INSERT INTO nvm_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jon fu vuak ijeg kuardiamga e uruvana bu uri kua, Ijefuon a vierafega no irerag abekno kuain? ");
INSERT INTO nvm_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Bu ijeg kuavga Jon fu una kia, E iji erar set nokarok (2) naoigakma ni be abe e be erar set bakin iji ma. Regavo erar fu duok ijo iji uruvanakma fuk nin duok fuon e roin ikvajiamne kiain. ");
INSERT INTO nvm_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Regavo e takes abeoijo roin bu do ruaikuai ruainvado bu uri Jon kua, E nijaidiamon revo noiji no irerag rekno kuain? ");
INSERT INTO nvm_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Bu ijeg kuavga Jon fu una kia, Ja takes abeokva jab mon kafo miji kareme roin joi karekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Regavo madu e bijaivo roin bu uri Jon kua, Regavo noiji no izegrekno kuain? Bu ijeg kuavga fu una roin kia, Ja e kiaga bu mon vajiavo iji jab biesiaga bu mon uruvana vajiaga ja kafo joi kareknum vo jab una e roin vajiak. Regavo madu jab ik jon ja rene mon abejo ijefuon kuaime ziekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jon fu e uruvana ijeg kuardiamga bu vierafero Jon kafu e iji God fu imut bijame kuamga fu ruakro kuainma ijinro bu ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Regavo Jon fu kia, Naiji naim e ukakbe ijefuon na do ijia ja ruardiakfuon. Regavo e iji ka ma e darokin iji fu rad rok. Revo naiji na ik fuon fu rekreno iji rekva naka ba aresren. Ijefuon e ijar Godon Kaven iji mian igeg naino iji kege oijon ijia uniafdiak. ");
INSERT INTO nvm_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Regavo madu igia faif. Kof iji bu dis ijia useme do jia abesga sunuat iji fu una azan ijia ajiega bu kege usiakorevo. Rega ma iji bu dis dibuor ijia ariga bu karev. Unam besum ijeg e iji rad rokon iji fu ruakma fur e uruvana ijiebuon ise bu reoijo ijia giaknum ke atasek. Fu ijegrene e ma reoijo iji fu kege ar fuon ma ijia uniaga ise iji fu kege ar mian iji ijia naine vako ijia jaga buka vajai fian abekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon fu ijeg kuardiame uri vuak ma iji kafokafo ijia e uruvana soisoigin kuardiain. Fu ijegrenki bu unam isema bu karioijo iji buka arega una oi karoikafa fu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ijegreare fu uri e Erodon izeg ise iji fu renma ijefuon vuak fuisina kuain. Ijefuon maiji Erod fu uviaifuon ijefuon bara Erodias aben revo madu fuka unam ise uruvana kafo ren. ");
INSERT INTO nvm_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Erod fu amur ijegren ga rad fu madu una kiamga bu Jon dab dibur unainva ijar fuka ma iseren. ");
INSERT INTO nvm_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Ijegrene e uruvana bun do ruaime barekoga Jesu fuk do ruain. Regavo fu vek sirimameno ijia varur gufia vana fu irame vakoga Godon Kaven ijar um guaf igeg arime Jesuon ruain. Areme God fun varur gufia kume, Aiji a Farinun na oijmavo na a gavo naka bomana oimadienmano kumen. ");
INSERT INTO nvm_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","Areme Jesu fu ofrene vake juaivasia teti (30) ijeg abega fu ijia anerene ik fuon iji ren. Regavo igi Jesuon saifarif iji bu Adamon uifarif ijia anere ruainva ijin. Regavo e uruvana bu vierafe Jesu fu Josofon farif ga Josof fu e Erin farif ga Eri fu e Mataton farif ga Matat fu e Rivaion farif. Regavo Rivai fu e Merkin farif ga e Merki fu Janain farif ga Janai fu e Josofon farif ga Josof fu e Mataiason farif ga e Mataias fu e Emoson farif ga e Emos fu e Neamon farif ga Neam fu e Esrin farif ga e Esri fu e Nagain farif. Rega e Nagai fu e Maton farif ga e Mat fu e Mataiason farif ga e Mataias fu e Semeinon farif ga e Semein fu e Josekon farif ga e Josek fu e Jodan farif ga e Joda fu e Joananon farif ga e Joanan fu e Resan farif. Rega Resa fu e Zerubaberon farif ga e Zerubaber fu e Seatieron farif ga e Seatier fu e Nerin farif ga e Neri fu e Merkin farif ga e Merki fu e Adin farif ga e Adi fu e Kosamon farif ga e Kosam fu e Ermadamon farif ga e Ermadam fu e Eron farif. Regavo Er fu e Josuan farif ga e Josua fu e Eriesan farif ga e Eriesa fu e Jorimon farif ga e Jorim fu e Mataton farif ga e Matat fu e Rivain farif ga e Rivai fu e Simionon farif ga e Simion fu e Judan farif ga e Juda fu e Josofon farif ga e Josof fu e Jonamon farif. Regavo e Jonam fu e Eriakimon farif ga e Eriakim fu e Merian farif ga e Meria fu e Menan farif ga e Mena fu e Matatan farif ga e Matata fu e Netanon farif ga e Netan fu e Devidon farif. Regavo e Devid fu e Jesin farif ga e Jesi fu e Obedon farif ga e Obed fu e Boazon farif ga e Boaz fu e Sarmonon farif ga e Sarmon fu e Nasonon farif ga e Nason fu e Aminadabon farif ga e Aminadab fu e Adminon farif ga fu e Anin farif ga e Ani fu e Esronon farif. Rega e Esron fu e Ferezon farif ga e Ferez fu e Judan farif ga e Juda fu e Jekafon farif ga e Jekaf fu e Aisekon farif ga e Aisek fu e Eburamon farif ga e Eburam fu e Teran farif ga e Tera fu e Neoron farif ga e Neor fu e Serugon farif ga e Serug fu e Reun farif ga e Reu fu e Feregon farif ga e Fereg fu e Eban farif. Regavo e Eba fu e Seran farif ga e Sera fu e Keinanon farif ga e Keinan fu e Afaksadon farif ga Afaksad fu e Semon farif ga e Sem fu e Noan farif ga e Noa fu e Remekon farif ga e Remek fu e Metusaran farif. Rega e Metusara fu e Enokon farif ga e Enok fu e Jaredon farif ga e Jared fu e Marareron farif ga e Mararer fu e Keinanon farif ga e Keinan fu e Inoson farif. Regavo e Inos fu e Seton farif ga e Set fu e Adamon farif ga e Adam fu Godon farif ijin. Ijefuon e agan bu ijeg uinvene ruain. ");
INSERT INTO nvm_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Tavan iji Jon fu Jodan do ijia Jesu do ruardame barekoga Godon Kaven ijar oifuon ijia arime raren. Rega Kaven Akai iji fun Jesu dab ninarume fun afeme ai moikum namo ijia vakoga Setan fu naki foti (40) ijeg Jesu biesuaoin. Regavo tavan iji fu oinma ijia fuka duok kafo ba ioin. Fu duok ba ioko fun naki foti (40) ijeg barenma buin ijia fuka vasia mukoi guain. ");
INSERT INTO nvm_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Fu vasia mukoi guainma ijia Setan fu ijia kekome Jesu kua, Aka ma Godon Fariga ni mun gari kuaga fu una duok rene kuain. ");
INSERT INTO nvm_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Fu ijeg kuardain gavo Jesu fu una roin kua, Godon buk akai bu isoinva ijia fu kuai, Barubara buba tavan bog duok ijesugin iok gavo bum Godon vuak ijesugin vierafene rekno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ijegreare Setan fun uri Jesu afeme nafar bomana be manino buin ijia ajie vain. Fu ijia ajie manine ar iror fok e mamkanuk kafokafo bu samuagdiavo iji nijaiknum ga ire uruvana nijain. ");
INSERT INTO nvm_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Areme fun uri Jesu kua, Nar ire nun uruvana a giainma iji kege a vajak. Ijefuon maiji ire uruvana iji nar daro nun ijia samuagdiavo ijefuon nar koiknun kege e be era nar vierafekva iji vajak. ");
INSERT INTO nvm_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ijefuon a na ato same sirimamekma na ire fok na kuaga ar samuagdiakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Fu ijeg kuardamga Jesu fu una roin kua, Usuibe buk akai bu isoinva ijia God fu kuai, Janika E Bomana God jon ijesugin fuon ato same sirimameknum ga ik fuon reofno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Areme Setan fun madu Jesu afeme va Jerusarem Godon ar bomana bu sainva azan ijia unain. Fu ijia ajie manikoga Setan fu uri kua, Aka ma Godon Farikma ni ijia furiko moik gamia akoze. ");
INSERT INTO nvm_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Ijefuon maiji usuibe buk akai bu isoinva ijia God fu kuai, Godri anera fuon uruvana kiaga bur a samuagdak. Regavo a furik akozekman bur dabe ari vake moikazan ijia unakva aba arime oi kananamiken. Regavo madu diak on iji aba kege nizukdiakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Rega Jesu fu uri Setan kua, Usuibe buk akai bu isoinva ijia God fu kuai, Ab God E Bomana on iji bisuamne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Setan fu ijeg Jesu bisuamoine barme tavan ukakbe fun Jesu areme vain. ");
INSERT INTO nvm_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","Ijegreare Jesu fu una Gareri guf iji fu ruainma iji fun Kaven Akai ijar dab ninarumga fu daro abe oknum ik fuon ren. Fu kekome mai besubesum ijia E Jiusbuon ar bu afuime vuak kuaivo ijia arume vuak nijaidiamoin. Fu ijegreogame e uruvana bu vuak fuon iji faime uri fu dab aroin. ");
INSERT INTO nvm_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","17","Areme Jesu fun una madu Nasaret ar iji bu fu nafenva ijia vain. Regavo tavan Sabat (Satade) iji e Jius bu isuar karijo ijia Jesu fun izeg fu tavan uruvana reoino ijeg fun ar bu afuime vuak kuaivo ijia aru vain. Fu ijia arume va manine kiamga bun Asaia e Godon vuak vierafene kuaimon ijefuon buk ijin abe main. Bu abe mavga fu kafarbe irame vuak be bu ijeg isoinva iji dain. ");
INSERT INTO nvm_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Godon Kaven iji fun na nirokdien ijefuon fun Godri na imut bijieme kie, Ni vuak nun ma iji abe va e iji isema karioijo iji kuardiamne. Regavo madu ni va e iji dibur karijo ijiga e ni zuriaigin iji ga madu e iji eraneb bu e ise ijieb samuagdiavo ijin karauniamne. ");
INSERT INTO nvm_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Regavo madu ni e uruvana kuardiame kia, Tavan iji God E Bomana fu ja ma rediakfuon iji fun igijar ruainmano kiamne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesu fu buk iji dame barme fun abe una e buk samuamo iji mame fun una ari fin. Fu una ari figa e uruvana ar ijia karinva iji buka uri uruvana Jesu nikajain. ");
INSERT INTO nvm_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ijegreare Jesu fun anerene uri vuak kuardiame kia, Buk kafar igi na dava ja fainva iji ivia tavan igi fun ijekma aresrenmano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","E uruvana bun isuar igia karine vuak fuon ma iji fu ir fuon ijia fu kuaimon iji faiva buka oiserdiain. Ijefuon e iji bu uri kuai, E guri fu Josofon farif gavo fu izeg vuak ijekin iji kuaimno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Bu ijeg kuaivga Jesu fu una kia, Na giaga ja vuak be ijeg kuaikuai vierafen. Ja kuai, A e karauniamo ijefuon ni koikon oi keunanamimne. Regavo ni izeg a ar Kafoniam ijia ire iji a reoina no fainva ijeg una ar on ma igia rega no game a ma vierafejno kiekuai vierafenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Regavo na igi kuardiakrejo ni faif. E Godon vuak vierafene kuaivo iji e aiko buon ma iji bu giame ijia oimardiavo bakin. ");
INSERT INTO nvm_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Regavo igia faif. Tavan iji e Eraija fu ar Isrer finma ijia bara amun uruvana bu ijia oin. Regavo tavan ijia juaivasia nokbek (3)ga asam sibank ijeg tavan fuba dakoga fuka tavai maren. Fun tavai marme ire ikva uruvana fuka saire barekoga vasia kekome ar iror ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Rega bara amun uruvana buka vasia kaniain gavo God fuba Eraija kua, Va bara amun uruvana ifejdiamne kuain. Regavo fum kua, Va ar Zarefet Saidon guf ijia bara amun iji fino ijin ifejdamne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Regavo madu una Eraisa e Godon vuak vierafene kuaimon ijefuon tavan ijia e uruvana ar Isrer ijia karinva iji bu kasi refrosi kuavo iji aben. Rega Eraisa fu Godon if ijia e kafo ba karauniain gavo fum kuamga fu e Neman ai Siriako iji fuonkua keunainmano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jesu fu ijeg kuardiamga e uruvana bu Jiusbuon ar iji bu afuivo ijia aru karinva iji bu vuak iji faiva buka deajidiain. ");
INSERT INTO nvm_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bu deajidiamga bu uri Jesu kunaime dab mai iji bu karinva makaf ijia useme dab uruor ijia abesekuai reoin. ");
INSERT INTO nvm_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Bu ijegreoijga Jesu fu e uruvana ijiebuon kafar ijia uniakome vakga bu ijia aren. ");
INSERT INTO nvm_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Areme Jesu fun vake ar Kafoniam moik Gareri guf ijia kekoin. Fu ijia kekome tavan Sabat (Satade) iji bu isuar karine Godon sirimamejo ijia e uruvana vuak nijaidiain. ");
INSERT INTO nvm_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jesu fu ijia vuak nijaidiamga e uruvana bu vuak fuon fu kuaimon iji faiva buka oiserdiain. Ijefuon maiji vuak fuon iji fuka darokin. ");
INSERT INTO nvm_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","Regavo e Jiusbuon ar iji bu afuivo guf ijia e be fu kaven ise ijar dab ninaruoino iji fu ijia fin. Ijefuon fu uri uruvana igia Jesu biumame kume, Jesu e Nasaretko gare a nuvuifuon a izeg vierafen? A igi a ruainma akafu no kege arafiruokafa ruain. Na vierafega aiji a Godon e Akaij ijino kumen. ");
INSERT INTO nvm_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Fu ijeg kumega Jesu fu uri kaven ise iji kuriaireme kua, Vuak iji a kuaimon iji arega i bijume keko ruvakne kuain. Fu ijeg kuamga kaven ise iji fu uri e iji dab e uruvana ijiebuon nifak ijia akozme fuba una ire ise kafo fuon ren gavo fum kekome vain. ");
INSERT INTO nvm_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kaven ise iji fu kekome vakga e ijia karinva bu iji gava buka oiserdiamga bu una bui ganamin. Bu bui ganamiknum kuai, Vuak iji fuka sibe darokido e guri fu darokma kaven ise iji kiaga bu usem vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Bu ijeg kuaime uri Jesu izeg fu renma ijefuon vuak iji abe kuaime ar iror ijia oin. ");
INSERT INTO nvm_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","39","Bu ijegrekoga Jesu fu ar iji areme keko Saimonon ar ijia vain. Regavo Saimonon bara ijefuon asie iji fu vajai vuat bomana urino ijefuon bu Jesu kuaga fu ifejdakafa bu useme kuain. Bu kuardavga Jesu fu va fu namo samaij ijia manine uri vajai fuon vuaturimo iji kuain. Jesu fu adam iji kuamga fu bara iji areme vakga fu maimga fun uri ire vajiaknum samuagdiain. ");
INSERT INTO nvm_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ijegreare rad tavan koko ijia e roin bu kaifijaf adam kafokafo abenva iji aferdiame Jesuon rokga fu e besubesum imut nigen namdiaknum e uruvana karauniain. ");
INSERT INTO nvm_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Fu ijegreknum madu kaven ise uruvana bu e nirokiavo iji kuriaireme kiamga bu e iji areme usem vain. Bu usem vaknum biumame kume, Aiji anka ma Godon Farifno kumen. Rega Jesu fuka kuriaireme kiamga buba vuak kuain. Ijefuon maiji bun vierafega Jesu fuka ma e iji God kuamga fu ari moikigia e fok karauniakafa ruainma ijin. ");
INSERT INTO nvm_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Areme tavan ik irasemo ijia Jesu fun uri mai ijin areme ari ai moikum namo ijia vain. Fu ijia vakga e uruvana bu uri anerene fu nisaimoine ja bieme nikajain. Ijefuon maiji bu vierafero fu una bu uniame vakro buka bijuknum nikajaoin. ");
INSERT INTO nvm_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Bu ijeg nikajaoijga fu uri kia, Na vierafega naka mai roin ijia Godon vuak ma iji izeg tavan rad fu koikfuon efuon iji samuagdiakfuon ijin abe kuardiak. Ijefuon ma iji God fu ijefuon kiemga na ruainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Fu ijeg kuardiame uri mai uruvana guf ijia oknum e Jiusbuon ar besubesum bu afuivo ijia vuak fuon ma iji kuardiaoin. ");
INSERT INTO nvm_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Areme tavan be Jesu fu do Genesaret daturaiko nafuinma irif ijia maniko e uruvana bu biom fu dab kirafirime ireme Godon vuak ma iji faiv. ");
INSERT INTO nvm_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Bu ijia ireme faivo ijia fu giaga e kijum arafiriavo nokarok (2) bu sisim buon kege do irif ijia name ugie buon kareme do sov. ");
INSERT INTO nvm_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ijefuon Jesu fun e Saimonon sisim ijia ajieme kuamga fu abe biom saof azan ijia abedeko fu ijia fine e uruvana vuak nijaidiain. ");
INSERT INTO nvm_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Fu vuak kuardia barme fun uri Saimon kua, Sisim on abe biom saof uf garia abedeme ugie jon kege do ijia oine kijum kafo karafno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Rega Saimon fun uri kua, E Bomana no naki arafirin gavo kijum kafo noka ba karain. Regavo a kiemo ijefuon na ugie abe una okno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Fu ijeg kuardame bun uri ugie buon kege oine kijum uruvana karavga ugie buon fuka bujasekafa ren. ");
INSERT INTO nvm_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ijefuon bu uri kaifijaf roin sisim be ijia karinva iji kumejga bu ro ifejdiain. Bu ifejdiame kijum ijin kareme sisim nokarok (2) ijia navga fuka afirene gama arikrena bu kege una irif ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Jesu fu ijegrega Saimon Fita fu iji game ari Jesu ato same kua, E Bomana naiji na e ise reoijo ijefuon gareg vakne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Jesu fu ijegrega Saimon Fita ga e iji bu kijum mamkanuk uruvana iji bu karainva ijin giava buka bomana oij iserdiain. ");
INSERT INTO nvm_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Rega Saimon Fita ga e roin Zebedin afijaf Jeims ko Jon buk buka oij iserdiain. Ijefuon Jesu fu uri Saimon kua, A jumo arega ni iviakmaigia una gafeg a kijum igi a karainma ijeg e aferdiakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ijefuon bu sisim buon iji dakara ajie irif ijia abedeme ire uruvana ijia areme uri Jesu jame vain. ");
INSERT INTO nvm_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tavan be Jesu fu mai be ijia fino ijia e be adam kasi igekin bu kua refrosi kuavo iji abenma ijar kekome Jesu fino ijia ruain. Fu keko Jesu game tua moik ijia dijeme uri Jesu soisoigin kua, E Bomana a vierafega a oimarkma ni vajai nun igi amardiega fu una madiemne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Fu ijeg kuardamga Jesu fu uri imut akozme e iji kunaime kua, Na vierafega na amardakno kuain. Fu ijeg kuardako ijia kasi iji fuka baren. ");
INSERT INTO nvm_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Areme Jesu fun uri kua, Ab va e kafo irerag na on renva iji kuardiakgavo nin amur va e Godon isuf baroijo iji vajat on ijekma abe fu nijaimne. Ijegreare ni ire kafo kege e Mosison akaij iji fu kuainma ijeg una God isuf baroiga e bu ijia game vierafero adam on iji fun barenmaro bu ijeg vierafekno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jesu fu ijegrekoga e uruvana bu uri vuak fuon dab mai ijia kuaime bomana re vain. Ijefuon e uruvana bu vuak fuon iji faikuai rokga fu adam ise kafokafo bu abenva iji karauniain. ");
INSERT INTO nvm_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Regavo tavan roin fu isuar areme va ar e bakin ijia fine sirimamen. ");
INSERT INTO nvm_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tavan be Jesu fu manine e vuak kuardiamo ijia e Ferisis roin ga e vuak akai nijaidiavo roin bu ijia ruain. Regavo e iji ruainva iji bu ar Gareri ga Judia guf ga Jerusarem mai ijia ruainva iji bu ijia karin. Regavo Jesu fun Godon daro iji fu e adam abejo iji karauniakfuon iji fuka fuon ruain. ");
INSERT INTO nvm_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Regavo e kafo bu e vajai garenma iji abe suf ijia anume abe fata ijia uname ruain. Bu e ijin abe Jesu manino uinak ijia abedevga fu amardakuai bu ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Regavo fuka e uruvana zarainva ijefuon bu unam iji bu afeme aru vakfuon iji fuka bakin. Ijefuon bu abe gieme ajie ar azan kuf ijia umaij ijia bujame abe kajek ijia kira dab abesva fu Jesu manino uinak ijia ari nain. ");
INSERT INTO nvm_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ijegreare Jesu fu buon izeg bu ma vierafejo iji giame uri e iji kua, Eko ise on iji nan giame arenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Rega e vuak akai nijaidiavo ijiga e Ferisis roin bu iji game uri bui kuai, E iji erar una Godon if iji dab buze im. Ema igi fu erar e kafobuo ise iji giame arekma bakin gavo fun God fuonkuano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Rega Jesu fu izeg bu vierafenva iji fun giain ijefuon fu uri kia, Ja irerafuon vuak kafokafo oijon ijia vierafejno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Fu ijeg kuardiame uri kia, Ja vierafega nabe e igi kuaga fu suf fuon kara tuame uri vaken? Regavo na kuak ise on iji nan game arenvano kuak. ");
INSERT INTO nvm_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Vuak nokarok (2) iji na izar e guri kuardaga ja ijia gieme ma vierafekfuon? Ja naba ma vierafejo ijefuon na nijaidiaga ja ijia game ma vierafek. Ja ijia vierafero Ema ijiebuon Farif igi na daro abedo na moikigia ebuon ise na giame arekro ja ijeg vierafekno kiain. Fu ijeg kuardiame fun uri e vajai garenma iji kua, Ni uri suf on iji kara tuame ar vakne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Fu ijegrega migegare e adagin iji namo iji fun uri suf fuon fu barie namo iji ke datome God oimarknum fun ar fuon ijia vain. ");
INSERT INTO nvm_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Fu ijegrega e uruvana buka bomana oiserdiamga bu uri juknum Godon oimarme kuai, Noka ivia ire sumakin iji gainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ijegreare rad Jesu fu vagak e takes abeno be if fuon iji Rivai fu fine e ijiebuon takes abega fu bieme kua, Ni na jajiemne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Fu ijeg kuamga Rivai fun uri ire uruvana fu reno iji fun ijia areme uri Jesu ja vain. ");
INSERT INTO nvm_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Areme Rivai fu ar fuon ijia Jesuon ire kanafumga e takes abeoijo iji ga e roin bun ijia duok ikuai afuin. ");
INSERT INTO nvm_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bu Jesuna duok ijga e Ferisis roin ga e vuak akai nijaidiavo roin buba oimaren ijefuon bu uri una e Jesuon vuak faivo iji kia, Jaiji ja irerafuon e iji takes abesvo ijiga e ise reoijo ijiena duok ijno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Bu ijeg kuardiavga Jesu fu uri kia, E iji buba adam abejo iji bu e adam giavo iji vierafejo bakin. Regavo bun e iji adam abejo ijieb bu e adam giavo iji vierafekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ijegvo na ruainva iji na e maturainva ijiebuon ruainva bakin. Regavo na e ise reoijo iji kiaga bu ise buon iji aregavo una oi karoime unam ma ijia kegokro na ijefuon ruainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ijegreare e kafo bu uri Jesu kua, E Jonon vuak faivo iji bu duok karoknum ga sirimamejo. Regavo madu e iji e Ferisis ijiebuon vuak faivo iji buk bu ijeg rej. Rega eon bu ijeg buba rej gavo buka duok iknum ga do ijno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Bu ijeg kuardavga Jesu fu una vuak be ijeg bijame kuardiain. Fu kia, Tavan iji barubara bu sanamikuai duok ijo ijia e baru iji fu ijia fike bu e ruainva iji kia bu duok karome karine una oifiaigma vakva bakin. Regavo buka oimarknum karine besum duok ik. Bu duok ine barme son rad e iji fu bara iji afeme ar be vakma ijia buson oifian abe buifuon duok karok. Unam besum ijeg gavo e vuak nun faivo iji na vek igia buna oijo iji no besum oimarknum duok besum iken. Regavo tavan rad e ani nun iji bu na aferdieme kaniga na guakva ijia bu nuifuon oifian abe duok karokno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesu fu ijeg kuardiame una madu vuak be ijeg bijame kuardiain. Fu kia, E be fu erar ugon iviamkor be abe bujame una ugon usuikor ijekma sigukma bakin. Fu ijegrekma rad fuka iserekfuon. Ijefuon maiji ugon be fu usuikor ga be fu iviamkor ijefuon fuba marek. ");
INSERT INTO nvm_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","Unam besum ijeg gavo fu erar vuain iviamkor iji abe una kamui usuikor iji bu fanuf surif ijia amarenva ijia usemo bakin. Regavo fu ijegrekma kamui usuikor iji fuka sisuikene bujaga vuain iviamkor iji fuka usek. Bu ijegrekva ire nokarok (2) iji buka iserek. Ijefuon vuain iviamkor iji buka kege una kamui iviamkor ijia usekin ire nokarok (2) iji buka marek. ");
INSERT INTO nvm_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Regavo ebe erar fu vuain usuikor iji ikma fuba una vuain iviamkor iji iken. Ijefuon maiji fu vierafero vuain usuikor ijefuon marien ijar fu mukor ro fu una vuain iviamkor mukor iji fuka uzakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tavan Sabat (Satade) be bu isuar karijo ijia Jesu fu juar bu vuit oinva ijia ura oin. Fu ijia urame okoga e vuak fuon faivo iji buk bu funa ijia ura oknum ire vuit sunin iji kafo turame imut tat ijia dakumume surif iji fuase oknum ioij. ");
INSERT INTO nvm_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Regavo e Ferisis roin bu giame uri kia, Ja irerafuon akai nuvuon abe tuaseme tavan Sabat (Satade) iji no isuar karijo ijia vuit sunin tuame ijno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Bu ijeg kiavga Jesu fu una roin kia, Ja buk akai kafar be ijia e Devid fu efuon ijiena bu vasiaordiavga bu kenva iji jabe dame gain? ");
INSERT INTO nvm_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Devid fu Godon ar iji bu sirimamejo ijia arume bred iji bu abe isuf baroijo ijin abe iga roin fu kege una efuon vajiama bu in. Regavo bred ijekin iji bu e iji Godon isuf baroijo ijieb buonkua ikfuon gavo e maikava buba ikno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesu fu ijeg kuardiame uri e Ferisis iji kia, Ema ijiebuon Farif igi naiji na tavan Sabat (Satade) iji isuar karijo ijefuon e Bomana ijin. Tavan Sabat (Satade) iji ja isuar karijo iji Jesu nar amaren. Ijefuon na aresredo nar tavan ijia e kiaga bu ire kafo rekva iji fun marek. ");
INSERT INTO nvm_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Areme tavan Sabat (Satade) be bu isuar karijo ijia Jesu fu una ar iji e Jius bu afuime vuak kuaivo ijia arume vuak nijaidiain. Regavo ar guf ijia e be imut abe kirainma fu ijia fin. ");
INSERT INTO nvm_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Rega e Ferisis iji abevo e vuak akai nijaidiavo iji buka Jesu nikaja are fu ise kafo rega bu ijefuon afeme kot rekuai reoin. Bu kuai are fu e be tavan iji bu isuar karijo ijia keunaga bu gakuai bu ijegarain. ");
INSERT INTO nvm_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Regavo Jesu irerag bu vierafejo iji fun giain ijefuon fu uri e iji imut maink iji abe kirainma iji kuai, Uri e uruvana ijiebuon nifak igia manine kuamga fu uri ijia manin. ");
INSERT INTO nvm_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Areme Jesu fun uri e Ferisis iji abevo e vuak akai nijaidiavo iji kia, Tavan Sabat (Satade) iji no isuar karijo ijefuon akaij iji fu kuainma ijia e ijekin iji no kege izeg rek? Nobe bu ifejdia vo no buon ise rek? Regavo madu noba kaniakgavo no bu karauniakno kiain? ");
INSERT INTO nvm_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Fu ijeg kuardiame uri e uruvana giaoine uri e iji kua, Imut on akozemne kuain. Jesu fu ijeg kuamga e iji fu uri Jesu fu kuainma ijeg ren. Fu ijegrega imut fuon fuka mukorigia main. ");
INSERT INTO nvm_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Rega e Ferisis ijiga e vuak akai nijaidiavo iji buka deajidiamga bu uri unam izeg bu Jesu kanakfuon ijin kuaime nisain. ");
INSERT INTO nvm_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Areme tavan ijia Jesu fu una uruor ijia ajieme sirimamekafa vain. Fun va uruor ijia kekome naki fu God sirimameko vake tavan irasen. ");
INSERT INTO nvm_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Fun tavan irasemga fu uri e vuak fuon faivo iji kumena bu rokga fu uri e tuer (12) kege kiama bu e afasor fuon ren. ");
INSERT INTO nvm_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Regavo e ijiebuon if iji Saimon (e iji Jesu fu una Fita kuainma) ijigam uviaifuon Edru ga Jeims ga Jon ga e Firif ga Batoromiu iji ken. ");
INSERT INTO nvm_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Regavo madu fu e Metiu ga Tomas ga Jeims e Arfiason farif ijigam Saimon (e iji fu e Romko ijieb fu samuakfuon iji fu uzamon e ijin). ");
INSERT INTO nvm_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Regavo madu Judas e Jeimson farif ijigam Judas Iskariot e iji fu rad Jesu abe una e ani fuon miakfuon ijin ken. ");
INSERT INTO nvm_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Areme Jesu fun e afasor iji fu kenma ijiena una arime roke uruor anej gumia usen. Rega e ma uruvana mai Jerusarem ga Judia guf ijia ruainva iji abevo e uruvana mai Taia ga Saidon saof irif ijia karijo iji bu ijia afuin. ");
INSERT INTO nvm_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Regavo e iji bu ruainva iji bu Jesur adam ni kafokafo iji bu abejo iji karauniaknum ga madu bu vuak fuon faikuai ruain. Revo e iji kaven ise ijieb ninarukiainva iji fu karauniamga bu una e ma ren. ");
INSERT INTO nvm_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Regavo e uruvana buka uri fu niriakuai vierafen ijefuon maiji daro fuon ijar e ijin abeko buka una madiain. ");
INSERT INTO nvm_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Fu ijegrejknum uri e vuak fuon faivo iji giaknum kia, E sinuom bakin iji jaka Godon oimaref. Ijefuon maiji Godri ja kedo fur una ja samuagdiak. ");
INSERT INTO nvm_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Regavo e iji ja vasiaordiavo iji jaka oimaref. Ijefuon maiji rad Godri duok uruvana vajiaga ja iken. Regavo e iji eraneb ja iviakma niraimoijo iji nika oimaref. Ijefuon maiji rad ja oimarme kiknum okfuon. ");
INSERT INTO nvm_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Regavo e iji ja bu eb jon deajin abe ga ja uzavo ga if jon kam isema ifdiavo ga ja kam buze ifdiaknum vuak joisina kuaivo iji nika oimaref. Ijefuon maiji ja Ema ijiebuon Farif igi na ma vierafejo ijefuon bu jon ijeg reken. ");
INSERT INTO nvm_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ijefuon tavan iji bu ja kam ijegreokva nika oimarknum of. Ijefuon maiji ire ma iji ja karekfuon iji bu varur gufia naoiv. Bu ijegrejo iji ni vierafero iji bun saifarif ijieb e amur Godon vua vierafene kuaivo iji bur kam ijegrene ruain. ");
INSERT INTO nvm_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Regavo e iji ja sinuom zarainva iji jaka juf. Ijefuon maiji ire ma iji jan iviakma karev. Regavo ire iji bu barekva nabagain kafu irerag ijar jon rekfuon? ");
INSERT INTO nvm_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Regavo e iji ja iviakma duok uruvana ijo iji nika juf. Ijefuon maiji rad jaka vasiaordiaken. Regavo e iji ja e ba ifejdiakuai vierafejo ja kiknum ura oijo iji nika juf. Ijefuon maiji rad jaiji jaka oifian abeknum niraiken. ");
INSERT INTO nvm_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Rega e iji bu e uruvana ijieb ja kam arordiame vuak jon bu mukorigia kuaimoijo iji nika juf. Ijefuon maiji saifijaf ijieb e iji bu vuak kufuime e roin kuardiame ruainva ijiebuon vuak buisina ijeg kuain. Bu ijeg kuaime e iji Godon vuak ma iji abe ruainva iji buba igiain. Rega buka una e iji bu vuak kufui kuaimoinva iji igiain. ");
INSERT INTO nvm_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","28","Jesu fu vuak ijin kuardiame barme uri kia, E iji erar vuak nun igi na kuardiavo iji faivo iji nika e ani jon iji oijmiaf. Regavo e iji bu jon deajir abejo iji nika una bu ma rediaf. Rega e iji eraneb bu jon isema rekva ni una buon oimaref. Revo eraneb bu ja kam ise ijia reoijo iji nika una buifuo sirimamef. ");
INSERT INTO nvm_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Rega erar adafak roin kanakma ni una roin abe maga fu kana. Regavo e kafob ugon jon ja azan savo iji kekva nin kiaga bu madu ugon jon ja rotit savo ijekma kef. ");
INSERT INTO nvm_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Regavo e kafob ire kafofuon ja kiakva nin irerag bu kiavo iji kege vajiaf. Regavo e kafob ire jon kafo kenva iji jab una roib ijefuon kiak. ");
INSERT INTO nvm_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Regavo irerag ja vierafe e kafo bu joifuon rejo iji nin jasik una roib ijeg ref. ");
INSERT INTO nvm_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ja e iji bu ja oijmiavo ijesugin oijmiakva iji Godon nifak ijia fu ma bakin. Ijefuon maiji e iji ise reoijo iji buk bu e iji bu oijmiavo iji oijmiavo. ");
INSERT INTO nvm_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Regavo ja e iji bu ja mardiavo ijesugin mardiakva Godon nifak ijia fuka ma bakin. Ijefuon maiji e ise reoijo iji buk bu e iji bu mardiavo iji bu mardiav. ");
INSERT INTO nvm_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Regavo ja e roin mon vajiame rad una vef roin kekuai vierafejo iji fu Godon nifak ijia fuka ma bakin. Ijefuon maiji e ise reoijo iji bumadu bu ijeg e kafo mon vajiame una roib kekuai vierafejo. ");
INSERT INTO nvm_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Regavo nin e ani jon oijmiame bu mardiaga ire kafo ja buon vajiakva jab una roib kekuai vierafek. Ja ijegrekva Godri joifuon unam mukor iji jon rediak. Regavo ja kukma ijegreokva iji ja Asoijon varur gufia fino ijefuon afijaf igeg reken. ");
INSERT INTO nvm_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ijefuon ni izeg Asoijon fu oijfuon ijia jon oifian abeno ijeg jak e kafobuon oifian abefno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesu fu ijeg kuardiame kia, Jab e kafobuon ise iji giame kuaik. Ja ijegrekva God fuba ise jon giame kiaken. Regavo ja e kafobuon ise giame arekva God fu ise jon fuk fu giame arekfuon. ");
INSERT INTO nvm_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Regavo ire jon kafo ja nainva iji kege e roin vajiakva God fu una ijefuon roib uruvana vajiaken. Ja ijegrekva God fu e suaikin ijefuon fu ifejdiame una biom ma uruvana vajiakfuon. God fu unam jon ma iji izeg ja e kafobuon reoijo ijia God fu giame una unam besum ijeg jon rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesu fu ijeg kuardiame vo una madu vuak be bijame kuardiain. Fu kia, E ni zuriaigin iji fuba uri e ni zuriaigin be afeme unam nijaiok. Regavo fu afeme vakma bu busik buka mako uraken. ");
INSERT INTO nvm_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Rega madu igia faif. E sikur reno be fuba uri e fu nijaimo iji asime ik fuon fu reno iji reken. Regavo fu irerag uruvana e fuon fu nijaimo fu nijainma iji mimatame keoino iji fu efuon fu nijainma igegrekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Jesu fu ijeg kuardiame vo una madu kia, Ja irerafuon uviaijon ijefuon kafut ukakbe fu ni fuon ijia karino iji game kuagavo una kafut bomana iji fu ni on ijia karino iji aba gam? ");
INSERT INTO nvm_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","A kafut iji fu vek ni on ijia karino iji a izeg una uviaion iji kua, Uviainu ro na ni kafut guraiji samdainma iji kedamno kuak. E guri ka i kufuikin gurie amur ni on ijia kafut bomana iji karino iji ke akoze fu marga ni ijar una kafut ukakbe iji fu uviaion ijefuon ni ijia karino iji game ke akoze. Regavo a on iji aba ke akozekma ab una uviaion ijefuon iji game kuaikno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jesu fu ijeg kuardiame una madu vuak igi bijame kuardiain. Fu kia, In ma iji fu sunin ise iji kiramo bakin. Rega in ise iji fu sunin mukor kiramo bakin. ");
INSERT INTO nvm_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Regavo in besubesum bun sunin buon izeg bu kiravo ijia e bu giame vierafej. Regavo e bu duribat karekuai vierafekva bu va kajesan sunin iji karekva bakin. Regavo kof nubukva bu va sir iji nubukva bakin. ");
INSERT INTO nvm_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ijegvo madu e ma iji fu ire ma iji fu oijfuon ijia vierafeno fu iji kuaimoin. Regavo e ise iji fu ire ise iji fu oijfuon ijia vierafene fu ijin kuaimoinon. Ijefuon vuak irerag itit fuon ijia fu kuaimon iji fu oijfuon ijia vierafenma fu ijin kuaimnon kiain. ");
INSERT INTO nvm_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesu fu ijeg kuardiame una kia, Ja irerafuon na kie E Bomanakono kieknum ga irerag na kuardiavo iji ja rejo bakin? ");
INSERT INTO nvm_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Regavo na e iji bu nun ruaknum vuak nun iji faime igiemo iji fu e izekin na ijin kuardiakrejo ni faif. ");
INSERT INTO nvm_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","E iji fu mukor vierafeknum ar fuon iji munuag azan ijia sainma ijekin. Fu ijia samga do firame daro ijar kekome ar fuon bijamga fuba katin ga fuka gire manin. Ijefuon maiji fun amarigia vierafene sain. ");
INSERT INTO nvm_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Regavo e iji fu vuak nun faime vo fuba abe mimatamo iji fu e iji ba amarigia vierafene kudie fuon iji amarigia rume ijia ar sainma ijekin. Ijefuon do daro fu firame keko ar iji bijamga fuka migegare tuain. Fu unam ma ise ijia tua dijeme fuka bujame iserenmano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Areme Jesu fun ire uruvana e iji kuardiame barme fun una uri ar Kafoniam ijia vain. ");
INSERT INTO nvm_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Rega e Romkobuon e bomana ijefuon efuon ikreno be fu oijmamo iji fuka adam bomana abene fuka guakafa ijia fin. ");
INSERT INTO nvm_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ijefuon e Romkobuon e bomana iji fu faik Jesu fu Kafoniam ruainma faime fu uri e Jius e mamkanuk roin ijin kia, Va Jesu kuaga fu ro enun ikreno igi amarega fu una maimno kiama bu vain. ");
INSERT INTO nvm_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","E Jius ijiebuon e mamkanuk iji bun vake Jesu fino ijia usen. Bu useme soisoigin igia kua, E Romkobuon e bomana iji fuka e nuvuon iji oijmamo ga fuka fuonkua nuvuifuon ar iji e bu ijia afuime vuak kuaivo iji samduin. Ijefuon no vierafega a va fu ifejdakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Ijefuon Jesu fun buna vake e bomana ijefuon ar iji samairenma ijia e bomana iji fun kaifijaf kiama bu Jesu kuakuai ruain. Bu ro useme Jesu kuai, No E bomana nuvuon iji fu kume naba aresredo ab ar nun igia ruak. Regavo madu na koiknun vuakva na maturainva bakin ijefuon nin vuak nijiega enun ikreno igi fu maimno kumen. ");
INSERT INTO nvm_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Regavo madu fu kume, Nak na enun mamkanuk ijiebuon rotit ijia ikrej. Rega madu na enun bijaivo iji roin kareva bu rotit nun ijia ikrej. Ijefuon na e be kua ro kuavo iji fu rok. Regavo na una madu be kua vakne kuavo iji fu vak. Regavo na madu enun ba mon fuon ikreno iji be kua ire igi rene kuavo iji fu reno kumen. ");
INSERT INTO nvm_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","E iji vuak abe ruainva iji bu vuak ijeg Jesu kuardavga fu vuak iji faima fuka oiseren. Fu oiseremga fu una dakaroim e uruvana fu ja vako iji kia, Na ar Isrer guf igia e kafo bu e igi fu ma vierafenma ijekin naka ba giainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Fu ijeg kuardiako e iji vuak abe ruainva iji bun una va e Romkobuon e bomana ijefuon ar ijia useme gak e iji adam abenma iji fun una main. ");
INSERT INTO nvm_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Areme tavan ukakbe barko rad Jesu fun e vuak fuon faivo ijigam e uruvana roin ijiena uri mai Nein kuavo ijia vain. ");
INSERT INTO nvm_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Fu vake mai bomana iji bu karinva vien ijia kekoin. Fu ik ijia kekme ga bu e guainma iji abe useme mako rukuai rok. Rega e iji guainma iji fu bara amun be ijia fino ijefuon farifuon besum ijar. Ijefuon e uruvana mai bomana guf ijia karinva iji bu funa ijia usem rok. ");
INSERT INTO nvm_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bu usem rokga Jesu fu bara amun iji gama fuka bomana oifiaimga fu uri kua, A niraimo iji aremne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Fu ijeg kuame fun va mavua iji bu e guainma iji abe ijia abesme roko iji kunaime e iji mavua iji abe roko iji bu arega ijia iren. Bu ijia irekoga Jesu fu uri kua, E nivek ige nar kuavno urine kuain. ");
INSERT INTO nvm_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Fu ijeg kuamga e iji guainma iji fu una uri fine vua kuaimga Jesu fu abe una asiefuon unafdain. ");
INSERT INTO nvm_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Areme e uruvana bu unam sumakin iji Jesu fu renma iji gava buka bomana oiserdiame ka dejufdiain. Ijefuon bu uri Godon bomana oimarme kuai. E Bomana iji Godon vuak vierafene kuaimon iji fun iga ruainmano kuain. Rega madu e roin bu uri kua, God fun e fuon igi karauniakafa ruainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jesu fu unam sumakin iji rega e bu vuak iji dab e ar iror ijia karioinva ijia kuaime bomana re vain. ");
INSERT INTO nvm_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","20","Areme e Jonon vuak faivo iji bun uri ire uruvana Jesu fu renma ijin Jon kuardain. Bu kuardavga fu uri e nokarok (2) kiama bu roga fu kia, Ni va e gafi kuaga fun ma e iji fu ruakno kuainva ijar vo fu bano kiaga no una e be samuavno kiain. Jon fu ijeg kuardiamga bun vake Jesu fino ijia useme kua, Jon e bomana nuvuon e do ruardiafo iji fu kuo, Va a kuaga aiji a e iji God fu kua fu ruakno kuainma iji vo a bakma noba una e be samuakno kuain? ");
INSERT INTO nvm_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Regavo tavan ijia Jesu fu e adam abenva iji karauniaknum e iji kaven ise ninarukiainva iji kiaga bu useme vaknum ga e ni zuriaigin iji kiaga bu una ni narav. ");
INSERT INTO nvm_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Fu ijegreoinon ijia fu uri e Jonon vuak abe vainva iji kia, Ni una va Jon irerag ja ni jon ijia giaknum fainva ijin kuardaf. Va kuardame kua, E ni zuriaigin iji bun una ni narako e aikirariainva iji buk bun una uri oijno kuaf. Regavo madu e iji bu adam refrosi abenva iji bun una madiav revo e ada bijukuriainma iji bun una faiv ga e aoinva iji bun una urij. Rega vuak ma iji bun abe e isema karioijo iji kuardiavno kuaf. ");
INSERT INTO nvm_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Regavo erar fu ire igi na reoijo iji fu faime ba oi kafokafo vierafega fum na ma vierafeno e iji fuka oimarmne kiain. ");
INSERT INTO nvm_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","25","Fu ijeg kuardiamga e Jonon vuak abe ruainva iji bun una vakoga rad Jesu fu uri Jonon vuak iji dab e uruvana ruainva iji kuardiain. Fu kuardiame kia, Tavan iji Jon fu ai moikum namo ijia fikoga ja useme fuon vainva iji ja irerag iji ijia gakuai vierafene usem vain? Jakafu e zazaikin be fu buibur asif abeno igekin ja iji gakuai vain. Ki ja irerag iji gakuai vainva ni kuardie na faiv. Regavo baga na vierafe jakafu ja e iji bu sinuom zarainva ugon ka mukor same ijia oijo ja iji giakuai vierafene vain. Iji fuka bakin gavo e ijeg ugon mukor savo iji bu e mamkanuk moik samuavo ijiebuon ar ma ijia karij. ");
INSERT INTO nvm_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","27","Regavo ja vainva iji ja irerag iji ijia gakuai vain? Ja e Godon vuak vierafene kuaimon ja iji gakuai ki ja era gakuai usem vain? Ni kuardie na fai. Naka ma kuardiav, E iji ja gakuai vainva iji fu ma e Godon vuak vierafene kuaimon be. E iji fuka ma e aduigin fur e Godon vuak vierafene kuaivo iji fur asidiain. Regavo Godon buk akaij iji bu usuibe isoime kuainva iji bu fuifuon kuain. Regavo vuak bu isoinva ijia God fu ijeg kuai, Na e vuak nun abe oinon be kuaga fu amur vak. Fur amur unam jon iji amarme vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Regavo vuak igi naka ma kuardiav. E mamkanuk iji roin bu ur kari ruainva iji bu e Jon e do ruardiamo ijekin bakin. Regavo e Jon fur fuka ma e ikin ga fur bu asidiain. Regavo Godon e iji fu oijbuon iji samuagdiafo ijiebuon uf ijia e be erar una e ukakbe reno e ijar fu Jon asime ka e ikin rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Fu ijeg kuardiamga e uruvana abevo e takes abeoijo iji bu vuak iji fain. Bu faime vierafega Godon unam ma iji ijia kekfuon iji fuka maga bu ijeg vierafen. Ijefuon bu Jonon vuak iji igame fuon rokga fur aferdiame do ruardiain. ");
INSERT INTO nvm_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Regavo e Ferisis iji ga e roin vuak akai nijaidiavo iji bu Godon ma iji fu buifuon vierafenma iji buka uzame ba Jonon rokga fu do ruardiain. ");
INSERT INTO nvm_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesu fu ijeg kuardiame kia, Na e igi bu unam ma iji uzamoknum vo madu unam buon bu kegoijo ijiebuon nar bijame kuaikno ni faif. ");
INSERT INTO nvm_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","E iji bu God uzavo iji bu am ukaknak iji bu va ar iji bu ire kimejo ijia useme ata roinroin rene karijo ijekin. Am roin bu uri una roin kume, No joifuon zaij vajaga jaba dua uruv. Regavo roin bu uri kume, No joifuon sise bijadiaga jaba niraivno kumejo bu ijekin. ");
INSERT INTO nvm_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ijegvo Jon e do ruardiamo fu ruainma iji fu tavan kafo duok karoknum ga do kugin iji fuba ioin. Fu ijegreoga ja kuai fu kaven ise ijar fusik oinon kuain. ");
INSERT INTO nvm_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ijegvo Ema ijiebuon Farif igi na ruainva iji na unam besum ijeg duok iknum do vuain ioijga ja kuai, E iji gaf. Fu duok uruvana iknum do vuain uruvana ioinon kuain. Regavo ja madu kuai fuka e takes abeoijo ijiga e ise ijiena kaireoino kuain. ");
INSERT INTO nvm_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Regavo igia fai. E ma vierafejo iji bu Jon ik irerag fu renma ga na reoinva iji bun giame vierafen. Bu vierafero God irerag fu vierafene reno iji fun mukorigia renoro bu ijeg vierafejno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jesu fu ijeg kuardiame barekoga e Ferisi be fu uri Jesu kuama fu fusik ar fuon ijia duok ikafa vain. Jesu fun va ar fuon ijia kekome duok ikafa ari fin. ");
INSERT INTO nvm_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Rega bara mai ijekor be ijia fino iji fuka ise uruvana reoinon. Ijefuon fu faik Jesu fu e Ferisi ijefuon ar ijia duok ikafa ruainma faime fun uri saror bu do jiavo iji abe ire udi mukor urino iji abe ijia useme abe ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Fu abe keko Jesuon nuon iji diak fu korenma ijia manine niraiko nido fuon ijar Jesuon diak azan ijia arin. Fu ijegrene uri nigen jau fuon ijia fidame fun uri diak iji kam irkuardiame uri do iji udi mukor urino iji abe ijia usemdain. ");
INSERT INTO nvm_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Rega e Ferisi iji Jesu kuama fu fusik duok ikafa vainma iji fu bara iji irerag fu reno iji gain. Fu game uri fui kuai, E igi fu ma e Godon vuak vierafene kuaimon ijarkma fu bara iji fu izekin ijar fu niriamo iji fu vierafekno kuain. Regavo madu bara iji fu unam ise izekin kegoino iji fu vierafekno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ijegreare Jesu fun uri kua, Saimon na vuak be kuardakno ni faimne kuain. Fu ijeg kuardamga Saimon fu uri kua, E nijaidiamon nin kuardiemne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","42","Fu ijeg kuardamga Jesu fu uri vuak be ijeg bijame Saimon kuardain. Fu kua, E nokarok (2) bu e sinuom uruvana renma iji monfuon kuavga fu e be mon ukakbe maga be fuka mon bomana main. Rega bu mon fuon iji una vajakuai vierafe gavo buba aresrenva ijefuon fu kiama bu ijia aren. Bu ijegrenva ijia a vierafega e nokarok (2) iji e izar fu e sinuom uruvana renma iji fuon ma bomana oimaremno kuain? ");
INSERT INTO nvm_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Jesu fu ijeg kuardamga Saimon fu uri kua, Na vierafega e iji fu mon bomana abenma ijarno kuain. Fu ijeg kuardamga Jesu fu una kua, Iji a ma kuainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Areme fu dakaroim una bara iji gavknum Saimon kua, A bara igi abe gain? Na ar on igia ajie rokga aba diak tat nun iji do somdien. Regavo fu bara igar nido fuon ijia diak tat nun somdieme nigen jau fuon ijia fidien. ");
INSERT INTO nvm_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","47","Regavo madu aba na oimardieme na irkuardien. Regavo fu bara igar na rokga fur ba arega fuka uri dia tat nun iji kam irkuardiain. Regavo madu aba nigen jau nun ijefuon ire udi mukor urino iji abe azirdien. Regavo fur ire iji ka udi mukor urino iji abe diak tat nun igi somdien. Ijefuon na gaga fuon oijmiemo iji fuka ma bomana ijefuon maiji ise fuon uruvana fu keoinma iji nan game aren. Regavo e be erar ise fuon fu reoinon iji na sibank giame arenva iji fuon oijmiemo iji fuim ma ukakbeno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jesu fu ijeg kuardiame uri bara iji kua, Ise on iji nan giame arenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Regavo e kafo fata irif ijia karioinva ijieb uri kua, E iji fu God aikido fu e kafobuon ise giame aremno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Regavo Jesu fu uri bara iji kua, On a ma vierafeno ijar a keunainma ijefuon aib una ijin bomana vierafegavo ni dazme vakne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ijegreare tavan sibank barko rad Jesu fu mai ga ar ukaknak besubesum guf ijia oknum e iji God fu izeg oijbuon iji samuagdiafo ijefuon vuak ma iji abe e uruvana kuardiaoin. Regavo iji fu ijegreoinma iji fu e tuer (12) vuak fuon faivo ijiena oknum ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Regavo fu madu bara roin vajai matan abenva ijigam bara roin kaven ise ijieb kam nirokiava Jesu fu karauniainma ijieb funa vain. Regavo bara be iji Meri (bara iji bu kua Megdarino kuavo) fu kaven ise imut roin ga nikit nokarok (7) iji bu dab ninaruoijo Jesu fu kiama bu usem vainva ijin. Rega kafo iji bara e Susa e iji fu Erodon ar bomana ijia fuifuon ikreno ijefuon bara Joana ga bara Susana ga bara uruvana roin ijieb funa vain. Bara ijieb mon buon ga ire buon ijia Jesu ga e vuak fuon faivo iji samuagdiame duok iknum vajiain. ");
INSERT INTO nvm_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Areme Jesu fu giaga buka vek e uruvana biome vuak fuon iji faikuai roka fu giain. Ijefuon fu uri vuak igi bijame kuardiain. ");
INSERT INTO nvm_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Fu kia, E be fu juar fuon ijia uij dajaikafa vain. Fu va juar ijia uij dajaikoga kafo bu uduime unam iji e vuimoijo ijia arivga bun um ijieb useme roin bun ine baren. ");
INSERT INTO nvm_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Regavo roin bu uduime munuag azan ijia arime bun tavuavo ijia bu sairen. Ijefuon maiji moik iji fu safik bakin. ");
INSERT INTO nvm_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Rega uij roin bu uduime tarar ijia arime tavuavga fun ufien gurogin ijieb kam okuriain. ");
INSERT INTO nvm_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Regavo uij roin bu uduime moik mukor safikin ijia ari tavuame buka mukorigia sunin kirain. In besubesum sunin fuon fu kirainma iji fuka uruvana vuan adred (100) ijeg kirainmano kiain. Regavo Jesu fu vuak ijin kuardiame barme kia, Ja adakiga ni vuak igi amarigia faifno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","10","Areme rad e vuak fuon faivo iji bu vuak ijefuon ma iji buba vierafenva ijefuon bu uri Jesu kuardain. Bu kuardavga fu uri kia, Godon vuak sauivkin iji izeg fu efuon ijiebuon oij iji fu samuagdiafo iji fun fuon vierafenma ijia abe samafrena jan gain. Regavo una e iji roin bu God uzavo iji na ijeg bijame kuardiaikin bu nisaik gavo buba giak. Regavo bu faikva buba amarigia vierafekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","12","Jesu fu ijeg kuardiame kia, Vuak iji na bijame kuardiaiva ijefuon ma iji igin. Uij iji Godon vuak ijin. Rega uij bu uduime unam e vuimoijo ijia arinva iji e iji bu Godon vuak iji fain. Regavo kaven ise Setanri oijbuon ijia vuak iji abe vakok buba God ma vierafeko fu bu karauniamo ijin. ");
INSERT INTO nvm_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Regavo uij iji uduime munuag azan ijia arime tavuame una sairevo iji e iji bu Godon vuak iji oimarknum faiv gavo ba kege oij buon ijia gigikin vierafejo ijin. Regavo bum tavan ukakbe ijia ma vierafe ga ise kafo buon roko iji buka ijia arevo ijin. ");
INSERT INTO nvm_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Regavo uij roin bu uduime gurogin uf ijia arinva iji e iji bu Godon vuak iji faiknum ga una moik igefuon ire kafokafo vierafeknum ga una vajai buon bu oi madiakfuon iji vierafejo ijin. Bu karine mon ga duok ga ire uruvana igia uruvana vierafejo ijefuon bu Godon vuak iji fu uij igeg abe oijbuon ijia oinma iji fu tavuame ajie sunin kiramo bakin. ");
INSERT INTO nvm_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Regavo uij iji moik ma ijia arime mukoi tavuame sunin kiravo iji e iji bu Godon vuak iji amarigia faime oijmame abe oijbuon ijia abedevo ijin. Bu abe oijbuon ijia abedeme uri giriesame nuibakin rene kaifijaf roin nijaidiaga buk rad Jesu ma vierafejo ijin. ");
INSERT INTO nvm_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesu fu ijeg kuardiame una kia, E be fu erar ikuosaij abe saname fata rotit ijia sauikma bakin. Regavo fuka abe saname samakaf ijia abedega e uruvana bu ijia gavknum aru vaken. ");
INSERT INTO nvm_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ijefuon irerag uruvana bu kege sauivo iji rad bu kege samakaf ijia roga bu giak. ");
INSERT INTO nvm_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ijefuon amarigia juknum faif. Erar ire uruvana kenma iji bu madu una ire kafo uruvana vajak. Regavo erar ire kafo bakikma iji ire sibank fu nainma iji buka karevakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesu fu ijeg fine vuak nijaidiamon ijia asiefuon ijiga uviaifijaf bu fu gakuai ruain. Rega Jesu fu e uruvana ijiebuon nifak ijia oinon ijefuon bu ro makaf ijia samuame iren. ");
INSERT INTO nvm_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ijefuon e be fu kekome Jesu kua, Asieon ijiga uviaifon bu a gakuai ro makaf gafa irenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Fu ijeg kuamga Jesu fu una dakaroime kia, Asienun ga uviaifnun iji e iji bu Godon vuak iji faime igiavo ijino kiain. ");
INSERT INTO nvm_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Areme tavan be Jesu fun e vuak fuon faivo ijiena sisim ijia ajieme kia, Ruano do igi daturaiko nafuinma irif gara vakno kiame bun anerene sisim abe vain. ");
INSERT INTO nvm_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bun sisim abe vako ijia Jesu fu ninain. Fun ninaikoga buibur ka bomana ijar bu vako do azan ijia ufin. Fu ufiko do iji fun guf ijia arume irtoijme fuka sisim dab dakaroiga bun aoikfuon ijia ren. ");
INSERT INTO nvm_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ijefuon e vuak fuon faivo iji bun useme Jesu same kua, E Bomana E Bomana noka aoikuai samairenvano igi guomne kuain! Bu ijeg kuavga Jesu fun uri buibur ijiga do iji darokma fira rokon iji kuama fu bakite vako do iji fun narume una ur nainma ijeg nain. ");
INSERT INTO nvm_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Areme fu uri e vuak fuon faivo iji kia, Jon ja ma vierafejo iji fu izegrenmano kiain? Fu ijeg kuardiamga buka oiserdiame dejufdiain. Ijefuon bu bui kua, E igi fu e izekido fu buibur ijeko do igi firame darokma rokon iji fafdiamga bu fu igame arenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Areme bun sisim abe do Gareri daturaiko nafuinma gara e Gerasako karinva ijia vain. ");
INSERT INTO nvm_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Regavo Jesu fu ik dia jafe jier azan ijia vuikoga e be ar ijeko ijar fuon ruain. Regavo e iji fu kaven ise ijieb fu dab ninaruv. Fu ar fuon iji fun usuibe areme va munuag tit bu e aoiga kege uniavo ijia fioin. Rega madu fu sinuom kafo samo bakin gavo fum detabar oinon. ");
INSERT INTO nvm_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ijefuon fu tavan ijia Jesu game uri nifak fuon ijia ato same uruvana biumame kume, Jesu God E Bomana kaf gufia fino ijefuon farif guri a irerag iji nun rekafa vierafen? E-e na anadame kuavno ab na abe arafiriekno kumen. ");
INSERT INTO nvm_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Fu ijeg kumenma ijefuon maiji Jesur amur kaven ise iji kiama bu fu areme vainva ijefuon fu ijeg kumen. Regavo madu buka tavan kafo e iji dab ninaruoijo. Ijefuon e aivo iji bu uri e iji kunaime dab e diburko igeg sen kam imut ga masian fuon iji kam tomdain. Bu tomdavo fu kam turakoreko kaven ise ijieb fu dab ninarume ai moikum namo ijia oij. ");
INSERT INTO nvm_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ijefuon Jesu fu kua, A ifon iji erano kuama fu kua, Na ifnun Uruvanano kuain. Fu ijeg kuainma ijefuon maiji buka kaven ise uruvana fu dab ninaruoijo. ");
INSERT INTO nvm_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kaven ise ijieb uri Jesu soisoime kua, E-e a no ab kege mako iji dibuor bakin ijia sakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Regavo ar bu maf samuagdiavo iji fu uruor be manino samaij ijia. Ijefuon kaven ise iji bu maf ijiebuon oij ijia arikuaim Jesu soisoin. ");
INSERT INTO nvm_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ijefuon Jesu fun kaven ise iji kiama bu e iji areme usem maf uruvana ijin kam ninaruva bu usem subinai ar igegamekin ijia arime do ine aoin. ");
INSERT INTO nvm_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bu ijegrejga e iji maf samuagdiavo iji bu ire iji renma ijin giame bun usem kukubija mai buon ijia e mamkanuk iji abe vo e juar mejo iji kuardiame vain. ");
INSERT INTO nvm_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bu vuak iji abe va kuardiavga e uruvana bu iji faime ire iji renma iji gakuai ruain. Bu ro Jesu fino ijia useme gak e iji kaven ise ijieb fu dab ninaruoijo iji fu Jesu manino samaij ijia fina bu game buka juin. Bu jume kuai, E iji kaven ise ijieb niroinva iji fun una e ma rene ugon same gafa fino kuain. ");
INSERT INTO nvm_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ijegreare e iji bu fu gainva ijieb vuak iji abe una va e roin ijin kuardiain. ");
INSERT INTO nvm_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ijefuon e ar Gerasa guf ijia karinva iji bu useme Jesu rotkurain. Ijefuon maiji buka uruvana igia juinva ijefuon Jesu fun una sisim abe vain. ");
INSERT INTO nvm_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Regavo e iji kaven ise bu fu niroiva Jesu fu kiama bu usem vainva iji fu Jesu soisoime kua, E-e ni kiega na osik vakno kuain. Fu ijeg kuardamga Jesu fu vuak igin kuardame kuama fun vain. ");
INSERT INTO nvm_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Fu kua, Ni una va ar on ijia God irerag fu on renma iji abe e roin kuardiamno kuain. Fu ijeg kuardamga e iji fun mai ijia oknum irerag Jesu fu fuon renma iji e uruvana kuardiaoin. ");
INSERT INTO nvm_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Areme Jesu fun e vuak fuon faivo ijiena bun una sisim abe do Gareri urame gara vain. Rega e uruvana bu fu samuame ijia karinva ijefuon Jesu fu vakga bu fu oimardain. ");
INSERT INTO nvm_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Areme ebe Jairasno kuavo iji fu ar iji bu afuime vuak kuaivo iji samuamo. E ijar ro Jesu ato same soisoime kua, Abe nosik ar nun ijia vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ijefuon maiji kabainun juaivasia tuer (12) ijeg barenma ijar adam abene guakafaren. Rega fu am kafo bakin ga fun kabaifuon besum ijesugin. Fu ijeg kuamga Jesu fu uri e iji jame vakga e uruvana buk bu uri buna vain. Regavo bu vek unam ijia vako ijia e uruvana bu vierafega buka Jesu vako uikinik fuon ijia vakuai buka bui ajifnamuiknum vain. ");
INSERT INTO nvm_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Rega bara be fu ijia buna vako iji fu ise fi ruake fuka juaivasia tuer (12) ijeg baren. Regavo kavuan iji arifon fuba baren. Ijefuon tavan uruvana fu va e adam giavo iji giam gavo kavuan fu arifon iji fuba baren. ");
INSERT INTO nvm_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ijefuon bara iji fu e ijiena ijia rokdo fu uri Jesuon ugon ijia kunaima kavuan fu arifon iji fuka migegareigia baren. ");
INSERT INTO nvm_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Bara ijar ijegrega Jesu fu faime kia, Erar na niriakienmano kiain? Fu ijeg kiamga e uruvana bu kua, No bano kuain. Rega Fita fu uri kua, E Bomana buka e uruvana a dab kirakuravno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Fu ijeg kuamga Jesu fu kua, Na fai e be fu na niriakiema nan fain. Ijefuon maiji daro nun roin bun usem e ijefuon vaka na fainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Rega bara iji fu gak izeg fu renma iji Jesu fun faiga fuka bomana juvknum ro Jesuon nifak ijia ato sain. Areme fu e uruvana ijiebuon nifak ijia fu irerafuon Jesu niriainma ijin kuardain. Fu iji kuardame madu fun izegrena adam fuon fu migegare mainma ijin kuardiain. ");
INSERT INTO nvm_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Fu ijeg kuardamga Jesu fu uri bara iji kua, Kabainu on a ma vierafeno ijar adam on iji fun mukoi barenmano nin va tavan bog oimarknum oine kuain. ");
INSERT INTO nvm_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesu fu vek manine bara ijin ijeg kuardamo ijia e vuak abe oino be fu e Jairason ar ijia ruain. Fu ro kekome Jairas kua, kabaion fun guainma ijefuon e guri E Nijaidiamo iji a afekafa vierafeno iji aremne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Fu ijeg Jairas kuamga Jesu fu vuak iji faime Jairas kua, Ab oifian abekgavo nin ma vierafega kabaion iji fu una maimno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Ijegreare Jesu fu vake Jairason ar gafia kekome giak e uruvana bu bara ukak ijefuon oifian abene niraiv. Bu niraivo ijia fu keko kia, Bara ukak iji fuba guain revo fum ninainmano ja niraivo iji arefno kiain. Fu ijeg kiamga e uruvana bu vuak fuon iji buba ma vierafenva ijefuon bu Jesu dab varaimene kijdain. Ijefuon maiji bu vierafega bara ukak iji fun ma guain. Regavo Jesu fu uri Fita ga Jon ga Jeims ga bara ukak ijefuon asoij ijigam asie ijin aferdiame ar guf iji bara ukak fu namo ijia aru vain. ");
INSERT INTO nvm_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesu fu arume bara ukak iji imut kene kua, Kabainu ni una urimne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Fu ijeg kuamga bara ukak ijefuon kaven fu una fuon rokga fu migegare una urina Jesu fu una eofijaf kiama bu duok vajavga fu in. ");
INSERT INTO nvm_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jesu fu ijegrega bara ukak ijefuon eofijaf iji buka oiserdiame vuaturiamga Jesu fu kia, Jab va ire igi na reja ja gienva iji jab e kafo kuardiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ijegreare tavan be Jesu fun e vuak fuon faivo tuer (12) iji kumena bu besum afuin. Bu afuiva fu kia, Na ivia ja daro miame kiavo ni va e iji kaven ise ijieb ninarukiainva ijigam e iji adam kafokafo abejo iji karauniafno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Fu ijeg kuardiame madu kia, Nin va vuak ma iji izeg God fu koikfuon una efuon ijiebuon oij iji samuagdiakfuon ijin abe kuardiaknum vo e adagin iji karauniaf. ");
INSERT INTO nvm_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Rega jab guduar ga kamui ga duok ga mon ga sinuom kafo kege vak. ");
INSERT INTO nvm_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Regavo ni vaga e ar be bu ja oimardiaknum aferdiaga nin ar ijesugin karine vake mai iji areme vaf. ");
INSERT INTO nvm_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Regavo eraneb buba ja oimardiakva ni dia tat jon ijia ireme anf odiame kuotuvat kanaseme nin mai iji areme vafno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Rega e vuak fuon faivo iji bun uri mai besubesum ijia oknum Jesuon vuak ma iji abe kuardiaknum e adagin iji karauniamoin. ");
INSERT INTO nvm_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Bu ijeg kegoijo ijia e Erod ar Gareri samuamo iji fu ire uruvana bu reoijo iji faime fuka ba ma vierafen. Ijefuon maiji e roin bu kuai Jon e do ruardiamo iji fun una urinmano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Rega madu e roin bu kuai e Eraijar una ruainmano kuain. Regavo e roin bu kuai bu e iji usuibe Godon vuak vierafene kuaivo iji aoinva ijia e bes una ruainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Bu ijeg kuaivga Erod fu uri kia, Na Jonon nigen iji nan kaname daturain revo e igi na erafon vuak iji una faivno kiain? Fu ijeg kuardiame uri unam izeg fu Jesu biekfuon iji giriesame nisain. ");
INSERT INTO nvm_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Areme e afasor iji bun una useme irerag uruvana bu reoinva ijin Jesu kuardain. Bu kuardavga fun aferdiame buonkua ar Betsaidano kuavo ijia vain. ");
INSERT INTO nvm_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bu ijia vakrejga e uruvana bun fain ijefuon bun uri buna vain. Bu vakga fu oimardiame are aferdiame izeg God fu oijbuon iji samuagdiakfuon ijin kuardiaknum e adam abejo iji karauniain. ");
INSERT INTO nvm_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ijegreare tavan kokreno ijia e vuak fuon faivo iji bu useme kua, E igi kiaga bu una mai iji e karijo ijia duok bu ikfuon ga ar bu naoikfuon iji nisaim vaf. Ijefuon maiji ar igi fuka ai moikum namo igiano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Bu ijeg kuardavga Jesu fu uri kia, Jar duok kafo vajia bu ijno kiain. Fu ijeg kiamga bu una roin kua, No duok uruvana bakigavo no bred imut roin (5) ga kijum nokarok (2) ijesugin. Regavo a vierafega nobe e uruvana ijiebuon duok kimekno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Rega e ijia karinva iji e baru ijesugin bu e faiv taosen (5,000) ijeg. Ijefuon Jesu fu uri e vuak fuon faivo iji kia, E iji kiaga bu e fifti (50) ijeg afuime kafokafo karifno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","16","Fu ijeg kiamga e vuak fuon faivo iji bun fu kiainma ijeg e uruvana kiava bu ari karin. Bun ari karikoga Jesu fun bred imut roin (5) iji ga kijum nokarok (2) iji kege varur gufia gavknum Godon sirimamen. Ijegreare fun ke tuaseme e vuak fuon faivo iji vajiama bu kege e iji vajiain. ");
INSERT INTO nvm_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bu vajiavga e uruvana bu duok iji ine buka aresrega e vuak fuon faivo iji bun ter tuer (12) ijeg kege duok ukur iji kareme ijia anuin. ");
INSERT INTO nvm_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tavan be Jesu fu fuonkua sirimameno ijia e vuak fuon faivo bu fuon ruain. Bu rokga fu uri kia, Ja vierafega e uruvana bu vierafe naiji na erano kiain? ");
INSERT INTO nvm_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Fu ijeg kiamga e vuak fuon faivo bu una kua, E roin bu kuai aiji a Jon e do ruardiamo ijin. Rega roin bu kuai, Aiji a Eraijano kuain ga kafo bu kuai aiji a e amur Godon vuak vierafene kuaivo be ijar una ruainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Bu ijeg kuardavga fu kia, Regavo jaiji ja vierafega naiji na erano kiain? Fu ijeg kiamga Fita fu uri kua, Aiji no vierafega a e iji God fu kuaga fu ruakno kuainva ijino kuain. ");
INSERT INTO nvm_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Fu ijeg kuamga Jesu fu uri vuak gikin kuriaireme kia, Jab e kafo vuak iji kuardiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ijegreare Jesu fun uri kia, Ema ijiebuon Farif igi naka uruvana vajai fian abekfuon. Regavo e aiko ijiebuon e mamkanuk ijigam e Godon isuf baroijo ijiebuon e mamkanuk ijigam e akai nijaidiavo iji roin buka na uzaken. Buka uzame unam ise kafokafo ijia na dab arafiriega naka uruvana igia vajai fian abene guak. Revo naki nokbek (3) barke God fu kiega na una madu urikno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Areme fu uri e uruvana kia, E iji erar vierafega fu nosik vakma fuka tavan bog ire fok fu vajainma ijefuon vierafeno iji nuigafiakfuon. Fu ijegrene uri vajai fian kafokafo bu fuon roko ijia ka magaga giriesame nuifuon ikrekfuon. ");
INSERT INTO nvm_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Regavo erar fu moikigia tavan bog fuon vierafe iji oijmiaknum fiokma rad fu una izeg unam ma karivako iji abekma bakin. Regavo erar fu moikigia tavan bog una e roin vierafeknum oijmiame ifejdiakma fu rad unam ma karivako iji abek. ");
INSERT INTO nvm_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Regavo erar fu moik igefuon sinuom igi oijmiagavo God fu uzakma kaven fuon iji fun abe aberen. Ijefuon maiji fu moik igefuon ire ijieb fu ifejdaga fu Godon ar ma iji abekma bakin. ");
INSERT INTO nvm_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Regavo eraneb bu na jume madu bu vuak nun faikuai jukva Ema ijiebuon Farif igi nasik tavan radkma ijia bu uzaken. Na tavan iji na una nun sanainma ijiga Asoinun ga anera ijiebuon sanainma ijekma roko ijia na ijeg reken. ");
INSERT INTO nvm_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Regavo vuak igi naka ma kuardiav. E kafo igia karinva iji jaba aoik ga ja vek karinva ijia ja tavan iji God fu una efuon ijiebuon oij iji samuagdiakfuon iji fu roga ja ni jon ijia gakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jesu fu vuak ijeg kuardiame vuik besum (1) barko ijia fu uri Fita ga Jon ga Jeims iji aferdiame uruor be makaf ijia sirimamekafa vain. ");
INSERT INTO nvm_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Fu va fine sirimameno ijia uikinik fuon iji fuka una nibe rekoga ugon fuon fu sainma iji fuka mukorigia sanain. ");
INSERT INTO nvm_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Fu ijegreko migegare e nokarok (2) Mosis ko Eraija bum ijia funa ireme vuak kuain. ");
INSERT INTO nvm_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","E nokarok (2) iji bum varur ijefuon sanainma ijekma arime izeg God fu Jesur Jerusarem ijia vajai fian abe guakfuon iji kuainma bu iji funa kuaiv. ");
INSERT INTO nvm_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Regavo Fita ga Jon ga Jeims bu ni nadiama bun ni naoin. Regavo buka ijia una migegare turanamime uri Jesuon sanainma ijiga e nokarok (2) iji funa irenva iji giain. ");
INSERT INTO nvm_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Areme e iji bun Jesu areme vakga Fita fu uri Jesu kua, E bomana noka magoi igia ruain ijefuon na vierafe no ar muvua nokbek (3) be on ga be Mosison ga be Eraijaon igia sakno kuain. Regavo vuak irerag Fita fu kuaimon iji fuka ba mukoi vierafen gavo fum ijia kuain. ");
INSERT INTO nvm_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Fita fu vek vuak kuaimon ijia vana bomana ijar oine iji bu irenva ijia okuriakoga bu rotit ijia juvknum aru iren. ");
INSERT INTO nvm_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ijegreko ijia God fu vana guf ijia kume, E iji fu farinun nar kuava fu ruain. Ijefuon vuak fuon fu kuardiamo iji mukoi faifno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Areme vuak iji kuaimon fun arekoga Jesu fu fuonkua ijia manina bu gain. Areme e Jesuon vuak faivo iji bun tavan ijia ire uruvana bu giainva iji buba e kafo kuardiain. ");
INSERT INTO nvm_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ijegrene afarma bu uruor makaf iji areme ari vakoga e uruvana bu useme Jesu bien. ");
INSERT INTO nvm_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Areme e be fu e uruvana ijiebuon uf ijia uri Jesu biumame kume, E nijaidiamon e-e farinun ka besum igin ga. ");
INSERT INTO nvm_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Farinun igi fu kaven ise ijar fum tavan kafokafo ijia ro kanaga fu moik ijia dije name aramavknum niraime ir tatan arim. ");
INSERT INTO nvm_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Rega na e vuak on faivo iji soisoime kia kaven ise iji azofdafno kiain revo bu ifejdaga fuka iserenmano kumen. ");
INSERT INTO nvm_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Fu ijeg kumega Jesu fu uri efuon ikrejo iji kia, E guri ka ba ma vierafejo gurie. Ja vierafe nakafu tavan izeg igia jana figa jason ijia nana oij besum rene God ma vierafek? Amon iji afeme igia roga na gavno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Fu ijeg kuama am iji fun Jesu manino ijia roko ijia kaven ise ijar ka uruvana igia am iji kaname dab moik ijia akoren. Ijefuon Jesu fu uri kaven ise iji kuriairega fu am iji areme vakga fu abe una asoifuon iji main. ");
INSERT INTO nvm_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Jesu fu ijegrega e uruvana bu Godon daro ka ma bomana iji gava buka oiserdiain. ");
INSERT INTO nvm_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","E uruvana bu vek karine irerag Jesu fu kegoino iji kam uruvana igia vierafejo ijia Jesu fu una e vuak fuon faivo iji vuak igi kuardiain. Fu kia, Vuak igi na iviakma kuardiakrejo igi mukoi vierafegavo jab rubdiak. Ema ijiebuon Farif igi naiji bu abe una e ani iji miakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Regavo e vuak fuon faivo iji bu Jesu fu irerafuon vuak ijin kuardiamo iji buka ba vierafen. Ijefuon maiji Godon Kaven ijar nigen buon fuba samafrediain. Regavo madu bu vuak iji Jesu fu kuardiainma ijefuon kua faikuai buka juin. ");
INSERT INTO nvm_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Areme tavan be e Jesuon vuak faivo iji bu erar fu e bomana rekfuon bu ijin dab bui kuaime sigunamin. ");
INSERT INTO nvm_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","48","Bu ijegrejga Jesu fun irerag bu vierafejo iji fun giain. Ijefuon fu uri am ukak iji afeme fu manino ijia uname uri kia, Erar ifnun ijia am ukak igi oimardakma e iji fu na oimardiek. Revo erar na oimardiemo iji fu madu e iji fu na kiema na ruainva iji oimardak. Ijefuon maiji e uruvana jon uf ijia e ukaknak iji bu e mamkanukno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jesu fu ijeg kuardiamga Jon fu uri kua, E Bomana e be fu ifon ijia kaven ise iji kuama fu keko vakga no kuava fu aren. Ijefuon maiji fu nona besum oinon bano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Fu ijeg kuardamga Jesu fu una Jon ga e vuak fuon faivo iji kia, Jab kuaga fu arek. Ijefuon maiji erar fuba ja nuigafiamo e iji fu una jana rene ja ifejdiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Areme tavan iji Jesu fu una varur gufia ajie vakfuon iji fun samairenma ijia fu una Jerusarem vakafa vierafene uri vain. ");
INSERT INTO nvm_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Fu e vuak fuon faivo iji kiama bun amur va e Sameriako buon mai ijia ire uruvana fuifuon kanafuin. ");
INSERT INTO nvm_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Regavo e ijekor iji buba fu afen ijefuon maiji bu vierafero fun Jerusarem vakafa vakoro bu ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Bu ijegrejga e vuak fuon faivo nokarok (2) e Jeims ko Jon bu giame una Jesu kua, E Bomana a vierafega nobe varur gufia mian kumega fu ari e igi kege arafiriakno kuain? ");
INSERT INTO nvm_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","56","Bu ijeg kuavga Jesu fu uri kuriairema bun una mai be ijia vain. ");
INSERT INTO nvm_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Areme Jesu fu e vuak fuon faivo ijiena unam ijia vako ijia e be fu uri Jesu kua, A izer vakma nak naka osik ijia vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Fu ijeg kuardamga Jesu fu una kua, Siroij taraiko foksno kuavo ijiga um iji bu mako ga nait buon bu amarenva bu ijia kariknum oij. Regavo Ema ijiebuon Farif igi naiji na ar na naijo ga fikfuon iji fu bano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Fu ijeg kuardiame fun una e be iji kua, Na jajiemne kuain. Regavo e iji fu kua, E Bomana ni areke na amur va asoinun samuake fu guaga na abe mako rume una javno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Fu ijeg kuardamga Jesu fu una kua, Erar buba oi karoime na ma vierafejo iji bun aoinva igekino ni arega bur e iji aoivo iji kege mako ruf. Regavo aiji ani uri vuak iji God fu izeg una e fuon ijiebuon oij iji samuagdiakfuon ijin abe e uruvana kuardiamne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Regavo e be fu kekme kua, E Bomana nak na a jakafie vierafen gavo ni areke na amur va aganun anadiame una a javno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Fu ijeg kuardamga Jesu fu kia, E be erar uri unam nun ijia reoknum ga una moik igefuon ire kafokafo vierafeno e iji fuba aresredo fuba una Godon e iji fu oijbuon iji samuagdiamo ijiena besum mazikno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Areme rad Jesu fun uri e seventi tu (72) ijeg kege e nokarok (2) ijeg ke mazime kiama bu amur useme mai iji fu vakma ijia vain. ");
INSERT INTO nvm_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Fu ijegreare uri vuak be ijeg bija kuardiame kia, Juar ijia ire uij uruvana fun duin. Regavo bu e iji uij iji kanafukfuon iji buka uruvana bakin. Ijefuon ni sirimamene una e uij koikin iji kuaga fur e ikrejo roin kega bu uij iji kanafukfuon. ");
INSERT INTO nvm_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Regavo igia faif. Jaiji na maf-sif igeg kege siroij kuriai e jakiamo ijiebuon uf ijia uniaga ja vak. ");
INSERT INTO nvm_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Regavo ja vakva jab kamui ga faus ga tamag kafo kege vak. Revo madu unam ijia ja vako ijia jab e kafo biediame anadiame ijia irem saroik. ");
INSERT INTO nvm_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Regavo ar amur iji ja ajievo ijia ni e iji karinva anadiame kia, Ni afurvene kariof. ");
INSERT INTO nvm_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Regavo ja gaga e iji fu unam afurvejo iji fu mukoi kegoino ijar ijia finoga ni arega daro iji ja mainva iji fu fusik navakfuon. Revo fu bakma ni God kuaga fu daro iji ja mainva iji una abe. ");
INSERT INTO nvm_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Regavo fu ja oimardiame aferdiakma ni ar besum ijia karine duok ga do fu vajiaga iji if. Ijefuon maiji e ikreoino iji fu ik fuon fu reoino ijefuon maiji abekfuon. Regavo jab ar be ijia ajie vo una ari be ajievknum ijeg reok. ");
INSERT INTO nvm_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Regavo madu ja mai kafo ijia vaga e bu ja oimardiame aferdiakva ni ijia karine duok bu joifuon kanafukva iji if. ");
INSERT INTO nvm_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Regavo madu ni e mai ijia adam abejo iji karauniaknum vuak iji God fu izeg efuon ijiebuon oij iji samuagdiamo ijin kuardiaf. ");
INSERT INTO nvm_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Regavo ja mai kafo ijia vaga e buba ja oimardiakva ni una usem unam ijia vaknum kia, Mai jon igia kuotuvat iji bu dia tat nuvuon igia kamafduokva iji non una azome jon dajaiv. Regavo ni kia tavan iji God fu efuon ijiebuon oij iji samuagdiamo iji fun samaij ijajarno kiafno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Jesu fu vuak ijeg e vuak fuon faivo iji kuardiame madu kia, Vuak igi na ma kuardiav. Tavan iji God fu ar Sodom arafirinma iji fum sibank. Regavo una mai iji eraneb ja vaga bu ja uzakva God fuka bu kam ma arafiriakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","E mai Korozinko bu vajai fian abekrejo ijegvo e mai Betsaidako iji jak jaka ijeg vajai fian abek. Ja ire sumakin iji na nifak jon ijia renva iji na mai Saidon ga Taia guf ijia ijegrenvabatie e ijekor iji buka usuibe uri ise buon ijefuon oifian abe duok karokfuon. Bu ijegrene vierafero ise buon uruvana bu renva iji bun nuigafiainvaro bu ijeg vierafek. ");
INSERT INTO nvm_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Regavo tavan radkma iji God fu una ise nuvuon ke mazim guomon ijia fu ar Taia ga Saidon iji fum sibank arafiriak. Regavo una e Korozinko iji ja fuka ma uruvana igia arafiriaken. ");
INSERT INTO nvm_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Rega e ar Kafoniamko iji jak jaka juf. Ijefuon maiji ja vierafero jaiji jan aresredo ja Godon ar ijia vakro ja iji vierafe gavo iji fu bakin. God ja fuka kam ar ise mian naino ijia kozekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesu ijeg kuardiame uri e vuak fuon faivo iji kia, Erar fu vuak jon faimo iji fu madu vuak nun iji fu ijek madu faim. Regavo erar fu ja uzamo iji fu madu na uzam vo madu fu e iji fu kiema na ruainva iji uzamno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Areme e seventi tu (72) iji bu usem vainva iji bun bomana oimarknum una useme izeg bu reoinva ijin Jesu kuardain. Bu useme kua, E Bomana kaven ise iji no if on ijia kiavga buka no iguome e adagin iji areme usem vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Bu ijeg kuardavga Jesu fu una kia, Iji jaka ma kuardiev. Na ire varur igi fu karamo ijeg na gak Setan fu kaf gufia arima nan gain. ");
INSERT INTO nvm_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Regavo igia faif. Jaiji nan daro miain. Ijefuon tavan iji ja oijo ijia tabar ga sugon ga ire ise kafo buba ja jakiak vo ise kafo buba jon rekfuon. Regavo madu Setan fu daro bado fuba ire ise kafo jon rekfuon. ");
INSERT INTO nvm_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Regavo jab kaven ise iji bu ja igiainva ijiebuon oimarvo. Rega nin oimaref ijefuon maiji Godri if jon fun buk fuon varur gufia namo ijia isoinmano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Areme tavan ijia Jesu fuka Godon Kaven ijar oimarmo iji abe fuon rokga fu uri kua, God Asoinun varur ga moik igefuon E Bomana. Na on oimarev ijefuon maiji a e igi ba ma vierafenva iji irerag a kege sauinma iji kege nijaiduogavo e ma vierafejo iji aka kege bu ni sauikuriain. Rega iji an on vierafenma ijia ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Regavo ar ire uruvana igi na samuagdiakfuon ijin vajien. Regavo an ar onkua na vierafe ga madu nan nar nunkua a vierafen. Revo madu e iji nar kenva iji nan koiknu a God izekin iji nan nijaidiainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Areme Jesu fun ijeg God sirimamene una dakaroim e vuak fuon faivo iji isuarigia kuardiame kia, Jaka ire iji ja giainva ijefuon oimaref. ");
INSERT INTO nvm_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Regavo vuak igi naka ma kuardiav. E iji amur Godon vuak vierafene kuaivo iji abevo e mamkanuk moik samuavo iji buka irerag ja giavo ijin giakuai vierafen gavo buba giain. Regavo madu bu vuak irerag ja faivo buka ijin faikuai vierafen gavo buba fain. Ijefuon maiji bun usuibe aoi barenvano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Tavan be e vuak akai nijaidiamon ijar Jesu biesuame kua, E Nijaidiamo na izegrekva na unam ma fivako iji abekno kuain? ");
INSERT INTO nvm_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Fu ijeg kuamga Jesu fu una roin kua, Regavo a buk akaij ijia vuak iji ma karivako ijefuon bu isoinva iji a izeg dame vierafenmano kuain? ");
INSERT INTO nvm_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jesu fu ijeg kuardamga e iji fu uri kua, Aka oion ga kaven on ga daro on ga vierafe on fok ijekma God E Bomana on iji oijmak. Regavo madu on izeg a oijmanamimo ijeg ni una kaifon ijin oijmiamne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Fu ijeg kuaimga Jesu fu kua, Ke iji aka ma kuaim. A ijegrekma a unam iji ma karivako iji abekno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Fu ijeg kuardamga e iji vuak akai nijaidiamon iji fu vierafega fu e uruvana oijmiamo bakin ijefuon fu uri Jesu kua, Revo kainun iji na era oijmakno kuain? ");
INSERT INTO nvm_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Fu ijeg kuardamga Jesu fu una vuak be ijeg bijame kuardain. Fu kua, E be fu ar Jerusarem ijia una Jeriko ari vakafa vakon ijia e niesavo ijieb useme fu bien. Bu bieme kunaim dab ugon fuon azome uri kanava fun guakrega bu ijia areme vain. ");
INSERT INTO nvm_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","32","Bu ijia areme vakoga E Jius buon isuf baroino be fu unam ijefuon vain. Fu vaga e iji fu ijia namga fu asime vakoga e Rivait be fuk rad jame vaga e iji bu kanainva iji fu ijia namga fuk keko game asim vain. ");
INSERT INTO nvm_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Bu ijegrene vakoga e Sameritenko be fu unam iji bu vainva ijefuon roke kekome e iji namo ijin gama fuka oifiain. ");
INSERT INTO nvm_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ijefuon fu va e iji namo ijia kekome muramura ijigam do vuain iji kege usemdavknum matan somdain. Fu somdame uri matan fuon iji ugon utifdame dabme maf-donki fuon azan ijia uname fun afeme va ar be e bu naoivo ijia keko uname ijia samua fin. ");
INSERT INTO nvm_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Areme afarma fun uri mon sunin kafo karame e iji ar samuamo iji vajain. Fu vajame kua, Ni amarigia e igi samuake na vainki una igefuon ruakva ni ire izeg a fuon akozenma iji kuardiega na una vef ijefuon vajavno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesu fu ijeg kuardame uri kua, A vierafega e nokbek (3) iji bu vainva ijia e izar fu e iji bu kanainva ijefuon kaino kuain? ");
INSERT INTO nvm_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Fu ijeg kuamga e iji vuak akai nijaidiamon iji fu kua, Na vierafe e iji fu ifejdainma ijar fu ma kaifuono kuain. Fu ijeg kuamga Jesu fu kua, Ijefuon ak nin va unam besum iji fu kenma ijeg kegoine kuain. ");
INSERT INTO nvm_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Areme Jesu fun e vuak fuon faivo ijiena Jerusarem vakuai roke mai be ijia usevga bara Mata fu Jesu oimardame afem ar fuon ijia vain. ");
INSERT INTO nvm_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Regavo bara Matan uviai Meri fu ro Jesu fu manine vuak nijaidiamon samaij ijia ari fine vuak fuon iji faim. ");
INSERT INTO nvm_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Regavo Mata fu ik uruvana fuonkua reno ijefuon fuka oifiain. Ijefuon fu ro Jesu kua, E Bomana naka nunkua ire uruvana rejno a nuifuon oifiadakma ni Meri kuaga fu ro na ifejdiemno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Fu ijeg kuamga E Bomana Jesu fu una roin Mata kua, Aiji a irerafuon ire uruvana rekafa bomana vierafeknum ziem? ");
INSERT INTO nvm_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Na vierafega ire besum fuka ma bomana. Regavo Meri fu ire iji fun gain ijefuon naba ire ma iji fu vierafeno iji abe vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Naki be Jesu fu ar be ijia fine sirimameno ijia e vuak fuon faimo be fu uri kua, E Bomana nin izeg Jon e do ruardiamo fu sirimamene e vuak fuon faivo iji nijaidiainma ijeg ak no nijaiduomne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Bu ijeg kuavga Jesu fu uri kia, Ja sirimamekva nin igeg sirimamef. God Asoinu no if on akaij iji abe ajieknum aroiv. Regavo tavan iji a una e uruvana igiebuon oij iji samuagdiakfuon iji nin migegare igia rene. ");
INSERT INTO nvm_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Rega tavan besubesum ijia nin duok no ikfuon iji vajuomne. ");
INSERT INTO nvm_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Regavo nin ise no reoijo iji guome are. Ijefuon maiji no eraneb bu nuvuon ise rejo iji non giame arev. Regavo ab no kege una unam gigikin ijia biesuk. ");
INSERT INTO nvm_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Jesu fu ijeg sirimame nijaidiame uri vuak be ijeg bijame e vuak fuon faivo iji kuardiain. Fu kia, Ja e igi ja karinva ijia e be a naki ve ufrenma ijia a kaion ijefuon ar ijia va kuak, Eko uviainu abe bred nokbek (3) ifejdiek? ");
INSERT INTO nvm_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Na kainun be fuka iviakma ruain gavo naka irerag abe makva bano kuak. Regavo kaion iji fu vek guf ijia moik naknum kuak, Kainu na ag bara nun ijiena noka ninaoido noba uri duok kafo ifejdakno kuakfuon. ");
INSERT INTO nvm_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Regavo fu kaion igeg fuba migegare uri ke vajakfuon. Regavo aka vek tavan jaoikin manine kanakanamo ijefuon fu irerag a vierafenma iji ke vajak. Ijefuon maiji aba juknum manine kuardain gavo aka zinunba manine kuardain. ");
INSERT INTO nvm_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ijefuon na kuardiako faif. Jon ja sirimamejo iji ja tavan uruvana giriesame kukma kuakva fu kege vajiak. Regavo madu uri tavan bog nisaikva ja gak. Regavo kanakanakva vien fu joifuon dajak. ");
INSERT INTO nvm_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ijefuon e uruvana eraneb fu kuakva bu karekfuon ga nisaikva bu giakfuon. Regavo madu bu kanakanakva vien iji fu buifuo dajadiak. ");
INSERT INTO nvm_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Regavo madu igia faif. E be erar a farifon fu kijum ikafa kuakma abe uri tabar abe mak? ");
INSERT INTO nvm_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Regavo fu madu uri kukoro fuo fu kuakma abe uri sugon abe mak? ");
INSERT INTO nvm_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Rega madu igia faif. Jaiji jam ise reoijo revo jaka uri ire ma ijesugin afjon vajiaken. Regavo Asoijon varur gufia fino iji fu e uruvana ja fuka ma bomana oijmiamo. Ijefuon fur Kaven Akai fuon iji kege eraneb bu fu kuavo iji vajiakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Areme tavan ijia Jesu fu e be kaven ise ijar dab ninaruko fu vuak ba kuaimon fu ijia fina fu gain. Fu game uri kaven ise iji kuriaireme kuama fu kekome vakga e iji fu ijia anerene una vuak kuain. Fu vuak kuaimga e uruvana buka oij iseradiain. ");
INSERT INTO nvm_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Rega e roin bu kuai, Fu e Birzibab e iji kaven ise samuagdiamo ijar daro mainma ijefuon fu iji kiaga bu usem vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Regavo e roin bu Jesu biesuakuai uri kua, Ni ire sumakin be rega no ijia Godon daro iji game ma vierafejno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Bu ijeg kuardavga Jesu fu izeg bu vierafenva iji fun giame uri vuak be bijame ijeg kuardiain. Fu kia, Moik be e bu afuime besum karijo iji bu ata roinroin rene bui bijaikva bu koikbuon ar buon iji bun dab iserek. Regavo madu e agan be bu ata roinroin rene una bui bijaikva bu if buon iji bun koikbuon kam iserek. ");
INSERT INTO nvm_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ijefuon Setanon ar ijia efuon buk bu ijeg dab ata roinroin rene una bui bijaikva bu izeg jaoijor karivak? Rega madu ja kuai kaven ise iji na kaven ise Birzibab daro miega na kiaga bu usem vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","20","Regavo na ijeg Birzibabon daro ijia kaven ise iji kiaga bu usem vagiakva ejon bu erafon daro ijia kaven ise iji kiaga bu usem vak? Ni ejon iji kiaga na erafon daro ijia kaven ise iji kiaga bu usem vako iji kuardiaga ja faif. Regavo gaga na Godon daro ijia kaven ise iji kiaga bu usem vagiakva ni vierafe tavan iji God fu una efuon ijiebuon oij iji samuagdiakfuon iji fun ruain. ");
INSERT INTO nvm_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Regavo madu igia faif. E darokin be fu ire bijaivo iji kanafume ar fuon iji samuame fikma ire fuon uruvana bu mukorigia naoik. ");
INSERT INTO nvm_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Regavo e ka ma darokin ijar kekome e darokin iji ire uruvana kanafu samuagdiamo iji kunaime juaf ga kaki fuon kamazak. Fu kamazame ar fuon ijia aru ire fuon fu amur kanafu name ijia bidua fino iji kareme kaifijaf ata vajiain. ");
INSERT INTO nvm_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ijefuon ebe erar fuba nosik renman iji na vierafe e iji bu e ani nun. Regavo erar fuba na ifejdieme e aferdiamo e iji fuka e igi kam atasega bu na nuigafieme atase vakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ijegreare Jesu fu uri kia, Kaven ise be fu e be dab niroimoine are kekome ai moikum namo ijia oknum ar fu fikfuon iji nisaimok. Fu nisaimoga bakma fu una kuaik, Nan ka una ar nun na amur fine ruainva ijia vakno kuaik. ");
INSERT INTO nvm_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Fu ijeg vierafene una vaga ar fuon fu fino iji bun amarme fuka mukor. ");
INSERT INTO nvm_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ijefuon fun una va madu kaven seven (7) ka ma ise iji aferdiame una ro ar fu amur finma ijia buna fik. Ijefuon e iji fu amur fu sibank fiogavo rad fuka una unam ma ise ijia fikno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","28","Jesu fu vuak iji kuardiame barekoga bara be fu e uruvana ijiebuon uf ijia uri kume, Na vierafe God fuka bara iji fu a nafene samuagdainma iji fuka bomana oimarkno kumen. Fu ijeg kumega Jesu fu una roin kua, Ijeg ga madu na vierafe God fu e iji bu vuak fuon iji faime igavo iji buk buka oimarkno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","30","Jesu fu ijeg kuardiamga e uruvana bun uri Jesu dab kirakuravga fu uri kia, E igi iviakma karinva iji bu unam ise kafokafo bu reoijo iji buka ba aren. Regavo bu vierafe naka ire sumakin kafo rega bu giakuai bu iji vierafen. Regavo ire sumakin iji na nijaidiakfuon iji nam ire iji Jona fu renma ijesugin nijaidiak. Jona e Godon vuak vierafene kuaimon e Ninevako iji anf be rene nijaidiain. Regavo iviakma Ema ijiebuon Farif igi nak na e igi iviakma karijo iji unam sumakin be rega bu gak. ");
INSERT INTO nvm_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","Regavo tavan radkma iji God fu una e uruvana ijiebuon ise iji ke mazim giak rokon ijia na vierafe bara bomana be ar Siba samuamo iji fuka ja imut bijiame vuak ise joisina kuaik. Ijefuon maiji moik fuon iji fuka aibe gavo fuka uri una e Soromonon vuak maiji fu kuaimon iji faikafa vain. Regavo vuak igi naka ma kuardiavo igia faif. E Soromonon vuak iji fuim ukakbe gavo ire igi na iviakma keoijo ijar fuka ma ikin. Regavo madu tavan radkma ijia e Ninevako iji buka uri ise jon ja rejo ijefuon ja imut bijiame joisina kuaik. Ijefuon maiji e Jona fum ema revo buka vuak fuon faime una fu igame ise buon nuigafiain. Ijegvo iviakma vuak irerag igi na kuardiavo ijar fuka ma bomana gavo e Jonan vuak iji fuim ukakbeno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesu fu ijeg kuardiame kia, E be fu erar ikuosaij saname abe sauikma bakin revo fuka abe samakaf ijia abedega e bu ruakva bu ijia gaknum aru ruakfuon. ");
INSERT INTO nvm_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ijegvo madu ni jon fu vajai jon ijefuon ikuosaij ijin. Ijefuon ni jon fu mukor abarekma vajai jon fuka amarigia sanak. Regavo ja ni jon fu tavan uruvana ire ise iji giaokva vajai jon fuka ise ijar rareme nakik. ");
INSERT INTO nvm_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ijefuon nika amarigia agordiaikin vajai jon fu sanainma ijar rarekevo nakinman iji fu areken. ");
INSERT INTO nvm_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","A ijegrekma a ikuosaij iji fu sanamon ijeg vajat on iji fuka tavan uruvana sanaga nakinman iji fuka barekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","38","Jesu fu vuak ijeg kuardiame barko e Ferisis be fu Jesu kuama fu fusik duok ikafa vain. Fun va ari fine duok ikreno ijia e Ferisis iji fu Jesu fuba imut do soin ga fum duok ikreno iji gama fuka oij iseren. ");
INSERT INTO nvm_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ijefuon E Bomana Jesu fu uri e iji kua, Iviakma igi e Ferisis iji janim vajai surif jon ijesugin do ruardiaf. Regavo oijon guf ijia jaka e kaniaknu ire ise reokuai vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","E guri ka isema vierafejo gurie. Jaiji fun Godri vajai surif jon iji amarme madu ijar vajai jon guf iji fuk amardiain. Ijefuon ni vajai surif jon ja kege samuavo ijeg oijon guf iji kege ijeg amarigia samuaf. ");
INSERT INTO nvm_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Regavo vajai surif jon iji ja kege uruvana vierafejo iji arekgavo nika uri oijon ma ijekma kaifjon oijmiame ifejdiaga fuka mardiaf. ");
INSERT INTO nvm_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","E Ferisis gurie jaka juf! Ijefuon maiji jaka duok ukakna kafo ja juar jon ijia masivo iji roin jaka kege una God vajavo iji fun maren. Regavo ja una e isema karioijo iji ja ifejdiaknumvo God jaka oijmavo bakin. Ire nokarok (2) ijieb bun Godon nifak ijia buka mamkanuk ijefuon ja ire ijieb kegokfuon. ");
INSERT INTO nvm_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","44","Regavo madu e Ferisis jaiji jaka juf! Ijefuon maiji ja ar e Jius bu afuime vuak kuaivo ijia jaka jar fata mukor ijin oijmiame ijia karij. Rega madu ja vierafe e buka ar iji bu ijia afuime ire kimejo ijia ja amarigia agordiavknum anadiakuai ja iji vierafen. Regavo madu jaiji jaka e iji bu aoivga bu kege mako rume ijia areko tarar ijieb okuriainva e bu ijia datuamoijo ijekin. E bu unam ijia ja biediavo iji bu vierafero ja e maro bu ijeg vierafej. Regavo oijon guf iji buka ma aoinva igekino kiain. ");
INSERT INTO nvm_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jesu fu ijeg kuardiamga e vuak akai nijaidiamon be fu uri kua, E nijaidiamon a vuak ijeg kuaimon iji aka uruvana igia vuak ise nuvuisina kuaimno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Fu ijeg kuamga Jesu fu una roin kua, Ja e vuak akai nijaidiavo iji jak jaka juf! Ijefuon maiji Mosis akai fu isoinma iji fuim sibank e bu igiakfuon ijin isoin. Regavo jar una madu akai kafo nainva ijefuon e bu akai uruvana igiakrega fuka ba aresren. Ja ijegreknum jaka e ijin afikin kam vajiak revo ja koikjo kafo imut miame ifejdiavo bakin. ");
INSERT INTO nvm_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Ijefuon nika juf! Ijefuon maiji ja e Godon vuak vierafene kuaivo bu kania mako ruinva iji jaka kam ar sakuriame amariav. Ijefuon na vierafe irerag saifon bu renva ja besum ijeg rej. ");
INSERT INTO nvm_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ja ijegrejo ijefuon God fuon izeg fu mukoi vierafeno ijia fu usuibe ijeg kuai, E vuak nun vierafene kuaivo iji abevo e vuak abe oijo na e iji kege uniaga bu vuak. Bu vuaga e kafo bu kaniaga kafo bu kam arafiriakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Bu moikigi ik amarenva ijia bu anerene e Ebor kaname uri e Godon vuak vierafene kuaivo uruvana kaniain. Bu ijeg kania roke radkma iji bu Godon ar guf fata iji bu isuf baroijo samaij ijia bun e Zekaraia kanain. Bur ijegrenva ijefuon God fu una e igi iviakma karinva iji fuka kam mukorigia arafiriakfuon. ");
INSERT INTO nvm_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Regavo e Ferisis guri vuak akai nijaidiavo iji jaka madu juf. Ijefuon maiji ja vuak ma iji e roin kuardiame nijaidiavo bakin gavo jaka kam sauiv. Regavo madu jak ja vuak iji ja mukoi faime abejo bakin gavo madu ja e iji bu ma vierafekfuon iji jaka jar bijukuriav. Jaiji ja ki iji bu kege ar vien azovo igekin ijefuon jar vien buon azomiakfuon revo ja vien buon jaka azomiavo bano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Jesu fu ijeg kuardiame fun vakrega e vuak akai nijaidiavo ijigam e Ferisis roin bu uri vuak ka ise fuisina kuaiknum ire uruvana ijefuon duna kafokafo kuardain. Bu ijeg biesua arega fu vuak kafo isema kuaiga bu gakuai bu iji ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ijegrene buka e uruvana ijia afuivo ijefuon buka bui ajifnamuiv. Bu ijegrejo ijia Jesu fu amur uri e vuak fuon faivo iji kia, E Ferisis ijiebuon unam ka kufui iji bu e biesiaoijo iji amarigia giame datomdiagavo jab buonak kegok. ");
INSERT INTO nvm_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Irerag uruvana ja nuriet sauime kegoijo iji bu tavan iji E Bomana fu una fine e uruvana ijiebuon ise iji giamo ijia buka una samafrek. ");
INSERT INTO nvm_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ijefuon maiji vuak irerag ja tavan nakinma ijia kuainva iji bu dab maza ijia kuaik. Regavo irerag uruvana ja isuar adatit kuaimoinva iji bu dab uruvana igia kuaik. ");
INSERT INTO nvm_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Regavo kaifnun na kuardiakrejo faif. Jab uri e iji bu vajai surif ijesugin kaniagavo rad buba una ire ma ise kafo rekfuon ijin juk. ");
INSERT INTO nvm_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Regavo e iji ja jukfuon iji nika God juf. Ijefuon maiji ja aoikva God fu daro namdo fur ja kege mian iji ijia naine vakon ijia korek. Ijefuon nika fu juf. ");
INSERT INTO nvm_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ijegvo ja vierafega um ukaknak imut roin (5) ijekin iji buba kege mon abekgavo nokarok (2) kimek? Unam besum ijegvo God fu um iji ukaknak iji fuka rumo bakin. ");
INSERT INTO nvm_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Regavo madu nigen jau jon uruvana God fun dain ijefuon jab juk jar jaka ma ikin ga um iji buim ukakna. ");
INSERT INTO nvm_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","9","Regavo igia faif. E be erar fu e uruvana ijiebuon nifak ijia manine kuaik fuiji fu e nuno kuainma iji Ema ijiebuon Farif igi nasik Godon anera ijiebuon nifak ijia fu abe aroiken. Regavo erar e uruvana ijiebuon nifak ijia kuaik fu naba vierafenmano kuaikma iji Ema ijiebuon Farif igi nasik Godon anera ijiebuon nifak ijia kua a naba vierafenvano kuak. ");
INSERT INTO nvm_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Regavo madu e be erar fu Ema ijiebuon Farif igi vuak ise nuisina kuaimon iji na game arek rega erar fu vuak ise kafo una Kaven Akai iji fuisina kuaimon iji God fuba game arek. ");
INSERT INTO nvm_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","Regavo madu igi faif. E bu ja aferdia kam ar e Jius bu afuime vuak kuaivo ijia vo ba e mamkanuk roin ijiebuon nifak ijia vo ba e akai samuavo ijiebuon nifak ijia kotrekuai vaga jab oifiadiak. Ja vuak izeg ga vuak irerag ja kuardiakva ijin jab uruvana vierafek. Ijefuon maiji Godon Kaven ijar tavan ijia vuak irerag ja kuaikfuon iji fur vierafe vajiaga ja kuardiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","14","Jesu fu ijeg kuardiamga e be fu e uruvana afuinva ijia uri kume, E nijaidiamon uviainun iji fun asoinuvuon ijefuon ire uruvana fun fur raren ijefuon ni kua fu roin atame na kiemne kumen. Fu ijeg kumega Jesu fu uri una e iji kua, E gare naiji na erar daro mienmado na uviaion kuaga fu ire uruvana kege una osik ata vajuonamikno kuain? ");
INSERT INTO nvm_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Fu ijeg kuardiame uri e uruvana kuardiame kia, E guri ja ire uruvana kafokafo ja jonkua rareme karevo iji nika joi samuanamiknum of. Ijefuon maiji e ma bu oimarknum kareoijo iji bu sinuom buon ma iji bu zaraivo ijar ifejdiaga bu oimarknum karijo bakin. Ijefuon fu ire uruvana zarainma iji jab vierafejno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","17","Ijegreare Jesu fun madu uri vuak be ijeg bijame kuardiain. Fu kia, E sinuom ga ire uruvana zarainma iji fu moik ire mukoi tavuavo be abene fun ijia fin. Fu fine fuon ijeg vierafero na ar nun na uij nakfuon iji bado nakafu izegarekno kuain? ");
INSERT INTO nvm_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Fu ijeg vierafene uri kua, Na vierafe na ar nun na uij navo iji bujame una mamkanuk same kumun uij nun uruvana ijia nak. ");
INSERT INTO nvm_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Areme rad nan oimarme nui kuai na vierafe naka aresredo naba uri ire kafofuon rek. Regavo juaivasia uruvana naba una ikregavo nam ire ijin iknum ijia fivakno kuaik. ");
INSERT INTO nvm_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Regavo God fu uri e iji kuak, E buzeikin gare ivia naki a guake ire on fok a kanafuinma iji erar karekno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Areme Jesu fu uri vuak fuon kuaime barekafa kia, Unam besum ijeg e buka sinuom zaraime karik revo buba God ma vierafekva e ijekin iji bu Godon nifak ijia buka e sinuom bakin igekino kiain. ");
INSERT INTO nvm_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Areme Jesu fu uri e vuak fuon faivo iji kuardiame kia, Na ijefuon na ijin kuardiame kia, Jab ire iji ja ine karivako iji vierafek gavo uri vajai surif jon igefuon sinuom iji uruvana vierafef. ");
INSERT INTO nvm_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","On a fivakfuon iji fuka ma bomana gavo ire iji fuim ukakbe. Regavo madu vajat on fuka ma bomana gavo sinuom iji fuim ukakbeno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ijegvo ni madu um iji giaf. Buiji bu uij oijga afurvejo bakin. Rega madu bu ar bu ijia ire afurvene nakfuon iji bu bakin gavo fun Godri samuagdiame ire vajiamon. Regavo jaiji ja um ijekin bakin ga jaiji ja Godon nifak ijia jaka e ikin. ");
INSERT INTO nvm_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Regavo ja ire iji bomana vierafekva iji fu erar aresrenma bado fuba fuon fu fivako iji abe biom jaoijmana abedeme fivakma bakin. ");
INSERT INTO nvm_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ja ire ukaknak iji jaba mukoi vierafekva iji ja izeg una ire mamkanuk roin giame mukoi vierafek? ");
INSERT INTO nvm_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Regavo ni madu sinar taraiko iji bu tavuame iravo iji giaf buiji bu koikbuon ugon bu savo iji amardiavo ga kimejo bakin. Regavo madu e Soromon fuka sinuom uruvana zarain revo ugon fu samo iji fuka ma mukor. Regavo bun sinar ijieb buon izeg ni mukor bu iravo ijia buka Soromonon ugon iji amarigia asidiame irav. ");
INSERT INTO nvm_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Regavo ni madu una garas bu ivia irenva a giainma ga niar a una vaga fun sairenma iji God fu vek garas iji samuagdiam. Regavo e iji jaiji ja sinar ijekin baki ijefuon God ja fuka tavan uruvana samuagdiame ifejdiam. Ijefuon efnun ja irerafuon jon ma vierafejo iji fuka vek ukaknak? ");
INSERT INTO nvm_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","30","Ijefuon jab oifian abeknum ga jab tavan bog do ga duok ja ikfuon ijefuon karine vierafek. Regavo unam ijegrejo iji bu e iji God ma vierafejo bakin ijieb ijeg rej. Regavo iji ja ire kafokafo vierafejo iji Asoijon varur gufia fino iji fun giame vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ijefuon ja ire kafokafo ja vierafejo iji aregavo ijeg ja ar fuon sanaima iji vierafene fuifuo ik reokva fur irerag ja vierafenva iji fur ifejdiaken. ");
INSERT INTO nvm_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jesu fu ijeg kuardiame kia, E sibank igi vuak nun faivo iji jab juk. Ijefuon maiji Asoijon iji fun izeg jon ja vierafejo iji fun giainmado fur ja kege una e iji fu oijbuon iji samuagdiamo ijia uniak. ");
INSERT INTO nvm_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ijefuon ni va ire jon uruvana ka kege kime mon abe una e sinuom bakin iji vajiaf. Regavo koikjo uri giriesame kaven jon ijiebuon kanafuf. Regavo jab uri sinuom jon ijiebuon bomana vierafegavo nika uri varur gufefuon ire ma iji bu bakrekva bakin ijin kanafuf. Ijefuon maiji varur gufia ire jon ma iji e buba niesa ga fanufanuf buba arafiriak. ");
INSERT INTO nvm_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ijefuon maiji ire ma iji jon uruvana bu izia naoivo iji oijon ijiga vierafe jon buk ijia naoikfuon. ");
INSERT INTO nvm_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jesu fu ijeg kuardiame kia, Ire be fu rekrega ja samuavo ijeg nika ugon jon kege amarigia same ivia kiriame ikuosaij jon kege saname samua karif. ");
INSERT INTO nvm_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Jaka e ikrejo bu ebuon bomana fu iro bu sanamikuai ijo fu ijia vakafa kiame vako bu samua karijo ijeg ref. Bu samuame karikin fu una ro fai bu migegare vien dajakfuon ijeg jaka samuaf. ");
INSERT INTO nvm_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Regavo e iji eraneb bu e bomana buon iji fu una roga bu vek samuame karinva fu giakfuon iji buka oimarkfuon. Areme fu uri kiama bu ari karikoga fu kia jaiji jaka ma vierafene karido ja ar nun igia duok uruvana jam kareme ikno kiak. ");
INSERT INTO nvm_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Jesu fu ijeg kuardiame kia, Na ve ufrenma ijia ga suok nakitu gamia na roga ja vek ijeg samua karikva naka jon bomana oimarek. ");
INSERT INTO nvm_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","40","Regavo madu ni vierafef. E niesamo be fu niesak roga e ar koikin fuba ninain ga fu gazregakma iji e niekin fu izeg arume niesakma bakin. Ijegvo jak jaka ijeg samua karif. Ijefuon maiji Ema ijiebuon Farif iji na tavan iji jaba vierafenva ijia na una ruakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Areme Fita fu uri Jesu kua, E Bomana duna iji a no faikfuon iji kuarduo ki a e uruvana ijiebuon kuarduomno kuain? ");
INSERT INTO nvm_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","43","Fu ijeg kuardamga Jesu fu una roin kua, E iji erar fu ma vierafene amarigia ikreno e ijar ire uruvana samuagdiakfuon. E bomana fuon fu e iji kuamga fu e iji funa ikrejo ijin tavan ma ijia ire vajiaken. Fu ijegreno ijia e bomana fuon fu una ar fuon rokon ijia fu iji gakma fuka fuon oimarkno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Jesu fu ijeg kuardiame uri kia, Vuak igi naka ma kuardiav. E bomana fuon iji fu uri e iji kuamga fur una ire fuon uruvana samuagdiak. ");
INSERT INTO nvm_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Regavo e ikreno iji fu kuaik e bomana fuba migegare una roga fuka saroimno kuame fu uri e funa ikrejo barga baru ijin fijiaknum do kugi ine nigen iserme duok uruvana i bareknum ijeg reken. ");
INSERT INTO nvm_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Areme e bomana iji fu una ar fuon ijia ire fuon uruvana ga efuon ikrejo iji giakafa ruak. Regavo fu rokon iji efuon ikreno fuba vierafen. Fuba vierafenma ijia fu ijia kekome ga fuba ire fuon uruvana mukoi samuagdiaga fu kuriaireme rotkuraga fu kekome e iji buba fu igiavo ijiena besum karine vajai fian abekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Areme Jesu fu madu uri kia, E ikreno erar fun ik irerag fu e Bomana ijefuon rejdakfuon iji fun vierafen. Regavo fuba koikfuon amur kanafume uri ik fuon iji redakma e iji fu e bomana ijar dab unam ise ijia vajai fian mak. ");
INSERT INTO nvm_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Regavo e ikreno erar fu efuon bomana ijefuon ik iji fu rekfuon iji fuba mukoi vierafen gavo fuim oijfuon ijia vierafero fu rad vajai fian abekro fu uri ik reoino iji rad e bomana fuon fuim ukakbe vajai fian mak. Ijeg ga God fu e iji fu ik sibank mamkanuk vajiaga bu reoijo iji fu vierafe bu giriesame sibank amarigia reoga fu una giakafa vierafen. Regavo eraneb fu ik ka mamkanuk vajiainma bu reoijo iji fu vierafe buka giriesame amarigia reoga fu una giakafa fu ijeg vierafenmano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesu fu ijeg kuardiame madu uri kia, Na ruainva na e uruvana moikigia oinva ijiebuon oij ijin kam arafiriakro ruain. Regavo na bomana vierafe ire iji fuka migegare barekfuon. ");
INSERT INTO nvm_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Regavo madu na ruainva iji na izeg vajai fian abekfuon ijefuon daro iji abedo na vajai fian abe vake barek. ");
INSERT INTO nvm_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Regavo ni vierafe na makarijo iji abe e moik iror igia karioinva iji miakro ruainva bakin. Regavo na ruainva iji na e fok ke atame kafokafo rekro ruain. ");
INSERT INTO nvm_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","53","Ijegvo iviakma e agan imut roin (5) iji bu dab ata nokarok (2) bu roin reke nokbek (3) bu roin rek. Rega madu ar be ijia asoifijaf iji bu uri afijaf ijiena dab atame roinroin reke gavo asiefijaf iji buk bu uri kabaifijaf ijiena unam besum ijeg rek. Regavo madu afijaf ijiebuon barafijaf iji buk bu barufijaf ijiebuon asiefijaf ijiena ata roinroin rene zinamikno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","55","Jesu fu ijeg kuardiame uri e Jius iji kia, Ja oine vana iji bu kaziga ja kuai fu vedakro kuaiko fu vedam. Regavo madu buibur fu bomana ufimon ja kuai fu tavai markreno kuaiko fu tavan marmon. ");
INSERT INTO nvm_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ijefuon e guri ka isema rejo gurie ja moik ga varur ijia irerag rekreno iji jan giame vierafej gavo ja irerafuon ire igi na kegoijo iji jaba amarigia gieme vierafej? ");
INSERT INTO nvm_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ja irerafuon ise jon ja reoijo iji jaba koikjo amarigia giame una ire ma ijesugin reoij. ");
INSERT INTO nvm_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","59","Regavo igia faif. A ebe fu a aferda kot rekafa vakma iji nika vek a unam ijia vako ijia vuak on fusik kuaime amare. Regavo aba ijegrekma fu a dab dakarame e bomana kot faimo ijia vakma fur a abe una foris miak. Fu a abe foris miaga bur aferda dab dibur abesek. Regavo igia faif. Bu aferda ijia unaga a ijia fine mon izeg bu kuainva a ijin kime vake barme una kekokno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jesu fu vuak ijeg kuardiame barekoga e iji bu ireme gakoga Fairet fu e Gareriko Godon isuf baroijo iji kaniainma ijieb uri vuak ijin Jesu kuardain. ");
INSERT INTO nvm_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Bu kuardavga fu una roin kia, Bu e ijin kam ijeg kaniainva ijefuon ja vierafega bur ma ise uruvana ren gavo e Gareriko roin bu bakin? ");
INSERT INTO nvm_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Regavo igia faif. Iji fuka ma bakin. Regavo ja unam ise jon uruvana ja kegoijo iji jaba arega una oij karoigakva e uruvana jak jaka bu aoinva ijeg aoikfuon. ");
INSERT INTO nvm_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Regavo madu e eitin (18) iji bu ar Sairom ijia ar iji bu tor ijia maduame sainva ijar tuame okuriama bu aoinva iji ja izeg vierafen? ");
INSERT INTO nvm_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ja vierafega bur ise ka uruvana rekovo e uruvana Jerusarem guf ijia karinva iji bu bakin? Regavo madu igia faif. Iji fuka ma bakin. Regavo jak jaba unam ise jon ja reoijo iji jaba areme una oij karoigakva ja bu renva ijeg jaka aoikno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Areme Jesu vuak be ijeg bijame kuardiain. Fu kia, E be fu in be jafene ar fuon aror ijia oin. Areme fu va in iji fu oinma iji gaga fu sunin kiraga fu turakafa ga unaim. ");
INSERT INTO nvm_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Regavo in iji fuba sunin kiramga fu una e juar fuon samuamo iji kua, Na juaivasia nokbek (3) na in igi ga unaim revo fuba sunin kiram. Ijefuon ni ufu dab akoze. In iji fum ijia manine moik roin fur raremno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","9","Fu ijeg kuamga e iji juar samuamo iji fu una kua, E Bomana ni juaivasia besum (1) igesugin are fu ijia manin. Fu manike na ase amareknum sakin akozaga ni juaivasia be ijia una gaga fu sunin kirakma iji fun marek revo bakikma nin ufume akozemne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Areme tavan Sabat (Satade) be e Jius bu isuar karine God sirimamejo ijia Jesu fu e Jiusbuon ar bu afuime vuak kuaivo ijia arume vuak nijaidiam. ");
INSERT INTO nvm_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Regavo bara nivek be fu kaven ise ijar niroinma fu ijia fin. Bara iji fu juaivasia eitin (18) ijeg fu adam iji abene nuon fuon dab giemoine fun arir oinon bakin. ");
INSERT INTO nvm_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","13","Ijefuon Jesu fu tavan ijia bara nivek iji game uri kua, Bara game adam on a abenma fun ivia barenmano kuain. Areme fun imut nigen abedemga migegare nuon fuon fu una arir rega fu una Godon oimaren. ");
INSERT INTO nvm_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Rega e bomana ar iji bu afuime vuak kuaivo iji samuamo iji fu Jesur tavan Sabat (Satade) iji e Jius bu isuar karine God sirimamejo ijia bara iji keunamga fuka deajin. Ijefuon fu uri e iji kia, Tavan siks (6) iji no ikreoijo ijefuon ja tavan ijia roga fu karauniaf. Revo jab tavan Sabat (Satade) iji no isuar karine God sirimamejo ijia ruakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","16","Fu ijeg kuardiamga Jesu fu una roin kuardame kua, E i kufuikin gare vuak iji a kuaimon iji ja ijeg reoijo bakin. E roin jaka tavan Sabat (Satade) iji ja isuar karijo ijia ja maf-os ga maf-donki jon ja kiriainva iji irame aferdiame va do vajiaga bu ij. Ijefuon nak na tavan igi ja isuar karijo ijia na bara igi keunava iji fun maren. Ijefuon maiji bara ijar fuka ma ikin ga fanuf iji bu ikin bakin. Ijeg barak igi e Eburamon uifarif iji fu Setanri juaivasia eitin (18) ijeg adam fuon fu abenma iji abe anu kunain. Ijefuon na tavan Sabat (Satade) iji ja isuar karine God sirimamejo ijia keunainva iji ja vierafega na isema ren? ");
INSERT INTO nvm_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesu vuak ijeg fu kuainma ijar e ani fuon bu faiva buka jufdiain gavo e uruvana roin bu ire sumakin iji fu renma ijefuon fuon oimardain. ");
INSERT INTO nvm_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","19","Areme Jesu fu uri kia, Na unam ijeg God fu efuon ijiebuon oij iji fu samuagdiamo na iji kuardiakrejo nin faivno kiain. Areme fu kia, God efuon ijiebuon oij iji fu samuagdiamo iji fu e be juar mene uij ukak be in sira sunin ijekin abe oina fu bomanarenma ijekin. Fu in iji abe oga fu tavuame ka bomana rena um bu ro in kiak ijia naitabenvano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Jesu fu ijeg kuardiame una madu vuak be bijame kuardiain. Fu kia, God efuon ijiebuon oij fu samuagdiamo iji fu ire ist ijekin. Bara iji fu ire ist ukakbe abe dis ijia useme farava ijekma amarekma fuka ofre uri bomana rekfuon. Unam besum ijeg gavo iviakma Godon e iji bu e sibank ga rad buka ma e uruvana rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","23","Jesu fu ijeg kuardiame fun una Jerusarem vakafa uri mai ga ar ukaknak kafokafo ijia vaknum vuak iji God fu izeg efuon ijiebuon oij iji samuagdiamo ijefuon vuak iji nijaidiaknum vain. Fu ijegreoinon ijia ebe fu uri Jesu kua, A vierafe God fube e uruvana karauniak ki fu e sibank karauniakno kuain? ");
INSERT INTO nvm_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Fu ijeg kuamga Jesu fu una roin kua, A koikon giriesakma a vien ma kifit ijia aru vaken. Ijefuon maiji e ka uruvana bu ijia aru vakuai giriesak gavo bu izeg aru vakva bakin. ");
INSERT INTO nvm_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Regavo igia faif. E ar koikin fu uri vien fuon iji fu abe bijukurak. Areme a makaf ijia manine kanakanaknum kua, Eko vien dajamne kuakma fu una kua, A izia ruainma iji naba vierafenvano kuak. ");
INSERT INTO nvm_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","27","Areme a una roin dakaroim kua, No ana duok ga do ioko a mai nuvuon ijia vuak nijaiduinmano kuak. Ja ijeg kuakva fu una madu kia, E ise reoijo gurie gareg vaf. Na ja izia ruainva iji naba vierafenvano kiak. ");
INSERT INTO nvm_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Areme ja gia Eburam ga Aisik ga Jekaf ga e iji bu amur Godon vuak vierafene kuaimoinva iji bu Godon e ijiena besum afuime irenva ja giak. Ja gia fuka deajidiaga ja imut kam jakia isoiknum niraiken ijefuon maiji ja iji fun kam makaf kozen. ");
INSERT INTO nvm_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","30","Regavo tavan ijia e uruvana ar iror igia oinva bu ro Godon ar sanainma ijia karine iro ike ja giak. Regavo eraneb iviakma bu koikbuon kam amur vierafeoijo iji tavan rad buka una rad gamia ruak. Regavo eraneb bu koikbuon kam rad gamia navo iji tavan rad bu amur irekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Areme tavan besum e Ferisis roin bu useme Jesu kua, Nika ar igi a oinon iji areme uri ai be va ijefuon maiji Erod fu a kanakafa vierafenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Bu ijeg kuardavga Jesu fu una roin kia, Va e iji siroij taraiko igekin iji kua, Na ivia ga niar na igia fine kaven ise iji kia bu e iji areme usem vaknum e adam abejo iji amardiaken. Regavo nituag ijar na ik nun na reoijo iji re barekno kuafno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Fu ijeg kuardiame una e Ferisis iji kia, Nason Jerusarem vak. Ijefuon maiji e Godon vuak vierafene kuaimon iji bu ar be ijia kanakva bakin gavo bu Jerusarem ijia kanak. ");
INSERT INTO nvm_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jesu fu ijeg kuardiame kua, O Jerusarem Jerusarem ar eon ijiena e Godon vuak vierafene kuaivo iji kaniain. Regavo madu ar e iji vuak abe oijo iji God fu kiama bu ruainva iji mun tuame kaniain. Na tavan uruvana naka imut akozme ja aferdiame kukoro iji fu uka fuon aferdiame daf fuon rotit ijia uniamo ijeg rej revo jaka na uzain. ");
INSERT INTO nvm_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ijefuon jaiji God fu ar iji e kafo ijia karijo bakin ijeg fu ijia areme vak. Regavo igia faif. Ja na jaba una giek gavo va tavan abega na una roko ijia ja kuak Godri e iji rokon iji e bomana ijefuon if ijia daro mamne kuaikno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Areme tavan Sabat (Satade) iji e Jius bu isuar karijo ijia e Feresibuon e bomana fu Jesu kuama fu ar fuon ijia fusik duok ikafa vain. Fu vakga e uruvana ijia ruainva iji buka amarigia nikaja arega fu irerag rega bu gakuai. ");
INSERT INTO nvm_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","3","Regavo e be diak ga faraf foinma ijar Jesuon ruain. Fu rokga Jesu fu uri e vuak akai nijaidiavo iji abevo e Ferisis iji kuardiame kia, No tavan Sabat (Satade) akaij ijia e karauniakva fube markno kiain? ");
INSERT INTO nvm_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Jesu fu vuak ijeg kuardiamga buba uri vef roin kuardavga fu uri e iji keuname kuama fu vain. ");
INSERT INTO nvm_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ijegreare fu madu una kia, E be igia erar amfuon be ga maf-kau fuon be fu tavan Sabat (Satade) igi ja isuar karijo ijia mako iji bu do jiavo ijia urakva jabe arega bu ijia karik ki ja va bu ifejdiame karauniaga bu ajie vakno kiain? ");
INSERT INTO nvm_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jesu fu vuak ijeg kuardiamga buba una vuak ijefuon una roin kuardain. ");
INSERT INTO nvm_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesu fu izeg e kafo bu ar ma iji rarevo iji fun giain ijefuon fu vuak be igeg bijame e uruvana kuardiain. ");
INSERT INTO nvm_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","Fu kia, E be fu iro ine a kua a vakma ab migegare va ar ma ijia ari fik. Ijefuon maiji a va ari fike e ikin be fu rad roga aba gak. Fu rad ruakma e iji fu ja e nokarok (2) kiama ja vainva iji fu ro a kua, Ani uri moik ijia fike fu e igar ar ma ijia fine kuakma aka juvknum urik. ");
INSERT INTO nvm_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ijefuon a vakma ni moik ijia figa e iji fu kuama a vainma iji fu roga a e ikin bega fur kuaga a uri fata ma ijia fik. E iji fu a ijegrekma e uruvana ruainva iji bu ijia izeg e iji fu a oimardame renma iji gakfuon. ");
INSERT INTO nvm_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ijefuon maiji e besubesum erar fu koikfuon abe e bomana rekma fu una e ukakbe reken. Rega erar fu koikfuon abe e ukakbe rekma fu una e bomana rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Areme rad Jesu fu uri e iji fu kuama fu fusik duok ikafa vainma ijin kua, A tavan kafo e kiaga bu ana duok ikva ab kaion ga uviaion ga e ar ana karijo ga e ire uruvana zarainva iji kiaga bu ro ana duok ik. Ijefuon maiji bu rad duok on a vajiainma ijefuon kume a vakma bu una vef izeg a buon renma ijeg on rek. ");
INSERT INTO nvm_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ijefuon a iro vajiakma ni e iji ire bakin ijigam e ai kirariainva ijigam e diak ga imut foinva ijigam e ni zuriaigin ijia kiaga bu ro iro on sare. ");
INSERT INTO nvm_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Regavo a ijegreno iji anka oimarek. Ijefuon maiji buba una ire on vef roin vajakfuon. Rega aiji fu Godri tavan iji e maturainva iji aoinva bu una urijo ijia fur unam ma kafo on rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Regavo e be ijia buna fine duok ino iji fu vuak iji faime uri Jesu kua, E iji eraneb bu Godon ar sanainma ijia fata ma ijia karine duok ikfuon iji buka oimarkno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Fu ijeg kuardamga Jesu fu una vuak be ijeg bijame kuardain. Fu kua, E be fu iro ikafa ire uruvana kanafume e uruvana kiaga bu sarekfuon. ");
INSERT INTO nvm_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Areme tavan iji iro ikfuon iji roga fun efuon ikrejo iji kia, Ni va e na kiainva iji kia ire uruvana nan kanafu samuainvano nin kia bu rokno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Fu ijeg kuardiamga efuon ikrejo iji bun va e iji e bomana buon fu kiainma iji kiain. Rega e uruvana bu iro iji buba vakuai vierafen ijefuon bu uri vuak kafokafo bu vierafenva ijia kuardiain. E be fu uri kia, Na moik be kimedo na iji gak vak. Ijefuon ni va vuak nun ejon bomana iji ijeg kuardafno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Regavo e be fu uri kia, Naiji na maf-kau nun ten (10) kimedo na iji kege ar nun ijia mimatame giak vakno ni va e iji vuak ijeg kuafno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Rega e be fu madu uri kia, Naiji na iviakma bara aben ijefuon naba vuakno ni va e iji ijeg kuardafno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Bu ijeg kuardavga e iji e bomana ijefuon ikreno iji fun una va gafia kekome vuak ijin efuon bomana iji kuardain. Regavo e bomana ar iji samuamo iji fuka deajin. Ijefuon fun uri efuon ikreno iji kua, Migegareigia una kekome va mai unam ijia oknum e duok bakin ijigam e ai kirariainva ijigam e ni zuriaigin ga imut ga diak foinva iji aferdiame rokne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Areme rad efuon ikreno fun una kekome kua, E bomana vuak on nan abe kekome kuardiame vain revo ar kafar fu vekno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Fu ijeg kuardamga e bomana iji fu uri kua, Ni va ar kafokafo samaij ga unam ijia oknum e uruvana kiaga bu ruainki ar nun fu e uruvana zaraik. ");
INSERT INTO nvm_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Rega igia faif. E iji na kiava buba iro nun igi sarenva e iji bu duok nun igi buba ikno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Areme tavan be e uruvana bu Jesuna vako ijia fu dakaroime kia, E be erar fu asoifuon ga asiefuon ga barafuon ga afijaf ijin uruvana oijmiagavo na fum sibank oijmiemo e iji fuba aresredo fu izeg kua na Jesuon agano kuaik. Regavo madu e be erar fu uviaifijaf ga makifijaf uruvana oijmiame una fui uruvana oijmana migavo na fun sibank oijmiemo e iji fuba aresredo fu e vuak nun faimon rekfuon. ");
INSERT INTO nvm_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Regavo madu erar fuba nuifuon vajai fian abe guame rad jajimo e iji fuba e vuak nun faimo reken. ");
INSERT INTO nvm_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","29","Ijegvo igia faif. A e be ar sakafa vierafekma e iji amur fuka va fine mon iji fu ar sakfuon iji vierafeknum kanafu vake fun aresrekma fu vierafero ar iji fu same barekro fun ijeg vierafek. Regavo fuba ar ijefuon ire uruvana kanafukma iji fuba same barek. Ijefuon e bu usem gakva buka dab varaimene kijdakfuon. ");
INSERT INTO nvm_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Bu dab varaimene kuaik, E iji ar iji fu anerene sain gavo fuba same barenmano kuaik. ");
INSERT INTO nvm_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Unam besum ijeg ga e bomana be fu e sibank ten taosen (10,000) ijeg aferdiame una e bomana be fu efuon ka uruvana tuenti taosen (20,000) ijeg aferdiainma ijek bijaikafa rokon iji fu isuar fine vierafekfuon. Fu fine vierafega fun aresredo fu e fuon ijiena va e bomana be ijek bijaikafa fu ijin vierafekfuon. ");
INSERT INTO nvm_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Fu fine vierafega fuba aresrekma fu e vuak abe oijo iji kiaga bur va e bomana be ijin vek gafi fu aibe ijia rokon ijia bieme una vuak oimarme kafaikfuon iji kuardakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jesu fu ijeg kuardiame kia, Unam besum ijeg ga e be fu erar e vuak nun faimo rekafa vierafekma ni amarigia fine vierafekfuon. Fu vierafega fun aresrekma fu ire uruvana ga unam ise kafokafo iji nuigafiame una e vuak nun faimon rekfuon. ");
INSERT INTO nvm_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","Regavo madu igia faif. Kujan iji fu ma gavo fu ve da arume safikirakma marien fuon fuba una kujan igeg rek. Ijefuon kujan ijekin iji fu ma bado bu kege korekfuon. Unam besum ijegvo ja na jajivo ijia ja isediaga ja ijia arekva iji ikjon iji ja nuifuon rejo iji fu barek. Ijefuon ja adakiga ni vuak igi amarigia faifno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ijegreare tavan be e takes abeoijor ijigam e ise uruvana bu Jesu vuak fu kuaimon iji faikuai ruain. ");
INSERT INTO nvm_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Regavo e Ferisis ijiga e vuak akai nijaidiavo iji bu uri ijefuon dab bui kuaime sigunamin. Bu kuai, E iji fu e ise iji oimardiame aferdiaknum buna duok ioinon kuain. ");
INSERT INTO nvm_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Bu ijeg kuaivga Jesu fu ijefuon una vuak be bijame kuardiain. ");
INSERT INTO nvm_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Fu kia, Ja e be erar fu maf-sif vuan adred (100) samuagdiamo ijia be fu sauikma fu izeg rek? Na vierafega fuka urine maf-sif nainti nain (99) iji fu ijia uniaga fuka kekome va be iji sauinma iji nisaimok. ");
INSERT INTO nvm_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Fu nisaimoine gakma fuka oimarme dabeme una ar ruak. Areme fu una kaifijaf ga e ar funa karijo iji kume bu besum afuiga fu uri kiak, Na maf sif nun sauinma iji nan una bien. Ijefuon naka oimadienmano ni roga no besum maf-sif igi sauinma iji fuon oimarkno kiak. ");
INSERT INTO nvm_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ijegvo igia faif. E uruvana bun unam ma ijesugin kegoijo ijefuon God fu buon oimarem. Regavo e besum fu ise rene oi dakaroime una Godon roko e uruvana varur gufia karijo iji buka fuon ma bomana oimarevno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesu fu ijeg kuardiame madu una vuak be bijame ijeg kuardiain. Fu kia, Bara be fu mon sunin imut roinroin (10) ijin nain revo fu be abe aberekma fu izeg rek? Na vierafega fuka uri ikuosaij fuon abe saname ar kafut amarigia kanaknum nisaik. ");
INSERT INTO nvm_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Fu nisaim vake gakma fuka oimarme uri kaifijaf ga e ar ijia funa karijo iji kume bu besum afuik. Bu afuiga fu kia, Na mon nun na abe aberenva iji nan una abenvano nin roga no besum duok ine oimarevno kiak. ");
INSERT INTO nvm_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ijegvo igia faif. Godon anera iji bu e iji erar fu ise fuon areme una oi dakaroime Godon roko iji buka fuifuon bomana oimarevno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Areme Jesu fu vuak fuon vek kuaimvako ijia fu una vuak be ijeg bijame kuardiain. ");
INSERT INTO nvm_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Fu kia, E be fu am farif nokarok (2) nafen. Regavo tavaibe am farif diar iji fu isema vierafene uri asoifuon kua, Asoinu a vek fino igia ni iviakma sinuom nun kege vajie vo nijaidiemne kuain. Ijefuon asoifuon fun uri sinuom kege afijaf nokarok (2) iji atame vajiain. ");
INSERT INTO nvm_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Fun atame vajiame arekoga naki sibank barko ijia farifuon diar iji fun sinuom fuon uruvana kege una e kafobuon kimene mon abe fun uri ai be vain. Fun va moik be aibe ijia kekome mon fuon dab unam ise kafokafo ijia akozeoin. ");
INSERT INTO nvm_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Fu ijegreoine mon fuon baremga ijia ar iji fu oinon ijia fuka vasia kekomga fuka vasia abene oifian abeoin. Ijegrene tavan be fun va e be moik iji abe fino ijefuon ik reoin. ");
INSERT INTO nvm_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Fu e ijefuon ik reoino ijia e iji fun kuama fu va maf fuon samuagdiaoin. ");
INSERT INTO nvm_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Regavo fuka mukorigia vasiaguainma ijefuon fu oinba maf ijiebuon duok iji roin ikafa vierafen ijefuon maiji fu erar fu duok kafo vajamo bakin. ");
INSERT INTO nvm_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Fu ijegre vake tavan be fu una fine mukoi dasu vierafene fui kuai, Na vierafega e iji bu iviakma asoinun ijefuon ikrejo iji buka duok uruvana iknum oij. Regavo naka igia vasia abene guakrej. ");
INSERT INTO nvm_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ijefuon na vierafe na ivia naka uri una asoinun fu fino ijia vak. Na va kekome asoinun kua, Naiji ja Godk nifak jon ijia ka isema ren. ");
INSERT INTO nvm_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ijefuon na ab una farifon igeg kiek. Regavo ni kie naiji na e on ik rejo igekino kiemne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Fun fui fi ijeg vierafene fun uri una asoifuon fu fino ijia vain. Fu vake asoifuon ijefuon ar iji fun samairen. ");
INSERT INTO nvm_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Fun samairenma ijia asoifuon fu gak farifuon fu gamia rokgame fuka uruvana oifiain. Ijefuon fu kukum vake gamia kekome farifuon dab anaime uimin. Fu uimimga farifuon fun uri kua, Asoinu naiji naka on isema ren vo madu Godon isema ren. Ijefuon na ab abe una farifon igeg kiek. Rega nin kie enun ik reno kiemne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Rega asoifuon iji fu faim arega uri e iji fuon ik rejo iji kume, Migegare ruafno kumen. Fu kumega bu rokga fu kia, Va ugon ka mukor ijia abe ro farinun igi abesame nin imut rin ga tamag iji kege samdafno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bun ijegrejga fu kia, Nin va maf-kau saruigi ijia be kaname abe roga no fuifuon duok bomana ik. ");
INSERT INTO nvm_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ijefuon maiji farinun igi fun guaigavo ivia fu una vek igaijar. Regavo madu fun sauigavo ivia no una bienvano kiain. Ijegreare bun fuifuon iro bomana ine oimaren. ");
INSERT INTO nvm_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Bu ijegrene farif amur iji fu juar gafia oine una ar gufia ruakafa roke mani faik bu asoifuon ijefuon ar ijia dua uruknum oimarev. ");
INSERT INTO nvm_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Bu ijegreja fu faime isuarigia roke ar samaij ijia manine e iji asoifuon ijefuon ikreno iji be kuama fu vakga fu kua, Ar gafi bu irerag abejno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Fu ijeg kuamga fu kua, Uviaion ijar una ruaiga asoion iji fu kuoga no maf-kau kaname fuifuon duok ij. Ijefuon maiji uviaion fuba guaigavo fu una ruainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Fu ijeg kuardamga farif amur iji fuka mukoi zieme fuba ar ijia aru vain. Fuba vakga asoifuon iji fu vierafe fu kekome farifuon soisoiga fu aru vakafa fu ijeg vierafene keko ruain. ");
INSERT INTO nvm_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Regavo farifuon amur iji fu una asoifuon ijeg kuardain. Fu kua, Ate na juaivasia uruvana naka igia on dibur ik igeg ik ren revo madu vuak a kuardiemo naba kege tuain rega naiji a irerag ma be abe mienma bakin. Aba ijeg maf-gout be kiema na kaname kaifnun ijiena ine oimaren. ");
INSERT INTO nvm_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Regavo farifon iji fu sinuom a vajainma iji fuka kege va kam bara iji bu baru turavo ijiebuon vajat ijia koren. Fu ijegreoine una rokga aka uri maf-kau iji dab fuifuon kana duok besum invano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Fu ijeg kuardamga asoifuon iji fu una kua, Farinu aiji a tavan uruvana nosik igia fino ijefuon irerag fok fun onum. ");
INSERT INTO nvm_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Regavo ivia noka duok ine oimarek ijefuon maiji uviaion fun guain gavo fu una urin revo madu fun sauin gavo ivia no una fu bienvano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesu e vuak fuon faivo ijin ijeg kuardiame una madu vuak be ijeg bijame kuardiain. Fu kia, E sinuom uruvana zarainma iji fu e be fu mon fuon samuakfuon iji aben. Regavo e sinuom uruvana zarainma iji fu rad faik efuon ikreno fu mon fuon iji fun kege unam kafokafo ijia koreoina fu fain. ");
INSERT INTO nvm_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ijefuon fu e iji kumena fu rokga fu kua, Eko na vuak on be ijeg fainva iji a irerag iji ren? Ni ik on a izeg renma iji kuardie na faiv. Ijefuon maiji aiji a una nuifuon ikreknum ire nun fok samuagdiakma bano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Rega e iji fuon ikreno iji fu uri fui kuai, Iviakma nakafu irerag abek? Na E bomana nun iji fun ik igi na rejo iji fun kiega na arek. Regavo naiji na daro bakin ijefuon na izeg una ik gigikin rekva ba. Regavo madu fuka ire jufdo naba una e kafo monfuo nimdiak. ");
INSERT INTO nvm_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ijefuon iviakma na irerag rekfuon iji nan vierafen. Na kaifnun iviamkor kafo kairenki na ik nun igi arekva na kaifnun iviamkor ijiebuon vaga bur oimarknum kiega na ar buon ijia vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ijefuon fun e besubesum iji bu e bomana fuon ijefuon ire iji bu kenva iji kumejga bu ruain. Bu rokga fu e iji amur ruainma iji kua, A ire izeg e bomana nun ijefuon kenmano kuain? ");
INSERT INTO nvm_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Fu ijeg kuamga fu kua, Na oir butor vuan adred (100) kenvano kuain. Fu ijeg kuamga e bomana iji fu una kua, Ni igia ari fine ire iji a kenma iji ufu una ari fifti (50) ijeg buk igia isoimne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Areme fu una e be iji kua, Regavo aiji a e bomana ijefuon ire iji a izeg kenmano kuain. Fu ijeg kuamga fu kua, Na farava beg vuan taosen (1,000) ijeg kenvano kuain. Fu ijeg kuamga fu kua, Ni igia ari fine ire iji a kenma iji ufu una ari eit adred (800) ijeg buk igia isoimne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Jesu fu ijeg kuardiame kia, E iji fuka ise rene e bomana fuon iji bisuain revo buka fu dab aroin. Ijefuon maiji fu mukor vierafene una kaifijaf iviamkor aferdia roga bu afikin fuon dasumdain. Ijefuon e moik igefuon e iji buk buka ijeg amarigia vierafeoknum una kaifijaf iviamkor roin aferdiaga bu afikin buon dasumdiav. Bu ire ijeg kegoijo ijia buka e iji Godon unam ma iji sanainma ijia kegoijo iji buka bur ka ma asidiav. ");
INSERT INTO nvm_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ijefuon Jesu fu uri vuak kuardiame kia, God abe kaijon igegrene ni mon jon kege e roin ifejdiaf. Ja ijegrenki God fu ja ifejdiame oimarknum aferdiaga ja varur gufia vakfuon. ");
INSERT INTO nvm_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ijefuon e be erar fu ire ukaknak iji kege mukor samuagdiakma fu una ire mamkanuk iji kege mukoi samuagdiakfuon. Revo erar ire ukaknak iji isema samuagdiakma fu izeg una ire mamkanuk iji mukor samuagdiakma bakin. ");
INSERT INTO nvm_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ijefuon a mon iji God fu vajamo iji aba kege una e roin ifejdiakma God fu varur gufia kaven ijefuon sinuom kafo una ja vajiakma bakin. ");
INSERT INTO nvm_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ijefuon ja Godon irerag fu vajainma iji jaba kege mukoi reokva fuba unam ma kafo una jon rek. ");
INSERT INTO nvm_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ijegvo madu igia faif. E besum fuba e nokarok (2) ijiebuon ik rekfuon. Ijefuon maiji fu e be fu mukoi oijmame fuifuon ikregavo una be iji fuka oisema vierafekfuon. Ijefuon jab God ga mon kege besum mazime buifuon ikreoijo. Rega nika God agoiknum vo igakgavo mon iji jab bomana vierafekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","15","Regavo e Ferisis iji buka mon uruvana oijmiavo ijefuon bu Jesu vuak iji fu kuaimon iji faime buka uri dab varaimen. Ijefuon Jesu fu uri kia, Vuak igi na kuardiainva iji jar e ijiebuon nifak ijia jaka mukoi kegoijo ijeg reoij. Regavo God fu oijon iji fun samakaf gia vierafen. Ijefuon maiji irerag ema bu ke mamkanuk igeg vierafejo iji una Godon nifak ijia buka bakin. ");
INSERT INTO nvm_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Regavo igia faif. E iji bu usuibe karine ruainva iji bu Mosison akaij ijiga e Godon vuak vierafene kuaivo ijiebuon vuak bu isoinva ijia giame jajiaknum karine roke e Jonon tavan ijia usen. Areme Jon fu tavan ijia Godon vuak ma iji izeg fu koikfuon una e fuon ijiebuon oij iji samuagdiakfuon ijin anerene kuain. Ijefuon iviakma e fok bu vuak iji faime buka una Godon e ijiena besum mazikuai buka giriesav. ");
INSERT INTO nvm_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Regavo igia faif. Rad varur gufeko moikigi bu barekfuon revo Godon akaij iji fuba bakrek. Ijefuon ja ise jon fok ja kegoijo ijia jaba arekva God fu ja kege akai fuon ijia giaknum vajai fian miak. ");
INSERT INTO nvm_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ijefuon igia faif. E be erar fu bara fuon abe uname vo una bara be abekma iji fuka e befuon bara iji daturam. Regavo e be erar fu bara iji bu abe unainva iji una abekma iji fu madu e befuon bara daturamno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","20","Fu ijeg kuardiame vake uri vuak be ijeg bijame kuardiain. Fu kia, E sinuom zarainma be fu tavan uruvana sinuom ni mukor same ar ma ijia fino. Regavo madu e sinuom bakin be if fuon Rasaras matan uruvana abenma iji bu afeme e sinuom zarainma ijefuon ar vien ijia unaga fu ijia fin. ");
INSERT INTO nvm_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Bu afeme ro ijia unaikin fu figa vasiaguakma fu uri va e sinuom zarainma ijefuon ar vien ijia duok ukur iji fu iga korenma iji ikafa bu ijeg ren. Regavo siroij iji buk buka ro matan fuon iji sirafiriknum ijeg rej. ");
INSERT INTO nvm_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Fu ijegrevake tavan be e sinuom bakin iji fu guamga anera ijieb dabme ajie Godon ar ma iji Eburam fu fino ijia unain. Fu ijia fikoga e sinuom zarainma iji fuk rad guamga bu abe mako ruin. ");
INSERT INTO nvm_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Regavo e iji fun guame va ar ise mian naino bu kua Edis kuavo ijia fine vajai fian bomana aben. Fu abeknum una gafeg kaf gufia gak Eburam fu Rasaras afeme fusik aibe ijia fina fu giain. ");
INSERT INTO nvm_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ijefuon fu uri kume, Eburam asoinu abe nun oifian aben. Ni Rasaras kuaga fu ro imut fuon ijia do abesme itit nun igia azirdiega fu gardiem. Ijefuon maiji naka mian igi naino ijia vajai fian bomana abejno kumen. ");
INSERT INTO nvm_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Rega Eburam fu una roin kume, Farinu ni vierafe on a fi ruainma ijia ire on ma iji fok an ken. Regavo e Rasaras fu ire ise iji ken. Ijefuon ni ijia fine vajai fian abegavo fuiji fu igia oimarknum fik. ");
INSERT INTO nvm_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Regavo igia fai. Mako ka dibuor bakin be fu uf ijijar. Ijefuon eraneb bu igia una ijia on vuakfuon iji buka ba aresredo bu izeg vuakva bakin. Regavo madu fu erar izeg iji a fino ijia una igia nuvuon ruakma bano kumen. ");
INSERT INTO nvm_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Fu ijeg kuardamga e sinuom zarainma iji fu una kume, Asoinu e-e ni Rasaras kuaga fu una va asoinun ijefuon ar ijia uviaifnun imut roin (5) iji samakaf visume kuardia. Va kuardiaikin buba ar igi na fine vajai fian abejo igia rokno kumen. ");
INSERT INTO nvm_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Regavo Eburam fu una roin kume, Uviaifon iji bu Mosis ga e Godon vuak vierafene kuaivo ijiebuon akaij iji bu isoinva iji bun dame vierafen. Ijefuon ni arega uviaifon bu vuak iji bu isoinva iji dame mukoi vierafekfuon. Ijefuon maiji bun siban e ijieb ijia isoime kuardiainvano kumen. ");
INSERT INTO nvm_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Eburam fu ijeg kumega e sinuom zarainma iji fu una roin kume, Eburam asoinu iji na vierafe fuka ba aresren. Ijefuon fuka e guainma ijar una uri buon vake bu ijia game una ise buon nuigafiakno kumen. ");
INSERT INTO nvm_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Rega Eburam fu una kume, Regavo bu vuak iji Mosis ga e Godon vuak vierafene kuaivo vuak iji bu buk akaij ijia isoinva iji buka ba dame fain. Ijefuodo bu madu e guainma fu una uri buon vakma buba vuak fuon faime ise buon arekno kumen. ");
INSERT INTO nvm_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","2","Jesu fu ijeg kuardiame una e vuak fuon faivo iji kia, Tavan uruvana ire iji bu e biesiako bu iserejo iji buka nuvuon rekfuon. Regavo e iji erar fu e roin ifejdiako bu ise rejo e iji fuka amarigia jukfuon. Regavo madu erar fu e roin bu iviakma God ma vierafejo iji biesia bu ise rekva Godri e iji abe ka amarigia arafirik. Ijefuon fu iji fu isekma nika uri mun ma bomana ijia abe uro fuon ijia kira saof ijia arikma iji fuka marek. ");
INSERT INTO nvm_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ijefuon nika koikjo mukoi samuanamif. Regavo uviaion be fu ise reoinon a gakma ni kua, Irerag a reoinon iji fu iseno aremne kuamne. Regavo a ijeg kuaga fu ise fuon una a kuardakma ni faime oion ijia are. ");
INSERT INTO nvm_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Regavo fu madu una tavan besum ijia on ise uruvana rejknum ro kuak, Kainu naka on ise renvano gieme aremne kuakma ni giame aremne kiain. ");
INSERT INTO nvm_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ijegreare Jesuon e afasor ijieb madu uri fu kua, E Bomana nuvuon no ma vierafejo ijin kege mamkanu reduoga no darokma God ma vierafejno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Bu ijeg kuardavga fu uri kia, Jon ja ma vierafejo iji bu ukaknak in sira sunin ijekin iji ja aresredo ja uri in guri kuak, Ni gireg gamia jafene saof ijia arimne kuakva fu igiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Areme Jesu fu una vuak be ijeg bijame kuardiain. Fu kia, Ja e be fu oifuon ikreno fu juar ijia ikrek vain vo baga fu maf samuagdiafoine una ruakma a irerag abek? Abe uri kuak, Eko migegare ro igia arifine duok on na kanafuidainva igi ine kuak? ");
INSERT INTO nvm_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Na vierafe jaba ijeg kuardakfuon revo jaka una madu kuak, Migegare va duok nun na ikfuon iji kanafu. A ijegreare nin samuake na duok ga do ine barga nin son rad ro fine duok ga do on ine kuak. ");
INSERT INTO nvm_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Fu ijegrene uri vuak fok a kuardamo ijia reokma a vierafe abe ijefuon una fuon oimarek? Iji fu bakin ijefuon maiji fun ik fuon fu reno fu iji ren. ");
INSERT INTO nvm_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ijefuon jak jaka unam besum ijeg rekfuon. Ja ikjon ja rekfuon God fu vajiainma ja iji reokva iji nin kuai, Noiji nom e Godon ik reoijo ijin ijefuon non ik nuvuon reoijno kuaikfuon. ");
INSERT INTO nvm_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","13","Areme tavan be Jesu fun ar Sameria irif Gareri samaij ijia mai be ijia kekokafa vako ijia fu e imut roinroin (10) e vajai kasi bu kua refrosi kuavo iji abenva iji biediain. E iji buba usem Jesu niriain revo bum aibe gafia ireme uruvana igia kume, Jesu E Bomana abe nuvuon oifian abene ifejduokno kumen. ");
INSERT INTO nvm_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Bu ijeg kumejga Jesu fu giame uri kia, Ni va e isuf baroijo iji giame vajai jon iji bu nijaidiavno kiain. Jesu fu ijeg kuardiamga bun una vakuai unam ijia vako ijia vajai kasi iji bu abenva iji fun bakiten. ");
INSERT INTO nvm_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Rega e besum fu uri gak vajai fuon fun una marenma fu gain. Ijefuon fuka uruvana igia kumejknum Godon if abe ajievknum oimarme una ruain. ");
INSERT INTO nvm_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Fu una roke Jesu fino ijia ato same fuon oimaren. Regavo e iji fu e ai Sameriako ijar ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Areme Jesu fu uri e iji kua, E iji na e imut roinroin (10) ijeg kasi abenva na ifejdiava bu madiain revo e nain (9) iji bu izer? ");
INSERT INTO nvm_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Regavo irerafuon e ai beko igi fu fuonkua God oimardakafa ruainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Rega Jesu fu uri e iji ruainma iji kua, On a ma vierafenma ijar a keunainmano ni uri vakne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Areme tavan be E Ferisis roin bu uri Jesu duna be kua, A vierafe tavan iji God fu una efuon ijiebuon oij iji samuagdiakfuon iji fu ivez rekno kuain? Bu ijeg kuardavga Jesu fu kia, Unam iji fu reno e bu izeg ni buon ijia gakva bakin. ");
INSERT INTO nvm_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ijefuon e be fuba kuaik, God fu iga ga garano kuaik. Ijefuon maiji God fu e besubesum oijon ijia samuagdiamno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","23","Ijegreare fu madu uri e vuak fuon faivo iji kia, Vake tavan abekma jaka karine Ema ijiebuon Farif ijefuon tavan iji fu una ruakfuon jaka iji gakuai karine ijefun rek. Regavo tavan iji e fok jaba gak. Regavo tavan iji fu una roko iji fu Godon sanainma ijekma una ruak. Regavo tavan ijia e buka usem biesiame kiak, Fu gafia vo fu igijano kiaga jab useme na nisaidie vuak. ");
INSERT INTO nvm_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ijefuon maiji tavan iji na una roko iji fu varur gari fu karaga e fok bu gavo ijeg Ema ijiebuon Farif igi na una roko iji fun unam besum ijeg ruak. ");
INSERT INTO nvm_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Regavo amur naka uruvana igia vajai fian abek ga madu e igi iviakma karijo iji buka na uzak. ");
INSERT INTO nvm_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Bu e Noan tavan ijia e uruvana izeg bu kenva ijeg Ema ijiebuon Farif igi na una roko tavan ijia e uruvana bu unam besum ijeg rekfuon. ");
INSERT INTO nvm_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noan tavan ijia e uruvana bu karine duok iknum do iknum barubara bui sanamiknum buka ijeg rein. Bu ijegrene roke tavan iji Noa fu sisim ijia ajiekoga do iji fuim ijia firame keko e fok numume vain. ");
INSERT INTO nvm_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ijegvo madu tavan iji e Rot fu finma ijia e fok bu madu duok iknum do iknum ire kafokafo kimejknum ijeg ren. Bu ijegreknum uri ire kafo kege una e kafona ivajuinamiknum ire uij iviamkor abedeknum ar saknum ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Bu ijegre roke tavan iji Rot fu ar Sodom areme vakoga mian iji fum varur gufia arime e fok ka naibaren. ");
INSERT INTO nvm_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ijegvo tavan iji Ema ijiebuon Farif igi na una roko iji fun unam besum ijeg rekfuon. ");
INSERT INTO nvm_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Regavo igia faif. Tavan iji E Bomana na una roko ijia e be fu ar fuon azan ijia ajie fino iji fuba una arime ar guf ijia sinuom fuon fok karekfuon. Regavo madu be fu juar fuon ijia oinon iji fu tavan ijia fuba una ire kafo ar fuon ijia naoivo iji karekfuon. ");
INSERT INTO nvm_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ijegvo ni unam izeg e Roton bara iji fu ar fuon mian naiga fu uri sinuom fuon iji vierafega mian fu jakinma iji vierafef. ");
INSERT INTO nvm_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ijefuon erar fu moikigia tavan bog fuon vierafenma iji oijmame keokma rad fu una izeg unam ma karivako iji abekma bakin. Regavo erar fu moikigia tavan bog una e roin vierafeknum oijmiame ifejdiafoinma iji fu rad unam ma karivako iji abek. ");
INSERT INTO nvm_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Regavo naka ma kuardiavo igia faif. Tavan iji na una roko ijia e nokarok (2) bu ar besum naoinva ijia anera bu ari e besum (1) afegavo be bu ijia arek. ");
INSERT INTO nvm_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Regavo madu bara nokarok (2) bu duok nifiejo ijia anera bu arime bara besum (1) afega be bu ijia arek. ");
INSERT INTO nvm_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Regavo madu e nokarok (2) bu juar ijia oijo ijia anera bu arime e besum (1) afega be bu ijia areme vakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jesu fu ijeg kuardiamga e vuak fuon faivo iji bu uri kua, E Bomana ire iji fu izia rekno kuain? Bu ijeg kuardain gavo Jesu fuba una vef roin kuardiain revo fum uri vuak ijeg bijame kia, Ar izerkin ire kafo aoinva bu naoivo iji um buruof iji fanuf kuniai bua ioijo ijieb udi ijia faime va ijia reoga ja giakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Areme Jesu fu vuak be bijame e vuak fuon faivo iji kuardiain. Fu ijeg kuardiaga bu vierafekin buka tavan uruvana sirimamekgavo buba uzakfuon. ");
INSERT INTO nvm_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Fu kia, Mai be ijia e bomana e kot faimo be fu ijia fino. Revo e iji God fuba bomana juvknum vo ema iji fu jume agordiamo bakin. ");
INSERT INTO nvm_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Regavo bara amun be mai besum ijia fino iji fuka tavan uruvana ro fu fino ijia kekome kua, Abe e iji bu na dab arafirievo iji ifejdieme oifian nun dasumdiekno kuam unaim. ");
INSERT INTO nvm_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Regavo e bomana kot faimo iji fuka ba ifejdakafa vierafen. Revo fu uri fui kuai, Na God na juvknum ema iji akariavo bakin. Revo bara amun iji fu na kiekieko naka isediem. Ijefuon ivia na fu ifejdame unam fuon amarek. Regavo bakma fu ijegreke na fuka isediekno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","7","Areme E Bomana Jesu fu uri kia, Ja vuak irerag e bomana akai samuamo fu renma na kuaivo iji jan fain. Regavo ja vierafe God fube efuon iji bu nakikmazak fuon sirimamejo iji ijeg ifejdiak? Revo madu ja vierafe fube saroime ifejdiak? ");
INSERT INTO nvm_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Naka ma kuardiav fuba saroik gavo fuka migegare ifejdiak. Regavo tavan iji Ema ijiebuon Farif igi na una roko iji ja vierafe e fok bu kafu vek na ma vierafeke na giak? Ijefuon nika unam izeg bara amun fu kenma ijeg mimatame God sirimamene kuara unar kekin fu ifejdiaga e ani jon buba unam jon kam arafiriakfuon. ");
INSERT INTO nvm_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Areme Jesu fu madu uri vuak be ijeg bijame e iji kuardiain. Fu giak e roin buka koikbuon aroinamiknum vierafero buka mukor rej ga e roin buka isema reojoro buka una e roin ni iken giamoijo ijefuon fu vuak ijeg bijame kuardiain. ");
INSERT INTO nvm_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Fu kia, Tavan be e nokarok (2) bu Godon ar ijia sirimamekuai vain. E be fu e Ferisi ga be fu e takes abeoinon ijin. ");
INSERT INTO nvm_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","E Ferisi iji fu va fuibe manine Godon sirimamen. Fu sirimane kua, God na on oimarev ijefuon maiji nam e roin bu bara turaknum sinuom rareknum ire ise kafokafo reoijo ijekin bakin. ");
INSERT INTO nvm_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Na vuik besum (1) guf ijia naka naki nokarok (2) na oifuon duok karoknum vo naka mon nun na abejo iji roin na abe oifuon abedevo. Naka on oimarev. Na e gari takes abeoinon ijekin bano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Fu ijeg sirimamen vo e takes abeoinon iji fu aibe ijia manin. Fuba ro asarajieme varur gufia gavknum sirimamen revo fum oi fuon ijia kanaknum kuai, O God naka isema reoijo ijefuon ni nun oifian abene kuain. ");
INSERT INTO nvm_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesu fu vuak ijeg bijame kuardiame kia, Na ma kuardiav e nokarok (2) iji bu sirimamenva ijia e iji takes abeoinon ijar fu Godon nifak ijia fu mukoi ken revo e be iji fu bakin. Ijefuon maiji erar fu koikfuon abe e bomana rekma rad fu e ukakbe rek. Revo e iji erar fu iviakma kabuaikabuaiki reoinon iji rad God fu e iji abe e bomana rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jesu fu vuak iji kuardiame barko bara roin bu am ukaknak iji aferdia fuon roga fu imut nigen namdiakro bu iji aferdia ruain. Regavo e vuak fuon faivo buka uri kuriaireme bijuin. ");
INSERT INTO nvm_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Bu ijeg bijuivga Jesu fu uri kia, Am ukaknak iji jab bijukuriakgavo ni arega bu ruaf. Ijefuon maiji God fu e iji eraneb bu am ukaknak igi bu asoijbuon ma vierafejo ijeg bu na ma vierafejo fu e ijekin iji samuagdiakafa vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Regavo igia faif. Eraneb buba am ukaknak iji bu asoijbuon ma vierafejo igegreare na ma vierafekva e iji bu Godon e rekva bano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Areme tavan be e Jiusbuon e bomana fu uri Jesu kua, E nijaidiamon mukor gure. Na irerag rekva na ma karivako iji abekno kuain? ");
INSERT INTO nvm_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Fu ijeg kuardamga Jesu fu una kua, A irerafuon na kie a e mano kiem? Fu e be erar e ma bakin revo e ma iji fun e besum God fuonkua. ");
INSERT INTO nvm_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Regavo a Godon akai fu nainma iji an vierafen. Ijefuon ab e kafobuon bara turaknum ab e kaniaknum vo ab niesaknum vo ab vuak kufuimene kuaimok. Regavo madu nika asie asoion iji amarigia igiamne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Jesu fu vuak ijeg kuardamga e iji fu una kua, Na vek am ukak ijia na akai fok naka igia ruainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Fu ijeg kuardamga Jesu fu faime una kua, Iji fun maren revo na vierafega a una ire besum ijin rekfuon. Na vierafe aka una va ire on fok kege kime mon abe e sinuom bakin iji vajiame nin una na jajie. ");
INSERT INTO nvm_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Jesu fu vuak ijeg kuardamga e iji fu vuak iji faima fuka oifiain. Ijefuon maiji fu vierafega fuka sinuom uruvana zarain. ");
INSERT INTO nvm_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ijegreare Jesu fu gak e iji fuka oifiain magame fu uri kua, E iji bu sinuom uruvana zarainva iji bu una e iji God fu oibuon iji samuagdiafo ijiena mazikva fuka ma gigikin. ");
INSERT INTO nvm_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Regavo igia faif. Fanuf kamer iji fuka ma bomana ga siem tit iji fuka ukakbe ijefuon fu ijia aru vakma fuka ma gigikin. Ijefuon unam besum ijegvo e sinuom zarainma fu e iji God fu oibuon iji samuagdiamo ijiena besum mazikfuon iji fuka ma gigikino kiain. ");
INSERT INTO nvm_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Areme e vuak iji fainva ijieb uri bui kuai, Fu erar aresredo fu e iji God fu oibuon iji samuagdiamo ijiena besum mazikno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Bu ijeg kuaivga Jesu fu una kia, E be fu erar fum fuon izeg fu mukoi vierafeno ga unam fuon fu kegoino ijia fu aresrenma bakin. Regavo fun Godri fuonkua fu aresredo fu ire fok rekfuon. Fur fuonkua era fu vierafenma iji kuaga fu e iji God fu oibuon iji samuagdiamo ijiena buna besum mazikno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Rega Fita fu uri Jesu kua, E Bomana no ar nuvuon iji noka ijia areme uri a jame ruainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Fu ijeg kuardamga Jesu fu uri kua, Vuak iji an ma kuardiem. Regavo igia faif. Eraneb bu uri ar buon ga ag barabuon ga uviaifijaf ga eofijaf fok ka nuigafiame uri nuifuon ikrekva bu vek moikigia karijo ijia God fuka unam ma kafo buon rek. Regavo madu bu aoikva tavan rad bu unam ma karivako iji abekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Areme Jesu fun e tuer (12) vuak fuon faivo iji aferdia besum uniame kia. Igia faif. No Jerusarem ijia vak. No ijia vainki vuak irerag fok e Godon vuak vierafene kuaivo bu Ema ijiebuon Farif igi nuifuon buk akaij ijia isoinva iji fuka aresrek. ");
INSERT INTO nvm_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","Bu na abe una e Jius bakin iji miaga bu vuak ise nuisina kuaiknum dab varaimeknum juvit foimadiek. Regavo madu bu na dab fijieme dab kuros kaniek. Regavo naki nokbek (3) barekma na ijia una urikno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jesu fu vuak ijeg kuardiain gavo e vuak fuon faivo iji buba amarigia fain. Ijefuon maiji fu Kaven Akai ijar vuak ijefuon maiji fuba abe oibuon ijia samafrediain ijefuon buba mukoi faime vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","36","Areme Jesu fun ar Jeriko samaij ijia roko ijia e ni zuriaigin be fu unam irif ijia fine duokfuon nimdiam. Fu fine ijegreno ijia fu faik buka e uruvana fu fino ijia irovajaknum asiva fu faime uri e iji kia, Iji bu irerag abejno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","38","Fu ijeg kiamga bu kua, Fu Jesu e Nasaretko ijar ruvakno kuain. Bu ijeg kuavga fu uri kume, Jesu e Devidon uifarif gafe ni afikin igi na abejo iji gieme nun oifian abene ifejdiemne kumen. ");
INSERT INTO nvm_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Fu ijeg kumega e iji amur roko ijieb uri kuriaireme kua, E gume isuar fine kuain. Regavo fuka una madu uruvana igia kume, E Devidon uifarif gafe ni afikin igi na abejo iji gieme nun oifian abene ifejdiemne kumen. ");
INSERT INTO nvm_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Fu ijeg kumega Jesu fu faime ijia manine kiama bu e ni zuriaigin iji afeme fuon vain. Bu afeme Jesu manino samaij ijia vakga fu kua, Na irerag iji redakro a iji vierafenmano kuain. Fu ijeg kuamga e ni zuriaigin iji fu una roin kua, E Bomana na vierafega naka una ni narakafie vierafenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","43","Fu ijeg kuamga Jesu fu uri e ni zuriaigin iji kua, On a ma vierafenma ijar a amardainmano ni ninaramne kuain. Rega tavan ijia e iji fu una ninara nisaime uri Godon oimarknum Jesu ja vain. Fu ja vakga e fok bu iji game buk uri Godon oimaren. ");
INSERT INTO nvm_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Jesu fu ijegrene fun Jeriko mai bomana iji asidiame vakafa vain. Regavo e takes abejo ijiebuon e bomana be ijia fino if fuon iji Zekias. Regavo e iji fu e ikin ga fuka e sinuom uruvana zarain. ");
INSERT INTO nvm_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","4","Regavo Zekias fu Jesu e izekin fu iji gakafak vierafen revo fuka e ivuankbe ijefuon fu izeg e fok ijiebuon nifak ijia Jesu gakma bakin. Ijefuon fu asidiame kukum roke in durim ijekin be unam irif ijia manino ijia ajien. Fu ijia ajie fine Jesu vuako iji gam. ");
INSERT INTO nvm_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","6","Fu fine gakoga Jesu fu roke in anej ijia kekome asarajie Zekias game kua, Zekias migegare ari rokne ijefuon maiji ivia na ar on ijia fikno kuain. Fu ijeg kuamga Zekias fuka oimaimga fu migegare ari kekome Jesuon bomana oimaren. ");
INSERT INTO nvm_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Fu ijegrega e fok bu game buka zien. Ijefuon bu isuar kuai e guri fuka e ise reno gavo e ikin guri fuka ar fuon ijia vakreno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Regavo Zekias fu uri manine E Bomana Jesu kua, E Bomana igia fai na vierafega naka ire nun fateroin kege una e sinuom bakin iji ik vajiaken. Regavo gaga na e roin biesiame ire buon roin kegogakva iji na vierafega naka una ire kafo kege una ire buon iji na kenva ijekma vajiakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Fu ijeg kuardamga Jesu fu una roin kia, Ivia e ar igia karijo ijiebuon ise iji God fun giame aren. Ijefuon ja jonkua Eburamon uifarif bakin gavo Zekias fuk fu Eburamon uifarif be. Ijefuon maiji fu na ma vierafen. Regavo Ema ijiebuon Farif igi na ruainva iji na e ijekin bu ise rene God uzame vainva na ijin nisaidiame aferdiaknum karauniakro ruainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Areme e uruvana bu vek karine Jesu vuak iji fu kuardiamo iji faikoga fu madu vuak be bijame kuardiain. Ijefuon maiji fun Jerusarem samaij ijia vako ijia fu vuak ijin kuaimga e bu vierafero tavan iji God fu efuon ijiebuon oij iji samuagdiakfuon iji fun iviakma igia rekrenoro bu ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ijefuon Jesu fu uri kia, E ikin be fu moik be ijia e bomana rekafa ijefuon daro abek vaido fu una ruakfuon. ");
INSERT INTO nvm_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","E bomana iji fu vakafa vierafene uri efuon ikrejo imut roinroin (10) iji kege uri mon fu nainma iji kege ata vajiain. Fu vajiame kia, Na vako ni mon ijin kege ik jon kafokafo rene una mon kafo amarega na una ro karevno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Fu ijeg kuardiame fun vek unam vako efuon iji buka fu uzame ziegafain. Ijefuon bu e vuak abe oijo iji kiava bu rad jame va e ikin iji kua, Eon gami bu kume no e iji fu e bomana nuvuon rekreno iji noka iseduomno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Regavo e ikin iji fu vuak buon iji fum faim arega fun va izeg fu e bomana rekfuon daro iji abe una ruain. Fun una ro kekome e iji mon fu atame vajiama bu kege ikrene una kafo azan kenva ijin giakafa kumena bu besum ufuin. ");
INSERT INTO nvm_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ijegreare e be fun kekome kua, E bomana na mon iji a mienma iji na abe ik rene una mon kafo imut roinroin (10) ijeg kege ijekma nainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Fu ijeg kuardamga e bomana iji fu uri kua, A ire ukaknak iji kege amarigia samuagdiado na kuaga a mai mamkanuk imut roinroin (10) iji samuagdiakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Fu ijeg kuardame una efuon ikreno be kumena fu vain. Fu kekome kua, E bomana na mon a mienma iji na abe ikreoine una mon kafo imut roin (5) ijeg kege una ijekma nadaivano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ijefuon e bomana iji fu una kua, A ijegrenma ijefuon a mai imut roin (5) iji samuagdiakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Areme fu una efuon ikreno be iji kumena fu vain. Fu kekome kua, E bomana mon on a mienma iji igaijar. Naka a juinva ijefuon na abe amarigia ugon ijia anume abeden. ");
INSERT INTO nvm_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ijefuon maiji na vierafega aiji aka e darokin fu erar a biesuakma bakin. Ijefuon na mon igi kege iremirekva tavan iji a una roko ijia na izegrekva bakin. Regavo madu a ire kafo a imut on ijia oinma ga nainma bakin iji am ijia kareknum masimoino ijefuon na iji ijegrevano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Fu ijeg kuardamga e bomana fuon iji fu una kua, A ijeg kuaimon ijefuon na vierafega aka ba nuifuon ik amarigia ren ijefuon na a dab arafirak. Regavo igia fai. Naiji naka e darokido na irerag nar nainva ga oinva bakin iji na masiknum karvo. ");
INSERT INTO nvm_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ijefuon a irerag abega a mon nun iji aba abe ar bu mon navo ijia abedekoga bu abe ikrene una mon kafo amardienvano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Fu ijeg kuardame fu una efuon ikrejo ijia irenva iji kia, Mon guri abe una e gari mon kege amarigia ikreno iji mafno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Fu ijeg kiamga bu una kua, E bomana e iji an amur mon bomana be fu mainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Bu ijeg kuardavga e bomana iji fu una roin kia, Na igi kuardiavo ni faif. E iji eraneb bu ire uruvana kenva iji bu una madu ma uruvana kek. Regavo erar fu ire kafo ba nainma iji irerag sibank fu nainma iji bu una kamazak. ");
INSERT INTO nvm_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Regavo e ani nun bu na e bomana rekfuon iji bu uzainva iji ni aferdiame ro na manijo nifak guria usem kania bu aoivno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesu fu vuak ijeg bijame kuardiame baremga fun amur Jerusarem vakga e uruvana bu rad jame vain. ");
INSERT INTO nvm_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Fun roke ar Betifas ko Beteni samaij uruor Orivsno kuavo ijia kekoin. Fu ijia kekome uri e vuak fuon faivo nokarok (2) iji vuak igin kuardiain. Fu kia, Va ar gafia useme vien ijia aruvaf. Ja vien ijia aru vaga bu maf-donki uka be buba abe oijo iji ijia kiraiga iji irame abe una igia ruaf. ");
INSERT INTO nvm_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Regavo ja iraga ebe fu giame kiaga ni kua, E Bomana ijar kuoga no iravno kuaf. ");
INSERT INTO nvm_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Areme e iji bun vake gafia usem vuak fok Jesu fu kuardiainma iji bun useme ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bun usem maf-donki uka iji iravga e koikin iji fun uri kia, E garie ja irerafuon maf-donki uka iji iravno kiain? ");
INSERT INTO nvm_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","35","Fu ijeg kiama bu una kua, No E Bomana ijar kuoga no iji iravno kuame bun abe una roke Jesu fino ijia usen. Areme bun ugon buon bu azan savo iji azome maf-donki azan ijia rieme Jesu imuikeja fu ijia ajie fin. ");
INSERT INTO nvm_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Areme fun abe unam ijia vako e roin bu ugon buon bu azan savo iji azome unam ijia riedako fu azan ijia vain. ");
INSERT INTO nvm_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Fun vake ar Jerusarem samaij uruor Orivs unam dorok ijia kekoin. Fu ijia kekomga e uruvana vuak fuon faivo iji bu fu ja roko iji bun ijia anerene ire sumakin fu rena bu gainva ijefuon uruvana igia Godon oimaren. ");
INSERT INTO nvm_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bu oimarknum kume, No vierafe Godri Kin igi fu E Bomana ijefuon if ijia rokon igi daro mak. Regavo no vierafega ire fok varur gufia naoivo bu afuime ijia naoim vak. Regavo madu noka Godon if iji dab aroikno kumen. ");
INSERT INTO nvm_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Areme e uruvana irenva guf ijia e Ferisis roin bu uri Jesu kua, E nijaidiamon ni e vuak on faivo iji kia bu isuar irevno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Bu ijeg kuavga Jesu fu una roin kia, Naka ma kuardiav na kuriaire bu arekva mun guri naoivo iji buka uri na arordiekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Fu ijeg kuardiame fun ajie roke mai bomana Jerusarem samaij ijia keko mai iji gama fuka oifiaima fu una efuon ijiebuon nirain. ");
INSERT INTO nvm_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Fu niraiknum kume, O e Jerusaremko igie irerafuon ni jon fuka vek nakinman ijefuon na jaka ba gieme vierafen. Regavo ja na gieme vierafenvabatie iviakma ja na amarigia agordiek. ");
INSERT INTO nvm_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Regavo ijeg jaka bakin ijefuon vake tavan be abekma ijia e ani jon bu unam jon iken roinroin ja usem vakfuon iji buka ufutkuria ameoine bijukuriak. ");
INSERT INTO nvm_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Areme bu uri ar jon ga e fok mai guf ijia karinva ijin arafiriak. Regavo mun iji bu kege ar jon sainva iji buka uduimarik. Ijefuon maiji ja Godon tavan iji fu ja karauniakafa ruainma iji jaba game ma vierafenvano kumen. ");
INSERT INTO nvm_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesu fun ijeg niraiknum kuardiame fun Godon ar bu sirimamejo ijia arume e iji bu karine ire kafokafo kimejo iji kuriaireme kiama bu usen. ");
INSERT INTO nvm_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Fu ijeg kiama bu usekoga fu uri kia, Usuibe buk akaij iji bu isoinva ijia God fu kuai, Ar nun iji bu ijia sirimamejno kuain. Regavo jar ijia aru karine dab e niesavobuo ar igeg amarevo kuain. ");
INSERT INTO nvm_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Fu ijeg kuriairega bu usem vako fu tavan uruvana Godon ar ijia vuak nijaidiam. Regavo e Godon isuf baroijo ijiebuon e mamkanuk ijiga e vuak akai nijaidiavo ijiga e aiko ijiebuon e mamkanuk iji bu ka Jesu kanakuai vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Regavo bu unam iji bu izeg Jesu kanakfuon iji bu nisaimga fuka iseren. Ijefuon maiji e uruvana buka vek ijia karine vuak fu kuaimon ijefuon ma ijin abekuai amarigia faiv. Bu vuak besum be buka ba asikuai vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","2","Areme tavan be Jesu fu Godon ar ijia arume vuak nijaidiaknum vuak fuon ma iji kuardiain. Fu ijeg kuardiamo ijia e mamkanuk Godon isuf baroijo ijigam e mamkanuk vuak akai nijaidiavo ijigam e mamkanuk roin bu besum afuime usem Jesu kua. A daro iji a izia aben ga erar abe mainma a iji abe ire igi reoinon ni kuarduo no faivno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Bu duna ijeg kuardavga Jesu fu uri kia, Iji jan ma kuardien revo ni areke na duna be kuardiakrejo ni faif. Ja vierafega e Jon daro iji fu abe e do ruardiamo iji fu emab main ki fu Godri mainmano kiain? ");
INSERT INTO nvm_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Fu ijeg kuardiamga bu uri vuak ijefuon dab bui sigume kuai, Vuak iji note una izeg kuardak? No kuaik Jon daro iji fu Godri mainmano kuakva fu una kuok revo ja irerafuon jaba Jon ma vierafenvano kuok? ");
INSERT INTO nvm_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Regavo madu no kuak daro iji fu emab mainvano kuakva no vierafega e uruvana igia irenva buka mun tuame kanuokno kuain. Ijefuon maiji e fok bu vierafega Jon fun ma e Godon vuak vierafene kuaimon ijin. ");
INSERT INTO nvm_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","8","Ijefuon bu vierafega fuka iserga bu uri kua, No Jon daro iji fu izia abenma iji noba vierafenvano kuain. Bu ijeg kuardavga Jesu fu kia, Ijekido nak na daro igi na izia abe ire igi kegoijo iji naba kuardiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Areme Jesu fu una madu suar be bijame e iji kuardiain. Fu kia, E be fu juar be mene e kafo kena bu juar iji samuako fun ar aibe vain. ");
INSERT INTO nvm_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Fu va ijia fine faik in fu oinma iji bun sunin kira baiva fu faime fun una efuon ikreno be kuama fu i sunin iji kafo tura vajakafa ruain. Fu roke gufia kekomga e iji juar samuame karinva ijieb uri e iji kunaime kanavga fu ire kafo ba ken revo fum imut kiriasame una vain. ");
INSERT INTO nvm_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Bu ijegrejga fu una efuon ikreno be kuama fu una rokga bu madu kanaknum dab unam kafokafo fu juf abekfuon ijia rejga fu ire kafo ba ken revo fum una imut kiriasame vain. ");
INSERT INTO nvm_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Areme e bomana iji fu una efuon ikreno be kuama fu rokga bu una madu e iji kaname dab gama akozen. ");
INSERT INTO nvm_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Areme e iji juar menma iji fun uri fui kuai, Nakafu izeg rek? Na vierafe iviakma naka farinun iji kua fu vakma bu ir fuon abene fu agordakno kuaime fun farifuon iji kuama fu ruain. ");
INSERT INTO nvm_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Regavo e iji in fu oinma iji samuagdiame karinva iji bun uri fu game bui kuai, E gafi no vierafega fu e juar igi mene vainma ijefuon farif ijin. Ijefuon rono kaname uri asoifuon ijefuon ire fok nuvuon karevno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ijefuon bun uri farifuon iji kunaime dab vuain oinva fak gufa akozme fu kanava fu guainmano kiain. Ijegreare Jesu fu uri kia, E iji bu ijeg ren revo ja vierafega e in iji oinma fu una ruakma fu e iji in samuagdiavo iji fu izeg rek? ");
INSERT INTO nvm_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Fu ruakma fu e in iji isema samuagdiavo iji fuka kaniaga bu aoike fu in fu oinma iji kege una e roin vajiakno kiain. Fu ijeg kuardiamga e iji bu vuak iji faime bui kuai, E iji no vierafe buba ijegrekno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Bu ijeg kuaivga Jesu fu una bu giame kia, Regavo ja vierafega Godon vuak iji bu usuibe buk akaij ijia isoinva iji bu irerafuon ijeg isoime kuai, E iji ar savo iji bu kudie ma iji girme manikfuon iji bu garo fu kudie isero bu abe akozen. Regavo rad bu ga kudie iji fuka ma mukor ga fuka mano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ijefuon erar fu kudie iji uzainma iji fu rad arikanaga fu kudie ijefuon azan ijia arikma fuka buaseme iserek. Regavo madu kudie iji fu ari e be kanakma fuka buaseme kuotuvat igeg rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ijefuon e vuak akai nijaidiavo iji abevo e Godon isuf baroijo ijiebuon e mamkanuk iji bu vierafe buka migegare Jesu kunaim tokuai vierafen. Ijefuon maiji bu vierafega vuak iji fu bijame kuainma iji fu buisina kuain. Regavo bu una e ijia ruainva iji juin. ");
INSERT INTO nvm_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ijefuon bu ebuon kafo subidiame sivisa bu isuarigia Jesu nikajame oknum biesuame duna kafokafo kuaknum ijeg ren. Bu ijegreoknum ga are fu vuak iji bu kuardavo ijia una vuak ise kafo kuaiga bu kunaim tokuai ijeg ren. Bu tom abe una e Romko buon e bomana daro iji samuamo iji maga fu efuon bijaivo iji kiaga bu kanakuai bu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ijefuon e iji bu sivisainva iji bun va Jesu fino ijia usem kuai, E Nijaidiamo no vierafega vuak on a kuaimoijknum nijaidiamon iji aka ma reoin. A ijegrejknum e kafo a jumo bakin ga aka Godon vuak ma iji fu e igiebuon vierafenma a ijin kuardiam. ");
INSERT INTO nvm_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ijefuon a vierafega akai nuvuon ijia fube mardo no e Romkobuon e bomana ijefuon takes rek. Ni ar kuarduoga no faivno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Regavo Jesu fun giaga bu fu biesuavga fu kia, Mon sunin ja takes rekfuon iji abe nijaidie na gavno kiain. Fu ijeg kiamga bu abe nijaivga fu kia, Ja vierafega uikinik ga if igi bu isoinva iji fu erafono kiain. Fu ijeg kiamga bu una roin kua, Fu Sisa e Romkobuon e bomana ijefuon uikinik ga if fuon ijino kuain. ");
INSERT INTO nvm_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Bu ijeg kuavga fu kia, Ire iji ja giaga bu Sisan ga iji ni kege una Sisa vajaf. Regavo irerag iji bu Godon ga ni kege una God vajafno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Fu vuak ijeg kuardiamga bu e uruvana ijiebuon nifak ijia una vuak kafokafo ijia biesuakrejga buka jufdiama bu ijia aren. Ijefuon maiji bu vuak iji fu una kuardiainma iji faivga fuka oiserdiama bum ijia isuar karine vuak fuon ijesugin fadain. ");
INSERT INTO nvm_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","28","Areme e Sejusis bu Jesu gakuai ruain. (Revo e ijieb kuai e iji aoivo iji bu una urijo bano kuaiv). Bu roke fu fino ijia usem kua, E nijaidiamon Mosis fu nuvuifuon akai be ijeg isoime abeden. Efarif be fu bara be abega fu am kafo ba tuanaga fu guakma bara iji fu uviaifuon ijar fusik abek. Fu abekin fur uviaifuon iji guainma ijefuon am tuanak. ");
INSERT INTO nvm_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ijegvo e agan seven (7) iji amur ijar bara abe fu am kafo ba tuanai gavo fum guain. ");
INSERT INTO nvm_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","32","Fu guakoga diar fuon ijar fusik bara amun iji abe am kafo fuba tuanain gavo fun madu guakoga diar fuon be ijar fusik madu aben. Bu e agan seven (7) fok buka ijegre vake baren. Regavo bu am kafo ba tuanain revo bum aoim barekoga rad bara iji fu guain. ");
INSERT INTO nvm_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Bu ijegrene agan fok seven (7) bu bara besum ijin aben. Revo a vierafega tavan rad agan fok aoinva bu una urijo ijia bara iji fu erafon barakno kuain? ");
INSERT INTO nvm_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","35","Bu ijeg Jesu kuardavga fu una kia, Iviakma igi barabaru bu bui sanamiv. Regavo rad tavan be abekma ijia e iji God fu kiak jaiji jan aresredo ja mako guf ijia una uri karikno kiakma ijia buba una buon sanamik. ");
INSERT INTO nvm_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ijefuon maiji fun Godri mako guf ijia karauniainma ijefuon bu una uri efuon rene anera igeg buba aoik gavo bum ijia karivak. ");
INSERT INTO nvm_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Regavo igia faif. Fun Mosisri e iji bu aoime una uri karivakfuon ijefuon vuak iji fu kuainma iji fun samakaf nijaidiain. Fun buk kafar be fu tarar iji fu nainma ijefuon vuak iji fu isoime kuainma ijia fu kuai, E Bomana iji fu e Eburam ga Aisek ga Jekaf ijiebuon Godno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Vuak iji fu kuainma ijefuon maiji God fu e aoivo ijiebuon God bakin. Regavo God iji fu e nivek karijo ijiebuon God ijin. Ijefuon maiji Godon nifak ijia e fok bu nivek karijno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jesu fu ijeg kuaimga e roin vuak akai nijaidiavo iji bu uri uruvana igia kume, E nijaidiamon duna buon iji an una amarigia roib kuardiainmano kumen. ");
INSERT INTO nvm_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ijefuon e iji buba una duna kafo Jesu kuain. ");
INSERT INTO nvm_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Areme Jesu fu uri e ijin kia, Ja irerafuon kuai e iji God kuama fu ruainma iji fu Devidon uifarifno kuaiv? Ja ijeg kuaivo ijia ja kuai Jesu fum emano kuaiv. ");
INSERT INTO nvm_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Regavo Devid fun koikfuon buk Sams ijia isoime kuai, God E Bomana ijar uri E Bomana nun kua ani ro imut maink nun igia e bomana rene fi. A ijia fike na e ani on bu ana nigaraivo iji kege kaniame ke diak rotit on ijia uniamne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Areme Jesu fu kia, E iji God kuama fu ruainma iji fu e Devidon uifarif ijia revo Devid fu una e iji fu e Bomanakono kuain. Ijefuon e iji God kuama fu ruainma iji fu izeg una Devidon uifarif rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","Ijegreare e fok bu karine faiko Jesu fu uri e vuak fuon faivo iji kia, E iji bu vuak akai nijaidiaoknum if buon kam ajievo iji mukoi agordiaknum ofno kiain. Fu kia, E iji bu vierafero buka sinuom ma same e fok ijiebuon nifak ijia oga bu giame arordiakuai bu ijeg reoij. Bu ijegrejknum buka arume ar iji e Jius bu afuime vuak kuaivo ijia ga madu ar iji bu iro ijo ijia buka ar maiji kege karijo. ");
INSERT INTO nvm_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Regavo buon bu sirimamejo iji bu kufuimene jaoijor sirimameknum e biesiame kuai bu e mano kuaiv. Bu ijeg kuaimoijknum buka bara amun iji biesiame sinuom buon niesav. Bu ijeg kufuimeoijo ijefuon God fuka bu kam unam ma ise ijia arafiriakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","2","Areme tavan be Jesu fu Godon ar ijia aru fine giako e sinuom zarainva ijieb arume mavua iji bu mon savo ijia mon saknum ijegrej. Fu ijia fine giamo ijia fu gak bara amun be fu mon kavuan ukakna nokarok (2) kege mavua ijia sama fu gain. ");
INSERT INTO nvm_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","Ijefuon fu uri kia, Na ma kuardiav e fok mon iji bu abesvo iji fu bara amun garar asidiain. Ijefuon maiji e roin mon uruvana karevo iji roin bu bui kega bum ukaknak kege vajiev. Regavo bara amun iji fu mon ma ukakbe fu duok kimekafa abedenma iji fun fok abe miainmano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","6","Areme e Jesuon vuak faivo roin bu kari Godon ar iji game kuai, Ar maiguri sainva iji buka mun ka mukor ijesugin kareme sain. Regavo madu ar guf ijia buka ire uruvana kege Godon isuf baroijo kuain. Bu ijeg kuavga Jesu fu uri kia, Ire fok igi ja giavo iji bu rad tavan be ruakma mun igi besum be fuba guri fu namo ijia ijeg nakfuon. Regavo rad bu bujame kozega mun iji bu uduim arikno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Fu ijeg kuardiamga e vuak fuon faivo iji bu uri kuai, E Nijaidiamo a vierafega ire iji fu ivez rekfuon? Regavo a vierafe no anf irerag ijar rega no ijia ga vierafero ire iji fu rekro no ijeg vierafekno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Bu ijeg kuardava Jesu fu una kia, Tavan rad e buka oine biesiakno nika amarigia giaknum of. Ijefuon maiji e uruvana buka if nun ijia usem biesiame kiak, Noiji no e iji fu ruakafa kuainva ijin ijefuon tavan iji fun ruainmano kiaga jab uri jajiak. ");
INSERT INTO nvm_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Regavo madu e roin buka una e roina bijaiknum vo e mamkanuk buon bu samuagdiavo ijiena vuak gigikin kuaimoga jab juk. Regavo igia faif. Tavan ijia ire kafokafo buka rega ja giakfuon. Regavo jab vierafero iji fun tavan radkma iji barno ijinro jab ijeg vierafek iji fui bakin. ");
INSERT INTO nvm_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ja e moik kafokafo ijia karioinva iji buka una bui bijaiga ja faik. ");
INSERT INTO nvm_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Regavo madu moikigi fuka unam ma ise ijia urake vasia kekokega e kafo bu vasia oriaga buka aoik. Regavo madu e uruvana buka adam ise abekfuon. Ijegrekega ire ni kafokafo ka ise ja jukfuon iji bu ijia rekega varur gufia anf mamkanuk roin bu ijia rek. ");
INSERT INTO nvm_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Regavo ire uruvana na kuardiavo iji bu rad rekfuon. Regavo amur e buka e Jiusbuon ar bu afuime vuak kuaivo ijia ja kam arafiriaknum aferdiame dibur uniakfuon. Regavo madu buka ja aferdiame e kin iji ga e mamkanuk ijiebuon vaga bur uri ja kege kam unam gigikin ijia vajai fian vajiakfuon. Ijefuon maiji jaka na ma vierafejo ijefuon bu ijeg rek. ");
INSERT INTO nvm_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Regavo bu unam ijegrejo iji bun ja ar aremdiado ja ijia vuak nun ma iji ijia kuardiakfuon. ");
INSERT INTO nvm_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ijefuon jab uri vuak jon ja izeg una bu kuardiakfuon ijin uruvana vierafek. ");
INSERT INTO nvm_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ijefuon maiji nar oijon ijia ga nigen jon ijia vuak vierafe vajiaga ja e iji bu ja kam vuak gigikin kuardiavo ijiebuon vuak iji karatuame una roin kuardiakfuon. ");
INSERT INTO nvm_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Regavo madu bu asie asoijon ijigam uviaifjon ijigam makifjon ga e jana ai besum karioijo ijieb ja ziegafiak. Bu ijegrene buka ja tomdiame kam e ani iji vajiaga bu kege arafiriaga e roin ja aoikfuon. ");
INSERT INTO nvm_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","19","E fok ja buka kam unam kafokafo ijia ijeg arafiriaknum ziegafiak ijefuon maiji jan una enun rene if nun dab kuaimoijo ijefuon bu ijeg rek. Regavo igia faif. Na e besubesum jaiji naka amarigia samuagdiak. Ijefuon jaka koikjo giriesainki God fu ifejdiame daro miaga ja tavan bog ijia ma karivak. ");
INSERT INTO nvm_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Areme Jesu fu uri kia, Ja tavan iji e bijaivo bu usem mai Jerusarem okurakva ni vierafero Jerusarem bun abe iserekrejoro ja ijeg vierafekfuon. ");
INSERT INTO nvm_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Regavo e iji eraneb ja ar Judia guf ijia karinva iji ni subime va uruor mamkanuk irif ijia sauif. Regavo madu e iji eraneb ja mai guf ijia karijo iji ni subime vaf. Regavo eraneb ja mai iji areme usem makaf ijia vainva iji jab una mai ijia ruak. ");
INSERT INTO nvm_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ijefuon maiji tavan iji ire iji bu ijegrekfuon iji bun buk akaij ijia isoin. Bu isoime kuai, Tavan ijia bu e moikigia oinva iji abevo ire fok moikigia naoivo iji kam vajai fian miakuai kuainva iji fu ijekma aresrek. ");
INSERT INTO nvm_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ijefuon vake tavan ise iji fu moikigia reno ijia bara am fudienva ijiga am iviakma nafenva iji buka afikin abek. Regavo God fu tavan ijia e Jius iji ziegafiakma bu unam ma ise ijia vajai fian abekfuon. ");
INSERT INTO nvm_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Regavo tavan ijia e bijaivo iji bu e roin kaniaga e roin bu aferdiame moik kafokafo ijia dibur uniak. Regavo mai Jerusarem iji bu e Jius bakin ijieb dab isereknum vake rad God fu una kiak tavan jon fun barenmano kiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","26","Jesu fu ijeg kuardiame kia, Bu ijegreke varur gufia anf ka mamkanuk kafo bu veni ga asam ga mujur ijia rega bu giak. Regavo madu moikigia fuka buibur bomana ufike saof fu foine ma iserke ijia e fok buka nonamime ka juk. Ijegrene Godri ire fok varur gufia kege katiga bu uri iji giame kuaik, Ire iji fukafu uniaibe moikigia rekreno kuaik. Regavo ire ijefuon daro ijar bu kekma buka bomana oi bijukuriakfuon. ");
INSERT INTO nvm_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Areme tavan ijia Ema ijiebuon Farif igi na una vana araf ijia daro ga sanaima nun ijekma roga ja giek. ");
INSERT INTO nvm_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ijefuon ja oga ire fok bun anerene rega nin oimaref. Ijefuon maiji e iji fu ja karauniakfuon iji fun samairen. ");
INSERT INTO nvm_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Areme Jesu fu vuak be ijeg bijame kuardiame kia, Ni in makam ga in kafo bu a kanavo iji vierafef. ");
INSERT INTO nvm_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ja oine in iji bu a kanavo ja giame vierafero tavan iji juar mekfuon iji fun samairenmaro ja uri anere juar mej. ");
INSERT INTO nvm_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Unam besum ijeg vo ja oine giaga ire kafokafo bu rega ni vierafero tavan iji God fu efuon ijiebuon oij iji samuagdiakfuon iji fun samairenmaro ni ijeg vierafef. ");
INSERT INTO nvm_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Regavo na igi kuardiako e iji ja iviakma vek karinva iji irerag na kuardiaiva iji fu Jerusarem ijia rega ja game radson aoik. ");
INSERT INTO nvm_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Regavo varur ijiga moikazan igia ire fok God amardiainma iji bu iserme barek gavo vuak nun fuba barek gavo fu tavan bog ijia nakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Jesu fu ijeg kuardiame una kia, Ijefuon nika amarigia joi samuanamikgavo jab uri iro ine do kugi iknum una moik igefuon ire iji uruvana vierafek. Ja ijegrekva moik igefuon ire ijieb ja kam utufutuf miaga ja tavan iji Ema ijiebuon Farif igi na una roko iji ja afurvene samuakva bakin. ");
INSERT INTO nvm_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ijefuon maiji tavan iji na una roko iji fu ire buar iji fu dasuikome fanuf muamafamo ijeg jaba samuainva ijia nam ijia una ruak. ");
INSERT INTO nvm_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ijefuon jab zazaigavo nika amarigia jon samuanamiknum ga tavan bog sirimamef. Ja ijegrejknum karinki Ema ijiebuon Farif igi na una roko ijia ire fok bu rekva ja giriesame uri irekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Areme naki besubesum ijia Jesu fu ro Godon ar bu sirimamejo ijia vuak nijaidiame tavan nakimon iji fu una va uruor Orivs manino ijia naino. ");
INSERT INTO nvm_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ijefuon e uruvana bu tavan bog suok vana ijekma va Godon ar ijia vuak fuon fu nijaidiamon iji faikuai vak. ");
INSERT INTO nvm_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ijegvo e Jiusbuon tavan iji bu iro Fasovano kuavo ijigam bred iriaikin ire ist bakin iji bu ine God izeg fu usuibe saifijaf karauniainma iji vierafejo iji fun samairen. ");
INSERT INTO nvm_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tavan iji fun samairega e mamkanuk Godon isuf baroijo iji abevo e vuak akai nijaidiavo iji bu uri unam izeg bu Jesu kanakfuon iji nisain. Regavo vuak iji buba abe kuaime samafren ijefuon maiji bu e uruvana ijia ruainva iji juin. ");
INSERT INTO nvm_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ijefuon tavan be Setan fu e Jesuon vuak faivo e tuer (12) ijia e Judias Iskariotno kuavo ijefuon oij ijia vuak vierafe mama fu oisema vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ijefuon fun kekome va e mamkanuk Godon isuf baroijo iji abevo e Godon ar juokarijo ijiebuon e mamkanuk ijiena izeg fu Jesu abe miakfuon ijin kuardiain. ");
INSERT INTO nvm_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","6","Judas fu vuak ijin kuardiamga e iji bun oimarme uri kua, A ijegrekma no mon be a makno kuain. Bu Judas ijeg kuardavga fun vuak iji buna kuaim abe maren. Areme fun uri isuar nuriet ijia izeg fu Jesu abe e ani fuon miakfuon ijin e fok sauikuriame reoin. ");
INSERT INTO nvm_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Areme tavan iji bu bred iriaikin ist bakin baroijo fun ruain. Regavo e Jius bu tavan iji bu iro Fasovano kuavo iji ikuai maf-sif uka iji kaniaknum ire kafokafo kanafuin. ");
INSERT INTO nvm_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","9","Ijefuon Jesu fu uri Fita ko Jon vuak nijaidiame kia, Va iro no tavan Fasova ijia ikfuon iji kanafufno kiain. Fu ijeg kiamga bu una Jesu kua, Regavo no izia duok iji kanafukno kuain? ");
INSERT INTO nvm_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Bu ijeg kuavga Jesu fu kia, Igia fai ja mai bomana vien iji bu aru vako ijia ja ebe fu do jia roko iji biekfuon. ");
INSERT INTO nvm_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Regavo ja biekva ni jame ar iji fu aru vako ijia arume e ar koikin iji kua, E Nijaidiamon iji fu kume ar iji na e vuak nun faivo ijiena iro Fasova ikfuon iji nijaiduomne kumenmano kuaf. ");
INSERT INTO nvm_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ja ijeg kuaga fur ar kaf ijia ajie ai guf bomana be bu mukorigia amarenva iji nijaidiaga ni ijia duok uruvana kanafufno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Areme bun va usem vuak irerag fok Jesu fu kuardiainma iji fuka maga bun uri duok uruvana bu tavan Fasova ijia ikfuon iji kanafuin. ");
INSERT INTO nvm_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Areme tavan fun nakisrenma ijia tavan ma iji fun rokga Jesu fu e tuer (12) vuak fuon faivo ijiena va ar guf ijia aru fata irif ijia kari ameoine duok in. ");
INSERT INTO nvm_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","16","Bun duok ikrejo ijia Jesu fu uri kia, Na bomana vierafega naka jana amur iro Fasova igin ine rad naka bomana vajai fian abek. Regavo igia faif. Rad naba una jana duok igavo nason duok fok God fu izeg e moikigia ise reoijo iji karauniakafa vierafenma ijin ka re barekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","Jesu fu ijeg kuardiame uri kafus iji abe Godon sirimane oimaren. Areme fu abe una e vuak fuon faivo iji miaknum kia, Kafus igi abe jon ivajuinamif. Ijefuon maiji naba una ijeg jana do vuain ik. Regavo tavan rad ijia na una moikigia e bomana rene e fok samuagdiavo ijia nason una jana ikno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Areme fun una madu uri bred iji abe Godon sirimane oimaren. Ijegreare fun abe ukaknak tuaseme kege e vuak fuon faivo iji vajiaknum kia, Ire igi fu vajai surif nun igekin na abe ja miav. Ijefuon ni irerag na reoinva iji jak ijegrejknum na vierafefno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Areme fun madu una uri kafus iji abe do vuain abe ijia useme abe miame kia, Vuain igi fu unam iviamkor iji God fu joifuon amardiakfuon ijefuon anf ijin. Ijefuon na guame kavuan nun iji na joifuon use ga ijia ja vierafero nar unam jon amarva ja una Godna besum renro ja ijeg vierafek. ");
INSERT INTO nvm_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ijegvo ni gaf ejon be fata igia nona fino ijar na abe e ani iji miak. ");
INSERT INTO nvm_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Regavo Ema ijiebuon Farif igi na guavo iji fun Godri ijeg vierafenma ijefuon na guak. Regavo e iji fu na abe una e ani miamo iji fuka ma ise rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jesu fu ijeg kuardiamga e vuak fuon faivo iji bu uri bui kuai, E igia no karinva ijia kafu erar Jesu abe una e ani iji miakreno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ijegreare e Jesuon vuak faivo iji bun uri erar fu e bomana rekfuon ijefuon bui duna kuanamin. ");
INSERT INTO nvm_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","26","Bu ijeg kuaivga Jesu fu una kia, E moikigia e mamkanuk rejo iji buka daro abe ebuon ikrejo iji vuak gigikin kuardiaknum samuagdiavo. Regavo na vierafe unam ijeg kegoijo iji fuba jon rekfuon. Regavo erar fu e bomana rekafa vierafekma iji nika una e kabuaikabuaiki rene efuon ijiebuon ikrene. ");
INSERT INTO nvm_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Regavo igia faif. E bu duok ijo iji bu e be fu ari fine samuako e be fu duok kege ro fu fino ijia nadaga fu ino. Regavo iji bu ijegrenva ijia ja vierafega e izar fu e ikin? Na vierafega e iji fata ijia finma ijar. Regavo naiji na e iji fu koikfuon abe e bomana reno na e ijekin bakin. Naiji na e bomana jon gavo na una ja nijaidiaga ja ijia gieme una e ukaknak igegrene una e kafobuo ikrekfuon kiain. ");
INSERT INTO nvm_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Jaiji jan ik izeg na unam gigikin na biediame ruainva ijia jan nana besum afikin ijia aru ruain. ");
INSERT INTO nvm_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ijefuon izeg asoinun fu na imut bijieme kiega na e fok ijiebuon e bomana rene samuagdiavo ijeg na ja oimarme kiavo ni jak ijeg kef. ");
INSERT INTO nvm_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ja ijegrenki ja rad nana ar iji asoinun fu samuamo ijia fata ma iji abe ijia karik. Ja ijia karine duok iknum vo do iknum e mamkanuk rene e Isrerko ijiebuon agan tuer (12) iji samuagdiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Areme Jesu fu uri Saimon kua, Saimon ni igi fai fun Godri Setan kuaido fu e iji ja vuak nun faivo iji jon izeg ja na ma vierafejo iji biesia giaga jan vek na ma vierafega fu iji giak. ");
INSERT INTO nvm_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Regavo Saimon aiji nan oifuon sirimamene God kuardaido fuba arega on a ma vierafeno iji aba arekfuon. Regavo a una oi dakaroime na ma vierafene ar uviaifon fok ifejdiaga bu buon ma vierafejo iji buka darokin rekno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Jesu fu ijeg kuardamga Fita fu una Jesu kua, E Bomana na vierafega nan samuain. Ijefuon e bu a tomda dibur unakva nak na ijia osik vajai fian abevo guakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Fita fu ijeg kuardamga Jesu fu una kua, Vuak igi naka ma kuardav a tavan nokbek (3) bu nuifuon kuakva a kiak na e iji naba gainvano kiake rad kukoro fu kumekno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Areme Jesu fu uri kia, Tavan iji na kiava ja mon ga kamuij ga tamag bakin usem mai besubesum ijia vainva ijia jaba ire kafofuo zazainvano kiain? Fu ijeg kuardiamga bu una kua, Ba ire fok no fun aresreno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesu fu ijeg kuardiame uri kia, Iviakma igi tavan iviamkor. Ijefuon erar fu sinuom ga mon kafo kege okafa vierafeno iji ni kamuij jon kege of. Regavo erar fu kaki baga fu set fuon fu iduaiga fu abesmo ijin abe una ebefuon kimega fu mon maga abe kaki bijaivo iji kime. ");
INSERT INTO nvm_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ijefuon maiji usuibe vuak iji bu buk akaij ijia isoime kuai, E iji bu abe e niesavo ijiena kamakno kuainva iji buka na abe ijegrega fu ijekma aresrekno kiain. Ijefuon maiji vuak irerag bu nuisina isoinva iji na vierafega bu rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Fu ijeg kuardiamga e vuak fuon faivo iji bu kua, E Bomana no kaki nokarok (2) igijarno kuavga fu kia, Vuak iji fun siban jaba una kuaikno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesu fu tavan uruvana vuak nijaidiaoine vo fun uruor Orivs manino ijia vak. Ijefuon fun mai iji areme una ijia vakga e vuak fuon faivo iji bun funa ijia vain. ");
INSERT INTO nvm_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Fu aferdiame buna vake uruor Orivs manino ijia useme fun uri kia, Ni koikjo sirimame God kuardaikin Setan fu oine biesiakma jaba zazaikno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Fu ijeg kuardiame fun ijia uniame bu karikoga fun uri sibank aibe ijia sauime sirimamekafa vain. ");
INSERT INTO nvm_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Jesu fun va kekome God sirimamene kua, Asoinu a vierafega fu markma ni vajai fian igi na abekrejo ijigam na guakrejo iji biju. Regavo baga ni vierafe nun iji arekgavo on a vierafenma ijia rene kuain. ");
INSERT INTO nvm_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Regavo tavan iji fu fine sirimameno ijia anera ijar varur gufia arime Jesu daro main. ");
INSERT INTO nvm_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Regavo kaven fuon fuka vajai afin ijefuon fuka darokma sirimamekoga vakik ijar kavuan igeg vajai fuon ijia arin. ");
INSERT INTO nvm_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","46","Fu sirimamene baremga fu una e vuak fuon faivo iji karinva ijia vaga bun ni naoin ijefuon maiji buka Jesuon oifian bomana abenva ijar buka aimiain. Bu ni naoivga Jesu fu kia, Ja irerafuon ni naoiv? Uri sirimame God kuardaikin Setan fu jon ja ma vierafejo iji biesia giakma jaba zazaikno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesu fu vek manine e vuak fuon faivo iji vuak kuardiamo ijia e azikeoijo iji abevo e uruvana roin bu ijia usen. Bu Judas e Jesuon vuak faimo ijar aferdiame roke ijia useme Judas fun uri Jesu uimin. ");
INSERT INTO nvm_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Regavo Jesu fu uri kua, Judas a Ema ijiebuon Farif igi naiji a ijeg uimimdiega e ani nun bu ijia game na tofdiekuai a ijefuon ijeg kenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Regavo e Jesuon vuak faivo iji bu gak Jesu bun kunaim tokrejga bu uri Jesu kua, E Bomana noba kaki nuvuon igia kege buna bijaikno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Rega e vuak fuon faimo be fu ijia manido fu uri kaki fuon iji kunaim darume dab e be e Godon isuf baroijo ijefuon ikreno ijefuon ada maink iji kana daturain. ");
INSERT INTO nvm_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Fu ijegrega Jesu fu uri kia, Iji fun sibano arefno kiain. Areme fu una e ijefuon ada iji abe una amardamga fun una maren. ");
INSERT INTO nvm_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Areme fu una e Godon isuf baroijo ijiebuon e mamkanuk ijigam e Godon ar juokarijo ijiebuon e mamkanuk ijigam e aiko ijiebuon e mamkanuk iji bu fu tokuai ruainva iji kia, Naiji na e kaniaknum isereoijo bakin. Regavo ja irerafuon jua magu abe na vierafe ruain. ");
INSERT INTO nvm_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Na tavan bog na Godon ar ijia vuak kuardiaknum vuak nijaidiaoin gavo jaba tavan ijia na tofdien. Regavo igi fun Setanri ja samuagdiamo ijefuon ja tavan jon ijia naki na tofdiekuai ruainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Areme bun Jesu tome afem e bomana Godon isuf baroijo ijefuon ar ijia arume vakoga Fita fu aibe gamia giaknum jajiame aru vain. ");
INSERT INTO nvm_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Regavo ar uf ijia bu mian bomana jame ijia iruavo ijefuon Fita fun va ijia buna mian iruame manin. ");
INSERT INTO nvm_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","57","Ijefuon bara be ijia ikreno ijar uri Fita game uruvana igia nikajame kia, E igi na vierafega fu ebe fusik oinon ijino kiain. Fu ijeg kiamga Fita fuka uri feme kia, Bara gare na e iji naba vierafenvano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Fu ijeg kuardiavo fiko ijia e be fu una madu keko game kuai, Na vierafega ak a e be fusik oinon ijino kuain. Rega Fita fu una madu feme kua, Naiji ma bano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Regavo tavan ivuankbe barko ijia ebe fusik madu uri ka darokma kume, E igi fu fusik oinon non game vierafen. Ijefuon maiji Jesu fu ar Gareri ijia ruainma ijefuon e igi fu e ijekono kumen. ");
INSERT INTO nvm_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Rega Fita fuka uri kua, E gari na vuak irerag a kuaimon iji naka ba vierafenvano kuain. Fita fu vek vuak ijeg kuardiako kukoro ijia kumen. ");
INSERT INTO nvm_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","62","Kukoro fu kumeko ijia E Bomana fu dakaroime Fita nikajamga fu ijia una E Bomana vuak iji fu kuardainma iji vierafen. Fu kuardame kua, A e bu nuifuon kuaraga a tavan nokbek (3) feke kukoro fu ijia kumekno kuainma fu ijin vierafen. Ijefuon Fita fuka oifiainma fu kekome makaf ijia ka bomana nirain. ");
INSERT INTO nvm_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Regavo e iji Jesu afem vako iji bu uri fu dab varaimeknum kanaknum ijeg ren. Regavo e iji bu e Jius e mamkanuk ijiebuon ar juokarijo ijieb ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bu Jesu afeme ijegrejknum uri ugon fat ijia abe ni fuon fok okurain. Areme bun uri uikinik ijia kanaknum kua, Ni erar a kanamo iji kurano faivno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bu ijegreknum uri fu arafirime vuak ise kafokafo fuisina kuain. ");
INSERT INTO nvm_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Bu ijegrene vake tavan afaremga e aiko ijiebuon e mamkanuk ijigam e Godon isuf baroijo ijiebuon e mamkanuk ijigam e vuak akai nijaidiavo iji bu besum afuikoga bu Jesu afem ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","68","Bu afem ijia rokga e ijieb uri Jesu kuai, A vierafega an ma e iji God kuama fu moikigia e fok karauniakafa ruainma ijiga ni kuarduo no faivno kuain. Bu ijeg kuavga fu una roin kia, Regavo ja vierafega na keno kiakva ja na jabe ma vierafek. Regavo madu na duna una ja kiakva jabe una roin kuardiek? ");
INSERT INTO nvm_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Regavo ivia tavan igia anerene una gafeg vako ijia Ema ijiebuon Farif igi naiji na God e darokin ijefuon imut maink ijia fikno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jesu fu ijeg kuardiamga e mamkanuk fok bu uri uruvana igia biumame kume, Ijefuon no vierafega akafu a Godon farifno kumen. Bu ijeg kumejga fu kia, Vuak iji ja kie a Godon farifno kievo iji jan ma kuaivno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Fu ijeg kiamga bu uri uruvana igia biumame kume, No vierafega no irerafuon una vuak kafo kuardakva bakin. Ijefuon maiji vuak iji fun koikfuon ir fuon ijia kuaima non fainvano kumen. ");
INSERT INTO nvm_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Areme e Jiusbuon e uguaikin iji bun uri Jesu afem Fairet e iji tavan ijia fu moik buon samuamo ijefuon vain. ");
INSERT INTO nvm_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bun afem va Fairet fino ijia usem uri vuak kafokafo bu kege una fu namdainva ijin Fairet kuardain. Bu kua, E igi no afem ruainva iji fu enuvuon iji aferdiame una unam be ijia nijaidiam. Fu ijegreknum e iji kiam, Jab e bomana Sisa moik Rom samuamo ijefuon takes rekno kiam. Regavo madu fu kume fuiji fu Godri kuama fu E Bomana rene efuon karauniakafa ruainmano kumen. ");
INSERT INTO nvm_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Bu ijeg kumejga Fairet fu vuak iji faime uri Jesu kua, Bu ijeg kuaivo ijefuon a vierafega an ma e Jiusbuon Kin ijino kuain. Fu ijeg kuardamga Jesu fu uri kua, Vuak iji a kuaimon iji an ma kuaimno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Areme Fairet fu uri e Godon isuf baroijo ijiebuon e mamkanuk iji abevo e fok ijia ruainva iji kia, Na e igi na abe vajai fian makfuon iji vuak ise fuon kafo naba fainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Fairet fu ijeg kuardiamga e ijia irenva buka madu una darokma kume, Fuka fur e fok aferdiame kam nijaidiakok buka oi kafokafo vierafeknum ba ma karij. Fur ijegreno ijefuon vuak iji fuka bomana rene ar Judia guf ijia rarem. Ijefuon maiji fun fur Gareri ijia anerene ijegrene roke iviakma fun una igia ruainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Bu ijeg kuardavga Fairet fu uri kia, Regavo ja vierafega e igi fu e Garerikono kiain. ");
INSERT INTO nvm_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Regavo tavan ijia e Erod fu e bomana rene moik Gareri iji samuamo gavo madu fu Jerusarem ijia fino. Ijefuon Fairet fu faik Jesu fu e Garerikoga fu kiama bu afem Erodon vain. ");
INSERT INTO nvm_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Regavo Erod fu Jesu irerag fu reoinon iji fun fain revo fuba bien. Regavo madu fuka tavan jaoijor Jesu uikinik iji gakafak bomana vierafen. Regavo madu fu vierafega Jesu fu fuifuon ire sumakin be rega fu gakafak fu ijeg vierafen. Ijefuon e azi keoijo iji bu Jesu afeme fuon rokga fu Jesu game fuka bomana oimaren. ");
INSERT INTO nvm_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ijefuon Erod fu uri Jesu duna uruvana kuardain gavo Jesu fuba una vef roin kuardain revo fum faime ijia aren. ");
INSERT INTO nvm_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Regavo e iji isuf baroijo ijiebuon e mamkanuk ijigam e vuak akai nijaidiavo iji bu ijia ireme faivo ijefuon bu biom vaknum darodarokin igia Jesu musikuame arafirin. ");
INSERT INTO nvm_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Bu ijegrekoga Erod ga efuon azi keoijo iji bun uri Jesu dab varaimene kijdaknum buka ba fu agoime ma vierafen. Bu ijegrene Erod fum uri efuon azi keoijo ijiena uri ugon ni mukor bu azan savo iji abe abesdame afem una Fairet fino ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Regavo amur Erod fu Fairetk bu oijmanamivo bakin gavo buka zienamiv revo bu tavan ijia e nokarok (2) iji buka Jesu dab kaname una no kaikin ren. ");
INSERT INTO nvm_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Areme Fairet fun e isuf baroijo ijiebuon e mamkanuk ijigam e aiko ijiebuon e mamkanuk ijigam e fok ijia ruainva iji kiava bu besum afuin. ");
INSERT INTO nvm_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Bu besum afuikoga Fairet fu uri e fok kia, E igi ja afem igia usem kie fu e Jius iji aferdiame kam unam ma ijia nijaidiaoino bano kien. Regavo jan ireme kieko na nifak jon ijia duna kafokafo kuardako fun una kuardieko jan faiv. Regavo na vuak ise iji ja fuisina kuardievo iji na nisaimga fu ise kafo ba ren. ");
INSERT INTO nvm_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Regavo Erod fuk fu ire ise kafo fu renma iji fuba fain. Regavo fum kiama ja afem una nuvuon ruain. Regavo igia fai. Fu ire ise kafo renmabatie fu ijefuon guak revo no faiga fu ise kafo fuba ren. ");
INSERT INTO nvm_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ijefuon na enun azi keoijo iji kiaga bu kunaim fijame arega fu vakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Regavo juaivasia besubesum guf ijia iro Fasova bu ijo iji e bu Fairet kuaga fu e dibur karijo ijia e besum buifuo kuaga fu keko vak. ");
INSERT INTO nvm_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ijefuon Fairet fu vierafega fu Jesu kuaga fu keko vakafa vierafen. Ijefuon fu ijeg kuaimga e fok bu kume, No vierafega a e Barabas kua fu keko vagavo Jesu iji kana fu guamne kumen. ");
INSERT INTO nvm_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Regavo e Barabas fu e roin kaniaknum vo e kafobuo oij iji kam karoima bu una e mamkanuk buon ijiena bijaikuai vierafenva ijefuon bu dab dibur unainva fu ijia fin. ");
INSERT INTO nvm_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","21","Regavo Fairet fu vierafe fuka Jesu kuaga fu keko vakafa fu ijeg vierafen. Ijefuon fu una madu kekome e fok ijia irenva ijin vuak iji kuardiamga bu una roin kume, Abe kuros kana abe kuros kanafno kumen. ");
INSERT INTO nvm_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Regavo Fairet fu tavan nokarok (2) vuak iji kuardiamga bu abe damurevga fu ijefuon una madu kia, Regavo ja vierafega fu ire ise iji fu irerag iji ren? Fu ise kafo rebatie na ijefuon kia bu kana fu guak revo na faiga fu ise kafo fu bakin. Ijefuon nam enun azi keoijo iji kiaga bu fijaga na keunaga fu vakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","24","Regavo e fok bu vierafega buka Jesu dab kuros kanakuai vierafen. Ijefuon buka uri uruvana igia kume, No vierafega no Jesu abe kuros kanakno kumen. Ijefuon bu ijeg Fairetna kuaime vake buka bur rarevga Fairet fun una bu kuaivo ijia ifejdiain. ");
INSERT INTO nvm_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ijefuon Fairet fun e iji fu e kaniaknum e roin biesiaga bu Fairet ba igavo iji bu abe dibur unainva iji keunama fu vain. Fu vakga Fairet fu una Jesu abe miamga bu abe buon vierafenva ijia ren. ");
INSERT INTO nvm_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Areme e Romko buon e azi keoijo iji bun uri Jesu afem kuros kanakuai vain. Bun afem unam ijia vako ijia bu e Saimon ar Sairinko iji fu ai be areme una Jerusarem vakafa roko iji bien. Ijefuon e azi keoijo iji bun uri kuriaireme kuava fu Jesu ifejdame kuros abe vain. ");
INSERT INTO nvm_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bu vakga e uruvana bu rad jajiame vain. Regavo madu bara kafo buk bu Jesuon oifian abene niraivknum buna vain. ");
INSERT INTO nvm_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Regavo Jesu fu una dakaroim giame kia, Bara Jerusaremko garie! Ja nuifuon niraivo iji aregavo ni afjon ijiebuon oifian abeknum jon oifian abef. ");
INSERT INTO nvm_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ijefuon maiji tavan iji fu rokdo fu va ijefuon afarekma e bu kiak, Bara iji e amuibitenva ijigam bara iji am nafejo bu arenva ijigam bara iji ba am nafene mut vajiavo iji jaka mukoi kenvano kiak. ");
INSERT INTO nvm_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Regavo madu tavan ijia e bu uri nafar mamkanuk ijigam uruor mamkanuk ijin kiak, Jaka tuame no okuruoga no migegare aoikno kiak. ");
INSERT INTO nvm_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","E bu ire ise ijeg nun rejo iji jaiji rad kafu izeg una jon rekno kiain? ");
INSERT INTO nvm_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Regavo e azi keoijo iji bu tavan besum ijia e niekin nokarok (2) aferdia Jesuna kuros kaniakuai vain. ");
INSERT INTO nvm_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bu vake ar bu kua E Nigen Ano kuavo ijia usem Jesu abe ijia kuros kanain. Areme bun madu e niekin nokarok (2) iji kege be abe imut maink ijia kanaga be bu abe imut aizinan ijia kanain. ");
INSERT INTO nvm_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Bu ijegrekoga Jesu fu una Asoifuon sirimame kua, God Asoinu ise iji bu nun rejo iji giame daze. Ijefuon maiji irerag bu rejo iji buba mukoi vierafenvano kuain. Regavo e azi keoijo iji bu uri ugon Jesu fu samo iji kege name kas abe akoze arega erar ke garo bu iji ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bu ijegrekoga e fok ijia ruainva iji bu ireme giakoga e Jius ijiebuon e mamkanuk iji bu Jesu dab varaimene kuai, Fu e roin bu aoivga fu karauniain. Ijefuon fun ma Godri imut bijame kuama fu ruainvaga ni are fu koikfuon fui kenunanami no gavno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Bu ijegrekoga e azi keoijo iji buk bu madu uri Jesu dab varaimene kijdaknum do vuain ise iji abe maga fu in. Fu iga bu kuai, A vierafega a e Jiusbuon Kin ijiga ni koikon keunanamimne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Regavo bu madu vuak be ijeg isoime nigen azan kuros buin ijia kaname kuai, E igi fu e Jiusbuon Kin ijino kuain. ");
INSERT INTO nvm_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Regavo e niekin nokarok (2) iji bu kege Jesuna kuros kaniainva ijia e be fu uri vuak ise kafo Jesuon kuain. Fu kua, A vierafega an ma e iji God fu imut bijame kuama a ruainmaga ni oi keunanamime no karaunuomne kuain. ");
INSERT INTO nvm_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Regavo e be iji fu uri kaifuon kuriaireme kua, A vuak ijeg a Jesu kuardamo iji are. A God abe jum? No e nokarok (2) igi no besum vajai fian abej revo no bu kege vajai fian muovo iji fun maren. Regavo una e guri fu ise be ba ren gavo fum masok vajai fian aben. No bu kege vajai fian vajuovo ijefuon maiji no nor unam ise iji kegoijo ijefuon bu iji kege vajai fian vajuov. Regavo a irerafuon una vuak ijekin fu kuardamno kuain? ");
INSERT INTO nvm_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","43","Fu ijeg kuardame una dakaroim Jesu kua, Jesu tavan iji a una E Bomana rene moikigia roko ijia ni na vierafene kuain. Fu ijeg kuamga Jesu una roin kua, Ivia aiji an nosik varur gufia vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Areme tavan fun uk manino ijia vana oine ruakoga ar fok fuka tavan naki vake tavan dakaroim gura manin. Fu ijegrekoga ugon iji bu abe Godon ar guf kirakurainva fu tavan ijia dab bujame nokarok (2) ren. ");
INSERT INTO nvm_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Areme Jesu fu kuros kaf ijia uruvana igia kume, God Asoinu kaven nun na imut tat on ijia arenvano kumene fun ijia guain. ");
INSERT INTO nvm_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ijegrekoga e azi keoijo ijiebuon e bomana iji fu uri ire iji renma iji game una God aroime kua, E iji fuka e mano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","49","Areme e fok eraneb ijia ruainva iji bu nifak buon ijia Jesu fu guama bu game buka fuifuon oifian abene niraiknum una ar buon ijia vain. Regavo madu e fok bu ijia afuime ire ijin giakuai vainva iji bu sibank aibe ijia ireme giakoga ire fok bu ijia ren. Regavo bara iji bu Gareri ijia Jesu jame ruainva iji buk bu buna ijia ireme giain. ");
INSERT INTO nvm_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Areme e be if fuon Josof fu ar Arimatia Judia guf ijia ruain. E iji fu e ma gavo fu unam mukoi kegoino. Regavo madu tavan fok fu tavan iji God fu ivez efuon ijiebuon oij iji samuagdakfuon fu ijin gakafa samuaoino ijin. Regavo fu e Jiusbuon e bomana be revo bu Jesu kanakuai kuaimoija fuba ifejdiame vuak kuai vo ire kafo ren. ");
INSERT INTO nvm_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","E ijar Jesuon surif iji kuros ijia jafe arikafa kekome Fairet kuakafa ruain. ");
INSERT INTO nvm_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Areme fun kekome Jesuon surif kuros ijia jafene abe ari ugon ijia anume abe va mako iji bu munuag ijia kajuam amarenva ijia unain. Regavo mako iji bu amur e aoinva kafo buba kege ijia uniain. ");
INSERT INTO nvm_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Regavo tavan iji fu Fraide gavo madu tavan Sabat (Satade) iji bu isuar karine God sirimamekfuon iji fun samairenma ijefuon bu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","56","Regavo bara iji bu ar Gareri ijia Jesu jame Jerusarem vainva iji bu Josofna va mako iji gakoga fu Jesuon vajai surif abe ijia unain. Ijegreare bara iji bun una ar ijia ire udi mukor urino iji kanafu Jesuon vajai surif iji azikuai kuaiknum bun una ar vain. Bun va ire udi mukor urino ijin kanafuin. Regavo afarma fu tavan Sabat (Satade) akai buon bu isuar karine God sirimamejo ijefuon bu akai ijin tuasekuai bu ijia aren. ");
INSERT INTO nvm_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Regavo Sade tavan ik abaisamo ijia bara iji bun una uri inak udi mukor urino bu amardia nainva iji kege Jesuon vajai surif iji azirdakuai bun vain. ");
INSERT INTO nvm_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","3","Bu va mako vien mun iji bu abe bijukuraiva iji gak fun eb abe vaja biom abeden. Ijefuon bum name ijia aruin gavo bu Jesu E Bomana ijefuon vajai surif iji buba gain. ");
INSERT INTO nvm_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ijefuon buka ijia ire bomana nuanamivo ijia migegare anera nokarok (2) ugon ka ma abaikin sainva ijieb bum iji bu irenva samaij ijia iren. ");
INSERT INTO nvm_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Regavo bara iji buka bomana juin gavo bum ijia anera nokarok (2) iji ato same kurituamajain. Regavo anera nokarok (2) iji bu uri kia, Ja irerafuon e iji bu aoinva ijia e iji fu nivek fino iji nisaimoij? ");
INSERT INTO nvm_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","E iji igi fu bakin gavo fun una urin. E iji fu izeg fu una urikfuon iji fun amur jana Gareri fu oinma ijia kuardiain. Fu kia, Ema ijiebuon Farif iji bu abe e ise reoijo iji miaga bu abe kuros kanagavo naki nokbek (3) barga fu una uri fivakno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","9","Rega bara iji bu ijiason vuak irerag Jesu fu amur kuardiainma iji vierafen. Areme bun una va gafia usem vuak irerag bu ijia giaknum fainva iji abe una e Jesuon vuak faivo e ireven (11) iji kuardiaknum efuon roin iji kuardiain. ");
INSERT INTO nvm_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","11","Regavo bara iji vuak ijin abe ruainva iji Meri Megdarin ga Joana ga Meri e Jeimson asie ijigam bara roin ijieb vuak iji abe ruain. Bur ire iji renma ijin game una e Jesuon vuak abe oijo iji kuardiain. Regavo e iji Jesuon vuak abe oijo iji bu vierafero vuak iji bu kufuimene kuaivoro buba ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Regavo Fita fuka migegare uri kukum va Jesu bu abe unainva ijia kekome amainkome gak bu ugon iji bu e aoiga bu anuvo ijieb ijia naoiva fu giain gavo ire kafo bu bakin. Ijefuon fu una vaknum irerag iji renma ijin ka bomana vierafeknum vain. ");
INSERT INTO nvm_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","14","Areme tavan besum ijia e Jesu jaoijo nokarok (2) bu ar be bu kua Emeasno kuavo ijia vakuai vain. Regavo ar iji fu Jerusarem samaij ijia bakin gavo fuka sibank ma aibe ireven (11) kiromitas ijeg. Bu unam ijia vaknum ire iji tavan nokbek (3) guf ijia renma ijin bui kuaiknum vain. ");
INSERT INTO nvm_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","16","Bu kuaime buon duna kuanamiknum vako ijia Jesu fum iji bu vako ijia buna vako bu gain gavo buba mukoi game vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","18","Ijefuon fu uri kia, Ja vuak iji ja kuaiknum ruainva iji ja irerag iji kuaiknum ruainvano kiain. Fu ijeg kiamga bu faime isuarigia oifiaigma iren. Bu ijia irekoga e be Kirofasno kuavo ijar uri kua, Noka bomana oiserduom ijefuon maiji e fok ar Jerusarem ijia karinva iji bu vuak irerag iji renma iji bun faim baren. Regavo aiji a izegrenma ijefuon a vuak iji aba faimano kuain? ");
INSERT INTO nvm_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Bu ijeg kuardavga Jesu fu uri kia, Regavo ire iji irerag ijieb renva ja ijin kuaivno kiain. Fu ijeg kuardiamga bu kua, No ire iji Jesu e Nasaretko fu renma no iji kuaiv. E iji fuka e bomana be fu Godon vuak vierafene kuaimon ijin. E iji fu Godon nifak ijia ga madu e fok ijiebuon nifak ijia fuka daro bomana abene Godon vuak nijaidiaknum ire sumakin mukor roin reoinon. ");
INSERT INTO nvm_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","E iji bu enuvuon Godon isuf baroijo ijiebuon e mamkanuk ijieb kunaim dab e Romko buon e bomana iji mavga fu abe e azi keoijo iji miamga bu abe kuros kanain. ");
INSERT INTO nvm_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Regavo oinuvuon bomana iji no vierafega fun e ijar e Isrerko no karaunuokfuon. Ijegvo madu ire iji fun naki nokbek (3) barenma ijia ren. ");
INSERT INTO nvm_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Regavo madu ivia suok tavan ik irasemo ijia bara kafo nona oijo ijieb mako ijia vainva una kuarduin. Bu ijia vain gavo bu vajai surif fuon iji buba gain. Ijefuon bu una kuarduome kuo bu nimamainva igeg anera kafo giavga bur kuardiame kia, Jesu fuba guain gavo fu vek fino kiain. ");
INSERT INTO nvm_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Regavo madu efarif roin nona oijo buk bu vuak iji fainva ijefuon bu va mako iji gaga fun ma Jesuon surif iji buba gain. ");
INSERT INTO nvm_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Bu vuak ijeg Jesu kuardame barevga Jesu fusik uri kia, E guri ka nigen iserenva gurie. Ja irerafuon e Godon vuak vierafene kuaivo ijiebuon vuak bu usuibe isoinva iji jaba migegare faime ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Igia faif. God fu vierafenma iji Kurais fuiji fu ijeg amur vajai fian abene guame rad fu una varur gufia ajie Godon sanaima ijia fikno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jesu fu ijeg kuardiame uri vuak irerag fok bu fuisina buk akaij ijia isoinva iji kuardiame nijaidiain. Fu amur e Mosison vuak fu isoinma ijia anerene kuardiame dab E Godon vuak vierafene kuaivo kafobuo ijia vain. ");
INSERT INTO nvm_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","29","Bu ijeg kuaiknum vake ar e nokarok (2) bu vako iji fun samairen. Regavo Jesu fu nakek vakvega e nokarok (2) bu kua, No vierafega tavan fun baren ijefuon a nona igia naikno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Areme fun fata azan ijia ari fine buna duok ikafa uri bred iji abe Godon oimaren. Areme fun abe ukaknak tuaseme kege vajiain. ");
INSERT INTO nvm_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Fu vajiama bu bred ijin kege ijga ni buon bu ijia naradiamga bu ijiason Jesu game vierafen. Rega bu uri kua, E igi Jesuno kuaivga fu migegare ni buon ijia bakren. ");
INSERT INTO nvm_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Fu ijegrekoga bu ijiason uri bui kuai, No unam gafi no funa ruainva ijia fu vuak iji bu usuibe buk ijia isoime kuainva iji kuarduoko oinuvuon iji buka mian igeg naimano kuain. ");
INSERT INTO nvm_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","34","Areme tavan ijia bu una uri va Jerusarem ijia e Jesuon vuak faivo ireven (11) bu karinva ijia vain. Bu va biediame buna besum afuime kia, E Bomana iji fun ma una urinmano kiain. Areme bu madu kia, Saimon fun Jesu gainmano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Rega e nokarok (2) iji una Jerusarem vainva iji bu ijia uri e vuak fuon faivo roin ijin vuak irerag bu Emeas vakuai unam ijia vako Jesu fu kuardiainma iji kuardiain. Rega bu madu izeg Jesu fu bred iji abe tuame vajiama bu ine ijia ni naradiama bu Jesu gainva ijin kuardiain. ");
INSERT INTO nvm_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","E nokarok (2) bu vek vuak iji karine kuardiavo ijia E Bomana Jesu fum migegare iji bu karinva ijia manine kia, Makarijo iji fu janano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Rega e iji bu uri fu game ka juin ijefuon maiji bu vierafero fukafu ekavenro bu ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","39","Rega Jesu fu una kia, Ja irerafuon juvknum naba gieme ma vierafej? Na ma Jesu nar. Ijefuon ni imut jon kege imut nun ga diak nun matan igi kuniaime giaf. Ijefuon maiji e aoinva ijiebuon kaven iji bu vajai surif ga an nun igi ja giavo ijekin bano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Fu ijeg kuardiame uri imut fuon ijigam diak tat fuon matan iji kege nijaidiain. ");
INSERT INTO nvm_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Regavo bu vek ba fu ma vierafen. Ijefuon maiji oijbuon iji buka oimaren gavo ka oiserdiain. Ijefuon Jesu fu uri kia, Ja duok ikfuon iji jabe kafo nainvano kiain? ");
INSERT INTO nvm_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Fu ijeg kiamga bu uri kijum be bu baroinva iji abe main. Bu abe mavga fu abe uri nifak buon ijia ina bu gain. ");
INSERT INTO nvm_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ijegreare fu uri e vuak fuon faivo iji kia, Ire fok nan vek iji na jana oinva ijia izeg na guame una urikfuon iji nan kuardiain. Regavo madu irerag fok e Mosison akaij ijia fu nuisina isoinma ijigam e Godon vuak vierafene kuaivo bu isoinva ijigam buk Sams ijia bu isoinva iji fun aresrenmano kiain. ");
INSERT INTO nvm_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","47","Fu ijeg kuardiame uri e vuak fuon faivo ijiebuon nigen bu girenva iji kam una irasdiame daro miain. Fu ijegrenki bu buk akaij ijia vuak fok buka mukoi vierafekuai fu iji ijeg ren. Fu ijegrene uri kia, Fun usuibe buk akaij ijia ijeg isoime kuain. E iji God kuama fu ruainma iji fu guame tavan nokbek (3) barke fu una uri fivakno kuain. Regavo madu buka if fuon ijia vuak iji e bu izeg ise buon iji arega una oi karoiga God fu ise buon iji giame arekfuon ijin dab kuaime vakno kuain. Regavo amur buka Jerusarem ijia anerene kuardiame abe ar iror ijia vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","49","Jesu fu ijeg kuardiame kia, Ja ire fok fu renma iji jan jar giain. Ijefuon ni jar vuak iji abe va e fok kuardiaof. Regavo na vakva nar e iji fu ar nun abekfuon iji Asoinun fu unafdiakno kiainma iji kuaga fu jon ruak. Regavo e iji fu Godon Kaven ma iji ijefuon fur ja kege e darokin rekfuon. Regavo igia faif. Jab migegare Jerusarem areme usem vak revo nin e iji fu varur gufia arime ja daro miakfuon iji samuafno kiain. ");
INSERT INTO nvm_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Areme Jesu fun e vuak fuon faivo iji aferdiame funa usem Jerusarem areme vake Beteni ijia usen. Areme fun imut kaf ijia akorme bu daro miaknum buifuo Godon sirimamen. ");
INSERT INTO nvm_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Fu ijeg manine buifuo sirimameko Asoifuon God fun ijia fu abe una varur ijia ajie vain. ");
INSERT INTO nvm_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","53","Rega e vuak fuon faivo iji bun uri fu dab bomana aroime oimarknum bun una Jerusarem vain. Regavo tavan uruvana bu va Godon ar ijia arume God sirimameknum fuon oimarknum ijeg reoin. ");
INSERT INTO nvm_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ik amur God fu moikigi ba amarenma ijia Vuak Iji fun ijia fusik fine ruain. Regavo Vuak Iji fu Jesur Godk fin ga Jesu fu Godk bu besum. ");
INSERT INTO nvm_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ik amur ijia Jesu fun Godk fin. ");
INSERT INTO nvm_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","God fu Jesuon if ijia ga daro fuon ijia ire fok amardiain. ");
INSERT INTO nvm_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Regavo Jesu fu ma karivako ijin ijefuon fur sanainma ijin abe e fok miain. ");
INSERT INTO nvm_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Jesu fu sanainma iji abe moikigi nakinma ijia rokga e moikigia ise reoijo iji buba abe unain. ");
INSERT INTO nvm_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Ijegreare God fu e Jon kuavo e vuak fuon abe oinon iji kuamga fu sanainma ijefuon vuak iji abe moikigia ruain. Jon fu uri moikigia e fok sanainma ijefuon kuardiamga bu vuak fuon iji mukoi faime ma vierafekro fu ruain. ");
INSERT INTO nvm_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon fu sanainma iji fu bakin gavo fuim e iji sanainma iji ruakreno ijefuon vuak iji abe amur e iji kuardiame ruain. ");
INSERT INTO nvm_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jesu fur fu ma sanainma iji ga fur moikigia e fok sanainma fuon iji abe nijaidiain. ");
INSERT INTO nvm_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Areme Jesu fun ema igegrene moikigia oin. God fu Jesuon azan ijia moikigi amaren. Regavo e fok buba fu mukoi game ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Fu moik fuon ijia rokga efuon iji bu fuba oimarknum afen. ");
INSERT INTO nvm_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Regavo e roin bu fu ma vierafene bu fu oijmame afevga fu daro miamga bu Godon afijaf ren. ");
INSERT INTO nvm_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bu Godon afijaf renva ijefuon maiji Godri Kaven fuon iji kege bu uniafdiain ijefuon bu ema ijiebuon afijaf bakin gavo bu Godon afijaf. ");
INSERT INTO nvm_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Areme Vuak iji fun ema rene tavan ivuankbe nona besum moikigia oin. Fu Asoifuon kaf gufia fino ijefuon Farif besum ijin ga fuon sanainma asoifuon fu abe mainma iji non gain. Jesu fu unam ma ijiga Godon ma ijekma oin. ");
INSERT INTO nvm_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon fu e ijefuon kuaimoin. Fu kume, Na e ijefuon kuardiame kia, E iji fu rad jajie rok ga fur fu ma e ikin fu na asidien. Ijefuon maiji naiji bu rad nafedien gavo fuiji fun usuibe fun Godk ijia fi ruain. ");
INSERT INTO nvm_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Godon maiji zarainma fu kanafu nainma iji fu tavan bog vajuoknum ifejduom. ");
INSERT INTO nvm_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Regavo God fu akai fuon abe Mosis mama fur abe no kuarduin ga Godon oijmiamo ijiga fuon ma iji fun kege Jesu vajama fur kege no vajuin. ");
INSERT INTO nvm_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Regavo God fu erar gainma bakin. Fun Farifuon iji fuk God renma ga fu tavan bog fusik fino ijar Godon vuak iji abe e fok kuardiain. ");
INSERT INTO nvm_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Areme e Jiusbuon e mamkanuk ai Jerusarem karinva bu e Godon isuf baroijo iji abevo e Rivait iji kiavga bu va Jon kua, Aiji a erano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Bu ijeg kuavga Jon fuba vuak kafo kuardiain revo fuka vuak ma ijesugin samakaf kuardiame kia, Naiji na e iji God fu kuamga fu arime e fok igin karauniakro roko iji bano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Fu ijeg kuardiamga e iji bu uri Jon kua, Regavo aiji a era? A e Eraija ki a erano kuain? Bu ijeg kuavga Jon fu una kia, Naiji na e Eraija bano kiain. Fu ijeg kiamga bu una kua, Regavo a e Godon vuak vierafene kuaimon ijino kuain. Bu ijeg kuavga Jon fu una kia, Naiji na e Godon vuak faime vierafene kuaivo iji bano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Fu ijeg kiamga bu una kua, Regavo aiji a era? Regavo if on iji era ga a irerag reoinon iji kuarduoga no una e gafi bu no kuova no ruainva iji kuardiafno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Bu ijeg kuavga Jon fu uri e be usuibe Godon vuak vierafene kuaimon e Asaia ijefuon vuak ijia bijame ijeg kuardiain. Fu kia, Naiji na e be fu ai moikum namo ijia fine kume, E Bomana ijefuon unam iji mukoi arir amarekega fu rokno kumeno ijino kiain. ");
INSERT INTO nvm_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Ijegreare e iji vuak abe oijo iji e Ferisis bu kiavga bu Jon fino ijia ruainva iji bun useme Jon kua, A kume a e iji God fu kuamga fu ruainma iji bakin ga a e Eraija bakin ga madu a e iji Godon vuak vierafene kuaimon iji bano kumen. Regavo a irerafuon e do ruardiamno kuain? ");
INSERT INTO nvm_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Bu ijeg kuavga Jon fu una roin kia, Na ja kege doma ijesugin ruardia gavo e be jaba vierafenva iji fu jana ijia manin. ");
INSERT INTO nvm_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","E iji fu rad jajie rok revo naiji naba aresredo na diak surif fuon fu samo naba kuniairumdakno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Regavo ire fok renma iji fu ai Betenino kuavo do Jodan irif gara tavan ajiemo Jon fu e do ruardiainma ijia ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Areme afarma Jon fu gak Jesu rokga fu game uri kia, Ni gafia gaf! E iji fu nuvuifuon vajai fian abene vajai fuon abe isuf barokfuon iji fu gafa roko gaf. Regavo e iji God fu abe e fok ijiebuon isuf baroga fur e fok moikigia ise reoijo iji karauniakfuon. ");
INSERT INTO nvm_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Na e ijefuon na iji kuardiame kia, E be fu rad jajie rokon kiain. Regavo fuiji fuka ma e ikin gavo naiji na bakin. Ijefuon maiji fuiji fun usuibe Godk ijia fin gavo na bu rad nafedien. ");
INSERT INTO nvm_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Na e iji naba mukoi vierafen. Regavo nam e iji do ruardiaga e fok ai Isrer karinva iji bu fu mukoi vierafekva ijefuon na iji ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Areme Jon fu izeg Godon Kaven fu gainma iji e fok kuardiame kia, Na ga varur gufia Godon Kaven be fu um guaf igeg arime Jesuon nigen ijia finan na gainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Fu ijeg kuardiame kia, Na um iji nan gain gavo naba fu mukoi game vierafen. Regavo fu God e iji na kiema na e do ruardiavo ijar kie, A do ruardiaknum gaga Kaven Akai fu um igeg arime e befuon nigen ijia kunaiga ro e ijar Kaven Akai iji kege ja uniafdidiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Regavo iji fuka ma na ni nun ijia gainva ijefuon e iji fu ma Godon Farifno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","36","Areme afarma Jon fun una Jodan do ijia e vuak fuon faivo nokarok (2) na ijia oinon ijia fu gak Jesu ni fuon ijia ruvaka fu gain. Fu game uri e nokarok (2) iji kia, E iji God fu abe nuvuifuon isuf barokfuon iji gafijarno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Fu ijeg kiamga e Jonon vuak faivo nokarok (2) iji bu vuak iji faime bun Jesu fu vako ijia jame vain. ");
INSERT INTO nvm_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Bu ja vakga Jesu fu giame una dakaroime kia, Ja irerag abekuai rokno kiain. Fu ijeg kiamga bu kua, Rabai a izia fine ruainmano kuain? (Revo vuak Rabai ijefuon anej ma iji e nijaidiamon). ");
INSERT INTO nvm_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Bu ijeg kuavga Jesu fu una kia, Ni ro gafno kiain. Regavo tavan iji fu ve nakisrenma ijefuon e nokarok (2) iji bun Jesuna vake ar fu fino ijia usem game funa ijia karine ve nakin. ");
INSERT INTO nvm_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Regavo e nokarok (2) iji bu Jonon vuak iji faime uri Jesu ja vainva ijia e be if fuon iji Edru e Saimon Fitaon uviaij ijin. ");
INSERT INTO nvm_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Areme e Edru fun migegare va uviaifuon Saimon Fita bieme kua, Uviainu no e iji fu no karaunuokfuon e Kurais e iji God fu visu kuinma iji non bienvano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Areme Edru fun Saimon afeme Jesu fino ijia ruain. Bu ijia rokga Jesu fu uri Saimon nikajame kua, E gari a Saimon e Jonon farif. Regavo aiji rad bu Kifasno kuakno kuain. (Revo if Kifas ko Fita ijefuon ma iji Mun Ikin. Ijefuon maiji rad fuon ma vierafeno iji fuka gigikin rega e fok Jesu ma vierafejo iji fur kudiej igeg biukudiak). ");
INSERT INTO nvm_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Areme afarma Jesu fun ai Gareri ijia vakro vierafeoino ijia fu e Firif nisaime kua ni na jajiemne kuain. ");
INSERT INTO nvm_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Regavo Firif fu ai Betsaidano kuavo ijia ruain. Regavo Saimon ko Edru bu madu bu ar ijekor. ");
INSERT INTO nvm_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Regavo Firif fun madu e Natanior nisaime kua, No e iji usuibe Mosis ga e iji Godon vuak vierafene kuaivo iji bu buk akaij ijia isoime kuai fu ruakno kuainva iji non bien. Regavo e iji Jesu fu Josofon farif ga fu ai Nasaretkor. ");
INSERT INTO nvm_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Fu ijeg kuardamga Natanior fu una e Firif kua, Ar ukak Nasaret aikin iji fun irerag ma be fu ijia rekma iji fuka ma bano kuain. Fu ijeg kuamga Firif fu kua, Anim nosik va gafia keko koikon gamne kuain. ");
INSERT INTO nvm_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Areme Jesu fu gak Natanior fu samaij ijia vakga fu uri kua, E gari fu ma e Isrerko buon uifarif revo fu e ir kufuikin bano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Rega Natanior fu uri Jesu kua, A izeg unam nun na kuaim kegoijo iji gieme vierafenmano kuain. Fu ijeg kuamga Jesu fu una roin kua, Firif fu rad kuamga a uri fu ja ruain revo naiji na amur gafi in anej a finma ijia na on izeg a vierafenma ga a e izekin iji nan gainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Fu ijeg kuardamga Natanior fu uri kua, E vuak nijaidiamon aiji a Godon Farif ga madu a e Isrerkobuon E Bomanano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Fu ijeg kuardamga Jesu fu una kua, A na ma vierafenma ijefuon maiji na a kua a vek gafi in anej ijia fino ijia na ga vierafenvano kuainva ijefuon a na ma vierafen. Regavo ire igi na iviakma kuardavo ijesugin bakin gavo rad na ire sumakin uruvana rega a giakno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Areme Jesu fun dakaroime kia, Vuak igi naka ma kuardiavno faif rad ja kaf gufi asoinun fu fino ijefuon vien fu dajaga anera fuon bu ijia ajie fuon vaknum una arime Godon Farif igi nun roga ja giak. ");
INSERT INTO nvm_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Naki nokarok (2) barko bu ai Keina Gareri guf ijia sanamikuai iro bomana be ijga Jesuon asiej iji fu ijia vain. Regavo Jesu ga e vuak fuon faivo iji bu madu bu iro iji sarekuai kiavga bun ijia vain. ");
INSERT INTO nvm_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","E uruvana bun iro iji iknum do be bu kua vuain no kuavo iji iknum ijegre vake vuain iji fun barekoga Jesuon asiej iji fun uri Jesu kua, E iji bu do vuain iji bun i barenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Fu ijeg kuamga Jesu fu uri kua, Asienu a irerafuon na nijaidie ga kuardiem? Ire fok nan vierafen ga tavan nun na anerene ik nun rekfuon iji fuba ruainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Fu ijeg kuardamga Jesuon asiej iji fun una e iji ire karme e fok vajiaoijo iji kia, Jesu fu irerag kuardiaga ni ire iji fu kuardiamo iji mukoi faime refno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Regavo ar iji bu karine duok ijo samaij ijia bu saror mamkanuk imut roin ga nikit (6) besum ijeg bu kege ijia nain. E Jius bu akai buon bu nainva ijia bu vierafe bu imut do sokva God fu oimaik. Ijefuon bu saror iji kege ar ijia nain. Saror iji buka mamkanuk ijefuon bu do uruvana jiaga buka irtoijev. ");
INSERT INTO nvm_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesu fun e iji bu duok nifie e iji vajiaoijo iji kiamga bu rokga fu kia, Ni saror igi karme do jiafno kiain. Fu ijeg kiamga bun saror fok karme do jiava buka irtoije baren. ");
INSERT INTO nvm_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Areme fun una kia, Nin do iji kafo jiame va e gafi iro igi inma iji samuamo iji vajafno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","Fu ijeg kiamga bu do iji kafo veseme va e iro iji samuamo iji vajava fu kege ine faik do iji fun ma vuain. E iji iro samuamo iji fu vuain iji bu izia kege ruainva iji fuba giain. Regavo bun e iji do iji veseme vainva ijieb vuain iji fu izia ruainma iji bur mukoi vierafen. Areme e iro iji samuamo iji fun e iji sanamivo iji abevo e fok kiamga bu isuar kariko fun uri Jesu kua, No unam nuvuon no rejo iji fu be. No amur no do vuain ma ijar ijknum e fok vajiame rad noson vuain ise iji ijo. Regavo aiji a vuain ma iji a abe abede fine radkma ijia abe e fok no vajuinmano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Rega Jesu fu amur anerene darokma ire sumakin fu kege e fok nijaidiainma iji fu ai Keinan Gareri guf ijia ijeg ren. Ar ijia fu fuon sanainma iji abe e fok nijaidiamga e vuak fuon faivo fok bu ijia game fu ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Bu ijegrene Jesu ga asiefuon ijigam uviaifijaf ijigam e vuak fuon faivo iji bun uri vake ai Kafoniam ijia useme naki sibank ijia karin. ");
INSERT INTO nvm_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Areme e Jiusbuon tavan iji bu kua Fasovano kuavo bu iro ine una saifijaf iji bu ai Ijift ijia vajai fian abeknum e ijiebuon ikreoija God fu karauniainma iji vierafejo iji fun samairen. Ijefuon Jesu fun Jerusarem aji vain. ");
INSERT INTO nvm_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Fu va Jerusarem kekome Godon ar ijia arume gak e uruvana bu ijia arume maf-kau ga maf-sif ga um iji kege isufuon una e kafobuon kimej. Regavo fu giak e roin bu fata ijia karine mon dame vajuonamiv. ");
INSERT INTO nvm_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Fu giame uri ire be isua igekin ka gigikin iji abe dab fanuf fok bu kege ijia aru karine kimejo iji fijiama bu usem subin. Bu usem subi vakga fu uri e ijiebuon fata iji bu karine mon dame vajuonamivo iji kam karoime mon buon kam uduim kozen. ");
INSERT INTO nvm_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Areme fu uri e iji karine um kimejo iji kia, Um jon iji kare usem vaf. Ja erar kiaga ja Asoinun ijefuon ar igi abe maket akar igeg amarvno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jesu fu ijegrega e vuak fuon faivo iji bu migegare Godon vuak iji bu usuibe buk akaij ijia bu isoinva iji vierafen. Regavo vuak iji fu ijeg kuai, O God ar on ijia bu vuak ma iji kuaiknum sirimamejor iji oinun fuka mian igeg naino kuain. ");
INSERT INTO nvm_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jesu fu ijegrega e Jiusbuon e mamkanuk iji bu migegare una duna be kua, Ni ire sumakin be rega no ijia game vierafero a daro namo ijefuon a ivia no kuriairega no usem vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Bu ijeg kuavga Jesu fu una kia, Ja Godon ar bomana igi bujakorekva na naki nokbek (3) guf ijia na una sa barekno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Fu ijeg kuardiamga bu una kua, Ar igi no juaivasia uruvana foti siks (46) ijeg akozme ar iji sa baren revo a izeg naki nokbek (3) ijia una sakno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Rega Jesu fu Godon ar ijefuon kuainma bakin revo fu vajai fuon ijefuon bijame kuaima e Jius iji buba fain. ");
INSERT INTO nvm_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Regavo rad Jesu fu guame naki nokbek (3) barga fu uriga e vuak fuon faivo iji bu vuak fuon iji fu Godon ar ijia bija kuainma iji vierafen. Areme bu ijia una Jesuon vuak fu kuainma ijiga Godon buk akaij iji ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesu fu Jerusarem ijia tavan bu kua Fasovano kuavo ijia iro iji bu ijo ijia fu fiknum ire sumakin uruvana reoga e fok bu iji giame bu fu ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Regavo Jesu fu e uruvana ijiebuon oij iji fun giain ijefuon fu erar una ema ijiebuon unam bu kegoijo ijin Jesu nijaikma bakin. Rega fun oibuon giainma ijefuon fuba bu ma vierafene fuon ma iji abe samafrediama bu gain. ");
INSERT INTO nvm_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","E Ferisi be if fuon iji Nikodimas revo fu e Jiusbuon e bomana be ijar naki be naki ijia vake Jesu fino ijia kekome kua, E Nijaidiamon no vierafega Godri a kuamga a e fok no nijaiduokro ruain. Fu erar ire sumakin darokma fok a reoino ijekin rekma bakin gavo fun e iji tavan bog Godk oinon ijar ire sumakin igi a reoinon ijekin kafokafo rek. ");
INSERT INTO nvm_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Fu ijeg kuamga Jesu fu una kua, Vuak igi na ma kuardavo fai erar fu vierafega fu e iji God fu oibuon iji samuagdiamo ijiena mazikma iji fuka God kuaga fu Kaven Akai abe unafdak. Kaven Akai iji fu oifuon ijia fine daro maga fu am ukak igeg nafene una unam iviamkor ijia amarigia kege vakfuon. ");
INSERT INTO nvm_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Fu ijeg kuardamga Nikodimas fu vuak iji fuba mukoi faime vierafenma ijefuon fu una Jesu kua, E iji bun e mamkanuk renva iji bu izeg una am ukakna rene asiefijaf defok ijia arime bu una nafediakno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Fu ijeg kuardamga Jesu fu una kua, Vuak igi na ma kuardav. Erar fu vierafe fu e iji God fu oibuon iji samuagdiamo ijiena mazikma e iji fuka God kuaga fu daro fuon ijia do ijiga Godon Kaven ijefuon azan ijia oifuon iji somdaga fu una e iviamkor rek. ");
INSERT INTO nvm_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Regavo am iviamkor iji bu ema ijieb nafejo revo kaven iviamkor iji fu Godri koikfuon abe e iji unafdiak. ");
INSERT INTO nvm_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ijegvo e fok bu una am ukakna igeg nafekfuon iji na kuardainva ijefuon ab vuak iji faime oiserdak. ");
INSERT INTO nvm_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Regavo ni igia fai buibur iji fu ufime roko ijigam fu ufime vako iji no gavo bakin ga nom vua fuon ijesugin faiv. Buibur iji fu ufimo ijeg Godon Kaven iji fu e besubesum ijiebuon oij ijia ikreno iji no izeg gakva bakin. ");
INSERT INTO nvm_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Jesu fu ijeg kuardamga Nikodimas fu vuak iji fuba mukoi faime vierafen ijefuon fu una madu Jesu kua, Vuak igi a kuardiemo iji na izeg vierafek? ");
INSERT INTO nvm_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Fu ijeg kuardamga Jesu fu kua, Aiji aka e Isrerkobuon e vuak nijaidiamon e bomana be revo a vuak igi na kuardavo iji aba mukoi faim. ");
INSERT INTO nvm_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Vuak fok no kuaimoijo iji noka kufuimejo bakin no irerag no vierafenva ijiga giaoinva no iji abe ja kuardiav. Regavo ja vek vuak nuvuon jaba mukoi faime reoij. ");
INSERT INTO nvm_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Regavo iviakma na moik igefuon vuak iji abe kuardaga aka ba ma vierafen ijefuon na varur gufefuon vuak iji ja kuardiakva jaka ba una ma vierafek. ");
INSERT INTO nvm_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Regavo fu erar varur gufia ajie vainma bakin revo fun Ema buon Farif iji God fu kuamga fu ari ruainma e ijar una varur gufia ajie vain. ");
INSERT INTO nvm_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Regavo Mosis fu ai moikum namo ijia ire be bu abe tabar igeg amarme abe kaf ijia ajie kiraga e adagin bu iji gavo ijia bu madiain. Ijegvo Ema buon Farif igi nak madu bu abe kuros kaf ijia kaniega na guak. ");
INSERT INTO nvm_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ijefuon erar fu kuros kaf ijia na guavo iji gieme ma vierafekma fu unam ma karivako iji abek. ");
INSERT INTO nvm_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","God fu e fok moikigia oijo iji oijmiainma ijefuon fu Farifuon besum iji kuamga fu ari ruain. Ijefuon erar fu Farifuon iji ma vierafekma e iji fuba guak gavo fum tavan bog unam ma karivako iji abe ijia fivak. ");
INSERT INTO nvm_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God fu Farifuon iji kuamga fu e fok moikigia ise reoijo ijiebuon ise iji kege mazim giakafa ruainma bakin gavo fum bu karauniakafa ruain. ");
INSERT INTO nvm_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Regavo erar fu Godon Farif iji ma vierafekma God fuba rad ise fuon fu renma iji giame duna kafo kuak. Regavo erar fu Godon Farif iji ba ma vierafenma iji God fun ise fuon giame vierafedo rad fu duna kafo kuak. Ijefuon maiji fu Godon Farif besum iji fuba ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Regavo Godon sanainma iji fun moikigia e fok ise reoijo ijiebuon ise iji kege mazim giakafa ruain. Regavo e fok bu sanainma iji areme una unam nakinma iji oijmainva ijefuon e fok bu ire ise fok reoin. ");
INSERT INTO nvm_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Regavo erar fu ise reoinon iji fu sanainma iji fu ma uzam. Ijefuon fuba una sanainma ijia ruak. Ijefuon maiji fun ise fok reoido fu una sanainma ijia ruakrega ise fuon fu samafrekro fuka mukoi jum. ");
INSERT INTO nvm_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Regavo erar fu unam ma ijesugin reoinon iji fu una sanainma ijia ruakro fuba juk. Ijefuon maiji ire fok fu reoinon iji fu God fu oimaikfuon ijia reoin. ");
INSERT INTO nvm_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jesu fu ijeg kuardiame fun e vuak fuon faivo ijiena e Judiakobuon ar ijia vain. Fu va ijia tavan sibank ai Judia ijia e ijiena fiknum bu aferdia do ruardiain. ");
INSERT INTO nvm_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Regavo tavan besum ijia e Jon fuk fu ai be bu kua Ainon kuavo Sairim samaij ijia fin. Fu ijia fiko e fok bu ijia vako fu aferdiame do ruardiam. Ijefuon maiji ar Ainon ijia fuka do uruvana ijia ruvako ijefuon fu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Regavo Jon iji fu reoinma iji buba abe dibur unainva ijia fu ijeg reoin. ");
INSERT INTO nvm_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ijegrekoga e Jonon vuak faivo roin bu e Jius be ijiena unam izeg bu e Jiusbuon unam ijia e kege do ruardiavo ijefuon dab bui kuaime sigunamin. ");
INSERT INTO nvm_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bu dab kuaime siguba areme va usem Jon kua, E nijaidiamon a e be fu osik do Jodan garainak ijia oinma iji abe vierafen? E iji a fuisina kuarduinma iji fu iviakma e uruvana do ruardiaga e fok bun una fuon vak. ");
INSERT INTO nvm_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Bu ijeg kuardavga Jon fu una kia, Fu erar daro fuon ijia ire ijekin kafo reokma bakin gavo fun Godri kuakma fu moikigia ire ijekin iji reok. ");
INSERT INTO nvm_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Regavo jan koikjo nana oknum faikoga na kuai, Naiji e iji God fu kuamga fu moikigia ari ruainma iji bano kuain. Regavo naiji na ur unam fuon amarme moikigia ruain gavo fu rad jajie rokno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","30","Regavo ni faif e be fu farifuon ijar bara abekro fuifuon unam amaren gavo fu faifai farifuon fun bara abenma fai fuka bomana oimarek. Unam besum ijeg ga naiji na e iji fu ruakreno ijefuon unam iji amare ruain. Regavo iviakma na fai e iji fun ruain ijefuon naka bomana oimadien. Ijefuon maiji fur fu e ikin reke ga naiji na e ukakbe rek. ");
INSERT INTO nvm_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","E iji fu kaf gufia ari ruainma iji fuka e bomana revo ire fok fur asidiain revo fur ire fok samuagdiamon. Regavo e iji bu moikigia nafenva iji fu e moik igekor ijefuon vuak fuon fok fu kuaimoino iji fu moik igefuon kuaimoin. ");
INSERT INTO nvm_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Regavo e iji kaf gufia ari ruainma iji fu vuak fok fu fainma ijiga ire fok fu giainma iji abe e moikigia karinva iji kuardiain. Regavo e iji bu vuak fuon buba mukoi faime igav. ");
INSERT INTO nvm_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Regavo erar fu vuak fuon iji mukoi fainma iji fu ma vierafero God fu maro fu ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Regavo e iji God fu kuamga fu ari ruainma iji fu vuak God fu kuardainma ijesugin abe e fok kuardiam. Ijefuon maiji Godri Kaven fuon darokin iji fu daknum vajamo bakin. ");
INSERT INTO nvm_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Regavo God Asoij iji fu Farifuon mukoi oijmamo ijefuon ire fok fu Farifuon iji kuaga fu samuagdiam. ");
INSERT INTO nvm_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Regavo erar fu Farifuon iji ma vierafekma e iji fu unam ma karivako iji abek. Regavo erar fu Farifuon ijefuon vuak iji ba mukoi faime igakma e iji fu unam ma karivako iji fuba abekfuon. Regavo Godon ziemo iji fuka tavan bog fusik navak. ");
INSERT INTO nvm_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","E Ferisis iji bu faik e uruvana buka una Jesuon vuak faivknum una fuon vakok fu aferdiame do ruardiako Jon bu arevo bu iji fain. ");
INSERT INTO nvm_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Regavo Jesu fu koikfuon ba e iji kege do ruardian revo bu e vuak fuon faivo ijieb e iji aferdia do ruardiav. ");
INSERT INTO nvm_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jesu fu faik e Ferisis iji bu vuak iji abe kuaimoijga fun ai Judia areme una madu uri Gareri ijia vain. ");
INSERT INTO nvm_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Regavo Jesu fu ai Gareri fu vainma iji ur fu ai Sameria ijia kekomevo ijar Gareri vakro ijeg vierafene vain. ");
INSERT INTO nvm_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ijefuon Jesu fu roke ai be Sameria guf iji bu kua Saikano kuavo ijia kekoin. Regavo ai Saika fu moik ivuankbe Jekaf fu abe farif fuon Josof mainma iji samaij ijia. ");
INSERT INTO nvm_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Regavo ai Saika ijia Jekafon do be fu moik guf ijia nafuinma bu jiavo iji fu ijia. Ijefuon Jesu fu unam jiamana roke tavan uk manino ijia fu aimamga fu do iji irif ijia fin. ");
INSERT INTO nvm_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Jesu fu do irif ijia figa bara Sameriako be fu do jiakafa rokga fu uri bara iji kua, Do be jia mie na ijno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Regavo e Jesuon vuak faivo fok bun ar ijia duok ikfuon iji kimekuai vakoga fu fuonkua ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jesu fu bara iji dofuo kuamga bara iji fu una kua, Aiji a e Jius ga naiji na bara Sameriako ijefuon a irerafuon na dofuo kiemno kuain. (Bara iji fu Jesu ijeg kuainma ijefuon maiji e Jius buba e Sameriakona besum afuime karioijo). ");
INSERT INTO nvm_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ijefuon Jesu fu una kua, A irerag God fu vajamo ijiga e igi erar igia fine a dofuo kuamo iji mukoi vierafebatie a fu kuaga fur do ma iji jiame a mak. Ijefuon maiji fur do iji bu ine tavan bog ijia ma karivako iji abe una a mak. ");
INSERT INTO nvm_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Jesu fu ijeg kuardamga bara iji fu una kua, E Bomana do igi nafuinma iji fuka mako dibuor gamia revo a baket bakin. Ijefuon a izer do iji bu ine ijia ma karivako iji jiak. ");
INSERT INTO nvm_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Regavo no sainuvuon Jekaf fu mako igi rume arema do iji fu ijia nafuimga afijaf iji abevo fanuf fuon fok bu do ijia iknum oin. Regavo aiji a vierafero ar e bomana ga Jekaf fu e ukakbero a ijeg vierafene kuaim. ");
INSERT INTO nvm_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","14","Bara iji fu ijeg kuardamga Jesu fu una roin kua, Erar do mako igia nafuinma igi jia ikma fuka rad una do kafak. Regavo erar fu do igi nar jia mavo iji abe ikma rad fuba una do kafak. Ijefuon maiji do iji nar jia miainva iji fu tavan bog oijon guf ijia navak revo do ijar ja ifejdiaga ja unam ma karivako iji abek. ");
INSERT INTO nvm_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Jesu fu ijeg kuardamga bara iji fu una kua, E Bomana ni do iji a kuaimon iji iviakma jia miega na abe ij. Naka tavan bog mako igia do jiakok fuka isediem ijefuon ni do iji a kuaimon iji jia miega na inkin rad naba una do kafiekno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Fu ijeg kuamga Jesu fu kua, Ni una va baru on iji afeme una igi na fijo igia rokne kuain. ");
INSERT INTO nvm_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Rega bara iji fu una kua, Naiji na baru bano kuain. Rega Jesu fu una kua, A kie a baru kafo bano kienma iji aka ma kuardiem. ");
INSERT INTO nvm_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Regavo a amur baru imut roin (5) ren gavo iviakma baru iji a fusik fino iji fu ma baru on bakin. Regavo iviakma na kuavga a kie a baru bano kienma iji an ma kuardienmano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jesu fu ijeg kuardamga bara iji fu kua, E Bomana na gaga aiji a e iji Godon vuak vierafene kuaimon ijin. ");
INSERT INTO nvm_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Regavo e Sameriako saifnuvuon bu usuibe uruor igia ajieme Godon sirimameknum dua urukafame aroivo. Regavo ja e Jius iji ja kuai Godon ar no sirimameknum aroikfuon iji fu Jerusarem ijiano kuaiv. ");
INSERT INTO nvm_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Fu ijeg kuamga Jesu fu una kua, Ni vuak igi na kuardavo igi ma vierafe tavan abekma noba una uruor igia ga ai Jerusarem ijia karine Godon sirimameknum fu aroik. ");
INSERT INTO nvm_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Regavo ja e Sameriako iji ja erafon sirimamejo iji jaba mukoi vierafeknum sirimamej. Regavo e Jius noiji no erafon sirimameknum aroivo iji non mukoi vierafen. Ijefuon maiji God fu e fok karauniakfuon iji fu e Jius ijia kuamga fu ari ruain. ");
INSERT INTO nvm_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Regavo e iji bu kaven ma vierafeknum Godon sirimameknum fu aroikva ijefuon tavan iji fu vek gavo na ma kuardav ire iji bun iviakma igijar rej. Ijefuon God fu e ijeg sirimamejo fu iji vierafeknum nisaidiam. ");
INSERT INTO nvm_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Regavo God fu e Kaven ijefuon erar fu Godon sirimamekma fuka kaven fuon ijekma oi ma vierafeknum sirimamek. ");
INSERT INTO nvm_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jesu fu ijeg kuardamga bara iji fu una kua, Na e iji fu e fok karauniakfuon God fu kuaga fu ari ruakfuon if fuon Kurais iji nan vierafen. Ijefuodo fu rad ruakma fur ire fok amarigia kuarduok. ");
INSERT INTO nvm_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Fu ijeg kuardamga Jesu fu una kua, E iji God fu kuaga fu ruakfuon iji nan iga ruainva iviakma nar igi osik manine vuak kuaivno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Bu ijeg kuaivo ijia e Jesuon vuak faivo iji bu vainva iji bun una ijia usen. Bu usem gak Jesu fu bara ijek vua kuaimga buka oiserdiain. Buka oiserdiain gavo buba una bara iji kua, A irerag abekro vierafen? Regavo madu buba una Jesu kua, A irerafuon bara ijek vuak kuaimno kuain? Buka rubdiamga bu ijia irem giain. ");
INSERT INTO nvm_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Bu irekoga bara iji fun do iji fu jiainma iji dab ijia abedeme una va ar ijia e fok kia, E be fu ire fok na nuriet reoinva iji fuka visu kuardiema na fain. Ijefuon na vierafe e iji fu kafu Kurais Godri kuamga fu ari ruainma ijino rua no gak vakno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bara iji fu ijeg kuardiamga e fok bun ar iji areme una Jesu fino ijia fu gak vain. ");
INSERT INTO nvm_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ijegrekoga e Jesuon vuak faivo iji bun uri Jesu soisoime kua, E vuak nijaidiamon duok kafo ine kuain. ");
INSERT INTO nvm_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Bu ijeg kuavga fu una kia, Duok nun iji na ine daro abe oijo iji jaba mukoi vierafenvano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Fu ijeg kuardiamga e vuak fuon faivo iji bu isuar una bui kuai, E iji fu kafu e kafob duok kege ro vajainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Bu una bui ijeg kuaivga Jesu fun giame una kia, Na ire iji na bijame kuardiavo iji na Asoinun ire iji fu vierafenma iji igame vo ik fuon iji fu na kuardiema na ruainva iji ka re barek. ");
INSERT INTO nvm_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Fu ijeg kuardiame uri vuak be ijeg bijame kuardiain. Ja kuai no asam nokarok ga nokarok (4) barekma no juar masikno kuaiv. Regavo ni juar garia giaf ire fok buka du barme masikfuon samuain. ");
INSERT INTO nvm_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ijefuon e iji fu juar masime kanafu ai mukor ijia naga bu tavan bog ijia naoimvakfuon iji fun Godri kimen. Ijefuon vo e iji uij dajaimo ijiga e uij kanafumo iji bu gia e uruvana bu una oi karoime una unam ma karivako iji kegoi bu giakva buka oimarek. ");
INSERT INTO nvm_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Regavo vuak iji bu kuaivo iji fuka ma e be fu uij dajaiko be fu masim. ");
INSERT INTO nvm_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Na ja kiavno nin va juar iji jaba menva ijia ire duinva iji masif. Regavo juar iji bu e roinb menva iji ja ijia ire ma iji duinva ijin masime karfno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Areme e Sameriako iji ar ijia karinva roin bu una Jesu ma vierafen. Ijefuon maiji bara iji fu kia, Fu ire fok na nuriet reoinva iji kuardienmano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ijefuon e Sameriako bu usem soisoime kua, Nika nona igia fine kuavga fu naki nokarok (2) una ijia buna fin. ");
INSERT INTO nvm_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Fu buna ijia fiknum vuak nijaidiamga e uruvana buka tavan ijia una fu ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Areme bu una usem bara iji kua, No ivia noka fu ma vierafen ijefuon maiji non koiknuvuon vuak fuon ma iji fu kuarduomo non fain. Regavo no vuak a kuarduinma ijefuon no iji fu ma vierafejo bakin. Gavo fuiji fu ma e moikigia oijo iji karauniakfuon ijin. ");
INSERT INTO nvm_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jesu fu naki nokarok (2) barekoga fun una madu uri gafia Gareri ajie vain. ");
INSERT INTO nvm_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Regavo Jesu fu koikfuon e vuak fuon faivo kuardiame kia, E iji Godon vuak vierafene kuaimon iji e aiko fuon iji buba fu akaime vuak fuon amarigia faime igakno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Regavo tavan ijia fu vake Gareri kekomga e iji karinva iji buka fu oimardame afen. Bu oimardainva ijefuon maiji bu Jerusarem ijia tavan Fasova iro iji iknum oimarkuai vainva ijia bu fu gain. Bu koikbuon ni buon ijia ire sumakin kafokafo fu rena bu giain ijefuon bu fu afen. ");
INSERT INTO nvm_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ijefuon Jesu fun tavan be una madu vake ai Keinan moik Gareri guf ijia kekoin. (Revo ar iji fu ur ijia do iji abe una do vuain bu ijo iji amarenma ijin). Regavo ai Kafoniam ijia e gaman ijiebuon ikreno be ijefuon am ijar ka adam ma bomana be aben. ");
INSERT INTO nvm_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","E iji fu ijia fine Jesu fu ai Judia areme una Gareri ruainma fu iji fain. Ijefuon fu va kuaga Jesu fu farifuon iji adam abene fuka guakreno ijin keunakro fu ijeg vierafene vain. ");
INSERT INTO nvm_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Fu vake gafia keko kuamga Jesu fu una kua, Ja e fok ja vierafe naka ire sumakin mukor kafo uruvana rega ja ijia giame ijar una na ma vierafekuai ja ijeg vierafenvano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Jesu fu ijeg kuardamga e bomana iji fu una kua, E Bomana e-e nika nosik vakne revo a saroikma farinun iji fuka guak. ");
INSERT INTO nvm_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Fu ijeg kuardamga Jesu fu una kua, Na vierafe farifon iji fuba guakgavo fu una maikno ni una vakne kuain. Fu ijeg kuardamga e bomana iji fu Jesuon vuak ijin abe ma vierafene fun una ai fuon ijia vain. ");
INSERT INTO nvm_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","E bomana iji fun una vakgame efuon ikrejo roin bu vuak abe roke unam ijia fu bieme usem kua, Amon adam abenma iji fun mainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Bu ijeg kuardavga e bomana iji fu tavan ivez farifuon fu una mainma ijefuon kiamga bu una kua, Fu niar tavan una gura manino ijia fu una urinmano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ijefuon e bomana iji fu ijia una vierafero Jesu fu tavan besum ijia fu una kua, Farifon iji fun una urikno kuainma fu iji vierafen. Ijefuon fu aganfuon ijiena tavan ijia una Jesu ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesu fu Judia oinevo fu una Gareri roko ijia fu unam sumakin nokarok (2) ijin rena bu giain. ");
INSERT INTO nvm_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tavan sibank barekoga Jesu fun una Jerusarem ijia e Jius bu afuime iro buon be ijo ijia vain. ");
INSERT INTO nvm_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Regavo ai Jerusarem ijia vien bomana be bu kua Sif Vieno kuavo iji samaij ijia do be fu ijia nafuin. Regavo do iji nafuinma iji bu e Ibrukobuon isama ijia bu kua Betesdano kuavo. Do iji nafuinma irif ijia bu ar kafo sa ameoine aren. ");
INSERT INTO nvm_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ijefuon e adam abejo ga e diak ise ga e ni zuriaigin ga vajai garenva uruvana bu ar ijefuon banad ijia naoiga do iji fu katiga bu gakuai bu iji samua naoiv. ");
INSERT INTO nvm_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ijefuon maiji Godon anera iji bu tavan kafokafo do ijia ari dab kativ. Regavo e adagin erar fu amur migegare do iji fu katime areke fu ijia arime una ajiekma e iji adam fuon irerag fu abeno iji fuka migegare barek. ");
INSERT INTO nvm_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ijefuon e be ijia namo iji fuka juaivasia uruvana adam abenma ijar ijia nam. ");
INSERT INTO nvm_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ijefuon Jesu fu keko e iji namo iji gain. Fu game vierafega e iji fuka usuibe adam abenma ijar ijia nam. Ijefuon Jesu fu uri kua, A vierafe adam on iji fube migegare madakno kuain? ");
INSERT INTO nvm_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Fu ijeg kuardamga e adagin iji fu una roin kua, E Bomana na erar na aferdieme imuikie do guri katimo ijia uniega na do ruaikva bakin. Na do guri fu ik katimo ijia na ruaikafie urijo iji bun e roinb amur asidie ruaigame naiji na ijia arevno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Fu ijeg kuardamga Jesu fu uri kua, Ni uri suf on iji ke matome vakne kuain. ");
INSERT INTO nvm_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Fu ijeg kuamga migegare e ijefuon adam iji fuka maimga fu uri suf fuon iji ke matome una ai fuon ijia vain. Regavo e adagin iji Jesu fu kuamga fu suf ke mato vainma iji fu tavan Sabat (Satade) iji e Jius bu isuar karine Godon sirimamejo ijia fu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","E Jiusbuon e mamkanuk roin bu usem e iji game kua, Ivia tavan Sabat (Satade) igi fu akai no isuar karijo revo suf iji a ke matom roko iji fuka ba maren. Ijefuon maiji akai nuvuon ijia no tavan iji no isuar karijo ijia ire kafo noba kege ok. Regavo suf on guraiji a abe oinon iji aka akai nuvuon iji dab tuasenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Bu ijeg kuardavga e adagin iji fu una kia, Na e iji fu amardienma ijar kie ni suf on iji ke mato vakne kiemga ijefuon na iji suf ke rokno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Fu ijeg kuardiamga bu kua, Regavo e iji erar a kuamga a suf ke mato kunaim rokno kuain? ");
INSERT INTO nvm_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Bu ijeg kuardaga e adagin iji fu e iji fu amardainma iji fuba mukoi vierafen. Ijefuon maiji buka e uruvana ijia afuinva ijefuon Jesu fun e kafar ijia sauin. ");
INSERT INTO nvm_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ijegreare Jesu fu rad una Godon ar bomana bu sirimamejo ijia e iji fu amardainma iji bieme kua, Eko vajat on guraiji fuka una madain ijefuon rad ab una madu ise rek. Regavo a una adamene ise rekma ire ka ma ise be fu una vajat on ijia rega a gakno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jesu fu ijeg kuardame vakoga e iji fun va e Jiusbuon e mamkanuk iji kuardiame kia, E iji fu Jesur na amardienmano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ijefuon e mamkanuk iji bun va unam iji Jesu fu renma ijefuon bu uri vuak ise kafokafo fuisina kuain. Ijefuon maiji e adagin iji fu tavan Sabat (Satade) akaij iji e Jius bu isuar karine God oimardavo ijia amardain. ");
INSERT INTO nvm_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Bu ijeg kuaivga Jesu fu giame uri kia, Asoinun iji fu tavan bog ikreno ijefuon nak na ikrejno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jesu fu vuak ijeg kuainma ijefuon e Jiusbuon e mamkanuk iji buka uruvana deajidiamga bu uri Jesu kanakuai vierafen. Ijefuon maiji fu akaij iji bu isuar karine God oimardavo iji bu abedenva ijesugin abe tuasenma bakigavo fu madu kuai fu God Asoifuon ijek bu besumno kuainma ijefuon bu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ijefuon Jesu fu una roin kia, Vuak igi naka ma kuardiavo mukoi faif. Na Godon Farif na irerag na reoijo iji nam nar oinun igia vierafene reoijo bakin. Regavo nam irerag Asoinun ijar rega na giavo na ire ni besum ijesugin reoij. ");
INSERT INTO nvm_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ijefuon maiji Asoij iji fu Farifuon iji oijmamo ijefuon fu uri ire fok fu reoinon iji Farifuon kuardako fu ren. Regavo fu uri ire ma mamkanuk kafo madu igekin iji nijaidie na rega ja giekva jaka oiserdiak. ");
INSERT INTO nvm_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Asoinun iji fu e bu aoivo iji fu kiaga bu una uri oijo ijeg ga Farifuon nak na e iji bu aoivo iji na koiknun e iji na vierafenva iji kiaga bu una uri karik. ");
INSERT INTO nvm_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Regavo Asoinun iji fu koikfuon e moikigia ise reoijo ijiebuon ise iji kege mazim giaknum duna kiamo bakin. Regavo ire iji fun una na kuardiega nar e moikigia ise reoijo ijiebuon ise iji fine giaknum duna kiak. ");
INSERT INTO nvm_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Regavo na ijegrega e fok bu Asoinun iji bu aroivo ijeg bu una na abe arordiek. Ijefuon eraneb buba arordievo iji bu Asoinun iji fu na kiema na ari ruainva iji buba aroiv. ");
INSERT INTO nvm_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ijefuon naka ma kuardiav eraneb vuak nun igi igieme una e iji fu na kiema na ruainva iji fu ma vierafekva e iji bu unam iji ma karivako iji abek. Fu ijegrenki rad God fuba una ise fuon iji kege mazim giame duna kafo kuaknum dab arafirak. Regavo fun koikfuon una madu guakfuon unam iji fun dajame una unam ma karivakfuon ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Regavo vuak igi na ma kuardiav tavan iji fun samairen gavo fu iga ruaido e gami aoinva iji bu Godon Farif na i nun igi faik revo eraneb bu faikva bu una ma karivak. ");
INSERT INTO nvm_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Asoinun iji fu unam ma karivako ijefuon anej ijin. Unam besum ijeg Farifuon fu na abe unam ma karivako anej iji amaren. ");
INSERT INTO nvm_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Regavo fun Godri daro miedo na fine e moikigia ise rejo iji kege mazim giame duna kafokafo kiak ijefuon maiji na Ema buon Farif. ");
INSERT INTO nvm_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Ijegvo jab vuak igi na kuardiavo ijefuon uri oiserdiavo. Tavan iji fun samairedo e gami mako ijia uniainva iji bu i fuon iji faikva bu mako ijia una usem ruak. Bu mako buon ijia una usemvo e iji bu ma kegoinva iji bu una ijia karivak revo e iji bu isema kegoinva iji bu una uri vajaifian abek. ");
INSERT INTO nvm_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Regavo na moikigia ire be irerag daro nun ijia reoijo iji fuka ma bakin. E moik igiebuon ise iji na kege mazim giavo iji na Asoi nun ijar kuardieko na faime ijia reoij ijefuodo iji naka ma ijefuon rej. Ijefuon maiji na nun vierafenva ijia reoijo bakin revo nan e iji fu kiema na ruainva ijefuon vierafenma na ijesugin jame reoij. ");
INSERT INTO nvm_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Regavo na koiknu uri kiak vuak nun igi na kuardiavo iji fuka mano kiakva ja izeg vuak nun iji abe ma vierafekva bakin. ");
INSERT INTO nvm_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Regavo Godri nuisina una e roin kuardiamo iji na vierafega vuak irerag fu kuardiamo iji fuka ma. ");
INSERT INTO nvm_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jar e iji kiavga bu va e Jon fino ijia usem nuisina kuavga fuba una vuak kufui ijia kuardiain. Regavo fuka uri samakaf vua ma iji nuisina kuardiain. ");
INSERT INTO nvm_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Vuak igi na Jon fu nuisina kuainma na iji visu kuardiaikin ja ijia ma vierafekva God fu tavan radkma ijia ja karauniak. ");
INSERT INTO nvm_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","E Jon vuak fu kuardiame ruainma iji fu ikuosaij abe baroina fu sanamga fu abe ruainma igekin. Fu sanainma iji abe rokga ja tavan ivuankbe ijesugin oimardain. ");
INSERT INTO nvm_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jon vuak iji fu nuisina kuardiainma iji fum sibank kuardien gavo iviakma ire sumakin ka darokin igi na rejo ijar fuka ma bomana. Ire mamkanuk sumakin igi na rega ja gievo iji ik iji Asoinun iji fu na vajienma ijin. Ja ire iji na rejo iji giakva ja ijia una ma vierafero naiji Godri kiema na ruainvaro. ");
INSERT INTO nvm_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","38","Regavo madu Asoinun iji fu na kiema na ruainva iji fuk fu nuisina fun kuardiain. Ja i fuon iji jaka ba fain gavo uikinik fuon iji jaba gain gavo ja e iji fu na kiema na ruainva iji jaba ma vierafen. Regavo madu vuak fuon jaba kege oijon ijia nain. ");
INSERT INTO nvm_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ja vierafe ja Godon vuak bu usuibe isoinva iji amarigia dakva ja unam ma karivakfuon iji ja ijia abekuai ja ijeg vierafen. Regavo vuak fok bu kuaime isoinva iji bu nuisina isoin. ");
INSERT INTO nvm_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Regavo ja nun roga nar ifejdiaga ja ma karivakfuon iji jaka uzav. ");
INSERT INTO nvm_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","Na ema jar na dab arordiekro na iji vierafenva bakin. Revo madu ja naka samakaf giain. Na giamga ja Godon oijmiamo iji jaba abe oijon ijia abeden. ");
INSERT INTO nvm_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Naiji na Asoinun ijefuon daro ga if fuon ijia ruain gavo ja oijon fok ijekma vuak nun igi ja mukoi faime abejo bakin. Regavo ja e be fum daro ga if fuon ijia ga vuak fuon iji dab ja kuardiabatie jaka amarigia vuak fuon iji faime fu kuardiamo iji igame keok. ");
INSERT INTO nvm_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ja una joi nidoinamikuai ja iji vierafen gavo Godri fu ja nidosiakfuon iji jaba bomana vierafene uri ijef ren. Ja ijegrejo ijia ja izeg una na ma vierafek? ");
INSERT INTO nvm_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Regavo jab vierafero nar ise jon igi ja reoijo ijin giame una Asoinun iji kuardakro jab ijeg vierafek. Regavo fu Mosison akaij iji ja dab ma vierafeoijo ijar ise jon ke mazim giak. ");
INSERT INTO nvm_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ja akaij iji fu abe miainma ja iji ma vierafeoijobatie ja madu una na ma vierafek. Ijefuon maiji vuak fok fu isoime kuainva iji fu nuisina kuain. ");
INSERT INTO nvm_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Regavo ja vuak fuon fu isoinma iji jaba abe ma vierafeoijo iji ja izeg una vuak nun igi abe ma vierafek? ");
INSERT INTO nvm_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jesu fu vua kuardiame fun vanag abe una do Gareri (if fuon be bu kua Taibiriasno kuavo iji) irif gara vain. ");
INSERT INTO nvm_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Fu ijia vakga e ka uruvana bu unam sumakin ka darokin iji fu e adagin fu karauniaga bu una madiamo iji gainva ijefuon bu iji jame vain. ");
INSERT INTO nvm_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Jesu fun e vuak fuon faivo ijiena uruor be ajie vake makaf ijia usem ijia karin. Regavo iji fun e Jiusbuon iro Fasova iji bu ijo iji samairenma ijia bu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Rene Jesu fu una dakaroim gia buka e uruvana javga fu una Firif kua, Buka e uruvana rok revo a vierafe duok iji no izia kimene vajiaga bu ikno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesu fu izegrekfuon iji fun vierafen gavo fum Firif oifuon fu izeg vierafenma iji gakafa fu ijefuon vuak ijeg kuardain. ");
INSERT INTO nvm_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Fu ijeg kuardamga Firif fu una roin kua, E guri buka e uruvana ijefuon a mon ka ma uruvana kege bred uruvana kimene vajiaga bu ikva iji madu na vierafe fuka ba aresremano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Fu ijeg kuardamga Edru e Saimon Fitaon diar ijar uri Jesu kua, Na am ukakbe fu bred ukakna imut roin (5) ga kijum nokarok (2) ijeg ke roka na gain. Regavo iji na vierafe fu izeg e fok bu iga fu defiakma bano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Bu ijeg kuardavga Jesu fu una kia, Ni e fok kiaga bu moik ijia ari karifno kiain. Regavo ar iji bu irenva iji fu garas mukoi name aren ijefuon bu ijia ari kariga e uruvana iji vainva ijia e baru ijesugin buka e faiv taosen (5,000) ijeg. ");
INSERT INTO nvm_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesu fun uri bred am ukak iji fu kege vainma iji kege uri kaf gufia kuniaime Godon sirimamene kege vajiamga bu kege una e fok iji vajiain. Ijegreare fun una madu kijum iji kege amur fu renma ijegrene kege e iji vajiamga bu ija buka defiain. ");
INSERT INTO nvm_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bun defiamga Jesu fun uri e vuak fuon faivo iji kia, Duok ukur iji kafo jab nisek nika amarigia kanafufno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Fu ijeg kuardiamga bun uri bred ijiga kijum ukur iji bu ija defiamga bu nainva iji karme una ter tuer (12) ijeg anusen. ");
INSERT INTO nvm_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jesu fu tavan ijia ire sumakin iji rena e uruvana bu game kuai, E iji fun ma e iji fu Godon vuak vierafene kuaimon iji fu ruakno kuainma ijarno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Regavo Jesu fun giamga e iji bu fu dab Kin buon rekuai ejafavga fu uri fuonkua uruor ijia ajie vain. ");
INSERT INTO nvm_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Rene fun tavan nakisrega e Jesuon vuak faivo iji bun uruor iji areme una do Gareri irif ijia ari vain. ");
INSERT INTO nvm_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bu ari usem vanag abe una ai Kafoniam nak vain. Regavo iji fuka tavan nakinma ijia bu vanag abe do ijia vain revo Jesu fuba ijia buna. ");
INSERT INTO nvm_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Regavo buibur bomana ijar ijia ufiko do iji fuka bomana foin. ");
INSERT INTO nvm_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Regavo e vuak fuon faivo iji bunka vanag abe do uf garia vainva ijia bu gak Jesu fu do azan ijia bu biediakro rokga bu game buka uruvana igia juin. ");
INSERT INTO nvm_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Bu juvga Jesu fu giame kia, Na narno jab jukno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Rega bun una oimarknum fu afeme vanag ijia uname migegare vanag iji fu do irif iji bu vako ijia kekoin. ");
INSERT INTO nvm_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Areme afarma e iji do irif gara fu bred ga kijum vajiama bu inva ijieb uri Jesu nisain. Bu vanag iji fu besum do irif ijia namo iji bun e Jesuon vuak faivo ijieb abe vaka bun gain revo Jesu fuba buna vanag ijia ajiema bu gainva ijefuon bu fu nisain. ");
INSERT INTO nvm_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Regavo vanag ai Taibiriasko iji bu roke do irif ar iji Jesu fu bred kege Godon oimarme kege una e fok vajiama bu inva ijia usen. ");
INSERT INTO nvm_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ijefuon bu uri gak e iji Jesuon vuak faivo ijiga Jesu bu baga bu uri vanag iji bu ik usem naoivo ijia ajieme bun Jesu nisaim ai Kafoniam ijia vain. ");
INSERT INTO nvm_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bu nisaim vake do gara ijia bieme kua, E Nijaidiamon a izeg igia ruainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Bu ijeg kuavga Jesu fu kia, Naka ma kuardiav ja na nisaidie ruainva ijefuon maiji ja bred na vajiava jaka uruvana inva ijefuon ja iji nisaidieme ruain. Regavo ja unam iviamkor sumakin na reja ja gienva ijefuon nisaidie ruainva bakin. ");
INSERT INTO nvm_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Jab uri juar ja duok abedeme ikfuon ijesugin vierafek. Ijefuon maiji duok iji bu tavan rad bu barek. Regavo ni uri daro jon iji kege ire iji ja ine tavan bog ijia karivakfuon ijin vierafene ijefuon ik reof. Regavo ire iji Ema buon Farif igi nar ja vajiakfuon. Ijefuon maiji God Asoij ijar na abe unam igi na reoijo ijefuon marme uniemga na ruainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Fu ijeg kuardiamga bu una kua, Regavo ik iji God fu vierafe no rekfuon iji no irerag iji rekno kuain? ");
INSERT INTO nvm_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Bu ijeg kuardavga fu kia, Ik iji God fu vierafe ja rekfuon iji ja e igi fu kiema na ari ruainva igi na ma vierafek. ");
INSERT INTO nvm_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Fu ijeg kuardiamga bu una kua, Regavo a ire sumakin be a irerag iji rega no ijia game una a ma vierafek? Regavo Godon buk akai bu usuibe isoinva ijia bu kuai, Mosis fu ai moikum namo ijia bred mena fum kaf gufia ari rokga fu kege e saifnuvuon iji vajiama bu invano kuain. Izeg bu ai moikum namo ijia vasiaordiamga bu bred mena fum kaf gufia arimga bu kege in. Ijefuon vo abe ire sumakin be ijekin iji rega no ijia game una a ma vierafek? ");
INSERT INTO nvm_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Bu ijeg kuardavga Jesu fu una kia, Naka ma kuardiav bred iji Mosis fu ai moikum namo ijia bred kege saifjon iji vajiamga bu inva iji fu bred ma iji bakin. Regavo bred iji asoinun fu iviakma vajiamo ijar fu bred ma. ");
INSERT INTO nvm_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ijefuon bred ma iji fu e ijar arime e moikigia oinva iji ifejdiaga bu ijia ma karivak. ");
INSERT INTO nvm_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Fu ijeg kuardiamga bu uri kua, E bomana nika ivia anerene tavan bog bred ijekin ijesugin vajuoke no ijno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Bu ijeg kuardavga Jesu fu uri kia, Naiji na bred iji ja ine tavan bog ijia ma karivakfuon ijin. Erar fu nun ruakma e iji fuba vasia guak. Regavo erar fu na ma vierafekma e iji fuba do kafak. ");
INSERT INTO nvm_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ijefuon igia faif iviakma na giamga ja irerag na reoijo iji jaka giev revo na giamga jaka ba una na ma vierafej. ");
INSERT INTO nvm_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Regavo na e iji Asoinun ijar oibuon iji ke karoiga bu enun rekva naba bu rotkuriak. ");
INSERT INTO nvm_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ijefuon maiji kaf gufia na ari ruainva iji nam nar nun vierafenva ijia reokro ruainva bakin na e iji fu kiemga na ari ruainva ijar irerag fur vierafeno na ijesugin reok. ");
INSERT INTO nvm_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Regavo Asoinun iji fu kiemga na ruainva ijefuon fuon fu vierafenma ijeg na e iji Asoinun ijar oibuon iji ke karoiga bu e nun rejo iji kafo naba uniakok. Regavo na tavan iji ire fok moikigia bu barekva na ijia e iji bu aoinva na kia bu una uri unam ma ijia ma karivak. ");
INSERT INTO nvm_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Regavo Asoinun ijar vierafenma iji erar Farifuon na gieme una na ma vierafekva bu unam ma ijia ma karivak. Bu ijegrenki tavan radkma ijia bu aoikva na kiaga bu una uri unam ma ijia ma karivakno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Fu ijeg kuardiamga e Jius iji bun ijefuon uri vuak iji dab bui musikuain. Ijefuon maiji fu kia, Naiji na bred iji kaf gufia ari ruainma ijino kiain. ");
INSERT INTO nvm_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bu kuai, E iji fu Jesu e Josofon farif iji non vierafenva ijin. No eofijaf iji non giavo gavo fu irerafuon kuai naiji na kaf gufia ari ruainvano kuaim? ");
INSERT INTO nvm_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Bu vuak iji dab bui siguvga Jesu fu giame una kia, Vuak iji ja dab joi musikuaivo iji aref. ");
INSERT INTO nvm_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Fu erar izeg koikfuon giriesame una na ma vierafekma bakin. Revo fun Asoinun iji fu kiemga na ruainva ijar e ijiebuon oij iji kege karoiga bu ijia na ma vierafek. Bu na ma vierafekva na tavan radkma ijia bu aoikva na kia bu una uri ijia ma karivak. ");
INSERT INTO nvm_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Regavo usuibe e iji bu Godon vuak vierafene kuaivo bu isoinva iji bu ijeg kuai, E fok bu Godri koikfuon nijaidiakno kuain. Ijegvo eraneb bu Asoinun ijefuon vuak iji faivknum unam fuon ma iji mukoi vierafekva e iji bu nun ruak. ");
INSERT INTO nvm_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Regavo e be fu erar Asoinun iji gainma bakin. Regavo fun e iji God fu kuamga fu ari ruainma ijar fuonkua gain. ");
INSERT INTO nvm_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ijefuon naka ma kuardiav eraneb ja na ma vierafekva ja unam ma karivako iji abek. ");
INSERT INTO nvm_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Naiji na bred ma iji ja ine tavan bog unam ma ijia ma karivakva ijin. ");
INSERT INTO nvm_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Saifjon iji bu ai moikum namo ijia bred mena kuavo iji igavo buka aoim baren. ");
INSERT INTO nvm_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Regavo bred iji kaf gufia ari ruainma iji fuka mukor ga nibe ijefuon eraneb bu bred iji ikva bu aoikva bakin. ");
INSERT INTO nvm_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ijefuon naiji na bred ma iji fu kaf gufia ari ruainma ijin. Erar bred ijin ikma fuba guakgavo fuim una unam ma karivako iji abek. Regavo bred iji vajai surif nun igin. Na vajai surif nun iji abe e fok moikigia oinva iji mia bu inki bu unam ma iji abe ijia ma karivak. ");
INSERT INTO nvm_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jesu fu ijeg kuardiamga E Jius iji bun vuak ijefuon una bui musikuain. Bu kuai e iji fu izeg vajai surif fuon iji abe muoga no ikno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Bu ijeg kuaivga Jesu fu una kia, Naiji na ma kuardiavo igia faif ja Ema buon Farif ijefuon vajai surif ijiga kavuan iji ba ikva ja izeg unam ma karivako iji abekva bakin. ");
INSERT INTO nvm_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Regavo eraneb kavuan nun ijiga surif nun iji ikva bu unam ma karivako iji abedo na tavan radkma ijia bu aoikva na kia bu una uri ijia ma karivak. ");
INSERT INTO nvm_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","56","Ijefuon maiji vajai surif nun ijiga kavuan iji bu kaven nuvuon ijiebuon duok ma. Ijefuon erar kavuan nun ijiga surif nun iji ikma na oifuon ijia fioga fuiji fu nosik besum fiok. ");
INSERT INTO nvm_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Asoinun iji fum ijia fino ijar na kiemga na ari ruain revo fum ijia vek fino ijefuon na vek fij. Ijefuon gavo eraneb bu vajai surif nun ijiga kavuan nun iji ikva na vek fijo ijefuon bu ijia karivak. ");
INSERT INTO nvm_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Regavo bred iji na kuardiavo iji fu kaf gufia ari ruainma ijin. Regavo fun bred iji saifjon iji bu ai moikum namo ijia inva ijekin bakin. Saifjon iji bu ai moikum namo ijia bred mena kuavo iji ine rad bu aoin gavo bred igi na kuardiavo iji fu ijekin bakin. Eraneb bred ijin ikva buba aoikno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Regavo vuak igi Jesur ai Kafoniam ijia ar iji bu afuime vuak kuaivo ijia aru mani vuak nijaidiamon ijia fu ijeg kuardiain. ");
INSERT INTO nvm_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","E Jesuon vuak faivo iji bu vuak iji faime una bui kuai, Vuak iji fuka gigikin fu erar vuak iji faime ma iji vierafekma bano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Bu ijeg dab bui siguvga Jesu fun giame uri kia, Ja vuak iji na kuardiainva iji jaka dab oi kafokafo vierafen ijefuon ja jon izeg ja na ma vierafejo iji jan arekuai ja ijeg vierafen? ");
INSERT INTO nvm_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Regavo ja Ema buon Farif iji fu una ar fu ari ruainma ijia ajie vakma ja izeg rek? ");
INSERT INTO nvm_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Unam ma iji ja abe ijia ma karivako iji fun besum ja Godon Kaven Akai abega fur oijon samuagdiakma ja ma karivak revo jam ema jar koikjo daro jon ijia ma karivakva iji ja izegrekva bakin. Revo vuak igi na kuardiainva iji na Kaven Akai ijefuon vuak iji kuardiain. Vuak ijar ja ifejdiaga ja unam ma karivako iji abek. ");
INSERT INTO nvm_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Regavo e guri roin na giamga jaka ba vuak iji abe ma vierafenvano kiain. Regavo Jesu iji fu kuainma iji fuka uria ijia eraneb bu fuba ma vierafekfuon iji fun giain. Regavo madu eraneb bu fu abe una e ise rejo iji miakfuon iji fun giame vierafenma ijefuon fu ijeg kuain. ");
INSERT INTO nvm_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Fu ijeg kuardiame kia, Na ijefuon ja kia fu e be erar fum koikfuon una na ma vierafekma bakin. Rega fun Asoinun ijar koikfuon e ijefuon oij iji abe dakaroiga fu ijia una na ma vierafekno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jesu fu ijeg kuardiainma ijefuon e vuak fuon faivo roin bu una funa okfuon iji bun uzain. ");
INSERT INTO nvm_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ijefuon Jesu fu uri e vuak fuon faivo tuer (12) ijeg kia, E roin bun na are vain gavo jak jab na areme vakuai vierafekvano kiain? ");
INSERT INTO nvm_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","69","Jesu fu ijeg kuardiamga Saimon Fita fu uri kua, E Bomana iviakma no ma vierafega a onkua aka e akai Godri kuamga a ruain. Revo vuak ma iji ma karivako iji ar kuarduoga no faiv gavo no a unako vakva no una e be erafon vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Fita fu ijeg kuardamga Jesu fu una kua, E guri tuer (12) iji na nar koiknu kega ja nana oin gavo iji ja oijo ijia e besum fu kaven iseno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Regavo iji fu kiainma iji fu Judas e Saimon Iskarioton farif ijefuon kuain. E iji fuka vuak fuon faimo be gavo fuka tavan rad Jesu abe una e ise reoijo iji miak ijefuon fu iji kuain. ");
INSERT INTO nvm_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Areme Jesu fun ai Gareri ijia oknum e iji vuak nijaidiaoin. Regavo fu una ai Judia ijia fuba oin ijefuon maiji Jius e mamkanuk iji bu fu kanakuai samuame karinva ijefuon fuba ijia vuak nijaidiain. ");
INSERT INTO nvm_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","Regavo ai Judia ijia bu tavan iji e Jius bu usuibe ai moikum namo ijia busame ijia karioinva iji vierafekuai iro ijo iji fun samairen. Ijefuon Jesuon uviaifijaf iji bun uri Jesu kua, Ar igi a oinon iji arega ni una uri gamia Judia vakne. A ijia va ire sumakin igi a reoinon iji roin ijia regakva e vuak on faivo iji bu ire sumakin a reno iji gak. ");
INSERT INTO nvm_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","A igia sauime fikma e ar iror fok bu izeg a ma vierafekva bakin. Ijefuon vierafe e fok bu a game ma vierafekva ni uri una gamia Judia e uruvana bu afuime iro ijo ijia va ire sumakin iji rega bu gavno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Vuak iji e uviaifijaf ijieb ijeg Jesu kuardain gavo bu madu Jesu buka ba ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ijefuon Jesu fu uri una kia, Tavan kafokafo e iji bu iro ikuai afuivo ijia ja tavan kafo vak ga tavan kafo ja arekva iji fun maren. Regavo iviakma naiji na tavan nun iji fuba abedo naba vak. ");
INSERT INTO nvm_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","E moikigia oinva iji ja bu ziegafiakva bakin revo bu na ziegafieknum dab arafiriek. Ijefuon maiji na unam ise bu kegoijo iji na samakaf visume kuardiavo ijefuon bu na ijeg rek. ");
INSERT INTO nvm_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ijefuon ni jar iro ijia vaf revo naiji naba vuak. Ijefuon maiji tavan nun iji fuba abenmano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Fu ijeg kuardiame fun ijia areme Gareri ijia naki sibank fin. ");
INSERT INTO nvm_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Areme Jesuon uviaifijaf iji bun Judia ijia iro iji bu inva ijia vakga Jesu fu rad isuar sauime jajia vain. ");
INSERT INTO nvm_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Fu vakgame e Jius e mamkanuk iji bu iro ijia karinva iji bu uri Jesu nisaimoknum e iji afuinva iji kia e iji fu izerkiga nijaiduofno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Regavo e iji afuinva ijia e roin bu fuisina isuar karine bui kuai e iji fuka e mano kuaiv. Regavo e roin bu kuai e iji fuka e uruvana aferdiame una unam ise ijia nijaidiamno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Bu dab ijeg fuisina kuaimoin revo buba abe uruvana kuaime samafren ijefuon maiji bu e Jius e mamkanuk iji juin. ");
INSERT INTO nvm_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Rene iro iji bun ine rirkinenva ijia Jesu fun Godon ar ijia aru manine e iji vuak anerene nijaidiam. ");
INSERT INTO nvm_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Fu ijeg nijaidiamga Jius e mamkanuk iji bu gava buka oiserdiamga bu kuai, E iji fu Godon buk akaij ijia vuak akaij iji buba abe fu nijain revo fu izeg vuak ma iji mukoi vierafenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Bu ijeg kuaivga Jesu fu una kia, Vuak igi na kuardiavo iji fu nun bakin revo vuak iji fun God Asoij iji fu kiema na ari ruainva ijefuon vuak. ");
INSERT INTO nvm_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","E be erar fu Godon vierafenma ijia kegoino e ijar vuak igi na abe kuardiavo iji fur giek. Fu giega na vuak nun nar vierafenva iji abe kuardia vo na Godon vuak abe kuardiavga iji fur gieme vierafek. ");
INSERT INTO nvm_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Regavo e be erar fum vuak fuon fur vierafeno iji abe kuardiaoino iji fu fuon aroinamikro fu iji vierafen. Regavo erar fu vierafe e iji fu kuamga fu ruainma iji abe aroikro fu ijeg vierafeno e iji vuak fuon fu kuaimon iji fuka ma ijesugin ga kufui kafo ijia fuka bakin. ");
INSERT INTO nvm_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosis fuka akai uruvana kege ja vajiain gavo e fok guri ja karinva ijia e besum fu erar akaij iji mukoi igiainma bakin. Regavo ja irerafuon ja na kaniekuai nisaidievno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jesu fu ijeg kuardiamga e iji bun uri kume, E gafi ka kaven ise ijar niroinma gafi a erar a kanakvega a iji kuaimno kumen. ");
INSERT INTO nvm_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Bu ijeg kuardavga fu una kia, Na ire sumakin besum tavan iji ja isuar karine Godon sirimamejo ijia reja ja gieva jaka oiserdiain. ");
INSERT INTO nvm_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Regavo iviakma ja Mosisri akaij iji surif kania ufu anf navo iji miainma ijefuon ja ijin ijeg keg. (Regavo unam iji bu saifjon ijieb ijeg kege ruain revo Mosis akai fu rad isoime ke vajiain). Ja am ukakna ijiebuon surif iji ja kania ufu anf navo iji fu tavan akaij iji guf ijekma ja iji jaika vierafekva bakin. Ijefuon vo ja irerafuon e adagin gafi na tavan iji ja isuar karine God sirimamejo ijia amarva fu mainma ijefuon una oij isema na vierafeknum jaka ziemoij. ");
INSERT INTO nvm_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ebuo ise iji ja giame kuaikva iji isuar irerag bu rejo iji anej ma iji amarigia giame kuaikfuon. Regavo iji jam uri irerag bu rejo iji giame una ise buon ijefuon kuaivo iji fuba maren. ");
INSERT INTO nvm_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Fu ijeg kuardiamga e Jerusaremko iji bu uri bui kuai, E iji kafu e igi e mamkanuk bu kanakuai nisaimoijo ijin. ");
INSERT INTO nvm_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Bu fu kanakuai kuaimoij revo fuba jum fuka uri e fok ijiebuon nifak ijia manine vuak kuaim. Rega madu e mamkanuk iji buba una vuak fuon gari roib kuardav. Bu kafu vuak fuon iji faime vierafega e iji fun ma e iji God fu kuamga fu ruainma ijarga buba una vuak fuon gari roib kuardav. ");
INSERT INTO nvm_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","No e gari fu e izekor iji non vierafen gavo tavan rad God e iji fu kuaga fu ruakno kuainma iji fu ruakma fu erar izia fu ruainma iji mukoi game vierafekma bano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","29","Jesu fu vek Godon ar bomana bu sirimamejo ijia manine vuak kuardiamo ijia bu ijeg kuaivga fu kume, E fok guri karinva gurie ja na e izekin ga na izia ruainva iji jaka ba vierafen. Naiji nam nar igia ari nun na vierafenva ijia reokro ruainva bakin. Regavo God iji fu kiema na ruainva iji fuka God ma ga fu e kufuikin bakin. Regavo fuiji ja game vierafenva bakin gavo nar fu nan vierafen. Ijefuon maiji na fur kiema na fu fino ijia ari ruainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Fu ijeg kuardiainma ijefuon e roin bu fu kunaim dibur unakuai vierafen. Regavo bu imut buon ijia kafo buba vajai fuon niriain. Ijefuon maiji tavan fuon ma iji bu fu kanakfuon iji fuba ruain. ");
INSERT INTO nvm_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Bu ijeg ren gavo e iji afuinva ijia buka e uruvana una fu ma vierafene isuar bui kuai, E iji bu usuibe kuai fu ruakno kuainva iji fu ruakma fute ire sumakin ka uruvana kafo e gari fuba renma iji asime rekno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Bu fuisina vuak ijeg kuaivga e Ferisis ijiga e mamkanuk Godon isuf baroijo iji bu e juo karijo roin kiavga bu Jesu tokuai vain. ");
INSERT INTO nvm_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Bun vake gafia usevga Jesu fu uri kia, Naiji nam asam sibank igia oine nan una God e iji fu kiema na ruainva ijefuon vak. ");
INSERT INTO nvm_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Na ijia vakva jaka uri na nisaidiek revo ja giekva bakin. Ijefuon maiji ja ar na vako ijia jaba vuakno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Fu iji kuardiamga e Jius bu vuak iji faime una bui kuai, E iji fu ar fu izia vakredo fu vaga noba gak? Fu kafu uri e Grikbuon mai ijia e Jius iji bu kari vainva ijia E Grik iji vuak nijaidia vak? ");
INSERT INTO nvm_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Fu kuai fu vakma no fu nisaik revo noba fu biek. Regavo madu no ar fu fino iji noba vakno kuainma ijefuon anej ma iji irerag? ");
INSERT INTO nvm_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","38","Tavan bomana be bu iro ine barekrejo ijia Jesu fu uri uruvana igia aramajiame kume, E be erar do kafakma ni nun roga na do jiamavno kumen. Ijefuon maiji usuibe Godon buk akaij ijia bu isoinva iji bu ijeg isoi, Eraneb bu na ma vierafekva do iji fu bu ifejdiaga bu ma karivako iji fu oibuon ijia abesek. ");
INSERT INTO nvm_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Regavo Jesu vuak iji fu do ijefuon kuainma iji fu Godon Kaven iji bu eraneb ma vierafene abekfuon fu ijefuon kuain. Regavo tavan ijia bu Godon Kaven buba aben. Ijefuon maiji Jesu fuba guame una uri sanainma fuon kaf gufia vain. ");
INSERT INTO nvm_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Areme e fok afuinva ijia e uruvana roin bu Jesu vuak iji fu ijeg kuainma iji faime kuai, E iji no vierafe fu ma e iji Godon vuak faime una e roin kuardiamo ijarno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Regavo e roin bu kuai, E iji fu God e iji fu kua fu ruakno kuainma ijar. Regavo roin bu kuai, E iji God fu kua fu ruakfuon iji fu ai Gareri guf ijia fu ruakma bano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Regavo Godon buk akaij iji bu usuibe isoinva ijia fu ijeg nijaiduin. E iji God fu kuai fu ruakfuon iji fun e Devidon uifarif ijia ruak. Regavo e iji fu ai Betriem e Devid fu fino ijia nafekno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ijefuon bu Jesuon vuak iji ijeg kuaime dab ata roinroin rene bui sigunamin. ");
INSERT INTO nvm_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","E roin buka deajidiamga bu Jesu kunaim tokuai vierafen gavo vajai fuon iji buba kafo niriain. ");
INSERT INTO nvm_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Areme e Godon ar juo karijo iji bu Jesu tokuai ruainva iji bun ijia areme una va e mamkanuk Godon isuf baroijo ijiga e Ferisis gafi bu karinva ijia usen. Bu usevga bu uri kia, Ja irerafuon e iji no kiava ja vainva iji jaba tom afem ruainvano kiain? ");
INSERT INTO nvm_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Bu ijeg kuardiavga e Godon ar juo karijo iji bu una roin kia, E iji no afekuai vain gavo no usem vuak fuon iji fu kuaimon iji faiva fuka oiseraduin. Vuak fuon iji fuka vuak sumakin e bu igia kuai no faivo bakin fu ijin kuaimga no ijia are ruainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Bu ijeg kuardiavga e Ferisis iji abevo e mamkanuk iji bu una kia, Ja kafu e ijefuon vuak fuon ijar oijon iji fun kam karoidiain. ");
INSERT INTO nvm_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ja vierafega e Ferisis ijiga e mamkanuk igi roin buba una fu ma vierafev? ");
INSERT INTO nvm_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","E iji nigen ka ba mukoi vierafejo iji bu kafu e Mosison akaij iji buba jajiav ijefuon bu uri e ijin ma vierafej. Bu ijegredo rad God fu bu kam unam ise ijia arafiriakno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","53","Bu ijeg kuaivga Nikodimas e iji fu tavan be naki ijia ro Jesuk fine vuak kuainma ijar uri kia, No akai nuvuon ijia kuainma iji noka amur e iji no kege vajai fian vajiakrejo ijiebuon vuak irerag bu isema rejo ijefuon anej ma iji faikfuon. Regavo rad ijar no bu kege vajai fian vajiakva iji fu markno kiain. Nikodimas fu ijeg kuardiamga e mamkanuk ijiga e Ferisis iji bu madu uri kua, A ijeg kuaimdo ak a kafu e Garerikor. Ni Godon buk akaij iji bu usuibe isoinva ijia dame ga. A ijia dame gabatie a ga e iji fu Godon vuak vierafene kuaimon iji fu ai Gareri ijia ruakma bano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Areme e fok bun una ar buon ijia vakga Jesu fu roin una uruor be Orivs kuavo in oriv ijesugin nainma ijia ajie vain. ");
INSERT INTO nvm_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Fu ijia vainma suok ijia fun una Godon ar bu sirimamejo makaf ijia ruain. Fu ijia rokga e uruvana bu biom fu dab kirakuravga fu ijia arifine e iji vuak nijaidiain. ");
INSERT INTO nvm_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Fu ijia vuak nijaidiakoga e Ferisis roin ga e Mosison akai nijaidiavo iji roin bu bara be fu baru turamon iji afeme ijia ruain. Bu ijia usem kuava fu e fok ijiebuon nifak ijia manin. ");
INSERT INTO nvm_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Fu maniga bu uri Jesu kua, E nijaidiamo no gaga bara gari fuka bara befuon baru turamga no iji game afem ruain. ");
INSERT INTO nvm_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Regavo akai nuvuon iji Mosis fu abedema iji bara ijeki iji no mun tuame kaniaga bu aoik revo iji a izeg vierafenmano kuain? ");
INSERT INTO nvm_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Regavo vuak iji bum ijeg kuardaga are Jesu fu uri ijia vuak isema kuardiaga bu rad fu tokuai ijefuon bu ijeg kuardain. Regavo Jesu irerag bu rejo iji fun vierafen ijefuon fu daime imut fuon ijia sakin ijia isoin. ");
INSERT INTO nvm_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bu duna ijeg ireme Jesu kuardavga fu uri ninuime kia, E guri ja irenva ijia e besum erar fu vierafega fu ise be fuba regakva nin amur uri mun guri kege bara gari kanafno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Fu ijeg kuardiame vo fu una madu daime imut fuon ijia sakin ijia isoin. ");
INSERT INTO nvm_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Fu isoikoga e iji bu vuak iji faime bun isuarigia besubesum vakga Jesu ko bara ijek bu ijia areme vain. E makin ijieb amur vako e roin iji bu rad vain. ");
INSERT INTO nvm_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Bu vako Jesu fu uri ninuime una bara iji kua, E guraiji irenva kafo bube vek ise on ijefuon kuaime kanakuai irenvano kuain? ");
INSERT INTO nvm_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Jesu fu ijeg kuamga bara iji fu una kua, E iji bun vabarenvano kuain. Fu ijeg kuamga Jesu fu kua, Nak naba a arafirak. Ijefuon a vakma ab una ise ijekin kafo rekno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ijegreare Jesu fu una madu e Ferisis iji kuardiame kia, Naiji na e moikigia oijo ijiebuon sanainma ijin. Eraneb bu na kegoijo ijeg bu rad nun ijia mimatame kegokva buba nakinma ijia ok. Regavo madu buka sanainma nun iji fu tavan bog ijia navako iji abekno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Fu ijeg kuardiamga e Ferisis iji bu uri kua, A ijeg kuaimon iji no vierafe aka kufuimen. A vuak on a vierafenma a iji dab no kuarduom ijefuon no vierafe vuak on iji fuka ma bano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Bu ijeg kuardavga Jesu fu kia, Na vuak nun igi na koiknu kuardiavo iji na koiknu vierafega naka ma kuardiav. Ijefuon maiji na izia ruain ga madu na izia vakfuon iji nan vierafen gavo jaiji jaka ba vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Regavo ema igi jar jon izeg ja karine una e kafobuon ise iji ja giavo iji jaka isema rej. Ijefuon maiji jaba amarigia vierafeknum ise buon iji giav. Regavo na nunkua na iviakma e kafobuon ise iji na ijeg giavo bakin. ");
INSERT INTO nvm_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Regavo na ebuon ise kafo giame kuaikva iji na aresredo na ijeg rek. Ijefuon maiji nam nar ebuon ise iji giavo bakin revo na Asoinun fu na kiema na ruainva iji na fusik ise iji giav. ");
INSERT INTO nvm_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Regavo madu bun usuibe buk akaij ijia ijeg isoi, E nokarok (2) bu e mamkanuk ijiebuon nifak ijia ireme vuak ni besum abe kuaikva vuak buon buka ma ijesugin kuaik. ");
INSERT INTO nvm_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Regavo vuak nun igi na kuardiaoijo iji naka ma kuardiav. Regavo madu Asoinun fu na kiema na ruainva iji fuk vuak irerag fu nuisina kuardiamo iji fu ma kuardiamno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Jesu fu ijeg kuardiamga e iji bu uri kua, Regavo Asoion fu izer fino iji nijaiduomne kuain. Bu ijeg kuavga Jesu fu kia, Ja na jaba ma vierafenva ijefuon ja Asoinun iji jaba vierafen. Revo ja na ma vierafebatie ja Asoinun iji madu ma vierafekno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesu fu Godon ar bomana guf ijia aru mavua be bu mon God vajavo iji savo ijia manine vuak ijeg kuardiain. Fu ijia manine vuak ijeg kuardiain gavo buba uri fu kanain vo ire kafo fuon ren. Ijefuon maiji tavan fuon fuba aben ijefuon bum karine vuak fuon ijesugin fadain. ");
INSERT INTO nvm_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Areme Jesu fu una madu kia, Naiji na oinevo nan vak. Na vakva ja uri na nisaidiek revo jaka ise jon ijekma mukoi aoik ijefuon ja ar na vako ijia jaba vuakno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ijefuon Jius e mamkanuk iji bu kuai, E iji fu kuai ja ar na vako ijia jaba jajie vuakno kuainma iji fu irerafuon ijeg kuaim? Fu kafu fui kananamikafa fu ijefuon ijeg kuain. ");
INSERT INTO nvm_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesu fu ijeg kuardiame una kia, Jaiji ja e moik igekor gavo naiji na e kaf gufekor. Regavo madu jaiji ja e moik igekor ga naiji na e moik igekor bakin. ");
INSERT INTO nvm_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ijefuon na iji kuardiame kia jaka ise jon ijekma mukoi aoik. Jaba ma vierafero naiji na e iji God fu kuai fu ruakno kuainma jaba ijeg vierafekva jaka ise jon ijekma mukoi aoik. ");
INSERT INTO nvm_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Jesu fu ijeg kuardiamga bu uri kua, Regavo aiji a erar iji ni samakaf kuarduoga no faivno kuain. Bu ijeg kuavga fu kia, Na ik vuak na kuardiainva ijia naiji na era iji nan kuardiain. ");
INSERT INTO nvm_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Na e moikigia ise jon iji ja reoijo iji fine giaknum ga ijefuon ja kuardiakva iji fuka uruvana. Regavo e iji fu na kiema na ruainva iji vuak fuon fuka ma. Ijefuon na e moikigia oinva ijin irerag fu kuardienma na ijesugin abe kuardiavno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jesu fu Asoifuon ijefuon fu ijin kuardiain revo e iji buba mukoi fain. ");
INSERT INTO nvm_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ijefuon fu uri kia, Tavan iji ja Ema ijiebuon Farif iji abe uri kaf ajiekva ijia ja ma vierafek. Ja vierafero naiji na e iji God fu kua fu e fok karaunia ruakno kuainma ijinro ja ijeg vierafek. Rega ja ijia vierafero irerag igia na reoknum kuardiaoinva iji na nun vierafenva ijia kuardiaoijo bakin. Regavo na Asoinun irerag fu nijaidienma na ijesugin kuardiaoijoro ja ijeg vierafek. ");
INSERT INTO nvm_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Regavo Asoinun iji fu kiema na ruainva iji fuba na unieko vain. Ijefuon maiji tavan bog irerag na reoijo iji na fu oimarkfuon ijia reoijno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Fu ijeg kuardiamga e roin bu Jesu vuak iji fu kuardiainma iji faime buka una fu ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ijefuon Jesu fun uri e Jius iji bu fu ma vierafenva iji kia, Ja vuak nun iji na nijaidiavo iji faime igiekva ja ma e vuak nun faivo iji rek. ");
INSERT INTO nvm_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ja vuak ma abe ma vierafega vuak ma ijar ise jon bu ja tomdiainva ijia karauniakno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Jesu fu ijeg kuardiamga bu uri kua, Noiji no e Eburamon uifarif ijefuon e be fuba no aferduome kam irerag fu vierafenma ijesugin kuoga no faime renva bakin. Regavo a irerafuon kuai, No ma iji abe ma vierafekva ma ijar ise nuvuon iji bu no tomduinva ijia karaunuokno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Areme Jesu fu uri kia, Vuak igi naka ma kuardiav eraneb bu ise reoijo iji bun ise ijar aferdiaga bu una fuifuon ikrej. ");
INSERT INTO nvm_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Regavo ni igia fai. Ja ise ijar tavan bog ja samuagdakma iji ja izeg oimarknum dazme karikva bakin. ");
INSERT INTO nvm_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Regavo ja Godon Farif ijar fu ise jon bu ja tomdiainva ijia karauniakma iji ise jon iji fu izeg una ja tomdiakva bakin. ");
INSERT INTO nvm_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ja e Eburamon uifarif iji nan vierafen gavo jaka na kaniekuai oij. Ijefuon maiji ja vuak nun igi na nijaidiavo iji jaba mukoi faime abej. ");
INSERT INTO nvm_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Regavo madu na Asoinun irerag fu nijaidienma na ijin abe kuardiav gavo jaiji ja vek una asoijon Setan irerag fu nijaidiainma ja ijin rejno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Fu ijeg kuardiamga bu uri kume, No asoinuvuon iji fu Eburamno kumen. Bu ijeg kumejga Jesu fu uri kia, Ja Eburamon afijafbatie ja irerag fu reoinma iji jak ja ijeg rek. ");
INSERT INTO nvm_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","41","Regavo iji jaka bakin ja vek una na kaniekuai vierafen. Ijefuon maiji na vuak ma iji God fu kuardienma ijin na abe kuardiainva ijefuon ja iji kaniekuai vierafen. Regavo e Eburam fuba ijeg ren revo iji ja rejo iji ja asoijon Setan fu reoinma ja ijegreoijno kiain. Fu ijeg kuardiamga bu uri kua, Noino am oij bakin revo no Asoinuvuon iji fun God fuonkua revo noino ma afijafno kumen. ");
INSERT INTO nvm_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Bu ijeg kuardavga Jesu fu uri kia, Ja God fu ma Asoi jonbatie ja na oijmiek. Ijefuon maiji fur na kiema na ruainva ivia na nifak jon igia manij. Na ari ruainva iji nam nar daro nun ijia ruainva bakin revo fun Godri kiema na ruain. ");
INSERT INTO nvm_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Regavo irerafuon ja vuak igi na kuardiavo iji jaba mukoi faiv? Jaba faivo ijefuon maiji jaba vuak faikuai ijefun rej ijefuon ja vuak asur ma nun iji jaba mukoi faiv. ");
INSERT INTO nvm_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ja asoijon Setan e kaven ise ijin ijefuon ja uri asoijon ijefuon fuon fu vierafeno ijia reokuai vierafen. Ik anej ijia fuiji fuka e kaniaga bu aoivo gavo fuba una vuak ma iji jame unam ma ijesugin reoin. Ijefuon maiji fu oifuon ijia fu vuak ma iji vierafene ijia reoino bakin. Fu vuak kufui kuaimon ijefuon maiji fu e ir kufuikin ga madu fuiji fu e kufuimeoijo ijiebuon asoij. ");
INSERT INTO nvm_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Vuak igi naka ma kuardiavo ijefuon jaba una na ma vierafej. ");
INSERT INTO nvm_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Regavo ni erar uri ise be na irerag iji reja fu gienma ijia kuardie na faiv. Regavo ja vierafega na vuak ma kuardiaga ja irerafuon ba na ma vierafev. ");
INSERT INTO nvm_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Regavo erar fu vierafega fun Godon e renma iji fur Godon vuak igi na kuardiavo iji fu mukoi faim. Regavo jaiji ja Godon e bakin ijefuon ja vuak fuon igi na kuardiavo iji jaba mukoi faivno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Areme e Jius iji bu uri kua, Regavo a vierafega igi no kuai a iji a e Sameritenko ga madu a kaven ise ijar a niroinmano kuainva iji kafu no ma kuainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Bu ijeg kuardavga Jesu fu kia, Naiji kaven ise ijar na niroikienma bakin. Naiji na Asoinun iji abe aroiv revo jaiji ja na arordievo bakin. ");
INSERT INTO nvm_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Naiji na koiknu nun sanainma iji abe aroikafie vierafejo bakin revo fun e besum fur fine nun sanainma iji abe arordiem. Regavo madu fur fine e fok no kege besum name guom. ");
INSERT INTO nvm_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ijefuon na ma kuardiav erar vuak nun igi mukoi faime igiakma e iji fuba guak. ");
INSERT INTO nvm_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jesu fu ijeg kuardiamga e Jius iji bu uri kua, Iviakma no samakaf gainva iji no vierafe aiji aka kaven ise ijar a nirokain. E Eburam ga e Godon vuak vierafene kuaivo iji bun aoim baren revo a una kuaimon erar vuak nun igi faime igiekva buba aoik. ");
INSERT INTO nvm_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","A vierafe Eburam fu e buze gavo ar a e ikin? Eburam fun guain revo madu e Godon vuak vierafene kuaivo iji bun aoim baren. Revo aiji a era aikido a vuak ijeg kuaimno kuain? ");
INSERT INTO nvm_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Bu ijeg kuardavga fu kia, Na uri koiknu nun sanainma iji abe aroikva iji na vierafe fuba marek. Regavo e iji fu nun sanainma iji abe arordiekfuon iji fun Asoinun e iji ja kume fuka God jonno kumejo ijar fuonkua arordiek. ");
INSERT INTO nvm_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Jaiji ja Asoinun iji jaba vierafen ga nar na fu vierafen. Revo na ivia igia kiak na fu naba vierafenvano kiakva iji na ja kuaivo ijeg naka vuak kufui kuardiak. Regavo na fu nan vierafen revo vuak fuon iji na igiav. ");
INSERT INTO nvm_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Regavo asoijon Eburam fu tavan iji bu na nafediekfuon fu iji gakro uruvana vierafen. Regavo fu ma vierafega na moikigia roko ijefuon fu tavan iji gainma igeg fu ma vierafene bomana oimarenmano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Fu ijeg kuardiamga bu uri kua. A juaivasia on iji fu bomana bakigavo a kume na Eburam nan gainvano kumen. ");
INSERT INTO nvm_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","59","Bu ijeg kuardavga fu kia, Vuak igi na ma kuardiav Eburam bu rad nafen gavo naiji nan ur ijia firuainvano kiain. Fu ijeg kuardiamga e Jius iji bu vuak iji vierafega buba aresren. Ijefuon bu uri mun tuame Jesu kanakrejga fu Godon ar bomana iji areme fun keko vain. ");
INSERT INTO nvm_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ijegreare Jesu fu oine e be ni zuriaigin nafenva fu fino iji fu keko gain. ");
INSERT INTO nvm_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Regavo e vuak fuon faivo iji bu uri Jesu kua, E nijaidiamon a vierafe e guri ni fu zuriainma iji fu ise fuon fu renma ijar ki fu eofijaf ijiebuon ise ijar fu ni zuriainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Bu ijeg kuardavga fu kia, E guri fu ni zuriainma iji fu ise fuon ijiga eofijaf ijiebuon ise ijar fu ni zuriainma bakin. Regavo ni fuon iji fu ijeg zuriainkin rad fu una ni naraga e fok bu ijia Godon daro iji fu izeg ikreno iji gakuai fu ijefuon ni zuriain. ");
INSERT INTO nvm_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ijefuon noka migegare tavan igi fu vek sanainma igia no e iji fu kienma na ruainva ijefuon ik ijin rekfuon. Regavo no saroike fu tavan nakikma fu erar izeg naki ikrekma bakin. ");
INSERT INTO nvm_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Regavo na vek moikigia oijo ijefuon naiji na moik igefuon sanainma ijino kiain. ");
INSERT INTO nvm_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","7","Fu ijeg kuardiame uri juvit foine abe sakin ijekma ujumujume abe e iji ni zuriainma ijefuon niom ijia azimdain. Areme fu uri kua, Ni va do Sairom bu kuavo iji nafuinma ijia uikinik on abe do ijia somne kuain. (Revo vuak Sairom ijefuon anej ma iji, Fu kuama fu ruain). Ijefuon e ni zuriaigin iji fun va do iji Jesu fu kuainma ijia uikinik fuon iji abe ijia somga ni fuon iji fun una naramga fun una ar vain. ");
INSERT INTO nvm_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Fu una vakga kaifijaf ijigam e roin bu ur fu ni zuriaigin fu e ire nimdiamon bu gainva vo fu una ni narainma ijefuon bu uri kuai, E iji fu kafu e ni zuriaigin iji fu unam ijia oknum ire nimdiamo ijarno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Regavo e roin bu kuai, Iji furno kuain. Regavo roin bu usem kuai, E iji fu e be gavo uikinik fuon iji fu e ni zuriaigin iji aikino kuain. Bu ijeg dab bui kuaivga e iji ni narainma iji fu kia, Na e ni zuriaigin iji ja ur gienva iji narno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Fu ijeg kuardiamga e iji bu uri kua, A ni on iji a irerag abega fu una naraimano kuain? ");
INSERT INTO nvm_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Bu ijeg kuardavga e iji ni narainma iji fu kia, Na e be bu kua Jesuno kuavo ijar sakin numume niom nun ijia azirdien. Fu azirdieme kie, Ni va do Sairom kuavo ijia ruaimne kiemga na va do ijia uikinik nun iji do ijia ruaivga ni nun iji fu una naraimano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Fu ijeg kuardiamga bu uri kua, Regavo e iji fu izerkino kuavga fu kia, Na e iji fu ni nun iji amardieme fu una izeg vaka naba gainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Rega bun e iji ni narainma iji afeme una e Ferisis ijiebuon vain. ");
INSERT INTO nvm_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Regavo tavan iji Jesu fu e ni zuriaigin ijin sakin numume ni fuon iji amarema fu una ni narainma iji fu tavan iji e Jius bu isuar karijo ijia fu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ijefuon e Ferisis iji bun madu una usem e iji fu izeg ni fuon iji fu una narainma ijefuon kuardain. Bu kuavga fu kia, E iji fu sakin ijia numume ni nun ijia azirdieme areko na do ruaivga ni nun iji fu una naraimano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Fu ijeg kuardiamga e Ferisis roin bu vuak iji faime bu una kuai, E iji fu tavan iji no isuar karine Godon sirimamejo ijefuon akaij iji fuba jam. Ijefuon no vierafe e ijegreoino iji fu Godon ruainma bano kuain. Regavo e roin bu kuai, E ijeg ise reoino iji fu izeg ire sumakin ijekin iji rekno kuain. Bu ijeg kuaime dab ata roinroin ireme bui musikuain. ");
INSERT INTO nvm_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ijefuon e Ferisis iji bu una e iji kua, A kuo na Jesur ni nun iji amardiama na una ni naraivano kuin. Regavo a e iji fu ijeg redainma iji a izeg vierafenmano kuain. Bu ijeg kuavga fu kia, Na vierafe e iji fu e Godon vuak vierafene kuaimon ijino kiain. ");
INSERT INTO nvm_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","20","Fu ijeg kuardiain gavo e Jiusbuon e mamkanuk iji bu e iji bu ni zuriaigin nafegavo fu una ni narainma iji bu vek ba ma vierafen ijefuon bu una eofijaf iji kiava bu aferdia ruain. Bu rokga e mamkanuk iji bu uri kia, Am igi fube amjon? Ja iviakma igia kuok non ijeg ni zuriaigin nafenvano kuokva nin fu izegrega ni fuon iji fu una narainma ijin kuarduo no fai. Bu ijeg kuardiavga eofijaf bu kia, Am guri fu farinuvuon no ni zuriaigin nafenva ijin no vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Regavo erar izegrega fu ni narainma iji noba vierafen. Regavo madu fu erar ni fuon iji amarema fu una narainma iji noba gain. Revo fu am ukak bakin ijefuon ni kuaga fu koikfuon vuak ma iji kuardiamno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Regavo eofijaf iji bu Jiusbuon e mamkanuk iji juinva ijefuon bu ijeg kuardiain. Ijefuon maiji e Jiusbuon e mamkanuk iji bun ur kuai, Erar bu kuaik Jesu fu e iji God fu kuamga fu ruainma ijino kuaikma e iji bu kuriairega bu rad buba una ar iji e Jius bu afuime vuak kuaivo ijia aru vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ijefuon e ni zuriaigin ijefuon eofijaf iji bu kuardiavga bu kia, Fu am uka bano ni kuaga fu koikfuon izeg fu ni narainma iji kuardiamno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ijefuon e Jius iji bun madu una e ni zuriaigin iji fu ni narainma ijin kua, No vierafe e iji fu ni on iji amardainma iji fuka ise reoino ijefuon a iviakma Godon if ijia kurame vuak iji ka visume kuarduomne kuain. ");
INSERT INTO nvm_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Bu ijeg kuardavga e iji fu kia, E iji naba gain kafu ise reoino kafu bakin. Regavo naiji na ni nun igi fu ur zuriain revo iviakma na una ni narainva na ijesugin vierafenvano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Fu ijeg kuardiamga bu kua, Regavo e iji fu a irerag redain vo fu izegredamga ni on iji fu una narainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Bu ijeg kuardavga fu kia, Vuak iji nan amur ja kuardievga nan kuardian revo jaka ba fain. Ja irerafuon una madu faikuai vierafej? Jakafu jak ja una e vuak fuon faivo iji rekuai vierafenvano kiain? ");
INSERT INTO nvm_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","E iji fu ni narainma iji fu vuak ijeg kuardiamga bu uri musikuame kua, Noiji no e Mosison vuak faivo gavo ar a e ijefuon vuak faimno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","No usuibe God fuka samakaf Mosis kuardaga fu faimo ijar no vierafe fu ma. Regavo e iji a kuaimo iji fu izia ruainma iji noka ba vierafenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Bu ijeg kuardavga e iji fu uri kia, Vuak iji ja kuaivo iji na faiga fuka oiserdiem. Fu izia ruainma iji jaka ba vierafen revo fur ni nun igi abe naradien. ");
INSERT INTO nvm_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Regavo non vierafe God fun e ijeg ise reoijo iji vuak buon fu faimo bakin. Regavo fu e guri bu tavan bog fuon sirimameknum ga irerag fu vierafenma ijia reoijo fu vuak buon iji faimon. ");
INSERT INTO nvm_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Regavo ik anej moikigi amarenva ijia e be fuba ijeg e ni zuriaigin iji amardiamga bu una ni narainva bakin. ");
INSERT INTO nvm_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Regavo e iji na kuaivo iji fuba Godon ruainmabatie fu izeg ire sumakin ijekin iji rekma bano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","E iji una ni narainma iji fu ijeg kuardiamga bu una kua, E guri ka vek ijia ise ijekma nafenva gure a vierafe a no nijaiduokreno kuain. Bu ijeg kuardame ka kuriaireme dakara dab makaf ijia akozva fu ar iji bu afuime vuak kuaivo iji areme keko vain. ");
INSERT INTO nvm_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Rene rad Jesu fu Jiusbuon e mamkanuk iji bu izeg e iji fu amarenma iji bu fu fak renva iji fain. Ijefuon fu tavaibe una e iji bieme kua, Abe Ema buon Farif iji na ma vierafenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Jesu fu ijeg kuardamga e iji fu una kua, Ni e iji era iji kuardiega na fu ma vierafejno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","E iji fu ijeg kuardamga Jesu fu kua, E iji an gainma ijin. Fur iviakma igi manine osik vuak kuaimno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Jesu fu ijeg kuardamga e iji fu uri Jesu ato same kurituamajame kua, E Bomana iviakma nan a ma vierafenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Fu ijeg kuardamga Jesu fu kua, Na moikigia na ari ruainva iji na e iji bu Godon unam buba gavo iji ifejdiaga bu gakuai na iji ruain. Regavo madu e iji bu vierafero bu Godon unam bun gavno kuain revo buka ba gavo iji ifejdiaga bu una ise buon samakaf giame vierafekro na iji ruain. ");
INSERT INTO nvm_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jesu fu vuak ijeg e iji kuardamga e Ferisis roin bu ijia irevado bu vuak iji faime una Jesu kua, A ijeg kuaido no kafu ni zuriaigino kuain. ");
INSERT INTO nvm_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Bu ijeg kuardavga Jesu fu kia, Ja ni zuriaiginbatie ja ise iji jaba rekfuon revo ja kuai no ni zuriainva bano kuaivo ijefuon ise jon iji fu vek ijeg namo kiain. ");
INSERT INTO nvm_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Areme Jesu fu kuardiame kia, Naka ma kuardiav e iji fu maf-sif ijiebuon vien iji bu amarenva iji fu aregavo fum maikava ijia ajie urame aru vako iji fun e niesamo ga madu fu e kaniamon. ");
INSERT INTO nvm_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Regavo e iji fu maf-sif buon vien ma ijia arume vako ijar fu ma e maf-sif samuagdiamon. ");
INSERT INTO nvm_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Fu vaga e iji vien samuamo iji fu vien iji dajadaga fu arume maf-sif fuon ijiebuon if ijia kumeko bu faime usem jaga fu aferdiame keko makaf ijia vak. ");
INSERT INTO nvm_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Fu aferdia keko amur kiaknum vako bu ijia jav. Ijefuon maiji bun ir fuon iji mukoi faime vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Regavo bu e be buba ja vak ijefuon maiji bu ir fuon bu faivo bado bu faikva buka subinai vak. ");
INSERT INTO nvm_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesu fu vuak iji abe bija ijeg kuardiain gavo e iji bu vuak iji fu kuainma ijefuon maiji buba mukoi faime vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","8","Areme Jesu fu una kuardiame kia, Na ma kuardiav na iji na maf-sif ijiebuon vien ijin. E iji roin bu amur ruainva iji bu e niekin ga madu bu e kaniavo. Regavo buiji e maf-sif samuagdiavo bakin ijefuon maf-sif iji bu ir buon iji buba fain. ");
INSERT INTO nvm_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Regavo naiji na vien ma ijin. Erar fu nun ruakma fu vien ma ijia arume ar nun ma ijia vak. Fu aru ruaknum vo una keko va duok ma iji ijknum ijeg rek. ");
INSERT INTO nvm_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Regavo e niekin iji fum niesaknum vo maf-sif iji kam arafiriaknum kaniakafa fu iji rok. Regavo naiji na ruainva iji na ma karivako iji abe miaga ja abenkin jam tavan bog ijia oimarknum ma karivakro na iji ruain. ");
INSERT INTO nvm_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ijefuon maiji na e maf-sif mukoi samuagdiamo iji nar oimarknum maf-sif nun ijiebuon guak. ");
INSERT INTO nvm_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","E iji fu maf-sif fuon bakin gavo fum e ijieb kuaga fu samuagdiamo iji fu monfuon ikreno ijefuon fuba mukoi samuagdiak. Ijefuodo fu siroij iji maf-sif jakiamo ijar ruakma fuka jume kovak. Fu vake siroij iji fu urame maf-sif iji jakiame buaseknum kam arafiriakva bu subinaime dab tata vak. ");
INSERT INTO nvm_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","E iji bu kuaga fu maf-sif samuagdiamo iji siroij ruakva fuka kovak. Ijefuon maiji maf-sif iji bu fuon bado fuba amarigia maf-sif iji mafardiame samuagdiak. ");
INSERT INTO nvm_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Regavo naiji na e maf-sif mukoi samuagdiavo. Asoinun iji na fun vierafen gavo nak na Asoinun iji nan vierafen. Unam besum ijeg maf-sif nun iji na bun vierafen gavo nak bu nan vierafen. Ijefuon na oimarknum buifuon guakafie vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Maf-sif roin bu nun revo bu tata oij ijefuon iviakma buba fak uf igia oij. Ijefuon na vierafe maf-sif iji naka aferdia roga bu besum ireke na nunkua samuagdiake bu ir nun ijesugin faik. ");
INSERT INTO nvm_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Asoinun iji fu na oijmiemo ijefuon maiji naka koiknu buifuon guakafie vierafen. Na guainkin rad fu kiega na una uri ijia fivak. ");
INSERT INTO nvm_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Naiji fu erar na dab kaniekma bakin. Regavo naka koiknu vajai nun igi abe ijia nijaidiaga bu kanie na guak. Na e darokin ijefuon bu kaniega na guame rad na daro nun ijia una urik. Regavo iji fun Asoi nun iji fu kiema na ruainva ijar na ijegrekfuon fu iji kuardienmano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Rega e Jius iji bun madu Jesu vuak iji fu ijeg kuardiainma ijefuon bun dab bui kuaime dab ata roinroin ren. ");
INSERT INTO nvm_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","E uruvana roin bu kuai, E iji kafu kaven ise ijar niroin kafu nigen iseren. Regavo ja irerafuon vuak fuon iji faikuai dab uruvana vierafejno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Regavo roin bu kuai, E kaven ise niroinma iji fu izeg vuak ijekin kuaimokma bakin. Regavo fu madu izeg e ni zuriaigin iji amardiaga bu una ni narakva bano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Areme tavan iji ve damo ijia e Jius fok bun una Jerusarem ijia afuin. Bu Godon ar bomana vien iji bu dajainva ijefuon tavan ijia oimardaknum iro bomana be in. ");
INSERT INTO nvm_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Bu ijegrejo ijia Jesu fu Godon ar bomana ijefuon makaf be bu kua Soromonon banadno kuavo ijia arume oin. ");
INSERT INTO nvm_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Fu ijia oga e Jiusbuon e mamkanuk roin bu game usem fu manino ijia irem ameoine kua, A ivez son amarigia kuarduoga no a oinon ijefuon anej ma iji vierafek? No if on iji a era ga madu a erar kuaga a ire sumakin kafokafo reoinon iji noka ba vierafen. Ijefuon a vierafega a Godri kuamga a ruainmaga nika samakaf kuarduoga no faiv? ");
INSERT INTO nvm_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","26","Bu ijeg kuardavga fu kia, vuak iji naka ur kuardiain gavo jaka vek ba ma vierafej. Na Asoinun ijefuon daro ijia na ire sumakin iji rej. Ijefuon ja ire iji na rejo ijia giame una na ma vierafekfuon revo iji jaka bakin. Ijefuon maiji jaiji maf-sif nun bakin. ");
INSERT INTO nvm_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Maf-sif nun iji nan vierafen ijefuon na kiakva bu ir nun iji faime una na jajiek. ");
INSERT INTO nvm_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Bu jajie roga na unam ma karivako iji abe miainkin buba aoigavo bu ijia ma karivak. Regavo e kafo buba maf-sif nun iji na samuagdiavo iji kafo imut nun ijia kuniai turame aferdia usem vakva bakin. ");
INSERT INTO nvm_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","30","Ijefuon maiji asoinun iji maf-sif iji fu kege vajienma iji fuka darokin ga fur ire fok asidiain. Ijefuon fu erar fu asime maf-sif fuon iji kafo imut fuon ijia kuniai turame aferdiame usem vakva bakin. Ijefuon asoinun ijek irerag no rejo iji fuka besumno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","32","Jesu fu ijeg kuardiamga e iji bun una madu mun tuame kanakrejga fu kia, Na ire sumakin uruvana ka mukor iji ni jon ijia reoija jan gien. Regavo ja vierafe ire sumakin iji na reja ja gienva iji irerag ijar fuka isediaga ja iji kaniekuai reoijno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Fu ijeg kuardiamga bu kua, No ire ma sumakin uruvana a renma ijefuon kanakrejo bakin. Regavo ar koikon Godon if iji abe buze imo ijefuon no iji ijeg rej. Aiji a ema igi no aikin gavo aka koikon dab God aikin amaremno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Bu ijeg kuardavga Jesu fu uri kia, Usuibe buk iji bu vuak akai isoinva ijia God fu vuak be e igi nuvuifuon kuaima bu isoinva iji bu ijeg isoin. God e igi no fu kuo jaiji moik igefuon godno kuin. ");
INSERT INTO nvm_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Regavo vuak iji bu isoinva iji no vierafe fuka ma fu izeg barekma bakin fu ijia navak. Ijefuon God fu e iji bu vuak fuon ma iji faivo iji fu kia, Ja moik igefuon godno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Regavo naiji na asoinun ijar na fu vierafen ijefuon fu kiema na moikigia ruain ga ja irerafuon kie a Godon if iji abe buzemno kiev. Ja kafu igi na kia naina Godon Farifno kiainva ijefuon ja ijeg rej. ");
INSERT INTO nvm_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Regavo ja giega na Asoinun ijefuon ik iji naba kegoijga ja ijefuon naba ma vierafekva iji fun ijin. ");
INSERT INTO nvm_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Regavo ja giega na asoinun ijefuon ik iji nan reoin gavo jaba na ma vierafejgakva nin ire sumakin iji na rejo ijia gieme una na ma vierafef. Ja ijegrekva ja ijiason una ma vierafero asoinun ijek irerag no rejknum kuaivo iji no besum ro ja ijeg vierafekno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jesu fu ijeg kuardiamga e iji bun una madu kunaim tokrejga fu giame isuar ar iji areme vain. ");
INSERT INTO nvm_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Fun Jerusarem areme una madu do Jodan vajame gara ar iji e Jon fu e do ruardiamo ijia fiokafa vain. ");
INSERT INTO nvm_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","42","Fu ijia vako e uruvana bu biom fuon ruaknum kua, E Jon fu ire sumakin kafo fuba rena no gain revo vuak irerag fok fu e garefuon fu kuarduinma iji fuka mano kuain. Areme e ka uruvana bu ijia una fu ma vierafene kuai, E iji fu ma e iji God fu kuai fu ruakno kuainma ijino kuain. ");
INSERT INTO nvm_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Regavo ai Beteni ijia e Rasaras kuavo ijar adam ka bomana aben. Regavo ai Beteni iji fu bara Mata ko Merik buon mai. ");
INSERT INTO nvm_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Regavo Meri iji bara iji fu oir udi mukoi urino iji fu abe Jesuon diak ijia useme some nigen fuon jau ijia abe fidainma ijin. Bara ijefuon makin e Rasarasno kuavo ijar adam aben. ");
INSERT INTO nvm_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Fu adam abene fuka guakvega makifijaf ijieb uri Jesu vuak nijame kume, E Bomana kaion a oijmamo iji fuka adam bomana abenmano kumen. ");
INSERT INTO nvm_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Bu vuak ijeg Jesu nijavga fu faime uri e vuak fuon faivo iji kia, E Rasaras fu adam aben ga na vierafe fu guame una uriga e bu ijia izeg Godon daro fu ikreno iji game una fu abe aroivknum vo Farif fuon igi na arordiekno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Regavo Jesu fu Mata ga Meri ga makin fuon Rasaras iji fuka bomana oijmiamo. Ijefuon Rasaras fu adam abenma ijefuon vuak iji bara nokarok (2) bu nijainva iji fun fain gavo fuba ijia vain fu magaga una madu naki nokarok (2) ijia fin. ");
INSERT INTO nvm_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Fu ijia fine rad fu una e vuak fuon faivo iji kia, Ruano una ai Judia vakno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Fu ijeg kuardiamga bu una roin kua, E Nijaidiamo ai Judia a una vakveno iji e Jius iji bu nito igem bu mun tuame kanakveja a ijefuon uri igia ruain. Regavo iji aba vierafe gavo a una madu ijia vakafa vierafenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Bu ijeg kuardavga fu kia, Tavan iji fuka jaoijmanak manine sanam. Ijefuon e iji fu tavan ijia oinon iji fuba arikanak ijefuon maiji fu moikigi fu sanainma ijia oin. ");
INSERT INTO nvm_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Regavo fu naki oinon iji fuka dia kam ire kafo nizukiak. Ijefuon maiji ire sanamo be fu bado fu izeg ai ni nisaime okma bakin. ");
INSERT INTO nvm_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jesu vuak ijeg kuardiame uri e vuak fuon faivo iji kia, Kainuvuon Rasaras fu ninaido na vakva na saga fu una urikno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Fu ijeg kuardiamga e vuak fuon faivo iji bu una roin kua, E Bomana Rasaras fu ma ninaikma iji no vierafe fu una urikno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Regavo Jesu fu Rasaras fun ma guainma ijefuon fu iji vierafene kuain. Regavo e vuak fuon faivo iji bu vierafero fu ma ninainmaro bu ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ijefuon Jesu fu uri ka visu kuardiame kia, E Rasaras fun ma guain. ");
INSERT INTO nvm_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Regavo magoi noba ijia kariko fu guainma ijefuon iji fun maren. Fu ijeg guaga na va gafia kua fu una uriga ja ijia game una na ma vierafekno uri no fu gak vakno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ijegreare e Tomas e iji bu kua Fuatkaru nafenvano kuavo ijar uri kia, E fok roga no enuvuon E Nijaidiamo guriena vainkin no funa besum aoikno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Regavo Rasaras fun guamga bu abe mako ruinva iji naki nokarok ga nokarok (4) barko ijia Jesu fu Beteni ijia kekoma bu vuak iji kuardain. ");
INSERT INTO nvm_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Regavo ai Beteni fu Jerusarem samaij ijia ijefuon e Jius uruvana bu bara Mata ko Merik giakuai ijia ruain. Bara nokarok (2) iji bu makibuon guainma ijefuon buka oifian abenva ijefuon e iji bu bara iji ifejdiakuai ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Regavo Mata fu oifian abeknum fino ijia bu kua Jesu rokno kuava fu faime fu kekome unam gafia biekafa vain. Fu vako Meri fu vek ar gafia e ijiena fin. ");
INSERT INTO nvm_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Regavo Mata fun kekome va Jesu bieme kua, E Bomana a igia finobatie makin nun iji fuba ijeg guak. ");
INSERT INTO nvm_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Regavo ivia na vierafega a fuifuon irerag a God kuardakma fu rekno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Mata fu ijeg kuardamga Jesu fu kua, Makin on iji fun guain gavo na vierafe fu una uri okno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Fu ijeg Mata kuardamga fu kua, Na vierafe tavan radkma iji ruakma ijia makin nun iji fu una uri fivakno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Areme Jesu fu madu una Mata kua, Naiji na ma karivako ijiga aoime una urijo ijin. Regavo erar fu na ma vierafekma iji fu guak revo kaven ijia fu una ijia fivak. ");
INSERT INTO nvm_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Regavo erar fu nivek fine na ma vierafeno e iji fu ijia ma fivak. Ijegvo a vuak igi na kuardavo iji abe faime ma vierafen? ");
INSERT INTO nvm_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Jesu fu ijeg kuardamga Mata fu kua, E Bomana na vierafega aiji a Godon Farif. E iji bu kuai fu moikigia ruakno kuainva ijino kuain. ");
INSERT INTO nvm_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata fu Jesu ijeg kuardame fun va ar gafia kekome isuar Meri kuardame kua, E iji E Nijaidiamo iji fun ruainma gafaija oifuon kiemno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Fu ijeg kuardamga Meri fun migegare kekome Jesu biekafa vain. ");
INSERT INTO nvm_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Regavo Jesu fuba ar ijia kekoin revo fu vek unam gami Mata fu bienma ijia manin. ");
INSERT INTO nvm_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ijefuon Meri fu migegare kekome fu biekafa vakgame e Jius iji bu fu samua karinva iji bu gak fu vakga bu uri dab arafirin. Bu vierafero kafu gami makifuon ijefuon mako vien ijia niraikafa vakoro bu usem jain. ");
INSERT INTO nvm_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Meri fu vake gami Jesu fu manino ijia kekome uri ato same kua, E Bomana a igia fibatie makin nun fuba ijeg guak. ");
INSERT INTO nvm_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Regavo Jesu fu uri Meri ga e Jius iji bu niraivo iji giama fuka bomana oifiain. ");
INSERT INTO nvm_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ijefuon fu uri kia, Ja surif fuon iji ja abe izia mako ruinvano kiain. Fu ijeg kiamga bu kua, E Bomana no abe gafia mako ruinvano ni ro gamne kuain. ");
INSERT INTO nvm_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","36","Areme Jesu fuka oifiaima fu ijia niraimga e Jius iji ruainva bu ijia gain. Bu game una bui kuai, Ni garia gaf fuka Rasaras oijmamo ijefuon fu iji niraimno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Bu ijeg game kuaiko e roin bu kuai, Fu ur e ni zuriaigin iji amarema fu una ninarain. Regavo igi fuka igia fikin fu Rasaras ifejdaga fu una urikdo fuba igia fimano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Areme bu Jesu afeme vake mako iji Rasaras bu uname mun dab vien iji bijuinva ijin nijain. Bu nijaivga fu kekome mako iji gama fuka bomana oifiain. ");
INSERT INTO nvm_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ijefuon fu kia, Mun guri ja dab mako vien guri bijuinva ijin biom gareg abedefno kiain. Jesu fu ijeg kuardiamga bara Mata e iji guainma ijefuon makin ijar una roin kua, E Bomana Rasaras no dab unainva iji fuka naki nokarok ga nokarok (4) baren. Ijefuon no mun guri biom abedekva fuka udi ise rikno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Mata fu ijeg una kuardamga Jesu fu kua, Nabe amur kua a ma vierafekma Godon sanainma iji a gakno kuain? ");
INSERT INTO nvm_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Areme e iji bun uri mun iji dab biom ken ijia abeden. Bu abedevga Jesu fun gafeg varur gufia nikajaknum sirimamene kua, Asoinun na on sirimamega a faimo ijefuon na bomana on oimarev. ");
INSERT INTO nvm_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Na tavan bog on sirimamene a irerag na kuardavo iji a faimon. Regavo igi na sirimamejo ijefuon maiji na e igi irenva ijiebuon na iji sirimamej. Na on sirimamega a faime irerag na kuardavo iji rega bu ijia game una ma vierafero naiji ar kiema na ruainvaro bu ijeg vierafek. ");
INSERT INTO nvm_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jesu fu ijeg sirimamene barme uri e iji bu unainva iji uruvana igia nizume kuai, Rasaras una keko ro. ");
INSERT INTO nvm_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jesu fu ijeg kuamga e iji bu dab ugon ijia anume unainva iji fu una ijekma kekoin. Fu anugma una keko rokga Jesu fu uri kia, Ugon gari ja dab anudainva iji iramdafno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Areme e fok bu Mata ko Merik giakuai ruainva iji bu Jesu ire sumakin iji fu renma iji game buka una fu ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Regavo e roin bu Jesu ire iji fu rena bu gainva ijin una va e Ferisis iji kuardiain. ");
INSERT INTO nvm_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ijefuon e Ferisis ijigam e mamkanuk Godon isuf baroijo iji bun e mamkanuk roin ijiena afuime vua kuain. Bu kuai, No e iji fu ire sumakin ka mamkanuk iji fu reoinon iji no fu abe izeg rek? ");
INSERT INTO nvm_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","No ire iji fu reoinon iji no game areke fu vek ijegreokma e uruvana buka una fu ma vierafek. Regavo madu e Romko buon e mamkanuk bu iji giakva bu uri ar bomana nuvuon igi no sirimamejo iji keduokfuon. Regavo madu buka uri enuvuon fok kam arafiriakno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Bu ijeg kuain gavo e Kaiafasno kuavo iji fu ijia fin. Regavo madu fu juaivasia ijia fu e Godon isuf baroino ijiebuon e bomana ijefuon fu uri kia, E gurie jaka ire kafo ba mukoi vierafej. ");
INSERT INTO nvm_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ijefuon na vierafe e besum fu e fok nuvuifuon guakma iji fu marek. Regavo no areke e Romko bu uri moik nuvuon fok keduokva fuka ba marek. ");
INSERT INTO nvm_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Regavo e Kaiafas vuak iji Jesu fu e Jius ijiebuon guakfuon iji fu kuainma iji fum fur vierafene kuainma bakin. Fuiji fu juaivasia ijia fu e Godon isuf baroino e bomana be ijefuon vuak iji fu ma ijefuon fu ijeg kuain. ");
INSERT INTO nvm_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Regavo fu madu e Jius ijesugin buifuon kuainma bakin. Regavo fuka Godon afijaf fok eraneb bu dab atase ar iror igia karioinva ijin aferdiame agan besum rekafa fu iji vierafene kuain. ");
INSERT INTO nvm_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ijefuon e Jius ijiebuon e mamkanuk iji bu tavan ijia vuak iji faime bun anerene uri Jesu kanakuai vuak kuaime ujuinamin. ");
INSERT INTO nvm_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ijefuon Jesu ai Judia fu oinma iji fuba una e ijiebuon nifak ijia oin. Regavo ar iji fu ijia areme una uri ai mai Ifrem ai moikum namo samaij ijia e vuak fuon faivo ijiena ijia fikafa vain. ");
INSERT INTO nvm_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Regavo tavan Fasova iji e Jius bu iro ijo iji fun samairega e fok bun ar buon iji areme una iro ijefuon kanafume samuakuai bu una Jerusarem ijia besum afuin. ");
INSERT INTO nvm_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bu ijia afuiknum ijegrejo ijia bu Godon ar ijia arume besum afuim karine Jesu nisain. Bu fu nisaimoknum uri bui kuai, Ja vierafega Jesu fube iro igia ruak? ");
INSERT INTO nvm_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","E Ferisis ijiga e Godon isuf baroijo iji bu ijegrejknum uri e iji kuardiame kia, Iviakma ar iji e Jesu fu fino iji erar game vierafekma ni migegare una kuarduoga no e iji kunaim abe tofno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Areme tavan Fasova iji bu iro ijo iji fun samairen. Ijefuon Jesu fun una vake ai Beteni e Rasaras fino ijia kekoin. Revo e Rasaras iji e iji fu guamga Jesu fu keunama fu una urinma ijin. ");
INSERT INTO nvm_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Fu una ijia vako e iji bu ijia Jesu oimardame fuifuon duok amare vajain. Regavo Rasaras fu ijia Jesuk fiko makifuon Mata fu duok karme vajiain. ");
INSERT INTO nvm_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Jesu fu duok ino ijia bara Meri fu kekome do be bu in nadno kuavo ijefuon gireg safik ijia amarenva fuka udi mukor urino iji abe keko ruain. Fu abe keko Jesuon diak ijia usemdame nige jau fuon ijia abe fimdain. Regavo do iji buka mon ka ma bomana ijia kimejo revo bara iji fuba iji vierafen gavo fuka dab uruvana uduime Jesuon diak somdain. Fu ijegreko ire ijefuon udi ijar ar iji bu karine duok ijo iji fuka raren. ");
INSERT INTO nvm_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Regavo e Judas e Jesuon vuak faimo gavo madu fu tavan rad Jesu abe e ani iji miaga bu kanakfuon e ijar uri Meri kua, Ire udikin mukor guraiji a abe usenma iji aka abe abedekin abe mon kimene e sinuom bakin ijin kafo vajiakfuon gavo a irerafuon abe una ijegrenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Regavo e Judas vuak iji fu ijeg kuainma iji fu e sinuom bakin iji mukor ifejdiamo ijefuon fu iji kuainma bakin. E iji fu e niekin ijefuon fu kamui mon kenma iji fur samuaknum koikfuon ijia kafo niesamoinon. ");
INSERT INTO nvm_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Areme Jesu fu uri kia, Ja bara igi fu nuifuon ire igi fu reno iji jab bijuk. Fu tavan iji na guaga fu abe azirdikfuon fu ijin iviakma mimatam. ");
INSERT INTO nvm_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","E iji sinuom bakin iji bu tavan bog bu igia jana ok revo naiji na tavan bog jana igia okva bano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Regavo tavan besum ijia e Jius iji bu faik Jesu fu ai Beteni ijia oina bu fain ijefuon e fok bu ijia vain. Bu Jesu fuonkua gakuai vainva bakin gavo bu madu e Rasaras fu guama Jesu fu kuamga fu una urinma bu iji gakuai vain. ");
INSERT INTO nvm_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ijefuon Jius e mamkanuk iji bu madu Rasaras kanakuai Jerusarem ijia kari kuaime ujuinamin. ");
INSERT INTO nvm_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ijefuon maiji fu guama Jesu fu keunama fu una urinma ijia e Jius uruvana bu ebuon mamkanuk iji arega bu una Jesu ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Areme afarma e uruvana Jerusarem ijia tavan Fasova iji bu iro ikuai ruainva ijieb Jesu fu ijia Jerusarem roko iji fain. ");
INSERT INTO nvm_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ijefuon e fok bu uri anam kiak mukiene unam gafia Jesu biekuai vain. Bu usem vaknum uruvana biumavknum kume, No Godon oimarek. Godri e Isrerko buon Kin iji fu ma E Bomana ijefuon if ijia roko iji fuon oimardakno kumen. ");
INSERT INTO nvm_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Areme Jesu fun buk akaij ijia usuibe bu isoime kuainva ijeg fun fanuf be bu kua maf-donkino kuavo ijefuon azan ijia ajie fine Jerusarem vain. Regavo vuak iji bu ijeg isoi, ");
INSERT INTO nvm_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","E mai Zaionko iji E Kin jon iji fu maf-donki uka iviamkor azan ijia ajie fine rokno jab jukno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Regavo e Jesuon vuak faivo iji bu unam kafokafo e iji bu Jesu fak rejo iji bun giain revo buka ba mukoi vierafen. Bu vake ijiason bu Jesu kanava fu guamga Godri kuamga fu una unam sanainma ijia uriga bu ijia vierafen. Bu vierafero vuak gami bu usuibe buk akaij ijia isoime kuainva iji bu fuifuon kuainva ijefuon bu fu abe ijegredainvaro bu ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","E iji bu ni buon ijia ireme gako Jesu fu Rasaras bu unainva ijia kuamga fu una uri keko roka bu gainva ijieb vuak ijin dab kuaime iravain. ");
INSERT INTO nvm_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","E fok bu unam sumakin darokin iji fu renma iji fainva ijefuon bu usem unam gafia Jesu biekuai vain. ");
INSERT INTO nvm_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","E Ferisis roin bu oknum iji giame kuai, Jam garaiji giaf. E fok buka biom fu ma vierafeknum dab arafiri vak. Regavo noiji no izegrenva ijefuon no bu ijia areme una fu dab arafiri vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Regavo e Griko roin bu Jerusarem ijia tavan Fasova iro iji bu ikrejo ijia sirimamekuai ruain. ");
INSERT INTO nvm_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ijefuon bu usem e Firif ai Besaida Gareri guf ijia ruainma ijin bieme kua, No Jesu gakuai vierafenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Bu ijeg kuavga Firif fun va Edru kuame busik bun vake Jesu fino ijia usem e iji bu kuardiainva ijeg fu kuardain. ");
INSERT INTO nvm_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Bu ijeg kuardava Jesu fu una roin kia, Tavan iji God fu Ema buon Farif iji abe fuon izeg fu kege ruainma ijefuon aroime kuaga fu fuon sanainma ijia fikfuon iji fun igijar. ");
INSERT INTO nvm_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Regavo vuak igi naka ma kuardiavno faif. Ire ufien sunin besum fu vek an ijia kira sairekma iji fu izeg una madu moik ijia arime una uruvana tavuakma bakin. Regavo ufien iji fu saireme una dabuiko moik ijia arikma ijar fuka uruvana tavuak. ");
INSERT INTO nvm_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Regavo erar fu moikigia tavan bog fuon vierafenma iji oijmaknum kegokma rad fu una izeg unam ma karivako iji abekma bakin. Regavo erar fu moikigia tavan bog una e roin vierafeknum oijmiame ifejdiaokma fu rad unam ma fivako iji abek. ");
INSERT INTO nvm_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Erar vua nun faimo rekafa vierafekma iji nika uri igi na kegoijo ijeg matieme keof. Regavo e vua nun faivo iji bu ar izer na fijo iji buk bu ijia karivak. Regavo asoinun iji fu gia eraneb bu na jajievo iji fu bu kege arordiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Fu ijeg kuardiame uri e vuak fuon faivo iji kia, Iviakma oinun fun ma bijukuriem ijefuon na izeg rek? Naba una asoinun kuak a tavan iji na vajai fian abekrejo iji ab kuaga fu nun rokno kuak? Regavo na ijeg una Asoinun kuakva iji fuba maren. Ijefuon maiji na tavan iji na ijeg vajai fian abekrejo iji biekro na ijefuon moikigia ari ruain. ");
INSERT INTO nvm_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Areme fu una Asoifuon sirimamene kua, Asoinun ni e fok nijaidiaga bu if on iji abe aroivno kuain. Areme bu faik God fu varur gufia ijeg kume, Na if nun sanainma iji nan usuibe abe e fok nijaidiain. Regavo iviakma na una madu if nun sanainma iji abe nijaidiaga bu game abe arordiekno kumen. ");
INSERT INTO nvm_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Regavo e fok samaij ijia irenva bu vuak iji faime una bui kuai fu varur kumeno kuain rega roin bu kuai fu anerak vuak kuainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Bu dab ijeg kuaivga Jesu fu kia, Vuak iji kaf gufia fu kuaima ja fainva iji fu nuifuon bakigavo fu e fok joifuon kuain. ");
INSERT INTO nvm_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Regavo ivia tavan igi fu e moikigia oijo ijiebuon tavan God fu ise buon iji ke mazim giak. Regavo e moik igefuon e bomana Setanon daro iji dab datuai fu ajuarek. ");
INSERT INTO nvm_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Regavo tavan iji bu na kanieme abe urikva ijia na e fok aferdiaga bu una nun ruakno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Regavo Jesu ijeg fu kuainma iji fu tavan iji bu rad fu dab kuros ijia kanaga fu guakma ijefuon fu vuak iji kuardiain. ");
INSERT INTO nvm_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Fu ijeg kuardiamga e fok bu una roin kua, Akai nuvuon ijia fu kuai E iji God fu kuaga fu moikigia ari ruakno kuainma iji fuba guak ga fu ijia fivakno kuain. Regavo a izegrenma ijefuon a kume, Ema buon Farif fu guaga bu abe kaf ajiekno kuaim. Regavo Ema buon Farif iji a kuaimon iji fu erar ga fu izerkin? ");
INSERT INTO nvm_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Bu ijeg kuardavga Jesu fu una roin kia, Ve igi fu sanainma iji fuka ijia tavan bog saname vakma bakin ijefuon ivia tavan igi fuba nakin gavo fu vek sanainma ijia mukoi keof. Ijefuon maiji e be erar ga fu naki oinon iji fuka ba ni nisaiknum vierafene oin. ");
INSERT INTO nvm_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ijefuon iviakma Kurais naiji na sanainma ijin. Ijefuon jaka vek igi na jana oijo ijia ja amarigia na ma vierafenkin ja una sanainma ijefuon e rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesu fu ire ma sumakin fok e Jius ijiebuon nifak ijia rene nijaidiain gavo bu giame buka ba una fu ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ijefuon maiji bu izeg e Asaia e Godon vuak vierafene kuardiamo bu usuibe buk akaij ijia isoinva ijekma riarekafa ijefuon bu ijeg ren. Regavo vuak iji e Asaia fu kuainma iji bu ijeg isoi, E Bomana eraneb vuak igi no kuardiainva iji faime ma vierafen? Revo madu E Bomana ijefuon daro iji fu eranebuon nifak ijia samafrene ikrega bu gak? ");
INSERT INTO nvm_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Bu ijeg isoinva ijefuon e iji buba fu ma vierafen. Ijefuon maiji fu madu vuak be madu ijeg kuai, Godri e ijiebuon niom iji kam zuriadiain ga madu nigen buon iji ba kam samafrediain. Fu ijegrediaikin buba ni narame nisaik ga madu buba mukoi vierafek. Regavo madu bu una nun roga na karauniakfuon iji buba vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","E Asaia vuak iji fu ijeg kuainma iji fum ur nimamaime Jesuon sanainma iji gainma ijefuon fu vuak iji vierafene isoin. ");
INSERT INTO nvm_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Regavo tavan ijia e Jius ijiebuon e mamkanuk roin buka una Jesu ma vierafen. Regavo bu una e Ferisis iji juinva ijefuon bu izeg Jesu bu ma vierafenva iji buba samakaf kuain. Ijefuon maiji bu vierafero e Ferisis ijieb sos iji bu vako iji kuriairekvaro bu iji vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Fu Godri bu kam nidosiame arordiakfuon iji buba vierafen revo buimve una ema ijieb bu kam arordiakfuon bu ijin vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Areme Jesu fu uri uruvana igia kuardiame kia, Erar fu na ma vierafeno iji fu nunkua vierafeno bakin gavo fu e iji fu na kiema na ruainva ijin madu ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Regavo e iji erar fu na giemo iji fu madu asoinun iji fu na kiema na ruainva iji gam. ");
INSERT INTO nvm_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Naiji na sanainma ijin abe moikigia ruain ijefuon eraneb bu na ma vierafejo iji bu nakinma ijia kariokva bakin gavo bu sanainma nun ijia kariok. ");
INSERT INTO nvm_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","48","Regavo eraneb bu na nuigafieme vuak nun ma iji ba faime igievo e iji fu fine una ise fuon iji giakfuon iji fu ijijar. Revo na ruainva iji na e moikigia ise reoijo iji ke mazim giakafie ruainva bakin gavo nam ise buon ijia karauniakafie ruain. Ijefuon vuak nun ma iji fok na kuardiainva ijieb tavan radkma iji ruakma bur una dakaroim ise buon iji giak. ");
INSERT INTO nvm_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Regavo na vuak kufui kuardiavo bakin ijefuon maiji na vuak nun na vierafenva ijin abe kuardiavo bakin. Regavo vuak irerag fok na kuardiavo iji fun Asoinun iji fu kiema na ruainva ijefuon vuak na iji abe ja kuardiav. ");
INSERT INTO nvm_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Regavo na vierafe vuak irerag fu kuainma vuak ijieb ifejduoga no unam ma ijia ma karivak. Ijefuon vuak na kuardiavo iji naka Asoinun ijefuon vuak fu kuardienma na iji abe kuardiavno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","2","Areme tavan Fasova iji e Jius bu iro ijo iji fun samairen. Ijefuon Jesu fu vierafero tavan iji fu moikigia oinon iji fun abedo fu una Asoifuon ijefuon vakro fu ijeg vierafen. Fu tavan bog fu moikigia oinma ijia fu e iji bu fu ma vierafejo iji oijmiame roke ka tavan radkma ijia ruain. Ijefuon Jesu fu naki be e vuak fuon faivo ijiena fine duok ino ijia Setan fu Judas e Saimon Isekarioton farif iji biesuakafa fu oifuon ijia arin. Ijefuon fu Jesu abe e ani iji miakafa vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Regavo Jesu fu vierafero ire fok fun asoifuon ijar kege daro fuon rotit ijia nadain ga madu fur kuamga fu moikigia ari ruaido fu madu una Asoifuon fino ijia vakro fu iji vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ijefuon fu ari fino iji fu areme uri ugon be fu azan abesenma iji daja abedeme uri taver abe viej fuon ijia kirain. ");
INSERT INTO nvm_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Fu kirame fun uri dis ijia do jiame e vuak fuon faivo ijiebuon diak iji sodiame taver abe safik fimdiain. ");
INSERT INTO nvm_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Fu ijegredia roke e Saimon Fita fino ijia keko diak sodakvega fu uri kua, E Bomana a irerafuon diak nun sodiemno kuain? ");
INSERT INTO nvm_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Fu ijeg kuama Jesu fu una roin kua, A iviakma ire igi na rejo iji aba vierafen revo ason rad ijar a gieme una na vierafekno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Fu ijeg kuardain gavo Fita fu una madu kua, A iviakma igia ga rad a diak nun igi sodiekma iji naka ma isediemno kuain. Fu ijeg kuamga Jesu fu una kua, Na diak on iji ba sodakva iji aiji a e vuak nun faimo bano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Jesu fu ijeg una Saimon Fita kuamga fu kua, E Bomana a diak nun igi sodiekveno ijefuon nika diak nun ga imut ga nigen nun ijekma sodiemne kuain. ");
INSERT INTO nvm_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Fu ijeg kuardamgavo Jesu fu una kua, Erar fu amur do fok ruainma iji fuka maren. Fu vajai fuon muin iji fuka soin ijefuon fuba una do ruaik. Regavo fu do ruaikafa vierafekma fu diak ijesugin ruaik. Ijegvo e guri ja fun maradiain revo e besum fuba maren fu vek muigin kiain. ");
INSERT INTO nvm_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesu vuak iji fu kuardiainma ijefuon maiji fu e iji erar rad fu abe una e ani iji miaga bu kanakfuon iji fun vierafen. Ijefuon fu iji kia, E fok ja fun maradiain gavo e besum fuka muigino kiain. ");
INSERT INTO nvm_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Areme Jesu fun e vuak fuon faivo iji diak somdia barme fun ugon fuon fu daru abedenma iji abe una abesme una ar fu fino ijia ari fine kia, Ja iviakma ire guri na renva iji jabe gieme vierafen? ");
INSERT INTO nvm_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ja na kie, E Nijaidiamo ga E Bomana kievo iji na vierafe fun maren ijefuon maiji na ijefuon ruain. ");
INSERT INTO nvm_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","15","Na E Bomana jon ga E Nijaidiamo jon revo naka uri diak jon iji somdiain. Ijefuon iviakma ire guri na renva iji na rene ja nijaidiain. Ijefuon jak ijeg koikjo kege una e ukakna rene uri e roin oijmiaknum ifejdiaf. ");
INSERT INTO nvm_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","17","Regavo vuak igi naka ma kuardiavo faif. E iji fu e bomana befuon ikreno iji fu izeg una e iji fu fuifuon ikreno iji asime fur e bomana rekma bakin. Regavo madu e iji fu figa e be kuaga fu vuak abe va e be kuardamo iji fu izeg una e iji fu kuaga fu vuak abe vako iji asime e bomana rek? Regavo ja uri vuak igi na kuardiava ja fainva iji abe mimatame kegokva jaka oimarknum karik. ");
INSERT INTO nvm_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Regavo vuak igi na kuardiavo iji na e fok ja faikfuon na iji kuardiavo bakin. Nan amur ijia oijon fok nan gia baren ijefuon na iji ja ken. Regavo na vierafero vuak iji bu usuibe buk akaij ijia isoime kuai, E iji fu nosik duok ioinon ijar una na ziegafiekno kuainma iji fuka riarekro na iji kuain. ");
INSERT INTO nvm_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Naka vek igia kuardiaga ja faime vierafekin rad ire iji fu rega ja ijia game vierafero naiji na e iji bu kuai fu ruakno kuainma ijinro ja ijeg vierafek. ");
INSERT INTO nvm_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Regavo vuak igi naka ma kuardiav, Erar e iji na kiaga bu vuak nun ma iji abe kuardiaoijo iji oijmiaknum aferdiamo iji bu madu na oijmieme aferdiev. Regavo madu e iji bu na oijmieme aferdievo iji bu madu Asoinun iji fu na kiema na ruainva iji oijmame afev. ");
INSERT INTO nvm_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesu fu vuak ijeg manine kuardiagak fuka oi bijukurakrega fuka uri samakaf visu kuardiame kia, Naka ma kuardiav, E guri ja karinva ijia e besum fu na abe una e ani iji miakno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Fu ijeg kuardiamga e vuak fuon faivo bu vuak ijin dab vierafega fuka ba aresren. Vuak iji Jesu kafu erafon kuainma iji buka ba vierafen ijefuon bu uri bui ganamin. ");
INSERT INTO nvm_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","24","Regavo e vuak fuon faimo be fu oijmamo iji fuka samaij ijia Jesuk fin. Ijefuon e Saimon Fita fu e iji ni riajama fu gamga fu kua, Kam ar ijia kuaga fu erafon kuaga fu kuarduo no faivno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Fu ijeg kuamga e iji fu Jesuon samaij ijia fino iji fu biom Jesuon navaivknum kua, E Bomana a vuak iji a kuaimo iji a erafon kuaimno kuain? ");
INSERT INTO nvm_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Rega Jesu fu una kua, A e iji na bred abe vuain guria abesme abe e iji maga a ijia game vierafekno kuain. Areme fu uri bred abe vuain ijia abesme abe e Judas Iskarioton Saimon farif ijin main. ");
INSERT INTO nvm_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Jesu fu bred iji abe e Judas mamga Setan fuka ijia migegare Judason oij ijia vuak ise vierafe main. Regavo Jesu fu uri kua, Ni migegare irerag a vierafenma iji rene kuain. ");
INSERT INTO nvm_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Areme e fok fata ijia afuime kari duok ijo iji bu Jesu fu irerafuon vuak ijeg Judas kuardainma ijefuon maiji buka ba vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Regavo e Judas fu mon buon fok fur samuagdiamo ijefuon bu vierafero kafu kuaga fu mon ijia kafo kege una va duok kafo kimekafa kuainmaro bu ijeg vierafen. Regavo be kafu kuaga fu mon ijia kafo kege una va e sinuom bakin iji vajiakro bu ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ijefuon Jesu fu bred buin iji abe e Judas mama fuba uzain gavo fu uri abe in. Regavo tavan iji fun ve nakin gavo madu ise iji fun rekreno ijefuon fu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas fu vakga Jesu fu uri ijeg kia, Iviakma Ema buon Farif ijefuon sanainma iji fun samafren. Ijefuon Godon sanainma iji fu Jesuon azan ijia abe e igiebuon nifak ijia samafren. ");
INSERT INTO nvm_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Regavo Godon sanainma iji fu Jesur abe e fok nijaidiakma God fuk madu fu daro fuon ijia Jesuon sanainma iji abe e fok iviakma nijaidiak. ");
INSERT INTO nvm_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Uviaifnu na vierafe na tavan uruvana naba jana ok. Ijefuon jaba na giekva jaka uri na nisaidiek. Regavo ur na e Jius e mamkanuk iji na kuardiainva ijeg jak na kia ja ar na vako iji jaba jajie vuak. ");
INSERT INTO nvm_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Regavo ni vuak iviamkor be na kuardiakrejo igi faif. Ni jon oijmanamif. Izeg na ja oijmia ruainva ijegvo jasik una jon ijeg oijmanamif. ");
INSERT INTO nvm_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ja jon oijmanamikva e iji bu ja giame vierafero jaiji ja ma e vuak nun faivro bu ijeg vierafekno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jesu fu ijeg kuardamga e Saimon Fita fu una roin kua, E Bomana ar iji a izia vakafa kuaimno kuain? Saimon Fita fu ijeg kuardamga Jesu fu una kua, A iviakma ar na vako iji aba jajie vuak. Regavo ason rad ar na vako a ijia vuakno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Fu ijeg kuardamga Saimon Fita fu kua, E Bomana na iviakma naka oifuon guame ar a vakreno ijia vakro vierafen gavo a irerafuon na arekno kuain? ");
INSERT INTO nvm_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Saimon Fita fu ijeg kuardamga Jesu fu una roin kua, A nuifuon guakno kienma iji a ma kuardiem ki a kufuimen? Vuak igi naka ma kuardavo ni fai, Ivia naki kukoro fuba kumenma ijia e bu nuisina una a kuakva a tavan nokbek (3) feme kiak e iji ja kuaivo iji naba gainvano kiak. ");
INSERT INTO nvm_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Areme Jesu fu uri kia, Jab uruvana vierafeknum oifian abek ni God ma vierafeknum vo na ma vierafef. ");
INSERT INTO nvm_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Regavo ar gufi asoinun fu fino iji fuka ar guf uruvana ijefuon na vakva na ar jon kafo amardiak. Regavo asoinun ijefuon ar guf iji fuba uruvanabatie na vuak igi naba biesiame kuardiak revo fuka ma uruvana ijefuon na ijin ja kuardiav. ");
INSERT INTO nvm_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na amur ajie va gufia kekome ar jon amarme na una ja aferdia ijia vaga ja nana karik. Ja va ar na fijo ijia jak ja ijia karik. ");
INSERT INTO nvm_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Regavo ar iji na vako ijefuon unam iji jan vierafedo ja ijia jajieme vuak. ");
INSERT INTO nvm_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Jesu fu ijeg kuardiamga e Tomas fu uri kua, E Bomana no ar a vakreno iji noba gain ga no izeg unam iji vierafene ja vuakno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Fu ijeg kuamga Jesu fu una kua, Naiji na unam ma iji ga vuak ma iji ga ma karivako ijin. Ijefuon unam ma iji Asoinun fu fino ijia vakfuon iji fu unam be a izeg vakma bakin gavo fun duadok nun ijia vak. ");
INSERT INTO nvm_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Jesu fu ijeg kuardiame kia, Ivia jan na gieme mukoi vierafen revo rad ja madu ijeg Asoinun game fu mukoi vierafek. Regavo iviakmaigia jan fu mukoi vierafen ga madu jan fu gainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Jesu fu ijeg kuaimga e Firif fu uri Jesu kua, E Bomana no Asoion iji gakuai vierafenvano ni nijaiduoga no ga fu oimaduomno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Fu ijeg kuamga Jesu fu una roin kua, Firif! Na tavan uruvana na jana oin gavo jaka vek naba gieme mukoi vierafen. Regavo erar fu na gienma iji fu Asoinun fun gain. Regavo ja irerafuon na kie, Ni Asoion nijaiduo no gavno kiev? ");
INSERT INTO nvm_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Regavo Firif a na giemo ijefuon ni ma vierafero naiji na Asoinun ijek fioijo ga Asoinun fu nosik tavan bog fioino kuain. Areme Jesu fu uri e vuak fuon faivo iji kia, Vuak fok na kuardiavo iji nam nar kuardiavo bakin revo vuak iji fu Asoinun ijefuon vuak. Ijefuon ik irerag na reoijo iji fu Asoinun fu nosik fioino ijar duadok nun ijia ik fuon iji ren. ");
INSERT INTO nvm_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Regavo ni vierafef. Naiji na Asoinun ijek fioijo ga Asoinun fu nosik fioin. Regavo naiji jaba ma vierafekva ni ik fuon na reoijo ijia giame una na ma vierafef. ");
INSERT INTO nvm_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Regavo vuak igi na ma kuardiavno ni amarigia faif. Erar fu na ma vierafekma fu ik iji na reoijo iji fuk ijeg reok. Regavo iji fuka ma rad na una Asoinun fu fino ijia vakva e iji bu iviakma nuifuon ik ukakna reoijo iji bu rad ik mamkanuk kafo nuifuon rek. ");
INSERT INTO nvm_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Regavo irerag kafo ja if nun ijia kiekva na migegare ifejdiak. Na ijegrekva e fok bu ire iji na reoijo ijia gieme bu una Asoinun iji oimardame dab aroik. ");
INSERT INTO nvm_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Regavo ja na ire kafo fuon ja if nun ijia kiekva na oi marknum ifejdiak. ");
INSERT INTO nvm_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ja na mukoi oijmiekva nika vuak nun fok mukoi faime igiame reof. ");
INSERT INTO nvm_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ja ijegrekva na Asoinun kuaga fu e iji ja ifejdiakfuon iji abe ja unafdiak. ");
INSERT INTO nvm_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Regavo e iji fu ja ifejdiakfuon iji Godon Kaven Akai ma iji fur ja ifejdiaga ja tavan bog Godon ma iji giaknum karivak. Regavo e moikigia ise reoijo iji buba oimarknum Kaven Akai iji abek. Ijefuon maiji bu fu buba gak ga madu buba mukoi vierafek. Regavo fuiji jan mukoi vierafen ijefuon maiji jan ni jon ijia fu gain ga fu jana tavan bog fiknum oin. ");
INSERT INTO nvm_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Regavo ja naba uniako vaga ja jonkua kariok ga na una ja karinva ijia ruak. ");
INSERT INTO nvm_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","E moikigia ise reoijo iji bu tavan sibank ijesugin bu na buba giek revo jaiji ja una na giek. Ijefuon maiji na guame una uri ijia fivako ijefuon jak ja ijia karivak. ");
INSERT INTO nvm_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ijefuon tavan iji abekma ja ijia gieme vierafero naiji na Asoinun ijek fioga ja nana karioij ijefuon maiji na oijon ijia fij. ");
INSERT INTO nvm_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Erar fu vuak nun fok na kuardiavo iji mukoi faime igiamo e iji fu tavan bog na oijmiem. Regavo e iji na mukoi oijmiemo iji Asoinun fu e iji mukoi oijmak ga nak na e iji mukoi oijmaknum na koiknu abe fu samafredaga fu na giek. ");
INSERT INTO nvm_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jesu fu vuak iji kuaim barko vo e Judas e iji fu Jesu abe e Jius iji miainma iji bakigavo e Judas be ijar uri Jesu kua, E Bomana a izegredo a nuvuon ruaga e iji moikigia ise reoijo iji a arekno kuain? ");
INSERT INTO nvm_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Fu ijeg kuamga Jesu fu una roin kua, Erar fu na mukoi oijmiekma fu vuak nun iji mukoi faime igiak. Regavo erar fu ijegreno iji Asoinun fu e ijin game oijmak ga na Asoinun ijek tavan bog no e ijiena oifuon ijia kariok. ");
INSERT INTO nvm_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Regavo erar fuba na mukoi oijmiekma e iji fu vuak nun fuba mukoi faime igiak. Ijefuon vuak iji ja faiko na kuardiainva iji fu vuak nun bakin gavo vuak fok fu Asoinun gufi fu kiema na ruainva ijefuon vuak. ");
INSERT INTO nvm_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Na vuak fok nan vek moikigi na jana oijo ijia nan kuardiain. ");
INSERT INTO nvm_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Regavo e iji fu ja ifejdiakfuon iji Godon Kaven Akai ijar ga iji fu Asoinun ijar if nun ijia kuaga fu ari jon ruak. Regavo fur ire fok nijaidiaknum ifejdiaga ja vuak fok na kuardiainva iji jaba rumdiagavo ja mukoi vierafeknum ok. ");
INSERT INTO nvm_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nan vakrej ijefuon na daro mia ja afurvene oimarknum kariok. Revo ijeg afurvene karijo ijekin be ja moikigia biekva bakin ijefuon jab uruvana oifian abeknum juk. ");
INSERT INTO nvm_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nan kuardiava jan fain, Na kia na ja unia vainki na una ruakno kiain. Regavo ja na mukoi oijmiekva ja nun oimareke na Asoinun fu fino ijia vak ijefuon maiji Asoinun ijar fu na asidien. ");
INSERT INTO nvm_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Na vuak fok nan amur kuardiain gavo ire ma iji bu rad rega ja ijia giame una ma vierafek. ");
INSERT INTO nvm_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","31","Naba jana uruvana fine vuak kuaik ijefuon maiji Setan e iji moikigi samuamo iji fun rok. Setan fu daro nun fu asikma bakin. Regavo e moikigia oinva ijieb ma vierafero naiji Asoinun iji oijmavo ijefuon na irerag fu kuardiemo na iji mukoi igiame reoij. Jesu fu vuak ijeg kuardiame kia, Ni uriga no ar igi no karinva iji areme vakno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesu naiji na in of ijekin ga Asoinun fu juar iji samuamon. ");
INSERT INTO nvm_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Fu giega in kiak nun kafo buba sunin kiraiga fu kaniafu korek. Regavo kiak iji sunin kiravo iji fuka amarigia nidosiame amarega bu sunin uruvana kirak. ");
INSERT INTO nvm_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Regavo vuak nun na kuardiainva ijar ise jon fun fikordiama jan una maradiain. ");
INSERT INTO nvm_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ijefuon ja tavan bog nana besum karioke na jana tavan bog oijon ijia fiok. Regavo in kiak fu izeg koikfuon sunin kirakma bakin gavo fu of fuon ijia bijakma fu sunin kirak. Regavo ja tavan bog ba nana besum kariokva jaba sunin kirak. ");
INSERT INTO nvm_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ijefuon naiji na in of ijin ga jaiji ja in kiak nun igekin. Ijefuon erar fu tavan bog nosik besum oin rega na fusik oifuon ijia tavan bog fiokva e iji fu in iji sunin uruvana kiramo ijin. Regavo na jana ba fiokva ja izeg amarigia sunin kiriakva bakin. ");
INSERT INTO nvm_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Regavo eraneb buba nana besum kariokva e iji fu in kiak bu kaniafu kozega bu sairvo ijeg bu kaniafu kozega bu sairek. Regavo madu in kiak buba sunin kiravo iji bu kaniafume mian naino ijia kozega bu naoime barek. Ijegvo erar fuba nosik fiokma Asoinun juar iji samuamo fu e ijekin iji kege mian naino ijia kozega bu naoime barek. ");
INSERT INTO nvm_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Regavo ja tavan bog nana karioknum ga vuak nun iji igiekva ja ire kafo vierafene kiekva God fu ifejdiak. ");
INSERT INTO nvm_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Regavo eraneb ja e vuak nun faivo ijegrene uri oijmanamiknum ifenami vo unam ma ijekin iji reokva iji ja in iji fu sunin uruvana kiramo ijeg rek. Ja unam ma ijekin iji ja rejo ijia e bu Asoinun ijefuon if iji abe nidoime aroik. ");
INSERT INTO nvm_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Regavo Asoinun fu na oijmiemo ijeg na una ja oijmiav ijefuon ni uri izeg na ja oijmiavo ijeg jon oijmanamime kariof. ");
INSERT INTO nvm_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Na Asoinun ijefuon vuak iji mukoi faime igavo ijefuon na fuon oijmiamo ijia tavan bog biduame firok. Unam besum ijeg jak ja vuak nun mukoi faime igiekva ja nun oijmiamo ijia biduame karivak. ");
INSERT INTO nvm_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Na vuak igi ja kuardiaikin ja tavan bog nun oimarvo iji abe oijon ijia abedega oimarvo nun ijar tavan bog oijon ijia name rarek. ");
INSERT INTO nvm_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ijefuon nika izeg na ja oijmiainva ijeg tavan bog jon oijmanamiknum kariof. ");
INSERT INTO nvm_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Regavo igia fai e be erar fu kaifijaf ijiebuon guakma iji fuon fu e oijmiamo iji fuka ma bomana. ");
INSERT INTO nvm_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ja irerag na kuardiavo ja ijia reokva jaiji ja ma kaifnun. ");
INSERT INTO nvm_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Regavo naba ja kia jaiji ja enun ikrejo kiak. Ijefuon maiji e iji fu e befuon ikreno iji fu e bomana fuon irerag fu vierafene reoinon iji fuka ba vierafen. Regavo naiji na e ijekin bakin gavo naiji na vuak irerag fok Asoinun fu kuardienma iji nan ja kuardia baren. Ijefuon naba kia ja enun ikrejo kiak. Regavo na ja kiakva na kaifnun kiak. ");
INSERT INTO nvm_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Regavo jaiji jam jar nun ruainva bakin gavo nar ja kenvano ni va tavan bog if nun ijia unam ma ijesugin kegokfuon. Ja ijegrenki ja ire kafofuon if nun ijia Asoinun kuakva fu ifejdiak. ");
INSERT INTO nvm_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Regavo na una madu kia, Nika jon mukoi oijmanamiknum kariof. ");
INSERT INTO nvm_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","E ise rejo moikigia oinva ijieb ja ziegafiame nibijiakva ni vierafero amur bu na ziegafie vo rad bu ja ziegafiavro. ");
INSERT INTO nvm_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ja e moikigia ise reoijo ijiebuon unam iji abe buna okva buka oijmiame ja aferdia kam unam buon ijia vak. Regavo jaiji ja e moikigia ise reoijo ijiebuon e bakin. Ijefuon nar ja kega ja e ijekin ijiebuon unam iji nuigafiain. Ijefuodo e moikigia ise reoijo iji buka ja ziegafiak. ");
INSERT INTO nvm_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","21","Ni vuak iji na amur kuardiainva iji vierafef, E iji e befuon ikreno iji fuba efuon bomana iji asim e bomana rek. Ijefuon bu na abe arafirienva ijeg bu ja kege arafiriak. Regavo bu vuak nun mukoi faime igiabatie buk bu vuak jon mukoi faime igiak. Bu ire ise fok jon rek ijefuon maiji ja enun ga madu bu e iji fu na kiema na igia ari ruainva iji buba mukoi vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Regavo naba ari moikigia vuak igi abe kuardiabatie e ise reoijo iji bu izeg ise iji mukoi giame vierafekva bakin. Regavo iviakma Jesu nar arime unam ma ga ise iji nan kuardiain ijefuon bu izeg una kuaik no ise iji noba mukoi giainva ijefuon noba giaga renvano kuaikva bakin. ");
INSERT INTO nvm_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Regavo erar fu na ziegafiemo iji fu Asoinun iji ziegafam. ");
INSERT INTO nvm_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Naba ari moikigia ire sumakin e bu rejo bakin iji rebatie e iji buba ise bu reoinva ijefuon vajai fian abek. Regavo nan arime buna oknum ire sumakin uruvana reko bun gien gavo bu uri na abevo Asoinun iji no fusik ziegafuv. ");
INSERT INTO nvm_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Regavo Godon buk akaij ijia bu isoime ijeg kuai, Bu vuak ma ijefuon na ziegafienva bano kuain. Regavo iji bu kuainva iji fun riaren ijefuon bu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Regavo e iji fu ja ifejdiakfuon iji fu Asoinun fino ijia ruak. Regavo e iji Kaven Akai fu Godon ma iji abe samafreoino ijin. Nar Asoinun kuaga fu Kaven Akai iji abe ja uniafdiak rega Kaven Akai ijar vuak nun iji abe nuisina ja kuardiak. ");
INSERT INTO nvm_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Regavo madu jar vuak nun abe e roin kuardiak ijefuon maiji ja ik anej ijia ja nana oknum unam nun fok jan gie baren. ");
INSERT INTO nvm_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Regavo naiji nan vakvej ijefuon na vuak igi kuardiaga ja uri giriesame ma vierafeknum kegok. ");
INSERT INTO nvm_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Regavo ja e Jiusbuon ar bu afuime vuak kuaivo ijia aru vakva bu kuriaireme rotkuriak. Regavo tavan abekma bu e igi ja oijo ijia be kanaga fu guak. Regavo bu ijegrekva bu vierafero bu Godon ik rejoro bu ijeg vierafek. ");
INSERT INTO nvm_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bu na abevo Asoinun iji buba ma vierafen ijefuon bu ire ise ijekin iji jon rek. ");
INSERT INTO nvm_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Regavo vuak igi na kuardiavo ijefuon vake tavan abega bu ire ise iji jon rekva ja vierafero vuak iji nan kuardiainvaro ja ijeg vierafek. Ik anej iji na jana oinva ijia vuak ijekin kafo naba kuardiain ijefuon maiji na vek jana besum oij. ");
INSERT INTO nvm_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Regavo iviakma na una e iji fu na kiema na ruainva ijefuon vakrej revo jaba na kie, A izia vakreno kiev? ");
INSERT INTO nvm_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Regavo iviakma na koiknu kuardiavo iji jaka oifiadiam. ");
INSERT INTO nvm_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Regavo na ma kuardiav, Na joifuon na magoi vakrej revo naba vakva Godon Kaven Akai iji fu ja ifejdiakfuon iji fuba ruak. Regavo na vakva nar Kaven Akai iji kuaga fu jon ruak. ");
INSERT INTO nvm_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Regavo Kaven Akai iji fu ruakma fu e moikigia oinva iji nijaidiaga bu unam ise iji bu reoijo iji koikbuon giak. Regavo madu fur nijaidiaga bu una unam ma ijia ja vak. Regavo fur tavan iji God fu una ise nuvuon kege mazim guokafa roko iji kuardiaga bu vierafek. ");
INSERT INTO nvm_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","10","Bu moikigia ise reoijo ijefuon buba na ma vierafeknum vo unam ma iji gak. Ijefuon maiji nan una Asoinun ijefuon vado jaba una na giek. ");
INSERT INTO nvm_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Regavo madu Kaven Akai fu ruakma fu e fok moikigia ise reoijo ijiebuon ise iji ke mazim giame samakaf nijaidiaga bu vierafek. Ijefuon maiji e moikigi samuamo iji God fun amur ise fuon giain. ");
INSERT INTO nvm_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Na vuak uruvana kuardiakafie vierafen gavo fuka uruvanado ja izeg vuak nun fok faime mukoi vierafeokva bakin. ");
INSERT INTO nvm_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Regavo Kaven Akai fu ruakma fur ja aferdiame una Godon unam ma ijiga vuak ma ijesugin nijaidiaga ja ijia ja vak. Regavo Kaven iji fuba daro fuon ijia vuak fuon fu vierafenma iji abe ja kuardiak gavo vuak fok fu Godon faimo ijesugin abe ja kuardiaknum vo irerag fu rad rekreno iji fur kuardiaga ja faime vierafek. ");
INSERT INTO nvm_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","15","Kaven Akai iji fu vuak nun fok nar kuardavo fu iji abe ja kuardiaga e fok bu nun sanainma iji abe aroiknum oimareok. Ire fok Asoinun fu samuagdiaknum fu reoinon iji bu nun ijefuon Kaven Akai fu ruakma fu vuak nun fok kafo madu kuardiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jesu fu ijeg kuardiame uri kia, Tavan ukakbe barga rad jaba na giek revo tavan ukakbe barga son ijar ja una na giekno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Fu ijeg kuardiamga e roin vuak fuon faivo iji bu uri una bui kuai, Vuak iji kafu irerafuon ijeg kuarduom? Fu kuo, Tavan ukakbe barga rad noba fu gak rega madu tavan ukakbe barga noson una fu gak. Regavo fu madu kuo fun una Asoifuon ijefuon vakno kuin. ");
INSERT INTO nvm_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","E iji vuak fuon faivo iji bu uri kua, Tavan ukakbe barko kuinma iji fu irerafuon ijeg kuarduin? No vuak iji fu kuaimon iji noka ba mukoi fainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Regavo Jesu fun vek ijia giame vierafega bu vuak ijefuon una duna kuakuai vierafejga fu uri kia, Na kia ja tavan ukakbe jaba na giek rega tavan ukakbe barekma ja una na giekno kiainva ijefuon ja iji dab una joi siguv. ");
INSERT INTO nvm_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Na ma kuardiav ja niraiknum oifian abek gavo e iji moikigia ise reoijo iji bu iviakma bu oimarek gavo jaiji jaka oifiadiak. Regavo tavan rad oifian iji ja abejo ijia ja una oimarek. ");
INSERT INTO nvm_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Regavo na vuak be bijame kuardiakrejo ni faif. Bara be fu am iviamkor iji nafekreno iji fuka oifian aben ijefuon maiji fuka vajai fian bomana abek revo am iji fun nafekma fu vajai fian fuon fuba una uruvana vierafek. Regavo fuka una uruvana oimarek ijefuon maiji amfuon iji fun nafe moikigia unain. ");
INSERT INTO nvm_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Bara iji fu renma ijeg iviakma ja ijeg rekvej. Ja iviakma oifian abej gavo rad na una ja biediakva jaka oimarek revo madu rad jon oimarevo iji fuka tavan bog jana navak. ");
INSERT INTO nvm_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Tavan iji na kuardiavo iji ruakma ja una na ire kafofuon kiekva bakin. Regavo vuak igi na iviakma kuardiakrejo iji ni mukoi faime vierafeof. Rad ja koikjo irerag ja vierafenva iji Asoinun iji if nun ijia kuakva fu vajiak. ");
INSERT INTO nvm_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Regavo usuibe jaba ire kafofuon Asoinun iji if nun ijia kuain. Regavo iviakma ni if nun ijia kuaf. Ja kuakva fu ifejdiaga ja tavan bog oimarknum karivak. ");
INSERT INTO nvm_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Regavo vuak fok na kuardiainva iji na bijiame kuardiaoin. Regavo tavan abekma naba una vuak kafo bijiame kuardiak. Regavo naka ir nun ijia Asoinun ijefuon vuak iji abe samakaf visume ja kuardiak. ");
INSERT INTO nvm_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","28","Regavo tavan iji na kuardiainva iji ruakma ja koikjo if nun ijia God kuardak gavo naiji naba una joifuon fu kuardak. Ijefuon maiji Asoinun iji fun mukorigia ja oijmiamo ijefuon ja kuakva fu ifejdiak. Fu ja oijmiamo ijefuon maiji ja na oijmieme ma vierafero naiji na Godon Farif ga fur kiema na ari ruain. Regavo iviakma nan moikigi areme una Asoinun ijefuon vak. ");
INSERT INTO nvm_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Areme e vuak fuon faivo iji bu uri Jesu kua, No gaga a vuak iviakma a kuarduomo iji aba bijiame kuarduom rega vuak fok aka ma samakaf visu kuarduom. Ijefuon fu erar una a duna kafokafo kuakma bakin. ");
INSERT INTO nvm_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Iviakma no gaga aka ire fok vierafen vo emabuon vierafe iji an amur giame vierafeno. Ijefuon no ma vierafe a ma Godon ruain. ");
INSERT INTO nvm_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Bu ijeg kuardavga Jesu fu kia, Iviakma jaba ma vierafej? ");
INSERT INTO nvm_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tavan iji fu roko iji fun iviakma ruain ijefuon ja subinai ar jon ijia tata vaga na ja ijia unieko vak. Regavo naiji na nunkua bakin na vek Asoinun ijek oij. ");
INSERT INTO nvm_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Na vuak igi na kuardiavo ijefuon maiji ja tavan bog nana karivakva ja afuime ok. Regavo e moikigia ire ise reoijo ijieb jon ire ise kafokafo rega jaka vajai fian abek. Regavo ni vierafe moik igefuon ise iji nar asin ijefuon jab zazaik revo nika giriesaf. ");
INSERT INTO nvm_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesu fu vuak iji kuardia barme fu uri gafeg kaf gufia nisaiknum kua, Asoinun tavan iji na guame vo una urikfuon iji fun ruain. Ijefuon ni on sanainma iji abe miega e bu izeg na guame una urikrejo iji gieme una if on dab aroik. ");
INSERT INTO nvm_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ar na abe daro mienma ijefuon na moikigia e fok samuagdiav. Regavo e iji a kege na vajienma iji nar aferdiame una unam ma karivakfuon iji abe miak. ");
INSERT INTO nvm_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Regavo unam ma karivako iji fu ijeg. E bu una a vierafe a God ma besum ijia fino iji ga na Jesu Kurais iji ar kiema na ruainva bu ijeg ma vierafekva bu unam ma karivako iji abek. ");
INSERT INTO nvm_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Na on sanainma iji nan abe e moikigia karinva iji nijaidia ga madu ik on fok a kiema na ruainva iji nan re baren. ");
INSERT INTO nvm_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Asoinu ni iviakma nifak on ijia sanainma on iji abe miemne. Regavo sanainma on iji usuibe a moikigi aba amarenma ijia na osik besum fikna a mienma ijin abe una miemne. ");
INSERT INTO nvm_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","7","Na vuak oisina nan e moikigia ise reoijo ijiebuon kafar ijia e iji a karema bu oi karoime una e a ma vierafenva iji kuardiain. E iji bu eon ga ar bu kege una na vajien. Bu vuak on bu mukoi faime igavo ijefuon iviakma bu ma vierafero ire fok na reoijo iji fu on rokoro bu ijeg vierafej. ");
INSERT INTO nvm_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Regavo na vuak on a kuardienma iji nan abe bu kuardiavga bu vuak on mukoi fain ga bu ma vierafega naiji na ma ar kiema na moik igia ari ruain. ");
INSERT INTO nvm_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ijefuon ivia na buifuon sirimamej. Na e fok moikigia ise reoijo ijiebuon sirimamejo bagavo na e iji a kege na vajienma ijiebuon sirimamej. ");
INSERT INTO nvm_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ijefuon maiji enun iji bu eon ga eon iji bu e nun. Regavo e nun fok na aferdiainva iji bu if nun abe bomana rej. ");
INSERT INTO nvm_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Regavo ivia nan moikigi areme una on vuak revo e vuak nun faivo iji bu moikigia karik. O Asoinun E Akai ni if on a abe na mienma ijefuon daro ijia bu samuagdiaga na osik no besum karinva ijeg bu agan rene besum karivak. ");
INSERT INTO nvm_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Na igia buna oinva iji na if on a abe mienma ijefuon daro ijia bu samuagdiain. Ijefuon e besum (1) fuba a nuigafame vain regavo fun e besum ijar fuon vierafenma ijia fu a nuigafame vainma ijefuon maiji fu buk on akaij ijia bu isoinva iji riarekafa fu iji a nuigafame vain. ");
INSERT INTO nvm_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Regavo iviakma nan una on vuak gavo na vek igi na buna moikigia oijo ijia na vuak fok kuardiaikin oimarvo nun iji fuba barek gavo fuka tavan bog oibuon ijia name rarek. ");
INSERT INTO nvm_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Na vuak on abe bu miavga bu abe e fok kuardiaknum mimatame kege nijaidiain gavo e moikigia karinva ijieb bu ziegafiame vuak buon buba mukoi fain. Ijefuon maiji na e vuak nun faivo ijiena no e moik igeko bakin. ");
INSERT INTO nvm_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ijefuon na sirimamene a kuaga a bu aferdiame moikigi areme vakma bakin gavo nam a kua, Ni bu mukoi samuagdiaga e moikigia ise reoijo iji buba biesiame aferdia una unam ise ijia vak. ");
INSERT INTO nvm_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Regavo na e moik igeko bakin ijeg buk bu e moik igeko bakin. ");
INSERT INTO nvm_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Regavo vuak on iji fu ma ijesugin ijefuon ni unam ma iji nijaidiaga bu tavan bog ana akai rene karivakfuon. ");
INSERT INTO nvm_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","A na abe moikigia unienma ijeg na bu kege moikigia uniav. ");
INSERT INTO nvm_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Regavo na buifuon na vajai nun abe isuf baroine oifuon ikredo buk bu e akai rene oifuon ikrek. ");
INSERT INTO nvm_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Regavo na buonkua buifuon sirimamejo bakin gavo na e iji bu vuak buon mukoi faime una na ma vierafejo ijiebuon sirimamej. ");
INSERT INTO nvm_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Na sirimamega bu agan besum igegrene kariok. O Asoinun na osik no besum karinva ijeg ni bu aferdiaga bu nona agan besum rek. A bu aferdia agan besum rekma e moikigia karinva iji bu ma vierafero naiji na ma ar kiema na moikigia ruainvaro bu ijeg vierafek. ");
INSERT INTO nvm_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Na sanainma on iji a abe na mienma iji nan abe bu miain. Na sanainma iji abe miaga bu izeg na osik no besum karinva ijeg bu besum karik. ");
INSERT INTO nvm_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Na iji na buna tavan bog oin ga aiji a tavan bog nosik oin. Ijefuon no tavan bog no besum okva e fok moikigia ise reoijo iji bu una ma vierafero na ma ar kiema na moikigia ruainvaro bu ijeg vierafek. Regavo bu madu vierafero a na oijmiemo ijeg a bu oijmiamro bu ijeg vierafek. ");
INSERT INTO nvm_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","O Asoinun ar e iji kege na vajien ijefuon na vierafe bu nana ar na fikfuon ijia vak revo bu ijia nun sanainma a abe na mienma bu iji gak. Ijefuon maiji a ik anej a moikigi ba amarenma ijia an na oijmien ijefuon a on sanainma ijin abe mien. ");
INSERT INTO nvm_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Asoinun ma ijesugin kegoino e iji moikigia karioijo iji bu a buba mukoi vierafen gavo na a nan mukoi vierafen. Regavo madu e vuak nun faivo iji buk bu ma vierafega ar na kiema na moikigia ruain. ");
INSERT INTO nvm_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Na vuak on nan abe bu kuardiava bu fain gavo na vek vuak on abe kuaimok. Na vuak on abe kuaimoga on oijmiemo iji a abe na mienma iji fu tavan bog buna nak ga na tavan bog buna ok. ");
INSERT INTO nvm_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesu fu ijeg sirimame barme fun uri e vuak fuon faivo ijin aferdiame do Kidron isof iji garainak ijia vain. Regavo ar iji bu vainva iji bu in ga sinar ni kafokafo bu oinva ijia Jesu fu e vuak fuon faivo ijiena ijia vain. ");
INSERT INTO nvm_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Regavo Judas e iji fu Jesu abe una e ani iji miakfuon iji fu ar iji bu vainva iji fun vierafen. Ijefuon maiji Jesu fu tavan uruvana e vuak fuon faivo ijiena va juar ijia kari vuak kuaimoinevo una rokdo fun vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ijefuon e mamkanuk Godon isuf baroijo ijiga e Ferisis ijieb e juo karijo ijiga e bijaivo iji kafo kege Judas uniafdava fu aferdia ijia vain. E uruvana fu aferdiainma iji bun juaf magu abeko ikuosaij saname bun Jesu nisaime ar ijia vain. ");
INSERT INTO nvm_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Regavo Jesu fu unam fok bu izeg fuon rekvejo iji fun giame vierafen. Ijefuon e iji bun fu nisaime vakga fu biom bu roko ijia vaknum kia, E gari jua magu abe roko garie ja era nisaime rokno kiain? ");
INSERT INTO nvm_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Fu ijeg kiamga bu una roin kua, No e Jesu ai Nasaretko iji nisaim rokno kuain. Bu ijeg kuardavga fu kia, E iji ja nisaim roko iji na igijano kiain. Regavo Judas e iji fu Jesu abe una e ani iji miainma iji fu e ijiena ruainma fu ijia manin. ");
INSERT INTO nvm_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Areme Jesu fu uri kia, Na e iji ja nisaimoijo iji na igano kiamga ir vuat fuon ijar e fok vajiama buka una nuink dijen. ");
INSERT INTO nvm_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Areme Jesu fu madu kia, E garie ja era nisaim rokno kiain? Fu ijeg kiamga bu kua, No Jesu e Nasaretko iji nisaimoijno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Regavo Jesu fu una kia, Na ik ja rokga na ijia kia na e iji na igijano kiain gavo jaka ba fain. Jan ma na nisaidieoijga ni e nun guri roin kiaga bu vafno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Regavo vuak iji fu ijeg kuardiainma ijefuon ma iji fu vierafe vuak gafi fu amur Asoifuon sirimame kua, Asoinun na e iji a kege na vajienma iji naba nuigafiakno kuainma iji fuka riarekafa fu ijefuon ijeg kuardiain. ");
INSERT INTO nvm_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Regavo Saimon Fita fu kaki be ka uikin jaoijmana iji dab kunaim manido fu uri ijia dab e be e bomana Godon isuf baroino ijefuon ikreno iji ada maink fuon iji kana daturain. Regavo e ijefuon if iji Markas. ");
INSERT INTO nvm_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Areme Jesu fu una Fita kua, Ire iji a reno iji fuba marenmano kaki on iji abe una suaf fuon ijia abese. A vierafero Asoi nun iji fu vajai fian igi na abene vajai fian abekfuon iji fu vierafenma iji fuba nun rekro a ijeg vierafenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Areme e iji bijaivo ijigam e bomana buon bu samuagdiamo ijigam e Jius roin iji bun Jesu kunaim tome afem e Anason ar ijia vain. ");
INSERT INTO nvm_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Regavo e Anas fu e Kaiafason ajuam revo madu Kaiafas fu juaivasia iji fuiji fu e Godon isuf baroino e bomana be. ");
INSERT INTO nvm_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Regavo madu e Kaiafasri ur ijia e Jius iji kia, Fu e besum ijar e fok nuvuifuon guakma fuka markno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Bun Jesu afeme Anas e bomana Godon isuf baroino ijefuon ar ijia aru vakga Saimon Fita ko e Jesuon vuak faimo iji fu jame ijia vain. Regavo e Anas fu e Jesuon vuak faimo be iji fun vierafen ijefuon e iji fuka arume gami bu vuak kuaivo ijia vain. ");
INSERT INTO nvm_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Regavo Fita fuba guf ijia aru vain gavo fu va vien bu aruvo ijia manin. Ijefuon e Jesuon vuak faimo be iji fu aru vainma ijar una kekome ro bara vien samua manino iji kuame Fita afem una guf ijia vain. ");
INSERT INTO nvm_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Bu aru vakga bara vien iji manino iji fu uri Fita game kua, Eko na vierafe ak a e gumi bu tom afem aru vainva ijefuon e vuak faimo be. Bara iji fu ijeg kuardamga Fita fuka juin ijefuon fu una roin kua, Naka ma bakin. ");
INSERT INTO nvm_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Buka iduadiainva ijefuon e iji bu e bomana Godon isuf baroijo ijiebuon ikrejo iji abevo e Godon ar bomana iji juo karijo iji bun mian jame ijia iruame iren. Ijefuon Fita fun va ijia e ijiena mian irua manin. ");
INSERT INTO nvm_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","E Bomana Godon isuf baroino iji fun uri Jesu vuak fuon fu e nijaidiaoino ijiga e vuak fuon faivo iji fu aferdiame oino ijefuon duna kafokafo kuardain. ");
INSERT INTO nvm_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Fu ijeg kuardamga Jesu fu una roin kua, Na tavan uruvana naka e fok ijiebuon nifak ijia vuak nun na ijia kuardiaoin. Na ar ukakna jon iji ja ijia aru afuim vuak kuaivo ijigam madu Godon ar bomana iji e Jius abevo e Jius bakin iji bu tavan bog ijia afuim sirimamejo na ijia arume vuak nijaidiaknum kuardiaoin. Regavo na vuak kafo naba isuar sauim kuardiaoin. ");
INSERT INTO nvm_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ijefuon a duna kafokafo iji a irerafuon na kuardiem? A duna ijeg kuardiekafa vierafekma ni e guraiji bu vuak irerag na kuaimoijo bu fainva ijin kiaga bur a kuardav. ");
INSERT INTO nvm_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesu fu ijeg e bomana iji kuardamga e Godon ar bomana iji juo karijo be fu samaij ijia manido fu uri Jesu uikinik ijia kanaknum kua, E igi a erar kuaga a vuak ijeg una e bomana gari kuardamno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Fu ijeg kuardamga Jesu fu una kua. Regavo a vierafega a ijia mani faiko na vuak ise irerag iji e bomana gari kuardaiga ni e fok vuak irerag na kuainva iji kuardiamne. Regavo a vierafega vuak irerag nar kuainva iji na ma ijefuon kuaivga a irerafuon na kanienmano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Areme Anas fun kiamga bu Jesu afem una Kaiafas fino ijia vain. Regavo Jesuon ij iji bu kege nuink kiriainva iji buba iradain gavo bu ijekma afem vain. ");
INSERT INTO nvm_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Regavo Fita fu vek e roina mian iruame manin ijefuon e iji funa irenva ijieb uri kua, E gure aiji no vierafega a e gufefuon vuak faimon beno kuain? Bu ijeg kuavga Fita fuka oi bijukurain ijefuon fu migegare uri kia, Naka ma bakin. ");
INSERT INTO nvm_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Regavo e be e bomana Godon isuf baroino ijefuon ikreno iji fu ijia manin. Regavo e iji fu e gami Fita fu naki gamia kaki dab ada kana daturava ijefuon agan be. Ijefuon e ijar uri Fita game kua, Na vierafe ak uikinik on iji na naki gamia Jesuk gainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Fu ijeg kuardamga Fita fu madu una kua, Na e iji ja kuaivo iji naka bagainvano kiako kukoro fu migegare ijia kumen. ");
INSERT INTO nvm_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Areme bu suok tavan ik gamia abaisako Jesuon e ani iji bun Kaiafason ar ijia Jesu afem una usem Fairet e Romkobuon e bomana ijefuon ar ijia vain. E Jius roin bu Jesu afem vainva iji buba ar guf gami e uruvana bu kot rejo ijia aru vain revo bum makaf ijia karin. Bu karinva ijefuon maiji bu ise iji amarigia agoinkin bu iro Fasova buon iji ikuai ijefuon buba aru vain. ");
INSERT INTO nvm_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ijefuon Fairet fu keko kia, E gufi ja afem nun ruainva iji fu irerag renma ijefuon ja iji afem ruainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Fu ijeg kuardiamga bu uri kume, No fu noba masok afem ruakva bagavo fu koikfuon isema renma ijefuon no iji afem on ruainvano kumen. ");
INSERT INTO nvm_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Bu ijeg kumejga Fairet fu kia, Na fu abe izegrekfuon iji naba gainvano ni koikjo afem abe akai jon iji ja abedenva ijia vierafene refno kiain. Fu ijeg kuardiamga bu una kume, Noim nor e kege kaniaga bu aoikva iji fuka akaino kumen. ");
INSERT INTO nvm_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Regavo iji bu Jesu dab ijegrenva iji fun izeg Jesu fu vek ijia unam izekin ijia e iji bu fu dab arafiriaga fu vajai fian abe guakfuon fu kuainma ijekma riarekafa bu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Areme Fairet fun una ar guf ijia arume Jesu kua, Aiji a vierafe a e Jiusbuon Kin ijino kuain? ");
INSERT INTO nvm_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Fu ijeg kuardamga Jesu fu una roin kua, A duna iji a kuardiemo iji am ar vierafene kuardiem ki bu eb nuifuon kuardava a fainma ijefuon a duna ijeg kuardiemno kuain? ");
INSERT INTO nvm_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Fu ijeg kuardamga Fairet fu uri kua, Regavo a vierafega naiji e Jius? Bu eon ijiga Jius e mamkanuk ijieb a aferda nun ruain. Ijefuon a irerag iji ren? ");
INSERT INTO nvm_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Fu ijeg kuardamga Jesu fu uri kua, Na e mamkanuk moik igeko bu e fok moikigia oijo iji bu samuagdiavo ijeg na bakin. Regavo na moik igefuon e bomanabatie ivia e vuak nun faivo iji bu na mafardieme una e igi ja na aferdie abe e Jius miakrejo ijiena bijaikfuon. Regavo ar nun fu moikigia bano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Jesu fu ijeg kuardamga Fairet fu una kua, A ijedo na vierafe a E Bomana be? Fu ijeg kuardamga Jesu fu una roin kua, A kie a e bomana beno kiem? Regavo moikigia bu nafedieva na ari ruainva iji na vuak ma iji abe e moikigi oinva iji kuardiakva bu ijefuon nafedien. Erar fu vuak nun iji mukoi faikma fu enun rek. ");
INSERT INTO nvm_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Fu ijeg kuardamga Fairet fu una madu kua, Regavo vuak ma iji irerag? Areme Fairet fun una madu kekome e Jius makaf ijia karinva iji kia, E gufi ja afem nun ruainva iji ise fuon naba gaivado naba abe arafirik. ");
INSERT INTO nvm_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Regavo usuibe unam jon iji ja e bu dibur ijia kariga ja kege ijegrejo iji ja tavan Fasova iji roko ja ijia kiega nar e iji kafo karauniav. Ijefuon ja vierafega fu mardo na e Jiusbuon Kin iji keunaga fu vakno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Fu ijeg kuardiamga e fok buka una roin biumavknum kume, No Jesu no iseduom revo no vierafe a e Barabas keuna fu vakno kumen. (Revo e Barabas fu e niekin be fu dibur ijia fino ijin). ");
INSERT INTO nvm_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ijefuon Fairet fun e bijaivo iji kiamga bun Jesu afem makaf ijia useme dab fijain. ");
INSERT INTO nvm_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Bun fijame e bijaivo ijieb kiej kanaufu atevme abe Jesuon nigen ijia abesdain. Areme bun madu uri ugon kavuan ka mukor abe iruafdain. ");
INSERT INTO nvm_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bu usem varaimeknum biesuame kua, No vierafe e igi fu e Jiusbuon e bomana fu tavan bog ijia fivako kuaime uikinik ijia kanain. ");
INSERT INTO nvm_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Bu dab ijegreko Fairet fu una madu keko ro e makaf gufi karinva iji kia, Ni gaf na e gumefuon ise be naba gain ijefuon na afem roga ja koikjo gak. ");
INSERT INTO nvm_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesu fu kiej iji bu ateve abesdainva ijigam ugon kavuan igekin iji bu abe iruadainva ijekma fu keko ruain. Areme Fairet fu uri kia, E iji na kiavo iji igijano ni gafno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Fu ijeg kuardiamga e mamkanuk Godon isuf baroijo ijigam e Godon ar juo karijo iji bun Jesu fu keko rokga bu game buka biumame kume, Abe kuros kana abe kuros kanafno kumen. Bu ijeg kumejga Fairet fu uri kia, Ni koikjo abe kuros kanaf. Na ise fuon kafo naba giaido naba abe arafirik. ");
INSERT INTO nvm_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Fairet fu ijeg kuardiamga e Jius fok buka uri kume, No akai nuvuon ijia e ijekin iji no kania bu aoivno kuain ijefuon no vierafe fuka guak. Ijefuon maiji fu koikfuon kuai, Naiji Godon Farifno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Areme Fairet fu vuak iji faima fuka uruvana igia juin. ");
INSERT INTO nvm_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ijefuon fu una ar ijia aru kekome Jesu kua, Regavo aiji a izia ruainmano kuain? Fu ijeg kuardamga Jesu fuba una roin kuardain. ");
INSERT INTO nvm_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Areme Fairet fu una madu kua, A na aba kuardiekma ni vierafe naiji daro bomana abedo na kiaga bu keunak vo baga na kia bu abe kuros kanak. ");
INSERT INTO nvm_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Fairet fu ijeg kuardamga Jesu fu una roin kua, A kie na daro bomana abenvano kiem revo a onkuabatie daro ijekin iji a izeg abekma bakin. Regavo fun Asoinun gufar daro ijin mainma ijefuon a daro ijin aben. Ijefuon e iji fu kiama bu na abe una igia on ruainva iji fuka ise ma bomana iji renmano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Fu ijeg kuamga Fairet fu vuak ijin faima fuka ba aresren ijefuon fu una unam be fu izegrene Jesu keunaga fu vakfuon iji nisain. Regavo e Jius iji buka una uri kuriaikuriaiki kume, A e guraiji keuna fu vakma aiji a gaman Sisaon kai bakin. E be erar fu kuai, Na e Kin beno kuaikma e iji fu Sisaon e anino kumen. ");
INSERT INTO nvm_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Regavo Fairet fu vuak iji bu kuardavo iji faime uri Jesu afem keko makaf ijia ar iji e bu kot faivo ijia ruain. Fairet fun kekome fata iji e mamkanuk bu karine kot faivo ijia arifin. (Regavo ar iji fu fata ijia arifinma iji e Ibrukobuon isama ijia bu kua Gabatano kuavo). ");
INSERT INTO nvm_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tavan iji iro ikrejo iji fu niar igeg ga ivia tavan fun uokaf abekreno ijia Fairet fu uri e Jius iji kia, E igi manino iji fu e Kin jon no kiain. ");
INSERT INTO nvm_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Fu ijeg kuardiamga e fok buka uruvana igia una madu kume, Kana kana abe kuros kana fuka guamno kumen. Ijefuon Fairet fu una kia, Ja vierafega fube maredo na joifuon e Kin jon iji dab kuros kanakno kiain. Fu ijeg kuardiamga e mamkanuk Godon isuf baroijo iji bu una kume, No e Kin iji fu no samuagduomo iji fun Sisa fuonkua. ");
INSERT INTO nvm_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Bu ijeg kumeja Fairet fun Jesu abe e azikeoijo iji miamga bu abe kuros kanakuai vain. ");
INSERT INTO nvm_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Areme Jesu fun kekome kuros fuon abe dabeme uruor iji fu E Nigen An Igekino kuavo ijia vain. (Regavo uruor iji bu vainva iji e Ibrukobuon isama iji bu Gorogotano kuavo). ");
INSERT INTO nvm_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Bun afem vake uruor ijia usem dab kuros kanain. Rene bu madu e nokarok (2) kam Jesu bu kanainva iken ijia roinroin kaniain. ");
INSERT INTO nvm_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Regavo Fairet fun vuak be isoime abe Jesuon kuros buin ijia kanain. Regavo vuak iji bu ijeg isoi, E igi Jesu ai Nasaretko fu e Jiusbuon Kin ijino kuain. ");
INSERT INTO nvm_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bu vuak isama nokbek (3) e Ibrukobuon ga Reten ga Grik ijiebuon isama ijia isoin. Regavo uruor iji bu Jesu abe kuros kanainva iji fu Jerusarem mai samaij ijia. Ijefuon e Jius uruvana bu ijia oijo iji bu vuak iji bu daoijo. ");
INSERT INTO nvm_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Fairet fu vuak ijeg isoimga e Jius ijiebuon e bomana Godon isuf baroino ijar una kua, Vuak gari a isoime kuai e Jiusbuon e Kin ijino kuainma iji aregavo kua, E igi fu kuai naiji e Jius ijiebuon Kin ijino kuainma ijeg isoin. ");
INSERT INTO nvm_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Fu ijeg kuardamga Fairet fu una kua, Irerag na kiavga bu isoinva iji fun mardo fu ijeg navakno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","E bijaivo iji bun Jesu abe kuros kaname bun uri ugon fuon fok bu ruinva ijin ke ata nokarok ga nokarok (4) name karme buon vajuinamin. Areme bun madu ugon be ni besum siguinva fu azan ijia abesmo ijin jafene aben. ");
INSERT INTO nvm_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Bun abe bui kuai, Ugon igi noba abe bujagavo no kas abe akozga erar abega no gakno kuain. Regavo ijeg bu kenva iji bu Godon vuak bu usuibe buk akaij ijia isoime kuainva ijekma aresrekro bu ijeg ren. Regavo vuak iji bu ijeg isoi, Bu ugon nun iji kam bukik vajuinamime uri ugon nun mukor iji abekuai kas abe akozekno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Bu ijegrekoga kuros iji bu Jesu abe kanainva anej samaij ijia e Jesuon asiej Meri ga uviaifuon be e Kirofason barak Meri ga Meri Megdarin iji bu ijia iren. ");
INSERT INTO nvm_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesu fu una nese gia asiefuon ga e vuak fuon faivo be fu mukoi oijmiamo iji bu ijia iren. Ijefuon fu asiefuon iji kua, Bara gume e guraiji fu farifono ni mukoi samua. ");
INSERT INTO nvm_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Areme fu una dakaroim e vuak fuon faimo iji kua, Bara guraiji fu asieono ni mukoi samuamne kuain. Areme e Jesuon vuak faimo iji fu tavan ijia bara iji abe asiefuon kuame afem ar fuon ijia fikafa vain. ");
INSERT INTO nvm_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Areme Jesu fu vierafe ire fok fu moikigia rekro ruainma iji fun rene baren ga madu vuak iji bu buk akaij ijia isoime kuainva iji fuka riarekafa fu kume, Na do kafiem. ");
INSERT INTO nvm_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Regavo kuros manino anej ijia bu ire vuain ise be jiame ijia abeden. Ijefuon Jesu fu ijeg kumega bu uri atebu ijia abe do vuain ijia abesme abe in ijia bijame abe Jesuon ir ijia azirdain. ");
INSERT INTO nvm_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesu fu vuain iji sira ine areme kume, Fun barenmano kumene ijia kurij ajuareme guain. ");
INSERT INTO nvm_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Areme rad e Jius iji bu vierafe bu Fairet kuaga fu kiaga bu va e iji kuros kaniainva ijiebuon masian iji kaniatuase bu migegare aoiga bu jafe arikuai bu ijeg vierafen. Bu ijeg vierafenva ijefuon maiji tavan iji fu Fraide bu ire kanafuinkin niar iji fuka tavan Sabat (Satade) e Jius bu isuar karine God sirimamek. Ijefuon surif buon bu areke bu ijia kiriakva fuka ma iserek. ");
INSERT INTO nvm_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ijefuon e bijaivo iji bun va gafia usem e nokarok (2) iji bu kege Jesuna kuros kaniainva ijiebuon masian iji kania tuasen. ");
INSERT INTO nvm_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Bu ijegreare una usem Jesu ga fun guainmaga buba masian fuon iji kania tuain. ");
INSERT INTO nvm_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Bu areko e bijaivo be fu uri juaf iji fu kunainma ijia dab Jesuon ken ijia bijako migegare kavuan ijiga do iji bu ijia arin. ");
INSERT INTO nvm_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Regavo e iji fu ire fok bu rejo fu ni fuon ijia giainma ijar vuak igi dab isoiga ja dame jak ma vierafekuai fu iji isoin. Regavo vuak irerag fu isoime kuainma iji fuk vierafega vuak iji fuka ma. ");
INSERT INTO nvm_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Regavo ire iji bu ijegrenva iji fu buk akaij ijia bu isoime kuai, An fuon be buba kana datok kuainva ijekma riarekafa fu ijin ren. ");
INSERT INTO nvm_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Regavo madu buk kafar be ijia bu isoinva fu kuai, E iji bu ken ijia bijainva iji e uruvana bu gakno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Bu ijegre barme rad Josof e Arimatiako ijar Jesuon surif jafe arikafa va Fairet kuain. Regavo Josof fu e be Jesu ma vierafeno. Regavo fu e Jius e mamkanuk iji jume fu isuar sauim ren. Regavo Fairet fun Josof kua ni Jesuon surif jafene kuamga fu jafene abe vain. ");
INSERT INTO nvm_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Regavo e Nikodimas e iji fu ur naki Jesu gak vainma ijar ire aros ga mer ire udi mukoi urino bu e aoiga bu azirdiaga surif buon iji buba muturevo iji kege Josofk vain. Regavo ire iji bu kege vainva iji afik buon bu teti kirogrem (30kg) ijeg. ");
INSERT INTO nvm_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","E Jiusbuon unam izeg bu e kege anume ke uniavo ijeg Josof ko Nikodimas bu ire udikin iji bu kege vainva iji ugon ijia azime Jesuon surif jafene abe ari anuin. ");
INSERT INTO nvm_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Regavo ar iji Jesu bu abe kuros kanainva iji ar iji bu in ga sinar oinva samaij ijia kanain. Regavo munua tit iviamkor be e ijia uniavo bakin iji fu ar iji bu in ga sinar oinva guf ijia. ");
INSERT INTO nvm_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Regavo tavan iji e Jius bu isuar karine God sirimamejo iji udam ijia ga madu munua tit iji fu samaij ijia ijefuon bu uri Jesuon surif iji abe munuag ijia unain. ");
INSERT INTO nvm_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Areme Sade suok tavan ik abaisako ijia bara Meri Megdarin fun vake mako gafi bu Jesu abe uname mun abe bijukurainva ijia kekoin. Fu ijia kekome ga mun iji bu abe vien bijuinva iji bun dab biom ken garia abeden. ");
INSERT INTO nvm_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Fu iji game fun una kukum vake Saimon Fita ga e Jesuon vuak faimo be fu oijmamo iji bu karinva ijia kekoin. Fu kekome kia, E Bomana nuvuon ijefuon surif fuon gafi bu unainva iji no vaga fu bado kabu dab izeg abedenva noka ba gainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Fu ijeg kuardiamga Saimon Fita ga e Jesuon vuak faimo be iji bun usem kukum mako gafi amarigia gakuai vain. ");
INSERT INTO nvm_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bu kukubija vain gavo Fita fu saroiko e be ijar amur asim vake mako gafia kekoin. ");
INSERT INTO nvm_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Fu kekome ba gafi mako guf ijia aru vain revo fum makaf ijia manine amainko ugon iji bu Jesu anuinva iji giain. ");
INSERT INTO nvm_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Fu ijeg manine gamo ijia Saimon Fita fu rad jame vake ijia kekome ka asim mako guf gafia aruin. Fu ijia aru gak ugon iji bu Jesu anuinva ijesugin bu ijia naoiv. Regavo ugon be iji bu abe Jesuon nigen anuinva iji fuk ijia nam. Ugon iji bu Jesuon vajat iji anuinva iji fu fuibe nako ga be iji bu abe nigen anuinva iji fu ba irasen revo fum vek izeg ur bu anuinva fu ijeg ijia nam. ");
INSERT INTO nvm_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Areme e be iji fu amur kukum vainma iji fuk fun rad jame aru ugon iji bu naoivo giame fu ijia ma vierafero Jesu fun una urinmaro fu ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Fu ma vierafen gavo e Jesuon vuak faivo roin bu izeg Godon vuak iji bu usuibe buk akaij ijia bu isoime kuai fu guame madu una urikno kuainma iji bu vek ba ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Bu iji game bun usem una ar vain. ");
INSERT INTO nvm_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Regavo Meri fu vek mako vien ijia manine niraim. ");
INSERT INTO nvm_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Fu ijia mani niraiba una mako ijia amainko gak anera nokarok (2) ugon abaikin sainva ijieb gafi mako guf iji Jesuon surif fu nainma ijia karij. Anera be fu Jesu fu nainma ijefuon diak ijia fiko be fu nigen ijia fin. ");
INSERT INTO nvm_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bu ijia karijga Meri fu amainko giamga bu uri kua, Bara gafe a irerafuon ijia manine niraimno kuain. Bu ijeg kuavga fu kia, Na e Bomana nun ijefuon surif fuon igi bu dab izia abedenva naka ba vierafenva ijefuon na iji niraivno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Meri fu ik ijeg una kaven dakin iji kuardiame una dakaroim ga Jesu fu iji Meri fu manino samaij ijia manina fu gain. Fu Jesu gain revo fuba amarigia vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Areme Jesu fu uri kua, Bara gure a irerafuon niraim. A era nisaime niraimno kuain? Fu ijeg kuamga Meri fu vierafero fu e juar samuamo ijar ro fu una kua, E-e a vierafega e surif igi ar abe va izer abedega ni nijaidiega na va abejo kuain. ");
INSERT INTO nvm_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Meri fu ijeg kuamga Jesu fu una kua, Merino kuain. Jesu ijeg kuamga Meri fu ijia faime una dakaroim e Ibrukobuon isama ijia kua, Raboni. (Revo vuak Raboni ijefuon maiji e nijaidiamon.) ");
INSERT INTO nvm_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Meri fu ijeg kuamga Jesu fu una kua, Naba una Asoinufuo vain revo na vek ijefuon ab na niriadiek. Regavo ni una va e vuak nun faivo gafi vuak nun igi abe kuardiamne. Va kia naiji nan una Asoinun ga Asoijon ga madu God nun ga God jon ijefuon vakno kia. ");
INSERT INTO nvm_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Fu ijeg kuamga Meri Megdarin fun una va gafia kekome e Jesuon vuak faivo iji E Bomana fu una uri fu bienma ijin kuardiame kia, Vuak igi fur koikfuon kuardienmano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Areme Sade tavan besum ijefuon nakifuon ijia e Jesuon vuak faivo fok bun ar buon vien fok bijume bun isuarigia guf ijia karin. Ijefuon maiji bu e Jiusbuon e mamkanuk iji juinva ijefuon bu ijeg ren. Bu isuar karinva ijia Jesu fu migegare iji bu karinva uf ijia manine uri kia, Na vierafe afuime karijo iji fu janano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Fu ijeg kuardiame fun uri imut tat fuon iji bu kaniainva matan ijiga ken bu bijainva ijin kege nijaidiain. E Bomana fu vajai matan iji kege e vuak fuon faivo iji nijaidiamga bu game vierafero fu ma Jesuro buka oimaren. ");
INSERT INTO nvm_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Areme fu una madu kia, Afuime karijo iji fu jana. Na Asoinun fu kiema na ari ruainva ijefuon na ja kiavno ni usem ar iror igia vafno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jesu fu ijeg kuardiame fun uri ivuat fuon vajiaknum kia, Kaven Akai igi na vajiavo ijin kef. ");
INSERT INTO nvm_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ja e kafobuon ise iji giame arekva God fuk ise jon iji fu giame arek. Regavo ja ise buon iji jaba giame arekva God fuk ise jon iji fuba giame arekno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tavan iji Jesu fu una e vuak fuon faivo iji fu biediainma ijia e Tomas if fuon be bu kua e fuatkaruk nafenva Didimasno kuavo iji fuba buna ijia fino ijia Jesu fu biediain. ");
INSERT INTO nvm_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ijefuon fu vainma una rokga e Jesuon vuak faivo bu uri kua, Tomas no kariga Jesu fu igia ajie roka no gainvano kuain. Bu ijeg kuardavga Tomas fu uri una kia, Na koiknu imut nun igia kege imut tat fuon iji ikok bu kaniainva matan ijia unia ga madu na imut nun igia abe ken fuon iji bu bijainva matan ijia kunaikva nason ma vierafekno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Areme vuik besum (1) barko e Jesuon vuak faivo fok bun una madu gire ijia besum afuim karin. Regavo tavan ijia Tomas fu buna besum ijia fin. Bu vien fok buka bijume karinva ijia Jesu fu migegare iji bu karinva uf ijia manine uri kia, Na vierafe afuime karijo iji fu janano kiain. ");
INSERT INTO nvm_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Fu ijeg kiame una dakaroim Tomas kua, Naiji nan ma una urin ijefuon uri imut on iji kege imut tat matan nun ijia uniame gia. Areme madu imut on iji akozme ken nun igi bu bijienva matan igia kuniem giamne. A matan ijia giame una ma vierafekgavo a nonamimo iji aremne kuain. ");
INSERT INTO nvm_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Fu ijeg kuamga Tomas fu uri kua, Na vierafega aiji aka ma E Bomana nun ga madu aka ma God nuno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Fu ijeg kuardamga Jesu fu una kua, A vierafe an ni on ijia gienma ijefuon a na ma vierafen? Regavo eraneb buba ni buon ijia gien gavo bum na ma vierafejo iji na bu ma rediakno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesu fu e vuak fuon faivo ijiebuon nifak ijia fu oknum ire sumakin ka mamkanuk uruvana kafo madu reoin revo ire iji roin buba buk igia isoin. ");
INSERT INTO nvm_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Regavo unam sumakin roin fu kegoinma igia bu isoinva iji bu e igi joifuon isoin. Jar dame giame ma vierafero Jesu fu ma Godon Farif ga Godri kuamga fu moikigia ari ruainmaro ja ijeg vierafekuai bu iji isoin. Regavo jon izeg ja fu ma vierafejo ijia ja tavan bog ma karivakno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ijegreare Jesu fu una madu tavan besum e vuak fuon faivo roin do Taibirias irif ijia biediain. Regavo fu izeg keko biediainma iji fu ijeg. ");
INSERT INTO nvm_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Fu Saimon e Fitano kuavo ijigam Tomas e iji bu kua Didimasno kuavo ijigam e Natanior ai Keinan Gareri guf ijekor ijigam e Zebedion afijaf nokarok (2) ijiga madu e vuak fuon faivo nokarok (2) ijiena bu besum ijia afuim karin. ");
INSERT INTO nvm_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Bu besum karinva ijia Saimon Fita fu uri kaifijaf roin kia, Na do daturaiko nafuinma gamia ugie abe kijum arafiriak vakno kiain. Fu ijeg kiamga kaifijaf iji bu uri kua, Nodua no vierafe no ana vakno kuain. Ijefuon bun ari vanag abe kijum nisaim vain. Bu naki bog arafirin gavo kijum besum be buka ba ken. ");
INSERT INTO nvm_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Bu do ovake tavan ik gamia abaisamo ijia Jesu fu do irif gura ijia manina bu gain. E vuak fuon faivo bu fu gain revo buba vierafero fu Jesuro buba ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Regavo Jesu fu uri kia, E nivek gari ugie iji ja kijum arafiriaoinva iji jabe kafo karaivano kiain. Fu ijeg kuardiamga bu kua, No kijum besum be noka ba kenvano kuain. ");
INSERT INTO nvm_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Areme fu una kia, Jaka naki bomana arafirin gavo nin ugie jon iji dakarame una vanag gufa ij maink ijia oine kijum kafo karafno kiain. Fu ijeg kiamga bun ugie iji dakarame abe una vanag maink gufa ijia oin. Bu oine una dakara ga buka izeg dakarakva bakin. Ijefuon maiji kijum ijar ugie iji fuka irtoijen. ");
INSERT INTO nvm_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Areme e Jesuon vuak faivo be Jesu fu oijmiamo iji fu unam sumakin iji game una Saimon Fita kua, Na vierafe e gari mani vuak kuarduomo iji fu E Bomana ijarno kuain. Regavo Fita fu ugon fuon be fu azan abesmo iji fu daru abedega rotit ijesugin abesoido fu ijeg kuamga fu uri ugon iji abe abesme furiko do ijia akozen. ");
INSERT INTO nvm_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Fu do ijia vaja vakoga e Jesuon vuak faivo roin bun vanag ugie iji kijum karainva ijekma dakarame irif garia vain. Ijefuon maiji bu samai do irif ijia oijo ijefuon bu migegare una irif ijia vain. ");
INSERT INTO nvm_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bu ijia ari usem vaknum ga duok bred ijiga kijum ijieb mian naine mareg ijia naoiva bu giain. ");
INSERT INTO nvm_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Bu iji giame Jesu fu uri kia, Kijum ja karainva iji kafo ke ruafno kiain. ");
INSERT INTO nvm_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Fu ijeg kiamga Fita fu una vanag ijia ajieme e Jesuon vuak faivo iji ifejdiame ugie iji bu kijum karainva ijin dakarame dab iror ijia abeden. Kijum ugie ijia karainva iji buka uruvana vuan adred fifti tiri (153) ga ka mamkanuk ijesugin revo ugie iji fuba bujain. ");
INSERT INTO nvm_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Areme Jesu fu uri kia, Igia ruaf no duok igi ijno kiain. Fu ijeg kiamga e vuak fuon faivo buba una kua a erarno kuain. Regavo bun vierafega fun E Bomana ijar ijefuon bu ijia aren. ");
INSERT INTO nvm_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Bu ijia areko Jesu fu uri bred iji dab tuaseme vajiaoine una madu kijum iji dab una ijeg buame vajiain. ");
INSERT INTO nvm_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Regavo Jesu fu guame una uri uikinik fuon fu abe una e vuak fuon faivo nijaidiainma iji fu amur tavan nokarok (2) biediamevo una igi be biediain. ");
INSERT INTO nvm_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Bun kari duok i barme Jesu fu uri Saimon Fita kua, Saimon e Jonon farif gure on a na oijmiemo iji fuba e guri roin bu na oijmievo iji asidiainmano kuain. Fu ijeg kuamga Saimon Fita fu una kua, E Bomana nun na a oijmavo iji an gieme vierafenmano kuain. Fu ijeg kuamga Jesu fu una kua, Saimon Fita maf-sif nun ijesugin amarigia samuagdiamne kuain. ");
INSERT INTO nvm_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Areme Jesu una madu kua, Saimon Fita e Jonon farif gure abeka na mukoi oijmiem ki a bano kuain? Fu ijeg kuamga Saimon Fita fu una kua, E Bomana nun na a oijmavo iji an gieme vierafenmano kuain. Areme Jesu fu una kua, Maf-sif nun ijesugin mukoi samuagdiamne kuain. ");
INSERT INTO nvm_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Areme Jesu fu tavan radkmaiji una kua, Saimon Fita e Jonon farif gure abe na mukoi oijmien ki a bano kuain? Regavo Fita fuka uruvana oifiain ijefuon maiji Jesu fu tavan nokbek (3) kua abe na oijmienmano kuain. Fu ijeg kuamga Fita fu kua, E Bomana nun a ire fok an gia vierafen. Ijefuon izeg na a oijmavo iji an samakaf gieme vierafenmano kuain. Fu ijeg kuamga Jesu fu una kua, Maf-sif nun iji mukoi samuagdiamne. ");
INSERT INTO nvm_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Jesu fu ijeg kuardame vuak be ijeg bijame Saimon Fita kuardame kua, A vek e nivek iji aka kekome ar izia a vakro vierafeno a ijia vak. Regavo a vake eoreno iji a ij kozega bu e roinb sinuom sadame imutkedame aferda ar aba ijia okafa vierafema ijia vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesu vuak iji fu ijeg bija kuardiainma iji fu Saimon Fita fu izeg rad guaga Godon if bu abe aroime nidoikfuon fu iji kuardiain. Jesu fu ijeg kuardiame uri Saimon Fita kua, Ijefuon a unam iji na kegoinva ijia ak makai nun ijia jajieme kegoine kuain. ");
INSERT INTO nvm_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Areme Saimon Fita fu dakaroim ga e Jesuon vuak faimo be fu oijmamo iji fu rad ja roka fu gain. (Regavo e iji fu ur bu Jesuna naki radkma ijia duok iko fu tuame Jesuon navaime kua, E Bomana e iji erar a abe una e ani iji miakreno kuainma ijar.) ");
INSERT INTO nvm_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Saimon Fita fu e ijar jamga fu dakaroim Jesu kua, E Bomana revo e gami roko iji fuiji fu izegrekno kuain? ");
INSERT INTO nvm_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Fu ijeg kuamga Jesu fu una roin kua, Fuiji na ivia kuak a ni igia oke na una rokno kuaibatie na ijeg rek. Regavo a irerafuon iji abe bomana vierafen? Ijeg a vierafeno iji arega igi na kegoijo iji makai ijia jak ijeg mimatame kegoine kiain. ");
INSERT INTO nvm_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Fu ijeg kiama e Jesu ma vierafejo bu vuak iji e Jesuon vuak faimo besum iji fuba guakfuon fu kuainma iji fain. Regavo Jesu fuba kua e iji fuba guak gavo fu ijia fivakno kuain gavo fu kua, Na vierafe fu ijia nivek fike na una ruakbatie na ijegrek ga a irerafuon iji abe bomana vierafemno kuain. ");
INSERT INTO nvm_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","E Jesuon vuak faimo iji fu kuainma e ijar vuak fok bu buk igia isoime kuainva iji fur ni fuon ijia giain. Regavo madu fu vuak iji abe e roin nijaidiaknum ga fur abe buk igia isoin. Ijefuon no vierafe vuak irerag fok fu igia isoinma iji fuka ma. ");
INSERT INTO nvm_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Areme Jesu fu madu ire ka ma uruvana kafo madu ren. Regavo ire fok buka abe buk igia isoibatie no vierafe e ar iror fok bu izeg vuak iji abe isoim barekva bakin. ");
INSERT INTO nvm_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tiofiras buk nun iji na amur isoinva iji na ire fok Jesu fu renma ijiga nijaidiainma iji isoin. Fu amur ikre vake uri varur gufia ajie vainma ijefuon vuak igi na iji isoin. Jesu fu Godon Kaven duadok ijia fu e afasor fuon bu vuak fuon faime una e roin kuardiavo iji bu izegrekfuon iji kuardiame fu uri varur gufia ajie vain. ");
INSERT INTO nvm_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Fu guame una urin gavo tavan foti (40) ijeg fu vajai fuon abe e vuak fuon faivo iji nijaidiaoin. Fu uri ka samakaf nijaidiamga bu game ma vierafero fu una urinmaro bu ijeg vierafen. Regavo tavan ijia fu uri God fu una efuon ijiebuon oij iji samuagdiakfuon ijefuon vuak iji nijaidiain. ");
INSERT INTO nvm_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Bu una besum afuivga fu uri vuak kuardiame kia, Jab ar Jerusarem arek. Regavo vuak na amur kuardiainva iji vierafene janika ijia karine ire iji Asoinun fu nijiakro kiainma iji samuaf. ");
INSERT INTO nvm_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ijefuon maiji Jon fu do ijesugin ja ruardiav revo iviakma igi God fu Kaven fuon uniafdiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","E afasor iji bu una besum karinva ijia bu uri Jesu kua, E Bomana abe iviakma no karaunuome ar nuvuon Isrer abe una muoga no koiknuvuon samuak? ");
INSERT INTO nvm_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Rega Jesu fu kia, Ja ivez ire iji rekfuon iji jab vierafejo revo fun Asoinun e ka darokin ijar fuonkua vierafenmano kiain. ");
INSERT INTO nvm_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Regavo Godon Kaven fu oijon ijia arikma ja ijia daro abene vuak nun iji amarigia e nijaidiak. Ja e Jerusaremko ijiga e Judiako ijiga e Sameriako ijiga e ar iror ijia karioinva iji nijaidiaok. ");
INSERT INTO nvm_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Fu ijeg kuardia bu nikajako ijia fun ajie vako vana ijar fu abe utime vako buba una gain. ");
INSERT INTO nvm_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Fu vako bu varur gufia nikajako ijia migegare e nokarok (2) ugon abar sainva ijieb bum ijia buna iren. ");
INSERT INTO nvm_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bu ijia ireme uri kia, E Gareriko gurie ja irerafuon ijia irem varur gufia nisaiv? Igi iviakma Jesu fu varur gufia ajie vaka ja gainva ijeg fu una roga ja gakno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Areme e afasor ijiga e roin Jesuon vuak faivo iji bu uruo Orivs iji areme una unam samaij ijefuon Jerusarem vain. ");
INSERT INTO nvm_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bu Jerusarem useme gire be bu karijo ijia ajie vain. Regavo e iji ijia vainva iji Fita ga Jon ga Jeims ga Edru ga Firif ga Tomas ga Batoromiu ga Metiu ga Afiason farif e Jeims ga Saimon e mamkanuk ijiena musikuaimo ijiga Jeimson farif Judas ijieb ijia vain. ");
INSERT INTO nvm_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Regavo tavan bog bu una besum afuime Godon sirimamejo bara roin ga Meri Jesuon asiej ijigam Jesuon uviaifijaf iji bu buna besum afuime Godon sirimamej. ");
INSERT INTO nvm_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","16","Naki sibank barekoga e fok vuan adred tuenti (120) Jesu mukoi vierafejo bu una besum afuiko Fita fu vuak kuardiakafa uri kia, Efnun Godon vuak bu usuibe isoinva fuka ma riaren. Regavo vuak iji fu usuibe Godon Kaven ijar Devidon ir ijia kuainma iji izeg Judas fu e ani ijiebuon unam amarega bu Jesu tokfuon. ");
INSERT INTO nvm_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Regavo e iji fun Jesur abenma ijefuon fu nona ik ren. ");
INSERT INTO nvm_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Regavo mon iji Judas fu unam ise ijia abenma iji fu abe moik be kimen. Regavo moik iji fu kimenma iji fu ijia ari kanamga fu detavuame guain. ");
INSERT INTO nvm_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Rega e fok ar Jerusarem ijia karinva bu vuak iji faime uri vua buonak ar iji abe ime kua Akerdamno kuain. Regavo Akerdama ijefuon maiji Ar Kavuan Arimon. ");
INSERT INTO nvm_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Regavo vuak iji bu buk Sams ijia ijeg isoi, Ar fuon iji e be fuba ijia fikno kuain. Regavo vuak be bu madu ijeg isoi, E be fuka ik fuon fu reno iji abekno kuain. ");
INSERT INTO nvm_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ijefuon e be fuka nona rene Jesuon vuak iji fu guame una urinma iji abe e roin kuardiakfuon. ");
INSERT INTO nvm_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Regavo e iji fu tavan fok nona Jesu jaoinma iji ga ik anej ijia Jon fu e nijaidiaknum do ruardiainma iji game roke Jesu fu varur gufia ajie vaka fu gainma no e ijin abekno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ijefuon bu e nokarok (2) be fu if nokbek (3) Josof Basabas ga Jastas kuavo iji abega e be if fuon Mataias ijin aben. ");
INSERT INTO nvm_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Bu e iji kege Godon sirimamene kua, E bomana a e fok ijiebuon oij iji ar giamon ijefuon e nokarok (2) igi giame e a vierafenma iji nijaiduomne. E Judas fu vuak on abe oinon ijia fu ik fuon iji areme ar fu vakfuon ijia vainmano ni erar fu ar fuon abekfuon iji nijaiduomne kuain. ");
INSERT INTO nvm_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Rene bu if buon isoime ke kaf gufia korva Mataiason if ijar amur arimga bu fu abe una e ireven (11) Jesu jaoijo ijiena mazin. ");
INSERT INTO nvm_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Tavan iji bu kua Fentikosno kuavo iji rokga e fok Jesu ma vierafejo bu una ar besum afuin. ");
INSERT INTO nvm_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Bu besum karikoga migegare varur gafia gurovisiko ijia buibur bomana igeg ufime ar guf bu karinva ijia aruin. ");
INSERT INTO nvm_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Areme bu gak ire be mian igeg vuije ikikene e besubesum ijiebuon vajat ijia kiren. ");
INSERT INTO nvm_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Godon Kaven ijar e fok ijiebuon oij ijia arume nirokiamga bu uri isama kafo bu faivo bakin ijia nanuame kuain. ");
INSERT INTO nvm_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Bu ijeg kuaivga e Jius God ma vierafejo bu ar iror ijia ruainva bu Jerusarem ijia karinva ijieb fain. ");
INSERT INTO nvm_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","7","Bu vuak nanuameja e fok bu faime una besum afuin. Regavo e kafokafo bu vuak buon bu kuaivo bu iji faiva buka oiserdiama bu kuai, E gafi ijeg kuaivo iji bu e Garerikor. ");
INSERT INTO nvm_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Regavo noiji no isama kafokafo kuaiv revo e Gareriko gafi bu izeg vuak nuvuon kuaiv? ");
INSERT INTO nvm_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Regavo no e roin no e Fatiako ga Meidko ga Eramko ga Mesafotamiako ga Judiako ga Kafadosiako. Regavo e roin no e Fontasko gavo ar be Eisia uf ijia revo roin Frigiako ga Femfiriako. Regavo roin e Ijiftko ga roin e Ribiako guf ar Sairini samaij ijia ruain. Regavo madu e kamono e Romko ga madu e roin no e Kritko ga Arabiako ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","12","Regavo e roin no e Jius ga roin no e Jius bakin revo nom e Jiusbuon unam bu rejo no ijeg reoij. Noiji no ar iror ijia ruain revo e iji bu isama nuvuon ijia una karoim ire ma iji God fu renma iji kuarduoga no faivno kuain. E fok bu vuak iji faiva buka oiserdiama bu una bui kuai, Vuak igi bu kuaivo ijefuon maiji ireragno kuain? ");
INSERT INTO nvm_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Regavo e roin bu e Jesu ma vierafejo ijin kam varaimene kuai, E iji bu do kugi ine nigen kam karoinvano kuain. ");
INSERT INTO nvm_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Areme Fita fu e ireven (11) Jesuon vuak abe oijo ijiena uri e fok aramajiame kia, E Jius guriga e Jerusarem karinva gurie janim isuar karine fadieke na irerag igi renma ijefuon gireg ma iji kuardiafno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Areme fu kia, Ja vierafero e igi bu do kugi invaro ja ijeg vierafen gavo iji bu bakin iviakma igi fu vek suok. ");
INSERT INTO nvm_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","17","Regavo vuak igi e Joir e Godon vuak vierafene kuaimon ijar ijeg kuai, God fu kia, Na tavan radkma ijia na Kaven nun abe e fok unafdiak. Rega afjon bu Godon vuak iji faime una e roin kuardiak. Rega e nivek iji bu nimamaik rega eof iji bu naka naoik. ");
INSERT INTO nvm_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Regavo vuak igi naka ma kuardiav e nuibakin vuak nun faivo iji na Kaven Akai nun abe unafdiaga bu vuak nun faime una e roin kuardiak. ");
INSERT INTO nvm_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Na kaf gufia ire bomana sumakin jaba gainva iji rejknum kafo moikigia rega kavuan firake mian ijia naine uk ajiek. ");
INSERT INTO nvm_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Regavo tavan fu nakike asam fu kavuaime una ire kavuan igeg rek. Ire ijieb amur rega rad ijia E Bomana ijefuon tavan bomana fu ruakfuon iji fu ruak. ");
INSERT INTO nvm_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Regavo tavan ijia erar fu E Bomana ijefuon if ijia kura kumekma fu keunak. ");
INSERT INTO nvm_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ijefuon e Isrerko gurie vuak igi faif. God fu Jesu e Nasaretko kuamga fu ire sumakin ga anf kafokafo ja amur ba giainva iji samakaf rena jan giain. ");
INSERT INTO nvm_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","God fu e iji bu Jesu abe ja miakfuon iji fun usuibe vierafen. Regavo fun usuibe oibuon ijia ijeg nirenma ijefuon ja arekoga bu Jesu abe e ani iji miava bu abe kuros kanain. ");
INSERT INTO nvm_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Jesu fu vajai fian abega Godri fu keunama fu una urin. Ijefuon maiji Jesu fuka izeg una zuarunam ijia manikma bakin. ");
INSERT INTO nvm_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Regavo Devid fu Jesusina vuak ijeg kuai, Fu kia, Tavan uruvana na ga E Bomana fu na uinak ijia maniunaim. Revo fuka mukoi samuagdiemo ijefuon fu erar ire ise be nun rekma bakin. ");
INSERT INTO nvm_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Ijefuon naka oimarme vuak iji e bu oimarkfuon iji kuaiv. Revo naka vek God a ma vierafen ijefuon maiji a kaven nun ab arega fu zuarunam vak. Regavo eon iji maturainma iji ab arega vajai fuon fu mako ijia muturek. ");
INSERT INTO nvm_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Regavo an ar unam iji ma karivako iji nijaidien. Regavo a nosik fino ijefuon naka oi madiem. Regavo vuak iji e Devidri ijeg kuain. ");
INSERT INTO nvm_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ijefuon efnun vuak igi na sai nuvuon e Devidon vuak iji abe samakaf kuardiakrej. Fu guama bu abe mako ruin revo mako fuon iviakma no vek gav. ");
INSERT INTO nvm_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Fu vek fino ijia fu e be fu Godon vuak vierafene kuaimon. Revo Devid izeg fu rekfuon iji fun Godri Devid kuardama fun vierafen. Fu ijeg kua, Na saton ijia e be abega fur uri a Kin renma ijegrene e fok samuagdiakno kuain. ");
INSERT INTO nvm_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Fu vierafega Jesu fu una urik ijefuon fu vuak ijeg kuardiame kia, God fuba e iji fu kuama fu ari ruainma iji arega fu zuarunam vak vo vajai fuon fuba mako ijia muturek. ");
INSERT INTO nvm_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Regavo God fu Jesu kuama fu una urina no e fok ni nuvuon ijia non gain. ");
INSERT INTO nvm_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Fu Godri kuamga fu uri ij maink fuon ijia fin. Fu ijia fikoga God fu Kaven Akai iji fu mako kuainma iji abe unafdain. Ijefuon irerag ja iviakma giaknum faivo iji fun Godri Kaven fuon iji abe no unafduin. ");
INSERT INTO nvm_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Devid fun guain gavo fuba varur ijia vain. Regavo fu vuak iji kuai, E Bomana fu e bomana nun kua, Ni nosik samai igia fike na e ani on moikigia karinva iji ke a uniafdaga bur moikigia karine oifuon ik rejno kuain. ");
INSERT INTO nvm_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ijefuon e Isrerko e fok igie vuak igi fuka vuak mano jaka mukoi faif. Godri Jesu e iji ja abe kuros kanainva iji kuama fu E Bomana ren. Regavo e iji God kuama fu ari ruainma iji fun e Jesur ari ruain. ");
INSERT INTO nvm_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","E bu vuak iji faiva vuak ijar oi kediama buka oi karoime uri Fita ga e afasor roin iji kia, Efnun No izegrekno kiain? ");
INSERT INTO nvm_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Rega Fita fu uri kia, E besubesum jaka oi karoime ise jon iji nuigafiakfuon. Ja ijegrega e be fu ja ke Jesuon if ijia do ruardiaga God fu ise jon giame arega ja Kaven Akai iji abejno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Regavo fun Godri kiainma ijefuon jaka afjon ijiga e aibe karinva ijiga e fok eraneb God fu if buon ijia kuria kumeno iji bu fuon vakfuon. ");
INSERT INTO nvm_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Fu ijeg kuriaikuriaikin vuak ju kuardiame kia, Jaka e iji ise rejo ijiebuon unam iji agordiaikin ja jon karaunianamifno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Regavo e fok bu Fitaon vuak iji faime ma vierafejga e be fu uri bu do ruardiain. Regavo tavan ijia e ka ma uruvana tiri taosen (3,000) bu uri e Jesu ma vierafejo ijiena mazin. ");
INSERT INTO nvm_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Regavo tavan uruvana bu besum e afasor ijiebuon vuak bu nijaidiavo iji faime buna gorveknum besum duok iknum Godon sirimameknum ijeg reoin. ");
INSERT INTO nvm_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","God fu daro efuon miamga bu uri unam sumakin kafo rejga e fok bu giava buka oiserdiain. ");
INSERT INTO nvm_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","E iji Jesu ma vierafejo iji buka besum afuim gorveknum sinuom vajuinamiknum ijeg reoin. ");
INSERT INTO nvm_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Regavo erar fu isema fioino bu gakva e roin buka uri sinuom buon ke kimene mon abe buon oifian ganamiknum atame vajuinamiv. ");
INSERT INTO nvm_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Tavan fok bu Godon ar ijia afuiknum ar buon ijia duok besum ine oimarev. ");
INSERT INTO nvm_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bu ijegrejknum Godon oimarga e fok bu giaro e Jesu ma vierafejo buka e maro bu ijeg vierafej. Rega E Bomana fu tavan besubesum e roin karauniame aferdiaga bu una e ma vierafejo ijiena maziv. ");
INSERT INTO nvm_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tavan be Fita ko Jon bu tavan gara vako ijia bu sirimamejo ijefuon bu uri Godon ar ijia vain. ");
INSERT INTO nvm_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Regavo Godon ar be vien bu kua Vien Ireragigekin kuavo ijia e be diak garenma ijar ijia fin. Regavo e iji tavan uruvana e bu fu suime Godon ar vien ijia unaga fu ijia fine e Godon ar ijia roko iji monfuon nimdiam. ");
INSERT INTO nvm_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ijefuon Fita ko Jon bu aru vakga fu giame uri nimdiame kia, Ja ni ire kafo vajiefno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","5","Fu ijeg kiamga bu uri aigin fu nikajakoga Fita fu uri kua, No guomne kuamga fu uri ire iji bu kuavo iji kekafa aigin bu nikajiain. ");
INSERT INTO nvm_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Regavo Fita fu uri e iji kua, Naka mon bakin ga ire iji na abe a makfuon iji na Jesu Kurais e Nasaretko ijefuon if ijia kua, Ni koikon uri vakne kuav. ");
INSERT INTO nvm_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Areme Fita fu uri ij maink fuon ijia e iji imut ke unamga migegare e ijefuon diak iji fu una girnamin. ");
INSERT INTO nvm_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Masian fuon bun girevga fu uri arin manin. Areme fun Godon oimarme aroikaraknum Fita ko Jonkna Godon ar bu sirimamejo ijia arume oin. ");
INSERT INTO nvm_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Tavan ijia fu uri oknum Godon oimarmga e iji guf ijia karinva iji bu fu game vierafega e iji fu e ire nimdiamo ijar. Revo fu Godon ar vien bu kua Vien Ireragigekin kuavo ijia fino iji game buka oiserdiain. ");
INSERT INTO nvm_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Regavo e iji fu uri Fita ko Jon kuniaikoga e fok bu biom bu irenva ijia ruain. Regavo ar iji bu irenva iji bu kua, Soromonon Banadno kuavo. ");
INSERT INTO nvm_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ijefuon Fita fu uri giame kia, E Isrerko gurie ja iragrega ja uri uruv no nikajuov? Ja vierafero e guri fu daro nuvuon ijia ga nuvuon maturainva ijia fu mainmaro jab ijeg vierafek. ");
INSERT INTO nvm_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","God iji saifnuvuon e Eburam ga Aisek ga e Jekaf ijiebuon God ijar Farifuon Jesu sanainma fuon iji abe main. Regavo jar Jesu dab e Jiusbuon e mamkanuk miavga bu kanain. Rega Fairet fu Jesu keunakrega jar Faireton nifak ijia Jesu uzain. ");
INSERT INTO nvm_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Fuka e akai ga e maturainma ijin revo jar fu uzain. Regavo jar Fairet kuava fu Jesu abe e ani iji miama bu kanaga e Barabas e iji e kaniamo iji ja areva fu vain. ");
INSERT INTO nvm_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ja e iji fu unam ma karivako iji e fok ijiebuon amarenma iji ja areko bu kanain. Regavo Godri keunamga fu una urinma iji nor Jonk gain. ");
INSERT INTO nvm_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","No Jesuon if iji ma vierafejo ijefuon ma vierafejo ijar e guri diak garenma guri keunama fu uri nifak jon ijia oina ja gain. ");
INSERT INTO nvm_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Regavo e gurie na giamga jaka ba ma vierafejo ijefuon ja e mamkanuk jon ijiena Jesu dab ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Usuibe God e iji bu vuak fuon vierafene kuaivo ijiebuon ir ijia kuai, E be gafia Godon ruakma fu vajai fian abekno kuainma ijefuon fu areko bu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ijefuon ni unam ise iji areme una Godon roga fur ise jon iji fi korek. ");
INSERT INTO nvm_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ja ijegrekva God fu kaven jon ifejdiaga bu girnamiga fuson e iji fu abe no unafduoko kuinma iji kuaga fu madu una ruak. Regavo e iji fu una ruakfuon iji Jesur. ");
INSERT INTO nvm_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","22","Jesu fu kaf gafia fike God fu ire fok iviamkor amarega fu ijar una ruak. Regavo vuak iji fu Godri usuibe e vuak fuon vierafene kuaivo ijiebuon ir ijia kuain. Regavo madu e Mosis fu kuainma ijeg, God fu e vuak fuon kuardiaoino be unaga fu na ruainva ijeg ruak. Regavo e iji fu ejon igia be ijefuon jaka vuak irerag fu kuardiakma iji mukoi faifno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Regavo erar fu vuak fuon faime ba mukoi kego iji fuka Godon e iji areme daturak garef maninki rad e iji bu abe arafirik. ");
INSERT INTO nvm_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Regavo e fok Godon vuak vierafene kuaivo iji bu irerag Jesu fu igia renma iji bun kuardiain. Regavo e Samuer ga e roin rad ruainva ijieb vuak iji abe kuardiain. ");
INSERT INTO nvm_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","E Godon vuak vierafene kuaivo iji bu irerag God fu rekafa kuainma iji fu ja abevo saifjon ijiebuon kuain. Regavo God e Eburam fu kuainma iji fu ijeg kuai, Nar ijeg renvado na uifarif on ijiebuon duadok ijia e fok moikigia oinva iji daro miak. ");
INSERT INTO nvm_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ijefuon God fu amur Jesu e ifejdiamo iji abe ja unafdiaga fu e fok ja ifejdiaga ja unam ise iji areme una unam ma ijia kari vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Fita ko Jon bu vek vuak kuardiavo ijia e Godon isuf baroijo ijigam e bomana Godon ar iji juo karijo iji samuagdiamo ijigam e Sejusis iji bu ijia usen. ");
INSERT INTO nvm_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","E iji bu faik Fita ko Jon bu kuai, Jesu fu guainma iji fun una urinma kuaivga bu iji faiva buka iserdiain. Bu kuai e fok gurieb vuak iji faime vierafero e iji aoivo iji bu una urijoro ijefuon buka isediain. ");
INSERT INTO nvm_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ijefuon bu tofdiame ke dibur uniava bu ijia naoin revo fun ve nakinma ijefuon bu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Buka e uruvana Fitan vuak iji faime ma vierafen. Regavo e iji Jesu ma vierafejo iji buka e uruvana faiv taosen (5,000) ijeg. ");
INSERT INTO nvm_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Regavo afarma e Jius ijiebuon e mamkanuk ijigam e aikor ijiebuon e mamkanuk ijigam e vuak akai nijaidiavo iji bu una ar Jerusarem ijia besum afuin. ");
INSERT INTO nvm_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Regavo e iji ijia afuinva iji e Kaiafas ga Jon ga Areksada ga Anas e bomana Godon isuf baroino ijigam efijaf ijieb ijia afuin. ");
INSERT INTO nvm_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bu afuime uri e afasor iji kiava bu nifak buon ijia irekoga bu duna kia, Ja daro iji ja izia abe ga madu ja erafon if ijia ja ire ijekin rejno kiain? ");
INSERT INTO nvm_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Bu ijeg kiavga Fita oifuon fu Godon Kaven ijar rarenma ijefuon fu uri kia, E makin gurie ja ire ma iji no izegreja e diak garenma iji fu urinma ja iji gakva ni are no samakaf visu kuardiaf. ");
INSERT INTO nvm_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Rega e fok guri karinva ijigam e Isrerko fok jaka mukoi faif. E igi manino iji Jesu e Nasaretko iji ja kanava fu guain ga Godri kuama fu una urinma ijefuon if ijia fu main. ");
INSERT INTO nvm_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Godon vuak usuibe bu isoinva ijia bu Jesuon bu ijeg kuai, Kudie be e ar savo iji bu vierafero fu isero bu ijeg vierafene dab akozen gavo rad ar uf iji fu kudie ijar kunaim manik. ");
INSERT INTO nvm_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Regavo fu e be erar ja karauniakma bakin gavo fun Jesur fuonkua ja karauniak. Regavo madu fu e be erar moikigia if fuon ijia ja karauniakma iji fuka ma bakino kiain. ");
INSERT INTO nvm_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Fita fu ijeg kuardiamga e Jius ijiebuon e mamkanuk iji bu giame vierafero e guri bu e aikor buba sikur ren gavo buka uri zinunba kuardiavo ijefuon buka oiserdiain. Regavo rad bu ijar vierafero e gurie bu Jesuna oijoro bu ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Bu madu gak e iji diak garenma iji fu ma ijia buna maniga buka i girdiain. ");
INSERT INTO nvm_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ijefuon bu e iji kiava bu ar iji bu vuak kuaivo iji areme usem vakga e iji bu una afuime bui kuai. ");
INSERT INTO nvm_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","No e iji no ke izegrekno kuain? Bu ijeg kuaikoga vo e fok ar Jerusarem ijia karinva iji bu daro iji Fita ko Jon bu abe ire sumakin iji rejo iji bun fain. Ijefuon noba kuaik vuak iji fu kufuino kuaik. ");
INSERT INTO nvm_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Regavo noka vuak iji bu e kuardiavo iji bijuk. Regavo no arekva buka vuak iji abe una e roin kuardiame ira vak. Ijefuon noka kuriairega buba una Jesuon if ijia kurame vuak kafo kuaimokfuon. ");
INSERT INTO nvm_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ijefuon bu kumejga Fita ko Jon bu una aru vakga bu vuak kuriaikuriaikin kuardiame kia, Jab una Jesuon if ijia kurame e nijaidiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Rega Fita ko Jon bu uri kia, Ja vierafe no ir jon iji faiga Godon ir iji no arekva ja vierafe God fu izeg vierafekno kiain? ");
INSERT INTO nvm_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Regavo no ire ma iji Jesu fu rena no gavknum fainva iji no abe kuaimoijo iji noba arekno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Regavo God fu ire sumakin iji rega e fok buka una Godon oimarme fu aroin. Ijefuon maiji e iji bu ire sumakin iji fuon reja fu una urinma iji fu eof ga juaivasia foti (40) ijeg baren. Revo e Jius ijiebuon e mamkanuk iji bu unam ise iji giame bu Fita ko Jon ke dibur uniakfuon iji nisaiga fuka bakin. Ijefuon bum kuriaireme kia, Rad jab una ijegrekno kiame areva bu usem vain. ");
INSERT INTO nvm_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Bu ijeg Fita ko Jon kiavga bu migegare usem vuak iji izeg e mamkanuk bu kuardiainva iji abe e Jesu ma vierafejo iji kuardiain. ");
INSERT INTO nvm_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bu vuak iji faime uri Godon oimarme fuon sirimamene kua, E Bomana ire fok samuagdiamo ar moikigi ga varur gufi ga saof iji amardiain ga guf ijia ire kafokafo amardiain. ");
INSERT INTO nvm_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","26","Ar usuibe Kaven on ijefuon duadok ijia sai nuvuon eon ikreno e Devidon ir ijia kuai, Irerafuon e Jius bakin iji bu Godon deajir abejno kuain. Unam ukakna iji bu Godon bui sivisanamivo iji fu una buzerek. Regavo e Kin roin ga e mamkanuk iji moik kafokafo samuagdiavo iji bu una besum afuime vuak kuaim iganamime E Bomana iji ga e iji God fu kuama fu ari ruainma ijiena bijaikuai vierafekno kuain. ");
INSERT INTO nvm_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Regavo iji fuka ma kuain. Ar bomana igia e Erod moikigi samuamo ijigam e Fontias Fairet ga e Jius bakin ijiga e Isrerko fok bu besum ireme Jesu Farifon e akaij iji oifuon ikreno iji a daro mainma ijefuon unam iji bijukuai sivisanamiv. ");
INSERT INTO nvm_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bu afuinva iji bu ire fok an daro on ga vierafe on ijia amur vierafene kuai bu rekno kuainma bu ijin rej. ");
INSERT INTO nvm_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Regavo E Bomana iviakma e uguaikin iji bu nuvuon ire ise kafo rekrejo iji faime e igi no oifuon ik rejo iji daro muoga no vuak on abe giriesame darokma e kuardiak. ");
INSERT INTO nvm_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Regavo imut on akozme Farifon e akaij iji oifuon ikreno ijefuon if ijia e adagin iji karaunia ga ire sumakin ga anf kafokafo rega bu giav. ");
INSERT INTO nvm_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bu ijeg Godon sirimamene barekoga ar iji bu ijia afuinva iji fu dab katin. Fu ijegreko e fok bu Godon Kaven Akai ijar oibuon ijia arimga buka uri anerene Godon vuak iji abe darokma e kuardiain. ");
INSERT INTO nvm_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","E fok Jesu ma vierafejo iji buka oi besum vierafene iganamime uri sinuom buon karme vajuinamin. Rega e be fuba kiak ire iji fu nuno kiainma bakin. ");
INSERT INTO nvm_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Areme e afasor iji bu uri Jesu fu guame una urinma ijefuon vuak darokma e kuardiavga God fu e fok ma rediain. ");
INSERT INTO nvm_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Areme e Jesu ma vierafejo iji bu uri moik buon ijigam ar buon iji ke kimene mon abe e afasor iji miava bu abe e sinuom bakin iji vajiavga e abevo sinuom abe fuka aresren. ");
INSERT INTO nvm_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","E be if fuon Josof kuavo ijar ijeg ren. E afasor ijieb if fuon bu kua, Banabasno kuain revo if Banabas ijefuon ma iji e roin ifejdiamon. Fu e Rivait ga ar bu fu nafenva iji Saifuras. ");
INSERT INTO nvm_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Josof fuk fu moik fuon abe kimene mon abe e afasor iji miama bu abe e sinuom bakin iji vajiain. ");
INSERT INTO nvm_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Regavo e be if fuon Ananaias ko bara fuon Safaira e ijar uri moik fuon dab kimen. ");
INSERT INTO nvm_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Regavo fun bara fuon ijek vuak kuaim iganaminma ijefuon fu uri mon roin fu kege fuon sauin ga roin fu abe e afasor iji miain. ");
INSERT INTO nvm_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Fu abe miamga Fita fu uri kua, Ananaias a Setanri oion ijia arimga a Godon Kaven iji biesuame mon roin a on ken. A keme una vuak kufui iji no kuarduome kuo, Na moik ijefuon mon iji nan fok abe ja miainvano kuin. ");
INSERT INTO nvm_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","A vierafe a moik on iji abe kimene mon abekma iji fun maren. Revo madu a vierafe a mon roin a on abega roin e vajiakma iji madu fun maren. Regavo iji a renma iji a irerag abekafa a ijeg ren? Aka no biesuinma bakin revo aka God biesuainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Rega Ananaias fu vuak iji faime tua moik ijia dijeme guamga e fok buka juin. ");
INSERT INTO nvm_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Fu guamga e nivek ijieb uri ugon abe fu anume abe usem mako ruin. ");
INSERT INTO nvm_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Regavo rirkinenma ijia bara fuon fu bagaga ijia aru ruain. ");
INSERT INTO nvm_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Fu ijia aru rokga Fita fu uri bara iji kua, Jabe moik be abe mon igi na abedenva ijeg kimenvano kuamga bara iji fu kua keno kuain. ");
INSERT INTO nvm_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Rega Fita fu bara iji kua, Ja no barukin ja izeg vierafene ijegrenvano kuain? Regavo iji ja renva iji ja Godon Kaven biesuain ijefuon vien garaijia e nivek iji bu baru on abe usem mako rukuai vainva ijeg ak bu abe giem usem vakno kuain. ");
INSERT INTO nvm_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Fita fu ijeg kuardamo ijia migegare bara iji fu tua moik iji Fita fu manino ijia dijemga e nivek bu aru gak fun guaiga bu abe usem baru fuon irif ijia mako ruin. ");
INSERT INTO nvm_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Regavo e iji Jesu ma vierafejo ijigam e iji bu vuak iji faiva iji buka dejufdiain. ");
INSERT INTO nvm_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","E afasor iji buka tavan uruvana ire sumakin kafo e fok ijiebuon nifak ijia reoin. Regavo e fok God ma vierafejo iji bu tavan fok Soromonon banad ijia afuime vuak kuaivknum Godon oimarev. ");
INSERT INTO nvm_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Regavo e roin bu juinva ijefuon buba ifejdiain gavo bum unam iji bu rejo iji ke arordiav. ");
INSERT INTO nvm_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Regavo tavan kafokafo ijia e uruvana barubara bu Jesu ma vierafene una e iji ma vierafejo ijiena mazin. ");
INSERT INTO nvm_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ijefuon bu e adam abenva iji ke unam ijia suf rieme ijia uniavknum fatakma ke ijia uniain. Bu ijia uniaga Fitar ijia oke kaven fuon ijar e roin nufiaga bu una madiakuai bu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Areme e fok ar Jerusarem samaij ijia karinva iji bu biom e adam abenva ijigam e kaven ise ijieb ninarukiainva iji aferdia Fitan rokga buka madiain. ");
INSERT INTO nvm_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","18","E bomana Godon isuf baroino ijigam efuon roin e Sejusis iji bu e fok bu e afasor ijiebuon vako iji faiva buka deajidiamga bu uri e iji tofdiame ke dibur uniain. ");
INSERT INTO nvm_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","20","Regavo naki igia Godon anera ijieb dibur vien iji dajame ari e afasor iji aferdia usem makaf ijia kia, Ni va Godon ar bomana ijia aru ireme unam iviamkor bu ma karivako iji abe e kuardiafno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Rega e afasor iji bu anera ijefuon ir iji abene suok nakitu bun Godon ar ijia aru ireme e nijaidiav. Regavo e bomana Godon isuf baroino ijigam e roin fu ifejdiavo iji bu e Jiusbuon e mamkanuk fok kumejga bu besum afuin. Areme bu e kiava bu e afasor bu dibur uniainva iji aferdiakuai vain. ");
INSERT INTO nvm_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","23","Regavo e iji bu kiava bu vainva iji bu dibur ijia usem gak e iji bu bakiga bu una ebuon mamkanuk iji kia dibur vien bun bijukurain revo e juokarinva iji bu makaf ijia iren. Rega vien iji no dajaga e iji bu bano kiain. ");
INSERT INTO nvm_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Bu ijeg kiavga e Godon ar juokarijo iji samuamo ijigam e mamkanuk Godon isuf baroijo iji bu vuak iji faime vierafero e Afasor igi bu izeg usenva bu ijin bomana vierafen. ");
INSERT INTO nvm_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Areme e be fun vuak iji abe arume kia, E iji ja kege dibur uniainva iji bun useme Godon ar bomana gamia aru ireme vuak abe e roin nijaidiavno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","27","Fu ijeg kiamga e juokarijo iji samuagdiamo iji fu efuon juokarinva ijiena va e afasor iji bu Godon ar bomana ijia aru irem e nijaidiavo iji isuar aru aferdia usem ruain. Bu ijegrenva ijefuon maiji bu vierafega bu kuriaikuriaikin kuardiakva e iji karinva ijieb uri mun tuame bu kaniak. Ijefuon bum isuar aferdiame ebuon mamkanuk ijiebuon vain. Bu aferdia gamia usevga e bomana Godon isuf baroino iji fu uri kia, No vuak gigikin ja kuardiame kia, Jab Jesuon if ijia e roin nijaidiavno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Regavo ar Jerusarem fun vuak jon ijar raren. Ja vierafega Jesu fu guainma iji ja abe no namduokno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Bu ijeg kiavga e afasor iji bu uri roin kia, Noka God igak gavo noba ema igiakno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Saifnuvuon ijiebuon God ijar Jesu ja abe kuros kanava fu guaga fur daro mama fu una urin. ");
INSERT INTO nvm_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","God fu Jesu daro mamga fu una uri fusik besum ij maink ijia fin ijefuon Jesu fu e ikin ga fu e karauniamon. Regavo God fu vierafe e Isrerko iji bu ise buon areme una Godon roga fur giame arekafa ijefuon fu unam iviamkor iji amaren. ");
INSERT INTO nvm_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","No Godon Kaven ijiena God irerag fu renma iji nor abe kuaimoij. Regavo kaven fuon iji fu e iji eraneb fu igavo ijin unafdiak. Vuak iji Fitar ijeg kuardiain. ");
INSERT INTO nvm_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Regavo e Jiusbuon e mamkanuk iji bu vuak iji faiva buka deajidiamga bu vierafe buka e afasor iji kania bu aoik. ");
INSERT INTO nvm_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Regavo e Ferisi be if fuon Gamerier fur Godon akaij iji nijaidiaga e bu ir fuon amarigia faivo ijar uri kia, E guraiji Jesuon vuak abe oijo iji ke usem vafno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Areme fu kia, E Isrerko guri ja afuinva gurie, Vuak igi faime irerag ja iviakma e guribuon rekrejo iji ni mukoi vierafeknum refno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ur e iji bu kua Tiudasno kuavo ijar e ijeg biesiame e be bomana igegreoga e uruvana fo taosen (4,000) bu uri fu ifejdain. Revo e roinb uri fu kanavga e iji funa oijo iji bu dab ataseme vain. ");
INSERT INTO nvm_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Areme rad gaman bu e if abeoijor ijia e Judas e Gareriko ijar e roin aferdia ijegrena e roinb madu fu kaniain. Bu kanava fu guakoga e iji funa oijo iji bu madu dab ataseme vain. ");
INSERT INTO nvm_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ijefuon na vierafe ja vuak nun igi abene e iji magiaga bu vakno kiain. Regavo irerag bu kuardiavo iji bu vierafe buon iji rekva iji fu iserekno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Regavo vuak iji fu Godon ruaiga bu iji abe kuardiavgakva iji ja izeg unam buon abe iserekva bakin. Ja unam ijeg ja rejo ijia ja joi ganamibatie jaga jaka Godna nigaraiv. ");
INSERT INTO nvm_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","E fok karinva iji bu e Gamerieron vuak iji abene uri e afasor iji kumeja bu una aru rokga bu fijiame kia, Jab rad una Jesuon if ijia e nijaidiavno kiame uniavga bu usem vain. ");
INSERT INTO nvm_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bu ar e Jiusbuon e mamkanuk bu vuak kuaivo iji are usem ai makaf ijia ruaknum Godon bomana oimaren. Ijefuon maiji bu Jesuon azan ijia vajai fian abejo ijefuon bu oimaren. ");
INSERT INTO nvm_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Rene tavan bog bu naoim urijo iji bu Godon ar bomana ijia arume e nijaidiaknum e ijiebuon ar ijia va Godon vuak ma iji abe nijaidiav. Bu nijaidiame kia, Jesu fu ma e iji usuibe God fu kua fu ruakno kuainma fu e ijarno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tavan ijia e iji Godon vuak faivo iji buka ma uruvana rejga e Jius roin isama Griks kuaivo ijigam e Jius roin isama Arameik kuaivo ijieb uri buna musikuain. Ijefuon maiji bara amun buon kafo ijia karijo iji buba amarigia samuagdiame duok iknum vajiav. ");
INSERT INTO nvm_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ijefuon e afasor tuer (12) iji bun uri e fok Jesu ma vierafejo iji kumeja bu besum afuivga bu kia, No vierafega noba ik nuvuon no Godon vuak iji abe kuaimoijo iji arekgavo una mon samuame duok kege e vajiakfuon iji fuba marek. ");
INSERT INTO nvm_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","4","Ijefuon uviaifnun ni jakikum e uguaikin iji bu Godon Kaven iji igavo ijia kega bur unam iji samuak. Regavo noiji no koiknuvuon Godon sirimameknum ga vuak fuon ijesugin abe e roin kuardiak. ");
INSERT INTO nvm_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","E fok buka afasor ijiebuon vuak iji faiva buka oimadiain. Ijefuon bu uri e Stiven e ka God ma vierafeno Godon Kaven Akai iji igamo iji aben. Regavo madu uri e Firif ga e Frokoras ga e Nikano ga e Timon ga e Famenas ga e Nikoraus e be ar Entiok ijia ruainma fu una e Jius ijiena mazinma ijin ken. ");
INSERT INTO nvm_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bu e iji kege una e afasor iji uniafdiaga bu ke Godon sirimamene imut nigen namdiain. ");
INSERT INTO nvm_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Areme Godon vuak iji fu abe bomana rene vakga e ar iror bu vuak iji fain. Regavo e kafo bu ar Jerusarem karinva iji bu una e Jesu ma vierafejo ijiena mazin. Regavo e Godon isuf baroijo fok buk bu una oi karoime Jesu ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stiven e iji ka Godon daro bomana oifuon ijia arinma ijar ire sumakin fok rejknum ire ma iji e fok ijiebuon ren. ");
INSERT INTO nvm_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Regavo e roin bun ijeg afuivo ijiebuon if bu kua E Oi Mafaiva kuavo ijigam e Jius ar Sairinko ijigam Areksadriako ijigam e Sirisiako ijigam Esiako iji bu ijia ruainva ijieb uri Stivensina kuain. ");
INSERT INTO nvm_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","E ijieb Stivensina kuain revo fuka Godon Kaven ijar fu daro mainmado fu vuak bu kuardavo iji fuka karatuame una kuardiam. ");
INSERT INTO nvm_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ijefuon bu e roin biesiame kam nidosiame duok vajiame kia, E Stiven fu Mosis ko Godk ijiebuon if iji ke buze ifdiamno kuain. ");
INSERT INTO nvm_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Bu ijeg kuardiavga e iji bu uri vuak iji abe e mamkanuk ijigam e akai samuagdiavo ijigam e fok kuardiavga vuak ijar e fok ijiebuon oij iji kam arafiriava buka deajidiain. Bu deajidiamga bu uri Stiven kunaim abe e Jiusbuon e mamkanuk iji karinva ijia vain. ");
INSERT INTO nvm_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Areme bun e iji bu amur kam nidosiame duok vajiainva iji kumeja bu usem Stivenon vuak iji abe kuardiame kia, E iji fu tavan bog fu Godon ar ma iji abe buzeiknum Godon vuak fu usuibe Mosis kuainma iji abe buzeimno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Bu ijeg kuardiavga e mamkanuk iji bu kia, No faiga fu Jesu e Nasaretko iji fu Godon ar bomana iji bujakoreme Mosison unam iji fu abe muinma iji abe una be amareko kuaima no fainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bu ijeg kuaivo ijia e mamkanuk ga e fok bu una Stivenon uikinik iji gak fuka ire anerabuon uikinik igekin. ");
INSERT INTO nvm_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Areme e bomana Godon isuf baroino ijar uri Stiven kua, A vierafega vuak igi bu oisina kuaivo iji fube mano kuain? ");
INSERT INTO nvm_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","3","Fu ijeg kuamga Stiven fu uri kia, Uviaifnun ga asoifnun gurie igia faif. God e iji sanainma fuon fuka zin igeg iramo iji fun usuibe sainuvuon Eburam fuba ar Mesofotamia arega Aran vainma ijia fun fu bien. Fu bieme kua, Ni ar on igeko e aganon igi arega uri ar be nar nijaidakrejo ijia vakne kuain. ");
INSERT INTO nvm_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ijefuon Eburam fu ar Kardia arega uri va ar Aran ijia figa asoifuon fu guama Godri fu kuamga fu uri una ro ar igi ja iviakma karinva igia fin. ");
INSERT INTO nvm_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Moik iji God fu Eburam mainma iji fu ma fuon mainma bakin. Revo God fum kua, Moik iji a saifon ijiena abe fikno kuain. Regavo tavan iji God fu vuak iji kuainma iji Eburamon fu am kafo ba nafen. ");
INSERT INTO nvm_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","7","Regavo God fu vuak ijeg Eburam kuardain. Fu kua, Saifon bu juaivasia fo adred (400) ijeg ebuon ar ijia karine e ijiebuon ikrek. Regavo e ijieb madu bu kam arafiriaga bu oifian abeknum ikrek. Regavo nar e ijekor iji kam arafiriaga bu vajai fian abega rad saifon bu moik iji areme usem moikigi na abe miavo ijia karine una nun sirimamekno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Eburam fu Godon vuak iji igamga God fu kua, Na am farifon iji na kege vajai surif buon kania ufume anf naga bu ijia vuak na kuardiainva iji vierafekno kuain. Ijefuon Eburam fu uri am farif Aisek nafene naki eit (8) barekoga fu abe ijeg ren. Revo rad Aisek fu uri Jekaf nafega fur uri am tuer (12) nafen. Revo am tuer (12) ijieb buka saifnuvuon ma anej ijin. ");
INSERT INTO nvm_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","Regavo am ijieb Josofna nibijaikuai vierafejo ijefuon bu uri fu dab e Ijiftko ijiebuon kimeja fu buon ik ren. Josof fuka oifiain gavo God fu fusik ijefuon fur afikin fuon iji dasumdako fu fioin. Josof fu va ar Ijift e kin Fero fino ijia kekoin. Regavo Godri daro mamga Kin Fero fu Josofon unam iji ga fuka mukor ijefuon fu kuama Josof fu moik Ijift ijia e bomana rene Kin ijefuon ar iji samuagdiain. ");
INSERT INTO nvm_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Areme ar Ijift ga Keinan ijia vasia kekome e fok kaniama e saifnuvuon bu duok bu ikfuon iji fun baren. ");
INSERT INTO nvm_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Regavo Jekaf fu faik ar Ijift ijia bu duok kafo ija fu faime uri saifnuvuon iji kiama bu ar ijia vain. Regavo ar iji bu vainva iji buon amur bu ijia vain. ");
INSERT INTO nvm_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Regavo rad bu una vaka Josof fu ijar vajai fuon abe nijaidiame kia, Naiji uviaijon ijino kiame aferdiame Kin Fero nijaima fu Josofon uviaifijaf iji giain. ");
INSERT INTO nvm_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Areme Josof fu ijia vuak buon abedeme kia, Ni vaga Jekaf asoinun iji kua fu aganuvuon iji aferdiame igia Ijift ruafno kiain. Regavo aganfuon fuka uruvana e seventi faiv (75) ijeg. ");
INSERT INTO nvm_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Fu ijeg kiainma ijefuon Jekaf fu va Ijift ijia saifnuvuon ijiena ijia karine aoin. ");
INSERT INTO nvm_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bu aoivga surif buon bu ke va ar Sekem kuaivo ijia e Eimobuon munuag be Eburam fu kimenma ijia uniain. ");
INSERT INTO nvm_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Regavo tavan iji God fu Eburam efuon karauniakafa kuainma iji fun samairega enuvuon ar Ijift ijia karinva iji buka uruvana ren. ");
INSERT INTO nvm_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Regavo rad e Kin be fu Josof ba vierafenma ijar anerene ar Ijift samuain. ");
INSERT INTO nvm_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kin ijar saifnuvuon iji biesiame kuriairema bu am buon iviamkor iji kam koreva bu aoin. ");
INSERT INTO nvm_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","21","Tavan ijia bu e Mosis ka e mukor iji nafen. Bu nafene abe ar fuon ijia samuame kariko asam nokbek (3) baremga bu fu abe akozva Kin Feron kabaij ijar Mosis abe fuirene farifuon igeg samuain. ");
INSERT INTO nvm_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Fu ijia figa e Ijiftko ijieb unam buon ma iji nijaiva fu e makin rene vuak mamkanuk iji kuai vo unam ma ijia reoin. ");
INSERT INTO nvm_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Mosis fu juaivasia fuon foti (40) ijeg baremga fu uri efuon e Isrerko iji giak vain. ");
INSERT INTO nvm_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Fu vaga efuon be e Ijiftko ijar dab arafirimga Mosis fu e iji abe uname e Ijiftko iji kanama fu guain. ");
INSERT INTO nvm_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosis fu vierafe fu ijegrega efuon bu game vierafero Mosis fu bu karauniakafa fu ijeg ren. Regavo efuon iji buba ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Rega afarma fu giak e Isrerko nokarok (2) bu bui bijaivga fu keko turamdiame kia, Jam igi faif jaiji nouviaikin revo ja iragrekuai joi bijaivno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Fu ijeg kiamga e iji kaifuon kanama ijar uri Mosis vaja dab gareg akozme kua, Erar a kua ani e makin rene no samuagduomne kuain. ");
INSERT INTO nvm_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","A vierafe a niar e Ijiftko iji a kanainma ijeg a na kaniekreno kuain? ");
INSERT INTO nvm_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Fu ijeg kuamga Mosis fu vuak iji faime uri ko ar Midian ijia va fine am farif nokarok (2) nafen. ");
INSERT INTO nvm_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Mosis fu ijia fine juaivasia foti (40) ijeg barko ijia fu una uruor Sainai ai moikum namo ijia mian naiga fu game va ijia Godon anera iji bien. ");
INSERT INTO nvm_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","32","Mosis fu ire iji game fuka oiserma fu ura samaij ijia mian ifirik iji naino iji gakafak vain. Fu gak vako ijia fu Godon ir iji fain. Fu faik fu kua, Na saifon Eburam ga Aisek ga Jekaf ijiebuon God ijin. Fu ijeg kuama Mosis fuka turanamime simaimga fu uri ni dab sauin. ");
INSERT INTO nvm_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Areme God fu ijia Mosis kua, Ar iji a manino iji fu akaino diak surif on a sainma iji rume namne kuain. ");
INSERT INTO nvm_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Regavo God fu madu kua, Na giaga enun ar Ijift ijia karinva buka vajai fian abej. Bu vajai fian abene aduiva na iji faime bu ifejdiakafie na ari ruainvano kumen. Ijefuon iviakma roga na vuak kuardaga a ar Ijift ijia vakne kuain. ");
INSERT INTO nvm_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Areme Stiven fu madu uri saifijaf ijiebuon suar iji buin ifene kuardiame kia, Mosis e iji Isrerko bu uzame kua, A erar kua ani e makin rene no samuagduomno kuainva ijin. Rega Godri anera iji mian rene naino ijefuon azan ijia Mosis kuama fu efuon samuagdiame karauniakafa vain. ");
INSERT INTO nvm_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Fu efuon Ijift karinva iji aferdiame juaivasia foti (40) ijeg fu buna ar Ijift ga saof Kavuan irif ijia ga ar ijia ire sumakin fok reoin. ");
INSERT INTO nvm_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Rega Mosis besum ijar e Isrerko kia, Godri ejon igia e vuak fuon vierafene kuaimon be kuaga fu igi na fu kiema na ruainva ijeg ruakno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mosis fu saifnuvuon e Isrerko ijiena ai moikum namo ijia besum buna oinma ijin. Regavo madu uruor Sainai ijia anera ijar Godon vuak ma iji abe fu mavga fu abe no karaunuokafa ruainma ijin. ");
INSERT INTO nvm_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Regavo e saifnuvuon bu Mosis buba igain. Rega buka Mosis uzame oibuon buka una ar Ijift ijia vakuai vierafen. ");
INSERT INTO nvm_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ijefuon bu uri e Eron kua, No e Mosis fu no aferduo ar Ijift are ruainma unam fu reno iji noka bagainva ijefuon ni ar god kafo amarme uniafduo no una iji jajiavno kuain. ");
INSERT INTO nvm_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Bu ijeg kuaime uri ire be maf-kau igekin iji amarme uri fuifuon isuf baroknum iro ine ire iji bu imut buon ijia amarenva ijefuon oimaren. ");
INSERT INTO nvm_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Regavo God fuba bu igiamga bu una mujur varur gafia irenva ijiebuon sirimamen. Rega vuak e Godon vuak vierafene kuaivo bu isoime ijeg kuai, E Isrerko iji ja ai moikum namo ijia juaivasia foti (40) ijeg ijia oin revo ja nuifuon fanuf kafo jaba kania isuf baroidien. ");
INSERT INTO nvm_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ja mavua be amare god jon Morek abe ijia abesme god jon Refanon mujur ijefuon kaven abe ijekma oij. Ire iji jam jar amardiain gavo jaka iji ke amarigia sirimamejo ijefuon na ja aferdia ja ar Babiron asim gafaijia vakno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Regavo saifnuvuon ijieb Godon ar muvua iji abe ai moikum namo ijia karioin. Regavo bu ar muvua ijin game vierafega God fuka ma ga ar muvuaka iji God fu Mosis kuardama fu gainma bu ijeg sain. ");
INSERT INTO nvm_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Regavo rad saifnuvuon bu ar muvuaka iji abe afijaf miava bu dab gieme e Josuana e ar kafoko ijiebuon ar abekuai vain. Regavo Godri ifejdiama bu e moik ijekor iji kuriaireva bu subinai vain. Bu subinai vakoga ar iji fum ijia na roke e Devidon tavan ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Devid fu unam amarigia kegoino ijefuon God fu Devid abe nidoin. Ijefuon Devid fu una God kua, Ar Jekafon God ijefuon ni kie na ar on be savno kuain. ");
INSERT INTO nvm_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Rega Devid fu bakigavo fu e Soromonri Godon ar be sain. ");
INSERT INTO nvm_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Regavo God fu e bomanado fuba ar emab sainva ijia fik. Regavo e Godon vuak vierafene kuainma iji fu ijeg kuai, ");
INSERT INTO nvm_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","God fu kua, Varur gafi fu ar nun gavo moikigi na dia ijia korevo ijefuon ja ar izia nuifuon sak? Regavo ar na ijia fikfuon iji izer? Regavo ire fok igi nan nar imut nun igia amardiain. ");
INSERT INTO nvm_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stiven fu suar iji kuardia barme uri kia, Ja sibe nui giren. Jaika e taraikor igeg Godon vuak iji jaba faiv. Ja e saifjon bu kenva jak ja ijeg Godon Kaven iji nuigafav. ");
INSERT INTO nvm_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Regavo saifjon ijieb e iji Godon vuak vierafene kuaivo iji kaniain. Regavo madu e ma iji bu kia fu ruakno kiainva iji ja iviakma koikjon kunaim kanain. ");
INSERT INTO nvm_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Godon vuak iji anera bu abe roka jan fain gavo irerafuon jaba vuak iji igain. ");
INSERT INTO nvm_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","E iji karinva bu Stivenon vuak iji faiva buka ma deajidiamga bu uri kuriaikuriaikin igia kuriaireme fu ziegafain. ");
INSERT INTO nvm_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Regavo Stiven e ka Godon Kaven Akai ijar oifuon ijia raren ijefuon fu gafeg varur gufia ga God fino ijia fuka sanako Jesu fu una Godon imut maink ijia fin. ");
INSERT INTO nvm_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Fu ijia figa Stiven fu game kume, Varur fu daja ruvako naga Jesu fu una Godon imut maink ijia fina na gainvano kumen. ");
INSERT INTO nvm_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","58","Fu ijeg kumega e fok bu imut ada bijume set iduadiaga bu savo buon iji ru moik ijia name vakga e nivek Sor kuavo ijar samuagdiako bu biom Stiven manino ijia vain. Bu ijia usem fu diakara dab ar iji bu karinva iji arega abe usem makaf ijia mun tuame kanain. ");
INSERT INTO nvm_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Buba aren gavo buka kanako fu uri kume, Jesu E Bomana ni kaven nun iji abene kumen. ");
INSERT INTO nvm_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Areme fu uri ato same biumame kume, E Bomana unam ise igi bu nun rejo iji ni giame aremne kumene ijia guain. Bu ijegreja e Sor fu giame oifuon ijia vierafene kuai magoino kuain. ");
INSERT INTO nvm_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ijia anerene e Jesu ma vierafejo Jerusarem karinva bu ijia vajai fian aben. E afasor iji bu bakigavo e fok ar ijia karinva bu dab ataseme ar Judia ga Sameria ijia vain. ");
INSERT INTO nvm_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","E God ma vierafejo roinb bu Stiven abe niraifiriknum abe mako ruin. ");
INSERT INTO nvm_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Regavo e Sor e Jesu ma vierafejo ijiebuon unam dab iserekafa ijefuon gire buon ijia ajiemoijknum barubara imut kara kuniairu makaf ijia koreme kam dibur uniain. ");
INSERT INTO nvm_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","E Jesu ma vierafejo iji bu dab atase vainva iji bu una ar iror ijia oknum e iji God fu kuama fu moikigia ari ruainma ijefuon vuak iji abe e roin kuardiaoin. ");
INSERT INTO nvm_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Bu ijegrekoga e Firif fu va mai be moik Sameria guf ijia kekome Jesuon vuak iji abe ijia kuardiain. ");
INSERT INTO nvm_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Regavo e fok ijia karinva iji buka e Firifon vuak iji mukoi faivknum ga unam sumakin fu reno iji gain. ");
INSERT INTO nvm_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","E Firifri ijegrega e iji kaven ise bu nirokdiainva iji bu una arega usem vakga e vajai garenva ijigam e ai kirariainva iji bu una madiain. ");
INSERT INTO nvm_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ijefuon e mai ijia karinva iji buka oimarvknum oin. ");
INSERT INTO nvm_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","10","Regavo mai ijia e be adam isekma fainma if fuon Saimon. Tavan kafo e iji fu unam sumakin kafo rega e Sameriako bu fu game buka oiserev. E iji fu koikfuon uri e iji kia, Naiji e ikin. Revo e makin abevo e ir vasiakin iji bu vuak fuon mukoi faivknum kuaik, E ijefuon daro iji fuka Godon daro ijekino kuaiv. ");
INSERT INTO nvm_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bu ijeg kuaiv ijefuon maiji fuka tavan jaoikin unam sumakin kafo fu reno iji giavo buka oiserdiaga bu vuak fuon mukoi faiv. ");
INSERT INTO nvm_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Regavo tavan ijia bu Firifon vuak iji God fu izeg efuon ijiebuon oij iji samuagdiamo ijiga Jesuon unam iviamkor fu iji abe kuardiamga bu vuak iji faime buka ma vierafen. Ijefuon Firif fu uri barubara aferdia do ruardiain. ");
INSERT INTO nvm_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Fu ijegrekoga e Saimon fuk fu Jesu ma vierafega e Firif fu abe do ruardama fu una fusik fine unam sumakin iji fu reno iji giama fuka oiseren. ");
INSERT INTO nvm_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ijegrekoga ar Jerusarem ijia e afasor bu faik e Sameriako bu Jesuon vuak iji bun faivga bu Fita ko Jon kiava bu ijia vain. ");
INSERT INTO nvm_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bu va moik Sameria usem e ijiebuon sirimamene God kua, Ni ar e Jesu ma vierafejo iji ifejdiaga bu Kaven Akai on iji abejno kuain. ");
INSERT INTO nvm_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Regavo e iji do ruainva iji bu Godon Kaven buba aben. Regavo bum Jesuon if ijia do ijesugin ruardiain. ");
INSERT INTO nvm_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Areme Fita ko Jonbi e iji imut nigen namdiava bu Godon Kaven iji aben. ");
INSERT INTO nvm_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Saimon fu giak e iji Fita ko Jon bu imut nigen namdiainva iji buka Godon kaven abejga fu uri Fita ko Jon kia, Na mon vajiaga ni na daro miega nak ijeg e imut nigen namdiaga bu Godon kaven abejno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Fu ijeg kiamga Fita fu uri kua, A Godon ire ma iji mon ijia kimekafa vierafeno iji fuka ma ise. Ijefuon na vierafega a mon on ijek mian vak. ");
INSERT INTO nvm_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","God fu gaga oion iji fuka ise ijefuon ab no ifejduok. ");
INSERT INTO nvm_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Rega a unam ise iji a vierafenma iji nuigafiame una Godon ruakma fuka ise on iji giame arek. ");
INSERT INTO nvm_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Aiji a unam igi no rejo iji gama fuka riezdain revo fun unam ise on ijar nigen on fun rarenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Bu ijeg kuavga Saimon fu uri kia, E-e ni nuifuon God kuaga vuak iji ja kuardienva iji fuba nun rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ijegrene bun Godon vuak ma ijiga unam ma iji izeg God fu buon renma ijin kuardiaknum nijaidiame barko Fita ko Jon bun una Jerusarem vain. Bu una vako ijia bu unam ijia Jesuon vuak ma iji abe e Sameriako iji kuardiaknum vain. ");
INSERT INTO nvm_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Areme Godon anera ijar e Firif kua, Aiji unam Jerusarem ijia una gafia Gaza vako ijefuon vakne kuain. Regavo unam iji bu e ijia oijo bakin ga fuka ma usuikor. ");
INSERT INTO nvm_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Ijefuon Firif fun kanaufume fun vako ijia fu e bomana be moik Itiofiako ijiebuon barak Kuinon mon samuamo iji unam ijia bien. Regavo e Itiofia buon bara Kuin ijefuon if iji Kedesino kuain. E bomana iji fu ar Jerusarem ijia Godon sirimamekafa vainma una fata iji bu maf-os kege iritia oijo ijia ajie vuaknum e Asaia e Godon vuak vierafene kuaimon iji fu isoinma iji daknum rok. ");
INSERT INTO nvm_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Regavo Godon Kaven ijar Firif kua, Fata gari maf-os fu dakara ruvako iji samaij ijia ura vakne kuain. ");
INSERT INTO nvm_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Fu ijeg kuamga Firif fu kukum garia keko faik e iji fu Asaiaon vuak iji dama fu faime uri kua, Vuak iji a damo iji abe vierafenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Firif fu ijeg kuardamga e iji fu kua, Na izeg vierafkva bakin revo fu e bes vuak igi na davo iji faime una kuardiekma na ijiason vierafekno kuain. Areme fu Firif kuama fu ajieme fusik fata ijia fikok maf-os ijar dakarama bun vain. ");
INSERT INTO nvm_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Regavo buk ijia Godon vuak kafar be fu ijeg dai, E be fuka maf-sif igeg bu kaniaga bu ekenavo bakin revo jau buon ufuga bu jiekejo bakin ijeg bu fu kanavga fuba vuak kafo ijia kuardiain revo fum ibite nain. ");
INSERT INTO nvm_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Regavo bu fu kunaime abe varaimeknum vuak kufui ijia fu abe kot ren. Regavo fum guainma ijefuon fu erar uifarif fuon ijiebuon vuak iji abe e kuardiakma bakin. (Revo vuak iji e bomana fu dainma iji e Asaiar ijeg kuainma fu iji dain). ");
INSERT INTO nvm_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ijefuon e bomana ijar uri Firif kua, Regavo e iji Godon vuak vierafene kuaimon iji fu e iji erafon fu ijeg kuain? Fu fuifuon ki fu e befuon fu ijeg kuainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Fu ijeg kuamga Firif fu uri ijia anerene vuak iji fu dainma ijiga Jesuon vuak ma iji abe kuardain. ");
INSERT INTO nvm_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bu kuaiknum unam ijefuon roko ijia bu do be game e bomana ijar uri Firif kua, Do be iga revo fube mardo a iviakma na abe igia do ruardiekno kuain. ");
INSERT INTO nvm_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Fu ijeg kuamga Firif fu uri kua, oion fok a God mukoi vierafekma na a abe do ruardakno kuain. Firif fu ijeg kuamga fu kua, Iji na vierafega Jesu Kurais iji fu ma Godon Farifno kuain. ");
INSERT INTO nvm_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Areme e bomana iji fun e iji maf-os abe roko iji kiava bu ijia ireko Firif ko e bomana iji bun ari do ijia useme Firif fun e iji abe do ruardain. ");
INSERT INTO nvm_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Fun do ruardame ajie iror ijia ruako ijia Godon Kaven ijar Firif afem vain. Fu vakga e bomana iji fu gak Firif fu baga fum uri fata ijia ajie fine oimarvknum vain. ");
INSERT INTO nvm_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Regavo Firif fu ga fu una ar Asotas ijia fin. Fu ijia figa fum uri ar ukakna ijia oknum Jesuon vuak ma iji kuardiame roke ar Sesaria ijia kekoin. ");
INSERT INTO nvm_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Bu ijegrekoga e Sor fu deajima fu uri e Jesuon vuak faivo ijin kaniakafa vierafen ijefuon fu va e isuf baroijo ijiebuon e bomana iji gain. Fu game kua, Ni fas be miega na abe va ar Damaskas ijia e Jiusbuon ar bu afuime vuak kuaivo ijia aru barubara bu Jesu jaoijo iji nijaidiame tofdia una igia Jerusarem rokno kuain. ");
INSERT INTO nvm_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","6","Sor fu ijegrene fu ar Damaskas ijia vakafa unam ijia vako ijia migegare kaf gafia saname e Sor ni manina fu tuame moik ijia dijen. Fu ijia dijekoga Jesu fu kume, Sor Sor a irerag fuon ise iji nun reno kumen. Jesu fu ijeg kumega Sor fu una kume, E Bomana a erarno kumen. Rega Jesu fu una kume, Na Jesu e iji a ise nun reno ijino kumen. Ni uri ar Damaskas ijia vaga e be fu irerag a rekfuon ijin kuardamno kumen. ");
INSERT INTO nvm_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Regavo e iji Sorna vako iji bu ir iji fain revo e ma iji buba gain. Ijefuon bu vuak kafo ba kuain rega bum ijia iren. ");
INSERT INTO nvm_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Regavo Sor fu moik iji arega uri ni naraga fuka iseremga ire kafo fuba giain ijefuon bu imut kene ar Damaskas ijia vain. ");
INSERT INTO nvm_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Fu naki nokbek (3) ijeg fu ni fuon iserma fu do ga duok kafo fuba in. ");
INSERT INTO nvm_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Regavo e Damaskasko be if fuon Ananaias fu Godon vuak faimo ijar nimamaime gak Jesu fu kume, Ananaiasno kumen. Rega Ananaias fu uri roin kua, E bomana na igijano kuain. ");
INSERT INTO nvm_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","12","Fu ijeg kuama E Bomana fu kua, Ni kanaufume uri unam bu kua Arirarino kuavo ijia va e Judason ar ijia e Sor e Tasasko ijefuon kia giamne. E iji fu Godon sirimameknum nimamai gak e be if fuon Ananaias fu ro imut fuon ijia vajai fuon ijia kunaima fu ni fuon una narama fu gain. ");
INSERT INTO nvm_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Rega Ananaias fu kua, E bomana e iji fu eon ar Jerusarem karinva iji isema rediam. ");
INSERT INTO nvm_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Regavo igia fu ruainma iji fu e mamkanuk Godon isuf baroijo iji kiamga bu igakva fu igia Damaskas e a ma vierafejo iji tomdiakafa fu ruainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Fu ijeg kuamga E bomana iji fu kua, Ni uri va gamne na fu kuaga fu nuifuon ik rene if nun iji abe ar iror ijia Kin ijigam e Jius iji kuardiaga bu if nun iji abe ma vierafek. ");
INSERT INTO nvm_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","E iji fu enun ijefuon na koiknun unam izeg fu nuifuon vajai fian abekfuon iji na nijaiga fu vierafek. ");
INSERT INTO nvm_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ijefuon Ananaias fun va ar ijia kekome aru imut fuon ijia Sor kunaime kua, Sor uviainu na E Bomana ijar na kiemga na ruain. Jesu e iji a igia ruakafa roko unam gafia a gainma ijar fu una ni on iji amarega kaven fuon iji fu oion ijia ari a samuagdakafa fu iji kiema na igia ruain. ");
INSERT INTO nvm_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","19","Fu ijeg kuardako migegare ire be kijum gen igekin ijieb Soron niom ijia azoiksa ariko ni fuon fu una maren. Fun marmga fu uri manikoga bu fu abe do ruardama fu uri duok ine daro fuon una aben. Fu daro abene naki sibank fu ar Damaskas ijia fiknum e Jesu jaoijo ijiena naioin. ");
INSERT INTO nvm_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Fu amur va ar e Jius bu afuim vuak kuaivo ijia kekome e iji vuak kuardiame kia, Jesu iji fu ma Godon farifno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Fu ijeg kuardiamga e fok bu vuak iji faiva buka oiserdiama bu bui kuai, E iji fu ar Jerusarem ijia e iji Jesu ma vierafejo iji kaniamo ijar. Regavo fu igia ruainma iji fu e igi tofdiame una e mamkanuk Godon isuf baroijo ar Jerusarem karinva ijia vakafa fu ijefuon ruainmano kuain. ");
INSERT INTO nvm_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Regavo e Sor vuak fuon fu kuardiamo iji fuka ma darokin rega e fok ar Damaskas karinva iji bu vuak iji faime bu ma vierafen. Areme bu ijia vierafero Jesu fu ma Godri kuamga fu ari ruainmaro bu ijeg vierafen. Regavo e Jius ar Damaskas karinva iji bu izeg Soron vuak iji asikva bakin. ");
INSERT INTO nvm_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","25","Regavo tavan kafo barenma ijia e Jius iji bu bui ujuinamime e Sor kanakuai kuaiv revo Sor vuak iji fun fain. Ijefuon nakikmaza ijia e iji bu mai vien ijia fu kanakuai ijia samua karioij. Bu ijegrejga e Soron vuak faivo iji bu isuar naki Sor abe ire kamuij igekin ijia abakarime abe fak iji bu kirainva iji gama abesen. ");
INSERT INTO nvm_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","30","Areme e Sor fu va Jerusarem ijia kekome e Jesuon vuak faivo ijin biediame buna okrega e Jesuon vuak faivo iji buka juin. Ijefuon maiji e Sor fu Jesuon vuak faimo be renma iji buba vierafen. Regavo e Banabasri ro kekome Sor afeme abe e afasor iji miame vuak izeg E Bomana fu Sor kuardainma ijiga izeg Sor fu E Bomana iji gainma ijigam izeg Sor fu Jesuon vuak gigikin fu e Damaskasko iji kuardiainma iji abe kuardiain. Ijefuon Sor fu ar Jerusarem ijia oknum Jesuon vuak iji darokma kuardiaoin. Sor fu ijegrejknum vo e Jius iji bu e Grikbuon isama ijia kuaiknum dab mafaivo iji kuaim amaren. Regavo e iji bu uri fu kanakrejga e Jesuon vuak faivo iji bu game uri Sor afem ar Sesaria ijia useme kuava fu una ar Tasas ijia vain. ");
INSERT INTO nvm_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Regavo e Jesuon vuak faivo iji ar Judia ga Grik ga Sameria ijia karinva iji bu una afurveknum kari vain. Regavo Godon Kaven ijar daro miaknum ifejdiama buka e uruvana rene E Bomana iji agoiknum ma vierafene karioin. ");
INSERT INTO nvm_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","34","Fita fu ai kafokafo oino ijia fu ar Rida ijia Godon e iji giakafa vain. Fu va ijia kekome e Ainias bien revo e iji fu diak ise fu juaivasia eit (8) igeg fuba diak oin. Ijefuon Fita fu Ainias kua, Jesu Kurais fu a amardainmano ni uri suf on kara matome vakne kuamga Ainias fu migegare uri arir manin. ");
INSERT INTO nvm_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Regavo e fok ar Rida ga Seron karinva iji bu fu game una oi karoime E Bomana ijefuon ruain. ");
INSERT INTO nvm_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Regavo bara be Jesuon vuak faimo if fuon Tabita ga Grikbuon vuak ijia bu kua Dokasno kuavo iji fu ar Jofa ijia fino. Regavo bara iji fu naikafare fuka ma rejknum e isema karinva iji ifejdiamon. ");
INSERT INTO nvm_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Fu ijegreoinon ijia fu adam abe vake guamga bu surif fuon dab do ruardame abe ar guf kaf ijia abeden. ");
INSERT INTO nvm_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Rega ar Rida fu Jofa samaij ijia ijefuon e Jesuon vuak faivo iji bu faik Fita fu ar Rida ijia oina bu fain. Bu faime e nokarok (2) kiava bu Fita afem migegare ruakuai vain. Bu vake ar Rida ijia usem Fita kuava fu migegare uri buna vake ar Jofa ijia kekoin. ");
INSERT INTO nvm_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Fu ijia kekomga bu fu afem ar guf kaf ijia ajie vain. Bu vagak bara amun fok bu sinuom kafo Dokasri buifuon amardiainma iji kege una fu nijaiknum niraifiriv. ");
INSERT INTO nvm_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Fita fu bara iji kiama bu usem vakga fu dakaroim bara iji guainma iji gavknum ato same sirimamene kua, Tabita urine kuamga bara iji fu ni narame Fita gavknum uri arir fin. ");
INSERT INTO nvm_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Fu uri arir figa Fita fu uri bara iji ifejdame imuike unama fu uri arin maniga fu bara amun iji abevo e God ma vierafejo iji nijaidiame kia, Bara igi fun una urinmano kiain. ");
INSERT INTO nvm_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Fu ijeg kiakoga vuak iji fun migegare igia e ar Jofa iji karinva iji buka faim baren. Areme e fok bu oi karoime E Bomana iji ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Rega Fita fu Jofa ijia tavan kafo e Saimon fu fanuf surif kege sinuom amardiamo ijek fioin. ");
INSERT INTO nvm_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","2","Ar Sesaria ijia e be if fuon Konirias fu e bijaivo ijiebuon e bomana ga fu madu e Itariko buon e bijaivo fok samuagdiamon. Regavo fu ga agbara fuon ijin buka God ma vierafeknum e iji bu oifiaigma karioijo iji oijmiame duok vajiaknum ga tavan fok fuka God sirimameno. ");
INSERT INTO nvm_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Fu ijegre vake nakibe tavan gara vako ijia fu nimamaime samakaf gak Godon anera be fu ro kua, Koniriasno kuain. ");
INSERT INTO nvm_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Fu kuamga Konirias fu uri juvknum uruvana igia anera iji nikajame kua, E Bomana a izegrenmano kuain? Fu ijeg kuamga anera iji fu uri Konirias kua, E oifian abejo iji a ifejdiamo ijigam buifuon a sirimameno iji God fun vierafenmano kuain. ");
INSERT INTO nvm_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ijefuon ni iviakma e kafo kia bu va ar Jofa ijia e Saimon e iji bu kua Fitano kuavo iji afem rofno kuain. ");
INSERT INTO nvm_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Regavo fu e nabui fuon Saimon be iji fu fanuf surif ijia kege sinuom amardiamo ijek fin gavo ar fuon fu saof irif ijiano kuain. ");
INSERT INTO nvm_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","8","Areme anera iji fu vuak kuardamo iji fun vako Konirias fu uri e ar fuon ijia ik rejo iji nokarok (2) ke are e bijaivo be fu ifejdamo iji God ma vierafeno ijin aben. Areme fu kiama bu rokga fu uri vuak fok fu nimamaime gainma iji kuardiame kiama bu ar Jofa ijia e Fita afekuai vain. ");
INSERT INTO nvm_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Bu vako afarma tavan uk manino ijia e iji Fita afekuai vainva iji bun vake mai iji samaireko ijia Fita fu ar azan ijia ajieme sirimamekafa vain. ");
INSERT INTO nvm_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","11","Regavo fuka vasiaguainma ijefuon fu duok kafo ikafa vierafen ijefuon bu fuifuon duok amarekoga fu ijia nimamain. Fu nimamai ga kaf gafia vien fuka dajame ire ugon igekin bomana be bu dab abesva fu moik ijia ari ruain. ");
INSERT INTO nvm_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Regavo ugon iji fu fanuf ni kafokafo ga um kafokafo ijekma ari ruain. ");
INSERT INTO nvm_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Areme kaf ijia vuak be ijia kume, Fita uri fanuf ijigam um iji kania bua ine kumen. ");
INSERT INTO nvm_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Rega Fita fu una roin kume, E Bomana na ijeg naba rekfuon ijefuon maiji duok ise ijekin iji naba ijno kumen. ");
INSERT INTO nvm_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","16","Fu ijeg kumega vuak be fu una madu kaf gufia kumen. Ire ijekin iji fun usuibe Godri ja ikfuon amardiain ijefuon ab kua duok iji bu iseno kuaik. ");
INSERT INTO nvm_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","18","Rega Fita fu vek fine ire iji fu nimamaime giainma iji vierafeko e iji Konirias fu kiama bu ruainva iji bun Saimonon ar iji game ro vien ijia iren. Bu vien ijia ireme kia, E Saimon Fita kuavo iji fube ijia fino kiain? ");
INSERT INTO nvm_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","20","Bu ijegreko Fita fu vek ijia fine ire iji fu nimamaime gainma iji vierafeno ijia Godon Kaven fu kua, Saimon e nokbek (3) bu a nisaivno ni uri una moik ijia ari vakne kuain. Regavo ab mani vierafek gavo nin buna vakne. Ijefuon maiji e iji nar kiava bu ruainvano kuain. ");
INSERT INTO nvm_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Areme Fita fun ari moik ijia kekome e iji kia, E iji ja nisaivo iji na iga ga ja irerafuon ruainvano kiain. ");
INSERT INTO nvm_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","23","Fu ijeg kiamga bu kua, No Konirias e bijaivo ijiebuon e bomana ijar kuoma no ruain. Regavo e iji fuka ma amarigia reoknum God ma vierafeno gavo e Jius fok bu fu agoiv. Ijefuon Godon anera iji fu Konirias kua, Ni a kuaga a ar fuon ijia roga fu vuak on a kuaimon iji faimne kuain. Areme Fita fun e iji aferdia ar guf ijia aru funa naoikuai vain. Regavo afarma Fita fun urine buna vakoga e Jofako roin God ma vierafejo iji bu funa vain. ");
INSERT INTO nvm_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Bu vake tavan besum ijia bu Sesaria ijia usen. Regavo Konirias fu bu vakfuon iji samua fido fun aganfuon ijigam kaifijaf iji kiama bu besum afuime karin. ");
INSERT INTO nvm_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Bu besum afuim karikoga Fita fu ik vien ijia arumo ijia Konirias fu uri fu bieme aguaiknum ato sakafain. ");
INSERT INTO nvm_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Fu ijegrega Fita fu kua, Naiji nam ema narno urine kuain. ");
INSERT INTO nvm_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","29","Areme Fita fu Koniriask vuak kuaiknum aru vagak e uruvana bu ar guf ijia karijga fu kia, Jan vierafen no akai nuvuon ijia e Jius bu e Jius bakin ijiena afuiknum ga bu giavo bano kiain. Regavo God fun na kie, Ab vierafero e kafo bu e ise gavo ar e maro ab ijeg vierafekno kien. Ijefuon bu na aferdiekuai vuakga naba uzain gavo nam uri ruain. Ijefuon naba kiak ja irerafuon na kieva na igia ruainva kiak? ");
INSERT INTO nvm_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Fu ijeg kuardiamga Konirias fu una roin kuai, Naki nokbek (3) barenma ijia na ar nun ijia tavan una gura manino (tiri (3) o korok) ijia na sirimamejga migegare e be ugon zin igeg iramo iji sainma ijar fu nifak nun ijia manin. ");
INSERT INTO nvm_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Fu manine kie, Konirias God fun on a sirimameno ijigam ire iji a e isema karioijo iji a vajiamo iji fun game vierafen. ");
INSERT INTO nvm_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ijefuon ni e kiaga bu va Jofa ijia e Saimon Fita kuavo iji fu e Saimon be iji fu fanuf surif ijia kege sinuom amardiamo ijek saof irif ijia fino iji afem rokne kien. ");
INSERT INTO nvm_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ijefuon na migegare oifuon kiava bu vuainva an magoi ruainmado no Godon nifak igia kari faivo ni vuak fok E Bomana fu nuvuifuon kuardainma iji no kuarduomne kuain. ");
INSERT INTO nvm_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","35","Fu ijeg kuardame arekoga Fita fun uri anerene kia, Iviakma nan vierafega God fu e roin oimardiaga e roin fu uzamo bakin. Regavo fum e moik kafokafo eraneb fu ma vierafeknum ma rejo iji aferdiam. ");
INSERT INTO nvm_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Regavo igi Godon vuak iji fu e Isrerko iji nijiainma ijin. E fok ijiebuon E Bomana Jesu Kurais fu buifuon ire be rekreno ijefuon vuak ma iji ja Godna afuikfuon ijin. ");
INSERT INTO nvm_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","38","Regavo ar Judia ijia izegrenma iji jan vierafen Jon fu Jesu do ruardainma ijia God fu Kaven Akai fuon kuama fu Jesu e Nasaretko ijefuon oij ijia arin. Fu ijia arimga fu daro abene unam ma ijia reoknum mareknum e iji Setan fu aferdiama bu efuon renva iji amardiame karauniaknum ijeg reoin. Regavo Godon Kaven fu fusik oino ijefuon fu ire ijeg reoin. Regavo ire iji fu renma iji fu ar Gareri ijia anerene gafeg vainmano kiain. ");
INSERT INTO nvm_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","41","Regavo ire fok fu e Jiusbuon ar ijigam Jerusarem ijia fu reoinma iji nor giain. Regavo bu fu abe kuros ijia kanavga Godri naki nokbek (3) barko ijia keunama fu una urina e roin bu gain. E fok buba gain gavo no e iji God fu kuoma no funa besum oinva iji nor fu una urina no funa besum duok ga do inva iji nor fu gain. ");
INSERT INTO nvm_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Regavo fu ijeg kuo, Ni e fok kia naiji na ma Godri kienmado na Godon vuak ma iji nijaidiaknum e iji aoinva ijigam nivek karinva iji fine ise buon iji ke mazim giak. ");
INSERT INTO nvm_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","E Godon vuak vierafene kuaivo ijieb fuisina kuai, Erar fu Jesu ma vierafekma ise fuon fu reno iji Jesur if fuon ijia giame arekno kuin. ");
INSERT INTO nvm_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Fita fu vek vuak iji kuaimon ijia Godon Kaven fu ari e iji vuak iji faivo ijiebuon ruain. ");
INSERT INTO nvm_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","E Jius God ma vierafejo iji bu Fitana ruainva iji buka oiserdiain ijefuon maiji Godon Kaven fu ari madu e iji Jius bakin ijiebuon oij ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","48","Ijefuon maiji bu fai e Jius bakin iji buka vuak nanuame kuaiknum Godon oimarev. Rega Fita fu uri kia, E be fuba e igi bu do ruaikrejo iji bijukuriak. Buka izeg Godon Kaven iji no abenva buk ijeg aben. Ijefuodo buka Jesu Kuraison if ijia kege do ruardiak. Areme bu Fita kuava fu naki sibank fu ijia buna fin. ");
INSERT INTO nvm_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Areme e afasor ijigam e kafo God ma vierafejo iji ar Judia ijia karinva iji bu fai e ar kafoko e Jius bakin iji buk bun Godon vuak iji abe ma vierafej. ");
INSERT INTO nvm_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Ijefuon tavan iji Fita fu Jerusarem ijia vakga e Jius iji bu vajai surif buon ufume anf navo ijin ma vierafejo ijieb uri fuisina kuaime kuai, A vainma a e Jius bakin ijiebuon ar ijia ajie buna duok inmano kuain. ");
INSERT INTO nvm_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Bu ijeg kuavga Fita fu uri vuak fok izeg fu renma iji anej gamia kuardiame vake garin gafia baren. ");
INSERT INTO nvm_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Areme Fita fu una uri kia, Na Jofa mai ijia fine sirimamejo ijia na nimamai ga ire ugon igekin iji bu kaf gufia dab abesva fu ari roke na fijo ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Fu ijia ari rokga na ga ugon iji fu fanuf kafokafo ijigam um kafokafo iji anuinva ijar ari ruain. ");
INSERT INTO nvm_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Na iji gavknum na fai kaf gufia vuak be na kume, Fita ni uri ire iji kania bua ine kumen. ");
INSERT INTO nvm_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Fu ijeg kumega na una roin kua, E Bomana iji naba ijeg rek. Na duok ise ijekin kafo naba invano kumen. ");
INSERT INTO nvm_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Na ijeg kumejga kaf gufia fu una madu kume, Ire iji fun Godri amardiainmano ab kia iseno kiak. ");
INSERT INTO nvm_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Vuak iji fu nokbek (3) ijeg kuardieme ire ugon igekin iji fun una varur gufia ajie vain. ");
INSERT INTO nvm_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ijegrekoga e nokbek (3) iji bu na aferdiekuai ruainva iji bu ro ar na fijo vien ijia iren. ");
INSERT INTO nvm_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Bu ijia irekoga Godon Kaven fu na kie, Ab mani vierafek nin buna vakne kien. Areme enun God ma vierafejo e sibank buk bu uri nana vake Koniriason ar ijia usen. ");
INSERT INTO nvm_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","No Koniriason ar ijia aru vakga fu vuak izeg anera iji fu ar fuon ijia ari vuak kuardainma iji kuarduin. ");
INSERT INTO nvm_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Fu kuo, E kafo kia bu va ar Jofa ijia useme e Saimon Fita kuavo iji afem roga fur Godon vuak ma iji abe roga a ga aganon iji bu vuak iji faiga God fu bu karauniakno kien. ");
INSERT INTO nvm_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ijegrene na ik vuak kuaivo ijia Godon Kaven fu izeg amur oi nuvuon ijia ruainma ijeg fu oibuon ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Fu ijegrega na una izeg Jesu fu usuibe kuainma na ijin vierafen. Fu kua, Jon fu e do ruardiain gavo a iji a Godon Kaven abekno kuainma na iji vierafen. ");
INSERT INTO nvm_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","No ma vierafega God fu ire ma iji fu e igi no Jesu ma vierafejo iji reduomo ijeg fu una e Jius bakin iji buon rediain. Revo naiji nam ema ijefuon na ire iji God fu renma iji na irerafuon unam fuon iji bijukva bakin. ");
INSERT INTO nvm_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","E iji bu vuak iji faime uri kai roinbuon bu kuaivo iji bu areme uri God abe aroiknum kua, Ijekido God fu e Jius bakin iji fu kiaga bu oi karoime ise buon una God kuardame una unam ma ijia karivakno kuain. ");
INSERT INTO nvm_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Bu e Stiven kanavga e God ma vierafejo iji bu bijaiknum musikuaivo iji bu jume dab ataseme uri ar Fonisia ga Saifras ga Entiok ijia vain. Bu ijia oknum Godon vuak iji abe e Jius ijesugin kuardiaoin. ");
INSERT INTO nvm_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Bu ijegreko e God ma vierafejo roin bu ar Saifras ga Sairini iji bu va ar Entiok ijia usem Jesu E Bomana ijefuon vuak ma iji abe e Jius bakin iji madu kuardiain. ");
INSERT INTO nvm_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Regavo Godon daro iji fuka ijia buna ijefuon e uruvana bu God ma vierafene una oi karoime E Bomana ijefuon ruain. ");
INSERT INTO nvm_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ijegrekoga vuak iji fu va Jerusarem sos ijia kekomga bu uri e Banabas kuavga fu ar Entiok ijia vain. ");
INSERT INTO nvm_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Fu va gamia kekome izeg God fu e iji daro miainma iji giama fuka oimaimga fu kia, Jab E Bomana iji uzak revo jaka amarigia fu igame jafno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Regavo e Banabas fuka e ma fu God ma vierafen ga Kaven Akai fuon ijefuon daro iji aben. Ijefuon e uruvana fur oibuon ke karoimga bu una E Bomana iji ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Areme Banabas fu ar Tasas ijia e Sor nisaim vain. ");
INSERT INTO nvm_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Fu nisaim vake bieme afem una ar Entiok ijia ruain. Bu ijia usem juaivasia besum (1) ijia Banabas ko Sor bu sos ijia e uruvana Jesuon vuak nijaidiain. Bu nijaidiavga ar Entiok ijia e iji bu amur Jesuon vuak faime ma vierafejga bu kia Kuristien no kiain. (Revo if ijefuon maiji e iji bu oi karoime Godon Kaven abenva ijin). ");
INSERT INTO nvm_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tavan besum ijia e Godon vuak vierafene kuaivo iji bu ar Jerusarem arega Entiok ari vain. ");
INSERT INTO nvm_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Regavo e be if fuon Agabas fu Godon Kaven ijefuon daro ijia fu uri manine kia, Moik fok fu vasia kekokveno kiain. Regavo tavan ijia e Krodias fu e bomana renma ijia vasia fu ijia kekoin. ");
INSERT INTO nvm_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Regavo iviakma igi e Jesuon vuak faivo iji bu Agabason vuak iji faime vierafero bu giriesame mon mamkanuk kafo e Jesuon vuak faivo iji ar Judia ijia karinva iji vajiakuai vierafen. ");
INSERT INTO nvm_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bu ijegrene ire buon bu kege e Banabas ko Sor vajiavga bur kege vain. ");
INSERT INTO nvm_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Areme tavan ijia Kin Erod fu e sos vako iji roin tofdia kam arafiriakafa vierafen. ");
INSERT INTO nvm_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Fu e Jeims e Jonon diar iji kiama bu ire kaki jaoijor ijia dab bijava fu guain. ");
INSERT INTO nvm_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Fu ijegrejknum gak e Jius iji bu unam iji fu reno ijia oimarvga fu uri madu Fita toin. (Revo iji fu tavan iji bu besum afuime bred iriaikin ijefuon iro ijo ijia fu ijeg ren). ");
INSERT INTO nvm_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","5","Bu Fita tome rad bu dab dibur unavga e bijaivo kafo bu atame nokarok ga nokarok (4) rene fu samuame karij. Bu karivake tavan abega bu vako kafo busik ro vien iji samuav. Bu ijegrekoga Kin Erod fu vierafero tavan iji Fasova iji barekma fu Fita dab e fok ijiebuon nifak ijia kot rekro fu ijeg vierafen. Fu ijeg vierafene Fita dab dibur unain. Regavo e sos ijia karinva iji buka Fitan giriesame Godon sirimamen. ");
INSERT INTO nvm_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Regavo niar igeg Erod fu Fita afem e ijiebuon ruakoga ga naki ijia Fita bu sen nokarok (2) kege kiriadame arevga fu e iji bu e diburko iji samuagdiavo nokarok (2) bu roinroin reko fu uf ijia nain. ");
INSERT INTO nvm_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Fu ijia naikoga e iji roin bu dibur vien iji samuame iren. Bu ijegrekoga migegare Godon anera be fu ari dibur guf ijia manikoga ijia tavan igeg sanain. Areme anera iji fu uri Fita faraf ijia kunaime sama fu uriga fu kua, Migegare urine kuain. Fu ijeg kuako sen fok bu Fita imut ijia kiriamdainva iji bu iraiksain. ");
INSERT INTO nvm_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Areme anera iji fu uri Fita kua, Sinuom on amarigia same diak surif on ke same uri ugon on e iduadiaga bu savo iji abe abese nosik vako rokne kuain. ");
INSERT INTO nvm_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Fu ijeg kuamga Fita fun uri ijegrene anera iji jame dibur iji arega keko makaf ijia vain. Fita fu anera iji fu reno iji fuba mukoi vierafen gavo fu vierafero fu nimamainmaro fu ijeg vierafen. ");
INSERT INTO nvm_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bu ijegrene usem roke ar be e dibur samuagdiavo iji bu irenva ijia asim roke vien be e bu samuavo ijia usen. Bu ijia usevga vien iji bu ajan ijia abe amarme bijukurainva iji fu koikfuon dajamga bu ijia usem vain. Bu useme unam be ijia vakga anera iji fun migegare ijia Fita unako vain. ");
INSERT INTO nvm_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Fu uname vakga Fita fu ijia izeg fu dibur iji arega keko ruainma iji vierafene fui kuai, Iviakma nan vierafe God fu anera fuon kuama fu na keuniekafa ruain. Ijefuon maiji na Kin Erodon daro rotit ijia fij gavo madu e Jius iji buk bu na abe ire ise kafo rekrejo ijefuon anera iji fu ruain. ");
INSERT INTO nvm_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","13","Fu ijeg vierafene fun vake bara Meri e Jon Makon asiej ijefuon ar ijia kekoin. Fu keko ga e uruvana bu ijia afuime sirimamejga Fita fu vien ijia manine kanakanama bara be if fuon Roda kuavo ijar keko e iji kanakanamo iji gakafa ruain. ");
INSERT INTO nvm_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Fu ruaknum Fitan ir iji faima fuka oimaimga fuba vien iji dajain revo fum una kukum aru e iji kia, Fita fu vien gafa manino kiain. ");
INSERT INTO nvm_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Fu ijeg kiamga bu kua, A no biesumno kuavga fu una madu kia, Naka ma kuardiav. Roda fu ijeg kiamga bu kua, No vierafe fu kaven fuon ijarno kuain. ");
INSERT INTO nvm_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Bu ijegreko Fita fu vek ijia manine kanakanamga buson uri vierafene va vien dajame ga fu Fitar maniga buka oiserdiain. ");
INSERT INTO nvm_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Areme Fita fun imut fuon ijia e iji bijukuriama bu isuar kariko fu uri E Bomana iji fu izeg fu afem ar dibur iji arega keko ruainma iji kuardiain. Fu kuardiame kia, Ni vuak iji abe Jeims ga e Jesu ma vierafejo kafo iji kuardiafno kiame fun bu areme uri ar be ijia vain. ");
INSERT INTO nvm_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Fu ijegreko ve irasemga e iji dibur samuavo iji bu uri Fita nisaime dab bui sigunamin. ");
INSERT INTO nvm_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Rega Kin Erod fu kiama bu una madu Fita nisain revo buba fu bien. Ijefuon fu e dibur samuavo iji kiama bu fuon rokga fu duna kafokafo kiame uri e bijaivo iji kaniakafa kuardiain. Regavo rad Erod fu Judia iji arega va Sesaria ijia keko naki kafo fu ijia fin. ");
INSERT INTO nvm_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Regavo Kin Erod fuka e ar Taiako ga Saidonko iji fuka ziegafiamga bu ijefuon besum afuime Erod gakuai vain. Bu vake gafia useme e Brastas fu Kin ijefuon ar iji samuamo ijia usen. Bu vierafe bu amur bu fu soisoiga fu buna rene bu ifejdiakma bu ijefuon fu soisoin. Bu ijegrene bun va Erod fino ijia kuaga fur izeg bu amur buon ziegafanamioinva iji bijukuriakafa ijefuon maiji duok buon bu ijo iji bu Kin ijefuon moik ijia karvo. ");
INSERT INTO nvm_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tavan be bu abedenva ijia Erod fu ugon fuon mukor ijesugin same ajie fata fuon ijia fine e uruvana vuak kuardiain. ");
INSERT INTO nvm_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Fu vuak kuardiamga e fok bu uri kume, E igi fu ema ijar kuarduomo bagavo fu Godri kuarduomno kumen. ");
INSERT INTO nvm_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Erod fu God fuba juvknum agoin gavo fu fine ijegrega tavan besum ijia E Bomana ijefuon anera ijar ari fu kana dasu abesemga fun guain. Fu ijia guamga ire nifun ijieb fu zain. ");
INSERT INTO nvm_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Fu guamga Godon vuak iji buka dab kuaim bomana rene ar fok ijia vain. ");
INSERT INTO nvm_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Regavo Banabas ko Sor bu Jerusarem ijia ik buon bun re barme e Jon Mak afem una ruain. ");
INSERT INTO nvm_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Regavo ar Entiok sos ijia e kafo Godon vuak vierafene kuaivo ijigam e vuak nijaidiavo ijiebuon if iji Banabas ko Simion e iji bu kua e kazin no kuavo ijin. Regavo madu e Rusias e ar Sairinko ijigam e Manain e Kin Erodon farif iji fu farikenma ijigam e Sor ijieb Godon vuak kuaiv. ");
INSERT INTO nvm_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","E ijieb bu E Bomana ijefuon e iji ifejdiame sirimameknum duok karovga Godon Kaven ijar kia, E Banabas ko Sor iji kege garia be uniainki bu ik be na kiainva bu iji rekno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Fu ijeg kiamga bun duok karoknum e Banabas ko Sor ke imut nigen namdiame buifuon sirimamene kege uniavga bun vain. ");
INSERT INTO nvm_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Banabas ko Sor bun Godon Kaven fu kiainma ijeg bun ari va ar Serusia ijia useme ijia sisim abe saof ijia moik be datura namo bu kua Saifurasno kuavo ijia vain. ");
INSERT INTO nvm_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Bu va ar Saramis ijia usem e Jiusbuon ar bu afuime vuak kuaivo ijia aru ireme Godon vuak iji kuardiain. Regavo e Jon Mak fu buna vaindo fu ifejdiame vuak kuardiain. ");
INSERT INTO nvm_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Areme bun ar Saramis areme bun saof uf ijia ura gama usem vake ar Fefos ijia usem e be if fuon Ba Jesu fu e masifdiamo iji bien. Regavo e iji fu e Jius gavo fu e iji vuak kufui kuardiame kia, Naiji na e be Godon vuak vierafene kuaiv e ijino kiain. ");
INSERT INTO nvm_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Regavo Ba Jesu fu e Segias Foras e iji fu ar moik iji daturaik namo iji samuamo ijefuon kai. Regavo e Sejias Foras fuka e nigen ma fu ire fok amarigia vierafeno. Regavo e iji fu Godon vuak iji faikafa vierafen ijefuon fu Banabas ko Sor kiama bu fu fino ijia vain. ");
INSERT INTO nvm_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Bu ijia vakga e Ba Jesu e iji e masifdiamo iji bu e Grik buon isama ijia bu kua Erimasno kuavo ijar e moik iji daturaik namo iji samuamo ijin kuriairen. Fu kuriaireme oifuon iji abe dakaroiga fu vuak iji bu kuardakrejo iji fuba ma vierafekafa fu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Fu ijegrekoga e Sor if fuon be For iji fu Godon Kaven ijar oifuon ijia arimga fu uri e iji e masifdiamo iji nikajame kua, Aiji a Setanon farif gavo aka ire ma igiena bijaikreno kuain. Revo madu vajat on fuka ire isekma ijieb ajiemdainva ijefuon aka naikafare E Bomana ijefuon vuak ma iji abe kufuimene kuaimon. ");
INSERT INTO nvm_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ijefuon iviakma E Bomana iji fu ire nibe rega ni on fu zuriaiga a tavan ivuankbe aba sanainma iji gak. Fu ijeg kuardamga Erimas fu ga vana kazin ijar ni fuon iji okuramga fu uri oknum imut ijia e ijin barame ofai arega e ijieb fu imuikedavro fu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Erimas fu ijegrega e iji moik iji datura namo iji samuamo iji fu ire sumakin iji gama fuka oiseren. Fu oiseremga fu ijia E Bomana ijefuon vuak iji bu nijaidiavo iji faime ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Areme rad For ga e iji funa oijo iji bun sisim abe ar Fefos areme vake ar Fega moik Famfiria guf ijia usen. Bu ijia usekoga Jon Mak fun bu uniakome una Jerusarem vain. ");
INSERT INTO nvm_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bu Fega nak roke ar Entiok moik Fisidia guf ijia usen. Bu ijia useme ga tavan iji fu e Jius bu isuar karijo iji game bun e ijiena e Jiusbuon ar bu afuim vuak kuaivo ijia karin. ");
INSERT INTO nvm_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bu ijia kariko e iji bun Mosison akaij ijigam e Godon vuak vierafene kuaivo ijiebuon vuak iji dain. Bu dame barekoga e mamkanuk iji Jiusbuon ar iji samuavo iji bun vuak be e iji Forna vainva iji nijain. Bu nijiame kia, Uviaifnuvuon gamie ja vierafega ja vuak kafo e igi soisoime kuardiakuai vierafekva ni uri ro kuardiafno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Bu ijeg kiavga For fun vuak kuardiakafa uri imut ajieme anere vuak kuardiain. Regavo vuak iji For fu kuardiainma iji fu ijeg kuain. Enun fokigie e Isrerko abevo e Jius bakin iji eraneb Godon sirimameknum God ma vierafejo iji vuak igi faif. ");
INSERT INTO nvm_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","18","E Isrerko ijiebuon God ijar saifnuvuon iji kiamga bu moik Ijift ijia kariko buka e uruvana ren. Regavo God besum ijar daro fuon ka ma bomana iji abe e iji nijaidiame aferdia moik iji are keko ruain. Regavo fuka juaivasia foti (40) ijeg ai moikum namo ijia oknum God dab vuak ise fuisina kuain revo fuka vek bu amarigia samuagdiain. ");
INSERT INTO nvm_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","20","Regavo fu moik Keinan guf ijia e isama kafokafo kuaivo bu moik seven (7) ijia karijo iji fok kaniama bu aoivga fu una e fuon fu aferdia roko iji kiamga bu moik iji abe ijia karin. Regavo bu juaivasia fo adred fifti (450) bu ijia kari ruain. Bu kari ruakga God fu uri e mamkanuk kafokafo iji kege uniama bu ijia karine e fok samuagdia roke e Godon vuak vierafene kuaimon e Samueron tavan ijia ruain. ");
INSERT INTO nvm_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ijefuon tavan iji fu nafenva iji rokga bu una Kinfuon God kuavga God fu e Sor abe miain. Regavo Sor fu e Kison farif gavo fu e Bezmanon uifarif ijefuon bu fu abeja fu juaivasia foti (40) ijeg fu Kin buon ren. ");
INSERT INTO nvm_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Sor fu Kin revake God fu Sor kuama fu areko fu una e Devid abe una e ijiebuon Kin rediain. Areme God fu Devidon vuak iji kuardiain, Na Devid e Jesion farif iji afenvano kiain. Regavo na e ijekin iji vierafedo fur fine ire fok na oinun ijia vierafejo iji fur rek. ");
INSERT INTO nvm_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","For fu ijeg kuardiame madu kia, E Devidon uifarif ijia Godri Jesu e iji e fok karauniamo iji kuama fu e Isrerko buon ruain. Regavo ijiebuon vuak iji fun Godri usuibe kuainma ijefuon fu ijeg ren. ");
INSERT INTO nvm_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesu fu rad ruain revo amur fu Jonri e Isrerko iji kia, Ni ise jon fok ja reoijo iji areme roga na ja do ruardiavno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Regavo Jon fu ik fuon fu reoino iji fun barekrega fu uri e iji kia, Ja vierafe naiji na erano kiain? Areme fu una kia, Naiji na e iji fu ruakrega ja samuavo iji bakin gavo naka ba aresredo naba e iji fu ruakreno ijefuon dia surif fu sainma iji rumdakno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Regavo efnun e Eburamon uifarif ijigam e Jius bakin eraneb ja igia ato same God aroivo igi vuak igi izeg Jesu fu e karauniakfuon iji fu nuvuifuon nijuin. ");
INSERT INTO nvm_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Regavo e ar Jerusarem ijia karinva abevo ebuon mamkanuk iji bu Jesu buka ba ma vierafen. Regavo bum e iji Godon vuak vierafene kuaivo ijiebuon vuak iji bu kuainva ijekma riarekafa bu Jesu dab kot rene kua, A isema renmado a guakno kuain. ");
INSERT INTO nvm_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Bu ijeg kuaime fu abe kana fu guakuai bu uri ire ise fu reoinma iji nisaiga fuka bakiga bu uri Fairet kua, Ni ar e igi abe kana fu guamne kuain. ");
INSERT INTO nvm_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bu Godon buk akaij ijia vuak fok fuisina bu isoime kuainva iji bun re barme kuros ijia fu jafe arime abe mako ijia unain. ");
INSERT INTO nvm_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","31","Regavo Godri fu keunama fu una uri tavan uruvana fu e iji bu funa ar Gareri ijia una Jerusarem vainva iji biediamga bu fu gain. Ijefuon iviakma e iji fu gainva ijieb e Isrerko iji kia Jesu bun gainvano kiain gavo noiji nom vuak fuon ma iji abe jon ruain. ");
INSERT INTO nvm_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Regavo vuak iji God fu amur e makin nuvuon kuardiame kia fu rekno kiainma iji fun iviakma e uifarif buon igi nuvuon rene Jesu keunama fu una urin. Regavo Godon buk be bu kua Samno kuavo ijia bu ijeg isoi, Aiji a Farinun gavo iviakma nan una Asoion renvano kuain. ");
INSERT INTO nvm_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Regavo God fu Jesu keunamga fu una urik rega surif fuon fuba muturekafa fu iji vierafene vuak ijin kiamga bu buk Sam ijia isoi, Ire ma iji na Devidon rekafa kuainva iji fu una on rek. ");
INSERT INTO nvm_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Regavo usuibe bu buk iji kafar be ijia ijeg isoi, Ja ejon ma iji fu joifuon ik reno iji jaba arega fu mako guf ijia muturek. ");
INSERT INTO nvm_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Regavo Devid fu vek fino ijia fum tavan fuon ijia Godon ikre roke fu guamga bu abe emakin fuon bu uniainva ijia unavga vajai fuon fuka muturen. ");
INSERT INTO nvm_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","39","Regavo e iji God fu keunama fu una urinma iji fuba muturen. Ijefuon efnun fokigie jabe ma vierafe God fu Jesuon azan ijia ise jon giame arek. Regavo fu Mosison akaij ijar ise jon ijia karauniakma bakin. Regavo eraneb bu Jesu ma vierafekva bu ise buon iji bu vajai fian abekrejo iji bun are usem una Godon nifak ijia buka maturaik. ");
INSERT INTO nvm_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ijefuon ni koikjon samuanamiknum vuak iji e Godon vuak vierafene kuaivo iji fuba jon rek. Regavo vuak iji bu ijeg kuai, ");
INSERT INTO nvm_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","E guri Godon vuak kania tuavo gurie ni mukoi faif. Ja ire sumakin be gakva jaka oiserdiaga ja aoik. Regavo ja vek karinva ijia irerag sumakin igi na rekva bu e kafob ire ijefuon anej ma iji kuardiabatie ja ma vierafekva bakin. ");
INSERT INTO nvm_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","For ko Banabas bu ik ar iji e Jius bu afuime vuak kuaivo iji are usevga e iji bu una kia, Ni tavan be e Jius bu isuar karijo ijia una ro vuak ijekin kafo kuarduofno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Bu ijeg kiame e iji bun vuak iji bu kuaivo iji are usem vakga e Jius iji abevo e Jius bakin iji bu e Jius ijiebuon unam iji abenva iji fok bu uri For ko Banabas jajiame vain. Bu jajia vakga e For ko Banabas bu uri soisoime kia, Ni ire ma iji God fu jon reno iji mukoi vierafeknum karifno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Regavo madu una tavan be e Jius bu isuar karijo ijia e ka ma uruvana mai guf ijia karinva iji bu E Bomana ijefuon vuak iji faikuai ruain. ");
INSERT INTO nvm_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Regavo e Jius iji bu roke ijia usem ga buka e uruvana ijia kariga buka iserdiama bu uri Forsina kuaime kuai, Vuak iji fu kuaimon iji fuka kufuimeno kuain. ");
INSERT INTO nvm_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Bu ijeg kuaivga For ko Banabas bu uri vuak iji abe darokma e Jius iji kuardiame kia, Godon vuak igi no abe amur ja kuardiainva iji fun maren revo ja vuak iji ja uzain. Ja uzainvado jakafu vierafe jaba aresredo ja ma karivako iji abek? Regavo jan ijegrenva ijefuon no jaiji no ijia areme una e Jius bakin ijiebuon vakno kiain. ");
INSERT INTO nvm_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Bu ijeg kuardiame kia, Vuak igi E Bomana ijar nijuome kuo, Na ja kege uniaga ja sanainma iji abe va e moikazan fok igia karinva iji aferdia roga na bu karauniakno kuin. ");
INSERT INTO nvm_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ijerene e Jius bakin iji bu vuak iji faime bu E Bomana ijefuon vuak iji abe oimarvknum aroin. Regavo e iji God fu kia bu unam ma karivakfuon iji abekno kiainma bu tavan ijia uri God ma vierafen. ");
INSERT INTO nvm_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Regavo E Bomana ijefuon vuak iji bu dab kuaime vako e fok ijia karinva iji buka faim baren. ");
INSERT INTO nvm_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Regavo E Jius mai ijia karinva ijieb uri e mamkanuk buon ijigam bara ikin kafo God ma vierafejo ijiebuon oij iji ke karoidiavga bu For ko Banabas uzame uri bu kaniakfuon kuaime kiava bun ar iji areme vain. ");
INSERT INTO nvm_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","E Jius iji bu ijegrejga For ko Banabas bu uri dia sakin buon fivga e iji bu giame vierafero bun no 