﻿USE sofia;
DROP TABLE IF EXISTS sofia.nuy_vpl;
CREATE TABLE nuy_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nuy_vpl WRITE;
INSERT INTO nuy_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ana-wulhu-wulhurr anu…bani-yunggaj, God ni-warra-maṉdhangi anaarrawindi-lhangu, anaarrwar marri anaani ana-lhal wugurru. ");
INSERT INTO nuy_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Anubani-yung anaarrawindi-lhangu wu-mamar. Nga waanga-mudangi maar-waḻarrlhangi-wugij. Nga ana-Mawurr na-God-jinyung wu-wirbirini aa-gugu-waj. ");
INSERT INTO nuy_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Anubanila-wala, na-God ni-yamayn, “Ba-lhalmbaarrang.” Nga yigaj, wu-lhalmbaarriyn. ");
INSERT INTO nuy_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nga na-God niwu-nayn anubani wu-lhalmbaarrangi-yinyung, wu-mamanunggu wugurru. Nga na-God niwu-waḻgaḻ-waa anubanila wu-lhalmbaarrangi-wala nga anubanila waanga-mudangi-wala. ");
INSERT INTO nuy_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Nga niwu-mij-guni anubani-yung wu-lhalmbaarrangi-yinyung “arrarra”. Marri wugurraayung anubani-yung waanga-mudangi niwu-mij-guni “miyn.ngu”. Nga manaaynjaabugij-duj mana-miyn.nganga. ");
INSERT INTO nuy_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Anubanila-wala, na-God ni-yamayn, “Anubani anaa-gugu anggu-rajaarrang. Arrgi wugurru arrwiyaj anggu-rumang, wugurraayung lhirribala-wuy anggu-rumang, nga wu-waḏa-waḏaḏ-mayn bandharra-waj.” Dani-yung ni-yamayn. Nga anaani wu-waṉbini. Niga niwu-maṉdhangi anubani wu-waḏa-waḏaḏ-jinyung bandharra-waj. Arrgi anaa-gugu wugurru arrwiyaj wu-rumayn, nga wugurraayung lhirribala-wuy wu-rumayn. ");
INSERT INTO nuy_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Anubani wu-waḏa-waḏaḏ-jinyung, niwu-mij-guni “wumala”. Nga manuulawaa-rruj mana-miyn.nganga. ");
INSERT INTO nuy_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Anubanila-wala na-God ni-yamayn, “Anubani anaa-gugu ana-lhirribala, wugurru anggu-muṉḏugang aynjaabu-rruj. Nga anaaban-bulbul-inyung anggu-rabalang.” Dani-yung ni-yamayn. Nga anaani wu-waṉbini. ");
INSERT INTO nuy_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Na-God niwu-mij-guni anaaban-bulbul “aban”, nga anaa-gugu wu-muṉḏugayn-jinyung, wugurru nima-mij-guni “lhagayag”. Nga na-God ni-warra-nayn, wu-mamanunggu wugurru. ");
INSERT INTO nuy_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Anubanila-wala, na-God ni-yamayn, “Anaaban warradijgana anu-bal anaaynba-gaynbaj-jinyung, waṉagana wuḏal marri anu-ngugulmung waṉagana wuḏal lhirribala anu-ngugulmung-duj.” Dani-yung ni-yamayn. Nga anaani wu-waṉbini. ");
INSERT INTO nuy_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Anaaban warradijgaa anu-bal anaaynba-gaynbaj-jinyung, waṉagaa wuḏal marri anu-ngugulmung waṉagaa anu-ḏal lhirribala anu-ngugulmung-duj. Nga na-God ni-warra-nayn, wu-mamanunggu wugurru. ");
INSERT INTO nuy_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Nga manuulaynbaj-duj mana-miyn.nganga. ");
INSERT INTO nuy_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Anubanila-wala, na-God ni-yamayn, “Wudhalng anggu-lhalmbaarrii ana-wumala-rruj, nga anggu-waḻgaḻ-wiiyn anaarrarra-wala anubanila-wala ana-miyn.ngu. Nga ambanggu-bajiyina anubani-yung wu-waṉina anaagalhal-aṉbana marri anaagalhal-aḻirr anaarrawindi. ");
INSERT INTO nuy_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Nga anggu-milhiynjina ana-wumala-rruj nga anggu-lhalmbaarrii yungguyung anaaban-guy.” Dani-yung ni-yamayn. Nga yigaj, anaani wu-waṉbini. ");
INSERT INTO nuy_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Na-God niwu-maṉdhangi wulawaa runggal-waa wu-lhalmbaarrii-yinyung, ngarraaḻirr ngi-buunggawa-mana anubani aarrarra-yinyung marri na-ḻabama ngijang ni-buunggawa-mana a-miyn.ngu-yinyung. Ngijang ngu-warra-maṉdhangi miyiri. ");
INSERT INTO nuy_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Nga niwu-burriyn wu-lhalmbaarrii-yinyung a-wumala-rruj, nga wu-milhii anaaban-guy. ");
INSERT INTO nuy_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Nga wu-buunggawa-mana arrarra-yinyung ngijang a-miyn.ngu-yinyung. Nga wu-waḻgaḻ-wiiyn wu-lhalmbaarrii-wala anubanila-wala waangamudii-wala. Nga na-God ni-warra-nayn, wu-mamanunggu wugurru. ");
INSERT INTO nuy_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Nga mana-wulal-wulal-uj mana-miyn.nganga. ");
INSERT INTO nuy_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Anubanila-wala, na-God ni-yamayn, “Anaa-gugu-rruj anggaandharwina aynba-gaynbaj-jinyung wu-wiri-yinyung ngujija. Marri ngijang anubani anaarrwa-garrwar anggaandharwina anubani ngurudhu.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Nga niga na-God nu-maṉdhangi yanggawu. Ngijang ni-maṉdhangi aynba-gaynbaj-jinyung ngujija. Nga wu-burraa aa-gugu-waj marri ama-lhagayag-baj. Ngijang ni-warra-maṉdhangi aynba-gaynbaj-jinyung ana-ngurudhu. Nga na-God ni-warra-nayn, wu-mamanunggu wugurru. ");
INSERT INTO nuy_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Marri niwaagajij-majgaa. Yaani-yung ni-yamayn, “Anaarra-wunyanyung arra-waṉagana ana-ngujija, nga andharwijgana mana-lhagayag-baj, marri ana-ngurudhu wugurraayunggaj arra-waṉagana ana-wunyanyung ana-ngurudhu.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Nga mana-marang-aynjaabugij-duj mana-miyn.nganga. ");
INSERT INTO nuy_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Anubanila-wala, na-God ni-yamayn, “Arrawindi aynba-gaynbaj-jinyung wu-wiri-yinyung anggaarra-ngu-burraa anaaban-baj, runggu-runggal-inyung marri wunyu-wunyanyung.” Dani-yung ni-yamayn. Nga yigaj, anaani wu-waṉbini. ");
INSERT INTO nuy_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","God ni-warra-maṉdhangi aynba-gaynbaj-jinyung wu-wiri-yinyung wu-warra-ngu-burraa, runggu-runggal-inyung marri wunyu-wunyanyung. Nga na-God ni-warra-nayn, wu-mamanunggu wugurru. ");
INSERT INTO nuy_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Anubanila-wala, na-God ni-yamijgini nigaajbaj, ni-yamayn, “Anaani aḏaba ngagurru ngaamba-maṉdhii wurru-wurruj, nga nguynju ngagurri-yii. Warruburru-yung ambirri-rangarrii anaarrawindi-lhangu mana-lhagayag-baj marri ana-ngurudhu anaarrwar-waj marri anubani-yung wu-warra-ngu-burraa anaaban-baj, runggu-runggal-inyung marri wunyu-wunyanyung.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Nga na-God wani-maṉdhangi na-wurruj-baa, waḻyinyung marri maṉinyung. Wuguṉi wini-burri nigawi-yii na-God-jii. ");
INSERT INTO nuy_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Marri waniigajij-majgaa wuguṉi. Ni-yamayn, “Nambaani-waṉagana arrawindi mijburrayung. Anubanila, nugurru aadanu warraarrawindi numburru-burraa anaaban-duj, marri nimbirriiban-ḏangarrii anaaban. Marri numburru-narrii ana-ngujija marri ana-ngurudhu marri wu-mun-bulal-wulal-inyung. ");
INSERT INTO nuy_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Marri nganaa-garra-maṉdhangi aynba-gaynbaj-jinyung ana-marrya, ana-lhal-lhangu-rruj anaarrawindi-lhangu, wuḏal marri wungugulmung aynba-gaynbaj-jinyung, nguynju yadhu numburru-nguyii. ");
INSERT INTO nuy_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Marri ngijang, anaarrawindi-lhangu wu-mun-bulal-wulal-inyung marri anaarrawindi-lhangu ana-ngurudhu, ngaya ngaarra-maṉdhangi arra-nguyii ana-maḏa marri ana-manjarr marri waanuynjungina-yinyung.” Dani-yung ni-yamayn na-God. Nga anaani wu-waṉbini, wiiyn-nguynju ni-yambini-yinyung. ");
INSERT INTO nuy_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Anubanila-wala na-God ni-warra-nani anaarrawindi-lhangu ni-warra-maṉdhangi-yinyung marri yigaj, wu-mamanunggu-windiyung wugurru. Nga marang-aynjaabugij marri aynjaabugij mana-miyn.nganga magurru. ");
INSERT INTO nuy_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Anaani wiijamaa, anaarrawindi-lhangu ni-warra-ngu-jadugayn niga na-God, ana-wumala marri anaani ana-lhal marri anaarrawindi-lhangu wu-warra-ngu-burraa-yinyung. ");
INSERT INTO nuy_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Anaarrawindi-lhangu ni-warra-ngu-jadugayn, ngarrubagi marang-aynjaabugij ngi-wulawaa ngarraaḻirr. Marri ni-warra-ngu-jadugayn anubanila ni-mijgalmini-wala. Marri ni-yanga-yangini ngarrubagi-rruj ngi-marang-aynjaabugij marri ngi-wulawaa ngarraaḻirr. ");
INSERT INTO nuy_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Nga niga ngu-maṉngulg-gayn ngarraaḻirr ngarra-marang-aynjaabugij marri ngarra-wulawaa, ngarrubagi-rruj ni-yanga-yangini yamba nigawi-nyinyung ni-mijgalmini-wala niga. ");
INSERT INTO nuy_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Yaani ana-lhaawu anubani-yung-jinyung anaarrwar marri anaani ana-lhal, anubanila na-God ni-warra-maṉdhangi-wala. Na-Yawei na-God ni-warra-ngu-jadugayn anubani ni-warra-maṉdhangi-yinyung. ");
INSERT INTO nuy_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Yagu waari anu-bal anggu-wanuynjungini anaaban-duj, nga waari anu-ḏal anggu-wal-warradangi. Yagu waari yamba angu-lharrgandi ngarraaṉbana marri waari yamba ambu-burri warra-wurruj ambu-mijgalmini yungguyung anaaban. ");
INSERT INTO nuy_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Yagu anaa-gugu wu-warra-raba-rabalangi lhirribala-wala anaaban-gala aban-gaḻaḻijgaa yungguyung. ");
INSERT INTO nuy_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Nga na-Yawei na-God niwu-miyn aban nga nu-maṉdhangi waḻyinyung. Nga ni-ngayn.gang nigawi-nyinyung ni-ngayn.gaani-yinyung nigawi-nyinyung yimurrg na-waḻyinyung-guy, nga ni-wiri-mayn. ");
INSERT INTO nuy_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Nga na-Yawei na-God ni-wanuynjungaa, anubani ana-lhal Eden ramaliyaj, nga bagu nu-burriyn na-waḻyinyung, naagi-yung nu-maṉdhangi-yinyung. ");
INSERT INTO nuy_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Nga ni-warradijgaa aynba-gaynbaj-jinyung rangag wu-mamanunggu, marri waṉijgini wungugulmung, anaambaḻaman ana-marrya. Marri bagu bandharra, wu-wal-lhaay rangag, ngarrangguuni-yinyung wiri, marri anaaynbaj ana-rangag, ngarrangguuni ngurru-marrbuy ambaḻaman marri aladi. ");
INSERT INTO nuy_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Aynjaabugij anubani anaala waala-yanggi a-Eden-baj. Anaani anaala waarrangi anubani waanuynjungina-yinyung. Wugurraayung anuwagala waala-wulawaa waala-yanggi anubani-yung-guy, marri wugurraayung anuwagala waala-wulawaa anaala, wubani waala-waliynjiyn aala-wuy. ");
INSERT INTO nuy_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Anubani-yung anaalaaynjaabugij wu-mayini Pishon. Anubani-yung waala-warrawarrangi, anubani anu-muwaj Havilah wu-mayini. Anubani-rruj ana-lhal-uj anubagu wu-burri wugubulu wuṉuga, gold. ");
INSERT INTO nuy_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Anaani wu-mamanunggu. Marri aynba-gaynbaj-jinyung rangag anubani-yung maḏa wu-warrawuj-baynji nguynju a-dhangarra-yii wu-yamaa. Marri ṉuga-mamaaḻang anubagu ma-burri. ");
INSERT INTO nuy_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Anubani-yung wulawaa anaala, wu-mayini Gihon. Anubani-yung wu-yanggi yuuguni waala-warrawarrangi a-lhal wu-mayini Cush, ana-lhal. ");
INSERT INTO nuy_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Wugurraayung waala-wulaynbaj anaala wu-mayini anubani-yung Tigris. Anubani ana-lhal Assyria, ramaliyaj wu-yanggi anaala. Wugurraayung waala-wulal-wulal anaala, wu-mayini Euphrates. ");
INSERT INTO nuy_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Nga na-Yawei na-God nu-burriyn nubagi na-waḻyinyung anubani-rruj wu-wanuynjungini-rruj a-Eden-duj, ni-mijgalmini yungguyung aban marri niwu-rangarrangi yungguyung. ");
INSERT INTO nuy_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Nga na-Yawei nu-yamijgayn nigawi-wuy, “Nagang baarra-nguyii anaani anu-ngugulmung anu-bal-wala wu-wanuynjungina-yinyung. ");
INSERT INTO nuy_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Yagu bagu wubal bani ningguuyii-yinyung nu-marrbuy anubani-yung ambaḻaman marri aladi, nagang yagi nu-ngi anu-ngugulmung anu-bal-ala. Ba-nguyii-maynji, ba-ngawang, ngarrubagi-rruj ngarraaḻirr.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Nga na-Yawei na-God ni-yamayn, “Waari anggiij-maṉdhini, naagi na-waḻyinyung ni-burrangi ni-wiri-wiri-mi-magi. Ngaya ngamba-maṉdhii ambaanggarra-ngu-burraa-yinyung, ambunu-maṉmani yadhu.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Anubanila-wala, niwaaban-miyn anaaban nga ni-warra-maṉdhangi wu-mun-bulal-wulal-inyung marri ana-ngurudhu. Nga ni-warra-yarrijgiyn anubani na-waḻyinyung-guy nguynju yadhu ni-warra-mij-guni. Nga yigaj, anubani arra-waṉagana ana-muwaj. ");
INSERT INTO nuy_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Na-waḻyinyung ni-warra-mijguni anu-muwaj anaarrawindi-lhangu ana-ngurudhu marri anaarrawindi-lhangu wu-mun-bulal-wulal-inyung. Yagu waari warraaynbaj ambaanggarra-ngu-burraa ambunu-maṉmangi yungguyung. ");
INSERT INTO nuy_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Anubanila-wala, na-Yawei na-God nu-yangijgayn na-waḻyinyung, niiḏdhiyn-bindiyung. Nga ni-yaay-waj nima-miyn aynjaabugij na-waḻyinyung-gala murrguḏi, nga niwu-dhidiyn anu-dhaṉ. ");
INSERT INTO nuy_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Nga ngu-maṉdhangi maṉinyung ama-murrguḏi-wala. Marri ngu-yarrijgiyn nigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Nga na-waḻyinyung ni-yamayn, “Aḏaabilhangu yigaj! Ngayawi-nyinyung-gala a-maguḻag marri a-ngagara. Ngarra-maṉinyung ngiga ngarra-ngarrimuwaj-jung, ngiga yamba na-waḻyinyung-gala ngu-maṉdhangi.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Wudani-yung-gala, warra-waḻya-waḻya warraarruna warra-mininyarra-yung marri warra-mijbiibiyung. Marri niga marri nigawi-nyinyung nga-rangarrina-yung, winiiynjaabu wini-yagaynjina, nguynju aynjaabugij ngun.gu. ");
INSERT INTO nuy_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Naagi na-waḻyinyung marri ngarra-maṉinyung, wuguṉi wini-mamar. Yagu waari ambiniimbulangi wuguṉi. ");
INSERT INTO nuy_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Anubani ana-marryn wu-gaḻij-mamaaḻang-bindiyung, ana-mulung-arrgi-wala wu-mun-bulal-wulal-inyung na-Yawei na-God ni-warra-maṉdhangi-yinyung. Anaani ana-marryn ngarra-maṉinyung nginggu-magayn, “Yuga na-God niini-magayn, ‘yagi niini-ngi anu-ngugulmung anaarrawindi-lhangu anu-bal’?” wu-yamayn. ");
INSERT INTO nuy_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ngigaayung ngarra-maṉinyung ngi-yambalmayn, “Naani-nguyii anaarrawindi-lhangu anu-bal. ");
INSERT INTO nuy_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Yagu bandharra bagu wu-burraa, ni-yamayn ‘Bandharra bagu wu-burraa, yagi niini-ngi anu-ngugulmung anu-bal-inyung. Yagu naani-ngang-maynji yagu naani-wiḻdhang-maynji, naani-ngawang.’” Dani-yung ngi-yamayn ngarra-maṉinyung. ");
INSERT INTO nuy_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Wugurraayung ana-marryn wu-yamayn, “Waari aniijgubulu-magaa, yagi niini-ngawi. ");
INSERT INTO nuy_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Na-God ni-yamayn anubani, ni-marrbuy yamba nimbini-nguyii-maynji, nimbini-yamana nigawi-yii na-God-jii. Nuguṉi nimbini-marrbuy anaambaḻaman marri anaaladi, nguynju nigawi-yii na-God-yii, niga yamba ni-marrbuy.” Dani-yung wu-yamayn ana-marryn. ");
INSERT INTO nuy_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ngarraagi ngarra-maṉinyung ngi-warranggayn, nga ngi-nayn ambaḻaman wu-mamaarriynjini anu-ngugulmung, marri ngiwu-ngaynbandangi angi-yina-mamaaḻang yungguyung. Marri ngi-miyn anu-ngugulmung marri ngi-ngang. Marri ngijang ngunu-yayn ngigawi naaṉngina-yung marri nigaayung ni-ngang. ");
INSERT INTO nuy_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Anubani-yung wini-nguni-wala, wini-warranggaa, wini-marrbuy wini-mamar. Naawiṉi-yung winiimbuliyn. Yagu winima-mangi magujiyarr ama-nunganyang. Bama-yung-mirri wini-ngarrayini. ");
INSERT INTO nuy_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Anubagu ngi-waḻirr-wiḻibiḻingiyn ngi-yabini-wuy, naawiṉi-yung wunu-yaynjangang na-Yawei na-God, ni-yanggi wu-wanuynjungini-waj. Nga wini-julubiyn wubani a-rangag-gaj. ");
INSERT INTO nuy_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Nga na-Yawei na-God naa-gaḏangi na-waḻyinyung, “Ajiga-rruj?” ");
INSERT INTO nuy_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Nigaayung nu-yambalmayn, “Ngunu-yaynjangani wu-wanuynjungina-wala, nga ngaya nga-ḏirrngawiiyn nga ngaambuliyn nga nga-julubiyn nugawi-wala, yagu yamba ngaya nga-mamar.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Nigaayung na-God nu-yamijgayn, “Yangi-nyung nagang nimbi-magaa nu-mamar? Yagu anubani nu-nguni anubani anu-ngugulmung, anubani ngunu-magaa mirraadhu ‘yagi nu-ngi’?” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Nigaayung na-waḻyinyung nu-yambalmayn, “Maṉinyung yamba, nu-ngu-burriyn-jinyung ngayawi-rruj. Ngangi-yayn marri nga-nguni anu-ngugulmung,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Nigaayung na-Yawei na-God ngu-yandhawiwayn ngarra-maṉinyung, “Yuga nagang nuynjaminggarriyn?” Ngigaayung ngunu-yambalmayn, “Marryn yamba, nganggu-dhaayurrijgaa ngaya marri nga-nguni,” ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Nigaayung naagi-yung na-Yawei nu-magayn ana-marryn, “Nagang yamba nunggaṉbini, nu-ngu-guldhiyn, numbiri-wiri-lhangu anaarrawindi-lhangu wu-mun-bulal-wulal-inyung. Anaanila-wala aḏaba nagang ba-yalgarrwina nugawi-mirri ba-gulmung-baḻawaḻajaa. Nga nagang bawu-nguyii lhagabuṉulg ngarraaḻirr-lhangu ba-burraa-maynji anggu-jarrmayarrmaj nugawi ana-wiri. ");
INSERT INTO nuy_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ngaya nganaagajij-maṉdhii nagang marri ngarra-maṉinyung nimbiniirriyn-marrdiynjina. Marri ngigawi-nyinyung warra-mijburrayung marri nugawi-nyinyung warra-mijburrayung amburru-wiynjina. Ngigawi-nyinyung warra-mijburrayung ambiimbaḻ-wadjii, marri wugurraayung ambii-lhungujun-bangana.” Dani-yung ni-yamayn na-Yawei. ");
INSERT INTO nuy_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Anubanila, naagi-yung ngu-magayn ngarra-maṉinyung, ni-yamayn, “Ngaya wiiyn baarragayii-yinyung bamba-yabang-maynji warra-gujuju. Yagu banu-ngaynbandii-wugij nugawi naaṉnginaaj, marri ani-buunggawa-mana nagang.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Anubanila, naagi-yung nu-magayn na-waḻyinyung, “Nagang nungu-yandhurrbang nga-rangarrinaaj, marri nu-nguni anu-ngugulmung, anubani-yung-jinyung ngaya ngana-magaa ‘Nagang yagi nu-ngi’. Wudani-yung-gala, anaaban nganggaaladi-wang. marri ba-mijgalmina angudu nguynju yadhu ba-nguyii ana-marrya, ba-burraa-maynji nugawi-nyinyung ana-wiri. ");
INSERT INTO nuy_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Anaaban arra-waṉagana miḏaaburruburru marri rawurrumugurrumu. Marri aynba-gaynbaj-jinyung baarra-nguyii anu-bal. ");
INSERT INTO nuy_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Marri ba-mijgalmina angaḏajung, marri ba-wurrij-burii, ba-mani-yinyung ana-marrya. Murrubu nagang baagiyn aaban-guy, wubanila-wala yamba nagang nu-maṉdhini. Aaban-gala nagang, Marri aaban-guy baagiyn.” Dani-yung ni-yamayn na-Yawei. ");
INSERT INTO nuy_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Naagi na-waḻyinyung, Adam na-nimuwaj-jung. Naagi-yung ngu-mijgayn nigawi nga-rangarrina-yung, Eve ngarra-ngarrimuwaj-jung. Ngiga yamba warraarrawindi-lhangu nga-rriibi-yung, warraarrawindi-lhangu warru-mandag. ");
INSERT INTO nuy_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Anubanila-wala, na-Yawei na-God wani-majgaa yaaḻi wubarriguḻag wu-mun-bulal-wulal-inyung. Yagu na-Adam marri nga-rangarrina-yung wani-yabijgaa wubarriguḻag-mirri. ");
INSERT INTO nuy_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Anubanila-wala, naagi-yung na-Yawei na-God ni-yamayn, “Aḏaba na-waḻyinyung ni-yamana ngagurri-yii, ni-marrbuy wu-waṉbina-yinyung ambaḻaman marri aladi. Niga yagi ni-marang-dhaayi marri ni-mi anu-ngugulmung anubanila-wala anu-bal ana-wiri-yinyung, yagi ni-ngi, ani-burrang anggu-wuguuguni.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Anubanila naagi-yung na-Yawei wani-lharrgang wuguṉi anubanila-wala ana-Eden-gala, nguynju na-waḻyinyung ani-mijgalmini anaaban, niga yamba ni-maṉdhini wubanila-wala aaban-gala. ");
INSERT INTO nuy_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Anubanila-wala, ana-ramalila wu-wanuynjungina-wala, niga ni-burri wu-wiri-yinyung ana-angel, narrangi, waṉagaa jarrmayarrmaj galiwanga warra-lhalmbaarrangi, warawararbini. Yaani yungguyung waari amburru-yanggi ana-warubaj ambirri-jiibugaa anu-bal ana-wiri-yinyung. ");
INSERT INTO nuy_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Na-Adam marri ngarra-Eve anubani wini-yaay. Anubani-yung aḏaba ngi-wurrij-mundurr. Wurrugu niimbuḻwiiyn naagi-yung na-wirrinyung. Ngarraagi-yung ngi-yamayn “Na-God ngani-maṉmangi, ngani-yayn waḻyinyung naagi, nganu-yabayn.” Dani-yung ngi-yambini. Wudani-yung-gala, ngunu-mij-gayn naagi-yung na-wirrinyung, na-nimuwaj-jung Cain. ");
INSERT INTO nuy_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Wurrugu ngijang, ngunu-malgadhaadharrijgayn, naagi-yung ngunu-yabayn wirrinyung, na-nimuwaj-jung naagi-yung Abel. Naawiṉi-yung nigamanyij. Naawiṉi-yung wini-warradangi, wini-ngambara-maa aḏaba. Na-Abel niga ni-narrangi jib. Nigaayung na-Cain, nigaayung ni-wanuynjungaa wubal. ");
INSERT INTO nuy_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Anubanila-wala, na-Cain naagi-yung, anubani ana-wulhu-wulhurr anu-ngugulmung aḏaba ni-waṉagaa. Ni-mangi, aḏaba ni-yarrijgini, anubani-yung nu-yayn na-Buunggawa-wuy na-Yawei-wuy. ");
INSERT INTO nuy_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Nigaayung Abel ni-miyn ana-wulhu-wulhurr winyig jib. Ni-ngaj-mangi mangaj marri lhanggu, nga buguni anaani-yung ni-yarrijgini mamanunggu lhanggu, marri ni-nangaa. Na-Yawei naa-gurrij-gaḻaaḻarriyn naagi-yung-guy na-Abel-wuy, ");
INSERT INTO nuy_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","yagu waari ani-waḻaaḻarrangi naadagi-yung-guy na-Cain-guy. Aadanila-wala, na-Cain naagi-yung ni-wurrij-galadi-wiiyn, ni-yimurr-jiwuriyn. Marri ni-riyaldhiyn. ");
INSERT INTO nuy_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Na-Yawei ni-yamayn, “A-yangi yungguyung nagang nuṉḏiyaldhii Cain, marri nuynjimurr-jiwuriyn? ");
INSERT INTO nuy_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Baaṉbina-maynji anaandhurrg, marri bani-yung ngaya nganggaḻaaḻarrang nugawi-wuy. Yagi-maynji nunggaṉbi ana-maaḻamburrg, anaaladi anaani wu-burraa nunggu-miṉmiṉḏii, aadanu aḏaba nugawi yungguyung bawu-waṉagana. Nugawaj ba-buunggawa aadanu aḏaba, aadanu aladi.” Dani-yung ni-yamaa na-God. ");
INSERT INTO nuy_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Anubanila, na-Cain ni-yanggi, nu-yambini na-nilharriyung-guy, “Baaṉina, naynjaarri yuuguni arabarabalu-wuy, nagaaj-bugij,” ni-yamayn na-Cain. Wini-yanggi, bagu-rruj-bindiyung, aḏaba bagu nu-wini, naagi-yung nu-mulunguwa-waa. ");
INSERT INTO nuy_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Anubanila na-Yawei nu-yandhawiwandi na-Cain-guy, ni-yamayn “Ajiga na-nilharri nagang na-Abel?” Nigaayung nu-yambalmayn, “Ari muga, nga-maḻaḻadi. Ngaya waari nganu-narrangi naadagi naa-murruyung.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Na-Yawei ni-yamayn nigaayung, “Yuga nagang nunu-yaminggarrijgayn niga? Manubama mana-wulang na-nilharri-yinyung, manubama maaḏii ngayawi-wuy aaban-gala,” nigaayung ni-yamayn na-God. ");
INSERT INTO nuy_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","“Anubani anaaban miyn nigawi-nyinyung mana-wulang, nugawi-nyinyung-gala wudanu a-marang. Aadanu ngawu-rraani aḏaba anaaban. ");
INSERT INTO nuy_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ba-riganjii-maynji marri baanuynjungana-maynji, yagi waarradi. Anggaari ana-marrya. Yagi nagang nunggu-dharrdhi aadani ana-lhal. Baagaagaḻawajii arrbidi.” Dani-yung na-Yawei na-God ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Nigaayung na-Cain ni-yamayn, “Nagang nimba-yayn windiyung magarrangaynji. Runggal-windiyung, waari-yinyung ngaaṉbi ari. ");
INSERT INTO nuy_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ana-yimbaj nimba-lharrganjii aḏaba anaanila-wala. Ngaya nga-ngu-julubina nugawi-wala. Waari ngayawi ana-lhal. Ngandaagaagaḻawajii arrbidi. Warraaynbaj-maynji ngambambi-lhangarrmang, ari ngambambiimana.” Dani-yung ni-yambini na-Cain nigaayung. ");
INSERT INTO nuy_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Na-Yawei nigaayung ni-yamayn, “Waari. Warraaynbaj-maynji ambiimana, ngaayung ngambaagagijgiyn marang-aynjaabugij marri angguulawaa,” ni-yamayn. Anubanila, na-Yawei niwu-burrangi mari nigawi-rruj na-Cain-duj. Nguynju yadhu warraaynbaj-maynji ambunu-lhangarrmaa, aḏaba yagi yungguyung wunu-wu. ");
INSERT INTO nuy_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Na-Cain ni-yanggi aḏaba na-Yawei-wala. Anubani-rruj ni-burri-rruj naagi-yung na-Cain, wu-mayini Nod, ana-lhal, ramaliyaj anubanila ana-Eden-gala. ");
INSERT INTO nuy_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Naagi-yung na-Cain niiynji-yaay nga-rangarrina-yung. Ngarraagi-yung ngi-wurrij-mundurr, marri ngunu-yabayn naagi-yung waḻyinyung, na-nimuwaj-jung Enoch. Anubanila, na-Cain naagi-yung niwu-maṉdhangi runggal anga. Anubani niwu-mayayn ana-wumurrng Enoch, wu-mayini, wiijamana nubagi na-niwiyayung-gala a-muwaj. ");
INSERT INTO nuy_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Naagi-yung na-Enoch, nigaayung nu-lhamayn niwiyayung, Irad. Nigaayung na-Irad ni-warradangi-wala, ni-ngambara-mayn, nu-lhamayn Mehujael. Na-Mehujael ni-warradangi, naagi nu-lhamayn Methushael. Naagi-yung nigaayung na-Methushael ni-warradangi-wala, nu-lhamayn naagi-yung Lamech. ");
INSERT INTO nuy_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Naagi-yung na-Lamech niiynji-wulawaa, nga-rangarrina-yung-biiyung. Ngarra-ngarrimuwaj-baa Adah marri Zillah. ");
INSERT INTO nuy_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","21","Ngarra-Adah wangi-yabaa wini-wulawaa, na-nimuwajbaa Jabal marri Jubal. Naagi-yung na-Jabal, nigawi-nyinyung warruburru-yung warra-mijburrayung marri wugurri-nyinyung warra-lhamaa-yinyung, wurru-burri-yinyung amubama-rruj ama-ganbij-duj, bani wuu-narra-narrangi-rruj a-bulugi. Nigaayung na-Jubal, nigawi-nyinyung warruburru-yung wani-lhamaa, nga wugurru waa-lhamaa-yinyung warruburru-yung, warraawurru-yung wurraayigini-yinyung gita marri trumpet. ");
INSERT INTO nuy_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ngigaayung ngarraaynbaj nga-rangarrina-yung na-Lamech-jinyung ngarra-Zillah, ngiga ngarraagi-yung ngunu-yabayn na-nimuwaj-jung Tubal-cain. Naagi-yung ni-warra-maṉdhangi-yinyung waragu marri galiwanga, aynba-gaynbaj-jinyung, iron-mirri marri bronze-mirri. Na-Tubal-cain-jinyung naagi-yung ngarra-ngarrilharriyung ngarra-ngarrimuwaj-jung Naamah. ");
INSERT INTO nuy_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Na-Lamech naagi-yung, wani-magaa ngarrubirrngi-yung nga-rangarrina-yung-biiyung. Ni-yamayn, “Adah marri Zillah, ngirri-yaynjangayii, Gurrngi-waj, guḻgu-wiiya, nimbingi-wawanggina anaani nga-yambina-yinyung. Waḻyinyung ngani-balhu, anubanila ngaayung nganu-wini, nga-miṉigarriyn. Naagi wulmurrinyung, nigaaj-gala ngani-wang. ");
INSERT INTO nuy_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Warraaynbaj-maynji ambunuumana na-Cain, na-God ambanii-gaagijgiyn marang-aynjaabugij marri wulawaa. Yagu ngaayung ngambaa-gaagijgiyn 77.” Dani-yung ni-yamaa na-Lamech. ");
INSERT INTO nuy_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Anu…bani-yunggaj, anubani-yumbaa ni-ngawiiyn na-Abel, anubanila-wala naagi na-Adam niiynji-yaay ngarra-Eve. Ngunu-yabayn naagi-yung naaynbajung. Ngunu-mij-guni Seth, na-nimuwaj-jung. Ngarraagi-yung ngi-yamayn, “Na-Cain nu-wini na-Abel. Na-God ngani-yayn aynbajung ngijang, ngayawi-nyinyung na-marig.” Dani-yung ngi-yamayn. Na-nimuwaj-jung yamba, anaani wiijamana, “Ngani-yayn.” ");
INSERT INTO nuy_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Naagi ni-warradangi wurrugu, marri nu-lhamayn nigaayung, Enosh. Anu…bani-yumbaa, naagi na-God wunu-mayaa na-nimuwaj-jung na-Yawei. ");
INSERT INTO nuy_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Anaani ana-wubiba wu-magina na-Adam-jinyung marri nigawi-nyinyung warra-mijgalgur-yung. Anu…bani-yunggaj, na-God nu-maṉdhangi naagi-yung na-waḻyinyung. Nu-maṉdhangi, ni-yamaa nguynju nigawi-yii na-God-jii. ");
INSERT INTO nuy_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Wani-maṉdhangi waḻyinyung marri maṉinyung. Naagi-yung waniigajij-majgaa, anubani wani-mayaa “warra-wurru-wurruj”. ");
INSERT INTO nuy_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Naagi-yung na-Adam ni-burri 130 anaagalhal-aḻirr. Bani-yung marri nu-lhamayn na-niwiyayung. Naagi-yung ni-yamaa nguynju nigawi-yii na-Adam-jii, wini-yi-nguynju. Nigaayung na-Adam nu-mij-gayn na-nimuwaj-jung Seth. ");
INSERT INTO nuy_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Anubanila-wala, na-Adam ni-burri 800 anaagalhal-aḻirr. Warra-miniwiyayung marri warra-miyn.ngarriwiyayung wani-waṉagaa. ");
INSERT INTO nuy_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Nigawi-nyinyung ana-wiri ni-burri-yinyung manaarmag 930, baḏag. Naagi-yung bani-yung marri ni-ngawiiyn. ");
INSERT INTO nuy_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Nigaayung naagi-yung na-Seth, ni-burri 105 anaagalhal-aḻirr. Bani-yung marri nu-lhamayn naagi-yung na-niwiyayung na-Enosh. ");
INSERT INTO nuy_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ngijang anubanila-wala Seth nigaayung ni-burri naagi-yung 807 anaagalhal-aḻirr. Warra-mininiwiyayung marri warra-miyn.ngarriwiyayung anubani-yumbaa wurru-burri. ");
INSERT INTO nuy_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Nigawi-nyinyung ana-wiri ni-burri-yinyung anaagalhal-aḻirr 912. Marri bani-yung ni-ngawiiyn. ");
INSERT INTO nuy_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Nigaayung na-Enosh, ni-burri 90 anaagalhal-aḻirr. ");
INSERT INTO nuy_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Anubanila-wala nigaayung nu-lhamayn na-Kenan. Anubanila-wala ni-burri naadagi-yung na-Enosh, nigaayung 815 anaagalhal-aḻirr. Warra-mininiwiyayung marri warra-miyn.ngarriwiyayung wuu-yagaynjini. ");
INSERT INTO nuy_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Nigawi-nyinyung ana-wiri ni-burri-yinyung anaagalhal-aḻirr 905. Bani-yung marri ni-ngawiiyn. ");
INSERT INTO nuy_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Na-Kenan naagi-yung 70 anaagalhal-aḻirr, ni-burri. Bani-yung marri nu-lhamayn Mahalalel, na-niwiyayung. ");
INSERT INTO nuy_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Anubanila-wala, na-Kenan ni-burri 840 anaagalhal-aḻirr. Warra-mininiwiyayung marri warra-miyn.ngarriwiyayung wuu-yagaynjini. ");
INSERT INTO nuy_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Nigawi-nyinyung ana-wiri ni-burri-yinyung 910 anaagalhal-aḻirr. Marri bani-yung ni-ngawiiyn. ");
INSERT INTO nuy_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Nigaayung na-Mahalalel 65 anaagalhal-aḻirr, naagi-yung ni-burri. Bani-yung marri nu-lhamayn naagi-yung na-nimuwaj-jung na-Jared. ");
INSERT INTO nuy_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Anubanila, na-Mahalalel naagi-yung ni-burri 830 anaagalhal-aḻirr. Wani-lhamaa warra-mininiwiyayung marri warra-miyn.ngarriwiyayung. ");
INSERT INTO nuy_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ana-wiri nigawi-nyinyung ni-burri-yinyung, 895 anaagalhal-aḻirr. Bani-yung marri ni-ngawiiyn. ");
INSERT INTO nuy_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Nigaayung naagi-yung na-Jared ni-burri anaagalhal-aḻirr 162. Bani-yung marri nu-lhamayn na-Enoch. ");
INSERT INTO nuy_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Anubanila-wala ni-burri na-Jared 800 anaagalhal-aḻirr. Wani-lhamaa warra-mininiwiyayung marri warra-miyn.ngarriwiyayung. ");
INSERT INTO nuy_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Anubani ana-wiri ni-burri-yinyung, 962. Bani-yung marri naagi-yung ni-ngawiiyn. ");
INSERT INTO nuy_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Na-Enoch niga naagi-yung 65 ni-burri anaagalhal-aḻirr. Bani-yung marri naagi-yung nu-lhamayn na-niwiyayung Methuselah. ");
INSERT INTO nuy_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Naagi-yung na-Enoch winiinggarra-yanggi na-God, baḏag 300 anaagalhal-aḻirr. Niimbuḻwiyn-gala na-Methuselah, na-Enoch naagi-yung wani-lhamaa miniwiyayung marri miyn.ngarriwiyayung. ");
INSERT INTO nuy_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Anaani-rruj ni-burri 365 anaagalhal-aḻirr. ");
INSERT INTO nuy_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Wini-yagaynjini naagi-yung na-God, winiinggarra-yanggi. Anubanila-wala na-Enoch niiṉibiyn. God nu-yarini niga. ");
INSERT INTO nuy_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Methuselah naagi-yung ni-burri 187 anaagalhal-aḻirr. Bani-yung marri naagi-yung nu-lhamayn na-Lamech, na-niwiyayung. ");
INSERT INTO nuy_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Anubanila-wala, na-Methuselah naagi-yung ni-burri 782 anaagalhal-aḻirr. Wani-lhamaa warra-mininiwiyayung marri warra-miyn.ngarriwiyayung. ");
INSERT INTO nuy_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Anubani 969 ana-wiri nigawi-nyinyung. Marri bani-yung ni-ngawiiyn. ");
INSERT INTO nuy_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Na-Lamech naagi-yung ni-burri 182 anaagalhal-aḻirr. Bani-yung marri nu-lhamayn naagi-yung na-niwiyayung. ");
INSERT INTO nuy_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Nu-mij-gayn na-niwiyayung na-Noah. Ni-yamayn, “Na-Yawei na-God anubani-yunggaj niwu-rraani anaani anaaban. Marri ngurru-mijgalmina, marri ngurru-waṉbina angudu aynba-gaynbaj-jinyung, marang-mirri. Naagi na-nigi ngaambani-maṉmani, anaani-rruj anaaban-duj.” Dani-yung ni-yamayn naagi-yung na-Lamech. ");
INSERT INTO nuy_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Anubanila-wala, niimbuḻwiyn-gala na-Noah, naagi-yung na-Lamech ni-burri 595 anaagalhal-aḻirr. Wani-lhamaa warruburru warra-mininiwiyayung marri warra-miyn.ngarriwiyayung. ");
INSERT INTO nuy_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Anubani nigawi-nyinyung ana-wiri ni-burri-yinyung, 777. Marri bani-yung ni-ngawiiyn. ");
INSERT INTO nuy_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Na-Noah naagi-yung ni-burri 500 anaagalhal-aḻirr. Naagi wani-lhamaa Shem, Ham marri Japheth, warraawurru wurru-wulaynbaj warra-miniwiyayung. ");
INSERT INTO nuy_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Warraawurru-yung warra-wurru-wurruj warraarra-waṉagaa arrawindi mijburrayung. Marri arrawindi warraarra-waṉagaa warra-miyn.ngarriwiyayung. ");
INSERT INTO nuy_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Anubanila-wala, warra-miniwiyayung na-God-jinyung warra-nani warruburru-yung warra-maṉaṉung. Waadurru-yung wurru-wajbarini warruburru-yung warra-maṉaṉung-guy. ");
INSERT INTO nuy_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Anubani-yung na-Yawei ni-yamayn, “Warra-wurru-wurruj yagi wurru-burrangi ana-baḏag. Warruburru yamba wurru-wurruj-bugij wugurru. Anubani amburru-burraa manaarmag 120, dani-yung-bugij.” Dani-yung ni-yamayn na-God. ");
INSERT INTO nuy_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Warruburru-yung warru-mandag, wurru-mayini Nephilim anubani-rruj wurru-burri, ngijang marri wuu-lhamarrangi-yinyung. Warruburru-yung warra-miniwiyayung na-God-jinyung wurru-yanggi warruburru-wuy warra-maṉaṉung-guy, warra-mangi, bani-yung marri wurraaynji-yaay aḏaba. Waadurru-yung warra-maṉaṉung warra-yabaa mijburrayung. Waadurru-yung warra-mijburrayung wurraarradangi, wurru-ngambara-maa. Warraawurru-yung wurru-waḏa-waḏaḏ-bindiyung, waa-runggu-runggal, warra-mi…yn-ngambara anu…bani-yunggaj. ");
INSERT INTO nuy_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Na-Yawei na-God wani-nani waadurru-yung wurraalaaladi. Waadurru-yung warra-wurru-wurruj wurru-wijangani yij-galaaladi, wirriij-ngaynbandangi alaaladi wuguuguni. ");
INSERT INTO nuy_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Naagi-yung na-Yawei ni-wurrij-galadi-wiiyn-bindiyung, anubani-yung wani-maṉdhangi-wala warra-wurru-wurruj anaani-rruj-jinyung ana-lhal. ");
INSERT INTO nuy_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ni-yamayn “Ngamba-jadugang waadurru warra-wurru-wurruj. Wiiya ngarra-maṉdhangi, arraga ngamba-jadugang anaanila anaaban-gala, wiiya. Warra-wurru-wurruj marri wu-ngarra-jalgarrwina-yinyung marri wu-ngarra-guṉmana-yinyung, nganggarra-ngu-jadugang. Ngaya yamba nga-wij-barrngayuyn anaani-yung ngaarra-maṉdhangi-yinyung.” Dani-yung ni-yamayn na-God. ");
INSERT INTO nuy_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Yagu naagi-yung na-Yawei na-God naa-gurrij-gaḻaaḻarrangi nigawi-wuy na-Noah-wuy. ");
INSERT INTO nuy_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Anaani ana-lhaawu na-Noah-yinyung marri nigawi-nyinyung warra-mijgalgur-yung. Naagi na-Noah ni-dhi-maṉdhini maaḻamburrg-bindiyung. Waari naagi-yung ani-waṉbini aniij-galaaladi, ani-yamaa warruburru-yung-jii warra-mulung-aynbaj-jii. Na-Noah marri na-God, naadiṉi-yung wini-yagaynjini, winiinggarra-yanggi. ");
INSERT INTO nuy_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Na-Noah wani-lhamaa wurru-wulaynbaj warra-miniwiyayung. Shem, Ham marri Japheth, durru-yung warra-miniwiyayung. ");
INSERT INTO nuy_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Na-God niwu-lhal-nani anaani ana-lhal marri warruburru-wuy warra-wurru-wurruj-guy wani-waḻamin-nani. Wurraalaaladi-windiyung. Warra-wurru-wurruj wuu-juriynjini, wurru-wiynjini, wurraandha-wuguuguni. ");
INSERT INTO nuy_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Anubani-rruj ana-lhal, wu-waṉini aladi. Warra-wurru-wurruj wurru-waṉbini aladi-windiyung, anaani-rruj ana-lhal, marri God wani-nani. ");
INSERT INTO nuy_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Anubanila-wala, na-God nu-magayn na-Noah-wuy, “Anaani ngaya nga-wijangayii, ngamba-jadugang waadurru warra-wurru-wurruj anaani-rruj-jinyung wurru-burraa, warraarrawindi. Anaani-rruj ana-lhal, wurru-wiynjina, wurraandha-wuguuguni yamba. Marri ngamba-jadugang waadurru warra-wurru-wurruj, marri anaarrawindi-lhangu wu-wiri-yinyung anaani-rruj ana-lhal. ");
INSERT INTO nuy_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","“Nagang aadanu, bama-maṉdhii barrawu nugawi-nyinyung, bani-wulguldhii yimbiḏ bani-yung marri bama-rayii aḏaba. Bawu-maṉdhii gara ana-lhirribala. Bama-maṉdhii maadamu mana-barrawu, marri bawu-maṉdhii wumurrng marri bama-waḻii aḻnga-mirri, maadamu mana-barrawu, mana-majamarr-waj marri ana-lhirribala. ");
INSERT INTO nuy_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","“Bama-maṉdhii nguynju aani-yung-jii. Maadamu bama-jarrmayayarrmijgang 133 mita ama-jarrmayarrmaj, marri 22 ngijang ama-yamarr-waldharrang-jinyung, magurraayung 13 mana-ma-gambarr. ");
INSERT INTO nuy_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Marri bawu-maṉdhii wumurrng arrwa-garrwar. Marri ama-ma-ngudhulmung-duj marri anuwaagu-yinyung anaarrwar, mana-ma-garrwa-garrwar-yinyung ana-wumurrng, anubani bawaarruyn, daju anggaawawalhii, aadanu aḻagaḻa mita anaarrwar-inyung marri ana-lhirribala-yinyung. Marri angguulaynbaj-gala ana-floor anggu-maṉdhina. Marri aynjaabugij anggu-burraa anu-dhawang.” ");
INSERT INTO nuy_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Niga na-God ni-yambini-wugij. “Ngaya anaani ngama-lharrgang ngugu, anaani-rruj ana-lhal, ama-waṉiyn. Aadanu nganggaarra-ngu-jadugana aadanu wu-ngarra-ngu-burraa-yinyung, wu-warra-ngayn.gaana-yinyung. Aadanu anaani-rruj-jinyung ana-lhal, aadanu anggu-warra-ngu-jadugiiyn-bindiyung, anggu-lhagarra-ngawina. ");
INSERT INTO nuy_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","“Yagu ngaya anaani ngunu-lhalamayana nugawi-wuy. Nguynju yungguyung ba-yaarri marri ba-yabaynjina amubama ama-barrawu-wuy, nagang marri nugawi warra-miniwiyaay marri nga-rangarrinaaj marri warra-miniwiyaay-inyung waadurru warra-miḏangarrina-yung. ");
INSERT INTO nuy_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Aadanu wu-ngarra-jaarri-yinyung ba-mani ana-bulugi marri anaaynba-gaynbaj-jinyung, ba-mani anggu-wulu-wulawaa-wugij, waḻya marri maṉung. Ba-yarrijgina amubama-wuy ama-barrawu-wuy, nguynju yungguyung anggu-wiri yungguyung. ");
INSERT INTO nuy_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Anubani ana-ngurudhu anggu-wulawaa-wugij ba-mani. Aadanu ana-bulugi, anggu-wulawaa-wugij ba-mani, marri wu-yalgarrwina-yinyung, anggu-wulawaa-wugij. Aadanu anggu-ngarra-jaarri nugawi-wuy, anggu-wulawaa-wugij, anaarrawindi-lhangu. Daju ba-waṉagana, nguynju yadhu anggu-ngarra-biri. ");
INSERT INTO nuy_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","“Marri, baarra-mani aynba-gaynbaj-jinyung ana-marrya. Baarra-yabijgana amudamu ama-barrawu-wuy. Nguynju yadhu numburru-nguyii nugurraa yungguyung aadani ana-marrya, wugurraayung nguyii yungguyung wudaju wu-ngarra-ngu-burraa-yinyung.” Dani-yung ni-yamaa na-God. ");
INSERT INTO nuy_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nigaayung na-Noah, wubanila-yung-galawaj nu-magaa-yinyung, ni-waṉbini niga na-Noah. ");
INSERT INTO nuy_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Anubanila-wala, niga na-Yawei na-God nu-yamijgayn na-Noah-wuy, “Numburru-yaarri ama-barrawu-wuy, nagang marri nugawi-nyinyung warra-mijburrayung. Anaani-rruj ana-lhal-lhangu, warraawurru wuu-ngarra-ngu-burraa-yinyung, nugaaj-bugij nu-ngu-burri ana-maaḻamburrg. ");
INSERT INTO nuy_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Aadanu ana-ngurudhu ba-nguyii-yinyung, aadanu 14 ba-mani, anggu-wulawaa-wugij, waḻya marri maṉung. Wugurraayung ana-mulung-arrgi aadanu, ba-mani anggu-wulawaa, waḻya marri maṉung. ");
INSERT INTO nuy_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Wugurraayung ana-ngurudhu, 14, anggu-nguynju, waḻya marri maṉung ba-mani, nguynju yadhu anggu-wiri anggu-burraa. ");
INSERT INTO nuy_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Marang-aynjaabugij marri jarranggay mana-miyn.nganga, wurru-wurrugu, bani-yung marri ngangu-lharrgang ngarraaṉbana. Angi-warra-rabina ngarraagi ngarraaṉbana 40 mana-miyn.nganga, angi-warra-rabina-wugij, miyn.ngu marri arrarra. Nganggarra-ngu-jadugang anaani-rruj ana-lhal, anaani wu-ngarra-biri-yinyung, ngaarra-maṉdhangi-yinyung, wu-warra-ngu-burraa.” Dani-yung na-Yawei ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Na-Noah ni-waṉbini wubanila-yung-galawaj na-Yawei-yinyung nu-magaa. ");
INSERT INTO nuy_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Naagi-yung na-Noah 600, nigawi-nyinyung aḏaba ni-yiwanggu-dhini. Anubani-yumbaa mana-ngugu manaama-yung ambamadhiyn anaani ana-lhal. ");
INSERT INTO nuy_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noah marri nigawi-nyinyung nga-rangarrina-yung marri nigawi-nyinyung warruburru warra-miniwiyayung marri wugurri-nyinyung warra-miniwiyayung-jinyung warra-miḏangarrina-yung, warraawurru-yung wurru-yanggi wurru-man-jabaynjini amubama ama-barrawu-wuy. Waari-waj mana-ngugu ama-waṉini, wurru-yabaynjini aḏaba. ");
INSERT INTO nuy_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Aadanu wu-warra-ngu-burraa-yinyung anaani-rruj-jinyung ana-lhal, ngurru-nguyii-yinyung yagu waari-yinyung ngaambu-ngang, marri anubani-yung wu-yalgarrwina-yinyung anaaban-baj, anubani-yung wu-ngarra-janggi wu-wulawaa-wugij, anubani waḻya marri maṉung. ");
INSERT INTO nuy_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Anubani-yung wu-ngarra-janggi na-Noah-wuy. Marri wu-ngarra-jabaynjini amubama ama-barrawu-wuy. Anaani wiiyn-nguynju ni-yambini-yinyung na-God, nu-magaa na-Noah a-wulhu-wulhurr-waj. ");
INSERT INTO nuy_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Anubani-yumbaa marang-aynjaabugij marri jarranggay mana-miyn.nganga, bani-yung marri mana-ngugu aḏaba ma-waṉini. ");
INSERT INTO nuy_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","16","Aadani-yumbaa na-Noah 600 nigawi-nyinyung aḏaba ni-malanga-jiwanggu-dhini. Wudani-yung-gala amaarmag, nigaayung na-ḻabama ni-wulawaa, ngigaayung ngarraaḻirr 17. Na-Noah marri nigawi-nyinyung warra-miniwiyayung Shem marri Ham marri Japheth marri na-Noah-yinyung nga-rangarrina-yung marri warra-miḏangarrina-yung warruburru-yung warra-miniwiyayung-jinyung, wurru-yabaynjini ama-barrawu-wuy. Wugurraayung anaaynba-gaynbaj-jinyung aadanu wu-ngarra-ngu-burraa-yinyung anaani-rruj, wugurraayung anaaynba-gaynbaj-jinyung ana-bulugi, anubani wu-ngarra-janggi buguni ama-barrawu-wuy, marri wu-ngarra-jalgarrwina-yinyung anubani anaaynba-gaynbaj-jinyung, marri wu-ngarra-guṉmana-yinyung ana-ngurudhu, marri wu-ngarra-jaarri-yinyung ana-ngurudhu, aadanu wu-ngarra-janggi wu-ngarra-jabaynjini ama-barrawu-wuy-wugij. Anaani ana-wulu-wulawaa, wu-ngarra-janggi nigawi-wuy na-Noah-wuy, marri wu-ngarra-jabaynjini. Anaani-yung wu-warra-ngu-burri anubagu, wu-ngarra-biri-yinyung, waḻya marri maṉung. Anubani-yung na-God nu-magaa-yinyung anubani-yunggaj. Anubanila na-God na-Yawei niwu-dhidiyn anu-dhawang. Anubani-yung aḏaba, anaa-gugu waaḻ-lhanga-lhangaḏbangi, aaban-gala. Wugurraayung anaa-gugu waar-warrini arrwar-wala. Ngarraagi ngarraaṉbana ngi-warra-rabini mana-miyn.nganga 40, arrarra marri miyn.ngu, runggal-windiyung ngi-warra-rabini ngarraagi. ");
INSERT INTO nuy_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Marri runggal ma-waṉini ngugu 40 mana-miyn.nganga ma-ḻuḻḏuḻwandi mana-ngugu. Marri manaama-yung mana-barrawu maallhiyn aḏaba, anubani ambaḻalhiyn anaaban, yuwaagu arrwar maalaldhi. ");
INSERT INTO nuy_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Anaa-gugu anaani-yung ambamadhiyn anaaban. Manaama-yung runggal-windiyung mana-ngugu, ma-waḻarrlhangi. Mana-barrawu aḏaba maallhangi. ");
INSERT INTO nuy_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Mana-ngugu aḏaba ma-ngarrgiyn. Anuwaagu-yinyung mana-ṉuga ma-ḻandhirrngindi-yinyung manaarrawindi, maadama-yung ambamadhiyn, anaani-yung anaa-gugu. ");
INSERT INTO nuy_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ma-ngarrgiyn windiyung aḏaba. Anubani-yung mana-ṉuga-wala, wugurraayung anaa-gugu anubani arrwar-windiyung, wu-burri, anubanila-wala 7 mita. ");
INSERT INTO nuy_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Anubani-yung anaarrawindi-yinyung wu-ngarra-ngu-burri wu-ngarra-biri-yinyung, aadani-yung wu-lhagarra-ngawini, wu-jadugiiyn. Anaarrawindi-yinyung anubani wu-ngarra-guṉmaa-yinyung, ana-ngurudhu, marri ana-bulugi, marri anaaynba-gaynbaj-jinyung wu-ngarra-jalgarrwini-yinyung anaaban-baj, marri warraarrawindi warra-wurru-wurruj, wu-lhagarra-ngawini. ");
INSERT INTO nuy_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Anaarrawindi wu-ngarra-ngu-burri-yinyung anubani anaaban-duj, anaarrawindi-yinyung anubani wu-ngayn.gaani-yinyung, aadani-yung wu-lhagarra-ngawini. ");
INSERT INTO nuy_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","God ni-warra-ngu-jadugayn aadani-yung, anaarrawindi-lhangu anubani wu-ngarra-biri-yinyung anaaban-duj-jinyung. Wurru-wurruj marri ngurudhu marri wu-ngarra-jalgarrwini-yinyung, marri ana-ngurudhu wu-ngarra-bilbilangi-yinyung. Wu-warra-ngu-jadugiiyn. Nigaaj-bugij Noah ni-wiri-mayn, marri warruburru-yung wuu-yagaynjini-yinyung wurraanggarra-ngu-burri-yinyung mana-barrawu-rruj. ");
INSERT INTO nuy_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Anaani-yung anaa-gugu ambamadhiyn anaani anaaban, 150 mana-miyn.nganga. ");
INSERT INTO nuy_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Na-God nu-yangani-wugij niga na-Noah marri wubani-yung a-ngurudhu-yinyung marri a-bulugi marri wubani wu-ngarra-ngu-burri-yinyung amubama-rruj ama-barrawu-rruj. Na-God niwu-lharrgang wudhanguyn, wu-waabuyaani. Anubani anaa-gugu waar-wagaagini aḏaba. ");
INSERT INTO nuy_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Anubani anaa-gugu wu-muḏaḏbiyn, waari aḏaba anggaaḻ-lhanga-lhangaḏbangi anaaban-gala. Wugurraayung ana-wumala-wala anubani wu-gara-wawalhangi-yinyung, waarwarrini-yinyung anuwagala anaa-gugu, anubani aḏaba wu-dhidiyn. Marri ngarraaṉbana ngi-warraajiyn. ");
INSERT INTO nuy_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Anaa-gugu waar-wagaagini aḏaba wurrugurrig aaban-guy. Anubani-yumbaa 150 ngarraaḻirr, anubani anaaban aḏaba waaban-bulbul-maa. ");
INSERT INTO nuy_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ḻabama marang-aynjaabugij marri ni-wulawaa aḏaba, ngigaayung ngarraaḻirr 17. Manaama-yung mana-barrawu ma-rijbini, amubama-yung ma-ḻandhirrngindi-wuy ama-ṉuga, maalamalhangayn arrwa-garrwar. Wu-mayini anubani-yung ana-lhal, Ararat. ");
INSERT INTO nuy_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Anaa-gugu waar-wagaagini-wugij. Wurrugu, naagi-na-ḻabama marang-aynjaabugij marri marang-aynjaabugij, ngarrubagi-yung ana-wulhu-wulhurr ngarraagi-yung ngarraaḻirr, anubani-yinyung anuwaagu-yinyung anaarrwar-garrwar-yinyung mana-ṉuga manubama-rruj, anuguni wirrima-nani manubama-yung mana-ṉuga ma-ṉuga-raba-rabalangi aḏaba. ");
INSERT INTO nuy_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ngijang ngarraaynbaj 40 mana-miyn.nganga, naagi na-Noah niwu-gara-wawalhijgayn anubani-yung ana-window. Niwu-maṉdhangi-yinyung anubani-yunggaj anaani-yung. ");
INSERT INTO nuy_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ni-miyn wuwag marri ni-lharrgang. Ni-wilbilangi. Ni-wura-wuramini-wugij, nga waari aniwu-lhangarrmaa ana-lhal. Wurrugu marri, waar-wagaagiyn waar-ngu-jadugini-wuy. ");
INSERT INTO nuy_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Anubanila ni-lharrgang-gala na-Noah, naagi-yung ni-waḻamin-jamijgini wubani aaban yungguyung anggaaban-bulbul-maa. Ngijang ngu-miyn ḻabarrg, ngijang ngu-lharrgang. ");
INSERT INTO nuy_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ngarra-ḻabarrg ngarraagi-yung waari anubuguni angiwu-lhangarrmaa anubani anaaban angi-ralhangi-yinyung. Ngiigiyn-gaj-bugij amubama ama-barrawu-wuy. Anaani anaa-gugu wurrugu waar-murrgulhi-wugij. Bagila ni-marang-dhangayangayn na-Noah marri ngi-wayamangi-wugij, ngi-ralhiyn a-marang-duj, ngu-burriyn lhirribala-wuy. ");
INSERT INTO nuy_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Anubanila-wala, ngijang ni-burri wurrugu, niimbu-narrini, marang-aynjaabugij marri muulawaa mana-miyn.nganga. Ngijang bagi-yung-bugij ḻabarrg-bugij, ngu-lharrgang. ");
INSERT INTO nuy_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Wurrugu, waamulugugurrangi, ngarraagi-yung ngarra-ḻabarrg ngijang ngiigiyn. Ngarraagi-yung ngiwu-manjarr-lhabangaa, aynjaabugij wu-manjarr-yililig. Anaani wu-mayini ana-manjarr, olive ana-rangag. Anubani-yung na-Noah aḏaba ni-marrbuy-mayn, anaani-yung anaa-gugu aḏaba waar-wagaagiyn-bindiyung. ");
INSERT INTO nuy_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Anubanila-wala, ngijang niimbu-narrini, marang-aynjaabugij marri muulawaa mana-miyn.nganga. Ngijang ni-malgaagijgiyn-bugij, ngu-lharrgang ngaadagi-yung ngarra-ḻabarrg. Aḏaba waari angiigini, ngarraagi aḏaba ngi-balanu ngi-yanggi. ");
INSERT INTO nuy_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Anubani-yumbaa naagi-yung na-Noah ni-burri 601 anaagalhal-aḻirr, naagi-yung ni-malanga-jiwanggu-dhini. Na-ḻabama naagi aynjaabugij aḏaba, ngarrubagi ana-wulhu-wulhurr ngarraaḻirr, anaa-gugu aḏaba waar-ngu-jadugiiyn. Na-Noah niwu-gara-wawalhijgayn anubani anu-dhawang, nga anubani ni-warranggayn. Anubani anaaban waaban-bulbul-maa lhaalhag. ");
INSERT INTO nuy_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Anubanila-wala, ngijang niimbu-narrini, na-wulawaa na-ḻabama. Nubagi-yung naaynbaj-duj na-ḻabama, ngarraagi-yung ngarraaḻirr 27, bani-yung marri anaaban aḏaba waaban-bubul-mayn-bindiyung. ");
INSERT INTO nuy_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Anubani-yung niga na-God nu-magayn na-Noah, ");
INSERT INTO nuy_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Numburru-rabalang, numburru-yaarri aḏaba, nagang marri nugawi nga-rangarrinaaj marri nugawi-nyinyung warra-miniwiyaay marri wugurri-nyinyung warra-miḏangarrina-yung. ");
INSERT INTO nuy_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Numbuu-yarrijgina, numbuu-rabalina aadanu aḏaba wu-ngarra-biri-yinyung. Aadanu ana-bulugi marri ana-ngurudhu aadanu wu-ngarra-jalgarrwina-yinyung. Wurrugu marri waṉagana arrawindi ana-wurrayung. Arrawindi aḏaba anggu-burraa. Anaani ambamadhang anggu-ngarra-ḏajaarrang ana-lhal-waj aḏaba.” Dani-yung ni-yamayn na-God. ");
INSERT INTO nuy_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Na-Noah marri nigawi-nyinyung nga-rangarrina-yung marri warra-miniwiyayung marri wugurri-nyinyung warruburru-yung warra-miḏangarrina-yung, wurraanggarra-rabalangi aḏaba. ");
INSERT INTO nuy_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ana-bulugi marri anubani wu-yalgarrwini-yinyung marri ana-ngurudhu marri anaaynba-gaynbaj-jinyung wugurraayunggaj, anubani wu-ngarra-ḏabalangi, wulu-wulawaa-wugij, anubani-yung wu-yamaa wu-rabalangi. ");
INSERT INTO nuy_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Na-Noah anubanila, nima-muṉḏugaa mana-ṉuga. Ni-wini anubani-yung mulung-arrgi bulugi marri ngurudhu, wurru-nguni-yinyung. Anubani bagu ni-nangaa ama-ṉuga-rruj, na-God yungguyung. ");
INSERT INTO nuy_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Na-Yawei na-God anubani-yung ni-warrawuj-jarrang arrawuj-mamaaḻang, waarrawuj-baynji. Ni-yamijgini anubuguni ana-lhirribala, “Nga-marrbuy warruburru-yung warra-wurru-wurruj-duj, wurru-wijangayii aladi ana-lhirribala, anubanila-wala wurraambuḻwina, wurraandha-wuguuguni anubani anaaladi, wurru-wijangayii-yinyung. Yagu wiiya aadanu. Yagi ngawu-marrgi anaaban nga-malgaagijgi ngijang. Yagi nga-wu ngijang wu-ngarra-biri-yinyung, aadanu yagi nga-malgaagijgi aḏaba. ");
INSERT INTO nuy_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Anaanila-wala anaani-rruj-jinyung ana-lhal anubani anggu-ngarra-ngu-burraa-maynji, anubani-yung anu-ḏal amburraanuynjungana amburraandha-wuguuguni. Marri amburru-mani anu-ngugulmung. Anaagalhal-mariga marri anaagalhal-aḻirr marri anaagalhal-aṉbana, anaarrarra marri ana-miyn.ngu, anggiijamana-wugij aadanu, anggiij-buguuguni.” Dani-yung ni-yamaa na-God. ");
INSERT INTO nuy_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Na-God waniigajij-majgaa na-Noah marri nigawi-nyinyung warra-miniwiyayung. Wani-yambini mamanunggu lhaawu. Ni-yamayn “Nugurru nambarra-lhamana arraarrawindi mijburrayung. Marri arrawindi warra-wurru-wurruj amburru-burraa anaani-rruj ana-lhal. ");
INSERT INTO nuy_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Aadanu ana-bulugi marri ana-ngurudhu marri anubani wu-ngarra-jalgarrwina-yinyung marri ana-ngujija, nambanggu-yamana nugurru. Anaani nganambaarriiyii, nugurru numburru-buunggawa-mana wugurri-wuy. ");
INSERT INTO nuy_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","“Nugurru nurru-marrbuy, anu…bani-yunggaj ngana-yayn wuḏal marri wungugulmung, nurru-nguni yadhu. Yagu anaanila-wala aḏaba, nganiiyii aynba-gaynbaj-jinyung numburru-nguyii. Anubani wu-ngarra-biri-yinyung marri anubani wu-wirbirina-yinyung, anubani-yung numburru-nguyii, numburru-marrya-wumana. Ngaya nganiiyii anaarrawindi-lhangu.” ");
INSERT INTO nuy_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Niga na-God ni-yambini-wugij. “Yagu numburru-nguyii-maynji ana-lhanggu, anubani-yung-maynji anggu-wulang-jirrirrii mana-wulang, yagi anubani nurru-ngi ana-lhanggu. Mana-wulang wiijamana aadanu wu-wiri. ");
INSERT INTO nuy_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Warrubawi-yung-maynji nambambiimana, marri ambirrimaadbarrwumana mana-wulang nugurri-nyinyung marri nambambii-jarina, warrubawi-yung ngambaa-gaagijgiiyn warrubawa, yagu yamba bama-yung yamba wulang. Marri, wugurraayunggaj ana-bulugi, nambangguumana-maynji, anubani-yung ngandaa-gaagijgiyn. Warraaynbaj-maynji ambarruumana warra-wurruj marri ambu-ngawang, wiijamana, nguynju nuumana nubagi na-nilharriyung. Waadawu ngambaa-gaagijgiiyn. ");
INSERT INTO nuy_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Warraaynbaj-maynji warrubawi-yung ambarraa-garwarrii manubama-yung mana-wulang, wugurraayunggaj warruburru-yung warra-mulung-arrgi-yung wugurraayung amburru-yamang, ambarraagarwarrii manubama-yung mana-wulang. Ngaya yamba ngarra-majgaa warra-wurru-wurruj nguynju ngayawi-yii. ");
INSERT INTO nuy_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Nugurru aadanu, nambarra-waṉagana arrawindi warra-mijburrayung. Wurrugu marri, arraarrawindi marri warra-wurru-wurruj. Arraarrawindi amburru-rajaarrii anaani-rruj ana-lhal.” Dani-yung ni-yambini na-God. ");
INSERT INTO nuy_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ngijang wani-magaa na-Noah marri nigawi-nyinyung warra-miniwiyayung. ");
INSERT INTO nuy_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Ni-yamayn “Anaani ngana-lhalamayana marri nugurri-wuy warra-mijburrayung warruburru-yung nambambi-garrindharrmani-yinyung. ");
INSERT INTO nuy_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Marri nga-lhalamayana wugurraayunggaj aadanu anaaynba-gaynbaj-jinyung wu-ngarra-biri-yinyung, ana-ngurudhu marri ana-bulugi marri anaaynba-gaynbaj-jinyung, aadanu anaarrawindi-lhangu wu-ngarra-ḏabalangi-yinyung manubama-yung-gala mana-barrawu-wala. ");
INSERT INTO nuy_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Anaani ngana-lhalamayana nugurri-wuy. Aadanu yagi ngaarra-ngu-jadugi aadanu wu-ngarra-biri-yinyung. Yagi ngijang ma-malgaagijgi mana-ngugu. Ngijang yagi ngama-lharrgi maadamu mana-ngugu ma-yami anaani-yung-jii. Ngijang yagi ngaarra-ngu-jadugi aadanu anaarrawindi-yinyung mana-ngugu-mirri.” ");
INSERT INTO nuy_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Niga na-God ni-yambini-wugij. “Yaani nganiiyii malnguj, yaani numburru-marrbuy yungguyung yaani ngana-lhalamayana. Marri ngaarra-lhalamayana wu-ngarra-biri-yinyung, wugurraayunggaj, anaani anggu-wuguuguni. ");
INSERT INTO nuy_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Dani nga-burriyn marryn, wu-lhara wu-malnguj, a-ngubunung-baj. Ana-malnguj aadanu nambanggu-yiyina, ngaya anaani ngana-lhalamayana, nugurru marri ana-lhal-lhangu. ");
INSERT INTO nuy_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Aadanu nganggu-lharrganjii-maynji ana-ngubunung, anggu-rijbina, anubani-yung nga-nayii anggu-lhara anu-malnguj ana-ngubunung-duj, ");
INSERT INTO nuy_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","bani-yung nganggawanggina anubani-yung ngana-lhalamayaa-yinyung nugurru, marri wu-ngarra-biri-yinyung. Anaa-gugu ngijang yagi mana-ngugu maadadi, ma-yami, yagi jadugi aadanu wu-ngarra-biri-yinyung. ");
INSERT INTO nuy_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","anu-malnguj-maynji ana-marryn anubani ana-ngubunung-duj anggu-lhangang, marri anubani-yung nga-nayii, marri ngambijangayii, anubani-yung ngana-lhalamayaa-yinyung nugurri-wuy marri aadanu aynba-gaynbaj-jinyung wu-ngarra-biri-yinyung ana-lhal-lhangu-rruj.” ");
INSERT INTO nuy_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Niga na-God ni-yambini-wugij na-Noah-wuy. “Anaani ana-malnguj wubani-yung ngana-lhalamayaa-yinyung nugurri-wuy marri anubani wu-ngarra-biri-yinyung anaarrawindi-lhangu-yinyung ana-lhal-lhangu-yinyung. Anubani ngana-lhalamayaa-yinyung anaani wiij-baḏa-waḏaḏ.” Dani-yung ni-yamaa na-God. ");
INSERT INTO nuy_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Na-Noah-yinyung warra-miniwiyayung, warru-mu-muwaj Shem, Ham, Japheth. Wurru-ngarra-ḏabalangi mana-barrawu-wala. Na-Ham naagi-yung, niga na-ninyarra-yung na-Canaan-jinyung. ");
INSERT INTO nuy_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Waadurru-yung warra-wulu-wulaynbaj warra-miniwiyayung na-Noah-yinyung. Waadurru-yung ana-lhal-lhangu-yinyung warra-wurru-wurruj, waadurru-yinyung warra-lhamaa, wurru-ngarra-ḏajaarrangi. ");
INSERT INTO nuy_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Na-Noah ni-rigandi, ni-wanuynjungaa. Anaani-yung niwu-wanuynjungaa wuyarrangaḻ. ");
INSERT INTO nuy_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Anubanila-wala, wu-warradangi aḏaba niwu-mangi anubani-yung ana-wuyarrangaḻ, niwu-dhurrmaa, niwu-maṉdhangi wine. Anubani-yumbaa aḏaba ni-waḻ-nguni, ni-wan-burrurru-dhiyn naagi-yung. Naagi-yung ni-burri ama-ganbij-duj. Anubagu ni-murrgulhi, maari manaama-yung mana-yaaḻi ani-yabini, nima-ngarrgiwaa, ni-yaay ni-mamar. ");
INSERT INTO nuy_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Anubanila-wala, nigaayung na-Ham ni-yanggi ni-warranggayn, nu-nayn, na-ninyarra-yung anubagu ni-mamar, naagi ni-murrgulhi. Niigiyn, wani-magaa bagu nubiṉi na-nilharriyung-biiyung. ");
INSERT INTO nuy_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Naawiṉi-yung na-Shem marri na-Japheth wini-yanggi, winima-miyn yaaḻi, naawiṉi-yung winima-dhig-baṉagaa niga amaaynbaj-duj nigaayung, anubanila winima-burriyn a-nyaḻaj-duj, wini-biinga-gaagini janda-mirri, yagi yungguyung ambunu-nani na-ninyarra-yung. Yingga wunu-lhangarrmayn, wunaambamadhiyn na-ninyarra-yung. Wini-ramarra-gaḻadhi-wugij naawiṉi-yumbaa. Waari ambunu-nani na-ninyarra-yung, ni-mamar yamba ni-murrgulhi. ");
INSERT INTO nuy_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Wurrugu, anubanila-wala na-Noah ni-marayanggiyn. Ni-marrbuy-mayn anubani-yung ni-yaminggarrini na-Ham na-wirrinyung-jinyung na-niwayayung. ");
INSERT INTO nuy_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Naagi-yung ni-yamaa, “Na-God nubagi anaagajij-galadi-wana na-wirrinyung na-Canaan, nubagi na-Ham-jinyung na-niwiyayung. Niga warra-minilharriyung, nubagi niga ambani-yandhurrbangana, ani-wirrig-bindiyung.” Dani-yung ni-yambini na-Noah. ");
INSERT INTO nuy_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ngijang ni-yambini, ni-yamayn, “Nganu-warraarriwana na-Yawei na-God nigawi-nyinyung na-Shem-jinyung. Nigaayung na-Canaan anu-yandhurrbangana na-Shem. ");
INSERT INTO nuy_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Anubani ana-lhal na-Japheth-jinyung, na-God anubani aniwu-runggal-wana. Warruburru warra-mulung-arrgi-yung wunu-lhamarrii-yinyung, amburru-burraa nubagi-rruj na-Shem-duj ana-lhal. Nigaayung na-Canaan anu-yandhurrbangana na-Japheth.” Dani-yung ni-yamaa na-Noah. ");
INSERT INTO nuy_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Anubanila-wala, manubama-yung mana-ngugu-wala, naagi na-Noah ni-burri 350 anubani anaagalhal-aḻirr. ");
INSERT INTO nuy_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nigawi-nyinyung anubani ana-wiri ni-burri 950 ni-burri. Anubanila-wala, ni-ngawiiyn aḏaba. ");
INSERT INTO nuy_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Anaani aḏaba ana-lhaawu wu-waṉina warruburru-yung wuu-lhamarrangi-yinyung na-Shem marri na-Ham marri na-Japheth-jinyung, warra-miniwiyayung na-Noah-yinyung. Wurrugu, manubamala-wala mana-ngugu-wala, warraawurru-yung warra-wulu-wulaynbaj warra-lhamaa warra-miniwiyayung. ");
INSERT INTO nuy_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Na-Japheth niga warruburru-yung warru-mu-muwaj Gomer, Magog, Madai, Javan, Tubal, Meshek marri Tiras. ");
INSERT INTO nuy_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Na-Gomer-yinyung warra-miniwiyayung warru-mu-muwaj Ashkenaz, Riphath, Togarmah. ");
INSERT INTO nuy_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Marri na-Javan-jinyung warra-miniwiyayung marri warruburru-yung wurru-lhamarrangi-yinyung, warraawurru-yung warra-wurru-wurruj anubani-yinyung ana-lhal wu-mayini Elishah, Spain, Cyprus marri Rhodes. ");
INSERT INTO nuy_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Warruburru-yung wurru-burri warubaj ama-madhaḻag-duj, marri a-rilji-rruj. Durru-yung nigawi-nyinyung warra-mijburrayung na-Japheth-jinyung, marri warruburru-yung wurru-lhamarrangi-yinyung. Waadurrala-wala, wurru-mulung-ḏajaarriyn warra-wurru-wurruj. Wuu-ngarra-ngu-burri warra-wurru-wurruj a-lhal-aynbaj-baj. Wurrugu marri, ana-lhaagi ambirri-mani aynba-gaynbaj-jinyung ngijang. ");
INSERT INTO nuy_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Nigaayung na-Ham-jinyung warra-miniwiyayung warru-mu-muwaj, Cush, Egypt, Put, marri Canaan. ");
INSERT INTO nuy_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Na-Cush-jinyung warra-miniwiyayung, Seba, Havilah, Sabtah, Raamah, Sabtecah. Na-Raamah-yinyung nubiṉi na-niwiyayung-biiyung, Sheba marri Dedan. ");
INSERT INTO nuy_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Naagi-yung na-Cush, nu-lhamayn naagi-yung na-Nimrod. Naagi na-Nimrod, naagi-yung ni-waḏa-waḏaḏ-jung-bindiyung. ");
INSERT INTO nuy_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Naagi-yung ni-yanggi-yinyung niilhagalharrmangi-yinyung wubani-yung a-yalaj, naagi-yung walajung-bindiyung. Marri na-Yawei niga ni-marrbuy. Wudanila-wala warra-wurru-wurruj warruburru-yung wurru-yamana anaani-yung ana-lhaawu, “Naadagu nguynju na-Nimrod-jii, naadagu walajung-bindiyung, marri na-Yawei ni-marrbuy.” ");
INSERT INTO nuy_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Naagi na-Nimrod wani-narrangi a-lhal-aynbaj-gala-yinyung, warraawurru-yung warra-wurru-wurruj. Ana-wulhu-wulhurr niwu-waṉagaa anaani ana-wumurrng, Babel, Erech, Akkad marri Calneh. Anubani-rruj-jinyung ana-lhal anaani-rruj, Shinar, ana-lhal, wu-mayini. ");
INSERT INTO nuy_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Naagi-yung na-Nimrod ni-yanggi Assyria-wuy. Niwu-raani anubani ana-Nineveh marri ana-Rehoboth Ir, marri Calah ");
INSERT INTO nuy_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","marri Resen. Ana-Nineveh marri ana-Calah, bagu bandharra wu-burri ana-wumurrng, wu-rudugaynjini. Anubani ana-runggal ana-lhal, runggal-windiyung anubani ana-wumurrng. ");
INSERT INTO nuy_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Nubagi-yung naaynbajung na-Egypt, wani-lhamaa warra-mijburrayung, marri warraaynba-gaynbaj-jinyung warru-mandag wuu-lhamaynjini warruburru-yung warra-wurru-wurruj. Warraawurru-yung warra-wurru-wurruj wurru-burri anubani-rruj ana-lhal Lydia, Anam, Lehab, Naphtuh, ");
INSERT INTO nuy_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pathrus, Casluh, marri Caphtor. Warraawurru-yung wurru-mayini Philistine, warraawurru-yung wuu-lhamaynjini-yinyung warra-wurru-wurruj ana-Caphtor-inyung ana-lhal. ");
INSERT INTO nuy_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Nigaayung na-Canaan naagi-yung nu-lhamayn na-Sidon, ana-wulhu-wulhurr na-niwiyayung. Marri anubanila-wala warraawurru-yung wuu-lhamarrangi, wubani a-lhal-aynbaj-gala-yinyung a-lhal. Warraawurru-yung wurru-mayini warra-Hittite, ");
INSERT INTO nuy_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","warra-Jebusite, warra-Amorite, marri warra-Girgashite, ");
INSERT INTO nuy_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","marri warra-Hivite, marri warra-Arkite, marri warra-Sinite, ");
INSERT INTO nuy_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","marri warra-Arvadite, marri warra-Zemarite, marri warra-Hamathite. Waadurru-yung warra-mijburrayung naagi-yung na-Canaan-jinyung wurru-yanggi, wurru-rajaarriyn. ");
INSERT INTO nuy_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Warraawurru-yung aḏaba wurru-yanggi wunumbiyaj Sidon-guy, wugurraayung warra-mulung-arrgi-yung wurru-yanggi arrgaḻinyi Gaza-wuy, wugurraayung warra-mulung-aynbaj wurru-yanggi ramaliyaj Sodom-guy marri Gomorrah-wuy marri Admah-wuy marri Zeboiim-guy marri Lasha-wuy. Anubani ana-lhal ana-runggal wu-mayini Canaan. ");
INSERT INTO nuy_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Dani-yunggaj ana-lhaawu na-Ham-jinyung warra-mijburrayung, warruburru-yung warra-mulung-arrgi-yung-jinyung warru-mandag, anubani ana-lhaagi aynba-gaynbaj-jinyung marri anubani-rruj ana-lhal aynba-gaynbaj-jinyung. ");
INSERT INTO nuy_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Naagi-yung nigaayung na-Shem, niga naagi maḻamarrijung, nigaayung naagi-yung na-Japheth niga na-yabaḏinyung. Naagi-yung na-Shem, wurrugu malgadhaadharri marri naagi-yung nu-ga-garri-yuriyn na-ninyarra-yung na-Eber. Marri bani-yung warra-mijburrayung wuu-waṉini arraarrawindi wani-lhamaa na-Eber. ");
INSERT INTO nuy_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Yaawurru-yung warra-miniwiyayung na-Shem-jinyung, warru-mu-muwaj. Elam, Asshur, Arpaksad, Lud, Aram. ");
INSERT INTO nuy_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Warra-miniwiyayung na-Aram-jinyung, warru-mu-muwaj, Uz, Hul, Gether, Meshek. ");
INSERT INTO nuy_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Naagi-yung na-Arpaksad, naagi-yung na-ninyarra-yung na-Shelah-yinyung. Nigaayung na-ninyarra-yung na-Shelah, na-Eber-inyung. ");
INSERT INTO nuy_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Na-Eber naagi-yung wani-lhamaa wini-wulawaa na-niwiyayung-biiyung. Na-nimuwaj-jung ni-mayini Peleg. Ni-wiri-waj naagi-yung na-Peleg, anaani-yung ana-lhal wirri-munduwaa. Nigaayung na-nilharriyung na-nimuwaj-jung Joktan. ");
INSERT INTO nuy_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Na-Joktan-jinyung warra-miniwiyayung marri warruburru-yung wurru-lhamaynjini-yinyung, warraawurru-yung warra-wurru-wurruj anubani-rruj ana-lhal wu-mayini Almodad, Sheleph, Hazarmaveth, Jerah, ");
INSERT INTO nuy_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diklah, ");
INSERT INTO nuy_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO nuy_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havilah, Jobab. Durru-yung wurru-burri-yinyung ana-lhal, wurru-lhamaynjini na-Joktan-gala. ");
INSERT INTO nuy_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ana-lhal anubani wurru-burri-rruj-jinyung, wu-mayini Mesha, marri Sephar, manubama-rruj amaaynja-ṉugu-ṉuga-rruj yuuguni ramaliyaj. ");
INSERT INTO nuy_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Dani-yunggaj ana-lhaawu waadurru-yung-jinyung wuu-lhamarrangi-yinyung na-Shem-gala. Warruburru-yung warra-mulung-arrgi-yung-jinyung warru-mandag, anubani ana-lhaagi aynba-gaynbaj-jinyung marri anubani-rruj ana-lhal aynba-gaynbaj-jinyung warra-wurru-wurruj. ");
INSERT INTO nuy_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Danila-yung-galawaj ana-lhaawu warruburru-yung-jinyung warra-wurru-wurruj wurru-mulung-bulaynbaj warru-mandag warra-miniwiyayung-jinyung na-Noah-yinyung. Warruburru-yung wurru-lhamaynjini wurru-mulung-bulaynbaj warru-mandag. Warraawurru-yung warra-wurru-wurruj wuu-manda-ḏajaarriyn aḏaba, manubamila-wala ma-waṉini-wala mana-ngugu. ");
INSERT INTO nuy_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Anubani-yumbaa, warraawurru-yung warra-wurru-wurruj aynjaabugij ana-lhaagi wuu-yambini. Wuu-yambini dani-yung-bugij. ");
INSERT INTO nuy_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Warraawurru-yung wurru-yanggi yaanuwuy ramaliyaj. Wirri-lhangarrmayn lhal a-wumayamaya-rruj. Anaani wu-mayini ana-lhal, Shinar. Nga bagu waadurru-yung wurru-burri. ");
INSERT INTO nuy_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Wuu-yambiynjini anubagu, “Gurruwaj, ngagurru ngaani-mani marri ngaani-dhurrmana arrmaṉngal, ngaanggaaban-baḻii yadhu, ngaanggu-nangana,” wurru-yamayn. Anubanila-wala, wirri-maṉdhangi arrmaṉngal-wala, nguynju wu-yamaa a-brick-jii, waari yamba anubagu maaynjaari mana-ṉuga. Wuu-rigandi aban-maṉḏuj-maṉḏuj wirriiban-dhangarrmayn. Wu-yamaa nguynju a-cement-jii. ");
INSERT INTO nuy_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Wurru-yamayn “Numburraaṉiyn ngaanggu-maṉdhii runggal wumurrng, ngagurraa yungguyung. Marri ngaanggu-maṉdhii yuuguni arrwiyaj-bindiyung anggu-yaarri marri ambarr-yarrdang ana-tower yuwaagu-windiyung arrwar. Nguynju yadhu ngagurri-nyinyung ana-muwaj anggu-mayina anggu-runggal. Nguynju yadhu yagi yungguyung nguu-rajaarri anuguni ana-lhal-aynbaj ana-lhal, yaaji-wugij ngaambu-burraa ngaambu-muṉḏugana.” Dani-yung wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Na-Yawei na-God ni-dhirridangi, ni-warranggayn, niwu-nani wubani a-wumurrng marri wubani-yung wugambarr niwu-nani. ");
INSERT INTO nuy_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ni-yamayn, “Yigaj, warraawurru wurru-manda-galiynjina,” ni-yamijgini, “Wuu-yambina aynjaabugij yamba ana-lhaagi. Anaani aynjaabugij wirri-maṉdhangi ana-wulhu-wulhurr ana-wumurrng. Bagala marri, ambirri-maṉdhii ambirri-runggal-wana. Anubani-yung-maynji amburru-wijangayii, marri bani-yung amburru-waṉbina. ");
INSERT INTO nuy_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Anaani ngaynjaminggarrina? Nga-ngu-dhirridang, ngambaa-gaynbijgang ana-lhaagi, nguynju yadhu yagi yungguyung wurraajangaynji ana-lhaagi.” Dani-yung ni-yamaa na-Yawei na-God. ");
INSERT INTO nuy_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Anubanila-wala wani-rajaarrijgayn. Anubani waari aḏaba ambirri-maṉdhangi ana-wumurrng. ");
INSERT INTO nuy_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Anubani-yung ana-wumurrng wu-mayini Babel, anaani wiijamana, na-God wani-gaynbijgayn anubani ana-lhaagi, warraarrawindi-lhangu-yinyung warra-wurru-wurruj. Na-Yawei anubanila-wala, wani-rajaarrijgayn aḏaba, wuu-manda-ḏajaarriyn, wuu-ngarra-janggi a-lhal-wuy yuuguni yaanuwuy, wuu-ngarra-janggi. ");
INSERT INTO nuy_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Yaani ana-lhaawu warra-mijburrayung-jinyung na-Shem-jinyung. Na-Shem naagi-yung 100 ni-burri-yinyung anaagalhal-aḻirr. Nga naagi-yung nu-lhamayn na-niwiyayung Arpaksad. Wulawaa anaagalhal-aḻirr manubamala-wala mana-ngugu-wala. ");
INSERT INTO nuy_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Anubanila na-Shem ni-burri 500 anaagalhal-aḻirr wurrugu. Wani-lhamaa warra-miniwiyayung marri warra-miyn.ngarriwayayung. ");
INSERT INTO nuy_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Nigaayung na-Arpaksad nigaayung 35 anaagalhal-aḻirr. Marri nu-lhamayn na-nimuwaj-jung Shelah. ");
INSERT INTO nuy_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Naagi-yung na-Arpaksad anubanila ni-burri 403 anaagalhal-aḻirr. Wani-lhamaa warra-miniwiyayung marri warra-miyn.ngarriwiyayung, naagi-yung. ");
INSERT INTO nuy_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Nigaayung naagi-yung na-Shelah, naagi-yung 30 ni-burri-yinyung anaagalhal-aḻirr. Nu-lhamayn marri bani-yung na-Eber. ");
INSERT INTO nuy_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Anubanila na-Shelah naagi-yung ni-burri 403 anaagalhal-aḻirr. Wani-lhamaa warra-miniwiyayung marri warra-miyn.ngarriwiyayung. ");
INSERT INTO nuy_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Nigaayung naagi-yung na-Eber 34 anaagalhal-aḻirr ni-burri naagi-yung. Marri bani-yung nu-lhamayn na-Peleg. ");
INSERT INTO nuy_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Naagi-yung na-Eber anubani ni-burri 430 anaagalhal-aḻirr. Warra-miniwiyayung marri warra-miyn.ngarriwiyayung wani-lhamaa anubani-yung. ");
INSERT INTO nuy_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Naagi-yung na-Peleg nigaayung 30 anubani anaagalhal-aḻirr. Nu-lhamayn naagi-yung na-nimuwaj-jung Reu. ");
INSERT INTO nuy_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Anubanila-wala na-Peleg naagi ni-burri 209 anaagalhal-aḻirr. Wani-lhamaa warra-miniwiyayung marri warra-miyn.ngarriwiyayung. ");
INSERT INTO nuy_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Naagi-yung na-Reu ni-burri 32 anaagalhal-aḻirr. Marri nu-lhamayn naagi-yung Serug na-nimuwaj-jung. ");
INSERT INTO nuy_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Anubanila-wala naagi-yung na-Reu ni-burri 207 anaagalhal-aḻirr. Marri wani-lhamaa warra-miniwiyayung marri warra-miyn.ngarriwiyayung. ");
INSERT INTO nuy_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Naagi-yung na-Serug ni-burri 30 anaagalhal-aḻirr. Nu-lhamayn naagi-yung na-nimuwaj-jung Nahor. ");
INSERT INTO nuy_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Na-Serug naagi-yung ni-burri 200 anaagalhal-aḻirr. Marri wani-lhamaa warra-miniwiyayung marri warra-miyn.ngarriwiyayung, naagi-yung. ");
INSERT INTO nuy_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naagi-yung na-Nahor ni-burri 29 anaagalhal-aḻirr. Marri bani-yung nu-lhamayn na-Terah. ");
INSERT INTO nuy_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Anubani-yung naagi na-Nahor ni-burri anaagalhal-aḻirr 119. Wani-lhamaa warra-miniwiyayung marri warra-miyn.ngarriwiyayung. ");
INSERT INTO nuy_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Nigaayung na-Terah 70 anaagalhal-aḻirr. Marri wani-lhamaa Abram marri Nahor marri Haran, wani-lhamaa. ");
INSERT INTO nuy_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Yaani ana-lhaawu warra-mijburrayung-jinyung na-Terah-yinyung. Naagi na-Terah wani-lhamaa na-Abram marri na-Nahor marri na-Haran. Nigaayung na-Haran nu-lhamayn na-Lot. ");
INSERT INTO nuy_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Na-Haran ni-ngawiiyn, wubani-rruj-jinyung a-lhal-uj niimbuḻwiiyn-duj. Anubani na-ninyarra-yung na-Terah niga ni-wiri-wugij. Ana-muwaj Ur wu-mayini, marri anaani ana-runggal ana-lhal wu-mayini Babylonia. ");
INSERT INTO nuy_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Naawiṉi-yung na-Abram marri na-Nahor winiiynji-yaay aḏaba, nga-rangarrina-yung-biiyung. Naagi-yung na-Abram, nga-rangarrina-yung ngi-mayini Sarai. Nigaayung na-Nahor, nga-rangarrina-yung ngi-mayini Milcah. Ngarra-Milcah ngaadagi-yung ngarra-ngarrilharriyung ngi-mayini ngarraagi-yung Iscah. Na-Haran naagi-yung ninyarra-yung ngaadirrngi-yumbaa-yinyung. ");
INSERT INTO nuy_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ngarra-Sarai ngiga waari ambangi-waṉagaa warra-mijburrayung. ");
INSERT INTO nuy_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Na-Terah naadagi-yung nu-miyn na-Abram na-niwayayung, marri na-Lot na-rangan-muruyung na-Terah nu-miyn, na-niwiyayung na-Haran-jinyung, marri Sarai ngigaayung ngi-yanggi, na-niwiyayung-jinyung nga-rangarrina-yung. Anubani wurraanggarra-yanggi, bagala wirriirruyn aḏaba ana-Ur ana-lhal, wubani a-runggal a-lhal Babylonia. Wurru-yanggi yuuguni Canaan-guy. Warraawurru-yung wurru-yanggi, nga aḻagaḻa wurru-waliyn Haran ana-lhal. Nga bagu wurru-burri wurrugu. ");
INSERT INTO nuy_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Baḏag wurru-burri anubagu aḏaba wurrugu. Naagi-yung na-Terah 205 nigawi-nyinyung manaarmag ni-burri. Bani-yung marri ni-ngawiiyn a-lhal-uj Haran-duj wu-mayini. ");
INSERT INTO nuy_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Anaani ana-lhaawu wu-magina anu…bani-yunggaj ana-Israel-inyung. Anubani-yumbaa warruburru-yung warra-runggu-runggal warra-mayaa “wurru-ragaana-yinyung”. Bagu waḻyinyung ni-burri, Elimelech na-nimuwaj-jung. Nigawi-nyinyung warru-mandag Ephrath. Ni-burri a-Bethlehem-duj a-Judea-rruj. Nga-rangarrina-yung Naomi, marri na-niwiyayung-biiyung Mahlon marri Chilion, na-nimuwaj-baa. Waari ngarraaṉbana angi-warra-rabini nguynju waari ana-marrya amburru-nguni yungguyung, maarmag-galadi. Wudani-yung yamba, wurraanggarra-yanggi Moab, nga wurru-burri bagu. ");
INSERT INTO nuy_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Anubanila-wala ni-ngawiiyn, nga Naomi waari angunu-waṉagaa naaṉngina-yung. Waangi-waṉagaa ni-marayung-biiyung-bugij. ");
INSERT INTO nuy_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Marri naawiṉi-yung winiiynji-yaay wani-mangi maṉumbaa, wubani-yinyung a-lhal, ngarra-ngarrimuwaj-baa Orpah marri Ruth wugurrngi. ");
INSERT INTO nuy_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Anubanila-wala, ari marang-aynjaabugij marri marang-aynjaabugij manaarmag, wini-ngawiiyn, wugurraayunggaj. Nga ngarra-Naomi aḏaba, ngi-wiri-wiri ngi-burri, wuu-lhagarra-ngawini aḏaba na-nimarayung-biiyung marri naaṉngina-yung. ");
INSERT INTO nuy_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Ngarra-Naomi ngi-burri wubani-rruj a-lhal. Nga anubanila lhaawu ngi-wawanggiyn, ninggu-lhangarrmayn. Na-Yawei wani-warubaj-gayn aḏaba warraawurru warra-wurru-wurruj nigawi-nyinyung, nga wani-yayn ngarraaṉbana. Marri ana-marrya anubani wani-yayn waanuynjungini aḏaba, wurru-nguni yadhu. Nga wudani-yung yamba ngarra-Naomi marri ngarrubirrngi nga-rangan.ngarri-yung-biiyung, wurraalgaalgurmangi amburru-yanggi yungguyung. ");
INSERT INTO nuy_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Wurraanggarra-yanggi aḏaba. Wurru-yangga-yanggi… nga aḻagaḻa aḏaba. ");
INSERT INTO nuy_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Wangi-yamijgayn, “Nimbingi-ngarra-gaagiyn nga-rriibi-waa-wuy. Ngaaḻamin-jamana na-Yawei, nambani-maṉmani nugurrngi, nguynju ngaya ngirri-maṉmangi nga nubiṉi na-waḻya-waa. ");
INSERT INTO nuy_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Nambani-lharrgang, nambaangiiynji-yara waḻya, nambaangi-waṉagana.” Dani-yung ngi-yamayn. Ngarraagi-yung ngarra-Naomi wangi-bilhargayn ngarrubirrngi nga-rangan.ngarri-yung-biiyung nga ngi-yamayn, “Wiiyaw,” ngi-yamayn. Yagu wugurrngiiyung wingi-ruguni. ");
INSERT INTO nuy_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Wingi-yamayn, “Yangi ngunaarru! Ngambaanggarra-yaarri nugawi-wuy warra-wurru-wurruj,” wingi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Nga ngarra-Naomi ngi-yamayn nga-rangan.ngarri-yung-biiyung-guy, “Nimbingiigiyn nugurrngi-wuy aanga. A-yangi yungguyung ngirri-ga-garri-yuri?” wangi-yamijgayn. “Nimbingiigiyn,” ngi-yamayn, “waari yamba ngarra-lhangarrmi warra-waḻya. Aḏaba anaani nga-ngajiwanggu,” wangi-yamijgayn. ");
INSERT INTO nuy_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Nga ngi-yamayn, “Nimbingiigiyn, marri nambaangi-mani waḻya,” ngi-yamayn. “Ngamba-mang-maynji warra-waḻya, warrubawi-yung warra-wirrig nambaangi-rangarrii baḏag, ambu-warradii-yinyung,” ngi-yamayn. “Nimbingiigiyn.” ");
INSERT INTO nuy_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","Marri wangi-yamijgayn, “Naangi-rangarrangan-magi, baḏag warrubawi-yung wu-warradangan, nubiṉi-yung na-wirrig-baa,” ngi-yamayn ngarra-Naomi. “Nimbingi-yaarri. Nambangi-mani aḏaba aynbaj. Ari naangi-narrangan-magi nubiṉi-yung, baḏag-magi wini-warradangan,” wangi-yamijgayn. “Na-Yawei niiynbijgiyn niga, ni-wiḻibiḻingiyn ngayawi-wala, marri ngaya anaani nga-wurrij-galadi-wina nugurrngi-wala.” Dani-yung ngi-yamayn, ngarra-Naomi ngiga. ");
INSERT INTO nuy_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Ngijang wingi-ruguni, wugurrngiiyung, angaḏajung wingi-ruguni yanggarrwar. Nga ngarra-Orpah ngu-bilhargayn marri ngi-yamayn, “Wiiyaw,” ngi-yamayn, “nga-yaarri,” ngu-yamijgayn ngarrubagi-yung. Ngiigiyn aḏaba a-lhal-wuy. Yagu ngigaayung ngarra-Ruth waari angi-yanggi, ngu-maṉdhiyn wingiinggarra-ngu-burri bagu, ngarrubagi-rruj. ");
INSERT INTO nuy_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Nga ngigaayung ngarra-Naomi ngi-yamayn ngigawi-wuy, “Nugawi-nyinyung ngarra-nganilharri aḏaba ngi-yanggi, ngiigiyn ngigawi warra-wurru-wurruj-guy marri ngigawi na-god. Nugaayung baagiyn nugawi-nyinyung-guy warra-wurru-wurruj marri nugawi-nyinyung-guy na-god. Baagiyn aḏaba a-lhal-wuy.” Dani-yung ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Yagu ngigaayung ngarra-Ruth ngi-yamayn, “A-yangi yungguyung nimba-yandhawiwanjii ngaya, waarruyn? Yagi nimba-lhambu ngaya ngaynjaarri nugawi-waj. Nagang-maynji ba-yaarri, ngaya ngaynjaarri nugawi-wuy. Yagu nagang-maynji ba-burraa, ngaya nga-ngu-burraa nugawi-rruj. Nugawi-nyinyung warra-wurru-wurruj, ngaayunggaj ngayawi-nyinyung warra-wurru-wurruj warruburru. Nga-nugawi-nyinyung na-God, ngaayung ngayawi na-God. ");
INSERT INTO nuy_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Anubani-rruj ana-lhal nagang ba-ngawang-maynji, ngaya bani-rruj a-lhal nga-ngawang, nga bagu ngambambi-wurrdhii. Nagang-maynji ba-ngawang yagu ngaya-maynji nga-ngawang, waarruyn, yagu nambiri-waj-maynji waarruyn, nganu-ngaynbandii na-Yawei ngambaniigajij-galadi-wana ngaya.” Dani-yung ngi-yamayn ngarra-Ruth. ");
INSERT INTO nuy_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Ngarra-Naomi ngarrubagi ngi-marrbuy ngarra-Ruth waari angi-yanggi. Waari ngijang anggu-yambini ngijang ngigawi-wuy aḏaba. ");
INSERT INTO nuy_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Wingi-yanggi a-Bethlehem-guy, nga wingi-waliyn. Nga warruburru-yung warra-maṉaṉung wirringa-nayn. Nga wurru-yambiynjini, “Yuga ngaadagu Naomi yuga?” wurru-yandhawiwaynjini waadurru-yung. ");
INSERT INTO nuy_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Marri ngigaayung ngi-yamayn, “Yagi anaani ngirri-mayi Naomi, ana-muwaj, nga-ḏinggina-yinyung. Yagu ngirri-mayana ngaya ‘Mara’, nga-wurrij-galadi-wina-yinyung, yagu na-Yawei yamba ngaya ngani-wurrij-galadi-wayn-bindiyung. ");
INSERT INTO nuy_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Ngaya nga-yanggi, ngaarra-waṉagaa arrawindi, yagu ngaya na-Yawei nganiigijgiyn nga-mara-mamar ngaya. Waari nganggaarra-waṉagaa anaaji,” ngi-yamayn ngarra-Naomi. “Yagi nirri-mayi nga-ḏinggina-yinyung, yagu na-Yawei yamba anii-dharrgang magarrangaynji ngayawi-wuy.” Dani-yung ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Anubani-yumbaa wingi-waliyn anubagu, ngarra-Naomi ngi-waliyn ana-Moab-gala marri bagu ngu-waṉagaa ngarra-Ruth, ngarraagi a-Moab-jinyung, nga-rangan.ngarri-yung. Wingi-waliyn a-Bethlehem-duj. Aḏaba bagu wurru-wulguldhangi ana-maḏa, ana-barley. Wurru-wulguldhangi marri wurraarraaṉbini, wingi-wurrij-balu ngarrubirrngi. Marri warraa-bardhangi bagu warra-wurru-wurruj bagu wurru-wulguldhangi. ");
INSERT INTO nuy_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Boaz, na-nimuwaj-jung. Ngarra-Naomi naalgur-nyung nubagi-yung. Nimbalal marri ni-runggal, ni-yiwanggu. Marri nubagi-yung ni-ngawiiyn-jinyung naaṉngina-yung, nubagi na-waḻyinyung naalgur-nyung. Marri warruburru-yung wurru-wardhangi-yinyung nigawi-nyinyung, warruburru-yung wurru-maḏa-wulguldhangi a-maḏa a-barley a-marrya-yinyung. ");
INSERT INTO nuy_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Ngarra-Ruth ngi-yamayn, ngarra-Naomi ngu-magayn, “Warruburru aḏaba wirri-wulguldhii ana-maḏa, ana-barley, marri wurraalgaalgurmani. Yagu ngaya nimba-lharrgang ngaynjaarri, nganggarra-muṉḏugana ana-barley warruburru wurru-wardhii-rruj warra-waḻya-waḻya? Warruburru-yung wurraarra-garraarruna-yinyung anaarrgi aaban-baj nganggarra-mani yuga? Ngaynjaarri, marri warruburru-yung warra-waṉagana-yinyung, warra-wardhijgana-yinyung, warra-bu-buunggawa, ngamba-magana, ‘Ngambardhii,’ ngaynjamang, marri wugurraayung, ambu-yambang-maynji ‘Yii, yaagi ngagurru ngurru-wardhii,’ ambu-yambang-maynji, ngambardhii.” Dani-yung ngi-yamayn. “Yii,” ngigaayung ngi-yamayn ngarra-Naomi, “Yii, ngan.ngalhaa, ba-yaarri,” ngu-yamijgayn. ");
INSERT INTO nuy_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Nga ngi-yanggi aḏaba ngarra-Ruth wubani wurraanaanuynjungaa-wuy, ngi-yanggi. Bagu, warruburru-yung warra-waḻya-waḻya wurru-wulguldhangi ana-barley, marri adhaadharri warra-mulung-aynbaj wurru-miyn-gabaa. Warruburru-yung wurraarra-garraarru, marri ngigaayung ngi-mangi. Nga anubanila ngi-yanggi nubagi na-Boaz-guy wurraanaanuynjungaa-wuy. Yagu ngi-maḻaḻadi na-Boaz niga-waj niwu-waṉagaa-yinyung anaani waanaanuynjungaa-rruj. ");
INSERT INTO nuy_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Ngi-waḻirr-lhaay arrwar aḏaba ngarraagi-yung ngarraaḻirr, ngamugijgaj. Nga anubanila, nigaayung ni-yanggi Bethlehem-gala na-Boaz, nga ni-yanggi wubani wurraanuynjungaa-wuy. Nga warruburru wani-nayn nigawi-nyinyung wurru-wardhangi-yinyung. Wani-waradangi. “Na-Yawei ani-burraa nugurri-rruj,” ni-yamayn. Wugurraayung anaaḻagaḻa wunu-yambalmayn, “Nugaayung nubagi na-Yawei aniigajij-majgana,” wunu-yamijgayn wugurru. ");
INSERT INTO nuy_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Nga anubanila ngu-nayn ngarrubagi ngarra-maṉinyung. Nga nu-yandhawiwayn nubagi naa-mijgalmini-yinyung-guy, nubagi ni-ragaani-yinyung-guy, “Yangi-nyung ngarruwaagi ngarra-maṉinyung? Yanga-yangi ngiga warra-mijgalgur-yung?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Nigaayung ni-yamayn, “Ngarraagi ngarra-maṉinyung a-Moab-jinyung. Ngaadagu wingiinggarra-yanggi ngarra-Naomi, a-Moab-gala. ");
INSERT INTO nuy_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Nga ngaadagu ngangi-yamijgayn, ngangi-yandhawiwandi nurru, ‘Ngaambaanggarra-mani ngandhamarrii ngaayung adhaadharri,’ ngi-yamayn. Nga anubanila, ngiimbari-waj ngi-wardhangi, waari-waj angi-ḻan.gaḏangi. Ngi-wardhangi… yingga anaaji anaarrwar ngi-ḻan.gaḏii. Ngi-ruluj-gini a-ruluj-duj, ngi-burri a-ruluj-duj.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Nigaayung na-Boaz ni-yanggi aḏaba ngigawi-wuy ngarra-Ruth-guy, nga ngu-yamijgayn, ni-yamayn “Ngana-magana ambaḻaman lhaawu. Baawanggina-wugij. Yagi barraarru warraawurru warra-miyn.ngaḻaynji. Bamba-garrindharrmani, waari anaanila-wala yagi nuṉḏumi anuuguni, yaaju-wugij ba-wardhii. Marri anaani ngunu-yamijgana nugawi-wuy, yagi naaynbajung nuṉḏumi anubani anaaban-guy. Yaaju-wugij ba-wardhii. ");
INSERT INTO nuy_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Bamba-nayii warraawurru warra-waḻya-waḻya wurru-wulguldhii-yinyung. Ba-yaarri yuuguni, marri ba-warubaj-gana warra-miyn.ngaḻaynji, warruburru wurru-mani-yinyung, marri bamba-garrindharrmani. Ngarra-yamijgayn ngayawi-nyinyung warra-waḻya-waḻya, yagi nimbi-warragayijgi. Anubani anaa-gugu wirri-warryangi mana-gaṉdharra-wuy. Anubani-yung-maynji ba-wurrij-guldhii, ba-yaarri marri baaḻ-nguyii anubanila anaa-gugu.” Dani-yung ni-yamayn na-Boaz. ");
INSERT INTO nuy_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Marri ngarra-Ruth ngarrubagi-yung ngi-burrdi aaban-duj, ngi-waban-jarrdangi. Ngi-yamayn, “Ngaya waari ana-Israel-inyung, yagu nagang aadanu nimba-maṉmangi marri nimba-man.galagaa ngaya, aadanu nagang yiwanggu-nyung,” ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Nigaayung na-Boaz ni-yamayn, “Ngaya anaani ngaawanggini nagang nga-rangan.ngarraaj, nungu-maṉmangi arrawindi nungu-waṉagaa, anubani-yumbaa naaṉnginaaj ni-ngawiiyn. Nga-marrbuy nagang aadanu anubani-yung na-ninyarra marri nga-rriibi marri nugawi-nyinyung ana-lhal nunggaarru. Yagu warraawurru nu-maḻaḻadi nagang warra-wurru-wurruj, yagu wiiya, nagang nu-ngu-burraa nurri-rruj. ");
INSERT INTO nuy_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Nagang nunu-warriini arrawindi na-Yawei-wuy, na-God ana-Israel-inyung. Marri nuynjanggi na-Yawei-wuy ani-rangarrii yungguyung. Ngaya ngaaḻamin-jamana niga ari niniiyii anubani-yung nunggaarra-ngaynbandii-yinyung.” Dani-yung ni-yamayn na-Boaz. ");
INSERT INTO nuy_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Ngarra-Ruth ngunu-yambalmayn, “Nagang aadanu nu-man.galag-bindiyung ngayawi-wuy. Nagang nimbaa-jarini nga-ḏirrngawini-yinyung marri ngaambulangi-yinyung. Yagu nagang aadanu ana-lhaawu nagang wu-man.galag yamba. Nagang marri nugawi-nyinyung nimbii-ba-bardhii-yinyung, nurru-runggal-windiyung, yagu ngaya nga-winyig.” Dani-yung ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Ngarrubagi anaarrwar yingga ngarraaḻirr ngi-waḻirr-lhangayn, nga wurru-nguni ana-marrya. Nga ngi-burrangayn yuwaagu ngi-waḻgaḻ. Nga na-Boaz ngaa-gaḏiyn, “Baaṉiyn, ba-nguyii anaani ana-marrya. Ba-mang marri ba-lhalwulhii wugargayag-guy.” Bani-yung ni-yamayn. Nga ngi-jarrarriyn marri ngi-burrangayn warra-waḻya-waḻya-rruj, warruburru wurru-nguni-rruj. Nga anubani anu-ḏal wurru-nanga, wu-lharamaa a-ngura-rruj. Ni-miyn, ngu-yayn, nga ngi-nguni. Waari ana-baḏag aḏaba anubani ngi-waḻarrang. Anubani ngi-waḻarrang ngi-warra-garraarruyn, bagu wu-warra-muynmulhi arrawindi. Nga anubagu mulung-arrgi ngijang bagu wu-burri. Nga ngi-yanggi ngarraagi-yung ngarra-Ruth, aḏaba ngijang ngi-mangi a-marrya a-barley. ");
INSERT INTO nuy_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Nga nigaayung nubagi-yung wani-magayn warruburru-yung warra-waḻya-waḻya, “Ngarraagi yagi nirringa-lhambu angi-muṉḏugana-maynji aadanu wu-warra-muynmulhaa-waj anubani wurraarraabayii-yinyung wudanu ana-barley. Yagi nirringa-yamijgi ‘Yagi nunggaṉbi!’ yagi nirringa-yamijgi ngaadagu. ");
INSERT INTO nuy_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Numburraarra-ngarrgiwana anubani wurraarraabaa-wala, numburraarra-ngu-burrii yaajijila, nguynju yadhu wubani angi-warra-lhangarrmana, ngijang angi-mani. Yagi ana-wungarri-mirri nirringa-yambi.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Nga ngarra-Ruth ngi-muṉḏugaa-wugij ngijang, murrubu ngarraaḻirr aḏaba ngi-yabini. anu-ḏal wu-warra-yadangi-wugij bagu anubani anu-bal-uj, anubani ana-marrya, ana-barley. Anubani ngi-waḏangi rangag-mirri. Nga ngiwu-mangi anu-ḏal, ngiwu-yabaa. Anubani wu-mundurr-mayn, marang-aynjaabugij marri marang-aynjaabugij ana-kilogram. ");
INSERT INTO nuy_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Anubani ngi-warraagijgiyn ngarrubagi-yung nga-rangan.ngarri-yung-guy, nga ngu-bajiyini. “Yaani ngaya nga-manga-mangi,” ngu-yamijgiiyn ngarrubagi-yung nga-rangan.ngarri-yung. “Yaani nga-muṉḏugaa ana-yimbaj,” ngi-yamayn. Nga ngu-yayn anubani ana-marrya, anubani-yung ngiirruyn-jinyung, anubani ngi-nguni-yinyung nga ngiirruyn. Ngijang ngu-warra-yayn, ngarrubagi nga-rangan.ngarri-yung, marri ngi-warra-burrangi-yinyung angi-nguni yungguyung yingga. ");
INSERT INTO nuy_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","“Ajiga aadanu nu-manga-mangi anu-ḏal?” ngu-yamijgayn. “Waa-yangi-nyung-duj nagang wurraanuynjungaa-rruj, waa-yangi-nyung-duj nagang numba-wardhangi nagang aadanu, nunggaarra-muṉḏugaa,” ngu-yamijgayn. “Ngaya nganu-yandhawiwana na-God anu-maṉmani, nubagi na-waḻyinyung nini-rangarrangi-yinyung nagang.” Dani-yung ngi-yamayn. Nga ngigaayung ngi-yamayn ngarra-Ruth, “Nubagi niwu-waṉagana-yinyung anubani anaaban, Boaz na-nimuwaj-jung,” ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Ngigaayung ngarra-Naomi ngi-yamayn, “Na-Yawei anaagajij-majgana niga! Nubagi na-Yawei, ngarrani-man.galagana-wugij, ngagurru ngurru-wiri-yinyung marri warrubawi wu-ngawina-yinyung,” ngi-yamayn. Nga ngu-yamijgayn ngarra-Ruth, “Naadagu na-waḻyinyung naalgur-nyung nubagi ngayawi-nyinyung na-guḻgu. Niga-waj nambani-rangarrii nagawaa.” Dani-yung ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Ngigaayung ngarra-Ruth ngi-yamayn, “Dagi-yung ngani-yamijgaa na-yiwanggu-nyung, ‘Ba-burraa-wugij ngayawi-rruj ngambii-ba-bardhii-yinyung warubaj. Ba-yama-yamana ba-wardhii… nga anggu-warra-ngu-jadugiiyn ana-barley… marri ana-wheat, ngayawi-rruj waanuynjungina-rruj.’” Dani-yung ngu-yamijgaa ngarra-Ruth. ");
INSERT INTO nuy_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Ngigaayung ngarra-Naomi ngu-yamijgaa ngarra-Ruth, “Yii, ba-wardhii-wugij nubagi na-yiwanggu-nyung-duj, warruburru-rruj warra-miyn-ngaḻaynji nigawi-nyinyung. ba-yaarri-maynji anaaynbaj-guy, ari warraaynbaj nagang ambiimana, ba-yaarri-maynji anaaynbaj-guy.” Dani-yung ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Nga anubagala aḏaba ngarra-Ruth ngi-wardhangi-wugij bagu, warruburru-rruj warra-miyn.ngaḻaynji na-Boaz-jinyung. Barley ngi-muṉḏugaa… marri wheat anu-bal. Ngi-warra-muṉḏugaa, a-barley-yinyung marri a-wheat-jinyung ngi-warra-muṉḏugaa, murrubu wu-warra-ngu-jadugiiyn bagu. Marri ngarrubagi-yung ngarra-Ruth ngi-burri-wugij nga-rangan.ngarri-yung-duj anubani-yumbaa wurru-wardhangi anubani-rruj. ");
INSERT INTO nuy_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Anubani-wala, ngu-yamijgaa nga-Naomi ngarra-Ruth-guy, “Banu-waṉagana nagang naaṉnginaaj marri mijburrayung. Ba-wurrij-maaḻang. Aniiyn-mamaaḻang ngaya nganu-lhangarrmang, wa-dhangarrmang naaṉnginaaj. ");
INSERT INTO nuy_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Nagang numbardhangi warruburru warra-miyn.ngaḻaynji-rruj yigaj, na-Boaz-duj nigawi-nyinyung waanaanuynjungina-rruj. Naalgur-nyung ngayawi-nyinyung na-guḻgu naadagu. Baawanggina aḏaba,” nu-yamijgayn. “Nga yimbaj ana-miyn.ngu anudanu, anggu-lhanguyn-bayamani-maynji ana-wirrig, bagu warruburru warra-waḻya-waḻya wunaa-ba-bardhii-yinyung amburru-burraa wubani waanuynjungina-rruj. Amburru-buyana wudhanguyn-mirri, amburru-waṉbina. Arra-wuyana amburru-warrganjii anu-ḏal. Anggu-warra-wuyana yuuguni anu-dhabag. Na-Boaz bagu nigaayunggaj ani-burraa. ");
INSERT INTO nuy_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","“Nagang aadanu ba-ngambina marri bawu-burrang arrawuyn-mamaaḻang-jinyung, marri yaaḻi-mamaaḻang mana-yaaḻi ba-yabiyn. Ba-yaarri buguni, yagu yagi nuṉḏumi ana-warubaj. Yagi ni-marrbuy-mi nagang anubagu. Banu-lhaṉḏii na-Boaz ani-nguyii a-marrya, marri ani-waḻ-nguyii. ");
INSERT INTO nuy_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Banu-nayii ajiga-rruj anubani ani-murrgulhangang. Banu-nayii-wugij ani-yingang. Marri bani-yung, ba-yaarri nigawi-wuy. Niga ani-mun-gambamadhina yaaḻi-mirri, ni-mawuraadi yamba. Ba-yaarri nga bagu banu-mun-garrayang, bamaarrayang mana-yaaḻi nigawi-wala ana-mun, nga ba-murrgulhang bagu nigawi-rruj a-mun-duj. Niga ani-magang anubani-yung yangi baaṉbina.” Dani-yung ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Nga ngu-yambalmayn ngarra-Ruth, “Yii, danila-yung-galawaj nganggaṉbini, anubani nimba-magaa-yinyung,” ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Ngi-yanggi ngarra-Ruth wubani wurraarra-ngu-burraa-wuy ana-barley. Nga bagu wubanila-yung-galawaj ngu-yamijgaa ngarrubagi nga-rangan.ngarri-yung, wubanila-yung-galawaj ngi-waṉbini. ");
INSERT INTO nuy_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Na-Boaz aḏaba ni-ngunu-nguni marri ni-waḻ-nguni, nga ni-waḻarrang, ni-wurrij-gaḻaaḻarrangi naagi-yung. Anubani wu-muṉḏugini-rruj a-barley, nga bagu ni-yingayn aḏaba. Ngarra-Ruth aḏaba ngi-yanggi midaarrgaj. Nga ngunu-mun-garrayang, nga ngi-murrgulhi a-mun-baj. ");
INSERT INTO nuy_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Miyn.giyn.gurarra ni-marayanggiyn, nga ni-wiḻibiḻingiyn, nga bagu ngu-nayn, ngi-murrgulhi maṉinyung a-mun-duj! ");
INSERT INTO nuy_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","“Yangi-nyung nagang aadanu?” ngu-yandhawiwayn. “Ngaya anaani ngaya-waj Ruth, yiwanggu-nyung,” ngi-yamayn. “Numbaambamadhang, bama-jarrmayarrmijgang mana-mangudhig ama-yaaḻi. Nimba-rangarrii ngaya. Nagang yamba naalgurmaynji, nimba-rangarrii-yinyung.” Dani-yung ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Nigaayung ni-yamayn, “Maṉinyung, niga na-Yawei aniigajij-majgana nagang. Maaḻamburrg nagang nunggaṉbini ngarrubagi-wuy nga-rangan.ngarraaj-guy. Yagu nundaambaḻaman-bindiyung aḏaba, waari yamba banu-lhangarrmang wulmurrinyung, niimbalal yagu niimbalalari, naaṉnginaaj. ");
INSERT INTO nuy_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","“Nga yagi nu-ngu-ḏirrngawi. Warraarrawindi-lhangu wurru-marrbuy anaani ana-lhal, nundaambaḻaman nagang. Anubani nimba-yandhawiwaa-yinyung, ngaya nganggaṉbina, ngunu-rangarrii nagang. ");
INSERT INTO nuy_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Ngubindi, ngaya naalgurmaynji yagu naalgur-yung nubagi naaynbajung nubagi ni-ragaana-yinyung. Nganu-yandhawiwana wurrugu ana-wulhu-wulhurr. ");
INSERT INTO nuy_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Ba-burraa yaaji murrubu anggu-ḻaḻmang ana-ngamugijgaj. Ani-rangarrii-maynji, anubani ambaḻaman. Yagi-maynji nini-rangarri, ngaya anaani ngunu-lhalamayana, na-Yawei-maynji ani-wiri, ngaya wa-rangarrii nga waa-gaṉbina aniijiijung, anaarrawindi-lhangu. Ba-murrgulhaa-wugij, murrubu anggaa-ḻaḻmang ngamugijgaj.” Dani-yung ni-yamayn na-Boaz. ");
INSERT INTO nuy_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Bagu ngi-murrgulhi-wugij a-mun-duj, murrubu waa-ḻaḻmayn. Waari-waj ngarraaḻirr angi-waḻirr-ḻaḻagini, waangamudangi-waj, na-Boaz ni-ḻaḻagiiyn. Nga ni-yamayn, “Ba-yaarri, yagi yamba anaaji warra-wurruj yagi wurru-marrbuy-mi. ");
INSERT INTO nuy_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Bama-yarrijgiyn maadamu nuynjabina-yinyung marri bama-waṉagang yaaji.” Dani-yung ni-yamayn. Nga ngima-waṉagaa marri ngu-yayn, ngaa-ḏarrjangi 20 ana-kilogram, ngaa-ḏarrjangi-yinyung ana-barley. Ngi-warraabaabaa ama-yaaḻi-wuy. Ngu-maṉmangi, wini-ḻaḻagaa-yinyung nga ngi-waj-barrgaay aḏaba ngi-yanggi. ");
INSERT INTO nuy_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Ngi-yanggi nga-rangan.ngarri-yung-guy. “Nuynjaminggarrina, ngan.ngalhaa,” ngi-yamayn. Nga ngarrubagi ngarra-Ruth ngu-magaa yangi anubani ni-waṉbini na-Boaz ngigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Nga ngi-yamayn, “Ngani-warriini anaani ana-barley marri ngani-yamijgayn, ‘Yagi nu-mara-mamar-mi ngaadagi nga-rangan.ngarraj-guy. Anaani ana-barley ngunuuyii ba-waṉagana.’” Dani-yung ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Nga ngigaayung ngarra-Naomi ngi-yamayn, “Yagi wurrugu numbaaḻwaḻ-gi wurrugurrij-bugij. Wurrugu nu-marrbuy-mang anggiijaminggarrina. Yagi ni-yanga-yangi. Ambani-yambina, warruburru-wuy warra-waḻya-waḻya-wuy. Ambuu-yambiynjina wurrugu, ambirri-maṉdhii ana-lhaawu, anaani ana-yimbaj.” Dani-yung ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Na-Boaz ni-yanggi wubani wurru-muṉḏu-muṉḏugaa-rruj, wubani wurru-yanggi-yinyung wurru-yabini… wurru-rabalangi wurru-yaḻdhangi, nga niindhadhangayn bagu. Nga nubagi na-waḻyinyung ni-yanggi buguni, nubagi-yung ni-magini-yinyung ngarra-Ruth. Nga na-Boaz niiḏiyn, “Guwaj, baaṉiyn yaaji, baandhadhangang.” Nga ni-yanggi na-Boaz-duj nga-niindhadhangayn. ");
INSERT INTO nuy_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Nga wani-yandhawiwaa warruburru-yung na-Boaz marang-aynjaabugij, marang-aynjaabugij warruburru warra-mijiwanggu amburru-yambiynjini yungguyung bagu amburraambargalangi. Nga wurraambargaliyn aḏaba. ");
INSERT INTO nuy_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Nga nu-yamijgayn nubagi naalgur-nyung-guy, “Nagang nu-marrbuy ngarra-ngajiwanggu-nyung ngarra-Naomi ngiigiyn aḏaba anubani ana-lhal-wala ana-Moab. Nubagi yaga ngigawi-nyinyung naaṉngina-yung, nagawi-nyinyung na-murruyung, wubani-yunggaj-jinyung, niga niwu-waṉagaa anubani anaabaḻa. Ngiga ngarra-Naomi ambangiiyn anubani-yung, ambi-lhal-rangarrii yungguyung. ");
INSERT INTO nuy_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Ngaya anaani nga-wijangani, nagawaa naynjambina anaani-yung-jinyung. Bawu-ngaynbandang-maynji, bawu-mani anubani anaabaḻa. Warraawurru warra-mijiwanggu amburraawanggina, marri warraawurru warra-mulung-aynbaj wurraambargalii-yinyung amburraawanggina. Yagu yagi-maynji nunggu-ngaynbandi, nimba-yamijgang, marri warruburru amburraawanggina. Yagu ngaya-waj nganggu-mang, nagang wubani-yunggaj yamba nagang nuṉḏaga-ragij. Nagang-maynji ba-yamang, yagi ngawu-mi. Yagu yagi-maynji nunggu-ngaynbandi, ngaya-waj nganggu-mang.” Dani-yung ni-yamayn na-Boaz. Nigaayung na-waḻyinyung ni-yamayn, “Ngaya-waj ari nganggu-mani.” ");
INSERT INTO nuy_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Nigaayung na-Boaz ni-yamayn, “Bawu-mani-maynji nagang, yagu ngarra-Ruth a-Moab-jinyung, ngarrubagi-yung ngarra-ngayi-nyung, nugawi ngarrubagi, bangu-mang. Nguynju yadhu ambangi-yabana warra-mijburrayung nubagi-yung-jinyung ni-ngawiiyn-jinyung-jinyung, marri anubani anaabaḻa, ambirri-waṉagana warruburru warra-mijburrayung.” Dani-yung ni-yamayn, wiijamaa yamba anubani ana-lhaawu-runggal, anaani-rruj ana-Israel. ");
INSERT INTO nuy_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Nigaayung na-waḻyinyung nu-yambalmayn, “Yagi anubani ngaaṉbi, yijgubulu! Yagu ngaya-maynji nganggu-mang aadanu, ngayawi-nyinyung warra-mijburrayung yagi ambirri-mi aadanu anaabaḻa. Ngaya anaani ngunuuyii, nugawaj bawu-mani.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Anu…bani-yunggaj wiijamaa ana-Israel-uj, warrubawi-yung wu-yiynjini-yinyung abaḻa yagu anaaynba-gaynbaj-jinyung, nigawi-nyinyung ni-mun-jabini-yinyung nima-lhalharijgaa. Nga nubagi niwu-mangi-yinyung nuuni manubami-yung. Nga anubani yijgubulu-windiyung, nuuni anubani anaabaḻa. ");
INSERT INTO nuy_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Wudani-yung-gala, niga naagi-yung na-waḻyinyung na-yamijgaa na-Boaz, “Ngaya anaani ngunuuyii. Bawu-mani anubani anaaban,” ni-yamayn. Marri nima-lha-lharijgaa nigawi-nyinyung ni-munju-mun-jabini-yinyung, marri nu-yayn nubagi na-yiwanggu-nyung. ");
INSERT INTO nuy_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Nigaayung na-Boaz wani-yamijgaa, warruburru warra-mijiwanggu marri warraarrawindi warra-wurru-wurruj, “Nugurru-waj aadanu aḏaba, nurru-marrbuy, anaani nirri-nani-wala. Ngaarra-mangi ngarra-Naomi-wala naaṉnginaaj-jinyung, nga nigaayung-gala na-niwiyayung-biiyung. Ngarra-mangi aḏaba ngaya-waj anaani. Nugurru-waj nirri-nani-wala. ");
INSERT INTO nuy_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Marri ngarra-Ruth ana-Moab-jinyung, ngarra-ngayi-nyung na-Mahlon-jinyung, aḏaba ngiga ngayawi-nyinyung ngarra-guḻgu. Wudani-yung-gala nga, aani-yung-gala aḏaba, nigawi-nyinyung ana-muwaj anaanila-wala anggu-wandha-wuguuguni aani-rruj anggu-burraa a-lhal-uj, marri aani-rruj a-wumurrng. Nugurru-waj yamba nirri-nayii-wala, anaani ana-yimbaj.” Dani-yung ni-yamayn na-Boaz. ");
INSERT INTO nuy_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Nga warruburru warra-mijiwanggu marri warra-mulung-aynbaj wurru-yamayn, “Yii, nurru-waj anaani yamba ngunu-nani-wala. Nuunu-yandhawiwana na-Yawei, anggu-maṉmani ngiga, angi-yaarri-yinyung nugawi-wuy anaanga. Ngarra-Rachel marri ngarra-Leah, arrawindi mijburrayung waangi-yabaa, na-Jacob-jinyung. Yagu nurru nuunu-yandhawiwana na-Yawei, anguuyii ngigawi-wuy, ngarra-Ruth-guy, warra-mijburrayung ambuu-yamana. Nga wudani-yung yamba, ambi-runggal-wana yadhu warru-mandag-jinyung ana-Ephrath-jinyung. Nguynju yadhu warruburru-yung ana-Bethlehem-jinyung, amburru-yamana, ‘Warruburru warru-mandag nigawi-nyinyung na-Boaz-jinyung wurru-runggal.’ ");
INSERT INTO nuy_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Na-Yawei nambaniiyii arrawindi warra-mijburrayung, marri ngarraagi-yung ngarra-maṉinyung anguuyii. Nga anaani nuunu-yandhawiwana, nambarra-waṉagana warra-mijburrayung, marri amburru-runggal-mana. Nguynju warruburru-yung-jii warra-mijburrayung na-Perez-jinyung. Niga na-niwiyayung na-Judah-yinyung marri ngarra-Tamar-yinyung.” Dani-yung wurru-yamayn, warruburru-yung warra-mijiwanggu. ");
INSERT INTO nuy_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Anubanila-wala, ngu-yarrijgiyn ngarra-Ruth nigawi-wuy aanga, nigawi-nyinyung anubani nga-rangarrina-yung ngaadangi-yung. Nga-wini-yaay aḏaba. Niga na-Yawei ngu-yayn aḏaba ngi-dhulmumbudi. Nga wurrugu ngunu-yabayn wirrinyung. ");
INSERT INTO nuy_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Warruburru-yung warra-maṉaṉung wurru-yamayn ngarra-Naomi-wuy, “Nuunu-warraarriwana na-Yawei. Nagang yamba nini-yayn na-ranggambinyiyn ana-yimbaj, ani-rangarrii yungguyung. Anaani ana-yimbaj nuunu-yandhawiwana na-Yawei, warraarrawindi ana-Israel-inyung amburru-marrbuy naadagi-yung na-winyinyung, ani-runggal yamba. ");
INSERT INTO nuy_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Wurrugu marri, ba-ngajiwanggu-mang, yijbanu ani-maṉmani, ani-rangarrii, ba-waḏa-waḏaḏ. Nugawi-nyinyung nga-rangan.ngarraaj ningii-ḏamarr-ngu-burraa, nga nagang ningii-jabayn nugawi-nyinyung na-ranggambinyiyn. Nagang-magaa bamba-waṉagaa warra-marang-aynjaabugij marri na-wulawaa warra-miniwiyayung, yagi-magaa ambi-rangarrangi nagang nguynju ngarraagi nga-rangan.ngarraaj.” Dani-yung wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Ngarra-Naomi ngarrubagi ngunu-miyn nubagi-yung na-ranggambinyinga-yung, nga yaaji ngunu-waṉagaa warubaj ngigawi-rruj, nga ngunu-rangarrangi niga, ngunu-magaani. ");
INSERT INTO nuy_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Warruburru-yung warra-maṉaṉung wurru-burri-yinyung wirringa-warubaj-gaa-yinyung, wunu-mijgayn nubagi Obed, na-nimuwaj-jung. Nga wurru-yamaa, “Ngarra-Naomi yigaj ngunu-waṉagana ranggambinyinga-yung, nga nigawi-yii na-nimarayung-jii ni-yamana,” wurru-yamayn. Nubagi na-Obed, na-niwiyayung Jesse, nga nigaayung anubagala na-Jesse-wala niga, na-niwiyayung aḏaba David na-king. ");
INSERT INTO nuy_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","22","Nga anaani warrubawi-yung warru-mandag na-Perez-gala nga na-David-guy. Perez, Hezron Ram, Amminadab, Nahshon, Salmon, Boaz, Obed, Jesse marri David. ");
INSERT INTO nuy_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Na-Yawei nu-magaa na-Jonah-wuy nubagi na-niwiyayung na-Amittai-yinyung, ");
INSERT INTO nuy_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","Ni-yamayn “Ba-ḻaḻagiiyn, ba-yaarri Nineveh-wuy, anubani wu-runggal ana-lhal, marri bamba-magana ngamba-jadugang warruburru, yagu yamba wurraalaaladi warra-wurru-wurruj wugurru.” Dani-yung ni-yamayn na-God. ");
INSERT INTO nuy_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Yagu na-Jonah ni-yarramayn nigawi-wala na-Yawei-wala. Nga naagi-yung ni-yanggi Joppa-wuy, nga nima-lhangarrmayn barrawu, ama-yanggi yungguyung arrgaḻinyi a-Spain-guy. Marri naagi-yung nu-yayn wuṉuga nubagi-wuy nima-waṉagaa-yinyung na-waḻyinyung mana-barrawu. Wurru-wayamangi… nga naagi-yung niga ni-yarramayn na-Yawei-wala. Nga naagi-yung na-Jonah ni-yabiyn ama-mangugara-rruj ama-barrawu nga ni-yingayn niga. ");
INSERT INTO nuy_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Anubanila-wala, na-Yawei niwu-lharrgang wuwalulu runggal. Manaama mana-barrawu lhaalhag yungguyung ama-ḻaḻmaa. ");
INSERT INTO nuy_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Wugurraayung warruburru-yung wurraanggarra-yanggi-yinyung warra-waḻya-waḻya, warruburru-yung wurru-ḏirrngawiiyn-bindiyung, nga wugurru wurraaḏangi wugurri-nyinyung-guy anaarrawindi ana-god, “Nimba-maṉmang!” wurru-yamayn. Yagu waari ambanggu-maṉmangi. Marri warraawurru-yung wurraarra-yarraani anaarrawindi-lhangu wurraarra-ngu-burrangi-yinyung, mana-barrawu-wala. Nga nigaayung na-Jonah ni-yaay-wugij niga. ");
INSERT INTO nuy_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Nigaayung nubagi-yung nima-waṉagaa-yinyung mana-barrawu ni-yanggi nigawi-wuy na-Jonah-wuy, nu-nayn, nga ni-yamayn, “A-yangi yungguyung nagang aadanu nuynjara-yara-wugij? Ba-ḻaḻagiiyn marri ba-yambina nugawi-wuy ana-god, nga ngaambanggu-maṉmani yungguyung wugurru. Ari ngaambanggu-warrngayang. Baaṉiyn, ba-ḻaḻagiiyn!” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Nga warruburru-yung wurraanggarra-yanggi-yinyung mana-barrawu-wuy, wurru-yamayn aḏaba, “Ngaambu-wayigina, yangi-nyung warrubawi-yung wu-waṉbini anaaladi, nga anaani ana-wuwalulu wu-waṉiyn,” wurru-yamayn. Nga nubagi-yung nima-waṉagaa-yinyung mana-barrawu ni-yamayn, “Anaani ana-rangag wu-jarrmayarrmaj-bugij nga aynjaabugij ana-dhamun.gurrg. Anaani anaaynjaaynjaabugij-gaj ngaanggu-ngarrgiwumana ana-rangag, nga nubagi-yung-maynji aniwu-mang ana-dhamun.gurrg, bagi-yung nga ni-waṉbini-yinyung anaaladi.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Nga anubani ana-rangag wirri-mangi, nga na-Jonah niwu-miyn anubani dhamun.gurrg. Wugurraayung wurru-yamayn, “Nugawaj danu ngunu-lhajbang, anaani ana-wuwalulu wu-waṉiyn. Ajigala-yinyung nagang ana-lhal aadanu nuynjanggi?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Nigaayung ni-yamayn “Ngaya anaani a-Hebrew-yinyung. Ngaya nganu-warraarriwana na-Yawei, na-God niwu-maṉdhangi-yinyung ana-wumala marri ana-lhal marri mana-lhagayag.” Dani-yung ni-yamayn niga. Marri wani-magaa bagu ni-yarramayn-jinyung na-Yawei-wala. ");
INSERT INTO nuy_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Wugurraayung warraawurru-yung wurraanggarra-yanggi-yinyung wurru-ḏirrngawiiyn-bindiyung, nga wurru-yamayn, “Aadanu aladi nunggaaṉbini!” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Anubani ana-wuwalulu wu-lhanguyn-ngarrgiyn aḏaba wu-runggal. Warraawurru-yung wunu-yamijgayn, “Nurru wa-yaminggarrijgang, anggu-muḏaḏbang yungguyung ana-wuwalulu?” wurru-yamayn wugurru. ");
INSERT INTO nuy_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Nigaayung na-Jonah ni-yamayn, “Ngirri-barawudang ama-lhagayag-guy, marri anggu-muḏaḏbang yungguyung ana-wuwalulu. Anaani wu-waṉiyn, ngaya-waj yamba anaani ngaaṉbini aladi.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Yagu warraawurru-yung wurru-wurrij-galadi-wiiyn. Waari ambunu-barawudangi mana-lhagayag-guy. Warraawurru-yung yamba yingga wurraan-jamaa, ambunu-barawudangi-magaa niga, ari na-God ambani-lhajbini wugurru. Wudani-yung-gala, angudu wurru-madhandhangi anu-ngarrg-guy, mana-barrawu-mirri. Yagu waari ambirrima-yarrijgini anu-ngarrg-guy, wurru-madhandhangi-wugij angaḏajung. Yagu ana-wuwalulu wu-ngarrgiyn-bindiyung, angudu-windiyung wugurru. Waari amburru-walangi anu-ngarrg-duj. ");
INSERT INTO nuy_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Anaani wurru-ḏirrngawini-windiyung warraawurru-yung, nga malgadhaadharri wuu-lhayn-janga-yangini, ambunu-barawudangi yungguyung na-Jonah ama-lhagayag-guy. Nga warraawurru-yung wurraaḏangi na-Yawei-wuy. Wurru-yamayn “Yawei, yagi nimba-lhajbu nurru anaani, naagi-yinyung na-mamanunggu-yung na-waḻyinyung, yagu nurru-waj nimba-ngawijgang. Nu-marrbuy anaani, nugawaj yamba nunggu-ngaynbandii.” Dani-yung wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Nga na-Jonah wunu-miyn, nga wunu-barawudiyn ama-lhagayag-guy. Nga mana-lhagayag ma-muḏaḏbiyn magurru, nga ana-wuwalulu, wu-muḏaḏbiyn wugurraayunggaj. ");
INSERT INTO nuy_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Nga warraawurru-yung wurru-ḏirrngawiiyn, wunu-yamayn na-Yawei niga. Anubanila-wala, warraawurru-yung wunuuni wujiigurung na-Yawei-wuy, marri wunu-warraarriwaa niga, marri wunu-lhalamayaa ambunu-warraarriwana yungguyung niga. ");
INSERT INTO nuy_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Nga na-Yawei ni-lharrgang ngujija runggal-windiyung. Marri ninggu-lharrgang na-Jonah, yagu ni-wiri-wugij niga. Anubanila ni-burri ana-lhirribala a-ngujija-rruj ngi-wulaynbaj ngarraaḻirr marri mana-miyn.nganga. ");
INSERT INTO nuy_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Naagi-yung na-Jonah ni-bu-burri ana-lhirribala a-ngujija-rruj. Marri ni-yambini na-Yawei-wuy na-God. Ni-yamaa, ");
INSERT INTO nuy_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","“Nga-wurrij-galadi-wiiyn anaani Yawei, marri ngaaḏangi nugawi-wuy. Marri nimba-yaynjangani ngaya, amaar-lhirribala-wala a-lhal wubani-rruj wu-ngawina-yinyung, ngaya ngaaḏangi ‘Nimba-maṉmang!’ marri nagang nimba-yaynjangani ngaya. ");
INSERT INTO nuy_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Nugawaj numba-barawudiyn amaar-lhirribala-wuy. Nga lhirribala ama-lhagayag-duj, nga mana-lhagayag ngamaambamadhiyn ngaya, nugawi-nyinyung maar-waladhaa ma-wadbarrini, marri ngamaambamadhiyn ngaya. ");
INSERT INTO nuy_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Ngaya yingga ngaan-jamayn, nimba-barawudiyn nugawi-wala, nga yagi ngawu-ni nugawi-nyinyung ana-maṉngulg ana-wumurrng ngijang, anubani-rruj ngayawi-nyinyung ana-lhal. ");
INSERT INTO nuy_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Mana-lhagayag ngamaambamadhiyn, nga ngama-yingalandi ngaya. Mana-lhagayag ngamaambamadhiyn-bindiyung, nga mana-mungulu ngama-yinag-gabaabaa. ");
INSERT INTO nuy_vpl VALUES ("JH2_6","033_2_6","JON","2","6","7","Ngaya nga-dhirridiyn ama-mangujang-guy ama-ṉuga, wubani-yung a-lhal wudhawang wu-dhidina-yinyung wuguuguni. Ngaya anaani ngaaḻamin-jamaa, ana-wiri anggu-jadugini, yagu Yawei, ngayawi-nyinyung na-God, ngaya nga-yambiyn nugawi-wuy, marri nagang Yawei, nimba-yaynjangani ngaya, nugawi-wala a-maṉngulg-gala a-wumurrng. Marri nagang nimba-wiri-gayn ngaya. ");
INSERT INTO nuy_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Wugurraayung warruburru-yung wurru-maṉdhangi-yinyung ana-rangag marri aynba-gaynbaj-jinyung wurru-warraarriwana-yinyung, waari ambi-ngaynbandang nagang. ");
INSERT INTO nuy_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Yagu ngaya-waj nga-mayana warraarriwana nugawi-wuy, ngaya wiiyn wujiigurung nga ngunu-lhalamayana. Yawei, nagang nimba-wiri-gana-yinyung nurru anaani.” Dani-yung ni-yamaa na-Jonah, ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Anubanila-wala, na-Yawei ni-yamijgayn ana-ngujija, nga ninggu-lhagaliyn na-Jonah ama-madhaḻag-duj. ");
INSERT INTO nuy_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Anubanila-wala, na-Yawei nu-yamijgayn ngijang na-Jonah. ");
INSERT INTO nuy_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","Ni-yamayn, “Ba-ḻaḻagiiyn, ba-yaarri Nineveh-wuy, anubani wu-runggal ana-lhal, marri bamba-magana warruburru-yung warra-wurru-wurruj ngayawi-nyinyung ana-lhaawu, ngaya ngunu-yayn-jinyung.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Nigaayung na-Jonah nu-yandhurrbang na-Yawei. Nga ni-yanggi Nineveh-wuy. Ana-Nineveh wu-lhal-lhabarrj yamba ana-lhal, warrubawi-yung-maynji ambu-yaarri anubani-wuy ana-lhal, ngi-wulaynbaj ngarraaḻirr ambu-walang ana-wagagala. Warruburru-yung wurru-burri warraarrawindi-rruj warra-wurru-wurruj. ");
INSERT INTO nuy_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Ana-wulhu-wulhurr, naagi-yung na-Jonah ni-yanggi ngarrubagi-rruj ngarraaḻirr aynjaabugij. Nga bagu, wani-magaa aḻagaḻa. Ni-yamayn, “Ni-wulawaa-wala na-ḻabama, nambani-jadugang aadanu na-God!” Dani-yung ni-yamayn na-Jonah, wani-magaa warruburru-yung. ");
INSERT INTO nuy_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Wugurraayung warra-wurru-wurruj ana-Nineveh-yinyung, wurru-jambarrgiiyn na-God-jinyung ana-lhaawu. Nga wurru-ramarr-yanga-yangini warraarrawindi-lhangu, waari amburru-nguni. Wurru-yabini yaaḻi-walaaladi, warraarrawindi-lhangu warra-wurru-wurruj warru-mandag, wirriij-barrngayuyn-bindiyung wugurru. Warraawurru-yung, wurraaṉbaaṉbini mirraadhu alaaladi. ");
INSERT INTO nuy_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Anubanila-wala, nubagi-yung ni-ragaani-yinyung na-runggal-yung ana-Nineveh-yinyung, niga ni-wawanggiyn ana-lhaawu. Nga ni-ḻaḻagiiyn nigawi-wala a-throne-gala nga nima-ngarrgiwayn nigawi-nyinyung mana-yaaḻi ma-mamanunggu, marri nima-miyn yaaḻi-walaaladi. Nga ni-burrangayn a-lhagabuṉuḻg-duj. ");
INSERT INTO nuy_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Anubanila-wala, naagi-yung niwu-lharrgang ana-lhaawu, warruburru-wuy ana-Nineveh wurru-ngarra-ngu-burri-yinyung. Anaani ana-lhaawu wu-yamayn, “Anaani ana-lhaawu ngayawi-wala, nga-ragaana-yinyung marri ngayawi-nyinyung ngambii-mijgalmina-yinyung. Yagi nugurru nurru-ngi ana-marrya marri anaaynba-gaynbaj-jinyung. Yagi nurru-ngi marri yagi nurraaḻ-ngi, nugurru warra-wurru-wurruj marri ana-mun-bulal-wulal-inyung warraaynjaaynjaabugij-gaj. ");
INSERT INTO nuy_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Nugurru numburru-yabina yaaḻi-walaaladi-yinyung, aḏaba nugurru marri anubani wu-mun-bulal-wulal-inyung, wugurraayunggaj anggu-yabina. “Nugurru warraarrawindi-lhangu numbunu-yambina-windiyung na-God-guy, marri nimbirriij-garruyn anubani anaaladi nurru-waṉbini-yinyung nugurru. ");
INSERT INTO nuy_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Ari na-God ani-ramarr-yanga-yangina, marri yagi ngarrani-wurrij-bi nga yagi ngarrani-ngawijgi niga.” Dani-yung wu-yamayn ana-lhaawu, nubagila-wala na-runggal-yung-gala. ");
INSERT INTO nuy_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Anubanila-wala, niga na-God wani-nayn anubani-yung wurru-waṉbini-yinyung wugurru. Wani-nayn anubani-yung anaaladi-yinyung wirriirruyn. Nga niga ni-ramarr-yanga-yangini, waari ambani-jadugaa warruburru-yung, anubani yaga ni-yambini mirraadhungu. ");
INSERT INTO nuy_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Nigaayung nubagi-yung na-Jonah ni-wurrij-galadi-wiiyn-bindiyung, marri ni-riyaldhiyn. ");
INSERT INTO nuy_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Niga ni-yambini na-Yawei-wuy, “Yawei, ngaya nga-marrbuy-wugij nagang barraa-ḏamarr-ngu-burraa, marri barra-man.galagana, yagu nagang barra-rangarrii marri numbuguuguni barra-man.galagana, yagu nu-man.galag yamba ngijang nuṉḏamarr-yanga-yangina, yagi barra-jadugi. Yuu, ngaya nga-marrbuy aadanu. Anubani-yunggaj, nga-burri-waj ngayawi-nyinyung-duj a-lhal, ngaya nga-marrbuy. Bani-yung marri, nagang numba-yamijgayn anubagala nga-yanggi yungguyung. Ngaya nga-wurrij-galadi-wiiyn, ngaya yamba nga-marrbuy yagi barra-jadugi warruburru-yung warra-wurru-wurruj. Yuu, ngaya nga-marrbuy anaani, marri ngunu-magaa nagang. Wudani-yung-gala, nga-yarramayn a-Spain-guy. ");
INSERT INTO nuy_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Nga Yawei, aḏaba nimba-lharrgang, nga-ngawang, anaani yij-mamaaḻang, nga-ngawang anaani.” Dani-yung ni-yamaa na-Jonah niga. ");
INSERT INTO nuy_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Nigaayung na-Yawei nu-yambalmayn, ni-yamayn “Nagang yagi nuṉḏiyaldhi, waari anggiij-maṉdhiiyn wugurru aadanu.” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Nigaayung na-Jonah ni-yangga-yanggi yuuguni ramali-waj, ramali wubani a-runggal a-lhal, nga ni-burrangayn. Nga niwu-maṉdhangi ruluj, nga ni-burrangayn bani, ni-ruluj-giyn yungguyung. Bani bagu ni-bu-burri… nga ni-warranggayn, anggu-yaminggarrini ana-Nineveh, aniwu-jadugaa yungguyung na-God. ");
INSERT INTO nuy_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Nigaayung na-Yawei na-God ni-maṉdhangi wubal, wugurru wu-warradangi, nga na-Jonah ni-burri bagu, ninggu-ruluj-gaa. Nga naagi-yung ni-wurrij-maṉdhiyn-bindiyung, wubani-yung-gala a-wubal. Anubagu ni-yaay. ");
INSERT INTO nuy_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Ngarraaynbaj-duj ngarraaḻirr, ngi-waḻirr-wadadiyn. Nga na-God nima-yamijgayn mana-ngaḏan. Manubani-yung nguni anu-bal, marri wu-ngawiiyn. ");
INSERT INTO nuy_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Ngarrubagi ngarraaḻirr ngi-waḻirr-adadiyn arrwar. Nga na-God niwu-lharrgang wudhanguyn, wu-lhanguyn-murrmbu-murrmbuluj, wu-lhanguyn-ḏamalila wugurru. Naagi-yung na-Jonah ni-warra-nagini. Nga niwu-ngaynbandangi ani-ngawini niga. Ni-yamayn, “Anaani wiij-maṉdhina, ngaya nga-ngawang,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Yagu nigaayung na-God ni-yamayn, “Nagang yagi nuṉḏiyaldhi anaani-yung-jinyung anu-bal, waari anggiij-maṉdhiiyn wugurru,” ni-yamayn. Nigaayung na-Jonah ni-yamayn, “Yii, ngaya wiij-maṉdhina nga-riyaldhii, marri nga-ngawang,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Nigaayung na-Yawei nu-yamijgayn, “Anaani anu-bal wu-wal-lhangaḏbiyn ngijang aynjaabugij mana-miyn.nganga ngijang amaaynbaj-duj wu-ngawiiyn. Nagang waari baanuynjungaa marri baarradijgaa, nga yigaj nagang numburrij-galadi-wiiyn anaani-yinyung. ");
INSERT INTO nuy_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Yagu anaani nga-wurrij-galadi-wina ngaayunggaj, warruburru-yung-jinyung warra-wurru-wurruj ana-Nineveh-yinyung, ngijang warraarrawindi-lhangu warraambaḻaman-jinyung warra-mijburrayung marri wugurraayunggaj, anaarrawindi-lhangu wu-mun-bulal-wulal-inyung. Yii, ngaya nga-wurrij-galadi-wina, anubani yungguyung ana-Nineveh.” Dani-yung ni-yamayn na-God. ");
INSERT INTO nuy_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Anaani ana-lhaawu wu-magina na-Jesus-Christ-inyung marri nigawi-nyinyung warra-mijgalgur-yung. Niga warru-mandag na-David-jinyung na-king, wubani-yunggaj-jinyung, nga warru-mandag na-Abraham-jinyung wu…bani-yunggaj-jinyung. ");
INSERT INTO nuy_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Nga na-Abraham-gala nga na-David-guy, anaani na-Jesus-inyung warru-mandag. Abraham, Isaac, Jacob, Judah nga nigawi-nyinyung warra-minilharri-yung. ");
INSERT INTO nuy_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Naagi na-Judah, wani-lhamaa wini-wulawaa, na-nimuwaj-baa Perez marri Zerah. Wuguṉi-nyinyung nga-rriibi-yung ngarra-ngarrimuwaj-jung Tamar. Hezron, Ram, ");
INSERT INTO nuy_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Amminadab, Nahshon, Salmon, ");
INSERT INTO nuy_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Boaz, nigawi-nyinyung nga-rriibi-yung Rahab, Obed, nigawi-nyinyung nga-rriibi-yung Ruth, Jesse, ");
INSERT INTO nuy_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","na-David na-king. Nigawi-nyinyung warru-mandag naadagu. Na-David-gala nga-Jehoiachin-guy, yaawurru warru-mandag wurru-mij-garrarrina. Na-David, Solomon, nigawi-nyinyung nga-rriibi-yung ngigawi-nyinyung naaṉngina-yung Uriah anubani-yunggaj. ");
INSERT INTO nuy_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Rehoboam, Abijah, Asa, ");
INSERT INTO nuy_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Jehoshaphat, Joram, Uzziah, ");
INSERT INTO nuy_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Jotham, Ahaz, Hezekiah, ");
INSERT INTO nuy_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Manasseh, Amon, Josiah, ");
INSERT INTO nuy_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jehoiachin marri nigawi-nyinyung warra-minilharri-yung. Anubagala warruburru-yung-gala warru-mandag banila nga, warruburru wurru-wiynji-wiynjini-yinyung warra-mulung-jarina warru-mulung warru-mandag, a-Babylon-guy. ");
INSERT INTO nuy_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Wurru-yanggi-wala a-Babylon-guy, na-Jehoiachin-gala nga na-Joseph-guy. Jehoiachin, Shealtiel, Zerubbabel, ");
INSERT INTO nuy_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Abiud, Eliakim, Azor, ");
INSERT INTO nuy_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Zadok, Achim, Eliud, ");
INSERT INTO nuy_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eleazar, Matthan, Jacob, ");
INSERT INTO nuy_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Joseph. Naagi-yung ngarra-Mary-yinyung naaṉngina-yung, nga ngarraagi-yung na-Jesus nigawi-nyinyung nga-rriibi-yung. Naagi-yung na-Jesus wunu-mayana Messiah, na-God-jinyung ni-wajbarini-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Warruburru-yung na-Abraham-gala nga na-David-guy, warra-14 warru-mandag. Nga na-David-gala, warruburru-yung warra-14. Banila nga, wurru-yanggi ana-Babylon-guy. Anubanila-wala, warruburru-yung warru-mandag warra-14 warru-mandag. Wubanila-wala, bani-yung nga, na-Jesus niimbuḻwiyn, warruburrala-wala. ");
INSERT INTO nuy_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yaani aḏaba yigaj wu-waṉbini, nga na-Jesus niimbuḻwiyn. Ngarra-Mary nga-rriibi-yung, ngi-lhalamayini na-Joseph. Waari aniiynji-yaay-waj ngarra-Mary, ni-marrbuy-mayn wangi-waṉagaa gujuju. Ni-maḻaḻadi niga na-Joseph, anubani Maṉngulg Mawurr wu-waṉbini ngarra-Mary-rruj marri ngunu-waṉagaa na-wirrinyung ana-lhirribala. ");
INSERT INTO nuy_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Naagi na-Joseph niimbaḻaman-bindiyung. Marri waari ambani-ngaynbandangi warruburru warra-wurru-wurruj amburru-marrbuy-maa warrubawi-yung warra-gujuju wangi-waṉagaa ngarraagi-yung ngarra-Mary. Wudani-yung-gala, niimbaḻaman-gala, ni-yamayn, “Ngangu-lharrgang aḏaba, angi-yaarri, nga waari ngarra-magi warra-wurruj,” ni-yamayn niga. ");
INSERT INTO nuy_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Dani-yung naagi-yung ni-wijangani. Yagu anubani ana-angel na-Buunggawa-yinyung wu-yanggi aḏaba miyn.ngu nigawi-wuy, ni-wuryarrangi. Nga wu-yamayn, “Joseph, na-David-jinyung, yagi nu-ngu-ḏirrngawi. Bangu-mang ngarra-Mary nugawi-nyinyung nga-rangarrinaaj, nga nimbini-yara. Ana-Maṉngulg Mawurr nginggu-yayn waadawu warra-gujuju. ");
INSERT INTO nuy_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ngiga angunu-yabang wirrinyung, nga naagi na-wirrinyung banu-mijgiyn Jesus, wani-wiri-gana-yinyung, niga yamba ambani-wiri-gana nigawi-nyinyung warra-wurru-wurruj wugurri-nyinyung-gala aniij-galaaladi.” Dani-yung wu-yamayn ana-angel. ");
INSERT INTO nuy_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Anaani anaarrawindi-lhangu wu-waṉbini, wiij-gandhurrg-mayn anaani ana-lhaawu. Wu…bani-yunggaj, nubagi naa-ja-jambini-yinyung naa-jambini na-Buunggawa. Ni-yamayn, ");
INSERT INTO nuy_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ngarraagi ngaḻaynjinyung angunu-yabang wirrinyung, nga nubagi ambunu-mijgiyn na-nimuwaj-jung Emmanuel.” Aadanu wiijamana, nguynju na-God ngagurri-rruj. ");
INSERT INTO nuy_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Na-Joseph ni-marayanggiyn nga wubani-yung-galawaj ana-angel ninggu-magaa, wubani-yung-galawaj ni-waṉbini. Ngu-miyn ngarra-Mary nga-rangarrina-yung. ");
INSERT INTO nuy_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Yagu waari angu-wiḻdhangi ngarraagi-yung. Wurrugu ngunu-yabayn ngigawi-nyinyung na-ni-marayung. Nga nubagi na-Joseph nu-mijgayn nigawi na-nimuwaj-jung Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Na-Jesus niimbuḻwiyn a-Bethlehem-duj a-Judea-rruj. Anubani-yumbaa Herod ni-burri anubagu, wani-narrangi anubani-yinyung ana-lhal. Anubani-yumbaa niimbuḻwiyn na-Jesus, warruburru-yung warra-runggu-runggal-inyung wurru-yanggi juju…j ramalila, wurru-yanggi Jerusalem-guy. ");
INSERT INTO nuy_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nga warra-yandhawiwaa, “Ajiga naagi na-gadhuwi-nyung na-wirrinyung, nubagi-yung na-Runggal-yung warra-Jew-yinyung? Anaani nirringa-nani miyiri ngi-ḻaḻagini, nurru-burri-waj nurri-nyinyung-duj a lhal, ramalila. Nga nurru-yanggi ngaanu-warraarriwana yungguyung,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nga na-Herod nubagi-yung ni-wawanggiyn, nga ni-ramarr-ruwi-ruwiyn, nga warruburru-yung warraarrawindi ana-Jerusalem-jinyung, wugurraayunggaj. ");
INSERT INTO nuy_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nga wani-warraa-gaḏiyn warra-runggu-runggal warra-priest marri warruburru-yung warra-yiyini-yinyung ana-lhaawu-runggal. Wurru-muṉḏugaa, nga wani-yandhawiwaa bagu, “Ajiga yuga na-Messiah aniimbuḻwiyn?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nga wurru-yamayn wugurraayung, “A-Bethlehem-duj a-Judea-rruj aniimbuḻwiyn. Yagu yamba nubagi-yung na-ja-jambini-yinyung na-God, ni-warrarrangi ana-lhaawu anu…bani-yunggaj, na-God ni-yamayn, ");
INSERT INTO nuy_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Anubani ana-wumurrng ana-Bethlehem, ana-lhal-inyung ana-Judah, waari anggu-wirrig-magaa, wugurru wu-runggal aadanu ana-Judah-rruj. Yagu yamba aynjaabu-nyung niga ambani-narrii ngayawi-nyinyung warra-wurru-wurruj warra-Israel. Nga naadagi-yung nubagi ni-ragaana-yinyung, nigawi-nyinyung ana-lhal, bani-yung nga ana-Bethlehem,’ wu-yamayn ana-lhaawu.” Dani-yung wurru-yamayn, warra-priest marri warra-yiyini-yinyung ana-lhaawu-runggal wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nga na-Herod midaarrgaj warruburru warra-mulung-aynbaj warra-runggu-runggal-inyung wanii-gaḏangi nigawi-wuy. Ni-yamayn, “Lhal-ngargu ngarra-miyiri ngi-ḻaḻagini?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","“Numburru-yaarri nga numbunaagalhaga-lharrmani nubagi na-gujuju-nyung. Numbunu-lhangarrmang, nga numburraagiyn nga ngirri-magana ngayawi-wuy, nguynju yadhu ngaayung ngaynjaarri nga nganu-warraarriwana ngaayunggaj,” ni-yamayn niga, wani-lharrgang a-Bethlehem-guy wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Wugurraayung warraawurru-yung wurru-yanggi aḏaba. Wirringa-nani ngarrubagi ngarra-miyiri, aḏaba raga-ragij ngi-yanggi, wangii-ḏagaani ngarraagi-yung ngarra-miyiri, nga ngi-yanggi. Nga bagu arrwar ngi-lhaay nubagi na-wirrinyung-duj ni-burri. ");
INSERT INTO nuy_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Warruburru wirringa-nani ngarra-miyiri, marri wurru-ḏinggini marri wurru-wurrij-gaḻaaḻarrangi. ");
INSERT INTO nuy_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nga wurru-ngarra-jabiyn wubani-rruj a-wumurrng, nga wirringa-nani nga-rriibi-yung marri na-winyinyung. Nga wurru-ḻandharrdhangayn, wunu-warraarriwaa. Nga wirri-gara-wawaḻijgayn wugurri-nyinyung ana-baadhi, nga wunu-yayn anujiigurung, gold marri frankincense, arrawuj-mamaaḻang-jinyung, a-wunguban-jii, marri myrrh, arrawuj-mamaaḻang-jinyung. ");
INSERT INTO nuy_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nga anubanila-wala, wurru-yaay, wurru-wuryarrangi. Nga na-God wani-magaa warruburru-yung, “Yagi nurraagi marri nuunu-yambi na-Herod,” ni-yamayn. Wubanila-wala aḏaba amaaynbaj-baj amaadi wurru-yanggi, wugurri-nyinyung-guy ana-lhal. ");
INSERT INTO nuy_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wurru-yanggi-wala warruburru-yung warra-runggu-runggal, warraa-janggi-wala, ana-angel na-Buunggawa-yinyung wu-yanggi aḏaba nga bagu na-Joseph-duj. Ni-yaay, ni-wuryarrangi aḏaba naagi-yung. Nga wu-yamayn, “Ba-ḻaḻagiiyn, marri numburru-yarramang yuuguni Egypt-guy, nagang marri na-wirrinyung marri nga-rriibi-yung. Numburru-burraa bagu nga wurrugu wa-yamijgang nagang, marri numburraagiyn anubagala ngijang. Yagu yamba na-Herod naagi anaagalhaga-lharrmani, anuumana yungguyung,” wu-yamayn ana-angel. ");
INSERT INTO nuy_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Na-Joseph ni-ḻaḻagiiyn marri nu-miyn na-wirrinyung marri nga-rriibi-yung, nga wurru-yarramayn aḏaba Egypt-guy miyn.ngu. ");
INSERT INTO nuy_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Wurru-burri bagu. Wurrugu na-Herod ni-ngawiiyn niga. Anaani ana-lhaawu wiij-gandhurrg-mayn, nubagi-yung-jinyung naa-ja-jambini-yinyung na-God anu…bani-yunggaj. Na-God ni-yamayn, (Hosea 11:1) “Egypt-gala ngaya nganaa-gaḏiyn ngayawi na-nigi,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ana-wulhu-wulhurr, anubani-yumbaa warruburru warra-runggu-runggal wurru-yanggi, naagi-yung na-Herod ni-marrbuy wunu-dhaayurrangi. Nga ni-riyaldhiyn-bindiyung. Nga warraawurru-yung wani-lharrgang wurru-wiynji-wiynjini-yinyung nigawi-nyinyung. Wurru-yanggi a-Bethlehem-guy, marri warra-wini warra-mijburrayung warra-waḻya-waḻya, wurru-burri-yinyung anubagu marri ana-lhal wu-ridiynjini-yinyung-duj. Warruburru-yung warra-mijburrayung manaarmag amaaynjaabugij yagu ama-wulawaa. Yagu yamba warruburru-yung warra-runggu-runggal-inyung wurru-magini ana-wulhu-wulhurr, “Ma-wulawaa manaarmag ngarraagi-yung ngarra-miyiri ngi-ḻaḻagini,” wurru-yamaa, wurru-magini. ");
INSERT INTO nuy_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Anaani ana-lhaawu wiij-gandhurrg-mayn, nubagi-yung-jinyung naa-ja-jambini-yinyung na-God, na-nimuwaj-jung Jeremiah. Na-God ni-yamaa, ");
INSERT INTO nuy_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ana-Ramah-rruj wurraawanggiyn yang, wurru-ruguni marri wurru-nyadangi, wurru-wurrij-galadi-wini-windiyung. Ngarra-Rachel ngi-ruguni ngigawi-nyinyung warra-mijburrayung yungguyung. Nga yagi ngi-muḏaḏbi, yagi ngi-wurrij-maṉdhi ngiga, yagu yamba warruburru-yung wurru-jadugiiyn aḏaba.” Dani-yung ni-yamayn na-Jeremiah, anaani ana-lhaawu wu-warrarrini a-wubiba-rruj. ");
INSERT INTO nuy_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Anubanila-wala, na-Herod ni-ngawiiyn. Anubani-yung ana-angel na-Buunggawa-yinyung wu-yanggi aḏaba nga wu-rabaliyn na-Joseph-duj ana-Egypt. ");
INSERT INTO nuy_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nga wu-yamayn, “Ba-ḻaḻagiiyn marri banu-mang na-winyinyung marri nga-rriibi-yung, baagiyn yuuguni nugawi-nyinyung-guy wubani a-lhal-wuy a-Israel-wuy. Warruburru-yung yigaj wunu-ngaynbandangi-yinyung ambunu-wini, wurru-ngawiiyn aḏaba,” wu-yamayn ana-angel wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nigaayung na-Joseph ni-ḻaḻagiiyn aḏaba, marri nu-miyn na-winyinyung marri nga-rriibi-yung, anubani wurru-yanggi wubani a-lhal-wuy a-Israel-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Anubani naagi ni-wawanggiyn lhaawu, nubagi na-nimuwaj-jung Archelaus ni-king-maa anubani ana-Judea-rruj, naagi yamba na-niwiyayung na-Herod-jinyung. Wudani-yung-gala, ni-ḏirrngawiiyn na-Joseph. Waari ani-yanggi ana-Judea-wuy. Nga ni-wuryarrangi, na-God nu-magaa naagi-yung “Yagi nurru-rumi anubuguni.” Wurru-yanggi aḏaba a-wurugu-wuy a-Galilee-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Wurru-yanggi wubani-wuy a-lhal, anu-muwaj Nazareth. Nga bagu wirri-maṉdhangi anga. Anaani wiij-gandhurrg-mayn ana-lhaawu warruburru-yung-jinyung wunaa-ja-jambini-yinyung na-God anu…bani-yunggaj, nubagi na-Runggal-yung ambunu-mayaa, a-Nazareth-jinyung niga. ");
INSERT INTO nuy_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Anubani-yumbaa, naagi-yung na-John waniimbara-ngambijgaa-yinyung ni-burri ana-lhal-aṉḏarrg-duj, ana-Judea-rruj. Ni-yanggi, nga wani-magaa, ");
INSERT INTO nuy_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Numburru-wurrij-biḻibiḻingiyn anubanila anaaladi-wala. Na-God-jinyung warru-mandag amburru-muṉḏugana lhaalhag,” ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Naagi na-John, yaagi nubagi anu…bani-yunggaj na-Isaiah nubagi naa-ja-jambini-yinyung na-God, naagi ni-yamaa, “Yaani-yung wu-yamayn ana-yang waaḏiyn yuwaagala a-lhal-aṉḏarrg-gala wugurru, Maanaami manaadi magurru aḏaba nimbirrimaadi-wandhurrg-gana raga-ragij-gaj na-Buunggawa yungguyung aḏaba.” Dani-yung ni-yamaa na-Isaiah niga. ");
INSERT INTO nuy_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Na-John ni-yabini wubarriguḻag a-gamul-inyung. Anubani ni-yabini wubarriguḻag-jii ni-yamarr-yabini. Marri ni-ngunu-nguni ḏaburrurrug marri ḻagu. ");
INSERT INTO nuy_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Warraarrawindi warra-wurru-wurruj wurru-yanggi nigawi-wuy, ana-Jerusalem-gala marri ana-Judea-wala marri anubanila anaala-wala ana-Jordan-gala. ");
INSERT INTO nuy_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Wugurru wirriij-garrarra-gaa wugurri-nyinyung anaaladi marri anubani-yung wirriij-barrngayuyn. Marri anubani-yung na-John waniimbara-ngambijgaa wugurru, anubani anaala-rruj, ana-Jordan. ");
INSERT INTO nuy_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Wani-nani bagi Pharisee marri Saducee, arraarrawindi-yung. Wunu-ngaynbandangi ambaniimbara-ngambijgaa warraawurru-yung. Nga ni-yamayn wugurri-wuy, “Nugurru aadanu nurru-marryn! Yangi-nyung nugurru nambi-magaa aḏaba nuu-yarramana? Na-God yamba yuga ani-riyaldhang? Yii! ");
INSERT INTO nuy_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Numburraaṉiyn aḏaba, nimbirriij-garruyn aḏaba aniij-galaaladi, aadanu aḏaba numburru-waṉbina maaḻamburrg-galawaj nugurru. ");
INSERT INTO nuy_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yagi nugurru nurru-yamijgaynji nugurraajbaj, ‘Ngagurru anaani aḏaba wiiya! Ngagurru na-baba Abraham niga-waj nga!’ Anaani aḏaba ngana-magana nugurru, manaama mana-ṉuga, na-God niga animaaynbijgang magurru, warruburru-yung-guy na-Abraham-jinyung warra-mijburrayung wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Na-God niga ari nugurru nambani-lhajbiyn lhaalhag. Anubani-yung niga ni-lhara warubaj a-rangag-duj, niwu-miṉmiṉḏii. Lhaalhag ari aniwu-madharrii aḏaba. Nugurru nurru-yamana aadanu nguynju wubani-yung-jii a-rangag-jii. Yagi-maynji nurru-waṉbi ana-maaḻamburrg, anubani-yung-jii anu-ngugulmung-jii waari anggu-warradang, anubani ari nugurru nambani-madharrii marri nambani-barawudang yuuguni buguni a-ngura-wuy!” ");
INSERT INTO nuy_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ngaya anaani nganaambara-ngambijgana guugu-mirri nirriij-garruyn-gala anubani anaaladi. Yagu niga nubagi naaynbajung ni-lhamarrii-yinyung ani-yaarri wurrugu. Niga ni-waḏa-waḏaḏ, waari nguynju ngayawi-yii. Ngaya anaani nga-wirrig, yagu ngaya yagi anaani nganaa-garraalgalgurmi, yagu yagi ngama-mi manubama ni-mun-jabina-yinyung. Niga Maṉngulg Mawurr-mirri nambaniimbara-ngambijgana, marri ngura-mirri. ");
INSERT INTO nuy_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Niga ngaambani-muṉḏugijgana ngagurru warra-wurru-wurruj nigawi-nyinyung-jinyung anaani. Yagu warruburru-yung warra-mulung-arrgi-yung, amburru-yaarri wubani-wuy a-ngura wu-naga-nagina-wuy. Niga ani-waṉbina lhaalhag. Anaani wiijamana, nguynju yaga wubani wu-maḏa-muṉḏugina a-maḏa, marri wirri-rajaarrijgana. Nubagi-yung ni-lhamarrii-yinyung, niwaadbarrwumana wugurru anubani-yung anu-ḏal yuuguni, yagu wugurraayung anubani ana-maḏa wu-maḏa-rijbina. Buguni wu-yaarri wubani-wuy a-ngura-wuy. Ana-ngura anaani wugurru waari anggu-ngawang, wu-wandha-wuguuguni wu-bu-burraa wu-naga-nagina wugurru.” Dani-yung ni-yambini na-John, na-nidhaawu-yung ni-yambini ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Anubanila, na-Jesus naagi-yung ni-yanggi aḏaba Jordan-guy, a-Galilee-wala. Nubagi nu-ngaynbandangi na-John anaambara-ngambijgana niga. ");
INSERT INTO nuy_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yagu na-John niga ni-yamaa, “Yagi ngaya ngunaambara-ngambijgi. Nugawaj nimbaambara-ngambijgana ngaya, ngunu-ngaynbandii. A-yangi yungguyung nagang aadanu waambara-ngambijgana, nuynjamana?” nu-yamijgaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yagu na-Jesus niga nu-yambalmayn, “Aḏaba baaṉbina. Yagi-maynji nunggaṉbi anaani, yagi-maynji nimbaambara-ngambijgi, anaarrawindi-lhangu na-God ngaani-yamijgaa-yinyung, yagi wu-wandhurrg-mi,” ni-yamayn. Waari aḏaba ngijang na-John ani-yambini anaaynbaj, aḏaba naambara-ngambijgayn niga. ");
INSERT INTO nuy_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Anubanila nigaayung na-Jesus niidadiyn anaa-gugu-wala, marri ana-wumala wu-gara-wawalhiyn. Marri na-God-jinyung ana-Maṉngulg Mawurr niwu-nani na-Jesus, wu-dhirridangi nigawi-wuy, nguynju yi-ḻabarrg-jii, wu-yamaa. Nga wu-burri nigawi-rruj arrwa-garrwar. ");
INSERT INTO nuy_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Marri bani-yung ana-lhaawu wu-yaṉḏabaliyn anaarrwar-wala. Na-God niga ni-yambini. Ni-yamayn, “Naagi ngayawi na-Nigi, marri ngaya nganaa-ḏamarr-ngu-burraa. Marri ngaya ngaaḻaaḻarriyn nigawi yungguyung,” ni-yamayn na-God. ");
INSERT INTO nuy_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Anubanila, anubani ana-Mawurr na-God-jinyung ninggu-yarrijgiyn aḏaba na-Jesus a-lhal-aṉḏarrg-guy, nga bagu anaani na-baḏirrnya-yung naa-dhangu-jujurangi. ");
INSERT INTO nuy_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Na-Jesus waari ani-nguni baḏag, 40 mana-miyn.nganga. Aḏaba ni-marryaadiyn-bindiyung. ");
INSERT INTO nuy_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Aḏaba na-baḏirrnya-yung ni-yanggi nga nu-yamijgayn, “Yuga nagang na-Niwiyayung na-God-jinyung? Bama-yamijgang manaami mana-ṉuga ama-marrya-wiiyn,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nigaayung na-Jesus ni-yamayn, “Na-God waarrarrina ana-wubiba-rruj, ni-yamayn, ‘Nagang-maynji ba-nguyii-wugij ana-marrya, yagi numbiri-mi-windiyung. Na-God-jinyung-gala a-lhaawu, ba-wiri-mana,’” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nga nu-yarrijgiyn aḏaba wubani a-maṉngulg-guy aanga, Jerusalem. Nga aarrwar-wuy nu-burriyn wubani a-Temple-Maṉngulg-guy naagi na-Jesus. Nga nu-yamijgaa, ");
INSERT INTO nuy_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Yuga nagang na-Niwiyayung na-God-jinyung? Ba-barawudiyn! Yagu na-God yamba, na-God-jinyung ana-lhaawu ana-wubiba-rruj, wu-yamana, ‘Niga na-God ani-magana-windiyung nigawi-nyinyung ana-angel nugawi-nyinyung. Wugurru ambi-waṉagana nagang wugurri-nyinyung-duj a-marang nguynju yadhu nagang yagi nunggu-lhambiḻdhi ana-mun mana-ṉuga-rruj.’” Dani-yung ni-yamayn na-baḏirrnya-yung. ");
INSERT INTO nuy_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Na-Jesus ni-yamayn ana-baḏirrnya-wuy, “Na-God ni-yamana ana-wubiba-rruj, ‘Yagi nagang nunu-rawu, niga na-Buunggawa nugawi-nyinyung na-God,’” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ngijang aḏaba ninggu-yarrijgini amubami ma-ḻandhirrngindaa-wuy. Nga ninggu-bajiyini anubani ana-lhal-lhangu anaarrawindi-lhangu anaani, marri anubani anaarraambaḻaman-jinyung wu-warra-ngu-burraa-yinyung ninggu-bajiyini. ");
INSERT INTO nuy_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nga ninggu-yamijgaa, “Nagang-maynji ba-ḻandharrdhangang marri nimbaarraarriwana ngaya, waarriiyn ngaya anaani anaarrawindi-lhangu aadanu,” wu-yamaa anubani-yung ana-baḏirrnya. ");
INSERT INTO nuy_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nga na-Jesus ni-yamayn, “Ba-yaarri! Ba-yaarri nagang Satan, yagu na-God yamba ni-yamayn ana-wubiba-rruj, (Deuteronomy 6:13) ‘Nagang banu-warraarriwana God-bugij, nigaaj-bugij, banu-yandhurrbangana niga-waj.’ ” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nga anubani ana-baḏirrnya ninggaarruyn aḏaba wu-yanggi, nga ana-angel wu-ngarra-janggi nigawi-wuy, wunu-maṉmangi niga. ");
INSERT INTO nuy_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Anubanila-wala, nigaayung naadagi-yung na-John, warruburru-yung wurru-wiynji-wiynjini-yinyung wunu-miyn, wunu-dhidiyn. Nga ni-wawanggiyn na-Jesus anubani ana-lhaawu. Niigiyn aḏaba Galilee-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nga niwaarruyn ana-Nazareth, ni-yanggi Capernaum-guy, nga anubagu ni-burri. Anubani ana-lhal wu-warubaj ana-wurugu, anubani ana-runggal ana-lhal wu-mayini ana-Zebulun marri ana-Naphtali. ");
INSERT INTO nuy_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Anubani ana-lhaawu wu-magini wu…bani-yunggaj, na-Isaiah nubagi naa-ja-jambini-yinyung na-God, anaani-yung ni-yambini anu…bani-yunggaj, wiij-gandhurrg-mayn aḏaba. Na-Isaiah ni-yamaa, ");
INSERT INTO nuy_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ana-lhal ana-Zebulun marri ana-Naphtali, bagu amaadi-waj ana-wurugu-waj, wagagala aala-waj ana-Jordan, Galilee, anubani ana-lhal, warruburru-yung-jinyung warra-Gentile-inyung. ");
INSERT INTO nuy_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Warruburru-yung ana-lhal-uj anubani-rruj, wurru-burri waangamudii-rruj. Aḏaba wirri-nani wu-lhalmbaarrangi runggal. Anubani-yunggaj wurru-bu-burri a-ruluj-baj, waangamudangi-waj, nguynju wubani yaga wurru-ngawa-ngawina-yii. Aḏaba anubani wu-lhalmbaarrii-yinyung wu-warra-lhalmbaarriyn aḏaba.” Dani-yung yigaj na-Isaiah ni-yambini, na-nidhaawu-yung. ");
INSERT INTO nuy_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Banila aḏaba anubani-yung, wani-magaa na-Jesus na-God-jinyung a-lhaawu aḏaba bagala. Ni-yamayn, “Nimbirriij-garruyn aniij-galaaladi-wala, yagu yamba na-God-jinyung warru-mandag amburru-muṉḏugana lhaalhag.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ni-yanggi a-wurugu-waj a-Galilee-rruj, nga wani-nayn nubiṉi-yung nigamanyij, Simon, naadagi-yung na-nimuwaj-jung, ni-mayini Peter, marri na-nilharri-yung Andrew. Winima-barawudangi naynja, ambini-mangi yungguyung ngujija, yagu wuguṉi-yung yamba wini-manga-mangi-yinyung ana-ngujija anubani-yunggaj. ");
INSERT INTO nuy_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Na-Jesus ni-yamayn, “Nimbinaaṉiyn, nganiinggarra-yaarri. Anaanila-wala, nambaani-mani wurru-wurruj na-God yungguyung,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Wuguṉiiyung winimaarruyn mana-naynja nga wunu-garrindharrmangi aḏaba na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ni-yanggi anubanila ana-lhal. Ngijang wani-nayn wini-wulawaa nigamanyij, James marri John, na-Zebedee-yinyung na-niwiyayung-biiyung. Nubiṉi-yung marri na-ninyarra-yung na-Zebedee, bagu warruburru-yung ama-barrawu-rruj wurru-burri. Wirrima-wa-warrgaa naynja, amburru-ngaḏugumbini yungguyung aḏaba yingga lhaalhag. Yagu aḏaba niga wanii-gaḏiyn nubiṉi-yung. ");
INSERT INTO nuy_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nga aḏaba winimaarruyn mana-barrawu marri na-ninyarra-yung, aḏaba wunu-garrindharrmangi na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Na-Jesus ni-yangga-yanggi a-Galilee-waj. Wani-magaa bagu anubani ana-synagog-duj, wani-magaa anubani-yung ana-lhaawu warrubawi-yung-jinyung warru-mandag na-God-jinyung. Anubagu wani-maji-waa warruburru-yung wuu-lhangurrngandi-yinyung marri wirri-warra-waṉagaa-yinyung ana-jiiji warraarra-guṉḏa-guṉḏa-yinyung wani-maji-waa wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nigawi-nyinyung ana-lhaawu wu-rajaarrangi a-Syria-waj. Warruburru wurraarra-yarrijgini nigawi-wuy warruburru-yung wu-lhangurrngandi-yinyung, marri warruburru-yung wurraarragayangi-yinyung, marri warruburru wurru-waṉagaa-yinyung ana-man.gurrg, marri wurru-wan-gaagidhangi-yinyung, marri wurraarra-ngu-binyalga-yinyung. Niga wani-warra-maji-waa warruburru warraarrawindi-lhangu. ");
INSERT INTO nuy_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Arraarrawindi wurru-wurruj wunu-garrindharrmangi na-Jesus ana-Galilee-wala, ana-Decapolis-gala, marri ana-Jerusalem-gala, ana-Judea-wala, marri ana-wagagala-wala anaala-wala ana-Jordan-gala wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Na-Jesus wani-nayn warra-garnyirrimba. Niidadiyn aḏaba ama-ṉuga-wuy arrwiyaj, nga ni-burrangayn aḏaba. Warruburru-yung wani-marrbuy-waa-yinyung wurru-yanggi nigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nga wani-marrbuy-waa wugurru. Ni-yamaa, ");
INSERT INTO nuy_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nugurru yuga nurru-marrbuy, waari nurru-maṉmi nugurraajbaj? Nigaayung na-God naniigajij-majgaa aḏaba, marri numburru-burraa nigawi-nyinyung warru-mandag. ");
INSERT INTO nuy_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Nugurru yuga nurru-wurrij-galadi-wina windiyung? Na-God naniigajij-majgaa aḏaba, marri nambani-man.galagana nugurru. ");
INSERT INTO nuy_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Nugurru yuga nurru-yaal-murramurra? Na-God naniigajij-majgaa aḏaba, marri niga nambaniiyn anubani anaarrawindi-lhangu nani-lhalamayaa-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Nugurru yuga nirri-ngaynbandii-windiyung numbunu-yandhurrbangana na-God, nguynju yaga nurru-marryaadi marri nurru-wurrij-guldhii yaga? Na-God naniigajij-majgaa aḏaba. Anubani anaarrawindi nurraarra-ngaynbandii-yinyung, niga ambaniiyii nugurru. ");
INSERT INTO nuy_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Nugurru yuga narra-man.galagana warra-mulung-aynbaj? Niga na-God naniigajij-majgaa aḏaba, marri nambani-man.galagana nugurru. ");
INSERT INTO nuy_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Nugurru yuga nurru-wawanggina ana-mamanunggu ana-lhirribala? Na-God niga naniigajij-majgaa aḏaba, marri numburru-warubaj-giiyn nigawi-wuy, numbunu-yilhal-nayii warubaj. ");
INSERT INTO nuy_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Warrubawi-yung-maynji ana-wungarri amburru-wiynjina, yuga nugurru nambarra-muḏaḏbijgana? Na-God naniigajij-majgaa aḏaba, marri nambani-mayana nigawi-nyinyung warra-mijburrayung nugurru. ");
INSERT INTO nuy_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Nugurru yuga nambi-wungarri-dhijgana, nugurru yamba nuunu-yandhurrbangana na-God, yuga? Niga naniigajij-majgaa aḏaba. Nugurru aadanu nigawi-nyinyung aadanu warru-mandag.” ");
INSERT INTO nuy_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Na-Jesus naagi-yung ni-yambini-wugij. “Ari nugurru nambambiiladi-yamawana marri nambambi-wungarri-dhijgana marri ambuu-yambina aynba-gaynbaj-jinyung ana-lhaawu a-yang-jilg-jinyung nugurri-nyinyung, nugurru yamba ngirri-garrindharrmani ngaya. Amburru-waṉbina-maynji aniijiijung, na-God nambaniigajij-majgana. ");
INSERT INTO nuy_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Numburru-ḏinggina, yagu yamba na-God nanii-garra-waṉagana anaarraambaḻaman-jinyung anaarrwar. Warruburru-yung wunaa-ja-jambini-yinyung anu…bani-yunggaj, warra-wungarri-dhijgaa wugurru.” ");
INSERT INTO nuy_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Naagi-yung na-Jesus ni-yambini-wugij. “Warra-wurru-wurruj wini-burrii lhanganig a-marrya-rruj, marri wu-burraa baḏag. Nugurru nurru-jambarrgina-yinyung, nugurru yii-lhanganig-jii nuu-yamana. Numburru-magina-maynji na-God-jinyung a-lhaawu, amburru-marrbuy wugurraayung amburru-yamana yungguyung maaḻamburrg-waj. Na-lhanganig-maynji yagi waṉagi na-nidhamij, numburru-yaminggarrang nimbiniigijgiyn nubagi na-nidhamij? Nubagi na-lhanganig niiladi. Yagi wini-waṉagi ana-marrya-rruj. Ambini-barawudang, nubagi na-lhanganig.” ");
INSERT INTO nuy_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Na-Jesus naagi-yung ni-yambini-wugij. “Nugurru nurru-yamana nguynju wu-lhalmbaarrii-yii ana-lhal-lhangu yungguyung. Anubani anaanga ama-ṉuga-rruj anaarrwar, yagi wirri-julubi. ");
INSERT INTO nuy_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nugurru-maynji aadanu nimbirri-lhalmbaarrijgana anubani wu-lhalmbaarrii-yinyung, yuga nimbirri-burrdang lhirribala ama-gaṉdharra-rruj? Girrjag! Yuwaagu arrwar nimbirri-wudhang. Nguynju amburraarra-nayii yungguyung aynba-gaynbaj-jinyung, warraarrawindi a-wumurrng-duj. ");
INSERT INTO nuy_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nguynju nugurraayunggaj wu-lhalmbaarrii-yii numburru-yamana, nguynju nambambi-nayii yungguyung warra-wurru-wurruj, numburru-waṉbina ambaḻaman. Nambambi-nayii, marri ambunu-warraarriwana naagila na-Baba anaarrwar-yinyung.” ");
INSERT INTO nuy_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Na-Jesus naagi-yung ni-yambini-wugij. “Yingga nurraan-jami-magi ngaya nga-yanggi nugurri-wuy ngawaaladi-yamawangun-magi yingga ana-lhaawu-runggal, yagu ana-lhaawu ngijang warruburru-yung-jinyung wunaa-ja-jambini-yinyung na-God anu…bani-yunggaj-jinyung. Waari. Nga-yanggi nganggu-wandhurrg-gana yungguyung anaani ana-lhaawu-runggal. ");
INSERT INTO nuy_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Anaani ngana-magana yijgubulu. Anggu-burraa-waj ana-lhal marri ana-wumala, yagi wu-jadugi anaani ana-lhaawu-runggal, anggu-wuguuguni-wugij anggu-burraa. Yagi anaaynjaabugij ana-wirrig anu-mari wu-jadugi, anggu-burraa-wugij. Marri anubani-yung anggu-wandhurrg-gina, anaarrawindi-lhangu. ");
INSERT INTO nuy_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Nugurru-maynji yagi nirri-yandhurrbi ana-lhaawu ana-wirrig, nga nambarra-marrbuy-wana-maynji yagi wirri-yandhurrbi anubani-yung, na-God nambani-winyig-gang nigawi-nyinyung warru-mandag. Yagu nugurru-maynji nimbirri-yandhurrbangana ana-lhaawu-runggal anaarrawindi-lhangu, nga nambarra-marrbuy-wana ambirri-yandhurrbangana anubani-yung, nugurru nambani-runggal-wang, nigawi-nyinyung-jinyung warru-mandag. ");
INSERT INTO nuy_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Warra-mulung-arrgi warrubawi-yung wirriirrarrangi-yinyung warra-yiyini-yinyung ana-lhaawu-runggal marri warra-Pharisee wirri-yandhurrbangana arrgi ana-lhaawu-runggal. Yagu nugurru-maynji nimbirri-yandhurrbangana ana-lhaawu-runggal maaḻamburrg-galawaj, nugurru numburru-yaarri na-God-jinyung-guy warru-mandag.” ");
INSERT INTO nuy_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Na-Jesus naagi-yung ni-yambini-wugij. “Warruburru warra-marrbuy-wana-yinyung nambi-magaa, (Exodus 20:13) ‘Yagi narra-mulunguwa-wi. Warrubawi-yung-maynji ambarruumana, na-God ambani-lhajbumana,’ dani-yung nambi-magaa nugurru. ");
INSERT INTO nuy_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yagu ngaya ngana-magana aḏaba, nagang-maynji banaa-ḏiyaldhang-maynji nugawi-nyinyung na-nilharri, banu-wungarri-dhijgang-maynji, marri banu-wurrij-bang-bindiyung, na-God ani-lhajbumana. Banu-mi-ḏijalagana-maynji marri banaaladi-yamana-maynji nugawi-nyinyung na-nilharri, nagang ani-yarrijgina nigawi-wuy a-court-guy. Nagang-maynji banu-mayana nagang na-nilharri ni-yilg, ba-nagina nagang a-ngura-wuy.” ");
INSERT INTO nuy_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Naagi-yung na-Jesus ni-yambini-wugij. “Nagang-maynji banuuyn anujiigurung na-Baba-wuy lhaalhag, a-Temple-Maṉngulg-duj, ba-marrbuy anubani yangi nunggaṉbini na-nilharri-wuy, bawaarruyn bagu. ");
INSERT INTO nuy_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ba-yaarri na-nilharri-wuy, nga nimbini-yambiynjina, banu-guwaj-gang ngijang. Bani-yung marri baagiyn, banuuyn anujiigurung nugawi-nyinyung, na-Baba-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Warrubawi-yung-maynji ambu-yambina nugawi-wuy, ‘Nagawaa na-yaarri a-court-guy, nga bagu nubagi-yung wani-nguynju-nguynjijgana-yinyung na-runggal-yung, nambani-nguynju-nguynjijgana nagawaa.’ Ani-yambina-maynji anubani, nimbini-yambiynjina, banu-guwaj-gang ana-wulhu-wulhurr. Yagi-maynji nunu-guwaj-gi, nagang aniiyn nubagi na-runggal-yung-guy a-court-duj, marri nubagi na-runggal-yung aniiyn nubagi wani-radba-radbumana-yinyung, marri nagang nubagi wani-radba-radbumana-yinyung ani-burrang wu-dhi-dhidina-rruj. ");
INSERT INTO nuy_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ngaya ngunu-magana yijgubulu-windiyung, yagi nuṉḏabali, murrubu bambiiyii ana-bayarra, bawu-jadugang nugawi-nyinyung anubani anu-ṉuga anaarrawindi-lhangu.” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Naagi-yung na-Jesus ni-yambini-wugij. “Warruburru-yung warra-marrbuy-wana-yinyung nambi-magaa anaani ana-lhaawu, (Exodus 20:14) ‘Yagi nagang naa-gamajangi warra-maṉung,’ wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yagu ngaya anaani ngana-magana aḏaba, bangu-nang-maynji ngarrubagi ngarra-maṉinyung, nga bangu-ngaynbandii nugawi-rruj ambubug, nunggaaṉbiyn aḏaba nugawi-rruj ambubug. ");
INSERT INTO nuy_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Wudani-yung yamba, nugawi-nyinyung-maynji mana-bagaḻang mana-walawalama ama-dhaayurrii marri baaṉbina aladi, bama-ngarrgiwang marri bama-barawudang! Bama-ngarrgiwang-maynji manubami mana-bagaḻang, marri ba-yaarri-maynji anubani-yung anaarrwiyaj ba-wiri-mana-maynji, anubani ari wiij-mamaaḻang. Yagu niga-maynji na-God ani-barawudang-maynji nagang a-ngura-wuy, amuulawaa-maynji mana-bagaḻang, waaladi! ");
INSERT INTO nuy_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Marri nugawi-nyinyung-maynji ana-walawalama ana-marang anggu-dhaayurrii marri baaṉbina-maynji aladi, bawu-wuḻdhang marri bawu-barawudang. Bawu-barawudang-maynji, marri ba-yaarri-maynji anubani-yung anaarrwiyaj, aḏaba maaḻamburrg. Yagu ba-yaarri-maynji anubani wu-naga-nagina-wuy, angguulawaa-maynji ana-marang, anubani aladi.” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Naagi-yung na-Jesus ni-yambini-wugij. “Warruburru warra-marrbuy-waa-yinyung nambi-magaa nugurru, (Deuteronomy 24:1) ‘Bangaarruyn-maynji nugawi-nyinyung nga-rangarrinaaj, banguuyn ngiga wubiba, amburru-marrbuy yungguyung nagang nungaarruyn, niiniirruynjiyn,’ wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yagu ngaya anaani ngana-magana, bangaarruyn-maynji nugawi-nyinyung nga-rangarrinaaj, marri waari angiiynji-yaay warraaynbaj-guy, bangu-dhaayurrii, yagu yamba angu-mang-maynji aynbajung waḻyinyung, angi-waṉbina aladi. Yagu nugawaj na-God ani-lhajbiyn. Marri nubagi na-waḻyinyung, nigaayunggaj ani-waṉbina aladi.” ");
INSERT INTO nuy_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Naagi-yung na-Jesus ni-yambini-wugij. “Warruburru warra-marrbuy-wana-yinyung nambi-magaa anu…bani-yunggaj, ‘ba-lhalamayina-maynji, bawu-warra-maya-mayana-maynji anaaban marri anaarrwar marri ana-Jerusalem, anubani nunggu-lhalamayana-yinyung yijgubulu, baaṉbina,’ wurru-yamaa warruburru warra-marrbuy-wana-yinyung.” ");
INSERT INTO nuy_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","“Yagu ngaya anaani ngana-magana, numburru-lhalamayina-maynji, yagi nurru-yambi anaaynbaj ana-lhaawu. Yagi anaani nirri-warra-maya-mayi anaarrwar marri anaaban, yaani yamba ni-burraa na-God, ni-buunggawa-mana. Marri nirri-mayi yagi ana-Jerusalem, anubani anaanga yamba na-Buunggawa-yinyung, na-Runggal-yung. ");
INSERT INTO nuy_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ngijang yagi nunggu-mayi nugawi-nyinyung ana-yinag, yagu yamba nugawi-nyinyung mana-mung. Yagi numa-ngalngalijgi yagu numa-dudumijgi. ");
INSERT INTO nuy_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yagi nunggaṉbi aniijiijung. Yagu ba-yambina ‘yii’, marri ‘yagi’. Anubani anaaynbaj ana-lhaawu nuynjambina, anubani na-baḏirrnya-yung nini-lhaawu-yiyina nuynjambina.” ");
INSERT INTO nuy_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Naagi-yung na-Jesus ni-yambini-wugij. “Anu…bani-yunggaj, warruburru warra-marrbuy-wana-yinyung nambi-magaa, (Exodus 21:24) ‘Ambi-wiyn-maynji mana-bagaḻang-duj, bamba-wiyn ama-bagaḻang-duj. Warrubawi-yung-maynji ambi-ra-wadjang ama-ra-rruj, wugurri bamba-ra-wadjang,’ wurru-yamaa warruburru-yung. ");
INSERT INTO nuy_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yagu ngaya anaani ngana-magana, yagi ngijang barraa-gaagijgi warrubawi-yung. Warrubawi-yung-maynji ambi-ramarra-wadjang nagang, ngijang anubani-yung ba-ramarra-wiḻibiḻingiyn aadanu, ambi-ramarra-wadjang aaynbaj-gala ngijang. ");
INSERT INTO nuy_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","“Nubagi-yung-maynji na-wurrujung ani-yarrijgina wurru-yamba-yambina-wuy, a-court-guy, nga ani-yamijgang, ‘Nimbiiyn nugawi-nyinyung mana-yaaḻi mana-lhirribala,’ ani-yamang, banuuyn manubami mana-yaaḻi, ngijang banuuyn manaarabarabalu mana-yaaḻi. ");
INSERT INTO nuy_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nubagi-yung-maynji ni-wiynji-wiynjini-yinyung ani-yamijgang, ‘Nimbii-garrwarrwuu ngayawi-nyinyung anaarra aḻagaḻa,’ ani-yamijgang nubagi-yung, banaa-garrwarrwuu malanganyanay! ");
INSERT INTO nuy_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Warrubawi-yung-maynji ambi-lhangayaana anubani-yung, baarra-waṉagana-yinyung, bambaarriiyii, yagi barraandirri.” ");
INSERT INTO nuy_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Na-Jesus naagi-yung ni-yambini-wugij. “Warruburru-yung warra-marrbuy-wana-yinyung nambi-magaa, ‘banaa-ḏamarr-ngu-burraa nugawi-nyinyung na-guwaj, marri banu-margirang nubagi ani-wungarri-dhijgana-yinyung,’ wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yagu ngaya nugurru ngana-magana, nambarraa-ḏamarr-ngu-burraa warrubawi-yung nambi-wurrij-bangana-yinyung, marri nambarraa-jambina na-God-guy, warrubawi-yung nambi-wungarri-dhijgana-yinyung nugurri-wuy, wurru-waṉbina aladi-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nguynju numburru-yamana na-Baba-yii anaarrwar-yinyung. Ni-yaminggarrina? Ngarraaḻirr ngarrani-waḻamin-dharrgang, ngarrangi-murrmbulijgana warraalaaladi-rruj marri warraambaḻaman-duj. Nguynju-waj ngarraaṉbana ngi-warra-rabina warraambaambaḻaman-duj marri warraalaaladi-rruj. Nugurraayunggaj aadanu, numburru-yamana nguynju na-Baba-yii anaarrwar-yinyung.” ");
INSERT INTO nuy_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Naagi-yung na-Jesus ni-yambini-wugij. “Warra-mulung-arrgi-yung nambi-ngaynbandii. Yuga warrubawi-yung narra-ngaynbandii bawi-yung-bugij? Waari anaani anggiij-mamaaḻang-magaa anaani-yung aḏaba. Wugurraayunggaj wirri-mana-mani-yinyung anu-ṉuga, wurraalaaladi wugurru, yagu wurru-yamana yingga aadanu, wiij-nguynju. ");
INSERT INTO nuy_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Warrubawi-yung waari-yinyung na-God-jinyung warra-wurru-wurruj, wurru-yambiynjina wugurri-nyinyung-guy warra-mijgalgur-yung-guy. Yagu nugurru-maynji numburru-yamana nguynju wugurri-yii, waari anaani anggiij-mamaaḻang-magaa. ");
INSERT INTO nuy_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","“Nguynju anaani ngana-magana, numburru-yamana nguynju nugurri-nyinyung-jii na-Baba-yii anaarrwar-yinyung. Waari ani-waṉbang anaaladi niga. Nugurraayunggaj yagi nurru-waṉbi anaaladi aadanu.” Dani-yung na-Jesus ni-yamaa, ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Naagi-yung na-Jesus ni-yambini-wugij. “Nambarra-maṉmani-maynji warra-mulung-aynbaj-guy, yagi nambi-ni warra-wurru-wurruj. Nurru-waṉbina-maynji aniijiijung, nambambi-nayii yungguyung, nubagi na-Baba anaarrwar-inyung yagi nani-bayarra-gi nugurru. Warrubawi-yung-maynji ambu-ngaynbandii yangi anubani nambarriiyn, yagi warra-wurru-wurruj nambi-ni anubani-yung numburru-waṉbina-yinyung nugurru. ");
INSERT INTO nuy_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Warruburru wurraambaḻaman-gina-yinyung wurraaṉbina anaambaḻaman-jinyung ana-synagog-duj marri wurru-yaarri-rruj warra-wurru-wurruj, yingga wurraan-jamana wurraambaḻaman, marri ambarra-warraarriwana. Ngaya ngana-magana, dani-yung-bugij wirri-mani, waari anaaynbaj. ");
INSERT INTO nuy_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nugurru yagi nurru-yamana warruburru-yung-jii. Warrubawi-yung-maynji bamba-maṉmani, nugurri-nyinyung ana-mangaṉḏayayaagu ana-marang, yagi wu-marrbuy-mi anaaynbaj ana-marang anggu-waṉbina-yinyung! ");
INSERT INTO nuy_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Marri nugurri-nyinyung na-Baba anaarrwar, nani-nayii-yinyung midaarrgaj, nambani-bayarra-gana nugurru.” ");
INSERT INTO nuy_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Na-Jesus naagi-yung ni-yambini-wugij. “Numburru-yambina-maynji na-Baba-wuy anaarrwiyaj, yagi nurru-yami warruburru-yung-jii wurraambaḻaman-gina-yinyung-jii. Wurraarragarra-lhara marri wurru-yambina na-Baba-wuy anaarrwiyaj ana-synagog-duj marri wurru-yaarri-waj amaadi-waj, wurraarragarra-lhara marri wuu-yambina, warra-wurru-wurruj yungguyung ambarra-nayii wugurru. Ngaya ngana-magana, dani-yung-bugij wirri-mani. ");
INSERT INTO nuy_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","“Numburru-yambina-maynji, numburru-yaarri aangaaynbaj-guy, yagi nambi-ni, midaarrgaj numburru-yambina na-Baba-wuy. Anubani-rruj na-Baba na-God, bagu ni-burraa niga, anubani anaanga-rruj numburru-yambina-rruj. Niga nambani-bayarra-gana nugurru. ");
INSERT INTO nuy_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Yagi nurru-yami nguynju warruburru-yung-jii warra-Gentile. Warruburru wurru-yamba-yambina arrawindi lhaawu. Wurraan-jamana, ‘Ngaya-maynji ngaynjambina arrawindi lhaawu, na-God ngambani-yaynjangayii,’ wurru-yamana. Waari aniijgubulu-magaa! ");
INSERT INTO nuy_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yagi nurru-yami warruburru-yung-jii. Nugurri-nyinyung na-Baba anaarrwar ni-marrbuy anubani nirri-ngaynbandii-yinyung raga-ragij-gaj, nga nurru-yambina adhaadharri. ");
INSERT INTO nuy_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Numburru-yambina, aniijiijung numburru-yamana. ‘Nurri-nyinyung Baba, nu-ngu-burraa anaarrwar. Nirri-maṉngulg-gana nugawi ana-muwaj. ");
INSERT INTO nuy_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ngunu-ngaynbandii ba-buunggawa-mana. Ngunu-ngaynbandii baaṉbina nugawi-waj ana-lhal-lhangu-rruj, nguynju nunggaṉbina wuguuguni anaarrwar. ");
INSERT INTO nuy_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Numbiiyii nurri-wuy ana-marrya nurru-ngaynbandii ana-yimbaj. ");
INSERT INTO nuy_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Numbaagajij-garruyn anaaladi-wala nurru-waṉbini-yinyung, nguynju narraagajij-garruna warruburru anaaladi-wala wurru-waṉbina nurri-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yagi numba-rawu anaangaḏajung. Numba-milimilidhii anaaladi-wala.’” ");
INSERT INTO nuy_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Naagi-yung na-Jesus ni-yambini-wugij. “Nambarraagajij-garruna-maynji warra-mulung-aynbaj warrubawi-yung wu-waṉbini-yinyung aniij-galaaladi, nigaayunggaj na-Baba anaarrwar naniigajij-garruna aniij-galaaladi. ");
INSERT INTO nuy_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Yagu yagi-maynji narraagajij-garru warrubawi-yung warra-mulung-aynbaj, nigaayunggaj na-Baba anaarrwar yagi naniigajij-garru aniij-galaaladi nugurru aadanu.” ");
INSERT INTO nuy_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Naagi-yung na-Jesus ni-yambini-wugij. “Yagi-maynji nurraarra-ngi ana-marrya, yagi nurru-yimurr-jiwuri nguynju warruburru-yung wurraambaḻaman-gina-yinyung warra-wurru-wurruj wuu-yamana. Warruburru wirriiladi-wina wugurri-nyinyung ana-yilhal nguynju warra-wurru-wurruj yungguyung warra-nayii, marri wurru-marrbuy warruburru-yung waari amburru-nguni ana-marrya. Ngana-magana yijgubulu, dani-yung-bugij wirri-mani, waari anaaynbaj. ");
INSERT INTO nuy_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Yagu nugurru yagi-maynji nurraarra-ngi ana-marrya, ba-yi-yarrbina nguynju nurraaṉbina-yii, ");
INSERT INTO nuy_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","nguynju yungguyung yagi warruburru wurru-marrbuy-mi anubani nurru-marrya-marrya nurru-burraa. Na-Baba-wugij ani-marrbuy, waari-yinyung ngaambani-nang ngagurru, ani-marrbuy. Anubani-yung midaarrgaj nurraaṉbina anubani-yung, niga-waj ni-warra-nayii, marri nambani-bayarra-gana nugurru.” ");
INSERT INTO nuy_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","20","Na-Jesus naagi-yung ni-yambini-wugij. “Nugurru numburraarraalgaalgurmani nguynju yadhu arraambaḻaman-jinyung numburraarra-mani anaarrwar-rruj. Anubani ana-lhal waari-yinyung ana-lhalawag marri anu-dhagabuṉulg anaaynba-gaynbaj-jinyung yagi arraaladi-wi, nga waamaamajaa-yinyung yagi wu-rumi nga waamajangi. Yagi nurru-warraalgaalgurmi nga nurraambalal-gi anaani-rruj ana-lhal. Ana-lhal a-lhalawag-jinyung marri anu-dhagabuṉulg-jinyung marri anaarra-maṉḏamaṉḏii-yinyung anaarraalaaladi-yinyung wu-warra-ngu-burraa, marri waamaamajaa-yinyung amburru-yaarri marri amburraamajang. ");
INSERT INTO nuy_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Numburraambalal-gina-maynji anaani-rruj ana-lhal, nugurri-nyinyung nurru-wijangayii-yinyung marri nurraaṉbina-yinyung yaaju-wugij anggu-warra-ngu-burraa, yagu yagi na-Baba-rruj anaarrwar.” ");
INSERT INTO nuy_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Na-Jesus naagi-yung ni-yambini-wugij. “Mana-bagaḻang yaga ma-yamana nguynju wu-lhalmbaarrii-yii nugurri-rruj a-ngun.gu-rruj. Nugurri-nyinyung-maynji mana-bagaḻang ama-maṉdhina, yagu anubani-yung numburraarra-nayii arrawindi wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Yagu nugurri-nyinyung-maynji mana-bagaḻang amaaladi, yagu yagi anubani-yung nurraarra-ni. Nguynju yaga wudanu wu-dumana aaladi a-lhirribala nugurri-rruj wudanu-rruj, wu-dumana-windiyung wugurru! ");
INSERT INTO nuy_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Waari narra-waṉagi na-wulawaa na-buunggawa-waa. Nugurru-maynji nambarra-waṉagana ambini-wulawaa na-buunggawa-waa, numbunu-margirang naaynbajung yagu naaynbajung numbunu-ngaynbandii. Numbunaa-garra-galgaalgurmani ari yijgubulu nubagi naaynbajung, ari yagi niga naaynbajung nuunaa-garra-galgaalgurmi ana-maaḻamburrg. Nguynju yunggaj, nugurru yagi nuunu-waṉagi na-God marri anaaynbaj yagi wu-buunggawa-mi.” ");
INSERT INTO nuy_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Naagi-yung na-Jesus ni-yambini-wugij. “Ngaya ngana-magana nugurru, yagi nurraarra-yangi ana-marrya marri anaa-gugu marri nurraarra-yabina-yinyung yagi nurraarra-yangi. Yagu nugurri-nyinyung yamba ana-wiri wu-runggal-wina aadanu. Waari ana-marrya-yii anggu-yamang yamba wugurru. Marri nugurri-nyinyung ana-ngun.gu mana-yaaḻi-yii waari anggu-yamang wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","“Numburraarra-nayii ana-ngurudhu wu-wilbilii-yinyung ana-wumala-waj. Yagu wugurru ana-ngurudhu waari majgang ana-marrya marri arra-ngu-burrang anubani ana-wumurrng-guy, arra-ngu-dhidang. Yagu na-Baba anaarrwar niga ni-maṉmani, ni-marrya-wuyii ana-marrya. Nugurru waari numburru-yamang ana-ngurudhu-yii aadanu. ");
INSERT INTO nuy_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wiiya nugurru nurru-ramarr-ruwi-ruwina-yinyung, ari malgaynbaaynbiyaj nurru-burraa, waari ana-baḏag nurru-burrangi anaani-rruj.” ");
INSERT INTO nuy_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Naagi-yung na-Jesus ni-yambini-wugij. “Yagi mana-yaaḻi yungguyung nurru-wijangi. Yagu numburraarranggana numburru-nayii wu-lhababidhii-yinyung, yangi anubani wu-waṉbina. Waari wu-warra-galgaalgurmi, waari warrgang mana-yaaḻi. ");
INSERT INTO nuy_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Na-Solomon na-king niga niimbalal-windiyung. Yagu aynjaabugij anubani-yung wu-lhababidii-yinyung bagu waanuynjungina, arra-waṉagana arraambaḻaman-jinyung anu-dhabag. Manubami na-Solomon-jinyung mana-yaaḻi waari ma-yamaa nguynju anubani-yung-jii wu-lhababidii-yii. ");
INSERT INTO nuy_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ana-maḏa anaani ana-yimbaj yaani aḏaba, anaagaray anggu-jadug. Ana-ngura nangana. Yagu niga na-Baba anaarrwar ni-burrii wu-lhababidii-yinyung aabaḻa-waj, nguynju yaga ama-yaaḻi-yii mamanunggu-yii yaga. Nguynju wubani-yung-jii wudhabag-jii waanuynjungina aabaḻa-waj yaga, nigaayung naniiyn, na-Baba anaarrwar-yinyung. Nurru-jambarrgina winyig! ");
INSERT INTO nuy_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","32","Warruburru warra-Gentile, waari-yinyung amburru-jambarrgi warra-wurru-wurruj, wurru-wurrij-galadi-wina ana-marrya yungguyung marri anaa-gugu marri mana-yaaḻi. Wirriijangayii warrubawi-yung, ‘Ajigala?’ wurru-yamana. Yagu nugurri na-Baba anaarrwar, ni-marrbuy yangi anubani nurraarra-ngaynbandii-yinyung. Yagu yagi nurru-wurrij-galadi-wi aniijiijung-jinyung anaarra. ");
INSERT INTO nuy_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yaani-yung numburru-wijangayii. Numburru-wijangayii na-God-jinyung, ni-Buunggawa, marri nigawi-nyinyung warru-mandag. Marri numburru-wijangayii anubani-yung nani-ngaynbandii-yinyung, numburraaṉbina yadhu. Marri nani-warriiyii anubani anaaynba-gaynbaj-jinyung nurraarra-ngaynbandii-yinyung nugurru. ");
INSERT INTO nuy_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Yagi anaagaray yungguyung nirriijanga-yangi ana-yimbaj. Agaray marri bani-yung numburru-wijangang. Yagi nurru-wurrij-galadi-wi anaagaray yungguyung, marri ana-yimbaj ngijang.” Dani-yung na-Jesus ni-yambini, ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Na-Jesus naagi-yung ni-yambini-wugij. “Nugurru aadanu, yagi narra-lhajbu, na-God nani-lhajbu-magi nugurru. ");
INSERT INTO nuy_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nambarra-nguynju-nguynjijgana-maynji warra-mulung-aynbaj, anggiiyn-nguynju, na-God nambani-nguynju-nguynjijgana nugurru, anggiijamana.” ");
INSERT INTO nuy_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Naagi-yung na-Jesus niga ni-yambini-wugij. “Yagu nugawi-nyinyung-maynji na-guwaj anaaban-binyig-maynji aniwu-waṉagana niga mana-bagaḻang-duj, yagu nagang banu-bagaḻang-nayii manubami nigawi-nyinyung mana-bagaḻang. Yagu waari nagang ba-marrbuy-mang aadanu nagang nunggu-waṉagana runggal-windiyung rangag nugawi-rruj mana-bagaḻang-duj! Marri yuga anubani-yung ba-yaminggarrang? ");
INSERT INTO nuy_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Marri a-yangi yungguyung nunu-yambina aadanu nugawi-nyinyung na-guwaj, ‘Guwaj, anubani-yung maadamu ngama-ngarrgiwang mana-mangarag nugawi-wala mana-bagaḻang-gala.’ Aadanu nuynjamana. Yagu yagi nagang nunggu-ni anubani ana-rangag nugawi-rruj wu-burraa mana-bagaḻang-duj. ");
INSERT INTO nuy_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nagang yamba aadanu nundaambaḻaman-gina windiyung! Ana-wulhu-wulhurr wurrugu bawu-ngarrgiwang nugawi-nyinyung-gala mana-bagaḻang-gala ana-rangag, nguynju yadhu baarranggana maaḻamburrg yadhu, nguynju anubani-yung bama-ngarrgiwang manubama mana-mangarag nugawi-wala na-guwaj-gala mana-bagaḻang-gala.” ");
INSERT INTO nuy_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Naagi-yung na-Jesus ni-yambini-wugij. “Anubani-maynji ana-maṉngulg-jinyung nurraarra-waṉagana-yinyung, yagi nurraarra-yu waa-ḻandhurrg. Marri anubani anaambaḻaman-jinyung yagi nurraarra-ngu-barawudi ana-bigi-bigi-wuy. Anubani ana-bigi-bigi arragarra-wan.ngana anubani-yung mun-mirri, marri anggaagiyn marri nambanggu-wangana nagang.” ");
INSERT INTO nuy_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Naagi-yung na-Jesus ni-yambini-wugij. “Nugurru-maynji anubani-yung numbunu-yandhawiwanjii-maynji nigawi-wuy na-God-guy, marri anubani-yung nambaniiyn niga. Numburraagalhaga-lharrmani-maynji anubani-yung anaaynbaj nigawi-wala na-God-gala, marri anubani-yung nimbirri-lhangarrmang wugurru aḏaba. Yagu nugurru-maynji nimbirri-waḏbaḏang-maynji anu-dhawang nugurru na-God-jinyung marri anubani-yung niga nambanii-ngu-gara-wawalhijgang aḏaba. ");
INSERT INTO nuy_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Warrubawi-yung-maynji ambunu-yandhawiwanjii-maynji niga, marri anubani-yung ambaniiyn aḏaba. Marri warrubawi-yung-maynji amburraagalhaga-lharrmani-maynji anubani anaaynbaj nigawi-wala na-God-gala, bani-yung marri ari ambirri-lhangarrmang wugurru. Marri warrubawi-yung-maynji ambirri-waḏbaḏang anu-dhawang na-God-jinyung, marri bani-yung nga ambanii-ngu-gara-wawalhijgang niga. ");
INSERT INTO nuy_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Nugurru aadanu, na-wirrinyung-maynji anubani-yung ani-yandhawiwang ana-marrya, yuga nagang banuuyn mana-ṉuga? ");
INSERT INTO nuy_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ngijang ani-yandhawiwanjii-maynji ana-ngujija, yuga nagang banuuyn marryn? Waari! ");
INSERT INTO nuy_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nugurru nurraalaaladi aadanu. Yagu nugurru nurru-marrbuy aadanu, narriiyii-yinyung anubani anaambaḻaman-jinyung, nugurri-nyinyung-guy warra-mijburrayung-guy. Aadanu nugurru numburru-marrbuy aḏaba anubanila-wala, nuwaagi na-Baba anaarrwar, ni-mamanunggu-windiyung. Anubani-yung-maynji numbunu-yandhawiwanjii, anubani nambaniiyii anaambaḻaman-jinyung wugurru.” ");
INSERT INTO nuy_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Naagi-yung na-Jesus ni-yambini-wugij niga. “Na-Moses marri warruburru-yung wunaa-ja-jambini-yinyung na-God anu…bani-yunggaj, wugurri-nyinyung anaarrawindi ana-lhaawu, anaani wiijamana. Nambarra-maṉmani warra-wurru-wurruj, nguynju narra-ngaynbandii nambambi-maṉmani nugurru aadanu.” ");
INSERT INTO nuy_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Naagi-yung na-Jesus ni-yambini-wugij. “Anaani ngana-magana nugurru. Anubani anu-dhawang a-ngura-wuy, wu-walbalg. Marri manubami manaadi maadi-wandhurrg. Arrawindi warra-wurru-wurruj wurru-yaarri manubami-waj manaadi, yagu wurru-yaarri a-ngura-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Yagu anubani anu-dhawang ana-wiri-wuy, wu-jiibug. Marri ma-jiibug manubama-yung manaadi, maadi-yaarri, maadi-yuḻug, ana-wiri-wuy. Waari warraarrawindi wurru-rumi manubami-rruj manaadi. Nugurraayunggaj aadanu numburru-yaarri manubami amaadi-ngu-jiibug-guy aadanu.” ");
INSERT INTO nuy_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Naagi-yung na-Jesus ni-yambini-wugij. “Warra-mulung-arrgi warra-wurru-wurruj yingga nambi-dhaayurrii. Wurru-yamaa, ‘Anaani ana-lhaawu na-God-jinyung,’ yagu waari aniijgubulu-magaa. Nugurru aadanu numburru-dhi-maṉdhina, yagi nurru-wawanggi wugurri-wuy. Warraawurru warra-wurru-wurruj yingga wugurru wurru-yamana nguynju a-jib-jii wurru-yamana, yagu warraawurru-yung yijgubulu wurru-yamana nguynju yaga waa-nunggarrang-jii! Warrubawi-yung waa-nunggarrang yaga wu-marryaadii, nga waa-raga-raguna a-marrya-waj, a-lhanggu-waj. Aadani-yung-jii wurru-yamana wugurraayung warra-wurru-wurruj.” ");
INSERT INTO nuy_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","“Anaani ngana-magana nugurri-wuy. Nugurru numburru-marrbuy warrubawi-yung warra-wurru-wurruj na-God-gala yagu wugurraayung nambi-dhaayurrii-yinyung. Numburru-marrbuy wurru-waṉbina-wala. Anaani wiijamana. Manubami mana-miḏaaburruburru waari waṉagang mana-mango mana-ma-ngu-jang. Ana-rawurrumugurrumu waari waṉagang mana-banana. ");
INSERT INTO nuy_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Anubani-yung anaambaḻaman-jinyung waanuynjungina-yinyung arra-waṉagana arraambaḻaman-jinyung marrya. Anubani waanuynjungina-yinyung wu-lhangurrnganjii-yinyung, ana-rangag-aladi, waari waṉagana ana-marrya. ");
INSERT INTO nuy_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Anubani anaambaḻaman-jinyung waanuynjungina-yinyung yagi waṉagi anaaladi ana-marrya. Anubani ana-rangag-aladi yagi waṉagi anaambaḻaman ana-marrya. ");
INSERT INTO nuy_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Anubani-yung-maynji ana-rangag yagi waṉagi ana-marrya, anubani ambii-rangag-guldhii marri ambirri-nangana anu-ḏangag a-ngura-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nguynju wudani-yung-jii, nugurru numburru-marrbuy warrubawi-yung warra-wurruj waaṉbina-yinyung ana-maaḻamburrg, nguynju wubani a-marrya-yii yaga waṉagana a-rangag marri waanuynjungina marri warra-ngugulmung-jaljirraa.” ");
INSERT INTO nuy_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Na-Jesus naagi-yung ni-yambini-wugij. “Numburru-yamana-maynji ngayawi-wuy, ‘Buunggawa! Buunggawa!’ ari nugurru yagi nani-waṉagi na-God, nigawi-nyinyung warru-mandag. Nugurraayung waari nurru-yambi-wugij ngayawi-wuy. Nugurru numburru-waṉbina anubani nani-ngaynbandii-yinyung na-Baba anaarrwar. ");
INSERT INTO nuy_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wurrugu marri, anubani-yung-maynji ngaya anamba-nguynju-nguynjijgana, ngarrubagi-rruj ngarraaḻirr, arrawindi warra-wurru-wurruj amburru-yambina, ‘Buunggawa! Buunggawa! Nurru ngunaa-jambini, nurru-yambini nugawi ana-muwaj. Nurru narra-ngu-barawudangi ana-man.gurrg, nugawi-wala a-muwaj. Marri nurru-waṉbini arrawindi aynba-gaynbaj-jinyung a-lhuḏ-jinyung nugawi-wala a-muwaj,’ amburru-yamana, warraarrawindi. ");
INSERT INTO nuy_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yagu warruburru-yung ngamba-yambina, anaani anggiij-garrarra. Ngaynjamana, ‘Aadanu ngaya nga-maḻaḻadi nugurru. Numbuu-ngarra-jaarri aḏaba ngayawi-wala, nugurru nurru-waṉbini yamba aladi!’ ngaynjamana, ngamba-yambina wugurru.” ");
INSERT INTO nuy_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Naagi-yung na-Jesus ni-yambini-wugij. “Wudani-yung-gala, nugurru-maynji nimbirri-yaynjangayii anaani ana-lhaawu ngayawi-nyinyung, nga nimbirri-yandhurrbangana, nugurru numburru-yamana nguynju na-yina-mamaaḻang-jung-jii. Nubagi na-waḻyinyung niwu-majgaa wumurrng, ama-mangarag-duj aaban-mamaaḻang-duj. ");
INSERT INTO nuy_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nga ngarraaṉbana ngi-warra-rabini nga mana-ngugu maarrangi nga anubani-yung ana-wudhanguyn angaḏajung waabuyaani. Waari anggu-rabini, anubani ana-wumurrng, wugurru yamba anubani-yung wu-lhaay wubani aaban-mamaaḻang-duj.” ");
INSERT INTO nuy_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Yagu numburraawanggina-maynji ngayawi-nyinyung ana-lhaawu nga yagi nirri-yandhurrbi, nugurru numburru-yamana nguynju nubagi na-yilg-jung-jii. Nubagi na-yilg-jung na-waḻyinyung, anaaban-galadi-rruj niwu-lhangijgayn nigawi-nyinyung ana-wumurrng. ");
INSERT INTO nuy_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ngarrubagi ngarraaṉbana ngi-warra-rabini marri mana-ngugu maarrangi, nga anubani ana-wudhanguyn angudu waabuyaani. Waari anubani anggu-lhaay, anubani wu-jadugiiyn, ana-wumurrng, wu-rabini wugurru.” ");
INSERT INTO nuy_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Danilayung-galawaj na-Jesus ni-yambini ni-yamaa, na-nidhaawu-yung. ");
INSERT INTO nuy_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Anubanila, warruburru-yung warra-wurru-wurruj wurru-wurrij-gaḻaaḻarriyn wudani-yung-gala ni-yambini a-lhaawu, anaani yamba ni-yambini nguynju yaga ni-ragaana-yii. Wani-magaa warruburru-wuy, “Anaani aḏaba numburru-waṉbina yungguyung,” ni-yamaa, waari waadurru-yung-jii warra-yiyini-yinyung ana-lhaawu-runggal wugurri-nyinyung. ");
INSERT INTO nuy_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Aḏaba na-Jesus ni-yanggi, ni-dhirridangi waaban-budii-wala, mulung-dhabarrj warra-wurru-wurruj wunu-garrindharrmangi niga. ");
INSERT INTO nuy_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Aḏaba naagi-yung na-waḻyinyung ni-warra-guṉḏa-guṉḏa naagi-yung, ni-yanggi buguni na-Jesus-guy. Ni-ḻandharrdhangayn marri ni-yamayn, “Yuga nagang ngaya nunggu-ngaynbandii-maynji, baaṉiyn aḏaba nimba-maji-wang ngaya anaani.” Dani-yung niga ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nigaayung naagi-yung na-Jesus ni-marang-dhaayiyn aḏaba nga nu-waṉagayn. “Yuu, ngaya anaani ngawu-ngaynbandii. Nagang ba-maji-mang aḏaba,” ni-yamayn. Lhugaajgiyalawaj naagi-yung na-waḻyinyung ni-maji-mayn anubanila-wala anu-dhangurrg-gala. ");
INSERT INTO nuy_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Aḏaba na-Jesus ni-yamayn nigawi-wuy. “Yagi warruburru barra-magi warra-mulung-aynbaj. Anubani-yung ba-yaarri nubagi-wuy na-priest-jung-guy, marri anubani-yung banu-bajiyina. Marri banuuyn na-God anubani ana-bayarra na-Moses-jinyung wani-magaa-yinyung, nguynju warruburru-yung warra-wurru-wurruj amburru-marrbuy. Dani-yung baaṉbina,” ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Anubanila-wala, na-Jesus ni-yanggi a-wumurrng-guy a-Capernaum-guy. Nubagi-yung wurrujung bagu niga ni-burri, Roman-jung wurrujung, wurru-wiynji-wiynjini-yinyung. Naagi-yung ni-runggal niga. Naagi-yung ni-yanggi nigawi-wuy na-Jesus-guy, nu-yandhawiwaa anu-maṉmangi yadhu. ");
INSERT INTO nuy_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ni-yamayn, “Buunggawa, ngayawi-nyinyung nganii-mijgalmina-yinyung ni-murrgulhaa anga-rruj. Niga waari ani-wirbiriyn marri niga ni-warragayii-windiyung,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nigaayung na-Jesus ni-yamayn, “Ngaya anaani ngaynjaarri marri nganu-maji-wang niga,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nigaayung na-Roman-jung na-waḻyinyung ni-yamayn, “Buunggawa, ngaya anaani waari ngaṉḏunggal-magaa, yagi nagang nuṉḏumi ngayawi-wuy anaanga. Anaani ba-yambina lhaawu-wugij, nga anubani-yung ani-maṉdhiiyn niga, nubagi-yung ngayawi-nyinyung na-guwaj. ");
INSERT INTO nuy_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Anaani ngaya yamba nga-marrbuy nagang, ngaya yamba na-nguynju nugawi-yii anaani. Yagu warruburru-yung wurru-buunggawa-mana-yinyung, anaani ngarra-yandhurrbangana ngaya. Yagu warruburru-yung wurru-wiynji-wiynjina-yinyung warruburru-yung ngambi-yandhurrbangana ngaya. Ngaya nganu-magana nubagi naaynjaabu-nyung-guy ‘Ba-yaarri,’ nubagi-yung ni-yaarri niga. Nubagi-yung nganu-magana naaynbajung ‘Baaṉiyn,’ nubagi-yung ni-yaarri ngayawi-wuy niga. Marri nubagi-yung ngani-yandhurrbangana-yinyung anubani-yung ‘Baaṉbang,’ marri anubani-yung nganii-gaṉbina niga.” Dani-yung ni-yamaa na-runggal-yung, ni-marrbuy yamba niga, nubagi na-Jesus niwu-waṉagaa lhuḏ-bindiyung. ");
INSERT INTO nuy_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nigaayung aḏaba na-Jesus anubani-yung ni-waḻaaḻarriyn-bindiyung. Naagi-yung wani-magayn warruburru-yung-guy wurraanggaanggarra-yanggi-yinyung niga, “Ngaya anaani ngana-magana nugurri-wuy, yijgubulu-windiyung, waari ngaya anaaji ngamba-nani warra-wurruj nguynju naadagu-yung-jii ni-jambarrgina-yii. Wugurraayung warruburru-yung warra-Jew, warruburru-yung waari ngaya ngambambii-ngu-jambarrgini nubagi-yung-jii.” ");
INSERT INTO nuy_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Arrawindi warra-wurru-wurruj amburru-yaarri anubanila-wala ana-ramalila-wala marri arrgaḻila, marri anaarrawindi-lhangu-wala ana-lhal, amburru-burraa amburru-nguyii wugurri-rruj na-Abraham, na-Isaac marri na-Jacob ana-lhal anaarrwar. ");
INSERT INTO nuy_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Yagu wugurraayung warra-mulung-aynbaj, warruburru-yung warra-Jew, anubani-yung ana-lhal-uj-jinyung, ambani-barawudang arabarabalu waangudumana-wuy. Anubagu warruburru-yung amburru-ruguna marri amburru-ra-bangaynjina amburraarragayii yamba wugurru.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Aḏaba na-Jesus ni-yamayn na-waḻyinyung-guy, “Ba-yaarri aanga-wuy. Nugawi-nyinyung ninii-mijgalmina-yinyung ni-maji-mayn anubani-yung nguynju-waj nagang nu-ngu-jambarrgiiyn,” ni-yamayn. Nigawi-nyinyung naa-mijgalmini-yinyung ni-maji-mayn anubani-yung aḏaba. ");
INSERT INTO nuy_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Aḏaba na-Jesus ni-yanggi na-Peter-yinyung-guy a-wumurrng. Niga ngu-nani anubani-yung na-Peter-yinyung nga-ranggurrumbayung ngi-murrgulhi ama-yaaḻi-rruj, ngarraagi-yung ngi-lhangurrngang, marri ngi-warra-murrmbulangi ngiga. ");
INSERT INTO nuy_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nigaayung na-Jesus ngu-waṉagayn ngiga a-marang-duj marri ana-wudhangurrg nginggaarruyn ngiga. Aḏaba ngiga ngi-ḻaḻagiiyn marri ngiga-waj ngunu-yayn ana-marrya, ni-nguni-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Wurrugu marri, anubani-yung waamulugugurriyn. Anubani-yung warra-wurru-wurruj warra-yarrijgini na-Jesus-guy arrawindi warruburru-yung wirri-waṉagaa-yinyung ana-man.gurrg. Na-Jesus ni-yambini lhaawu marri ana-man.gurrg wanggaarruyn wugurru. Marri niga wani-maji-waa arrawindi wurru-wudhangurrg-maa-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Niga ni-waṉbini anaarrawindi-lhangu, God yamba niga-waj ni-yambini anu…bani-yunggaj. Nubagi naa-ja-jambini-yinyung na-Isaiah, ni-yamayn, “Niga ngarranii-jarini ngagurri-nyinyung anu-dhangurrg, niga marri ngarranii-jarini ngagurri-nyinyung anaalaaladi-yinyung.” ");
INSERT INTO nuy_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Aḏaba na-Jesus wani-nani mulung-dhabarrj wunu-dhawawarumaa niga, niga wani-magaa nigawi-nyinyung wurru-marrbuy-maa-yinyung, “Ngaambu-yaarri wagagala-wuy a-wurugu,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aḏaba nubagi-yung wani-yiyini-yinyung a-lhaawu-runggal, ni-yanggi na-Jesus-guy marri ni-yamayn, “Barra-yiyina-yinyung, ngaya anaani wa-garrindharrmani-wugij, nagang anaaynbaj-guy ana-lhal nagang-maynji ba-yaarri,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nigaayung na-Jesus ni-yamayn, “Warrubawi-yung yaga waa-nunggarrang wu-riganjii wirri-gara-yungana a-gara, wu-gaadhina yaga. Wugurraayung yaga ana-ngurudhu anubani-yung wu-wayayarrii. Yagu anaani ngaya, na-Niwiyayung na-Wurrujung-jinyung, waari ngaya nganggu-waṉagang anaanga. Waari anaanga nga-yingi-yinyung ngaya anaani.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Aynbajung waḻyinyung, ni-marrbuy-maa-yinyung na-Jesus, ni-yamayn nigawi-wuy, “Buunggawa, ana-wulhu-wulhurr ngaya ngaynjaarri yuuguni wurrugu nganu-wurrdhii ngayawi-nyinyung na-baba, marri bani-yung nga ngaya wa-garrindharrmang,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yagu nigaayung na-Jesus nu-magaa niga, “Numba-garrindharrmani ngaya. Wugurraayung warruburru-yung yaga wurru-ngawina, burru-yung aḏaba wugurru ambarra-wurrdhii warruburru-yung wurru-ngawina-yinyung, aḏaba wiiya.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Anubanila-wala, niga na-Jesus ni-yabaynjiyn ama-barrawu-wuy marri nigawi-nyinyung wurru-marrbuy-maa-yinyung wuu-ngarra-jabaynjiyn. ");
INSERT INTO nuy_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na-Jesus niga ni-yingayn aḏaba. Wurru-waya-wayamangi… nga yingga anubagu ana-bandharra. Wu-yanggi anuwaagala anubani wuwalulu wu-waḻadhi. Anubani-yung wanggu-miyn bandharra. Anubani-yung waar-yabaynjini anaa-gugu. ");
INSERT INTO nuy_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Warraawurru-yung wugurru wurru-wuwaḻgayn marri bagu wunu-marayanggaa. Wurru-yamayn “Buunggawa! Numba-wiri-gang nurru! Ngagurru ngaambu-ngaṉḏina!” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nigaayung ni-yamayn, “Nurru-yaminggarrina nugurru, nurru-ḏirrngawina? Nugurru waari numbuu-jambarrgiiyn,” ni-yamayn. Aḏaba ni-ḻaḻagiiyn marri niwu-yamijgayn ana-wudhanguyn marri anaa-gugu. Anubani-yung ana-wudhanguyn wu-muḏaḏbiyn aḏaba, wugurraayung anubani-yung anaa-gugu waar-yingayn, muḻurrgu maar-yingayn. ");
INSERT INTO nuy_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Wugurraayung warra-waḻya-waḻya wurru-wurri-ḻaḻmayn. Wurru-yamayn “Yangi-nyung yuga naagi na-waḻyinyung naagi? Nguynju-waj anu-dhanguyn marri anaa-gugu ninggu-yandhurrbang niga!” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Anubani-yung wurraagaḻawajangi wagagala-wuy, wubani a-lhal wirri-mayaa Gadara. Wurru-waliyn aḏaba. Nga wini-wulawaa waḻya-waa wini-yanggi yuwaagala ama-gara-wala, manubami warra-wurrdhu-wurrdhangi-yinyung. Naawiṉi-yung wini-waṉagaa man.gurrg wuguṉi-rruj. Wini-wungarri wini-burri, warra-wurru-wurruj waari ambuu-yaḻdhangi anubanila-yung. Naawiṉi-yung wunu-lhangarrmayn niga. ");
INSERT INTO nuy_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Wuguṉi winiiḏangi, “Yagu a-yangi yungguyung niiṉi, anubagala nimba-warubaj-gayn niiṉi, na-Niwiyayung na-God-jinyung? Yuga nagang numbaaṉiyn numbaarragayijgang niiṉi raga-ragij anubani-yung ngaambani-nguynju-nguynjijgana na-God?” wini-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Warubaj anubani ana-lhal, anubagu mulung-dhabarrj bigi-bigi arra-nguni ana-maḏa. ");
INSERT INTO nuy_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ana-man.gurrg ninggu-yandhawiwaa na-Jesus, “Nagang-maynji numba-man-jarramijgang nurru, nimba-lharrgang nurru wubani-wuy a-bigi-bigi-wuy,” wu-yamayn ana-man.gurrg. ");
INSERT INTO nuy_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nigaayung na-Jesus ni-yamayn, “Numburru-yaarri!” Yagu anubani-yung ana-man.gurrg wanggaarruyn na-waḻya-waa marri wu-ngarra-janggi buguni a-bigi-bigi-wuy. Aḏaba anubani-yung bagala nga waagulhaynjiyn yuuguni a-dhirridhirrig-guy marri wu-ngarra-ngalbawaḻgayn wubani-wuy aa-gugu-wuy. Marri anubani-yung wu-warra-ngaṉḏini wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bagu warruburru-yung warra-waḻya-waḻya wurru-ranga-rangarrangi-yinyung anubani-yung ana-bigi-bigi. Warruburru-yung wuu-yarramayn nga yuuguni wubani-wuy a-wumurrng-guy wubani a-runggal, warra-magaa anubani-yung anaarrawindi-lhangu anaani-yung marri anubani-yung wu-waṉbini na-waḻya-waa-wuy wurru-waṉagaa-yinyung ana-man.gurrg-gaang. ");
INSERT INTO nuy_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Aḏaba warraarrawindi-lhangu anaanga-wala wurru-yanggi na-Jesus-guy. Aḏaba wugurru wunu-nani niga. Wugurru wunu-yandhawiwaa, “Bawaarruyn nurri-nyinyung ana-lhal,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Anubanila-wala, na-Jesus ni-yabaynjiyn ama-barrawu-wuy marri niigiyn nigawi-nyinyung-guy a-lhal a-Capernaum-guy. ");
INSERT INTO nuy_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Wugurraayung yuwaagala waḻya-waḻya wurru-yanggi na-Jesus-guy. Nga nubagi-yung wunu-warrgaay bilwilwilijung, waari naagi ani-yangga-yanggi, ni-murrgu-murrgulhi-wugij ama-yaaḻi-rruj. Na-Jesus nigaayung ni-marrbuy waadurru-yung wurru-jambarrgiiyn. Nga nu-yamijgayn na-waḻyinyung, “Guwaj, ba-lhamaamura, aḏaba nagang aadanu nundaarrbidi-mayn aadanu-wala anaaladi,” ni-yamayn niga, nu-yamijgayn. ");
INSERT INTO nuy_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mulung-arrgi-yung warra-yiyini-yinyung ana-lhaawu-runggal wurru-yamayn wugurraajbaj, “Naagi naaladi-yamawana na-God!” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nigaayung na-Jesus ni-marrbuy wugurri-nyinyung wurru-wijangani-yinyung. Naagi-yung ni-yamayn “A-yangi yungguyung nugurru aadanu nurru-wijangayii anaaladi-wuy anubani-yung? ");
INSERT INTO nuy_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Anaani ngaya nga-yambini, ‘nagang nundaarrbidi-mayn anaaladi-wala,’ danu nga aniij-garrarra. Yagu ngaynjamang-maynji ‘ba-ḻaḻagiiyn marri ba-jarrarrang,’ danu nga aniij-miḏaamimi ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Aadanu nugurru numburru-marrbuy-mana. Ngaya-waj nga na-Niwiyayung na-Wurrujung-jinyung, ngawu-waṉagana anaani lhuḏ-bindiyung anaani-rruj ana-lhal, nguynju yadhu ngambaagajij-garruna warra-wurru-wurruj anaani anaaladi-wala.” ni-yamayn, nga nu-yambini naadagi-yung na-bilnyalga-yung-guy, “Ba-ḻaḻagiiyn, nga ba-jarrarrang bama-warrgurrang maadamu mana-yaaḻi, ba-yaarri aanga-wuy,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nigaayung ni-ḻaḻagiiyn, aḏaba ni-yanggi aanga-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Aḏaba warra-wurru-wurruj wunu-nani anubani, wugurru wurru-wurrij-gaḻaaḻarrangi, marri wunu-warraarriwaa na-God niga yamba waniini aniijiijung ana-lhuḏ warra-wurru-wurruj-guy. ");
INSERT INTO nuy_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Aḏaba na-Jesus ni-yanggi, niga nu-nayn waḻyinyung na-nimuwaj-jung Matthew ni-bu-burri wubani yaga wirriirrarrangi-rruj, a-tax niwu-manga-mangi-yinyung anu-ṉuga. Niga na-Jesus ni-yamayn nigawi-wuy. “Numba-garrindharrmang ngaya,” ni-yamayn. Nigaayung ni-ḻaḻagiiyn marri nu-garrindharrmiyn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nguynju-waj na-Jesus ni-nguni na-Matthew-rruj a-wumurrng, arrawindi wirri-manga-mangi-yinyung anu-ṉuga marri warraalaaladi-yinyung wurru-waṉiyn marri wurru-nguni na-Jesus-duj marri nigawi-nyinyung wurru-marrbuy-maa-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Aḏaba warra-Pharisee warra-nani anubani, wugurru warra-yandhawiwaa na-Jesus-inyung wurru-marrbuy-maa-yinyung, “Ni-yaminggarrina, nugurri-nyinyung nani-bajiyina-yinyung ni-nguyii waadurru-rruj wirri-mana-mani-yinyung anu-ṉuga marri warraalaaladi-rruj?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Nigaayung aḏaba na-Jesus ni-wawanggiyn wugurri-wuy, niga ni-yamayn, “Nugurru numburru-wijangayii nubagi wani-maji-wana-yinyung na-wurrujung. Niga waari ambani-nang warruburru-yung wurru-waḏa-waḏaḏ-mi-yinyung. Niga wani-nayii warruburru-yung wuu-lhangurrnganjii-yinyung, burru-yung-bugij. Ngaya anaani ngana-magana anaani-yung. Ngaya nga-yanggi anaanu-wuy, waari-yinyung warra-mamanunggu-yinyung. Ngaya nga-yanggi, ngambaa-gaḏii yungguyung warruburru-yung warraalaaladi-yinyung ngayawi-wuy. Nugurru warra-Pharisee, numburru-yaarri marri numburru-marrbuy-dhina anubani-yung anaani wu-yamana ana-wubiba-rruj, God ni-yamaa, (Hosea 6:6) ‘Ngaya ngana-ngaynbandii nugurru nambarra-man.galagana, yagi nurru-ni ana-bulugi.’ ” Dani-yung ni-yamayn na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Anubanila-wala, warruburru-yung wurru-marrbuy-maa-yinyung na-John-jinyung wurru-yanggi na-Jesus-guy marri wurru-yamayn, “A-yangi yungguyung nurru marri warra-Pharisee waari naambu-ngang ana-marrya, nuunu-yambina na-God-guy, yagu nugawi-nyinyung wurru-marrbuy-mana-yinyung, waadurru wurru-nguyii-wugij?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nigaayung na-Jesus wani-yambalmayn, “Anubani-yung-maynji nubagi-yung ambunu-marangiiyn-maynji na-waḻyinyung, marri anubani-yung amburru-nguyii ana-marrya, amburru-waḻaaḻarrii, yagi wurru-wurrij-galadi-wi, amburru-nguyii-wugij. Yagu wurrugu, nubagi-yung-maynji warra-mulung-aynbaj warruburru-yung ambunu-yarrijgina nubagi-yung naaynji-maṉinyung, bani-yung marri amburru-wurrij-galadi-wina, yagi wurru-ngi anubani-yung ana-marrya.” ");
INSERT INTO nuy_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Waari warraaynbaj wirrima-warrgi mana-yaaḻi manubama-yung mana-nungguḏaaba, wirrima-dhabiḏbu mana-magadhuwa mana-yaaḻi. Ba-waṉbina-maynji, manubama-wuy mana-nungguḏaaba-wuy, manubama-yung ama-ḻaḻmang mana-nungguḏaaba, ma-lhar-ninig yamba.” ");
INSERT INTO nuy_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Nguynju-waj, warra-wurru-wurruj waari ambirriir-warryangi ana-gadhuwa anu-gargayag anubuguni mana-nungguḏaaba-wuy mana-big-guy. Anubani-yung-maynji numburru-waṉbina, manubami mana-big ama-ḻaḻmang, anu-gargayag anaani anggaar-warrina marri anu-gargayag marri mana-big amaaladi. Yagu anubani anu-gadhuwa anu-gargayag wirriir-warryii ama-gadhuwa-wuy ama-big-guy. Aḏaba wuguuguni anggu-mamanunggu-mana.” ");
INSERT INTO nuy_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Naagi-yung na-Jesus ni-yambini-wugij, nubagi-yung ni-ragaani-yinyung ni-yanggi nigawi-wuy. Niga ni-burrdangayn raga-ragij na-Jesus-duj marri ni-yamayn, “Ngayawi-nyinyung ngarra-ngarriyi ngi-ngawiiyn aḏaba. Yagu nagang-maynji baaṉiyn marri bangu-waṉagang nugawi-nyinyung-mirri marang, ngiga angi-wiri-mang ngijang,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yagu na-Jesus marri nigawi-nyinyung wurru-marrbuy-maa-yinyung wurru-ḻaḻagiiyn marri wurru-yanggi nigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Aḏaba maṉinyung ngarrubagi-yung nginggu-lhangarrmayn wulang maadbarrwini. Anaani-yung 12 anaagalhal-aḻirr. Ngiga ngi-yanggi adhaadharri na-Jesus-duj marri ngima-dhi-baṉagayn, nigawi-nyinyung mana-yaaḻi, ni-yabini-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ngiga ngi-wijangani, “Ngaya-maynji ngama-waṉagang nigawi-nyinyung mana-yaaḻi, ngaya nga-maji-mang,” ngi-wijangani. ");
INSERT INTO nuy_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nigaayung na-Jesus ni-wiḻibiḻingiyn marri ngu-nayn ngarra-maṉinyung marri ni-yamayn, “Ba-lhamaamura, ngarriiyi. Nagang yamba nu-ngu-jambarrgiiyn ngaya, aadanu aḏaba nu-maṉdhiiyn nagang,” ni-yamayn. Ngarraagi-yung ngarra-maṉinyung ngi-maji-mayn anubani-yung aḏaba. ");
INSERT INTO nuy_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Na-Jesus ni-yanggi-wugij, nga ni-waliyn anubagu ni-ragaani-yinyung a-wumurrng-guy. Anubagu niga wani-nani wurraayigini-yinyung marri arrawindi warra-wurru-wurruj wuu-ruguni… wurraalgarra-rawaynjini wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Naagi-yung ni-yamayn, “Numburru-yaarri. Ngarra-ngaḻaynjinyung waari angi-ngawini, ngiga ngi-yingayn,” ni-yamayn. Yagu warraawurru-yung wunu-rajburrnani niga. ");
INSERT INTO nuy_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nigaayung wani-lharrgang warra-garnyirrimba yuuguni arabarabalu-wuy. Niga ni-yanggi buguni a-wumurrng-guy marri ngu-marang-miyn ngigawi-nyinyung ana-marang marri ngiga ngi-ḻaḻagiiyn, ngi-lhangayn. ");
INSERT INTO nuy_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ana-lhaawu anubani-yung anaani wu-rajaarriyn anaarrawindi-lhangu-waj ana-lhal. ");
INSERT INTO nuy_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Aḏaba na-Jesus ni-yanggi anubagala. Naawiṉiiyung wini-wulawaa ba-galadi-waa waḻya-waa wunu-garrindharrmangi niga. Wuguṉi winiiḏangi, “Nimba-maji-wang niiṉi, nagang na-niwiyayung na-David-jinyung!” wini-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Wurrugu nigaayung na-Jesus ni-yanggi lhirribala-wuy marri nubiṉi-wuy ni-yamayn, “Yuga nuguṉi niini-jambarrgiiyn anubani-yung ngaya anamba-maji-wana?” Wuguṉiiyung wini-yamayn “Yii, Buunggawa.” ");
INSERT INTO nuy_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Aḏaba na-Jesus waani-ba-baṉagayn wuguṉi-nyinyung mana-bagaḻang marri ni-yamayn, “Anubani-yung nuguṉi niini-jambarrgiiyn, bani-yung anggu-waṉbang,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Wuguṉiiyung aḏaba wini-warranggayn. Yagu na-Jesus ni-yambini, wu-waḏa-waḏaḏ ana-lhaawu. “Yagi naani-magi anubani-yung anaani,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yagu wuguṉiiyung wini-yanggi marri winiwu-rajaarrijgayn ana-lhaawu anubani-yung na-Jesus anaarrawindi-lhangu ana-lhal. ");
INSERT INTO nuy_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Anubanila-wala wuguṉi wini-yanggi-wala, mulung-arrgi-yung warra-wurru-wurruj wunu-yarrijgini waḻyinyung na-Jesus-guy. Naagi na-waḻyinyung waari ani-yambini yagu yamba niga ni-waṉagaa man.gurrg nigawi-rruj. ");
INSERT INTO nuy_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nigaayung na-Jesus ni-yamijgayn ana-man.gurrg, ninggaarruyn na-waḻyinyung, nga niga ni-yambini. Wugurraayung warru-mandag wunu-nayn-gala nga wurru-wurrij-gaḻaaḻarriyn, marri wurru-yamayn, “Ngagurru waari ngaanggu-nani aniijiijung anaani-rruj ana-Israel,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Yagu wugurraayung warra-Pharisee wurru-yamayn, “Nubagi-yung na-baḏirrnya-yung, ni-buunggawa-mana-yinyung niga anubani-yung-jinyung ana-man.gurrg-gaang, ninggu-yayn niga ana-lhuḏ, ni-warra-yarramijgana-yinyung ana-man.gurrg-gaang.” Dani-yung wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Anubanila-wala, niga na-Jesus ni-yanggi arrawindi-wuy a-wumurrng, anubani-rruj ana-lhal. Niga wani-yiyini wugurri-nyinyung-duj a-synagog, wani-magaa ana-mamanunggu ana-lhaawu, warruburru-yung-jinyung warru-mandag na-God-jinyung. Marri wani-maji-waa warraarrawindi-lhangu, anaarrawindi-lhangu-yinyung ana-wudhangurrg. ");
INSERT INTO nuy_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Aḏaba niga wani-nani warru-mandag, niga wani-warrngayuyn-bindiyung wugurru yagu yamba wugurru wurru-walharaguni, marri waari ambarra-maṉmangi-yinyung. Wugurru wurru-yamaa nguynju yaga wudanu a-jib-jii, waari yaga warraaynbaj ambu-ranga-rangarrangi-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Na-Jesus wani-magaa nigawi-nyinyung-guy wurru-marrbuy-maa-yinyung-guy. “Warruburru-yung yamba arraarrawindi wurru-wurruj nambi-rangarrii nugurru amburraawanggina-yinyung aḏaba, ana-lhaawu, yagu wurraadharra nambambi-maṉmani-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nugurru numbunu-lhangayaana niga na-God, niga yamba ni-buunggawa-mana warruburru-wuy, nguynju yadhu niga ambani-lharrganjii yungguyung warra-wurru-wurruj, nambambi-maṉmani yadhu nugurru, nambarra-magana warra-mulung-aynbaj ana-lhaawu na-God-jinyung.” Dani-yung ni-yamayn na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Na-Jesus wanii-gaḏangi nigawi-nyinyung warra-12 wurru-marrbuy-maa-yinyung, marri wani-yayn wugurru ana-lhuḏ amburru-man-jarramijgaa yadhu ana-man.gurrg marri ambarra-maji-waa yadhu anu-dhangurrg-gala. ");
INSERT INTO nuy_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yaawurru yigaj warru-mu-muwaj warra-12 wani-lharrgandi-yinyung, wirri-lhaawu-yarrijgini-yinyung. Simon (nguynju-waj ni-mayini na-Peter) marri nigawi-nyinyung na-nilharri-yung Andrew, James na-niwiyayung na-Zebebee-yinyung, marri nigawi-nyinyung na-nilharri-yung na-John. ");
INSERT INTO nuy_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip, Batholomew, Thomas, Matthew, niga niwu-manga-mangi-yinyung anu-ṉuga. James, na-niwiyayung na-Alphaeus, marri Thaddaeus, ");
INSERT INTO nuy_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon Peitriyat marri Judas Iscariot, nubagi-yung anu-minbini-yinyung na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Na-Jesus wani-muṉḏugijgaa warraawurru-yung warra-12, niga wani-magaa. Ni-yamayn “Nugurru numburru-yaarri, ngirrii-jarrijgina ana-lhaawu. Yagu yagi nurru-rumi warruburru-yung-guy waari-yinyung warra-Jew, yagu ana-wumurrng-guy warra-Samaritan-jinyung. ");
INSERT INTO nuy_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Numburru-yaarri warra-wurru-wurruj-guy warra-Israel, warruburru-yung nguynju yaga waaṉibina-yii a-jib-jii. ");
INSERT INTO nuy_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nugurru numburru-yaarri, nambarra-magana anaani ana-lhaawu, aḏaba warruburru-yung warru-mandag anaarrwar-yinyung, amburru-muṉḏugana lhaalhag. ");
INSERT INTO nuy_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nambarra-maji-wana warra-wudhu-wudhangurrg, nambarra-ḻaḻagana ana-ngawij-gala. Nambarra-maji-wana warruburru-yung warraarra-guṉḏa-guṉḏa-yinyung, marri numburru-yarramijgana ana-man.gurrg warra-wurru-wurruj-gala. Ngaya nganambiiyn nugurru ana-lhuḏ arrbidi, nugurru nambarriiyii arrbidi. ");
INSERT INTO nuy_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yagi anaarrgi-yung nurraarra-waṉagi numburru-yaarri-maynji ana-lharug. Yagi anu-ṉuga anaaynba-gaynbaj-jinyung nurru-waṉagi, ");
INSERT INTO nuy_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yagi mana-big, yagi mana-yaaḻi yagi nurru-mun-jabina-yinyung, yagi ana-waaṉḏulu. Nugurru numburru-yamana nguynju wurru-mijgalmina-yii, marri nambambiiyn anubani-yung nurru-ngaynbandii-yinyung.” ");
INSERT INTO nuy_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Anubani-yung-maynji numburru-yaarri anubani-wuy anaanga-wuy, naamba-lhangarrmang mamanunggu wurruj anubagu marri numburru-burraa wugurri-rruj anaanga-rruj baḏag wurrugu. Wurrugu marri, nugurru numburru-yaarri. ");
INSERT INTO nuy_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nugurru numburru-yaarri-maynji anubani-wuy anaanga, numburru-yambina, ‘Lhamaamura nugurri-wuy,’ numburru-yamang. ");
INSERT INTO nuy_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Warra-wurru-wurruj-maynji anubagu nambambi-yabijgang nugurru, marri nugurri-nyinyung ana-lhamaamura anggu-burraa anubagu. Yagu-maynji wugurru yagi nambi-yabijgi nugurru, nimbirriigijgiyn ana-lhamaamura nugurri-wuy.” ");
INSERT INTO nuy_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Yagi-maynji warruburru-yung warra-wurru-wurruj nugurru nambi-ngaynbandi, marri yagi-maynji nambii-gawanggi nugurri-nyinyung ana-lhaawu, anubani-yung nimbirriirruyn ana-wumurrng, numburru-mun-jaljaliyn mana-mangarag nugurri-nyinyung-gala ana-mun, na-God yamba aniwu-lhal-waandirrang ana-lhal. ");
INSERT INTO nuy_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ngaya ngana-magana nugurru yijgubulu-windiyung, anubani-yung na-God ngaambani-nguynju-nguynjijgana-rruj ngarraaḻirr, anubani-yung ambani-man.galagana warruburru-wuy warraalaaladi-wuy anubani-yung-jinyung ana-Sodom marri ana-Gomorrah. Yagu wugurraayung warruburru-yung waari-yinyung nambi-ngaynbandi nugurru, waari wani-man.galagi, wugurri-wuy.” ");
INSERT INTO nuy_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Naagi-yung na-Jesus ni-yambini-wugij. “Numburraawanggina, ngaya anaani ngana-lharrganjii nugurru nguynju yaga a-jib-jii wubani a-ngirri-ngirri-wuy. Yagu numburru-lharu-nina wubani a-maragarrij-jinyung, numburru-yamana wubani-yung-jii a-marryn-jii yagu yagi nurru-maragarrij-mi, numburru-yamana nguynju yi-ḻabarrg-jii. ");
INSERT INTO nuy_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nugurru-waj, numburru-dhi-maṉdhina. Warrubawa-yung nambambi-yarrijgina buguni wuu-yamba-yambiynjina-wuy, bagu nambambi-nguynju-nguynjijgana. Warruburru-yung nambambi-warra-waḏjiwumana nugurru wugurri-nyinyung-duj ana-synagog. ");
INSERT INTO nuy_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Dani-yung amburru-waṉbina nugurri-wuy, nugurru yamba ngirrii-ngu-jambarrgina ngaya. Warruburru-yung nambambi-mang, numburru-lhara raga-ragij warra-bu-buunggawa marri warra-ki-king, nugurru yamba anaani nurru-marrbuy ngaya. Marri nugurru ngirrii-jambina ngaya anaani, nambarra-magana wugurru marri warruburru-yung waari-yinyung warra-Jew wugurraayunggaj.” ");
INSERT INTO nuy_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","“Warruburru-yung-maynji nambambi-bilhargana, yagu anubani yagi nirriijanga-yangi, marri nurru-wijangi, ‘Yuga yangi ngaynjambang?’ Anubani-yung yamba ana-Maṉngulg Mawurr nambangguuyii anaarrawindi-lhangu numburru-yambina-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Waari-magaa nugurri-nyinyung ana-lhaawu, yagu ana-Mawurr nugurri-nyinyung-jinyung na-Ninyarra nambangguuyii ana-lhaawu nugurri-wuy.” ");
INSERT INTO nuy_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Naagi-yung na-Jesus ni-yambini-wugij. “Warruburru-yung warra-wurru-wurruj ambarriiyn warruburru-yung warra-minilharri-yung, wugurraayung ari amburru-ngawang. Marri warra-wurru-wurruj ambarriiyn wugurri-nyinyung warra-mijburrayung. Warruburru-yung mijburrayung wugurraayung, ambarra-wurrij-bangana warra-mininyarra-yung-guy marri warra-mijbiibi-yung-guy, wugurru ambarra-ngawijgang. ");
INSERT INTO nuy_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Warraarrawindi nambambi-wurrij-bangana nugurri-wuy, nirri-waṉagana yamba ngayawi-nyinyung a-muwaj. Yagu numburru-lhara-wugij andhurrg, yagi nurru-lhuṉdhi. Nga anubani anggu-dhaag-mana-rruj, anubani-yung na-God nambani-wiri-gang.” ");
INSERT INTO nuy_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Naagi-yung na-Jesus ni-yambini-wugij. “Warruburru-yung-maynji nambambi-wungarri-dhijgana anaaynjaabugij-duj ana-lhal, numburru-yaarri aaynbaj-guy a-lhal. Ngaya ngana-magana yijgubulu-windiyung, nugurru waari nirri-jadugi numburru-yaarri-yinyung anaarrawindi-lhangu ana-lhal-waj ana-Israel, raga-ragij ngaya-waj ngandaagiyn, ngaya anaani na-Niwiyayung na-Wurrujung-jinyung. ");
INSERT INTO nuy_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Warruburru-yung wugurru wurru-marrbuy-mana-yinyung, yagi warruburru-yung wugurru wunu-magi nubagi-yung-guy wani-yiyina-wuy. Marri warruburru-yung wunu-yandhurrbangana-yinyung nubagi na-buunggawa-yung, warruburru-yung waari wurru-runggal-mi, waari wurru-yami nguynju nubagi-yung-jii na-buunggawa-yung-jii. ");
INSERT INTO nuy_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Anaani wiij-maṉdhina, warruburru-yung wurru-marrbuy-mana-yinyung, amburru-yamana nguynju wugurri-nyinyung wani-bajiyina-yinyung, marri warruburru-yung wunu-yandhurrbangana-yinyung amburru-yamana nguynju na-buunggawa-yung-jii. Anaani wiij-nguynju ngagurri-wuy. Warruburru-yung ngambi-mayana baḏirrnya-yung Beelzebul, nugurru aadanu nambambi-mayana aaladi-windiyung warru-mu-muwaj!” ");
INSERT INTO nuy_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Naagi-yung na-Jesus ni-yambini-wugij. “Yagu yagi nurru-ḏirrngawi warruburru-yung, yagu yamba anaarrawindi-lhangu anubani-yung wu-julubina-yinyung, wurrugu marri anggiij-garrarra-mang wugurru. Marri anaarrawindi-lhangu anubani-yung wu-miḏaamimi anaani amburru-marrbuy-dhina wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ngaya ngana-magana nugurru anaani-yinyung anaarrawindi-lhangu waangudumana, yagu nugurru nambarra-magana wugurru wu-lhalmbaarrii-rruj. Anubani-yung nugurru nurraawanggina nugurri-nyinyung-duj ama-warang, nugurru numburraaḏii anubani ana-wumurrng-gala anaarrwar. ");
INSERT INTO nuy_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Yagi nurru-ḏirrngawi warra-wurru-wurruj-guy. Warruburru ari nambambii-bumana ana-ngun.gu yagu anubanila yagi wurru-waṉbi anaaynbaj. Nugurru numburru-ḏirrngawina na-God-guy, bagi-yung-bugij. Niga ari nambanii-bumana ana-ngun.gu, marri anubanila-wala niga ari nambani-barawudang a-ngura-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Numburru-marrbuy ana-ngurudhu. Numburru-mani-maynji anuulawaa, yagu anubani-yung aynjaabugij winyig wuṉuga. Yagu anaaynjaabugij-maynji anggu-ngawang, God yamba niga ani-wijangayii. ");
INSERT INTO nuy_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Numburraawanggina aḏaba, na-God niga ni-marrbuy manaama mana-mung nugurri-rruj ana-yinag-duj, aynjaaynjaabugij-gaj. ");
INSERT INTO nuy_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yagi nurru-ḏirrngawi nugurru. Anubani-yung ana-ngurudhu, na-God ni-ngaynbandii niga. Nga yagu nugurraayung aadanu niga nani-ngaynbandii runggal-windiyung niga, waari nguynju yaga anaarrawindi ana-ngurudhu-yii.” ");
INSERT INTO nuy_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Naagi-yung na-Jesus ni-yambini-wugij. “Nugurru-maynji ngirrii-jambina ngaya warra-mulung-arrgi-yung-guy, wurrugu marri anaani nganaa-jambina ngayawi-wuy na-Baba-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yagu nugurru-maynji nambarra-magana-maynji warra-mulung-arrgi-yung-guy, numburru-yamana ‘Nubagi niga ngaya nga-maḻaḻadi’, wurrugu marri bani-yung ngaayung nganu-magang ngayawi-nyinyung na-Baba, ngaynjamang ‘Waadurru ngaya nga-maḻaḻadi’. ");
INSERT INTO nuy_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Nugurru ari nurraan-jamana, ngaya nga-yanggi aani-wuy a-lhal-wuy nguynju yadhu numburru-lhambaamburrg. Waari. Anaani nga-yanggi anaani ama-waṉina yungguyung magarrangaynji. ");
INSERT INTO nuy_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ngaya nga-yanggi, ‘Na-ninyarra-yung niga yuuguni ani-waḻgaḻ, yagu nigaayung na-niwiyayung yaanuwuy, ani-waḻgaḻ. Ngarriibi-yung ngiga yuuguni angi-yaarri, ngigaayung ngarra-ngarrimarayung yaanuwuy angi-yaarri. Ngarrubagi-yung ngarra-maṉinyung nga-rangan.ngarri-yung yuuguni, marri ngigawi-nyinyung nga-rangan.ngarri-yung yaanuwuy. ");
INSERT INTO nuy_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nugurri-nyinyung amburraabalguyungaynjina-yinyung, wugurru nugurri-nyinyung warra-mijgalgur!’ ");
INSERT INTO nuy_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Nugurru-maynji aadanu numburru-yaarri ngayawi-wuy, numburru-lhaabina aḏaba na-ninyarra marri nga-rriibi, yagu ngirrii-ḏamarr-ngu-burraa ngaya anaani. Marri nugurru numburru-lhaabina nugurri-nyinyung warra-mijburrayung, yagu ngirrii-ḏamarr-ngu-burraa ngaya anaani. Yagi-maynji nurru-waṉbi aadanu, yagu waari ngayawi-nyinyung-magaa anaani numburru-marrbuy-mang-jinyung ngaya. ");
INSERT INTO nuy_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nugurru-maynji ngirri-garrindharrmani ngaya, anubani-yung nugurru nimbirri-warrgu anu-ḏangag marri bani-yung ngirri-garrindharrmani ngaya. Yagi-maynji nurru-waṉbi aadanu, yagu waari ngayawi-nyinyung-magaa anaani numburru-marrbuy-mang-jinyung ngaya. ");
INSERT INTO nuy_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nugurru-maynji nimbirri-waṉagana-maynji nugurri-nyinyung ana-wiri, yagu anubani-yung nimbirriij-gajarrgang nugurru aadanu. Yagu nimbirriirruyn-maynji nugurri-nyinyung ana-wiri, ngayawi yungguyung, yagu nimbirri-waṉagana yijgubulu-windiyung ana-wiri. ");
INSERT INTO nuy_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Warrubawi-yung-maynji nambambi-walgur-wana nugurru, nguynju-waj ngambi-walgur-wana ngaya, nguynju-waj nubagi-yung ngani-lharrgang-jinyung ngaya, ambunu-walgur-wana niga. ");
INSERT INTO nuy_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Niga na-God wani-bayarra-gana, nigawi-nyinyung wunaa-ja-jambina-yinyung. Marri warrubawi-yung-maynji ambarra-walgur-wana-maynji warruburru-yung, wugurru yamba wunaa-ja-jambina, niga na-God ambani-bayarra-gana wugurraayunggaj, wu-nguynju ana-bayarra wugurru. Marri warrubawi-yung-maynji ambarra-walgur-wana-maynji warruburru-yung warra-mamanunggu-yinyung warra-wurru-wurruj yagu yamba wugurru warra-mamanunggu, niga na-God ambani-bayarra-gana wugurraayunggaj, wu-nguynju ana-bayarra warra-mamanunggu-yinyung wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Anaani ngana-magana yijgubulu-windiyung. Warrubawi-yung-maynji nambambiiyii anaa-gugu nugurru yamba ngayawi-nyinyung, bawi-yung ambirri-waṉagana ana-bayarra.” Dani-yung ni-yambini na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Naagi-yung na-Jesus niwu-jadugayn wani-yambini-yinyung, nigawi-nyinyung-guy warra-12 wurru-marrbuy-maa-yinyung. Anubanila-wala, niga ni-yanggi anubagala, ni-yanggi buguni wubani-wuy a-lhal a-Galilee, wani-marrbuy-waa warruburru-yung warra-wurru-wurruj marri warra-magaa ana-lhaawu na-God-jinyung. ");
INSERT INTO nuy_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nigaayung nubagi-yung na-John nubagi waniimbaambara-ngambijgaa-yinyung niga ni-radbidhi. Niga ni-wawanggiyn ana-lhaawu anubani-yung-jinyung na-Christ ni-waṉbini-yinyung. Naagi-yung wani-lharrgang mulung-arrgi nigawi-nyinyung wurru-marrbuy-maa-yinyung, wurru-yanggi na-Jesus-guy. ");
INSERT INTO nuy_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Wugurru wunu-yandhawiwaa niga, “Yuga nugawaj danu nundhamarriyn-jinyung nagang, na-John yaga ni-yambini-yinyung niga? Yagu nurru namba-rangarrii aynbaj?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nigaayung na-Jesus ni-yamayn, “Numbuu-yaarri numbunu-magang na-John, anubani-yung nugurru nirri-nani-yinyung marri nurraawanggini-yinyung nugurru. ");
INSERT INTO nuy_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Warruburru-yung warra-bagaḻang-aladi-yinyung wurraarranggana wugurru. Warruburru-yung warraarra-wilwilwiluj-jinyung aḏaba wurru-yaarri. Marri warruburru-yung warraarraguṉḏa-guṉḏa-yinyung warruburru-yung wurru-maṉdhini aḏaba. Marri warruburru-yung wurru-wan-mudangi-yinyung aḏaba warruburru-yung wurraawanggina wugurru. Marri warruburru-yung wurru-ngawini-yinyung, warruburru-yung wurru-ḻaḻagini aḏaba. Warruburru-yung warraambaambalalari-yinyung, warraawurru-yung wurraawanggina ana-mamanunggu ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Warrubawi-yung-maynji ngambi-yaynjangayii ngaya marri waari amburru-muḏaḏbang-jinyung wugurru, wurru-wuguuguni-wugij wuu-jambarrgina ngayawi-rruj, bawi-yung nga na-God niga waniigajij-majgana wugurru.” Dani-yung ni-yambini na-Jesus, ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Wugurraayung na-John-jinyung wurru-marrbuy-maa-yinyung wugurru wuu-yanggi. Nigaayung na-Jesus aḏaba wani-yambini warra-wurru-wurruj-guy nubagi-yung-jinyung na-John. Niga ni-yamayn, “Nugurru, a-yangi yungguyung yuga nurru-yanggi nugurru anubani ana-lhal-aṉḏarrg-guy? Yuga nimbirri-nani yungguyung a-maḏa wubani wu-maḏa-wirbirini yadhu? Girrjag nga! ");
INSERT INTO nuy_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Yagu a-yangi yungguyung yuga nurru-yanggi nugurru anubuguni nurru-nani? Yuga waḻyinyung naadagi-yung ni-yabini-yinyung yaaḻi-mamaaḻang mana-yaaḻi? Girrjag! Warruburru-yung wurru-yabini-yinyung magurru mana-yaaḻi-mamaaḻang, warruburru-yung wugurru wurru-burri nubagi-yung-duj anga na-king-duj. ");
INSERT INTO nuy_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","“Marri a-yangi yungguyung yuga anubani nurru-yanggi nurru-nani nugurru? Yuga nubagi-yung niga naa-ja-jambini-yinyung na-God? Yuu! Anaani ngana-magana, naagi-yung niga ni-runggal-windiyung, waari nguynju yaga warruburru-yung-jii wunaa-ja-jambini-yii yaga. ");
INSERT INTO nuy_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Anaani ana-lhaawu waarrarrina na-John-jinyung. Na-God ni-yamayn niga, ‘Ngaya anaani nganu-lharrganjii niga, bagi-yung nga nganii-dhaawu-yarrijgina-yinyung niga ana-raga-ragij nguynju yadhu nagang. Niga manubama-yung animaandhurrg-gana yungguyung nugawi-nyinyung-jinyung manaadi.’ Dani-yung na-God ni-yamaa niga, ni-yambini na-John-jinyung, anaani waarrarrina yamba a-wubiba-rruj.” ");
INSERT INTO nuy_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Na-Jesus naagi-yung niga ni-yambini-wugij. “Ngaya ngana-magana nugurri-wuy, naagi-yung na-John ni-runggal-windiyung niga. Nguynju yaga warruburru-yung warra-mulung-arrgi-yung wurraambuḻwina yaga warruburru warra-mijbiibi-yung-gala, waari ani-yamaa niga. Yagu warruburru warra-wurru-wurruj na-God-jinyung warru-mandag, warruburru-yung wurru-runggal-windiyung, waari naadagi-yung-jii na-John-jii, ambu-yamang. ");
INSERT INTO nuy_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Anubani-yumbaa na-John waniimbara-ngambijgaa nga anubuguni ana-yimbaj, warraawurru-yung warraarrawindi-lhangu wugurru wurru-yaarri angaḏajung warru-mandag-guy na-God-jinyung. ");
INSERT INTO nuy_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Anubani-yunggaj, warraarrawindi wunaa-ja-jambini-yinyung na-God, warra-magaa ana-lhaawu, marri anubani-yung ana-lhaawu-runggal na-Moses-inyung, wanggu-magaa wugurraayunggaj. Wurrugu marri, niga na-John ni-yanggi anubagala, wani-magaa nigaayunggaj. ");
INSERT INTO nuy_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Marri nugurru-maynji numburru-jambarrgiiyn anaani ana-lhaawu, niga na-John niga ni-yamaa nguynju na-Elijah-yii, ana-lhaawu yaga wugurru wu-yamana niga ani-waṉina. ");
INSERT INTO nuy_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nugurru-maynji numburru-wan-bawalhang aadanu, marri anubani-yung numburraawanggina-windiyung nugurru!” ");
INSERT INTO nuy_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Naagi-yung na-Jesus ni-yambini-wugij. “Ngaynjaminggarrang ngaya ngaynjamang nugurri-nyinyung aadanu warra-wurru-wurruj warraarrawindi-lhangu anaani ana-yimbaj? Nugurru nurru-yamana aḏaba aani-yung-jii. Aadanu nguynju nugurru warra-mijburrayung-jii, nurru-yamana. Warruburru-yung yaga wurraambargalii wugurru wubani-rruj wurru-muṉḏugana-rruj marri wurraa-gaḏijgaynjina wugurru, ");
INSERT INTO nuy_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nurru-lhamurrangi-maynji naagi na-lhambiḻbiḻg yagu waari nugurru ngijang numburru-wan.ngaa! Nurru nurru-ruguni yagu nugurru waari numburru-ruguni aadanu!’ ");
INSERT INTO nuy_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Aadanu nugurru nuu-yamana nga. Nugurru nurru-marrbuy, naagi-yung na-John waniimbara-ngambijgaa-yinyung ni-waṉini nugurri-wuy. Malgarrawindi waari naagi-yung ani-nguni ana-marrya yagu ani-waḻ-nguni anu-gargayag niga. Ngijang nugurru aadanu nurru-yamaa aadanu, ‘Niga naagi ni-waṉagana man.gurrg!’ ");
INSERT INTO nuy_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Yagu ngaya anaani, na-Niwiyayung na-Wurrujung-jinyung ngaya, nga-nguyii marri ngaaḻ-nguyii yagu anaani ngaya. Nugurru nurru-yamana aadanu, ‘Ni-wandha-wuguuguni ni-nguyii marri ni-waḻ-nguyii niga marri ni-bungurru-dhina niga, marri wani-walgur-wana warruburru-yung wirri-mana-mani-yinyung ana-tax anu-ṉuga, marri warruburru warraalaaladi-yinyung, wurraalgurmaynjini niga.’ Danu nurru-yamana nugurru. Yagu wugurraayung wurru-marrbuy-yinyung na-God-jinyung, wugurru wurru-marrbuy aniga-yung ana-maaḻamburrg.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Anubani-yunggaj niga na-Jesus ni-waṉbini nigawi-nyinyung aniij-mamaaḻang ana-mulung-arrgi-yung-duj ana-lhal, yagu anubani-yung warra-wurru-wurruj waari amburru-muḏaḏbangi wugurri-nyinyung anaalaaladi-wala. ");
INSERT INTO nuy_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Niga ni-yamayn, “Anubani-yung bani nga anggu-maṉdhina runggal-windiyung anaaladi nugurraa yungguyung aḏaba, ana-Chorazin-duj, ana-lhal, marri nugurraayung ana-Bethsaida-yinyung. Aadanu yamba ngaaṉbini aḏaba bagu yij-mamaaḻang nugurri-rruj. Yagu nugurru waari nimbirriij-garru anubani anaaladi, nurru-waṉbina-wugij nugurru. “Wugurraayung warruburru-yung ana-Tyre-yinyung marri ana-Sidon-jinyung, wiiya wugurru wurraaladi anu…bani-yunggaj. Yagu anubani-yung nganggaṉbini-magaa aniij-mamaaḻang wugurri-wuy, yagu anubani-yung ambirriij-garru-magaa wugurru anubani anaaladi. Wugurru amburru-wurrij-galadi-wini-magaa, wugurru amburru-burri ambuu-yaaḻi-aladi marri ambanggu-wudbudangi-magaa lhagabuṉulg wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Yagu ngaya ngana-magana nugurru, anubani-yung-maynji niga na-God anubani ambani-nguynju-nguynjijgana-maynji, warraawurru-yung anggu-waṉina aladi wugurri-wuy. Yagu nugurraayung ana-Chorazin-jinyung marri ana-Bethsaida-yinyung, wugurru anggu-waṉina nugurri-wuy runggal-windiyung aladi! ");
INSERT INTO nuy_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Marri nugurraayung ana-Capernaum-jinyung, ngaya ngana-magaa aḏaba ana-lhaawu nugurri-wuy. Marri yuga na-God niga nambani-warraarriwana niga? Waari! Numburru-yaarri nugurru arrwiyaj, yuga? Waari! Nugurru aḏaba nambani-lhajbiyn niga. Nugurru nambani-lharrgang, numburru-yaarri wubani a-ngura-wuy wu-naga-nagina-wuy! Nugurru yamba nganaagaminij-gaandirrangi ngaya anaani. Ngaya-magaa nganggaṉbini-magaa aniij-mamaaḻang anubani-rruj ana-Sodom, warruburru-yung warra-wurru-wurruj amburraajangi anaalaaladi marri anubani-yung aḏaba ana-wumurrng anggu-burri ana-yimbaj. ");
INSERT INTO nuy_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Yagu ngaya ngana-magana nugurru, anubani-yung-maynji niga na-God anubani ambani-nguynju-nguynjijgana-maynji, warraawurru-yung anggu-waṉina aladi wugurri-wuy. Yagu nugurraayung ana-Capernaum-jinyung, wugurru anggu-waṉina nugurri-wuy runggal-windiyung aladi!” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Anubanila-wala, niga na-Jesus ni-yamayn, “Ngaya ngunu-warraarriwana anaani Baba. Nugawaj nu-ngu-buunggawa-mana aadanu anaarrwar marri anaani-rruj ana-lhirribala. Nagang aadanu nunggij-ngu-julubayn anaani ana-lhaawu warruburru-yung-gala waa-yina-mamaaḻang-gala. Yagu wugurraayung waari-yinyung warruburru-yung ambuu-yina-mamaaḻang-jinyung-magaa, warruburru-wuy nunggij-garrarra-gayn, aadanu, ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yuu, Baba, danu nga nunggijangani-yinyung nagang aḏaba.” ");
INSERT INTO nuy_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Anaani-yung na-Jesus niga wani-magaa warra-wurru-wurruj-guy, “Ngaya anaani na-Baba nganiini anaarrawindi-lhangu niga, ngaya na-niwiyayung anaani. Waari warraaynbaj ambu-marrbuy-maa ngaya anaani. Yagu na-Baba-wugij ni-marrbuy ngaya anaani. Ngijang, na-Baba waari warraaynbaj ambu-marrbuy-maa niga. Yagu ngayaaj-bugij nga-marrbuy niga. Ngaya-maynji nganggiijangayii marri ngamba-magana, warra-wurru-wurruj-guy, ari wugurraayunggaj amburru-marrbuy niga.” ");
INSERT INTO nuy_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Naagi-yung na-Jesus ni-yambini-wugij. “Nugurru-maynji numburraalharaguna, numburru-yaal-ngawina-maynji, nugurru numburraaṉina ngayawi-wuy. Anubani anambaa-garra-yarraana, anamba-lhamaamura-gang. ");
INSERT INTO nuy_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Numburraaṉina ngirri-garrindharrmang ngayawi-wuy, numburru-marrbuy yadhu ngaya. Anubani yamba ngayawi-nyinyung, waari anubani anggiij-baḏa-waḏaḏ-magaa. Ngaya yamba nga-lhambaamburrg marri nga-yaal-murramurra, marri anamba-lhamaamura-wang. ");
INSERT INTO nuy_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Anubani-yung yamba ngayawi-nyinyung ana-lhaawu, nganggiij-garrarra-gana, waari anubani anggiij-baḏa-waḏaḏ-magaa.” Dani-yung na-Jesus ni-yambini, ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ngarrubagi-rruj ngarraaḻirr-maṉngulg-duj, na-Jesus anubani-yung ni-jarrarrangi banila-yung wu-warradiynjini-rruj wuḏal. Nigawi-nyinyung wurru-marrbuy-maa-yinyung wugurru wurru-marryaadiyn, aḏaba wugurru wurru-mangi anu-ḏal wurru-nguni. ");
INSERT INTO nuy_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Yagu wugurraayung warra-Pharisee warra-nayn. Wugurru wurru-yamayn na-Jesus-guy, “Baarranggang, aadanu-maynji amburru-waṉbina-maynji ngarraagi-rruj ngarraaḻirr, aadanu wiijamana wiij-galadi-wina,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nigaayung na-Jesus wani-yamijgayn, “Yuga nugurru waari nimbirri-nani ana-wubiba-rruj, niga na-David marri warruburru-yung nigawi-nyinyung warra-waḻya-waḻya wugurru wurru-marryaadangi. ");
INSERT INTO nuy_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Marri anubani-yung wurru-yanggi wubani-wuy na-God-guy wubani-wuy a-wumurrng. Marri warruburru-yung warra-priest, yagu burru-yung-bugij wurru-nguni anubani-yung ana-maṉngulg anu-ḏayn anubani-yung na-God-jinyung-duj ana-wumurrng. Yagu anubani-yung na-David marri nigawi-nyinyung warra-waḻya-waḻya wurru-nguni wugurru. Yuga anaani-yung nugurru nirri-nani? ");
INSERT INTO nuy_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Marri yuga nugurru waari nimbirri-nani anubani-rruj ana-lhaawu-runggal na-Moses-inyung, ngarrubagi-rruj ngarraaḻirr-maṉngulg-duj, wiiya waari amburru-mijgalmini warraarrawindi-lhangu, yagu wugurraayung warruburru-yung warra-priest wurru-mijgalmina ana-Temple-Maṉngulg-duj, yagu wiiya aadanu, wugurru waari amburru-waṉbang anaaladi. ");
INSERT INTO nuy_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“Ngaya ngana-magana nugurru aadanu, ngaya anaani nga-runggal-windiyung, waari nguynju ana-Temple-Maṉngulg-jii. ");
INSERT INTO nuy_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Anubani-yung ana-wubiba wu-yamana, God ni-yamaa, (Hosea 6:6) ‘Ngaya ngana-ngaynbandii nugurru nambarra-man.galagana, yagi nurru-ni ana-bulugi.’ Nugurru waari-windiyung numburru-marrbuy-maa wiijaminggarrina. Anubani-yung-maynji nugurru numburru-marrbuy-dhang wugurru, nugurru waari narra-nguynju-nguynjijgi warruburru-yung waari-yinyung amburru-waṉbini anaaladi. ");
INSERT INTO nuy_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yaani nga ngaya-waj na-Niwiyayung na-Wurrujung-jinyung, ngaya-waj yaani nga nga-buunggawa-mana aḏaba ngarraagi-rruj ngarraaḻirr-maṉngulg.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Anubanila-wala, niga na-Jesus ni-yanggi anubagala, wubani-wuy a-synagog-guy. ");
INSERT INTO nuy_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Marri bagu waḻyinyung ni-burri. Naagi-yung ni-warra-guṉḏa-guṉḏa nigawi-rruj a-marang. Bagu mulung-arrgi-yung wunu-nani na-Jesus, ambunu-lhajbini yadhu niga. Wugurru wunu-yandhawiwayn niga, “Yuga anubani ana-lhaawu-runggal wu-yamana, ambu-maji-mana ngarraaḻirr-maṉngulg-duj?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nigaayung na-Jesus wani-yambalmayn, “Anubani-yung-maynji nugurru numburru-waṉagana ana-jib marri anubani-yung anggu-rabina buguni a-gara-wuy ngarrubagi-rruj ngarraaḻirr-maṉngulg-duj, nugurru numburru-ngarrgiwang anubani-yung-gala ana-gara-wala. ");
INSERT INTO nuy_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ngubindi warrubawi-yung warra-wurruj wugurru ngijang wu-lhabarrj waari nguynju ana-jib-jii. Nguynju-waj anubani-yung yij-mamaaḻang amburru-waṉbina-yinyung anaambaḻaman ngarrubagi-rruj ngarraaḻirr-maṉngulg-duj.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Marri yunggaj ni-yamayn na-waḻyinyung-guy, “Bawu-lharraalhijgang nugawi-nyinyung ana-waṉja.” Nga nigaayung niwu-lharraalhijgayn. Marri anubani-yung ana-marang ni-marang-maṉdhiiyn, nguynju-yii aaynbaj-jii a-marang. ");
INSERT INTO nuy_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Yagu wugurraayung warruburru-yung warra-Pharisee wurru-yanggi yuuguni wurru-yambiynjini. Wurru-yamaa, “Nubagi-yung na-Jesus ngaanu-jadugang,” wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Na-Jesus naagi-yung ni-marrbuy wurru-waṉbini-yinyung. Niga niwaarruyn anubani anaanga. Arrawindi warra-wurru-wurruj wunu-garrindharrmangi niga, marri niga wani-maji-waa warraarrawindi-lhangu warruburru wuu-lhangurrngandi-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Naagi-yung wani-magaa, “Yagi narra-magi warruburru-yung warra-mulung-aynbaj, ngaya anaani,” ni-yamaa niga. ");
INSERT INTO nuy_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Anaani ni-waṉbini, yagu yamba na-God ni-yambini anu…bani-yunggaj. Anaani na-Isaiah nubagi-yung naa-ja-jambini-yinyung ni-yamaa, ");
INSERT INTO nuy_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Yaani niga ngayawi ni-mijgalmina-yinyung ngaya nga-wajbarini. Ngaya nganu-ngaynbandii marri ngaya-waj ngaaḻaaḻarrii nigawi-wuy. Ngaya nganggu-burrang ngayawi Mawurr nigawi-rruj, marri niga yunggaj ambani-magana warraarrawindi-wuy warra-wurru-wurruj, amburru-burraa yadhu maaḻamburrg ngayawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Niga waari ni-riyaldhi, yagi niiḏi, manubami-rruj manaadi. ");
INSERT INTO nuy_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Niga ni-man.galag-bindiyung warruburru-wuy warra-bilwilwiluj-jinyung, ni-lhambaamburrg-bindiyung niga, ambani-maṉmani-wugij, ambaniigajij-maṉdhii, marri ani-lhuḏ-jaarri niga. ");
INSERT INTO nuy_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Warruburru-yung ana-lhal-lhangu-rruj amburru-jambarrgina nigawi-wuy.” Dani-yung ni-yambini na-God, waarrarrini a-wubiba-rruj. ");
INSERT INTO nuy_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nga mulung-arrgi-yung wunu-yarrijgini na-Jesus-guy waḻyinyung nubagi-yung ni-ba-galadi marri waari ani-yambini yagu yamba niga ni-waṉagaa man.gurrg. Nigaayung na-Jesus nu-maji-wayn niga na-waḻyinyung, nga ni-yambiyn marri ni-warranggayn. ");
INSERT INTO nuy_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Warraarrawindi-lhangu warra-wurru-wurruj wugurru wurraalharaguni marri wurru-yamayn, “Yuga naagi niga na-niwiyayung na-David-jinyung?” wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Yagu wugurraayung warruburru-yung warra-Pharisee wurraawanggiyn anaani-yung, wugurru wurru-yamayn, “Naagi-yung ni-warra-yarramijgana anubani ana-man.gurrg, anubani-yung lhuḏ-mirri yamba nubagi-yung na-Beelzebul-inyung, na-baḏirrnya-yung, ni-buunggawa-mana-yinyung niga anubani-yung-jinyung ana-man.gurrg-gaang.” Dani-yung wurru-yamaa wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nigaayung naagi-yung na-Jesus anubani aḏaba ni-marrbuy warraawurru-yung-jinyung wirriijanga-yangani-yinyung anaaḻamin. Nga bagu-mirri wani-magayn wugurri-wuy, ni-yamayn, “Warra-mulung-aynjaabugij-maynji wugurru anubagu-maynji amburru-burraa, warruburru-yung-maynji wugurru amburru-wiynji-wiynjina-wugij, warruburru-yung aḏaba ari ambuu-manda-ngu-jadugiiyn aḏaba. Marri anaani wiij-nguynju, warruburru warra-mijgalgur amburru-wiynji-wiynjina-maynji anaanga-rruj, amburru-manda-ngu-jadugiiyn wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Marri anubani-yung-maynji na-baḏirrnya-yung ani-yarramijgina nigaaj-baj, niga ani-waḻgaḻ nigaaj-baj marri nigawi-nyinyung ni-buunggawa-mana-yinyung yunggaj waari wu-wandha-wuguuguni-mi, anggu-jadugiiyn wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","28","“Yuga ngaya anaani ngaarra-yarraana ana-man.gurrg-gaang ana-lhuḏ-mirri na-baḏirrnya-yung-gala yuga? Yagu nugurri-nyinyung warruburru warru-mandag, wugurraayunggaj anaani wurraarra-yarraana ana-man.gurrg yagu! Wugurru wirri-waṉagana lhuḏ, nguynju ngayawi-yii. Yuga waa-yangi-nyung-jinyung yuga anaani ana-lhuḏ? Yigaj! Anaani ana-lhuḏ nigawi-nyinyung na-God-jinyung. Marri nugurri-nyinyung warruburru warru-mandag, aadanu nugurru ari nambambi-lhajbumana aadanu. Yijgubulu, anaani ana-lhuḏ wu-yaarri na-God-gala na-ni-mawurr-yung-gala. Yagu anaani wiijamana, warru-mandag na-God-jinyung yamba, yaawurru nga, aḏaba, nugurri-rruj wurru-burraa. ");
INSERT INTO nuy_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Waari warraaynbaj wurru-yabi ana-wumurrng nubagi-yung-jinyung na-waḏa-waḏaḏ-jung-jinyung marri waari wunaa-garra-yari anubani-yung ana-ngurrji. Yagu, anubani-yung-maynji ana-wulhu-wulhurr nubagi-yung-maynji ambunu-radbumana na-waḏa-waḏaḏ-jung, bani-yung marri ambunaa-garra-yarina anubani-yung anaarra. ");
INSERT INTO nuy_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Yigaj! Warraaynbaj-maynji warrubawi-yung yagi-maynji ngurraanggarra-rumi ngayawi-wuy, warrubawi-yung wugurru ngambambi-wurrij-bangana ngaya. Yagi-maynji warraaynbaj wugurru warrubawi-yung warra-muṉḏugi warra-wurru-wurruj ngayawi-wuy, marri warrubawi-yung ari ambarra-lharrganjii ngayawi-wala wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Nguynju-waj ngaya ngana-magana nugurru, na-God ambaniigajij-garruyn anubani-yung anaarrawindi anaalaaladi, marri amburru-lhaguḻa-maaḻang-maynji, anubani-yung na-God ari ambaniigajij-garruyn. Yagu warruburru-yung-maynji warra-wurru-wurruj ambirriiladi-yamawana-maynji ana-Maṉngulg Mawurr, yagi na-God waniigajij-garru. ");
INSERT INTO nuy_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Marri warruburru-yung ngambiiladi-yamawana ngaya, na-Niwiyayung na-Wurrujung-jinyung, na-God ambaniigajij-garruyn wugurru. Yagu ambirriiladi-yamawana-maynji ana-Maṉngulg Mawurr, niga na-God waari waniigajij-garru, ana-yimbaj yagu anggu-wuguuguni.” ");
INSERT INTO nuy_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Naagi-yung na-Jesus ni-yambini-wugij. “Anubani-yung-maynji nugurru nimbirri-ngaynbandii ambaḻaman anu-ngugulmung, nimbirri-lhangarrmang ana-rangag anaambaḻaman. Anubani-yung-maynji nugurri-nyinyung ana-rangag waari waambaḻaman-mi, anubani-yung waṉagana aladi anu-ngugulmung. Nugurru nurru-marrbuy ana-rangag, anubanila anu-ngugulmung-gala wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","“Nugurru aadanu nurru-maragarrij, nguynju a-marryn-jii! Nugurru nurru-yamana nguynju anubani anaaladi ana-rangag. Nugurru waari numburru-yambang ana-maaḻamburrg, nugurru yamba nurraaladi ana-lhirribala. Anubani anaarrawindi nurru-wijangayii-yinyung ana-lhirribala, wugurru wu-rabalina anubanila ana-ramadhan-gala. ");
INSERT INTO nuy_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Warruburru-yung warra-mamanunggu-yinyung wugurru warra-wurru-wurruj warruburru wurru-mamanunggu-windiyung wugurri-rruj aandhiri-rruj. Marri anubani wurru-waṉbina aambaḻaman-jinyung wugurru. Yagu warruburru-yung warraalaaladi wugurru warra-wurru-wurruj, anubani anaaladi wu-burraa wugurri-rruj aandhiri-rruj. Marri anubanila-wala, wugurru wurru-waṉbina yij-galaaladi. ");
INSERT INTO nuy_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Marri ngaya ngana-magana nugurru aadanu, anubani na-God nambani-nguynju-nguynjijgana-rruj ngarraaḻirr, anaarrawindi anaaladi ana-lhaawu nurru-yambini-yinyung anaarrbidi, nugurru nimbirriij-burryuwina na-God-guy. ");
INSERT INTO nuy_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Niga na-God nambani-nguynju-nguynjijgana, nugurri-wala ana-lhaawu-wala. Ari nambani-lhajbiyn, yagu ari nambaniigajij-garruyn. Yagu bani-yung-gala ana-lhaawu-wala, ani-wijangayii niga.” Dani-yung ni-yambini na-Jesus, ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nga arrgi-yung warra-Pharisee marri warra-yiyini-yinyung ana-lhaawu-runggal wunu-magaa, wurru-yamaa, “Numba-marrbuy-wana-yinyung, nimba-bajiyina malnguj aarrwar-wala.” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nigaayung na-Jesus ni-yamayn “Nugurru aadanu warra-wurru-wurruj nurru-wiri-yinyung ana-yimbaj, nugurru aadanu nurraalaaladi. Nirri-ngaynbandii nugurru aadanu arrwar-wala yuwaagala malnguj. Yagu na-God niga yagi nani-yu nugurru. Na-God niga ani-wij-garrarra-gana-wugij anubani-yung yaga nguynju nubagi-yung-jii na-waḻyinyung-jii, nubagi naa-ja-jambini-yinyung, na-nimuwaj-jung Jonah, wiijamana. ");
INSERT INTO nuy_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Na-Jonah nubagi-yung ni-burri lhirribala ama-gulmung-duj wubani-rruj a-runggal a-ngujija anubani-yung ngi-wulaynbaj ngarraaḻirr marri muulawaa mana-miyn.nganga. Anubani-yung anggiij-nguynju, ngaya-waj na-Niwiyayung na-Wurrujung-jinyung, nga-ngu-burraa ana-lhirribala anubani-rruj anaaban-duj, angi-wulaynbaj ngarraaḻirr marri amuulawaa-wala mana-miyn.nganga. ");
INSERT INTO nuy_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Wurrugu marri ngijang, bani-yung ambani-nguynju-nguynjijgana niga warruburru-yung warra-wurru-wurruj-guy niga na-God, warruburru-yung warra-mulung-arrgi-yung ana-Nineveh-yinyung amburru-ḻaḻagiiyn, marri nugurraayung, numbuu-yagaynjina bagu numburru-burraa wugurri-rruj. Marri bagu nambambi-lhajbumana nugurru. Anaani-yung yamba wurraawanggini wugurru ana-lhaawu na-Jonah ni-yambini-yinyung, anubani-yung wurru-wurrij-biḻibiḻingini aḏaba. Yagu ngaya anaani nga-runggal-windiyung, nigaayung na-Jonah waari ani-runggal-magaa nguynju ngayawi-yii. ");
INSERT INTO nuy_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Marri ngarrubagi-yung ngarra-Queen ana-lhal-inyung wu-mayini Sheba, yaanuwuy wu-lhal-ngu-burri wugurru wagiyaj, ngiga ngarrubagi angi-ḻaḻagiiyn, marri nugurraayung aadanu, numbuu-yagaynjina bagu numburru-burraa ngigawi-rruj. Ngiga ngarrubagi nambangi-lhajbiyn ngiga nugurri-wuy. Wubanila-wala a-lhal-wala ngi-yanggi yuwaagala juju…j-gala ana-lhal, nguynju yadhu niga nubagi ngunu-yaynjangani na-Solomon, naagi-yung yamba ni-yina-mamaaḻang niga. Yagu ngaya anaani nga-runggal-windiyung, nigaayung na-Solomon waari ani-runggal-magaa nguynju ngayawi-yii.” ");
INSERT INTO nuy_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Naagi-yung na-Jesus ni-yambini-wugij niga. “Nubagi-yung-maynji na-waḻyinyung ani-waṉagana man.gurrg aladi, marri anubani-yung-maynji nigawi-wala anggu-rabalang, anubani-yung aninggaarruyn nga anggu-yaarri yuuguni a-lhal-aṉḏarrg-baj wugurru, anubani anggu-yaarri nga yagi-maynji lhangarrmi ana-mamanunggu ana-lhal, anggu-yaarri bagu anggu-ḻang-janga-yangina wugurru, ");
INSERT INTO nuy_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","anggu-yamang ‘Ngandaagiyn nubagi-wuy na-wurrujung-guy.’ Ngijang aḏaba, anggaagiyn nubagi-yung-guy ninggaarruyn-guy na-waḻyinyung-guy wugurru. Anaani wiijamana, nubagi-yung na-wurrujung ni-mamanunggu ana-lhirribala. ");
INSERT INTO nuy_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Anubani-yung ana-man.gurrg wu-warranggana nga wu-wagalhaga-lharrmani marri lhangarrmana aynbaj man.gurrg marang-aynjaabugij marri wulawaa, nga buguni aḏaba wu-yaarri. Anaani ana-man.gurrg yamba waaladi-windiyung, wugurri-wala aynjaabugij-gala mani. Marri anubani-yung wu-ngarra-jaarri, wu-ngarra-jabina, nubagi-yung-guy na-wurrujung-guy, anaani ana-man.gurrg wugurru. Anaani aḏaba niiladi-wina-windiyung niga, anubani-yung yaga wugurru ana-wulhu-wulhurr wurrugu ni-maṉdhini. Yagu waari aḏaba niga. Dani-yung anggiijamana, nugurri-wuy nurraalaaladi yamba warra-wurru-wurruj.” Dani-yung ni-yambini niga na-Jesus, ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Naagi-yung na-Jesus wani-yambini-wugij warra-wurru-wurruj-guy, nigawi-nyinyung nga-rriibi-yung marri warra-minilharri-yung wurru-lhaay arabarabalu, ambunu-yambini yungguyung niga. ");
INSERT INTO nuy_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aynjaabugij wunu-magaa na-Jesus, “Nugawi-nyinyung ngarriibi marri warra-minilharri durru wurraarra-garra-lhara aarabarabalu-rruj, marri wugurru nimbi-ngaynbandii ambi-yambina nagang,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nigaayung wani-yambalmayn, “Yangi-nyinyung ngayawi-nyinyung ngaa-rrigang? Yangi-yangi ngayawi-nyinyung naa-murruyung-gaang?” Ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nga niga wani-wurrurriyn nigawi-nyinyung-guy wurru-marrbuy-maa-wuy marri ni-yamayn, “Yaawurru ngayawi-nyinyung nga-rrigang marri naa-murruyung-gaang. ");
INSERT INTO nuy_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Warruburru-yung wunu-yandhurrbangana-yinyung na-Baba anaarrwar, burru-yung ngayawi-nyinyung naa-murruyung-gaang marri ngaa-murruyung-gaang marri ngaa-rrigang-gaang.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Anubanila-wala, ngi-nguynju-yinyung ngarraaḻirr na-Jesus ni-yanggi ana-wumurrng-gala marri ni-burrangayn ama-madha-gaḻaḻij-duj. ");
INSERT INTO nuy_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mulung-dhabarrj warru-mandag wurru-muṉḏugaa wunu-dhawawarumayn niga, yagu niga ni-yanggi buguni ama-barrawu-wuy, ni-yabaynjiyn nga ni-burrangayn. Yagu warruburru-yung warra-wurru-wurruj wurraarra-garra-lhi ama-madha-gaḻaḻij-duj. ");
INSERT INTO nuy_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Marri anubani-yung wani-magaa wiij-bulawaa-wala, ni-yambini anaarrawindi. Anaani-yung ni-yamayn, “Nubagi-yung na-waḻyinyung ni-yanggi, ni-wanuynjungaa anu-ḏal. ");
INSERT INTO nuy_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Marri ni-ral-yarraani. Anubani ana-mulung-aynbaj waadbarrwini amubama-waj amaadi-waj. Nga anubani ana-ngurudhu wu-wilbilangi marri wu-ngarra-ḏalhangi marri arra-nguni anu-ḏal. ");
INSERT INTO nuy_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","“Anubani ana-mulung-aynbaj anu-ḏal anubani waadbarrwini ama-ṉuga-waj, waari anubagu anaaban ana-lhirribala. Yagu anubani-yung waarradangi wu-nguḻu-nguḻubini, waari anubagu ana-lhirribala anaaban anuguni-yinyung anggu-lhiḏangi-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ngarrubagi-yung ngarraaḻirr ngi-ḻan.gaḏangi marri ngi-wal-murrmbulingijgayn yagu anubani-yung waari anubagu anu-ngujang, anubani-yung wu-ḏaḏarrg-mayn, wu-lhagarra-ngawini. ");
INSERT INTO nuy_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","“Ana-mulung-aynbaj wugurru anubani-yung anu-ḏal waadbarrwini a-rawurrumugurrumu-rruj. Anubani-yung anu-bal waarradangi. Anubani wugurraayunggaj wu-wal-warradangi ana-rawurrumugurrumu ngijang wu-waliynjini. Marri anubani-yung al-waabaabaa. ");
INSERT INTO nuy_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","“Anubani-yung ana-mulung-aynbaj anubani-yung waadbarrwini nga wu-warradiyn anuwaagu anaaban-mamaaḻang-baj. Marri anubani-yung wu-warradangi marri wu-gulmung-jungini, ana-mulung-arrgi anubani wu-maṉdhini 100 anu-ḏal anubanila-wala aynjaabugij, anubani-yung arrgi wu-maṉdhini 60 anu-ḏal, anaarrgi anubani-yung wu-maṉdhini 30 anu-ḏal, anubanila-wala wal-aynjaabugij wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Nugurru-maynji numburru-wan-bawalhang aadanu, marri anubani-yung numburraawanggina-windiyung nugurru!” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Anubanila-wala, warruburru-yung wurru-marrbuy-maa-yinyung wurru-yanggi nigawi-wuy, wurru-yamayn, “A-yangi-yungguyung nagang aadanu barra-magana aniij-bulawaa-wala ana-lhaawu, warra-wurru-wurruj-guy?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nigaayung na-Jesus ni-yamayn, “Anaani ngana-magana nugurri-wuy, nguynju yadhu anubani-yung numburru-marrbuy anubani aniij-miḏaamimi-yinyung, warruburru-yung-jinyung warru-mandag anaarrwar-yinyung. Yagu waari anaani ngamba-magaa warruburru-yung warra-mulung-aynbaj-guy. ");
INSERT INTO nuy_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nugurru numburru-marrbuy-yinyung anaani, anubani-yung God nambaniiyii nugurru, nguynju yadhu anubani numburru-marrbuy-wina windiyung nugurru. Yagu nugurru waari-yinyung numburru-marrbuy-mang-jinyung aadanu, yagu nugurru nurraaḻamin-jamana nurru-marrbuy, yagu aadanu na-God aniwu-yarina niga nugurri-wala. ");
INSERT INTO nuy_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","“Anaani wiijamana ngaya ngarra-magana-yinyung aniij-bulawaa-wala ana-lhaawu warra-wurru-wurruj. Wugurru wurraarranggana, yagu wugurru waari-windiyung ambirri-nang. Wugurru wurraawanggina, yagu wugurru waari-windiyung amburraawanggiyn yagu amburru-marrbuy-mang, ana-lhaawu na-God-jinyung. ");
INSERT INTO nuy_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Anaani wiijamana, nubagi-yung na-Isaiah nubagi naa-ja-jambini-yinyung, ni-yambini anu…bani-yunggaj. ‘Nugurru numburraawanggina-wugij, yagu nugurru waari nurru-marrbuy-dhi. Nugurru numburraarranggana-wugij, yagu waari nirri-ni ana-maaḻamburrg. ");
INSERT INTO nuy_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nugurru nurru-wijangayii-yinyung, nurru-wan-baḏa-waḏaḏ. Nugurru waari numburraawanggiyn nugurri-nyinyung-mirri mana-warang, marri nugurru nurru-ba-ngu-dhidiyn nugurri-nyinyung mana-bagaḻang. Nguynju yadhu nugurru waari nurraarranggi mana-bagaḻang-mirri, waari nurraawanggi mana-warang-mirri, Waari nurru-marrbuy-mi ana-maaḻamburrg. Nugurru-magaa numburraagini-magaa ngayawi-wuy, ngaya nganamba-wiri-gaa-magaa nugurru.’ “Dani-yung ni-yamaa na-God. ");
INSERT INTO nuy_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yagu nugurraayung naniigajij-majgana, yagu yamba nugurru nurraarranggana nugurri-nyinyung-mirri mana-bagaḻang marri nurraawanggina nugurri-nyinyung-mirri mana-warang. ");
INSERT INTO nuy_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ngaya ngana-magana nugurru yijgubulu-windiyung, arrawindi wunaa-ja-jambini-yinyung na-God, marri warra-mamanunggu-yinyung warra-wurru-wurruj anubani-yung wirri-ngaynbandangi wugurru ambirri-nani anaarrawindi nga-waṉbini-yinyung ngaya. Yagu waari anubani ambirri-nani wugurru. Yagu nugurru aadanu nirri-nani aḏaba. Warruburru-yung anubani-yunggaj wirri-ngaynbandangi wugurru amburraawanggini. Yagu waari anubani wugurru amburraawanggini.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Naagi-yung na-Jesus wani-magaa-wugij, ni-yamaa, “Yagu numburraawanggina anubani-yung wu-yamana-yinyung anubani-yung ana-lhaawu anubani-yung anu-ḏal-inyung. ");
INSERT INTO nuy_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“Anubani-yung anu-ḏal anubani-yung wu-rabini-yinyung manaadi-waj, anaani wiijamana, warra-wurruj warrubawi-yung wu-wawanggina-yinyung ana-lhaawu warru-mandag-jinyung anaarrwar, yagu waari wu-marrbuy-dhi anubani-yung. Marri nubagi naaladi-nyung na-baḏirrnya-yung ni-yaarri marri niwu-yarina anubani-yung ana-lhaawu wugurri-wala. ");
INSERT INTO nuy_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","“Wugurraayung anubani-yung anu-ḏal anubani-yung wu-rabina-yinyung mana-ṉuga-waj, anaani wiijamana, warra-wurru-wurruj warruburru-yung wurru-wawanggina-yinyung ana-lhaawu, marri wirri-ngaynbandii, wurru-waḻaaḻarrii, yagu waari-windiyung, nguynju yaga anubani ana-rangag waari-yinyung anu-ngujang, waari wu-warradi ana-rangag. Yagu warruburru-yung waari amburru-jambarrgang-bindiyung, Anubani-yung-maynji ana-wungarri anggu-waṉiyn, wugurru yamba wurru-jambarrgiiyn, warruburru-yung amburru-yarramana, amburru-lhuṉdhii wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Wugurraayung anubani-yung anu-ḏal anubani-yung wu-rabina-yinyung anubani-rruj ana-rawurrumugurrumu-rruj, anaani wiijamana warra-wurru-wurruj warruburru-yung wurru-wawanggina ana-lhaawu, yagu anubani-yung-maynji aniij-gaynbaj amburraalharaguna, anubani-yung wu-yaal-aḏaaḏigaynjina. Marri wirrii-ḏamarr-ngu-burraa anaani ana-lhal. Anubanila-wala aḏaba wu-ngarina ana-lhaawu. Yagu anubani-yung waari wu-warradi anu-ngugulumung. ");
INSERT INTO nuy_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Wugurraayung anu-ḏal wu-rabina-yinyung anaaban-mamaaḻang-baj, anaani wiijamana, warruburru-yung warra-wurru-wurruj wurru-wawanggina-yinyung ana-lhaawu, marri wurru-marrbuy-windiyung, wurru-jambarrgina. Anaani wiijamana, nguynju yaga anggu-warradii wu-ngugulmung. Malgaynbaaynbiyaj 100, malgaynbaaynbiyaj 60, malgaynbaaynbiyaj 30 wugurru.” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Aḏaba na-Jesus wani-magaa wugurru anaaynbaj aniij-bulawaa-wala ana-lhaawu. Ni-yamaa, “Warruburru-yung warru-mandag anaarrwar-yinyung nguynju na-waḻyinyung-jii nubagi-yung ni-wanuynjungaa-yinyung ana-mamanunggu anu-ḏal ana-wheat nigawi-nyinyung-duj anaabaḻa. ");
INSERT INTO nuy_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Anubani-yung miyn.ngu aḏaba, aynbaj wurruj wu-yanggi midaarrgaj aabaḻa-wuy, wu-ral-yarraani aladi wuḏal anubani-yung ana-wheat-duj marri aḏaba waarruyn. ");
INSERT INTO nuy_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","“Anubanila-wala, ana-wheat wu-ralgayiyn marri anu-jinag anu-ḏal wu-warradangi, yagu anaaladi waanuynjungina-yinyung nguynju-waj wu-warradiynjini. ");
INSERT INTO nuy_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Aḏaba na-waḻyinyung-jinyung wunaa-mijgalmini-yinyung wurru-yanggi nigawi-wuy marri wurru-yamayn, ‘Nagang nungganuynjungaa wu-mamanunggu anu-ḏal nugawi-nyinyung-duj anaabaḻa. Ajigala anubani-yung anaaladi waanuynjungina-yinyung wu-waṉiyn?’ wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nigaayung na-waḻyinyung ni-yamayn, ‘Maragarrij waanuynjungaa anaaladi!’ ni-yamayn. Wugurraayung wurru-yamayn, ‘Yuga nagang numba-ngaynbandiyn nurru naambu-ngarrgiwana anaaladi?’ wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nigaayung ni-yamayn, ‘Numburraarruyn, nugurru nurru-ngarrgiwu-magi ana-wheat wugurraayunggaj. ");
INSERT INTO nuy_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nimbirri-waḻamin-dharrgang anaaladi marri ana-wheat anggu-warradii anggaaynjaabu murrubu anubani-yung numburru-muṉḏugana-yinyung. Bani-yung aḏaba ngaya anamba-magang nugurru nurru-mijgalmina-yinyung, ana-wulhu-wulhurr nimbirri-muṉḏugana anaaladi marri wugurru anggaaynjaabu anggu-nagina. Aḏaba numburru-muṉḏugana ana-wheat marri numburru-yarrijgina ngayawi-wuy a-wumurrng.’” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Na-Jesus wani-magaa wugurru aynbaj ana-lhaawu, “Warruburru-yung warru-mandag anaarrwar-yinyung nguynju wurru-yamana, na-waḻyinyung ni-miyn a-winyig wuḏal, wubani wu-mayini mustard. Marri ni-wanuynjungaa nigawi-nyinyung-duj aabaḻa. ");
INSERT INTO nuy_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Anubani-yung ana-ral-wirrig, anaarrawindi-lhangu-wala anu-ḏal, yagu arrawindi-wala wu-wanuynjungini. Yagu anubani-yung-maynji anggu-warradii, marri anubani anggu-runggal-mana. Anaani-yung ana-ngurudhu wugurru anggu-ngarra-guṉmana nga bagu maṉdhii anggu-wayayarrii wugurru.” Dani-yung ni-yamaa niga na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Na-Jesus wani-magaa anaaynbaj ana-lhaawu. “Warruburru-yung warru-mandag anaarrwar-yinyung nguynju yaga wubani wurru-burrii wu-gulmung-buḻbuḻwanjii yaga. Ngarraagi-yung ngarra-maṉinyung ngiga ngi-mangi anubani-yung ana-marrya, nga ngi-burrangi ama-gaṉdharra-wuy. Anubani-yung ana-marrya aḏaba ngiirruyn nga bagu wu-burri nga wu-ḻuḻḏuḻwaa wugurraajbaj.” Dani-yung ni-yamaa niga. ");
INSERT INTO nuy_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Na-Jesus ni-yambini-wugij wiij-bulawaa-wala ana-lhaawu, wani-magaa warru-mandag. Waari anubani-yung ambani-magaa anggiij-garrarra, niga ni-yambini wiij-bulawaa-wala-wugij. ");
INSERT INTO nuy_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nubagi-yung yamba aynjaabu-nyung naa-ja-jambini-yinyung na-God, ni-yamaa, “Ngaya anaani ngaynjambina aniij-bulawaa-wala ana-lhaawu. Ngaya ngaynjambina nugurri-wuy, anaarrawindi-lhangu waari-yinyung numburru-marrbuy-dhini anubani-yung wu-lhal-maṉdhini-wala ana-lhal.” ");
INSERT INTO nuy_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Aḏaba na-Jesus waniirruyn warru-mandag marri ni-yanggi buguni a-wumurrng-guy. Nigawi-nyinyung wurru-marrbuy-maa-yinyung wurru-yanggi nigawi-wuy marri wurru-yamayn, “Numba-magana nurru wu-yaminggarrina-yinyung ana-lhaawu anubani-yung ana-wheat-jinyung marri anaaladi anu-ḏal-inyung,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Na-Jesus wani-yambalmayn, “Na-waḻyinyung nubagi-yung ni-wanuynjungaa-yinyung ana-mamanunggu-yinyung anu-ḏal anaabaḻa-rruj ngaya-waj nga, na-Niwiyayung na-Wurrujung-jinyung. ");
INSERT INTO nuy_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Marri anaabaḻa wiijamana ana-lhal-lhangu, marri ana-mamanunggu anu-ḏal wiijamana warruburru-yung na-God-jinyung warra-wurru-wurruj. Marri anaaladi waanuynjungina-yinyung wiijamana warruburru-yung warra-wurru-wurruj naaladi-nyung-jinyung na-baḏirrnya-yung. ");
INSERT INTO nuy_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Marri naaladi-nyung niga ni-wanuynjungaa-yinyung anaaladi anu-ḏal, niga na-baḏirrnya-yung. Marri anubani-yung wurru-muṉḏugana-yinyung, anubani wu-dhaag-mana-rruj. Marri wurru-mijgalmina-yinyung, warruburru-yung wurru-muṉḏugana-yinyung wu-yamana wubani-yung-jii angel. ");
INSERT INTO nuy_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Yigaj! anaaladi ana-maḏa wurraarra-ngarrgiwana marri wirri-nangana a-ngura-rruj, anaani anggiiyn-nguynju, anubani-yung anggu-dhaag-mana-rruj. ");
INSERT INTO nuy_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ngaya-waj na-Niwiyayung na-Wurrujung-jinyung, ngandharrgang angel, marri wugurru ambanggu-muṉḏugana ana-lhal-lhangu-waj warraarrawindi wurru-waṉbina-yinyung aaladi. ");
INSERT INTO nuy_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Marri ana-angel ambanggu-barawudii wugurru buguni wu-nagina-wuy a-ngura. Anubagu warruburru-yung amburru-ruguna marri amburru-ra-bangaynjina amburraarragayii yamba wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","“Wugurraayung aḏaba warra-mamanunggu-yinyung warra-wurru-wurruj amburru-milhiynjina nguynju yaga yi-waḻirr-yi, anubani-rruj ana-lhal wugurri-nyinyung-duj na-Ninyarra-yung-duj. Nugurru-maynji numburraan-bawalhang aadanu, marri anubani-yung numburraawanggina-windiyung nugurru!” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Naagi-yung na-Jesus ni-yambini-wugij. “Nguynju-waj, warruburru-yung warru-mandag anaarrwar-yinyung nguynju a-gold-jii, wu-julubina aabaḻa-rruj. Aynjaabu-nyung waḻyinyung niwu-lhangarrmayn marri aḏaba niga niwu-wurrdhangi ngijang. Niga yagu ni-waḻaaḻarrangi. Anubani-yung niga ni-yanggi marri waniini anaarrawindi-lhangu niga niwu-bayandhangi anubani-yung anaabaḻa. ");
INSERT INTO nuy_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Nguynju-waj warruburru-yung warru-mandag anaarrwar-yinyung nguynju na-waḻyinyung niga ni-walhaga-lharrmani mamanunggu-yinyung wu-warra-ngal-ngalii-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Aḏaba niga niwu-lhangarrmayn anubani-yung mamanunggu-yinyung wu-warra-ngal-ngalangi-yinyung, niga ni-yanggi marri waniini anaarrawindi-lhangu niga ni-warra-waṉagaa-yinyung marri niwu-bayandhangi anubani wu-warra-ngal-ngalangi-yinyung.” ");
INSERT INTO nuy_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Naagi-yung na-Jesus ni-yambini-wugij. “Nguynju-waj, warruburru-yung warru-mandag anaarrwar-yinyung, wu-yamana ama-naynja-yii wirrima-burri ama-lhagayag-guy marri wurru-mangi arrawindi aynba-gaynbaj-jinyung ana-ngujija. ");
INSERT INTO nuy_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Manubami-yung mana-naynja ma-ḏamadhan-maa, wurru-manga-mangi-yinyung ana-ngujija warra-waḻya-waḻya wirrimaarrgini mana-naynja mana-madhalag-duj. Wugurru wurru-burri marri wurraarra-ngu-burrangi arrawindi mamanunggu-yinyung ana-ngujija mana-gaṉdharra-rruj, wugurraayung wurraarra-barawudangi anaalaaladi-yinyung ana-ngujija. ");
INSERT INTO nuy_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","“Anaani anggu-yamana anubani-rruj anggu-dhaag-mana-rruj. Marri ana-angel anggu-waṉiyn marri ambanggu-waḻgaḻwana warraalaaladi-yinyung anubanila-wala warra-mamanunggu-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Marri ana-angel ambanggu-barawudii warraalaaladi-yinyung buguni a-ngura-wuy. Anubagu warruburru-yung amburru-ruguna marri amburru-ra-bangaynjina amburraarragayii yamba wugurru.” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Anubanila-wala, naagi-yung na-Jesus wani-magaa, nigawi-nyinyung wurru-marrbuy-maa-yinyung. Ni-yamayn “Yuga nugurru nurru-marrbuy anaani anaarrawindi-lhangu?” ni-yamayn. Wugurraayung “Yii” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nigaayung ni-yamayn, “Yagu mulung-arrgi-yung warra-yiyina-yinyung ana-lhaawu-runggal, amburru-marrbuy-mana-maynji warruburru-yung-jinyung warru-mandag anaarrwar-yinyung, wugurru amburru-yamana nguynju nubagi-yung na-waḻyinyung niwu-waṉagana-yinyung ana-wumurrng. Niga niwu-yarrijgina wu-gadhuwa anaarrawindi-lhangu marri ana-nungguḏaaba anaarrawindi-lhangu.” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Aḏaba naagi-yung na-Jesus niwu-jadugayn wani-bajiyini-yinyung anaani-yung ana-lhaawu, niga niwaarruyn anubagu. ");
INSERT INTO nuy_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Anubani-yung ni-yanggi nigawi-wuy wubani-wuy a-lhal-wuy. Marri wani-bajiyini warra-wurru-wurruj ana-synagog-duj marri wugurru wurru-wurrij-gaḻaaḻarriyn. Marri wurru-yamayn, “Marri naagi ajigala wunu-marrba-marrbuy-waa, anaani aniijgubulu-walawaj? Yangi-nyung? Ajigala ni-waṉbini aynba-gaynbaj lhuḏ-mirri? ");
INSERT INTO nuy_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Niga na-niwiyayung niwu-rana-raani-yinyung. Nigawi-nyinyung nga-rriibi-yung Mary, marri nigawi-nyinyung warra-minilharri-yung na-James marri na-Joseph marri na-Simon marri na-Jude, warruburru-yung. ");
INSERT INTO nuy_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Marri warra-miyn-ngarrilharri-yung yaawurru ngurraanggarra-ngu-burraa. Ajigala ni-warra-mangi anaarrawindi-lhangu?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Marri wunaagaminij-gaandirrangi. Yagu nigaayung na-Jesus wani-yamijgayn wugurri-wuy, “Warruburru-yung wunaa-ja-jambini-yinyung na-God, warra-wurru-wurruj wugurraayung warraagaminij-gaandirrangi, warruburru-yung wugurri-nyinyung-jinyung anubani-yung ana-lhal, marri wugurri-rruj anubani anaanga. Anubani-yung ana-lhal-aynbaj-gala ana-lhal, wurru-yanggi warruburru-yung, warra-ngaynbandangi wugurru,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yagu anubani-rruj ana-lhal, waari ani-waṉbini aniij-mamaaḻang ambani-maṉmangi-yinyung, wugurru yamba waari ambunaa-ngu-jambarrgini nigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Anubani-yumbaa na-Herod, naagi-yung ni-buunggawa-maa, anubani-rruj ana-Galilee. Anubani-yung ni-wawanggiyn anubani-yung ana-lhaawu na-Jesus-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nguynju-waj naagi-yung wani-magaa nigawi-nyinyung-guy warruburru-yung wurru-mijgalmini-yinyung, “Na-Jesus nubagi niga na-John nubagi waniimbara-ngambijgaa-yinyung, niga nubagi-yung ni-ḻaḻagiiyn anubanila-wala ana-ngawij! Anubani yamba niga ni-waṉbina anaani-yinyung ana-lhuḏ,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Anubani-yung ana-raga-ragij anaani-yung wu-waṉiyn. Na-Herod-jinyung na-nilharri-yung na-Philip ngarraagi-yung niiynji-yaay ngarra-ngarrimuwaj-jung Herodias. Marri na-Herod nigaayung ngu-miyn, ngijang niga-waj niiynji-yaay ngiga. Nigaayung na-John ni-yamayn na-Herod-guy, “Yagi nunaa-gaṉa-mi ngarra-maṉinyung na-nilharri-yinyung, yagu anaani waari aniij-mamaaḻang-magaa,” ni-yamayn. Wudani-yung-gala, nigaayung na-Herod nu-magaa aynjaabu-nyung wurrujung, anubuguni ni-yanggi, nga bagu nu-miyn, nga nu-radbini, niga na-John. Marri wunu-yarrijgini yuuguni wubani wu-dhi-dhidini-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Na-Herod nu-ngaynbandangi anubani-yung anu-wini niga na-John, yagu anubani-yung niga na-Herod ni-ḏirrngawini warruburru-wala warra-wurru-wurruj, yagu yamba warruburru-yung wugurru wurru-yamaa, “Niga na-John, nubagi naa-ja-jambina-yinyung na-God,” wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Anubani-rruj na-Herod-jinyung niimbuḻwiyn-jinyung wurru-burri, ngarrubagi-yung ngarra-Herodias-jinyung ngarra-ngarrimarayung ngi-wan.ngaa wungubal nubagi-yinyung na-Herod-jinyung marri nigawi-nyinyung warruburru-yung wurru-burri-yinyung anga-rruj. Marri ngiga ngunu-waḻaaḻarrijgayn-bindiyung. ");
INSERT INTO nuy_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nguynju-waj niga na-Herod anubani-yung ngu-lhalamayaa anubani-yung yijgubulu-windiyung, “Nimba-yandhawiwana-maynji anubani-yung anaarrgi-yung, marri anubani-yung wiiyii,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ngigaayung ngarrubagi-yung Herodias anubani-yung ngu-magaa ngiga ngarra-ngarrimarayung. Nguynju yadhu ngigaayung ngarra-ngaḻaynjinyung ngi-yamaa nubagi-wuy na-Herod-guy, “Nimbiiyn anubani-yung ngayawi-wuy ana-yinag na-John, yaani-wuy arrwar ama-plate-duj,” ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Yagu anubani-yung aḏaba na-runggal-yung na-Herod niga anubani-yung ni-wurrij-galadi-wiiyn-bindiyung. Yagu anubani-yung ni-wawanggini anubani-yung ngu-lhalamayaa-yinyung, marri ni-warranggaa warruburru-wuy warra-mulung-aynbaj-guy, wugurru yamba wurraawanggini ana-lhaawu. Nga ni-wijangani, ngiga ngiwu-ngaynbandangi-yinyung, anubani-yung anggu-waṉbini. ");
INSERT INTO nuy_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Niga wani-lharrgang warruburru-yung wugurru wurru-wiynji-wiynjini-yinyung, wunu-yinag-guldhiyn na-John-jinyung a-yinag. ");
INSERT INTO nuy_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Marri aḏaba wugurru warruburru-yung wirri-yurangi anubani-yung arrwar ama-plate-duj marri wirringa-yayn ngarra-ngaḻaynjinyung-guy, anubani ngiwu-yarrijgini nga ngu-yayn nga-rriibi-yung-guy. ");
INSERT INTO nuy_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yagu warruburru-yung niga na-John-jinyung wunu-garrindharrmangi-yinyung wurru-yanggi marri wirri-miyn anubani-yung nigawi-nyinyung ana-wubulu marri wirri-wurrdhangi bagu, nga aḏaba warruburru-yung wurru-yanggi marri wunu-magaa nubagi-yung na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nigaayung na-Jesus ni-wawanggiyn ana-lhaawu na-John-jinyung, niga anubani-yung niwaarruyn anubani ana-lhal. Ni-yanggi barrawu-mirri, wubani-wuy a-lhamaamura-wuy a-lhal, nguynju yungguyung bagu ni-wiri-wiri niga ni-burri. Yagu warruburru-yung warru-mandag wurraawanggiyn aḏaba anubani-yung marri wunu-garrindharrmangi niga, wurru-yanggi mun-mirri bagala aanga-wala. ");
INSERT INTO nuy_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nigaayung na-Jesus marri warruburru-yung wurru-marrbuy-maa-yinyung anubagu wurru-waliyn, wurraadadiyn anu-ngarrg-duj, wurraarranggayn yuuguni garnyirrimba. Niga anubani-yung wani-warrngayuyn warruburru-yung marri wani-maji-waa warruburru-yung wugurru wurru-lhangurrngandi-maynji. ");
INSERT INTO nuy_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Aḏaba waadhaadharrwara-maa. Wugurru warruburru-yung nigawi-nyinyung wurru-marrbuy-maa-yinyung wurru-yanggi buguni nigawi-wuy marri wurru-yamayn, “Anaani yagu a-lhamaamura-rruj ngurru-burraa. Anaani aḏaba waadhaadharrwara-mana. Bamba-lharrganjii warraawurru warra-wurru-wurruj aḏaba nguynju yadhu wugurru aḏaba amburru-yaarri buguni wubani-wuy aanga aani-rruj a-lhal, marri amburru-mani wugurri-nyinyung marrya,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yagu nigaayung na-Jesus ni-yamayn, “Wugurru anubani-yung waari wurru-rumi. Nugurru-waj nambarriiyii wugurru warruburru-yung amburru-nguyii,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Wugurraayung wurru-yamayn “Yagu nurru anaani nurru-waṉagana marang-aynjaabugij wuḏayn marri wulawaa ngujija, dani-yung-bugij” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nigaayung ni-yamayn, “Numburru-yuri ngayawi-wuy.” ");
INSERT INTO nuy_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nga nigaayung wani-yamijgayn warruburru-wuy warraarraarrawindi-wuy, “Numburru-burrangang daju a-maḏa-rruj,” ni-yamayn. Anubani-yung aḏaba niwu-miyn anubani-yung ana-marang-aynjaabugij anu-ḏayn marri ana-wulawaa ana-ngujija, marri yaanuwuy ni-mal-nayn arrwiyaj, marri nu-warraarriwaa na-God. Anubani-yung anu-ḏayn ni-rayn-bawayuwaa aḏaba, waniini anaani-yung warruburru-yung-guy wurru-marrbuy-maa-yinyung. Marri buguni warriini warra-wurru-wurruj-guy. ");
INSERT INTO nuy_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Warruburru-yung wurru-nguni, marri wurru-waḻarrandi, bani-yung marri. Nga aḏaba wurru-mangi wurru-muṉḏugaa anu-gamuymuy, manubama-yung mana-gaṉdharra, 12. Anu-gamuymuy buguni wurru-burrangi. ");
INSERT INTO nuy_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Muga warruburru-yung 5000 warra-waḻya-waḻya muga warruburru-yung wurru-nguni, marri waari ambarra-nguynmawaa warra-maṉaṉung marri warra-mijburrayung. ");
INSERT INTO nuy_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Lhugaajgiyalawaj, wani-yamijgayn warruburru-yung wurru-marrbuy-maa-yinyung, “Numbuu-yaarri ama-barrawu-wuy, marri numbuu-yaarri numbuu-ragaana buguni wagagala-wuy wubani-rruj a-wurugu-rruj,” ni-yamayn. Wani-yamijgayn warra-garnyirrimba, “Numbuu-ngarra-gaagiyn aḏaba aanga-wuy,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Anubanila-wala, niga ni-yanggi ni-wiri-wiri amubama-wuy bagu ama-magabang-guy, ni-yambini na-God-guy niga. Wurrugu anubani-yung ngarraaḻirr ngi-dhaarri aḏaba, niga anubagu ni-burri-wugij ni-wiri-wiri niga. ");
INSERT INTO nuy_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Anubani-yung mana-barrawu a-yarrmayarrmaj ma-burri anubanila-wala ana-lhal. Anubani-yung anaa-gugu jurangi, yagu yamba wudhanguyn yamba wu-wayamangi yuwaagala, wanggu-raganmayn. ");
INSERT INTO nuy_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Wurrugu ni-burri, wu-biinga-mudangi yamba. Wurrugu ngu-rangarrangi ngarrubagi-yung ngarraaḻirr ngiimbarra-nagini lhaalhag. Marri bani-yung ni-jarrarriyn arrwar aa-gugu-waj. ");
INSERT INTO nuy_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Warraawurru-yung wugurraayung wunu-nayn. Ni-yangga-yanggi aa-gugu-waj. Yagu anubani-yung warraawurru-yung wurru-ḏirrngawiiyn-bindiyung. “Baḏirrnya!” wurru-yamayn. Marri wurru-wuwudangi warraawurru-yung. ");
INSERT INTO nuy_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nga nigaayung wani-yamijgayn, “Wiiya! Anaani ngaya-waj. Yagi nurru-ḏirrngawi, numburru-wurrij-baabara,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nigaayung na-Peter ni-yamayn, “Buunggawa, aniijgubulu-maynji nagang, nimba-magang ngaya, ngaynjaarri nugawi-wuy arrwar aa-gugu-waj,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nigaayung na-Jesus ni-yamayn “Baaṉina,” marri nubagi-yung na-Peter nimaarruyn mana-barrawu marri ni-yanggi arrwar aa-gugu-waj buguni na-Jesus-guy. ");
INSERT INTO nuy_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Yagu naagi-yung niwu-nayn ana-wudhanguyn marri anaa-gugu, niga nubagi-yung ni-ḏirrngawini marri ni-wurrlhangi. Naagi-yung niiḏangi, “Buunggawa, nimba-maṉmang ngaya!” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nigaayung lhugaajgiyalawaj ni-marang-dhaayiyn marri nu-miyn na-Peter marri ni-yamayn, “Nagang numburrij-gadhaari-mina, nu-ngu-jambarrgiiyn winyig?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Anubanila-wala, wuguṉi wini-yabaynjiyn ama-barrawu-wuy nga aḏaba anubani-yung ana-wudhanguyn wu-muḏaḏbiyn. ");
INSERT INTO nuy_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nga aḏaba warruburru-yung wugurru ama-barrawu-rruj wunu-warraarriwaa na-Jesus, marri wurru-yamaa, “Yijgubulu-windiyung nagang aadanu na-niwiyayung na-God-jinyung,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Anubani-yung wurraagaḻawajangi aḏaba wurraadadangi wagagala-wuy, wubani a-lhal-wuy wu-mayini Gennesaret. ");
INSERT INTO nuy_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Wugurraayung warruburru-yung wugurru warra-wurru-wurruj wurru-nguynju-gayn niga na-Jesus. Wugurru warra-magaa warruburru-yung warra-wurru-wurruj anubani-rruj ana-lhal, marri wugurru warra-yurangi warruburru-yung warru-dhu-dhangurrg buguni nigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Naagi-yung na-Jesus wunu-yandhawiwandi-magaa, “Warruburru-yung wurru-lhangurrngandi-yinyung, ambi-yaaḻi-waṉagang amubama-waj ama-mangudhig-duj,” wurru-yamaa-magaa. Yagu warruburru-yung warraarraarrawindi wunu-yaaḻi-waṉagaa, wurru-maṉdhini-magaa wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nga mulung-arrgi-yung warruburru-yung warra-Pharisee marri warruburru-yung warra-yiyini-yinyung ana-lhaawu-runggal, wurru-yanggi yuwaagala Jerusalem-gala buguni anubani-yung na-Jesus-guy. Warruburru-yung wugurru wunu-yandhawiwaa niga. ");
INSERT INTO nuy_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“A-yangi yadhu nagang warruburru wurru-marrbuy-maa-yinyung, waari amburru-yandhurrbangang ana-lhaawu warra-miyn-ngambara-yinyung? Anubani-yung waari ambirri-yarrbini wugurri-nyinyung ana-marang, arrbidi wurru-nguni ana-marrya,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yagu nigaayung na-Jesus wani-yambalmayn, “Marri a-yangi yadhu nugurri-nyinyung ana-lhaawu, nugurru nirri-garrindharrmani wugurru, yagu nugurru waari ambirri-yandhurrbangang na-God-jinyung ana-lhaawu nugurru? ");
INSERT INTO nuy_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Numburru-marrbuy anubani-yung na-God ni-yambini, (Exodus 20:12) ‘Banu-yandhurrbangana na-ninyarra marri nga-rriibi,’ ni-yamayn, marri ngijang, (Exodus 21:17) ‘Warraaynbaj-maynji warrubawa-yung ambu-yambina anaaladi na-ninyarra-yung-guy marri nga-rriibi-yung-guy, yijgubulu anubani-yung ambu-ngawang,’ Dani-yung ni-yamayn na-God. ");
INSERT INTO nuy_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","“Yagu na-wurrujung-maynji ari ani-yamang na-ninyarra-yung-guy marri nga-rriibi-yung-guy, ‘Anubani-yung ana-bayarra nuguṉi-nyinyung, yagu aḏaba nganu-yayn na-God-guy aḏaba,’ ari ani-yamang. Nugurru warra-Pharisee nurru-yamana, aḏaba wiiya, wiij-maṉdhina aḏaba, dani-yung nurru-yamana. ");
INSERT INTO nuy_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Yaani-yung nugurru narra-yiyina, yagi yadhu anubani-yung warra-yandhurrbi wugurri-nyinyung warra-mininyarra-yung marri warra-mijbiibi-yung. Anaani-yung wiijamana, anubani-yung nirriijaḻgiwajgana ana-lhaawu na-God-jinyung, nugurri-nyinyung-gala a-lhaawu.” ");
INSERT INTO nuy_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Naagi-yung na-Jesus ni-yambini-wugij. “Nugurru aadanu nurraambaḻaman-gina nugurraajbaj, yagu ana-lhirribala nurru-burraa malanganyanay na-God-gala. Niga nubagi-yung na-Isaiah anubani-yung yijgubulu-windiyung anubani-yung niga ni-yambini anubani-yinyung nugurru. Na-God ni-yamaa, ");
INSERT INTO nuy_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Warra-wurru-wurruj ngambi-warraarriwana a-ramadhan-gala, yagu anaandhiri anubani wu-burraa malanganya…nay ngayawi-wala. ");
INSERT INTO nuy_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yagu warruburru-yung ngambi-warraarriwana arrbidi, Anaaynbaj ana-lhaawu wiijanggi warra-wurru-wurruj-gala, yagu warruburru-yung warra-magana warra-mulung-aynbaj, anaani wiijanggi ngayawi-wala, yagu waari.’ Dani-yung na-God ni-yamaa, waarrarrina a-wubiba-rruj.” Dani-yung na-Jesus ni-yambini, anaarrawindi ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Anubanila-wala anubani-yung niga na-Jesus wanii-gaḏangi warruburru-yung warra-wurru-wurruj nigawi-wuy, niga ni-yamayn, “Numburraawanggina marri numburru-marrbuy-mana anaani. ");
INSERT INTO nuy_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","“Waari-magaa anubani-yung-magaa warra-wurru-wurruj ambirri-burrang-jinyung anubuguni wugurri-nyinyung-guy ana-ramadhan-guy, waari wanggaaladi-wi. Yaani nga ambanggaaladi-wana, anubani-yung wu-rabalii wugurri-wala ana-ramadhan-gala. Yaani nga ambanggaaladi-wana wugurru.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nga warruburru-yung nigawi-nyinyung wurru-marrbuy-maa-yinyung wurru-yanggi anubani-yung nigawi-wuy marri wunu-yandhawiwaa, “Yagu nagang nu-marrbuy, warruburru-yung warra-Pharisee wugurru anubani wurru-riyaldhiyn yagu yamba nagang nuynjambini.” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nigaayung na-Jesus ni-yamayn, “Anubani-yung anaarrawindi-lhangu waanuynjungina-yinyung anu-bal anubani-yung ngayawi-nyinyung na-Baba anaarrwar anubani-yung waari ani-wanuynjungaa niga-mirri, amburraarra-ngarrgiwana aaban-gala. ");
INSERT INTO nuy_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nambarraarruyn warra-Pharisee, wugurru yamba wurru-yamana nguynju nubagi-yung na-ba-galadi-nyung na-wurrujung, niga naaṉa-ṉimana naaynbajung-guy na-ba-galadi-nyung. Wuguṉi ambini-rabina wubani a-gara-wuy.” Dani-yung ni-yamayn niga. ");
INSERT INTO nuy_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nigaayung na-Peter ni-yamayn, “Nimba-magana anaani-yung-jinyung ana-lhaawu,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nigaayung na-Jesus ni-yamayn, “Yuga nugurraayunggaj nurru-maḻaḻadi, nurru-yamana nguynju warruburru-yung-jii? ");
INSERT INTO nuy_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Yagu waari numburru-marrbuy-maa, anubani-yung anaarrawindi-lhangu ana-marrya anubani-yung wu-yabina ana-ramadhan-guy wu-yaarri ama-gulmung-guy marri aḏaba wu-rabalii ana-wubulu-wala. ");
INSERT INTO nuy_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","“Yagu anubani-yung anggu-rabalang-maynji ana-ramadhan-gala warra-wurruj-gala, anggu-rabalang wugurri-wala aandhiri-wala, marri yaani-yung wanggaaladi-wana wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Wurru-wijangayii alaaladi, warra-mulunguwana, warraagamajaa warra-maṉaṉung, warrubawa-yung yaga yigaj warra-waḻya-waḻya marri warra-maṉaṉung wurru-maynjina yaga. Marri wurraamajaa, wurraawaḻii, anubani-yung warraarra-yamawaynjina warra-mulung-aynbaj-guy. ");
INSERT INTO nuy_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Dani-yung nga nambanggaaladi-wana nugurru. Yagu numburru-nguyii-maynji, waari-yinyung nirri-yarrbu ana-marang, wiiya aḏaba, anubani-yung waari wugurru nanggaaladi-wi nugurru.” Dani-yung ni-yambini na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Anubanila-wala na-Jesus ni-yanggi anubanila-wala ana-lhal. Ni-yanggi wunumbiyaj wubani-wuy a-lhal a-Tyre-wuy marri a-Sidon-guy. ");
INSERT INTO nuy_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ngarrubagi-yung maṉinyung a-Canaan-jinyung yuwaagala wubanila-wala a-lhal ngi-yanggi buguni na-Jesus-guy. Ngiiḏangi yanggarrwar, “Runggal-yung na-niwiyayung na-David-jinyung, nimba-man.galagana ngaya! Ngayawi-nyinyung ngarra-marig anubani-yung ngi-waṉagana man.gurrg marri ngiga ngi-warragayii runggal-windiyung,” ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yagu nigaayung na-Jesus anubani-yung waari angu-yambalmaa ngarra-maṉinyung. Yagu nigawi-nyinyung wurru-marrbuy-maa-yinyung wurru-yanggi buguni na-Jesus-guy, nga wurru-yamayn, “Bangu-magang ngarrubagi-yung angi-yaarri, ngiga ngarrangi-garrindharrmani-wugij ngagurru marri ngiiḏii-wugij,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Aḏaba nigaayung na-Jesus ni-yamayn, “Na-God ngani-lharrgang ngaya, warruburru-wuy wurraaṉibina-wuy, warruburru-yung warra-wurru-wurruj warra-Israel, burru-yung-bugij,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ngigaayung ngarrubagi-yung ngarra-maṉinyung ngi-yanggi na-Jesus-guy ngijang marri ngi-ḻandharrdhangayn raga-ragij nigawi-rruj marri ngi-yamayn, “Buunggawa, nimba-maṉmang ngaya!” ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nigaayung ni-yamayn, “Waari nurru nurru-mi anubani-yung ana-marrya warruburrala-wala warra-mijburrayung-gala marri narra-yu wugurri-nyinyung warra-ḻandhurrg-guy, waari aadanu anggiij-maṉdhiiyn.” ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ngigaayung ngi-yamayn, “Yii Buunggawa, yagu warrubawa-yung wugurru warra-ḻandhurrg wu-nguyii anubani anu-gamuymuy waadbarrwina-yinyung warrubawa-wala wugurri-nyinyung-gala a-table-wala,” ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nigaayung na-Jesus ni-yamayn, “Bani-yung, nagang aadanu nu-ngu-jambarrgiiyn runggal-windiyung. Ngaya anubani nganggaṉbina nugawi-yii nuynjambini-yii.” ni-yamayn. Marri aḏaba ngarrubagi-yung ngarra-maṉinyung ngarra-ngarrimarayung ngi-maji-mayn ngiga. ");
INSERT INTO nuy_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Anubanila-wala niga na-Jesus ni-yanggi, anubani-yung ni-yanggi bagala-yung ama-madhaḻag-baj ana-wurugu-waj ana-Galilee-waj. Anubani-yung ni-yanggi arrwar ama-magabang-guy marri niindhadhi bagu. ");
INSERT INTO nuy_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Warruburru-yung garnyirrimba wumandag wurru-yanggi anubani-yung na-Jesus-guy. Warra-yarrijgini warruburru-yung wugurru wurru-babaaḏii-yinyung marri wurru-ba-galadi-yinyung marri warraarra-guṉḏa-guṉḏa-yinyung marri warruburru-yung waari amburru-yambini-yinyung, marri arrawindi ngijang wugurru. Wugurru warra-burrangi bagu na-Jesus-duj raga-ragij a-mun-duj, marri wani-maji-waa wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Warruburru-yung warru-mandag anubani-yung wurru-wurrij-gaḻaaḻarrangi, wugurru yamba warra-nayn anubani-yung warra-wurru-wurruj wugurru anubani-yung waari-yinyung ambu-yamba-yambini ana-wulhu-wulhurr, yagu aḏaba anaani wurru-yambini. Marri warruburru-yung warraarra-guṉḏa-guṉḏa-yinyung wugurru anubani-yung wurru-waḏa-waḏaḏ marri warruburru-yung wurru-babaaḏii-yinyung wuu-jarrarrangi marri warra-ba-galadi-yinyung wurraarranggaa. Anubani-yung wugurru wunu-warraarriwaa na-God warruburru-yung-jinyung warra-Israel. ");
INSERT INTO nuy_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Anubani-yung niga na-Jesus wanii-gaḏiyn nigawi-nyinyung wurru-marrbuy-maa-yinyung nigawi-wuy marri ni-yamayn, “Warruburru warra-garnyirrimba wurraanggarra-yanggi aḏaba ngi-waḻirr-wulaynbaj. Waari ana-marrya amburru-waṉagaa. Ngaya ngarra-warrngayuyn, warraawurru yamba wurru-marryaadii. Ngaya anubani waari ngarra-lharrgi wugurru wurru-marryaadi-yinyung anubani-magi wugurru wurru-rabingun-magi wurru-yanggan-magi aanga-wuy.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wugurraayung wurru-yamayn, “Yagu ngaambu-yaminggarrang anubani-yung ngaambu-mani ana-marrya anubani-yung ngaambiiyii warruburru-yung warraarrawindi warraawurru warra-wurru-wurruj? Ngagurru anaani ngurru-burraa a-yarrmayarrmaj anubanila-wala anaanga,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nigaayung na-Jesus ni-yamayn, “Wu-ngargu yuga anu-ḏayn nugurru anubani nurru-waṉagana yuga?” Wugurraayung wurru-yamayn, “Marang-aynjaabugij marri wulawaa, marri adharra wurraayung ngujija,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yagu wani-magayn warruburru warraarrawindi, “Numburraambargalang daju aaban-duj,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Anubani-yung niga ni-miyn ana-marang-aynjaabugij marri anuulawaa anu-ḏayn marri ana-ngujija, marri nu-warraarriwaa na-God-guy, nga niga ni-rayn-bawaayuwaa anubani-yung ana-marrya, marri waniini warruburru-yung wurru-marrbuy-maa-yinyung, marri anubani-yung warriini warruburru-wuy warra-wurru-wurruj. ");
INSERT INTO nuy_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Anubani-yung aḏaba warruburru-yung wurru-nguni marri wurru-waḻarrang. Anubanila-wala, warruburru-yung wurru-marrbuy-maa-yinyung wurru-ragaa anu-gamuymuy, manaama-yung mana-gaṉdharra marang-aynjaabugij marri muulawaa, wurru-yabaa buguni. ");
INSERT INTO nuy_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Warruburru-yung wugurru 4000 warra-waḻya-waḻya anubani-yung wugurru wurru-nguni anubagu, marri warra-maṉaṉung-duj marri warra-mijburrayung-duj. ");
INSERT INTO nuy_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Aḏaba anubani-yung niga na-Jesus wani-lharrgandi warruburru-yung warra-wurru-wurruj, aḏaba ni-yabaynjiyn ama-barrawu-wuy marri ni-yanggi wubani-wuy a-lhal Magadan-guy. ");
INSERT INTO nuy_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Warruburru-yung warra-Pharisee marri warra-Sadducee wurru-yanggi buguni na-Jesus-guy ambunu-dhaayurrijgaa yungguyung niga. Wugurru wunu-magaa, “Nimba-bajiyina malnguj aarrwar-wala.” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nigaayung ni-yamayn, “Ngarrubagi angi-yabina-rruj ngarraaḻirr nugurru anubani-yung nurru-yamana, ‘Ngagurru anubani-yung ngaanggu-waṉagana mamanunggu wudhanguyn yagu yamba anubani-yung ana-wumala nguynju yaga ama-buḻbarr-yii.’ ");
INSERT INTO nuy_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Marri ana-ngamugijgaj nugurru anubani-yung nurru-yamana ‘Anubani-yung nga angi-warra-rabina aṉbana yagu yamba anubani-yung ana-wumala angudumang marri ama-buḻbarr-yii,’ nurru-yamana. Nugurru nurru-marrbuy anubani ana-wumala-rruj, marri nurru-marrbuy anaani wu-yamana-yinyung. Yagu nugurru anubani-yung nurraarra-nayii anaarrawindi-lhangu na-God nani-bajiyina anaani ana-yimbaj, marri nugurru nurru-maḻaḻadi wiijaminggarrina-yinyung, warru-mandag-jinyung anaarrwar.” ");
INSERT INTO nuy_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Naagi-yung na-Jesus ni-yambini-wugij. “Nugurru aadanu nurraalaaladi-yinyung nirri-ngaynbandii nimbirri-nayii ana-malnguj na-God-gala. Yagu na-God niga yagi nani-yu nugurru. Na-God niga ani-wij-garrarra-gana-wugij anubani-yung yaga nguynju nubagi-yung-jii na-waḻyinyung-jii, na-nimuwaj-jung ni-mayini na-Jonah, wiijamana.” Dani-yung ni-yamayn na-Jesus. Nga aḏaba niga waniirruyn wugurru marri ni-yanggi aḏaba. ");
INSERT INTO nuy_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Naagi-yung na-Jesus marri warruburru-yung wurru-marrbuy-maa-yinyung wurru-yabaynjiyn ama-barrawu-wuy, nga wurru-yanggi wagagala-wuy wubani-wuy a-wurugu, yagu anubani-yung wugurru wurru-warandhalabiyn, waari anubani-yung amburru-waṉagaa anu-ḏayn. ");
INSERT INTO nuy_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Na-Jesus anaani-yung ni-yamaa, “Numburru-dhi-maṉdhina aadanu, anubani-yung-jinyung anu-ḏayn warruburru-yinyung warra-Pharisee-yinyung marri warra-Sadducee-yinyung,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Wugurraayung warruburru-yung nigawi-nyinyung wurru-marrbuy-maa-yinyung wurru-yambini anubani-yung-jinyung. “Anubani-yung niga ni-yambini ngagurru yamba ngurru-warandhalabiyn, waari anubani-yung ngaambu-waṉagang anu-ḏayn,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yagu nigaayung na-Jesus ni-marrbuy, anubani-yung wugurru wurru-yambiynjini-yinyung. Naagi-yung ni-yamayn, “Nugurru waari numburru-jambarrgang-bindiyung! A-yangi yadhu nugurru aadanu nurru-yambiynjina waari numburru-waṉagang anu-ḏayn nugurri-nyinyung? ");
INSERT INTO nuy_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Yuga nugurru waari numburru-marrbuy-dhini? Nurru-marrbuy anubani-yung ana-marang-aynjaabugij anu-ḏayn warruburru-yung-jinyung 5,000? Marri nurru-marrbuy ma-ngargu mana-gaṉdharra anu-gamuymuy-yinyung, nurru-yabaa manubami-wuy? ");
INSERT INTO nuy_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Marri anubani-yung marang-aynjaabugij marri wulawaa anubani-yung anu-ḏayn warruburru-yung-jinyung 4,000 marri ma-ngargu mana-gaṉdharra anu-gamuymuy-yinyung? ");
INSERT INTO nuy_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","“Anubani-yung waari-windiyung ngaya ngaynjambini anubani-yinyung anu-ḏayn. Nugurru nurru-yaminggarrina, waari nurru-marrbuy-mayn anubani-yung? Numburru-dhi-maṉdhina aadanu, anubani-yung-jinyung anu-ḏayn warruburru-yinyung warra-Pharisee-yinyung marri warra-Sadducee-yinyung,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Wugurraayung wurru-marrbuy anubani-yung niga anubani-yung waari ambani-magaa anubani-yung-jinyung anu-ḏayn ana-marrya, yagu wani-magaa anubani-yung-jinyung ana-lhaawu warruburru-yung-jinyung warra-Pharisee marri warra-Sadducee wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Anubani-yung na-Jesus marri warruburru-yung wurru-marrbuy-maa-yinyung wurru-yanggi anubani-wuy ana-lhal a-Caesarea Philippi. Niga na-Jesus ni-yambini, “Ngaya anaani, na-Niwiyayung na-Wurrujung-jinyung. Yangi-nyung warruburru-yung warra-wurru-wurruj wurru-yamaa, ngayawi-nyinyung, yuga?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Wugurraayung wurru-yamayn, “Warra-mulung-arrgi wurru-yamana nagang aadanu John, nubagi-yung yaga waniimbara-ngambijgaa-yinyung. Wugurraayung warra-mulung-arrgi wurru-yamana nagang aadanu Elijah, marri ngijang mulung-arrgi-yung wurru-yamana nagang Jeremiah yagu nubagi-yung aynjaabu-nyung warruburru-yung yaga wunaa-ja-jambini na-God-jinyung,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nga nigaayung ni-yamayn “Yagu nugurru aadanu, yangi-nyung yuga nugurru nurru-yamana ngaya anaani?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nubagi-yung na-Simon Peter ni-yamayn, “Nagang aadanu na-Christ, na-Niwiyayung ni-wiri-yinyung na-God,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Anubani-yung na-Jesus nu-yambalmayn, “Nagang nini-warra-yarijgayn na-God, Simon na-niwiyayung na-Jonah-yinyung, yagu yamba waari warra-wurruj ambi-bajiyini nagang. Anubani-yung ngayawi-nyinyung na-Baba anaarrwar nini-bajiyini nagang, ngayawi-nyinyung anaani. ");
INSERT INTO nuy_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Marri ngaya ngunu-magana, nagang aadanu Peter, nagang yamba nuynjamana nguynju ama-ṉuga-yii. Marri manaami-rruj mana-ṉuga anubani-yung ngaya ngamba-muṉḏugijgana ngayawi-nyinyung wurru-jambarrgina-yinyung, bamba-ragaana wugurru. Marri ana-lhuḏ ana-ngawij-jinyung, waari wu-lhuḏ-gugumi, wurru-burraa-wugij wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Anubani-yung ngaya wiiyn nagang anubani-yung ana-key anubani-yung-jinyung ana-lhal anaarrwar. Nagang bamba-magana warra-wurru-wurruj-guy anaani-rruj ana-lhal, anubani-yung-jinyung amburru-waṉbina-yinyung marri waari-yinyung wurru-waṉbi-yinyung. Marri niga na-God ani-wijangayii nguynju-waj anubani-rruj anaarrwar.” Dani-yung ni-yambini na-Jesus, nu-magaa na-Peter-wuy niga. ");
INSERT INTO nuy_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nga aḏaba naagi-yung na-Jesus wani-magaa, anubani-yung yagi warra-magi warra-mulung-arrgi anubani-yung niga nubagi na-Christ na-Runggal-yung. ");
INSERT INTO nuy_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Anubanila-wala aḏaba, niga wani-magaa nigawi-nyinyung wurru-marrbuy-maa-yinyung, ni-yamaa, “Ngaya anaani ngaynjaarri Jerusalem-guy. Marri nganggarra-garragayii runggal-windiyung. Warruburru-yung warra-mijiwanggu, warra-runggu-runggal warra-priest marri warra-yiyina-yinyung ana-lhaawu-runggal ngambambiindirrang ngaya. Warra-mulung-aynbaj warruburru-yung ngambambiimana. Marri amuulawaa-wala mana-miyn.nganga wurrugu, ngaya nga-ḻaḻagiiyn ana-ngawij-gala.” Dani-yung ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nigaayung na-Peter nu-ḻaḻagayn, “Baaṉiyn yuwaagu, naynjambiynjina.” Marri ni-yamayn, “Yagi nunggaṉbi! Na-God ani-maṉmani nagang! Anubani yagi wu-waṉbi nugawi-wuy,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nga aḏaba na-Jesus ni-yambini anubani-yung na-Peter-wuy, “Ba-yaarri baagiyn yuuguni a-magarri-wuy, Satan! Nagang aadanu waari nimba-maṉmi ngaya. Nagang aadanu waari na-God-jinyung-magaa, nagang aadanu warra-wurru-wurruj-gala nu-ngu-burraa,” ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nga na-Jesus wani-magaa anubani-yung nigawi-yung-guy wurru-marrbuy-maa-yinyung, “Nugurru-maynji ngirri-ngaynbandii-maynji anubani-yung ngirri-garrindharrmani ngaya, anubani-yung nugurru numburru-yiynjang marri nimbirri-warrgu anu-ḏangag marri bani-yung ngirri-garrindharrmani ngaya. ");
INSERT INTO nuy_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Na-wurrujung-maynji anubani-yung aniwu-waṉagana-maynji nigawi-nyinyung ana-wiri, wurrugu marri yijgubulu anggu-wurag. Yagu anubani-yung-maynji aniwaarruyn-maynji ana-wiri nigawi-nyinyung, ngayawi yungguyung, wurrugu marri nubagi-yung ani-wiri-mang. ");
INSERT INTO nuy_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nubagi-yung-maynji na-wurrujung aniwu-mang-maynji anaani ana-lhal-lhangu, yagu wurrugu marri anggu-wurag nigawi-nyinyung ana-wiri, aadanu wiijamana yij-galadi. Nubagi-yung-maynji na-wurrujung ani-bayarra-giiyn-maynji nigawi-nyinyung ana-wiri, yuga anubani-yung wiij-maṉdhina? Yangi ana-bayarra? Waari! ");
INSERT INTO nuy_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ngaya anaani na-Niwiyayung na-Wurrujung-jinyung, anubani-yung-maynji ngandaagiyn anuwaagala anaarrwar-wala, wubani-rruj wu-milhiynjina-rruj na-Baba-yinyung, marri anubani-yung anaarrawindi ana-angel. Marri bani-yung, ngaya anamba-bayarra-gana anubani-yung-jinyung nurru-waṉbini. ");
INSERT INTO nuy_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Ngaya anaani ngana-magana nugurru aadanu yijgubulu-windiyung, mulung-arrgi-yung nugurru aadanu aḏaba nurraarra-garra-lhara, ngirri-nayii ngaya-waj na-Niwiyayung na-Wurrujung-jinyung, ngandaagiyn marri ngamba-narrii ngayawi-nyinyung warru-mandag, lhuḏ-mirri, numburru-wiri-waj-bugij aadanu.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Marang-aynjaabugij marri jarranggay ngarraaḻirr wurrugu, na-Jesus wani-miyn na-Peter marri na-James marri na-John nubagi-yung na-nilharri-yung na-James-inyung. Anubani-yung wurru-yanggi arrwar ma-ḻandhirrngindi-wuy wugurraajbaj. ");
INSERT INTO nuy_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nga bagu wunu-nani. Nigaayung na-God naagi-yung na-Jesus naaynbijgayn. Nigawi-nyinyung nani-jilhal-yung wu-lhalmbaarrangi nguynju yi-waḻirr-yii, marri nigawi-nyinyung mana-yaaḻi ma-ngalngalangi nguynju wudhalng-jii. ");
INSERT INTO nuy_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Warraawurru-yung wurraarranggayn, Moses marri Elijah, wurraanggarra-garra-lhi na-Jesus. Marri wurru-yambiynjini, nigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nigaayung na-Peter ni-yamayn na-Jesus-guy, “Buunggawa, anaani nurru wiij-maṉdhina nurru-burraa nugawi-rruj. Nagang-maynji bawu-ngaynbandang, ngaya anaani nganggu-maṉdhii angguulaynbaj ana-ruluj, aynjaabugij nugawi-nyinyung, aynjaabugij na-Moses-inyung marri aynjaabugij na-Elijah-yinyung,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Naagi-yung na-Peter ni-yambini-wugij, ngubunung yuwaagala wu-yanggi, warruburru-wuy wugurru wanggaambamadhiyn, wu-ngal-ngalangi-yinyung ana-ngubunung. Yang wu-rabaliyn wubanila-wala a-ngubunung-gala, God ni-yambini, ni-yamayn “Naagi ngayawi-nyinyung na-Nigi, ngaya nganaa-ḏamarr-ngu-burraa, marri ngaya anaani ngaaḻaaḻarrii nigawi-wuy. Nigawi-wuy numbunaa-gawanggina aadanu.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wugurraayung warruburru-yung wurru-marrbuy-maa-yinyung wurraawanggini ana-yang, wugurru wurru-ḏirrngawiiyn-bindiyung marri wugurru wuu-ngarra-ḏabini aaban-guy. ");
INSERT INTO nuy_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yagu nigaayung na-Jesus ni-yanggi wugurri-wuy marri wani-waṉagayn wugurru marri ni-yamayn, “Numburru-ḻaḻagiiyn, yagi nurru-ḏirrngawi,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Wugurraayung wurraarranggayn, wugurru wunu-nayn na-Jesus, aḏaba ni-wiri-wiri. ");
INSERT INTO nuy_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Anubanila-wala wugurru wurru-dhirridangi amubama-waj ama-ṉuga-waj. Nigaayung na-Jesus wani-magaa wugurru, “Yagi narra-magi warra-mulung-aynbaj-guy anubani-yung nurraarra-nani-yinyung. Ngaya, na-Niwiyayung na-Wurrujung-jinyung, anubani-yung nga-ḻaḻagiiyn ana-ngawij-gala. Marri bani-yung nambarra-magana,” ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Marri warraawurru-yung wurru-marrbuy-maa-yinyung wunu-yandhawiwandi na-Jesus, “Wuu-yaminggarrini wuu-yambini warra-yiyina-yinyung ana-lhaawu-runggal, wurru-yamana, na-Elijah ani-yaarri raga-ragij, nubagi-yung naa-ja-jambini-yinyung na-God?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nigaayung na-Jesus ni-yamayn, “Yuu, danu nga na-Elijah ani-ragayang ani-yaarri, ana-wulhu-wulhurr, marri ani-warra-maṉdhii anaarrawindi-lhangu. ");
INSERT INTO nuy_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Yagu ngaya ngana-magana nugurru, niga na-Elijah bani-yung aḏaba ni-yanggi, yagu wugurru waari ambunu-nguynju-gaa niga. Wugurru wurru-waṉbini runggal-windiyung aladi nigawi-wuy, nguynju-waj wugurru wirri-ngaynbandangi wurru-waṉbini-yinyung. Anubani-yung anggu-nguynju ngaya, na-Niwiyayung na-Wurrujung-jinyung, warruburru-yung warra-wurru-wurruj anaani ngambambi-waṉbina, ngambambi-warragayangijgana wugurru.” Dani-yung ni-yamayn niga. ");
INSERT INTO nuy_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Wugurraayung aḏaba wurru-marrbuy-dhiyn anubani-yung na-Jesus ni-yambini-yinyung anubani-yung na-John-jinyung, nubagi-yung waniimbara-ngambijgaa-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Warraawurru-yung wuu-dhirridangi amubama ama-ṉuga-wala. Marri buguni wurru-yanggi warruburru-wuy warra-garnyirrimba-wuy. Aḏaba waḻyinyung ni-yanggi na-Jesus-guy marri ni-burrdangayn raga-ragij nigawi-rruj. ");
INSERT INTO nuy_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Naagi-yung ni-yamayn, “Buunggawa, banu-maṉmang ngayawi-nyinyung na-nigi. Niga niwu-waṉagana wudhangurrg nigawi-rruj, marri ni-warragayii-windiyung. Niga ni-rabina a-ngura-wuy yagu buguni aa-gugu-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ngaya nganu-yarrijgini niga nugawi-nyinyung-guy wurru-marrbuy-mana-wuy, wugurru ambunu-maji-waa niga, yagu waari.” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Na-Jesus nigaayung ni-yamayn, “Nugurru aadanu warra-wurru-wurruj waari numburru-jambarrgiiyn! Nugurru nurru-yina-baḏa-waḏaḏ! Yuga ngaya anaani nga-ngu-burraa baḏag nugurri-rruj yuga? Anaani ngaya nga-ngu-burraa baḏag nugurri-rruj, nga-lhambaamburrg yamba ngaya marri anambaa-gaṉbina nugurri-wuy anaani, yuga? Banu-yarrijgiyn na-wirrinyung yaanu-wuy.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Na-Jesus ni-yambiyn wu-waḏa-waḏaḏ ana-lhaawu ana-man.gurrg-guy ana-lhirribala na-wirrinyung-duj. Aḏaba wugurru wu-rabaliyn marri na-wirrinyung ni-maji-mayn anubani-yung-gala. ");
INSERT INTO nuy_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Anubanila-wala, warruburru-yung wurru-marrbuy-maa-yinyung wurru-yanggi na-Jesus-guy anubani-yung niga ni-lhalga marri wunu-yandhawiwaa, “Nurru-yaminggarrina, nurru anaani-yung waari naambu-barawudangi ana-man.gurrg?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Nigaayung na-Jesus ni-yamayn, “Yagu yamba nugurru nurru-jambarrgiiyn winyig-bindiyung. Ngaya ngana-magana nugurru yijgubulu-windiyung, nugurru-maynji anubani numburru-jambarrgina winyig-bugij, ari nimbirrima-yamijgang magurru mana-runggal mana-magabang, ‘Ba-dhudhurrgiyn yuuguni,’ magurru ama-dhudhurrgiyn. Anaarrawindi-lhangu anubani-yung anggu-waṉbina nugurri-wuy!” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Anubanila-wala, niga na-Jesus marri nigawi-nyinyung wurru-marrbuy-maa-yinyung wurru-yanggi ana-Galilee. Niga ni-yamayn wugurri-wuy, “Ngaya-waj yaani nga na-Niwiyayung na-Wurrujung-jinyung. Wurrugu, ngambambi-yarrijgina warruburru-yung-guy warra-mulung-aynbaj-guy. ");
INSERT INTO nuy_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Marri warruburru-yung ngambambi-ngawijgang ngaya. Wurrugu amuulawaa-wala mana-miyn.nganga, ngaya anaani nga-ḻaḻagiiyn.” Dani-yung ni-yamaa ana-lhaawu. Wugurraayung wurru-marrbuy-maa-yinyung wurru-wurrij-galadi-wiiyn-bindiyung wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Niga na-Jesus marri nigawi-nyinyung wurru-marrbuy-maa-yinyung wurru-yanggi, wurru-waliyn Capernaum-guy. Anubanila-wala, warra-waḻya-waḻya warruburru-yung wirri-manga-mangi-yinyung anu-ṉuga ana-Temple-Maṉngulg yungguyung ana-tax wurru-yanggi na-Peter-wuy. Wugurru wunu-yandhawiwayn, “Yuga nugawi-nyinyung nini-yiyina-yinyung ni-bayandhii ana-Temple-Maṉngulg yungguyung a-tax?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nigaayung na-Peter “Yii,” ni-yamayn. Na-Peter ni-yanggi buguni a-wumurrng-guy. Bagu na-Jesus ni-yamayn nigawi-wuy, “Simon, yangi numbijangayii? Warruburru warra-runggu-runggal ana-lhal-yinyung wirri-mani anu-ṉuga ana-tax, yagu waa-yangi-nyung-gala wirri-mani yuga? Yagu wugurri-nyinyung warruburru-yung warra-wurru-wurruj, yagu warra-mulung-arrgi-yung-gala?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nigaayung na-Peter ni-yamayn, “Warra-mulung-arrgi-yung-gala,” ni-yamayn. Nigaayung na-Jesus ni-yamayn “Yii, warruburru-yung warra-runggu-runggal-inyung warra-wurru-wurruj, wurru-warrgarrga, waari ambarriiyn ana-tax. ");
INSERT INTO nuy_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Niga na-God ni-yamana nguynju na-king nagawi-nyinyung anaani, na-warrgarrga nagawaa. Yagu nagawaa anaani yagi narra-riyaldhijgi warraawurru wirri-mana-mani-yinyung anu-ṉuga. Yagu ba-yaarri aa-gugu-wuy marri ba-ngaḏugumbina. Wurrugu nagang ba-guḏang ana-wulhu-wulhurr ana-ngujija, ba-lhaguḻa-wawalhigang marri nagang anaani bawu-lhangarrmang wu-ṉuga! Bawu-mang anubani-yung marri bambiiyn warraawurru-yung-guy, nagawi-nyinyung yadhu ana-tax anaani.” Dani-yung ni-yamayn na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Anubani-yung warruburru-yung wurru-marrbuy-maa-yinyung wurru-yanggi na-Jesus-guy marri wunu-yandhawiwayn, “Yangi-nyung warrubawi-yung wu-runggal, warru-mandag-jinyung anaarrwar-yinyung?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nigaayung na-Jesus naa-gaḏiyn wirrinyung nigawi-wuy, nga nu-lhangijgayn wugurri-rruj. ");
INSERT INTO nuy_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Aḏaba niga ni-yamayn. “Ngaya ngana-magana yijgubulu-windiyung nugurru. Waari nurru-burrangi warruburru-rruj warru-mandag-duj anaarrwar-yinyung. Yagu numburru-wiḻibiḻingiyn-maynji marri numburru-yamana nguynju warra-mijburrayung-jii, bani-yung numburru-burraa anaarrwar-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yigaj! Nugurru-maynji numburru-winyig-mana, numburru-nunggarrbidi-mana, nguynju naagi-yung-jii na-wirrinyung-jii, bani-yung nga nugurru numburru-runggal warru-mandag-duj anaarrwar-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nguynju-waj, nugurru-maynji nambarra-walgur-wana warra-wirrig nguynju naagi-yung-jii, ngayawi yungguyung, anaani wiij-nguynju, nguynju ngaayunggaj anaani ngirri-walgur-wana ngaya. ");
INSERT INTO nuy_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Warraawurru-maynji warra-mijburrayung ambu-jambarrgiiyn ngaya, yagu nubagi-yung-maynji naaynbajung-maynji ambani-lhambumana-maynji, ambanii-dhangu-jujurii-maynji, anubani-yung ana-wulhu-wulhurr warraaynbaj ambirrima-ṉuga-radbiyn ṉuga runggal-windiyung, nubagi-yung-guy ambunu-waḻwag-ḏadbiyn marri anubani-yung ambunu-barawudang anubuguni mana-lhagayag-guy! Aadanu anggiij-maṉdhiiyn, yagi yadhu wani-man-jarramijgi warra-mijburrayung ngayawi-wala. ");
INSERT INTO nuy_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Anubani-yung aladi nugurri-wuy ana-lhal-lhangu-wuy, yagu yamba warruburru-yung warra-mulung-arrgi-yung nambii-dhangu-jujurii-yinyung aaladi-wuy. Yagu runggal-windiyung aladi anggu-waṉiyn wugurri-wuy anubani-yung! ");
INSERT INTO nuy_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Nugawi-nyinyung-maynji ana-marang yagu ana-mun anggu-dhaayurrii marri baaṉbina-maynji aladi, bawu-wuḻdhang marri bawu-barawudang! Anubani-yung maaḻamburrg nagang, yagi nunggu-waṉagi nugawi-nyinyung-duj ana-wubulu marri ba-burraa anggu-wuguuguni. Yagi-magi nimbi-barawudi-magi buguni ana-ngura-wuy, bawu-waṉagana-yinyung wulawaa ana-marang marri ana-mun. Anubani-yung ana-ngura anggu-nagina anggu-wuguuguni wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Nugawi-nyinyung-maynji mana-bagaḻang ama-dhaayurrii marri baaṉbina aladi, bama-ngarrgiwang marri bama-barawudang! Anubani-yung wiij-maṉdhina bama-waṉagana aynjaabugij mana-bagaḻang marri ba-burraa anggu-wuguuguni. Yagi-magi nimbi-barawudi-magi buguni a-ngura-wuy wu-nagina, bama-waṉagana-yinyung manuulawaa mana-bagaḻang.” ");
INSERT INTO nuy_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Naagi-yung na-Jesus ni-yambini-wugij. “Nugurru yuga nurru-marrbuy ngaya nga-yambina-yinyung? Numburru-dhi-maṉdhina, yagi wuu-nunggarrbidi-mi warraawurru warra-mijburrayung. Ngaya ngana-magana nugurru, anubani-yung wugurru amburru-waṉagana ana-angel anaarrwar anubani-yung ngayawi-nyinyung-duj na-Baba-rruj. ");
INSERT INTO nuy_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Nugurru yuga nurru-wijangayii? Na-waḻyinyung-maynji ani-waṉagana 100 ana-jib yagu aynjaabugij anggaaṉibiyn-maynji, nigaayung anaani aniirruyn ana-mulung-arrgi-yung 99 ama-magabang-duj a-maḏa-rruj marri ani-yaarri aniigalhaga-lharrmani waaṉibiyn-jinyung wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ngaya ngana-magana yijgubulu-windiyung, niga ani-ḏinggina-windiyung, anubani-yung-jinyung aynjaabugij ana-jib, waari nguynju anubani-yung ana-99 anubani-yung waari-yinyung anggaaṉibiyn-jinyung. ");
INSERT INTO nuy_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Aadanu wiij-nguynju, nugurri-nyinyung na-Ninyarra anaarrwar waari ani-wij-ngaynbandang nigawi-nyinyung warra-mijburrayung wurraaṉibi.” ");
INSERT INTO nuy_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Naagi-yung na-Jesus ni-yambini-wugij niga. “Nugawi-nyinyung-maynji na-guwaj ani-waṉbina anaaladi nugawi-wuy, ba-yaarri marri banu-magana niga nimbini-wandhalga anubani-yung-jinyung. Niga-maynji anii-gawanggina nagang, nagang banu-maṉmani. ");
INSERT INTO nuy_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Yagu niga-maynji ani-lhaabang, yagi ni-wawanggi, bamba-muṉḏugijgana naaynjaabu-nyung yagu ambini-wulawaa, numburraanggarra-yaarri nigawi-wuy ngijang. Anubani-yung ani-wawanggina, ani-jambarrgina warruulawaa yagu warruulaynbaj-gala. ");
INSERT INTO nuy_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Yagu niga-maynji ani-lhaabina-wugij, anubani-yung yagi ni-wawanggi wugurri-wuy, bamba-magana wurru-jambarrgina-yinyung-guy. Niga-maynji ani-lhaabina-wugij, nagang banu-waṉbina niga nguynju yaga warrubawi-yung waari-yinyung ambu-jambarrgiiyn na-God-guy yagu nguynju yaga warruburru-yung-jii warraalaaladi-yii.” ");
INSERT INTO nuy_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Naagi-yung na-Jesus ni-yambini-wugij niga. “Ngaya ngana-magana nugurru yijgubulu, nugurru nambarra-magana warra-wurru-wurruj-guy anaani-rruj ana-lhal, anubani-yung-jinyung amburru-waṉbina-yinyung marri waari-yinyung wurru-waṉbi-yinyung. Marri niga na-God ani-wijangayii nguynju-waj anubani-rruj anaarrwar. ");
INSERT INTO nuy_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nguynju-waj, ngaya ngana-magana nugurru, anubani-yung na-wulawaa-maynji nuguṉi ana-lhal-rruj nimbiniindharrmang anubani-yung anaarrawindi-lhangu marri nimbini-yambina na-God-guy, anubani-yung ani-waṉbina nuguṉi yadhu, na-Baba anaarrwar. ");
INSERT INTO nuy_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nugurru numburru-muṉḏugana-maynji, anubani-yung warra-wulawaa yagu warra-wulaynbaj ngayawi yadhu, ngaya anaani bagu nugurri-rruj.” Dani-yung ni-yamayn na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Anubanila-wala, nigaayung na-Peter ni-yanggi na-Jesus-guy marri nu-yandhawiwayn, “Buunggawa, anggu-mal-ngargu ngayawi-nyinyung na-guwaj anaaladi ani-waṉbina ngayawi-wuy, marri ngaya nganaagajij-garruyn niga? Ari marang-aynjaabugij marri angguulawaa anubani-yung?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nigaayung na-Jesus nu-yambalmayn, “Ngaya ngunu-magana nagang, nagang banaagajij-garruyn niga yagu waari-wugij ana-marang-aynjaabugij marri anuulawaa anubani-yung. Nagang banaagajij-garruyn-bugij niga, malgarrawindi, yagi nu-muḏaḏbi, ari 500 anubani-yung! ");
INSERT INTO nuy_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Na-God-jinyung warru-mandag anaarrwar-yinyung, nguynju aani-yung-jii. Naaynjaabu-nyung na-king niwu-mani anu-ṉuga nigawi-nyinyung-gala wurru-mijgalmina-yinyung, ambunaa-gajijgiyn niga. ");
INSERT INTO nuy_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ana-raga-ragij, nubagi-yung naa-mijgalmini-yinyung nubagi-yung anuuyn-jinyung niga anubani-yung runggal-windiyung anu-ṉuga. Wugurru wunu-yarrijgini nigawi-wuy na-king-guy. ");
INSERT INTO nuy_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Yagu niga nubagi-yung naa-mijgalmini-yinyung waari aniwu-waṉagaa anu-ṉuga. Nigaayung na-runggal-yung ni-yambini, nubagi-yung-jinyung anaarrawindi-lhangu warriini, nguynju-waj nigawi-nyinyung ngarra-rangarrina-yung marri warra-mijburrayung, anubani-yung-jinyung anu-ṉuga. ");
INSERT INTO nuy_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Yagu nigaayung ni-rabini nigawi-nyinyung-mirri ḻan raga-ragij niga na-king, marri ni-yamayn ‘Wurrugu nimba-rangarrii, anaarrawindi-lhangu ngaya wiiyn,’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nigaayung nubagi-yung na-runggal-yung nu-warrngayuyn, naagajij-garruyn niga, nu-lharrgang. Niga ni-yanggi, ni-warrgarrga. ");
INSERT INTO nuy_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Yagu nigaayung naa-mijgalmini-yinyung ni-yanggi, nu-lhangarrmayn aynbajung ni-mijgalmini-yinyung, nubagi-yung anuuyn-jinyung niga waadharra anu-ṉuga. Niga nu-bilhargayn niga nu-waḻa-baṉagayn marri ni-yamayn ‘Numba-bayarra-gang ngaya anu-ṉuga nagang ngayawi-wuy!’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Yagu nigaayung ni-rabini ni-ḻandharrdhangayn marri ni-yamayn, ‘Wurrugu nimba-rangarrii, anaarrawindi-lhangu ngaya wiiyn,’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Yagu na-wulhu-wulhurr-yung ni-lhaabiyn niga. Nu-barawudiyn naaynbajung buguni wuu-dhi-dhidina-wuy, nguynju yadhu niga anuuni anaarrawindi-lhangu. ");
INSERT INTO nuy_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Yagu warruburru-yung warra-mulung-aynbaj wurru-mijgalmini-yinyung wunu-nani niga ni-waṉbini-yinyung, wugurru wurru-wurrij-galadi-wiiyn-bindiyung. Wugurru wurru-yanggi na-runggal-yung-guy, marri wunu-magaa anaarrawindi-lhangu anubani-yung wu-waṉbini-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nigaayung aḏaba na-runggal-yung naa-gaḏiyn nubagi-yung na-wulhu-wulhurr-yung naa-mijgalmini-yinyung marri ni-yamayn, ‘Nagang nundaaladi nu-mijgalmina-yinyung! Nagang numba-yandhawiwandi ngaya, marri ngunaagajij-garruyn nagang nimbiiyn-jinyung. ");
INSERT INTO nuy_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Yagu nagang banu-warrngayungaa-magaa nubagi-yung-guy naaynbajung-guy, nguynju-waj ngaya ngunu-warrngayungaa nagang.’ Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Marri naagi-yung na-runggal-yung ni-riyaldhiyn marri nu-burriyn na-wurrujung wubani-wuy wuu-dhi-dhidina-wuy, marri wunu-warragayangijgaa, nguynju yadhu niga anu-bayarra-gaa anaarrawindi-lhangu niga anuuni-yinyung wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Dani-yung nga, ngayawi-nyinyung anaarrwar na-Baba anaani nambani-waṉbina nugurri-wuy, nugurru-maynji yagi narraagajij-garru nugurri-nyinyung warra-mi-nilharri yagu warra-mi-ngarrilharri, nugurri-wala aandhiri-wala.” Dani-yung ni-yambini na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Anubanila-wala, niga na-Jesus ni-yambini-wala anubani anaarrawindi-lhangu, niga niwaarruyn ana-Galilee marri ni-yanggi buguni wubani-wuy a-Judea-wuy, yuuguni ramaliyaj a-Jordan aala. ");
INSERT INTO nuy_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mandag-dhabarrj warra-wurru-wurruj wunu-garrindharrmangi niga, marri niga wani-maji-waa wugurru bagu. ");
INSERT INTO nuy_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mulung-arrgi-yung warra-Pharisee wurru-yanggi na-Jesus-guy, ambunu-dhaayurrangi nigawi-wuy. Wugurru wunu-yandhawiwayn, “Yuga wiij-maṉdhina, na-waḻyinyung-jinyung angaarruyn nigawi-nyinyung ngarra-rangarrina-yung anaarrbidi yuga?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nigaayung na-Jesus ni-yamayn, “Waari! Yijgubulu nugurru nirri-nani ana-wubiba, anubani-yung na-God niwu-maṉdhangi anaani ana-lhal, (Genesis 1:27) ‘Niga wani-maṉdhangi na-wurruj-baa, waḻyinyung marri maṉinyung.’ ");
INSERT INTO nuy_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","“Marri na-God ni-yamayn, (Genesis 2:24) ‘Wudani-yung-gala, warra-waḻya-waḻya warraarruna warra-mininyarra-yung marri warra-mijbiibi-yung. Marri niga marri nigawi-nyinyung nga-rangarrina-yung, winiiynjaabu wini-yagaynjina, nguynju aynjaabugij ngun.gu.’ ");
INSERT INTO nuy_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Dani-yung ni-yamayn na-God. Yagu waari ambini-wulawaa-magaa, yagu aḏaba aynjaabu-nyung, na-God wani-waliyn na-wulawaa winiiynjaabu, yagu yagi warra-rajaarrijgi wugurru.” Dani-yung ni-yamayn na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wugurraayung warra-Pharisee wurru-yamayn, “Yagu a-yangi-yungguyung, na-Moses wani-yayn anubani-yung ana-lhaawu na-waḻyinyung-jinyung angaarruyn nigawi-nyinyung ngarra-rangarrina-yung, anguuyn ngiga ambiniirruynjang-jinyung ana-wubiba?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nigaayung na-Jesus ni-yamayn, “Nugurru yamba nurru-wan-baḏa-waḏaḏ! Na-Moses nani-magaa nugurru nambarraarruyn-jinyung nugurri-nyinyung warra-miḏangarrinaaj. Yagu waari anggu-waṉbini ana-wulhu-wulhurr. ");
INSERT INTO nuy_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yagu ngaya anaani ngana-magana nugurru, nugawi-nyinyung nga-rangarrinaaj, angiiynji-yara warraaynbaj-guy, wiiya, bangaarruyn ngiga. Yagu waari-maynji ngiiynji-yingi warraaynbaj-guy, marri bangaarruyn-maynji marri baaynji-yara ngarraaynbajung-guy, ba-waṉbina aladi-windiyung.” Dani-yung ni-yamayn na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wugurraayung warruburru-yung wurru-marrbuy-maa-yinyung wurru-yamayn nigawi-wuy, “Yuga nimba-magana, na-waḻyinyung yagi ngaarru nigawi-nyinyung ngarra-rangarrina-yung? Anubani-yung wij-maṉdhina yagi wurraaynji-yingi!” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nigaayung na-Jesus ni-yamayn, “Anaani yijgubulu, yagu anaani ana-lhaawu waari warraarrawindi-wuy. Na-God wani-yanguyii warra-mulung-arrgi-wuy, burru-yung-bugij anubani-yung. ");
INSERT INTO nuy_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Anaani wiijamana, mulung-arrgi-yung warra-waḻya-waḻya waari amburraaynji-yingang, wurraambuḻwina, waari wurru-waṉbi ana-nguniyn. Warra-mulung-aynbaj warra-waḻya-waḻya waari amburraaynji-yingang yagu yamba warra-mulung-aynbaj warra-balhu wugurri-wuy. Warra-mulung-aynbaj warra-waḻya-waḻya waari amburraarraaynji-yingang, wugurru yamba wurru-mijgalmina warru-mandag-jinyung anaarrwar-yinyung. Yagu warra-wurru-wurruj na-God wani-yanguyii-yinyung anaani ana-lhaawu, burru-yung amburru-waṉbina anubani-yung.” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Anubanila-wala, warraawurru-yung mijburrayung warra-yarrijgini nigawi-wuy, naagi-yung ambiniimbara-waṉagaa warruburru-yung marri ambanii-jambini wugurru. Yagu warraawurru-yung wurru-marrbuy-maa-yinyung warra-lhambini, “Yagi!” wurru-yamayn wugurri-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yagu nigaayung na-Jesus ni-yamayn, “Nambarra-lharrgang waadurru warra-mijburrayung ngayawi-wuy amburru-yaarri, yagi narra-lhambu. Yagu yamba anubani na-God-jinyung anaanga anaarrwar, anubani wugurri-nyinyung, marri warruburru waadurru-yung-jii.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Naagi-yung waniimbara-waṉagaa, warraawurru-yung warra-mijburrayung. Aḏaba niga ni-yanggi, niwaarruyn anubani-yung ana-lhal. ");
INSERT INTO nuy_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Waḻyinyung ni-yanggi na-Jesus-guy marri nu-yandhawiwayn, “Numba-yiyina-yinyung, yangi ana-mamanunggu-yinyung ngaya nganggaṉbina, nguynju yungguyung nga-ngu-burraa anggu-wuguuguni ana-wiri?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nigaayung na-Jesus ni-yamayn, “A-yangi yungguyung nagang numba-yandhwiwana ngaya anubani-yung-jinyung ana-mamanunggu-yinyung? Nigaaj-bugij na-God ni-mamanunggu. Yagu nagang-maynji bawu-ngaynbandii bawu-waṉagana ana-wiri anggu-wuguuguni, bawu-yandhurrbangana ana-lhaawu-runggal.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nigaayung na-waḻyinyung nu-yandhawiwayn, “A-yangi-yinyung ana-lhaawu-runggal?” ni-yamayn. Nigaayung na-Jesus nu-yambalmayn, “Nagang yagi barra-mulunguwawi, yagi barraa-gamajangi warra-maṉung, yagi barraa-gamajangi, yagi nunggawaḻi, ");
INSERT INTO nuy_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","nubiṉi-yung bamba-yandhurrbangana nga-rriibi marri na-ninyarra, marri warrubawi-yung barra-ngaynbandii warra-mulung-aynbaj, nguynju yaga wudanu nugaajbaj-mirri nu-ngaynbandiina.” Dani-yung ni-yamayn na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nigaayung na-waḻyinyung ni-yamayn, “Ngaya ngawu-yandhurrbangana anaarrawindi-lhangu. Yangi ngijang nganggaṉbina?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nigaayung na-Jesus nu-yambalmayn, “Nagang-maynji bawu-ngaynbandang ba-maaḻamburrg, aḏaba ba-yaarri bambarriiyii nugawi-nyinyung anaarrawindi-lhangu marri bambiiyii anu-ṉuga warraambalalari-wuy, marri nagang bawu-waṉagana runggal-windiyung anaarrwar. Aḏaba nagang baaṉiyn, numba-garrindharrmani ngaya.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Naadagi-yung na-waḻyinyung ni-wawanggiyn niga aḏaba anaani. Niga ni-yimurr-jiwuriyn, ni-yanggi aḏaba, anaani-yung yamba ni-warra-waṉagaa arrawindi, niimbalal-windiyung naagi-yung na-waḻyinyung. ");
INSERT INTO nuy_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nga nigaayung na-Jesus wani-magaa nigawi-nyinyung wurru-marrbuy-maa-yinyung, “Ngaya ngana-magana yijgubulu-windiyung, aadanu wugurru wiij-baḏa-waḏaḏ, warrubawi-yung warraambalal, yagi anubani wu-rumi na-God-guy anaanga anaarrwar. ");
INSERT INTO nuy_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Yii, ngaya ngana-magana ngijang, ari anubani ana-gamul anggu-yaarri marri anggu-yabiyn ngarrubagi-yung-guy ngarra-jaarru-wuy ngarra-ngarri-ngu-bagaḻang, ngi-ba-ngu-gara-wawalhii-wuy. Aadanu ari wiij-maṉdhina! Yagu anaani wu-miḏaamimi-windiyung, warrubawi-yung warraambalal amburru-yaarri-yinyung anubani-yung na-God-guy anaanga-wuy.” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wugurraayung wurru-marrbuy-maa-yinyung wurraawanggiyn anaani, wugurru wurru-wurri-ḻaḻmayn marri wunu-yandhawiwayn, “Yuga yangi-nyung naadagi na-God ambani-wiri-gana-yinyung wugurru?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Nigaayung na-Jesus ni-warranggayn wugurri-wuy marri ni-yamayn, “Wugurru warra-wurru-wurruj waari wurru-wiri-gi wugurraajbaj. Yagu na-God ani-waṉbina anaarrawindi-lhangu,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nigaayung na-Peter ni-yamayn na-Jesus-guy, “Yigaj, nurru anaani nurraarra-garraarruyn anaarrawindi-lhangu, marri anaani ngunu-garrindharrmangi nagang. Yagu anubani-yung yangi nurru naambu-waṉagana?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Nigaayung na-Jesus ni-yamayn wugurri-wuy, “Ngaya ngana-magana nugurru yijgubulu-windiyung, anubani-yung-maynji ngaya na-Niwiyayung na-Wurrujung-jinyung, ngaya nga-ngu-burraa anaarrwar ngayawi-nyinyung-duj ana-runggal ana-throne, nugurru ngirri-garrindharrmani-yinyung ngaya nguynju-waj numburru-burraa a-12-duj a-throne, nambarra-nguynju-nguynjijgana warra-12 warru-mandag warra-Israel. ");
INSERT INTO nuy_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Marri nugurru-maynji anaanga nimbirriirruyn, marri warra-minilharri, warra-miyn-ngarrilharri, warra-mi-ninyarra-yung, warra-mijbiibi-yung, warra-mijburrayung, ana-lhal, marri ngirri-garrindharrmani ngaya, nugurru nimbirri-lhangarrmang anaarrawindi-lhangu. Marri wurrugu marri malgadhaadharri, numburru-burraa numburraandha-wuguuguni. ");
INSERT INTO nuy_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Yagu warraarrawindi warra-wurru-wurruj ana-raga-ragij, amburru-lhamarrii adhaadharri. Warruburru warraarraarrawindi anaadhaadharri-yinyung, wugurraayung burru-yung amburru-ragaana.” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Naagi-yung na-Jesus ni-yambini-wugij. “Anaani anaarwar-yinyung wu-yamana aani-yung-jii. Waḻyinyung niwu-waṉagaa ana-lhal anubani-yung waanuynjungini-yinyung. Ana-ngamugijgaj ni-yanggi, wani-lhangarrmayn mulung-arrgi-yung waḻya-waḻya amburru-mijgalmini yadhu wubani waanuynjungini-rruj. ");
INSERT INTO nuy_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Naagi-yung wani-magaa, ambaniini-yinyung a-silver a-wuṉuga wugurru wurru-mijgalmini-yinyung ngarrubagi-rruj ngarraaḻirr. Nga niga wani-lharrgang buguni waanuynjungini-yinyung, wunaa-mijgalmini-yinyung wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Anubanila-wala, 9 o'clock naagi-yung na-waḻyinyung ni-yanggi a-wumurrng-guy marri wani-nani mulung-arrgi-yung waḻya-waḻya wurru-lhaay bagu, waari amburru-waṉbini-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Yagu niga ni-yamayn ‘Numburru-mijgalmina ngayawi-rruj waanuynjungina-rruj, marri nganamba-bayarra-gang,’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nga wugurraayung wurru-yanggi. Anubanila-wala 12 o'clock, marri ngijang 3 o'clock, naagi-yung ni-waṉbini, wu-nguynju anubani-yung. ");
INSERT INTO nuy_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Anubanila-wala, waadharrwara-mayn 5 o'clock, naagi na-waḻyinyung ni-yanggi a-wumurrng-guy ngijang marri wani-nayn wurraarragarra-lhi bagu. Niga wani-magaa, ‘A-yangi yungguyung nurru-lhara adaju baḏag, numburru-waṉbang-jinyung waari?’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Wugurraayung wurru-yamayn, ‘Waari warraaynbaj nambambi-magaa nurru, naambu-mijgalmina-yinyung,’ wurru-yamayn. Nigaayung ni-yamayn ‘Nugurru numburru-yaarri, numburru-mijgalmina ngayawi-nyinyung-guy waanuynjungina-wuy,’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Anubani-yung ngi-yabini ngarraaḻirr, naabalijung ni-yambini nubagi-wuy wani-rangarrangi-yinyung warruburru-yung wurru-mijgalmini-yinyung, ‘Bambaa-gaḏang warruburru-yung marri bamba-bayarra-gang wugurru. Warruburru-yung anaadhaadharri-yinyung bamba-bayarra-gang raga-ragij,’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Wugurraayung wurru-mijgalmini-yinyung warruburru-yung wani-mangi-yinyung 5 o'clock wurru-yanggi, warraaynjaaynjaabugij wirri-mangi aynjaabugij anu-ṉuga. ");
INSERT INTO nuy_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Anubanila, wurru-mijgalmini-yinyung warruburru-yung wani-mangi-yinyung ana-wulhu-wulhurr wurru-yanggi ambirri-mangi anu-ṉuga. Wugurru wurru-wijangani ambirri-mangi arrawindi anu-ṉuga. Yagu warraaynjaaynjaabugij-gaj wugurru nguynju-waj wirri-mangi aynjaabugij anu-ṉuga. ");
INSERT INTO nuy_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Warraawurru-yung wugurru wurru-nguḻu-nguḻu-yambini, naabalijung-jinyung. ");
INSERT INTO nuy_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Wugurru wunu-magaa, ‘Warruburru-yung wurru-mijgalmini-yinyung anaadhaadharri, wugurru wurru-mijgalmini aynjaabugij ngi-dhawawarumini-yinyung yagu nagang barriini wugurru wu-nguynju nurri-yii, yagu nurru nurru-mijgalmini anaangaḏajung ngarraaḻirr-lhangu ngi-nagini-yinyung ngarraaḻirr.’ Dani-yung wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Nigaayung aḏaba naabalijung ni-yamayn naaynjaabu-nyung-guy, ‘Guwaj, ngaya waari nimba-dhaayurrangi. Nagang nundaaṉḏarrmayn, nu-mijgalmini-yinyung aynjaabugij wuṉuga yadhu. ");
INSERT INTO nuy_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yagu bawu-mang nugawi-nyinyung anu-ṉuga marri ba-yaarri aḏaba. Ngaya ngawu-ngaynbandiyn nganuuyn nubagi-yung nganu-miyn-jinyung anaadhaadharri wu-nguynju anu-ṉuga. ");
INSERT INTO nuy_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Anaani ngayawi-nyinyung anu-ṉuga. Ngaya nganggaṉbina aynba-gaynbaj-jinyung. Ari nagang numba-margiriyn yagu yamba ngaya anaani nganu-walgaṉmana?’ Dani-yung ni-yambini na-waḻyinyung niga.” ");
INSERT INTO nuy_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Naagi-yung na-Jesus ni-yambini-wugij, warruburru-wuy wurru-marrbuy-maa-wuy. “Nugurru yuga nurru-marrbuy? Yagu warraarrawindi warra-wurru-wurruj ana-raga-ragij, amburru-lhamarrii adhaadharri. Warruburru warraarraarrawindi anaadhaadharri-yinyung, wugurraayung burru-yung amburru-ragaana.” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Anubanila-wala, niga na-Jesus ni-yanggi niidadangi Jerusalem-guy, niga wani-yarrijgini nigawi-nyinyung warra-12 wurru-marrbuy-maa-yinyung. Marri ni-yamayn wugurri-wuy, ");
INSERT INTO nuy_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Numburraarranggang, aḏaba anaani ngurru-yaarri Jerusalem-guy. Anubagu warruburru warra-priest, marri warruburru warra-yiyina-yinyung ana-lhaawu-runggal, ngambambi-bilhargana ngaya anaani na-Niwiyayung na-Wurrujung-jinyung. Marri burru-yung amburru-wijangayii, nga-ngawiiyn-jinyung. ");
INSERT INTO nuy_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Marri warruburru-yung warra-runggu-runggal warra-priest ambarriiyn warra-mulung-aynbaj-guy, waari-yinyung amburru-Jew-magaa. Warraawurru-yung ngambambi-gaḻij-gana marri ngambambi-rajburrnayii, marri ngambambi-warra-waḏjiwumana marri ngambambi-marang-barra-rayii wuḏangag-guy. Wurrugu amuulawaa-wala mana-miyn.nganga, ngaya anaani nga-ḻaḻagiiyn.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Anubanila-wala aḏaba ngarra-rangarrina-yung na-Zebedee-yinyung ngi-yanggi na-Jesus-guy, ngigawi-nyinyung-mirri na-nimarayung-biiyung. Ngiga ngi-burrdangayn raga-ragij nigawi-rruj marri ngunu-yandhawiwayn niga ani-waṉbini ngigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Na-Jesus ni-yamayn, “A-yangi nagang nu-ngaynbandiyn?” ni-yamayn. Ngigaayung ngi-yamayn, “Ngayawi-nyinyung na-marig-baa, ba-wijangayii, anubani-yung aynjaabu-nyung ani-burraa nugawi-rruj a-walawalama-rruj marri naaynbajung ani-burraa a-mangaṉḏayayaagu-wala nugawi-nyinyung-duj a-lhal, ba-buunggawa-mana-maynji.” Dani-yung ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yagu nigaayung na-Jesus wani-magaa nubiṉi-yung-guy na-nimarayung-biiyung-guy. Ni-yamayn “Nuguṉi waari nimbini-marrbuy-magaa anubani-yung nuguṉi niini-yambina-yinyung. Anaani ngaya nganggarragayii runggal, marri nga-ngawang. Anubani-yung anggiijamana, nguynju yaga ngaya nganggaḻ-nguyii manubama-yung mana-gaṉdharra-wala. Yuga manubama-yung ngijang nuguṉi nimbini-waḻ-nguyii, yuga?” ni-yamayn. Wuguṉiiyung wini-yamayn, “Yii, aadanu naani-waṉbina ngijang,” wini-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Na-Jesus nigaayung ni-yamayn, “Mana-gaṉdharra manubama-yung nganggaḻ-nguyii-wala, nuguṉiiyung ari nimbini-waḻ-nguyii. Yagu yagi anubani-yung nga-yambi, ‘Yuu, anubani nimbini-burraa walawalama marri mangaṉḏayayaagu’, yagi anubani-yung nga-yambi. Anubani-yung na-Baba ni-wijangani, yangi-nyung warrubawi-yung ambu-burraa anubagu ana-walawalama-rruj marri anubani ana-mangaṉḏayayaagu-rruj.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wugurraayung warruburru-yung warra-10 wurraawanggini, marri anubani-yung warraa-ḏiyaldhiyn naawiṉi-yung wini-dharrmaynjiyn-jinyung. ");
INSERT INTO nuy_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nigaayung na-Jesus wanii-gaḏiyn nigawi-wuy marri ni-yambini, “Nugurru nurru-marrbuy, warruburru-yung wurru-buunggawa-mana-yinyung ana-lhal-lhangu-yinyung, warruburru-yung wurru-yamana, ‘Ngaya anaani nga-buunggawa.’ Marri warruburru waa-runggu-runggal, warra-yamijgayn, ‘Nugurru aadanu ngirri-yandhurrbangana,’ wurru-yamana. ");
INSERT INTO nuy_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Yagu nugurru yagi anubani-yung nuu-yami warruburru-yung-jii. Nugurru-maynji numburru-runggal-mang, nugurru nambarra-maṉmani warra-mulung-aynbaj-guy. ");
INSERT INTO nuy_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Marri nimbirri-ngaynbandang-maynji anuwaagu ana-raga-ragij, warra-mulung-aynbaj-guy nambarraa-mijgalmina. ");
INSERT INTO nuy_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ngaya yamba anaani, na-Niwiyayung na-Wurrujung-jinyung, nga-yanggi anaanuwuy, waari ngambi-maṉmi-yinyung warra-mulung-aynbaj warruburru-yung. Nga-yanggi anaani, warra-mulung-aynbaj yungguyung ngamba-maṉmani, nguynju yungguyung anubani-yung ngaynjiynjang ngayawi-nyinyung ana-wiri, ngamba-bayarra-gana warruburru-yung warraarraarrawindi.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Anubanila-wala, na-Jesus marri nigawi-nyinyung wurru-marrbuy-maa-yinyung wurru-yanggi Jericho-wuy. Anubanila, wirriirruyn anubani ana-lhal, arraarrawindi-yinyung wurru-wurruj wunu-garrindharrmangi niga. ");
INSERT INTO nuy_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Wini-wulawaa bagaḻang-aladi-waa waḻya-waa wini-burri amaadi-rruj. Naawiṉi-yung wini-wawanggiyn na-Jesus ni-yaḻdhangi bagala-yung yagu wuguṉi winiiḏangi, “Buunggawa na-niwiyayung na-David-jinyung, numba-maṉmang niiṉi!” wini-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Yagu warraawurru-yung arraarrawindi wunu-yambini, “Nimbini-muḏaḏbang!” Yagu wuguṉiiyung naawiṉi-yung winiiḏangi-wugij yanggarrwar, “Buunggawa na-niwiyayung na-David-jinyung, numba-maṉmang niiṉi!” wini-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Bani-yung marri na-Jesus ni-lhangayn. Marri ni-yamayn nubiṉi-wuy “Yangi yuga ngaya anubani nimba-ngaynbandiyn marri anambaa-gaṉbang nuguṉi?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wuguṉiiyung wini-yamayn “Buunggawa, niiṉi niiniwu-ngaynbandiyn naani-warranggang,” wini-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nigaayung na-Jesus wani-warrngayuyn, marri wani-ba-baṉagayn wuguṉi-nyinyung mana-bagaḻang marri lhugaajgiyalawaj wuguṉi wini-warranggayn marri aḏaba wuguṉi wurraanggarra-yanggi na-Jesus-guy. ");
INSERT INTO nuy_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Warruburru-yung wurraanggarra-yanggi buguni Jerusalem-guy. Wurru-yanggi buguni Bethphage-wuy, buguni ma-ḻandhirrngindi-rruj ma-mayini Mount of Olives, wubani wu-ridiynjini a-Jerusalem. Anubanila-wala, na-Jesus wani-lharrgang wini-wulawaa nigawi-nyinyung wini-marrbuy-maa-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Wani-yamijgayn, “Nimbini-yaarri wubani-wuy a-wumurrng-guy, nimbini-lhangarrmang bagu wulawaa dunggu-dunggi, wu-lhamunu-radbidhaa, wu-biibi-yung marri wirrig. Marri anubani-yung nimbini-lhamunu-lharrina wugurru, marri nimbini-lhamunu-warrgina anubagala ngayawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Warrubawi-yung-maynji nambambi-yandhawiwana nuguṉi, nimbini-yamang ‘Anaani na-Buunggawa niga ni-ngaynbandii wugurru, marri niga anaani ani-lharrgang mal-dhamun.gurrg,’ nimbini-yamang.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Anaani wu-waṉbini, yagu yamba nubagi naa-ja-jambini-yinyung na-God, ni-warrarrangi anu…bani-yunggaj, ");
INSERT INTO nuy_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Nagang bamba-magana warra-wurru-wurruj ana-Jerusalem-jinyung, yigaj, nugurri-nyinyung na-King ni-waṉina nugurri-wuy, Niga ni-lhamaamura marri ninggu-warrguu ana-dunggi, ana-wirrig wugurru ana-dunggi.” Dani-yung waarrarrina a-wubiba-rruj. ");
INSERT INTO nuy_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nubiṉi-yung wini-marrbuy-maa-yinyung wini-yanggi marri wini-waṉbini anubani-yung na-Jesus wani-magaa-yinyung wuguṉi. ");
INSERT INTO nuy_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wuguṉi wini-yarrijgini ana-dunggi marri ana-wirrig na-Jesus-guy. Anubanila, manubama-yung wirrima-ngarrgiwaa yaaḻi nga wuu-rulbu-wabaa. Nga ni-burri bagu arrwar. ");
INSERT INTO nuy_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Arraarrawindi-yinyung warra-wurru-wurruj wirrima-murrgulhangi wugurri-nyinyung mana-yaaḻi amaadi-waj. Warra-mulung-arrgi-yung wirri-wulguldhangi manjarr wubanila-wala a-rangag-gala marri wirri-murrgulhangi wugurru amaadi-waj. ");
INSERT INTO nuy_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Marri warra-wurruj-wurruj wurru-yanggi raga-ragij na-Jesus-duj marri adhaadharri nigawi-rruj wurraaḏangi, “Hosanna! Ngaanu-warraarriwana niga na-niwiyayung na-David-jinyung! Naadagilu ni-yaarri, nigawi yungguyung na-Buunggawa na-God. Naadagilu na-God naagajij-majgana niga. Ngaanu-warraarriwana na-God anaarrwar-yinyung!” Dani-yung wurru-yamaa wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Aḏaba na-Jesus ni-yanggi Jerusalem-guy. Warraarrawindi-lhangu warra-wurru-wurruj wurru-wurrij-gaḻaaḻarrangi marri warra-yandhawiwaa, “Yangi-nyung naagi na-waḻyinyung?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Warru-mandag warra-yambalmayn, “Naagi na-waḻyinyung Jesus nubagi yaga naa-ja-jambina-yinyung na-God, anubanila-wala anaanga-wala ana-Nazareth anubani ana-Galilee-rruj,” wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Anubanila-wala, niga na-Jesus ni-yanggi buguni a-Temple-Maṉngulg-guy. Anubagu, wurraarra-yabijgaa arra, wuu-yiynjini marri wurru-bayandhangi wugurru. Naagi-yung wani-nani, ni-riyaldhiyn. Anubani-yung wani-man-jarramijgayn anubagala ana-Temple-Maṉngulg-gala. Anubani-yung warra-mulung-arrgi-yung wubani-yung wuṉuga-yinyung a-Temple-Maṉngulg-jinyung wu-bu-burri anubani-yung wurru-yiynjini, warra-mulung-arrgi-yung wurru-yiynjini anubagu lhabarrg. Anubani-yung na-Jesus ana-baadhi anubani niwu-miyn niwu-barawudiyn, marri anubani wurru-biḻajgudhii-yinyung. Warruburru-yung wani-man-jarramijgayn. ");
INSERT INTO nuy_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Naagi-yung wani-magaa, “Ana-wubiba na-God-jinyung wu-yamana, na-God ni-yamayn, ‘Ngayawi-nyinyung ana-wumurrng, nimbirri-mayana ana-wumurrng anaani ngambambi-yambina-yinyung,’ Dani-yung ana-wubiba wu-yamana. Yagu nugurru nirriiynbijgayn anaani ana-wumurrng, (Jeremiah 7:11) ‘nguynju yaga warrubawa-yung wurraamajaa marri wu-julubina,’ nurru-yamana.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Anubanila-wala, warruburru-yung waari-yinyung amburru-warranggaa-yinyung marri warraarra-guṉḏa-guṉḏa-yinyung wurru-yanggi na-Jesus-guy a-Temple-Maṉngulg-guy marri niga wani-maji-waa wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Yagu wugurraayung warruburru-yung warra-runggu-runggal warra-priest marri warra-yiyini-yinyung ana-lhaawu-runggal, wugurru wunu-nani na-Jesus anubani-yung ni-waṉbini-yinyung ana-mamanunggu-yinyung. Marri anubani-yung warra-nani warra-mijburrayung ana-Temple-Maṉngulg-duj wurru-yamaa, “Waarraarriwana! Na-niwiyayung na-David-jinyung!” wurru-yamaa. Wugurraayung warra-runggu-runggal wugurru wurru-riyaldhiyn. ");
INSERT INTO nuy_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Wugurru wunu-yandhawiwayn na-Jesus, “Yagu nagang nunggaawanggini warraawurru-yung-jinyung warra-mijburrayung wurru-yambini-yinyung?” wurru-yamaa. Nigaayung na-Jesus wani-magaa, “Yii, yagu nugurru nirri-nani ana-lhaawu waarrarrini-yinyung ana-wubiba-rruj, God, ambi-warraarriwana warra-mijburrayung marri warra-gujuju.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Anubanila-wala aḏaba na-Jesus marri nigawi-nyinyung wurru-marrbuy-maa-yinyung, wugurru wurru-rabaliyn anubanila ana-wumurrng-gala, nga wurru-yanggi wubani-wuy Bethany. Bagu wugurru wurru-burri ana-miyn.ngu. ");
INSERT INTO nuy_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Anubanila-wala ngama-ngamugijgaj, warruburru-yung wurru-yanggi wurraagiyn a-wumurrng-guy. Niga na-Jesus ni-marryaadiyn. ");
INSERT INTO nuy_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Niga nima-nani mana-maaṉbaaṉburru amaadi-waj. Niga ni-yanggi buguni yagu anubagu waari anu-ngugulmung anubagu, anubani-yung manjarr-wugij magurru. Yagu na-Jesus ni-yamayn manubami-wuy, “Nagang ngijang waari nunggu-waṉagi anu-ngugulmung!” nima-yamijgayn. Manaami lhugaajgiyalawaj ma-ḏaḏarrg-mayn aḏaba. ");
INSERT INTO nuy_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Wugurraayung nigawi-nyinyung wurru-marrbuy-maa-yinyung wirrima-nani. Wugurru wurru-wurri-ḻaḻmayn. “Ma-yaminggarrina manaama mana-maaṉbaaṉburru, ma-ḏaḏarrg-mayn ana-ngalbaḻang?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nigaayung na-Jesus ni-yamayn, “Ngaya ngana-magana nugurru yijgubulu-windiyung, nugurru-maynji numbunaa-ngu-jambarrgina na-God, marri yagi nurru-wij-gububuluwi, nugurru numburru-waṉbina anaani anubani-yung ngaya nga-waṉbini anaani-wuy ana-rangag, marri ngijang nugurru anaani nimbirrima-yambang mana-ṉuga ma-ḻandhirrngindaa-wuy, ‘Ba-yaarri, ba-barawudina buguni ama-lhagayag-guy,’ anubani-yung ama-waṉbina anubani-yung. ");
INSERT INTO nuy_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nugurru-maynji numburru-jambarrgiiyn, nugurru anaani nimbirri-mani anaaynba-gaynbaj-jinyung nugurru numbunu-yandhawiwana na-God-guy.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Na-Jesus ni-yanggi a-Temple-Maṉngulg-guy marri wurrugu niga wani-yiyini bagu warruburru-yung warra-wurru-wurruj. Anubanila-wala, warra-runggu-runggal warra-priest marri warra-mijiwanggu wurru-yanggi nigawi-wuy. Wugurru wurru-yamayn, “Ajigala nagang aadanu nunggaṉbina anaani anaarrawindi-lhangu? Yangi-nyung nagang nimbi-lharrgang, marri nunggaṉbini anaani-rruj?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nigaayung na-Jesus ni-yamayn, “Ngaya anaani nguynju-waj nganamba-yandhawiwana nugurru. Nugurru-maynji ngirri-yambalmang ngaya, nguynju-waj ngaya nganamba-magana nugurru, anubani-yung-jinyung ngaya ngaaṉbina anaarrawindi-lhangu. ");
INSERT INTO nuy_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ajigala naagi-yung na-John waniimbara-ngambijgaa? Nubagila na-God-gala yagu nugurri-wala warra-wurru-wurruj-gala?” ni-yamaa. Wugurraayung wurru-yambiynjini, “Ngagurru-maynji ngaambu-yamana na-God-gala, nigaayung ani-yamang, ‘A-yangi yungguyung naagi-yung waari numbunaa-ngu-jambarrgini na-John?’ ");
INSERT INTO nuy_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Yagu yagi ngurru-yami ‘warra-wurru-wurruj-gala,’ ngagurru yamba ngurru-ḏirrngawina warra-wurru-wurruj-gala. Waadurru-yung yamba wuu-jambarrgiiyn na-John, yijgubulu anubani-yung naa-ja-jambini-yinyung na-God.” Dani-yung wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Wudani-yung-gala, warraawurru-yung wurru-yamayn, “Nurru-maḻaḻadi nurru,” wurru-yamayn. Nigaayung na-Jesus wani-yamijgayn, “Waari yamba nugurru ngirri-magaa, ngaayung yagi ngana-magi nugurri-wuy, yangi-nyung ngaya ngambi-lharrgang, marri anaani ngaaṉbina.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Naagi-yung na-Jesus ni-yambini-wugij. “Nugurru numburraawanggina anaani ana-lhaawu. Na-waḻyinyung wani-waṉagaa wini-wulawaa na-niwiyayung-biiyung. Niga ni-yanggi na-wulhu-wulhurr-yung-guy marri ni-yamayn, ‘Ba-yaarri ba-mijgalmina ana-yimbaj ngayawi-nyinyung-duj waanuynjungina-rruj,’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Yagu nigaayung na-niwiyayung ni-yamayn, ‘Yagi nga-rumi,’ ni-yamayn, yagu wurrugu ni-wijangani, marri ni-yanggi. ");
INSERT INTO nuy_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nguynju-waj na-ninyarra-yung ni-yanggi naaynbajung-guy nga ni-yambini wu-nguynju ana-lhaawu. Nigaayung na-niwiyayung ni-yamayn, ‘Yii, ngaya anaani ngaynjaarri,’ ni-yamayn, yagu waari ani-yanggi niga. ");
INSERT INTO nuy_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yangi-nyung na-wulawaa na-niwiyayung-biiyung wunu-yandhurrbangaa na-ninyarra-yung?” Dani-yung ni-yambini na-Jesus. Wugurraayung wurru-yamayn, “Na-wulhu-wulhurr-yung,” wurru-yamayn. Nigaayung na-Jesus ni-yambini wugurri-wuy, “Ngaya ngana-magana nugurru yijgubulu-windiyung, wirri-mana-mani-yinyung ana-tax anu-ṉuga marri warra-maṉaṉung wurraaynjaaynji-yara-yinyung, nugurru nurraan-jamana wugurru wurraalaaladi, yagu burru-yung wurru-ngarra-jaarri anaarrwiyaj na-God-guy ana-raga-ragij-gaj nugurru aadanu. ");
INSERT INTO nuy_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Anaani wiijamana. Nubagi-yung na-John nani-yiyini nugurru maaḻamburrg-waj numburru-burraa. Yagu nugurru waari numburru-jambarrgini niga, yagu warruburru-yung wurraalaaladi, wugurru wurru-jambarrgini niga. Nugurru nurraarra-nani anaani, yagu nugurru nurru-lhaabini-wugij, waari-wugij numburru-jambarrgini nigawi-wuy.” Dani-yung na-Jesus ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Naagi-yung na-Jesus ni-yambini-wugij. “Numburraawanggina anaani ana-lhaawu. Na-waḻyinyung yaga ni-wanuynjungaa wubani-yung a-wuyarrangaḻ nguynju yungguyung aniwu-maṉdhangi wugargayag. Anubani-yung niwu-dhidangi ruluj nguynju yagi yungguyung ambu-yanggi anubuguni. Marri ni-rigandi ana-gara nguynju yungguyung aniwu-burrii buguni anubani-yung ana-wuyarrangaḻ marri aniwu-dhurrmana. Anubani-yung nima-muṉḏugaa nimaambarra-yarrmayarrmijgayn mana-ṉuga, wurru-wiḏangi yungguyung, nguynju wurraarranggaa nguynju yagi yungguyung warruburru-yung amburraamaji. Marri wani-lhangarrmayn waḻya-waḻya, warruburru-yung ambirri-rangarrangi ana-lhal, marri anubani-yung ni-yanggi yuuguni a-lhal-aynbaj-guy. ");
INSERT INTO nuy_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Anubani-yung lhangarrmayn-jinyung anubani-yung wu-warradangi ana-wuyarrangaḻ. Wani-lharrgang wunaa-mijgalmini-yinyung warruburru-yung-guy wirri-rangarrangi-yinyung-guy, wurru-mangi yadhu nigawi-nyinyung a-wuyarrangaḻ. ");
INSERT INTO nuy_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Yagu wugurraayung wirri-rangarrangi-yinyung ana-lhal, wugurru warra-bilhargaa warruburru-yung wurru-mijgalmini-yinyung. Naaynjaabu-nyung wunaarra-wadjangi, wunu-wini naaynbajung-guy, wunu-ngawijgayn niga. Marri aḏaba naaynbajung wunaambaḻgaa ṉuga-mirri. ");
INSERT INTO nuy_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Yagu na-waḻyinyung wani-lharrgang mulung-arrgi-yung wunaa-mijgalmini-yinyung, nguynju-waj ngijang aḏaba niga wani-lharrgang ana-wulhu-wulhurr-waj. Yagu wugurraayung wirri-rangarrangi-yinyung ana-lhal, wurru-waṉbini wu-nguynju anaarrawindi-lhangu ana-raga-ragij-gaj. ");
INSERT INTO nuy_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Yagu na-waḻyinyung ni-wijangani anu-lharrgang nigawi-nyinyung na-niwiyayung. Niga ni-yamijgini nigaajbaj, ‘Ari nubagi ambunu-yandhurrbangana ngayawi-nyinyung na-nigi,’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Yagu anubani-yung warruburru-yung wirri-rangarrangi-yinyung wunu-nayn na-niwiyayung ni-rabaliyn, wugurru wurru-yamayn wugurraajbaj ‘Numburraarranggang, yaagila na-niwiyayung. Aniwu-mang ari anaani ana-lhal, malgadhaadharri wurrugu nubagi-yung-gala na-yiwanggu-nyung-gala. Numburraaṉiyn, ngaanuumana naagila. Ngagurru-waj anaani ngaanggu-lhal-waṉagana anaani ana-lhal.’ Dani-yung wurru-yamijgaynjini. ");
INSERT INTO nuy_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Aḏaba wunu-bilhargayn marri wunu-barawudiyn anubanila ana-lhal-wala, nga wunu-wini, ni-ngawiiyn.” ");
INSERT INTO nuy_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Naagi-yung na-Jesus ni-yambini-wugij. “Yagu anubani-yung naabalijung, ni-yaminggarrina ani-waṉbina warruburru-yung-guy, anubani-yung niga ani-waṉiyn-maynji?” Dani-yung ni-yamayn na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wugurraayung warra-wurru-wurruj wurru-yamayn, “Niga anaani yijgubulu ambaniimana warruburru-yung warraalaaladi warra-waḻya-waḻya, ambani-ngawijgang wugurru. Aḏaba niga anaani ambaniiyn anubani waanuynjungina-yinyung warra-mulung-aynbaj-guy, warruburru-yung ambunuuyn niga nigawi-nyinyung ana-wuyarrangaḻ amburru-muṉḏugana-yinyung,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nigaayung na-Jesus ni-yambini wugurri-wuy, “Yuga nugurru anaani nirri-nani aḏaba, na-God-jinyung ana-wubiba? ‘Warruburru yaga wirri-maṉdhangi wumurrng. Anubagala wirrima-barawudiyn aynjaabugij ṉuga. Yagu manubama mana-ṉuga ma-burraa aḏaba anuwaagu anu-nguḏuṉ-duj, ma-runggal-windiyung magurru. Na-Buunggawa anaani ni-waṉbina. Ngurraarranggana ngagurru anubani-yung ni-waṉbina, marri ngurru-waḻaaḻarrii.’” ");
INSERT INTO nuy_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","Naagi-yung na-Jesus ni-yambini-wugij niga. “Yagu ngaya ngana-magana nugurri-wuy, anubani-yung anaarrwar na-God ni-buunggawa-mana-yinyung, anubani-yung aniwu-yarina nugurri-wala marri ambaniiyn warra-wurru-wurruj wurru-waṉbina-yinyung anaarrawindi-lhangu na-God niwu-ngaynbandiyn-jinyung niga.” Dani-yung ni-yambini na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wugurraayung warruburru-yung warra-runggu-runggal warra-priest marri warra-Pharisee warraawanggiyn anaani-yung ana-lhaawu, wugurru wurru-marrbuy na-Jesus ni-yambini-yinyung anubani-yung wugurri-nyinyung. ");
INSERT INTO nuy_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Wugurru naagi wunu-ngaynbandangi ambunu-bilhargaa niga bagu, yagu wugurru wurru-ḏirrngawiiyn warra-wurru-wurruj-gala, yagu yamba warruburru-yung wurru-jambarrgiiyn anubani-yung na-Jesus niga naa-ja-jambini-yinyung na-God niga. ");
INSERT INTO nuy_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Na-Jesus ngijang wani-magaa ana-lhaawu, wani-bajiyini warra-wurru-wurruj. Niga ni-yambini. ");
INSERT INTO nuy_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Na-God ni-buunggawa-mana-yinyung anaarrwar, nguynju yaga na-king-jii niga ni-warra-waṉagaa arrawindi ana-marrya, marri nguynju yadhu warruburru-yung warraarrawindi amburru-nguni yadhu wugurru, nigawi-nyinyung yamba na-niwiyayung aniiynji-yaay. ");
INSERT INTO nuy_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Marri na-king niwu-lharrgang lhaawu warra-mulung-arrgi-yung-guy warra-wurru-wurruj ‘Numburraaṉina, numburru-nguyii.’ Wani-lharrganjii nigawi-nyinyung wunaa-mijgalmini-yinyung, warra-magaa warra-wurru-wurruj. Yagu wugurru wurru-lhaabiyn waari amburru-yanggi warruburru-yung. ");
INSERT INTO nuy_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Aḏaba na-king wani-lharrgang mulung-aynbaj wurru-mijgalmini-yinyung. Ni-yamaa, ‘Nambarra-magana warruburru-yung, ana-marrya marri ana-lhanggu wu-warra-ngu-burraa. Wurru-wini arrawindi ana-bulugi ana-mamanunggu marri wurru-nangaa ana-lhanggu. Numburraaṉina, ngaambu-nguyii,’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Warraawurru-yung wunaa-mijgalmini-yinyung wurru-yanggi, warra-magaa, yagu wugurraayung warruburru-yung wurru-lhaabiyn-bugij, warraagaminij-gaandirrangi, wurru-yanggi. Aynjaabu-nyung ni-yanggi ni-mijgalmini nigawi-nyinyung-duj abaḻa, marri naaynbajung ni-yanggi nigawi-nyinyung-guy a-shop-guy. ");
INSERT INTO nuy_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Warra-mulung-arrgi-yung warra-bilhargayn wugurru, warraarra-wadjangi marri warra-ngawijgayn wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Nigaayung nubagi-yung na-king ni-riyaldhiyn-bindiyung. Niga wani-lharrgang nigawi-nyinyung wurru-wiynji-wiynjini-yinyung. Warruburru-yung warra-wini, warruburru-yung-guy wurru-lhaabini-wuy, warra-mulu-mulunguwawaa, marri wirri-nangaa wugurri-nyinyung ana-wumurrng. ");
INSERT INTO nuy_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Anubanila-wala, nubagi-yung na-king ni-yambini nigawi-nyinyung-guy wunaa-mijgalmini-wuy, ‘Ana-marrya aḏaba wu-warra-ngu-burraa, yagu warruburru-yung waari amburru-yanggi, wurraalaaladi yamba wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yagu numburru-yaarri wubani-wuy amaadi-wuy, marri nambarra-yandhawiwana warraaynjaaynjaabugij-gaj nugurru nambarra-lhangarrmang-jinyung, amburru-yaarri yungguyung ngayawi-nyinyung-guy a-marrya,’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“Yagu wurru-mijgalmini-yinyung wurru-yanggi buguni amaadi-wuy, marri warra-muṉḏugaa warraarrawindi-lhangu wugurru warra-lhangarrmayn-jinyung, warra-mamanunggu marri warraalaaladi. Marri ana-wumurrng ana-marrya-yinyung waandharwini, wurru-wurruj-bugij. ");
INSERT INTO nuy_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nga nubagi-yung na-king ni-waliyn, wani-nani warra-wurru-wurruj. Niga nu-nayn na-waḻyinyung nubagi-yung waari ani-yabini mana-yaaḻi ana-maaḻamburrg. ");
INSERT INTO nuy_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Naagi-yung na-king ni-yamayn, ‘Guwaj, nuynjaminggarrini nagang nuynjanggi anaaji? Nagang waari ba-yabini mana-yaaḻi ana-maaḻamburrg,’ ni-yamayn, yagu nigaayung na-waḻyinyung waari ani-yambini. ");
INSERT INTO nuy_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Yagu nigaayung na-king wani-magaa wurru-mijgalmini-yinyung, ‘Numbunu-radbumana naagi a-marang-duj marri a-mun-duj, numbunu-barawudang niga buguni waangamudi-wuy. Anubagu warruburru-yung amburru-ruguna marri amburru-ra-bangaynjina amburraarragayii yamba wugurru,’ ni-yamayn na-king. ");
INSERT INTO nuy_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Yii, na-God nanii-gaḏii warraarrawindi nugurru, yagu wurraadharra ni-wajbarini niga.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Anubanila-wala, warruburru-yung warra-Pharisee wurru-muṉḏugaa, marri wirriijungaa, nguynju yungguyung naagi-yung ambunu-yambini yungguyung yij-galadi marri ambunu-dhaayurrijgaa. ");
INSERT INTO nuy_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Wugurru warra-lharrgang wugurri-nyinyung wurru-marrbuy-maa-yinyung marri mulung-arrgi-yung wurru-wurruj warruburru-yung-gala warru-mandag-gala wurru-mayini na-Herod-jinyung. Wugurru wurru-yanggi na-Jesus-guy, nga wurru-yamayn, “Barra-yiyina-yinyung, nurru nurru-marrbuy aadanu nagang nuynjambina yijgubulu. Marri anubani-yung nagang barra-bajiyiyina yijgubulu-windiyung anubani-yung na-God-jinyung nigawi-waj-jinyung. Warraaynbaj waari nagang ambu-buunggawa-magaa. Waari nagang bamba-nang anubani-yung anaarabarabalu-waj. ");
INSERT INTO nuy_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Yagu numba-magana nurru, anubani-yung numbijangayii-yinyung. Yuga wiij-maṉdhina, ngagurru nganuuyii-yinyung nubagi-wuy na-runggal-yung na-Caesar anu-ṉuga, yagu waari?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nigaayung na-Jesus ni-marrbuy anaani-yung wunu-dhaayurrangi. Naagi-yung ni-yambini, “Nugurru aadanu nurraambaḻaman-gina! A-yangi yungguyung ngaya anaani ngirri-dhaayurrii? ");
INSERT INTO nuy_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ngirri-bajiyiyina ngaya anu-ṉuga narriini-yinyung ana-tax.” ni-yamayn. Wugurraayung wunu-bajiyini niga anu-ṉuga. ");
INSERT INTO nuy_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nigaayung ni-yamayn, “Wa-yangi-nyung anu-malnguj marri ana-muwaj anu-ṉuga-rruj?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wugurraayung wurru-yamayn, “Yagu nubagi na-Caesar niga.” Nigaayung aḏaba ni-yamayn, “Na-Caesar-yinyung anubani-yung, nugurru numbunaa-gaagijgiyn numbunuuyn nigawi-wuy. Marri anubani na-God-jinyung wugurraayunggaj numbunuuyii-wugij.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Wugurraayung warraawurru-yung wurru-wurri-ḻaḻmayn, anubani-yung-jinyung wani-yambalmayn wugurri-wuy. Marri wunaarruyn niga, wurru-yanggi aḏaba. ");
INSERT INTO nuy_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Anubani-yung ngi-nguynju-rruj ngarraaḻirr, mulung-arrgi-yung warra-Sadducee wurru-yanggi na-Jesus-guy. Warraawurru-yung wurraan-jamaa, warrubawa-yung wu-ngawina-yinyung waari wu-wiri-mi wugurru ngijang. Wurru-yanggi bagu, marri wunu-yandhawiwaa niga. ");
INSERT INTO nuy_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Wugurru wurru-yamaa, “Barra-yiyina-yinyung, na-Moses ni-yamayn aniiynji-yara-maynji na-waḻyinyung, marri niga ani-ngawiiyn yagu waari ambani-lhamaa warra-mijburrayung, nigawi-nyinyung na-nilharri-yung aniiynji-yara ngarra-ngayi-nyung, marri ambani-lhamana warra-mijburrayung nigawi yadhu ni-ngawiiyn-jinyung niga. ");
INSERT INTO nuy_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Anubani-yung warruburru-yung 7 wuu-dharrmaynjini-yinyung wurru-burri nurri-rruj. Marri na-wulhu-wulhurr-yung niiynji-yaay, yagu ni-ngawiiyn, waari ambani-lhamaa warra-mijburrayung. Nigawi-nyinyung na-nilharri-yung niiynji-yaay ngarra-ngayi-nyung. ");
INSERT INTO nuy_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Aḏaba naadhaadharri-nyung nguynju-waj ni-ngawiiyn. Anubani-yung wiij-nguynju nubagi-yung-guy naaynbajung marri warraarrawindi warra-mulung-arrgi-yung warra-7 warra-minilharri-yung. ");
INSERT INTO nuy_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Anubanila, ngigaayung ngarra-maṉinyung adhaadharri-windiyung, ngi-ngawiiyn ngiga. ");
INSERT INTO nuy_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","“Yagu anubani-yung warraarrawindi warra-7 warra-waḻya-waḻya wurraaynji-yaay-yinyung ngiga. Anubani-yung-maynji warra-wurruj-wurruj amburru-ḻaḻagina anubanila ana-ngawij-gala, wa-yangi-nyung-jinyung ngarra-rangarrina-yung, ngiga yamba ngiiynji-yaay warra-7 ngaadagi-yung?” Dani-yung wurru-yamaa, warruburru-yung warra-Saducee. ");
INSERT INTO nuy_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nigaayung na-Jesus wani-magaa, “Nugurru aadanu aḏaba nirriij-gajarrgaa. Yagu waari yamba aadanu numburru-marrbuy-maa anubani ana-lhaawu na-God-jinyung, marri waari-mirri numburru-marrbuy-maa anubani ana-lhuḏ na-God-jinyung. ");
INSERT INTO nuy_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Anubani-yung-maynji warra-wurruj-wurruj amburru-ḻaḻagina ana-ngawij-gala, wugurru anaani waari wurraaynji-yingi. Wugurru anaani nguynju yaga ana-angel anaarrwar-yinyung, amburru-yamana. ");
INSERT INTO nuy_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yagu nugurru yuga waari nimbirri-nani ana-wubiba, anubani-yung na-God ni-yambini nugurri-wuy anubani-yung amburru-ḻaḻagina-yinyung ana-ngawij-gala. ");
INSERT INTO nuy_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Na-God ni-yambini, (Exodus 3:6) ‘Ngaya anaani na-God na-Abraham-jinyung marri na-Isaac-jinyung marri na-Jacob-jinyung,’ ana-wubiba anaani wu-yamana. Na-God-jinyung warra-wurru-wurruj, warruburru-yung waari-yinyung amburru-ngawini, warruburru-yung wurru-wiri.” Dani-yung ni-yambini na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nguynju-waj warra-wurru-wurruj wurraawanggini anaani, wugurru wurru-wurrij-gaḻaaḻarrangi na-Jesus wani-yiyini-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Anubani-yung warra-Pharisee wugurru wurru-marrbuy-dhini, anubani-yung warra-Sadducee waari ambunu-yambalmaa na-Jesus, warraawurru-yung warra-Pharisee wugurru wurraaynjaabu-mayn. ");
INSERT INTO nuy_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Aynjaabu-nyung na-Pharisee-yung, ni-marrbuy-yinyung ana-lhaawu-runggal, nu-yandhawiwaa na-Jesus, anu-dhaayurrangi yungguyung niga. ");
INSERT INTO nuy_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Barra-yiyina-yinyung, aniga-yung aniij-ḏunggal ana-lhaawu?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nigaayung na-Jesus nu-yambalmayn, (Deuteronomy 6:4-5) “‘Numbunaa-ḏamarr-ngu-burraa na-Buunggawa nugurri-nyinyung na-God, nugurri-wala aandhiri-wala marri a-wiri-wala marri amaamburumburung-gala.’ ");
INSERT INTO nuy_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Anaani ana-wulhu-wulhurr-yinyung marri aniij-ḏunggal ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Marri anaadhaadharri-yinyung ana-lhaawu wu-nguynju. (Leviticus 19:18) ‘Warrubawa-yung nambarra-ngaynbandii nurraalgurmaynjina-yinyung nugurru, nguynju yaga danu nurru-ngaynbandiina nugurraajbaj,’ ");
INSERT INTO nuy_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","“Anaarrawindi-lhangu ana-lhaawu-runggal marri waarrarrina warruburru-yung wunaa-ja-jambini-yinyung na-God, anaarrawindi-lhangu wu-lhaawu-rabalii anaani-yung anuulawaa ana-lhaawu.” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Wugurru warra-Pharisee wugurru wurraaynjaabu. Naagi-yung na-Jesus wani-yandhawiwayn wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Yangi nugurru nurru-wijangayii anubani-yung na-runggal-yung na-Messiah? Wa-yangi-nyung-jinyung na-niwiyayung niga?” ni-yamayn. Wugurraayung wurru-yamayn, “Na-Messiah, niga na-niwiyayung na-David-jinyung,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nigaayung aḏaba na-Jesus ni-yamayn, “Yagu ni-yaminggarrini na-David nu-mayaa niga na-Buunggawa? Na-David ni-yambini lhuḏ-mirri Maṉngulg Mawurr, ni-yamayn, ");
INSERT INTO nuy_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Na-God nu-magaa na-king-guy, ngayawi-nyinyung-guy na-buunggawa-wuy, “Ba-burrangang yaaji ngayawi-rruj a-walawalama-rruj. Wurrugu marri, nugawi-nyinyung warruburru nurru-wurrij-marrdiynjini-yinyung, wurrugu ngamba-burrang nugawi-rruj a-mun-duj, bamba-mun-ban.ngang.” ’ Dani-yung ni-yamaa naagi-yung na-David. ");
INSERT INTO nuy_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Na-David niga-waj nu-mayaa nubagi-yung na-king, na-Messiah, ‘Buunggawa’, ni-yamaa. Yuga na-David-jinyung na-niwiyayung, nubagi na-David-jinyung na-buunggawa-yung?” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Wugurraayung warra-Pharisee wurraan-jamaa, waari warraaynbaj ambunu-mayaa na-niwiyayung, “buunggawa”. Warraawurru-yung waari ambunu-yambalmaa na-Jesus. Anubanila-wala, waari warraaynbaj wugurru amburru-wurrij-baḏa-waḏaḏ-maa. Yagu waari anaani ambunu-yambiḻibiḻingaani niga ngijang. ");
INSERT INTO nuy_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Anubanila-wala, niga na-Jesus wani-magaa, warru-mandag marri nigawi-nyinyung wurru-marrbuy-maa-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ni-yamayn, “Warruburru-yung warra-yiyina-yinyung ana-lhaawu-runggal marri warra-Pharisee nambi-yiyina na-Moses-inyung ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yagu nugurru nambarra-yandhurrbangana, marri nimbirri-garrindharrmani wugurri-nyinyung ana-lhaawu, yagu yagi nurru-waṉbi anubani-yung wugurru wurru-waṉbina-yinyung. Yagu yamba wugurru nambi-magana anubani-yung numburru-waṉbina-yinyung anaarrawindi-lhangu, yagu wugurru waari amburru-waṉbang wugurraajbaj! ");
INSERT INTO nuy_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wugurru wirriij-maṉdhii wiij-baḏa-waḏaḏ ana-lhaawu marri nambi-magana nugurru nimbirri-yandhurrbangana wugurru, yagu wugurru waari nambambi-maṉmang nugurru nurru-waṉbina-yinyung wugurri-nyinyung ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Wugurru wurru-waṉbina-yinyung mamanunggu-waj anaarrawindi-lhangu yagu anubani-yung warra-mulung-arrgi-yung anaani ambirri-nayii wugurru. Wugurru wirri-burri ana-lhaawu na-God-jinyung, wurraambaḻ-yabina a-yinag-duj, marri wirrima-maṉdhii mana-mamanunggu mana-yaaḻi ma-jarrmayarrmaj, ambirrima-nayii yadhu warra-wurru-wurruj, amburru-wijangayii wurru-mamanunggu wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","“Warraawurru-yung warra-Pharisee marri warra-yiyina-yinyung ana-lhaawu-runggal, anubani-rruj wurru-nguyu-nguyii-rruj, wirri-ngaynbandii amburru-burraa wubani-rruj a-mamanunggu-rruj. Marri anubani wurru-yaarri nga wurru-burraa wubani-yung a-mamanunggu, wubani a-synagog-duj. ");
INSERT INTO nuy_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Wugurru warra-ngaynbandii warruburru warra-wurru-wurruj amburru-yambina mamanunggu lhaawu wugurri-wuy anubani-rruj ana-shop-duj. Marri wugurru warra-ngaynbandii-windiyung warra-wurru-wurruj warra-mayana wugurru, ‘ngirri-yiyina-yinyung’. ");
INSERT INTO nuy_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Yagu nugurru aadanu, waari warraaynbaj nambi-mayi ‘ngirri-yiyina-yinyung’, yagu yamba nugurru nuunu-waṉagana naaynjaabu-nyung nani-yiyina-yinyung, niga na-God. Marri nugurru naa-murruyung-gaang ngaa-murruyung-gaang nurraaynjaabu aadanu. ");
INSERT INTO nuy_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Marri yagi narra-mayi warraaynbaj warra-wurruj anaani-rruj ana-lhal ‘baba’, yagu yamba nugurru nuunu-waṉagana aynjaabu-nyung-bugij na-Baba anaarrwar-yinyung nubagi. ");
INSERT INTO nuy_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Marri nugurru yagi nambi-mayi buunggawa, yagu yamba nugurru ngirri-waṉagana ngaya-waj nga, nugurri-nyinyung na-Buunggawa, marri nga-mayina na-Christ anaani. ");
INSERT INTO nuy_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","“Warruburru-yung wurru-runggu-runggal nugurri-rruj, wugurru nambii-mijgalmina-yinyung nugurru. ");
INSERT INTO nuy_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Anaani wiijamana, nugurru-maynji numburru-runggal-wiiyn, na-God niga nubagi nambani-winyig-gang aadanu. Yagu nugurru-maynji numburru-winyig-gina, God niga-waj nambani-runggal-wana aadanu.” ");
INSERT INTO nuy_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Naagi-yung na-Jesus ni-yambini-wugij. “Anubani-yung wungarri wu-waṉina nugurri-wuy, warra-yiyina-yinyung ana-lhaawu-runggal marri warra-Pharisee! Nugurru aadanu nurraambaḻaman-gina! Nugurru nimbi-dhidang anu-dhawang warra-wurru-wurruj, yagi yadhu wurru-rumi anaarrwar-wuy! Nugurru nugurraajbaj yagi nurru-rumi, marri ngijang nugurru narra-lhambumana warraaynbaj-guy, warruburru-yung amburru-yaarri-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Anubani-yung wungarri wu-waṉina nugurri-wuy, warra-yiyina-yinyung ana-lhaawu-runggal marri warra-Pharisee! Nugurru aadanu nurru-yaarri nurru-gaḻawajii a-lhal-waj marri ama-lhagayag-baj nambarraagalhaga-lharrmani warraaynjaabugij warra-wurruj nguynju yadhu warrubawi-yung nambambi-garrindharrmani nugurri-wuy. Yagu nugurru-maynji numbunu-lhangarrmang, nubagi-yung na-wurrujung nugurru numbunaa-ḏagaana, ani-yaarri wubani-wuy a-ngura-wuy, nguynju-waj nugurru aadanu! ");
INSERT INTO nuy_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Anubani-yung wungarri wu-waṉina nugurri-wuy! Nugurru narra-rangarrii warra-wurru-wurruj yagu nugurru nurru-ba-galadi! Nurru-yambina, warra-wurru-wurruj-maynji ambarra-lhalamayana, marri ambirri-mayana ana-Temple-Maṉngulg, anubani ana-lhaawu anggu-nunggarrbidi wugurru. Yagu wugurru-maynji ambirri-mayana-maynji ana-gold anubani-yung ana-Temple-Maṉngulg-duj, anubani ana-lhaawu anggu-waḏa-waḏaḏ, wugurru amburru-waṉbina anubani ana-lhaawu warra-lhalamayana-yinyung wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","“Nugurru nuu-yilg-balii! Yangi wu-runggal, ana-gold yagu ana-Temple-Maṉngulg anubani-yung maṉngulg-gana ana-gold-guy? ");
INSERT INTO nuy_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Marri nugurru warra-Pharisee nurru-yambina, warra-wurru-wurruj-maynji ambarra-lhalamayana, marri ambirri-mayana ana-altar, anubani-yung ana-lhaawu wu-nunggarrbidi, yagu wugurru-maynji ambirri-mayana anu-jiigurung ana-altar-rruj, anubani ana-lhaawu anggu-waḏa-waḏaḏ, wugurru amburru-waṉbina, anubani-yung ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","“Nugurru nurraa-munmani! Yangi wu-runggal, anu-jiigurung yagu ana-altar anubani-yung maṉngulg-gana anu-jiigurung-guy? ");
INSERT INTO nuy_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Anaani ngana-magana nugurri-wuy. Nugurru-maynji nimbirri-mayana ana-altar, anaani wiijamana, nimbirri-mayana anubani ana-altar marri nguynju-waj anaarrawindi-lhangu ana-altar-rruj. ");
INSERT INTO nuy_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","“Marri nimbirri-mayana-maynji ana-Temple-Maṉngulg, anaani wiijamana, nimbirri-mayana ana-Temple-Maṉngulg marri nguynju-waj numbunu-mayana na-God-guy, niga yamba ni-burraa ana-Temple-Maṉngulg-duj niga. ");
INSERT INTO nuy_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Marri nimbirri-mayana-maynji anaarrwar, anaani wiijamana na-God-jinyung ni-burraa-rruj, marri niga na-God nubagi-yung ni-burraa-yinyung anubani-rruj. ");
INSERT INTO nuy_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Anubani-yung aladi wu-waṉina nugurri-wuy, warra-yiyina-yinyung ana-lhaawu-runggal marri warra-Pharisee! Nugurru aadanu nurraambaḻaman-gina! Nugurru nuunuuyii na-God waadharra anaarrawindi-lhangu nugurru nurraarra-waṉagana-yinyung anaarrawuj-mamaaḻang-jinyung, anubani-yung yamba ana-lhaawu-runggal wu-yamana wugurru. Yagu nugurru waari nimbirri-yandhurrbang ana-runggal ana-lhaawu, waari nambarra-nguynju-nguynjijgang ana-maaḻamburrg, waari nambarra-man.galagang, waari numburru-jambarrg-magaa. Nugurru numburru-waṉbina anaani, marri nguynju-waj, anubani-yung ana-mulung-aynbaj anaarrawindi-lhangu. ");
INSERT INTO nuy_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nugurru narra-rangarrii warra-wurru-wurruj yagu nugurru nurru-ba-galadi! Nugurru nguynju yaga niini-mani na-milwiṉ nuu-waḻ-nguyii-wala yagu aḏaba nurru-lharrganjii anubani ana-gamul! ");
INSERT INTO nuy_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Anubani-yung aladi wu-waṉina nugurri-wuy, warra-yiyina-yinyung ana-lhaawu-runggal marri warra-Pharisee! Nugurru aadanu nurraambaḻaman-gina! Nugurru nirrima-yarrbumana arabarabalu-rruj nugurri-nyinyung mana-gaṉdharra marri anaaynba-gaynbaj-jinyung, yagu ana-lhirribala nugurri-rruj, nurru-murruwanjii marri nurru-ḻamumung-bindiyung aadanu. ");
INSERT INTO nuy_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Warra-Pharisee nugurru nurraamunmani-yinyung! Ana-wulhu-wulhurr ana-lhirribala numburru-yarrbina, marri aḏaba anaarabarabalu yijgubulu numburru-mamanunggu-windiyung. ");
INSERT INTO nuy_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Anubani-yung aladi wu-waṉina nugurri-wuy, warra-yiyina-yinyung ana-lhaawu-runggal marri warra-Pharisee! Nugurru aadanu nurraambaḻaman-gina! Nugurru nurru-yamana nguynju yaga aabiyn-jii, aḻarragamaṉa-yii anaarabarabalu, wugurraayung ana-lhirribala wu-ngunarr-mana! ");
INSERT INTO nuy_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Anubani-yung wiij-nguynju, nugurru nambi-nayii warra-wurru-wurruj, marri wurru-wijangayii nugurru nurru-mamanunggu, yagu ana-lhirribala nugurri-rruj nurraaladi-windiyung marri nurraambaḻaman-gina aadanu. ");
INSERT INTO nuy_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Anubani-yung aladi wu-waṉina nugurri-wuy, warra-yiyina-yinyung ana-lhaawu-runggal marri warra-Pharisee! Nugurru aadanu nurraambaḻaman-gina! Warruburru-yung wunaa-ja-jambini-yinyung na-God anu…bani-yunggaj marri warruburru wurru-burri-yinyung mamanunggu-waj, wugurri-nyinyung anaabiyn, nugurru manaama-yung nirrima-muṉḏugana aadanu arrwa-garrwar wubami-rruj ama-ṉuga, marri nugurru nirrimaarrarrii. ");
INSERT INTO nuy_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Marri nugurru nurru-yambina, ‘Ngagurru-magaa ngaambu-burri anu…bani-yunggaj warra-miyn-ngambara-waj, ngagurru yagi-magaa ngaamba-maṉmangi-magaa wugurru ambarra-wini-yinyung warruburru-yung wunaa-ja-jambini-yinyung na-God.’ Dani-yung nurru-yambina. ");
INSERT INTO nuy_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yagu nugurru nurru-yambina wudani-yung-jii, nurru-yambina nugurru aadanu warra-mijburrayung warruburru-yung-jinyung warra-wini-yinyung warruburru-yung wunaa-ja-jambini-yinyung na-God. ");
INSERT INTO nuy_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yagu ari nugurru numburru-waṉbina-wugij aadanu aladi, nguynju warruburru-yung-jii warra-miyn-ngambara-yii ana-wulhu-wulhurr! ");
INSERT INTO nuy_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Nugurru aadanu a-marryn-jii! Nurru-yaminggarrina nugurru yuga numburru-yarramana a-ngura-wala, na-God-jinyung-gala nambani-nguynju-nguynjijgana nugurru? ");
INSERT INTO nuy_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Yagu ngaya ngana-magana nugurru anaani, ngaya anaani ngamba-lharrganjii warra-mulung-arrgi-yung wunaa-ja-jambina-yinyung nugurri-wuy, marri wirri-lhaawu-yarrijgina-yinyung marri warra-yiyina-yinyung, ngaya ngamba-lharrganjii nugurri-wuy. Nugurru mulung-arrgi-yung nambarruumana marri nambarra-wudhii a-rangag-duj, warra-mulung-arrgi wugurru nugurru nambarraarrawadjii nugurri-nyinyung ana-synagog marri nambarra-man-dharrmani anubanila-wala anaanga-wala aaynbaj-guy aanga numburraandha-wuguuguni. ");
INSERT INTO nuy_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","“Yagu niga na-God nambani-lhajbumana nugurru aadanu, ama-wulang-jinyung warraarrawindi-yinyung warra-mamanunggu-yinyung warra-wurru-wurruj. Mana-wulang yaga nubagi-yung ni-wulang-jirryirrangi yigaj nubagi-yung na-Abel na-maaḻamburrg-jung yaga, ma-wuguuguni mana-wulang ma-dhililangi magurru, na-Zechariah-wuy nubagi na-niwiyayung na-Barachiah-yinyung. Nubagi-yung yaga wunu-jadugayn niga, wunu-wini a-Temple-Maṉngulg-duj, anubani ana-ḻibiḻibala wugurru gara-maṉngulg-bindiyung, wugurraayung ana-ḻibiḻibala ana-gara, anubani wugurru wurru-nanga-nangaa-yinyung, a-buluynjirri. ");
INSERT INTO nuy_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yuu, anaani ngana-magana nugurri-wuy aḏaba, anubani-yung na-God nambani-lhajbumana, nugurru aadanu nurru-burraa-yinyung ana-yimbaj anaani, amubama-wala ama-wulang-gala.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Naagi-yung na-Jesus ni-yambini-wugij niga. “Jerusalem, nugurru aadanu warra-wurru-wurruj ana-Jerusalem-jinyung aadanu! Malgarrawindi aḏaba nugurru narra-lhagarra-ngawijgana warruburru wunaa-ja-jambina-yinyung na-God, marri warruburru-yung wani-lharrgandi-yinyung niga na-God, nugurru narraambaḻgana ṉuga-mirri aadanu. Ngana-ngaynbandangi anaani ngaya malgarrawindi numburru-muṉḏugaa aḏaba ngayawi-rruj, nguynju yaga yiibagi-yung-jii yi-baawul-jii, ngi-muṉḏugijgana yaga ngigawi-nyinyung ana-wurraayung lhirribala ngigawi-rruj yi-ngarri-baṉja-rruj. Yagu nugurru waari ngirri-ngaynbandangi ngaya anaani. ");
INSERT INTO nuy_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ngubindi aḏaba, niga na-God niga-waj naniirruyn aadanu, nugurri-nyinyung-jinyung anaanga ana-Jerusalem-duj, wu-mamar marri waaladi. ");
INSERT INTO nuy_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Anaani ngaya ngana-magana, yagi anaani aḏaba ngaya ngirri-ni, marri wurrugu anaani ana-lhaawu numburru-yambina nga numburru-yamang, ‘Naadagilu ni-yaarri, nigawi yungguyung aḏaba na-Buunggawa na-God. Naadagilu, na-God naagajij-majgaa niga.’ Dani-yung numburru-yambina, ngirrii-jambina ngaya.” Dani-yung ni-yambini na-Jesus, na-nidhaawu-yung niga. ");
INSERT INTO nuy_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Anubanila-wala, na-Jesus niwaarruyn ana-Temple-Maṉngulg marri ni-yanggi. Wugurraayung nigawi-nyinyung wurru-marrbuy-maa-yinyung wurru-yanggi nigawi-wuy, wunu-bajiyini niga ana-Temple-Maṉngulg, wu-rayini. ");
INSERT INTO nuy_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Naagi-yung na-Jesus ni-yamayn, “Yuga nugurru nirri-nayii anaarrawindi-lhangu anaani wirri-raani-yinyung? Ngaya ngana-magana nugurru yijgubulu, yagi anubagu ma-murrgulhangi mana-ṉuga marri yagi ma-walamalhangi manaaynbaj, anubani-yung anggaa-mamaaḻang. Aadanu aḏaba anggu-jadugiiyn!” Dani-yung ni-yamayn niga. ");
INSERT INTO nuy_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Anubanila-wala, wurru-yanggi amubama-wuy ma-ḻandhirrngindi-wuy ama-ṉuga Mount of Olives. Nga bagu ni-burrangayn. Nigawi-nyinyung wurru-marrbuy-maa-yinyung wurru-yanggi nigawi-wuy wurru-wiri-wiri. Wugurru wurru-yamayn, “Numba-magana, yuga lhal-ngargu anaani anaarrawindi-lhangu anggu-waṉbina? Anaani-maynji anaani anggiij-barubaj-mana aḏaba, yuga yangi anubani nurru nambanggu-bajiyina, nagang baagiyn-jinyung ngijang marri anaani anggu-dhaagmana-rruj?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Na-Jesus nigaayung wani-yamijgayn, “Nugurru numburru-dhi-maṉdhina, warraaynbaj yungguyung nguynju yagi yungguyung nambi-dhaayurri. ");
INSERT INTO nuy_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Arraarrawindi yamba amburru-yaarri nugurri-wuy, marri amburru-yambina ngayawi-nyinyung-mirri ana-muwaj. Marri amburru-yamana, ‘Yagu ngaya-waj anaani na-Christ na-runggal-yung!’ amburru-yamang, marri ambarra-dhaayurrii warruburru-yung warraarrawindi warra-wurru-wurruj. ");
INSERT INTO nuy_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“Warra-mulung-aynbaj warruburru-yung nambambi-yambina, manubami-yung-jinyung mana-runggal mana-magarrangaynji, yaaji-waj marri malanganyanay. Yagi nurru-ḏirrngawi. Aadanu anggu-waṉbina raga-ragij. Anaani wiij-maṉdhina. Wurrugu marri malgadhaadharri, anaani ana-lhal anggu-jadugiiyn. ");
INSERT INTO nuy_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","“Yagu ana-raga-ragij, warruburru-yung warra-wurru-wurruj anubani anaaynjaabugij ana-lhal amburru-wiynjina yuuguni warra-mulung-aynbaj-guy. Warru-mandag-maynji warrubawa-yung amburru-burraa yuuguni warraaynbaj-guy warru-mandag-guy amburru-wiynjina. Anubagu anggaari ana-marrya, marri anubagu anggu-lhal-wirbirina ana-lhal-aynbaj-gala ana-lhal. ");
INSERT INTO nuy_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Anaani-yung anaarrawindi-lhangu anubani-yung ana-wulhu-wulhurr amburraarragayii, nguynju yaga anubani-yung warra-gadhuwa-yinyung warrubawi-yung ambaambuḻwiyn-jinyung.” ");
INSERT INTO nuy_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Naagi-yung na-Jesus ni-yambini-wugij. “Nugurru-waj, warra-wurru-wurruj nambambi-mang, nambambi-yarrijgina, nambambi-warragayijgana marri nambambiimana nugurru, numburru-ngawang. Wugurru nambambi-wurrij-bangana yagu yamba nugurru nurru-jambarrgiiyn ngayawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Anubani-yung aḏaba warraarrawindi amburru-muḏaḏbii, yagi wurru-jambarrgi, amburru-man-jarramana. Marri wugurru amburru-dhawawarumijgaynjina wugurraajbaj marri amburru-wurrij-bangaynjina wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mulung-arrgi-yung amburru-yamana, ‘Ngaya-waj nganaa-ja-jambina-yinyung na-God,’ yagu amburru-wawaḻii. Ambarra-dhaayurrii warraarrawindi warra-wurru-wurruj. ");
INSERT INTO nuy_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","“Anubani-yung runggal aladi anggu-ngarrgiyn, anaani-rruj ana-lhal, marri warraarrawindi warra-wurru-wurruj waari wunu-ngaynbandi na-God yagu warraaynbaj-guy. ");
INSERT INTO nuy_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Yagu nugurru numburru-lhara-wugij andhurrg aadanu, yagi nurru-lhuṉdhi. Nga anubani anggu-dhaag-mana-rruj, God niga-waj nambani-wiri-gana nugurru aadanu. ");
INSERT INTO nuy_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Marri yunggaj ana-mamanunggu ana-lhaawu anubani-yung na-God-jinyung warru-mandag, ambarra-magana ana-lhal-lhangu-waj, warraarrawindi-yinyung-guy warru-mandag. Anubanila-wala aḏaba, anubani-yung anggu-dhaagmana-rruj anggu-waṉbina.” ");
INSERT INTO nuy_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Naagi-yung na-Jesus ni-yambini-wugij. “Na-Daniel nubagi-yung naa-ja-jambini-yinyung na-God, ni-yambini wubani-yung anggu-burraa (Daniel 9:27) gangganyung anggu-malhi-lhara, wubani-rruj a-maṉngulg a-wumurrng,” ni-yamaa. Nugurru aadanu nirri-nayii-yinyung anaani ana-wubiba, ari nurru-marrbuy yangi anubani, ni-yambini-yinyung na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ni-yamaa-wugij, “Anubagu-maynji numburru-nayii, nugurru nurru-burraa-yinyung ana-Judea, numburru-yarramang amubama-wuy ma-ḻandhirrngindaa-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nugurru-maynji numburru-burraa wubani-rruj arabarabalu-rruj, yagi nurru-yabi, yagi nurraarra-mi anubani-yung anaarra anubanila-wala nugurri-nyinyung-gala ana-wumurrng. ");
INSERT INTO nuy_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nugurru-maynji ana-malanganyanay-wala anaanga-wala, yagi nurraagi anubani-yung nirrima-mi manubami-yung mana-yaaḻi. ");
INSERT INTO nuy_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ngarra-maṉinyung-maynji ngarrubagi-yung angi-wurrij-muṉḏurr yagu ngarrubagi-yung-maynji ambangi-wuynjijgana, anubani-yung anggu-waṉina-maynji, anggiij-miḏaamimi wugurri-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Nugurru numbunu-yambina arrwiyaj na-God-guy, wubani-yung nurru-yarramana-yinyung, ‘Yagi nunggiij-dharrgi anubani-rruj ngarraaḻirr-maṉngulg-duj yagu anaagalhal-aṉbana,’ numburru-yamana. ");
INSERT INTO nuy_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Yagu yamba anubani anggiij-maṉdhina runggal wungarri, waari aadanu anggiij-maṉdhini anggiijamaa anubanila na-God niwu-maṉdhangi-wala ana-lhal-lhangu, nga ana-yimbaj, marri anaani waari wu-waṉbi ngijang. ");
INSERT INTO nuy_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Na-Buunggawa ni-wijangani, aniwu-winyig-gang, anubani anggu-waṉiyn-maynji. Anubani-yung-magaa waari aniwu-winyig-gaa, waari warraaynbaj anubagu wu-wiri-mi. Yagu aniwu-muḏaḏbijgang anubani ana-wungarri aḻagaḻa, nguynju yadhu ambani-wiri-gana warruburru-yung nigawi-nyinyung warra-wurru-wurruj, ni-wajbarini-yinyung wugurru.” ");
INSERT INTO nuy_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Naagi-yung na-Jesus ni-yambini-wugij. “Anubani-yung, warra-mulung-aynbaj-maynji warruburru-yung nambambi-yamijgana, ‘Baarranggang, yaagi na-runggal-yung na-Christ,’ amburru-yamana-maynji, yagu ‘Yuuguni, baarranggang,’ yagi anubani-yung nurru-jambarrgi ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mulung-arrgi-yung yamba amburru-yamana, ‘Ngaya-waj na-Christ,’ yagu ‘Ngaya-waj nganaa-ja-jambina-yinyung na-God,’ yagu amburru-wawaḻii. Amburru-waṉbina runggal aniij-mamaaḻang, anaaynba-gaynbaj-jinyung. Warruburru-yung yingga ambarra-dhaayurrijgana warruburru-yung na-God-jinyung ni-wajbarini-yinyung, yagu yagi wurru-waṉbi wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yigaj! Ngaya ngana-magana aḏaba, anubani-yung anaani raga-ragij anggu-waṉbina-yinyung wurrugu.” ");
INSERT INTO nuy_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Naagi-yung na-Jesus ni-yambini-wugij. “Warra-wurru-wurruj-maynji nambambi-magana nugurru, na-Christ ni-burraa a-lhal-aṉḏarrg-duj, yagi nurru-rumi anubuguni. Wugurru-maynji amburru-yamang marri na-Christ ani-burraa lhirribala a-gara-rruj, yagi narraa-ngu-jambarrgi anubani-yung. ");
INSERT INTO nuy_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yagu yamba ngaya anaani, na-Niwiyayung na-Wurrujung-jinyung, ngandaagiyn-maynji, ngubindi-windiyung nga-milhiynjina ana-wumala-rruj, aajila ramalila marri yuuguni arrgaḻinyi nga-milhiynjina. Nguynju yaga yi-yamiynji ni-mindhii, anggiijamana wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Wubani-rruj yaga wu-ngawina-yinyung ana-wubulu, bagu yaga ngiga ngarrubagi ngarra-marrgij yaga ngiga angi-muṉḏugana.” ");
INSERT INTO nuy_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Naagi-yung na-Jesus ni-yambini-wugij. “Anubani-yung ana-malgadhaadharri anubanila ana-wungarri-wala, ‘Ngarraagi-yung ngarraaḻirr aḏaba angi-biingamudang, yagi na-ḻabama ni-wabarra-milhi. Ngarra-miyiri ngarrubagi-yung angiidbarrwiyn anaarrwar-wala. Anubagu anaarrwar-yinyung anubani-yung ana-waḏa-waḏaḏ-jinyung wu-burraa, anubani-yung anggu-warra-galalang.’ ");
INSERT INTO nuy_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Dani-yung nga nambanggu-bajiyina ngayawi-nyinyung, na-Niwiyayung na-Wurrujung-jinyung, anggaarrarra-giiyn ana-wumala-wala. Aḏaba warraarrawindi-yinyung warra-wurru-wurruj ana-lhal-rruj amburru-ruguna. Wugurru ngambambi-nayii ngaya, nga-ngu-dhirridii wubani-rruj a-ngubunung-duj. Anubani nganggu-waṉagana ngaya lhuḏ, marri nga-milhiynjina anuwaagala ngaynjaarri-maynji ngaya. ");
INSERT INTO nuy_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Anubani-yunggaj, na-God ni-wajbarini warra-wurru-wurruj nigawi yungguyung. Anubani-yung-maynji ngandaagiyn-maynji, marri ngandharrgang anaarrawindi ana-angel, marri na-lhambiḻbiḻg ani-lhamurriyn. Nguynju yungguyung warruburru-yung warra-wurru-wurruj amburru-muṉḏugana, anubanila-wala ana-lhal-aynbaj-gala ana-lhal anaarrawindi-lhangu.” ");
INSERT INTO nuy_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Na-Jesus naagi-yung ni-yambini-wugij niga. “Numburru-wijangayii amubami-yung ama-nunganyang-jinyung. Nugurru nurru-marrbuy-mana amubama-wala. Manubama-yung mana-magubaṉḏa ma-ninig-mayn marri wugadhuwa manjarr wu-rabalii. Anubani-yung nurru-marrbuy wiij-barubaj-mana agalhal-aṉbana. ");
INSERT INTO nuy_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Wudani-yung-jii, anubani-yung numburraarra-nayii anaarrawindi anggu-waṉbina, numburru-marrbuy ngaya anaani nga-burraa nugurri-rruj warubaj, nguynju yaga wu-dhawang-duj nga-burraa. ");
INSERT INTO nuy_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Anaani ngana-magana yijgubulu, warra-wurru-wurruj ana-yimbaj wurru-wiri, anubani-yung-maynji anggu-waṉbina-maynji, warruburru-yung yagi wuu-jadugi, amburru-wiri-wugij wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ari ana-wumala marri anaani ana-lhal anggu-jadugiiyn, yagu ngayawi-nyinyung ana-lhaawu yagi wu-jadugi wugurru.” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Naagi-yung na-Jesus ni-yambini-wugij. “Waari wu-marrbuy-mi warra-wurruj anubani-rruj wu-dhaag-mana-rruj anggu-waṉbang. Yagu ana-angel wugurraayung wu-maḻaḻadi. Ngaayung, na-niwiyayung, nga-maḻaḻadi. Yagu nigaaj-bugij na-Baba ni-marrbuy anaani. ");
INSERT INTO nuy_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Anubani-yung-maynji ngaya ngandaagiyn, ngaya na-Niwiyayung na-Wurrujung-jinyung, anubani-yung anggu-waṉbina nguynju yaga na-Noah-yii anu…bani-yunggaj. ");
INSERT INTO nuy_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Anubani wurru-nguni ana-marrya, marri anaani wurraaḻ-nguni. Marri wuu-lhalamayiynjini, marri wurru-maranguynjini. Wurrugu, niga na-Noah ni-yabiyn amubama-wuy ama-barrawu-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wugurru wurru-maḻaḻadi, anubani anggu-waṉbini-yinyung. Aḏaba mana-ngugu ma-waṉiyn marri wama-jadugayn wugurru. Anaani anggiiyn-nguynju, anubani-yung-maynji ngandaagiyn, ngaya-waj na-Niwiyayung na-Wurrujung-jinyung. Warruburru-yung warra-wurru-wurruj ambunaagaminij-gaandirrii-wugij na-God. ");
INSERT INTO nuy_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ambini-wulawaa waḻya-waa ambini-mijgalmina aabaḻa-rruj. Aynjaabu-nyung anu-yarina na-God, marri naaynbajung anaarruyn ani-burraa adhaadharri. ");
INSERT INTO nuy_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Marri ambingi-wulawaa maṉung-baa ambingi-yibana anu-ḏal. Nga na-God ngarrubagi angu-yarina aynjaabu-nyung, ngarraaynbajung angaarruyn ngiga.” ");
INSERT INTO nuy_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Naagi-yung na-Jesus ni-yambini-wugij. “Yagu nugurru-waj numburru-rangarrina, yagu yamba nurru-maḻaḻadi ngarraaḻirr ngaya anaani ngandaagiyn-jinyung, anaani nugurri-nyinyung na-Runggal-yung. ");
INSERT INTO nuy_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yagu nugurru anaani numburraawanggina aḏaba. Nubagi-yung ni-wamaamajaa-yinyung yagi niga nani-magi, lhal-ngargu ari anubuguni ani-yaarri nga aniwu-wagiwana nugurri-nyinyung ana-wumurrng. Niga-maynji nambani-magana-maynji nugurru, anubani-yung numburru-wanggirraa-wugij, numburru-burraa anubani-rruj nugurri-rruj anaanga-rruj. Yagu yagi-maynji niga nani-magi aniijgubulu, nugurru numburru-maḻaḻadi aadanu lhal-ngargu ari ani-yaarri niga. ");
INSERT INTO nuy_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","“Anaani wiij-nguynju aḏaba, ngaya na-Niwiyayung na-Wurrujung-jinyung, ngaynjaarri, nurru-maḻaḻadi lhal-ngargu ari anubani ngandaagiyn ngaya. Numburru-yamana nugurru numburru-burraa, numburru-wanggirraa. Numburru-burraa, ngirrii-garranggana ngaya. ");
INSERT INTO nuy_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Anaani wiijamana. Nugurru numburraawanggina aḏaba. Yangi-nyung yuga nubagi-yung na-waḻyinyung ni-mijgalmina-yinyung, marri ni-jambarrgina-yinyung niga, marri na-yina-mamaaḻang-jung niga? Nubagi-yung na-runggal-yung niga anu-magang, nubagi-yung ni-mijgalmina-yinyung, nguynju yadhu ambani-rangarrii yungguyung niga, warruburru-yung warra-mulung-arrgi-yung wurru-mijgalmina-yinyung anubani-rruj-jinyung ana-wumurrng. Marri nubagi ambaniiyii ana-marrya niga maaḻamburrg-galawaj. ");
INSERT INTO nuy_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Wurrugu nigaayung naabalijung ani-yaarri, nga ambani-nayii warruburru wugurru wurru-mijgalmina-yinyung. Nubagi-yung-maynji ani-mijgalmina-yinyung niga ani-waṉbina maaḻamburrg-galawaj, nubagi-yung naabalijung niga nubagi-yung ani-waḻaaḻarrii, marri anaagajij-majgana niga. ");
INSERT INTO nuy_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Anaani ngana-magana windiyung nugurru, nubagi-yung na-runggal-yung anu-magang-maynji, nubagi na-wurrujung, nguynju yadhu ani-warra-rangarrii anubani ani-warra-waṉagana nubagi na-runggal-yung niga. ");
INSERT INTO nuy_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Yagu nubagi-yung-maynji niga ani-mijgalmina-yinyung aniiladi, ani-yamijgina niga, ‘Nubagi na-runggal-yung waari niga ana-ngalbaḻang ni-rumi,’ dani-yung niga ani-yamana, ");
INSERT INTO nuy_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","marri ambaniimana warruburru-yung-guy warraaynbaj-guy wurru-mijgalmina-wuy, marri ani-nguyii-maynji nubagi-yung marri ani-bungurru-dhang-bindiyung niga warra-mulung-arrgi-yung-duj, ");
INSERT INTO nuy_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","anubani-yung niga ani-maḻaḻadi lhal-ngargu nubagi-yung na-buunggawa aniigiyn. Ngarrubagi-yung ngiga ngarraaḻirr lhal-ngargu marri, aniigiyn niga? ");
INSERT INTO nuy_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nubagi-yung niga anu-guldhang marri anu-barawudang niga, buguni warra-wurru-wurruj-guy wurraambaḻaman-gina-wuy. Warruburru-yung amburru-ruguna marri amburru-ra-bangaynjina amburraarragayii yamba wugurru.” Dani-yung ni-yamayn na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Naagi-yung na-Jesus ni-yambini-wugij. “Warruburru-yung warru-mandag anaarrwar-yinyung nguynju yaga 10 warra-miyn-ngaḻaynji, warruburru-yung wirri-waṉagaa wugurri-nyinyung anu-dhalng, marri wurru-yanggi wunu-narrangi nubagi-yung aniiynji-yaay-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Marang-aynjaabugij wugurru wurru-yilg marri marang-aynjaabugij wurru-yina-mamaaḻang. ");
INSERT INTO nuy_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Marri warra-yi-yilg warruburru-yung wirri-miyn wugurri-nyinyung anu-dhalng, yagu wugurru waari ambirri-waṉagaa anu-gargayag anu-dhalng anggu-nagini-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Wugurraayung warra-yina-mamaaḻang warra-miyn-ngaḻaynji wirri-waṉagaa wugurri-nyinyung anu-dhalng, marri anu-gargayag mana-gaṉdharra-rruj. ");
INSERT INTO nuy_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“Nubagi-yung aniiynji-yaay-yinyung waari ani-yanggi, baḏag-bindiyung niga. Wugurraayung wurru-yaal-ngawiiyn, wuu-lhagarra-yingayn. ");
INSERT INTO nuy_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Anubanila-wala, ana-miyn.giyn.gurarra aynbaj waaḏiyn, ‘Wuy! Nubagi yaagila ni-yaarri! Numburraaṉiyn marri ngaambaanggarra-yaarri nigawi-wuy!’ wu-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Wugurraayung warruburru-yung warra-miyn-ngaḻaynji wurru-marayanggiyn marri wirri-miyn wugurri-nyinyung anu-dhalng. ");
INSERT INTO nuy_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Yagu warra-yilg-jinyung wurru-yamayn warra-yina-mamaaḻang-guy, ‘Ngirriiyn nurru nugurri-nyinyung anu-gargayag, yagu yamba nurri-nyinyung anu-dhalng wu-yiga-ngawiiyn,’ wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Wugurraayung warra-yina-mamaaḻang warra-magaa, ‘Yagi! Nurru nirri-waṉagana waadharra nurraa yungguyung. Numburru-yaarri warruburru-wuy warriiyii-yinyung anu-gargayag marri numburru-bayandhii nugurraaj-baj,’ wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Wugurraayung wurru-yanggi wurru-bayandhangi anu-gargayag, yagu nubagi-yung aniiynji-yaay-yinyung ni-waṉiyn marri warra-marang-aynjaabugij warra-miyn-ngaḻaynji warruburru-yung wurraanggarra-yanggi wubani-wuy wurru-nguni-wuy, marri anubani-yung anu-dhawang wu-dhidiyn aḏaba. ");
INSERT INTO nuy_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Wurrugu warruburru-yung warra-mulung-arrgi-yung wurraagiyn marri wurru-yamayn, ‘Buunggawa, buunggawa, bawu-gara-wawalhijgang anu-dhawang, nurru numba-yabijgang,’ wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Yagu nigaayung wani-yambalmayn, ‘Ngaya ngana-magana nugurru yijgubulu-windiyung, ngaya nga-maḻaḻadi nugurru,’ ni-yamayn.” ");
INSERT INTO nuy_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Naagi-yung na-Jesus ni-yambini-wugij. “Yagu nugurru-waj ngirri-rangarrii, yagu yamba nugurru nurru-maḻaḻadi ngarraaḻirr anubani-yung ngaya ngandaagiyn, ngaya na-Niwiyayung na-Wurrujung-jinyung.” ");
INSERT INTO nuy_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Naagi-yung na-Jesus ni-yambini-wugij. “Warruburru-yung warru-mandag anaarrwar-yinyung wurru-yamana nguynju na-waḻyinyung-jii nubagi-yung ani-yanggi aynbaj-guy a-lhal. Niga wanii-gaḏiyn nigawi-nyinyung wunaa-mijgalmini-yinyung marri wani-magaa warruburru-yung, ambirri-rangarrangi anubani anaarrawindi-lhangu nigawi-nyinyung. ");
INSERT INTO nuy_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Niga nu-yayn naaynjaabu-nyung naa-mijgalmina-yinyung marang-aynjaabugij mana-big ana-gold, niga yamba ni-marrbuy-windiyung ni-mijgalmini-yinyung. Naaynbajung manuulawa mana-big marri naaynbajung aynjaabugij mana-big. ");
INSERT INTO nuy_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nubagi nima-waṉagaa-yinyung mana-marang-aynjaabugij mana-big ni-yanggi ni-nguḻu-nguḻubiyn niwu-waṉbini-yinyung anu-ṉuga, marri nima-mangi marang-aynjaabugij ngijang mana-big. ");
INSERT INTO nuy_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nubagi-yung nguynju-waj nima-waṉagaa-yinyung manuulawaa mana-big niwu-waṉbini anu-ṉuga, marri niwu-mangi wulawaa ngijang. ");
INSERT INTO nuy_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Yagu nubagi-yung nima-waṉagaa-yinyung manaaynjaabugij mana-big ni-yanggi marri ni-rigandi gara aaban-duj marri niwu-wurrdhangi na-runggal-yung-jinyung anu-ṉuga. ");
INSERT INTO nuy_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Wurrugu malanga-ngu-baḏag na-runggal-yung niigiyn anaanga-wuy, marri wani-yandhawiwayn wunaa-mijgalmini-yinyung anubani-yung wugurru wurru-waṉbini nigawi-nyinyung-mirri anu-ṉuga. ");
INSERT INTO nuy_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nubagi-yung nu-yayn-jinyung ana-marang-aynjaabugij mana-big-duj ana-gold, nimaagijgiyn marang-aynjaabugij ngijang mana-big nubagi-yung-guy na-runggal-yung-guy marri ni-yamayn, ‘Runggal-yung, nagang nimbaa-ngu-jambarrgiiyn ngaya, ngama-waṉagaa-yinyung mana-marang-aynjaabugij mana-big-duj ana-gold, yagu ngaya ngawu-waṉbini nugawi-nyinyung ana-gold, ngijang marang-aynjaabugij ngijang,’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nigaayung na-runggal-yung ni-yamayn ‘Nagang nunggaṉbini-yinyung maaḻamburrg, nagang nu-mamanunggu marri nu-ngu-jambarrg! Yagu yamba nagang numba-maṉmangi ana-wurraayung-jinyung, nagang baarra-narri ana-runggu-runggal-inyung anaarrawindi-lhangu. Baaṉiyn, na-ngu-ḏinggina ngayawi-rruj.’ Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Nguynju-waj nubagi-yung nu-yayn-jinyung manuulawa mana-big, ni-yanggi na-runggal-yung-guy marri ni-yamayn, ‘Runggal-yung, nagang nimba-ngu-jambarrgiiyn ngaya, ngama-waṉagaa-yinyung manuulawa mana-big, yagu ngaya ngawu-waṉbini ana-gold, muulawaa ngijang,’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nigaayung na-runggal-yung ni-yamayn, ‘Nagang nunggaṉbini-yinyung maaḻamburrg, nagang nu-mamanunggu marri nu-ngu-jambarrg! Yagu yamba nagang numba-maṉmangi ana-wurraayung-jinyung, nagang baarra-narri ana-runggu-runggal-inyung anaarrawindi-lhangu. Baaṉiyn, na-ngu-ḏinggina ngayawi-rruj.’ Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Nigaayung aḏaba nubagi-yung nu-yayn-jinyung manaaynjaabugij mana-big ni-yanggi na-runggal-yung-guy marri ni-yamayn, ‘Runggal-yung, ngaya nga-marrbuy anubani-yung nagang nuynjaal-aynjaabugij. Nagang baarra-muṉḏugana-yinyung anaarrawindi-lhangu nagang waari-yinyung baanuynjungaa. ");
INSERT INTO nuy_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yagu ngaya nga-ḏirrngawiiyn marri nga-yanggi marri nga-wurrdhangi nugawi-nyinyung anu-ṉuga aaban-duj. Yaami nugawi-nyinyung mana-big ana-gold.’ Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Nigaayung na-runggal-yung nu-magaa, ‘Nagang nundaaladi marri nuynjaal-ngawina! Nagang nu-marrbuy anubani-yung ngaya ngaarra-muṉḏugana-yinyung anaarrawindi-lhangu ngaya waari-yinyung ngangganuynjungaa. ");
INSERT INTO nuy_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Yagu a-yangi-yungguyung nagang waari bawu-burrangi ngayawi-nyinyung ana-gold ana-bank-duj, aḏaba ngaagiyn-maynji, ngaya nganggu-mangi ngayawi-nyinyung ana-gold marri ngijang.’ Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Yagu naagi-yung na-runggal-yung wani-magaa nigawi-nyinyung wunaa-mijgalmini-yinyung-guy, ‘Nimbirrima-yarrijgiyn mana-big nubagi-yung-gala, marri numbunuuyn naaynbajung-guy, nubagi-yung nima-waṉagana-yinyung 10 mana-big. ");
INSERT INTO nuy_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Anaani wiijamana, nugurru numburru-marrbuy-yinyung anaani, anubani-yung God nambaniiyii nugurru, nguynju yadhu anubani numburru-marrbuy-wina windiyung nugurru. Yagu nugurru waari-yinyung numburru-marrbuy-mang-jinyung aadanu, yagu nugurru nurraaḻamin-jamana nurru-marrbuy, yagu aadanu na-God aniwu-yarina niga nugurri-wala. ");
INSERT INTO nuy_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Numbunu-baruwudang naadagu naaladi-nyung arabarabalu-wuy, buguni waangudumana-wuy, anubagu warruburru-yung amburru-ruguna marri amburru-ra-bangaynjina amburraarragayii yamba wugurru.’ Dani-yung ni-yamayn niga na-runggal-yung.” Dani-yung ni-yambini na-Jesus, ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Naagi-yung na-Jesus ni-yambini-wugij. “Ngaya anaani na-Niwiyayung na-Wurrujung-jinyung, anubani-yung-maynji ngandaagiyn anuwaagala, wubani-rruj wu-milhiynjina-rruj, ngaya anaani nga-ngu-burraa anaarrwar, wubani-rruj wu-milhiynjina-rruj. ");
INSERT INTO nuy_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Warraarrawindi-lhangu warru-mandag ana-lhal-lhangu amburru-muṉḏugana raga-ragij ngayawi-rruj, marri ngaya ngambaaḻgaaḻgaḻwana wugurru, amburru-manda-bulawaa, nguynju yaga warruburru-yung wurru-rangarrii ana-jib, wurru-waḻgaḻwaa ana-jib anubani-yung-gala ana-naniguḏ. ");
INSERT INTO nuy_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","“Nguynju-waj, ngaya ngambaaḻgaaḻgaḻwana, marri warruburru-yung warra-mamanunggu-yinyung amburru-muṉḏugana ngayawi-nyinyung-gala walawalama-wala, wugurraayung warra-mulung-aynbaj mangaṉḏayayaagu-wala. ");
INSERT INTO nuy_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Marri ngaynjamana warra-wurru-wurruj-guy ana-walawalama-wala, ‘Numburraaṉiyn, ngayawi-nyinyung na-Baba naniigajij-majgana. Anu…bani-yunggaj niga niwu-lhal-maṉdhangi ana-lhal-lhangu, marri nanii-ganga-wandangi nugurraa yadhu. Nimbirri-waṉagana anubani ana-lhal. ");
INSERT INTO nuy_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ngaya yamba nga-marryaadangi, marri nugurru ngirri-yayn ngaya ana-marrya. Ngaya nga-wurrij-guldhangi marri nugurru ngirri-yayn ngaya anaa-gugu. Ngaya nga-lhalmarr, marri nugurru ngirri-yabijgayn ngaya nugurri-nyinyung-guy anga. ");
INSERT INTO nuy_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ngaya waari mana-yaaḻi marri nugurru ngirri-yayn ngaya. Ngaya nga-lhangurrngang marri nugurru ngirri-rangarrangi ngaya. Ngaya nga-dhidini marri nugurru ngirri-maṉmangi ngaya.’ Dani-yung ngaya ngaynjambina anaani. ");
INSERT INTO nuy_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Wugurraayung warra-mamanunggu-yinyung warra-wurru-wurruj ngambambi-yambalmang, ‘Runggal-yung, lhal-ngargu nurru ngunu-nani nu-marryaadangi marri ngunu-yayn nagang ana-marrya, yagu numburrij-guldhangi marri ngunu-yayn anaa-gugu? ");
INSERT INTO nuy_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Lhal-ngargu nurru ngunu-nani nundhalmarr marri ngunu-yabijgayn anaanga-wuy? Lhal-ngargu nurru ngunu-nani nagang waari mana-yaaḻi marri ngunu-yayn nagang nuynjabini? ");
INSERT INTO nuy_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Lhal-ngargu nurru ngunu-nani nagang nu-lhangurrngandi yagu nu-ngu-dhidini marri ngunu-maṉmangi nagang?’ Dani-yung amburru-yamana wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ngaayung ngaynjamang, ‘Ngaya ngana-magana nugurru yijgubulu-windiyung, anubani-yung nurru-waṉbini-yinyung ngayawi-nyinyung yadhu warra-wurru-wurruj, wiiya wugurru wurru-nunggarrbidi, aadaju nugurru nurru-waṉbini ngayawi-wuy.’ Dani-yung ngaynjamang. ");
INSERT INTO nuy_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Anubanila ngaya anaani Jesus ngaynjambina warruburru-yung-guy warraalaaladi-wuy, ngayawi-nyinyung-gala a-mangaṉḏayayaagu-wala, ‘Numburru-yaarri ngayawi-wala, nugurru yamba na-God nambani-jadugang! Numburru-yaarri a-ngura-wuy anubani-yung wu-nagina-rruj wuguuguni anubani-yung niwu-maṉdhangi na-God na-baḏirrnya-yung yungguyung marri nigawi-nyinyung anaarrawindi wu-mijgalmina-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ngaya yamba nga-marryaadangi yagu nugurru waari ngirriini ana-marrya. Ngaya nga-wurrij-guldhangi yagu nugurru waari ngirriini anaa-gugu. ");
INSERT INTO nuy_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ngaya nga-lhalmarr, yagu waari ngirri-yabijgaa nugurri-nyinyung-guy anaanga. Ngaya waari mana-yaaḻi yagu nugurru waari ngirriini mana-yaaḻi. Ngaya nga-lhangurrngang marri nga-dhidini, yagu nugurru waari ngirri-maṉmangi ngaya.’ Dani-yung ngaya ngaynjambina anaani ngandaagiyn-maynji. ");
INSERT INTO nuy_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Wugurraayung warruburru-yung warra-wurru-wurruj ngambambi-yambalmang, ‘Yagu lhal-ngargu nurru ngunu-nani nagang nu-marryaadangi yagu numburrij-guldhangi yagu nundhalmarr yagu waari mana-yaaḻi yagu nundhangurrngandi yagu nu-ngu-dhidini? Yuga lhal-ngargu nurru ngunu-nani yagu waari wa-maṉmangi nagang, yuga?’ Dani-yung amburru-yamana wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ngaayung ngaynjamang, ‘Ngaya ngana-magana yijgubulu-windiyung, anubani-yung nurru-lhaabiyn, waari nambarra-maṉmangi ngayawi-nyinyung warra-wurru-wurruj, wiiya wugurru wurru-nunggarrbidi, aadaju nugurru nurru-lhaabiyn ngaya anaani.’ Dani-yung ngaynjamang. ");
INSERT INTO nuy_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Nga warraawurru amburru-yaarri amburru-jadugiiyn anggu-wuguuguni, yagu wugurraayung warra-mamanunggu-yinyung warra-wurru-wurruj anaani amburru-yaarri amburru-burraa anggu-wuguuguni.” Dani-yung ni-yambini na-Jesus, na-nidhaawu-yung niga. ");
INSERT INTO nuy_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Wurrugu na-Jesus niwu-jadugayn ni-yambini-yinyung anaarrawindi-lhangu anaani. Niga wani-magaa nigawi-nyinyung wurru-marrbuy-maa-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nugurru nurru-marrbuy anubani-yung amuulawaa-wala mana-miyn.nganga, wu-rangga-ḻaabini-yinyung ana-miyn.ngu, ngarrubagi-rruj ngarraaḻirr ngaya-waj na-Niwiyayung na-Wurrujung-jinyung, warruburru-yung ngambambi-mang ngaya, marri ngambambi-marang-barra-rayii wuḏangag-guy marri nga-ngawina,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nga wurru-ragaani-yinyung warra-priest marri warra-Jew-yinyung wurru-ragaani-yinyung wurru-yambiynjini wurru-muṉḏugaa anaanga-rruj na-runggal-yung-jinyung na-priest-jung, na-nimuwaj-jung Caiaphas. ");
INSERT INTO nuy_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Anubani-rruj wurru-yambiynjini-rruj, wugurru wurru-wijangani ambunu-mangi yadhu na-Jesus midaarrgaj, ambunu-ngawijgaa niga. ");
INSERT INTO nuy_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Yagu wugurru wurru-yamayn, “Ngagurru yagi anaani ngurru-waṉbi anubani-rruj ngurru-mijgalmina-rruj, warruburru-rruj warraarrawindi-rruj, yagu wu-ngarrgi-magi ana-wungarri runggal-windiyung,” wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nigaayung na-Jesus bagu ni-burri Bethany wubani a-wumurrng-duj na-Simon-duj. Anubani-yunggaj naagi-yung ni-warra-guṉḏa-guṉḏa. ");
INSERT INTO nuy_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nga maṉinyung buguni ngi-yanggi. Ngima-waṉagaa manaama-yung mana-gaṉdharra ma-mamanunggu. Anubani-yung ma-lhaguḻaarramangi manaama-yung malagaj, wu-burri bagu arrawuj-mamaaḻang. Ngiga ngi-warwarryangi anaani na-Jesus-guy na-nijinag-jung-guy, bagu ni-nguni-rruj ana-marrya. ");
INSERT INTO nuy_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nigawi-nyinyung wurru-marrbuy-maa-yinyung wurru-riyaldhiyn, wurru-yamayn, “A-yangi yungguyung anubani-yung ngiwu-lhaladangi anubani-yung anaarrawuj-mamaaḻang? ");
INSERT INTO nuy_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Anubani-yung-magaa ngaambini warruburru-wuy, marri ngambambiini ana-runggal anu-ṉuga, nguynju yungguyung ngambiini warruburru-wuy warraambalalari-wuy,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nigaayung na-Jesus ni-marrbuy, marri ni-yamayn, “A-yangi yungguyung aadanu nugurru nirringa-wurrij-galadi-wana ngarraagi ngarra-maṉinyung? Ngaadagu ngi-waṉbina yij-mamaaḻang ngayawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Warruburru-yung warraambalalari, warruburru-yung anggu-wuguuguni amburru-burraa nugurri-rruj. Yagu ngaayung yagi nga-burrangi anaaji nugurri-rruj, ana-baḏag. ");
INSERT INTO nuy_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Anaani aḏaba wiij-barubaj-mana nga-ngawang-jinyung marri ngambambi-wurrdhii-yinyung. Wudani-yung-gala nga, ngarra-maṉinyung ngiwu-burrangi ana-malagaj ngayawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Anaani ngana-magana yijgubulu, warra-mulung-aynbaj-maynji warrubawi-yung ambarra-magana ana-lhaawu na-God-jinyung ana-lhal-aynbaj-gala ana-lhal, anubani-yung ambirriij-burryuwina wubani-yung ngi-waṉbini-yinyung, ngaadagi-yung ngarra-maṉinyung. Marri amburraawanggina ngigawi-nyinyung.” Dani-yung ni-yamayn na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Anubanila-wala aḏaba nubagi na-Judas Iscariot bagu wurraanggarra-ngu-burri, warra-12. Naagi-yung ni-yanggi wani-yambini wurru-ragaani-yinyung warra-priest. ");
INSERT INTO nuy_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Naagi-yung niga ni-yamayn, “Yangi nugurru ngirriiyn ngaya anambiiyn-maynji na-Jesus nugurri-wuy?” ni-yamayn. Wugurraayung wunu-yayn niga runggal wugarra, anu-ṉuga 30 ana-silver. ");
INSERT INTO nuy_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ni-burri wurrugu, niwu-rangarrangi lhal-ngargu ari anaa-dhaawu-rarrjangi, nguynju yungguyung ambunu-bilhargang niga. ");
INSERT INTO nuy_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ngarrubagi-rruj ana-wulhu-wulhurr ngarraaḻirr wurru-mijgalmini-rruj, ngarraagi-rruj ngarraaḻirr ngi-mayini “waari anggu-wuḻbuḻwandi anu-ḏayn”, warruburru-yung wurru-marrbuy-maa-yinyung wurru-yamayn, “Yuga aniga-wuy nimba-ngaynbandiyn naambu-warraalgaalgurmani ana-marrya, ngaambu-nguyii yadhu?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nigaayung na-Jesus wani-magaa nubiṉi-wuy wini-wulawaa, “Nimbini-yaarri buguni a-runggal-wuy a-wumurrng, nubagi-yung-guy na-waḻyinyung-guy, marri numbunu-magana niga, nimbini-yamang, nubagi-yung wani-yiyina-yinyung ni-yamana, ngarrubagi-yung ngarraaḻirr ngayawi-nyinyung wiij-barubaj-mana. Ngaya nga-mijgalmina anubani-yung wu-rangga-ḻaabini-yinyung, marri ngayawi-nyinyung wurru-marrbuy-mana-yinyung, nugawi-nyinyung-duj anaanga.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wuguṉiiyung wini-waṉbini, wini-warraalgaalgurmangi wurru-mijgalmini-yinyung wu-rangga-ḻaabini-yinyung ana-marrya. ");
INSERT INTO nuy_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Anubani-yung waadhaadharrwara-maa, na-Jesus marri warruburru-yung warra-12, wurru-yanggi buguni. ");
INSERT INTO nuy_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Marri anubagu wurru-burri wurru-ngunu-nguni-rruj, marri bagu ana-marrya wurru-nguni. Marri na-Jesus ni-yamayn, “Ngana-magana anaani aniijgubulu. Aynjaabu-nyung nugurri-rruj, ngambani-minbumana ngaya.” Dani-yung ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Anubani-yung wurru-yimurrjiwurangi wugurru. Warruburru-yung warraaynjaaynjaabugij warraawurru-yung wunu-yandhawiwandi na-Jesus, “Ngaya waari, yuga?” ");
INSERT INTO nuy_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Na-Jesus nigaayung ni-yamayn, “Aynjaabu-nyung daju nugurri-wala, dagu yaga ni-lhalwulhii marrya dagu aynjaabu-nyung ngirrima-lhagaṉmayn amaami ama-gaṉdharra, ngambani-minbumana ngaya. ");
INSERT INTO nuy_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Wiijamana, ngaya-waj na-Niwiyayung na-Wurrujung-jinyung, anubani-yung anggu-waṉbina ngayawi-wuy, wubani a-wubiba-yinyung wu-magina. Yagu nubagi-yung-maynji ngaya ngambani-minbumana, ari ani-warragayii runggal-windiyung. Niga-magaa waari aniimbuḻwini, anubani-yung ni-maṉdhini.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nigaayung aḏaba na-Judas, nubagi nu-minbang-jinyung, niga ni-yamayn na-Jesus-guy, “Barra-yiyina-yinyung, yijgubulu ngaya anaani waari,” ni-yamayn. Nigaayung na-Jesus ni-yamayn, “Yii, nugawaj nga,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Anubani-yung wurru-nguni-wugij bagu, na-Jesus ni-miyn anu-ḏayn, marri ni-yambini na-God-guy, marri ni-rayn-bagiwayn aḏaba. Niga waniini, nigawi-nyinyung-guy wurru-marrbuy-maa-wuy. Marri ni-yamayn, “Numburru-mani anaani anu-ḏayn marri numburru-nguyii. Anaani ngayawi-nyinyung a-ngun.gu, wu-yamana,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Aḏaba nima-miyn gaṉdharra, wubani wugargayag wu-burri. Marri ni-yambini na-God-guy marri waniini. Niga ni-yamayn, “Nugurru numburru-waḻ-nguyii anaani. ");
INSERT INTO nuy_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Anaani nguynju ngayawi-nyinyung ama-wulang, wu-yamana. Ngamaadbarrwumana ngaya nugurraa yungguyung warraarraarrawindi yungguyung. Anaani wiijamana, na-God nani-lhalamayana nugurri-wuy, marri naniigajij-garruna nugurri-nyinyung anaaladi. ");
INSERT INTO nuy_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ngaya ngana-magana nugurru anaani, yagi ngaya ngaaḻ-ngi anubanila anu-gargayag ana-wuyarrangaḻ-wala. Wurrugu marri, bagu ana-lhal na-Baba-yinyung, bagu marri nganggaḻ-nguyii ngijang nugurri-rruj, anggiij-gadhuwa-wiiyn.” Dani-yung ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Warraawurru-yung wirri-rawaa bagu, marri wurru-yanggi yuuguni, wuu-ngarra-ḏaba-rabaliyn. Yuuguni wurru-yanggi amubama-wuy ama-ṉuga ma-ḻandhirrngindi-wuy Mount of Olives-guy. ");
INSERT INTO nuy_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Wurru-yanggi… nga aḻagaḻa aḏaba. Naagi-yung na-Jesus wani-magayn, “Anaani ana-miyn.ngu, nugurru aadanu aḏaba numburru-man-jarramang marri ngirriirruyn ngaya, wu-yamana yamba anaani-rruj ana-wubiba, ‘Nubagi-yung yaga ni-ranga-rangarrii-yinyung wubani-wuy a-jib, wugurru ambunu-wiyn, marri anubani ana-jib anggu-man-jarramang,’ wu-yamana anaani ana-wubiba. ");
INSERT INTO nuy_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yagu wurrugu ngaya nga-ḻaḻagiiyn ana-ngawij-gala. Marri anubani-yung ngaynjaarri buguni Galilee-wuy, marri nugurru aadanu ngirri-ga-garri-yurii anubuguni.” Dani-yung ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nigaayung na-Peter nu-yambalmayn, “Warraawurru warra-mulung-arrgi-yung-maynji amburru-man-jarramang ambiirruyn nugawi-wala, yagu ngaya anaani yagi,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nigaayung na-Jesus nu-yamijgayn, “Ngunu-magana anaani yijgubulu. Manaama-rruj mana-miyn.nganga, marri aadanu ba-yambina, ‘Naadagu ngaya nga-maḻaḻadi niga na-Jesus,’ ba-yamang, anubani-yung ba-yambina anggu-mal-bulaynbaj. Wurrugu ngarrubagi-yung ngarra-baawul angiiḏang-maynji.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Yagu nigaayung na-Peter ni-yamayn, “Yagi anubani-yung nga-yambi! Waari nga-maḻaḻadi-wi nagang! Ngaya nga-ngawiiyn nugawi-rruj!” ni-yamaa. Yagu warruburru-yung warra-mulung-arrgi-yung wugurraayung wurru-yamaa, wiij-nguynju anaani-yung ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Wurru-yangga-yanggi… nga wurru-waliyn aḏaba, wubani a-lhal Gethsemane. Marri wani-yamijgayn bagu, “Numburru-burraa yaaji, wurrugu ngaya ngaynjaarri yuuguni marri ngaynjambina na-God-guy,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Wugurru wani-miyn na-Peter, marri wini-wulawaa na-niwiyayung-biiyung na-Zebedee-yinyung nigawi-rruj. Marri niga ni-wurrij-galadi-wiiyn marri ni-yimurr-jiwurangi. ");
INSERT INTO nuy_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Niga ni-yamayn, “Ngaya anaani nga-wurrij-galadi-wiiyn-bindiyung, ari nga-ngawang, nga-wurrij-galadi-wiiyn yamba. Nugurru aadanu yaaji numburru-burraa marri numburru-wanggirraa, ngirrii-garranggana ngaya,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Anubani-yung ni-jarrarriyn yuuguni windiyung. Marri bagu ni-rabini aaban-guy marri ni-yambini. “Baba, anaani-maynji anggiij-maṉdhina, bawu-yarina ana-wungarri ngayawi-wala, nguynju yagi ngaarragayi yadhu. Yagu nugaajbaj ba-waṉbina nunggijangayii-yinyung, waari anubani-yung ngaya ngawu-ngaynbandii-yinyung,” ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Aḏaba ni-yanggi niigiyn warruburru-wuy warra-wulu-wulaynbaj-guy, wani-rangga-lhangarrmayn wugurru wu-lhagarra-yingayn. Niga ni-yamayn na-Peter-wuy, “Nugurru waari ngirrii-banggirri ngarraaynjaabugij-duj ngi-dhawawarumini-yinyung ngarraaḻirr? ");
INSERT INTO nuy_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Numburru-wanggirraa, marri numbunu-yambina na-God-guy, a-lhuḏ yungguyung nambaniiyn, nguynju anubani anaaladi yagi nanggu-rawu anaangaḏajung. Yijgubulu aadanu ana-wiri wu-waḏa-waḏaḏ nugurri-nyinyung, yagu nugurri-nyinyung ana-ngun.gu wu-bilwilwiluj.” Dani-yung ni-yamaa naagi-yung. ");
INSERT INTO nuy_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Aḏaba niga niigiyn, ni-yambini, “Ngayawi-nyinyung Baba, yagi-maynji nunggu-yari ana-wungarri ngayawi-wala, marri ngaya-maynji nganggarragayii, nagang ba-waṉbina nunggijangayii-yinyung aadanu,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Aḏaba niga ni-yanggi niigiyn ngijang, marri ngijang niga wani-lhangarrmayn wugurru wurru-lhagarra-yingayn, warruburru yamba wurru-yaal-ngawiiyn-bindiyung. ");
INSERT INTO nuy_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yagu na-Jesus waniirruyn wugurru marri ni-yanggi ni-yambini na-God-guy mal-bulaynbaj-gala, ni-yambini wiij-nguynju-yinyung anubani-yung. ");
INSERT INTO nuy_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Aḏaba na-Jesus ni-yanggi niigiyn nigawi-nyinyung-guy wurru-marrbuy-maa-wuy marri ni-yamayn, “Yagu nugurru nuu-lhagarra-yara-wugij marri nurru-yanga-yangina? Numburraarranggang, anaani aḏaba wiij-barubaj-mana. Nubagi nganii-dhaawu-yarrijgini nubagi warruburru-wuy warraalaaladi-wuy, marri ngambambi-bilhargang, ngaya na-Niwiyayung na-Wurrujung-jinyung. ");
INSERT INTO nuy_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Numburru-ḻaḻagiiyn. Aḏaba ngagurru ngurru-yaarri. Yaagila ni-yaarri ngani-minbini-yinyung ngaya.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Wurrugu anaani-yung ni-yambini-wugij, nigaayung nubagi-yung na-Judas, warruburru-yung-jinyung warra-12, ni-yanggi buguni nigawi-wuy, marri warruburru-yung garnyirrimba. Warraawurru-yung wirri-warra-waṉagaa galiwanga marri rangag. Marri bagala wurru-yanggi warruburru-yung-gala warra-runggu-runggal warra-priest, marri warra-mijiwanggu warra-wurru-wurruj-jinyung wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ana-wulhu-wulhurr-waj, na-Judas anaani-yung wani-magaa, “Wurrugu nganu-lhawuynjang naadagu na-waḻyinyung. Bagi-yung nga. Numbunu-bilhargang niga,” anubani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Anubani-yung aḏaba na-Judas ni-yanggi andhurrg na-Jesus-guy. Ni-yamayn, “Nuynjaminggarrina, barra-yiyina-yinyung!” marri nu-lhaawuynjayn niga. ");
INSERT INTO nuy_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nigaayung na-Jesus ni-yamayn, “Guwaj, ba-waṉbina anubani-yung nagang numbaaṉiyn-jinyung ba-waṉbina-yinyung,” ni-yamayn. Aḏaba warraawurru-yung wurru-yanggi, wunu-bilhargayn niga. ");
INSERT INTO nuy_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Anubani-yung aḏaba naaynjaabu-nyung na-Jesus-inyung winiinggarra-yanggi-yinyung, niga niwu-waṉagaa galiwanga. Niwu-ngarrgiwaa niga, ana-galiwanga, nga naagi-yung ni-jarrarriyn nubagi-wuy na-waḻyinyung-guy naa-mijgalmini-yinyung na-runggal-yung na-priest-jung. Niga ni-jarrarriyn-bugij, marri dhiḏ! Nu-lhiyn! Naa-guldhiyn manubama-yung mana-warang. ");
INSERT INTO nuy_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Na-Jesus ni-yamayn na-waḻyinyung-guy, “Bawu-burrang nugawi-nyinyung ana-galiwanga, bawaagijgiyn. Warraarrawindi-lhangu warruburru-yung wirri-waṉagana-yinyung ana-galiwanga amburru-ngawina ana-galiwanga-mirri. ");
INSERT INTO nuy_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ari nagang nu-maḻaḻadi, ngaya nganu-yandhawiwana na-Baba marri niga ngambaniiyn ngaya ngijang arrawindi-windiyung wu-wiynji-wiynjina-yinyung ana-angel. ");
INSERT INTO nuy_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yagu ngaya yagi nganu-yandhawiwu, yagu yamba anubani ana-wubiba wu-yamana, ngaya nga-ngawang anaani.” ");
INSERT INTO nuy_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Anubani-yung na-Jesus wani-magaa warra-garnyirrimba-wuy, “Yuga nugurru aadanu nurru-yanggi galiwanga nirri-warra-waṉagana? Yuga majirrijirri nirrima-waṉagana, ngirri-bilhargaa yungguyung? Yuga ngaya anaani ngaandha-wungarri yamba? Ngarraaḻirr-lhangu ngaya nga-burri ana-Temple-Maṉngulg-duj marri bagu nga-yambini, yagu nugurru waari ngirri-bilhargaa ngaya anubagu. ");
INSERT INTO nuy_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Yagu anaarrawindi-lhangu anaani wu-waṉbini nguynju yadhu anubani-yung ana-lhaawu warruburru-yung-jinyung wunaa-ja-jambini-yinyung na-God anu…bani-yunggaj, anubani-yung anggu-wandhurrg-mana.” Dani-yung ni-yamayn. Aḏaba na-Jesus-inyung wurru-marrbuy-maa-yinyung wunaarruyn niga marri wurru-man-jarramayn wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Warruburru-yung wunu-miyn na-Jesus, wunu-yarrijgini niga aanga-wuy na-Caiaphas-guy na-runggal-yung-guy na-priest, warruburru-yung warra-yiyini-yinyung ana-lhaawu marri warra-mijiwanggu wurru-muṉḏugaa-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nigaayung na-Peter nu-garrindharrmangi na-Jesus, yuwaagala yagu adhaa…dharri ni-yangga-yanggi. Ni-yanggi buguni wubani-wuy a-wumurrng-guy nubagi-yung-jinyung na-runggal-yung na-priest. Anubani-yung ni-yanggi nga buguni ni-yabiyn. Niga ni-burrangayn warruburru-rruj wurru-mijgalmini-yinyung, aniwu-nani anggu-waṉbini yungguyung. ");
INSERT INTO nuy_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Wugurraayung warra-runggu-runggal warra-priest marri warruburru-yung wuu-yamba-yambini-yinyung, wirriij-ḏaguni yijanggaḻij lhaawu na-Jesus-inyung, ana-raga-ragij-jinyung, nguynju yungguyung naagi ambunu-ngawijgaa yungguyung. ");
INSERT INTO nuy_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Yagu waari anubani-yung ambirri-lhangarrmaa ana-lhaawu. Arraarrawindi warra-wurru-wurruj wurru-waṉiyn marri warra-magaa yijanggaḻij ana-lhaawu anubani-yung nigawi-nyinyung. Aḏaba wini-wulawaa waḻya-waa wini-waṉiyn marri wini-yamayn, ");
INSERT INTO nuy_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Naagi na-waḻyinyung ni-yamayn, ‘Ngaya anaani nganggu-jadugang ana-Temple-Maṉngulg na-God-jinyung marri nganggu-rayii ngijang amuulawaa-wala mana-miyn.nganga.’” Dani-yung wini-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nigaayung nubagi-yung na-runggal-yung ni-lhangayn marri ni-yamayn na-Jesus-guy, “Yuga nagang numba-yambalmang? Anaani yuga ana-lhaawu wu-yaminggarrina, wini-yambiynjina nugawi-nyinyung?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yagu nigaayung na-Jesus naagi-yung waari ani-yambini. Nigaayung na-runggal-yung ni-yamayn, “Ngaya ngunu-magana ana-muwaj na-God na-wiri-nyung, numba-magana nurru, yuga nagang na-Christ, na-Niwiyayung na-God-jinyung?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Na-Jesus nu-yambalmayn, “Aadanu nugawi-nyinyung ana-lhaawu. Yagu ngaya ngana-magana nugurru, anaani anggu-waṉbina, nugurru aadanu ngirri-nayii ngaya, (Daniel 7:13) ‘na-Niwiyayung na-Wurrujung-jinyung, ngaya nga-ngu-burraa walawalama nubagi-yung niwu-waṉagana-yinyung ana-lhuḏ. Marri nga-ngu-dhirridang anubani-yung ngubunung-mirri a-wumala-wala,’ ” Dani-yung ni-yamaa niga. ");
INSERT INTO nuy_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nigaayung nubagi-yung na-runggal-yung nigawi-nyinyung nimaarra-ḻaḻaani mana-yaaḻi, marri ni-yamayn, “Naagi-yung naaladi-yamawaa na-God! Ngagurru waari ngaamba-ngaynbandang warraaynbaj, ngarrambi-magi ana-lhaawu naagi-yinyung. Naagi-yung naaladi-yamawaa na-God! ");
INSERT INTO nuy_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yangi yuga nugurru nurru-wijangayii aadanu aḏaba?” ni-yamayn. Wugurraayung wurru-yamayn, “Ani-ngawang,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Anubanila, mulung-aynbaj wunu-yudangi na-Jesus nani-jilhal-yung, marri wunu-warra-waḏjiwini. Warra-mulung-arrgi-yung wunu-wini niga. ");
INSERT INTO nuy_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Wugurru wurru-yamayn, “Nagang Christ, ba-yambina lhaawu na-God-gala aḏaba! Numba-magang nurru, yangi-nyung nimbi-wang nagang!” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nigaayung nubagi-yung na-Peter bagu ni-burri aarabarabalu-rruj. Ngarrubagi-yung ngi-mijgalmini-yinyung ngarra-ngaḻaynjinyung buguni ngi-yanggi. Ngi-yamayn, “Nagang aadanu niiniinggaanggarra-yanggi-yinyung naagi na-waḻyinyung na-Jesus wubanila a-Galilee-wala,” ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Yagu na-Peter ni-yamayn warraarrawindi-wuy warra-wurru-wurruj “Ngaya waari nga-marrbuy-magaa, aadanu nuynjambina-yinyung anubani-yung,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Aḏaba niga ni-yanggi a-wu-dhawang-guy. Aynbajung ngaḻaynjinyung ngunu-nayn niga. Ngiga ngi-yamayn warra-wurru-wurruj-guy bagu, “Naagi na-waḻyinyung winiinggaanggarra-yanggi-yinyung na-Jesus a-Nazareth-jinyung,” ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nigaayung na-Peter ngijang ni-yamayn, “Anaani nganggawaḻii-maynji, na-God ngambani-jadugang ngaya! Naadagu na-waḻyinyung, nga-maḻaḻadi niga!” ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Wiij-dhamun.gurrg-maa wurrugu, mulung-arrgi-yung wurru-wurruj wurraarra-garra-lhi bagu, wurru-yanggi na-Peter-wuy marri wurru-yamayn, “Yijgubulu nagang aadanu niiniinggaanggarra-yanggi-yinyung. Anubani-yung nagang nuynjambina-yinyung nguynju warra-Galilee-yii,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nigaayung aḏaba ni-yamayn, “Anaani nganggawaḻii-maynji, na-God ngambani-jadugang ngaya! Naadagu na-waḻyinyung, nga-maḻaḻadi niga!” ni-yamaa. Anubani-yung ngarra-baawul ngiiḏiyn aḏaba. ");
INSERT INTO nuy_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nigaayung na-Peter bani-yung ni-wijangang anubani-yung na-Jesus niga nu-magaa-yinyung niga, “Aadanu ba-yamana nu-maḻaḻadi ngaya, ba-yambina anggu-mal-bulaynbaj. Wurrugu ngarrubagi-yung ngarra-baawul angiiḏang-maynji.” Aḏaba na-Peter ni-yanggi arabarabalu-wuy marri ni-ruguni-windiyung niga. ");
INSERT INTO nuy_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Anubanila ngi-ḻambalangi. Warruburru warra-runggu-runggal warra-priest marri warra-mijiwanggu wugurru wurraaḻamin-jamijgini anubani-yung na-Jesus ani-ngawiiyn. ");
INSERT INTO nuy_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Wugurru wunu-radbini aḏaba niga, wunu-yarrijgini niga marri wunu-burriyn bagu na-Pontius Pilate-duj na-runggal-yung ana-Rome-jinyung. ");
INSERT INTO nuy_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Na-Judas nubagi-yung nu-minbang-jinyung, niga wani-nani wugurru anubani-yung aḏaba wunu-lhajbini na-Jesus, aḏaba naagi-yung ni-wij-barrngayuyn, anubani-yung niga ni-waṉbini-yinyung, yagu niga niwu-miyn 30 ana-silver, niwaagijgiyn warruburru-wuy warra-priest-guy marri warra-mijiwanggu-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Niga wani-magayn waadurru-yung, “Ngaya yamba ngaaladi, ngaya ngana-yayn nugurri-wuy, niga waari-yinyung anubani-yung ani-waṉbini-yinyung anaaladi,” ni-yamayn. Wugurraayung wurru-yamayn, “Anubani-yung nugawi-nyinyung-bugij, waari-magaa nurri-nyinyung.” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yagu nigaayung aḏaba na-Judas niwu-barawudiyn anubani-yung ana-silver buguni a-Temple-Maṉngulg-guy. Aḏaba niga ni-yanggi marri ni-waḻa-ḏadbini nigaaj-baj, ni-ngawiiyn aḏaba. ");
INSERT INTO nuy_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Wugurraayung waa-runggu-runggal warra-priest wirri-miyn anu-ṉuga, wurru-yamayn, “Anaani anu-ṉuga ama-wulang-jinyung, wugurru yamba ngarranggu-bayarra-gaa, nguynju yadhu nubagi na-waḻyinyung ani-ngawang niga. Anaani ana-lhaawu-runggal ngarranggu-magana, waari ngaanggu-burrangi anu-ṉuga ana-Temple-Maṉngulg-duj.” Dani-yung yigaj wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Yagu wugurru wurru-wijangani, amburru-bayandhangi yadhu anaabaḻa, nubagi-yung-gala na-waḻyinyung-gala nimaarra-maṉdhangi aynba-gaynbaj-jinyung mana-gaṉdharra, nguynju yadhu amburru-wurrdhini-yinyung waa-nunggajigala-yinyung warruburru-yung wurru-ngawini-yinyung ana-Jerusalem-duj. ");
INSERT INTO nuy_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","10","Yagu anubani-yung na-Jeremiah nubagi naa-ja-jambini-yinyung na-God, ni-yambini, anu…bani-yunggaj, (Jeremiah 32:6-15, Zechariah 11:12-13) “Wirri-miyn 30 ana-silver, anubani-yung wu-yamaa-yinyung warra-Israel-inyung, wugurru wurru-wijangani na-wurrujung-jinyung anubani-yung. Wugurru wurru-bayandhangi anaabaḻa nubagila-wala nimaarra-maṉdhangi aynba-gaynbaj-jinyung mana-gaṉdharra, nguynju-waj na-Buunggawa ngani-magaa ngaya.” Dani-yung nga ni-yambini na-Jeremiah. Anubani-yung yigaj anubani-yung anaabaḻa wu-mayini “Abaḻa Ama-wulang-jinyung” anaani ana-yimbaj. ");
INSERT INTO nuy_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Anubanila-wala aḏaba, niga na-Jesus ni-lhaay nubagi-yung-duj na-Pilate na-runggal-yung-duj, marri naagi-yung na-Pilate nigaayung ni-yamayn, “Nugawaj yuga na-Runggal-yung warra-Jew-yinyung?” ni-yamayn. Na-Jesus nigaayung yaani-yung ni-yamayn “Anaani nugawi-nyinyung ana-lhaawu,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Wugurraayung aḏaba warruburru-yung waa-runggu-runggal warra-priest marri warra-mijiwanggu, wunu-lhajbini na-Jesus. Yagu nigaayung waari ani-yambini. ");
INSERT INTO nuy_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Yagu nigaayung na-Pilate yaani-yung ni-yamayn na-Jesus-guy, “Yuga nagang anubani-yung barra-yaynjangani warruburru-yung wugurru nimbi-lhajbini nagang anaarrawindi-lhangu?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yagu na-Jesus anubani-yung waari anu-yambalmaa na-Pilate. Marri niga na-Pilate ni-walharaguni-windiyung niga. ");
INSERT INTO nuy_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Manubama-yung-duj manaarmag wu-rangga-ḻaabini-yinyung, nubagi na-runggal-yung na-Pilate ni-yamaa-wugij, nu-waḻamin-dharrgang naaynjaabu-nyung wunu-radbini-yinyung, warruburru-yung-jinyung warra-wurru-wurruj wugurru wurru-wajbarini-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Anubani-yung bagu waḻyinyung ni-burri wuu-dhidini-rruj na-nimuwaj-jung nubagi-yung Barabbas, niga niiladi-windiyung. ");
INSERT INTO nuy_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Aḏaba warruburru-yung warra-priest wurru-muṉḏugaa na-Pilate-duj aanga, nga nigaayung na-Pilate ni-yamayn, “Yuga nugurru ngirri-ngaynbandiyn ngaya nganu-waḻamin-dharrgang yuga na-Barabbas yagu na-Jesus, nubagi-yung ni-mayina-yinyung na-Christ?” ");
INSERT INTO nuy_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Dani-yung nga ni-yamayn na-Pilate, ni-marrbuy yamba anubani-yung wunu-yayn na-Jesus nigawi-wuy warraawurru-yung wunu-margiriyn yamba nigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Anubani-yung na-Pilate ni-burri bagu wani-nguynju-nguynjijgaa-yinyung-duj. Nga ngigaayung nigawi-nyinyung nga-rangarrina-yung anubani-yung ngiwu-lharrgang lhaawu nigawi-wuy. “Yagi ngunu-waṉagi naadagu na-waḻyinyung na-mamanunggu-yung. Ana-yimbaj ngaya nga-wuryarrangi anubani-yung nigawi-nyinyung marri wungarri wu-waṉiyn ngayawi-wuy angaḏajung-bindiyung.” Dani-yung ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Yagu warruburru-yung waa-runggu-runggal-inyung warra-priest marri warra-mijiwanggu, warraadhangu-jujurangi warruburru-yung warru-mandag, wunu-yandhawiwaa wugurru na-Barabbas-inyung anu-lharrgandi marri na-Jesus anu-ngawijgaa. ");
INSERT INTO nuy_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nigaayung na-Pilate ni-yamayn, “Ngaya ngarra-waṉagana Barabbas marri Jesus, yangi-nyung nugurru ngirri-ngaynbandii ngaya ngambaḻamin-dharrgang nugurri-wuy?” ni-yamayn dani-yung. Wugurraayung warra-wurru-wurruj wurru-yamayn, “Barabbas”. ");
INSERT INTO nuy_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nigaayung na-Pilate ni-yamayn, “Yagu ngaynjaminggarrina nganggaṉbina na-Jesus-guy, nubagi-yung ni-mayina na-Christ?” Wugurraayung wurru-yamayn “Ani-ngawang-bugij niga!” ");
INSERT INTO nuy_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Yagu nigaayung na-Pilate ni-yamayn, “A-yangi-yungguyung? Waari anaaladi niga ani-waṉbini!” ni-yamayn. Yagu wugurraayung wurraaḏangi-wugij, “Ani-ngawang-bugij niga!” wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nigaayung aḏaba na-Pilate ni-yamijgini, “Ngaya-maynji anu-lharrgang, ari amburru-lhagararriynjina, wungarri anggu-waṉiyn,” ni-yamayn. Nga niga niwu-miyn guugu marri ni-marang-jarrbini nigawi-nyinyung ana-marang raga-ragij warru-mandag wurru-muṉḏugaa-rruj. Aḏaba niga ni-yamayn, “Ngaya anaani waari nganaa-dhangarrmaa anaaladi naagi na-waḻyinyung ani-ngawang-jinyung. Nugurru yagi ngirri-lhajbu ngaya, ani-ngawang-jinyung niga. Nugurru-waj anubani-yung numburru-waṉbina.” Dani-yung nga ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Wugurraayung warraarrawindi warra-wurru-wurruj wurru-yamayn, “Nurru anaani marri nurri-nyinyung warra-mijburrayung naanggu-waṉagana nigawi-nyinyung ani-ngawiiyn-jinyung.” Dani-yung wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Aḏaba niga na-Pilate nu-lharrgang na-Barabbas ni-warrgarrga yagu na-Jesus wani-yayn warruburru-wuy wurru-wiynji-wiynjini-wuy, “Numbunaarra-waḏjiwumana marri numbunu-yarrijgiyn aḏaba, bagu numbunu-marang-barra-rayii aḏaba, a-rangag-duj.” Dani-yung nga ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Marri nigawi-nyinyung na-Pilate-jinyung warruburru-yung wurru-wiynji-wiynjini-yinyung wunu-yarrijgini na-Jesus buguni wubani-wuy na-Pilate-jinyung a-wumurrng-guy. Marri warruburru-yung warra-muṉḏugijgayn warraarrawindi wurru-wiynji-wiynjini-yinyung buguni. ");
INSERT INTO nuy_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wugurru wirrima-miyn manubama-yung nigawi-nyinyung mana-yaaḻi, na-Jesus-gala, nga wunu-yabijgaa mamanunggu yaaḻi. Nguynju yaga warruburru-yii waa-runggu-runggal-yii ni-yabini ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Anubani-yung wirri-miyn rawurrumugurrumu, marri wirri-dhawawarumaa, marri anubani-yung wunaambaḻ-yadiyn niga. Marri wirri-burriyn anubani ana-rangag nigawi-nyinyung-duj a-marang. Aḏaba warraawurru-yung wurru-burrdi raga-ragij na-Jesus-duj marri aḏaba wunu-gaḻijgaa niga wurru-yamaa, “Ngunu-warraarriwana! Runggal-yung warra-Jew-yinyung!” wurru-yamaa dani-yung nga. ");
INSERT INTO nuy_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wugurru wunu-yudangi na-Jesus aḏaba wugurru wunaa-mangi ana-rangag marri wunu-wini niga a-yinag-duj. ");
INSERT INTO nuy_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Wunu-rajburrnani. Anubanila-wala, manubami-yung wunaa-ngarrgiwayn mana-yaaḻi marri ngijang wunu-yabijgayn manubama-yung mana-yaaḻi, wunaa-gaagijgiyn. Anubanila-wala aḏaba, wugurru wunu-yarrijgini ambunu-ngawijgaa yadhu niga. ");
INSERT INTO nuy_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Warraawurru-yung wurru-yanggi anubanila-wala ana-lhal Jerusalem-gala. Yagu nubagi-yung waḻyinyung wunu-lhangarrmayn, na-nimuwaj-jung niga Simon, wubani-yinyung a-lhal a-Cyrene-yinyung. Yagu wurru-yamayn, “Bawu-warrgurrang anaani ana-rangag naadagu-yinyung.” ");
INSERT INTO nuy_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Aḏaba naagi-yung na-Jesus wunu-yarrijgini wubani-wuy a-lhal-wuy, anu-muwaj wu-mayini Golgotha. Wiijamana wugurru anaani, ana-lhal a-ngagara-yii ana-yinag, wu-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Anubani-yung warruburru-yung wurru-wiynji-wiynjini-yinyung wirri-waḻangi wine-mirri, wugargayag, marri wu-ḻamij-galadi, anubani-yung wunu-yayn na-Jesus wunu-waḻ-ngujgaa anubani-yung. Wunu-yayn, yagu niga ni-lhaabiyn. ");
INSERT INTO nuy_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Marri aḏaba anubani-yung wunu-marang-barra-raani wubani-wuy a-rangag-guy aḏaba. Marri manubama-yung mana-yaaḻi wurraayajarrangi aḏaba. Amudama-yung yungguyung wurraayigini ama-yaaḻi, yangi-nyung anima-mangi niga magurru. ");
INSERT INTO nuy_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Marri warraawurru-yung wurraandhadhi bagu marri wunu-nani niga. ");
INSERT INTO nuy_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Wugurru wirri-burriyn waarrarrini arrwar na-Jesus-duj na-nijinag-jung-duj. Wu-yamaa anubani-yung, “Naagi Jesus na-Runggal-yung warra-Jew-yinyung.” ");
INSERT INTO nuy_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Yagu nubiṉi-yung wini-wulawaa wini-wungarri-dhini-yinyung warra-marang-barra-raani warubaj na-Jesus-duj, aynjaabu-nyung walawalama-wala marri naaynbajung mangaṉḏayayaagu-wala. ");
INSERT INTO nuy_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Anubanila-wala warruburru-yung warra-wurru-wurruj wurru-yaḻdhangi, wuu-yambini yij-maaḻang. Marri anubani-yung wuu-ḻang-barawararbini. ");
INSERT INTO nuy_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Marri wurru-yamaa, “Nugawaj nuynjamaa, bawu-jadugang anubani ana-Temple-Maṉngulg marri ngijang bawu-rayii muulawaa-wala mana-miyn.nganga! Yagu ba-maṉmiiyn aḏaba, baaṉiyn, ba-dhirridang aḏaba aadanu a-rangag-gala! Nagang-maynji yijgubulu-windiyung na-niwiyayung na-God-jinyung!” Dani-yung wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Wugurraayung warruburru-yung waa-runggu-runggal-inyung warra-priest marri warra-yiyini-yinyung ana-lhaawu-runggal marri warra-mijiwanggu, warraawurru-yung wunu-rajburrnani na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Wugurru wurru-yamayn, “Niga wani-maṉmangi warra-mulung-aynbaj yagu niga waari ninggu-waṉagang ana-lhuḏ, waari ni-maṉmi nigaaj-baj! Niga ni-mayini ni-king warra-Israel-yinyung! Ari ani-dhirridang ana-rangag-gala! Bani-yung ngagurru ngaambu-jambarrgiiyn nigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Niga naa-gurrij-ngu-burraa na-God, marri niga niin-jamayn, niga na-niwiyayung na-God-jinyung. Ari na-God-maynji nu-ngaynbandii-maynji, niga anu-maṉmang!” Dani-yung nga wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Marri nguynju-waj nubiṉi-yung wini-wungarri-dhini-yinyung warra-ngawijgayn-jinyung warubaj na-Jesus-duj, wuguṉi wunu-rajburrnani niga. ");
INSERT INTO nuy_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Aḏaba yaaji arrwar ngi-waḻirr-wadadiyn, anubani-yung aḏaba waangamudiyn anubani-rruj ana-lhal, wurrugu waangamudangi-wugij nga yaajijila arrgarrgaḻi ngi-waḻirr-wiḻibiḻingiyn. ");
INSERT INTO nuy_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Anubanila-wala aḏaba, na-Jesus niiḏangi yanggarrwar-mirri, ni-yambini anubani-yung ana-lhaagi Aramaic-mirri, “Eli, Eli, lama sabachthani?” ni-yamayn. Wiijamana anaani ana-lhaawu, (Psalm 22:1) “Ngayawi-nyinyung na-God, ngayawi-nyinyung na-God, a-yangi yungguyung ngaya nimbaarruyn?” ");
INSERT INTO nuy_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Anubagu-yinyung wurraarra-garra-lhi wurraawanggini anaani ana-lhaawu. Warra-mulung-aynbaj wurru-yamaa, “Yuga naadagu naa-gaḏii na-Elijah-wuy?” wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ni-nguḻu-nguḻubiyn nubagi naaynjaabu-nyung ni-wuwaḻgayn, nga ni-miyn alhilhig marri ni-warwarryangi vinegar wugargayag marri niwu-rangag-gabaa a-rangag-guy. Marri nu-yayn na-Jesus, nguynju ani-waḻ-nguni yungguyung. ");
INSERT INTO nuy_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Yagu mulung-arrgi-yung anubani-yung wurru-yamayn, “Wurrugu, yagi nunu-waṉbi niga. Ngagurru nguunu-ngaynbandiyn ngaanu-nayii na-Elijah. Ari ani-rabalang anu-maṉmang niga,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yagu nigaayung na-Jesus niiḏangi ngijang yanggarrwar-mirri, marri ni-ngawiiyn. ");
INSERT INTO nuy_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Manubama-yung mana-yaaḻi anubagu-yinyung ana-Temple-Maṉngulg-duj ma-burri, manubama-yung ma-ḻaḻmayn yuwaagu arrwar-wala nga yuuguni lhirribala-wuy. Nguynju-waj ana-lhal wu-wirbirini marri mana-ṉuga ma-ḻaḻmayn bandharra-waj. ");
INSERT INTO nuy_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Marri anubani-yung warra-wurrdhu-wurrdhangi-yinyung wu-gara-wawalhiyn marri warraarrawindi-yinyung na-God-yinyung warra-wurru-wurruj warruburru-yung wurru-ngawini-yinyung wuu-ngarra-ḻaḻagiiyn ana-ngawij-gala. ");
INSERT INTO nuy_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Wugurru wurru-rabaliyn anaabiyn-gala. Wurrugu, anubani-yung na-Jesus ni-ḻaḻagiiyn ana-ngawij-gala, warraawurru-yung wurru-yanggi buguni a-Jerusalem-guy, na-God-jinyung anaanga, nga bagu warraarrawindi warra-wurru-wurruj warra-nani wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Aynjaabu-nyung runggal-yung wurru-wiynji-wiynjini-yinyung, bagu ni-lhaay, marri wurru-wiynji-wiynjini-yinyung, wunu-rangarrangi na-Jesus. Wugurru aḏaba wirri-nani anaani waaban-birbirini marri anubani-yung anaarrawindi-lhangu anubani-yung wu-waṉbini, wugurru wurru-ḏirrngawiiyn marri wurru-yamayn, “Niga yijgubulu na-Niwiyayung na-God-jinyung!” Dani-yung wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wugurraayung arraarrawindi warra-maṉaṉung warruburru-yung wunu-ga-garrindharrmangi-yinyung na-Jesus anubanila-wala ana-Galilee, wunu-maṉmangi-yinyung niga. Warraawurru-yung wurraarragarra-lhi yuwaagala malanganyanay, warra-nani. ");
INSERT INTO nuy_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Warra-mulung-arrgi-yung ngarra-Mary Magdalene marri Mary nga-rriibi-yung naawiṉi-yung na-James marri na-Joseph, marri ngarrubagi-yung ngarraaynbajung nga-rriibi-yung na-James marri na-John. ");
INSERT INTO nuy_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Anubani-yung anaadharrwara, nubagi-yung naambalal-yung na-waḻyinyung ni-yanggi Jerusalem-guy. Naagi na-nimuwaj-jung Joseph, ni-marrbuy-maa-yinyung na-Jesus, niga anubanila-wala ana-lhal Arimathea. ");
INSERT INTO nuy_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Naagi ni-yanggi na-Pilate-guy, nu-yandhawiwandi wubani-yung a-ngun.gu na-Jesus-inyung niga. Nigaayung na-Pilate wani-magaa, warruburru-yung wurru-wiynji-wiynjini-yinyung, nga wunu-yayn na-Joseph. ");
INSERT INTO nuy_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nga aḏaba na-Joseph niwu-miyn anubani ana-wubulu marri niwu-wabaa mamanunggu-mirri mana-yaaḻi. ");
INSERT INTO nuy_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Naagi-yung aḏaba niwu-yurangi nga niwu-burriyn bagu ama-gadhuwa-rruj ama-gara ama-ṉuga-rruj. Nga ṉuga runggal nima-dhawawarumayn, nima-jurangi bagu, nima-dhidiyn amubama ama-madhawang. Aḏaba niga ni-yanggi. ");
INSERT INTO nuy_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ngigaayung ngarra-Mary Magdalene marri ngarraaynbajung ngarra-Mary wingi-burri bagu warubaj ama-gara-rruj. ");
INSERT INTO nuy_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ngarraagi ngarraaḻirr ngi-mayini, wurraarraalgaalgurmangi-yinyung ngarraaḻirr. Anubanila, ngarraaynbaj-duj ngarraaḻirr, warruburru-yung warra-runggu-runggal-yinyung warra-priest marri warra-Pharisee wurru-yanggi buguni na-Pilate-guy. ");
INSERT INTO nuy_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Wugurru wurru-yamayn, “Runggal-yung, anaani nurru-marrbuy, nubagi-yung na-Jesus ni-wawaḻangi-yinyung, niga ni-wiri-waj, ni-yamayn ‘Wurrugu amuulawaa-wala mana-miyn.nganga, ngaya anaani nga-ḻaḻagiiyn ana-ngawij-gala.’ ");
INSERT INTO nuy_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Dani-yung nga ni-yamayn. Yagu nagang ba-wij-maṉdhii lhaawu, ambirrima-rangarrii mana-gara yingga muulawaa-wala mana-miyn.nganga. Yagi-magi wugurru nigawi-nyinyung wurru-marrbuy-maa-yinyung wurru-yanggan-magi marri wurraamajan ana-wubulu marri warra-magangun-magi warra-wurru-wurruj, anubani-yung niga ni-ḻaḻagiiyn anubanila-wala ana-ngawij-gala. Anubani-yung yijanggaḻij anggu-lhabarrj-giiyn aḏaba.” Dani-yung nga wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nigaayung na-Pilate ni-yamayn, “Yii, nambarra-yarrijgina warruburru-yung wurru-wiynji-wiynjina-yinyung, marri numburru-yaarri nimbirrima-rangarrii ama-gara aadanu maaḻamburrg-galawaj,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Wugurraayung aḏaba wurru-yanggi amubami-wuy ama-gara. Marri wirrima-walangi alnga-mirri wubami-rruj ama-ma-dhawang-duj, marri warruburru-yung wurru-wiynji-wiynjini-yinyung bagu wirrima-narrangi wugurru. ");
INSERT INTO nuy_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Anubani-yung malgadhaadharri, ngarrubagi-wala ngarraaḻirr-maṉngulg-gala warra-Jew-yinyung, bagila ngi-ḻambalangi. Anubani-yung ana-Sunday. Ngarrubirrngi-yung ngarra-Mary Magdalene marri ngarraaynbajung ngarra-Mary wugurrngi wingi-yanggi ambingima-nani yungguyung ama-gara. ");
INSERT INTO nuy_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Anubani-yung anubagu runggal wu-lhal-wirbirini aḏaba. Wugurru aynjaabugij ana-angel na-Buunggawa-yinyung, wu-dhirridangi anaarrwar-wala wu-yanggi ama-gara-wuy marri juriyn mana-ṉuga anubanila-wala anu-dhawang-gala wugurru wu-burrangayn ama-ṉuga-rruj. ");
INSERT INTO nuy_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Wugurru wu-milhiynjini nguynju yi-yamiynji-yii, marri wugurri-nyinyung mana-yaaḻi ma-ngalngalangi-windiyung. ");
INSERT INTO nuy_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Wugurraayung warruburru-yung wurru-wiynji-wiynjini-yinyung bagu wirrima-narrangi-yinyung mana-gara, wurru-ḏirrngawiiyn-bindiyung wurraarra-galalangi, marri wurru-rabini nguynju yaga wurru-ngawa-ngawina-yii. ");
INSERT INTO nuy_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Anubani ana-angel wu-yamayn ngarra-maṉumbaa-wuy, “Yagi niingi-ḏirrngawi. Ngaya yamba nga-marrbuy aadanu nugurrngi nuungunaagalhaga-lharrmani na-Jesus nubagi-yung wunu-raani-yinyung yuwaagu a-rangag-duj. ");
INSERT INTO nuy_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yagu yamba niga niiri anaaji, niga ni-ḻaḻagiiyn aḏaba! Nguynju-waj niga ni-yambini-yii. Nimbingi-warranggang, yaani yigaj niga ni-murrgulhi. ");
INSERT INTO nuy_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Marri aḏaba nimbingi-yaarri ngalbaḻang marri nambaangi-magana warruburru-yung wurru-marrbuy-maa-yinyung, na-Jesus ni-ḻaḻagiiyn ana-ngawij-gala aḏaba. Niga ni-yaarri buguni Galilee-wuy, raga-ragij nugurri-wuy. Bagu, nugurru numbunu-nayii niga. Aḏaba ngaya anaani ngana-magaa nugurrngi.” Dani-yung wu-yamayn ana-angel. ");
INSERT INTO nuy_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wugurrngiiyung ngarra-maṉumbaa lhugaajgiyalawaj wingi-yanggi. Wugurrngi wingi-ḏirrngawiiyn yagu wugurrngi wingi-wurrij-gaḻaaḻarrangi. Wingi-wayamangi, ambaangi-lhangarrmaa yadhu warruburru-yung wurru-marrbuy-maa-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Wingi-wayamangi… lhugaajgiyalawaj na-Jesus wani-lhangarrmayn bagu. Niga ni-yamayn, “Gurrngi-waj, niingi-yaminggarrina?” ni-yamayn. Wugurrngiiyung ngarra-maṉumbaa wingi-yanggi nigawi-wuy wunu-mun-baṉagayn ana-mun marri wuunu-warraarriwaa niga. ");
INSERT INTO nuy_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nigaayung aḏaba na-Jesus ni-yamayn, “Yagi niingi-ḏirrngawi. Nimbingi-yaarri marri nambaangi-magana ngayawi-nyinyung wurru-marrbuy-mana-yinyung, amburru-yaarri buguni Galilee-wuy. Marri wugurru anaani ngambambi-nayii ngaya bagu.” Dani-yung ni-yamayn na-Jesus. Wugurrngiiyung wingi-yanggi aḏaba. ");
INSERT INTO nuy_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wugurraayung mulung-arrgi-yung wurru-wiynji-wiynjini-yinyung warruburru-yung wirrima-narra-narrangi-yinyung mana-gara, warruburru-yung wurru-yanggi buguni a-wumurrng-guy ana-Jerusalem, warra-magaa warra-runggu-runggal warra-priest, anaarrawindi-lhangu anubani-yung wu-waṉbini-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Aḏaba warra-priest marri warra-mijiwanggu, warraawurru-yung wurru-muṉḏugaa, wirriij-maṉdhangi-yinyung ana-lhaawu. Wugurru warra-bayarra-gaa wurru-wiynji-wiynjini-yinyung runggal-windiyung anu-ṉuga. ");
INSERT INTO nuy_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Marri warra-magaa, “Nambarra-magana warra-wurru-wurruj anubani-yung na-Jesus-inyung wurru-marrbuy-maa-yinyung, wurru-yanggi miyn.ngu marri wurraamaji ana-wubulu, nugurru nurru-yaay-yaay-waj aadanu. ");
INSERT INTO nuy_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Niga-maynji na-runggal-yung na-Pilate ani-wawanggiyn-maynji ana-lhaawu anubani-yung-jinyung nugurru nurru-yaay-yaay, nurru anaani naanu-magana lhaawu, naanu-yurrurrugana, nganambaagajij-maṉdhii nugurru. Yagi ma-waṉi mana-magarrangaynji nugurri-wuy.” Dani-yung wugurru warra-priest wurru-yamayn aḏaba. ");
INSERT INTO nuy_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Wugurraayung wurru-wiynji-wiynjini-yinyung wirri-waṉagaa anu-ṉuga marri warra-magaa warra-wurru-wurruj-guy, anaani aniijanggaḻij ana-lhaawu. Marri anaani ana-lhaawu wu-rajaarriyn warruburru-yung-guy warra-Jew-wuy nguynju-waj anaani ana-yimbaj. ");
INSERT INTO nuy_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Anubanila-wala, warra-11 wurru-marrbuy-maa-yinyung wurru-yanggi Galilee-wuy amubami-wuy maaḻandhirrngindi-wuy, amubami-wuy na-Jesus niga wani-magaa-yinyung anubani-yunggaj. ");
INSERT INTO nuy_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Manubami-rruj, wugurru wunu-nayn na-Jesus, marri wunu-warraarriwaa niga, yagu warra-mulung-arrgi-yung wugurru wurru-wurrij-gadhaarimini. ");
INSERT INTO nuy_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Aḏaba na-Jesus ni-yanggi wugurri-wuy marri ni-yamayn, “Anaarrawindi-lhangu ana-lhuḏ anaarrwar marri anaani-rruj ana-lhal ngani-yayn na-God ngayawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yagu nugurru aadanu numburru-yaarri marri nambarra-mani warra-wurru-wurruj, amburru-marrbuy-mana yadhu ngaya, ana-lhal-lhangu-waj. Marri nambarraambara-ngambijgana, na-nimuwaj-jung-jinyung na-Baba-yinyung marri na-Niwiyayung-jinyung marri ana-Maṉngulg Mawurr-inyung. ");
INSERT INTO nuy_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Marri nambarra-yiyina wugurru ambirri-yandhurrbangana anaarrawindi-lhangu ana-lhaawu, anubani-yung ngaya ngana-yiyini-yinyung nugurru. Marri yijgubulu-windiyung ngaya anaani nugurri-rruj nga-ngu-burraa anggu-wuguuguni, murrubu anggu-dhaag-mana-rruj.” Dani-yung ni-yamayn na-Jesus, wani-magaa wugurri-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Anaani anaambaḻaman ana-lhaawu na-God-jinyung, aani-yung na-Jesus na-Christ-jinyung na-niwiyayung na-God-jinyung. ");
INSERT INTO nuy_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Anu…bani-yunggaj, nubagi naa-ja-jambini-yinyung na-God, na-nimuwaj-jung Isaiah. Naagi-yung ni-warrarrangi anaani ana-lhaawu na-God-jinyung. Na-God ni-yamayn, “Ngaya anaani nganu-lharrganjii niga, bagi-yung nga nganii-dhaawu-yarrijgina-yinyung niga ana-raga-ragij nguynju yadhu nagang. Niga manubama-yung animaandhurrg-gana yungguyung manaadi.” ");
INSERT INTO nuy_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Yaani-yung wu-yamayn ana-yang waaḏiyn yuwaagala a-lhal-aṉḏarrg-gala wugurru, Maanaami manaadi magurru aḏaba nimbirrimaadi-wandhurrg-gana raga-ragij-gaj na-Buunggawa yungguyung aḏaba.” Dani-yung ni-yamayn na-Isaiah niga. ");
INSERT INTO nuy_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Anaani wiijamaa, ana-wulhu-wulhurr ni-ḻaḻagiiyn naagi-yung na-John, aagalhal-aṉḏarrg-gala, marri waniimbara-ngambijgaa marri wani-magaa warruburru warra-wurru-wurruj, “Numburru-wurrij-biḻibiḻingiyn anubanila anaaladi-wala, marri ngaya anambaambara-ngambijgana, nguynju yungguyung anubani-yung na-God yungguyung nugurri-nyinyung nambaniigajij-garruyn aniij-galaaladi.” Dani-yung ni-yamaa na-John niga. ");
INSERT INTO nuy_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Warraarraarrawindi warra-wurru-wurruj wurru-yanggi wubani-wuy a-lhal-aṉḏarrg-guy, bagu wurraawanggini. Wurru-yanggi anubagala ana-Judea-wala wurraawanggini, marri bagala ngijang Jerusalem-gala. Wugurru wirriij-garrarra-gaa wugurri-nyinyung anaaladi marri anubani-yung wirriij-barrngayuyn. Marri anubani-yung na-John waniimbara-ngambijgaa wugurru, anubani anaala-rruj, ana-Jordan. ");
INSERT INTO nuy_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Na-John ni-yabini mana-yaaḻi manubama-yung wubarriguḻag-mirri a-gamul-inyung. Marri anubani-yung ni-ngudaabini wumaguḻag-mirri. Marri ni-ngunu-nguni ḏaburrurrug marri ḻagu. ");
INSERT INTO nuy_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Anubani-yung wani-magaa warra-wurru-wurruj-guy, “Yaagila waḻyinyung ni-yaarri, adhaadharri ani-lhamarrii wurrugu marri. Yagu nigaayung naagila ni-runggal-windiyung, waari nguynju ngayawi-yii. Ngaya yagi nga-burrdangi marri nganu-mun-ngarrgiwu ni-mun-jabina-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ngaya anaani anambaambara-ngambijgana guugu-mirri, yagu niga ni-lhamarrii-yinyung, Maṉngulg Mawurr-mirri nambaniimbara-ngambijgana nugurru.” Dani-yung ni-yamaa na-John, na-nidhaawu-yung. ");
INSERT INTO nuy_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Anubanila, nigaayung na-Jesus ni-yanggi aḏaba anubagala ana-Nazareth-gala, ana-lhal-uj ana-Galilee-rruj. Na-John marri naambara-ngambijgaa, yuwaagu aala-rruj a-Jordan-duj. ");
INSERT INTO nuy_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Anubanila nigaayung na-Jesus niidadiyn anaa-gugu-wala, marri ni-mal-nayn arrwiyaj, ni-warranggayn ana-wumala-rruj wu-gara-wawalhiyn marri anubanila Maṉngulg Mawurr wu-dhirridangi nigawi-wuy, nguynju yi-ḻabarrg-jii, wu-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Marri bani-yung ana-lhaawu wu-yaṉḏabaliyn anaarrwar-wala. God ni-yambini, ni-yamayn, “Nagang aadanu ngayawi-nyinyung Nigi, marri ngaya ngunaa-ḏamarr-ngu-burraa, marri ngaya ngaaḻaaḻarrii nugawi yungguyung,” ni-yamayn na-God. ");
INSERT INTO nuy_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Aḏaba anaani-yung ana-Mawurr ninggu-yarrijgini yuuguni aagalhal-aṉḏarrg-guy. ");
INSERT INTO nuy_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nga bagu ni-burri 40 mana-miyn.nganga, marri na-baḏirrnya-yung bagu naa-dhangu-jujurangi. Marri anubani-yung waanggarra-ngu-burri anubani a-wandalga-yinyung wu-ngarra-ngu-burri-yinyung a-mun-bulal-wulal-inyung. Marri anubani-yung angel ninggu-maṉmangi naagi-yung. ");
INSERT INTO nuy_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Wurrugu marri malgadhaadharri, warruburru-yung wurru-wiynji-wiynjini-yinyung wunu-radbini naagi-yung na-John. Marri anubanila anaadhaadharri anubani-yung na-Jesus ni-yanggi buguni Galilee-wuy marri anubani wani-magaa na-God-jinyung ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ni-yamaa, “Anaani aḏaba wiij-dhamun.gurrg-mana anggiij-guldhang. Aḏaba warra-wurru-wurruj warruburru-yung warru-mandag na-God-jinyung amburru-muṉḏugana lhaalhag. Numburru-wiḻibiḻingiyn nugurri-nyinyung-gala aniij-galaaladi marri numburru-jambarrgiiyn na-God-jinyung a-lhaawu.” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Anubani-yung ni-yanggi nima-ḻaḻa-dharrmangi wubani-yung ni-dhawawarumini ni-wurugu-ramaa wubani a-lhal Galilee. Wani-nayn nubiṉi-yung waḻya-waa, Simon marri Andrew. Naawiṉi-yung nigamanyij. Naawiṉi-yung naynja winima-barawudangi, wini-guḏangi ngujija. ");
INSERT INTO nuy_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Na-Jesus ni-yamayn, “Nimbinaaṉiyn, nganiinggarra-yaarri. Anaanila-wala, nambaani-mani wurru-wurruj na-God yungguyung,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Lhugaajgiyalawaj wini-ḻaḻagiiyn marri winimaarruyn mana-naynja marri anubani-yung wurraanggarra-yanggi wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Anubanila mal-dhamurrug wurru-yanggi wuu-jarrarriyn, wurraarranggayn diṉi na-James marri na-John. Nubiṉi-yung niwiyayung-biiyung na-Zebedee-yinyung. Waadurru-yung warra-wulu-wulaynbaj wirrima-warrgaa manubama-yung mana-naynja. ");
INSERT INTO nuy_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nubiṉi-yung wanii-gaḏiyn. Manubama-yung winimaarruyn mana-naynja marri na-ninyarra-yung na-Zebedee. Bagu nga ni-bu-burri ama-barrawu-rruj, warruburru-yung wurraarraalgaalgurmangi warra-waḻya-waḻya-rruj, bagu ni-burri. Naawiṉi-yung aḏaba wurraanggarra-yanggi na-Jesus-guy. ");
INSERT INTO nuy_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Aḏaba anubani-yung wurru-yanggi Capernaum-guy anubani-rruj ngarraaḻirr-maṉngulg-duj ngarraaḻirr. Anubani-yung ni-yanggi wubani-yung wurru-maga-magini-wuy wubani a-gara, a-synagog. Wani-bajiyini bagu warruburru warra-wurru-wurruj. ");
INSERT INTO nuy_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Anubani-yung warruburru-yung wurru-wurrij-gaḻaaḻarriyn wudani-yung-gala ni-yambini a-lhaawu, anaani yamba ni-yambini nguynju yaga ni-ragaana-yii. Niga yamba ni-yambini wu-waḏa-waḏaḏ-bindiyung ana-lhaawu, waari waadurru-yung-jii warra-yiyini-yinyung ana-lhaawu-runggal wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Anubani-rruj ana-synagog-duj bagu waḻyinyung ni-burri, anubani-yung man.gurrg aladi ni-waṉagaa niga. ");
INSERT INTO nuy_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Naagi-yung niiḏangi yanggarrwar-mirri, anubani ana-man.gurrg ninggaaḏijgaa, “A-yangi yungguyung nagang nimba-warubaj-gana nurri-wuy, Jesus a-Nazareth-jinyung? Yuga nagang aadanu nimba-jadugang anaani nurru? Ngaya nga-marrbuy nagang, nagang aadanu na-maṉngulg-jung na-God-jinyung,” wu-yamayn ana-man.gurrg wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nigaayung na-Jesus ni-yambini yang-baḏa-waḏaḏ lhaawu, ni-yamaa, “Ba-muḏaḏbang, ba-rabalang nigawi-wala,” ni-magaa wubani-wuy a-man.gurrg-guy. ");
INSERT INTO nuy_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Yagu anubani-yung ana-man.gurrg anubani-yung ninggu-rabijgayn, marri anubani-yung ni-lhagar-lhililangi. Marri bani-yung ninggu-wuwudijgayn yanggarrwar nga wu-rabaliyn nigawi-wala. ");
INSERT INTO nuy_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wugurraayung warruburru-yung warraarrawindi wurru-wurrij-gaḻaaḻarriyn-bindiyung marri wuu-yandhawiwaynjini, wurru-yamayn, “Yuga yangi anaani? Marri yuga anaani wiij-gadhuwa ni-yambina? Yagu naagi-yung niga ni-yambini wu-waḏa-waḏaḏ-bindiyung ana-lhaawu! Yagu niga ni-warra-magaa-maynji, ana-man.gurrg-guy, yagu anubani-yung ninggu-yandhurrbangana!” Dani-yung wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yagu yamba anubani-yung, ana-lhaawu nigawi-nyinyung aḏaba wu-rajaarrangi, anubani-rruj ana-lhal, anubani-yung ana-Galilee. ");
INSERT INTO nuy_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Anubani-yung wurru-rabaliyn ana-synagog-gala, na-Jesus marri na-Simon marri na-Andrew marri na-James marri na-John. Wurraanggarra-yanggi buguni na-Simon-guy marri na-Andrew wubani-yung a-wumurrng. ");
INSERT INTO nuy_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ngarrubagi-yung na-Simon-jinyung nga-ranggurrumbayung ngi-lhangurrngang. Ngarraagi-yung ngi-murrmbulangi marri ngi-lhangurrngandi ngiwu-waṉagaa. Wunu-magaa naagi-yung na-Jesus. Nga ni-yanggi ngigawi-wuy, ");
INSERT INTO nuy_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ngu-waṉja-waṉagayn. “Ba-ḻaḻagiiyn,” ni-yamayn. Anubani-yung anu-dhangurrg nginggaarruyn marri anubani-yung ngi-ḻaḻagiiyn, nga ngiga-waj wangiini aadani-yung ana-marrya, wurru-nguni-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wurrugu marri, anubani-yung waamulugugurriyn. Anubani-yung warra-yarrijgini buguni warraarraguṉḏa-guṉḏa-yinyung warra-wurru-wurruj marri wurru-waṉagaa-yinyung wubani-yung aalaaladi-yinyung a-man.gurrg, nigawi-wuy wurru-yanggi. ");
INSERT INTO nuy_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Warraarrawindi anubani-rruj ana-runggal-uj ana-lhigiḏi warruburru-yung warubaj wubani-rruj wu-dhawang-duj. ");
INSERT INTO nuy_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Anaani-yung wani-ḻaḻagaa warraarrawindi-yinyung warruburru-yung warra-wurru-wurruj wubani aynba-gaynbaj-jinyung wirri-waṉagaa-yinyung a-wudhangurrg marri anubani-yung ni-warra-raba-rabalini a-man.gurrg, ni-man-jarramijgaa. Waari anubani-yung ani-lharrgandi ana-man.gurrg anggu-yambini, wugurru yamba wu-marrbuy niga. ");
INSERT INTO nuy_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Anubani-yung ngarraaynbaj-duj ngarraaḻirr, waari-waj angi-ḻambalangi, anaani-yung ni-ḻaḻagiiyn marri ni-yanggi yuuguni waari-wuy amburru-burri warra-wurru-wurruj, marri bagu ni-yambini na-Ninyarra-yung-guy. ");
INSERT INTO nuy_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Na-Simon marri warruburru-yung warra-mulung-aynbaj wunu-garrindharrmangi. ");
INSERT INTO nuy_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Marri wunu-lhangarrmayn wunu-yamijgayn, “Warraarrawindi nugawi nimbiigalhaga-lharrmangi,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nigaayung ni-yamayn, “Ngaambu-yaarri wubani-wuy aaynbaj-guy a-lhal-wuy, nguynju bagu ngamba-magana ngijang. Anaani yijiijung-jinyung anaani nga-yanggi, waari anaarrbidi,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Anaani-yung ni-yanggi wubani-rruj a-lhal-warrawindi-lhangu a-Galilee, marri wani-magaa bagu anubani ana-synagog-duj, marri wanii-garra-yarraani wugurri-nyinyung-gala aaladi a-man.gurrg wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nubagi-yung na-waḻyinyung anubani-yung ni-warra-guṉḏa-guṉḏa naagi-yung, ni-yanggi buguni na-Jesus-guy. Ni-ḻandharrdhangayn marri ni-yamayn, “Yuga nagang ngaya nunggu-ngaynbandii-maynji, baaṉiyn aḏaba nimba-maji-wang ngaya anaani.” Dani-yung niga ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nigaayung na-Jesus naagi-yung nu-warrngayuyn-bindiyung. Anubani-yung ana-marang niwu-burriyn marri nu-waṉagayn. Ni-yamayn, “Yuu, ngaya anaani ngawu-ngaynbandii. Nagang ba-maji-mang aḏaba,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Anubani-yung ana-jiiji aḏaba ninggaarruyn. Naagi-yung waari ani-warra-guṉḏa-guṉḏa-magaa, wu-jadugiiyn aḏaba. ");
INSERT INTO nuy_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Anaani-yung na-Jesus ni-yambini anubani-yung ana-lhaawu wu-waḏa-waḏaḏ. Ni-yamayn, “Yagi warruburru barra-magi warra-mulung-aynbaj. Anubani-yung ba-yaarri nubagi-wuy ni-maga-magina-wuy, marri anubani-yung banu-bajiyina. Ba-yamang, ‘Anubani-yung ana-jiiji aḏaba waaṉibiyn,’ ba-yamang, marri banuuyn na-God anubani ana-bayarra na-Moses-jinyung wani-magaa-yinyung, nguynju wiijamana nugaayung warruburru-yung warra-wurru-wurruj amburru-marrbuy. Dani-yung baaṉbina,” ni-yamayn na-Jesus. Anubani-yung na-Jesus naagi-yung nu-lharrgang. ");
INSERT INTO nuy_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yagu naagi-yung na-waḻyinyung aḏaba ni-yanggi marri wani-magaa warraa…rrawindi warruburru-yung-guy warra-wurru-wurruj-guy. Wudani-yung-gala, ana-lhaawu anubani-yung na-Jesus-jinyung wu-rajaarriyn. Marri waari ani-yanggi anubani-wuy ana-runggal-wuy ana-wumurrng, anubani-yung ni-burri wubani-rruj aa-ḏabarabalu-rruj marri warraawurru-yung warra-wurru-wurruj wurru-yanggi nigawi-wuy, anuwagala anuwagala ana-lhal-wala wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wurrugu anubani-yung ana-malgadhaadharri niigiyn Capernaum-guy. Marri warra-wurru-wurruj anaani-yung wurru-magaynjini anubani-yung ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Wudani-yung-gala, arraarrawindi wurru-wurruj wurru-yanggi wurru-muṉḏugaa. Yagu anubani-yung aḏaba wirri-dhaṉgayn, waari anubagu anggaawawalhangi anubani-rruj anu-dhawang. Marri anubani-yung wani-yambini anaani-yung ana-lhaawu wugurri-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Wurru-wulal-wulal warraawurru-yung warra-waḻya-waḻya, bilnyalga-yung waḻyinyung wunu-warrgaay nigawi-wuy na-Jesus-guy, nguynju yungguyung anu-maṉmangi. ");
INSERT INTO nuy_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Yagu warraawurru-yung waari ambunu-warubaj-gaa niga, arraarrawindi yamba warraawurru-yung wurru-muṉḏugaa. Yagu anubanila-wala, wurru-wiḏangi arrwa-garrwar nga bagala wirri-gara-wawalhijgaa nigawi-rruj na-Jesus-duj ni-lhaay. Nga bagala wunu-dhirridijgaa naagi-yung. Ni-murrgulhi nigawi-nyinyung-duj anubani-yung ni-ya-yaay-inyung ama-yaaḻi. ");
INSERT INTO nuy_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Na-Jesus nigaayung ni-mal-nayn nga wani-nayn warruburru-yung wurru-jambarrgiiyn. Marri nubagi-yung-guy nu-yamijgayn, “Guwaj, aḏaba nagang aadanu nundaarrbidi-mayn aadanu-wala anaaladi,” ni-yamayn niga, nu-yamijgayn. ");
INSERT INTO nuy_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Warra-mulung-aynbaj warruburru-yung warra-yiyini-yinyung ana-lhaawu-runggal, bagu wurru-burri, yagu anubani-yung wurru-wijangani, ");
INSERT INTO nuy_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“A-yangi yungguyung ni-yambini naagi ana-lhaawu? Aynjaabu-nyung-bugij ngambaniigajij-garruyn-jinyung, God-bugij. Naagi na-waḻyinyung naaladi-yamawana na-God!” wurru-yamayn wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yagu na-Jesus anubani-yung ni-marrbuy, nigawi-rruj ana-lhirribala. Ni-marrbuy anubani-yung wurru-wijangani-yinyung. Nga ni-yamayn, “A-yangi yungguyung nugurru aadanu nurru-wijangayii anubani-yung? ");
INSERT INTO nuy_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ngaynjamang-maynji ngaynjambang, ‘Nagang nundaarrbidi-mayn anaaladi-wala,’ danu nga aniij-garrarra. Yagu anubani-yung-maynji ngaynjambang ‘Ba-ḻaḻagiiyn, bamba-mang mana-yaaḻi marri ba-yaarri,’ aadanu wiij-baḏa-waḏaḏ. ");
INSERT INTO nuy_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aadanu nugurru numburru-marrbuy ngaya-waj na-Niwiyayung na-Wurrujung-jinyung, anambaagajij-garruna nugurru aniij-galadi, anaani-rruj ana-lhal-uj,” ni-yamayn, marri anubani-yung ni-yambini nubagi-wuy naarra-wilwilwilujung-guy, ");
INSERT INTO nuy_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ngaya anaani ngunu-magana, ba-ḻaḻagiiyn, marri bama-mang amudamu nugawi ama-yaaḻi marri ba-yaarri nugawi-wuy aanga-wuy.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Yagu nigaayung ni-ḻaḻagiiyn marri nima-miyn manubama-yung mana-yaaḻi marri ni-yanggi aa-ḏabarabalu-wuy. Warruburru-yung wunu-nani wurru-wurrij-gaḻaaḻarriyn. Marri wunu-warraarriwaa na-God. Wurru-yamaa, “Waari ngaanggiij-nani, anaani-yung-jii anggiijamaa,” wurru-yamayn wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Marri anubanila ni-rabaliyn yuuguni aa-ḏabarabalu-wuy warubaj wubani-wuy a-wurugu. Marri warruburru-yung warraarrawindi warruburru-yung wuu-yanggi nigawi-wuy marri bagu wani-magaa. ");
INSERT INTO nuy_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Anubani-yung ni-yanggi, niga nu-nayn waḻyinyung na-nimuwaj-jung Levi, na-niwiyayung na-Alphaeus. Naagi-yung niwu-mang-mangi-yinyung anu-ṉuga, ni-bu-burri wubani yaga wirriirrarrangi-rruj, a-tax anu-ṉuga. Niga na-Jesus ni-yamayn nigawi-wuy. “Numba-garrindharrmang ngaya,” ni-yamayn. Nigaayung ni-ḻaḻagiiyn marri nu-garrindharrmiyn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Anubanila-wala, na-Jesus ni-nguni nigawi-rruj a-wumurrng-duj. Yagu arrawindi wirri-manga-mangi-yinyung anu-ṉuga marri warraalaaladi-yinyung wurru-waṉiyn marri wurru-nguni na-Jesus-duj marri nigawi-nyinyung wurru-marrbuy-maa-yinyung, arraarrawindi yamba wunu-garrindharrmani niga. ");
INSERT INTO nuy_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wugurraayung warruburru-yung warra-yiyini-yinyung ana-lhaawu-runggal marri warra-Pharisee wunu-nani naagi-yung ni-nguni warraalaaladi-rruj marri warruburru-yung wirri-manga-mangi-yinyung anu-ṉuga. Marri wurru-yambini warruburru-wuy wurru-marrbuy-maa-wuy. Wurru-yamaa, “Ni-yaminggarrina, ni-nguni naagi-yung waadurru-rruj?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nigaayung aḏaba na-Jesus ni-wawanggiyn wugurri-wuy, niga ni-yamayn, “Nugurru numburru-wijangayii nubagi wani-maji-wana-yinyung na-wurrujung. Niga waari ambani-nang warruburru-yung wurru-waḏa-waḏaḏ-mi-yinyung. Niga wani-nayii warruburru-yung wuu-lhangurrnganjii-yinyung, burru-yung-bugij. Ngaya anaani ngana-magana anaani-yung. Ngaya nga-yanggi anaanu-wuy, waari-yinyung warra-mamanunggu-yinyung. Ngaya nga-yanggi, ngambaa-gaḏii yungguyung warruburru-yung warraalaaladi-yinyung ngayawi-wuy.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Warruburru-yung wurru-marrbuy-maa-yinyung na-John-jinyung marri warruburru-yung wurru-marrbuy-maa-yinyung warra-Pharisee-yinyung, warruburru-yung waari amburru-nguni ana-marrya wugurru. Yagu warruburru-yung warra-wurru-wurruj wunaa-gaḏiyn na-Jesus marri wurru-yamayn, “A-yangi yungguyung warruburru wurru-marrbuy-mana-yinyung yagi wurru-ngi ana-marrya, yagu nugawi-nyinyung wurru-marrbuy-mana-yinyung, waadurru wurru-nguyii ngijang?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yagu nigaayung na-Jesus wani-yamijgayn, “Anubani-yung-maynji nubagi-yung ambunu-marangiiyn-maynji na-waḻyinyung, marri anubani-yung amburru-nguyii ana-marrya, yuga amburru-lhambiynjina, yagi wurru-ngi yuga? Girrjag! Amburru-nguyii-wugij, ani-burraa-maynji anubagu nubagi-yung naaynji-maṉinyung. ");
INSERT INTO nuy_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yagu wurrugu, nubagi-yung-maynji warra-mulung-aynbaj warruburru-yung ambunu-yarrijgina nubagi-yung naaynji-maṉinyung, yagu anubani-yung warraawurru-yung yagi wurru-ngi anubani-yung ana-marrya. ");
INSERT INTO nuy_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Waari warraaynbaj wirrima-warrgi mana-yaaḻi manubama-yung mana-nungguḏaaba, wirrima-dhabiḏbi mana-magadhuwa mana-yaaḻi. Mana-ma-gadhuwa-maynji bama-burrang, marri bama-warrgana, manubama-wuy mana-nungguḏaaba-wuy, manubama-yung ama-ḻaḻmang mana-nungguḏaaba, ma-lhar-ninig aḏaba. ");
INSERT INTO nuy_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Warraaynbaj waari wirri-burri anubani-yung anu-gadhuwa anu-gargayag ana-nungguḏaaba-wuy anu-maguḻag-guy. Anubani-yung-maynji numburru-waṉbina, anubani-yung anggu-gulmung-ambadang yagu anubani anu-gargayag marri anubani ana-maguḻag anubani-yung anggu-wulagiynjang anggaaṉibiyn. Yagu anubani anu-gadhuwa anu-gargayag marri wugadhuwa anubani-yung wumaguḻag.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ngarrubagi-yung ngarraaḻirr-maṉngulg-duj, na-Jesus anubani-yung ni-jarrarrangi banila-yung wu-warradiynjini-rruj wuḏal. Marri warruburru-yung wurru-marrbuy-maa-yinyung wurru-yanggi marri wurru-mangi wuḏal marrya. ");
INSERT INTO nuy_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Yagu wugurraayung warra-Pharisee wunu-yamijgayn nigawi-wuy, “Baarranggang, aadanu-maynji amburru-waṉbina-maynji ngarraagi-rruj ngarraaḻirr, aadanu wiijamana wiij-galadi-wina,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nigaayung na-Jesus wani-yamijgayn, “Yuga nugurru waari nimbirri-nani ana-wubiba-rruj, niga na-David marri warruburru-yung nigawi-nyinyung warra-waḻya-waḻya wugurru wurru-ngaynbandangi marri wurru-marryaadangi. ");
INSERT INTO nuy_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Marri anubani-yung wurru-yanggi wubani-wuy na-God-guy wubani-wuy a-wumurrng. Marri warruburru-yung warra-priest, yagu burru-yung-bugij wurru-nguni anubani-yung ana-maṉngulg anu-ḏayn anubani-yung na-God-jinyung-duj ana-wumurrng. Yagu anubani-yung na-David ni-miyn, marri waniini warruburru-wuy nigawi-nyinyung warra-waḻya-waḻya, marri wurru-nguni wugurru. Nubagi-yung yaga na-Abiathar na-runggal-yung na-priest-jung. Yuga anaani-yung nugurru nirri-nani? ");
INSERT INTO nuy_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Na-God ngarraagi ngu-maṉdhangi ngarraaḻirr-maṉngulg, warra-wurru-wurruj yungguyung. Yuga wani-maṉdhangi warra-wurru-wurruj ngarraagi yungguyung ngarraaḻirr-maṉngulg? Waari! ");
INSERT INTO nuy_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Wudani-yung-gala, yaani nga ngaya-waj na-Niwiyayung na-Wurrujung-jinyung, ngaya-waj yaani nga nga-buunggawa-mana aḏaba ngarraagi-rruj ngarraaḻirr-maṉngulg.” Dani-yung ni-yamayn na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Anubanila-wala malgadhaadharri, ni-yanggi wubani-wuy a-synagog-guy ngijang. Marri bagu waḻyinyung ni-burri. Naagi-yung ni-warra-guṉḏa-guṉḏa a-marang. ");
INSERT INTO nuy_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Marri bagu mulung-arrgi-yung wunu-nani, wugurru yamba wurru-wijangani, “Nubagi yuga anu-maji-wang ngarrubagi-rruj ngarraaḻirr ngarra-maṉngulg? Marri anubani-yung ngaambu-yamang, ‘Naadagu niwu-wagiwayn anubani-yung ana-lhaawu ana-runggal,’” wurru-yamayn, wurru-wijangani. ");
INSERT INTO nuy_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nubagi-yung na-Jesus nu-yamijgayn nubagi-yung naarra-guṉḏa-guṉḏa-yinyung na-waḻyinyung, “Ba-ḻaḻagiiyn, baaṉina.” ");
INSERT INTO nuy_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Marri anubani-yung wani-yamijgayn warruburru-wuy, “Anaani ana-lhaawu-runggal, wu-yaminggarrina yuga wu-yambina? Yuga anaani ngaambu-yaminggarrina ngarraagi-rruj ngarraaḻirr-maṉngulg? Yuga ngaambu-waṉbina maaḻamburrg, yagu ngaambu-waṉbina aladi? Yuga warrubawi-yung ngaamba-wiri-gang yagu warrubawi-yung ngaamba-ngawijgang?” Dani-yung ni-yamayn. Yagu warruburru waari ambuu-yambini, waari. ");
INSERT INTO nuy_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Marri ni-warra-garranggaa wani-nani, marri anubani-yung ni-riyaldhiyn waari yamba warruburru-yung ambunu-warrngayungaa, nubagi na-waḻyinyung, marri wurru-ḻamumundhini. Marri anubani-yung ni-wurrij-galadi-wiiyn. Marri anubani-yung nu-yamijgayn nigawi-wuy na-waḻyinyung-guy, “Bawu-lharraalhijgang nugawi-nyinyung ana-waṉja.” Nga nigaayung niwu-lharraalhijgayn. Marri anubani-yung ana-marang ni-marang-maṉdhiiyn aḏaba ana-marang naagi-yung. ");
INSERT INTO nuy_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Warruburru-yung warra-Pharisee wurru-yanggi yuuguni warruburru-wuy warra-wurru-wurruj na-Herod-jinyung, marri bagu wurru-yambiynjini. Wurru-yamaa, “Nubagi-yung na-Jesus ngaanu-jadugang.” Dani-yung wurru-yamaa wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Na-Jesus marri warruburru-yung wurru-marrbuy-maa-yinyung, anubani-yung wii-lhal-warruyn anubani ana-lhal marri wurru-yanggi wubani-wuy a-wurugu-wuy. Warruburru-yung bagu warraarrawindi anubagala ana-Galilee-wala marri ana-Judea-wala, wunu-garrindharrmangi niga. ");
INSERT INTO nuy_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Warra-mulung-aynbaj wurru-yanggi Jerusalem-gala, marri bagala Idumea-wala, marri wagagala-wala Jordan-gala, marri bagala yuwaagala Tyre-wala, marri yuwaagala Sidon-gala, arrawindi warraawurru-yung warra-wurru-wurruj. Wurru-yanggi yagu yamba warraawurru-yung wurraawanggini ana-lhaawu, anubani-yung ni-waṉbini-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Warraawurru-yung wani-magaa warruburru-yung wurru-marrbuy-maa-yinyung, “Warraawurru warra-wurru-wurruj wurru-mulung-arrawindi. Warraawurru ngarrambi-jiibugayn ngagurru. Numbuu-yaarri barrawu, nimbirrima-burrang aḏaba,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Warraawurru-yung warraarra-guṉḏa-guṉḏa-yinyung wuu-yanggi, ambunu-waṉagaa, yagu yamba wani-maṉmangi arraarrawindi. ");
INSERT INTO nuy_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Marri anubani-yung ana-man.gurrg ninggu-nayn na-Jesus, marri anubani-yung waadbarrwini marri waaḏangi, “Nagang aadanu na-Niwiyayung na-God-jinyung!” wu-ngarra-jamaa. ");
INSERT INTO nuy_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yagu anubani-yung nigaayung ni-yambini, yang-baḏa-waḏaḏ-mirri lhaawu, “Yagi narra-magi warruburru-yung warra-mulung-aynbaj, ngaya anaani,” ni-yamaa niga. ");
INSERT INTO nuy_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Anubanila-wala, ni-yanggi yuuguni arrwiyaj ama-ṉuga-wuy. Naagi-yung ni-marrbuy yanga-yangi-nyung-galawaj wani-ngaynbandangi. Marri warruburru-yung wanii-gaḏiyn. Warruburru-yung wuu-yanggi nigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Marri ni-wajbarini warruburru-yung 12. Nguynju yungguyung naagi-yung wurraanggarra-yanggi, marri wani-lharrgandi yungguyung wurru-magini yungguyung. ");
INSERT INTO nuy_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Marri warraawurru-yung waniini lhuḏ, nguynju yungguyung wubani-yung aalaaladi-yinyung a-man.gurrg amburraarra-yarraana yungguyung. ");
INSERT INTO nuy_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yaawurru yigaj warru-mu-muwaj. Simon, naagi-yung nu-mij-gaynbijgayn anaaynbaj, Peter. ");
INSERT INTO nuy_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Marri James, marri John. Naawiṉi-yung na-Zebedee-yinyung na-niwiyayung-biiyung. Marri wani-mayaa Boanerges, anaani wiijamana, nguynju yaga yiidagu ni-waṉbini ni-mindhii yi-yamiynji, marri ni-ngurrurruwana. ");
INSERT INTO nuy_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Marri Andrew, Phillip, Bartholomew, Matthew, Thomas, James na-niwiyayung na-Alphaeus-jinyung. Marri Thaddeus marri Simon wubanila-wala a-lhal a-Canaan-gala. ");
INSERT INTO nuy_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Marri Judas Iscariot, wurrugu marri naagi-yung anu-minbini niga na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Marri na-Jesus nigaayung ni-yanggi aanga-wuy. Yagu warruburru-yung warraarrawindi wurru-yanggi nigawi-wuy. Warruburru-yung waari amburru-nguni, warraarrawindi yamba. ");
INSERT INTO nuy_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Wugurraayung nigawi-nyinyung warra-mijgalgur-yung wurraawanggini. Aḏaba wurru-yanggi anubagala, nguynju yungguyung naagi-yung ambunu-mangi. Wurru-yamayn, “Naagi-yung ni-wan-gaagidhiyn,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Warruburru-yung warra-yiyini-yinyung ana-lhaawu-runggal ana-Jerusalem-jinyung wurru-yamayn, “Nubagi-yung na-Beelzebul na-baḏirrnya-yung, ni-buunggawa-mana-yinyung niga anubani-yung-jinyung ana-man.gurrg-gaang, anubani-yung nigawi! Dani-yung ana-lhuḏ niwu-waṉagana, wubanila-wala na-baḏirrnya-yung-gala, marri niwu-yarramijgana ana-man.gurrg-gaang.” Dani-yung wurru-yamayn wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Marri na-Jesus ni-yamayn, “Numburraaṉiyn numburru-yaarri bagala.” Marri anaani-yung wani-magaa anaani-yung ana-lhaawu. “Yuga naagi na-baḏirrnya-yung ani-yarramijgina nigaajbaj? ");
INSERT INTO nuy_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Warra-mulung-aynjaabugij-maynji wugurru anubagu-maynji amburru-burraa, warruburru-yung-maynji wugurru amburru-wiynji-wiynjina-wugij, warruburru-yung waari wurru-burrangi ana-baḏag. ");
INSERT INTO nuy_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Warra-wurru-wurruj-maynji warra-mulung-aynjaabugij warruburru-yung warru-mandag amburru-wiynjina wugurraajbaj, marri warruburru-yung warru-mandag ari amburru-manda-ngu-jadugiiyn mal-dhamurrug. ");
INSERT INTO nuy_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Marri na-baḏirrnya-yung-jinyung-maynji ana-man.gurrg anggu-wiynjina wugurru wugurraajbaj-balij, yagi wu-lhuḏ-ḏumi wugurru aḏaba. Marri niga ani-jadugiiyn mal-dhamurrug. ");
INSERT INTO nuy_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Waari warraaynbaj wirri-yabi ana-wumurrng nubagi-yung-jinyung na-waḏa-waḏaḏ-jung-jinyung marri waari wunaa-garra-yari anubani-yung ana-ngurrji. Yagu, anubani-yung-maynji ana-wulhu-wulhurr nubagi-yung-maynji ambunu-radbumana na-waḏa-waḏaḏ-jung, marri ambunaa-garra-yarina anubani-yung anaarra. ");
INSERT INTO nuy_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Yagu yamba anubani-yung, na-God ambaniigajij-garruyn anubani-yung anaarrawindi anaalaaladi, marri amburru-lhaguḻa-maaḻang-maynji, anubani-yung na-God ari ambaniigajij-garruyn. ");
INSERT INTO nuy_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Yagu warruburru-yung-maynji warra-wurru-wurruj ambii-lhaawu-waandirrang-maynji ana-Maṉngulg Mawurr, yagi na-God waniigajij-garru. Warruburru-yung ambirri-waṉagana anubani-yung anaaladi wuguuguni.” ");
INSERT INTO nuy_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Dani-yung ni-yamaa na-Jesus, wani-yambini warruburru-wuy, wugurru yamba wurru-yamaa ana-raga-ragij, “Niga niwu-waṉagana aladi man.gurrg.” ");
INSERT INTO nuy_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nigawi-nyinyung nga-rriibi-yung marri warruburru-yung warra-minilharri-yung, wurru-yanggi bagu wurraarra-garra-lhi aaḏabarabalu-rruj. Marri anubani-yung wuu-yandharrgiiyn nigawi-wuy lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Warruburru-yung warru-mandag bagu wurraarra-garra-lhi, marri wurru-yamayn, “Nugawi-nyinyung nga-rriibi marri warra-minilharri durru wurraarra-garra-lhara aarabarabalu-rruj. Ngambi-yandhawiwana nugawi yungguyung,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Marri nigaayung ni-yamayn, “Yangi-nyung yuga ngaadagi ngaya ngaa-rrigang marri naa-murruyung-gaang?” ");
INSERT INTO nuy_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Marri ni-garri-niiyn warruburru-wuy warraarraarrawindi-wuy, wurru-burri-yinyung bagu wunu-nanggamiṉmiṉḏangi, marri ni-yamayn, “Yaawurru ngayawi-nyinyung nga-rrigang marri naa-murruyung-gaang. ");
INSERT INTO nuy_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Warrubawa-yung-maynji warraaynbaj ambunu-yandhurrbangana-maynji na-God, burru-yung ngayawi-nyinyung naa-murruyung-gaang marri ngaa-murruyung-gaang marri ngaa-rrigang-gaang.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Anubanila-wala, niga na-Jesus wani-magaa ana-lhaawu bagu ama-madha-gaḻaḻij-duj. Mulung-dhabarrj-bindiyung warru-mandag wurru-muṉḏugaa wunu-dhawawarumayn niga, yagu niga ni-yanggi buguni ama-barrawu-wuy, ni-yabaynjiyn nga ni-burrangayn. Yagu warruburru-yung warra-wurru-wurruj wurraarra-garra-lhi ama-madha-gaḻaḻij-duj. ");
INSERT INTO nuy_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Marri anubani-yung wani-magaa wiij-bulawaa-wala, ni-yambini arrawindi. Anaani-yung anaarrgi-yung ana-lhaawu wani-magaa. ");
INSERT INTO nuy_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Numburraawanggina! Nubagi-yung na-waḻyinyung ni-yanggi, ni-wanuynjungaa anu-ḏal. ");
INSERT INTO nuy_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Marri ni-ral-yarraani. Anubani ana-mulung-aynbaj waadbarrwini amubama-waj amaadi-waj. Nga anubani ana-ngurudhu wu-wilbilangi marri wu-ngarra-ḏalhangi marri arra-nguni anu-ḏal. ");
INSERT INTO nuy_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","“Anubani ana-mulung-aynbaj anu-ḏal anubani waadbarrwini ama-ṉuga-waj, waari anubagu anaaban ana-lhirribala. Yagu anubani-yung waarradangi wu-nguḻu-nguḻubini, waari anubagu ana-lhirribala anaaban anuguni-yinyung anggu-lhiḏangi-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ngarrubagi-yung ngarraaḻirr ngi-ḻan.gaḏangi marri ngi-wal-murrmbulingijgayn yagu anubani-yung waari anubagu anu-ngujang, anubani-yung wu-ḏaḏarrg-mayn, wu-lhagarra-ngawini. ");
INSERT INTO nuy_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","“Ana-mulung-aynbaj wugurru anubani-yung anu-ḏal waadbarrwini a-rawurrumugurrumu-rruj. Anubani-yung anu-bal waarradangi. Anubani wugurraayunggaj wu-wal-warradangi ana-rawurrumugurrumu ngijang wu-waliynjini. Marri anubani-yung al-waabaabaa, marri anubani-yung waari anggu-warradangi anu-ḏal. ");
INSERT INTO nuy_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","“Anubani-yung ana-mulung-aynbaj anubani-yung waadbarrwini nga wu-warradiyn anuwaagu anaaban-mamaaḻang-baj. Marri anubani-yung wu-warradangi marri wu-gulmung-jungini, ana-mulung-arrgi anubani wu-maṉdhini 30 anu-ḏal anubanila-wala aynjaabugij, anubani-yung arrgi wu-maṉdhini 60 anu-ḏal, anaarrgi anubani-yung wu-maṉdhini 100 anu-ḏal, anubanila-wala wal-aynjaabugij wugurru.” ");
INSERT INTO nuy_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Na-Jesus naagi-yung ni-yambini-wugij. “Nugurru-maynji numburraan-bawalhang aadanu, marri anubani-yung numburraawanggina windiyung nugurru!” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Malgadhaadharri waari warruburru-yung amburraanggarra-ngu-burri warraarraarrawindi. Warruburru-yung warra-12, marri warruburru-yung warra-mulung-aynbaj wurraanggarra-yanggi-yinyung, wunu-yandhawiwayn, “Anubani yuga wiijaminggarrina ana-lhaawu, wu-magina?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nigaayung ni-yamayn, “Nugurraajbaj, nirri-waṉagana anaani ana-bayarra, na-God-gala. Anaani ngana-magana nugurri-wuy, nguynju yadhu anubani-yung numburru-marrbuy anubani aniij-miḏaamimi-yinyung, warruburru-yung-jinyung warru-mandag nigawi-nyinyung na-God-jinyung. Yagu warruburru-yung warra-mulung-aynbaj anubani-yung amburraawanggina anaani-yung aniij-miḏaamimi-yinyung ana-lhaawu-wugij, yagu anubani waari wurraawanggi, wiijaminggarrina-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Anaani wiijamana, ana-wubiba waarrarrina, ‘Yijgubulu ambirriij-nayii, yagu anubani-yung waari wurru-marrbuy-dhi. Marri anubani yijgubulu amburraawanggina, manaama mana-warang, yagu waari anubani-yung wurru-marrbuy-mi. Marri anubani waari wurraagi na-God-guy, marri waari anubani-yung waniigajij-garru.’” ");
INSERT INTO nuy_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Naagi-yung na-Jesus wani-magaa-wugij, ni-yamaa, “Yagi-maynji anubani-yung nurru-marrbuy-mi anaani aniij-bulawaa-wala, yagu-maynji anubani-yung nurru-marrbuy-mi anaarrawindi anaani aniij-bulawaa-wala, yuga? ");
INSERT INTO nuy_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nubagi-yung yaga ni-wanuynjungana-yinyung, anubani-yung ni-ral-yarraani anu-ḏal. Anaani wiijamana, ana-lhaawu na-God-inyung. ");
INSERT INTO nuy_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","“Anubani-yung anu-ḏal amaadi-waj, wiijamana, warruburru-yung warra-wurru-wurruj wurraawanggina ana-lhaawu, yagu anubani-yung na-baḏirrnya-yung na-Satan ni-yaarri marri niwu-yarina anubani-yung ana-lhaawu wugurri-wala. ");
INSERT INTO nuy_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Anaani wiij-nguynju, anubani-yung anu-ḏal ama-ṉuga-waj waarradii, wiijamana, warra-wurru-wurruj warruburru-yung wurru-wawanggina-yinyung ana-lhaawu, marri wirri-ngaynbandii, wurru-waḻaaḻarrii, yagu waari-windiyung, nguynju yaga anubani ana-rangag waari-yinyung anu-ngujang, waari wu-warradi ana-rangag. Yagu warruburru-yung waari amburru-jambarrgang-bindiyung, Anubani-yung-maynji ana-wungarri anggu-waṉiyn, wugurru yamba wurru-jambarrgiiyn, warruburru-yung amburru-yarramana, amburru-lhuṉdhii wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Wugurraayung anubani-yung anu-ḏal anubani-yung wu-rabina-yinyung anubani-rruj ana-rawurrumugurrumu-rruj, anaani wiijamana warra-wurru-wurruj warruburru-yung wurru-wawanggina ana-lhaawu, ");
INSERT INTO nuy_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","yagu anubani-yung-maynji aniij-gaynbaj amburraalharaguna, anubani-yung wurru-yaal-aḏaaḏigaynjina. Marri wirrii-ḏamarr-ngu-burraa anaani ana-lhal, marri wurraarra-ngaynbandii aynba-gaynbaj. Anubanila-wala aḏaba wu-ngarina ana-lhaawu. Yagu anubani-yung waari wu-warradi anu-ngugulumung. ");
INSERT INTO nuy_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Wugurraayung anu-ḏal wu-rabina-yinyung anaaban-mamaaḻang-baj, anaani wiijamana, warruburru-yung warra-wurru-wurruj wurru-wawanggina-yinyung ana-lhaawu, marri wurru-jambarrgina-windiyung. Anaani wiijamana, nguynju yaga anggu-warradii wu-ngugulmung. Malgaynbaaynbiyaj 30, malgaynbaaynbiyaj 60, malgaynbaaynbiyaj 100 wugurru.” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Anubanila-wala, wani-yamijgayn, “Nugurru-maynji nimbirri-yarrijgina-maynji anu-dhalng nugurri-wuy anaanga, yuga bagu nimbirri-burrang ama-gaṉdharra-rruj lhirribala? Yagu lhirribala ama-yaaḻi-rruj? Yagi! Anubani nimbirri-wudhang yuwaagu arrwar, anggu-yaljirraa. ");
INSERT INTO nuy_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Anaarrawindi-lhangu anubani-yung wu-julubina-yinyung, wurrugu marri amburru-marrbuy-dhina wugurru. Marri anaarrawindi-lhangu anubani-yung wu-miḏaamimi anaani anggiij-garrarra-mang wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mana-warang-maynji numburraawanggina-maynji, numburru-wijangayii nugurri-rruj aambubug-duj.” ");
INSERT INTO nuy_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Naagi-yung na-Jesus ni-yambini-wugij. “Nugurru numburraawanggina numburru-maaḻamburrg anubani-yung ana-lhaawu. Anubani-yung-maynji numburru-yiynjang nugurri-nyinyung-gala nigawi-wuy na-God-guy, nigaayung na-God ari nambanii-gaagijgiyn, anaani wiij-nguynju wiijamana. Ngijang nambaniiyn ani-malgaagijgiyn. ");
INSERT INTO nuy_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nugurru numburru-marrbuy-yinyung anaani, anubani-yung God nambaniiyii nugurru, nguynju yadhu anubani numburru-marrbuy-wina windiyung nugurru. Yagu nugurru waari-yinyung numburru-marrbuy-mang-jinyung aadanu, yagu nugurru nurraaḻamin-jamana nurru-marrbuy, yagu aadanu na-God aniwu-yarina niga nugurri-wala.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Anubanila-wala na-Jesus ngijang ni-yambini, “Na-God-jinyung warru-mandag wu-yamana, nguynju yaga na-waḻyinyung nubagi-yung ni-warra-ngu-barawudangi anu-ḏal aaban-guy. ");
INSERT INTO nuy_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Marri ni-yaay, marri ni-ḻaḻagiiyn, malgarrawindi ni-waṉbini ni-ḻaḻagini. Wugurraayung anu-ḏal anubani-yung wu-wanung-dhangaḏbangi marri wu-warradangi. Waari anaani ani-marrbuy-magaa wiijaminggarrina wu-warradii, marri ajigala wu-wanung-dhangaḏbii marri wu-warradii. ");
INSERT INTO nuy_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Anubani-yung anaaban waaṉbina wu-wal-lhangaḏbii. Marri anubani-yung aḏaba wu-gulmung-jungina marri anubanila wu-warra-ngugulmung-jayaadii. ");
INSERT INTO nuy_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Marri anubanila aḏaba wu-lharang-mana. Marri ni-wal-wulguldhii. Anubani-yung aḏaba wu-lharang-mana yamba marri ngurru-mani.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Naagi-yung ngijang ni-yamaa, ni-yambini. “Warruburru-yung yuga warru-mandag wugurru na-God-jinyung, wurru-yaminggarrina? Yuga yangi aniij-bulawaa-wala ngaynjambina? ");
INSERT INTO nuy_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Warruburru-yung wurru-yamana nguynju a-winyig wuḏal, wubani wu-mayini mustard. Anubani-yung anu-ḏal, anubani-yung ana-ral-wirrig, anaarrawindi-lhangu anaani-rruj ana-lhal-uj. ");
INSERT INTO nuy_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Anubani-yung-maynji warraaynbaj ambu-wanuynjungana, marri anggu-warradii, marri anubani anggu-runggal-mana, anubani-yung anggu-ngaḻ-wilii. Anubani-yung anuuguni anggu-waṉḏa-lhalbarriynjina runggal, anu-gubaṉḏa. Ana-ngurudhu wugurru anggu-ngarra-guṉmana nga bagu anggu-wayayarrii wubani-rruj a-ruluj.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Wugurraayung warruburru-yung wurraawanggini nigawi-wuy, anubani-yung ni-yambini-yinyung ana-lhaawu, wiijamaa. Anubani-yung ni-yambini-wugij wiij-bulawaa-wala. ");
INSERT INTO nuy_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Waari anubani-yung ambani-magaa anggiij-garrarra. Yagu wurrugu marri, burru-yung-bugij warruburru-yung wurraanggarra-yanggi-yinyung, warruburru-yung wurru-marrbuy-maa-yinyung, marri anubani-yung ni-wij-jurrurrugaa anaarrawindi-lhangu, ni-wij-garrarra-gaa, wugurri-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Malgadhaadharri wurrugu anubani-yumbaa, anubani-yung wu-wamulugugurri. Anubani-yung wani-yamijgayn, “Ngaambu-yaarri wagagala-wuy a-wurugu,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Na-Jesus bagu ni-burri amubama ama-barrawu-rruj. Warruburru-yung warraarruyn warra-garnyirrimba, wuu-ngarra-jabaynjiyn amubama ama-barrawu-wuy. Naadagi-yung na-Jesus wurraanggarra-yanggi. ");
INSERT INTO nuy_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Na-Jesus niga ni-yingayn aḏaba. Wurru-waya-wayamangi… nga yingga anubagu ana-bandharra. Wu-yanggi anuwaagala anubani wuwalulu wu-waḻadhi. Anubani-yung wanggu-miyn bandharra. Anubani-yung waar-yabaynjini anaa-gugu. Anubani-yung ma-gayn-ngambini mana-barrawu. ");
INSERT INTO nuy_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Nigaayung na-Jesus yuwaagu adhaadharri ni-burri, ni-yaay-wugij, ni-yinag-gudhi. Marri wurru-yanggi, wunu-marayanggayn. Wurru-yamayn, “Nimba-yiyina-yinyung, yuga anaani yagi nimba-maṉmi, anubani anaani ngaambu-ngambang!” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Anubani-yung ni-ḻaḻagiiyn marri niwu-yamijgayn ana-wudhanguyn marri anaa-gugu. Ni-yamayn, “Ba-muḏaḏbang!” Anubani-yung ana-wudhanguyn wu-muḏaḏbiyn, wugurraayung anubani-yung anaa-gugu waar-yingayn, muḻurrgu maar-yingayn. ");
INSERT INTO nuy_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Anubani-yung wani-yamijgayn, “Nugurru a-yangi yungguyung marri nurru-ḏirrngawina? Yuga nurru-jambarrgiiyn ngayawi-wuy?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Anubani-yung wurrugu wurru-ḏirrngawiiyn, marri ngijang wurru-waḻaaḻarriyn. Marri anubani-yung wurru-yambiynjini, wurru-yamaa, “Yangi-nyung yuga naagi? Numburraarranggang a-wudhanguyn-guy marri anubani aa-gugu! Anubani-yung ninggu-warra-yandhurrbang!” wurru-yamayn wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Anubani-yung wurraagaḻawajangi wagagala-wuy, wubani a-lhal wirri-mayana Gerasa. ");
INSERT INTO nuy_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Anubani-yung na-Jesus naagi-yung ni-garrajiyn mana-barrawu-wala. Nubagi-yung waḻyinyung buguni ni-yanggi. Naagi-yung ni-yanggi yuwaagala ama-gara-wala. Anubani-yung niwu-waṉagaa aladi-windiyung man.gurrg. ");
INSERT INTO nuy_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Naagi-yung ni-bu-burri yuwaagu ama-ṉuga-rruj ama-gara-rruj. Anubani ana-wulhu-wulhurr anaani-yung waari warraaynbaj ambunu-radbini naagi-yung. Anubani-yung ana-chain wirri-mangi wunu-radbini, waari aadani-yung, niwu-wagiwaa. ");
INSERT INTO nuy_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Warraawurru-yung warra-mulung-aynbaj wunu-nani, malgarrawindi anaani-yung ni-radbidhi ana-chain-mirri. Anubani-yung niwu-warra-wagiwaa. Marri anubani-yung ni-lhuganda-radbidhi-yinyung anubagu, niwu-wagiwaa, ana-dhuduju. Waari naagi-yung ambunu-maṉdhangi. ");
INSERT INTO nuy_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Anubanila niiḏangi-magaa mana-ṉuga-wala, anubagu nima-milimilidhangi-yinyung mana-gara, ana-miyn.ngu marri anaarrarra. Anubani-yung niiḏangi-magaa marri ni-balhini ṉuga-mirri. ");
INSERT INTO nuy_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Marri anubani-yung nu-nayn naagi-yung na-Jesus malanganyanay. Marri ni-wuwaḻgayn marri ni-ḻandharrdhangayn. ");
INSERT INTO nuy_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Na-Jesus ni-yamayn, “Ba-rabalang, aladi-nyung man.gurrg!” Nigaayung niiḏangi yanggarrwar-mirri, “Yagu a-yangi yungguyung nagang anubagala nimba-warubaj-gaa Jesus, na-Niwiyayung na-God-jinyung ni-burraa-yinyung anuwaagi anaarrwar? Ngunu-lhangayaana, anubani-yung na-God-inyung ana-muwaj, yagi ngaya nimbaarragayangijgi!” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Na-Jesus anubani-yung nu-yandhawiwayn, “Yangi-nyung nagang aadanu na-nimuwaj-jung?” Nigaayung ni-yamayn, “Ngaya-waj anaani na-nimuwaj-jung ‘arrawindi’, dani-yung ngaya ana-muwaj, anaani yamba ngagurru warraarrawindi,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Anaani-yung ana-man.gurrg ninggu-lhangayaani, wu-yamayn, “Nurru anaani yagi nimbi-yarramijgi anaanila-wala ana-lhal,” ninggu-yamijgayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Anubani-yung arrawindi bigi-bigi wu-ngarra-ngu-burri anubagu amubama-rruj ama-ṉuga. ");
INSERT INTO nuy_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ninggu-yamijgayn ana-man.gurrg, “Nurru anaani nimba-lharrgang wudanu-wuy naambu-waliynjang,” wu-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nigaayung ni-yamayn, “Yuu, numburru-yaarri.” Anubani-yung marri ninggaarruyn ana-man.gurrg, nubagi-yung-gala na-wurrujung. Nga wu-yanggi wuguni wu-waliynjiyn wubani-wuy a-bigi-bigi-wuy. Anubani-yung anaarrawindi, anubani-yung wu-mulung-galiynjiyn-gala aḏaba anubani-yung 2000. Marri anubani-yung bagala nga waagulhaynjiyn yuuguni a-dhirridhirrig-guy marri wu-ngarra-ngalbawaḻgayn wubani-wuy aa-gugu-wuy. Marri anubani-yung wu-warra-ngaṉḏini wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bagu warruburru-yung warra-waḻya-waḻya wurru-ranga-rangarrangi-yinyung anubani-yung ana-bigi-bigi. Warruburru-yung wuu-yarramayn nga yuuguni warra-magaa warra-mulung-aynbaj-guy, wubani-wuy a-wumurrng-guy wubani a-runggal, marri yuuguni a-lhal-aynbaj-guy a-lhal. Marri warraawurru-yung warra-wurru-wurruj wurru-yanggi. “Yangi anubani wu-waṉbini?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Marri wurru-yanggi na-Jesus-guy marri anubani-yung wurraarranggayn, nubagi-yung na-wurrujung bagu ni-burri. Naadagi-yung ni-waṉagaa anubani-yung arrawindi ana-man.gurrg ana-raga-ragij-gaj, yagu anubani-yung winiinggarra-ngu-burri na-Jesus. Ni-yabini yaaḻi aḏaba, nigawi-nyinyung-duj a-yinag anubani-yung wu-wandhurrg aḏaba, ni-wijangani-yinyung niga. Warraawurru-yung wunu-nani-yinyung niga naadagi-yung, wurru-ḏirrngawiiyn wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Warruburru-yung warra-mulung-arrgi-yung wunu-nani-yinyung, warraawurru-yung warra-magaa wugurru, naagi-yung-jinyung wubani-yung-jinyung aarrawindi a-man.gurrg marri wubani-yung a-bigi-bigi. ");
INSERT INTO nuy_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nga warraawurru-yung wunu-lhangayaani na-Jesus, “Bawu-lhal-warruyn anaani nurri-nyinyung ana-lhal marri ba-yaarri!” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Marri anubani-yung ni-yanggi ama-barrawu-wuy, ni-yabaynjiyn. Nigaayung naagi-yung na-waḻyinyung anubani-yung ana-man.gurrg-jinyung niwu-waṉagaa, naagi-yung bagu nu-yandhawiwandi na-Jesus-guy, “Yuga ngaya anaani ngaynjaarri nugawi-wuy?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yagu nigaayung na-Jesus ni-yamayn, “Yagi. Baagiyn nugawi-wuy aanga-wuy, nugawi-wuy warra-mijgalgur-wuy. Bamba-magana anubani-yung ninii-gaṉbini-yinyung na-Buunggawa nugawi-nyinyung, anubani-yung ana-mamanunggu. Bamba-magana anubani-yung, nini-man.galagaa-yinyung,” ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Marri nigaayung na-waḻyinyung niigiyn, anubani-yung ni-yanggi, bagu wani-magaa warruburru-yung warra-mulung-aynbaj wubani-rruj a-lhal wirri-mayaa Decapolis, anubani-yung naa-gaṉbini-yinyung na-Jesus. Wugurraayung warraarrawindi wurru-wurrij-gaḻaaḻarriyn wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Anubani-yung na-Jesus niigaḻawajangi wubani a-wurugu-rruj barrawu-mirri, marri warruburru-yung wurru-wurruj wurru-yanggi wunu-warubaj-gaa, wurraanggarra-ngu-burri bagu a-wurugu-rruj. ");
INSERT INTO nuy_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nubagi-yung niwu-ranga-rangarrangi-yinyung anubani ana-synagog, na-nimuwaj-jung Jairus. Marri ni-yanggi, nu-nani na-Jesus. Marri ni-ḻandharrdhangayn ni-burrdangayn wubani raga-ragij nigawi-rruj a-mun-duj. ");
INSERT INTO nuy_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Marri nu-yandhawiwaa na-Jesus, “Ngayawi-nyinyung ngarra-ngarriiyi lhaalhag angi-ngawang. Baaṉiyn marri bangu-waṉagang nugawi-nyinyung-mirri marang, marri angi-maṉdhiiyn, angi-wiri-mang.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Marri na-Jesus winiinggarra-yanggi wuguṉi. Warruburru-yung warraarraarrawindi wunu-garrindharrmiyn. Warruburru-yung wunaaṉibijgayn wurru-wurruj-bugij. ");
INSERT INTO nuy_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ngigaayung ngarra-maṉinyung bagu nga wurraanggarra-yanggi warruburru-rruj warraarraarrawindi-rruj. Anubani-yunggaj ngaadagi-yung ngarra-maṉinyung nginggu-lhangarrmayn wulang maadbarrwini. Anaani-yung anaagalhal-aḻirr 12. ");
INSERT INTO nuy_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ngarraagi-yung ngi-yanggi warruburru-wuy warra-maja-maji-wana-yinyung warruburru-wuy, marri anubani-yung ngiwu-lhaladangi arrawindi anu-ṉuga. Yagu waari ngarraagi-yung angi-maṉdhini. Anubani-yung ngi-warragayangi-wugij, ngi-lhangurrngandi-wugij ngiga. ");
INSERT INTO nuy_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Anaani-yung ngi-wawanggini naadagi-yung na-Jesus. Anubani-yung ngi-yamijgini ngigaajbaj, “Ngama-waṉagang-maynji mana-yaaḻi nigawi-nyinyung, marri ari nga-maṉdhiiyn!” Anubani-yung ngi-yanggi bagu adhaadharri na-Jesus-duj warruburru-rruj warra-mandagarrawindi-rruj, marri anubani-yung ngi-marang-dhaayiyn ngima-waṉagayn mana-yaaḻi. ");
INSERT INTO nuy_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Anubanila-wala manubama-yung mana-wulang lhugaajgiyalawaj ma-wuldhiyn. Anubani-yung ana-ngun.gu ngi-yangini-yinyung aḏaba ngi-maṉdhiiyn ngiga. ");
INSERT INTO nuy_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nigaayung na-Jesus anubani-yung ni-marrbuy nigaajbaj, anubani ana-lhuḏ ninggaarruyn, na-Jesus-gala. Marri anubani-yung ni-wiḻibiḻingiyn wani-yamijgayn warruburru-wuy warraarraarrawindi-wuy, “Yangi-nyung ngaya ngambii-bildhiyn mana-yaaḻi?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yagu warruburru-yung wurru-marrbuy-maa-yinyung wurru-yamayn, “Yigaj, yaawurru-yung wuu-juriynjini marri nimbii-bildhiyn, nimbi-jurrjurrgina warraawurru. Marri a-yangi yungguyung aadanu nagang nuynjambina, ‘Yangi-nyung ngambi-wildhiyn ngaya?’” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yagu niga ni-warranggaa-wugij, ambani-nani yungguyung yangi-nyung wu-waṉbini. ");
INSERT INTO nuy_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ngaadagi-yung ngarra-maṉinyung ngi-marrbuy aadani-yung wu-waṉbini-yinyung ngigawi-wuy, marri ngi-ḏirrngawiiyn, ngi-warra-galaliyn. Marri anubani-yung ngi-jarrarriyn nga bagu ngi-ḻandharrdhangayn raga-ragij nigawi-rruj. Anubani-yung ngunu-magaa ana-lhaawu yijgubulu-walawaj, ngi-wij-ḏabalini ngiga. ");
INSERT INTO nuy_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nigaayung ngu-yamijgayn, ngigawi-wuy, “Ngarriiyi, nagang yamba nu-ngu-jambarrgiiyn, aadanu aḏaba nu-maṉdhiiyn. Ba-yaarri, ba-lhamaamura, marri ba-maṉdhiiyn,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Anubani-yung ni-yambini-wugij, warruburru-yung warra-wurru-wurruj anubagala wuu-ngarra-ḏaba-rabaliyn aanga-wala nubagi-yung-jinyung niwu-ranga-rangarrangi-yinyung ana-synagog. Warruburru-yung wurru-yamayn, “Nugawi-nyinyung ngarra-ngarriwiyaay aḏaba ngi-ngawiiyn. Aḏaba yagi nunu-yandhawiwu nigawi-wuy wani-yiyina-yinyung,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yagu anubani-yung na-Jesus waari ambanii-gawanggini, warruburru-yung. Nubagi-yung nu-yamijgayn nubagi niwu-ranga-rangarrangi-wuy, “Yagi nu-ngu-ḏirrngawi. Anaani nimbaa-ngu-jambarrgiiyn ngaya,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Anubani-yung winiinggarra-yanggi naadagi-yung na-Jairus, marri Peter, marri James, marri John, na-James-inyung na-nilharri-yung, wurraanggarra-yanggi wugurru. Naadagi-yung waari ambani-lharrgandi warruburru-yung waari amburraanggarra-yanggi, warra-mulung-aynbaj. ");
INSERT INTO nuy_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Anubani-yung wurru-yanggi wubani a-wumurrng-guy nubagi-yung niwu-ranga-rangarrangi-yinyung. Nigaayung na-Jesus ni-warranggayn arraarrawindi wuu-ruguni… wurraaḏangi… wurraalgarra-rawaynjini wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Anubani-yung ni-yanggi ni-yabiyn, marri ni-yamayn, “A-yangi yungguyung nugurru nurraaḏii marri nuu-ruguna? Ngarraagi ngarra-wirrinyung waari angi-ngawini, ngiga ngi-yingayn,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yagu warraawurru-yung wunu-rajburrnani niga. Nigaayung wani-lharrgang yuuguni aa-ḏabarabalu-wuy. Wani-yarrijgini nubiṉi-yung nga-rriibi-yung-bugij marri na-ninyarra-yung, wurraanggarra-yanggi. Marri burru-yung-bugij wurru-wulaynbaj. Anubani-wuy wuu-yanggi ama-gara-wuy. Ngiga ngarrubagi-yung ngarra-ngaḻaynjinyung bagu ngi-murrgulhi. ");
INSERT INTO nuy_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ni-yanggi-wugij, ngu-waṉja-ḻaḻagayn. Anubani-yung ngu-yamijgayn, anubani-yung nigawi-nyinyung-mirri ana-lhaagi ni-yambiyn, “Talitha kumi!” ni-yamayn. Anaani wiijamana, “Ngaḻaynjinyung, ba-ḻaḻagiiyn!” ");
INSERT INTO nuy_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Anubani-yung ngi-ḻaḻagiiyn, marri ngi-yanggi. Ngarraagi-yung 12 anaagalhal-aḻirr. Warraawurru-yung wurru-wurrij-gaḻaaḻarriyn-bindiyung, marri warraawurru-yung wurraarra-wilwiliyn. ");
INSERT INTO nuy_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Na-Jesus anaani-yung ni-yambini wu-waḏa-waḏaḏ ana-lhaawu. “Yagi anaani narra-magi warruburru-wuy warra-mulung-aynbaj-guy. Nimbirringiiyn, angi-nguyii marrya,” Dani-yung ni-yamayn niga. ");
INSERT INTO nuy_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Anubani-yung na-Jesus niwaarruyn ana-lhal. Anubani-yung ni-yanggi nigawi-wuy wubani-wuy a-lhal-wuy. Marri warruburru-yung wurru-marrbuy-maa-yinyung wugurru wurraanggarra-yanggi. ");
INSERT INTO nuy_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ngarrubagi-rruj ngarraaḻirr-maṉngulg-duj bagu ni-burri wubani-rruj a-synagog. Bagu wani-magaa. Marri burru-yung wunu-yaynjangani-yinyung wurru-wurrij-gaḻaaḻarriyn. Marri wurru-yamayn, “Marri naagi ajigala wunu-marrba-marrbuy-waa? Yangi-nyung? Anaani ana-lhaawu aniijgubulu-walawaj ni-yambina! Ajigala ni-waṉbini aynba-gaynbaj lhuḏ-mirri? ");
INSERT INTO nuy_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Naagi niwu-rana-raani-yinyung. Nigawi-nyinyung nga-rriibi-yung Mary, marri nigawi-nyinyung warra-minilharri-yung na-James marri na-Joseph marri na-Jude marri na-Simon, warruburru-yung. Marri warra-miyn-ngarrilharri-yung yaawurru ngurraanggarra-ngu-burraa,” wurru-yamaa. Marri wunaagaminij-gaandirrangi niga. ");
INSERT INTO nuy_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yagu nigaayung na-Jesus wani-yamijgayn wugurri-wuy, “Warruburru-yung wunaa-ja-jambini-yinyung na-God, warra-wurru-wurruj wugurraayung warraagaminij-gaandirrangi, warruburru-yung wugurri-nyinyung-jinyung anubani-yung ana-lhal, marri wugurri-nyinyung warruburru-yung warra-mijgalgur-yung, marri wugurri-rruj anubani ana-wumurrng. Anubani-yung ana-lhal-aynbaj-gala ana-lhal, wurru-yanggi warruburru-yung, warra-ngaynbandangi wugurru,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yagu anubani-rruj ana-lhal, waari ani-waṉbini aniij-mamaaḻang ambani-maṉmangi-yinyung. Yagu wani-waṉagaa nigawi-nyinyung-gala a-marang wurru-burri bagu wurraadharra, marri wani-ḻaḻagaa. ");
INSERT INTO nuy_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Anubani-yung ni-wurrij-dhimudiyn warruburru-yung yamba warra-wurru-wurruj waari ambuu-jambarrgini wugurru. Marri anubanila-wala ni-yanggi wubani-wuy a-lhal-aynbaj-guy, aaynbaj-guy a-wumurrng, wubani wu-ridiynjini-rruj. Marri bagu wani-magaa. ");
INSERT INTO nuy_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Marri warruburru-yung warra-12 wanii-gaḏiyn nigawi-wuy. Marri waniini nigawi-wala lhuḏ nguynju yungguyung wubani-yung a-man.gurrg yungguyung ambanggu-yandhurrbangaa. Anubanila-wala wani-lharrgandi wurru-wulu-wulawaa-wugij wurru-yanggi wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Marri ni-yamayn, “Yagi nurraarra-yarrijgi anaarrawindi anubani-yung-maynji numbuu-yaarri. Bani-yung-bugij nimbirri-waṉagana, waaṉḏulu, numburru-wagaralhina-yinyung. Marri yagi nuu-yarrijgi ana-marrya. Marri yagi ana-yirr nirri-waṉagi, yagi manaarrgi-yung mana-yaaḻi. Yagi nirri-waṉagi anu-ṉuga. ");
INSERT INTO nuy_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Damu-wugij, numburru-mun-jabina-yinyung. Yagu yagi nirrima-waṉagi manuulawaa mana-yaaḻi yagu dami-yung-bugij nuu-yabina-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Anubani-yung-maynji numburru-yaarri anubani-wuy anaanga-wuy, bagu numburru-burraa baḏag wurrugu. Wurrugu marri, numburru-wurrij-dhaḻagina-maynji, marri bani-yung nugurru numburru-yaarri anubagala ana-lhal-wala, nimbirriirruyn. ");
INSERT INTO nuy_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Yagi-maynji warruburru-yung warra-wurru-wurruj nugurru nambi-ngaynbandi, marri yagi-maynji nambii-gawanggi anubagu, anubani-yung nimbirriirruyn ana-wumurrng, nga manubama-yung nimbirrima-ngarrgiwang nurru-mun-jabina-yinyung nugurru, marri nimbirrima-yaljalang. Anubani-yung nambarra-yiyina wugurru, warruburru-yung wurru-waṉbini yamba aladi.” Dani-yung ni-yamaa na-Jesus, wani-magaa warruburru-yung wurraanggarra-yanggi-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Marri anubani-yung aḏaba wurru-yanggi, marri warra-magaa. “Nimbirriij-garruyn aniij-galaaladi,” wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Anubani-yung warra-garra-yarraani arrawindi ana-man.gurrg. Warraawurru-yung wuu-lhangurrngandi, yagu warraawurru-yung wugurraayung warraambara-wuryangi wugargayag, marri warra-ḻaḻagaa wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Warruburru-yung warraarrawindi warra-wurru-wurruj wurru-marrbuy naagi-yung na-Jesus. Anaani-yung nubagi-yung na-king na-Herod ni-wawanggini anaani-yung ana-lhaawu. Warra-mulung-arrgi-yung wurru-yamaa, “Na-Jesus nubagi niga na-John nubagi waniimbara-ngambijgaa-yinyung, niga nubagi-yung ni-ḻaḻagiiyn anubanila-wala ana-ngawij! Dani-yung-gala niwu-waṉagana ana-lhuḏ marri ni-waṉbini,” wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Warra-mulung-arrgi-yung warruburru-yung wurru-yamaa, “Naagi Elijah!” Marri warra-mulung-aynbaj wurru-yamaa, “Naagi ari nubagi-yung naa-ja-jambina-yinyung, nguynju warruburru wunaa-ja-jambini-yinyung wu…bani-yunggaj,” wurru-yamaa wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Yagu nigaayung na-Herod anaani-yung ni-wawanggiyn ana-lhaawu, marri ni-yamayn, “Na-John, nubagi nganu-waḻwag-guldhiyn ngaya-waj, ngijang ni-wiri-mayn, yagu God nu-ḻaḻagayn!” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Anubani-yung ana-wulhu-wulhurr anaani-yung wu-waṉiyn. Na-Herod-jinyung na-nilharri-yung na-Philip ngarraagi-yung niiynji-yaay ngarra-ngarrimuwaj-jung Herodias. Marri na-Herod nigaayung ngu-miyn, ngijang niga-waj niiynji-yaay ngiga. Nigaayung na-John ni-yamayn na-Herod-guy, “Yagi nunaa-gaṉa-mi na-nilharri-yinyung yagu anaani waari aniij-mamaaḻang-magaa,” ni-yamayn. Wudani-yung-gala, nigaayung na-Herod nu-magaa aynjaabu-nyung wurrujung, anubuguni ni-yanggi, nga bagu nu-miyn, nga nu-radbini. Marri wunu-yarrijgini yuuguni wubani wu-dhi-dhidini-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ngigaayung ngarraagi-yung ngarra-maṉinyung ngunu-wurrij-bangaa naagi-yung na-John. Ngunu-ngaynbandangi ambunuumana, yagu waari angiwiij-dhangarrmaa angunu-wini yungguyung. ");
INSERT INTO nuy_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Yagu anubani-yung na-Herod naagi-yung ni-ḏirrngawiiyn na-John-guy, aadani-yung ni-marrbuy naagi na-John ni-maṉngulg, marri ni-maaḻamburrg. Marri na-Herod naagi-yung nu-maṉmiyn. Marri ni-wawanggini nigawi-wuy, anubanila-wala ni-yinag-gabaabaynji, nigawi-rruj ana-yinag. Yagu anubani-yung nu-ngaynbandangi nu-yaynjangani, malgarrawindi. ");
INSERT INTO nuy_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Anaani-yung na-Herod-jinyung birthday wurru-burri. Ngigaayung ngarraagi-yung ngarra-Herodias ngi-wijangani, “Wudani-rruj aḏaba bagu ambunu-bilhargang na-John!” ngi-yamayn. Nigaayung na-Herod, runggal wurru-nguni marrya, warruburru-yung warra-runggu-runggal, anubani-rruj-jinyung ana-wumurrng, marri warruburru-yung wurru-wiynji-wiynjini-yinyung warra-runggu-runggal, marri warruburru-yung warra-mulung-aynbaj warra-runggu-runggal wurru-burri-yinyung ana-Galilee. ");
INSERT INTO nuy_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ngarraagi-yung ngarra-Herodias-jinyung ngarra-ngarrimarayung, ngi-yanggi ngi-wan.ngaa, wunggayn. Marri bani-yung na-Herod ni-waḻaaḻarriyn, marri warruburru-yung warra-mulung-aynbaj wurru-waḻaaḻarriyn wugurraayunggaj. Marri nubagi-yung na-king ngu-yamijgayn, “Nimba-yandhawiwana-maynji anubani-yung anaarrgi-yung, marri anubani-yung wiiyii,” ni-yamayn, ");
INSERT INTO nuy_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","“Nimba-yandhawiwana anubani arrawindi ngayawi-wuy, anubani arrgi anaanila a-lhal-wala, marri wiiyii,” ni-yamayn, ngu-lhalamayaa ngiga. ");
INSERT INTO nuy_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ngigaayung anaani-yung ngi-yanggi, nga ngu-magaa nga-rriibi-yung-guy, “Marri yangi ngaya nganu-yandhawiwana?” ngi-yamayn. Nga-rriibi-yung ngigaayung ngi-yamayn, “Banu-yandhawiwanjii lhal-ngargu anu-nindhagal-guldhang na-John waniimbaambara-ngambijgaa-yinyung,” ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Anubani-yung ngiigiyn-gaj-bugij ngi-nguḻu-nguḻubini nubagi-wuy na-king-guy. Marri ngunu-yamijgayn, “Nimbiiyn anubani-yung ngayawi-wuy ana-yinag na-John, arrwar ama-plate-duj,” ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yagu anubani-yung na-king ni-yimurr-jiwuriyn. Yagu anubani-yung ni-wawanggini anubani-yung ngu-lhalamayaa-yinyung, marri ni-warranggaa warruburru-wuy warra-mulung-aynbaj-guy. Waari anubani-yung angu-yang-ngu-biḻigagaa. ");
INSERT INTO nuy_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nubagi-yung naa-gaḏiyn nubagi-yung wurru-wiynji-wiynjini-yinyung na-lhamugarrijung, marri nu-yamijgayn, “Nimbi-yarrijgiyn wudanu a-yinag yaanuwuy.” Nigaayung ni-yanggi nubagi-yung buguni wubani-wuy wu-dhi-dhidina-wuy, marri warruburru-yung wunu-yinag-guldhiyn na-John-jinyung a-yinag. ");
INSERT INTO nuy_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Marri anubani-yung niwu-burriyn buguni amubama-wuy ama-gaṉdharra-wuy. Marri anubani-yung ngu-yayn buguni ngarrubagi-wuy ngarra-ngaḻaynjinyung-guy, anubani ngiwu-yarrijgini nga ngu-yayn nga-rriibi-yung-guy. ");
INSERT INTO nuy_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Na-John-jinyung anaani-yung wurraawanggiyn warruburru-yung wurru-marrbuy-maa-yinyung. Marri wurru-yanggi bagu, na-ni-gubulu-nyung naagi-yung wunu-miyn wubani-wuy warra-wurrdhu-wurrdhangi-wuy. Wunu-wurrdhangi aḏaba. Wudani-yung-gala nga, na-Herod ni-yambini na-Jesus-jinyung, niin-jamayn, “Naagi-yung John!” ni-waḻamin-jamaa niga. ");
INSERT INTO nuy_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Warruburru-yung yaga wani-lharrgandi-yinyung, ngijang warraawurru-yung aḏaba wurraagiyn nigawi-wuy na-Jesus-guy, marri wunu-magaa, “Anaani-yung aḏaba nurru-waṉbini arrawindi, marri narra-magaa,” wurru-yamaa wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Arraarrawindi wurru-yanggi anubagala marri anubuguni wurraagini. Na-Jesus marri warruburru-yung wurru-marrbuy-maa-yinyung, wugurraayung waari ambuu-yanga-yanga-yangini, waari ana-marrya amburru-ngunu-nguni. Yagu naagi-yung na-Jesus wani-yamijgayn, “Ngaambu-yaarri, ngaambu-wiri-wiri-gina, warruburrala-wala warra-wurru-wurruj-gala, wubani-wuy a-lhamaamura-wuy a-lhal, marri bagu ngaambu-burraa wurrugu ngaambu-yanga-yangina,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Aḏaba warraawurru-yung wurru-yanggi barrawu, marri wurru-yanggi wubani-wuy a-lhamaamura-wuy a-lhal, nguynju yungguyung bagu wurru-burri wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Yagu arraarrawindi wurru-marrbuy anubani-yung. Warruburru-yung warra-nani wurru-yanggi, wugurru wurru-ngarrg-dharrmangi wurru-wayamangi danila wugurraayung, wurraagulhaynjini wungarrg-galawaj, wubanila-wala a-wumurrng-gala. Wugurru-waj anubagu ana-raga-ragij wurru-waliyn. ");
INSERT INTO nuy_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nigaayung na-Jesus marri warruburru-yung wurru-marrbuy-maa-yinyung anubagu wurru-waliyn, wurraadadiyn anu-ngarrg-duj, wurraarranggayn yuuguni garnyirrimba. Na-Jesus naagi-yung ni-yamayn, “Warraawurru-yung nguynju yaga wudanu a-jib-jii, waari yaga warraaynbaj ambu-ranga-rangarrang,” ni-yamayn, wani-warrngayuyn naagi-yung. Marri anubani-yung ni-yanggi, wani-magaa, wiij-garrawindi ni-yambini niga. ");
INSERT INTO nuy_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Aḏaba waadhaadharrwara-maa. Wugurru warruburru-yung nigawi-nyinyung wurru-marrbuy-maa-yinyung wurru-yanggi buguni nigawi-wuy marri wurru-yamayn, “Anaani yagu a-lhamaamura-rruj ngurru-burraa. Anaani aḏaba waadhaadharrwara-mana. ");
INSERT INTO nuy_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Bamba-lharrganjii warraawurru warra-wurru-wurruj aḏaba nguynju yadhu wugurru aḏaba amburru-yaarri buguni wubani-wuy aanga aani-rruj a-lhal, marri amburru-mani wugurri-nyinyung marrya,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yagu nigaayung na-Jesus ni-yamayn, “Nugurru-waj nambarriiyii wugurru warruburru-yung amburru-nguyii,” ni-yamayn. Wugurraayung wurru-yamayn, “Yagi yuga nurru-waj nurru-rumi marri narraa-mi ana-marrya? Warraaynbaj-magaa ambu-mijgalmini-magaa na-ḻabama marang-aynjaabugij marri ani-wulawaa, marri ambi-waṉagaa-wugij anu-ṉuga, ambu-mangi-magaa ana-marrya.” Dani-yung wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nigaayung ni-yamayn, “Wu-ngargu aadanu ana-marrya nurru-waṉagana? Numburru-yaarri bagu numburraarra-nayii,” ni-yamayn. Wurru-yanggi bagu, wurru-nani. Wurraagiyn nga wunu-yamijgayn, “Anaani marang-aynjaabugij anu-ḏayn marri wulawaa ngujija,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nigaayung wani-yamijgayn warruburru-wuy warraarraarrawindi-wuy, “Numburru-burrangang wudanu a-maḏa-nguḏigu-rruj a-maḏa. Daju nugurru numburraambargalang, nugurraayung bagu numburru-muṉḏugang, nugurraayung yuwaagu numburru-muṉḏugang, numburraaḻgaaḻgaḻ, numburru-muṉḏugana,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Marri warruburru-yung wurru-muṉḏugaa, wurraaḻgaaḻgaḻ-waj. Warruburru-yung wurru-muṉḏugaa-yinyung warra-mulung-aynbaj 50 yagu anuwaagu warra-mulung-aynbaj wugurraayung wurru-muṉḏugaa-yinyung 100. ");
INSERT INTO nuy_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Anubani-yung aḏaba niwu-miyn anubani-yung ana-marang-aynjaabugij anu-ḏayn marri ana-wulawaa ana-ngujija, marri yaanuwuy ni-mal-nayn arrwiyaj, marri nu-warraarriwaa na-God. Anubani-yung anu-ḏayn ni-rayn-bawayuwaa aḏaba, waniini anaani-yung warruburru-yung-guy wurru-marrba-marrbuy-maa-yinyung. Marri buguni warriini warra-wurru-wurruj-guy. Marri anubani-yung ni-muṉḏuwaa ana-ngujija marri waniini warruburru-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Marri wurru-nguni, marri wurru-waḻarrandi, bani-yung marri. ");
INSERT INTO nuy_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nga aḏaba wurru-mangi wurru-muṉḏugaa anu-gamuymuy, manubama-yung mana-gaṉdharra, 12. Anu-gamuymuy buguni wurru-burrangi, anu-ḏayn-jinyung marri ana-ngujija-yinyung wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Muga warraawurru-yung warra-waḻya-waḻya 5000 wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Anubanila-wala, wani-yamijgayn warruburru-yung wurru-marrbuy-maa-yinyung, “Numbuu-yaarri ama-barrawu-wuy, marri numbuu-yaarri numbuu-ragaana buguni Bethsaida-wuy,” ni-yamayn. Anubani ana-lhal Bethsaida anubani wagagala a-wurugu. Wani-yamijgayn warra-garnyirrimba, “Numbuu-ngarra-gaagiyn aḏaba aanga-wuy,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Marri waniirruyn warruburru-yung marri yuuguni niidadiyn amubama-wuy ama-magabang-guy, ni-yambini na-God-guy niga. ");
INSERT INTO nuy_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Wurrugu anubani-yung ngarraaḻirr ngi-dhaarri aḏaba, magurraayung mana-barrawu aḏaba ma-yarbiyn wubani-wuy a-wurugu aḏaba. Nigaayung anubagu ni-burri ni-wiri-wiri anaadadin-duj. ");
INSERT INTO nuy_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Warraawurru-yung wani-nayn, wurru-madhandangi, wudhanguyn yamba wu-wayamangi yuwaagala, wanggu-raganmayn, marri bani-yung wurru-madhandhangi wugurru. Wurrugu ni-burri, wu-biinga-mudangi yamba, wurrugu ngu-rangarrangi ngarrubagi-yung ngarraaḻirr ngiimbarra-nagini lhaalhag. Marri bani-yung ni-jarrarriyn wubani-wuy aa-gugu-wuy. Marri anubani-yung lhaalhag ani-yaḻdhangi. ");
INSERT INTO nuy_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Warraawurru-yung wugurraayung wunu-nayn. Ni-yangga-yanggi aa-gugu-waj. Yagu anubani-yung warraawurru-yung wurraan-jamayn anubani-yung baḏirrnya. Marri wurru-wuwudangi, ");
INSERT INTO nuy_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","wuu-ḏirrngawiiyn-bindiyung warraawurru-yung. Nga nigaayung wani-yamijgayn, “Wiiya! Anaani ngaya-waj. Yagi nurru-ḏirrngawi, numburru-wurrij-baabara,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Anubani-yung ni-yabaynjiyn wugurri-wuy aḏaba. Marri anu-dhanguyn wu-muḏaḏbiyn. Yagu anubani-yung wurru-wurri-ḻaḻmayn-bindiyung, yagu waari yamba amburru-marrbuy-maa, anubani-yung yaga anu-ḏayn ni-warra-ḻibi-ḻibawaa, aadani-yung-gala waari amburru-marrbuy-maa, yagu yamba wurru-yina-baḏa-waḏaḏ wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Anubani-yung wurraagaḻawajangi aḏaba wurraadadangi wagagala-wuy, wubani a-lhal-wuy wu-mayini Gennesaret. Bagu wirrima-radbang. ");
INSERT INTO nuy_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Wugurraayung warruburru-yung wugurru warra-wurru-wurruj wurru-nguynju-gayn niga na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Anubani-rruj ana-lhal wurraagulhaynjini marri warraarra-mangi warruburru-yung warru-dhu-dhangurrg, waa-yarrijgini buguni, ama-yaaḻi-rruj. Wurraawanggini-magaa, “Naagi-yung aḏaba bagu ni-waliyn.” Marri anubanila, wurraagulhaynjini-magaa warraarra-mangi. ");
INSERT INTO nuy_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Anubani-yung ni-yanggi-magaa buguni wubani-wuy aanga-wuy. Anubani warraarra-mangi-magaa warraawurru-yung warra-murrgulhangi warraarra-guṉḏa-guṉḏa-yinyung, anubani-rruj yaga wuu-yamba-yambiynjini-rruj, wurru-muṉḏu-muṉḏugaa. Naagi-yung na-Jesus wunu-yandhawiwandi-magaa, “Warruburru-yung wurru-lhangurrngandi-yinyung, ambi-yaaḻi-waṉagang amubama-waj ama-mangudhig-duj,” wurru-yamaa-magaa. Yagu warruburru-yung warraarraarrawindi wunu-yaaḻi-waṉagaa, wurru-maṉdhini-magaa wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Warruburru-yung warra-Pharisee marri mulung-aynbaj warra-yiyini-yinyung ana-lhaawu-runggal, warruburru-yung anubanila ana-Jerusalem-jinyung, anubani-yung wunu-muṉḏugayn naagi-yung na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Anaani ana-lhaawu-runggal wu-yamana, “Numburru-marang-jarrbina,” bani-yung wu-yamana. Warra-mulung-aynbaj warruburru-yung na-Jesus-jinyung wurru-marrbuy-maa-yinyung waari anaani-yung amburru-waṉbini. Yagu warraawurru-yung wurru-nguni arrbidi, waari amburru-marang-jarrbini wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Warruburru-yung warra-yiyini-yinyung ana-lhaawu-runggal marri warra-Pharisee warra-nani. Warra-Pharisee marri warraarrawindi-lhangu warra-Jew, warruburru-yung wirri-yandhurrbangaa anaani-yung ana-lhaawu-runggal anaarrawindi-lhangu, warruburru-yung-jinyung warra-mi…yn-ngambara-yinyung. Warraawurru-yung wurru-marang-jarrbini ana-raga-ragij, marri bani-yung malgadhaadharri wurru-nguni ana-marrya. ");
INSERT INTO nuy_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Anubani-yung wurru-muṉḏugaa-wala anubagala, warruburru-yung wuu-ngarra-ḏaba-rabalangi anubagala, anubani-yung wuu-yarrbini mal-ḏaga-ragij-gaj, marri bani-yung malgadhaadharri wurru-nguni. Marri wirri-waṉagaa arrawindi ana-lhaawu-runggal, ama-gaṉdharra yungguyung wirrima-yarrbini, marri amubama-yung ama-runggu-runggal-inyung ama-gaṉdharra wirrima-yarrbini, marri mana-gaṉdharra ma-maṉdhini yiiḻi-mirri, dama-yung ngijang wirrima-yarrbini wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yagu anubani-yung warra-Pharisee marri warra-yiyini-yinyung ana-lhaawu-runggal wunu-yandhawiwandi na-Jesus, “A-yangi yungguyung nagang warruburru wurru-marrbuy-maa-yinyung, waari amburru-waṉbini nguynju warruburru-yung warra-mi…yn-ngambara wirriij-maṉdhangi? A-yangi yungguyung waari amburru-marang-jarrbini marri wurru-nguni ana-marrya?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yagu nigaayung wani-yamijgayn, “Nubagi-yung naa-ja-jambini-yinyung na-Isaiah, ni-yambini yijgubulu-windiyung nugurri-nyinyung. Nugurru aadanu nurraambaḻaman-gina nugurraajbaj, yagu ana-lhirribala wu-miḏaamimi. Ana-lhaawu anaani wu-yamana anaani-rruj a-wubiba, na-God ni-yamaa, ‘Warra-wurru-wurruj wuu-yambina a-ramadhan-gala, “na-God ni-mamanunggu,” yagu anaandhiri anubani wu-burraa malanganya…nay ngayawi-wala. ");
INSERT INTO nuy_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yagu warruburru-yung ngambi-warraarriwana arrbidi, Anaaynbaj ana-lhaawu wiijanggi warra-wurru-wurruj-gala, yagu warruburru-yung warra-magana warra-mulung-aynbaj, anaani wiijanggi ngayawi-wala, yagu waari.’ Dani-yung na-God ni-yamaa, waarrarrina a-wubiba-rruj.” ");
INSERT INTO nuy_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Naagi-yung na-Jesus wani-magaa-wugij. “Nugurru aadanu nirriirruna na-God-jinyung-gala a-lhaawu-runggal, nirri-waṉagana nirri-waḏa-waḏaḏ-gana ana-lhaawu aadanu warra-wurru-wurruj-jinyung.” ");
INSERT INTO nuy_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Naagi-yung ni-yambini-wugij, “Nugurru aadanu nurru-wijangayii wiij-miḏaamimi marri nurru-waṉbina aadanu anggiijamang na-God-jinyung-magaa waari. Nguynju yungguyung anubani-yung numburru-waṉbina nugurri-waj nimbirri-ngaynbandang-maynji! ");
INSERT INTO nuy_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Numburru-marrbuy anubani-yung na-Moses ni-yambini, (Exodus 20:12) ‘Banu-yandhurrbangana na-ninyarra marri nga-rriibi,’ ni-yamayn, marri ngijang, (Exodus 21:17) ‘Warraaynbaj-maynji warrubawa-yung ambu-yambina anaaladi na-ninyarra-yung-guy marri nga-rriibi-yung-guy, yijgubulu anubani-yung ambu-ngawang,’ dani-yung ni-yamayn na-Moses. ");
INSERT INTO nuy_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","“Yagu na-wurrujung-maynji ari ani-yamang na-ninyarra-yung-guy marri nga-rriibi-yung-guy, ‘Anubani-yung ana-bayarra nuguṉi-nyinyung, yagu aḏaba nganu-yayn na-God-guy aḏaba,’ ari ani-yamang. Nugurru warra-Pharisee nurru-yamana, aḏaba wiiya, wiij-maṉdhina aḏaba, dani-yung nurru-yamana. ");
INSERT INTO nuy_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nubagi-yung numbunu-lhambiyn yagi wani-yu ni-ninyarra-yung-guy marri nga-rriibi-yung-guy. ");
INSERT INTO nuy_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Anaani-yung wiijamana, anubani-yung nirriijaḻgiwijgana ana-lhaawu na-God-jinyung, nugurri-nyinyung-gala a-lhaawu, marri anubani-yung narra-yiyina warra-mulung-aynbaj-guy. Marri arrawindi, wiijamana, nurru-waṉbina.” Dani-yung ni-yamayn na-Jesus, wani-magaa warruburru-yung warra-yiyini-yinyung ana-lhaawu-runggal marri warra-Pharisee wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Anubanila-wala anubani-yung niga na-Jesus wanii-gaḏangi warruburru-yung warra-wurru-wurruj nigawi-wuy, niga ni-yamayn, “Numburraawanggina nugurru aadanu warraarraarrawindi, marri numburru-marrbuy-mana anaani. ");
INSERT INTO nuy_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Waari-magaa anubani-yung-magaa warra-wurru-wurruj ambirri-burrang-jinyung anubuguni wugurri-nyinyung-guy, waari wanggaaladi-wi. Yaani nga ambanggaaladi-wana, anubani-yung wu-rabalii wugurri-wala. Yaani nga ambanggaaladi-wana wugurru.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Marri anubani-yung ni-yanggi anubagala warruburrala-wala, ni-yanggi yuuguni a-wumurrng-guy. Warruburru-yung wurru-marrbuy-maa-yinyung bagu nga wunu-yandhawiwandi, wubani-yung a-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nigaayung na-Jesus ni-yamayn, “Yuga nugurraayunggaj nurru-maḻaḻadi, nurru-yamana nguynju warruburru-yung-jii? Yagu waari numburru-marrbuy-maa, anubani-yung anaarrawindi-lhangu ana-marrya anubani-yung wu-yabina wugurri-wuy warra-wurruj-guy, waari anubani-yung wanggaaladi-wi, yuga? ");
INSERT INTO nuy_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Anggu-yaarri-maynji anaanu-wuy wugurri-wuy mana-gulmung-guy, yagi anubani wu-burrangi anaandhiri-rruj. Marri anubanila wu-rabalii ana-wubulu-wala.” Dani-yung ni-yamayn. Yagu anaani ana-lhaawu na-Jesus anaani-yung ni-yambini ana-marrya, anaani wu-warra-mamanunggu. ");
INSERT INTO nuy_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Marri bani-yung ni-yamayn, “Anubani-yung anggu-rabalang-maynji warra-wurruj-gala, marri bani-yung ambanggaaladi-wang. ");
INSERT INTO nuy_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Yaani warruburrala-wala warra-wurru-wurruj-gala, wugurri-wala aandhiri-wala. Wurru-wijangayii alaaladi, warrubawa-yung yaga yigaj warra-waḻya-waḻya marri warra-maṉaṉung wurru-maynjina yaga. Marri wurraamajaa, warra-mulunguwa-wana, ");
INSERT INTO nuy_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","warraagamajaa warra-maṉaṉung, warraa-garra-ngaynbandii warraaynbaj-jinyung arra, wurraaṉbina aladi, wurraawaḻii, waari amburru-burrangang ana-maaḻamburrg, wurru-margirajaa, anubani-yung warraarra-yamawaynjina warra-mulung-aynbaj-guy, wurru-lhama-lhamina, wurru-yilg-balii. ");
INSERT INTO nuy_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","“Aadanila-yung-galawaj wu-yaarri lhirribala-wala. Marri bani-yung nambanggaaladi-wana nugurru.” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Anubanila-wala na-Jesus ni-yanggi anubanila-wala ana-lhal. Ni-yanggi wunumbiyaj wubani-wuy a-lhal a-Tyre-wuy marri a-Sidon-guy. Anubani-yung ni-yanggi buguni wubani-wuy a-wumurrng-guy. Naagi-yung ani-julubini bagu yungguyung. Yagu warraawurru-yung warra-wurru-wurruj wurru-marrbuy. ");
INSERT INTO nuy_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ngarraagi-yung ngarra-ngaḻaynjinyung ngiwu-waṉagaa anubani-yung man.gurrg aladi. Yagu nga-rriibi-yung ngarraagi-yung ngi-wawanggini naagi-yung na-Jesus. Marri ngi-yanggi, marri ngi-ḻandharrdhangayn nigawi-rruj raga-ragij a-mun-duj. ");
INSERT INTO nuy_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ngarraagi-yung ngarra-maṉinyung waari angi-Jew-magaa. Anubani ana-lhal wu-mayina Phonecia, wubani-rruj a-Syria-yinyung. Ngarraagi-yung ngunu-yandhawiwandi, “Bawu-barawudang wubani a-man.gurrg ngarrubagi-yung ngarra-marig-jinyung,” ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nigaayung na-Jesus ngu-yamijgayn ngigawi-wuy, “Waari nurru nurru-mi anubani-yung ana-marrya warruburrala-wala warra-mijburrayung-gala marri narra-yu wugurri-nyinyung warra-ḻandhurrg-guy, waari aadanu anggiij-maṉdhiiyn.” ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ngigaayung ngi-yamayn, “Yii Buunggawa! Yagu waa-ḻandhurrg wugurru ambu-burraa-maynji ana-lhirribala, anubani-rruj wurru-nguyu-nguyii-rruj, marri ambu-nguyii anubani-yung wugamuymuy anggaadbarrwina-yinyung, anubani-yung warra-mijburrayung-jinyung wubani a-marrya,” ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nigaayung ni-yamayn, “Nagang yamba nuynjambini aadanu ana-lhaawu, marri nu-jambarrgina, ba-yaarri aanga-wuy. Ngarrubagi nginggaarruyn ana-man.gurrg, ngarra-ngarrimarig, ngigawi-wala.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ngarraagi-yung ngi-yanggi. Ngarrubagi-yung ngarra-wirrinyung ngi-murrgulhii ama-yaaḻi-rruj, anubani-yung waaṉibiyn ana-man.gurrg aḏaba. ");
INSERT INTO nuy_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Wurrugu malgadhaadharri, anubani-yung ni-yanggi anubanila-wala ana-lhal wu-ridiynjini anubani ana-lhal ana-Tyre. Ni-yanggi wubani-wuy a-Sidon-guy. Ni-yaḻdhangi marri buguni ni-yanggi a-wurugu-wuy, Galilee-wuy. Marri buguni ni-yanggi anubani-waj Decapolis. ");
INSERT INTO nuy_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bagu wunu-yarrijgini wurrujung nigawi-wuy. Naagi-yung ni-wan-mudangi, marri naagi-yung waari ani-yamba-yambini ana-maaḻamburrg. Wunu-yandhawiwayn na-Jesus, “Banu-waṉagang naagi,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nigaayung na-Jesus nu-miyn naagi-yung, nu-yarrijgini warruburrala-wala warra-wurru-wurruj-gala. Naagi-yung na-Jesus amubama-wuy ama-warang-guy nu-warang-araa, marri ni-wa-judiyn marri nu-lhayn-baṉagayn. ");
INSERT INTO nuy_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Marri ni-mal-nayn arrwiyaj, a-wumala-wuy, marri ni-ngayn.gayayn runggal. Marri ni-yamayn, “Ephatha.” Anaani wiijamana, ba-warang-bawalhang. ");
INSERT INTO nuy_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Marri ni-wan-bawalhi, marri wugurraayung ana-lhayn anubani wu-wirbirini, marri maaḻamburrg ni-yambini niga. ");
INSERT INTO nuy_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Na-Jesus anubani-yung wani-yamijgayn, “Yagi narra-magi warruburru-wuy warra-mulung-arrgi-yung,” ni-yamayn. Yagu warra-magaa warruburru-yung warra-mulung-aynbaj. Yagu na-Jesus wani-yamijgayn ngijang, yagu ngijang marri ngijang warra-magaa, warruburru-wuy warraarraarrawindi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Warraawurru-yung warra-wurru-wurruj wurru-wurrij-gaḻaaḻarrangi windiyung. Marri wurru-yamayn, “Naagi ni-waṉbini maaḻamburrg-galawaj! Warrubawa-yung wu-wan-mudii-yinyung, marri wu-wawanggina! Marri warra-lhaawu-wari-yinyung, warrubawa-yung wurru-yambina!” Dani-yung wurru-yamaa wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Anubanila-wala malgadhaadharri, warraawurru-yung arraarrawindi wurru-waliynjini. Yagu waari ana-marrya amburru-waṉagaa. Na-Jesus wanii-gaḏiyn warruburru-yung wurru-marrbuy-maa-yinyung, ");
INSERT INTO nuy_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","marri ni-yamayn, “Warruburru warra-garnyirrimba wurraanggarra-yanggi aḏaba ngi-waḻirr-wulaynbaj. Waari ana-marrya amburru-waṉagaa. Ngaya ngarra-warrngayuyn, ");
INSERT INTO nuy_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","warraawurru yamba wurru-marryaadii. Ngaya anubani waari ngarra-lharrgi wugurru wurru-marryaadi-yinyung anubani-magi wugurru wurru-rabingun-magi wurru-yanggan-magi aanga-wuy. Warraawurru yamba a-jarrmayarrmaj-gala a-lhal warraawurru wuu-yanggi.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yagu wugurraayung wurru-marrbuy-maa-yinyung wurru-yamayn, “Marri yangi-mirri warraawurru ngaamba-marrya-wuyii ana-marrya? Ngagurru anaani ngurru-burraa a-yarrmayarrmaj anubanila-wala anaanga,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nigaayung ni-yamayn “Wu-ngargu yuga anu-ḏayn nugurru anubani nurru-waṉagana yuga?” ni-yamayn. Wugurraayung warraawurru-yung wurru-yamayn, “Marang-aynjaabugij marri wulawaa.” ");
INSERT INTO nuy_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yagu wani-magayn warruburru warraarrawindi, “Numburraambargalang daju aaban-duj,” ni-yamayn. Anubani-yung niga ni-miyn ana-marang-aynjaabugij marri anuulawaa anu-ḏayn, marri nu-warraarriwaa na-God-guy, nga niga ni-rayn-bawaayuwaa anubani-yung ana-marrya, marri waniini warruburru-yung wurru-marrbuy-maa-yinyung, marri anubani-yung warriini warruburru-wuy warra-wurru-wurruj. ");
INSERT INTO nuy_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Marri anubani-yung wurru-waṉagaa wunyu-wunyanyung ngujija. Marri anubani-yung ni-yambini ngijang na-God-guy. Nga wani-magayn warraawurru-wuy, “Anaani warruburru-wuy nambarriiyii ngijang,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Anubani-yung aḏaba warruburru-yung wurru-nguni marri wurru-waḻarrang. Anubanila-wala, warruburru-yung wurru-marrbuy-maa-yinyung wurru-ragaa anu-gamuymuy, manaama-yung mana-gaṉdharra marang-aynjaabugij marri muulawaa, wurru-yabaa buguni. ");
INSERT INTO nuy_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Warraawurru-yung wurru-burri anubagu 4000 warra-wurru-wurruj. Anubanila wani-lharrgang. ");
INSERT INTO nuy_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Aḏaba ni-yabaynjiyn ama-barrawu-wuy, marri warruburru-yung wurru-marrbuy-maa-yinyung, wurraanggarra-yanggi. Marri anubani-yung wurraagaḻawajiyn buguni anubani ana-lhal Dalmanutha. ");
INSERT INTO nuy_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Warruburru-yung warra-Pharisee wurru-yanggi marri anubani-yung wurru-wundi nigawi-wuy. Marri wunu-rawini nigawi-wuy, “Nimba-bajiyina malnguj aarrwar-wala.” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nigaayung ni-wurrij-galadi-wiiyn ana-lhirribala. Ni-yamayn, “A-yangi yungguyung nugurru warra-wurru-wurruj wurru-wiri-mana-yinyung ana-yimbaj, nurraarranggana ana-malnguj? Yijgubulu, niga na-God waari nani-bajiyi ana-malnguj, nugurru warra-wurru-wurruj.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Marri anubani-yung waniirruyn, ngijang wurru-yabaynjiyn amubama-yung-bugij ama-barrawu, wurraagaḻawajangi wagagala-wuy wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yagu anubani-yung wurru-warandhalabiyn, waari anubani-yung amburru-waṉagaa anu-ḏayn. Aynjaabugij bagu wu-burri wuḏayn, ana-marrya. ");
INSERT INTO nuy_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Na-Jesus anaani-yung ni-yamaa, “Numburru-dhi-maṉdhina aadanu, anubani-yung-jinyung anu-ḏayn warruburru-yinyung warra-Pharisee-yinyung marri nigaayunggaj na-Herod-jinyung,” ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wugurraayung warruburru-yung nigawi-nyinyung wurru-marrbuy-maa-yinyung wurru-yambini anubani-yung-jinyung. “Anubani-yung niga ni-yambini ngagurru yamba ngurru-warandhalabiyn, waari anubani-yung ngaambu-waṉagang anu-ḏayn,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yagu nigaayung na-Jesus ni-marrbuy, anubani-yung wugurru wurru-yambiynjini-yinyung. Naagi-yung ni-yamayn, “A-yangi yadhu nugurru aadanu nurru-yambiynjina waari numburru-waṉagang anu-ḏayn nugurri-nyinyung? Yuga nugurru waari numburru-marrbuy-dhini? Yuga nugurru aadanu nurru-yina-baḏa-waḏaḏ? ");
INSERT INTO nuy_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Damu bagaḻang nimbirrima-waṉagana! Yagu waari numburraarranggang? Yagu damu warang! Yagu waari numburraawanggang, yuga? Marri waari nurru-wijangi anubani-yung? ");
INSERT INTO nuy_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nurru-marrbuy anubani-yung nga-rayn-bawaayuwaa ana-marang-aynjaabugij anu-ḏayn warruburru-yung-jinyung 5,000? Ma-ngargu mana-gaṉdharra anu-gamuymuy-yinyung, nurru-yabaa manubama-wuy?” ni-yamayn. Wugurraayung warraawurru-yung wuu-yamayn, “12 yagu.” ");
INSERT INTO nuy_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nigaayung na-Jesus ni-yamayn, “Marri nga-rayn-bawaayuwaa marang-aynjaabugij marri wulawaa anu-ḏayn, warruburru-yung-jinyung warra-4000-jinyung. Ma-ngargu mana-gaṉdharra, anubani-yung anu-gamuymuy nurru-yabaa manubama-wuy?” ni-yamayn. “Marang-aynjaabugij marri muulawaa,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Yuga waari aadanu numburru-marrbuy-maa?” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Anubanila-wala, wurru-yanggi anubani-yung Bethsaida-wuy. Mulung-aynbaj warruburru-yung wunu-yarrijgini nubagi-yung ni-bagaḻang-aladi. “Banu-waṉagana,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Marri nu-waṉjaaṉa-ṉimayn nubagi-yung na-bagaḻang-aladi-nyung. Anubagala naaṉa-ṉimaa anubanila-wala ana-wumurrng-gala. Marri nu-ba-judangi nubagi-yung-guy marri nu-bagaḻang-baṉagayn. Marri nu-yandhawiwayn, “Yuga nunggarranggana yuga?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nigaayung na-waḻyinyung nubagi-yung ni-warranggayn marri ni-yamayn, “Ngarra-nayii wurru-wurruj, nguynju wudani a-rangag-jii wurru-yaarri,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ngijang nigaayung na-Jesus nu-bagaḻang-baṉagayn, nu-ba-bulagayn. Yagu nigaayung nubagi-yung yingga ni-marang-galiyn niga nubagi-yung na-wurrujung, ni-warranggayn amaningaḏajung. Marri bani wani-nayn ana-maaḻamburrg. Mana-bagaḻang manubama-yung ni-bagaḻang-maṉdhiiyn. ");
INSERT INTO nuy_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Na-Jesus naagi-yung nu-lharrgang buguni nigawi-wuy aanga-wuy. Yagu nu-magayn, “Yagi nuṉḏumi anubuguni anaaynbaj-guy anaanga-wuy,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Na-Jesus marri nigawi-nyinyung wurru-marrbuy-maa-yinyung, wurru-yanggi wubani-wuy aanga-wuy, wubani warubaj ana-Caesarea Philippi. Wani-yandhawiwayn, “Warruburru-yung yuga warra-wurru-wurruj wugurru, ngaya anaani yuga wurraaḻamin-jamaa, yangi-nyung ngaya?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wugurraayung wurru-yamayn, “Warra-mulung-arrgi wurru-yamana nagang aadanu John, nubagi-yung yaga waniimbara-ngambijgaa-yinyung. Warra-mulung-aynbaj wurru-yamana nagang aadanu Elijah. Warra-mulung-aynbaj wurru-yamana nagang aadanu warruburru-yung yaga wunaa-ja-jambini na-God-jinyung,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nigaayung ni-yamayn, “Yagu nugurru aadanu, yangi-nyung yuga nugurru nurru-yamana ngaya anaani?” ni-yamayn. Marri na-Peter nigaayung nu-yambalmayn, “Nagang aadanu na-Christ, na-Messiah, na-runggal-yung na-God-gala,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nigaayung na-Jesus wani-yamijgayn, “Yagi narra-magi ngaya anaani,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Marri anubani-yung wani-magaa ngijang, nigawi-mirri, nii-jamijgini, “Ngaya anaani na-Niwiyayung na-Wurrujung-jinyung, anaani ngambambii-garragayii runggal-windiyung. Warruburru-yung warra-mijiwanggu, warra-runggu-runggal warra-priest marri warra-yiyini-yinyung ana-lhaawu-runggal, ngambambiindirrii ngaya. Warra-mulung-aynbaj warruburru-yung ngambambiimana. Marri amuulawaa-wala mana-miyn.nganga wurrugu, ngaya nga-ḻaḻagiiyn ana-ngawij-gala.” Dani-yung ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Anubani-yung ni-yambini anaani-yung ana-lhaawu, anubani wiij-garrarra. Nigaayung na-Peter nu-ḻaḻagayn, “Baaṉiyn yuwaagu, naynjambiynjina.” Marri ni-yamayn, “Yagi nunggaṉbi!” ");
INSERT INTO nuy_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yagu na-Jesus nigaayung ni-wiḻibiḻingiyn marri ni-warranggaa buguni warruburru-wuy wurru-marrbuy-maa-yinyung. Nu-yamijgayn, na-Peter-wuy, “Ba-yaarri baagiyn yuuguni a-mugarri-wuy, Satan! Nagang aadanu waari na-God-jinyung-magaa, nagang aadanu warra-wurru-wurruj-gala nu-ngu-burraa,” ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Warraawurru-yung wurru-marrbuy-maa-yinyung wurraanggarra-yanggi. Wanii-gaḏiyn warruburru-yung warraarraarrawindi nigawi-wuy. Marri ni-yamayn, “Nugurru-maynji ngirri-ngaynbandii-maynji anubani-yung ngirri-garrindharrmani ngaya, anubani-yung nugurru numburru-yiynjang marri nimbirri-warrgu anu-ḏangag marri bani-yung ngirri-garrindharrmani ngaya. ");
INSERT INTO nuy_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","“Na-wurrujung-maynji anubani-yung aniwu-waṉagana-maynji nigawi-nyinyung ana-wiri, wurrugu marri yijgubulu anggu-wurag. Yagu anubani-yung-maynji aniwaarruyn-maynji ana-wiri nigawi-nyinyung, ngayawi yungguyung, marri ngayawi-nyinyung yungguyung ana-lhaawu, wurrugu marri nubagi-yung ani-wiri-mang. ");
INSERT INTO nuy_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nubagi-yung-maynji na-wurrujung aniwu-mang-maynji anaani ana-lhal-lhangu, yagu wurrugu marri anggu-wurag nigawi-nyinyung ana-wiri, aadanu wiijamana yij-galadi. ");
INSERT INTO nuy_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nubagi-yung-maynji na-wurrujung ani-bayarra-giiyn-maynji nigawi-nyinyung ana-wiri, yuga anubani-yung wiij-maṉdhina? Yangi ana-bayarra? Waari! ");
INSERT INTO nuy_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Anaani ana-malg-jimbaj, warraarrawindi warra-wurru-wurruj wurru-waṉbina aladi-windiyung marri wurru-yarramana na-God-gala. Warrubawi-yung-maynji warraaynbaj ngaya ngambii-gambulii anaani, marri ngayawi-nyinyung ana-lhaawu, ngaya-waj nga anaani na-Niwiyayung na-Wurrujung-jinyung, anaani warrubawi-yung ari ngaya ngambaa-gambulang warrubawi-yung, wurrugu marri anubani-yung ngandaagiyn-maynji anuwagala, wubani-rruj wu-milhiynjina-rruj na-Baba-yinyung, marri anubani-yung ana-angel ana-maṉngulg.” Dani-yung ni-yamaa na-Jesus, na-nidhaawu-yung. ");
INSERT INTO nuy_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Marri naagi-yung ngijang ni-yamayn, “Ngaya anaani ngana-magana nugurru aadanu yijgubulu-windiyung, mulung-arrgi-yung nugurru aadanu aḏaba nurraarra-garra-lhara, numbunu-nayii na-God, ambani-rangarrii nigawi-nyinyung warru-mandag, lhuḏ-mirri, numburru-wiri-waj-bugij aadanu.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Marang-aynjaabugij marri jarranggay anubani-yung malgadhaadharri, na-Jesus wani-mangi na-Peter marri na-James marri na-John. Anubani-yung wuu-yanggi amubama-wuy ma-ḻandhirrngindi-wuy ama-ṉuga. Anubagala wurru-yanggi, warraarruyn. Nga bagu wunu-nani. Nigaayung na-God naagi-yung naaynbijgayn. ");
INSERT INTO nuy_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Manaama-yung mana-yaaḻi nigawi-nyinyung ma-ngalngalangi windiyung. Warraaynbaj waari wirrima-yarrbu mana-yaaḻi ma-yami, maadami-yung-jii. ");
INSERT INTO nuy_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Warraawurru-yung wurraarranggayn, Elijah marri Moses, wurraanggarra-garra-lhi na-Jesus. Marri wurru-yambiynjini, nigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nigaayung na-Peter ni-yamayn na-Jesus-guy, “Buunggawa, anaani nurru wiij-maṉdhina nurru-burraa nugawi-rruj. Nanggu-maṉdhii angguulaynbaj ruluj, aynjaabugij nugawi-nyinyung, aynjaabugij na-Moses-inyung marri aynjaabugij na-Elijah-yinyung,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Waari anaani ana-lhaawu wugurru anggu-wandhurrg-maa, yagu nigaayung na-Peter waari anaani ani-marrbuy-maa niga, warraawurru-yung yamba wurru-ḏirrngawiiyn-bindiyung wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Anubani-yung ngubunung yuwaagala wu-yanggi, warruburru-wuy wugurru wanggaambamadhiyn. Marri wubanila-wala a-ngubunung-gala yang wu-rabaliyn. God ni-yambini a-ngubunung-gala. “Naagi ngayawi-nyinyung na-Nigi, ngaya nganaa-ḏamarr-ngu-burraa. Nigawi-wuy numbunaa-gawanggina aadanu.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Lhugaajgiyalawaj warruburru-yung wurraarra-garranggaa, yagu Jesus-bugij anubagu ni-burri. Waari warraaynbaj anubagu. ");
INSERT INTO nuy_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Anubani wurraarra-ḻaḻagiiyn aḏaba wurru-dhirridangi amubama-waj ama-ṉuga-waj. Nigaayung na-Jesus ni-yamayn, “Yagi warraaynbaj narra-magi anubani-yung nurraarra-nani-yinyung. Ngaya, na-Niwiyayung na-Wurrujung-jinyung, anubani-yung nga-ḻaḻagiiyn ana-ngawij-gala. Marri bani-yung nambarra-magana,” ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Wudani-yung-gala, anubani-yung wirri-waṉagaa ana-lhaawu bagu wugurri-rruj, marri anubani-yung wurru-yandhawiwaynjini, “Yangi yuga anubani ani-ḻaḻagiiyn ana-ngawij-gala, wiijamana?” wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Marri warraawurru-yung wunu-yandhawiwandi na-Jesus, “Wuu-yaminggarrini wuu-yambini warra-yiyini-yinyung ana-lhaawu-runggal, na-Elijah ani-yaarri raga-ragij, nubagi-yung naa-ja-jambini-yinyung na-God, anu…bani-yunggaj?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nigaayung na-Jesus ni-yamayn, “Yuu, danu nga na-Elijah ani-ragayang ani-yaarri, ana-wulhu-wulhurr, marri ani-warra-maṉdhii anaarrawindi-lhangu. Yagu nugurru aadanu numburraawanggina anaani-yinyung wu-yambina anaani-rruj ana-wubiba-rruj, ngaya anaani, na-Niwiyayung na-Wurrujung-jinyung, ngaya arrawindi nganggarragayii, anubani-yung, warra-mulung-aynbaj warruburru-yung amburraan-jamana, ngaya ngaaladi? ");
INSERT INTO nuy_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","“Yagu ngaya ngana-magana nugurru, niga na-Elijah bani-yung aḏaba ni-yanggi. Yagu anubani-yung wurru-waṉbini runggal-windiyung aladi nigawi-wuy, nguynju-waj wugurru wirri-ngaynbandangi wurru-waṉbini-yinyung, nguynju ana-lhaawu anaani wu-yamana.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Warraawurru-yung wuu-dhirridangi amubama ama-ṉuga-wala. Marri buguni wurru-yanggi warra-mulung-aynbaj-guy warruburru-wuy wurru-marrbuy-maa-yinyung. Yagu wurraarranggayn yagu arraarrawindi wurru-wurruj wurru-muṉḏugaa. Warraawurru-yung warra-yiyini-yinyung ana-lhaawu-runggal wurru-wundi, warruburru-wuy wurru-marrbuy-maa-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Warraawurru-yung warra-garnyirrimba wurraarranggayn wunu-nayn na-Jesus, marri wurru-wurrij-gaḻaaḻarriyn. Marri wurru-yarbiyn nigawi-wuy, marri wunu-yambini wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nigaayung wani-yandhawiwayn, “A-yangi yungguyung nugurru nuu-yambiynjina?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Aynbajung warra-garnyirrimba-rruj nu-yambalmayn, “Barra-yiyina-yinyung, nganu-yarrijgini ngayawi-nyinyung na-nigi nugawi-wuy. Naagi man.gurrg niwu-waṉagana, wu-lhaawu-wari. ");
INSERT INTO nuy_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ana-man.gurrg anaani, anubani-yung ninggu-mani marri ninggu-barawudii aaban-guy, marri anubani-yung ni-lhagar-lhililii. Marri ni-ra-bangaynjina, marri anubani-yung na-ningun.gu-yung ni-waḏa-waḏaḏ-mana. Ngarra-yandhawiwayn warruburru wurru-marrbuy-maa-yinyung nugawi-nyinyung, ambunaa-ngu-barawudangi naagi, wubani a-man.gurrg, yagu waari amburru-waṉbini wugurru.” Dani-yung ni-yamaa na-waḻyinyung. ");
INSERT INTO nuy_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Na-Jesus nigaayung ni-yamayn, “Nugurru aadanu warra-wurru-wurruj waari numburru-jambarrgiiyn! Yuga ngaya anaani nga-ngu-burraa baḏag nugurri-rruj yuga? Anaani ngaya nga-ngu-burraa baḏag nugurri-rruj, nga-lhambaamburrg yamba ngaya marri anambaa-gaṉbina nugurri-wuy anaani, yuga? Banu-yarrijgiyn na-wirrinyung yaanu-wuy.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Marri naagi-yung wunu-yarrijgini nigawi-wuy. Ana-man.gurrg anaani-yung ninggu-nayn na-Jesus. Lhugaajgiyalawaj naagi-yung na-wirrinyung ninggu-warra-galalangijgayn marri ni-rabini aaban-guy, anubani-yung ni-wadbarrwini aaban-baj marri ni-lhagar-lhililangi. ");
INSERT INTO nuy_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Na-Jesus naagi-yung nu-yandhawiwaa naadagi-yung-jinyung na-wirrinyung-jinyung na-ninyarra-yung, “Naagi-yung lhal-ngargu niwu-waṉagaa anaani-yung?” ni-yamayn. Nigaayung ni-yamayn, “Naagi-yung ni-wirrig-gaj, ni-gujuju-waj,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Anaani ana-man.gurrg, malgarrawindi ninggu-barawudangi ana-ngura-wuy marri yuuguni aa-gugu-wuy, nguynju yungguyung ani-ngawini. Nagang-maynji baaṉbang, nimba-warrngayang marri nimba-maṉmang niiṉi anaani,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nigaayung na-Jesus ni-yamayn, “A-yangi yungguyung nuynjamaa, ‘Nagang-maynji baaṉbang’? Warrubawa-yung-maynji ambu-jambarrgina, marri anaarrawindi-lhangu ari anggu-waṉbina,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Na-ninyarra-yung naagi-yung niiḏangi, “Nga-jambarrgiiyn! Nimba-maṉmang, nguynju yungguyung runggal nga-ngu-jambarrgina,” ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Warruburru-yung warraarraarrawindi anuwagala wurru-wuwaḻgayn, nga warra-dhawawarumayn naadiṉi-yung wini-yambiynjini-yinyung. Nigaayung na-Jesus wani-nani marri anubani-yung ni-yambini wu-waḏa-waḏaḏ ana-lhaawu wubani-wuy a-man.gurrg-guy. “Ramadhan-gari-nyung, warang-ari-nyung man.gurrg, ba-rabalang nigawi-wala, marri yagi nundaagi naagi-wuy,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Wugurraayung ana-man.gurrg anubani-yung waaḏangi, marri naagi-yung ninggu-warra-galalangijgayn runggal, marri anubani-yung wu-rabaliyn nigawi-wala. Naagi-yung na-wirrinyung ni-murrgulhi-wugij, waari ani-ḻaḻagini nguynju yaga waadawu waa-ngawina-yii, ni-yamaa. Warruburru-yung warraarraarrawindi wurraan-jamayn, “Naagi-yung ni-ngawiiyn.” ");
INSERT INTO nuy_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yagu na-Jesus naagi-yung ni-waṉja-ḻaḻagayn, nigaayung ni-ḻaḻagiiyn. ");
INSERT INTO nuy_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Na-Jesus anubani aḏaba ni-yanggi anubagala wubani-wuy a-wumurrng-guy, warruburrala-wala warra-garnyirrimba. Warraawurru-yung wurru-marrbuy-maa-yinyung wunu-yandhawiwang, “Yagu nurru anaani-yung waari naambu-barawudangi ana-man.gurrg?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nigaayung wani-yamijgayn, “Yagi nugurru nurraarra-yarramijgi anubujujung-gala. Yagu numbunu-yandhawiwana-maynji na-God, bani-yung-bugij numburraarra-yarramijgana.” Dani-yung ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Anubani-yung wurru-yanggi anubagala, wurru-yanggi bagala-yung Galilee-waj, waari warraawurru-yung warra-mulung-aynbaj amburru-marrbuy-magaa. ");
INSERT INTO nuy_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Burru-yung-bugij wurru-marrbuy-maa-yinyung wani-bajiyini. “Ngaya-waj yaani nga na-Niwiyayung na-Wurrujung-jinyung. Wurrugu, ngambambi-yarrijgina warruburru-yung-guy warra-mulung-aynbaj-guy. Marri warruburru-yung ngambambi-ngawijgang ngaya. Wurrugu amuulawaa-wala mana-miyn.nganga, ngaya anaani nga-ḻaḻagiiyn.” Dani-yung ni-yamaa ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Waari anubani-yung amburru-marrbuy-maa ana-lhaawu. Anubani-yung wurru-ḏirrngawini, waari ambunu-yambiḻibiḻingaani niga. ");
INSERT INTO nuy_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Marri anubani wurru-yanggi Capernaum-guy. Anubagu ana-wumurrng anubagu, marri wani-yandhawiwandi, “Anubani-yunggaj ngurru-yanggi manaadi-waj, nurru-yaminggarrini nugurru nurru-yambiynjini?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yagu waari anubani ambunu-yambalmaa. Yagu anubani-yunggaj, manaadi-waj wurru-yanggi, wurru-yambiynjini, “Yangi-nyung yuga nubagi-yung na-runggal-yung, ngagurri-wala?” ");
INSERT INTO nuy_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Anubani-yung na-Jesus ni-burrangayn. Anubani wanii-gaḏiyn warraawurru-yung 12 wurru-marrbuy-maa-yinyung. Marri anaani ni-yamayn, “Nubagi-yung-maynji aniwu-ngaynbandii ani-raga-ragij, nubagi-yung ani-lhamarrii, marri nubagi-yung ambanii-mijgalmina warruburru-yung warraarrawindi.” Dani-yung ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Anubani-yung nu-miyn wirrinyung, nga nu-waṉjaaṉa-ṉimaa nga nu-lhangijgayn wugurri-rruj wurru-marrbuy-maa-rruj raga-ragij. Marri nu-mangi marang-mirri, marri ni-yamayn, ");
INSERT INTO nuy_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Nugurru-maynji nambarra-walgur-wana warra-wirrig nguynju naagi-yung-jii, ngayawi yungguyung, anaani wiij-nguynju, nguynju ngaayunggaj anaani ngirri-walgur-wana ngaya. Marri nugurru-maynji ngirri-walgur-wana ngaya, ari nugurru ngirri-walgur-wi ngayawi-wugij yagi. Nubagi-yung ngani-lharrgang-jinyung, nigaayunggaj numbunu-walgur-wana nugurru.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nigaayung na-John ni-yamayn, “Nimba-yiyina-yinyung, nuunu-nani nurru waḻyinyung ni-warra-yarraani ana-man.gurrg, nugawi-nyinyung-mirri a-muwaj. Yagu nurraayung nuunu-lhambini niga, naadagi-yung yamba waari naambaanggarra-yanggi yamba niga. Waari yamba nagang ani-garrindharrmangi naadagi-yung.” Dani-yung ni-yambini na-John. ");
INSERT INTO nuy_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yagu nigaayung na-Jesus ni-yamayn, “Yagi nugurru aadanu nuunu-muḏaḏbijgi. Warrubawa-yung-maynji warraaynbaj ambu-waṉbina ana-maaḻamburrg marri ngambambi-mayana ngayawi-nyinyung ana-muwaj, marri anubani-yung anaadhaadharri marri, yagi warrubawa-yung ngambiiladi-yamawi ngaya. ");
INSERT INTO nuy_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Warrubawa-yung-maynji yagi-maynji ngurraabalguyungaynji ngagurru, marri warrubawa-yung ngambambi-ngaynbandii anaani. ");
INSERT INTO nuy_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ngubindi ngana-magana nugurri-wuy, warraaynbaj-maynji warrubawa-yung nambambiiyn anaa-gugu nambambi-waḻ-ngujgang, nugurru yamba nirri-waṉagana anubani-yung muwaj na-Christ-jinyung, bawi-yung ambirri-waṉagana ana-bayarra.” ");
INSERT INTO nuy_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Naagi-yung na-Jesus ni-yambini-wugij. “Numbunu-nayii naagi na-wirrinyung. Warraawurru-maynji warra-mijburrayung ambu-jambarrgiiyn ngaya, yagu nubagi-yung-maynji naaynbajung-maynji ambani-lhambumana-maynji, ambanii-dhangu-jujurii-maynji, anubani-yung ana-wulhu-wulhurr warraaynbaj ambirrima-ṉuga-radbiyn ṉuga runggal-windiyung, nubagi-yung-guy ambunu-waḻwag-ḏadbiyn marri anubani-yung ambunu-barawudang anubuguni mana-lhagayag-guy! Aadanu anggiij-maṉdhiiyn, yagi yadhu wani-man-jarramijgi warra-mijburrayung ngayawi-wala.” ");
INSERT INTO nuy_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Naagi-yung ni-yambini-wugij. “Ana-marang-maynji nugawi-nyinyung anubani-yung, anggaaladi-wana, anubani-yung bawu-wuldhang. Ba-yaarri-maynji anubani-yung anaarrwiyaj, ba-wiri-mana-maynji, marri ana-marang-maynji bawu-wuldhang, anubani-yung anggiij-maṉdhiiyn. Yagu ba-yaarri-maynji anubani-wuy wu-naga-nagina-wuy ana-ngura, angguulawaa-maynji ana-marang, aadanu anggiijamana anggiij-galadi-wina. Waari yamba anubani ana-ngura wiiga-ngawi wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","“Ana-mun-maynji nugawi-nyinyung anggaaladi-wana, anubani-yung bawu-wuldhang. Ba-yaarri-maynji anubani-yung anaarrwiyaj ba-wiri-mana-maynji, anubani-yung ba-babaḏii, yagi-maynji nuṉḏumi, anubani-yung anggiij-maṉdhiiyn. Yagu na-God-maynji anubani-yung ani-barawudang anubani-wuy wu-naga-nagina-wuy ana-ngura, wulawaa-mirri ana-mun, anubani-yung anggiijamana anggiij-galadi. ");
INSERT INTO nuy_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nugawi-nyinyung-maynji mana-bagaḻang ama-dhaayurrii marri baaṉbina aladi, bama-ngarrgiwang! Anubani-yung wiij-maṉdhina bama-waṉagana aynjaabugij mana-bagaḻang marri ba-burraa na-God-duj aanga. Yagi-magi nimbi-barawudi-magi buguni a-ngura-wuy wu-nagina, bama-waṉagana-yinyung manuulawaa mana-bagaḻang. ");
INSERT INTO nuy_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Anubani-rruj ana-lhal, dagu yaga nguway waari anubani ani-jadugang, marri anubani-yung ana-ngura waari anggu-yiga-ngawiiyn wugurru.’” ");
INSERT INTO nuy_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Naagi-yung na-Jesus ni-yambini-wugij. “Ana-lhanggu ba-waḻbumana lhanganig-mirri. Na-God nambaniiynbijgang ana-ngura-wala. ");
INSERT INTO nuy_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Naagi-yung niga na-lhanganig ni-lhami-mamaaḻang. Yagu naagi-yung na-lhanganig-maynji yagi waṉagi na-nidhamij, numburru-yaminggarrang nimbiniigijgiyn nubagi na-nidhamij? Nugurru-waj, numburru-waṉbina numburru-guwaj-gaynjina nugurru. Nguynju yaga nugurri-rruj ani-burraa na-lhanganig yaga.” Dani-yung ni-yamaa na-Jesus, na-nidhaawu-yung. ");
INSERT INTO nuy_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Marri anubani-yung na-Jesus niwaarruyn ana-lhal, anubani-yung ni-yanggi buguni wubani-wuy a-Judea-wuy, yuuguni ramaliyaj a-Jordan aala. Arraarrawindi wurru-wurruj wurru-yanggi ngijang nigawi-wuy. Marri wani-magaa ngijang. Anaani ni-waṉbini wuguuguni anaani-yung. ");
INSERT INTO nuy_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mulung-arrgi-yung warra-Pharisee wurru-yanggi na-Jesus-guy, ambunu-dhaayurrangi nigawi-wuy. Wugurru wunu-yandhawiwayn, “Yuga wiij-maṉdhina, na-waḻyinyung-jinyung angaarruyn nigawi-nyinyung ngarra-rangarrina-yung anaarrbidi yuga?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nigaayung wani-yambalmayn, “Wiijaminggarrini anubani-yung na-Moses nani-magaa aadanu ana-lhaawu-runggal?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wugurraayung wurru-yamayn, “Yagu niga na-Moses wani-yayn anubani-yung ana-lhaawu na-waḻyinyung-jinyung angaarruyn nigawi-nyinyung ngarra-rangarrina-yung, anguuyn ngiga ambiniirruynjang-jinyung ana-wubiba.” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nigaayung na-Jesus wani-magaa, “Aadani-yung ni-warrarrangi, aadani-yung yamba nugurru nurru-yinag-baḏa-waḏaḏ. ");
INSERT INTO nuy_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Yagu anubani-yung ana-wubiba waarrarrini, anubani-yung na-God niwu-maṉdhangi anaani ana-lhal, (Genesis 1:27) ‘Niga wani-maṉdhangi na-wurruj-baa, waḻyinyung marri maṉinyung.’ ");
INSERT INTO nuy_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","(Genesis 2:24) ‘Yagu anubani-yung yamba warra-waḻya-waḻya warraarruna warra-mininyarra-yung marri warra-mijbiibi-yung. Marri niga marri nigawi-nyinyung nga-rangarrina-yung, winiiynjaabu wini-yagaynjina, nguynju aynjaabugij ngun.gu.’ Dani-yung ni-yamayn na-God. Yagu waari ambini-wulawaa-magaa, yagu aḏaba aynjaabu-nyung, ");
INSERT INTO nuy_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","na-God wani-waliyn na-wulawaa winiiynjaabu, yagu yagi warra-rajaarrijgi wugurru.” Dani-yung ni-yamayn na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Anubanila-wala, anubagu ana-lhirribala ana-wumurrng-duj, warraawurru-yung wurru-marrbuy-maa-yinyung wunu-yandhawiwandi, wubani-yung-gala ni-yambini, a-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nga nigaayung wani-yamijgayn, “Nagang-maynji bangaarruyn-maynji nugawi-nyinyung nga-rangarrinaaj, marri baaynji-yara ngarraaynbajung-guy, ba-waṉbina aladi-windiyung. ");
INSERT INTO nuy_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Marri ngarrubagi ngarra-maṉinyung-maynji angunaarruyn nubagi-yung naaṉngina-yung, ngarrubagi-yung angiiyni-yara naaynbajung na-waḻyinyung, anubani angi-waṉbina aladi-windiyung.” Dani-yung ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Warraawurru-yung mijburrayung warra-yarrijgini nigawi-wuy, naagi-yung ambiniimbara-waṉagaa warruburru-yung. Yagu warraawurru-yung wurru-marrbuy-maa-yinyung warra-lhambini, “Yagi!” wurru-yamayn wugurri-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yagu nigaayung na-Jesus wani-nayn, marri ni-riyaldhangi. Ni-yamayn, “Nambarra-lharrgang waadurru warra-mijburrayung ngayawi-wuy amburru-yaarri, yagi narra-lhambu. Yagu yamba anubani na-God-jinyung anaanga anaarrwar, anubani wugurri-nyinyung, marri warruburru waadurru-yung-jii. ");
INSERT INTO nuy_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","“Ngaya ngana-magana yijgubulu-windiyung nugurru. Waari nurru-burrangi warruburru-rruj warru-mandag-duj na-God-jinyung. Yagu numburru-yamana-maynji nguynju warra-mijburrayung-jii, bani-yung numburru-burraa wugurri-rruj.” Dani-yung ni-yamaa niga. ");
INSERT INTO nuy_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Marri wani-miyn waadurru-yung warra-mijburrayung nigawi-wuy. Marri wanii-jambini na-God-guy, warraawurru-yung, marri waniimbara-waṉagaa, warraawurru-yung warra-mijburrayung. ");
INSERT INTO nuy_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nga anubani-yung ni-ḻaḻagiiyn marri ni-yanggi ngijang. Naagi-yung waḻyinyung ni-wuwaḻgayn. Marri ni-ḻandharrdhangayn raga-ragij nigawi-rruj. Marri nu-yandhawawandi, “Numba-yiyina-yinyung mamanunggu-yung, yuga ngaya nganggaṉbina, nguynju yungguyung nga-ngu-burraa anggu-wuguuguni ana-wiri?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nigaayung na-Jesus ni-yamayn, “A-yangi yungguyung ngaya nimba-mayana nga-mamanunggu nuynjamana? Nigaaj-bugij yaagi God na-mamanunggu-yung, waari warraaynbaj. ");
INSERT INTO nuy_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nu-marrbuy anubani-yung ana-lhaawu-runggal wu-yamana, (Exodus 20:12-16) ‘Yagi barra-mulunguwa-wi, yagi nurraa-gamajiynji warra-maṉung, yagi barraa-gamajangi, yagi nunggawaḻi, yagi barra-dhaayurrijgi, marri bamba-yandhurrbangana na-ninyarra marri nga-rriibi.’ ” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nigaayung nubagi-yung nu-yambalmayn nigaayung, “Anubani-yung nga-gadhuwa-waj, anaani-yung ngawu-yandhurrbangaa nga anaani-yung murrubu,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Na-Jesus nigaayung nu-nayn, naa-ḏamarr-ngu-burri. Marri ni-yamayn, “Aynjaabugij baaṉbina. Ba-yaarri bambarriiyii nugawi-nyinyung anaarrawindi-lhangu marri bambiiyii anu-ṉuga warraambalalari-wuy, marri nagang bawu-waṉagana runggal-windiyung anaarrwar. Aḏaba nagang baaṉiyn, numba-garrindharrmani ngaya.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Naadagi-yung na-waḻyinyung ni-wawanggiyn. Anubanila-wala ni-yimurr-jiwuriyn, anaani-yung yamba ni-warra-waṉagaa, niimbalal-windiyung naagi-yung na-waḻyinyung. ");
INSERT INTO nuy_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Na-Jesus ni-garri-niiyn marri wani-yamijgayn warruburru-wuy wurru-marrbuy-maa-yinyung, “Aadanu wugurru wiij-baḏa-waḏaḏ, warrubawi-yung warraambalal, yagi anubani wu-rumi na-God-guy nigawi-wuy anaanga.” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Warraawurru-yung wurru-marrbuy-maa-yinyung wurru-wurri-ḻaḻmayn. Nigaayung na-Jesus ngijang wani-yamijgayn, “Ngayawi-nyinyung mijburrayung, anaani wiij-baḏa-waḏaḏ, waari warrubawa-yung wu-rumi anubuguni na-God-guy anaanga-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Anaani wiijamana. Ari anubani ana-gamul anggu-yaarri marri anggu-yabiyn ngarrubagi-yung-guy ngarra-jaarru-wuy ngarra-ngarri-ngu-bagaḻang, ngi-ba-ngu-gara-wawalhii-wuy. Aadanu ari wiij-maṉdhina! Yagu anaani wiij-baḏa-waḏaḏ-bindiyung, warrubawi-yung warraambalal yagi wu-rumi anubani-yung na-God-guy anaanga-wuy.” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Warraawurru-yung wurru-wurri-ḻaḻmayn windiyung. Wugurraayung wunu-yamijgayn, “Yuga yangi-nyung naadagi na-God ambani-wiri-gana-yinyung wugurru?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nigaayung na-Jesus ni-warranggayn wugurri-wuy marri ni-yamayn, “Wugurru warra-wurru-wurruj waari wurru-wiri-gi wugurraajbaj. Yagu na-God ani-waṉbina anaarrawindi-lhangu,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Na-Peter nigaayung ni-yambini aḏaba. “Yigaj, nurru anaani nurraarra-garraarruyn anaarrawindi-lhangu, marri anaani ngunu-garrindharrmangi nagang,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Na-Jesus nigaayung ni-yamayn, “Ngana-magana yijgubulu, nugurru-maynji anaanga nimbirriirruyn, marri warru-nilharri nambarraarruyn, marri warru-ngarrilharri, nga-rriibi-yung marri na-ninyarra-yung, marri warra-mijburrayung, yagu ana-lhal nimbirriirruyn, ngayawi yungguyung, marri ngayawi ana-lhaawu, ");
INSERT INTO nuy_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nugurru nimbirri-lhangarrmang anaarrawindi-lhangu, anaani-yung aḏaba. Wiijamana, anaanga, warru-nilharri-yung marri warru-ngarrilharri-yung, marri nga-rriibi-yung, warra-mijburrayung, marri ana-lhal. Marri warra-mulung-aynbaj nambambi-wungarri-dhijgana. Yagu wurrugu marri malgadhaadharri, numburru-burraa numburraandha-wuguuguni. ");
INSERT INTO nuy_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Yagu warraarrawindi warra-wurru-wurruj ana-raga-ragij, amburru-lhamarrii adhaadharri. Warruburru warraarraarrawindi anaadhaadharri-yinyung, wugurraayung burru-yung amburru-ragaana.” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Warraawurru-yung wurru-yanggi wirrimaadi-lharrmangi, wurru-yanggi buguni, wurraadadangi Jerusalem-guy. Na-Jesus nigaayung a-raga-ragij ni-yanggi. Warraawurru-yung wurru-wurri-ḻaḻmayn, niga yamba ni-yanggi anubuguni. Marri warruburru-yung-jinyung anaadhaadharri wunu-ga-garri-yurangi wurru-ḏirrngawiiyn wugurru. Warraawurru-yung warra-12, wanii-gaḏiyn. Marri wani-magaa, “Anaani anggu-waṉbina ngayawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Numburraarranggang, aḏaba anaani ngurru-yaarri Jerusalem-guy. Anubagu warruburru warra-priest, marri warruburru warra-yiyina-yinyung ana-lhaawu-runggal, ngambambi-bilhargana ngaya anaani na-Niwiyayung na-Wurrujung-jinyung. Marri burru-yung amburru-wijangayii, nga-ngawiiyn-jinyung. Marri warruburru-yung warra-runggu-runggal warra-priest ambarriiyn warra-mulung-aynbaj-guy, waari-yinyung amburru-Jew-magaa. ");
INSERT INTO nuy_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Warraawurru-yung ngambambi-gaḻij-gana marri ngambambi-rajburrnayii, ngambambi-yudii, marri ngambambi-warra-waḏjiwumana marri ngambambiimana. Wurrugu amuulawaa-wala mana-miyn.nganga, ngaya anaani nga-ḻaḻagiiyn.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Naawiṉi-yung wini-wulawaa na-Zebedee-yinyung, James marri John, wini-yanggi nigawi-wuy. Marri wini-yamayn, “Nimba-yiyina-yinyung, wa-yandhawiwang-maynji nagang, yuga nimbaa-gaṉbina niiṉi-wuy, marri yuga baaṉbang?” wini-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nigaayung ni-yamayn, “Yangi yuga anubani nimba-ngaynbandii anambaa-gaṉbina?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wuguṉiiyung wini-yamayn, “Niiṉi naani-burraa daju nugawi-rruj anaarrwar, wu-milhiynjina-rruj nugawi-nyinyung-duj, naaynbajung ani-burraa mangaṉḏayayaagu, niga naaynbajung ani-burraa walawalama,” wini-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yagu nigaayung na-Jesus ni-yamayn, “Waari nimbini-marrbuy-magaa, marri aadanu niini-yambina ngijang. Anaani ngaya nganggarragayii runggal, marri nga-ngawang. Anubani-yung anggiijamana, nguynju yaga ngaya nganggaḻ-nguyii manubama-yung mana-gaṉdharra-wala. Yuga manubama-yung ngijang nuguṉi nimbini-waḻ-nguyii, yuga? Marri anubani-yung ngandaambara-ngambijgina. Marri nuguṉiiyung yuga nimbiniimbara-ngambijgina anaani anggiiyn-nguynju, yuga?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wuguṉiiyung wini-yamayn, “Yii, aadanu naani-waṉbina ngijang,” wini-yamayn. Na-Jesus nigaayung ni-yamayn, “Mana-gaṉdharra manubama-yung nganggaḻ-nguyii-wala, nuguṉiiyung ari nimbini-waḻ-nguyii. Anubani-yung nimbiniimbara-ngambijgina nguynju ngayawi-yii. ");
INSERT INTO nuy_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Yagu yagi anubani-yung nga-yambi, ‘Yuu, anubani nimbini-burraa walawalama marri mangaṉḏayayaagu’, yagi anubani-yung nga-yambi. Anubani-yung God ni-wijangani, yangi-nyung warrubawi-yung ambu-burraa anubagu ana-walawalamag-duj marri anubani ana-mangaṉḏayayaagu-rruj.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wugurraayung warruburru-yung warra-10 wurraawanggini, marri anubani-yung warraa-ḏiyaldhiyn naawiṉi-yung na-James marri na-John. ");
INSERT INTO nuy_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Na-Jesus anubani wanii-gaḏiyn nigawi-wuy marri ni-yamayn, “Nugurru nurru-marrbuy, warruburru-yung wurru-buunggawa-mana-yinyung ana-lhal-lhangu-yinyung, warruburru-yung wurraawanggina, ‘Ngaya anaani nga-buunggawa.’ Marri warruburru waa-runggu-runggal, warra-yamijgana, ‘Nugurru aadanu nimba-yandhurrbangana,’ wurru-yamana. ");
INSERT INTO nuy_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yagu nugurru yagi anubani-yung nuu-yami warruburru-yung-jii. Nugurru-maynji numburru-runggal-mang, marri nambarra-maṉmani warra-mulung-aynbaj-guy. ");
INSERT INTO nuy_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Marri nimbirri-ngaynbandang-maynji anuwaagu ana-raga-ragij, warra-mulung-aynbaj-guy nambarraa-mijgalmina. ");
INSERT INTO nuy_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ngaya yamba anaani, na-Niwiyayung na-Wurrujung-jinyung, nga-yanggi anaanuwuy, waari ngambi-maṉmi-yinyung warra-mulung-aynbaj warruburru-yung. Nga-yanggi anaani, warra-mulung-aynbaj yungguyung ngamba-maṉmani, nguynju yungguyung anubani-yung ngaynjiynjang ngayawi-nyinyung ana-wiri, ngamba-bayarra-gana warruburru-yung warraarraarrawindi.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Wurru-yanggi warraawurru-yung Jericho-wuy. Malgadhaadharri wurrugu, na-Jesus marri warruburru wurru-marrbuy-maa-yinyung marri warruburru warraarraarrawindi wurru-yanggi anubagala ana-Jericho-wala. Nubagi-yung na-nimuwaj-jung Bartimaeus, na-bagaḻang-aladi-nyung. Nubagi-yung wani-lhanga-lhangayaani-yinyung wuṉuga. Na-ninyarra-yung naagi-yung na-nimuwaj-jung Timaeus. Naagi na-Bartimaeus bagu ni-burri amaadi-rruj. ");
INSERT INTO nuy_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ni-wawanggiyn ana-lhaawu, “Bagu ni-yanggi naadagi-yung na-Jesus ana-Nazareth-jinyung.” Marri naagi-yung niiḏangi, “Jesus, na-niwiyayung na-David-jinyung, nimba-man.galagang anaani ngaayung!” ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Yagu warraawurru-yung arraarrawindi wunu-yambini, “Ba-muḏaḏbang!” Yagu nigaayung naagi-yung niiḏangi-wugij yanggarrwar, “Na-niwiyayung na-David-jinyung, nimba-man.galagang ngaya anaani!” ni-yamaa-wugij niga. ");
INSERT INTO nuy_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Bani-yung marri na-Jesus ni-lhangayn. “Numbunaa-gaḏiyn naadagu yaanuwuy,” ni-yamayn. Wunaa-gaḏangi naagi-yung na-bagaḻang-aladi-nyung, “Baaḻaaḻarrang marri ba-ḻaḻagiiyn, yuwaagila ninii-gaḏii,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Manaama-yung nima-ngarrgiwayn ni-yabini-yinyung mana-yaaḻi marri ni-ḻaḻagiiyn. Anubani-yung ni-jarrarriyn ni-barri-nguḻu-nguḻubiyn na-Jesus-guy. ");
INSERT INTO nuy_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Na-Jesus nu-yamijgayn, “Yangi yuga ngaya anubani nimba-ngaynbandiyn marri waa-gaṉbang nagang?” ni-yamayn. Na-bagaḻang-aladi-nyung nigaayung ni-yamayn, “Nimba-yiyina-yinyung, nguynju yungguyung nganggarranggang,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Na-Jesus nigaayung ni-yamayn, “Ba-yaarri. Aadanu yamba nu-ngu-jambarrgiiyn, marri aḏaba nu-maṉdhiiyn nagang,” ni-yamayn. Nga anubani lhugaajgiyalawaj ni-warranggayn niga. Marri anubani ni-yanggi aḏaba, nu-garrindharrmiyn na-Jesus-guy. ");
INSERT INTO nuy_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Warruburru-yung wurraanggarra-yanggi buguni Jerusalem-guy. Wurru-yanggi buguni Bethphage-wuy marri Bethany marri buguni ma-ḻandhirrngindi-rruj ma-mayini Mount of Olives, wubani wu-ridiynjini a-Jerusalem. Anubagu, wani-lharrgang wini-wulawaa nigawi-nyinyung wini-marrbuy-maa-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Wani-yamijgayn, “Nimbini-yaarri wubani-wuy a-wumurrng-guy, nimbini-lhangarrmang bani wu-lhamunu-radbidhaa, wirrig dunggi. Waari anaani-yung ambanggu-warrgaay, ana-dunggi. Marri anubani-yung nimbini-lhamunu-lharrina, marri nimbini-lhamunu-warrgina anubagala ngayawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Warraaynbaj-maynji warrubawa-yung ambu-yamang, ‘Niini-yaminggarrina nuguṉi aadanu niini-lhamunu-ngarrgiwana, aadanu ana-dunggi?’ Nuguṉiiyung nimbini-yamang, ‘Anaani na-Buunggawa niga ni-ngaynbandii wugurru, marri niga anaani ani-lharrgang mal-dhamun.gurrg,’ nimbini-yamang.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nubiṉi-yung na-wurruj-baa aḏaba wini-yanggi, marri anubani-yung wini-lhangarrmaa ana-wirrig ana-dunggi, wu-lhamunu-radbidhi bagu wu-dhawang-duj, bagu wu-lhaay amaadi-rruj. Marri anubani-yung wini-lhamunu-lharrini. ");
INSERT INTO nuy_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Warra-wurru-wurruj bagu wugurraayung wurraarra-garra-lhi. “Niini-yaminggarrina nuguṉi aadanu niini-ngarrgiwana ana-dunggi?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yagu wuguṉiiyung waani-yamijgayn, ana-lhaawu anubani-yung wani-yanguni na-Jesus. Yagu warruburru-yung warra-wurru-wurruj anubani-yung wuu-lharrgang. Anubani-yung wini-yarrijgini ana-dunggi buguni na-Jesus-guy. ");
INSERT INTO nuy_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Anubanila, manubama-yung wirrima-ngarrgiwaa yaaḻi nga wuu-rulbu-wabaa. Nga ni-burri bagu arrwar. ");
INSERT INTO nuy_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Arraarrawindi-yinyung warra-wurru-wurruj wirrima-murrgulhangi wugurri-nyinyung mana-yaaḻi amaadi-waj. Warra-mulung-arrgi-yung wirri-wulguldhangi manjarr wubanila-wala a-rangag-gala marri wirri-murrgulhangi wugurru amaadi-waj. ");
INSERT INTO nuy_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Warra-wurru-wurruj anuwaagu-yinyung ana-raga-ragij marri anuwagala anaadhaadharri, wurraaḏangi. Wurru-yamaa, “Hosanna! Ngaanu-warraarriwana na-God! Naadagilu ni-yaarri, nigawi yungguyung na-Buunggawa na-God. Naadagilu na-God naagajij-majgana niga. ");
INSERT INTO nuy_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Na-God nganiigajij-majgana ngagurru, warraarrawindi. Naadagilu yamba ani-buunggawa-mana lhaalhag, nguynju na-baba-yii na-David-jii. Ngaanu-warraarriwana na-God anaarrwar-yinyung!” Dani-yung wurru-yamaa wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Na-Jesus naagi-yung ni-yanggi Jerusalem-guy. Ni-yanggi wubani-wuy a-Temple-Maṉngulg-guy. Anubani ni-warra-nani anaarrawindi-yinyung wu-warra-ngu-burri. Ngarrubagi aḏaba ngarraaḻirr ngi-dhirridiyn. Wudani-yung-gala, na-Jesus marri warruburru-yung warra-12, wuu-yanggi anubagala ana-Jerusalem-gala, buguni Bethany-wuy. Wurru-waliyn, nga anubagu wurru-yaay wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Anubanila-wala, ana-Bethany-wala wurru-yanggi, Jerusalem-guy. Na-Jesus anubani-yung ni-marryaadiyn. ");
INSERT INTO nuy_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ni-warranggayn juju…j nima-wal-nayn, mana-maaṉbaaṉburru manaama-yung. Manaama-yung manjarr waṉagaa. “Yuga ma-ngugulmung bagu maarra-ngugulmung-jayaadangi?” ni-yamayn. Ni-yanggi nga nima-nani, yagu mabal-wugij ma-burri anubagu, waari yamba anubani-yung anggu-maṉdhini anubani anaagalhal-aṉbana. ");
INSERT INTO nuy_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Marri manubama-yung nima-yamijgayn, mana-mabal, “Warraaynbaj waari wu-ngi nugawi-wala anu-ngugulmung, nagang,” ni-yamayn. Wurru-marrbuy-maa-yinyung warruburru-yung wurraawanggini ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nga anubanila wurru-waliyn anubagu ana-Jerusalem. Naagi-yung na-Jesus ni-yanggi wubani-wuy a-Temple-Maṉngulg-guy. Anubagu, wurraarra-yabijgaa arra, wuu-yiynjini marri wurru-bayandhangi wugurru. Naagi-yung wani-nani, ni-riyaldhiyn. Anubani-yung wani-man-jarramijgayn anubagala ana-Temple-Maṉngulg-gala. Anubani-yung warra-mulung-arrgi-yung wubani-yung wuṉuga-yinyung a-Temple-Maṉngulg-jinyung wu-bu-burri anubani-yung wurru-yiynjini, warra-mulung-arrgi-yung wurru-yiynjini anubagu lhabarrg. Anubani-yung na-Jesus ana-baadhi anubani niwu-miyn niwu-barawudiyn, marri marri anubani wurru-biḻajgudhii-yinyung. Warruburru-yung wani-man-jarramijgayn. ");
INSERT INTO nuy_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Warra-mulung-arrgi-yung warra-wurru-wurruj wurru-warrwarrway wubani-waj a-Temple-Maṉngulg-baj. Yagu wani-lhambini. ");
INSERT INTO nuy_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Anubanila, wani-yiyini wugurri-wuy warra-wurru-wurruj-guy. Ni-yamaa, “Ana-wubiba na-God-jinyung wu-yamana, na-God ni-yamayn, ‘Ngayawi-nyinyung ana-wumurrng, nimbirri-mayana ana-wumurrng anaani ngambambi-yambina-yinyung, warruburru-yung warra-wurru-wurruj ana-lhal-lhangu-yinyung.’ Dani-yung ana-wubiba wu-yamana. Yagu nugurru nirriiynbijgayn anaani ana-wumurrng, (Jeremiah 7:11) ‘nguynju yaga warrubawa-yung wurraamajaa marri wu-julubina,’ nurru-yamana.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Warruburru-yung warra-runggu-runggal warra-priest marri warra-yiyini-yinyung ana-lhaawu-runggal, wurraawanggini anaani ana-lhaawu. Warraawurru-yung wurru-wijangani ari naagi-yung ambunu-yaminggarrijgaa ari ambunu-ngawijgaa. Warraawurru-yung yamba wuu-ḏirrngawiiyn nigawi-mirri, warruburru-yung yamba warra-wurru-wurruj wunaa-gawanggini, wurru-wurrij-gaḻaaḻarrangi nigawi-wala a-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Anubani-yung ana-miyn.ngu, na-Jesus marri warraawurru-yung wurru-marrbuy-maa-yinyung wuu-rabaliyn anubanila ana-wumurrng-gala ana-runggal. ");
INSERT INTO nuy_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ana-ngamugijgaj, wurru-yanggi amubami-wuy ama-maaṉbaaṉburru. Yagu manubama-yung ma-manjarr-wadbarrwini, maaṉbiyn aḏaba ma-ḏaḏarrg-mayn, arrwar-wala nga yuuguni lhirribala-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Na-Peter ni-wijangang bagu, nga ni-yamayn, “Buunggawa, baarranggang, numa-ranga-marrgaa, marri ma-ḏaḏarrg-mayn,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nigaayung na-Jesus nu-yambalmayn, “Nugurru numburru-jambarrgiiyn na-God. ");
INSERT INTO nuy_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Anaani ngana-magana yijgubulu, nugurru-maynji nimbirrima-yambang manaama-wuy mana-runggal mana-magabang, ‘Ba-ḻaḻagiiyn marri ba-barawudina buguni ama-lhagayag-guy,’ numburru-yamana-maynji, marri yagi-maynji nurru-wij-gubububuluwi, numburru-jambarrgina-maynji aadanu anggu-waṉbang, aadanu yijgubulu anggiij-gaṉbang. ");
INSERT INTO nuy_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Wudani-yung-gala, ngana-magana, numbunu-yambina-maynji na-God-guy, anubani-yung numburru-jambarrgiiyn nambaniiyii-yinyung, marri ngubindi, nambaniiyii aadanu. ");
INSERT INTO nuy_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Ana-malg-arrawindi-maynji anubani-yung numbunu-yandhawawana na-God, warraaynbaj-maynji ambu-waṉbina anaaladi nugurri-wuy, warrubawa-yung nambarraagajij-garruyn. Nguynju yungguyung nuwaagi na-Ninyarra anaarrwar-yinyung nigaayung ari nambaniigajij-garruyn, aniij-galadi.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ngijang wurraagiyn buguni Jerusalem-guy. Bagu na-Jesus ni-yanggi wubani-rruj a-Temple-Maṉngulg-duj. Marri warra-runggu-runggal warra-priest marri warra-yiyini-yinyung ana-lhaawu-runggal marri warra-mijiwanggu, warraawurru-yung wurru-yanggi nga wunu-yamijgayn, ");
INSERT INTO nuy_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Ajigala nagang aadanu nunggaṉbina anaani anaarrawindi-lhangu? Yangi-nyung nagang nimbi-lharrgang, marri nunggaṉbini anaani-rruj?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nigaayung na-Jesus ni-yamayn, “Ngaya anaani nguynju-waj nganamba-yandhawiwana nugurru. Nugurru-maynji ngirri-yambalmang ngaya, nguynju-waj ngaya nganamba-magana nugurru, anubani-yung-jinyung ngaya ngaaṉbina anaarrawindi-lhangu. ");
INSERT INTO nuy_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ajigala naagi-yung na-John waniimbara-ngambijgaa? Nubagila na-God-gala yagu nugurri-wala warra-wurru-wurruj-gala? Ngirri-yambalmang ngaya.” ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wugurraayung, wurru-yandhawiwaynjini, “Ngagurru-maynji ngaambu-yamana na-God-gala, nigaayung ani-yamang, ‘A-yangi yungguyung naagi-yung waari numbunaa-ngu-jambarrgini na-John?’ ");
INSERT INTO nuy_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Yagu yagi ngurru-yami ‘warra-wurru-wurruj-gala’.” Dani-yung wurru-yamayn, wugurru yamba wurru-ḏirrngawiiyn warra-wurru-wurruj-gala. Waadurru-yung wuu-jambarrgiiyn na-John, yijgubulu anubani-yung naa-ja-jambini-yinyung na-God. ");
INSERT INTO nuy_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Wudani-yung-gala, warraawurru-yung wurru-yamayn, “Nurru-maḻaḻadi nurru,” wurru-yamayn. Nigaayung na-Jesus wani-yamijgayn, “Waari yamba nugurru ngirri-magaa, ngaayung yagi ngana-magi nugurri-wuy, yangi-nyung ngaya ngambi-lharrgang, marri anaani ngaaṉbina.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Anubanila, naagi-yung na-Jesus wani-magaa anaani-yung ana-lhaawu. “Na-waḻyinyung yaga ni-wanuynjungaa wubani-yung a-wuyarrangaḻ nguynju yungguyung aniwu-maṉdhangi wugargayag. Anubani-yung niwu-dhidangi ruluj nguynju yagi yungguyung ambu-yanggi anubuguni. Marri ni-rigandi ana-gara nguynju yungguyung aniwu-burrii buguni anubani-yung ana-wuyarrangaḻ marri aniwu-dhurrmana. Anubani-yung nima-muṉḏugaa nimaambarra-yarrmayarrmijgayn mana-ṉuga, wurru-wiḏangi yungguyung, nguynju wurraarranggaa nguynju yagi yungguyung warruburru-yung amburraamaji. Marri wani-lhangarrmayn waḻya-waḻya, warruburru-yung ambirri-rangarrangi ana-lhal, marri anubani-yung ni-yanggi yuuguni a-lhal-aynbaj-guy niga. ");
INSERT INTO nuy_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Anubani-yung lhangarrmayn-jinyung anubani-yung wu-warradangi ana-wuyarrangaḻ. Nu-lharrgang waḻyinyung naa-mijgalmini-yinyung, warruburru-yung-guy wirri-rangarrangi-yinyung-guy, nguynju yadhu waadurru-yung ambunuuni yungguyung bani arrgi wuyarrangaḻ, wubanila-wala wubal. ");
INSERT INTO nuy_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Yagu warruburru-yung wirri-rangarrangi-yinyung, nubagi wunu-bilhargayn na-waḻyinyung, marri wunu-wini naagi-yung, nga wunu-lharrgang, waari ambunuuni, ni-mamar niigiyn niga. Nigaayung na-buunggawa-yung nubagi-yung nu-lharrgang ngijang aynbajung. ");
INSERT INTO nuy_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Naadagi-yung ngijang wunu-rayibaa a-yinag-duj. Marri naadagi-yung wunaambulijgayn. ");
INSERT INTO nuy_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","“Ngijang na-buunggawa-yung aynbajung wunu-lharrgang. Yagu nubagi-yung ngijang wunu-wini, marri ni-ngawiiyn. Na-buunggawa-yung nubagi-yung ngijang mulung-arrgi-yung wani-lharrgandi, arraarrawindi. Warra-mulung-arrgi-yung warra-wini, wurru-numaaḏu, warra-mulung-arrgi-yung warra-ngawijgaa wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Yagu aynjaabu-nyung-bugij nu-waṉagaa, nigawi-nyinyung na-niwiyayung, nubagi naa-ḏamarr-ngu-burri-yunyung. Naagi-yung adhaadharri-windiyung nu-lharrgang. Ni-yamijgini nigaajbaj, ‘Ari nubagi ambunu-yandhurrbangana ngayawi-nyinyung na-nigi,’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Yagu warruburru-yung wirri-rangarrangi-yinyung anubani-yung wurru-yamijgaynjini, ‘Numburraarranggang, yaagila na-niwiyayung. Aniwu-mang ari anaani ana-lhal, malgadhaadharri wurrugu nubagi-yung-gala na-yiwanggu-nyung-gala. Numburraaṉiyn, ngaanuumana naagila. Ngagurru-waj anaani ngaanggu-lhal-waṉagana anaani ana-lhal.’ Dani-yung wurru-yamijgaynjini. ");
INSERT INTO nuy_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Aḏaba wunu-bilhargayn marri wunu-wini, ni-ngawiiyn. Marri wunu-barawudiyn anubanila ana-lhal-wala.” ");
INSERT INTO nuy_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Naagi-yung na-Jesus ni-yambini-wugij. “Na-buunggawa-yung nubagi-yung ni-yaminggarrina ari anubagu? Ari nubagi-yung ani-yaarri, ari ambaniimana warruburru-yung wurru-mijgalmina-yinyung anubagu. Ari nigaayung ambaniiyn ana-lhal anubani warra-mulung-aynbaj-guy. ");
INSERT INTO nuy_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Yuga anaani nirri-nani aḏaba, na-God-jinyung ana-wubiba? ‘Warruburru yaga wirri-maṉdhangi wumurrng. Anubagala wirrima-barawudiyn aynjaabugij ṉuga. Yagu manubama mana-ṉuga ma-burraa aḏaba anuwaagu anu-nguḏuṉ-duj, ma-runggal-windiyung magurru. ");
INSERT INTO nuy_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Na-Buunggawa anaani ni-waṉbina. Ngurraarranggana ngagurru anubani-yung ni-waṉbina, marri ngurru-waḻaaḻarrii,’ wu-yamana ana-wubiba.” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Warraawurru warruburru wurru-marrbuy, na-Jesus wani-magaa ana-lhaawu wugurri-wuy. Naagi wunu-ngaynbandangi ambunu-bilhargaa niga bagu. Yagu wurru-ḏirrngawini warruburrala-wala warra-garnyirrimba-wala. Marri wunaarruyn wurru-yanggi wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Anubanila-wala, warra-lharrgang warraawurru-yung Pharisee marri na-Herod-jinyung warra-wurru-wurruj, na-Jesus-guy. Nguynju yungguyung naagi-yung ambunu-yambini yungguyung yij-galadi marri ambunu-dhaayurrijgaa. ");
INSERT INTO nuy_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Warruburru-yung wurru-yanggi nga bagu wunu-yamijgayn, “Barra-yiyina-yinyung, nurru nurraawanggina nugawi-nyinyung ana-lhaawu. Nurru-marrbuy aadanu nagang nuynjambina yijgubulu. Warraaynbaj waari nagang warra-buunggawa. Waari nagang bamba-nang anubani-yung anaarabarabalu-waj, nagang barra-bajiyiyina yijgubulu-windiyung anubani-yung na-God-jinyung nigawi-waj-jinyung. Yuga wiij-maṉdhina, ngagurru nganuuyii-yinyung nubagi-wuy na-runggal-yung na-Caesar anu-ṉuga, yagu waari? ");
INSERT INTO nuy_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yuga ngaambu-waṉbina anaani?” wurru-yamayn. Na-Jesus ni-marrbuy anaani-yung wunu-dhaayurrangi. Nigaayung ni-yamayn, “A-yangi yungguyung ngaya anaani ngirri-dhaayurrii? Bagalu nimbi-yarrijgiyn wudanu wuṉuga.” ");
INSERT INTO nuy_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Marri wunu-yayn. Nigaayung ni-yamayn, “Wa-yangi-nyung anu-malnguj marri ana-muwaj anu-ṉuga-rruj?” ni-yamayn. Wugurraayung wurru-yamayn, “Yagu nubagi na-Caesar niga.” ");
INSERT INTO nuy_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nigaayung ni-yamayn, “Na-Caesar-yinyung anubani-yung, nugurru numbunaa-gaagijgiyn numbunuuyn nigawi-wuy. Marri anubani na-God-jinyung wugurraayunggaj numbunuuyii-wugij.” Dani-yung ni-yamayn. Wugurraayung warraawurru-yung wurru-wurri-ḻaḻmayn, anubani-yung-jinyung wani-yambalmayn wugurri-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Warruburru-yung mulung-arrgi-yung warra-Sadducee wuu-yanggi. Warraawurru-yung waari ambuu-jambarrgiiyn warrubawa-yung wu-ngawina-yinyung wu-wiri-mana. Warraawurru-yung buguni wurru-yanggi na-Jesus-guy marri wunu-yandhawiwandi, ");
INSERT INTO nuy_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Barra-yiyina-yinyung, Moses anaani-yung ni-warrarrangi ana-lhaawu, ngagurraa yungguyung. Na-waḻyinyung-maynji nubagi-yung yagi-maynji wani-waṉagi warra-mijburrayung, marri ani-ngawang, nga-rangarrina-yung ngarrubagi-yung angi-wiri, ari bagi-yung nilharri-yung ngijang aniiynji-yara, nguynju yungguyung ari ambangi-yabana mijburrayung nigawi yadhu ni-ngawiiyn-jinyung niga.” ");
INSERT INTO nuy_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Warraawurru-yung wurru-yambini-wugij. “Warraawurru-yung 7 wuu-dharrmaynjini-yinyung wugurru. Naagi-yung na-wulhu-wulhurr-yung niiynji-yaay, yagu ni-ngawiiyn, waari ambani-lhamaa warra-mijburrayung. ");
INSERT INTO nuy_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ngijang naadhaadharri-nyung niiynji-yaay, ngarrubagi-yung-bugij ngarra-maṉinyung, yagu waari ambangi-yabaa warra-gujuju. Ngijang marri ni-ngawiiyn. Naaynbajung anubani-yung malgaḻagaḻayu ni-malgadhaadharri-giiyn. ");
INSERT INTO nuy_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Yagu warruburru-yung warra-minilharri-yung, ngiiynji-yaay marri wuu-lhagarra-ngawini. Waari warraawurru-yung ambarra-waṉagaa warra-mijburrayung. Anubanila, ngigaayung ngarra-maṉinyung adhaadharri-windiyung ngi-man-dhamarriyn, ngi-ngawiiyn ngiga. ");
INSERT INTO nuy_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Anubani-yung-maynji warra-wurruj-wurruj amburru-ḻaḻagina anubanila ana-ngawij-gala, wa-yangi-nyung-jinyung ngarra-rangarrina-yung, ngiga yamba ngiiynji-yaay warraarrawindi ngaadagi-yung?” Dani-yung wurru-yamaa, warruburru-yung warra-Saducee. ");
INSERT INTO nuy_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Na-Jesus nigaayung wani-yandhawiwayn, “Nugurru aadanu aḏaba nirriij-gajarrgaa. Yagu waari yamba aadanu numburru-marrbuy-maa anubani ana-lhaawu na-God-jinyung, marri waari-mirri numburru-marrbuy-maa anubani ana-lhuḏ na-God-jinyung. ");
INSERT INTO nuy_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Warrubawa-yung-maynji ambu-ḻaḻagiiyn marri amburru-wiri-mang, anubani-yung wugurru waari wurraaynji-yingi. Nguynju yaga wudanu angel-yii wubani aarrwar wu-burraa, amburru-yamana. ");
INSERT INTO nuy_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Yagu nugurru yuga waari nimbirri-nani ana-wubiba na-Moses-jinyung, anubani-yung na-God ni-yambini nugurri-wuy anubani-yung amburru-ḻaḻagina-yinyung ana-ngawij-gala? Wu-yambiynjini wubani-yung wu-nagina-yinyung anu-gulundundunung ana-rangag. Na-God nu-yamijgayn na-Moses, (Exodus 3:6) ‘Ngaya anaani na-God na-Abraham-jinyung marri na-Isaac-jinyung marri na-Jacob-jinyung,’ ana-wubiba anaani wu-yamana. ");
INSERT INTO nuy_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Na-God-jinyung warra-wurru-wurruj, warruburru-yung waari-yinyung amburru-ngawini, warruburru-yung wurru-wiri. Nugurru aadanu nurru-wij-gajarrgaa-windiyung.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Aynjaabu-nyung naagi-yung wani-yiyini-yinyung ana-lhaawu-runggal, ni-yanggi nigawi-wuy. Anubani-yung ni-wawanggiyn anaani wurru-wundi. Na-Jesus anubani-yung wani-yambini-yinyung, bagu ni-wawanggini. Anubani-yung ni-waḻamin-jamaa anaani-yung wiij-maṉdhini na-Jesus-jinyung ni-yambini. Wudani-yung-gala, nu-yandhawiwaa na-Jesus, “Aniga-yung yuga anubani-yung aniij-ḏunggal ana-lhaawu?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Na-Jesus nigaayung nu-yambalmayn, “Ana-wulhu-wulhurr anubani ana-lhaawu-runggal anaani, ‘Numburraawanggina, nugurru warra-Israel. ");
INSERT INTO nuy_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Na-Buunggawa ngagurri-nyinyung na-God, aynjaabu-nyung-bugij na-Buunggawa-yung. Marri numbunaa-ḏamarr-ngu-burraa na-Buunggawa nugurri-nyinyung na-God, nugurri-wala aandhiri-wala marri yii-wurrij-gala marri nugurri-nyinyung-gala amaamburumburung-gala, marri nugurri-nyinyung wudanu a-ngayn.gayij marri a-wiri, marri nugurri-nyinyung amudamu ama-malbij-gala, maaṉbina a-lhuḏ.’ ");
INSERT INTO nuy_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Anubani anaaynbaj ana-lhaawu anaani, ‘Warrubawa-yung nambarra-ngaynbandii nurraalgurmaynjina-yinyung nugurru, nguynju yaga wudanu nugaajbaj-mirri nu-ngaynbandiina.’ Dani-yung wu-yamana anaani ana-wubiba. Waari anaaynbaj ana-lhaawu aniij-ḏunggal waari anubagu anaanila-wala ana-lhaawu.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nigaayung nubagi-yung wani-yiyini-yinyung ana-lhaawu-runggal, nu-yamijgayn nigawi-wuy, “Barra-yiyina-yinyung, aadanu yij-mamaaḻang. Aadanu yagu yijgubulu aynjaabu-nyung-bugij na-God, warraaynbaj waari ambu-yamang nigawi-yii. ");
INSERT INTO nuy_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nganaa-ḏamarr-ngu-burraa-maynji niga, ngagurri-wala aandhiri-wala marri yii-wurrij-gala marri ngagurri-wala amaamburumburung-gala marri ngagurri-nyinyung-gala ana-lhuḏ, marri ngambarra-ngaynbandii warruburru-yung ngurraalgurmaynjina-yinyung nguynju yaga ngurru-ngaynbandiina ngagurraajbaj, aadanu ari anggiij-maṉdhiiyn. Aadanu anggiijamang waari wu…bani-yunggaj yaga yigaj wirrima-muṉḏugaa ama-ṉuga yigaj nga wurru-nanga na-God-guy.” Dani-yung ni-yamaa nubagi na-waḻyinyung. ");
INSERT INTO nuy_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nigaayung na-Jesus anubani-yung ni-marrbuy, nubagi na-waḻyinyung nigaayung ni-marrbuy. Marri nu-yambalmayn, “Nagang aadanu numbarubaj warruburru-yung na-God-jinyung warru-mandag,” ni-yamayn. Anubanila-wala, waari warraaynbaj wugurru amburru-wurrij-baḏa-waḏaḏ-maa. Yagu waari anaani ambunu-yambiḻibiḻingaani niga ngijang. ");
INSERT INTO nuy_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Na-Jesus naagi-yung wani-magaa wubani a-Temple-Maṉngulg-duj. Ni-yamaa, “Warruburru warra-yiyini-yinyung ana-lhaawu-runggal yaani-yung wurru-yamaa, nubagi-yung na-Messiah, nubagi-yung na-runggal-yung na-God-gala, niga naagi-yung na-King David-jinyung na-niwiyayung. Yagu anaani yuga anggiijaminggarrang? ");
INSERT INTO nuy_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Niga-waj yamba David ni-yambini, anubani-yung ana-Maṉngulg Mawurr ninggu-yanguni, marri ni-yamayn, ‘Na-God nu-magaa na-king-guy, ngayawi-nyinyung-guy na-buunggawa-wuy, “Ba-burrangang yaaji ngayawi-rruj a-walawalama-rruj. Wurrugu marri, nugawi-nyinyung warruburru nurru-wurrij-marrdiynjini-yinyung, wurrugu ngamba-burrang nugawi-rruj a-mun-duj, bamba-mun-ban.ngang.” ’ Ni-yamaa naagi-yung na-David. ");
INSERT INTO nuy_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Na-David niga-waj nu-mayaa nubagi-yung na-king, na-Messiah, ‘Buunggawa’, ni-yamaa. Yuga na-David-jinyung na-niwiyayung, nubagi na-David-jinyung na-buunggawa-yung?” Dani-yung ni-yamayn na-Jesus. Warraarraarrawindi wurraawanggini aani-yung a-lhaawu. Marri anubani-yung wurru-waḻaaḻarrangi wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Anubanila-wala, na-Jesus wani-magaa. “Numburru-dhi-maṉdhina warruburrala-wala warra-yiyini-yinyung ana-lhaawu-runggal. Waadurru wugurru wuu-yabina yaaḻi-yarrmayarrmaj wuu-yaarri-yinyung. Marri warra-ngaynbandii warruburru warra-wurru-wurruj amburru-yambina mamanunggu ana-lhaawu wugurri-wuy anubani-rruj nurru-mana-mani-rruj ana-marrya-rruj. ");
INSERT INTO nuy_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Marri anubani wurru-yaarri nga wurru-burraa wubani-yung a-mamanunggu, wubani a-synagog-duj. Marri anubani-rruj wurru-nguyu-nguyii-rruj, wirri-ngaynbandii amburru-burraa wubani-rruj a-mamanunggu-rruj. ");
INSERT INTO nuy_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yagu warruburru-yung wurraarra-yarina anaarrawindi wugurri-wala warra-ngaya-ngayi. Marri anubani-yung wuu-yambina wu-jarrmayarrmaj-bindiyung anaarrwiyaj, wugurraajbaj wurraambaḻaman-gina, nguynju yungguyung warra-mulung-aynbaj warruburru-yung ari ambarraarraarriwana yungguyung. Yagu na-God niga ambani-lhajbumana warruburru-yung. Niga-waj anubani-yung ambani-guldhijgang waadurru.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Anubanila-wala, naagi-yung ni-burrangayn, ni-warranggaa yuuguni wubani wu-ṉuga-wuy wu-dhabara-wuy. Ni-warranggaa buguni-wugij, anubani warraarraarrawindi wurru-yanggi nga wirri-burrangi anu-ṉuga wubani-wuy a-lhabara-wuy, wunuuni na-God-guy wugurru. Warruburru-yung warraambaambal wirri-burrangi arrawindi-windiyung wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ngigaayung ngarraagi-yung ngiimbalalari ngarra-ngayi-nyung, yuwaagala ngi-yanggi. Anaani-yung ngiwu-yurangi wulawaa wuṉuga winyig-baa. Nga ngiwu-burriyn ngiga. ");
INSERT INTO nuy_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Na-Jesus wanii-gaḏiyn warruburru-yung wurru-marrbuy-maa-yinyung marri ni-yamayn, “Anaani ngana-magana yijgubulu, ngaadagu ngarra-ngayi-nyung ngiimbalalari. Yagu ngiwu-burriyn arrawindi anu-ṉuga, wugurraayung warruburru-yung warra-mulung-aynbaj wirri-burrangi winyig wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Wugurru yamba warruburru-yung wirri-waṉagana anu-ṉuga a…rrawindi windiyung. Arrgi-waj wirri-burrangi, arrgi-waj wirri-waṉagaa. Yagu ngarraagi-yung ngiga ngiwu-waṉagaa waadharra yagu anubani-yung ngiwu-burriyn ngiwu-jadugayn, waari angiwaagijgini. Waari angi-waṉagang anu-ṉuga, waari ngi-mi ana-marrya aḏaba.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Anubanila-wala, anubani ana-Temple-Maṉngulg wirriirruyn yuuguni wurru-yanggi. Yagu aynjaabu-nyung ni-marrbuy-maa-yinyung nu-yamijgayn, “Nimba-yiyina-yinyung, baarranggang! Ṉuga-runggal ṉuga! Marri wumurrng runggal!” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nigaayung na-Jesus nu-yamijgayn, “Anuwaanila nunggu-nayii ana-runggal ana-wumurrng. Yagi anubagu ma-murrgulhangi mana-ṉuga marri yagi ma-walamalhangi manaaynbaj, anubani-yung anggaa-mamaaḻang. Aadanu aḏaba anggu-jadugiiyn!” Dani-yung ni-yamayn niga. ");
INSERT INTO nuy_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Anubanila-wala, wurru-yanggi amubama-wuy ma-ḻandhirrngindaa-wuy ama-ṉuga Mount of Olives. Nga bagu wurru-burrangayn. Bagala wurru-garri-niiyn, wurraarranggaa wubani-wuy a-Temple-Maṉngulg. Peter marri James marri John marri Andrew, warraawurru-yung wurru-yanggi warra-mulung-aynbaj-gala, marri wunu-yandhawiwandi na-Jesus, ");
INSERT INTO nuy_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Lhal-ngargu anaani anggu-waṉbina? Anaani-maynji anaani anggiij-barubaj-mana aḏaba, yuga yangi anubani nurru nambanggu-bajiyina?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Na-Jesus nigaayung wani-yamijgayn, “Nugurru numburru-dhi-maṉdhina, warraaynbaj yungguyung nguynju yagi yungguyung nambi-dhaayurri. ");
INSERT INTO nuy_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Arraarrawindi yamba amburru-yaarri nugurri-wuy, marri amburru-yambina ngayawi-nyinyung-mirri ana-muwaj. Marri amburru-yamana, ‘Yagu ngaya-waj anaani!’ nguynju yungguyung ambarra-dhaayurrii yungguyung warruburru-yung warraarrawindi warra-wurru-wurruj. ");
INSERT INTO nuy_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Warra-mulung-aynbaj warruburru-yung nambambi-yambina, anubanila mana-runggal mana-magarrangaynji, yaaji-waj marri malanganyanay. Yagi nurru-ḏirrngawi. Aadanu anggu-waṉbina raga-ragij. Anaani wiij-maṉdhina. Wurrugu marri malgadhaadharri, anaani ana-lhal anggu-jadugiiyn. ");
INSERT INTO nuy_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yagu ana-raga-ragij, warruburru-yung warra-wurru-wurruj anubani anaaynjaabugij ana-lhal amburru-wiynjina yuuguni warra-mulung-aynbaj-guy. Warru-mandag-maynji warrubawa-yung amburru-burraa yuuguni warraaynbaj-guy warru-mandag-guy amburru-wiynjina. Anaaban anubani-yung ari anggaaban-galalang, ana-lhal-warrawindi-waj. Anaaynbaj-baj ana-lhal ari yagi ana-marrya, anggaari. Anaani-yung anaarrawindi-lhangu anubani-yung ana-wulhu-wulhurr amburraarragayii, nguynju yaga anubani-yung warra-gadhuwa-yinyung warrubawi-yung ambaambuḻwiyn-jinyung.” ");
INSERT INTO nuy_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Naagi-yung na-Jesus ni-yambini-wugij. “Nugurru-waj, numburru-dhi-maṉdhina. Warrubawa-yung nambambi-yarrijgina buguni wuu-yamba-yambiynjina-wuy, bagu nambambi-nguynju-nguynjijgana. Ari bagu nambambiimana wubani-rruj a-synagog-duj. Ari bagu nambambi-lhangijgang warruburru raga-ragij warra-bu-buunggawa marri warra-ki-king, nugurru yamba anaani nurru-marrbuy ngaya. Marri nugurru ngirrii-jambina ngaya anaani, nambarra-magana wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yagu nugurru nambarra-magana anaambaḻaman ana-lhaawu warruburru-wuy warra-wurru-wurruj-guy, anaani-rruj-jinyung ana-lhal-lhangu anaarrawindi. Wurrugu marri malgadhaadharri, anaani ana-lhal anggu-jadugiiyn. ");
INSERT INTO nuy_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Warrubawa-yung-maynji nambambi-yarrijgina anubani-yung wuu-yamba-yambina-wuy, anubani-wuy warraaynbaj-maynji anubagu nambambi-nguynju-nguynjijgana, yagu anubani yagi nirriijanga-yangi, marri nurru-wijangi, ‘Yuga yangi ngaynjambang?’ Anubani-yung yamba ana-Maṉngulg Mawurr anggu-yambina-maynji, nambangguuyii-maynji ana-lhaawu, bani-yung numburru-yambang.” ");
INSERT INTO nuy_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Naagi-yung na-Jesus ni-yambini-wugij. “Warruburru-yung warra-wurru-wurruj ambarriiyn warruburru-yung warra-minilharri-yung, wugurraayung ari amburru-ngawang. Marri warra-wurru-wurruj ambarriiyn wugurri-nyinyung warra-mijburrayung. Warruburru-yung mijburrayung wugurraayung, amburru-wurrij-bangana warra-mi-ninyarra-yung-guy marri warra-mijbiibiyung-guy, amburru-yamana, ‘Yii, amburru-ngawang.’ ");
INSERT INTO nuy_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Warraarrawindi nambambi-wurrij-bangana nugurri-wuy, yagu yamba nugurru nurru-jambarrgiiyn ngayawi-wuy. Yagu nugurru numburru-lhara-wugij andhurrg aadanu, yagi nurru-lhuṉdhi. Nga anubani anggu-dhaag-mana-rruj, God niga-waj nambani-wiri-gana nugurru aadanu.” ");
INSERT INTO nuy_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Naagi-yung na-Jesus ni-yambini-wugij. “Bagu anggu-burraa-maynji (Daniel 9:27) gangganyung anggu-malhi-lhara, yagi aadanu wiij-maṉdhi,” ni-yamaa. Nugurru aadanu nirri-nayii-yinyung anaani ana-wubiba, ari nurru-marrbuy yangi anubani, ni-yambini-yinyung na-Jesus. Ni-yamaa, “Anubagu-maynji numburru-nayii, nugurru nurru-burraa-yinyung ana-Judea, numburru-yarramang amubama-wuy ma-ḻandhirrngindaa-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nugurru-maynji numburru-burraa wubani-rruj arabarabalu-rruj, yagi nurru-yabi, yagi nurraarra-mi anubani-yung anaarra anubanila-wala nugurri-nyinyung-gala ana-wumurrng. ");
INSERT INTO nuy_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nugurru-maynji ana-malanganyanay-wala anaanga-wala, yagi nurraagi anubani-yung nirrima-mi manubami-yung mana-yaaḻi. ");
INSERT INTO nuy_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ngarra-maṉinyung-maynji ngarrubagi-yung angi-wurrij-muṉḏurr yagu ngarrubagi-yung-maynji ambangi-wuynjijgana, anubani-yung anggu-waṉina-maynji, anggiij-miḏaamimi wugurri-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Numbunu-yambina arrwiyaj na-God-guy, ‘Yagi nunggiij-dharrgi anubani-rruj anaagalhal-aṉbana,’ numburru-yamana. ");
INSERT INTO nuy_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yagu yamba anubani anggiij-maṉdhina runggal wungarri, waari aadanu anggiij-maṉdhini anggiijamaa anubanila na-God niwu-maṉdhangi-wala ana-lhal-lhangu, nga ana-yimbaj, marri anaani waari wu-waṉbi ngijang. ");
INSERT INTO nuy_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Na-Buunggawa ni-wijangani, aniwu-winyig-gang, anubani anggu-waṉiyn-maynji. Anubani-yung-magaa waari aniwu-winyig-gaa, waari warraaynbaj anubagu wu-wiri-mi. Yagu aniwu-muḏaḏbijgang anubani ana-wungarri aḻagaḻa, nguynju yadhu ambani-wiri-gana warruburru-yung nigawi-nyinyung warra-wurru-wurruj, ni-wajbarini-yinyung wugurru.” ");
INSERT INTO nuy_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Naagi-yung na-Jesus ni-yambini-wugij. “Anubani-yung, warra-mulung-aynbaj-maynji warruburru-yung nambambi-yamijgana, ‘Baarranggang, yaagi na-runggal-yung na-Messiah,’ amburru-yamana-maynji, yagu ‘Yuuguni, baarranggang,’ yagi anubani-yung nurru-jambarrgi ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mulung-arrgi-yung yamba amburru-yamana, ‘Ngaya-waj na-Christ,’ yagu ‘Ngaya-waj nganaa-ja-jambina-yinyung na-God,’ yagu amburru-wawaḻii. Amburru-waṉbina runggal aniij-mamaaḻang, anaaynba-gaynbaj-jinyung. Warruburru-yung yingga ambarra-dhaayurrijgana warruburru-yung na-God-jinyung ni-wajbarini-yinyung, yagu yagi wurru-waṉbi wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Aadanu numburru-dhi-maṉdhina. Ngaya ngana-magana aḏaba, anubani-yung anaani raga-ragij anggu-waṉbina-yinyung wurrugu.” ");
INSERT INTO nuy_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Naagi-yung na-Jesus ni-yambini-wugij. “Anubani-yung ana-malgadhaadharri anubanila ana-wungarri, ‘Ngarraagi-yung ngarraaḻirr aḏaba angi-biingamudang, yagi na-ḻabama ni-wabarra-milhi. ");
INSERT INTO nuy_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ngarra-miyiri ngarrubagi-yung angiidbarrwiyn anaarrwar-wala. Anubagu anaarrwar-yinyung anubani-yung ana-waḏa-waḏaḏ-jinyung wu-burraa, anubani-yung anggu-warra-galalang.’ ");
INSERT INTO nuy_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Anubani-yung warra-wurru-wurruj warruburru-yung wurraarra-nayii ngaya-waj, na-Niwiyayung na-Wurrujung-jinyung. Ngaya nga-ngu-dhirridii wubani-rruj a-ngubunung-duj. Anubani nganggu-waṉagana ngaya lhuḏ, marri nga-milhiynjina anuwagala ngaynjaarri-maynji ngaya. ");
INSERT INTO nuy_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","“Anubani-yunggaj, waari-waj anaani ana-lhal anggu-burri, marri na-God ni-wajbarini warra-wurru-wurruj nigawi yungguyung. Anubani-yung-maynji ngandaagiyn-maynji, marri ngandharrgang ana-angel nguynju yungguyung warruburru-yung warra-wurru-wurruj amburru-muṉḏugana nigawi-rruj, anubani-yung ana-lhal-aynbaj-gala ana-lhal anaarrawindi-lhangu, anubani wu-dhaag-mana-rruj, anubani ana-lhal.” ");
INSERT INTO nuy_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Na-Jesus naagi-yung ni-yambini-wugij niga. “Numburru-wijangayii amubami-yung ama-nunganyang-jinyung. Nugurru nurru-marrbuy-mana amubama-wala. Manubama-yung mana-magubaṉḏa ma-ninig-mayn marri wugadhuwa manjarr wu-rabalii. Anubani-yung nurru-marrbuy wiij-barubaj-mana agalhal-aṉbana. ");
INSERT INTO nuy_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wudani-yung-jii, anubani-yung numburraarra-nayii anaarrawindi anggu-waṉbina, numburru-marrbuy ngaya anaani nga-burraa nugurri-rruj warubaj, nguynju yaga wu-dhawang-duj nga-burraa. ");
INSERT INTO nuy_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Anaani ngana-magana yijgubulu, warra-wurru-wurruj ana-yimbaj wurru-wiri, anubani-yung-maynji anggu-waṉbina-maynji, warruburru-yung yagi wuu-jadugi, amburru-wiri-wugij wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ari ana-wumala marri anaani ana-lhal anggu-jadugiiyn, yagu ngayawi-nyinyung ana-lhaawu yagi wu-jadugi wugurru.” ");
INSERT INTO nuy_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Naagi-yung na-Jesus ni-yambini-wugij. “Waari wu-marrbuy-mi warra-wurruj anubani-rruj wu-dhaag-mana-rruj anggu-waṉbang. Yagu ana-angel wugurraayung wu-maḻaḻadi. Ngaayung, na-niwiyayung, nga-maḻaḻadi. Yagu nigaaj-bugij na-Baba ni-marrbuy anaani. ");
INSERT INTO nuy_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yagu nugurru-waj ngirri-rangarrii, yagu yamba nugurru nurru-maḻaḻadi, anubani-yung-maynji anggu-waṉbina. ");
INSERT INTO nuy_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Anaani wiijamana. Waḻyinyung runggal-yung nubagi-yung ni-yanggi anuuguni ana-yarrmayarrmaj. Nubagi-yung warruburru-yung warra-waḻya-waḻya wunu-yandhurrbangaa-yinyung, warruburru-yung wani-magaa, ambirri-rangarrangi anubani ana-wumurrng nigawi-nyinyung. Marri nu-magaa nubagi-yung naaynjaabu-nyung, ‘Wudanu ba-rangarrina wu-dhawang-guy maaḻamburrg.’ Marri anubani-yung ni-yanggi. Wugurraayung warruburru-yung wirri-rangarrangi-wugij ana-wumurrng, wurru-maḻaḻadi yamba lhal-ngargu nubagi na-buunggawa ari aniigiyn. ");
INSERT INTO nuy_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Nugurraayunggaj aadanu numburru-yamana numbuu-rangarrina. Nurru-maḻaḻadi yamba lhal-ngargu ngaya ngambaṉiyn. Ari adharrwara, ari miyn.giyn.gurarra, ari anggaabirrarra-mana-wala, ari yuwaagala angi-ḻamba-ḻambalii. ");
INSERT INTO nuy_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yagi-maynji nurru-rangarri-maynji, anubani-yung ari ngaynjaarri lhugaajgiyalawaj. Ari bagu anamba-nang numburru-yara-yara, nugurru. ");
INSERT INTO nuy_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ngana-magana nugurri-wuy marri warraarraarrawindi-wuy, numburru-rangarrina!” Dani-yung ni-yamaa na-Jesus, na-nidhaawu-yung. ");
INSERT INTO nuy_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ngi-waḻirr-wulawaa, wurrugu malgadhaadharri ngijang anubani-yung amburru-nguni anaani ana-marrya. Anaani-yung wiijamaa, anu…bani-yunggaj wanggu-rangga-ḻaabini-yinyung anubani ana-angel. Anubani-yung wurru-nguni-yinyung ana-marrya, aadanu wirri-mayana wiijamana, waari-yinyung wubani wuḏayn yigaj anggu-wuḻbuḻwandi. Warruburru-yung warra-runggu-runggal warra-priest marri warra-yiyini-yinyung ana-lhaawu-runggal wurru-yamiynjini wugurraajbaj. Wugurru wurru-wijangani ambunu-mangi yadhu na-Jesus midaarrgaj, ambunu-ngawijgaa niga. ");
INSERT INTO nuy_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yagu wugurru wurru-yamayn, “Ngagurru yagi anaani ngurru-waṉbi anubani-rruj ngurru-mijgalmina-rruj, warruburru-rruj warraarrawindi-rruj, yagu wu-ngarrgi-magi ana-wungarri runggal-windiyung,” wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nigaayung na-Jesus bagu ni-burri Bethany wubani a-wumurrng-duj na-Simon-duj. Anubani-yunggaj naagi-yung ni-warra-guṉḏa-guṉḏa. Na-Jesus bagu ni-nguni marrya. Nga maṉinyung buguni ngi-yanggi. Ngima-waṉagaa manaama-yung mana-gaṉdharra ma-mamanunggu. Anubani-yung ma-lhaguḻaarramangi manaama-yung malagaj, wu-burri bagu arrawuj-mamaaḻang. Wu-mayini anaani-yung, nard. Anaani-yung runggal-windiyung anu-ṉuga, ngiwu-mangi. Marri maadama-yung ngima-miyn marri ngima-wagiwayn, ngarra-maṉinyung. Marri ngunaambara-wuryiyn anubani-yung ana-malagaj na-Jesus-guy. ");
INSERT INTO nuy_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Yagu warruburru-yung wurru-burri-yinyung anubagu wurru-riyaldhiyn. Marri wurru-yamaa, “A-yangi yungguyung anubani-yung ngiwu-barawudiyn anubani-yung anaarrawuj-mamaaḻang? ");
INSERT INTO nuy_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Anubani-yung-magaa ngaambini warruburru-wuy, marri ngambambiini ana-runggal anu-ṉuga, nguynju yungguyung ngambiini warruburru-wuy warraambalalari-wuy,” wurru-yamayn. Anaani-yung wurru-yambini yang-mara-maragarrij-mirri ana-yang wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yagu na-Jesus nigaayung ni-yamayn, “Nimbirringaarruyn ngaadagu. A-yangi yungguyung aadanu nugurru nirringa-yang-gurrij-marrdiyn? Ngaadagu ngi-waṉbina yij-mamaaḻang ngayawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Warruburru-yung warraambalalari, warruburru-yung anggu-wuguuguni amburru-burraa nugurri-rruj. Marri nimbirri-ngaynbandang-maynji, marri numburraaṉbina yij-mamaaḻang warruburru-wuy. Yagu ngaayung yagi nga-burrangi anaaji nugurri-rruj, ana-baḏag. ");
INSERT INTO nuy_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ngarraagi-yung ngi-waṉbini maaḻamburrg-galawaj. Anaani aḏaba wiij-barubaj-mana nga-ngawang-jinyung marri ngambambi-wurrdhii-yinyung. Wudani-yung-gala nga, ngarra-maṉinyung ngiwu-burrangi ana-malagaj ngayawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Anaani ngana-magana yijgubulu, warra-mulung-aynbaj-maynji warrubawi-yung ambarra-magana ana-lhaawu na-God-jinyung ana-lhal-aynbaj-gala ana-lhal, anubani-yung ambirriij-burryuwina wubani-yung ngi-waṉbini-yinyung, ngaadagi-yung ngarra-maṉinyung. Marri amburraawanggina ngigawi-nyinyung.” Dani-yung ni-yamayn na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Na-Judas Iscariot bagu wurraanggarra-ngu-burri, warra-12. Aḏaba ni-yanggi naagi-yung warruburru-wuy warra-runggu-runggal warra-priest. Marri nu-minbini na-Jesus, wani-yambini wugurri-wuy na-Jesus-inyung, nguynju yungguyung anubani-yung ambunu-bilhargaa naagi-yung. ");
INSERT INTO nuy_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Anubani-yung wurraawanggiyn anaani-yung ana-lhaawu, marri wurru-waḻaaḻarriyn. Marri wurru-yamayn, “Wiiyn nagang wuṉuga,” wurru-yamayn. Nga nigaayung ni-burri wurrugu, niwu-rangarrangi lhal-ngargu ari anaa-dhaawu-rarrjangi, nguynju yungguyung ambunu-bilhargang niga. ");
INSERT INTO nuy_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ngarrubagi-rruj ana-wulhu-wulhurr ngarraaḻirr wurru-mijgalmini-rruj, ngarraagi-rruj ngarraaḻirr ngi-mayini “waari anggu-wuḻbuḻwandi anu-ḏayn”. Bani-yung nga wurru-nguni, anubani-yung wurru-wini ana-jib, anubani-yung wurru-marrbuy-maa wubani-yung yaga ana-angel wanggu-rangga-ḻaabini, wubani-yunggaj. Warruburru-yung wurru-marrbuy-maa-yinyung wurru-yamayn, “Yuga aniga-wuy nimba-ngaynbandiyn naambu-warraalgaalgurmani ana-marrya, ngaambu-nguyii yadhu?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Na-Jesus wani-lharrgang wini-wulawaa waḻya-waa. “Nimbini-yaarri wubani-wuy a-runggal-wuy a-wumurrng. Bani-yung, nubagi numbunu-nang waḻyinyung, anima-warrguu gaṉdharra, nga anubani guugu ani-war-warrguu niga. Anaani bagu nambani-lhangarrmang nuguṉi. Nga nubagi-wuy numbunu-garrindharrmani nuguṉi nimbini-yaarri. ");
INSERT INTO nuy_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Anubani nga ani-yaarri a-wumurrng-guy niga. Nuguṉi buguni nimbini-yaarri aadanu. Nga bagu numbunu-yambina nubagi-yung-guy niwu-rangarrii-yinyung a-wumurrng, ‘Nubagi wani-yiyina-yinyung, nugawi-wuy nini-yandhawiwana, yuga aniga ana-gara wugurru, nguynju yungguyung ani-nguyii ana-marrya anubani-yung wanggu-rangga-ḻaabini-yinyung, marri nigawi-nyinyung warraawurru wurru-marrbuy-mana-yinyung, amburru-nguyii yungguyung wugurru?’ Dani-yung nimbini-yamana nuguṉi. ");
INSERT INTO nuy_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Anubani nambani-bajiyina runggal gara yuwaagu wu-burraa arrwar. Anubagu wu-warra-ngu-burraa aḏaba baadhi marri aynba-gaynbaj-jinyung. Anubagu ana-marrya nimbini-warra-ngu-burrii bagu.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Anubani wini-yanggi naawiṉi-yung. Wubanila-yung-gala-waj ni-yambini-yinyung na-Jesus wini-warra-lhangarrmayn bagu wuguṉi. Anubagu wini-warraalgaalgurmangi wurru-mijgalmini-yinyung wu-rangga-ḻaabini-yinyung ana-marrya. ");
INSERT INTO nuy_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Anubani-yung waadhaadharrwara-maa, na-Jesus marri warruburru-yung warra-12, wurru-yanggi buguni. ");
INSERT INTO nuy_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Marri anubagu wurru-burri wurru-ngunu-nguni-rruj, marri bagu ana-marrya wurru-nguni. Marri na-Jesus ni-yamayn, “Ngana-magana anaani aniijgubulu. Aynjaabu-nyung nugurri-rruj, ngambani-minbumana ngaya. Yaaji ni-burraa naagi, ngurraanggarra-nguyii-rruj yaaji.” Dani-yung ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Anubani-yung wurru-yimurrjiwurangi wugurru. Warruburru-yung warraaynjaaynjaabugij warraawurru-yung wunu-yandhawiwandi na-Jesus, “Ngaya waari, yuga?” ");
INSERT INTO nuy_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Na-Jesus nigaayung ni-yamayn, “Aynjaabu-nyung daju nugurri-wala, warra-12, nugurri-wala nga. Dagu yaga ni-lhalwulhii marrya dagu aynjaabu-nyung ngirrima-lhagaṉmayn amaami ama-gaṉdharra. ");
INSERT INTO nuy_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Wiijamana, ngaya-waj na-Niwiyayung na-Wurrujung-jinyung, anubani-yung anggu-waṉbina ngayawi-wuy, wubani a-wubiba-yinyung wu-magina. Yagu nubagi-yung-maynji ngaya ngambani-minbumana, ari ani-warragayii runggal-windiyung. Niga-magaa waari aniimbuḻwini, anubani-yung ni-maṉdhini.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Anubani-yung wurru-nguni-wugij bagu, na-Jesus ni-miyn anu-ḏayn, marri ni-yambini na-God-guy, marri ni-rayn-bagiwayn aḏaba. Niga waniini wugurru. Marri ni-yamayn, “Numburru-mani anaani anu-ḏayn. Anaani ngayawi-nyinyung a-ngun.gu, wu-yamana,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Aḏaba nima-miyn gaṉdharra, wubani wugargayag wu-burri. Marri ni-yambini na-God-guy marri waniini. Marri anubani-yung wurru-waḻ-nguni warraarraarrawindi. ");
INSERT INTO nuy_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Niga ni-yamayn, “Anaani nguynju yaga ngayawi-nyinyung ama-wulang, wu-yamana. Ngamaadbarrwumana ngaya nugurraa yungguyung warraarraarrawindi yungguyung. Anaani wiijamana, na-God nani-lhalamayana nugurri-wuy aadanu. ");
INSERT INTO nuy_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ngaya ngana-magana nugurru anaani, yagi aḏaba ngaaḻ-ngi anubanila anu-gargayag ana-wuyarrangaḻ-wala. Wurrugu marri, bagu ana-lhal na-God-jinyung, bagu marri nganggaḻ-nguyii ngijang, anggiij-gadhuwa-wiiyn.” Dani-yung ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Warraawurru-yung wirri-rawaa bagu, marri wurru-yanggi yuuguni, wuu-ngarra-ḏaba-rabaliyn. Yuuguni wurru-yanggi amubama-wuy ama-ṉuga ma-ḻandhirrngindi-wuy Mount of Olives-guy wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Wurru-yanggi… nga aḻagaḻa aḏaba. Naagi-yung na-Jesus wani-magayn, “Nugurru aadanu aḏaba numburru-man-jarramang, wu-yamana yamba anaani-rruj ana-wubiba, ‘Nubagi-yung yaga ni-ranga-rangarrii-yinyung wubani-wuy a-jib, ngaya nganu-wiiyn, marri anubani ana-jib anggu-man-jarramang,’ wu-yamana anaani ana-wubiba. ");
INSERT INTO nuy_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yagu wurrugu ngaya nga-ḻaḻagiiyn ana-ngawij-gala. Marri anubani-yung ngaynjaarri buguni Galilee-wuy, marri nugurru aadanu ngirri-ga-garri-yurii anubuguni.” Dani-yung ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nigaayung na-Peter nu-yambalmayn, “Warraawurru warra-mulung-arrgi-yung-maynji amburru-man-jarramang, ngaya anaani yagi,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nigaayung na-Jesus nu-yamijgayn, “Ngunu-magana anaani yijgubulu. Manaama-rruj mana-miyn.nganga, marri aadanu ba-yambina, ‘Naadagu ngaya nga-maḻaḻadi niga na-Jesus,’ ba-yamang, anubani-yung ba-yambina anggu-mal-bulaynbaj. Wurrugu ngarrubagi-yung ngarra-baawul angiiḏang-maynji anggu-mal-bulawaa.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Yagu nigaayung na-Peter ni-yamayn, “Yagi anubani-yung nga-yambi! Waari nga-maḻaḻadi-wi nagang! Ngaya nga-ngawiiyn nugawi-rruj!” ni-yamaa. Yagu warruburru-yung warra-mulung-arrgi-yung wugurraayung wurru-yamaa, wiij-nguynju anaani-yung ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Wurru-yangga-yanggi… nga wurru-waliyn aḏaba, wubani a-lhal Gethsemane. Marri wani-yamijgayn bagu wugurraayung wurru-marrbuy-maa-wuy, “Numburru-burraa yaaji, wurrugu ngaya ngaynjaarri marri ngaynjambina na-God-guy,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Wani-miyn Peter, James marri John, wurraanggarra-yanggi nigawi-wuy. Anubani-yung ni-walharaguni marri ni-wurrij-galadi-wini niga. ");
INSERT INTO nuy_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Marri ni-yamayn, “Ngaya anaani nga-wurrij-galadi-wiiyn-bindiyung, ari nga-ngawang, nga-wurrij-galadi-wiiyn yamba. Nugurru aadanu, yaaji numburru-burraa marri numburru-wanggirraa,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Anubani-yung ni-jarrarriyn yuuguni windiyung. Marri bagu ni-ḻandharrdhangayn, marri ni-yambini yuuguni arrwiyaj, na-Ninyarra-yung-guy, aniwu-yarini yungguyung anubani-yung ana-wungarri. ");
INSERT INTO nuy_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Marri ni-yamayn, “Ngayawi-nyinyung Baba, baaṉbina anubani-yung anaarrawindi nugaajbaj. Marri manaama mana-gaṉdharra bama-mang ngayawi-wala, nguynju yagi ngaarragayi yadhu. Yagu nugaajbaj baaṉbina ba-wijangayii, waari anubani-yung ngaya ngawu-ngaynbandii-yinyung,” ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Anubani-yung niigiyn warruburru-wuy warra-wulu-wulaynbaj-guy, wani-rangga-lhangarrmayn wugurru wu-lhagarra-yingayn. Nu-yamijgayn na-Peter-wuy, “Simon, yuga nuynjara-yara? Yagu waari aadanu aliyung ba-wanggirri ana-baḏag? ");
INSERT INTO nuy_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Numburru-wanggirraa, marri numburru-yambina a-lhuḏ yungguyung, nguynju anubani anaaladi yagi nanggu-rawu anaangaḏajung. Yijgubulu aadanu ana-wiri wu-waḏa-waḏaḏ nugurri-nyinyung, yagu nugurri-nyinyung ana-ngun.gu wu-bilwilwiluj.” Dani-yung ni-yamaa naagi-yung. ");
INSERT INTO nuy_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ngijang anubani-yung niigiyn-gaj-bugij, marri ni-yambini na-God-guy ngijang, ni-malgaagijgiyn. ");
INSERT INTO nuy_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Aḏaba niga ni-yanggi niigiyn ngijang, marri ngijang niga wani-lhangarrmayn wugurru wurru-lhagarra-yingayn, warruburru yamba wurru-yaal-ngawiiyn-bindiyung. Wurru-maḻaḻadi-wini, warruburru waari ambunu-yambini. ");
INSERT INTO nuy_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ngijang anubani-yung niigiyn anuuguni, ni-malgaagijgiyn niigiyn. Marri wani-yamijgayn, “Yagu nugurru nuu-lhagarra-yara-wugij marri nurru-yanga-yangina? Wiiya aḏaba. Anaani aḏaba wiij-barubaj-mana. Nubagi nganii-dhaawu-yarrijgini warruburru-wuy warraalaaladi-wuy, marri ngambambi-bilhargang, ngaya na-Niwiyayung na-Wurrujung-jinyung. ");
INSERT INTO nuy_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Numburru-ḻaḻagiiyn. Aḏaba ngagurru ngurru-yaarri. Yaagila ni-yaarri ngani-minbini-yinyung ngaya.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Wurrugu anaani-yung ni-yambini-wugij, nigaayung nubagi-yung na-Judas, warruburru-yung-jinyung warra-12, ni-yanggi buguni nigawi-wuy, marri warruburru-yung garnyirrimba. Warraawurru-yung wirri-warra-waṉagaa galiwanga marri rangag. Marri bagala wurru-yanggi warruburru-yung-gala warra-runggu-runggal warra-priest, marri warruburru-yung warra-yiyini-yinyung ana-lhaawu-runggal, marri warra-mijiwanggu wugurru. Wurrugu anaani-yung ni-yambini-wugij, nigaayung nubagi-yung na-Judas, warruburru-yung-jinyung warra-12. Ni-yanggi buguni nigawi-wuy. Arraarrawindi ni-man-garrwaay. Warraawurru-yung wirri-warra-waṉagaa galiwanga marri rangag. Marri bagala wurru-yanggi warruburru-yung warra-runggu-runggal, marri warra-yiyini-yinyung ana-lhaawu-runggal marri warra-mijiwanggu. ");
INSERT INTO nuy_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ana-wulhu-wulhurr-waj, na-Judas anaani-yung wani-magaa, “Wurrugu nganu-lhawuynjang naadagu na-waḻyinyung. Bagi-yung nga. Numbunu-bilhargang niga, marri numbunu-yarrijgina, numbunu-yarina, numbunu-rangarrii,” anubani-yunggaj ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Anubani-yung aḏaba na-Judas ni-yanggi andhurrg na-Jesus-guy. Ni-yamayn, “Barra-yiyina-yinyung!” marri nu-lhaawuynjayn niga. ");
INSERT INTO nuy_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Warraawurru-yung aḏaba wurru-yanggi wunu-bilhargayn niga. ");
INSERT INTO nuy_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Anubani-yung aḏaba naaynjaabu-nyung ni-marrbuy-maa-yinyung bagu ni-lhaay. Naagi-yung niwu-waṉagaa galiwanga. Niwu-ngarrgiwaa niga, ana-galiwanga, nga naagi-yung ni-jarrarriyn nubagi-wuy na-waḻyinyung-guy naa-mijgalmini-yinyung na-runggal-yung na-priest-jung. Niga ni-jarrarriyn-bugij, marri dhiḏ! Nu-lhiyn! Naa-guldhiyn manubama-yung mana-warang. ");
INSERT INTO nuy_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Anubani-yung na-Jesus wani-magaa warruburru-yung, “Yuga nugurru aadanu nurru-yanggi galiwanga nirri-warra-waṉagana? Yuga majirrijirri nirrima-waṉagana, ngirri-bilhargaa yungguyung? Yuga ngaya anaani ngaandha-wungarri yamba? ");
INSERT INTO nuy_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ngarraaḻirr-lhangu ngaya nga-burri ana-Temple-Maṉngulg-duj marri bagu nga-yambini, yagu nugurru waari ngirri-bilhargaa ngaya anubagu. Yagu anaarrawindi-lhangu na-God-jinyung ana-lhaawu, anubani-yung anggu-wandhurrg-mana.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Aḏaba wugurraayung warruburru-yung wurru-marrbuy-maa-yinyung wunaarruyn niga marri wurru-man-jarramayn wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Yagu naagi-yung wulmurr-inyung bagu nu-garrindharrmangi. Manaama-yung ni-yabini ma-waḏa-waḏaḏ mana-yaaḻi. Marri nigaayung wunu-bilhargayn. ");
INSERT INTO nuy_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Yagu bagu-waj nimaarruyn mana-yaaḻi marri ni-yarramayn ni-ngun.gu-mamar niga. ");
INSERT INTO nuy_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Na-Jesus wunu-miyn aḏaba. Wunu-yarrijgini buguni nubagi-wuy na-priest na-runggal-yung-guy. Bagu na-runggal-yung ni-burri, marri warra-mulung-aynbaj wugurraayung warra-runggu-runggal warra-priest marri warra-mijiwanggu marri warra-yiyini-yinyung ana-lhaawu-runggal. Bagu wurraanggarra-ngu-burri warruburru-yung. ");
INSERT INTO nuy_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nigaayung na-Peter nu-garrindharrmangi na-Jesus, yuwaagala yagu adhaa…dharri ni-yangga-yanggi. Ni-yanggi buguni wubani-wuy a-wumurrng-guy nubagi-yung-jinyung na-runggal-yung na-priest. Anubani-yung ni-yanggi nga buguni ni-yabiyn. Nga bagu ni-ralmaa a-ngura-rruj. Warruburru-yung wurru-mijgalmini-yinyung wugurru wurraanggarra-ngu-burri. ");
INSERT INTO nuy_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Wugurraayung warra-runggu-runggal warra-priest marri warruburru-yung wuu-yamba-yambini-yinyung, wirri-raguni lhaawu na-Jesus-inyung, yuga anubani yangi wu-waṉbini, ana-raga-ragij, nguynju yungguyung naagi ambunu-ngawijgayn yungguyung. ");
INSERT INTO nuy_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yagu waari anubani-yung ambirri-lhangarrmaa ana-lhaawu. Arraarrawindi wurru-wurruj wurraawaḻangi na-Jesus-inyung, wurru-yambini anubani-yung aynba-gaynbaj, yagu anubani ana-lhaawu waari anubani anggiyn-nguynju-magaa. ");
INSERT INTO nuy_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Yagu warra-mulung-aynbaj warruburru-yung wugurraayung wuu-ḻaḻagini nga wurraawaḻangi, wurru-yamaa, ");
INSERT INTO nuy_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nurraawanggini naagi-yung na-waḻyinyung, marri ni-yamaa, ‘Anaani nganggu-jadugang anaani ana-Temple-Maṉngulg, anaani yamba waḻya-waḻya wirri-maṉdhangi, marri nganggu-rayii ngijang amuulawaa-wala mana-miyn.nganga, yagi warra-waḻya-waḻya wirri-maṉdhi anaani.’” Dani-yung wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Yagu ana-lhaawu waari anaani-yung wiij-nguynju-wugij wurru-yambini-yinyung warruburru-yung. ");
INSERT INTO nuy_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nigaayung nubagi-yung na-runggal-yung ni-lhangayn raga-ragij wugurri-rruj, marri nu-yandhawiwandi na-Jesus. “Yuga nagang numba-yambalmana? Anaani yuga ana-lhaawu wu-yaminggarrina, wurru-yambiynjina nugawi-nyinyung?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nigaayung na-Jesus naagi-yung waari ani-yambini. Ngijang nubagi-yung na-runggal-yung nu-yandhawiwandi ngijang, “Yuga nugawaj aadanu na-Messiah, nuṉḏagaana-yinyung, yuga nugawaj na-Niwiyayung nubagi-yung-jinyung ngaanu-warraarriwana-yinyung anaarrwar-yinyung?” ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Na-Jesus nigaayung ni-yamayn, “Yuu, ngaya-waj anaani, marri nugurru aadanu ngirri-nayii ngaya, (Daniel 7:13) ‘na-Niwiyayung na-Wurrujung-jinyung, ngaya nga-ngu-burraa walawalama nubagi-yung niwu-waṉagana-yinyung ana-lhuḏ. Marri nga-ngu-dhirridang anubani-yung ngubunung-mirri a-wumala-wala,’ ” Dani-yung ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nubagi-yung na-runggal-yung nigawi-nyinyung nimaarra-ḻaḻaani mana-yaaḻi, marri ni-yamayn, “Waari ngaamba-ngaynbandang warraaynbaj, ngarrambi-magi ana-lhaawu naagi-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nugurru aadanu nurraawanggini anaani ana-lhaawu. Naagi-yung naaladi-yamawaa na-God! Yangi yuga nugurru nurru-wijangayii aadanu aḏaba?” ni-yamayn. Yagu warruburru-yung warraarrawindi wugurraayung wurru-yamayn, “Naadagu naaladi-yamawaa yamba, ani-ngawang,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Anubanila, mulung-aynbaj wunu-yudangi. Marri wunu-yilhal-ambamadhangi marri wunu-ramarra-wadjangi. “Ba-yambina lhaawu na-God-gala aḏaba!” wurru-yamaa. Marri warruburru-yung wurru-mijgalmini-yinyung wunu-miyn marri wunu-wini wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nigaayung nubagi-yung na-Peter bagu ni-burri aarabarabalu-rruj. Ngarrubagi-yung ngarra-ngaḻaynjinyung ngi-mijgalmini-yinyung nubagi-yung na-runggal-yung-jinyung, buguni ngi-yanggi. ");
INSERT INTO nuy_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nga ngunu-nayn na-Peter, bagu ni-ralma-ralmaa. Ngunu-nani… nga ngi-yamayn, “Nagang aadanu niiniinggaanggarra-yanggi-yinyung naagi na-waḻyinyung wubanila a-Nazareth-gala, naagi na-Jesus,” ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nigaayung na-Peter ni-yamaa, “Ngaya anaani nga-maḻaḻadi niga. Waari nga-marrbuy-magaa nuynjambina-yinyung. Aadanu waari nga-marrbuy-magaa,” ni-yamaa. Ngijang ni-yanggi wubani-wuy aaynbaj-guy. Ngarrubagi-yung ngarra-baawul ngiiḏiyn ngiga. ");
INSERT INTO nuy_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ngarrubagi-yung ngarra-ngaḻaynjinyung ngijang ngunu-nayn. Marri ngijang ngi-yambini warruburru-wuy wurraarra-garra-lhi-wuy, “Naadagu ni-yamana wurraanggaanggarra-yanggi-yinyung,” ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Anubagu nigaayung ngu-yambalmayn, ni-yamayn, “Waari, nga-maḻaḻadi nubagi,” ni-yamayn. Wurrugu malgadhaadharri ngijang, warruburru-yung-jinyung wurraarra-garra-lhi wunu-yamijgayn ngijang na-Peter-wuy, “Yijgubulu nagang aadanu niiniinggaanggarra-yanggi-yinyung. Nagang aadanu Galilee-wala!” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nigaayung aḏaba ni-yamayn, “Anaani nganggawaḻii-maynji, na-God ngambani-jadugang ngaya! Naadagu na-waḻyinyung nurru-yambina-yinyung, naadagu nga-maḻaḻadi niga!” ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ngijang ngarrubagi-yung ngarra-baawul ngiiḏiyn ngijang. Na-Peter bani-yung ni-marrbuy-mayn anubani-yung na-Jesus-inyung nu-yambini, “Aadanu ba-yamana nu-maḻaḻadi ngaya, ba-yambina anggu-mal-bulaynbaj. Wurrugu ngarrubagi-yung ngarra-baawul angiiḏang-maynji anggu-mal-bulawaa.” Yagu bani-yung na-Peter ni-wij-barrngayuyn marri ni-ruguni-windiyung niga. ");
INSERT INTO nuy_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Anubanila ngi-lhalmbalangi. Warruburru warra-runggu-runggal warra-priest marri warra-mijiwanggu marri warruburru-yung warra-yiyini-yinyung ana-lhaawu-runggal, marri warruburru-yung wuu-yamba-yambini-yinyung, warraawurru-yung wurru-muṉḏugaa. Wugurru wunu-radbini aḏaba niga, wunu-yarrijgini niga marri wunu-burriyn bagu na-Pontius Pilate-duj na-runggal-yung ana-Rome-jinyung. ");
INSERT INTO nuy_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Yagu nigaayung na-Pilate nu-yambiḻibiḻingaani, “Nugawaj yuga na-Runggal-yung warra-Jew-yinyung?” ni-yamayn. Na-Jesus nigaayung ni-yamayn “Anaani nugawi-nyinyung ana-lhaawu,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Warruburru-yung warra-runggu-runggal wunu-lhajbini na-Jesus, wurru-yamayn “Yuu, anaani ni-waṉbini aladi-windiyung,” wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Na-Pilate ngijang nu-yandhawiwandi na-Jesus-guy, “Yuga yagi nagang nimbi-yambalmi, yuga? Yuuguni ba-wawanggina. Wurru-yamana warruburrala nugawaj nunggaṉbini anaaladi-windiyung,” ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yagu na-Jesus waari-wugij anubani-yung anu-yambalmaa. Na-Pilate naagi-yung ni-walharaguni niga. ");
INSERT INTO nuy_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Manubama-yung-duj manaarmag wu-rangga-ḻaabini-yinyung, nubagi na-runggal-yung na-Pilate ni-yamaa-wugij, nu-waḻamin-dharrgang naaynjaabu-nyung wunu-radbini-yinyung, warruburru-yung-jinyung warra-wurru-wurruj wugurru wurru-wajbarini-yinyung. ");
INSERT INTO nuy_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Yagu anubani-rruj ana-mal-ḏaga-ragij-gaj, warra-mulung-arrgi-yung warra-Jew warraawurru-yung wurru-yanggi wurru-wiynjini buguni, wurru-wiynji-wiynjini-wuy warra-Roman-guy. Warra-wini bagu. Naaynjaabu-nyung bagu, na-nimuwaj-jung Barabbas. Naadagi-yung bagu ni-radbidhii, warra-mulung-aynbaj-duj. ");
INSERT INTO nuy_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Warraawurru-yung warraarraarrawindi wurru-yanggi buguni na-Pilate-guy. Anaani-yung aḏaba wunu-yandhawawandi, “Baaṉbina aadanu nugawaj nguynju yaga wubani nunggaṉbini a-raga-ragij-gaj,” wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nigaayung na-Pilate wani-yambalmayn, “Yuga ngaya nganu-warrgarrga-wang naagi na-Runggal-yung warra-Jew-yinyung? Yuga naagi-yung nugurru nuunu-ngaynbandiyn?” ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Dani-yung nga ni-yamayn na-Pilate, ni-marrbuy yamba anubani-yung wunu-yayn na-Jesus nigawi-wuy warraawurru-yung wunu-margiriyn yamba nigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Warra-runggu-runggal warraawurru-yung warra-mandagarrawindi warra-magaa aḏaba nga wurru-wurrij-nagiyn warruburru-yung wurru-muṉḏugaa-yinyung warra-wurru-wurruj. Wunu-ngaynbandangi naagi-yung na-Barabbas ani-burri ani-warrbidi-maa, waari-magaa nigaayung na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nigaayung na-Pilate ni-yamayn, “Yagu ngaynjaminggarrina nganggaṉbina naagi-wuy, nuunu-mayana-yinyung ‘na-Runggal-yung warra-Jew-yinyung’?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yagu warruburru-yung wurru-yingarraḏdhiyn, “Numbunu-marang-barra-rayii a-rangag-duj!” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Yagu nigaayung na-Pilate ni-yamayn, “A-yangi-yungguyung? Waari anaaladi niga ani-waṉbini!” ni-yamayn. Yagu wugurraayung wurraaḏangi-wugij, “Ani-ngawang-bugij niga!” wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Aḏaba niga na-Pilate wani-ngaynbandangi ambani-waḻaaḻarrijgana warruburru-yung warra-garnyirrimba. Niga nu-lharrgang na-Barabbas ni-warrgarrga, yagu na-Jesus wani-yayn warruburru-wuy wurru-wiynji-wiynjini-wuy, “Numbunaarra-waḏjiwumana marri numbunu-yarrijgiyn aḏaba, bagu numbunu-marang-barra-rayii aḏaba, a-rangag-duj.” Dani-yung nga ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Warruburru-yung wurru-wiynji-wiynjini-yinyung wunu-yarrijgini buguni wubani-wuy na-Pilate-jinyung a-wumurrng-guy. Marri warruburru-yung warraa-gaḏiyn warraarrawindi wurru-wiynji-wiynjini-yinyung wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Manubama-yung wunu-yabijgayn na-Jesus-guy, mamanunggu-windiyung mana-yaaḻi manubama-yung, nguynju na-king-jii ni-yaba-yabina-yii yaga, ma-yamaa. Marri anubani-yung wirri-miyn rawurrumugurrumu, marri wirri-dhawawarumaa, marri anubani-yung wunaambaḻ-yadiyn niga. ");
INSERT INTO nuy_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Marri anubani-yung wurru-lhaay marri anubani-yung wurru-marang-ngangarawini nigawi-wuy wurru-yamaa, “Ngunu-warraarriwana! Way! Runggal-yung warra-Jew-yinyung!” wurru-yamaa wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","20","Anubani-yung wunaambaḻ-wadjangi rangag-mirri. Marri anubani-yung wunu-yudangi. Marri wurru-yanggi marri wuu-ḻandharrdhi marri wurru-burrdi nigawi-rruj raga-ragij, wunu-warraarriwaa, wunu-rajburrnani. Anubanila-wala, manubami-yung wunaa-ngarrgiwayn mana-yaaḻi marri ngijang wunu-yabijgayn manubama-yung mana-yaaḻi, wunaa-gaagijgiyn. Anubanila-wala aḏaba, wugurru wunu-yarrijgini, wunu-rabalini, ambunu-ngawijgaa yadhu niga. ");
INSERT INTO nuy_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yagu nubagi-yung waḻyinyung bagala-yung ni-yaḻdhangi, na-nimuwaj-jung Simon, wubani-yinyung a-lhal-inyung a-Cyrene-yinyung. Naagi-yung na-ninyarra-yung nubiṉi-yung-jinyung na-Alexander-yinyung marri na-Rufus-inyung. Anubagala juju…j-gala ni-yanggi, buguni Jerusalem-guy. Wurru-yamayn, “Bawu-warrgurrang aani a-rangag naagi-yinyung.” ");
INSERT INTO nuy_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Na-Jesus naagi-yung wunu-yarrijgini wubani-wuy a-lhal-wuy, anu-muwaj wu-mayini Golgotha. Wiijamana wugurru anaani, ana-lhal a-ngagara-yii ana-yinag, wu-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Anubani-yung warruburru-yung wurru-wiynji-wiynjini-yinyung wirri-waḻangi wine-mirri, wugargayag, marri wu-ḻamij-galadi, anubani-yung wunu-yayn na-Jesus wunu-waḻ-ngujgaa anubani-yung. Wunu-yayn, yagu niga ni-lhaabiyn. ");
INSERT INTO nuy_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Marri anubani-yung wunu-marang-barra-raani wubani-wuy a-rangag-guy aḏaba. Marri manubama-yung mana-yaaḻi wurraarraayajarrangi aḏaba. Amudama-yung yungguyung wurraayigini ama-yaaḻi, yangi-nyung anima-mangi niga magurru. ");
INSERT INTO nuy_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Anaani-yung yaaji aḏaba arrwar, ngi-waḻirr-wadadiyn. ");
INSERT INTO nuy_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Anubani-yung wirriirrarrangi bagu wu-mari a-rangag-duj. Wu-yamaa anubani-yung, “Na-Runggal-yung warra-Jew-yinyung.” ");
INSERT INTO nuy_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Yagu nubiṉi-yung wini-wulawaa wini-wungarri-dhini-yinyung warra-marang-barra-raani warubaj na-Jesus-duj, aynjaabu-nyung walawalama-wala marri naaynbajung mangaṉḏayayaagu-wala. ");
INSERT INTO nuy_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Anubanila-wala warruburru-yung warra-wurru-wurruj wurru-yaḻdhangi, wuu-yambini yij-maaḻang. Marri anubani-yung wuu-ḻang-barawararbini. Marri wurru-yamaa, “Nugawaj nuynjamaa, bawu-jadugang anubani ana-Temple-Maṉngulg marri ngijang bawu-rayii muulawaa-wala mana-miyn.nganga! ");
INSERT INTO nuy_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Yagu ba-maṉmiiyn aḏaba, baaṉiyn, ba-dhirridang aḏaba aadanu a-rangag-gala!” Dani-yung wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Wugurraayung warruburru-yung waa-runggu-runggal-inyung warra-priest marri warra-yiyini-yinyung ana-lhaawu-runggal warraawurru-yung wunu-rajburrnani na-Jesus. Wugurru wurru-yamayn, “Niga wani-maṉmangi warra-mulung-aynbaj yagu niga waari ninggu-waṉagang ana-lhuḏ, waari ni-maṉmi nigaaj-baj! ");
INSERT INTO nuy_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Niga ni-mayini na-Messiah, na-runggal-yung warra-Israel-yinyung! Ari ani-dhirridang ana-rangag-gala! Bani-yung ngagurru ngaanu-nayii marri ngaambu-jambarrgiiyn nigawi-wuy!” wurru-yamaa. Wuguṉiiyung nubiṉi-yung na-wulawaa wini-ngarrmaa, wuguṉiiyunggaj. ");
INSERT INTO nuy_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Aḏaba yaaji arrwar ngi-waḻirr-wadadiyn, anubani-yung aḏaba waangamudiyn anubani-rruj ana-lhal, wurrugu waangamudangi-wugij nga yaajijila arrgarrgaḻi ngi-waḻirr-wiḻibiḻingiyn. ");
INSERT INTO nuy_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Anubanila-wala aḏaba, na-Jesus niiḏangi yanggarrwar-mirri, ni-yambini anubani-yung ana-lhaagi Aramaic-mirri, “Eloi, Eloi, lama sabachthani?” ni-yamayn. Wiijamana anaani ana-lhaawu, (Psalm 22:1) “Ngayawi-nyinyung na-God, ngayawi-nyinyung na-God, a-yangi yungguyung ngaya nimbaarruyn?” ");
INSERT INTO nuy_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Anubagu-yinyung wurraarra-garra-lhi wurraawanggini anaani ana-lhaawu. Warra-mulung-aynbaj wurru-yamaa, “Yuga naadagu naa-gaḏii na-Elijah-wuy?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ni-nguḻu-nguḻubiyn nubagi naaynjaabu-nyung ni-wuwaḻgayn, nga ni-miyn alhilhig marri ni-warwarryangi vinegar wugargayag marri niwu-rangag-gabaa a-rangag-guy. Marri nu-yayn na-Jesus, nguynju ani-waḻ-nguni yungguyung. Nubagi-yung ni-yamayn, “Wurrugu, ngagurru nguunu-ngaynbandiyn ngaanu-nayii na-Elijah. Ari ani-rabalang anu-maṉmang niga,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ngijang na-Jesus niiḏangi yanggarrwar-mirri, marri ni-ngawiiyn. ");
INSERT INTO nuy_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Manubama-yung mana-yaaḻi anubagu-yinyung ana-Temple-Maṉngulg-duj ma-burri, manubama-yung ma-ḻaḻmayn yuwaagu arrwar-wala nga yuuguni lhirribala-wuy. ");
INSERT INTO nuy_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Aynjaabu-nyung runggal-yung wurru-wiynji-wiynjini-yinyung, bagu ni-lhaay warubaj na-Jesus-duj. Nu-nani bagu ni-ngawiiyn naagi-yung, marri anaani ni-yamayn, “Niga yijgubulu na-Niwiyayung na-God-jinyung!” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wugurraayung warra-maṉaṉung wurraarra-garra-lhi, wurraarranggaa yuwaagala malanganyanay. Warra-mulung-arrgi-yung ngarra-Mary Magdalene, marri ngarraaynbajung ngarra-Mary nga-rriibi-yung naawiṉi-yung na-James-inyung marri na-Joses-inyung, marri ngarra-Salome. ");
INSERT INTO nuy_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Anu…bani-yunggaj warraawurru-yung wunu-garrindharrmangi bagu ana-Galilee-rruj marri wunu-maṉmangi. Arraarrawindi bagu maṉaṉung wugurraayunggaj wurraarra-garra-lhi bagu, marri wunu-nani naagi-yung na-Jesus ni-ngawiiyn. Anubani-yunggaj warraawurru-yung wurraanggarra-yanggi na-Jesus, buguni Jerusalem-guy. ");
INSERT INTO nuy_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Anubani-yung anaadharrwara aḏaba. Yagu anubani-yung wirri-mayana “amburraarraalgaalgurmani”. Anubani-yung raga-ragij-gaj ngarraaḻirr-maṉngulg-duj. ");
INSERT INTO nuy_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Nubagi-yung na-Joseph, bagala Arimathea-wala, naagi-yung ni-runggal marri niimbaḻaman na-waḻyinyung. Naagi-yung, wurru-yamba-yambiynjini-yinyung warruburru-yung-jinyung, waa-runggu-runggal. Nga anubagu niimbu-narrini na-God-jinyung warru-mandag, ni-jambarrgiiyn naagi-yung yamba na-God. Marri naagi-yung ni-ḏirrbaabara, ni-yanggi na-Pilate-guy, nu-yandhawiwandi, “Nimbiiyn anubani ana-wubulu nigawi-nyinyung na-Jesus-jinyung,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yagu na-Pilate nigaayung anubani ni-wurri-ḻaḻmayn, na-Jesus yamba anubani-yung ni-ngawiiyn aḏaba. Ni-ngawiiyn ni-nguḻu-nguḻubiyn. Na-Pilate nubagi naa-gaḏiyn nubagi-yung na-runggal-yung wurru-wiynji-wiynjini-yinyung, “Yuga naagi-yung ni-ngawiiyn?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nigaayung “Yuu,” ni-yamayn. Na-Pilate nigaayung nu-yamijgayn na-Joseph-wuy, “Yii, bawu-yarrijgina nigawi-nyinyung ana-wubulu,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nigaayung na-Joseph naagi-yung nima-miyn yaaḻi marri anubani-yung niwu-ngarrgiwayn ana-wubulu, anubanila ana-rangag-gala, nga anubani-yung niwu-warraabaabaa. Naagi-yung niwu-yurangi nga niwu-burriyn bagu ama-gara-rruj ama-ṉuga-rruj. Marri mana-ṉuga manaama-yung nima-dhawawarumayn, nima-jurangi bagu, nima-dhidiyn amubama ama-madhawang. ");
INSERT INTO nuy_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nigaayung ngarra-Mary Magdalene, marri ngarraaynbajung ngarra-Mary nga-rriibi-yung na-Joses-inyung, wingiwu-nayn anubani-yung ana-lhal nubagi-yung wunu-burriyn-jinyung na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Anubani-yung malgadhaadharri, ngarrubagi-wala ngarraaḻirr-maṉngulg-gala, ngarra-Mary Magdalene, marri ngarra-Mary nga-rriibi-yung na-James-inyung, marri ngarra-Salome, anaani-yung wirri-nimaa arrawuj-mamaaḻang, nguynju yungguyung ambirri-waḻbini yungguyung nigawi-nyinyung ana-wubulu. ");
INSERT INTO nuy_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bagila ngi-ḻambalangi. Warraawurru-yung aḏaba wurru-yanggi, wubani-wuy wuu-wurrdhu-wurrdhini-wuy wurru-yanggi. ");
INSERT INTO nuy_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Marri bagu wurru-yamijgaynjini, “Yangi-nyung marri warrubawi-yung ngambambii-ngu-jurang mana-ṉuga anubanila wu-wurrdhu-wurrdhina-wala ma-gara-ngu-dhidina yamba muga?” wurru-yamijgaynjini. ");
INSERT INTO nuy_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Yuuguni wurraarranggayn, maari anubagu mana-ṉuga ma-burri ama-dhidini. Anubani-yung ma-gara-wawalhangi. ");
INSERT INTO nuy_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Marri anubani-yung wurru-yanggi amubama ama-gara-wuy, anubani-yung wurraarranggayn bagu waḻyinyung wulmurr-inyung. Wubani-rruj ni-burri naagi-yung a-walawalamag-gala. Naagi-yung mana-yaaḻi ni-yabini ngalngalngaluj-bindiyung. Warraawurru-yung wurru-wurri-ḻaḻmayn wugurru. ");
INSERT INTO nuy_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Marri wani-yamijgayn, “Yagi nugurru nurru-wurri-ḻaḻmi. Nuunaa-garra-garranggana na-Jesus a-Nazareth-jinyung, nubagi-yung-jinyung wunu-raani-yinyung yuwaagu a-rangag-duj. Aḏaba yagu niga ni-ḻaḻagiiyn, niiri anaaji! Numburraarranggana, yaani yigaj niga ni-murrgulhi. ");
INSERT INTO nuy_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Numburraagiyn marri nambarra-magana warruburru wurru-marrbuy-maa-yinyung, marri na-Peter-wuy, ni-yaarri buguni Galilee-wuy, raga-ragij nugurri-wuy. Bagu, nugurru numbunu-nayii niga, wubani-yung yaga nani-magaa nugurru.” Dani-yung ni-yamaa na-waḻyinyung niga. ");
INSERT INTO nuy_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Warraawurru-yung wurru-ḏirrngawiiyn marri wurraarra-galalangi. Yagu yamba anubani-yung, anubanila wurraagiyn-gaj-bugij aḏaba wurru-garrigiyn-gaj marri wurraagulhaynjini, wurru-ḏirrngawiiyn yamba. Waari ambarra-magaa warra-mulung-arrgi-yung wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Guwaj Theophilus, anaani ngawu-lharrganjii nugawi-wuy ana-lhaawu. Nu-marrbuy anaani, arraarrawindi wurru-wurruj wuu-yambini waarrarrini, anaani-yung na-God-jinyung ni-waṉbini, anaani-rruj ana-lhal ngurru-burraa-rruj. ");
INSERT INTO nuy_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Warraarrawindi anaani wurraarranggaa marri wurraambu-narrini anubani-yung na-God-jinyung ni-waṉbini, ana-wulhu-wulhurr-wala ni-mijgalmini na-Jesus. Anubani-yung ngarrambi-magaa ngagurri-wuy ana-lhaawu. Marri anubani-yung wii-rangarrangi wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ngaya anaani nga-wawanggini anaani ana-lhaawu, maaḻamburrg-bindiyung. Anaani-yung ana-lhaawu niga na-God-jinyung ni-waṉbini-yinyung. Anaani-yung nga-wawanggini wu…bani-yunggaj. Anaani-yung nga-wijangani, ari anaani-yung ngaayunggaj, nganggarrarrangi yungguyung wu…banila-yung-galawaj. Danu nga aḏaba wiij-maṉdhina. Danu nga nugawaj Theophilus, nagang nuṉḏunggal, ");
INSERT INTO nuy_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","anaani nagang ngunaa-garrarrangi nugawi yungguyung. Nguynju yadhu ba-marrbuy yungguyung aniijgubulu anubani-yung-jinyung nunggaawanggini-yinyung anaani. ");
INSERT INTO nuy_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Anubani anu…bani-yunggaj, na-Herod na-king ni-buunggawa-maa wubani-yung-duj a-lhal a-Judea-rruj. Naaynbajung nigaayung naagi-yung na-priest, na-nimuwaj-jung naagi ni-mayini Zechariah. Ngarraagi-yung nga-rangarrina-yung ngarra-ngarrimuwaj-jung Elizabeth. Anu…bani-yunggaj warra-mi…yn-ngambara-waj, nubagi-yung na-Aaron, ni-burri ni-priest. Naagi-yung na-Aaron-gala, naaynbajung ni-mijgalmini-yinyung, nga naagi-yung na-nimuwaj-jung Abijah niga. Naagi-yung na-Abijah-wala, nubagi na-Zechariah ni-mijgalmini-yinyung niga. ");
INSERT INTO nuy_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Naawiṉi-yung na-Zechariah marri ngarra-Elizabeth, naawiṉi-yung wini-burri maaḻamburrg-galawaj na-God-guy. Naawiṉi-yung yungguyung wuguṉi wurru-marrbuy, winiwu-yandhurrbangaa ana-lhaawu-runggal na-God-jinyung maaḻamburrg-bindiyung. ");
INSERT INTO nuy_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Yagu waari wuguṉi warra-mijburrayung ambani-waṉagaa. Ngarraagi-yung ngaa-Elizabeth waari ambangi-waṉagaa warra-wirrig. Naawiṉi-yung wini-burri aḏaba ngi-ngajiwanggu-maa, marri nigaayung ni-yiwanggu-maa. ");
INSERT INTO nuy_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Naagi-yung ni-burri bagu ni-mijgalmini, niga naa-ja-jambini-yinyung na-God, wubani-rruj a-Temple-Maṉngulg-duj. Nigawi-nyinyung warru-mandag na-Abijah-yinyung bagu wurru-burri, wurru-mijgalmini wugurraayunggaj. ");
INSERT INTO nuy_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Anaani-yung anubani-yunggaj, wirrima-ṉuga-ngu-dhawawarumaa ṉuga, nguynju yadhu niga na-God ni-wajbariyn yangi-nyung aynjaabu-nyung. Naagi-yung ni-yanggi-magaa niwu-nangaa wunguban, wubani-rruj a-Temple-Maṉngulg-duj, lhirribala ni-lhaay. Anaani-yung wurru-yamaa wuguuguni-wugij wiijamaa wugurru. Anaani-yung, na-God niga ni-wajbariyn naagi-yung na-Zechariah nguynju yungguyung buguni ni-yanggi wubani-wuy a-Temple-Maṉngulg-guy. Nga ni-yabiyn lhirribala buguni a-wumurrng-guy wubani a-gara. ");
INSERT INTO nuy_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Marri bagu aarabarabalu-rruj, warraawurru-yung warraarrawindi wurru-yambini nigawi-wuy na-God-guy, anubani-yumbaa wugurru wu-nagini-rruj anubagu-rruj ana-lhirribala anubani anu-nguban. ");
INSERT INTO nuy_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Naagi-yung na-Zechariah ni-lhaay niga bagu lhirribala a-Temple-Maṉngulg-duj. Niga ni-warranggayn bagu ni-nani aynjaabugij angel wu-lhaay na-Buunggawa-yinyung ni-lharrgang. Wubani-rruj wu-lhaay bagu walawalama-wala ma-ṉuga-muṉḏugini-rruj ama-ṉuga a-wunguban-duj, lhirribala bagu a-Temple-Maṉngulg-duj. ");
INSERT INTO nuy_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Naagi-yung na-Zechariah ni-warranggayn nga ni-nayn, anubani-yung niga ni-wurri-ḻaḻmayn marri ni-wurrij-barrwarrangi, ni-ḏirrngawiiyn-bindiyung, niga ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Wugurraayung wu-yamayn ana-angel nigawi-wuy, “Yagi ngaya nimba-yami anaani, Zechariah. Nagang aadanu nuynjambini, niga na-God aadanu ninii-gawanggini nagang. Marri nagang ngaadagu nga-rangarrinaaj ngarra-Elizabeth, ambangi-waṉagana wirrig, ambangi-yabang gujuju, nuguṉi-nyinyung-jinyung. Banu-mayang niga na-nimuwaj-jung ani-mayina John. ");
INSERT INTO nuy_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Anubani-yung-maynji aniimbuḻwiyn niga, nagang ba-wurrij-gaḻaaḻarrii, marri ba-ḏinggina nagang. Warraarrawindi-lhangu wugurru anubani amburru-waḻaaḻarrii, ");
INSERT INTO nuy_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","niga yamba ani-runggal na-Buunggawa-yinyung. “Yagi niga ni-waḻ-ngi ana-wine marri ana-grog. Anubani-yung ana-Maṉngulg Mawurr wugurru anggu-burraa nigawi-rruj, aninggaambamadhii niga, anubanila-wala aniimbuḻwiyn-maynji. ");
INSERT INTO nuy_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Naagi-yung ani-yambina ana-lhaawu, nguynju yungguyung warruburru-yung warraarrawindi warra-Israel amburraagina, marri amburru-waliynjina na-Buunggawa-wuy, wugurri-nyinyung-guy na-God.” ");
INSERT INTO nuy_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Anaani ana-angel ninggu-yambini-wugij. “Nagang na-niwiyaay, ani-ragaana raga-ragij, na-Buunggawa-yung-guy. Ani-waṉbina naagi-yung-maynji, niga nguynju yaga na-Elijah-yii. Aniwu-waṉagana lhuḏ nigawi-yii. Anubani-yung-maynji ani-yambina-maynji niga, nguynju yadhu warruburru-yung amburraaynjaabu wugurru, warruburru-yung-guy warra-mi-ninyarra-yung marri warra-mijburrayung, amburraa-ḏamarr-ngu-burrangijgaynjina wugurru. Warruburru-yung wugurru waari-yinyung ambunu-yandhurrbang na-God, marri anubani-yung amburraaynbijgiiyn aḏaba wugurru, nguynju yadhu amburraawanggina marri amburru-maaḻamburrg wugurru, nguynju yaga warruburru-yung-jii warraambaambaḻaman-jii warra-wurru-wurruj. Nguynju yadhu warraawurru-yung warra-wurru-wurruj na-Buunggawa-yinyung, amburru-burraa marri amburraandhurrg-gina wugurru maaḻamburrg na-Buunggawa yungguyung, niga yamba na-Buunggawa ani-walang aḏaba lhaalhag.” Dani-yung nga wu-yamaa anaani-yung ana-angel, ninggu-magaa niga. ");
INSERT INTO nuy_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nigaayung naagi-yung na-Zechariah ni-yambalmayn ana-angel, “Marri ngaya ajigala nga-marrbuy-mang? Ngaya anaani aḏaba nga-yiwanggu, marri ngayawi-nyinyung ngarra-guḻgu ngigaayunggaj ngi-ngajiwanggu aḏaba,” ni-yamijgayn wugurri-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Wugurraayung ana-angel wu-yamayn, “Ngaya-waj anaani Gabriel, ngawu-lhaawu-yarrijgina-yinyung, marri ngaya-waj anaani nga-lhara-yinyung nigawi-rruj na-God-duj wubani-rruj ni-burraa-rruj. Ngaya anaani nganu-yandhurrbangana niga. Niga-waj ngani-lharrgang anaani, marri ngunu-magana, ngunu-yayn nugawi-wuy anaani ana-mamanunggu ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nagang yamba waari ba-jambarrgini aadanu, anaanila-wala yagi aḏaba nuynjambi aadanu, ba-ramadhan-ngu-dhidiiyn aḏaba. Nga aadanila-wala ba-yamana ba-burraa… nga anggu-waṉbang-gala, bani-yung marri, ba-ramadhan-bawalhang marri ba-yaṉḏabalang marri bani-yung ba-yambang. Aadanu yamba nagang anaani ana-lhaawu waari yamba nagang nimbaa-ngu-jambarrgini ngaya. Anaani ana-lhaawu yijgubulu. Anaani anggu-waṉbina wurrugu marri.” Dani-yung wu-yamaa anaani-yung ana-angel. ");
INSERT INTO nuy_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Warruburru warra-wurru-wurruj wunaa-garranggaa wugurru na-Zechariah baḏag, anaarabarabalu-rruj-jinyung wurru-burri. “A-yangi yadhu nubagi ni-burraa ana-baḏag ana-lhirribala, aḏaba ani-rabalangi niga wubani-yunggaj, yagu ni-yaminggarriyn?” Dani-yung wuu-yamijgaynjini. ");
INSERT INTO nuy_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Marri anubani-yung-maynji ni-rabaliyn niga, yagu waari ani-yambini aḏaba. “Yagu naagi-yung niga ni-bu-burri, yangi yamba ni-nayn, ari niga ni-wuryarrangi!” wurru-yamayn. Yagu waari niga ani-yambini, marang-bugij niga ni-marang-birbirini, ni-yambini marang-mirri ni-waṉbini, bani-yung-bugij, aḏaba niga ni-yang-gaṉibiyn. ");
INSERT INTO nuy_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Anubani-yumbaa niga ni-mijgalmini anubani-rruj ana-Temple-Maṉngulg-duj, anubanila-wala aḏaba wu-jadugiiyn. Nga aḏaba ni-yanggi aanga-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wurrugu marri ngijang malgadhaadharri, aḏaba ngarrubagi-yung nga-rangarrina-yung ngiga aḏaba ngi-gulmung-muṉḏurr-mayn. Nga anubanila-wala ngi-yanggi aḏaba warruburrala-wala. ");
INSERT INTO nuy_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ngiga ngi-yamayn aḏaba, “Anaani ngaya na-Buunggawa ngani-man.galagana ngayawi-wuy. Yagi aḏaba ngaya anaani ngaambuli warruburru-wuy warra-mulung-arrgi-yung-guy warra-wurru-wurruj-guy anaani. Aadanu aḏaba ngaya nganii-garra-yarini niga.” Dani-yung ngi-yamaa. Ngarraagi-yung ngi-yanggi, nga ngi-bu-burri ngiga ngi-lhalga. Marri anubani-yung ngi-burri marang-aynjaabugij na-ḻabama. ");
INSERT INTO nuy_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Anubanila, nubagila-wala naaynbaj-gala na-ḻabama, nigaayung na-God ni-lharrgang anubani-yung ana-angel wubani-yung-guy aanga a-Nazareth, wubani a-runggal-uj a-lhal Galilee. ");
INSERT INTO nuy_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ngarraagi-yung ngarra-ngaḻaynjinyung ngigaayung, ngarra-ngarrimuwaj-jung Mary. Naagi-yung niga wunu-lhalamayaa, na-waḻyinyung, na-nimuwaj-jung Joseph. Nigawi-nyinyung warru-mandag naagi-yung na-king-jinyung na-David. Naawiṉi-yung wurrugu waari ambini-yagaynjini wuguṉi. ");
INSERT INTO nuy_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Anaani-yung ana-angel wu-yanggi buguni ngigawi-wuy, marri nginggu-yamijgayn ngiga, wu-yamayn, “Mary, nagang aadanu na-Buunggawa aḏaba nini-walgaṉmaa, marri nagang aḏaba niiniinggarra-ngu-burraa nugawi-rruj,” wu-yamaa dani-yung. ");
INSERT INTO nuy_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ngigaayung ngarraagi-yung aḏaba ngi-walharaguni. Ngi-yambini ngigaajbaj, “Anaani yuga wu-lhaawu-yaminggarrina anaani ana-lhaawu wugurru? A-yangi yungguyung anaani ngaya nganggu-magana?” Dani-yung ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Wugurraayung ana-angel nginggu-magayn, “Yagi ngaya anaani nimba-yami, Mary. Na-God niga ni-waḻaaḻarrii nugawi-wuy. Marri nagang aadanu nini-walgaṉmaa aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nagang aadanu bamba-waṉagana daju gujuju lhirribala, nugawi-rruj. Nubagi-yung wirrinyung banu-yabang waḻyinyung na-nimarig. Marri nubagi-yung banu-mayang na-nimuwaj-jung Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Niga naadagu ani-runggal-windiyung. Marri ani-mayina niga na-niwiyayung naagila-yinyung anaarrwar-inyung. Naagi anaagajij-dharrmani aḏaba niga na-king David-jinyung, wubani yaga warra-mi…yn-ngambara-waj. Niga-waj yamba God naadagu anu-buunggawa-wana, ani-ragaana yungguyung. ");
INSERT INTO nuy_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Niga naadagu ani-ragaana, warruburru-yung-guy warra-Israel, burru-yung nga, na-Jacob-jinyung warru-mandag, anggu-wuguuguni aadanu aḏaba. Nigaaj-bugij ani-ragaana aḏaba, ani-wandha-wuguuguni, niga ambani-narrii yungguyung, warruburru-yung warra-wurru-wurruj, ani-wij-garrarra-gana yadhu, yagi ni-muḏaḏbi.” Dani-yung wu-yamaa anaani-yung ana-angel, nginggu-magaa ngiga. ");
INSERT INTO nuy_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Yagu ngigaayung ngi-yambalmayn, ngi-walharaguni yamba, ngi-yamayn “Marri yuga anaani anggiijaminggarrina anggu-waṉbina? Yagu ngaya anaani waari ngandaaynji-yaay warra-waḻya,” ngigaayung ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Wugurraayung ana-angel wu-yamayn nginggu-yamijgayn, “Anaani Maṉngulg Mawurr yamba wugurru anggu-yaarri nugawi-wuy, ana-lhuḏ nigawi-nyinyung na-runggal-yung-jinyung anggu-burraa nugawi-rruj. Aadanula-wala, naadagu na-wirrinyung ani-mayina ani-maṉngulg, marri na-God-jinyung na-niwiyayung niga. ");
INSERT INTO nuy_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Baawanggina nagang! Ngarrubagi ngaa-Elizabeth, nugawi-nyinyung niingiilgurmaynjiyn-jinyung, ngarra-ngajiwanggu-nyung, anubani-yung ana-wulhu-wulhurr wugurru wurru-yamaa, ‘Waari ngarrubagi ambangi-waṉagaa warra-wirrig ngiga,’ wurru-yamaa anaani-yung warruburru-yung warra-wurru-wurruj. Yagu ngigaayunggaj bawa aḏaba winyig wangi-waṉagana, anaanila-wala aḏaba marang-aynjaabugij marri jarranggay naagi na-ḻabama. ");
INSERT INTO nuy_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Na-God-maynji niga anubani ani-wijangayii, yagu bani-yung nga ani-waṉbina. Waari anaaynbaj ninggu-muḏaḏbijgi niga.” Dani-yung wu-yamaa anaani-yung ana-angel. ");
INSERT INTO nuy_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ngigaayung ngarra-Mary ngi-yamayn, “Yii, yijgubulu, ngaya anaani na-Buunggawa-yinyung, marri nganu-yandhurrbangana-yinyung niga. Nigawi-nyinyung ana-lhaawu, anubani-yung anggu-waṉbina ngayawi-wuy,” ngi-yamayn ngiga. Marri anubani-yung ana-angel wu-yanggi aḏaba ngigawi-wala. ");
INSERT INTO nuy_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Anubanila-wala, ngarra-Mary ngi-ḻaḻagiiyn marri aḏaba ngi-yanggi yuuguni ama-ṉuga-wuy, maarra-ḻandhirrngindi-wuy, wubani aanga, wubani a-runggal a-lhal wugurru wu-mayini Judah. ");
INSERT INTO nuy_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Wubani ngiga ngi-yanggi buguni na-Zechariah-wuy. Ngi-yabiyn. Nga Mary-wala ngiga ngaa-gaḏiyn ngaa-Elizabeth-guy. ");
INSERT INTO nuy_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ngigaayung ngaa-Elizabeth ngi-wawanggini. Nga warrubawi-yung warra-gujuju wu-wirbirini ana-lhirribala ngigawi-rruj aḏaba. Anubani-yung aḏaba Maṉngulg Mawurr ngarraagi-yung ngiga ngiindharwiiyn, ngaa-Elizabeth. ");
INSERT INTO nuy_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Marri ngiiḏangi yanggarrwar-mirri, “Nagang aadanu yamba na-God nagang nini-walgaṉmaa, waari warruburru-yung-jii wugurru warra-maṉaṉung-jii-magaa. Marri naagi-yung niga nu-walgaṉmaa, na-gujuju-nyung anubagu ana-lhirribala ni-burri-yinyung. ");
INSERT INTO nuy_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Anaani ngaya mamanunggu-windiyung nganiini ngayawi-wuy, nagang aadanu nuynjanggi anubagala, nimba-wagarangi, nagang yamba aadanu nga-rriibi-yung nagang na-Buunggawa-yinyung marri ngayawi-nyinyung niga. ");
INSERT INTO nuy_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Marri baawanggina, aadanu aḏaba anubani-yunggaj ngunu-yaynjangani, nigaayung na-gujuju-nyung ni-wirbirini ngayawi-rruj, niga yamba ni-wawanggini, marri ni-waḻaaḻarrangi niga. ");
INSERT INTO nuy_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Na-Buunggawa niga naniigajij-majgaa, nagang yamba aadanu nu-ngu-jambarrgiiyn nigawi-nyinyung ana-lhaawu, ani-waṉbina-yinyung.” Dani-yung yigaj ngi-yamaa ngarra-Elizabeth ngarraagi-yung. ");
INSERT INTO nuy_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ngigaayung ngarra-Mary ngi-yamayn, ngu-yambalmayn, “Ngaya aḏaba nganu-warraarriwana na-Buunggawa, ngaya nga-yamana, ni-runggal niga, ni-Buunggawa. ");
INSERT INTO nuy_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Marri ngaya anaani nga-ḏinggina aḏaba, niga yamba na-God, niga ngani-wiri-gana-yinyung. ");
INSERT INTO nuy_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ngaya anaani nga-burraa nga-wirrig-bindiyung, marri ngaya anaani nganu-yandhurrbangana-yinyung. Yagu God nigaaj-bugij niga ni-wawanggina ngayawi-wuy, marri ngani-man.galagana. Wugurru warruburru warra-wurru-wurruj amburru-lhamarrii-yinyung, marri amburru-yambina-yinyung ngayawi-nyinyung ana-lhaawu, niga na-God, ngaya ngaaniigajij-majgaa, wugurru amburru-yamana yungguyung. ");
INSERT INTO nuy_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Yagu yamba nigaaj-bugij na-waḏa-waḏaḏ-jung. Marri ni-waṉbina yij-mamaaḻang-galawaj ngayawi-wuy. Ana-muwaj nigawi-nyinyung, wu-maṉngulg. ");
INSERT INTO nuy_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ngagurru warra-wurru-wurruj ngaanu-yandhurrbangana-yinyung ngagurru nigawaj-bugij aḏaba, na-God niga ngarrani-man.galagana anaani ngagurru. Marri ngagurri-nyinyung warruburru warra-mijburrayung marri warruburru-yung anaadhaadharri-yinyung wugurraayunggaj. ");
INSERT INTO nuy_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Na-God niga ni-waṉbina yij-mamaaḻang-galawaj, niga yamba ni-waḏa-waḏaḏ. Marri warruburru-yung wugurraayung wuu-lhama-lhamina-yinyung, wugurru yamba wurru-wawanggina anaani wiij-galadi. Yagu na-God niga ambani-man-jarramijgang warruburru-yung, marri ambani-manda-ḻibi-ḻibawana niga waadurru-yung. ");
INSERT INTO nuy_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yagu warruburru-yung wugurraayung waa-runggu-runggal, wurru-waḏa-waḏaḏ-gina-yinyung, warruburru-yung ambani-barawudang wugurru. Yagu warruburru-yung wugurraayung wurru-yaal-murramurra-yinyung, marri wugurru ambani-runggal-wang wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Marri warruburru wugurraayung wurru-marryaadii-yinyung, ambaniiyii mamanunggu ana-marrya wugurru. Yagu warruburru-yung wugurraayung warraambaambalal, ambani-lharrgang amburru-mamar wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Yagu ngagurru anaani warra-wurru-wurruj warra-Israel, nigawi-nyinyung warru-mandag, nguunu-yandhurrbangana-yinyung niga, ngarrani-maṉmani ngagurru. Niga yamba ni-wawanggina-wugij ngagurri-wuy anaani, ngarrani-man.galagana-wugij ngagurru niga. ");
INSERT INTO nuy_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Anaani wiij-nguynju wugurru, ni-yambini-yinyung anu…bani-yunggaj, warruburru-yung-wuy warra-miyn.ngambara-wuy, marri na-Abraham-guy marri warruburru-yung wuu-lhamarrangi-yinyung. Danu nga ana-lhaawu anaani anggu-burraa anggiij-buguuguni-wugij wugurru.” Dani-yung nga, ngi-yamaa ngarraagi-yung ngarra-Mary. ");
INSERT INTO nuy_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Anubanila-wala aḏaba, ngarraagi-yung ngarra-Mary ngi-burri ni-wulaynbaj-gala na-ḻabama, anubagu wugurrngi wingiinggarra-ngu-burri ngarraagi-yung ngaa-Elizabeth. Anubanila-wala aḏaba ngiga ngiigiyn ngigawi-wuy aanga-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Anubanila-wala aḏaba malgadhaadharri, ngarraagi-yung ngaa-Elizabeth ngunu-yabayn ngigawi-nyinyung naagi-yung na-wirrinyung, na-ni-marayung. ");
INSERT INTO nuy_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ngigawi-nyinyung warra-mijgalgur-yung marri warruburru wurraanggarra-yagaynjini-yinyung, anaani-yung wurraawanggini ana-lhaawu aḏaba, naagi-yung na-Buunggawa ngu-man.galagaa windiyung ngarraagi-yinyung ngiga. Marri anubanila wugurru wurru-waḻaaḻarrangi windiyung ngigawi-wuy aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Manubama-yung mana-miyn.nganga marang-aynjaabugij marri muulawaa wurrugu, warruburru wurru-burri-yinyung wurru-muṉḏugaa, naagi-yung aḏaba wunu-wulmurr-gaa, na-wirrinyung niga. Wurru-yamaa-wugij wugurru wurraandha-wuguuguni. Naagi-yung wunaa-ngaynbandangi niga ambunu-mijguni Zechariah, wurru-yamaa, nguynju yaga na-ninyarra-yung-jii wubani yaga a-muwaj, ambini-miyn-nguynju-magaa wuguṉi. ");
INSERT INTO nuy_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Yagu ngigaayung ngaa-rriibi-yung ngiga ngi-yamayn, “Yagi yagi aadanu! Naagi ani-mayina John, niga.” Dani-yung ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yagu wugurraayung wurru-yamayn, “Anaaji nagang waari amburru-mayini aadani-yung-jii ana-muwaj, nurraalgurmaynjini-yinyung.” Dani-yung wurru-yamayn wugurraayung. ");
INSERT INTO nuy_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Marri wunu-yandhawiwandi naagi-yung marang-mirri wurru-yamaa, nigawi-wuy na-ninyarra-yung-guy, “Aniga-yung yuga ana-muwaj ngaanu-mij-giyn naagi?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nigaayung wani-yandhawiwayn marang-mirri, marri niwu-wurrurriyn ana-rangag, nga wunaa-jurangi, bani-yung marri nu-mij-garrarrangi aḏaba, “Na-ni-muwaj-jung John.” Yagu warraawurru-yung wunu-miyn-nayn-gala wubani a-muwaj, wurru-wurri-ḻaḻmayn wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Anubanila-wala aḏaba lhugaajgiyalawaj anaani-yung, naagi-yung na-Zecharaiah ni-ramadhan-bawalhiyn, marri ni-ramadhan-birbiriyn niga, anaani-yung ni-yaṉḏabaliyn aḏaba ni-yambini. Aḏaba anubanila-wala nigaayung nu-warraarriwaa na-God-guy. ");
INSERT INTO nuy_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yagu aḏaba warraawurru-yung warra-wurru-wurruj wurru-wurri-ḻaḻmayn-bindiyung niga. Warraawurru-yung anubanila-wala wunu-wurryuwini niga naagi-yung aḏaba, warruburru-yung anuwaagu-yinyung anaangaarrwar-yinyung wurru-burri mana-ṉuga-rruj, anubani-yung wuu-yanga-yanguynjini anaani ana-lhaawu, wuu-yambiynjini wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Marri anubagu-yinyung wurru-wawanggini-yinyung anubani wurru-wuguuguni-wugij wugurru wirriijanga-yangani, na-gujuju-jinyung, “Yangi-nyung yuga naagi na-gujuju-nyung niga? Ari niga ani-runggal.” Dani-yung wurru-yamaa. Yijgubulu windiyung naagi-yung na-Buunggawa niga nu-rangarrangi marri nu-maṉmangi na-wirrinyung. ");
INSERT INTO nuy_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Naagi-yung na-ninyarra-yung na-Zechariah niga, niindharwiiyn Maṉngulg-mirri Mawurr windiyung, marri naa-jambini nigawi-wuy na-God-guy. Ni-yamaa niga, ");
INSERT INTO nuy_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ngaanu-warraarriwana nigawi-wuy na-Buunggawa marri na-God ngagurri-nyinyung niga, ngagurru warra-Israel anaani. Niga yamba ni-yaarri ngagurri-wuy, ngarranii-gurrij-ngu-burraa yamba ngagurru anaani, marri ngarrani-wiri-gayn ngagurru, nigawi-nyinyung yamba anaani warra-wurru-wurruj aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Marri niga ngarranii-jarrijgina ngagurri-wuy nigaayung nubagi-yung naaynbajung ngaambani-wiri-gana-yinyung, nubagi niga ani-waḏa-waḏaḏ-bindiyung. Marri warru-mandag nubagi na-David-jinyung, nubagi-yung nu-yandhurrbangaa-yinyung na-God niga. ");
INSERT INTO nuy_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nguynju yaga ni-yambini na-God anu…bani-yunggaj, wani-yiyini warruburru-yung yaga wunaa-ja-jambini-yinyung niga, warruburru-yung wugurru warra-waḻya-waḻya wurru-maṉngulg. Anaani-yung wurru-magini ana-lhaawu warruburru-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Yaani-yung ana-lhaawu na-God ni-yamaa, ‘Ngaya anaani anamba-wiri-gana, warruburru-yung-gala nambi-margirii-yinyung, marri warruburru-yung nambi-wurrij-bangana-yinyung, nugurru’ ni-yamaa na-God. ");
INSERT INTO nuy_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Anaani-yung ngarrani-lhalamayaa ngagurru warruburru-yung warra-miyn-ngambara-waj, anaani na-God ni-yambini, ni-yamaa, ‘Ngaya anaani anamba-man.galagana, nugurru aadanu,’ ni-yamayn dani-yung, ngarrani-lhalamayaa ngagurru, ni-wij-maṉdhangi anaani ana-maṉngulg ana-lhaawu. Ana-yimbaj anaani ni-wawanggina anaani-yung aḏaba ana-lhaawu, ani-waṉbina, ngaambani-man.galagana yungguyung ngagurru. ");
INSERT INTO nuy_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Niga nu-lhalamayaa, ngagurri-nyinyung na-baba na-Abraham. ");
INSERT INTO nuy_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ni-yamaa, ‘Aadanu anamba-maṉmani nugurru, warruburrala-wala nambi-wurrij-bangana-wala-yinyung, nguynju yadhu ngii-yandhurrbangana yungguyung ngaya maaḻamburrg, waari yadhu nuu-ḏirrngawi nugurru. ");
INSERT INTO nuy_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nguynju yadhu numburru-burraa numburru-maṉngulg, numburru-maaḻamburrg-bugij ngayawi-wuy, anggu-wuguuguni.’ Ni-yamaa anaani-yung na-God niga.” Naagi-yung niga na-Zechariah ni-yambini-wugij. ");
INSERT INTO nuy_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Marri nugawaj danu nigi, nagang-maynji ba-ngambara-mang, aadanu ambu-yamana, ambi-wurryuwina, ‘Naa-ja-jambina-yinyung niga naagi, na-runggal-yung na-God,’ ambu-yamana. Nagang aadanu ba-yaarri raga-ragij na-Buunggawa-wuy, nguynju yadhu nagang bamaandhurrg-gana manaadi nigawi-nyinyung raga-ragij-gaj. ");
INSERT INTO nuy_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Marri bamba-yiyina nagang warra-wurru-wurruj, nguynju yadhu niga na-God yungguyung ambani-wiri-gana yadhu niga. Anaani wiijamana, nguynju yadhu ambaniigajij-garruna wugurri-nyinyung aniij-galaaladi. ");
INSERT INTO nuy_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Niga yamba ngarrani-man.galagana windiyung ngagurru. Naagi-yung na-God niga nubagi-yung anu-lharrgang anubagala anaarrwar-wala, nubagi-yung naaynbajung. Naagi-yung niga, nguynju yaga arrarra-yii wu-burraa-yii wu-yamana, niga ani-yamana. Ani-wabarra-milhii niga anaanu-wuy ngagurri-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Anaani ngagurru ngurru-burraa waangamudi-rruj, ana-lhirribala-rruj waangudumana-rruj ana-ngawij-jinyung. Yagu nubagi naaynbajung, ani-yamana nguynju anaarrarra-yii, niga ngambani-bajiyina amiga-yung manaadi magurru, nguynju yadhu ngaambu-lhamaamura anaani.” Dani-yung nga, ni-yamaa ni-yambini na-Zechariah niga. ");
INSERT INTO nuy_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Anubanila-wala, naagi-yung na-wirrinyung na-John yingga aḏaba ni-warradiyn. Marri ni-burri maaḻamburrg-bindiyung naagi-yung niga. Anubanila-wala aḏaba ni-yanggi yuuguni a-lhal-aṉḏarrg-guy. Wurrugu marri adhaadharri, anubani-yung ni-yiyijgiiyn niga wugurri-wuy warra-wurru-wurruj-guy warra-Israel, wunu-nani niga. ");
INSERT INTO nuy_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Anubani-yunggaj na-John nubagi waniimbara-ngambijgaa-yinyung ni-wirrig-gaj, nubagi-yung na-wurrujung na-runggal-yung na-Caesar na-Augustus, ni-yandharrgiiyn lhaawu, ni-yamayn, “Warraarrawindi-lhangu warruburru warra-wurru-wurruj anubani amburru-mij-garrarrina.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Anaani-yung wubani-yunggaj, a-wulhu-wulhurr-waj anaani-yung wirriirrarrangi, ana-muwaj. Nubagi-yung naaynbajung ni-buunggawa-maa, na-nimuwaj-jung naagi-yung Quirinius, anubani ni-burri ana-lhal Syria. Wugurru wunu-mayaa naagi-yung ni-governor niga. ");
INSERT INTO nuy_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Warruburru-yung warraarrawindi warra-wurru-wurruj wurru-yanggi, wubani-wuy wugurri-nyinyung-guy arrgi-yung-guy a-lhal, wurru-mulu-ḻibawini, a-lhal-aynbaj-baj a-lhal wurru-mandag-ḏajaarrangi wurru-yanggi. Yagu anaani-yung wugurri-nyinyung ana-muwaj anubani waarrarrini. ");
INSERT INTO nuy_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nigaayung naagi-yung na-Joseph, niga ni-yanggi, anubanila ana-Nazareth-gala ni-yanggi. Wubanila-wala a-runggal a-lhal Galilee. Ni-yanggi buguni Judea-wuy, wubani aanga wu-mayini Bethlehem. Marri bagu Bethlehem-duj, nubagi niga na-king David niimbuḻwiyn wu…bani-yunggaj. Nigaayung na-Joseph ni-yanggi anubuguni, nigawi-nyinyung yamba warru-mandag na-David-jinyung. ");
INSERT INTO nuy_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ngigaayung ngarraagi-yung ngarra-Mary wunu-lhalamayaa na-Joseph niga. Ngarraagi aḏaba ngi-wurrij-mundurr ngiga. Naawiṉi-yung aḏaba wini-yanggi nguynju yadhu bagu yungguyung ambini-mij-garrarrini wuguṉi, na-nimuwaj-baa. ");
INSERT INTO nuy_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Wini-yanggi Bethlehem-guy. Anubani-yung aḏaba wiij-dhamun.gurrg-maa, wu-wurrij-barubaj-maa, warra-wirrig. ");
INSERT INTO nuy_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Wini-waliyn aḏaba Bethlehem. Yagu waari ambiniwu-lhangarrmaa nubiṉi-yung anaanga ambini-burri-yinyung ambini-yaay-yinyung, arraarrawindi yamba warraawurru-yung wurru-yanggi anubuguni, wirri-dhaṉgayn anubani-yung anaanga. Wini-burri bagu wubani-rruj wu-bu-burri-rruj a-bulugi, a-gara. Anubanila-wala aḏaba, ngunu-yabayn na-ni-marayung naagi-yung, ngunu-maḻaamarr-gayn-jinyung niga. Naagi-yung ngunu-warraabaabaa manubama-yung mana-yaaḻi. Anubani ngunu-burriyn wubani-rruj a-lhabara a-bulugi-rruj ngunu-nguni-rruj-jinyung a-marrya, buguni naagi-yung ni-lhabara-ngandhadhi niga. ");
INSERT INTO nuy_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Anubani-rruj ana-lhal waadurru-yung wuu-rangarrangi ana-jib miyn.ngu. Wurru-bu-burri aarabarabalu-rruj bagu. ");
INSERT INTO nuy_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nga anubani-yung angel na-Buunggawa-yinyung wu-rabaliyn. Anubani-yung runggal waabarra-milhangi yuwaagala na-Buunggawa-wala. Anubani-yung waabarra-milhangi wugurri-rruj. Marri wurru-wurri-ḻaḻmayn-bindiyung wugurru warraawurru-yung. ");
INSERT INTO nuy_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Wugurraayung ana-angel wanggu-magayn, “Gurruwaj, yagi nugurru nurru-ḏirrngawi. Numburraawanggina! Anaani ngana-magana anaani mamanunggu lhaawu. Warraarrawindi-lhangu warra-wurru-wurruj anubani-yung amburru-waḻaaḻarrii anaanila-wala anggu-waṉbina-maynji. ");
INSERT INTO nuy_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ana-yimbaj naadagu na-wirrinyung niimbuḻwiyn nugurraa yungguyung, wubani-rruj ana-wumurrng na-David-jinyung. Nigaayung nambani-wiri-gana-yinyung nugurru, na-Christ, na-Messiah, na-Buunggawa.” Dani-yung wu-yamaa. ");
INSERT INTO nuy_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","“Anaanila-wala anubani-yung aḏaba nugurru numburru-marrbuy. Anubani-yung numbunu-lhangarrmang niga nubagi-yung na-wirrinyung. Anubani-yung ni-warraabaabina nubagi niga yaaḻi, anubani-rruj nguyu-nguyii-rruj a-marrya a-bulugi-rruj a-lhabara, bagu nga, ni-murrgulhaa niga.” Dani-yung wu-yamaa anaani-yung ana-angel, wanggu-magaa. ");
INSERT INTO nuy_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Yagu lhugaajgiyalawaj anubani-yung anaarrawindi ana-angel wu-ngarra-ḏaba-rabaliyn aḏaba, alangi wubani-wuy aḏaba aaynbaj-guy a-angel-wuy wugurru. Anaani-yung aḏaba wugurru ninggu-warraarriwaa na-God. Anaani-yung wu-yamaa, ");
INSERT INTO nuy_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Anaani nguunu-warraarriwana ngagurru na-God anaarrwar-yinyung. Yagu warruburru wugurraayung anaaban-duj-jinyung wurru-burraa warra-wurru-wurruj, warruburru wunu-waḻaaḻarrijgana-yinyung niga, warruburru amburru-burraa ambuu-lhamaamura nigawi-rruj,” Dani-yung wu-yamaa anaani-yung anaarrawindi ana-angel. ");
INSERT INTO nuy_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Yagu anubanila-wala ana-angel aḏaba wu-yanggi wu-ngarra-gagini arrwiyaj. Yagu wugurraayung warraawurru-yung wuu-ranga-rangarrangi-yinyung ana-jib anaani-yung wuu-yambiynjini bagu aḏaba, wurru-yamijgaynjini, “Yingga ngaambu-yaarri Bethlehem-guy, marri ngaambu-milgina, ngaambu-warranggana wubani waaṉbini-yinyung, wubani-yung na-Buunggawa ngarrani-bajijgayn-jinyung,” wurru-yamayn dani-yung. ");
INSERT INTO nuy_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Warraawurru-yung aḏaba lhugaajgiyalawaj wuu-ngarra-ḻaḻagiiyn, marri wurru-yanggi, wurru-nguḻu-nguḻubini. Marri warra-lhangarrmayn, ngarra-Mary marri na-Joseph marri nubagi na-wirrinyung. Wubani-rruj a-bulugi ngunu-nguni-rruj, bagu ni-murrgulhi, ni-lhabara-ngandhadhi, na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Marri warraawurru-yung wurraarranggayn. Marri warra-magaa warruburru warra-mulung-arrgi-wuy, anaani wurru-magini anubani-yung wanggu-magaa-yinyung wubani a-angel, anaani-yung ana-lhaawu nubagi-yung-jinyung na-wirrinyung-jinyung. ");
INSERT INTO nuy_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Yagu warruburru warra-mulung-aynbaj wurraawanggini-yinyung, wurru-wurrij-gaḻaaḻarrangi, anubani-yung-jinyung waadurru-yung wurru-magini-yinyung. ");
INSERT INTO nuy_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ngigaayung ngarraagi-yung ngarra-Mary anaani-yung ngi-wuguuguni-wugij ngi-wawanggini, ngiwu-waṉagaa ana-lhaawu ngi-wandha-wuguuguni ngiga. ");
INSERT INTO nuy_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Yagu warraawurru-yung wurru-ranga-rangarrangi-yinyung aḏaba wurraagiyn. Warraawurru-yung wunu-warraarriwaa na-God-guy. Anaani-yung wurru-yambini anubani-yung-jinyung aniij-mamaaḻang na-God-gala, anubani-yung wurraarra-nani-yinyung marri anubani-yung wurraawanggini-yinyung. Anaani aḏaba wiij-nguynju wubanila-yung-galawaj a-angel-inyung wanggu-magaa wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Manaama-yung mana-miyn.nganga marang-aynjaabugij marri muulawaa, naagi-yung aḏaba na-wirrinyung wunu-wulmurr-gaa niga. Yagu naagi-yung niga wunu-mij-gayn na-nimuwaj-jung Jesus. Anu…bani-yunggaj ninggu-mij-gayn naagi-yung ana-angel. Anaani-yung wubani-yunggaj waari-waj angunu-waṉagaa na-wirrinyung, anaani-yung ana-muwaj ninggu-mij-gayn niga. ");
INSERT INTO nuy_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Anubani mana-miyn.nganga aḏaba 30 wurrugu, naawiṉi-yung aḏaba wini-yanggi wubani-wuy a-Temple-Maṉngulg-guy. Wunu-waṉagaa daji naagi-yung na-wirrinyung. Naawiṉi-yung wini-yanggi buguni nguynju yadhu ambiniwu-yandhurrbangaa yungguyung anubani-yung a-lhaawu-runggal na-Moses-jinyung. Ngarraagi-yung arrbidi aḏaba angi-burri ngarra-Mary, anubanila-wala niimbuḻwiyn-gala naagi-yung na-wirrinyung na-Jesus. Marri naagi-yung wunu-yarrijgini niga wubani-wuy a-Temple-Maṉngulg-guy na-Jesus, wunu-bajiyini marri wunuuni nubagi-wuy na-God-guy. Wurru-yamaa-wugij wugurru warra-wurru-wurruj, wurraandha-wuguuguni, anaani-yung. ");
INSERT INTO nuy_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Anaani wiij-nguynju anubani-yung waarrarrini na-Buunggawa-yinyung wugurru, wiijamana anaani, na-Moses ni-yambini, (Exodus 13:2,12) “Nubagi-yung-maynji na-waḻyinyung, na-wirrinyung, ana-raga-ragij niga aniimbuḻwiyn, nubagi-yung ani-maṉngulg-bindiyung ani-mayina na-Buunggawa-wuy,” wu-yamana anaani ana-wubiba, wu-magina. ");
INSERT INTO nuy_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Wuguṉi wini-waṉbini naawiṉi dani-yung. Anaani-yung wunu-yayn nigawi-wuy na-God-guy, wiijamana anaani wugurru, anaani-rruj wu-waṉbini ana-lhaawu-runggal. Anaani-yung wini-mangi ngurudhu. Anaani wiij-nguynju, anaani ana-wubiba wu-yamana, (Leviticus 12:8) “Ngi-wulawaa ngaa-ḻabarrg-baa, wugurraayung yagu ari anaani wulawaa ana-rumurumuwa-waa,” anaani-rruj wu-yamana ana-wubiba. Yagu anaani-yung wini-wini aḏaba marri wini-nangaa, nguynju yadhu na-God yungguyung ambunu-yandhurrbangaa nubiṉi-yung. ");
INSERT INTO nuy_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Naagi-yung bagu niga yiwanggu-nyung ni-burri aani-rruj a-lhal, Jerusalem. Na-ni-muwaj-jung naagi-yung niga Simeon. Naagi-yung ni-burri maaḻamburrg-bindiyung niga. Naagi-yung nu-yandhurrbangaa nigaaj-bugij na-God. Naagi-yung wurrugu nu-rangarrangi naadagi-yung na-Messiah, nguynju yadhu naadagi-yung ambani-man.galagana yungguyung warruburru-yung warra-Israel. Anaani-rruj Maṉngulg Mawurr wu-burri nigawi-rruj naagi-yung niga na-Simeon. ");
INSERT INTO nuy_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Anaani-yung wu…bani-yunggaj niga ninggu-magaa Maṉngulg Mawurr naagi-yung, “Yagi wurrugu nagang nu-ngawi, wurrugu baambu-narrina… nga. Nagang ba-burraa ba-wiri-wugij, nga naagi banu-nayii na-Messiah, na-runggal-yung na-Buunggawa-yinyung.” Dani-yung wu-yamaa ninggu-magaa ana-Maṉngulg Mawurr anubani-yunggaj niga. ");
INSERT INTO nuy_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ngijang anaani-yung aḏaba ninggu-magaa Maṉngulg Mawurr nigawi-wuy. Nigaayung naagi-yung ni-yanggi aḏaba wubani-wuy a-Temple-Maṉngulg-guy. Wuguṉiiyung nga-rriibi-yung marri naadagi-yung na-ninyarra-yung, naagi-yung aḏaba wunu-yarrijgini na-wirrinyung na-Jesus wubani-wuy a-lhigiḏi-wuy. Naawiṉi-yung ambunaa-gaṉbini wuguṉi, wu-yamana yamba anaani ana-lhaawu-runggal. Anaani-yung wurru-waṉbini warra-wurru-wurruj wugurru wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nigaayung naagi-yung na-Simeon wani-raganmayn, marri nu-miyn na-Jesus, marri nu-mijgalalini niga marri nu-warraarriwaa nigawi-wuy na-God-guy. Marri ni-yamayn niga, ");
INSERT INTO nuy_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Buunggawa, ngaya anaani ngunu-yandhurrbangaa nagang. Nimba-lharrgang aḏaba ngaya, anaani ngaya nga-ngawang, ngaya yamba anaani nga-lhamaamura nga-burraa. Wiij-nguynju wudani-yung-jii nimba-magaa-yii nagang. ");
INSERT INTO nuy_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ngaya aḏaba nganu-nani ngayawi-nyinyung-gala ama-bagaḻang-gala, naagi ngaambani-wiri-gana-yinyung, naagi nunu-lharrgang-jinyung niga. ");
INSERT INTO nuy_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nagang nunu-lharrgang anubagala naagi, warraawurru yungguyung warraarrawindi-lhangu warra-wurru-wurruj, wugurru ambunu-nayii yadhu niga. ");
INSERT INTO nuy_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ani-yamana niga nguynju yaga wu-lhalmbaarrii-yii. Ani-wij-garrarra-gana yungguyung niga warraarrawindi-wuy warra-Gentile-wuy niga. Marri nurru anaani, nugawi-nyinyung aḏaba warra-wurru-wurruj warra-Israel, nurru warruburru warra-mulung-arrgi-yung aḏaba nambambi-warraarriwana, yagu yamba niga-waj yamba aḏaba dagi-yung.” ");
INSERT INTO nuy_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Dani-yung niga ni-yamaa na-Simeon. Naawiṉi-yung, nga-rriibi-yung marri naagi-yung na-ninyarra-yung, wuguṉi wini-wurrij-gaḻaaḻarrangi aadani-yung. ");
INSERT INTO nuy_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Na-Simeon nigaayung ni-yamayn, “Na-God niga-waj nambaniigajij-majgana nugurru aadanu.” Ngijang ngu-magayn ngarra-Mary-wuy, “Ba-wawanggina nagang. Naagi-yung na-wirrinyung, ambani-maṉmani arraarrawindi warra-wurru-wurruj niga, yagu wugurraayung warra-mulung-aynbaj wugurru waari wani-maṉmi, amburru-jadugiiyn, anaani warra-Israel. Yagu niga anubani ambani-bajiyina-yinyung warra-wurru-wurruj, yagu niga ambunaandirrii. Yagu nugaayung aadanu Mary, ba-wurrij-galadi-wina windiyung-maynji, nguynju yaga wudanu a-galiwanga-yii anggaadhugang nugawi-wuy, danu nga anggiijamana wugurru ba-wurrij-galadi-wina-maynji nagang aadanu. Warra-wurru-wurruj warruburru-yung wurraawanggina wij-miḏaamimi-windiyung wugurri-wala anaandhiri-wala wurraawanggina-yinyung. Yagu niga naagi-yung ani-wij-garrarra-gana aḏaba.” Dani-yung yigaj ni-yamaa, naagi-yung na-Simeon, na-nidhaawu-yung. ");
INSERT INTO nuy_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Bagu ngigaayung ngajiwanggu-nyung ngayi-nyung ngi-burri, ngarraagi-yung ngunaa-ja-jambini-yinyung na-God, ngarra-ngarrimuwaj-jung ngiga ngi-mayini Anna. Naagi-yung na-ninyarra-yung ni-mayini niga Phanuel, nigawi-nyinyung warru-mandag Asher-yinyung. Yagu ngarraagi-yung ngiga ngi-ngajiwanggu-windiyung aḏaba. Ngarraagi-yung anubani-yunggaj ngiga ngiiynji-yaay naagi-yung aynjaabu-nyung waḻyinyung marang-aynjaabugij marri muulaynbaj manaarmag, marri nubagi-yung niga ni-ngawiiyn aḏaba wubani-yunggaj. ");
INSERT INTO nuy_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ngarraagi-yung ngi-ngayi ngiga. Aḏaba ngarraagi-yung ngi-burri 84 manaarmag, ngi-burri ngiga. Ngarraagi-yung ngi-bu-burri wubani-rruj a-Temple-Maṉngulg-duj ngi-wuguuguni. Ngarraagi-yung ngunu-warraarriwaa na-God. Malgarrawindi waari angi-ngunu-nguni ngiga ana-marrya, ngi-wandha-wuguuguni-wugij ngunu-yamba-yambini nigawi-wuy na-God, ana-miyn.ngu marri anaarrarra. ");
INSERT INTO nuy_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Wuguṉiiyung naawiṉi-yung anubani-yumbaa na-Joseph marri ngarra-Mary, bagu wuguṉiiyung wini-burri. Ngarrubagi-yung ngigaayung ngarra-ngajiwanggu-nyung ngarra-Anna anuwagala aḏaba ngi-yanggi bagu ngi-waliyn ngiga. Ngunu-nani niga na-wirrinyung, marri “Yuu, nga,” ngi-yamayn nigawi-wuy na-God-guy. Ngarraagi ngiga ngi-yambini-wugij naagi-yung na-Jesus-inyung ana-lhaawu, warruburru-yung-guy warra-wurru-wurruj warra-Israel. Ngi-yambini, ngi-yamayn “Nugurru yuga nurru-marrbuy? Na-God ngarrani-lhalamayaa-yinyung, aynbajung na-runggal-yung ani-yaarri, ngambani-muḻugu-wana-yinyung, ngurraambu-narrina ngagurru anaani. Niga dagi-yung nga, naadagu na-wirrinyung.” Dani-yung ngi-yamaa ngiga ngarra-ngajiwanggu-nyung, ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Anubanila-wala, ngarra-Mary marri naagi-yung na-Joseph, winiwu-yandhurrbangaa anaani-yung ana-lhaawu-runggal na-Buunggawa-yinyung, anaani aḏaba wu-jadugiiyn. Wurrugu marri malgadhaadharri, anubani winiigiyn yuuguni Galilee-wuy, wubani-yung aanga-wuy, wu-mayini ana-lhal, Nazareth. ");
INSERT INTO nuy_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Naagi-yung niga na-wirrinyung bagu ni-warradangi… nga ni-mali-waḏa-waḏaḏ-mayn. Aḏaba anubani-yung ni-marrbuy-windiyung ni-wijangani-yinyung niga. Na-God niga ni-waḻaaḻarrangi nigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Naawiṉi-yung na-Jesus-inyung na-ninyarra-yung marri nga-rriibi-yung wini-wuguuguni wini-yangga-yanggi-magaa, winiwu-milgini anaagalhal-aḻirr, wubani a-Jerusalem-guy wini-yangga-yanggi wuguṉi buguni. Anubani-yung warraarrawindi wurru-muṉḏugaa-magaa, wunu-warraarriwaa na-God. Anaani-yung wiijamaa, anubani-yunggaj wanggu-rangga-ḻaabini anubani ana-angel, wurru-yaay-maynji mana-miyn.nganga ana-Egypt-duj, marri na-God wani-wiri-gayn wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Anubani-yung na-Jesus aḏaba 12 ni-burri anaagalhal-aḻirr, buguni aḏaba wurru-yanggi, nguynju yaga warruburru-yung-jii wugurru yaga warra-mulung-arrgi-yung-jii. ");
INSERT INTO nuy_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Anubani-yumbaa wunu-warraarriwaa na-God, marri aḏaba wu-jadugiiyn, naawiṉi-yung aḏaba winiigiyn wuguṉi. Yagu niga naagi-yung na-wulmurr-inyung na-Jesus niga bagu-waj aḏaba ni-burri Jerusalem-gaj, ni-baldhiyn. Yagu naagi-yung na-ninyarra-yung marri nga-rriibi-yung anubani-yung aḏaba wini-maḻaḻadi naadagi-yung wuguṉi. ");
INSERT INTO nuy_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Anaani wuguṉi yingga winiin-jamayn bagu wurraanggarra-yanggi warruburru-yung-guy warra-mulung-arrgi-yung-guy niga. Wurru-yangga-yanggi… nga aynjaabugij ngarraaḻirr wurru-yanggi-yinyung wugurru. Wini-yanggi, nga bagu wunaa-garra-garranggaa aḏaba wuguṉi warruburru-wuy warra-mulung-arrgi-yung-guy. ");
INSERT INTO nuy_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Yagu waari ambunu-lhangarrmaa. Wurru-yaay aḏaba anubani-yung. Anubani-yung wuguṉi winiigiyn-gaj-bugij Jerusalem-guy. Buguni aḏaba wunaa-galhaga-lharrmangi. Nga bagu wurrugu wini-yaay. ");
INSERT INTO nuy_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Wunaa-galhaga-lharrmangi-wugij wini-warra-garranggaa… nga wini-yanggi wubani a-Temple-Maṉngulg-guy. Nga bagu warra-yiyini-yinyung warruburru-yung warra-waḻya-waḻya wurru-burri. Nga bagu niga na-Jesus ni-burri nigaayunggaj, waani-lhangarrmayn bagu aḏaba. Niga wani-yaynjangani marri anubani wani-yambiḻibiḻingaani bani-yung wani-yambalmaa niga. ");
INSERT INTO nuy_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yagu warruburru-yung warra-wurru-wurruj anubani-yung wurraawanggini bagu wurru-burri, wurru-wurrij-gaḻaaḻarrangi, wurru-yamaa, “Naagi-yung ni-marrbuy niga anaani yagu! Marri naagi-yung wani-maga-magaa niga,” wurru-yamaa warruburru-yung. ");
INSERT INTO nuy_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Naawiṉi-yung na-Joseph marri ngarra-Mary wunu-nayn niga, marri naawiṉi-yung wini-wurri-ḻaḻmayn aḏaba. Ngarraagi-yung nga-rriibi-yung ngi-yamayn nigawi-wuy, “Marig, yuga a-yangi yungguyung nagang nu-midaarr-gaṉibiyn, nimbaarruyn niiṉi aadanu? Nagang na-ninyarra marri ngaya anaani, ngunaa-galhaga-lharrmangi nugawi-wuy, anaani-yung niini-wurrij-galadi-wini-windiyung.” Dani-yung ngi-yamayn ngiga. ");
INSERT INTO nuy_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nigaayung ni-yamayn, “Nuguṉi ajigala ngirrii-galhaga-lharrmangi? Yuga waari nuguṉi nimbini-marrbuy-magaa yaaji ngaya nga-burri, anaani-rruj na-Baba-rruj a-wumurrng, anaani wiij-maṉdhina, anaani-rruj nga-burri ngaya?” ");
INSERT INTO nuy_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Dani-yung ni-yamayn. Yagu naawiṉi-yung anaani waari ambini-marrbuy-maa, wuguṉi. ");
INSERT INTO nuy_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Anubanila-wala aḏaba wurraanggarra-yanggi, wuguṉi-wuy. Wurru-yanggi aḏaba yuuguni Nazareth-guy. Naagi-yung niga wani-yandhurrbangaa naadiṉi-yung-guy. Yagu ngarraagi-yung nga-rriibi-yung ngiga ngi-wawanggini-wugij anubani-yung ana-lhaawu, waari anaani-yung angi-warandhalabini ngiga, ngi-wijanga-yangani-wugij. ");
INSERT INTO nuy_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Anubanila-wala, anubani-yung na-Jesus naagi-yung niga yingga ni-warradiyn aḏaba, anubani-yung ni-marrbuy-dhini arrawindi. Na-God niga ni-waḻaaḻarrangi nigawi-wuy. Wugurraayunggaj warraawurru-yung warra-wurru-wurruj nigawi-wuy wurraaḻaaḻarrangi. ");
INSERT INTO nuy_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Anubani-yumbaa wurrugu, naagi-yung na-runggal-yung ni-mayini na-nimuwaj-jung Tiberius Caesar, anubani-rruj ni-burri ana-lhal wu-mayini Rome. Naagi-yung ni-buunggawa-maa warraawurru-yung warraarrawindi warra-wurru-wurruj. Anaani-yung ni-burri 15 anaagalhal-aḻirr niga. Nigaayung na-Pontius Pilate naagi-yung ni-buunggawa-maa ana-lhal anubani-yung Judea. Nigaayung na-Herod naagi-yung ni-buunggawa-maa ana-lhal wu-mayini Galilee. Nga naagi-yung wunu-mayaa ni-tetrarch niga. Nigaayung naagi-yung na-nilharri-yung ni-mayini Philip. Nigaayung naagi-yung ni-buunggawa-maa, wini-nguynju wini-mijgalmini-yinyung, naagi-yung ni-tetrarch Ituraea ana-lhal marri Trachonitis. Nigaayung naagi-yung naaynbajung, na-nimuwaj-jung Lysanius, ni-buunggawa-maa ni-tetrarch anubani ana-lhal Abilene. Anaani anubani-yunggaj warraawurru-yung wurru-buunggawa-maa-yinyung wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Wuguṉi-yung naawiṉi-yung na-Annas marri na-Caiaphas, wuguṉi wini-burri bagu ana-lhal Jerusalem. Naawiṉi-yung wuguṉi na-runggal-waa na-priest-baa, wini-bu-burri bagu nga. Anubani-yumbaa nigaayung naadagi-yung na-John, na-niwiyayung na-Zechariah-yinyung. Niga naagi-yung ni-burri yuwaa…gu nga a-lhal-aṉḏarrg-duj. Na-God niga bagu nu-lhangarrmayn, nga nu-yambini nu-yanguni ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nigaayung naagi-yung ni-ḻaḻagiiyn aḏaba ni-yanggi, wubani niigaagaḻawajangi wagagala marri yaajijili marri wugurru yamba anubani wu-lhal-magaynjini yamba anaala-rruj, wugurru anubani wu-mayini Jordan. Nga bagu niga wani-magaa aḏaba warra-wurru-wurruj. Ni-yamaa, “Nugurru aḏaba nimbirriij-garruna aniij-galaaladi-wala. Anaani ngaya anambaambara-ngambijgana aḏaba guugu-mirri nugurru. Nga niga-waj God nambaniigajij-garruyn aniij-galaaladi-wala nugurru,” Dani-yung ni-yamaa niga. ");
INSERT INTO nuy_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Anaani aḏaba wiij-nguynju waarrarrina anaani-rruj ana-wubiba, naagi-yung niga na-Isaiah naa-ja-jambini-yinyung na-God anu…bani-yunggaj. Yaani-yung ni-yamaa niga, “Yaani-yung wu-yamayn ana-yang waaḏiyn yuwaagala a-lhal-aṉḏarrg-gala wugurru, Maanaami manaadi magurru aḏaba nimbirrimaadi-wandhurrg-gana raga-ragij-gaj na-Buunggawa yungguyung aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Anubani-yung waalagaranjii-yinyung anubani numburraa-burrdii aḏaba. Maadamu mana-ṉuga nimbirrima-waḻarrlhijgana maarra-ḻandhirrngindaa-wala-yinyung magurru. Manubama-yung manaadi manaadi-warrwarruj-jinyung, maadamu nimbirrimaadi-wandhurrg-gana magurru. Anubani anaaban-dharra-dharrangaj-jinyung, aadanu nimbirriiban-mamaaḻang-gana. ");
INSERT INTO nuy_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Warraarrawindi-lhangu aadanu amburraarranggana, na-God naadagu ngaambani-maṉmang ngagurru nigawi-nyinyung warra-wurru-wurruj anaani,” Dani-yung ni-yamaa na-Isaiah, waarrarrini anaani ana-wubiba-rruj. ");
INSERT INTO nuy_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Wudani-yung-gala, wugurru warruburru-yung warraarrawindi warra-wurru-wurruj wurru-yanggi nigawi-wuy na-John-guy, marri waniimbara-ngambijgaa yungguyung niga. Wani-magaa anaani-yung ni-yamaa, “Nugurru aadanu nurru-marryn! Yangi-nyung nugurru nambi-magaa aḏaba nuu-yarramana? Na-God yamba yuga ani-riyaldhang? Yii! ");
INSERT INTO nuy_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Numburraaṉiyn aḏaba, nimbirriij-garruyn aḏaba aniij-galaaladi, aadanu aḏaba numburru-waṉbina maaḻamburrg-galawaj nugurru. Yagi nugurru nurru-yamijgaynji nugurraajbaj, ‘Ngagurru anaani aḏaba wiiya! Ngagurru na-baba Abraham niga-waj nga!’ Anaani aḏaba ngana-magana nugurru, manaama mana-ṉuga, na-God niga animaaynbijgang magurru, warruburru-yung-guy na-Abraham-jinyung warra-mijburrayung wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“Na-God niga ari nugurru nambani-lhajbiyn lhaalhag. Anubani-yung niga ni-lhara warubaj a-rangag-duj, niga niwu-miṉmiṉḏii. Lhaalhag ari niga aniwu-madharrii aḏaba. Nugurru nurru-yamana aadanu nguynju wubani-yung-jii a-rangag-jii. Yagi-maynji nurru-waṉbi nugurru ana-maaḻamburrg, anubani-yung-jii anu-ngugulmung-jii waari anggu-warradang, anubani ari nugurru nambani-madharrii marri nambani-barawudang yuuguni buguni a-ngura-wuy!” Dani-yung ni-yamaa, ni-magini naagi-yung ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yagu warraarrawindi warraawurru-yung, wugurraayung wunu-yandhawiwandi niga, “Yuga anaani naambu-yaminggarrang nurru?” Dani-yung wurru-yamayn wugurraayung. ");
INSERT INTO nuy_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nigaayung wani-yambalmayn, “Bama-waṉagana-maynji manubama-yung manuulawaa mana-yaaḻi, warraaynbaj-maynji warrubawi-yung amaari-maynji, yagu manubama-yung bambiiyn wugurru. Ba-waṉagana-maynji ana-marrya, yagu wugurru-maynji ambaambalalari, warrubawi-yung bambiiyii nagang.” Dani-yung ni-yamaa niga. ");
INSERT INTO nuy_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Warra-mulung-arrgi-yung warruburru-yung wirri-manga-mangi-yinyung anu-ṉuga, wirri-muṉḏu-muṉḏugaa-yinyung, wurru-yanggi buguni nigawi-wuy na-John-guy, nga waniimbara-ngambijgaa yungguyung niga. Wurru-yamayn, “Barra-yiyi-yiyina-yinyung nagang, yuga anaani nurru naambu-yaminggarrang aḏaba?” ");
INSERT INTO nuy_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nigaayung ni-yamayn, “Nimbirri-mang anubani anggu-wandhurrg-jinyung anu-ṉuga, yagi nugurru anubani-yung nurru-murruwi aadanu.” Ni-yamaa dani-yung niga ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Warruburru-yung wugurraayung wurru-wiynji-wiynjini-yinyung wurru-yanggi buguni nigawi-wuy. Wurru-yamayn, “Yuga nurraayunggaj anaani, nurru naambu-yaminggarrang?” wugurraayung wurru-yamayn. Nigaayung wani-yambalmayn wugurri-wuy, ni-yamayn, “Nugurru aadanu yagi narraa-gamajangi warra-mulung-arrgi-yung. Yagu yagi narra-wu, marri yagi narraa-gamajangi. Yagi narra-dhaayurri, marri narraa-gawaḻi warra-mulung-arrgi-yung-jinyung, yagi-magi yungguyung nirri-mi anu-ṉuga. Nimbirri-mani danu-yung-bugij nugurri-nyinyung anu-ṉuga, nga wiiya.” Dani-yung ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nubagi-yung warruburru-yung wunaa-garranggaa niga nubagi-yung na-Messiah, na-runggal-yung nigawi-nyinyung na-God-jinyung. Yaani-yung wuu-yamijgaynjini wugurru, “Yaagi-yung yuga John, yuga runggal-yung naagi?” wurru-yamayn wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nigaayung na-John wani-yambalmayn wugurru, “Ngaya anaani nganaambara-ngambijgana guugu-mirri. Yagu niga nubagi naaynbajung ni-lhamarrii-yinyung ani-yaarri wurrugu, dagila lhaalhag. Niga ni-waḏa-waḏaḏ, waari nguynju ani-yamang ngayawi-yii. Niga ni-runggal windiyung nubagila niga, yagu ngaya anaani nga-wirrig. Yagi ngaya anaani nga-burrdangi marri nganu-mun-ngarrgiwu manubama nigawi-nyinyung ni-mun-jabina-yinyung. Niga Maṉngulg Mawurr-mirri nambaniimbara-ngambijgana, marri ngura-mirri.” ");
INSERT INTO nuy_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Na-John niga ni-yambini-wugij. “Niga ngaambani-muṉḏugijgana ngagurru warra-wurru-wurruj nigawi-nyinyung-jinyung anaani. Yagu warruburru-yung warra-mulung-arrgi-yung, amburru-yaarri wubani-wuy a-ngura wu-naga-nagina-wuy. Niga ani-waṉbina lhaalhag. Anaani wiijamana, nguynju yaga wubani wu-maḏa-muṉḏugina a-maḏa, marri wirri-rajaarrijgana. Nubagi-yung ni-lhamarrii-yinyung, niwaadbarrwumana wugurru anubani-yung anu-ḏal yuuguni, yagu wugurraayung anubani ana-maḏa wu-maḏa-rijbina. Buguni wu-yaarri wubani-wuy a-ngura-wuy. Ana-ngura anaani wugurru waari anggu-ngawang, wu-wandha-wuguuguni wu-bu-burraa wu-naga-nagina wugurru.” ");
INSERT INTO nuy_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ni-yambini dani-yung na-John, niga na-nidhaawu-yung ni-yamaa. Anaani anaarrgi-yung ana-lhaawu ngijang, ni-yamaa. “Numburraagina aḏaba na-Buunggawa-wuy,” ni-yamaa. Ni-wuguuguni niga ni-yamaa-wugij. Wani-magaa ana-lhaawu na-God-jinyung. ");
INSERT INTO nuy_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yagu naagi-yung na-Herod nubagi-yung na-runggal-yung, niga ni-mayini tetrarch, ni-waṉbini niga aladi. Naadagi-yung na-nilharri-yung na-Philip, ngigaayung ngarraagi-yung nga-rangarrina-yung ngarra-ngarrimuwaj-jung Herodias. Ngarraagi-yung Herod ngaaṉa-miyn, nga bagu winiinggarra-yaay. Anaani niga ni-waṉbini arrawindi aladi ngijang. Nigaayung na-John niga ni-warranggaa, marri nu-nayn, nga yaani-yung ni-yamayn, “Anaani-yung nunggaṉbini nagang aladi-windiyung,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nigaayung na-Herod aḏaba ngijang runggal-windiyung ni-waṉbini aladi. Niga naagi-yung na-John nu-burriyn aḏaba yuuguni wu-dhidini-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Anubani-yunggaj naagi-yung na-John waniimbara-ngambijgaa niga warraawurru-yung arraarrawindi wurru-wurruj. Marri na-Jesus naagi-yung naambara-ngambijgaa nigaayunggaj. Na-Jesus aḏaba ni-yambini na-Ninyarra-yung-guy. Anaani-yung ana-wumala wu-gara-wawalhiyn aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Nga anubani Maṉngulg Mawurr wu-dhirridangi nigawi-wuy, nguynju yi-ḻabarrg-jii, wu-yamaa. Marri bani-yung ana-lhaawu wu-yaṉḏabaliyn anaarrwar-wala. God ni-yambini, ni-yamayn, “Nagang aadanu ngayawi-nyinyung Nigi, marri ngaya ngunaa-ḏamarr-ngu-burraa, marri ngaya ngaaḻaaḻarrii nugawi yungguyung,” ni-yamayn na-God. ");
INSERT INTO nuy_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Anubani-yung na-Jesus naagi-yung ana-wulhu-wulhurr-waj ni-mijgalmini, naagi-yung ni-burri 30 anaagalhal-aḻirr. Naagi-yung yingga wurraan-jamaa warruburru warra-mulung-arrgi-yung, na-Joseph-jinyung na-niwiyayung niga. Niga naagi-yung na-Joseph, nigawi-nyinyung na-ninyarra-yung Heli. Marri naadagila-wala na-Joseph-gala, nga yuuguni waagaagina yuuguni ana-muwaj na-Adam-guy marri nga na-God-guy. Joseph, Heli, ");
INSERT INTO nuy_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matthat, Levi, Melchi, Jannai, Joseph, ");
INSERT INTO nuy_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Mattathias, Amos, Nahum, Esli, Naggai, ");
INSERT INTO nuy_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maath, Mattathias, Semein, Josech, Joda, ");
INSERT INTO nuy_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joanan, Rhesa, Zerubbabel, Shealtiel, Neri, ");
INSERT INTO nuy_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melchi, Addi, Cosam, Elmadam, Er, ");
INSERT INTO nuy_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Joshua, Eliezer, Jorim, Matthat, Levi, ");
INSERT INTO nuy_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simeon, Judah, Joseph, Jonam, Eliakim, ");
INSERT INTO nuy_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Melea, Menna, Mattatha, Nathan, David, ");
INSERT INTO nuy_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jesse, Obed, Boaz, Salmon, Nahshon, ");
INSERT INTO nuy_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Amminadab, Ram, Hezron, Perez, Judah, ");
INSERT INTO nuy_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jacob, Isaac, Abraham, Terah, Nahor, ");
INSERT INTO nuy_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serug, Reu, Peleg, Eber, Shelah, ");
INSERT INTO nuy_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Cainan, Arphaxad, Shem, Noah, Lamech, ");
INSERT INTO nuy_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Methuselah, Enoch, Jared, Mahalaleel, Cainan, ");
INSERT INTO nuy_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enos, Seth, Adam, God. ");
INSERT INTO nuy_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Naagi-yung na-Jesus niindharwiiyn niga aḏaba Maṉngulg-mirri Mawurr. Anubani-yung niga niwaarruyn aḏaba anaala ana-Jordan-jinyung ana-lhal. Nga ninggu-yamijgayn anaani-yung ana-Maṉngulg Mawurr, “Ba-yaarri aḏaba yuuguni a-lhal-aṉḏarr-guy,” ninggu-yamijgayn. Nigaayung ni-yanggi buguni. Anubagu niga ni-burri 40 mana-miyn.nganga. Anubani-yung ana-Maṉngulg Mawurr bagu ninggaa-ḏagaani. Nigaayung na-baḏirrnya-yung bagu naa-dhangu-jujurangi naagi-yung. Anaani waari niga ani-nguni ana-marrya, manubama-yung 40 mana-miyn.nganga ni-burri. Anubani-yumbaa… ni-bu-burri… nga ni-marryaadiyn-bindiyung aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nigaayung na-baḏirrnya-yung bagu ni-yamayn, “Yuga nagang aadanu na-niwiyayung na-God-jinyung? Nagang aadanu manaama bama-yamijgang mana-ṉuga, nguynju ama-marrya-wiiyn magurru,” ni-yamayn na-baḏirrnya-yung niga. ");
INSERT INTO nuy_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nigaayung na-Jesus nu-yambalmayn, ni-yamayn “Anaani ana-wubiba wu-yamana waarrarrina, ‘Nagang-maynji ba-nguyii-wugij ana-marrya, yagi numbiri-mi-windiyung.’” Dani-yung ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Anubani-yung na-baḏirrnya-yung niga nu-yarrijgini yuuguni a…rrwiyaj. Anubagala nu-wudhiyn yuwaagu arrwar, nga nu-bajiyini anaani anaarrawindi-lhangu ana-lhal. Anaani-yung wiij-dhamun.gurrg, yagu niga nu-bajiyini. ");
INSERT INTO nuy_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nigaayung na-baḏirrnya-yung ni-yamayn, “Anaani nunggu-nayii ana-lhal, anaani ngaya wiiyn nugawi-wuy. Nugawaj ba-buunggawa-mana aḏaba, marri anubani anaarraambaḻaman-jinyung wu-warra-ngu-burraa-yinyung, wugurru nagang baarra-waṉagana. Ngaya-waj yamba anaani nga-buunggawa-mana aḏaba anaani ana-lhal, ngaya-waj yamba anaani ngaarra-mangi aḏaba. Warraaynbaj-maynji ngaya warrubawi-yung ngambiiyn, yagu anaani ngaya ngambiiyn aḏaba! ");
INSERT INTO nuy_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Aadanu-maynji ngaya nimba-warraarriwana ngayawi-wuy, anaani-yung baarra-waṉagana aḏaba nugawaj.” Dani-yung ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nigaayung na-Jesus nu-yambalmayn, nga ni-yamayn, “Anaani waarrarrina ana-wubiba, ‘Nagang banu-warraarriwana God-bugij, nigaaj-bugij, banu-yandhurrbangana niga-waj.’” Dani-yung ni-yamayn nigaayung na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Anubanila-wala niga na-baḏirrnya-yung nu-yarrijgini yuuguni Jerusalem-guy. Nga yuwaagu nu-burriyn arrwa-garrwar, wuguṉi wini-walamalhi arrwar wu-nguḏulbu-rruj a-Temple-Maṉngulg. Nga bagu nu-magaa niga, “Yuga nagang aadanu na-niwiyayung na-God-jinyung yuga? Warrg! Yaajili ba-garrajang yingga! ");
INSERT INTO nuy_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Anaani yamba waarrarrina wugurru, ‘Niga na-God ani-magana-windiyung nigawi-nyinyung ana-angel nugawi-nyinyung, nagang anggu-rangarrii ana-maaḻamburrg. ");
INSERT INTO nuy_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Wugurru ambi-waṉagana nagang wugurri-nyinyung-duj a-marang nguynju yadhu nagang yagi nunggu-lhambiḻdhi ana-mun mana-ṉuga-rruj.’” Dani-yung ni-yamaa na-baḏirrnya-yung. ");
INSERT INTO nuy_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nigaayung na-Jesus nu-yambalmayn, ni-yamayn, “Anaani-rruj wu-yamana ana-wubiba, ‘Yagi nagang nunu-rawu, niga na-Buunggawa nugawi-nyinyung na-God,’” Dani-yung ni-yamayn nigaayung na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Anaani na-baḏirrnya-yung naagi-yung na-Jesus naa-dhangu-jujurangi arrawindi. Anubanila-wala wiij-ngu-jadugiiyn aḏaba. Anubanila-wala naarruyn, niga aḏaba ni-yanggi. Naagi-yung na-baḏirrnya-yung nu-rangarrangi, aniga-yung anubani aniij-mamaaḻang ngijang anggu-waṉiyn-maynji nigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Anubanila-wala, malgadhaadharri aḏaba anubani-yung, na-Jesus niigiyn yuuguni Galilee-wuy. Naagi-yung niga niwu-waṉagaa lhuḏ-bindiyung Maṉngulg Mawurr. Nigawi-nyinyung ana-lhaawu aḏaba anaani wu-lhaawu-rajaarrangi nigawi-nyinyung a-lhal-waj. ");
INSERT INTO nuy_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Naagi-yung ni-yanggi-magaa wubani-wuy warraarrawindi-wuy wurru-muṉḏugaa-wuy warra-Jew, wu-mayini synagog. Nga bagu wani-magaa-magaa niga warruburru-yung-guy. Nga warraawurru warraarrawindi wugurru wurru-yamaa, “Naagi yagu niga ni-mamanunggu ngijang!” ");
INSERT INTO nuy_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Anubanila-wala niga ni-yanggi yuuguni buguni Nazareth-guy. Nga anubani-rruj ana-lhal wu…bani-yunggaj ni-burri niga bagu, nga ni-warradangi bagu wubani-rruj a-lhal. Ngarrubagi-rruj ngarraaḻirr-maṉngulg-duj, anubani ni-yanggi aḏaba buguni a-synagog-guy. Anaani ni-yamaa-wugij niga ni-yanggi, ni-wandha-wuguuguni. Ni-yanggi… nga bagu naagi-yung ni-lhangayn yuwaagu raga-ragij warruburru-rruj, nga nigaayung aynbajung nu-yayn wubiba, niwu-nani yungguyung niga. ");
INSERT INTO nuy_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Anaani-yung ana-wubiba na-Isaiah-yinyung, nubagi-yung yaga naa-ja-jambini-yinyung na-God-jinyung anu…bani-yunggaj naagi-yung. Nigaayung na-Jesus aḏaba niwu-gara-wawalhijgayn anaani ana-wubiba. Nga anaani niga ni-warra-garranggaa nga anaani niwu-lhangarrmayn aḏaba anaani-rruj-jinyung waarrarrini-yinyung anaani ana-wubiba-rruj. Wu-yamaa, ");
INSERT INTO nuy_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Anaani na-nimawurr-yung ni-burraa ngayawi-rruj na-Buunggawa. Anaani na-Buunggawa ngaya ni-wajbariyn aḏaba. Nguynju yadhu anaani ngamba-magana ana-lhaawu warruburru-wuy warraambalalari-wuy. Anaani yamba wu-mamanunggu ana-lhaawu. Warruburru-yung wugurru warra-mulung-arrgi-yung wuu-radbidhaa aḏaba, na-God niga anaani-yung ngani-lharrgang ngaya, nguynju yungguyung ngaya nga-magina anaani ana-lhaawu, ‘Numbuu-yaarri aḏaba nugurru, nambani-muḻugu-wana niga.’ Yagu warruburru-yung-guy nga, warra-bagaḻang-alaaladi-yinyung, ‘Nugurru aḏaba numburraarranggana.’ Yagu burru-yung wurru-buunggawa-maa-yinyung durru-yung nga warraaladi-waa warra-wurru-wurruj, marri ngaya ngamba-muḻugu-wang warruburru. ");
INSERT INTO nuy_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Danu nga ngaya-waj ngamba-magana, ‘Yaani aḏaba wiij-maṉdhina, God niga-waj nambani-muḻugu-wana aḏaba niga.’” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ngijang niwaagijgini niga aḏaba, niwu-dhawawarumaa ana-wubiba. Nga anubani-yung niga naagagijgiyn nubagi-yung-guy na-waḻyinyung nu-marangayn-jinyung niga. Nga ni-burrangayn aḏaba, nguynju yadhu niga-waj ambani-magaa yungguyung warruburru-yung-guy. Nga warruburru-yung-jinyung anubani-rruj ana-synagog, anubani-yung wurraarranggaa wunu-nani niga. ");
INSERT INTO nuy_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nga yaani-yung ni-yambini. Ni-yamayn warruburru-wuy, “Anaani ana-lhaawu ana-yimbaj wu-waṉbina yijgubulu-windiyung, aani-rruj yamba nugurru aḏaba nurraawanggina ana-lhaawu,” ni-yamaa dani-yung niga. ");
INSERT INTO nuy_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Yagu wugurraayung aḏaba wurru-yambiynjini marri bagu-waj wurru-ngulu-ngulu-yambini wugurru. Wurru-yamayn, “Yagu naagi yamba aḏaba ngarrani-magana ngagurri-wuy lhaawu-mamaaḻang ana-lhaawu niga! Yagu naagi na-Joseph-jinyung niga na-niwiyayung, aliyung yuga?” wurru-yamayn dani-yung. ");
INSERT INTO nuy_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nigaayung na-Jesus ni-yamayn, “Danu muga nugurru-waj ngirri-magana ngaya ana-lhaawu, ‘Nagang aadanu barra-maja-maji-wana-yinyung aadanu, yagu ba-maji-wina nugaajbaj aadanu!’ Marri ngirri-magana, ‘Anaani-yung nurru nurraawanggini wubani yaga nunggaṉbini wubani-rruj a-lhal a-Capernaum. Aadanu nagang baaṉbina anaani-rruj ana-lhal nugawi-rruj, anggiiyn-miḻgi-wugij aḏaba aadanu.’ Ari danu muga yaani numburru-yambina nugurru.” ");
INSERT INTO nuy_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Na-Jesus ni-yambini-wugij, wani-magaa niga. “Yagu ngaya ngana-magana anaani yijgubulu windiyung, warruburru-yung wunaa-ja-jambini-yinyung na-God, warra-wurru-wurruj wugurraayung warraagaminij-gaandirrangi, warruburru-yung wugurri-nyinyung-jinyung anubani-yung ana-lhal. ");
INSERT INTO nuy_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Yagu ngaya anaani ngana-magana ngubindi windiyung, anu…bani-yunggaj niga naagi-yung na-Elijah ni-burri. Wulaynbaj-gala anaagalhal-aḻirr marri marang-aynjaabugij jarranggay nigaayung na-ḻabama, waari ngarraaṉbana ngi-warra-rabini ngiga. Waari anubagu anggu-burri ana-marrya. Warraarraarrawindi warruburru-yung warra-ngaya-ngayi wurru-burri anaani-rruj ana-lhal ana-Israel. ");
INSERT INTO nuy_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Yagu niga na-God waari anaa-ngaynbandangi naagi anu-lharrgandi na-Elijah warruburru-wuy, ambani-maṉmangi yadhu niga. Yagu naagi-yung na-God niga nu-lharrgang wubani-wuy a-lhal-aynbaj-guy, wu-mayini ana-lhal Zarephath anaanga, anubani-yung ana-lhal wu-mayini Sidon. Bagu nga, ngaadagi-yung ngarra-ngayi-nyung ngi-burri, ngiga ngi-lhalmarr yamba. Dagi-yung-bugij nga, ngu-maṉmangi-yinyung, naagi-yung na-Elijah niga.” ");
INSERT INTO nuy_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na-Jesus ni-yambini-wugij niga. “Ngijang anaani-yung anu…bani-yunggaj naagi-yung na-ja-jambini-yinyung na-God, naagi-yung na-Elisha, warraawurru-yung arraarrawindi wurru-burri warraarraguṉḏa-guṉḏa-yinyung, anaani-rruj aḏaba ana-lhal ana-Israel-uj. Yagu na-God naagi-yung waari anaa-ngaynbandangi niga anu-lharrgandi yungguyung na-Elisha, waadurru-yung-guy, yagu yaaji-wugij niga ni-burri, yagu waari niga warraawurru-yung ambani-maji-waa niga. Yagu niga na-Naaman, ni-wawanggiyn lhaawu, nga ni-yanggi yuwaagala Syria-wala, dagi-yung-bugij niga nu-maji-wayn, naagi-yung na-Elisha.” Dani-yung ni-yamaa naagi-yung na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yagu wugurraayung warraawurru ana-synagog-jinyung wurru-burri anubagu, aḏaba wurraawanggiyn, yagu warraawurru wunaa-ḏiyaldhiyn-bindiyung niga. ");
INSERT INTO nuy_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Warraawurru-yung wugurru wurru-ḻaḻagiiyn, nga wunu-waṉja-miyn niga aḏaba, nga wunu-waṉjaarrgini nga wunu-jurrjurrgini niga anubanila-wala ana-wumurrng-gala nga wunu-rabalijgini niga. Nga anubanila wunaarrgini niga nga buguni wubami-wuy ama-ṉuga ma-ḻandhirrngindi-wuy, nga buguni wunu-yarrijgini, nga bagu-rruj dama warubaj wubani-rruj a-wumurrng-duj. Nga bagala naagi-yung ambunu-barawudangi yungguyung niga. ");
INSERT INTO nuy_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Yagu naagi-yung niga na-Jesus wani-galiynbarwang waadurru-yung wugurru, nga bagala-yung niga ni-yanggi ni-yaḻdhiyn naagi-yung wugurri-waj. ");
INSERT INTO nuy_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Anubanila-wala aḏaba ni-yanggi yuuguni Galilee-wuy, anubani anaanga wu-mayini-yinyung Capernaum. Ngijang bagu wani-magaa wugurru aḏaba wubani-rruj a-lhal a-synagog-duj, yiibagi-rruj yi-waḻirr-maṉngulg-duj. ");
INSERT INTO nuy_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yagu warraawurru wurru-wurrij-gaḻaaḻarriyn wudani-yung-gala ni-yambini a-lhaawu, anaani yamba ni-yambini nguynju yaga ni-ragaana-yii. Niga yamba ni-yambini wu-waḏa-waḏaḏ-bindiyung ana-lhaawu wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Anubani-rruj ana-synagog-duj bagu waḻyinyung ni-burri, anubani-yung man.gurrg aladi ni-waṉagaa niga. Naagi-yung niiḏangi yanggarrwar-mirri, ");
INSERT INTO nuy_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","anubani ana-man.gurrg ninggaaḏijgaa, “Yagay yagay! A-yangi yungguyung nagang nimba-warubaj-gana nurri-wuy, Jesus a-Nazareth-jinyung? Yuga nagang aadanu nimba-jadugang anaani nurru? Ngaya nga-marrbuy nagang, nagang aadanu na-maṉngulg-jung na-God-jinyung,” wu-yamayn ana-man.gurrg wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nigaayung na-Jesus ni-yambini yang-baḏa-waḏaḏ lhaawu, ni-yamaa, “Ba-muḏaḏbang, ba-rabalang nigawi-wala,” ni-magaa wubani-wuy a-man.gurrg-guy. Nga anubani-yung ana-man.gurrg ninggu-barawudiyn naadagi-yung na-wurrujung, nga bagu wugurri-rruj bandharra ni-rabini niga. Marri bani-yung aḏaba wu-rabalangi. Yagu naagi-yung waari aninggu-warragayangijgaa niga. ");
INSERT INTO nuy_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Wugurraayung warruburru-yung warraarrawindi wurru-wurrij-gaḻaaḻarriyn-bindiyung marri wuu-yandhawiwaynjini, wurru-yamayn, “Ana-lhaawu yuga anaani wiijaminggarrina? Yagu naagi-yung niga ni-yambini wu-waḏa-waḏaḏ-bindiyung ana-lhaawu! Niwu-waṉagana niga lhuḏ-bindiyung! Yagu niga ni-warra-magaa-maynji, ana-man.gurrg-guy, yagu anubani-yung wu-ngarra-ḏabalangi.” Dani-yung wurru-yamaa wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Anubani ana-lhaawu aḏaba wirri-rajaarrijgayn wugurru, yuuguni a-lhal-wurraayung-baj wubani-rruj-jinyung wu-ridiynjini a-lhal, aadani-yung ana-lhaawu, wu-yamaa. ");
INSERT INTO nuy_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Anubanila-wala ni-ḻaḻagiiyn aḏaba, marri ni-rabaliyn wubani a-synagog-gala. Aḏaba yuuguni ni-yanggi, wubani-wuy aanga-wuy nubagi-rruj na-nimuwaj-jung ni-mayini niga Simon. Naagi-yung ni-yanggi nga buguni ni-yabiyn wubani a-wumurrng-guy. Naagi-yung na-Simon niga ngaadagi-yung ngiga ngaa-ranggurrumbayung, ngarraagi-yung ngi-lhangurrngang, marri ngi-warra-murrmbulangi ngiga. Naagi-yung wunu-yandhawiwandi niga na-Jesus, nguynju yadhu nigaayung yingga angu-maji-waa yungguyung. ");
INSERT INTO nuy_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nga ni-yanggi na-Jesus ngigawi-wuy, nga bagu ni-lhangayn ngaadagi-yung-duj ngi-murrgulhi-rruj. Nga naagi-yung na-Jesus ni-yambini wu-waḏa-waḏaḏ ana-lhaawu, niwu-yamijgaa wubani-wuy a-wudhangurrg-guy. Yagu anaani ana-wudhangurrg ngiga nginggaarruyn. Lhugaajgiyalawaj ngarraagi-yung ngi-ḻaḻagiiyn aḏaba, nga ngiga-waj wangiini aadani-yung ana-marrya, wurru-nguni-yinyung. ");
INSERT INTO nuy_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Aḏaba wugurru anubani-yung waamulugugurriyn. Bani-yung marri wugurru warraarra-yurangi warra-wurru-wurruj nigawi-wuy, warraawurru-yung yamba wirri-waṉagaa aynba-gaynbaj-jinyung wudhangurrg wugurru. Yagu naagi-yung-guy wugurru wunaa-garra-yurangi na-Jesus-guy. Warraawurru-yung wani-waṉagaa marri wani-maji-waa, waadurru-yung warraarrawindi-lhangu. ");
INSERT INTO nuy_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Marri wugurraayung warraarrawindi wurraarra-waṉagaa man.gurrg. Anubani-yung wu-warra-rabalangi wugurri-wala. Anaani wugurru ana-man.gurrg ninggu-yamijgaa niga, “Nagang aadanu na-niwiyayung na-God-jinyung!” wu-ngarra-jamaa ana-man.gurrg wugurru. Yagu niga anaani ni-muḏaḏbijgaa, aḏaba ni-yambini, yagu naagi-yung yamba niga wu-marrbuy aadani-yung, naagi-yung na-Messiah, na-runggal-yung na-God-jinyung. ");
INSERT INTO nuy_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Wurrugu marri malgadhaadharri-windiyung, anubani anggu-lhalmbaarrang-jinyung wugurru. Niwaarruyn niga anaani aḏaba ana-lhal. Nga naagi aḏaba ni-yanggi yuuguni waari-wuy amburru-burri warra-wurru-wurruj. Yagu warraawurru-yung wugurru warra-wurru-wurruj wunaagalhaga-lharrmangi niga. Wunaaga-galhaga-lharrmangi… nga wunu-lhangarrmayn. Yagu wunu-ngaynbandangi warraawurru-yung bagu ani-burri niga. ");
INSERT INTO nuy_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yagu nigaayung wani-yamijgayn, “Anaani nga-magina ngaya wu-mamanunggu-windiyung ana-lhaawu, naagi-yung na-God niga wani-rangarrii-yinyung warrubawi-yung nigawi-nyinyung warru-mandag. Anaani aḏaba wiij-maṉdhina. Ngaya anaani ngaynjaarri marri ngamba-magana warruburru a-lhal-aynbaj-baj-jinyung a-lhal. Anaani na-God niga ngani-lharrgang aani-yung-jinyung yijiijung-jinyung.” Dani-yung ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ni-yanggi… nga wubani a-synagog warra-Jew-yinyung ni-yanggi, wani-magaa niga. ");
INSERT INTO nuy_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Anubanila-wala aḏaba ni-yanggi wubani a-wurugu-wuy, nga anubani ana-lhal wu-mayini Genessaret, nga wugurraayung wu-lhal-nguynju anaani, yagu anaaynbaj anu-muwaj wu-mayini Galilee. Warraawurru-yung wugurru warra-garnyirrimba wurru-ngarra-janggi aḏaba, wurru-lhardhargaynjini marri wunu-jurangi naagi-yung na-Jesus. Wirri-ngaynbandangi yamba wubani a-lhaawu amburraawanggini yungguyung na-God-jinyung a-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Naagi-yung nigaayung na-Jesus ni-warranggayn nga manubama-yung nima-nayn muulawaa barrawu. Ma-radbidhi bagu a-wungarrg-duj. Warruburru-yung wurru-ngaḏa-ngaḏugumbini-yinyung anubani ana-ngujija, waari anubagu amburru-burri wugurru. Yuwaagu wurraadadiyn ama-madha-gaḻaḻij-duj nga wirrima-yarrbini mana-naynja wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nga nigaayung na-Jesus ni-yanggi wubama-wuy amaaynbaj-guy ama-barrawu-wuy nga ni-yabaynjiyn niga aḏaba, nga manubama-yung na-Simon-jinyung nigawi-nyinyung, mana-barrawu. Nga na-Jesus nu-yandhawiwandi na-Simon-guy, “Manaami mana-barrawu bama-jurang yuuguni bandharra-wuy,” ni-yamayn. Niga niindhadhangayn nga bagu ama-barrawu-rruj, nga bagala wani-magaa niga na-Jesus waadurru-wuy warra-wurru-wurruj-guy. ");
INSERT INTO nuy_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wani-magaa… nga aḏaba ni-wiyn.gayn ana-lhaawu. Nga ni-wiḻibiḻingiyn, nga nu-yamijgayn na-Simon-guy, “Wili, ngaambu-yaarri yuuguni aḏaba aalagararij-guy. Nugurru aḏaba aadanu bagu nga nimbirrima-barawudang maadamu mana-naynja nga numburru-ngaḏugumbina.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nigaayung na-Simon ni-yamayn nu-yambalmayn nigawi-wuy, “Buunggawa, anaani nurru-mijgalmini mana-wuṉ nirrima-mal-dharrma-dharrmangi… nga wu-ḻaḻmayn. Yagu waari naambu-mangi ana-ngujija anaaynbaj. Yagu nugawaj yamba danu nimba-magayn, manaama naama-barawudang mana-naynja.” Dani-yung ni-yamayn na-Simon. ");
INSERT INTO nuy_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Yagu aḏaba anubani-yung wani-yamijgayn-gala, anubani-yung wurru-waṉbini. Yagu warraawurru wurru-miyn aḏaba ngujija a…rrawindi-windiyung. Yagu manaama-yung mana-naynja lhaalhag amaarra-wulguldhangi magurru. ");
INSERT INTO nuy_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Warraawurru-yung wugurru wurru-mijgalmini-yinyung aḏaba warruburru-yung-guy warraa-gaḏangi warra-bagarraaḏangi wubama-yung-guy amaaynbaj-guy ama-barrawu. Warraawurru-yung anuwagala aḏaba wurru-madhandangi wugurraayung wubama-yung-guy ama-barrawu. Manaama-yumbaa magurru mana-ramba-wulawaa mana-barrawu-waa manubama maandharwiiyn-bindiyung ngujija-wugij. Lhaalhag yungguyung manaama-yumbaa aḏaba ama-ngambini. Manubama-yumbaa ma-nyigarrngij aḏaba ma-yanggi-waa. ");
INSERT INTO nuy_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Naagi-yung na-Simon Peter ni-warra-nayn-gala a-ngujija, nga aḏaba ni-garrajiyn nga ni-jarrarriyn, nga ni-ḻandharrdhangayn na-Jesus a-mun-duj. Nga nu-yamijgayn na-Jesus-guy, “Buunggawa, ba-yaarri ngayawi-wala, ngaya yamba anaani ngaaladi,” nu-yamijgayn nigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Naagi-yung yamba niga ni-wurri-ḻaḻmayn. Marri warruburru-yung wurraanggarra-yanggi-yinyung, wugurraayunggaj wurru-wurri-ḻaḻmayn. Anaani-yung yamba wugurru wurru-miyn-bindiyung arrawindi yamba ngujija. ");
INSERT INTO nuy_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Naawiṉi-yung wuguṉiiyunggaj na-James marri na-John, na-niwiyayung-biiyung na-Zebedee-yinyung, warraawurru-yung wugurru aynjaabu buguni wurru-mijgalmini waadurru-yung na-Simon-guy. Yagu nigaayung na-Jesus nu-yamijgayn na-Simon-guy, “Yagi nagang nu-ngu-ḏirrngawi aadanu. Anaanila-wala aḏaba nagang bamba-mani wurru-wurruj bamba-muṉḏugijgana aḏaba na-God yungguyung.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Manaama-yumbaa aḏaba wurru-madhandangi yuuguni buguni aḏaba a-wu…ngarrg-guy. Warraawurru-yung aḏaba wurraarra-garraarruyn aadani-yung anaarrawindi-lhangu, aḏaba wurru-yanggi wunu-garrindharrmangi nigawi-wuy na-Jesus-guy aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wurrugu marri malgadhaadharri, anubani-yumbaa wurru-yanggi yuuguni a-wumurrng-guy. Naagi-yung aynjaabu-nyung waḻyinyung bagu arra-guṉḏa-guṉḏa-yung ni-burri wubani-rruj. Nga nu-nayn naagi-yung na-Jesus. Nga ni-yi-ngu-burrdangayn na-nijilhal-yung yuuguni aaban-guy. Nga naagi-yung niga nu-lhangayaani, ni-yamayn, “Buunggawa, yuga nagang ngaya nunggu-ngaynbandii-maynji, baaṉiyn aḏaba nimba-maji-wang ngaya anaani.” Dani-yung niga ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nigaayung naagi-yung na-Jesus ni-marang-dhaayiyn aḏaba nga nu-waṉagayn. “Yuu, ngaya anaani ngawu-ngaynbandii. Nagang ba-maji-mang aḏaba,” ni-yamayn. Anubani-yumbaa aḏaba lhugaajgiyalawaj naagi-yung ni-maji-mayn niga. Waari anubani aḏaba ani-warra-guṉḏa-guṉḏa-maa, aḏaba niga naagi-yung ni-warra-maṉdhiiyn niga. ");
INSERT INTO nuy_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nigaayung naagi-yung na-Jesus nu-magaa aḏaba naadagi-yung-guy, “Yagi nagang barra-magi warruburru warra-mulung-arrgi-yung-guy,” nu-yamijgayn, “Yagu anaanila-wala ba-yaarri nagang nga nubagi-yung-guy na-priest-guy, ni-maga-magina-wuy wubani a-Temple-Maṉngulg-guy, nga bagu banu-magana nga banu-bajiyina niga. Ani-nayii yungguyung nagang aadanu nundhar-mamarriynjina. Nga marri banuuyii aḏaba nigawi-wuy na-God-guy, nguynju yaga anu…bani-yunggaj na-Moses ni-yambini. Nagang yamba nu-maṉdhiiyn aḏaba. Nguynju yungguyung warruburru-yung warra-wurru-wurruj amburru-marrbuy.” Dani-yung yigaj ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yagu anaani-yung na-Jesus-jinyung ana-lhaawu aḏaba wu-rajaarrangi, ngijang wuguuguni-wugij, ana-lhaawu aadani-yung aḏaba. Warraawurru-yung warraarrawindi warra-wurru-wurruj wugurru wurru-yanggi, nga aḏaba wurru-muṉḏugaa, wunu-dhawawarumayn niga. Anaani-yung wugurru amburraawanggini yungguyung marri amburru-maji-maa yungguyung wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yagu malgarrawindi niga naagi-yung na-Jesus waniirru-magaa, nga ni-yanggi wubani-wuy a-lhal a-wulbul-wuy aḏaba, ni-yanggi-magaa marri bagu, nu-yambini-magaa, nu-yandhawiwaa na-ninyarra-yung-guy niga. ");
INSERT INTO nuy_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Malgaynjaabugij niga wani-marrbuy-waa aḏaba warra-wurru-wurruj-guy wubani-rruj a-wumurrng-duj. Warruburru-yung warra-Pharisee marri warruburru-yung warra-marrba-marrbuy-waa-yinyung nga bagu wurru-burri. Warraawurru-yung wurru-yanggi wubanila a-lhal a-Galilee-wala marri yuwaagala Jerusalem-gala. Nga bagu marri wugurru wurru-muṉḏugaa. Yagu naagi-yung na-Jesus niwu-waṉagaa lhuḏ-bindiyung na-Buunggawa-wala, nguynju yadhu niga wani-maji-waa yungguyung waadurru-yung. ");
INSERT INTO nuy_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wugurraayung yuwaagala waḻya-waḻya ngijang wurru-yanggi. Nga naagi-yung wunu-warrgaay bilwilwilijung, waari naagi ani-yangga-yanggi, ni-murrgu-murrgulhi-wugij ama-yaaḻi-rruj. Naagi-yung buguni yungguyung ambunu-yarrijgini wubani-wuy a-wumurrng-guy, bagu yungguyung ambunu-burrangi na-Jesus-duj raga-ragij. ");
INSERT INTO nuy_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Yagu wugurru wurraarranggayn, anubani-yung wirri-dhaṉ-gayn wurru-wurruj-bugij wurraarra-garra-lhi-yinyung, wirri-dhidiyn. Yagu anubanila-wala wurraadadangi a-wumurrng-duj wu-nguḏulbu-rruj aarrwa-garrwar. Nga yuwaagala aarrwar-wala wirri-gara-yungaa. Nga anubagala wunu-lharrgandi aarrwar-wala wurrugurrij-bugij, ni-murrgulhi-wugij yaaḻi-mirri. Bagu waa-wawalhangi miyn.ngalag waa-wirrig raga-ragij na-Jesus-duj, nga bagu wunu-murrgulhi niga naadagi-yung na-bilnyalga-yung. ");
INSERT INTO nuy_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Na-Jesus nigaayung naagi-yung ni-marrbuy waadurru-yung wurru-jambarrgiiyn. Yagu anaanila-wala nu-yamijgayn, “Guwaj, aḏaba nagang aadanu nundaarrbidi-mayn aadanu-wala anaaladi,” ni-yamayn niga, nu-yamijgayn. ");
INSERT INTO nuy_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yagu warraawurru-yung warra-yiyini-yinyung ana-lhaawu-runggal marri warra-Pharisee wurru-wijangani wugurru. “Yangi-nyung yuga niga naagi? Naagi niga aḏaba nu-barawudii niga na-God! Yagu God-bugij niga-waj ngarraniigajij-garruna-yinyung anaaladi.” Dani-yung wurru-yamaa wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nigaayung na-Jesus naagi-yung ni-marrbuy aadani-yung wurru-wijangani-yinyung. Wani-yambalmayn wugurri-wuy, “A-yangi yungguyung yuga nugurru nuu-wijangayii aadanu,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","“Anaani ngaya nga-yambini, ‘danu nundaarrbidi-mayn anaaladi-wala,’ danu nga aniij-garrarra. Yagu ngaynjamang-maynji ‘ba-ḻaḻagiiyn marri ba-jarrarrang,’ danu nga aniij-miḏaamimi ana-lhaawu, nugurru yamba numbunu-nayii, ani-yaminggarrang niga, nguynju yadhu numburru-marrbuy. ");
INSERT INTO nuy_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","“Ngana-ngaynbandii ngaya anaani numburru-marrbuy-mana nugurru. Ngaya-waj nga na-Niwiyayung na-Wurrujung-jinyung. Ngawu-waṉagana anaani lhuḏ-bindiyung anaani-rruj ana-lhal, nguynju yadhu ngambaagajij-garruna warra-wurru-wurruj anaani anaaladi-wala.” Dani-yung ni-yamaa na-Jesus. Anubani-yumbaa nu-yambini naadagi-yung na-bilnyalga-yung-guy, “Anaani ngunu-magana, ba-ḻaḻagiiyn, nga ba-jarrarrang bama-warrgurrang maadamu mana-yaaḻi, ba-yaarri aanga-wuy,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yagu naagi-yung lhugaajgiyalawaj niga ni-ḻaḻagiiyn, aḏaba ni-jarrarriyn, warruburru raga-ragij wunu-nani-wala ama-bagaḻang-gala wugurri-nyinyung-mirri. Nima-miyn manaama-yung mana-yaaḻi nga aḏaba ni-jarrarriyn, niigiyn aanga-wuy. Nu-warraarriwaa na-God-guy niga. ");
INSERT INTO nuy_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Warraawurru-yung wurru-wurrij-barrwarrangi-windiyung, warraarrawindi-lhangu wugurru. Wugurraayunggaj wunu-warraarriwaa na-God-guy, warraawurru-yung yamba wunu-yamayn wugurru. “Waari ngaamba-nani anaani-yung-jii, ambu-yamaa,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Naagi-yung na-Jesus anubanila-wala aḏaba ni-yanggi aanga-wala. Ni-yanggi… nga bagu ni-warranggayn nu-nayn waḻyinyung na-nimuwaj-jung Levi. Naagi-yung niwu-mang-mangi-yinyung anu-ṉuga, ni-bu-burri wubani yaga wirriirrarrangi-rruj, a-tax anu-ṉuga. Niga na-Jesus ni-yamayn nigawi-wuy. “Numba-garrindharrmang ngaya,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nigaayung na-Levi ni-ḻaḻagiiyn aḏaba, nu-garrindharrmiyn. Anubani ni-warra-garraarruyn anaarrawindi wu-warra-ngu-burri-yinyung. ");
INSERT INTO nuy_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Anubanila-wala naagi-yung na-Levi-duj anubani wurru-nguni runggal ana-marrya, nigawi-rruj aanga-rruj, na-Jesus yungguyung. Arraarrawindi wirri-manga-mangi-yinyung warruburru wuṉuga, bagu wurru-burri, marri warruburru mulung-aynbaj, wugurraayung nga bagu wurru-burri. ");
INSERT INTO nuy_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Warruburru-yung warra-Pharisee marri warra-yiyini-yinyung ana-lhaawu-runggal wugurri-nyinyung, warraawurru-yung warra-magaa wurru-marrbuy-maa-wuy, “Numburru-yaminggarrina, nugurru nurru-nguyii waadurru-rruj wirri-mana-mani-yinyung anu-ṉuga marri warraalaaladi-rruj?” Dani-yung wurru-yamaa wugurru, wunu-wurryuwini niga na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nigaayung aḏaba na-Jesus ni-yamayn, “Nugurru numburru-wijangayii nubagi wani-maji-wana-yinyung na-wurrujung. Niga waari ambani-nang warruburru-yung wurru-waḏa-waḏaḏ-mi-yinyung. Niga wani-nayii warruburru-yung wuu-lhangurrnganjii-yinyung, burru-yung-bugij. ");
INSERT INTO nuy_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ngaya anaani ngana-magana anaani-yung. Ngaya nga-yanggi anaanu-wuy, waari-yinyung warra-mamanunggu-yinyung. Ngaya nga-yanggi, ngambaa-gaḏii yungguyung warruburru-yung warraalaaladi-yinyung ngayawi-wuy.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Warra-mulung-aynbaj warruburru-yung wunu-yamijgayn, “Naadagu na-John marri nigawi-nyinyung waadurru wurru-marrbuy-mana-yinyung, malgarrawindi warraawurru-yung waari amburru-ngang ana-marrya wugurru. Yagu wunu-yambina-wugij yuuguni arrwiyaj na-God-guy. Marri warraawurru-yung warra-Pharisee-yinyung wurru-marrbuy-mana-yinyung anaani wugurraayunggaj wuu-yamana wiij-nguynju wugurru, aani-yung-jii. Yagu nagang nugawi-nyinyung waadurru wurru-marrbuy-mana-yinyung, waadurru wurraaḻ-nguyii yagu marri wurru-nguyii!” Dani-yung niga wunu-yamijgayn na-Jesus-guy. ");
INSERT INTO nuy_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Na-Jesus nigaayung wani-yambalmayn, “Nga anaani wiijamana. Na-waḻyinyung-maynji nubagi-yung aniiynji-yara-maynji, anubani-maynji warruburru wurraalgur-maynjini-yinyung anubagu-maynji amburraanggarra-nguyii ana-marrya, yagi nugurru narra-lhambu, narra-muḏaḏbijgi wugurru. Amburru-nguyii-wugij. ");
INSERT INTO nuy_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wurrugu marri, warraaynbaj-maynji marri anuwaagala ambunu-mang nubagi-yung niga ambunu-yarrijgina-maynji, marri anubanila-wala amburru-wurrij-galadi-wiiyn-bindiyung, marri amburru-muḏaḏbang wugurru, yagi wurru-ngi ana-marrya aḏaba.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Anaani-yung wani-magaa-wugij, ni-yambini anubani-yung-jinyung wiij-bulawaa. Ni-yamayn, “Manubami-yung-maynji mana-yaaḻi mana-magadhuwa, yagi manubama-yung nirrima-ḻaḻbu. Manubama-yung magurraayung manaaynbaj mana-lhar-nungguḏaaba-yinyung magurru yagi nirrima-ḻaḻbu nga anubuguni nirrima-dhabiḏbu yagi. Aadanu-maynji numburru-yamana-maynji, manubama-yung mana-magadhuwa mana-yaaḻi yagu manubama-yung ama-jadugiiyn, marri magurraayung manubama-yung mana-lhar-nungguḏaaba yagi ma-gadhuwa-mi magurru, ama-lhar-nungguḏaaba-wugij. ");
INSERT INTO nuy_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Anaani wiij-nguynju aḏaba, anubani-yung-maynji anu-gargayag anu-gadhuwa, yagi nirri-burri anubuguni ana-nungguḏaaba anu-barriguḻag-guy. Aadanu-maynji numburraaṉbina, anubani-yung anu-barriguḻag ana-nungguḏaaba anubani anggu-ḻaḻmang-maynji, marri anubani-yung anggaar-warryina wugurru. Anubani-yung anu-barriguḻag anubani aḏaba anggu-jadugiiyn. ");
INSERT INTO nuy_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Anubani-yung anu-gadhuwa anu-gargayag, nimbirriir-yabana wubani-yung a-wubarriguḻag-guy a-wugadhuwa.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Anaani-yung wani-magaa ana-lhaawu niga. “Warrubawi-yung-maynji ambu-waḻ-nguyii ana-nungguḏaaba ana-wine, danu nga wirri-ngaynbandii. Yagu yagi anubani-yung wirri-ngaynbandi anu-gadhuwa anu-gargayag anu-dhamig ngijang. Ambu-yamana-maynji ngijang, ‘Anubani-yung ana-nungguḏaaba aḏaba wu-maṉdhina, anu-dhamig.’” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Wurrugu marri anubanila-wala, ngarrubagi-rruj ngarraaḻirr-maṉngulg-duj, na-Jesus anubani-yung ni-jarrarrangi banila-yung wu-warradiynjini-rruj wuḏal. Warruburru-yung wurru-marrbuy-maa-yinyung bagala-yung wurru-ral-ngarrgiwaa marri wurru-ral-wuyudangi anu-ḏal. Nga anubanila aḏaba wurru-nguni. ");
INSERT INTO nuy_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Yagu wugurraayung mulung-arrgi-yung warra-Pharisee warra-nayn nga wurru-yamayn, “Nurru-yaminggarrina, aadanu-maynji numburru-waṉbina-maynji ngarraagi-rruj ngarraaḻirr, aadanu wiijamana wiij-galadi-wina.” Dani-yung wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nigaayung na-Jesus wani-yamijgayn, “Yuga nugurru waari nimbirri-nani ana-wubiba-rruj, niga na-David marri warruburru-yung nigawi-nyinyung warra-waḻya-waḻya wugurru wurru-marryaadangi. ");
INSERT INTO nuy_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Marri anubani-yung wurru-yanggi wubani-wuy na-God-guy wubani-wuy a-wumurrng. Marri warruburru-yung warra-priest, yagu burru-yung-bugij wurru-nguni anubani-yung ana-maṉngulg anu-ḏayn anubani-yung na-God-jinyung-duj ana-wumurrng. Yagu anubani-yung na-David ni-miyn, marri waniini warruburru-wuy nigawi-nyinyung warra-waḻya-waḻya, marri wurru-nguni wugurru. Yuga anaani-yung nugurru nirri-nani? ");
INSERT INTO nuy_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yaani nga ngaya-waj na-Niwiyayung na-Wurrujung-jinyung, ngaya-waj yaani nga nga-buunggawa-mana aḏaba ngarraagi-rruj ngarraaḻirr-maṉngulg.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Anubani-yung ngarraaynbaj-duj ngarrubagi ngarraaḻirr-maṉngulg, anubani-yung ni-yanggi wubani-wuy a-synagog-guy, nga bagu wani-magaa. Nga bagu waḻyinyung naagi ni-burri, a-walawalama-wala niga ni-warra-guṉḏa-guṉḏa ana-marang. ");
INSERT INTO nuy_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Warraawurru-yung warra-yiyini-yinyung ana-lhaawu-runggal marri warra-Pharisee wunu-nani wunu-dhi-nani na-Jesus. “Yuga naadagu anu-maṉdhang niga, ngarraagi-rruj ngarraaḻirr-maṉngulg-duj yuga? Ari niga ani-mijgalmina yadhu.” Dani-yung wurru-yamayn wugurru, nguynju yadhu anaani ambani-lhajbini wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Na-Jesus niga ni-marrbuy aḏaba anaani wurraawanggini-yinyung wugurru. Anaani niga nu-magayn aḏaba nubagi-yung naarra-guṉḏa-guṉḏa-yinyung na-waḻyinyung, “Baaṉiyn ngayawi-wuy, nga yaaji ba-lhangang nagang.” Anubani ni-ḻaḻagiiyn, ni-jarrarriyn nga bagu ni-lhangayn nigawi-rruj. ");
INSERT INTO nuy_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Na-Jesus aḏaba anubani wani-magayn warruburru-wuy warra-mulung-aynbaj-guy, nga ni-yamayn, “Ngaya anaani ngana-yandhawiwanjii nugurri-wuy aḏaba. Anaani ana-lhaawu-runggal, wu-yaminggarrina yuga wu-yambina? Yuga anaani ngaambu-yaminggarrina ngarraagi-rruj ngarraaḻirr-maṉngulg? Yuga ngaambu-waṉbina maaḻamburrg, yagu ngaambu-waṉbina aladi? Yuga warrubawi-yung ngaamba-wiri-gang yagu warrubawi-yung ngaamba-ngawijgang?” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Anubani ni-warra-garranggaa wani-nani wugurru. Marri anubani-yung nu-yamijgayn nigawi-wuy na-waḻyinyung-guy, “Bawu-lharraalhijgang nugawi-nyinyung ana-waṉja.” Nga nigaayung niwu-lharraalhijgayn. Marri anubani-yung ana-marang ni-marang-maṉdhiiyn aḏaba ana-marang naagi-yung. ");
INSERT INTO nuy_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yagu warruburru-yung wugurraayung warra-wurru-wurruj wunu-wurrij-bang-bindiyung niga. Anubani aḏaba wuu-yambiynjini yuuguni, wuu-yanga-yanguynjini. “Yuga naagi ngaanu-yaminggarrijgang aḏaba niga?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Anubani-yumbaa niga ni-yanggi, niidadangi buguni ama-ṉuga-wuy. Anubagu aḏaba nu-yambini na-ninyarra-yung-guy na-God. Nga bagu aḏaba niga nu-yambini niwu-mal-dharrmi…yn, niga nu-yambini. ");
INSERT INTO nuy_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Yingga anubani-yung waabirrarra-bini aḏaba. Wanii-gaḏiyn warruburru-wuy wurru-marrbuy-maa-yinyung. Marri niga ni-wajbarini warraawurru-yung 12. Warraawurru-yung niga wani-mijguni wugurru, wirri-lhaawu-yarrijgini-yinyung wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Yaawurru-yung yigaj warru-mu-muwaj. Simon, nu-mayayn Peter, marri Andrew, na-nilharri-yung na-Peter-yinyung, James, marri John, Philip, Bartholomew, ");
INSERT INTO nuy_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew, Thomas, James na-niwiyayung na-Alphaeus-jinyung, Simon Peitriyat, ");
INSERT INTO nuy_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas na-niwiyayung na-James-inyung, marri Judas Iscariot, wurrugu marri naagi-yung anu-minbini niga na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Anubani-yung aḏaba, naagi-yung na-Jesus anubagala mana-ṉuga-wala wurraanggarra-ngu-dhirridangi niga. Wugurraayung bagu mulung-arrgi-yung wurru-marrbuy-maa-yinyung wurraarra-garra-lhi aḏaba aa-bayway-rruj, wunu-rangarrangi niga. Nga warraawurru-yung arraarrawindi bagu wurru-burri wunaa-garranggaa wunu-rangarrangi. Marri arraarrawindi anubani ana-lhal-aynbaj-gala-yinyung bagu wugurraayunggaj wurru-burri. Anubani-yinyung ana-lhal ana-Judea, marri anubani ana-Jerusalem-gala, marri wu-ridiynjini-yinyung ana-lhal a-Tyre marri a-Sidon-jinyung, wubani-yung yaga wu-lhal-ngu-burri-yinyung ama-lhagayag-duj. ");
INSERT INTO nuy_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Anubani-yung wuu-ngarra-balangi aḏaba bagu. Marri wunu-ngaynbandangi niga nguynju yadhu amburraawanggini, marri amburru-maṉdhini yungguyung wubani a-wudhangurrg-gala. Warruburru-yung warra-mulung-arrgi-yung wurraarra-waṉagaa aalaaladi-yinyung man.gurrg, wanggaabalguyungaa-yinyung wugurru. Marri anubani-yung aḏaba wurru-maṉdhini wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Warraawurru-yung warraarrawindi wunu-ngaynbandangi ambunu-waṉagaa niga, anaani yamba niwu-waṉagaa lhuḏ, wu-rabalangi nigawi-wala, marri yungguyung wugurru wani-maji-waa niga. ");
INSERT INTO nuy_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Na-Jesus ni-warranggayn warruburru-yung-guy wurru-marrbuy-maa-yinyung-guy. Wani-yamijgayn niga, “Nugurru aadanu nurraambalalari yamba, niga na-God naniigajij-majgaa aḏaba aadanu. Nugurru aḏaba nigawi-nyinyung aadanu warru-mandag. ");
INSERT INTO nuy_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Nugurru aadanu nurru-marryaadii-yinyung, na-God niga anaani-yung aadanu naniigajij-majgaa aḏaba. Wurrugu marri aḏaba anubanila, numburru-waḻarrang aadanu. “Nugurru aadanu nurru-ruguna-yinyung, na-God naniigajij-majgaa niga. Wurrugu marri aḏaba anubanila, numburru-ngarrmana nugurru.” ");
INSERT INTO nuy_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Na-Jesus naagi-yung ni-yambini-wugij wugurri-wuy. “Warra-wurru-wurruj-maynji nugurru nambambi-wurrij-bangana, yagu anubani-yung God niga-waj nambaniigajij-majgana nugurru. Warra-wurru-wurruj nugurru anubani-yung nambi-mayana, wurru-yamana, ‘Nurru-lhalmarr yamba nugurru.’ Marri anubani nambi-warra-yamawana marri nambiiladi-yamawana nugurru, yagu yamba nugurru aadanu ngayawi-nyinyung yamba aḏaba, ngaya yamba anaani na-Niwiyayung na-Wurrujung-jinyung. ");
INSERT INTO nuy_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Aadanilu-wala, anubani-yung numburru-waḻaaḻarrii aḏaba, marri numburru-wan.ngana aḏaba, nugurru yamba nurru-waḻaaḻarrii aadanu. Nugurru nani-yayn yamba runggal-windiyung bayarra anubanila anaarrwar-wala, ana-wumala-wala. Nguynju yaga warruburru-yung warra-miyn-ngambara-waj, warraa-gaṉbini warruburru-wuy wunaa-ja-jambini-yinyung na-God, warraa-gaṉbini wudani-yung-jii wugurru.” ");
INSERT INTO nuy_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Naagi-yung na-Jesus ni-yambini-wugij. “Yagu nugurru aadanu nurraambalal-windiyung, anubani-yung niga na-God nambaniimbulijgang nugurru aadanu. Marri aḏaba ana-bayarra danu nga nirri-waṉagana, wu-jadugiiyn aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Marri nugurru aadanu nurru-waḻarranjii-yinyung ana-marrya, anubani na-God niga nambaniimbulijgang aadanu. Wurrugu marri, nugurru aadanu numburru-marryaadii. “Marri nugurru aadanu nurru-ngarrmana-yinyung, anubani na-God niga nambaniimbulijgang aadanu. Wurrugu marri anubani numburru-ruguna, marri numburru-nyadii-windiyung aadanu. ");
INSERT INTO nuy_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Warruburru-yung-maynji warraarrawindi ambuu-yamana-maynji nugurru aadanu nurru-mamanunggu, yagu niga na-God anubani-yung nambaniimbulijgang nugurru aadanu. Warruburru-yung anu…bani-yunggaj wurru-yambini, ‘Anaani na-God-jinyung ana-lhaawu,’ wurru-yamaa, yagu waari, anubani-yung wurraawaḻangi wugurru. Yagu warruburru-yung yingga wugurraayung warra-miyn-ngambara, ‘Wurru-mamanunggu,’ wurru-yamaa, wugurri-wuy warruburru-yung-guy wurru-yamba-yambini-wuy.” ");
INSERT INTO nuy_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Na-Jesus naagi-yung niga ni-yambini-wugij. “Anaani ngana-magana nugurru aadanu nurraawanggina-yinyung, warrubawi-yung nurraabalguyungaynjina-yinyung nugurri-wuy, nugurru nambarraa-ḏamarr-ngu-burraa aadanu. Warrubawi-yung-maynji nambambi-wurrij-bangana nugurru, warrubawi-yung nambarra-man.galagana wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Warrubawi-yung-maynji ambunu-yandhawiwanjii-maynji niga na-God, nigawi-wuy, nguynju yungguyung anaaladi anggu-waṉiyn nugurri-wuy, nugurraayunggaj numbunu-yandhawiwanjii na-God, nguynju yadhu ‘bambaagajij-majgana yadhu wugurru.’ Warrubawi-yung ambu-waṉbina-yinyung anaaladi nugurri-wuy, numbunu-yandhawiwanjii na-God, ambani-maṉmani yungguyung warrubawi-yung. ");
INSERT INTO nuy_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Warrubawi-yung-maynji warraaynbaj ambi-ramarra-wadjang nagang, ngijang anubani-yung ba-ramarra-wiḻibiḻingiyn aadanu, ambi-ramarra-wadjang aaynbaj-gala ngijang. Warrubawi-yung-maynji ambii-jarina-maynji mana-yaaḻi, yagi ngijang warrubawi-yung barra-lhambu nagang, manubama-yung-maynji ngijang mana-wirrig ambii-jarina wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Warraaynbaj-maynji ambi-yandhawiwanjii nagang, warrubawi-yung bambiiyn. Warrubawi-yung-maynji ambii-jarina nugawi-wala, yagi warrubawi-yung barra-yandhawiwi, nimbii-gaagijgi nagang, yagi barra-yami aadanu.” ");
INSERT INTO nuy_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Naagi-yung na-Jesus ni-yambini-wugij niga. “Nambarra-maṉmani warra-wurru-wurruj, nguynju narra-ngaynbandii nambambi-maṉmani nugurru aadanu. ");
INSERT INTO nuy_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Warra-mulung-arrgi-yung nambi-ngaynbandii. Yuga warrubawi-yung narra-ngaynbandii bawi-yung-bugij? Waari anaani anggiij-mamaaḻang-magaa anaani-yung aḏaba. Wugurraayunggaj burru-yung warraalaaladi-yinyung wurru-yamana yingga aadanu, wiij-nguynju. Warruburru-yung wugurru warra-ngaynbandii warra-mulung-arrgi-yung-guy, warra-ngaynbandii-yinyung yagu wugurri-wuy wuu-yamana dani-yung. ");
INSERT INTO nuy_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","“Warrubawi-yung warra-mulung-arrgi-yung nambi-man.galagana nugurru. Nugurru-maynji nambarra-man.galagana warruburru-yung-bugij-maynji, waari aadanu anggiij-mamaaḻang-magaa anaani-yung. Wugurraayung warruburru-yung warraalaaladi wurru-yamana aadanu, wiij-nguynju yingga. ");
INSERT INTO nuy_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","“Marri nambarriiyii-maynji nugurru warruburru-yung-guy, nugurru aadanu yamba nurru-marrbuy nambarraa-gaagijgiyn, burru-yung-bugij, waari wugurru aadanu anggiij-mamaaḻang-magaa anaani-yung. Warruburru-yung warraalaaladi wurru-yamana aadanu, nguynju yadhu anubani-yung anggiij-gagiiyn aḏaba anubani-yung.” ");
INSERT INTO nuy_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Naagi-yung na-Jesus niga ni-yambini-wugij. “Nugurru aadanu nambarraa-ḏamarr-ngu-burraa warruburru-yung nambii-ḏiyaldhii-yinyung nugurri-wuy. Marri nugurru nambarra-man.galagana aadanu. Nambarriiyii nugurru warruburru-yung-guy warra-mulung-arrgi-yung-guy. Ari numburru-wijangayii nugurru numburru-yamana, warrubawi-yung yagi anubani nambii-gaagijgi nugurru, yagu wiiya aadanu, nambarriiyii wugurru. Aadanu nugurru-waj nga numburru-waṉbina. Niga na-God anubani nambaniiyn runggal-windiyung nambani-bayarra-gang aadanu. Nugurru aadanu nigawi-nyinyung warra-mijburrayung aḏaba, naagila anaarrwar-yinyung. Anaani yamba wugurru wiijamana, niga yamba anubani-yung ni-man.galag niga warruburru-yung wuu-ḻamumundhina-yinyung marri warruburru-yung warraalaaladi-yinyung. ");
INSERT INTO nuy_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","“Warrubawi-yung nambarra-man.galagana, marri nambarraagajij-garruna wugurru, nguynju anubani-yung niga naagila na-Baba anaarrwar-wala ni-yamana niga, ngarrani-man.galagana marri ngarraniigajij-garruna ngagurru.” ");
INSERT INTO nuy_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Naagi-yung na-Jesus niga ni-yambini-wugij. “Nugurru aadanu, yagi narra-lhajbu, na-God nani-lhajbu-magi nugurru. Nugurru aadanu yagi warruburru-yung narra-lhajbu wugurru. Nguynju yadhu niga na-God waari aadanu nani-lhajbu niga. Bani-yung nga nambarraagajij-garruna nugurru. Nguynju yadhu niga na-God aadanu nambaniigajij-garruna niga. ");
INSERT INTO nuy_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","“Marri anubani-yung nugurru nambarriiyii warra-mulung-arrgi-yung-guy. Nguynju nigaayung yadhu anubani-yung nambaniiyn, anaarrawindi windiyung aniij-mamaaḻang-jinyung, nguynju yaga anubani-yung anu-ḏal wugurru wu-ḏamadhan-mana ama-gaṉdharra-rruj yaga wu-burraa. Marri nima-jurii, niwu-waḏa-waḏaḏ-gana marri anubani nima-mani manubama mana-gaṉdharra marri nima-yaljalii, nga manubama-yung ma-lhaguḻaarrmani magurru. Marri niga anima-magayang, marri nambaniiyn ama-lharrbij-duj nugurri-rruj. Dani-yung nga, anggiijamana wugurru. Anubani-yung-maynji nambarriiyn, nugurraayung anubani-yung nambanii-gaagijgiyn na-God niga.” Ni-yamaa dani-yung niga, na-nidhaawu-yung na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Anaani-yung wani-magaa niga warraawurru-yung, wiij-bulawaa-wala. “Yuga niga nubagi-yung na-bagaḻang-aladi-nyung nubagi anaaṉa-ṉimana niga na-bagaḻang-aladi-nyung naaynbajung? Girrjag! Ari nubiṉi-yung wuguṉi ambini-rabina wubani a-gara-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","“Warruburru-yung wugurru wurru-marrbuy-mana-yinyung, yagi warruburru-yung wugurru wunu-magi nubagi-yung-guy wani-yiyina-wuy. Yagu wurrugu marri, amburru-marrbuy-mana-maynji ana-maaḻamburrg wugurru, bani-yung amburru-nguynju warruburru-yung-jii warra-yiyini-yinyung wugurru.” ");
INSERT INTO nuy_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Naagi-yung na-Jesus niga ni-yambini-wugij. “Yagu nugawi-nyinyung-maynji na-guwaj anaaban-binyig-maynji aniwu-waṉagana niga mana-bagaḻang-duj, yagu nagang banu-bagaḻang-nayii manubami nigawi-nyinyung mana-bagaḻang. Yagu waari nagang ba-marrbuy-mang aadanu nagang nunggu-waṉagana runggal-windiyung rangag nugawi-rruj mana-bagaḻang-duj! Marri yuga anubani-yung ba-yaminggarrang? ");
INSERT INTO nuy_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Marri a-yangi yungguyung nunu-yambina aadanu nugawi-nyinyung na-guwaj, ‘Guwaj, anubani-yung maadamu ngama-ngarrgiwang mana-mangarag nugawi-wala mana-bagaḻang-gala.’ Aadanu nuynjamana. Yagu yagi nagang nunggu-ni anubani ana-rangag nugawi-rruj wu-burraa mana-bagaḻang-duj. Nagang yamba aadanu nundaambaḻaman-gina windiyung! Ana-wulhu-wulhurr wurrugu bawu-ngarrgiwang nugawi-nyinyung-gala mana-bagaḻang-gala ana-rangag, nguynju yadhu baarranggana maaḻamburrg yadhu, nguynju anubani-yung bama-ngarrgiwang manubama mana-mangarag nugawi-wala na-guwaj-gala mana-bagaḻang-gala. ");
INSERT INTO nuy_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Anaani wiijamana. Anubani-yung ana-mamanunggu ana-rangag, anubani-yung ana-marrya-yinyung wu-burraa anubagu ana-rangag-duj, waari anubagu anaaladi anggu-burrangang anubani-rruj. Wugurraayung anubani anaaladi ana-rangag, waari anubagu ana-mamanunggu ana-marrya anu-ngugulmung anggu-gulmung-ngu-burri. ");
INSERT INTO nuy_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Anubani-rruj warra-wurru-wurruj wugurru wurru-marrbuy anubani-yung ana-rangag, aniga-yung ana-marrya anu-ngugulmung-jinyung. Yagi manubama-yung mana-maaṉbaaṉburru yagi anubagu ma-burrangi ana-rawurrumugurrumu-rruj. Marri yagi anubani-yung ana-wuyarrangaḻ yagi wu-burrangi anubagu mana-miḏaaburruburru-rruj magurru yigaj! ");
INSERT INTO nuy_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","“Warruburru-yung warra-mamanunggu-yinyung wugurru warra-wurru-wurruj warruburru wurru-mamanunggu-windiyung wugurri-rruj aandhiri-rruj. Marri anubani wurru-waṉbina aambaḻaman-jinyung wugurru. Yagu warruburru-yung warraalaaladi wugurru warra-wurru-wurruj, anubani anaaladi wu-burraa wugurri-rruj aandhiri-rruj. Marri anubanila-wala, wugurru wurru-waṉbina yij-galaaladi. Anubani anaarrawindi-lhangu nugurru nurru-wawanggina-yinyung nugurri-rruj aandhiri-rruj, bani-yung nugurru nurru-yambina, nugurri-wala ana-lhaguḻa-wala, anubani wugurru ambaḻaman yagu aladi.” ");
INSERT INTO nuy_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Naagi-yung na-Jesus niga ni-yambini-wugij. “Anubani-yung ngirri-mayana nugurru nurru-yamana ‘Buunggawa, Buunggawa’. Yagu a-yangi yungguyung yuga waari numburru-waṉbang anaani ngaya nga-yambina-yinyung? ");
INSERT INTO nuy_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Warraaynbaj-maynji warrubawi-yung ambu-yaarri ngayawi-wuy marri ambu-wawanggina ngayawi-nyinyung ana-lhaawu, anubani ngambambi-yandhurrbangana ngaya, anaani ngana-magana nugurru ambu-yaminggarrang aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","“Nguynju yaga nubagi-yung na-waḻyinyung, niga niwu-raani anubani ana-wumurrng. Anubani-yung niga ni-rigandi, niwu-maṉdhangi alagararij, marri anubani-yung nima-maṉdhangi ṉuga. Marri anubani-yung niwu-jadugayn niga ana-wumurrng aḏaba. Anubanila-wala aḏaba, ma-ḻaḻagiiyn ngugu, marri ambamadhiyn anubani-yung ana-wumurrng. Yagu anubani-yung ana-wumurrng waari wugurru anggu-wirbirini. Yagu anubani-yung yamba niwu-maṉdhangi-windiyung maaḻamburrg niga. ");
INSERT INTO nuy_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Yagu warraaynbaj-maynji warrubawi-yung ambu-yaarri ngayawi-wuy, arrbidi ari ambu-wawanggina-maynji ana-lhaawu, yagi-maynji warrubawi-yung ngambi-yandhurrbi ngaya, nguynju yaga nubagi-yung-jii yaga niwu-raani anubani ana-wumurrng aaban-duj yaga. Waari manubama-yung anima-burrangi mana-ṉuga ana-lhirribala. Marri manubama-yung mana-ngugu maarriyn, nga marri anubani-yung juriyn anubani ana-wumurrng wugurru. Anubani-yung lhugaajgiyalawaj anubani wu-rabini, nga anubani wu-burayiyn.” Dani-yung-galawaj ni-yambini na-Jesus, na-nidhaawu-yung niga, wani-magaa. ");
INSERT INTO nuy_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Na-Jesus aḏaba anubani-yung wani-magaa-yinyung ana-lhaawu, niwu-jadugayn aḏaba. Marri anubani-yung ni-yanggi yuuguni niga Capernaum-guy. ");
INSERT INTO nuy_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nubagi-yung wurrujung bagu niga ni-burri, Roman-jung wurrujung, wurru-wiynji-wiynjini-yinyung. Naagi-yung ni-runggal niga. Naagi-yung ni-buunggawa-maa warruburru-yung 100, warru-mandag, wugurru wurru-wiynji-wiynjini-yinyung. Naagi-yung niga nu-waṉagaa wurrujung, bagi-yung nga nu-yandhurrbangaa-yinyung. Nubagi-yung niga naa-ḏamarr-ngu-burri windiyung, na-wurrujung. Naagi-yung niga ni-lhangurrngandi windiyung, lhaalhag niga ani-ngawini aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nigaayung naagi-yung na-runggal-yung ni-wawanggini anubani-yung ana-lhaawu na-Jesus-inyung, wani-maji-waa-yinyung warruburru-yung warra-wurru-wurruj. Warraawurru-yung mulung-arrgi wugurru bagu mijiwanggu wurru-burri, Jew. Naadagi-yung niga wani-lharrgang buguni nga na-Jesus-guy. ");
INSERT INTO nuy_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Wurru-yanggi… nga bagu wunu-yandhawiwayn niga, “Baaṉiyn, ba-yaarri nga banu-maji-wang yungguyung nubagi nu-yandhurrbangana-yinyung niga na-runggal-yung-jinyung,” wurru-yamaa wugurru. Waadurru-yung warra-mijiwanggu wugurru naadagi-yung wunu-lhangayaani naagi-yung na-Jesus. “Nubagi-yung yamba niga na-runggal-yung niimbaḻaman, aadanu nagang banaa-gaṉbina nubagi. ");
INSERT INTO nuy_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Naadagu yamba niga ngarrani-ngaynbandii ngagurru anaani warra-Israel-inyung warra-wurru-wurruj. Anubani-yung niga niwu-maṉdhangi ana-wumurrng ana-synagog, ngagurraa yadhu.” Dani-yung wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nigaayung na-Jesus ni-ḻaḻagiiyn aḏaba wurraanggarra-yanggi wugurri-wuy. Aḏaba ni-yanggi niwu-warubaj-gaa anubani-yung ana-wumurrng. Naadagi-yung niga na-runggal-yung wani-lharrgang warraawurru-yung waḻya-waḻya, wurru-yanggi na-Jesus-guy. Anaani-yung wugurru wirri-lhaawu-yarrijgini ana-lhaawu, nigawi-wuy. Wurru-yamayn “Buunggawa, ngaya yagi anaani nimba-warubaj-gi nagang ngayawi-wuy, waari yamba ngaya anaani ngaṉḏunggal-magaa ngaya. Yagi nagang anubagala nuynjabi ngayawi-wuy anaani ana-wumurrng-guy. ");
INSERT INTO nuy_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Anaanila-wala, ngaya waari ngaynjanggi nugawi-wuy. Waari anaani ngaṉḏunggal-magaa ngaya. Anaani ba-yambina lhaawu-wugij, nga anubani-yung ani-maṉdhiiyn niga, nubagi-yung ngayawi-nyinyung na-guwaj. ");
INSERT INTO nuy_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","“Anaani ngaya yamba nga-marrbuy nagang, ngaya yamba na-nguynju nugawi-yii anaani. Yagu warruburru-yung wurru-buunggawa-mana-yinyung, anaani ngarra-yandhurrbangana ngaya. Yagu warruburru-yung wurru-wiynji-wiynjina-yinyung warruburru-yung ngambi-yandhurrbangana ngaya. Ngaya nganu-magana nubagi naaynjaabu-nyung-guy ‘Ba-yaarri,’ nubagi-yung ni-yaarri niga. Nubagi-yung ngana-magana naaynbajung ‘Baaṉiyn,’ nubagi-yung ni-yaarri ngayawi-wuy niga. Marri nubagi-yung ngani-yandhurrbangana-yinyung anubani-yung ‘Baaṉbang,’ marri anubani-yung nganii-gaṉbina niga.” Dani-yung ni-yamaa na-runggal-yung, ni-marrbuy yamba niga, nubagi na-Jesus niwu-waṉagaa lhuḏ-bindiyung. ");
INSERT INTO nuy_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nigaayung naagi-yung na-Jesus anubani-yung ni-waḻaaḻarriyn-bindiyung. Anubani-yung ni-wiḻibiḻingiyn niga, naagi-yung wani-magayn warruburru-yung-guy warraarrawindi wugurru wunu-ga-garri-yurangi-yinyung, “Ngaya anaani ngana-magana nugurri-wuy, waari ngaya anaaji ngamba-nani warra-wurruj nguynju naadagu-yung-jii ni-jambarrgiiyn-jii. Niga waari ani-Jew-magaa, yagu ni-jambarrgiiyn-bindiyung naadagi-yung. Wugurraayung warruburru-yung warra-Jew, warruburru-yung waari ngaya ngambambii-ngu-jambarrgini naadagi-yung-jii.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Warruburru-yung wugurraayung warra-waḻya-waḻya, nubagi-yung na-runggal-yung wani-lharrgandi-yinyung, aḏaba wurraagiyn wubani-wuy a-wumurrng-guy wugurru. Warruburru-yung-maynji wunu-nani nubagi-yung na-wurrujung. Anubani-yung aḏaba ni-maji-mayn niga. ");
INSERT INTO nuy_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wurrugu marri malgadhaadharri ngijang, anubani ni-yanggi na-Jesus aaynbaj-guy a-wumurrng-guy. Ana-muwaj wu-mayini Nain. Warruburru-yung wurru-marrbuy-maa-yinyung wurraanggarra-yanggi, marri wugurraayunggaj warruburru-yung garnyirrimba nga, wurraanggarra-yanggi anubuguni. ");
INSERT INTO nuy_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Anubani wuu-yanggi wubani-wuy a-wumurrng-guy wu-dhawang-guy. Wugurraayung warra-mulung-aynbaj warra-wurru-wurruj aḏaba anubanila wuu-ngarra-ḏaba-rabalangi wugurru. Naagi-yung wunu-warrgaay, ni-ngawiiyn, wurrujung. Naadagi-yung nga-rriibi-yung ngarra-ngajiwanggu-nyung na-ni-marayung, aynjaabu-nyung-bugij dagi-yung ngunu-yabayn. Ngaadagi-yung yamba ngiga ngi-ngayi. Warruburru-yung ana-wumurrng-gala anubani anu-dhawang-gala wugurru wurru-yanggi, wurraanggarra-yanggi ngiga. ");
INSERT INTO nuy_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Naagi-yung na-Buunggawa niga ngu-nayn. Ngarraagi-yung ngu-warrngayuyn-bindiyung. “Yagi nuṉḏugi nagang,” ngu-magayn. ");
INSERT INTO nuy_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ni-yanggi, nga anubani-yung niwu-wiḻdhiyn anubani-yung ana-baadhi. Warruburru-yung wugurru wunu-warrgaay-yinyung naagi-yung, wurru-lhangayn aḏaba. Nga ni-yamayn, “Wulmurr-inyung, nagang ba-ḻaḻagiiyn.” ");
INSERT INTO nuy_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nubagi-yung niga ni-ngawiiyn-jinyung ni-ḻaḻagiiyn, marri ni-yambiyn niga. Na-Jesus naagi-yung nu-miyn, nga ngaa-gaagijgiyn nga-rriibi-yung-guy aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Warraawurru-yung wurru-wurri-ḻaḻmayn-bindiyung wugurru. Wunu-warraarriwaa na-God-guy. “Naagi-yung niga na-runggal-yung naa-ja-jambina-yinyung, ni-rabaliyn-bindiyung aḏaba ngagurri-rruj,” wurru-yamayn. Marri, “Na-God niga aḏaba yaaji ni-burraa ngagurri-rruj, ngarrani-maṉmani ngagurru warra-wurru-wurruj nigawi-nyinyung,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Anaani-yung na-Jesus-inyung ana-lhaawu aḏaba wu-rajaarrangi anubani-rruj ana-lhal wu-lhal-wurraayung-baj anubani ana-Judea-waj, marri anubani ana-lhal-aynbaj-baj anubani wu-ridiynjini-yinyung ana-lhal. ");
INSERT INTO nuy_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nubagi-yung niga na-John, waniimbaambara-ngambijgaa-yinyung, bagu aḏaba ni-radbidhi niga. Warraawurru-yung nigawi-nyinyung wurru-marrbuy-maa-yinyung, bagu aḏaba wunu-magaa nigawi-wuy, ana-lhaawu na-Jesus-inyung. ");
INSERT INTO nuy_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Naawiṉi-yung wini-wulawaa wuguṉi wanii-gaḏiyn niga. Naagi-yung na-John wani-lharrgang wuguṉi na-Jesus-guy, wubani-yung a-lhaawu wunaa-jurangi nigawi-wuy. Ni-yamayn “Nugawaj yuga aadanu nimba-garrindharrmiyn-jinyung ngaya?” ni-yamayn na-John, “Aadanu yuga anubani-yung ngaya nga-yambini-yinyung marri ngarra-magaa-yinyung? Yagu ngaanaa-garranggana niga nubagi-yung naaynbajung?” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Naawiṉi-yung wuguṉi wini-yanggi na-Jesus-guy. Nga wini-yamayn, “Nubagi-yung na-John yaga waniimbaambara-ngambijgaa-yinyung anaani niiṉi nani-lharrgang nugawi-wuy. Yaani lhaawu ngunaa-jurangi nagang. Yuga nugawaj danu nundhamarriyn-jinyung nagang, na-John yaga ni-yambini-yinyung niga? Yagu nurru namba-rangarrii aynbaj?” wini-yamayn wuguṉi. ");
INSERT INTO nuy_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nigaayung naagi-yung na-Jesus wani-maṉmangi wugurru arraarrawindi wurru-wurruj. Warruburru-yung wurru-lhangurrngandi-yinyung, marri anubani wurraarragayangi-yinyung arraalaaladi-yinyung, marri anubani-yung ana-man.gurrg mawurr wurru-waṉagaa-yinyung, arraarrawindi wurru-bagaḻang-aladi-wini-yinyung. Wani-maji-waa niga marri wurraarranggaa aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nga naawiṉi-yung wani-yambalmayn aḏaba nubiṉi-yung-guy na-wulawaa-wuy, “Nimbiniigiyn nuguṉi, nga numbunu-magana na-John-guy, anubani-yung nuguṉi niiniwu-nani-yinyung marri niini-wawanggini-yinyung nuguṉi. Warruburru-yung warra-bagaḻang-aladi-yinyung wurraarranggaa wugurru. Warruburru-yung warraarra-wilwilwiluj-jinyung aḏaba wurru-yanggi. Marri warruburru-yung warraarraguṉḏa-guṉḏa warruburru-yung wurru-maṉdhini aḏaba. Marri warruburru-yung wurru-wan-mudangi-yinyung aḏaba warruburru-yung wurraawanggini wugurru. Marri warruburru-yung wurru-ngawini-yinyung, warruburru-yung wurru-ḻaḻagini aḏaba. Warruburru-yung warraambaambalalari-yinyung, warraawurru-yung wurraawanggini ana-mamanunggu ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Warrubawi-yung-maynji ngambi-yaynjangayii ngaya marri waari amburru-muḏaḏbang-jinyung wugurru, wurru-wuguuguni-wugij wuu-jambarrgina ngayawi-rruj, bawi-yung nga na-God niga waniigajij-majgana wugurru.” Dani-yung ni-yambini na-Jesus, ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Naawiṉi-yung winiwu-lhaawu-yarrijgini-yinyung, bagala aḏaba winiigiyn na-John-guy wuguṉi. Anubanila-wala, nigaayung naagi-yung na-Jesus wani-magaa aḏaba warruburru-wuy warraarrawindi nubagi-yung-jinyung na-John. Niga ni-yamayn, “Nugurru, a-yangi yungguyung yuga nurru-yanggi nugurru anubani ana-lhal-aṉḏarrg-guy? Yuga nimbirri-nani yungguyung a-maḏa wubani wu-maḏa-wirbirini yadhu? Girrjag nga! ");
INSERT INTO nuy_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Yagu a-yangi yungguyung yuga nurru-yanggi nugurru anubuguni nurru-nani? Yuga waḻyinyung naadagi-yung ni-yabini-yinyung yaaḻi-mamaaḻang mana-yaaḻi? Girrjag! Warruburru-yung wurru-yabini-yinyung magurru mana-yaaḻi-mamaaḻang, warruburru-yung yuga wugurru wurraambalal yamba? Yii! Marri warruburru-yung wugurru wurru-burri nubagi-yung-duj anga na-king-duj. ");
INSERT INTO nuy_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","“Marri a-yangi yungguyung yuga anubani nurru-yanggi nurru-nani nugurru? Yuga nubagi-yung niga naa-ja-jambini-yinyung na-God? Yuu! Naagi-yung yamba niga ni-runggal-windiyung, waari nguynju yaga warruburru-yung-jii wunaa-ja-jambini-yii yaga. ");
INSERT INTO nuy_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Anaani ana-lhaawu waarrarrina na-John-jinyung. Na-God ni-yamayn niga, ‘Ngaya anaani nganu-lharrganjii niga, bagi-yung nga nganii-dhaawu-yarrijgina-yinyung niga ana-raga-ragij nguynju yadhu nagang. Niga manubama-yung animaandhurrg-gana yungguyung nugawi-nyinyung-jinyung manaadi.’ Dani-yung na-God ni-yamaa niga, ni-yambini na-John-jinyung, anaani waarrarrina yamba a-wubiba-rruj.” ");
INSERT INTO nuy_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na-Jesus naagi-yung niga ni-yambini-wugij. “Ngaya ngana-magana nugurri-wuy, naagi-yung na-John ni-runggal-windiyung niga. Nguynju yaga warruburru-yung warra-mulung-arrgi-yung wurraambuḻwina yaga warruburru warra-mijbiibiyung-gala, waari ani-yamaa niga. Yagu warruburru warra-wurru-wurruj na-God-jinyung warru-mandag, warruburru-yung wurru-runggal-windiyung, waari naadagi-yung-jii na-John-jii, ambu-yamang.” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Wugurraayung warruburru-yung warra-wurru-wurruj marri warruburru-yung wirri-mundu-munduwaa-yinyung wugurru anu-ṉuga, “Na-God niga naadagu ni-maaḻamburrg!” wugurru wurru-yamaa. Niga yamba na-John naadagi-yung waniimbara-ngambijgaa yamba, anubani-yunggaj. ");
INSERT INTO nuy_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Yagu wugurraayung warruburru-yung warra-Pharisee marri warruburru-yung warra-marrbuy-waa-yinyung wugurru anubani ana-lhaawu-runggal, yagu anubani-yung niga na-God-jinyung wani-ngaynbandangi-yinyung, yagu wugurru anubani waari ambirriij-ngaynbandangi waadurru-yung. Waari anubani ambii-yarrijgini wugurri-wuy. Warraawurru-yung wugurru wurraaḻamin-jamaa, wugurru yamba wunaandirrangi niga na-John, yagu naagi-yung waari yamba ambaniimbara-ngambijgaa niga. ");
INSERT INTO nuy_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Na-Jesus niga ni-yamayn, “Ngaynjaminggarrang ngaya ngaynjamang nugurri-nyinyung aadanu warra-wurru-wurruj warraarrawindi-lhangu anaani ana-yimbaj? Nugurru nurru-yamana aḏaba aani-yung-jii. ");
INSERT INTO nuy_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Aadanu nguynju nugurru warra-mijburrayung-jii, nurru-yamana. Warruburru-yung yaga wurraambargalii wugurru wubani-rruj wurru-muṉḏugaynjina-rruj marri wurraa-gaḏijgaynjina wugurru, ‘Nurru-lhamurrangi-maynji naagi na-lhambiḻbiḻg yagu waari nugurru ngijang numburru-wan.ngaa! Nurru nurru-ruguni yagu nugurru waari numburru-ruguni aadanu!’ ");
INSERT INTO nuy_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Aadanu nugurru nuu-yamana nga. Nugurru nurru-marrbuy, naagi-yung na-John waniimbara-ngambijgaa-yinyung ni-waṉini nugurri-wuy. Malgarrawindi waari naagi-yung ani-nguni ana-marrya yagu ani-waḻ-nguni anu-gargayag niga. Ngijang nugurru aadanu nurru-yamaa aadanu, ‘Niga naagi niwu-waṉagana man.gurrg!’ ");
INSERT INTO nuy_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yagu ngaya anaani, na-Niwiyayung na-Wurrujung-jinyung ngaya, nga-nguyii marri ngaaḻ-nguyii yagu anaani ngaya. Nugurru nurru-yamana aadanu, ‘Ni-wandha-wuguuguni ni-nguyii marri ni-waḻ-nguyii niga marri ni-bungurru-dhina niga, marri warra-mijgalgur-yung warruburru-yung wirri-mana-mani-yinyung wuṉuga, marri warruburru warraalaaladi-yinyung, wurraalgurmaynjini niga.’ Danu nurru-yamana nugurru. ");
INSERT INTO nuy_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","“Yagu wugurraayung wurru-marrbuy-yinyung na-God-jinyung, wugurru wurru-marrbuy aniga-yung ana-maaḻamburrg.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Anubanila-wala, naagi-yung Pharisee-yung nga bagu wurrujung nu-yandhawiwandi niga, “Baaṉiyn, marri ba-nguyii ngayawi-rruj.” Anubani-yung ni-yanggi marri ni-yabiyn niga nigawi-rruj na-Pharisee-yung-duj. Marri ni-nguni bagu ana-marrya. Yagu ngarrubagi-yung ngarra-maṉinyung ngigaayung anubanila ana-wumurrng-gala, ngarraagi-yung ngiga ngiiladi-windiyung. ");
INSERT INTO nuy_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ngarraagi-yung ngi-wawanggiyn ngiga ana-lhaawu, anubani-yung na-Jesus niga bagu yamba ni-nguni nubagi-yung-duj na-Pharisee-yung-duj. Marri ngi-yanggi ngiga buguni. Manaama-yung wirrima-miyn mana-gaṉdharra ma-mamanunggu. Anubani-yung bagu wu-burri wumalagaj, wu-lhaguḻaarrmangi wugurru, arrawuj-mamaaḻang. ");
INSERT INTO nuy_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Anubani-yung ngiga ngi-jarrarriyn nga ngi-lhangayn a-mun-duj na-Jesus-duj. Marri anubani-yung ngiga ngi-ruguni. Anubani-yung ngi-ruguni-yinyung ngi-ba-dhililangi, nga anubani-yung ngunu-mun-jarrbini ru-mirri niga. Marri ngigawi-nyinyung-mirri mung-mirri, ngunu-mun-jarrbini niga. Marri anubani-yung ngiga ngunu-mun-dhawuynjaa. Marri anubani-yung ngunu-mun-baḻbini ngiga wugargayag-mirri. ");
INSERT INTO nuy_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Naadagi-yung niga na-Pharisee-yung ngu-nayn, nigaajbaj ni-yamijgini, “Naagi-magaa niga anaa-ja-jambini-yinyung-magaa na-God, naagi-yung niga ani-marrbuy-maa aḏaba, yangi-nyung ngarraagi ngarra-maṉinyung ngiga, anubani-yung ngi-waṉbaaṉbini-yinyung ngiga anaaladi, naagi-yung-magaa niga ani-marrbuy-maa aḏaba!” ni-yamijgini, ni-yamaa niga. ");
INSERT INTO nuy_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yagu nigaayung na-Jesus anubani-yung nu-yambalmayn, nga ni-yamayn “Simon, wa-magana lhaawu anaani.” Nigaayung ni-yamayn, “Yangi yuga anubani, nagang barra-marrbuy-wana-yinyung.” ");
INSERT INTO nuy_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Na-Jesus nigaayung ni-yamayn, “Naawiṉi wini-wulawaa waḻya-waa, naawiṉi ambunaa-gaagijgini wuṉuga wuguṉi nubagi-yung-guy naaynjaabu-nyung-guy na-waḻyinyung. Naagi naaynjaabu-nyung niga anaa-gaagijgini anubani-yung wugurru anu-ṉuga 500. Niga nubagi-yung naaynbajung nigaayung 50. ");
INSERT INTO nuy_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Naawiṉi-yumbaa wuguṉi waari ambunaa-gaagijgini, waari yamba ambiniwu-waṉagaa anu-ṉuga wuguṉi. Yagu nubagi-yung niga naaynjaabu-nyung niga waniigajij-garruyn. Naawiṉi-yung na-wulawaa nga, ajiga-yung-jinyung niga nu-ngaynbandangi ana-runggal, nubagi-yung naaynjaabu-nyung?” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nigaayung na-Simon ni-yamayn, “Ari bagi-yung nga, naagajij-garruyn-jinyung niga ana-runggal,” ni-yamayn. Nigaayung na-Jesus ni-yamayn, “Aadanu nagang numbijangani-yinyung, wiij-maṉdhiiyn, yagu wiij-gandhurrg aḏaba,” ni-yamayn nubagi-yung-guy. ");
INSERT INTO nuy_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Anubani-yung ni-wiḻibiḻingiyn niga, ngarrubagi-yung-guy ngarra-maṉinyung-guy, nga nu-magayn na-Simon-guy, “Nungu-nayii ngarraagi ngarra-maṉinyung? Ngaya anaani-yung nga-yanggi nugawi-wuy ana-wumurrng-guy, yagu anubagu waari ngaya nimba-mun-jarrbini nagang, ngayawi-nyinyung ana-mun, anaa-gugu-mirri. Yagu ngiga ngangi-mun-jarrbini ru-mirri. Marri ngangi-mun-jarrbini ngigawi-nyinyung mung-mirri. ");
INSERT INTO nuy_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nagang waari nimba-bilhargaa ngaya, anubani-yumbaa nga-yanggi nugawi-wuy, yagu ngiga ngi-wuguuguni-wugij ngarraagi ngangi-mun-dhawuynjana ngiga. ");
INSERT INTO nuy_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Yagu nagang waari bawu-burrangi anubani-yung anu-gargayag ngayawi-wuy ana-yinag-guy. Yagu ngiga ngi-wuguuguni-wugij ngiwu-burrangi ana-malagaj ngayawi-rruj ana-mun-duj ngiga. ");
INSERT INTO nuy_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","“Anaanila-wala ngunu-magana nagang, anaanila-wala aḏaba ngarraagi ngi-warrbidi ngi-burraa ngiga, anubanila anaaladi-wala anaarrawindi-yinyung. Ngarraagi yamba ngiga ngangi-ngaynbandii runggal-windiyung. Yagu warrubawi-yung-maynji wugurru ambu-warrbidi-mang-maynji anubani anaaladi wugurru winyig wirri-waṉagana, yagu warrubawi-yung ngambambi-ngaynbandii ngaya winyig.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ngarrubagi-yung ngu-magayn niga ngarra-maṉinyung-guy, “Nagang aḏaba nundaarrbidi anaaladi-wala,” ni-yamayn ngigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Warruburru-yung warra-mulung-arrgi-yung wurraanggarra-nguni-yinyung ana-marrya anubagu, warruburru-yung wurru-yambiynjini wugurraajbaj-balij. “Yangi-nyung yuga naagi, waniigajij-garruna-yinyung anaaladi niga?” wurru-magaynjini wurru-yamaa. ");
INSERT INTO nuy_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yagu ngarrubagi-yung ngu-magayn ngarra-maṉinyung-guy, nga ni-yamayn, “Nagang aḏaba aadanu nu-ngu-jambarrgiiyn. Aadanila-wala aḏaba God aadanu niga nini-wiri-gayn nagang. Ba-yaarri aḏaba nagang, ba-lhamaamura,” ngu-yamijgayn dani-yung niga. ");
INSERT INTO nuy_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wurrugu marri anubani-yumbaa malgadhaadharri, anubani-yung naagi-yung na-Jesus ni-yanggi aaynba-gaynbaj-baj anga, a-lhal-wurraayung-baj. Niwu-rajaarrangijgaa wugurru ana-lhaawu. Anaani-yung wani-magaa warruburru-yung-jinyung wuu-jambarrgini-yinyung na-God-jinyung warru-mandag. Warruburru-yung warra-12 bagu wurraanggarra-yanggi warraawurru-yung. ");
INSERT INTO nuy_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Marri mulung-arrgi-yung maṉaṉung wugurraayunggaj wurraanggarra-yanggi. Wani-maji-waa wugurru wubani-yunggaj. Warraawurru-yung wugurru wuu-lhangurrngandi marri wirri-waṉagaa man.gurrg, anubani-yunggaj wugurru. Bagu ngarraagi-yung ngarra-Mary, ngarra-ngarrimuwaj-jung ngiga ngi-mayini Magdalene. Ngarraagi-yung marang-aynjaabugij marri wulawaa ngi-waṉagaa anubani ana-man.gurrg wu-burri ngigawi-rruj, anubani nginggaarruyn, anubani-yunggaj nga aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Marri ngarraagi-yung aynbajung ngijang Joanna, ngarra-ngarrimuwaj-jung. Ngarraagi-yung naaṉngina-yung niga na-nimuwaj-jung ni-mayini Chuza. Naagi-yung naa-mijgalmini-yinyung niga na-Herod. Marri bagu ngarraagi-yung ngarra-ngarrimuwaj-jung Suzanna. Marri bagu warraawurru-yung warraarrawindi warra-maṉaṉung wurraanggarra-yanggi, wugurraayunggaj bagu warra-rangarrangi nigawi-nyinyung-jinyung wurru-marrbuy-maa-yinyung marri na-Jesus. Warraawurru-yung wugurru wirri-waṉagaa wuṉuga, yagu warriini aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Warraawurru-yung arraarrawindi wurru-wurruj anuwagala wurru-waliyn. Warraawurru-yung a-lhal-waynbaj-gala-inyung a-lhal warraawurru wurru-yanggi anubuguni. Anaani-yung na-Jesus wani-magaa wu-miḏaamimi-yinyung wugurru ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Nga ni-yamayn, “Nubagi-yung na-waḻyinyung ni-yanggi, ni-wanuynjungaa anu-ḏal. Marri ni-ral-yarraani. Anubani ana-mulung-aynbaj waadbarrwini amubama-waj amaadi-waj. Nga warra-wurru-wurruj anubani-yung wuu-yanggi-magaa marri wuu-ral-wan.ngaa wugurru. Marri anubani ana-ngurudhu wu-wilbilangi marri wu-ngarra-ḏalhangi marri arra-nguni anu-ḏal. ");
INSERT INTO nuy_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","“Anaarrgi-yung anu-ḏal waadbarrwini ama-ṉuga-waj. Anubani-yung wu-warradangi, yagu waal-murrmbulangi aḏaba. Waari yamba anubagu anaa-gugu, waabaṉḏaaṉḏarrg yamba wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","“Ana-mulung-aynbaj wugurru anubani-yung anu-ḏal waadbarrwini a-rawurrumugurrumu-rruj. Anubani-yung anu-bal waarradangi. Anubani wugurraayunggaj wu-wal-warradangi ana-rawurrumugurrumu ngijang wu-waliynjini. Marri anubani-yung al-waabaabaa. ");
INSERT INTO nuy_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","“Anubani-yung ana-mulung-aynbaj anubani-yung waadbarrwini nga wu-warradiyn anuwaagu anaaban-mamaaḻang-baj. Marri anubani-yung wu-warradangi marri wu-gulmung-jungini, ana-mulung-arrgi anubani wu-maṉdhini 100 anu-ḏal anubanila-wala aynjaabugij wugurru.” Na-Jesus naagi-yung ni-yambini-wugij. “Nugurru-maynji numburraan-bawalhang aadanu, marri anubani-yung numburraawanggina windiyung nugurru!” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Wurrugu warraawurru-yung wurru-marrbuy-maa-yinyung wunu-yandhawiwandi niga, “Aadanu yuga ana-lhaawu, wu-yaminggarrina wugurru?” ");
INSERT INTO nuy_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nigaayung wani-yambalmayn nga ni-yamayn, “Nugurraajbaj aadanu, nirri-waṉagana anaani ana-bayarra, na-God-gala. Anaani ngana-magana nugurri-wuy aḏaba, nguynju yadhu anubani-yung numburru-marrbuy anubani-yung aniiyn-miḏaamimi-yinyung, warruburru-yung-jinyung warru-mandag nigawi-nyinyung na-God-jinyung aḏaba. Yagu warruburru-yung warra-mulung-aynbaj anubani-yung amburraawanggina-maynji anaani-yung aniij-miḏaamimi-yinyung ana-lhaawu-wugij, yagu anubani waari wurraawanggi wugurru, wiijaminggarrina-yinyung. Anaani wiijamana, ana-wubiba waarrarrina, ‘Anubani amburraarranggana amburraarra-nayii, yagu waari wurru-marrbuy-mi wugurru. Yagu anubani amburraawanggina-windiyung yijgubulu-windiyung, yagu waari anubani wurru-marrbuy-mi-windiyung.’” ");
INSERT INTO nuy_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Na-Jesus niga ni-yambini-wugij. “Yaani-yung yigaj aniij-bulawaa-wala wiijamana. Anaani anu-ḏal, anaani wiijamana, yaani-yung nga ana-lhaawu na-God-jinyung. ");
INSERT INTO nuy_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Warruburru-yung warra-wurru-wurruj nguynju yaga amaami-yung-jii amaadi-yii, warruburru-yung wurraawanggina anubani ana-lhaawu. Yagu nigaayung na-baḏirrnya-yung anuwagala ni-yaarri, anubani-yung niwu-yarina anubani ana-lhaawu wugurri-wala. Nguynju yadhu waari yungguyung wuu-jambarrgi, marri waari wanggu-maṉmi yungguyung wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Wugurraayung warruburru-yung warra-mulung-aynbaj nguynju yaga ama-ṉuga-yii wurru-yamana, anubani wurru-wawanggina ana-lhaawu, marri wirri-ngaynbandii, wurru-waḻaaḻarrii, yagu waari-windiyung, nguynju yaga anubani ana-rangag waari-yinyung anu-ngujang, waari wu-warradi ana-rangag. Yagu warruburru-yung waari amburru-jambarrgang-bindiyung, Nubagi-yung-maynji na-baḏirrnya-yung nigaayung ni-yaarri wanii-dhangu-jujurii, warruburru-yung amburru-yarramana, amburru-lhuṉdhii wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Anubani-yung waadbarrwini yaga ana-rawurrumugurrumu-rruj, anaani wiijamana, warra-wurru-wurruj warruburru-yung wurru-wawanggina ana-lhaawu. Anubani-yung wurru-yaarri wugurri-waj, yagu anubani-yung-maynji aniij-gaynbaj amburraalharaguna, anubani-yung wu-yaal-aḏaaḏigaynjina. Marri wirrii-ḏamarr-ngu-burraa anaambalal. Anubanila-wala aḏaba wu-ngarina ana-lhaawu. Yagu anubani-yung waari wu-lharang-mi anu-ngugulumung. ");
INSERT INTO nuy_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Wugurraayung anu-ḏal wu-rabina-yinyung anaaban-mamaaḻang-baj, anaani wiijamana, warruburru-yung warra-wurru-wurruj wurru-wawanggina-yinyung ana-lhaawu, marri wuu-jambarrgina-windiyung wugurru, yagu wurraambaḻaman ana-lhirribala wugurri-rruj. Marri wurru-waṉbina yij-mamaaḻang-galawaj wugurru. Warraawurru-yung waari wurru-lhuṉdhi yamba wugurru. Nguynju yaga wubani wu-warradii yaga a-marrya, waṉagana yaga wungugulmung.” ");
INSERT INTO nuy_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Na-Jesus naagi-yung ni-yambini-wugij niga. “Nugurru aadanu waari wu-lhalmbaarrii-yinyung anubani-yung nirri-burri manubama-wuy mana-gaṉdharra-wuy, marri nirriimbamadhi aadanu. Yagu nugurru anuuguni nirri-julubi ana-lhirribala wugurru amubami-rruj ama-yaaḻi-rruj. Yagu nugurru anubani nimbirri-burrang yuwaagu arrwar, anggu-wudhaa wugurru. Nguynju yadhu warrubawi-yung warra-wurruj wugurraayung anuwagala ambu-yaarri-maynji nga ambirri-nayii anubani anggu-lhalmbaarrii yuwaagu arrwar, anggu-wudhaa wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Yagu waari warraaynbaj warrubawi-yung anubani-yung-maynji waari wu-warra-ngu-julubi anubani warra-wuguuguni-mi wugurru. Wurrugu marri, warrubawi-yung ambu-yaarri marri nga ambarra-bajiyina warruburru-yung-guy warra-mulung-arrgi-yung-guy aḏaba. Waari warraaynbaj wugurru warra-wurruj wirriij-mamarri wuguuguni-mi wugurru. Wurrugu marri anubani-yung, ambarra-magana warruburru-yung-guy warra-mulung-arrgi-yung-guy. ");
INSERT INTO nuy_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Gurruwaj, anubani-yung numburraawanggina-maynji ana-lhaawu na-God-jinyung, numburru-dhi-maṉdhina aḏaba. Nugurru numburru-marrbuy-yinyung anaani, anubani-yung God nambaniiyii nugurru, nguynju yadhu anubani numburru-marrbuy-wina windiyung nugurru. Yagu nugurru waari-yinyung numburru-marrbuy-mang-jinyung aadanu, yagu nugurru nurraaḻamin-jamana nurru-marrbuy, yagu aadanu na-God aniwu-yarina niga nugurri-wala.” Dani-yung ni-yamaa ana-lhaawu na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ngarrubagi-yung nga-rriibi-yung marri warruburru-yung warra-minilharri-yung, wurru-yanggi buguni na-Jesus-guy. Yagu warraawurru-yung yamba arraarrawindi wurru-wurruj aḏaba wunu-dhawawarumayn niga, waari niga ambunu-yambini. ");
INSERT INTO nuy_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Yagu arrgaarrgi-yung wunu-yambini wugurru, “Nagang nga-rriibi marri warra-minilharri, durru wurraarra-garra-lhara aarabarabalu-rruj. Nagang aadanu ambi-yambina,” wunu-yamijgayn nigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yagu nigaayung wani-yambalmayn niga, “Warrubawi-yung-maynji ambi-yaynjangayii-yinyung na-God-jinyung ana-lhaawu marri ambi-yandhurrbangana, burru-yung aḏaba ngaya nga-rrigang-gaang marri naa-murruyung-gaang marri ngaa-murruyung-gaang.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wurrugu marri anubani-yung malgadhaadharri, ni-yanggi ama-barrawu-wuy. Warraawurru-yung wurraanggarra-yanggi wugurru, warruburru wurru-marrbuy-maa-yinyung. Wani-magayn bagu, “Ngaambu-yaarri wagagala-wuy a-wurugu,” ni-yamayn. Anubani-yung wugurru wuu-ngarra-jabaynjiyn aḏaba, ");
INSERT INTO nuy_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","aḏaba wurru-warrgang wagagala-wuy. Yagu naagi-yung niga ni-yingayn na-Jesus. Wurru-waya-wayamangi… nga yingga anubagu ana-bandharra. Wu-yanggi anuwaagala anubani wuwalulu wu-waḻadhi. Anubani-yung wanggu-miyn bandharra. Anubani-yung maar-yabaynjini. Manaama-yung aḏaba lhaalhag ma-gayn-ngambini, marri lhaalhag ma-ngambini aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Warraawurru-yung wugurru wurru-wuwaḻgayn marri bagu wunu-marayanggaa. Wurru-yamayn wugurru, “Buunggawa! Buunggawa! Aḏaba anaani ngaambu-ngambang!” Yagu nigaayung naagi-yung na-Jesus ni-ḻaḻagiiyn, marri anubani-yung ana-wudhanguyn niwu-yambiyn, marri wu-muḏaḏbiyn. Marri wugurraayung anubani-yung anaa-gugu niwu-yambiyn, marri wu-muḏaḏbiyn. Anubanila-wala wurraarranggayn, aḏaba waar-yingayn. ");
INSERT INTO nuy_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Anubani-yung wani-magayn wugurri-wuy, “Yuga nugurru waari aadanu numbuu-jambarrgini?” Yagu warraawurru-yung wunu-yamayn-bindiyung wugurru. Warraawurru-yung wurru-ngulu-ngulu-yambini bagu wugurraajbaj-balij, “Yagu yangi naagi ni-waṉbini aniij-mamaaḻang niga?” wurru-yamaa. “Yangi-nyung yuga naagi niga? Anubani-yung niwu-magayn anaani-yung ana-wudhanguyn ana-lhaawu-mirri, wu-muḏaḏbiyn marri niwu-magayn anaani-yung anaa-gugu, wugurraayung wu-muḏaḏbiyn!” Dani-yung wurru-yamaa wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Anubanila-wala wurru-warrgang wurru-wayamangi wagagala aḏaba wurraadadiyn. Anubani ana-lhal wu-mayini Gerasa. Aadanu ana-Galilee wagagala wu-lhal-ngu-burri, wugurraayung aadanu ana-lhal ana-Gerasa yaajijili. ");
INSERT INTO nuy_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Anubani-yung ni-garrajiyn manubama mana-barrawu-wala, naagi-yung waḻyinyung anubani-yung-jinyung ana-lhal, ni-yarbiyn buguni, nu-raganmayn niga. Naagi-yung niwu-waṉagaa niga man.gurrg. Naagi-yung anu…bani-yunggaj waari mana-yaaḻi manubama-yung ani-yabini niga. Waari anubagu ani-burri ana-wumurrng-duj. Naagi-yung niga ni-bu-burri amubama-rruj ama-gara ama-ṉuga-rruj. ");
INSERT INTO nuy_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Nga naagi-yung nu-nayn na-Jesus. Yuwaagala-walawaj ni-wayamangi daji niiḏangi. Ni-wayamangi-wugij nga ni-rabini raga-ragij nigawi-rruj a-mun-duj. Yagu nigaayung na-Jesus anubani-yung ni-yambini anubani-yung ana-man.gurrg, nga “Ba-rabalang,” ni-yamayn wugurri-wuy. Malgarrawindi yamba naagi-yung ninggu-bilhargaa, ninggu-waḏa-waḏaḏ-gaa niga. Warraawurru-yung warra-wurru-wurruj wunu-rangarrangi-yinyung, marri wunu-radbini niga, ana-chain-mirri, marri anubani-yung ana-dhuduju, wugurru wirri-burrangi anubuguni, wii-dhabiḏbini. Yagu anaani-yung niwu-wagiwaa-wugij niga. Yagu anubani-yung ana-man.gurrg anaani-yung ninggu-mangi-magaa marri yuuguni ninggu-yarini-magaa wubani-wuy a-lhal-aṉḏarrg-guy. Naagi-yung niiḏangi yanggarrwar-mirri, “Yagu a-yangi yungguyung nagang anubagala nimba-warubaj-gayn ngaya Jesus, na-niwiyayung na-God-jinyung ni-burraa-yinyung nuwaagi anaarrwar? Ngaya anaani ngunu-yandhawawanjii, yagi ngaya nimbaarragayangijgi aadanu!” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nigaayung na-Jesus ni-yamayn nu-yandhawiwandi nigawi-wuy, “Yangi-nyung yuga nagang aadanu na-nimuwaj-jung?” “Ngaya-waj anaani na-nimuwaj-jung ‘arrawindi’, dani-yung nga ngaya ana-muwaj.” Dani-yung ni-yamayn, niga yamba ni-waṉagaa arrawindi man.gurrg. ");
INSERT INTO nuy_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Anaani-yung ana-man.gurrg ninggu-yandhawiwandi na-Jesus-guy. Wu-yamayn, “Yagi nurru nimba-lharrgi anuuguni nuu-rabali anaalagarararij-guy ana-mamar-wuy.” ");
INSERT INTO nuy_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Wugurraayung arrgi-yung yuwaagu bigi-bigi ngunu-nguni wagagala. Anubani ana-man.gurrg ninggu-yandhawiwandi wugurru na-Jesus, “Nagang buguni nimba-lharrgang wuwaanila-wuy a-bigi-bigi-wuy,” wu-yamayn. Nigaayung “Yuu aḏaba, numburru-yaarri,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Anubani-yung wu-ngarra-ḏaba-rabaliyn nubagila-wala na-waḻyinyung-gala, aḏaba yuuguni wu-ngarra-janggi wubani-yung-guy wu-mulung-galiynjiyn aḏaba. Anubani-yung bagala nga waagulhaynjiyn yuuguni a-dhirridhirrig-guy marri wu-ngarra-ngalbawaḻgayn wubani-wuy aa-gugu-wuy. Marri anubani-yung wu-warra-ngaṉḏini wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bagu warruburru-yung warra-waḻya-waḻya wurru-ranga-rangarrangi-yinyung anubani-yung ana-bigi-bigi. Warruburru-yung wurru-nani, wuu-yarramayn nga yuuguni warra-magaa warra-mulung-aynbaj-guy, wubani-wuy a-wumurrng-guy wubani a-runggal, marri yuuguni a-lhal-aynbaj-guy a-lhal. ");
INSERT INTO nuy_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Wugurraayung wurru-yanggi arraarrawindi marri wurraarra-nani. Warraawurru wuu-yanggi buguni na-Jesus-guy nga bagu wunu-lhangarrmaa naagi-yung na-waḻyinyung. Anaani ana-man.gurrg aḏaba ninggaarruyn nigawi-wala. Naagi-yung ni-burri niga a-mun-duj na-Jesus-duj, niindhadhi. Ni-yabini yaaḻi aḏaba, nigawi-nyinyung-duj a-yinag anubani-yung wu-wandhurrg aḏaba, ni-wijangani-yinyung niga. Warraawurru-yung wunu-nani-yinyung niga naadagi-yung, wurru-ḏirrngawiiyn wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Warruburru-yung warra-mulung-arrgi-yung warra-wurru-wurruj wunu-nani-yinyung, warraawurru-yung warra-magaa wugurru, anubani-yung ni-waṉbini-yinyung niga naagi-yung na-Jesus. Anubani-yung naa-garra-raba-rabalini niga anubani ana-man.gurrg-gaang, marri naagi-yung nu-maaḻamburrg-gayn-jinyung. ");
INSERT INTO nuy_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Wudani-yung-gala wugurru, warruburru-yung warraarrawindi-lhangu anubani-rruj-jinyung ana-lhal, wugurru wurru-ḏirrngawiiyn-bindiyung, wunu-yamayn niga na-Jesus. Marri wunu-yandhawiwandi niga, “Numbuu-yaarri aḏaba nurri-wala,” wurru-yamayn. Yagu nigaayung na-Jesus anubani ni-wawanggiyn aḏaba ni-yanggi, ni-yabaynjiyn ama-barrawu-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nigaayung naagi-yung na-waḻyinyung anubani-yung ana-man.gurrg-jinyung niwu-waṉagaa, naagi-yung bagu nu-yandhawiwandi na-Jesus-guy, “Yuga ngaya anaani ngaynjaarri nugawi-wuy?” ni-yamayn. Yagu nigaayung na-Jesus naagijgiyn. Ni-yamayn, ");
INSERT INTO nuy_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Baagiyn nagang nugawi-wuy aanga-wuy,” nu-yamijgayn. “Anaani bamba-magana bamba-marrbuy-wana anubani-yung na-God-jinyung ninii-gaṉbini-yinyung nugawi-wuy.” Dani-yung ni-yamayn. Nigaayung na-waḻyinyung niigiyn, marri nu-yandhurrbang, ni-yanggi bagu wani-magaa warruburru-yung warraarrawindi-lhangu-wuy, anubani-yung naa-gaṉbini-yinyung na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nigaayung na-Jesus marri warruburru-yung wurru-marrbuy-maa-yinyung, wirringa-ḻaḻagayn ngarrubagi-yung ngaa-dhumbala, marri wurru-warrgang wagagala-wuy. Wurru-wayamangi… wurru-waliyn aḏaba. Warruburru-yung arraarrawindi wurru-wurruj bagu wunu-rangarrangi niga. Wurru-yanggi buguni wurru-waḻaaḻarrangi wugurru, nigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Naagi-yung niga na-nimuwaj-jung na-waḻyinyung, ni-mayini Jairus. Niga-waj yamba nga dagi-yung ni-ragaani ana-synagog-duj, niga ni-bu-burri-yinyung. Naagi-yung ni-yarbiyn, nga ni-ḻandharrdhangayn nigawi-rruj a-mun-duj na-Jesus-duj. Marri anubani-yung nu-yandhawiwandi niga, “Baaṉiyn aḏaba, ba-yaarri ngayawi-wuy aanga-wuy,” ni-yamayn niga. ");
INSERT INTO nuy_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Naadagi-yung niga ngu-waṉagaa ngarra-ngarriwiyayung aynjaabu-nyung-bugij niga. Ngarraagi-yung ngiga 12 anaagalhal-aḻirr-inyung. Ngarraagi-yung lhaalhag aḏaba angi-ngawini ngiga. Nigaayung naagi na-Jesus ni-yanggi. Warraawurru-yung wuniiyn.guḻabaabaa naagi-yung niga na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Yagu bagu ngarraagi-yung maṉinyung ngigaayung ngi-yanggi bagu. Anubani-yunggaj ngarraagi-yung ngiga nginggu-lhangarrmayn wulang ma-dhi-dhililangi ngigawi-rruj. Anaani-yung anaagalhal-aḻirr 12. Warraaynbaj waari ngarraagi-yung ambirringa-maji-waa ngiga. ");
INSERT INTO nuy_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ngarraagi-yung ngunu-ga-garri-yurangi, bagu ngi-yanggi na-Jesus-guy. Yuwaagu nga ngima-dhi-baṉagayn, nigawi-nyinyung mana-yaaḻi, ni-yabini-yinyung. Manubama-yung nga lhugaajgiyalawaj mana-wulang ma-muḏaḏbiyn, ma-jadugiiyn. ");
INSERT INTO nuy_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Na-Jesus wani-magayn, “Yangi-nyung ngaya ngambi-wiḻdhiyn anaani?” Warruburru-yung warraarrawindi wurru-yamaa “Waari nurru anaani!” Nigaayung na-Peter ni-yamayn, “Buunggawa, warraawurru arrawindi yigaj nimbi-dhagaaguramayn nagang aadanu, warra-wurru-wurruj, wuu-juriynjina wugurru,” ni-yamayn niga, nu-yamijgayn. ");
INSERT INTO nuy_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nigaayung na-Jesus ni-yamayn, “Girrjag! Aynjaabugij wurruj ngambi-wiḻdhiyn ngaya anaani. Nga-marrbuy ngaya, ngayawi-nyinyung-gala ana-lhuḏ aḏaba wu-yanggi,” ni-yamayn niga. ");
INSERT INTO nuy_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ngarraagi-yung ngi-marrbuy ngarra-maṉinyung, ngarraagi-yung waari angi-wij-mamarrangi ngiga. Ngarraagi-yung ngi-rabaliyn, marri ngi-warra-galalangi ngiga, ngiimbuliyn-bindiyung. Nga ngi-yanggi nga ngi-rabini raga-ragij nigawi-rruj na-Jesus-duj. Ngarraagi-yung ngunu-magaa aḏaba, ngi-yaminggarrini-yinyung anubani-yung ngunu-yaaḻi-waṉagayn-jinyung. Warraawurru-yung warra-wurru-wurruj bagu wurraarra-garra-lhi wirringa-yaynjangani, ngunu-magaa-yinyung ngiga. Anaani-yung ngi-yamayn ngiga, “Anaani-yung lhugaajgiyalawaj-gaj aḏaba ngaya nga-maji-mayn anaani,” ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nigaayung ngu-magayn ngigawi-wuy, ni-yamayn “Ngarriiyi, nagang yamba nu-ngu-jambarrgiiyn ngaya, aadanu aḏaba nu-maṉdhiiyn nagang aadanu. Ba-yaarri aḏaba, ba-lhamaamura,” ngu-magayn ngigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Anubani-yung ni-yambini-wugij, nga aynjaabu-nyung waḻyinyung bagu ni-rabaliyn yuwaagala wubani-yung-gala aanga nubagi-yung-jinyung na-waḻyinyung ni-ragaani-yinyung. Nga anubani-yung nu-magayn niga, nubagi-wuy ni-ragaani-yinyung, nga ni-yamayn, “Nugawi-nyinyung ngarra-ngarriwiyaay aḏaba ngiga ngi-ngawiiyn. Aḏaba yagi nunu-yandhawiwu nigawi-wuy wani-yiyina-yinyung,” ni-yamayn na-waḻyinyung niga. ");
INSERT INTO nuy_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Na-Jesus nigaayung ni-wawanggiyn anubani ana-lhaawu. Nigaayung nu-magayn, ni-yamayn, “Yagi nu-ngu-ḏirrngawi. Anaani nimbaa-ngu-jambarrgiiyn ngaya, marri ngaadagu angi-maṉdhiiyn aḏaba,” ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Anubani-yung ni-yanggi wubani a-wumurrng-guy. Warraawurru-yung wugurru wurraanggarra-yanggi anubuguni ana-wumurrng-guy, yagu waari niga ambani-lharrgandi wugurru amburraanggarra-yabini nigawi-wuy. Durru-yung-bugij wurraanggarra-yanggi Peter, John marri James. Marri rriibi-yung marri ninyarra-yung-bugij, ngarrubagi-yung-jinyung ngarra-ngaḻaynjinyung-jinyung, wurru-yabiyn anubuguni. ");
INSERT INTO nuy_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Warruburru-yung ana-wumurrng-duj wuu-ruguni… wurraaḏangi… wurraalgarra-rawaynjini wugurru. Yagu nigaayung na-Jesus warruburru-yung-guy wani-magayn, “Yagi nugurru nuu-ngarra-ḏugi aadanu. Waari ngarraagi-yung ngiga angi-ngawini, ngiga ngi-yingayn,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Yagu warraawurru-yung wunu-rajburrnani niga, wurru-marrbuy yamba ngaadagi-yung ngiga ngi-ngawiiyn. ");
INSERT INTO nuy_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Naagi-yung niga ngu-waṉja-miyn, ngu-waṉja-ḻaḻagayn ngaadagi ngarra-ngaḻaynjinyung, marri ngaa-gaḏiyn. “Ngaḻaynjinyung, ba-ḻaḻagiiyn!” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Anubani-yung ana-ngayn.gayij ngigawi-nyinyung waagiyn aḏaba ngigawi-wuy. Anubani-yung lhugaajgiyalawaj-gaj aḏaba ngi-ḻaḻagiiyn. Anubani-yung wani-magayn niga warruburru-yung-guy, “Nimbirringaa-gagina marrya, ngarraagi nimbirringiiyn ngiga.” ");
INSERT INTO nuy_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yagu nga-rriibi-yung marri na-ninyarra-yung naawiṉi-yung anubani wini-wurrij-gaḻaaḻarriyn-bindiyung wuguṉi. Yagu wani-magayn nubiṉi-yumbaa, “Yagi nuguṉi naani-magi anaani wu-waṉbini-yinyung ngarraagi-rruj ngarra-ngaḻaynjinyung,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Wurrugu marri, warruburru-yung wanii-gaḏangi niga na-Jesus, warra-12. Anubani-yung aḏaba waniini lhuḏ waadurru-yung-guy. Nguynju yadhu anubani-yung ambuu-man-jarramijgaa yungguyung wubani a-man.gurrg, marri amburru-buunggawa-maa. Marri nguynju yadhu ambarra-maji-waa yungguyung warruburru-yung wuu-lhangurrngandi-yinyung. ");
INSERT INTO nuy_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Marri anubani-yung wani-lharrgandi nguynju yadhu wubani-yung amburru-magini yungguyung na-God-jinyung ana-lhaawu, ambani-rangarrii-yinyung warruburru-yung nigawi-nyinyung warru-mandag. Marri ambarra-maji-waa yungguyung warra-wurru-wurruj. ");
INSERT INTO nuy_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wani-magaa yaani-yung wugurru waadurru-yung-guy, “Yagi anaarrgi-yung nurraarra-waṉagi numburru-yaarri-maynji ana-lharug. Yagi ana-waaṉḏulu, yagi mana-big, yagi ana-marrya yagi anu-ṉuga, marri yagi manuulawaa mana-yaaḻi nirrima-waṉagi, aynjaabugij-bugij nimbirrima-waṉagana nugurru. ");
INSERT INTO nuy_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Anubani-yung-maynji numburru-yaarri anubani-wuy anaanga-wuy, bagu numburru-burraa baḏag wurrugu. Wurrugu marri, numburru-wurrij-dhaḻagina-maynji, marri bani-yung nugurru numburru-yaarri anubagala ana-lhal-wala, nimbirriirruyn. ");
INSERT INTO nuy_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nugurru-maynji anubani numburru-yaarri anubani-wuy ana-wumurrng-guy, yagi-maynji nambi-ngaynbandi anubagu, anubani-yung nimbirriirruyn ana-wumurrng, nga manubama-yung nimbirrima-ngarrgiwang nurru-mun-jabina-yinyung nugurru, marri nimbirrima-yaljalang. Anubani-yung nambarra-yiyina wugurru, warruburru-yung wurru-waṉbini yamba aladi.” Dani-yung wani-magaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Anubani-yung aḏaba wunaarruyn, nga wuu-ngarra-janggi wugurru. Anubani-yung aḏaba wurru-yanggi wubani a-lhal, a-lhal-wurraayung-baj. Warraawurru-yung wurru-magini anubani ana-lhaawu na-God-jinyung. Anubani-yung warra-maji-waa arraarrawindi wurru-wurruj ana-lhal-lhangu-waj. ");
INSERT INTO nuy_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Naagi-yung na-Herod, naagi-yung wani-narrangi-yinyung, niga ni-mayini tetrarch. Anubani-yung niga ni-wawanggiyn anubani-yung wu-waṉbini-yinyung wugurru. Warra-mulung-arrgi-yung wugurru anubagu wurru-yamaa, “Naagi-yung niga John, ni-ḻaḻagiiyn yingga, anubanila-wala ana-ngawij-gala,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wugurraayung warruburru-yung warra-mulung-arrgi-yung wurru-yamaa “Naagi Elijah yingga ni-rabaliyn ana-ngawij-gala niga,” wurru-yamaa. Ngijang warra-mulung-arrgi-yung wurru-yamaa “Nubagi-yung yaga naaynjaabu-nyung naa-ja-jambini-yinyung anu…bani-yunggaj, naagi-yung yingga niga ni-ḻaḻagiiyn, dagi-yung,” wurru-yamaa wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nigaayung naagi-yung na-Herod ni-wawanggiyn aḏaba, marri ni-walharaguni. Naagi-yung ni-yamayn niga, “Naadagi-yung aḏaba na-John, niga nganu-nindhagal-guldhiyn yagu aḏaba! Nga-wawanggini anaani ana-lhaawu nubagi-yung yaga naaynbajung-jinyung yagu. Yangi-nyung yuga niga naadagi?” ni-yamaa. Naagi na-Herod niga nu-ngaynbandiyn anu-nani na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wurrugu wugurraayung warruburru-yung wirri-lhaawu-yarrijgini-yinyung, warruburru-yung wani-lharrgandi-yinyung, wurraagiyn aḏaba nigawi-wuy na-Jesus-guy. Nga bagu aḏaba wunu-magaa “Nurru-waṉbini anaani-yung nurru,” wurru-yamayn. Anubanila wani-miyn waadurru-yung, marri wani-yarrijgini warruburrala-wala. Wurru-yanggi buguni anubani-yung ana-wumurrng wu-mayini Bethsaida. ");
INSERT INTO nuy_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Warraawurru-yung arraarrawindi wurraawanggiyn aḏaba niga bagu aḏaba ni-burri. Nga anubani wurru-yanggi wugurru, wunu-garrindharrmangi. Anubani-yung ni-waḻaaḻarriyn niga anubagu-yinyung wurru-burri. Marri anubagu wani-magaa niga warraawurru-yung, warruburru-yung-jinyung warru-mandag na-God-jinyung. Warruburru-yung wugurru wuu-lhangurrngandi-yinyung, wani-maji-waa niga. ");
INSERT INTO nuy_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Aḏaba waadhaadharrwara-maa. Wugurru warruburru-yung nigawi-nyinyung wurru-marrbuy-maa-yinyung wurru-yanggi buguni nigawi-wuy marri wurru-yamayn, “Bamba-lharrganjii warraawurru warra-wurru-wurruj aḏaba nguynju yadhu wugurru aḏaba amburru-yaarri buguni wubani-wuy aanga aani-rruj a-lhal, marri bagu amburru-mani ana-marrya marri wugurru amburru-yara. Anaani yagu a-lhamaamura-rruj ngurru-burraa. Waadurru bamba-lharrgang,” wurru-yamayn nigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nigaayung na-Jesus wani-yambalmayn niga, “Nugurru-waj danu, nambarriiyn ana-marrya.” Wugurraayung wurru-yamayn, “Anaani nurru-waṉagana marang-aynjaabugij-bugij anaani anu-ḏayn, marri wulawaa ana-ngujija. Yagi nurru nurru-rumi marri narraa-mi ana-marrya,” wurru-yamayn wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Warraawurru-yung yamba 5000 warra-waḻya-waḻya anaani wurru-burri anubagu. Nga nigaayung na-Jesus wani-magayn warruburru-yung wurru-marrbuy-maa-yinyung, “Nambarra-magang waadurru, daju amburraambargalang amburraaḻgaaḻgaḻ, amburru-muṉḏugana, ari 50 daju marri wugurraayung yuwaagu 50, aani-yung-jii amburraambargalang.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Wugurraayung warraawurru-yung wani-yanguni-wala, anubani warra-magayn wugurraayung. Aḏaba wurraambargalangi waadurru-yung. ");
INSERT INTO nuy_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Anubani-yung aḏaba niwu-miyn anubani-yung ana-marang-aynjaabugij anu-ḏayn marri ana-wulawaa ana-ngujija, marri yaanuwuy ni-mal-nayn arrwiyaj, marri nu-warraarriwaa na-God. Anubani-yung anu-ḏayn ni-rayn-bawayuwaa aḏaba, waniini anaani-yung warruburru-yung-guy wurru-marrbuy-maa-yinyung. Marri buguni warriini warra-wurru-wurruj-guy. ");
INSERT INTO nuy_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Warruburru-yung wurru-nguni, marri wurru-waḻarrandi, bani-yung marri. Nga aḏaba wurru-mangi wurru-muṉḏugaa anu-gamuymuy, manubama-yung mana-gaṉdharra, 12. Anu-gamuymuy buguni wurru-burrangi. ");
INSERT INTO nuy_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Malgadhaadharri ngijang wurrugu, ni-yanggi yuuguni, ni-yambini na-ninyarra-yung-guy niga. Burru-yung-bugij nga, wurru-marrbuy-maa-yinyung anubagu, wugurru wuu-yagaynjini wugurru wurru-yanggi. Bagu wani-yandhawiwayn niga, “Warruburru-yung yuga warra-wurru-wurruj wugurru, ngaya anaani yuga wurraaḻamin-jamaa, yangi-nyung ngaya?” ni-yamayn niga na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wugurraayung wurru-yamayn, “Warra-mulung-arrgi wurru-yamana nagang aadanu John, nubagi-yung yaga waniimbara-ngambijgaa-yinyung. Warra-mulung-aynbaj ngijang wugurru wuu-yamana nagang aadanu Elijah. Warra-mulung-arrgi-yung wurru-yamana ngijang, nagang aadanu wunaa-ja-jambini-yinyung yaga na-God wu…bani-yunggaj, warruburru wugurru wurraaḻamin-jamana, wurru-wiri-mayn yingga, wurru-yamana nagang aadanu.” Dani-yung wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nga nigaayung na-Jesus ni-yamayn, “Yagu nugurru aadanu, yangi-nyung yuga nugurru nurru-yamana ngaya anaani?” ni-yamayn. Nigaayung na-Peter anubani-yung nu-yambalmayn niga, “Nagang aadanu na-Christ, na-Messiah, na-runggal-yung na-God-gala,” ni-yamayn nigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yagu nigaayung naagi-yung na-Jesus ni-yamayn, “Yagi narra-magi warruburru-yung warra-mulung-arrgi-yung-guy.” Anaani-yung wani-yang-baḏa-waḏaḏ-gaa ana-lhaawu, nguynju yadhu yagi yungguyung anubani warra-magi. ");
INSERT INTO nuy_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ni-yamayn, “Ngaya anaani na-Niwiyayung na-Wurrujung-jinyung, anaani ngambambii-garragayii runggal-windiyung. Warruburru-yung warra-mijiwanggu, warra-runggu-runggal warra-priest marri warra-yiyini-yinyung ana-lhaawu-runggal, ngambambiindirrii ngaya. Warra-mulung-aynbaj warruburru-yung ngambambiimana. Marri amuulawaa-wala mana-miyn.nganga wurrugu, ngaya nga-ḻaḻagiiyn ana-ngawij-gala.” Dani-yung ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Anubani-yung wani-magayn ngijang warruburru-wuy warraarrawindi-wuy, “Nugurru-maynji ngirri-ngaynbandii-maynji anubani-yung ngirri-garrindharrmani ngaya, anubani-yung nugurru numburru-yiynjang marri nimbirri-warrgu anu-ḏangag, anaani-lhangu ana-malgarrawindi, marri bani-yung ngirri-garrindharrmani ngaya. ");
INSERT INTO nuy_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","“Na-wurrujung-maynji anubani-yung aniwu-waṉagana-maynji nigawi-nyinyung ana-wiri, wurrugu marri yijgubulu anggu-wurag. Yagu anubani-yung-maynji aniwaarruyn-maynji ana-wiri nigawi-nyinyung, ngayawi yungguyung, wurrugu marri nubagi-yung ani-wiri-mang. ");
INSERT INTO nuy_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","“Nubagi-yung-maynji na-wurrujung aniwu-mang-maynji anaani ana-lhal-lhangu, yagu wurrugu marri aniwaaṉibijgang-maynji nigawi-nyinyung ana-wiri, anggu-wurag, aadanu wiijamana yij-galadi. ");
INSERT INTO nuy_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Warrubawi-yung-maynji warraaynbaj ngaya ngambii-gambulii anaani, marri ngayawi-nyinyung ana-lhaawu, ngaya-waj nga anaani na-Niwiyayung na-Wurrujung-jinyung, anaani warrubawi-yung ari ngaya ngambaa-gambulang warrubawi-yung, wurrugu marri anubani-yung ngandaagiyn-maynji, anubani-wuy wu-milhiynjina-rruj ngayawi-nyinyung, marri na-Baba-yinyung marri anubani-yung-jinyung ana-angel ana-maṉngulg. ");
INSERT INTO nuy_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Ngaya anaani ngana-magana nugurru aadanu yijgubulu-windiyung, mulung-arrgi-yung nugurru aadanu aḏaba nurraarra-garra-lhara, numbunu-nayii aḏaba niga na-God, ambani-rangarrii nigawi-nyinyung warru-mandag, numburru-wiri-waj-bugij aadanu.” Dani-yung na-Jesus ni-yambini. ");
INSERT INTO nuy_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Wurrugu marang-aynjaabugij marri ngi-wulaynbaj ngarraaḻirr, anubani-yung ni-yanggi marri niidadiyn yuuguni ama-ṉuga-wuy nga bagu ni-yambini na-ninyarra-yung-guy. Anubani-yung wurraanggarra-yanggi wurru-bugu-yanggi, waadurru-yung na-Peter, na-John marri na-James. ");
INSERT INTO nuy_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nga bagu ni-yambini arrwiyaj. Anubani-yung na-nijilhal-yung anubani-yung ni-yi-waynbijgiiyn niga. Marri maadama-yung mana-yaaḻi maaynbijgiiyn, ma-ngarrngarr-nagini-windiyung, ma-milhiynjini nguynju yi-yamiynji-yii, maadami-yung. ");
INSERT INTO nuy_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Anubagu waadurru-yung wurraarragarra-lhi yagu wuguṉi wini-wulawaa, wurru-yambiynjini niga. Naawiṉi na-nimuwaj-baa Moses marri Elijah. ");
INSERT INTO nuy_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Warraawurru-yung wurraaynjaabu anubagu wurraanggarragarra-lhi, wurru-ngalngalangi wurru-nguynju, wugurru wurru-milhiynjini. Anaani-yung wuu-yambiynjini wugurru wubani-yung yaga na-Jesus ani-yanggi-yinyung niga aanila-wala-yinyung a-lhal. Anubani yaga niga aniwu-jadugang anubani-yung ana-Jerusalem niga. ");
INSERT INTO nuy_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Yagu wugurraayung warraawurru-yung na-Peter marri naadiṉi-yung wurraanggarra-yanggi-yinyung nigawi-wuy, warraawurru wuu-yaal-ngawiiyn, marri aḏaba wurru-yingayn. Anubani-yung-maynji wurru-ḻaḻagiiyn, marri wurraarranggayn, nga warra-nayn warraawurru-yung. Anubani wunu-nayn na-Jesus bagu ni-lhaay, ni-milhiynjini, wuguṉiiyung naawiṉi-yumbaa bagu wurru-bugu-warragarra-lhi nigawi-rruj. ");
INSERT INTO nuy_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nubiṉi-yung wurraanggarragarra-lhi-yinyung, na-Jesus nubiṉi lhaalhag aḏaba ambini-yanggi, ambunaarru. Anubani-yung na-Peter niga nu-magayn na-Jesus-guy, “Buunggawa, anaani nurru wiij-maṉdhina nurru nurru-burraa nugawi-rruj. Nanggu-maṉdhii angguulaynbaj ruluj, aynjaabugij nugawi-nyinyung, aynjaabugij na-Moses-inyung marri aynjaabugij na-Elijah-yinyung,” ni-yamayn. Waari anaani ana-lhaawu wugurru anggu-wandhurrg-maa, yagu nigaayung na-Peter waari anaani ani-marrbuy-maa niga. ");
INSERT INTO nuy_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Bagu-mirri, niga ni-yambini-waj, anubani-yung ngubunung yuwaagala wu-yanggi, warruburru-wuy wugurru wanggaambamadhiyn. Waadurru-yung warra-wulu-wulaynbaj, wugurru wirri-yamayn anubani-yung ana-ngubunung. ");
INSERT INTO nuy_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Yagu bagala yang wu-rabaliyn wubanila a-ngubunung-gala. God niga-waj ni-yambini. Ni-yamayn “Naagi ngayawi-nyinyung na-Nigi. Nga-wajbariyn yamba niga. Nigawi-wuy numbunaa-gawanggina aadanu.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Anubanila-wala ana-lhaawu-wala wurrugu, anubani-yung wurraarranggayn, nga ni-wiri-wiri niga Jesus-bugij anubagu ni-lhaay. Anubanila-wala, anaani-yung wirriiyn-ngu-julubayn wugurru, waari ambarra-magaa warra-mulung-arrgi-yung-guy, anubani-yung warra-nani-wala wugurru waadurru-yung. ");
INSERT INTO nuy_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Bagu-waj wugurru waadurru-yung anubani-yung wurru-yaay. Marri yiibagi-rruj yiiynbaj-duj yi-waḻirr, aḏaba wurru-dhirridiyn manubamila-wala mana-ṉuga-wala. Warraawurru-yung aḏaba warra-raganmayn arraarrawindi-yung wurru-wurruj. ");
INSERT INTO nuy_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Yagu naagi-yung nubagi na-waḻyinyung warruburru-rruj-jinyung ni-burri, anubani-yung niga niiḏiyn na-Jesus-guy. “Barra-yiyi-yiyina-yinyung nagang, yuga ngaya anaani wa-yandhawiwang? Baarranggang nagang, banu-nang aḏaba na-nigi ngayawi-nyinyung. Yaagi-yung-bugij aynjaabu-nyung nganu-waṉagana naagi na-wirrinyung. ");
INSERT INTO nuy_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Naagi niga ni-waṉagana yaani man.gurrg. Anaani ninggu-bilhargana-maynji, marri anubani-yung niga niiḏii aḏaba, marri ninggu-yaljalii, marri anaani ni-lhagar-lhililii niga. Marri anubani ninggu-warragayangijgana, marri waari aninggaarru niga. ");
INSERT INTO nuy_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Anaani-yung ngaya ngarra-yandhawiwandi waadurru wugurru wurru-marrbuy-maa-yinyung, ambunaa-ngu-barawudangi naagi, wubani a-man.gurrg, yagu waari amburru-waṉbini wugurru.” Dani-yung ni-yambini niga. ");
INSERT INTO nuy_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Na-Jesus nigaayung ni-yamayn, “Nugurru aadanu warra-wurru-wurruj waari numburru-jambarrgiiyn! Nugurru nurru-yina-baḏa-waḏaḏ! Yuga ngaya anaani nga-ngu-burraa baḏag nugurri-rruj yuga? Anaani ngaya nga-ngu-burraa baḏag nugurri-rruj, nga-lhambaamburrg yamba ngaya marri anambaa-gaṉbina nugurri-wuy anaani, yuga? Baaṉiyn, banu-yarrijgina naadagu na-niwiyaay ngayawi-wuy,” ni-yamayn niga. ");
INSERT INTO nuy_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Naadagi-yung na-wirrinyung niga ni-yanggi. Marri anubani-yung ana-man.gurrg niga naagi ninggu-barawudiyn aḏaba na-wirrinyung aaban-guy. Naagi-yung ninggu-yaljalangi-windiyung angaḏajung. Yagu nigaayung na-Jesus ni-yamayn “Ba-muḏaḏbang!” ni-yamijgayn, ni-lhambang anubani anaaladi ana-man.gurrg. Nga naadagi-yung ni-waḏa-waḏaḏ-mayn aḏaba na-wirrinyung. Marri aḏaba naagi-yung naa-gaagijgiyn na-ninyarra-yung-guy. ");
INSERT INTO nuy_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Wugurraayung warraarrawindi-yung wurru-waḻaaḻarriyn anubani-yung-maynji wirri-nani ana-lhuḏ na-God-jinyung, niga yamba na-God ni-runggal windiyung naagi-yung. Warraawurru-yung wugurru warraarrawindi wurru-yambiynjini aḏaba, “Anubani-yung-jinyung ni-waṉbini-yinyung naagi-yung na-Jesus, anubani-yung yij-mamaaḻang-bindiyung wugurru,” wurru-yamaa. Yagu nigaayung naagi-yung na-Jesus ni-yamayn warruburru-yung-guy wurru-marrbuy-maa-wuy, ");
INSERT INTO nuy_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nugurru aadanu ngirrii-gawanggina ana-lhaawu maaḻamburrg. Ngaya-waj yaani nga na-Niwiyayung na-Wurrujung-jinyung. Wurrugu, ngambambi-yarrijgina warruburru-yung-guy warra-mulung-aynbaj-guy.” Dani-yung ni-yamaa ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yagu anaani-yung waari amburru-marrbuy-maa, anaani ana-lhaawu, anaani-yung yamba wugurru wiij-miḏaamimi-windiyung anaani-yung. Waari anaani amburru-wijangani anaandhurrg, anaani ana-lhaawu. Marri waadurru-yung wugurru wurraambulangi yamba, waari ambunu-yandhawiwandi anaani-yung-jinyung wugurru ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Anubanila-wala, wugurru warraawurru-yung wurru-marrbuy-maa-yinyung, wurru-wundii wugurraajbaj-balij. “Yangi-nyung yuga naadagi na-runggal-yung ngagurri-wala?” wurru-yamayn wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yagu nigaayung na-Jesus anubani-yung ni-marrbuy aadani-yung wurraawanggini-yinyung. Nigaayung naagi-yung nu-miyn wirrinyung, nga nu-lhangijgayn bagu nanggaa-ḻibiḻibala nigawi-rruj. ");
INSERT INTO nuy_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Marri anubani wani-magayn wugurru, “Nugurru-maynji nambarra-walgur-wana warra-wirrig nguynju naagi-yung-jii, ngayawi yungguyung, anaani wiij-nguynju, nguynju ngaayunggaj anaani ngirri-walgur-wana ngaya. Marri nugurru-maynji ngirrii-walgur-wana-maynji ngayawi-wuy, marri nubagi numbunu-walgur-wana nubagi-yung ngani-lharrgang-jinyung ngaya, nigaayunggaj. Nugurru-maynji aadanu numburru-burraa numburru-yaal-murramurra, marri numburru-winyig-gina-maynji nugurru, bani-yung nugurru numburru-runggal-mang aḏaba aadanu.” Dani-yung ni-yambini na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yagu nigaayung na-John ni-yamayn, “Buunggawa, nuunu-nani nurru waḻyinyung ni-warra-yarraani ana-man.gurrg, nugawi-nyinyung-mirri a-muwaj. Yagu nurraayung nuunu-lhambini niga, naadagi-yung yamba waari naambaanggarra-yanggi yamba niga. Waari yamba nagang ani-garrindharrmangi naadagi-yung.” Dani-yung ni-yambini na-John. ");
INSERT INTO nuy_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yagu nigaayung na-Jesus ni-yamayn, “Yagi nugurru aadanu nuunu-muḏaḏbijgi. Warrubawa-yung-maynji yagi-maynji nurraabalguyungaynji nugurru, marri warrubawa-yung nambambi-ngaynbandii aadanu.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Wurrugu marri malgadhaadharri, aḏaba mal-barubaj na-God niga anubani-yung anu-mang-jinyung niga, anaagijgiyn-jinyung anaarrwiyaj. Naagi-yung niga na-Jesus ni-wawanggini nigaajbaj, marri naagi-yung lhambuguni-yung anubuguni ni-yanggi ana-Jerusalem-guy. ");
INSERT INTO nuy_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Warruburru-yung warra-waḻya-waḻya wugurru anubani-yung wunaa-dhaawu-yarrijgini-yinyung niga anubani ana-lhaawu. Nga anubani-yung wurru-yanggi wubani a-wumurrng-guy ana-lhal wu-mayini Samaria, nga amburraarraalgurmangi yungguyung, aniga-yung-jinyung anaanga niga ani-yaay yungguyung. ");
INSERT INTO nuy_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Yagu waadurru-yung wugurru warra-wurru-wurruj waari ambunu-ngaynbandangi niga, naagi-yung yamba niga niwu-ngaynbandangi ni-yanggi Jerusalem-guy, niga na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Naawiṉi-yung wuguṉi nigamanyij na-James marri na-John, naawiṉi-yung wini-marrbuy-maa-yinyung wuguṉi, anaani-yung aḏaba wini-wawanggiyn ana-lhaawu. Marri anubani-yung wini-yamayn, “Buunggawa, yuga niiṉi anaani naanu-yambina yuga na-God-guy, niiṉi? Marri yuga ngura anaani anuwagala anggu-dhirridii marri anubani-yung ambanggu-nangana wugurru anaani-rruj anaaban-duj, ambanggu-jadugang wugurru?” Dani-yung wini-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nigaayung na-Jesus wani-magayn nubiṉi-wuy, “Aadanu wugurru yamba yij-galadi, aadanu nuguṉi nimbini-muḏaḏbang,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Anubanila-wala, wurru-bugu-yanggi aḏaba yuuguni wubani-wuy a-wumurrng-guy aaynbaj-guy aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Wurrugu marri, ngijang anubani-yung wurru-yanggi aḏaba yuuguni wirrimaadi-lharrmangi. Nga naagi waḻyinyung bagu nu-magayn na-Jesus-guy, “Nga ngaya anaani wa-garrindharrmani-wugij, nagang anaaynbaj-guy ana-lhal nagang-maynji ba-yaarri,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nigaayung na-Jesus nu-yambalmayn, “Warrubawi-yung yaga waa-nunggarrang wu-riganjii wirri-gara-yungana a-gara, wu-gaadhina yaga. Wugurraayung yaga ana-ngurudhu anubani-yung wu-wayayarrii. Yagu anaani ngaya, na-Niwiyayung na-Wurrujung-jinyung, waari ngaya nganggu-waṉagang anaanga. Waari anaanga nga-yingi-yinyung ngaya anaani.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ngijang aḏaba anubani-yumbaa, wurrugu marri, na-Jesus anubani nu-magayn aynbajung-guy. Marri ni-yamayn “Baaṉiyn, nimba-garrindharrmang ngayawi-wuy aḏaba.” Nigaayung ni-yamayn, “Wurrugu. Wurrugu marri ngaynjaarri ngaya yuuguni wurrugu nganu-wurrdhii ngayawi-nyinyung na-baba, marri bani-yung nga ngaya wa-garrindharrmang,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nigaayung na-Jesus nu-yambalmayn niga, “Yagi,” ni-yamayn nigawi-wuy. “Warruburru-yung yaga wurru-ngawina, burru-yung aḏaba wugurru warra-wurrdhii warruburru-yung wurru-ngawina-yinyung, aḏaba wiiya. Nugawaj aḏaba, ba-yaarri, bamba-magana aadanu ana-lhaawu, warruburru-yung-jinyung yaga na-God-jinyung warru-mandag.” Dani-yung nu-magayn niga na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nigaayung naaynjaabu-nyung na-waḻyinyung aḏaba nu-magayn, “Ngaya-waj yaani nga, wa-garrindharrmani Buunggawa. Wurrugu, ngaynjaarri nga ngaynjamang ngaya ‘Wiiyaw’ ngamba-magang warruburru ngayawi-wuy ngurraalgurmaynjini-yinyung.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nigaayung na-Jesus nu-yambalmayn, “Nagang-maynji ba-mijgalmina aadanu, anubanila ba-wuguuguni-wugij-maynji nagang ba-wawanggina aynba-gaynbaj-jinyung, ari yagi nagang nuṉḏumi anubani-wuy anaanga-wuy, anubani-wuy na-God-jinyung wani-rangarrii-yinyung nigawi-nyinyung-jinyung warru-mandag.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Wurrugu anubanila-wala naagi-yung na-Jesus anubani-yung ni-wajbarini niga warraawurru-yung 72 warra-waḻya-waḻya. Warraawurru-yung wugurru wani-lharrgandi niga raga-ragij nigawi-rruj. Warraawurru-yung wurru-yanggi wurru-wulu-wulawaa-waj-bugij. Marri ni-yamayn niga, “Nugurru aadanu numburru-yaarri wubani-waj a-wumurrng-baj, marri ngaya ngaynjaarri wurrugu lhaalhag wugurri-waj a-lhal-waj. ");
INSERT INTO nuy_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Warruburru-yung yamba arraarrawindi wurru-wurruj nambi-rangarrii nugurru amburraawanggina-yinyung aḏaba, ana-lhaawu, yagu wurraadharra nambambi-maṉmani-yinyung. Nugurru numbunu-lhangayaana niga na-God, niga yamba ni-buunggawa-mana warruburru-wuy, nguynju yadhu niga ambani-lharrganjii yungguyung warra-wurru-wurruj, nambambi-maṉmani yadhu nugurru, nambarra-magana warra-mulung-aynbaj ana-lhaawu na-God-jinyung. ");
INSERT INTO nuy_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Numburraawanggina, ngaya anaani ngana-lharrganjii nugurru nguynju yaga a-jib-jii wubani a-ngirri-ngirri-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yagu nugurru numburru-yaarri arrbidi. Yagi nirri-yarrijgi anu-ṉuga. Marri yagi mana-big, marri yagi nugurru nirrima-waṉagi manaaynbaj nurru-mun-jabina-yinyung nugurru. Warruburru-yung-maynji nambambi-lhangarrmana nugurru manaadi-rruj, yagi nurru-muḏaḏbi aadanu, nga yagi nambi-magi wugurru.” ");
INSERT INTO nuy_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Na-Jesus naagi-yung niga ni-yambini-wugij. “Anubani-yung-maynji numburru-yaarri nugurru anubani-wuy anaanga-wuy, ana-wulhu-wulhurr nugurru numburru-yamang, ‘Aadanu, na-God nambaniiyn nugurru lhamaamura niga.’ ");
INSERT INTO nuy_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nubagi-yung-maynji niga na-lhamaamura-yung na-wurrujung anubagu ani-burraa, nambani-yaynjangayii-maynji nugurri-nyinyung ana-lhaawu, anubani-yung niga ani-lhamaamura-mang-bindiyung, niga na-God anu-maṉmani-wugij niga. Yagu warraaynbaj-maynji warrubawi-yung wu-lhamaamura-mi wugurru, anubagu yagi-maynji wu-burrangi wugurri-rruj, anubani-yung ana-lhamaamura nugurri-wuy aḏaba anggaagiyn, anggu-burrangang, na-God niga waari wani-maṉmi, warruburru-yung warra-wurru-wurruj wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","“Anubani-yung-maynji nugurru numburru-yaarri anubani-wuy anaanga-wuy, nga bagu numburru-burraa wurrugu. Nga yagi anubani nurru-rumi wurrugu anubanila-wala anuuguni anaaynbaj-guy marri anuuguni anaaynbaj-guy yagi nurru-rumi, nirriinga-walmabalmi anubani anaanga. Anubani-yung nambambiiyii-maynji ana-marrya marri anaa-gugu, numburru-nguyii marri numburru-waḻ-nguyii, yagi nurru-lhaabi. Anaani wiijamana. Warrubawi-yung-maynji warra-wurruj ambu-mijgalmina, warrubawi-yung wiij-maṉdhina aḏaba ambarra-bayarra-gana wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Nugurru aadanu numburru-yaarri-maynji anubani-wuy ana-wumurrng-guy warrubawi-yung nambambi-ngaynbandang-maynji, anubani-yung numburru-nguyii warruburru-yung-jinyung nambambiiyii-yinyung ana-marrya. ");
INSERT INTO nuy_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Marri warruburru-yung warra-wudhu-wudhangurrg anubagu amburru-burraa-maynji, warruburru-yung nambarra-maji-wana nugurru. Marri nambarra-magana aḏaba, warruburru warra-wurru-wurruj anubani-rruj-jinyung, ‘Warruburru-yung warru-mandag na-God-jinyung wurru-warubaj-gina aḏaba nugurri-rruj.’ Danu numburru-yamana nambarra-magana nugurru. ");
INSERT INTO nuy_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Yagu anubani-yung-maynji numburru-yaarri nugurru ana-wumurrng-guy nga yagi-maynji anubani nambi-ngaynbandi nugurru, marri numburru-yaarri aḏaba amubama-wuy amaadi-wuy, nga bagu numburru-yamang, ");
INSERT INTO nuy_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Anubani-yung ana-lhagabuṉulg nambanggu-mun-maṉḏamaṉḏii-maynji, anubani-yung bagu naambu-mun-jarrbina nurru, nugurru yamba aadanu ngirriigaminij-gaandirrangi nurru. Nugurru waari na-God-jinyung-magaa, waari nani-rangarri nugurru aadanu. Yagu anaani numburru-marrbuy nugurru, warruburru-yung na-God-jinyung warru-mandag warubaj aḏaba nugurri-rruj.’ Nugurru dani-yung numburru-yambina aḏaba.” ");
INSERT INTO nuy_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na-Jesus anubani-yung wani-magaa-wugij. “Ngaya ngana-magana nugurru yijgubulu-windiyung, anubani-yung na-God ngaambani-nguynju-nguynjijgana-rruj ngarraaḻirr, anubani-yung ambani-man.galagana warruburru-wuy anubani-yung-jinyung ana-Sodom. Yagu wugurraayung warruburru-yung waari-yinyung nambi-ngaynbandi nugurru, waari wani-man.galagi, wugurri-wuy.” Dani-yung ni-yamaa, na-nidhaawu-yung na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Anaani-yung ni-yambini ngijang, “Anubani-yung bani nga anggu-maṉdhina runggal-windiyung anaaladi nugurraa yungguyung aḏaba, ana-Chorazin-duj, ana-lhal, marri nugurraayung ana-Bethsaida-yinyung. Aadanu yamba ngaaṉbini aḏaba bagu yij-mamaaḻang nugurri-rruj. Yagu nugurru waari nimbirriij-garru anubani anaaladi, nurru-waṉbina-wugij nugurru. Wugurraayung warruburru-yung ana-Tyre-yinyung marri ana-Sidon-jinyung, wiiya wugurru wurraaladi anu…bani-yunggaj. Yagu anubani-yung nganggaṉbini-magaa aniij-mamaaḻang wugurri-wuy, yagu anubani-yung ambirriij-garru-magaa wugurru anubani anaaladi. Wugurru amburru-wurrij-galadi-wini-magaa, wugurru amburru-burri ambuu-yaaḻi-aladi marri ambanggu-wudbudangi-magaa lhagabuṉulg wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","“Anubani-yung-maynji niga na-God anubani ambani-nguynju-nguynjijgana-maynji, warraawurru-yung anggu-waṉina aladi wugurri-wuy. Yagu nugurraayung ana-Chorazin-jinyung marri ana-Bethsaida-yinyung, wugurru anggu-waṉina nugurri-wuy runggal-windiyung aladi! ");
INSERT INTO nuy_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“Marri nugurraayung ana-Capernaum-jinyung, ngaya ngana-magaa aḏaba ana-lhaawu nugurri-wuy. Marri yuga na-God niga nambani-warraarriwana niga? Waari! Numburru-yaarri nugurru arrwiyaj, yuga? Waari! Nugurru aḏaba nambani-lhajbiyn niga. Nugurru nambani-lharrgang, numburru-yaarri wubani a-ngura-wuy wu-naga-nagina-wuy!” ");
INSERT INTO nuy_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Dani-wugij na-Jesus niga wani-magaa-wugij warruburru-yung wurru-marrbuy-maa-yinyung. “Warraaynbaj-maynji warrubawi-yung nugurru nambambi-yaynjangayii nugurri-wuy, anaani wiijamana, ngaayunggaj ngambambi-yaynjangayii ngayawi-wuy. Yagu nugurri-wuy-maynji nambambiigaminij-gaandirrii, anaani wiijamana ngaayunggaj ngambambiigaminij-gaandirrii anaani. Marri ngambambiigaminij-gaandirrii-maynji, nigaayunggaj ambunaagaminij-gaandirrang, niga na-God, nubagi ngani-lharrgang-jinyung ngaya.” Dani-yung nga ni-yambini ana-lhaawu. Warraawurru-yung wugurru warra-waḻya-waḻya 72, warraawurru-yung aḏaba wurru-yanggi wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wurrugu malgadhaadharri anubani-yung, aḏaba wurraagiyn warraawurru-yung warra-waḻya-waḻya. Marri anubani-yung wurru-waḻaaḻarrangi wugurru. Warraawurru-yung wunu-magaa niga, “Buunggawa, anaani-yung ana-man.gurrg anubani-yung-maynji nugawi-nyinyung ana-muwaj nurru-yambini, anaani-yung aḏaba nurru nanggu-yandhurrbangaa wugurru,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Na-Jesus ni-yamayn, “Nganu-nani aḏaba nubagi-yung na-baḏirrnya-yung na-Satan. Aḏaba ni-rabini nguynju yaga yiidagu-yii yaga yi-yamiynji-yii, ni-yamaa, ni-rabini niga. ");
INSERT INTO nuy_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nugurru nganiiyii aḏaba anaani ana-lhuḏ. Anubani-yung ana-marryn numburru-nyiyn-ban.ngana nugurru, marri nubagi-yung na-maḻa nimbini-wan.ngana. Wiiya nubagi-yung niga na-baḏirrnya-yung niwu-waṉagana ana-lhuḏ, yagu anubani-yung yagi nani-warragayijgi nugurru. ");
INSERT INTO nuy_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Aadanu ana-man.gurrg wugurru aadanu nanggu-yandhurrbangana. Marri nurru-waḻaaḻarrii nugurru. Yagu anubani-yung numburru-waḻaaḻarrii-windiyung nugurru, runggal, niga yamba na-God anubani-yung niga nanii-mij-garrarrangi yamba ana-muwaj yuwaani waarrarrina arrwar, nigawi-rruj na-God-duj.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Anubani-yumbaa niga aḏaba, anubani-yung na-Jesus naagi-yung niga ni-ḏinggini anubani-yung-gala ana-Maṉngulg Mawurr-wala. Marri ni-yamayn, “Ngaya ngunu-warraarriwana anaani Baba. Nugawaj nu-ngu-buunggawa-mana aadanu anaarrwar marri anaani-rruj ana-lhirribala. Nagang aadanu nunggij-ngu-julubayn anaani ana-lhaawu warruburru-yung-gala waa-yina-mamaaḻang-gala. Yagu wugurraayung waari-yinyung warruburru-yung ambuu-yina-mamaaḻang-jinyung-magaa, warruburru-wuy nunggij-garrarra-gayn, aadanu, ana-lhaawu. Yuu, Baba, danu nga nunggijangani-yinyung nagang aḏaba.” ");
INSERT INTO nuy_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Anaani-yung na-Jesus niga ni-yambini-wugij. “Ngaya anaani na-Baba nganiini anaarrawindi-lhangu niga, ngaya niga na-niwiyayung anaani. Waari warraaynbaj ambu-marrbuy-maa ngaya anaani. Yagu na-Baba-wugij ni-marrbuy ngaya anaani. Ngijang, na-Baba waari warraaynbaj ambu-marrbuy-maa niga. Yagu ngayaaj-bugij nga-marrbuy niga. Ngaya-maynji nganggiijangayii marri ngamba-magana, warra-wurru-wurruj-guy, ari wugurraayunggaj amburru-marrbuy niga.” Dani-yung ni-yambini na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Warruburru-yung-guy niga wani-magaa wurru-marrbuy-maa-wuy, wugurraajbaj wuu-yambiynjini ana-lhaawu. Ni-yamayn niga, “Nugurru aadanu nurraarra-nani aḏaba arrawindi. Anubani-yung niga naniigajij-majgaa na-God. ");
INSERT INTO nuy_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Anaani ngana-magana nugurru, warraawurru arraarrawindi anubani wunaa-ja-jambini-yinyung, marri warruburru-yung waa-runggu-runggal-inyung anu…bani-yunggaj-jinyung, anubani-yung wirri-ngaynbandangi wugurru ambirri-nani anaarrawindi nga-waṉbini-yinyung ngaya. Yagu waari anubani ambirri-nani wugurru. Yagu nugurru aadanu nirri-nani aḏaba. Warruburru-yung anubani-yunggaj wirri-ngaynbandangi wugurru amburru-wawanggini. Yagu waari anubani wugurru amburraawanggini.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Anubani malgadhaadharri wurrugu, nubagi naaynjaabu-nyung wani-yiyini-yinyung ana-lhaawu-runggal, ni-yanggi, nu-yandhawiwandi na-Jesus, nguynju yadhu anubani-yung anu-rawini yadhu. Nga nu-yamijgayn “Barra-yiyina-yinyung, yuga ngaya anaani ngaynjaminggarrina anubani-yung ngambiri-mang ngaya anggu-wuguuguni-yinyung?” ");
INSERT INTO nuy_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Na-Jesus nigaayung nu-yambalmayn, “Yuga wu-yaminggarrina aadanu waarrarrina ana-lhaawu-runggal? Aadanu-rruj nagang nunggu-nayii?” ");
INSERT INTO nuy_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nigaayung anubani nu-yambalmayn, ni-yamayn (Deuteronomy 6:5) “Numbunaa-ḏamarr-ngu-burraa niga na-Buunggawa nugurri-nyinyung na-God, nugurri-wala aandhiri-wala marri yi-wurrij-gala marri a-wiri-wala marri ama-malbij-gala marri a-yinag-gala. Marri, (Leviticus 19:18) ‘Warrubawa-yung nambarra-ngaynbandii nurraalgurmaynjina-yinyung nugurru, nguynju yaga danu nurru-ngaynbandiina nugurraajbaj,’ ” Dani-yung ni-yamayn na-waḻyinyung niga. ");
INSERT INTO nuy_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nigaayung na-Jesus anubani-yung ni-yamayn, “Nagang aadanu nuynjambina andhurrg windiyung. Baaṉbina nagang anubani-yung, marri nguynju yadhu ba-burraa ba-wiri nagang.” ");
INSERT INTO nuy_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nigaayung na-waḻyinyung, anubani-yung wani-ngaynbandangi niga ambani-bajiyini andhurrg yungguyung ani-burri. Marri ni-yamayn, “Yangi-nyung yuga naadagi ngaya na-guwaj?” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nga naagi-yung na-Jesus anaani-yung nu-magaa ana-lhaawu niga. “Naagi-yung waḻyinyung ni-yanggi yuwaagala Jerusalem-gala, marri ni-yanggi yuuguni Jericho-wuy, buguni ni-dhirridangi ni-yanggi niga. Yagu naagi-yung na-waḻyinyung aḻagaḻa niga, wunu-bilhargayn nga wunu-wini, warraawurru-yung wurraamaamaji-yinyung wugurru wuṉuga-yinyung. Manaama-yung mana-yaaḻi nigawi-nyinyung wunaa-garra-ḻaḻaani marri wunu-wini niga. Naagi-yung aḏaba lhaalhag niga ani-ngawini. Warraawurru-yung aḏaba wunaarruyn niga, ni-rigu-murrgulhi aḏaba, wurru-yanggi. ");
INSERT INTO nuy_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Naagi-yung aynbajung anuwagala ni-lhamarrangi, marri nimaadi-lharrmangi amaadi-waj ni-yanggi, nubagi-yung priest-jung, ni-yamba-yambini-yinyung. Ni-yanggi nga ni-warranggayn nu-nayn, ni-murrgulhi, naadagi-yung niga. Nga naagi-yung yuwaagala-yung-galawaj niga ni-ḻimayn, naagadharrgang naadagi-yung. ");
INSERT INTO nuy_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","“Wurrugu marri ngijang, naagi-yung aynbajung warru-mandag na-Levi-yinyung, naagi-yung ni-wa-wardhangi-yinyung wubani-rruj a-Temple-Maṉngulg-duj niga, naagi-yung ni-yamayn-bugij nigaayunggaj. Naagi-yung ni-yanggi… nga ni-warranggayn, yuwaagila ni-murrgulhi niga. Nga yaajila-walawaj-gaj niga naagadharrgang, ni-yaḻdhiyn. ");
INSERT INTO nuy_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Nigaayung naagi-yung marri wurrugu, anubani-yung ana-lhal-inyung niga a-Samaria-yinyung, naagi-yung lhalmarr-yung, naagi-yung ni-yanggi nga nu-nayn, naagi-yung na-waḻyinyung niga ni-murrgulhi. Nga anubani-yung niga nu-warrngayuyn. ");
INSERT INTO nuy_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ni-yanggi buguni nigawi-wuy. Nga ni-garrajiyn, aḏaba nu-lhaṉ-jarrbini niga wubani a-jiiji. Anaani-yung nu-lhaṉ-baḻbini niga wugargayag-mirri, marri nu-lhaṉ-gabaa yaaḻi-mirri niga. Naagi-yung ni-rulbu-wayajarrangi niga anubani ana-dunggi, nu-walamalhiyn nu-burriyn arrwa-garrwar a-dunggi-rruj. Niga yuwaagu ni-wudhi arrwar, nigaayung naadagi-yung ni-lhamunu-warrgini, anaani-yung ana-dunggi. Anubani-yung wini-yanggi wuguṉi wubani-wuy a-wumurrng-guy. Wini-yanggi… nga bagu nu-burriyn niga, nga nu-rangarrangi. ");
INSERT INTO nuy_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nga wini-yaay wuguṉi anubani-yung. “Ngijang yiiynbaj-duj yi-waḻirr, naagi-yung ana-Samaria-yinyung, naagi-yung nu-yayn nubagi-yung ni-buunggawa-maa-yinyung wubani-yung-jinyung a-wumurrng, niwu-rangarrangi-yinyung niga. Anaani-yung wuṉuga-wulawaa anu-ṉuga nu-yayn nigawi-wuy. Nga nu-magayn niga, ‘Nugawaj danu banu-rangarrii naadagu na-waḻyinyung. Aadanu-maynji nagang anu-ṉuga bawu-lhaladii-maynji, ngijang ngaya ngandaagiyn, marri wiiyn ngijang nagang,’ ni-yamayn.” ");
INSERT INTO nuy_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Na-Jesus ni-yambini-wugij, anaani-yung ana-lhaawu. “Nugurru numburraawanggina anaani-yung ana-lhaawu. Waadurru-yung-gala wugurru warra-wulu-wulaynbaj, yangi-nyung niga nu-guwaj-gaa naadagi-yung niga ni-warragayangi-yinyung? Nugurraajbaj numburru-wijangayii.” Dani-yung niga wani-magaa, na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nigaayung na-waḻyinyung wani-yiyini-yinyung ana-lhaawu-runggal, ni-yamayn niga, “Dagi-yung nga, nu-man.galagaa-yinyung.” Nigaayung ni-yamayn na-Jesus, “Ba-yaarri aḏaba, baaṉbina wudani-yung-jii ngijang, anggiijamana,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Anubanila-wala, aḏaba warraawurru-yung wurru-yanggi-wugij. Nga wurru-yanggi wubani-wuy a-wumurrng-guy. Nga ngaadagi-yung ngarra-maṉinyung bagu ngi-burri ngiga, ngarra-ngarrimuwaj-jung Martha. Nga bagu ngiga ngi-yanggi nga ngi-rabaliyn, nga wangi-yandhawiwayn wugurru, “Numburraaṉiyn ngayawi-wuy aani aanga-wuy,” ngi-yamayn. Nga wurru-yanggi, wurru-yabiyn ngigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ngaadagi-yung ngarra-ngarrilharri-yung ngiga bagu ngi-burri, ngarraagi-yung ngarra-ngarrimuwaj-jung Mary. Ngarraagi-yung ngarra-Mary ngi-jarrarriyn nga ngi-burrangayn nigawi-rruj, ngiindadhangayn na-Jesus-duj, ngunu-mun-miṉmiṉḏiyn a-mun-duj. Nga ngarraagi-yung ngiga ngi-wawanggini, ngunu-yaynjangani ni-yambini-yinyung ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ngigaayung ngarra-Martha, ngiga ngi-warraalgaalgurmangi aynba-gaynbaj-jinyung, ngiga ngi-mijgalmini, warruburru-yung wangi-rangarrangi ngiga. Yagu ngiga yamba ngarraagi-yung yamba ngiga ngi-mijgalmini, nga waari angunu-yaynjangani niga naagi-yung na-Jesus. Ngi-jarrarriyn, ngi-lhangayn, nga ngi-yamayn, “Buunggawa, ngaadagu ngaya ngaa-murruyung, waari ngaya anaani ngambangi-maṉmangi yagu! Angi-mijgalmini ngiga, ngambangi-maṉmangi! Anaani nga-mijgalmina ngayaaj-bugij! Nagang aadanu yamba numbarandhalabiyn ngaya! Bangu-magang ngaadagu, ngaya ngambangi-maṉmani.” Dani-yung ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yagu nigaayung na-Buunggawa niga ni-yamayn, “Martha, Martha, aynjawalayung nagang!” ni-yamayn. “Nagang aadanu yamba nuṉḏamarr-ruwi-ruwina-windiyung, aynba-gaynbaj-jinyung arrawindi-yinyung. ");
INSERT INTO nuy_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Yagu aynjaabugij-bugij wugurru anaani aniij-ḏunggal. Aadanu nagang nimbaa-gawanggina ngayawi-nyinyung ana-lhaawu. Ngarra-Mary yamba ngiga yaagi ngi-burraa ngayawi-rruj. Ngiga ngarraagi ngi-wijangani ngigaaj-baj-mirri, aniga-yung aniij-mamaaḻang wugurru. Yagi ngarraagi ngaya ngangu-lhambu ngiga.” Dani-yung ni-yamayn niga na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Anaani aḏaba yuwaagu wurru-burri a-lhal-aynbaj-duj. Niga na-Jesus ni-yambini na-ninyarra-yung-guy aḏaba. Anubani-yung niwu-jadugayn niga ni-yambini-yinyung. Warraawurru-yung wurru-marrbuy-maa-yinyung wugurru wurru-burri bagu. Nga aynjaabu-nyung nu-magayn nigawi-wuy na-Jesus-guy. Nga ni-yamayn, “Buunggawa, nimba-yiyina nurru, naambu-yaminggarrina-yinyung naambu-yambina nigawi-wuy, nguynju yaga na-John warruburru-yung wurru-marrbuy-maa-yinyung wani-yiyini yaga niga.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nigaayung ni-yamayn wugurri-wuy, “Anubani-yung-maynji numbunu-yambina niga, yaani-yung nga numburru-yamana. Baba, nagang nirri-maṉngulg-gana nugawi ana-muwaj. Ngunu-ngaynbandii ba-buunggawa-mana anaani warraarrawindi-lhangu. ");
INSERT INTO nuy_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Numbiiyii nurri-wuy ana-marrya nurru-ngaynbandii-yinyung ana-yimbaj. ");
INSERT INTO nuy_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Numbaagajij-garruyn anaaladi-wala nurru-waṉbini-yinyung, nurru yamba narraagajij-garruna warruburru warraarrawindi, anaaladi-wala wurru-waṉbina nurri-wuy. Yagi numba-rawu anaangaḏajung.” Dani-yung ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Marri anaani-yung aḏaba wani-magaa niga. “Nagang-maynji banu-wagarii nugawi-nyinyung-guy nubagi-yung na-guwajung ana-miyn.ngu, marri ba-yamang nigawi-wuy, ‘Guwaj, nimbiiyn ngaya angguulaynbaj wuḏayn, marrya. ");
INSERT INTO nuy_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ngayawi-nyinyung yamba nubagi naaynbajung na-guwajung, ni-waliyn yamba, ni-yanggi waa-yarrmayarrmaj yamba ngayawi-nyinyung-guy anaanga-wuy. Ngaya waari yamba anubani ngambaṉagang anubagu, nigawi yungguyung ana-marrya.’ ");
INSERT INTO nuy_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Aadanu-maynji nagang ba-yamana, ani-yaminggarrang nubagi niga na-guwajung? Nugurru aadanu numburru-wijangayii aḏaba. Yuga niga nubagi-yung nagang ani-yambina nigawi-wala a-wumurrng-gala lhirribala-wala, ‘Yagi nagang nuṉḏumi anubagala ngayawi-wuy. Anaani anu-dhawang wu-dhidina yamba. Ngayawi-nyinyung warra-mijburrayung yamba warraawurru aḏaba wuu-lhagarra-yara ngayawi-rruj. Yagi ngaya nga-ḻaḻagi, marri yagi ngaya ngunu-yu nagang.’ ");
INSERT INTO nuy_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yuga nugurru nurraan-jamana niga aadanu ani-yambang niga? Yagi! Ari ani-yamang ‘Yuu!’ Anaani ngana-magana, niga nugawi-nyinyung nubagi na-guwajung. Yagu wiiya aadanu. Yagu ngubindi, nubagi niga ani-ḻaḻagiiyn, yagu nagang yamba nunu-yandhawiwanjii-wugij, nunu-yaṉḏawumana niga, numbuguuguni nagang. Ari ani-ḻaḻagiiyn, anubani-yung aniiyn anubani-yung nunggarra-ngaynbandii-yinyung niga anaarrawindi-lhangu.” ");
INSERT INTO nuy_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Naagi-yung na-Jesus ni-yambini-wugij niga. “Anaani ngana-magana nugurru, nugurru-maynji anubani-yung numbunu-yandhawiwanjii-maynji nigawi-wuy na-God-guy, marri anubani-yung nambaniiyn niga. Numburraagalhaga-lharrmani-maynji anubani-yung anaaynbaj nigawi-wala na-God-gala, marri anubani-yung nimbirri-lhangarrmang wugurru aḏaba. Yagu nugurru-maynji nimbirri-waḏbaḏang-maynji anu-dhawang nugurru na-God-jinyung marri anubani-yung niga nambanii-ngu-gara-wawalhijgang aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Warrubawi-yung-maynji ambunu-yandhawiwanjii-maynji niga, marri anubani-yung ambaniiyn aḏaba. Marri warrubawi-yung-maynji amburraagalhaga-lharrmani-maynji anubani anaaynbaj nigawi-wala na-God-gala, bani-yung marri ari ambirri-lhangarrmang wugurru. Marri warrubawi-yung-maynji ambirri-waḏbaḏang anu-dhawang na-God-jinyung, marri bani-yung nga ambanii-ngu-gara-wawalhijgang niga. ");
INSERT INTO nuy_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Nugurru aadanu warra-mininyarra-yung, na-niwiyaay-maynji anubani-yung ani-yandhawiwang ana-ngujija, yuga nagang banuuyn marryn? Waari! ");
INSERT INTO nuy_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ngijang ani-yandhawiwanjii-maynji nagang ana-gagaḻang, yuga nagang banuuyn maḻa? Waari! ");
INSERT INTO nuy_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nugurru nurraalaaladi aadanu. Yagu nugurru nurru-marrbuy aadanu, narriiyii-yinyung anubani anaambaḻaman-jinyung, nugurri-nyinyung-guy warra-mijburrayung-guy. Aadanu nugurru numburru-marrbuy aḏaba anubanila-wala, nuwaagi na-Baba anaarrwar, niga ni-mamanunggu-windiyung. Anubani-yung-maynji numbunu-yandhawiwanjii, anubani nambaniiyii anubani ana-Maṉngulg Mawurr wugurru.” Dani-yung ni-yamaa na-Jesus, wani-magaa. ");
INSERT INTO nuy_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Anubani-yumbaa anaani-yung niga ni-warra-yarraani ana-man.gurrg. Anaani-yung ana-man.gurrg waari anggu-yambini wugurru, nigaayunggaj naagi na-waḻyinyung waari ani-yambini niga. Anubani-yung ana-man.gurrg wu-rabaliyn nubagila-wala na-waḻyinyung-gala, marri bani-yung anaani-yung ni-yambini niga. Warraawurru-yung warra-wurru-wurruj wunu-nayn-gala nga wurru-wurrij-gaḻaaḻarriyn wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Yagu wugurraayung warra-mulung-arrgi-yung wurru-yamaa, “Wurrugu aadani-yung ari ni-warra-lharrgang niga anubani ana-man.gurrg, anubani-yung lhuḏ-mirri yamba nubagi-yung na-Beelzebul-inyung, na-baḏirrnya-yung, ni-buunggawa-mana-yinyung niga anubani-yung-jinyung ana-man.gurrg.” Dani-yung wurru-yamaa wugurru yingga. ");
INSERT INTO nuy_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Wugurraayung warra-mulung-arrgi-yung warraawurru-yung wunu-rawini yingga niga. Warraawurru-yung wugurru wunu-ngaynbandangi ani-waṉbini aynbaj malnguj aarrwar-wala. ");
INSERT INTO nuy_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nigaayung naagi-yung na-Jesus anubani aḏaba ni-marrbuy warraawurru-yung-jinyung wirriijangani-yinyung anaaḻamin. Nga bagu-mirri wani-magayn wugurri-wuy, ni-yamayn, “Warra-mulung-aynjaabugij-maynji wugurru anubagu-maynji amburru-burraa, warruburru-yung-maynji wugurru amburru-wiynji-wiynjina-wugij, warruburru-yung aḏaba ari ambuu-manda-ngu-jadugiiyn aḏaba. Warruburru-yung wugurru wurraalgurmaynjina-yinyung, amburru-wiynjina wugurraajbaj aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Marri na-baḏirrnya-yung-jinyung-maynji ana-man.gurrg anggu-wiynjina wugurru wugurraajbaj-balij, yagi wu-lhuḏ-ḏumi wugurru aḏaba. Anubani-yung anggu-jadugaynjang wugurru. Yagu nurru-yamaa nugurru, ngaya anaani ngaarra-yarraani ana-man.gurrg anubani-yung lhuḏ-mirri nigawi-nyinyung-gala nubagi-yung na-baḏirrnya-yung-jinyung-gala. ");
INSERT INTO nuy_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","20","Ngaya anaani ngaarra-yarraana aḏaba na-baḏirrnya-yung-gala anaani yuga ana-man.gurrg-gaang? Yagu nugurri-nyinyung warruburru wurru-marrbuy-mana-yinyung, wugurraayunggaj anaani wurraarra-yarraana ana-man.gurrg yagu! Wugurru wirri-waṉagana lhuḏ, nguynju ngayawi-yii. Yuga waa-yangi-nyung-jinyung yuga anaani ana-lhuḏ? “Yigaj! Anaani ana-lhuḏ wu-yaarri nigawi-wala na-God-gala. Marri nugurri-nyinyung warruburru wurru-marrbuy-mana-yinyung, aadanu nugurru ari nambambi-bajiyina aadanu, nugurru yamba nurru-wij-gajarrgana aadanu. Yijgubulu, anaani ana-lhuḏ wu-yaarri na-God-gala. Yagu anaani nanggu-bajiyina nugurru, warru-mandag na-God-jinyung yamba, yaawurru nga, aḏaba, nugurri-rruj wurru-burraa.” ");
INSERT INTO nuy_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Na-Jesus naagi-yung ni-yambini-wugij niga. “Anaani wiijamana. Nubagi-yung yaga na-waḏa-waḏaḏ-jung na-waḻyinyung ni-miyn-gudhi yaga mana-ḻarrda, nimaarra-waṉagaa niga. Anubani-yung niwu-rangarrangi yaga ana-wumurrng nigawi-nyinyung. Anubani-yung nigawi-nyinyung anaarra wu-warra-ngu-burri-yinyung anubagu, nga waari anggu-warraaṉibini wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","‘Waari ngambambii-gamaji ngaya manaama. Ma-naranggi-wambaḻaman mana-ḻarrda,’ ni-yamayn niga. Yagu nubagi-yung aynbajung niga na-waḻyinyung, ni-waḏa-waḏaḏ-bindiyung niga, nubagi ni-yanggi, nga wini-wiynjini wuguṉi, nga nu-lhuḏ-gugumangi waḏa-waḏaḏ-jung niga. Anubani-yung nimaarra-yarini magurru manubama-yung mana-ḻarrda. Marri ni-warra-yarini anubani-yung ana-mamanunggu-yinyung anaarra. Marri waniini nigawi-nyinyung-guy warruburru-yung wurru-guwaj-gaynjina-yinyung niga. ");
INSERT INTO nuy_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Yigaj! Warraaynbaj-maynji warrubawi-yung yagi-maynji ngurraanggarra-rumi ngayawi-wuy, warrubawi-yung wugurru ngambambi-wurrij-bangana ngaya. Yagi-maynji warraaynbaj wugurru warrubawi-yung warra-muṉḏugi warra-wurru-wurruj ngayawi-wuy, marri warrubawi-yung ari ambarra-lharrganjii ngayawi-wala wugurru.” ");
INSERT INTO nuy_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Naagi-yung na-Jesus ni-yambini-wugij niga. “Nubagi-yung-maynji na-waḻyinyung ani-waṉagana man.gurrg aladi, marri anubani-yung-maynji nigawi-wala anggu-rabalang, anubani-yung aninggaarruyn nga anggu-yaarri yuuguni a-lhal-aṉḏarrg-baj wugurru, anubani anggu-yaarri nga yagi-maynji lhangarrmi ana-mamanunggu ana-lhal, anggu-yaarri bagu anggu-ḻang-janga-yangina wugurru, anggu-yamang ‘Ngandaagiyn nubagi-wuy na-wurrujung-guy.’ ");
INSERT INTO nuy_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ngijang aḏaba, anggaagiyn nubagi-yung-guy ninggaarruyn-guy na-waḻyinyung-guy wugurru. Anaani wiijamana, nubagi-yung na-wurrujung ni-mamanunggu ana-lhirribala. ");
INSERT INTO nuy_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Anubani-yung ana-man.gurrg wu-warranggana nga wu-wagalhaga-lharrmani marri lhangarrmana aynbaj man.gurrg marang-aynjaabugij marri wulawaa, nga buguni aḏaba wu-yaarri. Anaani ana-man.gurrg yamba waaladi-windiyung, wugurri-wala aynjaabugij-gala mani. Marri anubani-yung wu-ngarra-jaarri, wu-ngarra-jabina, nubagi-yung-guy na-wurrujung-guy, anaani ana-man.gurrg wugurru. Anaani aḏaba niiladi-wina-windiyung niga, anubani-yung yaga wugurru ana-wulhu-wulhurr wurrugu ni-maṉdhini. Yagu waari aḏaba niga.” Dani-yung ni-yambini niga na-Jesus, ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yagu ngiga maṉinyung ngarraagi-yung warru-mandag-duj ngiga anubagu ngi-burri. Nga bagala ngiiḏangi yanggarrwar-mirri, “Ngaadagu nagang ngarriibi nugawi-nyinyung, dagu nga ningi-yabayn, marri ningi-wuynjijgaa ana-mimi anubani-yunggaj. Niga na-God ngaagajij-majgaa ngiga ngarraagi-yung!” ngunu-magayn, ngi-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yagu nigaayung na-Jesus ngu-yambalmayn, “Wiiya aadanu wugurru. Yaani-yung aniij-ḏunggal wu-yamana. Waadurru wurraawanggina-yinyung anubani-yung na-God-jinyung ana-lhaawu, marri ambii-yandhurrbangana-yinyung anaani, burru-yung nga na-God ambaniigajij-majgana wugurru,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Arraarrawindi wurru-wurruj wurru-yanggi, wurru-walangi wugurru. Nga anaani-yung na-Jesus ni-yambini niga. “Nugurru aadanu warra-wurru-wurruj wurru-wiri-mana-yinyung ana-yimbaj, nugurru aadanu nurraalaaladi. Nirri-ngaynbandii nugurru aadanu arrwar-wala yuwaagala malnguj, nambanggu-bajiyina nugurru. Yagu na-God niga yagi nani-yu nugurru. Na-God niga ani-wij-garrarra-gana-wugij anubani-yung yaga nguynju nubagi-yung-jii na-waḻyinyung-jii, na-nimuwaj-jung ni-mayini na-Jonah, wiijamana. ");
INSERT INTO nuy_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Naagi-yung na-Jonah niga ni-yanggi, nga wani-bajiyini anubani-rruj ana-lhal wu-mayini Nineveh, anu…bani-yunggaj. Yagu anaani wiij-nguynju aḏaba, ngaya-waj na-Niwiyayung na-Wurrujung-jinyung, ngaya-waj anamba-bajiyina nugurru warra-wurru-wurruj-guy aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Wurrugu marri ngijang, bani-yung ambani-nguynju-nguynjijgana niga warruburru-yung warra-wurru-wurruj-guy niga na-God, ngarrubagi-yung ngarra-queen ana-lhal wu-mayini Sheba, yaanuwuy wu-lhal-ngu-burri wugurru wagiyaj, ngiga ngarrubagi angi-ḻaḻagiiyn, marri nugurraayung aadanu, numbuu-yagaynjina bagu numburru-burraa ngigawi-rruj. Ngiga ngarrubagi nambangi-lhajbiyn ngiga nugurri-wuy. Wubanila-wala a-lhal-wala ngi-yanggi yuwaagala juju…j-gala ana-lhal, nguynju yadhu niga nubagi ngunu-yaynjangani na-Solomon, naagi-yung yamba ni-yina-mamaaḻang niga. Yagu wugurraayung anaaynbaj yaani, yagu waari na-Solomon ani-runggal-magaa niga nguynju anubani-yung-jii wugurru anaaynbaj-jii. ");
INSERT INTO nuy_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Marri warruburru-yung warra-mulung-arrgi-yung ana-Nineveh-yinyung amburru-ḻaḻagiiyn, marri nugurraayung, numbuu-yagaynjina bagu numburru-burraa wugurri-rruj. Marri bagu nambambi-lhajbumana nugurru. Anaani-yung yamba wurraawanggini wugurru ana-lhaawu na-Jonah-yinyung, anubani-yung wurru-wurrij-biḻibiḻingini aḏaba. Yagu wugurraayung anaaynbaj yaani nga, niga na-Jonah waari-magaa ani-runggal-magaa nguynju yaga anubani-yung-jii wugurru anaaynbaj-jii.” ");
INSERT INTO nuy_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Naagi-yung na-Jesus ni-yambini-wugij niga. “Nugurru-maynji aadanu nimbirri-lhalmbaarrijgana anubani anu-dhalng wu-lhalmbaarrii-yinyung, yuga nimbirri-burrang wubani-wuy a-gara-wuy yuwaagu lhirribala-wuy? Yuga nimbirri-burrdang lhirribala wubama ama-gaṉdharra-rruj? Girrjag! Yuwaagu arrwar nimbirri-wudhang wugurru. Nguynju yadhu anuwagala amburru-yaarri warra-wurru-wurruj marri amburru-yabina-maynji, nguynju ambirri-nayii yungguyung wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Mana-bagaḻang yaga ma-yamana nguynju wu-lhalmbaarrii-yii nugurri-rruj a-ngun.gu-rruj. Nugurri-nyinyung-maynji mana-bagaḻang ama-maṉdhina, yagu anubani-yung numburraarra-nayii arrawindi wugurru. Yagu nugurri-nyinyung-maynji mana-bagaḻang amaaladi, yagu yagi anubani-yung nurraarra-ni. Nguynju yaga wudanu wu-dumana aaladi a-lhirribala nugurri-rruj wudanu-rruj. ");
INSERT INTO nuy_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","“Nugurru yuga nurru-marrbuy anaani? Anubani ana-lhaawu na-God-jinyung, wu-yamana nguynju yaga wu-lhalmbaarrii-yii. Nugurru numburru-dhi-maṉdhina nugurraajbaj aḏaba. Nugurru aadanu numburru-wijangayii marri numburru-marrbuy-windiyung aadanu, anubani ana-lhaawu na-God-jinyung. Yagu ari waari numburru-marrbuy-magaa nugurru, ari nugurru nurru-burraa wubani-rruj aa-ngududumaj-duj aadanu. Numburru-dhi-maṉdhina aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","“Nugurri-nyinyung-maynji ana-ngun.gu aadanu anubani anggandharwina-windiyung-maynji anggu-lhalmbaarrii, yagi anubagu anaa-ngududumaj-duj wugurru yagi miṉmiṉḏi anubagu. Anubani-yung-maynji nugurru numburru-milhiynjina, nguynju yadhu anubani wu-lhalmbaarrii-yinyung anggu-lhalmbaarrii, nugurri-wuy nambanggu-miṉmiṉḏii aḏaba.” Dani-yung ni-yambini na-Jesus, ana-lhaawu anaani-yung. ");
INSERT INTO nuy_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Anubani-yumbaa ni-yambini-wugij niga. Nga anubagu Pharisee-yung nu-yandhawiwandi niga, “Baaṉina, ba-yaarri ngayawi-wuy, nga ngaambu-nguyii marrya ngagurru,” ni-yamayn. Nigaayung na-Jesus ni-yanggi… nga bagu ni-burrangayn wubani-rruj a-marrya-rruj. ");
INSERT INTO nuy_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Naagi-yung na-Pharisee-yung niga nu-nani. “Naagi-yung waari niga ani-marang-jarrbini yagu! Niga ni-wagiwayn anaani ana-lhaawu-runggal na-Moses-jinyung!” ni-yamijgini, ni-yambini nigaajbaj. ");
INSERT INTO nuy_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nigaayung na-Buunggawa ni-yamayn nu-magayn, “Nugurru aadanu warra-Pharisee nuu-yamana aani-yung-jii nugurru. Nugurru nirrima-yarrbumana arabarabalu-rruj nugurri-nyinyung mana-gaṉdharra marri anaaynba-gaynbaj-jinyung. Yagu aadaju ana-lhirribala nugurri-rruj nurru-murruwanjii nugurru. Marri aladi-windiyung wu-burraa, aḏaba waandharwina-windiyung, nugurri-rruj aadaju. ");
INSERT INTO nuy_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nugurru aḏaba aadanu nuu-yilg-balii. Na-God niga ngarrani-maṉdhangi ngagurru, waari-wugij anubani anaarrwaraj. Yagu ngarrani-maṉdhangi ana-lhirribala ngagurri-rruj. ");
INSERT INTO nuy_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nugurru numbunuuyii aadanu na-God-guy marri nambarriiyii warruburru-yung warraarrgi-yung-guy, numburru-lhaal-maaḻang aḏaba, anubani-rruj nugurri-rruj anaandhiri-rruj ana-lhirribala. Anaani numburru-waṉbina-wugij-maynji nugurru, anubani anaarrawindi-lhangu anggu-ngalngalang aḏaba nugurri-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Anaaladi wu-yaarri wu-waṉina aḏaba nugurri-wuy warra-Pharisee-wuy! Anubani-yung-maynji wugurru 10 nurraarra-waṉagana-maynji anaaynba-gaynbaj-jinyung, yagu aynjaabugij nugurru nunuuyii na-God-guy. Wiij-maṉdhina anaani. Yagu nugurru warra-Pharisee aadanu nurru-waṉbina anaani winyig, anubani-yung ana-manjarr, wu-warradii-yinyung anu-bal, anubani nirri-manjarr-mani nugurru nga nirri-manjarr-wuyudii nga nirri-yarina wugurru anaarrawuj-mamaaḻang. Danu nurru-waṉbina nugurru, yagu waari nambarra-man.galagang warruburru-wuy warra-wurru-wurruj-guy, marri waari nugurru numbunu-ngaynbandang na-God niga. Anaani-yung numburru-waṉbina anaani, marri nguynju-waj, anubani-yung ana-mulung-aynbaj anaarrawindi-lhangu.” ");
INSERT INTO nuy_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Na-Jesus naagi-yung ni-yambini-wugij niga. “Anaaladi wu-waṉina nugurri-wuy warra-Pharisee-wuy! Nugurru yamba nirri-ngaynbandii aadanu nurru-yaarri nga nurru-burraa wubani-rruj a-mamanunggu-rruj wubani-rruj a-synagog-duj. Marri narra-ngaynbandii nugurru warrubawi-yung nambambi-magana yungguyung lhaawu-mamaaḻang nugurri-wuy, anubani-rruj nurru-mana-mani-rruj nugurru ana-marrya-rruj, nguynju yadhu warraarrawindi yungguyung nambambi-nayii nugurru, marri amburraan-jamana nugurru yingga nurru-runggal. ");
INSERT INTO nuy_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Anaaladi wu-yaarri wu-waṉina wugurru nugurri-wuy! Nugurru yaga aadanu nguynju yaga wubani aabiyn-jii wu-yamana. Bani yaga waari ambarraabiyn-nang wugurru. Arrbidi yaga wurru-yaarri, warraabiyn-garragarra-wan.ngana wugurru.” Dani-yung na-Jesus ni-yambini. ");
INSERT INTO nuy_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Bagi-yung aynjaabu-nyung niga wani-marrbuy-waa-yinyung ana-lhaawu-runggal, nga bagu nu-yambalmayn nigawi-wuy, nga ni-yamayn, “Barra-marrbuy-wana-yinyung, aadanu nuynjambini wugurri-wuy, warruburru-wuy warra-Pharisee-wuy, yagu bagu-mirri anaani nagang ngunu-lhajbang, nurraayunggaj ngijang anaani,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yagu nigaayung na-Jesus nu-yambalmayn, nga ni-yamayn, “Nugurraayunggaj aadanu, anaaladi wu-yaarri nugurri-wuy, nugurru narra-marrbuy-wana-yinyung aadanu ana-lhaawu-runggal! Nugurru yamba nirriij-maṉdhii wiij-baḏa-waḏaḏ ana-lhaawu marri narrai-magana wugurru ambirri-yandhurrbangana wugurru, yagu nugurru waari nambarra-maṉmang wugurru wurru-waṉbina-yinyung nugurri-nyinyung ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Anaaladi wu-yaarri-wugij nugurri-wuy! Nugurri-nyinyung warra-miyn-ngambara warra-wini wugurru warruburru-yung wunaa-ja-jambini-yinyung niga na-God. Marri wugurri-nyinyung anaabiyn, nugurru manaama-yung nirrima-muṉḏugana aadanu arrwa-garrwar wubami-rruj ama-ṉuga. ");
INSERT INTO nuy_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Anaani wiijamana, nugurru nurru-yambina wudani-yung-jii, nurru-yambina warruburru-yung wurru-waṉbini maaḻamburrg, wugurru warra-wini-yinyung warruburru-yung wunaa-ja-jambini-yinyung na-God. Yigaj! Wugurru warra-wini, yagu nugurraayung, damu nirrima-muṉḏugana nugurru mana-ṉuga. ");
INSERT INTO nuy_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Anaani wiijamana wugurru, na-God na-yina-mamaaḻang-jung ni-yamaa niga, ‘Ngaya anaani ngarra-lharrganjii waadurru ngambii-ja-jambina-yinyung, marri waadurru warra-mulung-aynbaj ngaya ngarra-lharrganjii-yinyung anaani. Marri ngarra-lharrganjii wugurri-wuy warra-wurru-wurruj-guy aḏaba. Waadurru ambarruumana wugurru mulung-arrgi-yung, yagu warra-mulung-aynbaj-guy ambarra-wungarri-dhijgana.’ Dani-yung ni-yambini na-God niga.” ");
INSERT INTO nuy_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Naagi-yung na-Jesus ni-yambini-wugij niga. “Anaani wiijamana, niga na-God nugurru aadanu nambaniigaramang nugurri-wuy, nurru-burraa-yinyung anaani ana-yimbaj, warruburru-yung wunaa-ja-jambini-yinyung anubani-yunggaj, mana-wulang manubama-yung wurraarra-garra-waḻangi wugurru. Anu…bani-yunggaj ana-wulhu…wulhurr-waj wugurru, mana-wulang wurraarra-garra-waḻangi nga ana-yimbaj-dhangu, murrubu, ma-wuguuguni magurru. ");
INSERT INTO nuy_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Mana-wulang yaga nubagi-yung ni-wulang-jirryirrangi yigaj na-Abel yaga, ma-wuguuguni mana-wulang ma-dhililangi magurru, na-Zechariah-wuy. Nubagi-yung yaga wunu-jadugayn niga, wunu-wini a-Temple-Maṉngulg-duj, anubani ana-ḻibiḻibala wugurru gara-maṉngulg-bindiyung, wugurraayung ana-ḻibiḻibala ana-gara, anubani wugurru wurru-nanga-nangaa-yinyung, a-buluynjirri. Yuu, anaani ngana-magana nugurri-wuy aḏaba, anubani-yung na-God nambani-lhajbumana nugurru aadanu nurru-burraa-yinyung ana-yimbaj anaani, amubama-wala ama-wulang-gala.” ");
INSERT INTO nuy_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Naagi-yung na-Jesus ni-yambini-wugij niga. “Nugurru aadanu narra-marrbuy-wana-yinyung wudanu ana-lhaawu-runggal-inyung, anaaladi wu-yaarri nugurri-wuy aadanu! Nurru-marrbuy nugurru anaarrgi-yung ana-lhaawu yuga, nugurraajbaj aadanu numburru-magaynjina nguynju yadhu numburru-marrbuy-waynjina nugurru? Nguynju yaga danu key nirri-waṉagana nugurru, nirri-gara-wawalhijgana-yinyung anu-dhawang. Yagu nugurru nugurraajbaj yagi nurru-rumi, marri ngijang nugurru narra-lhambumana warraaynbaj-guy, warruburru-yung amburru-yaarri-yinyung.” Dani-yung na-Jesus na-nidhaawu-yung, ni-yambini. ");
INSERT INTO nuy_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Anubanila-wala ni-rabaliyn niga ni-yanggi. Nga anubani-yung warra-Pharisee marri warra-yiyini-yinyung ana-lhaawu-runggal wurraandha-wuguuguni-wugij wugurru wurru-wundi, wunu-yambiḻibiḻingaani-wugij niga. ");
INSERT INTO nuy_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Wurraawanggini, nga wunu-yaynjangani-wugij aani a-lhaawu. “Ari naagi niga ani-yambina aladi lhaawu. Bani-yung marri niga ngaanu-lhajbiyn,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Arraarrawindi-windiyung garnyirrimba wurru-wurruj wurru-yanggi nigawi-wuy na-Jesus-guy, wurru-muṉḏugaa. Warraawurru-yung wugurru arraarrawindi yamba anubani wurru-burri, arrbidi wugurru wurru-mun-garra-garra-wan.ngaynjini. Yagu nigaayung na-Jesus wani-magayn warruburru-yung wurru-marrbuy-maa-yinyung-guy, burru-yung-bugij. Wani-magayn, “Numburru-dhi-maṉdhina aadanu. Yagi nugurru nurru-yami waadurru-yung-jii warra-Pharisee-yii. Waadurru yamba wugurru wuu-lhama-lhamina, marri wugurraajbaj wurru-mamanunggu-wina wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Anaarrawindi-lhangu anubani-yung wu-julubina-yinyung, wurrugu marri anggiij-garrarra-mang wugurru. Marri anaarrawindi-lhangu anubani-yung wu-miḏaamimi anaani amburru-marrbuy-dhina wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Numburru-yambina-maynji nugurru anubani-rruj anaangamangamug-duj, aadanu amburraawanggina marri, aadanu anggiij-garrarra. Marri anubani-yung-maynji numbuu-lhagar-yamba-yambina-maynji anubani-rruj wiij-mamarrina-yinyung anubani-yung, wurrugu marri yuwaagala wugambara-wala a-wumurrng-gala, bagala nga amburraaḏii wugurru.” ");
INSERT INTO nuy_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Naagi-yung na-Jesus ni-yambini-wugij niga. “Guwaj-gaang, anaani ngana-magana nugurri-wuy. Yagi nurru-ḏirrngawi warra-wurru-wurruj-guy. Warruburru ari nambambii-bumana ana-ngun.gu yagu anubanila yagi wurru-waṉbi anaaynbaj. ");
INSERT INTO nuy_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ngaya anaani ngana-magana aḏaba nugurri-wuy, nubagi-yung niga na-God numbunu-yamana ari. Nubagi-yung ari nambaniimana, wurrugu marri malgadhaadharri nubagi-yung ari nambani-barawudii a-ngura-wuy. Yuu nga, anaani ngana-magana aadanu nugurri-wuy, bagi-yung-bugij nga, nugurru numbunu-yamana niga. ");
INSERT INTO nuy_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Numburru-mani-maynji ana-marang-aynjaabugij ana-ngurudhu, yagu anubani-yung aynjaabugij winyig wuṉuga. Yagu na-God niga niigajijangayii wugurru ana-ngurudhu, aynjaaynjaabugij-gaj. Waari ani-warandhalabang niga. ");
INSERT INTO nuy_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Numburraawanggina aḏaba, na-God niga ni-marrbuy manaama mana-mung ngagurri-rruj marri anaani-rruj ana-yinag-duj, aynjaaynjaabugij-gaj. Yagi nurru-ḏirrngawi nugurru. Anubani-yung ana-ngurudhu, na-God ni-ngaynbandii niga. Nga yagu nugurraayung aadanu niga nani-ngaynbandii runggal-windiyung niga, waari nguynju yaga anaarrawindi ana-ngurudhu-yii.” ");
INSERT INTO nuy_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Naagi-yung na-Jesus niga-waj ni-yambini-wugij. “Anaani ngana-magana nugurri-wuy, nugurru-maynji ngirrii-jambina ngaya warra-mulung-arrgi-yung-guy, wurrugu marri anaani nganaa-jambina nugurru, ngaya anaani-yung na-Niwiyayung na-Wurrujung-jinyung, nganaa-jambina nugurru, nga-magana anubani ana-angel nigawi-nyinyung na-God-jinyung. ");
INSERT INTO nuy_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yagu nugurru-maynji nambarra-magana-maynji warra-mulung-arrgi-yung-guy, numburru-yamana ‘Nubagi niga ngaya nga-maḻaḻadi’, wurrugu marri bani-yung ngaayung nga-magang anubani ana-angel, ngaynjamang ‘Waadurru ngaya nga-maḻaḻadi’. ");
INSERT INTO nuy_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Warraaynbaj-maynji wugurru ngaya ngambiiladi-yamawana, God niga-waj ambaniigajij-garruyn wugurru. Yagu nubagi-yung-maynji na-wurrujung niga ani-waladi-yamawana-maynji anuwaani ana-Maṉngulg Mawurr, waari na-God naagajij-garru niga nubagi-yung. ");
INSERT INTO nuy_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nugurru aadanu ari nambambi-yarrijgina aḏaba, nga yuwaagu ari nambambi-burrii wubani-rruj a-synagog-duj, nguynju yadhu wugurraayung warruburru-yung warra-mijiwanggu warra-Jew ari nambambi-lhajbumana nugurru. Yagu ari nambambi-yarrijgina warruburru-wuy warra-bu-buunggawa-wuy wugurru. Yagu anubani yagi nirriijanga-yangi, marri nurru-wijangi, ‘Yuga yangi ngamba-yambalmang warruburru-wuy? Yangi ngaynjambina?’ Yagi nurru-yami nugurru aadanu. ");
INSERT INTO nuy_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Yaani yamba ngaya Maṉngulg Mawurr nambanggu-yiyina aḏaba, anubani-yung-maynji nugurru numburru-yambina, anubani-yung nambangguuyii nugurru anggu-mamanunggu ana-lhaawu.” Dani-yung ni-yambini na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Aynjaabu-nyung bagu wurrujung warruburru-rruj warra-mandag-arrawindi-wala, bagala nga ni-ḻaḻagiiyn, nga nu-yamijgayn nigawi-wuy, “Barra-marrba-marrbuy-wana-yinyung, ngaya na-baba niga nuuni nubagi-wuy ngayawi-wuy naa-murruyung, ana-ngurrji niga, anubani-yumbaa niga ni-ngawiiyn-maynji, nubagi na-yiwanggu-nyung. Nga banu-magana aḏaba naagi-yung naa-murruyung, nguynju niga yaga nganiiyii arrgi ana-ngurrji.” Dani-yung niga nu-yamijgayn na-Jesus-guy. ");
INSERT INTO nuy_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yagu nigaayung na-Jesus nu-magayn nigawi-wuy nubagi-wuy, “Guwaj, ngaya anaani yagi ngunu-nguynju-nguynjijgi aadanu. Yagi yamba ngaya nga-wij-maṉdhi aadanu nugawi-wuy.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Marri wani-magayn warruburru-wuy warra-wurru-wurruj-guy, “Numburru-marrbuy-mana aḏaba anaanila-wala aḏaba, marri numburru-dhi-maṉdhina nugurru. Yagi nugurru anubani nurraarra-ngaynbandi anubani-yung warra-mulung-arrgi-yung-jinyung anubani-yung ana-ngurrji. Yagu nubagi-yung-maynji na-wurrujung-jinyung anubani-yung ana-wiri, waari anubani-yung anggu-nguynju-magaa anaarra anubani-yung ni-warra-waṉagana-yinyung.” Dani-yung ni-yambini na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Marri wani-magayn wugurru anaani-yung wiij-bulawaa-wala ana-lhaawu. “Nubagi-yung naambalalijung, niga niwu-waṉagaa aban-mamaaḻang, anubani arrawindi waarraanuynjungini ana-marrya anu-bal-uj. ");
INSERT INTO nuy_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nga nubagi-yung na-wurrujung niga ni-wijangani wurrugu, ‘Yuga anaani ngaya ngaynjaminggarrang anaani? Yuga ajiga-rruj nganggaarra-ngu-burrang-jinyung ana-marrya, anaani wu-warra-ngu-burraa-yinyung, ngaya ngaarra-waṉagana-yinyung? Wu-winyig yamba anaani wugurru ana-wumurrng ngayawi-nyinyung,’ ni-yamayn niga. ");
INSERT INTO nuy_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","‘Yaani wurrugu nganggaṉbina ana-wulhu-wulhurr. Marri wugurraayung nganggu-ngarrgiwana anubani ana-wumurrng. Marri nganggu-rayii runggal-windiyung ana-wumurrng, wu-gadhuwa. Nguynju yadhu ngangaarra-ngu-burrii buguni ana-marrya marri ngayawi-nyinyung buguni anaarra, anggu-warra-ngu-burraa yadhu. ");
INSERT INTO nuy_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Marri ngaynjamang ngaya nga-magina ngayaaj-baj, ngaynjamang, Ngaya ngaarra-waṉagana arrawindi aḏaba ana-ngurrji, marri arrawindi yadhu anaagalhal-aḻirr, anggu-warra-ngu-burraa. Ngaya ngaynjanga-yangina aḏaba. Nga-nguyii marri nganggaaḻ-nguyii marri nganggaḻaaḻarrii.’ Dani-yung ni-yamaa na-wurrujung niga. ");
INSERT INTO nuy_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Yagu na-God nigaayung ni-yamayn nigawi-wuy, ‘Nagang aadanu nuynjilg. Yagu nagang waajarina ana-wiri nugawi-wala, ana-yimbaj manaami-rruj mana-miyn.nganga. Marri aadanu nunggaarra-waṉagana-yinyung, marri yangi-nyung amburraarra-waṉagana aadanu?’ Dani-yung ni-yamayn na-God.” ");
INSERT INTO nuy_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Na-Jesus niga ni-magini-wugij. “Warrubawi-yung-maynji warra-wurruj amburraarra-waṉagana-wugij-maynji anaarrawindi anaarra, marri yagi wugurru waambalal-gi aniijgubulu na-God-guy, anubani-yung warrubawi-yung amburru-nguynju nubagi-yung-jii naambalal-yung-jii.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Anubani-yung ngijang na-Jesus niga wani-magaa warruburru-yung nigawi-nyinyung wurru-marrbuy-maa-wuy, “Ngaya ngana-magana nugurru, yagi nurraarra-yangi ana-marrya marri nurraarra-yabina-yinyung yagi nurraarra-yangi. ");
INSERT INTO nuy_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yagu nugurri-nyinyung yamba ana-wiri wu-runggal-wina aadanu. Waari ana-marrya-yii anggu-yamang yamba wugurru. Marri nugurri-nyinyung ana-ngun.gu mana-yaaḻi-yii waari anggu-yamang wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Numburru-wijangayii yaga yiibagi yii-warbarg. Niga waari aniwu-wanuynjungang anu-ḏal. Waari nubagi ani-rumang ani-muṉḏugang anubani ana-marrya. Waari aniwu-waṉagang ana-wumurrng, anubagu ani-warra-yabijgang yungguyung aadanu ana-marrya. Yagu God niga-waj ni-marrya-wuyii. Yagu ni-wijangayii niga nugurri-wuy, nugurru nurru-runggal, waari anubani-yung-jii ana-ngurudhu-yii, numbuu-yamang. ");
INSERT INTO nuy_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nugurru nurru-ramarr-ruwi-ruwina-maynji, yuga nugurru numburru-burraa malanga-baḏag aadanu, nugurri-nyinyung-mirri ana-wiri? Girrjag nga! ");
INSERT INTO nuy_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yagu anubani-yung winyig-bindiyung, yagu yagi anubani nurru-waṉbi aḏaba. Yuga a-yangi yungguyung nugurru nirriijanga-yangayii anubani-yung aniij-ḏunggal aadanu?” ");
INSERT INTO nuy_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Na-Jesus naagi-yung ni-yambini-wugij. “Numburraawanggina wubani wu-lhababidii-yii a-maḏa yaga. Waari anubani anggu-mijgalmiyn wugurru, yagu maṉdhang magurru waari mana-yaaḻi. Anaani ngana-magana, nubagi-yung na-runggal-yung na-king na-Solomon niga, manaama-yung nimaarra-waṉagaa mana-yaaḻi mamanunggu-yinyung. Yagu waari ama-mamanunggu-magaa wubani-yung-jii yaga wu-lhababidii-yii a-maḏa. ");
INSERT INTO nuy_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ana-maḏa anaani wu-lhababidii ana-yimbaj, marri wurrugu wu-ngawina aḏaba, marri wirri-barawudii wubani-wuy a-ngura-wuy. Yagu God niga-waj niini nguynju amudamu-yung-jii ama-yaaḻi-yii. Yijgubulu-windiyung nambaniiyii manubama-yung mana-yaaḻi nugurri-wuy. Yagu nugurru waari numburru-jambarrgiiyn-bindiyung aadanu. ");
INSERT INTO nuy_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Yagi nugurru nurru-wurrij-galadi-wi, anubani-yung ana-marrya yungguyung, aniga-yung yuga numburru-nguyii, yagi nugurru nurru-wiji-wijangi ana-marrya-wuy, yagu anaa-gugu-wuy, marri nurru-ramarr-ruwi-ruwi yagi. ");
INSERT INTO nuy_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Warruburru-yung warraarrawindi waari-yinyung amburru-jambarrgiyn-jinyung na-God-guy, warruburru-yung wugurru wurru-rama-ramarr-ruwi-ruwina-wugij, wubujumbaj a-marrya-waj, wurraandha-wuguuguni-wugij wugurru. Yagu nugurru aadanu yagi nurru-yami wugurri-yii. Nugurri-nyinyung na-Baba niga ni-marrbuy anaani ana-marrya nurru-ngaynbandii-yinyung nugurru. ");
INSERT INTO nuy_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nugurru numburru-wuguuguni-wugij numburru-wijangayii na-God-jinyung nambani-magana-yinyung niga, marri niga nambaniiyii anubani-yung nurraarra-ngaynbandii-yinyung, anubani anaarrawindi-lhangu.” ");
INSERT INTO nuy_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Naagi-yung na-Jesus ni-yambini-wugij niga. “Nugurraaj-bugij nga nurraadharra aadanu, yagu yagi nurru-ḏirrngawi aadanu. Nugurri-nyinyung na-Ninyarra niga nani-rangarrii nugurru, nigawi-nyinyung aadanu warru-mandag. Aadanu niga ni-waḻaaḻarrii, anubani-yung nambanii-gaṉbina-yinyung nugurru. ");
INSERT INTO nuy_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nugurru numburraarra-waṉagana-maynji, yagi nurraarra-waṉagi nugurraa-mirri, yagu nambarriiyii warruburru-yung-guy warraambalalari-wuy. Bani-yung marri, numburraarra-waṉagana nugurru arrawindi arraambaḻaman-jinyung anuwaani anaarrwar. Yagu anaaji anaaban-duj danu yaga big wirri-yaba-yabijgana-yinyung a-wuṉuga, manubami-yung-maynji ama-nungguḏaaba-dhang, marri anubani amaarra-ḻaḻma-ḻaḻmana magurru. Yagu magurraayung anuwaani anaarrwar mana-big-maynji nimbirrima-waṉagana ama-burraa, manubama-yung yagi maarra-ḻaḻma-ḻaḻmi magurru. Ama-yamana-wugij ama-burraa amaama-magaa-wugij. Nubagi-yung ni-wamaamajaa-yinyung niga yagi anubuguni ni-rumi ni-wamajangi. Marri ana-lhalawag yagi anubuguni wu-rumi, anubagu wi. ");
INSERT INTO nuy_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Numburraambalal-gina-maynji anaani-rruj ana-lhal, nugurri-nyinyung nurru-wijangayii-yinyung marri nurraaṉbina-yinyung yaaju-wugij anggu-warra-ngu-burraa, yagu yagi na-Baba-rruj anaarrwar.” ");
INSERT INTO nuy_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Naagi-yung na-Jesus ni-yambini-wugij niga. “Nugurru numburru-dhi-maṉdhina aḏaba. Wurrugu ngaya ngandaagiyn-maynji, nguynju yungguyung yagi nurru-wurri-ḻaḻmi ngaya. Anaani wiijamana, nguynju yaga warruburru wurru-mijgalmina-yinyung, wugurru wurraarraalgaalgurmani. Anubani yaga wu-lhalmbaarrii-yinyung, wirri-lhalmbaarrijgana wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Anaani wiijamana. Aynjaabu-nyung yaga waḻyinyung ni-yanggi wubani-wuy wurru-nguni-yinyung a-marrya yaga. Yagu warruburru-yung wurru-mijgalmini-yinyung wurrugu wunu-rangarrangi niga. Wurrugu marri niga anubani niwu-waḏbaḏiyn anu-dhawang-duj anuwaagu. Nga wugurraayung wirri-gara-wawalhijgayn anubani lhugaajgiyalawaj wugurru. Nugurru aadanu, numbuu-yamana, numburraambu-narrina-wugij wurrugu. ");
INSERT INTO nuy_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nubagi-yung-maynji na-waḻyinyung anubani-yumbaa niga ani-yaarri, warruburru-yung-maynji amburru-wanggirraa-maynji marri ambunu-rangarrii niga, marri bani-yung ani-waḻaaḻarrii niga nubagi-yung. Anaani ngana-magana yijgubulu ngubindi, niga-waj ani-yabiyn maadamu mana-yaaḻi nguynju yadhu anubani ani-mijgalmina niga. Niga-waj aḏaba ambani-magana, ‘Nugurru-waj aadaju numburru-biḻaj-gudhangang aḏaba.’ Niga-waj ambaniiyii aḏaba anubani ana-marrya marri niga-waj nubagi ambani-rangarrii wugurru! ");
INSERT INTO nuy_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","“Yagu nubagi-yung na-waḻyinyung niga ani-yaarri miyn.giyn.gurarra yagu yuwaagala anggu-biyarrarramana-wala aḏaba. Warruburru-yung-maynji wugurru amburru-wanggirraa, yagu anubagu ambani-lhangarrmang nubagi-yung, ani-waḻaaḻarrii niga warruburru-wuy, nga warruburru-yung wugurru wurru-mijgalmina-yinyung yamba.” ");
INSERT INTO nuy_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Naagi-yung na-Jesus ni-yambini-wugij niga. “Nugurru anaani numburraawanggina aḏaba. Anaani wiijamana. Nubagi-yung ni-wamaamajaa-yinyung yagi niga nani-magi, lhal-ngargu ari anubuguni ani-yaarri nga aniwu-wagiwana nugurri-nyinyung ana-wumurrng. Niga-maynji nambani-magana-maynji nugurru, anubani-yung numburru-wanggirraa-wugij, numburru-burraa anubani-rruj nugurri-rruj anaanga-rruj. Yagu yagi-maynji niga nani-magi aniijgubulu, nugurru numburru-maḻaḻadi aadanu lhal-ngargu ari ani-yaarri niga. ");
INSERT INTO nuy_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","“Anaani wiij-nguynju aḏaba, ngaya na-Niwiyayung na-Wurrujung-jinyung, ngaynjaarri, nurru-maḻaḻadi lhal-ngargu ari anubani ngandaagiyn ngaya. Numburru-yamana nugurru numburru-burraa, numburru-wanggirraa. Numburru-burraa, ngirrii-garranggana ngaya.” Dani-yung ni-yamaa na-Jesus, ni-magini niga. ");
INSERT INTO nuy_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nigaayung na-Peter ni-yamayn, “Buunggawa yuga aadanu nagang nimba-magana nurru wiij-bulawaa-wala, yagu nurraa-wugij aadanu, yagu warraarraarrawindi-wuy?” Dani-yung ni-yamayn nigaayung nu-yambalmayn. ");
INSERT INTO nuy_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nigaayung na-Buunggawa ni-yamayn, “Anaani wiijamana. Nugurru numburraawanggina aḏaba. Yangi-nyung yuga nubagi-yung na-waḻyinyung ni-mijgalmina-yinyung, marri ni-jambarrgina-yinyung niga, marri na-yina-mamaaḻang-jung niga? Nubagi-yung na-runggal-yung niga anu-magang, nubagi-yung ni-mijgalmina-yinyung, nguynju yadhu ambani-rangarrii yungguyung niga, warruburru-yung warra-mulung-arrgi-yung wurru-mijgalmina-yinyung anubani-rruj-jinyung ana-wumurrng. Marri nubagi ambaniiyii ana-marrya niga maaḻamburrg-galawaj. ");
INSERT INTO nuy_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Wurrugu nigaayung naabalijung ani-yaarri, nga ambani-nayii warruburru wugurru wurru-mijgalmina-yinyung. Nubagi-yung-maynji ani-mijgalmina-yinyung niga ani-waṉbina maaḻamburrg-galawaj, nubagi-yung naabalijung niga nubagi-yung ani-waḻaaḻarrii, marri anaagajij-majgana niga. ");
INSERT INTO nuy_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","“Anaani ngana-magana windiyung nugurru, nubagi-yung na-runggal-yung anu-magang-maynji, nubagi na-wurrujung, nguynju yadhu ani-warra-rangarrii anubani ani-warra-waṉagana nubagi na-runggal-yung niga. ");
INSERT INTO nuy_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Yagu nubagi-yung-maynji niga ani-mijgalmina-yinyung ani-yamijgina niga, ‘Nubagi na-runggal-yung aniigiyn-maynji, yagu ani-jirrmiṉḏidhang niga aḏaba, nga ani-walang wurrugu marri,’ dani-yung niga ani-yamana, marri ambaniimana-maynji warruburru-yung-guy warraaynbaj-guy wurru-mijgalmina-wuy, warra-waḻya-waḻya wugurru marri warra-maṉaṉung, marri ani-nguyii-maynji nubagi-yung marri ani-bungurru-dhang-bindiyung niga, ");
INSERT INTO nuy_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","anubani-yung niga ani-maḻaḻadi lhal-ngargu nubagi-yung na-buunggawa aniigiyn. Ngarrubagi-yung ngiga ngarraaḻirr lhal-ngargu marri, aniigiyn niga? Nubagi-yung niga anu-guldhang nguynju warruburru-yung-jii yaga waari-yinyung amburru-jambarrg-mang, marri anu-barawudang wugurri-wuy niga.” ");
INSERT INTO nuy_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Na-Jesus naagi-yung ni-yambini-wugij niga. “Yagu nubagi-yung anaa-maa-mijgalmina-yinyung niga ani-marrbuy-maynji nubagi-yung niga na-buunggawa-yung nu-ngaynbandii-yinyung, yagu yagi-maynji niga naa-gaṉbi nubagi-yung-guy na-buunggawa-yung-guy, yagu yagi-maynji nu-narri niga na-buunggawa-yung, yagu nubagi ambunu-lharrbadjii niga rangag-mirri, malgarrawindi niga. ");
INSERT INTO nuy_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yagu nubagi-yung-maynji anaa-maa-mijgalmina-yinyung niga nubagi-yung ani-maḻaḻadi-maynji, yagu anubani ani-waṉbina aladi yagu anubani-yung ani-maḻaḻadi-wina yamba niga, marri amburru-yaarri ambunuumana anggu-mal-bulaynbaj-gala niga. Na-God-maynji niga nambani-magana nugurri-wuy, numbunaa-mijgalmina yungguyung, anubani-yung numburru-waṉbina nugurru, numburru-mijgalmina maaḻamburrg-galawaj nigawi-wuy. Ari nambani-magana niga, numbunaa-mijgalmina runggal-windiyung nugurru. Anubani-yung numburraaṉbina nugurru, yagu numbunu-yandhurrbangana, niga yamba nani-magaa nugurri-wuy.” Dani-yung ni-yamaa na-Jesus, wani-magaa ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Marri ngijang ni-yamayn niga, “Anaani nga-yanggi yaanuwuy, nguynju yadhu wugurru nganggu-jadugang anubani anaaladi. Anaani wu-yamana nguynju yadhu nganggu-barawudang anubani ana-ngura aani-wuy aaban-guy. Anaani ngawu-ngaynbandii ngaya anubani wugurru anaaladi nganggu-nangana ngaya. ");
INSERT INTO nuy_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yagu wurrugu, raga-ragij-gaj, anubani runggal-windiyung aladi anggu-waṉina ngayawi-wuy wugurru. Ngaya anaani nga-wurrij-galadi-wina-wugij, aadani-yung yamba anaaladi waari anggu-jadugini wurrugu. ");
INSERT INTO nuy_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Nugurru aadanu yuga nurru-wijangayii nugurru ngaya nga-yanggi aani-wuy a-lhal-wuy nguynju yadhu numburru-lhambaamburrg? Waari. Anaani ngana-magana nugurru yijgubulu, anaani nga-yanggi anaani nganamba-rajaarrijgana nugurru. ");
INSERT INTO nuy_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Anaanila-wala, anaani anggiijamana, warraawurru-yung marang-aynjaabugij-maynji warruburru-yung amburru-burraa wugurru, yagu anubanila-wala ngamba-rajaarrijgana, ari amburru-wulaynbaj yuuguni, wugurraayung ambini-wulawaa yaanuwuy wuguṉiiyung. Yagu ari ambini-wulawaa yuuguni ambini-yaarri, wugurraayung amburru-wulaynbaj yaanuwuy, amburraabalguyungaynjina yamba wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","“Anubani-yung amburru-mulu-ḻibawiiyn, ambuu-dhalbaarriynjang wugurru. Na-ninyarra-yung niga yuuguni ani-waḻgaḻ, yagu nigaayung na-niwiyayung yaanuwuy, ani-waḻgaḻ. Yagu na-niwiyayung niga yuuguni, niga na-ninyarra-yung yaanuwuy. Ngarriibi-yung ngiga yuuguni angi-yaarri, ngigaayung ngarra-ngarrimarayung yaanuwuy angi-yaarri. Yagu ngarra-ngarrimarayung ngiga yuuguni, ngigaayung nga-rriibi-yung yaanuwuy. Ngarrubagi-yung ngarra-maṉinyung nga-rangan.ngarri-yung yuuguni, marri ngigawi-nyinyung nga-rangan.ngarri-yung yaanuwuy.” Dani-yung ni-yambini na-Jesus niga, ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Anaani-yung wani-magaa niga warruburru-wuy warraarrawindi-wuy warra-wurru-wurruj-guy, “Nugurru-maynji nimbirri-nayii anubani ana-ngubunung, wugurru anggu-rijbina, anaajila anaarrgaḻila, anubani-yung lhugaajgiyalawaj nugurru numburru-yamana ‘Anaanila aḏaba aṉbana anggu-warra-rabang.’ Marri ngubindi, anaani anggu-warra-rabina wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ana-wudhanguyn-maynji anuwagala anggu-wayamani wugurru ana-wagiyangu, yagu anubani-yung numburru-yamana ‘Anggaa-murrmbulii wugurru’. Marri anggu-waṉbina aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nugurru yamba aadanu nurru-lhama-lhamina! Nurru-marrbuy aadanu nugurru anubani ana-wumala marri anaani anaaban-duj. Yagu waaṉbina-rruj-jinyung wugurru anaani-rruj ana-yimbaj, yuga yagi nurru-marrbuy-mi anaani nugurru? ");
INSERT INTO nuy_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nugurru aadanu numburru-wijangayii nugurraajbaj, aniga-yung aniij-mamaaḻang. Anaani wiijamana. ");
INSERT INTO nuy_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Warraaynbaj-maynji nagang warrubawi-yung ambi-lhajbiyn, nga nagang ambi-yarrijgiyn nubagi-wuy wani-nguynju-nguynjijgana-wuy, anubani-yung-maynji nimbini-yaarri, nga bagu-mirri nagang banu-yandhawiwana nigawi-wuy, nubagi niga nini-lhajbang-jinyung nagang, nga banu-yambina yaynjaalul-mirri nagang. Nimbini-yambiynjang nagang, aniga-yung anggiij-maṉdhiiyn wugurru. Anubanila aniirruyn niga, ani-yaarri. Yagu yagi-maynji nunu-guwaj-gi, nagang aniiyn nubagi na-runggal-yung-guy a-court-duj, marri nubagi na-runggal-yung aniiyn nubagi wani-radba-radbumana-yinyung, marri nagang nubagi wani-radba-radbumana-yinyung ani-burrang wu-dhi-dhidina-rruj. ");
INSERT INTO nuy_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ngaya ngunu-magana yijgubulu-windiyung, yagi nuṉḏabali, murrubu bambiiyii ana-bayarra, bawu-jadugang nugawi-nyinyung anubani anu-ṉuga anaarrawindi-lhangu.” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ngarrubagi-rruj ngarraaḻirr, warraawurru warra-wurru-wurruj wurraanggarra-yanggi-yinyung niga naagi-yung na-Jesus, wunu-magaa niga, nga wurru-yamayn, “Nu-marrbuy yuga nagang warruburru ana-Galilee-yinyung, wurru-yanggi yuuguni Jerusalem-guy anubani-yunggaj, nga anubani ana-bulugi wunuuni nigawi-wuy na-God-guy, wurru-nangaa wugurru? Yagu nigaayung naadagu na-Pontius Pilate wani-lharrgandi wugurru warruburru wurru-wiynji-wiynjini-yinyung, warruburru-wuy warra-wini waadurru-yung warra-wurru-wurruj ana-Galilee-yinyung, nga aḏaba wuu-lhagarra-ngawini wugurru.” Dani-yung wurru-yamaa wugurru, yaani-yung ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yagu nigaayung na-Jesus wani-yambalmayn niga, “Warruburru warra-wurru-wurruj ana-Galilee-yinyung, dani-yung nga wugurru wurraarragayangi. Yuga nugurru nurraawanggini warruburru wugurru wurraalaaladi runggal-windiyung, warruburru-yung, waari yaga nguynju warruburru warra-mulung-aynbaj yaga ana-Galilee-yinyung wurru-burraa wugurru? ");
INSERT INTO nuy_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Yagu ngaya anaani ngana-magana nugurri-wuy, waari nga. Yagu nugurru-maynji aadanu waari nirriij-garru aniij-galaaladi aadanu, ari numburru-jadugiiyn aḏaba aadanu nguynju yaga warruburru-yung-jii. ");
INSERT INTO nuy_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Marri nugurru nurru-marrbuy, anubani-yumbaa manubama-yung wirrima-muṉḏugaa mana-ṉuga marri nga arrwiyaj maambara-yarrmayarrmaj magurru yuwaagu, anubani-rruj ana-lhal anu-muwaj wu-mayini Siloam, manubama-yung ma-rabini magurru nga bagu wurru-burri 18 warruburru-yung, wama-mulhiyn, wuu-lhagarra-ngawini warra-wurru-wurruj wugurru. Warraawurru-yung 18, yuga nugurru nurraawanggini waadurru-yung yuga wurraalaaladi-windiyung, waari nguynju yuga warruburru-yung-jii warra-mulung-arrgi-yung-jii anubani-rruj ana-Jerusalem-duj yaga? ");
INSERT INTO nuy_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Anaani ngana-magana wugurru, waari-windiyung. Yagu yagi-maynji nugurru aadanu nirriij-garru aniij-galaaladi, na-God nambani-jadugang aadanu nugurru, nguynju warruburru-yung-jii yaga.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Anaani-yung bagu nga niga wani-magaa wiij-bulawaa-wala wugurru. “Naagi-yung waḻyinyung niga nimaanuynjungaa nunganyang nigawi-rruj wubani-rruj aaban. Naagi-yung ni-yanggi nga nimaagalhaga-lharrmangi ama-mangugulmung. Yagu waari niga anima-lhangarrmaa. ");
INSERT INTO nuy_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nga nubagi nu-yamijgayn nu-yandhurrbangaa-yinyung niga, nubagi-yung nima-rangarrangi-yinyung manubama-yung mana-nunganyang, ‘Anaani-yung nga-yanggi wulaynbaj-gala anaagalhal-aṉbana. Yagu waari ngaya ngama-gulmung-dhangarrmang ngijang amaarradangi magurru. Bama-wal-wuldhii aḏaba. Manaama arrbidi ma-wal-lhara yamba magurru anaani-rruj anaaban-duj,’ ni-yamayn niga. ");
INSERT INTO nuy_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Yagu naagi-yung nigaayung nu-yandhurrbangaa-yinyung ni-yamayn nu-yambalmayn, ‘Buunggawa, manaama ama-burraa bamaarruyn anaani-rruj anaagalhal-aṉbana yaaji-wugij ama-burraa. Manaama ngama-jang-ḏiganjii marri daju ngama-muṉḏugana magurru mana-manure. ");
INSERT INTO nuy_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Wugurraayung anaaynbaj-duj-maynji anaagalhal-aṉbana, maadamu waṉagana mangugulmung aḏaba. Yagu yagi-maynji magurru, bani-yung marri nimba-magang, marri nga ngama-wal-wuldhii aḏaba.’” Dani-yung na-Jesus anaani-yung ni-yambini ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Anubani-yumbaa ngarrubagi ngarraaḻirr-maṉngulg ngarraaḻirr, anaani-yung ni-yanggi buguni, nga wani-magaa wubani-rruj a-synagog-duj. ");
INSERT INTO nuy_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ngarraagi-yung bagu ngi-burri maṉinyung. Ngarraagi-yung ngi-lhangurrngang ngiga ngi-waṉagaa man.gurrg ngigawi-rruj. Ngarraagi-yung ngi-burri ngi-waṉagaa 18 anaagalhal-aṉbana. Ngarraagi-yung ngi-janda-wulun-gulundangi-wugij, nga ngiga waari angi-janda-lharraalhangi ngarraagi-yung. ");
INSERT INTO nuy_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yagu na-Jesus ni-warranggayn nga ngu-nayn. Marri ngaa-gaḏiyn ngigawi-wuy, nga ni-yamayn, “Maṉinyung, aḏaba nagang nundaarrbidi aadanu ana-wudhangurrg-gala, nunggaarruyn aḏaba.” ");
INSERT INTO nuy_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Marri ni-marang-ngu-burrangayn ana-marang ngigawi-rruj, ngu-waṉagayn. Nga anubani-yung lhugaajgiyalawaj ngiga ngi-lharraalhiyn, nga ngi-malayn-baḏa-waḏaḏ-mayn ngiga. Marri ngunu-warraarriwaa nigawi-wuy na-God-guy. ");
INSERT INTO nuy_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yagu nubagi-yung na-waḻyinyung ni-buunggawa-maa-yinyung niga ana-synagog-duj anubani-yung, naagi-yung ni-yambini yang-bungu-wungarri-mirri, anaani-yung yamba Jesus yamba dagi-yung ngu-maji-waa ngiga anubani-rruj ngarraagi-yung ngarraaḻirr-maṉngulg-duj. Nubagi-yung niga na-waḻyinyung wani-magayn warruburru-yung-guy warra-wurru-wurruj-guy, “Anaani ngagurru ngurru-mijgalmina yamba marang-aynjaabugij marri jarranggay ngarraagi ngarraaḻirr-uj. Anaani yamba wiij-maṉdhina. Nugurru aadanu numburru-yaarri yirraagi-rruj yi-waḻirr-uj, bani-yung marri nga numburru-maṉdhina nugurru. Yagi ngarraagi-rruj ngarraaḻirr-maṉngulg-duj ngiga.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yagu nigaayung na-Buunggawa nu-yambalmayn, nga ni-yamayn, “Nugurru aadanu nurru-yaal-arrawindi aadanu! Ngarrubagi-rruj ngarraaḻirr-maṉngulg-duj, nugurru nurru-waḻa-ḏadbumana-yinyung aḏaba ana-bulugi marri ana-dunggi marri aadanu aḏaba numburraarra-lharrina wugurru. Aḏaba marri numburraarra-yarrijgina yuuguni numburraarra-lhamunu-warrgina marri yuuguni aa-gugu-wuy numbuu-yarrijgina wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Anaani wiijamana wugurru, nguynju yaga ngarrubagi ngarra-ngarriwiyayung na-Abraham-jinyung, nguynju yaga nubagi na-baḏirrnya-yung ngu-radbini anaani-yung 18 anaagalhal-aṉbana ngiga. Yuga anaani wiij-maṉdhina yuga, ngiga ngarraagi angi-muḻugu-mang, ngigaayunggaj yuga, ngarraagi-rruj ngarraaḻirr-maṉngulg-duj?” Dani-yung ni-yamayn niga, ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wugurraayung warruburru-yung wunaabalguyungaa-yinyung niga, anaani-yung wurraambuliyn-bindiyung, anaani-yung-gala ana-lhaawu ni-yambini-wala niga. Yagu wugurraayung warruburru-yung warraarraarrawindi anaani-yung wuu-ḏinggini-windiyung wugurru, anaani-yung-gala wu-mamanunggu-windiyung yamba wugurru ni-waṉbini-yinyung niga. ");
INSERT INTO nuy_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Anubanila-wala, anaani-yung ni-yambini na-Jesus niga. “Warruburru-yung yuga warru-mandag wugurru na-God-jinyung, wurru-yaminggarrina? Yuga yangi-mirri aadanu ngaya ngambaagajij-nguynju-nguynjijgana ngaya? ");
INSERT INTO nuy_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Warruburru-yung wurru-yamana nguynju a-winyig wuḏal, wubani wu-mayini mustard. Anubani-yung nubagi na-wurrujung ni-ral-miyn nga ni-ral-yarrijgini nigawi-wuy wubani-wuy aaban-guy marri ni-ral-wurrdhangi. Anubani-yung yingga waanundhangaḏbiyn nga aḏaba wu-wal-warradangi wugurru. Anaani-yung ana-ngurudhu wugurru wu-ngarra-guṉmaa marri nga bagu maṉdhangi wu-wayayarrangi wugurru.” Dani-yung ni-yamaa niga na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Marri yaani-yung ngijang ni-yamayn niga, “Warruburru-yung warru-mandag na-God-jinyung, yuga yangi-mirri ngambaagajij-nguynju-nguynjijgana ngaya? ");
INSERT INTO nuy_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nguynju yaga wubani wurru-burrii wu-gulmung-buḻbuḻwanjii yaga. Ngarraagi-yung ngarra-maṉinyung ngiga ngi-mangi anubani-yung ana-marrya, nga ngi-burrangi ama-gaṉdharra-wuy. Anubani-yung ana-marrya aḏaba ngiirruyn nga bagu wu-burri nga wu-ḻuḻḏuḻwaa wugurraajbaj.” Dani-yung ni-yamaa niga. ");
INSERT INTO nuy_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Naagi-yung na-Jesus niga ni-yanggi-wugij, aḏaba ni-guwaṉawaṉaa wubani-wuy a-Jerusalem-guy niga. Ni-yanggi… wubani a-lhal-wurraayung-baj, niwu-lhal-milgayn. Ni-yanggi… nga daji wani-magaa. ");
INSERT INTO nuy_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Aynbajung nu-yamijgayn nigawi-wuy, nga ni-yamayn “Buunggawa, yuga amburru-ngargu waadurru amburru-wiri-mang? Yuga amburraadharra wugurru?” ni-yamayn. Yagu nigaayung wani-yambalmayn wugurri-wuy, ");
INSERT INTO nuy_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Numburru-waṉbina angaḏajung, nguynju yadhu numburru-yabina yungguyung wubani-wuy wudhawang a-gara-ngu-jiibug-guy, wubani a-God-jinyung a-wumurrng. Anaani ngana-magana nugurri-wuy, warruburru warraarrawindi-maynji wubani-wuy amburru-yaarri, yagu yagi wurru-yabi wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Yaani anaani wiijamana wugurru. Nubagi-yung na-waḻyinyung niwu-waṉagana-maynji ana-wumurrng. Anubani-maynji niga anu-dhawang aniwu-dhidang, nugurru numburru-yaarri nga bagu numburru-lhara aarabarabalu-rruj nga bagu anubani nimbirri-waḏbaḏii. Numburru-yamana, ‘Buunggawa, nimbaa-ngu-gara-wawalhijgang aḏaba anaani anu-dhawang nugawi-nyinyung!’ Nga nigaayung ani-yamang, ‘Aadanu ngaya nga-maḻaḻadi nugurru ajigala nurru-yanggi.’ ");
INSERT INTO nuy_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nga aḏaba nugurraayung numburru-yamang, ‘Nurru anaani nurru-nguni marri nurru-waḻ-nguni nugawi-rruj anaani. Nga nugawaj danu nimba-yiyini anaani nurru, maadamu-rruj manaadi.’ ");
INSERT INTO nuy_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nga nigaayung ani-yamang ‘Anaani ngana-magana, ngaya nga-maḻaḻadi nugurru, yuga nuu-nunggajigala-wayangu aadanu? Juy! Numbuu-yaarri ngayawi-wala nugurru aadanu nurru-waṉbina-yinyung anaaladi,’ ani-yamang niga. ");
INSERT INTO nuy_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Nugurraayung aḏaba numbuu-ruguna marri numbuu-ra-bangaynjina, numburraarragayii yamba nugurru. Marri nambarra-nayii na-Abraham marri na-Isaac marri na-Jacob, marri warruburru-yung wunaa-ja-jambini-yinyung na-God, wubani-rruj wurru-burraa-rruj na-God-jinyung aanga. Yagu nugurru-waj danu, na-God nambani-barawudang niga. ");
INSERT INTO nuy_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Arrawindi aḏaba amburru-yaarri wugurru yaajila ramalila marri arrgaḻila marri wunumbiyala marri yuwaagala wagiyangu. Marri warraawurru amburru-burraa amburru-nguyii nigawi-rruj na-God-duj wubani aanga. ");
INSERT INTO nuy_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nga warruburru-yung warra-mulung-arrgi-yung wugurru wuu-ragaani-yinyung warruburru-yung wugurru ambuu-lhamarrang. Yagu wugurraayung warruburru-yung wuu-lhamarrangi-yinyung, burru-yung nga aḏaba ambuu-ragaana.” Dani-yung ni-yamaa na-Jesus, ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wugurraayung aḏaba waadurru-yung warra-Pharisee wurru-yanggi. Nga bagu wunu-yamijgayn nigawi-wuy, “Ba-yaarri aḏaba anaanila-wala, yagu yamba naagi niga na-Herod aniimana yamba nagang.” ");
INSERT INTO nuy_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nigaayung naagi-yung ni-yamayn, “Numburru-yaarri buguni, nga numbunu-magana nigawi-wuy, nubagi-wuy na-yanggaḻijung-guy, ‘Baawanggina aadanu, ngaya nga-warra-yarraana anaani ana-man.gurrg, marri anaani ngarra-maji-wana-wugij warraawurru anaani ana-yimbaj marri ngijang anaagaray ngaya ngandhuḏ-buguuguni-wugij anaani. Marri yingga ngarrubagi-rruj ngarraaynbaj-duj ngarraaḻirr, bani-yung aḏaba ngaya nganggu-jadugang anaani.’ Dani-yung numbunu-yamijgang numbunu-magang nubagi na-Herod-guy. ");
INSERT INTO nuy_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Wiiya aadanu ni-yambina-yinyung niga. Ngaya yamba anaani ngaynjaarri-wugij ngayawi-nyinyung-guy amaadi-wugij, anaani ana-yimbaj marri anaagaray marri manubami-rruj manaaynbaj-duj mana-miyn.nganga. Warruburru-yung yamba warraarrawindi wunaa-ja-jambini-yinyung niga na-God, warra-jadugaa yamba wugurru anubani-rruj ana-Jerusalem-duj, waari anaaynbaj-duj yamba ana-lhal. Marri nga bagu ngaayunggaj anaani ngambambiimana, ngaayunggaj. ");
INSERT INTO nuy_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem, nugurru aadanu warra-wurru-wurruj ana-Jerusalem-jinyung aadanu! Malgarrawindi aḏaba nugurru narra-lhagarra-ngawijgana warruburru wunaa-ja-jambina-yinyung na-God, marri warruburru-yung wani-lharrgandi-yinyung niga na-God, nugurru narraambaḻgana ṉuga-mirri aadanu. Ngana-ngaynbandangi anaani ngaya malgarrawindi numburru-muṉḏugaa aḏaba ngayawi-rruj, nguynju yaga yiibagi-yung-jii yi-baawul-jii, ngi-muṉḏugijgana yaga ngigawi-nyinyung ana-wurraayung lhirribala ngigawi-rruj yi-ngarri-baṉja-rruj. Yagu nugurru waari ngirri-ngaynbandangi ngaya anaani. ");
INSERT INTO nuy_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ngubindi aḏaba, niga na-God niga-waj yamba nanii-garruyn aadanu, nugurri-nyinyung-jinyung anaanga niga yamba niwaarruyn. Anaani ngana-magana ngaya, yagi anaani aḏaba ngaya ngirri-ni, marri wurrugu anaani ana-lhaawu numburru-yambina nga numburru-yamang, ‘Naadagilu ni-yaarri, nigawi yungguyung aḏaba na-Buunggawa na-God. Naadagilu, na-God naagajij-majgaa niga.’ Dani-yung numburru-yambina, ngirrii-jambina ngaya.” Dani-yung ni-yambini na-Jesus, na-nidhaawu-yung niga. ");
INSERT INTO nuy_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ngarrubagi-rruj ngarraaḻirr-maṉngulg-duj, anubani na-Jesus marri warruburru-yung wurraanggarra-yanggi-yinyung, wurru-yanggi wugurru, marri wurru-nguni ana-marrya nubagi-yung-duj na-waḻyinyung-duj, wubani a-wumurrng-duj ni-buunggawa-maa-yinyung naagi-yung na-Pharisee-yung. Yagu warruburru-yung wugurru warra-mulung-arrgi-yung wunu-ru-nani niga. ");
INSERT INTO nuy_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Naagi-yung waḻyinyung bagu ni-burri raga-ragij. Marri naagi-yung ni-warra-wuḻbuḻwandi naagi-yung niga. ");
INSERT INTO nuy_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Aḏaba na-Jesus wani-magayn niga warruburru-wuy warra-yiyini-yinyung-guy ana-lhaawu-runggal, marri warruburru-wuy warra-Pharisee-wuy. Yaani-yung nga wani-magayn, “Yuga anaani wiij-maṉdhina wugurru aḏaba ana-lhaawu-runggal, yuga anaani ambarra-maji-wang-jinyung wugurru ngarraagi-rruj ngarraaḻirr-maṉngulg-duj aḏaba? Yagu waari?” ");
INSERT INTO nuy_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yagu warruburru-yung wugurraayung waari amburru-yambini nigawi-wuy. Nga anubani-yung naagi-yung na-Jesus niga nu-miyn nga nubagi-yung na-wurrujung niga nu-maji-wayn aḏaba. Marri anubani-yung aḏaba niga nu-lharrgang naagi-yung. ");
INSERT INTO nuy_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nga aḏaba warruburru-yung-guy niga wani-magayn aḏaba, “Yuga daju dunggi marri bulugi yuga nugurru nurru-waṉagana, marri anubani-yung anggu-rabina-maynji anubuguni anubani-wuy ana-gara-wuy, yuga anubani-yung nugurru lhugaajgiyalawaj numburru-yaarri ngarrubagi-rruj ngarraaḻirr-maṉngulg-duj, marri numburru-ngarrgiwana, yuga? Yagu waari?” ");
INSERT INTO nuy_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yagu waari warruburru-yung ambunu-yambalmaa niga. Waari yamba ambirri-waṉagaa ana-lhaawu wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yagu mulung-arrgi-yung wugurru bagu wurru-burri na-Pharisee-yung-duj anubani-rruj ana-wumurrng-duj, warruburru-yung yamba wani-yandhawiwandi niga ana-wulhu-wulhurr. Na-Jesus wani-nayn warruburru-yung-guy, nga anaani-yung wugurru wurru-wajbarini yamba wugurru wubani-rruj yamba a-mamanunggu-rruj, wurru-burri-yinyung warraawurru-yung, yagu yamba anaani-yung, anubani-yung-gala wugurru wani-magaa bagu wiij-bulawaa-wala wugurru. Yaani-yung nga ni-yamaa niga. ");
INSERT INTO nuy_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nubagi-yung-maynji na-waḻyinyung marri ngarrubagi-yung ngarra-maṉinyung nubiṉi-yung-maynji wuguṉi ambini-yara, marri anubani-yung niga ani-yandhawiwanjii-maynji, ‘Baaṉina, ngaambu-nguyii ngagurru,’ nga ba-yaarri-maynji, nga yagi nu-ngu-burrangi nagang anubani-rruj ana-mamanunggu-rruj aadanu. Yagu ari nubagi-yung na-runggal-yung niga buguni ani-yaarri wudanu-wuy niga. ");
INSERT INTO nuy_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Marri nubagi-yung na-wurrujung nini-yandhawiwandi-yinyung niga anubani-yunggaj, nga ani-yaarri niga nga bagu ani-yamijgang, ‘Waari anaani nugawi-nyinyung-magaa anaani ana-lhal, nubagi naaynbajung-jinyung nigawi, anaani ani-burraa niga ana-lhal.’ Anubanila-wala nagang baambulang aḏaba, ngijang baagiyn wubani-wuy a-lhal-wirrig-guy, buguni nga. ");
INSERT INTO nuy_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Yagu warrubawi-yung-maynji warraaynbaj nagang ambi-magang, anubani-yung-jinyung ana-marrya, baaṉbina aḏaba anaani. Ba-yaarri nga ba-burraa wubani-rruj a-winyig-duj nagang. Marri nubagi-yung nini-yandhawiwandi-yinyung nubagi-yung ari ani-yaarri, nga ani-magang, ‘Guwaj, aḏaba baadadang wubani a-runggal-wuy nagang.’ Anubani-yung warruburru-yung warraarrawindi amburru-nguyii-yinyung anubani ana-marrya, yagu anubani-yung ambi-nayii nagang wugurri-nyinyung-mirri-maynji mana-muṉbarrg-gala. Anubani-yung amburru-marrbuy, nagang nuṉḏunggal aadanu. ");
INSERT INTO nuy_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nugurru-maynji aadanu numburru-runggal-wina, nubagi na-God nambani-winyig-gna nugurru aadanu niga. Yagu nugurru-maynji numburru-winyig-gina-maynji, marri numburru-yaal-murramurra-maynji, niga na-God nambani-runggal-wana aadanu nugurru.” Dani-yung ni-yamaa na-Jesus, ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Naagi-yung na-Jesus niga nu-yamijgayn nubagi-yung nu-yandhawiwandi-yinyung anubani ana-wulhu-wulhurr anubani ana-wumurrng-duj, nga ni-yamayn, “Warrubawi-yung-maynji bamba-yandhawiwanjii, ‘Numburraaṉiyn ngayawi-wuy aanga-wuy, nga bagu ngagurru ngaambu-nguyii ana-marrya,’ ari angi-waḻirr-lhangang-duj yagu adhaadharrwara-wuy. Ari bamba-yandhawiwanjii warruburru nurru-guwaj-gaynjina-yinyung nugurru marri nugawi-nyinyung warra-minilharri-wuy, marri nugawi-nyinyung-guy nurraalgurmaynjini-wuy, marri warruburru-yung-guy warraambaambalal-wuy. Ari nagang bamba-yandhawiwanjii durru-yung-bugij. Yagu yagi nuynjami nagang. Ari wugurru yamba anubani-yung ari ambi-yandhawiwanjii nagang ngijang ari wugurri-wuy a-wumurrng-guy, marri ari anubani-yung ambii-gaagijgiyn nagang. ");
INSERT INTO nuy_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Anubani-maynji ana-marrya warraaynbaj-jinyung ba-waṉagana-maynji nagang, bamba-yandhawiwanjii wurrugu warruburru warraambaambalalari-wuy, marri warruburru-yung-guy wurru-babaaḏii-yinyung-guy, marri warruburru-yung waari-yinyung amburraarranggang-jinyung mana-bagaḻang. ");
INSERT INTO nuy_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Yagu naagi-yung na-God niga aniigajij-majgana nagang. Warraawurru yamba waari nimbii-gaagijgi nagang. Nga God niga-waj anii-gaagijgiyn nagang aadanu, anubani-yung-maynji warruburru-yung warra-mamanunggu-yinyung ambani-ḻaḻagang niga anubani ana-ngawij-gala.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Bagi-yung niga waḻyinyung ni-ngunu-nguni-yinyung ana-marrya nigawi-rruj na-Jesus-duj, anubani-yung niga ni-wawanggini anaani ana-lhaawu. Nga aḏaba nigawi-wuy nu-yamijgayn, “Warraaynbaj-maynji warrubawi-yung warra-wurruj ambu-nguyii ana-marrya nigawi-rruj na-God-duj anaanga, anubani-yung-maynji niga na-God ambani-muṉḏugijgana nigawi-nyinyung-jinyung warru-mandag, yagu God niga-waj ambaniigajij-majgana wugurru niga.” ");
INSERT INTO nuy_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yagu nigaayung na-Jesus nu-magayn aḏaba nigawi-wuy, “Nubagi-yung aynjaabu-nyung waḻyinyung niga ni-warra-waṉagaa arrawindi ana-marrya, marri nguynju yadhu warruburru-yung warraarrawindi amburru-nguni yadhu wugurru. Niwu-lharrgang niga lhaawu warruburru-yung-guy, ‘Numburraaṉina malg-aynbaj marri, numburru-yaarri ngayawi-wuy, marri numburru-nguyii nugurru.’ Dani-yung ni-yamaa niga. ");
INSERT INTO nuy_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","“Anubanila-wala, wugurru anubani-yung ana-marrya wu-warra-lharang aḏaba, wu-warra-ngu-burri. Nga naagi-yung nu-yandhurrbangaa-yinyung niga nu-lharrgang warruburru-yung-guy. Ni-yanggi nga bagu ni-yamayn, ‘Numburraaṉina aḏaba, bani aḏaba wu-warra-ngu-burraa ana-marrya.’ ");
INSERT INTO nuy_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Yagu warraawurru-yung aḏaba wugurraayung wurru-ḻiyn.giwini ana-lhaawu. Nga bagi-yung aynbajung wurrujung ni-yamayn, ‘Ngaya anaani aban anubani-yung ngawu-mangi, marri ngaya ngaynjaarri marri nganggu-nayii aḏaba ngaya. Anaani ngunu-yandhawiwanjii nugawi-wuy, nimba-lharrgang ngaya anaani, ngaynjaarri.’ ");
INSERT INTO nuy_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Marri nigaayung naaynbajung ni-yamayn nubagi-yung, ‘Ngaya anaani ngaarra-mangi 10 bulugi, nguynju yadhu ngaynjaarri buguni marri ngaṉḏawumana yungguyung ngaya. Marri ngaya ngunu-yandhawiwanjii anaani, nimba-lharrgang aḏaba, ngaynjaarri.’ ");
INSERT INTO nuy_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Nigaayung bagu aynjaabu-nyung ni-yamayn, ‘Ngayawi-nyinyung yamba ngarra-guḻgu ngi-yaarri dagila aḏaba, marri naani-yara yungguyung. Yagi ngaya anaani nga-rumi aadanu-wuy.’ Waadurru-yung wugurru warra-wulu-wulaynbaj wurru-wawaḻangi yamba, waari yamba ambirri-ngaynbandangi wugurru amburru-yanggi, waadurru-yung anubuguni. ");
INSERT INTO nuy_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Yagu nubagi-yung nu-yandhurrbangaa-yinyung niga anubani-yung niigiyn niga, nga anubani-yung niga nu-magaa nubagi-yung-guy na-buunggawa-yung-guy niga. Yagu nigaayung na-buunggawa-yung, niwu-waṉagaa-yinyung anubani-yung ana-wumurrng, naagi-yung niga ni-riyaldhiyn-bindiyung niga. Nubagi-yung-guy nu-yandhurrbangaa-yinyung-guy nga nu-magayn niga, ‘Ba-yaarri ba-nguḻu-nguḻubina aḏaba, wubami-wuy amaaynba-gaynbaj-jinyung-guy amaadi-wuy, wubani-wuy a-wumurrng-guy maadi-yaarri-yinyung yaga. Aḏaba ba-yaarri nga warruburru-yung bamba-yandhawiwang nagang warruburru-wuy warraambaambalalari-wuy aadanu, marri warruburru-yung wurru-babaḏii-yinyung, marri warruburru-yung waari-yinyung amburraarranggang-jinyung wugurru. Warruburru-yung aḏaba bambaarra-ngu-jadugang bamba-yarrijgina bagala yaanuwuy.’ Dani-yung ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Nga nubagi-yung niga nu-yandhurrbangaa-yinyung ni-yanggi. Nga bagala niigiyn. Nga ni-yamayn, ‘Aadanu aḏaba ngaya ngaaṉbini anaani, yagu wugurru waa-walbalg yamba, yaani wu-burraa-wugij wugurru wu-gara-maynmajii wugurru.’ ");
INSERT INTO nuy_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Yagu nubagi-yung na-buunggawa-yung niga ni-yamayn, ‘Nagang ba-yaarri nga ba-rabalang wubani-wala a-wumurrng-gala, nga ba-yaarri amaadi-wuy. Nga nagang ba-yaarri wubani-wuy a-ruluj-guy, nga warruburru-yung-guy wuu-ngarra-gandhadhaa-wuy warruburru-wuy warraambaambalalari-wuy. Nga ba-yaarri, nga bagu bamba-magana anggu-waḏa-waḏaḏ-bindiyung anaani ana-lhaawu. Bamba-yamijgana wugurru, “Numburraaṉina numburru-yaarri.” Nguynju yadhu ngayawi-nyinyung anaani ana-wumurrng anggaandharwiiyn, wurru-wurruj-bugij aḏaba anggu-dhaṉmang yungguyung. ");
INSERT INTO nuy_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ngaya anaani ngunu-magana nugawi-wuy aḏaba, warraawurru-yung yaga anubani-yunggaj ngaya ngambi-yandhawiwandi, yagi yaga wurru-ngi ngayawi-nyinyung ana-marrya.’” Dani-yung na-Jesus ni-yambini, ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Arraarrawindi wugurru wurru-wurruj wuu-yagaynjini wurru-yanggi. Ni-yanggi… nga ni-wiḻibiḻingiyn niga, nga bagu wani-magaa. ");
INSERT INTO nuy_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Nga ni-yamayn niga, “Nugurru-maynji aadanu numburru-yaarri ngayawi-wuy, numburru-lhaabina aḏaba na-ninyarra marri nga-rriibi marri nga-rangarrinaaj marri warruburru-yung nugurri-nyinyung warra-mijburrayung, marri warra-minilharri marri warra-miyn.ngarrilharri-wuy, marri ngijang, nugurru numburru-lhaabina nugurri-nyinyung aadanu ana-wiri nga. Yagi-maynji nurru-waṉbi aadanu, yagu waari ngayawi-nyinyung-magaa anaani numburru-marrbuy-mang-jinyung ngaya. ");
INSERT INTO nuy_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","“Nugurru aadanu nimbirri-warrgu anubani ana-rangag, marri ngaya ngirri-garrindharrmani. Yagi-maynji nurru-waṉbi aadanu, waari ngayawi-nyinyung-magaa anaani numburru-marrbuy-mang-jinyung ngaya.” ");
INSERT INTO nuy_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Na-Jesus naagi-yung ni-yambini-wugij niga. “Nugurru-maynji ngirri-garrindharrmani, wurrugu, anubani ana-raga-ragij numburru-wijangayii wurrugu ngayawi-nyinyung. Marri yuga nugurru ngirri-ngaynbandii-windiyung anaani ngirri-garrindharrmani ngaya, yagu waari? Anaani wugurru wiijamana, aadanu nugurru yuga warraaynjaaynjaabugij-gaj-jinyung, nimbirri-maṉdhii-maynji anubani-yung ana-wumurrng, anubani-yung nugurru numburraambargalang nga nimbirri-nguynmawana anu-ṉuga, nga aniga-yung anggu-ngargu, nimbii-jadugang yungguyung wugurru? ");
INSERT INTO nuy_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Yagi-maynji nugurru nurru-waṉbi aadanu, ari nimbirriiban-baḻii wubami-rruj ama-ṉuga-rruj, marri yagi aadanu wu-jadugi wugurru aḏaba. Warraarrawindi-maynji warra-wurru-wurruj aadanu ambirri-nayii, anubani-yung wugurru nambambi-rajburrnayii aadanu. ");
INSERT INTO nuy_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Amburru-yamang wugurru, ‘Naagi-yung niga na-waḻyinyung niwu-maṉdhangi, yagu waari aniwu-jadugaa niga!’ Dani-yung amburru-yamana wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Marri ari anaani wiij-nguynju. Nubagi na-runggal-yung-maynji na-king-jung, nubiṉi-yung-maynji ambini-wiynjina wuguṉi ana-wungarri naaynbajung-guy na-king-guy, anubani-yung ana-wulhu-wulhurr wurrugu niga-waj aniindhadhangang, marri ambani-nguynmawana nigawi-nyinyung wurru-wiynji-wiynjina-yinyung. Marri nga ani-yamang, ‘Ngaya warraawurru ngarra-waṉagana warra-waḻya-waḻya 10,000, nigaayung naaynbajung warruburru wani-waṉagana 20,000 warra-waḻya-waḻya. Yuga ngaya-waj anaani ngandhuḏ-jaarri yuga?’ ");
INSERT INTO nuy_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ari ani-yamang niga ‘Yagi ngaya nga-lhuḏ-ḏumi, ari arraarrawindi yamba wani-waṉagana niga!’ Nga anubanila, nubagi anu-lharrgang nubagi naa-ja-jambina-yinyung ari nubagi-wuy naaynbajung-guy na-king-guy. Ari nigaayung nubagi-yung naaynbajung ni-burraa-waj wurrugu yuwaagu jujuu…j. Nga buguni niga ani-yaarri nga anu-yandhawiwanjii anubani-yung aḏaba amburru-burraa wugurru amburru-lhamaamura.” ");
INSERT INTO nuy_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Na-Jesus naagi-yung ni-yambini-wugij niga. “Yagu anaani-yung wiijamana, nugurru-maynji aadanu yagi nurraarra-garraarru-maynji anubani-yung anaarrawindi-lhangu anaani-rruj-jinyung wu-warra-ngu-burraa-yinyung, waari ngayawi-nyinyung-magaa anaani numburru-marrbuy-mang-jinyung ngaya. ");
INSERT INTO nuy_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Naagi-yung niga na-lhanganig ni-lhami-mamaaḻang. Yagu naagi-yung na-lhanganig-maynji yagi waṉagi na-nidhamij, numburru-yaminggarrang nimbiniigijgiyn nubagi na-nidhamij? ");
INSERT INTO nuy_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Naadagu aḏaba niga ni-lhamij-galadi. Anaani aḏaba aniwaaban-galadi-wana anaani anaaban, yagu animaaladi-wana magurru mana-manure. Yagu warra-wurru-wurruj naagi niga ambini-warra-yarraana aḏaba. “Gurruwaj, nugurru-maynji aadanu numburraan-bawalhang, anubani-yung numburraawanggina-windiyung nugurru!” Dani-yung ni-yamaa na-Jesus, na-nidhaawu-yung. ");
INSERT INTO nuy_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Anubani-yumbaa warraawurru-yung wugurru wirri-nguynmu-nguynmawaa-yinyung anu-ṉuga marri warruburru-yung wugurraayung warra-mulung-arrgi-yung warraalaaladi-yinyung, anubani-yung wurru-yanggi marri nga bagu wurru-muṉḏugaa nigawi-wuy na-Jesus-guy. ");
INSERT INTO nuy_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Yagu warruburru-yung warra-Pharisee marri warruburru-yung warra-yiyini-yinyung ana-lhaawu-runggal, warraawurru-yung wugurru warriirrimarrdiyn. “Yagu niga naagi aḏaba ni-malngawina warraawurru-wuy warraalaaladi-wuy, nga anubani niga ni-nguyii bagu-rruj wugurri-rruj ana-marrya.” Dani-yung wurru-yambini wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yagu yamba aḏaba anaani-yung, wani-magaa bagu wiij-bulawaa-wala ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nugurru-maynji aadanu numburru-waṉagana anubani-yung ana-jib yagu 100 ari. Yagu anaaynjaabugij-maynji wugurru anggaaṉibiyn. Nugurru yuga numburru-yaminggarrina aadanu aḏaba? Anubani-yung numburraarruyn wugurru 99 anubani-yung bagu anggu-ngarra-ngu-burraa, anubagu a-lhal-maḏa-rruj, marri anubani-yung ngijang numburraagalhaga-lharrmani wubani-yung wugurru waaṉibiyn-inyung. Numburraagalhaga-lharrmani wugurru… nga numburru-lhangarrmang. ");
INSERT INTO nuy_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Anubani-yung numburru-lhangarrmang-maynji ana-jib wugurru, anubani-yung nugurru numburru-mang, marri numburru-ḻaḻagang marri numburru-warrgurrang, a-nyaḻaj-guy, marri numburru-yarrijgina aanga-wuy. Anubani nugurru numburru-ḏinggina. ");
INSERT INTO nuy_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Numburraaḏii nugurru, warruburru-yung-guy nurru-ga-gaḻijgaynjina-wuy marri warruburru-yung-guy warra-mijgalgur-wuy. Nga numburru-yamang wugurri-wuy, ‘Numburru-waḻaaḻarrii aḏaba ngayawi-wuy, ngaya yamba anaani nga-lhangarrmayn anaani ana-jib, anubani-yung waaṉibiyn-jinyung wugurru anubani-yunggaj, anaani-yung.’ ");
INSERT INTO nuy_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Yagu anaani wiijamana wugurru, ngana-magana anaani nugurri-wuy, nubagi-yung-maynji naaynjaabu-nyung naaladi-nyung niga ani-wurrij-biḻibiḻingiyn-maynji, warruburru-yung wugurru wurru-burraa-yinyung anuwaani anaarrwar, warruburru-yung amburru-ḏinggina-windiyung runggal. Yagu warruburru-yung wurru-ḏinggina wirrig, warruburru-yung yamba warru-mulung wugurru 99 waari yamba wugurru amburru-wurrij-biḻibiḻingini wugurru, anubani-yung yamba wugurru wurru-maaḻamburrg. Yagu nubagi-yung-maynji naaladi-nyung niga ani-wurrij-biḻibiḻingiyn-maynji, warruburru-yung amburru-ḏinggina runggal-windiyung wugurru.” ");
INSERT INTO nuy_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Naagi-yung na-Jesus ni-yambini-wugij niga. “Ngarrubagi-yung-maynji ngarra-maṉinyung angiwu-waṉagana 10 anu-ṉuga wugurru yi-yiiḻi-yii, yagu anubani-yung angiwaaṉibijgang-maynji ngiga anaaynjaabugij, marri angiwu-lhalmbaarrijgang-maynji ana-ngura marri ngiga angi-waalhudii anubani-yung. Marri anubani wugurru angiwaagalhaga-lharrmani wubani-rruj a-lhirribala a-wumurrng-duj. Angiwaagalhaga-lharrmani… marri angiwu-nang ngiga, angiwu-lhangarrmang anubani-yung. Yijgubulu, anaani angi-yamang ngiga. ");
INSERT INTO nuy_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Anubani-yung-maynji angiwu-lhangarrmang ngiga, nga anubani-yung ambangii-gaḏang warruburru-yung-guy wurru-ga-gaḻijgaynjina-yinyung marri ngigawi-nyinyung-guy warra-mijgalgur-yung-guy. Marri anubani angi-yamang, ‘Numburru-ḏinggina nugurru ngayawi-wuy, anubani-yung ngawu-lhangarrmayn waaṉibiyn-jinyung anu-ṉuga,’ angi-yamang ngiga. ");
INSERT INTO nuy_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Anaani ngana-magana nugurri-wuy, anaani wiij-nguynju aḏaba, nubagi-yung-maynji naaladi-nyung naaynjaabu-nyung, anubani anaaladi-maynji ani-wij-garru-maynji niga, anubani-yung ana-angel na-God-jinyung, anubani anggu-ḏinggina windiyung.” Dani-yung na-Jesus niga ni-yambini. ");
INSERT INTO nuy_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ngijang yaani-yung ni-yambini anaaynbaj ana-lhaawu. “Nubagi-yung waḻyinyung, wini-wulawaa niwiyayung-biiyung wani-waṉagaa. ");
INSERT INTO nuy_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nubagi-yung niga na-yabaḏi-nyung nu-yamijgayn na-ninyarra-yung-guy, ‘Baba, anaarrgi-yung nugawi-nyinyung anaarra yagu nganggaarra-mani wurrugu. Yagu nagang numbiiyn-bugij aḏaba anaani.’ Nigaayung na-ninyarra-yung aḏaba nigaayung ni-warra-munduwaa niga anubani-yung anaarra, nga waniini niga nubiṉi-yung-guy. ");
INSERT INTO nuy_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Wurrugu marri mal-dhamurrug nubagi-yung na-niwiyayung na-yabaḏi-nyung niga ni-warra-mangi aḏaba anaarra. Aḏaba nubagi-yung niga ni-yanggi wubani-wuy a-lhal-aynbaj-guy a-lhal jujuu…j malanganyanay, niga ni-yanggi. Nga bagu anubani-yung ni-warra-lhaladangi anaarra, ni-warra-nguḻu-nguḻugayn-bindiyung niga, ni-warra-ngu-jadugayn, anubani-yung niga yij-galaaladi-windiyung yamba ni-waṉbini naadagi-yung. ");
INSERT INTO nuy_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Anubani-yung aḏaba ni-burri anubagu ni-mamar niga. Anubani-rruj ana-lhal, waari ana-marrya, maarmag-galadi aḏaba. Warruburru-yung wugurru wurru-marryaadangi anubani-rruj ana-lhal. Nigaayung naadagi-yung na-wurrujung, nigaayung ni-marryaadangi. ");
INSERT INTO nuy_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aḏaba ni-yanggi nubagi-wuy na-wurrujung-guy anubani-rruj-jinyung ana-lhal, ani-mijgalmini yungguyung niga. Yagu nigaayung na-waḻyinyung anubani nu-magayn, ‘Nagang ba-rangarrii wubani a-bigi-bigi-wuy,’ niga ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nga naagi-yung na-waḻyinyung ni-yanggi, ni-rangarrangi aḏaba ana-bigi-bigi. Naagi-yung ni-ngaynbandangi-windiyung niga anubani ani-nguni a-bigi-bigi-yinyung ngunu-nguni a-marrya. Warraaynbaj yamba waari niga ambunu-marrya-wini wugurru ana-marrya naagi-yung. ");
INSERT INTO nuy_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Anubani-yung niga ni-dhi-maṉdhini aḏaba nigaajbaj, nga bagu niga ni-yamijgaynjini niga, ‘Warruburru-yung warra-wurru-wurruj niga wunaa-mijgalmina-yinyung ngayawi-nyinyung na-baba, ari wugurru wurru-waḻarranjii, marri ngijang. Yagu ngaya yaani aḏaba, nga-ngu-jadugiiyn, ari nga-ngawang, ngaya yamba anaani nga-gaj-marryaadiyn yaani. ");
INSERT INTO nuy_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Aḏaba nga-ḻaḻagiiyn marri ngaynjaarri ngayawi-wuy na-baba-wuy. Marri ngaynjamang ngaya nigawi-wuy, “Baba, anaani ngaya ngaaṉbini aladi nigawi-wuy na-God-guy yagu marri nugawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ngaaladi yamba ngaya anaani, yagi numba-mayi marri numba-nigi-wi ngaya. Nimba-lharrgang ngaya, waa-mijgalmina yungguyung aḏaba.” ’ Dani-yung ni-yamaa niga. ");
INSERT INTO nuy_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Anubani-yung ni-ḻaḻagiiyn, aḏaba ni-jarrarriyn na-ninyarra-yung-guy. “Aadani-yumbaa niga na-ninyarra-yung ni-warranggaa nga ni-malnguj-ngaḏba-ngaḏbangi anuwagala ni-yanggi-yinyung niga. Anubani-yumbaa niga nu-warrngayuyn-bindiyung naadagi-yung. Marri ni-yarbiyn nga nu-bilhargayn, nga nu-lhaawuynjayn niga. ");
INSERT INTO nuy_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Anubani-yung niga na-niwiyayung nu-magayn, nga ni-yamayn ‘Baba, anaani ngaya ngaaṉbini aladi nigawi-wuy na-God-guy yagu marri nugawi-wuy. Ngaaladi ngaya anaani, yagi nimba-mayi ngaya nimba-nigi-wi.’ Dani-yung ni-yamayn niga. ");
INSERT INTO nuy_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Yagu nigaayung na-ninyarra-yung niga wani-magayn warruburru-yung-guy wunu-yandhurrbangaa-yinyung, ‘Gurruwaj, numburru-nguḻu-nguḻubiyn bagalu nimbirrima-yarrijgiyn maadamu mana-yaaḻi, marri numbunu-yabijgang niga. Marri anubani dajilu nimbirri-mang marri nimbirri-waṉagana numbunu-marang-jadang yadhu niga. Marri dajilu nimbirrima-mang, nimbirrima-waṉagana, marri numbunu-mun-jabijgang yungguyung niga. ");
INSERT INTO nuy_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Marri nugurru numburraagalhaga-lharrmani aḏaba a-bulugi a-mangaj, marri numburruumana wugurru. Marri anubani-yung ngaambu-nguyii yadhu, ngaambu-ḏinggina. ");
INSERT INTO nuy_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Naagi-yung yamba na-nigi niga yaga ni-ngawiiyn yagu niga ni-wiri-wugij niga. Niiṉibiyn mirraadhu, yagu nguunu-lhangarrmayn niga.’ Dani-yung ni-yamaa. Anubani wurru-ḏinggini wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Yagu niga nubagi-yung nu-ngambara-gayn-jinyung niga na-niwiyayung, yuwaagu niga ni-burri marri ni-mijgalmini aarabarabalu-rruj. Nga anubani-yung ni-yanggi niga wubani a-wumurrng-guy. Yagu niga ni-wawanggiyn nga anubani-yung wugurru wurraayigini, wurru-wan.ngaa anubagu. ");
INSERT INTO nuy_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nga bagala niga niiḏiyn nubagi-yung-guy na-wurrujung-guy nubagi nu-yandhurrbangaa-yinyung niga. Nu-yamijgayn, ‘A-yangi yungguyung yuga aadanu wugurru wurru-waṉbina wurru-ḏinggina waadurru?’ ");
INSERT INTO nuy_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Nga nigaayung nubagi nu-yambalmayn nu-magayn, ‘Nugawi-nyinyung yaga na-nilharri aḏaba yaagi niigiyn niga. Niigiyn aḏaba nugawi-wuy na-ninyarra-wuy. Niga na-ninyarra anaani ni-wini aḏaba mangaj bulugi. Na-nilharri yamba nagang niga ni-wiri-wugij marri niga ni-maaḻamburrg niigiyn.’ Dani-yung ni-yamayn naagi-yung na-wurrujung. ");
INSERT INTO nuy_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Yagu naagi-yung na-ngambari-nyung niga aḏaba ni-riyaldhiyn. Waari anubuguni ani-yabini, nu-wurrij-marrdiyn-bindiyung niga naadagi-yung. Yagu nubagi na-ninyarra-yung ni-rabaliyn marri nu-yandhawiwandi niga. ");
INSERT INTO nuy_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Yagu nigaayung na-ninyarra-yung-guy nu-yambalmayn, ‘Anaani-yung ngaya anaarrawindi-lhangu anaagalhal-aṉbana anaani-yung ngunu-yandhurrbangaa nagang. Yagu waari nimbiini ngaya anaaynjaabugij ana-naniguḏ ana-wirrig nguynju yadhu ngaayunggaj nga-ngu-ḏinggini yungguyung warraawurru yaga nurru-guwaj-gaynjina-yinyung nurru. ");
INSERT INTO nuy_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Yagu naadagu naaynbajung nugawi-yinyung na-niwiyaay yaga, anuwagala niigiyn-jinyung, anubani-yung niwu-lhaladangi anubani-yung yaga anu-ṉuga, warruburru-yung-guy warraalaaladi-wuy yaga warra-maṉaṉung-guy. Marri ngijang niga nunaa-bini aadanu ana-bulugi ana-mangaj.’ Dani-yung ni-yamayn niga. ");
INSERT INTO nuy_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Yagu nigaayung na-ninyarra-yung nu-yamijgayn nigawi-wuy, ‘Nigi, nagawaa yaani na-burri na-yagaynjini na-wuguuguni-wugij nagawaa, naanggarra-ngu-burri yaaji. Anaani anaarrawindi-lhangu nagang baarra-waṉagana, nugawi, wurrugu marri. ");
INSERT INTO nuy_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yagu anaani aḏaba ngagurru ngaambu-waḻaaḻarrii marri ngaambu-ḏinggina. Anaani wiij-maṉdhiiyn aḏaba. Naagi yamba nugawi-nyinyung na-nilharri ni-ngawiiyn, yagu ni-wiri-mayn ngijang. Niiṉibiyn, yagu ngijang nguunu-lhangarrmayn niga.’” Dani-yung ni-yamaa na-Jesus, na-nidhaawu-yung. ");
INSERT INTO nuy_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Anubanila-wala, na-Jesus wani-magayn niga warruburru-wuy wurru-marrbuy-maa-wuy, “Nubagi-yung yaga waḻyinyung ambalal-yung. Marri nubagi-yung naaynbajung naa-mijgalmini-yinyung naagi-yung niga. Nubagi-yung naa-garra-rangarrangi-yinyung wubani-yung aarra. Nga aḏaba aynbajung nu-magayn nubagi-yung naambalalijung, ‘Nubagi ninii-mijgalmina-yinyung niga, anubani-yung niga ni-warra-lhaladangi aḏaba anubani anaarra,’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","“Nigaayung nubagi naa-gaḏiyn aḏaba yuuguni naa-maa-mijgalmini-wuy. Ni-yamayn nga nu-yamijgayn ‘Aadanu ngaya ngaawanggini nugawi-nyinyung ana-lhaawu,’ ni-yamayn. ‘Yuga ngubindi aadanu? Ba-warrarrii a-wubiba-wuy, nga anubani-yung barriini-yinyung marri barraa-gaagijgini-yinyung warruburru-yung-guy. Nimbiiyn aḏaba bagalu aadanu ana-wubiba. Yagi yamba nagang nimbaa-garra-rangarri aadanu ngayawi-nyinyung anaani anaarra.’ Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Nubagi-yung niga naa-maa-mijgalmini-yinyung na-waḻyinyung nigaajbaj ni-yamijgini. Ni-yamayn, ‘Yuga ngaya ngaynjaminggarrina anaani, aḏaba ngaya ngani-lhambang yamba naagi na-buunggawa-yung, ngaya nganaa-ba-bardhii-yinyung nigawi-nyinyung? Waari yamba ngaya ngambaḏa-waḏaḏ-magaa, yagi ngaya anaani nga-rigi ana-gara. Ngaya anaani ngaambuliyn, yagi ngaya nga-lhangayi anu-ṉuga. ");
INSERT INTO nuy_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nga-marrbuy anaani nganggaṉbina-yinyung. Nguynju warra-mulung-arrgi-yung ngambambi-yarrijgina yadhu wubani wugurri-wuy a-wumurrng-guy, naagi-maynji ngaya anaani ngambani-lharrgang.’ Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Anubanila-wala, wanii-gaḏiyn warruburru-yung-guy warra-mulung-arrgi-yung-guy, warruburru-yung-jinyung wani-lhalamayaa-yinyung niga anubani anu-ṉuga nubagi-wuy niga na-buunggawa-yung-guy. Wanii-gaḏangi aynjaaynjaabugij-gaj niga. Ana-wulhu-wulhurr-inyung niga nubagi-yung nu-magayn, ‘Nagang yuga wu-ngargu aadanu banaa-gaagijgina anu-ṉuga, ngayawi-nyinyung na-buunggawa-yung-guy?’ ");
INSERT INTO nuy_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Nigaayung ni-yamayn, ‘Anaani 4000 lita anubani-yung anu-gargayag, anaani.’ Nigaayung ni-yamayn, ‘Yaani ana-wubiba nugaayung. Ba-burrangang daju. Marri ba-warrarrii anubani anggu-malnguj-garrarrina anubagu 2000.’ Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ngijang nu-yambini naaynbajung-guy, ‘Yuga wu-ngargu nagang aadanu banaa-gaagijgiyn, nubagi na-buunggawa-yung-guy?’ Nigaayung ni-yamayn, ‘Anaani 4000 lita anubani-yung wuḏal-inyung, anaani a-marrya.’ Nigaayung ni-yamayn, ‘Daju baandhadhangang, marri ba-warrarrii aadanu ana-wubiba, anggu-malnguj-garrarrina anubagu 3000.’ Dani-yung ni-yamayn.” ");
INSERT INTO nuy_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Na-Jesus naagi-yung ni-yambini-wugij niga. “Nubagi-yung niga naaladi-nyung naa-maa-mijgalmini-yinyung, dani-yung ni-waṉbini niga. Yagu niga nubagi-yung na-buunggawa-yung nigawi-nyinyung, nubagi-yung nu-warraarriwaa niga! ‘Aadanu nagang nuynjina-mamaaḻang,’ ni-yamayn. Anaani wiijamana, warruburru-yung warra-wurru-wurruj anaani-rruj-jinyung wurru-burraa ana-lhal, anaani wurru-yina-mamaaḻang anaani-rruj-jinyung ana-lhal, wugurraayung warruburru-yung warra-mulung-aynbaj warra-wurru-wurruj wu-lhalmbaarrii-yinyung wurru-burraa wugurru, warraawurru-yung warra-mijburrayung na-God-jinyung, waari amburru-yamang wugurri-yii. ");
INSERT INTO nuy_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Marri ngana-magana anaani nugurri-wuy, anubani-yung numburru-guwaj-gaynjina nugurru warra-mulung-arrgi-yung-guy. Nambarriiyii nugurru anubani anu-ṉuga marri anubani-yung anaarrgi-yung ana-ngurrji, anaani-rruj-jinyung ana-lhal. Anubani-yung-maynji anu-ṉuga anggu-jadugiiyn wugurru, anggaari, yagu God niga-waj nambani-yarrijgina anuguni anaarrwiyaj nigawi-wuy, anubani anggu-wuguuguni anubani-rruj anaanga.” ");
INSERT INTO nuy_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Na-Jesus ni-yambini-wugij niga. Ni-yamayn, “Nugurru-maynji aadanu numburraarra-waṉagana ana-winyig, marri anubani-yung numburru-warraaṉbina maaḻamburrg, anubani-yung numburraarra-waṉagana-maynji anaarrawindi, anubani-yung ari numburraarra-waṉbina wugurru maaḻamburrg. Yagu nugurru-maynji numburraarra-waṉagana ana-winyig, marri anubani-yung numburru-waṉbina-maynji wugurru anaaladi, anubani-yung numburraarra-waṉagana-maynji anaarrawindi, anubani-yung ari numburru-waṉbina aladi. ");
INSERT INTO nuy_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","“Nugurru-maynji yagi-maynji narra-yu anu-ṉuga warruburru-wuy ana-maaḻamburrg-galawaj, marri anubani-yung anaarrgi-yung wugurru ana-ngurrji, anaani-rruj-jinyung ana-lhal, yagi-maynji nurru-waṉbi nugurru ana-maaḻamburrg, niga na-God yagi nani-yu nugurru anubani anaarrawindi ana-mamanunggu-yinyung anaarrwar-wala. ");
INSERT INTO nuy_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yagi-maynji nugurru nurraarra-waṉbi ana-maaḻamburrg anubani anaarra warra-mulung-arrgi-yung-jinyung, yagu waari nugurru aadanu nambii-ngu-jambarrg-gi, aadanu waari numburru-mamanunggu-magaa nugurru. Marri yagi nambi-yu aadanu nugurri-wuy anubani anaarra yagu ana-ngurrji. ");
INSERT INTO nuy_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Waari narra-waṉagi na-wulawaa na-buunggawa-waa. Nugurru-maynji nambarra-waṉagana ambini-wulawaa na-buunggawa-waa, numbunu-margirang naaynbajung yagu naaynbajung numbunu-ngaynbandii. Numbunaa-garra-galgaalgurmani ari yijgubulu nubagi naaynbajung, ari yagi niga naaynbajung nuunaa-garra-galgaalgurmi ana-maaḻamburrg. Nguynju yunggaj, nugurru yagi nuunu-waṉagi na-God marri anaaynbaj yagi wu-buunggawa-mi.” Dani-yung ni-yamaa na-Jesus, wani-magaa warruburru-wuy wurru-marrbuy-maa-wuy, ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Wugurraayung warra-Pharisee warraawurru-yung wirrii-ḏamarr-ngu-burri windiyung anaani-yung anu-ṉuga wugurru. Yagu anubani yingga wurraawanggini anaani ana-lhaawu, marri anubani wunu-rajburrnani niga na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yagu nigaayung wani-yamijgayn wugurri-wuy, “Nugurru aadanu nurru-mamanunggu-wina, nguynju yadhu warraarrawindi warra-wurru-wurruj nambambi-nayii nugurru aadanu. Yagu God ni-marrbuy niga-waj anaani ana-lhirribala anaandhiri-rruj, niwu-nayii niga. Warra-wurru-wurruj-maynji nugurru aadanu nambambi-warraarriwana, yagu God niga-waj nambani-nayii nugurri-wuy. Ni-marrbuy niga nugurru nurraalaaladi-windiyung aadanu. ");
INSERT INTO nuy_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Anaani wugurru anu…bani-yunggaj anaani-yung nga anubuguni na-John-guy nubagi yaga waniimbaambara-ngambijgaa-yinyung niga, warruburru-yung wurraawanggini anaani-yung ana-lhaawu-runggal marri anubani-yung anaaynbaj ana-lhaawu warruburru-yung-jinyung wugurru wunaa-ja-jambini-yinyung na-God. Nga anubani-yung malgadhaadharri wurrugu, nga anubani-yung ana-lhaawu anubani-yung-jinyung na-God niga wani-rangarrii-yinyung nigawi-nyinyung warruburru-yung warru-mandag, anaani-yung ana-lhaawu aḏaba wu-rajaarrii. Yagu warraawurru-yung warraarrawindi-lhangu warra-wurru-wurruj wugurru wurru-yaarri angaḏajung nigawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Anuwaani anaarrwar marri anaani ana-lhirribala ngurru-burraa-rruj ngagurru, anaani ari anggu-jadugiiyn aḏaba. Yagu anaani wiij-baḏa-waḏaḏ-bindiyung wugurru, yagi anubani ana-lhaawu-runggal wu-warrbidi-mi wugurru. Anaani-rruj wugurru yagi anubagu anaaynbaj anu-mari wu-mari-warrarrii, yagi wugurru wu-jadugi.” ");
INSERT INTO nuy_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Na-Jesus naagi-yung ni-yambini-wugij niga. “Nagang-maynji bangaarruyn-maynji nugawi-nyinyung nga-rangarrinaaj, marri baaynji-yara ngarraaynbajung-guy, ba-waṉbina aladi-windiyung. Marri, nubagi-yung-maynji na-waḻyinyung marri ngarrubagi ngarra-maṉinyung ambiniirruynjang-maynji, yagu naaynbajung-maynji ngarrubagi-yung ambini-yara, ngarra-maṉinyung, bagi-yung niga ani-waṉbina aladi-windiyung.” ");
INSERT INTO nuy_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Naagi-yung ni-yambini-wugij. “Nga bagi-yung ambalal-ijung wurrujung, manubami-yung ni-yabini yaaḻi-mamaaḻang-jinyung, ma-mamanunggu-windiyung, manaama waṉagana runggal anu-ṉuga. Naagi-yung na-waḻyinyung ni-ngunu-nguni ana-marrya arraambaḻaman-jinyung, ni-wuguuguni. ");
INSERT INTO nuy_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nigaayung naagi-yung naambalalari-nyung, na-nimuwaj-jung Lazarus ni-mayini. Bagu aarabarabalu-rruj ni-murrgu-murrgulhi bagu wu-dhawang-duj naambalalijung-duj anaanga. Naagi-yung niga ni-warra-guṉḏa-guṉḏa. ");
INSERT INTO nuy_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Naagi-yung ni-ngaynbandangi-windiyung ani-nguni anu-gamuymuy, nubagi-yung-gala naambalalijung-gala ni-nguni-wala. Marri anuwagala-magaa waa-ḻandhurrg wu-yanggi, nga wunu-lhaṉ-buynjaa anubani ana-jiji. ");
INSERT INTO nuy_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Wurrugu nubagi ni-ngawiiyn naagi-yung naambalalari-nyung. Anubani wu-yanggi ana-angel ninggu-miyn, ninggu-warrgurriyn. Naagi-yung ninggu-yarrijgini na-Abraham-guy, bagu ninggu-burriyn, marri wini-yagaynjini aḏaba. Nigaayung malgadhaadharri ni-ngawiiyn naagi-yung naambalalijung. Nga naagi-yung wunu-wurrdhangi. ");
INSERT INTO nuy_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Naagi ni-yanggi wubani wu-naga-nagina-wuy a-ngura-wuy. Nga bagu ni-burri, wubani-rruj a-ngura-rruj, ni-warragayangi-windiyung. Nga yuuguni ni-ba-jaḻdhiyn arrwiyaj, ni-warranggayn bagila nu-nayn na-Abraham, jujuu…j ni-burri. Ni-warranggayn bagu nigaayung niindhadhi naagi-yung na-Lazarus nigaayunggaj, wini-yagaynjini. ");
INSERT INTO nuy_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Anubagala niiḏangi, ni-yamayn ‘Baba! Abraham! Nimba-man.galagang! Naadagu banu-lharrgang na-Lazarus. Naadagu ani-yaarri nga ni-marang-dhalwulangang nga ni-yaarri nga bagala ngambani-lhaynjajgang, ngambani-lhayn-mawuraadijgang nguynju yadhu. Anaani yamba waa-lhanga-lhangalmbaliyn nga-burraa a-ngura-rruj, ngaarragayii,’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Yagu nigaayung na-Abraham nu-yamijgayn ‘Nigi, baawanggina, aadanu anu…bani-yunggaj nagang numbiri-waj, aadanu nunggarra-mangi arraambaḻaman-jinyung anaarra, nunggarra-waṉagaa. Nigaayung naagi-yung na-Lazarus nigaayung ni-warra-mangi alaaladi-yinyung. Yagu anaani nurru naagi aḏaba nuunu-man.galagana, nurri-rruj ni-burraa. Yagu nugaayung aadanu danu nga aḏaba nunggarragayii. ");
INSERT INTO nuy_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Marri ngijang, nugurru aadanu marri nurru anaani, danu yamba waaḻadhaa runggal. Warraaynbaj-maynji anaajili ambu-yaarri nugawi-wuy-maynji aadanu-wuy, yagi aadanu-wuy yamba wu-rumi. Warraaynbaj yamba yagi anaadajilu wu-garraji nugurri-wala anaanu-wuy,’ ni-yamayn na-Abraham. ");
INSERT INTO nuy_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Nigaayung ni-yamayn, ‘Ngunu-lhangayaana anaani baba, banu-lharrgang naadagu na-Lazarus, ani-yaarri ngayawi-wuy warra-mijgalgur-yung-guy. ");
INSERT INTO nuy_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ngaya anaani ngarra-waṉagana marang-aynjaabugij naa-murruyung-gaang warruburru. Nguynju yadhu bagu ambani-magana, ambani-ru-maṉdhii warruburru, nguynju yungguyung waari wuu-rumi anaanu-wuy, nguynju yadhu yagi yungguyung wurraarragayi,’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Yagu nigaayung na-Abraham ni-yamayn, ‘Yagu warruburru wugurraayung wirri-waṉagana bani lhaawu na-Moses-jinyung marri warruburru-yung wunaa-ja-jambini-yinyung na-God, anu…bani-yunggaj-jinyung. Wugurru warruburru amburraawanggina wubani a-lhaawu,’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Yagu nigaayung anubani-yumbaa ni-yamayn, ‘Yagi, baba Abraham. Warraaynbaj-maynji warrubawi-yung ambu-yaarri anubani ana-ngawij-gala, bani-yung marri anubani amburru-wurrij-biḻibiḻingiyn.’ ");
INSERT INTO nuy_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Nigaayung anubani na-Abraham ni-yamayn, ‘Warrubawi-yung-maynji yagi wii-yandhurrbi anubani ana-lhaawu na-Moses-jinyung marri warruburru-yung wunaa-ja-jambini-yinyung na-God, warrubawi-yung-maynji warraaynbaj ana-ngawij-gala-maynji ambu-ḻaḻagiiyn, warrubawi-yung yagi-wugij wu-jambarrgi.’” Yaani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Anubanila-wala, naagi-yung na-Jesus wani-magayn niga warruburru-yung-guy wurru-marrbuy-maa-wuy, “Anaani ngubindi-windiyung warraarrawindi-lhangu nugurri-wuy. Warrubawi-yung warraaynbaj nambambi-dhangu-jujurii-maynji, nguynju yadhu nugurraayung ari numburraaṉbina aladi. Yagu anubani-yung runggal windiyung aladi anubani anggu-waṉina wugurri-wuy nambambiidhangu-jujurii-yinyung-maynji. ");
INSERT INTO nuy_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nubagi-yung-maynji na-wurrujung, nubagi-yung ambani-magang-maynji warruburru-wuy warra-mijburrayung-guy, ambaniidhangu-jujurii-maynji, anubani-yung ana-wulhu-wulhurr warraaynbaj ambirrima-ṉuga-radbiyn ṉuga runggal-windiyung, nubagi-yung-guy ambunu-waḻwag-ḏadbiyn marri anubani-yung ambunu-barawudang anubuguni mana-lhagayag-guy! Aadanu anggiij-maṉdhiiyn, yagi yadhu waniidhangu-ju-juri warra-mijburrayung, marri wurru-waṉbi anaaladi wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Nugurru aadanu aḏaba numburru-dhi-maṉdhina. Na-nilharri-maynji nubagi ani-waṉbina anaaladi, anubani-yung banu-magana niga, ‘Aadanu wiij-galadi-wina wugurru.’ Yagu nubagi-yung-maynji ani-wurrij-biḻibiḻingiyn niga, anubani-yung nagang banaagajij-garruyn aadanu. ");
INSERT INTO nuy_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nubagi-yung-maynji ani-waṉbina-maynji niga anaaladi nugawi-wuy, anubani-yung marang-aynjaabugij marri wulawaa, anubani-yung ani-waṉbina, ngarrubagi-rruj ngarraaynjaabugij ngarraaḻirr niga, anubani-yung-maynji marang-aynjaabugij marri anggiij-bulawaa-maynji naagi-yung ani-wiḻibiḻingiyn nugawi-wuy, nga ani-yamang aḏaba ‘Anaani ngaya nga-wij-garruyn aḏaba. Marri ngaya anaani nimbaagajij-garruyn nagang.’ Ani-yamana-maynji, marri nugaayung banaagajij-garruyn nubagi-yung niga.” Dani-yung ni-yamaa na-Jesus, ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Warraawurru-yung wirri-lhaawu-yarrijgini-yinyung, wunu-magayn nigawi-wuy na-Buunggawa-wuy, wurru-yamayn “Nurru aḏaba anaani nuu-jambarrgiiyn. Nimba-maṉmang, nguynju yadhu naambu-jambarrgina yungguyung angudu.” ");
INSERT INTO nuy_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yagu nigaayung na-Buunggawa ni-yamayn, “Nugurru-maynji anubani numburru-jambarrgiiyn winyig-bindiyung, ari numburru-yamang-maynji aani-yung-guy wubal-wuy a-mulberry-wuy, numburru-yamijgang anubani ‘Ba-ḻaḻagiiyn, nagang aadanu anu-bal, ba-yaarri nga yuwaagu baanuynjungina ama-lhagayag-duj’ marri anubani nambanggu-yandhurrbang nugurru.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ni-yambini-wugij naagi-yung na-Jesus. “Nubagi-yung niga nini-yandhurrbangana-yinyung, nubagi-yung-maynji ani-riganjii anaaban nguynju ani-wanuynjungana yungguyung, yagu anubani-yung anii-ḏangarrii ana-jib nugawi-nyinyung. Anubani-yung anubagala-maynji ani-yaarri anubuguni ana-wumurrng-guy, yuga ba-yamana ‘Baaṉina, ba-yaarri ba-nguyii’? Yuga anaani-yung ba-yamang nigawi-wuy? ");
INSERT INTO nuy_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Girrjag! Banu-yamijgang ba-yamang, ‘Ba-yaarri ba-mani ana-marrya ba-burrii, baarraalgaalgurmani, nga ba-yarrijgina ana-marrya ngayawi-wuy. Anubani-yung nga-nguyii, marri nganggaḻ-nguyii, anubani-yung nganggaarra-ngu-jadugang. Adhaadharri wurrugu nugaayung ba-nguyii marri baaḻ-nguyii.’ Aadanu ba-yambina. ");
INSERT INTO nuy_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yuga ‘Yuu, nga’ ba-yamang nigawi-wuy nubagi nini-yandhurrbangana-yinyung? Girrjag! ");
INSERT INTO nuy_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Anaani wiij-nguynju, anaani anaarrawindi-lhangu anubani-yung ngana-magana-yinyung, anubani-yung numburraaṉbina. Anubanila, numburru-yamang, ‘Nurru anaani ngunu-yandhurrbangana-yinyung, nurru anaani nurru-winyig. Nurru anubani-yung nurraaṉbini, waari anaaynbaj. Anubani-yung wiij-maṉdhiiyn.’ Dani-yung numburru-yamang.” Ni-yamayn yaani-yung na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Anubani-yung ani-yanggi niga buguni Jerusalem-guy. Aḏaba ni-yanggi Galilee-wala, aḏaba niwu-lhal-wambaḻalhiyn ana-Samaria. ");
INSERT INTO nuy_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nga ni-yanggi buguni wubani-wuy a-wumurrng-guy, aanga-wuy. Ni-yanggi… nga bagu, ni-warranggayn, nga yaawurru 10 warruburru arraarra-guṉḏa-guṉḏa, wurraarragarra-lhi, yuwaagu waḻya-waḻya. ");
INSERT INTO nuy_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Warraawurru-yung bagala wurraaḏiyn, wurru-yamayn, “Jesus Buunggawa-yung, nurru anaani nimba-man.galagang nurru!” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nga nigaayung ni-warranggayn wani-nayn, nga buguni wani-magayn, “Nugurru numburru-yaarri nga bagu numbunu-bajiyina, nubagi-yung-guy ni-yamba-yambina-yinyung, na-priest-jung numburru-yiyijgina nugurri-nyinyung warru-gu-gudhar.” Dani-yung ni-yamayn na-Jesus niga. Warraawurru-yung wuu-yanggi… nga aḻagaḻa aḏaba. Wurraarranggayn, wurru-maji-mayn. ");
INSERT INTO nuy_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yagu bagu aynjaabu-nyung waḻyinyung ni-yamayn ni-warranggayn, ni-warra-niini anubani-yung, ni-maji-mayn. Anubanila-wala niigiyn yuuguni na-Jesus-guy. Anubani ni-yanggi bagu, nu-warraarriwaa na-God-guy, yanggarrwar-mirri ni-yambini. ");
INSERT INTO nuy_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Anubani-yung ni-yanggi ni-ḻandharrdhangayn ni-burrdangayn anaani ana-yilhal yuuguni aaban-guy, yarrdiyn. “Yuu, nga,” ni-yamayn na-Jesus-guy. Yagu naagi-yung a-Samaria-yinyung niga na-waḻyinyung. ");
INSERT INTO nuy_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Naagi-yung na-Jesus ni-yamayn, “Warruburru-yung 10 yuga nurru-maji-maa warraawurru warra-waḻya-waḻya? Yagu awurruga warruburru-yung marang-aynjaabugij marri wurru-wulal-wulal awurruga? ");
INSERT INTO nuy_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Naagi-yung niga wubani a-lhal-aynbaj-gala-yinyung a-lhal, yuga naagi-yung-bugij niigiyn, niga nu-warraarriwaa na-God-guy?” ");
INSERT INTO nuy_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nubagi-yung-guy nu-yamijgayn, “Ba-ḻaḻagiiyn aḏaba ba-yaarri. Aadanu yamba nagang nu-ngu-jambarrgiiyn, anaanila-wala aḏaba nu-maṉdhiiyn-bindiyung,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Anubanila-wala, warruburru warra-Pharisee wunu-yandhawiwandi, “Anubani-yung na-God ambani-rangarrii nigawi-nyinyung warru-mandag, lhal-ngargu anubani-yung?” wurru-yamayn. Anubani-yung wani-yambalmayn, “Waari anaaji ana-malnguj, nanggu-bajiyi ana-raga-ragij. ");
INSERT INTO nuy_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Marri waari wurru-yambi ‘Yigaj, anaani-yung aḏaba!’ yagu ‘Yuwaagila!’ anubani waari wurru-yambi. Yagu numburraawanggina. Na-God yaagi aḏaba wani-rangarrii, aani-rruj.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Anubani wani-magayn wurru-marrbuy-maa-wuy, “Wurrugu amaaynbaj-duj, wurrugu ngirri-ngaynbandii ngirri-nayii ngaya, na-Niwiyayung na-Wurrujung-jinyung, numburru-yamana ‘Lhal-ngargu aniigiyn?’ Yagu yagi ngirri-ni. ");
INSERT INTO nuy_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Anubani-yung nambambi-yambina, ‘Numburraarranggang yuuguni!’ yagu ‘Numburraarranggang yaanuwuy!’ Yagi nurru-rumi, yagi narra-garrindharrmi. ");
INSERT INTO nuy_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Yagu yamba ngaya anaani, na-Niwiyayung na-Wurrujung-jinyung, ngandaagiyn-maynji, ngubindi-windiyung nga-milhiynjina ana-wumala-rruj, aajila ramalila marri yuuguni arrgaḻinyi nga-milhiynjina. Nguynju yaga yi-yamiynji ni-mindhii, anggiijamana wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yagu anubani-yumbaa ana-wulhu-wulhurr-waj, malgarrawindi nganggarragayii. Marri warraawurru warra-wurru-wurruj anaani-rruj, ngambambiindirrii ngaya.” ");
INSERT INTO nuy_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Marri ni-yambini-wugij na-Jesus. “Anubani-yung-maynji ngaya ngandaagiyn, ngaya na-Niwiyayung na-Wurrujung-jinyung, anubani-yung anggu-waṉbina nguynju yaga na-Noah-yii anu…bani-yunggaj. ");
INSERT INTO nuy_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Anubani wurru-nguni ana-marrya, marri anaani wurraaḻ-nguni. Marri wuu-lhalamayiynjini, marri wurru-maranguynjini. Wurrugu, niga na-Noah ni-yabiyn amubama-wuy ama-barrawu-wuy. Manubama-yung mana-ngugu ma-waṉiyn, marri wama-jadugayn, marri wama-rubang magurru. ");
INSERT INTO nuy_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Anaani wubani-yunggaj wugurru, niga na-Lot-jinyung, anubani-yumbaa wurru-nguni ana-marrya, marri wurraaḻ-nguni, marri anubani wurru-yiynjini, marri warriini, marri wurraanuynjungaa, marri wirri-raani ana-wumurrng, anaani wiijamaa. Wugurru wunaa-gaminij-gaandirrangi niga na-God waadurru-yung. ");
INSERT INTO nuy_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nga anubani-yung na-Lot naagi-yung ni-rabaliyn anubanila-wala ana-Sodom-gala. Nga anaani-yung ngura yuwaagala arrwar-wala wu-dhirridangi, manaami-yung mana-ṉuga ma-ṉuga-lhalmbaarrangi ma-ṉuga-nagini-windiyung magurraayunggaj ma-ngarrgan-jarramayn ma-rabini. Wanggu-jadugayn anaani-yung, gamuyumuyu wugurru.” ");
INSERT INTO nuy_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Niga ni-yambini-wugij, naagi-yung na-Jesus. “Anaani anggiijamang wurrugu, na-God niga anubani-yung nambani-bajiyina yaani nga ngaya-waj, na-Niwiyayung na-Wurrujung-jinyung. ");
INSERT INTO nuy_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Anubani-yumbaa, ngarrubagi-yung ngarraaḻirr, nugurru-maynji numburru-burraa wubani-rruj arabarabalu-rruj, yagu nugurri-nyinyung anaarra anubani ana-lhirribala-maynji anggu-warra-ngu-burraa, yagi nugurru nurru-yabi, yagi nurraarra-mi ana-wumurrng-gala. Marri nguynju-waj, nugurru-maynji ana-malanganyanay-wala anaanga-wala, yagi nurraagi nugurru. ");
INSERT INTO nuy_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nugurru aadanu aḏaba, numburru-wijangayii marri numburraawanggina ngarrubagi-yung yaga na-Lot-jinyung nga-rangarrina-yung yaga ngiga. ");
INSERT INTO nuy_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nugurru-maynji nimbirri-waṉagana-maynji nugurri-nyinyung ana-wiri, yagu anubani-yung nimbirriij-gajarrgang nugurru aadanu. Yagu nimbirriirruyn-maynji nugurri-nyinyung ana-wiri, yagu nimbirri-waṉagana aadanu. ");
INSERT INTO nuy_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Anaani ngana-magana nugurri-wuy, anubani-yung-maynji ana-miyn.ngu wugurru, ambini-wulawaa waḻya-waa ambini-yara wubani-rruj wuguṉi aanga-rruj. Naaynbajung niga anu-yarina na-God, yagu naaynbajung bagu-waj niga ani-murrgulhaa-wugij. ");
INSERT INTO nuy_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Marri wugurrngiiyung ngarrubirrngi-yumbaa ambingi-wulawaa maṉumbaa, ambingi-yibana, anubani anu-ḏal. Nga na-God ngarrubagi angu-yarina aynjaabu-nyung, ngarraaynbajung angaarruyn ngiga.” Dani-yung niga na-Jesus ni-yambini ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wugurraayung wurru-yamayn warraawurru-yung “Yuga aniga-yung, Buunggawa?” Nigaayung ni-yamayn, “Wubani-rruj yaga wu-ngawina-yinyung ana-wubulu, bagu yaga ngiga ngarrubagi ngarra-marrgij yaga ngiga angi-muṉḏugana.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Naagi-yung na-Jesus wani-ngaynbandangi niga, nguynju yadhu wugurru ambunu-yambina yadhu nigawi-wuy na-God-guy, amburraandha-wuguuguni, yagi yungguyung wurru-lhuṉdhi wugurru. Marri wani-magaa yaani-yung anaani wiij-bulawaa-wala wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ni-yamayn niga, “Anubani-rruj ana-wumurrng, nga nubagi-yung bagu-rruj wani-nguynju-nguynjijgana-yinyung ni-burraa raga-ragij niga. Waari naagi-yung niga ani-ḏirrngawini na-God-guy marri warraawurru-yung niga waniigaminij-gaandirrangi warruburru-yung-guy warra-wurru-wurruj-guy niga. ");
INSERT INTO nuy_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ngigaayung ngarrubagi-yung bagu ngayi-nyung ngi-burri. Ngarraagi-yung ngiga ngi-yanggi-wugij nigawi-wuy. Yaani-yung-bugij ngiga ngi-yamaa, ‘Nubagi niga na-waḻyinyung ni-waṉbina-wugij aladi ngayawi-wuy. Nagang nimba-maṉmang, banu-lhambiyn niga, nimbaagajij-majgana ngaya.’ Dani-yung nga, ngiga ngi-yamaa-wugij, ngi-wandha-wuguuguni ngi-yambini ngiga. ");
INSERT INTO nuy_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Wurrugu niga mal-dhamurrug naagi-yung ni-lhaabini niga. Yagu wurrugu ngijang anubanila-wala ni-yamijgini nigaajbaj, ‘Ngarraagi ngiga aḏaba ngangu-maṉmang. Yagu ngaya anaani waari nga-ngu-ḏirrngawiiyn na-God-guy, marri ngarraagaminij-gaandirrii warruburru-wuy warra-wurru-wurruj-guy. ");
INSERT INTO nuy_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Yagu wiiya aḏaba anaani. Ngarraagi-yung ngarra-ngayi-nyung ngayawi-wugij ngiga ngi-yangga-yanggi, ngangi-yambini-wugij ngayawi-wuy. Ngiga ngangaa-gaṉbina, marri ngangaagajij-majgana. Nguynju yadhu ari yagi ngi-rumi yungguyung, yagi yungguyung ngangi-yandhawiwi, ngangi-yaal-ngawijgi-magi ngaya.’ Dani-yung ni-yamijgaynjini niga naagi-yung na-waḻyinyung.” ");
INSERT INTO nuy_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yaani-yung na-Buunggawa niga ni-yambini-wugij, “Numburraawanggina anaani ana-lhaawu, nubagila-wala naaladi-nyung-gala na-waḻyinyung nubagi-yung wani-nguynju-nguynjijgana-yinyung niga. ");
INSERT INTO nuy_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Yagu niga-waj God anubani ani-waṉbina runggal-windiyung, nugurri-wuy warra-wurru-wurruj-guy ni-wajbarini-yinyung niga, nugurru yamba aadanu nuunaa-gaḏii miyn.ngu marri arrarra nigawi-wuy. Niga-waj nambaniigajij-majgana nugurru aadanu. Yuga baḏag aadanu ani-narrii? Yagi! ");
INSERT INTO nuy_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Anaani ngana-magana, aadanu ani-waṉbang anggiiyn-nguḻu-nguḻug-bugij, nambaniigajij-majgana nugurru aadanu. Yagu anaani ngaya ngandaagiiyn-maynji, ngaya anaani na-Niwiyayung na-Wurrujung-jinyung, yuga ngamba-lhangarrmang ngaya warruburru-yung ambuu-jambarrgina-wugij, anaani-rruj ana-lhal?” Dani-yung ni-yambini na-Jesus, na-nidhaawu-yung. ");
INSERT INTO nuy_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Wugurraayung mulung-arrgi-yung wurru-wurruj bagu, warraawurru-yung yingga wurraaḻamin-jamijgini wugurru anubani-yung yingga wurru-dhi-maṉdhini wugurraajbaj. Yagu waari. Marri warraagaminij-gaandirrangi warra-mulung-arrgi-yung-guy wugurru. Anaanila-wala, na-Jesus wani-magaa anaani-yung wiij-bulawaa-wala wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Niga ni-yamayn, “Wini-wulawaa naawiṉi-yung waḻya-waa wini-yanggi wubani-wuy a-Temple-Maṉngulg-guy, nguynju yadhu wunu-yambini yungguyung na-God-guy. Naaynbajung niga Pharisee-yung, nigaayung naaynbajung niwu-mana-mani-yinyung wuṉuga. ");
INSERT INTO nuy_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Niga naagi-yung na-Pharisee-yung bagu ni-lhaay, nga ni-yambini nigaajbaj. Ni-yamaa, ‘God, ngunu-warraarriwana nagang, ngaya yamba waari ngaynjamang warruburru-yung-jii warra-mulung-arrgi-yung-jii. Ngaya waari ngaynjamang warruburru-yung-jii wurraamaamajaa-yii, yagu warra-dhaayurrii-yinyung, yagu wurraamaji-yinyung warrubawi-yung warra-maṉung. Yagu ngaya waari ngaynjamang nguynju naagi-yung-jii niwu-mundu-munduwaa-yinyung anu-ṉuga niga. ");
INSERT INTO nuy_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ngaya anaani malgarrawindi waari nga-ngang ana-marrya ngaya, nguynju yadhu nga-yambina arrwiyaj. Anubani-yung-maynji 10 anubani-yung nga-mani-maynji, anubani-yung aynjaabugij ngaya ngunuuyii nugawi-wuy.’ Dani-yung ni-yamaa, na-Pharisee-yung niga. ");
INSERT INTO nuy_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Yagu nubagi-yung niga niwu-mundu-munduwaa-yinyung anu-ṉuga, yuwaagu-wajgaj ni-lhaay niga malanganyanay. Waari niga ani-warranggaa anaarrwiyaj, yuuguni ni-waban-nani aaban-guy. Ni-wurrij-baḻgini niga. Nga ni-yamayn, ‘God, nimba-man.galagana ngaya, anaani yamba ngaaladi-windiyung ngaya anaani.’” ");
INSERT INTO nuy_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yaani-yung na-Jesus niga ni-yambini-wugij. “Anaani ngana-magana nugurri-wuy, naagi-yung niwu-nguynmu-nguynmawaa-yinyung anu-ṉuga, niigiyn anubani anaanga-wuy. Nigaayung na-God naagajij-garruyn niga, marri ni-wandhurrg-giiyn yamba aḏaba niga. Yagu niga nubagi naaynbajung niga waari. Anaani wiijamana, nugurru-maynji numburru-runggal-wiiyn, na-God niga nubagi nambani-winyig-gang aadanu. Yagu nugurru-maynji numburru-winyig-gina, God niga-waj nambani-runggal-wana aadanu.” Dani-yung ni-yambini na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Anubanila-wala, warraawurru-yung warra-wurru-wurruj waa-yarrijgini mulung-arrgi-yung nigawi-wuy. Marri mijburrayung waa-yarrijgini ngijang buguni, nguynju yadhu ambani-waṉagaa yungguyung wugurru. Yagu warraawurru-yung wurru-marrbuy-maa-yinyung warra-nayn wugurru. Nga warra-lhambini, “Yagi!” wurru-yamayn wugurri-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yagu niga na-Jesus niiḏangi warruburru-yung-guy warra-mijburrayung-guy. Nga wani-magayn warruburru-yung-guy warra-mulung-aynbaj-guy, “Nambarra-lharrgang waadurru warra-mijburrayung ngayawi-wuy amburru-yaarri, yagi narra-lhambu. Yagu yamba anubani na-God-jinyung anaanga anaarrwar, anubani wugurri-nyinyung, marri warruburru waadurru-yung-jii. ");
INSERT INTO nuy_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","“Ngaya ngana-magana yijgubulu-windiyung nugurru. Waari nurru-burrangi warruburru-rruj warru-mandag-duj na-God-jinyung. Yagu numburru-yamana-maynji nguynju warra-mijburrayung-jii, bani-yung numburru-burraa wugurri-rruj.” Dani-yung ni-yamaa niga. ");
INSERT INTO nuy_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nigaayung nubagi-yung ni-buunggawa-maa-yinyung wurrujung ni-burri bagu niga. Nga niga nu-yandhawiwandi na-Jesus-guy, ni-yamayn, “Barra-yiyina-yinyung nagang mamanunggu-yung, yuga ngaya nganggaṉbina, nguynju yungguyung nga-ngu-burraa anggu-wuguuguni ana-wiri?” ni-yamayn niga. ");
INSERT INTO nuy_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nigaayung na-Jesus nu-yambalmayn nigawi-wuy, “A-yangi yungguyung aadanu ngaya nimba-mayana nga-mamanunggu ngaya nuynjamana nagang? Nigaaj-bugij nga, God na-mamanunggu-yung, waari warraaynbaj warrubawi-yung. ");
INSERT INTO nuy_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nagang nu-marrbuy anaani ana-lhaawu-runggal, yagi barraa-gamajangi warra-maṉung, yagi barra-mulunguwawi warra-wurru-wurruj, yagi barraa-gamajangi, yagi nunggawaḻi, nubiṉi-yung bamba-yandhurrbangana nga-rriibi marri na-ninyarra.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nigaayung nubagi-yung nu-yambalmayn nigaayung, “Anubani-yung nga-gadhuwa-waj ngaya, anaani-yung ngawu-yandhurrbangaa ana-lhaawu, nga anaani-rruj murrubu,” ni-yamayn niga. ");
INSERT INTO nuy_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nigaayung na-Jesus anaani ni-wawanggiiyn aḏaba. Nga yaani-yung ni-yamayn, “Nagang aynjaabugij baaṉbina-yinyung nagang. Ba-yaarri bambarriiyii nugawi-nyinyung anaarrawindi-lhangu marri bambiiyii anu-ṉuga warraambalalari-wuy, marri nagang bawu-waṉagana runggal-windiyung anaarrwar. Aḏaba nagang baaṉiyn, numba-garrindharrmani ngaya.” Dani-yung ni-yamayn na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Naadagi-yung na-waḻyinyung ni-wawanggiyn niga aḏaba anaani. Anubanila-wala niga aḏaba ni-yimurr-jiwuriyn, anaani-yung yamba ni-warra-waṉagaa arrawindi, niimbalal-windiyung naagi-yung na-waḻyinyung. ");
INSERT INTO nuy_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Na-Jesus anubani nu-nani. Nga ni-yamayn “Aadanu wugurru wiij-baḏa-waḏaḏ, warrubawi-yung warraambalal, yagi anubani wu-rumi na-God-guy anaanga. ");
INSERT INTO nuy_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Anaani wiijamana. Ari anubani ana-gamul anggu-yaarri marri anggu-yabiyn ngarrubagi-yung-guy ngarra-jaarru-wuy ngarra-ngarri-ngu-bagaḻang, ngi-ba-ngu-gara-wawalhii-wuy. Aadanu ari wiij-maṉdhina! Yagu anaani wiij-baḏa-waḏaḏ-bindiyung, warrubawi-yung warraambalal yagi wu-rumi anubani-yung na-God-guy anaanga-wuy.” Dani-yung ni-yamaa na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Warraawurru-yung warra-wurru-wurruj wurraawanggini anaani. Nga wurru-yamayn, “Yuga yangi-nyung naadagi na-God ambani-wiri-gana-yinyung wugurru?” ");
INSERT INTO nuy_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nigaayung ni-yamayn, “Wugurru warra-wurru-wurruj waari wurru-wiri-gi wugurraajbaj ana-yimbaj. Yagu God-bugij nigaaj-bugij ambani-wiri-gana-yinyung wugurru,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nigaayung na-Peter nu-yambalmayn, “Yigaj, nurru anaani nirriirruyn nurri-nyinyung anaanga aḏaba, marri anaani ngunu-garrindharrmangi nagang,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nigaayung na-Jesus ni-yamayn wugurri-wuy, “Anaani ngana-magana ngubindi, nagang-maynji bawaarruyn anaanga, yagu nugawi-nyinyung ana-lhal, yagu bangaarruyn-maynji nga-rangarrinaaj yagu na-nilharri yagu na-ninyarra marri nga-rriibi, yagu nugawi-nyinyung warra-mijburrayung, wugurraa yungguyung yadhu warruburru-yung warru-mandag na-God-jinyung, ");
INSERT INTO nuy_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","anubani-yung aḏaba ba-warra-mani nagang anaani-rruj ana-yimbaj arrawindi bayarra. Wurrugu marri ngijang malgadhaadharri aḏaba, nagang ba-wiri anggu-wuguuguni-yinyung.” Dani-yung ni-yambini na-Jesus niga. ");
INSERT INTO nuy_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Warruburru-yung wanii-gaḏiyn warra-12, nigawi-wuy wurru-yanggi aḏaba wugurru. Nga ni-yamayn, “Nugurru aadanu numburraawanggina. Anaani ngaambu-yaarri nga ngaambaadadii aḏaba Jerusalem-guy. Warruburru-yung wunaa-ja-jambini-yinyung wugurru niga na-God, anubani-yung wirriirrarrangi yamba arrawindi lhaawu ngayawi-nyinyung, ngaya anaani na-Niwiyayung na-Wurrujung-jinyung. Anaani-rruj anubani wirriirrarrangi-yinyung wugurru, anaani anaarrawindi-lhangu anggu-waṉbina wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ngaya anaani, warra-mulung-arrgi-yung aḏaba ambarriiyn warra-mulung-aynbaj-guy, waari-yinyung amburru-Jew-magaa. Nga warraawurru-yung ngambambi-gaḻij-gana marri ngambambi-rajburrnayii marri ngambambi-rraana marri ngambambi-yudii. ");
INSERT INTO nuy_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Marri ngambambi-warra-waḏjiwumana marri ngambambiimana. Wurrugu amuulawaa-wala mana-miyn.nganga, ngaya anaani nga-ḻaḻagiiyn.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yagu warraawurru-yung wugurru waari anaani-yung amburru-marrbuy-maa. Anaani-yung ana-lhaawu anaani wiij-miḏaamimi yamba wugurri-wuy. Waari anaani-yung amburru-marrbuy-maa ni-yambini-yinyung niga na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Anubanila-wala aḏaba, warraawurru-yung wuu-yanggi Jericho-wuy, wirri-warubaj-gaa aḏaba. Wurru-yanggi, bagu naagi-yung ni-bagaḻang-aladi ni-burri niga bagu amaadi-rruj. Bagu wani-lhanga-lhangayaani-yinyung niga wuṉuga. ");
INSERT INTO nuy_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ni-wawanggini naagi-yung warraawurru-yung warra-wurru-wurruj wuu-mayn.ngunu-ngunaynjini wuu-yambiynjini wugurru wuu-ngarra-janggi. Marri niga wani-yandhawiwandi “Yuga anubani nuu-yaminggarrina aadanu nugurru? Yangi yuga anubani? Yingga!” ");
INSERT INTO nuy_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Wugurraayung wunu-magayn, wurru-yamayn “Jesus a-Nazareth-jinyung, yaajila-yung ani-yaḻdhii.” ");
INSERT INTO nuy_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nigaayung naagi-yung yanggarrwar niiḏangi aḏaba. Ni-yamayn “Jesus, na-niwiyayung na-David-jinyung, nimba-man.galagang anaani ngaayung!” ");
INSERT INTO nuy_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Yagu warruburru-yung anubagu-yinyung warra-wurru-wurruj anuwaagu wuu-ngarra-janggi-yinyung wugurru warruburru-yung ana-raga-ragij, warraawurru-yung wugurru wunu-yingarraḏdhangi-windiyung niga naagi-yung, wunu-muḏaḏbijgaa niga. Yagu nigaayung niiḏangi-wugij ngijang ngijang ni-yamaa, “Na-niwiyayung na-David-jinyung, nimba-man.galagang ngaya anaani!” ni-yamaa-wugij niga. ");
INSERT INTO nuy_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Bani-yung marri na-Jesus ni-lhangayn. Warruburru-yung wani-magayn warra-wurru-wurruj-guy, nga ni-yamayn, “Numbunu-mang, nga numbunu-yarrijgina bagalu ngayawi-wuy.” Wunu-yarrijgini, nga wunu-burriyn na-Jesus-duj. Niga na-Jesus ni-yamayn, ");
INSERT INTO nuy_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Yangi yuga ngaya anubani nimba-ngaynbandiyn marri waa-gaṉbang nagang?” ni-yamayn. Nigaayung ni-yamayn, “Buunggawa, nimba-maṉdhang ngaya, nguynju yadhu anubani-yung aḏaba nganggarranggang yadhu ngaya.” ");
INSERT INTO nuy_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Nigaayung na-Jesus ni-yamayn, “Baarranggang nagang. Aadanu yamba nu-ngu-jambarrgiiyn, marri aḏaba nu-maṉdhiiyn nagang,” ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nga anubani lhugaajgiyalawaj ni-warranggayn niga. Marri anubani ni-yanggi aḏaba, nu-garrindharrmiyn na-Jesus-guy. Marri nu-warraarriwaa niga na-God-guy. Wugurraayung warruburru-yung warra-wurru-wurruj wunu-nayn-maynji, wugurraayunggaj wunu-warraarriwaa na-God-guy wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Na-Jesus naagi-yung ni-yanggi Jericho-wuy. Buguni ni-lharug-janggi niga. ");
INSERT INTO nuy_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nubagi-yung wurrujung bagu ni-burri, na-nimuwaj-jung ni-mayini Zacchaeus. Naagi-yung ni-buunggawa-maa-yinyung niga niwu-mundu-munduwaa-yinyung a-wuṉuga. Naagi-yung niimbalal-windiyung niga. ");
INSERT INTO nuy_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Naagi-yung nu-ngaynbandangi-windiyung anu-nani na-Jesus. “Yangi-nyung yuga naagi?” ni-yamayn. Yagu naagi-yung niimbara-lhamun.gurrg yamba, yingga ni-yamaa ni-madhangaḏangi yagu waari anu-nani, wurru-wurruj yamba. ");
INSERT INTO nuy_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Anubanila-wala niga waniirruyn, ni-wuwaḻgayn yuuguni raga-ragij. Ni-wayamangi niga, nga ni-warranggayn, nima-nayn nunggurrdha. Amubama-rruj amaadi bagu manaami ma-lhaay magurru. Nga bagu niga ni-wiḏangi nga ni-walamalhangayn niga. ");
INSERT INTO nuy_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nga bagala-yung nigaayung banila-yung na-Jesus ni-yanggi, nimaadi-lharrmangi niga. Ni-warranggayn, nga ni-mal-nayn. Nga nu-yamijgayn, “Zacchaeus, ba-dhirridang nagang, ba-nguḻu-nguḻubiyn. Ana-yimbaj yamba ngaya nga-ngu-burraa nugawi-rruj aanga-rruj.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nigaayung naadagi-yung na-Zacchaeus ni-dhirridiyn-bindiyung ni-nguḻu-nguḻubini. Anubani-yung yamba niga ni-waḻaaḻarrangi. Anubani-yung nu-lhala-miyn niga naagi-yung na-Jesus nu-yarrijgiyn aḏaba yuuguni nigawi-wuy a-wumurrng-guy. ");
INSERT INTO nuy_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Yagu warraawurru-yung warra-wurru-wurruj wunu-nani naagi-yung, wuniirrimarrdangi-windiyung niga, wurru-yamayn, “Naagi na-Jesus ni-yaarri naagi-wuy naaladi-nyung-guy,” wurru-yamayn wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Anubani-rruj ana-wumurrng-duj, na-Zacchaeus niga bagu ni-lhangayn. Nu-yamijgayn na-Buunggawa-wuy, ni-yamayn “Baawanggina nagang anaani Buunggawa. Ngayawi-nyinyung anaani ana-ngurrji, anaarrgi-yung aḏaba ngarraarriini warruburru-wuy warraambaambalalari-wuy. Marri ngijang, ari ngaya ngarra-dhaayurrangi-yinyung warra-mulung-aynbaj, marri ngaarra-waṉagana anaani anaarra. Anubani-yung aḏaba ngambaa-gaagijgina anggu-mal-bulal-wulal-wala.” Dani-yung ni-yamaa niga. ");
INSERT INTO nuy_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nigaayung na-Jesus nu-yambalmayn nigawi-wuy, ni-yamayn “Ana-yimbaj anaani-rruj, wugurru warra-wurru-wurruj anaani-rruj ana-wumurrng, na-God niga wani-wiri-gayn. Niga yamba naagi nigaayunggaj na-niwiyayung na-Abraham-jinyung niga. ");
INSERT INTO nuy_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Anaani wiijamana, ngaya-waj na-Niwiyayung na-Wurrujung-jinyung, anaani nga-yanggi warruburru-yung ngarraagalhaga-lharrmani wurraaṉibina-yinyung. Nguynju ngamba-wiri-gana yadhu ngaya.” Dani-yung ni-yamaa niga na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Wugurraayung warraawurru-yung wurraawanggini anaani ana-lhaawu ni-yambini-yinyung na-Jesus. Anubani-yung warubaj wubani-rruj a-Jerusalem-duj. Warraawurru-yung yingga wurraan-jamaa naagi-yung na-God ambani-bajiyiyn wugurru lhaalhag, ani-buunggawa-maa niga, marri warraarrawindi-lhangu nigawi-nyinyung warru-mandag wugurraayunggaj. Wudani-yung-gala aḏaba, naagi-yung niga na-Jesus ni-magini anaani-yung wiij-bulawaa-wala ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ni-yamaa, “Naagi-yung na-runggal-yung niga ni-yanggi juju…j-gala malanganyanay wubani a-lhal-wuy. Nguynju yadhu naagi-yung ambunu-buunggawa-waa, ani-king-maa wubani-rruj nigawi-rruj a-lhal-uj. Wurrugu marri anubani aniigini ngijang niga. ");
INSERT INTO nuy_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Naagi-yung wanii-gaḏiyn warruburru-yung wunu-yandhurrbangaa-yinyung, 10. Anaani-yung waniini wuṉuga runggal niga, aynjaaynjaabugij-gaj, warruburru-yung-guy. Nga niga ni-yamayn, ‘Numburru-yaarri nga numburraarra-mani, marri ngijang ngirrii-gaagijgina nugurru ngayawi-wuy.’ Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Yagu warruburru-yung anubani-rruj-jinyung ana-lhal naagi-yung wuniirrimarrdangi niga. Naagi-yung wunu-lharrgang niwu-lhaawu-yarrijgini-yinyung wurrugu. Anaani lhaawu wu-yamaa, ‘Waari naadagi-yung naanu-ngaynbandangi, waari niga ni-buunggawa-mi naadagu nurri-wuy,’ wu-yamaa anaani ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Wurrugu marri naagi-yung wunu-runggal-wayn, bagi-yung aḏaba ni-burri ni-buunggawa-maa ni-king-maa niga anubani-rruj. Nga anubani niigiyn niga aḏaba. Nga ni-yamayn, ‘Bambaa-gaḏang warruburru ngambi-yandhurrbangana-yinyung ngaya, anubani-yung ngarriini anu-ṉuga anubani-yunggaj. Nguynju yadhu nga-marrbuy anubani-yung wu-ngargu anubani anu-ṉuga wirri-waṉagaa-yinyung wugurri-nyinyung, anubani-yung-jinyung wurraarra-mangi-yinyung marri wirriigijgini-yinyung wugurru.’ Dani-yung ni-yamayn niga. ");
INSERT INTO nuy_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Nubagi-yung ana-raga-ragij-jinyung nubagi ni-yanggi buguni aḏaba nu-wagarangi nigawi-wuy. Ni-yamayn, ‘Buunggawa, anubani-yung anu-ṉuga numbiini-yinyung nagang, anaani anaarrgi-yung 10 ngaya ngawu-waṉagana anaani,’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Nigaayung ni-yamayn, ‘Aadanu nagang nunggaṉbini ambaḻaman,’ ni-yamayn. ‘Nagang yamba aadanu nunggaṉbini maaḻamburrg-galawaj, aynjaabugij-bugij anu-ṉuga, anaani ngaya wa-maṉdhii nagang, aḏaba ba-buunggawa-mana 10 anubani-rruj ana-wumurrng, nagang, ba-buunggawa-mana.’ Dani-yung nu-yamijgayn niga. ");
INSERT INTO nuy_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Nga nigaayung nubagi naaynbajung niga nu-ga-garri-yurangi ngijang, waḻyinyung. Nga ni-yamayn, ‘Buunggawa, anubani-yung nimbiini-yinyung ngaya anu-ṉuga, anaani ngawu-waṉagana arrgi-yung ngijang marang-aynjaabugij,’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Nigaayung ni-yamayn, ‘Nagang aadanu ba-buunggawa-mana aḏaba marang-aynjaabugij-gala ana-wumurrng, bawu-rangarrii-yinyung nagang,’ ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Nigaayung nubagi-yung naaynbajung ngijang nu-ga-garri-yurangi niga ni-yanggi. Nga niga ni-yamayn, ‘Buunggawa, yaani nugawi-nyinyung anu-ṉuga. Anaani-yung ngaya ngawaarraabaabaa yaaḻi-mirri. ");
INSERT INTO nuy_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ngaya yamba anaani ngunu-yamana nagang, nuynjaal-aynjaabugij yamba nagang. Anubani-yung waari nagang ba-burrangi, anubani-yung nu-mangi. Waari anubani-yung nagang baanuynjungaa yagu nu-mangi anubani-yung ana-marrya nagang.’ Dani-yung ni-yamayn na-wurrujung niga. ");
INSERT INTO nuy_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Nigaayung na-buunggawa-yung ni-yamayn, ‘Aadanu nagang nuynjambini-wala ana-lhaawu, aadanu nugawi-wuy aḏaba ngaya ngunu-lhajbang, nagang yamba aadanu nundaaladi-windiyung! Aadanu nagang nu-marrbuy anaani ngaya nga-yaal-aynjaabugij. Anubani-yung waari ngaya nganggu-burrangi anaaban-guy yagu ngawu-mangi ngijang. Waari anubani ngangganuynjungaa ngaya anu-ḏal, yagu nga-mangi ana-marrya. ");
INSERT INTO nuy_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Yagu a-yangi yungguyung nagang waari bawu-burrangi ngayawi-nyinyung anu-ṉuga ana-bank-duj? Anubani-yumbaa yigaj ngaya ngaagiyn, aḏaba anubani-yung nganggu-mangi anu-ṉuga ngaya, anubanila-wala.’ Dani-yung ni-yamayn niga. ");
INSERT INTO nuy_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Warruburru wani-magayn niga warruburru wurraarragarra-lhi-yinyung, ‘Naadagu-wala nimbirri-mang anubani anu-ṉuga, marri nubagi-wuy naaynbajung-guy numbunuuyn nigawi-wuy, niwu-waṉagana-yinyung 10 niga.’ Dani-yung ni-yamayn nubagi na-buunggawa-yung. ");
INSERT INTO nuy_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Wugurraayung wurru-yamayn, ‘Buunggawa, niwu-waṉagana aḏaba anaani 10 yagu!’ ");
INSERT INTO nuy_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Nigaayung ni-yamayn, ‘Anaani ngana-magana nugurri-wuy, nugurru numburru-marrbuy-yinyung anaani, anubani-yung God nambaniiyii nugurru, nguynju yadhu anubani numburru-marrbuy-wina windiyung nugurru. Yagu nugurru waari-yinyung numburru-marrbuy-mang-jinyung aadanu, yagu nugurru nurraaḻamin-jamana nurru-marrbuy, yagu aadanu na-God aniwu-yarina niga nugurri-wala. ");
INSERT INTO nuy_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Yagu warruburru-yung wugurraayung ngambi-wurrij-marrdii-yinyung ngaya, waari ngaya ngambambi-ngaynbandangi wugurraa yungguyung nga-ngu-buunggawa-maa ngaya, nambarraagina bagala marri nambarra-lhala-mani nambarra-yarrijgina yaaji, nambarruumana, ngayawi-rruj yaaji raga-ragij.’ Dani-yung ni-yamaa, nubagi na-buunggawa-yung niga.” Dani-yung na-Jesus ni-yambini, ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Anubanila-wala, aḏaba niga ni-yanggi-wugij yuuguni Jerusalem-guy, ni-ḻangudhudhurrbini buguni nga aḏaba niga. ");
INSERT INTO nuy_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Wubani-yung-guy ni-yanggi a-lhal-wulawaa-wuy a-lhal, wu-mayini Bethphage marri Bethany. marri buguni ma-ḻandhirrngindi-rruj ma-mayini Mount of Olives. Anubagu, wani-lharrgang wini-wulawaa nigawi-nyinyung wini-marrbuy-maa-yinyung. ");
INSERT INTO nuy_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Wani-yamijgayn, “Nimbini-yaarri wubani-wuy a-wumurrng-guy, nimbini-lhangarrmang bani wu-lhamunu-radbidhaa, wirrig dunggi. Waari anaani-yung ambanggu-warrgaay, ana-dunggi. Marri anubani-yung nimbini-lhamunu-lharrina, marri nimbini-lhamunu-warrgina anubagala ngayawi-wuy. ");
INSERT INTO nuy_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Warraaynbaj-maynji warrubawi-yung nambambi-magang nuguṉi-wuy, nambambi-yandhawawanjii, ‘Niini-yaminggarrina nuguṉi aadanu niini-lhamunu-ngarrgiwana, aadanu ana-dunggi?’ ambu-yamang-maynji, nimbini-yamang nuguṉi, ‘Anaani na-Buunggawa niga ni-ngaynbandii wugurru.’” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Aḏaba wuguṉiiyung nubiṉi-yung waani-lharrgang aḏaba wini-yanggi wuguṉi. Wini-yanggi anaani-yung wini-lhangarrmayn ana-dunggi, wubanila-yung-galawaj yaga na-Jesus ni-yambini, na-nidhaawu-yung. ");
INSERT INTO nuy_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Anubani bagu wini-lhamunu-ngarrgiwaa wuguṉi. Aḏaba warruburru-yung wuu-rangarrangi-yinyung wugurru wurru-yamayn, “Niini-yaminggarrina nuguṉi aadanu niini-lhamunu-ngarrgiwana?” ");
INSERT INTO nuy_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nga wuguṉiiyung wini-yamayn, “Niga yamba na-Buunggawa anaani ni-ngaynbandii wugurru,” wini-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Anubani-yung wini-yarrijgini aḏaba naawiṉi-yung ana-dunggi wugurru. Wini-yanggi na-Jesus-guy. Anubanila, manubama-yung wirrima-ngarrgiwaa yaaḻi nga wuu-rulbu-wabaa. Anubani-yung wunu-maṉmangi naagi-yung niga na-Jesus, ni-wudhangayn arrwa-garrwar. ");
INSERT INTO nuy_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Anubani-yung aḏaba ninggu-warrgaay, ni-yanggi niga. Warraawurru-yung warra-wurru-wurruj wirrima-murrgulhangi wugurri-nyinyung mana-yaaḻi amaadi-waj. ");
INSERT INTO nuy_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Anubani-yung niga ni-yanggi buguni Jerusalem-guy. Aḏaba yuuguni ni-dhirridangi niga a-Mount of Olives-gala. Warruburru-yung wurru-marrbuy-maa-yinyung aḏaba arraarrawindi wurru-wurruj, wurraaḏangi wugurru nigawi-wuy. Warraawurru-yung wurru-waḻaaḻarrangi, marri wunu-warraarriwaa na-God-guy. Anaani-yung ni-waṉbini yamba niga yij-mamaaḻang-bindiyung naagi-yung, lhuḏ-mirri, wunu-nani-yinyung niga. ");
INSERT INTO nuy_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Wugurru wurru-yamaa, “Naadagilu niga ni-yaarri, nigawi yungguyung na-Buunggawa na-God. Naadagilu na-God naagajij-majgana niga. Naadagilu ni-runggal-windiyung niga.” “Anubani wu-mamanunggu-windiyung anaarrwar-rruj. Anaani ngaanu-warraarriwana ngagurru naagila-yinyung anaarrwar-yinyung.” Dani-yung wurru-yamaa wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Warruburru-yung mulung-arrgi-yung bagu Pharisee wurraarra-garra-lhi warruburru-yung-duj. Wurru-yamayn nigawi-wuy na-Jesus-guy, “Barra-marrbuy-wana-yinyung nagang, waadurru bamba-lhambiyn wugurru nugawi-nyinyung wurru-marrbuy-mana-yinyung. Yagi anaani wuu-yambi anaani ana-lhaawu wugurru,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nigaayung naagi na-Jesus wani-yambalmayn wugurri-wuy, “Anaani ngana-magana, ngaya ngamba-lhambiyn-maynji, yijgubulu magurraayung manaami mana-ṉuga amaaḏang magurru.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Naagi-yung ni-yanggi aḏaba buguni ni-warubaj-gaa Jerusalem-guy. Naagi-yung ni-warranggaa, niwu-nani wubani a-wumurrng-guy. Anubani-yung niga ni-ruguni, niga yamba wani-warrngayungaa-windiyung warruburru-yung warra-wurru-wurruj ana-Jerusalem-jinyung wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Anaani-yung ni-yamayn, “Numburru-marrbuy-mang nugurru anaani ana-yimbaj, aniga-yung yuga numburru-lhamaamura-mang nugurru. Yagu aadanu wiij-miḏaamimi wugurru, nugurru yamba mana-muṉbarrg yagi nugurru nurru-warranggi aadanu. ");
INSERT INTO nuy_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","“Anubani-yumbaa anggu-waṉina-maynji, wugurru, anaani anggu-waṉbang nugurri-wuy. Nugurri-nyinyung nurru-wurrij-bangaynjina-yinyung wugurru waadurru ambirrima-muṉḏugana magurru mangarag nga aadanu nambambi-dhawawarumang nugurri-rruj, aadanu nambambi-dhidang wugurru, nguynju yagi yungguyung nurru-yarrami nugurru aadanu. ");
INSERT INTO nuy_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Aadanu ana-wumurrng nugurri-nyinyung, ambirriimana wugurru, nga yuuguni aadanu ambirri-murrgulhang aaban-guy. Marri nugurru aadanu, nugurraayunggaj! Dani-yung warruburru-yung wurru-wiynji-wiynjina-yinyung amburru-waṉbina wugurru. Yagi anubagu ma-murrgulhangi mana-ṉuga marri yagi maalamalhangi manaaynbaj, anubani-yung anggaa-mamaaḻang. Nugurru yamba aadanu waari numburru-marrbuy-maa anubani-yumbaa niga na-God ni-yanggi anaanuwuy ni-wagarangi niga ana-lhal.” Dani-yung ni-yamaa na-Jesus, na-nidhaawu-yung. ");
INSERT INTO nuy_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Anubanila-wala aḏaba ni-yanggi wubani a-Temple-Maṉngulg-guy ni-yanggi. Ni-yanggi, warraawurru-yung wani-man-jarramijgayn niga, anubani-yung yamba wurraarra-yabijgaa arra, wuu-yiynjini wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Naagi-yung wani-magaa, “Ana-wubiba na-God-jinyung wu-yamana, na-God ni-yamayn, ‘Ngayawi-nyinyung ana-wumurrng, nimbirri-mayana ana-wumurrng anaani ngambambi-yambina-yinyung,’ Dani-yung ana-wubiba wu-yamana. Yagu nugurru nirriiynbijgana anaani ana-wumurrng, (Jeremiah 7:11) ‘nguynju yaga warrubawa-yung wurraamajaa marri wu-julubina,’ nurru-yamana.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Naagi-yung ni-yanggi anubani-wuy ana-wumurrng-guy, wani-magaa malgarrawindi niga. Wugurraayung warruburru-yung wuu-yamba-yambini-yinyung warra-priest waa-runggu-runggal, marri warra-yiyini-yinyung ana-lhaawu-runggal marri warruburru-yung wuu-raga-ragaani-yinyung warra-wurru-wurruj, warraawurru-yung wurru-wijangani-windiyung ambunu-jadugang yungguyung wugurru niga. ");
INSERT INTO nuy_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Yagu waari ambirriij-dhangarrmaa wugurru. Yagu waari amburru-waṉbini. Warraawurru-yung warra-wurru-wurruj yamba wunu-yaynjangani niga. Warraawurru-yung wirri-ngaynbandangi windiyung anaani nigawi-nyinyung ana-lhaawu. ");
INSERT INTO nuy_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Anubani-yumbaa naagi-yung na-Jesus wani-magaa bagu a-Temple-Maṉngulg-duj, niga wani-yiyini. Wani-magaa aani-yung a-mamanunggu a-lhaawu. Warraawurru-yung waa-runggu-runggal warra-priest marri warra-yiyini-yinyung ana-lhaawu-runggal marri warruburru-yung warra-mijiwanggu, warraawurru-yung wuu-yanggi nigawi-wuy, wunu-wagarangi. ");
INSERT INTO nuy_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nga bagu wunu-yamijgayn, “Ajigala nagang aadanu nunggaṉbina anaani anaarrawindi-lhangu? Yangi-nyung nagang nimbi-lharrgang, marri nunggaṉbini anaani-rruj?” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nigaayung wani-yambalmayn, “Marri ngaayung anaani nganamba-yandhawiwana nugurri-wuy. Nugurru-waj ngirri-magana danu. ");
INSERT INTO nuy_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ajigala naagi-yung na-John waniimbara-ngambijgaa? Nubagila na-God-gala yagu nugurri-wala warra-wurru-wurruj-gala?” ni-yamaa. ");
INSERT INTO nuy_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Anaani-yumbaa, aḏaba wuu-yambiynjini wugurraajbaj-balij. “Ngagurru-maynji ngaambu-yamana-maynji ‘anuwagala anaarrwar-inyung,’ nigaayung ani-yamang ‘Nugurru a-yangi yungguyung naagi-yung waari numbunaa-ngu-jambarrgini na-John niga?’ ");
INSERT INTO nuy_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Yagu ngaambu-yamana-maynji ‘Warra-wurru-wurruj-gala’, yagu anubani-yung mana-ṉuga warruburru-yung ngambambiimbaḻ-gana, warra-wurru-wurruj. Wurraaḻamin-jamana wugurru, naadagu na-John naa-ja-jambini-yinyung na-God.” Dani-yung wurru-yamaa wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Wudani-yung-gala, warraawurru-yung wurru-yamayn, “Nurru-maḻaḻadi nurru,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nigaayung na-Jesus wani-yamijgayn, “Waari yamba nugurru ngirri-magaa, ngaayung yagi ngana-magi nugurri-wuy, yangi-nyung ngaya ngambi-lharrgang, marri anaani ngaaṉbina.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ngijang anubanila, ni-magini anaani-yung aḏaba, wiij-bulawaa-wala. Anaani-yung ni-yamayn, “Na-waḻyinyung yaga ni-wanuynjungaa wubani-yung a-wuyarrangaḻ nguynju yungguyung aniwu-maṉdhangi wugargayag. Marri wani-lhangarrmayn waḻya-waḻya, warruburru-yung ambirri-rangarrangi ana-lhal, marri anubani-yung ni-yanggi yuuguni a-lhal-aynbaj-guy niga. Nga ni-burri bagu baḏag wurrugu, wubani a-lhal-aynbaj-duj niga. ");
INSERT INTO nuy_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“Anubani-yung lhangarrmayn-jinyung anubani-yung wu-warradangi ana-wuyarrangaḻ. Nu-lharrgang waḻyinyung naa-mijgalmini-yinyung, warruburru-yung-guy wirri-rangarrangi-yinyung-guy, nguynju yadhu waadurru-yung ambunuuni yungguyung bani arrgi wuyarrangaḻ, wubanila-wala wubal. Yagu warruburru-yung wirri-rangarrangi-yinyung, nubagi wunu-bilhargayn na-waḻyinyung, marri wunu-wini naagi-yung, nga wunu-lharrgang, waari ambunuuni, ni-mamar niigiyn niga. ");
INSERT INTO nuy_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Nigaayung naagi-yung na-buunggawa-yung nubagi aynbajung nu-lharrgang nu-yandhurrbangaa-yinyung niga ngijang. Ni-yanggi anubagu niga. Ngijang wuu-yamayn-bugij wunu-wini naagi-yung, wunaambulijgayn niga. Nga naagi-yung wunu-lharrgang niigiyn ni-mamar niga. ");
INSERT INTO nuy_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","“Ngijang naagi-yung na-buunggawa-yung, ngijang aynbajung nu-lharrgang, waḻyinyung. Naagi-yung wunu-miyn, wunu-wini, nga naagi-yung wunu-numaaḏu-wayn aḏaba wunu-barawudiyn niga. ");
INSERT INTO nuy_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Naagi-yung na-buunggawa-yung, niwaaban-baṉagaa-yinyung anubani anaaban, ni-yamayn ‘Anaani yuga ngaya ngaynjaminggarrang anaani? Ari nganu-lharrgang ngayawi-nyinyung na-nigi, nganaa-ḏamarr-ngu-burraa-yinyung. Niga-waj ari ambunu-yandhurrbang.’ Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Yagu warraawurru-yung wunu-nayn naagi-yung na-niwiyayung ni-rabaliyn, nga wuu-yamijgaynjini wugurraajbaj, ‘Numburraarranggang, yaagila na-niwiyayung. Aniwu-mang ari anaani ana-lhal, malgadhaadharri wurrugu nubagi-yung-gala na-yiwanggu-nyung-gala. Numburraaṉiyn, ngaanuumana naagila. Ngagurru-waj anaani ngaanggu-lhal-waṉagana anaani ana-lhal.’ Dani-yung wurru-yamijgaynjini. ");
INSERT INTO nuy_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Aḏaba naagi-yung wunu-barawudiyn aḏaba, nga wunu-wini, wunu-ngawijgayn niga.” Naagi-yung na-Jesus niga ni-yambini-wugij. “Naagi-yung na-buunggawa-yung naagi ani-yaminggarrina anubagu ari? ");
INSERT INTO nuy_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Aniigiyn anubagala waadurru-yung-guy, nga ambani-jadugang, warra-waḻya-waḻya. Anubani ari ana-lhal, ambaniiyn warra-mulung-aynbaj-guy.” Dani-yung ni-yambini anaani ana-lhaawu, na-Jesus niga. Warraawurru-yung wurraawanggini ana-lhaawu. Warraawurru-yung wurru-yamayn wugurru “Girrjag!” ");
INSERT INTO nuy_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nigaayung wani-nayn warruburru-wuy warra-wurru-wurruj-guy. Anubani-yung ni-yamayn niga, “Anaani wiijaminggarrina yuga anaani ana-lhaawu waarrarrina, ‘Warruburru yaga wirri-maṉdhangi wumurrng. Anubagala wirrima-barawudiyn aynjaabugij ṉuga. Yagu manubama mana-ṉuga ma-burraa aḏaba anuwaagu anu-nguḏuṉ-duj, ma-runggal-windiyung magurru.’ Dani-yung wu-yamana ana-wubiba.” ");
INSERT INTO nuy_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Naagi-yung na-Jesus ni-yambini-wugij niga. “Warruburru-yung-maynji warraarrawindi ambuu-rabina manubama-rruj mana-ṉuga-wuy, warruburru-yung amburraarra-wada-wadii, amburru-jadugiiyn wugurru. Yagu mana-ṉuga-maynji anuwagala ama-rabina warruburru-yung ambama-mulhang, manubama-yung ambama-munyurrgang magurru.” Dani-yung ni-yambini na-Jesus, na-nidhaawu-yung niga. ");
INSERT INTO nuy_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wugurraayung warraawurru-yung warra-yiyini-yinyung ana-lhaawu-runggal marri waa-runggu-runggal warra-priest, naagi wunu-ngaynbandangi ambunu-bilhargaa niga bagu. Anubani-yung wurru-marrbuy yamba wugurru wani-magaa anaani ana-lhaawu wugurri-nyinyung niga. Yagu waadurru yamba wugurru wuu-ḏirrngawini warra-wurru-wurruj-gala, yagu waari anaani amburru-waṉbini wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Warraawurru-yung wunu-nani-wugij niga. “Ari ani-yambina aladi,” wurru-yamaa. Wunu-ngaynbandangi ambunu-bilhargaa, marri nubagi ambunuuni na-buunggawa-yung, na-Pontius Pilate-guy, na-nimuwaj-jung. Bagi-yung nga buunggawa-yung ana-lhuḏ aniwu-waṉagaa niga naadagi na-Jesus-inyung. Anubanila warra-lharrgang warruburru-yung warra-waḻya-waḻya. Wurru-yanggi wugurru, wurru-guwaj-gaynjini na-Jesus. Yagu warraawurru-yung wurraawaḻangi wugurru. Wunu-waḻamin-nani. Waadurru-yung wugurru wunu-waḻamin-nguynju-nguynjijgaa niga. Marri anubani wurraawanggini anaani ana-lhaawu, marri ari waadurru-yung yungguyung wugurru ambunu-dhaayurrangi nigawi-wuy, ari ani-yambini yungguyung aladi. ");
INSERT INTO nuy_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Marri wunu-yandhawiwandi wugurru, “Barra-yiyina-yinyung, nurru anaani nurru-marrbuy, nagang nuynjambina maaḻamburrg marri numba-yiyina nagang andhurrg. Marri nunggaṉbina andhurrg warruburru warra-wurru-wurruj-guy. Ngubindi, nagang numba-yiyina aniga-yung na-God ngarrani-ngaynbandii-yinyung niga. ");
INSERT INTO nuy_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Yuga wiij-maṉdhina, ngagurru nganuuyii-yinyung nubagi-wuy na-runggal-yung na-Caesar anu-ṉuga, yagu waari?” Dani-yung wurru-yamayn wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nigaayung ni-marrbuy anaani-yung wunu-dhaayurrijgaa niga. Niga wani-yambalmayn wugurri-wuy, ");
INSERT INTO nuy_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nimbirri-yarrijgina bagalu aadanu anu-ṉuga,” ni-yamayn. Nga wirri-yarrijgini wugurru. Anubani-yung ni-yamayn, “Wa-yangi-nyung anu-malnguj marri ana-muwaj anu-ṉuga-rruj?” ni-yamayn. Wugurraayung wurru-yamayn, “Yagu nubagi na-Caesar niga.” ");
INSERT INTO nuy_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nigaayung ni-yamayn, “Na-Caesar-yinyung anubani-yung, nugurru numbunaa-gaagijgiyn numbunuuyn nigawi-wuy. Marri anubani na-God-jinyung wugurraayunggaj numbunuuyii-wugij.” Dani-yung ni-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yagu warruburru-yung warra-wurru-wurruj wugurraayung wurraawanggini. Yagu warruburru-yung warra-waḻya-waḻya anaani-yung waari ambunu-dhaayurrangi niga, wudani-yung-gala aani-yung a-lhaawu. Warraawurru-yung wurru-wurri-ḻaḻmayn aḏaba, anubani-yung-jinyung wani-yambalmayn-jinyung wugurri-wuy niga. Waari ambuu-yambini ana-lhaawu wugurru. ");
INSERT INTO nuy_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Warruburru-yung mulung-arrgi-yung warra-Sadducee wuu-yanggi. Warraawurru-yung waari ambuu-jambarrgini warrubawi-yung wu-ngawina-yinyung waari wu-wiri-mi wugurru ngijang. ");
INSERT INTO nuy_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Wurru-yanggi bagu, wunu-yambiḻibiḻingaani, naagi-yung na-Jesus niga. Nga wurru-yamayn “Barra-yiyina-yinyung, na-Moses anaani-yung ni-warrarrangi ana-lhaawu, ngagurraa yungguyung. Na-waḻyinyung-maynji nubagi-yung yagi-maynji wani-waṉagi warra-mijburrayung, marri ani-ngawang, nga-rangarrina-yung ngarrubagi-yung angi-wiri, ari bagi-yung nilharri-yung ngijang aniiynji-yara, nguynju yungguyung ari ambangi-yabana mijburrayung nigawi yadhu ni-ngawiiyn-jinyung niga.” ");
INSERT INTO nuy_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Warraawurru-yung warra-Saducee wurru-yambini-wugij. “Warraawurru-yung 7 wuu-dharrmaynjini-yinyung wugurru. Naagi-yung na-wulhu-wulhurr-yung niiynji-yaay, yagu ni-ngawiiyn, waari ambani-lhamaa warra-mijburrayung. ");
INSERT INTO nuy_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ngijang naadhaadharri-nyung niiynji-yaay, ngarrubagi-yung-bugij ngarra-maṉinyung. Waari ambani-lhamaa. ");
INSERT INTO nuy_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ngijang nubagi-yung naadhaadharrila-yung niga ngijang niiynji-yaay-wugij, ngarrubagi-yung-bugij. Warraawurru-yung warra-7, ngarraagi-yung wurraaynji-yaay ngiga aynjaabu-nyung-bugij ngarra-maṉinyung. Waari ngarraagi-yung ambangii-jabaa waadurru-yung. Warraawurru-yung wuu-lhagarra-ngawini aḏaba. ");
INSERT INTO nuy_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Anubanila, ngigaayung ngarra-maṉinyung adhaadharri-windiyung ngi-man-dhamarriyn, ngi-ngawiiyn ngiga. ");
INSERT INTO nuy_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Anubani-yung-maynji warra-wurruj-wurruj amburru-ḻaḻagina anubanila ana-ngawij-gala, wa-yangi-nyung-jinyung ngarra-rangarrina-yung, ngiga yamba ngiiynji-yaay warraarrawindi ngaadagi-yung?” Dani-yung wurru-yamaa, warruburru-yung warra-Saducee. ");
INSERT INTO nuy_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nigaayung na-Jesus wani-yambalmayn niga, “Nugurru aadanu warra-wurru-wurruj anaani-rruj-jinyung ana-lhal-lhangu-yinyung, nurraaynji-yara nugurru. ");
INSERT INTO nuy_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Yagu na-God nigaajbaj ni-wijangayii, warruburru-yung wugurru wurru-maaḻamburrg-jinyung, burru-yung nga ambu-ḻaḻagina ana-ngawij-gala wurrugu marri. Anubani-yung waari wugurru wurraaynji-yingi. ");
INSERT INTO nuy_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Yagi yamba wugurru anubani-yung wurru-ngawi wurru-malgaagijgi ngijang. Amburru-burraa yamba ambuu-yamana nguynju aani a-angel-yii yaga. Warruburru-yung warra-mijburrayung na-God-jinyung, wugurru yamba amburraanggarra-ḻaḻagina yamba wugurru ana-ngawij-gala. ");
INSERT INTO nuy_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Anaani ngubindi, nga-yamana, warruburru-yung wurru-ngawini-yinyung marri amburru-ḻaḻagiiyn wugurru ngijang. Na-Moses niga anaani ngarrani-yiyina ngagurru. Anaani-rruj ana-wubiba wu-yamana wubani yaga ni-yanggi ni-lhalga-waj yaga, wubani-yung yaga wu-nagini a-rangag. Nga anubani-yung niga ni-yambini na-Buunggawa-wuy, marri nu-mayaa niga anubani-yung ‘Nagang aadanu na-God na-Abraham-jinyung marri na-Isaac-jinyung marri na-Jacob-jinyung,’ ana-wubiba anaani wu-yamana. ");
INSERT INTO nuy_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Na-God-jinyung warra-wurru-wurruj, warruburru-yung waari-yinyung amburru-ngawini, warruburru-yung wurru-wiri. Warraarrawindi yamba wurru-burraa, wurru-wiri wugurru, nigawi-rruj na-God-duj aḏaba.” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wugurraayung warra-mulung-arrgi-yung warra-yiyini-yinyung ana-lhaawu-runggal wunu-yambalmayn niga, “Barra-yiyina-yinyung, nagang aadanu nuynjambini yij-mamaaḻang nagang ana-lhaawu,” wurru-yamayn. ");
INSERT INTO nuy_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Anubanila-wala, waari warraaynbaj wugurru amburru-wurrij-baabara-maa. Yagu waari anaani ambunu-yambiḻibiḻingaani niga ngijang. ");
INSERT INTO nuy_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yagu niga wani-magayn wugurri-wuy, “Warra-wurru-wurruj wurru-yamana, naadagu na-Messiah, nubagi na-runggal-yung na-God-gala, naadagu na-niwiyayung na-David-jinyung niga. Anaani anggiijaminggarrina wugurru anggiij-maṉdhiiyn? ");
INSERT INTO nuy_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Niga-waj yamba David ni-yambini anubani-yung ana-wubiba-wuy anu-muwaj wu-mayina wugurru Psalms, anu-ngubal, ni-yamayn niga, ‘Na-God nu-magaa na-king-guy, ngayawi-nyinyung-guy na-buunggawa-wuy, “Ba-burrangang yaaji ngayawi-rruj a-walawalama-rruj. ");
INSERT INTO nuy_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Wurrugu marri, nugawi-nyinyung warruburru nurru-wurrij-marrdiynjini-yinyung, wurrugu ngamba-burrang nugawi-rruj a-mun-duj, bamba-mun-ban.ngang.” ’ Dani-yung na-David ni-yamaa niga, anaani waarrarrina ana-wubiba-rruj.” ");
INSERT INTO nuy_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Na-Jesus ni-yambini-wugij niga. “Na-David niga-waj nu-mayaa nubagi-yung na-king, na-Messiah, ‘Buunggawa’, ni-yamaa. Yuga na-David-jinyung na-niwiyayung, nubagi na-David-jinyung na-buunggawa-yung?” Dani-yung ni-yamaa na-Jesus. ");
INSERT INTO nuy_vpl VALUES ("LK20_45","072_20_45","LUK",