﻿USE sofia;
DROP TABLE IF EXISTS sofia.nuq_vpl;
CREATE TABLE nuq_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nuq_vpl WRITE;
INSERT INTO nuq_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Teenei te moe iho na tipuna Jisas Krais te mokopuna Devit raa, tena Devit he mokopuna Abraham. ");
INSERT INTO nuq_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","6a Aanei na inoa na tipuna Jisas Krais kaamata Abraham haere no tae te saaita te tuku Devit: Abraham, Aisak, Jekop, Juda ia ma na taina aia raa, tena Peres laaua ma Sera (te tinna laaua raa ko Tamar), Hesron, Ram, Aminadap, Nason, Salmon, Boas (te tinna aia raa ko Rehap), Obet (te tinna aia raa ko Rut), Jesi, tena te tuku Devit. ");
INSERT INTO nuq_vpl VALUES ("MT1_6b","070_1_6b","MAT","1","6b","6b","11 Tena kaamata Devit haere no tae te saaita na tama Israel raa ni too ria no kkave i Babilon: Devit, Solomon (te tinna aia raa ko te avana Uria i mua), tena Rehoboam, Abaija, Asa, Jehosafat, Jehoram, Usaia, Jotam, Ahas, Hesekaia, Manase, Amon, Josaia, tena Jehoiakin ia ma na taina aia raa. ");
INSERT INTO nuq_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","16 Aanei alaa tipuna taatou e mmau hoki i roto te launiu kaamata te saaita i muri na tama Israel raa ni too ria no kkave i Babilon haere no tae te saaita Jisas ni haanau iho: Jehoiakin, Sealtiel, Serubabel, Abiut, Eliakim, Asor, Sadok, Akim, Eliut, Eliesa, Matan, Jekop, tena Josep te avana Meri te tinna Jisas tera na tama e kanna ma ko te Mesaia raa. ");
INSERT INTO nuq_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ia tena e isi sanahuru ma haa na tautama kaamata te saaita Abraham haere no tae te saaita Devit, tena e isi hoki teeraa sanahuru ma haa na tautama kaamata te saaita Devit haere no tae te saaita na tama Israel raa ni too ria no kkave i Babilon raa, tena e isi hoki teeraa sanahuru ma haa na tautama kaamata te saaita na tama Israel raa ni too ria no kkave i Babilon haere no tae te saaita Jisas ni haanau iho raa. ");
INSERT INTO nuq_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Teenei ko na tattara i te haanau iho Jisas. Meri te tinna Aia raa e hakamattino ma ki avana Josep, e meia i mua laaua e hakapaa, Meri ku iroa pera ma aia ku hai tama i na mahi TeAnana Tapu. ");
INSERT INTO nuq_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josep he tama e ppena tahi na mee e ttonu, tena aia se hihai ma ki mee Meri ki napa i mua na karemata na tama hakaatoa; kito aia ki mee na maanatu ma ki tiaki hemuu Meri. ");
INSERT INTO nuq_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Te saaita aia koi noho koi ma na maanatu aia ma ki peesia Meri raa, te ensel TeAriki raa ku tuu ake i roto te miti no meake ma, “Josep, te mokopuna Devit, auu se mataku te too Meri ki mee mo avana akoe. Maitaname aia e hai tama i na mahi TeAnana Tapu. ");
INSERT INTO nuq_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Meri e me ki haanau te tamariki tanata, tena akoe ku hui te inoa te tamariki naa Jisas, maitaname te Tamariki naa e me ki hakasao te kanohenua Aia raa i taha ma na hai sara laatou.” ");
INSERT INTO nuq_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tena na mee nei hakaatoa e kapihi mai ki huri mai te hakamaoni hea TeAtua ni tattara ake na profet Aia raa ma, ");
INSERT INTO nuq_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“He taukupu e tonu e me ki hai tama no haanau te tamariki tanata, tena te tamariki naa e me ki hui Imanuel” (e mee ma, “TeAtua e noho ma taatou”). ");
INSERT INTO nuq_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josep ku mahike i aruna, tena ki too Meri no avvana laaua. Josep e tautari hea te ensel raa ni tattara ake aia ki ppena raa. ");
INSERT INTO nuq_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Emeia Josep se moemmoe laaua ma Meri haere no tae roo te saaita Meri ni haanau te tamariki tanata raa. Tena Josep ki hui te inoa te tamariki raa Jisas. ");
INSERT INTO nuq_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jisas e haanau mai i te matakaina Betlehem i roto Judia te saaita Herot ni tuku. Meri e mamaoha no oti, tena se roroa na tama i te anake e mattonu i te vahi na hetuu raa ku ttae ake i Jerusalem ");
INSERT INTO nuq_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","no vahihhiri ma, “Teehee te tamariki e haanau iho ki mee mo tuku na Jiu naa? Maatou e kkite te hetuu Aia raa te saaita te hetuu raa ni tuu ake i te vahi te anake, ia tena maatou e oo mai ma ki hakamaru ake te tamariki naa.” ");
INSERT INTO nuq_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Te saoaita Herot ni rono na tattara ma e isi teeraa tuku ku haanau iho, aia ku se hihia roo, ia hoki na tama hakaatoa i roto Jerusalem raa ku se hihhia. ");
INSERT INTO nuq_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tena Herot ki kanna ake na maatua hakananniu raa ia ma na tama poroporo na tuaa raa ki hakkutu ake hakaatoa, tena aia ki vahiri ake na tama raa ma, “Te Mesaia raa e me ki haanau mai i hee?” ");
INSERT INTO nuq_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kito na tama raa ki meake ma, “Te Mesaia raa e me ki haanau iho i te matakaina Betlehem i roto Judia, e mee na profet raa ni tattaa ma: ");
INSERT INTO nuq_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betlehem e tuu i roto Judia, akoe he matakaina e hakanaaniu hoki i roto na matakaina Judia raa, maitaname he tama hakanaaniu e me ki haanau iho i te kina naa; he tama e me ki hakattaki Israel te kanohenua Anau raa.’ ” ");
INSERT INTO nuq_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kito Herot ki kanna ake na tama mattonu ni oo mai peeraa i te anake raa ma ki kkutu hemuu ma aia, tena aia ki vahiri ake na tama raa ma ki iroa aia te saaita hee roo te hetuu raa ni hopo ake. ");
INSERT INTO nuq_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tena aia ki kauna na tama mattonu raa ki oo i Betlehem ma na tattara nei, “Oo no ssee hakaraoi roo te tamariki naa, tena te saaita kootou e kkite te tamariki naa, kootou ku hakari mai ki iroa anau ki haere hoki anau no hakamaru te tamariki naa.” ");
INSERT INTO nuq_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","10 Kito na tama raa ki oo, e meia te saaita na tama raa koi oo koi, na tama raa ku kkite te hetuu laatou ni kkite i te vahi te anake raa. Ia te saaita na tama mattonu raa ni kkite te hetuu raa, na tama raa ku hihhia roo! Te hetuu raa e haere i mua na tama raa no tae roo i te kina te tamariki raa e moe raa, tena ki hakamau. ");
INSERT INTO nuq_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Na tama mattonu raa ku oo no uru i roto te hare raa, ia te saaita na tama raa ni kkite te tamariki raa laaua ma Meri te tinna aia raa, na tama raa ku tutturi no hakamaru ake te tamariki raa. Tena na tama raa ki uhu ake na gol, na rehu e mannoni hakaaroha raa ia ma na maraseni e pena i na laakau e sui mmaha raa, tena ki kou ake na mee raa mo hoki te tamariki raa. ");
INSERT INTO nuq_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kito na tama raa ki tauttari teeraa mateara no vakkai i te matakaina laatou raa, maitaname TeAtua ni tattara ake na tama raa i roto te miti ma ki se lavaa te vakkai iaa Herot raa. ");
INSERT INTO nuq_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Te saaita na tama mattonu raa ni vakkai, te ensel TeAtua raa ku tuu ake iaa Josep i roto te miti no meake ma, “Herot e me ki sesee te tamariki naa ma ki taa ki mate. Mahike i aruna no too te tamariki naa laaua ma te tinna aia raa no hakassao no oo i Isip, tena kootou ku nnoho i te kina naa ki ttae roo te saaita anau e me ki meatu kootou ki vakkai mai muri.” ");
INSERT INTO nuq_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kito Josep ki mahike te poo naa no too te tamariki raa laaua ma Meri no oo te poo naa koi i Isip, ");
INSERT INTO nuq_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","tena laatou ki nnoho i Isip no tae roo te saaita Herot ni mate. Na mee nei e kapihi mai ki mee na tattara TeAtua ni tattara ake na profet i mua raa ki hakamaoni ma, “Anau e kanna te tamariki tanata Anau raa ki haere i taha ma Isip.” ");
INSERT INTO nuq_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herot ku roto roo te saaita aia ni iroa ma na tama mattonu i te vahi te anake raa e malliu ake aia. Tena aia ki hakamoe te tattara e ivi ma ki taa na tamalliki taanata hakaatoa i roto Betlehem ia ma na matakaina tappiri ake raa hoki; na tamalliki taanata tera ku ttae e rua na hetau te mattua laatou haere sara mai i raro. Herot e ppena te mee nei tautari te iroa aia ni too i na tama mattonu i te anake raa te saaita roo te hetuu raa ni hopo ake. ");
INSERT INTO nuq_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Na mee nei e kapihi mai, tena na tattara TeAtua ni tattara ake Jeremaia raa ku hakamaoni ma: ");
INSERT INTO nuq_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Te nnana e hamai peeraa i Rama, te nnana na tama e ttani okioki roo. Resel e tanitani i na tamalliki aia, tena aia se hihai ma ni tama ki oo ake no hakatattara hia aia, e mee na tamalliki aia raa hakaatoa ku mmate.” ");
INSERT INTO nuq_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","I muri Herot ni mate, te ensel TeAtua raa ku tuu ake iaa Josep i roto te miti no tattara ake ma, ");
INSERT INTO nuq_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Mahike i aruna no too te hai tinna akoe naa, tena kootou ku oo i Israel, maitaname na tama ni hahaivi ma ki taa te tamariki naa ku mmate.” ");
INSERT INTO nuq_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tena Josep ku mahike i aruna no too te tamariki raa laaua ma Meri no vakkai i Israel. ");
INSERT INTO nuq_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Emeia te saaita Josep ni rono ma Arkelaus, te tama Herot raa ku tuku i Judia, aia ku mataku te vaakai i te matakaina raa. Kito TeAtua ki tattara ake hoki Josep i roto te miti, tena Josep ki haere i Galili ");
INSERT INTO nuq_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","no noho i roto he matakaina hokotahi i Nasaret. Tena na tattara na profet nei raa ku hakamaoni: “Te Tamariki raa e me ki kanna ria pera ma he tama i Nasaret.” ");
INSERT INTO nuq_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Te saaita naa Jon Baptis ku haere iho i taha ma te kina e tuu mahoa i roto Judia raa, tena ki kaamata no takutaku. ");
INSERT INTO nuq_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Jon e takutaku ma, “Ttike i taha ma na hai sara kootou, maitaname te hakamaatua ana i te Vaelani raa ku taapiri ki hamai!” ");
INSERT INTO nuq_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon ko te tama profet Aisaia ni tattara mai te saaita aia ni mee ma, “E isi te tama e tattara hakamaroa i te kina e tuu mahoa raa ma, ‘Tanattana te mateara TeAriki raa; Tena hakattonu na mateara raa ki ttonu ki hamai Aia vaa aruna!’ ” ");
INSERT INTO nuq_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Na hekau Jon raa e pena i na kiri na kamel, tena te taitu aia raa he kiri hoki te manu, tena aia e kaikai na lokas ia ma na hani vaa roto. ");
INSERT INTO nuq_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tammaki na tama i Jerusalem ma na tama i roto Judia raa hakaatoa ia ma na tama na henua tappiri i te riva Jordan raa ku oo ake iaa Jon. ");
INSERT INTO nuq_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Na tama raa e uiui na hai sara laatou raa, tena Jon ki hakoukou tapu na tama raa i roto te riva Jordan. ");
INSERT INTO nuq_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jon e kite tammaki na Farisi ia ma na Sadyusi e oo ake ma aia ki hakoukou tapu laatou, tena aia ki hai ake na tama raa ma, “Kootou ni lapono! Koai te tama e meatu ma kootou e lavaa te hakassao i taha ma na hakalono llihu TeAtua e me ki kou atu kootou raa? ");
INSERT INTO nuq_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ppena na mee e me ki huri ake pera ma kootou ku ttike i taha ma na hai sara kootou raa. ");
INSERT INTO nuq_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Auu se mannatu ma kootou e me ki tattara ma Abraham he tipuna kootou, tena ma kootou ku lavaa te hakassao i taha ma na hakalono llihu raa. Anau e meatu pera ma TeAtua e lavaa te huri na hatu nei ki mee pera ma ni mokopuna Abraham! ");
INSERT INTO nuq_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Te takuu raa ku tanattana ki ttuu na patiaka na laakau raa; na laakau hakaatoa se hhua na hua taualleka raa e me ki tuutia ki hhina, tena ku lletua i roto te ahi. ");
INSERT INTO nuq_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Anau e hakoukou tapu kootou ma te vai ki huri atu pera ma kootou ku ttike i taha ma na hai sara kootou, e meia te tama e me ki hamai i muri anau raa e me ki hakoukou tapu kootou ma TeAnana Tapu ia ma te ahi. Aia e hakanaaniu i aruna anau, tena anau se tau hoki te sausau na taka Aia raa. ");
INSERT INTO nuq_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tama raa e tuu ma te taitahi Aia raa ki hakkutu na maanunu na hua raa. Aia e me ki hakkutu na kai Aia raa i roto te hare hakananaopo na kai raa, tena ku ttuni na penu raa i roto te ahi se lavaa te mate raa.” ");
INSERT INTO nuq_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jisas e hamai peeraa i Galili te saaita naa, tena Aia ki haere iaa Jon i te riva Jordan raa ma Jon ki hakoukou tapu Aia. ");
INSERT INTO nuq_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Emeia Jon e hahaivi ma ki mee Jisas ki hakatike te hakataakoto Aia, tena aia ki meake, “Akoe avare e tau te hakoukou tapu anau, ia tena Akoe ku hamai ma anau ki hakoukou tapu Akoe!” ");
INSERT INTO nuq_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Emeia Jisas e meake Jon ma, “Tiaki koi ki moe peenaa te saaita nei. Maitaname teenei te ara taaua e lavaa te ppena na mee hakaatoa TeAtua e hihai raa.” Kito Jon ki hakatina ake hoki. ");
INSERT INTO nuq_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jisas e hakoukou tapu ria koi no oti, tena Aia ki haere i taha ma te riva raa. Te vaelani raa ku taaraki iho, tena Aia ku kite TeAnana Tapu TeAtua raa ku llee iho pera ma he rupe i aruna Aia. ");
INSERT INTO nuq_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tena te reo TeAtua raa ku tattara iho i te vaelani ma, “Teenei he tamariki roo Anau e hakasessere mahi, Anau e hihia roo Aia.” ");
INSERT INTO nuq_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tena TeAnana Tapu raa ku hakattaki Jisas i te kina e tuu mahoa raa ma Satan ki tatakore Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jisas e noho tipu haa na aho ia ma na poo se kai, tena Aia ku rono te hikai. ");
INSERT INTO nuq_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kito Satan ki haere ake no meake Jisas ma, “Kame Akoe he Tamariki hakamaoni TeAtua, Akoe ku meake na hatu nei ki huri mo haraoa.” ");
INSERT INTO nuq_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kito Jisas ki meake ma, “Te Launiu Tapu raa e tattara mai ma, ‘Na tama se mee ma e ora koi i na haraoa, e meia na tama e ora i na tattara hakaatoa TeAtua e tattara raa.’ ” ");
INSERT INTO nuq_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kito Satan ki hakattaki Jisas i Jerusalem, i te Matakaina e Tapu raa no hakatuu Tama raa i te kina e palluna roo i aruna te Hare Tapu raa, ");
INSERT INTO nuq_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","tena aia ki meake, “Kame Akoe he Tamariki hakamaoni TeAtua, Akoe ku llee i raro, maitaname te Launiu Tapu raa e tattara mai ma, ‘TeAtua e me ki meake na ensel Aia raa ki mmata hakaraoi Akoe; na ensel raa e me ki ttaohi Akoe ma na rima laatou; ki se lavaa na vae Akoe raa te pakuu na hatu raa no mmere.’ ” ");
INSERT INTO nuq_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Kito Jisas ki meake, “Emeia te Launiu Tapu raa e tattara hoki ma, ‘Auu se hahaaite TeAriki TeAtua akoe raa.’ ” ");
INSERT INTO nuq_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kito Satan ki hakattaki Jisas i aruna te mouna palluna roo no huri ake na henua hakaatoa i roto te maarama nei ia ma na mee taualleka hakaatoa na henua raa e isi. ");
INSERT INTO nuq_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kito Satan ki meake, “Anau e me ki kou atu na mee nei hakaatoa kame Akoe e tuturi no lotu mai anau.” ");
INSERT INTO nuq_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tena Jisas ki meake, “Satan, haere i taha! Te Launiu Tapu raa e mee ma, ‘Lotu ake TeAriki TeAtua akoe raa, tena ku hehekau koi ma Tama raa!’ ” ");
INSERT INTO nuq_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kito Satan ki tiaki Jisas no haere, tena na ensel raa ki oo ake no tokonaki Jisas. ");
INSERT INTO nuq_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jisas ku rono ma Jon ku ponotia i roto te hare karapusi, tena Aia ki tiaki te kina raa no haere i Galili. ");
INSERT INTO nuq_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Aia se noho hoki i Nasaret, e meia Aia e haere no noho i Kaperneam, he matakaina e tuu i te vahi te Namo Galili i roto na henua Sebulun laaua ma Naptali. ");
INSERT INTO nuq_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Te mee nei e kapihi mai ki hakamaoni na tattara profet Aisaia ni tattara mai i mua ma, ");
INSERT INTO nuq_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Te matakaina Sebulun, ia ma te matakaina Naptali raa e ttuu i te kina te mateara e haere i tai i teeraa vahi te riva Jordan i Galili, te matakaina na tama seai ma ni Jiu raa! ");
INSERT INTO nuq_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Na tama e nnoho na kina poouri raa e me ki kkite te maahina e rahi roo, te maahina raa e me ki hakamaahina atu i kootou na tama tera e nnoho i raro te maru te mate raa.” ");
INSERT INTO nuq_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jisas e kaamata te saaita naa no takutaku ma, “Ttike i taha ma na hai ssara kootou, maitaname te Hakamaatua ana i te Vaelani raa ku taapiri mai!” ");
INSERT INTO nuq_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Te saaita Jisas ni hahaere vaa tai te Namo Galili, Aia e kite tokorua na haanau, ni tama meemee ika, tokorua raa ko Saimon (na tama e kanna ma ko Pita raa), tena Andru te taina Pita raa, tokorua raa e puipui te kupena. ");
INSERT INTO nuq_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kito Jisas ki meake tokorua raa, “Tauttari mai Anau, tena Anau e me ki akoako koorua ki hahannota na tama.” ");
INSERT INTO nuq_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Te saaita naa koi tokorua raa ku tiaki na kupena raa no tauttari Jisas. ");
INSERT INTO nuq_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jisas e hakanuu atu no kite teeraa haanau hoki, Jems laaua ma Jon ni tama Sebedi. Tokorua raa e nnoho ma Sebedi te tamana laaua raa i roto te manaui no tanattana na kupena laatou raa. Kito Jisas ki kanna ake tokorua raa, ");
INSERT INTO nuq_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","tena te saaita naa koi tokorua raa ku ttiaki te tamana laaua raa ma te manaui raa no tauttari Jisas. ");
INSERT INTO nuq_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas e areha na matakaina hakaatoa i Galili raa no akoako i na hare lotu na Jiu raa, tena ki takutaku ake te Rono Tauareka i te vahi te Hakamaatua ana i te Vaelani raa, tena ki tokonaki hoki na tama hakaatoa e lavvea na maahana raa no taualleka. ");
INSERT INTO nuq_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Te rono Jisas raa ku paa no ttae i na kina hakaatoa i roto Siria, tena na tama raa ku kou ake na tama e lavvea, na tama e hakalono llihu i na maahana roo hakaatoa, na tama e tuttuu haeo i na tinotama laatou, na tama e ttau ria na tipua, ia na tama e peuppeu ia ma na tama na vae e mmate raa. Jisas e tokonaki na tama raa hakaatoa no taualleka. ");
INSERT INTO nuq_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tena he kanohenua e rahi roo ku tauttari Jisas kaamata i Galili laaua ma Dekapolis, tena Jerusalem, Judia ia ma na matakaina i teeraa vahi te riva Jordan raa. ");
INSERT INTO nuq_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas e kite ma na kanohenua raa e tauttari Aia, tena Aia ki haere i aruna te mouna raa no noho. Na disaipol Aia raa e nnoho hakattike Tama raa, ");
INSERT INTO nuq_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","tena Aia ki kaamata no akoako ake na kanohenua raa: ");
INSERT INTO nuq_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Na tama na anana laatou raa e matanaennae raa e me ki hakatapu ria; te Hakamaatua ana i te Vaelani raa he kina na tama naa! ");
INSERT INTO nuq_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Na tama e ppari raa e me ki hakatapu ria; TeAtua e me ki mee hakaraoi na tama naa! ");
INSERT INTO nuq_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Na tama e laumarie raa e me ki hakatapu ria; na tama naa e me ki too na mee TeAtua ni tattara mai raa! ");
INSERT INTO nuq_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Na tama e hihhai roo ki ppena na mee TeAtua e hihai raa e me ki hakatapu ria; TeAtua e me ki kou ake na mee roo hakaatoa i na tama naa. ");
INSERT INTO nuq_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Na tama e manava alloha alaa tama raa e me ki hakatapu ria; TeAtua e me ki hai aroha na tama naa! ");
INSERT INTO nuq_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Na tama e ttonu i na hatu manava laatou raa e me ki hakatapu ria; na tama naa e me ki kkite TeAtua! ");
INSERT INTO nuq_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Na tama e hehekau ma ki too te noho laoi raa e me ki hakatapu ria; TeAtua e me ki kanna na tama naa pera ma ni tamalliki Aia! ");
INSERT INTO nuq_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Na tama e hakalono llihu e mee laatou e ppena hea TeAtua e hihai raa e me ki hakatapu ria; te Hakamaatua ana i te Vaelani raa he kina na tama naa! ");
INSERT INTO nuq_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kootou ki hihhia te saaita na tama e haru haeo, tena ki kou atu na hakalono llihu, tena ki hatuhatu na tattara malliu i kootou e mee kootou e tauttari Anau. ");
INSERT INTO nuq_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kootou ki hihhia roo, maitaname te tuhana e rahi raa e moe ma kootou i te vaelani. Na profet i mua kootou raa ni too na hakalono llihu peenei hoki. ");
INSERT INTO nuq_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Kootou e sau pera ma ko te sol na tama hakaatoa i te maarama nei. Emeia kame te sol raa ku se mmara, akoe ku se lavaa te mee te sol raa ki mmara hakaraoi. Te sol raa ku haeo, tena ku peesia i aho ki oo ake na tama no lakalaka vaa aruna. ");
INSERT INTO nuq_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kootou e ssau pera ma ko te maahina na tama hakaatoa i te maarama nei. Te matakaina e tuu i aruna te mouna raa se lavaa te lluu ria. ");
INSERT INTO nuq_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Se hai tama e hakaura te lamu no uhi i raro te kumete; e meia te lamu raa e me ki hakatootoo i aruna ki maahina i hare raa ki kkite na tama hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kootou hoki ki hakamaahina i mua na tama hakaatoa pera ma he lamu; ki kkite na tama raa na mee taualleka kootou e ppena raa, tena na tama raa e me ki hakammaha te Tamana kootou i te vaelani raa. ");
INSERT INTO nuq_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Auu se mannatu ma Anau e hamai ki seu na Tuaa Moses ia ma na akoako na profet raa. Anau se hamai ki seu na mee naa, e meia Anau e hamai ki mee na akoako raa ki hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kootou ki mannatu, te saaita te vaelani ia ma te maarama nei koi ttuu, se lavaa he tattara ia ma he paa mee i roto na tuaa raa e me ki seua ria ki tae roo te saaita te hakaotioti na mee roo hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ia tena koai te tama se tautari he tuaa i roto na tuaa raa, tena ki akoako alaa tama ki tauttari aia, te tama naa e me ki hakamuri roo i te Hakamaatua ana i te Vaelani raa. Teeraa mee hoki, koai te tama e tautari na tuaa raa, tena ki akoako alaa tama ki tauttari aia, te tama naa e me ki hakamaatua i roto te Hakamaatua ana i te Vaelani raa. ");
INSERT INTO nuq_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tena Anau e meatu kootou pera ma kootou e lavaa te ttae i te Hakamaatua ana i te Vaelani raa kame na hakattina kootou raa e hai mmahi roo i aruna na hakattina na tama e poroporo na tuaa ia ma na Farisi raa i te ppena hea TeAtua e hihai raa. ");
INSERT INTO nuq_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kootou ni llono pera ma na tama i mua raa ni illoa ma, ‘Se taa na tama ki mmate; te tama e taa te tama no mate raa e me ki tuu i mua na tama hakatonutonu raa.’ ");
INSERT INTO nuq_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Emeia te saaita nei, Anau ku meatu kootou: kame akoe e hakatauttau ma te taina akoe raa, tena akoe e me ki tuu i mua na tama hakatonutonu raa, ia kame akoe e meake te taina akoe raa ma, ‘Te manapuhi,’ akoe e me ki tuu i mua na tama hakatonutonu raa hoki, ia kame akoe e hai ake hakahaeo i te taina akoe raa ma teeraa he vvare, tena akoe e me ki haere i te kina te ahi raa. ");
INSERT INTO nuq_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Kame akoe ku tanatana ki kkave te hoki akoe raa i te kina te olta, tena te maanatu akoe raa ku tere ake pera ma koorua hai taina e nohonnoho haeo, ");
INSERT INTO nuq_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tena tiaki te hoki akoe naa ki moe i te kina te olta raa, tena akoe ku haere vave no tattara hakaraoi koorua hai taina, tena ki oti akoe ku vaakai no kou ake te hoki akoe raa i TeAtua. ");
INSERT INTO nuq_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kame he tama e sara koorua, tena aia ku ppono akoe i te kot, haere no tattara hakaraoi koorua te saaita na tama raa se ki ttaohi te kot raa, ia i mua hoki akoe e tuu i te kot. Te saaita akoe ku tuu i te kot, na tama hakatonutonu raa e me ki ttaohi akoe, tena ku kou ake akoe i na rima na polis raa, tena na polis raa e me ki ppono akoe i te hare karapusi. ");
INSERT INTO nuq_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tena anau e meatu akoe; akoe e me ki noho roo i roto te hare karapusi raa ki tae roo te saaita akoe e pehi te paini akoe raa hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Kootou ni llono na tattara ma, ‘Auu se karemata kailallao.’ ");
INSERT INTO nuq_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Emeia te saaita nei anau e meatu kootou: kame he tanata e kite te hine, tena aia ku manako te hine raa; te tanata naa ku sara i te vahi te hine raa i roto te hatu manava aia. ");
INSERT INTO nuq_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kame te karemata te vahi laaua akoe raa e mee akoe no hai sara, tena kkope te karemata naa i taha no peesia! E tauareka roo te peesia he paa kina te tinotama akoe naa i taha, ka oti te tinotama akoe naa hakaatoa ku lletua i roto te ahi. ");
INSERT INTO nuq_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kame te rima laaua akoe raa e mee akoe no hai sara, tena ttuu te rima naa i taha no peesia! E tauareka te peesia he paa kina te tinotama akoe naa i taha, ka oti te tinotama akoe naa hakaatoa ku lettua i roto te ahi. ");
INSERT INTO nuq_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“E mmau hoki i roto na tuaa ma, ‘Kame he tama e hihai ki peesia te avana aia raa, tena te tama naa ki taataa ake he launiu i te avana aia raa pera ma aia ku peesia te tama raa.’ ");
INSERT INTO nuq_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Emeia te saaita nei anau e meatu kootou: kame he tanata e peesia te avana aia niaina ma te avana aia raa se isi te mee e sara e ppena, te tanata naa e me ki sara kame te hine raa e maanatu ma ki too teeraa tanata hoki, tena te tanata e avana te hine naa e me ki hai sara hoki i te vahi te haere avvana huri. ");
INSERT INTO nuq_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kootou ni llono hoki pera ma na tama i mua raa ni illoa ma, ‘Auu se tiaki na tattara hakamaoni kootou ni hakamoemoe raa, e meia ppena hea kootou ni tattara hakamaoni ake TeAtua ma kootou e me ki ppena raa.’ ");
INSERT INTO nuq_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Emeia te saaita nei anau ku meatu kootou: auu se ttapa na mee ki hakamaoni na tattara kootou raa te saaita kootou e hihhai ki hakamoe he tattara. Auu se ttapa i te vaelani, ia se ttapa hoki te nohorana TeAtua raa; ");
INSERT INTO nuq_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ia se ttapa hoki te maarama nei, maitaname teenei he kina TeAtua e hamaroroo na vae Aia, ia se ttapa hoki Jerusalem, maitaname teenei he matakaina te Tuku hakanaaniu raa. ");
INSERT INTO nuq_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ia auu se ttapa hoki te pohouru akoe ma ki hakamaoni na tattara, maitaname akoe se lavaa te mee he rouru hokotahi ki makkini ia ma ki pallaa. ");
INSERT INTO nuq_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mee koi peeraa, ‘Noo’ seai naa, mee peeraa ‘Seai.’ Ni mee hoki peeraa akoe e ttapa, aanaa ni hakataakoto koi e oo mai te tama sakkino raa. ");
INSERT INTO nuq_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Kootou ni llono na tattara nei i mua, ‘Kame akoe e ttuki te karemata anau, anau e me ki ttuki hoki te karemata akoe, Kame akoe e kkoti te niho anau, anau e me ki kkoti hoki te niho akoe.’ ");
INSERT INTO nuq_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Emeia te saaita nei anau e meatu kootou: auu se taui muri te sara teeraa tama e ppena i akoe. Kame he tama e ppaa te patikauvae te vahi laaua akoe raa, tiaki aia ki paa te patikauvae te vahi se laaua raa hoki. ");
INSERT INTO nuq_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kame he tama e ppono ma koorua ki kot te kaukahu akoe raa, tena tiaki aia ki too hoki te kaukahu mattoru akoe raa. ");
INSERT INTO nuq_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kame he tama e hakamataku atu ma akoe ki amo te kete aia raa ki tae te mael hokotahi, tena amo ki tae e rua na mael. ");
INSERT INTO nuq_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kame he tama e kainno atu akoe ki kou ake he mee, tena kou ake hea te tama naa e hihai raa; kame he tama e hihai ki too he mee ki oti aia ku kou atu muri, tena kou ake hea te tama naa e hihai raa. ");
INSERT INTO nuq_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Kootou ni llono na tattara nei i mua: ‘Laoi koi na tama e taualleka kootou raa, tena ku haeo ma na tama e kiri lloto kootou raa.’ ");
INSERT INTO nuq_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Emeia te saaita nei anau ku meatu kootou: laoi na tama e kiri lloto kootou raa, tena ku lotu ma na tama e mee kootou ki hakalono llihu raa, ");
INSERT INTO nuq_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","tena kootou e me ki mee pera ma ni tamalliki te Tamana taatou i te vaelani raa. Maitaname Aia e hakamaahina ake te maahina Aia raa i aruna na tama haeo raa hakapaa ma na tama taualleka raa hakaatoa, tena ki kou ake te reurehu raa ki lleku i aruna na tama e ppena na mee taualleka ia ma na tama e ppena na mee sakkino raa. ");
INSERT INTO nuq_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kame kootou e laoi koi na tama e laoi kootou raa, kaa TeAtua e me ki kou atu na tuhana kootou raa peehee? Na tama e aoao na takis raa e ppena peenei hoki! ");
INSERT INTO nuq_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tena kame kootou e tattara ake koi na tama e laoi kootou raa, kaa alaa tama e me ki illoa peehee kootou? Na tama e nnoho pouri raa e ppena peenei hoki! ");
INSERT INTO nuq_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kootou ki ttonu tahi e ssau hoki pera ma te Tamana kootou i te vaelani raa e tonu tahi. ");
INSERT INTO nuq_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Lollohi hakamattonu, auu se huri ake na tiputipu kootou i te vahi te lotu raa i mua na karemata na tama hakaatoa ma ki kkite na tama raa hea kootou e ppena raa. Kame kootou e ppena na mee nei i mua na karemata na tama, tena te Tamana kootou i te vaelani raa se lavaa te kou atu ni tuhana ma kootou. ");
INSERT INTO nuq_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Te saaita kootou e hoki ake na mee i na tama e tuttuu haeo raa, tena auu se mee ki kkite na tama hakaatoa pera ma na tama tattara uhiuhi raa e ppena i roto na hare laatou ia ma i aruna na mateara raa. Na tama raa e ppena peenei ma ki hakammaha na tama raa laatou. Anau e meatu kootou te hakamaoni, na tama nei ku oti te too na tuhana haeo laatou raa. ");
INSERT INTO nuq_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Emeia te saaita kootou e me ki tokonaki na tama e tuttuu haeo raa, tena hoki ake ki se illoa na tama ia ma na soa laoi kootou raa. ");
INSERT INTO nuq_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Teenaa he mee koi akoe hokkoe. Tena te Tamana akoe raa, te Tama e kite hea akoe ni ppena tera se hai tama e iroa raa e me ki kou atu te tuhana akoe. ");
INSERT INTO nuq_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Te saaita akoe e lotu, auu se mee pera ma na tama tattara uhiuhi raa! Na tama raa e hihhai ki ttuu i aruna no lotu i roto na hare lotu ia ma i te kina na mateara ma ki kkira ake na tama raa laatou. Anau e meatu te hakamaoni, na tama nei ku oti te too na tuhana haeo laatou raa. ");
INSERT INTO nuq_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Emeia te saaita akoe e lotu, haere i roto te rum akoe raa no ppui te totoka raa, tena akoe ku lotu ake i te Tamana akoe tera taatou se kkite raa. Tena te Tamana akoe raa, te Tama e kite hea akoe e ppena hemuu raa e me ki kou atu te tuhana akoe. ");
INSERT INTO nuq_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Te saaita akoe e lotu, auu se mee tammaki na tattara tera akoe se iroa, e ssau pera ma na tama e nnoho pouri raa e ppena tahi raa, na tama raa e kkahu ma na atua laatou raa e me ki hakallono na lotu laatou raa e mee na lotu raa e lolloa. ");
INSERT INTO nuq_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Auu se mee pera ma na tama raa. Te Tamana akoe raa ko na iroa avare hea akoe e hihai i mua akoe e kainno ake Aia. ");
INSERT INTO nuq_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Teenei kootou e tau te lotu peenei, ‘Tamana maatou i te vaelani: te inoa e tapu Akoe ki hakammaha ria; ");
INSERT INTO nuq_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","tiaki te Hakamaatua ana Akoe raa ki hamai; tiaki maatou ki ppena hea Akoe e hihai maatou ki ppena i te maarama nei ki ssau pera ma i te vaelani. ");
INSERT INTO nuq_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kou mai ni kai ma maatou ki tau ma te aho nei. ");
INSERT INTO nuq_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ssirihia na hai sara maatou ni ppena raa, e ssau pera ma maatou e ssirihia na hai sara na tama e ppena i maatou raa. ");
INSERT INTO nuq_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Auu se tiaki maatou ki ttiri na hahaaite e hainattaa, tena ku rorohi hakaraoi maatou i taha ma na mahi te tama sakkino raa.’ Te Hakamaatua ana, na mahi ia ma na mee taualleka Akoe raa ki mmoe tahi na vahao hakaatoa. Amen ");
INSERT INTO nuq_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kame kootou e ssirihia na hai sara na tama e ppena i kootou raa, tena te Tamana kootou i te vaelani raa e me ki ssirihia na hai sara kootou raa hoki. ");
INSERT INTO nuq_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Emeia kame kootou se ssirihia na hai sara na tama e ppena i kootou raa, tena te Tamana kootou i te vaelani raa e me ki se lavaa hoki te ssirihia na hai sara kootou ni ppena raa. ");
INSERT INTO nuq_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Te saaita kootou e hakamaatapu na kai, auu se kkira hakamatanaennae na karemata kootou raa pera ma na tama tattara uhiuhi raa e ppena tahi. Na tama raa e hihhai ki mee na karemata laatou raa ki kkee ma ki illoa na tama ma laatou e hakamaatapu na kai. Anau e meatu te hakamaoni, na tama nei ku oti te too na tuhana haeo laatou raa. ");
INSERT INTO nuq_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Te saaita kootou e hakamaatapu na kai, oo no koukou, tena ku ssoe na rouru kootou raa, ");
INSERT INTO nuq_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ki se lavaa na tama te illoa ma kootou e hakamattapu na kai, te Tamana koi kootou i te vaelani tera taatou se kkite raa e iroa. Tena te Tamana kootou e kite hea kootou e ppena tera na tama se illoa raa e me ki kou atu na tuhana kootou raa. ");
INSERT INTO nuq_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Auu se hakatau na mee taualleka i te maarama nei raa ma kootou, na mee tera na lollona ia ma te piritia raa e lavaa te kkai no haeo, tena na tama kailallao raa e lavaa te ssaa na hare raa no kailallao. ");
INSERT INTO nuq_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Emeia hakatau na mee taualleka i te vaelani raa ma kootou, na mee tera na lollona ia ma te piritia raa se lavaa te kkai no haeo, tena na tama kailallao raa se lavaa te ssaa no too. ");
INSERT INTO nuq_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Maitaname na hatu manava kootou raa e me ki mmoe koi i te kina na mee taualleka kootou raa e mmoe. ");
INSERT INTO nuq_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Na karemata kootou raa ko na maahina na tinotama kootou. Kame na karemata kootou raa e taualleka, tena na tinotama kootou raa e maarama roo hakaatoa; ");
INSERT INTO nuq_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","e meia kame na karemata kootou raa ku haeo, tena kootou e ssau pera ma ni tama e nnoho i roto te pouri. ");
INSERT INTO nuq_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Akoe se lavaa te hehekau ma tokorua na tama hakamattua, akoe e me ki kiri lloto teeraa tama, tena ku laoi teeraa tama; akoe e me ki hakarono teeraa tama, tena e me ki se hakarono teeraa tama. Kootou se lavaa te hehekau ma TeAtua, tena ma ku mannako hoki na sileni. ");
INSERT INTO nuq_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Tera hea anau e meatu kootou: auu se hakatettere mmaha i te vahi na kai ia ma hea kootou e me ki unu ki ora kootou raa, ia hoki ma na hekau kootou e me ki leulleu raa. Aiea te ora raa se hakamaatua i aruna na kai? Tena kaa te tinotama raa se hakamaatua i aruna na hekau? ");
INSERT INTO nuq_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kira ake na manu lellee raa, na manu raa se ttori na kai, ia se haki na hua raa no hakatau i roto na hare; e meia te Tamana kootou i te vaelani raa e rorohi na manu raa! Tena kaa kootou se hakamattua i aruna na manu raa? ");
INSERT INTO nuq_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kame he tama e manako te ora aia; eaa te tama naa e lavaa te hakanuu te ora aia raa ki roroa hakamarie? ");
INSERT INTO nuq_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Kaa kootou e mamannatu tammaki i na hekau raa ki aa? Kira ake na kaute e hhomo raa: na kaute raa se ppena na hekau. ");
INSERT INTO nuq_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Emeia Anau e meatu kootou pera ma te Tuku Solomon raa ma na mee taualleka ia ma na hekau aia raa hakaatoa se hai lakkei taualleka roo pera ma na kaute nei. ");
INSERT INTO nuq_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Teenaa ko TeAtua e hakalaakei na veve e hhomo huri raa, na veve e hhomo te aho nei taiao ku seai raa koi, ku vvela i roto te ahi. Aiea TeAtua se lavaa te kou atu ni hekau ma kootou? Na hakattina kootou naa e pammee roo! ");
INSERT INTO nuq_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Auu se mamannatu tammaki ma, ‘Anau e me ki too na kai, na vai ia ma na hekau anau raa i hee?’ ");
INSERT INTO nuq_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","(Aanei na mee na tama e nnoho pouri raa kame e mamannatu tammaki.) Te Tamana kootou i te vaelani raa e iroa pera ma kootou e hihhai na mee nei. ");
INSERT INTO nuq_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Emeia kootou ki kaamata no mamannatu hai mmahi i te Hakamaatua ana i te Vaelani raa ia ma hea TeAtua e hihai kootou ki ppena raa, tena Aia e me ki kou atu na mee nei hakaatoa ma kootou. ");
INSERT INTO nuq_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ia tena auu se mamannatu tammaki te aho taiao raa; te aho naa e isi na liuna aia hokoia. Na hakalono llihu te aho nei e tau koi ma te aho nei, auu se hakapiri ake alaa hakalono llihu i aruna ma ni hakalono llihu peehee te aho naa e isi raa.” ");
INSERT INTO nuq_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Auu se haru te haeo alaa tama ki se lavaa TeAtua te hakatonutonu kootou, ");
INSERT INTO nuq_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","e mee TeAtua e me ki hakatonutonu kootou peenaa hoki tautari te haru haeo kootou alaa tama raa. Aia e me ki hakatonutonu kootou tautari na tiputipu kootou ni haru na haeo alaa tama raa. ");
INSERT INTO nuq_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Aiea akoe e kkira ake te kerekere e mmau te karemata te taina akoe raa, kaa akoe se anana peehee te laakau e mmau te karemata akoe raa? ");
INSERT INTO nuq_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kaa akoe e lavaa peehee te meake te taina akoe raa ma, ‘Huri mai ki ppisi te kerekere e mmau te karemata akoe raa,’ te saaita te laakau e rahi raa e mmau i te karemata akoe raa? ");
INSERT INTO nuq_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kootou ni tama tattara uhiuhi! Tokea te laakau e mmau te karemata akoe raa i taha i mua, tena akoe e me ki kite hakaraoi no ppisi te kerekere e mmau te karemata te taina akoe raa. ");
INSERT INTO nuq_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Auu se kou ake na mee e ttapu raa i na poi, e mee na poi raa e me ki huri atu no uti kootou. Auu se tuku na pure kivakiva kootou raa i mua na piki, e mee na piki raa e me ki lakalaka na pure raa. ");
INSERT INTO nuq_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kainno, tena akoe e me ki too hea akoe e hihai raa; Sesee, tena akoe e me ki lave hea akoe e sesee raa; papaku te totoka, tena te totoka raa e me ki taaraki atu akoe. ");
INSERT INTO nuq_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Maitaname na tama hakaatoa e kainno raa e me ki too hea laatou e kainno ake raa, tena na tama hakaatoa e sesee raa e me ki lave hea laatou e sesee raa, tena te totoka raa e me ki taaraki atu i na tama e papaku te totoka raa. ");
INSERT INTO nuq_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kame he tamariki e kainno ake te tamana aia raa ki kou ake he haraoa, eaa te tamana aia raa e me ki kou ake he hatu? ");
INSERT INTO nuq_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kaa seai, akoe e me ki kou ake he lapono kame te tamariki raa e kainno atu ma ki kou ake he ika? ");
INSERT INTO nuq_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Niaina ma kootou ni tama sakkino, e meia kootou e illoa te kou ake na tamalliki kootou raa na mee taualleka. Kaa e hia hoki te Tamana taatou i te vaelani raa e me ki kou ake na mee taualleka i na tama e kainno ake Aia raa? ");
INSERT INTO nuq_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Tokonaki alaa tama, e ssau pera ma kootou e hihhai na tama raa ki tokonaki kootou. Teenei te hakataakoto hakanaaniu i na tuaa Moses ia ma na akoako na profet TeAtua raa. ");
INSERT INTO nuq_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Uru i roto te totoka e kkao raa, e mee te totoka e haere i te kina te ahi raa e llaha, ia e hainauhie roo te tauttari, ia tena e tammaki roo na tama e me ki tauttari te mateara naa. ");
INSERT INTO nuq_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Emeia te totoka e haere i te kina te ora raa e kkao roo, tena te mateara raa e hainattaa roo te tauttari, ia hoki na tama e tauttari te mateara raa e moisi. ");
INSERT INTO nuq_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Hakamattonu i te vahi na profet malliu raa; na tama naa e ssau pera ma ni sipsip e ttara, e meia na tama naa e ssau roo pera ma ni manu kai ttama i roto laatou. ");
INSERT INTO nuq_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kootou e me ki illoa na tama nei i na mee laatou e ppena raa. Na mataiona se lavaa te hhua na hua na pukunahu, na natu se lavaa te hhua na hua na purukavuhu. ");
INSERT INTO nuq_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Te laakau e homo tauareka raa e me ki hhua na hua taualleka, e meia te laakau e homohomo haeo raa e me ki hhua na hua haeo. ");
INSERT INTO nuq_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Te laakau e homo tauareka se lavaa te hua na hua haeo, tena te laakau e homohomo haeo se lavaa te hua na hua taualleka. ");
INSERT INTO nuq_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tena na laakau se hhua na hua raa e me ki tuutia ria ki hhina, tena ku lletu i roto te ahi. ");
INSERT INTO nuq_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ia tena kootou e me ki illoa na profet malliu raa i na mee laatou e ppena raa. ");
INSERT INTO nuq_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Se mee ma na tama hakaatoa e kanna mai Anau ma, ‘TeAriki, TeAriki raa’ e me ki uru i roto te Hakamaatua ana i te Vaelani raa, e meia na tama koi e ppena hea te Tamana i te vaelani raa e hihai laatou ki ppena raa e me ki ttae i te kina raa. ");
INSERT INTO nuq_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Te saaita te Aho te Hakatonutonu raa e tae mai, tammaki na tama e me ki mee mai Anau ma, ‘TeAriki, TeAriki! Maatou ni hakatae na tattara TeAtua raa i te inoa Akoe, tena maatou ni hakaise tammaki na tipua i te inoa Akoe, tena ki ppena hoki tammaki na mirakol!’ ");
INSERT INTO nuq_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tena Anau e me ki meake na tama naa ma, ‘Anau ni se iroa roo kootou. Oo i taha ma Anau, kootou ni tama haeo!’ ");
INSERT INTO nuq_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Tena na tama e llono na tattara Anau nei no tauttari raa e ssau pera ma te tama e atamai tera e hakatuu te hare aia raa i aruna na hatu. ");
INSERT INTO nuq_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Te reurehu raa ku lleku no ttahe na riva raa, tena te matani raa hoki ku maairi hai mahi roo no ppaku te hare raa. Emeia te hare raa se hina, e mee te hare raa e pena i aruna na hatu. ");
INSERT INTO nuq_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Emeia na tama e llono na tattara Anau nei, tena ki se tauttari na tattara raa e ssau pera ma te tama e panimu e hakatuu te hare aia raa i aruna te kerekere koi. ");
INSERT INTO nuq_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Te reurehu raa ku lleku no ttahe na riva raa, tena te matani raa ku maairi hai mahi roo no ppaku te hare, tena te hare raa ku hina no paku i raro. Te hare raa e hina no ppaku i raro hakamaroa roo.” ");
INSERT INTO nuq_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Te saaita Jisas ni tattara no oti te kanohenua raa ku mahharo roo i na akoako Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jisas se akoako pera ma na tama e poroporo na tuaa raa; e meia Aia e akoako roo ma na mahi Aia. ");
INSERT INTO nuq_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas ku haere iho i raro ma te mouna raa, tena na kanohenua e tammaki raa ku tauttari Aia. ");
INSERT INTO nuq_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tena he tama e kaina te manumanu haeo i te tinotama aia ku haere ake iaa Jisas no tuturi i mua Tama raa, tena ki meake, “TeAriki, kame Akoe e hihai, Akoe ku tokonaki anau ki tauareka.” ");
INSERT INTO nuq_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kito Jisas ki kapake no ttaohi te tama raa, tena ki meake, “Anau e hihai ki tokonaki akoe! Akoe ku tauareka!” Te saaita naa koi te maahana raa ku hopo i taha ma te tama raa. ");
INSERT INTO nuq_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tena Jisas ki tattara ake te tama raa, “Hakarono! Auu se tattara ake na tama, e meia haere tahi roo i te maatua i te hare lotu raa ki mmata te tama raa te tinotama akoe, tena akoe ku kou ake na hoki Moses ni tattara mai raa ki huri ake ki kkite na tama hakaatoa pera ma akoe ku tauareka hakamaoni.” ");
INSERT INTO nuq_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","He soldia hakamaatua na soldia i Rom raa ku ttiri Jisas te saaita Jisas ni tae i Kaperneam, tena te soldia raa ki kainno ake Jisas ma ki tokonaki aia. ");
INSERT INTO nuq_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“TeAriki, te purepure anau raa e moe i hare e laavea roo, tena aia se lavaa te hurihuri, ia e hakalono llihu haeo roo.” ");
INSERT INTO nuq_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tena Jisas ki meake, “Anau e me ki haere atu no tokonaki te tama naa ki tauareka.” ");
INSERT INTO nuq_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kito te soldia hakamaatua raa ki meake, “TeAriki, seai! Anau e maanatu ma Akoe se tau te uru i roto te hare anau raa. Akoe ki ppehi koi he tattara ki tauareka te purepure anau raa. ");
INSERT INTO nuq_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Anau he tama hoki e noho i raro na mahi na soldia hakamattua, tena e isi na soldia e nnoho i raro na mahi anau. Kame anau e meake te tama nei, ‘Haere!’ te tama naa e me ki haere; kame anau e meake te tama nei, ‘Hamai!’ te tama naa e me ki hamai; kame anau e meake te purepure anau raa, ‘Ppena te mee nei!’, te tama naa e me ki ppena koi.” ");
INSERT INTO nuq_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisas e oho roo te saaita Aia ni rono na tattara te soldia raa, tena Aia ki tattara ake te kanohenua e tauttari Aia raa ma, “Anau e meatu kootou, Anau se hai tama roo e kite i roto Israel tera e isi te hakatina peenei ma te tama nei. ");
INSERT INTO nuq_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Anau e meatu te hakamaoni pera ma tammaki na tama e me ki oo mai i te anake ia ma te laki no nnoho ma Abraham, Aisak ia ma Jekop te saaita te kai te Hakamaatua ana i te Vaelani raa. ");
INSERT INTO nuq_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Emeia na tama e tau roo te nnoho i roto te Hakamaatua ana i te Vaelani raa e me ki lettua i aho i te kina e pouri raa. Te kina na tama raa e me ki ttani no hakati kkati na niho laatou raa.” ");
INSERT INTO nuq_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tena Jisas ki meake te soldia raa, “Vaakai i hare, tena akoe e me ki kite hea akoe e hakatina raa.” Te saaita naa koi te purepure te soldia hakamaatua raa ku tauareka. ");
INSERT INTO nuq_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisas e haere i te hare Pita raa no kite te hinaona hine Pita raa e moe, e lavea te vvela. ");
INSERT INTO nuq_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Aia e ttaohi te rima te hine raa, tena te vvela raa ku hopo, tena te hine raa ku mahike i aruna no kou ake na kai na tama raa no kkai. ");
INSERT INTO nuq_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Te saaita te mee raa ku hiahi, na tama raa ku kou ake tammaki na tama e ttau ria na tipua raa iaa Jisas. Jisas e hakaise na tipua sakkino raa ma te tattara koi hokotahi, tena ki tokonaki hoki na tama lavvea raa no taualleka. ");
INSERT INTO nuq_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Aia e ppena na mee nei ki mee ki hakamaoni na tattara profet Aisaia ni tattara mai i mua ma, “Tama raa Hokoia e ui na maahana taatou raa, tena ki ssau na maahana taatou raa i taha.” ");
INSERT INTO nuq_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisas e kite te kanohenua e ttuu alleha Aia raa, tena Aia ki meake na disaipol Aia raa ki oo i teeraa vahi te namo raa. ");
INSERT INTO nuq_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tena he tama e poroporo na tuaa ku haere ake no meake Jisas ma, “Rabai, anau e tanattana ki hahaere ma Akoe he kina peehee Akoe e haere.” ");
INSERT INTO nuq_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Kito Jisas ki meake te tama raa, “Alaa manu hahaere e moemmoe na rua, tena na manu lellee raa e tokottoko i na hohana, e meia te Tamariki te Tama nei se isi te kina e me ki moe no hamaroroo.” ");
INSERT INTO nuq_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tena teeraa tama, he disaipol ki meake, “TeAriki, hakattari ki haere anau no tanu te tamana anau raa i mua.” ");
INSERT INTO nuq_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kito Jisas ki meake, “Tautari mai Anau, tena ku tiaki na tama ku mmate raa ki tanu na tama e mmate laatou raa.” ");
INSERT INTO nuq_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisas e kake i roto te manaui raa, tena na disaipol Aia raa ki kkake hoki i roto te manaui raa no huro laatou. ");
INSERT INTO nuq_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Te saaita naa koi, te matani hai mahi roo ku ttiri laatou i roto te namo, tena te manaui raa ku taapiri koi ki apuru. Emeia Jisas e moe heiroa roo. ");
INSERT INTO nuq_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Na disaipol raa ku oo atu no hhano Jisas no maahuru, tena ki meake ma, “TeAriki, tokonaki maatou! Taatou kaa mmate!” ");
INSERT INTO nuq_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kito Jisas ki meake, “Aiea kootou e mattaku naea? Kootou se isi na hakattina?” Tena Jisas ki tuu i aruna no meake te matani ia ma na peau raa ki hakamau, tena te mee raa ku tteiho no marino kkii roo. ");
INSERT INTO nuq_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Na disaipol raa hakaatoa ku mahharo, tena ki tattara ma, “Teenei he Tama peehee? Te matani ia ma na peau raa hoki e hakallono te Tama nei.” ");
INSERT INTO nuq_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisas ku tae i te matakaina Gadara i teeraa vahi te namo raa, tena Aia ku ttiri tokorua na tama e oo mai i taha ma te kava te kina raa. Tokorua na taanata nei e isi na tipua sakkino roo e ttau i roto laaua, tena na tama te matakaina raa e mattaku te hahaere te mateara raa. ");
INSERT INTO nuq_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tokorua raa ku hakateki no vaa hakamaroa roo ma, “Akoe he Tamariki TeAtua, hea Akoe e hihai ki ppena i maatou? Akoe e hamai ma ki kou mai na hakalono llihu maatou i mua te saaita te hakatonutonu raa e tae mai?” ");
INSERT INTO nuq_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","E isi na piki tammaki roo e kaikkai se mmao hoki. ");
INSERT INTO nuq_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kito na tipua raa ki kainno ake Jisas ma, “Kame Akoe e me ki hakaise maatou i taha, tena Akoe ku kkave maatou ki ttau i roto na piki raa.” ");
INSERT INTO nuq_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tena Jisas ki meake na tipua raa, “Huro”, kito na tipua raa ki huro no ttau i roto na piki raa. Na piki raa hakaatoa ku huro no maoha i te vahi te mouna e motu hua raa no maoha i roto te lottai no mallemo. ");
INSERT INTO nuq_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tena na tama e lollohi na piki raa ku mattaku no huro i taha, tena ki huro i te matakaina raa no tattara ake na mee roo hakaatoa tera ni kapihi ake i te tokorua na tama ni ttau ria na tipua raa. ");
INSERT INTO nuq_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kito na tama hakaatoa i te matakaina raa ki oo ake no mmata Jisas; te saaita laatou ni kkite Tama raa, na tama raa ku meake ma Jisas ki tiaki te matakaina laatou raa, tena ku haere i taha. ");
INSERT INTO nuq_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas ku kake i aruna te manaui raa no tere vaa roto te namo raa no vaakai i te matakaina Aia raa, ");
INSERT INTO nuq_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","tena na tama i te kina raa ku ssau ake te tama na vae e mmate e moe i aruna te kakkake. Jisas e kite ma na tama raa e hakattina roo, tena Aia ki meake te tama na vae e mmate raa ma, “Taku tama, auu se mataku! Na hai sara akoe raa ku oti te ssirihia.” ");
INSERT INTO nuq_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tena na tama e poroporo na tuaa raa ku tattara hokolaatou ma, “Te Tama nei e tattara roo pera ma Aia ko TeAtua hoki!” ");
INSERT INTO nuq_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisas e iroa na mannatu na tama raa, tena Aia ki meake, “Aiea kootou e isi na mannatu sakkino naea? ");
INSERT INTO nuq_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Aiea te tattara hee e hainauhie, te tattara ma, ‘Na hai sara akoe raa ku oti te ssirihia,’ ma te tattara ma, ‘Tuu i aruna no haere?’ ");
INSERT INTO nuq_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Anau e me ki huri atu te hakamaoni ki kkite kootou pera ma te Tamariki te Tama nei e isi na mahi i roto te maarama nei ki ssirihia na hai sara.” Kito Jisas ki meake te tama na vae e mmate raa, “Tuu i aruna no too te moena akoe naa no haere i hare!” ");
INSERT INTO nuq_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tena te tama raa ku mahike no tuu i aruna no haere i hare. ");
INSERT INTO nuq_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Te saaita te kanohenua raa ni kkite te mee raa, na tama raa ku mattaku no hakammaha ake TeAtua, e mee Aia e kou ake na mahi hai mmahi i na tama. ");
INSERT INTO nuq_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas ku haere i taha ma te matakaina raa, ia te saaita Aia ni haere raa, Aia ku kite te tama e aoao na takis e noho i te kina aia e hehekau raa, te inoa aia raa ko Matiu. Tena Jisas ki meake te tama raa, “Tautari mai Anau.” Kito Matiu ki mahike i aruna no tautari Jisas. ");
INSERT INTO nuq_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Te saaita Jisas ni noho no kai i te hare Matiu raa, tammaki na tama aoao na takis ia ma na tama hai ssara e oo ake hoki no kkai laatou ma Jisas ia ma na disaipol Aia raa. ");
INSERT INTO nuq_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","E isi na Farisi e kkite, tena laatou ki vahiri ake na disaipol Jisas raa ma, “Aiea te Rabai kootou raa e kkai ma na tama aoao na takis ia ma na tama hai ssara raea?” ");
INSERT INTO nuq_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisas e rono na tattara na tama raa, tena Aia ki meake, “Na tama se lavvea raa se lavaa te oo no mata te dokta, e meia na tama koi e lavvea raa e me ki oo no mata na dokta. ");
INSERT INTO nuq_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Oo, tena kootou ku sesee te hakataakoto e moe i roto te Launiu Tapu ma, ‘Anau e hihai koi te laoi, seai ma na hoki na manu raa.’ Anau se hamai no kanna na tama ma laatou e ttonu raa, e meia Anau e hamai no kanna na tama e hai ssara raa.” ");
INSERT INTO nuq_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tena na disaipol Jon Baptis raa ku oo ake no vahiri ake Jisas ma, “Aiea maatou ma na Farisi raa e hakamattapu na vahao hakaatoa roo, e meia na disaipol Akoe raa se hai vahao roo e hakamaatapu raea?” ");
INSERT INTO nuq_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Kito Jisas ki meake, “Kootou e mannatu ma na tama e hakkorohia ki oo ake i te kai te avana raa e me ki nnoho no alloha te saaita te tanata raa koi noho i te kina raa? Seai! Emeia e isi te aho e me ki hamai te saaita te tanata raa e me ki too ria no kkave i taha ma na tama raa, tena ki oti na tama naa e me ki hakamaatapu. ");
INSERT INTO nuq_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Se hai tama e ttui te muri maro vahao nei i aruna te paamaro tuai, maitaname te muri maro vahao nei raa e me ki mahatuhatu no masae, tena te rua raa e me ki rahi roo. ");
INSERT INTO nuq_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tena se hai tama e me ki utu na wain vahao nei raa i roto te kiri na manu e utuutu na wain tera ku tuai raa, maitaname te kiri na manu e utuutu na wain ku tuai raa e me ki kkuha no mahaa, tena na wain raa ku mannini puamu, tena te kiri na manu e utuutu na wain ku tuai raa e me ki haeo hoki. Emeia na wain vahao nei raa e tau te utu i roto te kiri na manu e utuutu na wain vahao nei, tena na mee e rua raa e me ki mmoe taualleka.” ");
INSERT INTO nuq_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas koi tattara ake koi na tattara nei, tena he tama hakamaatua na Jiu raa ku haere ake no tuturi i mua Tama raa, tena ki meake, “Taku tamariki hine raa e mate vahao nei koi, e meia hamai no hakapiri na rima Akoe raa i aruna te tamariki raa ki ora.” ");
INSERT INTO nuq_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kito Jisas ki mahike i aruna no tautari te tama raa, tena na disaipol Jisas raa ku tauttari atu hoki vaa muri. ");
INSERT INTO nuq_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tena he hine e hakalono llihu haeo roo i roto sanahuru ma rua na hetau e mee te toto aia raa e tettere koi peenaa ku haere ake vaa muri no ttaohi na kaunutu na hekau Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Te hine raa e tattara hokoia ma, “Anau e me ki tauareka kame anau e ttaohi koi na hekau te Tama nei.” ");
INSERT INTO nuq_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jisas e hakatike no kite te hine raa, tena ki meake, “Taku tama, auu se mataku! Te hakatina akoe raa e mee akoe no tauareka.” Te saaita naa koi te hine raa ku tauareka. ");
INSERT INTO nuq_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tena Jisas ki haere i te hare te tama hakamaatua raa. Jisas e kite na tama e huhua na huatana ia ma na tama e tanittani, ");
INSERT INTO nuq_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","tena Aia ki meake na tama raa ma, “Kootou hakaatoa ki oo i aho! Te tamariki hine naa se mate, te tama naa e moe koi!” Kito na tama raa ki kaamata no tataussua Jisas. ");
INSERT INTO nuq_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Emeia te saaita na tama raa hakaatoa roo ku ttae i aho, Jisas ku haere i te rum te tamariki hine raa, tena Aia ki ttaohi te rima te tamariki raa, tena te tamariki hine raa ku mahike i aruna. ");
INSERT INTO nuq_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tena te rono raa ku paa na kina roo hakaatoa i te henua raa. ");
INSERT INTO nuq_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas ku tiaki te kina raa no haere, tena tokorua na taanata karemata sseni ku tauttari Aia. Tokorua e kakanna ake ma, “Tamariki Devit, hai aroha mai maaua!” ");
INSERT INTO nuq_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Te saaita Jisas ni haere no uru i hare, tokorua na taanata karemata sseni raa ku oo ake iaa Jisas, tena Aia ki vahiri ake tokorua raa, “Koorua e hakattina pera ma Anau e lavaa te tokonaki koorua?” Kito tokorua raa ki meake, “Noo, TeAriki!” ");
INSERT INTO nuq_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tena Jisas ki ttaohi na karemata tokorua raa, tena ki meake, “Hea koorua e hakattina raa e me ki kapihi atu!” ");
INSERT INTO nuq_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tokorua raa ku mee no kkite, tena Jisas ki tattara hakamataku ake tokorua raa ma, “Auu se tattara ake hoki ni tama!” ");
INSERT INTO nuq_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Emeia tokorua raa e oo koi no paa te rono Jisas raa i na kina roo hakaatoa i te henua raa. ");
INSERT INTO nuq_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tokorua na taanata raa ku oo, tena e isi na tama e kou ake te tama se lavaa te tattara, maitaname aia e isi te tipua e tau i roto aia. ");
INSERT INTO nuq_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Emeia te saaita te tipua raa ni hakaise ria no tere i taha, te tama raa ku kaamata no tattara, tena na tama raa hakaatoa ku mahharo. Tena na tama raa ki tattara ma, “Maatou ni se hai mee roo peenei ni kkite i roto Israel.” ");
INSERT INTO nuq_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Emeia na Farisi raa e tattara ma, “Teenaa ko te tipua hakamaatua raa e kou ake na mahi Jisas ki hakaise na tipua raa i taha.” ");
INSERT INTO nuq_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisas e haere hakatike na matakaina e llahi ia ma na matakaina pammee raa. Aia e akoako i roto na hare lotu na Jiu raa, tena ki takutaku ake te Rono Tauareka i te vahi te Hakamaatua ana i te Vaelani raa, tena ki tokonaki na tama hakaatoa e lavvea na maahana raa no taualleka. ");
INSERT INTO nuq_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Te saaita Aia ni kite te kanohenua raa, Aia ku aroha roo i na tama raa, maitaname na tama raa e tammaki te mannatu, ia e hahaere vvare koi, e ssau pera ma na sipsip se hai tama e rorohi. ");
INSERT INTO nuq_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kito Jisas ki meake na disaipol Aia raa, “Na hua e me ki haki raa e tammaki roo, e meia na tama e me ki haki na hua raa e moisi. ");
INSERT INTO nuq_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Lotu ake te Tama hakamaatua te huata raa ki kauna tammaki na tama ki oo no haki na hua raa.” ");
INSERT INTO nuq_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas e kanna ake sanahuru ma rua na aposol Aia raa ki hakkutu ake, tena Aia ki kou ake na mahi na tama raa ki tokonaki na tama e lavvea na maahana roo hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aanei na inoa na aposol sanahuru ma rua nei: tama kaamata Saimon, (e hui hoki ma ko Pita raa), tena Andru te taina aia raa; Jems ia ma te taina aia raa Jon, na tama Sebedi raa; ");
INSERT INTO nuq_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, tena Bartolomyu; Tomas, tena Matiu, te tama e aoao na takis raa; Jems te tamariki Alfius raa, tena Tadius; ");
INSERT INTO nuq_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","tena Saimon, te tama i roto te kuturana na tama se hihai ma Rom ki rorohi Israel raa, tena Judas Iskariot, te tama e me ki hakari ake Jisas i na tama hakamattua raa. ");
INSERT INTO nuq_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas e kauna ria te sanahuru ma rua na aposol raa ma na tattara nei: “Auu se oo i na henua na tama seai ma ni Jiu raa, ia se oo hoki i na matakaina i roto Samaria raa. ");
INSERT INTO nuq_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Emeia oo i na kanohenua Israel tera ku llano pera ma ni sipsip raa. ");
INSERT INTO nuq_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Oo no takutaku atu pera ma, ‘Te Hakamaatua ana i te Vaelani raa ku taapiri mai!’ ");
INSERT INTO nuq_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tokonaki na tama lavvea raa, tena ku hakaora na tama ku mmate raa, tena ku tokonaki na tama e kaina te manumanu haeo raa ki taualleka, tena ku hakaise na tipua sakkino raa i taha. Kootou ku oti te too marino na mee, tena auu se mannatu ma ki too ni sui. ");
INSERT INTO nuq_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Auu se too ni gol, siliva, ia ni sileni no ppono i roto na muri kopu kootou raa. ");
INSERT INTO nuq_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Auu se hahaere ma na muri kopu na tama e kainonno raa te saaita kootou e oo, ia se too hoki teeraa kaukahu, na taka ia ma he laakau hahaere, maitaname na tama e tau te kou ake ni aa na tama hehekau raa e hihhai. ");
INSERT INTO nuq_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Te saaita kootou e ttae he matakaina, tena oo i roto te matakaina naa no sesee he tama tera e hihai ki too kootou, tena kootou ku nnoho ma te tama naa ki tae roo te saaita kootou ku tiaki te matakaina naa. ");
INSERT INTO nuq_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Te saaita kootou e oo i roto he hare, kootou ku meake ma, ‘Te tauareka ki nnoho ma kootou.’ ");
INSERT INTO nuq_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kame na tama te hare naa e too hakaraoi kootou, tena tiaki te tauareka kootou raa ki nnoho ma na tama naa; e meia kame na tama te hare naa e haeo kootou, tena kootou ku too muri te tauareka kootou raa. ");
INSERT INTO nuq_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tena kame he hare, ia he matakaina se hihhai ki too, ia ki hakallono kootou, tena tiaki te matakaina naa, tena ku ttahi na kkere e mmau na tapuvae kootou raa i taha. ");
INSERT INTO nuq_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Anau e meatu te hakamaoni pera ma i te Aho Hakatonutonu raa, TeAtua e me ki huri ake te aroha e rahi roo i na tama i Sodom laaua ma Gomora raa, ia seai ma na tama te matakaina naa! ");
INSERT INTO nuq_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Hakallono! Anau e kauna kootou pera ma ni sipsip ki oo i na manu kai ttama raa. Kootou ki hakamattonu pera ma na lapono, ia laumarie pera ma na rupe. ");
INSERT INTO nuq_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Lollohi hakamattonu maitaname e isi na tama e me ki hakapiki kootou, tena ku too kootou no kkave i te kot, tena na tama naa e me ki riki kootou vaa roto na hare lotu na Jiu raa. ");
INSERT INTO nuq_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kootou e me ki ttuu i mua na tama hakamattua ia ma na tuku ki hakatonutonu ria e mee kootou e tauttari Anau, tena te saaita naa kootou ku takutaku atu te Rono Tauareka raa i na tama naa ia ma na tama seai ma ni Jiu raa. ");
INSERT INTO nuq_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Te saaita na tama e ppono kootou i te kot, tena auu se mattaku ma niaa kootou e me ki tattara ia ma kootou e me ki tattara peehee; e mee te saaita kootou ku tuu i te kot raa, kootou e me ki illoa roo te tattara na tattara hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Maitaname na tattara kootou e me ki tattara raa seai ma ni tattara kootou; aanaa ni tattara TeAnana Tapu te Tamana kootou raa e kou atu kootou ki tattara. ");
INSERT INTO nuq_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“E isi na tama e me ki kou ake na taina laatou raa ki taaia ria ki mmate, tena na tamana na tamalliki raa e me ki mee pera hoki i na tamalliki laatou raa, tena na tamalliki raa e me ki huri sara ake na maatua laatou raa no kou ake ki taaia ria ki mmate. ");
INSERT INTO nuq_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Na tama hakaatoa e me ki haeo ma kootou e mee kootou e tauttari Anau. Emeia na tama e ttuu mmau no ttae te hakaoti raa e me ki ora. ");
INSERT INTO nuq_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kame he matakaina e kou atu na hakalono llihu i kootou, tena huro i teeraa matakaina. Anau e meatu te hakamaoni pera ma kootou se lavaa te hakaotioti na hehekau kootou i roto na matakaina Israel raa hakaatoa i mua te Tamariki te Tama nei e hamai. ");
INSERT INTO nuq_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Se isi te tamariki skul e raka i aruna te tisa aia, ia se isi te tama hehekau e hakanaaniu i aruna te tama hakamaatua aia raa. ");
INSERT INTO nuq_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Emeia te tamariki skul raa e lavaa te ttae te kooina te tisa aia raa, tena te tama hehekau raa e lavaa hoki. Kame Belsebul e hakamaatua i roto he hareakina, tena na tama i roto te hareakina naa e me ki hui na inoa e sakkino roo! ");
INSERT INTO nuq_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ia tena auu se mattaku na tama. Na mee e huuna ria raa e me ki laavea ria, tena na tama e me ki illoa na mee hakaatoa na tama e hai amuni raa. ");
INSERT INTO nuq_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Na mee Anau e tattara hemuu atu i kootou raa, kootou ku tattara ake ki illoa na tama hakaatoa, tena na mee Anau e tattara hemuu atu i roto na hare kootou raa, kootou ki ttuu i aruna na tauhuhu na hare raa no tattara ake na tama. ");
INSERT INTO nuq_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Auu se mattaku na tama tera e lavaa te taa koi te tinotama raa, tena ku se lavaa hoki te taa na anana kootou raa; e meia kootou ki mattaku TeAtua, te Tama e lavaa te taa no ppehi na tinotama ia ma na anana kootou raa i te kina te ahi raa. ");
INSERT INTO nuq_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kootou e illoa ma te sileni hokotahi e lavaa te sui e rua na rupe? Te Tamana kootou raa e rorohi hakaraoi roo na manu raa, tena kame TeAtua e hihai, tena se lavaa he rupe e me ki mate. ");
INSERT INTO nuq_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Tena i te vahi kootou, na rouru kootou raa hakaatoa ku oti te ppau ria. ");
INSERT INTO nuq_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ia tena auu se mattaku, TeAtua e maanatu mahi roo i kootou, e raka i aruna ma na rupe raa. ");
INSERT INTO nuq_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Na tama e tattara i mua na karemata na tama hakaatoa ma laatou ni tama Anau raa; Anau e me ki ppena peeraa hoki i na tama naa i mua na karemata te Tamana Anau i te vaelani raa. ");
INSERT INTO nuq_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Emeia na tama e tattara i mua na tama ma laatou se hihhai Anau raa; Anau e me ki ppena peeraa hoki i mua te Tamana Anau i te vaelani raa. ");
INSERT INTO nuq_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Auu se mannatu ma Anau e hamai ma ki kou atu te noho laoi. Seai, Anau se hamai ma ki kou atu te noho laoi, e meia Anau e hamai ki vaevae kootou ma te paraamoa. ");
INSERT INTO nuq_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Anau e hamai ki mee na tamalliki taanata raa ki nonnoho haeo ma na tamana laatou raa, tena na tamalliki hine raa ki nonnoho haeo ma na tinna laatou raa, tena na tama hhine raa ku nonnoho haeo ma na hinaona hhine laatou raa; ");
INSERT INTO nuq_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Na tama roo e me ki kiri lloto kootou raa ko na tama koi i roto te manava kootou raa. ");
INSERT INTO nuq_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Na tama e laoi mahi roo na maatua laatou e raka ma te laoi laatou i Anau raa se tau te mee pera ma ni disaipol Anau, tena na tama e laoi na tamalliki laatou e raka ma te laoi laatou i Anau raa se tau te mee pera ma ni disaipol Anau. ");
INSERT INTO nuq_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Na tama se hakapiri na kros laatou raa no tauttari mai na tapuvae Anau raa se tau te mee pera ma ni disaipol Anau. ");
INSERT INTO nuq_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Na tama e mannako na ora laatou raa se lavaa te too te ora hakamaoni, e meia na tama se mannako na ora laatou no tauttari Anau raa e me ki too te ora hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Te tama e too hakaraoi kootou raa e too hakaraoi hoki Anau, tena te tama e too hakaraoi Anau raa e too hakaraoi hoki te Tama ni kauna ria mai Anau raa. ");
INSERT INTO nuq_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Te tama e too hakaraoi na profet TeAtua raa e me ki too hoki na tuhana na profet raa, e mee aia e iroa ma na tama raa ni profet TeAtua. Tena te tama e too hakaraoi te tama tauareka raa e me ki too te tuhana na tama taualleka raa e me ki too raa, e mee aia e iroa ma teeraa he tama tauareka, tena ki too hakaraoi tama raa. ");
INSERT INTO nuq_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kootou ki illoa pera ma te tama e kou ake te vai ki unu he tama na tama e tauttari Anau raa e me ki too he tuhana, e mee aia e iroa ma te tama raa he tama e tautari Anau, tena aia ki kou ake te vai ki unu tama raa.” ");
INSERT INTO nuq_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Te saaita Jisas ni tattara ake na disaipol Aia raa no oti, Aia ku tiaki te kina raa ma ki haere no akoako, tena ki takutaku i roto na matakaina tappiri ake i te kina raa. ");
INSERT INTO nuq_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jon e noho i roto te hare karapusi raa te saaita naa no rono na mee Krais ni ppena raa, tena aia ki kauna na disaipol aia raa ki oo no vahiri ake Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Tena na tama raa ki oo no vahiri ake ma, “Mee mai ki illoa maatou, Akoe ko te tama Jon e tattara ma e me ki hamai raa, ma maatou e me ki hakattari teeraa tama hoki?” ");
INSERT INTO nuq_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Kito Jisas ki meake, “Vakkai no tattara ake Jon na mee kootou e llono ia ma na mee kootou e kkite raa: ");
INSERT INTO nuq_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","na tama e sseni raa ku kkite, na tama na vae e mmate raa ku hahaere, na tinotama na tama e kaina te manumanu haeo raa ku taualleka, na tama e tturi raa ku llono, na tama e mmate raa ku ora muri, tena na tama e tuttuu haeo raa ku llono te Rono Tauareka raa. ");
INSERT INTO nuq_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Na tama se mamannatu tammaki i Anau raa e me ki hakattapu ria!” ");
INSERT INTO nuq_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Te saaita na disaipol Jon raa ni oo, tena Jisas ku tattara ake te kanohenua raa i te vahi Jon, “Te saaita kootou ni oo iaa Jon i te kina e tuu mahoa raa, hea kootou ni mannatu ma kootou e me ki kkite raa? He veve e ino atu peeraa i te auna te matani raa e maairi mai? Seai! ");
INSERT INTO nuq_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Hea kootou ni oo ma ki oo no mmata raa? He tama e uru na hekau e sui mmaha? Seai hoki! Na tama e uru na hekau e sui mmaha raa e nnoho i roto na hare na tuku. ");
INSERT INTO nuq_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mee mai ki rono Anau! Hea kootou ni oo ma ki oo no mmata raa? He profet? Noo, e meia te profet nei seai ma he profet vare. ");
INSERT INTO nuq_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Maitaname Jon ko te tama te Launiu Tapu raa e tattara ma, ‘TeAtua e mee mai ma, “Anau e me ki kauna te profet Anau raa ki haere i mua Akoe no tanattana te mateara Akoe raa.” ’ ");
INSERT INTO nuq_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Anau e meatu te hakamaoni pera ma Jon e hakanaaniu roo i aruna na tama hakaatoa tera ni nnoho i roto te maarama nei raa. Emeia te Tama hakaoti i te Hakamaatua ana i te Vaelani raa e hakanaaniu i aruna Jon. ");
INSERT INTO nuq_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Kaamata te saaita Jon ni takutaku na tattara aia raa haere no tae te aho nei, te Hakamaatua ana i te Vaelani raa e hakalono llihu roo i na mahi na tama tera e hihhai ki hakamattua i te Hakamaatua ana raa. ");
INSERT INTO nuq_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","I mua roo hamai no tae te saaita Jon raa, na profet ia ma na Tuaa Moses raa e tattara mai i te vahi te Hakamaatua ana i te Vaelani raa; ");
INSERT INTO nuq_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","tena kame kootou e hihhai ki hakattina na tattara na tama raa, tena Jon ko Elaija koi, e mee te hamai aia raa e mmau i roto te Launiu Tapu. ");
INSERT INTO nuq_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tena hakallono, kame kootou e isi na katarina! ");
INSERT INTO nuq_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Kaa he mee peehee Anau e lavaa te tattara atu tera e hakanatahi ma na tama i te aho nei raa? Na tama raa e ssau pera ma ni tamalliki tera e nohonoho i na kina na maket. Na tama raa e nnoho no vavaa ake alaa tama ma, ");
INSERT INTO nuq_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Maatou e hakattani na rue roo taualleka, e meia kootou se hihhai ki llue! Tena maatou e huhua na rue hakaalloha, e meia kootou se ttani.’ ");
INSERT INTO nuq_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Te saaita Jon ni hamai raa, aia e hakamaatapu ki se kai na kai, ia ki se unu na wain, tena na tama hakaatoa e tattara ma, ‘Tama raa e isi te tipua sakkino i roto aia!’ ");
INSERT INTO nuq_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tena te saaita te Tamariki te Tama nei ni hamai raa, te Tama raa e kai, ia e unu na wain, tena na tama hakaatoa ku tattara ma, ‘Kira ake te Tama nei! Teenei he tama kaikai vvare ia ma he tama unu roo, tena Aia e ssoa laoi roo ma na tama aoao na takis ia ma na tama hai ssara raa!’ Te atamai TeAtua raa ku huri mai no hakamaoni i na mee taatou e kkite raa.” ");
INSERT INTO nuq_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Na tama na matakaina Jisas ni ppena tammaki na mirakol raa se lavaa roo te ttike i taha ma na hai sara laatou raa, tena Aia ki hai ake roo na tama na matakaina raa. ");
INSERT INTO nuq_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kootou na tama i Korasin raa e me ki haeo roo! Kootou hoki na tama i Betsaida raa e me ki haeo roo! Peeraa Anau ki ppena na mirakol Anau ni ppena i roto na matakaina kootou raa i Taia laaua ma Saidon, na tama na matakaina naa ko na ammuhi avare na rehu no ppari, ki huri ake pera ma laatou ku ttike i taha ma na hai sara laatou raa. ");
INSERT INTO nuq_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Anau e meatu te hakamaoni pera ma te Aho te Hakatonutonu raa, te aroha TeAtua i na tama i Taia laaua ma Saidon raa e me ki raka roo i aruna kootou. ");
INSERT INTO nuq_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Emeia, kootou na tama i Kaperneam raa! Eaa, kootou e hihhai ki ssau kootou hokkootou i te vaelani? Kootou e me ki lettua ria i te kina te ahi raa! Ia peeraa na mirakol Anau ni ppena i roto te matakaina kootou raa ki ppena i roto Sodom; peeraa te matakaina naa te aho nei koi nnoho koi! ");
INSERT INTO nuq_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kootou ki illoa pera ma i te Aho te Hakatonutonu raa, te aroha TeAtua i na tama i Sodom raa e me ki raka i aruna kootou!” ");
INSERT INTO nuq_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Te saaita naa Jisas ku tattara ma, “Tamana, TeAtua i te vaelani ia ma te maarama nei! Anau e hakammaha Akoe, e mee Akoe e hakari ake na tama se illoa raa na mee Akoe ni huu ki se illoa na tama e atamai ia ma na tama mattonu raa. ");
INSERT INTO nuq_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Hakamaoni Tamana, Akoe e hihai roo ma na mee raa ki kapihi mai peenei. ");
INSERT INTO nuq_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Te Tamana Anau raa e kou mai Anau na mee roo hakaatoa. Se hai tama hoki e iroa te Tamariki te Tama nei, te Tamana koi Hokoia e iroa, ia se hai tama e iroa te Tamana, te Tamariki Aia raa koi ia ma na tama te Tamariki raa ni hirihiri ki hakari na tattara Aia raa koi e illoa. ");
INSERT INTO nuq_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Oo mai Anau, kootou na tama hakaatoa tera ku naennae te amoamo na mee e mmaha raa, Anau e me ki kou atu te hamalollo. ");
INSERT INTO nuq_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Too na tiputipu Anau raa i roto kootou ki illoa kootou Anau, maitaname te anana Anau raa e laumarie, ia e pasemmu, tena kootou e me ki kkite te hamalollo hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Maitaname na mee Anau e tattara atu kootou raa e taualleka, tena hea Anau e me ki kou atu raa e mamahua roo.” ");
INSERT INTO nuq_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tena ki oti Jisas ma na disaipol Aia raa ku oo vaa roto te paupaku na wit raa i te aho te Sabat. Na disaipol Aia raa ku hikkai, tena laatou ki kotikoti na hua na wit raa no kkai. ");
INSERT INTO nuq_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Te saaita na Farisi raa ni kkite na disaipol raa e kotikoti na hua raa, na tama raa ku meake Jisas ma, “Kira ake, te mee naa e sara ma na disaipol Akoe raa ki kotikoti na hua raa i te Sabat!” ");
INSERT INTO nuq_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kito Jisas ki meake, “Kootou ni se ppau hea Devit ni ppena te saaita aia ma na tama e tauttari aia raa ni hikkai? ");
INSERT INTO nuq_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Devit ni haere i roto te Hare Tapu TeAtua raa, tena aia ma na tama tauttari aia raa ni kkai na haraoa e ttapu na maatua raa ni hoki ake TeAtua raa; niaina roo ma na tuaa raa e ppui na tama vare te kkai. Na maatua raa koi e lavaa te kkai na haraoa raa. ");
INSERT INTO nuq_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Eaa kootou ni se ppau hoki i roto na tuaa Moses pera ma na maatua i roto te Hare Tapu raa e sseu na tuaa i te aho te Sabat raa i na aho e ttapu hakaatoa, e meia na tama raa se ssara raea? ");
INSERT INTO nuq_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Anau e meatu pera ma se hai mee i te kina nei e hakanaaniu i aruna te Hare Tapu raa. ");
INSERT INTO nuq_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Te Launiu Tapu e mee mai ma, ‘Anau e hihai koi te laoi, seai ma na hoki na manu.’ Kame kootou e illoa hakamaoni roo te hakataakoto nei, tena kootou se lavaa hoki te haru na haeo na tama se isi na sara raa; ");
INSERT INTO nuq_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","maitaname te Tamariki te Tama nei ko TeAriki te Sabat.” ");
INSERT INTO nuq_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tena Jisas ku tiaki te kina raa no haere i te hare lotu na Jiu raa, ");
INSERT INTO nuq_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","tena e isi te tama te rima e mate e noho i te kina raa. E isi na tama e hihhai ki kkite Jisas e ppena na mee e ssara, kito na tama raa ki vahiri ake ma, “Na tuaa te Sabat raa e ppui taatou ki tokonaki na tama ki taualleka?” ");
INSERT INTO nuq_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tena Jisas ki meake, “Kame he tama kootou e isi te sipsip e tteiho i roto te rua i te aho te Sabat, akoe kame se hhuti ake te manu raa i aruna? ");
INSERT INTO nuq_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tena te ora te tama e hakanaaniu i aruna te sipsip! Ia tena na Tuaa taatou raa e hakattana hoki taatou ki tokonaki te tama i te Sabat.” ");
INSERT INTO nuq_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kito Jisas ki meake te tama te rima e mate raa, “Ssora te rima akoe.” Tena te tama raa ki ssora te rima aia raa, tena te rima raa ku tauareka ku ssau hoki pera ma teeraa rima. ");
INSERT INTO nuq_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kito na Farisi raa ki oo no hakatonutonu na tattara ma ki taa Jisas ki mate. ");
INSERT INTO nuq_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisas e rono na hakataakoto na tama raa ma ki taa Aia ki mate raa, tena Aia ki haere i taha ma te kina raa, tena he kanohenua e rahi roo ku tauttari Aia. Aia e tokonaki na tama hakaatoa e lavvea raa no taualleka, ");
INSERT INTO nuq_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","tena ki tattara ake na tama raa ki se tattara ake alaa tama i te vahi Aia. ");
INSERT INTO nuq_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aia e ppena peenei ma ki hakamaoni hea TeAtua ni tattara ake profet Aisaia ma ki tattara mai taatou ma: ");
INSERT INTO nuq_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Teenei te Tama Hehekau Anau tera Anau ni hirihiri, te Tama tera Anau e laoi, ia e hihia roo. Anau e me ki kou ake TeAnana Tapu Anau raa ki noho i roto Aia, tena Aia e me ki tattara atu i te hakatonutonu Anau na tama raa ki llono na henua hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tama raa se lavaa te hakatautau ia ma ki vavaa, ia Tama raa se lavaa te tuu no tattara hakamaroa i na kina na mateara. ");
INSERT INTO nuq_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tama raa se lavaa te peesia na tama na hakattina laatou e matanaennae raa i taha, ia se lavaa te taa mate na hakattina na tama raa ki mmate hua, ki tae roo te saaita Aia e hamai no kou mai na tiputipu te ora hakamaoni raa. ");
INSERT INTO nuq_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tena na tama hakaatoa e me ki tuku na hakattina laatou raa i Tama raa.” ");
INSERT INTO nuq_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tena na tama raa ki kou ake te tama e sseni, ia e se lavaa hoki te tattara, e mee aia e isi te tipua e tau i roto aia. Jisas e tokonaki te tama raa no lavaa te tattara, ia no lavaa hoki te kite. ");
INSERT INTO nuq_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Te kanohenua raa ku mahharo roo i na mee Jisas e ppena raa. Tena na tama raa ki vahihhiri ma, “Eaa, teenei ko te mokopuna Devit raa koi?” ");
INSERT INTO nuq_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Na Farisi raa e llono na tattara raa, tena na tama raa ki meake ma, “Te Tama naa e lavaa koi te hakaise na tipua raa e mee Belsebul e kou ake na mahi Aia ki ppena na mee raa.” ");
INSERT INTO nuq_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisas e iroa na hakataakoto na tama raa, tena Aia ki meake, “Kame he henua e motumotu i na kuturana no ppuhu hokolaatou, te henua naa se lavaa te tuu roroa. Tena kame he matakaina, seai naa he hai maatua e vaevae i na kuturana no ppuhu hokolaatou, tena na tama naa e me ki nnoho maseuseu hoki. ");
INSERT INTO nuq_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tena kame he kuturana i roto te nohorana Satan raa e ppuhu hokolaatou, te mee naa e huri ake pera ma te nohorana naa ku motumotu i na kuturana, tena te nohorana naa se roroa ku maseu. ");
INSERT INTO nuq_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kootou e tattara ma Belsebul e kou mai na mahi Anau ki hakaise na tipua raa i taha. Ia tena koai te tama e kou ake na mahi na tama tauttari kootou raa ki hakaise na tipua raa i taha? Na tama koi e tauttari kootou raa e me ki huri atu pera ma kootou e ssara! ");
INSERT INTO nuq_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kootou e ssara, teenaa seai ma ko Belsebul, e meia TeAnana Tapu TeAtua raa e kou mai na mahi Anau ki hakaise na tipua raa i taha. Tena te mee nei e hakamaoni pera ma te Hakamaatua ana i te Vaelani raa ku tae mai no nnoho ma kootou. ");
INSERT INTO nuq_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Se hai tama e lavaa te saa no uru i roto te hare te tama e ivi raa no too na hekau te tama raa, e meia kame aia e hihai, aia ku haihai te tama raa i mua, tena aia ku lavaa te uru i hare no too hea aia e hihai raa. ");
INSERT INTO nuq_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Kame he tama se tuu i te vahi Anau, te tama naa e hakataukaa ma Anau; te tama se tokonaki Anau ki hakkutu mai raa e hakatui na tama raa i taha ma Anau. ");
INSERT INTO nuq_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Teenei te hakataakoto Anau e tattara atu kootou raa: ni hai sara, ia ni tattara sakkino peehee na tama e pehipehi i te vahi TeAtua raa e lavaa koi te ssirihia; e meia na tattara sakkino te tama e ppehi i TeAnana Tapu raa se lavaa roo te ssirihia. ");
INSERT INTO nuq_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Te tama e mee na tattara sakkino i te vahi te Tamariki te Tama nei e lavaa te ssirihia; e meia na tattara sakkino te tama e mee i TeAnana Tapu raa e me ki mmoe tahi roo se lavaa te ssirihia. ");
INSERT INTO nuq_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Kame akoe e hihai na hua taualleka, tena akoe ki isi te laakau e homohomo tauareka; kame akoe e isi te laakau e homohomo haeo, tena akoe e me ki isi na hua haeo. Taatou e lavaa te illoa i na laakau raa e mee na hua laatou e hhua raa. ");
INSERT INTO nuq_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kootou ni lapono, kootou e lavaa peehee te tattara na tattara taualleka te saaita kootou e hai ssara? E mee te maihu raa e tattara iho na mee e kkapi i roto te hatu manava raa. ");
INSERT INTO nuq_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Na tama taualleka raa e huri mai na mee taualleka i roto na hatu manava laatou raa, tena na tama haeo raa e huri na mee sakkino i roto na hatu manava laatou raa. ");
INSERT INTO nuq_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Kootou ki illoa pera ma te Aho Hakatonutonu raa, kootou e me ki hakarikari na tattara sakkino hakaatoa roo kootou ni pehipehi raa. ");
INSERT INTO nuq_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Na tattara akoe raa e me ki hakatonutonu akoe, ki huri atu ma akoe e tonu; ma akoe e hai sara.” ");
INSERT INTO nuq_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tena e isi na tama poroporo na tuaa ia ma na Farisi e meake ma, “Rabai, maatou e hihhai ki kkite Akoe e pena he mirakol.” ");
INSERT INTO nuq_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kito Jisas ki meake, “Na tama te aho nei raa ni tama sakkino, ia ni tama se hakattina!” Kootou e mee mai ma ki huri atu he mirakol? Se lavaa! Te mirakol hokotahi Anau e me ki huri atu raa ko te mirakol profet Jona. ");
INSERT INTO nuq_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","E ssau hoki pera ma Jona e noho e toru na aho ia ma e toru na poo i roto te manava te ika e rahi roo, tena te Tamariki te Tama nei e me ki moe e toru na aho ia ma e toru na poo i te kava. ");
INSERT INTO nuq_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Te saaita te Aho Hakatonutonu raa, na tama i Ninive raa e me ki ttuu i aruna no ppau atu na hai sara kootou raa, maitaname na tama raa ni ttike i taha ma na hai sara laatou raa te saaita laatou ni llono na tattara Jona raa, tena Anau e meatu, e isi te mee i te kina nei e hakanaaniu roo i aruna Jona! ");
INSERT INTO nuq_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Te saaita te Aho Hakatonutonu raa, te avana te tuku i Seba raa e me ki tuu i aruna no ppau atu na hai sara kootou raa, maitaname aia ni horau mai roo i te henua aia e mmao raa ma ki hakarono na akoako te atamai te Tuku Solomon raa, tena Anau e meatu pera ma e isi te mee i te kina nei e hakanaaniu roo i aruna Solomon! ");
INSERT INTO nuq_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kame he tipua e haere i taha ma he tama, te tipua naa e me ki haere vaa roto na kina pakuppaku na henua raa no sesee he kina ki hamaroroo. Emeia kame aia se isi te kina e lave, ");
INSERT INTO nuq_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","tena aia e me ki tattara hokoia ma, ‘Anau e me ki vaakai muri te hare anau raa.’ Tena aia e me ki vaakai no kite pera ma te hare raa ku tuu vare, ia ku atea, tena ku oti te tukutuku hakaraoi. ");
INSERT INTO nuq_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tena te tipua raa e me ki haere no hakattaki ake e hitu hoki na tipua e sakkino roo i aruna aia ma ki oo laatou no nnoho i roto te tama naa. Te saaita na tipua raa ku nnoho roo hakaatoa, tena te tama naa e me ki haeo roo i aruna ma te kaamata raa. Teenei hea e me ki kapihi ake i na tama sakkino i te aho nei.” ");
INSERT INTO nuq_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas koi tattara ake koi na tama raa te saaita te tinna ia ma na taina Aia raa ni ttae ake i te kina raa. Na tama raa e ttuu i aho, tena ki meake na tama raa ma laatou e hihhai ki tattara ma Jisas. ");
INSERT INTO nuq_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kito na tama e ttuu i te kina raa ki meake Jisas ma, “Kira ake, te tinna ia ma na taina Akoe raa e ttuu i aho, tena na tama raa e hihhai ki tattara kootou.” ");
INSERT INTO nuq_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tena Jisas ki meake, “Koai te tinna Anau? Koai na taina Anau?” ");
INSERT INTO nuq_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kito Jisas ki hakassii ake na disaipol Aia raa, tena ki meake, “Kira ake! Na disaipol raa ko te tinna ia ma na taina Anau! ");
INSERT INTO nuq_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tena te tama tera e tautari na tiputipu te Tamana Anau i te vaelani raa, he taina, he kave, ia he tinna Anau.” ");
INSERT INTO nuq_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Te aho naa koi Jisas ku tiaki te hare naa no haere i tai, tena Aia ki noho i te kina raa no akoako ake na tama raa. ");
INSERT INTO nuq_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Te kanohenua e kkutu ake i te kina raa e rahi roo, tena Aia ki kake no noho i roto te manaui raa, e meia te kanohenua raa e ttuu i te taunatai. ");
INSERT INTO nuq_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jisas e tattara ake i na tattara hurihuri ki akoako ake tammaki na mee i na tama raa. “Hakallono! Teeraa he tama e haere ttori na hua na wit. ");
INSERT INTO nuq_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Te saaita aia ni haere maka na hua raa i roto te paupaku raa, tena alaa hua e maoha i aruna na mateara, tena na manu raa ku llee iho no kkai na hua raa. ");
INSERT INTO nuq_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Alaa hua e maoha i aruna na kina e hatu, ia te kerekere i te kina raa e patake roo. Na hua raa se roroa ku hhomo e mee te kerekere raa e patake. ");
INSERT INTO nuq_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Emeia te saaita te laa raa ni hopo ake, tena te laa raa ku ttuni na hua raa, e mee na patiaka na hua raa se uru roo i raro, tena na hua raa se roroa ku mmate. ");
INSERT INTO nuq_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Alaa hua e maoha i roto na tiare, tena na tiare raa e hhomo no uhi na hua raa. ");
INSERT INTO nuq_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Emeia alaa hua e maoha i te kina na kerekere taualleka, tena na hua raa ku hhomo no hhua na hua, alaa laakau e ttae huitarau na hua, alaa laakau e ttae tipu ono, tena alaa laakau e ttae tipu toru na hua.” ");
INSERT INTO nuq_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tena Jisas ki hakaoti ake ma, “Hakallono, kame kootou e isi na katarina.” ");
INSERT INTO nuq_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tena na disaipol raa ki oo ake no vahiri ake Jisas ma, “Aiea te saaita Akoe e tattara ake na tama raa, Akoe e tattara na tattara hurihuri raea?” ");
INSERT INTO nuq_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Kito Jisas ki meake, “TeAtua ku oti te kou atu te atamai na mee i roto te Hakamaatua ana i te Vaelani tera e huuna ria raa, e meia TeAtua se kou ake te atamai raa i na tama. ");
INSERT INTO nuq_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Maitaname na tama tera e isi na illoa laatou raa, TeAtua e me ki hakanuu na illoa na tama raa ki llahi roo, e meia na tama se isi na illoa raa, TeAtua e me ki ssau na illoa na tama raa i taha, niaina ma na illoa na tama raa e pammee. ");
INSERT INTO nuq_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Te hakataakoto Anau e tattara ake na tama raa i na tattara hurihuri raa e mee na tama raa e kirakira, e meia laatou se kkite, tena na tama raa e halollono, e meia na tama raa se llono, ia se hai mee e illoa. ");
INSERT INTO nuq_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ia tena na tattara TeAtua tera profet Aisaia ni tattara mai raa ku kkati ma na tama nei: ‘Na tama nei e me ki halollono koi no halollono e meia laatou se lavaa te illoa; na tama nei e me ki matamata koi no matamata, e meia laatou se lavaa te kkite, ");
INSERT INTO nuq_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","e mee na kapuroro laatou raa e nnahe roo te illoa, ia na katarina laatou raa e tturi, tena na karemata laatou raa e ppuni. TeAtua e mee ma peeraa na karemata na tama naa ki kkite, ia na katarina laatou raa ki llono, ia hoki na kapuroro laatou raa ki mallama, na tama naa e lavaa koi te tauttari Aia, tena Aia ku tokonaki na tama naa ki taualleka.’ ");
INSERT INTO nuq_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Tena kootou iaa, TeAtua ku oti te hakatapu kootou! Na karemata kootou raa ku kkite, tena na katarina kootou raa ku llono. ");
INSERT INTO nuq_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Anau e meatu te hakamaoni, tammaki na profet ia ma na tama e tauttari TeAtua e hihhai roo ki kkite na mee kootou e kkite raa, e meia laatou se lavaa te kkite, tena na tama naa e hihhai hoki ki llono na mee kootou e llono raa, e meia na tama naa se lavaa te llono. ");
INSERT INTO nuq_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Hakallono, tena ku mee ki illoa kootou te hakataakoto te tattara hurihuri te tama e haere lletu na hua raa. ");
INSERT INTO nuq_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Na tama e llono na tattara i te vahi te Hakamaatua ana i te Vaelani raa, e meia laatou se illoa na tattara raa, na tama naa e ssau pera ma na hua e maoha i aruna te mateara raa, tena Satan ki haere ake no ssoro na tattara TeAtua raa i taha ma na hatu manava na tama naa. ");
INSERT INTO nuq_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Na hua e maoha i te kina e hatu raa, e ttuu ma na tama e hihhia no too na tattara TeAtua raa te saaita koi laatou ni llono na tattara raa. ");
INSERT INTO nuq_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Emeia na tattara raa se mmoe tahi i roto na hatu manava na tama naa, ia se mmoe roroa hoki. Tena te saaita na hainattaa ia ma na hakalono llihu ku ttiri na tama raa e mee laatou e tauttari Anau, tena na tama naa ku tiaki hua koi na tattara raa. ");
INSERT INTO nuq_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Na hua e maoha i te kina na tiare raa e ttuu ma na tama e llono na tattara TeAtua raa, e meia na tama raa e mamannatu tammaki na ora i te maarama nei raa, ia te mannako laatou na mee taualleka raa e uhi na tattara TeAtua raa, tena na tama naa ku se hhua na hua. ");
INSERT INTO nuq_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tena na hua e hhomo i te kina na kerekere taualleka raa e ttuu ma na tama e llono, ia e illoa hoki na tattara TeAtua raa: na tama naa e me ki ppena tammaki na tiputipu taualleka, e ssau pera ma na hua e hhomo i te kerekere tauareka no hhua huitarau, tipu ono ia ma tipu toru na hua raa.” ");
INSERT INTO nuq_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas e tattara ake na tama raa teeraa tattara hurihuri hoki: te Hakamaatua ana i te Vaelani raa e tipu peenei. He tama e ttori na hua taualleka i roto te paupaku aia. ");
INSERT INTO nuq_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ia he poo hokotahi te saaita na tama hakaatoa ku mmoe, tena he tama manava haeo i te tama raa kue haere ake no ttori na veve haeo raa i te kina na wit e hhomo raa, tena ki haere. ");
INSERT INTO nuq_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Te saaita na wit raa ku homo no hhua, na veve sakkino raa hoki ku homo. ");
INSERT INTO nuq_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Te tama hehekau raa e haere no meake te tama raa ma, ‘Tama hakamaatua, akoe ni ttori na hua taualleka i roto te paupaku akoe raa, kaa na veve sakkino raa e oo mai i hee?’ ");
INSERT INTO nuq_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tena te tama hakamaatua raa ki meake, ‘E isi na tama manava sakkino e ttori na veve naa.’ Kito na tama raa ki meake, ‘Akoe e hihai ma maatou ki oo no haere uhu na veve raa i taha?’ ");
INSERT INTO nuq_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tena te tama hakamaatua raa ki meake, ‘Seai, kaa oti kootou ku haere uhu na veve raa, tena ku uhu hoki ma na wit raa. ");
INSERT INTO nuq_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tiaki na wit ia ma na veve raa ki hhomo hakaatoa ki tae roo te saaita taatou e haki na hua raa. Tena Anau e me ki meake na tama e haki na hua raa ki haere uhu na veve raa i mua, tena ku nonoa na veve raa i na sai no ttuni, tena ki oti na tama raa ku haere haki na hua na wit raa no hakatau i roto te hare anau raa.’ ” ");
INSERT INTO nuq_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tena Jisas ki tattara ake na tama raa teeraa tattara hurihuri hoki: “Te Hakamaatua ana i te Vaelani raa e tipu peenei. He tama e too te hua te mastet raa no ttori i roto te paupaku aia raa. ");
INSERT INTO nuq_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Te hua naa ko te hua roo e paamee hokoia i na hua hakaatoa, e meia te saaita aia e homo, te laakau raa e me ki rahi roo i aruna na laakau hakaatoa, te laakau naa e me ki homo no matua, tena na manu raa ku llee ake no pena na hohana laatou raa i aruna na raraa te laakau raa.” ");
INSERT INTO nuq_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tena Jisas ki tattara ake teeraa tattara hurihuri hoki: Te Hakamaatua ana i te Vaelani raa e tipu peenei. He hine e too na ist no hilo ma na haraoa raa, tena ki hakamoe te haraoa raa no huta. ");
INSERT INTO nuq_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas e tattara na tattara hurihuri na saaita Aia e tattara ake na kanohenua raa, ia ni tattara peehee Aia e tattara ake i na tama, Aia e tattara i na tattara hurihuri. ");
INSERT INTO nuq_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Aia e ppena peenei ki mee na tattara na profet raa ki hakamaoni ma, “Anau e tattara na tattara hurihuri na saaita Anau e tattara ake na tama raa; Anau e me ki tattara ake na tama raa na mee e huuna ria i te kaamata roo te saaita te maarama nei ni tipu mai raa.” ");
INSERT INTO nuq_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Te saaita te kanohenua raa ku tiaki Jisas no oo i na hare laatou raa, na disaipol Jisas raa ku oo ake no vahiri ake Tama raa ma, “Tattara mai maatou ma te hakataakoto te tattara hurihuri na veve e hhomo i roto te paupaku raa e mee maea.” ");
INSERT INTO nuq_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kito Jisas ki meake, “Te tama e ttori na hua taualleka raa ko te Tamariki te Tama nei; ");
INSERT INTO nuq_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","te paupaku raa ko te maarama nei; na hua taualleka raa ko na tama i roto te Hakamaatua ana i te Vaelani raa, tena na veve sakkino raa ko na tama e tauttari Satan raa, ");
INSERT INTO nuq_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","tena te tama sakkino e ttori na veve raa ko Satan. Te hakihaki na hua raa ko te hakaotioti na mee i te maarama nei, tena na tama e haere haki raa ko na ensel. ");
INSERT INTO nuq_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Tena na veve sakkino raa e me ki hakkutu ria no ttuni i roto te ahi, ia e me ki ssau peeraa hoki i te hakaotioti na mee hakaatoa i te maarama nei raa. ");
INSERT INTO nuq_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Te Tamariki te Tama nei e me ki kauna na ensel Aia raa ki oo no hakkutu na tama sakkino tera e mee na tama ki hai ssara raa ia ma na tama e ppena na mee sakkino raa i taha ma te Hakamaatua ana Aia raa, ");
INSERT INTO nuq_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","tena na ensel raa e me ki lletu na tama raa i roto te ahi e vvela roo, tena na tama raa e me ki ttani no hakatikkati na niho laatou raa. ");
INSERT INTO nuq_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tena na tama TeAtua raa e me ki hakamaahina ake pera ma te laa raa i roto te Hakamaatua ana te Tamana laatou raa. Hakallono, kame kootou e isi na katarina! ");
INSERT INTO nuq_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Te Hakamaatua ana i te Vaelani raa e tipu peenei. He tama e kite tammaki na sileni i roto te paupaku, tena aia ki tanu hakaraoi na mee raa. Te tama raa ku hihia roo, tena aia ki haere no too na hekau aia raa no kou ake alaa tama ki sui, tena aia ki too na sileni raa no haere no sui te paupaku raa. ");
INSERT INTO nuq_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ia hoki te Hakamaatua ana i te Vaelani raa e tipu peenei. He tama e sesee na pure e kivakiva, ");
INSERT INTO nuq_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ia te saaita aia ni kite te pure hokotahi e kivakiva roo, tena aia ku kou ake na hekau aia e ttino raa hakaatoa ki sui alaa tama, tena aia ki sui te pure e kivakiva raa. ");
INSERT INTO nuq_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ia hoki te Hakamaatua ana i te Vaelani raa e tipu peenei. E isi na tama meemee ika e ppehi te kupena laatou raa i roto te namo ma ki mmau na ika hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Te saaita te kupena raa ku pii na ika, na tama raa ku horo ake te kupena raa i uta, tena ki nnoho i raro no hiri na ika raa: na tama raa e ppono na ika taualleka raa i roto na kete, tena ki peesia na ika haeo raa i taha. ");
INSERT INTO nuq_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tena e me ki ssau peenei hoki i te hakaotioti na mee hakaatoa i te maarama nei raa: na ensel raa e me ki oo no havakkee na tama sakkino raa i taha ma na tama taualleka raa, ");
INSERT INTO nuq_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","tena ku lletu na tama sakkino raa i roto te ahi e vvela raa, tena na tama raa e me ki ttani no hakati kkati na niho laatou raa i te kina raa.” ");
INSERT INTO nuq_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tena Jisas ki vahiri ake na tama raa, “Kootou e illoa na mee nei?” Kito na tama raa ki meake, “Noo.” ");
INSERT INTO nuq_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tena Jisas ki meake, “Te hakataakoto nei e mee pera ma na tama e poroporo na tuaa tera ku mee mo disaipol i roto te Hakamaatua ana i te Vaelani raa e ssau pera ma he tama e ttino te hare tera e too na mee hoou ia ma na mee tuai raa no taari i taha ma te hare hakatautau na mee raa.” ");
INSERT INTO nuq_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisas ku oti te tattara ake na tattara hurihuri raa, tena Aia ki tiaki te kina raa ");
INSERT INTO nuq_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","no vaakai i te matakaina Aia raa. Tama raa e akoako i roto te hare lotu na Jiu raa, tena na tama e llono na tattara Aia raa ku mahharo roo. Na tama raa e tattara hokolaatou ma, “Tama raa e too te iroa Aia raa i hee? Kaa na mirakol hoki Aia e ppena raa? ");
INSERT INTO nuq_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Teenei seai ma ko te tamariki te tama hakatuutuu hare raa? Aiea Meri seai ma ko te tinna Aia, tena Jems, Josep, Saimon ia ma Judas seai ma ko na taina Aia? ");
INSERT INTO nuq_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Aiea na kaave Aia raa se nnoho i te matakaina nei? Tama nei e too te iroa Aia raa i hee?” ");
INSERT INTO nuq_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tena na tama raa ku se hihhai ki too Jisas. Kito Jisas ki meake na tama raa, “Na profet e me ki hakammaha ria i na kina roo hakaatoa, e meia te matakaina roo aia ia ma te hareakina roo aia raa e me ki se hihhai te tama naa.” ");
INSERT INTO nuq_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","E mee na tama raa se hakattina, tena Aia ki se ppena tammaki na mirakol i te matakaina raa. ");
INSERT INTO nuq_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Herot te tama e hakamaatua i roto Galili te saaita naa raa ku rono i na mahi Jisas. ");
INSERT INTO nuq_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tena Herot ki meake na purepure aia raa ma, “Te tama naa ko Jon Baptis hakamaoni ku ora hakaraoi? Tera hea aia e isi na mahi ki ppena na mirakol raa?” ");
INSERT INTO nuq_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Maitaname Herot ni meake kaamata ma na soldia aia raa ki hakapiki Jon, tena ku haihai tama raa no ppono i te hare karapusi. Aia e ppena peenei e mee Herodias te avana Filip te taina aia raa. ");
INSERT INTO nuq_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jon Baptis ni hai ake Herot i mua ma, “Te mee naa se tonu ma akoe ki avana Herodias!” ");
INSERT INTO nuq_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot e hihai roo ma ki taa Jon ki mate, e meia aia e mataku i te kanohenua na Jiu raa, maitaname na tama raa e hakattina pera ma Jon he profet. ");
INSERT INTO nuq_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herot e pena te kai ki maanatu te aho aia ni haanau iho raa, tena te taukupu aia raa ku ruerue i mua na tama i hare raa hakaatoa. Herot ku hihia roo, ");
INSERT INTO nuq_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","tena aia ki meake te taukupu aia raa, “Anau e meatu te hakamaoni pera ma anau e me ki kou atu he mee peehee akoe e kainno mai anau!” ");
INSERT INTO nuq_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kito te tinna te taukupu raa ki meake te hakataakoto aia, tena te taukupu raa ki kainno ake te tamana aia raa ma, “Pare mai te saaita nei roo koi, te pohouru Jon raa i aruna he parete!” ");
INSERT INTO nuq_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herot ku aroha, e meia aia ku se hai ara hoki, e mee te tattara aia ni kou ake te taukupu raa i mua na tama hakaatoa i hare raa, tena aia ki meake ki ppena te hakataakoto te taukupu raa ki kotia. ");
INSERT INTO nuq_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tena Herot ki kkave te tattara i na soldia aia raa ki ssepe te uaa Jon raa i roto te hare karapusi. ");
INSERT INTO nuq_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Na soldia raa ku pare ake te pohouru Jon raa i aruna te parete, tena ki kou ake te taukupu raa, tena te taukupu raa ki too te pohouru raa no kkave i te tinna aia raa. ");
INSERT INTO nuq_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tena na disaipol Jon raa ki oo ake no too te tinotama raa no kkave no tanu, tena laatou ki oo no meake Jisas. ");
INSERT INTO nuq_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Te saaita Jisas ni rono ma Jon ku mate, Aia ku tiaki te matakaina raa no kake te manaui raa no tere Hokoia i te kina se hai tama raa. Na tama raa ku llono ma Jisas ku tere, tena laatou ki tiaki na matakaina laatou raa no oo vaa uta i te kina Jisas e tere raa. ");
INSERT INTO nuq_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisas ku tiho i raro ma te manaui raa, tena te saaita aia ni kite te kanohenua e rahi raa, Aia ku aroha roo i na tama raa, tena Aia ki tokonaki na tama e lavvea raa no taualleka. ");
INSERT INTO nuq_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Te hiahi na disaipol raa ku oo ake no meake Jisas ma, “Te mee raa ku hiahi roo, tena te kina nei e mmao se hai tama. Kauna te kanohenua raa ki oo i na matakaina raa no sui ni kai ma laatou.” ");
INSERT INTO nuq_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kito Jisas ki meake na disaipol raa, “Na tama naa se lavaa te oo! Kootou hokkootou ki kou ake ni mee ki kkai na tama naa!” ");
INSERT INTO nuq_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kito na disaipol raa ki meake ma, “Maatou e isi koi e rima na haraoa ia ma e rua na ika.” ");
INSERT INTO nuq_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tena Jisas ki meake, “Kou mai na mee naa i te kina nei!” ");
INSERT INTO nuq_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kito Jisas ki meake te kanohenua raa ki nnoho i aruna na veve raa, tena Aia ki too na haraoa e rima raa ia ma na ika e rua raa, tena ki kkira i te vaelani no hakammaha ake TeAtua. Tena Aia ki ttohi na haraoa raa no kou ake na disaipol Aia raa, kito na disaipol raa ki vaevae ake na mee raa i te kanohenua raa. ");
INSERT INTO nuq_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Na tama roo hakaatoa e kkai no ppohu. Tena na disaipol raa ki sasao na kai e ttoe raa no ppii sanahuru ma rua na kete. ");
INSERT INTO nuq_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Te kooina na taanata raa hakaatoa kame e ttae rima simata, se ppau na hhine ia ma na tamalliki raa. ");
INSERT INTO nuq_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tena Jisas ki meake na disaipol Aia raa ki kkake te manaui raa no tere i mua i teeraa vahi te namo raa, tena Aia ki kauna te kanohenua raa no vakkai. ");
INSERT INTO nuq_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Aia e kauna te kanohenua raa no oti roo, tena Aia ki haere Hokoia i aruna te mouna raa no lotu. Jisas e noho koi Hokoia i te kina raa te saaita te mee raa ku hakapouri; ");
INSERT INTO nuq_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","tena te saaita naa hoki te manaui raa ku mmao, ia ku pehipehi roo, maitaname te matani raa e maairi mai roo i mua. ");
INSERT INTO nuq_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Jisas ku haere ake vaa aruna te lottai raa, tena i lottonu te toru ma te ono te tahata Aia ku taapiri ake i na disaipol Aia raa. ");
INSERT INTO nuq_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Te saaita na disaipol raa ni kkite Jisas e haere ake vaa aruna te lottai raa, tena na tama raa ku mattaku roo. Na tama raa ku tattara, tena ki vaa huri i te mattaku laatou raa ma, “Teenaa he tipua!” ");
INSERT INTO nuq_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jisas ku tattara ake na disaipol raa, tena ki meake, “Auu se ttuu na huru kootou! Teenei ko Nau koi. Auu se mattaku!” ");
INSERT INTO nuq_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kito Pita ki meake, “TeAriki, kame teenaa ko Koe hakamaoni, tena mee mai anau ki haere atu vaa aruna te lottai.” ");
INSERT INTO nuq_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tena Jisas ki meake, “Hamai.” Kito Pita ki tiho i taha ma te manaui raa no haere atu iaa Jisas raa vaa aruna te lottai. ");
INSERT INTO nuq_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Emeia te saaita koi te maanatu Pita raa ni tere ake i te matani e maairi hai mahi raa, te mataku aia raa ku tere ake, tena aia ku tere i roto te lottai. Kito Pita ki tani ake te varo aia ma, “TeAriki, tokonaki anau!” ");
INSERT INTO nuq_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Te saaita naa koi Jisas ku haaro atu te rima Aia raa no ttaohi Pita, tena ki meake, “Te hakatina akoe raa se hai mahi! Aiea akoe e mamaanatu tammaki naea?” ");
INSERT INTO nuq_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tena tokorua raa ku kkake i roto te manaui raa, tena te matani raa ku tteiho no marino kkii. ");
INSERT INTO nuq_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Na disaipol i roto te manaui raa ku hakammaha ake Jisas, tena na tama raa ki meake ma, “Hakamaoni roo, Akoe ko te Tamariki TeAtua.” ");
INSERT INTO nuq_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Na tama raa e tere vaa roto te namo raa no ttae he matakaina i roto Genesaret i teeraa vahi, ");
INSERT INTO nuq_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","tena na tama i te kina raa ku kkira ake no mattino Jisas. Kito na tama raa ki aru na tama na matakaina tappiri ake raa ki kou mai na tama lavvea raa iaa Jisas. ");
INSERT INTO nuq_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Na tama raa e kainno ake Jisas ma ki tiaki na tama lavvea raa ki ttaohi na kaunutu na hekau Aia raa ki taualleka na tama raa, tena na tama hakaatoa e ttaohi na kaunutu na hekau Jisas raa ku taualleka. ");
INSERT INTO nuq_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tena e isi na Farisi ia ma na tama e poroporo na tuaa e oo mai i Jerusalem no vahiri ake Jisas ma, ");
INSERT INTO nuq_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Aiea na disaipol Akoe raa se tauttari na tiputipu na tipuna taatou ni kou mai i mua raea? Na tama raa se ssoro na rima laatou raa i mua laatou e kkai na kai!” ");
INSERT INTO nuq_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kito Jisas ki meake, “Kaa kootou se tauttari na tattara TeAtua raa, tena ki tauttari koi na akoako kootou hokkootou raea? ");
INSERT INTO nuq_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","E mee TeAtua ni tattara mai ma, ‘Hakammaha na tamana ia ma na tinna kootou raa,’ tena, ‘Kame kootou e kou ake na haeo na tamana ia ma na tinna kootou raa, kootou e me ki taaia ria no mmate.’ ");
INSERT INTO nuq_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Emeia kootou e akoako ma kame na tama e isi na mee ki tokonaki na tamana ia ma na tinna laatou raa, tena ki oti ki meake ma, ‘Na mee nei ni mee TeAtua,’ ");
INSERT INTO nuq_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","tena na tama naa ku se tau hoki te hakammaha na maatua laatou raa. Kootou se hakammaha na tuaa TeAtua raa, e meia kootou e tauttari koi na akoako kootou hokkootou. ");
INSERT INTO nuq_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kootou ni tama tattara uhiuhi! Na tattara Aisaia ni tattara i te vahi kootou raa ku hakamaoni roo! ");
INSERT INTO nuq_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","TeAtua e mee ma, ‘Na tama nei e hakammaha Anau ma na maihu koi laatou, e meia na hatu manava laatou raa e mmao roo i taha ma Anau. ");
INSERT INTO nuq_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ia se tau hoki ma na tama nei ki hakammaha Anau, maitaname na tama nei e akoako na tuaa na tama raa pera ma ni tuaa Anau!’ ” ");
INSERT INTO nuq_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kito Jisas ki kanna ake te kanohenua raa ki oo ake Aia, tena Aia ki meake, “Hakallono ki illoa kootou! ");
INSERT INTO nuq_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Seai ma ko na mee e uru i roto na maihu kootou raa e mee kootou no hai ssara, e meia aaraa ko na mee e oo mai i taha ma na maihu raa e mee kootou no hai ssara.” ");
INSERT INTO nuq_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tena na disaipol raa ki oo ake no meake Jisas ma, “Akoe e iroa pera ma na hakataakoto na Farisi raa e sakkino roo i na tattara Akoe e tattara raa?” ");
INSERT INTO nuq_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Kito Jisas ki meake, “Na laakau hakaatoa te Tamana Anau i te vaelani raa ni se ttori raa e me ki uhu ria.” ");
INSERT INTO nuq_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","“Auu se mamannatu tammaki i na tama naa! Aanaa ko na tama hakamattua e sseni tera e hakattaki na tama karemata sseni raa, tena kame he tama e sseni e hakattaki teeraa tama e sseni, tokorua naa hakaatoa e me ki maoha i roto te rua e nnoto raa.” ");
INSERT INTO nuq_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kito Pita ki meake, “Hakamaarama mai te tattara naa ki illoa maatou.” ");
INSERT INTO nuq_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tena Jisas ki meake na tama raa, “Kootou ni disaipol Anau, e meia na illoa kootou raa se tae roo na illoa alaa tama. ");
INSERT INTO nuq_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kootou se ki illoa roo? He mee peehee e uru i roto te maihu e me ki haere no tae te kopu, tena ki oti ku haere iho i taha ma te tinotama. ");
INSERT INTO nuq_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Emeia na mee tera e oo mai i te hatu manava no hhopo i taha ma te maihu raa ko na mee roo tera e mee te tama ki hai sara raa. ");
INSERT INTO nuq_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Maitaname na hakataakoto sakkino ki taa na tama, ki hai huri ma alaa tama, ki ppena na tiputipu sakkino, ki kailallao, ki tattara malliu, tena ki tamoa haeo alaa tama raa e oo mai i te hatu manava. ");
INSERT INTO nuq_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aanei ko na mee tera e mee te tama ki hai sara. Emeia ki kkai se ssoro na rima pera ma kootou e tattara ma taatou ki ppena raa, te mee naa se mee kootou ki hai ssara.” ");
INSERT INTO nuq_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas ku tiaki te matakaina raa no haere no tae he kina e taapiri i na matakaina Taia laaua ma Saidon raa. ");
INSERT INTO nuq_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tena he hine i te matakaina Kenan e noho i te kina raa, tena aia ki haere ake no tani ake Jisas ma, “Tamariki Devit, Hai aroha mai anau! Taku tamariki hine raa e isi te tipua e tau i roto aia, tena te saaita nei aia ku haeo roo.” ");
INSERT INTO nuq_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Emeia Jisas se hai tattara e meake te hine raa. Tena na disaipol Jisas raa ki oo ake no meake Tama raa ma, “Hakaise te hine naa ki haere! Te hine naa e me ki haere vavaa koi peenaa vaa muri taatou!” ");
INSERT INTO nuq_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kito Jisas ki meake na disaipol Aia raa ma, “Anau e kauna ria ki hamai no tokonaki na tama e ssau pera ma ni sipsip i roto Israel tera ku llano raa.” ");
INSERT INTO nuq_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Te hine raa e rono na tattara raa, tena aia ki haere atu no tuturi i mua na vae Jisas raa no meake ma, “TeAriki, tokonaki anau!” ");
INSERT INTO nuq_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tena Jisas ki meake ma, “Se tonu ma taatou ki too na kai na tamalliki raa no kou ake na poi raa ki kkai.” ");
INSERT INTO nuq_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kito te hine raa ki meake, “TeAriki, te tattara naa e hakamaoni, e meia na poi raa e kkai hoki na maanunu e maoha i raro te tebol te tama hakamaatua laatou raa.” ");
INSERT INTO nuq_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tena Jisas ki meake te hine raa, “Akoe he hine roo e hakatina mahi! Anau e me ki ppena ma akoe hea akoe e hihai raa.” Te saaita naa koi te tamariki hine raa ku tauareka. ");
INSERT INTO nuq_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas ku tiaki te matakaina raa no haere vaa tai te Namo Galili raa. Aia e haere no kake te paa mouna raa, tena ki noho i raro. ");
INSERT INTO nuq_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Na kanohenua e tammaki roo ku oo ake iaa Jisas ma na tama na vae e mmate, na tama e sseni, na tama na vae e ppiko, na tama e tturi se lavaa te tattara ia ma tammaki na tama lavvea, tena te kanohenua raa e too na tama raa hakaatoa no hakammoe i mua na vae Jisas raa, tena Jisas ki tokonaki na tama raa hakaatoa no taualleka. ");
INSERT INTO nuq_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Te kanohenua raa ku mahharo e mee na tama e tturi se lavaa te tattara raa ku tattara, na tama na vae e ppiko raa ku taualleka, na tama na vae e mmate raa ku hahaere, na tama e sseni raa ku kkite; tena na tama raa hakaatoa ki hakammaha ake TeAtua na tama Israel raa. ");
INSERT INTO nuq_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisas e kanna ake na disaipol Aia raa no meake ma, “Anau e aroha roo na tama nei, maitaname na tama nei e nnoho ma Anau i roto e toru na aho, tena te saaita nei na tama nei ku se hai kai ki kkai. Anau se hihai ki kauna na tama nei ki oo se kkai, e mee na karemata na tama naa e me ki pouri te saaita laatou e vakkai raa.” ");
INSERT INTO nuq_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kito na disaipol raa ki vahiri ake ma, “Kaa maatou e me ki oo no ssee ni kai i hee ki hannai na tama nei ma teenei he kina e tuu mahoa nei?” ");
INSERT INTO nuq_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tena Jisas ki vahiri ake, “Kaa e hia na haraoa kootou e isi?” Kito na disaipol raa ki meake, “E hitu na haraoa, tena e rua na ika pammee.” ");
INSERT INTO nuq_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kito Jisas ki meake te kanohenua raa ki nnoho i raro. ");
INSERT INTO nuq_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tena Aia ki too e hitu na haraoa raa ia ma e rua na ika raa no hakammaha ake TeAtua, tena Aia ki tohitohi na haraoa ma na ika raa no kou ake na disaipol Aia raa, tena na disaipol raa ki vaevae ake na kai raa i te kanohenua raa no kkai. ");
INSERT INTO nuq_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Na tama raa hakaatoa e kkai no ppohu. Tena na disaipol raa ki sasao na kai e ttoe raa no ppii e hitu na kete. ");
INSERT INTO nuq_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Te kooina na taanata e kai raa e tae haa simata, se ppau na hhine laatou ma na tamalliki. ");
INSERT INTO nuq_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kito Jisas ki kauna te kanohenua raa no vakkai, tena Aia ki kake i roto te manaui raa no tere i Magadan. ");
INSERT INTO nuq_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Na Farisi ia ma na Sadyusi raa ni oo ake iaa Jisas raa no malliu ma ki taaiki Tama raa, kito na tama raa ki meake ma Jisas ki huri ake he mirakol ki kkite laatou pera ma TeAtua e kou ake hakamaoni na mahi Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Emeia Jisas e meake na tama raa, “Te saaita te laa raa e hakatootoo ki huru raa, kootou e me ki tattara ma, ‘Te poo nei e me ki tauareka roo e mee te lani mea raa ku hura.’ ");
INSERT INTO nuq_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tena te tahata roo kootou e me ki mahhuru no tattara ma, ‘Te mee raa e me ki lleku, maitaname te lani raa ku tuu pouri roo hakaatoa.’ Kootou e lavaa te illoa i te vahi te lani raa e mee kootou e kkite na tuutuu te vaelani raa, e meia kootou se lavaa te illoa na hakkatu na mee nei. ");
INSERT INTO nuq_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Na tama te aho nei raa ni tama roo e sakkino, ia se hakattina! Kootou e mee ma Anau ki huri atu he mirakol? Se lavaa! Te mirakol koi kootou e me ki kkite raa ko te mirakol Jona.” Tena Jisas ki huri no haere i taha ma na tama raa. ");
INSERT INTO nuq_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Na disaipol raa ku huro no ttae teeraa vahi te namo raa, tena na tama raa e ssiri hoki ma ki too ni haraoa. ");
INSERT INTO nuq_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kito Jisas ki meake na tama raa, “Lollohi hakamattonu i na ist na Farisi ia ma na Sadyusi raa.” ");
INSERT INTO nuq_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tena na disaipol raa ku tattara hokolaatou ma, “Tama raa e tattara peenei raa e mee taatou se isi na haraoa e kou mai.” ");
INSERT INTO nuq_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisas e iroa hea na tama raa e tattara, tena Aia ki vahiri ake, “Aiea kootou e tattara hokkootou ma kootou se isi na haraoa e kou mai naea? Na hakattina kootou raa e pammee roo! ");
INSERT INTO nuq_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kootou se ki illoa? Kootou se mannatu te saaita Anau ni ttohi na haraoa e rima raa no haanai rima simata na taanata? Kaa e hia na kete kootou ni sassao no ppii raa? ");
INSERT INTO nuq_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kaa na haraoa e hitu taatou ni hannai haa simata na taanata raa? E hia na kete kootou ni sassao no ppii raa? ");
INSERT INTO nuq_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kaa kootou se illoa peehee ma Anau se tattara atu kootou i te vahi na haraoa? Lollohi hakamattonu kootou i te vahi na ist na Farisi ia ma na Sadyusi raa!” ");
INSERT INTO nuq_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Te saaita naa roo na disaipol raa ku illoa ma Jisas se tattara ake laatou i te vahi na ist na tama e hilo ma na haraoa raa, e meia Tama raa e tattara i te vahi na akoako na Farisi ia ma na Sadyusi raa. ");
INSERT INTO nuq_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas ku haere no taapiri i te kina Sisaria Filipai raa, tena Aia ki vahiri ake na disaipol Aia raa i te kina raa ma, “Kootou e mannatu ma te Tamariki te Tama nei koai?” ");
INSERT INTO nuq_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kito na disaipol raa ki meake, “E isi na tama e tattara ma Akoe ko Jon Baptis, tena alaa tama e mee ma Akoe ko Elaija, alaa tama e mee ma Akoe ko Jeremaia ia ma Akoe he profet hoki.” ");
INSERT INTO nuq_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tena Jisas ki vahiri ake na disaipol raa, “Kaa kootou? Kootou e mannatu ma Anau koai?” ");
INSERT INTO nuq_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Kito Saimon Pita ki meake, “Akoe ko te Mesaia, te Tamariki TeAtua e ora tahi raa.” ");
INSERT INTO nuq_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tena Jisas ki meake, “Saimon, te tamariki Jon, akoe ku hakatapu ria. Maitaname te hakamaoni naa se hamai koi te tama, e meia te Tamana i te vaelani raa e kou atu akoe te hakamaoni naa. ");
INSERT INTO nuq_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ia tena Anau e meatu akoe Pita: akoe he hatu, tena Anau e me ki pena te hare lotu Anau raa i aruna te hatu nei, tena te mate se lavaa te seu te hare lotu naa. ");
INSERT INTO nuq_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Anau e me ki kou atu akoe na kii te Hakamaatua ana i te Vaelani raa, tena hea akoe e hakkapi i te maarama nei, te vaelani raa e me ki hakkapi hoki; ia hea akoe e hakattana i te maarama nei, te vaelani raa e me ki hakattana hoki.” ");
INSERT INTO nuq_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kito Jisas ki tattara ake na disaipol Aia raa ki se tattara ake ni tama pera ma Aia ko te Mesaia. ");
INSERT INTO nuq_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kaamata te saaita naa Jisas ku tattara hakamatahua ake na disaipol Aia raa ma, “Anau e me ki haere i Jerusalem no hakalono llihu i na rima na tama hakamattua, na maatua hakananniu ia ma na tama poroporo na tuaa raa. Anau e me ki taia ria no mate, e meia i muri e toru na aho, Anau e me ki mahike muri no ora.” ");
INSERT INTO nuq_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kito Pita ki hakattaki Jisas i taha ma na tama raa, tena aia ki hai ake Jisas ma, “TeAriki, TeAtua se hihai ma Akoe ki mate! Te mee naa se lavaa te kapihi atu Akoe!” ");
INSERT INTO nuq_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tena Jisas ki hakatike no hai ake Pita ma, “Satan, haere i taha ma Anau! Akoe e me ki ttuu vaa mua Anau, maitaname na hakataakoto akoe naa se oo mai TeAtua, e meia aanaa ni hakataakoto koi te tama.” ");
INSERT INTO nuq_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tena Jisas ki meake na disaipol Aia raa ma, “Kame he tama kootou e hihai ki tautari Anau, te tama naa ki se maanatu te ora aia, tena ku amo te kros aia raa no tautari mai Anau.” ");
INSERT INTO nuq_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kame kootou e mannako na ora kootou, tena kootou e me ki llano i taha ma te ora hakamaoni raa, e meia kame kootou se mannako na ora kootou raa no mmate ma Anau, tena kootou e me ki too te ora hakamaoni raa. ");
INSERT INTO nuq_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Hea kootou e me ki too kame kootou e ttino na mee hakaatoa i te maarama nei raa, e meia i roto roo na ora kootou raa e haeo? Se isi na mee kootou e me ki too! Tena se hai mee hoki kootou e lavaa te hoki ki sui muri na ora kootou raa. ");
INSERT INTO nuq_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Maitaname te Tamariki te Tama nei ku taapiri ki hamai ma na mahi hai mmahi te Tamana ia ma na ensel Aia raa, tena Aia e me ki kou atu na tuhana kootou raa tautari hea kootou ni ppena. ");
INSERT INTO nuq_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Anau e meatu te hakamaoni pera ma e isi na tama i te kina nei se lavaa te mmate ki tae roo te saaita laatou e kkite te Tamariki te Tama nei e hamai pera ma he Tuku raa.” ");
INSERT INTO nuq_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","E ono na aho ku llaka, tena Jisas ki too Pita ia ma te haanau Jems laaua ma Jon ki oo laatou i aruna te mouna e palluna raa. Te kina raa se hai tama, hokolaatou koi. ");
INSERT INTO nuq_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Te saaita na tama raa ni kkira ake Jisas, te tinotama Jisas raa ku senisi no kee roo, na karemata Aia raa ku maahina roo pera ma te laa, tena na hekau Aia raa ku makkini hua roo. ");
INSERT INTO nuq_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tena tokotoru na disaipol raa ku kkite hoki Moses laaua ma Elaija e tattara laatou ma Jisas. ");
INSERT INTO nuq_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kito Pita ki mahike i aruna no meake Jisas ma, “TeAriki, e tauareka roo e mee maatou e nnoho i te kina nei! Kame Akoe e hihai anau e me ki hakatuu e toru na paa hare, te hare Akoe, te hare Moses, tena te hare Elaija.” ");
INSERT INTO nuq_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita koi tattara, tena he pukureurehu e kkiva raa ku hamai no uhi tokotoru raa, tena te reo raa ku tattara iho ma, “Teenei he Tamariki Anau, tena Anau e laoi mahi roo Aia. Hakallono na tattara Aia raa!” ");
INSERT INTO nuq_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Te saaita na disaipol raa ni llono te reo raa, na tama raa ku mattaku roo no lletu no mmoe hakahaori i aruna te kerekere. ");
INSERT INTO nuq_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kito Jisas ki haere atu no ttaohi na tama raa, tena ki meake, “Mahhike i aruna, Auu se mattaku!” ");
INSERT INTO nuq_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kito na tama raa ki kkira ake no kkite Jisas ku tuu koi Hokoia. ");
INSERT INTO nuq_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Na tama raa koi oo mai koi i raro ma te mouna raa, tena Jisas ki meake hakaoti tokotoru raa ma, “Auu se tattara ake ni tama hea kootou ni kkite raa ki tae roo te saaita te Tamariki te Tama nei ku ora muri i taha ma te mate.” ");
INSERT INTO nuq_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tena na disaipol raa ki vahiri ake Jisas ma, “Kaa na tama e poroporo na tuaa raa e tattara ma Elaija e me ki hamai i mua te Mesaia raea?” ");
INSERT INTO nuq_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Kito Jisas ki meake, “Hakamaoni, Elaija e me ki hamai i mua no tanattana na mee hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tena Anau e meatu pera ma Elaija ku oti te hamai, e meia na tama raa se illoa i te tama raa, tena ki mee hakahaeo tama raa ki kotia na hakataakoto laatou raa. Tena na tama raa e me ki mee hakahaeo peeraa hoki i te Tamariki te Tama nei.” ");
INSERT INTO nuq_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tena na disaipol raa ku illoa koi ma Tama raa e tattara ake laatou i te vahi Jon Baptis. ");
INSERT INTO nuq_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jisas ma e toru na disaipol raa ku ttae i te kina te kanohenua raa e ttuu raa, tena he tanata e haere ake iaa Jisas no tuturi i mua Tama raa, ");
INSERT INTO nuq_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","tena ki meake, “TeAriki, hai aroha te tamariki anau nei! Tamariki nei e isi na peuppeu, tena alaa saaita te tamariki nei e me ki mahi roo no tteiho i roto te ahi, kaa seai i roto te vai. ");
INSERT INTO nuq_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Anau e too te tamariki nei no kou ake na disaipol Akoe raa, e meia laatou se lavaa te tokonaki taku tama nei.” ");
INSERT INTO nuq_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kito Jisas ki meake, “Kootou ni tama se isi na hakattina, tena na hakataakoto kootou naa e ssara hoki! E hia na vahao Anau e me ki nnoho ma kootou? Kou mai te tamariki naa i Anau i te kina nei!” ");
INSERT INTO nuq_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jisas e tattara hakamataku ake koi te tipua raa, tena te tipua raa ku tere i taha ma te tamariki raa, tena te tamariki tanata raa ku tauareka te saaita naa koi. ");
INSERT INTO nuq_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kito na disaipol raa ki oo ake hemuu iaa Jisas no vahiri ake ma, “Aiea maatou se lavaa te hakaise te tipua raa i taha raea?” ");
INSERT INTO nuq_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tena Jisas ki meake, “Kootou se lavaa, maitaname na hakattina kootou raa se hai mmahi. Anau e meatu kootou te hakamaoni pera ma kame na hakattina kootou raa e llahi pera ma te hua e paamee roo hokoia i na hua hakaatoa raa, tena kootou e me ki lavaa te meake te mouna raa ma, ‘Kkene no tuu i te kina raa!’ tena te mouna naa e me ki kkene. Kootou e lavaa te ppena he mee peehee! ");
INSERT INTO nuq_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Te lotu ia ma te hakamaatapu raa koi e lavaa te hakaise na tipua raa i taha, se hai mee peeraa hoki e lavaa.” ");
INSERT INTO nuq_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisas ku tattara ake na disaipol Aia raa te saaita laatou ni oo mai no kaatoa i Galili raa ma, “He tama e me ki hakari ake te Tamariki te Tama nei i na tama ");
INSERT INTO nuq_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","tera e me ki taa te Tama raa ki mate raa; e meia e toru na aho i muri te Tama raa e me ki mahike muri no ora.” Tena na disaipol raa ku alloha roo. ");
INSERT INTO nuq_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Te saaita Jisas ma na disaipol Aia raa ku ttae i Kaperneam, tena na tama e aoao na takis i te Hare Tapu raa ku oo ake no vahiri ake Pita ma, “Eaa, te Rabai kootou raa e me ki aoao hoki na takis i te Hare Tapu raa?” ");
INSERT INTO nuq_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Kito Pita ki meake, “Noo!” Te saaita Pita ni haere no uru i roto te hare Jisas e noho raa, Jisas ku vahiri ake kaamata roo iaa Pita ma, “Saimon, he hakataakoto peehee akoe e isi? Koai na tama e suisui ake na takis na tuku te maarama nei raa? Na tama te henua raa ma na tama alaa henua tera e nnoho i roto te henua raa?” ");
INSERT INTO nuq_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Kito Pita ki meake, “Na tama alaa henua tera e nnoho i roto te henua naa.” Tena Jisas ki vaakai ake te tattara Pita raa ma, “Tena te hakataakoto akoe raa e mee pera ma na tama te henua raa se lavaa te pehi na takis. ");
INSERT INTO nuq_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Emeia taatou se hihhai ma ki mee na tama nei ki mamannatu haeo. Tena oo i tai no lletu he uka. Tena i roto te maihu te ika kaamata kootou e mmau raa, kootou e me ki kkite te sileni tera e lavaa te pehi te takis Anau ia ma na takis kootou raa. Too te sileni naa no kkave ki pehi na takis taatou raa.” ");
INSERT INTO nuq_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Te saaita naa na disaipol raa ku oo ake no vahiri ake Jisas ma, “Koai te tama e hakanaaniu i roto te Hakamaatua ana i te Vaelani raa?” ");
INSERT INTO nuq_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kito Jisas ki kanna ake te tamariki raa no haere ake, tena Aia ki too tamariki no hakatuu i mua na tama raa, ");
INSERT INTO nuq_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","tena ki meake, “Anau e meatu te hakamaoni, kame kootou se huri no mee pera ma ni tamalliki, tena kootou se lavaa roo te uru i roto te Hakamaatua ana i te Vaelani raa. ");
INSERT INTO nuq_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Te tama e hakanaaniu i roto te Hakamaatua ana i te Vaelani raa ko te tama e laumarie no mee pera ma he tamariki. ");
INSERT INTO nuq_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Tena kame he tama e too hakaraoi te tamariki peenei raa i te inoa Anau, tena te tama naa e too hakaraoi hoki Anau. ");
INSERT INTO nuq_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Kame he tama e mee he tamariki paamee peenei raa ki tiaki te hakatina aia e isi i Anau raa, tena te tama naa e tau roo te nnoa he hatu e rahi te uaa aia raa, tena ku lletu aia hokoia i te lottai ki maremo. ");
INSERT INTO nuq_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Te maarama nei e haeo roo e mee e isi na mee e me ki mee na tama ki tiaki na hakattina laatou raa! Na mee peenei e me ki hura tahi, e meia na tama e ppena na mee nei ki hakamaoni raa e me ki haeo roo! ");
INSERT INTO nuq_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Kame te rima ia ma te vae akoe raa e mee akoe ki tiaki te hakatina akoe raa, tena tuu te vae ia ma te rima naa no peesia! E tauareka akoe ki too te ora e ora tahi ma te rima ia ma te vae hokotahi, ka oti akoe ku lettua ma saa rima ia ma saa vae akoe naa i roto te ahi e ura tahi raa. ");
INSERT INTO nuq_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kame te karemata akoe raa e mee akoe ki tiaki te hakatina akoe raa, tena kope te karemata naa no peesia! E tauareka akoe ki too te ora e ora tahi ma te karemata hokotahi, ka oti akoe ku lettua ma saa karemata akoe naa i roto te ahi e ura tahi raa. ");
INSERT INTO nuq_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Lollohi ka oti kootou ku hai lavvaka i na tamalliki peenei raa. Anau e meatu, na ensel e lollohi na tamalliki nei i te vaelani raa e nnoho tahi ma te Tamana Anau i te vaelani raa. ");
INSERT INTO nuq_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Maitaname te Tamariki te Tama nei e hamai ki tokonaki na tama ku llano raa. ");
INSERT INTO nuq_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Kootou e mannatu peehee kame he tama e isi huitarau na sipsip, tena he sipsip hokotahi ku haere no rano? Te tama naa e me ki tiaki teeraa tipu sivo ma sivo na sipsip raa ki kaikkai, tena Aia e me ki haere no sesee te sipsip e rano raa. ");
INSERT INTO nuq_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Anau e meatu, te saaita te tama naa e lave te sipsip e rano raa, te tama naa e me ki hihhia roo, e raka roo ma te hihia aia i na sipsip tipu sivo ma sivo se llano raa. ");
INSERT INTO nuq_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","E ssau hoki peenei, te Tamana kootou i te vaelani raa se hihai hoki ma he tamariki kootou ki haere no rano. ");
INSERT INTO nuq_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Kame te taina akoe raa e roto akoe, haere no tattara ake hakaraoi te sara te tama naa. Emeia auu se mee na tama ki illoa, te mee naa e me ki moe koi i lottonu koorua. Kame te taina akoe raa e hakarono akoe, tena akoe ku tokonaki te tama naa ki nnoho hakaraoi koorua. ");
INSERT INTO nuq_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Emeia kame te taina akoe raa se hihai ki hakarono akoe, tena too he tama seai naa tokorua na tama ki oo kootou pera ma te Launiu Tapu raa e tattara ma, ‘Tokorua seai naa tokotoru na tama naa e me ki hakatonutonu na tattara hakaatoa.’ ");
INSERT INTO nuq_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tena kame te tama naa se hihai ki hakarono na tattara tokorua naa, tena kootou ku mee iho te sara naa i roto te hare lotu ki hakallono na tama hakaatoa. Tena huri ake ki iroa aia pera ma aia e ssau pera ma he tama e noho pouri, ia he tama aoao na takis. ");
INSERT INTO nuq_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ia tena Anau e meatu kootou: hea kootou e hakkapi i roto te maarama nei, te vaelani raa e me ki hakkapi hoki, tena hea kootou e hakattana i roto te maarama nei, te vaelani raa e me ki hakattana hoki. ");
INSERT INTO nuq_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ia tena Anau e me ki meatu hoki: kame he tokorua na tama i te maarama nei e tattara no tonu ma ki lotu no kainno ake he mee, tena te Tamana i te vaelani raa e me ki kou ake hea te tokorua e hihhai raa. ");
INSERT INTO nuq_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kame tokorua seai naa tokotoru na tama e oo mai no kkutu i te inoa Anau, Anau e me ki noho i te kina naa ma na tama naa.” ");
INSERT INTO nuq_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tena Pita ki haere ake no vahiri ake Jisas ma, “TeAriki, kame te taina anau raa e tauhano te ppena na mee se ttonu i anau, e hia na vahao anau e me ki ssirihia na hai sara tama naa? E hitu na vahao?” ");
INSERT INTO nuq_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Kito Jisas ki meake, “Seai, seai ma e hitu na vahao, e meia e hitu ma tipu hitu na vahao, ");
INSERT INTO nuq_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","maitaname te Hakamaatua ana i te Vaelani raa e ssau peenei: Teeraa he tuku, tena aia e hihai ki kite na taoni na tama hehekau aia raa. ");
INSERT INTO nuq_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Te tuku raa ku noho koi ma ki mmata na taoni raa, tena na tama raa ku hakattaki ake te tama hehekau tera e isi te taoni aia e rahi i te tuku raa. ");
INSERT INTO nuq_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Te tama hehekau raa se isi na sileni tammaki ki pehi te taoni aia raa, kito te tuku raa ki meake alaa tama ki oo ake no sui te tama raa, te avana ia ma na tamalliki aia raa mo tama hehekau na tama raa ki lavaa te tama raa te pehi te taoni aia raa. ");
INSERT INTO nuq_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tena te tama hehekau raa ku tteiho no tuturi i mua te tuku raa no meake, ‘Akoe ki aroha no kou mai he saaita, tena anau e me ki pehi na taoni anau raa hakaatoa!’ ");
INSERT INTO nuq_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Te tuku raa ku aroha i te tama hehekau raa, tena aia ki ssoro te taoni te tama raa, tena ki meake te tama raa ki haere. ");
INSERT INTO nuq_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Kito te tama hehekau raa ki haere no ttiri teeraa tama hehekau tera e isi te taoni aia na sileni e moisi koi. Tena te tama hehekau raa ki ttaohi te uaa teeraa tama hehekau no haere unuki, tena ki meake, ‘Sui muri mai na sileni akoe ni taoni anau raa!’ ");
INSERT INTO nuq_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tena teeraa tama hehekau ku tteiho no tuturi, tena ki kainno ake te tama hehekau raa ma, ‘Akoe ki aroha no kou mai he saaita, tena anau e me ki pehi atu na taoni anau i akoe raa.’ ");
INSERT INTO nuq_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Emeia te tama hehekau raa se hihai, tena aia ki too te tama hehekau raa no ppono i roto te hare karapusi ki tae roo te saaita te tama raa e lavaa te pehi ake na taoni aia raa. ");
INSERT INTO nuq_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Te saaita alaa tama hehekau ni kkite hea e kapihi ake i teeraa tama hehekau raa, na tama raa ku se hihhia, tena laatou ki oo no meake te tuku raa na mee hakaatoa laatou e kkite te tama hehekau raa ni ppena raa. ");
INSERT INTO nuq_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kito te tuku raa ki kanna ake te tama hehekau kaamata raa ki haere ake i hare. Tena te tuku raa ki meake, ‘Akoe he tama hehekau sakkino, anau e ssoro na taoni akoe raa hakaatoa i taha e mee akoe e kainno mai anau ki hai aroha akoe. ");
INSERT INTO nuq_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Akoe e tau roo te hai aroha teeraa tama hehekau pera ma anau ni hai aroha akoe raa.’ ");
INSERT INTO nuq_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Te tuku raa ku roto roo, tena aia ki kkave te tama hehekau raa no ppono i te hare karapusi raa ma ki hakalono llihu te tama raa ki tae roo te saaita aia e pehi te taoni aia raa.” ");
INSERT INTO nuq_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tena Jisas ki hakaoti ake ma, “Te Tamana Anau i te vaelani raa e me ki ppena peenei hoki i na tama se lavaa te ssirihia na hai sara alaa tama raa ma na hatu manava laatou raa.” ");
INSERT INTO nuq_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas e tattara roo no oti, tena Aia ki tiaki Galili no haere i na matakaina i roto Judia i teeraa vahi te riva Jordan raa. ");
INSERT INTO nuq_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tammaki roo na tama e tauttari Aia, tena Aia ki tokonaki na tama lavvea raa no taualleka. ");
INSERT INTO nuq_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","E isi na Farisi e oo ake iaa Jisas ma ki taaiki Tama raa ma te vahiri nei, “Na tuaa taatou raa e hakattana te tama ki peesia te avana aia raa ki tau ma hea aia e hihai ma seai?” ");
INSERT INTO nuq_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Kito Jisas ki meake, “Aiea kootou se ppau i roto te Launiu Tapu pera ma TeAtua e pena te tanata ia ma te hine? ");
INSERT INTO nuq_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tena TeAtua ki meake, ‘Teeraa hea te taupeara raa e me ki tiaki na maatua aia raa, tena ku haere no nnoho ma te hine aia raa, tena tokorua naa ku mee pera ma he tama hokotahi.’ ");
INSERT INTO nuq_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tokorua naa ku se mee pera ma he tokorua, e meia tokorua naa ku hokotahi. Tena se hai tama e lavaa te mmosi hea TeAtua ni hukui raa.” ");
INSERT INTO nuq_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kito na Farisi raa ki vahiri ake, “Aiea, kaa Moses e kou mai te tuaa ma te tanata raa e lavaa te kou ake te hine aia raa he launiu ma ki ttuu te avana laaua raa, tena aia ku hakaise te hine raa ki haere raea?” ");
INSERT INTO nuq_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tena Jisas ki meake, “Moses e hakattana kootou ki tiaki na avana kootou raa, maitaname kootou e poro nattaa. Emeia te saaita TeAtua ni pena mai na mee hakaatoa raa se tipu peenei. ");
INSERT INTO nuq_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Tena Anau e meatu kootou, kame he tanata e peesia vare koi te hine aia raa e mee aia hokoia e ppena na tiputipu sakkino, tena te tanata naa e me ki sara i te vahi te haere avvana huri kame aia e too teeraa hine.” ");
INSERT INTO nuq_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tena na disaipol Aia raa ki meake, “Kame te mee nei e hakamaoni peenei, tena kame e tauareka koi taatou ki nnoho se avvana.” ");
INSERT INTO nuq_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kito Jisas ki meake, “Te akoako nei se haere na tama roo hakaatoa, e haere koi i na tama tera TeAtua ni kou ake na tattara raa. ");
INSERT INTO nuq_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Maitaname e isi na hakataakoto e kkee tera te tanata se lavaa te avana: alaa taanata e mee laatou e hannau mai roo peeraa, alaa taanata e mee laatou e ttipu mai roo peeraa, tena alaa tama se avvana e mee na uata laatou e ppena ma te Hakamaatua ana i te Vaelani raa. Tiaki na tama e lavaa te too na akoako nei raa ki tautari nailloa laatou.” ");
INSERT INTO nuq_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","E isi na tama e kou ake na tamalliki laatou raa iaa Jisas ma Tama raa ki hakapiri na rima Aia raa i aruna na tamalliki raa, tena ku lotu ma na tamalliki raa, kito na disaipol raa ki hai ake na tama raa. ");
INSERT INTO nuq_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Tena Jisas ki meake, “Tiaki na tamalliki naa ki oo mai Anau, auu se ppui na tamalliki naa, maitaname te Hakamaatua ana i te Vaelani raa he kina hoki na tama peenei.” ");
INSERT INTO nuq_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jisas e hakapiri na rima Aia raa i aruna na tamalliki raa no oti, tena Aia ki haere. ");
INSERT INTO nuq_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Teeraa he tama e haere ake no vahiri ake Jisas ma, “Rabai, ni mee peehee e taualleka anau te ppena ki lavaa anau te too te ora hakamaoni?” ");
INSERT INTO nuq_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Kito Jisas ki meake, “Aiea akoe e vahiri mai Anau i te vahi na mee taualleka naea? He Tama hokotahi koi e tauareka. Tautari na tuaa raa hakaatoa kame akoe e hihai ki too te ora hakamaoni raa.” ");
INSERT INTO nuq_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tena te tama raa ki vahiri ake, “Ni tuaa peehee e taualleka?” Kito Jisas ki meake, “Auu se taa tama, auu se karemata kailallao, auu se kailallao, ia auu se hatuhatu na tattara malliu alaa tama, ");
INSERT INTO nuq_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","tena hakammaha te tamana ia ma te tinna akoe raa, tena ku laoi alaa tama pera ma akoe e laoi akoe hokkoe raa.” ");
INSERT INTO nuq_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tena te tama raa ki meake, “Anau e tautari tahi na tuaa nei roo hakaatoa. Kaa hea hoki anau e me ki ppena?” ");
INSERT INTO nuq_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Kito Jisas ki meake, “Kame akoe e hihai ki tonu hakamaoni, tena haere no too na hekau akoe raa hakaatoa no kou ake alaa tama ki sui, tena ku too na sileni raa no kou ake na tama e tuttuu haeo raa, tena akoe e me ki isi na mee taualleka i te vaelani, tena ki oti akoe ku hamai no tautari Anau.” ");
INSERT INTO nuq_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Te saaita te tama tane raa ni rono na tattara nei, te tama raa ku se hihai roo, maitaname aia he tama roo e hai hekau. ");
INSERT INTO nuq_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tena Jisas ki tattara ake na disaipol Aia raa ma, “Anau e meatu te hakamaoni: na tama hai hekau raa e hainattaa roo te ttae te Hakamaatua ana i te Vaelani raa. ");
INSERT INTO nuq_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Anau ku vaakai atu hoki te tattara nei: na tama hai hekau raa e hainattaa roo te ttae te Hakamaatua ana i te Vaelani raa, te hainattaa raa e raka roo i aruna ma te kamel e uru i roto te rua te rina ttui paamaro raa.” ");
INSERT INTO nuq_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Te saaita na disaipol raa ni llono na tattara nei, na tama raa ku mahharo roo. Kito na tama raa ki vahihhiri ma, “Kaa koai na tama e me ki too te ora hakamaoni naa?” ");
INSERT INTO nuq_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Kito Jisas ki kkira ake na tama raa no meake ma, “Na mee nei e hainattaa ma taatou na tama, e meia na mee e hainauhie roo ma TeAtua.” ");
INSERT INTO nuq_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tena kito Pita ki tattara ake ma, “Kira ake, maatou e tiaki na mee hakaatoa roo no tauttari Akoe. Kaa hea maatou e me ki too?” ");
INSERT INTO nuq_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kito Jisas ki meake na disaipol raa, “Kootou ki illoa pera ma te saaita te Tamariki te Tama nei e noho ma na mahi i aruna te Hakamaatua ana Aia i te Maarama Hoou raa, kootou e me ki nnoho no hakamattua hoki i aruna na nohorana sanahuru ma rua na kaha Israel raa. ");
INSERT INTO nuq_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","“Tena na tama e tiaki na hare, na taina, na tamana, na tinna, na tamalliki laatou raa no tauttari Anau raa e me ki too huitarau na tuhana i aruna na mee nei, tena laatou e me ki too te ora e ora tahi. ");
INSERT INTO nuq_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Emeia tammaki na tama e ttuu i mua te saaita nei raa e me ki hakammuri, tena tammaki na tama e hakammuri te saaita nei raa e me ki ttuu i mua. ");
INSERT INTO nuq_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Te Hakamaatua ana i te Vaelani raa e tipu peenei. He tama e haere te tahata poo ma ki mmata ni taanata ki oo no uata i roto te paupaku aia raa. ");
INSERT INTO nuq_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Te tama raa e meake ma aia e me ki sui na tama raa te sui na tama kame e tottoo i roto te aho hokotahi raa, tena aia ki kauna na tama raa ma ki oo no uata. ");
INSERT INTO nuq_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Te sivo te tahata, tama raa ku vaakai hakaraoi i te kina te maket raa no kite na taanata e tuttuu koi se hai mee e mee, ");
INSERT INTO nuq_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","kito tama raa ki meake, ‘Kootou hoki, oo no uata i roto te paupaku anau raa, tena anau e me ki sui kootou te sui tauareka.’ ");
INSERT INTO nuq_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Kito na tama raa ki oo. Tena te laa latea ia ma te toru te hiahi tama raa ku vaakai hakaraoi i te maket no too alaa tama. ");
INSERT INTO nuq_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tena te mee raa ku taapiri ki tae te rima te hiahi, tena tama raa ku vaakai i te maket no kite na taanata e tuttuu vare koi se hai mee e mee. Kito tama raa ki vahiri ake na tama raa, ‘Aiea kootou e tuttuu vare roo te aho nei se hai mee e mee naea?’ ");
INSERT INTO nuq_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tena na tama raa ki meake, ‘Se hai tama e too maatou.’ Kito te tama raa ki meake, ‘Kame peenaa kootou ku oo hoki no uata i roto te paupaku anau raa.’ ");
INSERT INTO nuq_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Te saaita te laa raa ku huru raa, tena te tama hakamaatua te paupaku raa ku meake te tama e rorohi na tama hehekau te paupaku aia raa ma, ‘Kanna atu na tama hehekau raa no kou ake na sui na tama raa hakaatoa. Kaamata no sui na tama anau ni kou mai te hiahi raa, tena ku sui atu no hakaoti na tama anau ni kou mai te tahata poo raa.’ ");
INSERT INTO nuq_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Na tama tera ni hehekau hakamuri raa ku oo no too na sui laatou raa. ");
INSERT INTO nuq_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tena na tama ni hehekau kaamata raa ku oo ake hoki no too na sui laatou raa. Na tama kaamata raa e mannatu ma na sui laatou raa e me ki raka i aruna na sui na tama hehekau hakamuri raa. Emeia na tama raa e sui hakanatahi hakaatoa ma na tama hakamuri raa. ");
INSERT INTO nuq_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Na tama kaamata raa e too na sui laatou raa, tena ki haere tamumu i te tama hakamaatua raa ma, ");
INSERT INTO nuq_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Na tama hakamuri raa e hehekau paa saaita koi, e meia maatou e hehekau te aho nei roo hakaatoa i roto te laa e vvela nei, tena akoe e kou ake na sui na tama raa e ssau pera ma na sui maatou nei!’ ");
INSERT INTO nuq_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Kito te tama hakamaatua te paupaku raa ki meake te tama hehekau kaamata raa, ‘Taku soa, anau se hai laavaka akoe. Akoe e hihai ma anau ki sui akoe te siliva hokotahi i te aho hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Too na sileni akoe naa no haere i hare. Teenei he hihai anau ki sui na tama hakamuri raa na sui e ssau pera ma na sui kootou na tama kaamata raa. ");
INSERT INTO nuq_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Aiea anau se tau te ppena hea anau e hihai ma na sileni anau nei? Eaa, akoe e manava kkere e mee anau e tauareka i na tama nei?’ ” ");
INSERT INTO nuq_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kito Jisas ki hakaoti ake na tattara Aia raa ma, “Na tama ni hakamuri raa e me ki oo i mua, tena na tama ni oo i mua raa e me ki hakammuri.” ");
INSERT INTO nuq_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Te saaita Jisas ni haere peeraa i Jerusalem raa, Aia e kanna ake te sanahuru ma rua na disaipol Aia raa, tena ki tattara hemuu ake na tama raa te saaita laatou koi oo vaa aruna te mateara raa. ");
INSERT INTO nuq_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Jisas e meake na tama raa ma, “Hakallono, taatou e me ki oo i Jerusalem i te kina te Tamariki te Tama nei e me ki hakapiki ria no kou ake i na maatua hakananniu raa ia ma na tama poroporo na tuaa raa. Na tama raa e me ki tattara ma te Tama raa e tau te mate i na sara Tama raa ni ppena raa, ");
INSERT INTO nuq_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","tena ku too te Tama raa no kou ake i na tama seai ma ni Jiu raa, tena na tama raa e me ki tataussua te Tama raa, tena ku riki Tama raa, tena ku ttii Tama raa i aruna te kros; e meia i muri e toru na aho, Tama raa e me ki ora muri.” ");
INSERT INTO nuq_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tena te avana Sebedi raa ku haere ake iaa Jisas ma te tokorua na tama aia raa no tuturi i mua Jisas raa, tena ki kainno ake Tama raa hea aia e hihai raa. ");
INSERT INTO nuq_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kito Jisas ki meake te hine raa, “Hea akoe e hihai?” Tena te hine raa ki meake, “Tattara mai ki rono anau pera ma te saaita Akoe e Tuku raa, Akoe ku too tokorua na tama anau nei no hakanoho te tama te vahi laaua, tena teeraa tama i te vahi se laaua Akoe raa.” ");
INSERT INTO nuq_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Tena Jisas ki meake tokorua na tamatane te hine raa ma, “Koorua se illoa hea koorua e kainno mai Anau raa. Koorua e lavaa te unu te kapu na hakalono llihu Anau ku mee ki unu raa?” Kito tokorua raa ki meake, “Maaua e lavaa!” ");
INSERT INTO nuq_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tena Jisas ki meake tokorua raa, “Hakamaoni, koorua e me ki unu, e meia Anau se isi na mahi ki hirihiri ma koai te tama e me ki noho i te vahi laaua ia ma te vahi se laaua Anau raa. Na kina nei ni kina te Tamana Anau raa e tanattana ma na tama raa ki nnoho.” ");
INSERT INTO nuq_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Te saaita teeraa sanahuru na disaipol ni llono na tattara tokorua raa, na tama raa ku lloto roo i tokorua raa. ");
INSERT INTO nuq_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kito Jisas ki kanna ake na disaipol raa hakaatoa, tena ki tattara ake ma, “Kootou e illoa pera ma na tama hakananniu na tama e nnoho pouri raa e isi na mahi i aruna na tama raa, tena na tama hakamattua raa e isi hoki na mahi. ");
INSERT INTO nuq_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Emeia Anau se hihai ma te mee nei ki kapihi atu kootou. Kame he tama kootou e hihai ki hakanaaniu, te tama naa ki mee pera ma he tama hehekau i na tama hakaatoa; ");
INSERT INTO nuq_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ia kame he tama e hihai ki tuu i mua, tena te tama naa ki mee mo tama hehekau na tama hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","E ssau pera ma te Tamariki te Tama nei, Aia se hamai ki mee na tama ki hehekau ma Aia, e meia Aia e hamai ma ki hehekau ki tokonaki na tama, tena ku hoki ake te ora Aia raa ki taui muri tammaki na tama i taha ma na hai sara laatou raa.” ");
INSERT INTO nuq_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Te saaita Jisas ma na disaipol Aia raa ku tiaki Jeriko no oo, tena he kanohenua e rahi ku tauttari atu vaa muri. ");
INSERT INTO nuq_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tena tokorua na tama karemata sseni e nnoho i te vahi te mateara raa ku llono ma Jisas ku haere hakaraka, kito tokorua raa ki kakanna ake ma, “TeAriki, Tamariki Devit! Hai aroha mai maaua!” ");
INSERT INTO nuq_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tena te kanohenua raa ki hai ake tokorua raa ki nnoho hemuu. Emeia tokorua raa ku kakanna ake hakamaroa roo ma, “TeAriki, Tamariki Devit! Hai aroha mai maaua!” ");
INSERT INTO nuq_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tena Jisas ki hakamau no kanna ake tokorua raa, tena ki vahiri ake, “Hea koorua e hihhai ma Anau ki ppena ma koorua naa?” ");
INSERT INTO nuq_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kito tokorua raa ki meake, “TeAriki, maaua e hihhai ma Akoe ki taaraki na karemata maaua nei ki kkite!” ");
INSERT INTO nuq_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jisas ku aroha i tokorua raa, tena Aia ki hapake no ttaohi na karemata tokorua raa, tena te saaita naa koi tokorua raa ku lavaa te kkite, kito tokorua raa ki tauttari vaa muri Jisas. ");
INSERT INTO nuq_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jisas ma na disaipol Aia raa ku tappiri i Jerusalem, tena laatou ki oo no ttae i Betfage i te kina te Mouna e hhomo na Oliv raa. Laatou ku ttae i te kina raa, tena Jisas ki kauna tokorua na disaipol Aia raa ki oo i mua ");
INSERT INTO nuq_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ma na tattara nei: “Oo i te matakaina e tuu i mua raa, tena koorua e me ki kkite he donki e haihai e tuu ma te punua aia raa, tena koorua ku vvete na manu naa no hakattaki mai. ");
INSERT INTO nuq_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kame he tama e vahiri atu, tena koorua ku meake aia pera ma, ‘TeAriki e hihai na manu nei,’ tena te tama naa e me ki hakattana koorua ki too na manu naa.” ");
INSERT INTO nuq_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Na mee nei hakaatoa e kapihi mai ki mee na tattara na profet raa ki hakamaoni: ");
INSERT INTO nuq_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Meake te matakaina Saion raa, kira ake te tuku kootou raa ku haere atu! Tama raa e tuku Aia no mouraro, tena ki kake i aruna te donki; i aruna te punua te donki; te punua tane te donki.” ");
INSERT INTO nuq_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kito tokorua na disaipol raa ki oo no ppena hea Jisas ni tattara ake laaua ma ki oo no ppena raa: ");
INSERT INTO nuq_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","tokorua raa e oo no hakattaki ake te donki raa laaua ma te punua raa, tena laaua ki ssora na kaukahu laaua raa i aruna saa manu raa, tena Jisas ki kake i aruna. ");
INSERT INTO nuq_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tammaki na tama e sosora na kaukahu laatou raa i aruna te mateara, tena alaa tama ku tuutuu na paa raraa na laakau raa no lletu i aruna te mateara. ");
INSERT INTO nuq_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na tama e hahaere vaa mua ia ma na tama e hahaere vaa muri raa ku kaamata no vavaa ma, “Hakammaha te Tamariki Devit! TeAtua e hakatapu te tama e hamai i te inoa TeAriki raa! Hakammaha TeAtua!” ");
INSERT INTO nuq_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Te saaita Jisas ni tae atu i Jerusalem raa, te matakaina raa hakaatoa ku vaa huri roo. Na tama raa e vahihhiri ma, “Teenei koai te Tama nei?” ");
INSERT INTO nuq_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tena na tama e oo ake ma Jisas raa ki meake, “Teenei ko profet Jisas te tama i Nasaret i roto Galili raa.” ");
INSERT INTO nuq_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas e haere i roto te Hare Tapu raa no hakaise na tama hakaatoa e tataui na mee varoto te Hare Tapu raa i aho, tena ki hakahuri na tebol na tama e nnoho no sesenisi na sileni raa ia ma na tuai na tama e suisui na rupe raa, ");
INSERT INTO nuq_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","tena Aia ki meake na tama raa ma, “E mmau i roto te Launiu Tapu pera ma TeAtua e tattara ma, ‘Te Hare Tapu Anau nei he hare lotulotu.’ Emeia kootou ku huri te hare nei ki mee mo hare na tama kailallao!” ");
INSERT INTO nuq_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na tama e sseni ia ma na tama na vae e ppiko raa ku oo ake iaa Jisas i te Hare Tapu raa, tena Aia ki tokonaki na tama raa no taualleka. ");
INSERT INTO nuq_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Na maatua hakananniu ia ma na tama poroporo na tuaa raa ku lloto te saaita laatou ni kkite na mee taualleka Jisas e ppena raa, tena na tamalliki raa ku vaa varoto te Hare Tapu raa ma, “Hakammaha te Tamariki Devit!” ");
INSERT INTO nuq_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kito na tama raa ki vahiri ake Jisas ma, “Akoe e rono na tattara na tama raa?” Kito Jisas ki meake, “Noo, Anau e rono. Aiea kootou se ppau na tattara nei i roto te Launiu Tapu? ‘Kootou e ako ake na tamalliki ia ma na memea raa ki hoki na hoki e ttonu hakamaoni.’ ” ");
INSERT INTO nuq_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tena Jisas ki tiaki na tama raa no haere i te matakaina Betani raa no noho te poo naa i te matakaina raa. ");
INSERT INTO nuq_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Te tahata te saaita Aia ku vaakai i te matakaina raa, Aia ku rono te hikai. ");
INSERT INTO nuq_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tena Aia e kkira no kite te fik e tuu i te vahi te mateara, tena Aia ki haere atu, e meia Aia e kite koi na laumea se hai hua e mmau. Kito Jisas ki meake te laakau raa, “Akoe se lavaa hoki te hua na hua!” Te saaita naa koi te laakau raa ku haere mate. ");
INSERT INTO nuq_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Na disaipol raa e kkite no mahharo. Tena laatou ki vahihhiri ma, “Te laakau raa e mate vave roo peehee?” ");
INSERT INTO nuq_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Kito Jisas ki meake, “Anau e meatu te hakamaoni, kame kootou e hakattina, ia se isi tammaki na mannatu, tena kootou e me ki lavaa te ppena hea Anau ni ppena i te laakau nei raa. Ia seai ma ko te mee nei koi, e meia kootou e me ki lavaa te meake te mouna nei ki haere no tuu i te moana, tena te mouna naa e me ki haere. ");
INSERT INTO nuq_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kame kootou e hakattina, kootou e me ki too hea kootou e kainno ake i na lotu kootou raa.” ");
INSERT INTO nuq_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas ku vaakai i te Hare Tapu, tena te saaita Aia ni akoako raa, na maatua hakananniu ia ma na tama hakamattua raa ku oo ake no vahiri ake Tama raa ma, “Ni mahi peehee Akoe e isi ki ppena na mee nei? Koai te tama e kou atu na mahi Akoe naa?” ");
INSERT INTO nuq_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Kito Jisas ki meake na tama raa ma, “Anau e me ki vahiri atu he vahiri hokotahi, tena kame kootou e mee mai te hakataakoto te vahiri Anau nei, tena Anau e me ki meatu ma ni mahi peehee Anau e isi ki ppena na mee nei. ");
INSERT INTO nuq_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Tena na mahi Jon e isi ki hakoukou tapu na tama raa ni mahi e oo mai i hee: e oo mai TeAtua ma e oo mai koi te tama?” Tena na tama raa ku kaamata no hakataukoti hokolaatou ma, “Taatou e me ki meake peehee? Kame taatou e meake ma, ‘Ni mahi TeAtua’, tena Aia e me ki mee mai taatou ma, ‘Kaa kootou se hakattina Jon naea?’ ");
INSERT INTO nuq_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Emeia kame taatou e mee ma, ‘Ni mahi koi na tama,’ taatou e mattaku hoki hea te kanohenua raa e me ki ppena i taatou, maitaname na tama raa hakaatoa e hakattina pera ma Jon he profet.” ");
INSERT INTO nuq_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kito na tama raa ki meake Jisas ma, “Maatou se illoa.” Tena Jisas ki meake na tama raa ma, “Anau hoki se lavaa te meatu ma ni mahi peehee Anau e isi ki ppena na mee nei.” ");
INSERT INTO nuq_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kito Jisas ki meake, “Kaa kootou e mannatu maea? He tama e isi tokorua na taupeara. Tama raa e haere no meake te taupeara matua raa ma, ‘Taku tama, haere no vere te paupaku e hhomo na grep raa te aho nei.’ ");
INSERT INTO nuq_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tena te taupeara matua raa ki meake, ‘Anau e kkaro te haere no vere,’ e meia te saaita te tamana aia raa ni haere, te taupeara raa ku senisi te hakataakoto aia no haere no vere. ");
INSERT INTO nuq_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tena te tamana laaua raa ki haere no meake te taupeara paamee raa na tattara aia ni meake te taupeara matua raa. Kito te tapeara paamee raa ki meake, ‘Noo, taku tamana, anau e me ki haere,’ e meia aia se haere koi. ");
INSERT INTO nuq_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Koai te tama tokorua nei e ppena hea te tamana laaua raa e hihai raa?” Kito na tama raa ki meake, “Te taupeara matua.” Tena Jisas ki meake na tama raa, “Anau e meatu kootou: na tama aoao na takis ia ma na hhine se ttonu raa e me ki ttae te Hakamaatua ana i te Vaelani raa i mua kootou. ");
INSERT INTO nuq_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Maitaname Jon Baptis e hamai no huri atu te mateara e tonu kootou ki tauttari, tena kootou se hakattina tama raa; e meia na tama aoao na takis ia ma na hhine se ttonu raa e hakattina i tama raa. Niaina te saaita kootou ni kkite te mee nei raa, kootou se senisi na hakataakoto kootou raa no hakattina tama raa.” ");
INSERT INTO nuq_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kito Jisas ki meake, “Hakallono mai teeraa tattara hurihuri: He tama e ttori na hua na grep i roto te kerekere aia e ttino raa, tena ki ppui areha te paupaku raa, tena ki ssaa te rua ki kumikumi na wain raa, tena ki pena te hare palluna. Tena aia ki kou ake te paupaku raa ki lollohi na tama, tena aia ki horau alaa henua. ");
INSERT INTO nuq_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Te saaita na hua na grep raa ku lleu, te tama hakamaatua raa ku kauna na tama hehekau aia raa ki oo no too te tuhana aia raa no kou ake. ");
INSERT INTO nuq_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Na tama lollohi te paupaku raa ku ttaohi na tama hehekau raa no taa, tena ki taa teeraa tama no mate, tena ki maka teeraa tama na hatu. ");
INSERT INTO nuq_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tena te tama hakamaatua raa ki kauna hoki alaa tama hehekau, e meia na tama raa ku tammaki i aruna na tama kaamata raa, tena na tama lollohi raa ki ppena i na tama raa hea laatou ni ppena i na tama kaamata raa. ");
INSERT INTO nuq_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tena aia ki kauna te taupeara aia raa hakamuri. Aia e tattara ma, ‘Hakamaoni roo na tama nei e me ki hakammaha te tamariki anau nei,’ ");
INSERT INTO nuq_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Emeia te saaita na tama lollohi te paupaku raa ni kkite te taupeara raa, na tama raa ku tattara hokolaatou ma, ‘Oo mai, taatou ki taa te taupeara nei, tena taatou ku too na mee aia e ttino raa ma taatou!’ ");
INSERT INTO nuq_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kito na tama raa ki ttaohi te taupeara raa no lletu tama raa i taha ma te paupaku raa, tena ki taa tama raa no mate.” ");
INSERT INTO nuq_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kito Jisas ki meake, “Te saaita te tama hakamaatua te paupaku raa e hamai raa, hea te tama raa e me ki ppena i na tama lollohi raa?” ");
INSERT INTO nuq_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tena na tama raa ki meake, “Te tama hakamaatua raa e me ki taa na tama sakkino raa ki mmate, tena ku kou ake te paupaku raa ki lollohi alaa tama; na tama tera e lavaa te kou ake te tuhana aia raa te saaita na hua raa e lleu.” ");
INSERT INTO nuq_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kito Jisas ki meake na tama raa, “Kootou se hai vahao e ppau hea te Launiu Tapu raa e tattara? ‘Te hatu na tama hakatuutuu hare raa e hakahekeheke ma e haeo raa ko te hatu e mmau roo hokoia i na hatu hakaatoa. Teenei he mee TeAriki e pena; he mee tauareka roo tera taatou e kkite!’ ” ");
INSERT INTO nuq_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tena Jisas ki meake hoki, “Anau e meatu kootou, te Hakamaatua ana i te Vaelani raa e me ki too ria i taha ma kootou no kou ake i na tama tera e lavaa te hhua na hua hakamaoni raa.” ");
INSERT INTO nuq_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Te tama e tteiho i aruna te hatu nei raa e me ki motumotu matalliki roo, tena kame te hatu naa e tteiho i aruna he tama, te hatu naa e me ki hakapelapela te tama naa ki mee mo rehu. ");
INSERT INTO nuq_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na maatua hakananniu ia ma na tama hakamattua raa e llono na tattara hurihuri Jisas raa, tena laatou ku illoa koi ma Jisas e tattara i laatou, ");
INSERT INTO nuq_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","kito na tama raa ki tattara ma ki hakapiki Jisas. Emeia laatou e mattaku i te kanohenua raa, maitaname na tama raa hakammaha roo ma Jisas he profet. ");
INSERT INTO nuq_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas ku tattara ake hoki na tama raa i na tattara hurihuri. ");
INSERT INTO nuq_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Te Hakamaatua ana i te Vaelani raa e ssau peenei. Teeraa he tama e tanatana te kai e rahi ma te arapou tanata aia raa ki avana. ");
INSERT INTO nuq_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tama raa e kauna na tama hehekau aia raa ki oo no meake na tama aia ni aru raa ki oo ake, e meia na tama raa e kkaro te oo ake. ");
INSERT INTO nuq_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kito te tama raa ki kauna alaa tama hehekau ma na tattara aia nei, ‘Te kai raa ku tanatana, na bulmakau ia ma na sipsip e llahi anau raa ku oti te taa, tena na mee hakaatoa ku tanatana. Oo mai ki kkai te kai te avana nei!’ ");
INSERT INTO nuq_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Emeia na tama te tama raa ni aru raa se anaana atu na tattara te tama raa, e meia laatou e oo koi no ppena hea laatou e mannatu ki ppena raa: teeraa tama e haere i te paupaku aia raa, teeraa tama e haere i te stoa aia raa, ");
INSERT INTO nuq_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","e meia alaa tama e ttaohi na tama hehekau raa no taa na tama raa, tena ki taa alaa tama no mmate. ");
INSERT INTO nuq_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Te tuku raa ku roto roo, tena aia ki kauna na soldia aia raa ki oo no taa na tama raa ki mmate, tena ku ttuni te matakaina na tama raa ki ura. ");
INSERT INTO nuq_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kito te tuku raa ki kanna ake na tama hehekau aia raa no tattara ake ma, ‘Te kai te avana nei ku tanatana, e meia na tama anau ni aru raa ku se tau te oo mai no kkai te kai nei. ");
INSERT INTO nuq_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tena oo te saaita nei i na mateara e llahi raa no hakkoro mai tammaki roo na tama ki oo mai i te kai nei.’ ");
INSERT INTO nuq_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kito na tama hehekau raa ki oo i na mateara raa no hakkoro na tama roo hakaatoa laatou e ttiri raa, na tama taualleka ia ma na tama haeo, tena te hare e me ki kkai te kai raa ku kkapi roo na tama. ");
INSERT INTO nuq_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Kito te tuku raa ki haere atu no mmata na tama e oo ake i te kai raa, tena aia e kite te tama hokotahi se uru na hekau na tama e uruuru na saaita na kai na avana raa. ");
INSERT INTO nuq_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tena te tuku raa ki haere no vahiri ake te tama raa ma, ‘Taku soa, akoe e uru mai i hare peehee ma akoe se uru na hekau na tama e uruuru na saaita na kai na avana naa?’ Emeia te tama raa e tuu hemuu koi se hai tattara e meake. ");
INSERT INTO nuq_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tena te tuku raa ki meake na tama hehekau aia raa, ‘Haihai na rima ia ma na vae te tama nei raa, tena ku lletu aia i aho i te kina e pouri raa. Tena aia e me ki tani no hakati kkati na niho aia raa.’ ” ");
INSERT INTO nuq_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tena Jisas ki hakaoti ake ma, “Tammaki na tama e me ki aruhia, e meia e moisi koi na tama e mee hirihiri ria.” ");
INSERT INTO nuq_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Na Farisi raa e oo no tattara ma laatou ki taaiki Jisas ma na vahiri laatou raa. ");
INSERT INTO nuq_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tena na Farisi raa ki kauna na disaipol laatou raa ia ma na tama i roto te kuturana Herot raa. Na tama raa e oo no meake Jisas ma, “Rabai, maatou e illoa Akoe e tattara te hakamaoni. Akoe e akoako ake na tama te hakamaoni hea TeAtua e isi ma na tama raa, tena Akoe se maanatu hoki hea na tama e mannatu, maitaname Akoe se maanatu hoki na mahi te tama e isi. ");
INSERT INTO nuq_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tena mee mai maatou: Akoe e maanatu peehee? E me ki sara ma na tuaa taatou kame taatou e sui ake na takis raa i te tuku i Rom ma seai?” ");
INSERT INTO nuq_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Emeia Jisas e iroa na hakataakoto sakkino na tama raa, tena Aia ki meake, “Kootou ni tama tattara uhiuhi! Aiea kootou e hahaivi ma ki taaiki Anau naea? ");
INSERT INTO nuq_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Huri mai he sileni na sileni kootou e tataui na takis raa!” Kito na tama raa ki kou ake te sileni, ");
INSERT INTO nuq_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","tena Jisas ki vahiri ake na tama raa, “Teenei he pohouru, ia he inoa aii e mmau i te sileni nei raa?” ");
INSERT INTO nuq_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kito na tama raa ki meake, “Te pohouru ia ma te inoa te tuku i Rom.” Tena Jisas ki meake na tama raa, “Tena kootou ku sui ake te tuku i Rom raa hea aia e ttino, tena ku sui ake TeAtua hea TeAtua e ttino.” ");
INSERT INTO nuq_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Te saaita na tama raa ni llono na tattara nei, na tama raa ku mahharo roo, tena ki tiaki Jisas no oo i taha. ");
INSERT INTO nuq_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Te aho naa koi na Sadyusi raa ku oo ake iaa Jisas raa, tena ki tattara ma na tama ku mmate raa se lavaa te ora muri i taha ma te mate. ");
INSERT INTO nuq_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Na tama raa e vahiri ake ma, “Rabai, Moses e tattara mai ma kame he tanata e mate se hai tamalliki, te taina aia raa e me ki avana te hine raa ki hura tama ma te taina aia ku mate raa. ");
INSERT INTO nuq_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ia tena e isi tokohitu na hai taina ni nnoho i te kina nei. Te tama matua raa e avana no mate se hai tamalliki, tena taina pare ake raa ku avana te hine raa. ");
INSERT INTO nuq_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Te tama raa ku mate hoki se hai tamalliki, tena te tama hakatoru raa ki avana te hine raa hoki no mate se hai tamalliki. Te hai taina raa hakaatoa e avvana te hine raa no mmate se hai tamalliki ");
INSERT INTO nuq_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tena ki oti roo te hine raa ku mate. ");
INSERT INTO nuq_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ia tena i te aho na tama hakaatoa e me ki ora muri raa, koai te tama te hai taina nei e me ki avana te hine raa? Na tama nei hakaatoa ku oti te avvana te hine raa.” ");
INSERT INTO nuq_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kito Jisas ki meake, “Kootou e vvare roo! Kootou e vvare maitaname kootou se illoa na tattara te Launiu Tapu ia ma na mahi TeAtua raa. ");
INSERT INTO nuq_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","I te aho na tama e me ki mahhike i taha ma te mate no ora muri raa, na tama raa e me ki ssau pera ma ni ensel i te vaelani, tena laatou se lavaa te avvana. ");
INSERT INTO nuq_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ia tena i te vahi te ora muri i taha ma te mate raa: kootou se hai vahao e ppau hea TeAtua ni tattara atu i kootou? Aia e mee ma, ");
INSERT INTO nuq_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Anau ko TeAtua Abraham, TeAtua Aisak ia ma TeAtua Jekop.’ Aia ko TeAtua na tama e ora, seai ma na tama e mmate.” ");
INSERT INTO nuq_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Te saaita te kanohenua raa ni llono na tattara nei, na tama raa ku mahharo roo i na akoako Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Te saaita na Farisi raa ni llono ma na tattara Jisas raa e mee na Sadyusi raa no nnoho hemuu, tena na tama raa ki oo ake no hakapaa, ");
INSERT INTO nuq_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","tena he tama na tama raa, e meia aia he tama e poroporo na tuaa e haere ake ma ki taaiki Jisas ma te vahiri aia. ");
INSERT INTO nuq_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Tama raa e vahiri ake ma, “Rabai, te tuaa hee e hakanaaniu i roto na tuaa hakaatoa?” ");
INSERT INTO nuq_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Kito Jisas ki meake, “ ‘Laoi TeAriki TeAtua kootou raa ma na hatu manava kootou, na anana kootou ia ma na hakataakoto kootou.’ ");
INSERT INTO nuq_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Teenei ko te tuaa hakamaatua ia e hakanaaniu. ");
INSERT INTO nuq_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Te tuaa e pare ake tera e hakanaaniu hoki raa e mee peenei: ‘Laoi alaa tama pera ma akoe e laoi akoe hokkoe.’ ");
INSERT INTO nuq_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Na tuaa Moses raa hakaatoa ia ma na akoako na profet raa e tuunaki koi i na tuaa e rua nei.” ");
INSERT INTO nuq_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Na Farisi raa ku hakkutu hakaatoa, tena Jisas ki vahiri ake na tama raa ma, ");
INSERT INTO nuq_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Kootou e mannatu peehee i te Mesaia raa? Tama raa he mokopuna aii?” Kito na tama raa ki meake, “Te tama naa he mokopuna Devit.” ");
INSERT INTO nuq_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tena Jisas ki meake, “Aiea kaa TeAnana Tapu raa ni tau i roto Devit, tena tama raa ki kanna te Mesaia raa ma ko ‘TeAriki’ raea? Devit e meake ma, ");
INSERT INTO nuq_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘TeAtua e meake i TeAriki Anau raa ma: Noho i te vahi laaua Anau nei, ki tae roo te saaita Anau e tuku na tama e kiri lloto Akoe raa i raro na tapuvae Akoe raa.’ ");
INSERT INTO nuq_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tena kame Devit e kanna Te Mesaia raa ma, ‘TeAriki’, kaa te Mesaia raa e lavaa peehee te mee pera ma he mokopuna Devit?” ");
INSERT INTO nuq_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ia se hai tama na tama raa e lavaa te sui muri ake te vahiri Jisas raa, tena kaamata te aho naa, se hai tama hoki e haere ake ma ki vahiri ake Jisas he vahiri. ");
INSERT INTO nuq_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tena Jisas ki tattara ake te kanohenua raa ia ma na disaipol Aia raa ma, ");
INSERT INTO nuq_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Na tama e poroporo na tuaa ia ma na Farisi raa ko na tama e ttonu te tattara atu na tuaa Moses raa. ");
INSERT INTO nuq_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kootou ki hakallono no tauttari na mee hakaatoa na tama naa e tattara atu kootou ki ppena raa, e meia auu se tauttari na tiputipu na tama naa, maitaname na tama naa se tauttari na tattara laatou e tattara atu raa. ");
INSERT INTO nuq_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Na tama naa e hakatau atu na mee roo e mmaha, ia e hainattaa te amo raa i aruna kootou, e meia laatou se lavaa roo te kkira atu no tokonaki kootou ki amo na mee e mmaha raa. ");
INSERT INTO nuq_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Na tama naa e ppena na mee ma ki kkite na tama hakaatoa na mee laatou e ppena raa. Kira ake na mee e mmau na tattara te Launiu Tapu tera laatou e nnoa na marae ia ma na rima laatou raa, ia kira ake hoki te lloa na maea e nnoa na hekau laatou raa. ");
INSERT INTO nuq_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Na tama naa e hihhai ki nnoho i na kina na tama hakamattua e nohonoho i na kina na kai e llahi ia ma na kina e hakananniu i roto na hare lotu na Jiu raa; ");
INSERT INTO nuq_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","tena na Farisi raa hoki e hihhai ma na tama ki hakammaha laatou i na kina na maket, tena na tama naa hoki e hihhai ma na tama ki kakanna laatou ma, ‘Rabai’ ");
INSERT INTO nuq_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kootou se lavaa te kanna ria ma, ‘Ni Rabai’, maitaname kootou hakaatoa ni hai taina koi, tena kootou e isi te Rabai hokotahi koi. ");
INSERT INTO nuq_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tena kootou se lavaa te kanna he tama na tama te maarama nei ma, ‘Tamana’, maitaname kootou e isi te Tamana hokotahi i te vaelani. ");
INSERT INTO nuq_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tena kootou se lavaa te kanna ria ma, ‘ni Tama hakamattua’, maitaname te tama hokotahi e hakamaatua kootou raa ko te Mesaia. ");
INSERT INTO nuq_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Te tama hakanaaniu kootou raa ko te tama e hehekau ma kootou raa. ");
INSERT INTO nuq_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Te tama e mee aia hokoia ki hakanaaniu raa e me ki tuku ria ki mouraro roo, tena te tama e mee aia hokoia ki mouraro raa e me ki ssau ria no hakanaaniu. ");
INSERT INTO nuq_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ia e me ki haeo roo ma kootou na tama poroporo na tuaa ia ma na Farisi raa! Kootou ni tama tattara uhiuhi! Kootou e ppui te totoka te Hakamaatua ana i te Vaelani raa i na tama te maarama nei raa, e meia kootou hokkootou se lavaa te ttae i te kina raa, tena kootou e ppui hoki na tama e hahaivi ma ki ttae i te kina raa! ");
INSERT INTO nuq_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Kootou na tama poroporo na tuaa ia ma na Farisi raa e me ki hakalono llihu haeo roo! Kootou ni tama tattara uhiuhi! Kootou e hai lavvaka no kailallao na hekau na hhine ku se hai avana raa, tena ki hakatannata hoki ma kootou e too na lotu lolloa! Kootou e me ki hakalono llihu haeo roo e mee na tiputipu sakkino kootou nei! ");
INSERT INTO nuq_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kootou na tama poroporo na tuaa ia ma na Farisi raa e me ki haeo roo! Kootou ni tama tattara uhiuhi! Kootou e huro vaa roto te moana, tena ki oo vaa roto na henua hakaatoa ma ki sesee ni tama ki tauttari kootou, e meia te saaita kootou ku llave na tama, tena kootou ku mee roo na tama naa ki haeo ki oo no ttae i te kina te ahi raa peenaa ma kootou naa hoki! ");
INSERT INTO nuq_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kootou ni tama karemata sseni e hakattaki na kanohenua, kootou e me ki hakalono llihu haeo roo! Kootou e akoako ma, ‘Kame he tama e ttapa te Hare Tapu raa ma ki hakamaoni na tattara aia raa, tena te tama naa e lavaa koi te seu te tattara aia raa; e meia kame he tama e ttapa na gol i roto te Hare Tapu raa ma ki hakamaoni na tattara aia raa, tena te tattara naa ku hakamaoni roo.’ ");
INSERT INTO nuq_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","“Kootou ni vvare e karemata sseni! Koai te mee e hakanaaniu, na gol ma ko te Hare Tapu e mee na gol raa ki ttapu raa? ");
INSERT INTO nuq_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kootou e akoako hoki ma, ‘Kame he tama e ttapa te olta raa ma ki hakamaoni na tattara aia raa, tena te tattara naa e lavaa koi te seu ria, e meia kame aia e ttapa na hoki i aruna te olta raa ma ki hakamaoni na tattara aia raa, tena te tattara naa ku hakamaoni roo.’ ");
INSERT INTO nuq_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Na karemata kootou naa e sseni roo! Koai te mee e hakanaaniu, na hoki raa ma ko te olta e mee na hoki raa ki ttapu raa? ");
INSERT INTO nuq_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ia tena kame he tama e ttapa te olta raa ma ki hakamaoni na tattara aia raa, te tama naa e ttapa te olta raa ia ma na hoki e ppiri i aruna raa, ");
INSERT INTO nuq_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","tena kame aia e ttapa te Hare Tapu raa, tena te tama naa e ttapa te Hare Tapu raa ia ma TeAtua te Tama e noho i te kina raa; ");
INSERT INTO nuq_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","tena kame he tama e ttapa te vaelani raa ma ki hakamaoni na tattara aia raa, tena te tama naa e ttapa te Nohorana TeAtua raa ia ma te Tama e noho i aruna raa. ");
INSERT INTO nuq_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kootou na tama poroporo na tuaa ia ma na Farisi raa e me ki haeo roo! Kootou ni tama tattara uhiuhi! Kootou e hoki ake TeAtua te hakasehui na laumea ia ma na laakau e mannoni na tama e hilo ma na kai teeraa e kanna ria ma ni mint, ni dil ia ma na kumin raa, e meia kootou se hihhai ki tauttari na akoako hakamaoni na tuaa raa pera ma ki nnoho taualleka, ki manava alloha, tena ki tattara te hakamaoni. Aanei na tuaa kootou e tau te tauttari, tena kootou ki se tiaki alaa tuaa. ");
INSERT INTO nuq_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kootou ni tama karemata sseni! Kootou e kkope na rano i roto na vai kootou e unu raa, e meia kootou se illoa ma kootou e hhoro na kamel! ");
INSERT INTO nuq_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kootou na tama poroporo na tuaa ia ma na Farisi raa e me ki haeo roo! Kootou ni tama tattara uhiuhi! Kootou e ssoro koi te vahi i aho na parete ia ma na kapu kootou raa, e meia i roto na parete ia ma na kapu raa e kkapi roo na mee sakkino pera ma na tiputipu sakkino kootou raa. ");
INSERT INTO nuq_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Na Farisi karemata sseni! Kootou ki ssoro i roto na parete ia ma na kapu raa ki matahua i mua, tena kootou ku ssoro hoki i aho raa ki matahua! ");
INSERT INTO nuq_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kootou na tama poroporo na tuaa ia ma na Farisi raa e me ki haeo roo! Kootou ni tama tattara uhiuhi! Kootou e ssau pera ma na kerekere makkini i aruna na taruma tera e makkini hua roo, e meia i roto te taruma naa e pii roo na ivi ia ma na tama ku ppara. ");
INSERT INTO nuq_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tena kootou e ssau peeraa hoki, na tinotama kootou i aho raa e tiputipu laoi i na karemata na tama, e meia i roto kootou raa e pii roo na tiputipu sakkino ia ma na hai sara. ");
INSERT INTO nuq_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kootou na tama poroporo na tuaa ia ma na Farisi raa e me ki haeo roo! Kootou ni tama tattara uhiuhi! Kootou e ppena hakaraoi roo na taruma na profet raa, tena ki hakalaakei hoki na taruma na tama ni nnoho na ora taualleka raa; ");
INSERT INTO nuq_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","tena kootou e tattara hoki ma: pera ma kootou ki nnoho te saaita na tipuna kootou raa ni nnoho raa, kootou se lavaa te ppena hea na tama raa ni ppena no taa na profet raa no mmate. ");
INSERT INTO nuq_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ia tena kootou ku hakari roo pera ma kootou ni mokopuna na tama ni taa na profet raa no mmate raa! ");
INSERT INTO nuq_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ia tena hai na mahi kootou ki hakaoti hea na tipuna kootou raa ni kaamata mai raa! ");
INSERT INTO nuq_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kootou ni lapono, ia ni tamalliki na lapono! Kootou e kkahu ma kootou e lavaa te hakassao i taha ma te kina te ahi? ");
INSERT INTO nuq_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Tena Anau e meatu kootou pera ma Anau e me ki kauna ria atu ni profet, na tama e atamai ia ma na tisa; kootou e me ki taa alaa tama na tama nei no mmate, tena ku ttii alaa tama, tena ku riki alaa tama i roto na hare lotu na Jiu raa, tena ku hakatui alaa tama ki huro i alaa matakaina. ");
INSERT INTO nuq_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ia tena i te hakaotioti kootou e me ki too na hakalono llihu hakaatoa i te mmate na tama e ttonu raa, kaamata mai te mate Abel raa haere no tae te mate Sakaraia te tama Berekia raa; te tama kootou ni taa i lottonu te olta ia ma te Hare Tapu raa. ");
INSERT INTO nuq_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Anau e meatu te hakamaoni: na hakalono llihu te mmate na tama nei raa e me ki mmoe i roto na tama te aho nei raa! ");
INSERT INTO nuq_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem, Jerusalem! Kootou e taa na profet, tena ki maka na tama e kavekave na tattara tera TeAtua ni kauna ria atu raa! E hia roo na vahao Anau e maanatu ma ki hakkutu mai kootou hakaatoa ma na rima Anau pera ma he manu hine e hakkutu ake na pupunua aia raa, e meia kootou se hihhai ma Anau ki hakkutu mai kootou! ");
INSERT INTO nuq_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ia tena te Hare Tapu kootou naa e me ki tuu vare roo se hai tama. ");
INSERT INTO nuq_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Anau e meatu kootou; kaamata te saaita nei kootou se lavaa hoki te kkite Anau ki tae roo te saaita kootou ku tattara ma, ‘TeAtua e hakatapu te Tama e hamai i te inoa TeAriki raa.’ ” ");
INSERT INTO nuq_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas ku huri no haere i taha ma te Hare Tapu raa, tena na disaipol Aia raa ku oo ake no meake Aia ki kkira ake i na hare te Hare Tapu raa. ");
INSERT INTO nuq_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tena Jisas ki meake, “Hakamaoni, kootou e me ki kkite na mee nei hakaatoa. Tena Anau e me ki meatu he mee hokotahi. Se isi te hatu hokotahi i na hatu e mmau te Hare Tapu naa e me ki mmau tahi roo i te kina aia e mmau raa; na hatu hakaatoa e me ki hhopo no maoha i raro.” ");
INSERT INTO nuq_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas e noho i aruna te Mouna e hhomo na Oliv raa, tena na disaipol raa ki oo ake hokolaatou no mmata Tama raa. Kito na tama raa ki meake, “Hakari mai maatou te saaita na mee nei e me ki kapihi mai, ia hea e me ki kapihi mai ki huri mai maatou te saaita Akoe e me ki hamai ia ma te saaita na mee hakaatoa e me ki oti raa.” ");
INSERT INTO nuq_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tena Jisas ki meake, “Kootou ki tanattana tahi, ia auu se tiaki alaa tama ki malliu atu kootou. ");
INSERT INTO nuq_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tammaki na tama e mee ma laatou e tattara i te vahi Anau e me ki oo atu no tattara atu ma, ‘Anau ko te Mesaia!’ Tena laatou e me ki malliu ake tammaki roo na tama. ");
INSERT INTO nuq_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kootou e me ki llono na kapipihi na taua e ttani tappiri atu ia ma na rono na henua e ppuhu, e meia auu se mamannatu tammaki. Na mee nei e me ki kapihi atu, e meia se mee ma teenaa te hakaoti naa ku tae atu. ");
INSERT INTO nuq_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Na henua e me ki ppuhu hokolaatou, na tuku e me ki ppuhu hokolaatou. Tena e me ki isi te saaita te hikkai ia ma na ruru henua na kina hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Na mee nei hakaatoa e ssau pera ma na isu kaamata te hine ku mee ki mamaoha raa. ");
INSERT INTO nuq_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kootou e me ki hakapiki ria no kou ake na tama ki kou atu na hakalono llihu kootou, tena ku taa kootou ki mmate. Na kanohenua hakaatoa e me ki se hihhai kootou e mee kootou e tauttari Anau. ");
INSERT INTO nuq_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tammaki na tama e me ki tiaki na hakattina laatou raa te saaita naa; na tama naa e me ki tattara haeo teeraa tama ma teeraa tama, tena e me ki se hihhai hokolaatou. ");
INSERT INTO nuq_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ia tammaki na profet malliu e me ki oo atu no tattara malliu ake tammaki na tama. ");
INSERT INTO nuq_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tammaki na tama e me ki tauhano te ppena na mee sakkino, tena laatou e me ki tiaki na laoi laatou ni isi i mua raa. ");
INSERT INTO nuq_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Emeia na tama e ttuu mmau no ttae te hakaoti raa e me ki ora. ");
INSERT INTO nuq_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tena te Rono Tauareka i te vahi te Hakamaatua ana i te Vaelani raa e me ki takutaku ria ki llono na tama na henua hakaatoa i te maarama nei raa, tena ki oti te hakaotioti te maarama nei raa ku tae atu. ");
INSERT INTO nuq_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Kootou e me ki kkite te mee sakkino roo tera profet Daniel ni tattara raa. Te mee naa e me ki tuu i te kina e tapu kkini i roto te Hare Tapu raa.” (Te tama e ppau na tattara nei raa ki iroa te hakataakoto na tattara nei!) ");
INSERT INTO nuq_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Tena na tama i roto Judia raa ku huro i te kina na mouna raa no mmuni. ");
INSERT INTO nuq_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Te tama i aruna te tauhuhu te hare aia raa se lavaa te tiho i raro ma ki too hea aia e ttino raa. ");
INSERT INTO nuq_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ia te tama i roto te paupaku aia raa se lavaa te vaakai i hare ma ki too te kkahu rima lloa aia raa. ");
INSERT INTO nuq_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Te aho naa e me ki haeo roo ma na hhine hai ttama ia ma na hhine na tamalliki laatou raa koi pammee raa. ");
INSERT INTO nuq_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Lotu ake TeAtua ki se lavaa kootou te huro i taha te saaita te matani ia ma te saaita te Sabat! ");
INSERT INTO nuq_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Maitaname na hakalono llihu te saaita naa e me ki haeo roo i aruna na hakalono llihu tera ni hhura mai i te kaamata roo te maarama nei ni tipu ake haere no tae mai te aho nei. Tena se lavaa hoki ni hakalono llihu peenei e me ki hura atu hoki i muri. ");
INSERT INTO nuq_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Emeia TeAtua ku oti te ttuu te kooina na aho raa no moisi; peeraa TeAtua ki se ttuu na aho raa no moisi, se hai tama e me ki ora. TeAtua e ttuu na aho raa no moisi e mee na tama Aia ni hirihiri raa. ");
INSERT INTO nuq_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Tena kame he tama e meatu akoe ma, ‘Kira ake, teenei te Mesaia nei!’ ia ma ku meatu ma, ‘Teeraa Aia raa!’, kootou se lavaa te hakattina na tattara naa. ");
INSERT INTO nuq_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Maitaname na mesaia malliu ia ma na profet malliu raa e me ki ttae atu; na tama naa e me ki huri atu na mirakol ia ma na hakkatu e llahi ma ki lavaa laatou te malliu ake hoki na tama TeAtua ni hirihiri raa, kame laatou e lavaa. ");
INSERT INTO nuq_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Hakallono! Anau ku oti te tattara atu na mee nei i mua te aho naa e tae atu. ");
INSERT INTO nuq_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Tena kame ni tama e meatu ma, ‘Teeraa te Tama raa i te kina e tuu mahoa raa!’ Tena kootou ki se vvare no oo i te kina naa, tena kame laatou e meatu ma, ‘Teeraa te Tama raa e mmuni i te kina raa!’ Tena kootou se lavaa te hakattina na tattara na tama naa. ");
INSERT INTO nuq_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Maitaname te Tamariki te Tama nei e me ki hamai pera ma he uila no hakamaahina i te vaelani raa, kaamata te anake haere no tae te laki. ");
INSERT INTO nuq_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“He kina peehee e moe te mee e mate, na manu lellee kai ttama raa e me ki muimui i te kina naa. ");
INSERT INTO nuq_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“I muri na hakalono llihu na aho naa, te laa raa e me ki pouri, tena te maremo raa e me ki se lavaa hoki te maahina, na hetuu raa e me ki maoha i taha ma te vaelani, tena na mahi i te vaelani raa ku se lavaa te oo tonu na ara laatou e hahaere raa. ");
INSERT INTO nuq_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tena na hakkatu te Tamariki te Tama nei e me ki hura ake i te vaelani, tena na tama hakaatoa i roto te maarama nei raa e me ki tanittani te saaita laatou e kkite te Tamariki te Tama nei, e hamai i roto na pukureurehu i te vaelani raa ma na mahi hai mmahi. ");
INSERT INTO nuq_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Te puu hakanaaniu raa e me ki tani, tena te Tama raa e me ki kauna ria iho na ensel Aia raa ki oo i na kina hakaatoa i te maarama nei raa no hakkutu ake na tama roo hakaatoa Aia ni hirihiri raa. ");
INSERT INTO nuq_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Te laakau fik raa e me ki poroporo atu kootou na hakataakoto. Te saaita na raraa raa e hhomo, tena na laumea raa ku mahaa ake, tena kootou e me ki illoa pera ma te saaita na reurehu raa ku tappiri ki ttae mai. ");
INSERT INTO nuq_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ia e ssau pera hoki, te saaita kootou e kkite na mee nei hakaatoa raa, kootou e me ki illoa pera ma te saaita te Tama raa e me ki hamai raa ku taapiri, ia Aia ku tanattana ki hamai. ");
INSERT INTO nuq_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mannatu pera ma na mee nei hakaatoa e me ki kapihi atu i mua na tama e nnoho te saaita nei raa e mmate hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Te vaelani ma te maarama nei e me ki oti, e meia na tattara Anau raa e me ki mmoe tahi se lavaa roo te oti. ");
INSERT INTO nuq_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Se hai tama e iroa te aho hee roo ia ma te saaita hee roo te aho naa e me ki tae mai, niaina na ensel i te vaelani, ia te Tamariki te Tama nei hoki se iroa; te Tamana Hokoia koi e iroa. ");
INSERT INTO nuq_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Te hamai te Tamariki te Tama nei e me ki ssau pera ma hea ni kapihi ake te saaita Noa raa. ");
INSERT INTO nuq_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Na aho i mua te tai uu raa, na tama raa e kkai, ia e unu, tena na hhine ia ma na taanata raa e avavvana haere no tae roo te saaita Noa ku haere i roto te vakatua aia raa, ");
INSERT INTO nuq_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","e meia na tama raa se illoa hea e me ki kapihi ake haere no tae roo te saaita laatou ku loohia te tai uu raa. Te aho te Tamariki te Tama nei e hamai raa e me ki ssau pera ma te saaita naa. ");
INSERT INTO nuq_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Te saaita naa tokorua na taanata e me ki uata i roto te paupaku hokotahi, teeraa tama e me ki too ria i taha, tena teeraa tama e me ki tiaki ria. ");
INSERT INTO nuq_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tokorua na hhine e me ki tukituki na kai, teeraa tama e me ki too ria i taha, tena teeraa tama e me ki tiaki ria. ");
INSERT INTO nuq_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Kootou ki tanattana tahi, maitaname kootou se illoa te aho hee roo TeAriki e me ki hamai. ");
INSERT INTO nuq_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kame te tama te hare raa e iroa te saaita te tama kairarao raa e me ki haere ake, kootou e illoa pera ma te tama naa se lavaa te moe ki se lavaa te tama kairarao raa te haere ake no ssaa te haere aia raa. ");
INSERT INTO nuq_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","“Ia tena kootou ki tanattana tahi, maitaname te Tamariki te Tama nei e me ki hamai te saaita kootou e nnoho taravare ma Aia ku se hamai raa. ");
INSERT INTO nuq_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Kaa koai te tama e hakamaoni i na hehekau aia, ia e atamai naa? Teenaa ko te tama tera te tama hakamaatua raa e tuku aia ki hakamaatua i aruna alaa tama hehekau raa, tena ku vaevae ake na kai na tama raa na saaita laatou e kkai raa. ");
INSERT INTO nuq_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Te tama hehekau naa e me ki hihia roo kame te tama hakamaatua aia raa e hamai no kite aia e ppena na mee raa. ");
INSERT INTO nuq_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Anau e meatu kootou te hakamaoni pera ma te tama hakamaatua naa e me ki tuku te tama naa ki mmata na hekau aia raa hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Emeia kame aia he tama hehekau haeo, aia e me ki tattara hokoia ma, ‘Te tama hakamaatua anau raa e me ki se lavaa te hamai saaita roroa roo.’ ");
INSERT INTO nuq_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Tena aia ku kaamata no riki alaa tama e hehekau ma aia raa, tena ku haere no kai, ia no unu ma na tama e unu mahi raa. ");
INSERT INTO nuq_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tena te tama hakamaatua te tama hehekau naa e me ki hamai te saaita te tama hehekau naa se tanattana, ia se iroa te saaita te tama raa e me ki hamai raa. ");
INSERT INTO nuq_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Te tama hakamaatua naa e me ki tuutuu maruu te tama hehekau naa ki hakalono llihu pera ma alaa tama e tattara uhiuhi raa hoki. Na tama naa e me ki ttani no hakatikkati na niho laatou. ");
INSERT INTO nuq_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Te saaita naa te Hakamaatua ana i te Vaelani raa e me ki ssau pera ma te sanahuru na taukupu e too na lamu laatou raa ma ki oo no ttiri ma te taupeara ku mee ki avana raa. ");
INSERT INTO nuq_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tena he tokorima na taukupu e panimu, tena teeraa tokorima na taukupu e atamai. ");
INSERT INTO nuq_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Te tokorima na taukupu e panimu raa e too koi na lamu laatou raa, tena se hai karaseni hoki e too ma na lamu raa, ");
INSERT INTO nuq_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","tena te tokorima na taukupu e atamai raa e too na lamu laatou raa, tena ki utu hoki na karaseni na lamu raa. ");
INSERT INTO nuq_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Te taupeara e me ki avana raa e nnahe roo te hamai, tena na taukupu raa ku tutturi moe no mmoe heilloa roo. ");
INSERT INTO nuq_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Te mee raa ku raka te tuapoo, tena laatou ku llono te tama e kanna ma, ‘Teenei te taupeara ku mee ki avana nei ku hamai! Oo mai no tanattana ki hamai aia!’ ");
INSERT INTO nuq_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tena te sanahuru na taukupu raa ku mahhuru no mmiri ake na lamu laatou raa i aruna. ");
INSERT INTO nuq_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tena te tokorima na taukupu e panimu raa ku meake teeraa tokorima na taukupu ma, ‘Utu mai ni karaseni ma na lamu maatou nei, na lamu nei ku mmaha.’ ");
INSERT INTO nuq_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tena na taukupu e atamai raa ki meake, ‘Maatou se lavaa te utu atu e mee na karaseni nei se llava te vvae ma taatou. Oo no sui ni karaseni ma kootou te stoa.’ ");
INSERT INTO nuq_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kito te tokorima na taukupu e panimu raa ki oo no sui na karaseni laatou raa, ia te saaita na taukupu e panimu raa ni oo, te taupeara ku mee ki avana raa hoki ku tae ake. Te tokorima na taukupu e tanattana raa ku oo ma te taupeara raa i te kina te kai raa, tena na tama raa ki ppui te totoka. ");
INSERT INTO nuq_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Tena ki oti roo teeraa tokorima na taukupu ku ttae ake, tena ki kakanna ake ma, ‘TeAriki, TeAriki! Taaraki te totoka raa ki oo atu maatou i hare.’ ");
INSERT INTO nuq_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tena te taupeara raa ki meake, ‘Anau se lavaa te taaraki te totoka raa! Anau se iroa kootou.’ ” ");
INSERT INTO nuq_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tena Jisas ki meake, “Kootou ki tanattana, maitaname kootou se illoa te aho ia ma te saaita hee roo te Tamariki te Tama nei e me ki hamai. ");
INSERT INTO nuq_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Te saaita naa te Hakamaatua ana i te Vaelani raa e me ki tipu peenei. Teeraa he tama e tanattana ki horau, tena aia ki kanna ake na tama hehekau aia raa, tena ki meake na tama raa ki lollohi na hekau aia raa. ");
INSERT INTO nuq_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tama raa e kou ake na sileni na tama raa tautari te iroa te tama raa. Te tama hokotahi aia e kou ake rima simata na sileni, teeraa tama aia e kou ake rua simata, tena teeraa tama aia e kou ake te simata hokotahi. Tena aia ki tiaki na tama raa no horau. ");
INSERT INTO nuq_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Te tama hehekau ni too rima simata na sileni raa ku haere no hehekau no too hoki teeraa rima simata na sileni. ");
INSERT INTO nuq_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ia e ssau hoki ma te tama ni too rua simata na sileni raa. Tama raa e haere no hehekau ma na sileni raa no too teeraa rua simata na sileni hoki. ");
INSERT INTO nuq_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Emeia te tama hakatoru ni too te simata hokotahi raa ku haere no keri te rua raa, tena ki tanu na sileni te tama hakamaatua aia raa ni kou ake raa. ");
INSERT INTO nuq_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Te saaita te tama hakamaatua raa ni haere raa ku roroa roo, tena ki oti aia ku vaakai mai ma ki hakatonu ma na tama hehekau aia raa i te vahi na sileni aia ni kou ake raa. ");
INSERT INTO nuq_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Te tama hehekau ni too rima simata na sileni raa ku haere ake no kou ake te rima simata na sileni raa, tena ki meake, ‘Tama hakamaatua, akoe ni kou mai rima simata na sileni, ia teenei teeraa rima simata anau ni hehekau ma na sileni nei no too!’ ");
INSERT INTO nuq_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Tena te tama hakamaatua raa ki meake, ‘Tauareka roo, akoe he tama hakamaoni te hehekau! Akoe e huri mai ma akoe he tama hehekau tauareka hakamaoni te rorohi na sileni moisi, tena anau e me ki tuku akoe ki rorohi na sileni tammaki. Hamai i hare ki hihhia taaua hakaatoa!’ ");
INSERT INTO nuq_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Tena te tama hehekau ni too rua simata na sileni raa ku haere ake i hare, tena ki meake, ‘Tama hakamaatua, akoe e kou mai rua simata na sileni, tena teenei teeraa rua simata na sileni anau ni hehekau ma na sileni nei no too raa.’ ");
INSERT INTO nuq_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘Tauareka roo, akoe he tama hakamaoni te hehekau! Akoe e huri mai ma akoe he tama hakamaoni te rorohi na sileni moisi, tena anau e me ki tuku akoe ki rorohi tammaki na sileni. Hamai i hare ki hihhia taaua hakaatoa!’ ");
INSERT INTO nuq_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Tena te tama hehekau ni too te simata hokotahi raa ku haere ake i hare, tena ki meake, ‘Tama hakamaatua, anau e iroa pera ma na tama e mattaku akoe; akoe haere haki, tena ki kkope na kai na kina alaa tama e ttori raa. ");
INSERT INTO nuq_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Anau e mataku akoe, tena anau ki haere no tanu na sileni akoe raa i te kerekere. Kira ake aanei na sileni akoe nei hakaatoa roo.’ ");
INSERT INTO nuq_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Tena te tama hakamaatua raa ki meake, ‘Akoe he tama hehekau sakkino, ia e matanaenae. Akoe e iroa pera ma anau he tama haere haki, tena ki kkope na kai na kina alaa tama e ttori raa kaa seai? ");
INSERT INTO nuq_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tena akoe e tau roo te ppono na sileni anau nei i roto te benk, tena anau e me ki too na sileni nei hakapaa ma na sileni laatou e me ki hakapiri ake i aruna te saaita anau e vaakai mai raa.’ ");
INSERT INTO nuq_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Tena te tama hakamaatua raa ki meake na tama e ttuu i te kina raa, ‘Too na sileni raa i taha ma te tama naa no kou ake te tama e isi sanahuru na simata na sileni raa. ");
INSERT INTO nuq_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Niaina ma akoe e isi tammaki na mee, e meia akoe e me ki isi tammaki hoki alaa mee e me ki ttoe, tena te tama se isi na mee raa, niaina ma na mee raa e moisi, na mee raa e me ki too ria i taha ma aia. ");
INSERT INTO nuq_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Tena kootou ki lletu te tama hehekau sakkino nei i aho i te kina e pouri raa, tena aia e me ki tani no hakatikkati na niho aia raa.’ ");
INSERT INTO nuq_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Te saaita te Tamariki te Tama nei e hamai pera ma he Tuku ma na ensel Aia raa, te Tama raa e me ki noho i aruna te Nohorana hakanaaniu Aia raa, ");
INSERT INTO nuq_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","tena na tama na henua hakaatoa e me ki kkutu i mua Tama raa. Tena te Tama raa e me ki vvae na tama raa i na kuturana e rua e ssau pera ma te tama rorohi na manu raa e vvae na sipsip raa i taha ma na gout. ");
INSERT INTO nuq_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tama raa e me ki tuku na tama e ttonu raa i te vahi laaua Aia, tena na tama sakkino raa i te vahi se laaua Aia. ");
INSERT INTO nuq_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Tena te Tuku raa e me ki meake na tama i te vahi laaua Aia raa ma, ‘Oo mai, kootou ko na tama e hakatapu ria te Tamana Anau raa! Oo mai no ttino te Hakamaatua ana i te Vaelani tera ku oti te tanattana ma kootou te saaita roo te maarama nei ni tipu ake raa. ");
INSERT INTO nuq_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Anau e hikai, tena kootou e haanai Anau, Anau e hiunu, tena kootou e kou mai na vai no unu Anau; Anau he manu siri, tena kootou e too hakaraoi Anau i na hare kootou raa; ");
INSERT INTO nuq_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Anau se hai hekau, tena kootou e kou mai na hekau Anau; Anau e laavea, tena kootou e lollohi hakaraoi Anau, Anau e karapusi ria, tena kootou e oo mai no matamata Anau.’ ");
INSERT INTO nuq_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Tena na tama e tonu tahi raa e me ki meake ma, ‘TeAriki, te saaita hee maatou ni kkite ma Akoe ni hikai, tena maatou ki haanai Akoe, ia te saaita hee Akoe ni hiunu, tena maatou ki kou atu na vai no unu Akoe? ");
INSERT INTO nuq_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Te saaita hee maatou ni kkite ma Akoe he manu siri, tena maatou ki too hakaraoi Akoe i na hare maatou raa, ia te saaita hee Akoe se hai hekau, tena maatou ki kou atu na hekau Akoe? ");
INSERT INTO nuq_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Te saaita hee maatou ni kkite ma Akoe e laavea, ia ni ponotia i te hare karapusi, tena maatou ki oo atu no mmata Akoe?’ ");
INSERT INTO nuq_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tena te Tuku raa e me ki meake, ‘Anau e meatu kootou, he saaita peehee kootou e ppena hakatauareka i na tama Anau tera e mouraro raa, kootou e ppena te tauareka naa i Anau!’ ");
INSERT INTO nuq_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Tena ki oti Aia ki meake na tama i te vahi se laaua Aia raa, ‘Oo i taha ma Anau, kootou ko na tama e nnoho i raro na haeo TeAtua! Oo i te kina te ahi e ura tahi tera e tanattana ma Satan ia ma na ensel aia raa! ");
INSERT INTO nuq_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Anau e hikai, e meia kootou se haanai Anau, Anau e hiunu, e meia kootou se hai vai e kou mai no unu Anau; ");
INSERT INTO nuq_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Anau he manu siri, e meia kootou se too hakaraoi Anau i na hare kootou raa, tena Anau ni se hai hekau, e meia kootou se hai hekau ni kou mai Anau. Anau e laavea, ia e moe i te hare karapusi, e meia kootou se oo mai no lollohi Anau.’ ");
INSERT INTO nuq_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Tena na tama sakkino raa e me ki meake, ‘TeAriki, te saaita hee maatou ni kkite ma Akoe e hikai, ia e hiunu ia ma Akoe he manu siri ia ma Akoe se hai hekau ia ma Akoe e laavea ia ma Akoe e karapusi, tena maatou se oo atu no mmata Akoe?’ ");
INSERT INTO nuq_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Tena te Tuku raa e me ki meake, ‘Anau e meatu kootou, he saaita peehee kootou se hihhai ki tokonaki he tama na tama mouraro Anau raa, tena kootou se hihhai ki tokonaki hoki Anau.’ ");
INSERT INTO nuq_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Na tama sakkino raa e me ki oo i te kina na hakalono llihu se isi te hakaoti raa, tena na tama e ttonu raa e me ki oo i te kina te ora e ora tahi raa.” ");
INSERT INTO nuq_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas e akoako ake na hakataakoto roo hakaatoa no oti, tena Aia ki meake na disaipol Aia raa, ");
INSERT INTO nuq_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kootou e illoa pera ma te Pasova raa e me ki teiho mai te aho hakarua raa, tena te Tamariki te Tama nei e me ki hakapiki ria no kou ake na tama e kiri lloto Aia raa ki ttii i aruna te kros.” ");
INSERT INTO nuq_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tena na maatua hakananniu raa laatou ma na tama hakamattua raa ki oo no kkutu hakaatoa i te hare tuku Kaiafas te pohouru hakanaaniu na maatua raa ");
INSERT INTO nuq_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","no tattara ma ki hakapiki hemuu Jisas, tena ku taa Tama raa ki mate. ");
INSERT INTO nuq_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Na tama raa e tattara ma, “Taatou se lavaa te ppena te hakataakoto taatou nei te saaita te Pasova raa, ka oti te kanohenua raa ku hakatauttau ma taatou.” ");
INSERT INTO nuq_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas e noho i Betani i te hare Saimon, te tama te tinotama aia raa ni kaina te manumanu haeo raa. ");
INSERT INTO nuq_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jisas koi noho koi no kai, tena he hine e haere ake iaa Jisas ma te lloo manoni e sui mmaha roo no nnini i aruna te pohouru Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Na disaipol raa ku lloto roo te saaita laatou ni kkite te hine raa e nnini te lloo manoni raa i aruna te pohouru Jisas raa, tena laatou ki meake, “Aiea te lloo naa ku ninnini puamu naea? ");
INSERT INTO nuq_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Te lloo nei e tau roo te kou ake alaa tama ki sui tammaki na sileni, tena taatou ku too na sileni raa no kou ake i na tama hakaalloha raa!” ");
INSERT INTO nuq_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisas e iroa hea na disaipol raa e tattara raa, kito Aia ki vahiri ake na tama raa, “Aiea kootou e tattara i te hine nei naea? Hea te hine nei e ppena i Anau raa he mee roo e tauareka. ");
INSERT INTO nuq_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Na tama hakaalloha raa e me ki nnoho tahi ma kootou, e meia Anau se lavaa te noho tahi ma kootou. ");
INSERT INTO nuq_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Hea te hine nei e ppena raa, aia e nnini te lloo manoni raa i aruna te tinotama Anau ki tanattana te saaita Anau e me ki tanu ria raa. ");
INSERT INTO nuq_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tena Anau e meatu kootou te hakamaoni pera ma he kina peehee i roto te maarama nei na tama e takutaku te Rono Tauareka nei, na tama e me ki mannatu te hine nei i te mee aia e ppena nei.” ");
INSERT INTO nuq_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tena Judas Iskariot, he tama i roto te sanahuru ma rua na disaipol raa ku haere no mmata na maatua hakananniu raa, ");
INSERT INTO nuq_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","tena ki vahiri ake, “Hea kootou e me ki kou mai anau kame anau e hakari atu Jisas i kootou?” Na maatua hakananniu raa ku ppau ake tipu toru na sileni no kou ake iaa Judas. ");
INSERT INTO nuq_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tena kaamata te saaita naa Judas ku kirakira he saaita e tauareka aia ki hakari ake Jisas i na tama hakamattua raa. ");
INSERT INTO nuq_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Te aho kaamata te Kai te Haraoa Mannihi raa, na disaipol raa ku oo ake iaa Jisas raa no vahiri ake Tama raa ma, “I te kina hee Akoe e hihai ma maatou ki oo no tanattana te Kai te Pasova raa ma Akoe?” ");
INSERT INTO nuq_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kito Jisas ki meake, “Oo i te tama hokotahi i roto te matakaina raa no meake ma, ‘Te Rabai raa e tattara ma te saaita Aia raa ku ttae mai, tena Aia ma na disaipol Aia raa e me ki kkai te Kai te Pasova raa i te hare akoe.’ ” ");
INSERT INTO nuq_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Na disaipol raa e oo no ppena hea Jisas ni tattara ake laatou raa, tena laatou ki tanattana mai te Kai te Pasova raa. ");
INSERT INTO nuq_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jisas ma te sanahuru ma rua na disaipol Aia raa ku nnoho ma ki kkai te saaita te mee raa ku hiahi. ");
INSERT INTO nuq_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Laatou koi nnoho koi no kkai, tena Jisas ki meake, “Anau e meatu kootou, he tama kootou e me ki hakari ake Anau i na tama e kiri lloto Anau raa.” ");
INSERT INTO nuq_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Na disaipol raa ku se hihhai roo, tena laatou ku kaamata no vahihhiri ake Jisas tama taki ttahi ma, “TeAriki, Akoe ma e tattara koi anau.” ");
INSERT INTO nuq_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kito Jisas ki meake, “Te tama e ttoki te haraoa aia raa i roto te parete Anau e ttoki te haraoa raa ko te tama e me ki hakari ake Anau i na tama haeo raa. ");
INSERT INTO nuq_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Te Tamariki te Tama nei e me ki mate pera ma te Launiu Tapu raa e tattara, e meia te tama e hakari ake te Tamariki te Tama nei raa e me ki haeo roo! E tauareka roo kame te tama naa ni se haanau iho i te maarama nei!” ");
INSERT INTO nuq_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tena Judas te tama sakkino raa ku meake, “Rabai, Akoe ma e tattara koi anau.” Kito Jisas ki meake, “Teenaa koi akoe ku mee mai naa.” ");
INSERT INTO nuq_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Te saaita laatou koi kkai, Jisas ku too te muri haraoa raa no lotu ake TeAtua, tena ki ttohi te haraoa raa no vaevae ake i na disaipol Aia raa, tena ki meake, “Too no kkai, teenei ko te tinotama Anau.” ");
INSERT INTO nuq_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tena Jisas ki too te kapu raa no lotu ake TeAtua, tena ki kou ake na disaipol Aia raa, tena ki meake, “Kootou hakaatoa ki unu; ");
INSERT INTO nuq_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","teenei ko te toto Anau tera e huri atu te hakamaoni te tattara e ivi TeAtua raa, tena te toto Anau nei e nnini atu ki ssoro na hai sara na kanohenua hakaatoa i taha. ");
INSERT INTO nuq_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Anau e meatu kootou, Anau se lavaa hoki te unu te wain nei ki tae roo te saaita Anau e unu ma kootou te wain hoou raa, i te Hakamaatua ana te Tamana Anau raa.” ");
INSERT INTO nuq_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kito na tama raa ki huhua te rue te lotu raa, tena ki oo peeraa i te Mouna e hhomo na Oliv raa. ");
INSERT INTO nuq_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tena Jisas ki meake na disaipol raa, “Te poo nei kootou hakaatoa e me ki tiaki Anau no huro i taha, maitaname te Launiu Tapu raa e tattara ma, ‘TeAtua e me ki taa te tama e rorohi na manu raa, tena na sipsip raa e me ki maaseu huri.’ ");
INSERT INTO nuq_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Emeia i muri te saaita Anau ku ora muri raa, Anau e me ki haere i Galili i mua kootou.” ");
INSERT INTO nuq_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kito Pita ki tattara ake Jisas ma, “Anau se lavaa roo te tiaki Akoe, niaina ma na tama nei hakaatoa e tiaki Akoe!” ");
INSERT INTO nuq_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tena Jisas ki meake Pita, “Anau e meatu te hakamaoni, i mua te manu tane raa e tani te poo nei, akoe e me ki kore e toru na vahao pera ma akoe se iroa Anau.” ");
INSERT INTO nuq_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Kito Pita ki meake, “Anau se lavaa te ppena peenaa, niaina anau e taia ria no mate ma Akoe!” Tena na disaipol raa hakaatoa ku tattara ake pera ma Pita raa hoki. ");
INSERT INTO nuq_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tena Jisas ki haere ma na disaipol Aia raa i te kina e hui ma ko Getsemani raa, tena Aia ki meake na disaipol raa, “Nnoho i te kina nei ki haere Anau no lotu i te kina raa.” ");
INSERT INTO nuq_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tena Aia ki too Pita ia ma te tokorua na tama Sebedi raa. Jisas ku aroha roo, tena te hakataakoto Aia raa hoki ku sakkino roo, ");
INSERT INTO nuq_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","kito Jisas ki meake na disaipol raa, “Te aroha i roto te hatu manava Anau raa e rahi roo, tena Anau ku taapiri koi ki mate te aroha. Nnoho i te kina nei ki ara taatou.” ");
INSERT INTO nuq_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jisas e haere no mmao hakamarie, tena Aia ki tteiho i raro no tuturi, tena ki lotu ake peenei, “Taku Tamana, kame e hainauhie, Akoe ku too te kapu te hakalono llihu nei i taha ma Anau! Emeia Akoe se tautari hea Anau e hihai, tautari koi hea Akoe e hihai.” ");
INSERT INTO nuq_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tena Aia ki vaakai no kite tokotoru na disaipol raa ku mmoe heilloa roo; kito Jisas ki meake Pita, “Kootou tokotoru se lavaa roo te ara ake he paa saaita ki ara taatou? ");
INSERT INTO nuq_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tauhano te ara tahi, tena ku lotu tahi ki se lavaa kootou te maoha i na hahaaite. Te anana raa e mataora, e meia te tinotama raa e matanaenae.” ");
INSERT INTO nuq_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Tena Jisas ki vaakai hakaraoi hoki no lotu ake peenei, “Taku Tamana, kame Akoe se lavaa te too te kapu te hakalono llihu nei i taha ma Anau, tena tiaki Anau ki hakalono llihu pera ma Akoe e hihai raa.” ");
INSERT INTO nuq_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tena Aia ki vaakai hoki no kite tokotoru na disaipol raa ku mmoe heilloa roo; tokotoru raa ku se lavaa roo te kkira na karemata laatou. ");
INSERT INTO nuq_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tena Jisas ku tiaki na disaipol raa no haere te hakatoru na vahao no lotu ake na lotu Aia ni lotu ake kaamata raa. ");
INSERT INTO nuq_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tena Aia ki vaakai ake i na disaipol raa no meake, “Kootou koi mmoe roo no hamalollo? Kira ake! Te saaita te Tamariki te Tama nei e me ki noho i raro na mahi na tama hai ssara raa ku tae mai. ");
INSERT INTO nuq_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mahhike i aruna ki oo taatou. Kira ake, teenei te tama e me ki hakari ake Anau!” ");
INSERT INTO nuq_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas koi tattara koi te saaita Judas, he tama i roto te sanahuru ma rua na disaipol raa ku tae ake. Judas e haere ake ma te kanohenua e rahi tera na maatua hakananniu ia ma na tama hakamattua raa ni kauna ki oo ake. Na tama raa e oo ake ma na paraamoa ia ma na muri laakau. ");
INSERT INTO nuq_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas te tama sakkino raa ku oti te tattara ake na tama raa ma, “Te tama Anau e mohoni raa ko te tama kootou e hihhai raa, tena kootou ku hakapiki Tama naa!” ");
INSERT INTO nuq_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas e haere tahi atu roo iaa Jisas raa no meake ma, “Rabai, te tauareka ki noho ma Akoe,” tena aia ki mohoni Jisas. ");
INSERT INTO nuq_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kito Jisas ki meake, “Taku soa, akoe ki vave!” Kito na tama raa ki oo ake no hakapiki Jisas, tena ki ttaohi mmau roo Tama raa ");
INSERT INTO nuq_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tena he tama hokotahi e tuu ma Jisas ku ssau te paraamoa aia raa no ssepe te katarina te tama hehekau te pohouru hakanaaniu na maatua raa no hopo. ");
INSERT INTO nuq_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tena Jisas ki meake te tama raa, “Tuku te paraamoa naa i te kina akoe ni too raa. Na tama hakaatoa e ppuhu ma na paraamoa raa e me ki mmate i na paraamoa. ");
INSERT INTO nuq_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kootou se illoa pera ma Anau e lavaa te kanna ake te Tamana Anau raa ki tokonaki, tena te Tamana Anau raa e lavaa te kou mai sanahuru ma rua na kuturana na ensel te saaita nei koi ki tokonaki Anau? ");
INSERT INTO nuq_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Emeia kame peenaa, tena kaa na tattara te Launiu Tapu raa e tattara mai ma te mee nei e me ki kapihi mai raa e me ki hakamaoni peehee?” ");
INSERT INTO nuq_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tena Jisas ki meake te kanohenua raa, “Kootou e oo mai roo ma na paraamoa ia ma na muri laakau ki ttaohi Anau pera ma Anau he tama se hailou? Na aho hakaatoa Anau e noho no akoako i te Hare Tapu, tena kootou se hakapiki Anau. ");
INSERT INTO nuq_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Emeia na mee nei hakaatoa e kapihi mai ki mee hea na profet raa ni tattara i roto te Launiu Tapu raa ki hakamaoni.” Tena na disaipol Jisas raa hakaatoa ku tiaki Tama raa no huro i taha. ");
INSERT INTO nuq_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Na tama ni hakapiki Jisas raa ku too Tama raa no kkave i te hare Kaiafas te pohouru hakanaaniu na maatua raa, tena na tama poroporo na tuaa ia ma na tama hakamattua raa ku kkutu i te kina raa. ");
INSERT INTO nuq_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita e hahaere tautari atu hakammao no tae roo i te kina te hare te pohouru hakanaaniu na maatua raa. Pita e uru atu i te kina te hare raa no noho i raro ma na tama lollohi raa ma ki kite aia hea na tama raa e me ki ppena. ");
INSERT INTO nuq_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Na maatua hakananniu ia ma alaa tama hakananniu e lahulahu ma ki lave ni tattara se ttonu i te vahi Jisas ma ki lavaa laatou te taa Tama raa ki mate; ");
INSERT INTO nuq_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","e meia laatou se hai mee e lave, niaina roo ma e tammaki roo na tama e oo ake na hatu na malliu laatou iaa Jisas. Tena te hakaoti, tokorua na taanata ku oo ake i mua ");
INSERT INTO nuq_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","no tattara ake ma, “Te Tama nei e tattara ma, ‘Anau e lavaa te seu te Hare Tapu TeAtua nei ki hina, tena ku hakatuu hakaraoi i roto e toru na aho.’ ” ");
INSERT INTO nuq_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Te pohouru hakanaaniu na maatua raa ku tuu i aruna no meake Jisas ma, “Akoe se isi na tattara ki tattara i te vahi na tattara na tama raa e hai atu Akoe raa?” ");
INSERT INTO nuq_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Emeia Jisas e tuu hemuu koi. Te pohouru hakanaaniu na maatua raa ku meake hakaraoi hoki iaa Jisas ma, “Anau e meatu Akoe ki mee mai te hakamaoni i te inoa TeAtua e ora raa: eaa, Akoe ko te Mesaia, te Tamariki TeAtua raa ma seai?” ");
INSERT INTO nuq_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Kito Jisas ki meake, “Teenaa koi akoe ku mee mai naa. Emeia Anau e meatu kootou: kaamata te saaita nei kootou e me ki kkite te Tamariki te Tama nei e me ki noho i te vahi laaua TeAtua Hakanaaniu raa, tena e me ki hamai i aruna na pukureurehu i te vaelani raa!” ");
INSERT INTO nuq_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Te pohouru hakanaaniu na maatua raa e rono koi na tattara raa, tena aia ki ssae na kaukahu aia raa, tena ki meake, “Tama nei e tattara haeo TeAtua! Taatou se hihhai hoki ma alaa tama ki oo mai no tattara mai i te vahi te Tama nei! Kootou e llono koi te saaita nei na tattara Aia e tattara haeo TeAtua raa! ");
INSERT INTO nuq_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kootou e mannatu maea?” Kito na tama raa ki meake, “Tama naa e isi te sara, tena Aia e tau te taia ria ki mate.” ");
INSERT INTO nuq_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tena na tama raa ku sasavare na maihu Jisas, tena ki riki Tama raa; kito na tama ni ppaa na patikauvae Jisas raa ");
INSERT INTO nuq_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ki meake ma, “Te Mesaia, kame Akoe he profet hakamaoni, Akoe ku tini ma koai te tama ni ppaa Akoe raa!” ");
INSERT INTO nuq_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita e noho i te kina te hare raa te saaita te hine hehekau te pohouru hakanaaniu na maatua raa ni haere ake no meake aia ma, “Akoe hoki e hahaere ma Jisas te tama i Galili raa.” ");
INSERT INTO nuq_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Emeia Pita e kore i mua na tama raa hakaatoa, tena aia ki meake, “Anau se iroa hea akoe e tattara naa.” ");
INSERT INTO nuq_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kito Pita ki tiaki te kina aia e noho raa no haere i te kina te totoka te hare raa. Tena teeraa hine hehekau ku kite Pita, tena aia ki meake na taanata e ttuu i te kina raa, “Te tama nei e hahaere ma Jisas, te tama i Nasaret raa.” ");
INSERT INTO nuq_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tena Pita ki kore hakaraoi hoki ma, “Anau e meatu te hakamaoni pera ma anau se iroa te Tama naa!” ");
INSERT INTO nuq_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tena se roroa na taanata e ttuu i te kina raa ku oo ake iaa Pita raa. Kito na tama raa ki meake, “Hakamaoni roo akoe he tama na tama raa hoki, maitaname na tattara akoe raa e huri mai pera ma akoe i roto na tama raa hoki!” ");
INSERT INTO nuq_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kito Pita ki meake, “Anau e meatu te hakamaoni pera ma anau e tattara roo te hakamaoni. TeAtua ki kou mai ni hakalono llihu kame anau se tattara te hakamaoni! Anau se iroa te Tama naa!” Te saaita naa koi te manu tane raa ku tani, ");
INSERT INTO nuq_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","tena Pita ku maanatu hea Jisas ni meake aia raa ma, “I mua te manu tane raa e tani, akoe e me ki kore e toru na vahao pera ma akoe se iroa Anau.” Tena Pita ki haere i aho no tanitani roo. ");
INSERT INTO nuq_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Te tahata roo na maatua hakananniu ia ma na tama hakamattua na Jiu raa ku hakatonutonu na hakataakoto laatou raa ma ki taa Jisas ki mate. ");
INSERT INTO nuq_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Na tama raa e haihai Jisas ma na seni, tena ki hakattaki Tama raa no kou ake iaa Pailat te tama hakamaatua te taumani i Rom raa. ");
INSERT INTO nuq_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Te saaita Judas, te tama ni hakari ake Jisas raa ni iroa pera ma Jisas ku mee ki taia ria ki mate, aia ku aroha roo iaa Jisas, tena aia ki haere no kou ake hakaraoi te tipu toru na sileni raa i na maatua hakananniu ia ma na tama hakamattua na Jiu raa. ");
INSERT INTO nuq_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Judas e tattara ma, “Anau ku sara roo e mee anau e hakari ake te Tama se isi te sara raa ki taia ria ki mate!” Kito na tama raa ki meake ma, “Kaa hea maatou i te mee naa? Teenaa he vahi koi akoe!” ");
INSERT INTO nuq_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kito Judas ki peesia ake na sileni raa i roto te Hare Tapu, tena ki haere. Aia e haere no halavaua aia hokoia. ");
INSERT INTO nuq_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Na maatua hakananniu raa ku too na sileni raa, tena ki tattara ma, “Teenei ni sileni e taui ki ssepe te ora te tama, ia e me ki se tonu hoki ma na tuaa taatou raa ki ppono na sileni nei ma na sileni i te Hare Tapu raa.” ");
INSERT INTO nuq_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Na tama raa e tattara no tonu i te vahi na sileni raa, tena laatou ki sui te kerekere na tama e penapena na hopeni ma na pelaa e matakkau raa ki mee mo kava na manu siri. ");
INSERT INTO nuq_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Teeraa hea te kerekere raa i mua haere no tae te aho nei koi kanna ria koi ma, “Te Kerekere e hhapu ria te toto.” ");
INSERT INTO nuq_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tena hea profet Jeremaia ni tattara mai i mua raa ku hakamaoni, “Na tama raa e too tipu toru na sileni raa, teenaa ko te kooina na tama Israel raa ni nnuu ma ki sui ake te tama raa, ");
INSERT INTO nuq_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","tena laatou ki too na sileni raa no sui te kerekere na tama e penapena na hopeni ma na pelaa e matakkau raa, e ssau pera ma TeAriki ni tattara mai anau.” ");
INSERT INTO nuq_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisas e tuu i mua Pailat te tama hakamaatua te taumani raa, tena Pailat ki vahiri ake Jisas ma, “Akoe ko te tuku na Jiu?” Tena Jisas ki meake, “Teenaa koi akoe ku mee mai naa.” ");
INSERT INTO nuq_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Emeia Aia e tuu hemuu koi se hai tattara e meake i na tattara na maatua hakananniu ia ma na tama hakamattua raa e hai ake Aia raa. ");
INSERT INTO nuq_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kito Pailat ki meake Jisas, “Akoe se rono na tattara hakaatoa na tama raa e hai atu Akoe raa?” ");
INSERT INTO nuq_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Emeia Jisas se hai tattara roo hokotahi e meake, tena Pailat ku mahharo e mee Jisas e tuu hemuu roo. ");
INSERT INTO nuq_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","I roto na Kai na Pasova hakaatoa, te tama hakamaatua te taumani raa e me ki hakattana he tama karapusi hokotahi tera te kanohenua raa e meake aia ki hakattana. ");
INSERT INTO nuq_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Te saaita naa e isi te tama karapusi hokotahi tera na tama hakaatoa e illoa aia, te inoa aia raa ko Jisas Barabas. ");
INSERT INTO nuq_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Te kanohenua raa ni hakkutu i te kina hokotahi, tena Pailat ku vahiri ake na tama raa ma, “Koai te tama kootou e hihhai ma anau ki hakattana: Jisas Barabas ma Jisas na tama e kanna ma ko te Mesaia raa?” ");
INSERT INTO nuq_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat e iroa roo pera ma na tama hakamattua na Jiu raa e kou ake Jisas raa e mee laatou e manava kkere Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat koi noho i roto te hare hakatonutonu raa, tena te avana aia raa ku kou ake te tattara ma: “Te Tama naa se isi na sara e ppena, tena auu se ppena he mee i te Tama naa, maitaname te poo raa anau e moe no kite pera ma anau e hakalono llihu haeo roo e mee na haeo taatou e ppena i te Tama naa.” ");
INSERT INTO nuq_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Na maatua hakananniu ia ma na tama hakamattua raa ku tatakore ake te kanohenua raa ki meake Pailat ki hakattana Barabas ki haere, tena ku taa Jisas ki mate. ");
INSERT INTO nuq_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tena Pailat e vahiri ake te kanohenua raa, “Koai te tama tokorua nei kootou e hihhai ma anau ki hakattana ma kootou?” Kito te kanohenua raa ki meake ma, “Barabas!” ");
INSERT INTO nuq_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tena Pailat ki vahiri ake hoki na tama raa ma, “Kaa hea anau e me ki ppena iaa Jisas te Mesaia raa?” Kito na tama raa ki meake, “Tii Tama naa i aruna te kros!” ");
INSERT INTO nuq_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tena Pailat ki vahiri ake na tama raa, “Aiea hea te Tama nei e ppena e sara naa?” Kito te kanohenua raa ki kaamata no vaa ake hakamaroa roo ma, “Tii Tama naa i aruna te kros!” ");
INSERT INTO nuq_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Te saaita Pailat ku iroa pera ma kame ku hainattaa ma aia, e mee na tama raa ku kaamata no lloto, tena aia ki ahu na vai raa no ssoro na rima aia raa i mua te kanohenua raa hakaatoa, tena aia ki meake, “Te mate te Tama nei seai ma he sara anau! Teenaa he vahi kootou hokkootou!” ");
INSERT INTO nuq_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tena te kanohenua raa ki hakaioo ake hakaatoa ma, “Tiaki te mate te Tama naa ki moe i na rima maatou ia ma na tamalliki maatou raa!” ");
INSERT INTO nuq_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kito Pailat ki hakattana ake Barabas i te kanohenua raa, tena te saaita na soldia raa ni riki Jisas no oti, Pailat ku kou ake Jisas i na tama raa ki ttii i aruna te kros. ");
INSERT INTO nuq_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tena na soldia Pailat raa ku too Jisas no kkave i te hare te tama hakamaatua te taumani raa, tena na soldia raa hakaatoa ku mmui ake iaa Jisas. ");
INSERT INTO nuq_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Na soldia raa e ui te kaukahu Jisas raa i taha, tena laatou ki hakauru ake te kaukahu roroa e mmea. ");
INSERT INTO nuq_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tena na soldia raa ki ssiri te hau manamana i na laakau e tutuia raa no hakatau ake i te pohouru Jisas raa, tena ki kou ake te laakau raa ma ki ttaohi te rima laaua Tama raa, tena na soldia raa ki tataussua no tutturi i mua Tama raa, tena ki meake ma, “Hakammaha te Tuku na Jiu!” ");
INSERT INTO nuq_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kito na soldia raa ki sasavare Jisas, tena ki too te laakau raa no lliki te pohouru Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Te saaita laatou ku oti roo te tataussua Tama raa, tena laatou ki ui te kaukahu e mmea laatou ni hakauru ake raa, tena ki hakauru ake te kaukahu Tama raa. Kito na soldia raa ki hakattaki Jisas ma ki ttii i aruna te kros. ");
INSERT INTO nuq_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Te saaita na tama raa ni oo i taha ma te matakaina raa, na tama raa ku ttiri Saimon te tama i Sairini raa, tena na soldia raa ki hakamataku ake tama raa ma ki amo te kros Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Na tama raa e oo no ttae i te kina e hui ma Golgota, e mee ma, “Te Kina te Ivi te Pohouru raa.” ");
INSERT INTO nuq_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tena na soldia raa ki kou ake na wain e hilo ma na maraseni e mmara ma ki unu Jisas i te kina raa; e meia Jisas e hakamata te wain raa, teha Aia ki kkaro te unu te wain raa. ");
INSERT INTO nuq_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Na soldia raa e ttii Jisas no oti, tena laatou ki ttahao huhu na hatu ma ki vaevae na hekau Jisas raa ma laatou. ");
INSERT INTO nuq_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Na soldia raa e ttahao no oti, tena ki nnoho i te kina raa no matamata ake Jisas. ");
INSERT INTO nuq_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kito na soldia raa ki ttii i aruna koi te pohouru Jisas raa te hono laatou e tattaa na tattara nei, “Teenei ko Jisas, te Tuku na Jiu.” ");
INSERT INTO nuq_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tena na soldia raa ki ttii hoki tokorua na tama kailallao raa i na vahi Jisas, te tama e ttii i te vahi laaua, tena teeraa tama e ttii i te vahi se laaua Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Na tama e oo hakallaka raa ku lulluu na pohouru laatou, tena ki hai ake na haeo Jisas ma, ");
INSERT INTO nuq_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Akoe e tattara ma Akoe e me ki seu te Hare Tapu raa, tena ma i roto e toru na aho Akoe e me ki hakatuu muri te Hare Tapu raa! Tokonaki Akoe ki ora kame Akoe he Tamariki TeAtua! Hamai i raro ma te kros naa ma Akoe e lavaa!” ");
INSERT INTO nuq_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tena na maatua hakananniu raa, na tama poroporo na tuaa raa ia ma na tama hakamattua raa ku hai ake hoki iaa Jisas ma, ");
INSERT INTO nuq_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Aia e tokonaki alaa tama, e meia Aia se lavaa te tokonaki Aia Hokoia! Aiea Aia seai ma ko te tuku na tama Israel? Kame Aia e tiho mai i raro ma te kros raa te saaita nei, maatou e me ki hakattina i Aia! ");
INSERT INTO nuq_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Aia e hakatina roo TeAtua, tena ki tattara ma Aia he Tamariki TeAtua. Ia tena taatou ki mmata ma TeAtua e me ki tokonaki Aia te saaita nei!” ");
INSERT INTO nuq_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tena tokorua na tama kailallao raa ku hai ake hoki na tattara iaa Jisas. ");
INSERT INTO nuq_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Te saaita te laa latea te henua raa hakaatoa ku pouri roo haere no tae te toru te hiahi. ");
INSERT INTO nuq_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kame te toru te hiahi, Jisas ku tani ake hakamaroa ma, “Eli, Eli, lema sabaktani?” na tattara nei e mee ma, “Taku Atua, Taku Atua, aiea Akoe e tiaki Anau naea?” ");
INSERT INTO nuq_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","E isi na tama e ttuu i te kina raa e llono Jisas, tena ki meake, “Tama nei e kakanna ake Elaija!” ");
INSERT INTO nuq_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tena he soldia hokotahi ku tere no too te spans raa no hhui i roto te wain e mmara raa, tena ki nnoa te mee raa te mata te laakau raa, tena ki kou ake ma Jisas ki unu. ");
INSERT INTO nuq_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Emeia alaa tama e meake ma, “Hakattari, taatou ki mmata ma Elaija se hamai no tokonaki Aia!” ");
INSERT INTO nuq_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jisas e kanna hoki hakamaroa, tena ki ssau te manava hakaoti Aia raa. ");
INSERT INTO nuq_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tena te paamaro e tootoo i roto Hare Tapu raa ku mahaa rua kaamata i aruna haere no hopo i raro. Te ruru henua raa ku ruru te henua raa, tena na hatu raa ku mahahaa, ");
INSERT INTO nuq_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","tena na taruma raa ku ttuu tallaki, tena tammaki na tama TeAtua ni mmate raa ku ora muri. ");
INSERT INTO nuq_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Na tama ni mmate ku ora raa ku tiaki na taruma laatou raa, tena te saaita Jisas ni ora muri raa, na tama raa ku oo i roto te Matakaina e Tapu raa, tena tammaki na tama e kkite na tama raa. ");
INSERT INTO nuq_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Te saaita te soldia hakamaatua raa hakapaa ma na soldia e ttuu ma aia raa ni kkite te ruru henua raa ia ma alaa mee hoki tera ni kapihi ake raa, na tama raa ku mattaku, tena ki tattara ma, “Hakamaoni, teenei he Tamariki TeAtua!” ");
INSERT INTO nuq_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tammaki na hhine e ttuu i te kina raa. Na hhine raa e ttuu hakammao no matamata. Aanei ko na hhine tera ni tauttari mai Jisas kaamata mai i Galili, tena ki tokonaki hoki Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Na hhine raa ko Meri te tama i Makdala raa, ia Meri te tinna Jems laaua ma Josep raa ia ma te avana Sebedi raa e tuu hoki ma na hhine raa i te kina raa. ");
INSERT INTO nuq_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tena he tama hai hekau i te matakaina Arimatea raa ku tae ake te saaita te mee raa ku hiahi; te inoa aia raa ko Josep, tena aia hoki he tama e hakatina iaa Jisas. ");
INSERT INTO nuq_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Josep e haere iaa Pailat raa no kainno ake ma aia e lavaa te too te tinotama Jisas raa. Tena Pailat ki meake na soldia aia raa ki kou ake te tinotama Jisas raa iaa Josep. ");
INSERT INTO nuq_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tena Josep ki too te tinotama Jisas raa no mmini na paamaro e hoou roo, ");
INSERT INTO nuq_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","tena aia ki ppono te tinotama Jisas raa i roto te taruma aia ni keri vahao nei koi i te kina na hatu raa. Tena aia ki hakatakape ake te hatu e rahi roo no ppui te totoka te taruma raa, tena aia ki haere i hare. ");
INSERT INTO nuq_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri te tama i Makdala raa laaua ma teeraa Meri hoki e nnoho i te kina raa no ana ake te taruma raa. ");
INSERT INTO nuq_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Te aho taiao raa ko te aho te Sabat, tena na maatua hakananniu raa laatou ma na Farisi raa ku oo no mmata Pailat, ");
INSERT INTO nuq_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","tena ki meake, “Tama hakamaatua, maatou ku mannatu te saaita te Tama tattara mariu raa koi ora raa, Aia e tattara ma, ‘I muri e toru na aho, Anau e me ki ora muri.’ ");
INSERT INTO nuq_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tena kauna ni soldia ki oo no lollohi hakappuru roo te taruma raa ki tae te aho hakatoru raa, ki se lavaa na disaipol Aia raa te oo mai no too hemuu te tinotama Tama raa, tena ku tattara ake na tama pera ma Jisas ku ora muri. Te tattara mariu hakaoti nei e me ki sakkino roo i aruna na tattara malliu kaamata raa.” ");
INSERT INTO nuq_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kito Pailat ki meake na soldia raa, “Kootou ki oo no ppui hakaraoi roo te taruma raa, tena ku lollohi hakappuru roo.” ");
INSERT INTO nuq_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kito na soldia raa ki oo no ppui hakaraoi roo te taruma raa, tena ki hakammau te hakamaatino i aruna te hatu raa, tena laatou ki meake na soldia e lollohi raa ki ttuu no lollohi. ");
INSERT INTO nuq_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","I muri te Sabat, i te tahata poo roo te aho te latapu, Meri te tama i Makdala raa laaua ma teeraa Meri hoki ku oo no mmata i te taruma raa. ");
INSERT INTO nuq_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Te saaita naa koi te ruru henua hai mahi roo ku ruru, tena he ensel TeAriki e hamai i te vaelani no hakatakape te hatu raa i taha, tena ki noho i aruna te hatu raa. ");
INSERT INTO nuq_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Te tipu te ensel raa e maahina roo pera ma he uila, tena na hekau aia raa e makkini hua roo. ");
INSERT INTO nuq_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Na soldia raa ku poreppore roo te mattaku, tena laatou ku ssau poi ni tama ku mmate. ");
INSERT INTO nuq_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tena te ensel raa ki tattara ake na hhine raa ma, “Koorua ki se mattaku, anau e iroa koorua e sesee Jisas, te tama ni ttii ria i aruna te kros raa. ");
INSERT INTO nuq_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tama raa ku seai i te kina nei; Tama raa ku oti te ora muri pera ma Aia ni tattara atu kootou raa. Oo mai i te kina nei no mmata te kina Aia ni moe raa. ");
INSERT INTO nuq_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Koorua ki oo vave roo no meake na disaipol Aia raa pera ma, ‘Jisas ku oti te ora muri i taha ma te mate, tena te saaita nei Aia ku haere i Galili i mua kootou; kootou e me ki kkite Tama raa i te kina raa!’ Mannatu hea anau ni tattara atu raa.” ");
INSERT INTO nuq_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kito tokorua raa ki tiaki hakavave te taruma raa no oo; tokorua raa e mattaku, ia e hihhia hoki, tena laaua ki huro no tattara ake na disaipol raa. ");
INSERT INTO nuq_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Te saaita naa koi Jisas ku ttiri tokorua hhine raa, tena Aia ki meake, “Te noho laoi ki nnoho ma koorua.” Tena tokorua hhine raa ku oo ake iaa Jisas raa no ttaohi na tapuvae Tama raa, tena ki hakamaru ake Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kito Jisas ki meake tokorua hhine raa, “Auu se mattaku, oo no meake na taina Anau raa ki oo i Galili, tena laatou e me ki kkite Anau i te kina raa.” ");
INSERT INTO nuq_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Te tokorua hhine raa koi oo koi, tena ni soldia i roto na soldia ni lollohi te taruma raa ku vakkai i te matakaina e rahi raa no meake na maatua hakananniu raa na mee hakaatoa ni kapihi ake raa. ");
INSERT INTO nuq_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tena na maatua hakananniu raa ki kkutu ma na tama hakamattua raa ki hakatonutonu na hakataakoto laatou; na tama raa e sui na soldia raa tammaki na sileni, ");
INSERT INTO nuq_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","tena ki meake, “Kootou ki tattara ake na tama pera ma na disaipol Aia raa ni oo atu hemuu te poo no too te tinotama te Tama raa te saaita kootou ni mmoe. ");
INSERT INTO nuq_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tena kame te tama hakamaatua te taumani raa e rono na tattara nei, maatou e me ki tatakore te tama raa pera ma kootou e ttonu koi, tena kootou ki se mamannatu tammaki i na mee nei.” ");
INSERT INTO nuq_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Na soldia raa ku too na sileni raa, tena ki oo no ppena hea na maatua hakananniu raa ni tattara ake laatou raa. Teenei na tattara malliu na Jiu raa e ttoha te saaita raa haere no tae te aho nei. ");
INSERT INTO nuq_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Te sanahuru ma tahi na disaipol raa ku oo i te mouna i Galili tera Jisas ni tattara ake laatou ki oo raa. ");
INSERT INTO nuq_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Te saaita na disaipol raa ni kkite Jisas, na tama raa ku hakamaru ake Tama raa, niaina ma alaa tama laatou koi mamannatu tammaki. ");
INSERT INTO nuq_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisas e haere ake no taapiri, tena ki meake na disaipol raa, “TeAtua e kou mai Anau na mahi hakaatoa i te vaelani ma te maarama nei. ");
INSERT INTO nuq_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tena kootou ki oo i na tama na henua hakaatoa no mee na tama raa mo disaipol Anau: hakoukkou tapu na tama naa i te inoa Tamana, Tana Tama ia ma TeAnana Tapu, ");
INSERT INTO nuq_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","tena kootou ku akoako na tama naa ki tauttari roo na mee hakaatoa Anau ni tattara atu kootou raa. Tena Anau e me ki noho tahi roo ma kootou ki ttae te hakaoti te maarama nei.”");
INSERT INTO nuq_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Teenei ko te Rono Tauareka i te vahi Jisas Krais te Tamariki TeAtua raa. ");
INSERT INTO nuq_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Te Rono Tauareka nei e kaamata te saaita profet Aisaia ni taataa i roto te launiu aia ma, “TeAtua e tattara ma, ‘Anau e me ki kauna te profet Anau raa ki haere i mua Akoe no tanattana mai te mateara Akoe raa.’ ");
INSERT INTO nuq_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","He tama e tattara iho hakamaroa i te kina se hai tama e tuu mahoa raa ma, ‘Tanattana te mateara TeAriki raa, tena ku hakatonu te mateara Aia e me ki hamai vaa aruna raa!’ ” ");
INSERT INTO nuq_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tena Jon e hakahura iho i te kina se hai tama e tuu mahoa raa no hakoukou tapu na tama, tena ki takutaku. Jon e meake te kanohenua raa ma, “Ttike i taha ma na hai sara kootou raa ki hakoukou tapu ria kootou, tena TeAtua e me ki ssoro na hai sara kootou raa i taha.” ");
INSERT INTO nuq_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tammaki na tama i na matakaina Judia laaua ma Jerusalem raa ku oo ake no hakallono iaa Jon. Na tama raa e uiui na hai sara laatou raa, tena Jon ki hakoukou tapu na tama raa i roto te riva Jordan. ");
INSERT INTO nuq_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon e uru na hekau e pena i na huruhuru na kamel, tena ki taitu te kiri na manu, tena aia e kaikai na lokas ia ma na hani vaa roto. ");
INSERT INTO nuq_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jon e takutaku ake te kanohenua raa ma, “Te Tama e me ki hamai i muri anau raa e hakanaaniu i aruna anau. Anau se tau hoki te huru i raro no ui na taka Aia e uru raa. ");
INSERT INTO nuq_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Anau e hakoukou tapu kootou ma te vai, e meia te tama naa e me ki hakoukou tapu kootou ma TeAnana Tapu.” ");
INSERT INTO nuq_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ia se roroa hoki, tena Jisas ku hamai peeraa i Nasaret te matakaina i roto Galili. Tena Jon ki hakoukou tapu Jisas i roto te riva Jordan. ");
INSERT INTO nuq_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Te saaita koi Jisas ni mahike no tuu i aruna i roto te riva raa, tena Aia ku kite te vaelani raa ku taaraki iho, tena TeAnana Tapu raa ku llee iho peeraa ma he rupe no toko i aruna Aia. ");
INSERT INTO nuq_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tena te reo TeAtua raa ku tattara iho i te vaelani ma, “Akoe ko Taku Tamariki tera Anau e hihai mahi roo. Anau e hihia roo Akoe.” ");
INSERT INTO nuq_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Te saaita naa koi, TeAnana Tapu raa ku hakattaki Jisas i te kina se hai tama e tuu mahoa raa, ");
INSERT INTO nuq_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","tena Aia ki noho i te kina raa tipu haa na aho, tena Satan ki tatakore Aia. Na manu takavao raa e hahaere vaa raa hoki, e meia na ensel raa e oo ake no tokonaki Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jon ku oti te ppono ria i roto te hare karapusi, tena Jisas ki haere no takutaku ake te Rono Tauareka TeAtua raa i Galili. ");
INSERT INTO nuq_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jisas e takutaku ma, “Te saaita hakamaoni raa ku tae mai, tena te Hakamaatua ana i te Vaelani raa ku taapiri! Ttike i taha ma na hai sara kootou raa no hakattina i te Rono Tauareka TeAtua raa.” ");
INSERT INTO nuq_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisas e hahaere vaa tai te Namo Galili, tena Aia e kite te haanau Saimon laaua ma Andru e puipui te kupena. Tokorua raa ni tama meemee ika. ");
INSERT INTO nuq_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Tena Jisas ki meake tokorua raa, “Tauttari mai Anau, tena Anau e me ki akoako koorua ki hahanota na tama.” ");
INSERT INTO nuq_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Te saaita naa koi tokorua raa ku tiaki na kupena laaua raa no tauttari Jisas. ");
INSERT INTO nuq_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tena Jisas ki hakanuu atu no kite teeraa haanau hoki, Jems laaua ma Jon, na tama Sebedi raa. Na tama raa e onoono na kupena laatou raa i roto te vaka. ");
INSERT INTO nuq_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jisas e kite tokorua raa, tena Aia ki kanna ake te haanau raa, kito Jems laaua ma Jon ki tiaki Sebedi te tamana laaua raa i roto te vaka raa ma na tama hehekau laatou raa, tena laaua ki tauttari Jisas. ");
INSERT INTO nuq_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisas ma na disaipol Aia raa ku oo no ttae i te matakaina Kaperneam, tena i te aho te Sabat raa Jisas ku haere i te hare lotu na Jiu raa no akoako ake te kanohenua raa. ");
INSERT INTO nuq_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Na tama e llono na akoako Jisas raa ku mahharo roo e mee Aia se akoako pera ma na tama poroporo na tuaa raa, e meia Aia e akoako roo ma na mahi Aia. ");
INSERT INTO nuq_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Te saaita naa koi he tama e ttau ria te tipua ku haere ake iaa Jisas i roto te hare lotu raa no kanna ake ma, ");
INSERT INTO nuq_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jisas te Tama i Nasaret, hea Akoe e hihai i maatou? Akoe e hamai ma ki seu maatou? Anau e iroa Akoe: Akoe ko te Tama e Tapu TeAtua raa.” ");
INSERT INTO nuq_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tena Jisas ki hakamataku ake te tipua raa ma, “Auu se vaa, tena akoe ku hamai i taha ma te tama naa!” ");
INSERT INTO nuq_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tena te tipua raa ku ssue roo na mahi aia i roto te tama raa, tena ki kapihi te varo aia raa hakamaroa roo no haere i taha ma te tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Na tama raa hakaatoa ku mahharo, tena ki vahihhiri hokolaatou ma, “Teenei he mee peehee? Teenei he akoako vahao nei? Te Tama nei e isi na mahi Aia ki tattara hakamataku ake na tipua raa, tena na tipua raa e hakallono hoki Aia.” ");
INSERT INTO nuq_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tena te rono Jisas raa ku paa vave roo vaa roto Galili. ");
INSERT INTO nuq_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisas ma na disaipol Aia raa, tena Jems laaua ma Jon ku tiaki te hare lotu raa no oo tahi roo i te hare Saimon laaua ma Andru raa. ");
INSERT INTO nuq_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Te hinaona hine Saimon raa e moe i hare i aruna te lomoena aia raa, tena na tama raa ku tattara ake Jisas ma, “Te hine nei e laavea, ia te vvela aia raa e hai mahi roo.” ");
INSERT INTO nuq_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tena Jisas ki haere atu no taohi te rima te hine raa no hakamahike i aruna. Te saaita naa koi te vvela raa ku hopo, tena te hine raa ku mahike no kou ake na kai na tama raa no kkai. ");
INSERT INTO nuq_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Te saaita te laa raa ni huru, te kanohenua raa ku hakattaki ake na tama lavvea ia ma na tama e isi na tipua raa iaa Jisas. ");
INSERT INTO nuq_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Na tama te matakaina raa hakaatoa ku oo ake no hakkutu i aho te hare Saimon raa. ");
INSERT INTO nuq_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tena Jisas ki ui na maahana na tama lavvea raa, tena ki hakaise na tipua raa i taha. Jisas e ppui ake hoki na tipua raa ki se tattara, e mee na tipua raa ko na illoa roo avare Aia. ");
INSERT INTO nuq_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jisas e maahuru te tahata poo roo no haere i te kina se hai tama raa no lotu. ");
INSERT INTO nuq_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tena Saimon laatou ma na tama i roto te hare aia raa ku oo no sesee Jisas. ");
INSERT INTO nuq_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Na tama raa e oo no kkite Jisas, tena laatou ki meake ma, “Na tama hakaatoa e sesee Akoe.” ");
INSERT INTO nuq_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kito Jisas ki meake na tama raa, “Taatou ki oo hoki i alaa matakaina e tappiri mai raa no takutaku i roto na matakaina raa, e mee teenei hea Anau e hamai.” ");
INSERT INTO nuq_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tena Jisas ku haere vaa roto Galili no takutaku i roto na hare lotu na matakaina raa, tena ki hakaise na tipua raa i taha. ");
INSERT INTO nuq_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","He tama e kaina te manumanu haeo ku haere ake no tuturi i mua Jisas, tena ki kainno ake ma, “Kame Akoe e hihai, Akoe ku mee anau ki matahua i te vahi te lotu.” ");
INSERT INTO nuq_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jisas ku aroha te tama raa, tena Aia ki haaro ake te rima Aia raa no taohi te tama raa, tena ki meake, “Anau e hihai ki tokonaki akoe, tena akoe ku matahua.” ");
INSERT INTO nuq_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Te saaita naa koi te maahana raa ku hopo i taha ma te tama raa, tena te tama raa ku tauareka. ");
INSERT INTO nuq_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jisas ku kauna te tama raa ki haere, tena ki tattara hakamataku ake ma, ");
INSERT INTO nuq_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Auu se tattara ake alaa tama hea Anau ni ppena raa. Haere no huri ake te tinotama akoe raa ki mmata te maatua raa, tena akoe ku kou ake te hakamaru akoe raa ki tau ma na tama ku taualleka raa pera ma hea Moses ni mee mai raa, ia ki huri ake hoki ki kkite te kanohenua raa pera ma akoe ku tauareka.” ");
INSERT INTO nuq_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Emeia te tama raa e haere no haere tattara koi i na kina roo hakaatoa hea Jisas ni ppena raa. Tena Jisas ku se lavaa te haere i roto na matakaina raa, e mee te tama raa e tattara mahi roo hea Aia ni ppena raa. Tena Jisas ki haere i na kina se hai tama e nnoho raa, tena na tama na matakaina raa hakaatoa ku oo ake i Aia. ");
INSERT INTO nuq_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","E llava na aho ku llaka, tena Jisas ki vaakai i Kaperneam. Te kanohenua raa ku llono ma Jisas ku tae ake i te hare Aia ni noho raa. ");
INSERT INTO nuq_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Tena tammaki na tama ku oo ake no nnoho i te hare raa. Te hare raa ku kappi roo, tena na totoka raa hoki ku kkapi. Jisas e takutaku ake na tama raa na tattara TeAtua raa, ");
INSERT INTO nuq_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ia te saaita naa he tokohaa na tama e sausau ake te tama na vae e mmate raa ku ttae ake. ");
INSERT INTO nuq_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tena te tokohaa raa ku se lavaa te ttae i te kina Jisas e noho raa e mee te hare raa ku kappi roo. Kito na tama raa ki kkake no hakahotu te inaki i aruna roo te kina Jisas e noho raa, tena na tama raa ki hakatere iho te moena te tama na vae e mmate raa e moe. ");
INSERT INTO nuq_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jisas e kite na hakattina na tama raa, tena Aia ki meake te tama na vae e mmate raa ma, “Taku tama, Anau e ssoro na hai sara akoe raa i taha.” ");
INSERT INTO nuq_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ia e isi na tama poroporo na tuaa e nnoho i te kina raa, tena na tama raa ku mamannatu hokolaatou ma, ");
INSERT INTO nuq_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Te Tama nei se mataku te tattara peenei? Te Tama nei e tattara haeo TeAtua! TeAtua ko te Tama hokotahi koi e lavaa te ssoro na hai sara i taha!” ");
INSERT INTO nuq_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Te saaita naa koi Jisas ku iroa na hakataakoto na tama raa, tena Aia ki meake, “Aiea kootou e mamannatu peenaa naea? ");
INSERT INTO nuq_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Aiea te tattara hee e hainauhie ki meake te tama na vae e mmate nei, te tattara ma, ‘Na hai sara akoe raa ku oti te ssorohia’, ma te tattara ma, ‘Mahike i aruna no too te moena akoe naa no haere’? ");
INSERT INTO nuq_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Anau e me ki huri atu kootou pera ma te Tamariki te Tama nei e isi na mahi i te maarama nei ki ssoro na hai sara na tama i taha.” Kito Aia ki meake te tama na vae e mmate raa, ");
INSERT INTO nuq_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Anau e meatu akoe, mahike i aruna no too te moena akoe naa no haere i hare!” ");
INSERT INTO nuq_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Te saaita naa koi te tama na vae e mmate raa ku tuu i aruna no too te moena aia raa, tena ki haere vaa lottonu na tama raa hakaatoa. Te kanohenua raa ku mahharo roo, tena ki hakammaha TeAtua ma, “Taatou se hai mee roo peenei ni kkite i mua.” ");
INSERT INTO nuq_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisas ku vaakai i tai i te Namo Galili raa, tena tammaki na tama ku oo ake i Aia. Kito Jisas ki akoako ake na tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jisas e haere vaa tai no kite Livai te tama Alfius raa e noho i te kina e aoao na takis te taumani i Rom raa. Tena Jisas ki meake te tama raa, “Tautari mai Anau.” Kito Livai ki mahike i aruna no tautari Jisas. ");
INSERT INTO nuq_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jisas ma na disaipol Aia raa ku noho i te hare Livai raa no kkai, tena tammaki na tama aoao na takis ia ma na tama hai ssara e tauttari ake hoki Jisas, ia tammaki na tama ku nnoho ma ki kkai ma Jisas. ");
INSERT INTO nuq_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","E isi na Farisi ia ma na tama poroporo na tuaa e kkite Jisas e kkai ma na tama hai ssara ia ma na tama aoao na takis raa, tena na tama raa ki vahiri ake na disaipol Jisas raa ma, “Aiea te Tama raa e kkai ma na tama aoao na takis ia ma na tama hai ssara raea?” ");
INSERT INTO nuq_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jisas e rono na tattara na tama raa, tena Aia ki meake, “Na tama se lavvea raa se lavaa te oo no mmata te dokta, e meia na tama e lavvea raa koi e me ki oo no mmata te dokta. Anau se hamai no kanna na tama e mannatu ma laatou e ttonu raa, e meia Anau e hamai no kanna na tama ma laatou e ppii na hai ssara raa.” ");
INSERT INTO nuq_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Na tama tauttari Jon Baptis ma na Farisi raa e isi na vahao e hakamaatapu ki se kkai. Tena e isi na tama e oo no meake Jisas ma, “Aiea na disaipol Jon Baptis raa ia ma na disaipol na Farisi raa e hakamaatapu, kaa na disaipol Akoe raa se hakamaatapu raea?” ");
INSERT INTO nuq_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Kito Jisas ki meake, “Eaa! Na tama e aruhia ki oo i te kai te avana raa e me ki nnoho koi se kkai? Seai! Te saaita te tama tane vahao nei raa e nnoho ma laatou, na tama raa se lavaa te nnoho se kkai. ");
INSERT INTO nuq_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Emeia e isi te aho e me ki hamai te saaita na tama raa e me ki too te tama raa i taha, tena na tama naa ku hakamaatapu. ");
INSERT INTO nuq_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Se hai tama e me ki ttui te muri maro vahao nei raa i aruna te paamaro tuai, maitaname te kina e ttui hoou raa e me ki masae i taha no mee te rua raa no rahi roo. ");
INSERT INTO nuq_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Se hai tama e me ki utu na wain e pena vahao nei raa i roto te kiri na sipsip tera laatou ku oti te utu na wain i mua raa, e mee te hai mahi te wain raa e me ki ssaa te kiri na sipsip ku tuai raa, tena te wain raa ku manini puamu, tena te kiri na sipsip raa hoki e me ki haeo. Emeia utu na wain e pena vahao nei raa i roto na kiri na sipsip vahao nei raa.” ");
INSERT INTO nuq_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jisas ma na disaipol Aia raa ku oo vaa roto te paupaku e hhomo na wit raa i te aho te Sabat. Tena na disaipol Aia raa ku kotikoti na hua na wit raa no kkai. ");
INSERT INTO nuq_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kito na Farisi raa ki meake Jisas, “Kira ake, te mee nei e sara ma na tuaa taatou ma na disaipol Akoe raa ki kotikoti na hua raa i te aho te Sabat!” ");
INSERT INTO nuq_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Kito Jisas ki meake na Farisi raa, “Kootou ni se ppau hea Devit ni ppena i mua te saaita aia ma na tama tauttari aia raa ni se isi na mee e me ki kkai? Devit ma na tama tauttari aia raa ku hikkai, ");
INSERT INTO nuq_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","tena Devit ki haere i roto te Hare Tapu raa no kai na haraoa e ttapu na maatua raa ni hoki ake TeAtua raa. Te mee nei e kapihi mai te saaita Abiatar; te pohouru hakanaaniu na maatua raa. Na maatua raa koi e lavaa te kkai na haraoa raa, teenaa hea na tuaa raa e tattara mai, e meia Devit e kai no oti, tena ki kou ake na haraoa raa hoki no kkai na tama tauttari aia raa.” ");
INSERT INTO nuq_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kito Jisas ki meake hoki na Farisi raa, “TeAtua e tuku te Sabat raa ma ki tokonaki na tama, e meia Aia se tuku ma te Sabat raa ki hakamaatua i aruna te tama. ");
INSERT INTO nuq_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ia tena te Tamariki te Tama nei ko TeAriki te Sabat.” ");
INSERT INTO nuq_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tena Jisas ku vaakai hakaraoi i te hare lotu na Jiu raa no kite te tama te rima e mate e noho i te kina raa. ");
INSERT INTO nuq_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Alaa tama i te kina raa e hihhai ki mmau tattara iaa Jisas. Tena na tama raa ku kirakira hakamattonu roo ma ka oti Jisas ku kapake no tokonaki te tama raa i te aho te Sabat raa. ");
INSERT INTO nuq_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tena Jisas ki meake te tama te rima e mate raa, “Hamai i te kina nei no tuu i mua.” ");
INSERT INTO nuq_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tena Aia ki vahiri ake na tama raa, “Na tuaa taatou i te aho te Sabat raa e mee maea? Ki tokonaki te ora te tama ma ki kou ake na hakalono llihu te tama? Ki tokonaki te tama ki ora ma ki ssepe te ora te tama?” Emeia na tama raa se hai tattara roo e meake. ");
INSERT INTO nuq_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisas ku roto no kkira ake na tama raa, e meia i roto hoki Aia te saaita naa, Aia e aroha roo i na tama raa e mee na tama raa e tattara nattaa ia e ssara hoki. Tena Aia ki meake te tama te rima e mate raa, “Ssora te rima akoe naa.” Te tama raa e ssora te rima aia raa, tena te rima raa ku tauareka hakaraoi. ");
INSERT INTO nuq_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kito na Farisi raa ki tiaki te hare lotu raa, tena ki oo no kkutu ma alaa tama te kuturana Herot raa, tena na tama raa ku tattara ma ki taa Jisas ki mate. ");
INSERT INTO nuq_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisas ma na disaipol Aia raa ku oo peeraa i te Namo Galili raa, tena he kanohenua e rahi roo ku tauttari Tama raa. Na tama raa ni tama e oo mai i Galili ia ma Judia, ");
INSERT INTO nuq_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ia ma na tama i Jerusalem, na tama Idumea, na tama te vahi te anake te riva Jordan raa ia ma na tama na matakaina e ttuu alleha Taia laaua ma Saidon raa. Na tama nei hakaatoa e oo ake iaa Jisas e mee laatou ni llono na mee Tama raa ni ppena raa. ");
INSERT INTO nuq_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Te kanohenua raa e rahi roo, tena Jisas ki meake na disaipol Aia raa ki tanattana he vaka ma Aia, ka oti te kanohenua raa ku mmui ake no hakkapi Aia. ");
INSERT INTO nuq_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jisas ku oti te tokonaki tammaki na tama lavvea no taualleka, tena na tama se ki tokonaki ria no taualleka raa ku haere unuki na tama raa ma ki ttae laatou iaa Jisas no ttaohi Tama raa ki taualleka laatou. ");
INSERT INTO nuq_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tena he saaita peehee na tama e isi na tipua i roto laatou raa e kkite Jisas, na tama raa e me ki hhina i mua Tama raa, tena ku ttani ake ma, “Akoe ko te Tamariki TeAtua!” ");
INSERT INTO nuq_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tena Jisas ki hakamataku ake na tipua raa ma ki se hakari ake na tama ma koai Aia. ");
INSERT INTO nuq_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jisas e haere i te kina te mouna raa no kanna ake na tama Aia e hihai raa ki oo ake Aia. Na tama raa e oo ake, ");
INSERT INTO nuq_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","tena Aia ki hirihiri sanahuru ma rua na tama, tena Aia ki kanna na tama raa ma ni aposol. Kito Jisas ki meake, “Anau e hirihiri kootou ki nnoho ma Anau. Anau e me ki kauna hoki kootou ki oo no takutaku, ");
INSERT INTO nuq_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","tena kootou e me ki isi na mahi ki hakaise na tipua i taha.” ");
INSERT INTO nuq_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Teenei te sanahuru ma rua na aposol Jisas ni hirihiri raa: Saimon (Jisas e hui ma ko Pita raa); ");
INSERT INTO nuq_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","tena Jems laaua ma te taina aia raa Jon na tama Sebedi raa (Jisas e hui tokorua raa ma Boanerges, e mee ma “Na taanata te Hatturi”); ");
INSERT INTO nuq_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","tena Andru, Filip, Bartolomyu, Matiu, Tomas, Jems te tama Alfius raa, Tadius, Saimon te tama se hihai ma Rom ki rorohi Israel raa, ");
INSERT INTO nuq_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","tena Judas Iskariot, te tama e me ki hakari ake Jisas i na tama hakamattua raa. ");
INSERT INTO nuq_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jisas ku haere i hare, tena he kanohenua e rahi roo ku hakkutu ake, tena Jisas ma na disaipol raa ku se isi te saaita ki nnoho no kkai. ");
INSERT INTO nuq_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Te tinna ia ma na taina Jisas raa ku llono na tattara na tama e tattara i te vahi Jisas raa, kito na tama raa ki oo no mmata ma ki too Tama raa, e mee na tama ku tattara ma, “Jisas ku vvare!” ");
INSERT INTO nuq_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Na tama poroporo na tuaa ni oo mai i Jerusalem raa ku tattara ma, “Belsebul e tau i roto Tama naa. Teenaa ko tuku na tipua raa e kou ake na mahi Tama naa ki hakaise na tipua raa i taha.” ");
INSERT INTO nuq_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kito Jisas ki kanna ake na tama raa ki oo ake, tena Aia ki tattara ake na tattara hurihuri nei, “Satan e lavaa te hakaise na tipua aia raa i taha? ");
INSERT INTO nuq_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kame he henua e vaevae hokolaatou i na kuturana no ppuhu hokolaatou, na tama naa se lavaa te nnoho taualleka. ");
INSERT INTO nuq_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ia kame he hareakina e vaevae hokolaatou i na kuturana no ppuhu hokolaatou, te hareakina naa se lavaa te nnoho taualleka hoki. ");
INSERT INTO nuq_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kame na tipua Satan raa e vaevae i na kuturana no ppuhu hokolaatou, tena na mahi Satan raa se lavaa te mmoe roroa, e meia na mahi raa e me ki mattea koi no oti. ");
INSERT INTO nuq_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Se hai tama e lavaa te uru i roto te hare te tama e ivi raa no too na hekau te tama raa kame te tama kairarao raa se haihai te tama e ivi raa i mua ki lavaa aia te uru i hare no kairarao. ");
INSERT INTO nuq_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Anau e meatu te hakamaoni pera ma TeAtua e lavaa te ssirihia na hai sara ia ma na tattara sakkino hakaatoa na tama e pehipehi i te vahi Aia raa. ");
INSERT INTO nuq_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Emeia te tama e tattara sakkino TeAnana Tapu raa se lavaa te ssirihia, maitaname te hai sara naa e me ki moe tahi na vahao hakaatoa.” ");
INSERT INTO nuq_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Jisas e tattara ake peenei maitaname e isi na tama e tattara ma, “Tama raa e isi te tipua e tau i roto Aia.”) ");
INSERT INTO nuq_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tena te tinna ia ma na taina Jisas raa ku ttae ake. Na tama raa e ttuu i aho, tena ki kkave te tattara i hare ma ki meake Jisas ki hamai i aho. ");
INSERT INTO nuq_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kito na tama e nnoho alleha Jisas raa ki meake, “Kira ake, te tinna ma na taina ia ma na kaave Akoe raa e ttuu i aho, tena laatou e hihhai ma Akoe ki haere ake.” ");
INSERT INTO nuq_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kito Jisas ki meake, “Koai te tinna Anau? Koai na taina Anau?” ");
INSERT INTO nuq_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jisas e kkira ake na tama e nnoho alleha Aia raa, tena ki meake, “Kira ake! Aanei na tinna ia ma na taina Anau! ");
INSERT INTO nuq_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Te tama e ppena hea TeAtua e hihai raa he taina, he kave, ia he tinna Anau.” ");
INSERT INTO nuq_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisas ku kaamata no akoako te kanohenua raa i tai te Namo Galili raa. Te kanohenua e muimui ake Aia raa e tammaki roo, tena Aia ki kake i roto te vaka raa no noho no akoako ake na tama raa. Te vaka raa e tautau i tai, tena te kanohenua raa e ttuu i te taunatai no hakallono. ");
INSERT INTO nuq_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jisas e tattara na tattara hurihuri ki akoako ake na tama raa tammaki na mee, tena Aia ki meake ma, ");
INSERT INTO nuq_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Hakallono! Teeraa he tama e haere lletu na hua ma ki hhomo. ");
INSERT INTO nuq_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Te saaita aia ni haere lletu na hua raa, alaa hua e maoha i te mateara, tena na manu raa ku llee iho no kkai na hua raa. ");
INSERT INTO nuq_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tena alaa hua e maoha i te kina e hatu, tena te kina raa se isi hoki tammaki na kerekere. Ia se roroa na hua raa ku hhomo e mee te kerekere raa e patake roo. ");
INSERT INTO nuq_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tena te saaita te laa raa ni hopo ake, na hua e hhomo raa ku vvela ria koi no mmate e mee na patiaka raa se uru roo i roto te kerekere. ");
INSERT INTO nuq_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Alaa hua e maoha i te kina na laakau e tutuia raa, tena na laakau raa e hhomo ake no uhi na hua raa, tena na hua raa ku se lavaa te hhomo no llahi no hhua na hua. ");
INSERT INTO nuq_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Emeia alaa hua e maoha i te kina na kerekere e taualleka, tena na hua raa ku hhomo no llahi no hhua na hua: alaa laakau e ttae tipu toru na hua, alaa laakau e ttae tipu ono, tena alaa laakau e ttae huitarau na hua.” ");
INSERT INTO nuq_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tena Jisas ki hakaoti ake ma, “Hakallono kame kootou e isi na katarina!” ");
INSERT INTO nuq_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jisas ku noho Hokoia, tena na tama ni llono na tattara Jisas raa ku oo ake ma te sanahuru ma rua na disaipol raa no vahiri ake Tama raa ma ki tattara hakamatahua ake te hakataakoto te tattara hurihuri raa. ");
INSERT INTO nuq_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kito Jisas ki meake, “Kootou ku oti te too na mee tera se hai tama e iroa i te vahi te Hakamaatua ana i te Vaelani raa. Emeia alaa tama na tama e ttuu koi i aho raa e me ki llono na mee nei i na tattara hurihuri raa ");
INSERT INTO nuq_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ma ki lavaa, ‘Na tama raa te kirakira koi no kirakira, e meia laatou se lavaa te kkite; na tama raa e me ki hakalollono koi no hakalollono, e meia laatou se lavaa te illoa. Kame na tama raa e kkite no illoa, tena na tama raa e me ki vakkai ake TeAtua, tena TeAtua e me ki ssirihia na hai sara na tama raa.’ ” ");
INSERT INTO nuq_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tena Jisas ki vahiri ake na tama raa, “Aiea kootou se illoa te hakataakoto te tattara hurihuri nei? Kaa kootou e me ki illoa peehee na hakataakoto alaa tattara hurihuri? ");
INSERT INTO nuq_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Te tama e haere lletu na hua raa ko te tama e haere tattara na tattara TeAtua raa. ");
INSERT INTO nuq_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Alaa tama e ssau pera ma na hua e maoha i aruna te mateara raa, ia te saaita koi na tama raa ni llono na tattara TeAtua raa, Satan ku haere ake no tokea na tattara raa i taha ma na tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Alaa tama e ssau pera ma na hua e maoha i aruna i te kina e hatu raa. Emeia te saaita na tama raa ni llono na tattara TeAtua raa, na tama raa ku hihhia no too na tattara raa. ");
INSERT INTO nuq_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tena na tattara raa se uru kanohi roo i roto na tama raa, ia na tattara raa hoki se mmoe roroa. Tena te saaita na haeo ia ma na hakalono llihu raa e ttae ake e mee na tattara TeAtua raa, tena na tama raa e me ki tiaki hua koi na tattara raa. ");
INSERT INTO nuq_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Alaa tama e ssau pera ma na hua e maoha i te kina na laakau e tutuia raa. Aanei ko na tama tera e llono na tattara TeAtua raa, ");
INSERT INTO nuq_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","e meia na tama raa e mamannatu tammaki na ora i te maarama nei raa, tena te mannako sileni ia ma na mee roo hakaatoa i roto te maarama nei raa e hakapaa hakaatoa no uhi na tattara TeAtua raa, tena na tattara raa ku se hhua na hua. ");
INSERT INTO nuq_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Emeia alaa tama e ssau pera ma na hua e hhomo i te kina te kerekere tauareka raa. Na tama raa e llono no too na tattara raa, tena na tattara TeAtua e mmoe i roto na tama raa ku hhomo no hhua na hua; alaa laakau e ttae tipu toru, alaa laakau e ttae tipu ono, tena alaa laakau e ttae huitarau na hua.” ");
INSERT INTO nuq_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tena Jisas ki meake hoki ma, “Eaa, e isi te tama e lavaa te hakaura te lamu raa, tena ku uhi i raro te kumete, kaa seai ku hakatuu i raro te sea mommoe? Te tama raa kame se hakaura te lamu raa no hakatotoo i aruna ki maahina? ");
INSERT INTO nuq_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Na mee e huuna ria raa e me ki huri ake no kkite na tama hakaatoa, tena na mee e uhia ria raa e me ki laavea ria koi. ");
INSERT INTO nuq_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tena hakallono, kame kootou e isi na katarina!” ");
INSERT INTO nuq_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kito Jisas ki meake hoki na tama raa ma, “Mannatu hakaraoi i na mee kootou e llono raa. Na tuaa kootou e hakatonutonu na tama raa ko na tuaa TeAtua e me ki too no hakatonutonu kootou, ia e me ki mmaha roo i aruna na tuaa naa. ");
INSERT INTO nuq_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","TeAtua e me ki kou ake alaa mee hoki i na tama tera e isi tammaki na mee raa, ia na tama se isi na mee raa, TeAtua e me ki too na mee naa hakaatoa i taha ma laatou, niaina ma na mee raa e moisi.” ");
INSERT INTO nuq_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Tena Jisas ki meake na tama raa, “Te Hakamaatua ana i te Vaelani raa e ssau pera ma te tama e haere lletu na hua i roto te paupaku aia raa. ");
INSERT INTO nuq_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Te tama naa he tama koi e moe na poo, tena te tahata aia ku maahuru no hahaere, e meia na hua aia ni haere lletu raa ku mahha ake no hhomo. Tena te tama raa se iroa ma na hua raa e hhomo peehee. ");
INSERT INTO nuq_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Te kerekere raa e mee na hua raa no hhomo no llahi no hhua na hua; na hua raa ku mahha ake no hhomo, tena na laumea raa e hhura ake kaamata, tena ki oti na kaute na hua raa ku mattara, tena ki oti roo na hua raa ku hhura ake. ");
INSERT INTO nuq_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Te saaita na hua raa ku lleu, tena te tama raa ku haere haki na hua raa ma te paraamoa aia raa, e mee te saaita ki haki na hua raa ku ttae.” ");
INSERT INTO nuq_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Tena Jisas ki vahiri ake “Te Hakamaatua ana i te Vaelani raa e tipu peehee? Ni tattara hurihuri peehee taatou e me ki tattara ki hakamaarama atu kootou i na tipu te Hakamaatua ana i te Vaelani raa? ");
INSERT INTO nuq_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Te Hakamaatua ana i te Vaelani raa e tipu peenei. He tama e too te hua te mastet, teenaa ko te hua e paamee roo hokoia i na hua roo hakaatoa i te maarama nei raa no ttori. ");
INSERT INTO nuq_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Se roroa te hua raa ku homo, tena ki homo no rahi roo i aruna na laakau hakaatoa. Na raraa te laakau raa e llahi roo, tena na manu raa ku pena na hohana laatou raa i te maru te laakau raa.” ");
INSERT INTO nuq_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","E tammaki na tattara hurihuri peenei Jisas e takutaku ake te kanohenua raa na tattara Aia; Jisas e tattara ake e hia na tattara hurihuri Aia e lavaa te tattara ake ma ki illoa na tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jisas e tattara ake na tattara hurihuri na vahao hakaatoa Aia e tattara ake na kanohenua raa, e meia te saaita Aia e noho ma na disaipol Aia raa, tena Aia ku tattara hakamatahua ake na disaipol Aia raa na hakataakoto na tattara hurihuri raa. ");
INSERT INTO nuq_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jisas ku meake na disaipol Aia raa te hiahi te aho naa ma, “Taatou ki tere i teeraa vahi te namo nei.” ");
INSERT INTO nuq_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kito na tama raa ki tiaki te kanohenua raa, tena ki oo no kkake te vaka Jisas e noho i roto raa, tena na disaipol raa hakaatoa ku hhuro laatou ma Jisas. Alaa vaka e tauttau hoki i te kina raa. ");
INSERT INTO nuq_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Te saaita naa koi te matani raa ku maairi roo, tena na peau raa ku utuutu i roto te vaka raa no pii roo te riu raa. ");
INSERT INTO nuq_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisas e moe i muri te vaka raa no aruna te pilo. Kito na disaipol raa ki hhano Tama raa no maahuru, tena ki meake, “Rabai, Akoe se maanatu ma taatou kaa mmate?” ");
INSERT INTO nuq_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tena Jisas ki tuu i aruna no hai ake te matani raa ma, “Marino!”, tena Aia ki hai ake hoki na peau raa ma, “Ku tau se peau!” Tena te matani raa ku mate no marino kkii roo. ");
INSERT INTO nuq_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kito Jisas ki meake na disaipol Aia raa, “Kootou e mattaku naea? Kootou se isi na hakattina?” ");
INSERT INTO nuq_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Emeia na disaipol raa ku mattaku roo, tena ki tattara hokolaatou ma, “Teenei he tama peehee? Te matani ia ma na peau raa e hakallono hoki Aia!” ");
INSERT INTO nuq_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisas ma na disaipol Aia raa ku ttae i teeraa vahi te Namo Galili i te matakaina Gerasa raa. ");
INSERT INTO nuq_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jisas e tiho koi i taha ma te vaka raa, tena he tama e hamai peeraa i te kina na kava raa ku ttiri Aia. Te tama raa e isi na tipua i roto aia, ");
INSERT INTO nuq_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","tena aia e nohonoho koi i te kina na kava raa. Se hai tama e lavaa te haihai te tama raa ma na seni; ");
INSERT INTO nuq_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","e mee tammaki na vahao na tama raa e haihai aia ma na seni, e meia aia e mmosi koi na seni raa, tena ki hakappela na popore mattoru na tama raa e taro na vae aia raa. Te tama raa e ivi roo, ia se hai tama hoki e lavaa te ttaohi tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Te ao ma te poo, te tama nei e haere kapipihi varo i na kina na kava ia ma na mouna raa, tena ki tutuu hoki te tinotama aia raa ma na hatu. ");
INSERT INTO nuq_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Te tama raa koi mmao te saaita aia ni kite Jisas, tena aia ki tere ake no tteiho no tuturi i mua Tama raa, ");
INSERT INTO nuq_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","tena ki kanna hakamaroa roo ma, “Jisas, te Tamariki TeAtua Hakanaaniu! Hea Akoe e hihai ki ppena i anau? Anau e kainno atu Akoe i te inoa TeAtua ki se lavaa te mee anau ki hakalono llihu!” ");
INSERT INTO nuq_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Te tama raa e meake peenei, e mee Jisas e tattara ake ma, “Te tipua sakkino, hamai i taha ma te tama naa!”) ");
INSERT INTO nuq_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kito Jisas ki vahiri ake te tama raa, “Koai te inoa akoe?” Tena te tama raa ki meake, “Te inoa anau ko, ‘He kautana’, e mee maatou e tammaki roo!” ");
INSERT INTO nuq_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Te tama raa e tuu koi no kainonno ake Jisas ma ki se lavaa te hakaise na tipua raa i taha ma te kina raa. ");
INSERT INTO nuq_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tena e isi na piki tammaki roo e kaikkai tappiri ake i te vahi te mouna raa. ");
INSERT INTO nuq_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kito na tipua raa ki kainno ake Jisas ma, “Tiaki maatou ki huro i te kina na piki raa no uru i roto na piki raa.” ");
INSERT INTO nuq_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jisas e meake na tipua raa ki oo, tena na tipua raa ki huro i taha ma te tama raa no uru i roto na piki raa. Na piki raa hakaatoa kame e ttae rua simata, tena na piki raa ku huro na mahi roo laatou i te kina te mouna e motu hua raa no maoha i roto te vai raa no mallemo. ");
INSERT INTO nuq_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Na tama e lollohi na piki raa ku huro i roto te matakaina raa no paa te rono raa i na tama e nnoho vaa raa. Kito na tama raa ki oo no mmata hea ni kapihi ake i na piki raa, ");
INSERT INTO nuq_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ia te saaita na tama raa ni ttae iaa Jisas, na tama raa ku kkite hoki te tama ni isi tammaki na tipua i roto aia raa. Te tama raa ku noho i te kina raa, ku oti te hakareureu ria na paamaro, iaa te hakataakoto aia raa hoki ku tauareka, tena na tama raa hakaatoa ku mattaku. ");
INSERT INTO nuq_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Na tama ni kkite raa ku tattara ake na tama raa hea ni kapihi ake i te tama e isi na tipua i roto aia raa ia ma na piki raa. ");
INSERT INTO nuq_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kito na tama raa ki meake Jisas ki tiaki te matakaina laatou raa no haere. ");
INSERT INTO nuq_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jisas ku mee ki kake i roto te vaka raa, tena te tama ni isi na tipua i roto aia raa ku meake ma, “Tiaki anau ki tautari Akoe.” ");
INSERT INTO nuq_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Emeia Jisas se hihai ma te tama raa ki haere ake. Kito Aia ki meake te tama raa ma, “Vaakai i hare i na hareakina akoe raa, tena ku tattara ake na tama raa hea TeAtua ni ppena i akoe ia ma te laoi hoki Aia ni huri atu akoe raa.” ");
INSERT INTO nuq_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kito te tama raa ki haere no haere vaa roto Dekapolis no tattara ake na tama na kina raa hea Jisas ni ppena i aia raa. Na tama hakaatoa e llono raa ku mahharo roo. ");
INSERT INTO nuq_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas ku vaakai i teeraa vahi te namo raa hoki, tena he kanohenua e rahi roo ku mmui ake Aia i te taunatai. ");
INSERT INTO nuq_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jairus te tama hakamaatua te hare lotu raa ku tae ake, tena te saaita aia ni kite Jisas, aia ku tteiho no tuturi i mua na vae Tama raa ");
INSERT INTO nuq_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","no tattara hakaaroha ake roo iaa Jisas ma, “Te tamariki hine anau raa e laavea hai mahi roo. Hamai ki oo taaua ki haere Akoe no hakapiri na rima Akoe raa i aruna te tamariki raa ki tauareka te tamariki raa no ora.” ");
INSERT INTO nuq_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tena Jisas ki oo laaua ma Jairus. Ia e tammaki hoki na tama e oo ma Jisas, tena na tama raa ku haere muimui roo na vahi Jisas. ");
INSERT INTO nuq_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tena he hine i te kina raa e hakalono llihu haeo roo i roto sanahuru ma rua na hetau, e mee te toto aia raa e tettere koi peenaa. ");
INSERT INTO nuq_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Te hine raa ni haere no mmata tammaki na dokta ki tokonaki aia. Te hine raa e llano roo e hia na sileni, e meia te maahana aia raa e haere mahi koi na vahao hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Te hine raa e rono na mahi Jisas e isi raa, tena aia ki tautari atu vaa muri ma te kanohenua raa, ");
INSERT INTO nuq_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","tena ki tattara hokoia ma, “Anau e me ki tauareka kame anau e ttaohi koi na hekau te Tama nei.” ");
INSERT INTO nuq_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Te hine raa e haaro atu no ttaohi te kaukahu Jisas raa, tena te toto e tettere raa ku hakamotu vahao naa koi, tena aia ku rono roo te tere maatara ia ma te tauareka i roto te tinotama aia. ");
INSERT INTO nuq_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Te saaita naa koi Jisas ku iroa ma e isi na mahi ni oo i taha ma Aia, kito Aia ki hakatike no vahiri ake te kanohenua raa ma, “Koai te tama ni ttaohi te kaukahu Anau raa?” ");
INSERT INTO nuq_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kito na disaipol raa ki meake, “Akoe e iroa pera ma te kanohenua nei e mmui atu roo Akoe; kaa Akoe e vahiri ma koai te tama e ttaohi Akoe naea?” ");
INSERT INTO nuq_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Emeia Jisas e tuu koi no kkira hakataka ma ki kite Aia te tama ni ttaohi te kaukahu Aia raa. ");
INSERT INTO nuq_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Te hine raa ku iroa hea ni kapihi ake i aia raa, tena aia ki haere porepore atu roo i te mataku no tuturi i mua na vae Jisas, tena ki tattara ake hakamaoni ake iaa Jisas. ");
INSERT INTO nuq_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kito Jisas ki meake te hine raa, “Taku tama, te hakatina akoe naa e mee akoe no tauareka. Haere ma te tauareka, na hakalono llihu akoe raa hakaatoa ku oti.” ");
INSERT INTO nuq_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisas koi tattara ake koi, tena na tama ni oo mai i te hare Jairus raa ku ttae ake no meake ma, “Te tamariki hine akoe raa ku mate. Tena tiaki, auu se anaana atu te Rabai naa!” ");
INSERT INTO nuq_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Emeia Jisas se anaana atu hoki na tattara na tama raa, tena Aia ki meake Jairus ma, “Auu se mataku, akoe ki hakatina koi.” ");
INSERT INTO nuq_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tena Jisas ki ppui ki se hai tama hoki e haere ake ma Aia, tena Aia ki too koi Pita, tena Jems laaua ma te taina aia raa Jon. ");
INSERT INTO nuq_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Na tama raa e oo no ttae i te hare Jairus raa, tena Jisas ku kite te ttani huri na tama raa hakamaroa. ");
INSERT INTO nuq_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tena Aia ki uru atu i hare no meake na tama raa ma, “Kootou e ttani huri peenaa naea? Kootou e tanittani naea? Te tamariki hine naa se mate; te tamariki hine naa e moe koi!” ");
INSERT INTO nuq_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Na tama raa ku katakkata ake iaa Jisas, kito Jisas ki hakaise na tama raa hakaatoa i aho, tena Aia ki too koi te tamana ma te tinna te tamariki hine raa ia ma te tokotoru na disaipol raa, tena laatou ki oo i te rum te tamariki raa e moe raa. ");
INSERT INTO nuq_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kito Jisas ki ttaohi te rima te tamariki hine raa, tena ki meake, “Talita koum,” e mee ma, “Tamariki hine, Anau e meatu akoe ki mahike i aruna!” ");
INSERT INTO nuq_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tena koi te tamariki hine raa ku mahike i aruna no hahaere. (Te tamariki hine raa ku tae sanahuru ma rua na hetau te matua aia.) Na tama raa hakaatoa ku mahharo roo te saaita te tamariki raa ni mahike no hahaere. ");
INSERT INTO nuq_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tena Jisas ki tattara hakamataku ake na tama raa ki se tattara ake ni tama, tena Aia ki meake hoki ma, “Kou ake ni kai ki kai te tamariki nei.” ");
INSERT INTO nuq_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas ku tiaki te kina raa no haere i te matakaina Aia ni matua mai raa, tena na disaipol Aia raa ku tauttari atu vaa muri. ");
INSERT INTO nuq_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jisas e kaamata no akoako i roto te hare lotu na Jiu raa i te aho te Sabat. Tammaki na tama e nnoho i te kina raa, tena te saaita laatou ni llono na tattara Jisas raa, na tama raa ku mahharo roo, tena ki vahihhiri ma, “Te Tama nei e too na hakataakoto raa i hee? Teenei he atamai Tama nei e too i hee? Kaa Aia e ppena peehee na mirakol raa? ");
INSERT INTO nuq_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Aiea te Tama nei seai ma ko te tama hakatuutuu hare raa, tena Aia seai ma ko te tamariki Meri, ia na taina Aia raa seai ma ko Jems, Josep, Judas, tena Saimon? Aiea na kaave Aia raa se nnoho hoki i te kina nei?” Tena na tama te matakaina raa ku se hihhai Jisas. ");
INSERT INTO nuq_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kito Jisas ki meake na tama raa, “Na profet e hihhai ria i na matakaina roo hakaatoa, e meia i te matakaina roo aia, na hareakina ia ma na tama roo te manava aia raa e me ki se hihhai te profet naa.” ");
INSERT INTO nuq_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jisas ku se lavaa hoki te ppena ni mirakol i te kina raa, e meia Aia e hakapiri na rima Aia raa i aruna na tama lavvea moisi koi no taualleka. ");
INSERT INTO nuq_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jisas e mahharo roo, e mee na tama raa se isi na hakattina. Tena Jisas ki haere no akoako na tama i na matakaina e ttuu alleha vaa raa. ");
INSERT INTO nuq_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jisas e kanna ake te sanahuru ma rua na disaipol raa, tena ki kauna na tama raa ki oo taki tokorua. Aia e kou ake na mahi na tama raa ki hakaise na tipua, ");
INSERT INTO nuq_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","tena Aia ki tattara ake hoki na tama raa ma, “Auu se too hoki ni mee peeraa no oo ma kootou, e meia too koi he laakau hahaere, tena auu se too ni haraoa, he muri kopu ia ma ni sileni. ");
INSERT INTO nuq_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Uru ni taka, tena auu se too hoki teeraa kaukahu.” ");
INSERT INTO nuq_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jisas e tattara ake hoki ma, “Kame he matakaina e too hakaraoi kootou, tena kootou ku nnoho te matakaina naa i roto te hare hokotahi koi ki tae roo te saaita kootou e tiaki te matakaina naa. ");
INSERT INTO nuq_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kame kootou e oo no ttae he matakaina, tena na tama te matakaina naa ku se hihhai ki too ia ma ki hakallono kootou, tena kootou ku tiaki te matakaina naa, tena ku ttahi na kkere e mmau na tapuvae kootou raa. Teenaa he hakkatu haeo i te matakaina naa.” ");
INSERT INTO nuq_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kito na disaipol raa ki oo no takutaku ake na tama raa ki ttike i taha ma na hai sara laatou. ");
INSERT INTO nuq_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Na disaipol raa e hakaise tammaki na tipua, tena ki amuhi tammaki na tama lavvea raa ma na lloo na oliv raa no taualleka. ");
INSERT INTO nuq_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Te saaita naa te tuku Herot raa ku rono tammaki na mee tera Jisas ni ppena raa, e mee na tama hakaatoa ku llono i na mahi Jisas e isi raa. Alaa tama e tattara ma, “Jon Baptis ku ora hakaraoi! Tera hea aia e isi na mahi peenei ki ppena na mirakol raa.” ");
INSERT INTO nuq_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Alaa tama e tattara ma, “Te Tama raa ko Elaija.” Tena alaa tama e tattara ma, “Te Tama raa he profet e ssau koi pera ma na profet i mua raa.” ");
INSERT INTO nuq_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herot ku rono na tattara nei, tena aia ki meake ma, “Te Tama naa ko Jon Baptis! Anau ni meake na soldia anau raa ki oo no ssepe te pohouru te tama naa no hopo, ia tena aia ku ora muri hakaraoi!” ");
INSERT INTO nuq_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herot hokoia ni meake na soldia aia raa ki hakapiki Jon, tena ku haihai te tama raa ma na seni no ppono i roto te hare karapusi. Herot e ppena peenei e mee Herodias te hine aia ku avana raa, maitaname te hine raa he avana Filip te taina koi aia raa. ");
INSERT INTO nuq_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jon Baptis e tattara tahi ake Herot ma, “Te mee naa e sara ma akoe ki too te avana te taina akoe raa no avvana koorua!” ");
INSERT INTO nuq_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias ku noho ma te roto aia iaa Jon, tena aia ku hihai roo ma ki taa tama raa ki mate, e meia aia se lavaa e mee Herot. ");
INSERT INTO nuq_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herot e mataku Jon, e mee aia e iroa ma Jon he tama tauareka, ia he tama e tapu, tena aia e rorohi hakaraoi roo tama raa. Herot e hihai ki hakarono na tattara Jon raa, niaina roo ma aia se tauareka i roto aia na vahao hakaatoa aia e rono Jon e tattara raa. ");
INSERT INTO nuq_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tena ki oti roo Herodias ku isi te ara ki taa Jon ki mate. Teenaa he aho Herot e pena te kai ma ki kkai laatou ma na tama hakamattua te taumani raa, na soldia hakamattua raa ia ma na tama hakamattua i roto Galili raa ki mannatu laatou te aho aia ni haanau mai raa. ");
INSERT INTO nuq_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Te taukupu Herodias raa ku haere ake no ruerue vaa hare, tena Herot ma na tama i hare raa ku hihhia roo. Kito Herot ki meake te taukupu raa ma, “Hea akoe e hihai ki too? Anau e me ki kou atu he mee peehee akoe e kainno mai anau ki kou atu.” ");
INSERT INTO nuq_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Herot e kou ake te taukupu raa tammaki roo na hakataakoto, tena aia ki meake, “Anau e tattara te hakamaoni pera ma anau e me ki kou atu he mee peehee akoe e kainno mai anau ki kou atu, niaina akoe e kainno mai anau ki kou atu he vahi na mee hakaatoa i roto te nohorana anau nei!” ");
INSERT INTO nuq_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kito te taukupu raa ki haere no vahiri ake te tinna aia raa ma, “Hea anau e me ki kainno ake naa?” Tena te hine raa ki meake, “Te pohouru Jon Baptis.” ");
INSERT INTO nuq_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tena te taukupu raa ki haere hakavave roo no meake ma, “Anau e hihai akoe ki pare mai te pohouru Jon Baptis raa vahao nei roo koi i aruna he parete!” ");
INSERT INTO nuq_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Te mee nei e mee roo Herot no aroha, e meia aia ku se hai ara hoki e lavaa te ttuki te hakataakoto raa, e mee aia ku oti te tattara hakamaoni ake te taukupu raa i mua na tama hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kito Herot ki kauna te soldia aia raa ma ki haere no kou mai te pohouru Jon raa. Tena te soldia raa ku haere i roto te hare karapusi raa no ssepe te pohouru Jon raa no hopo, ");
INSERT INTO nuq_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","tena aia ki pare te pohouru raa i aruna te parete, tena ki haere ake no kou ake te taukupu raa, tena te taukupu raa ki too te pohouru raa no kou ake te tinna aia raa. ");
INSERT INTO nuq_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Na disaipol Jon raa ku llono ma Jon ku mate, tena na tama raa ki oo ake no too te tinotama raa no kkave no tanu. ");
INSERT INTO nuq_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Na aposol Jisas raa ku vakkai ake no ttiri Jisas, tena ki tattara ake Tama raa na mee hakaatoa laatou ni ppena ia ma hea laatou ni akoako raa. ");
INSERT INTO nuq_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tena Jisas ma na disaipol Aia raa ku se isi te saaita e ttana ki nnoho no kkai e mee na tama e oo ake ia ma na tama e oo raa e tammaki roo. Kito Jisas ki meake na disaipol Aia raa, “Taatou ki oo hokotaatou i te kina se hai tama raa no hamalollo hakamarie.” ");
INSERT INTO nuq_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tena Jisas ma na disaipol Aia raa ki kkake te vaka raa no huro hokolaatou i te kina se hai tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Emeia tammaki na tama e kkite te saaita na tama raa ni tere, tena na tama raa e illoa koi i te kina na tama raa e tere raa; kito na tama raa ki oo vaa roto na matakaina raa no huro i mua i te kina Jisas ma na disaipol Aia raa e tere raa. ");
INSERT INTO nuq_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jisas ku tiho i taha ma te vaka raa no kite te kanohenua e rahi raa, tena Aia ku aroha roo i na tama raa, e mee na tama raa e ssau pera ma ni sipsip se isi te tama e rorohi. Tena Aia ki akoako ake tammaki na mee i na tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Te mee raa ku haere ki pouri, tena na disaipol raa ku oo ake no meake Jisas ma, “Te mee raa ku haere ki pouri, tena te kina nei hoki se isi na tama. ");
INSERT INTO nuq_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kauna na tama nei ki oo, tena ku tiaki laatou ki oo i na matakaina tappiri mai raa no ssui ni kai ma laatou no kkai.” ");
INSERT INTO nuq_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tena Jisas ki meake, “Kootou ki kou ake ni kai ma na tama nei ki kkai.” Kito na disaipol raa ki meake, “Akoe e hihai ma maatou ki too rua huitarau na sileni no sui ni haraoa ki hannai na tama nei?” ");
INSERT INTO nuq_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tena Jisas ki meake na disaipol raa, “Oo no mmata ma e hia na haraoa kootou e isi!” Na tama raa e oo no mmata, tena ki meake Jisas ma, “E rima na haraoa ia ma na ika e rua.” ");
INSERT INTO nuq_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tena Jisas ki tattara ake na disaipol raa ki meake te kanohenua raa ki vaevae no nnoho i na kuturana i aruna na veve. ");
INSERT INTO nuq_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kito te kanohenua raa ki nnoho hakalaini i na kuturana. Na kuturana e ttae huitarau, tena alaa kuturana e ttae tipu rima. ");
INSERT INTO nuq_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tena Jisas ki too e rima na haraoa raa ia ma e rua na ika raa, tena ki kkira i te vaelani no hakatapu na mee raa. Kito Jisas ki tohitohi na haraoa raa, tena ki kou ake na haraoa ia ma na ika e rua raa i na disaipol raa ki vaevae ake te kanohenua raa. ");
INSERT INTO nuq_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Na tama raa hakaatoa e kkai no ppohu. ");
INSERT INTO nuq_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tena na disaipol raa ki haere sasao na haraoa ia ma na punnohi e ttoe raa no ppii sanahuru ma rua na kete. ");
INSERT INTO nuq_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Te kooina na taanata e kkai raa e ttae rima simata. ");
INSERT INTO nuq_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Te saaita naa koi Jisas ku meake na disaipol Aia raa ki kkake te vaka raa no tere i mua i Betsaida i teeraa vahi te namo raa, tena Aia ki kauna te kanohenua raa ki oo. ");
INSERT INTO nuq_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jisas e kou ake te tauareka i te kanohenua raa no oti, tena Aia ki haere i te kina te mouna raa no lotu. ");
INSERT INTO nuq_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Te mee raa ku hiahi roo, tena te vaka na disaipol raa ni tere raa ku tae i lottonu roo te namo, e meia Jisas e noho koi Hokoia i uta. ");
INSERT INTO nuq_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jisas e kite na disaipol raa e hai roo na mahi ma na hoe laatou raa, e mee te matani raa e ppui mai roo i mua, tena Jisas ki haere atu vaa aruna te lottai raa. Tena i lottonu te toru ma te ono te tahata, Jisas ku ttiri na tama raa. Jisas e haere ma ki haere hakaraka, ");
INSERT INTO nuq_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","tena na disaipol raa ku kkite Jisas e haere vaa aruna te lottai raa, tena na tama raa ku kapihi na varo laatou ma, “Teenaa he tipua!” ");
INSERT INTO nuq_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Na disaipol raa hakaatoa ku mattaku te saaita laatou ni kkite Tama raa. Kito Jisas ki tattara ake na disaipol raa ma, “Teenei ko Nau, auu se mattaku!” ");
INSERT INTO nuq_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tena Aia ki kake i roto te vaka raa, tena te matani raa ku tteiho no marino. Na disaipol raa ku mahharo roo, ");
INSERT INTO nuq_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","e mee laatou se illoa te hakataakoto hakamaoni tera Jisas ni haanai rima simata na taanata raa, e mee na hakataakoto hoki laatou raa koi pouri. ");
INSERT INTO nuq_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Na tama raa e tere vaa roto te namo raa no ttae i Genesaret i teeraa vahi, tena laatou ki taura te vaka raa i te kina raa. ");
INSERT INTO nuq_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Na tama raa ku ttiho i taha ma te vaka raa no oo, tena na tama i te kina raa ku mattino ma teeraa ko Jisas. ");
INSERT INTO nuq_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kito na tama raa ki huro tattara vaa roto na matakaina raa hakaatoa, tena na matakaina e llono ma Jisas ku tae ake raa ku sausau ake na tama lavvea raa ma na lomoena laatou raa iaa Jisas. ");
INSERT INTO nuq_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Tena Jisas ku haere i na kina roo hakaatoa i na matakaina pammee raa, na matakaina e llahi raa ia ma na kina na tama e nnoho vaa roto raa, tena na tama na kina raa ku sausau ake na tama e lavvea raa i na maket, tena ki meake Jisas ki tiaki na tama lavvea raa ki ttaohi koi na kaunutu te kaukahu Tama raa, tena na tama hakaatoa e ttaohi te kaukahu Jisas raa ku taualleka. ");
INSERT INTO nuq_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","E isi na Farisi ia ma na tama poroporo na tuaa e oo mai peeraa i Jerusalem no kkutu laatou ma Jisas. ");
INSERT INTO nuq_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Na Farisi raa e kkite ma na disaipol Jisas raa e kkai na kai ma na rima e kkere. Na disaipol raa se ssoro na rima laatou raa pera ma hea na Farisi raa ni poroporo ake na tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(E mee na Farisi ia ma na Jiu raa hakaatoa e tauttari na tiputipu na tipuna laatou i mua raa, tena na tama raa se lavaa te kkai kame laatou se ssoro hakaraoi na rima laatou, ");
INSERT INTO nuq_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ia hoki na tama raa se lavaa te kkai na kai i te maket kame laatou se ssoro na mee raa i mua. Na tama raa e tauttari hoki tammaki na tiputipu laatou ni too i mua pera ma na tiputipu te ssoro na kapu, na hopeni, na dis ia ma na sea mommoe raa.) ");
INSERT INTO nuq_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kito na Farisi laatou ma na tama poroporo na tuaa raa ki vahiri ake Jisas ma, “Aiea na disaipol Akoe raa se tauttari na tiputipu taatou ni too i na tipuna taatou i mua raa, tena na tama raa e kkai se ssoro na rima laatou raea?” ");
INSERT INTO nuq_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Kito Jisas ki meake, “Na tattara Aisaia raa ku ttonu roo te saaita aia ni tattara i te vahi kootou! Kootou ni tama tattara uhiuhi e ssau pera ma Aisaia ni taataa mai raa, ‘TeAtua e tattara ma na tama raa e hakammaha Anau ma na tattara laatou, e meia na hatu manava laatou raa e mmao roo i taha ma Anau. ");
INSERT INTO nuq_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Na tama naa e hakamarumaru vare koi Anau, e mee laatou e akoako na tuaa na tama raa pera ma ni tuaa TeAtua!’ ");
INSERT INTO nuq_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kootou e peesia na tuaa TeAtua raa, tena ki tauttari koi na akoako na tama.” ");
INSERT INTO nuq_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Tena Jisas ki meake hoki, “Kootou e illoa roo na ara ki peesia na tuaa TeAtua raa, tena ki tauttari koi na akoako na tama. ");
INSERT INTO nuq_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Maitaname Moses ni tattara mai ma, ‘Hakammaha na tamana, ia ma na tinna kootou raa,’ tena e tattara hoki ma, ‘Te tama e haru na haeo te tamana, ia ma te tinna aia raa e me ki taia ria ki mate.’ ");
INSERT INTO nuq_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Emeia kootou e akoako ma kame he tama e isi na mee tera aia e lavaa te tokonaki te tamana ia ma te tinna aia raa, tena aia ku tattara ma, ‘Na mee nei anau ku oti te tattara ma ki kou ake ma TeAtua’, ");
INSERT INTO nuq_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","tena aia e isi te hakataakoto tauareka ki se tokonaki te tamana ia ma te tinna aia raa. ");
INSERT INTO nuq_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ia tena na akoako peenei kootou e kou ake na tama raa e uhi na tattara TeAtua raa ki mee pera ma ni tattara vare koi. Ia tena kootou e ppena hoki tammaki na mee peenei.” ");
INSERT INTO nuq_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tena Jisas ki kanna ake te kanohenua raa ki oo ake hakaraoi, tena Aia ki meake, “Kootou hakaatoa ki hakallono mai Anau ki illoa kootou. ");
INSERT INTO nuq_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Se isi te mee i aho e haere i roto te tama no mee te tama raa ki hai sara. Emeia na mee e oo mai i taha ma te tama raa e mee te tama raa ki hai sara.” ");
INSERT INTO nuq_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Hakallono kame kootou e isi na katarina. ");
INSERT INTO nuq_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Te kanohenua raa ku tiaki te kina raa no oo i na hare, kito na disaipol Jisas raa ki meake Tama raa ki tattara ake te hakataakoto te tattara raa. ");
INSERT INTO nuq_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Tena Jisas ki meake, “Kootou hoki se atamai? Kootou se illoa? Se isi te mee i aho e haere i roto te tama no mee te tama raa ki hai sara, ");
INSERT INTO nuq_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","maitaname na mee raa se uru i roto te hatu manava, e meia na mee raa e uru i roto te kopu raa, tena ki oti ku oo mai i taha ma te tinotama.” (Na tattara nei, Jisas e huri mai pera ma taatou e lavaa te kkai na kai hakaatoa.) ");
INSERT INTO nuq_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tena Jisas ki meake hoki ma, “Aanaa ko na mee e oo mai i taha ma te tama raa e mee te tama ki se matahua. ");
INSERT INTO nuq_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Maitaname na hakataakoto e hakattaki laatou ki ppena na tiputipu sakkino raa e oo mai i roto te hatu manava te tama; na hakataakoto ki ppena na mee sakkino, ki kailallao, ki taa te tama ki mate, ");
INSERT INTO nuq_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ki ppena na mee sakkino ma teeraa tama, ki kai mannako, ia ki ppena na tiputipu sakkino hakaatoa, ki hai lavvaka, ki hai huri, ki manava kkere, ki tattara tama, ki hai ahu, tena ki ppena na hakataakoto e vvare raa. ");
INSERT INTO nuq_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Na tiputipu sakkino nei hakaatoa e hhopo iho i roto te tama no mee te tama ki se matahua.” ");
INSERT INTO nuq_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tena Jisas ki tiaki te kina raa no haere i te kina e taapiri te matakaina Taia raa. Tama raa e haere no uru i roto te hare e mee Aia se hihai ma na tama ki illoa ma Aia e noho i te hare raa, e meia Aia e laavea ria koi. ");
INSERT INTO nuq_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","He hine te tamariki hine aia raa e isi te tipua e tau i roto aia ku rono ma Jisas ku tae ake, tena aia ki haere atu no tteiho no tuturi i mua na vae Jisas. ");
INSERT INTO nuq_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Te hine raa seai ma he Jiu, tena aia e haanau mai i te matakaina Fonisia i roto Siria. Te hine raa e kainno ake Jisas ki hakaise te tipua raa i taha ma te tamariki hine aia raa. ");
INSERT INTO nuq_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Emeia Jisas e meake, “Taatou ki hannai na tamalliki raa i mua. Tena e me ki se tonu kame taatou e too na kai na tamalliki raa no kou ake na poi raa ki kkai.” ");
INSERT INTO nuq_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kito te hine raa ki meake, “TeAriki, na poi raa hoki e kkai na maanunu na tamalliki raa e teiho i raro ma te tebol!” ");
INSERT INTO nuq_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tena Jisas ki meake, “Haere i hare, tena akoe e me ki kite pera ma te tipua raa ku oti te haere i taha ma te tamariki hine akoe raa, e mee koi te tattara akoe ni mee mai raa!” ");
INSERT INTO nuq_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Te hine raa ku haere i hare no kite te tamariki raa e moe i aruna te sea mommoe raa; te tipua raa ku oti te haere hakamaoni i taha ma te tamariki raa. ");
INSERT INTO nuq_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisas e tiaki te matakaina taapiri ake Tair raa no haere vaa roto Saidon, tena ki haere peeraa i te Namo Galili raa. Aia e haere vaa roto na kina tappiri Dekapolis raa. ");
INSERT INTO nuq_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Na tama te matakaina raa e hakattaki ake te tama na katarina e tturi, ia se lavaa hoki te tattara. Na tama raa e kainno ake Jisas ki hakapiri na rima Aia raa i aruna te tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kito Jisas ki too te tama raa hokoia koi no hakattaki i taha ma te kanohenua raa, tena ki taro na matarima Aia raa i roto na katarina te tama raa, tena ki savare no mmuru na savare Aia raa i aruna te arero te tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tena Aia ki kkira i te vaelani, tena ki too te maanava Aia, tena ki meake ma, “Efata”, te tattara nei e mee ma, “Taaraki!” ");
INSERT INTO nuq_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Te saaita naa koi te tama raa ku rono, tena te arero aia raa ku lavaa te tattara tonu na tattara. ");
INSERT INTO nuq_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kito Jisas ki meake na tama raa ki se tattara ake na tama hea Aia ni ppena raa; e meia na saaita Aia e tattara ake na tama raa ki se tattara raa, na tama raa e oo koi no haere tattara. ");
INSERT INTO nuq_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tena na tama hakaatoa e llono raa ku mahharo roo. Na tama raa e tattara ma, “Na mee hakaatoa te Tama nei e ppena raa e taualleka! Aia e mee hoki na tama katarina tturi raa ki llono, tena na tama se lavaa te tattara raa ku tattara!” ");
INSERT INTO nuq_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tena he kanohenua e rahi hoki ku oo ake iaa Jisas raa. Te kanohenua raa se isi na kai e me ki kkai, tena Jisas ki kanna ake na disaipol Aia raa no meake ma, ");
INSERT INTO nuq_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Anau e aroha te kanohenua nei e mee na tama nei e nnoho roo ma Anau e toru na aho, tena laatou ku se hai kai e me ki kkai. ");
INSERT INTO nuq_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kame Anau e kauna na tama nei ki oo se hai kai e kou ake ki kkai, na karemata na tama nei e me ki pouri te saaita laatou e vakkai raa, maitaname alaa tama na tama nei e oo mai roo na matakaina e mmao.” ");
INSERT INTO nuq_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kito na disaipol raa ki vahiri ake ma, “Kaa maatou e me ki too ni kai i hee i te kina se hai tama e tuu mahoa nei ki hannai na tama nei hakaatoa?” ");
INSERT INTO nuq_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Kito Jisas ki vahiri ake, “E hia na haraoa kootou e isi?” Tena na disaipol raa ki meake ma, “E hitu na haraoa.” ");
INSERT INTO nuq_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kito Jisas ki meake te kanohenua raa ki nnoho i raro, tena Aia ki too na haraoa e hitu raa no lotu ake TeAtua, tena ki ttohi na haraoa raa no kou ake na disaipol Aia raa ki vaevae ake i te kanohenua raa, tena na disaipol raa ku too na haraoa raa no vaevae. ");
INSERT INTO nuq_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Na tama raa e isi hoki na paa ika e moisi, tena Jisas ki too na ika raa no lotu ake TeAtua, tena ki meake na disaipol raa ki vaevae hoki na ika raa. ");
INSERT INTO nuq_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","9 Na tama raa hakaatoa e kkai no ppohu. Tena te kooina na tama e kkai raa hakaatoa e tae peeraa haa simata na tama. Tena na disaipol raa ki sasao na kai e ttoe raa no ppii e hitu na kete. Kito Jisas ki meake te kanohenua raa ki oo, ");
INSERT INTO nuq_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","tena Aia ma na disaipol Aia raa ki kakke te vaka raa no tere i Dalmanuta. ");
INSERT INTO nuq_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","E isi na Farisi e oo ake no hakatauttau laatou ma Jisas. Na tama raa e hihhai ki taaiki Tama raa, kito na tama raa ki meake Jisas ki ppena he mirakol ki huri ake pera ma TeAtua ni kauna ria mai Tama raa hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kito Jisas ki maanava hakamaroa roo, tena ki meake, “Aiea kootou na tama te aho nei raa e hihhai ki kkite he mirakol naea? Anau e meatu se lavaa! Anau se lavaa te huri atu he mirakol ki kkite kootou!” ");
INSERT INTO nuq_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tena Jisas ki tiaki na Farisi raa, tena ki kake te vaka raa no tere hoki i teeraa vahi te namo raa. ");
INSERT INTO nuq_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na disaipol raa ku ssiri ki too hakallava na haraoa, e meia laatou e isi koi te haraoa hokotahi i roto te vaka. ");
INSERT INTO nuq_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Tena Jisas ki poroporo ake na tama raa ma, “Lollohi hakamattonu i te ist na Farisi ia ma te ist te tuku Herot raa.” ");
INSERT INTO nuq_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tena na disaipol raa ku tattara hokolaatou ma, “Tama raa e tattara peeraa e mee taatou se isi na haraoa.” ");
INSERT INTO nuq_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisas e iroa hea na disaipol raa e tattara raa, tena Aia ki vahiri ake na tama raa, “Aiea kootou e tattara hokkootou ma taatou se hai haraoa naea? Kootou se ki illoa roo na hakataakoto? Na kapuroro kootou naa koi vvare koi? ");
INSERT INTO nuq_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kootou e isi na karemata, eaa kootou se kkite? Kootou e isi na katarina, eaa kootou se llono? Kootou se mannatu ");
INSERT INTO nuq_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","te saaita Anau ni ttohi e rima na haraoa raa no haanai rima simata na taanata. E hia na kete kootou ni sassao no ppii na muri haraoa ni ttoe raa?” Kito na disaipol raa ki meake ma, “Sanahuru ma rua na kete.” ");
INSERT INTO nuq_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Tena Jisas ki meake, “Kaa te saaita Anau ni ttohi e hitu na haraoa no haanai e haa simata na taanata raa, e hia na kete kootou ni sassao no ppii na muri haraoa ni ttoe raa?” Kito na disaipol raa ki meake ma, “E hitu!” ");
INSERT INTO nuq_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tena Jisas ki meake, “Tena kaa kootou se ki illoa roo?” ");
INSERT INTO nuq_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jisas ma na disaipol Aia raa ku ttae i te matakaina Betsaida raa, tena na tama i te kina raa ku hakattaki ake te tama karemata sseni raa iaa Jisas, tena ki kainno ake ma Jisas ki kapake no ttaohi te tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kito Jisas ki ttaohi te rima te tama karemata sseni raa no hakattaki i taha ma te matakaina raa. Tena Jisas ki savare na karemata te tama raa no oti, tena Aia ki hakapiri na rima Aia raa i aruna te tama raa, tena ki vahiri ake ma, “Akoe e isi na mee e kite?” ");
INSERT INTO nuq_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Te tama raa ku ssau te pohouru aia raa i aruna no kkira ake, tena ki meake, “Noo, anau e kite na tama, e meia na tama raa e ssau pera ma ni laakau e hahaere.” ");
INSERT INTO nuq_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tena Jisas ki hakapiri hakaraoi na rima Aia raa i aruna na karemata te tama raa. Te saaita nei te tama raa ku kkira hakatauareka roo e mee aia ku lavaa te kite, tena aia ku kite hakaraoi roo na mee roo hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kito Jisas ki kauna te tama raa ki vaakai, tena ki meake, “Auu se vaakai i roto te matakaina raa.” ");
INSERT INTO nuq_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tena Jisas ma na disaipol Aia raa ku oo i na matakaina tappiri ake i Sisaria Filipai raa. Te saaita laatou ni oo vaa aruna te mateara raa, Jisas ku vahiri ake na disaipol Aia raa ma, “Mee mai Anau ma te kanohenua raa e tattara ma Anau koai?” ");
INSERT INTO nuq_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kito na disaipol raa ki meake, “Alaa tama e tattara ma Akoe ko Jon Baptis, tena alaa tama e tattara ma Akoe ko Elaija, tena alaa tama e tattara ma Akoe he profet na profet i mua raa.” ");
INSERT INTO nuq_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tena Jisas ki vahiri ake na disaipol raa, “Kaa kootou? Kootou e mannatu ma Anau koai?” Kito Pita ki meake, “Akoe ko te Mesaia.” ");
INSERT INTO nuq_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tena Jisas ki ppui ake na disaipol raa ma, “Auu se tattara ake ni tama i te vahi Anau.” ");
INSERT INTO nuq_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tena Jisas ki kaamata no akoako ake na disaipol Aia raa ma, “te Tamariki te Tama nei e me ki ttiri tammaki na hakalono llihu, tena na tama hakamattua na Jiu raa laatou ma na maatua hakananniu raa ia ma na tama poroporo na tuaa raa hakaatoa e me ki se hihhai te Tama raa. Tena na tama raa e me ki taa te Tama raa no mate. Tena i muri e toru na aho Tama raa e me ki mahike muri no ora.” ");
INSERT INTO nuq_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jisas e tattara hakamatahua ake roo te hakataakoto nei i na disaipol raa. Tena Pita ki hakattaki Jisas i te vahi, tena ki hai ake Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Emeia Jisas e hakatike no kkira ake na disaipol Aia raa, tena ki hai ake Pita ma, “Satan, haere i taha ma Anau, na hakataakoto akoe naa se oo mai TeAtua, e meia na hakataakoto naa ni hakataakoto koi te tama.” ");
INSERT INTO nuq_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tena Jisas ki kanna ake te kanohenua raa ma disaipol Aia raa ki oo ake, tena ki meake, “Kame ni tama kootou e hihhai ki tauttari Anau, te tama naa ki se maanatu te ora aia, tena ku amo te kros aia raa no tautari mai Anau. ");
INSERT INTO nuq_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kame he tama e manako te ora aia, te tama naa e me ki se lavaa te too te ora hakamaoni, e meia kame akoe e hoki mai te ora akoe raa ma Anau ia ma Te Rono Tauareka raa; tena akoe e me ki too te ora hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Hea akoe e me ki too kame akoe e ttino na mee hakaatoa i roto te maarama nei raa, e meia i roto te ora akoe raa e haeo roo? Se hai mee akoe e me ki too! ");
INSERT INTO nuq_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Se hai mee hoki akoe e lavaa te hoki ake ki sui muri te ora akoe raa. ");
INSERT INTO nuq_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Kame akoe e napa Anau ia ma na poroporo Anau raa i roto na aho e pii na hai sara nei, tena te Tamariki te Tama nei e me ki napa hoki akoe te saaita Aia e hamai ma na mahi te Tamana Aia raa ia ma na ensel e ttapu raa.” ");
INSERT INTO nuq_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Tena Jisas ki meake hoki na disaipol Aia raa ma, “Anau e meatu kootou, e isi na tama i te kina nei e me ki kkite te Hakamaatua ana i te Vaelani raa e hamai ma na mahi hai mmahi i mua laatou e mmate.” ");
INSERT INTO nuq_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","E ono na aho ku llaka, tena Jisas ki too Pita, Jems ia ma Jon no hakattaki i aruna te mouna raa, tena laatou hokolaatou koi ku nnoho i te kina raa. Na tama raa e nnoho no kirakira ake, tena te tinotama Jisas raa ku haere no kee roo, ");
INSERT INTO nuq_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","na hekau Aia e uru raa ku makkini hua roo; se hai tama i te maarama nei e lavaa te kkumi na hekau raa ki makkini roo peeraa. ");
INSERT INTO nuq_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tena te tokotoru na disaipol raa ku kkite hoki Elaija laaua ma Moses e tattara laatou ma Jisas. ");
INSERT INTO nuq_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kito Pita ki meake Jisas ma, “Rabai, e tauareka roo e mee maatou e nnoho i te kina nei! Maatou e me ki hakatuu e toru na paa hare, te paa hare Akoe, te paa hare Moses, tena te paa hare Elaija.” ");
INSERT INTO nuq_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita ma teeraa tokorua ku mattaku roo, tena Pita ku se iroa ma aia ki tattara ake peehee. ");
INSERT INTO nuq_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tena te pukureurehu raa ku haere iho no uhi na tama raa, tena TeAtua ku tattara iho i roto te pukureurehu raa ma, “Teenei he Tamariki roo Anau, tena Anau e laoi mahi roo. Hakallono na tattara Aia!” ");
INSERT INTO nuq_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tokotoru na disaipol raa ku kirakira huri roo, e meia laatou se hai tama e kkite; Jisas Hokoia koi ku ttuu ma laatou. ");
INSERT INTO nuq_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Te saaita laatou ni oo mai i raro te mouna raa, Jisas ku tattara ake na disaipol raa ma, “Auu se tattara ake ni tama hea kootou ni kkite raa ki tae roo te saaita te Tamariki te Tama nei e mahike muri i taha ma te mate raa.” ");
INSERT INTO nuq_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tokotoru raa e hakallono na tattara Jisas raa, e meia laatou e vahihhiri koi i roto laatou hokolaatou ma, “Te tattara e mee ma ‘mahike muri i taha ma te mate raa’ e mee maea?” ");
INSERT INTO nuq_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tena tokotoru raa ki vahiri ake Jisas ma, “Aiea kaa na tama poroporo na tuaa raa e tattara ma Elaija e me ki hamai i mua te Mesaia raea?” ");
INSERT INTO nuq_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Kito Jisas ki meake, “Hakamaoni Elaija e me ki hamai i mua te Mesaia raa no tanattana na mee hakaatoa. Aiea kaa te Launiu Tapu raa e tattara ma te Tamariki te Tama nei e me ki hakalono llihu haeo roo, ia e me ki se hihhai ria raea? ");
INSERT INTO nuq_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Anau e meatu kootou, Elaija ku oti te hamai, tena hea na tama raa ni ppena i te tama raa, na tama raa e ppena koi tautari hea laatou e hihhai, e ssau pera ma te Launiu Tapu raa e tattara i te vahi tama raa.” ");
INSERT INTO nuq_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jisas ma te tokotoru na disaipol raa ku oo no ttiri ma alaa disaipol, tena laatou ku kkite te kanohenua e rahi e tuu alleha e mee na tama poroporo na tuaa raa e hakatauttau ma na disaipol raa. ");
INSERT INTO nuq_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Te kanohenua raa ku oho no huro hihhia ake roo iaa Jisas te saaita laatou ni kkite Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tena Jisas ki vahiri ake na disaipol Aia raa ma, “Hea roo kootou ma na tama raa e hakatauttau raa?” ");
INSERT INTO nuq_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tena he tama i roto te kanohenua raa ki meake ma, “Rabai, anau e kou mai taku tamariki nei i Akoe raa e mee te tamariki nei e isi te tipua i roto aia, tena aia hoki se lavaa te tattara. ");
INSERT INTO nuq_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","He saaita peehee te tipua raa e tau i roto te tamariki nei, te tipua raa e me ki lletu te tama nei i raro, tena te araara raa ku kkoo iho, tena aia ku hakkati na niho aia raa, ia te tinotama aia raa hoki e me ki matakkau roo. Anau e kainno ake na disaipol Akoe raa ki hakaise te tipua raa i taha, e meia laatou se lavaa.” ");
INSERT INTO nuq_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Tena Jisas ki meake na disaipol raa, “Kootou ni tama roo se hakattina! E hia na vahao Anau e me ki nnoho ma kootou? Anau e me ki nnoho ma kootou ki ttae he saaita peehee hoki? Kou mai te tamariki naa i Anau!” ");
INSERT INTO nuq_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kito na tama raa ki hakattaki ake te tamariki raa. Te tipua raa e kite koi Jisas, tena aia ki lletu te tamariki raa no takapekape vaa raro te kerekere, tena te araara raa ku kkoo iho i te maihu. ");
INSERT INTO nuq_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kito Jisas ki vahiri ake te tamana te tamariki raa, “Te tamariki nei e kaamata vahao hee roo no meemee peenei?” Tena te tamana te tamariki raa ki meake ma, “Kaamata roo te saaita aia koi paamee. ");
INSERT INTO nuq_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ia tammaki roo na vahao te tipua raa e lletu te tamariki nei i roto te ahi ia ma i roto na vai ma ki mate. Ia kame Akoe e lavaa, Akoe ku aroha koi no tokonaki maaua!” ");
INSERT INTO nuq_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Tena Jisas ki meake, “Noo, Anau e lavaa kame akoe hokkoe e lavaa! Na mee hakaatoa e hainauhie koi kame te tama e isi te hakatina i TeAtua.” ");
INSERT INTO nuq_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tena te tamana te tamariki raa ku tani ake ma, “Anau e isi te hakatina i TeAtua, e meia te hakatina anau nei se tau. Tokonaki anau ki hai mahi te hakatina anau nei!” ");
INSERT INTO nuq_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jisas e kite pera ma te kanohenua raa ku kenekene ake no tappiri laatou, kito Aia ki hai ake te tipua raa. Aia e meake ma, “Te tipua e tturi, ia se lavaa te tattara, Anau e meatu akoe ki haere i taha ma te tamariki nei vahao nei roo koi, tena ku se lavaa hoki te vaakai mai i roto te tama nei.” ");
INSERT INTO nuq_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tena te tipua raa ki kapihi te varo aia raa no ssue hakahaeo roo no tere i taha ma te tamariki raa. Te tamariki raa ku moe hemuu roo pera ma he tama ku mate, tena te kanohenua raa ku tattara hokolaatou ma, “Te tamariki raa ku mate!” ");
INSERT INTO nuq_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tena Jisas ki ttaohi te rima tamariki raa no hakamahike, kito te tamariki raa ki mahike no tuu i aruna. ");
INSERT INTO nuq_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jisas ku haere no uru i hare raa, tena na disaipol raa ki vahiri hemuu ake Jisas ma, “Aiea maatou se lavaa te hakaise te tipua raa i taha raea?” ");
INSERT INTO nuq_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tena Jisas ki meake, “Te lotu koi e lavaa te hakaise na tipua peenei raa i taha, se hai mee peeraa hoki e lavaa.” ");
INSERT INTO nuq_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jisas ma na disaipol Aia raa ku tiaki te matakaina raa, tena ki oo peeraa i Galili. Jisas se hihai ma na tama raa ki illoa i te kina Aia e haere raa, ");
INSERT INTO nuq_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","e mee Aia e akoako ake na disaipol Aia raa ma, “te Tamariki te Tama nei e me ki noho i raro na mahi na tama e me ki taa Aia ki mate raa. Emeia i muri e toru na aho Aia e me ki mahike muri no ora.” ");
INSERT INTO nuq_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Emeia na disaipol raa se illoa te hakataakoto na akoako Jisas raa, tena laatou hoki e mattaku te vahiri ake Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jisas ma na disaipol Aia raa ku ttae i Kaperneam, tena ki oo no uru i roto he hare, tena ki oti Jisas ku vahiri ake na disaipol raa ma, “Hea kootou ni hakatauttau hokkootou i aruna te mateara raa?” ");
INSERT INTO nuq_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Na disaipol raa ku nnoho hemuu roo, e mee laatou ni hakatauttau i aruna te mateara ma koai te tama laatou e me ki hakanaaniu. ");
INSERT INTO nuq_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jisas ku noho i raro, tena ki kanna ake na disaipol raa no tattara ake na tama raa ma, “Te tama e hihai ma aia ki hakanaaniu raa ki tuku aia ki mouraro, tena ku hehekau ma na tama hakaatoa.” ");
INSERT INTO nuq_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tena Jisas ki too te tamariki raa no hakatuu i mua na disaipol raa hakaatoa, tena ki avei te tamariki raa, tena ki meake na tama raa, ");
INSERT INTO nuq_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Te tama e too hakaraoi na tamalliki peenei i te inoa Anau raa e too hakaraoi hoki Anau, tena te tama e too hakaraoi Anau raa se mee ma e too hakaraoi koi Anau, e meia aia e too hakaraoi hoki te Tama ni kauna ria mai Anau raa.” ");
INSERT INTO nuq_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tena Jon ki meake Jisas, “Rabai, maatou e kkite te tama e hakaise na tipua i te inoa Akoe. Tena maatou ki ppui te tama raa, maitaname te tama raa seai ma tama i roto te kuturana taatou nei.” ");
INSERT INTO nuq_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tena Jisas ki meake, “Auu se ppui te tama naa, maitaname te tama e ppena na mirakol peenei i te inoa Anau raa e hainattaa roo te ppehi na tattara haeo i te vahi Anau. ");
INSERT INTO nuq_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","E mee na tama se hakataukaa ma taatou raa ni tama i te vahi taatou. ");
INSERT INTO nuq_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Anau e meatu te hakamaoni pera ma kame he tama e kou atu na vai ki unu kootou e mee kootou e hukui ma Anau, te tama naa e me ki too hoki te tuhana aia. ");
INSERT INTO nuq_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Kame he tama e tatakore na tamalliki peenei raa ki tiaki na hakattina laatou i Anau raa, tena e tauareka roo ki nnoa he hatu e rahi te uaa te tama naa, tena ku lletu aia i roto te lottai ki maremo. ");
INSERT INTO nuq_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tena kame te rima akoe raa e mee akoe ki tiaki te hakatina akoe raa, tena tuu te rima naa ki hopo! E tauareka akoe te too te ora hakamaoni ma te rima hokotahi. Ka oti akoe ku noho ma saa rima akoe raa no haere i te kina te ahi e ura tahi se lavaa te mate raa. ");
INSERT INTO nuq_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Na roo e kkai na tama i te kina raa se lavaa te mmate, ia te ahi hoki e me ki ttuni na tama i te kina raa se lavaa te mate. ");
INSERT INTO nuq_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Tena kame te vae akoe raa e mee akoe ki tiaki te hakatina akoe raa, tena tuu te vae naa ki hopo! E tauareka akoe te too te ora hakamaoni ma te vae hokotahi. Ka oti akoe ku noho ma saa vae akoe raa no haere i te kina te ahi e ura tahi raa. ");
INSERT INTO nuq_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Na roo e kkai na tama i te kina raa se lavaa te mmate, ia te ahi hoki e me ki ttuni na tama i te kina raa se lavaa te mate. ");
INSERT INTO nuq_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Tena kame te karemata akoe raa e mee akoe ki tiaki te hakatina akoe raa, tena kope te karemata naa i taha! E tauareka akoe te tae te Hakamaatua ana i te Vaelani raa ma te karemata hokotahi. Ka oti akoe ku noho ma saa karemata akoe raa no haere i te kina te ahi e ura tahi raa. ");
INSERT INTO nuq_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Na roo e kkai na tama i te kina raa se lavaa te mmate, ia te ahi hoki e me ki ttuni na tama i te kina raa se lavaa te mate. ");
INSERT INTO nuq_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“TeAtua e me ki mee na tama hakaatoa ki matahua ma te ahi e ssau pera ma te sol raa e mee na hoki raa no matahua. ");
INSERT INTO nuq_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Te sol raa e tauareka; e meia kame te sol raa ku se mmara, tena kaa akoe e me ki mee te sol raa ki mmara hakaraoi peehee? “Kootou ki too te tauareka te sol raa i roto kootou ki nnoho taualleka kootou ma na tama.” ");
INSERT INTO nuq_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tena Jisas ki tiaki te kina raa no haere i te matakaina Judia i teeraa vahi te riva Jordan raa. Tena na tama raa ku oo ake hakaraoi no mmui ake Jisas, tena Jisas ki akoako ake na tama raa pera ma na saaita Aia ni akoako i mua raa. ");
INSERT INTO nuq_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ia e isi na Farisi e oo ake no hahaivi ma ki taaiki Jisas, tena ki vahiri ake Tama raa ma, “Mee mai, na tuaa taatou raa e hakattana te tanata ki peesia te avana aia ma seai?” ");
INSERT INTO nuq_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tena Jisas ki meake “He tuaa peehee Moses ni kou atu kootou raa?” ");
INSERT INTO nuq_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kito na tama raa ki meake, “Moses e hakattana te tanata ki taataa ake he launiu i te avana aia raa ki iroa pera ma aia ku mee ki peesia te hine raa, tena ki oti aia ku meake te hine raa ki haere i taha.” ");
INSERT INTO nuq_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Kito Jisas ki meake, “Moses e taataa atu te tuaa nei e mee kootou e poro nattaa roo. ");
INSERT INTO nuq_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Emeia i te kaamata roo te saaita TeAtua ni pena te maarama nei raa, ‘TeAtua e pena te tanata ma te hine,’ teenei hea te Launiu Tapu raa e tattara ma, ");
INSERT INTO nuq_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Tera hea te taupeara raa e me ki tiaki te tamana ma te tinna aia raa no haere no hakapaa ma te hine aia raa, ");
INSERT INTO nuq_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","tena tokorua naa ku mee pera ma he tama hokotahi.’ Laaua ku se mee pera ma he tokorua, e meia tokorua raa ku hokotahi. ");
INSERT INTO nuq_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tena se hai tama e lavaa te vvae hea TeAtua ni hukui raa.” ");
INSERT INTO nuq_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jisas ma na disaipol Aia raa ku oo i hare, tena na tama raa ki vahiri ake hakaraoi i te vahi te pepeesia na avana raa. ");
INSERT INTO nuq_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tena Jisas ki meake, “Te tanata e peesia te hine aia raa no avana teeraa hine raa ku ppena te hai sara i te vahi te avvana huri. ");
INSERT INTO nuq_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ia e ssau peeraa hoki, te hine e peesia te tanata aia raa no avana teeraa tanata raa ku ppena te hai sara i te vahi hoki te avvana huri raa.” ");
INSERT INTO nuq_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","E isi na tama e kou ake na tamalliki laatou raa iaa Jisas ma Tama raa ki hakatapu na tamalliki raa, tena na disaipol Jisas raa ki haatua ake na tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jisas e kite hea na disaipol raa e ppena raa, tena Aia ki roto no meake na disaipol raa ma, “Tiaki na tamalliki naa ki oo mai Anau, auu se ppui na tamalliki naa maitaname te Hakamaatua ana i te Vaelani raa he kina hoki na tama peenei. ");
INSERT INTO nuq_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Anau e meatu kootou te hakamaoni, kame he tama se too te Hakamaatua ana i te Vaelani raa pera ma he tamariki paamee, te tama naa se lavaa roo te uru i roto te Hakamaatua ana i te Vaelani raa.” ");
INSERT INTO nuq_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tena Jisas ki ssau ake na tamalliki raa, tena ki hakapiri na rima Aia raa i aruna na tamalliki raa no hakatapu na tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisas ku tanattana ki haere hoki, tena he tanata ku tere ake no tuturi i mua Jisas, tena ki vahiri ake, “Rabai, Akoe e Tauareka roo, tena kaa hea anau e me ki ppena ki too te ora e ora tahi raa?” ");
INSERT INTO nuq_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Kito Jisas ki vahiri ake te tama raa ma, “Aiea akoe e mee ma Anau e tauareka naea? Se hai tama e tauareka, TeAtua Hokoia koi e tauareka. ");
INSERT INTO nuq_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Akoe e iroa na tuaa ma: ‘Se taa tama, se avvana huri, se kailallao, se tattara malliu alaa tama, se hai lavvaka alaa tama, tena ku hakammaha te tamana ma te tinna akoe raa?’ ” ");
INSERT INTO nuq_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tena te tama raa ki meake Jisas ma, “Rabai, anau e tautari roo na tuaa naa hakaatoa kaamata roo te saaita anau ni paamee raa.” ");
INSERT INTO nuq_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tena Jisas ki kkira hakatauareka ake roo te tama raa, tena ki meake, “He mee hokotahi koi akoe e tau te ppena. Haere no too na hekau akoe raa hakaatoa no kou ake alaa tama ki sui, tena akoe ku too na sileni raa no kou ake na tama hakaalloha raa, tena akoe e me ki isi tammaki na mee taualleka i te vaelani; ki oti akoe ku hamai no tautari Anau.” ");
INSERT INTO nuq_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Te tama raa e rono koi na tattara Jisas raa, tena aia ku kkira hakahaeo roo na karemata aia raa no haere i taha, e mee aia he tama roo hai hekau. ");
INSERT INTO nuq_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tena Jisas ki kira hakataka ake na disaipol Aia raa, tena ki meake, “Na tama hai sileni raa e hainattaa roo te ttae i te Hakamaatua ana i te Vaelani raa!” ");
INSERT INTO nuq_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Na disaipol raa ku mahharo roo i na tattara Jisas raa, tena Jisas ki tattara ake hoki ma, “Aku tama, te Hakamaatua ana i te Vaelani raa e hainattaa roo te ttae! ");
INSERT INTO nuq_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Te hainattaa te tama hai sileni ki uru i roto te Hakamaatua ana i te Vaelani raa e raka roo i aruna ma te kamel e uru i roto te rua te rina e ttui paamaro raa.” ");
INSERT INTO nuq_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Na disaipol raa ku mahharo haeo roo i na tattara Jisas raa, tena ki vahihhiri hokolaatou ma, “Tena kaa koai na tama e me ki too te ora e ora tahi naa?” ");
INSERT INTO nuq_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Kito Jisas ki kira hakamattonu ake na disaipol raa, tena ki meake, “Na mee hakaatoa e hainattaa ma te tama seai ma TeAtua, e meia na mee hakaatoa hainauhie roo i TeAtua te ppena.” ");
INSERT INTO nuq_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kito Pita ki meake Jisas, “Kira ake! Maatou e tiaki na mee roo hakaatoa no tauttari Akoe.” ");
INSERT INTO nuq_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Tena Jisas ki meake, “Noo, Anau e meatu kootou kame he tama e tiaki te hare aia, na taina aia, na kaave aia, te tinna aia, te tamana aia, na tamalliki aia ia ma na paupaku aia raa no tautari Anau ia ma te Rono Tauareka raa, ");
INSERT INTO nuq_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tena te tama naa e me ki too na hoki tammaki i te nnoho taatou vahao nei raa. Te tama naa e me ki too huitarau na hare, na taina, na kaave, na tinna, na tamalliki ia ma na paupaku, hakapaa hoki ma na hakalono llihu, tena i te ora i muri raa aia e me ki too te ora e ora tahi. ");
INSERT INTO nuq_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Emeia na tama tammaki e ttuu i mua te saaita nei raa e me ki hakammuri, tena na tama tammaki e hakammuri te saaita nei raa e me ki ttuu i mua.” ");
INSERT INTO nuq_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jisas ma na disaipol Aia raa ku oo te mateara e haere peeraa i Jerusalem raa, tena Jisas ki haere i mua na disaipol Aia raa. Na disaipol raa e mamannatu tammaki, e meia te kanohenua e tauttari vaa muri na tama raa e mattaku. Tena Jisas ki kanna ake hakaraoi te sanahuru ma rua na disaipol Aia raa, tena ki tattara ake na tama raa na mee e me ki kapihi ake Aia raa. ");
INSERT INTO nuq_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Hakallono! Taatou e me ki oo peeraa i Jerusalem i te kina te Tamariki te Tama nei e me ki noho i raro na mahi na maatua hakananniu ia ma na tama poroporo na tuaa raa. Na tama raa e me ki hatu na tattara malliu, tena ku hakaioo ma ki taa Tama raa ki mate, tena na tama raa e me ki kou ake Tama raa i na tama seai ma ni Jiu raa ki taa ki mate. ");
INSERT INTO nuq_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Na tama raa e me ki tataussua Tama raa, sasavare Tama raa, tena ku riki Tama raa, tena ki oti ku taa Tama raa ki mate; e meia Tama raa e me ki mahike muri no ora i te aho tana hakatoru raa.” ");
INSERT INTO nuq_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Na tama Sebedi raa, Jems laaua ma Jon ku oo ake no meake Jisas ma, “Rabai, maaua e isi te mee e hihhai ma Akoe ki ppena ma maaua.” ");
INSERT INTO nuq_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tena Jisas ki meake, “He mee peehee?” ");
INSERT INTO nuq_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kito te haanau raa ki meake, “Maaua e hihhai ma Akoe ki tiaki maaua ki nnoho i te vahi Akoe, te tama e noho te vahi laaua, tena teeraa tama ku noho i te vahi se laaua Akoe raa te saaita Akoe e noho i aruna te Nohorana Hakanaaniu Akoe i roto te Hakamaatua ana i te Vaelani raa.” ");
INSERT INTO nuq_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kito Jisas ki meake, “Koorua se illoa hea koorua e kainno mai Anau raa. Koorua e lavaa te unu te kapu na hakalono lihu Anau e me ki unu raa? Koorua e lavaa te too te hakoukou tapu Anau e me ki too raa?” ");
INSERT INTO nuq_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Kito te haanau raa ki meake, “Maaua e lavaa.” Tena Jisas ki meake tokorua raa, “Hakamaoni koorua e me ki unu te kapu Anau e me ki unu raa, tena ku too te hakoukou tapu Anau e me ki too raa. ");
INSERT INTO nuq_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Emeia Anau se isi na mahi ki tini koai e me ki noho i te vahi laaua ia ma koai e me ki noho i te vahi se laaua Anau raa. TeAtua ko te Tama e me ki tanattana na kina raa no kou ake na tama Aia ni hirihiri raa.” ");
INSERT INTO nuq_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Te saaita teeraa sanahuru na disaipol ni llono na tattara Jems laaua ma Jon raa, na tama raa ku lloto roo i tokorua raa. ");
INSERT INTO nuq_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kito Jisas ki kanna ake na disaipol Aia raa ki hakkutu ake, tena Aia ki meake, “Kootou e illoa pera ma na tama e mee pera ma ni tama hakanaaniu na tama e nnoho pouri raa e isi na mahi i aruna na tama raa, ia tena na tama hakanaaniu raa e isi roo na mahi hai mmahi. ");
INSERT INTO nuq_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tena kootou ki se mee peenaa. Kame he tama kootou e hihai ki hakamaatua, tena te tama naa e me ki mee mo tama hehekau na tama hakaatoa, ");
INSERT INTO nuq_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ia kame he tama kootou e hihai ki mua, tena aia ki mee pera ma he tama e mouraro i na tama hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Maitaname te Tamariki te Tama nei se hamai ki hakanaaniu; Aia e hamai ki hehekau, tena ku hoki ake te ora Aia raa ki hakattana tammaki na tama i taha ma na hai sara laatou.” ");
INSERT INTO nuq_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Na tama raa ku ttae i Jeriko, tena Jisas ma na disaipol Aia raa ia ma te kanohenua e rahi raa ku mee ki tiaki te matakaina raa no oo, tena he tama na karemata aia raa e sseni e noho i te vahi te mateara raa no kainonno, te inoa aia raa ko Bartimeus te tama Timeus. ");
INSERT INTO nuq_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bartimeus ku rono ma teeraa ko Jisas te Tama i Nasaret raa, tena aia ki kakanna ake hakamaroa ma, “Jisas! Tamariki Devit! Hai aroha mai Anau!” ");
INSERT INTO nuq_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tena tammaki na tama ku lloto no hai ake te tama raa ki noho hemuu, Emeia Bartimeus ku kakanna ake hakamaroa roo ma, “Tamariki Devit, hai aroha mai anau!” ");
INSERT INTO nuq_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jisas ku tuu, tena ki meake, “Kanna atu te tama raa ki hamai.” Kito na tama raa ki kanna ake te tama karemata sseni raa, tena ki meake, “Auu se maanatu! Mahike i aruna, Tama raa e kanna atu ma akoe ki haere ake.” ");
INSERT INTO nuq_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kito te tama raa ki peesia na hekau aia e kkahu raa, tena ki llee no tuu i aruna no haere atu iaa Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Kito Jisas ki vahiri ake, “Hea akoe e hihai ma Anau ki ppena ma akoe naa?” Tena te tama karemata sseni raa ki meake, “Rabai, anau e hihai ma anau ki kite hakaraoi.” ");
INSERT INTO nuq_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Tena Jisas ki meake, “Haere, te hakatina akoe naa e mee akoe no tauareka.” Te saaita naa koi te tama raa ku kite no tautari atu vaa muri Jisas. ");
INSERT INTO nuq_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jisas ma na disaipol Aia raa ku ttae i na matakaina Betfage laaua ma Betani, taapiri i te Mouna e hhomo na Oliv raa. Na tama raa ku tappiri i Jerusalem, tena Jisas ki kauna tokorua na disaipol Aia raa ki oo i mua ");
INSERT INTO nuq_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ma na tattara nei: “Oo i te matakaina e tuu i mua raa. Te saaita koorua e ttae atu raa koorua e me ki kkite te donki koi pupunua e haihai tera se hai tama roo ni kake no tere. Vvete te manu naa, tena koorua ku hakattaki mai i te kina nei. ");
INSERT INTO nuq_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ia kame he tama e vahiri atu ma koorua e vvete te manu naa ki aa, tena koorua ku meake te tama naa pera ma TeAriki e hihai te manu nei paa saaita koi, tena ki oti Aia ku kou mai hakaraoi te manu nei.” ");
INSERT INTO nuq_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kito tokorua raa ki oo no kkite te donki e haihai taapiri te totoka te hare. Tokorua raa ku vvete te manu raa, ");
INSERT INTO nuq_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","tena na tama e ttuu vaa raa ku vahiri ake tokorua raa ma, “Koorua e vvete te donki naa ki aa?” ");
INSERT INTO nuq_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tena tokorua raa ki meake hea Jisas ni tattara ake laaua raa, tena na tama raa ki tiaki tokorua raa ki too te manu raa. ");
INSERT INTO nuq_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tokorua raa e hakattaki ake te donki raa iaa Jisas, tena ki lletu na kaukahu laaua raa i aruna te manu raa, tena Jisas ki kake i aruna. ");
INSERT INTO nuq_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tammaki roo na tama ku sosora na kaukahu laatou raa i aruna te mateara, tena alaa tama ku tutuu na launiu i roto na paupaku vaa raa no sosora hoki i aruna te mateara. ");
INSERT INTO nuq_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tena na tama e oo vaa mua ia ma na tama e oo mai vaa muri raa ku kaamata no vavaa ma, “Hakammaha TeAtua! TeAtua e hakatapu te Tama e hamai i te inoa TeAriki raa! ");
INSERT INTO nuq_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","TeAtua e hakatapu te Tama ku Tuku pera ma te tuku Devit, te tipuna taatou i mua raa! Hakammaha TeAtua!” ");
INSERT INTO nuq_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisas ku tae i roto Jerusalem, tena Aia ki haere i roto te Hare Tapu raa, tena ki tuu no matamata na mee hakaatoa i hare raa. Ia te saaita naa hoki te mee raa ku hiahi haeo roo, tena Aia ma te sanahuru ma rua na disaipol Aia raa ku oo i Betani. ");
INSERT INTO nuq_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Te aho taiao raa, na tama raa ku tiaki Betani no vakkai i Jerusalem, tena Jisas ku rono te hikai. ");
INSERT INTO nuq_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aia e kite te laakau fik e tammaki na laumea e tuu i mmao, tena Aia ki haere atu ma ki mmata ma e isi na hua e mmau. Emeia te saaita Aia ni tae i te kina te laakau raa, Aia e kite koi na laumea, e mee teenaa seai ma ko te saaita na fik raa e me ki hhua. ");
INSERT INTO nuq_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tena Jisas ki meake te laakau raa, “Se hai tama hoki e me ki kkai na hua akoe.” Na disaipol raa e llono Jisas e meake te laakau raa. ");
INSERT INTO nuq_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Te saaita na tama raa ni ttae i Jerusalem, Jisas ku haere i te Hare Tapu raa no hakaise na tama e suisui na mee vaa hare raa. Aia e hakahuri na tebol na tama e sesenisi na sileni raa, tena ki hakahuri na tuai na tama e nnoho no suisui na rupe raa, ");
INSERT INTO nuq_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","tena Aia ki ppui ki se hai tama e amo he mee vaa roto te Hare Tapu raa. ");
INSERT INTO nuq_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kito Aia ki akoako ake na tama raa ma: “Na tattara TeAtua nei e mmau i roto te Launiu Tapu ma, ‘Te Hare Tapu Anau nei e me ki kanna ria pera ma he hare lotulotu na tama na henua hakaatoa.’ Emeia kootou e huri te hare nei ki mee mo hare na tama kailallao!” ");
INSERT INTO nuq_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na maatua hakananniu ia ma na tama poroporo na tuaa raa ku llono na tattara Jisas raa, kito na tama raa ki sesee he ara ma ki taa Tama raa ki mate. Na tama raa e mattaku Jisas, maitaname te kanohenua raa e mamahharo roo i na akoako Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Te saaita te mee raa ku hiahi, Jisas ma na disaipol Aia raa ku tiaki te matakaina raa no oo. ");
INSERT INTO nuq_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tena te tahata te aho taiao raa na tama raa ku oo hoki vaa te mateara raa, tena ki kkite te laakau fik raa. Te laakau raa ku mate kaamata na patiaka i raro raa haere no ttae i aruna te laakau raa hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita ku maanatu na tattara Jisas ni meake te laakau raa, tena aia ki meake Tama raa ma, “Rabai, kira ake te laakau akoe ni hakamate ake raa ku mate!” ");
INSERT INTO nuq_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Kito Jisas ki meake na disaipol raa, “Kootou ki isi na hakattina i TeAtua. ");
INSERT INTO nuq_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Anau e meatu te hakamaoni: kame he tama e meake te mouna raa ma, ‘Haere no llee i roto te lottai’, te mouna naa e me ki haere no llee i roto te lottai kame te tama naa se mamannatu tammaki, tena ki hakatina hoki ma hea aia ni meake raa e me ki hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tera hea Anau e tattara atu kootou ma, te saaita kootou e lotu no kainno ake TeAtua niaa kootou e hihhai raa, tena kootou ki hakattina pera ma kootou e me ki too na mee raa, tena TeAtua e me ki kou atu niaa kootou e kainno ake Aia raa. ");
INSERT INTO nuq_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Te saaita kootou e ttuu no lotu, tena kootou ki ssirihia ni haeo peehee kootou e isi ma alaa tama ki lavaa te Tamana kootou i te vaelani raa te ssirihia niaa kootou e ppena e ssara raa. ");
INSERT INTO nuq_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kame kootou se ssirihia na hai sara alaa tama, tena te Tamana kootou i te vaelani raa se lavaa te ssirihia niaa kootou e ppena e ssara raa.” ");
INSERT INTO nuq_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jisas ma na disaipol Aia raa ku ttae hoki i Jerusalem. Tena te saaita Jisas ni haere peeraa i te Hare Tapu raa, na maatua hakananniu raa, na tama poroporo na tuaa ia ma na tama hakamattua na Jiu raa ku oo ake iaa Jisas raa ");
INSERT INTO nuq_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","no vahiri ake Tama raa ma, “Ni mahi peehee Akoe e isi ki ppena na mee nei? Koai te tama e kou atu na mahi Akoe naa?” ");
INSERT INTO nuq_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Kito Jisas ki meake na tama raa, “Anau e me ki vahiri atu he vahiri hokotahi, tena kame kootou e sui muri mai te vahiri Anau nei, tena Anau e me ki meatu ma ni mahi peehee Anau e isi ki ppena na mee nei. ");
INSERT INTO nuq_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kootou ki mee mai Anau, na mahi Jon e isi ki hakoukou tapu na tama raa ni mahi e oo mai i hee: ni mahi e oo mai TeAtua ma ni mahi koi na tama i te maarama nei raa?” ");
INSERT INTO nuq_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Na tama raa ku kaamata no kooti hokolaatou ma, “Taatou e me ki meake peehee? Kame taatou e meake ma, ‘Ni mahi TeAtua’, tena Aia e me ki mee mai ma, ‘Kaa kootou se hakattina Jon naea?’ ");
INSERT INTO nuq_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Emeia kame taatou e meake ma, ‘Ni mahi koi na tama i te maarama nei!’ ” (Na tama raa e tattara peenei raa e mee laatou e mattaku maitaname te kanohenua raa e hakattina ma Jon he profet hakamaoni.) ");
INSERT INTO nuq_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kito na tama raa ki meake Jisas ma, “Maatou se illoa.” Tena Jisas ki meake, “Tena Anau hoki se lavaa te meatu ma ni mahi peehee Anau e isi ki ppena na mee nei.” ");
INSERT INTO nuq_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tena Jisas ki tattara ake te kanohenua raa te tattara hurihuri ma, “Teeraa he tama e ttori na hua na grep i roto te paupaku aia, tena ki ppui areha te paupaku raa. Te tama raa e tanattana te kina ki kumikumi na hua, tena ki hakatuu te paa hare palluna ki nnoho na tama no lollohi te paupaku raa. Tena te tama raa ki kou ake te paupaku raa i na tama ki lollohi, tena aia ki horau i te henua e mmao. ");
INSERT INTO nuq_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Te saaita na hua raa ku lleu raa, te tama hakamaatua te paupaku raa ku kauna te tama hehekau aia raa ki haere no too te tuhana aia raa i na tama e lollohi te paupaku aia raa. ");
INSERT INTO nuq_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tena na tama e lollohi te paupaku raa ki taohi te tama hehekau raa no taa te tama raa, tena ki hakaise te tama raa i taha se hai mee e kou ake. ");
INSERT INTO nuq_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Te tama hakamaatua te paupaku raa ku kauna teeraa tama hehekau aia, kito na tama e lollohi raa ki riki te pohouru te tama raa, tena ki ppena na mee sakkino roo i te tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kito te tama hakamaatua raa ki kauna teeraa tama hehekau hoki, tena na tama raa ki taa te tama raa no mate. Tammaki na tama hehekau te tama hakamaatua raa ni kauna raa e ttiri na hakalono llihu e ssau pera ma na hakalono llihu na tama hehekau kaamata raa ni ttiri raa hoki. ");
INSERT INTO nuq_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Te tama hakaoti e ttoe ki haere raa ko te taupeara te tama hakamaatua tera aia e laoi mahi raa. Te hakaoti roo aia ki kauna te taupeara aia raa ki haere no mmata na tama e lollohi te paupaku raa. Tena aia ki tattara ma, ‘Anau e iroa na tama naa e me ki hakammaha te tama anau nei.’ ");
INSERT INTO nuq_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Emeia na tama e lollohi te paupaku raa e tattara hokolaatou ma, ‘Teenei te taupeara te tama hakamaatua te paupaku nei. Oo mai, taatou ki taa te taupeara nei ki mate, tena taatou ku too na mee hakaatoa aia e ttino raa ma taatou!’ ");
INSERT INTO nuq_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kito na tama raa ki ttaohi te taupeara raa no taa no mate, tena ki peesia te tinotama te taupeara raa i taha ma te paupaku raa.” ");
INSERT INTO nuq_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Kito Jisas ki vahiri ake “Kaa hea te tama hakamaatua raa e me ki ppena? Tama raa e me ki hamai no taa na tama raa ki mmate, tena ku too te paupaku raa no kou ake alaa tama ki lollohi. ");
INSERT INTO nuq_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Hakamaoni kootou ku oti te ppau na tattara nei i roto te Launiu Tapu ma, ‘Te hatu na tama e hakatuutuu na hare raa ni hakahekeheke ma e haeo raa, ko te hatu e mmau roo hokoia i aruna na hatu hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","TeAtua e pena na mee nei, tena na mee nei e tiputipu laoi roo!’ ” ");
INSERT INTO nuq_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tena na tama hakamattua na Jiu raa ku hahaivi ma ki hakapiki Jisas, e mee laatou e illoa ma te tattara hurihuri Jisas raa e tattara koi laatou. Emeia laatou e mattaku i te kanohenua raa, tena laatou ki tiaki Jisas no oo i taha. ");
INSERT INTO nuq_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","E isi na Farisi ia ma alaa tama te kuturana Herot raa ni kauna ria ki oo iaa Jisas ma ki taaiki Tama raa ma na vahiri. ");
INSERT INTO nuq_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Na tama raa e oo no meake Jisas ma, “Rabai, maatou e illoa ma Akoe he tama e tattara te hakamaoni, tena Akoe se mamaanatu tammaki ma ni hakataakoto peehee na tama e isi. Akoe se maanatu hoki ma ni mahi peehee na tama e isi, e meia Akoe e akoako ake na tama te hakamaoni na mee TeAtua e hihai raa. Tena mee mai maatou, eaa e sara ma na tuaa taatou raa ki sui ake na takis raa i te tuku i Rom raa? Taatou e me ki sui ake ma seai?” ");
INSERT INTO nuq_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Emeia Jisas e iroa i te vahiri na tama raa e vahiri mariu ake raa, tena Aia ki meake, “Aiea kootou e hahaivi ma ki taaiki Anau naea? Kou mai he sileni ki mmata Anau.” ");
INSERT INTO nuq_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tena na tama raa ki kou ake te sileni, kito Jisas ki vahiri ake, “Teenei he pohouru iaa he inoa aii?” Kito na tama raa ki meake, “He pohouru, ia he inoa te tuku i Rom.” ");
INSERT INTO nuq_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tena Jisas ki meake, “Tena kootou ku sui ake te tuku raa hea te tuku raa e ttino, tena ku kou ake TeAtua hea TeAtua e ttino.” Na tama raa ku mahharo roo i na tattara Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tena e isi na Sadyusi, na tama e mee ma se hai tama e lavaa te ora muri i taha ma te mate raa ku oo ake no meake Jisas ma, ");
INSERT INTO nuq_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Rabai, Moses e taataa mai te tuaa nei i taatou ma, ‘Kame he tanata e mate no tiaki te hine aia raa se isi na tamalliki, tena te taina aia raa e me ki avana te tautukaha raa ki hura tama te hine raa, tena na tamalliki raa e me ki mee pera ma ni tamalliki te tanata mua aia ku mate raa.’ ");
INSERT INTO nuq_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tena e isi tokohitu na hai taina: Te tama matua raa e avana no mate se hai tamalliki. ");
INSERT INTO nuq_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tena te tama e pare ake raa ku avana te tautukaha raa, tena aia hoki e mate se hai tamalliki. Tena te tama hakatoru raa ku avana no mate se hai tamalliki hoki, ");
INSERT INTO nuq_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ia tena tokohitu na hai taina raa hakaatoa ni avvana te hine raa no mmate se hai tamalliki. Tena ki oti roo te hine raa ku mate. ");
INSERT INTO nuq_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ia te saaita na tama e mmate raa hakaatoa ku mahhike no ora i te aho te ora muri raa, te hine raa e me ki avana aii? E mee te tokohitu na hai taina raa hakaatoa ni avvana te hine raa.” ");
INSERT INTO nuq_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Kito Jisas ki meake na tama raa, “Kootou e ssara haeo! Tena kootou e illoa hea? E mee kootou se illoa te Launiu Tapu ia ma na mahi TeAtua. ");
INSERT INTO nuq_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Maitaname te saaita na tama e mmate raa ku mahhike no ora raa, na tama raa e me ki mee pera ma ni ensel i te vaelani, tena laatou se lavaa te avvana. ");
INSERT INTO nuq_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ia tena i te vahi na tama e mmate no ora muri raa, kootou se hai vahao e ppau i roto te Launiu Moses i te kina e tattara i te pupu e ura raa? Te Launiu raa e taataa ma TeAtua e meake Moses ma, ‘Anau ko TeAtua Abraham, TeAtua Aisak ia ma TeAtua Jekop.’ ");
INSERT INTO nuq_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Aia ko TeAtua na tama e ora, ia seai ma HeAtua na tama e mmate raa. Kootou e ssara roo!” ");
INSERT INTO nuq_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","He tama poroporo na tuaa e noho i te kina raa no rono na Sadyusi raa e hakataukoti ma Jisas. Tena aia e kite hoki pera ma Jisas e kou ake na tama raa na hakataakoto taualleka, kito aia ki haere atu iaa Jisas ma te vahiri nei: “He tuaa peehee e hakanaaniu i na tuaa raa hakaatoa?” ");
INSERT INTO nuq_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tena kito Jisas ki meake, “Te tuaa e hakanaaniu raa e mee peenei: ‘Hakallono mai Israel hakaatoa! TeAriki TeAtua taatou raa ko TeAtua hokotahi koi. ");
INSERT INTO nuq_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Laoi TeAriki TeAtua kootou raa ma na hatu manava kootou, na anana kootou, na hakataakoto kootou ia ma na mahi kootou.’ ");
INSERT INTO nuq_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Te tuaa hakarua e hakanaaniu raa e mee peenei, ‘Laoi alaa tama pera ma kootou e laoi kootou hokkootou.’ Se hai tuaa e hakanaaniu i aruna na tuaa e rua nei.” ");
INSERT INTO nuq_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kito te tama poroporo na tuaa raa ki meake Jisas ma, “Rabai, tauareka roo! Akoe e tattara hakamaoni pera ma TeAriki Hokoia ko TeAtua, tena se hai atua peeraa hoki, TeAtua Hokoia koi. ");
INSERT INTO nuq_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tena ku laoi TeAtua ma na hatu manava kootou raa, na hakataakoto ia ma na mahi kootou raa, tena ku laoi hoki alaa tama pera ma kootou e laoi kootou hokkootou raa e hakanaaniu roo i aruna ma kootou ki hoki ake na hoki na manu ia ma alaa hoki peeraa hoki i TeAtua.” ");
INSERT INTO nuq_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisas e rono pera ma na tattara te tama raa e mattonu, tena Aia ki meake te tama raa ma, “Akoe se mmao i taha ma te Hakamaatua ana i te Vaelani raa.” Tena i muri te mee nei na tama raa ku mattaku te vahiri ake Jisas alaa vahiri hoki. ");
INSERT INTO nuq_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas e vahiri ake te vahiri nei te saaita Aia ni akoako i roto te Hare Tapu raa ma, “Na tama poroporo na tuaa raa e lavaa peehee te tattara ma te Mesaia raa he mokopuna Devit? ");
INSERT INTO nuq_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","TeAnana Tapu raa ni tau i roto Devit no tattara ma: ‘TeAtua e meake TeAriki anau raa ma, noho i te vahi laaua Anau raa ki tae roo te saaita Anau e tuku na tama e kiri lloto Akoe raa i raro na tapuvae Akoe raa.’ ");
INSERT INTO nuq_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit hokoia e kanna Tama raa ma ‘TeAriki.’ Tena kaa te Mesaia raa e lavaa peehee te mee pera ma he mokopuna Devit?” He kanohenua e rahi e nnoho hakaraoi roo no hakalollono Jisas e tattara raa. ");
INSERT INTO nuq_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisas e akoako ake na tama raa, tena Aia ki meake ma, “Hakamattonu i na tama poroporo na tuaa tera e hihhai ki hahaere ma na hekau lolloa raa, tena e hihhai hoki ki hakammaha ria i na kina na maket raa. ");
INSERT INTO nuq_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ia na tama raa e hihhai hoki ki nnoho ma na tama hakamattua i roto na hare lotu ia ma na kina taualleka i na kina na kai e llahi raa. ");
INSERT INTO nuq_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Na tama raa e hai lavvaka no kailallao na hare na tautukaha hhine raa, tena ki hakatannata hoki ma laatou e too na lotu lolloa. Na hakalono llihu na tama naa e me ki haeo roo!” ");
INSERT INTO nuq_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas e noho taapiri te kina te papa e ponopono na sileni te Hare Tapu raa, tena Aia ki matamata ake te kanohenua raa e oo ake no ponopono na sileni laatou raa i roto te papa raa. Tammaki na tama hai sileni e ppono tammaki na sileni. ");
INSERT INTO nuq_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tena he tautukaha hine e hakaaroha e haere ake no ppono e rua na sileni. ");
INSERT INTO nuq_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tena Jisas ki kanna ake na disaipol Aia raa no meake ma, “Anau e meatu te hakamaoni pera ma te hoki te tautukaha hine e hakaaroha nei raa e raka roo ma na hoki na tama hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Maitaname na tama raa e kou ake na sileni, tena e isi koi na sileni e mmoe. Ia te hine nei niaina roo ma aia e hakaaroha, e meia aia e ppono na sileni hakaatoa aia e isi raa. Te hine raa e hoki ake na sileni hakaatoa aia e isi ki tokonaki aia raa.” ");
INSERT INTO nuq_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisas ku tiaki te Hare Tapu raa no haere, tena he disaipol na disaipol Aia raa ku meake ma, “Rabai, kira ake! Te hare raa ma na hatu raa e tiputipu taualleka roo!” ");
INSERT INTO nuq_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Tena Jisas ki meake te disaipol raa, “Akoe e kite te hare e rahi nei? Se hai hatu e me ki mmau i te kina aia e mmau raa; na hatu hakaatoa e me ki hhopo no maoha i raro.” ");
INSERT INTO nuq_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisas e noho i aruna te Mouna e hhomo na Oliv raa, tena ki ana atu peeraa i te Hare Tapu raa. Kito Pita, Jems, Jon, tena Andru ki oo ake hokolaatou no nnoho ma Jisas. ");
INSERT INTO nuq_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Tena na tama raa ki meake, “Tattara mai maatou ma na mee nei e me ki kapihi mai vahao hee, tena ku tattara mai hoki ma ni hakkatu peehee maatou e me ki kkite ki huri mai pera ma na mee nei ku mee ki kapihi mai.” ");
INSERT INTO nuq_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kito Jisas ki meake, “Lollohi hakamattonu ki se lavaa ni tama e oo atu no malliu atu kootou. ");
INSERT INTO nuq_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tammaki na tama e me ki oo atu ma laatou e tattara i te vahi Anau, tena ku tattara ma, ‘Anau ko te Mesaia!’ ia na tama naa e me ki malliu ake hoki tammaki na tama. ");
INSERT INTO nuq_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tena auu se mamannatu tammaki te saaita kootou e llono te ttani na kapipihi tappiri atu ia ma na rono na taua e mmao raa. Na mee e me ki kapihi atu, e meia na mee nei se huri atu pera ma te maarama nei ku hamai te hakaoti. ");
INSERT INTO nuq_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Na henua e me ki ppuhu hokolaatou, tena na tuku raa hoki e me ki ppuhu hokolaatou. Na henua hakaatoa e me ki ttiri na ruru henua, ia e me ki ttiri hoki te hikkai. Tena na mee nei hakaatoa e ssau koi pera ma na hakalono llihu kaamata roo te hine ku mee ki mamaoha raa. ");
INSERT INTO nuq_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kootou hokkootou ki lollohi. Kootou e me ki hakapiki ria no kkave i na hare kot. Kootou e me ki riki ria i roto na hare lotu na Jiu, tena kootou e me ki ttuu i mua na tama hakamattua ia ma na tuku raa no tattara ake te Rono Tauareka raa i na tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Emeia kootou ki takutaku ake te Rono Tauareka raa i na tama roo hakaatoa i mua te aho hakaoti raa e tae atu. ");
INSERT INTO nuq_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kame kootou e hakapiki ria no kkave i na hare kot, tena kootou ki se mamannatu tammaki i mua te kot raa ma ni tattara peehee kootou e me ki tattara; ia te saaita ki kot raa e ttae, tena kootou ku tattara ake ni tattara peehee e uru atu i roto na mannatu kootou raa e mee TeAnana Tapu raa e me ki kou atu na tattara kootou e me ki tattara raa. ");
INSERT INTO nuq_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Na tama e me ki kou ake na taina laatou raa ki taaia ki mmate, tena na tamana na tamalliki raa e me ki ppena peeraa hoki i na tamalliki laatou raa. Na tamalliki raa e me ki huri sara no taa na maatua laatou raa ki mmate. ");
INSERT INTO nuq_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Na tama hakaatoa e me ki se hihhai kootou e mee kootou e tauttari Anau. Emeia te tama e tuu mmau i te hakatina aia no tae te hakaoti raa e me ki ora. ");
INSERT INTO nuq_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Kootou e me ki kkite te haeo raa e hamai no tuu i te kina aia se tau te tuu raa.” (Akoe te tama e ppau raa: ki iroa te hakataakoto te tattara nei!) “Tena na tama i Judia raa e me ki huro i na kina na mouna raa no mmuni. ");
INSERT INTO nuq_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Te tama e noho i aruna te tauhuhu te hare aia raa se lavaa te tiho no haere i hare ma ki too niaa aia e hihai ki too raa. ");
INSERT INTO nuq_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Te tama i roto te paupaku raa se lavaa te vaakai i hare ma ki too te kaukahu aia raa. ");
INSERT INTO nuq_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Na aho naa e me ki haeo roo ma na hhine e hai ttama raa ia ma na hhine e isi na tamalliki pammee raa! ");
INSERT INTO nuq_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Lotu no kainno ake TeAtua ki se lavaa na mee nei e kapihi atu i te saaita te matani te laki raa e maairi raa. ");
INSERT INTO nuq_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Maitaname na hakalono llihu na aho naa e me ki haeo roo i aruna ma na hakalono llihu te maarama nei ni isi i mua raa, kaamata te saaita TeAtua ni pena iho te maarama nei raa haere no tae mai te aho nei. Ia e me ki se lavaa hoki ni hakalono llihu peenei e hhura mai i muri. ");
INSERT INTO nuq_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Emeia TeAtua ku oti te ttuu na aho raa no moisi, ia peeraa TeAtua ki se ttuu na aho raa no moisi, se hai tama taatou e lavaa te ora. TeAtua e ttuu na aho raa no moisi e mee Aia e maanatu na tama Aia ni hirihiri raa. ");
INSERT INTO nuq_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Tena kame he tama e meatu ma, ‘Kira mai, teenei te Mesaia nei!’ ia seai naa aia ku meatu ma, ‘Kira ake, teeraa te Tama raa!’ tena auu se hakattina te tama naa. ");
INSERT INTO nuq_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Maitaname na mesaia ia ma na profet malliu raa e me ki ttae atu. Na tama raa e me ki ppena na mirakol ia ma na mee taualleka ma ki malliu ake na tama TeAtua ni hirihiri raa, kame laatou e lavaa. ");
INSERT INTO nuq_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kootou ki ttuu mmau! Anau ku oti te tattara atu na mee roo hakaatoa i mua na mee naa e kapihi atu. ");
INSERT INTO nuq_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“I muri na aho na hakalono llihu raa, te laa raa e me ki haere no pouri, tena te maremo raa e me ki se lavaa te tii, ");
INSERT INTO nuq_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","tena na hetuu i te vaelani raa e me ki maoha i raro, tena na mahi na mee i te lani raa e me ki oo sara ma na ara laatou e hahaere raa. ");
INSERT INTO nuq_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tena te Tamariki te Tama nei e me ki hamai i aruna na pukureurehu ma na mahi hai mmahi. ");
INSERT INTO nuq_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Te Tama raa e me ki kauna na ensel raa ki oo i na kina hakaatoa i roto te maarama nei raa no hakkutu hakaatoa na tama TeAtua ni hirihiri raa. ");
INSERT INTO nuq_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Te fik raa e me ki akoako atu he hakataakoto. Te saaita na laumea na raraa te laakau raa ku tilottilo roo, kootou e me ki illoa pera ma te saaita na laakau e me ki hhomo taualleka raa ku mee ki tae mai. ");
INSERT INTO nuq_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ia e ssau hoki, te saaita kootou e kkite na mee nei hakaatoa e kapihi atu raa, kootou e me ki illoa pera ma te saaita raa ku taapiri mai, ia ku tanattana koi ki hamai. ");
INSERT INTO nuq_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mannatu pera ma na mee nei hakaatoa e me ki kapihi mai i mua na tama hakaatoa e nnoho te saaita nei raa e mmate. ");
INSERT INTO nuq_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Te vaelani ma te maarama nei e me ki oti, e meia na tattara Anau raa se lavaa te oti. ");
INSERT INTO nuq_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Tena se hai tama e iroa te aho ia ma te saaita hee roo na mee nei e me ki kapihi mai, niaina na ensel i te vaelani, ia te Tamariki hoki TeAtua raa se iroa; te Tamana Hokoia koi e iroa. ");
INSERT INTO nuq_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Lollohi hakamattonu, tena ku tanattana, e mee kootou se illoa ma te saaita hakamaoni raa e me ki tae atu vahao hee. ");
INSERT INTO nuq_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Te aho naa e me ki ssau pera ma te tama ku mee ki horau i te henua e mmao, tena ki tattara hakaraoi ake roo na tama hehekau raa niaa na tama raa e me ki ppena raa, tena ki tiaki ake na tama hehekau aia raa ki lollohi. Aia e meake hoki te tama e tuu te totoka raa ki rorohi hakappuru roo. ");
INSERT INTO nuq_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ia tena lollohi hakamattonu, maitaname kootou se illoa te saaita te tama hakamaatua raa e me ki hamai i hare. Ka oti te tama raa ku hamai te hiahi, seai naa te tuapoo, seai naa te uru te ata, ia seai naa te saaita te laa raa ku hopo ake. ");
INSERT INTO nuq_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ka oti aia ku hakateki no hamai no kite kootou e mmoe heilloa. ");
INSERT INTO nuq_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ia hea Anau e tattara atu kootou nei, Anau e tattara ake hoki na tama hakaatoa ki lollohi hakamattonu!” ");
INSERT INTO nuq_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","E rua na aho i mua te Kai te Pasova ia ma te Kai te Haraoa Mannihi raa, na maatua hakananniu ia ma na tama poroporo na tuaa raa ku sesee he ara ma ki hakapiki hemuu Jisas, tena ku taa Tama raa ki mate. ");
INSERT INTO nuq_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Na tama raa e tattara ma, “Taatou se lavaa te ppena te hakataakoto nei te saaita te kai raa, maitaname te kanohenua raa e me ki lloto.” ");
INSERT INTO nuq_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisas e noho i Betani i te hare Saimon te tama ni kaina te manumanu haeo i mua raa. Jisas e noho no kai, tena he hine ki haere ake i hare ma te lloo manoni e pena koi na nad tera e sui mmaha roo. Te hine raa e taaraki te lloo manoni raa no nnini i aruna te pohouru Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tena e isi na tama e nnoho i te kina raa ku lloto roo, tena ki tattara hokolaatou ma, “E isi te tauareka te hine raa e ninnini puamu te lloo manoni raa? ");
INSERT INTO nuq_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Te lloo manoni raa e tau roo te kou ake ni tama ki sui toru huitarau na sileni, tena ku too na sileni raa no kou ake na tama hakaalloha raa!” Kito na tama raa ki tattara lloto ake roo te hine raa. ");
INSERT INTO nuq_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tena Jisas ki meake na tama raa, “Tiaki te hine naa! Aiea kootou e tattara lloto ake te hine naa naea? Te hine nei e pena te mee e tauareka roo i Anau. ");
INSERT INTO nuq_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Na tama hakaalloha raa e me ki nnoho tahi roo ma kootou, tena he saaita peehee kootou e hihhai ki tokonaki na tama naa, kootou e lavaa te tokonaki koi. Emeia Anau se lavaa te noho tahi roo ma kootou. ");
INSERT INTO nuq_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Te hine nei e pena hea aia e lavaa te ppena; Aia e nnini te lloo manoni raa i aruna te tinotama Anau ma ki tanattana te tinotama Anau raa i mua Anau e tanu ria. ");
INSERT INTO nuq_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Anau e meatu te hakamaoni pera ma hea te hine nei e ppena raa e me ki mee pera ma he hakamaarona aia te saaita na tama e takutaku te Rono Tauareka nei i na kina hakaatoa i roto te maarama nei.” ");
INSERT INTO nuq_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tena Judas Iskariot, he tama i roto te sanahuru ma rua na disaipol raa ku haere no meake na maatua hakananniu raa ma Aia e me ki hakari ake Jisas i na tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Na tama raa ku hihhia roo te saaita laatou ni llono na tattara Judas raa, tena laatou ki meake ma laatou e me ki kou ake ni sileni. Tena Judas ku kirakira he saaita e tauareka ma ki hakari ake Jisas i na tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Te aho kaamata roo te Kai te Haraoa Mannihi raa; teenaa ko te aho na tama e me ki taa na sipsip ki kkai te Kai te Pasova raa, tena na disaipol Jisas raa ku vahiri ake Jisas ma, “Te kina hee Akoe e hihai ma maatou ki oo no tanattana te Kai te Pasova raa ma Akoe?” ");
INSERT INTO nuq_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tena Jisas ki kauna tokorua na disaipol ma na tattara nei: “Oo i roto te matakaina e rahi raa, tena he tanata e amo te lloo vai e me ki ttiri koorua. Tauttari te tama naa ");
INSERT INTO nuq_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ki tae te hare aia e uru raa, tena koorua ku meake te tama hakamaatua te hare naa ma, ‘Te Rabai raa e mee ma, “Teehee te rum Anau ma na disaipol Anau raa e me ki kkai te Kai te Pasova naa?” ’ ");
INSERT INTO nuq_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tena te tama naa e me ki huri atu te rum e rahi i aruna, ku oti te tukutuku hakaraoi. Tena koorua ku tanattana mai na mee hakaatoa ki oo atu maatou.” ");
INSERT INTO nuq_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tokorua raa e oo i roto te matakaina raa no kkite na mee raa e ssau roo pera ma hea Jisas ni tattara ake laaua raa. Kito tokorua raa ki tanattana na kai e me ki kkai te kai te Pasova raa. ");
INSERT INTO nuq_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Te mee raa ku hiahi, tena Jisas ku haere ake ma te sanahuru ma rua na disaipol Aia raa. ");
INSERT INTO nuq_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Na tama raa ku nnoho ma ki kkai, tena Jisas ki meake, “Anau e meatu kootou; he tama kootou e me ki hakari ake Anau i na tama e kiri lloto Anau raa, e meia te tama naa e noho no kai ma Anau i te kina nei.” ");
INSERT INTO nuq_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Na hakataakoto na disaipol raa ku haeo roo, tena laatou ki vahihhiri ake Jisas tama taki ttahi ma, “Akoe ma e tattara koi anau?” ");
INSERT INTO nuq_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kito Jisas ki meake, “He tama i roto kootou te sanahuru ma rua na disaipol naa, teenaa ko te tama e me ki ttoki te haraoa aia raa i roto te parete Anau e ttoki te haraoa Anau raa. ");
INSERT INTO nuq_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Te Tamariki te Tama nei e me ki mate pera ma te Launiu Tapu raa e tattara; e meia te tama e me ki hakari ake te Tamariki te Tama nei e mee ki haeo roo! E me ki tauareka roo ma te tama naa peeraa aia ki se haanau iho i te maarama nei.” ");
INSERT INTO nuq_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Laatou koi kkai koi, tena Jisas ki too te haraoa raa no lotu ake TeAtua, tena ki ttohi te haraoa raa no kou ake na disaipol raa, tena Aia ki meake, “Too te haraoa nei, teenei ko te tinotama Anau.” ");
INSERT INTO nuq_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tena Jisas ki too te kapu raa no hakammaha ake TeAtua, tena ki kou ake te kapu raa i na disaipol raa, tena na tama raa hakaatoa ki unu te kapu raa. ");
INSERT INTO nuq_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kito Jisas ki meake ma, “Teenei ko te toto Anau tera e nnini atu ki tokonaki tammaki na tama, te toto Anau nei e huri atu te hakamaoni te tattara e ivi TeAtua raa. ");
INSERT INTO nuq_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Anau e meatu kootou pera ma Anau se lavaa hoki te unu te wain nei ki tae roo te aho Anau e me ki unu te wain hoou i te Hakamaatua ana i te Vaelani raa.” ");
INSERT INTO nuq_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tena na tama raa ki huhua te rue te lotu raa, tena ki oo peeraa i te Mouna e hhomo na Oliv raa. ");
INSERT INTO nuq_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tena Jisas ki meake na tama raa, “Kootou hakaatoa e me ki huro i taha, tena ku tiaki Anau, e mee te Launiu Tapu e tattara ma, ‘TeAtua e me ki taa te tama rorohi na manu raa, tena na sipsip raa e me ki maaseu huri.’ ");
INSERT INTO nuq_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Emeia te saaita Anau e me ki mahike muri i taha ma te mate raa, Anau e me ki haere i mua kootou no haere i Galili.” ");
INSERT INTO nuq_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Kito Pita ki meake, “Niaina ma na tama nei hakaatoa e huro i taha ma Akoe, e meia anau se lavaa roo te tiaki Akoe!” ");
INSERT INTO nuq_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tena Jisas ki meake Pita, “Anau e meatu te hakamaoni pera ma i mua te manu tane raa e tani e rua na vahao te poo nei, akoe e me ki kore e toru na vahao pera ma akoe se iroa Anau.” ");
INSERT INTO nuq_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kito Pita ki tattara hakappura ake ma, “Anau se lavaa roo te kore, niaina anau e mate ma Akoe!” Tena na disaipol raa hakaatoa ku tattara ake pera ma Pita raa hoki. ");
INSERT INTO nuq_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Na tama raa e oo no ttae i te kina e hui ma ko Getsemani raa, tena Jisas ki meake na disaipol Aia raa ma, “Nnoho i te kina nei, Anau e me ki haere no lotu.” ");
INSERT INTO nuq_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tena Aia ki too Pita, Jems ia ma Jon no haere ma Aia. Jisas ku se hihai roo ki hakarono i roto te tinotama Aia raa, ia te hakataakoto hoki Aia raa ku haeo roo, ");
INSERT INTO nuq_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","tena Aia ki meake na tama raa, “Te aroha i roto te hatu manava Anau nei e rahi roo, tena Anau ku taapiri koi ki mate te aroha. Nnoho i te kina nei no lollohi.” ");
INSERT INTO nuq_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jisas e haere hakamarie koi, tena ki tteiho no tuturi i raro no lotu ake TeAtua ma kame e hainauhie Aia ki se lavaa te too na hakalono llihu Aia e me ki too raa. ");
INSERT INTO nuq_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tena Aia ki lotu ma, “Aba! Taku Tamana! Na mee hakaatoa e hainauhie ma Akoe. Too te kapu te hakalono llihu nei i taha ma Anau. Emeia teenei seai ma he hihai Anau, tena ppena te hihai Akoe naa.” ");
INSERT INTO nuq_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tena Aia ki vaakai no kite te tokotoru na disaipol raa ku mmoe. Tena aia ki meake Pita, “Saimon, akoe e moe? Akoe se lavaa roo te ara ake he paa saaita?” ");
INSERT INTO nuq_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tena Aia ki meake na tama raa, “Ara tahi, tena ku lotu ake ki se lavaa kootou te tteiho i na hahaaite. Te anana raa e mataora, e meia te tinotama raa e matanaenae.” ");
INSERT INTO nuq_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kito Aia ki haere hakaraoi no lotu ake TeAtua pera ma Aia ni lotu ake i mua raa koi. ");
INSERT INTO nuq_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tena ki oti Aia ki vaakai ake hakaraoi no kite na disaipol raa ku mmoe heilloa roo; na tama raa ku se lavaa roo te kkira na karemata laatou. Tena laatou ku se illoa ma laatou ki meake peehee iaa Jisas. ");
INSERT INTO nuq_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jisas e haere no lotu te hakatoru na vahao, tena ki vaakai ake no kite na disaipol raa e mmoe koi, tena Aia ki meake, “Kootou koi mmoe koi no hamalollo? Ku tau peenaa! Te saaita hakamaoni raa ku tae mai! Kira ake, te Tamariki te Tama nei ku mee ki noho i raro na mahi na tama hai ssara raa. ");
INSERT INTO nuq_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mahhike i aruna ki oo taatou. Kira ake, teenei te tama e me ki hakari ake Anau i na tama hai ssara raa!” ");
INSERT INTO nuq_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas koi tattara koi te saaita Judas he tama i roto te sanahuru ma rua na disaipol raa ku tae ake. Judas e haere ake ma te kanohenua na maatua hakananniu, na tama poroporo na tuaa ia ma na tama hakamattua na Jiu raa ni kauna ria ki oo ake ma na paraamoa ia ma na laakau raa. ");
INSERT INTO nuq_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas e meake te kanohenua raa te hakkatu ma, “Te tama anau e mohoni raa ko te tama kootou e hihhai. Hakapiki te Tama naa, tena ku too no oo ma kootou.” ");
INSERT INTO nuq_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas e tae ake koi, tena aia ki haere tahi atu roo iaa Jisas raa no meake ma, “Rabai!”, tena aia ki mohoni Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kito na tama raa ki hakapiki Jisas, tena ki taohi mmau roo Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tena he tama e tuu i te kina raa ku uhu te paraamoa aia raa no ttuu te katarina te tama hehekau te pohouru hakanaaniu na maatua raa no hopo. ");
INSERT INTO nuq_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kito Jisas ki meake te kanohenua raa, “Kootou e oo mai ma na paraamoa ia ma na laakau ki ttaohi Anau pera ma Anau he tama se hai lou? ");
INSERT INTO nuq_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Te aho ma te aho Anau e nnoho ma kootou i roto te Hare Tapu raa no akoako, tena kootou se hakapiki Anau. Emeia na tattara te Launiu Tapu raa e me ki oo mai no hakamaoni.” ");
INSERT INTO nuq_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tena na disaipol Jisas raa hakaatoa ku tiaki Tama raa no huro i taha. ");
INSERT INTO nuq_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","He taupeara hokotahi e kkahu koi te paamaro makkini, e tautari atu vaa muri Jisas. Na tama raa e mee ma ki hakapiki te tama raa, ");
INSERT INTO nuq_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","tena te tama raa ki peesia te paamaro aia ni kkahu raa no tere se hai mee e kkahu. ");
INSERT INTO nuq_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Na tama raa e too Jisas no kkave i te hare te pohouru hakanaaniu na maatua raa, tena na maatua hakananniu raa, na tama hakamattua na Jiu raa ia ma na tama poroporo na tuaa raa ku hakkutu hakaatoa i te kina raa. ");
INSERT INTO nuq_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita e haere tautari atu vaa muri no uru i te kina te hare te pohouru hakanaaniu na maatua raa. Tena aia ki noho i te kina raa ma na soldia raa no hakamamahana te ahi raa. ");
INSERT INTO nuq_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na maatua hakananniu raa ma na tama hakamattua na Jiu raa hakaatoa ku sesee ni ara ma ki lavaa laatou te taa Jisas ki mate, e meia laatou se hai ara roo e lave. ");
INSERT INTO nuq_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tammaki na tama e oo ake no hatu na malliu laatou iaa Jisas, e meia na tattara na tama raa se hakanatahi hoki. ");
INSERT INTO nuq_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tena e isi na tama ku ttuu i aruna no haatu na malliu laatou raa iaa Jisas ma, ");
INSERT INTO nuq_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Maatou e llono te Tama nei e tattara ma, ‘Anau e me ki seu te Hare Tapu na tama e pena nei, tena i roto e toru na aho, anau e me ki hakatuu muri te hare tera se hai tama te maarama nei e me ki pena raa.’ ” ");
INSERT INTO nuq_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Emeia na tattara na tama raa hoki se hakanatahi. ");
INSERT INTO nuq_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Te pohouru hakanaaniu na maatua raa ku mahhike no tuu i mua na tama raa hakaatoa no vahiri ake Jisas ma, “Akoe e isi na tattara e me ki tattara i te vahi na tattara na tama nei e hai atu Akoe raa?” ");
INSERT INTO nuq_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Emeia Jisas e tuu hemuu koi se hai tattara roo e meake. Tena te pohouru hakanaaniu na maatua raa ki vahiri ake hakaraoi hoki ma, “Akoe ko te Mesaia, te Tamariki TeAtua e Tapu?” ");
INSERT INTO nuq_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Kito Jisas ki meake, “Teenei Anau, tena kootou hakaatoa e me ki kkite te Tamariki te Tama nei e noho i te vahi laaua TeAtua Hakanaaniu, tena Aia e me ki hamai i aruna na pukureurehu i te vaelani raa!” ");
INSERT INTO nuq_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Te pohouru hakanaaniu na maatua raa ku ssae na hekau aia raa, tena ki meake, “Maatou se hihhai ki too hoki ni tattara alaa tama. ");
INSERT INTO nuq_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kootou ku llono koi na tattara haeo Tama nei e tattara i TeAtua raa. Kaa kootou e mannatu maea?” Te kanohenua raa hakaatoa ku hakaioo ake ma Tama raa ku sara, e tau te taia ria ki mate. ");
INSERT INTO nuq_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tena alaa tama na tama raa ku kaamata no sasavare Jisas, tena ki nnoa te paamaro raa na karemata Jisas, tena ki ttuki Tama raa. Kito na tama raa ki meake ma, “Tini ma koai te tama ni ttuki Akoe raa!” Kito na soldia raa ki oo atu no riki Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita koi noho koi i aho te hare te pohouru hakanaaniu na maatua raa te saaita te taukupu hehekau te pohouru hakanaaniu na maatua raa ni haere ake. ");
INSERT INTO nuq_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Te taukupu raa e kite Pita e hakamamahana i te vahi te ahi raa, tena aia ki kkira hakamattonu ake roo iaa Pita, tena ki meake, “Akoe hoki e hahaere ma Jisas te tama i Nasaret raa.” ");
INSERT INTO nuq_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Emeia Pita e kore, tena ki meake, “Anau se iroa hea akoe e tattara naa.” Tena Pita ki haere i taha ma te kina raa no ssae i aho. Te saaita naa koi te manu tane raa ku tani. ");
INSERT INTO nuq_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Te taukupu raa e kite Pita i te kina raa, tena aia ki tattara ake na tama e ttuu vaa raa ma, “Teenei he tama na tama raa hoki!” ");
INSERT INTO nuq_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tena Pita ki kore hakaraoi hoki. Se roroa hoki, na tama e tuu vaa raa ku hai ake hoki Pita ma, “Akoe se lavaa hoki te kore pera ma akoe se hai i roto na tama raa maitaname akoe he tama i Galili.” ");
INSERT INTO nuq_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tena Pita ki meake, “Anau e meatu pera ma anau e tattara te hakamaoni! TeAtua ki mee ki hakalono llihu kame anau se tattara te hakamaoni! Anau se iroa te Tama kootou e tattara naa!” ");
INSERT INTO nuq_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Te saaita naa koi te manu tane raa ku tani tana hakarua, tena Pita ku maanatu na tattara Jisas ni meake aia ma, “I mua te manu tane raa e tani e rua na vahao, akoe e me ki kore e toru na vahao pera ma akoe se iroa Anau.” Tena Pita ku aroha roo no tanitani. ");
INSERT INTO nuq_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tahata poo na maatua hakananniu raa ku hakkutu hakavave ma na tama hakamattua na Jiu raa, na tama poroporo na tuaa raa ia ma na tama hakananniu roo hakaatoa no hakatonutonu na tattara laatou. Kito na tama raa ki haihai na rima Jisas raa, tena ki hakattaki Tama raa no kou ake iaa Pailat raa. ");
INSERT INTO nuq_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kito Pailat ki vahiri ake Jisas ma, “Akoe ko te Tuku na Jiu?” Tena Jisas ki meake “Teenaa koi akoe ku mee mai naa.” ");
INSERT INTO nuq_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na maatua hakananniu raa ku hai ake tammaki roo na tattara iaa Jisas, ");
INSERT INTO nuq_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","kito Pailat ki vahiri ake hoki ma, “Akoe e me ki tuu hemuu koi peenaa? Hakarono na tattara na tama nei e hai atu Akoe raa!” ");
INSERT INTO nuq_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jisas e tuu hemuu koi se hai tattara roo e meake, tena Pailat ku mahharo roo. ");
INSERT INTO nuq_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na hetau hakaatoa te saaita te Kai te Pasova eaa, Pailat e me ki hakattana he tama karapusi te kanohenua raa e kainno ake aia ki hakattana ma laatou raa. ");
INSERT INTO nuq_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tena he tama te inoa aia raa ko Barabas e noho i te hare karapusi te saaita naa, e mee aia ni taa te tama no mate te saaita laatou ni ppuhu raa. ");
INSERT INTO nuq_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Te kanohenua raa ku hakkutu ma ki kainno ake Pailat ki ppena hea laatou e hihhai pera ma na saaita i mua raa, ");
INSERT INTO nuq_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","kito Pailat ki vahiri ake na tama raa ma, “Kootou e hihhai ma anau ki hakattana te Tuku na Jiu raa ma kootou?” ");
INSERT INTO nuq_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Emeia Pailat e iroa ma na maatua hakananniu raa e kou ake Jisas i aia raa e mee laatou e manava kkere Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tena na maatua hakananniu raa ku tatakore ake te kanohenua raa ki meake Pailat ma ki hakattana Barabas ma laatou. ");
INSERT INTO nuq_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kito Pailat ki vahiri ake te kanohenua raa ma, “Kaa hea kootou e hihhai ma anau ki ppena i te Tama kootou e kanna ma he Tuku na Jiu raa?” ");
INSERT INTO nuq_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kito te kanohenua raa ki vaa ake ma, “Ttii Tama naa i aruna te kros!” ");
INSERT INTO nuq_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Tena Pailat ki vaakai ake ma, “Kaa he sara peehee te Tama nei ni ppena?” Na tama raa ku vaa ake hakamaroa roo ma, “Ttii Tama naa i aruna te kros!” ");
INSERT INTO nuq_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailat e hihai ma ki mee te kanohenua raa ki hihhia, tena aia ki hakattana ake Barabas i na tama raa. Kito aia ki meake na tama raa ki riki Jisas, tena ku too Tama raa no kkave no ttii i aruna te kros. ");
INSERT INTO nuq_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Na soldia raa ku too Jisas no hakattaki i roto te hare Pailat raa (i te kina e hui ma te Pretorium raa), tena na tama raa ki kanna ake na soldia raa hakaatoa ki hakkutu ake. ");
INSERT INTO nuq_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kito na soldia raa ki hakauru ake Jisas te kaukahu e ttea pouri raa, tena ki pena te hau i na laakau e tutuia raa no hakapiri ake i te pohouru Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tena na soldia raa ku tataussua ma laatou e hakammaha ake Tama raa ma, “Hakammaha te Tuku na Jiu!” ");
INSERT INTO nuq_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Na soldia raa e riki te pohouru Jisas raa ma te laakau, tena ki sasavare Tama raa, tena ki tataussua ma laatou e hakamaru ake Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Na soldia raa ku oti roo te tataussua Jisas, kito na tama raa ki ui te kaukahu e ttea pouri raa i taha, tena ki hakauru ake hakaraoi na kaukahu Tama raa. Kito na tama raa ki hakattaki Tama raa ma ki ttii i aruna te kros. ");
INSERT INTO nuq_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Na tama raa e oo no ttiri Saimon, he tama e hamai peeraa i na matakaina na vahi raa ma ki haere i roto te matakaina e rahi raa, tena na soldia raa ki meake te tama raa ki amo te kros Jisas raa. (Saimon he tama i Sairini, tena aia ko te tamana Aleksanda laaua ma Rufus.) ");
INSERT INTO nuq_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Na tama raa e hakattaki Jisas no tae i te kina e hui ma Golgota raa, e mee ma, “Te Kina te Ivi te Pohouru te tama.” ");
INSERT INTO nuq_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Na tama raa e kou ake te wain e hilo ma te maraseni e hui ma he mir raa ma ki unu Jisas, e meia Jisas e kkaro te unu. ");
INSERT INTO nuq_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kito na soldia raa ki ttii Jisas i aruna te kros, tena ki vaevae na hekau Tama raa ma laatou. Na tama raa e ttahao huhuu na hatu ki mmata ma koai te tama e me ki too he mee peehee i na hekau Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Te sivo te tahata na soldia raa ku ttii Jisas i aruna te kros. ");
INSERT INTO nuq_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tena ki tattaa na tattara nei, “Te Tuku na Jiu” ma ki illoa na tama te sara Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Na soldia raa e ttii hoki tokorua na tama kailallao ma Jisas, te tama i te vahi laaua, tena te tama i te vahi se laaua. ");
INSERT INTO nuq_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Te mee nei e mee ki hakamaoni te tattara te Launiu Tapu raa ma, “Na tama e me ki tattara ma te Tama raa e hukui ma na tama kailallao.” ");
INSERT INTO nuq_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na tama e oo hakallaka raa ku lulluu na pohouru laatou, tena ki hai ake Jisas ma, “Akoe he tama! Akoe e mee ma Akoe e me ki seu te Hare Tapu raa, tena ku hakatuu hakaraoi te hare raa i roto e toru na aho! ");
INSERT INTO nuq_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Tena tiho mai vahao nei i raro ma te kros naa, tena ku tokonaki Akoe Hokkoe!” ");
INSERT INTO nuq_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Na maatua hakananniu raa laatou ma na tama poroporo na tuaa raa ku tataussua ake hoki Jisas. Na tama raa e tattara hokolaatou ma, “Tama raa e tokonaki alaa tama, e meia Aia se lavaa te tokonaki Aia Hokoia! ");
INSERT INTO nuq_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Taatou ki mmata ma te Mesaia, te Tuku na tama Israel raa e hamai i raro ma te kros raa vahao nei, tena taatou e me ki hakattina i Aia!” Tena tokorua na tama kailallao e ttii ria hoki i aruna na kros ma Jisas raa ku hai ake hoki Tama raa. ");
INSERT INTO nuq_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tena te laa latea te henua raa hakaatoa ku pouri haere no tae roo te toru te hiahi. ");
INSERT INTO nuq_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tena te toru te hiahi Jisas ku tani ake hakamaroa ma, “Eloi, Eloi, lema sabaktani?” e mee ma, “Taku Atua, Taku Atua, aiea Akoe e tiaki Anau naea?” ");
INSERT INTO nuq_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","E isi na tama i te kina raa e llono Jisas, tena ki tattara ma, “Hakallono, Tama raa e kakanna ake Elaija!” ");
INSERT INTO nuq_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tena he tama ki tere ake ma te spans raa no ppono i roto te wain raa, tena ki nnoa te mata te laakau raa no ssau no tuku ake te maihu Jisas raa, tena ki meake, “Hakattari! Taatou ki mmata ma Elaija e me ki hamai no tuuri mai te Tama nei i raro ma te kros raa!” ");
INSERT INTO nuq_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jisas e kapihi te varo Aia raa hakamaroa, tena ki mate. ");
INSERT INTO nuq_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tena te paamaro e tootoo i roto te Hare Tapu raa ku masae i lottonu kaamata i aruna haere no hopo i raro. ");
INSERT INTO nuq_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Te tama hakamaatua na soldia raa e tuu roo i mua te kros raa no kite te mate Jisas raa, tena ki tattara ma, “Hakamaoni Te Tama nei he Tamariki TeAtua!” ");
INSERT INTO nuq_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","E isi na hhine e ttuu hakammao no matamata, tena i roto na hhine e ttuu i te kina raa ko Meri te tama i Makdala raa, Meri te tinna Jems laaua ma Josep raa, tena Salome. ");
INSERT INTO nuq_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Na hhine raa ni tauttari mai roo Jisas te saaita Aia ni noho i Galili, tena laatou e tokonaki hoki Tama raa. Tammaki hoki na hhine ni oo mai ma Jisas i Jerusalem raa e ttuu i te kina raa. ");
INSERT INTO nuq_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","43 Te mee raa ku haere ki hiahi, tena Josep te tama i Arimatea raa ku tae ake. Tama raa he tama hakanaaniu hoki, tena aia e noho no hakattari ma ki tae mai te Hakamaatua ana i te Vaelani raa. Teenaa ko te Aho e Tanattana (teenaa ko te aho i mua te Sabat), kito Josep ki haere se mataku atu no tuu i mua Pailat, tena ki meake te tama raa ma aia e me ki too te tinotama Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat ku oho roo e mee aia e rono ma Jisas ku mate. Tena aia ki kanna ake te soldia hakamaatua raa no vahiri ake ma Jisas ko naa mate roo. ");
INSERT INTO nuq_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pailat ku rono na tattara te soldia raa, tena aia ki meake ma Josep e lavaa te too te tinotama Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josep e sui te paamaro e llaha, tena aia ki turi iho te tinotama Jisas raa i raro no mmini te paamaro raa, tena ki ppono te tinotama raa i roto te taruma na tama e keri te kina na hatu i te vahi te tutu raa. Tena aia ki hakatakape ake te hatu e rahi raa no ppui te totoka te taruma raa. ");
INSERT INTO nuq_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meri te tama i Makdala raa laaua ma Meri te tinna Josep raa e ttuu no matamata no kkite te kina te tama raa e ppono te tinotama Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Te Sabat raa ku oti, tena Meri te tama i Makdala raa, tena Meri te tinna Jems raa ia ma Salome e ssui na mee mannoni ma ki amuhi te tinotama Jisas. ");
INSERT INTO nuq_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tena na hhine raa ku oo i te kina te taruma raa te tahata roo te aho te Latapu. ");
INSERT INTO nuq_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","4 Na hhine raa e haere tattara hokolaatou i aruna te mateare ma, “Koai te tama e me ki hakatakape te hatu raa i taha ma te totoka te taruma raa ma taatou?” (E mee te hatu raa e rahi roo.) Emeia na hhine raa e ttae atu no kkite ma te hatu raa ku oti te hakatakape ria i taha. ");
INSERT INTO nuq_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kito na hhine raa ki uru atu i roto te taruma raa no kkite te tama e uru na hekau makkini roo e noho te vahi laaua, tena na hhine raa ku oho roo. ");
INSERT INTO nuq_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kito te tama raa ki meake, “Auu se oho, anau e iroa kootou e sesee Jisas te Tama i Nasaret tera ni ttii ria i aruna te kros raa. Te Tama raa ku seai i te kina nei, Aia ku oti te ora muri! Kira ake, teenei te kina na tama raa ni hakamoe te tinotama Aia. ");
INSERT INTO nuq_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tena oo vahao nei no meake na disaipol Aia raa, hakapaa hoki ma Pita pera ma, ‘Tama raa ku haere i mua kootou i Galili; kootou e me ki kkite Tama raa i te kina raa pera ma Aia ni tattara atu kootou raa.’ ” ");
INSERT INTO nuq_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kito na hhine raa ki huro i taha ma te taruma raa, ia e poreppore roo te mattaku. Na hhine raa se isi te tama ni tattara ake, e mee laatou e mattaku.  ");
INSERT INTO nuq_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisas e tuu ake iaa Meri te hine i Makdala Aia ni hakaise e hitu na tipua i taha raa, teenaa ko te tahata roo te aho te Latapu te saaita Aia ni mahike muri no ora. ");
INSERT INTO nuq_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tena Meri ki haere no tattara ake na tama ni hahaere ma Jisas raa. Na tama raa e ppari no tanittani, ");
INSERT INTO nuq_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","e meia te saaita na tama raa ni llono Meri te hine i Makdala raa e tattara ma Jisas ku ora ia ma aia e kite hoki Tama raa, tena na tama raa ku se hakattina na tattara te hine raa. ");
INSERT INTO nuq_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tena ki oti Jisas ku tuu ake hoki i te tokorua na disaipol te saaita tokorua raa ni tiaki te matakaina raa no oo. ");
INSERT INTO nuq_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tena tokorua raa ku vakkai no tattara ake alaa disaipol pera ma laaua e kkite Jisas, e meia na tama raa se hakattina hoki na tattara tokorua raa. ");
INSERT INTO nuq_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tena ki oti roo Jisas ku tuu ake i te sanahuru ma tahi na disaipol raa te saaita na tama raa ni kkai. Aia e hai ake na disaipol raa, e mee na tama raa se isi na hakattina, ia e mee hoki na tama raa e hainattaa roo te hakattina na tattara na tama ni kkite ma Aia ku ora muri raa. ");
INSERT INTO nuq_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tena Jisas ki meake na disaipol raa ma, “Oo i na kina hakaatoa i roto te maarama nei raa no takutaku ake te Rono Tauareka raa i na tama roo hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Koai te tama e hakatina no too te hakoukou tapu raa e me ki ora, tena te tama se hakatina raa e me ki hakatonutonu ria. ");
INSERT INTO nuq_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na tama e hakattina raa e me ki too na mahi ki ppena na mirakol: na tama naa e me ki hakaise na tipua i taha i te inoa Anau; na tama naa e me ki tattara ake na tattara vahao nei raa i na tama se illoa raa; ");
INSERT INTO nuq_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","kame na tama naa e ttaohi na lapono, ia e unu na vai maraseni e lavaa te taa te tama ki mate raa; na tama naa se lavaa te mmate, tena na tama naa e me ki hakappiri na rima laatou raa i aruna na tama lavvea raa no taualleka.” ");
INSERT INTO nuq_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","TeAriki Jisas e tattara ake na disaipol raa no oti, tena Aia ku too ria no kkave i te vaelani no noho i te vahi laaua TeAtua raa. ");
INSERT INTO nuq_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tena na disaipol raa ku oo no takutaku na kina roo hakaatoa. TeAriki e hehekau ma na tama raa ki huri ake pera ma na takutaku na disaipol raa e hakamaoni i na mirakol na tama raa e ppena raa.");
INSERT INTO nuq_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tiofilus, te hakamaatua: Tammaki na tama e hai na mahi laatou ma ki tattaa ni launiu ki hakari atu na mee Jisas ni huri mai taatou raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Na tama raa e tattaa na mee taatou ni llono na tama ni kkite na mee raa i te kaamata raa roo, tena ki haere tattara na tattara raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Maitaname anau ni too hakaraoi roo na tiputipu nei hakaatoa i te kaamata roo, tena anau e maanatu ma kame e tauareka anau te taataa atu te launiu nei i akoe, ");
INSERT INTO nuq_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ki iroa akoe pera ma te akoako akoe ni rono raa e hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","He maatua i roto te hareakina Abiya raa e noho te saaita Herot ni tuku i roto Judia raa, te inoa aia raa ko Sekaraia. Tena te avana aia raa ko Elisabet, he hine i roto te hareakina Aron raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sekaraia laaua ma Elisabet e tauttari tahi na tuaa TeAtua raa, ia tokorua raa hoki e ttonu tahi i mua na karemata TeAtua. ");
INSERT INTO nuq_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tokorua raa ku mattua hakaatoa, e meia laaua se ki hai tamalliki roo e mee Elisabet e poka. ");
INSERT INTO nuq_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Teeraa he aho, na maatua raa e hirihiri Sekaraia ki too te lotu i roto te Hare Tapu te sao aia. Sekaraia e hehekau ma TeAtua pera ma he maatua. ");
INSERT INTO nuq_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Teenei he tiputipu na maatua raa, tena na maatua raa e ttahao na hatu no hirihiri Sekaraia ki haere no hakkaa te insens i aruna te olta raa. Kito Sekaraia ki haere i roto te Hare Tapu TeAtua raa, ");
INSERT INTO nuq_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","tena te kanohenua i aho raa ku lotu te saaita Sakaraia ni haere no hakkaa te insens raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tena te ensel TeAtua raa ku tuu ake iaa Sekaraia i te vahi laaua te olta i te kina te insens raa e ura raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Te saaita Sekaraia ni kite te ensel raa, aia ku oho roo no mataku. ");
INSERT INTO nuq_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tena te ensel raa ki meake, “Sekaraia! Auu se mataku, TeAtua ku rono te lotu akoe raa, tena Elisabet te avana akoe raa e me ki haanau he tamariki tanata ma akoe, tena akoe ku hui te inoa te tamariki naa Jon. ");
INSERT INTO nuq_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Te saaita naa, akoe e me ki hihia roo, tena tammaki na tama e me ki hihhia hoki te saaita te tamariki naa e haanau iho raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Jon e me ki hakanaaniu i mua na karemata TeAtua. Tama naa se lavaa te unu na wain ia ma na vai mmara. TeAnana Tapu e me ki noho i roto te tama naa kaamata te saaita aia e me ki haanau iho raa, ");
INSERT INTO nuq_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","tena Jon e me ki hakattaki tammaki na tama Israel ki vakkai muri ake TeAtua, TeAriki laatou raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jon e me ki haere i mua TeAriki ma na mahi hai mmahi pera ma ko profet Elaija. Tama naa e me ki hakapaa hakaraoi na tamana ia ma na tamalliki laatou raa. Tena Jon e me ki poroporo na tama e hakatapanatta raa ki hakallono na tattara mattonu na tama e ttonu tahi raa. Ia tena aia e me ki poroporo te kanohenua TeAtua raa ki tanattana te hamai TeAriki.” ");
INSERT INTO nuq_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tena Sekaraia ki meake te ensel raa, “Anau e me ki iroa peehee ma na tattara akoe naa e me ki hakamaoni? E mee anau ku matua, tena te avana anau raa hoki ku matua.” ");
INSERT INTO nuq_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kito te ensel raa ki meake, “Anau ko Gabriel, tena anau e tuu i mua TeAtua te Tama e kauna ria iho anau ki tattara atu akoe na tattara taualleka nei. ");
INSERT INTO nuq_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Emeia teenaa akoe se hakatina na tattara teeraa e me ki oo mai no hakamaoni he saaita raa, tena akoe e me ki se lavaa te tattara; te maihu akoe naa e me ki puni ki tae roo te saaita te tamariki naa e haanau iho raa.” ");
INSERT INTO nuq_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Te saaita naa, te kanohenua tera e hakattari Sakaraia ki hamai i mata hare raa ku mamannatu tammaki e mee te tama raa e nnahe roo te hakahura mai i aho. ");
INSERT INTO nuq_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Te saaita Sakaraia ni hakahura iho raa, aia ku se lavaa te tattara, tena na tama raa ku illoa pera ma te tama raa e isi te kite aia i roto te Hare Tapu. Tena Sekaraia ki auna ake na tama raa, e mee aia ku se lavaa te tattara. ");
INSERT INTO nuq_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Te saaita Sekaraia ni oti na hehekau aia i roto te Hare Tapu raa, tena aia ki vaakai muri i hare. ");
INSERT INTO nuq_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ki oti roo Elisabet te avana aia raa ku hai tama, tena i roto e rima na marama, aia ku munimuni koi vaa hare, se hahaere vaa aho. ");
INSERT INTO nuq_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elisabet ku tattara ma, “Te saaita nei roo TeAtua ku tokonaki anau, tena Aia e tokea te napa anau ni isi i mua te kanohenua raa i taha.” ");
INSERT INTO nuq_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","27 Elisabet ku tae te hakaono na marama aia, tena TeAtua ki kauna ria iho ensel Gabriel ki tattara ake Meri, he taukupu e tonu tera e noho i Nasaret, he matakaina i roto Galili. Te taukupu raa e hakamattino ma te taupeara e hui ma ko Josep, he tama i roto te hareakina te tuku Devit raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Te ensel raa e haere iho no meake Meri ma, “Te noho laoi ki noho ma akoe! TeAriki e hakatapu akoe, tena ki rorohi laoi akoe.” ");
INSERT INTO nuq_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Meri ku tipuaina haeo roo i na tattara te ensel raa, tena aia ku maanatu ma te hakataakoto na tattara te ensel raa e mee maea. ");
INSERT INTO nuq_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tena kito te ensel raa ki meake, “Meri! Akoe se lavaa te mataku, TeAtua e hakatapu akoe. ");
INSERT INTO nuq_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Akoe e me ki hai tama no haanau he tamariki tanata, tena akoe ku hui te inoa te tamariki naa Jisas. ");
INSERT INTO nuq_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tama naa e me ki hakanaaniu, tena Aia e me ki kanna ria ma, te Tamariki TeAtua i Aruna. TeAtua e me ki mee te Tama naa ki tuku pera ma Devit te tipuna Aia i mua raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Tama naa e me ki hakamaatua i aruna te kaha Jekop raa na vahao hakaatoa, tena te Hakamaatua ana Aia raa se isi te hakaoti.” ");
INSERT INTO nuq_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tena kito Meri ki meake te ensel raa, “Anau he taukupu e tonu, ia se hai tama ni mmoe ma anau, kaa anau e me ki hai tama peehee?” ");
INSERT INTO nuq_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kito te ensel raa ki meake, “TeAnana Tapu e me ki noho ma akoe, tena na mahi TeAtua raa e me ki takoto i roto akoe. Tena i te hakataakoto nei koi te tamariki e tapu naa e mee ki taapa ma te Tamariki TeAtua. ");
INSERT INTO nuq_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Maanatu te tinna akoe raa, Elisabet. Na tama e tattara ma te tama raa ku se lavaa te isi na tamalliki, e meia te saaita nei aia ku hai tama, tena teenei ko te hakaono na marama aia, niaina ma aia ku matua haeo roo. ");
INSERT INTO nuq_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Maitaname se isi roo te mee e hainattaa ma TeAtua te ppena.” ");
INSERT INTO nuq_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kito Meri ki meake, “Anau he taukupu e hehekau ma TeAtua, tena hea akoe ni tattara mai raa, tiaki peenaa ki kapihi mai anau pera ma akoe ni tattara mai raa.” Tena kito te ensel raa ki tiaki te hine raa no haere. ");
INSERT INTO nuq_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Se roroa i muri koi te ensel raa ni tattara ake raa, tena Meri ku haere i te hare Sekaraia i te matakaina tera e tuu i aruna na mouna i Judia raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Meri ku tae atu i te hare raa, tena aia ki kanna ake Elisabet, te avana Sekaraia raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Te saaita Elisabet ni rono te nnana Meri raa, te tamariki i roto aia raa ku hihia no tatahuki, tena TeAnana Tapu raa ku tau i roto Elisabet. ");
INSERT INTO nuq_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tena aia ki tattara hakamaroa ake ma, “Akoe e hakatapu ria TeAtua, e raka i aruna ma alaa taukupu. Tena TeAtua e me ki hakatapu te tamariki akoe e me ki haanau raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Akoe ko te tinna taku Ariki, tena anau e maaharo e mee akoe e hamai no mmata anau. ");
INSERT INTO nuq_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Te saaita anau ni rono te nnana akoe raa, te tamariki i roto te manava anau nei e hihia roo no tatahuki. ");
INSERT INTO nuq_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Akoe e me ki hakatapu ria e mee akoe e hakatina pera ma na tattara TeAtua e tattara atu akoe raa e me ki oo mai no hakamaoni!” ");
INSERT INTO nuq_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tena Meri ki tattara ma, “Taku hatu manava e hakammaha TeAtua, ");
INSERT INTO nuq_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","te anana anau e hihia i TeAtua taku Tokonaki, ");
INSERT INTO nuq_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","maitaname Aia e maanatu roo anau, te tama mouraro e hehekau Aia nei! Kaamata te saaita nei na tama hakaatoa e me ki tattara ma anau ku hakatapu ria, ");
INSERT INTO nuq_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","e mee na mee e llahi TeAtua Hai mahi raa ni ppena i anau raa. Te inoa Aia raa e tapu; ");
INSERT INTO nuq_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","kaamata teeraa tautama haere no tae teeraa tautama, Aia e me ki huri ake te aroha Aia raa i na tama e hakammaha Aia raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Aia e ssora iho te rima hai mahi Aia raa, no hakatui na tama hai ahu e hai mannatu raa i taha. ");
INSERT INTO nuq_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Aia e hakatuu na tuku hai mmahi raa i taha ma na nohorana laatou raa, tena ki ssau na tama mouraro raa ki hakananniu. ");
INSERT INTO nuq_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","TeAtua e haanai na tama e hikkai raa no ppohu ma na mee taualleka, tena ki kauna na tama hai sileni raa i taha, se hai mee e kou ake. ");
INSERT INTO nuq_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","TeAtua e taohi mmau na tattara hakamaoni Aia ni meake na tipuna taatou raa, tena ki hamai no tokonaki Israel, te tama hehekau Aia raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Aia e maanatu ma ki huri ake te laoi Aia raa iaa Abraham, ia ma na hai mokopuna aia raa na vahao hakaatoa.” ");
INSERT INTO nuq_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meri e nnoho laaua ma Elisabet no ttae e toru na marama, tena aia ki vaakai muri i te matakaina aia raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet ku tae te saaita aia ku mee ki mamaoha, tena aia e haanau te tamariki tanata. ");
INSERT INTO nuq_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Na tama te kauhare raa ia ma na hareakina aia raa ku llono pera ma TeAtua e aroha no tokonaki Elisabet, tena na tama raa ku hihhia hakaatoa ma Elisabet. ");
INSERT INTO nuq_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Te saaita te tamariki raa ku tae e varu na aho te matua aia, na tama hakamattua raa ku oo ake no ttuu te hakamaatino e tapu te tamariki raa, tena na tama raa ku mee ma ki hui te tamariki raa Sekaraia, te inoa te tamana te tamariki raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Emeia Elisabet te tinna te tamariki raa e meake ma, “Seai! Te inoa te tamariki naa ko Jon.” ");
INSERT INTO nuq_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kito na tama raa ki meake Elisabet, “Emeia se hai tama i roto te hareakina akoe raa e hui te inoa naa.” ");
INSERT INTO nuq_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kito na tama raa ki auna ake te tamana te tamariki raa ma te tamariki raa e me ki hui aai. ");
INSERT INTO nuq_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tena Sekaraia ki auna ake ma ki kou ake he mee ki taataa, tena aia ki taataa na tattara nei, “Te inoa te tamariki nei ko Jon.” Tena na tama raa hakaatoa ku mahharo roo. ");
INSERT INTO nuq_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Te saaita naa koi Sekaraia ku lavaa te tattara hakaraoi, tena aia ki hakammaha TeAtua. ");
INSERT INTO nuq_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Na tama te matakaina raa ku mattaku, tena te rono raa ku paa no ttae alaa matakaina i aruna na mouna i roto Judia raa hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Na tama e llono te rono raa ku mamannatu tammaki, tena ki tattara ma, “Te tamariki naa e me ki tipu peehee?” E mee ku matahua pera ma TeAtua e kou ake na mahi Aia raa i te tamariki raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","TeAnana Tapu raa ku tau i roto Sekaraia, te tamana Jon raa, tena Sekaraia ki tattara ake na tattara TeAtua nei, ");
INSERT INTO nuq_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Taatou ki hakammaha TeAtua, TeAriki na tama Israel raa! Aia ni hamai ki tokonaki no hakattana te kanohenua Aia raa i taha ma na hai sara laatou raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","TeAtua e kou mai te Tama hai mahi ki tokonaki taatou, Tama raa he mokopuna Devit, te tama hehekau Aia raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Aia ni tattara hakamaoni ake na profet e ttapu Aia i mua raa ");
INSERT INTO nuq_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","pera ma Aia e me ki hakattana taatou i taha ma na tama e nohonoho haeo ma taatou raa, ia i taha hoki ma na mahi na tama e kiri lloto taatou raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Aia e tattara ma Aia e me ki huri ake te laoi Aia raa i na tipuna taatou raa, tena ku maanatu na tattara hakamaoni e ttapu Aia raa. ");
INSERT INTO nuq_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","74 TeAtua e tattara hakamaoni ake Abraham te tipuna taatou raa pera ma Aia e me ki hakattana taatou i taha ma na mahi na tama e nohonnoho haeo ma taatou raa, ki se mattaku taatou te hehekau tahi ma Aia, ");
INSERT INTO nuq_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ia ki mee na ora taatou raa ki ttapu, ia ki ttonu tahi hoki i mua na karemata TeAtua na aho hakaatoa i roto na ora taatou. ");
INSERT INTO nuq_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Taku tama, akoe e me ki kanna ria pera ma he profet TeAtua Hakanaaniu i Aruna. Akoe e me ki haere i mua TeAriki, no tanattana te mateara Aia ki hamai vaa aruna, ");
INSERT INTO nuq_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","no hakailloa ake na kanohenua Aia raa pera ma laatou e me ki ora, kame laatou e ttike i taha na hai sara laatou. ");
INSERT INTO nuq_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","TeAtua taatou raa he atua e manava aroha, ia e laoi. Aia e me ki mee te maahina te noho laoi raa ki maahina mai i aruna taatou, ");
INSERT INTO nuq_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","tena ku hakamaahina mai te vaelani raa i aruna na tama e nnoho i raro te maru te mate raa, tena ku hakattaki taatou raa ki oo tonu i te mateara te noho laoi raa.” ");
INSERT INTO nuq_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Te tamariki raa e homo no matua, ia e atamai hoki. Tena aia e noho i te kina se hai tama e tuu mahoa raa no tae roo te saaita aia ni hakahura iho no tuu i mua na tama Israel raa. ");
INSERT INTO nuq_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Te saaita naa, Ogastus te tuku hakanaaniu i Rom raa e hakamoe te tuaa ma na tama i Rom raa hakaatoa ki oo i na matakaina laatou raa no hakamaumau na inoa laatou raa i roto na launiu te taumani i Rom raa. ");
INSERT INTO nuq_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Te hakamaumau kaamata na inoa nei e kapihi mai te saaita Kwirinius ni hakamaatua i roto Siria. ");
INSERT INTO nuq_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ia tena na tama hakaatoa ku oo no hakamaumau na inoa laatou raa i na matakaina na tipuna laatou raa ni nnoho mai i mua. ");
INSERT INTO nuq_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep ku tiaki Nasaret he matakaina i roto Galili no haere i Betlehem i roto Judia, te matakaina te tuku Devit raa ni haanau mai raa. Josep e haere i te matakaina raa, e mee aia e mamaoha iho i roto te hareakina Devit. ");
INSERT INTO nuq_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josep e oo laaua ma Meri, te taukupu e hakamattino ma ki avvana laaua raa: tokorua raa e oo ma ki hakammau na inoa laaua raa. Meri e hai tama, ");
INSERT INTO nuq_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","tena te saaita tokorua raa koi nnoho koi i Betlehem, Meri ku tae te saaita aia ku mee ki mamaoha. ");
INSERT INTO nuq_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Meri ku haanau te arapou tanata kaamata aia raa, tena aia ki taapuru te tamariki raa na paamaro, tena ki hakamoe te tamariki raa i roto te kumete na manu raa e kaikkai. Tokorua raa e nnoho i roto te hare na manu raa, maitaname na hare na tama e moemmoe i te matakaina raa ku kkapi hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Te poo naa, e isi na tama lollohi na manu e nnoho i roto na paupaku tappiri ake i Betlehem raa no lollohi na sipsip laatou raa. ");
INSERT INTO nuq_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Te ensel TeAtua raa e tuu ake i na tama raa, tena na mahi TeAtua raa ku hakamaahina ake na tama raa. Na tama raa ku mattaku haeo roo, ");
INSERT INTO nuq_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","e meia te ensel raa e meake na tama raa ma, “Kootou ki se mattaku, maitaname anau e hamai ma te Rono Tauareka tera e me ki kou atu te hihia e rahi roo i na tama hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Te aho nei i roto te matakaina Devit i Betlehem, Krais TeAriki, te Tokonaki kootou raa ku haanau iho. ");
INSERT INTO nuq_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Te mee nei e me ki huri atu te hakamaoni i na tattara anau nei: kootou e me ki kkite te tamariki e taapuru na paamaro e moe i roto te kumete na manu e kaikkai.” ");
INSERT INTO nuq_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tena te saaita naa koi tammaki na ensel i te vaelani ku hukui ake ma te ensel raa no hakammaha TeAtua ma, ");
INSERT INTO nuq_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Hakammaha TeAtua i te vaelani i aruna, ia ki nnoho laoi na tama i te maarama nei tera Akoe e hihia na tiputipu laatou raa.” ");
INSERT INTO nuq_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Te saaita na ensel raa ni vakkai muri i te vaelani, na tama e lollohi na manu raa ku tattara hokolaatou ma, “Taatou ki oo i Betlehem no mmata na mee TeAtua e meake na ensel Aia raa ki tattara mai taatou raa.” ");
INSERT INTO nuq_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kito na tama raa ki hai taruaru no oo no kkite Meri laaua ma Josep, tena ki kkite hoki te tamariki raa e moe i roto te kumete na manu e kaikkai raa. ");
INSERT INTO nuq_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Te saaita na tama lollohi na manu raa ni kkite te tamariki raa, na tama raa ku tattara ake na tama i te matakaina raa na tattara te ensel raa ni tattara ake laatou i te vahi te tamariki raa. ");
INSERT INTO nuq_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Na tama hakaatoa ni llono na tattara na tama lollohi na manu raa ku mahharo roo. ");
INSERT INTO nuq_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tena Meri e maanatu na mee raa hakaatoa, tena ki kkumi hemuu na tattara raa i roto te hatu manava aia. ");
INSERT INTO nuq_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Na tama lollohi na manu raa ku vakkai, tena ki huhua na rue no hakammaha ake TeAtua, maitaname hea laatou ni llono ia ma hea laatou ni kkite raa, e ssau roo pera ma hea te ensel raa ni tattara ake laatou raa. ");
INSERT INTO nuq_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","I muri e varu na aho, te saaita te tamariki raa ku mee ki ttuu te hakamaatino e tapu raa, na tama raa ku hui te tamariki raa Jisas, te inoa te ensel raa ni meake i mua Meri ni hai tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ia te saaita ki mee Meri ki matahua pera ma na tuaa Moses e tattara raa ku tae. Tena tokorua raa ki too hoki Jisas no oo ma laaua i te Hare Tapu ma ki hoki ake te tamariki raa iaa TeAtua ");
INSERT INTO nuq_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","pera ma hea e mmau i roto na tuaa TeAtua raa ma: “Na arapou taanata hakaatoa e me ki ttapu i na karemata TeAriki.” ");
INSERT INTO nuq_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tokorua raa e oo ma ki hoki ake e rua na rupe, kaa seai e rua na reia pera ma hea e mmau i roto na tuaa TeAtua raa. ");
INSERT INTO nuq_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","He tama e hui ma ko Simion e noho i Jerusalem te saaita naa. Te tama raa e tonu tahi, ia he tama hoki e hakatina, tena aia e noho no ttari te saaita TeAtua e me ki tokonaki na tama Israel raa ki ora. TeAnana Tapu raa ku tau i roto Simion, ");
INSERT INTO nuq_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","tena TeAnana Tapu raa ni tattara ake Simion pera ma aia e me ki kite te Mesaia TeAtua ni tattara ma Aia e me ki kou mai raa i mua Simion e mate. ");
INSERT INTO nuq_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kito TeAnana Tapu raa ki hakattaki Simion i roto te Hare Tapu raa. Meri laaua ma Josep e too Jisas no kkave i te Hare Tapu raa ma ki ppena hea e mmau na tuaa raa, ");
INSERT INTO nuq_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","tena Simion ku kapake no ssau te tamariki raa, tena ki hakammaha ake TeAtua peenei, ");
INSERT INTO nuq_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“TeAtua, Akoe e ttaohi mmau roo na tattara Akoe raa no tae roo te saaita nei, tena tiaki te tama hehekau Akoe nei ki haere ma te noho laoi, ");
INSERT INTO nuq_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","e mee Anau ku kite roo ma na karemata anau te Tama e me ki tokonaki maatou ki ora raa, ");
INSERT INTO nuq_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","te Tama Akoe ni tanattana i mua na karemata na tama hakaatoa: ");
INSERT INTO nuq_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Aia ko te maahina tera e me ki huri ake hea Akoe e hihai raa ki illoa na tama seai ma ni Jiu raa, tena ku kou ake na mahi Akoe raa i na tama Israel raa.” ");
INSERT INTO nuq_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Josep laaua ma Meri ku mahharo haeo roo i na tattara Simion e tattara i te vahi Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tena kito Simion ki hakatapu te hai maatua raa, tena aia ki meake Meri, “TeAtua e hirihiri te tamariki nei ma ki seu na tama se hakattina raa, tena ku kou ake te nnoho laoi i na tama Israel raa. Te Tamariki nei e me ki mee pera ma he hakkatu TeAtua tera tammaki na tama e me ki tattara hakameemee i te tamariki nei ");
INSERT INTO nuq_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","tena te tamariki nei e me ki hakari na hakataakoto na tama raa, tena te aroha akoe raa e me ki ssau pera ma he paraamoa e taaro i roto te hatu manava akoe.” ");
INSERT INTO nuq_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","37 He tautukaha hine ku matua roo e noho i te kina raa, tena aia he profet hoki. Te tamana aia raa ko Fanuel, he tama i roto te hareakina Aser. Aia ni noho ma te tanata aia raa e hitu koi na hetau, tena te avana aia raa ku mate, tena te saaita nei aia ku tae tipu varu ma haa na hetau te matua aia. Te hine raa e haere tahi i te Hare Tapu, tena te ao ma te poo aia e hakammaha TeAtua, tena ki hakamaatapu tahi, ia e lotu tahi hoki. ");
INSERT INTO nuq_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Te paa saaita naa koi, Ana ku tae ake hoki no hakammaha TeAtua, tena ki tattara ake i te vahi te tamariki raa i na tama tera e nnoho no hakattari ma TeAtua e me ki hakattana na tama Jerusalem raa. ");
INSERT INTO nuq_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josep laaua ma Meri e ppena no oti roo hea e mmau i roto na tuaa TeAtua raa, tena tokorua raa ki vakkai i Nasaret, te matakaina laatou i roto Galili raa. ");
INSERT INTO nuq_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Te tamariki raa e homo no matua, ia e atamai hoki, maitaname TeAtua e hihia te Tamariki raa, tena ki hakatapu Tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Na hetau hakaatoa, na maatua Jisas raa e oo i Jerusalem ki kkai te Kai te Pasova raa. ");
INSERT INTO nuq_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisas te saaita naa ku tae sanahuru ma rua na hetau te matua Aia, tena laatou hai maatua ku oo i te Kai te Pasova raa pera ma laatou ni hahaere tahi na hetau hakaatoa raa. ");
INSERT INTO nuq_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Te kai raa ku oti, tena laatou ku vakkai muri i te matakaina laatou raa, e meia Jisas e noho koi i Jerusalem. Na maatua Aia raa se illoa ma Jisas ni se oo laatou. ");
INSERT INTO nuq_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tokorua raa e mannatu ma Jisas e hahaere ma te kautana laatou e oo raa, tena ki oo te aho naa hakaatoa. Te hiahi tokorua raa ku sesee, tena ki vahihhiri ake na llave ana ia ma na soa laoi laaua raa ma Jisas i hee. ");
INSERT INTO nuq_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Tokorua raa ku se lave Tama raa, tena laaua ki vakkai i Jerusalem ma ki ssee Jisas. ");
INSERT INTO nuq_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Te aho tana hakatoru tokorua raa ku lave Jisas i roto te Hare Tapu, e noho ma na tisa na Jiu raa no hakalollono, tena ki vahihhiri ake na vahiri i na tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Na tama hakaatoa ni llono te Tamariki raa e sui muri ake na vahiri laatou raa ku mahharo roo i te mattonu te Tamariki raa. ");
INSERT INTO nuq_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Na maatua Jisas raa ku oho hoki te saaita laaua ni kkite te Tamariki raa, tena te tinna Aia raa ki meake, “Taku tama, aiea Akoe e mee peenaa i maaua naea? Maaua ku mmate roo te sesee Akoe.” ");
INSERT INTO nuq_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tena kito Jisas ki meake, “Aiea koorua e sesee Anau naea? Koorua se illoa pera ma Anau e me ki noho i roto te hare te Tamana Anau nei?” ");
INSERT INTO nuq_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Emeia tokorua raa se illoa hea Jisas e tattara ake raa. ");
INSERT INTO nuq_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kito Jisas ki vakkai muri ma na maatua Aia raa i Nasaret, tena Aia e hakarono roo tokorua raa. Meri e kkumi hemuu na tattara hakaatoa te Tamariki raa i roto te hatu manava aia. ");
INSERT INTO nuq_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Tena Jisas e matua vave, ia e atamai hoki. TeAtua e hihia i na tiputipu te Tamariki raa, e ssau hoki pera ma te kanohenua raa hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Teenei ko te hakasehui ma rima na hetau Taiberias e tuku i Rom, tena Pontius Pailat e hakamaatua i roto Judia, tena Herot e hakamaatua i roto Galili. Filip te taina Herot raa e hakamaatua i roto Ituria laaua ma Trakonitis, ia tena Lisanias e hakamaatua i roto Abilene. ");
INSERT INTO nuq_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Tena Anas laaua ma Kaiafas ko na pohouru hakananniu na maatua raa. Te saaita naa, na tattara TeAtua raa ku ttiri Jon te taupeara Sekaraia raa i roto te kina e tuu mahoa raa. ");
INSERT INTO nuq_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tena Jon ku haere vaa roto na kina hakaatoa tappiri te riva Jordan raa no takutaku ake ma, “Ttike i taha ma na hai sara kootou raa, tena anau ku hakoukou tapu kootou. TeAtua e me ki ssoro na hai sara kootou raa i taha.” ");
INSERT INTO nuq_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","E ssau pera ma profet Aisaia ni taataa mai i roto te launiu aia ma, “He tama e takutaku i te kina e tuu mahoa ma, Tanattana te mateara TeAriki ki hamai vaa aruna. Tena ku hakatonu te mateara Aia raa ki tonu. ");
INSERT INTO nuq_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tanu na kina notonoto raa ki mmore. Tena ku ssari na mouna ia ma na tutu raa ki hakanatahi. Hakattonu na mateara e ppiko raa ki ttonu, tena ku hakamoremore na kina papapa haeo raa ki pappapa laoi. ");
INSERT INTO nuq_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tena na tama roo hakaatoa e me ki kkite TeAtua e tokonaki laatou ki ora.” ");
INSERT INTO nuq_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tena tammaki na tama ku oo ake Jon ma tama raa ki hakoukou tapu laatou. Kito Jon ki meake na tama raa, “Kootou ni lapono. Koai te tama e meatu ma kootou e lavaa te hakassao i taha ma na hakalono llihu TeAtua e me ki kou atu kootou raa? ");
INSERT INTO nuq_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ppena na mee taualleka ki huri ake pera ma kootou ku ttike i taha ma na hai sara kootou. Tena auu se ahu ma Abraham he tipuna kootou. Anau e meatu kootou pera ma TeAtua e lavaa te huri na hatu nei ki mee peeraa ma ni mokopuna Abraham. ");
INSERT INTO nuq_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Te taku TeAtua raa ku tanatana ki ttuu na patiaka na laakau raa; na laakau hakaatoa se hhua na hua taualleka raa e me ki tuutia ki hina, tena ku lletu i roto te ahi.” ");
INSERT INTO nuq_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kito te kanohenua raa ki meake Jon, “Maatou e me ki mee peehee?” ");
INSERT INTO nuq_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tena Jon ki meake, “Te tama e isi e rua na kaukahu raa ki kou ake he kaukahu hokotahi ma te tama se isi raa. Tena te tama e isi na kai raa ki vvae na kai aia raa ma alaa tama.” ");
INSERT INTO nuq_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Na tama e aoao na takis te taumani raa e hihhai hoki ma Jon ki hakoukou tapu laatou. Tena na tama raa ki meake, “Rabai, hea maatou e me ki ppena?” ");
INSERT INTO nuq_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tena Jon ki meake na tama raa, “Kootou ki se too na sileni ki raka i aruna ma hea na tama hakamattua raa e meatu kootou ki too raa.” ");
INSERT INTO nuq_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tena na soldia raa ki meake Jon, “Kaa maatou? Hea maatou e me ki ppena?” Kito Jon ki meake na tama raa, “Auu se malliu no too na sileni te kanohenua raa ki raka ma te kooina kootou e tau te too raa. Kootou ki hihhia koi ma na sui kootou raa.” ");
INSERT INTO nuq_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Te kanohenua raa e nnoho ma te hakattina pera ma te Mesaia raa e me ki hamai, tena laatou ku mamannatu ma Jon kame ko te Mesaia raa. ");
INSERT INTO nuq_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tena Jon ki tattara ake te kanohenua raa hakaatoa ma, “Anau e hakoukou tapu kootou ma te vai, e meia e isi te tama e me ki hamai i muri anau tera e hakanaaniu roo i aruna anau. Anau se tau hoki te vvete na maea na taka Aia e uru raa. Tama raa e me ki hakoukou tapu kootou ma TeAnana Tapu ia ma te ahi. ");
INSERT INTO nuq_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tama raa ku tuu ma te tahitahi Aia raa ki vvae na hua raa i taha ma na penu na hua raa, tena ku hakkutu na hua raa i roto te hare Aia raa, tena ku ttuni na penu na hua raa.” ");
INSERT INTO nuq_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","E tammaki roo na ara tera Jon e takutaku ake te Rono Tauareka TeAtua raa i na kanohenua raa, tena aia ki meake hoki na tama raa ki peesia na tiputipu sakkino laatou raa. ");
INSERT INTO nuq_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tena Jon ki hai ake Herot, te tama e hakamaatua i roto Judia raa, e mee Herot e avana Herodias te avana te taina roo aia raa, tena ki ppena hoki tammaki na mee se ttonu. ");
INSERT INTO nuq_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tena Herot ki ppena te mee sakkino roo no ppono Jon i roto te hare karapusi. ");
INSERT INTO nuq_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Na tama raa ku oti te hakoukou tapu ria hakaatoa, tena Jon ki hakoukou tapu hoki Jisas. Te vaelani raa ku taaraki te saaita Jisas ni lotu raa, ");
INSERT INTO nuq_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","tena TeAnana Tapu raa ku llee iho i aruna Jisas pera ma he rupe. Tena TeAtua ki tattara iho i te vaelani ma, “Akoe he Tamariki hakamaoni roo Anau. Anau e hihia roo i Akoe.” ");
INSERT INTO nuq_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Te saaita Jisas ni kaamata na hehekau Aia raa, Aia ku taapiri ki tae tipu toru na hetau te matua Aia. Tena Jisas ko te Tama te kanohenua raa e mannatu ma he tamariki Josep raa. Tena Josep he tama Heli. ");
INSERT INTO nuq_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli he tama Matat. Matat he tama Livai. Livai he tama Melki. Melki he tama Janai. Janai he tama Josep. ");
INSERT INTO nuq_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep he tama Matatias. Matatias he tama Amos. Amos he tama Nahum. Nahum he tama Esli. Esli he tama Nagai. ");
INSERT INTO nuq_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai he tama Mat. Mat he tama Matatias. Matatias he tama Semein. Semein he tama Josek. Josek he tama Joda. ");
INSERT INTO nuq_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda he tama Joanan. Joanan he tama Resa. Resa he tama Serubabel. Serubabel he tama Sealtiel. Sealtiel he tama Neri. ");
INSERT INTO nuq_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri he tama Melki. Melki he tama Adi. Adi he tama Kosam. Kosam he tama Elmadam. Elmadam he tama Er. ");
INSERT INTO nuq_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er he tama Josua. Josua he tama Elieser. Elieser he tama Jorim. Jorim he tama Matat. Matat he tama Livai. ");
INSERT INTO nuq_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai he tama Simeon. Simeon he tama Juda. Juda he tama Josep. Josep he tama Jonam. Jonam he tama Eliakim. ");
INSERT INTO nuq_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim he tama Melea. Melea he tama Mena. Mena he tama Matata. Matata he tama Natan. Natan he tama Devit. ");
INSERT INTO nuq_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit he tama Jesi. Jesi he tama Obet. Obet he tama Boas. Boas he tama Salmon. Salmon he tama Nason. ");
INSERT INTO nuq_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason he tama Aminadap. Aminadap he tama Atmin. Atmin he tama Hesron. Hesron he tama Peres. Peres he tama Juda. ");
INSERT INTO nuq_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda he tama Jekop. Jekop he tama Aisak. Aisak he tama Abraham. Abraham he tama Tera. Tera he tama Nahor. ");
INSERT INTO nuq_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor he tama Seruk. Seruk he tama Reu. Reu he tama Pelek. Pelek he tama Eber. Eber he tama Sela. ");
INSERT INTO nuq_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela he tama Kainan. Kainan he tama Arpaksat. Arpaksat he tama Siem. Siem he tama Noa. Noa he tama Lamek. ");
INSERT INTO nuq_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek he tama Metusela. Metusela he tama Enok. Enok he tama Jaret. Jaret he tama Mahalalel. Mahalalel he tama Kenan. ");
INSERT INTO nuq_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan he tama Enos. Enos he tama Set. Set he tama Adam. Adam he tama TeAtua. ");
INSERT INTO nuq_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","TeAnana Tapu raa ku tau i roto Jisas, tena Aia ki haere i taha ma te riva Jordan raa. Kito TeAnana Tapu raa ki hakattaki Jisas i te kina se hai tama e tuu mahoa raa, ");
INSERT INTO nuq_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","tena Satan ku tatakore Jisas i roto tipu haa na aho. I roto na aho naa hakaatoa Jisas se hai mee e kai, tena i te aho hakaoti raa Aia ku hikai roo. ");
INSERT INTO nuq_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kito Satan ki meake Jisas, “Kame Akoe he tamariki hakamaoni TeAtua, Akoe ku meake te hatu nei ki huri mo haraoa.” ");
INSERT INTO nuq_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tena Jisas ki meake, “E mmau i roto te Launiu Tapu ma, ‘Te tama se mee ma e ora koi i te haraoa.’ ” ");
INSERT INTO nuq_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kito Satan ki hakattaki Jisas i te kina e palluna raa, tena ki hakkite ake paa saaita koi na henua roo hakaatoa i te maarama nei raa iaa Jisas. ");
INSERT INTO nuq_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Tena Satan ki meake Jisas, “Anau e me ki kou atu na mahi nei ia ma na mee taualleka nei iaa Akoe, maitaname anau ku ttino na mee nei hakaatoa, tena anau e me ki kou ake na mee nei he tama peehee anau e hihai ki kou ake. ");
INSERT INTO nuq_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tena kame Akoe e lotu mai anau, anau e me ki kou atu na mee nei hakaatoa ma Akoe.” ");
INSERT INTO nuq_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kito Jisas ki meake, “E mmau i roto te Launiu Tapu ma, ‘Lotu ake TeAriki TeAtua akoe raa, tena ku hehekau koi ma Tama raa.’ ” ");
INSERT INTO nuq_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tena Satan ki hakattaki Jisas i Jerusalem no hakatuu Tama raa i te kina e palluna roo i te Hare Tapu raa, tena aia ki meake, “Kame Akoe he Tamariki hakamaoni TeAtua, Akoe ku llee i raro, ");
INSERT INTO nuq_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","maitaname te Launiu Tapu raa e tattara mai pera ma, ‘TeAtua e me ki meake na ensel Aia raa ki lollohi hakaraoi Akoe.’ ");
INSERT INTO nuq_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ia e mmau hoki ma, ‘Na ensel raa e me ki ttaohi Akoe ma na rima laatou ki se lavaa na vae akoe raa te paku na hatu.’ ” ");
INSERT INTO nuq_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tena Jisas ki meake, “te Launiu Tapu raa e tattara mai hoki pera ma, ‘Akoe se lavaa te hahaaite TeAriki TeAtua akoe raa.’ ” ");
INSERT INTO nuq_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan ku oti roo na hahaaite hakaatoa aia iaa Jisas raa, tena aia ki tiaki Tama raa no haere kaa i taha. ");
INSERT INTO nuq_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jisas ku vaakai i Galili, tena na mahi TeAnana Tapu raa ku tau i roto Aia. Te rono Jisas raa ku tere i na matakaina hakaatoa roo i roto Galili. ");
INSERT INTO nuq_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jisas e akoako i roto na hare lotu na Jiu raa, tena na tama raa hakaatoa ku hakammaha i Aia. ");
INSERT INTO nuq_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jisas ku haere i Nasaret, te matakaina Aia ni matua mai raa. Jisas ku haere i te hare lotu i te aho te Sabat pera ma Aia ni hahaere i mua raa. Tena Jisas ki tuu i mua te kanohenua raa ma ki ppau ake te Launiu Tapu raa, ");
INSERT INTO nuq_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","tena te tama e rorohi te hare lotu raa ki kou ake te launiu profet Aisaia raa iaa Jisas. Tena Jisas ki taaraki te launiu raa no tae i te kina e taataa ma, ");
INSERT INTO nuq_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“TeAnana Tapu TeAtua raa e tau i roto Anau, maitaname TeAtua ni hirihiri Anau ki kkave te Rono Tauareka raa i na tama e hakaalloha raa. TeAtua e kauna ria iho Anau ki tattara ake na kanohenua hakaatoa pera ma Aia e me ki hakattana na tama karapusi raa, tena ku mee na tama karemata sseni raa ki kkite, tena ku hakattana na tama hakaalloha raa i taha ma na mahi na tama hakatannata raa, ");
INSERT INTO nuq_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","tena ku tattara ake pera ma te saaita hakamaoni raa ku tae mai, te saaita TeAriki e me ki tokonaki te kanohenua Aia raa ki ora.” ");
INSERT INTO nuq_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kito Jisas ki ppui te launiu raa, tena ki kou ake muri i te tama e rorohi te hare lotu raa, tena ki noho i raro. Na tama i roto te hare lotu raa hakaatoa ku kkira ake iaa Jisas, ");
INSERT INTO nuq_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","tena Jisas ki meake na tama raa, “Na tattara i roto te Launiu Tapu kootou ni llono raa ku hakamaoni te aho nei.” ");
INSERT INTO nuq_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Te kanohenua raa ku hakammaha roo iaa Jisas ia ma na tattara taualleka Aia raa. Na tama raa e tattara ma, “Teenei he tamariki Josep, kaa seai?” ");
INSERT INTO nuq_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kito Jisas ki meake na tama raa, “Anau e iroa pera ma kootou e me ki mee mai Anau te tattara ma, ‘Dokta, tokonaki akoe Hokkoe ki tauareka.’ Kootou e me ki mee mai hoki Anau ki ppena i te matakaina Anau nei na mee tera kootou e llono Anau ni ppena i Kaperneam raa.” ");
INSERT INTO nuq_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Tena Jisas ki meake, “Anau e meatu te hakamaoni, na kanohenua hakaatoa e me ki se hihhai te profet i te matakaina roo aia raa. ");
INSERT INTO nuq_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Hakallono mai Anau: te mee nei e hakamaoni pera ma na tautukaha hhine ni nnoho i roto Israel te saaita Elaija raa e tammaki, ia teenaa ko te saaita ni se hai reurehu roo hokotahi ni lleku i roto e toru toe na hetau raa, tena te henua naa hakaatoa hoki ni ttiri te one e haeo roo. ");
INSERT INTO nuq_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ia TeAtua ni se kauna Elaija ki haere he tama peeraa hoki, e meia Elaija e haere i te tautukaha hine e noho i Sarefat, he matakaina i roto Saidon. ");
INSERT INTO nuq_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Tena e tammaki hoki na tama e kaina te manumanu haeo e nnoho i roto Israel te saaita profet Elisa, e meia se hai tama na tama raa ni tokonaki ria no taualleka. Elisa e tokonaki koi Naman te tama i Siria raa.” ");
INSERT INTO nuq_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Te saaita na tama i roto te hare lotu raa ni llono na tattara nei, na tama raa ku lloto haeo roo. ");
INSERT INTO nuq_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tena na tama raa ku mahhike i aruna no horo Jisas i taha ma te matakaina raa. Te matakaina raa e tuu i aruna te mouna palluna. Tena na tama raa ku mee ma ki taohi Jisas no lletu i raro i te vahi te mouna raa, ");
INSERT INTO nuq_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","e meia Jisas e haere uru koi vaa roto te kanohenua raa no haere i taha. ");
INSERT INTO nuq_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kito Jisas ki haere i te matakaina Kaperneam i roto Galili raa. Tena i te aho te Sabat, Jisas ku akoako ake te kanohenua raa. ");
INSERT INTO nuq_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Na tama raa ku mahharo roo i na akoako Jisas raa, maitaname Tama raa e akoako ma na mahi Aia. ");
INSERT INTO nuq_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","He tama i roto te hare lotu raa e isi te tipua sakkino i roto aia. Tena te tama raa ki kanna ake hakamaroa ma, ");
INSERT INTO nuq_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jisas, te Tama i Nasaret, hea Akoe e me ki ppena i maatou? Akoe e hamai ma ki seu maatou? Anau e iroa koai Akoe. Akoe ko te Tama e Tapu TeAtua tera e hakatae na tattara Aia raa!” ");
INSERT INTO nuq_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kito Jisas ki hakamataku ake te tipua raa ma, “Se vaa, tena ku oo i taha ma te tama naa!” Kito te tipua raa ki lletu te tama raa i raro, tena ki tere i taha se hai mee sakkino e ppena i te taupeara raa. ");
INSERT INTO nuq_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Te kanohenua raa hakaatoa ku mahharo, tena ki tattara hokolaatou ma, “Teenei he akoako peehee? Tama nei e tattara ake na tipua raa ma na mahi, tena na tipua raa ku huro iho i taha.” ");
INSERT INTO nuq_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tena te rono Jisas raa ku paa i na kina vaa raa hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tena Jisas ku haere i taha ma te hare lotu raa no haere i te hare Saimon raa. Te hinaona hine Saimon raa e laavea, te vvela aia raa e hai mahi roo. Tena na tama i te hare raa ku meake ma Jisas ki tokonaki te hine raa. ");
INSERT INTO nuq_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jisas e tuu i te vahi te hine raa no hai ake te maahana raa ki tiaki te hine raa. Te saaita naa koi, te hine raa ku mahike i aruna no tanattana na kai na tama raa ki kkai. ");
INSERT INTO nuq_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Te saaita te laa raa ku mee ki huru, te kanohenua raa ku kou ake na tama lavvea na maahana roo hakaatoa raa iaa Jisas, tena Tama raa ki hakapiri na rima Aia raa i aruna na tama raa hakaatoa no taualleka. ");
INSERT INTO nuq_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tammaki na tipua sakkino ku huro i taha ma na tama. Tena na tipua raa e kanna ake hakamaroa ma, “Akoe ko te Tamariki TeAtua.” Tena Jisas ki hakamataku ake na tipua raa ki se tattara, maitaname na tipua raa e illoa pera ma Aia ko te Mesaia. ");
INSERT INTO nuq_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tena te tahata roo Jisas ku tiaki te matakaina raa no haere i te kina se hai tama e nnoho raa. Te kanohenua raa ku kaamata no sesee Jisas, tena te saaita laatou ni lave Tama raa, na tama raa ku mee ma ki ttaohi Tama raa ki se haere i taha ma laatou. ");
INSERT INTO nuq_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Emeia Jisas e meake na tama raa, “Anau e me ki takutaku te Rono Tauareka i te Hakamaatua ana i te Vaelani raa i alaa matakaina hoki, maitaname teenei hea TeAtua ni kauna ria mai Anau raa.” ");
INSERT INTO nuq_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tena Jisas ki haere no takutaku i roto na hare lotu i Judia raa. ");
INSERT INTO nuq_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Teeraa he aho Jisas e tuu i tai te Namo Genesaret, tena te kanohenua raa ku muimui ake iaa Jisas ma ki hakallono Tama raa e takutaku na tattara TeAtua raa. ");
INSERT INTO nuq_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jisas e kite e rua na vaka e hakauu te taunatai, tena na tama meemee ika raa ku ttiho i raro no huihui na kupena laatou raa. ");
INSERT INTO nuq_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jisas ku kake i roto te vaka hokotahi, ia teenaa ko te vaka Saimon, tena Aia ki meake Saimon ki unuki te vaka raa i taha ma te taunatai raa. Tena Jisas ki noho i roto te vaka raa no akoako ake te kanohenua raa. ");
INSERT INTO nuq_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jisas e akoako ake te kanohenua raa no oti, tena Aia ki meake Saimon, “Hakanuu te vaka nei i te kina e nnoto raa, tena ku ppehi te kupena akoe raa ki mmau ni ika.” ");
INSERT INTO nuq_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Kito Saimon ki meake, “TeAriki, te poo raa hakaatoa maatou e puipui ma ki mmau ni ika, e meia maatou se hai ika roo hokotahi ni mmau. Emeia, teenaa Akoe e mee mai ma ki ppehi te kupena nei, tena anau e me ki ppehi.” ");
INSERT INTO nuq_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Na tama raa e ppehi te kupena laatou raa no mmau tammaki roo na ika, tena te kupena raa ku taapiri ki masae. ");
INSERT INTO nuq_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kito na tama raa ki auna ake na soa laatou i roto teeraa vaka raa ma ki oo ake no tokonaki laatou. Tena na tama raa ki oo ake no uta e rua na vaka raa no tappiri roo ki appuru na ika. ");
INSERT INTO nuq_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Te saaita koi Saimon Pita ni kite te kooina na ika raa hakaatoa, aia ku tteiho i raro no tuturi i mua Jisas, tena ki meake, “TeAriki, haere i taha ma anau! Anau he tama hai sara!” ");
INSERT INTO nuq_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pita ia ma na soa aia raa ku mahharo i te kooina na ika laatou ni ppui raa hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tena Jems laaua ma Jon na tama Sebedi raa ku mahharo hoki peeraa ma Pita raa. Kito Jisas ki meake Pita, “Auu se mataku! Te saaita nei akoe e me ki hahanota na tama.” ");
INSERT INTO nuq_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kito na tama raa ki horo na vaka laatou raa i uta, tena ki tiaki na mee raa hakaatoa no tauttari Jisas. ");
INSERT INTO nuq_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jisas e noho i roto te matakaina tera e isi te tama e kaina te manumanu haeo. Te tinotama te tama raa e hai saanuku roo hakaatoa. Te saaita tama raa ni kite Jisas, aia ku tteiho no tuturi i mua Jisas, tena ki meake, “TeAriki! Kame Akoe e hihai, Akoe ku tokonaki anau ki matahua.” ");
INSERT INTO nuq_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tena Jisas ki haaro ake te rima Aia raa no ttaohi tama raa, tena ki meake, “Anau e hihai ki tokonaki akoe ki tauareka.” Te saaita naa koi, te tinotama te tama raa ku mmore hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tena Jisas ki meake te tama raa, “Auu se tattara ake ni tama, e meia haere tahi roo i te maatua raa, tena ku meake aia ki mmata te tinotama akoe raa, ki huri ake te kanohenua raa te hakamaoni pera ma akoe ku tauareka, tena akoe ku hoki ake te hoki tera Moses ni meatu raa.” ");
INSERT INTO nuq_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Emeia te rono Jisas raa ku paa na kina roo hakaatoa, tena tammaki na tama ku oo ake no hakallono Tama raa, ia tammaki hoki na tama e lavvea na maahana raa ku taualleka ma na maahana laatou. ");
INSERT INTO nuq_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Emeia tammaki na vahao Jisas e tiaki na tama raa no haere i na kina se hai tama raa no lotu. ");
INSERT INTO nuq_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","He aho hokotahi Jisas e akoako ake te kanohenua raa, tena e isi na Farisi laatou ma na tama e poroporo na tuaa e nnoho i te kina raa hoki. Na tama raa e oo mai i na matakaina hakaatoa i roto Galili, Judia ia ma Jerusalem. Na mahi TeAtua raa e mmoe i roto Jisas ki tokonaki na tama lavvea raa ki taualleka. ");
INSERT INTO nuq_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","E isi na tama e ssau ake te tama na vae e mmate i aruna te kakkake. Tena na tama raa ku hahaivi ma ki ssau ake te tama raa i roto hare ma ki hakamoe i mua Jisas. ");
INSERT INTO nuq_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Emeia na tama raa ku se ssao te uru i hare, e mee te kanohenua raa e tammaki roo. Kito na tama raa ki kkake i aruna na inaki raa no hakahotu te inaki hokotahi, tena ki hakatere iho te tama na vae e mmate raa i aruna te kakkake raa no hakamoe i mua Jisas. ");
INSERT INTO nuq_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jisas e kite na hakattina na tama raa, tena Aia ki meake te tama na vae e mmate raa, “Taku soa! Anau e ssoro na hai sara akoe raa i taha.” ");
INSERT INTO nuq_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tena na tama e poroporo na tuaa ia ma na Farisi raa ku tattara hokolaatou ma, “Koai te Tama e tattara hakameemee TeAtua nei? TeAtua Hokoia koi e lavaa te ssoro na hai sara i taha!” ");
INSERT INTO nuq_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jisas e iroa na hakataakoto na tama raa, tena Aia ki meake na tama raa, “Aiea kootou e too na mannatu peenaa naea? ");
INSERT INTO nuq_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Te tattara hee e hainauhie, te tattara ma, ‘Anau e ssoro na hai sara akoe raa i taha,’ ma te tattara ma, ‘Tuu i aruna no haere?’ ");
INSERT INTO nuq_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Anau e me ki huri atu kootou pera ma te Tamariki te Tama nei e isi na mahi Aia i te maarama nei ki ssoro na hai sara i taha.” Kito Jisas ki meake te tama na vae e mmate raa, “Anau e meatu akoe, tuu i aruna no too te kakkake akoe naa no haere i hare.” ");
INSERT INTO nuq_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Te saaita naa koi, te tama raa ku mahike i aruna i mua te kanohenua raa hakaatoa, tena ki too te kakkake aia ni moe raa no haere i hare, tena ki hakammaha TeAtua. ");
INSERT INTO nuq_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Te kanohenua raa hakaatoa ku mahharo roo! Na tama raa ku mattaku, tena ki hakammaha hoki TeAtua ma, “Maatou ku kkite na mee taualleka i te aho nei.” ");
INSERT INTO nuq_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tena Jisas ki haere i taha ma te hare raa no kite te tama e aoao na takis te taumani e hui ma ko Livai. Te tama raa e noho i te kina e aoao na takis raa, tena Jisas ki meake te tama raa, “Tautari mai Anau.” ");
INSERT INTO nuq_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tena Livai ki mahike i aruna no tiaki na mee roo hakaatoa, tena ki tautari Jisas. ");
INSERT INTO nuq_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kito Livai ki pena te kai e rahi i roto te hare aia raa, tena tammaki na tama e aoao na takis ia ma alaa tama hoki e nnoho i te kina raa no kkai. ");
INSERT INTO nuq_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tena na Farisi ia ma na tama e poroporo na tuaa raa ku hai ake na disaipol Jisas raa ma, “Aiea kootou e kkai ma na tama e aoao na takis ia ma na tama hai ssara naea?” ");
INSERT INTO nuq_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tena Jisas ki meake na tama raa, “Na tama se lavvea raa se lavaa te oo no mmata te dokta, aanaa ko na tama koi e lavvea raa e me ki oo no mmata te dokta. ");
INSERT INTO nuq_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Anau se hamai no kanna na tama e mannatu ma laatou e ttonu raa ki ttike i taha ma na hai sara laatou, e meia Anau e hamai no kanna na tama hai ssara raa ki ttike i taha ma na hai sara laatou raa.” ");
INSERT INTO nuq_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kito na tama raa ki meake Jisas, “Na disaipol Jon raa e hakamaatapu, ia e lotu tahi hoki, e ssau hoki pera ma na disaipol na Farisi raa, e meia na disaipol Akoe raa e kkai, ia e unu koi.” ");
INSERT INTO nuq_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tena Jisas ki meake, “Eaa! Na soa te tama e avana raa e me ki se lavaa te kkai te saaita te tama e avana raa e nnoho ma laatou? Seai! ");
INSERT INTO nuq_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Emeia e isi te aho te tama e avana raa e me ki haere i taha ma na soa Aia raa, tena na tama raa e me ki hakamaatapu.” ");
INSERT INTO nuq_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tena Jisas ki tattara ake hoki na tama raa te tattara hurihuri nei, “Se hai tama e lavaa te ssae te paamaro vahao nei raa no hakapuni te paamaro tuai e masae raa, maitaname te muri maro raa e me ki masae i taha ma te paamaro tuai raa, e mee te paamaro tuai raa ku se mmau. ");
INSERT INTO nuq_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Se hai tama e utu te wain vahao nei i roto te kiri tuai na sipsip raa, maitaname te wain vahao nei raa e me ki pia no ssaa te kiri te sipsip raa, tena te wain vahao nei raa ku manini puamu, ia te kiri te sipsip raa hoki e me ki haeo. ");
INSERT INTO nuq_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Emeia na wain vahao nei raa e tau te utu i roto te kiri te sipsip vahao nei. ");
INSERT INTO nuq_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kame he tama e unu te wain e mmara, te tama naa e me ki se lavaa te hiunu te wain e marie raa. Tama raa e me ki mee ma, ‘Te wain kaamata raa e tauareka.’ ” ");
INSERT INTO nuq_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jisas ma na disaipol Aia raa ku oo vaa roto te paupaku e hhomo na wit raa i te aho te Sabat. Na disaipol raa e kotikoti na wit raa no murumuru ma na rima laatou raa, tena ki kkai na hua raa. ");
INSERT INTO nuq_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kito na Farisi raa ki meake, “Hea kootou e ppena i te aho te Sabat nei raa se tonu ma hea e mmau i roto na tuaa te aho nei raa.” ");
INSERT INTO nuq_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tena Jisas ki meake na Farisi raa, “Kootou ni mee raa se ppau hea Devit ni ppena te saaita aia ma na tama tauttari aia raa ni hikkai? ");
INSERT INTO nuq_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Devit e haere i te Hare Tapu TeAtua raa no too na haraoa ku oti te hakatapu raa no kai, tena ki kou ake hoki na haraoa raa i na tama tauttari aia raa no kkai. Ia se tonu ma na tuaa ma te tama vare ki kai na haraoa raa, na maatua raa koi e lavaa te kkai na haraoa raa.” ");
INSERT INTO nuq_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tena kito Jisas ki meake na Farisi raa, “Te Tamariki te Tama nei ko TeAriki te Sabat.” ");
INSERT INTO nuq_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Teeraa Sabat, Jisas ku haere i te hare lotu na Jiu raa no akoako. He tama te rima laaua aia raa e mate e noho i te kina raa. ");
INSERT INTO nuq_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Na tama poroporo na tuaa ia ma na Farisi raa e hihhai ma ki kkite Jisas e ppena he mee e sara ma ki lavaa laatou te mmau tattara iaa Jisas, tena na tama raa ku kirakira hakamattonu roo ma ka oti Jisas ku tokonaki te tama raa i te aho te Sabat raa. ");
INSERT INTO nuq_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Emeia Jisas e iroa na hakataakoto na tama raa, tena Aia ki meake te tama te rima e mate raa, “Tuu i aruna no hamai i mua.” Tena te tama raa ki mahike no haere ake no tuu i mua te kanohenua raa. ");
INSERT INTO nuq_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kito Jisas ki meake na tama raa, “Anau e vahiri atu kootou: hea na tuaa taatou raa e mee mai ma taatou ki ppena i te aho te Sabat? Ki tokonaki te tama ma ki mee te tama ki hakalono llihu? Ki tokonaki te ora te tama ma ki ssepe te ora te tama?” ");
INSERT INTO nuq_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jisas e kkira hakataka ake na tama raa hakaatoa, tena Aia ki meake te tama raa, “Ssora te rima akoe naa.” Kito te tama raa ki ssora te rima aia raa, tena te rima raa ku tauareka hakaraoi. ");
INSERT INTO nuq_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Na Farisi laatou ma na tama poroporo na tuaa raa ku lloto haeo roo, tena ki kaamata no tattara hokolaatou ma hea laatou e me ki ppena iaa Jisas. ");
INSERT INTO nuq_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Te saaita naa Jisas ku haere i aruna te mouna raa no lotu, tena ki noho te poo naa hakaatoa no lotu ake TeAtua. ");
INSERT INTO nuq_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Te tahata Aia ku kanna ake na disaipol Aia raa hakaatoa, tena Aia ki hirihiri sanahuru ma rua na tama, tena Aia ki kanna na tama raa ma ni aposol. Aanei na inoa na tama raa: ");
INSERT INTO nuq_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saimon tera Jisas e hui ma ko Pita raa, tena Andru te taina Pita raa, Jems, te taina Jon raa, tena Jon, Filip, Bartolomyu, ");
INSERT INTO nuq_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiu, Tomas, Jems, te tama Alfius raa, tena Saimon, te tama se hihai ma Rom ki rorohi Israel raa, ");
INSERT INTO nuq_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, te tama Jems raa, tena Judas Iskariot te tama e me ki hakari ake Jisas i na tama hakamattua raa. ");
INSERT INTO nuq_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisas ma na aposol Aia raa ku oo mai i raro ma te mouna raa, tena Aia ki haere no tuu i te kina e mmore raa ma na disaipol tammaki Aia raa. He kanohenua e rahi roo e ttuu i te kina raa, na tama i Judia, na tama i Jerusalem ia ma na tama na matakaina vaa tai Taia laaua ma Saidon raa. ");
INSERT INTO nuq_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Na tama raa e oo ake ma ki hakallono Jisas, tena ma ku meake Tama raa ki tokonaki laatou ki taualleka. Na tama e isi na tipua sakkino raa e oo ake hoki ma Jisas ki tokonaki laatou. ");
INSERT INTO nuq_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Na tama raa hakaatoa e hahaivi ma ki ttaohi Jisas, e mee na mahi TeAtua e takoto i roto Jisas raa e tokonaki na tama raa hakaatoa no taualleka. ");
INSERT INTO nuq_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas e kkira ake na disaipol Aia raa, tena ki meake, “Kootou na tama hakaalloha raa e me ki hakatapu ria, e mee te Hakamaatua ana i te Vaelani raa he kina kootou! ");
INSERT INTO nuq_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kootou na tama e hikkai vahao nei raa e me ki hakatapu ria, kootou e me ki ppohu! Kootou na tama e tanittani vahao nei raa e me ki hakatapu ria, kootou e me ki katakkata! ");
INSERT INTO nuq_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kootou e me ki hakatapu ria te saaita na tama e kiri lloto kootou, ia ku se hihhai kootou, ku hai na haeo kootou, tena ki tattara sakkino kootou, e mee kootou e tauttari te Tamariki te Tama nei! ");
INSERT INTO nuq_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kootou ki hihhia te saaita na mee nei e kapihi atu kootou. Kootou ki hihhia roo, maitaname na tuhana e llahi kootou raa e mmoe i te vaelani. Na tipuna na tamana taatou i mua raa hoki e kou ake na hakalono llihu i na profet TeAtua i mua raa. ");
INSERT INTO nuq_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ia tena kootou na tama e tuttuu laoi te saaita nei raa e me ki haeo roo; e mee te saaita te hihhia kootou raa ku oti! ");
INSERT INTO nuq_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kootou na tama e kkai no ppohu te saaita nei raa e me ki haeo roo; maitaname kootou e me ki hikkai i muri! Kootou na tama e maihu kkata te saaita nei e me ki haeo roo; kootou e me ki ppari no tanittani! ");
INSERT INTO nuq_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ia se isi te tauareka te saaita te kanohenua raa e tattara hakatauareka akoe, e mee na tipuna laatou raa ni tattara hakamamaha na tama seai ma ni profet TeAtua hakamaoni raa. ");
INSERT INTO nuq_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Emeia Anau e meatu kootou na tama e llono Anau raa: Laoi na tama e haeo kootou raa, tena ku ppena hakatauareka na tama e kiri lloto kootou raa, ");
INSERT INTO nuq_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","tena ku lotu ake TeAtua ki hakatapu na tama e hai haeo kootou raa, tena ku lotu ake hoki TeAtua ki tokonaki na tama e tattara llihu kootou raa. ");
INSERT INTO nuq_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kame he tama e ppaa te patikauvae akoe raa, tena meake aia ki ppaa teeraa patikauvae hoki. Kame he tama e too te kaukahu mattoru akoe raa, tena tiaki aia ki too hoki te kaukahu mannihi akoe raa. ");
INSERT INTO nuq_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kou ake niaa na tama e kainno atu akoe raa, tena kame he tama e too hea akoe e ttino raa, tena auu se meake ki kou atu muri. ");
INSERT INTO nuq_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","“Ppena i alaa tama pera ma hea akoe e hihai ma na tama raa ki ppena i akoe raa. ");
INSERT INTO nuq_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kame kootou e laoi koi na tama tera e laoi kootou raa, kaa he tauareka peehee kootou e me ki too? E mee na tama hai ssara raa hoki e laoi koi na tama e laoi laatou raa. ");
INSERT INTO nuq_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kame kootou e taualleka koi na tama tera e taualleka kootou raa, tena kaa he tauareka peehee kootou e me ki too? E mee na tama hai ssara raa hoki e taualleka koi na tama e taualleka laatou raa. ");
INSERT INTO nuq_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ia tena kame kootou e hoki ake na mee i na tama tera kootou e illoa ma kootou e lavaa te too muri na mee raa, tena kaa he tauareka peehee kootou e me ki too? E mee na tama hai ssara raa hoki e hoki ake na mee i na tama hai ssara raa ma ki lavaa laatou te too muri te kooina laatou ni hoki raa. ");
INSERT INTO nuq_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Emeia kootou ki laoi na tama e haeo kootou raa, tena ku ppena hakatauareka na tama raa; hoki, tena auu se hakataakoto ma ki too muri he mee. Tena kootou e me ki isi na tuhana e llahi. Kootou e me ki mee pera ma ni tamalliki TeAtua Hakanaaniu. TeAtua e laoi na tama sakkino ia ma na tama hai ssara. ");
INSERT INTO nuq_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kootou ki manava alloha e ssau pera ma te Tamana taatou raa e manava aroha. ");
INSERT INTO nuq_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Auu se tattara te hai sara te tama te maanatu koi akoe, tena TeAtua e me ki se lavaa te hakatonutonu kootou. Auu se tamoa haeo alaa tama, ka oti alaa tama ku tamoa haeo kootou. Ssirihia na hai sara alaa tama, tena TeAtua e me ki ssirihia na hai sara kootou raa. ");
INSERT INTO nuq_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Hoki ake alaa tama, tena TeAtua e me ki hoki atu kootou. Hakamaoni, kootou e me ki too te kooina e rahi roo. Te tokonaki e rahi raa e me ki moe i na rima kootou tera kootou e me ki se lavaa te ttaohi. Te kooina kootou e hoki ake alaa tama raa, TeAtua e me ki kou atu te kooina naa hoki.” ");
INSERT INTO nuq_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Tena Jisas ki tattara ake na tama raa te tattara hurihuri nei, “Te tama karemata sseni raa se lavaa te hakattaki teeraa tama karemata sseni. Kame aia e hakattaki, tena laaua hakaatoa e me ki tteiho i roto te rua e nnoto. ");
INSERT INTO nuq_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Se hai tamalliki skul e raka i aruna te tisa laatou raa, e meia na tamalliki skul hakaatoa e me ki ssau pera ma te tisa laatou raa te saaita laatou ku oti na skul laatou raa. ");
INSERT INTO nuq_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Aiea akoe e kkira ake te kerekere e mmau te karemata te taina akoe raa, kaa akoe se anana peehee te laakau e mmau te karemata akoe raa? ");
INSERT INTO nuq_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Akoe e lavaa peehee te meake te taina akoe raa, ma, ‘Taina, hamai ki ppisi te kerekere e mmau te karemata akoe naa,’ te saaita akoe hokkoe se kite te laakau e mmau te karemata akoe raa? Akoe e tattara uhiuhi koi. Akoe e tau te tokea te laakau e mmau te karemata akoe raa i mua, tena akoe e me ki kite laoi no ppisi te kerekere e mmau te karemata te taina akoe raa. ");
INSERT INTO nuq_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Te laakau tauareka se lavaa te hua na hua sakkino. Tena te laakau sakkino se lavaa te hua na hua taualleka. ");
INSERT INTO nuq_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Na hua raa e huri mai na tipu te laakau raa. Se lavaa he tama te haki te natu i te purukavuhu. Tena se lavaa he tama te haki te hui te hara i te paaku. ");
INSERT INTO nuq_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Na tama taualleka raa e ppena na mee taualleka: tauttari na tiputipu taualleka na hatu manava laatou raa. Tena na tama sakkino raa e pena na mee sakkino: tauttari na tiputipu sakkino na ora laatou raa. Te maihu raa e tattara iho na mee tera e kkapi i roto na hatu manava laatou raa. ");
INSERT INTO nuq_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Aiea kootou e kanna mai Anau ma ‘TeAriki, TeAriki,’ e meia kaa kootou se ppena hea Anau ni meatu raea? ");
INSERT INTO nuq_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kame he tama e hamai Anau no rono na tattara Anau raa, tena ki tautari na tattara raa, Anau e me ki huri ake na tiputipu taualleka i te tama naa. ");
INSERT INTO nuq_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tama naa e ssau pera ma he tama e keri na pou te hare aia raa ki hakatuu i aruna te hatu paa. Tena te hua peau raa ku lohia no paku te hare raa, e meia te hare raa se lavaa roo te naue, maitaname te hare raa e ppena hakatauareka roo. ");
INSERT INTO nuq_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Emeia kame he tama e rono na tattara Anau raa, tena ki se tautari na tattara Anau raa, tena te tama naa e ssau pera ma he tama e hakatuu te hare aia raa i aruna te kerekere vare koi, tena te saaita te hua peau raa e ppaku te hare raa, te hare raa e me ki hina no ppaku hakamaroa roo i raro.” ");
INSERT INTO nuq_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas ku oti roo te tattara ake na tattara Aia raa hakaatoa i te kanohenua raa, tena Aia ki haere i Kaperneam. ");
INSERT INTO nuq_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Teeraa he purepure hakamaatua, tena aia e isi te tama hehekau tera aia e hihai mahi roo, te tama hehekau aia raa e laavea no taapiri ki mate. ");
INSERT INTO nuq_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Te purepure hakamaatua raa e rono na mahi Jisas raa, tena aia ki kauna na tama hakamattua na Jiu raa ki oo no meake Jisas ki haere ake no tokonaki te tama hehekau aia raa ki tauareka. ");
INSERT INTO nuq_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Na tama raa e oo ake no ttiri Jisas, tena ki tattara hakaaroha ake ma, “Te tama nei e tau roo Akoe ki tokonaki aia. ");
INSERT INTO nuq_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Te purepure hakamaatua nei e laoi roo maatou, tena aia e hakatuu hoki te hare lotu maatou raa.” ");
INSERT INTO nuq_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kito Jisas ki oo ma na tama raa. Jisas ku taapiri i te hare raa, tena te purepure hakamaatua raa ki kauna na soa laoi aia raa ki meake Jisas ma, “TeAriki, ka oti Akoe ku naenae. Anau e maanatu ma Akoe se tau te hamai i roto te hare anau nei, ");
INSERT INTO nuq_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","tena anau hokonnau e maanatu ma anau se tau hoki te haere atu no mmata akoe. Akoe ki ppehi koi he tattara ki tauareka te tama hehekau anau nei. ");
INSERT INTO nuq_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Anau hoki he tama e noho i raro na mahi na tama hakamattua, tena anau e isi na purepure e hehekau i raro anau. Kame anau e meake te tama raa ma, ‘Haere!’ tena te tama naa e me ki haere. Kame anau e meake te tama raa ma, ‘Hamai!’ te tama naa e me ki hamai. Kame anau e meake te tama hehekau anau raa ma, ‘Ppena te mee nei!’ tena te tama naa e me ki ppena koi.” ");
INSERT INTO nuq_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisas e oho te saaita Aia ni rono na tattara te tama raa, tena Aia ki hakatike no meake te kanohenua e tauttari Aia raa, “Anau e meatu kootou, Anau se hai vahao roo e ttiri te tama e hakatina peenei, niaina ma i roto roo Israel!” ");
INSERT INTO nuq_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Na tama ni oo ma na tattara raa ku vakkai i te hare te purepure hakamaatua raa no kkite ma te tama hehekau raa ku tauareka. ");
INSERT INTO nuq_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Teeraa aho Jisas ku haere i te matakaina Nain ma na disaipol Aia raa, tena he kanohenua e rahi roo ku oo laatou. ");
INSERT INTO nuq_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Te saaita koi Jisas ni tae i te totoka te matakaina raa, na tama te matakaina raa ku ssau ake te tama e mate. Te tama e mate raa ko te tautahi tama koi te tautukaha hine raa, tena tammaki na tama e oo iho ma te hine raa i taha ma te matakaina raa ma ki tanu te tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Te saaita TeAriki ni kite te hine raa, Aia ku aroha roo i te hine raa, tena Aia ki meake ma, “Auu se tani.” ");
INSERT INTO nuq_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tena Aia ki haere atu no ttaohi te moena te tama e mate raa, tena na taanata e ssau raa ku hakamau. Kito Jisas ki meake, “Anau e meatu akoe! Taupeara! Mahike i aruna!” ");
INSERT INTO nuq_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Te tama e mate raa ku mahike no noho i aruna, tena ki kaamata no tattara. Tena Jisas ki hoki muri ake te taupeara raa i te tinna aia raa. ");
INSERT INTO nuq_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Na tama raa hakaatoa ku mahharo, tena ki hakammaha TeAtua. Na tama raa e tattara ma, “Te profet hakanaaniu raa ku tae mai. TeAtua ku hamai ki tokonaki te kanohenua Aia raa ki ora!” ");
INSERT INTO nuq_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tena te rono Jisas raa ku paa vaa roto Judia ia ma na kina tappiri ake te matakaina raa. ");
INSERT INTO nuq_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Na disaipol Jon Baptis raa ku tattara ake Jon i te rono Jisas raa, tena Jon ki kanna ake tokorua na tama, ");
INSERT INTO nuq_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","tena ki kauna tokorua raa ki oo no vahiri ake Jisas ma, “Akoe ko te Tama tera Jon ni tattara ma e me ki hamai raa ma maatou e me ki hakattari teeraa tama hoki?” ");
INSERT INTO nuq_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tokorua raa e oo no ttae iaa Jisas, tena tokorua raa ki meake, “Jon Baptis e kauna ria mai maaua ki vahiri atu ma Akoe ko te Tama aia ni tattara ma e me ki hamai raa ma maatou e me ki hakattari teeraa tama hoki?” ");
INSERT INTO nuq_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ia te saaita naa hoki Jisas e tokonaki tammaki na tama lavvea ia ma na tama e hakalono llihu i na maahana ia ma na tama e ttau ria na tipua sakkino eaa, tena Aia ki mee tammaki na tama karemata sseni raa no kkite. ");
INSERT INTO nuq_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tena Jisas ki meake tokorua na disaipol Jon raa ma, “Vakkai hakaraoi no meake Jon hea koorua ni kkite ia ma hea koorua ni llono raa: Na tama karemata sseni raa ku kkite, na tama na vae e mmate raa ku hahaere, na tama e kaina te manumanu haeo raa ku taualleka, na tama katarina tturi raa ku llono, na tama e mate raa ku ora hakaraoi, tena na tama hakaalloha raa ku llono te Rono Tauareka TeAtua raa. ");
INSERT INTO nuq_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Na tama se mamannatu tammaki i Anau raa e me ki hakatapu ria.” ");
INSERT INTO nuq_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Na disaipol Jon raa ku vakkai, tena Jisas ku kaamata no tattara ake te kanohenua raa i te vahi Aia, “Te saaita kootou ni oo iaa Jon i te kina se hai tama e tuu mahoa raa, hea kootou e mannatu ma kootou e me ki kkite raa? He laumea te veve e ino atu te matani? ");
INSERT INTO nuq_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Hea kootou ni oo ma ki oo no mmata raa? He tama e uru na hekau taualleka e sui mmaha? Na tama e uru na hekau peenei raa e nnoho i na ora e hainauhie, ia e nnoho hoki i roto na hare na tuku. ");
INSERT INTO nuq_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kootou ki mee mai, hea kootou ni oo ma ki oo no mmata raa? He profet? Noo, e meia Anau e meatu pera ma Jon e raka roo i aruna na profet raa hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","E mee Jon ko te tama te Launiu Tapu raa e tattara ma: TeAtua e mee ma, ‘Anau e me ki kauna te tama hakatae na tattara Anau raa i mua Akoe ki taaraki te mateara raa ma Akoe.’ ” ");
INSERT INTO nuq_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Tena Jisas ki meake hoki ma, “Anau e meatu kootou, se hai tama ni haanau iho i roto te maarama nei e hakanaaniu i aruna Jon. Emeia te tama tera e mouraro i te Hakamaatua ana i te Vaelani raa e hakanaaniu roo i aruna Jon.” ");
INSERT INTO nuq_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Hakaatoa e llono na tattara Jisas raa, tena te kanohenua raa; taohi mua na tama e aoao na takis tera ni tauttari roo hea TeAtua ni meake, tena Jon ki hakoukou tapu na tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Emeia na Farisi ia ma na tama e poroporo na tuaa raa e ui i taha ma te hakataakoto tera TeAtua e hihai ma laatou ki ppena raa, tena na tama raa ku se hihhai hoki ma Jon ki hakoukou tapu laatou. ");
INSERT INTO nuq_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tena Jisas ki meake hoki ma, “Kaa Anau e me ki tattara peehee i na tama te maarama nei raa? Na tama raa e ssau pera ma niaa? ");
INSERT INTO nuq_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Na tama raa e ssau pera ma ni tamalliki e nnoho i roto marae, tena teeraa kuturana ku vava ake teeraa kuturana ma, ‘Maatou e hakattani na hula, e meia kootou se hihhai ki llue! Maatou e huhua na huatana, e meia kootou se hihhai ki ttani!’ ");
INSERT INTO nuq_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Jon Baptis e hamai, tena aia e hakamaatapu, ia se unu na wain, tena kootou ku tattara ma, ‘Tama raa e isi te tipua i roto aia!’ ");
INSERT INTO nuq_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Te Tamariki te Tama nei ku oti te hamai, tena Aia e kai, ia e unu, tena kootou ku tattara ma, ‘Kira ake te Tama raa! Tama raa e kaikai vvare ia e unu tahi, tena Aia e ssoa laoi ma na tama e aoao na takis ia ma na tama hai ssara raa!’ ");
INSERT INTO nuq_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Te atamai TeAtua raa e huri ake i roto na tama tera e tauttari hea Aia e hihai raa.” ");
INSERT INTO nuq_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","He Farisi e hakkoro Jisas ma ki kkai laaua te poo naa, tena Jisas ki haere i te hare te tama raa no noho i raro ma ki kai. ");
INSERT INTO nuq_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tena i roto te matakaina naa e isi te hine te ora aia raa e pii roo na hai sara. Te hine raa e rono pera ma Jisas e kai i te hare te Farisi raa, tena aia ki too te lloo manoni e sui mmaha raa no haere ake ma aia, ");
INSERT INTO nuq_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","tena aia ki haere no tuu i muri Jisas, taapiri na vae Tama raa no tani, tena na vae Jisas raa ku ssuu i na vai karemata te hine raa. Kito te hine raa ki hakapakupaku na vae Jisas raa ma te rouru aia, tena ki mohoni na vae Tama raa, tena ki nnini te lloo manoni raa i aruna na vae Jisas. ");
INSERT INTO nuq_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Te saaita te Farisi raa ni kite te mee nei, aia ku tattara hokoia ma, “Kame te Tama nei he profet hakamaoni, Aia e me ki iroa na tiputipu te hine tera e tataohi Aia raa; Aia e lavaa te iroa te ora sakkino te hine nei e isi raa.” ");
INSERT INTO nuq_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kito Jisas ki meake te Farisi raa, “Saimon, Anau e isi te mee e me ki meatu akoe.” Tena Saimon ki meake, “Rabai! Tattara mai, anau e hakarono atu.” ");
INSERT INTO nuq_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Kito Jisas ki kaamata ake ma, “E isi tokorua na tama e taoni na sileni te tama hai sileni hokotahi. Teeraa tama e taoni huitarau na siliva, tena teeraa tama e taoni tipu rima na siliva. ");
INSERT INTO nuq_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tena tokorua raa hakaatoa ku se lavaa te ppehi na taoni laaua raa, kito te tama hai sileni raa ki ssoro na taoni tokorua raa hakaatoa i taha. Koai te tama tokorua nei e me ki laoi mahi roo te tama hai sileni raa?” ");
INSERT INTO nuq_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tena Saimon ki meake, “Anau e tini kame ko te tama tera e isi te taoni e rahi raa.” Tena Jisas ki meake, “Noo, akoe e tonu.” ");
INSERT INTO nuq_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kito Jisas ki hakatike ake te hine raa, tena Aia ki meake Saimon, “Akoe e kite te hine nei? Anau e hamai i roto te hare akoe nei, tena akoe se kou mai ni vai ki huhui na vae Anau, e meia te hine nei e huhui na vae Anau raa ma na vai karemata aia raa, tena ki hakapakupaku na vae Anau raa ma te rouru aia. ");
INSERT INTO nuq_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Akoe se mohoni Anau te saaita Anau ni hamai i roto te hare akoe nei, e meia te hine nei se hakamotu te momohoni na vae Anau kaamata roo te saaita Anau ni hamai raa. ");
INSERT INTO nuq_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Akoe se hai sunu na oliv ni kou mai ma ki amuhi te pohouru Anau, e meia te hine nei e amuhi na vae Anau raa ma te lloo manoni aia raa. ");
INSERT INTO nuq_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Anau e meatu akoe, te laoi te hine nei e huri mai Anau raa e huri mai te hakamaoni pera ma na hai sara tammaki aia raa ku oti te ssorohia i taha. Emeia kame TeAtua e ssoro na hai sara moisi te tama, tena te laoi te tama naa i Anau raa se lavaa te hai mahi.” ");
INSERT INTO nuq_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tena Jisas ki meake te hine raa, “Anau e ssoro na hai sara akoe raa i taha.” ");
INSERT INTO nuq_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Na tama e nnoho i te kina raa ku tattara hokolaatou ma, “Koai te Tama nei, Aia e lavaa hoki te ssoro na hai sara i taha?” ");
INSERT INTO nuq_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tena Jisas ki meake te hine raa, “Te hakatina akoe raa e tokonaki akoe ki ora, haere ma te noho laoi.” ");
INSERT INTO nuq_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tena i muri Jisas ku haere vaa roto na matakaina e llahi ia ma na matakaina pammee raa no takutaku te Rono Tauareka i te Hakamaatua ana i te Vaelani raa. Te sanahuru ma rua na disaipol raa e oo hoki ma Jisas, ");
INSERT INTO nuq_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","tena e isi hoki na hhine tera Jisas ni tokonaki no hakaise na tipua sakkino i taha raa ia ma na hhine tera Jisas ni tokonaki laatou no taualleka ma na maahana laatou raa: Meri te tama e hui ma ko Makdala raa, te tama Jisas ni hakaise e hitu na tipua i taha raa, ");
INSERT INTO nuq_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","tena Joana, te tanata aia raa ko Kusa, he tama hehekau ma Herot, tena Susana ia ma alaa hhine hoki tera e hai na mahi laatou ma ki tokonaki Jisas ma na disaipol Aia raa. ");
INSERT INTO nuq_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tammaki na tama e oo mai i na matakaina hakaatoa no muimui ake iaa Jisas, tena Jisas ki tattara ake te tattara hurihuri nei te saaita te kanohenua raa ni hakkutu ake roo hakaatoa raa: ");
INSERT INTO nuq_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Teeraa he tama e haere lletu na hua ma ki hhomo. Te saaita te tama raa ni haere lletu na hua raa, alaa hua ku maoha i aruna te mateara, tena na tama ku hahaere lakalaka koi na hua raa, tena na manu raa hoki e kkai na hua raa. ");
INSERT INTO nuq_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Alaa hua ku maoha i te kina e hatu, tena te saaita na hua raa ni hhomo raa, na hua raa e hhomo ake koi no mmate, e mee te kerekere raa e pakupaku. ");
INSERT INTO nuq_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Alaa hua ku maoha i te kina na veve tutuia. Tena na veve tutuia raa ku hhomo no uhi na hua raa. ");
INSERT INTO nuq_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Alaa hua ku maoha i aruna te kina te kerekere tauareka, tena na hua raa ku hhomo no llahi no hhua, tena te laakau hokotahi e tae huitarau na hua.” Kito Jisas ki hakaoti ake ma, “Tena hakallono kame kootou e isi na katarina.” ");
INSERT INTO nuq_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Na disaipol Jisas raa e vahiri ake Tama raa ma te hakataakoto te tattara hurihuri raa e mee maea. ");
INSERT INTO nuq_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tena Jisas ki meake, “TeAtua e hihai kootou ki illoa na mee i te Hakamaatua ana Aia raa, tena Aia e tattara ake alaa tama na tattara hurihuri ma niaina na tama raa e matamata, e meia na tama raa se lavaa te kkite, ia niaina ma na tama raa e llono, e meia na tama raa se lavaa te illoa.” ");
INSERT INTO nuq_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Teenei te hakataakoto te tattara hurihuri nei: Na hua raa ko na tattara TeAtua. ");
INSERT INTO nuq_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Na hua e maoha i te mateara raa ko na tama tera e llono na tattara TeAtua raa, tena Satan ku haere ake no too na tattara TeAtua raa i taha ma na hatu manava na tama raa ma ki ppui na tama raa ki se hakattina ma ki se lavaa TeAtua te tokonaki na tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Na hua e maoha i te kina e hatu raa ko na tama e llono na tattara TeAtua raa, tena ki hihhia no too na tattara raa. Emeia na tattara raa se mmoe roroa i roto na tama raa; na tama raa e hakattina paa saaita koi, tena te saaita laatou ku ttiri na hahaaite raa, na tama raa ku tiaki koi na hakattina laatou raa. ");
INSERT INTO nuq_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Na hua e maoha i te kina na veve tutuia raa ko na tama e llono na tattara TeAtua raa, e meia na hakataakoto i te vahi na sileni ia ma te ora te maarama nei raa e mee na hakattina na tama raa no se hai mmahi, tena na hua laatou e hhua raa ku se lavaa te lleu. ");
INSERT INTO nuq_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na hua e maoha i te kina te kerekere tauareka raa ko na tama e llono na tattara TeAtua raa, tena ki ttaohi mmau na tattara raa i roto na hatu manava laatou, tena ki tuu mmau no hhua na hua. ");
INSERT INTO nuq_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Se hai tama e hakaura te lamu, tena ku uhi i raro te kumete ia ma ku tuku i raro te sea. Emeia te tama raa e me ki hakatuu te lamu raa i aruna te kina e hakatuutuu te lamu raa ki lavaa na tama te kkite te maahina te saaita laatou e oo mai i hare.” ");
INSERT INTO nuq_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Na mee hakaatoa e huuna ria raa e me ki hura ake i mua na tama. Tena na mee tera e uhi ria raa e me ki laavea ria. ");
INSERT INTO nuq_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Kootou ki hakamattonu te saaita kootou e hakallono, maitaname TeAtua e me ki hakapaa ake alaa mee i aruna na mee akoe e isi raa, e meia kame akoe se isi, tena akoe se hihai hoki te too, tena na mee raa e me ki too ria i taha ma akoe.” ");
INSERT INTO nuq_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Te tinna ia ma na taina Jisas raa e oo ake ma ki mmata Tama raa, e meia laatou ku se lavaa te oo hakataapiri ake, maitaname te kanohenua raa e muimui areha roo Jisas. ");
INSERT INTO nuq_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tena he tama ki meake Jisas, “Te tinna ia ma na taina Akoe raa e ttuu i aho, tena laatou e hihhai ma ki mmata Akoe.” ");
INSERT INTO nuq_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kito Jisas ki meake na tama raa hakaatoa, “Te tinna ia ma na taina Anau raa ko na tama tera e llono na tattara TeAtua, tena ki ppena tauttari na tattara raa.” ");
INSERT INTO nuq_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Teeraa he aho, Jisas ma na disaipol Aia raa e kakke i roto te vaka. Tena Jisas ki meake na tama raa, “Taatou ki tere i teeraa vahi te namo nei.” Kito na tama raa ki uhu no tere. ");
INSERT INTO nuq_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Te saaita laatou koi tere, Jisas ku moe heiroa. Te saaita naa koi te matani raa ku maairi hai mahi roo, tena te vaka raa ku utu ria na peau no taapiri ki apuru. ");
INSERT INTO nuq_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kito na disaipol raa ki huro no hhano Jisas, tena ki meake, “TeAriki, TeAriki, taatou kaa mallemo no mmate!” Jisas ku maahuru, tena ki tattara ake te matani ia ma na peau raa. Tena te matani raa ma na peau raa ku tteiho no marino kkii roo. ");
INSERT INTO nuq_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tena Jisas ki meake na disaipol raa, “Na hee na hakattina kootou?” Emeia na disaipol raa e mahharo, ia e mattaku hoki, tena laatou ki vahihhiri hokolaatou ma, “Te Tama nei he tama peehee? Aia e tattara ake te matani ma na peau raa, tena na mee raa e hakallono hoki Aia.” ");
INSERT INTO nuq_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tena Jisas ma na disaipol Aia raa ku tere no tae teeraa vahi te namo Galili raa i te kina na tama i Gerasa. ");
INSERT INTO nuq_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Te saaita Jisas ni tiho i uta, he tama i te matakaina raa e isi na tipua sakkino ku haere ake no ttiri Tama raa. Saaita roroa roo te tama raa se isi na hekau, tena aia se noho i te hare aia raa, e meia te tama raa e noho i roto na rua na tama e mmate raa e mmoe. ");
INSERT INTO nuq_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Te saaita aia ni kite Jisas, te tama raa ku tteiho no tuturi i mua na vae Jisas, tena ki kanna ake, “Jisas te Tamariki TeAtua Hakanaaniu i Aruna! Hea Akoe e hihai i anau? Anau e kainno atu Akoe, auu se mee anau ki hakalono llihu!” ");
INSERT INTO nuq_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Te tanata raa e tattara peenei, maitaname Jisas ku oti te hakaise te tipua raa i taha ma aia. Tammaki na vahao aia ni hakapiki ria, ia niaina ma na vae ia ma na rima aia raa e haihai ria na seni, e meia te tama raa e me ki mmosi koi na seni raa, tena te tipua raa ku too aia no kkave i te kina e tuu mahoa raa. ");
INSERT INTO nuq_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Kito Jisas ki vahiri ake te tama raa, “Koai te inoa akoe?” Tena te tama raa ki meake, “Te inoa anau raa ko ‘He kautana,’ ” maitaname tammaki na tipua e nnoho i roto te tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kito na tipua raa ki kainno ake Jisas ma ki se lavaa te kkave laatou i te kina te rua e nnoto raa ki ttae roo te saaita laatou e too na hakalono llihu hakaoti laatou raa. ");
INSERT INTO nuq_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","E isi na piki tammaki roo e kaikkai i te vahi te mouna raa. Kito na tipua raa ki kainno ake Jisas ma ki tiaki laatou ki huro i roto na piki raa, tena Aia ki meake na tipua raa ki oo. ");
INSERT INTO nuq_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Na tipua raa e huro i taha ma te tama raa no uru i roto na piki raa. Tena na piki raa hakaatoa ku huro i te vahi te mouna e motu hua raa no tteiho i roto te moana raa no mallemo. ");
INSERT INTO nuq_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Na tama e lollohi na piki raa e kkite hea ni kapihi ake i na piki raa, tena na tama raa ki huro no paa te rono raa i na matakaina ia ma na kina vaa raa. ");
INSERT INTO nuq_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tena na tama raa hakaatoa ku oo ake no mmata ma hea ni kapihi ake i te kina raa, tena te saaita na tama raa ni oo ake no ttiri Jisas raa, na tama raa ku kkite hoki te tama tera ni noho ria na tipua raa ku noho i te kina na vae Jisas raa. Te tama raa ku uru na hekau, tena te hakataakoto aia raa ku tauareka, tena na tama raa hakaatoa ku mattaku. ");
INSERT INTO nuq_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Na tama ni kkite raa ku tattara ake te kanohenua raa pera ma Jisas ni tokonaki te tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tena na tama te matakaina raa hakaatoa ku mattaku, tena laatou ki meake Jisas ki haere i taha. Kito Jisas ki kake te vaka raa no tere. ");
INSERT INTO nuq_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tena te tama Jisas ni tokonaki no hakaise na tipua i taha raa ku meake Jisas, “Tiaki anau ki hahaere ma Akoe.” Emeia Jisas e kauna te tama raa ki haere, tena ki meake, ");
INSERT INTO nuq_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Haere i hare, tena ku tattara ake na tama pera ma TeAtua e tokonaki akoe.” Tena te tama raa ki haere vaa roto na matakaina raa hakaatoa no tattara ake pera ma Jisas e tokonaki aia. ");
INSERT INTO nuq_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Te saaita Jisas ni vaakai i Galili raa, te kanohenua raa ku too hakaraoi te Tama raa, e mee laatou hakaatoa ni hakattari Tama raa ki haere ake. ");
INSERT INTO nuq_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tena he tama e rorohi te hare lotu; te inoa aia raa ko Jairus. Aia e tteiho no tuturi i mua na vae Jisas, tena ki kainno ake Tama raa ma ki oo laaua i te hare aia raa, ");
INSERT INTO nuq_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","e mee te tamariki hine aia raa ku mee ki mate, te tamariki raa ku tae sanahuru ma rua na hetau, ia teenaa ko te tautahi koi aia. Te saaita Jisas ni haere, te kanohenua raa ku muimui ake roo Tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tena i roto te kanohenua raa, e isi te hine te toto aia raa e tettere koi peenaa, te hine raa e hakalono llihu roo i roto sanahuru ma rua na hetau. Na sileni te hine raa ku oti te suisui na dokta ma ki tokonaki aia, e meia se hai tama e lavaa te tokonaki aia. ");
INSERT INTO nuq_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kito te hine raa ki hamai vaa muri Jisas no ttaohi na kaunutu na hekau Jisas raa, ia te saaita naa koi te toto raa ku hakamotu. ");
INSERT INTO nuq_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tena Jisas ki vahiri ake, “Koai te tama ni ttaohi Anau raa?” Tena te kanohenua raa hakaatoa e kore pera ma laatou se hai tama ni taohi Jisas. Kito Pita ki meake, “TeAriki, te kanohenua nei hakaatoa e muimui areha roo Akoe.” ");
INSERT INTO nuq_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Emeia Jisas e meake ma, “E isi te tama ni taohi Anau, Anau e iroa maitaname e isi na mahi ni oo i taha ma Anau.” ");
INSERT INTO nuq_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Te hine raa ku iroa pera ma aia ku laavea ria, tena aia ku porepore te mataku, kito te hine raa ki haere atu no tuturi i mua na vae Jisas. Te hine raa e tattara ake Jisas te hakataakoto tera aia ni ttaohi na hekau Tama raa ia ma te maatara te tinotama aia raa i mua te kanohenua raa hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Tena Jisas ki meake te hine raa, “Taku tama, te hakatina akoe raa e mee akoe no tauareka. Haere ma te noho laoi.” ");
INSERT INTO nuq_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisas koi tattara koi, tena he tama i te hare Jairus raa ku haere ake no meake tama raa ma, “Te tamariki hine akoe raa ku mate, tena tiaki koi te Rabai naa.” ");
INSERT INTO nuq_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Emeia Jisas e rono na tattara raa, tena Aia ki meake Jairus, “Auu se mataku; akoe ki hakatina koi, tena te tamariki naa e me ki tauareka.” ");
INSERT INTO nuq_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jisas ku tae i te hare Jairus raa, tena Aia ki ppui ki se hai tama hoki e haere ma Aia i hare, tena Aia ki too koi Pita, Jems, Jon ia ma na maatua te tamariki raa. ");
INSERT INTO nuq_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Na tama i roto te hare raa hakaatoa ku tanittani i te tamariki hine raa. Tena Jisas ki meake, “Auu se ttani, te tamariki naa se mate; te tamariki naa e moe koi.” ");
INSERT INTO nuq_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Na tama raa ku tataussua Jisas, e mee laatou e illoa pera ma te tamariki raa ku mate. ");
INSERT INTO nuq_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jisas e ttaohi te rima te tamariki hine raa, tena ki meake, “Taku tama, mahike i aruna.” ");
INSERT INTO nuq_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Te tamariki raa ku ora hakaraoi, tena ki mahike no noho i aruna, tena Jisas ki meake na tama raa ki kou ake ni kai ki kai te tamariki raa. ");
INSERT INTO nuq_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Na maatua te tamariki raa ku mahharo roo, tena Jisas ki meake na tama raa ki se tattara ake alaa tama hea Aia ni ppena raa. ");
INSERT INTO nuq_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisas e kanna ake te sanahuru ma rua na disaipol Aia raa ki hakkutu ake hakaatoa, tena Aia ki kou ake na tama raa na mahi ki hakaise na tipua sakkino, tena ku tokonaki hoki na tama lavvea raa. ");
INSERT INTO nuq_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tena Jisas ki kauna na tama raa ki oo no takutaku i te vahi te Hakamaatua ana i te Vaelani raa, tena ku tokonaki hoki na tama lavvea raa ki taualleka. ");
INSERT INTO nuq_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jisas ku oti te tattara ake na tama raa ma, “Kootou se lavaa te too ni mee te saaita kootou e oo raa, ia se too ni laakau hahaere, ia se too ni muri kopu, ia se too ni kai, ia se too ni sileni, ia se too hoki he kaukahu. ");
INSERT INTO nuq_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kootou ki nnoho koi i te hare hokotahi i roto te matakaina tera e too hakaraoi kootou raa, ki ttae roo te saaita kootou e oo i taha ma te matakaina naa. ");
INSERT INTO nuq_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kame he matakaina se hihai ki too kootou, tena kootou ku tiaki te matakaina naa, tena ku ttahi na kerekere e mmau na muri vae kootou raa ki illoa laatou pera ma teenaa he hakkatu haeo.” ");
INSERT INTO nuq_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tena na disaipol raa ki oo i na matakaina hakaatoa no takutaku ake te Rono Tauareka raa, tena ki tokonaki hoki na tama lavvea i na kina roo hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Te saaita Herot, te tuku i Galili raa ni rono na mee Jisas ni ppena raa, aia ku vvare hakaoti roo, maitaname alaa tama e tattara ma Jon Baptis ku ora muri. ");
INSERT INTO nuq_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Tena alaa tama e tattara ma Elaija ku vaakai mai muri, tena alaa tama hoki e tattara ma teeraa he profet na profet TeAtua i mua tera ku ora muri. ");
INSERT INTO nuq_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tena Herot ki meake, “Anau ni meake na soldia anau raa ki ssepe te uaa Jon raa ki hopo. Kaa teenei koai te tama anau e rono e ppena na mee e llahi nei?” Tena Herot ku hahaivi ma ki kite aia Jisas. ");
INSERT INTO nuq_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tena na aposol raa ku vakkai ake no tattara ake Jisas na mee hakaatoa laatou ni ppena raa. Jisas ku too na tama raa, tena laatou ki oo hokolaatou i te matakaina Betsaida raa. ");
INSERT INTO nuq_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Te saaita te kanohenua raa ni llono ma Jisas ku haere ma na aposol Aia raa, na tama raa ku tauttari Tama raa. Jisas e hihia i na tama raa, tena Aia ki tattara ake na tama raa i te Hakamaatua ana i te Vaelani raa, tena ki tokonaki hoki na tama tera e hihhai ma laatou ki taualleka raa. ");
INSERT INTO nuq_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Te saaita te laa raa ku hakatootoo ma ki huru, te sanahuru ma rua na disaipol raa ku oo ake no meake Jisas ma, “Meake te kanohenua nei ki oo i na matakaina ia ma na kina tappiri mai raa no ssee ni kai ia ma ni kina ki mmoe, e mee teenei he kina se hai tama.” ");
INSERT INTO nuq_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Emeia Jisas e meake na tama raa ma, “Kootou ki kou ake ni kai ma te kanohenua nei ki kkai.” Kito na disaipol raa ki meake, “Maatou e isi koi e rima na haraoa ia ma e rua na ika. Akoe e hihai ma maatou ki oo no sui ni kai ma te kanohenua nei hakaatoa?” ");
INSERT INTO nuq_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Te kooina na taanata hakaatoa i te kina raa kame e ttae rima simata.) Tena Jisas ki meake na disaipol Aia raa, “Meake te kanohenua raa ki nnoho i na kuturana ki ttae tipu rima na tama.” ");
INSERT INTO nuq_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kito na disaipol raa ki meake te kanohenua raa hakaatoa ki nnoho i raro. ");
INSERT INTO nuq_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tena Jisas ki too e rima na haraoa ia ma e rua na ika raa, tena ki kkira i aruna i te vaelani no lotu ake TeAtua, tena ki ttohi na haraoa raa, tena ki kou ake na disaipol Aia raa ki vaevae ake i te kanohenua raa. ");
INSERT INTO nuq_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Te kanohenua raa hakaatoa e kkai no ppohu, tena na disaipol raa ki haere saosao na muri haraoa ia ma na punnohi e ttoe raa no ppii sanahuru ma rua na kete. ");
INSERT INTO nuq_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","E isi te aho Jisas e lotu Hokoia, tena na disaipol Aia raa ki oo ake. Kito Jisas ki vahiri ake na tama raa, “Te kanohenua raa e tattara ma Anau koai?” ");
INSERT INTO nuq_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kito na tama raa ki meake, “E isi na tama e tattara ma Akoe ko Jon Baptis, tena alaa tama e tattara ma Akoe ko Elaija, tena alaa tama hoki e tattara ma Akoe he profet i mua tera ku ora muri.” ");
INSERT INTO nuq_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tena Jisas ki vahiri ake na disaipol raa ma, “Kaa kootou e mee ma Anau koai?” Kito Pita ki meake, “Akoe ko te Mesaia TeAtua.” ");
INSERT INTO nuq_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tena Jisas ki tattara hakamataku ake na disaipol raa ki se tattara ake ni tama. ");
INSERT INTO nuq_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jisas e tattara ake hoki na disaipol raa ma, “Te Tamariki te Tama nei e me ki hakalono llihu, tena na tama hakamattua na Jiu raa, na maatua hakananniu raa ia ma na tama e poroporo na tuaa raa e me ki se hihhai te Tama raa. Tama raa e me ki taia ria no mate, e meia e toru na aho i muri Tama raa e me ki mahike muri no ora.” ");
INSERT INTO nuq_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tena Jisas ki meake na tama raa hakaatoa, “Kame he tama e hihai ki tautari Anau, te tama naa ki tiaki na mee hakaatoa aia e hihai raa, tena ku amo te kros aia raa no tautari mai Anau. ");
INSERT INTO nuq_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kame he tama e maanatu te ora aia, te tama naa e me ki se lavaa te too te ora hakamaoni, e meia kame he tama e hoki mai te ora aia raa ki tautari Anau, tena aia e me ki too te ora hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Hea akoe e me ki too kame akoe e ttino na mee i te maarama nei raa hakaatoa, e meia i roto roo te ora akoe raa e haeo roo? Se hai mee akoe e me ki too. ");
INSERT INTO nuq_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Kame akoe e napa Anau ia ma na akoako Anau raa, tena te Tamariki te Tama nei e me ki napa hoki akoe te saaita Aia e hamai ma na mahi Aia ia ma na mahi te Tamana ia ma na ensel e ttapu Aia raa. ");
INSERT INTO nuq_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Anau e meatu te hakamaoni pera ma alaa tama kootou e ora vahao nei raa e me ki se lavaa te mmate ki tae te saaita laatou e kkite te Hakamaatua ana i te Vaelani raa.” ");
INSERT INTO nuq_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","He latapu hakaatoa ku raka te saaita Jisas ni tattara ake na disaipol raa, tena Aia ki too Pita, Jems, tena Jon no haere ma Aia, tena laatou e oo i aruna te mouna raa ma ki lotu. ");
INSERT INTO nuq_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jisas koi lotu, tena na maihu Aia raa ku haere no maahina roo, tena na hekau Aia raa ku makkini hua roo. ");
INSERT INTO nuq_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Te saaita naa koi tokorua na tama ku ttuu ake no tattara laatou ma Jisas. Tokorua raa ko Moses laaua ma Elaija, ");
INSERT INTO nuq_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","tokorua raa ni hakahura ake ma na mahi i te vaelani no tattara laatou ma Jisas i te vahi Aia e me ki mate i Jerusalem ki kotia te hakataakoto TeAtua raa. ");
INSERT INTO nuq_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita ma teeraa tokorua ku mmoe heilloa roo, e meia laatou ku mahhuru no kkite na mahi Jisas ia ma teeraa tokorua na taanata ku ttuu laatou ma Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moses laaua ma Elaija ku mee ma ki tiaki Jisas, tena Pita ki meake Tama raa, “TeAriki, e tauareka roo e mee maatou i te kina nei! Maatou e me ki hakatuu e toru na paa hare; te hare Akoe, te hare Moses, tena te hare Elaija.” (Pita se iroa roo hea aia e tattara raa.) ");
INSERT INTO nuq_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita koi tattara koi, tena te pukureurehu raa ku haere iho no uhi na tama raa hakaatoa, tena tokotoru na disaipol raa ku mattaku roo. ");
INSERT INTO nuq_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tena te reo raa ku tattara iho i roto te pukureurehu raa ma, “Teenei he Tama roo Anau tera Anau ni hirihiri, tena kootou ki hakallono te Tama nei.” ");
INSERT INTO nuq_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Te reo raa e tattara no oti, tena tokotoru raa ku kkite Jisas ku tuu koi Hokoia. Na disaipol raa e kkumi hemuu na mee raa hakaatoa, tena laatou se hai tama e tattara ake te saaita naa i na mee laatou ni kkite raa. ");
INSERT INTO nuq_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tena te aho taiao raa na tama raa ku oo iho i raro ma te mouna raa no ttiri te kanohenua e tammaki roo. ");
INSERT INTO nuq_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Teeraa he tama e kanna ake i roto te kanohenua raa ma, “Rabai, hamai no mmata te taupeara anau nei. Teenei ko te tautahi koi anau. ");
INSERT INTO nuq_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Tammaki na vahao te tipua raa e noho i roto te tama nei, tena aia e me ki hakateki no kapihi te varo aia raa no ppore, tena te araara raa ku koo i te maihu aia. Te tipua raa e mee roo te tama nei ki hakalono llihu, tena aia ku se lavaa roo te tiaki te tama nei no haere i taha. ");
INSERT INTO nuq_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Anau e kainno ake na disaipol Akoe raa ki hakaise te tipua raa i taha ma te tama nei, e meia na tama nei se lavaa.” ");
INSERT INTO nuq_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kito Jisas ki meake, “Kootou ni tama se hakattina, ia ni tama haeo! E hia na vahao Anau e me ki nnoho ma kootou? E hia na vahao Anau e me ki tattara atu kootou?” Tena Aia ki meake te tamana te tamariki raa, “Kou mai te tamariki naa i te kina nei.” ");
INSERT INTO nuq_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Te saaita te tamariki raa ni haere ake, te tipua raa ku lletu te tamariki raa i raro, tena te tamariki raa ku kaamata no ppore. Kito Jisas ki hakaise te tipua raa i taha ma te tamariki raa. Teenaa koi te tamariki raa ku tauareka, tena Jisas ki kou ake muri te tamariki raa i te tamana aia raa. ");
INSERT INTO nuq_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Na tama raa hakaatoa ku mahharo i na mahi hai mmahi TeAtua raa. Te kanohenua raa koi mamahharo roo i na mee hakaatoa Jisas ni ppena raa, te saaita Jisas ni tattara ake na disaipol Aia raa ma, ");
INSERT INTO nuq_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Kootou ki se ssiri hea Anau ni tattara atu kootou raa! Te Tamariki te Tama nei e me ki noho i raro na mahi na tama i te maarama nei.” ");
INSERT INTO nuq_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Emeia na disaipol raa se illoa te hakataakoto na tattara raa. TeAtua e mee na hakataakoto na tama raa no pouri ki se lavaa na tama raa te illoa, tena na disaipol raa e mattaku hoki te vahiri ake te hakataakoto na tattara raa. ");
INSERT INTO nuq_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tena na disaipol Jisas raa ku hakatauttau hokolaatou ma koai te tama laatou e me ki hakanaaniu. ");
INSERT INTO nuq_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Emeia Jisas e iroa na hakataakoto na tama raa, tena Aia ki too te tamariki raa no hakatuu i te vahi Aia, ");
INSERT INTO nuq_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","tena Aia ki meake na tama raa, “Te tama e too hakaraoi na tamalliki peenei i te inoa Anau raa, e too hakaraoi hoki Anau, tena te tama e too hakaraoi Anau raa e too hakaraoi hoki te Tama ni kauna ria mai Anau raa. E mee te tama e mouraro kootou hakaatoa raa ko te tama e hakanaaniu.” ");
INSERT INTO nuq_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tena Jon ki meake, “TeAriki, maatou e kkite te tama e hakaise na tipua i te inoa Akoe, tena maatou ki ppui te tama raa, maitaname te tama raa seai ma he tama i roto te kuturana taatou nei.” ");
INSERT INTO nuq_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tena Jisas ki meake Jon ma alaa disaipol ma, “Auu se ppui te tama naa, maitaname te tama se hakataukaa ma kootou raa he tama i roto kootou.” ");
INSERT INTO nuq_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Te saaita Jisas ku mee ki too ria no kkave i te vaelani raa ku taapiri, tena Aia ku maanatu ma ki haere i Jerusalem. ");
INSERT INTO nuq_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jisas e kauna na tama raa ma na tattara Aia raa ki oo i mua Aia i te matakaina i Samaria raa no tanattana na mee hakaatoa ki ttae atu Aia. ");
INSERT INTO nuq_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Emeia na tama te matakaina raa se hihhai ki too Jisas, e mee laatou e illoa koi ma Tama raa e mee ki haere i Jerusalem. ");
INSERT INTO nuq_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jems laaua ma Jon e kkite ma na tama raa ku se hihhai ki too Jisas, tena tokorua raa ki oo no meake Jisas ma, “TeAriki, Akoe e hihai ma maaua ki kanna he ahi i te vaelani ki haere iho no seu na tama te matakaina nei?” ");
INSERT INTO nuq_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tena Jisas ki hakatike no hai ake tokorua raa ma, “Koorua se illoa ma he anana peehee koorua e isi; e mee te Tamariki te Tama nei se hamai ma ki seu na ora na tama, e meia Aia e hamai ki tokonaki na ora na tama.” ");
INSERT INTO nuq_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tena Jisas ma na disaipol Aia raa ki oo i teeraa matakaina. ");
INSERT INTO nuq_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Na tama raa koi oo koi vaa aruna te mateara, tena he tama ki meake Jisas ma, “Anau e me ki tautari Akoe he kina peehee Akoe e haere.” ");
INSERT INTO nuq_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Tena Jisas ki meake te tama raa, “Na manu vaa roto raa e isi na rua e moemmoe, tena na manu lellee raa e isi na hohana, e meia te Tamariki te Tama nei se isi te kina e me ki moe no hamaroroo.” ");
INSERT INTO nuq_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kito Jisas ki meake teeraa tama, “Tautari mai Anau.” Emeia te tama raa e meake ma, “TeAriki, hakattari ki haere anau no tanu te tamana anau raa i mua.” ");
INSERT INTO nuq_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tena Jisas ki meake te tama raa, “Tiaki na tama ku mmate raa ki tanu na tama laatou e mmate raa, tena akoe ku haere no takutaku ake te Hakamaatua ana i te Vaelani raa i na tama.” ");
INSERT INTO nuq_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tena kito teeraa tama ki meake, “TeAriki, anau e me ki tautari Akoe, e meia hakattari ki haere anau no hakaalloha ma na hareakina anau raa i mua.” ");
INSERT INTO nuq_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tena Jisas ki meake te tama raa, “Kame he tama e kaamata no tautari Anau, e meia aia e mamaanatu na tiputipu aia i mua raa, te tama naa se lavaa te tae i te Hakamaatua ana i te Vaelani raa.” ");
INSERT INTO nuq_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tena i muri, Jisas ku hirihiri tipu hitu ma rua na tama, tena ki kauna na tama raa taki tokorua ki oo i mua Aia i na matakaina tera Aia e me ki oti ku haere raa. ");
INSERT INTO nuq_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Tena Jisas ki meake na tama raa, “Na laakau raa e huhhui roo, e meia na tama e me ki oo no haki raa e moisi. Lotu ake te Tama Hakamaatua te huata raa ki kauna ria mai ni tama hehekau ki oo no haki na hua raa. ");
INSERT INTO nuq_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Anau e kauna kootou pera ma ni punua sipsip ki oo i na poi kai ttama raa. ");
INSERT INTO nuq_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Auu se too ni muri kopu na sileni ia ma ni punakete, ia se too hoki ni taka. Auu se ttuu no tattara ma na tama i te mateara. ");
INSERT INTO nuq_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Te saaita kootou e uru i roto te hare, kootou ki meake i mua ma, ‘Te noho laoi ki nnoho ma kootou.’ ");
INSERT INTO nuq_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kame te tama e noho te hare naa e laoi kootou, tena tiaki te tauareka kootou e oo atu ma kootou raa ki noho ma te tama naa, ia kame seai kootou ku too muri te tauareka naa. ");
INSERT INTO nuq_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nnoho i roto te hare hokotahi koi, tena ku kkai, ia unu hea na tama naa e kou atu kootou, maitaname na tama hehekau raa e tau te too na sui laatou. Kootou ki se haere uru huri na hare. ");
INSERT INTO nuq_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","He saaita peehee kootou e oo i roto he matakaina, tena na tama raa ku too hakaraoi kootou, tena kkai hea na tama naa e kou atu kootou ki kkai raa, ");
INSERT INTO nuq_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","tena ku tokonaki na tama lavvea i roto te matakaina naa, tena ku meake hoki te kanohenua naa pera ma, ‘Te Hakamaatua ana i te Vaelani raa ku taapiri atu i kootou.’ ");
INSERT INTO nuq_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Emeia kame kootou e oo i roto he matakaina, tena na tama te matakaina naa se hihhai kootou, tena kootou ku oo vaa roto na mateara raa hakaatoa no tattara ake na tama raa pera ma, ");
INSERT INTO nuq_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Maatou e me ki ttahi na kkere te matakaina nei e mmau na vae maatou raa ki illoa kootou pera ma kootou e ssara. Kootou ki mannatu pera ma te Hakamaatua ana i te Vaelani raa ku hamai no taapiri atu i kootou!’ ");
INSERT INTO nuq_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Anau e meatu kootou pera ma te Aho te Hakatonutonu raa, TeAtua e me ki huri ake te laoi Aia e rahi roo i na tama i Sodom, ia seai ma na tama te matakaina naa. ");
INSERT INTO nuq_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Na tama i Korasin raa, kootou e me ki hakalono llihu haeo roo. Na tama i Betsaida, kootou e me ki hakalono llihu hoki. Peeraa maatou ki ppena na mirakol maatou ni ppena i roto na matakaina nei raa i Taia laaua ma Saidon, na tama na matakaina seai ma ni Jiu raa peeraa ko na ppari avare no too na rehu raa no murumuru na tinotama laatou raa ki huri ake pera ma laatou ku ttike i taha ma na hai sara laatou raa! ");
INSERT INTO nuq_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","TeAtua e me ki huri ake te laoi Aia e rahi roo i na tama i Taia laaua ma Saidon i te Aho te Hakatonutonu raa, ia seai ma kootou. ");
INSERT INTO nuq_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Tena kootou na tama i Kaperneam raa! Kootou e hihhai ki ssau kootou hokkootou ki ttae i te vaelani? Kootou e me ki lettua ria i te kina te ahi raa.” ");
INSERT INTO nuq_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tena Jisas ki meake na disaipol Aia raa ma, “Te tama e hakarono na tattara kootou raa, e me ki hakarono hoki na tattara Anau raa, ia te tama se hihai kootou raa, e me ki se hihhai hoki Anau, tena te tama se hihai Anau raa, e me ki se hihai hoki te Tama ni kauna ria mai Anau raa.” ");
INSERT INTO nuq_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tena te tipu hitu ma rua na tama Jisas ni kauna raa ku vakkai muri ake, tena ku hihhia roo. Kito na tama raa ki meake, “TeAriki, na tipua raa e hakallono maatou te saaita maatou e hakaise laatou i te inoa Akoe!” ");
INSERT INTO nuq_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tena Jisas ki meake na tama raa, “Anau e kite Satan e tteiho i taha ma te vaelani pera ma he uila. ");
INSERT INTO nuq_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Hakallono! Anau e kou atu kootou na mahi ki hakahiti vaa aruna na lapono haeo ia ma na kahana, tena ku hakahiti hoki vaa aruna na mahi Satan, ia se hai mee e lavaa te mee kootou ki hakalono llihu. ");
INSERT INTO nuq_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tena kootou ki se hihhia e mee na tipua haeo raa e hakallono kootou; e meia kootou ki hihhia e mee na inoa kootou raa ku mmau i te vaelani.” ");
INSERT INTO nuq_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Te saaita naa TeAnana Tapu raa ku mee Jisas no hihia roo, tena Aia ki meake, “Tamana, Akoe ko TeAriki i te vaelani ia ma te maarama nei! Anau e hakammaha Akoe, maitaname Akoe e hakari ake na tama se illoa raa na mee tera Akoe e huu i taha ma na tama e atamai raa. Hakamaoni Tamana, teenei hea Akoe e hihai ma na mee nei ki kapihi mai peenei.” ");
INSERT INTO nuq_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kito Jisas ki meake na disaipol Aia raa ma, “Te Tamana Anau raa e kou mai na mee nei hakaatoa i Anau. Se hai tama e iroa te Tamariki nei, te Tamana Hokoia koi e iroa, ia se hai tama e iroa te Tamana, te Tamariki nei koi ia ma na tama Aia ni hirihiri raa e illoa te Tama raa.” ");
INSERT INTO nuq_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tena Jisas ki hakatike no meake hemuu na disaipol Aia raa ma, “Kootou e hakatapu ria TeAtua, maitaname kootou e kkite na mee e llahi kootou ni kkite raa. ");
INSERT INTO nuq_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Anau e meatu kootou pera ma tammaki na profet ia ma na tuku e hihhai ki kkite na mee kootou ni kkite raa, e meia laatou se lavaa te kkite. Na tama raa e hihhai ki llono hea kootou ni llono raa, e meia laatou se lavaa te llono.” ");
INSERT INTO nuq_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","He tama poroporo na tuaa e mahike i aruna no vahiri ake te vahiri e hainattaa roo iaa Jisas ma ki taaiki Tama raa. Tama raa e vahiri ake ma, “Rabai, hea anau e me ki ppena ki too te ora e ora tahi raa?” ");
INSERT INTO nuq_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tena kito Jisas ki meake te tama raa, “Te Launiu Tapu raa e tattara maea? Te hakataakoto akoe i te vahi na tuaa raa e mee peehee?” ");
INSERT INTO nuq_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kito te tama raa ki meake, “Laoi TeAriki TeAtua akoe raa ma te hatu manava akoe, te ora akoe, na mahi ia ma te hakataakoto akoe. Ia hoki, akoe ki laoi alaa tama pera ma akoe e laoi akoe hokkoe raa.” ");
INSERT INTO nuq_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tena Jisas ki meake, “Akoe e tonu, tautari na tuaa naa, tena akoe e me ki ora.” ");
INSERT INTO nuq_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Emeia te tama e poroporo na tuaa raa e hihai ki mee pera ma aia e mattonu, tena aia ki vahiri ake hoki Jisas ma, “Koai te tama anau e me ki laoi naa?” ");
INSERT INTO nuq_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tena Jisas ki meake, “E isi te tama e tiaki Jerusalem no haere i Jeriko, tena na tama kailallao raa ki hakaoho ake no too na hekau te tama raa hakaatoa, tena ki taa tama raa no taapiri ki mate. ");
INSERT INTO nuq_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tena he maatua na Jiu raa ku haere atu te mateara naa hoki, e meia te saaita aia ni kite te tama raa, te maatua raa ku taa no haere teeraa vahi te mateara raa. ");
INSERT INTO nuq_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tena ki oti te tama hehekau te hare lotu raa ku hamai te mateara naa hoki, tena ki haere atu no mmata te tama raa, tena ki hakaraka no haere teeraa vahi te mateara raa hoki. ");
INSERT INTO nuq_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Emeia he tama i Samaria e haere ake te mateara naa hoki no ttiri te tama raa. Te saaita aia ni kite te tama raa, aia ku aroha haeo roo. ");
INSERT INTO nuq_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tena aia ki haere ake no nnini na sunu ia ma na wain raa i aruna na saanuku te tama raa, tena ki haihai na saanuku raa. Tena aia ki ssau te tama raa no hakapiri i aruna te donki aia raa, tena ki too te tama raa no kkave i te hare na tama e moemmoe raa, tena aia ki rorohi te tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Te aho taiao raa, te tama i Samaria raa ku kou ake e rua na siliva ki sui ake te tama hakamaatua te hare raa, tena aia ki meake, ‘Rorohi ake te tama nei, te saaita anau e vaakai mai peenei raa, anau e me ki sui atu hea hoki akoe ni sui ki tokonaki te tama nei raa.’ ” ");
INSERT INTO nuq_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tena Jisas ki hakaoti ake ma, “I te hakataakoto akoe, koai te tama na tama e toru nei e huri ake te laoi aia i te tama e taia ria na tama kailallao raa?” ");
INSERT INTO nuq_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Kito te tama e poroporo na tuaa raa ki meake, “Te tama e aroha te tanata raa.” Tena Jisas ki meake te tama raa, “Ia haere, tena akoe ku ppena peeraa hoki.” ");
INSERT INTO nuq_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tena Jisas ma na disaipol Aia raa ku oo no ttae he matakaina, tena he hine te inoa aia raa ko Marta e hakkoro na tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta e isi te taina e hui ma ko Meri, tena Meri e noho taapiri na vae Jisas raa no hakarono Tama raa e akoako. ");
INSERT INTO nuq_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Tena Marta ku mamaanatu tammaki e mee aia e tammaki na mee e me ki ppena, tena aia ki haere ake no meake, “TeAriki, Akoe se hakataakoto pera ma te taina anau raa e tiaki mai na uata raa hakaatoa ki ppena anau hokonnau? Meake aia ki hamai no tokonaki anau.” ");
INSERT INTO nuq_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kito Jisas ki meake, “Marta, Marta! Akoe e mamaanatu tammaki, tena ku kapitia roo tammaki na mee, ");
INSERT INTO nuq_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","e meia he mee hokotahi e hakamaatua. Meri e hirihiri ki ppena te mee e hakamaatua, tena Anau se lavaa te tokea te mee raa i taha ma aia.” ");
INSERT INTO nuq_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","E isi te aho Jisas e noho he kina no lotu. Te saaita Aia ku oti te lotu, tena he tama na disaipol Aia raa ku meake Tama raa ma, “TeAriki, akoako mai maatou ki lotu pera ma Jon ni akoako ake na disaipol aia raa.” ");
INSERT INTO nuq_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tena Jisas ki meake na tama raa, “Te saaita kootou e lotu raa, tena kootou ku lotu peenei: ‘Tamana: Te inoa e tapu Akoe naa ki hakammaha ria; tiaki te Hakamaatua ana Akoe raa ki hamai. ");
INSERT INTO nuq_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kou mai ni kai ma maatou te aho ma te aho. ");
INSERT INTO nuq_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ssirihia niaa maatou e ssara, pera ma maatou e ssirihia niaa na tama e ssara i maatou raa. Auu se kou mai na hahaaite e hainattaa i maatou.’ ” ");
INSERT INTO nuq_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Tena Jisas ki meake na disaipol Aia raa ma, “Kame he tama kootou e haere te tuapoo no meake te soa aia raa ma, ‘Na soa, kou mai e toru na haraoa, tena i muri anau ku sui muri atu. ");
INSERT INTO nuq_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Anau e isi te soa e horau mai i te kina e mmao roo no tae mai vahao nei koi i hare, e meia anau se isi na kai ki kai te tama raa!’ ");
INSERT INTO nuq_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tena kame te soa akoe raa e tattara iho i roto hare ma, ‘Auu se mee hoki anau ki naenae! Te totoka raa ku oti te hakkapi, tena anau ma na tamalliki anau raa ku mmoe. Anau ku se lavaa hoki te mahike no kou atu ni kai.’ ");
INSERT INTO nuq_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Tena kaa ku mee peehee? Anau e meatu, niaina ma te soa akoe raa e kkaro te mahike no kou atu ni kai ma e mee koorua e ssoa laoi, e meia aia e me ki mahike no kou atu niaa akoe e kainno ake raa, e mee akoe se napa te kainno hakatau. ");
INSERT INTO nuq_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ia tena Anau e meatu kootou: Kainno, tena akoe e me ki too hea akoe e kainno raa; sesee, tena akoe e me ki llave hea akoe e sesee raa; papaku te totoka, tena te totoka raa e me ki taaraki atu akoe. ");
INSERT INTO nuq_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Maitaname na tama e kainno raa e me ki too hea laatou e kainno raa; na tama e sesee raa e me ki llave hea laatou e sesee raa, tena te totoka raa e me ki taaraki atu kootou na tama tera e papaku te totoka raa. ");
INSERT INTO nuq_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kame akoe he tamana, eaa akoe e me ki kou ake he lapono kame te tamariki raa e meatu ma ki kou ake he ika? ");
INSERT INTO nuq_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kaa seai akoe e me ki kou ake he kahana kame te tamariki raa e meatu ma ki kou ake he hua? ");
INSERT INTO nuq_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Niaina ma akoe he tama haeo, e meia akoe e iroa te kou ake na mee taualleka i na tamalliki kootou raa. Kaa e hia hoki te Tamana taatou i te vaelani raa e me ki kou ake TeAnana Tapu raa i na tama e kainno ake Aia raa!” ");
INSERT INTO nuq_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jisas e hakaise te tipua tera e mee te tama raa no se lavaa te tattara raa, tena te saaita te tipua raa ni haere i taha raa, tena te tama raa ku lavaa te tattara. Te kanohenua raa ku mahharo roo, ");
INSERT INTO nuq_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","e meia alaa tama e tattara ma, “Teenaa ko Belsebul, te tipua hakamaatua na tipua raa e kou ake na mahi Tama raa ki hakaise na tipua raa i taha.” ");
INSERT INTO nuq_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Alaa tama e hihhai ki taaiki Jisas, tena laatou ki meake Tama raa ki ppena he mirakol ki huri ake pera ma TeAtua ni kauna ria iho Tama raa hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Emeia Jisas e iroa na hakataakoto na tama raa, tena Aia ki meake na tama raa, “Kame na tama he henua e vaevae i na kuturana no ppuhu hokolaatou, te henua naa e me ki se lavaa te ttae teeraa saaita hoki. Tena kame he hai maatua e vaevae hokolaatou, tena na tama naa e me ki nnoho maseuseu. ");
INSERT INTO nuq_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tena kame na tipua Satan raa e vaevae i na kuturana no ppuhu hokolaatou, tena kaa te nohorana aia raa e me ki tauareka peehee? Kootou e tattara pera ma Anau e hakaise na tipua raa, e mee Belsebul e kou mai na mahi Anau ki ppena na mee raa. ");
INSERT INTO nuq_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kame Anau e hakaise na tipua raa i na mahi Belsebul, kaa na tama tauttari kootou raa e hakaise na tipua raa i taha peehee? Na tama tauttari kootou raa e huri atu pera ma kootou e ssara. ");
INSERT INTO nuq_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Emeia Anau e hakaise na tipua raa i taha i na mahi TeAtua, tena na mee nei e huri atu pera ma te Hakamaatua ana i te Vaelani raa ku oti te tae atu i kootou. ");
INSERT INTO nuq_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Kame he tama e ivi e rorohi te hare aia raa ma na hana aia, tena na hekau aia raa e me ki mmoe taualleka roo. ");
INSERT INTO nuq_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Emeia kame he tama e ivi i aruna te tama raa e haere ake no taa te tama raa, tena ku too na hana te tama raa e tuunaki raa no haere ma aia, tena ki vaevae na mee aia ni kairarao raa. ");
INSERT INTO nuq_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Te tama se tuu i te vahi Anau raa e hakataukaa ma Anau, tena te tama se tokonaki Anau ki hakkutu mai na tama raa e hakatui na tama raa i taha ma Anau. ");
INSERT INTO nuq_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kame he tipua e haere i taha ma te tama, te tipua naa e me ki haere vaa aruna na kina pakupaku raa no sesee he kina ki noho. Emeia kame aia se hai kina e lave, aia e me ki tattara hokoia ma, ‘Anau e me ki vaakai muri i te hare anau raa.’ ");
INSERT INTO nuq_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tena te tipua naa e me ki vaakai no kite te hare raa ku matahua, ia ku oti hoki te tukutuku hakaraoi. ");
INSERT INTO nuq_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tena te tipua raa e me ki haere no hakattaki ake e hitu na tipua e sakkino roo i aruna aia, tena laatou e me ki oo no uru i roto te tama raa. Te saaita na tipua raa ku oti te uru hakaatoa, te tama naa e me ki haeo roo, ia ku raka hoki ma te saaita i mua raa.” ");
INSERT INTO nuq_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisas e tattara no oti, tena he hine i roto te kanohenua raa ku meake Jisas ma, “Te hine ni haanau, tena ki rorohi Akoe raa e me ki hakatapu ria roo peehee!” ");
INSERT INTO nuq_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kito Jisas ki meake, “Kaa na tama e llono na tattara TeAtua raa, tena ki tauttari na tattara raa e me ki hakatapu ria roo peehee?” ");
INSERT INTO nuq_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Te kanohenua raa e muimui ake Jisas, tena Jisas ki meake, “Na tama te aho nei raa ni tama roo e haeo! Na tama raa e kainno mai ma Anau ki huri ake he mirakol, e meia Anau se lavaa te huri ake he mirakol, te mirakol koi profet Jona raa e me ki akoako ake laatou. ");
INSERT INTO nuq_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","E me ki ssau koi, profet Jona ko te hakkatu na tama Ninive, tena te Tamariki te Tama nei ko te hakkatu na tama te aho nei. ");
INSERT INTO nuq_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","I te Aho te Hakatonutonu raa te tuku hine i Seba raa e me ki tuu i aruna no hai ake na tama te aho nei raa na sara laatou raa, maitaname aia ni horau mai roo i te kina e mmao ma ki hakarono na tattara mattonu te Tuku Solomon raa. Tena Anau e me ki meatu pera ma e isi te mee i te kina nei e hakanaaniu roo i aruna Solomon. ");
INSERT INTO nuq_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“I te Aho te Hakatonutonu raa, na tama i Ninive raa e me ki mahhike i aruna no hai atu na ssara kootou raa, maitaname laatou ni ttike i taha ma na hai sara laatou raa te saaita laatou ni llono na takutaku Jona raa; ia tena Anau e meatu kootou pera ma e isi te mee i te kina nei e hakanaaniu roo i aruna Jona! ");
INSERT INTO nuq_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Se hai tama e hakaura te lamu, tena ku uhi te lamu raa, ia ma ku tuku te lamu raa i raro te kumete. Emeia te tama raa e me ki hakapiri te lamu raa i te kina te lamu raa e tuutuu raa ki kkite na tama hakaatoa te maahina te saaita laatou e uru mai i hare raa. ");
INSERT INTO nuq_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Na karemata kootou naa e ssau pera ma ni lamu i na tinotama kootou. Te saaita na karemata kootou raa e taualleka, tena na tinotama kootou raa e maahina hakaatoa; e meia te saaita na karemata kootou raa ku haeo, tena na tinotama kootou raa ku pouri. ");
INSERT INTO nuq_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Lollohi hakamattonu i te maahina i roto akoe naa ki seai ma he pouri. ");
INSERT INTO nuq_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kame te tinotama akoe naa e maarama hakaatoa se hai kina roo e pouri, tena te tinotama akoe naa e me ki maarama hakaatoa e ssau pera ma te lamu raa e hakamaahina atu akoe ma te maahina aia raa.” ");
INSERT INTO nuq_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Te saaita Jisas ku oti roo te tattara, tena he Farisi ku haere ake no hakkoro Jisas ma ki oo laaua no kkai i te hare aia raa, tena Jisas ki haere no noho i raro ma ki kai. ");
INSERT INTO nuq_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Te Farisi raa ku oho te saaita aia ni kite ma Jisas e kai se ssoro na rima Aia raa i mua. ");
INSERT INTO nuq_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tena Jisas ki meake te Farisi raa, “Kootou na Farisi raa e ssoro koi na vahi i aho na kapu ia ma na parete kootou raa, e meia i roto roo kootou raa e pii roo na tiputipu sakkino ia ma na tiputipu se ttonu. ");
INSERT INTO nuq_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kootou ni vvare! Aiea TeAtua se pena te tinotama ia ma te anana? ");
INSERT INTO nuq_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tena kou ake hea i roto na kapu ma na parete kootou raa i na tama hakaalloha raa, tena na ora kootou raa hakaatoa e me ki matahua hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kootou na Farisi raa e me ki hakalono lihu haeo roo! Kootou e hoki ake TeAtua na hua pammee pera ma na mint raa, na rue raa ia ma alaa hua hoki, e meia kootou e ssiri ki tauttari, ia ki laoi TeAtua. Kootou e ttonu te hoki ake na mee raa i TeAtua, ia tena auu se ssiri ki ppena na mee raa. ");
INSERT INTO nuq_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kootou na Farisi raa e me ki hakalono llihu haeo roo, e mee kootou e hihhai ki nnoho na sea na tama hakananniu raa e nonnoho i roto na hare lotu na Jiu raa ia ma na tama hoki ki hakammaha kootou i na kina e kkapi na tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kootou e me ki hakalono llihu haeo roo! Kootou e ssau pera ma ni taruma se isi na hakamattino, tena na tama ku hahaere vaa aruna se illoa ma teeraa ni taruma.” ");
INSERT INTO nuq_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","He tama na tama poroporo na tuaa raa ku meake Jisas ma, “Rabai, te saaita Akoe e tattara peenei raa; Akoe e hai hoki na haeo maatou!” ");
INSERT INTO nuq_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kito Jisas ki meake, “Kootou na tama e poroporo na tuaa raa e me ki hakalono llihu hoki! Kootou e hakapiri i aruna na panaua na tama raa na mee e mmaha te amo raa, e meia kootou hokkootou se lavaa te ssora na rima kootou raa no tokonaki na tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kootou e me ki hakalono llihu haeo roo! Kootou e hakatuu na hatu taualleka raa i na taruma na profet TeAtua raa. Teenaa ko na profet na tipuna kootou raa ni taa no mmate. ");
INSERT INTO nuq_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kootou hokkootou e huri mai pera ma hea na tipuna kootou raa ni ppena raa e hakamaoni; na tama raa e taa na profet raa no mmate, tena vahao nei kootou ku hakatuu na hatu na taruma na tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Teenei hea te Atamai TeAtua raa e tattara mai ma, ‘Anau e me ki kauna na profet ia ma na tama hakataetae na tattara raa ki oo i na tama naa, tena na tama naa e me ki taa alaa tama no mmate, tena ku kou ake na hakalono llihu i alaa tama.’ ");
INSERT INTO nuq_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tena na tama te saaita nei raa e me ki hakalono llihu i te taaia ria na profet raa hakaatoa no mmate kaamata mai roo te saaita te maarama nei ni tipu ake raa, ");
INSERT INTO nuq_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","tena kaamata mai te mate Abel raa haere no tae te mate Sekaraia te tama tera ni taia ria no mate i lottonu te olta ia ma te Kina e Tapu raa. Hakamaoni na tama te tautama nei raa e me ki hakalono llihu e mee na sara nei hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kootou na tama poroporo na tuaa raa e me ki hakalono llihu haeo roo! Kootou se poroporo ake na kanohenua raa ki illoa na tiputipu TeAtua, tena kootou hokkootou se illoa na tiputipu Tama raa, ia kootou e ppui hoki na tama tera e hai na mahi laatou ma ki illoa raa.” ");
INSERT INTO nuq_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jisas ku tiaki te matakaina raa no haere, tena na tama poroporo na tuaa ia ma na Farisi raa ku kaamata no tamoa haeo Jisas, tena ki vahihhiri ake Tama raa tammaki na mee, ");
INSERT INTO nuq_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ma ki lave laatou he mee e sara i na tattara Tama raa, tena ma laatou ku hakapiki Tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tammaki roo na simata na tama e muimui ake iaa Jisas, tena na tama raa e haere lakalaka koi na vae alaa tama. Jisas e meake kaamata na disaipol Aia raa ma, “Lollohi hakamattonu i na ist na Farisi raa. Anau e tattara atu i na tattara uhiuhi na tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Hea e huuna ria e me ki huri ake, tena na hakataakoto na tama e hai hemuu raa e me ki laavea ria. ");
INSERT INTO nuq_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ni tattara peehee kootou e tattara hemuu i te poo, tena na tama hakaatoa e me ki llono na tattara naa i te ao, ia hea kootou e ppisi hemuu i roto na hare kootou te saaita na totoka raa e ppui raa; na tama e me ki tattara iho hakamaroa na tattara naa i aruna na tauhuhu na hare. ");
INSERT INTO nuq_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Anau e meatu kootou Aku taina, kootou ki se mattaku na tama tera e taa koi te tinotama raa no mate, tena i muri ku se lavaa te ppena teeraa mee e haeo roo i aruna ma hea laatou ni ppena raa. ");
INSERT INTO nuq_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Anau e me ki huri atu te tama kootou e me ki mattaku aa: kootou ki mattaku TeAtua, te Tama e lavaa te taa te tama ki mate, tena i muri ku lletu te tama raa i roto te ahi e ura tahi. Kootou ki hakattina Anau, teenei ko te Tama kootou e tau te mattaku! ");
INSERT INTO nuq_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Eaa, e rima na rupe kame se lavaa te sui e rua na sileni? Emeia TeAtua se lavaa te ssiri he rupe hokotahi. ");
INSERT INTO nuq_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Tena na rouru na pohouru kootou raa hakaatoa ku oti te ppau ria. Ia tena kootou ki se mattaku, e mee kootou e hakananniu roo i aruna tammaki na rupe. ");
INSERT INTO nuq_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Anau e meatu kootou te hakamaoni pera ma koai te tama e tattara i na kina e tammaki na tama ma aia he tama e tautari Anau, tena te Tamariki te Tama nei e me ki ppena peeraa hoki i mua na ensel TeAtua raa. ");
INSERT INTO nuq_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Emeia na tama e tattara i na kina e tammaki na tama ma laatou se hihhai Anau raa; te Tamariki te Tama nei e me ki tattara i te se hihai Aia i na tama raa hoki i mua na ensel TeAtua raa. ");
INSERT INTO nuq_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Te tama e ppehi te tattara haeo i te Tamariki te Tama nei raa, TeAtua e lavaa te ssirihia te sara te tama naa, e meia na tama e hai na haeo TeAnana Tapu raa, tena TeAtua se lavaa roo te ssirihia te sara na tama naa. ");
INSERT INTO nuq_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Kame ni tama e too kootou no kkave i na hare lotu na Jiu raa ma na tama hakananniu ia ma na tama hakamattua raa ki lahulahu kootou, tena kootou ki se mamannatu tammaki ma kootou e me ki tattara peehee ki tokonaki kootou. ");
INSERT INTO nuq_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","E mee TeAnana Tapu raa e me ki poroporo atu kootou na tattara tera kootou e me ki tattara raa.” ");
INSERT INTO nuq_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Teeraa he tama i roto te kanohenua raa e meake Jisas ma, “Rabai, meake te taina anau raa ki vvae ma maaua na hekau te tamana maaua raa.” ");
INSERT INTO nuq_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tena Jisas ki meake te tama raa, “Koai te tama e kou mai na mahi Anau ki vvae i lottonu ma koorua na hekau te tamana koorua raa?” ");
INSERT INTO nuq_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kito Jisas ki meake na tama raa hakaatoa ma, “Lollohi hakamattonu, ka oti kootou ku mannako na mee hakaatoa, maitaname na ora hakamaoni kootou raa se mmoe i roto na mee kootou e ttino raa, niaina ma kootou e hai hekau peehee.” ");
INSERT INTO nuq_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tena Jisas ki tattara ake te tattara hurihuri nei, “Teeraa he tama e isi tammaki na kerekere tera e hhomo tammaki na kai taualleka. ");
INSERT INTO nuq_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tena te tama raa ku noho no mamaanatu hokoia ma, ‘Anau se isi te hare ki hakatau na kai anau nei hakaatoa. Hea anau e me ki ppena?’ ");
INSERT INTO nuq_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Te tama raa e tattara hokoia ma, ‘Anau e iroa hea anau e me ki ppena. Anau e me ki seu na hare pammee e hakatautau na kai raa, tena ku hakatuu ni hare e llahi ki hakatautau na kai ia ma alaa mee hoki. ");
INSERT INTO nuq_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tena anau ku tattara hokonnau ma anau ku isi na mee hakaatoa! Anau ku isi tammaki na mee tera e me ki mmoe tammaki na hetau. Anau e me ki noho koi no kai, unu, tena ku hihia!’ ");
INSERT INTO nuq_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Emeia TeAtua e meake te tama raa ma, ‘Akoe he vvare roo! Te poo nei koi akoe e me ki mate, tena kaa koai te tama e me ki too na mee roo hakaatoa akoe e hakatautau ma akoe raa?’ ” ");
INSERT INTO nuq_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tena Jisas ki hakaoti ake ma, “Teenei hea e me ki kapihi ake i te tama e hakatautau ma ki tammaki aia na mee raa, e meia aia e tutuu haeo roo i na karemata TeAtua.” ");
INSERT INTO nuq_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tena Jisas ki meake na disaipol Aia raa, “Tena Anau e meatu kootou ki se mamannatu tammaki na kai kootou e me ki kkai ki ora kootou raa ia ma na hekau kootou e me ki leulleu raa. ");
INSERT INTO nuq_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Te ora te tama e hakamaatua i aruna na kai, tena te tinotama raa e hakamaatua i aruna na hekau. ");
INSERT INTO nuq_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kira ake na lakia raa: na manu raa se ttori na kai, ia se hakatautau na kai, na manu raa se isi na hare hakatautau na kai; TeAtua e haanai na manu raa! Na ora kootou raa e hakananniu roo i aruna na manu raa. ");
INSERT INTO nuq_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","E isi te tama e lavaa te hakanuu te ora aia raa no roroa kame aia e mamaanatu tammaki te ora aia? ");
INSERT INTO nuq_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kootou se lavaa roo te ppena na mee e hainauhie raia, kootou ki mamannatu tammaki alaa mee hoki? ");
INSERT INTO nuq_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kootou ki kira ake na kaute e hhomo huri raa: na kaute raa se uata, ia se ppena na hekau laatou hokolaatou. Emeia Anau e meatu pera ma na hekau te Tuku Solomon raa ia ma na hekau aia raa hakaatoa se isi na hekau e hai lakkei taualleka roo pera ma na kaute nei. ");
INSERT INTO nuq_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","TeAtua ko te Tama e hakalaakei na kaute raa. Na kaute raa e hura ake te aho nei koi, tena taiao ku seai, ku vvela ria i roto te ahi. Aiea kaa TeAtua se lavaa hoki te kou atu ni hekau ma kootou? Na hakattina kootou raa e pammee roo! ");
INSERT INTO nuq_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Tena kootou ki se mamannatu tammaki ma hea kootou e me ki kkai ia ma hea kootou e me ki unu raa. ");
INSERT INTO nuq_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","E mee na tama e nnoho pouri te maarama nei raa e mamannatu tahi na mee nei. Te Tamana kootou raa e iroa pera ma kootou e hihhai na mee nei. ");
INSERT INTO nuq_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Emeia kootou ki mamannatu tahi i te Hakamaatua ana i te Vaelani raa, tena Aia e me ki kou atu na mee nei hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kootou ki se mattaku, niaina ma kootou e moisi, maitaname TeAtua e hihai ki kou atu te Hakamaatua ana Aia raa ma kootou. ");
INSERT INTO nuq_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kou ake na hekau kootou raa ki ssui alaa tama, tena ku too na sileni raa no kou ake i na tama hakaalloha raa. Too na muri kopu e ponopono na sileni e mmau raa no hakatau na mee hakaatoa e taualleka kootou raa i te vaelani, i te kina na mee raa se lavaa roo te haere moisi, e mee na tama kailallao raa se lavaa te ttae no too na mee raa, tena na lollona raa hoki se lavaa te kkai na mee raa. ");
INSERT INTO nuq_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","E mee na hakataakoto kootou raa e me ki mmoe tahi koi i te kina na hekau kootou raa e mmoe. ");
INSERT INTO nuq_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Kootou ki tanattana i na mee tera e me ki oo mai raa, ia uruuru hakaoti na hekau kootou raa ki ppuhu, tena ku hakaura na lamu kootou raa ki ura ");
INSERT INTO nuq_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","pera ma na tama hehekau raa e nnoho no hakattari te tama hakamaatua raa ki vaakai mai i te kai te avana aia ni haere raa. Te tama raa e hamai koi no papaku te totoka raa, tena na tama raa ku taaraki vave koi te totoka raa. ");
INSERT INTO nuq_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Na tama hehekau raa e me ki hihhia roo te saaita te tama hakamaatua raa e vaakai mai no kite ma laatou e ara koi! Anau e meatu te hakamaoni pera ma te tama raa e me ki ui te kaukahu mattoru aia raa, tena ku meake na tama raa ki nnoho i raro, tena aia ku kou ake na kai na tama raa ki kkai. ");
INSERT INTO nuq_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Na tama raa e me ki hihhia roo kame te tama hakamaatua raa e hamai no kite ma laatou e tanattana, niaina te tama raa e hamai te tuapoo ia ma i muri te tuapoo. ");
INSERT INTO nuq_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tena kootou e lavaa te illoa pera ma kame te tama hakamaatua te hare raa e iroa te saaita te tama kairarao raa e me ki haere ake, te tama naa e me ki se lavaa te tiaki te tama kairarao raa ki uru ake i te hare aia raa. ");
INSERT INTO nuq_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ia tena kootou ki tanattana peeraa hoki, maitaname te Tamariki te Tama nei e me ki vaakai mai te saaita kootou se tanattana ma Aia e me ki vaakai mai raa.” ");
INSERT INTO nuq_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tena Pita ki meake, “TeAriki, te tattara hurihuri nei, e tattara koi maatou ma Akoe e tattara na tama roo hakaatoa?” ");
INSERT INTO nuq_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kito Jisas ki meake, “Kaa koai te tama hakamaoni i na hehekau aia tera e atamai naa? Teenaa ko te tama tera te tama hakamaatua raa e tuku ki hakamaatua, ki mmata na mee hakaatoa i roto te hare, tena ku vaevae ake na kai na tama hehekau raa na saaita hakaatoa e kkai raa. ");
INSERT INTO nuq_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Te tama hehekau naa e me ki hihia roo kame te tama hakamaatua raa e vaakai mai i hare no kite ma aia e ppena na uata aia raa! ");
INSERT INTO nuq_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Hakamaoni roo, Anau e meatu kootou, te tama hakamaatua raa e me ki tuku te tama raa ki hakamaatua na mee roo hakaatoa aia e ttino raa. ");
INSERT INTO nuq_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Emeia kame te tama hehekau naa e hakataakoto hokoia pera ma te tama hakamaatua raa e me ki nnahe roo te vaakai mai, tena aia ku kaamata no riki alaa taanata ia ma na hhine hehekau raa, tena ku tauhano te kai, ia e unu tahi no vvare, ");
INSERT INTO nuq_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","tena te tama hakamaatua raa ku vaakai mai i te aho te tama hehekau raa se iroa ma te tama hakamaatua raa e me ki vaakai mai raa. Tena te tama hakamaatua raa e me ki tuutuu maruu te tinotama te tama raa no lletu i aho ki iroa te tama raa pera ma aia se hakarono na tattara. ");
INSERT INTO nuq_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Te tama hehekau e iroa hea te tama hakamaatua aia raa e hihai aia ki ppena raa, e meia aia se tanattana ki pena te mee raa, tena te tama naa e me ki riki ria hakahaeo roo. ");
INSERT INTO nuq_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Emeia te tama hehekau tera se iroa hea te tama hakamaatua raa e hihai aia ki ppena raa, e pena te mee e sara tera e tau aia te hakalono llihu, tena te tama naa se lavaa te riki ria hakahaeo roo. Ia na tama e me ki kainno ake tammaki na mee i te tamae too tammaki na mee raa, ia hoki na tama e me ka kainno ake tammaki roo na mee i te tama e too tammaki roo na mee raa.” ");
INSERT INTO nuq_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Tena Jisas ki meake, “Anau e hamai no hakaura te maarama nei ki ura, tena Anau e hihai roo kame te ahi raa ku oti te kaamata ki ura. ");
INSERT INTO nuq_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Anau e isi te hakoukou tapu e me ki too, tena te hakalono llihu i roto Anau nei e me ki moe roo ki oti te mee nei! ");
INSERT INTO nuq_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Kootou e kkahu ma Anau e hamai ki tokonaki te maarama nei ki nonnoho laoi? Seai, Anau se hamai ma te noho laoi, e meia Anau e hamai ki vaevae. ");
INSERT INTO nuq_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tokorima na tama i roto te hai matua hokotahi e me ki nonnoho haeo hokolaatou, tena tokotoru na tama e me ki nonnoho haeo ma teeraa tokorua na tama, tena tokorua na tama e me ki nonnoho haeo ma teeraa tokotoru. ");
INSERT INTO nuq_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Na tamana e me ki nonnoho haeo ma na tama tane laatou, tena na tama tane raa e me ki nonnoho haeo ma na tamana laatou raa. Na tinna e me ki nonnoho haeo ma na tama hhine laatou raa, tena na tama hhine raa e me ki nonnoho haeo ma na tinna laatou. Na hinaona hhine e me ki nonnoho haeo ma na hinaona laatou, tena na tama hhine raa e me ki nonnoho haeo ma na hinaona hhine laatou raa.” ");
INSERT INTO nuq_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kito Jisas ki tattara ake hoki te kanohenua raa ma, “Te saaita kootou e kkite te pukureurehu e hamai i te laki, tena kootou e me ki tattara ma te mee raa e me ki lleku, tena te mee raa ku lleku hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ia te saaita kootou e kkite ma te matani raa ku aniani mai i te kupu, tena kootou e me ki tattara ma te mee raa e me ki vvela, tena te mee raa ku vvela hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kootou ni tama e tattara uhiuhi! Kootou e lavaa te kira ake te vaelani raa, tena ku mannatu ma te mee raa e me ki tauareka ma e mee ki haeo. Kaa kootou se illoa peehee na hakkatu na mee e huri atu vahao nei raa? ");
INSERT INTO nuq_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Aiea kootou se hakatonutonu hokkootou na mee e tonu kootou e tau te ppena raea? ");
INSERT INTO nuq_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kame he tama e ppono akoe i te kot e mee akoe e seu te tuaa, tena akoe ki haere no tattara hakaraoi koorua i mua koorua e oo i te kot. Kame akoe se haere no tattara hakaraoi koorua, tena akoe e me ki huutia ria i mua na tama te kot raa, tena na tama raa e me ki kou ake akoe i na rima na polis raa ki ppono i roto te hare karapusi. ");
INSERT INTO nuq_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tena Anau e meatu, akoe e me ki noho i roto te hare karapusi raa ki tae roo te saaita akoe e ppehi te paini akoe raa hakaatoa.” ");
INSERT INTO nuq_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Te saaita naa e isi na tama i te kina raa e oo ake no meake Jisas i te vahi na tama i Galili tera Pailat ni taa no mmate te saaita na tama raa ni hoki ake na hoki laatou i TeAtua raa. ");
INSERT INTO nuq_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tena Jisas ki meake na tama raa, “E mee na tama i Galili raa ni taaia ria no mmate peeraa, tena kootou ku mannatu ma te mee raa e huri ake te hakamaoni pera ma na hai sara na tama raa e raka i aruna ma alaa tama i roto Galili? ");
INSERT INTO nuq_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Seai! Tena Anau e meatu pera ma kame kootou se ttike i taha ma na hai sara kootou, tena kootou e me ki mmate peeraa hoki ");
INSERT INTO nuq_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kaa te sanahuru ma varu na tama i Siloam tera ni mmate te saaita te hare palluna raa ni teiho no taaona laatou raa? Kootou e mannatu ma te mmate na tama raa e huri ake pera ma na tama raa e pii na hai sara e raka i aruna ma na tama e nnoho i Jerusalem raa? ");
INSERT INTO nuq_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Seai! Tena Anau e meatu, kame kootou se ttike i taha ma hai sara kootou, tena kootou e me ki mmate peeraa hoki.” ");
INSERT INTO nuq_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kito Jisas ki tattara ake na tama raa te tattara hurihuri nei, “Teeraa he tama e isi te laakau fik e homo i roto te paupaku aia. Tama raa e haere ake no mmata ma te laakau raa e isi na hua e mmau, e meia aia se hai hua e kite. ");
INSERT INTO nuq_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kito te tama raa ki meake te tama e rorohi te paupaku raa, ‘Kira ake! E toru roo na hetau anau e hamai no matamata ma e isi na hua e mmau te laakau nei, e meia anau se hai hua e kite. Tena tuu te laakau nei i raro. Aiea te laakau nei ki tiaki roo ki tuu no kai na kai i roto te kerekere?’ ");
INSERT INTO nuq_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tena te tama e rorohi te paupaku raa ki meake, ‘Te tama hakamaatua, tiaki te laakau naa ki tuu he hetau hokotahi, tena anau e me ki mmuru ni muruna no uhi hakatike te purapura te laakau naa. ");
INSERT INTO nuq_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tena kame te hetau i muri raa te laakau nei ku hua, tena ku tauareka, kaa seai, tena akoe ku ttuu te laakau nei ki hina.’ ” ");
INSERT INTO nuq_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jisas e akoako i roto te hare lotu raa i te aho te Sabat. ");
INSERT INTO nuq_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tena he hine i roto te matakaina raa e isi te tipua sakkino e mee te hine raa no lalavea i roto sanahuru ma varu na hetau; te hine raa ku hahaere piko roo, ia tena ku se lavaa roo te tuu tonu. ");
INSERT INTO nuq_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisas e kite te hine raa, tena Aia ki kanna ake ma, “Taku tama, akoe ku tauareka ma te maahana akoe naa.” ");
INSERT INTO nuq_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kito Jisas ki hakapiri na rima Aia raa i aruna te hine raa, tena te saaita naa koi te hine raa ku hamatakkau hokoia koi no tuu tonu, tena ki hakammaha ake TeAtua. ");
INSERT INTO nuq_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tena te tama hakamaatua te hare lotu na Jiu raa ku roto e mee Jisas e tokonaki te hine raa no tauareka i te aho te Sabat raa, kito te tama hakamaatua raa ki tattara ake te kanohenua raa ma, “Taatou e isi e ono na aho ki hehekau, tena kootou ki oo mai i roto na aho naa ki tokonaki ria kootou ki taualleka. Kootou se lavaa te oo mai te aho te Sabat.” ");
INSERT INTO nuq_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tena TeAriki ki meake, “Kootou e tattara uhiuhi koi. Kootou e nnoho mai naa e me ki vvete koi na manu kootou raa no hakattaki i taha ma na paa hare laatou raa no haunu na vai i te aho te Sabat. ");
INSERT INTO nuq_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ia te hine nei he mokopuna Abraham tera Satan ni haihai no karapusi i roto sanahuru ma varu na hetau. Eaa kaa te hine nei ku se lavaa roo te tokonaki ria ki tauareka i te aho te Sabat nei?” ");
INSERT INTO nuq_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Na tattara Aia raa e mee na tama e kiri lloto Aia raa no nnapa hokolaatou, tena te kanohenua raa ku hihhia roo i na mee taualleka Jisas e ppena raa. ");
INSERT INTO nuq_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tena Jisas ki meake, “Te Hakamaatua ana i te Vaelani raa e tipu peehee? He mee peehee Anau e lavaa te hakapaa tera e ssau ma te Hakamaatua ana i te Vaelani raa? ");
INSERT INTO nuq_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Te Hakamaatua ana i te Vaelani raa e ssau pera ma te hua te mastet te tama e ttori i roto te paupaku aia raa. Te hua raa e homo no rahi roo, tena na manu raa ku ppena na hohana laatou raa i aruna te laakau raa.” ");
INSERT INTO nuq_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Tena Jisas ki vahiri ake hakaraoi, “He mee peehee Anau e lavaa te hakapaa tera e ssau ma te Hakamaatua ana i te Vaelani raa? ");
INSERT INTO nuq_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Te Hakamaatua ana i te Vaelani raa e ssau pera ma te ist te hine raa e hilo i roto na haraoa, tena ki hakamoe te haraoa raa no hhuta.” ");
INSERT INTO nuq_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisas e tuui sara pera i Jerusalem no haere vaa roto na matakaina e llahi ia ma na matakaina pammee raa no takutaku ake na kanohenua raa. ");
INSERT INTO nuq_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","E isi te tama e vahiri ake Jisas ma, “TeAriki, na tama e me ki tokonaki ria ki ora raa e moisi koi?” Kito Jisas ki meake na tama raa ma, ");
INSERT INTO nuq_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Hai na mahi kootou ki lavaa kootou te uru i roto te totoka e kkao raa; maitaname tammaki na tama e me ki hahaivi ki uru i roto hare, e meia laatou e me ki se lavaa. ");
INSERT INTO nuq_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Te tama hakamaatua te hare raa e me ki mahike no ppui te totoka raa, tena te saaita kootou e ttuu i aho no papaku te totoka raa, tena ku tattara ake ma, ‘TeAriki, taaraki te totoka raa ki uru atu maatou!’ Tena te Tama raa e me ki meatu ma, ‘Anau se iroa kootou e oo mai i hee!’ ");
INSERT INTO nuq_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tena kootou e me ki meake ma, ‘Maatou e kkai, ia e unu ma Akoe. Akoe ni akoako mai maatou i roto na matakaina maatou raa.’ ");
INSERT INTO nuq_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Emeia te Tama raa e me ki meatu hoki ma, ‘Anau se iroa kootou e oo mai i hee. Oo i taha ma Anau, kootou hakaatoa ni tama e hai ssara.’ ");
INSERT INTO nuq_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Kootou e me ki tanittani no hakati kkati na niho kootou raa te saaita kootou e kkite Abraham, Aisak, Jekop ia ma na profet hakaatoa tera e nnoho i roto te Hakamaatua ana i te Vaelani raa te saaita kootou e me ki lettua ria i aho raa. ");
INSERT INTO nuq_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Na tama e me ki oo mai i te vahi te anake ia ma te laki, i te vahi tokorau ia ma te kupu. Na tama raa e me ki nnoho i roto te Hakamaatua ana i te Vaelani raa no kkai. ");
INSERT INTO nuq_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Na tama e hakammuri te saaita nei raa e me ki tuu i mua, tena na tama e ttuu i mua te saaita nei raa e me ki hakammuri.” ");
INSERT INTO nuq_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Te saaita naa hoki e isi na Farisi e oo ake no meake Jisas ma, “Akoe ki haere i taha ma te kina nei no haere teeraa matakaina, maitaname Herot e hihai ki taa Akoe ki mate.” ");
INSERT INTO nuq_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tena Jisas ki meake na tama raa, “Oo no meake te manu kai tama naa: ‘Anau e hakaise na tipua i taha, tena ku tokonaki na tama lavvea raa te aho nei ma taiao, tena te aho tana hakatoru raa Anau e me ki hakaoti na uata Anau nei.’ ");
INSERT INTO nuq_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tena te aho nei, taiao ia ma teeraa aho; Anau e me ki tuui sara peeraa i Jerusalem, maitaname se tonu ma na profet raa ki mmate i alaa kina, na tama raa e me ki mmate i Jerusalem koi. ");
INSERT INTO nuq_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem, Jerusalem! Kootou e taa na profet raa no mmate, tena kootou e maka na tama TeAtua ni kauna ria atu ma na tattara Aia raa! E hia roo na vahao Anau e hihai ki hakkutu mai kootou, e ssau pera ma na manu hine raa e hakkutu mai na pupunua aia raa i raro na pakau aia raa. Emeia kootou se hihhai ma Anau ki tokonaki kootou! ");
INSERT INTO nuq_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tena te hare lotu kootou naa e me ki tuu se hai tama. Anau e meatu kootou te hakamaoni pera ma kootou se lavaa te kkite Anau ki tae roo te saaita kootou e tattara ma, ‘TeAtua e hakatapu te Tama tera ni hamai i te inoa TeAriki raa.’ ” ");
INSERT INTO nuq_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","He Sabat hokotahi Jisas e haere ma ki haere no kai i te hare te tama hakamaatua na Farisi raa, tena na tama raa ku matamata hemuu iaa Jisas. ");
INSERT INTO nuq_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tena he tama ku haere ake iaa Jisas raa; na vae ia ma na rima aia raa e ssura hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kito Jisas ki meake na Farisi ia ma na tama e poroporo na tuaa raa ma, “Na tuaa taatou raa e hakattana taatou ki tokonaki te tama i te aho te Sabat ma seai?” ");
INSERT INTO nuq_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Emeia na tama raa e nnoho hemuu se hai tattara roo e meake. Tena Jisas ki too te tama raa no tokonaki no tauareka, tena Aia ki kauna te tama raa no haere. ");
INSERT INTO nuq_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kito Jisas ki meake, “Kame he tama kootou e isi te tamariki, seai naa he manu e teiho i roto te rua e nnoto i te aho te Sabat; eaa akoe kame se lavaa te arato ake te tamariki seai naa te manu raa i aruna i te aho te Sabat raa?” ");
INSERT INTO nuq_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tena na tama raa ku se lavaa te sui muri ake te vahiri Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisas e kite pera ma na tama e oo ake i te kai raa e hirihiri ki nnoho na kina na tama hakananniu e nonnoho raa, kito Jisas ki tattara ake na tama raa te tattara hurihuri nei. ");
INSERT INTO nuq_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kame he tama e aru atu akoe ki haere ake i te kai te avana, tena auu se haere no noho i te kina na tama hakananniu raa e nonnoho raa, ka oti te tama hakamaatua te kai raa e isi hoki te tama ni aru tera e hakanaaniu i aruna akoe, ");
INSERT INTO nuq_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","tena te tama tera ni aru atu koorua hakaatoa raa ku haere atu no meatu akoe ma, ‘Mahike ki noho te tama nei’, tena akoe e me ki napa no haere no noho i muri roo. ");
INSERT INTO nuq_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Emeia kame akoe e aruhia ki haere ake i te kai, tena haere koi no noho i te kina i muri raa, tena te tama hakamaatua raa e me ki kite, tena ku haere atu no meatu akoe ma, ‘Na soa, hamai i mua no noho he kina tauareka raa.’ Tena na tama hakaatoa i te kina te kai raa e me ki kkite pera ma te tama hakamaatua te kai raa e hakammaha akoe. ");
INSERT INTO nuq_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Na tama e mee hokolaatou no hakananniu raa, e me ki tuku iho no mouraro, tena na tama e mee hokolaatou no mouraro raa e me ki ssau ria no hakananniu.” ");
INSERT INTO nuq_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kito Jisas ki meake te tama ni aru ake Aia raa, “Te saaita akoe e me ki tanattana na kai raa, tena auu se aru na soa akoe raa, na taina akoe raa, na hareakina akoe raa ia ma na tama tera e hai hekau raa roo, e mee i muri na tama naa e me ki aru atu hoki akoe ki sui muri hea akoe ni ppena raa. ");
INSERT INTO nuq_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Te saaita akoe e tanattana te kai, tena ku aru na tama hakaalloha raa, na tama tottoro raa, na tama na vae e mmate raa ia ma na tama karemata sseni raa; ");
INSERT INTO nuq_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","tena akoe e me ki hakatapu ria, maitaname na tama raa se lavaa te sui muri atu akoe. TeAtua e me ki sui muri atu akoe te saaita na tama e ttonu tahi raa e me ki mahike muri i taha ma te mate.” ");
INSERT INTO nuq_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tena he tama e noho i te kina raa no kkai laatou ma Jisas e rono na tattara Jisas raa, tena aia ki meake, “Na tama e me ki kkai te kai e rahi i te Hakamaatua ana i te Vaelani raa e me ki hakatapu ria.” ");
INSERT INTO nuq_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tena Jisas ki meake te tama raa, “Teeraa he tama e tanattana te kai e rahi, tena aia ki aru tammaki roo na tama. ");
INSERT INTO nuq_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Te saaita te kai raa ku tanattana, tena te tama raa ku kauna te tama hehekau aia raa ki haere no meake na tama aia ni aru raa ma, ‘Oo mai, na mee hakaatoa ku tanattana!’ ");
INSERT INTO nuq_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tena na tama raa ku kaamata no tattara hakameemee. Te tama kaamata raa e meake te tama hehekau raa ma, ‘Anau e sui te paupaku vahao nei koi, tena anau e me ki haere no mmata te paupaku raa. Kaaroha, anau e kapitia.’ ");
INSERT INTO nuq_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Tena teeraa tama ki meake, ‘Anau e sui sanahuru na bulmakau, ia tena anau e me ki haere no haaite na manu nei. Kaaroha roo, anau e kapitia.’ ");
INSERT INTO nuq_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tena teeraa tama hoki ku meake, ‘Anau e avana vahao nei koi tera hea anau ku se lavaa te haere atu.’ ");
INSERT INTO nuq_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Tena te tama hehekau raa ki vaakai no meake te tama hakamaatua aia raa. Tena te tama hakamaatua raa ku roto roo, tena ki meake, ‘Haere vave vaa roto na mateara te matakaina nei raa, tena ku hakkoro mai na tama hakaalloha raa, na tama tottoro raa, na tama karemata sseni raa ia ma na tama na vae e mmate raa ki oo mai.’ ");
INSERT INTO nuq_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tena te tama hehekau raa ki meake, ‘Te tama hakamaatua, anau ku oti te ppena na mee hakaatoa tera akoe ni mee mai anau ki ppena raa, e meia te hare nei koi ttana koi.’ ");
INSERT INTO nuq_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tena kito te tama hakamaatua raa ki meake te tama hehekau raa, ‘Haere i na mateara vaa roto raa no meake na tama raa ki oo mai ki kkapi roo te hare anau nei. ");
INSERT INTO nuq_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Anau e meatu kootou hakaatoa pera ma se hai tama na tama anau ni aru kaamata raa e me ki hakammata na kai anau nei.’ ” ");
INSERT INTO nuq_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tammaki na tama e hahaere ma Jisas, tena Jisas ki hakatike no tattara ake na tama raa, ");
INSERT INTO nuq_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Te tama se tau te mee pera ma he disaipol Anau kame te laoi aia i na maatua aia raa, i te avana ia ma na tamalliki aia raa, i na taina ia ma na kaave aia raa ia ma te ora aia raa e raka i aruna ma te laoi aia Anau raa. ");
INSERT INTO nuq_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Na tama se amo na kros laatou no tauttari mai Anau raa se lavaa te mee pera ma ni disaipol Anau. ");
INSERT INTO nuq_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Kame he tama e hihai ki pena he hare palluna, te tama naa e me ki noho kaamata no mamaanatu te kooina te sui te hare naa ki mmata ma na sileni aia raa e llava te sui te hare naa hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kame akoe se noho no maanatu hakaraoi, akoe e me ki hakatuu koi na pou raa, tena ku se lavaa hoki te hakaoti te hare naa, tena na tama e kkite te hare se oti naa e me ki tataussua akoe. ");
INSERT INTO nuq_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Na tama raa e me ki meatu, ‘Akoe e kaamata no pena te hare raa, tena ku se lavaa koi te hakaoti!’ ");
INSERT INTO nuq_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Kame he tuku e haere ma sanahuru na simata na tama ma ki ppuhu ma te tuku tera e hamai ma tipu rua na simata na tama raa, tena te tuku raa e me ki noho kaamata no mamaanatu ma aia e lavaa te ppuhu ma teeraa tuku ma seai. ");
INSERT INTO nuq_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kame aia e maanatu ma aia se tau, tena te tuku raa e me ki kkave te tattara i teeraa tuku ma laaua ki tattara hakaraoi te saaita te tuku raa koi mmao.” ");
INSERT INTO nuq_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Tena Jisas ki hakaoti ake ma, “Kootou e ssau peeraa hoki. Kootou se lavaa te mee pera ma ni disaipol Anau kame kootou se tiaki na mee hakaatoa kootou e isi raa. ");
INSERT INTO nuq_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Te sol raa e tauareka, e meia te saaita te sol raa ku se mmara, taatou ku se lavaa hoki te mee te sol raa ki mmara hakaraoi. ");
INSERT INTO nuq_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Te sol raa ku haeo, ia se lavaa hoki te mee pera ma ni muruna, tena te sol raa ku tau koi te peesia. Tena hakallono kame kootou e isi na katarina.” ");
INSERT INTO nuq_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Teeraa he aho, e tammaki na tama e aoao na takis ia ma na tama hai ssara e oo ake ma ki hakallono na tattara Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tena na Farisi ia ma na tama poroporo na tuaa raa ku tamumu ma, “Tama nei e hihai na tama hai ssara, ia e kaikkai hoki ma na tama raa.” ");
INSERT INTO nuq_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kito Jisas ki tattara ake na tama raa te tattara hurihuri nei: ");
INSERT INTO nuq_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Kame he tama kootou e isi huitarau na sipsip, tena he sipsip hokotahi ku rano. Hea akoe e me ki pena? Akoe e me ki tiaki na sipsip tipu sivo ma sivo raa ki kaikkai, tena akoe e me ki haere no sesee te sipsip hokotahi e rano raa te saaita roo akoe e lave te manu raa. ");
INSERT INTO nuq_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Te saaita akoe ku lave te sipsip raa, akoe e me ki hihia roo no hakapiri te sipsip raa i te panaua akoe ");
INSERT INTO nuq_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","no amo i hare. Tena akoe e me ki kanna ake na soa akoe ia ma na tama e illoa akoe raa hakaatoa, tena ku tattara ake na tama raa ma, ‘Anau e hihia roo e mee anau ku lave te sipsip anau ni rano raa. Oo mai taatou ki hihhia hakaatoa!’ ");
INSERT INTO nuq_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Anau e meatu kootou pera ma e me ki ssau peeraa hoki, kame he tama hokotahi e tike i taha ma na hai sara aia, na ensel i te vaelani raa e me ki hihhia roo, e raka i aruna ma te tipu sivo ma sivo na tama e ttonu tahi tera se tau te ttike i taha ma na hai sara laatou raa. ");
INSERT INTO nuq_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Kame he hine e isi sanahuru na siliva, tena he siliva hokotahi ku rano. Hea te hine raa e me ki pena? Te hine raa e me ki hakaura te lamu raa no verevere te hare raa, tena ku sesee hakaraoi roo na kina hakaatoa ki lave roo aia te siliva raa. ");
INSERT INTO nuq_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Te saaita aia e lave te siliva raa, te hine raa e me ki kanna ake na soa ia ma na tama e illoa aia raa hakaatoa, tena ku meake, ‘Anau e hihia roo e mee anau ku lave te siliva anau ni rano raa. Taatou ki hihhia hakaatoa!’ ");
INSERT INTO nuq_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Anau e meatu kootou pera ma e me ki ssau peeraa hoki, na ensel i te vaelani raa e me ki hihhia roo kame he tama hai sara hokotahi e tike i taha ma na hai sara aia.” ");
INSERT INTO nuq_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Tena Jisas ki tattara ake hoki, “Teeraa he tama e isi e rua na taupeara. ");
INSERT INTO nuq_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Taupeara paamee raa e meake te tamana aia raa ma, ‘Kou mai te tuhana anau raa vahao nei.’ Kito te tamana tokorua raa ki vvae i lottonu na hekau raa ma na taupeara e rua aia raa. ");
INSERT INTO nuq_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tena na aho i muri raa koi, te taupeara raa ku kou ake na hekau aia raa hakaatoa ki sui alaa tama, tena ki too na sileni raa no haere i taha. Aia e haere te henua e mmao roo, tena ki kaamata no tatahao puamu na sileni aia raa i na tiputipu sakkino. ");
INSERT INTO nuq_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Te taupeara raa e suisui na sileni aia raa no oti roo hakaatoa, tena te one raa ku tae ake i te henua raa, tena te taupeara raa ku se hai sileni roo e ttoe. ");
INSERT INTO nuq_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tena aia ki haere no hehekau ma he tama i te henua raa. Kito te tama raa ki kauna te taupeara raa ki haere no rorohi na piki aia raa. ");
INSERT INTO nuq_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Te taupeara raa ku maanatu ma ki kai koi na kai na piki raa e kkai raa, e mee se hai tama e kou ake ni kai ki kai aia. ");
INSERT INTO nuq_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tena te hakataakoto raa ku tere ake i te taupeara raa ma, ‘Na tama hehekau te tamana anau raa hakaatoa e kkai roo no ppohu, ia e isi koi na kai e ttoe, e meia anau ku taapiri koi ki mate taku hikai. ");
INSERT INTO nuq_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Anau e me ki mahike no haere te tamana anau raa no meake ma, “Tamana, anau ku sara roo i mua na karemata TeAtua ia ma na karemata akoe. ");
INSERT INTO nuq_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Anau ku se tau te mee pera ma he tama akoe, too anau mo tama koi hehekau akoe.” ’ ");
INSERT INTO nuq_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tena te taupeara raa ku mahike no vaakai muri i te tamana aia raa. “Te taupeara raa koi mmao roo i taha ma te hare raa te saaita te tamana aia raa ni kite aia, tena aia ku aroha roo i te taupeara aia raa, kito aia ki tere atu no avei te taupeara raa no mohoni. ");
INSERT INTO nuq_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tena te taupeara raa ki meake, ‘Taku tamana, anau ku sara roo i mua na karemata TeAtua ia ma na karemata akoe. Anau ku se tau hoki te mee pera ma he tamariki akoe.’ ");
INSERT INTO nuq_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Emeia te tamana aia raa e kanna ake na tama hehekau aia raa ma, ‘Vave! Kou mai na hekau taualleka raa no hakauru ake te tama nei. Taro ake he ring te matarima aia raa, tena ku hakauru ake ni taka i na vae aia raa. ");
INSERT INTO nuq_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Tena kootou ku oo no taa te pupunua bulmakau e rahi raa, tena taatou ku pena he kai e rahi ki hihhia taatou ma te tama nei! ");
INSERT INTO nuq_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Maitaname te tamariki anau nei ni mee raa ku mate, tena vahao nei aia ku ora muri; aia ni mee raa e rano, tena vahao nei aia ku vaakai mai.’ Tena na tama raa ku kaamata no kkai te kai raa. ");
INSERT INTO nuq_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ia te saaita naa te taupeara matua raa e noho i roto te paupaku. Tena te taupeara matua raa ku vaakai mai i hare, tena te saaita aia ku taapiri i hare raa, aia ku rono te rue ia ma na tama e llue. ");
INSERT INTO nuq_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kito aia ki kanna ake te tama hehekau aia raa no vahiri ake ma, ‘Hea na tama raa e hai raa?’ ");
INSERT INTO nuq_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kito te tama hehekau raa ki meake, ‘Te taina akoe raa ku tae mai, tena te tamana akoe raa ki taa te pupunua bulmakau e rahi raa ki kkai taatou, e mee te taina akoe raa ku tae laoi mai.’ ");
INSERT INTO nuq_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Te taupeara matua raa ku roto roo, tena aia ku se hihai ki haere i roto hare; kito te tamana aia raa ki hamai i aho no hakorokoro te taupeara matua raa ki haere ake i hare. ");
INSERT INTO nuq_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tena te taupeara raa ki meake te tamana aia raa ma, ‘Kira ake, na hetau nei hakaatoa anau e hehekau ma akoe pera ma he tama hehekau, tena anau se hai vahao roo e tattara sui na tattara akoe raa. Kaa hea akoe ni kou mai anau? Akoe se hai mee ni kou mai anau ma ki pena he kai ma na soa anau raa. ");
INSERT INTO nuq_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Emeia akoe e taa te pupunua bulmakau e rahi raa, te saaita te tama akoe e kanna ma he tamariki akoe raa ni tae mai, niaina roo ma te tama raa ni tahao puamu na sileni akoe raa i na hhine.’ ");
INSERT INTO nuq_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tena te tamana aia raa ki meake, ‘Taku tama, akoe e noho tahi ma anau, tena na mee hakaatoa anau e ttino raa ni mee akoe. ");
INSERT INTO nuq_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Emeia taatou e tau te kkai no hihhia, maitaname te taina akoe raa ni mee raa ku mate, e meia vahao nei aia ku ora muri; aia ni mee raa e rano, tena vahao nei aia ku vaakai mai.’ ” ");
INSERT INTO nuq_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kito Jisas ki meake na disaipol Aia raa, “Teeraa he tama hai sileni, tena aia e isi te tama hehekau tera e rorohi na hekau aia raa hakaatoa. Te tama hai sileni raa e rono pera ma te tama hehekau aia raa e tatahao puamu na sileni aia raa. ");
INSERT INTO nuq_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tena te tama hai sileni raa ki kanna ake te tama hehekau aia raa no vahiri ake ma, ‘Aanei ni tattara peehee anau e rono nei? Taataa mai he launiu ki iroa anau te rorohi akoe na hekau anau raa hakaatoa, maitaname akoe ku mee ki hakaoti ria.’ ");
INSERT INTO nuq_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tena te tama hehekau raa ki tattara hokoia ma, ‘Te tama hakamaatua raa ku mee ki hakaoti anau. Kaa hea anau e me ki pena? Anau ku se ivi te keri na rua, tena anau e napa hoki te kainno huri. ");
INSERT INTO nuq_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Te saaita nei anau e iroa hea anau e me ki pena! Te saaita anau ku hakaoti ria ma te uata anau raa, na soa anau raa e me ki hakkoro anau ki oo maatou i na hare laatou raa.’ ");
INSERT INTO nuq_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Tena kito te tama raa ki kanna ake na tama e isi na taoni i te tama hai sileni raa. Tama raa e vahiri ake te tama kaamata raa ma, ‘E hia na taoni akoe i te tama hakamaatua anau raa?’ ");
INSERT INTO nuq_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Kito te tama raa ki meake, ‘E varu huitarau na galon na sunu.’ Tena kito te tama hehekau raa ki meake te tama raa, ‘Teenei te launiu na taoni akoe, too tena akoe ku taataa haa huitarau na galon na sunu.’ ");
INSERT INTO nuq_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tena aia ki vahiri ake teeraa tama, ‘Kaa e hia te taoni akoe raa?’ Tena te tama raa ki meake ma, ‘Simata na kopu haraoa.’ Tena te tama hehekau raa ki meake, ‘Teenei te taoni akoe, too tena akoe ku taataa varu huitarau na kopu haraoa.’ ");
INSERT INTO nuq_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ia niaina ma te tama hehekau raa e hai laavaka, e meia te tama hakamaatua raa e hakammaha koi te tama hehekau aia raa, maitaname na tama te maarama nei raa ni tama roo e illoa te hai lavvaka na mee, e kkee roo ma na tama i te maahina raa.” ");
INSERT INTO nuq_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Kito Jisas ki tattara ake hoki ma, “Ia tena Anau e meatu kootou: tokonaki na tama e tuttuu haeo raa ma na mee taualleka i te maarama nei raa, tena te saaita na mee hakaatoa e oti raa, akoe e me ki iroa ria i te kina te ora se isi te hakaoti raa. ");
INSERT INTO nuq_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Te tama e rorohi hakatauareka na mee pammee raa e lavaa hoki te rorohi hakatauareka na mee e llahi, tena te tama se lavaa te rorohi na mee pammee raa se lavaa hoki te rorohi na mee e llahi. ");
INSERT INTO nuq_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ia tena, kame akoe se lavaa te rorohi hakatauareka na mee i te maarama nei raa, tena kaa akoe e me ki lavaa peehee te rorohi na mee hakamaoni e sui mmaha raa? ");
INSERT INTO nuq_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kame akoe se lavaa te rorohi hakatauareka hea teeraa tama e ttino raa, tena kaa koai te tama e me ki kou atu hea akoe e ttino raa? ");
INSERT INTO nuq_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Se hai tama e me ki hehekau i raro na mahi tokorua na tama hakamattua; na tama hehekau peenei raa e me ki haeo teeraa tama, tena ku laoi teeraa tama. Te tama naa e me ki hakarono teeraa tama, tena ku se lavaa te hakarono teeraa tama. Akoe se lavaa te hehekau hakamaoni TeAtua kame akoe e manako sileni.” ");
INSERT INTO nuq_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Te saaita na Farisi raa ni llono na tattara Jisas raa, na tama raa ku tataussua Tama raa, e mee laatou ni tama e hihhai sileni. ");
INSERT INTO nuq_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tena Jisas ki meake na tama raa, “Kootou ko na tama e hihhai ki mee pera ma kootou e ttonu i mua na karemata na tama hakaatoa, e meia TeAtua e iroa na hatu manava kootou. Maitaname na mee na tama e hakataakoto ma ni mee hakamaoni raa ko na mee TeAtua e mee ma ni mee vare i na karemata Aia. ");
INSERT INTO nuq_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Na tuaa Moses ia ma na tattara na profet raa e hai mmahi roo haere no tae te saaita Jon Baptis raa, tena kaamata te saaita naa maatou ku tattara tahi atu te Rono Tauareka i te Hakamaatua ana i te Vaelani raa, tena na tama hakaatoa ku hai na mahi laatou ma ki ttae i te Hakamaatua ana i te Vaelani raa. ");
INSERT INTO nuq_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Emeia e hainauhie roo ma te vaelani ia ma te maarama nei te oti, ia se lavaa he paa tattara tera e tattara i te vahi na tuaa TeAtua raa e lavaa te oti. ");
INSERT INTO nuq_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Kame he tanata e tiaki te hine aia raa no avana teeraa hine, te tama naa ku sara ma te tuaa i te vahi te avvana huri, tena te tanata e avana te hine e peesia ria raa e sara hoki ma te tuaa te avvana huri raa.” ");
INSERT INTO nuq_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Tena Jisas ki meake, “Teeraa he tama hai sileni e uruuru na hekau e sui mmaha roo, tena aia e noho hihia tahi na aho hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ia e isi hoki te tama hakaalloha, te inoa aia raa ko Lasarus. Te tinotama te tama raa e uhia na saanuku hakaatoa, tena na vahao hakaatoa te tama raa e nonoho i te totoka te hare te tama hai sileni raa, ");
INSERT INTO nuq_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ma ki kai na maanunu na kai e tteiho i taha ma te tebol te tama raa. Na poi raa hoki kame e oo ake no ariari na saanuku Lasarus raa. ");
INSERT INTO nuq_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Tena ki oti Lasarus ku mate, tena na ensel raa ki ssau te tama raa no hakanoho i te vahi Abraham i te kai e rahi i te vaelani raa. Tena ki oti te tama hai sileni raa ku mate hoki no tanu ria. ");
INSERT INTO nuq_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Te tama raa ku noho i te kina tera aia e me ki hakalono llihu haeo roo, tena aia ku kira no kite Abraham e mmao roo i taha, tena Lasarus e noho i te vahi tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kito te tama hai sileni raa ki kanna ake, ‘Abraham taku tamana! Hai aroha mai anau, tena ku kauna ria mai Lasarus ki ttoki te matarima aia i roto te vai, tena aia ku hamai no hakamaariki te arero anau nei.’ ");
INSERT INTO nuq_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Tena Abraham ki meake, ‘Taku tama, akoe e maanatu! Te saaita akoe ni noho i te maarama i raro raa, akoe e isi roo na mee hakaatoa taualleka, tena Lasarus se hai mee taualleka ni too. Tena te saaita nei Lasarus ku noho hihia i te kina nei, tena akoe ia ku hakalono llihu. ");
INSERT INTO nuq_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Teeraa mee hoki, e isi te rua e nnoto e moe i lottonu taaua ma ki se lavaa he tama maatou e hakahiti atu i te vahi naa, ia ki se lavaa hoki he tama kootou e hakahiti mai i te vahi nei.’ ");
INSERT INTO nuq_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tena kito te tama hai sileni raa ki meake, ‘Anau e kainno atu akoe, Abraham taku tamana! Kauna ria Lasarus ki haere i te hare te tamana anau raa ");
INSERT INTO nuq_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","no tattara ake e rima na taina anau raa ki se lavaa na tama raa te oo mai i te kina e hakalono llihu nei.’ ");
INSERT INTO nuq_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Kito Abraham ki meake, ‘Na taina akoe raa ku oti te llono na tattara na tuaa Moses ia ma na launiu na profet raa, tena na taina akoe raa e tau te hakallono na tattara na tama raa.’ ");
INSERT INTO nuq_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kito te tama hai sileni raa ki meake, ‘Abraham, taku tamana! Na tattara naa se tau, e meia kame he tama e mahike muri i taha ma te mate no haere no tattara ake na tama naa, tena na tama naa e me ki ttike i taha ma na hai sara laatou raa.’ ");
INSERT INTO nuq_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Tena Abraham ki meake, ‘Kame na taina akoe raa se hakallono na tuaa Moses ia ma na profet raa, na tama naa e me ki se lavaa hoki te hakallono te tama e me ki mahike muri i taha ma te mate raa.’ ” ");
INSERT INTO nuq_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Tena Jisas ki meake na disaipol Aia raa ma, “Na mee tera e me ki mee na tama ki hai sara raa e me ki ttae mai, tena na tama e tauttari na mee raa e me ki hakalono llihu haeo roo. ");
INSERT INTO nuq_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","E me ki tauareka roo kame he tama e nnoa he hatu e rahi roo i te uaa te tama naa, tena ku lletu te tama naa i te lottai, ka oti te tama naa ku tatakore alaa tama ki hai ssara hoki. ");
INSERT INTO nuq_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Tena kootou ki hakamattonu hea kootou e ppena raa! “Kame te taina akoe raa e sara, akoe ku hai ake te tama naa, tena kame aia e tike i taha ma na hai sara aia raa, tena akoe ku hai aroha atu te tama naa. ");
INSERT INTO nuq_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kame te taina akoe raa e sara ma akoe e hitu na vahao i roto te aho hokotahi, tena na vahao hakaatoa aia e haere atu no meatu akoe pera ma, ‘Anau ku aroha,’ tena akoe ki hai aroha te tama naa.” ");
INSERT INTO nuq_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kito na aposol raa ki meake TeAriki ma, “Mee na hakattina maatou raa ki hai mmahi.” ");
INSERT INTO nuq_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tena Jisas ki meake, “Kame kootou e isi na hakattina e llahi pera ma na hua te mastet raa, tena akoe e me ki lavaa te meake te laakau e homo nei ma, ‘Llana ma na patiaka akoe raa no haere no tuu i te moana!’ tena te laakau naa e me ki hakarono akoe. ");
INSERT INTO nuq_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ia kame he tama e hehekau ma kootou tera e tuei seai naa e rorohi na sipsip. Tena te saaita te tama hehekau raa e hamai i hare raa, eaa akoe e me ki meake te tama hehekau raa ki hakavave no kai na kai aia raa? ");
INSERT INTO nuq_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Seai! Emeia akoe e me ki meake te tama hehekau raa ma, ‘Tanattana na kai anau raa, tena akoe ku uru na hekau akoe raa no pare mai na kai anau raa ki kai, tena te saaita roo anau ku oti te kai, ia ku oti te unu raa, tena akoe ku lavaa te kai.’ ");
INSERT INTO nuq_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Akoe se lavaa te hakammaha te tama hehekau akoe raa, niaina roo ma te tama raa e hakarono na tattara akoe. ");
INSERT INTO nuq_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","E ssau peenaa ma kootou naa hoki, te saaita kootou ku oti te ppena na mee TeAtua e hihai ma kootou ki ppena raa, kootou e me ki mee ma, ‘Maatou ni tama hehekau vare koi, tena maatou e ppena koi niaa maatou e me ki ppena raa.’ ” ");
INSERT INTO nuq_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Te saaita Jisas ni haere peeraa i Jerusalem raa, Aia e haere tautari te kooina e tere vaa lottonu Samaria laaua ma Galili raa. ");
INSERT INTO nuq_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Aia e haere i roto te matakaina raa, tena sanahuru na tama e kaina te manumanu haeo ku ttiri Aia. Na tama raa e ttuu hakammao, ");
INSERT INTO nuq_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","tena ki kanna ake hakamaroa ma, “Jisas! TeAriki! Hai aroha mai maatou.” ");
INSERT INTO nuq_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jisas e kite na tama raa, tena aia ki meake, “Oo no huri ake na tinotama kootou raa ki mmata na maatua te lotu raa.” Na tama raa koi oo koi, tena na tinotama laatou raa ku taualleka. ");
INSERT INTO nuq_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tena he tama hokotahi e kite pera ma te tinotama aia raa ku tauareka, tena aia ki vaakai ake no haere hakammaha TeAtua hakamaroa roo. ");
INSERT INTO nuq_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Aia e teiho no tuturi i mua na vae Jisas raa, tena ki hakammaha Tama raa. Te tama raa he tama i Samaria. ");
INSERT INTO nuq_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kito Jisas ki meake, “Anau e tokonaki sanahuru na tama no taualleka, kaa teehee teeraa tokosivo? ");
INSERT INTO nuq_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Aiea te manu siri nei e vaakai mai hokoia no hakammaha TeAtua naea?” ");
INSERT INTO nuq_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kito Jisas ki meake te tama raa, “Mahike i aruna no haere; te hakatina akoe raa e mee akoe no tauareka.” ");
INSERT INTO nuq_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","E isi na Farisi e vahiri ake ma te Hakamaatua ana i te Vaelani raa e me ki hamai vahao hee. Tena Jisas ki meake, “Te hamai te Hakamaatua ana i te Vaelani raa se isi na hakkatu taatou e lavaa te kkite. ");
INSERT INTO nuq_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Se hai tama e lavaa te mee ma, ‘Kira ake, teenei te Hakamaatua ana nei!’ ia se hai tama e lavaa te mee ma, ‘Teeraa te Hakamaatua ana raa!’; maitaname te Hakamaatua ana i te Vaelani raa e nnoho ma kootou.” ");
INSERT INTO nuq_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tena Jisas ki meake na disaipol Aia raa ma, “E isi te saaita koi hamai i muri tera kootou e me ki hihhai ki kkite he aho i na aho te Tamariki te Tama nei ni hehekau raa, e meia kootou se lavaa te kkite he aho na aho naa. ");
INSERT INTO nuq_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","E me ki isi na tama e me ki meatu ma, ‘Teenei te Tamariki te Tama nei!’ ia ku meatu ma, ‘Kira ake, te Tama raa i te kina raa.’ Emeia auu se oo no sesee. ");
INSERT INTO nuq_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Te aho te Tamariki te Tama nei e me ki vaakai mai i muri raa e ssau pera ma he uila tera e taaraki no hakamaarama te vaelani raa hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Emeia te Tamariki te Tama nei e me ki hakalono llihu haeo roo i mua, tena te aho naa, na tama e me ki se hihhai te Tama naa. ");
INSERT INTO nuq_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Na tiputipu na tama raa ni ppena te saaita Noa raa e me ki ssau pera ma na tiputipu na tama raa e me ki ppena te saaita te Tamariki te Tama nei e me ki vaakai mai raa. ");
INSERT INTO nuq_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Na tama hakaatoa e kkai, ia e unu, tena na taanata e avvana na hhine haere roo no ttae te saaita Noa ni haere i roto te vaka raa, tena te tai uu raa ku haere ake no loohia te henua raa no mmate na tama raa hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Na tiputipu na tama nei e ssau pera ma na tiputipu na tama te saaita Lot raa. Na tama raa e kkai, ia e unu, tena na tama raa e suisui na mee, tena alaa tama e sui na hekau alaa tama, tena na tama e ttori na kai, tena alaa tama e ppena na hare. ");
INSERT INTO nuq_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Te aho Lot ni haere i taha ma Sodom raa, te ahi ia ma na hatu na salfa raa ku tteiho mai i taha ma te vaelani no ttuni na tama raa hakaatoa no mmate. ");
INSERT INTO nuq_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Na mee ni kapihi mai te saaita Lot raa e me ki kapihi mai hoki te aho te Tamariki te Tama nei e me ki vaakai mai raa. ");
INSERT INTO nuq_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Te aho naa kame he tama e noho i aruna te tauhuhu te hare, te tama naa se lavaa te tiho i roto te hare raa ma ki too niaa aia e ttino raa, ia e ssau hoki pera ma te tama e noho i roto te paupaku raa, te tama naa se lavaa te vaakai hoki i hare. ");
INSERT INTO nuq_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kootou ki mannatu te mate te avana Lot raa. ");
INSERT INTO nuq_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Te tama e manako te ora aia i te maarama nei raa se lavaa te too te ora e ora tahi, ia te tama se manako te ora aia i te maarama nei raa e me ki too te ora e ora tahi. ");
INSERT INTO nuq_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Anau e meatu kootou, te poo naa e rua na tama e me ki mmoe i aruna te lomoena hokotahi, tena TeAtua e me ki too teeraa tama i taha, tena ku tiaki teeraa tama. ");
INSERT INTO nuq_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","E rua na hhine e me ki nnoho hakaatoa no tukituki na hakapopu, tena TeAtua e me ki too teeraa hine i taha, tena ku tiaki teeraa hine. ");
INSERT INTO nuq_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","E rua na taanata e me ki uata i roto te paupaku hokotahi, tena TeAtua e me ki too teeraa tama i taha, tena ku tiaki teeraa tama.” ");
INSERT INTO nuq_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kito na disaipol raa ki vahiri ake Jisas ma, “TeAriki! Na mee nei e me ki kapihi mai i te kina hee?” Tena Jisas ki meake, “He kina peehee e moe te mee e mate, na manu kai ttama lellee raa e me ki muimui atu i te kina naa.” ");
INSERT INTO nuq_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Tena Jisas ki tattara ake na disaipol Aia raa te tattara hurihuri nei ma ki poroporo ake na tama raa ki se mamannatu tammaki no lotu tahi. ");
INSERT INTO nuq_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“He tama hakatonutonu e noho i te matakaina raa. Te tama raa se mataku TeAtua, ia se hakammaha hoki alaa tama. ");
INSERT INTO nuq_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tena i roto te matakaina naa e isi hoki te tautukaha hine e noho, tena te hine raa e haere tahi ake no kainno ake te tama hakatonutonu raa ma, ‘Tokonaki no hakatonu anau ma te tama e hakatauttau ma anau raa.’ ");
INSERT INTO nuq_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Saaita roroa roo te tama hakatonutonu raa se hihai ki tokonaki te tautukaha hine raa, tena ki oti roo aia ku tattara hokoia ma, ‘Niaina ma anau se mataku TeAtua, ia se hakammaha alaa tama, ");
INSERT INTO nuq_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","e meia anau ku kkaro e mee te tautukaha hine nei e hamai tahi no kainno mai anau ki tokonaki aia. Anau e me ki mee te hakataakoto te hine nei ki tauareka, kaa seai te hine nei e me ki hahamai tahi no mee te tino anau raa ki ttahi aia.’ ” ");
INSERT INTO nuq_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tena TeAriki ki meake, “Hakallono atu hea te tama hakatonutonu haeo raa e tattara raa. ");
INSERT INTO nuq_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Eaa! TeAtua se lavaa te tokonaki no hakatonutonu na tama e ttani tahi ake Aia te ao ma te poo ma ki tokonaki laatou raa? Eaa! Tama raa e me ki nnahe te tokonaki na tama raa? ");
INSERT INTO nuq_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Anau e meatu kootou, TeAtua e me ki vave no tokonaki na tama Aia raa. Emeia, kaa te Tamariki te Tama nei e lavaa te kite na hakattina peenei te saaita Aia e vaakai mai raa?” ");
INSERT INTO nuq_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tena Jisas ki tattara ake te tattara hurihuri nei i na tama e hakataakoto ma laatou e ttonu tahi, tena ki se hihhai alaa tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Tokorua na tama e oo i te Hare Tapu ma ki lotu, teeraa tama he Farisi, tena teeraa tama he tama e aoao na takis. ");
INSERT INTO nuq_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Te Farisi raa e tuu hakammao hokoia no lotu peenei, ‘Anau e hakammaha atu Akoe TeAtua, maitaname anau se manako, anau se kairarao, anau se karemat kairarao pera ma alaa tama. Anau e hakammaha Akoe, e mee anau se ssau pera ma te tama e aoao na takis e tuu i te kina raa. ");
INSERT INTO nuq_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Anau e hakamaatapu e rua na aho i roto te latapu hokotahi, ia tena anau e hoki atu te hakasehui na mee hakaatoa anau e too raa.’ ");
INSERT INTO nuq_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Emeia te tama e aoao na takis raa e tuu hakammao no kkira i raro no tukituki te hatahata aia, tena ki lotu ake peenei, ‘TeAtua, hai aroha mai anau, e mee anau he tama hai sara.’ ” ");
INSERT INTO nuq_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Tena Jisas ki meake na tama raa, “Anau e meatu kootou, te tama e aoao na takis raa e tonu i mua na karemata TeAtua te saaita te lotu raa ni oti, seai ma ko te Farisi raa. Na tama e mee hokolaatou ki hakananniu raa, e me ki tuku iho no mouraro, tena na tama e mee hokolaatou ki mouraro raa e me ki ssau ria no hakananniu.” ");
INSERT INTO nuq_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","E isi na tama e kou ake na tamalliki laatou raa iaa Jisas ma Tama raa ki hakatapu na tamalliki raa. Na disaipol raa e kkite, tena ki hai ake na tama raa ma ki se mee peeraa, ");
INSERT INTO nuq_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","e meia Jisas e kanna ake na tamalliki raa ki oo ake Aia, tena ki meake, “Tiaki na tamalliki naa ki oo mai Anau, tena kootou ki se ppui na tamalliki naa, e mee te Hakamaatua ana i te Vaelani raa he kina na tama peenei. ");
INSERT INTO nuq_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Anau e meatu te hakamaoni! Te tama se hihai ki too te Hakamaatua ana i te Vaelani raa pera ma na tamalliki peenei raa e me ki se lavaa roo te uru i roto te Hakamaatua ana i te Vaelani raa.” ");
INSERT INTO nuq_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","He tama hakamaatua na Jiu raa e vahiri ake Jisas ma, “Te Rabai e tauareka! Hea anau e me ki pena ki lavaa anau te too te ora e ora tahi raa?” ");
INSERT INTO nuq_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Kito Jisas ki meake te tama raa, “Aiea akoe e mee ma Anau e tauareka naea? Se hai tama e tauareka, TeAtua Hokoia koi e tauareka. ");
INSERT INTO nuq_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Akoe e iroa na tuaa nei: ‘Auu se avvana huri, auu se taa tama, auu se kailallao, auu se tattara malliu alaa tama, tena ku hakammaha te tamana ia ma te tinna akoe raa.’ ” ");
INSERT INTO nuq_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tena te tama hakamaatua raa ki meake, “Anau e tautari roo na tuaa naa hakaatoa, kaamata roo te saaita anau ni paamee raa.” ");
INSERT INTO nuq_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisas e rono na tattara te tama raa, tena Aia ki meake, “He mee hokotahi koi akoe e tau te ppena. Kou ake na mee hakaatoa akoe e ttino raa ki sui alaa tama, tena ku too na sileni raa no kou ake na tama hakaalloha raa, tena akoe e me ki isi na mee taualleka i te vaelani, tena ki oti akoe ku hamai no tautari Anau.” ");
INSERT INTO nuq_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Emeia te saaita te tama raa ni rono na tattara raa, aia ku se hihia roo, e mee aia he tama e hai hekau roo. ");
INSERT INTO nuq_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisas e kite pera ma te maanatu te tama raa ku haeo roo, tena Aia ki meake, “E me ki hainattaa roo ma na tama hai sileni raa te ttae i te Hakamaatua ana i te Vaelani raa. ");
INSERT INTO nuq_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Te hainattaa te tama hai sileni ki ttae i te Hakamaatua ana i te Vaelani raa e me ki hainattaa roo i aruna ma te kamel e uru i roto te rua te rina e ttui paamaro raa.” ");
INSERT INTO nuq_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tena na tama e llono Jisas e tattara raa ku vahiri ake ma, “Kaa koai na tama e me ki ora naa?” ");
INSERT INTO nuq_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Kito Jisas ki meake, “Na mee tera e hainattaa roo ma taatou na tama te ppena raa, e hainauhie roo ma TeAtua.” ");
INSERT INTO nuq_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kito Pita ki meake, “Kira ake! Maatou e tiaki na mee hakaatoa maatou e ttino raa no tauttari Akoe.” ");
INSERT INTO nuq_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Tena Jisas ki meake, “Hakamaoni! Anau e meatu kootou te hakamaoni pera ma he tama peehee e tiaki te hare aia, te avana aia, na taina aia, na maatua aia ia ma na tamalliki aia raa no tautari na tiputipu te Hakamaatua ana i te Vaelani raa ");
INSERT INTO nuq_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","e me ki too tammaki roo na mee te saaita nei ia ma te ora e ora tahi tera e hamai i muri raa.” ");
INSERT INTO nuq_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Tena Jisas ki too te sanahuru ma rua na disaipol Aia raa i te vahi, tena ki meake, “Hakallono! Taatou e me ki oo i Jerusalem ki mee na tattara na profet raa ni tattaa i te vahi te Tamariki te Tama nei raa ki hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Na tama i Jerusalem raa e me ki kou ake te Tama raa i na rima na tama seai ma ni Jiu raa, tena na tama raa e me ki tataussua Tama raa, tena ku hai na haeo Tama raa, tena ku sasavare Tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Na tama raa e me ki riki Tama raa, tena ku taa Tama raa no mate, e meia i te aho tana hakatoru raa, Tama raa e me ki mahike muri no ora.” ");
INSERT INTO nuq_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Emeia na disaipol raa se hai mee e illoa i na tattara Jisas raa. Na hakataakoto na tattara raa e huuna ria tera hea na tama raa se illoa hea Jisas ni tattara ake raa. ");
INSERT INTO nuq_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","E isi te tama karemata sseni e noho i te vahi te mateara raa no kainonno te saaita Jisas ni haere no taapiri i Jeriko. ");
INSERT INTO nuq_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Te tama raa ku rono te kanohenua raa e hakallaka vaa mua, tena aia ki vahiri ake, “Hea kootou e mee naa?” ");
INSERT INTO nuq_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kito na tama raa ki meake te tama raa ma, “Jisas te Tama i Nasaret raa ku hamai.” ");
INSERT INTO nuq_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tena te tama karemata sseni raa ki kanna ake ma, “Jisas! Te Mokopuna Devit! Hai aroha mai anau!” ");
INSERT INTO nuq_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kito na tama e ttuu i mua te tama raa ku hai ake te tama raa ma ki noho hemuu. Emeia te tama raa e kanna ake hakamaroa roo ma, “Te Mokopuna Devit! Hai aroha mai anau!” ");
INSERT INTO nuq_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tena Jisas ki tuu no meake na tama raa ki kou ake te tama karemata sseni raa i Aia. Te tama raa ku taapiri ake, kito Jisas ki vahiri ake te tama raa ma, ");
INSERT INTO nuq_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Hea akoe e hihai ma Anau ki ppena ma akoe naa?” Kito te tama raa ki meake, “TeAriki, anau e hihai ma anau ki kite.” ");
INSERT INTO nuq_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Tena Jisas ki meake te tama raa ma, “Tena akoe ku kite naa! Te hakatina akoe raa e mee akoe no tauareka.” ");
INSERT INTO nuq_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Te saaita naa koi te tama raa ku lavaa te kite, tena aia ki haere tautari atu vaa muri Jisas, tena ki hakammaha TeAtua. Te saaita te kanohenua raa ni kkite ma te tama raa ku kite, na tama raa hakaatoa ku hakammaha ake TeAtua. ");
INSERT INTO nuq_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisas e haere peeraa i Jeriko, tena ki haere hakaraka. ");
INSERT INTO nuq_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Teeraa he tama hakamaatua na tama e aoao na takis raa, te inoa aia raa ko Sakius, tena aia he tama hai sileni hoki. ");
INSERT INTO nuq_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tama raa e hakahikkahi ma ki kite ma Jisas koai, e meia aia he tama e popoto roo, tena aia ku se lavaa te kite Jisas e mee te kanohenua raa e tammaki roo. ");
INSERT INTO nuq_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tena kito Sakius ki tere i mua te kanohenua raa no kake i aruna te laakau e rahi roo ma ki lavaa aia te kite Jisas, e mee Jisas e haere atu hoki te ara naa. ");
INSERT INTO nuq_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jisas ku tae i te kina te laakau raa, tena Aia ki kkira i aruna no meake Sakius ma, “Tiho mai vave i raro, e mee Anau e me ki noho i te hare akoe raa te aho nei.” ");
INSERT INTO nuq_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakius ku hihia roo no tiho vave i raro, tena aia ki too Jisas no oo laaua i te hare aia raa. ");
INSERT INTO nuq_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Na tama hakaatoa ni kkite raa ku kaamata no tamumu ma, “Jisas e haere i te hare te tama hai sara!” ");
INSERT INTO nuq_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tena Sakius ki tuu i aruna no meake Jisas ma, “TeAriki! Hakarono mai, anau e me ki vvae hea anau e ttino raa i lottonu, tena ku kou ake i na tama hakaalloha raa, tena kame anau ni hai laavaka he tama anau e me ki kou ake e haa na tuhana ki raka ma hea anau ni hai laavaka no too i te tama raa.” ");
INSERT INTO nuq_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tena Jisas ki meake, “Te aho nei TeAtua ku tokonaki na tama i roto te hare nei raa no ora, maitaname teenei he mokopuna Abraham hoki. ");
INSERT INTO nuq_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Te Tamariki te Tama nei e hamai ma ki sesee na tama e llano raa, tena ku tokonaki na tama raa ki too te ora hakamaoni.” ");
INSERT INTO nuq_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Na tama raa koi hakalollono koi na tattara raa, tena Jisas ku tattara ake te tattara hurihuri nei. Aia ku taapiri roo i Jerusalem, tena na tama raa e kkahu ma te Hakamaatua ana i te Vaelani raa ku taapiri koi ki hakahura ake. ");
INSERT INTO nuq_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kito Jisas ki meake, “Teeraa he tama e hakamaatua roo, tena aia e horau i te henua e mmao roo i taha ma ki tuku te henua raa, tena i muri aia ku vaakai ake i te henua aia raa. ");
INSERT INTO nuq_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","I mua aia ni horau raa, aia e kanna ake te sanahuru na tama hehekau aia raa, tena ki kou ake na tama raa na siliva taki ttahi, tena ki meake na tama raa, ‘Kootou ki mmata ma e hia kootou e lavaa te hakapiri ake i aruna te siliva hokotahi nei te saaita anau e haere raa.’ ");
INSERT INTO nuq_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Emeia te saaita naa hoki na tama roo te henua aia raa ku se hihhai te tama raa, tena laatou ki kauna ria atu na tama i muri te tama raa ma ki meake na tama te henua te tama raa e haere raa ma, ‘Maatou ku se hihhai te tama nei ki mee pera ma he tuku maatou.’ ");
INSERT INTO nuq_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Te tama raa e haere no tuku, tena ki vaakai mai i muri. Te tama raa e tae ake koi, tena ki kanna ake na tama hehekau aia raa ki oo ake no ttuu i mua aia ki mmata ma e hia na sileni laatou ni lavaa te too raa. ");
INSERT INTO nuq_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Te tama kaamata raa e haere ake, tena ki meake, ‘Tama hakamaatua! Anau e hehekau no too sanahuru na siliva i aruna ma hea akoe ni kou mai raa.’ ");
INSERT INTO nuq_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Tena te tuku raa ki meake, ‘Tauareka roo, akoe he tama hehekau tauareka! Anau e me ki tuku akoe ki rorohi sanahuru na matakaina e llahi.’ ");
INSERT INTO nuq_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tena te tama hakarua raa ki haere ake no meake ma, ‘Tama hakamaatua! Anau e hehekau no too e rima na siliva i aruna ma hea akoe ni kou mai anau raa.’ ");
INSERT INTO nuq_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Tena te tama hakamaatua raa ki meake te tama raa, ‘Akoe e me ki rorohi e rima na matakaina e llahi.’ ");
INSERT INTO nuq_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Tena teeraa tama ku haere ake no meake ma, ‘Tama hakamaatua! Teenei te siliva akoe; anau e huu i roto te paamaro. ");
INSERT INTO nuq_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Anau e mataku akoe, e mee akoe he tama e hakamataku. Akoe e too na mee tera seai ma ni mee akoe raa, tena akoe e kkope na kai tera akoe ni se ttori.’ ");
INSERT INTO nuq_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tena te tuku raa ki meake, ‘Akoe he tama hehekau haeo! Anau e me ki too na tattara akoe naa ki hakatonutonu akoe! Akoe e iroa pera ma anau he tama hakamataku, tena anau e too na mee tera seai ma ni mee anau raa, tena ki too hoki na kai tera anau ni se ttori raa. ");
INSERT INTO nuq_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Aiea kaa akoe se ppono te siliva nei i roto te benk raea? Tena anau e me ki too muri te siliva nei ma na siliva laatou e hakapiri ake i aruna raa.’ ");
INSERT INTO nuq_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Tena te tuku raa ki meake na tama e ttuu vaa raa, ‘Too te siliva naa i taha ma te tama raa, tena ku kou ake te tama e isi sanahuru na siliva raa.’ ");
INSERT INTO nuq_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kito na tama raa ki meake te tuku raa ma, ‘Tama hakamaatua! Tama raa e isi sanahuru na siliva!’ ");
INSERT INTO nuq_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Tena te tuku raa ki meake, ‘Anau e meatu kootou pera ma na tama e isi tammaki na mee raa e me ki too alaa mee e hakapiri ake hoki i aruna, tena na tama se isi na mee raa niaina ma na mee raa e moisi, e meia na mee raa e me ki too ria i taha ma laatou. ");
INSERT INTO nuq_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tena kou mai na tama ni se hihhai ma anau ki tuku laatou raa i te kina nei vahao nei, tena ku taa na tama raa ki mmate i mua na karemata anau!’ ” ");
INSERT INTO nuq_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas e tattara ake te tattara hurihuri raa no oti, tena Aia ki haere i mua na tama raa i Jerusalem. ");
INSERT INTO nuq_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jisas ku taapiri i Betfage laaua ma Betani i te kina te Mouna e hhomo na Oliv raa, tena Jisas ki kauna tokorua na disaipol Aia raa ki oo i mua ");
INSERT INTO nuq_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ma na tattara nei, “Oo i te matakaina e tuu mai i mua raa, tena te saaita koorua e uru atu i te matakaina naa, koorua e me ki kkite te donki e nnoa tera se hai tama ni kake i aruna no tere, tena koorua ku vvete te donki naa no hakattaki mai. ");
INSERT INTO nuq_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kame he tama e vahiri atu ma, ‘Koorua e vvete te donki naa ki aa,’ tena koorua ku meake pera ma, ‘TeAriki e hihai te manu nei.’ ” ");
INSERT INTO nuq_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tokorua raa e oo no kkite pera ma na mee laaua e kkite raa e ssau roo pera ma hea Jisas ni tattara ake laaua raa. ");
INSERT INTO nuq_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tokorua raa ku vvete te donki raa, tena te tama te manu raa ki vahiri ake tokorua raa ma, “Koorua e vvete te donki naa ki aa?” ");
INSERT INTO nuq_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kito tokorua ki meake ma, “TeAriki e hihai te manu nei.” ");
INSERT INTO nuq_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tena tokorua raa ki hakattaki ake te donki raa iaa Jisas. Tena na disaipol raa ki hakapiri na kaukahu laatou raa i aruna te donki raa, tena laatou ki hakkake Jisas i aruna. ");
INSERT INTO nuq_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jisas e tere i aruna te donki raa, tena te kanohenua raa ku sosora na kaukahu lolloa laatou raa vaa aruna te mateara. ");
INSERT INTO nuq_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jisas ku taapiri i Jerusalem i te kina te mateara e haere i raro te Mouna e hhomo na Oliv raa, tena tammaki roo na disaipol Aia raa ku kaamata no hakammaha TeAtua, tena ki hakammaha ake TeAtua hakamaroa roo, e mee laatou ku kkite na mee e llahi roo. ");
INSERT INTO nuq_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“TeAtua e hakatapu te Tuku tera e hamai i te inoa TeAriki raa! Na mahi TeAtua ia ma te Noho Laoi i te vaelani!” ");
INSERT INTO nuq_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","E isi na Farisi i roto te kanohenua raa e hai ake Jisas ma, “Rabai! Meake na disaipol Akoe raa ki se vaa!” ");
INSERT INTO nuq_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Kito Jisas ki meake, “Anau e meatu kootou, kame na tama nei e ttuu hemuu, tena na hatu nei hokolaatou e me ki kaamata no vaa.” ");
INSERT INTO nuq_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisas ku taapiri roo i Jerusalem, tena te saaita Aia ni kite te matakaina raa, Aia ku tani roo Tana aroha, ");
INSERT INTO nuq_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","tena ki meake, “Kame kootou e illoa hakamaoni hea e me ki kou atu te noho laoi! Emeia kootou se lavaa te kkite te noho laoi raa. ");
INSERT INTO nuq_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","E isi te saaita e me ki hamai, tena na tama e haeo kootou raa e me ki oo atu no hakkutu na kerekere raa ki palluna, tena ku llepo areha kootou i na vahi hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Na tama raa e me ki seu te matakaina e rahi kootou naa, tena ku taa kootou ki mmate; na tama raa se lavaa te tiaki he hatu ki mmau i te kina aia ni mmau raa, maitaname kootou ni se illoa te saaita TeAtua e me ki tokonaki kootou raa.” ");
INSERT INTO nuq_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tena Jisas ki haere i roto te Hare Tapu raa no hakaise na tama e suisui na mee vaa hare raa, ");
INSERT INTO nuq_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","kito Jisas ki meake na tama raa, “Na tattara nei e mmau i roto te Launiu Tapu TeAtua raa pera ma, ‘Te Hare Tapu Anau nei he hare e me ki lotulotu.’ Emeia kootou ku huri te hare nei ki mee mo he hare na tama kailallao.” ");
INSERT INTO nuq_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jisas e akoako i roto te Hare Tapu raa na aho hakaatoa. Na maatua hakananniu raa, na tama e poroporo na tuaa raa ia ma na tama hakamattua na Jiu raa e hihhai ma ki taa Jisas ki mate, ");
INSERT INTO nuq_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","e meia na tama raa se hai ara e lave ki taa Tama raa, maitaname te kanohenua raa e hihhai ki hakallono na tattara Tama raa, tena na tama raa hoki se hihhai ma laatou ki se llono he tattara hokotahi. ");
INSERT INTO nuq_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Teeraa he aho Jisas e akoako ake te kanohenua raa i te vahi te Rono Tauareka raa i roto te Hare Tapu, tena na maatua hakananniu raa, na tama poroporo na tuaa raa, hakapaa ma na tama hakamattua na Jiu raa ku oo ake ");
INSERT INTO nuq_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","no meake Jisas ma, “Akoe ki mee mai maatou ma ni mahi peehee akoe e isi ki ppena na mee nei?” ");
INSERT INTO nuq_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Kito Jisas ki meake na tama raa, “Anau e me ki vahiri atu he vahiri hokotahi. Kootou ki mee mai Anau, ");
INSERT INTO nuq_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","na mahi Jon e isi ki hakoukou tapu na tama raa ni mahi e oo mai TeAtua ma ni mahi e oo mai koi te tama?” ");
INSERT INTO nuq_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tena na tama raa ku kaamata no hakatauttau hokolaatou ma, “Taatou e me ki meake peehee? Kame taatou e meake ma, ‘Na mahi Jon e isi raa ni mahi TeAtua’, tena Aia e me ki mee mai ma, ‘Kaa kootou se hakattina Jon naea?’ ");
INSERT INTO nuq_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tena kame taatou e meake ma, ‘Na mahi Jon e isi raa ni mahi koi te tama,’ tena te kanohenua nei e me ki maka taatou na hatu, maitaname na tama raa e hakattina pera ma Jon he profet.” ");
INSERT INTO nuq_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kito na tama raa ki meake ma, “Maatou se illoa ma na mahi Jon e isi raa ni mahi e oo mai i hee.” ");
INSERT INTO nuq_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tena Jisas ki meake na tama raa, “Tena Anau hoki se lavaa te meatu ma ni mahi peehee Anau e isi ki ppena na mee nei.” ");
INSERT INTO nuq_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tena Jisas ki tattara ake te tattara hurihuri nei: “Teeraa he tama e ttori na hua na grep i roto te paupaku aia, tena aia ki kou ake te paupaku raa ki lollohi alaa tama, tena te tama raa ki tiaki te henua aia raa no haere no noho i taha ma te henua raa saaita roroa roo. ");
INSERT INTO nuq_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Te saaita na hua na laakau raa ku lleu, tena te tama hakamaatua te paupaku raa ku kauna te tama hehekau aia raa ki haere no mmata na tama e lollohi te paupaku aia raa, tena ku too te tuhana aia raa. Emeia na tama e lollohi te paupaku raa e taa te tama raa, tena ki kauna muri te tama raa ki vaakai se hai mee e kou ake. ");
INSERT INTO nuq_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tena kito te tama hakamaatua raa ki kauna teeraa tama; e meia na tama e lollohi te paupaku raa e taa te tama raa hoki, tena ki ppena hakahaeo roo i te tama raa, tena ki kauna muri te tama raa ki haere se hai mee hoki e kou ake. ");
INSERT INTO nuq_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tena aia ki kauna te tama tana hakatoru raa, tena na tama lollohi te paupaku raa ki taa te tama raa no masessere haeo roo, tena ki ppehi te tama raa i aho. ");
INSERT INTO nuq_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Tena te tama hakamaatua te paupaku raa ki tattara ma, ‘Hea anau e me ki ppena? Anau e me ki kauna te taupeara hokotahi anau e hakasessere mahi nei. Na tama naa kame e me ki hakammaha hakamaoni taku tama nei.’ ");
INSERT INTO nuq_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Emeia, te saaita na tama e lollohi te paupaku raa ni kkite te taupeara raa, na tama raa ku tattara hokolaatou ma, ‘Teenei te taupeara te tama hakamaatua te paupaku nei. Taatou ki taa te tama nei ki mate, tena taatou ku too na mee hakaatoa aia e ttino raa ma taatou!’ ");
INSERT INTO nuq_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kito na tama raa ki lletu te taupeara raa i taha ma te paupaku raa, tena ki taa te tama raa no mate.” Kito Jisas ki vahiri ake, “Kaa hea te tama hakamaatua te paupaku raa e me ki ppena i na tama e lollohi raa? ");
INSERT INTO nuq_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Te tama hakamaatua raa e me ki hamai no taa na tama raa ki mmate, tena ku too te paupaku raa no kou ake alaa tama ki lollohi.” Te kanohenua raa e llono na tattara nei, tena na tama raa ki meake ma, “Te mee naa se tonu!” ");
INSERT INTO nuq_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Kito Jisas ki kira ake na tama raa, tena ki meake, “Kaa te hakataakoto na tattara te Launiu Tapu raa e mee maea? ‘Te hatu na tama e hakatuutuu na hare raa ni hakahekeheke ma e haeo raa ko te hatu roo e mmau hokoia i na hatu hakaatoa.’ ");
INSERT INTO nuq_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Na tama e hhina i aruna te hatu nei raa e me ki motumotu matalliki roo, tena kame te hatu naa e tteiho i aruna he tama, te hatu naa e me ki hakappela te tama naa ki mee mo rehu.” ");
INSERT INTO nuq_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Na tama poroporo na tuaa ia ma na maatua hakananniu raa e hahaivi ma ki hakapiki Jisas i te kina raa, e mee laatou e illoa ma Jisas e tattara te tattara hurihuri raa i laatou; e meia laatou e mattaku hoki i te kanohenua raa. ");
INSERT INTO nuq_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tena na tama raa ku kirakira he saaita e ttana. Na tama raa e sui na tama ki oo no malliu ma laatou ni tama e ttonu, tena ku oo no vahihhiri ake Jisas ma ki taaiki Tama raa ma na vahiri, ki lavaa laatou te too Jisas no kou ake i na tama hakamattua te taumani i Rom raa. ");
INSERT INTO nuq_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tena na tama haeo raa ki meake Jisas, “Rabai, maatou e illoa pera ma na tattara ia ma na akoako Akoe raa e ttonu. Maatou e illoa pera ma Akoe se maanatu ma he kakkae peehee te tama e isi, e meia Akoe e akoako ake te hakamaoni TeAtua raa i na tama hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Akoe ki mee mai maatou ma e sara ma na tuaa taatou raa ki sui ake na takis raa i te tuku i Rom ma seai?” ");
INSERT INTO nuq_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Emeia Jisas e iroa ma na tama raa e malliu, tena Aia ki meake na tama raa, ");
INSERT INTO nuq_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Huri mai he sileni. Teenei he pohouru, ia he inoa aai e mmau te sileni nei raa?” Kito na tama raa ki meake, “He pohouru, ia he inoa te tuku i Rom.” ");
INSERT INTO nuq_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tena kito Jisas ki meake, “Tena kootou ku sui ake te tuku raa hea aia e ttino, tena ku sui ake TeAtua hea TeAtua e ttino.” ");
INSERT INTO nuq_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tena na tama raa ku se hai mee roo e lavaa ma ki taaiki Jisas i mua te kanohenua raa hakaatoa, kito na tama raa ki nnoho hemuu, e meia laatou e mamahharo roo i na tattara Tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Na Sadyusi raa ko na tama e mee ma na tama e mmate se lavaa te ora muri, tena na tama raa ki oo ake no meake Jisas ma, ");
INSERT INTO nuq_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Rabai, Moses e taataa mai na tuaa nei i taatou ma: ‘Kame he tanata e mate se hai tamalliki i te avana aia raa, tena te taina aia raa e me ki avana te tautukaha hine raa ki lavaa laaua te hura tama, tena na tamalliki raa e me ki mee pera ma ni tamalliki te tanata ku mate raa.’ ");
INSERT INTO nuq_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tena teeraa he tokohitu na haanau; te taina matua raa e avana no mate se hai tamalliki. ");
INSERT INTO nuq_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tena te tama pare ake raa ku avana te hine raa no mate hoki se hai tamalliki, ");
INSERT INTO nuq_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","tena te tama hakatoru raa ku avana hoki te hine raa no mmate se hai tamalliki. Tena te tokohitu na haanau raa hakaatoa ni avvana te hine raa no mmate se hai tamalliki. ");
INSERT INTO nuq_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tena ki oti roo te hine raa ku mate. ");
INSERT INTO nuq_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ia tena, i te aho na tama e mmate raa e me ki ora muri i taha ma te mate raa, koai te tama na tama nei e me ki avana te hine raa? E mee te tokohitu na haanau raa hakaatoa ni avvana te hine raa.” ");
INSERT INTO nuq_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tena Jisas ki meake na tama raa, “Na taanata ia ma na hhine te maarama nei raa e avvana, ");
INSERT INTO nuq_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","e meia na taanata ia ma na hhine tera e me ki ora muri i taha ma te mate no nnoho i te maarama i muri raa se lavaa te avvana. ");
INSERT INTO nuq_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Na tama raa e me ki mee pera ma ni ensel, tena na tama raa hoki se lavaa te mmate. Na tama raa ni tamalliki TeAtua, e mee laatou ni ora muri i taha ma te mate. ");
INSERT INTO nuq_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ia tena Moses ni hakamatahua mai pera ma na tama e mmate raa e me ki mahhike muri no ora. I na tattara i te vahi te pupuu e ura raa, Moses e tattara pera ma TeAriki ko ‘TeAtua tera Abraham, TeAtua tera Aisak, tena TeAtua tera Jekop.’ ");
INSERT INTO nuq_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Aia he atua na tama e ora, seai ma he atua na tama e mmate, maitaname na tama hakaatoa e ora koi i Aia.” ");
INSERT INTO nuq_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kito na tama e poroporo na tuaa raa ki meake, “Rabai, na tattara Akoe naa e ttonu!” ");
INSERT INTO nuq_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tena na tama raa ku mattaku te vahiri ake alaa vahiri hoki. ");
INSERT INTO nuq_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tena Jisas ki vahiri ake na tama raa, “Aiea na tama raa e tattara ma te Mesaia raa he Mokopuna Devit raea? ");
INSERT INTO nuq_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","E mee Devit hokoia ni tattara mai i roto te launiu na Rue raa pera ma, ‘TeAtua e meake TeAriki anau raa ma, Noho i te vahi laaua Anau nei, ");
INSERT INTO nuq_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ki tae roo te saaita Anau e tuku na tama e kiri lloto Akoe raa i raro na vae Akoe raa pera ma he tuai.’ ");
INSERT INTO nuq_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Devit e kanna te Mesaia raa ma, ‘TeAriki’; kaa te Mesaia raa e lavaa te mee pera ma he Mokopuna Devit peehee?” ");
INSERT INTO nuq_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Te kanohenua raa e nnoho no hakallono Jisas e tattara raa, tena Aia ki meake na disaipol aia raa ma, ");
INSERT INTO nuq_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Lollohi hakamattonu i na tama poroporo na tuaa raa. Na tama raa e hihhai ki uru na kaukahu lolloa, tena e hihhai hoki ma na tama ki hakammaha laatou i na kina na maket, tena na tama raa e hihhai hoki ki nnoho i na kina na tama hakamattua e nohonnoho raa, tena e hihhai hoki ki nnoho i na kina taualleka i te kina na kai e llahi raa. ");
INSERT INTO nuq_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Na tama raa e hihhai ki hai lavvaka no kailallao na hare na tautukaha hhine raa, tena ki hakatannata ma laatou e too na lotu e lolloa! Emeia na hakalono llihu laatou e me ki too raa e me ki haeo roo.” ");
INSERT INTO nuq_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas e kkira hakataka no kite na tama hai sileni raa e ponopono na hoki laatou raa i roto te papa na sileni i te Hare Tapu raa, ");
INSERT INTO nuq_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","tena Aia e kite te tautukaha hine hakaalloha e ppono e rua na peni i roto te papa raa hoki. ");
INSERT INTO nuq_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kito Jisas ki meake, “Anau e meatu kootou pera ma te hoki te tautukaha hine nei ni ppono raa e raka roo i aruna ma na hoki na tama hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Maitaname na tama e ppono tammaki na sileni raa e isi hoki na sileni e ttoe; e meia te hine nei he tama hakaalloha, tena aia e hoki ake na peeni hakaoti aia e isi raa hakaatoa, tena aia ku se hai sileni hoki e ttoe ki tokonaki aia.” ");
INSERT INTO nuq_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","E isi na disaipol Jisas e tattara ma te Hare Tapu raa e tiputipu laoi roo ma na hatu e mmau i te hare raa ia ma na hoki na tama raa e hoki ake TeAtua raa. Tena Jisas ki meake, ");
INSERT INTO nuq_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“E isi te saaita e me ki tae mai tera na mee taualleka hakaatoa kootou e kkite e mmau i te Hare Tapu nei raa e me ki maoha i raro.” ");
INSERT INTO nuq_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kito na tama raa ki vahiri ake, “Rabai, na mee nei e me ki kapihi mai vahao hee? Kaa hea e me ki huri mai ki illoa maatou te saaita na mee nei e me ki kapihi mai raa?” ");
INSERT INTO nuq_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tena Jisas ki meake, “Lollohi hakamattonu, tena kootou ki se hakapanimu. Tammaki na tama e me ki malliu ma laatou e tattara te vahi Anau, tena na tama naa e me ki oo atu no meatu ma, ‘Anau ko te Mesaia!’ ia ma, ‘Te hakaoti raa ku mee ki tae mai i te maarama nei!’ Emeia kootou ki se tauttari na tama naa. ");
INSERT INTO nuq_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kootou ki se mattaku te saaita kootou e llono na taua na henua e llahi ia ma na taua i roto koi na henua raa; na mee nei e me ki kapihi atu i mua, e meia na mee nei se huri atu pera ma te hakaoti te maarama nei raa ku taapiri.” ");
INSERT INTO nuq_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tena Jisas ki meake hoki ma, “Na henua e me ki ppuhu hokolaatou, tena na nohorana e me ki ppuhu hokolaatou hoki. ");
INSERT INTO nuq_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tammaki na henua e me ki ttiri na ruru henua hai mmahi, te one ia ma na maahana haeo e me ki ttiri na kina hakaatoa, tena e me ki isi na mee hakamattaku kootou ni se kkite i mua raa e me ki oo mai peeraa i te vaelani, ");
INSERT INTO nuq_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","e meia i mua na mee nei e kapihi atu, kootou e me ki hakapiki ria, tena na tama raa e me ki kou atu na hakalono lihu i kootou; na tama raa e me ki too kootou no kkave i te hare lotu raa ki hakatonutonu ria, tena ku too kootou no ppono i te hare karapusi; kootou e me ki ttuu i mua na tuku ia ma na tama hakamattua raa e mee kootou e tauttari Anau. ");
INSERT INTO nuq_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Teenaa te saaita tauareka kootou te tattara ake te Rono Tauareka raa. ");
INSERT INTO nuq_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kootou ki mmoe koi te maanatu hokotahi, ia ki se mamannatu tammaki hea kootou e me ki tattarama ki tokonaki kootou raa, ");
INSERT INTO nuq_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","maitaname Anau e me ki kou atu kootou na tattara ia ma te atamai tera na tama e haeo kootou raa e me ki se lavaa te mee ma kootou e ssara. ");
INSERT INTO nuq_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Na maatua kootou raa, na taina kootou raa, na hareakina kootou raa, na soa kootou raa e me ki too kootou no kkave i na tama e kiri lloto kootou raa, tena na tama raa e me ki taa alaa tama kootou no mmate. ");
INSERT INTO nuq_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Na tama hakaatoa e me ki kiri lloto kootou e mee kootou e tauttari Anau. ");
INSERT INTO nuq_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Emeia se lavaa roo he rouru i aruna na pohouru kootou raa e me ki hopo. ");
INSERT INTO nuq_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tuu mmau, tena kootou e me ki too te ora hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Kootou e me ki illoa pera ma Jerusalem ku mee ki seua ria, te saaita kootou e kkite na tama na taua raa ku alleha Jerusalem. ");
INSERT INTO nuq_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tena na tama i Judia raa e me ki huro peeraa i na mouna raa, tena na tama e nnoho i roto te matakaina e rahi raa e me ki huro i taha, tena na tama e nnoho i mmao ma te matakaina raa e me ki se lavaa te oo i roto te matakaina raa. ");
INSERT INTO nuq_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","E mee teenaa ko ‘Na aho na hakalono llihu TeAtua raa’, ki mee na tattara hakaatoa te Launiu Tapu raa ki hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Te aho naa, na hhine hai ttama ia ma na hhine e mee na tamalliki pammee raa e me ki hakalono llihu haeo roo. Na mee sakkino roo e me ki ttae ake te henua naa, tena TeAtua e me ki kou ake na hakalono llihu Aia raa i na tama te henua naa. ");
INSERT INTO nuq_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","E isi na tama e me ki taaia ria no mmate ma na paraamoa, tena alaa tama e me ki too ria no kkave i alaa henua pera ma ni tama karapusi, tena na tama e nnoho pouri raa e me ki hakananniu i roto Jerusalem ki ttae te saaita TeAtua e tuku ake laatou raa e oti. ");
INSERT INTO nuq_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“E isi na mee kootou ni se kkite i mua raa e me ki kapihi ake i te laa, te maremo ia ma na hetuu. Na henua hakaatoa i roto te maarama nei raa e me ki mamannatu tammaki, ia e me ki mattaku te mmuu te peau ia ma te ttahe te moana. ");
INSERT INTO nuq_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Te mattaku na tama raa e me ki mee na karemata laatou raa no pouri te saaita laatou ni nnoho no ttari hea e me ki kapihi mai i roto te maarama nei raa, tena na mee i te vaelani raa e me ki se lavaa te oo tonu i na ara laatou e hahaere raa. ");
INSERT INTO nuq_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Te Tamariki te Tama nei e me ki hamai i roto te pukureurehu ma na mahi hai mmahi ia ma te maahina. ");
INSERT INTO nuq_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Te saaita na mee nei e me ki ttae atu raa, kootou e me ki ttuu no kkira i aruna, e mee TeAtua ku taapiri ki hamai no tokonaki kootou ki ora.” ");
INSERT INTO nuq_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tena Jisas ki tattara ake te tattara hurihuri nei, “Kootou ki mannatu te laakau fik raa ia ma alaa laakau hoki. ");
INSERT INTO nuq_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Te saaita kootou e kkite na laumea na laakau raa ku hura ake, kootou ku illoa koi pera ma te saaita na reurehu raa ku taapiri. ");
INSERT INTO nuq_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","E ssau hoki, te saaita kootou e kite na mee nei e kapihi atu raa, tena kootou e me ki illoa pera ma te Hakamaatua ana i te Vaelani raa ku taapiri atu. ");
INSERT INTO nuq_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Mannatu pera ma na mee nei e me ki kapihi mai i mua na tama e nnoho vahao nei raa e mmate hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Te vaelani ia ma te maarama nei e me ki oo no oti, e meia na tattara Anau raa se lavaa te oo no oti. ");
INSERT INTO nuq_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Kootou ki hakamattonu ki se lavaa kootou te kapitia hai mahi i na kai e llahi ia ma te unu tahi, tena ki se mamannatu tammaki na ora i te maarama nei raa, ka oti te aho naa ku hakateki no tae atu no ttaohi kootou ");
INSERT INTO nuq_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","pera ma he taaiki. Te aho Anau e me ki vaakai mai raa e me ki ttae na tama hakaatoa i roto te maarama nei. ");
INSERT INTO nuq_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kootou ki hakamattonu, tena ku lotu tahi ki lavaa kootou te isi na mahi te uru atu ma na hakalono llihu tera e me ki ttae atu raa, ia ki lavaa hoki kootou te ttuu i mua te Tamariki te Tama nei.” ");
INSERT INTO nuq_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jisas e akoako na aho hakaatoa i roto te Hare Tapu, tena te hiahi Aia ku haere no noho te poo naa i aruna te Mouna e hhomo na Oliv raa. ");
INSERT INTO nuq_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Te tahata roo na aho hakaatoa na tama raa e oo ake i te Hare Tapu raa no hakallono Jisas e tattara. ");
INSERT INTO nuq_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Te saaita te Kai te Haraoa Mannihi tera laatou e kanna hoki ma te Pasova raa ku taapiri. ");
INSERT INTO nuq_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Na maatua hakananniu raa laatou ma na tama poroporo na tuaa raa e mattaku i te kanohenua raa, tena laatou ki sesee he ara ma ki taa hemuu Jisas ki mate. ");
INSERT INTO nuq_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tena Satan ku tau i roto Judas Iskariot, he tama i roto te sanahuru ma rua na disaipol Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kito Judas ki haere no tattara ake na maatua hakananniu raa laatou ma na soldia e lollohi te Hare Tapu raa ki illoa na tama raa te ara aia e me ki hakari ake Jisas i na tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Na tama raa ku hihhia roo, tena ki meake ma laatou e me ki sui Judas na sileni. ");
INSERT INTO nuq_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas e hihai te hakataakoto na tama raa, tena aia ku kaamata no matamata hemuu he saaita e tauareka tera aia e me ki kou ake Jisas i na tama hakamattua raa ki se illoa te kanohenua raa. ");
INSERT INTO nuq_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Te saaita ki taa na punua sipsip raa e teiho mai i te aho te Kai te Haraoa Mannihi raa. ");
INSERT INTO nuq_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jisas e kauna Pita laaua ma Jon ma na tattara nei, “Oo no tanattana mai te Kai te Pasova raa ki kkai taatou.” ");
INSERT INTO nuq_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tena tokorua raa ki vahiri ake ma, “Akoe e hihai ma maaua ki oo no tanattana te kai raa i hee?” ");
INSERT INTO nuq_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Kito Jisas ki meake, “He tanata e amo te lloo vaitea e me ki ttiri koorua te saaita koorua e uru atu i roto te matakaina naa, tena koorua ku tauttari te tanata naa i roto te hare aia e haere no uru raa, ");
INSERT INTO nuq_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","tena koorua ku meake te tama hakamaatua te hare naa pera ma, ‘Te Rabai raa e mee mai maaua ki meatu akoe ma teehee te rum Aia e me ki kai te Kai te Pasova raa ma na disaipol Aia naa?’ ");
INSERT INTO nuq_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Te tama naa e me ki huri atu te rum e rahi i aruna, tena koorua ku tanattana mai na mee hakaatoa ki kkai taatou i te kina naa.” ");
INSERT INTO nuq_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tena tokorua raa ki oo no kkite pera ma na mee raa e ssau roo pera ma hea Jisas ni tattara ake laaua raa, tena laaua ki tanattana na kai te Pasova raa. ");
INSERT INTO nuq_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Te saaita ki kkai te kai raa ku ttae, tena Jisas ma na aposol Aia raa ku nnoho ma ki kkai. ");
INSERT INTO nuq_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kito Jisas ki meake na tama raa, “Anau e hihai roo ma ki kai te kai te Pasova nei ma kootou i mua Anau e hakalono llihu. ");
INSERT INTO nuq_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ia tena Anau e meatu kootou pera ma Anau se lavaa hoki te kai te kai nei ki ttae roo te saaita te mee nei e huri mai te hakamaoni aia i roto te Hakamaatua ana i te Vaelani raa.” ");
INSERT INTO nuq_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jisas e too te kapu raa no lotu ake TeAtua, tena ki meake, “Too te kapu nei no unu, tena ku hakataka atu ki unu kootou hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Anau e meatu kootou pera ma Anau se lavaa hoki te unu te wain nei ki tae roo te saaita te mee nei e huri mai te hakamaoni aia i roto te Hakamaatua ana i te Vaelani raa.” ");
INSERT INTO nuq_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tena Jisas ki too te muri haraoa raa no lotu ake TeAtua, tena ki ttohi te haraoa raa no kou ake na tama raa, tena Aia ki meake, “Teenei ko te tinotama Anau tera Anau e kou atu kootou. Ppena te mee nei ki mannatu kootou Anau.” ");
INSERT INTO nuq_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tena te saaita te kai raa ku oti Aia ku too hoki te kapu raa, tena ki meake, “Teenei ko te kapu te tattara e ivi TeAtua e mmoe i roto te toto Anau tera e me ki nnini atu ki tokonaki kootou raa.” ");
INSERT INTO nuq_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Emeia kkira mai! Te tama e me ki hakari ake Anau i na tama haeo raa e noho i te tebol nei ma Anau! ");
INSERT INTO nuq_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Te Tamariki te Tama nei e me ki mate ki tautari hea TeAtua ni hakamoe raa, e meia te tama tera e me ki hakari ake Anau i na tama haeo raa e me ki hakalono llihu haeo roo.” ");
INSERT INTO nuq_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tena na disaipol raa ku vahihhiri hokolaatou ma koai roo te tama laatou e me ki hakari ake Jisas i na tama haeo raa. ");
INSERT INTO nuq_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tena na disaipol raa ku kaamata no hakatauttau hokolaatou ma koai te tama laatou e me ki hakanaaniu. ");
INSERT INTO nuq_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tena Jisas ki meake na tama raa, “Na tuku na tama e nnoho pouri raa e isi na mahi i aruna na kanohenua laatou raa, tena na tama hakananniu raa ku ttapa ria pera ma, ‘Na Soa te Kanohenua.’ ");
INSERT INTO nuq_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tena kootou ki se mee peeraa, e meia te tama hakanaaniu kootou raa e me ki mee pera ma he tama mouraro, tena te tama hakamaatua raa e me ki mee pera ma he tama hehekau. ");
INSERT INTO nuq_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Koai te tama e hakanaaniu, te tama e noho ma ki kai raa ma te tama e kou ake na kai raa? Hakamaoni te tama e noho i raro raa e hakanaaniu. Emeia Anau e nnoho ma kootou pera ma he tama hehekau. ");
INSERT INTO nuq_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Kootou e nnoho roo ma Anau te saaita Anau ni hahaaite ria raa; ");
INSERT INTO nuq_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","tena Anau e me ki kou atu kootou na mahi ki mee pera ma ni tuku, e ssau pera ma te Tamana Anau raa ni kou mai na mahi Anau ki hakamaatua raa. ");
INSERT INTO nuq_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kootou e me ki kkai, ia e me ki unu ma Anau i roto te Hakamaatua ana Anau raa, tena kootou e me ki nnoho i aruna na nohorana no hakamattua na kaha sanahauru ma rua Israel raa. ");
INSERT INTO nuq_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Saimon, Saimon! Hakarono! Satan ku oti te too te tattara TeAtua ki hahaaite kootou hakaatoa, ki vvae na tama taualleka raa i taha ma na tama haeo pera ma te tama e ttori na kai raa e vvae na hua na wit raa i taha ma na penu. ");
INSERT INTO nuq_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Emeia Anau e lotu ma akoe Saimon, ki hai mahi te hakatina akoe raa ki se lavaa akoe te tteiho. Te saaita akoe e vaakai muri mai Anau raa, akoe ku tokonaki hoki na taina akoe raa ki hai mmahi na hakattina laatou.” ");
INSERT INTO nuq_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Kito Pita ki meake, “TeAriki, anau e tanattana ki haere no karapusi, ia ki mate ma Akoe!” ");
INSERT INTO nuq_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Tena Jisas ki meake, “Pita, Anau e meatu akoe, i mua te manu tane raa e tani te poo nei, akoe e me ki kore e toru na vahao pera ma akoe se iroa Anau.” ");
INSERT INTO nuq_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tena Jisas ki vahiri ake na disaipol Aia raa ma, “Te saaita Anau ni kauna kootou ki oo no takutaku se hai sileni ni too, ia se hai muri kopu ni too raa, tena se hai taka e uru raa, kootou e isi na mee kootou e hihhai tera kootou se isi?” Kito na tama raa ki meake, “Seai!” ");
INSERT INTO nuq_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tena Jisas ki meake, “Emeia te saaita nei, te tama e isi te muri kopu na sileni raa ku too, tena te tama se isi te paraamoa raa ku kou ake te kaukahu mattoru aia raa ki sui teeraa tama, tena aia ku too na sileni raa no sui he paraamoa ma aia. ");
INSERT INTO nuq_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Anau e meatu maitaname te kina e mmau i roto te Launiu Tapu e tattara ma, ‘Te Tama raa e hukui ma na tama kailallao raa,’ ku hakamaoni i Anau te aho nei, e mee hea na tama ni tattaa i te vahi Anau raa e me ki hakamaoni.” ");
INSERT INTO nuq_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kito na disaipol raa ki meake, “TeAriki! Kira mai! E isi e rua na paraamoa.” Tena Jisas ki meake, “Ku tau peenaa na tattara naa!” ");
INSERT INTO nuq_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jisas ku tiaki te matakaina raa, tena ki haere ma na disaipol Aia raa i te Mouna e hhomo na Oliv raa pera ma Aia ni hahaere i mua raa. ");
INSERT INTO nuq_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Jisas ku tae i te kina raa, tena Aia ki meake na disaipol Aia raa ma, “Kootou ki lotu ki se lavaa kootou te tteiho i na hahaaite.” ");
INSERT INTO nuq_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jisas e haere no mmao hakamarie i taha ma na tama raa, tena Aia ki tuturi i raro no lotu. ");
INSERT INTO nuq_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Aia e lotu ma, “Tamana, kame Akoe e hihai, Akoe ku too te kapu te hakalono lihu nei i taha ma Anau. Teenei seai ma he hihai Anau, e meia teenei he hihai Akoe e hihai ma Anau ki ppena.” ");
INSERT INTO nuq_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tena te ensel i te vaelani raa ku tuu ake no tokonaki Tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jisas ku tipuaina haeo roo, tena Aia ki lotu roo ma na mahi Aia, tena na kahota Aia raa ku nnini i aruna te kerekere raa pera ma ni toto e kkoo. ");
INSERT INTO nuq_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Te saaita Jisas ni lotu no oti, Aia ku mahike i aruna no vaakai atu no kite na disaipol raa ku mmoe se llono roo, e mee na alloha laatou raa e mee roo laatou no matanaennae. ");
INSERT INTO nuq_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kito Jisas ki meake na tama raa, “Kootou e mmoe naea? Mahike i aruna no lotu ki se lavaa kootou te ttiri na hahaaite.” ");
INSERT INTO nuq_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas koi tattara koi te saaita te kanohenua raa ni ttae ake, tena Judas he tama i roto te sanahuru ma rua na disaipol raa ku hakattaki ake na tama raa. Judas e haere ake iaa Jisas raa ma ki mohoni Tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tena Jisas ki meake, “Judas, te mohoni akoe naa e me ki hakari ake te Tamariki te Tama nei i te kanohenua raa?” ");
INSERT INTO nuq_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Na disaipol ni nnoho ma Jisas raa ku kkite hea e me ki kapihi ake raa, tena na tama raa ku vahiri ake Jisas ma, “TeAriki! Eaa, maatou e me ki ppuhu ma na paraamoa maatou nei?” ");
INSERT INTO nuq_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tena he tama na tama raa ku ttuu te katarina te vahi laaua te tama hehekau te pohouru hakanaaniu na maatua raa no hopo. ");
INSERT INTO nuq_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tena Jisas ki meake, “Ku tau peenaa.” Tena Aia ki taohi te katarina te tama raa no hakammau ake no tauareka. ");
INSERT INTO nuq_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kito Jisas ki meake na maatua hakananniu raa, tena na soldia e lollohi te Hare Tapu raa ia ma na tama hakamattua tera ni oo ake ma ki ttaohi Aia raa ma, “Eaa, kootou e oo mai roo ma na paraamoa ia ma na hika ki taohi Anau pera ma Anau he tama tahao haeo? ");
INSERT INTO nuq_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Anau e nnoho ma kootou na aho hakaatoa i roto te Hare Tapu, tena kootou se mee ma ki taohi Anau. Emeia teenei te saaita kootou ki hehekau, te saaita na mahi te pouri raa ku hakamaatua i roto kootou.” ");
INSERT INTO nuq_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Na tama raa ku hakapiki Jisas, tena ki too Tama raa no kkave i te hare te pohouru hakanaaniu na maatua raa, tena Pita ki haere tautari atu hakammao. ");
INSERT INTO nuq_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","E isi te ahi e ura i roto te kina te hare raa, tena Pita ki haere atu no nnoho ma na tama e nnoho i te kina te ahi raa. ");
INSERT INTO nuq_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Te saaita te taukupu hehekau raa ni kite Pita e noho i te kina te ahi raa, te taukupu raa ku kkira hakamattonu ake roo iaa Pita, tena ki meake, “Te tama nei hoki e hahaere ma Jisas.” ");
INSERT INTO nuq_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Emeia Pita e kore, tena ki meake te hine raa ma, “Anau se iroa te Tama naa.” ");
INSERT INTO nuq_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tena se roroa hoki e isi te tanata ku kkira ake no maatino Pita, tena ki meake, “Akoe hoki e hai i roto na tama raa!” Emeia Pita e kore, tena ki meake te tanata raa ma, “Seai, anau se hai na tama naa.” ");
INSERT INTO nuq_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Saaita raa ku roroa ake hakamaarie, tena teeraa tama hoki ku hamakkau ake pera ma, “Te tama nei e hahaere hakamaoni ma Jisas, maitaname aia he tama i Galili.” ");
INSERT INTO nuq_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tena Pita ki meake te tanata raa, “Anau se iroa hea akoe e tattara naa.” Te saaita naa koi te manu tane raa ku tani. ");
INSERT INTO nuq_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tena Jisas ki hakatike no kkira tonu ake roo iaa Pita, tena Pita ku maanatu na tattara TeAriki raa ni tattara ake aia raa ma, “I mua te manu tane raa e tani te poo nei, akoe e me ki kore e toru na vahao pera ma akoe se iroa Anau.” ");
INSERT INTO nuq_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pita ku aroha roo, tena aia ki haere i aho no tanitani roo. ");
INSERT INTO nuq_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Na tama e lollohi Jisas raa ku tataussua Jisas, tena ki riki Tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Na tama raa e nnoa na karemata Jisas raa, tena ki meake Tama raa ma, “Tini ma koai te tama ni lliki Akoe raa?” ");
INSERT INTO nuq_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kito na tama raa ki hai ake tammaki roo na tattara haeo iaa Jisas. ");
INSERT INTO nuq_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Te mee raa ku maarama, tena na tama hakamattua raa, na maatua hakananniu raa ia ma na tama poroporo na tuaa raa ku kkutu hakaatoa, tena na tama raa ki kou ake Jisas no hakatuu i mua te kuturana raa. ");
INSERT INTO nuq_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kito na tama raa ki meake, “Mee mai, Akoe ko te Mesaia?” Kito Jisas ki meake, “Kame Anau e meatu, kootou e me ki se lavaa te hakattina Anau, ");
INSERT INTO nuq_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","tena kame Anau e vahiri atu, kootou e me ki se lavaa te mee mai hoki. ");
INSERT INTO nuq_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Emeia te saaita nei te Tamariki te Tama nei e me ki noho i te vahi laaua TeAtua Hai mahi raa.” ");
INSERT INTO nuq_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tena na tama raa hakaatoa ki meake, “Kaa Akoe ko te Tamariki TeAtua?” Kito Jisas ki meake, “Teenaa koi kootou e illoa naa.” ");
INSERT INTO nuq_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tena na tama raa ki meake, “Taatou se hihhai ki too ni tattara alaa tama hoki! Taatou hokotaatou e llono na tattara te Tama nei!” ");
INSERT INTO nuq_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tena na tama te kuturana raa hakaatoa ku mahike i aruna no too Jisas no kkave iaa Pailat raa, ");
INSERT INTO nuq_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","tena na tama raa ku kaamata no hatuhatu na malliu laatou iaa Jisas ma, “Te Tama nei e hahaivi ma ki mee na tama raa ki hakataukaa ma te taumani, tena ki mee na tama raa ki se lavaa te sui ake na takis laatou raa i te tuku i Rom raa, tena Aia e mee mai Hokoia ma Aia ko te Mesaia ia ma he tuku.” ");
INSERT INTO nuq_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kito Pailat ki vahiri ake Jisas ma, “Akoe ko te tuku na Jiu?” Tena Jisas ki meake, “Teenaa koi akoe ku mee mai naa.” ");
INSERT INTO nuq_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kito Pailat ki meake na maatua hakananniu raa laatou ma te kanohenua raa ma, “Anau se hai mee e lave ki meatu ma te tama nei e sara.” ");
INSERT INTO nuq_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Emeia na tama raa e vanake ake koi ma, “Te Tama nei e haere vaa roto Judia raa hakaatoa ma ki hakatike na hakataakoto na tama raa ma na akoako Aia raa. Aia e kaamata mai i Galili, ia tena vahao nei Aia ku tae mai i te kina nei.” ");
INSERT INTO nuq_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat e rono na tattara na tama raa, tena aia ki vahiri ake ma, “Teenei he tama i Galili?” ");
INSERT INTO nuq_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Te saaita Pailat ni iroa pera ma Jisas he tama i te henua Herot e rorohi raa, tena aia ki kauna Jisas ki haere iaa Herot raa, e mee Herot e noho te saaita naa hoki i Jerusalem. ");
INSERT INTO nuq_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herot ku hihia roo te saaita aia ni kite Jisas, e mee aia ni rono tammaki na mee i te vahi Jisas, tena aia hoki ko na hahaivi roo ma ki kite Jisas. Aia e hihai ma ki kite Jisas e ppena he mirakol. ");
INSERT INTO nuq_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tena Herot ku vahihhiri ake Jisas tammaki na mee, e meia Jisas e noho hemuu koi, se hai tattara roo e meake. ");
INSERT INTO nuq_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tena na maatua hakananniu raa laatou ma na tama poroporo na tuaa raa ku oo ake no ttuu i mua no hatu na malliu laatou iaa Jisas. ");
INSERT INTO nuq_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herot ma na soldia aia raa ku tataussua Jisas, tena ki tattara haeo roo i Tama raa, tena laatou ki hakauru ake na hekau taualleka roo iaa Jisas, tena ki kauna Tama raa ki vaakai iaa Pailat raa. ");
INSERT INTO nuq_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tena te aho naa koi Pailat laaua ma Herot ku ssoa; i mua raa laaua e haeo roo hokolaaua. ");
INSERT INTO nuq_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat ku kanna ake na maatua hakananniu raa, na tama hakamattua raa ia ma te kanohenua raa ki hakkutu ake hakaatoa, ");
INSERT INTO nuq_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","tena aia ki meake na tama raa, “Kootou e kou mai te Tama nei i anau, tena ki mee ma te Tama nei e hakattaki sara na tama. Tena anau e lahulahu te Tama nei i mua na karemata kootou hakaatoa, tena anau e kite pera ma te Tama nei se isi te mee e sara ma na tattara haeo kootou ni tattara mai raa. ");
INSERT INTO nuq_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot hoki se hai tattara e kou mai ma te Tama nei e sara, e mee aia e kauna ria mai te Tama nei ki vaakai mai taatou. Te Tama nei se isi te mee e sara ki lavaa taatou te taa Aia ki mate. ");
INSERT INTO nuq_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tena anau e me ki riki koi te Tama nei, tena ku hakattana Aia ki haere.” ");
INSERT INTO nuq_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Te saaita na Kai na Pasova hakaatoa, Pailat e me ki hakattana he tama karapusi. ");
INSERT INTO nuq_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tena te kanohenua raa hakaatoa ku hakaioo ake ma, “Taa Tama naa ki mate! Hakattana Barabas ma maatou!” ");
INSERT INTO nuq_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas e ponotia i roto te hare karapusi e mee aia e usuusu te kanohenua raa ki se hakallono te taumani, tena aia e taa hoki te tama no mate.) ");
INSERT INTO nuq_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat e hihai koi ma ki hakattana Jisas, tena aia ki tattara hakaraoi ake hoki te kanohenua raa. ");
INSERT INTO nuq_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Emeia na tama raa e vaa ake koi ma, “Tii Tama naa i aruna te kros! Tii Tama naa i aruna te kros!” ");
INSERT INTO nuq_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tena Pailat ku tattara ake na tama raa te hakatautoru na vahao ma, “Kaa he sara peehee te Tama nei e ppena? Anau se hai mee e lave ki mee ma te Tama nei e sara ki lavaa te Tama nei te taia ria ki mate. Anau e me ki riki koi te Tama nei, tena ku hakattana Aia ki haere.” ");
INSERT INTO nuq_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Emeia na tama raa e vaa ake hakamaroa roo pera ma Jisas e tau te ttii ria i aruna te kros, tena i te hakaoti roo na tama raa ku too hea laatou ni ttani ake raa. ");
INSERT INTO nuq_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tena Pailat ku tuku ake hea te kanohenua raa e kainno ake aia raa. ");
INSERT INTO nuq_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pailat e hakattana Barabas, te tama te kanohenua raa e hirihiri raa; teenaa ko te tama tera ni ponotia i roto i te hare karapusi e mee aia e usuusu na tama ki se hakallono te taumani raa, tena ki taa hoki te tama no mate raa, tena Pailat ki kou ake Jisas i na rima te kanohenua raa ki ppena hea laatou e mannatu ki ppena raa. ");
INSERT INTO nuq_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kito na soldia raa ki hakattaki Jisas i taha, tena na tama raa ki oo no ttiri te tama te matakaina Sairini, te inoa aia raa ko Saimon, tena Saimon e hamai peeraa i na henua i na vahi raa, tena aia e haere ki haere ake i te matakaina raa. Kito na tama raa ki ttaohi Saimon no hakapiri ake te kros raa i aruna te tama raa, tena ki meake te tama raa ki amo atu te kros raa vaa muri Jisas. ");
INSERT INTO nuq_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","He kanohenua e rahi roo e tauttari Jisas, tena i roto te kanohenua raa e isi na hhine e haere tanittani, tena ki taa na tinotama laatou hokolaatou i te alloha laatou iaa Jisas. ");
INSERT INTO nuq_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jisas e huri ake no meake na hhine raa ma, “Na hhine i Jerusalem! Auu se ttani ma kootou e alloha Anau, e meia ttani ma kootou ia ma na tamalliki kootou raa. ");
INSERT INTO nuq_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Maitaname e isi na aho koi oo mai, tena na tama e me ki tattara ma, ‘Na hhine ni se hai tamalliki ia ma na hhine se hai tamalliki ni hannau raa ia ma na hhine se hai tamalliki ni anaana raa e me ki hakatapu ria!’ ");
INSERT INTO nuq_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Teenaa ko te saaita na tama raa e me ki meake na mouna palluna raa ma, ‘Hina mai i aruna maatou!’ tena ku meake na tutu raa ma, ‘Hakammuni maatou!’ ");
INSERT INTO nuq_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kame na tama e lavaa te kou mai na hakalono llihu peenei Anau te Tama e ssau pera ma he laakau e homo mata ora nei raa, tena kaa hea e me ki kapihi atu kootou na tama e ssau pera ma ni laakau ku mmate raa?” ");
INSERT INTO nuq_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Na tama raa e hakattaki ake Jisas ma tokorua hoki na taanata kailallao ma ki taa ki mmate. ");
INSERT INTO nuq_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Te saaita na tama raa ni ttae i te kina e hui ma, “Te ivi te Pohouru raa”, na tama raa ku ttii Jisas ma te tokorua na taanata raa. Na tama raa e ttii teeraa tama i te vahi laaua, tena teeraa tama i te vahi se laaua Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tena Jisas ki meake, “Tamana, ssirihia hea na tama nei e ssara. Na tama nei se illoa hea laatou e ppena raa.” Na soldia raa e ttahao huhu na hatu ma koai te tama e me ki too na kaukahu Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Te kanohenua raa e ttuu i te kina raa no mmata na mee nei, te saaita na tama hakamattua na Jiu raa ni tataussua ake Jisas ma, “Te Tama nei e tokonaki alaa tama; tiaki ki mmata ma Aia e lavaa te tokonaki Aia Hokoia kame Aia ko te Mesaia TeAtua e hirihiri raa!” ");
INSERT INTO nuq_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Na soldia raa hoki ku tataussua ake Jisas. Na tama raa e oo ake no kou ake te wain e mmara raa iaa Jisas, ");
INSERT INTO nuq_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","tena ki meake, “Tokonaki Akoe Hokkoe kame Akoe ko te Tuku na Jiu.” ");
INSERT INTO nuq_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na tama raa e tattaa na tattara nei i aruna te kros ma, “TEENEI ko TE TUKU NA JIU.” ");
INSERT INTO nuq_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","He tama te tokorua na tama kailallao e mmau i aruna na kros raa e hai ake hakahaeo roo iaa Jisas ma, “Akoe seai ma ko te Mesaia? Tokonaki Akoe Hokkoe, tena ku tokonaki hoki maaua.” ");
INSERT INTO nuq_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tena teeraa tama ki meake, “Akoe se mataku TeAtua? Te hakalono llihu akoe e too naa e ssau pera ma te hakalono llihu Aia raa hoki. ");
INSERT INTO nuq_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Taaua e tonu te too na hakalono llihu nei, e mee taaua e ppena na mee e ssara, e meia te Tama nei se isi te mee e sara e ppena.” ");
INSERT INTO nuq_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tena aia ki meake Jisas ma, “Jisas, maanatu mai anau te saaita Akoe e Tuku raa.” ");
INSERT INTO nuq_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Kito Jisas ki meake te tama raa, “Anau e meatu te hakamaoni. Te aho nei koi, akoe e me ki noho ma Anau i Paradais.” ");
INSERT INTO nuq_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","45 Te mee raa kame ku tae te laa latea te saaita te laa raa ku pouri, tena te henua raa hakaatoa ku pouri roo haere no tae te toru te hiahi, tena te paamaro e tootoo i roto te Hare Tapu raa ku mahaa rua. ");
INSERT INTO nuq_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tena Jisas ku kanna hakamaroa ma, “Tamana! Anau e kou atu TeAnana Anau nei ki moe na rima Akoe.” Aia e tattara peenei, tena ki mate. ");
INSERT INTO nuq_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Te tama hakamaatua na soldia raa e kite te mate Jisas raa, tena aia ki hakammaha ma, “Hakamaoni roo, teenei he Tama tauareka.” ");
INSERT INTO nuq_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Te saaita te kanohenua ni hakkutu ake i te kina raa ma ki mmata Jisas e ttii ria raa ni kkitte na mee roo hakaatoa raa, na tama raa ku vakkai i na hare laatou raa, tena ku alloha roo no tukituki na hatahata laatou. ");
INSERT INTO nuq_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Na tama e illoa roo Jisas raa hakapaa ma na hhine ni kaamata i Galili no tauttari Jisas raa e ttuu hakammao no matamata. ");
INSERT INTO nuq_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","51 Teeraa he tama e hui ma ko Josep he tama i te matakaina Arimatea i roto Judia raa. Te tama raa he tama tauareka, ia he tama na tama e hakammaha, tena aia e noho no hakattari ma te Hakamaatua ana i te Vaelani raa ki hamai. Niaina ma aia he tama i roto te kuturana na tama hakatonutonu na Jiu raa, e meia aia se hakatina roo na hakataakoto na tama raa ia ma na mee na tama raa e ppena raa. ");
INSERT INTO nuq_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Josep e haere no mmata Pailat, tena ki kainno ake ma aia e me ki too te tinotama Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tena Josep ki turi iho te tinotama Jisas raa i raro no mmini te tinotama raa ma na paamaro, tena ki kkave no ppono i roto te rua na tama ni keri i te kina na hatu matakkau raa, tena te rua naa hoki ni se hai tama e mate ni moe i mua. ");
INSERT INTO nuq_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Teenaa ko te aho rima, tena te Sabat raa hoki ku mee ki ttae. ");
INSERT INTO nuq_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Na hhine ni kaamata i Galili no tauttari Jisas raa ku oo laatou ma Josep no kkite te rua raa, tena ki kkite hoki ma Josep e hakamoe peehee te tinotama Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tena na hhine raa ki vakkai i hare no tanattana na karena ia ma na lloo mannoni ki amuhi te tinotama Jisas. Na tama raa e hamalollo i te aho te Sabat raa, ki tauttari hea na tuaa raa e hihai laatou ki ppena. ");
INSERT INTO nuq_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Te tahata roo te aho te latapu; na hhine raa ku oo i te taruma raa, tena ki too na karena ia ma na lloo mannoni laatou ni tanattana raa. ");
INSERT INTO nuq_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Na hhine raa e oo no kkite te hatu ni ppui te totoka te taruma raa ku oti te hakatakape ria i taha, ");
INSERT INTO nuq_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","tena laatou ki oo no uru i roto te taruma raa; e meia laatou ku se kkite te tinotama TeAriki Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Na hhine raa ku ttuu no mamannatu hokolaatou, tena te saaita naa koi e rua na taanata e uru na kaukahu e kivakiva roo ku ttuu ake i te vahi laatou. ");
INSERT INTO nuq_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Na hhine raa ku mattaku no hakammaru i raro, tena tokorua raa ki meake na hhine raa, “Aiea kootou e sesee te Tama e ora raa i te kina na tama e mmate nei naea? ");
INSERT INTO nuq_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Te Tama naa ku seai; Aia ku oti te ora muri. Kootou e mannatu hea Aia ni tattara atu kootou i Galili pera ma, ");
INSERT INTO nuq_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Na tama hai ssara raa e me ki hakapiki te Tamariki te Tama nei, tena ku ttii Tama raa i aruna te kros raa, tena te aho tana hakatoru raa Aia e me ki mahike muri no ora.’ ” ");
INSERT INTO nuq_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Na hhine raa ku mannatu na tattara Jisas raa, ");
INSERT INTO nuq_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","tena laatou ki oo i taha ma te taruma raa no tattara ake te sanahuru ma tahi na disaipol Jisas raa ia ma alaa hakattina ana i na mee hakaatoa laatou ni kkite raa. ");
INSERT INTO nuq_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Na hhine raa ko Meri Makdala, Joana ia ma Meri te tinna Jems raa. Na hhine raa ia ma alaa hhine hoki tera ni oo laatou raa ku tattara ake na mee raa hakaatoa i na aposol raa. ");
INSERT INTO nuq_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Emeia na aposol raa e mannatu ma hea na hhine raa e tattara ake raa seai ma ni tattara hakamaoni, tena na aposol raa se hakattina hoki na tattara na hhine raa. ");
INSERT INTO nuq_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kito Pita ki mahike i aruna no tere i te kina te taruma raa, tena aia ki huru i raro no kite koi na paamaro na tama raa ni mmini Jisas raa. Tena aia ki vaakai i hare, ia e maaharo hoki hea ni kapihi ake raa. ");
INSERT INTO nuq_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Te aho naa hoki e rua na disaipol Jisas raa ku oo i te matakaina Emeus raa, he matakaina e hitu na mael te mmao aia i taha ma Jerusalem, ");
INSERT INTO nuq_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","tena tokorua raa e haere tattara hokolaaua na mee hakaatoa ni kapihi ake raa. ");
INSERT INTO nuq_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tokorua raa e tattara, tena ki vahihhiri hokolaaua, tena Jisas Hokoia ku haere hakataapiri ake no hahaere ma tokorua raa. ");
INSERT INTO nuq_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tokorua raa e kkite Tama raa, e meia laaua se illoa ma teeraa ko Jisas. ");
INSERT INTO nuq_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tena Jisas ki vahiri ake tokorua raa, “Hea koorua e haere tattara hokkoorua naa?” Tena tokorua raa ku ttuu hemuu no kira hakaalloha ake na karemata laaua raa. ");
INSERT INTO nuq_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tena te tama e hui ma ko Kliopas raa ki meake, “Eaa, akoe ko te Tama hokotahi koi tera se iroa hea ni kapihi mai i roto na aho ku llaka raa?” ");
INSERT INTO nuq_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tena Jisas ki vahiri ake ma, “Ni mee peehee?” Kito tokorua raa ki meake, “Na mee tera ni kapihi ake iaa Jisas te Tama i Nasaret raa. Te Tama nei he profet, tena TeAtua ia ma na tama hakaatoa e hakattina pera ma te Tama nei e isi na mahi i roto na tattara Aia ia ma na mee hakaatoa Aia ni ppena raa. ");
INSERT INTO nuq_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Na maatua hakananniu ma na tama hakamattua maatou raa e kou ake te Tama raa i te tuku i Rom raa ki kou ake he tattara laatou ki taa Tama raa ki mate, tena ma laatou ki ttii Tama raa i aruna te kros. ");
INSERT INTO nuq_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tena maatou e hakattina pera ma Aia ko te Tama e me ki hakattana na tama Israel raa! I aruna na mee nei hakaatoa, teenei ko te hakatoru na aho tera na mee nei ni kapihi mai. ");
INSERT INTO nuq_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Emeia e isi na hhine i roto te kuturana maatou nei e mee maatou no oho; na tama raa e oo te tahata roo i te kina te taruma raa, ");
INSERT INTO nuq_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","tena laatou ku se kkite te tinotama Tama raa. Kito na tama raa ki vakkai mai no tattara mai ma laatou e kkite karemata roo na ensel raa e tattara ake ma te Tama raa ku oti te ora muri. ");
INSERT INTO nuq_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tena alaa tama te kuturana maatou nei ku oo hoki i te taruma raa no kkite pera ma te taruma raa ku tuu vare hakamaoni e ssau koi pera ma na hhine raa ni tattara mai raa.” ");
INSERT INTO nuq_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tena Jisas ki meake tokorua raa, “Koorua e vvare roo, koorua e hainatta roo te hakattina na tattara hakaatoa tera na profet raa ni tattara mai raa! ");
INSERT INTO nuq_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Eaa, te Mesaia raa se tau te too na hakalono llihu nei hakaatoa, tena ki oti Aia ku too na mahi Aia i aruna?” ");
INSERT INTO nuq_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kito Jisas ki hakamaarama ake tokorua raa na tattara hakaatoa tera e tattara i te vahi Aia i roto te Launiu Tapu raa, kaamata te launiu Moses raa ia ma na tattara hoki na profet raa hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Te saaita laatou ku tappiri i te matakaina laatou e oo raa, Jisas ku haere pera ma Aia e me ki haere hakaraka; ");
INSERT INTO nuq_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","e meia tokorua raa e taohi Aia, tena ki meake, “Nnoho taatou; te laa raa ku mee ki huru, ia te mee raa hoki ku haere ki pouri.” Tena Jisas ki oo ma tokorua raa no nnoho laatou. ");
INSERT INTO nuq_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Jisas ku noho i raro ma ki kkai laatou, tena Aia ki too te haraoa raa no hakatapu, tena ki ttohi te haraoa raa no kou ake tokorua raa. ");
INSERT INTO nuq_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tena na karemata tokorua raa ku tallaki, tena laaua ku illoa ma teeraa ko Jisas, e meia Tama raa ku hakateki koi no seai. ");
INSERT INTO nuq_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kito tokorua raa ki tattara hokolaaua ma, “Eaa, na tattara Tama raa se ssau pera ma he ahi e ura i roto taaua te saaita Aia ni tattara mai, tena ki hakamaarama mai hoki na tattara te Launiu Tapu raa i aruna te mateara?” ");
INSERT INTO nuq_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Te saaita naa koi tokorua raa ku mahhike i aruna no vakkai i Jerusalem no kkite te sanahuru ma tahi na disaipol raa e kkutu ma alaa tama. ");
INSERT INTO nuq_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tena na tama raa ki tattara ake tokorua raa ma, “TeAriki ku ora muri hakamaoni! Tama raa e hakkite ake Aia iaa Saimon!” ");
INSERT INTO nuq_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tena tokorua raa ku tattara ake na tama raa hea ni kapihi ake laaua i aruna te mateara raa ia ma te saaita hoki Jisas ni ttohi te haraoa raa, tena laaua ku illoa ma teeraa ko TeAriki. ");
INSERT INTO nuq_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tokorua raa koi tattara ake koi na tama raa, tena Jisas ku hakateki no tuu ake i lottonu na tama raa, tena ki meake, “Te noho laoi ki nnoho ma kootou.” ");
INSERT INTO nuq_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Na tama raa ku mattaku ma laatou e kkite te tipua. ");
INSERT INTO nuq_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Tena Jisas ki meake na tama raa, “Kootou e mattaku naea? Aiea kootou e mamannatu tammaki i roto na hakataakoto kootou naea? ");
INSERT INTO nuq_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kira mai na rima ia ma na vae Anau nei ki kkite kootou pera ma teenei ko Anau hakamaoni. Taohi te tinotama Anau nei ki illoa kootou, maitaname te tipua se isi na punnohi ia ma na ivi peenei ma Anau e isi nei.” ");
INSERT INTO nuq_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Aia e tattara ake peenei, tena ki huri ake na rima ia ma na vae Aia raa. ");
INSERT INTO nuq_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Na tama raa se hakattina koi, e meia laatou e hihhia roo, tena e isi na hakataakoto, kito Jisas ki vahiri ake ma, “Kootou e isi na kai e mmoe i te kina nei ki kkai?” ");
INSERT INTO nuq_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tena na tama raa ki kou ake te punnohi te ika e moa raa, ");
INSERT INTO nuq_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","tena Jisas ki too te ika raa no kai i mua na tama raa hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tena Jisas ki meake na tama raa, “Teenei ko na tattara roo Anau ni tattara atu te saaita Anau koi nnoho ma kootou raa. Na tattara hakaatoa i roto na Tuaa Moses raa, na tattara na profet raa ia ma te launiu na Rue tera e tattara i te vahi Anau raa e me ki oo mai no hakamaoni.” ");
INSERT INTO nuq_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tena Jisas ki taaraki na hakataakoto na tama raa ki illoa na tattara te Launiu Tapu raa. ");
INSERT INTO nuq_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tena Aia ki meake, “Teenei hea te Launiu Tapu raa e tattara: te Mesaia raa e me ki hakalono llihu, tena e toru na aho i muri Aia e me ki ora muri, ");
INSERT INTO nuq_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","tena na tama e me ki kaamata i Jerusalem no takutaku ake na kanohenua hakaatoa i te vahi te ttike i taha ma na hai sara ia ma te ssirihia na hai sara i te inoa te Mesaia. ");
INSERT INTO nuq_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kootou e kkite karemata na mee nei hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tena Anau Hokonnau e me ki kou atu hea te Tamana raa ni tattara hakamaoni atu ma Aia e me ki kou atu kootou raa. Emeia kootou ki nnoho no hakattari i roto te matakaina e rahi nei ki ttae roo te saaita na mahi i aruna raa e ttae atu kootou.” ");
INSERT INTO nuq_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tena Jisas ki hakattaki na tama raa i taha ma te matakaina raa no taapiri i Betani, tena Aia ki ssau na rima Aia i aruna no hakatapu na tama raa. ");
INSERT INTO nuq_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Te saaita Aia koi hakatapu koi na tama raa, Aia ku haere i taha ma na tama raa no too ria no kkave i te vaelani. ");
INSERT INTO nuq_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kito na tama raa ki lotu ake Tama raa, tena ku hihhia roo no vakkai i Jerusalem, ");
INSERT INTO nuq_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","tena ki nnoho na aho naa hakaatoa i roto te Hare Tapu raa no hakammaha ake TeAtua.");
INSERT INTO nuq_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Te Tattara raa ko na noho mai avare i mua na mee hakaatoa ni ttipu ake; te Tattara raa e nnoho laaua ma TeAtua, tena te Tattara raa ko TeAtua koi. ");
INSERT INTO nuq_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Te Tattara raa e nnoho laaua ma TeAtua i te kaamata roo. ");
INSERT INTO nuq_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","TeAtua e pena na mee hakaatoa i na mahi Tama raa; ia se hai mee i roto te maarama nei ni tipu ake ma te Tattara raa se iroa. ");
INSERT INTO nuq_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Te Tattara raa ko te tahito te ora, tena te Ora raa e kou mai te Maahina i na tama hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tena te Maahina raa e hakamaahina na kina e pouri raa, tena te pouri raa se lavaa hoki te uhi te Maahina raa ki se maahina iho. ");
INSERT INTO nuq_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","TeAtua e kauna ria mai Jon te tama hakatae na tattara Aia raa ");
INSERT INTO nuq_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ki hamai no tattara ake na tama raa i te vahi te Maahina raa, ki lavaa na tama hakaatoa e llono raa te hakattina. ");
INSERT INTO nuq_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon seai ma ko te Maahina raa; e meia aia e hamai ki tattara ake na tama i te vahi te Maahina raa. ");
INSERT INTO nuq_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Teenei ko te Maahina hakamaoni roo, te Maahina nei e hamai ki hakamaahina i aruna na tama hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Te Maahina raa ni noho i roto te maarama nei, ia niaina ma TeAtua e pena na mee hakaatoa i na mahi Tama raa, e meia te maarama nei hakaatoa se illoa laoi Tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tama raa ni haere i te henua Aia ni matua mai raa, e meia na tama roo te matakaina Aia raa se hihai ki too Tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Emeia e isi na tama ni too Aia, tena ki hakattina hoki Tama raa, tena Aia ki kou ake na mahi na tama raa ki mee pera ma ni tamalliki TeAtua. ");
INSERT INTO nuq_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Na tama raa se mee pera ma ni tamalliki TeAtua i na mahi koi laatou ia ma e mee laatou e hannau mai pera ma ni tamalliki na tama i te maarama nei, e meia TeAtua Hokoia ko te Tamana na tamalliki raa. ");
INSERT INTO nuq_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Te Tattara raa e hamai no tipu tama, tena ki hamai ma na mahi hai mmahi no huri mai te hakamaoni TeAtua, tena Aia e nnoho hoki ma maatou. Maatou e kkite na mahi Aia, na mahi tera Aia ni too pera ma ko te tautahi Tama koi TeAtua. ");
INSERT INTO nuq_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon e tattara hoki i te Tama raa. Aia e tattara hakamaroa ma, “Teenei ko te tama Anau ni tattara atu kootou te saaita anau ni tattara ma, ‘Tama raa e me ki hamai i muri anau, e meia Aia e hakanaaniu roo i aruna anau, maitaname Aia ko na noho mai roo i mua anau ni haanau mai.’ ” ");
INSERT INTO nuq_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Taatou hakaatoa e hakatapu ria, e mee te laoi Tama raa e isi raa, tena Aia e tauhano te hakatapu taatou na vahao roo hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","TeAtua e kou ake na tuaa raa iaa Moses, e meia te laoi ia ma te hakamaoni raa e hamai ma Jisas Krais. ");
INSERT INTO nuq_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Se hai tama ni kite TeAtua. Te Tamariki hokotahi raa koi, te Tama e ssau roo pera ma TeAtua tera e noho i te vahi Tamana, tena ki hakari mai taatou ki illoa TeAtua raa. ");
INSERT INTO nuq_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Na tama hakamattua na Jiu i roto Jerusalem raa e kauna na maatua ia ma na tama i te kaha Levi raa ki oo no vahiri ake Jon ma, “Koai akoe?” ");
INSERT INTO nuq_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ia Jon se kkaro hoki te tattara, tena aia ki tattara hakamatahua ake na tama raa ma, “Anau seai ma ko te Mesaia.” ");
INSERT INTO nuq_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kito na tama raa ki vahiri ake hoki ma, “Tena kaa akoe koai? Akoe ko Elaija?” Tena Jon ki meake, “Seai, anau seai ma ko Elaija.” Kito na tama raa ki vahiri ake hoki ma, “Akoe ko te Profet maatou e hakattari raa?” Tena Jon ki meake, “Seai hoki.” ");
INSERT INTO nuq_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kito na tama raa ki meake, “Tena iaa tattara mai ma akoe koai. Maatou e hihhai ki too ni tattara ki oo ma maatou no meake na tama ni kauna ria mai maatou raa. Ni tattara peehee akoe e isi ki tattara mai i te vahi akoe?” ");
INSERT INTO nuq_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tena Jon ki meake te tattara e mmau i roto te launiu profet Aisaia ma, “Anau ko ‘te reo te tama e tattara i roto te kina e tuu mahoa raa ma: Tanattana te mateara TeAriki ki hamai vaa aruna!’ ” ");
INSERT INTO nuq_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Kito na tama na Farisi ni kauna ki oo ake raa ");
INSERT INTO nuq_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ku vahiri ake Jon ma, “Kame akoe seai ma ko te Mesaia, ia seai ma ko Elaija, ia seai ma he profet, tena kaa akoe e hakoukou tapu na tama naea?” ");
INSERT INTO nuq_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tena Jon ki meake, “Anau e hakoukou tapu na tama ma te vai, e meia e isi te tama e tuu i roto kootou tera kootou se illoa. ");
INSERT INTO nuq_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tama naa e me ki hamai i muri anau, e meia anau se tau hoki te ui na taka Aia e uru raa.” ");
INSERT INTO nuq_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Na tattara nei e kapihi mai i Betani i te vahi te anake i te riva Jordan raa; i te kina Jon e hakoukou tapu na tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Te aho taiao raa Jon ku kite Jisas e haere ake aia, tena ki meake, “Teenei ko te Sipsip TeAtua tera e me ki ssoro na hai sara te maarama nei raa i taha! ");
INSERT INTO nuq_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Teenei ko te Tama anau e tattara te saaita anau ni tattara atu ma, ‘E isi te tama e me ki hamai i muri anau, e meia Aia e hakanaaniu roo i aruna anau, maitaname Aia ko na noho mai roo avare i mua anau ni haanau mai.’ ");
INSERT INTO nuq_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Anau se iroa hoki ma te Tama raa koai, e meia anau e hamai no hakoukou tapu kootou ma te vai ma ki lavaa kootou na tama Israel raa te illoa Tama raa.” ");
INSERT INTO nuq_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Tena Jon ki tattara ake na tama raa ma, “Anau e kite TeAnana Tapu raa e llee mai i raro pera ma he rupe no toko i aruna Tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tena anau se iroa ma teeraa ko te Tama raa, e meia TeAtua, te Tama ni kauna ria mai anau ki hakoukou tapu ma te vai raa ni tattara mai anau ma, ‘Akoe e me ki kite TeAnana Tapu raa e llee mai i raro no toko i aruna he tama. Tena te Tama naa ko te tama e me ki hakoukou tapu ma TeAnana Tapu raa.’ ” ");
INSERT INTO nuq_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Tena Jon ki meake, “Anau ku kite te hakkatu nei, tena anau e meatu kootou pera ma te Tama nei ko te Tamariki TeAtua.” ");
INSERT INTO nuq_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Te aho taiao raa Jon ku tuu hoki i te kina raa ma tokorua na disaipol aia raa, ");
INSERT INTO nuq_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ia te saaita aia ni kite Jisas ku haere hakaraka, tena aia ki meake tokorua raa ma, “Teeraa ko te Sipsip TeAtua!” ");
INSERT INTO nuq_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tokorua na disaipol raa e llono na tattara Jon raa, tena tokorua raa ki tauttari Jisas. ");
INSERT INTO nuq_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisas e hakatike no kite tokorua raa e tauttari Aia, tena Aia ki vahiri ake, “Koorua e sesee te aa?” Tena tokorua raa ki meake, “Rabai, Akoe e nohonoho vaa hee?” (Rabai e mee ma he “Tisa”.) ");
INSERT INTO nuq_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tena Jisas ki meake, “Oo mai ki kkite koorua.” (Te mee raa kame ku tae te haa te hiahi.) Kito tokorua raa ki oo laatou ma Jisas no kkite te kina Tama raa e nohonoho raa, tena tokorua ki nnoho laatou ma Tama raa te aho naa hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Teeraa tama tokorua raa ko Andru, te taina Saimon Pita raa. ");
INSERT INTO nuq_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tena Andru ki haere no ttiri Saimon Pita, tena aia ki meake, “Maaua e kkite te Mesaia.” (Te tattara nei e mee ma “Krais”.) ");
INSERT INTO nuq_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tena aia ki too Saimon no oo laaua i te kina Jisas e noho raa. Jisas e kkira ake Saimon, tena ki meake, “Te inoa akoe raa ko Saimon te tamariki Jon, e meia akoe e me ki hui Sifas.” (Te inoa nei e mee ma “he hatu”.) ");
INSERT INTO nuq_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Te aho taiao raa Jisas ku maanatu ma ki haere i Galili. Aia ku ttiri Filip, tena ki meake, “Tautari mai Anau!” ");
INSERT INTO nuq_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip he tama i Betsaida, te matakaina Andru laaua ma Pita raa. ");
INSERT INTO nuq_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip e haere no ttiri Nataniel, tena ki meake, “Maatou ku kkite te Tama Moses e taataa i roto te launiu na tuaa ia ma te tama hoki na profet raa ni tattaa mai raa. Tama raa ko Jisas te tamariki Josep, te tama i Nasaret.” ");
INSERT INTO nuq_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Kito Nataniel ki meake, “Aiea e isi te mee tauareka e lavaa te hamai i roto Nasaret?” Tena Filip ki meake, “Hamai ki kite akoe.” ");
INSERT INTO nuq_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Te saaita Jisas ni kite Nataniel e haere ake, Aia ku tattara ake i te vahi tama raa ma, “Teenei he tama hakamaoni Israel, tama nei se lavaa hoki te mariu!” ");
INSERT INTO nuq_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Kito Nataniel ki vahiri ake Jisas, “Akoe e iroa peehee anau?” Tena Jisas ki meake, “Anau e kite akoe e noho i raro te laakau fik raa i mua Filip ni haere atu no meatu akoe.” ");
INSERT INTO nuq_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Kito Nataniel ki meake, “Rabai, Akoe ko te Tamariki TeAtua! Akoe ko te Tuku Israel!” ");
INSERT INTO nuq_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Tena kito Jisas ki meake Nataniel, “Akoe ku hakatina koi e mee Anau e meatu ma Anau e kite akoe e noho i raro te laakau fik? Akoe e me ki kite na hakkatu e hakananniu i aruna te mee nei!” ");
INSERT INTO nuq_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tena Jisas ki meake na tama raa, “Anau e tattara atu kootou te hakamaoni: kootou e me ki kkite te vaelani raa e taaraki, tena na ensel TeAtua raa e oo i aruna, tena ki oo mai i raro i aruna te Tamariki te Tama nei.” ");
INSERT INTO nuq_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","E isi te avana e me ki ttaohi i te matakaina i Kana i roto Galili i te aho tana hakatoru raa. Te tinna Jisas raa ku tae i te kina raa, ");
INSERT INTO nuq_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","tena na tama raa e aru hoki Jisas ma na disaipol Aia raa ki oo ake i te kai te avana raa. ");
INSERT INTO nuq_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Na wain raa ku mmaha hakaatoa, tena Meri ki haere no meake Jisas ma, “Na tama raa ku se hai wain e me ki unu.” ");
INSERT INTO nuq_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kito Jisas ki meake, “Taku tinna, akoe se tau te mee mai Anau hea Anau e me ki pena, maitaname te saaita hakamaoni Anau ki ppena na mee raa se ki tae.” ");
INSERT INTO nuq_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tena te tinna Jisas raa ki meake na tama e hehekau te hare raa ma, “Kootou ki ppena hea Tama nei e meatu kootou.” ");
INSERT INTO nuq_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na Jiu raa e tammaki roo na tuaa i te vahi te ssoro na tinotama laatou ia ma alaa mee hoki ki matahua, tera hea na tama raa e hakattuu na lloo vai e llahi raa ki sossoro na rima laatou raa ki tautari na tuaa raa. Te lloo hokotahi kaa pii kame e tae peeraa sanahuru ma rima, seai naa tipu rua ma rima na galon. ");
INSERT INTO nuq_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tena Jisas ki meake na tama e hehekau te hare raa, “Utu na lloo raa ki ppii na vaitea.” Na tama raa e utu na lloo raa no ppii oho roo, ");
INSERT INTO nuq_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","tena Jisas ki meake na tama raa, “Ahu ni vai no kkave te tama hakamaatua te kai nei raa.” Na tama raa e ahu na vaitea ");
INSERT INTO nuq_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ku huri mo wain raa no kkave i te tama hakamaatua te kai raa, tena te tama raa ki kamata te vai raa. Te tama raa se iroa ma te wain raa e hamai i hee (e meia na tama hehekau ni ahu ake na wain raa hokolaatou koi e illoa); kito te tama raa ki kanna ake te tamatane e avana vahao nei raa ki haere ake, ");
INSERT INTO nuq_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","tena aia ki meake te tama raa, “Na tama hakaatoa e taki na wain taualleka raa i mua, tena te saaita na tama hakaatoa ku vvare, tena laatou ku taki na wain se taualleka raa. Emeia akoe e hakkapi na wain taualleka nei no tae roo te saaita nei!” ");
INSERT INTO nuq_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jisas e huri te mirakol kaamata nei i Kana i roto Galili; Aia e huri ake na mahi Aia raa i te kina raa, tena na disaipol Aia raa ku hakattina roo Tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","I muri te kai te avana raa, Jisas ma te tinna Aia raa, na taina Aia raa, tena na disaipol Aia raa ku oo i Kaperneam no nnoho e llava na aho i te kina raa. ");
INSERT INTO nuq_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Te saaita hoki te Kai te Pasova raa ku taapiri, tena Jisas ki haere i Jerusalem. ");
INSERT INTO nuq_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jisas e haere i roto te Hare Tapu raa no kite na tama e tataui na bulmakau, na sipsip ia ma na rupe, tena na tama hoki e sesenisi na sileni raa e nnoho ma na tebol laatou raa. ");
INSERT INTO nuq_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kito Jisas ki ssiri te maea raa, tena ki hakatui na manu raa hakaatoa i aho ma te Hare Tapu raa; na sipsip ia ma na bulmakau raa hoki, tena ki hakahuri na tebol na tama sesenisi na sileni raa no masseu na sileni na tama raa; ");
INSERT INTO nuq_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","tena Aia ki hai ake na tama e nnoho ma na rupe raa, “Too na manu naa no kkave i taha ma te hare nei! Auu se mee te hare te Tamana Anau nei pera ma he maket!” ");
INSERT INTO nuq_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Na disaipol Jisas raa ku mannatu na tattara i roto te Launiu Tapu ma, “Te hihai anau i te hare Akoe nei raa e ttuni roo i roto anau pera ma he ahi.” ");
INSERT INTO nuq_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tena na tama hakamattua na Jiu raa ku meake ma, “He mirakol peehee Akoe e lavaa te huri mai ki kkite maatou pera ma Akoe e isi na mahi hakamaoni ki hakaise na tama nei i taha?” ");
INSERT INTO nuq_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Kito Jisas ki meake, “Anau e me ki seu te Hare Tapu nei ki moe i raro, tena ku hakatuu hakaraoi te hare nei i roto e toru na aho.” ");
INSERT INTO nuq_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tena na tama raa ki vahiri ake, “Akoe e me ki hakatuu hakaraoi te hare nei i roto e toru na aho? Te Hare Tapu nei e too roo tipu haa ma ono na hetau ki pena!” ");
INSERT INTO nuq_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Emeia te hare tapu Jisas e tattara raa ko te tinotama Aia. ");
INSERT INTO nuq_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Tena te saaita Jisas ni ora muri i taha ma te mate raa, na disaipol Aia raa ku mannatu na tattara Aia ni tattara ake raa, tena ki hakattina na tattara te Launiu Tapu raa ia ma na tattara Jisas ni tattara ake laatou raa. ");
INSERT INTO nuq_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jisas koi noho i Jerusalem te saaita te Kai te Pasova raa, tena tammaki na tama ku hakattina Tama raa, e mee na mirakol laatou e kkite Tama raa e ppena raa. ");
INSERT INTO nuq_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Emeia Jisas se huri ake roo te hakamaoni Aia i na tama raa, e mee Aia e iroa na hakataakoto na tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Niaina se hai tama e tattara ake Jisas na hakataakoto na tama raa, e meia Jisas ko na iroa roo avare hea i roto na hatu manava na tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nikodimas he tama hakamaatua na Jiu, tena aia e hukui hoki ma te kuturana na Farisi raa. ");
INSERT INTO nuq_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","He poo hokotahi Nikodimas e haere ake iaa Jisas raa no vahiri ake Tama raa ma, “Rabai, maatou e illoa ma Akoe he tama TeAtua e kauna ria mai. Se hai tama e lavaa te ppena na mirakol Akoe e ppena raa kame TeAtua se hehekau i roto te tama naa.” ");
INSERT INTO nuq_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Kito Jisas ki meake, “Anau e meatu te hakamaoni: se hai tama e lavaa te tae i te Hakamaatua ana i te Vaelani raa kame aia se haanau mai hakaraoi.” ");
INSERT INTO nuq_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tena Nikodimas ki meake, “Te tama ku matua raa e me ki haanau mai hakaraoi peehee? Te tama ku matua se lavaa te uru i roto te manava te tinna aia raa ki haanau mai hakaraoi!” ");
INSERT INTO nuq_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Kito Jisas ki meake, “Anau e tattara atu te hakamaoni, se hai tama e lavaa te tae i te Hakamaatua ana i te Vaelani raa kame aia se haanau mai ma te vai ia ma TeAnana Tapu. ");
INSERT INTO nuq_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Taatou e too na tinotama taatou nei i na maatua taatou, e meia taatou e too na anana taatou raa i TeAnana Tapu. ");
INSERT INTO nuq_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Auu se oho e mee Anau e meatu akoe pera ma kootou ki hannau mai hakaraoi. ");
INSERT INTO nuq_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Te matani raa e maairi mai te totoka hee aia e hihai ki maairi. Akoe e rono te matani raa e maairi, e meia akoe se iroa ma te matani raa e hamai i hee, ia e haere i hee. Te matani raa e ssau pera ma na tama hakaatoa e hannau mai ma TeAnana Tapu raa.” ");
INSERT INTO nuq_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tena Nikodimas ki meake, “Te mee nei e me ki kapihi mai peehee?” ");
INSERT INTO nuq_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Kito Jisas ki meake, “Akoe he tama hakamaatua e akoako i roto Israel, e meia akoe se iroa na tattara nei? ");
INSERT INTO nuq_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Anau e tattara atu te hakamaoni: maatou e tattara atu na mee maatou e illoa raa, tena ki tattara atu hoki na mee maatou e kkite raa, e meia se hai tama kootou e hihhai ki hakallono na tattara maatou raa. ");
INSERT INTO nuq_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kootou se hakattina Anau te saaita Anau e tattara atu na mee i te maarama nei; kaa kootou e me ki hakattina peehee kame Anau ni tattara atu na mee i te vaelani raa? ");
INSERT INTO nuq_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Se hai tama roo hokotahi ni haere i aruna i te vaelani, teeraa ko te Tamariki te Tama nei koi, te Tama ni hamai i raro i taha ma te vaelani raa.” ");
INSERT INTO nuq_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Te Tamariki te Tama nei e me ki ssau ria i aruna pera ma Moses ni ssau te lapono e pena i na katanatea raa, ");
INSERT INTO nuq_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tena na tama e hakattina Tama raa e me ki too te ora e ora tahi. ");
INSERT INTO nuq_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Maitaname TeAtua e laoi mahi roo na tama i te maarama nei, tena Aia ki kou mai te tautahi Tama Aia raa, tena na tama hakaatoa e hakattina i Tamariki raa se lavaa te mmate, e meia na tama naa e me ki too te ora e ora tahi. ");
INSERT INTO nuq_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Maitaname TeAtua se kou mai te Tamariki Aia raa i te maarama nei ki mee mo tama hakatonutonu, e meia Aia e kou mai Tamariki Aia raa ki tokonaki na tama i te maarama nei raa ki ora. ");
INSERT INTO nuq_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Na tama e hakattina i te Tamariki TeAtua raa se lavaa te hakatonutonu ria; e meia na tama se hakattina raa ko na hakatonutonu ria avare, maitaname laatou ni se hakattina i te Tamariki TeAtua raa. ");
INSERT INTO nuq_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","TeAtua e me ki hakatonutonu na tama i te maarama nei raa peenei: te Maahina raa ku oti te hamai i te maarama nei, e meia na tama raa e hihhai koi te pouri raa, tena ki tiaki te Maahina raa, maitaname na tiputipu laatou raa e sakkino. ");
INSERT INTO nuq_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Na tama hakaatoa e ppena na tiputipu sakkino raa se hihhai te Maahina raa, ia se hihai hoki ki oo ake i te kina te Maahina raa, maitaname na tama raa se hihhai ma na tama ki illoa na tiputipu sakkino laatou raa. ");
INSERT INTO nuq_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Emeia na tama ni ppena na tiputipu e ttonu raa ku oo ake i te Maahina raa ma ki lavaa te Maahina raa te huri ake pera ma laatou e hakallono no tauttari hea TeAtua e hihai raa. ");
INSERT INTO nuq_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tena ki oti, Jisas ma na disaipol Aia raa ku oo i te matakaina Judia raa, tena Aia ki nnoho ma na tama raa e llava na aho no hakoukou tapu na tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon hoki e hakoukou tapu na tama i Aenon, taapiri te matakaina i Salim raa, maitaname te kina raa e tammaki na vai. Na tama e oo ake iaa Jon, tena aia ki hakoukou tapu na tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Te mee nei e kapihi mai i mua Jon ni ponotia i roto te hare karapusi raa.) ");
INSERT INTO nuq_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","E isi na disaipol Jon e hakataukoti ma na Jiu i te vahi te tuaa ki ssoro na mee ki matahua raa. ");
INSERT INTO nuq_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kito na disaipol Jon raa ki oo ake no meake Jon ma, “Rabai, akoe e maanatu te tanata ni ttuu koorua i te vahi te anake i te riva Jordan; te Tama akoe ni tattara mai raa? Te Tama raa ku kaamata no hakoukou tapu na tama te saaita nei, tena na tama hakaatoa ku oo ake i te Tama raa!” ");
INSERT INTO nuq_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Kito Jon ki meake, “Se hai tama e lavaa te isi na mee kame TeAtua se kou ake ni mee ma te tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kootou hokkootou e llono na maihu anau te saaita anau ni tattara atu ma, ‘Anau seai ma ko te Mesaia, e meia anau e kauna ria mai koi ki hamai i mua Tama raa.’ ");
INSERT INTO nuq_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kame he taupeara e avana vahao nei, tena te hine aia e avana raa he hine aia, e meia te soa laoi roo te taupeara raa e me ki hihia roo te saaita aia e rono te reo te taupeara ku avana raa. Tera hea anau e hihia roo i roto anau. ");
INSERT INTO nuq_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Te Tama naa e me ki haere roo no hakanaaniu, tena anau e me ki haere sara no mouraro.” ");
INSERT INTO nuq_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Te Tama e hamai i te vaelani raa e hakanaaniu i aruna na tama hakaatoa. Te tama e haanau mai i roto te maarama nei raa he tama te maarama nei, tena aia e me ki tattara koi na mee i te maarama nei, e meia te Tama e hamai i te vaelani raa e hakanaaniu i aruna na mee roo hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tama raa e me ki tattara mai na mee Aia ni kite ia ma na mee Aia ni rono raa, e meia se hai tama e hihai ki hakarono na tattara Tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tena te tama e tautari na tattara Tama raa e me ki huri ake pera ma TeAtua e hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Te Tama TeAtua e kauna ria mai raa e tattara na tattara TeAtua, maitaname TeAtua e kou ake TeAnana Tapu raa ki noho i roto Tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","TeAtua e laoi roo te Tamariki Aia raa, tena ki kou ake na mahi Tama raa ma ki rorohi na mee hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Te tama e hakatina te Tamariki TeAtua raa e me ki too te ora e ora tahi; te tama se hakatina te Tamariki TeAtua raa se lavaa te too te ora e ora tahi, e meia aia e me ki too na hakalono llihu TeAtua. ");
INSERT INTO nuq_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Na Farisi raa ku llono pera ma na tama Jisas e hakoukou tapu raa ku tammaki roo i aruna na tama Jon ni hakoukou tapu raa. ");
INSERT INTO nuq_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Emeia te hakamaoni Jisas se hai tama ni hakoukou tapu, aaraa ko na disaipol Aia raa koi e hakoukou tapu na tama.) ");
INSERT INTO nuq_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Te saaita Jisas ni rono na tattara na tama raa, tena Aia ku tiaki Judia no vaakai i Galili; ");
INSERT INTO nuq_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","tena ki haere vaa roto Samaria te saaita Aia ni vaakai raa. ");
INSERT INTO nuq_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Aia e haere vaa roto Samaria no tae te matakaina Saikar, se mmao hoki ma te paupaku Jekop ni kou ake ma Josep, te tamariki aia raa. ");
INSERT INTO nuq_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Te vai Jekop ni keri raa e tuu i te kina raa, tena Jisas ki haere no noho i te vahi te vai raa e mee Aia ku naenae te hahaere. Te mee raa kame ku tae te laa latea. ");
INSERT INTO nuq_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tena he hine i Samaria ku hamai ki ahu na vai, tena Jisas ki meake te hine raa, “Ahu mai he vai ki unu Anau.” ");
INSERT INTO nuq_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Na disaipol Jisas raa e oo i roto te matakaina raa ma ki sui ni kai.) ");
INSERT INTO nuq_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kito te hine raa ki meake, “Akoe he Jiu, tena anau he tama i Samaria. Kaa Akoe e lavaa peehee te kainno mai anau ki ahu he vai ki unu Akoe?” (Na Jiu raa e ttapu te unu na kapu, ia te kkai na parete na tama i Samaria.) ");
INSERT INTO nuq_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tena Jisas ki meake, “Kame koi akoe e iroa na mee TeAtua e kou atu raa ia ma te Tama e kainno atu akoe ki ahu ake he vai raa, tena akoe ku kainno ake te Tama naa, tena te Tama naa e me ki kou atu te vai te ora raa.” ");
INSERT INTO nuq_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kito te hine raa ki meake, “Akoe se isi te puu, tena te vai nei hoki e nnoto. Kaa Akoe e me ki too te vai te ora naa i hee? ");
INSERT INTO nuq_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Jekop te tipuna taatou i mua raa e kou mai te vai nei ma maatou, tena aia ma na tamalliki aia raa ia ma na manu aia raa hakaatoa ni unuunu te vai nei. Eaa Akoe e maanatu ma Akoe e hakanaaniu i aruna Jekop?” ");
INSERT INTO nuq_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Tena Jisas ki meake, “Na tama hakaatoa e unu te vai nei raa e me ki hiunu hakaraoi, ");
INSERT INTO nuq_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","e meia na tama e unu te vai Anau e me ki kou ake raa se lavaa te hiunu hakaraoi. Te vai Anau e me ki kou ake raa e me ki mee pera ma he vai e tere, tena te vai te ora raa e me ki kou ake te tama naa te ora e ora tahi.” ");
INSERT INTO nuq_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kito te hine raa ki meake, “TeAriki, kou mai te vai naa i anau! Tena anau e me ki se lavaa te hiunu hakaraoi, ia anau se lavaa hoki te hamai no ahuahu tahi na vai.” ");
INSERT INTO nuq_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Tena Jisas ki meake te hine raa, “Haere no meake te avana akoe raa, tena koorua ku oo mai.” ");
INSERT INTO nuq_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kito te hine raa ki meake, “Anau se isi te avana.” Tena Jisas ki meake, “Akoe e tattara te hakamaoni te saaita akoe e mee mai ma akoe se isi te avana. ");
INSERT INTO nuq_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Akoe ni avana e rima na taanata i mua, tena te tanata akoe e noho ma akoe te saaita nei raa seai ma he avana akoe hakamaoni. Akoe e tattara mai Anau te hakamaoni.” ");
INSERT INTO nuq_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kito te hine raa ki meake, “TeAriki, anau e kite pera ma Akoe he profet. ");
INSERT INTO nuq_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Na tipuna maatou i Samaria raa e lotulotu TeAtua i aruna te mouna nei, e meia kootou na Jiu raa e mee ma Jerusalem ko te kina hakamaoni maatou e tau te lotulotu ake TeAtua.” ");
INSERT INTO nuq_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Tena Jisas ki meake te hine raa, “Akoe ki hakatina Anau, e mee e isi te saaita koi hamai tera na tama se lavaa te lotulotu ake TeAtua i aruna te mouna nei ia ma i roto Jerusalem. ");
INSERT INTO nuq_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kootou na tama i Samaria raa se illoa te Tama kootou e lotulotu raa; e meia maatou na Jiu raa e illoa te Tama maatou e lotulotu raa, maitaname te Tama e me ki tokonaki na tama ki ora raa e me ki hamai i Jerusalem. ");
INSERT INTO nuq_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Emeia te saaita e me ki hamai raa ku oti te tae mai, te saaita na tama e me ki lotulotu hakamaoni TeAtua i na mahi TeAnana Tapu raa, tena ku lotu ake TeAtua te lotulotu hakamaoni Tama raa e hihai raa. ");
INSERT INTO nuq_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","TeAtua ko TeAnana Tapu, tena na tama e lavaa koi te lotu hakamaoni ake Tama raa i na mahi TeAnana Tapu.” ");
INSERT INTO nuq_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kito te hine raa ki meake Jisas, “Anau e iroa pera ma te Mesaia raa e me ki hamai, tena te saaita Aia e hamai raa, Aia e me ki hakari mai na mee roo hakaatoa.” ");
INSERT INTO nuq_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Tena Jisas ki meake, “Teenei Anau nei, te Tama e tattara atu nei.” ");
INSERT INTO nuq_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Na disaipol raa ku ttae ake te vahao naa, tena na tama raa e oho roo e mee laatou e kkite Jisas e tattara ma te hine raa. Emeia se hai tama na tama naa e vahiri ake te hine raa ma, “Hea akoe e hihai?” iaa se hai tama e vahiri ake hoki Jisas ma, “Aiea Akoe e tattara ma te hine raa raea?” ");
INSERT INTO nuq_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kito te hine raa ki tiaki te lloo vaitea aia raa no vaakai i te matakaina raa no tattara ake na tama i te kina raa ma, ");
INSERT INTO nuq_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Oo mai no mata te tama e hakari mai anau na mee hakaatoa anau ni ppena i mua raa. Eaa, te tama raa seai ma ko te Mesaia raa koi?” ");
INSERT INTO nuq_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kito na tama raa ki tiaki te matakaina laatou raa ma ki oo no mmata Jisas. ");
INSERT INTO nuq_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Te saaita naa hoki na disaipol raa ku hakorokoro ma Jisas ki too ni kai no kai. ");
INSERT INTO nuq_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Emeia Jisas e meake, “Anau e isi na kai e kai tera kootou se illoa.” ");
INSERT INTO nuq_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kito na disaipol raa ki vahihhiri hokolaatou ma, “E isi te tama ni kou ake na kai te Tama nei no kai?” ");
INSERT INTO nuq_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Tena Jisas ki meake, “Anau ki tautari te hihai te Tama ni kauna ria mai Anau raa, tena ku hakaoti hea Aia ni kou mai Anau ki ppena raa, aanaa na kai Anau. ");
INSERT INTO nuq_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kootou e isi te tattara ma, ‘E haa na marama koi mmoe, tena taatou ku oo no haki na hua raa.’ Emeia Anau e meatu kootou ki kkira i roto na paupaku raa; na hua raa ku lleu, tena ku tau te haki. ");
INSERT INTO nuq_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Te tama e haki no hakatau na hua raa e me ki taui ria ma te ora e ora tahi, tena te tama e ttori raa laaua ma te tama e haki raa e me ki hihhia hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Te tattara e mee ma, ‘Teeraa tama e ttori, tena teeraa tama ku haki raa,’ e hakamaoni roo. ");
INSERT INTO nuq_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Anau e kauna kootou ki oo no haki na hua i roto na paupaku kootou se anaana raa; alaa tama ni hehekau i te paupaku naa, tena kootou e me ki too te laoi i na kahota na tama naa.” ");
INSERT INTO nuq_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tammaki na tama i roto Samaria ku hakattina iaa Jisas e mee te hine raa ni tattara ake laatou ma, “Tama raa e hakari mai anau na mee hakaatoa anau ni ppena i mua raa.” ");
INSERT INTO nuq_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Tena te saaita na tama i Samaria raa ni ttiri Jisas, na tama raa ku meake Tama raa ma ki nnoho laatou, tena Jisas ki noho ma na tama raa e rua na aho. ");
INSERT INTO nuq_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ia tammaki roo na tama ku hakattina e mee na tattara Tama raa, ");
INSERT INTO nuq_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","kito na tama raa ki meake te hine raa, “Teenei maatou ku hakattina, ia maatou se mee ma e hakattina e mee na tattara akoe ni tattara mai raa, e meia maatou e hakattina e mee maatou hokomaatou roo ku llono na tattara Tama raa, tena maatou ku illoa pera ma Tama raa ko te Tokonaki na tama te maarama nei.” ");
INSERT INTO nuq_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jisas e noho te matakaina raa e rua na aho no oti, tena Aia ki haere i Galili. ");
INSERT INTO nuq_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Maitaname Jisas Hokoia ni tattara ma, “Te profet e me ki se hihai ria i te matakaina roo aia.” ");
INSERT INTO nuq_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Te saaita Aia ni tae i Galili raa, na tama te matakaina raa ku too hakaraoi roo Tama raa, maitaname laatou ni oo i te Kai te Pasova i Jerusalem raa no kkite na mee hakaatoa Jisas ni ppena te saaita te kai raa. ");
INSERT INTO nuq_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kito Jisas ki vaakai i Kana i roto Galili i te kina Aia ni huri te vai raa mo wain. Tena he tama hakamaatua te taumani, te tamariki aia raa e laavea i Kaperneam, e noho i te kina raa. ");
INSERT INTO nuq_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Te saaita aia ni rono ma Jisas ku tae ake i Galili, te tama raa ku haere ake iaa Jisas no meake Tama raa ma ki oo laaua i Kaperneam no tokonaki te tamariki aia ku taapiri ki mate raa ki tauareka. ");
INSERT INTO nuq_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tena Jisas ki meake tama raa, “Kootou e hihhai ki kkite na mirakol ia ma na mee taualleka, tena kootou ki hakattina.” ");
INSERT INTO nuq_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tena te tama hakamaatua raa ki meake, “TeAriki, hamai ki oo taaua i mua te tamariki anau raa e mate.” ");
INSERT INTO nuq_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Kito Jisas ki meake, “Haere, te tamariki akoe naa e me ki tauareka!” Te tama raa e hakatina na tattara Jisas raa, tena aia ki haere. ");
INSERT INTO nuq_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Te tama raa koi haere atu koi, tena na tama hehekau aia raa ku oo ake no ttiri te tama raa i aruna te mateara, tena ki meake, “Te tamariki akoe raa ku tauareka!” ");
INSERT INTO nuq_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kito te tamana te tamariki raa ki vahiri ake ma te tamariki raa e kaamata vahao hee no tauareka. Tena na tama raa ki meake, “Te vvela te tamariki raa e hopo te tahi te hiahi te aho raa.” ");
INSERT INTO nuq_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tena te tamana te tamariki raa ku maanatu ma teenaa ko te saaita roo Jisas ni meake aia ma, “Te tamariki akoe raa e me ki tauareka.” Tena aia ma na tama te hare aia raa hakaatoa ku hakattina. ");
INSERT INTO nuq_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Teenei ko te mirakol hakarua Jisas ni ppena te saaita Aia ni tiaki Judia no haere i Galili raa. ");
INSERT INTO nuq_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tena ki oti roo Jisas ku haere i Jerusalem e mee te kai e rahi na Jiu raa e me ki ttaohi raa. ");
INSERT INTO nuq_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Tena he vai i te kina raa e tuu taapiri te Totoka na Sipsip tera e isi e rima na paaro raa; te vai raa e hui ma Betesda i na tattara na Hibru. ");
INSERT INTO nuq_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","4 E tammaki na tama lavvea e moemmoe vaa raro na paaro raa: na tama e sseni, na tama na vae e mmate ia ma na tama se lavaa te hahaere. Na tama raa e mmoe no hakattari te vai raa ki mmioo, maitaname e isi roo na saaita te ensel TeAriki raa e me ki haere iho no mee te vai raa ki mmioo, tena te tama laavea kaamata roo e llee i roto te vai raa e me ki tauareka ma te maahana aia raa. ");
INSERT INTO nuq_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tena he tanata e laavea i roto tipu toru ma varu na hetau e moe i te kina raa. ");
INSERT INTO nuq_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisas e kite te tanata raa e moe i te kina raa, tena Aia e iroa ma te tanata raa e laavea te saaita roroa roo; kito Jisas ki meake te tanata raa, “Akoe e hihai ki tauareka?” ");
INSERT INTO nuq_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Kito te tanata e laavea raa ki meake, “TeAriki, se hai tama e me ki tokonaki ki kkave anau te saaita te vai raa e mmioo; te saaita anau koi hahaivi atu koi, teeraa tama ku tae koi i mua.” ");
INSERT INTO nuq_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kito Jisas ki meake te tanata raa, “Mahike i aruna no too te moena akoe naa no haere.” ");
INSERT INTO nuq_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Te saaita naa koi te tanata raa ku tauareka, tena aia ki too te moena aia raa no haere. Te aho Jisas e mee te tama raa no tauareka raa he aho te Sabat, ");
INSERT INTO nuq_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","tena na tama hakamattua na Jiu raa ku meake te tanata ku tauareka raa ma, “Teenei he aho te Sabat, tena na tuaa raa e mee ma e tapu akoe te amo te moena akoe naa i te aho nei.” ");
INSERT INTO nuq_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kito te tanata raa ki meake, “Te tama e tokonaki anau no tauareka raa e mee mai ma anau ki too te moena anau nei no haere.” ");
INSERT INTO nuq_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Kito na tama raa ki vahiri ake te tama raa, “Koai te tama e meatu ma akoe ki too te moena akoe naa no haere naa?” ");
INSERT INTO nuq_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Emeia te tanata ku tauareka raa se iroa ma Jisas koai, maitaname te kina raa e tammaki roo na tama, tena Jisas e haere uru koi vaa roto na tama raa no haere i taha. ");
INSERT INTO nuq_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tena ki oti Jisas ku ttiri te tama raa i roto te Hare Tapu, tena Aia ki meake, “Hakarono, akoe ku tauareka vahao nei, tena hakaoti te ppena na mee sakkino, kaa seai na mee sakkino roo e me ki ttae atu akoe.” ");
INSERT INTO nuq_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tena te tanata raa ki haere no tattara ake na tama hakamattua na Jiu raa ma teeraa ko Jisas ni tokonaki aia no tauareka. ");
INSERT INTO nuq_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kito na tama raa ki kaamata no tattara sakkino roo iaa Jisas, e mee Tama raa e tokonaki te tanata raa no tauareka i te aho te Sabat. ");
INSERT INTO nuq_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Tena Jisas ki meake na Jiu raa, “Te Tamana Anau raa se hai vahao e hamaroroo, tera hea Anau e uata tahi koi.” ");
INSERT INTO nuq_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Te tattara nei e mee roo na hakataakoto na tama hakamattua na Jiu raa no mmaha ma ki taa Jisas ki mate, e mee Jisas se mee ma e seu koi na tuaa te Sabat raa, e meia Tama raa e tattara hoki pera ma TeAtua ko te Tamana Aia, tena na tattara Aia raa e huri ake pera ma laaua ma TeAtua e hokotahi. ");
INSERT INTO nuq_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kito Jisas ki meake na Jiu raa, “Anau e tattara atu te hakamaoni: Te Tamariki TeAtua raa se lavaa te ppena na mee i te hakataakoto koi Aia; Aia e ppena koi na mee Aia e kite te Tamana Aia raa e ppena raa. Hea te Tamana raa e ppena, te Tamariki raa hoki e me ki pena. ");
INSERT INTO nuq_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Maitaname te Tamana raa e laoi roo te Tamariki Aia raa, tena ki huri ake na mee hakaatoa Aia e ppena raa. Tama raa e me ki huri ake te Tamariki Aia raa ki ppena na mee e llahi roo i aruna na mee nei, tena kootou e me ki mahharo. ");
INSERT INTO nuq_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","E ssau koi pera ma te Tamana raa e hakamahike na tama ku mmate raa, tena ki kou ake na ora na tama raa, tena te Tamariki raa hoki e me ki kou ake na ora na tama Aia ni hirihiri raa. ");
INSERT INTO nuq_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Te Tamana se hakatonutonu na tama, e meia Aia e kou ake na mahi hakaatoa te Tamariki Aia raa ki hakatonutonu na tama, ");
INSERT INTO nuq_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ki lavaa na tama hakaatoa te hakammaha te Tamariki raa e ssau pera ma laatou e hakammaha te Tamana raa. Koai te tama se hakammaha te Tamariki raa, se hakammaha hoki te Tamana tera ni kauna ria mai Tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Anau e tattara atu te hakamaoni: na tama e llono na tattara Anau, tena ki hakattina i te Tama ni kauna ria mai Anau raa e me ki too te ora e ora tahi. Na tama raa se lavaa te hakatonutonu ria, e meia na tama raa ku hhiti i taha ma na mahi te mate no ora. ");
INSERT INTO nuq_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Anau e tattara atu te hakamaoni: e isi te saaita koi hamai, e meia te saaita naa ku oti te tae mai, te saaita na tama ku oti te mmate raa e me ki llono te reo te Tamariki TeAtua raa, tena na tama e llono te reo raa e me ki ora. ");
INSERT INTO nuq_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Te Tamana raa ko te tahito te ora, ia tena Aia e kou ake hoki na mahi te Tamariki Aia raa ki tahito te ora e ssau pera ma Aia raa hoki. ");
INSERT INTO nuq_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tena Aia ki kou ake na mahi te Tamariki Aia raa ki hakatonutonu na tama, maitaname Tama raa ko te Tamariki te Tama nei. ");
INSERT INTO nuq_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Auu se oho i na tattara Anau e mee ma; e isi te saaita koi hamai, te saaita na tama hakaatoa ni mmate raa e me ki llono te reo Anau, ");
INSERT INTO nuq_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","tena ku oo iho i taha ma na taruma laatou raa, tena na tama ni ppena na mee taualleka raa e me ki mahhike no ora, ia na tama e ppena na mee sakkino raa e me ki mahhike no too na hakalono llihu. ");
INSERT INTO nuq_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Anau se lavaa te ppena he mee i na mahi Anau Hokonnau; Anau e hakatonutonu koi tautari hea TeAtua e mee mai Anau raa, tena te hakatonutonu Anau raa e tonu, maitaname Anau se hahaivi ma ki ppena hea Anau e hihai, e meia Anau e ppena hea te Tama ni kauna ria mai Anau raa e hihai. ");
INSERT INTO nuq_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Kame Anau e tattara koi i te vahi Anau Hokonnau, tena na tattara Anau e tattara raa se isi te hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Emeia e isi te tama e me ki tattara i te vahi Anau, tena Anau e iroa pera ma na tattara te tama raa e tattara i te vahi Anau raa e hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kootou ni kauna na tama kootou raa iaa Jon, tena tama raa ki tattara atu i te vahi te hakamaoni raa. ");
INSERT INTO nuq_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Anau se tau hoki te ssee he tama i te maarama nei ki tattara atu kootou i te vahi Anau; Anau e tattara atu koi ma ki tokonaki kootou ki ora. ");
INSERT INTO nuq_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon e ssau pera ma he lamu e ura ki hakamaahina atu kootou, tena kootou e hihhai ma ki hihhia paa saaita koi i te maahina tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Emeia e isi na mee e tattara i te vahi Anau tera e hakanaaniu i aruna na tattara Jon raa: na mee anau e ppena raa, aanaa ko na mee te Tamana ni kou mai Anau ki ppena raa, tena na mee nei e tattara i te vahi Anau, tena ki huri atu hoki pera ma te Tamana e kauna ria mai Anau. ");
INSERT INTO nuq_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tena te Tamana ni kauna ria mai Anau raa e tattara hoki i te vahi Anau. Kootou se hai vahao e llono te reo Tama raa, ia se kkite na karemata Tama raa, ");
INSERT INTO nuq_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","tena kootou ki se ttaohi mmau na tattara Tama raa i roto na hatu manava kootou, maitaname kootou se hakattina i te Tama Tama raa ni kauna ria mai raa. ");
INSERT INTO nuq_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kootou e paupau te Launiu Tapu raa, maitaname kootou e mannatu ma kootou e me ki lave te ora e ora tahi raa i roto te launiu raa. Tena te Launiu Tapu kootou e paupau raa e tattara i te vahi Anau! ");
INSERT INTO nuq_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Emeia kootou se hihhai ki oo mai Anau no too te ora e ora tahi raa. ");
INSERT INTO nuq_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Anau se mee ma na tama te maarama nei raa ki hakammaha Anau. ");
INSERT INTO nuq_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Emeia Anau e iroa na tiputipu kootou, tena Anau e iroa hoki pera ma kootou se laoi hakamaoni TeAtua i roto na hatu manava kootou. ");
INSERT INTO nuq_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Anau e hamai ma na mahi te Tamana Anau raa, e meia kootou se hihai ki too Anau; ia tena kame he tama e hamai i te vahi aia hokoia, kootou e hihai roo ki too tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kootou e hihhai roo kame alaa tama e hakammaha kootou, e meia kootou se hahaivi ma ki mee TeAtua ki hakammaha kootou. Tena, kaa kootou e me ki hakattina peehee Anau? ");
INSERT INTO nuq_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Tena auu se mannatu ma Anau ko te tama e me ki ppau atu na hai sara kootou raa i mua te Tamana Anau raa. Moses te tama kootou e hakattina raa ko te tama e me ki ppau atu na hai sara kootou ni ppena raa. ");
INSERT INTO nuq_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kame kootou ni hakattina hakamaoni Moses, kootou e me ki hakattina hoki Anau, maitaname tama raa ni taataa atu hoki i te vahi Anau. ");
INSERT INTO nuq_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Emeia kootou se hakattina hea Moses ni taataa raa, tena kaa kootou e me ki hakattina peehee na tattara Anau raa?” ");
INSERT INTO nuq_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tena ki oti Jisas ku tere no tae teeraa vahi te Namo Galili raa (te Namo nei alaa tama e kanna ma te Namo Taiberias). ");
INSERT INTO nuq_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tena he kanohenua e rahi roo e tauttari Jisas, maitaname laatou ni kkite na mahi Tama raa ni tokonaki na tama e lavvea raa no taualleka. ");
INSERT INTO nuq_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jisas e kake te paa mouna no nnoho ma na disaipol Aia raa. ");
INSERT INTO nuq_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Te saaita naa te Kai te Pasova raa ku taapiri hoki. ");
INSERT INTO nuq_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisas e kkira hakataka no kite te kanohenua e rahi roo ku oo ake Aia, tena Aia ki kanna ake Filip, “Te kina hee taatou e lavaa te sui ni kai e llava ki haanai te kanohenua nei?” ");
INSERT INTO nuq_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Jisas e meake koi ma ki haaite Filip; e meia te hakamaoni, Aia ko na iroa roo avare hea Aia e me ki pena.) ");
INSERT INTO nuq_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Kito Filip ki meake, “Na tama nei hakaatoa se lavaa te isi na kai ki kkai kame taatou e too rua huitarau na siliva ma ki sui ni kai ki hannai na tama nei.” ");
INSERT INTO nuq_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tena teeraa disaipol hoki, Andru te taina Saimon Pita raa ki meake, ");
INSERT INTO nuq_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“He tamariki tanata i te kina nei e isi e rima na haraoa e pena i na bali ia ma e rua na ika. Emeia na mee nei e me ki se tau roo ma te kanohenua nei.” ");
INSERT INTO nuq_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Kito Jisas ki meake na tama raa, “Meake te kanohenua raa ki nnoho i raro” (Te kina raa e hhomo na veve roo hakaatoa.) Kito te kanohenua raa ki nnoho i raro, tena te kooina na taanata raa hakaatoa kame e ttae rima simata. ");
INSERT INTO nuq_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tena Jisas ki too na haraoa raa no lotu ake TeAtua, tena ki vaevae ake i na tama e nnoho i te kina raa. Jisas e mee peeraa hoki na ika raa. Tena na tama raa hakaatoa e kkai roo no ppohu. ");
INSERT INTO nuq_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Na tama raa e kkai roo no ppohu hakaatoa, tena Jisas ki meake na disaipol Aia raa ma, “Hakanaopo na kai e ttoe raa, taatou ki se kkai puamu.” ");
INSERT INTO nuq_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kito na tama raa ki haere koko na muri haraoa ia ma na ika na tama raa ni kkai no ttoe raa no sasao sanahuru ma rua na kete no ppii. ");
INSERT INTO nuq_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Te kanohenua raa ku kkite te mirakol Jisas ni ppena raa, tena na tama raa ki tattara ma, “Hakamaoni, teenei ko te Profet: te Tama te Launiu Tapu raa e tattara ma e me ki hamai i te maarama nei raa!” ");
INSERT INTO nuq_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jisas e iroa pera ma na tama raa ku mee ma ki oo ake no ttaohi Aia ki mee mo tuku, tena Aia ki tiaki na tama raa no haere Hokoia koi i te kina na mouna raa. ");
INSERT INTO nuq_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Te saaita te mee raa ku hiahi, na disaipol Jisas raa ku oo i tai ");
INSERT INTO nuq_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","no kakke te vaka raa no tere peeraa i Kaperneam, he matakaina e tuu i teeraa vahi te namo raa. Te mee raa ku poo, tena Jisas se ki tae ake roo i laatou. ");
INSERT INTO nuq_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Te saaita naa te matani raa ku kaamata no maairi, tena te moana raa hoki ku pepeau. ");
INSERT INTO nuq_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Na disaipol raa e aro no mmao roo i taha ma te henua raa, tena laatou ku kkite Jisas e haere ake vaa aruna te lottai no haere hakataapiri ake roo te vaka raa, tena na disaipol raa ku mattaku roo. ");
INSERT INTO nuq_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kito Jisas ki meake, “Auu se mattaku, teenei ko Nau!” ");
INSERT INTO nuq_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Na disaipol raa ku mee koi ma ki hakkake Tama raa i roto te vaka raa, tena te saaita naa koi te vaka raa ku tae i te kina laatou e tere raa. ");
INSERT INTO nuq_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Te aho taiao raa te kanohenua ni nnoho teeraa vahi raa ku illoa ma teeraa he vaka hokotahi koi ni tautau i te kina raa. Na tama raa e illoa ma Jisas ni se kakke laatou ma na disaipol raa i roto te vaka raa; na disaipol raa ni tiaki Tama raa i te kina raa no tere. ");
INSERT INTO nuq_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tena alaa vaka e huro mai peeraa i Taiberias ku hakauu ake i te kina raa; te kina te kanohenua raa ni kkai na haraoa TeAriki ni hakatapu raa. ");
INSERT INTO nuq_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Te saaita te kanohenua raa ku illoa pera ma Jisas ku seai i te kina raa ma na disaipol Aia raa, na tama raa ku kakke na vaka raa no huro peeraa i Kaperneam no sesee Jisas. ");
INSERT INTO nuq_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Te kanohenua raa ku kkite Jisas i teeraa vahi te namo raa, tena na tama raa ki vahiri ake Tama raa ma, “Rabai, Akoe ni tae mai i te kina nei vahao hee?” ");
INSERT INTO nuq_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Kito Jisas ki meake, “Anau e tattara atu te hakamaoni: kootou e sesee Anau raa e mee kootou ni kkai na haraoa raa no ppohu roo kootou, ia te sesee kootou raa se mee ma kootou e illoa na mirakol Anau raa. ");
INSERT INTO nuq_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Auu se hakatettere mahi i na kai tera e me ki ppara raa, e meia hakatettere i na kai tera e me ki kou atu te ora e ora tahi raa. Aanei ko na kai te Tamariki te Tama nei e me ki kou atu kootou, maitaname TeAtua Tamana raa ku oti te tuku te hakamaatino Aia raa i aruna Tama raa.” ");
INSERT INTO nuq_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kito na tama raa ki vahiri ake, “Kaa hea maatou e me ki ppena ki lavaa maatou te ppena na mee TeAtua e hihai ma maatou ki ppena raa?” ");
INSERT INTO nuq_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tena Jisas ki meake, “Teenei hea TeAtua e hihai ma kootou ki ppena: kootou ki hakattina i te Tama Aia ni kauna ria mai raa.” ");
INSERT INTO nuq_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kito na tama raa ki meake, “He mirakol peehee Akoe e lavaa te ppena ki hakattina maatou i Akoe? Hea Akoe e me ki ppena? ");
INSERT INTO nuq_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Na tipuna maatou raa e kkai na ‘mana’ i te kina e tuu mahoa raa, ia pera ma te Launiu Tapu raa e tattara ma, ‘Tama raa e kou ake na haraoa i te vaelani raa no kkai na tama raa.’ ” ");
INSERT INTO nuq_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tena Jisas ki meake, “Anau e tattara atu te hakamaoni, te haraoa Moses e kou atu raa seai ma ko te haraoa i te vaelani raa; teeraa ko te Tamana Anau raa e kou atu kootou te haraoa hakamaoni i te vaelani raa. ");
INSERT INTO nuq_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Maitaname te haraoa TeAtua e kou atu raa ko te tama e hamai i taha ma te vaelani ki kou atu te ora hakamaoni i na tama te maarama nei raa.” ");
INSERT INTO nuq_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Kito na tama raa ki meake, “Rabai, tauhano te kou mai te haraoa naa na vahao hakaatoa.” ");
INSERT INTO nuq_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Tena Jisas ki meake na tama raa, “Anau ko te Haraoa te Ora, na tama e oo mai Anau raa se lavaa te hikkai, tena na tama e hakattina Anau raa se lavaa te hiunu. ");
INSERT INTO nuq_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Teenei Anau ku meatu kootou te saaita nei pera ma kootou e kite Anau, e meia kootou se lavaa te hakattina Anau. ");
INSERT INTO nuq_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Na tama hakaatoa te Tamana e kou mai Anau raa e me ki oo mai Anau. Anau se lavaa te hakaise he tama na tama e oo mai Anau raa i taha, ");
INSERT INTO nuq_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","maitaname Anau se hamai i taha ma te vaelani ki ppena hea Anau e hihai, e meia Anau e hamai ki ppena te hihai te Tama e kauna ria mai Anau raa. ");
INSERT INTO nuq_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tena te Tama raa e hihai ma Anau ki se lavaa te hakaise he tama na tama Aia e kou mai Anau raa, e meia ma Anau ki hakaora muri na tama raa hakaatoa i te aho hakaoti raa. ");
INSERT INTO nuq_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Maitaname te Tamana Anau raa e hihai ma na tama hakaatoa e kkite te Tamariki Aia raa no hakattina raa e me ki too te ora e ora tahi. Tena Anau e me ki hakaora muri na tama raa i te aho hakaoti raa.” ");
INSERT INTO nuq_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tena te kanohenua raa ku kaamata no tamumu iaa Jisas, e mee na tattara Tama raa ma, “Anau ko te haraoa e hamai i te vaelani.” ");
INSERT INTO nuq_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kito na tama raa ki meake, “Te tama nei ko Jisas te tamariki Josep raa, kaa seai? Taatou e illoa te tamana ia ma te tinna Aia raa. Kaa Aia e tattara peehee ma Aia e hamai i te vaelani?” ");
INSERT INTO nuq_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Kito Jisas ki meake, “Auu se tamumu hokkootou. ");
INSERT INTO nuq_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Se hai tama e lavaa te hamai Anau kame te Tamana se hakattaki mai tama naa iaa Anau, tena Anau e me ki hakaora muri tama naa i te aho hakaoti raa. ");
INSERT INTO nuq_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Na profet raa e tattaa ma, ‘TeAtua e me ki poroporo na tama hakaatoa.’ Na tama e llono no illoa na tattara Tama raa e me ki oo mai Anau. ");
INSERT INTO nuq_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Te tattara nei se mee pera ma e isi te tama ni kite te Tamana, te Tama e hamai TeAtua raa ko te Tama hokotahi koi tera ni kite te Tamana raa. ");
INSERT INTO nuq_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Anau e meatu te hakamaoni: te tama e hakatina raa e me ki too te ora e ora tahi. ");
INSERT INTO nuq_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Anau ko te haraoa te ora. ");
INSERT INTO nuq_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Na tipuna kootou raa e kkai na mana i te kina e tuu mahoa raa, e meia na tama raa e mmate koi. ");
INSERT INTO nuq_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Emeia te haraoa e hamai i te vaelani raa e kee, e mee te tama e kai te haraoa naa se lavaa te mate. ");
INSERT INTO nuq_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Anau ko te haraoa e ora tera e hamai i te vaelani. Kame he tama e kai te haraoa nei, tena aia e me ki noho tahi roo. Te haraoa Anau e me ki kou ake raa ko te tinotama Anau tera Anau e me ki hoki atu ki lavaa na tama te maarama nei raa te ora.” ");
INSERT INTO nuq_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Te tattara nei e mee te kanohenua raa no hakatauttau hokolaatou. Na tama raa e vahihhiri ma, “Te Tama nei e me ki kou mai peehee te tinotama Aia raa ki kkai taatou?” ");
INSERT INTO nuq_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tena Jisas ki meake na tama raa, “Anau e tattara atu te hakamaoni: kame kootou se kkai te tinotama, ia se unu te toto te Tamariki te Tama nei; kootou se lavaa te isi na ora i roto kootou. ");
INSERT INTO nuq_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Na tama e kkai te tinotama Anau raa, tena ki unu te toto Anau raa e me ki too te ora e ora tahi, tena Anau e me ki hakaora muri na tama naa i te aho hakaoti raa. ");
INSERT INTO nuq_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Maitaname te tinotama Anau raa ko te kai hakamaoni, tena te toto Anau raa ko te vai hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Na tama e kkai te tinotama Anau, tena ki unu te toto Anau raa e nnoho i roto Anau, tena Anau e noho i roto na tama naa. ");
INSERT INTO nuq_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Te Tamana e ora raa ni kauna ria mai Anau, tena Anau e ora e mee te Tama raa. Ia e ssau peeraa hoki, te tama e kai te tinotama Anau raa e me ki ora e mee Anau e noho. ");
INSERT INTO nuq_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ia teenei ko te haraoa e hamai i te vaelani; te haraoa nei e kee ma te haraoa na tipuna kootou raa ni kkai raa. Na tama raa e nnoho roo no oti, tena ki mmate, e meia na tama e kkai te haraoa e hamai i te vaelani raa e me ki nnoho tahi roo.” ");
INSERT INTO nuq_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisas e tattara na tattara nei te saaita Aia ni akoako i roto te hare lotu na Jiu i Kaperneam raa. ");
INSERT INTO nuq_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tammaki na tama e tauttari Jisas raa e llono na tattara nei, tena ki meake, “Na akoako nei e hainattaa roo. Koai na tama e lavaa te hakallono na tattara nei?” ");
INSERT INTO nuq_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Se hai tama e meake, e meia Jisas e iroa pera ma na disaipol Aia raa e tamumu i na tattara Aia raa, tena Aia ki meake na tama raa, “Eaa, na tattara nei e mee kootou no se hihhai ki tauttari Anau? ");
INSERT INTO nuq_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kaa hea kootou e me ki mee, kame kootou e kkite te Tamariki te Tama nei e vaakai i aruna i te kina Aia ni noho i mua raa? ");
INSERT INTO nuq_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","TeAnana Tapu TeAtua raa e kou atu te ora, tena na mahi na tama te maarama nei raa ni mahi vare koi. Na tattara Anau e tattara atu raa e kou atu kootou TeAnana Tapu TeAtua tera e kou atu te ora raa. ");
INSERT INTO nuq_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Emeia alaa tama kootou se hakattina.” (Jisas e iroa i te kaamata roo na tama tera e me ki se hakattina ia ma te tama e me ki kou ake Aia i na tama haeo raa.) ");
INSERT INTO nuq_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tena Aia ki meake hoki, “Teenei te hakataakoto Anau ni tattara atu kootou pera ma se hai tama e lavaa te hamai Anau kame te Tamana se hakattaki mai te tama naa iaa Anau.” ");
INSERT INTO nuq_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tena tammaki na tama ni tauttari Jisas raa ku huri no vakkai muri, na tama raa ku se tauttari hoki Tama raa he saaita. ");
INSERT INTO nuq_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kito Jisas ki vahiri ake te sanahuru ma rua na disaipol Aia raa, “Kaa kootou, kootou e hihhai ki tiaki Anau hoki?” ");
INSERT INTO nuq_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tena Saimon Pita ki meake, “TeAriki, kaa maatou e me ki oo iaa aii? Akoe e hahaere ma na tattara te ora e ora tahi. ");
INSERT INTO nuq_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tena te saaita nei maatou ku illoa no hakattina pera ma Akoe ko te Tama e Tapu TeAtua.” ");
INSERT INTO nuq_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Kito Jisas ki meake, “Anau ni hirihiri kootou te sanahuru ma rua na tama nei, kaa seai? Emeia he tama kootou he tipua sakkino!” ");
INSERT INTO nuq_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jisas e tattara iaa Judas, te tama Saimon Iskariot raa. Maitaname Judas e me ki kou ake Jisas i na tama haeo raa, niaina ma aia he tama i roto te sanahuru ma rua na disaipol raa. ");
INSERT INTO nuq_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tena ki oti Jisas ku haere peeraa i Galili, tena Aia se hihai hoki ma ki haere vaa roto Judia, maitaname na tama hakamattua na Jiu i te kina raa e hihhai ma ki taa Aia ki mate. ");
INSERT INTO nuq_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Te saaita hoki te Kai na Paa hare raa ku taapiri, ");
INSERT INTO nuq_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","kito na taina Jisas raa ki meake Tama raa, “Tiaki te kina nei no haere i Judia ki kkite na tama e tauttari Akoe raa na mee Akoe e me ki ppena raa. ");
INSERT INTO nuq_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Se hai tama e lavaa te huu he mee, kame aia e hihai ma na tama hakaatoa ki illoa aia. E mee Akoe e haere ppena na mee nei, tena ki huri ake na mee nei ma ki illoa na tama hakaatoa te maarama nei raa Akoe!” ");
INSERT INTO nuq_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Na taina roo Jisas raa se hakattina hoki Tama raa.) ");
INSERT INTO nuq_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tena Jisas ki meake na tama raa, “Te saaita hakamaoni Anau ki ppena na mee nei raa se ki ttae mai, e meia na saaita hakaatoa ni saaita kootou. ");
INSERT INTO nuq_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Te maarama nei se lavaa te kiri lloto kootou, e meia te maarama nei e kiri lloto Anau, maitaname Anau e tattara tahi ake pera ma na tiputipu laatou raa e sakkino. ");
INSERT INTO nuq_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kootou ki oo i te kina te Kai raa. Anau se lavaa te haere atu, maitaname te saaita hakamaoni Anau raa se ki tae.” ");
INSERT INTO nuq_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jisas e tattara ake peenei, tena ki noho koi i Galili. ");
INSERT INTO nuq_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Tena ki oti na taina Jisas raa ku oo i te kina te Kai raa, tena Jisas hoki e haere; e meia Aia e haere hemuu koi ma ki se illoa na tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Na tama hakamattua na Jiu raa e sesee Jisas i te kina te Kai raa. Na tama raa e vahihhiri ma, “Teehee Aia naa?” ");
INSERT INTO nuq_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Te kanohenua raa e tattara hemuu hokolaatou. Alaa tama e tattara ma, “Te Tama raa he tama tauareka.” Tena alaa tama ki meake ma, “Seai, te Tama naa e mariu ake koi na tama.” ");
INSERT INTO nuq_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Emeia se hai tama e tattara hakamaroa, maitaname na tama raa e mattaku i na tama hakamattua na Jiu raa. ");
INSERT INTO nuq_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Te Kai raa ku tae lottonu ma te hakaoti, tena Jisas ki haere i roto te Hare Tapu raa no kaamata no takutaku. ");
INSERT INTO nuq_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Na tama hakamattua na Jiu raa ku mahharo roo, tena ki meake, “Te Tama nei e iroa roo peehee na mee hakaatoa ma Aia se skul raa?” ");
INSERT INTO nuq_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Kito Jisas ki meake, “Na mee Anau e akoako raa seai ma ni akoako Anau, e meia aaraa ni akoako TeAtua, te Tama ni kauna ria mai Anau raa. ");
INSERT INTO nuq_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Te tama e hihai ki ppena hea TeAtua e hihai raa e me ki iroa i te vahi na akoako Anau raa pera ma na akoako raa ni akoako e oo mai TeAtua ma ni akoako koi Anau e tattara i te vahi Anau Hokonnau. ");
INSERT INTO nuq_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Te tama e tattara i te vahi aia hokoia raa e hahaivi koi ki hakammaha te inoa aia hokoia. Emeia te Tama e hihai ki hakammaha te inoa te Tama ni kauna ria mai Aia raa e hakamaoni, tena Aia Hokoia e tonu tahi. ");
INSERT INTO nuq_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses ni kou atu na tuaa raa, kaa seai? Emeia se hai tama kootou e tauttari na tuaa raa. Kaa kootou e hahaivi ma ki taa Anau ki mate naea?” ");
INSERT INTO nuq_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tena te kanohenua raa ki meake, “Akoe e isi te tipua sakkino e tau i roto Akoe. Koai na tama e hahaivi ma ki taa Akoe ki mate naa?” ");
INSERT INTO nuq_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Kito Jisas ki meake, “Anau ni ppena te mirakol hokotahi koi, tena kootou hakaatoa roo e mahharo. ");
INSERT INTO nuq_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses ni meatu kootou ki tuu te hakamaatino e tapu raa i na tamalliki kootou (e meia Moses seai ma ko te tama e kaamata te mee nei, aaraa ko na tipuna kootou raa e kaamata), tena kootou ki ttuu te hakamaatino e tapu raa i na tamalliki kootou raa i te aho te Sabat raa. ");
INSERT INTO nuq_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kootou e ttuu te hakamaatino e tapu na tamalliki kootou raa i te aho te Sabat raa ma ki tautari na tuaa Moses raa, kaa kootou e lloto ma Anau e tokonaki te tama raa no tauareka i te aho te Sabat naea? ");
INSERT INTO nuq_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Auu se hakatonutonu tautari hea kootou e kkite, e meia hakatonutonu tautari na tiputipu e ttonu.” ");
INSERT INTO nuq_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","E isi na tama i Jerusalem e tattara ma, “Teenei seai ma ko te tama na tama hakamattua raa e hahaivi ma ki taa ki mate? ");
INSERT INTO nuq_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kira ake! Tama raa ku tuu roo i mua na tama raa no tattara, tena laatou se hai tattara e meake te Tama raa! Eaa, na tama raa ku illoa hakamaoni ma teeraa ko te Mesaia! ");
INSERT INTO nuq_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Emeia te saaita te Mesaia raa e hamai raa, se hai tama e me ki iroa ma te Mesaia raa e hamai te matakaina hee. Emeia taatou hakaatoa kaa e illoa koi ma te Tama nei he tama i hee.” ");
INSERT INTO nuq_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jisas e akoako i roto te Hare Tapu raa, tena Aia ki meake hakamaroa roo ma, “Kootou e illoa hakamaoni roo Anau, tena e illoa hoki ma Anau e hamai i hee? Anau se hamai i te vahi Anau Hokonnau. Emeia te Tama e kauna ria mai Anau raa e tonu tahi. Kootou se illoa Tama raa, ");
INSERT INTO nuq_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","e meia Anau e iroa Tama raa, maitaname Anau e hamai Tama raa, tena Tama raa e kauna ria mai Anau ki hamai.” ");
INSERT INTO nuq_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tena na tama raa ku tattara ma ki hakapiki Tama raa, e meia se hai tama e ttaohi Tama raa, maitaname te saaita hakamaoni Aia raa se ki tae. ");
INSERT INTO nuq_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Emeia tammaki na tama i roto te kanohenua raa ku hakattina iaa Jisas, tena ki meake, “Te saaita te Mesaia raa e hamai raa, eaa Aia e me ki ppena tammaki na mirakol peenei ma te Tama nei e ppena nei?” ");
INSERT INTO nuq_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Na Farisi raa e llono na tattara te kanohenua raa e tattara hemuu iaa Jisas raa, tena laatou hakapaa ma na maatua hakananniu raa ku kauna na soldia e lollohi te Hare Tapu raa ki oo no hakapiki Jisas. ");
INSERT INTO nuq_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kito Jisas ki meake, “Anau e me ki nnoho ma kootou paa saaita koi, tena ki oti Anau ku vaakai i te Tama ni kauna ria mai Anau raa. ");
INSERT INTO nuq_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kootou e me ki sesee Anau, e meia kootou se lavaa ki kkite Anau, maitaname kootou se lavaa te oo i te kina Anau e me ki noho raa.” ");
INSERT INTO nuq_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Na tama hakamattua na Jiu raa ku tattara hokolaatou ma, “Tama raa e mee ma Aia e me ki haere i hee ki se kkite taatou Aia raa? Aia e me ki haere na matakaina na tama taatou raa e nnoho i roto Grik raa no akoako ake na tama raa? ");
INSERT INTO nuq_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Tama raa e mee ma taatou e me ki sesee Aia, e meia taatou se lavaa te kkite Aia, tena ma taatou se lavaa hoki te oo i te kina Aia e me ki noho raa. Tama raa e tattara maea?” ");
INSERT INTO nuq_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Te aho hakaoti te Kai raa he aho e rahi roo, tena Jisas ki mahike i aruna no tattara hakamaroa roo ma, “Te tama e hiunu raa ki hamai Anau, ");
INSERT INTO nuq_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","tena te tama e hakatina Anau raa e me ki hamai no unu.” E ssau pera ma te Launiu Tapu raa e tattara ma, “Te vai te ora raa e me ki tere iho i taha ma te vahi manava Tama raa.” ");
INSERT INTO nuq_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jisas e tattara peenei i te vahi TeAnana Tapu tera na tama e hakattina raa e me ki too raa. Te saaita naa Aia se ki kou ake TeAnana Tapu raa, maitaname Aia se ki haere no too na mahi Aia. ");
INSERT INTO nuq_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","E isi na tama i roto te kanohenua raa e llono na tattara Jisas raa, tena ki meake, “Te Tama nei ko te Profet TeAtua raa hakamaoni!” ");
INSERT INTO nuq_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Alaa tama e tattara ma, “Tama nei ko te Mesaia!” Emeia alaa tama e tattara ma, “Te Mesaia raa se lavaa te hamai i Galili! ");
INSERT INTO nuq_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Te Launiu Tapu raa e tattara ma te Mesaia raa he mokopuna te Tuku Devit raa, tena Aia e me ki haanau mai i Betlehem, te matakaina Devit ni noho i mua raa.” ");
INSERT INTO nuq_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tena te kanohenua raa ku hakatauttau hokolaatou e mee Jisas. ");
INSERT INTO nuq_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Alaa tama e hihhai ki hakapiki Tama raa, e meia se hai tama e kapake no ttaohi Tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Na soldia raa ku vakkai ake, tena na maatua hakananniu ia ma na Farisi raa ku vahiri ake na tama raa ma, “Kootou se too Tama raa no oo mai kootou raea?” ");
INSERT INTO nuq_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Kito na soldia raa ki meake, “Se hai tama roo e tattara na tattara te Tama nei e tattara raa!” ");
INSERT INTO nuq_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Kito na Farisi raa ki meake, “Eaa, Tama raa e mee kootou no vvare hoki? ");
INSERT INTO nuq_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kootou e illoa raa e isi te tama na tama hakamattua ia ma he Farisi ni hakatina Tama raa? ");
INSERT INTO nuq_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Te kanohenua raa se illoa laoi na tuaa Moses raa, tena na tama raa e me ki too na hakalono llihu TeAtua raa!” ");
INSERT INTO nuq_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tena he Farisi e noho i te kina raa, te inoa aia raa ko Nikodimas, teenaa ko te tama ni haere ake no mmata Jisas i mua raa. Tama raa e tattara ake na tama raa ma, ");
INSERT INTO nuq_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“I te vahi na tuaa taatou raa; taatou se lavaa te kou ake na hakalono llihu te tama kame taatou se vahiri tama raa ki too taatou te hakamaoni na mee tama raa e ppena e ssara raa.” ");
INSERT INTO nuq_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Kito na tama raa ki meake, “Eaa, akoe he tama hoki i Galili? Paupau te Launiu Tapu raa ki iroa akoe pera ma se isi te profet e me ki haanau mai i Galili.” ");
INSERT INTO nuq_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tena na tama hakaatoa ku vakkai i na hare laatou raa, e meia Jisas e haere i te Mouna e hhomo na Oliv raa. ");
INSERT INTO nuq_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Te tahata roo te aho taiao raa Jisas ku vaakai ake i te Hare Tapu. Na tama hakaatoa ku muimui ake Tama raa, tena Aia ki noho i raro no akoako ake te kanohenua raa. ");
INSERT INTO nuq_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kito na tama poroporo na tuaa raa laatou ma na Farisi raa ku kou ake te hine e laavea ria e pena te mee sakkino no hakatuu i mua na tama raa hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kito na tama raa ki meake Jisas, “Rabai, na tama raa e laavea te hine nei e pena te mee sakkino. ");
INSERT INTO nuq_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na tuaa Moses raa e mee mai taatou ma kame he hine e pena te mee sakkino peenei, tena na tama ku maka te hine naa na hatu ki mate. Tena kaa Akoe e maanatu maea?” ");
INSERT INTO nuq_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Na tama raa e vahiri ake peenei ma ki taaiki Jisas, ki lavaa laatou te mmau tattara i Tama raa. Emeia Jisas e huru koi i raro no sisi te mata rima Aia raa i aruna te kerekere. ");
INSERT INTO nuq_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Na tama raa e ttuu koi no vahihhiri ake Jisas na vahiri, tena Jisas ki hamatakkau i aruna no meake na tama raa, “Koai te tama kootou se isi na hai sara e ppena raa ku too te hatu kaamata raa no ppehi te hine nei.” ");
INSERT INTO nuq_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tena Aia ki huru hakaraoi i raro no sisi i aruna te kerekere. ");
INSERT INTO nuq_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Te saaita na tama raa ni llono na tattara raa, na tama raa ku hakaatoa ku haere uhu taki ttahi no oo; kaamata ma na tama mattua raa. Tena Jisas Hokoia koi ku ttoe, tena te hine raa hoki e tuu i te kina raa. ");
INSERT INTO nuq_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kito Jisas ki hamatakkau no tuu i aruna, tena ki meake te hine raa, “Na hee na tama naa? E isi te tama e ttoe ki mee mai ni tattara i te vahi akoe?” ");
INSERT INTO nuq_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tena te hine raa ki meake, “TeAriki, se hai tama e ttoe.” Kito Jisas ki meake, “Tena Anau hoki se hai tattara i te vahi akoe. Haere, tena auu se ppena hoki na mee sakkino.” ");
INSERT INTO nuq_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tena Jisas ki tattara ake na Farisi raa hakaraoi. Jisas e meake ma, “Anau ko te Maahina te maarama nei. Koai te tama e tautari Anau e me ki too te Maahina te ora, tena aia hoki se lavaa te hahaere i roto te pouri.” ");
INSERT INTO nuq_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kito na Farisi raa ki meake Jisas, “Tena te saaita nei Akoe ku tattara mai maatou i te vahi Akoe Hokkoe, e meia na tattara Akoe raa se isi roo te hakamaoni.” ");
INSERT INTO nuq_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Tena Jisas ki meake, “Niaina Anau e tattara i te vahi Anau Hokonnau, hea Anau e meatu raa e hakamaoni, maitaname Anau e iroa te kina Anau ni hamai ia ma te kina Anau e me ki haere raa. Kootou se illoa te kina Anau ni hamai ia ma te kina Anau e me ki haere raa. ");
INSERT INTO nuq_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kootou e hakatonutonu na mee hakaatoa tautari te hakataakoto te tama, e meia Anau se hai tama ni hakatonutonu. ");
INSERT INTO nuq_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Emeia peeraa Anau ki hakatonutonu na tama raa, tena te hakatonutonu Anau raa e me ki hakamaoni, maitaname Anau se mee ma Anau e hakatonutonu Hokonnau; te Tamana ni kauna ria mai Anau raa e noho ma Anau. ");
INSERT INTO nuq_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","E mmau i roto na tuaa kootou raa pera ma, kame tokorua na tama e hakattina te hakataakoto hokotahi, tena hea laaua e tattara raa e hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Anau e tattara i te vahi Anau Hokonnau, tena te Tamana ni kauna ria mai Anau raa e tattara hoki i te vahi Anau.” ");
INSERT INTO nuq_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kito na tama raa ki vahiri ake, “Teehee te Tamana Akoe naa?” Tena Jisas ki meake, “Kootou se illoa Anau ia ma te Tamana Anau raa hoki. Ia peeraa kootou ki illoa Anau; kootou e me ki illoa hoki te Tamana Anau raa.” ");
INSERT INTO nuq_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisas e tattara ake na tattara nei hakaatoa i te kanohenua raa te saaita Aia ni akoako i roto te Hare Tapu i te kina na tama raa e tukutuku na hoki raa. Ia se hai tama e hakapiki Tama raa e mee te saaita Aia e me ki taia ria no mate raa se ki tae. ");
INSERT INTO nuq_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Tena Jisas ki meake hakaraoi na tama raa pera ma, “Anau e me ki haere i taha; kootou e me ki sesee Anau, tena kootou e me ki mmate i na hai sara kootou. Kootou se lavaa te oo i te kina Anau e me ki haere raa.” ");
INSERT INTO nuq_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Kito na tama hakamattua na Jiu raa ki tattara ma, “Tama raa e tattara ma taatou se lavaa te oo i te kina Aia e me ki haere raa. Eaa, Aia e maanatu ma ki taa Aia Hokoia ki mate?” ");
INSERT INTO nuq_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Tena Jisas ki meake, “Kootou ni tama te maarama i raro nei, e meia Anau e hamai i aruna. Kootou ni tama te maarama nei, e meia Anau seai ma he tama te maarama nei. ");
INSERT INTO nuq_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Tera hea Anau e meatu ma kootou e me ki mate i na hai sara kootou raa. Tena kootou e me ki mmate i na hai sara kootou raa kame kootou se hakattina pera ma, ‘Anau ko Nau koi’.” ");
INSERT INTO nuq_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kito na tama raa ki meake, “Koai Akoe?” Tena Jisas ki meake, “Anau e me ki tattara atu kootou peehee? ");
INSERT INTO nuq_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Anau e tammaki na tattara ki tattara atu i te vahi kootou, ia tammaki hoki na tattara ki hai atu na haeo kootou raa. Te Tama ni kauna ria mai Anau raa e hakamaoni, tena Anau e tattara ake te maarama nei na mee Anau e rono Aia e tattara mai Anau raa.” ");
INSERT INTO nuq_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Na tama raa se illoa ma Jisas e tattara ake laatou i te vahi te Tamana. ");
INSERT INTO nuq_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kito Jisas ki meake na tama raa, “Te saaita kootou e ssau te Tamariki te Tama nei i aruna raa, tena kootou e me ki illoa pera ma ‘Anau ko Nau koi’, tena kootou e me ki illoa pera ma Anau se ppena na mee i na mahi Anau Hokonnau, e meia Anau e tattara koi hea te Tamana e tattara mai Anau ki tattara atu raa. ");
INSERT INTO nuq_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tena te Tama e kauna ria mai Anau raa e noho ma Anau; Tama raa se hai vahao e tiaki Anau, maitaname Anau e ppena tahi hea Aia e hihai raa.” ");
INSERT INTO nuq_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tammaki na tama e llono na tattara Jisas raa ku hakattina Tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kito Jisas ki meake na tama e hakattina i Aia raa, “Kame kootou e tauttari na akoako Anau nei, tena kootou ni disaipol hakamaoni Anau; ");
INSERT INTO nuq_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","kootou e me ki illoa te hakamaoni raa, tena te hakamaoni raa e me ki hakattana kootou.” ");
INSERT INTO nuq_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Kito na tama raa ki meake, “Maatou ni mokopuna Abraham, tena maatou se hai vahao e hehekau ma na tama. Kaa he hakataakoto peehee Akoe e tattara ma, ‘Kootou e me ki hakattana ria naa’?” ");
INSERT INTO nuq_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tena Jisas ki meake na tama raa, “Anau e meatu kootou te hakamaoni: na tama hakaatoa e isi na hai sara raa e nnoho i raro na mahi na hai sara raa. ");
INSERT INTO nuq_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Te tama hehekau raa seai ma he tama hakamaoni i roto te hare, e meia te tamariki raa he tama hakamaoni e noho tahi i roto te hare. ");
INSERT INTO nuq_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kame te Tama TeAtua raa e tokonaki kootou ki ttana, tena kootou e me ki ttana hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Anau e iroa kootou ni mokopuna Abraham. Emeia kootou e hahaivi ma ki taa Anau ki mate, maitaname kootou se hihhai ki tauttari na akoako Anau raa. ");
INSERT INTO nuq_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Anau e tattara hea te Tamana Anau raa e huri mai Anau raa, e meia kootou e ppena hea te tamana kootou raa ni tattara atu kootou raa.” ");
INSERT INTO nuq_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Kito na tama raa ki meake Jisas, “Te tamana maatou raa ko Abraham.” Tena Jisas ki meake, “Kame kootou ni tamalliki hakamaoni Abraham, tena kootou e me ki ppena na mee aia ni ppena raa. ");
INSERT INTO nuq_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Anau na vahao hakaatoa e tattara atu kootou te hakamaoni Anau e rono i TeAtua raa, e meia kootou e hahaivi ma ki taa Anau ki mate. Abraham se ppena na tiputipu peenei! ");
INSERT INTO nuq_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kootou e ppena hea te tamana kootou raa ni ppena.” Kito na tama raa ki meake, “TeAtua Hokoia koi ko te Tamana maatou e isi, tena maatou ni tamalliki hakamaoni Aia.” ");
INSERT INTO nuq_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tena Jisas ki meake na tama raa, “Kame TeAtua he Tamana kootou hakamaoni, kootou e me ki laoi Anau, maitaname TeAtua e kauna ria mai Anau, tera hea te aho nei Anau e noho i te kina nei. Anau se hamai te hihai Anau, e meia TeAtua e kauna ria mai Anau. ");
INSERT INTO nuq_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Aiea kootou se illoa hea Anau e tattara atu raea? E mee kootou se hihhai ki hakallono na tattara Anau raa. ");
INSERT INTO nuq_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kootou ni tamalliki Satan te tamana kootou raa, tena kootou e hihhai ki tauttari hea te tamana kootou raa e hihai. Te tama naa he tama taa tama kaamata mai roo i te kaamata, tena aia se hai vahao e tuu te vahi te hakamaoni, maitaname aia hokoia se isi te hakamaoni i roto aia. Te saaita aia e tattara te tattara mariu raa, aia e ppena koi hea e tau ma aia raa, maitaname aia he tama tattara mariu, tena aia ko te tamana na tama hakaatoa e tattara malliu raa. ");
INSERT INTO nuq_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Emeia Anau e tattara te hakamaoni tera hea kootou se hihhai ki hakattina Anau. ");
INSERT INTO nuq_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Koai te tama kootou e lavaa te mee mai te hakamaoni hea Anau e ppena e sara? Kame Anau e tattara atu te hakamaoni, tena kaa kootou se hakattina Anau naea? ");
INSERT INTO nuq_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Te tama e hamai TeAtua raa e hakarono na tattara TeAtua. Emeia kootou seai ma ni tamalliki TeAtua, tera hea kootou se hihhai ki hakallono.” ");
INSERT INTO nuq_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Kito na tama raa ki vahiri ake Jisas, “Eaa, maatou e sara te saaita maatou ni meatu pera ma Akoe he tama i Samaria, tena ma Akoe e isi te tipua i roto Akoe?” ");
INSERT INTO nuq_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Tena Jisas ki meake, “Anau se isi te tipua i roto Anau, tena Anau e hakammaha te Tamana Anau raa, e meia kootou se hakammaha Anau. ");
INSERT INTO nuq_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Anau se hihai ki ssau Anau Hokonnau i aruna. Emeia e isi te Tama e hihai ki ssau Anau, tena Aia ko te Tama e me ki hakatonutonu. ");
INSERT INTO nuq_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Anau e meatu kootou te hakamaoni: koai te tama e tautari na tattara Anau raa se lavaa te mate.” ");
INSERT INTO nuq_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Kito na tama raa ki meake, “Te saaita nei maatou ku illoa te hakamaoni pera ma Akoe e isi te tipua i roto Akoe! Abraham e mate, tena na profet raa hoki e mmate, e meia Akoe e mee ma na tama e tauttari na akoako Akoe raa se lavaa te mmate. ");
INSERT INTO nuq_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Abraham, te tamana maatou raa e mate; eaa Akoe e mee ma Akoe e hakanaaniu i aruna Abraham? Na profet raa hoki e mmate. Akoe e maanatu ma Akoe he tama peehee?” ");
INSERT INTO nuq_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Kito Jisas ki meake, “Kame Anau e hakammaha Anau Hokonnau, tena te hakammaha Anau raa he mee vare koi. Te Tama e hakammaha Anau raa ko te Tamana Anau raa, te Tama kootou e mee ma he Atua kootou raa. ");
INSERT INTO nuq_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kootou se illoa roo Tama raa, e meia Anau e iroa Tama raa. Kame Anau e tattara pera ma Anau se iroa Tama raa, tena Anau he Tama tattara mariu peenaa ma kootou. Emeia Anau e iroa Tama raa, tena Anau e tautari na tattara Tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham te tamana kootou raa e hihia ma aia e me ki kite te saaita Anau e hamai raa, tena aia ni kite no hihia roo.” ");
INSERT INTO nuq_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kito na tama raa ki meake Jisas, “Akoe se tae tipu rima na hetau te matua Akoe, tena Akoe e mee pera ma Akoe ni kite Abraham?” ");
INSERT INTO nuq_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Tena Jisas ki meake, “Anau e meatu kootou te hakamaoni roo. I mua Abraham ni haanau mai, ‘Teenei Anau’.” ");
INSERT INTO nuq_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tena na tama raa ki too na hatu raa ma ki maka Jisas, e meia Jisas e hakalluu Aia Hokoia, tena ki haere i taha ma te Hare Tapu raa. ");
INSERT INTO nuq_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisas ku haere, tena Aia ki kite te tama na karemata e sseni kaamata mai roo te saaita aia ni haanau iho raa. ");
INSERT INTO nuq_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tena na disaipol Jisas raa ki vahiri ake Tama raa, “Rabai, ni hai sara aii e mee te tama nei no sseni raa? Ni hai sara aia ma ni hai sara na maatua aia raa?” ");
INSERT INTO nuq_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Kito Jisas ki meake, “Seai ma ni hai sara te tama nei ia ma ni hai sara na maatua aia raa tera e mee na karemata tama nei no sseni. Tama nei e sseni ma ki kkite kootou na mahi TeAtua tera e me ki huri ake i roto te tama nei. ");
INSERT INTO nuq_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tena taatou ki tauhano te ppena na uata te Tama ni kauna ria mai Anau raa te saaita te mee raa koi maarama; te poo e me ki tae mai te saaita taatou ku se hai tama e uata. ");
INSERT INTO nuq_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Anau ko te Maahina te maarama nei te saaita Anau e noho i roto te maarama nei.” ");
INSERT INTO nuq_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jisas e tattara no oti, kito Aia ki saavare i aruna te kerekere raa, tena ki murumuru na saavare Aia raa ma na kerekere raa no pelapela, tena Aia ki mmuru na karemata te tama raa, ");
INSERT INTO nuq_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","tena ki meake, “Haere no huhui na karemata akoe raa i roto te Vai i Siloam.” (Te tattara nei e mee ma “Kauna”.) Kito te tama raa ki haere no huhui na karemata Aia, tena ki vaakai ake na karemata aia raa ku kkite. ");
INSERT INTO nuq_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Na tama te kauhare raa ia ma na tama ni kkite tama ni noho no kainonno i mua raa ku vahihhiri ma, “Teenei seai ma ko te tama kame e noho no kainonno raa?” ");
INSERT INTO nuq_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tena alaa tama ki meake ma, “Teenaa ko te tama naa koi,” e meia alaa tama e mee ma, “Seai, te tama naa e ssau roo pera ma te tama raa.” Kito te taupeara raa ki meake hokoia ma, “Teenei ko nau koi.” ");
INSERT INTO nuq_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kito na tama raa ki vahiri ake te taupeara raa, “Kaa akoe ku kite vahao nei naea?” ");
INSERT INTO nuq_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tena te tama raa ki meake, “Te tama e hui ma ko Jisas raa e murumuru na peela raa, tena ki mmuru na karemata anau raa, tena Aia ki mee mai ma anau ki haere no huhui na karemata anau i Siloam. Kito anau ki haere, ia te saaita koi anau ni huhui raa, anau ku lavaa te kite.” ");
INSERT INTO nuq_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Kito na tama raa ki vahiri ake ma, “Teehee te Tama naa?” Tena te tama raa ki meake, “Anau se iroa.” ");
INSERT INTO nuq_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tena te kanohenua raa ki too te tama ku kite raa no kkave i na Farisi raa. ");
INSERT INTO nuq_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Te aho Jisas ni mee na peela raa no mmuru na karemata te tama raa no kite raa he aho te Sabat. ");
INSERT INTO nuq_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tena na Farisi raa ki vahiri ake hakaraoi te tama ku kite raa ma aia ku lavaa te kite peehee. Kito te tama raa ki meake na Farisi raa, “Tama raa e mmuru na karemata anau raa ma na peela, tena ki oti anau ki huhui na karemata anau raa; teenei hea anau ku kite.” ");
INSERT INTO nuq_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tena e isi na Farisi ki meake, “Te tama e pena te mee nei raa seai ma he tama e hamai TeAtua, maitaname Aia se tautari na tuaa te Sabat raa.” Emeia alaa tama e tattara ma, “Te tama hai sara e lavaa peehee te ppena na mirakol peenei?” Tena na tama raa ku hakataukoti hokolaatou. ");
INSERT INTO nuq_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kito na Farisi raa ki vahiri ake hakaraoi te tama ku kite raa ma, “Akoe e mee ma Tama raa e tokonaki akoe no kite, tena kaa akoe e maanatu ma Aia koai?” Tena te tama raa ki meake, “Te Tama raa he Profet.” ");
INSERT INTO nuq_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Na tama hakamattua na Jiu raa se hihhai ki hakattina pera ma te tama raa i mua raa e sseni, tena te saaita nei ma aia ku kite hakaraoi. Kito na tama raa ki kanna ake na maatua te tama raa ");
INSERT INTO nuq_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","no vahiri ake tokorua raa ma, “Teenei he tama koorua? Koorua e mee ma te tama nei e sseni te saaita aia ni haanau mai raa; kaa te tama nei ku lavaa peehee te kite te saaita nei?” ");
INSERT INTO nuq_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Kito na maatua te tama raa ki meake, “Maaua e illoa ma teenei he taupeara maaua, tena maaua e illoa ma na karemata aia raa e sseni te saaita aia ni haanau iho raa. ");
INSERT INTO nuq_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Emeia maaua se illoa ma aia ku kite peehee te saaita nei, iaa maaua se illoa hoki te tama ni tokonaki te tama nei no kite raa. Vahiri ake te tama nei; aia ku matua, tena aia hokoia e lavaa te tattara atu kootou!” ");
INSERT INTO nuq_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Na maatua te tama raa e tattara peenei raa e mee laaua e mattaku i na tama hakamattua na Jiu raa, maitaname na tama raa ku oti te tattara no tonu ma kame he tama e hakatina ma Jisas ko te Mesaia, tena te tama naa e me ki hakatuu ria i taha ma te hare lotu. ");
INSERT INTO nuq_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tera hea na maatua te tama raa e meake ma, “Vahiri ake te tama nei; aia ku matua, tena aia e me ki tattara atu hokoia!” ");
INSERT INTO nuq_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kito na tama hakamattua na Jiu raa ki kanna ake te taupeara raa ki haere ake hakaraoi, tena laatou ki meake, “Tattara mai te hakamaoni i mua TeAtua pera ma akoe e me ki tattara te hakamaoni! Maatou e illoa ma te Tama e tokonaki akoe no kite raa he tama hai sara.” ");
INSERT INTO nuq_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Kito te taupeara raa ki meake, “Anau se iroa, Aia he tama hai sara ma seai, e meia te mee hokotahi koi anau e iroa raa: anau e iroa pera ma anau ni mee raa e sseni, tena te saaita nei anau ku kite.” ");
INSERT INTO nuq_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tena na tama raa ki vahiri ake, “Kaa Tama naa e mee peehee akoe? Aia e mee peehee akoe no kite?” ");
INSERT INTO nuq_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Kito te taupeara raa ki meake, “Anau ku oti te meatu kootou, tena kootou se hihhai ki hakallono. Aiea kootou e hihhai ki llono hakaraoi naea? Kame ko kootou hoki e hihhai ki mee pera ma ni disaipol Tama raa?” ");
INSERT INTO nuq_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kito na tama raa ku hai ake hakasakkino roo i te taupeara raa, tena ki meake, “Akoe avare he disaipol Tama raa; e meia maatou ni disaipol Moses. ");
INSERT INTO nuq_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Maatou e illoa ma TeAtua ni tattara ake Moses; e meia maatou se illoa ma te Tama naa e hamai i hee!” ");
INSERT INTO nuq_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kito te taupeara raa ki meake, “Anau e mahharo i na tattara naa! Kootou se illoa ma te Tama naa e hamai i hee, e meia Aia e tokonaki anau no kite! ");
INSERT INTO nuq_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Maatou e illoa TeAtua se hakarono na tama hai ssara; Tama raa e hakarono na tama e hakammaha Aia raa, tena ki ppena hea Aia e hihai ma na tama raa ki ppena raa. ");
INSERT INTO nuq_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Taatou se hai vahao roo ni llono i mua te saaita te maarama nei ni tipu ake ma he tama ni tokonaki te tama karemata sseni peenei no kite. ");
INSERT INTO nuq_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kame te Tama naa seai ma he tama TeAtua e kauna ria mai, tena te Tama naa se lavaa hoki te ppena he mee.” ");
INSERT INTO nuq_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Kito na tama raa ki meake, “Akoe e haanau no matua mai ma na hai sara, tena akoe e hihai ma ki akoako mai maatou?” Tena na tama raa ki hakatuu te taupeara raa i taha ma te hare lotu. ");
INSERT INTO nuq_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Te saaita Jisas ni rono hea ni kapihi ake te taupeara raa, tena Aia ki haere no mmata te taupeara raa, tena ki vahiri ake te taupeara raa, “Akoe e hakatina i te Tamariki te Tama nei?” ");
INSERT INTO nuq_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tena te taupeara raa ki meake, “Hakari mai te Tama naa ki iroa anau, ki lavaa anau te hakatina Tama naa!” ");
INSERT INTO nuq_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Tena Jisas ki meake, “Akoe ku oti te kite te Tama naa, teenei Aia nei e tattara ma akoe te saaita nei.” ");
INSERT INTO nuq_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kito te taupeara raa ki meake, “TeAriki, anau ku hakatina,” tena aia ki tuturi i mua Jisas. ");
INSERT INTO nuq_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Tena Jisas ki meake, “Anau e hamai i te maarama nei ki hakatonutonu, ki lavaa na tama e sseni raa te kkite, tena na tama e kkite raa ki sseni.” ");
INSERT INTO nuq_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","E isi na Farisi e ttuu i te kina raa no llono na tattara Jisas raa, tena na tama raa ki vahiri ake Jisas ma, “Hakamaoni Akoe kame e tattara ma maatou hoki e sseni nee?” ");
INSERT INTO nuq_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Kito Jisas ki meake, “Kame kootou e sseni, tena na hakataakoto kootou raa se lavaa te haeo ma kootou e ssara, e meia kame kootou e mee ma kootou e kkite, tena na hakataakoto kootou raa e me ki haeo ma kootou e ssara.” ");
INSERT INTO nuq_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Tena Jisas ki meake, “Anau e tattara atu kootou te hakamaoni: te tama se uru tonu te totoka raa, tena ki kake na vahi te hare na sipsip e moemmoe raa he tama kairarao, iaa he tama sakkino. ");
INSERT INTO nuq_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Te tama e uru tonu te totoka raa ko te tama e rorohi na sipsip raa. ");
INSERT INTO nuq_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Te tama e tuu te totoka raa e me ki taaraki te totoka raa ki uru te tama raa; na sipsip raa e llono te reo tama raa te saaita aia e kakanna na inoa na sipsip raa, tena ku hakattaki na manu raa i aho. ");
INSERT INTO nuq_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Te saaita na sipsip raa ku ttae i aho hakaatoa, te tama raa e me ki haere i mua na sipsip raa, tena na sipsip raa e me ki tauttari aia, maitaname na manu raa e illoa te reo tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Na sipsip raa se lavaa te tauttari he tama peeraa hoki; e meia na manu raa e me ki huro i taha ma te tama raa, maitaname laatou se illoa te reo te tama raa.” ");
INSERT INTO nuq_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas e tattara ake te tattara hurihuri nei, e meia na tama raa se illoa te hakataakoto te tattara hurihuri raa. ");
INSERT INTO nuq_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kito Jisas ki meake hakaraoi, “Anau e meatu te hakamaoni: Anau ko te totoka te hare na sipsip. ");
INSERT INTO nuq_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Na tama hakaatoa ni oo mai i mua raa ni tama kailallao, ia ni tama sakkino, e meia na sipsip raa se hihhai ki hakallono na tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Anau ko te totoka. Na tama e oo mai Anau raa e me ki ora; na tama raa e me ki oo mai i hare, tena ku oo i aho no sesee na kai. ");
INSERT INTO nuq_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Na tama kailallao raa e oo mai koi ki kailallao, ki taa ki mmate, tena ku seu kootou. Anau e hamai ma ki tokonaki kootou ki too te ora; te ora tera e pii na mee taualleka raa. ");
INSERT INTO nuq_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Anau ko te Tama tauareka te rorohi na sipsip, Anau e tanattana ki mate ma na sipsip raa. ");
INSERT INTO nuq_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Te saaita te tama na tama raa ni too ma ki rorohi na sipsip raa e kite te poi kai tama raa ku haere ake, te tama raa e me ki tiaki na sipsip raa no tere i taha, tena te poi kai tama raa e me ki oho ake na sipsip raa, tena na sipsip raa hakaatoa ku maaseu no huro. ");
INSERT INTO nuq_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Te tama na tama raa e too ki rorohi na sipsip raa e tere i taha e mee aia seai ma ko te tama hakamaoni ki rorohi na sipsip raa. ");
INSERT INTO nuq_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","15 Tena Anau ko te Tama tauareka te rorohi na sipsip raa. E ssau pera ma te Tamana e iroa Anau, tena Anau e iroa te Tamana, ia e ssau hoki pera ma Anau e iroa na sipsip Anau raa, tena na sipsip Anau raa e illoa Anau. Tena Anau e tanattana ki mate ma na sipsip raa. ");
INSERT INTO nuq_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","E isi alaa sipsip Anau seai i roto te hare nei. Anau e me ki kou mai laatou hoki; na manu naa e me ki hakallono te reo Anau raa, tena laatou e me ki oo mai no hakapaa hakaatoa, tena he tama hokotahi koi e me ki rorohi laatou. ");
INSERT INTO nuq_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Te Tamana e laoi Anau, maitaname Anau e tanattana ki hoki atu te ora Anau raa ma ki lavaa Anau te too muri te ora Anau raa hakaraoi. ");
INSERT INTO nuq_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Se hai tama e me ki too te ora Anau raa i taha ma Anau. Anau e hoki atu te ora Anau i te hihai Anau. Anau e isi na mahi ki hoki te ora Anau raa, tena Anau e isi na mahi hoki ki too muri te ora Anau raa. Teenei hea te Tamana e tattara mai Anau ki ppena.” ");
INSERT INTO nuq_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tena na tama raa ku hakataukoti hokolaatou, e mee na tattara Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tammaki na tama e tattara ma, “Tama naa e isi te tipua! Tama naa ku vvare! Aiea kootou e hakallono Tama naa naea?” ");
INSERT INTO nuq_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Emeia alaa tama e tattara ma, “Te tama e isi te tipua i roto aia se lavaa te tattara peenei! Te tipua se lavaa te mee na tama karemata sseni raa ki kkite!” ");
INSERT INTO nuq_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Teenaa ko te saaita te haumallii, tena te kanohenua Jerusalem raa ku kkai te Kai na Jiu raa e tataohi ki mannatu te Hakatapu te Hare Tapu. ");
INSERT INTO nuq_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jisas e hahaere vaa te kina te Paaro Solomon i roto te Hare Tapu raa, ");
INSERT INTO nuq_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","tena te kanohenua raa ki hakkutu ake iaa Jisas, tena ki vahiri ake Tama raa ma, “Akoe e mee roo maatou ki hakattari te saaita roroa roo. Tattara mai te hakamaoni: Akoe ko te Mesaia?” ");
INSERT INTO nuq_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Kito Jisas ki meake, “Anau ku oti te meatu kootou, e meia kootou se hihhai ki hakattina Anau. Na mee Anau e ppena i na mahi te Tamana Anau raa e huri atu ki illoa kootou koai Anau, ");
INSERT INTO nuq_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","e meia kootou se hihhai ki hakattina Anau, maitaname kootou seai ma ni sipsip Anau. ");
INSERT INTO nuq_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Na sipsip Anau raa e hakallono te reo Anau; Anau e iroa laatou, tena laatou e tauttari Anau. ");
INSERT INTO nuq_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Anau e kou ake laatou te ora e ora tahi, tena laatou se lavaa roo te mmate. Se hai tama e lavaa te too laatou i taha ma Anau. ");
INSERT INTO nuq_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Hea te Tamana e kou mai Anau raa e hakanaaniu i aruna na mee hakaatoa, tena se hai tama e lavaa te too laatou i taha ma na rima te Tamana. ");
INSERT INTO nuq_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Anau ma te Tamana e hokotahi roo.” ");
INSERT INTO nuq_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tena te kanohenua raa ki too hoki na hatu raa ma ki maka Jisas. ");
INSERT INTO nuq_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Tena Jisas ki meake na tama raa, “Anau e ppena tammaki roo na mee taualleka tera te Tamana raa e kou mai Anau ki ppena i mua na karemata kootou; kaa hea Anau e ppena tera kootou e hihhai ki maka Anau ma na hatu naa?” ");
INSERT INTO nuq_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Kito na tama raa ki meake, “Maatou se hihhai ki maka Akoe na hatu e mee na mee taualleka Akoe e ppena raa, e meia e mee Akoe e tattara haeo TeAtua! Akoe he tama koi, e meia Akoe e hihai ki mee ma Akoe ko TeAtua!” ");
INSERT INTO nuq_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Tena Jisas ki meake, “E mmau i roto na tuaa kootou raa pera ma TeAtua e mee ma, ‘Kootou ni atua.’ ");
INSERT INTO nuq_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Taatou e illoa pera ma hea e mmau i roto te Launiu Tapu raa e hakamaoni, tena TeAtua e kanna na tama tera Aia ni kou ake na tattara Aia raa ma ni atua. ");
INSERT INTO nuq_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ia i te vahi Anau, te Tamana e hirihiri Anau, tena ki kauna ria mai Anau ki hamai i te maarama nei. Kaa kootou e tattara ma Anau e tattara haeo TeAtua peehee, e mee Anau e tattara ma Anau he Tamariki TeAtua? ");
INSERT INTO nuq_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kame Anau se ppena hea te Tamana e hihai Anau ki ppena raa, tena auu se hakattina Anau. ");
INSERT INTO nuq_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Emeia kame Anau e ppena na mee raa, niaina kootou se hakattina Anau, kootou e tau te hakattina hea Anau e ppena raa ki lavaa kootou te illoa na vahao hakaatoa pera ma te Tamana e noho i roto Anau, tena Anau e noho i roto te Tamana.” ");
INSERT INTO nuq_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tena na tama raa ku hahaivi hoki ma ki hakapiki Jisas, e meia Aia hakalliha i taha ma na tama raa no haere. ");
INSERT INTO nuq_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jisas ku vaakai hakaraoi i teeraa vahi te riva Jordan raa, i te kina Jon ni hakoukou tapu na tama raa, tena Aia ki noho i te kina raa. ");
INSERT INTO nuq_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tammaki na tama e oo ake iaa Jisas no meake ma, “Jon se hai mirakol e huri mai, e meia na tattara hakaatoa aia e tattara i te Tama nei raa e hakamaoni.” ");
INSERT INTO nuq_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tena tammaki na tama i te kina raa ku hakattina iaa Jisas. ");
INSERT INTO nuq_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","He tama e laavea e noho i roto Betani, te inoa aia raa ko Lasarus. Betani ko te matakaina te haanau Meri laaua ma Marta e nnoho. ");
INSERT INTO nuq_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Te Meri nei ko te hine tera ni nnini te lloo manoni raa i aruna na tapuvae TeAriki raa, tena ki hakapakupaku na tapuvae Tama raa ma na rouru aia. Tena Lasarus te tama e laavea raa he kave Meri.) ");
INSERT INTO nuq_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Te haanau hhine raa e kkave te tattara iaa Jisas ma, “TeAriki, te soa laoi Akoe raa ku laavea.” ");
INSERT INTO nuq_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Te saaita Jisas ni rono na tattara raa, tena Aia ki tattara ake ma, “Te hakaotioti te maahana Lasarus nei seai ma ko te mate; te mee nei e kapihi mai ma ki lavaa TeAtua te huri mai na mahi hai mmahi, tena na mahi naa e me ki huri ake pera ma te Tamariki TeAtua raa e me ki too na mahi hai mmahi.” ");
INSERT INTO nuq_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas e laoi te hai taina Marta laaua ma Meri ia ma Lasarus te kave laaua raa, ");
INSERT INTO nuq_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ia niaina ma Aia e rono ma Lasarus e laavea, e meia Aia e noho koi i te kina raa no tae e rua na aho. ");
INSERT INTO nuq_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tena Aia ki meake na disaipol Aia raa, “Taatou ki vakkai i Judia.” ");
INSERT INTO nuq_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Kito na disaipol raa ki meake, “Rabai, paa saaita raa koi na tama i te matakaina raa e hihhai ma ki maka Akoe na hatu, tena Akoe ku maanatu ma ki vaakai hoki i te kina raa?” ");
INSERT INTO nuq_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Tena Jisas ki meake, “Te laa raa e hopo ake te tahata, tena ki huru te hiahi, kaa seai? Tena te tama e hahaere te ao raa se lavaa te ppaku na mee no hhina, maitaname laatou e kkite te maahina te maarama nei raa. ");
INSERT INTO nuq_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Emeia kame na tama raa e hahaere te poo, tena laatou e me ki ppaku no hhina, maitaname laatou se kkite te maahina te maarama nei raa.” ");
INSERT INTO nuq_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jisas e tattara peenei, tena ki hakapaa ake hoki ma, “Lasarus te soa taatou raa ku moe heiroa, e meia Anau e me ki haere no hakaaraa aia ki maahuru.” ");
INSERT INTO nuq_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Kito na disaipol raa ki meake, “TeAriki, kame aia e moe, tama naa e me ki tauareka.” ");
INSERT INTO nuq_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisas e tattara pera ma Lasarus ku mate, e meia na disaipol raa e kkahu ma Lasarus e moe heiroa koi. ");
INSERT INTO nuq_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kito Jisas ki tattara hakamatahua ake ma, “Lasarus ku mate, ");
INSERT INTO nuq_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","e meia Anau e hihia e mee Anau se noho i te kina raa, tena Anau e hihai ma kootou ki kkite ki lavaa kootou te hakattina. Taatou ki oo no mmata aia.” ");
INSERT INTO nuq_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tena Tomas e hui ma te Kokoa raa ku meake na disaipol laatou raa, “Taatou hakaatoa ki oo ma te Rabai raa ki mmate taatou ma Tama raa!” ");
INSERT INTO nuq_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Te saaita Jisas ni tae i Betani raa, tena Aia ku rono pera ma Lasarus ku oti te tanu e haa na aho ku llaka raa. ");
INSERT INTO nuq_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani e rua na mael se mmao hoki i taha ma Jerusalem, ");
INSERT INTO nuq_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","tena tammaki na tama i Judia ni oo ake no mmata Marta laaua ma Meri ma ki hakatatarahia tokorua raa i te mate Lasarus raa. ");
INSERT INTO nuq_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Te saaita Marta ni rono ma Jisas ku tae ake, tena aia ki haere no mmata Tama raa, e meia Meri e noho koi i hare. ");
INSERT INTO nuq_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Kito Marta ki meake Jisas ma, “TeAriki, peeraa koi Akoe ki noho i te kina nei, te kave anau raa se lavaa te mate! ");
INSERT INTO nuq_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Emeia anau e iroa pera ma TeAtua e me ki kou atu Akoe hea Akoe e kainno ake Aia raa.” ");
INSERT INTO nuq_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Kito Jisas ki meake, “Te kave akoe raa e me ki ora muri.” ");
INSERT INTO nuq_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tena Marta ki meake, “Anau e iroa pera ma aia e me ki ora muri i te aho hakaoti raa.” ");
INSERT INTO nuq_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Kito Jisas ki meake Marta, “Anau ko te ora muri ia ma te ora e ora tahi. Na tama e hakattina Anau raa e me ki ora, niaina laatou ku mmate; ");
INSERT INTO nuq_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","tena na tama hakaatoa e ora tera e hakattina Anau raa se lavaa te mmate. Akoe e hakatina te tattara nei?” ");
INSERT INTO nuq_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tena Marta ki meake, “Hakamaoni roo, TeAriki! Anau e hakatina pera ma Akoe ko te Mesaia, te Tamariki TeAtua tera ni hamai i te maarama nei raa.” ");
INSERT INTO nuq_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta e tattara ake no oti, tena aia ki vaakai i hare no kanna hemuu ake Meri te taina aia raa. Tena Marta ki meake Meri ma, “Te Rabai raa ku tae mai, tena Aia e vahiri akoe.” ");
INSERT INTO nuq_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Te saaita Meri ni rono na tattara nei, aia ku mahike no haere hakavave no mmata Jisas. ");
INSERT INTO nuq_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Jisas se ki tae roo i roto te matakaina, e meia Aia e noho koi i te kina Marta ni ttiri Aia raa.) ");
INSERT INTO nuq_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Na tama e nnoho i hare ma Meri no hakatatarahia te tama raa ku tauttari Meri te saaita laatou ni kkite aia ni mahike i aruna no haere hakavave i aho raa. Na tama raa e kkahu ma Meri ku haere i te kava no tanitani. ");
INSERT INTO nuq_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Meri ku tae i te kina Jisas e noho raa, tena te saaita koi aia ni kite Jisas, aia ku hina atu i mua na vae Jisas. Tena Meri ki meake, “TeAriki, peeraa Akoe ki noho i te kina nei, te kave anau raa se lavaa te mate!” ");
INSERT INTO nuq_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisas e kite Meri e tani, tena ki kite hoki na tama e ttuu vaa raa e tanittani laatou ma Meri, tena te aroha Aia raa ku haere ake roo. ");
INSERT INTO nuq_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kito Jisas ki vahiri ake na tama raa, “Kootou e tanu Lasarus i hee?” Tena na tama raa ki meake, “TeAriki, Hamai no mmata.” ");
INSERT INTO nuq_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisas ku tani. ");
INSERT INTO nuq_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Na tama raa ku tattara ma, “Kira ake, Jisas e aroha mahi roo Lasarus!” ");
INSERT INTO nuq_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Emeia alaa tama e tattara ma, “Tama raa e mee na tama karemata sseni raa no kkite, kaa seai? Kaa Aia se lavaa peehee te mee Lasarus ki se mate?” ");
INSERT INTO nuq_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Te aroha Jisas raa ku haere ake hakaraoi, tena Aia ki haere i te taruma. Te taruma raa he rua e tuu te vahi te mouna, tena te hatu raa e ppui te totoka te taruma raa. ");
INSERT INTO nuq_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tena Jisas ki meake, “Hakatupe te hatu raa i taha!” Tena Marta te kave Lasarus raa ki meake, “TeAriki, te kina nei e me ki purau roo. Tama naa e tanu e haa na aho ku llaka raa!” ");
INSERT INTO nuq_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Kito Jisas ki meake Marta, “Anau ni mee raa se meatu ma akoe e me ki kite na mahi hai mmahi TeAtua raa kame akoe e hakattina?” ");
INSERT INTO nuq_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kito na tama raa ki hakatupe te hatu raa i taha. Tena Jisas ki kkira i aruna no meake, “Tamana, Anau e hakammaha Akoe e mee Akoe e hakarono Anau. ");
INSERT INTO nuq_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Anau e iroa pera ma Akoe e hakarono Anau na vahao roo hakaatoa, e meia Anau e tattara peenei ki mee na tama e ttuu i te kina nei raa ki hakattina pera ma Akoe e kauna ria mai Anau.” ");
INSERT INTO nuq_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jisas e lotu ake peenei no oti, tena Aia ki kanna ake hakamaroa roo ma, “Lasarus, hamai i aho!” ");
INSERT INTO nuq_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kito Lasarus ki hamai i aho, e meia na paamaro na tama raa ni mmini na rima ia ma na vae aia raa e mmau koi, hakapaa ma te paamaro e uhi na karemata aia raa. Tena Jisas ki meake na tama raa, “Vvete na paamaro raa i taha ma te tama raa, tena ku tiaki aia ki haere.” ");
INSERT INTO nuq_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tammaki na tama ni oo ake no mmata Meri raa e kkite hea Jisas ni ppena raa, tena na tama raa ku hakattina iaa Jisas. ");
INSERT INTO nuq_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Emeia e isi na tama e vakkai no meake na Farisi raa hea Jisas ni ppena raa. ");
INSERT INTO nuq_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kito na Farisi raa laatou ma na maatua hakananniu raa ku kkutu ma na tama hakamattua na Jiu raa no tattara ma, “Hea taatou e me ki ppena? Kira ake na mirakol hakaatoa te Tama nei ni ppena raa! ");
INSERT INTO nuq_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kame taatou e tiaki Tama nei ki tauhano no ppena na mee nei, tena na tama hakaatoa e me ki hakattina Tama nei, tena na tama hakamattua i Rom raa e me ki oo mai no seu te Hare Tapu ia ma te henua taatou nei!” ");
INSERT INTO nuq_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","He tama hokotahi na tama raa, te inoa aia raa ko Kaiafas, tena aia ko te pohouru hakanaaniu na maatua te hetau naa. Tama raa e meake ma, “Kootou ni vvare hakaatoa! ");
INSERT INTO nuq_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kootou se isi na hakataakoto pera ma e tauareka kootou te tiaki he tama hokotahi ki mate ma na tama hakaatoa, ki se lavaa na tama te henua raa te taaia ria no mmate hakaatoa?” ");
INSERT INTO nuq_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Te hakamaoni, Kaiafas se tattara peenei i te hakataakoto koi aia; e meia e mee aia ko te pohouru hakanaaniu na maatua te hetau naa, tena aia ki tattara ake pera ma Jisas e me ki mate ma na Jiu hakaatoa, ");
INSERT INTO nuq_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ia se mee ma na Jiu raa koi, e meia ki hakkutu mai hakaatoa na tama TeAtua tera e nnoho maseu raa ki mee pera ma he kanohenua hokotahi. ");
INSERT INTO nuq_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kaamata te aho naa, na tama hakamattua na Jiu raa ku penapena na hakataakoto ma ki taa Jisas ki mate. ");
INSERT INTO nuq_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tena Jisas ku se hahaere ki kkite na tama i Judia raa, e meia Aia e haere i te kina e tuu taapiri te kina e tuu mahoa i te matakaina e hui ma ko Efraim raa, tena Aia ki nnoho ma na disaipol Aia raa i te kina raa. ");
INSERT INTO nuq_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Te saaita te Kai te Pasova raa ku taapiri, tena tammaki na tama ku tiaki na matakaina laatou raa no oo i Jerusalem ki mee na ora laatou raa ki matahua i mua na maihu TeAtua. ");
INSERT INTO nuq_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Na tama raa ku sesee Jisas, tena te saaita laatou ni kkutu hakaatoa i roto te Hare Tapu raa, na tama raa ku vahihhiri hokolaatou ma, “Kootou e mannatu maea? Tama naa kame se lavaa te hamai te Kai nei!” ");
INSERT INTO nuq_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Na maatua hakananniu raa laatou ma na Farisi raa e kou ake te tattara ma kame he tama e iroa te kina Jisas e noho raa, tena te tama naa ku haere ake no meake laatou ki oo laatou no hakapiki Tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ia e ono na aho i mua te Kai te Pasova raa, Jisas ku vaakai i Betani i te hare Lasarus, te tama Aia ni hakaora raa. ");
INSERT INTO nuq_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Na tama raa e tanattana na kai ki kai Jisas i te hare raa, kito Marta e parepare ake na kai raa, tena Lasarus e noho hoki i te tebol raa ma Jisas. ");
INSERT INTO nuq_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tena Meri ku too te lloo manoni e sui mmaha tera e hakauru ma te nad raa, tena ki nnini te lloo raa i aruna na tapuvae Jisas raa, tena ki hakapakupaku ma te rouru aia raa. Te manoni te lloo raa ku taakai vaa roto te hare raa hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Judas Iskariot, he disaipol hoki Jisas, ia te tama e me ki oti ku hakari ake Jisas i na tama hakamattua raa ku meake ma, ");
INSERT INTO nuq_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Aiea te lloo nei se kou ake alaa tama ki taui e toru huitarau na sileni, tena na sileni naa ku mee ki tokonaki na tama hakaalloha raea?” ");
INSERT INTO nuq_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas e tattara peenei se mee ma aia e maanatu na tama hakaalloha raa, e meia e mee aia he tama kairarao. Judas e hahaere ma te muri kopu na sileni, tena aia e kairarao hoki na sileni raa. ");
INSERT INTO nuq_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Emeia Jisas e meake ma, “Tiaki te hine naa! Te hine naa e tataohi roo te lloo raa ki tanattana te aho Anau e me ki tanu raa. ");
INSERT INTO nuq_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Na tama hakaalloha raa e me ki nnoho tahi ma kootou, e meia Anau se lavaa te noho tahi ma kootou.” ");
INSERT INTO nuq_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tammaki na Jiu ku llono ma Jisas ku tae i Betani, tena laatou ki oo i te matakaina raa, ia laatou se oo koi e mee Jisas e noho i te kina raa, e meia laatou e oo e mee laatou e hihai hoki ki kkite Lasarus, te tama ni mate raa, tena Jisas ki hakaora aia no ora raa. ");
INSERT INTO nuq_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kito na maatua hakananniu raa ki tattara ma ki taa hoki Lasarus ki mate, ");
INSERT INTO nuq_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","maitaname te tattara te ora muri Lasarus raa e mee na Jiu raa no se hakattina laatou, tena ki hakattina koi iaa Jisas. ");
INSERT INTO nuq_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Te aho taiao raa, na tama ni oo ake i te Kai te Pasova raa ku llono ma Jisas ku haere ake i Jerusalem. ");
INSERT INTO nuq_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kito na tama raa ki tuutuu na raraa na laakau raa, tena ki oo ake ma ki ttiri Jisas; na tama raa e haere vavaa ma, “Hakammaha TeAtua! TeAtua e hakatapu te Tama e hamai i te inoa TeAriki raa! TeAtua e hakatapu te Tuku Israel!” ");
INSERT INTO nuq_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisas e kite te donki, tena ki kake i aruna te manu raa no tere, e ssau pera ma hea e mmau i roto te Launiu Tapu ma, ");
INSERT INTO nuq_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Te matakaina e rahi Saion, auu se mattaku! Teenei te Tuku kootou nei ku hamai, ia e tere atu i aruna te donki.” ");
INSERT INTO nuq_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Na disaipol raa se illoa te mee nei i te kaamata; e meia te saaita Jisas ni ora muri ma na mahi hai mmahi raa, tena laatou ku mannatu na tattara e mmau i roto te Launiu Tapu tera e tattara i te vahi Jisas raa, tena laatou se ppena hoki te mee nei ma ki hakammaha Tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Te kanohenua ni ttuu i te kina raa ma Jisas te saaita Aia ni kanna ake Lasarus ki hamai i aho ma te taruma raa, tena ki hakaora tama raa ku tattara ake hea ni kapihi ake raa. ");
INSERT INTO nuq_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tera hea te kanohenua raa e oo ma ki ttiri laatou ma Jisas, maitaname laatou e llono ma teeraa ko Jisas e ppena te mirakol raa. ");
INSERT INTO nuq_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kito na Farisi raa ki tattara hokolaatou ma, “Kootou e kkite, taatou ku seai i na mee roo hakaatoa! Kira ake, te maarama nei hakaatoa ku tauttari Tama raa!” ");
INSERT INTO nuq_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","E isi na Grik hoki i roto na tama e oo i Jerusalem ma ki lotu te saaita te Kai raa. ");
INSERT INTO nuq_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Na tama raa e oo iaa Filip raa (teenei he tama i Betsaida i roto Galili) no meake, “Tama hakamaatua, maatou e hihhai ki kkite Jisas.” ");
INSERT INTO nuq_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Kito Filip ki haere no meake Andru, tena tokorua raa ki oo no meake Jisas. ");
INSERT INTO nuq_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tena Jisas ki meake tokorua raa, “Te saaita te Tamariki te Tama nei e me ki too na mahi hai mmahi raa ku tae mai. ");
INSERT INTO nuq_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Anau e tattara atu te hakamaoni: te hua te wit raa e me ki se lavaa te tammaki na kai kame aia se tteiho i aruna te kerekere raa no mate. Kame te hua raa e mate, tena na hua aia e hua raa e me ki tammaki roo. ");
INSERT INTO nuq_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Na tama e hakasessere na ora laatou raa e me ki llano i taha ma te ora hakamaoni raa, tena na tama se mannako na ora laatou i te maarama nei raa e me ki too te ora e ora tahi. ");
INSERT INTO nuq_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Te tama e hihai ki hehekau ma Anau raa ki tautari Anau, ki lavaa na tama hehekau Anau raa te nnoho ma Anau i te kina Anau e noho raa. Tena te Tamana Anau raa e me ki hakammaha na tama e hehekau ma Anau raa. ");
INSERT INTO nuq_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Te saaita nei Anau ku tipuaina haeo roo i roto Anau. Kaa hea Anau e me ki meake? Eaa, Anau ki meake ma, ‘Tamana, Auu se tiaki te saaita raa ki tae mai’? Emeia, kaa teenaa kaa hea Anau e hamai naa. Anau e hamai ki hakalono llihu te saaita naa. ");
INSERT INTO nuq_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tamana, kou mai na mahi hai mmahi i te inoa Akoe!” Tena te reo raa ki tattara iho i te vaelani ma, “Anau ku oti te kou atu na mahi hai mmahi i te inoa Anau, tena Anau e me ki kou atu hakaraoi na mahi naa.” ");
INSERT INTO nuq_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Te kanohenua e ttuu i te kina raa e llono te reo raa, tena alaa tama ki tattara ma teeraa he hatturi, ia alaa tama e mee ma, “Teeraa he ensel e tattara ake Tama raa!” ");
INSERT INTO nuq_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Emeia Jisas e tattara ake na tama raa ma, “Te reo raa se tattara iho ma ki rono Anau, e meia ki llono kootou. ");
INSERT INTO nuq_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Te saaita nei ko te saaita e me ki hakatonutonu te maarama nei; te saaita nei te tama hakamatua i te maarama nei raa e me ki hakattuu ria i taha ma te kakkake aia raa. ");
INSERT INTO nuq_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Te saaita Anau e me ki ssau ria i aruna no haere i taha ma te maarama nei raa, Anau e me ki hakattaki mai na tama hakaatoa i te maarama nei raa ki haere Anau.” ");
INSERT INTO nuq_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jisas e tattara ake peenei ki huri ake te mate ia ma na hakalono llihu Aia. ");
INSERT INTO nuq_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kito te kanohenua raa ki meake, “Na tuaa taatou raa e tattara mai ma te Mesaia raa e me ki noho tahi roo. Kaa Akoe e tattara peehee ma te Tamariki te Tama nei e me ki ssau ria i aruna? Tena kaa koai te Tamariki te Tama nei naa?” ");
INSERT INTO nuq_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Kito Jisas ki meake, “Te Maahina raa e me ki nnoho ma kootou paa saaita koi. Kootou ki hahaere te saaita te Maahina raa e nnoho ma kootou, ki se lavaa te pouri raa te haere atu no uhi kootou; maitaname te tama e hahaere i roto te pouri raa se iroa te kina aia e haere raa. ");
INSERT INTO nuq_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Hakattina i te Maahina raa, te saaita te Maahina raa e nnoho ma kootou, tena kootou e me ki mee pera ma ni tama te maahina.” Jisas e tattara ake na tattara nei no oti, tena Aia ki haere no mmuni i taha ma na tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Niaina roo ma Jisas e ppena na mirakol nei i mua na karemata na tama raa, e meia na tama raa se hakattina koi iaa Jisas, ");
INSERT INTO nuq_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","tena hea profet Aisaia ni tattara raa ku huri mai no hakamaoni ma: “TeAriki, koai te tama e hakatina na tattara maatou e tattara ake raa? TeAriki e huri ake na mahi Aia raa aii?” ");
INSERT INTO nuq_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Tena na tama raa se lavaa te hakattina e mee Aisaia e tattara hoki ma: ");
INSERT INTO nuq_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“TeAtua e mee na karemata na tama raa no sseni, tena ki ppui na hakataakoto na tama raa, ki se lavaa na karemata na tama raa te kkite, tena na kapuroro na tama raa se lavaa te illoa, tena TeAtua e mee ma na tama raa se lavaa te oo ake Aia, ma ki tokonaki Tama raa na tama raa.” ");
INSERT INTO nuq_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia e tattara peenei, maitaname aia e kite na mahi hai mmahi Jisas; tera hea aia e tattara i te vahi Tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Niaina ma e tammaki na tama hakamattua na Jiu raa e hakattina iaa Jisas, e meia laatou se hihhai ki tattara ma ki llono na tama e mee laatou e mattaku na Farisi raa; ma ka oti na tama raa ku hakatuu laatou i taha ma te hare lotu. ");
INSERT INTO nuq_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Na Farisi raa e mannatu ma na tama ki hakammaha koi laatou, tena laatou se mannatu hoki ma TeAtua ki hakammaha laatou. ");
INSERT INTO nuq_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisas e tattara ake hakamaroa ma, “Te tama e hakatina Anau raa se mee ma e hakatina koi Anau, e meia aia e hakatina hoki te Tama e kauna ria mai Anau raa. ");
INSERT INTO nuq_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ia te tama e kite Anau raa e kite hoki te Tama e kauna ria mai Anau raa. ");
INSERT INTO nuq_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Anau e hamai i roto te maarama nei pera ma he maahina, ki se lavaa na tama hakaatoa e hakattina Anau raa te nnoho koi i roto te pouri raa. ");
INSERT INTO nuq_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kame he tama e rono na tattara Anau raa no se tautari; Anau se lavaa te hakatonutonu te tama naa. Anau se hamai ki hakatonutonu te maarama nei, e meia Anau e hamai ki tokonaki te maarama nei. ");
INSERT INTO nuq_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Na tama se hihhai Anau, ia se hihhai hoki ki too na tattara Anau raa e isi te Tama hokotahi e me ki hakatonutonu laatou. Na tattara Anau e tattara raa ko na tattara tera e me ki hakatonutonu laatou i te aho hakaoti raa! ");
INSERT INTO nuq_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Te tattara nei e hakamaoni, maitaname Anau se tattara i na mahi Anau Hokonnau, e meia te Tamana ni kauna ria mai Anau raa e tattara mai hea Anau e me ki tattara atu raa. ");
INSERT INTO nuq_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Tena Anau e iroa pera ma na tattara Aia raa e kou mai te ora e ora tahi. Tena na tattara Anau e tattara raa, ni tattara Tamana e tattara mai Anau ki tattara atu.” ");
INSERT INTO nuq_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Teenaa ko te aho i mua te Kai te Pasova raa. Jisas e iroa pera ma te saaita Aia ku mee ki tiaki te maarama nei no vaakai te Tamana raa ku tae mai. Aia na vahao hakaatoa e laoi na tama i roto te maarama nei tera e mee pera ma ni tama roo Aia raa, tena Aia e laoi na tama raa haere no tae roo te hakaoti. ");
INSERT INTO nuq_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jisas ma na disaipol Aia raa e nnoho ma ki kkai te hiahi. Emeia Satan ku oti te kou ake te hakataakoto iaa Judas Iskariot, te tama Saimon raa ma ki hakari ake Jisas i na tama hakamattua raa. ");
INSERT INTO nuq_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisas e iroa pera ma te Tamana e kou ake na mahi hakaatoa Aia, tena Aia e iroa pera ma Aia e hamai i TeAtua, tena e me ki vaakai i TeAtua. ");
INSERT INTO nuq_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kito Jisas ki mahike i taha ma te tebol raa no ui te kaukahu Aia raa, tena ki nnoa te muri maro raa areha na paioro Aia. ");
INSERT INTO nuq_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kito Aia ki nnini na vai raa i roto te paa kumete, tena ki kaamata no huhui na tapuvae na disaipol raa, tena Aia ki hakapakupaku na tapuvae na tama raa ma te muri maro Aia e nnoa areha na paioro Aia raa. ");
INSERT INTO nuq_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jisas e haere huhui na tapuvae na tama raa no tae ake Saimon Pita, tena Saimon Pita ki meake, “TeAriki, Akoe e me ki huhui na tapuvae anau?” ");
INSERT INTO nuq_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tena Jisas ki meake Pita, “Te saaita nei akoe se iroa hea Anau e ppena nei, e meia i muri akoe e me ki iroa.” ");
INSERT INTO nuq_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Kito Pita ki meake, “Akoe se lavaa roo te huhui na tapuvae anau he saaita!” Tena Jisas ki meake, “Kame Anau se huhui na tapuvae akoe naa, tena akoe se lavaa te mee pera ma he disaipol Anau.” ");
INSERT INTO nuq_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Kito Saimon Pita ki meake, “TeAriki, kame peenaa Akoe se lavaa te huhui koi na tapuvae anau nei! Huhui hoki na rima ia ma te pohouru anau raa.” ");
INSERT INTO nuq_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Tena Jisas ki meake, “Na tama e koukou hakaatoa raa ku matahua roo, tena laatou ku se tau hoki te koukkou, e meia na tapuvae laatou raa e kkere koi. Kootou hakaatoa e matahua, e meia he tama hokotahi se matahua.” ");
INSERT INTO nuq_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Jisas ko na iroa roo avare te tama e me ki hakari ake Aia i na tama hakamattua raa; tera hea Aia e tattara ma, “Kootou hakaatoa e matahua, e meia he tama hokotahi koi se matahua.”) ");
INSERT INTO nuq_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jisas e huhui na tapuvae na disaipol raa no oti, tena Aia ki uru hakaraoi te kaukahu Aia raa, tena ki vaakai no noho te kina Aia ni noho raa. Kito Aia ki meake, “Kootou e illoa hea Anau e ppena i kootou te saaita nei? ");
INSERT INTO nuq_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kootou e kakanna Anau Rabai ia ma TeAriki, tena e tonu kootou te ppena peenaa, maitaname teenei Anau nei. ");
INSERT INTO nuq_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Anau TeAriki ia ma te Rabai kootou nei e huhui vahao nei koi na tapuvae kootou raa. Tena kootou hoki ki huhui na tapuvae kootou hokkootou. ");
INSERT INTO nuq_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Anau e huri atu hea kootou e me ki ppena raa, tena kootou e me ki ppena hea Anau ni ppena i kootou te saaita nei raa. ");
INSERT INTO nuq_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Anau e tattara atu te hakamaoni: te tama hehekau raa se hakamaatua i aruna te tama hakamaatua aia raa, tena na tama e kavekave na tattara raa se hakamattua i aruna te tama e kauna laatou raa. ");
INSERT INTO nuq_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Teenei kootou ku illoa te hakamaoni nei te saaita nei, tena kootou e me ki hihhia roo kame kootou e tauttari na mee nei. ");
INSERT INTO nuq_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Anau se tattara kootou hakaatoa; Anau e iroa na tama Anau e hirihiri raa. Emeia na tattara i roto te Launiu Tapu nei e me ki hakamaoni, ‘Te tama e kaikkai hakapaa maaua na kai anau raa e me ki huri no haeo anau.’ ");
INSERT INTO nuq_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Anau e tattara atu na mee nei i mua na mee nei e kapihi atu, tena te saaita na mee nei e kapihi atu raa, kootou e me ki hakattina pera ma, ‘Anau ko Nau koi’. ");
INSERT INTO nuq_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Anau e tattara atu te hakamaoni; koai te tama e too hakaraoi te tama Anau e kauna raa e too hakaraoi hoki Anau, tena koai e too hakaraoi Anau e too hakaraoi hoki te Tama e kauna ria mai Anau raa.” ");
INSERT INTO nuq_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisas e tattara ake peenei no oti, tena Aia ku tipuaina haeo roo, kito Aia ki meake tahi koi na tama raa ma, “Anau e meatu te hakamaoni: he tama kootou e me ki hakari ake Anau i na tama hakamattua raa.” ");
INSERT INTO nuq_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tena na disaipol raa ku oho no kirakira huri hokolaatou ma Jisas e tattara aii. ");
INSERT INTO nuq_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tena he disaipol hokotahi, te tama Jisas e hihai mahi raa, e noho taapiri ake Jisas. ");
INSERT INTO nuq_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Kito Saimon Pita ki auna ake te tama raa, tena ki meake, “Vahiri atu Tama raa ma Aia e tattara aii.” ");
INSERT INTO nuq_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kito te disaipol raa ki hakapare atu te vahi Jisas raa no vahiri ake ma, “TeAriki, koai te tama naa?” ");
INSERT INTO nuq_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tena Jisas ki meake, “Anau e me ki ttoki ni haraoa i roto te hakamomoa raa, tena ku kou ake te tama naa; teenaa ko te tama Anau e tattara.” Kito Jisas ki too te muri haraoa raa no ttoki te hakamomoa raa, tena ki kou ake Judas, te tama Saimon Iskariot raa. ");
INSERT INTO nuq_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Te saaita koi Judas ni too te haraoa raa, Satan ku tau i roto aia. Kito Jisas ki meake tama raa, “Akoe ki vave ma hea akoe e me ki ppena raa!” ");
INSERT INTO nuq_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Iaa se hai tama na disaipol raa e illoa ma Jisas e meake peeraa iaa Judas raea. ");
INSERT INTO nuq_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","E mee Judas ko te tama e rorohi te muri kopu na sileni raa, tena e isi na disaipol e mannatu ma Jisas e meake Judas ki haere no sui hea laatou e hihhai ki mee te kai raa, ia seai naa ku kou ake ni mee ma na tama hakaalloha raa. ");
INSERT INTO nuq_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas e too te haraoa raa, tena ki haere i aho te saaita naa koi. Te mee raa ku poo. ");
INSERT INTO nuq_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas ku oti te haere, tena Jisas ki meake, “Te saaita nei kootou e me ki kkite na mahi hai mmahi te Tamariki te Tama nei; te saaita nei Aia e me ki huri ake na mahi hai mmahi TeAtua raa i roto Aia. ");
INSERT INTO nuq_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Tena kame Aia e huri ake na mahi hai mmahi TeAtua raa i roto Aia, TeAtua e me ki huri ake hoki na mahi te Tamariki te Tama nei i roto Aia, tena Aia e me ki ppena koi peenei te vahao hokotahi nei. ");
INSERT INTO nuq_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Aku tamalliki, Anau se lavaa te nnoho ma kootou saaita roroa hoki. Kootou e me ki sesee Anau; e meia Anau e meatu kootou te saaita nei hea Anau ni meake na tama hakamattua na Jiu raa ma, ‘Kootou se lavaa te oo i te kina Anau e me ki haere raa.’ ");
INSERT INTO nuq_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Tena te saaita nei Anau e me ki kou atu te tuaa vahao nei: laoi te tama ma te tama. Tena kootou ki laoi te tama ma te tama e ssau pera ma Anau e laoi kootou. ");
INSERT INTO nuq_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kame kootou e laoi te tama ma te tama, tena na tama hakaatoa e me ki illoa pera ma kootou ni disaipol Anau.” ");
INSERT INTO nuq_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Kito Saimon Pita ki vahiri ake Jisas, “TeAriki, Akoe e me ki haere i hee?” Tena Jisas ki meake, “Akoe se lavaa te tautari mai Anau te saaita nei, e meia i muri akoe e me ki tautari mai Anau.” ");
INSERT INTO nuq_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Kito Pita ki meake, “TeAriki, aiea anau se lavaa te tautari Akoe te saaita nei naea? Anau e tanattana ki mate ma Akoe!” ");
INSERT INTO nuq_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Tena Jisas ki meake, “Akoe e tanattana hakamaoni ki mate ma Anau? Anau e meatu te hakamaoni: i mua te manu tane raa e tani te poo nei, akoe e me ki kore e toru na vahao pera ma akoe se iroa Anau.” ");
INSERT INTO nuq_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Tena Jisas ki meake na disaipol raa, “Kootou ki se tipuaina no mamannatu tammaki. Kootou ki hakattina TeAtua, tena ku hakattina hoki Anau. ");
INSERT INTO nuq_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","E tammaki roo na rum i roto te hare te Tamana Anau raa, tena Anau e me ki haere no tanattana ni kina ma kootou. Anau se lavaa te tattara atu peenei kame te mee nei se hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","I muri Anau ku oti te haere no tanattana na kina kootou raa, tena Anau e me ki vaakai mai no too kootou ki oo taatou; ki nnoho kootou ma Anau i te kina Anau e noho raa. ");
INSERT INTO nuq_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kootou e illoa te mateara e haere i te kina tera Anau e haere raa?” ");
INSERT INTO nuq_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Kito Tomas ki meake Jisas, “TeAriki, maatou se illoa te kina Akoe e haere naa; kaa maatou e me ki illoa peehee te mateara e haere no tae i te kina naa?” ");
INSERT INTO nuq_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tena Jisas ki meake Tomas, “Anau ko te Mateara, te Hakamaoni ia ma te Ora; Anau ko te mateara, tena se hai mateara peeraa hoki te tama e lavaa te tae Tamana. ");
INSERT INTO nuq_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Teenei kootou ku illoa Anau te saaita nei, tena kootou e me ki illoa hoki te Tamana, tena kaamata te saaita nei kootou ku illoa Tama raa, ia kootou ku oti te kkite Tama raa.” ");
INSERT INTO nuq_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Kito Filip ki meake Jisas, “TeAriki, huri mai te Tamana ki kkite maatou; teenaa koi hea maatou e hihhai.” ");
INSERT INTO nuq_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tena Jisas ki meake, “Filip, Anau e nnoho ma kootou taku saaita e roroa roo, tena kootou se ki illoa roo Anau? Na tama e kkite Anau raa e kkite Tamana. Tena, kaa kootou e mee mai ma, ‘Huri mai Tamana naea’? ");
INSERT INTO nuq_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Filip, akoe se hakatina pera ma Anau e noho i roto Tamana, tena Tamana e noho i roto Anau?” Tena Jisas ki meake na disaipol Aia raa ma, “Na tattara Anau e tattara atu kootou raa seai ma ni tattara koi Anau. Te Tamana e noho tahi i roto Anau raa e ppena hea Aia e maanatu ki ppena raa. ");
INSERT INTO nuq_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kootou ki hakattina Anau te saaita Anau e meatu pera ma Anau e noho i roto Tamana, tena Tamana e noho i roto Anau. Kaa seai kootou ku hakattina e mee kootou e kkite na mee e llahi Anau ni ppena raa. ");
INSERT INTO nuq_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Anau e tattara atu te hakamaoni: na tama e hakattina Anau raa e me ki ppena na mee Anau ni ppena raa. Hakamaoni, na tama naa e me ki ppena na mee e llahi roo, maitaname Anau e me ki vaakai no nnoho Maaua ma Tamana. ");
INSERT INTO nuq_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Tena Anau e me ki ppena he mee peehee kootou e kainno mai i te inoa Anau, ki kkite na tama hakaatoa na mahi hai mmahi TeAtua tera te Tamariki Aia raa e isi. ");
INSERT INTO nuq_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kame kootou e kainno mai ni mee peehee i te inoa Anau, tena Anau e me ki ppena hea kootou e kainno mai raa. ");
INSERT INTO nuq_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Kame kootou e laoi Anau, kootou e me ki tauttari na tuaa Anau raa. ");
INSERT INTO nuq_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Anau e me ki kainno ake te Tamana Anau raa, tena Aia e me ki kou atu teeraa Tokonaki, te Tama naa e me ki nnoho tahi roo ma kootou. ");
INSERT INTO nuq_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Te Tama naa ko TeAnana Tapu tera e me ki hakari atu te hakamaoni TeAtua raa. Te maarama nei se lavaa te too Tama raa, e mee te maarama nei se lavaa te kkite, ia te illoa Tama raa. Emeia kootou e illoa Tama raa, maitaname Aia e noho ma kootou, ia e noho hoki i roto kootou. ");
INSERT INTO nuq_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Te saaita Anau e haere raa, Anau se lavaa te tiaki kootou ki nnoho hokkootou; Anau e me ki vaakai mai kootou. ");
INSERT INTO nuq_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Se roroa te maarama nei ku se lavaa te kkite Anau, e meia kootou e me ki kkite Anau; e mee Anau e ora, tena kootou hoki e me ki ora. ");
INSERT INTO nuq_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Te saaita te aho naa e tteiho mai raa, kootou e me ki illoa pera ma Anau e noho i roto Tamana, tena kootou e nnoho i roto Anau, e ssau pera ma Anau e noho i roto kootou. ");
INSERT INTO nuq_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Na tama e hakallono na tuaa Anau raa, tena ki tauttari na tuaa raa ko na tama e laoi Anau. Te Tamana Anau raa e me ki laoi na tama tera e laoi Anau raa; Anau hoki e me ki laoi na tama raa, tena ku huri ake Anau Hokonnau i na tama raa.” ");
INSERT INTO nuq_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tena Judas (seai ma ko Judas Iskariot) ki meake, “TeAriki, Akoe e me ki huri mai Akoe Hokkoe i maatou, kaa na tama i te maarama nei raa e me ki seai?” ");
INSERT INTO nuq_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Kito Jisas ki meake te tama raa, “Te tama e laoi Anau raa e me ki tauttari na akoako Anau. Te Tamana Anau raa e me ki laoi aia, tena Anau ma te Tamana Anau raa e me ki oo mai no nnoho ma te tama naa. ");
INSERT INTO nuq_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Te tama se laoi Anau raa se lavaa te tautari na akoako Anau. Tena na akoako kootou ni llono raa seai ma ni akoako Anau, e meia na akoako raa e oo mai Tamana, te Tama ni kauna ria mai Anau raa. ");
INSERT INTO nuq_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Anau ku oti te tattara atu na mee nei te saaita Anau ni nnoho ma kootou raa. ");
INSERT INTO nuq_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","TeAnana Tapu, te Tokonaki kootou tera te Tamana e kauna ria atu kootou i te inoa Anau raa e me ki akoako atu kootou na mee roo hakaatoa, tena ku mee kootou ki mannatu na mee roo hakaatoa Anau ni tattara atu raa. ");
INSERT INTO nuq_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Te noho laoi nei ko te mee Anau e tiaki ki nnoho ma kootou; teenei he noho laoi Anau tera Anau e kou atu kootou. Anau se kou atu pera ma na tiputipu te maarama nei kame e kou atu na mee raa. Auu se tipuaina no mamannatu tammaki; ia auu se mattaku. ");
INSERT INTO nuq_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kootou e llono Anau e tattara atu kootou, ‘Anau e me ki haere, e meia Anau e me ki vaakai mai kootou.’ Kame kootou e laoi Anau, tena kootou e me ki hihhia, maitaname Anau e me ki haere te Tamana Anau raa, e mee Aia e hakanaaniu i aruna Anau. ");
INSERT INTO nuq_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Anau e tattara atu kootou na mee nei vahao nei i mua na mee nei e me ki kapihi atu raa, tena te saaita na mee nei e kapihi atu raa, kootou e me ki hakattina. ");
INSERT INTO nuq_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Anau se lavaa te tattara ma kootou ki roroa hoki, maitaname te tama hakamaatua te maarama nei raa ku hamai. Tama raa se isi na mahi aia i aruna Anau, ");
INSERT INTO nuq_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","e meia te maarama nei e tau te illoa pera ma Anau e laoi te Tamana; tera hea Anau e ppena na mee hakaatoa Aia e mee mai Anau ki ppena raa. “Oo mai, taatou ki oo i taha ma te kina nei. ");
INSERT INTO nuq_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Anau ko te laakau vain hakamaoni, tena te Tamana Anau raa ko te Tama te paupaku raa. ");
INSERT INTO nuq_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tama raa e me ki ttuu i taha na raraa Anau tera se hhua na hua raa, tena ku verevere hakaraoi na raraa tera e hhua na hua raa ki attea ki hhua tammaki na hua. ");
INSERT INTO nuq_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kootou ku oti te matahua e mee na akoako Anau ni kou atu kootou raa. ");
INSERT INTO nuq_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Hukui tahi ma Anau, tena Anau e me ki hukui tahi ma kootou. Te raraa hokoia se lavaa te hua na hua, te raraa raa e me ki hua koi kame aia e mmau ma te laakau vain raa. Tena kootou hoki se lavaa te hhua na hua kame kootou se hukui ma Anau. ");
INSERT INTO nuq_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Anau ko te laakau vain, tena kootou ko na raraa. Na tama tera e hukkui ma Anau, tena Anau e hukui ma laatou raa e me ki hhua tammaki na hua; maitaname kootou se lavaa te ppena ni mee kame Anau seai. ");
INSERT INTO nuq_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Te tama se hukui ma Anau raa e me ki peesia ria pera ma he raraa ki moe no pakupaku; na raraa peenei raa e me ki hakkutu ria no lletu i roto te ahi ki vvela raa. ");
INSERT INTO nuq_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kame kootou e hukui ma Anau, tena na uata Anau raa e mmoe i roto kootou, tena kootou e lavaa te kainno mai ni mee peehee kootou e hihhai, tena kootou e me ki too na mee naa. ");
INSERT INTO nuq_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Na hua kootou e hhua raa e huri ake na mahi hai mmahi te Tamana Anau raa; tera hea kootou e mee pera ma ni disaipol Anau. ");
INSERT INTO nuq_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Anau e laoi kootou pera ma te Tamana e laoi Anau; hukui tahi ma Anau ki laoi Anau kootou. ");
INSERT INTO nuq_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kame kootou e tauttari na tattara Anau raa, tena kootou e me ki nnoho i roto te laoi Anau raa, e ssau pera ma Anau e tautari na tattara te Tamana Anau raa, tena Anau e noho i roto te laoi Aia. ");
INSERT INTO nuq_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Anau e tattara atu na mee nei ma ki moe te hihia Anau raa i roto kootou, tena kootou e me ki hihhia hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Te tuaa Anau raa e mee peenei: laoi te tama ma te tama, e ssau pera ma Anau e laoi kootou raa. ");
INSERT INTO nuq_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Te laoi e rahi roo te tama e lavaa te isi ki tokonaki na soa aia raa ko te ora aia. ");
INSERT INTO nuq_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tena kootou e me ki mee pera ma ni soa Anau kame kootou e ppena hea Anau ni tattara atu raa. ");
INSERT INTO nuq_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Anau ku se lavaa hoki te kanna kootou pera ma ni tama hehekau, maitaname na tama hehekau raa se illoa hea te tama hakamaatua laatou raa e hihai. Emeia Anau e kanna kootou pera ma ni soa Anau, maitaname Anau ku oti te tattara atu na mee hakaatoa Anau e rono te Tamana Anau raa e tattara mai. ");
INSERT INTO nuq_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kootou se hirihiri Anau; Anau ni hirihiri kootou, tena ki tini kootou ki oo no hhua tammaki na hua, na hua tera e me ki mmoe tahi raa. Tena te Tamana e me ki kou atu kootou niaa kootou e kainno ake Aia i te inoa Anau. ");
INSERT INTO nuq_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Teenei te tuaa Anau e meatu kootou: laoi te tama ma te tama. ");
INSERT INTO nuq_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Kame na tama te maarama nei e kiri lloto kootou, tena kootou ki mannatu pera ma laatou e kiri lloto Anau i mua. ");
INSERT INTO nuq_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kame kootou e tauttari na tiputipu te maarama nei raa, tena na tama te maarama nei raa e me ki hihai roo kootou pera ma ni tama roo laatou. Emeia Anau ni hirihiri kootou ki oo mai i taha ma te maarama nei, tena kootou seai ma ni tama te maarama nei; tera hea na tama te maarama nei raa e kiri lloto kootou. ");
INSERT INTO nuq_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mannatu hea Anau ni tattara atu kootou raa: ‘Na tama hehekau raa se hakamattua i aruna na tama hakamattua laatou raa.’ Kame na tama raa e kou mai na hakalono llihu Anau, tena na tama raa e me ki kou atu hoki na hakalono llihu kootou; kame laatou e hakallono na akoako Anau raa, tena na tama raa e me ki hakallono hoki na akoako kootou raa. ");
INSERT INTO nuq_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Emeia na tama raa e me ki ppena na mee nei hakaatoa i kootou, e mee kootou ni tama Anau, tena laatou hoki se illoa te Tama ni kauna ria mai Anau raa. ");
INSERT INTO nuq_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Na tama raa se lavaa te mannatu ma laatou e hai ssara, ia peeraa Anau ki se hamai no tattara ake na tama raa, peeraa vahao nei na tama raa se lavaa te tattara huhu na hai sara laatou raa. ");
INSERT INTO nuq_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Na tama e kiri lloto Anau raa e kiri lloto hoki te Tamana Anau raa. ");
INSERT INTO nuq_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Na tama raa se lavaa te mannatu ma laatou e hai sara peeraa Anau ki se hamai no ppena i mua na karemata laatou raa na mee tera se hai tama hoki ni ppena raa, tena na tama raa ni kkite na mee Anau ni ppena raa, tena laatou ku kiri lloto Anau ma te Tamana Anau raa. ");
INSERT INTO nuq_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Emeia na mee nei e me ki kapihi atu ki mee na tattara e mmau i roto na tuaa nei raa ki hakamaoni: ‘Na tama raa e lloto vare koi Anau.’ ");
INSERT INTO nuq_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Te Tokonaki e me ki hamai, teenaa ko TeAnana Tapu tera e hamai i TeAtua raa, tena Aia e me ki hakari mai te hakamaoni Tamana. Anau e me ki kauna ria atu TeAnana Tapu e nnoho laaua ma Tamana raa, tena Aia e me ki tattara atu kootou i te vahi Anau. ");
INSERT INTO nuq_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Tena kootou hoki e me ki tattara i te vahi Anau, maitaname kootou ni nnoho ma Anau i te kaamata roo. ");
INSERT INTO nuq_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Anau ku oti te tattara atu na mee nei, ki se lavaa kootou te tiaki na hakattina kootou raa. ");
INSERT INTO nuq_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kootou e me ki hakattuu ria i taha ma na hare lotu, tena e isi te saaita koi hamai tera na tama e me ki taa kootou no mmate raa e me ki mannatu ma laatou e ppena hea TeAtua e hihai. ");
INSERT INTO nuq_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Na tama e me ki ppena na mee nei i kootou, maitaname laatou se illoa Anau ia ma te Tamana Anau raa. ");
INSERT INTO nuq_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Emeia Anau ku oti te tattara atu kootou, maitaname e isi te saaita e me ki tae atu, tena kootou e me ki kkite na tama raa e ppena na mee nei, tena kootou e me ki mannatu hea Anau ni tattara atu kootou raa. “Anau ni se tattara atu na mee nei i te kaamata roo e mee Anau e nnoho ma kootou. ");
INSERT INTO nuq_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Emeia te saaita nei, Anau e me ki vaakai i te Tama tera ni kauna ria mai Anau raa, e meia se hai tama kootou e vahiri mai Anau ma Anau e me ki haere i hee. ");
INSERT INTO nuq_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Emeia teenei Anau ku oti te tattara atu kootou nei, tena kootou e me ki alloha roo i roto kootou. ");
INSERT INTO nuq_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Emeia Anau e tattara atu te hakamaoni: e me ki tauareka ma kootou kame Anau e haere i taha, maitaname kame Anau se haere i taha, te Tokonaki raa se lavaa te hamai. Emeia kame Anau e haere i taha, tena Anau e me ki kauna ria mai te Tokonaki raa ki hamai no nnoho ma kootou. ");
INSERT INTO nuq_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tena te saaita Aia e hamai raa, Aia e me ki huri ake na tama hakaatoa te maarama nei raa te hakamaoni pera ma laatou e ssara i te vahi na hai ssara ia ma hea e tonu ia ma te hakatonutonu TeAtua i na tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Na tama raa e ssara i te vahi na hai sara, maitaname na tama raa se hakattina i Anau; ");
INSERT INTO nuq_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","na tama raa e ssara i te vahi na mee e ttonu, maitaname Anau e me ki vaakai i te Tamana Anau raa, tena kootou se lavaa hoki te kkite Anau; ");
INSERT INTO nuq_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","tena na hakataakoto na tama raa e ssara i te vahi na tama TeAtua e me ki hakatonutonu raa, maitaname TeAtua ku oti te hakatonutonu te tama hakamaatua i te maarama nei raa. ");
INSERT INTO nuq_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Anau e isi tammaki roo na mee ki tattara atu kootou, e meia na mee nei e me ki tammaki roo ma kootou te amo te saaita nei. ");
INSERT INTO nuq_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tena te saaita TeAnana Tapu raa e hamai raa, Aia e me ki huri atu te hakamaoni TeAtua, tena Aia e me ki hakattaki kootou ki illoa te hakamaoni na mee roo hakaatoa. Tama raa se lavaa te tattara i na mahi Aia Hokoia, e meia Tama raa e me ki tattara atu kootou hea Aia e rono raa, tena Aia e me ki tattara atu kootou na mee tera e me ki oo mai i muri raa. ");
INSERT INTO nuq_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tama raa e me ki huri atu kootou na mahi hai mmahi Anau, maitaname Aia e me ki too hea Anau ni tattara ake Aia raa no tattara atu kootou. ");
INSERT INTO nuq_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Na mee hakaatoa te Tamana Anau raa e isi raa ni mee Anau; tera hea Anau e tattara atu pera ma TeAnana Tapu raa e me ki too hea Anau e tattara ake Aia ki tattara atu kootou raa. ");
INSERT INTO nuq_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Se roroa kootou e me ki se lavaa te kkite Anau, tena se roroa hoki kootou e me ki kkite Anau.” ");
INSERT INTO nuq_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tena e isi na disaipol ku vahihhiri hokolaatou ma, “Te hakataakoto te tattara nei raa e mee maea? Tama raa e tattara mai taatou ma se roroa taatou e me ki se kkite Aia, tena se roroa hoki taatou e me ki kkite Aia, tena Aia e tattara hoki ma, ‘Na mee nei e mee raa e mee Anau e me ki haere te Tamana Anau raa.’ ");
INSERT INTO nuq_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Te tattara ma ‘se roroa raa’ e mee maea? Taatou se illoa hea Tama raa e tattara mai taatou raa.” ");
INSERT INTO nuq_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisas e iroa ma na disaipol raa e mee ma ki vahiri ake Aia, kito Aia ki meake na tama raa, “Anau e meatu kootou, ‘Se roroa kootou e me ki se kkite Anau, tena se roroa hoki kootou e me ki kkite Anau.’ Teenei hea kootou e vahihhiri hokkootou? ");
INSERT INTO nuq_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Anau e tattara atu te hakamaoni: kootou e me ki alloha no tanittani hakamaroa roo, e meia na tama te maarama nei raa e me ki hihhia; kootou e me ki alloha, e meia ki oti na alloha naa ku huri no hihhia. ");
INSERT INTO nuq_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Te hine ku taapiri ki mamaoha raa e me ki aroha aia hokoia, maitaname te saaita te hakalono llihu aia raa ku tae ake; e meia te saaita te tamariki raa e hopo raa, te hine raa e me ki ssiri na hakalono llihu aia raa hakaatoa, maitaname aia ku hihia e mee te tamariki raa ku haanau iho i te maarama nei. ");
INSERT INTO nuq_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Teenei hea e nnoho ma kootou te aho nei: kootou e me ki alloha, e meia Anau e me ki kite kootou hakaraoi, tena kootou e me ki hihhia roo i roto na hatu manava kootou, teenei ko te hihia tera se hai tama e lavaa te ui i taha ma kootou. ");
INSERT INTO nuq_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Te saaita te aho naa e tae mai raa, kootou e me ki se lavaa te kainno mai Anau ni mee peehee. Anau e tattara atu te hakamaoni: Te Tamana e me ki kou atu niaa kootou e kainno ake Aia i te inoa Anau. ");
INSERT INTO nuq_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","I mua, kootou se hai tama e kainno ake TeAtua i te inoa Anau niaa kootou e hihhai, ia kainno tena kootou e me ki too ki lavaa kootou te too te hihia hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Anau e tattara atu kootou na mee nei i na tattara hurihuri. Emeia e isi te saaita e me ki tae mai, tena Anau se lavaa te tattara atu na tattara hurihuri, e meia Anau e me ki tattara hakamatahua atu kootou i te vahi te Tamana. ");
INSERT INTO nuq_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Te saaita te aho naa e tae mai raa, kootou e me ki kainno ake Tama raa na mee i te inoa Anau, tena Anau se tattara atu ma Anau e me ki kainno ake Tama raa ma kootou, ");
INSERT INTO nuq_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","maitaname te Tamana Hokoia e laoi kootou. Aia e laoi kootou maitaname kootou e laoi Anau, tena ki hakattina pera ma Anau e hamai TeAtua. ");
INSERT INTO nuq_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Anau e hamai Tamana no tae mai i te maarama nei. Tena vahao nei Anau e me ki tiaki te maarama nei no vaakai muri te Tamana Anau raa.” ");
INSERT INTO nuq_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tena na disaipol Aia raa ki meake Jisas ma, “Te saaita nei Akoe ku tattara hakamatahua mai, tena Akoe ku se tattara na tattara hurihuri. ");
INSERT INTO nuq_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Te saaita nei maatou ku illoa pera ma Akoe e iroa roo na mee hakaatoa; Akoe e iroa na hakataakoto na tama hakaatoa niaina laatou se vahiri atu Akoe. Te mee nei e mee maatou no hakattina pera ma Akoe e hamai TeAtua.” ");
INSERT INTO nuq_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Kito Jisas ki meake na tama raa, “Kootou ku hakattina roo te saaita nei? ");
INSERT INTO nuq_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","E isi te saaita e me ki tae mai, tena te saaita naa ku tae mai, teenaa ko te saaita kootou hakaatoa e me ki maaseu huri no huro na matakaina kootou raa, tena ku tiaki Anau ki noho Hokonnau. Emeia Anau se mee ma Anau e noho Hokonnau, maitaname Tamana e noho i roto Anau. ");
INSERT INTO nuq_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Anau e tattara te mee nei ki lavaa kootou te nnoho taravare e mee kootou e hukui ma Anau. Na tama te maarama nei raa e me ki mee kootou ki hakalono llihu. Emeia kootou ki se mattaku! Anau ku oti te seu na mahi te maarama nei!” ");
INSERT INTO nuq_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisas e tattara ake na tattara Aia raa no oti, tena Aia ki kkira i te vaelani no lotu ma, “Tamana, te saaita Anau e me ki hakalono llihu raa ku tae mai. Huri ake na mahi hai mmahi te Tamariki Akoe raa, ki lavaa te Tamariki Akoe raa te huri ake na mahi hai mmahi Akoe raa. ");
INSERT INTO nuq_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Maitaname Akoe e kou mai Anau na mahi ki hakamaatua i aruna na tama roo hakaatoa ma ki lavaa Anau te kou ake te ora e ora tahi raa i na tama Akoe ni kou mai Anau raa. ");
INSERT INTO nuq_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Tena te hakataakoto te ora e ora tahi raa e mee na tama ki illoa Akoe; TeAtua hokotahi tera e hakamaoni raa, ia ki illoa hoki Jisas Krais, te Tama Akoe ni kauna ria mai raa. ");
INSERT INTO nuq_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Anau ku oti te huri ake na mahi hai mmahi Akoe raa i te maarama nei; Anau ku oti te ppena na uata hakaatoa Akoe ni kou mai Anau ki ppena raa. ");
INSERT INTO nuq_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tamana! Kou mai na mahi hai mmahi Akoe raa vahao nei Akoe koi noho ma Anau, kou mai na mahi e ssau pera ma na mahi Anau ni isi te saaita Anau ni noho ma Akoe i mua te maarama nei ni tipu ake raa. ");
INSERT INTO nuq_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Anau e tattara ake na tama Akoe ni kou mai i roto te maarama nei raa no illoa mai Akoe. Na tama raa ni tama Akoe, tena Akoe e kou mai na tama raa i Anau. Na tama raa e hakallono roo na tattara Akoe raa, ");
INSERT INTO nuq_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","tena te saaita nei laatou ku illoa pera ma na mee hakaatoa Akoe ni kou mai Anau raa ni mee e oo mai Akoe. ");
INSERT INTO nuq_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Anau e tattara ake no llono na tama raa na tattara Akoe ni kou mai Anau raa, tena na tama raa ku too na tattara raa; na tama raa e illoa pera ma Anau e hamai Akoe, tena laatou e hakattina hoki pera ma Akoe e kauna ria mai Anau. ");
INSERT INTO nuq_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Anau e lotu ma na tama raa. Anau se lotu ma na tama te maarama nei hakaatoa, e meia Anau e lotu ma na tama koi Akoe ni kou mai Anau raa, maitaname na tama raa ni tama Akoe. ");
INSERT INTO nuq_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Na mee hakaatoa Anau e isi raa ni mee Akoe, tena na mee hakaatoa Akoe e isi raa ni mee Anau, tena na mee raa e me ki huri ake na mahi Anau. ");
INSERT INTO nuq_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Tena te saaita nei Anau e me ki vaakai atu Akoe; Anau ku se lavaa hoki te noho i roto te maarama nei, e meia na tama raa e me ki nnoho i te maarama nei. Tamana e Tapu! Rorohi laoi na tama raa i na mahi te inoa Akoe, teenaa ko te inoa Akoe ni kou mai Anau ma ki lavaa na tama raa te nnoho pera ma he kanohenua hokotahi, e ssau pera ma Taaua e hokotahi raa. ");
INSERT INTO nuq_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Te saaita Anau e nnoho ma na tama raa, Anau e rorohi hakaraoi na tama raa i na mahi te inoa Akoe, teenaa ko te inoa Akoe ni kou mai Anau raa. Anau e rorohi hakappuru na tama raa, tena se hai tama na tama raa ni llano, e meia te tama koi e tau te rano raa e me ki rano, ki mee na tattara te Launiu Tapu raa ki hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Tena te saaita nei, Anau ku haere atu Akoe, tena Anau e tattara na tattara nei i te maarama nei ki lavaa na tama raa te hihhia hakamaoni roo i roto na hatu manava laatou. ");
INSERT INTO nuq_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Anau e kou ake na tattara Akoe raa no llono na tama raa, tena na tama te maarama nei raa ku se hihhai na tama raa, maitaname na hakataakoto na tama raa se hakanatahi pera ma na hakataakoto na tama te maarama nei raa, e ssau pera ma na hakataakoto Anau raa se hakanatahi ma na hakataakoto na tama te maarama nei raa. ");
INSERT INTO nuq_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Anau se kainno atu Akoe ki too na tama raa i taha ma te maarama nei, e meia Anau e kainno atu Akoe ki rorohi laoi na tama raa i taha ma na mahi Satan. ");
INSERT INTO nuq_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Na tama raa seai ma ni tama te maarama nei, e ssau pera ma Anau seai ma he tama te maarama nei. ");
INSERT INTO nuq_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Na tattara Akoe raa e hakamaoni, tena Akoe ku hakatapu na ora na tama raa i na mahi na tattara hakamaoni Akoe raa. ");
INSERT INTO nuq_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Anau e kauna na tama raa ki oo vaa roto te maarama nei, e ssau pera ma Akoe ni kauna ria mai Anau ki hamai i te maarama nei raa. ");
INSERT INTO nuq_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Tena ku tokonaki na tama raa. Anau e hoki atu te ora Anau raa ki hehekau ma Akoe, ki lavaa na tama raa te hoki atu hoki na ora laatou raa ki hehekau ma Akoe. ");
INSERT INTO nuq_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Anau se lotu atu ma ki tokonaki koi na tama nei, e meia ki tokonaki hoki na tama tera e hakattina Anau i na tattara laatou raa. ");
INSERT INTO nuq_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Anau e lotu ma na tama raa ki nnoho pera ma he kanohenua hokotahi. Tamana! Tokonaki na tama raa ki nnoho i roto Taaua, ki lavaa na tama te maarama nei raa te hakattina pera ma Akoe e kauna ria mai Anau. ");
INSERT INTO nuq_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Anau e kou ake na tama raa na mahi pera ma na mahi Akoe ni kou mai Anau raa, ia ki lavaa hoki na tama raa te hukui no hokotahi, e ssau pera ma Taaua e hokotahi raa: ");
INSERT INTO nuq_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Anau e noho i roto na tama raa, tena Akoe e noho i roto Anau ki tokonaki na tama raa ki hukui hakamaoni no hokotahi, ia ki lavaa na tama te maarama nei raa te illoa pera ma Akoe e kauna ria mai Anau, tena ki illoa hoki pera ma Akoe e laoi laatou pera ma Akoe e laoi Anau raa. ");
INSERT INTO nuq_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tamana! Akoe e kou mai na tama raa i Anau, tena Anau e hihai ma na tama raa ki nnoho i te kina Anau e noho raa ki lavaa na tama raa te kkite na mahi hai mmahi Anau raa, teenaa ko na mahi hai mmahi Akoe ni kou mai Anau raa, maitaname Akoe e laoi Anau i mua te maarama nei ni tipu ake. ");
INSERT INTO nuq_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Tamana e Tonu tahi! Na tama te maarama nei raa se illoa Akoe, e meia Anau e iroa Akoe, tena na tama Akoe e kou mai Anau raa e illoa ma Akoe e kauna ria mai Anau. ");
INSERT INTO nuq_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Anau e tattara ake na tama raa no illoa Akoe, tena Anau e me ki tauhano te ppena peenei, ki lavaa te laoi Akoe Anau raa te moe i roto na tama raa, tena Anau hoki ki noho i roto na tama raa.” ");
INSERT INTO nuq_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Te saaita Jisas ni lotu no oti, Aia ku haere ma na disaipol Aia raa i teeraa vahi te Riva Kidron. Tena e isi te paupaku e hhomo na oliv e tuu i te kina raa, tena Jisas ma na disaipol Aia raa ki oo i roto te paupaku raa. ");
INSERT INTO nuq_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, te tama e me ki hakari ake Jisas raa e iroa te paupaku raa, maitaname Jisas e kkutu tammaki na vahao ma na disaipol Aia raa i te kina raa. ");
INSERT INTO nuq_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kito Judas ki haere ake ma na soldia i Rom raa hakapaa ma na soldia e lollohi te Hare Tapu tera na maatua hakananniu ia ma na Farisi raa ni kauna ria ki oo ake raa, tena na tama raa e oo ake ma na haana laatou raa, na lamu ia ma na laiti. ");
INSERT INTO nuq_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisas e iroa na mee roo hakaatoa tera e me ki kapihi ake Aia te poo naa, tena Jisas ki haere atu no vahiri ake na tama raa, “Koai te tama kootou e sesee naa?” ");
INSERT INTO nuq_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Kito na tama raa ki meake, “Jisas te tama i Nasaret raa.” Tena Jisas ki meake, “Teenei Anau nei.” Judas te tama sakkino raa e tuu i te kina raa ma na soldia raa. ");
INSERT INTO nuq_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Te saaita Jisas ni meake ma, “Teenei Anau nei,” na tama raa ku horo muri no hhina i raro. ");
INSERT INTO nuq_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tena Jisas ki vahiri ake hakaraoi hoki ma, “Koai te tama kootou e sesee naa?” Kito na tama raa ki meake, “Jisas te tama i Nasaret raa.” ");
INSERT INTO nuq_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Tena Jisas ki meake, “Anau ku oti te meatu pera ma teenei Anau nei. Tena kame kootou e sesee koi Anau, kootou ku tiaki na tama nei ki oo.” ");
INSERT INTO nuq_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Jisas e tattara ake peenei ma ki mee na tattara Aia ni tattara ake i mua raa ki hakamaoni: “Tamana, se hai tama na tama Akoe ni kou mai Anau raa e me ki llano.”) ");
INSERT INTO nuq_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tena Saimon Pita, te tama e isi te paraamoa raa ku uhu te paraamoa raa no ttuu te katarina te vahi laaua te tama hehekau te pohouru hakanaaniu na maatua raa no hopo. Te inoa te tama hehekau raa ko Malkus. ");
INSERT INTO nuq_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Kito Jisas ki meake Pita, “Tuku te paraamoa naa i te kina Akoe ni too raa! Akoe e maanatu ma Anau ki se lavaa te unu te kapu na hakalono llihu te Tamana raa ni kou mai Anau?” ");
INSERT INTO nuq_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tena na soldia i Rom raa hakapaa ma te soldia hakamaatua ia ma soldia na Jiu raa ku hakapiki Jisas no haihai, ");
INSERT INTO nuq_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","tena ki too Tama raa no kkave ia Anas raa i mua. Anas ko te hinaona tanata Kaiafas, te pohouru hakanaaniu na maatua te hetau naa. ");
INSERT INTO nuq_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Teeraa ko Kaiafas ni tattara ake na tama hakamattua na Jiu raa ma e tauareka te tama hokotahi ki mate ma na tama hakaatoa raa. ");
INSERT INTO nuq_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita laaua ma teeraa disaipol ku tauttari Jisas. Te pohouru hakanaaniu na maatua raa e iroa laoi roo teraa disaipol, kito te disaipol raa ki haere i hare ma Jisas i te kina te hare te pohouru hakanaaniu na maatua raa, ");
INSERT INTO nuq_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","e meia Pita e hakattari mai i aho. Tena teeraa disaipol ki vaakai i aho no tattara ake te taukupu e tuu te totoka raa, tena aia ki too Pita no kkave i hare. ");
INSERT INTO nuq_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kito te taukupu e tuu te totoka raa ki meake Pita, “Akoe hoki he disaipol te Tama raa kaa seai?” Tena Pita ki meake, “Seai, anau seai.” ");
INSERT INTO nuq_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Te poo naa e haumallii, tena na tama hehekau raa e hakaura te ahi, tena ki ttuu alleha te ahi raa no hakamamahana. Kito Pita ki haere atu no ttuu ma na tama raa no hakamamahana hoki. ");
INSERT INTO nuq_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Te pohouru hakanaaniu na maatua raa ku vahiri ake Jisas i te vahi na disaipol ia ma na akoako Aia raa. ");
INSERT INTO nuq_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Tena Jisas ki meake, “Anau na vahao tahi e tuu i mua na tama hakaatoa no tattara; Anau e mee na akoako Anau raa i roto na hare lotu na Jiu ia ma te Hare Tapu, tena i na kina na tama hakaatoa e kkutu tahi raa. Anau se hai vahao e tattara hemuu na tattara Anau raa. ");
INSERT INTO nuq_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Aiea, kaa kootou e vahiri mai Anau naea? Vahiri atu na tama tera e llono na tattara Anau raa. Vahiri ake na tama raa ma ni tattara peehee Anau e tattara raa, maitaname na tama raa e illoa hea Anau e tattara ake laatou raa.” ");
INSERT INTO nuq_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Te saaita Jisas ni meake peenei raa, tena he soldia hokotahi ku ppaa na patikauvae Tama raa, tena ki meake, “Akoe e lavaa roo te tattara ake peenaa i te pohouru hakanaaniu na maatua raa?” ");
INSERT INTO nuq_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Kito Jisas ki meake, “Kame Anau e isi te tattara sakkino ni ppehi, tena akoe ku meake ki llono na tama nei hakaatoa te tattara naa. Emeia kame na tattara Anau raa e ttonu koi, tena kaa akoe e ppaa Anau naea?” ");
INSERT INTO nuq_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jisas koi haihai ria koi, tena Anas ki kkave Jisas iaa Kaiafas, te pohouru hakanaaniu na maatua raa. ");
INSERT INTO nuq_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pita koi tuu koi i te kina te ahi raa no hakamamahana. Kito alaa tama ki meake, “Akoe seai ma he disaipol hoki te Tama raa?” Emeia Pita e kore hoki, tena ki meake, “Seai, anau seai.” ");
INSERT INTO nuq_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","He tama hehekau te pohouru hakanaaniu na maatua raa, ia he tama hoki e lave te tama Pita ni ttuu te katarina no hopo raa ku meake, “Aiea anau se kite akoe ni tuu ma te Tama raa i roto te paupaku?” ");
INSERT INTO nuq_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Kito Pita ki kore hakaraoi hoki, tena ki meake, “Seai.” Te saaita naa koi te manu tane raa ku tani. ");
INSERT INTO nuq_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Te tahata roo na soldia raa ku too Jisas i te hare Kaiafas raa no kkave i te hare te tama hakamaatua te taumani i Rom raa. Na tama hakamattua na Jiu raa se oo i hare, maitaname laatou se hihai ma laatou ki isi na hai sara i te vahi na tuaa raa, ma ki lavaa laatou te kkai te Kai te Pasova raa. ");
INSERT INTO nuq_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kito Pailat ki haere i aho no vahiri ake na tama raa, “Kootou ki tattara mai hea te Tama nei e ppena e ssara naa.” ");
INSERT INTO nuq_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kito na tama raa ki meake, “Maatou se lavaa te kou mai te Tama nei iaa Akoe kame Aia ni se hai sara e ppena.” ");
INSERT INTO nuq_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tena Pailat ki meake na tama raa, “Tena kootou hokkootou ki too Tama nei no hakatonutonu i te vahi na tuaa kootou raa.” Kito na tama raa ki vaakai ake ma, “Maatou e tapu te taa te tama ki mate.” ");
INSERT INTO nuq_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Na mee nei e kapihi mai ki mee na tattara Jisas raa ki hakamaoni; na tattara Aia ni tattara ake na tama raa i te vahi te mate Aia raa.) ");
INSERT INTO nuq_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Kito Pailat ki vaakai i hare no kanna ake Jisas, tena ki vahiri ake Tama raa, “Akoe ko te Tuku na Jiu?” ");
INSERT INTO nuq_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Tena Jisas ki vahiri ake ma, “Te vahiri naa he vahiri koi akoe ma e isi na tama e tattara atu akoe i te vahi Anau?” ");
INSERT INTO nuq_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Kito Pailat ki meake, “Akoe e maanatu ma anau he Jiu? Teenaa ko na tama roo kootou naa ia ma na maatua hakananniu raa e kou mai Akoe i anau. Hea Akoe ni ppena?” ");
INSERT INTO nuq_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tena Jisas ki meake, “Te Hakamaatua ana Anau raa se tuu i te maarama nei; ia peeraa te Hakamaatua ana Anau raa ki tuu i te maarama nei, peera na tama tauttari Anau raa e me ki ppuhu ki se lavaa kootou te too Anau no kkave i na tama hakamattua na Jiu raa. Te Hakamaatua ana Anau raa se tuu i te maarama nei.” ");
INSERT INTO nuq_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Kito Pailat ki vahiri ake Jisas, “Tena, kaa Akoe he tuku?” Kito Jisas ki meake, “Akoe e vahiri mai ma Anau he tuku. Anau e haanau mai i roto te maarama nei ma te hakataakoto hokotahi nei; ki tattara i te vahi te hakamaoni raa. Na tama e tauttari te hakamaoni raa e me ki hakallono Anau.” ");
INSERT INTO nuq_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Kito Pailat ki meake, “Kaa te hakamaoni raa hea?” Kito Pailat ki vaakai hakaraoi i aho no meake te kanohenua raa, “Anau se isi te mee e sara e lave ma ki taa Tama nei ki mate. ");
INSERT INTO nuq_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Emeia i te vahi na tuaa tera kootou e isi raa, na vahao na Kai na Pasova hakaatoa, anau e me ki hakattana he tama karapusi hokotahi ma kootou. Kootou e hihhai ma anau ki hakattana ma kootou te Tuku na Jiu raa?” ");
INSERT INTO nuq_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kito te kanohenua raa ki vaa ake ma, “Seai, seai ma ko Tama naa! Maatou e hihhai Barabas!” (Barabas he tama taa tama.) ");
INSERT INTO nuq_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tena Pailat ki kou ake Jisas i na soldia raa ki riki. ");
INSERT INTO nuq_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Na soldia raa e pena te hau i na laakau e tutuia raa, tena ki hakatau ake i aruna te pohouru Tama raa, tena na tama raa ki hakauru ake Jisas te kaukahu e ttea pouri raa, ");
INSERT INTO nuq_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","tena laatou ki oo ake no meake Tama raa ma, “Hakammaha te Tuku na Jiu!” Tena na tama raa ki oo ake no ppaa na maihu Tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Kito Pailat ki vaakai ake hakaraoi i aho no meake te kanohenua raa, “Kira ake, anau e me ki kou mai Tama raa i aho ki kkite kootou pera ma anau se isi te mee e sara e lave ki taa Tama raa ki mate.” ");
INSERT INTO nuq_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kito Jisas ki hamai i aho, tena Aia ku hau te hau manamana, tena ki uru hoki te kaukahu e ttea pouri. Kito Pailat ki meake na tama raa, “Kira ake! Teenei te Tama nei!” ");
INSERT INTO nuq_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Te saaita na maatua hakananniu raa laatou ma na soldia e lollohi te Hare Tapu raa ni kkite Jisas, na tama raa ku vaa ake ma, “Tii Tama naa i aruna te kros! Tii Tama naa i aruna te kros!” Kito Pailat ki meake te kanohenua raa, “Kame peenaa; kootou hokkootou ku too Tama nei no ttii i aruna te kros. Anau se lave hea Tama nei e ppena e sara.” ");
INSERT INTO nuq_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tena te kanohenua raa ki meake hakaraoi, “Maatou e isi te tuaa tera e mee ma te Tama nei e tau te mate, maitaname Aia e tattara ma Aia he Tamariki TeAtua.” ");
INSERT INTO nuq_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Te saaita Pailat ni rono na tattara nei, Aia ku mataku roo. ");
INSERT INTO nuq_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Tena aia ki vaakai i hare no vahiri ake Jisas, “Akoe he tama e hamai i hee?” Emeia Jisas e tuu hemuu koi se tattara. ");
INSERT INTO nuq_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kito Pailat ki meake Aia, “Akoe se hihai ki tattara mai Anau? Maanatu, anau e isi na mahi ki hakattana Akoe ki haere ia ma ki ttii Akoe i aruna te kros.” ");
INSERT INTO nuq_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tena Jisas ki meake, “Akoe e isi koi na mahi i aruna Anau e mee TeAtua e kou atu na mahi naa i akoe. Emeia te tama e kou atu Anau i na rima kootou raa e ppena te mee e haeo roo.” ");
INSERT INTO nuq_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Te saaita Pailat ni rono na tattara nei, aia ku sesee he ara ma ki hakattana Tama raa ki haere. Emeia te kanohenua raa e vaa ake ma, “Kame akoe e hakattana Tama naa ki haere, tena akoe e huri mai pera ma akoe seai ma he soa te tuku i Rom raa! Te tama e tattara ma aia he tuku raa e hakataukaa ma te tuku i Rom!” ");
INSERT INTO nuq_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Te saaita Pailat ni rono na tattara nei, aia ku too Jisas no kkave i aho no hakanoho i aruna te tuai e hakatonutonu na tama tera e kanna ma, “Te Papa Hatu raa”. (Na Hibru raa e kanna te kina nei ma “Gabata”.) ");
INSERT INTO nuq_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Te mee raa ku taapiri ki tae te laa latea te aho naa, te aho i mua te aho te Kai te Pasova raa. Tena Pailat ki meake te kanohenua raa, “Teenei te Tuku kootou!” ");
INSERT INTO nuq_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tena na tama raa ki vaa ake ma, “Taa Tama naa ki mate! Taa Tama naa ki mate! Ttii Tama naa i aruna te kros!” Kito Pailat ki meake te kanohenua raa, “Kootou e hihhai ma anau ki ttii te Tuku kootou raa i aruna te kros?” Tena na maatua hakananniu raa ki meake, “Te tuku hokotahi koi maatou e isi raa ko te tuku i Rom!” ");
INSERT INTO nuq_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tena Pailat ki too Jisas no kou ake na tama raa ki tii i aruna te kros. Kito na tama raa ki hakattaki Jisas. ");
INSERT INTO nuq_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jisas e amo te kros Aia raa no haere no tae i te kina e hui ma, “Te Kina te Ivi te Pohouru.” (Na Hibru raa e kanna te kina raa ma, “Golgota”.) ");
INSERT INTO nuq_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Na soldia raa e ttii Jisas i te kina raa, tena na tama raa ki ttii hoki tokorua na tama kailallao raa i na vahi, tena te kros Jisas e tuu lottonu na kros tokorua raa. ");
INSERT INTO nuq_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailat e taataa na tattara nei i aruna te hono, tena ki ttii te hono raa i aruna te kros. Teenei na tattara Pailat e taataa, “Jisas te Tama i Nasaret, te Tuku na Jiu.” ");
INSERT INTO nuq_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Tammaki na tama e ppau na tattara raa, maitaname te kina na tama raa e ttii Jisas raa se mmao ma te matakaina e rahi raa. Na tattara nei e tattaa i na tattara Hibru, Latin ia ma Grik. ");
INSERT INTO nuq_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tena na maatua hakananniu raa ki meake Pailat, “Auu se taataa ma ‘Te Tuku na Jiu’, e meia taataa pera ma, ‘Te Tama nei e tattara ma, Anau ko te Tuku na Jiu.’ ” ");
INSERT INTO nuq_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Kito Pailat ki meake, “Hea anau e taataa tiaki ki mmau peenaa.” ");
INSERT INTO nuq_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Na soldia raa e ttii roo Jisas no oti, tena laatou ki too na hekau Tama raa no vvae e haa na tuhana ki tau ma laatou tokohaa, te soldia hokotahi e too te tuhana aia. Na soldia raa e too hoki te kaukahu roroa tera e ttui koi te paamaro hokotahi, se hai kina e huhukui raa. ");
INSERT INTO nuq_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Na soldia raa e tattara hokolaatou ma, “Taatou se lavaa te saesae te kaukahu nei, taatou ki ttahao huhu na hatu ki mmata ma koai e me ki too te kaukahu nei.” Te mee nei e kapihi mai ki mee na tattara te Launiu Tapu raa ki hakamaoni: “Na tama raa e vaevae na hekau Anau raa ma laatou, tena ki ttahao huhu na hatu ki too te kaukahu roroa Anau raa.” Teenei hea na soldia raa e ppena. ");
INSERT INTO nuq_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Te tinna Jisas raa, te taina te tinna Aia raa, Meri te avana Klopas raa, tena Meri te tama i Makdala raa e ttuu taapiri ake te kros Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jisas e kite te tinna Aia raa laaua ma te disaipol Aia e hihhai mahi raa e ttuu i te kina raa, tena Aia ki meake te tinna Aia raa ma, “Teenei he tama Akoe.” ");
INSERT INTO nuq_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tena Aia ki meake te disaipol raa, “Teenei he tinna akoe.” Tena kaamata te saaita naa te disaipol raa ku too Meri no nnoho laaua i te hare Aia raa. ");
INSERT INTO nuq_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jisas e iroa pera ma te saaita nei na mee roo hakaatoa ku oti, tena ki mee hea e mmau i roto te Launiu Tapu raa ki hakamaoni, tena Aia ki meake ma, “Anau hiunu.” ");
INSERT INTO nuq_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","E isi te kumete e tuu i te kina raa e pii roo na wain e mmara; na soldia raa e too te spans raa no ttoki i roto te wain raa, tena ki haihai te spans raa i te mata te laakau te hisop raa, tena ki ssau ake no tuku ake na maihu Tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jisas e mmiti te wain raa no pakupaku, tena ki meake, “Ku oti hakaatoa!” Tena Aia ki huru te pohouru Aia raa no mate. ");
INSERT INTO nuq_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Tena na tama hakamattua na Jiu raa ki meake Pailat ki hakattana laatou ki oo no kkoti na vae na tama e tottoo i aruna na kros raa, tena ku turi iho na tinotama raa i taha ma na kros raa. Na tama hakamattua raa e meake e mee teeraa he aho rima, tena laatou se hihhai ma na tinotama raa ki tottoo te aho te Sabat raa, e mee te Sabat raa he aho e tapu. ");
INSERT INTO nuq_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kito na soldia raa ki oo no kkoti na vae te tama kaamata raa, tena ki oo no kkoti na vae teeraa tama hoki tera ni ttii ria i teeraa vahi Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Emeia te saaita laatou ni oo atu iaa Jisas raa, na soldia ku kkite pera ma Jisas ko na mate roo, tena laatou ni se kkoti na vae Tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Tena he soldia hokotahi e taro te hika aia raa i te vahi manava Jisas, tena te saaita naa koi na toto ia ma na vai raa ku kkoo iho i taha ma te vahi manava Tama raa. ");
INSERT INTO nuq_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Te tama ni kite te mee nei raa ku haere tattara roo te mee nei ma ki lavaa kootou te hakattina. Hea te tama raa e tattara raa e hakamaoni, tena aia hoki e iroa pera ma aia e tattara te hakamaoni.) ");
INSERT INTO nuq_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Te mee nei e kapihi mai ki mee na tattara i roto te Launiu Tapu raa ki hakamaoni: “Se isi na ivi Tama raa e me ki kottia ria.” ");
INSERT INTO nuq_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tena e isi teeraa kina hoki e mmau i roto te Launiu Tapu e mee ma, “Te kanohenua raa e me ki kkira ake te Tama laatou ni ttoki raa.” ");
INSERT INTO nuq_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tena ki oti, Josep te tama te matakaina Arimatea raa ku haere no meake Pailat ma aia e lavaa te too te tinotama Jisas raa. (Josep he tama e tautari hemuu na tiputipu Jisas, maitaname aia e mataku na tama hakamattua na Jiu raa.) Tena Pailat ki meake tama raa ki too te tinotama Jisas raa, tena Josep ki haere no ssau te tinotama Jisas raa i taha ma te kina raa. ");
INSERT INTO nuq_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimas, te tama ni haere kaamata no mmata Jisas i te poo raa e oo laaua ma Josep, tena aia e too na sanda e hilo ma na rehu mannoni e taapa ma ni aloo raa no haere ma aia; te mmaha na mee raa e tae tipu toru na kilo. ");
INSERT INTO nuq_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tokorua na taanata raa e too te tinotama Jisas raa no amuhi na lloo e hilo ma na rehu manoni raa, tena ki mmini te tinotama Jisas raa ma na paamaro. Teenei he tiputipu na Jiu raa te saaita laatou e tanattana ki tanu te tama. ");
INSERT INTO nuq_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","E isi te paupaku e tuu i te kina Jisas ni taia ria no mate raa, ia e isi hoki te taruma e tuu i roto te paupaku raa tera se hai tama ni tanu i roto i mua. ");
INSERT INTO nuq_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Maitaname teenaa ko te aho i mua te Sabat, ia e mee te taruma raa e taapiri hoki, tena tokorua raa ki oo no ppono te tinotama Jisas raa i roto te taruma raa. ");
INSERT INTO nuq_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tahata roo te aho te latapu, te saaita te mee raa koi maru pouri, tena Meri te tama te matakaina Makdala raa ku haere i te taruma raa no kite pera ma te hatu ni ppui te taruma raa ku oti te hakatupe ria i taha ma te totoka te taruma raa. ");
INSERT INTO nuq_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tena te hine raa ki tere no mmata Saimon Pita laaua ma te disaipol tera Jisas e hihai mahi raa, tena aia ki tattara ake tokorua raa ma, “Na tama raa ku oti te too te tinotama TeAriki raa i taha ma te taruma raa, tena maatou ku se illoa i te kina na tama raa e tuku te tinotama Tama raa!” ");
INSERT INTO nuq_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kito Pita laaua ma teeraa disaipol ki oo i te taruma raa. ");
INSERT INTO nuq_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tokorua raa e hai ma te huro, e meia teeraa disaipol e nahoro roo i aruna Pita, tena aia e tae kaamata i te taruma. ");
INSERT INTO nuq_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tama raa se uru i roto te taruma raa hoki, e meia aia e haatiu koi no kite na paamaro ni mmini Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tena Saimon Pita e tere mai i muri no haere tahi roo no uru i roto te taruma raa. Pita e kite na paamaro ni mmini Jisas raa e mmoe i te kina raa, ");
INSERT INTO nuq_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ia te paamaro hoki na tama raa ni uhi te pohouru Jisas raa. Te paamaro raa se mmoe hakapaa ma na paamaro ni mmini te tinotama raa, e meia te paamaro raa e minimini no moe te kina aia hokoia. ");
INSERT INTO nuq_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tena teeraa disaipol, te tama ni tae kaamata i te taruma raa ku uru atu i roto te taruma raa no kite te mmoe na mee raa, tena ki hakatina. ");
INSERT INTO nuq_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Emeia tokorua raa se illoa hakaraoi na tattara e mmau i roto te Launiu Tapu tera e mee ma te Tama raa e me ki ora muri i taha ma te mate raa.) ");
INSERT INTO nuq_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tena tokorua na disaipol raa ki vakkai i hare. ");
INSERT INTO nuq_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Meri e haere no tuu no tanitani i aho te taruma raa. Aia koi tanitani koi, tena aia ku huru atu no kkira i roto te taruma raa ");
INSERT INTO nuq_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","no kite e rua na ensel e uru na hekau makkini, tokorua raa e nnoho i te kina te tinotama Jisas raa ni moe. Tokorua e noho, te tama i te kina te pohouru, tena teeraa tama e noho i te kina na vae raa. ");
INSERT INTO nuq_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Kito tokorua raa ki vahiri ake, “Akoe e tanitani naea?” Tena Meri ki meake, “Na tama raa e too te tinotama TeAriki anau raa i taha, tena anau ku se iroa i te kina laatou e tuku te tinotama Tama raa!” ");
INSERT INTO nuq_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tena aia ki hakatike no kite Jisas ku tuu i te kina raa; e meia aia se iroa ma teeraa ko Jisas. ");
INSERT INTO nuq_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Kito Jisas ki vahiri ake ma, “Akoe e tanitani naea? Akoe e sesee aii?” Meri e kkahu ma teeraa ko te tama te paupaku raa, kito aia ki meake te Tama raa, “Tama hakanaaniu, kame akoe e too te tinotama Tama raa i taha, tena akoe ku hakari mai anau i te kina akoe e tuku te tinotama Tama raa, ki haere anau no too te tinotama raa.” ");
INSERT INTO nuq_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Kito Jisas ki kanna ake te hine raa ma, “Meri!” Tena Meri ki hakatike no kkira ake Jisas, tena ki meake, “Raboni!” i na tattara hakaHibru. (Te tattara nei e mee ma, “Tisa”.) ");
INSERT INTO nuq_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Kito Jisas ki meake Meri, “Auu se ttaohi Anau, maitaname Anau se ki haere i aruna i te Tamana Anau raa. Emeia haere no tattara ake na taina Anau raa pera ma Anau e me ki vaakai i TeAtua te Tamana Anau ia ma te Tamana laatou raa, ia TeAtua Anau ia ma TeAtua laatou raa.” ");
INSERT INTO nuq_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kito Meri ki haere no tattara ake na disaipol raa pera ma aia e kite TeAriki, tena aia ki tattara ake na disaipol raa na tattara Jisas ni tattara ake aia raa. ");
INSERT INTO nuq_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Te mee raa ku hiahi roo te aho te latapu, tena na disaipol raa ku hakkutu i hare, tena ki pupui na totoka raa no hakapikapi, maitaname laatou e mattaku na tama hakamattua na Jiu raa. Tena Jisas ki haere ake no tuu i te kina na tama raa e kkutu raa no meake, “Te noho laoi ki nnoho ma kootou!” ");
INSERT INTO nuq_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Jisas e tattara ake no oti, tena Aia ki huri ake na rima ia ma te vahi manava Aia raa. Na disaipol raa ku hihhia roo e mee laatou ku kkite TeAriki. ");
INSERT INTO nuq_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kito Jisas ki meake hakaraoi hoki ma, “Te noho laoi ki nnoho ma kootou. E ssau pera ma te Tamana e kauna ria mai Anau, tena Anau e me ki kauna hoki kootou.” ");
INSERT INTO nuq_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tena Jisas ki iri ake na tama raa, tena ki meake, “Too TeAnana Tapu. ");
INSERT INTO nuq_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kame kootou e ssirihia na hai sara na tama, tena na hai sara na tama naa e me ki ssirihia; kame kootou se ssirihia na hai sara na tama naa, tena na hai sara na tama naa se lavaa te ssirihia.” ");
INSERT INTO nuq_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomas he disaipol i roto te sanahuru ma rua na disaipol raa (na tama e kakanna hoki aia ma te Kokoa raa), e seai i te kina raa te saaita Jisas ni haere ake. ");
INSERT INTO nuq_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tena alaa disaipol ku tattara ake Tomas ma, “Maatou e kkite TeAriki!” Kito Tomas ki meake na tama raa, “Anau e me ki hakatina koi kame anau e kite na kina na katana raa ni uru na rima Aia raa, tena ku taaro te matarima anau nei i roto na kina na katana raa ni uru raa, tena ku taaro hoki te rima anau nei i roto te vahi manava Aia raa.” ");
INSERT INTO nuq_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","He latapu hakaatoa e haere no raka, tena na disaipol raa ku kkutu hakaraoi i hare, tena Tomas ku nnoho ma laatou te saaita naa. Na totoka raa e puipui hakammate roo, e meia Jisas e haere ake koi i hare no ttuu ma na tama raa, tena ki meake, “Te noho laoi ki nnoho ma kootou.” ");
INSERT INTO nuq_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tena kito Jisas ki meake Tomas, “Taaro te mata rima akoe raa i te kina nei, tena akoe ku kkira mai na rima Anau nei, tena haaro mai hoki te rima akoe raa no ppono i roto te vahi manava Anau nei. Hakaoti te mamaanatu tammaki, tena ku hakatina!” ");
INSERT INTO nuq_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Kito Tomas ki meake Jisas, “TeAriki ia ma TeAtua anau!” ");
INSERT INTO nuq_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Tena Jisas ki meake Tomas, “Akoe ku hakatina e mee akoe ku kite Anau? Na tama se kkite Anau no hakattina raa e me ki hakatapu ria!” ");
INSERT INTO nuq_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisas e ppena tammaki alaa mirakol hoki i mua na karemata na disaipol raa tera se tattaa i roto te launiu nei. ");
INSERT INTO nuq_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Emeia na mee nei e tattaa i roto te launiu nei ki lavaa kootou te hakattina pera ma Jisas ko te Mesaia, te Tamariki TeAtua raa, tena na hakattina kootou Tama raa e me ki mee kootou ki too te ora hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tena ki oti, Jisas ku tuu ake hoki i na disaipol Aia raa i te kina te Namo Galili raa. Te mee nei e kapihi ake peenei. ");
INSERT INTO nuq_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, Tomas (te Kokoa raa), Nataniel, (te tama i Kana i roto Galili raa), tena tokorua na tama Sebedi raa ia ma alaa tokorua hoki na disaipol Jisas raa e kkutu hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tena Saimon Pita ki meake alaa disaipol ma, “Anau e me ki haere no pupui.” Kito na disaipol raa ki meake ma, “Maatou e me ki oo taatou.” Tena na tama raa ki too te manaui raa no aro, e meia te poo naa hakaatoa na tama raa se isi na ika e mmau. ");
INSERT INTO nuq_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Te saaita te laa raa ku hopo ake, Jisas ku tuu i te taunatai, e meia na disaipol raa se illoa ma teeraa ko Jisas. ");
INSERT INTO nuq_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Kito Jisas ki vahiri ake na tama raa, “Eaa, kootou se isi na ika e mmau?” Tena na disaipol raa ki meake, “Seai roo hokotahi.” ");
INSERT INTO nuq_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kito Jisas ki meake na tama raa, “Ppehi te kupena naa i te vahi laaua te manaui naa, tena kootou e me ki mmau na ika.” Kito na tama raa ki lletu te kupena raa, tena laatou ku se lavaa te hhuti ake te kupena raa i aruna, maitaname te kupena raa ku mmau na ika tammaki roo. ");
INSERT INTO nuq_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tena te disaipol tera Jisas e hihai mahi raa ku meake Pita, “Teenaa ko TeAriki!” Ia te saaita koi Pita ni rono ma teeraa ko TeAriki raa, tena aia ku rii te kaukahu aia raa areha te tinotama aia raa (e mee aia ni ui na kaukahu aia raa), tena aia ki llee no kkau i uta. ");
INSERT INTO nuq_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Alaa disaipol ku aro ake te manaui raa i uta no hhuti te kupena ku pii roo na ika raa. Na tama raa se mmao roo i taha ma te taunatai, kame peeraa huitarau na mita te mmao laatou. ");
INSERT INTO nuq_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Te saaita na disaipol raa ni ttae i uta, na tama raa ku kkite te ahi e malla ma na ika e mmoe i roto te ahi raa ia ma na haraoa hoki. ");
INSERT INTO nuq_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Tena Jisas ki meake na disaipol raa, “Kou mai ni ika na ika kootou e mmau te kupena raa.” ");
INSERT INTO nuq_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kito Saimon Pita ki haere atu no kake i roto te manaui raa no horoo ake te kupena raa i uta; te kupena raa e pii roo na ika e llahi; na ika raa hakaatoa e tae huitarau tipu rima ma toru; niaina na ika raa e tammaki roo, e meia te kupena raa se mahaa. ");
INSERT INTO nuq_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Tena Jisas ki meake na tama raa, “Oo mai no kkai.” Emeia se isi te disaipol e hihai ki vahiri ake Tama raa ma “Akoe koai?” maitaname laatou e illoa ma teeraa ko TeAriki. ");
INSERT INTO nuq_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Kito Jisas ki haere atu no too na haraoa raa, tena ki vaevae ake na tama raa, tena Aia ki too hoki na ika raa no vaevae ake. ");
INSERT INTO nuq_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Teenei ko te hakatoru na vahao Jisas ku tuu ake i na disaipol Aia raa i muri Aia ni mate no ora muri. ");
INSERT INTO nuq_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Te saaita na tama raa ni kkai roo no oti, tena Jisas ki vahiri ake Saimon Pita, “Saimon te tama Jon, te laoi akoe Anau raa e raka i aruna ma na laoi na tama nei i Anau raa ma seai?” Kito Pita ki meake, “Noo TeAriki, Akoe e iroa pera ma anau e laoi roo Akoe.” Tena Jisas ki meake Pita, “Rorohi hakaraoi na punua sipsip Anau raa.” ");
INSERT INTO nuq_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tena Jisas ki vahiri ake hakaraoi hoki iaa Pita ma, “Saimon te tama Jon, akoe e laoi Anau ma seai?” Kito Pita ki meake, “Noo, TeAriki, Akoe e iroa pera ma anau e laoi roo Akoe.” Tena Jisas ki meake Pita, “Rorohi hakaraoi na punua sipsip Anau raa.” ");
INSERT INTO nuq_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jisas ku vahiri ake hoki te hakatoru na vahao ma, “Saimon, te tama Jon, akoe e laoi Anau ma seai?” Pita ku se hihai e mee Jisas e vahiri ake e toru na vahao ma, “Akoe e laoi Anau ma seai?” kito aia ki meake, “TeAriki, Akoe e iroa na mee roo hakaatoa; akoe e iroa pera ma anau e laoi roo Akoe!” Tena Jisas ki meake, “Rorohi na sipsip Anau raa. ");
INSERT INTO nuq_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Anau e tattara atu te hakamaoni: te saaita akoe ni paamee raa, akoe e tanattana no haere he kina peehee akoe e hihai ki haere raa; e meia te saaita akoe ku tanata matua raa, akoe e me ki ssora na rima akoe raa, tena teeraa tama e me ki haihai akoe, tena ku too akoe no kkave i te kina akoe se hihai ki haere raa.” ");
INSERT INTO nuq_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Jisas e tattara ake peenei ki huri ake te tiputipu te mate Pita tera e me ki huri ake na mahi hai mmahi TeAtua raa.) Tena Jisas ki meake Pita, “Tautari mai Anau!” ");
INSERT INTO nuq_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita e hakatike no kite te disaipol tera Jisas e hihai mahi raa e tuu i muri aia; teenaa ko te disaipol tera ni hakapare ake te vahi Jisas te saaita laatou ni kkai raa no vahiri ake ma, “TeAriki, koai te tama e me ki hakari ake Akoe i na tama hakamattua naa?” ");
INSERT INTO nuq_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita ni kite te disaipol raa, tena aia ki vahiri ake Jisas ma, “TeAriki, kaa te tama nei?” ");
INSERT INTO nuq_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Kito Jisas ki meake Pita, “Kame Anau e hihai ma te tama nei ki noho roo ki tae te saaita Anau e vaakai mai raa, tena kaa hea akoe e me ki mee? Tautari mai Anau!” ");
INSERT INTO nuq_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tena te tattara nei ku tere no llono na tama tauttari Jisas raa ma te disaipol raa ku se lavaa te mate. Emeia Jisas se meake ma te disaipol raa se lavaa te mate; Jisas e meake ma, “Kame Anau e hihai aia ki noho roo ki tae te saaita Anau e vaakai mai raa, tena kaa hea akoe e me ki mee?” ");
INSERT INTO nuq_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Te disaipol naa ko te tama tera ni tattara na tattara nei, ia te tama hoki tera ni taataa na mee nei i roto te launiu nei raa, tena maatou e illoa pera ma hea aia e tattara raa e hakamaoni. ");
INSERT INTO nuq_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Tena e tammaki roo alaa mee hoki Jisas ni ppena. Kame na mee nei hakaatoa ni tattaa i roto te launiu nei, tena anau e maanatu ma te maarama nei kame se lavaa te isi na kina ki hakatau na launiu nei hakaatoa.");
INSERT INTO nuq_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiofilus, anau ni taataa te launiu kaamata anau raa ki hakari atu na akoako Jisas raa ia ma na mee hakaatoa Aia ni ppena raa ");
INSERT INTO nuq_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","haere no tae te aho TeAtua ni too Aia no kkave i te vaelani raa. I mua Aia ni too ria no kkave i te vaelani raa, Aia ni akoako ake ma na mahi TeAnana Tapu raa i na tama Aia ni hirihiri ki mee mo aposol Aia raa. ");
INSERT INTO nuq_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","I roto tipu haa na aho i muri te mate Jisas raa, Aia ni tuu ake i na aposol Aia raa tammaki na vahao ia ma tammaki na ara ki huri ake te hakamaoni pera ma Aia ku ora. Na tama raa e kkite Aia, tena Aia ki tattara ake na tama raa i te vahi te Hakamaatua ana i te Vaelani raa. ");
INSERT INTO nuq_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Na aposol raa ni kkutu hakaatoa te saaita Jisas ni nnoho ma laatou raa, tena Jisas ki kou ake te tattara e mmaha ma, “Auu se oo i taha ma Jerusalem, e meia kootou ki nnoho no hakattari ki too kootou te hoki Anau ni tattara atu raa, te hoki te Tamana Anau raa ni tattara ma Aia e me ki kou atu raa. ");
INSERT INTO nuq_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon e hakoukou tapu ma te vai, e meia na aho i muri raa kootou e me ki hakoukou tapu ria ma TeAnana Tapu.” ");
INSERT INTO nuq_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jisas e kkutu ma na aposol Aia raa hakaatoa, kito na tama raa ki vahiri ake Tama raa ma, “TeAriki! Teenei te saaita Akoe e me ki kou ake muri te Hakamaatua ana i te Vaelani raa i na tama Israel?” ");
INSERT INTO nuq_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tena Jisas ki meake na tama raa, “Te Tamana Anau raa Hokoia e me ki tuku te maanatu Aia te saaita na mee nei e me ki kapihi atu raa, ia teenaa seai ma he mee kootou ki illoa te saaita na mee nei e me ki kapihi atu raa. ");
INSERT INTO nuq_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Emeia te saaita TeAnana Tapu raa e tae atu kootou raa, tena kootou e me ki isi na mahi ki tattara ake na tiputipu Anau raa i roto Jerusalem ia ma i roto Judia ma Samaria ia ma na kina hakaatoa i roto te maarama nei raa.” ");
INSERT INTO nuq_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jisas e tattara ake no oti roo, tena Aia ku too ria no kkave i te vaelani i mua na karemata na tama raa hakaatoa, kito te pukureurehu raa ki haere ake no uhi Jisas, tena na tama raa ku se kkite Tama raa. ");
INSERT INTO nuq_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Na karemata na tama raa koi ana koi i aruna te saaita Jisas ni too ria no kkave i te vaelani raa, tena te saaita naa koi tokorua na tama e uru na kaukahu makkini ku ttuu ake i te vahi laatou ");
INSERT INTO nuq_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","no meake ma, “Na tama i Galili, aiea kootou e ttuu i te kina naa no kirakira i te vaelani naea? Jisas tera e too ria i taha ma kootou no kkave i te vaelani raa e me ki vaakai mai hoki peenei ma kootou ni kkite Aia e haere i te vaelani raa.” ");
INSERT INTO nuq_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tena na aposol raa ku oo i taha ma te mouna e hhomo na Oliv raa no vakkai i Jerusalem, te matakaina e taapiri ake raa. ");
INSERT INTO nuq_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Na tama raa ku ttae te matakaina raa, tena ki kkake i aruna te rum laatou e nonnoho raa. Na tama nei ko Pita, Jon, Jems, Andru, Filip, Tomas, Bartolomyu, Matiu, Jems te tama Alfius raa, Saimon te tama i roto te kuturana na tama se hihhai ma Rom ki rorohi Israel raa, tena Judas te tama Jems raa. ");
INSERT INTO nuq_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Na tama nei e kkutu tahi pera ma he kuturana no lotulotu hakapaa ma na hhine, tena Meri te tinna Jisas raa ia ma na taina hoki Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Na aho i muri raa na hakattina ana raa ku kkutu ki tattara, tena te kooina na tama raa hakaatoa e ttae pera huitarau tipu rua na tama, tena Pita ki mahike i aruna ma ki tattara. ");
INSERT INTO nuq_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Tena aia ki meake, “Aku taina, te tattara i roto te Launiu Tapu tera TeAnana Tapu raa ni tattara ake Devit i te vahi Judas, te tama ni hakattaki mai na tama haeo raa ki hakapiki Jisas raa ku hakamaoni te aho nei. ");
INSERT INTO nuq_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas he tama i roto te kuturana taatou nei, e mee Jisas ni hirihiri hoki tama raa ki uata ma taatou.” ");
INSERT INTO nuq_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Judas e too te sui i te haeo aia ni ppena raa no sui te kerekere. Aia e hina no mate i te kina raa, tena te manava aia raa e mahaa no oo iho na vava raa i aho. ");
INSERT INTO nuq_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Na tama i Jerusalem raa hakaatoa e llono hea ni kapihi ake iaa Judas raa, tena ki kanna te kerekere raa ma ko Akeldama i na tattara laatou, te tattara nei e mee ma, “Te kerekere ni hapu ria te toto.”) ");
INSERT INTO nuq_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Maitaname te tattara nei e mmau i roto te launiu na Rue te Lotu raa ma: ‘Te hare aia raa e me ki tuu vare, ia se hai tama e me ki noho i roto te hare naa.’ Tena e mmau hoki ma, ‘Teeraa tama e me ki too te sao te tama raa no uata.’ ");
INSERT INTO nuq_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","22 Ia tena e tau he tama ki hukui ma taatou ki takutaku i te vahi te ora muri TeAriki Jisas raa. Tena te tama naa ki hai hoki i roto te kuturana taatou nei i na vahao hakaatoa TeAriki Jisas ni hahaere ma taatou i na kina raa, kaamata mai te saaita Jon Baptis ni takutaku i te vahi te hakoukou tapu raa haere no ttae te saaita Jisas ku too ria i taha ma taatou no haere i te vaelani raa.” ");
INSERT INTO nuq_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tena na tama raa ki tini tokorua na taanata: Josep te tama e kanna ria ma ko Barsabas raa (na tama e kakanna hoki tama raa ma ko Jastus), tena Matias. ");
INSERT INTO nuq_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","25 Kito na tama raa ki lotu ake ma, “TeAriki, Akoe e iroa na hakataakoto na tama hakaatoa, ia tena huri mai maatou i te tokorua nei ma koai te tama Akoe e hirihiri ki mee mo aposol ki too te sao Judas tera ku mate no haere i te kina e tau roo ma aia raa.” ");
INSERT INTO nuq_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kito na tama raa ki ttahao huhu na hatu ma ki hirihiri he tama i tokorua raa, tena te inoa Matias raa ku huri ake. Tena Matias ku hukui ma te sanahuru ma tahi na aposol raa. ");
INSERT INTO nuq_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Te aho te Kai Pentikos raa ku tae mai, tena na hakattina ana raa hakaatoa ku hakkutu i te kina hokotahi. ");
INSERT INTO nuq_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Te saaita naa koi te vaelani raa ku mmuu pera ma he matani hai mahi e maairi, tena i roto te hare laatou e nnoho raa ku mmuu roo. ");
INSERT INTO nuq_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tena ki oti laatou ku kkite na ahi e ssau pera ma ni arero ku ttoha no ura vaa aruna na tama hakaatoa i roto te hare raa. ");
INSERT INTO nuq_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","TeAnana Tapu raa ku tau i roto na tama raa hakaatoa, tena na tama raa ku kaamata no tattara i na tattara alaa henua tera TeAnana Tapu raa e mee laatou ki lavaa te tattara. ");
INSERT INTO nuq_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","E isi na Jiu e nnoho i Jerusalem, na tama nei ni tama e oo mai na kina hakaatoa i roto te maarama nei, e meia laatou ni tama hoki e lotu tahi ake TeAtua. ");
INSERT INTO nuq_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Te saaita na tama raa ni llono te mmuu raa, tena te kanohenua e rahi raa ku hakkutu ake hakaatoa. Na tama raa hakaatoa ku mahharo roo, e mee laatou ku llono na hakattina ana raa e tattara na tattara na henua laatou raa. ");
INSERT INTO nuq_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Na tama raa ku oho roo no mahharo, tena ki tattara ma, “Na tama e tattara nei ni tama i Galili. ");
INSERT INTO nuq_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Emeia teenei taatou hakaatoa ku llono roo na tama raa e tattara i na tattara roo na henua taatou raa. ");
INSERT INTO nuq_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Taatou na tama i Partia, ia na tama i Midia, ia na tama i Elam, ia na tama i Mesopotemia, ia na tama i Judia, ia na tama i Kapadosia, ia na tama i Pontus, ia na tama i Esia, ");
INSERT INTO nuq_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ia na tama i Frigia, ia na tama i Pamfilia, ia na tama i Isip ia ma na tama na matakaina i Libia tappiri i Sairini raa. Tena alaa tama taatou ni tama i Rom, ");
INSERT INTO nuq_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","tena taatou na Jiu ia ma na tama seai ma ni Jiu tera ku hukui na tiputipu na Jiu raa, tena alaa tama taatou ni tama i Krit ia ma Arebia, e meia taatou hakaatoa ku llono na tama raa e tattara na mee hakanaaniu TeAtua ni ppena raa i na tattara roo taatou.” ");
INSERT INTO nuq_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Na tama raa e oho no kirakira huri, tena ki vahihhiri hokolaatou ma, “Na mee nei e mee maea?” ");
INSERT INTO nuq_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Emeia alaa tama e tataussua na hakattina ana raa ma, “Na tama nei e unu no vvare!” ");
INSERT INTO nuq_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tena Pita ki mahike no tuu i aruna ma teeraa sanahuru ma tahi na aposol no tattara hakamaroa ake i te kanohenua raa ma, “Kootou na Jiu ia ma na tama e nnoho i Jerusalem raa, kootou ki hakallono mai, tena anau e me ki tattara atu ki illoa kootou te hakataakoto tera ni kapihi mai raa. ");
INSERT INTO nuq_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Na tama nei se unu no vvare pera ma kootou e hakataakoto raa; teenei ko te sivo koi te tahata. ");
INSERT INTO nuq_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Emeia teenei hea profet Joel ni tattara mai i mua ma, ");
INSERT INTO nuq_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘TeAtua e mee mai ma: Teenei hea Anau e me ki ppena i roto na aho hakaoti raa: Anau e me ki kou iho TeAnana Tapu Anau raa i aruna na tama hakaatoa. Na taupeara ma na taukupu kootou raa e me ki tattara atu na tattara Anau, tena na tamatane kootou raa e me ki kkite karemata na hakkatu, tena na taanata mattua kootou raa e me ki isi na miti. ");
INSERT INTO nuq_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tena na taanata ia ma na hhine e hehekau Anau raa, Anau e me ki kou ake TeAnana Tapu Anau raa i na tama raa i roto na aho naa, tena na tama raa e me ki tattara atu na tattara Anau. ");
INSERT INTO nuq_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Anau e me ki huri atu na mirakol i te vaelani ia ma na mee taualleka i te maarama i raro nei raa. Taatou e me ki kkite na toto, te ahi ia ma te kohu e mattoru roo; ");
INSERT INTO nuq_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","te laa raa e me ki pouri, tena te maremo raa e me ki mmea pera ma he toto, i mua te Aho hakanaaniu TeAtua raa e tae mai. ");
INSERT INTO nuq_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","He tama peehee e kanna ake te inoa TeAriki ki tokonaki aia, te tama naa e me ki ora.’ ");
INSERT INTO nuq_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Hakallono mai na tattara nei, na tama Israel! Jisas te tama i Nasaret raa he Tama e isi na mahi TeAtua tera Aia ni huri atu no kkite kootou i na mirakol ia ma na mee taualleka Aia ni pena i na mahi TeAtua raa. Kootou e illoa hokkootou na mee nei, maitaname na mee raa e kapihi mai i roto kootou i te kina nei. ");
INSERT INTO nuq_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","TeAtua ni hakamoe te hakataakoto Aia raa no tonu ma ki kou atu Jisas i kootou, tena na tama hai ssara raa ku tii Tama raa i aruna te kros ki mate i na rima kootou. ");
INSERT INTO nuq_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Emeia TeAtua e hakamahike Tama raa i taha ma te mate no hakattana Tama raa i taha ma na mahi te mate, maitaname te mate se lavaa te ttaohi Tama raa mo karapusi i te kina na tama e mmate raa. ");
INSERT INTO nuq_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tena Devit e tattara peenei iaa Jisas, ‘Anau e kite TeAriki e haere i mua anau na vahao hakaatoa. Aia e taapiri mai anau, tena anau se lavaa te tipuaina, ");
INSERT INTO nuq_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","tena anau e hihia roo i roto anau, tena na tattara anau raa ni tattara te hihhia. Niaina ma anau he tama koi, e meia anau e me ki noho ma te hakatina anau i TeAtua raa, ");
INSERT INTO nuq_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","e mee Akoe se lavaa te tiaki Anau i te kina na tama ku mmate raa; Akoe se lavaa te tiaki te Tama Hehekau hakamaoni Akoe raa ki para i te kava. ");
INSERT INTO nuq_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Akoe ku oti te huri mai Anau te mateara e haere i te kina te ora raa, tena te noho Akoe ma Anau raa e mee roo Anau no hihia.’ ");
INSERT INTO nuq_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Aku taina, anau e me ki tattara hakamatahua atu kootou i Devit te tuku hakanaaniu taatou raa. Tama raa e mate no tanu ria, tena te taruma aia raa koi tuu ma na taruma taatou raa te aho nei. ");
INSERT INTO nuq_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Devit he profet, tena aia e iroa hea TeAtua ni tattara ake aia raa. TeAtua ni tattara hakamaoni ake iaa Devit pera ma Aia e me ki mee he tama i na hai mokopuna aia raa ki tuku hoki pera ma aia raa. ");
INSERT INTO nuq_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Devit e kite hea TeAtua e me ki ppena i muri raa, tena aia ki tattara i te ora muri te Mesaia raa te saaita aia ni tattara ma, ‘Tama raa se lavaa te tiaki ki moe i te kina na tama ku mmate raa; te tinotama Aia raa se lavaa te para i te kava.’ ");
INSERT INTO nuq_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","TeAtua ni hakamahike Jisas i taha ma te mate, tena maatou hakaatoa e kkite te hakamaoni na mee nei. ");
INSERT INTO nuq_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jisas e haere i aruna no noho i te vahi laaua TeAtua te Tamana Aia raa, tena TeAtua ki kou ake TeAnana Tapu raa pera ma Aia ni tattara ake raa. Na mee kootou e kkite nei ia ma na mee kootou e llono raa ko na hoki Aia e kou mai maatou raa. ");
INSERT INTO nuq_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","E mee teeraa seai ma ko Devit ni haere i aruna i te vaelani raa, e meia aia e tattara ma, ‘TeAtua e meake TeAriki anau raa ma, Noho i te kina nei i te vahi laaua Anau raa, ");
INSERT INTO nuq_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ki ttae roo te saaita Anau e tuku na tama e kiri lloto Akoe raa i raro na tapuvae Akoe raa pera ma he tuai.’ ");
INSERT INTO nuq_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Kootou na tama Israel raa hakaatoa, kootou ki illoa pera ma Jisas kootou ni ttii i aruna te kros raa ko te Tama TeAtua ni mee pera ma ko TeAriki ia ma te Mesaia kootou raa!” ");
INSERT INTO nuq_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Te saaita te kanohenua raa ni llono na tattara nei, na tama raa ku tipuaina haeo roo, tena ki meake Pita ia ma alaa aposol ma, “Na taina maatou, niaa maatou e me ki ppena?” ");
INSERT INTO nuq_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Kito Pita ki meake na tama raa, “Kootou te tama ma te tama ki ttike i taha ma na hai sara kootou raa, tena ku too te hakoukou tapu i te inoa Jisas Krais, tena TeAtua e me ki ssirihia na hai sara kootou raa, tena kootou e me ki too TeAnana Tapu, te hoki TeAtua raa. ");
INSERT INTO nuq_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Maitaname TeAtua ni hakamoe te tattara hakamaoni Aia raa ma kootou ia ma na tamalliki kootou raa, na tama e mmao raa ia ma na tama hakaatoa TeAriki TeAtua taatou raa ni kanna ki oo ake Aia raa.” ");
INSERT INTO nuq_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita e tattara hai mahi ake te kanohenua raa, tena ki meake tammaki hoki na tattara, “Hakamattonu ki se lavaa kootou te ttiri na hakalono llihu TeAtua e me ki kou ake na tama haeo raa.” ");
INSERT INTO nuq_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tammaki na tama e hakattina na tattara nei, tena ki too te hakoukou tapu, ia tena e toru na simata na tama ku hakapaa ake i te kuturana na hakattina ana raa te aho naa koi. ");
INSERT INTO nuq_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Na tama raa e nnoho tahi ma na aposol raa no too na akoako na tama raa, tena ki hukui ma na tama raa no kkai te kai tapu ia ma na lotu. ");
INSERT INTO nuq_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Na aposol raa e ppena tammaki na mirakol ia ma na mee taualleka, tena na tama raa hakaatoa ku mahharo. ");
INSERT INTO nuq_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Na hakattina ana raa e kkutu tahi hakaatoa, tena ki vaevae i roto laatou hokolaatou hea laatou e isi raa. ");
INSERT INTO nuq_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Na tama raa e kou ake hea laatou e ttino ia ma hea laatou e isi raa ki sui alaa tama, tena ku vaevae na sileni raa i roto laatou hakaatoa tautari e hia te tama e hihai ");
INSERT INTO nuq_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Te aho ma te aho na hakattina ana raa e kkutu pera ma he kuturana i roto te Hare Tapu raa, tena na tama raa e kkai hakaatoa i roto na hare laatou raa. Na tama raa e kaikkai hakaraoi roo, ia e kkai ma te hihhia i roto na hatu manava laatou. ");
INSERT INTO nuq_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Na tama raa e hakammaha TeAtua, tena e hihhia i te taualleka na tama roo hakaatoa. Na aho hakaatoa TeAtua e hakapaa ake na tama ku hakattina raa i te kuturana raa. ");
INSERT INTO nuq_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","He aho hokotahi Pita laaua ma Jon e oo i te Hare Tapu te toru te hiahi, teenaa ko te saaita te lotu. ");
INSERT INTO nuq_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","E isi te tama na vae aia raa ni mmate roo te saaita aia ni haanau mai raa, tena aia e noho i te totoka e hui ma ko te Totoka Tiputipu laoi raa. Na aho hakaatoa na tama raa e sausau ake te tama raa no hakanoho i te mata totoka raa ki kainonno ake na tama e oo i roto te Hare Tapu raa ki kou ake ni sileni ma aia. ");
INSERT INTO nuq_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Te tama raa e kite Pita laaua ma Jon ku oo i hare, tena aia ki kainno ake tokorua raa ma ki kou ake ni sileni ma aia. ");
INSERT INTO nuq_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tena tokorua raa ku kira hakamattonu ake roo i te tama na vae e mmate raa, tena Pita ki meake, “Kira mai maaua!” ");
INSERT INTO nuq_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kito te tama raa ki kkira ake tokorua raa, tena aia e kkahu ma tokorua raa e me ki kou ake ni sileni. ");
INSERT INTO nuq_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kito Pita ki meake te tama raa ma, “Anau se isi roo na sileni, e meia anau e me ki kou atu hea anau e isi: i te inoa Jisas Krais te Tama Nasaret raa, anau e meatu akoe ki tuu i aruna no haere!” ");
INSERT INTO nuq_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Tena Pita ki taohi te rima laaua te tama raa no hakamahike i aruna. Te saaita naa koi na vae ia ma na hukui te tama raa ku ivi te tuu; ");
INSERT INTO nuq_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","kito te tama raa ki llee i aruna no ttuu na vae aia, tena ki kaamata no hahaere. Tena te tama raa ki oo laatou ma Pita laaua ma Jon i roto te Hare Tapu raa. Te tama raa e haere lellee, tena ki hakammaha ake TeAtua. ");
INSERT INTO nuq_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Te kanohenua raa ku kkite te tama na vae e mmate raa ku hahaere, tena laatou ki hakammaha hoki te inoa TeAtua, ");
INSERT INTO nuq_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","na tama raa ku mattino ma teeraa ko te tama e noho no kainonno i te kina te Totoka e Tiputipu laoi raa, tena na tama raa hakaatoa ku oho no mahharo ma hea roo ni kapihi ake i te tama raa. ");
INSERT INTO nuq_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Te tama raa koi tataohi koi Pita laaua ma Jon i te kina na tama raa e hui ma ko te Paaro Solomon raa, tena te kanohenua raa ku mahharo no huro atu i te tokotoru raa. ");
INSERT INTO nuq_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita e kite te kanohenua raa, tena aia ki meake na tama raa ma, “Na tama Israel, aiea kootou e mahharo naea? Aiea kootou e ttonu mai maatou naea? Kootou e kkahu ma aanei ni mahi maaua hokomaaua ia ma te ttonu tahi maaua raa e mee te tama nei no lavaa te hahaere? ");
INSERT INTO nuq_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","TeAtua Abraham, Aisak ia ma Jekop raa, tena TeAtua na tipuna taatou i mua raa ni kou ake na mahi hai mmahi i te vaelani raa iaa Jisas te Tama Hehekau Aia raa. Emeia kootou e kou ake te Tama raa i na tama hakamattua raa, tena kootou ki huri ake te se hihhai kootou i Tama raa i mua na karemata Pailat ia ma te saaita hoki Pailat ni maanatu ma ki hakattana Tama raa ki haere raa. ");
INSERT INTO nuq_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Tama raa e tapu, ia he Tama tauareka, e meia kootou se hihhai Tama raa, tena kootou ki meake Pailat ki ppena hea kootou e hihhai, tena kootou ki hakasao te tama taa tama raa. ");
INSERT INTO nuq_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kootou e taa te Tama e hakattaki taatou ki ora raa, tena TeAtua ki hakamahike Tama raa i taha ma te mate, tena maatou e kkite te mate ia ma te ora muri Tama raa. ");
INSERT INTO nuq_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Teenei ko te inoa Jisas raa e kou mai na mahi ki mee te tama na vae e mmate nei ki lavaa te hahaere. Hea kootou e kkite no illoa raa e oo mai hakaatoa i te vahi te hakattina i te inoa Jisas raa. Kootou hakaatoa ku kkite, te tama nei ku tauareka i na hakattina maaua i te inoa Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Aku taina, te saaita nei anau ku iroa pera ma hea kootou ia ma na tama hakamattua kootou raa ni ppena iaa Jisas raa e hamai koi i te vvare na pohouru kootou. ");
INSERT INTO nuq_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","TeAtua e tattara ake na profet Aia raa i mua ki tattara pera ma te Mesaia raa e me ki hakalono llihu, ia tena na tattara Aia raa ku hakamaoni te aho nei. ");
INSERT INTO nuq_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Ttike i taha ma na hai sara kootou raa te saaita nei, tena ku vakkai muri ake TeAtua ki lavaa Tama raa te ssirihia na hai sara kootou raa. Kame kootou e tauttari, ");
INSERT INTO nuq_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","tena TeAtua e me ki tokonaki na anana kootou raa ki ivi, tena Aia e me ki kauna ria atu Jisas te Mesaia Aia ku oti te hirihiri ma kootou raa. ");
INSERT INTO nuq_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jisas e me ki noho i te vaelani ki ttae roo te saaita na mee hakaatoa e oo mai no hoou pera ma TeAtua ni tattara ake na profet Aia i mua raa. ");
INSERT INTO nuq_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses e tattara ma, ‘TeAriki TeAtua kootou raa e me ki kauna ria atu he profet e ssau pera ma Aia ni kauna ria atu anau raa, tena te Tama naa e me ki hamai i roto koi kootou. Tena kootou ki hakallono na tattara hakaatoa Aia e tattara atu raa. ");
INSERT INTO nuq_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kame he tama se hakarono na tattara te Profet naa, tena te tama naa e me ki havakkee ria i taha ma na hakattina ana TeAtua raa hakaatoa, tena te tama naa e me ki hakalono llihu.’ ");
INSERT INTO nuq_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Tena na profet hakaatoa e too na tattara TeAtua raa hakapaa ma Samuel ia ma na profet i muri aia tera ni tattara hoki hea e me ki kapihi mai i roto na aho nei raa. ");
INSERT INTO nuq_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Te tattara e ivi TeAtua ni tattara ake na profet Aia raa e tattara i kootou, ia tena kootou i roto hoki na tattara hakamaoni TeAtua ni meake na tipuna kootou i mua raa. Pera ma Aia ni meake Abraham ma, ‘Anau e me ki hakatapu na tama hakaatoa i te maarama nei raa e mee koi na hai mokopuna akoe raa.’ ");
INSERT INTO nuq_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ia tena TeAtua ni hirihiri te Tama Hehekau Aia raa, tena ki kauna ria atu te Tama raa ki haere atu kootou i mua ma ki hakatapu kootou, tena ku tokonaki kootou ki ttike i taha ma na tiputipu sakkino kootou raa.” ");
INSERT INTO nuq_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita laaua ma Jon koi tattara ake koi te kanohenua raa te saaita na maatua raa, tena te purepure hakamaatua na purepure te Hare Tapu raa ia ma na Sadyusi raa ni ttae ake. ");
INSERT INTO nuq_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Na tama raa ku se hihhia roo, e mee Pita laaua ma Jon e akoako ake te kanohenua raa pera ma Jisas ku oti te mahike muri i taha ma te mate, tena na tattara nei e huri mai pera ma na tama e mmate raa e me ki mahhike muri no ora. ");
INSERT INTO nuq_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tena kito na tama raa ki hakapiki tokorua raa no ppono i roto te hare karapusi raa ki ttae teeraa aho, e mee te mee raa ku haere ki pouri. ");
INSERT INTO nuq_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Emeia tammaki na tama ni llono na tattara raa ku hakattina, tena te kooina na hakattina ana raa ku hakanuu no tae rima simata na tama. ");
INSERT INTO nuq_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Te aho taiao raa na tama hakananniu na Jiu raa, na tama hakamattua raa ia ma na tama poroporo na tuaa raa ku hakkutu hakaatoa i Jerusalem. ");
INSERT INTO nuq_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Na tama raa e kkutu ma Anas te pohouru hakanaaniu na maatua raa, tena Kaiafas, tena Jon, Aleksanda ia ma alaa tama i roto te manava na maatua hakananniu raa. ");
INSERT INTO nuq_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Na tama raa e meake Pita laaua ma Jon ki oo ake no ttuu i mua laatou, tena laatou ki vahiri ake tokorua ma, “Koorua e mee peehee te tama nei no hahaere? Ni mahi peehee koorua e isi, ia koorua e ttapa roo te inoa aii?” ");
INSERT INTO nuq_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","TeAnana Tapu raa ku tau i roto Pita, tena aia ki meake na tama raa, “Na tama hakananniu ia ma na tama hakamattua na kanohenua: ");
INSERT INTO nuq_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kame kootou e vahiri mai maaua i te mee tauareka maaua ni ppena i te tama na vae e mmate nei ia ma te tama nei e tauareka peehee, ");
INSERT INTO nuq_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","tena kootou hakaatoa e tau te illoa, ia na tama hakaatoa i roto Israel e tau te illoa pera ma te tama e tuu i mua kootou nei ku tauareka i na mahi te inoa Jisas Krais te Tama i Nasaret raa: te Tama kootou ni ttii no mate i aruna te kros raa, tena TeAtua ki hakamahike Tama raa i taha ma te mate no ora raa. ");
INSERT INTO nuq_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jisas ko te tama te Launiu Tapu raa e tattara ma, ‘Te hatu tera kootou na tama hakatuutuu hare raa ni hakahekeheke raa, ko te hatu e mmau roo hokoia i na hatu hakaatoa.’ ");
INSERT INTO nuq_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Jisas Hokoia e lavaa te tokonaki taatou ki ora; i roto te maarama nei hakaatoa TeAtua se hai inoa hoki peeraa ni kou ake na mahi ma ki tokonaki taatou ki ora.” ");
INSERT INTO nuq_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Na tama i roto te kuturana raa ku mahharo, e mee laatou e kkite Pita laaua ma Jon e ivi roo te tattara, tena laatou e illoa hoki pera ma tokorua raa ni tama vare koi, ia se skul hakaraoi. Tena na tama raa e illoa ma tokorua raa ni hahaere ma Jisas. ");
INSERT INTO nuq_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tena na tama raa ku se hai tattara hoki e lave te meake, maitaname laatou ku kkite te tama na vae ni mmate raa ku ttuu laatou ma Pita laaua ma Jon. ");
INSERT INTO nuq_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kito na tama raa ki meake Pita laaua ma Jon ma ki oo i aho ma te hare raa, tena laatou ku kaamata no tattara hemuu hokolaatou. ");
INSERT INTO nuq_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Na tama raa e tattara ma, “Hea taatou e me ki ppena i te tokorua nei? Na tama hakaatoa i roto Jerusalem raa ku illoa ma tokorua nei e ppena te mirakol e hainattaa te tama te ppena, ia tena taatou hokotaatou se lavaa te ppura hoki. ");
INSERT INTO nuq_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Taatou ki tattara hakamataku ake tokorua nei ki se lavaa te tattara ake alaa tama hoki i te inoa Jisas, ki se lavaa te mee nei te ttoha no ttae alaa tama.” ");
INSERT INTO nuq_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kito na tama raa ki kanna ake tokorua raa ki vakkai ake i hare, tena ki meake tokorua raa ki se lavaa roo te tattara ia ma ku akoako ake na tama i te inoa Jisas. ");
INSERT INTO nuq_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Tena Pita laaua ma Jon ki meake na tama raa ma, “Kootou hokkootou ki ukkui ma he mee peehee e tauareka i na karemata TeAtua: ki hakallono kootou ma ki hakallono TeAtua? ");
INSERT INTO nuq_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","E mee maaua ku se lavaa hoki te ppui na maihu maaua ma ki se tattara hea maaua ni kkite ia ma hea maaua ni llono raa.” ");
INSERT INTO nuq_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tena kito te kuturana na tama hakamattua raa ki tattara hakamataku ake roo tokorua raa, tena ki tiaki tokorua raa no oo. Na tama raa e kkite pera ma e hainattaa te kou ake ni hakalono llihu i tokorua raa, maitaname te kanohenua raa ku tattara hakamamaha TeAtua i te mee ni kapihi ake raa. ");
INSERT INTO nuq_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Te tama tokorua raa ni tokonaki no lavaa te hahaere raa ku tae tipu haa toe na hetau te matua aia. ");
INSERT INTO nuq_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tokorua raa ku hakattana ria ki oo, tena laaua ku vakkai i te kuturana laatou raa no tattara ake hea na maatua hakananniu ia ma na tama hakamattua raa ni meake laaua raa. ");
INSERT INTO nuq_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Na hakattina ana raa ku llono na tattara raa, tena na tama raa hakaatoa ku hakkutu no lotu ake TeAtua ma, “TeAriki, te Tama e pena te vaelani, te maarama nei, te lottai ia ma na mee roo hakaatoa! ");
INSERT INTO nuq_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Akoe ni tattara ake te tama hehekau Akoe raa, Devit te tipuna maatou raa i na mahi TeAnana Tapu ma, ‘Aiea na tama seai ma ni Jiu raa e lloto naea? Aiea na tama raa e penapena na hakataakoto sakkino raea? ");
INSERT INTO nuq_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Na tuku te maarama nei raa e tanattana hokolaatou ki oo no ppuhu, tena na tama hakamattua raa e kkutu hakaatoa, ki hakataukoti ma TeAtua ia ma te Mesaia Aia raa.’ ");
INSERT INTO nuq_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Maitaname Herot laaua ma Pontius Pailat e kkutu hakaatoa i roto te matakaina e rahi nei ma na tama seai ma ni Jiu raa ia ma na tama Israel raa ki hakataukoti ma Jisas, te Tama Hehekau e tapu Akoe ni mee mo Mesaia raa. ");
INSERT INTO nuq_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Na tama raa e hakkutu ma ki ppena i na mahi Akoe raa na mee hakaatoa tera Akoe ni hakamoe mai roo i mua ma e me ki kapihi mai raa. ");
INSERT INTO nuq_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","TeAriki, te saaita nei Akoe ki hakamaarona na tattara na tama raa e penapena raa, tena ku tokonaki maatou na tama hehekau Akoe nei ki ivi te tattara na tattara Akoe raa. ");
INSERT INTO nuq_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Haaro iho te rima Akoe raa no tokonaki na tama lavvea raa ki taualleka, tena ku kou mai ni mahi ki ppena na mirakol ia ma na mee taualleka maatou e me ki ppena i te inoa Jisas te Tama Hehekau e tapu Akoe raa.” ");
INSERT INTO nuq_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Te lotu raa ku masseu, tena te kina na tama raa e kkutu raa ku naue. TeAnana Tapu raa ku tau i roto na tama raa, tena na tama raa ku kaamata no tattara na tattara TeAtua raa, ia e ivi hoki te tattara. ");
INSERT INTO nuq_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Na hakattina ana raa hakaatoa e oo roo te maanatu hokotahi. Se hai tama laatou e tattara ma na mee aia e ttino raa ni mee koi aia, e meia laatou hakaatoa e vaevae hakaraoi roo na mee laatou e ttino raa ma alaa tama. ");
INSERT INTO nuq_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Na aposol raa e tattara ma na mahi hai mmahi i te ora muri TeAriki Jisas, ia tena TeAtua e kou ake te hakatapu e rahi roo i na tama raa hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Se hai tama i roto te kuturana raa e tuutuu haeo. Na tama e ttino na kerekere ia ma na hare raa e kou ake na mee raa ki sui alaa tama, tena ku too na sileni laatou e too i na mee raa ");
INSERT INTO nuq_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","no kou ake i na aposol raa, tena na aposol raa ku vaevae ake na sileni raa i na tama, tautari e hia te tama e hihai. ");
INSERT INTO nuq_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tena Josep he tama i roto te hareakina Levi tera ni haanau iho i Saiprus, tena na aposol raa e kakanna te tama raa ma ko Banabas (te inoa nei e mee ma, “Te tama Hakapurupuru”), ");
INSERT INTO nuq_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","te tama raa e kou ake te kerekere aia raa no sui alaa tama, tena ki too na sileni raa no kou ake na aposol raa. ");
INSERT INTO nuq_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","He tama e hui ma ko Ananaias laaua ma Safaira te avana aia raa e too na mee hakaatoa laaua e ttino raa no kou ake alaa tama ki sui. ");
INSERT INTO nuq_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Emeia Safaira laaua ma Ananaias e tattara no tonu ma laaua ki taohi he kooina, tena ku kou ake na sileni e ttoe raa i na aposol raa. ");
INSERT INTO nuq_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kito Pita ki meake, “Ananaias, aiea akoe e tiaki Satan ki haere atu i roto akoe no mee akoe ki mariu ake TeAnana Tapu raa, tena akoe ki ttaohi teeraa kooina na sileni na mee akoe ni kou ake alaa tama ki sui raea? ");
INSERT INTO nuq_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Na mee raa ni mee akoe e ttino i mua akoe ni kou ake na mee raa ki sui alaa tama; te saaita na tama raa ku oti te sui na mee akoe e ttino raa, tena na sileni raa ni sileni hoki akoe. Kaa akoe ni maanatu roo peehee ma ki ppena te maanatu haeo naa? Akoe se mee ma akoe e mariu ake te tama, e meia akoe e mariu ake TeAtua!” ");
INSERT INTO nuq_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaias e rono koi na tattara nei, tena aia ku hina i raro no mate, tena na tama hakaatoa e llono te mate te tama raa ku mattaku roo. ");
INSERT INTO nuq_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Kito na taupeara raa ki oo ake no mmini te tinotama tama raa, tena ki ssau i aho no tanu. ");
INSERT INTO nuq_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Se roroa koi te avana Ananaias raa ku haere ake iaa Pita, e meia aia se iroa ma hea ni kapihi ake iaa Ananaias raa. ");
INSERT INTO nuq_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Tena Pita ki vahiri ake te hine raa, “Mee mai, teenei te kooina na sileni hakaatoa akoe ma te avana akoe raa ni too i na mee koorua ni kou ake alaa tama ki sui raa ma seai?” Tena Safaira ki meake, “Noo, teenaa te kooina na sileni naa hakaatoa.” ");
INSERT INTO nuq_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kito Pita ki meake Safaira, “Aiea koorua hai avana e mannatu ma ki hahaaite TeAnana Tapu TeAriki naea? Na taupeara ni tanu te avana akoe raa ku ttuu vahao nei i te totoka, tena na tama raa e me ki ssau hoki akoe i aho.” ");
INSERT INTO nuq_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Te saaita naa koi Safaira ku hina i raro i mua na vae Pita raa no mate hoki. Na taupeara raa ku oo mai no kkite ma Safaira ku mate, tena laatou ki ssau te tama raa i aho no tanu i te vahi Ananaias. ");
INSERT INTO nuq_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tena na hakattina ana raa hakaatoa ia ma na tama ni llono raa ku mattaku roo. ");
INSERT INTO nuq_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na aposol raa e huri ake tammaki na mirakol ia ma na mee taualleka no kkite na tama raa. Tena na hakattina ana raa hakaatoa ku hakkutu i te kina te Paaro Solomon raa. ");
INSERT INTO nuq_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Na tama seai ma ni tama i roto te kuturana nei raa ku mattaku te hukui ake na tama raa, niaina roo ma te kanohenua raa e tattara hakammaha roo i na tama raa. ");
INSERT INTO nuq_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tena tammaki na taanata ia ma na hhine ku hakattina i TeAriki, tena ki hukui ake i te kuturana na hakattina ana raa. ");
INSERT INTO nuq_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Maitaname te kanohenua raa e kkite hea na aposol raa ni ppena raa, tena na tama raa ku sausau iho na tama lavvea raa i te mateara no hakammoe na tama raa i aruna koi na lomoena laatou raa ma ki lavaa te inaina Pita raa te raka vaa aruna alaa tama te saaita aia e haere hakaraka raa. ");
INSERT INTO nuq_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Tena na kanohenua na matakaina e alleha i Jerusalem raa ku mmui ake no kou ake na tama lavvea raa ia ma na tama e isi na tipua i roto laatou raa, tena na tama lavvea raa hakaatoa ku taualleka. ");
INSERT INTO nuq_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tena te pohouru hakanaaniu na maatua raa ma na tama e huhukui ma aia raa ia ma na tama i roto te kuturana na Sadyusi raa ku manava kkere haeo roo i na aposol raa, tena laatou ki tattara ma ki ppena he mee. ");
INSERT INTO nuq_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Na tama raa e hakapiki na aposol raa, tena ki ppono na tama raa i roto te hare karapusi te matakaina raa. ");
INSERT INTO nuq_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Emeia te poo naa, te ensel TeAtua raa ku taaraki te totoka te hare karapusi raa no hakattaki na tama raa i aho, tena ki meake, ");
INSERT INTO nuq_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Oo no ttuu i roto te Hare Tapu raa, tena ku takutaku ake te kanohenua raa i te ora vahao nei raa.” ");
INSERT INTO nuq_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Na aposol raa e hakallono, tena te tahata poo roo na tama raa ku oo no uru i roto te Hare Tapu raa, tena ki kaamata no takutaku. Te pohouru hakanaaniu na maatua raa ma na tama e huhukui ma aia raa ku kanna ake na tama hakamattua na Jiu raa ki oo ake ki hakkutu hakaatoa, tena na tama raa ki kkave te tattara i te hare karapusi raa ma ki hakattaki ake na aposol raa no hakattuu i mua laatou. ");
INSERT INTO nuq_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Emeia te saaita na purepure raa ni ttae i te hare karapusi raa, na tama raa ku se kkite na aposol raa, kito na purepure raa ki vakkai no meake na tama hakamattua raa ma, ");
INSERT INTO nuq_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Maatou e oo no ttae i te hare karapusi raa, tena maatou e kkite ma te totoka raa e loki no mmau nniti roo, tena na tama lollohi raa e ttuu koi i te totoka. Emeia te saaita maatou ni taaraki te totoka raa, maatou ku se hai tama e kkite i hare!” ");
INSERT INTO nuq_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Te saaita na maatua hakananniu raa ia ma te purepure e rorohi te Hare Tapu raa ni llono na tattara na tama raa, na tama raa ku mamaanatu tammaki roo ma hea ni kapihi ake i na aposol raa. ");
INSERT INTO nuq_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tena he tama ku haere ake i hare no meake na tama raa ma, “Hakallono! Na tama kootou ni ppono i roto te hare karapusi raa ku ttuu vahao nei i roto te Hare Tapu raa no takutaku ake te kanohenua raa!” ");
INSERT INTO nuq_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tena te purepure hakamaatua raa ki haere ma na purepure aia raa no too na aposol raa no hakattaki ake. Na tama raa e too hakaraoi koi na aposol raa, e mee laatou e mattaku ma ka oti te kanohenua raa ku maka laatou na hatu. ");
INSERT INTO nuq_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Na purepure raa e hakattaki ake na aposol raa i hare, tena ki meake na tama raa ki ttuu i mua na tama hakamattua na Jiu raa, kito te pohouru hakanaaniu na maatua raa ki vahihhiri ake na tama raa. ");
INSERT INTO nuq_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Tena te maatua raa ki meake ma, “Maatou e kou atu na tattara hakamattaku ma kootou ki se lavaa te akoako ake na tama i te inoa Jisas. Emeia kira ake ma hea kootou e hai naa! Kootou e ttoha na akoako kootou raa vaa roto Jerusalem hakaatoa, tena kootou e hihhai ma ki mee pera ma teenei ko maatou e taa te Tama raa no mate!” ");
INSERT INTO nuq_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tena Pita ma alaa aposol ki meake, “Maatou e me ki tauttari TeAtua, maatou se lavaa te tauttari te tama. ");
INSERT INTO nuq_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","TeAtua na tipuna taatou i mua raa e hakamahike Tama raa i taha ma te mate i muri kootou ni ttii Tama raa no mate i aruna te kros. ");
INSERT INTO nuq_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","TeAtua e ssau Tama raa i aruna no hakanoho i te vahi laaua Aia ki mee mo Tama Hakamaatua ia ma he Tokonaki taatou ki lavaa na tama Israel raa te ttike i taha ma na hai ssara laatou raa. ");
INSERT INTO nuq_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Maatou e kkite karemata na mee nei, tena maatou ma TeAnana Tapu, te hoki TeAtua ni kou ake i na tama e tauttari Aia raa.” ");
INSERT INTO nuq_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Te saaita na tama hakamattua na Jiu raa ni llono na tattara nei, na tama raa ku lloto haeo roo, tena laatou ku mannatu ma ki taa na aposol raa ki mmate. ");
INSERT INTO nuq_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ia tena he Farisi i roto laatou ku mahike no tuu i aruna, te inoa aia raa ko Gamaliel, e meia aia he tama poroporo na tuaa, tena na tama hakaatoa e hakammaha te tama raa. Gamaliel e meake ma ki hakattaki na aposol raa i aho, ");
INSERT INTO nuq_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","tena aia ki meake na tama laatou hakamattua raa, “Taatou na tama hakamattua Israel, taatou ki hakamattonu hea taatou e mannatu ma ki ppena i na tama nei raa. ");
INSERT INTO nuq_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kootou e mannatu Teudas, te tama ni hakahura mai paa saaita ku oti raa ma aia he tama e hakanaaniu; tena kame e ttae peeraa haa huitarau na tama ni tauttari tama raa. Emeia te tama raa e taia ria koi no mate, tena na tama hakaatoa ni tauttari aia raa ku maaseu, tena hea aia ni kaamata raa ku seai koi. ");
INSERT INTO nuq_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tena ki oti Judas te tama i Galili raa ku hakahura mai te saaita te paupau na tama raa, tena e tammaki hoki na tama ni tauttari tama raa, e meia tama raa e taia ria hoki no mate, tena na tama ni tauttari aia raa ku maaseu huri. ");
INSERT INTO nuq_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ia te mee nei, anau e meatu ma taatou se lavaa te ppena he mee i na tama nei. Tiaki koi na tama naa! Kame hea laatou e hakamoe ia ma hea laatou e ppena raa e hamai koi te tama, tena te mee naa e me ki haere hoki no seai, ");
INSERT INTO nuq_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","e meia kame te mee naa e hamai TeAtua, tena taatou kame se tau te ppui na tama naa. Taatou e me ki kkite ma taatou e ppuhu koi ma TeAtua!” Tena na tama hakamattua raa ku tauttari te hakataakoto Gamaliel raa. ");
INSERT INTO nuq_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Na tama raa e kanna ake na aposol raa ki oo ake i hare, tena laatou ki riki na tama raa, tena ki tattara hakamataku ake na tama raa ki se lavaa hoki te tattara i te inoa Jisas, tena laatou ki hakattana na aposol raa no oo. ");
INSERT INTO nuq_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Te saaita na tama raa ni tiaki na tama hakamattua raa no oo, na tama raa e hihhia koi, maitaname TeAtua e kkira ma e tauareka koi laatou te hakalono llihu e mee laatou e hehekau i te inoa Jisas. ");
INSERT INTO nuq_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Na aposol raa e tauhano koi te takutaku ake te Rono Tauareka Jisas te Mesaia raa na aho hakaatoa i roto te Hare Tapu ia ma i roto koi na hare na tama raa. ");
INSERT INTO nuq_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tena i muri, te kooina na hakattina ana raa ku haere homo koi no tammaki, tena na Jiu e illoa na tattara ha Grik raa ku hakatauttau ma na Jiu i te henua raa. Na Jiu e illoa na tattara ha Grik raa ku lloto ma na Jiu raa e hai lavvaka i na tautukaha hhine laatou raa i te vahi na sileni e vaevvae te aho ma te aho raa. ");
INSERT INTO nuq_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tena kito te sanahuru ma rua na aposol Jisas raa ki hakkutu ake na hakattina ana raa hakaatoa, tena ki meake, “Te mee naa se tonu ma taatou ki tiaki na takutaku na tattara TeAtua raa, tena ku lollohi koi na sileni. ");
INSERT INTO nuq_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ia tena aku taina, taatou ki hirihiri e hitu na taanata i roto kootou tera TeAnana Tapu raa e tau i roto laatou, ia e atamai hoki, tena taatou ku tuku na tama naa ki lollohi na sileni. ");
INSERT INTO nuq_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tena maatou hokomaatou e me ki lotu tahi, tena ku hehekau no takutaku.” ");
INSERT INTO nuq_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Te kuturana raa hakaatoa e hihhai te hakataakoto na aposol raa, kito na tama raa ki hirihiri Stiven, he tama e isi TeAnana Tapu i roto aia, ia he tama e hakatina mmahi roo, tena Filip, Prokorus, Nikanor, Timon, Parmenas, tena Nikolas te tama i Antiok ku mee pera ma he Jiu raa. ");
INSERT INTO nuq_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tena te kuturana raa ki too na tama raa no kou ake i na aposol raa, tena na aposol raa ki lotu no hakapiri na rima laatou raa i aruna na tama raa. ");
INSERT INTO nuq_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tena na tattara TeAtua raa ku tauhano koi te ttae alaa tama. Te kooina na disaipol i roto Jerusalem raa e haere tammaki koi, tena te kooina na maatua ku hakattina raa e tammaki hoki. ");
INSERT INTO nuq_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stiven he tama TeAtua e hakatapu hai mahi roo, tena ki kou ake na mahi tama raa ki ppena na mirakol e llahi ia ma na mee taualleka i mua na kanohenua. ");
INSERT INTO nuq_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Emeia e isi na tama e hakataukaa ma Stiven. Teenei ni Jiu tera ni hehekau ma na tama i mua, e meia te saaita nei na tama raa ku ttana, tena na Jiu nei e nnoho i roto Sairini laaua ma Aleksandria. Na Jiu raa hakapaa ma na Jiu i roto Silisia laaua ma Esia raa ku hakatauttau laatou ma Stiven. ");
INSERT INTO nuq_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Emeia TeAnana Tapu raa e kou ake te atamai e rahi roo iaa Stiven, tena te saaita aia ni tattara, se hai tama hoki e lavaa te hakatauttau ma aia. ");
INSERT INTO nuq_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kito na tama raa ki sui alaa tama ki tattara ma, “Maatou e llono te tama nei e tattara haeo Moses laaua ma TeAtua!” ");
INSERT INTO nuq_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Na tattara nei e mee te kanohenua raa, na tama hakamattua raa ia ma na tama e poroporo na tuaa raa no lloto roo. Na tama raa ku hakapiki Stiven, tena ki kkave tama raa no hakatuu i mua te kuturana na tama hakamattua raa. ");
INSERT INTO nuq_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Kito na tama hakamattua raa ki kou ake na tama i hare raa ki hatu ma malliu laatou iaa Stiven. Na tama raa e tattara ma, “Maatou e llono te tama nei e tattara haeo te Hare Tapu, ia ma na Tuaa Moses raa. ");
INSERT INTO nuq_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Maatou e llono te tama nei e tattara ma Jisas te tama i Nasaret raa e me ki seu te Hare Tapu nei ki maseu, tena ku hakatike na tiputipu hakaatoa tera Moses ni kou mai taatou raa.” ");
INSERT INTO nuq_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Na tama hakaatoa e nnoho i te kina raa ku ttonu ake roo iaa Stiven. Na tama raa ku kkite ma na maihu tama raa ku ssau roo pera ma na maihu te ensel raa. ");
INSERT INTO nuq_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Te pohouru hakanaaniu na maatua raa e vahiri ake Stiven ma, “Na tattara nei e hakamaoni?” ");
INSERT INTO nuq_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Kito Stiven ki meake, “Aku taina ma aku tamana. Hakallono mai anau! I mua Abraham te tipuna taatou raa ni haere no noho i Haran, TeAtua na mahi hakaatoa raa ku tuu ake iaa Abraham i Mesopotemia, ");
INSERT INTO nuq_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","tena ki meake tama raa ma, ‘Tiaki na hareakina akoe raa ma te henua akoe raa, tena akoe ku haere i te henua Anau e me ki huri atu akoe raa.’ ");
INSERT INTO nuq_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Kito Abraham ki tiaki te henua aia raa, tena ki haere no noho i Haran. I muri te saaita te tamana Abraham raa ni mate, TeAtua ku meake hoki Abraham ki kkene mai i te henua kootou ku nnoho nei. ");
INSERT INTO nuq_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","TeAtua ni se kou ake he kerekere i roto te henua raa ma Abraham ki ttino, ia se hai paa kina hoki Abraham e ttino, e meia TeAtua e tattara ake hakamaoni ma Aia e mee ki kou ake te henua raa ma Abraham, tena te henua raa e me ki mee pera ma he henua Abraham ma na hai mokopuna aia raa. TeAtua e hakamoe te tattara nei ma Abraham te saaita Abraham ni se ki hai tamalliki. ");
INSERT INTO nuq_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Teenei hea TeAtua e meake Abraham ma, ‘Na hai mokopuna akoe raa e me ki nnoho i te henua na tama e kkee roo, tena na tama raa e me ki mee mo tama hehekau i roto haa huitarau na hetau, tena na tama te henua naa e me ki mee hakahaeo roo na hai mokopuna akoe raa. ");
INSERT INTO nuq_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Anau e me ki kou ake te hakalono llihu na tama tera e mee na hai mokopuna akoe raa mo tama hehekau laatou raa, tena ki oti na hai mokopuna akoe raa ku mee no oo i taha ma te henua naa no lotulotu mai Anau i te henua nei.’ ");
INSERT INTO nuq_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kito TeAtua ki meake Abraham ki ttuu te hakamaatino e tapu raa i na taanata pera ma he hakamaatino i te tattara e ivi Aia raa. I muri te latapu hokotahi te saaita Aisak ni haanau iho raa, Abraham ku ttuu te hakamaatino e tapu raa iaa Aisak, tena Aisak ki ttuu hoki te hakamaatino e tapu raa iaa Jekop te tamariki aia raa, tena Jekop ki ttuu te hakamaatino e tapu raa i te sanahuru ma rua na taanata aia raa. Te sanahuru ma rua na tipuna taatou tera na tama hakaatoa e illoa raa. ");
INSERT INTO nuq_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Alaa tamatane Jekop ku manava kkere iaa Josep te taina laatou raa, tena na tama raa ki kou ake Josep i na tama Isip raa ki sui ria pera ma he tama hehekau. Emeia TeAtua e noho ma Josep, ");
INSERT INTO nuq_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","tena ki hakattana tama raa i taha ma na hakalono llihu aia raa hakaatoa. Josep ku haere no tuu i mua te tuku i Isip raa, tena TeAtua e mee Josep ki tuu tauareka roo i mua te tama raa, ia e atamai hoki, tena te tuku raa ki mee Josep ki hakamaatua i roto Isip ia ma i roto te hare te tuku raa. ");
INSERT INTO nuq_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Tena ki oti Isip laaua ma Kenan hakaatoa ku ttiri te hikkai e haeo roo tera e mee tammaki na tama no hakalono llihu. Na tipuna taatou raa ku se isi na kai ki kkai. ");
INSERT INTO nuq_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jekop ku rono ma e isi na kai i Isip, tena aia ki kauna na tamatane aia raa, na tipuna taatou raa ki oo i te horau kaamata roo laatou raa i Isip. ");
INSERT INTO nuq_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Tena te saaita na tama raa ni vakkai tana rua, Josep ku hakari ake aia hokoia i na taina aia raa, tena te tuku i Isip raa ku mee no iroa te hareakina Josep raa. ");
INSERT INTO nuq_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kito Josep ki kkave te tattara raa iaa Jekop, te tamana aia raa ki meake te tipu hitu ma rima na tama i roto te hareakina aia raa hakaatoa ki oo ake i Isip. ");
INSERT INTO nuq_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tena Jekop ki haere Isip, i te henua aia ma na tamatane aia raa e me ki mmate raa. ");
INSERT INTO nuq_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Na tama raa e kkave na tinotama na tama raa no tanu i Sekem, i roto te kava Abraham ni sui ake na sileni i na tama te manava Hamor raa. ");
INSERT INTO nuq_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Te saaita TeAtua ku mee ki hakamaoni te tattara Aia ni hakamoe ma Abraham raa ku taapiri ki ttae, tena te kooina na tama taatou i roto Isip raa ku haere no tammaki roo. ");
INSERT INTO nuq_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tena ki oti roo he tuku ni se iroa mai Josep ku tuku i roto Isip. ");
INSERT INTO nuq_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Aia e hai laavaka na tipuna taatou raa, tena ki hai haeo roo na tama raa, tena ki hakamataku ake na tama raa ki tuku na tamalliki laatou raa i aho ma na hare laatou raa ki mmate na tamalliki raa. ");
INSERT INTO nuq_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Teenei ko te saaita Moses, he tamariki tauareka roo ku haanau iho. Na maatua aia raa e lollohi te tamariki raa i roto te hare laatou raa e toru na marama, ");
INSERT INTO nuq_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ia te saaita na maatua te tamariki raa ni kkave te tamariki raa i taha ma te hare laatou raa, te taukupu te tuku raa ku ppuru te tamariki raa, tena ki too te tamariki raa pera ma he tamariki roo aia. ");
INSERT INTO nuq_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Na tama raa e akoako Moses i te atamai na tiputipu Isip raa hakaatoa, tena Moses he tama roo hakamaoni i te vahi te tattara ia ma na mee aia e ppena raa. ");
INSERT INTO nuq_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Moses ku ttae tipu haa na hetau te matua aia, tena aia ku maanatu ma ki haere no mmata ma na tama Isip raa e mee peehee na taina aia na tama Israel raa. ");
INSERT INTO nuq_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tena aia ku kite he tama hokotahi e taia ria te tama i Isip, tena aia ki haere atu ma ki tokonaki te tama raa, tena aia ki taa te tama Isip raa no mate. ");
INSERT INTO nuq_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","(Aia e kkahu ma na tama Israel raa e mee ki kkite no illoa pera ma TeAtua e me ki too aia ki hakassao laatou, e meia na tama raa se illoa.) ");
INSERT INTO nuq_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Te aho taiao raa Moses ku kite tokorua na tama Israel e ppuhu, tena aia ku hahaivi ma ki mee tokorua raa ki tattara hakaraoi. Tena Moses ki meake, ‘Koorua ki hakallono mai, koorua ni tama Israel hakaatoa, kaa koorua e ppuhu ma ki aa?’ ");
INSERT INTO nuq_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Kito te tama e taa teeraa tama raa ki unuki Moses i taha, tena ki meake, ‘Koai te tama e mee akoe ki hakamaatua, tena ku hakatonutonu maatou? ");
INSERT INTO nuq_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Akoe e hihai ki taa anau ki mate hoki pera ma akoe ni taa te tama Isip raa te aho raa?’ ");
INSERT INTO nuq_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses e rono koi na tattara nei, tena aia ki tere i taha ma Isip no haere no noho i Midian. Tena aia ku isi e rua na tamalliki taanata i te henua raa. ");
INSERT INTO nuq_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Tipu haa na hetau ku llaka, tena te ensel TeAtua raa ku tuu ake iaa Moses i roto te pupu e ura i te kina e tuu mahoa taapiri i te Mouna Sainai raa. ");
INSERT INTO nuq_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses ku maaharo roo i te mee aia e kite raa, tena aia ki haere atu no taapiri te pupu raa ma ki kite laoi aia. Tena aia ku rono te reo TeAtua raa e tattara ma: ");
INSERT INTO nuq_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Anau ko TeAtua na tipuna akoe raa, TeAtua Abraham, TeAtua Aisak, tena TeAtua Jekop.’ Moses ku porepore roo te mataku, tena aia ku se hihai ki kkira ake hoki te pupu raa. ");
INSERT INTO nuq_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Tena TeAtua ki meake Moses ma, ‘Ui na taka akoe naa i taha, e mee te kerekere akoe e tuu naa he kina e tapu. ");
INSERT INTO nuq_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Anau ku kite te kanohenua Anau raa e hakalono llihu haeo roo i roto Isip. Anau e rono te ttani laatou, tena Anau ku hamai i raro ki hakassao laatou. Hamai vahao nei, Anau e me ki kauna akoe ki haere i Isip.’ ");
INSERT INTO nuq_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moses ko te tama te kanohenua Israel raa ni se hihhai. Na tama raa ni vahiri ake ma, ‘Koai te tama e mee akoe ki hakamaatua, tena ku hakatonutonu maatou?’ Moses ko te tama TeAtua e kauna ki rorohi te kanohenua raa, tena te ensel tera ni tuu ake aia i roto te pupu e ura raa e me ki tokonaki aia. ");
INSERT INTO nuq_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses e hakattaki te kanohenua raa i taha ma Isip, tena ki huri ake na mirakol ia ma na mee e llahi roo i roto Isip ia ma i te kina te Moana e Mmea raa ia ma i te kina e tuu mahoa raa i roto tipu haa na hetau. ");
INSERT INTO nuq_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moses ko te tama ni meake te kanohenua Israel raa ma, ‘TeAtua e me ki kauna ria atu he profet e ssau pera ma Aia e kauna ria mai anau raa, te Tama naa e me ki hamai i roto koi kootou.’ ");
INSERT INTO nuq_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Te tama nei e hai hoki i roto te kanohenua Israel tera ni kkutu i te kina e tuu mahoa raa, tena aia e tuu i te kina raa ma na tipuna taatou i mua raa ia ma te ensel ni tattara ake aia i aruna te Mouna Sainai raa, tena aia ki too na tattara TeAtua e isi te ora raa no hakatae mai taatou. ");
INSERT INTO nuq_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Emeia na tipuna taatou raa se hihhai ki hakallono tama raa; na tama raa e unuki tama raa i taha, tena ki tattara ma laatou ki vakkai koi i Isip. ");
INSERT INTO nuq_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kito na tama raa ki meake Aron, ‘Penapena mai he atua ki hakattaki maatou. Maatou ku se illoa hea e kapihi ake iaa Moses te tama ni hakattaki mai taatou i taha ma Isip raa.’ ");
INSERT INTO nuq_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tena ki oti na tama raa ku penapena te hatu tipua e ssau pera ma he bulmakau, tena ki hoki ake na hoki i te hatu tipua raa, tena ki pena te kai e rahi roo ma ki hakammaha hea laatou hokolaatou ni pena raa. ");
INSERT INTO nuq_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","TeAtua ku haere i taha ma na tama raa, tena ki tiaki na tama raa ki hakamarumaru na hetuu i te vaelani raa pera ma hea e mmau i roto te launiu na profet raa ma, ‘Te kanohenua Israel! Kootou e nnoho tipu haa na hetau i roto te kina e tuu mahoa, tena na manu kootou e taa raa, kootou se hoki mai Anau. ");
INSERT INTO nuq_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Teenaa ko te paa hare te atua Molek raa kootou e amoamo, tena te hatu tipua Refan, te hetuu atua kootou raa; Aanei ni hatu tipua kootou e penapena ma ki lotulotu. Ia tena Anau e me ki hakaise kootou i taha ki hakahiti roo i teeraa vahi i Babilon.’ ");
INSERT INTO nuq_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Na tipuna taatou raa e hahaere ma te Paa Hare TeAtua raa i roto te kina e tuu mahoa raa. Te Paa Hare raa e pena tautari hea TeAtua ni meake Moses ki pena raa, tena ki tautari hoki hea TeAtua ni huri ake tama raa. ");
INSERT INTO nuq_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tena ki oti na tipuna taatou raa ku too te Paa Hare raa i na tamana laatou raa, tena ki amoamo te Paa Hare raa te saaita laatou ni oo ma Josua no too na henua TeAtua ni hakaise na tama na henua raa i taha raa, te saaita na tama Israel raa ni oo atu. Te Paa Hare raa e tuu roo no tae te saaita Devit. ");
INSERT INTO nuq_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Devit he tama roo e hakarono, tena TeAtua e hihai roo te tama raa, kito aia ki kainno ake TeAtua ma ki tiaki aia ki pena he hare ma TeAtua Jekop raa ki noho. ");
INSERT INTO nuq_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Emeia teeraa ko Solomon e pena te Hare Tapu TeAtua raa. ");
INSERT INTO nuq_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Emeia TeAtua Hakanaaniu i Aruna raa se noho i roto na hare na tama e pena ma na rima laatou raa pera ma hea na profet raa ni tattara raa: ");
INSERT INTO nuq_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","TeAriki e mee ma, ‘Te Vaelani ko te Nohorana Anau, tena te maarama nei ko te kina Anau e tukutuku na tapuvae Anau raa. He hare peehee kootou e me ki pena ma Anau naa? Teehee te kina Anau e me ki noho naa? ");
INSERT INTO nuq_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Aiea teenei seai ma ko Nau e pena na mee nei hakaatoa?’ ” ");
INSERT INTO nuq_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Tena Stiven ki meake hoki ma, “Kootou e vvare roo! Na hatu manava kootou raa e pouri, tena na katarina kootou raa e tturi te hakallono na tattara TeAtua raa! Kootou e ssau roo pera ma na tipuna kootou i mua raa, ia kootou hoki na vahao tahi e kkeu i taha ma TeAnana Tapu! ");
INSERT INTO nuq_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ia e isi te profet tera na tipuna kootou raa ni se taa no mate? Na tama raa e taa no mmate na profet TeAtua ni tattara mai i mua roo i te hamai te Tama Hehekau e tonu tahi raa. Tena te saaita nei kootou e kou ake te Tama raa i na tama haeo raa, tena kootou ki taa Tama raa no mate. ");
INSERT INTO nuq_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kootou ko na tama e too na tuaa TeAtua tera na ensel raa ni kou mai raa. Emeia kootou se tauttari na tuaa raa.” ");
INSERT INTO nuq_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Na tama hakamattua raa e nnoho no hakallono na tattara Stiven raa, tena na tama raa ku lloto haeo roo, tena ki utiuti roo na paati laatou. ");
INSERT INTO nuq_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Emeia TeAnana Tapu raa ku tau i roto Stiven, tena aia ku kkira i te vaelani no kite na mahi TeAtua raa ia ma Jisas e tuu i te vahi laaua Tama raa. ");
INSERT INTO nuq_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tena aia ki meake, “Kira ake, anau e kite te vaelani raa ku taaraki, tena te Tamariki te Tama nei raa e tuu i te vahi laaua TeAtua.” ");
INSERT INTO nuq_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Na tama hakamattua raa ku ttani na varo laatou raa, tena ki ppui na katarina laatou raa ma na rima laatou. Kito na tama raa hakaatoa ki hakaoho ake iaa Stiven raa ");
INSERT INTO nuq_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","no horo tama raa i taha ma te matakaina raa, tena ki maka tama raa ma na hatu. Na tama e maka raa e ui na kaukahu lolloa laatou raa, tena ki kou ake te taupeara te inoa aia raa ko Sol ki rorohi. ");
INSERT INTO nuq_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Na tama raa koi maka koi Stiven ma na hatu te saaita aia ni kanna ake TeAriki ma, “TeAriki Jisas, too te anana anau.” ");
INSERT INTO nuq_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tena Stiven ki tuturi i raro no kanna ake hakamaroa ma, “TeAriki! Auu se maanatu ria na hai sara na tama nei.” Aia e tattara ake koi peenei, tena ki mate. ");
INSERT INTO nuq_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sol e hakatina hoki ma te mate Stiven raa e tonu. Te aho naa koi te hare lotu i Jerusalem raa ku ttiri na hakalono llihu haeo roo. Tena na hakattina ana raa hakaatoa ku maaseu i na kina hakaatoa i roto na matakaina Judia laaua ma Samaria raa, e meia na aposol raa e nnoho koi se maaseu. ");
INSERT INTO nuq_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","E isi na hakattina ana e tanu Stiven, tena ki tanittani hakamaroa roo i te alloha laatou iaa Stiven. ");
INSERT INTO nuq_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Emeia Sol e hihai ma ki seu na hakattina na hakattina ana raa, tena aia ki haere hakatike na hare raa hakaatoa no horo mai na hakattina ana raa i aho, na taanata ia ma na hhine, tena ki ppono na tama raa i roto te hare karapusi. ");
INSERT INTO nuq_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Na hakattina ana ni maaseu i na kina raa ku oo i na matakaina hakaatoa no takutaku te Rono Tauareka raa. ");
INSERT INTO nuq_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip e haere no takutaku ake na tiputipu te Mesaia raa i na tama te matakaina Samaria raa. ");
INSERT INTO nuq_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Te kanohenua raa e hakallono hakaraoi roo na tattara Filip e tattara raa, tena na tama raa e hakallono no kkite na mirakol te tama raa e ppena raa. ");
INSERT INTO nuq_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tammaki na tipua e ttani na varo laatou no huro i taha, tena tammaki na tama na vae e mmate ia ma na tama ni se lavaa te hahaere hakaraoi raa ku taualleka. ");
INSERT INTO nuq_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tena te matakaina raa hakaatoa ku hihhia roo. ");
INSERT INTO nuq_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","He tama te inoa aia raa ko Saimon e noho i te kina raa, tena na paanamu aia raa e mee na tama i Samaria raa no mamannatu tammaki. Tama raa e mee ma aia he tama hakanaaniu, ");
INSERT INTO nuq_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","tena na tama hakaatoa i roto te matakaina e rahi raa, na tama mouruna ia ma na tama mouraro raa ku hakallono roo tama raa. Na tama raa e mee ma, “Saimon e isi na mahi tera taatou e kanna ma, ‘na Mahi roo Hakanaaniu raa’.” ");
INSERT INTO nuq_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Na tama raa e hakallono tama raa, e mee te saaita roroa roo tama raa e mee laatou no mattaku ma na paanamu aia raa. ");
INSERT INTO nuq_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Emeia te saaita laatou ni hakattina na tattara Filip i te vahi te Rono Tauareka i te Hakamaatua ana i te Vaelani ia ma Jisas Krais raa, tena na taanata ia ma na hhine raa ku too te hakoukou tapu. ");
INSERT INTO nuq_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon hoki ku hakatina, ia te saaita aia ku oti te too te hakoukou tapu raa, tama raa ku se haere no mmao i taha ma Filip, ia aia e mamaharo i na mirakol ia ma na mee taualleka Filip ni ppena raa. ");
INSERT INTO nuq_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Na aposol e nnoho i Jerusalem raa ku llono ma na tama i Samaria raa ku hakattina na tattara TeAtua raa, tena laatou ki kauna Pita laaua ma Jon ki oo i Samaria. ");
INSERT INTO nuq_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Tokorua raa e oo no ttae, tena laaua ki lotu ma na hakattina ana raa ma ki lavaa na tama raa te too TeAnana Tapu raa. ");
INSERT INTO nuq_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","E mee na tama raa se ki too TeAnana Tapu raa; na tama raa e too koi te hakoukou tapu i te inoa TeAriki Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kito Pita laaua ma Jon ki hakapiri na rima laaua raa i aruna na tama raa, tena TeAnana Tapu raa ku haere iho no tau i roto na tama raa. ");
INSERT INTO nuq_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimon e kite pera ma na hakattina ana raa ku too hoki TeAnana Tapu te saaita tokorua raa ni hakapiri na rima laaua raa i aruna na tama raa. Tena kito Saimon ki kou ake na sileni iaa Pita laaua ma Jon, ");
INSERT INTO nuq_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","tena ki meake, “Kou mai hoki na mahi naa iaa anau ki lavaa na tama anau e hakapiri na rima anau i aruna raa te too hoki TeAnana Tapu.” ");
INSERT INTO nuq_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kito Pita ki meake Saimon, “Haere ma na sileni akoe naa i te kina te ahi raa, akoe e maanatu ma akoe e lavaa te sui na hoki TeAtua raa ma na sileni! ");
INSERT INTO nuq_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Akoe se hai kina e hakappai, ia se hai i roto te uata nei, maitaname te hatu manava akoe raa se tonu i mua na karemata TeAtua. ");
INSERT INTO nuq_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Tena tike i taha ma te hakataakoto haeo akoe naa, tena akoe ku lotu ake TeAriki ki hai aroha akoe i na maanatu haeo akoe e isi raa. ");
INSERT INTO nuq_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","E mee anau e kite pera ma akoe e isi na hakataakoto haeo, tena ki noho pera ma he karapusi na hai sara.” ");
INSERT INTO nuq_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kito Saimon ki meake Pita laaua ma Jon, “Tena koorua ki alloha no lotu ake TeAriki ma anau ki se lavaa he mee na mee koorua e tattara raa e kapihi mai anau.” ");
INSERT INTO nuq_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pita laaua ma Jon ku tattara ake na tattara i te vahi TeAtua ni tokonaki laaua raa, tena ki takutaku ake na tattara TeAriki raa no oti roo, tena laaua ki vakkai i Jerusalem. Tokorua raa e takutaku ake hoki te Rono Tauareka raa i roto tammaki na matakaina i Samaria te saaita laaua ni vakkai raa. ");
INSERT INTO nuq_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Te ensel TeAtua raa ku tattara ake Filip ma, “Tanattana no haere peeraa i te kupu; i te mateara e kaamata i Jerusalem raa no haere peeraa i Gasa.” (Te mateara nei ku seai te aho nei.) ");
INSERT INTO nuq_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","28 Tena kito Filip ki tanattana no haere. Tena he tanata Itiopia, he tama hakamaatua i te vahi na sileni te tuku hine Itiopia raa ku vaakai te matakaina aia raa. Tama raa ni haere i Jerusalem no lotu ake TeAtua, tena aia e vaakai i roto te vaka hai wiri aia raa. Aia e tere, tena e paupau hakamaroa hoki te launiu profet Aisaia raa. ");
INSERT INTO nuq_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","TeAnana Tapu raa ku meake Filip ma, “Haere atu i te kina te vaka raa, tena akoe ku haere hakataapiri atu te vaka naa.” ");
INSERT INTO nuq_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Kito Filip ki tere atu i te kina te vaka raa, tena aia ku rono te tama raa e paupau te launiu profet Aisaia raa. Kito aia ki vahiri ake te tama raa, “Akoe e iroa hea akoe e paupau naa?” ");
INSERT INTO nuq_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tena te tama hakamaatua raa ki meake, “Anau e me ki iroa peehee kame se hai tama e tattara hakamatahua mai anau?” Tena aia ki meake Filip ki kake ake i aruna no noho i te vahi aia. ");
INSERT INTO nuq_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Teenei te kina aia e paupau i roto te Launiu Tapu raa, “Tama raa e ssau pera ma he sipsip na tama e hakattaki ma ki taa ki mate, ia e ssau hoki pera ma he punua sipsip e tuu hemuu te saaita na tama raa e ohe na huruhuru Aia raa. Aia se hai tattara roo e hopo te maihu Aia raa. ");
INSERT INTO nuq_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Na tama raa e hakanapa Tama raa, tena se hai tama e tuu ma ki tokonaki Tama raa. Se hai tama e iroa te hakatere iho i te vahi na tipuna Tama raa, e mee te ora Aia i roto te maarama nei raa ku hamai te hakaotioti.” ");
INSERT INTO nuq_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tena te tama hakamaatua raa ki meake Filip, “Mee mai, te profet nei e tattara aii? Aia e tattara aia hokoia, ma aia e tattara i teeraa tama?” ");
INSERT INTO nuq_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tena Filip ki kaamata no tattara ake, kaamata na tattara te Launiu Tapu raa, tena ki tattara ake te tama raa i te Rono Tauareka i te vahi Jisas raa. ");
INSERT INTO nuq_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Na tama raa e huro tauttari te mateara raa no ttiri te kina e isi na vai raa, tena te tama hakamaatua raa ki meake, “Kira ake na vai raa. Hea e ppui anau ki se too te hakoukou tapu naa?” ");
INSERT INTO nuq_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Kito Filip ki meake te tama raa, “Akoe e me ki hakoukou tapu ria kame akoe e hakatina hakamaoni ma te hatu manava akoe.” Kito tama raa ki meake, “Anau e hakatina. Anau e hakatina pera ma Jisas Krais ko te Tamariki TeAtua.” ");
INSERT INTO nuq_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tena te tama hakamaatua raa ki meake na tama raa ki hakamau te vaka raa, tena laaua ma Filip ki ttiho no oo i te kina te vai raa, kito Filip ki hakoukou tapu tama raa. ");
INSERT INTO nuq_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tokorua raa ku oo mai i taha ma te vai raa, tena TeAnana Tapu raa ku too Filip i taha. Te tama hakamaatua raa ku se kite hoki Filip, tena aia ku hihia roo no kake te vaka aia raa no tere. ");
INSERT INTO nuq_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip e oho koi aia ku tae i Asdot, tena aia ki haere i Sisaria no takutaku ake te Rono Tauareka raa i na matakaina roo hakaatoa. ");
INSERT INTO nuq_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Te saaita naa Sol e hai na mahi aia ma ki taa na tama tauttari Jisas raa ki mmate, te hakataakoto haeo nei e mee roo na tama raa no mattaku. Sol e haere i te pohouru hakanaaniu na maatua raa ");
INSERT INTO nuq_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","no meake ma ki kou ake ni launiu ki kkave i na hare lotu na Jiu i Damaskus raa pera ma kame aia e kite na tama e tauttari na Tiputipu TeAriki raa, tena aia ku hakapiki na tama raa hakaatoa; na taanata ia ma na hhine raa no kou ake i Jerusalem. ");
INSERT INTO nuq_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sol ku taapiri i te matakaina Damaskus, tena te saaita naa koi he maahina e hamai i te vaelani ku maahina hakatike aia. ");
INSERT INTO nuq_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sol ku teiho i raro, tena aia ku rono te reo e tattara ake aia ma, “Sol, Sol! Aiea akoe e mee Anau ki hakalono llihu naea?” ");
INSERT INTO nuq_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Kito Sol ki vahiri ake ma, “TeAriki, koai Akoe?” Tena te reo raa ki meake, “Anau ko Jisas te Tama akoe e kou ake na hakalono llihu raa. ");
INSERT INTO nuq_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Emeia, ttuu i aruna no haere i te matakaina raa, tena he tama e me ki tattara atu akoe hea akoe e me ki ppena raa.” ");
INSERT INTO nuq_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Na tama ni oo laatou ma Sol raa ku ttuu hemuu se hai tama roo e tattara; na tama raa e llono te reo raa, e meia laatou se kkite te tama raa. ");
INSERT INTO nuq_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol ku mahike no tuu i aruna, tena ki taaraki na karemata aia, e meia aia ku se hai mee e kite. Kito na tama raa ki taohi na rima tama raa no hakattaki i Damaskus. ");
INSERT INTO nuq_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","I roto e toru na aho, Sol se hai mee roo e kite, tena te saaita naa hoki aia ku se kai, ia ku se unu. ");
INSERT INTO nuq_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tena he tama e hakatina Jisas e noho i Damaskus te inoa aia raa ko Ananaias. Aia e kite karemata roo ma TeAriki e kanna ake aia ma, “Ananaias!” Kito aia ki meake, “TeAriki, teenei anau.” ");
INSERT INTO nuq_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Tena TeAriki ki meake Ananaias, “Tanattana no haere i te Mateara e Tonu raa, tena i te hare Judas raa akoe ku vahiri ma teehee te tama i Tarsus te inoa aia raa ko Sol. Tama naa e lotu vahao nei, ");
INSERT INTO nuq_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","tena aia e kite karemata hoki ma he tama, te inoa aia raa ko Ananaias e haere ake no hakapiri na rima aia raa i aruna aia ma ki lavaa aia te kite hakaraoi.” ");
INSERT INTO nuq_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Kito Ananaias ki meake, “TeAriki, tammaki na tama e tattara mai anau na tiputipu te tama naa ia ma na mee aia e ppena i na tama Akoe i roto Jerusalem raa. ");
INSERT INTO nuq_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Tena Sol e hamai i Damaskus ma na tattara na maatua hakananniu raa ma ki hakapiki na tama e lotulotu Akoe raa.” ");
INSERT INTO nuq_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Tena TeAriki ki meake Ananaias, “Haere, maitaname Anau e hirihiri Sol ki hehekau ma Anau ki akoako na tama seai ma ni Jiu raa, na tuku ia ma na tama Israel raa ki illoa i te inoa Anau. ");
INSERT INTO nuq_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Tena Anau Hokonnau e me ki huri ake tama naa na hakalono llihu hakaatoa aia e me ki too te saaita aia e tattara i te vahi Anau raa.” ");
INSERT INTO nuq_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kito Ananaias ki haere no tae i te hare Sol e noho raa, tena ki hakapiri na rima aia raa i aruna tama raa. Tena aia ki meake, “Sol, taku taina, TeAriki e kauna ria mai anau, Jisas Hokoia te Tama ni tuu atu akoe i te mateara te saaita akoe ni hamai i te matakaina nei raa e kauna ria mai anau ki lavaa akoe te kite hakaraoi, tena TeAnana Tapu ku tau i roto akoe.” ");
INSERT INTO nuq_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Te saaita naa koi he mee e ssau pera ma na unahi na ika raa ku tteiho i taha ma na karemata Sol, tena aia ku lavaa te kite hakaraoi. Sol ku mahike no tuu i aruna, tena Ananaias ki hakoukou tapu aia. ");
INSERT INTO nuq_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Tena i muri te saaita aia ku oti te kai, Sol ku mataora hakaraoi. Sol e nnoho hakamarie se llava hoki na aho ma na hakattina ana i Damaskus raa. ");
INSERT INTO nuq_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tena aia ki haere tahi roo i te hare lotu na Jiu raa, tena ki kaamata no takutaku ake pera ma Jisas ko te Tamariki TeAtua. ");
INSERT INTO nuq_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Na tama hakaatoa e llono na tattara Pol raa ku oho roo no vahihhiri ma, “Teenei seai ma ko te tama e taa na tama e lotulotu Jisas i roto Jerusalem? Tena aia ni mee raa se hamai i te kina nei ma te hakataakoto ki hakapiki na hakattina ana raa, tena ku too na tama raa no kkave i na maatua hakananniu raa?” ");
INSERT INTO nuq_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Emeia na takutaku Sol raa ku oo roo no hai mmahi, tena na tattara aia ma Jisas ko te Mesaia raa e matahua roo, tena na Jiu e nnoho i Damaskus raa ku se lavaa te sui muri ake na tattara tama raa. ");
INSERT INTO nuq_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Tammaki na aho ku llaka, tena na Jiu raa ku hakkutu hakaatoa no tattara ma ki taa Sol ki mate, ");
INSERT INTO nuq_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","e meia e isi na tama e hakari ake Sol te hakataakoto na Jiu raa. Te ao ma te poo na Jiu raa ku lollohi na totoka te matakaina raa ma ki taa tama raa ki mate. ");
INSERT INTO nuq_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Tena he poo hokotahi na tama e tauttari Sol raa ku hakatere iho Sol i raro i te vahi te tauppaa raa i roto te kete e rahi. ");
INSERT INTO nuq_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol ku haere no tae i Jerusalem, tena ki hahaivi ma ki hukui ma na disaipol Jisas raa. Emeia na tama raa se hakattina ma Sol he disaipol, tena laatou e mattaku hoki tama raa. ");
INSERT INTO nuq_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kito Banabas ki haere ake no tokonaki Sol, tena ki too te tama raa no kkave i na aposol raa. Tama raa e tattara hakamatahua ake na tama raa pera ma Sol e kite TeAriki i aruna te mateara, tena TeAriki e tattara ake tama raa. Banabas e tattara ake hoki na mahi Sol ni takutaku i te inoa Jisas i roto Damaskus raa. ");
INSERT INTO nuq_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kito Sol ki nnoho ma na tama raa, tena ki haere na kina hakaatoa i roto Jerusalem raa no takutaku ma na mahi i te inoa TeAriki. ");
INSERT INTO nuq_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sol e tattara, tena ki hakataukoti hoki ma na Jiu tera e illoa na tattara ha Grik raa, tena na tama raa ku hahaivi ma ki taa tama raa ki mate. ");
INSERT INTO nuq_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Te saaita na hakattina ana raa ni llono te mee nei, na tama raa ku too Sol no kkave i Sisaria, tena ki kauna tama raa no haere i Tarsus. ");
INSERT INTO nuq_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Te saaita naa na hare lotu hakaatoa i roto Judia, Galili ia ma Samaria raa ku nnoho taravare roo. E mee TeAnana Tapu raa ku tokonaki na hare lotu raa, tena na hakattina ana raa ku oo no tammaki roo, ia e lotulotu tahi ake hoki TeAriki. ");
INSERT INTO nuq_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita e haere hakatike na matakaina hakaatoa, tena he saaita hokotahi aia ku haere no mmata na tama e hakattina TeAtua e nnoho i Lida raa. ");
INSERT INTO nuq_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tena aia e ttiri te tama hokotahi te inoa aia raa ko Ainias. Na vae tama raa e mmate, tena i roto e varu na hetau Ainias se lavaa te mahike i taha ma te moena aia e moemoe raa. ");
INSERT INTO nuq_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Tena Pita ki meake tama raa, “Ainias, Jisas Krais e mee akoe no tauareka. Tuu i aruna no hhatu te moena akoe e moemoe naa.” Te saaita naa koi Ainias ku mahike no tuu i aruna. ");
INSERT INTO nuq_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Na tama hakaatoa e nnoho i Lida ia ma Saron raa ku kkite tama raa no hakattina i TeAtua. ");
INSERT INTO nuq_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","E isi te hine e noho i Jopa te inoa aia raa ko Tabita, tena aia he tama e hakatina. (Te inoa aia ha Grik raa ko Dokas.) Aia e ppena tahi na mee taualleka, tena ki tokonaki hoki na tama e tuttuu haeo raa. ");
INSERT INTO nuq_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Te saaita naa hoki Dokas ku laavea no mate. Na tama raa e hakoukou te tinotama tama raa, tena ki kkave no hakamoe i te rum i aruna raa. ");
INSERT INTO nuq_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ia Jopa se mmao hoki i taha ma Lida, tena te saaita na hakattina ana raa ni llono ma Pita e noho i Lida, na tama raa ku kauna tokorua na tama ki oo no meake Pita ma, “Akoe ki aroha koi no hamai vave roo.” ");
INSERT INTO nuq_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kito Pita ki tanattana no oo laatou ma na tama raa. Pita ku tae atu, tena na tama raa ki too aia no kkave i te rum i aruna raa, tena na tautukaha hhine raa hakaatoa e tanittani no muimui ake Pita, tena ki huri ake na kaukahu ia ma na kaukahu mattoru Dokas ni ttui te saaita aia koi ora raa. ");
INSERT INTO nuq_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Kito Pita ki hakaise na tama raa hakaatoa i aho, tena ki tuturi i raro no lotu, tena aia ki huri no meake te tinotama raa, “Tabita, mahike i aruna.” Tena Dokas ki taaraki na karemata aia raa, tena te saaita koi aia ni kite Pita raa, aia ku mahike no noho i aruna. ");
INSERT INTO nuq_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Tena Pita ki haaro atu no tokonaki tama raa no hakamahike i aruna. Kito Pita ki kanna ake na hakattina ana raa hakaatoa hakapaa ma na tautukaha hhine raa, tena Pita ki kou ake Dokas te tama ku ora hakaraoi raa i na tama raa. ");
INSERT INTO nuq_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Te rono nei ku ttoha i na kina hakaatoa i roto Jopa, tena tammaki na tama ku hakattina i TeAriki. ");
INSERT INTO nuq_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita e noho i Jopa tammaki na aho ma Saimon, te tama e hehekau no tanattana na kiri na manu raa ki pena alaa mee hoki. ");
INSERT INTO nuq_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","He tama e noho i Sisaria te inoa aia raa ko Kornilius, tena aia ko te soldia hakamaatua te kautana na soldia na tama raa e kanna ma, “Na Soldia Itali raa.” ");
INSERT INTO nuq_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kornilius he hakattina ana, tena aia ma na hareakina aia raa hakaatoa e lotulotu TeAtua. Aia e ppena hoki tammaki na mee ki tokonaki na Jiu tera e tuttuu haeo raa, ia e lotu tahi hoki TeAtua. ");
INSERT INTO nuq_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","He aho hokotahi te mee raa kame ku tae te toru te hiahi, tena Kornilius e kite karemata pera ma aia e miti raa, tena aia e kite roo te ensel TeAtua raa e haere ake i hare no kanna ake ma, “Kornilius!” ");
INSERT INTO nuq_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kito Kornilius ki kkira hakamattonu ake roo te ensel raa ma te mataku, tena aia ki meake, “TeAriki, hea?” Tena te ensel raa ki meake, “TeAtua e hihia roo na lotu ia ma na uata taualleka akoe raa, tena Aia e tanattana ki kou atu hea akoe e hihai. ");
INSERT INTO nuq_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Tena kauna he tama te saaita nei ki haere i Jopa no mmate te tama te inoa aia raa ko Saimon Pita. ");
INSERT INTO nuq_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tama raa e nnoho laaua ma Saimon te tama e hehekau no tanattana na kiri na manu tera e noho taapiri te lottai raa.” ");
INSERT INTO nuq_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Te ensel raa ku haere i taha, kito Kornilius ki kanna ake e rua na tama hehekau i roto te hare aia raa ia ma te soldia. Te soldia nei he tama hoki e ppena na tiputipu TeAtua e hihai raa, tena na vahao hakaatoa aia e nniti tahi roo ma Kornilius. ");
INSERT INTO nuq_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kornilius e tattara ake na tama raa hea aia ni kite raa, tena aia ki kauna na tama raa ki oo i Jopa. ");
INSERT INTO nuq_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Te mee raa kame ku tae te laa latea te aho taiao raa, tena tokotoru raa ku oo atu no tappiri i Jopa, ia te saaita naa hoki Pita ku kake i aruna te tauhuhu te hare raa ma ki lotu. ");
INSERT INTO nuq_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pita ku hikai, tena aia ku hihai roo ma ki kai he mee. Na tama i te hare raa e tanattana na kai, tena Pita e kite karemata pera ma aia e miti. ");
INSERT INTO nuq_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Pita e kite te vaelani raa ku taaraki, tena he mee e ssau pera ma he paamaro e rahi e ttaohi ria na mata e haa raa ku hamai i raro i te maarama nei. ");
INSERT INTO nuq_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Tena tammaki roo na manu hahaere, na manu tottoro ia ma na manu lellee kai ttama e mmoe i aruna te mee raa. ");
INSERT INTO nuq_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tena te saaita naa koi te reo raa ku tattara ake Pita ma, “Pita, mahike i aruna no taa he manu no kai.” ");
INSERT INTO nuq_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Kito Pita ki meake, “TeAriki! Anau se hai vahao roo e kai na manu e matakkere tera se tau te tama te kai. E hai nattaa roo anau te mee peenaa!” ");
INSERT INTO nuq_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Tena te reo raa ku tattara hakaraoi ake hoki iaa Pita ma, “Auu se mee ma na mee raa e matakkere te saaita TeAtua ku oti te mee ma na mee raa e matahua.” ");
INSERT INTO nuq_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Te mee nei e kapihi mai anau e toru na vahao, tena ki oti te mee raa ku vaakai muri i te vaelani. ");
INSERT INTO nuq_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita koi mamaanatu koi te hakataakoto te mee raa, tena te saaita naa hoki na tama Kornilius ni kauna ria ake raa ku illoa hoki te kina te hare Saimon raa e tuu, tena na tama raa ku oo ake no ttuu i mua te totoka te hare raa. ");
INSERT INTO nuq_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Kito na tama raa ki kanna ake i hare no vahiri ake ma, “E isi te tama e nnoho ma kootou te inoa aia raa ko Saimon Pita?” ");
INSERT INTO nuq_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita koi mamaanatu koi ma ki iroa aia te hakataakoto te mee raa, tena TeAnana Tapu raa ki meake ma, “E toru na tama e oo mai no mmata akoe.” ");
INSERT INTO nuq_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ia tanattana no tiho i raro, tena auu se kkaro te oo ma na tama naa, e mee Anau e kauna ria mai na tama naa. ");
INSERT INTO nuq_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Kito Pita ki tiho i raro no meake na tama raa ma, “Anau ko te tama kootou e sesee. Kootou e oo mai noaa?” ");
INSERT INTO nuq_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Kito na tama raa ki meake, “Kornilius, te tama hakamaatua maatou raa e kauna ria mai maatou ki oo mai. Aia he tama tauareka tera e lotu tahi TeAtua, tena na Jiu raa hakaatoa e hakammaha roo tama raa. Te ensel TeAtua raa e meake tama raa ki aru mai akoe ki haere ake i te hare aia raa, ki rono aia ma ni tattara peehee akoe e me ki tattara ake aia raa.” ");
INSERT INTO nuq_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Kito Pita ki meake na tama raa ki oo ake i hare, tena ki meake na tama raa ki nnoho te poo naa i te hare raa. Te aho taiao raa aia ku tanattana no oo ma na tama raa, tena e isi na hakattina ana i Jopa e oo hoki laatou. ");
INSERT INTO nuq_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Teeraa aho roo Pita ku tae i Sisaria, tena Kornilius hakapaa hoki ma na llave ana aia raa ia ma na soa laoi aia ni meake ki oo ake raa e nnoho no hakattari Pita. ");
INSERT INTO nuq_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Te saaita Pita ku taapiri ki uru i hare, Kornilius ku hamai no ttiri tama raa, tena ki teiho i raro no tuturi i mua Pita. ");
INSERT INTO nuq_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Emeia Pita e hakamahike tama raa, tena ki meake, “Tuu i aruna, anau he tama koi peenaa ma akoe naa.” ");
INSERT INTO nuq_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita e haere tattara ake Kornilius te saaita laaua ni oo i roto hare no kkite tammaki roo na tama e hakkutu. ");
INSERT INTO nuq_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kito Pita ki meake na tama raa, “Kootou hokkootou e illoa roo pera ma na Jiu i te vahi na tuaa laatou raa se lavaa te hakapaa ma na tama seai ma ni Jiu raa. Emeia TeAtua e huri mai anau pera ma anau se lavaa te hakataakoto ma e isi na tama se matahua ia ma e hai sara. ");
INSERT INTO nuq_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Tena te saaita kootou ni aru mai anau raa, anau e hamai koi se isi hoki te maanatu. Ia tena anau e me ki vahiri atu kootou ma kootou ni aru mai anau kiaa?” ");
INSERT INTO nuq_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Tena Kornilius ki meake, “E toru na aho ku llaka te hiahi te saaita peenei, anau e lotu i roto te hare anau raa. Te saaita naa koi he tama e uru na hekau e kivakiva ku tuu mai i mua anau, ");
INSERT INTO nuq_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","tena ki mee mai, ‘Kornilius! TeAtua ku rono te lotu akoe raa, tena e kite hoki te tokonaki akoe na tama hakaalloha raa. ");
INSERT INTO nuq_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kauna ria he tama ki haere i Jopa no mmata te tama te inoa aia raa ko Saimon Pita. Te tama naa e noho i te hare Saimon te tama e hehekau no tanattana na kiri na manu e noho taapiri te lottai raa.’ ");
INSERT INTO nuq_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Tena anau se nnahe hoki te aru atu akoe ki hamai, ia tena akoe e tauareka roo no hamai. Tena maatou hakaatoa e hakkutu i te kina nei i na mahi TeAtua no hakattari ki hakallono ma ni tattara peehee TeAtua e kou atu akoe ki tattara mai maatou.” ");
INSERT INTO nuq_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kito Pita ki kaamata no tattara ake ma, “Te saaita nei anau ku iroa te hakamaoni pera ma te laoi TeAtua e huri ake na tama roo hakaatoa raa e ssau koi. ");
INSERT INTO nuq_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","TeAtua e hihai na tama na henua hakaatoa tera e lotulotu Aia raa, tena ki ppena na mee e ttonu, niaina ma laatou e ttipu peehee. ");
INSERT INTO nuq_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Kootou e illoa na tattara Aia ni kou atu kootou na tama Israel raa. Aia e takutaku atu na tattara te Rono Tauareka te noho laoi raa i na mahi Jisas Krais, TeAriki taatou hakaatoa raa. ");
INSERT INTO nuq_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kootou e illoa na mee e llahi ni kapihi mai i roto Israel raa hakaatoa, kaamata mai i Galili, i muri Jon ni takutaku atu na tattara i te vahi te hakoukou tapu raa. ");
INSERT INTO nuq_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Kootou e illoa TeAtua e hakatapu Jisas Krais te Tama i Nasaret raa ma TeAnana Tapu ia ma na mahi. TeAtua e noho ma Tama raa, tena Aia e haere na kina roo hakaatoa no haere ppena na mee taualleka, tena ki tokonaki na tama hakaatoa e nnoho i raro na mahi Satan raa. ");
INSERT INTO nuq_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Maatou ko na tama e kkite karemata roo na mee hakaatoa tera Jisas ni ppena i roto Israel ia ma Jerusalem raa. Tena ki oti na tama raa ki ttii Tama raa i aruna te kros no mate. ");
INSERT INTO nuq_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Emeia i muri e toru na aho, TeAtua ku hakamahike Tama raa i taha ma te mate, tena Tama raa ki tuu mai maatou. ");
INSERT INTO nuq_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Tama raa se tuu ake na tama hakaatoa, e meia Tama raa e tuu ake na tama TeAtua ko na hirihiri mai avare raa, teenaa ko maatou na tama e kkai, ia e unu ma Tama raa te saaita Aia ni mahike muri no ora raa. ");
INSERT INTO nuq_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Tena Aia e tattara mai maatou ma ki takutaku ake te Rono Tauareka raa i na kanohenua, tena ku tattara hakamatahua ake pera ma Aia ko te Tama TeAtua e tini ki hakatonutonu na tama e ora ia ma na tama ku mmate raa. ");
INSERT INTO nuq_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Na profet hakaatoa ni tattara i te vahi Tama raa, na tama raa e tattara ma na hai sara na tama hakaatoa e hakattina Tama raa e me ki ssorohia i taha i na mahi te inoa Tama raa.” ");
INSERT INTO nuq_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita koi tattara koi, tena TeAnana Tapu raa ku haere iho no tau i roto na tama hakaatoa tera e hakallono aia e tattara raa. ");
INSERT INTO nuq_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Na hakattina ana na Jiu ni oo mai ma Pita i Jopa raa ku mahharo roo, e mee TeAtua e kou ake te hoki TeAnana Tapu raa i na tama seai ma ni Jiu raa hoki. ");
INSERT INTO nuq_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","E mee laatou ku llono na tama raa e hakammaha ake TeAtua i na tattara alaa henua. Tena Pita ki meake, ");
INSERT INTO nuq_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Na tama nei ku too TeAnana Tapu raa pera ma taatou ni too raa hoki. Kaa koai hoki e lavaa te ppui na tama nei ki se hakoukou tapu ria ma te vai?” ");
INSERT INTO nuq_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Kito Pita ki meake ma na tama raa ki too te hakoukou tapu i te inoa Jisas Krais. Tena na tama raa ki kainno ake Pita ki noho e llava na aho ma laatou. ");
INSERT INTO nuq_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Na aposol Jisas raa ma alaa hakattina ana i roto Judia ku llono ma na tama seai ma ni Jiu raa ku too hoki na tattara TeAtua raa. ");
INSERT INTO nuq_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pita ku haere i Jerusalem, tena na tama e hihhai ma na tama seai ma ni Jiu ki ttuu te hakamaatino e tapu raa ku tattara sosomei ake Pita ma, ");
INSERT INTO nuq_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Akoe e noho i roto na hare na tama seai ma ni Jiu se isi te hakamaatino TeAtua raa, tena akoe e kkai hoki ma na tama raa.” ");
INSERT INTO nuq_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kito Pita ki kaamata ake roo te kaamata no tattara ake na tama raa na mee roo hakaatoa ni kapihi ake raa: ");
INSERT INTO nuq_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Te saaita anau ni lotu i te matakaina Jopa, anau e isi te kite anau. Anau e kite karemata roo te mee e ssau pera ma he paamaro e ttaohi ria na mata e haa raa e hakatere iho i raro i taha ma te vaelani. Tena te mee raa e hamai no hakamau i te vahi koi anau. ");
INSERT INTO nuq_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Anau e mmata hakaraoi roo i roto no kite na manu e ttara, na manu kai ttama, na manu tottoro ia ma na manu lellee kai ttama raa. ");
INSERT INTO nuq_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tena anau ku rono te reo e tattara mai anau ma, ‘Pita, mahike i aruna no taa he manu no kai!’ ");
INSERT INTO nuq_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Kito anau ki meake, ‘TeAriki, e hai nattaa roo anau te mee peenaa. Anau se hai vahao roo e kai te manu se matahua tera se tau te tama te kai.’ ");
INSERT INTO nuq_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Tena te reo raa ku tattara mai hakaraoi hoki i te vaelani ma, ‘Auu se mee ma na mee raa se matahua te saaita TeAtua ku oti te mee ma na mee raa e matahua.’ ");
INSERT INTO nuq_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Te mee nei e kapihi mai e toru na vahao, tena ki oti te mee raa ku vaakai i te vaelani. ");
INSERT INTO nuq_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Te saaita naa koi e toru na tama ni oo mai i Sisaria no mmata anau raa ku ttae mai i te hare anau e noho raa. ");
INSERT INTO nuq_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","TeAnana Tapu e mee mai ma anau ki se kkaro no oo maatou. E ono na hakattina ana i Jopa e oo maatou i Sisaria, tena maatou hakaatoa e oo no ttae i te hare Kornilius. ");
INSERT INTO nuq_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Tena Kornilius ku tattara mai maatou i te kite aia te ensel e tuu ake i roto te hare aia raa no tattara ake ma, ‘Kauna ria he tama ki haere i Jopa no mmata te tama te inoa aia roo ko Saimon Pita. ");
INSERT INTO nuq_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Te tama naa e me ki tattara atu na tattara tera e me ki tokonaki te hareakina akoe raa hakaatoa ki ora.’ ");
INSERT INTO nuq_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Anau e kaamata no tattara, tena TeAnana Tapu raa ku haere iho no tau i roto na tama raa e ssau koi pera ma TeAnana Tapu raa ni hamai no tau i roto taatou i te kaamata roo. ");
INSERT INTO nuq_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tena anau ku maanatu na tattara TeAriki ni tattara mai ma, ‘Jon e hakoukou tapu ma te vai, e meia kootou e me ki hakoukou tapu ria ma TeAnana Tapu.’ ");
INSERT INTO nuq_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Tena ku matahua pera ma TeAtua e kou ake na tama seai ma ni Jiu raa te hoki hokotahi nei koi tera Aia ni kou mai taatou te saaita taatou ni hakattina i TeAriki Jisas Krais raa. Tena kaa ni mahi peehee anau e isi ki ppui TeAtua!” ");
INSERT INTO nuq_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Te saaita koi na tama raa ni llono na tattara nei, na tama raa ku hakaoti na tattara sosomei laatou, tena ki hakammaha ake TeAtua ma, “TeAtua ku kou ake hoki na tama seai ma ni Jiu raa te tonu ki ttike i taha na hai sara raa laatou raa ki lavaa laatou te ora.” ");
INSERT INTO nuq_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Na hakattina ana ni maaseu te saaita te hakalono llihu ni kapihi ake te saaita Stiven ni taia ria no mate raa ku oo no ttae i Fonisia, Saiprus ia ma Antiok no takutaku ake na Jiu raa koi. ");
INSERT INTO nuq_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Emeia alaa hakattina ana, na tama i Saiprus laaua ma Sairini raa ku oo no takutaku ake te Rono Tauareka TeAriki Jisas raa i na tama seai ma ni Jiu i roto Antiok raa. ");
INSERT INTO nuq_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Na tama raa e nnoho hoki ma na mahi TeAtua, tena tammaki roo na tama ku hakattina no tauttari TeAriki. ");
INSERT INTO nuq_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Te rono nei ku ttoha no tae te lotu i Jerusalem raa, kito na tama raa ki kauna ria Banabas ki haere i Antiok. ");
INSERT INTO nuq_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Te saaita Banabas ni tae no kite ma TeAtua e hakatapu hai mahi roo na tama raa, aia ku hihia roo, tena ki meake na tama raa hakaatoa ki hakattina hakamaoni TeAriki ma na hatu manava laatou. ");
INSERT INTO nuq_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas he tama tauareka, ia he tama e hakatina hoki, tena TeAnana Tapu raa e tau i roto tama raa, tena tammaki na tama ku hakattina TeAtua. ");
INSERT INTO nuq_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kito Banabas ki haere i Tarsus no mmata Sol. ");
INSERT INTO nuq_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Aia ku ttiri Sol, tena aia ki too tama raa no kkave i Antiok. Tena te hetau naa hakaatoa tokorua raa e ttiri ma na hakattina ana raa, tena ki akoako ake te kuturana e rahi roo. Teenaa ko i roto Antiok tera na hakattina ana raa ku kanna ria kaamata roo ma na Tama te Lotu. ");
INSERT INTO nuq_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Te saaita naa ho