﻿USE sofia;
DROP TABLE IF EXISTS sofia.num_vpl;
CREATE TABLE num_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES num_vpl WRITE;
INSERT INTO num_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ko te tohi hohoko 'eni 'o Sīsū Kalaisi, 'a ia ko te hako 'o Tēvita, ko te hako 'o 'Ēpalahame. ");
INSERT INTO num_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ko te hako 'o 'Ēpalahame 'ia 'Aisake; pea ko te hako 'o 'Aisake 'ia Sēkope; pea ko te hako 'o Sēkope 'ia Siuta mo tono 'ū tokouá; ");
INSERT INTO num_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","pea ko te hako 'o Siuta 'ia Felesi mo Sala, 'a ia ko te nā fa'eé ko Tema; pea ko te hako 'o Felesi 'ia 'Esilome; pea ko te hako 'o 'Esilome 'ia 'Ālame; ");
INSERT INTO num_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","pea ko te hako 'o 'Ālame 'ia 'Aminatape; pea ko te hako 'o 'Aminatape 'ia Nāsoni; pea ko te hako 'o Nāsoni 'ia Salemone; ");
INSERT INTO num_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","pea ko te hako 'o Salemone 'ia Poasi, 'a ia ko tana fa'eé ko Lēhapi; pea ko te hako 'o Poasi 'ia 'Ōpeti, 'a ia ko tana fa'eé ko Lute; pea ko te hako 'o 'Ōpeti 'ia Sese; ");
INSERT INTO num_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","pea ko te hako 'o Sese 'ia Tēvita ko te tu'i. Pea ko te hako 'o Tēvita 'ia Solomone, 'a ia ko tana fa'eé 'ia te fafine ne'e nonofo mo Ulaiá; ");
INSERT INTO num_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","pea ko te hako 'o Solomone 'ia Lehopoame; pea ko te hako 'o Lehopoame 'ia 'Āpaia; pea ko te hako 'o 'Āpaia 'ia 'Asa; ");
INSERT INTO num_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","pea ko te hako 'o 'Asa 'ia Sihosafate; pea ko te hako 'o Sihosafate 'ia Siolame; pea ko te hako 'o Siolame 'ia 'Ūsaia; ");
INSERT INTO num_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","pea ko te hako 'o 'Ūsaia 'ia Siotame; pea ko te hako 'o Siotame 'ia 'Āhasi; pea ko te hako 'o 'Āhasi 'ia Hesekaia; ");
INSERT INTO num_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","pea ko te hako 'o Hesekaia 'ia Manase; pea ko te hako 'o Manase 'ia 'Āmone; pea ko te hako 'o 'Āmone 'ia Siosaia; ");
INSERT INTO num_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","pea ko te hako 'o Siosaia 'ia Sekonaia mo tono kāingá — ko te kuonga ia 'o te fetukutuku ki Pāpiloné. ");
INSERT INTO num_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pea 'i te 'osi tono fetukutuku 'o nātou ki Pāpiloné ne'e 'i ai te hako 'o Sekonaia, ko Saletili; pea ko te hako 'o Saletili 'ia Seluipepeli; ");
INSERT INTO num_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","pea ko te hako 'o Seluipepeli 'ia 'Āpaiuta; pea ko te hako 'o 'Āpaiuta 'ia 'Ilaiakimi; pea ko te hako 'o 'Ilaiakimi 'ia 'Ēsoa; ");
INSERT INTO num_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","pea ko te hako 'o 'Ēsoa 'ia Sētoki; pea ko te hako 'o Sētoki 'ia 'Akemi; pea ko te hako 'o 'Akemi 'ia 'Elaiuti; ");
INSERT INTO num_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","pea ko te hako 'o 'Elaiuti 'ia 'Eliesa; pea ko te hako 'o 'Eliesa 'ia Mātani; pea ko te hako 'o Mātani 'ia Sēkope; ");
INSERT INTO num_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","pea ko te hako 'o Sēkope 'ia Siosifa, 'a ia ko te 'unoho ia 'o Mele ko te fa'ē 'a Sīsū, 'ā ē 'oku ui ko Kalaisí. ");
INSERT INTO num_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ko ia ko te lau 'o te 'ū to'utangatá meiā 'Ēpalahame kiā Tēvitá ko te to'utangata 'e hongofulu mā fā; pea meiā Tēvita ki te fetukutuku ki Pāpiloné ko te to'utangata 'e hongofulu mā fā; pea mei te fetukutuku ki Pāpiloné 'o a'u kiā Kalaisí ko te to'utangata 'e hongofulu mā fā. ");
INSERT INTO num_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ko te anga 'eni tono 'alo'i 'o Sīsū Kalaisí. Kua polo'i tana fa'eé ko Mele kiā Siosifa, kā 'i te he'iki ai ke nā nonofó, ne'e hā mai kua tu'itu'ina ia 'i te Laumālie Mā'oni'oní. ");
INSERT INTO num_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Pea ko Siosifa tono hoá, ko te tangata anga-tonu, pea ne'e kailoa loto 'e ia ke fakahaa'i ia, ko ia ai ne ina pehē ke tukuange fakafufuu'i pē 'ona. ");
INSERT INTO num_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kae lolotonga ta'aná fakakaukau pehē, ne'e hā kiā ia 'e te 'āngelo 'a te 'Alikí 'i te misi, 'o pehē ange, “'E Siosifa, hako 'o Tēvita, 'aua 'e manahē ke 'aumai 'ia Mele ko tou 'unoho; he ko Ia kua tu'itu'ina aí 'oku mei te Laumālie Mā'oni'oní. ");
INSERT INTO num_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Pea 'e 'alo'i ia he Tama, pea 'e ke fakahingoa Ia ko Sīsū; he 'e fakama'uli 'e Ia Tono kakaí mei te notou 'ū angahalá.” ");
INSERT INTO num_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Pea ne fai 'eni kotoa pē kote'uhí ke fakamo'oni ki te me'a ne folafola 'aki 'e te 'Alikí 'i te palōfitá, ");
INSERT INTO num_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","'o pehē, “Vakai, 'e tu'itu'ina te tāupo'oú, pea 'e ina 'alo'i he Tama, pea 'e notou fakahingoa 'Ona ko 'Imānuela, ko tono 'uhingá, 'oku 'iā tātou 'ia te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pea kua 'ala ake 'ia Siosifa mei tana moé, pea fai 'e ia 'o hangē ko te fekau 'a te 'āngelo 'a te 'Alikí kiā iá, 'o 'aumai 'ia Mele ko tono 'unoho, ");
INSERT INTO num_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","pea ne'e kailoa nā fe'iloaki kae'aua ke 'alo'i 'ia te Tamá; pea ne'e fakahingoa 'e ia 'Ona ko Sīsū. ");
INSERT INTO num_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Pea kua 'alo'i 'ia Sīsū 'i Pētelihema 'i Siutea, 'i te kuonga 'o te tu'i ko Hēlotá, pea vakai, ne'e ōmai ki Selusalema he kau maki mei te hahaké, ");
INSERT INTO num_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","'o notou 'eke ange, “Ko fea Ia kua 'alo'i ko te Tu'i 'o te kakai Siú? He kua motou mamata 'i Hahake ki Tono fetu'ú, pea kua motou ōmai 'eni ke hū kiā Ia.” ");
INSERT INTO num_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pea 'i te fanongo ki ai 'e te tu'i ko Hēlotá, ne'e puputu'u ia, fakataha mo Selusalema fuli pē. ");
INSERT INTO num_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Pea hanga 'e ia 'o fakataha'i te kau taula'aliki lahí kotoa pē, mo te kau sikalaipé, 'o 'eke ange kiā nātou pē kua 'alo'i 'i fea 'ia te Kalaisí. ");
INSERT INTO num_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Pea notou tali ange kiā ia, “'I Pētelihema 'i Siutea; he kua pehē tono tohi 'e te palōfitá, ");
INSERT INTO num_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Pea ko koe, Pētelihema, 'i te fanua 'o Siutá, 'oku kailoa 'aupito ko te si'i taha 'ia koe 'i te hau'aliki 'o Siutá; kote'uhí 'e ha'u meiā koe he Takimu'a, 'a ia 'e Ina pule'i Toku kakai 'Isilelí.’ ” ");
INSERT INTO num_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pea toki 'aumai fakafufū 'e Hēlota 'ia te kau Makí, 'o 'eke fakapapau kiā nātou ki te taimi ne'e hā mai ai te fetu'ú. ");
INSERT INTO num_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pea fekau 'e ia 'ia nātou ki Pētelihema, mo iange, “Kotou ō 'o 'eke fakatotolo ki te Tamasi'í; pea kā kotou 'ilo'i Ia pea kotou tala'i mai, kote'uhí ke au 'alu atu foki mo au 'o hū kiā Ia.” ");
INSERT INTO num_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pea kua notou ō mo te fekau 'a te tu'í, pea vakai, ko te fetu'ú, 'ā ē ne'e notou mamata ki ai 'i Hahaké, ne'e mu'amu'a 'iā nātou 'o a'u ki te feitu'u ne'e 'i ai te Tamasi'í, 'o tu'u 'i ai mei lunga. ");
INSERT INTO num_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Pea 'i te notou sisio ki te fetu'ú, ne'e notou fiafia lahi 'aupito. ");
INSERT INTO num_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pea 'i te notou hū ki te falé, ne'e notou mamata ki te Tamasi'í, 'oku 'i Tana fa'eé ko Mele; pea notou tū'ulutui ifo leva 'o hū kiā Ia. Pea kua notou vete ake te notou 'ū koloá, 'o notou 'avatu ki Ai 'ia te 'ū me'a'ofa, ko te koula mo te laipeno mo te mula. ");
INSERT INTO num_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pea 'i te valokia nātou 'e te 'Atuá 'i te misi, ke 'aua 'e notou toe foki kiā Hēlotá, ne notou foki leva ki te notou fanuá 'i te ala kehe. ");
INSERT INTO num_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pea 'i te notou ō atú, vakai, ne'e hā kiā Siosifa he 'āngelo 'a te 'Alikí 'i te misi, 'o iange, “'Ala ake, 'o to'o te Tamasi'í mo Tana fa'eé, pea holataki'i nāua ki 'Isipite, pea kotou nonofo 'i ai kae'aua ke au toki fakahaa'i atu; he 'e kumi 'e Hēlota 'ia te Tamasi'í ke fakapoongi.” ");
INSERT INTO num_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Pea 'ala ake leva ia, 'o to'o te Tamasi'í mo Tana fa'eé 'i te pō ko iá, 'o notou ō ki 'Isipite; ");
INSERT INTO num_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","pea ne'e notou nonofo 'i ai 'o a'u ki te pekia 'a Hēlotá, kote'uhí ke fakamo'oni ki te me'a ne'e folafola 'aki 'e te 'Alikí 'i te palōfitá, 'o pehē, “Kua U ui mai Toku Fohá mei 'Isipite.” ");
INSERT INTO num_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pea 'i te 'ilo'i 'e Hēlota kua va'inga'aki 'ona 'e te kau Makí, ne fu'u 'ita lahi 'aupito ia; 'o fekau ke tāmate'i 'ia te tamaliki tangata kotoa pē 'i Pētelihema mo te 'ū feitu'u ofi atu ki aí, 'o ngata meiā nātou ne'e ta'u uá 'o faai ki muli, 'o fakatatau ki te me'a ne'e iange 'e te kau Makí. ");
INSERT INTO num_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Pea ne'e toki fakamo'oni ai ki te me'a ne lea 'aki 'e te palōfita ko Selemaiá, 'o pehē, ");
INSERT INTO num_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ne'e ongo mei Lama he le'o, ko te tangi mo te fu'u tangilāulau; ko te tēngihia 'e Lesieli tana fānaú, pea 'e kailoa ina tali he fakafiamālie, kote'uhí he kua notou mole nātou ia.” ");
INSERT INTO num_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pea kua pekia 'ia Hēlota, pea vakai, ne'e hā mai te 'āngelo 'a te 'Alikí kiā Siosifa 'i te misi 'i 'Isipite, ");
INSERT INTO num_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","'o iange, “'Ala ake, pea to'o te Tamasi'í mo Tana fa'eé, pea 'alu ki te fanua 'o 'Isilelí; he kua mate 'ia nātou ne'e kumi ki te Tamasi'í ke fakapoongí.” ");
INSERT INTO num_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Pea tu'u ake ia, 'o to'o 'ia te Tamasi'í mo Tana fa'eé, pea notou ō atu ki te fanua 'o 'Isilelí. ");
INSERT INTO num_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kā 'i tana fanongo 'oku pule 'ia 'Akileosi 'i Siutea, ko te fetongi 'o tana tamai ko Hēlotá, ne ina manahē ke 'alu ki ai. Pea ne'e valokia 'ona 'e te 'Atuá 'i te misi, 'o ina afe ai ki te vāhenga 'o Kālelí. ");
INSERT INTO num_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Pea ha'u ia 'o nofo 'i te kolo ko Nāsaleti; kote'uhí ke fakamo'oni ki te me'a ne'e lea 'aki 'e te kau palōfitá, 'o pehē, “'E ui Ia ko he Nāsaleti.” ");
INSERT INTO num_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","'I te 'ū 'aho ko iá ne'e ha'u 'ia Sione Papitaiso, 'o malanga 'i te toafa 'o Siuteá, ");
INSERT INTO num_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","'o pehē, “Kotou fakatomala, he kua ofi te Pule'anga 'o Hēvaní.” ");
INSERT INTO num_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","He ko 'eni ia ne'e lea ki ai 'e te palōfita ko 'Aiseá, 'o pehē, “Ko te le'o 'o he toko taha 'oku kalanga 'i te toafá, ‘Kotou teuteu te hā'ele'anga 'o te 'Alikí; fakatonutonu Tono 'ū alá.’ ” ");
INSERT INTO num_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Pea ko te kofu 'o Sioné ne'e ngaahi ia mei te fulufulu'i kāmeli, pea fakama'u leta tono kongalotó; pea ko tana me'akaí ko te he'e mo te huhua'i honi vao. ");
INSERT INTO num_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Pea ne'e toki ō atu kiā ia 'ia Selusalema, mo Siutea fuli pē, mo te feitu'u kotoa 'o Sioataní, ");
INSERT INTO num_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","pea notou papitaiso 'iā ia 'i te vaitafe ko Sioataní, 'i te vete te notou 'ū angahalá. ");
INSERT INTO num_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kā 'i tana vakai atu ki te tokolahi 'o te kau Fālesí mo te Sātusi 'oku notou ōmai ki te papitaisó, ne ina lea ange kiā nātou, “'Ia te hako'i ngata fekai, ko ai ne ina fale'i kōtou ke hola mei te houhau 'e ha'ú? ");
INSERT INTO num_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pea kāpau ko ia, pe'i kotou fua 'o taau mo te fakatomala. ");
INSERT INTO num_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Pea 'aua 'e kotou pehē 'i te kotou lotó, ‘Ko 'Ēpalahame te motou tamaí;’ he 'okou tala'i atu, 'oku mafai 'e te 'Atuá ke fokotu'u mei te 'ū fe'i maka nei he fānau kiā 'Ēpalahame. ");
INSERT INTO num_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Pea ko 'eni, kua tu'u te tokí 'i te tafito 'o te 'ū 'akaú; ko ia, ko te 'akau kotoa pē 'oku kailoa fua lelei, 'oku tā ia 'o laku ki te afí. ");
INSERT INTO num_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ko aú 'okou papitaiso vai 'ia kōtou ki te fakatomalá, kā ko Ia 'oku mulimuli maí 'oku mālohi Ia 'iā au, pea 'oku kailoa kita taau ke to'o Tono senitoló; 'e papitaiso 'e Ia 'ia kōtou 'aki te Laumālie Mā'oni'oní mo te afi. ");
INSERT INTO num_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Pea 'oku 'i Tono nimá 'ia te me'a tata uite, pea 'e Ina sivi 'aki ke ma'a Tono haha'angá, 'o tānaki tono uité ki te faleokó, kā 'e tutu te kafukafú 'aki te afi 'oku kailoa lava to'onó tāmate'i.” ");
INSERT INTO num_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Pea toki ha'u 'ia Sīsū mei Kāleli ki Sioatani kiā Sione ke papitaiso 'iā ia. ");
INSERT INTO num_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kā ne hanga 'e Sione ia 'o teke'i 'Ona, 'o pehē ange, “Ne'e tonu ange ke papitaiso 'oku 'iā Koe, kā kua Ke ha'u koā Koe kiā au?” ");
INSERT INTO num_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pea tali ange 'e Sīsū 'o pehē, “Tukuange pē ke fai 'eni, he 'oku taau pē mo tāua ke fakakakato 'ia te tu'utu'uni kotoa pē.” Pea ne'e toki tukuange leva ke fai ia. ");
INSERT INTO num_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Pea kua papitaiso 'ia Sīsū, pea 'alu ake leva Ia mei te vaí; pea 'ohovale pē, kua fakaava ifo te langí kiā Ia, pea mamata Ia ki te Laumālie 'o te 'Atuá 'oku 'alu ifo 'i te tatau 'o he lupe, 'o a'u mai kiā Ia. ");
INSERT INTO num_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Pea 'ohovale pē kua ongo mai he le'o mei te langí 'o pehē, “Ko Toku 'Alo Pelé 'ena, 'a ia 'Okou hōifua 'i Aí.” ");
INSERT INTO num_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pea ne'e tataki 'ia Sīsū 'e te Laumālié ki te toafá ke 'ahi'ahi'i ai 'Ona 'e te tēvoló. ");
INSERT INTO num_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Pea kua 'osi Tana 'aukai 'i te 'aho 'e fāngofulu mo te pō 'e fāngofulu, pea toki fiakaia Ia. ");
INSERT INTO num_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Pea ha'u te toko taha fakatauvelé, 'o lea kiā Ia, “Kāpau ko te 'Alo Koe 'o te 'Atuá, fekau ki te 'ū fe'i maka nei ke liliu ko te 'ū fe'i mā.” ");
INSERT INTO num_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ka ne'e tali ange 'e Ia 'o pehē, “Kua tohi, ‘'E kailoa ma'uli te tangatá 'i te maá pē, kā 'i te 'ū Folafola kotoa pē 'oku ha'u mei te fofonga 'o te 'Atuá.’ ” ");
INSERT INTO num_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pea hanga 'e te tēvoló 'o 'ave 'Ona ki te Kolo Tapú, 'o fokotu'u Ia ki te tumu'aki 'o te Temipalé, ");
INSERT INTO num_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","'o pehē ange kiā Ia, “Kāpau ko te 'Alo Koe 'o te 'Atuá, hopo ki lalo; he kua tohi, ‘'E Ina kouna Tana kau 'āngeló talia Koe; pea 'e notou hapahapai 'Ou, na'a tūkia Tou va'é 'i te maká.’ ” ");
INSERT INTO num_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Pea tali ange 'e Sīsū kiā ia, “Kua tohi foki, ‘'Aua 'e ke 'ahi'ahi'i te 'Alikí ko tou 'Atuá.’ ” ");
INSERT INTO num_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pea toe 'avake 'Ona 'e te tēvoló ki te ma'unga mā'olunga 'aupito, 'o faka'ali'ali ki Ai 'ia te 'ū pule'anga kotoa pē 'o māmani mo te notou nāunaú; ");
INSERT INTO num_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","'o iange kiā Ia, “Ko te 'ū me'a kotoa pē ko 'ení 'e au 'avatu kiā Koe, 'o kāpau 'e Ke punou 'o hū kiā au.” ");
INSERT INTO num_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pea toki iange 'e Sīsū, “Sētane, fei mo 'alu! He kua tohi, ‘Ko te 'Aliki ko tou 'Atuá 'e ke lotu kiā Ia, pea ko Ia pē Toko Taha 'e ke tauhi ki Aí.’ ” ");
INSERT INTO num_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pea toki tukuange 'Ona 'e te tēvoló; pea vakai, ne'e ha'u te kau 'āngeló 'o tauhi kiā Ia. ");
INSERT INTO num_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Pea 'i te fanongo 'e Sīsū kua tuku 'ia Sione ki te pilīsoné, ne'e 'alu Ia ki Kāleli. ");
INSERT INTO num_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pea ne'e hiki Ia mei Nāsaletí, 'o 'alu 'o nofo 'i Kāpaneume, 'a ia 'oku tu'u 'i te matātaí, 'i te ngata'anga 'o Sepulone mo Nafitalaí, ");
INSERT INTO num_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","kote'uhí ke fakamo'oni ki te me'a ne lea 'aki 'e te palōfita ko 'Aiseá, 'o pehē, ");
INSERT INTO num_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ko te fanua 'o Sepuloné, mo te fanua 'o Nafitalaí, 'i te feitu'u 'oku hanga ki taí, 'i Tu'a-Sioatani, ko Kāleli 'o te Senitailé; ");
INSERT INTO num_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ko te kakai ne'e nonofo 'i te pō'ulí ne'e notou mamata ki te maama lahi; pea ko te nofo 'i te fanua tonu mo te malumalu 'o te maté ne hopo ake he maama kiā nātou.” ");
INSERT INTO num_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mei te taimi ko iá ne'e kamata 'e Sīsū ke malanga, 'o pehē, “Kotou fakatomala, he kua ofi 'ia te Pule'anga 'o Hēvaní.” ");
INSERT INTO num_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Pea 'i Tana 'eva'eva 'i te matātai 'o te Tai 'o Kālelí, ne vakai atu 'e Ia ki te ongo tautēhina, ko Saimone 'oku ui ko Pitá, pea mo 'Anitelū ko tono tehiná, 'oku nā sili, he ko te ongo tautai. ");
INSERT INTO num_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Pea pehē ange 'e Ia kiā nāua, “Kulā mulimuli 'iā Au, pea 'e Au ngaahi 'ia kōlua ko te ongo tautai tangata.” ");
INSERT INTO num_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Pea nā si'aki leva te nā kupengá, 'o mulimuli kiā Ia. ");
INSERT INTO num_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Pea 'alu atu Ia mei ai, pea mamata 'e Ia ki te ongo tautēhina kehe, ko Sēmisi ko te foha 'o Sēpeti, mo Sione ko tono tehiná, 'oku notou 'i te vaká mo Sēpeti ko te nā tamaí, 'oku fai te notou pena kupenga. Pea ui ange 'e Ia 'ia nāua. ");
INSERT INTO num_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Pea nā tukuange leva te vaká mo te nā tamaí, 'o mulimuli kiā Ia. ");
INSERT INTO num_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Pea ne'e 'alu holo 'ia Sīsū 'i Kāleli fuli pē, 'o faiako 'i te notou 'ū falelotú, mo malanga 'aki te ongoongolelei 'o te Pule'angá; pea neongo pe ko te ā he fa'ahinga mahaki ne'e 'i te kakaí, ne Ina fakama'uli 'ia nātou. ");
INSERT INTO num_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Pea mafola atu Tono ongoongó ki Sīlia kātoa; pea ne'e notou 'aumai kiā Ia 'ia te kakai kotoa pē ne puké, 'ia nātou ne ma'ua 'i te 'ū mahaki kehekehe pe faingata'a'ina, 'ia nātou ne'e 'ulusino ai 'ia te fanga tēvolo mo te mahaki moa mo te mamatea, pea ne Ina fakama'uli 'ia nātou fuli pē. ");
INSERT INTO num_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Pea ne'e mulimuli kiā Ia he fu'u kakai tokolahi 'aupito mei Kāleli, mo Tikapolusi, mo Selusalema, mo Siutea, pea mo te kauvai 'e taha 'o Sioataní. ");
INSERT INTO num_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Pea 'i Tana sio ki te fu'u kakaí, ne'e 'alu ake Ia ki te ma'ungá, pea 'i Tana nofo ifó ne'e 'u'unu atu kiā Ia Tana kau akó; ");
INSERT INTO num_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","pea ko 'eni Tana 'ū akonaki ne'e fai kiā nātoú: ");
INSERT INTO num_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“'Oku manū'ia 'ia nātou 'oku ongo'i masiva 'i te notou laumālié, he 'oku 'o nātou 'ia te Pule'anga 'o Hēvaní. ");
INSERT INTO num_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","'Oku manū'ia 'ia nātou 'oku mamahí, he 'e notou ma'u 'ia te fiamālié. ");
INSERT INTO num_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","'Oku manū'ia 'ia nātou 'oku anga-maluú, he 'e tō mo'o nātou 'ia te fanuá. ");
INSERT INTO num_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","'Oku manū'ia 'ia nātou 'oku fiakai mo fiainu ki te mā'oni'oní, he 'e fakamākona 'ia nātou. ");
INSERT INTO num_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","'Oku manū'ia 'ia nātou 'oku manava'ofá, he 'e fai manava'ofa kiā nātou. ");
INSERT INTO num_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","'Oku manū'ia 'ia nātou 'oku ma'a te notou lotó, he 'e notou mamata ki te 'Atuá. ");
INSERT INTO num_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","'Oku manū'ia 'ia nātou 'oku fakatupu melinó, he 'e ui 'ia nātou ko te fānau 'a te 'Atuá. ");
INSERT INTO num_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","'Oku manū'ia 'ia nātou 'oku fakatanga'i kote'uhí ko te mā'oni'oní, he 'oku 'o nātou 'ia te Pule'anga 'o Hēvaní. ");
INSERT INTO num_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","'Oku manū'ia 'ia kōtou, 'o kā manukia, mo fakatanga'i, mo lohi'ekina 'i te kovi kehekehe, kote'uhí ko Au. ");
INSERT INTO num_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kotou fiafia mo hākailangitau, he 'e lahi te kotou totongí 'i hēvani; he ne'e pehē te notou fakatanga'i 'ia te kau palōfitá, 'a ē ne mu'amu'a 'iā kōtoú. ");
INSERT INTO num_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ko kōtoú ko te māsima 'o te fanuá; pea kā mole mei te māsimá tono koná, 'e toe fakakonakona te māsimá 'aki 'ia te ā? 'Oku kala kei 'aonga ia ki he me'a, kā ko te laku pē ki tu'a ke tāmalaki 'e te kakaí. ");
INSERT INTO num_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ko kōtoú ko te maama 'o māmani; ko te kolo 'oku tu'u 'i te funga ma'unga 'oku kailoa ina lava ke puli. ");
INSERT INTO num_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Pea 'oku kala tutu he maama 'o fa'o ki te puha, kā ki te tu'unga maamá pē, pea 'oku ulo atu ia kiā nātou fuli pē 'oku 'i te falé. ");
INSERT INTO num_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Pehē foki, ke ulo atu te kotou maamá ke hā ki te kakaí, ke notou mamata ki te kotou 'ū ngāue leleí, pea fakamālō'ina te kotou Tamai 'oku 'i hēvaní. ");
INSERT INTO num_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“'Aua 'e kotou mahalo kua U ha'ú ke fakata'e'aonga'i 'ia te Laó, pe ko te Tohi Palōfitá; ne'e kala Kita ha'ú ke fakata'e'aonga'i, kā ke fakakakato. ");
INSERT INTO num_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","He 'Okou tala mo'oni atu kiā kōtou, lolotonga 'oku he'iki ai mole 'ia te langí mo māmani, 'e kala mole mei te Laó he fe'i mata'itohi pē he fe'i kohi 'e taha, kae'aua ke fakahoko kotoa pē. ");
INSERT INTO num_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ko ia ai, kā 'i ai he taha 'e tāmate'i he taha 'o te 'ū tu'utu'uni nei 'oku si'isi'í, mo ako'i pehē ki te kakaí, 'e lau ia ko te si'isi'i 'i te Pule'anga 'o Hēvaní; kā ko ia 'e fai ki ai mo ako 'akí, 'e lau ia ko te lahi 'i te Pule'anga 'o Hēvaní. ");
INSERT INTO num_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","He 'Okou tala'i atu kiā kōtou, kāpau 'e kala lahi ake te kotou mā'oni'oní 'i te mā'oni'oni 'a te kau sikalaipé mo te kau Fālesí, 'e kailoa 'aupito kotou hū ki te Pule'anga 'o Hēvaní. ");
INSERT INTO num_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kua kotou fanongo ne folafola 'aki ki te mātu'á 'i mu'a, 'o pehē, ‘'Aua 'e ke fakapō; pea ko ia ko 'ē 'e fakapoó, 'e 'ave 'ona ki te fakamaaú.’ ");
INSERT INTO num_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kā 'Okou tala'i atu kiā kōtou 'e Au, ko ia ko 'ē 'e 'ita ki tono kāingá, 'e 'ave 'ona ki te fakamaaú; pea ko ia ko 'ē 'e pehē ki tono kāingá, ‘Siana vale,’ 'e fakamāu'i ia 'i te Sanetalimí; kā ko ia ko 'ē 'e pehē, ‘Siana fakasesele,’ 'e fakamāumatea ia pea tutu 'i te afi 'o helí. ");
INSERT INTO num_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ko ia, kā kua ke ha'u mo koe he feilaulau ki te 'ōlitá, 'o ke toki manatu'i ai kua 'i ai te me'a 'oku kovi'ina ai tou kāingá kiā koe, ");
INSERT INTO num_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tuku pē hena tau feilaulaú 'i te 'āfaki 'ōlitá, kā ke 'alu 'ia koe 'o fakalelei mo tou kāingá, pea ke toki ha'u 'o 'avatu tau feilaulaú. ");
INSERT INTO num_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Fakalelei leva ke vave mo tou filí, lolotonga te kulā fononga 'i te alá mo iá, na'a tukuange 'ou 'e tou filí ki te fakamaaú; pea 'avatu 'e te fakamaaú ki te 'ōfisá pea sī ai 'ou ki te pilīsoné. ");
INSERT INTO num_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","'Okou tala mo'oni atu kiā koe, 'e kala ke 'alu mei ai kae'aua ke 'osi tau totongí 'o a'u ki te toenga sēniti. ");
INSERT INTO num_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Kua kotou fanongo ne folafola 'aki, ‘'Aua 'e ke tono fafine.’ ");
INSERT INTO num_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kā 'Okou tala kiā kotou 'e Au, ko ia ko 'ē 'e fakasio he fafine ke tafunaki ta'aná holi kiā ia, kua ina tono'i ia 'i tono lotó. ");
INSERT INTO num_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ko ia kāpau ko tou mata to'omata'ú 'oku fakatūkia'i 'oú, kape'i ia 'o si'aki; he 'oku sai ange kiā koe ke mole tou kupu pē 'e tahá, 'i tono sī tou sinó kakato ki heli. ");
INSERT INTO num_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Pea neongo ko tou nima to'omata'ú 'oku fakatūkia'i 'oú, tu'usi ia 'o si'aki; he 'oku sai ange kiā koe ke mole hau kupu pē 'e taha, 'i te sī tou sinó kakato ki heli. ");
INSERT INTO num_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ne folafola 'aki foki 'o pehē, ‘Kā 'i ai he taha 'e si'aki tono malí, ke 'avange ia ki ai he tohi vete.’ ");
INSERT INTO num_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kā 'Okou tala'i atu kiā kōtou, ko ia ko 'ē kua si'aki tono malí, kae kailoa 'i tana faihala mo he taha, 'oku tukuange 'e ia 'ona ke tonoa; pea ko te tangata 'e mali mo ia kua si'akí, 'oku tono fafine ia. ");
INSERT INTO num_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kua kotou fanongo foki, ne'e folafola 'aki ki te mātu'á 'i mu'a, ‘'Aua 'e ke fuakava lohi, kā ke fai ki te 'Alikí tau 'ū fuakavá.’ ");
INSERT INTO num_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kā 'Okou tala'i atu kiā kotou 'e Au, 'aua 'aupito 'e ke fuakava. 'Aua 'e lea ki te langí, he ko te taloni ia 'o te 'Atuá; ");
INSERT INTO num_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","pe ki te fanuá, he ko Tono tu'unga va'e; pe ki Selusalema, he ko te kolo ia 'o te Tu'i Fakalevalevá. ");
INSERT INTO num_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","'Aua 'e fuakava ki tou 'ulú, he 'oku kala ke mafai ki tono liliu 'o he lau'i'ulu 'e taha ke hinahina pe 'uli'uli. ");
INSERT INTO num_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kā 'i te kotou aleá, ke 'io pē te kotou 'ió; mo kailoa pē te kotou kailoá. He kā 'i ai leva ho'oná fakalahi, 'oku mei te Filí ia. ");
INSERT INTO num_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Kua kotou fanongo ne'e folafola 'aki 'o pehē, ‘Ke totongi 'aki te fe'i mata he fe'i mata, mo te fe'i nifo 'aki he fe'i nifo.’ ");
INSERT INTO num_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kā 'Okou tala'i atu kiā kotou, 'aua 'e sāuni he kovi 'oku fai mai kiā koe; kae kāpau 'e sipi'i he taha tou kau'ahe mata'ú, hanga atu koe, 'o fulihi ki ai tou kau'ahe hemá. ");
INSERT INTO num_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pea kā loto he taha ke kulā hopo, pea ke ma'u 'e ia tou soté, 'avange kiā ia mo tou pulupulú. ");
INSERT INTO num_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Pea kā fakafatongia'i 'ou he taha ke 'ave 'ona 'i te maile 'e taha, 'alu mo ia ke maile ua. ");
INSERT INTO num_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kā kole atu he taha kiā koe, pea tali; pea kā loto he taha ke nō meiā koe, 'aua 'e ke sītu'a mei ai. ");
INSERT INTO num_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Kua kotou fanongo ne folafola 'aki 'o pehē, ‘'E ke 'ofa ki tou kaungā'apí, kae fihi'a ki tou filí.’ ");
INSERT INTO num_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kā 'Okou tala'i atu kiā kōtou, kotou 'ofa'i te kotou 'ū filí, pea hūfia 'ia nātou 'oku fakatanga'i kōtoú. ");
INSERT INTO num_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kote'uhí ke kotou taau mo te fānau 'a te kotou Tamai 'oku 'i hēvaní; he 'oku fakaulo 'e Ia Tana la'aá ki te anga-koví mo te anga-leleí, pea 'oku faka'ua Ia ki te faitotonú mo te faihalá. ");
INSERT INTO num_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","He kāpau 'e kotou 'ofa'i 'ia natou pē 'oku 'ofa maí, ko te ā he totongi 'e kotou ma'u? 'Oku kala koā fai pehē mo te kau tānaki tukuhaú? ");
INSERT INTO num_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Pea kāpau 'oku kotou fetapa ki te kotou kāingá pē, ko te ā he me'a 'oku kotou fai 'oku hulu atu? 'Oku kailoa koā fai 'e te Senitailé foki 'ia te me'a ko iá? ");
INSERT INTO num_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kae kotou haohaoa pē 'ia kōtou; 'o hangē foki ko te haohaoa 'ia te kotou Tamai 'oku 'i hēvaní. ");
INSERT INTO num_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Vakai ke 'aua 'e fai te kotou tō'onga fakalotú ke hā ki te kakaí, kote'uhí ke notou siofia 'ia kōtou; he kā pehē, 'oku kailoa leva 'i ai he kotou totongi mei te kotou Tamai 'oku 'i hēvaní. ");
INSERT INTO num_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ko ia ai, kā fai hau foaki, 'aua 'e ke ifi he me'alea ke fakahaa'i 'ou, 'o hangē ko te fai 'e te kau mālualohi 'i te falelotú mo te alá, kote'uhí ke notou ma'u te fakamālō 'a te kakaí. 'Okou tala mo'oni atu kiā kōtou, ko tono ngata ia te notou totongi kua notou ma'ú. ");
INSERT INTO num_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kā ko koe, kā fai leva hau foaki, ke 'aua 'e 'ilo'i 'e tou nima hemá 'ia te me'a 'oku fai 'e tou nima mata'ú, ");
INSERT INTO num_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","kote'uhí ke lilo pē tau foakí; pea ko tau Tamaí, 'a ē 'oku 'afio 'i te liló, 'e totongi 'e Ia kiā koe. ");
INSERT INTO num_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Pea kā kotou lotu, 'aua 'e kotou hangē ko te kau mālualohí; he 'oku notou manako ke tu'u 'i te falelotú mo te tuliki 'o te 'ū alá ke fai te notou lotú, kote'uhí ke notou hā ki te kakaí. 'Okou tala mo'oni atu kiā kōtou, ko tono ngata ia te notou totongi kua notou ma'ú. ");
INSERT INTO num_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kā ko koe, kā ke lotu, hū ki tou lokí, pea tāpuni'i tou matapaá, pea fai tau hū ki tau Tamaí, 'ā ē 'oku 'afio 'i te liló; pea ko tau Tamaí, 'a ē 'oku 'afio 'i te liló, 'e totongi 'e Ia kiā koe. ");
INSERT INTO num_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Pea kā kotou lotu leva, 'aua 'e kotou fefoki'aki mo launoa, hangē ko te hītení; he 'oku notou mahalo 'e ongo atu te notou me'á ko te lahi te notou laú. ");
INSERT INTO num_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ko ia, 'aua 'e kotou fa'ifa'itaki kiā nātou; he 'oku he'iki ai kotou kole kōtou iá, kua 'osi 'afio'i 'e te kōtou Tamaí 'ia te 'ū me'a 'oku kotou masiva aí. ");
INSERT INTO num_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ko ia 'e pehē leva te kōtou lotú: ‘Ko te motou Tamai 'oku 'i hēvani, ke tāpuhā Tou huafá, ");
INSERT INTO num_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ke hoko mai Tau pulé, ke fai Tou finangaló 'i māmani, hangē ko ia 'i te langí. ");
INSERT INTO num_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ke foaki mai 'i te 'aho nei he motou me'akai. ");
INSERT INTO num_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pea fakamolemole'i te motou 'ū angahalá; hangē ko te motou fakamolemole'i 'ia nātou ne fai angahala mai kiā mātoú. ");
INSERT INTO num_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Pea 'aua 'e fakahū 'ia mātou ki te 'ahi'ahi; kā Ke fakahaofi 'ia mātou mei te kovi.’ ");
INSERT INTO num_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","He kāpau 'e kotou fakamolemole'i te 'ū hala 'a te kakaí, 'e fakamolemole'i kōtou 'e te kotou Tamai Fakalangí; ");
INSERT INTO num_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","pea kā kailoa kotou fakamolemole'i te 'ū hala 'a te kakaí, pea 'e kailoa foki fakamolemole'i 'e te kotou Tamaí 'ia te 'ū hala 'a kōtoú. ");
INSERT INTO num_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Pea kā kotou 'aukai, 'aua 'e kotou mata mamahi, 'o hangē ko te kau mālualohí; he 'oku notou fakakehe'i te notou matá, kote'uhí ke notou hā ki te kakaí 'oku notou 'aukai. 'Okou tala mo'oni atu kiā kōtou, ko tono ngata ia te totongi 'oku notou ma'ú. ");
INSERT INTO num_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kā ko koe, kāpau 'e ke 'aukai, pani tou 'ulú mo fufulu tou matá, ");
INSERT INTO num_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kote'uhí ke 'aua 'e hā atu tau 'aukaí ki te kakaí, kā ki tau Tamaí pē, 'a ē 'oku 'afio 'i te fufuú. Pea ko tau Tamaí, 'a ē 'oku 'afio 'i te fufuú, 'e totongi 'e Ia kiā koe. ");
INSERT INTO num_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“'Aua 'e fa'olaki koloa ma'a kōtou 'i māmani; he ko te feitu'u ia 'oku keina ai 'e te ané mo te 'ume'umeá, pea haea 'e te kau kaiha'á 'o kaiha'asi. ");
INSERT INTO num_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kae fa'olaki koloa ma'a kōtou 'i hēvani, he ko te feitu'u ia 'oku kailoa keina ai 'e te ané mo te 'ume'umeá, pea 'oku kailoa haea 'e te kau kaiha'á 'o kaiha'asi. ");
INSERT INTO num_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","He ko te feitu'u 'oku 'i ai tau koloá, 'e 'i ai foki mo to'oú loto. ");
INSERT INTO num_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ko te māma'anga 'o te sinó ko te matá. Ko ia kāpau 'oku haohaoa te sio tou matá, 'e maama pē tou sinó kātoa. ");
INSERT INTO num_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kae kāpau 'e kovi tou matá, pea 'e fakapō'uli tou sinó kātoa. Ko ia kāpau kua fakapō'uli 'ia te maama 'oku 'iā koé, pea tā ko te pō'uli lahi mo'oni ia! ");
INSERT INTO num_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“'Oku kala lava he taha ke 'aliki 'aki he 'aliki 'e toko ua: he 'e fihi'a ia ki te taha kae 'ofa'i te taha; pē 'e piki ia ki te taha, kae ta'etoka'i te taha. 'Oku kailoa lava ke kotou 'aliki 'aki te 'Atuá mo te koloá fakatou'osi. ");
INSERT INTO num_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ko ia ai 'Okou tala'i atu kiā kōtou, 'aua 'e kotou hoha'a kote'uhí ko te kotou ma'ulí, he me'a 'e kotou kai pē he me'a 'e kotou inu; pehē foki te kotou sinó, ki te me'a 'e kotou 'ai ki aí. 'Oku kailoa koā lahi 'ia te ma'ulí 'i te me'akaí, mo te sinó 'i tono kofú? ");
INSERT INTO num_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Vakai angé ki te fanga manupuna 'o te 'ataá; he 'oku kala notou tūtuu'i pe tu'usi, pe fa'olaki 'i te faleoko. Kā 'oku fafanga 'ia nātou 'e te kotou Tamai Fakalangí. 'Oku kailoa koā kotou mahu'inga noa pē 'iā nātou? ");
INSERT INTO num_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Pea neongo ai te kotou lotoma'uá, kā ko ai ia 'iā kōtou 'e lava ke fakaloaloa si'i atu tana ma'ulí? ");
INSERT INTO num_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Pea ko te ā 'oku kotou hoha'a ai ki te kofú? Kotou sivi 'ia te 'ū lile 'o te kelekelé, pe kua fefe'aki te notou tupú: 'oku kala notou ngāue, pea 'oku kala notou filo, ");
INSERT INTO num_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kā 'Okou tala'i atu kiā kōtou, na'a mo Solomone, 'i tana 'ai tono nāunaú fuli pē, ne'e kailoa faka'ofa'ofa tatau tono teungá mo he taha 'o te 'ū lile ko 'ení. ");
INSERT INTO num_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Pea kāpau leva 'oku fakakofu'i pehē 'e te 'Atuá 'ia te mahuku 'o te kelekelé, 'ā ē 'oku 'i ai 'i te 'aho nei, kae tafu 'aki te 'ōvaní 'āpongipongi, huanoa 'ia kōtou, 'ia te kau tui vaivai! ");
INSERT INTO num_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ko ia, 'aua 'e kotou hoha'a, 'o kotou pehē, ‘Ko te ā 'e tou kai mo inu mo kofú? ");
INSERT INTO num_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","He ko te 'ū me'a ko iá 'oku tokanga ki ai 'e te Senitailé, pea 'oku mea'i 'e te kotou Tamai Fakalangí 'oku kotou masiva 'i te 'ū me'a ko iá. ");
INSERT INTO num_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kae kotou fu'aki kumi mu'a ki Tono pule'angá, mo te mā'oni'oni 'A'aná, pea 'e 'avatu mo ia foki 'ia te 'ū me'a ko iá fuli pē. ");
INSERT INTO num_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ko ia 'aua 'e kotou lotoma'ua kote'uhí ko te 'āpongipongí, he 'e ma'ua 'ia te 'āpongipongí 'i te me'a ko iá. 'Oku lahi pē ki te 'aho nei to'oná kovi. ");
INSERT INTO num_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“'Aua 'e kotou fakaanga, he 'e fakaanga'i 'ia kōtou. ");
INSERT INTO num_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","He ko te fakaanga 'oku kotou fakaanga 'akí ko ia pē 'e fakaanga'i 'aki 'ia kōtoú, pea ko te me'a-fua 'e kotou fua 'akí ko ia pē 'e fua 'aki 'ia kōtoú. ");
INSERT INTO num_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","He ko te ā 'oku ke tokanga ai ki te malamala'i 'akau 'i te mata 'o tou tokouá, kā ko te fu'u lalango 'i to'oú mata 'oku kala ke 'ilo'i? ");
INSERT INTO num_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Pea 'e ke lea fefe'aki ai ki tou tokouá, ‘'Ē, tuku ke au to'o mai te malamala'i 'akau mei tou matá,’ kae tā ko te fu'u lalango 'ena ia 'i to'oú mata? ");
INSERT INTO num_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","'Ia te mālualohi, fu'aki to'o mai te fu'u lalangó mei to'oú mata, pea 'e ke toki sio lelei ke to'o mai te malamala'i 'akau mei te mata 'o tou tokouá. ");
INSERT INTO num_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","'Aua 'e 'avange te 'ū me'a toputapú ki te fanga kulií, pea 'aua 'e laku te kotou 'ū mata'itofé ki te fanga puaká, na'a faifaí pea notou tāmalaki ia, pea notou foki mai 'o hahae 'ia kōtou. ");
INSERT INTO num_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kole, pea 'e 'avatu kiā kotou; kumi, pea 'e kotou 'ilo'i; tukituki, pea 'e to'o kiā kōtou. ");
INSERT INTO num_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","He ko ia fuli pē 'oku kolé, 'oku ma'u, pea ko ia 'oku kumí 'oku 'ilo'i, pea ko ia 'oku tukitukí 'e to'o kiā ia. ");
INSERT INTO num_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","He ko te tangata fea ia 'iā kōtou, kā kole ki ai tono fohá he fe'i mā, 'e 'avange koā 'e ia he fe'i maka? ");
INSERT INTO num_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Pea kā kole he mata'i ika, 'e 'avange koā ia he ngata? ");
INSERT INTO num_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pea kāpau ā kua kotou 'ilo'i ke foaki me'a'ofa lelei ki te kotou fānaú, neongo ko te fa'ahinga kovi 'ia kōtou, huanoa te kotou Tamai 'oku 'i hēvaní Tana foaki me'a lelei kiā nātou 'oku kole kiā Iá. ");
INSERT INTO num_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ko ia ko te me'a kotoa pē 'oku kotou loto ke fai 'e te kakaí kiā kōtoú, kotou fai pehē foki kiā nātou; he ko te Laó ia mo te Tohi Palōfitá. ");
INSERT INTO num_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Kotou hū 'i te matapā fāsi'í; he 'oku fālahi te matapaá, pea 'atā 'ia te ala, 'oku fakatau ki malá, pea tokolahi te kakai 'oku notou hū atu 'i aí; ");
INSERT INTO num_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","kae fāsi'i 'ia te matapā, pea 'efi'efi 'ia te ala, 'oku fakatau ki te ma'ulí; pea tokosi'i te kakai 'oku notou 'ilo'i iá. ");
INSERT INTO num_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Kotou lamalama 'ia te kau palōfita lohí, 'ia nātou 'oku ōmai kiā kōtou mo te kofu fakasipí, kā 'i lotó ko te fanga ulofi fekai. ");
INSERT INTO num_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ko te notou 'ū fuá 'e kotou 'ilo'i lelei ai 'ia nātou. He 'oku toli he kālepi mei te vao talatala, pe ko te fiki mei te talatala'āmoa? ");
INSERT INTO num_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Pehē, kā 'i ai he 'akau lelei 'oku fua lelei ia; kae kā 'i ai he 'akau tamaki 'oku fua kovi ia. ");
INSERT INTO num_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","'Oku kailoa lava te 'akau leleí ke fua kovi, pe ko te 'akau tamakí ke fua lelei. ");
INSERT INTO num_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kā 'i ai leva he fu'u 'akau 'oku kala fua lelei, 'oku taa'i ia 'o laku ki te afí. ");
INSERT INTO num_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ko ia ai ko te notou fuá 'e kotou 'ilo'i lelei ai 'ia nātoú. ");
INSERT INTO num_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“'E kala hū ki te Pule'anga 'o Hēvaní 'ia nātou fuli pē 'oku pehē mai kiā Au, ‘'Aliki, 'Aliki ē!’, kā ko nātou pē 'oku notou fai te finangalo 'o Taku Tamai 'oku 'i hēvaní. ");
INSERT INTO num_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ko te tokolahi 'e notou lea mai 'i te 'aho ko 'ē, 'o pehē, ‘'Aliki, 'Aliki, ne kala koā ko Tou huafá ne'e motou palōfisai aí? Pea ko Tou huafá ne'e motou kapusi tēvolo aí? Pea ko Tou huafá ne'e motou feia ai te 'ū mana lahi?’ ");
INSERT INTO num_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pea 'e Au toki vete kiā nātou Toku lotó, 'o pehē, ‘Ne kailoa 'aupito ke Au 'ilo'i 'ia kōtou; 'alu meiā Au, 'ia te kau maumau lao!’ ");
INSERT INTO num_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Pea ko 'eni, ko ia kotoa pē 'oku fanongo ki te 'ū tala nei 'A'akú mo fai ki aí, 'e Au fakatatau ia ki te tangata fakapotopoto, 'a ia ne ina langa tono falé 'i te funga maká. ");
INSERT INTO num_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pea ne'e tō te 'uá, pea tafe mai te vaitafé, pea angi te matangí, 'o notou fa'afa'aki ki te fale ko iá; ka ne'e kailoa holo, he ne'e langa ia 'i te funga maká. ");
INSERT INTO num_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kā ko ia kua fanongo ki te 'ū tala nei 'A'akú, kae kala fai ki aí, 'e fakatatau ia ki te tangata vale, 'a ia ne ina langa tono falé 'i te 'one'oné. ");
INSERT INTO num_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Pea ne tō te 'uá, pea tafe mai 'ia te vaitafé, pea angi mālohi mo te matangí, 'o notou tuki ki te fale ko iá, pea holo ia; pea ko te holo 'o te fale ko iá ko te holo lahi.” ");
INSERT INTO num_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pea 'i te faka'osi 'e Sīsū Tana 'ū tala neí, ne'e to'oa te loto 'o te kakaí 'i Tana 'ū akonakí, ");
INSERT INTO num_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","he ne'e ako'i 'e Ia 'ia nātou 'o ngali mo he pule, 'o kala hangē ko te notou kau sikalaipé. ");
INSERT INTO num_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Pea 'i Tana 'alu ifo mei te ma'ungá, ne mulimuli kiā Ia he fu'u kakai tokolahi. ");
INSERT INTO num_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Pea vakai, ne'e ha'u he tangata kilia 'o hū kiā Ia, 'o iange, “'Aliki, ka ne Ke loto ke fai, 'e Ke lava ke fakama'a 'oku.” ");
INSERT INTO num_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Pea mafao atu Ia Tono nimá 'o ala kiā ia, mo iange, “'Okou loto pē; ke ma'a 'ia koe.” Pea ne'e ma'a leva tono kiliá. ");
INSERT INTO num_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Pea pehē 'e Sīsū kiā ia, “Tokanga ke 'aua na'a ke tala'i te me'a nei ki he taha; kā ke 'alu pē 'o fakahaa'i 'ou ki te taula'alikí, pea 'avange 'ia te feilaulau ne'e tu'utu'uni 'e Mōsesé, ko te fakamo'oni kiā nātou.” ");
INSERT INTO num_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Pea 'i Tana a'u ki Kāpaneumé, ne ha'u kiā Ia he senituliō, 'o kole ange, ");
INSERT INTO num_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","'o pehē, “'Aliki, ko si'aku tamaio'alikí 'oku takoto 'i 'api, kua puke 'i te mamateá, pea 'oku faingata'a'ina 'aupito.” ");
INSERT INTO num_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Pea iange 'e Sīsū ki ai, “'E Au 'alu atu 'o fakama'uli ia.” ");
INSERT INTO num_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kae tali ange 'e te senitulioó ia, 'o pehē, “'Aliki, 'oku kala kita taau ke Ke hū mai ki toku poko'i falé; kā Ke fai pē mu'a he fe'i folafola, pea 'e ma'uli ai pē ta'akú tamaio'aliki. ");
INSERT INTO num_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","He ko aú foki ko te tangata 'okou fakaongo ki toku pule, pea 'oku 'i ai he kau sōtia 'oku fakaongo kiā au: pea u iange ki te taha, ‘'Alu,’ pea 'e 'alu atu ia; pea ki te taha, ‘Ha'u,’ pea 'e ha'u ia; pea u iange ki taku pōpulá, ‘Fai ē,’ pea fai leva ia.” ");
INSERT INTO num_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pea 'i te fanongo ki ai 'e Sīsuú ne Ina ofo 'i ai; 'o iange kiā nātou ne'e mulimuli maí, “'Okou tala mo'oni atu kiā kōtou, ne kala U 'ilo'i he taha 'i 'Isileli 'oku pehē fau tana tuí. ");
INSERT INTO num_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Pea 'Okou tala'i atu, 'E ha'u he tokolahi mei hahake mo hihifo, 'o notou nonofo mo 'Ēpalahame mo 'Aisake mo Sēkope, 'i te Pule'anga 'o Hēvaní; ");
INSERT INTO num_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","kā ko te fānau totonu 'o te Pule'angá 'e kapusi nātou ia ki te pō'uli 'o tua'aá. Ko te feitu'u ia 'e toki hoko ai 'ia te tangi mo te fengai'itaki 'o te nifó.” ");
INSERT INTO num_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Pea iange 'e Sīsū ki te senitulioó, “Pe'i foki atu ā ki 'api; 'e fai kiā koe 'o hangē ko tau tuí.” Pea ne'e ma'uli te tamaio'alikí 'i te taimi pē ko iá. ");
INSERT INTO num_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pea 'i te ulu leva 'ia Sīsū ki te fale 'o Pitá, ne Ina 'ilo'i atu 'ia te fa'ē tono malí, 'oku takoto, ko te puke 'i te mofí. ");
INSERT INTO num_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Pea ala Ia ki tono nimá, pea mahu'i leva te mofí mei te fafiné, pea tu'u ake ia 'o tauhi kiā Ia. ");
INSERT INTO num_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pea 'i te afiafi ifó, ne'e notou 'aumai kiā Ia te tokolahi kua 'ulusino ai he fanga tēvolo; 'o kapusi 'e Ia 'ia te 'ū fa'ahikehé 'aki te lea pē, pea ne'e fakama'uli 'e Ia mo nātou fuli pē ne'e mahaki'iná, ");
INSERT INTO num_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","kote'uhí ke fakamo'oni ki te me'a ne folafola 'aki 'iā 'Aisea ko te palōfitá, 'o pehē, “Ne'e to'o 'e Ia te tou 'ū vaivaí, mo fua te tou 'ū mahakí.” ");
INSERT INTO num_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Pea 'i te vakai 'e Sīsū ki te fu'u tokolahi 'o te kakaí, ne Ina fekau ke notou ō mei ai ki te kauvai 'e tahá. ");
INSERT INTO num_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pea ha'u kiā Ia he taha, ko te sikalaipe, 'o iange kiā Ia, “Tangata'aliki, 'e au mulimuli kiā Koe, neongo pe ko te fea he feitu'u 'e Ke me'a ki aí.” ");
INSERT INTO num_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Pea iange 'e Sīsū kiā ia, “Ko te fanga fōkisí 'oku 'i ai he notou tafu, mo te fanga manupuna 'o te 'ataá he notou pununga; kā ko te Fanautama te Tangatá 'oku kala 'i ai he me'a ke 'olunga ki ai Tono 'ulú.” ");
INSERT INTO num_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pea toki lea mo he taha kehe 'i Tana kau akó, 'o pehē kiā Ia, “'Aliki, tuku mai 'oku ke au lele mu'a 'o tanu taku tamaí.” ");
INSERT INTO num_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kā ne iange 'e Sīsū, “Mulimuli koe kiā Au, pea tuku ki te kau maté ke tanu te notou kau mate 'a nātoú.” ");
INSERT INTO num_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pea kua heka Ia ki te vaká, pea toki heka mo Tana kau akó. ");
INSERT INTO num_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Pea 'ohovale pē kua tō he taufa, pea ne'e fakapūlou 'aki te vaká he 'ū peau; ka ne'e moe pē Ia. ");
INSERT INTO num_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Pea 'unu'unu atu Tana kau akó, 'o fafangu Ia, mo notou iange, “'Aliki ē, tokoni mai; he 'oku tou tu'utāmaki!” ");
INSERT INTO num_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Pea iange 'e Ia kiā natou, “'Ia te kau tui vaivai, ko te ā 'oku kotou lotosi'i aí?” Pea toki tu'u Ia 'o lolomi te matangí mo te taí, pea ne'e hoko he tofu lahi. ");
INSERT INTO num_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Pea 'ohovale 'aupito 'ia te kau akó mo notou pehē, “Ko te Tangata ā 'eni? He na'a mo te matangí mo te taí 'oku nā talangafua kiā Ia!” ");
INSERT INTO num_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pea 'i Tana a'u ki te kauvaí, ki te fanua 'o te ha'a Katalá, ne'e fakafetaulaki mai kiā Ia he ongo tangata ne 'ulusino ai te kau tēvolo, ko te nā ōmai mei te 'ū fanualotó; ko te ongo me'a ngaahi ngata'a 'aupito, ko ia ai ne'e kala fia 'alu he taha 'o ofi ki te ala ko iá. ");
INSERT INTO num_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pea fokifā pē kua nā kalanga 'o pehē, “Ko Tou ā 'ia mātou, 'e 'Alo 'o te 'Atua? Kua Ke ha'u koā ke fakamamahi'i leva 'ia mātou, kā 'oku he'iki ai hoko tono taimí?” ");
INSERT INTO num_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pea ne'e 'i ai te fu'u fanga puaka ne notou huahua mai mei te mama'ó; ");
INSERT INTO num_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","pea kole kiā Ia 'e te kau tēvoló, 'o pehē, “Kāpau 'e Ke kapusi 'ia mātou, tuku mu'a ke motou uulu ki te fanga puaká.” ");
INSERT INTO num_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Pea iange 'e Ia kiā natou, “Ō leva.” Pea notou uulu mai ki tu'a, 'o ō atu, 'o uulu ki te fanga puaká; pea vakai, ne 'oho te fanga puaká kotoa pē 'i te taifoifó ki loto tai, 'o notou malemo ai. ");
INSERT INTO num_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pea hola 'ia te kakai ne'e tauhi nātoú, 'o notou ō mei ai ki te koló, 'o ongoongoa te me'a kotoa pē, kae'uma'ā te 'ū me'a kau ki te ongo tangata ne 'ulusino ai te kau tēvoló. ");
INSERT INTO num_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Pea vakai, ne'e ōmai kotoa pē 'ia te koló ki tu'a ke fakafetaulaki kiā Sīsū; pea 'i te notou 'ilo'i Iá, ne'e notou kole ange kiā Ia ke hiki mei te notou feitu'ú. ");
INSERT INTO num_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Pea heka vaka Ia 'o 'alu ki te kauvaí, 'o a'u ki Tono kolo 'O'oná. ");
INSERT INTO num_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pea vakai, ne notou 'aumai kiā Ia he tangata mamatea, kua takoto 'i te moe'anga. Pea 'i te vakai 'e Sīsū ki te notou tuí, ne'e folafola ange 'e Ia ki te tangata mamateá, “Toku foha, fiamālie pē, kua fakamolemole'i tau 'ū angahalá.” ");
INSERT INTO num_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kae vakai, ne'e 'i ai he 'ihi 'i te kau sikalaipé ne notou pehē 'i te notou lotó, “'Oku lea fia 'atua 'ia te Siana nei!” ");
INSERT INTO num_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pea 'ilo'i 'e Sīsū te notou mahaló, 'o iange 'e Ia, “Ko te ā 'oku kotou mahalo kovi ai 'i te kotou lotó? ");
INSERT INTO num_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","He ko fea 'oku faingafuá, 'i Taku pehē, ‘Kua fakamolemole'i tau 'ū angahalá,’ pe ko Taku pehē, ‘Tu'u 'o 'eva'eva’? ");
INSERT INTO num_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kā kote'uhí ke kotou 'ilo'i 'oku mafai 'e te Fanautama te Tangatá ke fakamolemole angahala 'i māmani, (pea toki hanga 'e Ia, 'o lea ki te tangata mamateá,) Tu'u ake, to'o tou moe'angá, pea 'alu ki tou 'apí!” ");
INSERT INTO num_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Pea tu'u ake leva ia, 'o 'alu ki tono 'apí. ");
INSERT INTO num_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pea 'i te sio ki ai te kakaí ne'e notou ofo, 'o notou fakamālō ki te 'Atuá, 'i Tana tuku he fu'u mafai pehē ki te tangatá. ");
INSERT INTO num_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Pea 'i te 'alu atu 'ia Sīsū mei aí, ne sio Ia ki te tangata 'oku nofo 'i te fale tuté, ko tono hingoá ko Mātiu; pea iange 'e Ia ki ai, “Mulimuli kiā Au.” Pea tu'u ia 'o mulimuli kiā Ia. ");
INSERT INTO num_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pea 'i te kainanga 'e Sīsū 'i te falé, tā ne'e 'i ai te tokolahi 'o te kau tānaki tukuhaú mo te kau angahalá, ne'e notou ōmai 'o nonofo mo Ia mo Tana kau akó 'i te kaí. ");
INSERT INTO num_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pea 'i te sio ki ai 'ia te kau Fālesí, ne'e notou iange ki Tana kau akó, “Ko te ā kua kai fakataha ai te kotou Faiakó mo te kau tānaki tukuhaú mo te kau angahalá?” ");
INSERT INTO num_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Pea 'i te fanongo 'e Sīsū ki aí, ne iange 'e Ia, “Ko te tangata faito'ó 'oku kailoa ma'a te ma'uli leleí, kā ma'a te mahakí. ");
INSERT INTO num_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kae kotou ō mu'a 'o kumi ki te 'uhinga 'o te me'a nei, ‘Ko te meesí 'Okou fia ma'ú, 'o kala ko te feilaulaú.’ He ne'e kala U ha'ú ke ui 'ia te anga-tonú, kā ko te angahalá.” ");
INSERT INTO num_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Pea toki ha'u kiā Ia 'ia te kau ako 'a Sioné, 'o notou pehē, “Ko te ā 'oku motou fa'a 'aukai ai mātou ia, mo te kau Fālesí; kae kailoa 'aukai Ta'aú ia kau ako?” ");
INSERT INTO num_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Pea iange 'e Sīsū kiā natou, “He 'e lava te kau fakaafe 'o te tangata ta'ané ke fakamamahi, lolotonga 'oku 'iā nātou 'ia te tangata ta'ané? Kae tokaange he taimi 'e hiki ai meiā nātou te tangata ta'ané, pea 'e notou toki 'aukai leva. ");
INSERT INTO num_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Pea 'oku kailoa hanga he taha 'o 'oposi he kofu matu'a 'aki he konga tupenu fo'ou; he ko te me'a 'oku 'oposi 'akí 'e mingi ia, pea 'oku hoko ai he fu'u mahae 'oku lahi ange. ");
INSERT INTO num_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Pea 'oku kailoa notou 'utu te uaine fo'oú ki te 'ū hina leta matu'a; he kā pehē, 'e mahae 'ia te 'ū hiná, pea mahua te uainé, 'o maumau mo te hiná. Kā 'oku notou 'utu te uaine fo'oú ki te 'ū hina fo'ou, pea 'e nā fakatou tolonga.” ");
INSERT INTO num_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Pea 'i te lolotonga Tana lea 'aki te 'ū me'a nei kiā nātoú, 'ohovale pē kua ha'u he matāpule, 'o tū'ulutui kiā Ia, 'o pehē, “'Oku 'i ai toku ki'i 'ofafine kua toki pekia; kā Ke me'a mai mu'a, 'o 'ai pē Tou nimá kiā ia, pea 'e ma'uli ia.” ");
INSERT INTO num_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Pea tu'u ake 'ia Sīsū 'o mulimuli atu, 'e Ia mo Tana kau akó. ");
INSERT INTO num_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Pea vakai, ko he fafine kua 'au toto 'o ta'u 'e hongofulu mā ua, ne'e 'unu'unu atu ia 'i Tono tu'á, 'o ala ki te kapa 'o Tono kofú. ");
INSERT INTO num_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","He ne'e pehē 'e ia 'i tono lotó, “Kāpau 'e au ala pē ki Tono kofú, 'e au ma'uli.” ");
INSERT INTO num_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ka ne'e tafoki ange 'e Sīsū 'o 'ilo'i ia, pea iange Ia, “'Aua 'e ke manahē, nga'ata; kua fakama'uli 'ou 'e tau tuí.” Pea ne'e ma'uli te fafiné mei te taimi pē ko iá. ");
INSERT INTO num_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pea 'i te hū 'ia Sīsū ki te fale 'o te matāpulé, 'o mamata ki te kau ifi fangufangú, mo te kakai 'oku tangilāulaú, ");
INSERT INTO num_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ne iange 'e Ia, “Kotou mātuku atu; he 'oku kailoa mate te ta'ahiné ia, kā 'oku moe pē.” Pea notou kakata mo manuki kiā Ia. ");
INSERT INTO num_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pea kua tuku atu 'ia te kakaí, pea hū atu Ia 'o puke tono nimá; pea tu'u ake te ta'ahiné. ");
INSERT INTO num_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Pea ne'e mafola atu Tono ongoongó ki te fanua fuli pē ko iá. ");
INSERT INTO num_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Pea 'i te 'alu 'ia Sīsū mei aí, ne'e mulimuli kiā Ia he ongo tangata kui, 'oku nā kalanga 'o pehē, “Hako 'o Tēvita, 'alo'ofa mai kiā māua!” ");
INSERT INTO num_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pea 'i Tana hū ki falé, ne 'unu'unu atu kiā Ia 'ia te ongo kuí; pea 'eke ange 'e Sīsū kiā nāua, “'Oku kulā tui 'Okou lava 'ia te me'a nei?” Pea nā pehē ki ai, “'Io, 'Aliki.” ");
INSERT INTO num_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Toki ala leva 'e Ia ki to'o nāuá mata, mo pehē, “Ke fai kiā kōlua 'o fakatatau ki te kulā tuí.” ");
INSERT INTO num_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Pea 'a'ala leva te nā matá. Pea na'ina'i mamafa 'e Sīsū kiā nāua, 'o pehē, “Vakai ke 'aua na'a 'ilo'i 'eni he taha.” ");
INSERT INTO num_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ka ne'e ō 'ia nāua ia, 'o ongoongoa atu 'ia Sīsū ki te fanua kotoa pē ko iá. ");
INSERT INTO num_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pea 'i te nā ō atú, vakai, ne'e 'aumai kiā Ia he tangata noa kua 'ulusino ai he tēvolo. ");
INSERT INTO num_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pea 'i tono kapusi te tēvoló, ne lea ai 'ia te noá; pea ne'e ofo 'aupito 'ia te kakaí, 'o notou pehē, “Kua he'iki ai hoko he me'a pehē 'i 'Isileli!” ");
INSERT INTO num_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ka ne'e tala 'e te kau Fālesí ia 'o pehē, “Ko te 'aliki 'o te kau tēvoló 'oku fai 'aki Tana kapusi tēvoló.” ");
INSERT INTO num_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pea ne'e fononga takai 'ia Sīsū ki te kolo lalahi kotoa pē mo te 'ū kolo lilikí 'o faiako 'i te 'ū falelotú, mo malanga 'aki te ongoongolelei 'o te Pule'angá: mo fakama'uli te mahaki mo te hangatāmaki kotoa pē 'o te kakaí. ");
INSERT INTO num_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pea 'i Tana mamata ki te fu'u kakaí, ne'e langa Tono fatú 'i te 'ofa kiā nātou; kote'uhí ne'e notou mafasia mo tukuhāusia, 'o hangē he fanga sipi 'oku kailoa 'i ai he notou tauhí. ");
INSERT INTO num_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Pea toki pehē 'e Ia ki Tana kau akó, “Kua lahi mo matu'u 'ia te ta'ú, kā 'oku tokosi'i 'ia te kau ngāué. ");
INSERT INTO num_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ko ia kotou kole ki te 'Aliki 'oku 'A'ana 'ia te ta'ú, ke fekau'i atu mo he kau ngāue ke utu Tana ta'ú.” ");
INSERT INTO num_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Pea kua ui ange 'e Sīsū Tana kau ako 'e toko hongofulu mā uá, 'o tuku kiā natou 'ia te mafai ke pule ki te 'ū fa'ahikehé, kote'uhí ke notou kapusi nātou; mo fakama'uli 'ia te mahakí mo te hangatāmaki kotoa pē. ");
INSERT INTO num_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Pea ko te hingoa 'eni 'o te kau 'apōsetolo 'e toko hongofulu mā uá. Ko te 'uluakí ko Saimone, 'ā ē ne'e ui ko Pitá, mo 'Anitelū ko tono tehiná; ko Sēmisi ko te foha 'o Sēpetí, mo Sione ko tono tehiná; ");
INSERT INTO num_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ko Filipe mo Pātolomiu; ko Tōmasi mo Mātiu ko te tānaki tukuhaú; ko Sēmisi ko te foha 'o 'Alefiusi, mo Lepiusi, ne'e ui foki ko Tatiusí; ");
INSERT INTO num_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ko Saimone 'o te kautaha Mamahi'i fanuá, pea mo Siutasi 'Isikaliote, 'ā ē ne'e lavaki'i 'ia Sīsuú. ");
INSERT INTO num_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ko te toko hongofulu mā ua 'eni ne'e fekau atu 'e Sīsū, 'o fekau'i 'ia nātou, 'o pehē, “'Aua 'e kotou afe 'i te ala 'oku 'alu ki te Senitailé, pea 'aua 'e kotou hū he kolo Samēlia, ");
INSERT INTO num_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","kae kotou ō pē ki te fanga sipi kua mole 'i te fale 'o 'Isilelí. ");
INSERT INTO num_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pea 'i te kotou oó, kotou malanga 'o pehē, ‘Kua ofi 'ia te Pule'anga 'o Hēvaní.’ ");
INSERT INTO num_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pea kotou faito'o mahaki, mo fokotu'u 'ia te pekiá, mo fakama'a te kiliá, pea kapusi 'ia te tēvoló. Kua kotou ma'u ta'etotongi, ko ia ai, kotou 'avatu ta'etotongi. ");
INSERT INTO num_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","'Aua 'e kotou fa'o he pa'anga koula ke fakapona 'i te kotou no'ó, pe ko te siliva, pe ko te kapa. ");
INSERT INTO num_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","'Aua 'e to'o he kato 'oho ki te alá, pe 'ai ke ua tou koté, pe ko te senitoló, pe he tokotoko. He 'oku taau te tangata 'oku ngāué ke ma'u ha'aná totongi. ");
INSERT INTO num_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Pea kā kotou hū atu he kolo lalahi, pē he kolo liliki, kotou kumi 'i ai he 'api 'oku taau ke kotou ō ki aí; pea nofo pē 'i ai kae'aua ke kotou hiki mei te kolo ko iá. ");
INSERT INTO num_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pea 'i te kotou hū ki te falé, tāpuaki'i ia. ");
INSERT INTO num_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Pea kāpau 'oku taau mo'oni 'ia te falé, 'e nofo 'i ai te kotou tāpuakí; pea kāpau 'oku kailoa, 'e foki mai pē kiā kōtou te kotou tāpuakí. ");
INSERT INTO num_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kā 'i ai he 'ihi 'e kailoa notou tali 'ia kōtou, pe fia fanongo ki te kotou 'ū leá, pea 'i te kotou hū mai mei te fale pe ko te kolo ko iá, kotou tūtuu'i tono efú mei te kotou va'é. ");
INSERT INTO num_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","'Okou tala mo'oni atu kiā kōtou, 'e kātaki'ingafua ange 'i te 'Aho Fakamaaú 'ia te fanua 'o Sōtoma mo Kōmolá 'i te kolo ko iá. ");
INSERT INTO num_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ko 'eni, 'Okou fekau atu 'ia kōtou hangē ko he fanga sipi 'i te lotolotonga 'o he fanga ulofi; ko ia ai, kotou olo poto hangē ko te ngatá, pea anga-lelei hangē ko te lupé. ");
INSERT INTO num_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kae kotou tokanga ki te kakaí, he 'e feinga he 'ihi ke notou faka'ilo kōtou ki te fakamāu'angá, pea 'e notou haha 'ia kōtou 'i te notou 'ū falelotú. ");
INSERT INTO num_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","'Io, 'e 'ave 'ia kōtou ki te kau kōvana, mo te 'ū tu'i, kote'uhí ko Au, ke 'i ai he fakamo'oni kiā nātou mo te kau Senitailé. ");
INSERT INTO num_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pea kā notou faka'ilo 'ia kōtou, 'aua 'e kotou lotoma'ua pe fefe'aki he kotou tali, pē he me'a 'e kotou lea 'aki; he 'e 'avatu kiā kotou 'i te taimi ko iá 'ia te me'a 'e kotou lea 'akí. ");
INSERT INTO num_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","He 'oku kala ko kōtou 'e leá, kā ko te Laumālie 'a te kotou Tamaí 'e lea 'iā kotou. ");
INSERT INTO num_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Pea 'e faka'ilo 'e te ta'oketé tono tehiná, kote'uhí ke tāmate'i, pea ko te tamaí tana fānaú; pea 'e tu'u te fānaú ki te notou mātu'á 'o tāmate'i 'ia nātou. ");
INSERT INTO num_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Pea 'e fihi'a te kakai kotoa pē 'iā kōtou kote'uhí ko Toku hingoá; kā ko ia 'e kātaki 'o a'u ki te ngata'angá, 'e ma'uli ia. ");
INSERT INTO num_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pea kā notou fakatanga'i kōtou 'i te kolo ko 'ení, kotou hola ki te kolo kehe. He 'Okou tala mo'oni atu kiā kōtou, 'i te he'iki ai ke kotou 'osiki 'ia te 'ū kolo 'o 'Isilelí, kua a'u mai 'ia te Fanautama te Tangatá ia. ");
INSERT INTO num_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","'Oku kala he tama ako 'e lahi ake 'i tana faiakó, pe ko te pōpulá 'i tana 'alikí. ");
INSERT INTO num_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mālō pē kāpau 'e fai ki te tama akó 'o tatau mo tana faiakó, pea ki te pōpulá 'o tatau mo tana 'alikí. Pea kāpau kua notou ui te 'Aliki 'o te falé ko Pelisipupe, 'e toe kovi ange te notou 'ai hingoa kiā nātou 'i Tono falé. ");
INSERT INTO num_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ko ia 'aua 'e kotou manahē kiā nātou; he 'oku kala he me'a kua fufū 'e ta'efakahaa'i, pe lilo 'e ta'e'ilo'i. ");
INSERT INTO num_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ko te me'a 'Okou tala pō'uli kiā kōtoú, kotou fakahā 'aho; pea ko te me'a kua fanafana'aki ki te kotou talingá, kotou malanga 'aki mei te funga falé. ");
INSERT INTO num_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Pea 'aua 'e kotou manahē kiā nātou 'oku tāmate'i 'ia te sinó pē, kā ko te laumālié 'oku kala notou lava ke tāmate'i. Kae kotou manahē kiā Ia 'oku mafai ke faka'auha 'i heli 'ia te laumālié mo te sinó fakatou'osi. ");
INSERT INTO num_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","'Oku kala koā fakatau he ongo ki'i misi 'e ua ki te sēniti pē 'e taha? Kā 'e kailoa tō ki te kelekelé he nā fe'i taha ta'e mea'i 'e te kotou Tamaí. ");
INSERT INTO num_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kā ko te 'ū tu'ani lau'i'ulu 'i te kotou 'ulú kua 'osi lau fakalautelau. ");
INSERT INTO num_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ko ia 'aua 'e kotou manahē; 'oku kotou mahu'inga ange kōtou ia 'i te fanga misi tokolahi. ");
INSERT INTO num_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Kā 'i ai he taha 'e fakahaa'i 'i te 'ao 'o te kakaí tana kau kiā Aú, 'e Au fakahaa'i foki 'e Au Taku kau kiā iá 'i te 'ao 'o Taku Tamai 'oku 'i hēvaní. ");
INSERT INTO num_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kā ko ia ko 'ē 'e fakafisinga'i 'Oku 'i te 'ao 'o te kakaí, 'e Au fakafisinga'i 'ona 'e Au foki 'i te 'ao 'o Taku Tamai 'oku 'i hēvaní. ");
INSERT INTO num_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","'Aua 'e kotou mahalo ne Au ha'ú ke 'aumai he melino ki māmani. Ne kala U ha'ú ke 'aumai he melino, kā ko te heletā. ");
INSERT INTO num_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","He kua U ha'ú ke fakafepaki'i he tangata ki tana tamaí, he 'ofafine ki tana fa'eé, he 'ofafine ki te fa'ē tono husepānití; ");
INSERT INTO num_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","pea 'e hoko leva, ko te 'ū fili 'o he tangata 'ia nātou 'oku nonofo mo ia 'i tono falé. ");
INSERT INTO num_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ko ia 'oku lahi tana 'ofa ki tana tamaí, pe ko tana fa'eé, 'i tana 'ofa kiā Aú, 'oku kala tuha ia mo Au; pea ko ia 'oku lahi tana 'ofa ki tono fohá, pe ko tono 'ofafiné, 'i tana 'ofa kiā Aú, 'oku kala tuha ia mo Au. ");
INSERT INTO num_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Pea ko ia 'oku kailoa ina fua tono kolosí 'o mulimuli mai kiā Aú, 'oku kala tuha ia mo Au. ");
INSERT INTO num_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ko ia 'oku feinga ke kalofaki tana ma'ulí, ko tana tuku ia ke molé; kā ko ia 'oku tuku tana ma'ulí ke mole kote'uhí ko Au, ko tana kalofakí ia. ");
INSERT INTO num_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ko ia ko 'ē 'e tali 'ia kōtoú 'oku tali 'e ia 'Oku, pea ko ia ko 'ē 'e tali 'Okú, 'oku ina tali 'ia Ia ne'e fekau mai 'Okú. ");
INSERT INTO num_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ko ia ko 'ē 'oku tali he palōfita, kote'uhí pē ko tana palōfitá, 'e ma'u 'e ia te totongi 'a te palōfita; pea ko ia ko 'ē 'oku tali he tangata anga-tonu, kote'uhí pē ko tana anga-tonú, 'e ma'u 'e ia te totongi 'a te tangata anga-tonu. ");
INSERT INTO num_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","'Io, ko ia ko 'ē 'e 'avange he inu ki te taha 'o si'i kau ta'e'iloa nei, kote'uhí pē ko te toko taha ia 'i Taku kau akó, neongo ko te me'i vai momoko pē, 'Okou tala mo'oni atu kiā kōtou, 'e kailoa 'aupito mole ta'aná totongi.” ");
INSERT INTO num_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pea kua faka'osi 'e Sīsū Tana fai tu'utu'uni ki Tana kau hongofulu mā uá, pea hiki Ia mei te feitu'u ko iá ke faiako mo malanga 'i te 'ū koló. ");
INSERT INTO num_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Pea 'i te fanongo 'e Sione mei pilīsone ki te 'ū ngāue 'a Kalaisí, ne ina fekau atu tana ongo ako 'e toko ua ke fehu'i kiā Ia, ");
INSERT INTO num_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","'o pehē, “Ko Koe koā ia ne'e pehē ke ha'ú, pē 'e tou 'amanaki ki te taha kehe?” ");
INSERT INTO num_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Pea tali ange 'e Sīsū kiā nāua, “Kulā ō 'o fakahaa'i kiā Sione 'ia te 'ū me'a 'oku kulā fanongo mo mamata ki aí: ");
INSERT INTO num_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","'oku 'a'ala 'ia te kuí, 'oku 'eva'eva 'ia te heké, 'oku fakama'a 'ia te kiliá, 'oku ongo 'ia te tulí, pea 'oku fokotu'u 'ia te pekiá, pea 'oku malanga 'aki 'ia te ongoongoleleí ki te masivá. ");
INSERT INTO num_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Pea manū'ia ā kā ko ia 'oku kailoa tūkia 'iā Aú.” ");
INSERT INTO num_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pea kua nā ō, pea hanga 'e Sīsū 'o lea ki te kakaí 'iā Sione, “Ne kotou ō atu ki te toafá ke mamata ki te ā? Ko te kaho 'apē 'oku lulu'i 'e te matangí? ");
INSERT INTO num_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kā ko te ā nai ne kotou ō atu ke mātaa'í? Ko te tangata 'apē ne kofu faka'ofa'ofa? 'Ē, ko nātou 'oku teunga faka'ofa'ofá 'oku 'i te 'api ia 'o te 'ū tu'i. ");
INSERT INTO num_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kā ne kotou ō atú ki te ā? Ki te palōfita? 'Io, pea 'Okou tala'i atu, 'oku lahi ia 'i te palōfita. ");
INSERT INTO num_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ko 'eni ia ne'e tohi ki ai 'ia te Folafolá, ‘Vakai, 'Okou fekau atu Taku talafekaú ke mu'amu'a kiā Koe, ke teuteu'i Tou alá Mo'ou.’ ");
INSERT INTO num_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","'Okou tala mo'oni atu kiā kōtou, 'i te kakai kotoa pē kua fanau'i 'e te fafiné, kua he'iki ai he taha 'e lahi ange 'iā Sione Papitaiso; kā neongo pe ko ai 'oku mā'ulalo taha 'i te Pule'anga 'o Hēvaní, kā 'oku lahi ia 'iā Sione. ");
INSERT INTO num_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Talu mei te 'ū 'aho 'o Sione Papitaisó 'o faai mai, mo tono 'ohofia te Pule'anga 'o Hēvaní, mo tono fa'ao 'e te kau fakamālohi. ");
INSERT INTO num_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","He ko te kau palōfita kotoa pē mo te Laó, 'o a'u mai kiā Sione, ne'e notou palōfisai pē. ");
INSERT INTO num_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Pea kāpau 'oku kotou tali te kikite ko iá, ko Sione ia 'ia te 'Ilaisiā kua hoko maí. ");
INSERT INTO num_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ko ia 'oku ma'u talingá, ke ongo'i ia. ");
INSERT INTO num_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kā 'e Au fakatatau ki te ā 'ia te to'utangata nei? 'Oku hangē ia ko te tamaliki 'oku nofo 'i te mala'e fakataú, 'o ui ange ki te tamaliki kehe, ");
INSERT INTO num_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","'o pehē, ‘Ne'e motou ifi fangufangu atu, kae kala kotou me'e; pea motou hua atu te pohoeé, kae kala kotou sī fatafata.’ ");
INSERT INTO num_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","He ne'e ha'u 'ia Sioné 'o kala kainanga mo faikava; pea kotou pehē, ‘'Oku 'iā ia he tēvolo.’ ");
INSERT INTO num_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kā kua ha'u 'ia te Fanautama te Tangatá 'o kainanga mo faikava; pea kotou pehē leva, ‘'Isa, ko te tama fa'a kai mo fa'a inu kava, ko te kaume'a 'o te kau tānaki tukuhaú mo te kau angahalá.’ Ka ne'e fakatonuhia'i 'ia Poto 'e Ta'aná fānau.” ");
INSERT INTO num_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pea toki valoki'i 'e Sīsū 'ia te 'ū kolo 'ā ē ne'e fai lahi ai Tana 'ū ngāue mamafá, kote'uhí ko te kailoa notou fakatomalá. ");
INSERT INTO num_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Pohoē 'ia koe, Kōlesini! Pohoē 'ia koe, Petesaita! He kāpau ne'e fai 'i Taia mo Saitoni 'ia te 'ū ngāue mamafa ne'e fai 'iā kōluá, ne fualoa pē te notou fakatomala, 'o 'ai tauanga'a mo pani efuefu. ");
INSERT INTO num_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kā 'Okou tala'i atu, 'e kātaki'ingafua ange 'i te 'Aho Fakamaaú 'ia Taia mo Saitoni 'iā kōlua. ");
INSERT INTO num_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Pea ko koe foki, Kāpaneume, 'e hiki koā 'ou ki hēvani? 'E 'ave ifo 'ou ki heli. He kāpau ne'e mama'i fai 'i Sōtoma 'ia te 'ū ngāue mamafa ne'e fai 'iā koé, pehē ne tolonga ia 'o a'u mai ki te 'aho nei. ");
INSERT INTO num_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kā 'Okou tala'i atu, 'e kātaki'ingafua ange 'i te 'Aho Fakamaaú 'ia te fanua ko Sōtomá 'iā koe.” ");
INSERT INTO num_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Pea lea 'e Sīsū 'i te 'aho ko iá, 'o pehē, “'Okou fakafeta'i atu kiā Koe, 'e Tamai, ko te 'Aliki 'o hēvani mo māmaní, 'i Tau fufū 'ia te 'ū me'a peheé mei te kakai 'oku poto mo 'ilo'iló, kā Ke tatala ia ki te fanga ki'i tamaliki. ");
INSERT INTO num_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","'Io, 'e Tamai: tonuhia pē To'oú finangalo ke pehē. ");
INSERT INTO num_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kua tuku mai kiā Au 'e Taku Tamaí 'ia te 'ū me'a fuli pē, pea 'oku kala he toko taha 'e 'ilo'i 'ia te 'Aló, ngata pē 'i te Tamaí; pea 'oku kala 'ilo'i te Tamaí 'e he taha, ngata pē 'i te 'Aló, pea mo he taha pē 'e loto te 'Aló ke faka'ilo Ia ki ai. ");
INSERT INTO num_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ha'u kiā Au, 'ia kōtou fuli pē 'oku fakaongosia mo mafasiá, pea 'e Au fakamālōloo'i kōtou. ");
INSERT INTO num_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","'Ai Taku ioké kiā kōtou, pea kotou ako 'iā Au; he 'Okou fa'a kātaki mo anga-malū, pea 'e kotou 'ilo'i he mālōlō 'i te kotou laumālié. ");
INSERT INTO num_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","He ko te ioke 'A'akú 'oku malū, pea ko te kavenga 'A'akú 'oku ma'ama'a.” ");
INSERT INTO num_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pea 'i te Sāpate 'e taha, ne'e fou atu 'ia Sīsū, 'i te loto ngoue koane; pea ne'e fiakaia Tana kau akó, 'o notou kamata toli 'ia te 'ū fe'i koané, 'o kai. ");
INSERT INTO num_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kā 'i te sio ki ai 'ia te kau Fālesí, ne'e notou pehē kiā Ia, “Vakai angé, 'oku fai Tau kau akó 'ia te me'a 'oku kailoa ngafua 'i te 'aho Sāpaté!” ");
INSERT INTO num_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pea tali ange Ia kiā nātou, “Ne'e kailoa koā kotou lau 'ia te me'a ne'e fai 'e Tēvita 'i tana hālofiá mo nātou ne'e 'iā iá? ");
INSERT INTO num_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","He ne'e hū ia ki te Fale 'o te 'Atuá, 'o kai 'ia te mā fonó, 'a ē ne'e kailoa ngafua kiā ia ke kai, pe ko nātou ne'e 'iā iá, ngata pē 'i te kau taula'alikí. ");
INSERT INTO num_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Pea 'oku kailoa koā kotou lau 'i te Laó, 'o pehē, ko te kau taula'aliki 'oku 'i te Temipalé 'i te Sāpaté, 'oku notou maumau Sāpate kae ta'ehalaia pē? ");
INSERT INTO num_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pea 'Okou tala'i atu, 'oku 'i heni he Taha ia 'oku lahi 'i te Temipalé. ");
INSERT INTO num_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Pea ka ne kotou 'ilo'i tono 'uhinga 'o te me'a nei, ‘Ko te meesí 'Okou tangi ki aí, 'o kailoa ko te feilaulaú,’ pehē ne'e kailoa kotou fakahalaki 'ia te 'ata'ataá. ");
INSERT INTO num_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","He ko te Fanautama te Tangatá ko te 'Aliki foki Ia 'o te Sāpaté.” ");
INSERT INTO num_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Pea kua 'alu Ia mei ai, 'o hū ki te notou falelotú. ");
INSERT INTO num_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Pea vakai, ne'e 'i ai he tangata kua mate tono nimá. Pea notou fehu'i kiā Ia, 'o pehē, “'Oku ngafua koā ke faito'o 'i te Sāpaté?”, kote'uhí ke notou faka'ilo Ia. ");
INSERT INTO num_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Pea iange Ia kiā nātou, “Ko te tangata fea ia 'iā kōtou, 'oku taha pē tana sipí, pea kā tō ia he luo 'i te Sāpaté, 'e kala koā puke ia 'ona, 'o to'o ake? ");
INSERT INTO num_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pea tono kailoa koā mahu'inga ange 'ia te tangatá 'i te sipí? Ko ia 'oku ngafua pē 'i te Sāpaté ke failelei.” ");
INSERT INTO num_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Pea toki pehē Ia ki te tangatá, “Mafao atu tou nimá.” Pea mafao atu ia, pea ne'e toe ma'uli mai ia, 'o hangē ko te nima 'e tahá. ");
INSERT INTO num_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pea ō ki tu'a 'ia te kau Fālesí, 'o notou fai he fakataha, pe 'e fefe'aki he notou tāmate'i 'Ona. ");
INSERT INTO num_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kā 'i te 'ilo ki ai 'e Sīsuú, ne'e 'alu Ia mei te feitu'u ko iá; pea ne'e mulimuli kiā Ia he tokolahi, pea ne Ina fakama'uli 'ia nātou kotoa pē; ");
INSERT INTO num_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","pea na'ina'i 'e Ia kiā nātou, ke 'aua na'a notou fakahaa'i Ia. ");
INSERT INTO num_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kote'uhí ke fakamo'oni ki te me'a ne'e folafola 'aki 'iā 'Aisea ko te palōfitá, 'o pehē, ");
INSERT INTO num_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ko 'eni Taku Tamaio'aliki kua U filí, Taku Pele, 'a ia ne'e hōifua ai Toku lotó. 'E Au 'ai Toku laumālié kiā Ia, pea 'e Ina fakahā ki te Senitailé 'ia te fai fakamaaú. ");
INSERT INTO num_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","'E kailoa fakakikihi Ia, pe kalanga; 'io, 'e kailoa fanongo he taha mei ala ki Tono le'ó. ");
INSERT INTO num_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","'E kailoa fasi'i Ia he va'a kaho kua mapelu, pea tāmate'i te maama 'oku kohu peé, kae'aua kua ikuna Tana fakamaau totonú. ");
INSERT INTO num_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Pea 'e falala 'e te Senitailé ki Tono huafá.” ");
INSERT INTO num_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Pea ne'e toki 'aumai kiā Ia he tangata ne'e kui mo noa, pea kua 'ulusino ai he tēvolo; pea ne'e fakama'uli 'ona 'e Sīsū, 'o lea leva ia mo 'ala tono matá. ");
INSERT INTO num_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Pea ne'e ofo ai 'ia te kakai kotoa pē, 'o notou pehē, “'Oku kailoa nai ko te Hako 'eni 'o Tēvitá?” ");
INSERT INTO num_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kā ko te kau Fālesí, 'i te notou fanongo ki aí, ne'e notou pehē, “'Oku kala fai 'e te Siana nei Ta'aná kapusi tēvolo, kae 'iā Pelisipupe pē, ko te 'aliki 'o te kau tēvoló!” ");
INSERT INTO num_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pea ne'e 'ilo'i 'e Sīsū te notou fakakaukaú, 'o iange Ia, “Kā 'i ai he pule'anga 'oku māvahevahe mo fetu'usi, 'e 'auha ia; pea kā 'i ai he kolo mo he fāmili 'oku vākovi mo fetu'usi, 'e kailoa lava ia ke tu'u. ");
INSERT INTO num_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Pea kāpau 'oku kapusi 'e Sētane 'ia Sētane, 'o māvahevahe, tā 'oku fihi'a pē ia kiā ia; pea tu'u fefe'aki ai tono pule'angá? ");
INSERT INTO num_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Pea kāpau 'oku fai Taku kapusi tēvoló 'iā Pelisipupe, pea 'oku fai 'iā ai 'e te kotou kau tamá? Ko ia ai ko nātou 'e kotou halaia mei aí. ");
INSERT INTO num_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kae kāpau ko te Laumālie 'o te 'Atuá 'Okou fai ai Taku kapusi tēvoló, pea tā kua a'u mai kiā kōtou 'ia te Pule'anga 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","He 'e lava fefe'aki he taha ke hū ki te fale 'o he to'a, 'o kaiha'asi tana koloá, 'o kāpau 'e kailoa ina 'uluaki ha'i 'ia te to'á? Pea 'e toki lava leva ia ke vete tono falé. ");
INSERT INTO num_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ko ia 'oku kailoa kau mo Aú 'oku angatu'u ia kiā Au; pea ko ia 'oku kailoa kau mo Au 'i te fakatahatahá 'oku fakamavetevete ia. ");
INSERT INTO num_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ko ia 'Okou tala'i atu kiā kōtou, ko te angahala fuli pē, pea mo te lau kovi ki te 'Atuá, 'e fakamolemole'i pē ki te kakaí; kā ko te lau kovi ki te Laumālie Mā'oni'oní, 'e kailoa fakamolemole'i. ");
INSERT INTO num_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Pea kā 'i ai he taha 'e 'ai he lea kovi ki te Fanautama te Tangatá 'e fakamolemole'i pē ia: kā ko ia 'e 'ai he lea 'oku kau kovi ki te Laumālie Mā'oni'oní, 'e kailoa fakamolemole'i 'ona ia, 'i te maama ko 'ení, pe 'i te maama kaha'ú. ");
INSERT INTO num_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Kehe pē ke kotou lau 'oku lelei 'ia te 'akaú mo lelei tono fuá, pē 'e kotou lau 'oku tamaki 'ia te 'akaú mo tamaki tono fuá; he 'oku 'ilo'i te 'akaú 'i tono fuá. ");
INSERT INTO num_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","'Ia te hako'i ngata fekai, 'e kotou lava fefe'aki ke lea 'aki 'ia te 'ū me'a 'oku leleí, kā ko te fa'ahinga 'oku kovi? He ko te talanoa 'o te ngutú 'oku mei te me'a hulu atu 'i te lotó. ");
INSERT INTO num_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ko te tangata leleí 'oku 'alu ake mei ai 'ia te 'ū me'a lelei mei te koloa lelei 'o te lotó; pea ko te tangata koví 'oku 'alu ake mei ai 'ia te me'a kovi mei te koloa kovi 'o te lotó. ");
INSERT INTO num_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pea 'Okou tala'i atu kiā kōtou, ko te lea kovi kotoa pē 'oku lea 'aki 'e te kakaí, 'e notou fakamatala ki ai 'i te 'aho fakamaaú; ");
INSERT INTO num_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","he ko tau 'ū leá 'e tafito ki ai tau tonuhiá, pea ko tau 'ū leá 'e tafito ki ai tau halaiá.” ");
INSERT INTO num_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ne'e toki tali kiā Ia 'e te 'ihi 'o te kau sikalaipé mo te kau Fālesí, 'o pehē, “Tangata'aliki, 'oku motou fia mamata he faka'ilonga meiā Koe.” ");
INSERT INTO num_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ka ne'e tali 'e Ia 'o pehē kiā nātou, “Ko te to'utangata faikovi ia mo fe'auaki, 'oku tangi ki te faka'ilongá; kā 'oku kailoa he faka'ilonga 'e 'avange ki ai, ngata pē 'i te faka'ilonga 'o Siona ko te palōfitá. ");
INSERT INTO num_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","He 'oku hangē ko tana 'i te kete 'o te fu'u iká 'ia Siona, 'o 'aho tolu mo pō tolú, pehē foki 'e 'i lalo fanua 'ia te Fanautama te Tangatá, 'o 'aho tolu mo pō tolu. ");
INSERT INTO num_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","'E hopo 'ia te kakai Ninivé mo te to'utangata nei 'i te fakamaaú, pea 'e notou fakahalaia'i ia; he ne'e fakatomala 'e nātou 'i te malanga 'a Sioná, kae vakai, 'oku 'i heni he Taha ia 'oku lahi ange 'iā Siona. ");
INSERT INTO num_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","'E tutu'u 'i te fakamaaú 'ia te kuini 'o te feitu'u Tongá, pea mo te to'utangata nei, pea 'e fakahalaia'i 'e ia 'ona; he ne'e ha'u ia mei te ngata'anga 'o māmaní ke fanongo ki te poto 'o Solomoné, kae vakai, 'oku 'i heni he Taha ia 'oku lahi ange 'iā Solomone. ");
INSERT INTO num_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kā 'alu atu 'ia te fa'ahikehé mei te tangatá, 'oku 'osiki ia 'ia te 'ū feitu'u moamoá tana 'alu'i, ko te kumi he mālōlō'anga, kae kailoa ma'u. ");
INSERT INTO num_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Pea toki pehē ia, ‘Ke au foki mu'a ki toku falé, 'a ē ne au 'alu mei aí.’ Pea 'i tana a'u maí, tā 'oku kei 'atā, pea kua tafi mo teuteu'i. ");
INSERT INTO num_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Toki 'alu leva ia 'o ma'u mai mo te fa'ahikehe 'e fitu kehe, 'oku notou kovi ange 'iā ia; pea notou hū mai, 'o nonofo 'i ai. Pea hoko ai ki te tangata ko iá 'o lahi ange tana kovi ki mulí 'i tana kovi mu'á. 'E pehē pē foki ki te to'utangata anga-kovi nei.” ");
INSERT INTO num_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Pea 'i Tana kei lea ki te kakaí, ne'e a'u mai Tana fa'eé mo Tono 'ū tokouá 'o tutu'u mei tu'a, ko te notou fia lea kiā Ia. ");
INSERT INTO num_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Pea pehē ange he taha kiā Ia, “'Ē, ko Tau fa'eé mo Tou 'ū tokouá 'oku notou tutu'u mei tu'a, ko te notou fia lea kiā Koe.” ");
INSERT INTO num_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kae toki tali ange 'e Ia kiā ia ne'e lea maí, “Ko ai ia Taku fa'eé? Pea ko ai Toku 'ū tokouá?” ");
INSERT INTO num_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Pea mafao atu Ia Tono nimá ki Tana kau akó, 'o iange, “Ko 'eni ia Taku fa'eé mo Toku 'ū tokouá! ");
INSERT INTO num_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ko ia kotoa pē 'oku fai 'ia te finangalo 'o Taku Tamai 'oku 'i hēvaní, ko ia ia Toku tokouá, mo Toku tu'afafiné, mo Taku fa'eé.” ");
INSERT INTO num_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ne'e 'alu atu 'ia Sīsū 'i te 'aho tatau mei te falé, 'o nofo 'i matātai. ");
INSERT INTO num_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Pea fakataha kiā Ia 'ia te fu'u kakai tokolahi, ko ia ai ne'e heka Ia he vaka 'o nofo mei ai, kae tutu'u 'ia te fu'u fakatahá mei 'uta. ");
INSERT INTO num_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Pea lahi 'ia te 'ū me'a ne'e lea 'aki 'e Ia kiā natou 'i te 'ū talanoa fakatātā, 'o pehē, “Vakai, ne'e 'alu atu he tangata tūtuu'i ke tūtuu'i. ");
INSERT INTO num_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pea 'i tana tūtuu'í, ne'e ngangana he pulapula 'ihi 'i te va'ealá, pea puna mai 'ia te fanga manupuná, 'o notou kai ia 'o 'osi. ");
INSERT INTO num_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Pea ngangana he pulapula 'ihi ki te potu makamaka, 'a ē ne'e si'isi'i ai te kelekelé; pea tupu ake leva ia, kote'uhí ne'e kailoa matolu te kelekelé. ");
INSERT INTO num_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kā 'i te 'alu ake te la'aá, ne'e vela ia; pea kote'uhí ne'e kailoa hana aká, ne'e mate ia. ");
INSERT INTO num_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pea ngangana he pulapula 'ihi ki te loto 'akau talatala; pea tupu ake te 'akau talatalá, 'o kāsia'i 'ona. ");
INSERT INTO num_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pea ngangana he pulapula 'ihi ki te kelekele lelei, pea fua ia, 'o taki fua teau 'ihi, pea fua onongofulu 'ihi, pea fua tolungofulu 'ihi. ");
INSERT INTO num_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ko ia 'oku ma'u talingá, ke ongo'i ia.” ");
INSERT INTO num_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Pea ha'u Tana kau akó 'o 'eke ange kiā Ia, “Ko te ā 'oku lea fakatātā ai 'e Koe kiā nātoú?” ");
INSERT INTO num_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Pea tali ange Ia, 'o pehē, “Kote'uhí kua tuku kiā kōtou ke 'ilo'i te 'ū misiteli 'o te Pule'anga 'o Hēvaní, kā ko nātou 'oku kailoa tuku ki ai. ");
INSERT INTO num_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","He ko ia ko 'ē 'oku ma'u he me'á 'e 'avange ki ai mo he me'a, pea 'e hulu atu ia; pea ko ia ko 'ē 'oku kailoa ma'ú, na'a mo te me'a 'oku ma'u 'e iá 'e to'o meiā ia. ");
INSERT INTO num_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ko tono 'uhinga 'eni 'o Taku lea fakatātā kiā nātoú, kote'uhí 'oku notou 'a'ala, kae kailoa mamata, pea 'oku notou fānonongo kae kailoa ongo'i, 'uma'ā he 'ilo'i. ");
INSERT INTO num_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Pea 'oku fakamo'oni'i 'iā nātou 'ia te palōfisai 'a 'Aiseá, 'a ē 'oku pehē, ‘'E kotou mātu'aki fanongo, kae kailoa ongo'i; pea 'e kotou mātu'aki sio, kae kailoa 'ilo'i. ");
INSERT INTO num_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","He kua ongonoa te loto 'o te kakai nei, pea kua ongongata'a te notou talingá, pea ko te notou matá kua notou tāpuni'i; na'a faifai angé 'e notou sisio 'aki te notou matá, pea fānonongo 'aki te notou talingá, pea 'i'ilo 'aki te notou lotó, 'o notou tafoki, kae Au fakama'uli 'ia nātou.’ ");
INSERT INTO num_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Kā 'oku manū'ia ta'a kōtoú mata, he 'oku notou mamata, mo ta'a kōtoú talinga, he 'oku notou fanongo. ");
INSERT INTO num_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","He 'Okou tala mo'oni atu kiā kōtou, ne'e tokolahi pē te kau palōfita mo te kakai mā'oni'oni, ne'e notou faka'amu ke mamata ki te 'ū me'a 'oku kotou sisio ki aí, ka ne'e kailoa notou mamata; pea ke fanongo ki te 'ū me'a 'oku kotou fānonongo ki aí, ka ne'e kailoa notou fanongo. ");
INSERT INTO num_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ko ia ai, kotou fanongo mai kōtou ki te talanoa fakatātā 'o te tangata tūtuu'í. ");
INSERT INTO num_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kāpau 'e fanongo he taha ki te Folafola 'o te Pule'angá, kae kailoa tokanga ki ai, 'oku ha'u 'ia te Filí, 'o fa'ao te me'a ne'e tō ki tono lotó. Ko 'eni ia ne'e tūtuu'i 'i te va'ealá. ");
INSERT INTO num_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Pea ko ia ne'e tūtuu'i ki te potu makamaká, ko te toko taha ia 'oku fanongo ki te Folafolá, 'o puke fiafia leva ki ai; ");
INSERT INTO num_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","kā 'oku kailoa 'i ai he aka 'iā ia, kā 'oku fakataimi pē. Pea kā hoko mai he faingata'a pē he fakatanga kote'uhí ko te Folafolá, pea tūkia leva. ");
INSERT INTO num_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Pea ko ia ne'e tūtuu'i 'i te potu 'akau talatalá, ko te toko taha ia 'oku fanongo ki te Folafolá; pea ko te lotoma'ua ki māmaní, mo te 'ofa ki te koloá, 'oku kāsia ai 'ia te Folafolá, pea 'oku ta'efua ia. ");
INSERT INTO num_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pea ko ia ne'e tūtuu'i ki te kelekele leleí, ko te toko taha ia 'oku fanongo ki te Folafolá, pea tokanga ki ai; pea ko 'eni ia 'oku fuá, 'o fua teau te taha, pea fua onongofulu te taha, pea fua tolungofulu 'ia te taha.” ");
INSERT INTO num_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Pea ne'e fai 'e Sīsū mo te talanoa fakatātā 'e taha, 'o pehē, “'Oku tatau 'ia te Pule'anga 'o Hēvaní mo he tangata ne'e tūtuu'i pulapula lelei 'i tana ngoué. ");
INSERT INTO num_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pea lolotonga te momoe 'ia te kakaí, ne'e ha'u tono filí, 'o toe tūtuu'i he tea 'i te loto uité, pea 'alu ia. ");
INSERT INTO num_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Pea kua tupu tono sinó, pea a'u ki te fua, pea toki hā 'i ai mo te teá. ");
INSERT INTO num_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Pea ha'u te kau tamaio'aliki 'a te 'alikí, 'o notou pehē kiā ia, ‘'Aliki, ne'e kailoa koā ko te pulapula lelei pē ia ne ke tūtuu'i 'i tau ngoué? Kā ko te tea 'ení ia mei fea?’ ");
INSERT INTO num_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Pea tali ange ia kiā nātou, ‘Ko he fili pē kua ina fai 'ení.’ Pea notou iange ki ai, ‘'E ke loto ke motou ō 'o ta'aki ia?’ ");
INSERT INTO num_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pea tali ange ia, ‘'Aua; na'a faifai angé 'i te kotou tufi te teá, kua kotou ta'aki fakataha ai mo te uité foki. ");
INSERT INTO num_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tuku pē ke nā tutupu fakataha 'o a'u ki te utu-ta'ú; pea kā hoko 'ia te utu-ta'ú 'e au tala ki te kau tu'usí, “Kotou 'uluaki tānaki te teá, 'o nono'o ke tutu; kae fetuku te uité ki toku faleokó.” ’ ” ");
INSERT INTO num_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Pea toe fai 'e Sīsū he talanoa fakatātā 'e taha kiā nātou 'o pehē, “'Oku tatau 'ia te Pule'anga 'o Hēvaní mo he fe'i pulapula'i mūsita, ne'e to'o he tangata 'o tō 'i tana ngoué. ");
INSERT INTO num_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ko te fōsi'i taha ia 'i te pulapula'i 'akau kotoa pē, kae tupu ake iá, ko te lahi taha ia 'i te fa'ahinga 'akau lilikí, pea hoko ia ko te fu'u 'akau, pea ha'u ai 'ia te fanga manupuna 'o te 'ataá, 'o nofo 'i tono 'ū va'á.” ");
INSERT INTO num_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Pea toe fai 'e Sīsū he talanoa fakatātā 'e taha kiā nātou, 'o pehē, “'Oku tatau 'ia te Pule'anga 'o Hēvaní mo te lēvani ne'e to'o he fafine, 'o natu 'aki te fua māhoa'a 'e tolu, kae'aua ke fai lēvani te māhoa'á fuli pē.” ");
INSERT INTO num_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ne'e ako 'aki 'e Sīsū 'ia te 'ū me'a nei kotoa pē ki te kakaí 'o fou 'i te 'ū talanoa fakatātā; pea ne'e kailoa lea 'aki Ia he me'a kiā nātou kā 'i te talanoa fakatātā pē; ");
INSERT INTO num_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","kote'uhí ke fakamo'oni'i 'ia te me'a ne'e folafola 'aki 'e te palōfitá, 'o pehē, “'E Au tangaki Toku ngutú 'i te 'ū talanoa fakatātā, 'E Au 'a'au 'ia te 'ū me'a ne fufū talu mei te tanupou 'o māmaní.” ");
INSERT INTO num_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pea toki tukuange 'e Sīsū 'ia te kakaí, kae hū Ia ki fale; pea ha'u kiā Ia Tana kau akó, 'o notou pehē, “Fakamatala'i mai te talanoa fakatātā 'o te 'ū tea 'i te ngoué.” ");
INSERT INTO num_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Pea tali Ia 'o pehē, “Ko Ia 'oku tō 'ia te pulapula leleí ko te Fanautama te Tangatá ia. ");
INSERT INTO num_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ko te ngoué ko māmani; ko te pulapula leleí ko te fānau 'o te Pule'angá; ko te 'ū teá ko te fānau ia 'a te toko taha koví; ");
INSERT INTO num_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ko te fili ne'e tō iá ko te tēvoló; ko te utu-ta'ú ko te faka'osi 'o he kuonga; ko te kau tu'usí ko te kau 'āngeló. ");
INSERT INTO num_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Pea hangē 'oku tānaki 'ia te teá 'o tutu 'aki te afí, 'e pehē foki 'i te faka'osi 'o māmaní. ");
INSERT INTO num_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","'E fekau atu 'e te Fanautama te Tangatá Tana kau 'āngeló, pea 'e notou tānaki mei Tono pule'angá 'ia te tūkia'anga kotoa pē, mo nātou 'oku maumau laó; ");
INSERT INTO num_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","pea 'e notou laku 'ia nātou ki te fōnise afi, ko te feitu'u ia 'e toki hoko ai 'ia te tangi mo te fengai'itaki 'o te nifó. ");
INSERT INTO num_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kae toki ho'ata mai 'ia te kau faileleí 'o hangē ko te la'aá 'i te pule'anga 'o te notou Tamaí. Ko ia 'oku ma'u talingá, ke ongo'i ia. ");
INSERT INTO num_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Pehē foki, 'oku tatau 'ia te Pule'anga 'o Hēvaní mo he koloa ne'e fufuu'i he loto ngoue, 'a ia ne'e 'ilo ki ai he tangata, 'o ina fufuu'i, pea 'i tana fiafiá 'oku 'alu ia 'o fakatau atu tana koloa kotoa pē, kae fakatau 'aki 'ia te ngoue ko iá. ");
INSERT INTO num_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“'Oku tatau foki 'ia te Pule'anga 'o Hēvaní mo he tangata fakatau, 'a ia ne ina fekumi ki te mata'itofe lelei. ");
INSERT INTO num_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pea 'i tana 'ilo'i te mata'itofe ne'e mahu'inga lahi, ne ina 'alu 'o fakatau atu tana me'a kotoa pē, 'o fakatau 'aki 'ia te mata'itofe ko iá. ");
INSERT INTO num_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“'Oku tatau foki 'ia te Pule'anga 'o Hēvaní mo he kupenga ne'e sī ki tai, 'o ha'o 'aki 'ia te fa'ahinga ika kotoa pē. ");
INSERT INTO num_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Pea 'i tana fonú ne'e notou toho ake ki 'uta, 'o notou nofo ifo 'o fa'o kato 'ia te leleí, kae si'aki te koví. ");
INSERT INTO num_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","'E pehē pē 'i te faka'osi 'o māmaní: 'e 'alu atu 'ia te kau 'āngeló, 'o vahe'i mai 'ia te kakai koví mei te lotolotonga 'o te faileleí, ");
INSERT INTO num_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","pea 'e notou laku 'ia nātou ki te fōnise afi, ko te feitu'u ia 'e toki hoko ai 'ia te tangi mo te fengai'itaki 'o te nifó. ");
INSERT INTO num_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Kua mahino kiā kōtou 'ia te 'ū me'a nei kotoa pē?” Pea notou tali, “Ko 'ē.” ");
INSERT INTO num_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Pea iange 'e Ia kiā nātou, “Ko ia ai, ko te sikalaipe kotoa pē kua toe hoko ko te tama ako 'o te Pule'anga 'o Hēvaní, 'oku hangē ia ko te 'aliki 'o te fale, kua tuku atu 'e ia mei tono tuku'anga koloá 'ia te me'a fo'ou mo te me'a matu'a.” ");
INSERT INTO num_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pea 'i te faka'osi 'e Sīsū 'ia te 'ū talanoa fakatātā nei, ne Ina 'alu mei ai. ");
INSERT INTO num_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Pea 'i Tana ha'u ki Tono kolo 'O'oná ne'e fai Ia Tana ako kiā nātou 'i te notou falelotú. Pea notou ofo lahi 'i ai, 'o notou pehē, “'Oku ma'u mei fea 'e te Siana nei Tana potó, mo Tana 'ū ngāue mamafa nei? ");
INSERT INTO num_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","'Oku kailoa koā ko te Foha 'eni 'o te tufungá? 'Oku kala koā hingoa Tana fa'eé ko Mele, pea ko Sēmisi mo Siosifa mo Saimone mo Siutasi Tono 'ū tehiná? ");
INSERT INTO num_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Pea ko Tono 'ū tu'afāfiné, 'oku kailoa koā notou nofo kotoa pē 'iā tātou? Kā ko Tana ma'u mei fea 'ia te 'ū fu'u me'a nei?” ");
INSERT INTO num_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Pea ne'e notou tūkia 'iā Ia. Ka ne'e tali 'e Sīsū kiā nātou, “'Oku kailoa masiva faka'apa'apa he palōfita, kā 'i tono fanua totonú pē mo tono fāmili 'o'oná.” ");
INSERT INTO num_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Pea ne'e kala loko fai 'e Ia he ngāue mamafa 'i ai, ko te me'a 'i te notou ta'etuí. ");
INSERT INTO num_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","'I te kuonga ko iá ne'e fanongo 'e te tu'i ko Hēlotá ki te ongoongo 'o Sīsuú, ");
INSERT INTO num_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","pea pehē ange ia ki tana kau tamaio'alikí, “Ko Sione Papitaiso 'eni; kua tu'u ake mei te maté, pea ko tono 'uhinga ia 'o te fu'u mafai 'oku ngāue 'iā Iá.” ");
INSERT INTO num_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","He ne'e puke 'e Hēlota 'ia Sione, 'o ha'i ia, 'o 'ave 'o tuku pilīsone, kote'uhí ko Helotiasi ko te mali 'o tono tokoua ko Filipé. ");
INSERT INTO num_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","He ne'e fa'a lau 'e Sione ki ai, 'o pehē, “'Oku kailoa ngafua kiā koe ke ma'u 'ona.” ");
INSERT INTO num_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Pea neongo tana loto ke tāmate'i iá, ka ne'e manahē ia ki te kakaí, he ne'e notou lau ko te palōfita ia. ");
INSERT INTO num_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pea 'i te hoko ki te 'aho fakamanatu 'o te 'alo'i 'o Hēlotá, ne me'e 'ia te ta'ahine 'a Helotiasí 'i te ha'oha'ongá, 'o mālie'ina ai 'ia Hēlota. ");
INSERT INTO num_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ko ia, ne ina fuakava 'aki he lea tuki, ke 'avange kiā ia he me'a pē 'e kole ange ki aí. ");
INSERT INTO num_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Pea 'i tono fakaloto'i 'ona 'e tana fa'eé, ne'e iange ia, “'Aumai kiā au he peleti 'ia te 'ulu 'o Sione Papitaisó!” ");
INSERT INTO num_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Pea neongo ne'e mamahi 'ia te tu'í, kā kote'uhí ko tana fuakavá, pea mo nātou ne'e notou taumafa mo iá, ne ina tu'utu'uni pē ke 'avange. ");
INSERT INTO num_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Pea fekau atu 'e ia ke tu'usi te 'ulu 'o Sioné 'i te pilīsoné. ");
INSERT INTO num_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Pea ne'e 'aumai tono 'ulú he peleti, 'o 'avange ki te ta'ahiné; pea 'avange 'e ia ki tana fa'eé. ");
INSERT INTO num_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pea ne'e ha'u tana kau akó, 'o 'ave 'ia te 'anga'angá 'o tanu, pea notou toki ō 'o tala kiā Sīsū. ");
INSERT INTO num_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Pea 'i te fanongo 'e Sīsū ki aí, ne Ina 'alu vaka mei ai ki te feitu'u 'oku lala, ke fakaenātou pē. Pea ne'e fanongo ki ai 'e te kakaí, 'o notou ala 'uta pē mo mulimuli kiā Ia mei te 'ū koló. ");
INSERT INTO num_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pea 'i Tana hifo ki 'utá, ne'e mamata Ia ki te fu'u kakai tokolahi; pea ne'e langa Tono fatú 'i te 'ofa kiā nātou, 'o Ina fakama'uli te notou kau mahakí. ");
INSERT INTO num_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pea 'i tana afiafi ifó, ne'e ha'u kiā Ia Tana kau akó, 'o notou iange, “Ko te feitu'u lala 'eni, pea kua mei 'osi 'ia te 'ahó; ko ia ai, tukuange mu'a te kakaí ke notou ō ki te fanga ki'i koló, 'o fakatau he notou me'akai.” ");
INSERT INTO num_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ka ne'e iange 'e Sīsū kiā nātou, “'Oku kala 'aonga ia ke notou ō; 'avange 'e kōtou he notou me'akai.” ");
INSERT INTO num_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Pea notou tali kiā Ia, “Ko te me'a pē 'oku tou ma'ú ko te fe'i mā 'e nima, mo te mata'i ika 'e ua.” ");
INSERT INTO num_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Pea iange 'e Ia, “'Aumai ia ki heni kiā Au.” ");
INSERT INTO num_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Pea tu'utu'uni 'e Ia ke nofo 'ia te kakaí ki lalo 'i te musié. Pea to'o 'e Ia 'ia te fe'i mā 'e nimá mo te ongo iká, 'o tāngaki ake ki te langí, 'o fai he tāpuaki. Pea toki pakipaki 'e Ia 'ia te 'ū fe'i maá, 'o 'avange ki Tana kau akó, pea tufaki 'e te kau akó ki te kakaí. ");
INSERT INTO num_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Pea ne'e notou kai kotoa pē 'o mākokona. Pea ne'e notou tānaki 'ia te 'ū mapakipaki'i mā ne'e toé, 'o fonu ai 'ia te kato 'e hongofulu mā ua. ");
INSERT INTO num_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Pea ko nātou ne'e tokoní, ne'e toko nima afe nai 'ia te tangatá, 'o kailoa lau ai 'ia fafine mo te tamalikí. ");
INSERT INTO num_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pea toki fekau fakamālohi 'e Sīsū ki te kau akó ke fei mo notou heka ki te vaká, 'o mu'amu'a 'iā Ia ki te kauvai 'e tahá, lolotonga Tana tukuange 'ia te kakaí. ");
INSERT INTO num_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pea kua tukuange 'e Ia 'ia te kakaí ke notou ō, pea 'alu ake Ia ki te ma'ungá toko taha pē ke lotu. Pea 'i tana afiafi pō'ulí ne'e kei 'i ai pē Ia toko taha. ");
INSERT INTO num_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Pea ko te vaká kua a'u ki te vaeua mālié, pea faingata'a'ina 'i te peaú, he ne'e tōkai 'ia te matangí. ");
INSERT INTO num_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pea 'i te vaha'a 'o te tolu mo te ono hengihengí, ne'e 'alu atu 'ia Sīsū kiā nātou 'oku hā'ele 'i te fukahi taí. ");
INSERT INTO num_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pea 'i te sio kiā Ia 'e te kau akó, 'oku hā'ele 'i te fukahi taí, ne'e notou puputu'u, mo pehē, “Ko te fa'ahikehe!” Pea notou fekālanga'i ko te notou manaheé. ");
INSERT INTO num_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ka ne'e lea ange 'e Sīsū kiā nātou, 'o pehē, “Kotou fiamālie he ko Au pē ia. 'Aua 'e kotou manahē!” ");
INSERT INTO num_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pea tali 'e Pita kiā Ia, “'Aliki, kāpau ko Koe, fekau ke au 'alu atu 'i te fukahi taí.” ");
INSERT INTO num_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Pea iange 'e Ia, “Ha'u!” Pea hifo 'ia Pita mei te vaká, 'o hā'ele 'i te fukahi vaí ke 'alu kiā Sīsū. ");
INSERT INTO num_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kā 'i tana tokanga ki te mālohi 'o te matangí, ne'e 'ilifia ia; pea 'i tana kamata ngoto ifó ne'e kalanga ia, “'Aliki ē, fakama'uli 'oku!” ");
INSERT INTO num_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Pea mafao atu leva 'e Sīsū Tono nimá, 'o puke'i 'ona, 'o iange kiā ia, “'Ia te tui vaivai, ko te ā ne ke tāla'a aí?” ");
INSERT INTO num_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pea 'i te nā heka ki te vaká ne'e malū leva 'ia te matangí. ");
INSERT INTO num_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Pea ko nātou ne'e 'i te vaká ne'e notou tū'ulutui kiā Ia, 'o notou pehē, “Tā ko te mo'oni, ko te 'Alo 'o te 'Atuá 'ia Koe.” ");
INSERT INTO num_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pea 'i te notou hoko atú, ne'e notou tū'uta ki te fanua ko Kenesaleti. ");
INSERT INTO num_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Pea 'i tono 'ilo'i 'e te kau tangata 'o te feitu'ú ko Sīsū iá, ne'e notou fekau atu ki te feitu'u kotoa pē 'o te fanua ko iá, 'o fetuku mai kiā Ia 'ia nātou fuli pē ne'e mahaki'iná, ");
INSERT INTO num_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","'o notou kole kiā Ia ke tuku mu'a ke notou ki'i ala pē he kapa 'o Tono kofú. Pea ko nātou kotoa pē ne'e ala ki aí ne'e notou ma'uli 'aupito. ");
INSERT INTO num_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pea ne'e ōmai te kau Fālesi mo te kau sikalaipe 'o Selusalemá kiā Sīsū, 'o notou pehē ange, ");
INSERT INTO num_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ko te ā 'oku laka kehe ai Ta'aú kau ako mo te akonaki kua tukufakaholo mei te mātu'á? He 'oku kala notou fanofano te notou nimá 'i te notou kai maá!” ");
INSERT INTO num_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kae tali ange 'e Ia, 'o pehē kiā nātou, “Ko te ā 'oku kotou laka kehe ai 'ia kōtou ia mo te lao 'a te 'Atuá, kote'uhí ko te akonaki fakaeono'aho 'a kōtoú? ");
INSERT INTO num_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","He ne'e tu'utu'uni 'e te 'Atuá 'o pehē, ‘Faka'apa'apa ki tau tamaí mo tau fa'eé;’ mo 'eni, ‘Ko ia 'e lea kovi ki tana tamaí, pe ko tana fa'eé, ke mate tāmate'i ia.’ ");
INSERT INTO num_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kā kua kotou pehē 'e kōtou ia, ‘Ko ia 'e pehē ki tana tamaí, pe ko tana fa'eé, 'Ā, kua fakatāpui ki te ngāue 'a te 'Alikí 'ia te me'a ne au mei 'aonga 'aki kiā koé, ");
INSERT INTO num_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","pea 'e kailoa leva ina fai tana faka'apa'apa ki tana tamaí, pe ko tana fa'eé; pea tā kua kotou fakata'e'aonga'i 'ia te lao 'a te 'Atuá 'aki te kotou lau fakaeono'ahó. ");
INSERT INTO num_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","'Ia te kau mālualohi! Ne'ine'i palōfisai 'e 'Aisea 'iā kōtoú, 'o pehē, ");
INSERT INTO num_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ko te kakai nei 'oku notou faka'apa'apa kiā Au 'aki te notou ngutú, kā ko te notou lotó 'oku mama'o meiā Au. ");
INSERT INTO num_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ko te kulanoa pē te notou lotu maí; 'oku notou ako 'aki he 'ū tokāteline, ko te 'ū tu'utu'uni pē 'a te tangata!’ ” ");
INSERT INTO num_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Pea toki ui 'e Sīsū 'ia te kakaí, 'o iange kiā natou, “Fanongo mai kae kotou 'ilo'i. ");
INSERT INTO num_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","'Oku kala ko te me'a 'oku hū atu ki te ngutú 'oku 'uli ai he tangata, kā ko te me'a 'oku hū mai mei te ngutú, ko 'eni ia 'oku 'uli ai 'ia te tangatá.” ");
INSERT INTO num_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pea toki ha'u ai Tana kau akó, 'o 'eke ange kiā Ia, “'Oku Ke mea'i koā ne'e lavea te loto 'o te kau Fālesí, 'i te notou fanongo ki Tau lea nā?” ");
INSERT INTO num_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Kae toki pehē ange 'e Sīsū, “Ko te 'akau kotoa pē ne'e kailoa tō 'e Taku Tamai 'oku 'i hēvaní, 'e ta'aki ia. ");
INSERT INTO num_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","'Aua kotou tokanga kiā nātou; ko te kau takimu'a kui 'ia nātou ia. Pea kā taki he kui 'ia te kui, 'e nā fakatou tō ki te luó.” ");
INSERT INTO num_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pea lea 'e Pita 'o pehē ange kiā Ia, “Fakamatala'i mai mu'a te talanoa fakatātā nei kiā mātou.” ");
INSERT INTO num_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Pea iange Ia, “'Oku kei ta'e'ilo pē koā mo kōtou ia? ");
INSERT INTO num_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kua he'iki ai koā mahino atu, kā 'i ai he me'a 'oku hū ki te ngutú, 'oku 'alu ifo ia ki te keté, pea toki laku atu ki tua'ā? ");
INSERT INTO num_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kā ko te 'ū me'a 'oku hū atu mei te ngutú 'oku ha'u ia mei te lotó; pea ko te me'a ia 'oku 'uli ai 'ia te tangatá. ");
INSERT INTO num_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","He 'oku hū mai mei te lotó 'ia te fakakaukau pango, 'ia te fakapō, 'ia te tono 'unoho, 'ia te fe'auaki, 'ia te kaiha'a, 'ia te fakamo'oni lohi, 'ia te lea kovi. ");
INSERT INTO num_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ko 'eni 'ia te 'ū me'a 'oku 'uli ai 'ia te tangatá: kā ko te kai ta'efanofanó 'oku kailoa 'uli ai te tangatá ia.” ");
INSERT INTO num_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Pea 'alu atu 'ia Sīsū mei ai, ki te 'ū feitu'u 'o Taia mo Saitoní. ");
INSERT INTO num_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Pea vakai, ne'e 'i ai he fafine Kēnani 'i te feitu'u ko iá, ne'e 'alu atu 'o kalanga kiā Ia, 'o pehē, “'Aliki ē, Hako 'o Tēvita, 'alo'ofa mai mu'a; ko taku ta'ahiné 'oku faingata'a'ina lahi, he 'oku 'ulusino ai te tēvolo!” ");
INSERT INTO num_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ka ne'e kala Ha'aná ki'i lea 'e taha kiā ia. Pea ōmai tana kau akó, 'o kole ange kiā Sīsū, “Fekau te fafiné ke 'alu, he 'oku tangi toupili mai ia kiā tātou!” ");
INSERT INTO num_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ka ne'e tali ange Ia 'o pehē, “Ne'e fekau'i mai 'Okú ki te fanga sipi pē kua mole 'i te ha'a 'Isilelí.” ");
INSERT INTO num_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pea toki ha'u te fafiné, 'o tū'ulutui kiā Ia, mo iange, “'Aliki, tokoni mai mu'a.” ");
INSERT INTO num_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ka ne'e tali ange 'e Sīsū, 'o pehē, “'Oku kailoa totonu ke to'o te mā 'a te fānaú, 'o sī ki te fanga kulií.” ");
INSERT INTO num_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pea iange 'e te fafiné, “Ko te mo'oni ia, 'Aliki; ka na'a mo te fanga kulií foki 'oku notou kai mei te 'ū momo 'oku ngangana mei te tēpile 'a te notou 'alikí.” ");
INSERT INTO num_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Pea toki iange 'e Sīsū kiā ia, “Fafine, tā 'oku lahi tau tuí; 'e fai ma'au 'ia te me'a 'oku ke kole ki aí.” Pea ne'e ma'uli tana ta'ahiné mei te taimi pē ko iá. ");
INSERT INTO num_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Pea 'alu 'ia Sīsū mei ai, pea ha'u Ia 'o ofi ki te Tai 'o Kālelí; 'o toki 'alu ake ki te ma'ungá, 'o nofo 'i ai. ");
INSERT INTO num_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Pea ō atu kiā Ia he fu'u kakai tokolahi, 'o notou 'aumai 'ia te heke, mo te kui, mo te va'e ketu, mo te noa, pea mo he tokolahi ne'e puke 'i te mahaki kehekehe; 'o notou tuku atu 'ia nātou ki te va'e 'o Sīsuú, pea ne'e fakama'uli 'e Ia 'ia nātou. ");
INSERT INTO num_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Pea ofo ai 'ia te kakaí, 'i te notou sio ki te noá 'oku lea, mo te va'e ketú 'oku ma'uli, mo te heké 'oku 'eva'eva, mo te kuí 'oku 'a'ala; pea notou fakamālō'ina 'ia te 'Atua 'o 'Isilelí. ");
INSERT INTO num_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Pea ui mai 'e Sīsū Tana kau akó kiā Ia, 'o iange, “'Oku langa Toku fatú 'i te 'ofa ki te kakai nei, he ko te 'aho 'eni 'e tolu mo te notou nonofo mai, pea 'oku kailoa he notou me'akai. Pea 'oku kala U loto ke tukuange 'ia nātou 'oku notou fiakakai, na'a faifai pea notou pōngingia 'i te alá.” ");
INSERT INTO num_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Pea notou tali ange kiā Ia, “'E tou ma'u mei fea 'i te toafa nei he mā lahi, ke totofu ai he fu'u kakai tokolahi pehē fau?” ");
INSERT INTO num_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Pea iange 'e Sīsū, “'Oku fia te kotou fe'i maá?” Pea notou tali, “'Oku fitu, mo te 'ū mata'i ika liliki.” ");
INSERT INTO num_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Pea fekau 'e Ia ki te kakaí ke notou tāngungutu 'i te funga kelekelé. ");
INSERT INTO num_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Pea ne Ina to'o 'ia te fe'i mā 'e fitú, mo te 'ū mata'i iká, 'o fai he fakafeta'i, pea toki pakipaki 'e Ia 'o 'avange ki te kau akó, pea 'avange 'e te kau akó ki te kakaí. ");
INSERT INTO num_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Pea notou kai kotoa pē, 'o mākokona; pea notou tānaki 'ia te 'ū kongakonga mā ne'e toé, pea fonu ai te kato 'e fitu. ");
INSERT INTO num_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Pea ko nātou ne'e kaí ko te toko fā afe tangata, 'o kala lau ai 'ia fafine mo te tamalikí. ");
INSERT INTO num_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pea tukuange leva 'e Sīsū 'ia te kakaí, kae heka Ia ki te vaká, 'o folau atu ki te 'ū feitu'u 'o Makataní. ");
INSERT INTO num_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pea ha'u kiā Ia 'ia te kau Fālesí mo te kau Sātusí, 'o 'ahi'ahi'i 'Ona, 'i te notou kole ke faka'ali'ali ange kiā natou he faka'ilonga mei langi. ");
INSERT INTO num_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pea toki tali 'e Sīsū kiā nātou, “Kā afiafi leva 'oku kotou pehē, ‘'E 'afua, he 'oku kulakula 'ia te langí.’ ");
INSERT INTO num_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Pea kā pongipongi 'oku kotou pehē, ‘'E 'alotāmaki 'ia te 'aho nei, he 'oku kulakula mo pōpō'uli 'ia te langí.’ 'Oku kotou vavanga koā ki te mata 'o te langí; kā ko te 'ū faka'ilonga 'o te kuongá 'oku kala kotou lava ke 'ilo'i? ");
INSERT INTO num_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ko te to'utangata faikovi ia mo fe'auaki 'oku notou tangi ki te faka'ilongá; kā 'oku kala he faka'ilonga 'e 'avange ki ai, ngata pē 'i te faka'ilonga 'o Sioná.” Pea 'alu leva Ia meiā nātou. ");
INSERT INTO num_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Pea kua a'u te kau akó ki te kauvai 'e tahá, tā ne'e ngalo 'iā nātou ke 'ave he mā. ");
INSERT INTO num_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Pea iange 'e Sīsū kiā nātou, “Kotou tokanga kiā kōtou kote'uhí ko te lēvani 'a te kau Fālesí mo te kau Sātusí.” ");
INSERT INTO num_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pea notou alea ai 'iā nātou 'o pehē, “Ko tono 'uhingá ko te kailoa tou 'aumai he maá.” ");
INSERT INTO num_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pea 'i te 'ilo ki ai 'e Sīsuú, ne'e iange Ia, “'Ia te kau tui vaivai, ko te ā 'oku kotou alea ai 'o pehē kote'uhí ko te kailoa kotou 'aumai he maá? ");
INSERT INTO num_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kua kailoa koā mahino kiā kōtou, pe 'e kotou manatu'i te fe'i mā 'e nima ki te toko nima afé, mo te fia'i kato ne'e kotou tānakí? ");
INSERT INTO num_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Pe ko te fe'i mā 'e fitu ki te toko fā afé, mo te fia'i kato ne'e kotou tānakí? ");
INSERT INTO num_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kua fefe'aki nai tana ta'emahino kiā kotou ne'e kala ko Taku lea atú ki te maá? Kotou lamalama 'ia kōtou kote'uhí ko te lēvani 'a te kau Fālesí mo te Sātusí.” ");
INSERT INTO num_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ne'e toki mahino leva kiā nātou, tā 'oku kailoa ko Tana pehē ke notou faka'ehi'ehi mei te lēvani maá, kā ko te akonaki 'a te kau Fālesí mo te kau Sātusí. ");
INSERT INTO num_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Pea kua a'u 'ia Sīsū ki te feitu'u 'o Sesalia Filipaí, pea fehu'i ange 'e Ia ki Tana kau akó, “Ko ai nai 'ia te Fanautama te Tangatá 'i te lau 'a te kakaí?” ");
INSERT INTO num_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Pea notou pehē, “Ko te lau 'a te 'ihi, ko Sione Papitaiso; kā ko te 'ihi, ko 'Ilaisiā; pea ko te 'ihi, ko Selemaia, pē he taha 'o te kau palōfitá.” ");
INSERT INTO num_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Pea pehē ange 'e Ia, “Kā ko ai 'ia Au 'i te lau 'a kōtoú?” ");
INSERT INTO num_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Pea tali 'e Saimone Pita, 'o pehē, “Ko te Kalaisí Koe, ko te 'Alo 'o te 'Atua Ma'ulí.” ");
INSERT INTO num_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Pea tali 'e Sīsū, 'o pehē kiā ia, “'Oku manū'ia mo'oni 'ia koe, 'e Saimone Pāsiona, he 'oku kailoa ko te kakano mo te toto ne'e fakahaa'i kiā koé, kā ko Taku Tamai 'oku 'i hēvaní. ");
INSERT INTO num_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ko 'eni Taku lea foki kiā koé, ko Pita 'ia koe; pea 'i te funga maka nei 'e Au langa ai Toku siasí; pea 'e kailoa mālohi ki ai 'ia te 'ū matapā 'o Hētesí. ");
INSERT INTO num_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","'E Au 'avatu kiā koe 'ia te 'ū kī 'o te Pule'anga 'o Hēvaní; pea kā 'i ai he me'a 'e ke tapui 'i māmani, kua tapui ia 'i hēvani; pea kā 'i ai he me'a 'e ke fakangafua 'i māmani, kua fakangafua ia 'i hēvani.” ");
INSERT INTO num_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ne Ina toki fekau ki te kau akó, ke 'aua na'a notou tala holo, ko Ia ia 'ia te Kalaisí. ");
INSERT INTO num_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Pea talu mei te taimi ko iá mo tono fakahaa'i 'e Sīsū ki Tana kau akó, 'e pau ke 'alu atu Ia ki Selusalema, pea 'e lahi Tono fakamamahi'i 'e te kau mātu'á mo te kau taula'aliki lahí mo te kau sikalaipé, pea 'e tāmate'i 'Ona, pea 'e fokotu'u ake 'i tono 'aho tolú. ");
INSERT INTO num_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pea toki 'ave 'Ona 'e Pita, 'o valoki'i, mo pehē ange, “'Aua Ke lea pehē, 'Aliki! 'E kailoa 'aupito hoko he me'a pehē kiā Koe!” ");
INSERT INTO num_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pea toki tafoki Ia 'o lea kiā Pita, “Tu'u ki muli, Sētane; ko Toku tūkia'anga 'ia koe. He 'oku kailoa ko te 'ū me'a faka-e-'Atua 'oku sio ki ai tou lotó, kā ko te 'ū me'a fakaetangata.” ");
INSERT INTO num_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pea toki lea ange 'e Sīsū ki Tana kau akó, 'o pehē, “Kā 'i ai he taha 'oku fia mulimuli mai, kua pau ke tuku 'e ia tono lotó, pea fua tono kolosí, 'o mulimuli mai 'iā Au. ");
INSERT INTO num_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","He ko ia 'oku feinga ke kalofaki tana ma'ulí, ko tana tuku ia ke molé; pea ko ia 'e tuku tana ma'ulí ke mole kote'uhí ko Au, ko tana kalofakí ia. ");
INSERT INTO num_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","He ko te ā tono 'aonga kā ma'u he tangata 'ia māmani fuli pē 'i tana ngāué, kae mole ai tana ma'ulí? Pea ko te ā he me'a 'e 'avatu he tangata ke fakatau 'aki mai tana ma'ulí? ");
INSERT INTO num_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Hē 'e hā'ele mai 'ia te Fanautama te Tangatá, 'i te nāunau 'o Tana Tamaí, mo Tana kau 'āngeló; pea 'e toki totongi 'e Ia ki te tangata taki taha 'o fakatatau ki tana ngāué. ");
INSERT INTO num_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","'Okou tala mo'oni atu kiā kōtou, 'oku 'i ai he 'ihi 'o kōtou 'oku tutu'u 'i hení, 'e kailoa notou mama'i lave ki te maté, kae'aua ke notou mamata ki te Fanautama te Tangatá 'oku hā'ele mai 'i Tono pule'angá.” ");
INSERT INTO num_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pea kua 'osi mei ai te 'aho 'e ono, pea 'ave 'e Sīsū 'ia Pita, mo Sēmisi, mo Sione ko te tehina 'o Sēmisí, 'o 'avake 'ia nātou ki te ma'unga mā'olunga fakaenātou. ");
INSERT INTO num_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Pea ne'e fakakehe Tono angá 'i te notou 'aó, pea ne'e ulo Tono fofongá 'o hangē ko te la'aá, pea ko Tono 'ū kofú ne'e hina ekiaki 'o hangē ko te maamá. ");
INSERT INTO num_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Pea vakai, ne'e hā kiā nātou 'ia Mōsese mo 'Ilaisiā 'oku notou talanoa mo Ia. ");
INSERT INTO num_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pea iange 'e Pita kiā Sīsū, “'Aliki, 'oku sai te tou 'i hení; kāpau 'e Ke loto ki ai, pea tuku ke motou ngaahi 'i heni he palepale 'e tolu, 'o taha Mo'ou, pea taha mo'o Mōsese, pea taha mo'o 'Ilaisiā.” ");
INSERT INTO num_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pea 'i te kei lea 'ia Pitá, fokifā pē kua fakapūlou'i 'aki nātou 'ia te 'ao ngingila. Pea ne'e ongo mai he le'o mei te 'aó, ne'e folafola mai, “Ko Toku 'Alo Pelé 'eni, 'a ia 'Okou hōifua ki Aí; kotou fakaongo kiā Ia!” ");
INSERT INTO num_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pea 'i te notou fanongo ki aí, ne'e notou tō fo'oifo ki lalo, mo notou manahē 'aupito. ");
INSERT INTO num_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Pea ha'u 'ia Sīsū 'o ala kiā nātou, mo iange, “Tu'u, pea 'aua manahē!” ");
INSERT INTO num_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pea 'i te notou hanga aké, ne'e kailoa notou toe sio he taha, kā ko Sīsū pē. ");
INSERT INTO num_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pea 'i te notou ō ifo mei te ma'ungá, ne'e fekau 'e Sīsū kiā nātou, 'o pehē, “'Aua 'e kotou fai he talanoa ki te me'a kua haá, kae'aua ke toetu'u mei te maté 'ia te Fanautama te Tangatá.” ");
INSERT INTO num_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Pea fehu'i kiā Ia 'e te kau akó, 'o pehē, “Ko te ā tono 'uhinga 'o te pehē 'e te kau sikalaipé, kua pau ke fu'aki ha'u 'ia 'Ilaisiaá?” ");
INSERT INTO num_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Pea tali 'e Ia 'o pehē, “Ko te mo'oni, 'e fu'aki ha'u 'ia 'Ilaisiā, 'o fakatonutonu 'ia te me'a kotoa pē. ");
INSERT INTO num_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kā 'Okou tala'i atu, kua 'osi ha'u 'ia 'Ilaisiā, ka ne'e kailoa notou 'ilo'i ia, pea ne'e notou fai te notou lotó kiā Ia. 'Io, 'e pehē pē foki mo te notou ngaahikovi'i 'ia te Fanautama te Tangatá.” ");
INSERT INTO num_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Pea toki mahino leva ki te kau akó, tā ko Sione Papitaiso 'oku kau ki ai Tana leá. ");
INSERT INTO num_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pea 'i te notou ha'u ki te kakaí, ne'e ha'u he tangata, 'o tū'ulutui kiā Ia, 'o pehē, ");
INSERT INTO num_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“'Aliki, 'ofa mai mu'a ki toku 'uhikí, he kua puke 'i te mahaki moá, pea mamahi lahi; kua tu'a lahi tana tō ki te afí, pea tu'a lahi tana tō ki te vaí. ");
INSERT INTO num_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Pea ne au 'aumai 'ona ki Tau kau akó, ka ne'e kailoa notou lava si'ana fakama'uli!” ");
INSERT INTO num_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Pea tali ange 'e Sīsū 'o pehē, “'Ia te fa'ahinga ta'etui mo anga-kehe, 'e ngata 'āfea Taku 'iā kōtoú? 'E ngata 'āfea Taku kātaki'i 'ia kōtoú? 'Aumai 'ona ki heni kiā Au.” ");
INSERT INTO num_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Pea ne'e lolomi 'e Sīsū 'ia te tēvoló, pea mahu'i ia mei te tamá, pea ne'e ma'uli ia 'i te taimi pē ko iá. ");
INSERT INTO num_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pea toki ōmai te kau akó 'iā nātou pē kiā Sīsū, 'o notou 'eke ange, “Ko te ā ne'e kailoa motou lava ai ke kapusi iá?” ");
INSERT INTO num_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Pea pehē Ia kiā natou, “Kote'uhí pē ko te kotou tui vaivaí. He 'Okou tala mo'oni atu kiā kōtou, kā ne 'i ai he kotou tui, 'o tatau mo te fe'i pulapula'i mūsitá tono lahí, 'e kotou pehē ki te ma'unga nei, ‘Hiki mei heni ki hená,’ pea 'e hiki ia. Pea 'e kailoa he me'a 'e faingata'a kiā kōtou. ");
INSERT INTO num_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kā neongo ia, ko te fa'ahinga nei 'oku kailoa lava ia ke mahu'i, kā 'i te lotu pē mo te 'aukai.” ");
INSERT INTO num_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Pea 'i te lolotonga te notou fakataha 'i Kālelí, ne'e lea ange 'e Sīsū kiā nātou, 'o pehē, “'E tukuange 'ia te Fanautama te Tangatá ki te nima 'o te kakaí, ");
INSERT INTO num_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","pea 'e notou tāmate'i 'Ona, pea 'i tono 'aho tolú 'e toe fokotu'u Ia mei te maté.” Pea ne'e notou loto mamahi 'aupito. ");
INSERT INTO num_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pea notou a'u ki Kāpaneume, pea ko nātou ne'e tānaki 'ia te tukuhau fakasiasí ne notou ō atu kiā Pita, 'o iange, “'Oku kailoa koā fai 'e te kotou Tangata'alikí 'ia te tukuhau Temipalé?” ");
INSERT INTO num_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pea iange ia, “'Io.” Kā 'i tana hū ki falé ne'e iange 'e Sīsū kiā ia, 'o pehē, “'E Saimone, ko te ā tau laú? Ko te 'ū tu'i 'o māmaní 'oku notou tānaki tute mo te tukuhau meiā ai: mei te fale'aló, pe mei te kakai kehé?” ");
INSERT INTO num_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pea tali ange ia, “Mei te kakai kehé pē.” Pea pehē ange 'e Sīsū kiā ia, “'Āua, pea tā 'oku 'ata'atā 'ia te fale'aló ia. ");
INSERT INTO num_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kā kote'uhí ke 'aua na'a tou fakatupu 'ita kiā nātou, 'alu mu'a koe ki tai, 'o lafo he māta'u; pea ko te 'uluaki ika 'e kaí, 'e ke to'o 'o fa'ai tono ngutú, pea 'e ke 'ilo'i ai he fe'i sikeli; to'o ia 'o 'avange kiā nātou Ma'aku mo koe.” ");
INSERT INTO num_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Pea 'i te 'aho ko iá ne'e ōmai te kau akó kiā Sīsū, 'o notou pehē, “Ko ai 'oku lahi taha 'i te Pule'anga 'o Hēvaní?” ");
INSERT INTO num_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Pea ui mai 'e Ia he tamasi'i ke 'alu ange, 'o Ina tuku 'i te notou lotolotongá, ");
INSERT INTO num_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","'o pehē ange Ia, “'Okou tala mo'oni atu kiā kōtou, kāpau 'e kailoa kotou liliu, 'o hoko ke hangē ko te fanga ki'i tamalikí, 'e kailoa 'aupito kotou hū ki te Pule'anga 'o Hēvaní. ");
INSERT INTO num_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ko ia ai, ko ia ko 'ē 'e fakavaivai'i 'ona 'o hangē ko te tamasi'i ko 'ení, ko ia ia 'oku lahi 'i te Pule'anga 'o Hēvaní. ");
INSERT INTO num_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pea kā 'i ai he taha 'oku tali he tamasi'i pehē 'e toko taha, kote'uhí ko Toku hingoá, 'oku tali 'e ia 'Oku. ");
INSERT INTO num_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Pea kā 'i ai he tangata 'e fakatūkia'i he taha 'o te fa'ahinga liliki nei 'oku tui kiā Aú, 'e sai ange ki te tangata ko iá kāpau ne'e tautau he fu'u maka 'i tono kiá, 'o lōmaki'i 'ona 'i te moana lolotó. ");
INSERT INTO num_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","'E mala'ia 'ia māmani kote'uhí ko te kau tūkia'angá! He kua pau 'e hoko mai 'ia te kau tūkia'anga; kae pohoē 'ia te tangata, 'a ē 'e ha'u mei ai 'ia te tūkia'angá! ");
INSERT INTO num_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Pea kāpau 'oku fakatūkia'i 'ou 'e tou nimá, pe ko tou va'é, tu'usi ia, pea si'aki atu. 'Oku ngutuhua ange tau a'u ki te ma'ulí nima taha pe va'e taha, 'i tono sī nima ua pe va'e ua 'ou ki te afi ta'engatá. ");
INSERT INTO num_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Pea kāpau 'oku fakatūkia'i 'ou 'e tou matá, kape'i ia, 'o si'aki. 'Oku ngutuhua ange hau a'u mata taha ki te ma'ulí, 'i tono sī mata ua 'ou ki te afi 'o helí. ");
INSERT INTO num_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Vakai ke 'aua na'a kotou fakasītua'i he taha 'o te fa'ahinga liliki nei. Hē 'Okou tala'i atu, ko te notou kau 'āngelo 'i te langí 'oku notou fakafe'ao ma'u pē ki Taku Tamai 'oku 'i hēvaní. ");
INSERT INTO num_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","He kua ha'u 'ia te Fanautama te Tangatá ke fakama'uli 'ia nātou ne'e molé. ");
INSERT INTO num_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ko te ā he kotou lau? Kā ne ma'u he tangata he sipi 'e teau, pea hē he notou taha, 'e kailoa koā ina tuku 'ia te toko hivangofulu mā hivá 'i te ma'ungá, kae 'alu ke kumi 'ia te taha kua heé? ");
INSERT INTO num_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Pea kāpau 'e 'ilo'i 'e ia 'ona, 'Okou tala mo'oni atu kiā kōtou, 'oku lahi ange tana fiafia 'i te fe'i sipi ko iá, 'i te hivangofulu mā hiva ne'e kailoa heé. ");
INSERT INTO num_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Pehē foki, 'oku kailoa ko te finangalo 'o te kotou Tamai 'oku 'i hēvaní ke mole he fe'i toko taha 'o te fa'ahinga liliki nei. ");
INSERT INTO num_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Pea kāpau 'e faihala atu tou tokouá kiā koe, 'alu 'ia koe 'o fakamahino kiā ia, 'o fakaekōlua pē. Kāpau 'e tokanga ia kiā koe, kua ke ma'u mai tou tokouá. ");
INSERT INTO num_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kae kā kailoa ina tokanga, ke toe 'alu mo koe he toko taha pe toko ua, kote'uhí ke fakapapau'i 'ia te 'ū me'á mei te fakamo'oni 'a te toko ua pe toko tolu. ");
INSERT INTO num_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pea kāpau 'e kailoa toka'i 'e ia 'ia nātou, pea tala ki te siasí. Pea kāpau 'e kailoa toka'i 'e ia mo te siasí foki, pea ke tatau ia kiā koe mo te hīteni pē ko te tānaki tukuhau. ");
INSERT INTO num_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","'Okou tala mo'oni atu kiā kōtou, ko te me'a kotoa pē 'e kotou tapui 'i māmani 'e tapui 'i hēvani; ko te me'a kotoa pē 'e kotou fakangafua 'i māmani 'e fakangafua 'i hēvani. ");
INSERT INTO num_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Pea 'Okou tala'i atu kiā kōtou foki, kā 'i ai he toko ua 'iā kōtou 'i māmani 'e nā loto taha he me'a pē 'e nā kole ki ai, 'e fai pē ma'a nāua 'e Taku Tamai 'oku 'i hēvaní. ");
INSERT INTO num_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","He ko te feitu'u kua fakataha 'i ai he toko ua pe te toko tolu 'i Toku hingoá, 'e Au 'i ai mo nātou.” ");
INSERT INTO num_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ne'e toki ha'u 'ia Pita kiā Ia, 'o pehē, “'Aliki, 'e tu'a fia te faihala mai toku tokouá kiā au, kae au fakamolemole'i pē? 'E tu'a fitu nai?” ");
INSERT INTO num_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Pea iange 'e Sīsū, “'Oku kala U pehē kiā koe, 'e tu'a fitu, kā, 'e tu'a fitungofulu liunga 'aki te fitu. ");
INSERT INTO num_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ko ia 'oku tatau 'ia te Pule'anga 'o Hēvaní mo he tu'i, ne'e finangalo ke sivi'i te fakamatala pa'anga tana kau tamaio'alikí. ");
INSERT INTO num_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pea 'i tana kamata te siví, ne'e 'aumai kiā ia he toko taha ne'e ma'ua ko te talēniti 'e taha mano. ");
INSERT INTO num_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pea 'i te kailoa hana me'a ke totongi 'akí, ne'e fekau tana 'alikí ke fakatau tuki 'ona, mo tono malí, mo te fānaú, mo tana me'a kotoa pē, ke totongi 'aki. ");
INSERT INTO num_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kā ne tōmape'e 'ia te tamaio'alikí 'o kole fakamātoato kiā ia, mo kole ange, ‘Tuku mai mu'a si'aku faingamālie, pea 'e au totongi fuli pē kiā koe.’ ");
INSERT INTO num_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Pea manava'ofa ai 'ia te 'alikí ki te tamaio'aliki ko iá, 'o tukuange 'ona, mo fakamolemole'i tono ma'uá kotoa pē. ");
INSERT INTO num_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kā 'i te 'alu atu te tamaio'aliki ko iá, ne ina 'ilo'i atu he toko taha 'o tana kaungā tamaio'alikí, ne'e ma'ua kiā ia ko te tēnali 'e teau. Pea puke'i 'e ia 'ona 'o sisina tono kiá, mo iange, ‘Totongi mai leva tou ma'uá!’ ");
INSERT INTO num_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kā ne tōmape'e 'ia te toko taha ne nā kaungā ngāué, 'o kole ange kiā ia, ‘Tuku mai mu'a si'aku faingamālie, pea 'e au totongi kiā koe.’ ");
INSERT INTO num_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ka ne'e kailoa tali 'e ia tana kolé; kae 'alu ia 'o sī 'ona ki te pilīsoné, kae'aua ke totongi 'osi mai tono 'ū ma'uá. ");
INSERT INTO num_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kā ko tono kaungā tamaio'alikí, 'i te notou vakai ki te me'a kua faí, ne'e notou mamahi 'aupito, 'o notou ō 'o fakamatala ki te notou 'alikí 'ia te me'a kotoa pē kua faí. ");
INSERT INTO num_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Toki ui ange te tamaio'alikí 'e tana 'alikí, 'o iange ki ai, ‘'Ia te tamaio'aliki anga-kovi, ne au fakamolemole'i 'ou 'i tou fu'u ma'uá kotoa pē ko te me'a 'i tau kole maí. ");
INSERT INTO num_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Pea ne'e kailoa koā mei totonu tau 'ofa mo koe kiā ia 'oku kulā kaungā ngāué, 'o hangē ko taku 'ofa kiā koé?’ ");
INSERT INTO num_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Pea 'ita ai tana 'alikí, 'o tukuange 'ona ki te kau fakamamahí, kae'aua ke totongi mai kotoa pē 'ia te 'ū me'a ne'e ma'ua ki aí. ");
INSERT INTO num_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","'E pehē pē foki mo te fai Taku Tamai Fakalangí kiā kōtou, 'o kāpau 'e kailoa kotou fakamolemole'i mo'oni he taha 'e ma'ua atu.” ");
INSERT INTO num_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pea kua faka'osi 'e Sīsū Tana faiakó, pea 'alu leva Ia mei Kāleli, 'o a'u atu ki te 'ū feitu'u 'o Siutea 'i Tu'a-Sioataní. ");
INSERT INTO num_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Pea ne'e mulimuli kiā Ia he fu'u kakai tokolahi, pea ne'e fakama'uli 'e Ia 'ia nātou 'i ai. ");
INSERT INTO num_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pea ha'u kiā Ia 'ia te kau Fālesí ke 'ahi'ahi'i 'Ona, 'o notou pehē, “'Oku ngafua koā ke vete to'otó malí he fa'ahinga 'uhinga pē?” ");
INSERT INTO num_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Pea tali Ia, 'o pehē, “Ne'e kailoa kotou lau koā, ko Ia ne'e ngaahi 'ia te kakaí 'i te kamata'angá ne'e ngaahi nāua ko te tangata mo te fafine, ");
INSERT INTO num_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","pea mo te Folafola, ‘Ko te me'a ko iá 'e tukuange ai he tangata tana tamaí mo tana fa'eé, kae pīkitai ki tono 'unohó; pea 'e hoko 'ia te toko uá ko te kakano pē taha’? ");
INSERT INTO num_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tā 'oku kailoa nā kei ua, kā ko te kakano pē taha. 'Āua, pea ko te me'a kua fakahoko 'e te 'Atuá, ke 'aua na'a fakamāvae he tangata.” ");
INSERT INTO num_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pea notou iange kiā Ia, “Kāpau ko ia, pea ko te ā ne'e tu'utu'uni ai 'e Mōsese ke 'avange he tohi vete, 'o tukuangé?” ");
INSERT INTO num_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Pea iange Ia kiā nātou, “Ko te me'a 'i te fefeka te kotou lotó, ko ia ne'e fakangafua ai 'e Mōsese ke kotou vete te kotou 'unohó; ka ne'e kailoa pehē ia 'i te kamata'angá. ");
INSERT INTO num_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kā 'Okou tala'i atu 'eni kiā kōtou, kā 'i ai he taha 'e vete tono 'unohó, 'o kailoa kote'uhí ko tana fe'auaki, pea toki mali ia mo he fafine kehe, 'oku fe'auaki ia; pea ko ia 'e mali mo ia kua veté, 'oku tono fafine ia.” ");
INSERT INTO num_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Pea iange Tana kau akó kiā Ia, “Kāpau ko tono anga ia 'o te tangatá mo tono 'unohó, tā 'oku sai ange pē te nofo ta'emalí ia.” ");
INSERT INTO num_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kae toki iange Ia kiā natou, “'E kailoa tali te me'a ko iá 'e te kakai kotoa pē, ngata pē 'iā nātou kua tuku ki aí. ");
INSERT INTO num_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","He 'oku 'i ai te fa'ahinga 'iunoke 'oku tupu pehē mei te manava te notou fa'eé; pea 'oku 'i ai te fa'ahinga 'iunoke kua ngaahi ke 'iunoke 'e te tangatá; pea 'oku 'i ai te fa'ahinga 'iunoke kua notou ngaahi nātou ke pehē, kote'uhí ko te Pule'anga 'o Hēvaní. Ko ia ko 'ē 'oku malava ke talí, ke pehē pē ia.” ");
INSERT INTO num_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ne'e toki 'aumai kiā Ia he tamaliki liliki ke hilifaki Tono nimá kiā nātou 'o lotua; ka ne'e lolomi 'e te kau akó 'ia te kakaí. ");
INSERT INTO num_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kae toki iange 'e Sīsū, “Tukuange pē te tamalikí ke ōmai kiā Au, 'aua 'e ta'ofi 'ia nātoú, he 'oku ma'a te fa'ahinga ko iá 'ia te Pule'anga 'o Hēvaní.” ");
INSERT INTO num_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Pea hilifaki 'e Ia Tono nimá kiā nātou, pea toki 'alu mei ai. ");
INSERT INTO num_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Pea vakai, ne'e ha'u kiā Ia he toko taha, 'o pehē, “Tangata'aliki, ko te ā he ngāue lelei ke au fai, kae au ma'u ai 'ia te ma'uli ta'engatá?” ");
INSERT INTO num_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Pea tali ange 'e Ia, “Ko te ā 'oku ke ui ai 'Oku ko te leleí? Ko te Toko Taha pē 'oku leleí. Kae kāpau ko tou lotó ke hū ki te ma'ulí, pe'i tauhi 'ia te 'ū fekaú.” ");
INSERT INTO num_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Pea iange ia, “'Ia te fea fua?” Pea iange 'e Sīsū, “'A 'eni, ‘'Aua na'a ke fakapō, 'aua na'a ke fe'auaki, 'aua na'a ke kaiha'a, 'aua na'a ke fakamo'oni lohi, ");
INSERT INTO num_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","faka'apa'apa ki tau tamaí mo tau fa'eé,’ pea, ‘'E ke 'ofa ki tou kaungā'apí 'o hangē pē ko tau 'ofa kiā koé.’ ” ");
INSERT INTO num_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Pea lea ange 'e te talavoú kiā Ia, “Kua u tauhi kātoa 'ia te 'ū fekau ko iá; ko te ā taku me'a 'oku kei toe ke au faí?” ");
INSERT INTO num_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Pea pehē ange 'e Sīsū kiā ia, “Kāpau ko tou lotó ke ke haohaoa, pe'i 'alu 'o fakatau atu tau nga'ota'otá, pea foaki tono pa'angá ki te masivá, pea 'e 'i ai he koloa 'e fa'olaki ma'au 'i hēvani; pea ke ha'u leva 'o mulimuli 'iā Au.” ");
INSERT INTO num_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pea 'i te fanongo 'e te talavoú ki te lea ko iá ne'e foki ia kua mamahi, he ko te tama koloa'ina ia. ");
INSERT INTO num_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Pea pehē 'e Sīsū ki Tana kau akó, “'Okou tala mo'oni atu kiā kōtou, 'e faingata'a 'aupito ke hū he taha koloa'ina ki te Pule'anga 'o Hēvaní. ");
INSERT INTO num_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","'Io, 'Okou toe lea atu, 'oku faingafua ange ke hū he kāmeli 'i te ava'i hui tuitui, 'i te hū he koloa'ina ki te Pule'anga 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pea 'i te fanongo ki ai 'e te kau akó ne'e notou fu'u ofo lahi, 'o notou pehē, “Pea ko ai tū 'e ala ma'uli?” ");
INSERT INTO num_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Pea siofia 'ia nātou 'e Sīsū, 'o iange, “'I te vakai 'a te tangatá ko te me'a ia 'e kailoa malava; kā ki te 'Atuá 'oku malava 'ia te me'a kotoa pē.” ");
INSERT INTO num_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pea toki lea ai 'ia Pita, 'o pehē ki ai, “Vakai, ko mātou 'eni kua motou si'aki 'ia te me'a kotoa pē, 'o motou mulimuli kiā Koe. Ko te ā he me'a 'e motou ma'u aí?” ");
INSERT INTO num_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Pea iange 'e Sīsū kiā nātou, “'Okou tala mo'oni atu kiā kōtou, 'ia kōtou kua mulimuli kiā Aú, kā hoko mai 'ia te fakatupu fo'oú, pea nofo 'ia te Fanautama te Tangatá 'i Tono taloni lāngilangi'iná, 'e fakanofo 'ia kōtou foki ki te taloni 'e hongofulu mā ua, 'o kotou fakamāu'i 'ia te matakali 'e hongofulu mā ua 'o 'Isilelí. ");
INSERT INTO num_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","'Io, ko ia kotoa pē kua ina si'aki he 'ū fale, pe 'ū tokoua, pe 'ū tu'afāfine, pe tamai, pe fa'ē, pe fānau, pē he 'ū tōkanga ngoue, kote'uhiā ko Toku hingoá, 'e toe ma'u ia 'o lōteau, pea 'e ma'u foki ia 'ia te ma'uli ta'engatá. ");
INSERT INTO num_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kā ko te tokolahi 'oku mu'amu'á 'e notou mulimuli; pea ko te tokolahi 'o te kau mulimulí 'e notou mu'amu'a. ");
INSERT INTO num_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“He ko te Pule'anga 'o Hēvaní 'oku tatau mo te tangata'aliki, ne'e 'alu atu hengihengi ke unga he 'ihi ke ngāue 'i tana ngoue vainé. ");
INSERT INTO num_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Pea ne'e alea ia mo te kau ngāué, ko te fe'i tēnali ki te 'aho, 'o fekau atu 'ia nātou ki tana ngoue vainé. ");
INSERT INTO num_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pea 'alu atu ia 'i te hiva pongipongí, 'o 'ilo'i he 'ihi 'oku notou tutu'u noa pē 'i te mala'e fakataú, ");
INSERT INTO num_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","pea iange ia kiā nātou, ‘'Alu mo kōtou ki te ngoue vainé, pea 'e au 'avatu kiā kōtou tono taaú.’ Pea notou 'alu. ");
INSERT INTO num_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Pea toe 'alu atu ia, 'o fe'unga mo te ho'atā mālié, pea mo te tolu afiafí, 'o fai pehē foki. ");
INSERT INTO num_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pea fe'unga mo te nima afiafí ne'e 'alu atu ia, pea tā ne'e 'i ai mo te 'ihi 'oku notou tutu'u pē; pea iange ia kiā nātou, ‘Ko te ā 'oku kotou tutu'u noa ai pē heni 'i te 'aho nei kakato?’ ");
INSERT INTO num_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Pea notou iange kiā ia, ‘Kote'uhí ko te kailoa he taha 'e fia unga 'ia mātoú.’ Pea lea ange ia, ‘Kotou ō mo kōtou foki ki te ngoue vainé.’ ");
INSERT INTO num_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Pea 'i tana afiafí leva, ne'e lea te 'aliki 'o te ngoue vainé ki tana taki ngāué, ‘Ui te kau ngāué, 'o tufa te notou totongí, 'o kamata mei te mulimuli maí 'o fai atu ki te mu'amu'a maí.’ ");
INSERT INTO num_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Pea ha'u 'ia nātou ne'e unga fe'unga mo te nima afiafí, 'o notou taki taha ma'u te fe'i tēnali. ");
INSERT INTO num_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pea 'i te ha'u 'ia nātou ne'e fu'aki ungá, 'o notou 'amanaki 'e lahi ange ta'a nātoú me'a; kā ko nātou foki ne'e notou ma'u taki taha te fe'i tēnali. ");
INSERT INTO num_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pea 'i te notou to'o iá, ne'e notou lāunga ki te tangata'alikí ");
INSERT INTO num_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","'o notou pehē ange, ‘'Ē, ko te kau siana ne'e mulimuli maí ko te fe'i houa pē taha ne'e notou ngāue'í, pea ko 'eni kua ke fakatatau 'ia nātou kiā mātou, 'a ē kua motou fua tono mamafa 'o te ngāué, pea fetakai mo te pupuha 'o te 'ahó!’ ");
INSERT INTO num_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ka ne'e tali pē ia, 'o iange ki te notou toko taha, ‘Siana, he 'okou kākaa'i 'ou? Ne'e kailoa koā tā alea ke fe'i tēnali 'e taha? ");
INSERT INTO num_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","To'o pē tau me'á 'o 'alu. Ko te 'avange ki te mulimuli maí 'o tatau mo koé ko te me'a fa'italiha pē ia 'a'aku. ");
INSERT INTO num_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Na'a kua kailoa koā ngafua taku fa'italiha ki ta'akú me'a? Pe na'a kua meheka 'ia koé kote'uhí ko taku 'ofá?’ ");
INSERT INTO num_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Pehē foki, ko te mulimulí 'e notou mu'amu'a, pea ko te mu'amu'á 'e notou mulimuli.” ");
INSERT INTO num_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Pea 'i te 'alu ake 'ia Sīsū ki Selusalemá, ne Ina 'ave 'ia te kau hongofulu mā uá 'o fakaenātou pē; pea 'i te notou 'i te alá ne'e iange Ia, ");
INSERT INTO num_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ko 'eni 'oku tou ō ki Selusalema, pea 'e tukuange 'ia te Fanautama te Tangatá ki te kau taula'aliki lahí mo te kau sikalaipé. Pea 'e notou fakamāu'i 'Ona ke mate; ");
INSERT INTO num_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","pea 'e notou 'avatu Ia ki te kau Senitailé ke manuki'i, mo haha, mo kalusefai; pea 'e toetu'u Ia 'i tono 'aho tolú.” ");
INSERT INTO num_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Pea ha'u kiā Ia 'ia te fa'ē 'a te ongo foha 'o Sēpetí, mo tana ongo tamá, 'o tū'ulutui, 'o fai tana kole kiā Ia. ");
INSERT INTO num_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Pea iange Ia ki te fafiné, “Ko te ā to'oú loto?” Pea pehē mai 'e ia, “Tuku mai mu'a ke nofo taku ongo tamá, ko te taha 'i Tou to'omata'ú, mo te taha 'i Tou to'ohemá, 'i Tou pule'angá.” ");
INSERT INTO num_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ka ne'e tali ange 'e Sīsū, 'o pehē, “'Oku kala kulā 'ilo'i 'ia te me'a 'oku kulā kole ki aí. He 'e kulā lava koā ke inu 'i te ipu 'Okou teu inu aí?” Pea nā pehē ange ki Ai, “'E mā lava pē.” ");
INSERT INTO num_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Pea lea Ia kiā nāua, “'E kulā inu pē 'i te ipu 'Okou inu aí; kā ko te nofo ki Toku to'omata'ú mo Toku to'ohemá, 'oku kailoa 'A'aku ke 'avatu ia, kā kiā nātou pē kua teuteu ia ki ai 'e Taku Tamaí.” ");
INSERT INTO num_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pea 'i te fanongo ki ai te toko hongofulú, ne'e notou 'ita 'i te ongo tautēhiná. ");
INSERT INTO num_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kae ui ange nātou 'e Sīsū, 'o iange, “'Oku kotou 'ilo'i pē, ko te 'ū 'aliki 'o te Senitailé 'oku notou fa'a pule ki te kakaí, pea ko te notou kau mā'olungá 'oku notou holi ke angi'i holo 'ia te kakaí. ");
INSERT INTO num_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kā 'e kailoa pehē 'ia kōtou ia; kā ko ia 'oku holi ke hoko ko te lahi 'iā kōtoú, 'e nofo ia ko te kotou sevāniti, ");
INSERT INTO num_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","pea ko ia 'oku holi ke hoko ko te kotou tu'ukimu'á, 'e nofo ia ko te kotou tamaio'aliki; ");
INSERT INTO num_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","'o hangē foki ko te Fanautama te Tangatá ne'e kailoa ha'ú Iá ke ma'u sevāniti, kā ke sevāniti pē 'e Ia, pea ke tuku Tana ma'ulí ke huhu'i 'aki he tokolahi, 'i Tana fetongi 'ia nātou.” ");
INSERT INTO num_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Pea 'i te notou ō atu mei Selikoó, ne'e mulimuli kiā Ia he fu'u kakai tokolahi. ");
INSERT INTO num_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Pea tā ko te ongo kui 'oku nā nonofo 'i te va'ealá; pea 'i te nā fanongo 'oku me'a ange 'ia Sīsuú, ne'e nā kalanga 'o pehē, “'Aliki ē, Hako 'o Tēvitá, 'alo'ofa mai!” ");
INSERT INTO num_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ka ne'e lolomi nāua 'e te kakaí ke nā fakalongolongo: kae toe 'āsili ange ai te nā kalangá, “'Aliki ē, Hako 'o Tēvitá, 'alo'ofa mai!” ");
INSERT INTO num_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Pea tu'u 'ia Sīsū, 'o 'eke ange kiā nāua, “Ko te ā te me'a 'oku kulā holi ke Au fai ma'a kōluá?” ");
INSERT INTO num_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Pea nā iange, “'Aliki ē, faka'ā mu'a te mā poko'i matá!” ");
INSERT INTO num_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Pea ne'e langa te fatu 'o Sīsuú 'i te 'ofa, 'o Ina ala ki te nā 'ū fe'i matá. Pea nā 'a'ala leva, 'o mulimuli kiā Ia. ");
INSERT INTO num_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Pea 'i te notou ofi ki Selusalemá, 'o a'u atu ki Petefesi 'i te ma'unga ko 'Ōlivé, ne'e toki fekau atu 'e Sīsū he ongo tama ako 'e toko ua, ");
INSERT INTO num_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","'o iange kiā nāua, “Kulā ō ki te ki'i kolo ko 'ena 'oku hanga maí, pea 'e kulā 'ilo'i ai he 'asi 'oku nono'o, pea 'i ai mo tono 'uhiki; vete ia, 'o taki mai. ");
INSERT INTO num_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pea kā 'eke atu he taha, pea kulā iange, ‘'Oku fia ma'u nāua 'e te 'Alikí;’ pea 'e ina tuku mai leva 'ia nāua.” ");
INSERT INTO num_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Pea ne'e fai 'eni kote'uhí ke fakamo'oni ki te me'a ne'e folafola 'aki 'e te palōfitá, 'o pehē, ");
INSERT INTO num_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kotou lea ki te ta'ahine Saioné, ‘Vakai, ko tou Tu'í 'ena 'oku me'a mai kiā koe. Ko te 'Aliki 'oku anga-malū, 'a ia 'oku heka ki te 'asi, 'io, ki te ki'i monumanu, ko te 'uhiki 'o he 'asi.’ ” ");
INSERT INTO num_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Pea ō te ongo tama akó, 'o fai 'ia te me'a ne'e fekau'i nāua ki ai 'e Sīsuú. ");
INSERT INTO num_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Pea nā taki mai 'ia te 'así mo tono 'uhikí, pea notou 'ai ki ai te notou 'ū pulupulú, pea toki heka 'ia Sīsū ki ai. ");
INSERT INTO num_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Pea folahi atu 'e te kakai tokolahi te notou pulupulú 'i te loto alá; pea hanga 'e te 'ihi 'o tu'usi he 'ū va'a 'akau, 'o falikiliki 'aki te alá. ");
INSERT INTO num_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Pea ko te fu'u kakai ne'e notou ō mu'amu'a 'iā Iá, mo nātou ne'e mulimuli maí, ne'e notou kalakalanga 'o pehē, “Hōsana ki te Hako 'o Tēvitá! 'Oku manū'ia Ia 'oku hā'ele mai 'i te huafa 'o te 'Alikí! Hōsana 'i Langi Taupotu!” ");
INSERT INTO num_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pea 'i Tana hū ki Selusalemá, ne'e ngatū 'ia te koló fuli pē, 'o notou fe'eke, “Ko ai 'eni?” ");
INSERT INTO num_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Pea tali mai mei te fu'u kakaí, “Ko Sīsū 'eni, ko te palōfita mei Nāsaleti 'i Kālelí.” ");
INSERT INTO num_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Pea hū 'ia Sīsū ki te Temipalé, 'o kapusi 'ia nātou fuli pē ne'e fakatau atu mo fakatau mai 'i te Temipalé, 'o fulihi 'ia te 'ū tēpile 'a te kau fetongi pa'angá, mo te 'ū nofo'a 'o te kakai ne'e fakatau lupé. ");
INSERT INTO num_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Pea folafola Ia kiā nātou, “Kua tohi, ‘Ko Toku falé 'e ui ko te falelotu;’ kā kua kotou ngaahi ia ko te 'ana 'o he kau kaiha'a!” ");
INSERT INTO num_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Pea ne'e ōmai kiā Ia 'i te Temipalé he kau kui mo he kau heke, pea ne Ina fakama'uli 'ia nātou. ");
INSERT INTO num_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kā ko te kau taula'aliki lahí mo te kau sikalaipé, 'i te notou vakai ki te 'ū me'a fakaofo ne'e fai 'e Sīsuú, mo te tamaliki ne'e notou kalakalanga 'i te Temipalé, 'o pehē, “Hōsana ki te Hako 'o Tēvitá,” ne'e notou 'ita lahi, ");
INSERT INTO num_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","'o notou iange kiā Ia, “'Oku fanongo koā 'e Koe ki te me'a 'oku lau 'e nātou nā?” Pea folafola ange 'e Sīsū, “'Io; kua he'iki ai koā kotou lau, 'o pehē, ‘Ko te ngutu 'o te tamalikí mo te valevalé kua Ke tu'utu'uni mei ai To'oú fakamālō’?” ");
INSERT INTO num_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pea tukuange 'e Ia 'ia nātou, 'o 'alu ki te kolo 'o Pētaní, 'o toka 'i ai. ");
INSERT INTO num_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pea 'i te pongipongi aké, 'i Tana foki ki te koló, ne'e hālofia Ia. ");
INSERT INTO num_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Pea 'i Tana vakai ki te fu'u fiki 'oku tu'u 'i te va'ealá, ne'e 'alu Ia ki ai; ka ne'e kala 'ilo'i ai 'e Ia he fe'i fua, kā ko te 'ū laú pe. Pea folafola Ia ki ai, 'o pehē, “Ke 'aua na'a toe 'i ai hau fua 'o ta'engata.” Pea mae leva 'ia te fu'u fikí. ");
INSERT INTO num_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pea 'i te mamata ki ai 'e te kau akó, ne'e notou ofo, 'o notou pehē, “Ne fefe'aki tana mae vave pehē 'ia te fu'u fikí?” ");
INSERT INTO num_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Pea tali 'e Sīsū 'o iange kiā nātou, “'Okou tala mo'oni atu kiā kōtou, kāpau 'e kotou tui, 'o 'aua tāla'a, 'e kailoa ngata 'i te me'a kua fai ki te fikí 'ia te me'a 'e kotou lavá; kae kāpau 'e kotou lea ki te ma'unga nei, ‘Fei mo mahiki 'ia koe, 'o patū ki tai;’ pea 'e hoko ia. ");
INSERT INTO num_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Pea ko te me'a kotoa pē 'e kotou kole 'i te lotu, 'o kotou tui pē, 'e kotou ma'u.” ");
INSERT INTO num_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Pea kua Ina hū ki te Temipalé, pea ko te kau taula'aliki lahí mo te kau mātu'a 'o te kakai Siú ne'e notou ōmai kiā Ia 'i Tana faiakó, 'o notou pehē, “Ko te mafai mei fea 'oku fai ai 'e Koe 'ia te 'ū me'a nei? Pea ko ai ne'e tuku kiā Koe 'ia te mafai ko iá?” ");
INSERT INTO num_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Pea tali 'e Sīsū kiā nātou, “Ke fai atu mo Au Taku fehu'i 'e taha, pea kāpau 'e kotou tali mai, pea 'e Au toki fakahaa'i atu pe ko te ā Toku mafai 'Okou fai ai 'ia te 'ū me'a neí. ");
INSERT INTO num_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ko te fai papitaiso 'a Sioné ne'e mei fea ia? Mei hēvani, pe mei te tangatá?” Pea notou fekīhiaki, 'o pehē, “Kāpau 'e tou tali, ‘Mei hēvani,’ 'e pehē mai Ia, pea ko te ā ne kala kotou tuitala ai kiā iá? ");
INSERT INTO num_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pea kāpau 'e tou pehē, ‘Mei te tangatá,’ kae talia te kakaí; he 'oku notou lau kotoa pē ko te palōfita 'ia Sione.” ");
INSERT INTO num_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Pea notou iange kiā Sīsū 'o pehē, “'Oku kala motou 'ilo'i.” Pea iange 'e Ia kiā natou, “Pea 'e kailoa ā ke Au tala'i atu 'e Au, 'ia te mafai ko ia 'Okou fai ai 'ia te 'ū me'a nei.” ");
INSERT INTO num_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Kā ko te ā te kotou laú? Takua ne'e 'i ai he tangata mo tono ongo foha; pea ha'u ia ki te lahí, 'o iange kiā ia, ‘Tama, 'alu mu'a 'o ngāue 'i te ngoue vainé 'i te 'aho nei.’ ");
INSERT INTO num_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Kae tali ange ia, 'o pehē, ‘'E kala u 'alu;’ ka ne'e tautea tono lotó ki muli, 'o 'alu. ");
INSERT INTO num_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Pea ha'u ia ki te tama 'e tahá, 'o lea kiā ia 'i te me'a tatau. Pea tali ange ia, 'o pehē, ‘'Oku lelei, Tangata'aliki;’ kā ne'e kailoa 'alu ia. ");
INSERT INTO num_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ko ai 'iā nāua ne'e fai ki te tu'utu'uni 'a te tamaí?” Pea notou pehē, “Ko te foha lahí.” Pea pehē 'e Sīsū kiā nātou, “'Okou tala mo'oni atu kiā kōtou, ko te kau tānaki tukuhaú mo te kau fe'auakí 'oku notou takimu'a 'iā kōtou 'i te hū ki te Pule'anga 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","He ne'e ha'u 'ia Sione kiā kōtou 'i te ala 'o te mā'oni'oní, pea ne'e kailoa kotou tui kiā ia, kā ko te kau tānaki tukuhaú mo te fe'auakí ne'e notou tui nātou. Pea ko kōtou, neongo ne'e kotou sio ki ai, ka ne'e kailoa kotou fia fakatomala, ke kotou tui ai kiā ia. ");
INSERT INTO num_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Kotou fanongo mai ki te talanoa fakatātā 'e taha. Takua ne'e 'i ai he tangata, ne'e tō tana ngoue vaine, pea ne'e 'aa'i takai ia, mo keli 'i ai he tata'o'anga kālepi, pea langa foki mo te taua 'i ai, pea ne ina tuku atu ke lisi 'e te kau fa'a, kae 'alu ia ki te fanua muli. ");
INSERT INTO num_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Pea 'i te ofi 'ia te to'ukai kālepí, ne ina fekau atu tana kau tamaio'alikí ki te kau fa'á ke ma'u mai tono 'inasí. ");
INSERT INTO num_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ka ne'e puke 'e te kau fa'á tana kau tamaio'alikí, 'o notou haha te toko taha, pea tāmate'i te toko taha, pea tolomaka'i mo te toko taha. ");
INSERT INTO num_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Pea ne ina toe fekau atu mo he tu'unga tamaio'aliki kehe, 'o tokolahi 'i te fu'aki oó; pea notou ngaahikovi'i 'ia nātou foki 'o tatau mo nātou ne'e fu'aki oó. ");
INSERT INTO num_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pea ne ina fekau atu ki muli mai tono fohá, 'i tana pehē, ‘'E notou toka'i toku fohá.’ ");
INSERT INTO num_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kā 'i te mamata 'e te kau fa'á ki te fohá, ne'e notou alea, 'o pehē, ‘Ko te 'eá 'ena; 'ē, tou tāmate'i mu'a ia, kae tou ma'u tono tofi'á.’ ");
INSERT INTO num_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Pea notou puke ia 'o toho ki te tu'a ngoué, 'o tāmate'i 'ona 'i ai. ");
INSERT INTO num_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Pea kā hoko mai 'ia te 'aliki 'o te ngoue vainé, ko te ā tana me'a 'e fai ki te kau fa'a ko iá?” ");
INSERT INTO num_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Pea notou pehē kiā Ia, “'E ina faka'auha fakalialia'i 'ia te kau faikovi ko iá, pea tuku ke lisi te ngoué 'e te kau fa'a kehe, 'a ia 'e notou 'avange tono 'inasí 'i tono taimi totonu.” ");
INSERT INTO num_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Pea pehē ange 'e Sīsū kiā natou, “Kua he'iki ai koā kotou lau 'i te Tohitapú, ‘Ko te maka ne fakata'e'aonga'i 'e te kau tufungá, kua hoko ko te fungani maka 'o te tulikí. Ko te me'a mei te 'Alikí ia, pea fakaofo ki te tou matá?’ ");
INSERT INTO num_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ko ia 'Okou tala'i atu, 'e fa'ao meiā kōtou 'ia te Pule'anga 'o te 'Atuá, pea 'e 'avange ia ki te kakai 'oku notou ma'u 'ia te fua 'oku taau mo iá. ");
INSERT INTO num_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Pea ko ia ko 'ē 'e tō ki te maka ko iá 'e mafasifasi; kā ko ia 'e tō 'ia te maká ki aí, 'e laiki 'ona ke efu.” ");
INSERT INTO num_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pea 'i te fanongo 'e te kau taula'aliki lahí mo te kau Fālesí ki Tana 'ū talanoa fakatātaá, ne'e notou 'ilo'i 'oku 'uhinga Tana leá kiā nātou. ");
INSERT INTO num_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Pea ne'e notou feinga ke puke Ia, ka ne'e notou manahē ki te kakaí, he ne'e notou lau ko te palōfita 'ia Sīsū. ");
INSERT INTO num_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Pea toe fai 'e Sīsū Tana faiako kiā nātoú 'aki te 'ū talanoa fakatātā, 'o pehē, ");
INSERT INTO num_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“'Oku tatau 'ia te Pule'anga 'o Hēvaní mo he tu'i, 'a ia ne'e teu tana kātoanga ta'ane ma'a tono 'aló. ");
INSERT INTO num_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pea ne ina fekau atu tana kau tamaio'alikí ke ui mai 'ia te kau fakaafé ke notou ōmai ki te kātoangá; ka ne'e kailoa notou fia ōmai. ");
INSERT INTO num_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Pea toe fekau atu 'e ia he kau tamaio'aliki kehe, 'o pehē, ‘Fakahā kiā nātou ne'e talá: ko 'eni, kua 'osi teu taku kātoangá; kua tāmate'i taku fanga pulú, mo taku fanga manu tali 'alikí, pea kua maau 'ia te me'a kotoa pē. Kotou ōmai ā ki te ta'ané.’ ");
INSERT INTO num_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ka ne'e kailoa tokanga mai te kau fakaafé ia, 'o notou 'alu, ko te taha ki tana ngoue, ko te taha ki tana fai fakatau; ");
INSERT INTO num_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","pea ko te toé ne'e notou puke tana kau tamaio'alikí, 'o ngaahikovi'i mo tāmate'i. ");
INSERT INTO num_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Pea houhau ai 'ia te tu'í, 'o fekau atu tana 'ū kongakaú, 'o faka'auha 'ia te kau fakapō ko iá, mo tutu te notou koló. ");
INSERT INTO num_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Pea toki folafola ia ki tana kau tamaio'alikí, ‘Ko te ta'ané kua teu, kā ko nātou ne'e tala ki aí ne'e kailoa tuha 'ia nātou ia. ");
INSERT INTO num_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ko ia kotou ō ki te 'ū manga'i alá, pea ko te kakai 'e kotou 'ilo'i 'i aí, tala ke notou ha'u ki te kātoangá.’ ");
INSERT INTO num_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Pea 'alu atu 'ia te kau tamaio'alikí ki te 'ū alá, 'o notou tānaki 'ia te kakai kotoa pē ne'e notou sio ki aí, 'ia te kovi mo te lelei fakatou'osi; pea ne'e fonu 'ia te kātoangá. ");
INSERT INTO num_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Pea 'i te me'a mai te tu'í ke vakai ki te kakai ne'e kainangá, ne ina 'ilo'i ai he tangata kua kailoa ina tui he kofu ta'ane. ");
INSERT INTO num_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Pea folafola ia ki ai, ‘Siana, ne'e fefe'aki tau hū mai ki heni ta'e 'ai hau kofu ta'ané?’ Pea fakalongolongo pē ia. ");
INSERT INTO num_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Pea fekau 'e te tu'í ki te kau sevānití, ‘Ha'i tono va'é mo tono nimá, 'o sī 'ona ki te pō'uli 'o tua'aá. Ko te feitu'u ia 'e toki hoko ai 'ia te tangi mo te fengai'itaki 'o te nifó.’ ");
INSERT INTO num_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","He 'oku ui 'ia te tokolahi, kae fili pē te tokosi'i.” ");
INSERT INTO num_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pea toki ō 'ia te kau Fālesí, 'o notou fa'ufa'u pe fefe'aki te notou tauhele'i 'Ona 'i te aleá. ");
INSERT INTO num_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Pea notou fekau atu kiā Ia he notou kau ako fakataha mo te fa'ahi 'a Hēlotá, 'o notou pehē ange, “Tangata'aliki, 'oku motou 'ilo'i 'oku mo'oni 'ia Koe, pea 'oku ako totonu 'aki 'e Koe 'ia te ala 'o te 'Alikí, pea 'oku kala Ke tokanga ki te lau 'a te kakaí, kote'uhí 'oku kala Ke filifilimānako. ");
INSERT INTO num_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ko ia ai, tala'i mai pe ko te ā Tau laú, pe 'oku ngafua ke totongi tukuhau kiā Sisa, pe kailoa?” ");
INSERT INTO num_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ka ne'e mea'i 'e Sīsū te notou fakakaukau koví, 'o iange Ia, “'Ia te kau mālualohi, ko te ā 'oku kotou 'ahi'ahi'i ai 'Okú? ");
INSERT INTO num_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Faka'ali'ali mai 'ia te pa'anga tukuhaú.” Pea notou 'aumai kiā Ia he fe'i tēnali. ");
INSERT INTO num_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Pea iange Ia kiā nātou, “Ko te fofonga 'ena mo te hingoa 'o ai?” ");
INSERT INTO num_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Pea notou iange kiā Ia, “'O Sisa.” Pea folafola Ia kiā natou, “Pe'i 'avange kiā Sisa 'ia te 'ū me'a 'a Sisá, pea ki te 'Atuá 'ia te 'ū me'a 'a te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pea notou 'ohovale 'aupito 'i Tana talí, pea notou mātuku atu 'o 'alu meiā Ia. ");
INSERT INTO num_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","'I te 'aho ko iá ne'e ōmai kiā Ia 'ia te kau Sātusí, 'ā ē 'oku notou pehē 'oku kailoa he toetu'ú, ");
INSERT INTO num_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","'o notou fehu'i kiā Ia, “Tangata'aliki, ne'e pehē 'e Mōsese, ‘Kāpau 'e pekia he tangata 'oku kailoa 'i ai hana fānau, pea toe mali tono tokouá mo te finematu'á, ke fakatupu ai he hako ki tono tokouá.’ ");
INSERT INTO num_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pea ko 'eni, ne'e nonofo mo mātou he tautēhina 'e toko fitu. Pea mali 'ia te 'uluakí 'o pekia, pea ko te me'a 'i te kailoa hana hakó ne'e tukuange ia tono finematu'á ki tono tehiná. ");
INSERT INTO num_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pehē foki mo tono toko uá, mo tono toko tolú, kae'aua ke 'osi 'ia te toko fitú. ");
INSERT INTO num_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pea toki pekia ki muli mai 'ia te fafiné. ");
INSERT INTO num_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Pea 'i te toetu'ú 'e hoko ia ko te 'unoho 'o ai 'i te toko fitú? He ne'e notou ma'u ia 'e nātou kotoa pē.” ");
INSERT INTO num_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kae toki tali ange 'e Sīsū kiā nātou, “'Oku kotou hē, ko te kailoa kotou 'ilo'i 'ia te Tohitapú, mo te māfimafi 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","He 'oku kailoa he ma'u hoa, pē he foaki 'unoho hili 'ia te toetu'ú, kā 'oku notou tatau mo te kau 'āngeló 'i hēvani. ");
INSERT INTO num_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kā ko te me'a ki te toetu'u 'o te pekiá, ne kailoa kotou lau koā 'ia te folafola 'a te 'Atuá kiā kōtou, 'o pehē, ");
INSERT INTO num_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ko Au ko te 'Atua 'o 'Ēpalahame, pea ko te 'Atua 'o 'Aisake, pea ko te 'Atua 'o Sēkope’? 'Oku kala ko te 'Atua Ia 'o te kau maté, kā 'o te kau ma'ulí.” ");
INSERT INTO num_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pea 'i te fanongo ki ai 'e te fu'u kakaí, ne'e notou ofo 'aupito 'i te anga 'o Tana faiakó. ");
INSERT INTO num_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pea 'i te fanongo 'e te kau Fālesí kua Ina fakasīlongo'i 'ia te kau Sātusí, ne'e notou fakataha leva 'ia nātou. ");
INSERT INTO num_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Pea ko te notou toko taha, ko te tufunga lao, ne ina fehu'i kiā Ia, ko tana 'ahi'ahi'i 'Ona, 'o pehē, ");
INSERT INTO num_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tangata'aliki, ko te tu'utu'uni fea 'i te Laó 'oku mamafa tahá?” ");
INSERT INTO num_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Pea tali 'e Sīsū ki ai, “'E ke 'ofa ki te 'Aliki ko tou 'Atuá, 'o fai 'aki te kotoa 'o tou lotó, mo te kotoa 'o tou laumālié, mo te kotoa 'o tou 'atamaí. ");
INSERT INTO num_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ko 'eni ia 'ia te tu'utu'uni 'oku mamafa taha mo tu'ukimu'á. ");
INSERT INTO num_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Pea 'oku tatau mo ia tono uá: 'E ke 'ofa ki tou kaungā'apí 'o hangē pē ko tau 'ofa kiā koé. ");
INSERT INTO num_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ko te ongo tu'utu'uni ko 'ení 'e ua 'oku tautau ki ai 'ia te Laó kotoa pē mo te Tohi Palōfitá.” ");
INSERT INTO num_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pea 'i te kei fakatahataha mai 'ia te kau Fālesí, ne'e fehu'i ange 'e Sīsū kiā nātou, ");
INSERT INTO num_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ko te ā te kotou lau ki te Kalaisí? Ko te Hako nai Ia 'o ai?” Pea notou tali, “'O Tēvita.” ");
INSERT INTO num_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Pea pehē ange Ia kiā nātou, “Pea fefe'aki ai tono ui 'Ona 'e Tēvita ko te 'Aliki 'i tana Laumālie'iná, 'o pehē, ");
INSERT INTO num_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ne folafola 'e te 'Alikí ki toku 'Alikí, Nofo ifo koe 'i Toku to'omata'ú, kae'aua ke Au 'ai Tou fili fuli pē ko Tou tu'unga va'e’? ");
INSERT INTO num_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Pea kāpau 'oku ui 'Ona 'e Tēvita ko tono 'Aliki, pea ko tono hako fefe'aki Ia?” ");
INSERT INTO num_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Pea ne'e kailoa he taha 'e lava tono tali; pea 'i te 'osi ange te 'aho ko iá ne'e kala toe 'i ai he toko taha 'e fakato'ato'a ke fai he fehu'i kiā Ia. ");
INSERT INTO num_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ne'e toki folafola ange 'e Sīsū ki te fu'u kakaí, mo Tana kau akó, ");
INSERT INTO num_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","'o pehē, “Ko te kau sikalaipé mo te Fālesí 'oku notou ma'u 'ia te tu'unga 'o Mōsesé, ");
INSERT INTO num_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ko ia, ko te me'a kotoa pē 'oku notou fekau ke kotou faí, kotou fai ki ai mo tauhi. Kae'aua na'a kotou fa'ifa'itaki ki te notou ngāué, he 'oku notou lea kae kailoa fai ki ai. ");
INSERT INTO num_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pea 'oku notou ha'iha'i 'ia te 'ū kavenga mamafa, mo fakamamahi, ki te uma 'o te kakaí; kā ko nātoú 'oku kailoa fia 'ai he notou fe'i tuhu 'o nātou ki ai. ");
INSERT INTO num_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kā 'oku notou fai te notou ngāue kotoa pē ke mamata ki ai 'ia te kakaí. He 'oku notou fakalaulahi te notou failaketelí, mo fakalahi 'ia te tapa 'o te notou kofú; ");
INSERT INTO num_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","pea notou manako ki te nofo'anga 'i mu'a 'i te kātoangá, pea nofo ki mu'a 'i te falelotú, ");
INSERT INTO num_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","pea ke faka'apa'apa'ina 'i te mala'e fakataú, pea ke ui 'e te kakaí kiā nātou, ‘Lāpai, Lāpai.’ ");
INSERT INTO num_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kā ko kōtoú 'aua 'e ui ko te Lāpai, he 'oku taha pē te kotou Faiakó; kā ko kōtoú ko te 'ū tokoua kotoa pē. ");
INSERT INTO num_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pea 'aua 'e ui he toko taha 'i māmani ko te kotou tamai, he 'oku taha pē te kotou Tamaí, 'ā ē 'oku 'i hēvaní. ");
INSERT INTO num_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kae'uma'ā 'aua 'e ui 'ia kōtou ko te kau takimu'a, he 'oku taha pē te kotou Takimu'á, ko Kalaisi. ");
INSERT INTO num_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kā ko ia 'oku lahi 'iā kōtoú, 'e hoko ia ko te kotou sevāniti. ");
INSERT INTO num_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Pea ko ia ko 'ē 'e hākeaki'i pē 'oná 'e fakavaivai'i; pea ko ia ko 'ē 'e fakavaivai'i 'oná 'e hākeaki'i. ");
INSERT INTO num_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Kae pohoē 'ia kōtou, sikalaipe mo te Fālesi, ko te kau mālualohi! He 'oku kotou tāpuni 'ia te Pule'anga 'o Hēvaní ki te kakaí. 'Io, 'oku kailoa kotou fia hū 'e kōtou, pea ko nātou 'oku feinga ke huú, 'oku kailoa kotou tukuange ke notou hū. ");
INSERT INTO num_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Pohoē 'ia kōtou, sikalaipe mo te Fālesi, 'ia te mālualohi! He 'oku kotou folo 'ia te 'ū 'api 'o te si'i kau uitou fuli pē, pea kotou mounu 'aki te lotu loaloá. Ko ia ai, 'e kotou ma'u 'e kōtou he tautea 'oku lahi ange. ");
INSERT INTO num_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Pohoē 'ia kōtou, sikalaipe mo te Fālesi, 'ia te mālualohi! He 'oku kotou foli 'ia te taí mo te fanuá ke fakatafoki he toko taha; pea kā tafoki ia, 'oku kotou ngaahi 'ona ko te toko taha 'o heli 'o kovi lahi ake ia 'iā kōtou. ");
INSERT INTO num_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Pohoē 'ia kōtou, ko te kau takimu'a kui! 'Oku kotou lau 'o pehē, ‘Kā fuakava he taha ki te Fale Tapú, ko te me'a noa pē ia, kae kā fuakava he taha ki te koula 'o te Fale Tapú, kua pau ke fai ia ki tana fuakavá!’ ");
INSERT INTO num_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","'Ia te kau vale mo kui! He ko fea 'oku lahí, 'ia te koulá, pe ko te Fale Tapú 'a ē 'oku toputapu ai 'ia te koulá? ");
INSERT INTO num_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mo kotou lau foki, ‘Kā fuakava he taha ki te 'ōlitá, ko te me'a noa pē ia; kae kā fuakava he taha ki te me'a'ofa kua hilifaki ki aí, kua pau ke fai ia ki tana fuakavá.’ ");
INSERT INTO num_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","'Ia te koto kui! He ko fea 'oku lahí, 'ia te me'a'ofá, pe ko te 'ōlita 'oku toputapu ai 'ia te me'a'ofá? ");
INSERT INTO num_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","'Āua, ko ia 'oku fuakava ki te 'ōlitá, 'oku kailoa lea ia ki ai pē, kā 'oku lea foki ia ki te me'a kotoa pē kua hilifaki ki aí. ");
INSERT INTO num_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Pea ko ia 'oku fuakava ki te Fale Tapú, 'oku kailoa lea ia ki ai pē, kā kiā Ia foki 'oku 'afio 'i aí. ");
INSERT INTO num_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Pea ko ia 'oku fuakava 'aki 'ia hēvaní, 'oku fuakava ia ki te taloni 'o te 'Atuá, pea mo Ia 'oku 'afio 'i aí. ");
INSERT INTO num_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Pohoē 'ia kōtou, sikalaipe mo te Fālesi, 'ia te mālualohi! He 'oku kotou 'avatu 'ia te vahe hongofulu 'o te minité mo te anetó mo te kuminó; kā kua kotou tuku 'ia te 'ū me'a mamafa 'o te Laó, 'ia te fakamaau totonú, mo te fai meesí, mo te faitotonú. Ka ne'e totonu ke fai 'eni, pea 'aua na'a tuku 'ena. ");
INSERT INTO num_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","'Ia te koto takimu'a kui! 'Oku kotou heu'i mei te kotou inú 'ia te namú, kae folo fua 'ia te kāmelí! ");
INSERT INTO num_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Pohoē 'ia kōtou, sikalaipe mo te Fālesi, 'ia te mālualohi! He 'oku kotou fufulu 'ia te tu'a ipú mo te tisí, kae fonu te kotou lotó 'i te fakamālohí mo te siokitá. ");
INSERT INTO num_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","'Ia te Fālesi kui! Fufulu mu'a te loto ipú mo te peletí, kote'uhí ke ma'a ai mo tu'a foki. ");
INSERT INTO num_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Pohoē 'ia kōtou, sikalaipe mo te Fālesi, 'ia te mālualohi! He 'oku kotou tatau tofu pē mo te 'ū fanualoto kua vali hinahina, 'a ia 'oku matamatalelei mo'oni 'i tu'a, kā 'i lotó 'oku fokotu'uniu ai 'ia te hui 'o te pekiá mo te 'ū fakalialia kotoa pē. ");
INSERT INTO num_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","'Oku pehē 'ia kōtou foki; 'i tu'á 'oku kotou hā ki te kakaí ko te kau mā'oni'oni, kā 'i lotó 'oku kotou fonu 'i te mālualohí mo te maumau laó. ");
INSERT INTO num_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Pohoē 'ia kōtou, sikalaipe mo te Fālesi, 'ia te mālualohi! He 'oku kotou langafale'i 'ia te 'ū fanualoto 'o te kau palōfitá, mo fakasanisani 'ia te 'ū fale fa'itoka 'o te kakai mā'oni'oní; ");
INSERT INTO num_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","'o kotou pehē, ‘Kāpau ne motou ma'uli 'i te kuonga 'o te motou mātu'á 'i mu'a, 'e kala motou kau mo nātou 'i tono tāmate'i 'o te kau palōfitá.’ ");
INSERT INTO num_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tā 'oku kotou fakamo'oni pē kiā kōtou, ko te hako 'ia kōtou 'o te kakai ne'e notou fakapoongi 'ia te kau palōfitá. ");
INSERT INTO num_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Pe'i kotou faka'osi ā 'ia te ngāue ne'e kamata 'e te kotou mātu'a 'i mu'á. ");
INSERT INTO num_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","'Ia te fanga ngata! 'Ia te hako'i ngata fekai! 'E kotou hao fefe'aki ai mei te mala'ia 'o helí? ");
INSERT INTO num_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ko ia ai, vakai, 'Okou fekau'i atu kiā kōtou he kau palōfita, mo he kau poto, mo he kau sikalaipe. 'E kotou tāmate'i te notou 'ihi mo kalusefai; pea 'e kotou haha te notou 'ihi 'i te kotou 'ū falelotú, pea fakatanga'i mei te kolo ki te kolo, ");
INSERT INTO num_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","kote'uhí ke 'eke kiā kōtou 'ia te toto mā'oni'oni kotoa pē kua lilingi ki te kelekelé, mei te toto 'o 'Ēpeli mā'oni'oní 'o a'u ki te toto 'o Sākalaia ko te foha 'o Palakaiá, 'ā ē ne'e kotou tāmate'i 'i te vaha'a 'o te Fale Tapú mo te 'ōlitá. ");
INSERT INTO num_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","'Okou tala mo'oni atu kiā kōtou, 'e hoko 'ia te 'ū me'a ko 'ení kotoa pē ki te to'utangata nei! ");
INSERT INTO num_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“'E Selusalema! Selusalema! 'Ia te kolo 'oku tāmate'i 'ia te kau palōfitá, mo tolomaka'i 'ia te kakai 'oku fekau atu kiā koé! Kua tu'a fia Taku loto ke tānaki mai tau fānaú, 'o hangē ko te tānaki 'e te matu'a moá to'onó fānganga ki tono lalo kapakaú, ka ne'e kailoa kotou loto ki ai! ");
INSERT INTO num_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Vakai, kua si'aki atu kiā kōtou te kotou falé ke lala 'aupito. ");
INSERT INTO num_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Hē 'Okou tala'i atu, ngata mei heni, 'e kailoa 'aupito kotou toe sio kiā Au, kae'aua ke kotou pehē, ‘'Oku manū'ia Ia 'oku hā'ele mai 'i te huafa 'o te 'Alikí.’ ” ");
INSERT INTO num_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Pea hū atu 'ia Sīsū mei te Temipalé, 'o kamata Tana fonongá; pea ōmai Tana kau akó ke faka'ali'ali kiā Ia 'ia te 'ū fale 'o te Temipalé. ");
INSERT INTO num_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ka ne'e pehē ange Ia kiā nātou, “'Oku kotou sio koā ki te 'ū me'a ko 'ení fuli pē? 'Okou tala mo'oni atu kiā kōtou, 'e kailoa 'aupito tuku he fe'i maka ia heni 'o ta'eholoki ki lalo.” ");
INSERT INTO num_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Pea 'i Tana nofo ifo 'i te funga ma'unga ko 'Ōlivé, ne'e ōmai kiā Ia 'ia te kau akó fakaenātou, 'o notou pehē, “Tala'i mai, pe 'e hoko fakafea 'ia te 'ū me'a ko iá, pea ko te ā te faka'ilonga 'o Tau ha'ú, mo te ngata'anga 'o māmaní?” ");
INSERT INTO num_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Pea tali ange 'e Sīsū kiā nātou, “Kotou tokanga, na'a takihee'i kōtou he taha. ");
INSERT INTO num_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kote'uhí 'e ha'u he tokolahi 'i Toku hingoá, 'o notou pehē, ‘Ko au 'ia te Kalaisí;’ pea 'e notou takihee'i he tokolahi. ");
INSERT INTO num_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Pea 'e kotou fanongo ki te 'ū tau, mo te 'ū ongoongo 'o te tau. Tokanga ke 'aua na'a kotou manahē ai kōtou ia; he kua pau ke hoko ia, kae kei tuai pē 'ia te ngata'angá. ");
INSERT INTO num_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kote'uhí 'e tu'u ake he kakai ki te kakai, mo te pule'anga ki te pule'anga; pea 'e 'i ai he 'ū honge, mo he 'ū mofuike 'i te 'ū feitu'u kehekehe. ");
INSERT INTO num_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kā ko te 'ū me'a ko iá kotoa pē ko te kamata'anga pē ia 'o te langaá. ");
INSERT INTO num_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Pea 'e notou toki tukuange 'ia kōtou ke fakamamahi'i, pea 'e notou tāmate'i 'ia kōtou. Pea 'e fihi'anakina'i kōtou 'e te kakai kotoa pē, ko te me'a 'i Toku hingoá. ");
INSERT INTO num_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Pea 'e toki tūkia ai he tokolahi, pea 'e notou tau'aki faka'ilo 'ia nātou, mo fetāufihi'a'aki. ");
INSERT INTO num_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Pea 'e tokolahi te kau palōfita lohi 'e tutupu aké, 'o notou takihee'i he tokolahi. ");
INSERT INTO num_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Pea ko te me'a 'i te fakautuutu 'ia te maumau laó, 'e faka'a'au 'o momoko te 'ofa 'a te tokolahi. ");
INSERT INTO num_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kā ko ia 'e kātaki 'o a'u ki te ngata'angá, ko ia ia 'e ma'ulí. ");
INSERT INTO num_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pea ko te ongoongolelei 'o te pule'angá 'e malanga 'aki ki māmani kotoa pē, ke 'i ai he fakamo'oni ki te kakai kotoa pē, pea toki hoko 'ia te ngata'angá. ");
INSERT INTO num_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ko ia ai, kā kotou vakai 'oku tu'u 'i te Potu Toputapú 'ia te ‘me'a fakalialia 'o te faka'auhá’, 'ā ē ne'e folafola ki ai 'e te palōfita ko Tānielá (ko ia 'oku lau iá, ke mahino ki ai), ");
INSERT INTO num_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","pea ke toki hola ki te ma'ungá 'ia nātou 'oku notou nonofo 'i Siuteá. ");
INSERT INTO num_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Pea ko ia 'oku 'i te tu'a falé ke 'aua 'alu ifo ke 'ave te 'ū me'a mei tono falé; ");
INSERT INTO num_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","pea ko ia 'oku 'i te ngoué, ke 'aua na'a foki ki 'api ke 'ave tono 'ū kofú. ");
INSERT INTO num_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kae pohoē 'ia nātou 'oku faitamá, mo nātou 'oku tautama 'i te taimi ko iá! ");
INSERT INTO num_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pea kotou lotua foki ke 'aua na'a hoko te kotou holá 'i te fa'ahita'u momokó, pe 'i te 'aho Sāpaté. ");
INSERT INTO num_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kote'uhí 'e toki hoko ai 'ia te mamahi lahi, pea kua he'iki ai hana tatau talu mei te kamata'anga 'o māmaní 'o a'u mai ki te taimi nei, 'io, pea 'e kailoa 'aupito toe 'i ai. ");
INSERT INTO num_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Pea kāpau 'e kailoa fakanounou te taimi ko iá, 'e 'auha te kakano kotoa pē; kā kote'uhí ko te kakai filí, 'e fakanounou ai 'ia te 'ū 'aho ko iá. ");
INSERT INTO num_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Pea kāpau 'e toki pehē atu he taha, ‘'Ē, 'oku 'i heni 'ia Kalaisi,’ pē ‘'I hena,’ 'aua 'e kotou tui ki ai. ");
INSERT INTO num_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kote'uhí 'e tupu ake he kau Kalaisi lohi, mo he kau palōfita lohi, pea 'e notou fakahoko he 'ū faka'ilonga lahi mo te 'ū me'a fakaofo; 'o fai ke taki hē 'aki te kakai filí, 'o kāpau ne lava. ");
INSERT INTO num_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tokanga! He kua U 'osi tala'i atu kiā kōtou. ");
INSERT INTO num_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ko ia, kāpau 'e notou pehē atu kiā kōtou, ‘Vakai, ko 'ena 'i te toafá!’ 'aua na'a kotou ō ki ai. ‘Vakai, 'oku toi 'i heni!’ 'aua 'e kotou tui ki ai. ");
INSERT INTO num_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","He hangē ko te pā mai 'ia te 'uhilá mei te hahaké, pea ulo 'o a'u ki te hihifó, 'e pehē pē foki te hoko mai 'a te Fanautama te Tangatá. ");
INSERT INTO num_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","He ko te feitu'u ko ia 'oku 'i ai te 'anga'angá, 'e kātoa ki ai 'ia te fanga 'īkalé foki. ");
INSERT INTO num_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Pea kā 'osi leva 'ia te mamahi 'o te taimi ko iá 'e fakapō'uli te la'aá, pea 'e tuku te māhiná tana huhulú, pea 'e ngangana te 'ū fetu'u mei te langí, pea 'e ngatōtō 'ia te 'ū mālohinga 'o te langí. ");
INSERT INTO num_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pea 'e toki hā mei te langí 'ia te faka'ilonga 'o te Fanautama te Tangatá; pea 'e toki sī fatafata 'e te 'ū matakali 'o māmaní kotoa pē, pea 'e notou toki sisio ki te Fanautama te Tangatá 'oku hoko mai 'i te 'ū 'ao 'o te langí, 'i te mālohi mo te nāunau lahi. ");
INSERT INTO num_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Pea 'e Ina fekau atu Tana kau 'āngeló mo te le'o 'o he talupite lahi; pea 'e notou tānaki Tana kakai filí mei te matangi 'e faá, mei te ngata'anga 'e taha 'o te langí 'o a'u ki tono ngata'anga 'e tahá. ");
INSERT INTO num_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Kotou ma'u mei te fikí tono fakatātaá: kā muimuia tono muká pea kamata lau, 'oku kotou 'ilo'i leva 'oku ofi 'ia te fa'ahita'u māfaná. ");
INSERT INTO num_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Pehē foki 'ia kōtou, kā kotou mamata ki te 'ū me'a kotoa pē ko iá, pea kotou 'ilo'i kua ofi ia, 'io, kua a'u ki te matapaá. ");
INSERT INTO num_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","'Okou tala mo'oni atu kiā kōtou, 'e kailoa 'aupito mole 'ia te to'utangata nei, kae'aua ke hoko 'ia te 'ū me'a ko iá kotoa pē. ");
INSERT INTO num_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","'E mole 'ia te langí mo māmani, kā ko Taku 'ū leá 'e kailoa 'aupito mole. ");
INSERT INTO num_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Kā ko te me'a ki te 'aho ko iá mo tono houá, 'oku kailoa 'ilo he taha ki ai; pe ko te kau 'āngelo 'i te langí, pea na'a mo te 'Aló, ngata pē 'i te Tamaí Toko Taha. ");
INSERT INTO num_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kae hangē ko te taimi 'o Noá, 'e pehē foki te hoko mai 'ia te Fanautama te Tangatá. ");
INSERT INTO num_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","He hangē ne'e nofo 'ia te kakaí 'i te kuonga ki mu'a 'i te Lōmakí, 'o notou kai mo inu, 'o notou taki taha ma'u hoa pē he foaki 'unoho, 'o a'u ki te 'aho ne'e hū ai 'ia Noa ki te 'a'aké, ");
INSERT INTO num_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","pea ne'e kailoa he notou 'amanaki 'e taha, kae'aua ke hoko mai 'ia te Lōmakí, 'o 'ave 'ia nātou kotoa pē, 'e pehē foki 'i te hoko mai 'ia te Fanautama te Tangatá. ");
INSERT INTO num_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ko te taimi ko iá, 'e 'i te ngoué he toko ua; 'e 'ave te taha, kae tuku te taha. ");
INSERT INTO num_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","'E 'i ai te ongo fafine 'oku fai te nā momosi koane; 'e 'ave te taha kae tuku te taha. ");
INSERT INTO num_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ko ia ai kotou le'o, hē 'oku kailoa kotou 'ilo'i pe ko fea te houa 'e hoko mai ai te kotou 'Alikí. ");
INSERT INTO num_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kae kotou 'ilo'i 'eni, kāpau ne'e sinaki mea'i 'e te tangata'alikí pe ko te houa fea 'e ha'u ai 'ia te kaiha'á, pehē ne le'o, 'o kailoa tuku tono falé ke haea. ");
INSERT INTO num_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ko ia ke toka teuteu 'ia kōtou foki, kote'uhí 'e ha'u 'ia te Fanautama te Tangatá 'i te taimi 'oku kailoa kotou 'amanaki ai kiā Iá. ");
INSERT INTO num_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“'Io, ko ai nai he tamaio'aliki lototō mo fai fakapotopotó, 'a ē kua fakanofo 'e tana 'alikí ke pule'i tono kau nofo'angá, mo 'avange te notou me'akaí 'i tono taimi totonú? ");
INSERT INTO num_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","'Oku manū'ia 'ia te tamaio'aliki ko iá, kā ha'u tana 'alikí 'o 'ilo'i 'ona 'oku fai pehē. ");
INSERT INTO num_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","'Okou tala mo'oni atu kiā kōtou, 'e fakanofo ia 'ona ke pule ki tana 'ū me'á kotoa pē. ");
INSERT INTO num_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kae kā pehē 'e te tamaio'aliki kovi ko 'ená 'i tono lotó, ‘'Oku fakatuatuai mai taku 'alikí ta'aná ha'u,’ ");
INSERT INTO num_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","pea hanga leva ia 'o haha 'ia nātou 'oku 'i te kau ngāué mo iá, pea kai ia mo inu kava mo te kau konaá; ");
INSERT INTO num_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","'e toki ha'u te 'aliki 'o te tamaio'aliki ko iá 'i te 'aho 'oku kailoa ina tokanga aí, pea mo te houa 'oku kailoa 'ilo 'e ia ki aí, ");
INSERT INTO num_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","pea 'e ina fahi ua 'ona, pea tu'utu'uni ke ina 'inasi fakataha mo te kau mālualohí. Ko te feitu'u ia 'e toki hoko ai 'ia te tangi mo te fengai'itaki 'o te nifó. ");
INSERT INTO num_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“'I te taimi ko iá 'e tatau te Pule'anga 'o Hēvaní mo te kau tāupo'ou 'e toko hongofulu, 'a ia ne'e notou taki taha to'o tana maama, 'o ō atu ke fakafetaulaki ki te 'aliki ta'ané. ");
INSERT INTO num_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ko te toko nima ko te kau fakavalevale, kā ko te toko nima ko te kau fakapotopoto. ");
INSERT INTO num_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ko te kau fakavalevalé ne'e notou to'o te notou 'ū maamá, kae kailoa 'ave he lolo; ");
INSERT INTO num_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","kā ko te kau fakapotopotó ne'e notou 'ave te lolo 'i te 'ū hiná fakataha mo te notou 'ū maamá. ");
INSERT INTO num_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Pea 'i te tuai mai 'ia te 'aliki ta'ané, ne'e notou tulemoe kotoa pē 'o momoe. ");
INSERT INTO num_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Kā 'i te tu'ulapoó ne'e pā mai te kalanga, ‘Ko te 'aliki ta'ané 'eni, kotou ō atu 'o fakafetaulaki kiā ia!’ ");
INSERT INTO num_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Toki 'a'ala ake 'ia te kau tāupo'oú kotoa pē, 'o taki taha ngaahi tana maama. ");
INSERT INTO num_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pea kole ange te kau fakavalevalé ki te kau fakapotopotó, ‘'Aumai mu'a he motou me'i lolo, he kua tei mate te motou 'ū maamá.’ ");
INSERT INTO num_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ka ne'e tali ange te kau tāupo'ou fakapotopotó 'o pehē, ‘Ka na'a kailoa fe'unga mo mātou mo kōtou fakatou'osi; kotou ō mu'a ki te kau fakataú, 'o fakatau ma'a kōtou.’ ");
INSERT INTO num_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kae lolotonga te notou 'alu mei ai ke fakataú, mo te ha'u te 'aliki ta'ané; pea ko nātou ne'e notou 'osi teuteú ne'e notou ō atu mo ia 'o hū ki te kātoangá, pea tāpuni 'ia te matapaá. ");
INSERT INTO num_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Pea ha'u tōmuli tono toe 'o te kau tāupo'oú, 'o notou pehē, ‘'Aliki, 'aliki, to'o kiā mātou!’ ");
INSERT INTO num_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ka ne'e tali ange 'e ia 'o pehē, ‘'Okou tala mo'oni atu kiā kōtou, 'oku kala u 'ilo'i 'ia kōtou!’ ");
INSERT INTO num_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ko ia kotou lele'o, hē 'oku kala kotou 'ilo'i tono 'ahó, pe ko tono houá. ");
INSERT INTO num_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“He ko te Pule'anga 'o Hēvaní 'oku hangē ko te tangata ne'e teu tana 'alu ki muli, pea ne ina ui ange tana kau tamaio'alikí, 'o tuku kiā nātou tana koloá. ");
INSERT INTO num_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ko te toko taha ne ina 'avange ki ai te talēniti 'e nima, pea ua ki te toko taha, pea taha ki te toko taha, 'o fakatatau ki te notou mafai taki taha. Pea 'alu ia ki muli. ");
INSERT INTO num_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pea 'alu leva ia ne'e ma'u te talēniti 'e nimá, 'o ngāue 'aki ia, 'o fakatupu 'aki he nima kehe. ");
INSERT INTO num_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Pehē foki mo ia ne'e 'a'ana te uá, ne'e ma'u ia mo he ua kehe. ");
INSERT INTO num_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kā ko ia ne'e ma'u te tahá, ne ina 'alu 'o keli he luo, 'o fufuu'i ai te pa'anga tana 'alikí. ");
INSERT INTO num_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Pea fualoa mei aí kua ha'u 'ia te 'aliki 'o te kau tamaio'aliki ko iá, 'o vakai'i te notou fakamatala pa'angá. ");
INSERT INTO num_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pea 'unu'unu mai ia ne ina ma'u te talēniti 'e nimá, 'o 'aumai mo he talēniti 'e nima kehe, 'o iange ia, ‘'Aliki, ne ke tuku mai te talēniti 'e nima; ko 'eni, 'okou ma'u mai mo he nima kehe.’ ");
INSERT INTO num_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Pea me'a mai tana 'alikí, ‘Mālō, si'i tamaio'aliki lelei mo lototō. Kua ke lototō 'i tau pule ki te 'ū me'a si'i; 'e au fakanofo 'ou ke pule ki te 'ū me'a lahi. Hū koe ki te fiafia'anga 'o tou 'alikí!’ ");
INSERT INTO num_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Pea ha'u foki mo ia ne'e 'a'ana te talēniti 'e uá, 'o iange, ‘'Aliki, ne ke tuku mai te talēniti 'e ua; ko 'eni, 'okou ma'u mai mo he ua kehe.’ ");
INSERT INTO num_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Pea me'a mai tana 'alikí, ‘Mālō, si'i tamaio'aliki lelei mo lototō. Kua ke lototō 'i te pule ki te 'ū me'a si'i; 'e au fakanofo 'ou ke pule ki te 'ū me'a lahi. Hū koe ki te fiafia'anga 'o tou 'alikí!’ ");
INSERT INTO num_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pea toki ha'u mo ia kua ma'u te talēniti 'e tahá, 'o pehē ange, ‘'Aliki, ne au 'ilo'i koe ko te tangata faingata'a; 'oku ke utu 'i te me'a ne'e kailoa ke fakaheká, mo toli te me'a ne kailoa ke lulú. ");
INSERT INTO num_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Pea u manahē, pea u 'alu 'o fufuu'i tau talēnití 'i te kelekelé. 'Ē, ko 'ena ā tau me'á.’ ");
INSERT INTO num_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kā ne tali ange tana 'alikí, 'o pehē ange, ‘'Ia te tamaio'aliki pau'u mo fakapikopiko! Ne ke 'ilo'i koā 'okou utu 'ia te me'a ne kala u fakaheká, pea u toli te me'a ne kala u lulú? ");
INSERT INTO num_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ne'e mei totonu ange ke ke fakahū taku pa'angá ki te pangikeé; pehē kua u ma'u mei ai taku me'á, mo tono tupú foki, 'i taku ha'u neí. ");
INSERT INTO num_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ko ia kotou to'o te talēnití meiā ia, 'o 'avange kiā ia 'oku ma'u te hongofulú. ");
INSERT INTO num_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","He ko ia ko 'ē 'oku ma'u he me'á 'e 'avange ki ai mo te me'a, pea 'e hulu atu ia; kā ko ia 'oku kailoa ma'ú, na'a mo te me'a 'oku ma'u iá 'e to'o meiā ia! ");
INSERT INTO num_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kae kotou sī te tamaio'aliki ta'e'aongá ki te pō'uli 'o tua'aá. Ko te feitu'u ia 'e toki hoko ai 'ia te tangi mo te fengai'itaki 'o te nifó.’ ");
INSERT INTO num_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Kae kāpau 'e ha'u 'ia te Fanautama te Tangatá 'i Tono nāunaú, mo te kau 'āngelo kotoa pē, 'e toki nofo Ia 'i Tono taloni lāngilangi'iná. ");
INSERT INTO num_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Pea 'e fakatahataha ki Tono 'aó 'ia te kakai kotoa pē; pea 'e vahe'i 'e Ia 'ia nātou, 'o hangē ko te vahe'i he tauhi sipi 'ia te fanga sipí mei te fanga kosí. ");
INSERT INTO num_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Pea 'e Ina fokotu'u te fanga sipí mei Tono to'omata'ú, kā ko te fanga kosí mei Tono to'ohemá. ");
INSERT INTO num_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Pea 'e toki folafola te Tu'í kiā nātou 'i Tono to'omata'ú, ‘Ōmai kōtou, 'ia te fa'ahinga kua fakamanū'ia 'e Taku Tamaí, 'o ma'u 'ia te pule'anga kua teu ma'a kōtou talu te tanupou 'o māmaní. ");
INSERT INTO num_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Hē ne Au fiakaia, pea kotou 'aumai Taku kai; ne Au fiainua, pea kotou 'aumai Taku inu; ne Au 'āunofo, pea kotou fakaafe'i 'Oku; ");
INSERT INTO num_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ne kailoa Haku kofu, pea kotou fakakofu 'Oku; ne Au mahaki'ina, pea kotou ōmai Toku vakai; ne Au 'i te pilīsoné, pea kotou 'a'ahi mai.’ ");
INSERT INTO num_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Pea 'e toki tali 'ia te kau faileleí, 'o pehē, ‘'Aliki, 'anefea he motou 'ilo'i 'Ou 'oku Ke hālofia, pea motou fafanga'i 'Ou? pe fiainua pea motou 'avatu Hau inu? ");
INSERT INTO num_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Pea 'anefea he motou 'ilo'i Koe 'oku Ke 'āunofo, pea motou fakaafe'i, pe ta'ekofu pea motou fakakofu'i? ");
INSERT INTO num_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Pea 'anefea he motou 'ilo'i Koe 'oku tengetange, pe ma'ua 'i te pilīsoné, pea motou 'a'ahi atu?’ ");
INSERT INTO num_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Pea 'e toki tali te Tu'í, 'o folafola mai, ‘'Okou tala mo'oni atu kiā kōtou, 'i te kotou fai pehē ki te si'i taha 'i Toku 'ū tokoua nei, ne'e kotou fai ia kiā Au!’ ");
INSERT INTO num_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Pea 'e toki folafola foki Ia kiā natou 'i te to'ohemá, ‘'Alu meiā Au, 'ia kōtou kua mala'iá, ki te afi ta'engata 'ā ē ne'e teuteu ma'a te tēvoló mo tana kau 'āngeló. ");
INSERT INTO num_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Hē ne Au fiakaia, ka ne'e kailoa kotou 'aumai Haku kai; ne Au fiainua, ka ne'e kailoa kotou 'aumai Haku inu; ");
INSERT INTO num_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ne Au 'āunofo, ka ne'e kailoa kotou fakaafe'i 'Oku; ne Au ta'ekofu, ka ne'e kailoa kotou fakakofu'i 'Oku; ne Au mahaki'ina, pea ma'ua 'i te pilīsoné, ka ne'e kailoa kotou 'a'ahi mai.’ ");
INSERT INTO num_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Pea 'e toki tali mo nātou, 'o pehē, ‘'Aliki, ne 'anefea he motou 'ilo'i 'Ou 'oku Ke hālofia, pe fiainua, pe 'āunofo, pe ta'ekofu, pe tengetange, pe ma'ua 'i te pilīsoné, 'o kailoa motou tokoni atu?’ ");
INSERT INTO num_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Pea 'e toki tali ange Ia kiā nātou, 'o pehē, ‘'Okou tala mo'oni atu kiā kōtou, ko te kailoa kotou fai pehē ki te si'i taha 'o Toku 'ū tokoua nei, ko te kailoa kotou fai ia kiā Aú.’ ");
INSERT INTO num_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Pea 'e 'alu atu 'ia nātou nei ki te tautea ta'engatá; kā ko te kau faileleí ki te ma'uli ta'engatá.” ");
INSERT INTO num_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pea kua faka'osi 'e Sīsū Tana 'ū akonaki kotoa pē, pea iange Ia ki Tana kau akó, ");
INSERT INTO num_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“'Oku kotou 'ilo'i kā 'osi ange te 'aho 'e ua pea hoko 'ia te Pāsová, pea 'e tukuange ai 'ia te Fanautama te Tangatá ke kalusefai.” ");
INSERT INTO num_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Pea toki fakataha 'ia te hau'aliki taula'alikí, mo te kau mātu'a 'o te kakai 'Isilelí, ki te loto'ā 'o te Taula'aliki Lahí, 'a ē 'oku hingoa ko Kaiafasí. ");
INSERT INTO num_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Pea ne'e notou fa'ufa'u ke puke fakafufū 'ia Sīsū, 'o tāmate'i. ");
INSERT INTO num_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ka ne'e notou pehē, “'Aua na'a fai lolotonga te kātoangá, na'a 'i ai he maveuveu 'i te kakaí.” ");
INSERT INTO num_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Pea 'i te kei nofo 'ia Sīsū 'i Pētani, 'i te fale 'o Saimone ko te kiliá, ");
INSERT INTO num_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ne'e ha'u he fafine, mo tana hina 'alapasita, ne'e fonu 'i te lolo tākai mahu'inga lahi 'aupito, 'o ina lilingi ki Tono fofongá, lolotonga Tana nofo 'i te kaí. ");
INSERT INTO num_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pea 'i te sio ki ai 'ia te kau akó ne'e notou 'ita, 'o notou pehē, “Ko te ā kua maumau'i ai 'ení? ");
INSERT INTO num_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","He kāpau ne'e fakatau atu ia, ne'e mei ma'u ai he pa'anga lahi ke foaki ki te masivá!” ");
INSERT INTO num_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ka ne'e mea'i 'e Sīsū te notou laú, 'o iange 'e Ia kiā nātou, “Ko te ā 'oku kotou fakamamahi ai ki te fafiné? He ko te ngāue lelei kua fai 'e ia kiā Aú. ");
INSERT INTO num_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ko te me'a ki te masivá 'e kotou feangai ai pē mo nātou; kā 'e kailoa kotou feangai ai pē mo Au. ");
INSERT INTO num_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","He ko tana lilingi te lolo nei ki Toku sinó, ko ta'aná fai ke teuteu'i Toku 'anga'angá ki fa'itoka. ");
INSERT INTO num_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","'Okou tala mo'oni atu kiā kōtou, ko te feitu'u kotoa pē 'i māmani 'e malanga 'aki ai 'ia te ongoongolelei ko 'ení, 'e lea 'aki ai foki 'ia te me'a ne'e fai 'e te si'i fafine nei, ko te fakamanatu kiā ia.” ");
INSERT INTO num_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ko te taimi ko iá ne'e 'alu ki te kau taula'aliki lahí he toko taha 'i te kau hongofulu mā uá, ko Siutasi 'Isikaliote, ");
INSERT INTO num_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","'o 'eke ange, “Ko te ā 'e kotou 'aumai ma'akú ka u lavaki'i Ia kiā kotou?” Pea notou alea mo ia ke konga siliva 'e tolungofulu. ");
INSERT INTO num_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Pea mei te taimi ko iá ne ina kumi faingamālie ai ke lavaki'i 'Ona. ");
INSERT INTO num_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pea 'i te 'uluaki 'aho 'o te Mā Ta'e Lēvaní, ne'e ōmai te kau akó kiā Sīsū, 'o 'eke ange, “Ko fea he feitu'u 'oku Ke loto ke motou teuteu'i ai Ma'au 'ia te Pāsová?” ");
INSERT INTO num_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Pea pehē ange Ia, “Ō pē ki te koló he 'e 'i ai he tangata, 'o iange ki ai, ‘'Oku pehē mai 'e te 'Alikí, “Kua hoko mai 'eni Toku taimí, pea 'e Au fai 'i tou falé 'ia te Pāsová mo Taku kau akó.” ’ ” ");
INSERT INTO num_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Pea ne'e fai 'e te kau akó 'o hangē ko te fekau 'e Sīsū kiā nātoú, 'o notou teuteu 'ia te Pāsová. ");
INSERT INTO num_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pea 'i te afiafi pō'ulí ne'e nofo ifo Ia ke kai, fakataha mo te kau hongofulu mā uá. ");
INSERT INTO num_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Pea 'i te lolotonga te notou kaí ne'e pehē ange Ia, “'Okou tala mo'oni atu kiā kōtou, ko te toko taha 'iā kōtou 'e ina lavaki'i 'Oku.” ");
INSERT INTO num_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Pea notou loto mamahi 'aupito, 'o notou kamata lea kiā Ia tāutaha, “'Oku kailoa ko au 'apē, 'Aliki?” ");
INSERT INTO num_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Pea iange Ia, 'o pehē, “Ko ia ko 'ē 'e velo fakataha mo Au tono nimá ki te tisí, ko ia ia 'e lavaki'i 'Okú. ");
INSERT INTO num_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","'Oku mo'oni ko te mole 'ia te Fanautama te Tangatá 'oku hangē ko ia kua tohi Ma'aná, kae pohoē 'ia te tangata 'e lavaki'i 'Oná! Ne ngutuhua ange ki te tangata ko iá kāpau ne'e kailoa fanau'i 'ona.” ");
INSERT INTO num_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Pea tali 'e Siutasi, 'a ia ne ina lavaki'i Iá, 'o pehē, “Ko au nai ia, Lāpai?” Pea iange Ia ki ai, “Ko ia pē kua ke lea 'akí.” ");
INSERT INTO num_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pea 'i te lolotonga te notou kaí, ne'e to'o 'e Sīsū he fe'i mā, 'o tāpuaki'i, mo pakipaki, 'o tufatufa ki te kau akó, mo pehē, “To'o 'o kai; ko Toku sinó 'eni.” ");
INSERT INTO num_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ne'e to'o 'e Ia mo he ipu, 'o fai he fakafeta'i, 'o 'avange kiā nātou, mo pehē, “Kotou inu kotoa pē mei ai; ");
INSERT INTO num_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","he ko Toku totó 'eni, ko te toto 'o te fuakavá, 'a ia 'oku lilingi kote'uhí ko te tokolahi, ke lava ai te fakamolemole angahalá. ");
INSERT INTO num_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kā 'Okou tala'i atu kiā kōtou, ngata heni, 'e kailoa 'aupito ke Au toe inu mei te fua ko 'eni 'o te vainé, 'o a'u ki te 'aho 'e Au toki inu ai ia kua fo'ou fakataha mo kōtou 'i te pule'anga 'o Taku Tamaí.” ");
INSERT INTO num_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pea kua fai te notou hiva himi, pea notou toki ō ake ki te ma'unga ko 'Ōlivé. ");
INSERT INTO num_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Pea toki pehē 'e Sīsū kiā nātou, “'E kotou tūkia kotoa pē 'iā Au 'i te pō nei. He kua tohi, ‘'E Au taa'i te tauhí, pea 'e mavetevete 'ia te fanga sipí.’ ");
INSERT INTO num_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kae 'osi ange Taku toetu'ú, 'e Au mu'amu'a 'iā kōtou ki Kāleli.” ");
INSERT INTO num_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kae tali ange 'e Pita kiā Ia, “Neongo 'e tūkia kotoa pē 'iā Koe, kā ko au, 'e kailoa 'aupito ke au tūkia 'o ta'engata.” ");
INSERT INTO num_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Pea iange 'e Sīsū kiā ia, “'Okou tala mo'oni atu kiā koe, ko te pō nei, 'i te he'iki ai 'u'ua te moá, kua tu'a tolu ta'aú fakafisinga'i 'Oku.” ");
INSERT INTO num_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pea iange 'e Pita kiā Ia, “'E kailoa 'aupito ke au fakafisinga'i 'Ou, neongo 'e iku ki taku mate fakataha mo Koe.” Pehē foki mo te lau Tana kau akó kotoa pē. ");
INSERT INTO num_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pea toki ha'u ai 'ia Sīsū mo nātou ki te feitu'u 'oku ui ko Ketisemani, pea pehē ange Ia ki Tana kau akó, “Kotou nofo heni, kae Au 'alu ki hē 'o lotu.” ");
INSERT INTO num_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pea ne Ina 'ave 'ia Pita, mo te ongo foha 'o Sēpetí, pea ne'e kamata ke mamahi Tono lotó 'o hoha'a lahi. ");
INSERT INTO num_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Pea iange 'e Ia kiā nātou, “'Oku mamahi lahi Toku laumālié, 'o hangē kā maté. Kotou tatali 'i heni, ke tou le'o mo Au.” ");
INSERT INTO num_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Pea 'alu si'i atu Ia, 'o fo'oifo ki Tono fofongá, mo lotu 'o pehē “'E Tamai, kāpau 'e lava, pea 'ave te ipu nei meiā Au. Kā neongo ia, kae'aua na'a fai ki Toku lotó, kā ki To'oú pē finangalo.” ");
INSERT INTO num_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pea ha'u Ia ki te kau akó, 'o 'ilo'i nātou 'oku notou momoe; pea iange Ia kiā Pita, “'Oku pehē koā te kotou ta'elava ke 'a'ala mo Au 'o houa 'e taha? ");
INSERT INTO num_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Le'o pē mo lotu, ke 'aua na'a kotou hū ki te 'ahi'ahi. 'Oku loto pē 'ia te laumālié ke fai, kā 'oku vaivai 'ia te kakanó.” ");
INSERT INTO num_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Pea toe 'alu Ia ko tono tu'a uá, 'o lotu, 'o pehē, “'E Tamai, kāpau 'e kailoa lava ke 'ave te ipu nei meiā Au, kā 'i Ta'akú pē inu, pe'i fai pē To'oú finangalo.” ");
INSERT INTO num_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pea toe ha'u Ia 'o 'ilo'i 'ia nātou 'oku notou kei momoe pē, he kua notou ongosia 'aupito. ");
INSERT INTO num_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Pea ne Ina tuku pē 'ia nātou, 'o toe 'alu ko tono tu'a tolú ke lotu, 'o toe fai 'aki pē 'ia te lea ko iá. ");
INSERT INTO num_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pea toki ha'u Ia ki te kau akó, 'o pehē kiā nātou, “Kotou momoe ai pe ā 'eni mo mālōlō. 'Ē, kua ofi 'ia te taimí ke lavaki'i ai 'ia te Fanautama te Tangatá ki te kau angahalá. ");
INSERT INTO num_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kotou tutu'u ake, kae tou ō; vakai, kua ofi mai Toku lavakí!” ");
INSERT INTO num_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Pea 'i te lolotonga Tana kei leá, tā 'oku ha'u 'ia Siutasi, ko te taha 'o te kau hongofulu mā uá, pea ha'u mo ia he fu'u kakai tokolahi mo te 'ū heletā mo te 'ū 'akau, ko te ōmai mei te kau taula'aliki lahí, mo te kau mātu'a 'o te kakaí. ");
INSERT INTO num_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Pea ko ia ne ina lavaki'i Iá ne ina tuku kiā nātou he faka'ilonga, 'i tana pehē, “Ko Ia ko 'ē 'e au 'uma ki Aí, ko Ia ia, kotou puke'i 'Ona.” ");
INSERT INTO num_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pea ha'u leva ia kiā Sīsū, 'o pehē, “'Ēī, Lāpai!” mo 'uma kiā Ia. ");
INSERT INTO num_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Pea iange 'e Sīsū ki ai, “Siana, ko te ā te me'a kua ke ha'u aí?” Pea toki 'unu mai 'ia te kakaí, 'o ala mālohi kiā Sīsū, 'o puke'i 'Ona. ");
INSERT INTO num_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pea vakai, ko te toko taha 'iā nātou ne'e kau mo Sīsuú ne'e unuhi ia tana heletaá, 'o taa'i te tamaio'aliki 'a te Taula'aliki Lahí, 'o tu'usi tono lau'i talingá. ");
INSERT INTO num_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Pea pehē ange 'e Sīsū kiā ia, “Fakafoki tau heletaá ki tono 'ai'angá; he ko nātou kotoa pē 'oku ala ki te heletaá 'e notou mate 'i te heletā. ");
INSERT INTO num_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","He 'oku ke pehē koā 'oku faingata'a kiā Au ke kole ki Taku Tamaí, ke 'aumai he kongakau 'āngelo 'e hongofulu mā ua, pe lahi ake? ");
INSERT INTO num_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kae fakamo'oni fefe'aki ai 'ia te 'ū Folafolá, 'a ia 'oku fakahaa'i ai kua pau ke hoko 'ia te 'ū me'a nei?” ");
INSERT INTO num_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Pea toki lea 'e Sīsū ki te kakaí, “Ko te kotou ōmai mo te heletā mo te 'akau ke puke 'aki 'Okú, hangē ko he kaiha'á! Ko te 'aho kotoa pē mo Taku nofo 'i te Temipalé 'o faiako, kā ne kailoa kotou puke'i ai 'Oku. ");
INSERT INTO num_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kā kua hoko 'ia te 'ū me'a 'ení kotoa pē, kote'uhí ke fakamo'oni ki te 'ū Folafola 'a te kau palōfitá.” Pea ne'e toki si'aki 'Ona 'e te kau akó kotoa pē, 'o notou hola. ");
INSERT INTO num_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Pea ko nātou ne'e puke 'ia Sīsuú ne'e notou taki ange 'Ona kiā Kaiafasi ko te Taula'aliki Lahí, pea ne'e fakataha ki ai 'ia te kau sikalaipé mo te kau mātu'á. ");
INSERT INTO num_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ka ne'e mulimuli atu kiā Ia 'ia Pita mei te mama'ó, 'o a'u ki te loto'ā 'o te Taula'aliki Lahí, pea hū ia ki loto, 'o nofo mo te kau le'o Temipalé ke vakai ki te me'a 'e hokó. ");
INSERT INTO num_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pea ko te kau taula'aliki lahí, mo te Sanetalimí kotoa pē, ne'e notou fiu tono kumi he kau fakamo'oni lohi ke tukuaki'i 'aki 'ia Sīsū, ke notou tāmate'i ai Ia; ");
INSERT INTO num_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ka ne'e kailoa notou ma'u, neongo ne'e ha'u 'ia te kau fakamo'oni lohi tokolahi. Kā ne faifaí pea tu'u mai he toko ua ");
INSERT INTO num_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","'o nā pehē, “Ne'e lau 'e te siana nei, ‘'Oku faingafua kiā Au ke vete 'ia te Fale Tapu 'o te 'Atuá, 'o toe langa 'i te 'aho 'e tolu.’ ” ");
INSERT INTO num_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Pea tu'u 'ia te Taula'aliki Lahí, 'o pehē kiā Ia, “'Oku kailoa koā Hau tali ki te me'a 'oku talatalaaki'i ai 'Ou mei te kau tangata nei?” ");
INSERT INTO num_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ka ne'e longo pē 'ia Sīsū ia. Pea toe lea 'ia te Taula'aliki Lahí, 'o pehē ange, “'Okou fekau kiā Koe 'i te 'Atua ma'ulí, ke Ke lea mo'oni mai pe ko te Kalaisí Koe, ko te 'Alo 'o te 'Atuá!” ");
INSERT INTO num_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Pea tali ange 'e Sīsū kiā ia, “Ko ia pē. Kā 'Okou tala'i atu kiā kōtou, 'e kotou mamata 'āmuli ki te Fanautama te Tangatá, 'oku nofo ki te nima to'omata'u 'o te 'Atua Māfimafí, pea 'e hoko mai Ia 'oku heka ki te 'ū 'ao 'o te langí.” ");
INSERT INTO num_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pea ne'e toki hae ifo 'e te Taula'aliki Lahí tono kofú, 'o pehē, “Kua Ina lea fia 'Atua; kote'uma'aki te tou toe kumi fakamo'oní? Ko 'eni kua kotou toki fanongo ki te lea fia 'Atuá. ");
INSERT INTO num_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ko te ā te kotou laú?” Pea notou tali 'o pehē, “'Oku totonu Ia ke mate!” ");
INSERT INTO num_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Pea notou toki 'anuhi Tono fofongá, mo tuki'i Ia. Pea sipi'i 'Ona he 'ihi, ");
INSERT INTO num_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","'o notou pehē, “'E Kalaisi, mate mai pe ko ai ne'e sipi'i 'Oú?” ");
INSERT INTO num_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pea ne'e nofo 'ia Pita 'i tu'a 'i te loto'aá. Pea ha'u kiā ia he fafine kaunanga, 'o pehē, “Ko koe foki ne ke 'iā Sīsū mei Kālelí.” ");
INSERT INTO num_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pea fakafisi ia 'i te 'ao 'o nātoú kotoa pē, mo pehē ange, “'Oku kailoa kita 'ilo'i 'ia te me'a 'oku ke lea ki aí.” ");
INSERT INTO num_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pea kua 'alu ia ki te fale hū'angá, pea ne'e sio kiā ia he fafine 'e taha, pea iange ia kiā natou ne'e notou 'i aí, “Ko te siana nei foki ne'e 'iā Sīsū mei Nāsaletí.” ");
INSERT INTO num_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pea toe fakafisi ia, mo fuakava, “'Oku kailoa 'ilo'i 'e kita 'ia te tangatá!” ");
INSERT INTO num_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pea toe si'i atú ne'e ōmai kiā ia 'ia nātou ne'e tutu'u 'i aí, 'o notou pehē ange kiā Pita, “'Ē, 'oku mo'oni pē 'oku ke kau foki ki te fa'ahinga ko iá; he 'oku 'ilonga ia mei te fasi 'o tau leá.” ");
INSERT INTO num_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pea toki hanga ia, 'o tuki mo fuakava, “'Oku kailoa 'aupito ha'akú 'ilo kau ki te Tangatá.” Pea ne'e 'u'ua leva 'ia te moá. ");
INSERT INTO num_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pea manatu'i ai 'e Pita 'ia te lea 'a Sīsuú, 'a ia ne'e pehē, “'I te he'iki ai 'u'ua te moá, kua tu'a tolu ta'aú fakafisinga'i 'Oku.” Pea 'alu leva ia ki tua'ā, 'o tangi mamahi. ");
INSERT INTO num_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pea 'i te pongipongi aké, ne'e alea'i 'e te kau taula'aliki lahí kotoa pē mo te kau mātu'a 'o te kakaí he me'a ke notou tāmate'i ai 'ia Sīsū. ");
INSERT INTO num_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pea notou toki ha'i Ia, 'o 'ave kiā Pailato ko te kōvaná. ");
INSERT INTO num_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pea 'i te toki 'ilo'i 'e Siutasi ko Tono lavakí, tā kua fakamāumatea Iá, ne'e fakatomala ia, 'o toe 'aumai 'e ia 'ia te konga siliva 'e tolungofulú ki te kau taula'aliki lahí mo te kau mātu'á, ");
INSERT INTO num_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","'o pehē ange, “Kua u fai angahala, he kua u lavaki'i ke mate 'ia te toto ta'ehalaiá.” Ka ne'e tali ange 'e nātou, “He 'oku motou kau ai? 'Oku 'iā koe pē ia!” ");
INSERT INTO num_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Pea ne ina laku atu 'ia te 'ū konga silivá ki te Fale Tapú, pea toki 'alu ia 'o tautau pē 'ona. ");
INSERT INTO num_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pea to'o mai 'e te kau taula'aliki lahí 'ia te 'ū konga silivá 'o notou pehē, “'Oku kala ngafua ke sī 'eni ki te pa'anga 'o te Temipalé, he ko te totongi toto.” ");
INSERT INTO num_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pea ne'e notou alea ke fakatau 'aki ia 'ia te 'api 'o te tufunga ipu 'umeá mo'o fa'itoka 'o te kakai mei mulí. ");
INSERT INTO num_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ko te 'uhinga ia tono ui 'o te 'api ko iá ko 'Api Toto, 'o a'u ki te 'aho nei. ");
INSERT INTO num_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Pea ne'e toki fakamo'oni 'eni ki te me'a ne'e folafola 'aki 'iā Selemaia ko te palōfitá, 'o pehē, “Pea ne'e notou to'o 'ia te konga siliva 'e tolungofulu, ko te mahu'inga 'o Ia ne'e fakataú, 'a ia ne'e notou fua tono mahu'ingá kote'uhí ko te kakai 'Isilelí; ");
INSERT INTO num_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","'o totongi 'aki ia 'ia te 'api 'o te tufunga ipu 'umeá, 'o hangē ko te tu'utu'uni 'a te 'Alikí kiā au.” ");
INSERT INTO num_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Pea ne'e tu'u 'ia Sīsū 'i te 'ao 'o te kōvaná. Pea fehu'i ange 'e te kōvaná kiā Ia, 'o pehē, “Ko Koe 'ia te Tu'i 'o te kakai Siú?” Pea pehē ange 'e Sīsū ki ai, “Ko ia pē.” ");
INSERT INTO num_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pea 'i tono talatalaaki'i 'Ona 'e te kau taula'aliki lahí mo te kau mātu'á, ne'e longo pē Ia. ");
INSERT INTO num_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pea toki me'a 'e Pailato kiā Ia, “'Oku kala Ke tokanga koā ki te 'ū me'a kua notou faka'ilo kau kiā Koé?” ");
INSERT INTO num_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ka ne'e kailoa toe tali ange Ia he mama'i lea 'e taha, ko ia ne'e ofo 'aupito 'ia te kōvaná. ");
INSERT INTO num_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pea ko te anga 'o te kōvaná, kā hoko he kātoanga, 'e vete ange ia he pōpula, he toko taha 'e loto ki ai 'ia te kakaí. ");
INSERT INTO num_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Pea ne'e 'i ai he pōpula ongoongoa, ne'e ui ko Palāpasa. ");
INSERT INTO num_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pea 'i te notou fakataha maí, ne'e pehē 'e Pailato kiā nātou, “Ko ai 'oku kotou loto ke au vete atú? 'Ia Palāpasa, pe ko Sīsū, 'a ē 'oku ui ko te Kalaisí?” ");
INSERT INTO num_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","He ne'e 'ilo'i 'e ia ko te meheká pē ne'e notou tukuange ai 'Ona kiā iá. ");
INSERT INTO num_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pea 'i tana nofo ifo ki te nofo'anga fakamaaú, ne'e fekau ange tono malí 'o pehē, “'Aua na'a ke kau he me'a ki te Tangata Mā'oni'oni nā, he ne au hoha'a lahi 'ane hengihengi 'i taku misi ko te me'a 'iā Ia.” ");
INSERT INTO num_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pea ko te kau taula'aliki lahí mo te kau mātu'á ne'e notou fakaloto'i te kakaí ke notou kole ke tukuange mai 'ia Palāpasa, kae tāmate'i 'ia Sīsū. ");
INSERT INTO num_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pea toe me'a 'ia te kōvaná, 'o pehē kiā nātou, “Ko ai 'i te ongo me'a nei 'oku kotou loto ke au vete atú?” Pea notou pehē, “Ko Palāpasa!” ");
INSERT INTO num_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pea pehē 'e Pailato kiā nātou, “Pea ko te ā 'e au fai kiā Sīsū 'a ē 'oku ui ko te Kalaisí?” Pea notou kaikaila kotoa pē, “Kalusefai Ia!” ");
INSERT INTO num_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pea pehē ange ia, “He ko te ā Ha'aná kovi kua fai?” Ka ne'e 'ā'āsili ai te notou kalangá, “Kalusefai Ia!” ");
INSERT INTO num_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pea 'i te vakai 'e Pailato, 'oku kailoa lava hana me'a, kā 'e faifai pea hoko he maveuveú, ne'e to'o ia he vai, 'o fanofano 'i te 'ao 'o te kakaí, mo pehē ia, “'Oku 'ata'atā 'ia kita ia mei te toto 'o te Tangata mā'oni'oni nei; 'oku 'iā kōtou ia.” ");
INSERT INTO num_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Pea lea 'ia te kakaí kotoa pē, 'o notou pehē, “Tuku To'onó toto ke 'eke kiā mātou mo te motou fānaú!” ");
INSERT INTO num_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pea toki vete ange ia 'ia Palāpasa kiā nātou, kae kau'imaea'i 'ia Sīsū, 'o toki tukuange 'Ona ke kalusefai. ");
INSERT INTO num_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pea toki 'ave 'e te kau tau 'a te kōvaná 'ia Sīsū ki te Palasí, 'o notou tānaki te vāhenga taú kotoa pē ki ai. ");
INSERT INTO num_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Pea notou vete Tono kofú, 'o 'ai kiā Ia he pulupulu kula 'aho'aho. ");
INSERT INTO num_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pea notou fī he kalauni talatala, 'o 'ai ki Tono fofongá, pea notou 'ai he va'a kaho ki Tono nima to'omata'ú. Pea notou toki tū'ulutui 'i Tono 'aó, 'o toutou luma kiā Ia, 'o pehē, “'Ēī, Tu'i 'o te kakai Siú!” ");
INSERT INTO num_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pea notou 'anuhi Ia, 'o to'o 'ia te va'a kahó, 'o toutou taa'i 'aki Tono fofongá. ");
INSERT INTO num_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pea 'osi ange te notou va'inga'aki Iá, ne notou to'o meiā Ia 'ia te pulupulú, pea notou 'ai kiā Ia Tono kofu 'O'oná, 'o notou taki atu 'Ona ke kalusefai. ");
INSERT INTO num_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pea 'i te notou 'alu atu ki tua'aá, ne'e notou 'ilo'i ai he tangata Sailine, ko tono hingoá ko Saimone, 'o notou fekau'i ia ke fua Tono kolosí. ");
INSERT INTO num_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pea 'i te notou a'u ki te feitu'u 'oku ui ko Kolokota, (ko tono 'uhingá, ko te feitu'u 'o te 'ulupoko,) ");
INSERT INTO num_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ne'e notou 'avange kiā Ia he uaine kua hu'i 'aki te 'ahu, ke inu; kā 'i Tana kamata 'ahi'ahi'í, ne'e kala Ina loto ke inu. ");
INSERT INTO num_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pea ne'e notou kalusefai Ia, pea notou tufa 'aki te talotalo Tono 'ū kofú. ");
INSERT INTO num_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pea notou nofo ifo 'i ai 'o le'ohi Ia. ");
INSERT INTO num_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pea ne'e notou 'ai ki lunga 'i Tono funga fofongá te 'uhinga 'o Tono tauteá, 'a ia ne'e tohi ai 'o pehē, “KO SĪSŪ 'ENI KO TE TU'I 'O TE KAKAI SIU.” ");
INSERT INTO num_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pea ne'e kalusefai fakataha mo Ia he ongo kaiha'a, ko te taha mei to'omata'u mo te taha mei to'ohema. ");
INSERT INTO num_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Pea ko te kakai ne'e ō angé ne'e notou manuki ki Ai, mo kalokalo te notou 'ulú, ");
INSERT INTO num_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","'o notou pehē, “'Ia Koe 'oku holoki Fale Tapu 'o langa 'i te 'aho 'e tolú, 'ē, fakahaofi 'Ou! Kāpau ko te 'Alo Koe 'o te 'Atuá, pe'i 'alu ifo mei te kolosí!” ");
INSERT INTO num_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Pehē foki mo te kau taula'aliki lahí mo te kau sikalaipé mo te kau mātu'á ne'e notou manuki'i 'Ona, ");
INSERT INTO num_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","'o pehē, “Ne Ina fakahaofi 'ia te kakai kehé; kā 'oku kailoa lava Ia ke fakahaofi 'Ona! Ko te Tu'i 'Isilelí takua 'eni; tuku ke Ina 'alu ifo leva mei te kolosí, pea 'e motou tui kiā Ia! ");
INSERT INTO num_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ne'e falala takua Ia ki te 'Atuá, pe'i tuku ke fakahaofi 'Ona 'e te 'Atuá, 'o kāpau 'oku 'ofa mai kiā Ia. Hē ne Ina pehē takua, ‘Ko te 'Alo 'o te 'Atuá 'ia Au.’ ” ");
INSERT INTO num_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ne pehē foki mo tono manuki'i 'e te ongo kaiha'a ne'e kalusefai fakataha mo Iá. ");
INSERT INTO num_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pea ne'e tō he pō'uli ki te fanuá fuli pē mei te ho'atā mālié 'o a'u ki te tolu afiafí. ");
INSERT INTO num_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pea fe'unga nai mo te tolu afiafí ne'e kalanga le'o lahi 'ia Sīsū, 'o pehē, “'Īlai, 'Īlai, lama sapakatani?”, ko tono 'uhingá, “'E Toku 'Atua, 'e Toku 'Atua, ko te ā kua Ke si'aki ai 'Okú?” ");
INSERT INTO num_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pea ko te 'ihi 'iā nātou ne'e tutu'u 'i aí, 'i te notou fanongo ki aí ne'e notou pehē, “Tā 'oku ui 'ia te Siana nei kiā 'Ilaisiā!” ");
INSERT INTO num_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Pea lele leva he notou toko taha, 'o to'o he oma, 'o unu 'i te vinika, 'o hunuki 'aki he va'a kaho, 'o 'avange ke inu 'e Ia. ");
INSERT INTO num_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kae pehē mai tono toé, “'Ē, tou vakai pe 'e ha'u 'ia 'Ilaisiā 'o fakahaofi 'Ona.” ");
INSERT INTO num_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pea toe kalanga 'ia Sīsū 'o le'o lahi, 'o Ina tukuange Tono laumālié. ");
INSERT INTO num_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Pea vakai, ko te puipui 'o te Fale Tapú ne'e mahaeua mei lunga ki lalo. Pea ne'e mofuike 'ia te fanuá, pea mafahifahi 'ia te 'ū makatu'ú; ");
INSERT INTO num_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","pea matangaki 'ia te 'ū fanualotó, pea ne'e fokotu'u te 'anga'anga 'o te kakai mā'oni'oni 'ihi ne'e momoe 'i aí, ");
INSERT INTO num_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","pea notou ha'u mei te 'ū fanualotó hili ange te toetu'u 'a Sīsuú, 'o notou 'alu ki te Kolo Tapú, 'o notou hā ki te 'ihi. ");
INSERT INTO num_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pea ko te senitulioó, mo nātou ne'e kau mo ia 'i tono le'ohi 'o Sīsuú, 'i te notou vakai ki te mofuiké, mo te 'ū me'a kehekehe ne'e hokó, ne'e notou 'ilifia 'aupito, 'o notou pehē, “Tā ne'e mo'oni pē, ko te 'Alo 'eni 'o te 'Atuá!” ");
INSERT INTO num_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pea ne'e nofo 'i ai he kau fafine, 'o notou sisio mai mei te mama'ó; ko te fa'ahinga ne'e mulimuli kiā Sīsū mei Kāleli ke tauhi kiā Ia. ");
INSERT INTO num_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ko te notou 'ihi ko Mele mei Makitalá, mo Mele ko te fa'ē 'a Sēmisi mo Siosē, pea mo te fa'ē 'a te ongo foha 'o Sēpetí. ");
INSERT INTO num_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pea 'i tana afiafi ifó, ne'e 'alu ange he tangata koloa'ina mei 'Alematea; ko tono hingoá ko Siosifa, pea ko te toko taha foki ia ne'e ako 'iā Sīsū. ");
INSERT INTO num_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pea 'alu ia kiā Pailato, 'o kole te sino 'o Sīsuú; pea toki fekau 'e Pailato ke 'avange ia. ");
INSERT INTO num_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Pea 'ave 'e Siosifa 'ia te 'anga'angá, 'o teu 'aki he tupenu mahu'inga mo ma'a, ");
INSERT INTO num_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","pea toki fakatakoto Ia 'i tono fanualoto fo'ou 'o'oná, 'a ia kua ina foa 'i te loto maká. Pea ne ina fakateka he fu'u maka 'o songo 'aki 'ia te fanualotó, pea toki 'alu. ");
INSERT INTO num_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ka ne'e nofo ai pē 'ia Mele mei Makitalá mo te Mele 'e tahá, 'o fehangahangai mo te fa'itoká. ");
INSERT INTO num_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pea a'u ki te 'aho 'e tahá, ko te Sāpate ia, ne'e fakataha te kau taula'aliki lahí mo te kau Fālesí kiā Pailato, ");
INSERT INTO num_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","'o notou pehē, “'Aliki, 'oku motou manatu'i ne'e lau 'e te siana kākā ko 'ená 'i Tana kei ma'ulí, 'o pehē, ‘Hili te 'aho 'e tolu 'e Au toetu'u.’ ");
INSERT INTO num_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ko ia ke ke fekau mu'a ke malu'i te fanualotó, 'o a'u ki tono tolu 'o te 'ahó, na'a faifai angé kua ōmai Tana kau akó, 'o kaiha'asi Ia, 'o notou tala ki te kakaí, kua toetu'u Ia mei te maté; pea 'e 'ange'ange te lohi ki mu'á 'i te lohi ki mulí!” ");
INSERT INTO num_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pea iange 'e Pailato kiā nātou, “Ko 'ena te kau le'ó; kotou ō 'o fai te kotou lelei tahá, 'i tono malu'i te fanualotó.” ");
INSERT INTO num_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pea ne'e notou ō 'o ngaahi ke malu 'ia te fanualotó, pea notou sila'i foki mo te maká, pea tuku ki ai mo te kau le'o. ");
INSERT INTO num_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pea 'i te faka'osi 'o te Sāpaté, pea kamata mafoa mai te ata 'o te fu'aki 'aho 'o te uiké, ne'e ō 'ia Mele mei Makitalá mo te Mele 'e tahá ke vakai 'ia te fa'itoká. ");
INSERT INTO num_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","'Ohovale pē kua tō he fu'u mofuike, he ne'e 'alu ifo mei te langí he 'āngelo 'a te 'Alikí, 'o teka'i mai te maká, 'o hekaheka 'i ai. ");
INSERT INTO num_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Pea ne'e hangē tana hā maí ko te tapa te 'uhilá, pea ne'e hinapaki tono kofú 'o hangē ko te sinoú. ");
INSERT INTO num_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Pea ne'e tete 'ia te kau le'ó 'i te notou manahē kiā iá, 'o hangē kā notou maté. ");
INSERT INTO num_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pea lea ange te 'āngeló ki te ongo fafiné, “'Aua 'e kulā manahē; hē 'okou 'ilo'i ko te kulā kumi 'ia Sīsū, 'a ē ne'e kalusefaí. ");
INSERT INTO num_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","'Oku kailoa 'i heni Ia, he kua Ina toetu'u, 'o hangē ko Tana me'á. Kulā ōmai 'o sio ki te feitu'u ne'e takoto ai 'ia te 'Alikí. ");
INSERT INTO num_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Pea kulā ō leva ke vave 'o tala ki Tana kau akó, ‘Kua toetu'u Ia mei te pekiá; pea ko 'eni 'oku mu'amu'a Ia 'iā kōtou ki Kāleli; pea 'e kotou mamata kiā Ia 'i ai.’ Ko 'eni 'okou tala'i atu kiā kōlua.” ");
INSERT INTO num_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Pea nā ō leva mei te fanualotó, kua nā manahē mo te fiafia lahi; 'o nā felele'i ke fei mo tala ki Tana kau akó. ");
INSERT INTO num_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Pea 'ohovale pē, kua fakafetaulaki mai 'ia Sīsū kiā nāua, 'o Ina me'a mai, “Mālō te kulā lelei!” Pea ō atu 'ia te ongo fafiné 'o puke Tono va'é, 'o hū kiā Ia. ");
INSERT INTO num_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Pea folafola ange 'e Sīsū kiā nāua, “'Aua 'e kulā manahē; kulā ō pē 'o fakahā ki Toku 'ū tokouá ke notou ō ki Kāleli, pea 'e notou mamata 'i ai kiā Au.” ");
INSERT INTO num_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pea lolotonga te nā oó, tā ne'e ō ki kolo he 'ihi 'o te kau le'ó, 'o notou fakamatala ki te kau taula'aliki lahí 'ia te 'ū me'a fuli pē ne'e hokó. ");
INSERT INTO num_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Pea kua notou fakataha mo te kau mātu'á, 'o notou fa'ufa'u, pea notou 'avange leva he fu'u pa'anga ki te kau sōtiá, ");
INSERT INTO num_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","'o notou iange, “Ko 'eni te kotou leá, ‘Ne ha'u pō'uli Tana kau akó, 'o kaiha'asi 'Ona lolotonga te motou momoé.’ ");
INSERT INTO num_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pea kāpau 'e faka'ilo 'eni ki te kōvaná, 'e motou fakaloto'i 'ona, kae 'ata'atā 'ia kōtou.” ");
INSERT INTO num_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Pea notou to'o 'ia te pa'angá, 'o fai 'o hangē ko te notou fale'í; pea ko tono tala ko iá kua fakamafola holo 'i te kakai Siú, 'o a'u mai ki te 'aho nei. ");
INSERT INTO num_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Pea ko te kau ako 'e hongofulu mā tahá ne'e notou fononga ki Kāleli, ki te ma'unga ne'e tu'utu'uni 'e Sīsū kiā nātoú. ");
INSERT INTO num_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pea 'i te notou mamata kiā Iá ne'e notou hū; ka ne'e tāla'a te 'ihi. ");
INSERT INTO num_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Pea ha'u 'ia Sīsū kiā nātou, 'o pehē ange, “Kua tuku kiā Au 'ia te pule kotoa pē 'i langi pea ki māmani. ");
INSERT INTO num_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ko ia ke kotou ō, 'o ngaahi 'ia te kakai kotoa pē ko Taku kau ako, 'i te papitaiso nātou ki te huafa 'o te Tamai mo te 'Alo mo te Laumālie Mā'oni'oni, ");
INSERT INTO num_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","mo ako'i 'ia nātou ke tauhi 'ia te 'ū me'a kotoa pē 'Okou tu'utu'uni atú. Pea ko 'eni, 'Okou 'iā kōtou 'e Au 'i te 'aho kotoa pē, 'o a'u ki te ngata'anga 'o māmani.”");
INSERT INTO num_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ko te kamata'anga 'o te ongoongolelei 'o Sīsū Kalaisi, ko te 'Alo 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Hangē pē ko te me'a kua tohi 'e te palōfita ko 'Aiseá, “Ko 'eni, 'Okou fekau Taku talafekaú ke mu'amu'a 'i Tou 'aó, ke teuteu'i Tou alá. ");
INSERT INTO num_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ko te le'o 'o he taha 'oku kalanga 'i te toafá, ‘Kotou teuteu te hā'ele'anga 'o te 'Alikí, fakatonutonu Tono 'ū alá.’ ” ");
INSERT INTO num_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ne'e fai papitaiso 'e Sione 'i te toafá, mo malanga 'aki 'ia te papitaiso 'o te fakatomalá ki te fakamolemole 'o te angahalá. ");
INSERT INTO num_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Pea ne'e ō atu kiā ia 'ia te kakai kotoa pē 'o Siutea, mo nātou mei Selusalemá; 'o notou papitaiso 'iā ia 'i te vaitafe ko Sioataní, 'i te vete te notou 'ū angahalá. ");
INSERT INTO num_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Pea ne'e kofu 'aki 'e Sione he fulufulu'i kāmeli, mo no'o tono kongalotó 'aki te kili'i manu. Pea ko tana me'akaí ko te fanga he'e mo te huhua'i honi vao. ");
INSERT INTO num_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Pea ne'e malanga ia, 'o pehē, “'Oku mulimuli mai he Toko Taha 'oku mālohi ange 'iā au; pea 'oku kailoa taau 'ia kita ke punou 'o vete te nono'o Tono senitoló. ");
INSERT INTO num_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ko te mo'oni, 'okou papitaiso kōtou 'aki 'ia te vai, kā 'e papitaiso 'e Ia 'ia kōtou 'aki 'ia te Laumālie Mā'oni'oní.” ");
INSERT INTO num_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Pea 'i te kuonga ko iá ne'e ha'u 'ia Sīsū mei Nāsaleti 'i Kālelí, 'o papitaiso 'iā Sione 'i Sioatani. ");
INSERT INTO num_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pea 'i Tana 'alu ake mei te vaí, ne Ina mamata atu kua mavae ua 'ia te langí, pea 'oku 'alu ifo kiā Ia 'ia te Laumālié 'i te tatau 'o he lupe. ");
INSERT INTO num_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Pea ongo mai he le'o mei te langí ne'e pehē mai, “Ko Toku 'Alo Pelé 'ia Koe; ko Koe 'Okou hōifua ki aí.” ");
INSERT INTO num_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pea ne'e tataki leva 'Ona 'e te Laumālié ki te toafá. ");
INSERT INTO num_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Pea ne'e nofo Ia 'i te toafá 'o 'aho fāngofulu, 'o fai ai Tono 'ahi'ahi'i 'e Sētane. Pea ne'e 'i ai Ia mo te fanga manu kaivaó; pea ne'e tauhi kiā Ia 'e te kau 'āngeló. ");
INSERT INTO num_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pea kua fakahū 'ia Sione ki te pilīsoné, pea ha'u 'ia Sīsū ki Kāleli, 'o malanga 'aki te ongoongolelei 'a te 'Atuá, ");
INSERT INTO num_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","'o pehē, “Kua kakato te taimí, pea kua ofi 'ia te Pule'anga 'o te 'Atuá; ko ia, kotou fakatomala 'o tui ki te Kōsipelí.” ");
INSERT INTO num_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Pea 'i Tana hā'ele ange 'i te matātai 'o te Tai 'o Kālelí, ne'e mamata atu Ia kiā Saimone mo 'Anitelū ko te tehina 'o Saimoné, 'oku fai te nā sili, he ko te ongo tautai. ");
INSERT INTO num_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Pea lea atu 'ia Sīsū kiā nāua, “Kulā ōmai 'o mulimuli 'iā Au; pea 'e Au ngaahi kōlua ko te ongo tautai tangata.” ");
INSERT INTO num_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pea nā si'aki leva te nā kupengá, 'o mulimuli kiā Ia. ");
INSERT INTO num_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Pea toe laka si'i atu 'ia Sīsū, 'o vakai kiā Sēmisi ko te foha 'o Sēpetí, mo Sione ko tono tehiná, 'oku nā 'i te vaká 'o fai te nā pena kupenga. ");
INSERT INTO num_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pea ne Ina ui leva 'ia nāua, pea nā tukuange te nā tamaí ko Sēpeti 'i te vaká mo te kau ngāue ungá, 'o nā mulimuli kiā Ia. ");
INSERT INTO num_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Pea notou fononga atu 'o hū ki Kāpaneume; pea ne'e hū Ia 'i te Sāpaté ki te falelotú 'o faiako. ");
INSERT INTO num_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Pea ne'e notou ofo 'aupito 'i te anga 'o Tana faiakó; hē ne Ina ako'i 'ia nātou 'o hangē ko he pule, 'o kailoa hangē ko te kau sikalaipé. ");
INSERT INTO num_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pea ne'e 'i te notou falelotú he tangata ne'e 'iā ia he fa'ahikehe; pea ne'e kaila ake ia, ");
INSERT INTO num_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","'o pehē, “Ko Tou ā 'ia māua, 'e Sīsū mei Nāsaleti? Kua ke ha'u ai ke faka'auha 'ia māuá? 'Okou 'ilo'i Koe, ko te Taha Tapu Koe 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pea lolomi 'ona 'e Sīsū, 'o pehē, “Tuku tau leá, pea hū mai ki tu'a meiā ia!” ");
INSERT INTO num_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Pea hanga 'e te fa'ahikehé, 'o ha'aki te tangatá ki lalo; mo 'ai tana fu'u kaila, 'o toki hū mai ki tu'a meiā ia. ");
INSERT INTO num_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Pea ne'e fu'u 'ohovale 'ia nātou kotoa pē; 'o notou fe'ekenaki 'iā nātou 'o pehē, “Ko te ā nai 'eni? Ko te ā te akonaki fo'ou nei? He 'oku fekau 'e Ia 'i te mālohi ki te kau fa'ahikehé, pea notou talangafua leva kiā Ia!” ");
INSERT INTO num_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Pea ne'e mafola leva Tono ongoongó 'i te feitu'u kotoa pē 'o Kāleli. ");
INSERT INTO num_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pea 'i te notou hū atu mei te falelotú, ne Ina hū ki te fale 'o Saimone mo 'Aniteluú, fakataha mo Sēmisi mo Sione. ");
INSERT INTO num_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pea ne'e takoto ai 'ia te fa'ē 'a te mali 'o Saimoné, 'oku puke 'i te mofí; pea notou fakahaa'i ange kiā Sīsū. ");
INSERT INTO num_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Pea 'alu atu Ia ki ai, 'o puke tono nimá 'o fokotu'u; pea mahu'i leva te mofí meiā ia, pea hanga ia 'o tauhi kiā nātou. ");
INSERT INTO num_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pea 'i te afiafi ifó, kua tō 'ia te la'aá, ne'e notou 'aumai kiā Ia 'ia te kakai kotoa pē ne'e puke, mo nātou ne'e 'ulusino ai 'ia te kau tēvoló. ");
INSERT INTO num_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Pea fakataha mai 'ia te koló kotoa pē ki te matapā 'o te falé. ");
INSERT INTO num_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Pea ne'e fakama'uli he tokolahi 'iā nātou ne'e puke 'i te fa'ahinga mahaki kehekehe, mo Ina kapusi he tokolahi 'o te kau tēvoló. Pea ne'e kailoa Ina tuku ke lea 'ia te kau tēvoló, kote'uhí he ne'e notou 'ilo'i Ia. ");
INSERT INTO num_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pea ne'e tu'u hengihengi ake 'ia Sīsū 'oku kei pō'ulí, 'o 'alu ki te feitu'u lala, 'o fai ai Tana lotu. ");
INSERT INTO num_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Pea mulimuli kiā Ia 'ia Saimone mo nātou ne'e 'iā iá, ");
INSERT INTO num_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","pea 'i te notou 'ilo'i Iá, ne'e notou pehē ki Ai, “'Oku kumi 'e te fu'u kakaí kotoa pē kiā Koe!” ");
INSERT INTO num_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pea pehē 'e Ia kiā nātou, “Tou ō tātou ia ki te 'ū kolo ofi maí, kote'uhí ke Au malanga ki ai foki; he ko te me'a ia ne Au ha'u aí.” ");
INSERT INTO num_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Pea ne'e malanga Ia 'i te notou 'ū falelotú 'i Kāleli fuli pē, mo kapusi tēvolo foki. ");
INSERT INTO num_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Pea ha'u kiā Ia he tangata kilia, 'o tū'ulutui kiā Ia, mo kole ange, 'o pehē, “Ka ne Ke loto ke fai, 'e Ke lava ke fakama'a 'oku.” ");
INSERT INTO num_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Pea langa te fatu 'o Sīsuú 'i te 'ofa, 'o mafao atu Tono nimá 'o ala kiā ia, mo pehē, “'Okou loto pē; ke ma'a 'ia koe!” ");
INSERT INTO num_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Pea 'i Tana folafolá, ne'e matafi leva te kiliá meiā ia, 'o ma'a ai. ");
INSERT INTO num_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Pea na'ina'i mamafa 'e Sīsū kiā ia, 'o toki fekau ke 'alú, ");
INSERT INTO num_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","'o pehē ki ai, “Tokanga ke 'aua na'a ke tala te me'a nei ki he taha; kā ke 'alu pē 'o fakahaa'i 'ou ki te taula'alikí, pea 'avange 'ia te me'a ne'e tu'utu'uni 'e Mōsesé kote'uhí ko tou fakama'a, ko te fakamo'oni kiā nātou.” ");
INSERT INTO num_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kā ne 'alu pē ia 'o ongoongoa mo talanoa'i holo 'ia te me'á; ko ia ne'e kailoa kei lava 'e Sīsū ke 'alu fakahā 'Ona he kolo, ka ne'e nofo pē Ia 'i tua'ā, 'i te 'ū feitu'u lala. Pea ne'e ō atu te kakaí kiā Ia mei te feitu'u kotoa pē. ");
INSERT INTO num_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pea 'i te 'osi mei ai he 'ū 'aho 'ihi ne'e toe 'alu Ia ki Kāpaneume, pea ne'e ongo atu kua 'i fale Ia. ");
INSERT INTO num_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Pea fakataha leva ki ai he tokolahi; 'io, ne'e faifai pea na'a mo te matafalé ne'e kailoa haofia. Pea malanga 'aki 'e Ia te Folafolá kiā nātou. ");
INSERT INTO num_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Pea ōmai he 'ihi kiā Ia mo he tangata mamatea, kua fata mai 'e te toko fā. ");
INSERT INTO num_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pea 'i te kailoa notou lava ke fakaofiofi 'ona kiā Sīsuú, kote'uhí ko te tokolahi 'o te kakaí, ne'e notou avangi te 'ato 'o te fale ne'e 'i ai Iá, pea kua 'a'au kotoa, 'o notou tukutuku ifo 'ia te moe'anga ne'e takoto ai 'ia te mamateá. ");
INSERT INTO num_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pea 'i te vakai 'e Sīsū ki te notou tuí, ne'e pehē ange Ia ki te mamateá, “Toku foha, kua fakamolemole'i tau 'ū angahalá.” ");
INSERT INTO num_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Pea ko te 'ihi 'o te kau sikalaipe ne'e nofo 'i aí, ne'e notou fifili 'i te notou lotó, 'o pehē, ");
INSERT INTO num_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ko te ā 'oku lea fia 'Atua ai 'ia te siana nei? He ko ai 'oku mafai ke fakamolemole angahala, kā ko te 'Atuá Toko Taha pē?” ");
INSERT INTO num_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ka ne'e 'ilo'i pē 'e Sīsū 'i Tono laumālié 'oku pehē te notou fifilí, pea lea ange Ia kiā nātou, “Ko te ā 'oku kotou fifili ai 'i te kotou lotó ki te 'ū me'a nei? ");
INSERT INTO num_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","He ko te fea 'oku faingafuá, 'ia te pehē ki te tangata mamate nei, ‘Kua fakamolemole tau 'ū angahalá,’ pe ko te pehē, ‘Tu'u, to'o tou moe'angá, pea 'eva'eva’? ");
INSERT INTO num_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kā kote'uhí ke kotou 'ilo'i, 'oku mafai 'e te Fanautama te Tangatá ke fakamolemole angahala 'i māmani, (pea hanga Ia 'o lea ki te tangata mamateá,) ");
INSERT INTO num_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","'Okou tala'i atu kiā koe, tu'u, to'o tou moe'angá, pea 'alu ki tou 'apí.” ");
INSERT INTO num_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Pea tu'u leva ia, 'o to'o tono moe'angá, 'o 'alu atu mei ai 'i te 'ao 'o te kakai kotoa pē. Ko ia ne'e notou fakatumutumu kotoa pē, 'o notou fakamālō'ina 'ia te 'Atuá, mo notou pehē, “Kua he'iki ai 'aupito ke tou mamata tātou ia he me'a pehē!” ");
INSERT INTO num_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Pea toe hā'ele atu Ia 'i te matātaí; pea ha'u kiā Ia 'ia te kakaí kotoa pē, pea ne'e faiako Ia kiā nātou. ");
INSERT INTO num_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pea 'i Tana 'alu atú, ne'e mamata Ia kiā Līvai, ko te foha 'o 'Alefiusi, 'oku nofo mai 'i te fale tuté; pea iange 'e Sīsū kiā ia, “Mulimuli kiā Au.” Pea tu'u mai ia 'o mulimuli kiā Ia. ");
INSERT INTO num_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pea ne'e kainanga Ia 'i te fale 'o Līvaí, pea ne'e tokolahi foki 'ia te kau tānaki tukuhau mo te kau angahala ne'e notou nofo mo Sīsū mo Tana kau akó 'i te kaí, he ne'e fa'a tokolahi 'ia nātou ne'e mulimuli kiā Iá. ");
INSERT INTO num_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pea 'i te sio atu te kau sikalaipé mo te kau Fālesí kiā Sīsū 'oku notou kakai fakataha mai mo te kau angahalá mo te kau tānaki tukuhaú, ne'e notou lea ki Tana kau akó, 'o pehē, “Ko te ā 'oku kai mo inu fakataha ai 'ia Sīsū mo te kau tānaki tukuhaú mo te kau angahalá?” ");
INSERT INTO num_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Pea ne'e fanongo 'e Sīsū ki ai, 'o iange kiā nātou, “Ko te tangata faito'ó 'oku kala ma'a te ma'uli leleí, kā ma'a te mahakí. Ne'e kala U ha'ú ke ui 'ia te anga-tonú, kā ko te angahalá ke fakatomala.” ");
INSERT INTO num_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Pea ne'e fa'a 'aukai te kau ako 'a Sioné mo te kau ako 'a te kau Fālesí; pea ne'e ōmai he 'ihi 'o iange kiā Sīsū, “Ko te ā 'oku 'aukai ai 'ia te kau ako ia 'a Sioné, mo te kau ako 'a te kau Fālesí, kā ko Ta'aú kau ako 'oku kala notou 'aukai nātou?” ");
INSERT INTO num_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Pea iange 'e Sīsū kiā nātou, “He 'e lava ke 'aukai 'ia te kau fakaafe 'o te tangata ta'ané, 'i te kei 'iā nātou 'ia te tangata ta'ané? Lolotonga 'oku 'iā nātou te tangata ta'ané, 'oku kala notou fa'a 'aukai. ");
INSERT INTO num_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kae tokaange he taimi 'e hiki ai 'ia te tangata ta'ané meiā nātou; pea 'e notou toki 'aukai 'i te 'aho ko iá. ");
INSERT INTO num_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","'Oku kala 'oposi he taha te kofu matu'á 'aki he konga tupenu fo'ou; he kā pehē, ko te konga fo'ou 'oku 'oposi 'akí, 'e mingi ia, pea hoko ai he fu'u mahae 'oku lahi ange. ");
INSERT INTO num_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Pea 'oku kailoa 'utu he taha te uaine fo'oú ki te 'ū hina leta matu'a; he kā pehē, 'e hae 'ia te 'ū hina matu'á 'e te uaine fo'oú, pea 'e maumau 'ia te uainé mo te hiná fakatou'osi. Kā 'oku notou 'utu 'ia te uaine fo'oú ki te 'ū hina fo'ou.” ");
INSERT INTO num_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pea ko te Sāpate 'e taha ne'e fononga atu 'ia Sīsū 'o ala loto ngoue. Pea hanga 'e Tana kau akó 'o toli 'ia te 'ū fe'i uite. ");
INSERT INTO num_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pea lea ange 'ia te kau Fālesí kiā Ia, “Vakai angé; ko te ā 'oku notou fai ai 'i te 'aho Sāpaté 'ia te me'a 'oku kala ngafuá?” ");
INSERT INTO num_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Pea pehē ange Ia kiā nātou, “Kua he'iki ai koā kotou lau ki te me'a ne'e fai 'e Tēvita 'i tana tu'utāmakí, mo hālofia, fakataha mo nātou ne'e 'iā iá? ");
INSERT INTO num_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","He ne'e hū ia ki te Fale 'o te 'Atuá, 'i te kuonga ne'e taula'aliki lahi ai 'ia 'Apaiatá, pea kai 'e ia te mā fonó, 'ā ē 'oku kailoa ngafua tono kaí, kā ki te kau taula'alikí pē, mo ina 'avange foki kiā nātou ne'e 'iā iá?” ");
INSERT INTO num_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Pea toe pehē Ia kiā nātou, “Ne'e fokotu'u 'ia te Sāpaté ma'a te tangatá, kae kailoa ko te tangatá ma'a te Sāpaté; ");
INSERT INTO num_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ko ia ko te Fanautama te Tangatá ko te 'Aliki Ia 'o te Sāpaté foki.” ");
INSERT INTO num_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Pea toe hū Ia ki te falelotú; pea ne'e 'i ai he tangata kua mate tono nimá. ");
INSERT INTO num_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pea notou lamasi 'Ona, pē 'e Ina fai he faito'o 'i te 'aho Sāpaté, kote'uhí kae notou toki faka'ilo ai 'Ona. ");
INSERT INTO num_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pea pehē ange Ia ki te tangata kua nima maté, “Tu'u mai ki loto.” ");
INSERT INTO num_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pea iange 'e Ia kiā nātou, “Ko fea 'oku ngafua 'i te Sāpaté? Ke fai he lelei pē ke fai he kovi? Ke fakahaofi ma'uli, pē ke tāmate'i?” Pea notou fakalongo pē. ");
INSERT INTO num_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Pea sio takai Ia kiā nātou mo Tana tuputāmakí, he ne'e mamahi Ia 'i te fefeka pehē fau te notou lotó; pea toki pehē Ia ki te tangatá, “Mafao atu tou nimá.” Pea mafao atu ia; pea ne'e toe ma'uli mai tono nimá. ");
INSERT INTO num_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pea ō leva ki tu'a 'ia te kau Fālesí, fakataha mo te fa'ahi 'a Hēlotá, 'o notou alea'i, pe fefe'aki he notou tāmate'i 'Ona. ");
INSERT INTO num_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Pea ne'e ō 'ia Sīsū mo Tana kau akó ki tai, pea mulimuli mai he fu'u kakai tokolahi 'aupito mei Kāleli mo Siutea, ");
INSERT INTO num_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","mo Selusalema mo 'Aitumia, mo Tu'a-Sioatani, mo nātou ne'e ofi mai ki Taia mo Saitoní, 'i te notou fanongo ki te 'ū me'a lahi kua fai 'e Iá. ");
INSERT INTO num_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Pea lea Ia ki Tana kau akó, ke teuteu mai he ki'i vaka kiā Ia, kote'uhí ko te fu'u kakaí, na'a notou faka'efihia'i 'Ona. ");
INSERT INTO num_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","He ne'e tokolahi te kakai ne'e fakama'uli 'e Iá; ko ia ko nātou kotoa pē ne'e notou mahaki'iná, ne'e notou feteketeke'i ke notou ala kiā Ia. ");
INSERT INTO num_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Pea ko te 'ū fa'ahikehé, kā notou sio kiā Ia, 'e notou tōmape'e 'i Tono 'aó, 'o kaila, “Ko te 'Alo Koe 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pea ne Ina fekau mālohi 'ia nātou, ke 'aua na'a notou fakahaa'i 'Ona. ");
INSERT INTO num_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pea 'alu ake 'ia Sīsū ki te ma'ungá, 'o ui ange 'ia nātou ne'e loto Ia ki aí, pea notou ōmai kiā Ia. ");
INSERT INTO num_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Pea ne Ina fakanofo he toko hongofulu mā ua, ke notou tākaua mo Ia, pea ke Ina fekau atu 'ia nātou ke malanga, ");
INSERT INTO num_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","pea ke notou ma'u 'ia te mafai ke fakama'uli mahaki, mo kapusi tēvolo. ");
INSERT INTO num_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ko Saimone, ne'e fakahingoa 'e Ia ko Pitá; ");
INSERT INTO num_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","mo Sēmisi ko te foha 'o Sēpeti, mo Sione ko te tehina 'o Sēmisí; ne Ina 'ai kiā nāua te hingoa ko te ongo Poanesi, ko tono 'uhingá, ko te ongo foha 'o te mana; ");
INSERT INTO num_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ko 'Anitelū foki mo Filipe, mo Pātolomiu, mo Mātiu, mo Tōmasi, mo Sēmisi ko te foha 'o 'Alefiusi, mo Tatiusi, mo Saimone 'o te kautaha Mamahi'i fanua, ");
INSERT INTO num_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","mo Siutasi 'Isikaliote, 'ā ē ne ina lavaki'i 'ia Sīsuú. ");
INSERT INTO num_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pea ne'e notou hū he fale. Pea toe fakataha mai 'ia te kakaí, ko ia ne'e kailoa notou lava 'o mama he konga mā. ");
INSERT INTO num_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Pea 'i te fanongo ki ai Tono kāingá, ne'e notou ō atu ke puke Ia; he ne'e notou pehē, “'Oku sesele Ia.” ");
INSERT INTO num_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pea ne'e pehē 'e te kau sikalaipe ne'e ō ifo mei Selusalemá, “'Oku 'iā Ia 'ia Pelisipupe;” mo 'eni, “'Oku fai 'e Ia Tana kapusi tēvoló 'iā Pelisipupe ko te 'aliki 'o te kau tēvoló.” ");
INSERT INTO num_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Pea ui ange nātou 'e Sīsū, 'o lea ange 'i te 'ū talanoa fakatātā, 'o pehē, “He 'e lava fefe'aki ke kapusi 'e Sētane 'ia Sētane? ");
INSERT INTO num_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kā 'i ai he pule'anga 'oku māvahevahe mo fetu'usi, 'e kailoa tu'u ma'u 'ia te pule'anga ko iá. ");
INSERT INTO num_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Pea kā 'i ai he 'api 'e māvahevahe mo fetu'usi, 'e kailoa lava ke tu'u ma'u 'ia te 'api ko iá. ");
INSERT INTO num_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Pea kāpau 'e tu'u 'e Sētane kiā ia pē, 'o māvahevahe, 'e kailoa lava ia ke tu'u, kā kua pau ke ngata ia. ");
INSERT INTO num_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Pea tala'i'eaí 'e lava he taha ke hū ki te fale 'o he to'a, 'o kaiha'asi tana koloá; kae'aua mu'a ke ina ha'iha'i 'ia te to'á, pea toki lava ke kaiha'asi tana koloá. ");
INSERT INTO num_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","'Okou tala mo'oni atu kiā kōtou, 'e fakamolemole ki te hako 'o te tangatá 'ia te angahala kotoa pē, pea mo te 'ū lau kovi 'e notou fai ki te 'Atuá. ");
INSERT INTO num_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kā ko ia ko 'ē 'e lau kovi ki te Laumālie Mā'oni'oní 'e kailoa fakamolemole'i 'ona 'o lauikuonga, kā 'e ma'ua ia 'i te mala'ia ta'engata.” ");
INSERT INTO num_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ko te lea pehē 'e Sīsuú, kote'uhí ko te pehē 'e te kakaí, “'Oku 'iā Ia he fa'ahikehe.” ");
INSERT INTO num_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Pea ne'e ōmai Tana fa'eé mo Tono 'ū tokouá, 'o tutu'u 'i tu'a, 'o notou fekau atu kiā Ia. ");
INSERT INTO num_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Pea pehē ange kiā Sīsū 'e te kakai ne'e kāpui 'Oná, “'Ē, ko Tau fa'eé mo Tou 'ū tokouá 'oku notou tutu'u mei tu'a, pea 'oku notou fia ma'u 'ia Koe.” ");
INSERT INTO num_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kae tali ange Ia kiā nātou, 'o pehē, “Ko ai ia Taku fa'eé mo Toku 'ū tokouá?” ");
INSERT INTO num_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Pea sio takai Ia kiā nātou ne'e nofo 'o kāpui 'Oná, 'o pehē, “Ko 'eni ia Taku fa'eé mo Toku 'ū tokouá! ");
INSERT INTO num_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ko ia ko 'ē 'e fai 'ia te finangalo 'o te 'Atuá, ko ia ia Toku tokouá mo Toku tu'afafiné mo Taku fa'eé.” ");
INSERT INTO num_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Pea toe faiako Ia 'i te matātaí. Pea kua fakataha kiā Ia he fu'u kakai tokolahi 'aupito, ko ia ne'e heka Ia he vaka, 'o nofo mei tai; kā ko te fu'u kakaí ne'e notou tutu'u mei 'uta, 'o hanga ki tai. ");
INSERT INTO num_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Pea ne'e lahi Tana ako'i 'ia nātoú 'i te 'ū talanoa fakatātā, 'o Ina pehē kiā nātou: ");
INSERT INTO num_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Kotou fanongo mai. Ko 'eni, ne'e 'alu atu he tangata tō pulapula'i 'akau ke tūtuu'i. ");
INSERT INTO num_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pea 'i te fai tana tūtuu'í, ne'e ngangana he me'a 'i te va'ealá, pea puna mai te fanga manupuná, 'o notou kai ia 'o 'osi. ");
INSERT INTO num_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pea ngangana mo he me'a ki te feitu'u makamaka, 'a ia ne'e si'isi'i ai 'ia te kelekelé; pea tupu leva ia, kote'uhí ne'e si'isi'i 'ia te kelekelé. ");
INSERT INTO num_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pea 'i te 'alu ake 'ia te la'aá, ne'e velahia; pea ko te me'a 'i te kailoa hana aká, ne'e mate ia. ");
INSERT INTO num_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Pea ngangana mo he me'a ki te loto 'akau talatala, pea tupu ake 'ia te 'ū 'akau talatalá ia 'o kāsia'i 'ona, pea ne'e kailoa a'u ia ki te fuá. ");
INSERT INTO num_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pea ngangana he 'ihi ki te kelekele kua lelei; pea tupu ake ia 'o fua lahi, 'o fua tolungofulu 'ihi, pea fua onongofulu 'ihi, pea fua teau 'ihi.” ");
INSERT INTO num_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Pea pehē ange Ia, “Ko ia 'oku ma'u talinga ke fanongo 'akí, ke ongo'i ia.” ");
INSERT INTO num_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pea 'i te notou fakaenātoú leva, pea ko nātou ne'e 'iā Iá, mo te toko hongofulu mā uá, ne'e notou 'eke kiā Ia kau ki te 'ū talanoa fakatātaá. ");
INSERT INTO num_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Pea pehē ange Ia, “Kua tuku kiā kōtou 'ia te misiteli 'o te Pule'anga 'o te 'Atuá; kā 'oku fai fakatātā kotoa pē kiā nātou 'oku 'i tua'aá, ");
INSERT INTO num_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kote'uhí ‘ke notou sio mo'oni, kae kailoa 'ilo'i; pea fanongo mo'oni, kae kailoa ongo'i; na'a faifaí pea notou tafoki, pea fakamolemole'i ai 'ia nātou.’ ” ");
INSERT INTO num_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ne'e pehē foki 'e Ia kiā nātou, “'Oku kailoa koā kotou 'ilo'i te talanoa fakatātā nei? Pea 'e kotou 'ilo'i fefe'aki ai 'ia te 'ū fakatātā kehé? ");
INSERT INTO num_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ko te tangata tūtuu'í 'oku tūtuu'i ia 'ia te Folafolá. ");
INSERT INTO num_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Pea ko 'eni ia 'ia nātou 'i te va'ealá, ko nātou ia ne'e tūtuu'i ki ai 'ia te Folafolá, kā 'i te notou fanongo ki aí, ne'e ha'u leva 'ia Sētane, 'o 'ave te Folafola kua tō 'iā nātoú. ");
INSERT INTO num_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Pehē foki, ko nātou ne'e tūtuu'i 'i te feitu'u makamaká, ko nātou ia 'oku fanongo ki te Folafolá, pea puke fiafia leva ki ai; ");
INSERT INTO num_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","kā 'oku kailoa he aka 'iā nātou, kae fakataimi pē. Faifai pea hoko he faingata'a pē he fakatanga, kote'uhí ko te Folafolá, pea notou tūkia leva. ");
INSERT INTO num_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Pea 'oku 'i ai mo he 'ihi 'oku tūtuu'i 'i te 'ulu 'akau talatala; ko nātou ia 'oku fanongo ki te Folafolá, ");
INSERT INTO num_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kā ko te fa'a lotoma'ua ki māmaní, mo te 'ofa ki te koloá, mo te holi ki te 'ū me'a kehekehé, 'oku notou uulu mai, 'o kāsia 'ia te Folafolá, pea ta'efua ai. ");
INSERT INTO num_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pea 'oku 'i ai mo te pulapula'i 'akau ne'e tūtuu'i ki te kelekele kua lelei; ko te fa'ahinga ia 'oku fanongo ki te Folafolá, pea tali lelei ia, pea notou fua, 'o taki tolungofulu 'ihi, pea taki onongofulu 'ihi, pea taki teau 'ihi.” ");
INSERT INTO num_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Pea toe pehē Ia kiā nātou, “He 'oku 'aumai koā he maama ke fa'o ki te loto puha, pē ki te lalo moe'anga? Kae kailoa fokotu'u 'ona ki te tu'unga maamá? ");
INSERT INTO num_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","He 'oku kala he me'a 'oku lilo, 'e ta'efakahaa'i, mo he me'a 'oku fufuu'i, 'e ta'e'iloa. ");
INSERT INTO num_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kā 'i ai he taha 'oku ma'u talinga ke fanongo 'akí, ke ongo'i ia.” ");
INSERT INTO num_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ne'e pehē foki Ia kiā nātou, “Tokanga ki te me'a 'oku kotou fanongo ki aí; he ko te me'a-fua 'oku kotou fua 'akí, ko ia pē 'e fua 'aki kiā kōtoú, pea 'e fakalahi atu. ");
INSERT INTO num_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","He ko ia 'oku ma'u he me'á, 'e 'avange ki ai mo he me'a; kā ko ia 'oku kailoa ma'ú, na'a mo te me'a 'oku ma'u 'e iá, 'e to'o meiā ia.” ");
INSERT INTO num_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Pea toe pehē 'e Sīsū, “Ko te anga 'eni 'o te Pule'anga 'o te 'Atuá: 'oku hangē ko te laku pulapula'i 'akau he tangata ki te kelekelé. ");
INSERT INTO num_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pea moe ia mo 'ala, 'i te pō mo te 'aho, pea tupu pē 'ia te pulapula'i 'akaú 'o 'alu ake, kae kailoa hana 'ilo'i pe 'oku fakafefe'aki. ");
INSERT INTO num_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","'Oku fakatupu ia 'e te kelekelé 'iā ia pē, 'o fu'aki tupu 'ia te muká, hoko ai mo te motó, pea toki hoko ai mo te fe'i koané kua matu'a. ");
INSERT INTO num_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pea 'i tana matu'a te fuá, pea toki 'ai leva 'ia te hele tu'usí, he kua hoko 'ia te utu-ta'ú.” ");
INSERT INTO num_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Pea fai atu Ia 'o pehē, “'E Au fakatatau ki te ā 'ia te Pule'anga 'o te 'Atuá? 'Io, ko te ā nai he talanoa fakatātā 'e Au fakatatau 'aki 'ona ki aí? ");
INSERT INTO num_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","'Oku hangē ia ko he fe'i pulapula'i mūsita; 'a ia kā tūtuu'i ki te kelekelé, ko te si'i taha ia 'i te pulapula'i 'akau kotoa pē kua tō. ");
INSERT INTO num_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kae hili ange to'onó tō, 'oku tupu ake ia 'o hoko ko te lahi 'i te fa'ahinga 'akau lilikí, pea 'oku va'ava'a lalahi ia; ko ia 'oku lava ai 'ia te fanga manupuna 'o te 'ataá ke notou nonofo 'i tono malumalú.” ");
INSERT INTO num_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Pea lahi mo te 'ū talanoa fakatātā pehē ne'e lea 'aki 'e Sīsū 'i te Folafolá kiā nātou, 'o fakatatau ki te notou mafai ke fanongo ki aí. ");
INSERT INTO num_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Pea ne'e ngāue 'aki ma'u pē 'e Sīsū he 'ū talanoa fakatātā 'i Tana malangá; pea 'i te notou fakaenātou peé, ne'e toki faka'uhinga kotoa pē 'e Ia ki Tana kau ako 'A'aná. ");
INSERT INTO num_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pea 'i tana afiafi ifo 'o te 'aho ko iá, ne Ina pehē kiā nātou, “Tou ō ki te kauvai 'e tahá.” ");
INSERT INTO num_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Pea kua notou tukuange 'ia te kakaí, pea notou 'ave ai pē 'Ona 'i te vaka ne'e 'i ai Iá, pea ne'e 'i ai mo te 'ū vaka kehe ne'e notou folau. ");
INSERT INTO num_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pea tō mai he fu'u matangi lahi, pea kamata ake 'ia te 'ū peaú ki te loto vaká, 'o kamata ngoto ia. ");
INSERT INTO num_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ka ne'e 'i te taumulí 'ia Sīsū, 'o moe Ia 'i te me'a fakamalū; pea notou fafangu'i 'Ona, 'o pehē kiā Ia, “Tangata'aliki, 'oku kala koā Ke tokanga'i te tou tu'utāmakí?” ");
INSERT INTO num_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Pea tu'u ake Ia 'o lolomi 'ia te matangí, 'o pehē ki te taí, “Longoā, 'aua ke toe mama'i ngaue!” Pea ne'e malū 'ia te matangí, pea ne'e hoko he fu'u tofu lahi. ");
INSERT INTO num_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Pea pehē ange Ia kiā nātou, “Ko te ā 'oku pehē fau ai te kotou lotosi'í? Ko te ā 'oku kala 'i ai ai he kotou tuí?” ");
INSERT INTO num_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pea ne'e notou manahē lahi 'aupito, mo notou fealealea'aki, 'o pehē, “Ko Ai tū 'eni? He na'a mo te matangí mo te taí 'oku nā fakaongo kiā Ia!” ");
INSERT INTO num_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pea notou a'u ki te kauvai 'e taha 'o te taí, ki te fanua 'o te kakai Kēlasá. ");
INSERT INTO num_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pea 'i Tana hifo mei te vaká, ne'e fakafetaulaki mai kiā Ia mei te 'ū fa'itoká he tangata kua 'iā ia he fa'ahikehe. ");
INSERT INTO num_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Pea ne'e nofo pē ia 'i te 'ū fa'itoká; pea ne'e kala lava he taha tono ha'i, neongo ko te fai 'aki he seini. ");
INSERT INTO num_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","He kua tu'a lahi te kii'i tono va'é, mo tono ha'i seini, pea ne ina motuhi 'ia te 'ū seiní mo laiki te 'ū ukameá; pea ne'e kailoa mafai he taha ke lava'i 'ona. ");
INSERT INTO num_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pea ne'e 'i te 'ū fa'itoká ia mo te 'ū ma'ungá ma'u ai pē, 'i te pō mo te 'aho, 'o kaikaila, mo tafatafa'i 'aki 'ona 'ia te 'ū fe'i maka. ");
INSERT INTO num_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pea 'i tana mamata mei te mama'ó kiā Sīsuú, ne'e lele atu ia, 'o tū'ulutui kiā Ia, ");
INSERT INTO num_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","mo tangi le'o lahi, 'o pehē, “Ko Tou ā 'ia au, 'e Sīsū, ko te 'Alo 'o te 'Atua Taupotú? 'Okou hū tōtōaki kiā Koe 'i te 'Atuá, ke 'aua mu'a na'a Ke fakamamahi'i 'oku!” ");
INSERT INTO num_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","He kua kamata pehē 'e Sīsū ki ai, “'Ia te fa'ahikehe nā, mahu'i mai mei te tangatá!” ");
INSERT INTO num_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Pea fehu'i kiā ia 'e Sīsū, “Ko ai tou hingoá?” Pea tali 'e ia, “Ko Kongakau, he 'oku motou tokolahi.” ");
INSERT INTO num_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Pea kole fakamātoato ia kiā Sīsū, ke 'aua ne Ina fekau ke notou 'alu mei te fanuá. ");
INSERT INTO num_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Pea ne'e 'i ai he fu'u fanga puaka 'i te feitu'u ko iá ne'e notou huhua 'i te 'āfaki 'o te ma'ungá. ");
INSERT INTO num_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Pea notou kole kiā Ia, 'o pehē, “Fekau mu'a 'ia mātou ke motou uulu ki te fanga puaká.” ");
INSERT INTO num_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Pea tukuange leva nātou 'e Sīsū, pea ō atu te kau fa'ahikehé, 'o uulu ki te fanga puaká; pea 'oho 'ia te fanga monumanú 'i te taifoifo ki taí, (ne'e notou fe'unga nai mo te toko ua afe) 'o notou malemo 'i te taí. ");
INSERT INTO num_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pea feholaki 'ia te kakai ne'e tauhi 'ia te fanga puaká, 'o notou ō 'o talanoa'i 'ia te me'á ki te koló mo te tuku'utá. Pea ne'e ō atu te kakaí ke vakai 'ia te me'a kua hokó. ");
INSERT INTO num_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pea notou a'u mai kiā Sīsū, 'o mamata ki te tangata ne 'ulusino ai 'ia te 'ū fa'ahikehé, kua ta'utu, pea kua kofu mo 'atamai lelei, pea ne'e notou 'ilifia. ");
INSERT INTO num_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Pea ne'e tala kiā natou 'e te kakai ne'e mamata ki aí, 'ia te me'a ne'e hoko ki te tangata ne 'ulusino ai 'ia te 'ū fa'ahikehé, pea mo te me'a ne'e kau ki te fanga puaká. ");
INSERT INTO num_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Pea notou kole leva kiā Sīsū ke 'alu mei te notou feitu'ú. ");
INSERT INTO num_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Pea 'i Tana heka ki te vaká, ne'e kole kiā Ia 'e te tangata ne 'ulusino ai 'ia te 'ū fa'ahikehé ke nā ō mo Ia. ");
INSERT INTO num_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ka ne'e kala loto 'e Sīsū ia ki ai, kae pehē ange Ia, “'Alu koe ia ki tou 'apí mo tou kakaí, pea ongoongoa kiā nātou 'ia te fu'u me'a kua fai 'e te 'Alikí ma'au, mo Tana 'ofa'i 'oú.” ");
INSERT INTO num_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Pea 'alu te tangatá, 'o kamata ongoongoa 'i Tikapolusi 'ia te fu'u me'a kotoa pē kua fai 'e Sīsū ma'aná. Pea ne'e ofo ai 'ia te kakaí fuli pē. ");
INSERT INTO num_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Pea kua foki 'ia Sīsū 'i te vaká ki te kauvai 'e tahá, pea fakataha kiā Ia he fu'u kakai tokolahi, pea ne'e 'i te matātaí Ia. ");
INSERT INTO num_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Pea ha'u he toko taha 'i te kau pule 'o te falelotú, ko tono hingoá ko Sailosi. Pea 'i tana vakai kiā Sīsuú ne'e hinga atu ia ki Tono va'é, ");
INSERT INTO num_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","'o kole fakamātoato kiā Ia, 'o pehē, “Ko si'aku ki'i 'ofafiné 'oku tau'aki; me'a mai mu'a 'o 'ai Tou nimá kiā ia, kote'uhí ke hao ai 'o ma'uli!” ");
INSERT INTO num_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Pea 'alu 'ia Sīsū mo te tangatá; pea mulimuli ki ai he fu'u kakai tokolahi, 'o notou feta'ota'omi mai kiā Ia. ");
INSERT INTO num_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pea ne'e 'i ai he fafine 'e taha, ne'e 'au toto 'i te ta'u 'e hongofulu mā ua, ");
INSERT INTO num_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","pea kua lahi te faito'o fakamamahi kua fai kiā ia 'e te kau faito'o tokolahi, pea kua 'osi atu si'ana koloá kotoa pē, kae kailoa 'aupito ha'aná 'aonga, ka ne'e faka'a'au ia ke toe kovi ange. ");
INSERT INTO num_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Pea kua fanongo ia ki te talanoa 'o Sīsuú, pea ha'u ia mo te kakaí mei Tono tu'á, 'o ala ki Tono kofú. ");
INSERT INTO num_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","He ne'e pehē ia, “Kāpau 'e au ala kiā Ia, neongo ko Tono kofú pē, 'e fakama'uli 'oku.” ");
INSERT INTO num_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pea matu'u leva tana 'aú, pea ongo'i ia 'i tono sinó kua ma'uli mei tono mamahi'angá. ");
INSERT INTO num_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ka ne'e 'ilo'i leva 'e Sīsū 'i Tono finangaló, kua 'alu atu meiā Ia he mālohi, pea tafoki Ia ki te kakaí 'o 'eke, “Ko ai ne'e ala mai ki Toku kofú?” ");
INSERT INTO num_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Pea iange Tana kau akó kiā Ia, “Ko Tau lau koā, ‘Ko ai kua ala mai kiā Au?’ Kae vakai angé, ko te kakaí ē 'oku notou feta'omi mai kiā Koe!” ");
INSERT INTO num_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ka ne'e sio holo pē 'ia Sīsū ke 'ilo'i pe ko ai ne'e fai 'ia te me'a ko iá. ");
INSERT INTO num_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Pea ko te fafiné, 'i tana vakai ki te me'a kua hoko kiā iá, pea ha'u ia 'oku 'ilifia mo tetetete, 'o hinga atu 'i Tono 'aó 'o vete kiā ia 'ia te me'a kotoa pē kua hoko kiā iá. ");
INSERT INTO num_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Pea toki iange 'e Sīsū kiā ia, “Nga'ata, kua fakama'uli 'ou 'e tau tuí; 'alu fiamālie pe ā koe, pea ke ma'uli mei tou mamahi'angá.” ");
INSERT INTO num_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kae lolotonga Tana kei leá, mo te ōmai he 'ihi mei te fale 'o te pule 'o te falelotú, 'o notou pehē, “Kua pekia tou 'ofafiné, 'aua na'a ke toe fakahoha'asi te Tangata'alikí.” ");
INSERT INTO num_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pea 'i te fanongo 'e Sīsū ki te me'a ne'e laú, ne'e pehē ange Ia ki te pule 'o te falelotú, “'Aua na'a ke lotosi'i; tui pē koe.” ");
INSERT INTO num_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Pea ne'e kala tuku 'e Ia he taha ke mulimuli mai kiā Ia, ko Pita pē, mo Sēmisi, mo Sione ko te tokoua 'o Sēmisí. ");
INSERT INTO num_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pea notou a'u ki te 'api 'o te matāpulé, pea 'ilo'i ai 'e Sīsū he fu'u vālau, mo nātou ne'e notou tēngihia mo tangi le'o lahi. ");
INSERT INTO num_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pea hū atu Ia 'o lea kiā nātou, “Ko te ā 'oku kotou vālau ai mo tangí? 'Oku kailoa mate te ta'ahiné ia, kā 'oku moe pē!” ");
INSERT INTO num_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ka ne'e notou kakata mo manuki kiā Ia, pea ne Ina fekau ke notou ō kotoa pē ki tu'a, pea 'ave 'e Ia 'ia te tamai 'a te ta'ahiné mo tana fa'eé, mo nātou ne'e ōmai mo Iá, 'o notou hū ki te loki ne'e takoto ai 'ia te ta'ahiné. ");
INSERT INTO num_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pea puke 'e Ia tono nimá mo lea ange, “Tālita, kumi!”, 'a ia ko tono hikí, “Ta'ahine, 'Okou lea atu kiā koe, tu'u ake!” ");
INSERT INTO num_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Pea tu'u ake leva te ta'ahiné, 'o 'eva'eva; he ko tono ta'u hongofulu mā ua 'eni. Pea ne'e fu'u 'ohovale lahi 'ia te kakaí. ");
INSERT INTO num_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pea lea lahi Ia kiā nātou ke 'aua na'a 'ilo'i he taha 'ia te me'a ko iá; mo Ina fekau ke 'avange hana me'a ke kai. ");
INSERT INTO num_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pea ne'e 'alu 'ia Sīsū mei ai, 'o ha'u ki Tono kolo 'O'oná; pea mulimuli kiā Ia Tana kau akó. ");
INSERT INTO num_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pea 'i te 'aho Sāpaté, ne'e kamata faiako Ia 'i te falelotú; pea ne'e ofo te tokolahi 'i te notou fanongo kiā Iá, 'o pehē, “Ne'e ma'u mei fea 'e te Siana nā 'ia te 'ū me'a nei? Pea ko te ā fua 'ia te poto ko 'eni kua 'avange ki aí? Pea mei fea Tana fai he 'ū fu'u ngāue mamafa pehē? ");
INSERT INTO num_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","'Oku kailoa koā ko te tufungá 'eni, ko te tama 'a Melé, mo te tokoua 'o Sēmisi mo Siosē mo Siutasi mo Saimoné? 'Oku kala koā nofo mo tātou heni tono 'ū tu'afāfiné?” Pea ne'e notou tūkia 'iā Ia. ");
INSERT INTO num_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pea toki lea 'e Sīsū kiā nātou, 'o pehē, “'Oku kailoa masiva faka'apa'apa he palōfita, kā 'i tono fanua totonú, mo tono kāinga 'o'oná, mo tono fāmilí.” ");
INSERT INTO num_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Pea ne'e kailoa lava Ia ke fai ai he ngāue mamafa 'e taha, ngata pē 'i Tana hilifaki Tono nimá ki te 'ihi tokosi'i ne'e mahaki'iná, 'o fakama'uli. ");
INSERT INTO num_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Pea ne'e fakatumutumu Ia 'i te pehē fau te notou ta'etuí. Pea ne'e 'alu takai Ia 'i te 'ū koló, 'o faiako. ");
INSERT INTO num_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Pea ui ange 'e Sīsū 'ia te kau hongofulu mā uá, 'o fekau'i atu 'ia nātou, 'o tautau toko ua; mo tuku kiā nātou ke fa'italiha ki te kau fa'ahikehé. ");
INSERT INTO num_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ne'e tu'utu'uni foki 'e Ia kiā natou ke 'aua na'a notou to'o he me'a ki te alá, ngata pē he tokotoko; pea 'aua na'a 'ave he mā, pē he kato 'oho, pe fakapona he pa'anga 'i te notou no'ó, ");
INSERT INTO num_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","pea ke notou tui senitolo pē, pea 'aua na'a 'ai he sote 'e ua. ");
INSERT INTO num_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Pea pehē foki 'e Ia kiā nātou, “Kā kotou hū he fale, nofo pē 'i ai kae'aua ke kotou toki hiki mei ai. ");
INSERT INTO num_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pea ko nātou 'e kala tali 'ia kōtou, pe fanongo kiā kōtoú, pea kā kotou mavahe mei ai, kotou tūtuu'i te efú mei te kotou 'aofiva'é, ko te faka'ilonga kiā nātou.” ");
INSERT INTO num_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Pea ne'e notou 'alu atu, 'o notou malanga ke fakatomala 'ia te kakaí. ");
INSERT INTO num_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pea ne'e notou kapusi 'ia te fanga tēvolo tokolahi, pea notou pani 'aki he lolo 'ia te tokolahi ne'e mahaki'iná, 'o fakama'uli. ");
INSERT INTO num_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Pea ne'e fanongo ki ai te tu'i ko Hēlotá, (he kua ongoongoa Tono hingoá,) pea pehē 'e ia, “Ko SionePapitaiso pē 'eni ia kua toetu'u mei te maté, pea ko te 'uhinga ia 'o te fu'u mafai 'oku ngāue 'iā Iá.” ");
INSERT INTO num_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kae pehē he 'ihi, “Ko 'Ilaisiā pe 'eni;” pea ko te 'ihi, “Ko he palōfita ia, hangē he toko taha 'o te kau palōfita mu'á.” ");
INSERT INTO num_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kā 'i te fanongo ki ai 'ia Hēlotá, ne'e pehē ia, “Ko Sione pē 'eni, 'ā ē ne au tu'usi tono 'ulú, ko ia ia kua toetu'u ake mei te maté!” ");
INSERT INTO num_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","He ne'e fekau atu 'e Hēlota ke puke 'ia Sione; pea ne'e ha'i ia 'o sī ki te pilīsoné, kote'uhí ko Helotiasi ko te mali 'o tono tokoua ko Filipé; he kua nā mali. ");
INSERT INTO num_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","He ne'e fa'a lau 'e Sione kiā Hēlota, “'Oku kailoa ngafua kiā koe ke ma'u 'ia te mali 'o tou tokouá!” ");
INSERT INTO num_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Pea ne'e loto kovi 'ia Helotiasi kiā Sione, 'o loto ia ke tāmate'i 'ona; ka ne'e kailoa ina lava, ");
INSERT INTO num_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","he ne'e manahē 'ia Hēlota kiā Sione, ko tana 'ilo'i ko te tangata faitotonu ia mo mā'oni'oni, pea ne'e malu'i 'e ia 'ona. Pea ne'e fa'a fanongo fiafia 'e Hēlota kiā ia, neongo ne fa'a puputu'u ai tono lotó. ");
INSERT INTO num_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pea faifaí ne'e 'i ai he 'aho faingamālie, ko te fai kātoanga 'e Hēlota 'i tono 'aho 'alo'í, mo tono hau'alikí, mo te kau 'alikitaú mo te kau tu'ukimu'a 'o Kālelí. ");
INSERT INTO num_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Pea hū atu te ta'ahine 'a Helotiasí, 'o me'e; pea ne'e mālie'ina ai 'ia Hēlota mo nātou ne'e taumafa mo iá. Pea pehē 'e te tu'í ki te ta'ahiné, “Kole mai kiā au, he me'a pē 'e ke loto ki aí, pea 'e au 'avatu.” ");
INSERT INTO num_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pea ne'e fuakava ia ki te ta'ahiné, “Neongo pe ko te ā 'e ke kole maí, 'e au 'avatu; 'io, 'o a'u ki te vaeua 'o toku pule'angá!” ");
INSERT INTO num_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pea ne'e hū atu ia ki tu'a 'o 'eke ange ki tana fa'eé, “Ko te ā he me'a 'e au kolé?” Pea tali ange ia, “Ko te 'ulu 'o Sione Papitaisó!” ");
INSERT INTO num_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Pea toe hū ia, 'o 'alu fakato'oto'o ki te tu'í, 'o kole ange, “Ko toku lotó ke ke 'aumai leva 'eni kiā au he peleti 'ia te 'ulu 'o Sione Papitaisó.” ");
INSERT INTO num_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Pea mamahi lahi 'ia te tu'í; kā kote'uhí ko tana fuakavá, pea kote'uhí ko nātou ne'e taumafa mo iá, ne'e kailoa lava ia ke fakafisi. ");
INSERT INTO num_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Pea ne'e kouna leva 'e te tu'í he taha 'o te kau le'ó, ke 'aumai te 'ulu 'o Sioné. Pea 'alu atu ia 'o tu'usi tono 'ulú 'i te pilīsoné, ");
INSERT INTO num_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","'o 'aumai 'ia te 'ulú 'i te peleti, 'o 'avange ki te ta'ahiné; pea 'avange 'e te ta'ahiné ki tana fa'eé. ");
INSERT INTO num_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pea 'i te fanongo ki ai tana kau akó, ne'e notou ōmai leva 'o 'ave tono 'anga'angá, 'o telio he fanualoto. ");
INSERT INTO num_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Pea fakataha te kau 'apōsetoló kiā Sīsū, 'o notou fakamatala kotoa pē kiā Ia 'ia te 'ū me'a kua notou faí mo ia ne notou ako 'akí. ");
INSERT INTO num_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Pea pehē ange Ia kiā nātou, “Kotou ōmai 'iā kōtou pē, ki te feitu'u 'oku ngaongaó, 'o ki'i mālōlō.” He ne'e 'i ai ma'u pē he kakai tokolahi ne'e ōmai mo ō; pea na'a mo te kaí ne'e kailoa he taimi ki ai. ");
INSERT INTO num_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Pea ne'e notou folau 'i te vaká 'iā nātou pē, ki te feitu'u ne'e ngaongao. ");
INSERT INTO num_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pea ne'e mamata te kakai tokolahi ki te notou 'alú, 'o notou 'ilo'i tono 'uhingá; pea notou felele'i 'i uta mei te kolo kehekehe ki te feitu'u ko iá, 'o notou mu'amu'a ki ai. ");
INSERT INTO num_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pea 'i Tana hifo ki 'utá, ne Ina 'ilo'i atu he fu'u kakai tokolahi; pea ne'e langa Tono fatú 'i te 'ofa kiā nātou, kote'uhí kua notou tatau tofu pē mo he fanga sipi 'oku kailoa he notou tauhí. Pea ne'e hanga Ia 'o ako kiā nātou he me'a lahi. ");
INSERT INTO num_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pea kua mei 'osi 'ia te 'aho ko iá, pea ha'u Tana kau akó kiā Sīsū, 'o notou pehē ange, “Ko te feitu'u lala 'eni, pea kua mei 'osi 'ia te 'aho nei. ");
INSERT INTO num_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tukuange mu'a te kakaí ke notou ō ki te 'ū ngoue takatakaí, mo te fanga ki'i koló, 'o fakatau he me'akai ma'a nātou.” ");
INSERT INTO num_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ka ne'e tali ange 'e Ia 'o pehē, “'Avange 'e kōtou he notou me'akai.” Pea notou pehē ki Ai, “Ke motou ō koā, 'o fakatau he mā tēnali 'e uangeau, 'o 'avange ke notou kai?” ");
INSERT INTO num_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Pea pehē ange Ia kiā nātou, “'Oku fia te kotou fe'i maá? Ō 'o vakai.” Pea kua notou 'ilo'i, 'o notou iange, “'Oku nima, pea mo te mata'i ika 'e ua.” ");
INSERT INTO num_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Pea fekau 'e Ia ke notou fakanofonofo 'ia te kakai kotoa pē 'i te musie lanu matá, 'o fakakalasi pē. ");
INSERT INTO num_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Pea ne'e notou tā'u'utu ki lalo 'o fakakulupu, 'o taki teau ki hē, mo taki nimangofulu ki hē. ");
INSERT INTO num_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pea to'o 'e Ia 'ia te fe'i mā 'e nimá pea mo te ongo mata'i iká, 'o hanga ake ki te langí 'o tāpuaki'i; mo pakipaki 'ia te 'ū fe'i maá 'o 'avange ki Tana kau akó ke tufa ki te kakaí; pea ne'e vahevahe foki 'e Ia mo te ongo iká kiā nātou fuli pē. ");
INSERT INTO num_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Pea ne'e notou kai kotoa pē, 'o mākokona. ");
INSERT INTO num_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pea notou tānaki te 'ū mapakipaki'i maá, 'o fe'unga mo te kato 'e hongofulu mā ua, mo te 'ū konga iká foki. ");
INSERT INTO num_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Pea ko nātou ne'e kai 'ia te 'ū fe'i maá, ne'e toko nima afe 'ia te kakai tangatá pē. ");
INSERT INTO num_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pea fekau leva 'e Sīsū Tana kau akó ke heka ki te vaká, 'o mu'amu'a ki te kauvai 'e tahá ki Petesaita, kae tukuange 'e Ia 'ia te kakaí. ");
INSERT INTO num_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pea 'i te 'osi ange Tana tukuange 'ia te kakaí, ne'e 'alu Ia mei ai ki te ma'ungá ke lotu. ");
INSERT INTO num_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pea 'i tana afiafi pō'ulí, ne'e 'i te vaeua mālie 'o te taí 'ia te vaká, kae toe toko taha pē Ia 'i 'uta. ");
INSERT INTO num_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Pea ne'e mamata Ia kiā nātou 'oku notou faingata'a'ina 'i te notou 'a'aló, he ne'e angi mei mu'a 'ia te matangí. Pea 'i te vaha'a 'o te tolu mo te ono hengihengí, ne'e ha'u Ia kiā nātou, 'oku ha'ele 'i te fukahi taí; 'o hangē kā fakalaka atu 'iā nātoú. ");
INSERT INTO num_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kā ko nātou, 'i te notou mamata kiā Ia 'oku hā'ele 'i te fukahi taí, ne'e notou mahalo ko he fa'ahikehe, 'o notou fu'u kekē; ");
INSERT INTO num_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","he ne'e notou sio kotoa pē ki Ai, 'o notou puputu'u. Pea lea ange Ia kiā nātou, 'o pehē, “Fiamālie kōtou, he ko Au pē ia. Tuku te kotou manaheé!” ");
INSERT INTO num_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Pea heka Ia ki te vaká kiā nātou; pea malū leva 'ia te matangí. Pea ne'e makehe atu 'aupito te notou fakatumutumú. ");
INSERT INTO num_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","He na'a mo te mana 'o te 'ū fe'i maá, kua kailoa o'o kiā nātou, he kua fefeka te notou lotó. ");
INSERT INTO num_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pea kua notou folau atu, 'o a'u ki te fanua ko Kenesaletí, 'o tau 'i ai. ");
INSERT INTO num_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pea 'i te notou hifo mei te vaká, ne'e 'ilo'i leva 'e te kakaí ko Sīsū Ia. ");
INSERT INTO num_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Pea notou felele'i holo 'i te fanua ko iá fuli pē, 'o notou fata mai 'ia nātou ne'e puké 'i te notou 'ū moe'angá, ki te feitu'u ne'e notou fanongo 'oku 'i ai 'ia Sīsuú. ");
INSERT INTO num_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Pea neongo pe ko te fea he kolo liliki, pe kolo lalahi, pe feitu'u 'i te tuku'utá, ne'e fononga Ia ki ai, 'e notou 'ai ke tākokoto te notou kakai mahaki'iná 'i te mala'é, 'o kole kiā Ia ke tuku mu'a ke notou ala he kapa pē 'o Tono kofú. Pea ko nātou kotoa pē ne'e ala kiā Iá ne'e notou ma'uli. ");
INSERT INTO num_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pea fakataha kiā Ia 'ia te kau Fālesí, mo he 'ihi 'o te kau sikalaipé, kua notou ōmai mei Selusalema, ");
INSERT INTO num_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","pea 'i te notou vakai he 'ihi 'o Tana kau akó 'oku notou kai mā mo te nima 'uli, ko tono 'uhingá, ko te kailoa matu'a fanofanó, ne'e notou hanu. ");
INSERT INTO num_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","He ko te kau Fālesí mo te kau Siú kotoa pē 'e kala notou kai, kae'aua ke notou fu'aki fanofano, ko te notou tauhi ki te lau 'a te mātu'á. ");
INSERT INTO num_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Pea kā notou foki mei te mala'e fakataú, 'oku kailoa notou kai, kae'aua ke notou fu'aki kaukau. Pea lahi mo te 'ū me'a kehekehe kua notou puke 'o tauhi; hangē ko te fufulu 'o te 'ū ipu, mo te 'ū kulo, mo te 'ū ipu kapa, mo te 'ū nofo'a. ");
INSERT INTO num_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Pea fehu'i kiā ia 'e te kau Fālesí mo te kau sikalaipé, “Ko te ā 'oku kailoa fai tatau ai Ta'aú kau ako pea mo te lau 'a te mātu'á, kae notou kai pē mo te nima 'ulí?” ");
INSERT INTO num_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Pea tali ange Ia, “Ne'ine'i palōfisai 'e 'Aisea kiā kōtou mālualohi! 'O hangē ko ia kua tohí, ‘Ko te kakai nei 'oku notou faka'apa'apa kiā Au 'aki te notou ngutú, kā ko te notou lotó 'oku fakamama'o meiā Au. ");
INSERT INTO num_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ko te kulanoa pē te notou lotu maí, he 'oku notou ako 'aki he 'ū tokāteline, 'a ia ko te 'ū tu'utu'uni pē 'a te tangata.’ ");
INSERT INTO num_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kua kotou tuku pē te tu'utu'uni 'a te 'Atuá 'o kotou puke ki te talatupu'a 'a te tangatá.” ");
INSERT INTO num_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Pea toe hoko atu Ia, 'o pehē, “Mālō mu'a te kotou ta'etoka'i 'ia te tu'utu'uni 'a te 'Atuá, kae kotou mamafa ki te lau fakaeono'aho 'a kōtoú! ");
INSERT INTO num_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","He ne'e pehē 'e Mōsese ia, ‘Faka'apa'apa ki tau tamaí mo tau fa'eé;’ mo pehē, ‘Ko ia 'e lea kovi ki tana tamaí, pe ko tana fa'eé, 'e mate tāmate'i.’ ");
INSERT INTO num_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kā 'oku kotou pehē 'e kōtou ia, ‘Kāpau 'e lea ange he tangata ki tana tamaí, pe ko tana fa'eé, 'o pehē, “'Ē, ko te me'a ne au mei 'aonga 'aki kiā koé kua kōpano ia” ’, (ko tono 'uhingá, kua fakatāpui ki te ngāue 'a te 'Alikí,) ");
INSERT INTO num_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","kua kala kotou kei tuku ke fai 'e ia he me'a ma'a tana tamaí, pe ko tana fa'eé! ");
INSERT INTO num_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kua kotou fakata'e'aonga'i 'ia te Folafola 'a te 'Atuá 'aki te kotou lau fakaeono'ahó, 'ā ē kua kotou 'avatu ki te kakaí. Pea kua lahi pē mo te 'ū me'a pehē kua kotou fai 'o tatau mo ia.” ");
INSERT INTO num_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Pea toe ui mai Ia 'ia te kakaí kotoa pē, 'o pehē kiā nātou, “Kotou fanongo mai kotoa pē, kae kotou 'ilo'i. ");
INSERT INTO num_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","'Oku kailoa 'uli he tangata ia mei te me'a 'oku hū kiā ia mei tu'á; kā ko te 'ū me'a 'oku hū mai mei te tangatá, ko 'eni ia 'oku 'uli ai 'ia te tangatá. ");
INSERT INTO num_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ko ia 'oku ma'u talinga ke fanongo 'akí, ke ongo'i ia.” ");
INSERT INTO num_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pea kua notou hū ki fale 'o mavahe mei te kakaí, pea 'eke kiā Ia 'e Tana kau akó 'o kau ki te talanoa fakatātā nei. ");
INSERT INTO num_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Pea lea Ia kiā nātou, 'o pehē, “'Oku ta'e'ilo pehē mo kōtou foki? 'Oku kala koā mahino kiā kōtou, 'oku kailoa fa'a 'uli te tangatá 'i te 'ū me'a 'oku hū kiā ia mei tu'á? ");
INSERT INTO num_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kote'uhí 'oku kailoa 'alu ia ki tono lotó kā ki tono keté, pea 'oku mole atu ki tua'ā.” (Ko Tana lea peheé ne'e fakangafua ai Ia 'ia te 'ū me'akai kotoa pē.) ");
INSERT INTO num_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Pea fai atu Ia, “Ko ia 'oku hū mai mei te tangatá, ko 'eni ia 'oku 'uli ai 'ia te tangatá. ");
INSERT INTO num_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","He 'oku hū ki tu'a mei te loto 'o te tangatá 'ia te 'ū fakakaukau kovi, 'ia te fe'auaki, 'ia te tono 'unoho, 'ia te fakapō, ");
INSERT INTO num_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","'ia te kaiha'a, 'ia te mānumanu, 'ia te anga-fakalialia, 'ia te kākā, 'ia te pau'u, 'ia te meheka, 'ia te lau kovi ki te 'Atuá, 'ia te 'afungi, 'ia te fai fakavalevale. ");
INSERT INTO num_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ko te 'ū kovi 'eni kotoa pē 'oku ha'u mei loto, pea 'uli ai 'ia te tangatá.” ");
INSERT INTO num_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Pea tu'u ake Ia 'o 'alu mei ai ki te tafafanua 'o Taia mo Saitoní, 'o hū ai ki fale, pea loto Ia ke 'aua na'a 'ilo ki ai he taha, kā ne kailoa lava Ia ke puli. ");
INSERT INTO num_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","He ne'e 'ilo ki ai he fafine, 'a ia ne'e ma'ua tana ta'ahiné he fa'ahikehe; pea ha'u ia 'o hinga atu ki Tono va'é. ");
INSERT INTO num_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ko te fafine Kalisi 'eni, mei Sailo-Finisia. Pea kole ange 'e ia kiā Sīsū ke kapusi te tēvoló mei tana ta'ahiné. ");
INSERT INTO num_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ka ne'e iange 'e Sīsū ki ai, “'Aua ke mākona 'ia te fānaú; he 'oku kailoa totonu ke to'o te mā 'a te fānaú 'o sī ki te fanga kulií.” ");
INSERT INTO num_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pea tali 'e te fafiné 'o iange, “'Io, 'Aliki; kā 'oku kai foki 'ia te fanga kulií 'i te lalo tēpilé, mei te 'ū momo'i me'akai 'a te fānaú.” ");
INSERT INTO num_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Pea iange 'e Sīsū ki ai, “Kote'uhí ko tau lea ko iá, ke ke 'alu ā; kua mahu'i te tēvoló mei tau ta'ahiné.” ");
INSERT INTO num_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Pea foki atu te fafiné ki tono 'apí, 'o 'ilo'i tana ki'i ta'ahiné 'oku takoto 'i te moe'angá, pea kua mahu'i atu te tēvoló meiā ia. ");
INSERT INTO num_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pea toe hiki 'ia Sīsū mei te tafafanua 'o Taia mo Saitoní, 'o fou atu 'i Tikapolusi, 'o a'u ki te Tai 'o Kālelí. ");
INSERT INTO num_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Pea notou 'aumai kiā Ia he tangata ne'e tuli mo le'ovale; pea notou kole kiā Ia ke hilifaki Tono nimá ki ai. ");
INSERT INTO num_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Pea taki'i 'ona 'e Sīsū mei te kakaí 'o fakaenāua pē, pea ne'e 'ai Ia Tono tuhú ki te ongo talinga 'o te tangatá, mo 'a'anu Ia 'o 'ai ki tono 'aleló. ");
INSERT INTO num_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pea hanga ake Ia ki te langí, 'o māpuhoi, mo pehē ki te tangatá, “'Efata,” 'a ia ko tono 'uhingá, “Ke ava mai!” ");
INSERT INTO num_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Pea ne'e ava leva tono talingá, pea mavete te no'o 'o tono 'aleló, 'o lea totonu. ");
INSERT INTO num_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Pea na'ina'i Ia kiā nātou ke 'aua na'a notou 'ai ke 'ilo'i he taha. Kā ko te lahi ange Tana na'ina'i kiā nātoú, ne'e 'āsili ange ai te notou ongoongoa Iá. ");
INSERT INTO num_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Pea ne'e notou ofo lahi 'aupito, 'o notou pehē, “Tono kailoa koā tu'utai Ta'aná ngāue kotoa pē! Kua ngaahi 'e Ia 'ia te tulí ke ongo, mo te noá ke lea!” ");
INSERT INTO num_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pea faifaí pea tē 'i ai he fu'u kakai tokolahi, pea ne'e kailoa he notou me'atokoni; pea ui ange 'e Sīsū Tana kau akó, 'o pehē kiā nātou, ");
INSERT INTO num_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“'Oku langa Toku fatú 'i te 'ofa ki te kakai nei; he ko te 'aho 'eni 'e tolu mo te notou nonofo mai, pea 'oku kala he notou me'atokoni. ");
INSERT INTO num_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Pea kāpau 'e Au tukuange nātou ke ō fiakakai ki te notou 'ū 'apí, 'e notou pōngingia 'i te alá; kae'uma'ā ko te notou 'ihi ne'e ōmai mama'o.” ");
INSERT INTO num_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Pea tali ange Tana kau akó, “'E ma'u mei fea heni 'i te lalá he 'ū fe'i mā ke totofu ai 'ia te kakai nei?” ");
INSERT INTO num_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Pea fehu'i ange 'e Ia kiā nātou, “'Oku fia te kotou fe'i maá?” Pea notou tali, “'Oku fitu.” ");
INSERT INTO num_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Pea fekau 'e Ia ke tā'u'utu 'ia te kakaí 'i te funga kelekelé. Pea to'o 'e Ia te fe'i mā 'e fitú, 'o fai he fakafeta'i mo pakipaki; pea 'avange ki Tana kau akó ke tufatufa; pea ne'e notou tufatufa'i ia ki te kakaí. ");
INSERT INTO num_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Pea ne'e 'i ai he notou mata'i ika liliki; pea ne'e tāpuaki'i mo ia, 'o fekau ke tufatufa foki. ");
INSERT INTO num_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Pea ne'e notou kai 'o mākokona; pea notou tānaki 'ia te mapakipaki'i mā ne'e toé, 'o fe'unga mo te kato 'e fitu. ");
INSERT INTO num_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Pea ne'e notou fe'unga nai mo te toko fā afe. Pea toki tukuange 'e Ia 'ia nātou. ");
INSERT INTO num_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Pea heka leva Ia ki te vaká, fakataha mo Tana kau akó, 'o folau ki te 'ū feitu'u 'o Talamanutá. ");
INSERT INTO num_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pea 'alu atu 'ia te kau Fālesí, 'o notou kamata fakafehu'i kiā Ia, ko te notou fia ma'u meiā Ia he faka'ilonga mei langi; ko te notou 'ahi'ahi'i 'Ona. ");
INSERT INTO num_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Pea fu'u māpuhoi Ia 'i Tono laumālié 'o pehē, “Ko te ā 'oku tangi faka'ilonga ai 'e te to'utangata nei? 'Okou tala mo'oni atu kiā kōtou, 'e kailoa 'aupito 'avatu he faka'ilonga ia ki te to'utangata nei!” ");
INSERT INTO num_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Pea 'alu Ia meiā nātou, 'o toe heka vaka 'o 'alu mei ai ki te kauvai 'e tahá. ");
INSERT INTO num_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pea ne'e ngalo 'iā nātou ke 'ave he mā, he ne'e taha pē 'ia te fe'i mā 'i te vaká. ");
INSERT INTO num_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Pea na'ina'i Ia kiā nātou 'o pehē, “Kotou tokanga, 'o vakai, talia 'ia te lēvani 'a te kau Fālesí, pea mo te lēvani 'a Hēlotá.” ");
INSERT INTO num_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pea talanoa leva te kau akó 'iā nātou 'o pehē, “Ko tono 'uhingá 'apē ko te kailoa he tou fe'i maá.” ");
INSERT INTO num_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pea kua 'ilo'i 'eni 'e Sīsū, 'o fehu'i ange kiā nātou, “Ko te ā 'oku kotou talanoa ai 'o pehē kote'uhí 'oku kailoa he kotou maá? Kua he'iki ai koā kotou 'ilo'i pe mahino'i? Kua fefeka koā ta'a kōtoú loto? ");
INSERT INTO num_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","'Oku kotou mata koā, kae kailoa mamata? Pea 'oku kotou talinga, kae kailoa ongo'i? 'Io, pea 'oku kailoa koā kotou manatu'i? ");
INSERT INTO num_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ko te taimi ne Au pakipaki ai 'ia te fe'i mā 'e nima ma'a te toko nima afé, ko te fia'i kato ne'e kotou 'aumai, kua fonu 'i te 'ū kongakonga maá?” Pea notou tali, “'E hongofulu mā ua.” ");
INSERT INTO num_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“'Io, mo Taku pakipaki 'ia te fe'i mā 'e fitu ma'a te toko fā afé, ko te kato fonu 'e fia 'ia te kongakonga mā ne'e kotou 'aumaí?” Pea notou tali, “'E fitu.” ");
INSERT INTO num_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Pea iange 'e Ia kiā nātou, “Kua he'iki ai koā mahino kiā kōtou?” ");
INSERT INTO num_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pea notou a'u ki Petesaita. Pea ne'e 'aumai kiā Ia he tangata kui, 'o notou kole ke Ina ala ange ki ai. ");
INSERT INTO num_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Pea puke 'e Ia te nima 'o te kuí, 'o 'ave 'ona ki tu'a kolo; pea 'a'anu 'e Ia ki tono ongo fe'i matá, mo 'ai Tono ongo nimá ki te tangatá, 'o fehu'i kiā ia, “'Oku ke 'ilo'i he me'a?” ");
INSERT INTO num_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Pea hanga ake ia 'o iange, “'Okou sio ki te kakai, he 'oku hā he me'a hangē ko he 'ū 'akaú, kā 'oku notou 'eva'eva.” ");
INSERT INTO num_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Pea tē 'ai 'e Ia Tono nimá ki te mata 'o te tangatá; pea sio totonu ia, pea tē ma'uli mai 'o haohaoa, pea ne'e mātu'aki sio lelei ia ki te me'a kotoa pē. ");
INSERT INTO num_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pea fekau 'e Sīsū kiā ia ke 'alu ki tono 'apí, mo pehē ange, “'Aua na'a ke hū ki te koló, pea 'aua na'a ke lea ki he taha 'i te kolo nei.” ");
INSERT INTO num_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Pea 'alu atu 'ia Sīsū mei ai mo Tana kau akó ki te feitu'u 'o Sesalia Filipaí. Pea 'i te notou ō 'i te alá ne'e fehu'i ange Ia ki Tana kau akó, 'o pehē, “Ko ai 'ia Au 'i te lau 'a te kakaí?” ");
INSERT INTO num_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Pea notou tali 'o pehē, “Ko Sione Papitaiso; kā ko te lau 'a te 'ihi, ko 'Ilaisiā; pea ko te 'ihi, ko te toko taha 'i te kau palōfitá.” ");
INSERT INTO num_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Toki fehu'i ange 'e Ia kiā nātou, “Kā ko ai 'ia Au 'i te lau 'a kōtoú?” Pea tali 'e Pita 'o pehē ki Ai, “Ko te Kalaisí 'ia Koe.” ");
INSERT INTO num_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pea lolomi 'e Ia 'ia nātou ke 'aua na'a notou 'ai ke 'ilo'i he taha 'ia te me'a ko iá. ");
INSERT INTO num_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Pea ne'e kamata hinoi'i 'e Ia 'ia nātou, 'i te pau ki te Fanautama te Tangatá ke lahi Tono fakamamahi'í, pea ke fakatale'i 'Ona 'e te kau mātu'á, mo te kau taula'aliki lahí, mo te kau sikalaipé, pea ke tāmate'i; pea kā 'osi te 'aho 'e tolu 'e toetu'u Ia. ");
INSERT INTO num_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Pea ne'e tala'i fakapatonu 'e Ia 'ia te me'a ko iá. Pea 'ave 'Ona 'e Pita, 'o kamata valoki'i Ia. ");
INSERT INTO num_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kā ne tafoki 'e Sīsū, 'o hanga ki Tana kau akó, 'o valoki'i 'ia Pita, mo pehē, “Tu'u ki muli, Sētane; he 'oku kala ko te 'ū me'a faka-e-'Atua 'oku sio ki ai to'oú loto, kā ko te 'ū me'a fakaetangata!” ");
INSERT INTO num_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Pea ui ange 'e Ia 'ia te kakaí, fakataha mo Tana kau akó, 'o pehē kiā nātou, “Kā 'i ai he taha 'oku fia mulimuli mai 'iā Au, kua pau ke tuku 'e ia tono lotó, pea fua tono kolosí, 'o mulimuli mai 'iā Au. ");
INSERT INTO num_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","He ko ia 'oku feinga ke kalofaki ta'aná ma'uli, ko tana tuku ia ke molé; kā ko ia 'oku tuku tana ma'ulí ke mole kote'uhí ko Au mo te ongoongoleleí, 'e fakahaofi ia. ");
INSERT INTO num_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","He ko te ā tono 'aonga ki te tangatá kā ina ma'u 'ia māmani fuli pē 'i tana ngāué, kae mole ai ta'aná ma'uli? ");
INSERT INTO num_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","He ko te ā 'e 'avatu he tangata ke fakatau 'aki mai tana ma'ulí? ");
INSERT INTO num_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Pea kā 'i ai he taha 'e maa'i 'Oku mo Taku 'ū leá 'i te 'ao 'o te to'utangata fe'auaki mo angahala'ina nei, 'e maa'i te toko taha ko iá 'e te Fanautama te Tangatá, 'o kā hā'ele mai Ia mo te nāunau 'o Tana Tamaí, mo te kau 'āngelo mā'oni'oní.” ");
INSERT INTO num_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Pea pehē 'e Ia kiā nātou, “'Okou tala mo'oni atu kiā kōtou, 'oku 'i ai te 'ihi 'oku tutu'u heni, 'e kailoa notou mama'i lave ki te maté, kae'aua ke notou mamata ki te Pule'anga 'o te 'Atuá kua hoko mai mo te mālohi.” ");
INSERT INTO num_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pea 'osi mei ai he 'aho 'e ono, pea 'ave 'e Sīsū 'ia Pita, mo Sēmisi, mo Sione, 'o tataki 'ia nātou ki te ma'unga mā'olunga, fakaenātou pē. Pea ne'e liliu Tono angá 'i te notou 'aó; ");
INSERT INTO num_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","pea ne'e ngingila Tono 'ū kofú, 'o mātu'aki hina ekiaki; 'oku kala he taha fō tupenu 'i māmani 'e mafai tono fakahinahiná ke pehē. ");
INSERT INTO num_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Pea ne'e hā kiā nātou 'ia 'Ilaisiā fakataha mo Mōsese, 'o notou talanoa mo Sīsū. ");
INSERT INTO num_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pea iange 'e Pita kiā Sīsū, “Lāpai, 'oku sai te tou 'i hení. Tuku mu'a ke motou ngaahi he palepale 'e tolu, 'o taha Mo'ou, pea taha mo'o Mōsese, pea taha mo'o 'Ilaisiā.” ");
INSERT INTO num_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","He ne'e kala ina 'ilo'i pe ko te ā hana lea 'e fai, he ne'e notou mate 'i te manaheé. ");
INSERT INTO num_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pea hoko mai leva he konga 'ao 'o fakapūlou'i nātou; pea ne'e ongo mai he le'o mei te 'aó 'o pehē, “Ko Toku 'Alo Pelé 'ena; kotou fakaongo kiā Ia!” ");
INSERT INTO num_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pea tafoki fakavave ake te kau akó 'o fakasio holo, tā ko Sīsū pē Toko Taha ne'e tu'u mo nātoú. ");
INSERT INTO num_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pea 'i te notou ō ifo mei te ma'ungá, ne'e tapou ange 'e Sīsū kiā nātou, ke 'aua 'aupito na'a notou fakamatala ki te 'ū me'a kua notou mamata ki aí, kae'aua ke toetu'u mei te maté 'ia te Fanautama te Tangatá. ");
INSERT INTO num_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Pea ne'e notou tauhi te lea ko iá fakaenātou pē, mo fifili, pe ko te ā koā 'ia te lea ko ia, “toetu'u mei te maté.” ");
INSERT INTO num_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Pea notou fehu'i kiā Ia, 'o pehē, “Ko te ā 'oku lau ai 'e te kau sikalaipé, 'o pehē, kua pau ke matu'a ha'u 'ia 'Ilaisiā?” ");
INSERT INTO num_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Pea tali ange 'e Ia kiā nātou, “'Oku mo'oni pē, 'oku fu'aki ha'u 'ia 'Ilaisiā, 'o fakatonutonu 'ia te 'ū me'a kotoa pē. Kae fefe'aki nai 'ia te me'a kua tohi kau ki te Fanautama te Tangatá, 'o pehē, 'e lahi Tono fakamamahi'í mo Tono fakava'iva'inga 'akí? ");
INSERT INTO num_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kā 'Okou tala'i atu, kua ha'u foki 'ia 'Ilaisiā, pea kua notou fai ta'a nātoú loto kiā ia, 'o tatau mo te me'a ne'e tohi 'o kau kiā iá.” ");
INSERT INTO num_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pea 'i te notou ō ifo ki te kau akó, ne'e notou mamata ki te fu'u kakaí 'oku tu'u takatakai kiā natou, mo he kau sikalaipe 'oku notou fakakikihi mo nātou. ");
INSERT INTO num_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pea 'i te mamata 'e te fu'u kakaí kiā Sīsuú, ne'e notou fu'u 'oho, 'o notou felele'i kotoa pē 'o fetapa kiā Ia. ");
INSERT INTO num_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Pea fehu'i ange 'e Ia kiā natou, “Ko te ā te me'a ne'e kotou fakakikihi ai mo nātoú?” ");
INSERT INTO num_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Pea tali ange he toko taha mei te kakaí, “Tangata'aliki, ne au 'aumai toku fohá kiā Koe, 'oku 'iā ia he fa'ahikehe fakanoa. ");
INSERT INTO num_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Pea ko fea pē he feitu'u 'e puke ai 'e te fa'ahikehé, 'oku ha'aki 'e ia 'ona, pea 'oku koa tono ngutú, mo ngai'i tono nifó, mo hamu tono sinó. Pea u lea ki Tau kau akó ke notou kapusi 'ia te fa'ahikehé, ka ne'e kala notou lava.” ");
INSERT INTO num_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Pea toki tali ange 'e Ia 'o pehē, “'Ia te fa'ahinga ta'etui! 'E ngata 'āfea Taku 'iā kōtoú? 'E ngata 'āfea Taku kātaki'i 'ia kōtoú? 'Aumai ia kiā Au!” ");
INSERT INTO num_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Pea notou 'aumai 'ona kiā Ia. Pea 'i te vakai leva 'e te fa'ahikehé kiā Sīsuú, ne'e fu'u fakatekelili'i 'e ia 'ia te tamá, pea patū ia ki te kelekelé, 'o teketekefili, pea koa tono ngutú. ");
INSERT INTO num_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Pea fehu'i ange 'e Sīsū ki tana tamaí, “Ko te ā tono fualoa tana peheé?” Pea tali ange ia, “Talu pē mei tana valevalé. ");
INSERT INTO num_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Pea kua tu'a lahi tana sī 'ona ki lalo ki te afí mo te vaí, ke tāmate'i 'ona. Kā Ke 'alo'ofa mu'a 'o tokoni mai, 'o kāpau 'e Ke lava.” ");
INSERT INTO num_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Pea pehē ange 'e Sīsū ki ai, “'O kāpau 'e lava koā? 'Oku malava 'ia te me'a kotoa pē kiā ia 'oku tuí!” ");
INSERT INTO num_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Pea kalanga leva te tamai 'a te tamasi'í, 'o pehē, “'Okou tui pē; tokoni mai mu'a ki taku ta'etuí!” ");
INSERT INTO num_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pea 'i te vakai 'e Sīsū 'oku felele'i mai 'ia te kakaí, ne'e lolomi 'e Ia 'ia te fa'ahikehé 'o pehē, “'Ia te fa'ahikehe fakanoa mo tuli, 'Okou fekau kiā koe ke ke hū leva ki tu'a meiā ia, pea 'aua na'a ke tē hū ki ai!” ");
INSERT INTO num_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Pea kaikaila 'ia te fa'ahikehé, mo fakatekelili'i lahi 'ona, 'o toki mahu'i mai. Pea ne'e hangē kua maté 'ia te tamá; 'io, ne'e pehē 'e te kakaí, “Kua pekia ia!” ");
INSERT INTO num_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ka ne'e puke 'e Sīsū tono nimá 'o langa'i, pea tu'u ake ia. ");
INSERT INTO num_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pea 'i te hū 'ia Sīsū ki falé, ne'e fehu'i kiā Ia 'e Tana kau akó fakaenātou, “Ko te ā ne'e kala motou lava ai ke kapusi iá?” ");
INSERT INTO num_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Pea pehē Ia kiā nātou, “Ko te fa'ahinga nei 'oku kailoa lava ia ke mahu'i, kā 'i te lotu pē mo te 'aukai.” ");
INSERT INTO num_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Pea ne'e notou 'alu mei ai, 'o fononga atu 'i Kāleli; pea ne'e kala loto 'e Ia ke 'ilo'i he taha pē 'oku 'i fea Ia. ");
INSERT INTO num_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Hē ne Ina fakamahino'i ki Tana kau akó, 'o pehē, “'E tukuange 'ia te Fanautama te Tangatá ki te nima 'o te kakaí, pea 'e notou tāmate'i 'Ona; pea 'osi te 'aho 'e tolu mei Tono tāmate'í, 'e toetu'u Ia.” ");
INSERT INTO num_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ka ne'e kailoa notou 'ilo'i te 'uhinga 'o Tana leá, pea ne'e notou manahē ke toe fehu'i kiā Ia. ");
INSERT INTO num_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Pea notou a'u ki Kāpaneume; pea 'i Tana 'i te falé ne'e fehu'i ange 'e Ia kiā nātou, “Ko te ā te me'a ne'e kotou fakakikihi ki ai 'i te alá?” ");
INSERT INTO num_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pea notou longo pē, he ne'e notou fakakikihi 'i te alá, pe ko ai 'oku lahi tahá. ");
INSERT INTO num_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Pea nofo ifo 'ia Sīsū, 'o ui ange te kau hongofulu mā uá, 'o pehē kiā nātou, “Kā 'i ai he taha 'oku holi ke mu'amu'a, ke nofo ia ko te ki muli 'iā kōtou kotoa pē, mo te kotou sevāniti.” ");
INSERT INTO num_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Pea to'o 'e Ia he tamasi'i, 'o tuku 'i te notou lotolotongá; pea hapai 'e Ia 'ona 'o fua, mo pehē kiā nātou, ");
INSERT INTO num_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ko ia 'oku ina tali he tamasi'i pehē 'e taha 'i Toku hingoá, 'oku tali 'e ia 'Oku; pea ko ia 'oku ina tali 'Okú, 'oku kala ko Au pē kua tali 'e iá, kā ko Ia ne'e fekau'i mai 'Okú.” ");
INSERT INTO num_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Pea iange 'e Sione kiā Ia, “Tangata'aliki, ne'e motou 'ilo'i he taha 'oku kapusi tēvolo 'i Tou huafá, kā 'oku kailoa mulimuli ia kiā tātou; pea ne'e motou feinga ke ta'ofi ia, kote'uhí he ne'e kailoa ko he taha ia 'iā tātou.” ");
INSERT INTO num_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ka ne'e tali ange 'e Sīsū, “'Aua 'e kotou ta'ofi iá; hē 'oku kailoa he taha 'e fai he mana 'i Toku hingoá, pea toe hanga ia 'o lau'ikovi'i 'Oku. ");
INSERT INTO num_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","He ko ia 'oku kailoa angatu'u kiā tātoú, 'oku kau ia mo tātou. ");
INSERT INTO num_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pea ko ia 'e 'avatu kiā kōtou he ipu vai ke inu 'i Toku hingoá, kote'uhí pē ko te kotou kau kiā Kalaisí, 'Okou tala mo'oni atu kiā kōtou, 'e kailoa 'aupito mole ta'aná totongi. ");
INSERT INTO num_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Kae kā 'i ai he tangata 'e fakatūkia'i he taha 'i te fa'ahinga liliki nei 'oku tuí, 'e sai ange kiā ia kāpau ne'e tautau he fu'u maka 'i tono kiá, 'o sī ki tai. ");
INSERT INTO num_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Pea kāpau 'e fakatūkia'i 'ou 'e tou nimá, tu'usi atu ia; 'oku sai ange tau a'u nima taha ki te ma'ulí, 'i tau mole nima ua ki heli, ki te afi 'oku kailoa 'aupito matāmate'i; ");
INSERT INTO num_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","'a ia 'oku kala 'auha ai te notou 'uangá, pea 'oku kala mate ai 'ia te afí. ");
INSERT INTO num_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Pea kāpau 'e fakatūkia'i 'ou 'e tou va'é, tu'usi ia; 'oku sai ange tau a'u va'e taha ki te ma'ulí, 'i tono sī va'e ua 'ou ki heli, ");
INSERT INTO num_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","'a ia 'oku kailoa 'auha ai te notou 'uangá, pea 'oku kailoa mate ai te afí. ");
INSERT INTO num_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Pea kāpau 'e fakatūkia'i 'ou 'e tou matá, si'aki ia; 'oku sai ange tau a'u mata taha ki te Pule'anga 'o te 'Atuá, 'i tono sī mata ua 'ou ki heli; ");
INSERT INTO num_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","'a ia 'oku kailoa 'auha ai te notou 'uangá, pea 'oku kailoa mate ai 'ia te afí. ");
INSERT INTO num_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","He 'e fakamāsima 'ia te kakai kotoa pē 'aki he afi. ");
INSERT INTO num_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ko te me'a 'aonga 'ia te māsimá, pea kā mole mei te māsimá tono koná, 'e kotou fakakonakonahi ia 'aki te ā? 'Ē, kotou taki taha tauhi 'i tono lotó he māsima; pea kotou fe'ofa'ofani 'i te kotou feangaí.” ");
INSERT INTO num_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Pea mavahe 'ia Sīsū mei ai, 'o ha'u ki te mata fanua 'o Siuteá 'i te kauvai 'e taha 'o Sioataní. Pea ne'e toe fakataha mai kiā Ia he fu'u kakai; pea toe ako'i 'e Ia 'ia nātou, 'o hangē ko Tana fa'a faí. ");
INSERT INTO num_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pea ha'u 'ia te kau Fālesí, 'o 'eke kiā Ia, ko te notou tauhele'i 'Ona, “'Oku ngafua nai ki te tangatá ke tukuange tono 'unohó?” ");
INSERT INTO num_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Pea tali 'e Ia, 'o pehē kiā nātou, “Ko te ā te tu'utu'uni 'a Mōsese kiā kōtoú?” ");
INSERT INTO num_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Pea notou pehē ange, “Ne'e fakangafua 'e Mōsese ke fai he tohi vete, pea tukuange.” ");
INSERT INTO num_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Pea tali 'e Sīsū kiā nātou, “Ko te me'a 'i te fefeka te kotou lotó, ko ia ne'e tohi ai 'ia te tu'utu'uni ko iá kiā kōtou. ");
INSERT INTO num_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kā 'i te kamata'anga 'o te fakatupú, ‘ne'e ngaahi 'e te 'Atuá 'ia te tangata mo te fafine.’ ");
INSERT INTO num_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Ko te me'a ia 'e tukuange ai he tangata tana tamaí mo tana fa'eé, kae pīkitai ki tono malí; ");
INSERT INTO num_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","pea 'e hoko 'ia nāua ko te kakano pē taha.’ Ko ia ai 'oku kala nā kei ua, kā ko te kakano pē taha. ");
INSERT INTO num_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","'Āua; pea ko te me'a kua fakahoko 'e te 'Atuá, ke 'aua na'a fakamāvae'i 'e te tangata!” ");
INSERT INTO num_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pea kua notou 'i fale, pea toe 'eke kiā Ia 'e te kau akó kau ki te me'a ko iá. ");
INSERT INTO num_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Pea pehē ange 'e Ia kiā nātou, “Kā 'i ai he taha 'e vete mo tono hoá, pea toki mali mo he fafine kehe, ko te tono ia. ");
INSERT INTO num_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Pea kā vete he fafine mo tono 'unohó, 'o toki mali mo he tangata kehe, 'oku fe'auaki ia.” ");
INSERT INTO num_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Pea ne'e 'aumai kiā Ia he tamaliki liliki, kote'uhí ke ala kiā nātou; ka ne'e lolomi 'e te kau akó 'ia te kakai ne'e 'aumai 'ia nātoú. ");
INSERT INTO num_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kā 'i te mamata ki ai 'e Sīsuú ne'e tuputāmaki Ia, 'o pehē ange kiā nātou, “Tukuange te tamalikí ke notou ha'u kiā Au; 'aua 'e ta'ofi 'ia nātoú, he 'oku ma'a te fa'ahinga ko iá 'ia te Pule'anga 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","'Okou tala mo'oni atu kiā kōtou, ko ia 'e kailoa ina tali 'ia te Pule'anga 'o te 'Atuá 'o hangē ko he tamasi'í, 'e kailoa 'aupito hū ia ki ai.” ");
INSERT INTO num_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pea hapai 'e Ia 'ia te fanga ki'i tamalikí, 'o 'ai Tono nimá kiā nātou, 'o tāpuaki'i. ");
INSERT INTO num_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Pea 'i Tana hā'ele atu ki te alá, ne'e lele mai he toko taha, 'o tū'ulutui kiā Sīsū, 'o fehu'i ki Ai, “'Ia te Tangata'aliki lelei, ko te ā 'e au fai, kae au ma'u ai 'ia te ma'uli ta'engatá?” ");
INSERT INTO num_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Pea pehē ange 'e Sīsū kiā ia, “Ko te ā 'oku ke ui ai 'Oku ko te leleí? 'Oku kailoa he taha 'oku lelei, ngata pē 'i te 'Atuá Toko Taha. ");
INSERT INTO num_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","'Oku ke 'ilo'i pē 'ia te 'ū fekaú: ‘'Aua na'a ke fe'auaki, 'aua na'a ke fakapō, 'aua na'a ke kaiha'a, 'aua na'a ke fakamo'oni lohi, 'aua na'a ke fai kākā, faka'apa'apa ki tau tamaí mo tau fa'eé.’ ” ");
INSERT INTO num_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Pea tali ange 'e ia 'o pehē ki Ai, “Tangata'aliki, ko te 'ū fekau kotoa pē ko 'ená, kua u 'osi tauhi 'ia nātou fuli pē talu taku kei si'isi'í.” ");
INSERT INTO num_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Pea sio fakamama'u kiā ia 'e Sīsū mo te 'ofa lahi, pea toki pehē ange 'e Ia, “Ko te me'a pē taha 'oku kei toé: 'alu 'o fakatau atu 'ia te me'a kotoa pē 'oku ke ma'ú, pea foaki tono pa'angá ki te masivá, pea 'e 'i ai he koloa 'e fa'olaki ma'au 'i hēvani; pea ke ha'u 'o mulimuli 'iā Au.” ");
INSERT INTO num_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pea ne'e tāfu'ua te tangatá 'i te lea ko iá, 'o foki kua mamahi lahi tono lotó, he ne'e lahi tana koloá. ");
INSERT INTO num_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Pea sio takai holo 'ia Sīsū, 'o pehē ki Tana kau akó, “Ko te me'a faingata'a 'aupito kiā nātou 'oku koloa'iná ke hū ki te Pule'anga 'o te 'Atuá!” ");
INSERT INTO num_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Pea ne'e fu'u 'ohovale 'aupito 'ia te kau akó 'i Tana leá. Pea toe tali tu'a ua 'e Sīsū, 'o pehē kiā nātou, “Fānau, 'e faingata'a 'aupito 'ia te hū ki te Pule'anga 'o te 'Atuá! ");
INSERT INTO num_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","'Oku faingafua ange ke hū he kāmeli 'i te ava'i hui tuitui, 'i te hū he koloa'ina ki te Pule'anga 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pea ne'e notou mātu'aki ofo fakamanahē, 'o notou fepehē'aki, “Pea ko ai tū ia 'e ala ma'uli?” ");
INSERT INTO num_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Pea siofia nātou 'e Sīsū, 'o pehē ange, “'I te vakai 'a te tangatá 'e kailoa lava, kā 'oku kailoa pehē ia ki te 'Atuá; he 'oku malava 'ia te me'a kotoa pē ki te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pea lea ange 'e Pita kiā Ia, “Vakai, ko mātou 'eni kua motou si'aki 'ia te me'a kotoa pē 'o motou mulimuli kiā Koe.” ");
INSERT INTO num_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Pea iange 'e Sīsū, “'Okou tala mo'oni atu kiā kōtou, 'oku kailoa he taha kua si'aki he fale, pe 'ū tokoua, pe 'ū tu'afāfine, pe fa'ē, pe tamai, pe fānau, pe 'ū tōkanga ngoue, kote'uhí ko Au, pea kote'uhí ko te ongoongoleleí, ");
INSERT INTO num_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kā 'e ma'u 'e ia, 'i te nofo ko 'ení 'o lōteau, he 'ū fale, mo te 'ū tokoua, mo te 'ū tu'afāfine, mo te 'ū fa'ē, mo te fānau, mo te kelekele, fakataha mo te 'ū fakatangá foki; pea 'i te maama kaha'ú ko te ma'uli ta'engata. ");
INSERT INTO num_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kā ko te tokolahi 'oku mu'amu'á 'e notou mulimuli, pea ko te mulimulí 'e notou mu'amu'a.” ");
INSERT INTO num_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Pea kua notou fononga atu 'i te alá ki Selusalema; pea mu'amu'a atu 'ia Sīsū 'iā nātou. Pea notou fu'u ofo, pea ko nātou ne'e mulimulí ne'e notou teteki. Pea toe 'ave 'e Ia 'ia te kau hongofulu mā uá, 'o fakamatala'i kiā nātou 'ia te 'ū me'a 'oku ene ke hoko kiā Iá, ");
INSERT INTO num_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","'o pehē, “Ko 'eni, 'oku tou ō ake ki Selusalema, pea 'e tuku 'ia te Fanautama te Tangatá ki te kau taula'aliki lahí mo te kau sikalaipé. Pea 'e notou tu'utu'uni ke tāmate'i 'Ona; pea 'e notou tuku atu 'Ona ki te kau Senitailé, ");
INSERT INTO num_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","pea 'e notou manuki'i 'Ona, mo 'anuhia, mo haha, mo tāmate'i. Pea 'i te 'osi he 'aho 'e tolu 'e toetu'u Ia.” ");
INSERT INTO num_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Pea ne'e ōmai kiā Ia 'ia Sēmisi mo Sione, ko te ongo foha 'o Sēpeti, 'o nā iange ki Ai, “Tangata'aliki, 'oku mā loto ke Ke fai ma'a māua he me'a pē 'e mā kole atú.” ");
INSERT INTO num_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Pea iange Ia kiā nāua, “Ko te ā te me'a 'oku kulā holi ke Au fai ma'a kōluá?” ");
INSERT INTO num_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Pea nā iange, “Tuku mai ke mā nonofo, ko te taha 'i Tou to'omata'ú mo te taha 'i Tou to'ohemá, 'i Tou kolōliá.” ");
INSERT INTO num_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ka ne'e iange 'e Sīsū kiā nāua, “'Oku kala kulā 'ilo'i 'ia te me'a 'oku kulā kole ki aí. He 'e kulā lava koā ke inu 'i te ipu 'Okou inu aí, pē ke papitaiso 'i te papitaiso'anga 'Okou papitaiso aí?” ");
INSERT INTO num_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Pea nā pehē ki Ai, “'E mā lava pē.” Pea pehē 'e Sīsū kiā nāua, “'E kulā inu pē 'i te ipu 'Okou inu aí, pea 'e kulā papitaiso 'i te papitaiso'anga 'Okou papitaiso aí; ");
INSERT INTO num_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","kā ko te nofo ki Toku to'omata'ú pe ko Toku to'ohemá, 'oku kailoa 'A'aku ke 'avatu ia, kā kiā nātou pē kua teuteu ia ki aí.” ");
INSERT INTO num_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Pea 'i te fanongo ki ai 'ia te toko hongofulú, ne'e notou 'ita lahi kiā Sēmisi mo Sione. ");
INSERT INTO num_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pea ui ange nātou 'e Sīsū 'o pehē ange, “'Oku kotou 'ilo'i pē, ko nātou 'oku lau ko te pule 'o te kau Senitailé 'oku notou mafai ke pule'i te notou kakaí; pea ko te notou kau mā'olungá 'oku notou fa'italiha ki te kakaí. ");
INSERT INTO num_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kā 'e kailoa pehē 'ia kōtou ia; kā ko ia 'oku loto ke lahi 'iā kōtoú, 'e nofo ia ko te kotou sevāniti, ");
INSERT INTO num_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","pea ko ia 'oku loto ke tu'ukimu'a 'iā kōtoú, 'e nofo ia ko te tamaio'aliki kiā kōtou kotoa pē. ");
INSERT INTO num_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","He ko te Fanautama te Tangatá foki ne'e kailoa ha'u Iá ke ma'u sevāniti, kā ke sevāniti pē 'e Ia, pea ke foaki Tana ma'ulí ko te huhu'i 'o te tokolahi.” ");
INSERT INTO num_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Pea notou a'u ki Selikō. Pea 'i Tana 'alu atu mei Selikō mo Tana kau akó, fakataha mo te fu'u kakai tokolahi, ne'e nofo mai 'i te va'ealá 'ia Pātimiosi, ko te foha 'o Timiosi, ko te matu'a kui ne'e ma'uli kolekole pē. ");
INSERT INTO num_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Pea 'i tana fanongo ko Sīsū ia mei Nāsaletí, ne'e kalanga ia, 'o pehē, “Sīsū, Hako 'o Tēvitá ē, 'alo'ofa mai kiā au!” ");
INSERT INTO num_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pea lolomi ia 'e te tokolahi ke fakalongolongo; kā ne fakautuutu ai ta'aná kalanga, “Hako 'o Tēvitá ē, 'alo'ofa mai!” ");
INSERT INTO num_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Pea tu'u 'ia Sīsū, 'o pehē, “Ui mai ia!” Pea notou ui mai leva te matu'a kuí, 'o notou pehē ki ai, “Fiamālie koe! Tu'u ki lunga, he ko 'ē 'oku ui mai kiā koe!” ");
INSERT INTO num_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Pea si'aki leva 'e ia tono pulupulú, 'o puna ki lunga 'o 'alu kiā Sīsū. ");
INSERT INTO num_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Pea pehē ange 'e Sīsū ki ai, “Ko te ā te me'a 'oku ke loto ke Au fai ma'aú?” Pea tali 'e te matu'a kuí, “Lāponai, ke au 'ala mu'a!” ");
INSERT INTO num_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Pea folafola 'e Sīsū ki ai, “'Alu ā; kua fakama'uli 'ou 'e tau tuí.” Pea 'ala ake leva ia, 'o mulimuli kiā Sīsū 'i te alá. ");
INSERT INTO num_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Pea kua notou ofi ki Selusalema, 'o hoko ki Petefesi mo Pētani 'i te ma'unga ko 'Ōlivé, pea fekau atu 'e Ia he toko ua 'o Tana kau akó, ");
INSERT INTO num_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","'o pehē kiā nāua, “Kulā ō ki te ki'i kolo ko 'ena 'oku hanga maí; pea 'i te kulā a'u leva ki aí, 'e kulā 'ilo'i he ki'i 'asi kua nono'o, 'a ia kua he'iki ai he tangata 'e heka ki ai; vete ia 'o taki mai. ");
INSERT INTO num_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Pea kā 'i ai he taha 'e 'eke atu, ‘Ko te 'ai ia ke ā?’ pea kulā iange, ‘'Oku fia ma'u ia 'e te 'Alikí, pea 'e toe fakafoki vave mai pē.’ ” ");
INSERT INTO num_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Pea nā ō atu, 'o nā 'ilo'i he ki'i 'asi 'oku nono'o 'i tua'ā, 'o ofi ki te matapā 'i te alá; pea nā vete ia. ");
INSERT INTO num_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pea ko te 'ihi 'iā nātou ne'e tutu'u aí, ne'e notou 'eke ange kiā nāua, “Ko te ā 'oku kulā vete ai te ki'i 'así?” ");
INSERT INTO num_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Pea nā tali 'o hangē ko te fekau 'e Sīsuú; pea notou tuku leva ke nā ō. ");
INSERT INTO num_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Pea nā 'aumai te ki'i 'así kiā Sīsū, pea notou 'ai ki ai te notou 'ū pulupulú, ke heka ai 'ia Sīsū. ");
INSERT INTO num_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Pea ko te tokolahi ne'e notou falikiliki te alá 'aki te notou pulupulú; pea faliki 'aki 'e te 'ihi 'ia te 'ū 'ulu'ulu'i 'akau ne'e notou tu'usi mei te ngoue'angá. ");
INSERT INTO num_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Pea ko nātou ne'e 'alu mu'amu'á, mo nātou ne'e mulimuli maí, ne'e notou fekālanga'i 'o pehē, “Hōsana! 'Oku manū'ia Ia 'oku hā'ele mai 'i te huafa 'o te 'Alikí! ");
INSERT INTO num_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ke manū'ia 'ia te pule'anga 'o te tou tamai ko Tēvitá, 'a ia 'oku hoko mai! Hōsana ki Langi Taupotu!” ");
INSERT INTO num_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pea a'u atu 'ia Sīsū ki Selusalema, 'o hū ki te Temipalé. Pea 'i te 'osi ange Tana vakai holo 'ia te 'ū me'a kotoa pē, ne'e 'alu Ia mei ai ki Pētani fakataha mo te kau hongofulu mā uá; he kua afiafi fau. ");
INSERT INTO num_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pea pongipongi aké, 'i te notou ōmai mei Pētaní, ne'e hālofia Ia. ");
INSERT INTO num_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Pea 'i Tana vakai he fu'u fiki mei te mama'ó kua fai lau, ne'e 'alu Ia ki ai, hei'ilo 'e ma'u ai 'e Ia he me'a. Kā 'i Tana a'u ki aí ne'e kailoa Ina 'ilo'i ai he fua, ko te 'ū lau pē; he ne'e kailoa ko te to'ukai fikí ia. ");
INSERT INTO num_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Pea folafola 'e Ia ki ai, 'o pehē, “Ke 'aua na'a kai tou fuá he taha 'o ta'engata!” Pea ne'e fanongo ki ai Tana kau akó. ");
INSERT INTO num_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pea notou a'u ki Selusalema. Pea hū Ia ki te Temipalé, 'o kamata kapusi 'ia nātou ne'e fakatau atu mo fakatau mai 'i te Temipalé, pea fulihi 'e Ia 'ia te 'ū tēpile 'o te kau fetongi pa'angá, mo te 'ū nofo'a 'o te kakai ne'e fakatau lupé. ");
INSERT INTO num_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Pea ne'e kailoa tuku Ia he taha ke fetuku holo tana kavengá 'i te loto Temipalé. ");
INSERT INTO num_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Pea ne'e faiako Ia, 'o pehē kiā nātou, “Kua kailoa koā tohi 'o pehē, ‘Ko Toku falé 'e ui ko te falelotu mo'o te kakai kotoa pē?’ Kā kua kotou ngaahi ia ko te 'ana 'o he kau kaiha'a!” ");
INSERT INTO num_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pea 'i te fanongo ki ai 'ia te kau taula'aliki lahí mo te kau sikalaipé, ne'e notou fifili pe fefe'aki he notou tāmate'i 'Ona; he ne'e notou manahē kiā Ia, kote'uhí ko te to'oa te loto 'o te kakaí 'i Tana faiakó. ");
INSERT INTO num_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pea 'i te afiafí leva ne'e 'alu atu Ia ki tu'a kolo. ");
INSERT INTO num_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pea 'i te notou foki mai 'i te pongipongi 'e tahá, ne'e notou vakai ki te fu'u fikí kua mate 'o a'u ki tono tafitó. ");
INSERT INTO num_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pea manatu'i 'e Pita, 'o pehē kiā Ia, “Lāpai, vakai angé, ko te fu'u fiki ne Ke tukitala'í kua mate!” ");
INSERT INTO num_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Pea tali 'e Sīsū 'o pehē kiā nātou, “Kotou tui pē ki te 'Atuá! ");
INSERT INTO num_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","He 'Okou tala mo'oni atu kiā kōtou, kā 'i ai he taha 'e pehē ange ki te ma'unga nei, ‘Fei mo mahiki koe, 'o patū ki tai;’ 'o kailoa tāla'a 'i tono lotó, kae ina tui pē 'oku hoko tana leá, 'e hoko ia. ");
INSERT INTO num_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ko ia 'Okou tala'i atu, ko te 'ū me'a kotoa pē 'oku kotou hūfia mo kole, tui pē 'oku kotou ma'u ia, pea 'e hoko kiā kōtou. ");
INSERT INTO num_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pea kā kotou tu'u leva ke lotu, pea kā 'i ai he me'a 'oku kotou kovi'ina ai he taha, fakamolemole'i mu'a 'ona, kote'uhí kae fakamolemole'i 'ia te kotou 'ū angahalá 'e te kotou Tamai 'oku 'i hēvaní. ");
INSERT INTO num_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kae kāpau 'e kailoa kotou fakamolemole, pea 'e kailoa fakamolemole'i 'e te kotou Tamai 'oku 'i hēvaní 'ia te kotou angahalá.” ");
INSERT INTO num_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pea notou toe ha'u ki Selusalema. Pea lolotonga Tana ha'ele 'i te Temipalé, ne'e ha'u kiā Ia 'ia te kau taula'aliki lahí, mo te kau sikalaipé mo te kau mātu'á, ");
INSERT INTO num_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","'o notou fehu'i ki Ai, “Ko te mafai mei fea 'oku Ke fai ai 'ia te 'ū me'a ko 'ení? Pea ko ai ne'e tuku kiā Koe 'ia te mafai ko iá, ke fai 'ia te 'ū me'a nei?” ");
INSERT INTO num_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Pea tali 'e Sīsū, “'E Au fai atu Haku fehu'i 'e taha, pea kā kotou tali mai, pea 'e Au toki fakahaa'i atu pe ko te ā Toku mafai 'Okou fai ai 'ia te 'ū me'a neí. ");
INSERT INTO num_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ko te fai papitaiso 'a Sioné, ne'e mei hēvani ia, pe mei te tangatá? Kotou tali mai.” ");
INSERT INTO num_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Pea notou fekīhiaki 'o pehē, “Kāpau 'e tou tali, ‘Mei hēvani,’ 'e pehē mai Ia, ‘Pea ko te ā ne'e kala kotou tuitala ai kiā iá?’ ");
INSERT INTO num_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kāpau 'e tou pehē, ‘Mei te tangatá’ …” Ka ne'e notou manahē ki te kakai Siú, he ne'e lau kotoa pē 'e nātou, ko Sioné ko te palōfita mo'oni. ");
INSERT INTO num_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Pea notou tali kiā Sīsū, 'o pehē, “'Oku kala motou 'ilo'i.” Pea iange 'e Sīsū kiā nātou, “Pea 'e kailoa ā ke Au tala'i atu 'e Au foki, pe ko te ā Toku mafai 'Okou fai ai 'ia te 'ū me'a neí.” ");
INSERT INTO num_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Pea hanga 'e Ia 'o lea kiā natou 'i te 'ū talanoa fakatātā, “Takua ne'e tō he ngoue vaine 'e te tangata, pea ne ina 'aa'i takai ia, mo keli he tata'o'anga kālepi, mo langa'i he taua 'i ai, pea ne'e tuku 'e ia ke lisi 'e te kau fa'a, kae 'alu ia ki muli. ");
INSERT INTO num_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pea 'i te hoko ki tono to'ukaí, ne'e fekau atu 'e ia he tamaio'aliki ki te kau fa'á, ke ma'u meiā nātou tono 'inasi mei te fua 'o te ngoué. ");
INSERT INTO num_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ka ne'e notou puke'i 'ona 'o haha, mo notou fakafoki mola ia. ");
INSERT INTO num_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Pea toe fekau atu 'e ia he tamaio'aliki kehe, pea ko te toko taha ko iá ne'e notou foa'i tono 'ulú, mo pā'usi'i. ");
INSERT INTO num_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Pea fekau atu 'e ia mo he taha; pea notou tāmate'i 'ona. Pea 'i ai mo he tokolahi kehe; pea notou haha te 'ihi, mo tāmate'i te 'ihi. ");
INSERT INTO num_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ne'e kei toe he toko taha ke fekau, ko tono foha pelé; pea ne'e fekau atu fakamulimuli 'ona 'e ia kiā nātou, ko tana pehē, ‘'E notou toka'i toku fohá.’ ");
INSERT INTO num_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kā ko te kau fa'a ko iá ne'e notou fetala'aki 'o pehē, ‘Ko te 'eá 'ena; 'ē, tou tāmate'i mu'a ia, pea 'e 'o tātou 'ia te tofi'á!’ ");
INSERT INTO num_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Pea notou puke ia 'o tāmate'i, 'o notou toho 'ona ki te tua'ā ngoué. ");
INSERT INTO num_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ko te ā leva te me'a 'e fai 'e te 'aliki 'o te ngoue vainé? 'E hoko mai ia, 'o faka'auha 'ia te kau fa'á, pea 'e 'avange 'e ia te ngoue vainé ki te 'ihi kehe. ");
INSERT INTO num_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","'Io, ne'e kailoa koā kotou lau 'ia te potu Folafola ko iá: ‘Ko te maka ne'e fakata'e'aonga'i 'e te kau tufungá, kua hoko ko te fungani maka 'o te tulikí. ");
INSERT INTO num_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ko te me'a mei te 'Alikí ia, pea fakaofo ki te tou matá’?” ");
INSERT INTO num_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Pea notou feinga ke puke Ia, ka ne'e notou manahē ki te kakaí: he ne'e notou 'ilo'i ko Tana lea 'aki 'ia te talanoa fakatātaá 'o kau kiā nātou. Pea notou 'alu meiā Ia. ");
INSERT INTO num_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pea notou fekau ange kiā Ia he 'ihi 'o te kau Fālesí, pea mo he 'ihi 'o te fa'ahi 'a Hēlotá, ke tauhele'i 'Ona 'i te aleá. ");
INSERT INTO num_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pea notou ōmai kiā Ia 'o pehē, “Tangata'aliki, 'oku motou 'ilo'i 'oku Ke mo'oni pē Koe, pea 'oku kailoa Ke tokanga ki te lau 'a te kakaí, kote'uhí 'oku kailoa Ke filifilimānako, kā 'oku Ke ako totonu 'aki 'ia te ala 'o te 'Alikí. Pe 'oku ngafua ke totongi tukuhau kiā Sisa, pe kailoa?” ");
INSERT INTO num_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ka ne'e 'ilo'i pē 'e Sīsū te notou kākaá, 'o pehē ange 'e Ia kiā nātou, “Ko te ā 'oku kotou 'ahi'ahi'i ai 'Okú? 'Aumai he fe'i tēnali ke Au sio ki ai.” ");
INSERT INTO num_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Pea notou 'aumai. Pea pehē ange 'e Ia kiā nātou, “Ko te fofonga 'ena mo te hingoa 'o ai?” Pea notou tali, “'O Sisa.” ");
INSERT INTO num_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Pea toki iange 'e Sīsū, “Pe'i 'avange kiā Sisa 'ia te 'ū me'a 'a Sisá, pea ki te 'Atuá 'ia te 'ū me'a 'a te 'Atuá.” Pea ne'e notou 'ohovale lahi 'iā Ia. ");
INSERT INTO num_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pea ōmai kiā Ia he kau Sātusi, ko te fa'ahinga 'oku notou lau 'oku kailoa he toetu'u; pea notou fehu'i kiā Ia, 'o pehē, ");
INSERT INTO num_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tangata'aliki, ne'e tohi 'e Mōsese kiā mātou, 'o pehē, ‘Kāpau 'e pekia he taha 'o he tautēhina, 'o tuku tono finematu'á, kae kailoa he fānau, pea ke ma'u 'e tono tokouá 'ia te finematu'á, ke fakatupu 'aki he hako ki tono tokouá.’ ");
INSERT INTO num_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ne'e 'i ai he tautēhina 'e toko fitu. Pea ne'e ma'u 'unoho 'ia te foha lahí; pea ne'e pekia ia 'o kailoa hana hako. ");
INSERT INTO num_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Pea ma'u 'ia te fafiné 'e tono tokouá; pea pekia mo ia, 'o kailoa hana hako; pea pehē tofu pē mo te fika tolú. ");
INSERT INTO num_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Pea ma'u ia 'e te toko fitú, kae kailoa he hako. Pea kua notou pekia kotoa pē, pea toki pekia ki muli mo te fafiné. ");
INSERT INTO num_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","'I te toetu'ú, 'e hoko ia ko te mali 'o ai 'iā nātou? He ko te toko fitú ne'e notou ma'u 'ona ko te notou mali.” ");
INSERT INTO num_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Pea pehē 'e Sīsū kiā nātou, “Ko te me'a ia 'oku kotou hē aí, kote'uhí 'oku kala kotou 'ilo'i 'ia te Tohitapú, mo te māfimafi 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","He kā toetu'u leva 'ia te kakaí mei te pekiá, 'e kailoa he ma'u 'unoho, pe foaki ke 'unoho; kā 'e notou hangē ko te kau 'āngeló 'i hēvani. ");
INSERT INTO num_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kā ko te me'a ki te toetu'u 'o te pekiá, ne kailoa koā kotou lau 'i te Tohi 'a Mōsese 'i te vahe 'oku kau ki te talatala'āmoá, 'ia te folafola 'a te 'Atuá kiā Mōsese, 'o pehē, ‘Ko Au ko te 'Atua 'o 'Ēpalahame, mo te 'Atua 'o 'Aisake, mo te 'Atua 'o Sēkope’? ");
INSERT INTO num_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","'Oku kala ko te 'Atua Ia 'o te maté, kā 'o te ma'ulí. 'Oku kotou hē lahi!” ");
INSERT INTO num_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Pea ha'u kiā Ia he taha 'o te kau sikalaipé, ko tana fanongo ki te notou fakafekikí, mo tana 'ilo'i kua mālō Tana tali kiā nātoú; 'o fehu'i kiā Ia, 'o pehē, “Ko te fa'ahinga tu'utu'uni fea 'oku mamafa tahá?” ");
INSERT INTO num_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Pea ne'e tali 'e Sīsū, “Ko te mahu'inga tahá 'eni, ‘Fanongo mai, 'ia 'Isileli; ko te 'Aliki ko tou 'Atuá, ko te 'Alikí pē taha Ia. ");
INSERT INTO num_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pea 'e ke 'ofa ki te 'Aliki ko tou 'Atuá, 'o fai 'aki te kotoa 'o tou lotó, mo te kotoa 'o tou laumālié, mo te kotoa 'o tou 'atamaí, mo te kotoa 'o tou iví.’ ");
INSERT INTO num_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ko tono uá 'eni, ‘'E ke 'ofa ki tou kaungā'apí 'o hangē ko tau 'ofa kiā koé.’ 'Oku kailoa he fekau 'e toe mamafa ange 'i te ongo fekau nei.” ");
INSERT INTO num_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Pea pehē 'e te sikalaipé kiā Ia, “Mālō, Tangata'aliki, mo'oni Tau laú; 'oku taha pē Ia, pea 'oku kailoa Hana ua. ");
INSERT INTO num_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Pea ko te 'ofa kiā Ia 'aki te kotoa 'o te lotó, mo te kotoa 'o te 'atamaí, mo te kotoa 'o te laumālié, mo te kotoa 'o te iví, pea ko te 'ofa ki tono kaungā'apí 'o hangē ko tana 'ofa kiā iá, 'oku laka ange ia 'i te 'avatu 'o te 'ū feilaulau tutú pe ko te 'ū 'inasí.” ");
INSERT INTO num_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Pea 'i te vakai 'e Sīsū ki te tangatá kua fakapotopoto tana talí, ne'e pehē ange 'e Ia ki ai, “'Oku kala mama'o koe ia mei te Pule'anga 'o te 'Atuá.” Pea ne'e kailoa toe 'i ai he taha 'e fakato'ato'a ke fai he fehu'i kiā Ia. ");
INSERT INTO num_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Pea lolotonga Tana faiako 'i te Temipalé, ne'e fehu'i atu 'e Sīsū 'o pehē, “'Oku fefe'aki te lau 'a te kau sikalaipé, 'o pehē, ‘Ko te Kalaisí ko te Hako 'o Tēvitá Ia’? ");
INSERT INTO num_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","He ne'e lea foki 'e Tēvita, 'i te Laumālie Mā'oni'oní 'o pehē, ‘Ne'e folafola 'e te 'Alikí ki toku 'Alikí, Nofo Koe 'i Toku to'omata'ú, kae'aua ke Au ngaahi Tou 'ū filí ko Tou tu'unga va'e.’ ");
INSERT INTO num_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ko ia, kāpau 'oku ui Ia 'e Tēvita ko tono 'Aliki, pea ko tono hako fefe'aki Ia?” Pea ne'e mālie'ina 'ia te fu'u fakataha 'o te kakaí 'i te notou fanongo kiā Iá. ");
INSERT INTO num_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Pea 'i Tana faiakó ne'e pehē ange Ia, “Kotou lamalama 'ia te kau sikalaipé, 'a ia ko te notou manakó ke 'eva'eva mo te kofu tōtōlofa, mo te faka'apa'apa'ina 'i te 'ū mala'e fakataú, ");
INSERT INTO num_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","pea ke nofo ki mu'a 'i te falelotú, pea 'i te 'ū nofo'anga mā'olunga 'i te 'ū kātoangá. ");
INSERT INTO num_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ko te fa'ahinga 'oku notou folo 'ia te 'ū 'api 'o si'i kau uitoú, pea notou mounu 'aki te notou fa'a lotu loaloá. 'E ma'u 'e te kau siana ko iá he tautea 'oku kovi ange.” ");
INSERT INTO num_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Pea ne'e nofo 'ia Sīsū 'o hanga ki te puha tānaki'anga me'a'ofá, 'o vakai ki te anga 'o te sī pa'anga 'a te kakaí ki ai. Pea ne'e 'i ai he tokolahi koloa'ina ne'e notou sī pa'anga lalahi. ");
INSERT INTO num_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pea ha'u he toko taha, ko he fafine uitou masiva, 'o sī he ongo ki'i pa'anga kapa, 'a ia 'oku konga sēniti pē tono lau fakatahá. ");
INSERT INTO num_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Pea ui ange 'e Ia Tana kau akó, 'o pehē kiā nātou, “'Okou tala mo'oni atu kiā kōtou, ko te si'i fafine uitou masiva nei, kua hulu atu ta'aná sī 'iā nātou fuli pē kua sī ki te tānaki'anga me'a'ofá. ");
INSERT INTO num_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","He ko nātou kotoa pē, ne'e notou sī mei te pa'anga hulu 'o te notou koloá; ka ne'e fusimo'omo 'ia te si'i fafine nei, kae sī 'ia te me'a kotoa pē ne ina ma'ú, 'io, tono kotoa 'o te me'a ne ina ma'u ke tauhi 'aki si'ana ma'ulí.” ");
INSERT INTO num_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Pea 'i Tana fononga atu mei te Temipalé, ne'e lea ange he taha 'o Tana kau akó, “Tangata'aliki, vakai angé 'ia te 'ū maká mo te 'ū falé! Me'a faka'ofa'ofa ē!” ");
INSERT INTO num_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Pea pehē ange 'e Sīsū, “'Oku kotou tokanga koā ki te 'ū fale lalahi nei? 'E kailoa 'aupito toe hili he fe'i maka ia heni 'i te funga maka, kā 'e holoki kotoa pē ki lalo.” ");
INSERT INTO num_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Pea 'i Tana nofo ifo 'i te funga ma'unga ko 'Ōlivé, 'o hanga ki te Temipalé, ne'e fehu'i fakafufū kiā Ia 'e Pita, mo Sēmisi mo Sione mo 'Anitelū, 'o pehē, ");
INSERT INTO num_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tala'i mai, pe hoko fakafea 'ia te 'ū me'a ko iá, pea ko te ā 'ia te faka'ilonga 'o te teu hoko mai 'ia te 'ū me'a ko iá?” ");
INSERT INTO num_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Pea hanga 'e Sīsū 'o lea kiā nātou, “Vakavakai na'a lohiaki'i kōtou he taha. ");
INSERT INTO num_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kote'uhí 'e 'i ai he tokolahi 'e notou ha'u 'i te hingoa 'O'okú, mo notou pehē, ‘Ko au ia;’ pea 'e notou lohiaki'i he tokolahi. ");
INSERT INTO num_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pea kā kotou fanongo ki te 'ū taú mo he 'ū ongoongo 'o te tau, 'aua na'a kotou manavasi'i ai; he kua pau ke hoko ia, kae kei tuai pē 'ia te ngata'angá. ");
INSERT INTO num_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kote'uhí 'e tu'u ake he kakai ki te kakai, mo he pule'anga ki te pule'anga. 'E 'i ai he 'ū mofuike 'i te 'ū feitu'u kehekehe, 'e 'i ai he 'ū honge mo te 'ū mamahi lahi; kā ko te kamata'anga pē ia 'o te langaá. ");
INSERT INTO num_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kae kotou vakavakai kiā kōtou. 'E notou faka'ilo kōtou ki te 'ū fakamāu'angá, pea 'e haha kōtou 'i te 'ū falelotú; pea 'e 'avatu 'ia kōtou ki te 'ao 'o te 'ū kōvaná mo te 'ū tu'í kote'uhí ko Au, ke 'i ai he fakamo'oni kiā nātou. ");
INSERT INTO num_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pea kua pau ke fu'aki malanga 'aki 'ia te ongoongoleleí ki te kakai kotoa pē. ");
INSERT INTO num_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pea kā notou taki 'ia kōtou ke faka'ilo, 'aua na'a kotou lotoma'ua pe ko te ā he kotou lea 'e fai, kā ko te me'a 'e 'avatu kiā kotou 'i te taimi ko iá, kotou lea 'aki ia. He 'oku kailoa ko kōtou 'e leá, kā ko te Laumālie Mā'oni'oní. ");
INSERT INTO num_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Pea 'e faka'ilo 'e te ta'oketé tono tehiná kote'uhí ke tāmate'i, pea ko te tamaí tana fānaú; pea 'e tu'u 'ia te fānaú ki te notou mātu'á, 'o tāmate'i 'ia nātou. ");
INSERT INTO num_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Pea 'e kotou hoko ko te fihi'anakina 'e te kakai kotoa pē kote'uhí ko Toku hingoá; kā ko ia 'e kītaki 'o a'u ki te ngata'angá, ko ia ia 'e ma'ulí. ");
INSERT INTO num_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Pea kā kotou vakai ki te ‘me'a fakalialia 'o te faka'auhá’, 'oku tu'u 'i te feitu'u 'oku kailoa totonu ke tu'u aí (ko ia 'oku lau iá, ke mahino ki ai), pea ke toki hola ki te ma'ungá 'ia nātou 'oku 'i Siuteá. ");
INSERT INTO num_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Pea ko ia 'oku 'i te tu'a falé ke 'aua na'a 'alu ifo ki fale, pe hū ki ai ke 'ave he me'a; ");
INSERT INTO num_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","pea ko ia 'oku 'i te ngoué ke 'aua na'a foki ki 'api ke 'ave tono kofú. ");
INSERT INTO num_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kae pohoē 'ia nātou 'oku faitamá mo nātou 'oku tautama 'i te taimi ko iá! ");
INSERT INTO num_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pea kotou lotua ke 'aua na'a hoko ia 'i te fa'ahita'u momokó. ");
INSERT INTO num_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","He ko te 'ū 'aho ko iá ko te koto mamahi lahi; pea kua he'iki ai ha'aná tatau talu mei te kamata'angá, 'a ia ne'e ngaahi ai 'e te 'Atuá 'ia māmani, 'o a'u mai ki te taimi nei, 'io pea 'e kailoa 'aupito tē 'i ai. ");
INSERT INTO num_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","He ka ne ta'e'aua tono fakanounou 'e te 'Alikí 'ia te taimi ko iá, pehē 'e 'auha 'ia te kakano kotoa pē; kā kote'uhí ko te kakai filí, 'a ia kua fili 'e Iá, ko ia kua Ina fakanounou ai 'ia te taimí. ");
INSERT INTO num_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Pea kāpau 'e pehē atu he taha, ‘'Ē, 'oku 'i heni 'ia Kalaisi,’ pē ‘'Oku 'i hena;’ 'aua na'a kotou tui ki ai. ");
INSERT INTO num_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kote'uhí 'e tupu ake he kau Kalaisi lohi, mo he kau palōfita lohi, pea 'e notou fakahoko he 'ū faka'ilonga, mo he 'ū me'a fakaofo, 'o fai ke kākaa'i 'aki te kakai filí, 'o kāpau ne lava. ");
INSERT INTO num_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kae kotou tokanga 'ia kōtou; he kua U sinaki fakahaa'i atu 'ia te 'ū me'a nei fuli pē kiā kōtou. ");
INSERT INTO num_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Kā 'i te 'ū 'aho ko iá, hili ange te mamahi ko iá, 'e fakapō'uli 'ia te la'aá, pea 'e tuku 'e te māhiná tana huhulú, ");
INSERT INTO num_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","pea 'e ngangana 'ia te 'ū fetu'ú mei te langí, pea 'e lulu'i 'ia te 'ū mālohinga 'o te langí. ");
INSERT INTO num_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Pea 'e notou toki sisio ki te Fanautama te Tangatá 'oku hoko mai 'i te 'ū 'aó, pea ha'u mo Ia 'ia te mālohi mo te nāunau lahi. ");
INSERT INTO num_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pea 'e toki fekau atu 'e Ia Tana kau 'āngeló, pea 'e notou tānaki 'ia te kakai filí mei te matangí 'e fā, mei te ngata'anga 'o māmaní 'o a'u ki te ngata'anga 'o te langí. ");
INSERT INTO num_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Pea kotou ma'u mei te fu'u fikí tono fakatātaá: kā muimuia tono muká pea kamata lau, 'oku kotou 'ilo'i leva kua ofi 'ia te fa'ahita'u māfaná. ");
INSERT INTO num_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ke pehē foki 'ia kōtou, kā kotou vakai leva kua hoko 'ia te 'ū me'a ko 'ení, pea kotou 'ilo'i kua ofi ia, 'io, kua a'u ki te matapaá. ");
INSERT INTO num_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","'Okou tala mo'oni atu kiā kōtou, 'e kailoa 'aupito mole 'ia te to'utangata ko 'ení, kae'aua ke hoko 'ia te 'ū me'a ko iá fuli pē. ");
INSERT INTO num_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","'E mole 'ia te langí mo māmani, kā ko Taku 'ū leá 'e kailoa 'aupito mole. ");
INSERT INTO num_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Kā ko te me'a ki te 'aho ko iá, mo tono houá, 'oku kailoa he taha 'oku 'ilo ki ai, pe ko he 'āngelo 'i te langí, pea na'a mo te 'Aló, ngata pē 'i te Tamaí Toko Taha. ");
INSERT INTO num_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kotou tokanga, kotou lele'o pē mo lotu, he 'oku kailoa kotou 'ilo'i pē 'e fakafea tono taimí. ");
INSERT INTO num_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","'O hangē ko he tangata 'oku 'alu ki muli, pea tukuange 'e ia tono 'apí, mo tu'utu'uni ki tana tamaio'aliki taki taha tono tu'unga mo tana ngāue, pea na'ina'i foki 'e ia ki te tauhi matapaá ke le'o. ");
INSERT INTO num_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ko ia kotou lele'o, he 'oku kala kotou 'ilo'i pe hoko fakafea mai 'ia te 'Aliki 'o te 'apí, pe afiafi, pe tu'ulapō, pe 'i te 'u'ua 'ia te moá, pe hengihengi — ");
INSERT INTO num_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","na'a ha'u fakafokifā pē ia, 'o 'ilo'i kōtou 'oku kotou momoe. ");
INSERT INTO num_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Pea ko te me'a 'Okou tala kiā kōtoú, 'Okou tala ki te kakai kotoa pē: kotou lele'o!” ");
INSERT INTO num_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pea ne'e toe pē he 'aho 'e ua pea a'u ki te Pāsová, mo te Kātoanga Kai Mā Ta'e Lēvaní. Pea ko te kau taula'aliki lahí, mo te kau sikalaipé, ne'e notou fiu 'i te feinga pe fefe'aki he notou puke fakafufū 'ia Sīsū, 'o tāmate'i. ");
INSERT INTO num_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","He ne'e notou pehē, “'Aua na'a fai lolotonga te kātoangá, na'a faifai angé kua 'i ai he maveuveu 'i te kakaí.” ");
INSERT INTO num_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Pea ne'e 'i Pētani 'ia Sīsū 'i te fale 'o Saimone ko te kiliá, pea lolotonga Tana nofo 'i te kaí, ne'e ha'u he fafine mo tana hina 'alapasita, ne'e fonu 'i te lolo tākai, ko te na'ati mo'oni, pea mahu'inga 'aupito, 'o lilingi 'ia te loló ki Tono fofongá. ");
INSERT INTO num_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Pea ne'e 'i ai he 'ihi ne'e notou lāunga, 'o pehē, “Ko te ā kua maumau'i ai te lolo tākai nei? ");
INSERT INTO num_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","He kāpau ne'e fakatau atu ia, ne'e mei ma'u ai he tēnali 'e tolungeau tupu ke foaki ki te masivá!” Pea notou fakaanga'i lahi 'ia te fafiné. ");
INSERT INTO num_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ka ne'e pehē ange 'e Sīsū, “Tuku ai pē 'ia te fafiné; ko te ā 'oku kotou fakamamahi ai kiā iá? He ko te ngāue lelei ia kua fai 'e ia kiā Aú. ");
INSERT INTO num_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","He ko te me'a ki te masivá 'e kotou feangai ai pē mo nātou, pea kā kotou loto ke fai he 'ofa ki ai, pea faingafua; kā 'e kailoa kotou feangai ai pē mo Au. ");
INSERT INTO num_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kua fai 'e ia si'ana tūkuingatá; he kua sinaki tākai 'e ia Toku sinó ki fa'itoka. ");
INSERT INTO num_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","'Okou tala mo'oni atu kiā kōtou, ko te feitu'u kotoa pē 'i māmani 'e malanga 'aki ai 'ia te ongoongoleleí, 'e lea 'aki ai foki 'ia te me'a ne'e fai 'e te si'i fafine nei, ko te fakamanatu kiā ia.” ");
INSERT INTO num_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pea ko Siutasi 'Isikaliote, ne ina 'alu mei ai ki te kau taula'aliki lahí, kote'uhí ke lavaki'i 'e ia 'Ona kiā nātou. ");
INSERT INTO num_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pea 'i te notou fanongo ki tana laú, ne'e notou fiafia 'o notou aleapau ke 'avange hana pa'anga. Pea toki kumi faingamālie leva 'e Siutasi ke lavaki'i 'ia Sīsū. ");
INSERT INTO num_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pea 'i te 'uluaki 'aho 'o te Kātoanga Kai Mā Ta'e Lēvaní, 'ā ē 'oku tāmate'i ai 'ia te Pāsová, ne'e lea ange Tana kau akó kiā Ia, “Ko fea te feitu'u 'oku Ke loto ke motou ō 'o teuteu ke Ke 'ilo ai 'ia te pāsová?” ");
INSERT INTO num_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Pea fekau 'e Ia he toko ua 'o Tana kau akó, 'o iange, “Kulā ō ki te koló, pea 'e fakafetaulaki mai kiā kōlua he tangata 'oku fua he hina vai; kulā mulimuli ki ai. ");
INSERT INTO num_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ko fea pē he 'api 'e hū ia ki aí, pea kulā lea ai ki te matāpule 'o te falé, ‘'Oku pehē mai 'e te Tangata'alikí: “Ko fea Toku loki ke Au kai ai 'ia te Pāsová mo Taku kau akó?”’ ");
INSERT INTO num_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Pea 'e fakahā atu 'e ia kiā kōlua he fu'u falekai 'i lunga kua 'osi faliki mo teuteu; ko te feitu'u ia 'e kulā teuteu ai ma'a tātoú.” ");
INSERT INTO num_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Pea 'alu atu te ongo akó, 'o nā hū ki te koló, 'o nā 'ilo'i pē 'o hangē ko Tana iange kiā nāuá; 'o nā teu ai 'ia te Pāsová. ");
INSERT INTO num_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pea 'i te afiafí pō'ulí ne Ina nofo ifo ke kai fakataha mo te kau hongofulu mā uá. ");
INSERT INTO num_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Pea 'i te lolotonga te notou tā'u'utu 'o kaí ne'e lea ange 'e Sīsū 'o pehē, “'Okou tala mo'oni atu kiā kōtou, ko te toko taha 'iā kōtou 'e lavaki'i 'Oku, 'io, ko te toko taha 'oku kai mo Au.” ");
INSERT INTO num_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Pea notou kamata loto mamahi, pea notou hanga 'o lea tahataha kiā Ia, 'o pehē, “'Oku kailoa nai ko au, 'ē?” ");
INSERT INTO num_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Pea pehē ange 'e Ia kiā nātou, “Ko te toko taha pē 'o te kau hongofulu mā uá, 'a ia 'oku ala fakataha mo Au ki te tisí. ");
INSERT INTO num_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","He 'oku mo'oni ko te mole 'ia te Fanautama te Tangatá 'oku hangē ko ia kua tohi Ma'aná, kae pohoē 'ia te tangata 'e ina lavaki'i 'ia te Fanautama te Tangatá! Ne ngutuhua ange ki te tangata ko iá kāpau ne kailoa fanau'i.” ");
INSERT INTO num_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Pea lolotonga te notou kaí ne Ina to'o he fe'i mā, 'o tāpuaki'i, mo pakipaki, 'o 'avange kiā nātou, 'o pehē ange 'e Ia, “To'o; ko Toku sinó 'eni.” ");
INSERT INTO num_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ne Ina to'o foki he ipu, pea hili Tana fai he fakafeta'i, ne Ina 'avange kiā nātou; pea notou inu kotoa pē mei ai. ");
INSERT INTO num_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Pea pehē 'e Ia kiā nātou, “Ko Toku totó 'eni, ko te toto 'o te fuakavá, 'a ia 'oku lilingi kote'uhí ko te tokolahi. ");
INSERT INTO num_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","'Okou tala mo'oni atu kiā kōtou, 'e kailoa 'aupito ke Au tē inu mei te fua 'o te vainé, 'o a'u ki te 'aho ko ia 'e Au toki inu ai ia kua fo'ou 'i te Pule'anga 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pea hili ange te notou fai he hiva, ne'e notou ō ki te ma'unga ko 'Ōlivé. ");
INSERT INTO num_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Pea iange 'e Sīsū kiā nātou, “'E kotou tūkia kotoa pē, he kua tohi, ‘'E Au taa'i 'ia te tauhí, pea 'e mavete te fanga sipí.’ ");
INSERT INTO num_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kā neongo iá, kae hili ange Taku toetu'ú, 'e Au mu'amu'a 'iā kōtou ki Kāleli.” ");
INSERT INTO num_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ka ne'e iange 'e Pita ki Ai, “Neongo 'e tūkia kotoa pē, kā 'e kailoa pehē 'eni ia.” ");
INSERT INTO num_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Pea iange 'e Sīsū kiā ia, “'Okou tala mo'oni atu kiā koe, ko te 'ānaí, 'io, 'i te pō nei, 'i te he'iki ai 'u'ua tu'a ua 'ia te moá, kua tu'a tolu ta'aú fakafisinga'i 'Oku.” ");
INSERT INTO num_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kā ne 'āsili ai ta'aná lea fakamātoato, “'E kailoa 'aupito ke au fakafisinga'i 'Ou, neongo 'e iku pē ki ta'akú mate mo Koe!” Ne'e lea pehē foki 'ia nātou kotoa pē. ");
INSERT INTO num_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pea notou a'u ki te feitu'u 'oku ui ko Ketisemani; pea pehē ange 'e Ia ki Tana kau akó, “Kotou nonofo ifo heni, kae Au 'alu 'o lotu.” ");
INSERT INTO num_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pea ne'e 'alu mo Ia 'ia Pita mo Sēmisi mo Sione, pea kamata ke mamahi Tono lotó 'o hoha'a lahi; ");
INSERT INTO num_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","pea pehē 'e Ia kiā nātou, “'Oku mamahi lahi Toku laumālié, 'o hangē kā maté. Kotou tatali 'i heni, 'o le'o.” ");
INSERT INTO num_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Pea 'alu si'i atu Ia, 'o tō fo'oifo ki te kelekelé, pea lotu 'e Ia ke tolona 'ia te houá meiā Ia, 'o kāpau 'e lava. ");
INSERT INTO num_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Pea pehē 'e Ia, “'Apā, Tamai, 'oku malava 'e Koe 'ia te me'a kotoa pē; ke ke fakalaka mu'a 'ia te ipu nei meiā Au. Kā neongo ia, 'aua na'a fai ki To'okú loto, kā ki To'oú pē.” ");
INSERT INTO num_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pea ha'u Ia 'o 'ilo'i 'ia nātou kua notou momoe, 'o Ina pehē ange kiā Pita, “'E Saimone, 'oku ke moe koā koe ia? 'Oku kailoa koā lava ke ke 'ala 'o houa taha? ");
INSERT INTO num_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kotou lele'o pē mo lotu, ke 'aua na'a kotou tō ki te 'ahi'ahí. 'Oku loto pē 'ia te laumālié ke fai, kā 'oku vaivai 'ia te kakanó.” ");
INSERT INTO num_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Pea tē 'alu Ia 'o lotu, 'o fai 'aki 'ia te lea pē ko iá. ");
INSERT INTO num_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pea tē ha'u Ia, 'o 'ilo'i 'ia nātou 'oku notou kei momoe pē, he ne'e mafatukituki te notou matá. Pea ne'e kala notou 'ilo'i pe ko te ā he notou tali 'e fai kiā Ia. ");
INSERT INTO num_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pea ha'u Ia ko tono tu'a tolú, 'o pehē kiā nātou, “Kotou momoe ai pe ā 'eni mo mālōlō. Kua fe'unga; kua hokosia tono taimí. 'Ē, 'oku lavaki'i 'ia te Fanautama te Tangatá ki te nima 'o te kau angahalá. ");
INSERT INTO num_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kotou tutu'u, kae tou ō; vakai, kua ofi mai Toku lavakí!” ");
INSERT INTO num_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Pea fokifā pē, lolotonga Tana kei leá, mo te a'u mai 'ia Siutasi 'Isikaliote, ko te toko taha 'o te kau hongofulu mā uá, pea ha'u mo ia he fu'u kakai mo te 'ū heletā mo te 'ū 'akau, ko te notou ōmai mei te kau taula'aliki lahí mo te kau sikalaipé mo te kau mātu'á. ");
INSERT INTO num_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Pea ko ia ne'e lavaki'i Iá ne ina tuku he faka'ilonga kiā nātou, 'aki tana pehē, “Ko Ia ko 'ē 'e au 'uma ki aí, ko Ia ia; kotou puke'i 'Ona, 'o taki atu.” ");
INSERT INTO num_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pea 'i tana ha'ú, ne ina 'unu'unu leva ki Ai mo pehē, “Lāpai!” 'o 'uma kiā Ia. ");
INSERT INTO num_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Pea ala mālohi kiā Ia 'e te kakaí, 'o notou puke Ia. ");
INSERT INTO num_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pea ko te toko taha 'o nātou ne tu'u ofi angé ne ina unuhi tana heletaá, 'o taa'i 'ia te tamaio'aliki 'a te Taula'aliki Lahí, 'o tu'usi tono lau'i talingá. ");
INSERT INTO num_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Pea lea 'e Sīsū, 'o pehē kiā nātou, “Ko te kotou ōmai mo te heletā mo te 'akau ke puke 'Okú, 'o hangē ko he kaiha'a 'ia Aú! ");
INSERT INTO num_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ko te 'aho kotoa pē ne Au 'iā kōtou 'i te Temipalé 'o faiako, ka ne'e kailoa kotou puke'i 'Oku. Kā ko tono 'uhingá, ke fakamo'oni ki te 'ū Folafolá.” ");
INSERT INTO num_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pea notou si'aki 'Ona 'o notou hola kotoa pē. ");
INSERT INTO num_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pea ko te talavou 'e toko taha, ne ina mulimuli atu mo te kakaí kua kailoa 'ai hana kofu, kā kua takatakai 'aki 'ona he fu'u tupenu, pea notou puke'i ia. ");
INSERT INTO num_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pea si'aki 'e ia to'oná tupenu, 'o hola tēlefua meiā nātou. ");
INSERT INTO num_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pea notou taki ange 'ia Sīsū ki te Taula'aliki Lahí. Pea fakataha kiā ia 'ia te hau'aliki taula'aliki kotoa pē, mo te kau mātu'á, mo te kau sikalaipé. ");
INSERT INTO num_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pea ne'e mulimuli ki ai 'ia Pita mei te mama'ó 'o hū ki te loto'ā 'o te Taula'aliki Lahí; pea ne ina nofo fakataha mo te kau le'o Temipalé, 'o mūmū 'i te afí. ");
INSERT INTO num_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pea ko te kau taula'aliki lahí, mo te Sanetalimí kotoa pē, ne'e notou fiu'a kumi he talatalaaki 'o Sīsū ke lava ai Tono tāmate'i; kā ne kailoa notou ma'u. ");
INSERT INTO num_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","He neongo ne'e 'i ai he tokolahi ne'e notou tukuaki'i 'Ona, ka ne'e kailoa fai tatau te notou 'ū fakamatalá. ");
INSERT INTO num_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Pea tutu'u ake mo he 'ihi, 'o notou tukuaki'i Ia, 'o pehē, ");
INSERT INTO num_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ne'e motou fanongo kiā Ia 'oku pehē, ‘'E Au vete 'ia te Fale Tapu nei, 'a ia kua ngaahi 'e te nimá, pea 'e Au langa 'i te 'aho 'e tolu he Fale Tapu 'e taha, 'a ia 'oku kailoa ko te ngaahi 'e te nimá.’ ” ");
INSERT INTO num_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kae na'a mo ia, ne'e kailoa pē fai tatau te notou fakamatalá. ");
INSERT INTO num_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Pea tu'u mai ki loto 'ia te Taula'aliki Lahí, 'o fehu'i ange kiā Sīsū, “'Oku kala koā Ha'aú mama'i tali ki te me'a 'oku talatalaaki'i ai 'Ou 'e nātou nei?” ");
INSERT INTO num_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kā ne fakalongolongo pē Ia, 'o kailoa tali Ia he me'a. Pea toe fehu'i 'e te Taula'aliki Lahí, 'o pehē ki Ai, “Ko te Kalaisí 'ia Koe, ko te 'Alo 'o te Fakamālō'iná?” ");
INSERT INTO num_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Pea pehē ange 'e Sīsū, “Ko Au Ia; pea 'e kotou mamata ki te Fanautama te Tangatá 'oku nofo ki te nima to'omata'u 'o Mālohí, pea 'oku ha'u Ia mo te 'ū 'ao 'o te langí.” ");
INSERT INTO num_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pea toki hae ifo 'e te Taula'aliki Lahí tono kofu 'o'oná, 'o pehē ange, “Kote'uma'aki te tou tē kumi fakamo'oni? ");
INSERT INTO num_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kua kotou fānonongo ki te lea fia 'Atuá; ko te ā leva te kotou lotó?” Pea notou loto taha kotoa pē, ko te Tangatá ia 'oku tonu 'aupito ke mate. ");
INSERT INTO num_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Pea hanga he 'ihi 'o 'anuhi 'Ona, pea notou fakapūlou'i Tono fofongá, 'o notou taa'i 'Ona, mo notou pehē ki Ai, “Mate mai pe ko ai ne taa'i 'Oú!” Pea pēkalae'i 'Ona 'e te kau le'o Temipalé 'aki te notou lau'i nimá. ");
INSERT INTO num_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pea 'i te kei nofo 'ia Pita 'i lalo 'i te loto'aá, ne'e ha'u he toko taha 'o te kau kaunanga 'a te Taula'aliki Lahí. ");
INSERT INTO num_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pea 'i tana vakai kiā Pita 'oku mūmuú, ne ina sio fakamama'u kiā ia 'o pehē, “Ko koe foki ne ke 'iā Sīsū mei Nāsaletí!” ");
INSERT INTO num_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ka ne'e fakafisi ia, 'o pehē, “'Oku kala 'ilo'i Ia 'e au, pea 'oku kailoa mahino kiā au pe ko tau laú ki te ā.” Pea 'alu atu ia mei ai ki te fale hū'angá; pea ne'e 'u'ua 'ia te moá. ");
INSERT INTO num_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pea tē vakai kiā ia 'e te kaunangá, 'o kamata lea kiā natou ne'e tutu'u 'i aí, 'o pehē, “'Oku kau 'ia te siana nei ki te fa'ahinga ko iá!” ");
INSERT INTO num_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pea tē fakafisi pē ia. Pea fualoa si'i atu, ne'e tē lea kiā Pita 'ia nātou ne'e tutu'u 'i aí, “'Ē, 'oku mo'oni pē 'oku ke kau ki te fa'ahinga ko iá; kae'uma'ā he ko te Kāleli foki 'ia koe!” ");
INSERT INTO num_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ka ne'e tuki mo fuakava 'e ia 'o pehē, “'Oku kailoa 'aupito ha'akú 'ilo 'e taha ki te Tangata ko 'ena 'oku kotou lau ki Aí.” ");
INSERT INTO num_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pea ne'e 'u'ua leva 'ia te moá ko tono tu'a uá. Pea manatu 'ia Pita ki te lea ne'e lea 'aki 'e Sīsū kiā ia 'o pehē, “'I te he'iki ai 'u'ua tu'a ua 'ia te moá, kua tu'a tolu ta'aú fakafisinga'i 'Oku.” Pea 'i tana manatu ki aí, ne'e toki tangi mamahi ia. ");
INSERT INTO num_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pea pongipongí leva, ne'e fai 'e te kau taula'aliki lahí te notou fakakaukau, pea mo te kau mātu'á mo te kau sikalaipé, 'io, 'ia te Sanetalimí kotoa pē; 'o notou ha'i 'ia Sīsū, pea notou 'ave 'Ona kiā Pailato. ");
INSERT INTO num_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pea fehu'i 'e Pailato kiā Sīsū, “Ko Koe 'ia te Tu'i 'o te kakai Siú?” Pea tali Ia ki ai, 'o pehē, “Ko ia pē.” ");
INSERT INTO num_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pea hanga 'e te kau taula'aliki lahí, 'o talatalaaki'i 'Ona 'i te 'ū me'a lahi. ");
INSERT INTO num_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pea tē fehu'i 'e Pailato kiā Ia, 'o pehē, “'Oku kailoa Hau mama'i tali koā? Vakai ange ki te 'ū me'a kua notou talatalaaki'i 'aki 'Oú!” ");
INSERT INTO num_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kā ne kailoa tē tali 'e Sīsū he mama'i me'a 'e taha; ko ia ne'e ofo ai 'ia Pailato. ");
INSERT INTO num_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pea kā hoko 'ia te kātoangá, ne'e vete ange 'e Pailato he pōpula 'e taha, 'a ia pē 'e notou kole ki aí. ");
INSERT INTO num_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pea ne'e 'i ai he matu'a ne'e hingoa ko Palāpasa, 'a ia ne'e nofo ha'isia fakataha mo te 'ihi ne'e angatu'u, 'a ia ko te fa'ahinga ne'e notou fai he fakapō lolotonga te notou angatu'ú. ");
INSERT INTO num_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Pea ō ange te kakaí, 'o notou kaikaila kiā ia ke fai ange ma'a nātou 'o hangē ko tana fa'a faí. ");
INSERT INTO num_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pea tali 'e Pailato, 'o pehē kiā nātou, “'Oku kotou loto ke au vete atu 'ia te Tu'i Siú?” ");
INSERT INTO num_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Hē ne ina 'ilo'i, tā ko te loto meheka kua tukuange ai 'Ona 'e te kau taula'aliki lahí. ");
INSERT INTO num_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kā ne'e ue'i 'e te kau taula'aliki lahí 'ia te kakaí ke vete mai pē 'ia Palāpasa. ");
INSERT INTO num_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pea toe tali 'e Pailato, 'o pehē kiā natou, “Pea ko te ā leva te me'a 'oku kotou loto ke au fai kiā Ia 'oku kotou ui ko te Tu'i Siú?” ");
INSERT INTO num_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Pea notou tē kalanga, “Kalusefai Ia!” ");
INSERT INTO num_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pea pehē 'e Pailato kiā nātou, “He ko te ā he kovi kua fai 'e Ia?” Kā ne fakautuutu pē te notou kalangá, “Kalusefai Ia!” ");
INSERT INTO num_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pea ko Pailato, ko te me'a 'i tana fia fai te me'a 'oku loto ki ai 'ia te kakaí, ne ina vete ange 'ia Palāpasa kiā nātou, pea 'i te 'osi ange tana kau'imaea'i 'o Sīsuú, ne ina tuku atu 'Ona ke kalusefai. ");
INSERT INTO num_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pea taki ange 'Ona 'e te kau taú, 'o fakahū ki te loto'ā 'o te Palasi 'o te kōvaná; pea notou fakataha 'ia te vāhenga taú kotoa pē. ");
INSERT INTO num_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pea notou 'ai kiā Ia he kofu kulakula, pea notou fī he kalauni talatala, 'o 'ai takai 'i Tono fofongá. ");
INSERT INTO num_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pea notou kamata fetapa kiā Ia, 'o pehē “'Ēī, Tu'i 'o te kakai Siú!” ");
INSERT INTO num_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pea notou taa'i Tono fofongá 'aki he kaho, mo notou 'anuhi 'Ona, pea notou tū'ulutui 'o hū kiā Ia. ");
INSERT INTO num_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pea 'osi ange te notou va'inga'aki Iá, ne'e notou to'o meiā Ia 'ia te kofu kulakulá, kae notou 'ai ki Ai Tono kofu 'O'oná. Pea notou taki atu Ia ke kalusefai. ");
INSERT INTO num_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pea ne'e notou fekau he tangata ko Saimone mei Sailine, ko tana ha'ú mei 'uta, pea ko te tamai 'a 'Alekisānita mo Lūfusi, ke fua Tono kolosí. ");
INSERT INTO num_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pea ne'e notou 'ave 'Ona ki te feitu'u ko Kolokota, 'a ia ko tono hikí, ko te feitu'u 'o te 'ulupoko. ");
INSERT INTO num_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pea ne'e notou 'avatu kiā Ia he uaine kua hu'i 'aki te mula, ka ne'e kailoa tali 'e Ia. ");
INSERT INTO num_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Pea 'i te 'osi ange te notou kalusefai Iá, ne'e notou tufatufa Tono 'ū kofú, 'o notou talotalo ki ai, ke 'ilo'i pe ko te ā 'e ma'u 'e te tangata taki taha. ");
INSERT INTO num_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Pea 'i te hoko te hiva pongipongí ne'e notou kalusefai ai 'Ona. ");
INSERT INTO num_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pea ne'e 'ai he tohi 'i lunga ki te 'uhinga 'o Tono tauteá, 'a ia ne'e tohi 'i ai 'o pehē, “KO TE TU'I 'O TE KAKAI SIU.” ");
INSERT INTO num_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Pea notou kalusefai fakataha mo Ia he ongo kaiha'a, ko te toko taha mei to'omata'u, mo te toko taha mei to'ohema. ");
INSERT INTO num_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Pea ne'e fakamo'oni'i ai te lau 'a te Folafolá, 'o pehē, “Pea ne'e fakakau Ia fakataha mo te kau maumau laó.” ");
INSERT INTO num_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Pea ko te kakai ne'e ō angé ne'e notou talalākulaku ki Ai, mo notou kalokalo te notou 'ulú, 'o notou pehē, “Uē! 'Ia te Tama holoki Fale Tapu 'o langa 'i te 'aho 'e tolú! ");
INSERT INTO num_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","'Alu ifo angé mei te kolosí, 'o fakahaofi 'Ou!” ");
INSERT INTO num_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pea manuki pehē foki mo te kau taula'aliki lahí mo te kau sikalaipé 'o notou fepehē'aki 'iā nātou 'o pehē, “Ne Ina fakahaofi 'ia te kakai kehé, kā 'oku kailoa Ina lava ke fakahaofi pē 'Ona! ");
INSERT INTO num_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ko te Kalaisí takua 'eni, ko te Tu'i 'Isilelí; pea tukuangé ke 'alu ifo Ia mei te kolosí, ke motou sio ki Ai kae motou toki tui!” Pea ko te ongo me'a foki ne'e kalusefai mo Iá ne'e nā manuki'i 'Ona. ");
INSERT INTO num_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pea 'i te a'u ki te ho'atā mālié, ne'e hoko he pō'uli ki te fanuá fuli pē, 'o a'u ki te tolu afiafí. ");
INSERT INTO num_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pea 'i te tolu afiafí ne'e kalanga le'o lahi 'ia Sīsū, “'Īlai, 'Īlai, lama sapakatani?”, 'a ia ko tono hikí, “'E Toku 'Atua, 'e Toku 'Atua, ko te ā kua Ke si'aki ai 'Okú?” ");
INSERT INTO num_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Pea ko te 'ihi 'iā nātou ne'e tutu'u ofi maí, 'i te notou fānonongo ki aí, ne'e notou pehē, “Vakai, 'oku ui Ia kiā 'Ilaisiā!” ");
INSERT INTO num_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Pea lele he toko taha, 'o unu he oma 'i te vinika, 'o 'ai ki te va'a kaho, 'o 'avange kiā Ia ke inu, mo pehē ange, “'Ē, tou vakai angé pe 'e ha'u 'ia 'Ilaisiā ke 'ave ifo 'Ona!” ");
INSERT INTO num_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pea ne'e kalanga le'o lahi 'ia Sīsū, 'o toki tukuange Tono laumālié. ");
INSERT INTO num_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Pea ne'e mahaeua 'ia te puipui 'o te Fale Tapú mei lunga ki lalo. ");
INSERT INTO num_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Pea ko te senituliō ne'e tu'u ofi mai, 'o fehangahangai mo Iá, 'i tana vakai ki te pehē te tukuange Tono laumālié, ne'e pehē ia, “Tā ko te mo'oni pē, ko te 'Alo Ia 'o te 'Atuá!” ");
INSERT INTO num_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Pea ne'e 'i ai foki mo he kau fafine ne'e notou mamata mai mei te mama'ó; ko te 'ihi 'iā nātou ko Mele mei Makitalá, mo Mele ko te fa'ē 'a Sēmisi Si'i mo Sioseé, pea mo Sālome, ");
INSERT INTO num_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","('ā ē ne'e notou mulimuli kiā Ia 'i Tana 'i Kālelí, 'o notou tauhi ki Ai,) pea mo he kau fafine tokolahi, 'a ia ne'e notou ō ake mo Ia ki Selusalema. ");
INSERT INTO num_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Pea 'i tana afiafi ifó leva, pea kote'uhí ko te Tokonaki ia, 'a ia ko te 'aho 'oku mu'amu'a 'i te Sāpaté, ");
INSERT INTO num_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ne'e fakato'ato'a 'ia Siosifa ko te 'Alemateá, ('a ia ko te 'aliki ne'e kau ki te Fakataha Fakamātu'á, pea ne'e nofo 'amanaki ki te Pule'anga 'o te 'Atuá,) pea ne ina hū kiā Pailato, 'o kole 'ia te sino 'o Sīsuú. ");
INSERT INTO num_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pea ne'e ofo 'ia Pailato 'i Tana pekia vavé, 'o ina ui ange 'ia te senitulioó, 'o fakafehu'i kiā ia pe kua fualoa Tana pekiá. ");
INSERT INTO num_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pea 'i tana 'ilo ki ai mei te senitulioó, ne ina foaki 'ia te 'anga'angá kiā Siosifa. ");
INSERT INTO num_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Pea hanga ia 'o fakatau he tupenu mahu'inga, 'o tuku ifo te sino 'o Sīsuú, 'o fakakoloa 'aki 'ia te tupenú, 'o telio 'Ona 'i te fanualoto, 'a ia kua 'osi foa'i 'i te maká, 'o fakateka 'e ia he maka ke songo 'aki 'ia te fanualotó. ");
INSERT INTO num_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Pea ko Mele mei Makitalá, mo Mele ko te fa'ē 'a Sioseé, ne'e nā mamata ki te feitu'u kua notou telio ai 'ia Sīsuú. ");
INSERT INTO num_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pea 'i te 'osi 'ia te Sāpaté, ne'e hanga 'e Mele mei Makitalá, mo Mele ko te fa'ē 'a Sēmisí, mo Sālome, 'o notou fakatau 'ia te 'ū ahi namu lelei, kote'uhí ke notou ō 'o tākai 'aki 'ia te sino 'o Sīsuú. ");
INSERT INTO num_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pea notou 'alu ki te fanualotó hengihengi 'aupito 'i te fu'aki 'aho 'o te uiké, fe'unga mo te hopo 'ia te la'aá. ");
INSERT INTO num_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Pea notou fepehē'aki, “Ko ai ia 'e fakateka ma'a tātou 'ia te maká mei te matapā 'o te fanualotó?” ");
INSERT INTO num_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pea 'i te notou hanga aké, tā kua teka'i atu 'ia te maká ia; he ne'e fu'u lahi. ");
INSERT INTO num_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pea 'i te notou uulu ki te fanualotó, ne'e notou mamata he talavou 'oku nofo 'i te 'āfaki mata'ú, 'oku kofu 'aki he kofu hinahina mo tōtōlofa; pea ne'e notou fu'u 'oho. ");
INSERT INTO num_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pea pehē ange 'e ia kiā nātou, “'Aua 'e kotou 'ilifia; ko te kotou kumi kiā Sīsū mei Nāsaleti ne'e kalusefaí; kua toetu'u Ia! 'Oku kailoa 'i heni Ia; vakai ko te feitu'u 'ē ne'e notou telio ai Iá. ");
INSERT INTO num_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kae kotou ō mu'a, 'o fakahā ki Tana kau akó, mo Pita, 'o pehē, ‘'Oku mu'amu'a Ia 'iā kōtou ki Kāleli; ko te feitu'u ko iá 'e kotou mamata ai kiā Ia, 'o hangē ko Tana tala'i atu kiā kōtoú.’ ” ");
INSERT INTO num_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Pea notou uulu ki tu'a, 'o hola mei te fanualotó, he ne'e notou tetetete mo tāfu'ua. Pea ne'e kailoa notou tala'i te me'á ki he taha; he ne'e notou fu'u manahē 'aupito. ");
INSERT INTO num_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Pea 'i Tana toetu'u 'i te hengihengi 'o te fu'aki 'aho 'o te uiké, ne'e fu'aki hā Ia kiā Mele mei Makitalá, 'ā ē ne'e kapusi mei ai 'ia te fanga tēvolo 'e toko fitú. ");
INSERT INTO num_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Pea 'alu 'ia te fafine ko iá, 'o tala kiā nātou kua kau mo Sīsuú, lolotonga te notou nonofo mamahi mo te tangí. ");
INSERT INTO num_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kā ko nātou, neongo te notou fanongo kua ma'uli Iá pea kua mātā 'Ona 'e te fafiné, ne'e kailoa he notou mama'i tui ki ai. ");
INSERT INTO num_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","'Osi ange ko iá ne Ina hā 'i te founga 'e taha ki te notou toko ua ne'e nā luelue, ko te nā fononga ki te tuku'utá. ");
INSERT INTO num_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pea ne nā foki, 'o fakahā 'ia te me'á ki tono toé; ka ne'e kailoa pē tui nātou ia ki ai. ");
INSERT INTO num_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pea hili ko iá, ne Ina hā ki te kau hongofulu mā tahá, lolotonga te notou kainangá, 'o valoki'i 'ia nātou 'i te notou ta'etuí mo ongongata'á, kote'uhí ko te kailoa notou tui kiā nātou ne'e mamata kiā Ia kua Ina toetu'ú. ");
INSERT INTO num_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Pea toki pehē ange 'e Ia kiā nātou, “Kotou ō ki māmani fuli pē, 'o malanga 'aki 'ia te ongoongoleleí ki te kakai kotoa pē. ");
INSERT INTO num_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ko ia pē 'e tui mo papitaisó 'e ma'uli; kā ko ia ko 'ē 'e kailoa tuí 'e mala'ia. ");
INSERT INTO num_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Pea 'e ō mo nātou 'oku tuí 'ia te 'ū faka'ilonga ko 'ení: 'e notou kapusi tēvolo 'i te hingoa 'O'okú; 'e notou lea 'aki 'ia te 'ū lea fo'ou; ");
INSERT INTO num_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","'e notou puke ake 'ia te fanga ngata; pea kāpau 'e notou inu he me'a 'oku kona, 'e kailoa 'aupito kovi ia kiā nātou; 'e notou hilifaki nima ki te mahakí, pea 'e notou mā'u'uli.” ");
INSERT INTO num_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pea 'i te 'osi ange te folafola 'a te 'Alikí kiā nātoú, ne'e 'avake Ia ki te langí, 'o 'afio mei te to'omata'u 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pea ko nātou, ne'e notou 'alu atu 'o malanga holo; pea ne'e ngāue fakataha mo nātou 'e te 'Alikí, 'o poupou 'ia te Folafolá 'aki 'ia te 'ū faka'ilonga ne'e hokó.");
INSERT INTO num_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","'E Tiofilusi, ko te me'a 'i te hanga 'e te tokolahi, 'o fa'u tono fakamatala 'o te 'ū me'a 'oku mātu'aki tui ki ai 'ia tātoú, ");
INSERT INTO num_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","'o fakatatau ki tono tala'i mai 'e nātou ne'e notou sio tonu ki ai mei tono kamatá, 'o hoko ko te kau ngāue 'o te Folafolá, ");
INSERT INTO num_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","kua u fakakaukau mo au foki, tangata'aliki, ke tohi hokohoko ia, ma'au, he kua u fakatotolo'i mai kotoa pē ke mahu'inga mālie, ");
INSERT INTO num_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","kote'uhí ke ke 'ilo'i lelei tono mo'oni 'o te 'ū fakamatalá, 'a ia ne'e akonakina 'aki 'oú. ");
INSERT INTO num_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","'I te kuonga 'o Hēlota, ko te tu'i Siuteá, ne'e 'i ai he taula'aliki ne'e hingoa ko Sākalaia, 'a ia ne'e kau ki te lakanga 'o 'Āpaiá; pea ne'e 'i ai tono mali, 'a ia ne'e 'i te hako totonu 'o 'Ēloné, pea ko tono hingoá ko 'Ilisapesi. ");
INSERT INTO num_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Pea ko te ongo me'a ne'e sai 'aupito te nā fakafeangai ki te 'Atuá, pea nā lalaka 'i te 'ū fekau mo te tu'utu'uni kotoa pē 'a te 'Alikí mo te haohaoa. ");
INSERT INTO num_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pea ne'e kailoa 'i ai he nā tama, kote'uhí ne'e pa'a 'ia 'Ilisapesi; pea kua nā mātutu'a fakatou'osi pē. ");
INSERT INTO num_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Pea ko te 'aho 'e taha ne ina fai ai tana ngāue fakataula'aliki ki te 'Atuá 'i te hokohoko tono lakangá; ");
INSERT INTO num_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","pea 'i te talotaló, 'o fakatatau ki te anga 'o te ngāue fakataula'alikí, ne'e tō kiā ia 'ia te tutu 'o te 'inisēnisí 'i tana hū ki te Fale Tapu 'o te 'Alikí. ");
INSERT INTO num_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pea ne'e lotu 'i tu'a 'ia te fakatahá kotoa pē, 'i te hokosia te taimi 'o te tutu 'inisēnisí. ");
INSERT INTO num_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Pea ne'e hā kiā ia he 'āngelo 'a te 'Alikí, 'o tu'u 'i te 'āfaki mata'u 'o te 'ōlita tutu'anga 'inisēnisí. ");
INSERT INTO num_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pea 'i te sio ki ai 'ia Sākalaiá, ne'e 'ilifia lahi ia mo puputu'u. ");
INSERT INTO num_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ka ne'e lea kiā ia 'ia te 'āngeló 'o pehē, “'E Sākalaia, 'aua 'e ke manahē; he kua tau ake tau huú, pea ko tou hoa ko 'Ilisapesí, 'e fanau'i ia he tama kiā koe, pea 'e ke fakahingoa 'ona ko Sione. ");
INSERT INTO num_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Pea 'e ke fiafia ai mo nēkaneka: 'io, 'e fiafia he tokolahi 'i tono fanau'i maí. ");
INSERT INTO num_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","He 'e hoko ia ko te lahi 'i te vakai 'a te 'Alikí; pea 'e kailoa 'aupito inu 'e ia he uaine pē he kava mālohi; pea 'e fonu ia 'i te Laumālie Mā'oni'oní, 'o kamata pē mei te manava 'o tana fa'eé. ");
INSERT INTO num_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Pea 'e fakatafoki 'e ia he tokolahi 'o te kakai 'Isilelí ki te 'Alikí ko te notou 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Pea 'e mu'amu'a atu ia ki te 'Alikí 'i te anga mo te mālohi 'o 'Ilaisiaá, kote'uhí ke liliu 'ia te loto 'o te mātu'á ke tokanga ki te notou fānaú, pea mo te kau talangata'á ke notou ma'u te anga-fakapotopoto 'o te kau anga-tonú, pea ke teu'i ma'a te 'Alikí he kakai lelei.” ");
INSERT INTO num_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Pea ne'e iange 'e Sākalaia ki te 'āngeló, “'E au 'ilo'i fefe'aki 'ia te me'a nei? He ko aú ko te matu'a, pea ko toku malí ko te fafine fualoa 'aupito.” ");
INSERT INTO num_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Pea iange 'e te 'āngeló kiā ia, “Ko au Kepaleli, pea 'okou fakafe'ao ki te 'Atuá; pea kua fekau'i 'oku ke lea kiā koe, pea ke 'avatu kiā koe 'ia te ongoongo lelei ko 'ení. ");
INSERT INTO num_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pea vakai, 'e ke noa, 'o kailoa ke fa'a lea, 'o a'u ki te 'aho 'e hoko ai 'ia te 'ū me'a nei, kote'uhí ne'e kailoa ke tui ki taku 'ū talá, kā ko te 'ū me'a ia 'e hoko mo'oni 'o kā a'u ki tono taimí.” ");
INSERT INTO num_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Pea ne'e ma'u talia pē 'ia te kakaí kiā Sākalaia, 'o notou fifili lahi ki tana fualoa 'i te Fale Tapú. ");
INSERT INTO num_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pea 'i tana hū maí, ne'e kailoa lava ia ke lea kiā nātou; pea notou toki 'ilo'i ai, tā ne'e mamata ia he vīsone 'i te Fale Tapú. Pea ne'e kamokamo pē ia kiā nātou, mo fakalongolongo. ");
INSERT INTO num_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pea 'i te 'osi ange te 'ū 'aho 'o tana feia 'ia te ngāue tapú, ne'e foki mai ia ki 'api. ");
INSERT INTO num_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pea 'i te 'osi ange te 'ū 'aho ko iá, ne'e tu'itu'ina 'ia 'Ilisapesi ko tono malí, pea nofo pē ia 'i te liló 'o nima māhina, 'i tana pehē, ");
INSERT INTO num_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Kote'uhiā kua pehē fau te ngāue 'a te 'Alikí ma'akú, 'i Tana āfeitaulalo mai, 'o to'o ange toku mā'anga ki te kakaí.” ");
INSERT INTO num_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Pea 'i tono ono māhiná, ne'e fekau mei te 'Atuá 'ia te 'āngelo ko Kepalelí ki te kolo 'o Kāleli ne'e hingoa ko Nāsaleti, ");
INSERT INTO num_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ke 'alu ki te tāupo'ou ne'e polo'i ki te tangata 'i te hako 'o Tēvitá, ne'e hingoa ko Siosifa; pea ko te hingoa 'o te ta'ahiné ko Mele. ");
INSERT INTO num_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Pea 'i tana a'u atu kiā iá ne'e pehē ange 'e ia, “Mālō te lelei, 'ia koe kua 'ofainá; 'oku 'iā koe 'ia te 'Alikí!” ");
INSERT INTO num_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pea ma'utāfu'ua ia 'i te lea ko 'ení, 'o fifili pe ko te ā tono 'uhinga 'o te fetapa nei. ");
INSERT INTO num_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Pea tē iange 'e te 'āngeló, “'E Mele, 'aua 'e ke manahē; he kua 'ofaina 'ou mei te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Pea ko 'eni, 'e ke tu'itu'ina, pea 'e ke 'alo'i he tama, pea 'e ke fakahuafa 'Ona ko Sīsū. ");
INSERT INTO num_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Pea 'e lahi Ia; pea 'e lau Ia ko te 'Alo 'o te 'Aliki Taupotú; pea 'e foaki kiā Ia 'e te 'Aliki ko te 'Atuá 'ia te taloni 'o Tana kui ko Tēvitá; ");
INSERT INTO num_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","pea 'e tu'i Ia ki te hako 'o Sēkopé 'o lauikuonga; pea ko Tana pulé 'e kailoa ngata.” ");
INSERT INTO num_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Pea iange 'e Mele ki te 'āngeló, “'E hoko fefe'aki ia? He 'oku he'iki ai ke au 'iloa he tangata.” ");
INSERT INTO num_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Pea iange 'e te 'āngeló kiā ia, 'o pehē, “'E hoko mai 'ia te Laumālie Mā'oni'oní kiā koe, pea 'e fakamalumalu 'ou 'e te māfimafi 'o te 'Aliki Taupotú; pea ko ia ai 'e ui te hako tapu 'e ke fā'ele'í, ko te 'Alo 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Pea vakai, ko 'Ilisapesi ko tou kāingá, kua tu'itu'ina mo ia he tama, kā kua matu'a; pea ko tono ono māhina 'eni 'o ia ne'e lau ko te pa'á. ");
INSERT INTO num_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","He 'oku kailoa he me'a ia 'e faingata'a ki te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Pea iange 'e Mele, “Ko au 'eni, ko te kaunanga 'a te 'Alikí; ke hoko mai kiā kita 'o hangē ko tau me'á.” Pea 'alu leva 'ia te 'āngeló meiā ia. ");
INSERT INTO num_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pea tu'u ake 'ia Mele, 'i te 'ū 'aho ko iá, 'o 'alu fakavave ki te fanua ma'ungá, ki te kolo 'o Siutea; ");
INSERT INTO num_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","'o hū ki te fale 'o Sākalaiá, 'o fetapa kiā 'Ilisapesi. ");
INSERT INTO num_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pea 'i te fanongo 'e 'Ilisapesi ki te fetapa 'a Melé, ne'e futefute 'ia te tama 'i tono manavá. Pea fonu 'ia 'Ilisapesi 'i te Laumālie Mā'oni'oní, ");
INSERT INTO num_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","'o kalanga le'o lahi, “'Oku manū'ia 'ia koe 'i te fafine kotoa pē! Pea 'oku manū'ia mo te fua 'o tou manavá! ");
INSERT INTO num_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ko te ā kua 'a'ahi mai ai kiā au, 'ia koe, ko te fa'ē 'o toku 'Alikí! ");
INSERT INTO num_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","He vakai ange, 'i te ongo mai leva tau fetapá ki toku talingá, pea toki futefute te tama 'i toku manavá. ");
INSERT INTO num_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Pea manū'ia ā kā ko ia ne'e tuitalá! Kote'uhí 'e fakamo'oni'i te 'ū me'a ne'e fakahā mei te 'Alikí kiā iá.” ");
INSERT INTO num_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Pea lea 'ia Mele 'o pehē, “'Oku fakahīkihiki'i 'ia te 'Alikí 'e toku laumālié. ");
INSERT INTO num_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Pea fiafia toku laumālié 'i te 'Atuá ko toku Fakama'uli. ");
INSERT INTO num_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","He kua āfeitaulalo mai Ia kiā kita me'avale ko Tana kaunanga. He vakai mai, ko te 'aho neí 'e kamata ke lau 'oku ko te manū'ia 'e te 'ū to'utangatá. ");
INSERT INTO num_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","He kua fai ma'aku 'e te Māfimafí he 'ū me'a lalahi; pea 'oku mā'oni'oni Tono huafá. ");
INSERT INTO num_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pea ko Tana meesí 'oku laui to'utangata kiā nātou 'oku 'apasia kiā Iá. ");
INSERT INTO num_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kua fai kaukaua 'aki Tono nimá; kua veteki Ia 'ia te ha'a 'afungí 'i te laukau te notou lotó. ");
INSERT INTO num_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kua Ina hifo 'ia te kau pulé mei te notou taloní, pea ko te mā'ulaló ne Ina hākeaki'i. ");
INSERT INTO num_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kua 'avange me'a lelei 'e Ia ki te fiakaiá 'o notou mākokona, pea ko te ma'u me'á kua Ina tuku ke 'alu pakupaku. ");
INSERT INTO num_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kua Ina taukapo'i 'ia 'Isileli, ko Tana tamaio'alikí, ke fakamanatua ma'u Tana 'ū meesí; ");
INSERT INTO num_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","hangē ko Tana folafola ki te tou mātu'á 'i mu'a, 'e fai kiā 'Ēpalahame mo tono hakó, 'o ta'engata.” ");
INSERT INTO num_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Pea ne'e nofo 'ia Mele mo ia, 'o fe'unga nai mo te māhina 'e tolu, pea toki foki ki tono 'apí. ");
INSERT INTO num_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Pea 'i te kakato 'ia te 'ū māhina 'o 'Ilisapesí, ne'e fā'ele'i ia he tama. ");
INSERT INTO num_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pea 'i te fanongo 'e te kakai 'o te feitu'u ko iá, mo tono kāingá, kua fakae'a 'e te 'Alikí Tana meesí 'i te fafine nei, ne'e notou fiafia fakataha mo ia. ");
INSERT INTO num_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pea 'i te faifaí pea hoko tono 'aho valú, ne'e notou ōmai ke kamu 'ia te tamasi'í; pea notou pehē ke fakahingoa 'ona ki tana tamaí ko Sākalaia. ");
INSERT INTO num_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ka ne'e tali ange ta'aná fa'ē 'o pehē, “'Aua, kā 'e hingoa ia ko Sione.” ");
INSERT INTO num_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Pea notou iange kiā ia, “'Oku kailoa he taha 'i tou kāingá 'oku hingoa pehē.” ");
INSERT INTO num_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Pea notou kamo ange leva ki tana tamaí, pe 'oku loto ke fakahingoa te tamasi'í ko ai. ");
INSERT INTO num_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Pea kole ange 'e ia ke 'aumai he maka tohi, 'o tohi 'e ia 'i ai 'o pehē, “Ko tono hingoá ko Sione.” Pea notou ofo kotoa pē 'i ai. ");
INSERT INTO num_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pea ne'e faka'atā leva tono ngutú mo tono 'aleló; 'o kamata lea mo fakamālō ki te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Pea ne'e tō he 'ilifia lahi ki te kakai kotoa pē 'i te notou kaungā'apí; pea 'i te fanua ma'unga kotoa pē 'o Siuteá ne'e lahi tono talanoa'i ai 'o te 'ū me'a nei. ");
INSERT INTO num_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Pea ko nātou kotoa pē ne'e fanongo ki aí, ne'e notou fifili 'i te notou lotó, 'o pehē, “'E fefe'aki nai te anga 'o te tamasi'i nei?” Pea ne'e kau mo ia 'ia te māfimafi 'o te 'Alikí. ");
INSERT INTO num_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Pea ne'e fonu tana tamaí ko Sākalaia 'i te Laumālie Mā'oni'oní, pea ne'e palōfisai ia 'o pehē: ");
INSERT INTO num_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Fakafeta'i ki te 'Alikí, ko te 'Atua 'o 'Isilelí! He kua 'a'ahi mai Ia, mo huhu'i Tono kakaí. ");
INSERT INTO num_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Pea kua fokotu'u 'e Ia he mālohi 'o te fakama'ulí kiā tātou, 'i te hako 'o Tēvita ko Tana tamaio'alikí, ");
INSERT INTO num_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","'o hangē ā ko Tana folafola 'i te ngutu 'o Tana kau palōfita tapú talu mei mu'a: ");
INSERT INTO num_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ko te fakahaofi mei te tou 'ū filí, mo te nima 'o te kakai 'oku fihi'a maí; ");
INSERT INTO num_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ke fakaai Tana meesi ki te tou mātu'á 'i mu'a, mo te manatu ki Tana fuakava mā'oni'oní, ");
INSERT INTO num_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","'ia te fuakava ne'e fuakava 'aki 'e Ia ki te tou tamai ko 'Ēpalahamé, ");
INSERT INTO num_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ke tuku mai 'e Ia kiā tātou, ke tou fai ta'emanahē te tou ngāue ki te 'Alikí, he kua hamusi tātou mei te tou 'ū filí, ");
INSERT INTO num_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","'o tou fakafeangai kiā Ia 'aki te mā'oni'oni mo te failelei 'i te 'ū 'aho kotoa pē 'o te tou ma'ulí. ");
INSERT INTO num_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Pea ko koe, tamasi'i, 'e lau ko te palōfita 'o te 'Aliki Taupotú, he 'e ke fakamelomelo kiā Ia ke teuteu'i Tono 'ū alá, ");
INSERT INTO num_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ke 'avatu 'ia te tala 'o te fakama'ulí ki te kakai 'A'aná, ko te fakamolemole te notou 'ū angahalá, ");
INSERT INTO num_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ko te me'a 'i te 'alo'ofa 'a te tou 'Atuá, 'a ia ne'e 'a'ahi mei ai 'ia te pongipongí mei lunga, ");
INSERT INTO num_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ke hulu 'aki 'ia te nofo 'i te pō'ulí mo te malu 'o Maté, mo tataki te tou va'é ki te ala 'o te fiamālié.” ");
INSERT INTO num_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Pea ne'e tupu ake 'ia te tamá, 'o ina faka'a'au ke mālohi fakalaumālie; pea ne ina 'i te toafá 'o a'u ki te 'aho ne'e fakahaa'i ai 'ona ki 'Isilelí. ");
INSERT INTO num_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Pea 'i te kuonga ko iá, ne'e 'alu atu he fekau meiā Sisa 'Akositō, ke tohi kakai 'ia māmani kotoa pē. ");
INSERT INTO num_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Pea ne'e fu'aki fai 'ia te tohi kakai ko iá, 'i te lolotonga te kōvana 'i Sīlia 'ia Sailinió. ");
INSERT INTO num_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Pea ne'e ō atu 'ia te kakai kotoa pē, taki taha ki tono kolo 'o'oná ke notou tohi ai. ");
INSERT INTO num_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Pea fononga ake mo Siosifa foki mei te kolo ko Nāsaletí 'i Kāleli, ko tana 'alu ki Siutea, ki te kolo 'o Tēvitá, 'a ia 'oku hingoa ko Pētelihema (he ne'e kau ia ki te hako mo te fa'ahinga 'o Tēvitá); ");
INSERT INTO num_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ke nā tohi ai mo Mele, ko te fafine kua polo'i kiā ia, 'a ia ne'e faitamá. ");
INSERT INTO num_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pea 'i te lolotonga te nā 'i aí, ne'e kakato tono māhiná ke fā'ele. ");
INSERT INTO num_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Pea ne'e 'alo'i leva 'ia te tamá, ko tono 'uluakí Ia, pea fakakofu 'aki 'Ona 'ia te kofu 'o te tamasi'i valevale, mo fakatakoto 'i te 'ai'angakai 'o te monumanú; kote'uhí ne'e kala nā hao 'i te fale tali fonongá. ");
INSERT INTO num_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Pea ne'e 'i ai 'i te fanua ko iá he kau tauhi sipi ne'e notou momoe 'i te vaó, ko te le'ohi te notou fanga sipí 'i te pō'ulí. ");
INSERT INTO num_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Pea fokifā pē kua tu'u mai kiā nātou he 'āngelo 'a te 'Alikí, pea malama mai te Sikaina 'o te 'Alikí 'o huhulu 'ia nātou; pea ne'e notou manahē 'aupito. ");
INSERT INTO num_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pea iange 'e te 'āngeló kiā nātou, “'Aua na'a manahē; he ko 'eni kua u ha'u mo au he talanoa mālie, ko te me'a fakafiafia 'aupito, ko te me'a ia ma'a te kakai 'Isilelí kotoa pē. ");
INSERT INTO num_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","He ne'e 'alo'i kiā kōtou 'anenai 'i te kolo 'o Tēvitá he Fakama'uli, 'a ia ko Kalaisi ko te 'Alikí. ");
INSERT INTO num_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Pea ko tono faka'ilongá 'eni kiā kōtou: 'e kotou 'ilo'i he tamasi'i valevale, kua kofu fakatamasi'i valevale, pea 'oku takoto Ia 'i te 'ai'angakai 'o te monumanú.” ");
INSERT INTO num_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Pea fokifā pē ne'e 'i te 'āngeló he tokolahi 'o te hōsitē 'o langí, 'oku notou fakamālō ki te 'Atuá, mo notou pehē: ");
INSERT INTO num_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ko te kolōliá ki te 'Atuá 'i langi taupotu, pea ko te melinó ki māmani ki te kakai kua hōifua ki ai.” ");
INSERT INTO num_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pea 'i te 'alu leva meiā nātou 'ia te kau 'āngeló ki te langí, ne'e fepehē'aki 'e te kau tauhi sipí, “Tou ō mu'a ki Pētelihema, 'o vakai angé 'ia te me'a nei kua fakahā mai 'e te 'Alikí kiā tātoú.” ");
INSERT INTO num_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Pea notou ō fakavave leva, 'o 'ilo'i 'ia Mele mo Siosifa fakatou'osi, pea mo te Tamasi'i valevalé 'oku takoto 'i te 'ai'angakaí. ");
INSERT INTO num_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pea 'i te notou mamata ki Aí, ne'e notou hanga leva 'o fakamatala'i 'ia te me'a ne'e fakahaa'i ange kiā nātoú, 'o kau ki te Tamasi'i nei. ");
INSERT INTO num_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Pea ko nātou ne'e notou fanongo ki aí, ne'e notou ofo kotoa pē 'i te 'ū me'a ne lea 'aki 'e te kau tauhi sipí kiā nātoú. ");
INSERT INTO num_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ka ne'e kumuni kotoa pē 'e Mele 'ia te 'ū me'a ko 'ení, 'o fifili ki ai 'i tono lotó. ");
INSERT INTO num_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pea foki atu 'ia te kau tauhi sipí, mo notou fakafeta'i mo fakamālō ki te 'Atuá; kote'uhí ko te 'ū me'a kotoa pē ne'e notou fanongo mo mamata ki aí, 'oku tatau tofu pē mo te me'a 'ā ē ne'e tala'i maí. ");
INSERT INTO num_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pea 'i te kakato Tono 'aho valú ke kamu ai Iá, pea ne'e fakahingoa 'Ona ko Sīsū; 'a ia ko tono fakahingoa mei te 'āngeló 'i te he'iki ai tu'itu'ina Ia 'i te manavá. ");
INSERT INTO num_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Pea 'i te hokosia te 'aho ke fakama'a ai 'ia nāua, 'o fakatatau ki te lao 'a Mōsesé, ne nā 'ave leva 'Ona ki Selusalema ke 'avatu ki te 'Alikí, ");
INSERT INTO num_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","('o hangē ko ia kua tohi 'i te Lao 'a te 'Alikí, “Ko te tamasi'i kotoa pē, ko he olopo'ou, 'e lau 'ona ko te tapu ki te 'Alikí,”) ");
INSERT INTO num_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","pea kote'uhí foki ke nā fai 'ia te feilaulaú, 'o fakatatau mo ia 'oku hā 'i te Lao 'a te 'Alikí, “ko te ongo fe'i kulukulu, pē ko he fe'i lupe mui 'e ua.” ");
INSERT INTO num_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Pea vakai, ne'e nofo 'i Selusalema he tangata ne'e hingoa ko Simione; pea ko te tangata anga-tonu ia mo lotu mo'oni, 'i tana nofo 'amanaki ki te taukapo'i 'o 'Isilelí; pea ne'e 'iā ia 'ia te Laumālie Mā'oni'oní. ");
INSERT INTO num_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Pea ne'e fakahaa'i kiā ia 'e te Laumālie Mā'oni'oní, 'e kailoa ina mamata ki te maté kae'aua ke mamata ki te Kalaisi 'a te 'Alikí. ");
INSERT INTO num_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Pea kua 'alu ia ki te Temipalé kua Laumālie'ina, mo tono 'avange 'ia te tamasi'i ko Sīsuú 'e Tana mātu'á ke fai kiā Ia 'o fakatatau ki te tu'utu'uni 'a te Laó. ");
INSERT INTO num_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Pea ma'u 'e ia 'ia te tamá 'o hapai ake, mo fakamālō'ina 'ia te 'Atuá, 'o pehē, ");
INSERT INTO num_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“'E 'Aliki, tā ko Tau toki tukuange 'eni Tau pōpulá ke 'alu kua fiamālie, 'o hangē ko Tau folafolá. ");
INSERT INTO num_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","He kua mamata toku matá ki Tou fakama'ulí, ");
INSERT INTO num_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","'a ia ne Ke teuteu'i ke hā ki te kakai kotoa pē; ");
INSERT INTO num_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ko te maama ke tatala 'aki te fakapō'uli 'o te Senitailé, pea ko te lāngilangi'anga 'o Tou kakai 'Isilelí.” ");
INSERT INTO num_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Pea ne'e fu'u ofo 'aupito Tana tamaí mo Tana fa'eé 'i te 'ū me'a ne'e lea 'aki 'o kau ki te Tamá. ");
INSERT INTO num_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Pea ne'e tāpuaki'i nāua 'e Simione, 'o iange ia kiā Mele ko Tana fa'eé, “Vakai, ko te nafa 'o te Toko Taha nei ko te tūkia'anga mo te toetu'u'anga 'o he tokolahi 'i 'Isileli, pea ko te faka'ilonga kā leakovi'i, ");
INSERT INTO num_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","('io, na'a mo koe 'e ulu he heletā 'i tou lotó,) kote'uhí ke toki hā mai ai 'ia te fakakaukau 'i te loto 'o te tokolahi.” ");
INSERT INTO num_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Pea ne'e 'i ai he fafine palōfita ko 'Ana, 'a ia ko te 'ofafine 'o Fanueli, 'i te ha'a 'Āselí. Pea ko te fafine 'eni ne'e fualoa 'aupito: pea ne'e ma'u husepāniti ia 'i tana finamulí, 'o nā nonofo 'o fitu ta'u; ");
INSERT INTO num_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","pea kua nofo uitou ia 'o valungofulu mā fā ta'u. Pea ne'e kailoa mahu'i ia mei te Temipalé, ka ne'e tauhi ia ki te 'Atuá 'aki te 'aukai mo te lotu 'i te pō mo te 'aho. ");
INSERT INTO num_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Pea ne'e tu'u mai mo ia 'i te taimi pē ko iá, 'o fakafeta'i ki te 'Atuá; pea lea ia 'i te Tamá kiā nātou kotoa pē 'i Selusalema ne'e notou nofo 'amanaki ki te huhu'í. ");
INSERT INTO num_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Pea kua 'osi te nā fakakakato 'ia te 'ū me'a nei kotoa pē, 'o fakatatau ki te Lao 'a te 'Alikí, pea ne'e notou foki leva ki Kāleli ki te notou koló ko Nāsaleti. ");
INSERT INTO num_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Pea ne'e tupu ake 'ia te tamasi'í, 'o faka'a'au Ia ke mālohi, 'i tono fakafonu Ia 'aki te potó; pea ne'e nofo kiā Ia 'ia te 'ofa 'a te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Pea ne'e ō Tana ongo mātu'á 'i te ta'u kotoa pē ki Selusalema, ki te kātoanga 'o te Pāsová. ");
INSERT INTO num_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Pea 'i te hoko Tono hongofulu mā ua ta'ú, ne'e notou fononga ake, 'o hangē ko te notou fa'a fai 'i te kātoangá. ");
INSERT INTO num_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pea kua faka'osi tono 'ū 'ahó, 'o notou kamata foki atu, ka ne'e nofo pē te tamasi'i ia ko Sīsuú 'i Selusalema; pea ne'e kailoa 'ilo ki ai Tana ongo mātu'á. ");
INSERT INTO num_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Pea 'i te nā mahalo 'oku 'i te kaungā fonongá pē Iá, ne nā hanga ō pē, kae'aua ke 'osi mai te vā'ihala 'o te 'aho ko iá; pea nā toki kumi 'Ona ki te notou kāingá mo te notou kau fe'iloakí. ");
INSERT INTO num_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pea 'i te kailoa nā 'ilo'i Iá, ne nā tē foki ki Selusalema ko te kumi kiā Ia. ");
INSERT INTO num_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pea 'i te 'osi angé, hili te 'aho 'e tolu, ne nā toki 'ilo'i 'Ona ki te Temipalé, 'oku lotolōtoi Ia 'i te kau akonakí, 'o fakafanongo mo fakafehu'i foki kiā nātou. ");
INSERT INTO num_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Pea ko nātou kotoa pē ne'e notou fanongo kiā Iá, ne'e notou fakatumutumu 'i te anga 'o Tana fakakaukaú mo Tana 'ū talí. ");
INSERT INTO num_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Pea 'i te nā mamata ki aí, ne'e to'oa te nā lotó; pea lea kiā Ia Tana fa'eé, “Tama, ko te ā kua ke fai pehē mai ai kiā māuá? He ko 'eni, ko Tau tamaí mo au kua mā fiu'a kumi 'Ou mo te loto hoha'a lahi!” ");
INSERT INTO num_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Pea iange 'e Ia kiā nāua, “He ne'e kulā kumi 'Okú ko te ā? Ne kailoa koā kulā 'ilo'i kua pau ke Au 'i te ngāue 'o Taku Tamaí?” ");
INSERT INTO num_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pea ne'e kailoa nā lave'i tono 'uhinga 'o Tana lea ko 'eni kiā nāuá. ");
INSERT INTO num_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pea toki foki Ia mo nāua, 'o a'u ki Nāsaleti; pea ne'e anganofo Ia kiā nāua. Pea ne'e kumuni 'e Tana fa'eé 'ia te 'ū me'a kotoa pē ko 'ení 'i tono lotó. ");
INSERT INTO num_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Pea ne'e lalaka atu 'ia Sīsū 'i te potó, mo te lahi Tono sinó, pea mo Tono 'ofaina 'e te 'Atuá mo te tangatá. ");
INSERT INTO num_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Pea 'i tono hongofulu mā nima ta'u 'o te pule 'a Taipiliō ko te Sisá, pea 'i te lolotonga te kōvana 'ia Ponitō Pailato 'i Siuteá, pea tu'i 'ia Hēlota 'i Kālelí, mo tono tehina ko Filipé 'i 'Aitulia mo te feitu'u ko Telakonaitisí, pea tu'i 'ia Lisaniasi 'i 'Apiliné, ");
INSERT INTO num_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","pea Taula'aliki Lahi 'ia 'Ānasi mo Kaiafasí, ne'e hoko ai 'ia te folafola 'a te 'Atuá kiā Sione ko te foha 'o Sākalaiá 'i te toafá. ");
INSERT INTO num_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Pea 'alu atu ia ki te feitu'u kotoa pē 'o Sioataní, 'o malanga 'aki te papitaiso 'o te fakatomalá ki te fakamolemole 'o te angahalá. ");
INSERT INTO num_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","'O hangē ko ia kua tohi 'i te tohi 'o te 'ū lea 'a 'Aisea ko te palōfitá: “Ko te le'o 'o he toko taha 'oku kalanga 'i te toafá, ‘Kotou teuteu 'ia te hā'ele'anga 'o te 'Alikí; fakatonutonu Tono 'ū alá. ");
INSERT INTO num_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ko te tele'a kotoa pē 'e tanu, pea ko te ma'unga mo te tafungafunga kotoa pē 'e holoki; pea 'e ngaahi te pikopikó ke hangatonu, mo te tokatāmakí ke tokamālie. ");
INSERT INTO num_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Pea 'e mamata 'e te kakano kotoa pē ki te fakama'uli'anga 'a te 'Atuá.’ ” ");
INSERT INTO num_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Pea toki lea 'e ia ki te fu'u kakai ne'e notou fononga mai ke papitaiso 'iā iá, 'o pehē, “'Ia te hako'i ngata fekai, ko ai ia ne'e fale'i kōtou ke kotou hola mei te houhau kua mei a'u maí? ");
INSERT INTO num_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kāpau ko ia, pe'i kotou fua 'o taau mo he kau fakatomala; pea 'aua na'a kotou lau 'i te kotou lotó, 'o pehē takua, ‘Ko 'Ēpalahame 'ia te motou tamaí.’ He 'okou tala'i atu, 'oku mafai 'e te 'Atuá ia ke fokotu'u mei te 'ū maka neí he fānau kiā 'Ēpalahame. ");
INSERT INTO num_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Pea 'oku lolotonga tu'u 'eni te tokí 'i te tafito 'o te 'ū 'akaú; ko ia ai, kā 'i ai he fu'u 'akau 'oku kailoa fua lelei 'oku tā ia 'o laku ki te afí.” ");
INSERT INTO num_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Pea fa'a fehu'i kiā ia 'e te fu'u kakaí, 'o notou iange, “Pea ko te ā leva te motou me'a 'e faí?” ");
INSERT INTO num_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Pea iange 'e ia kiā nātou, 'o pehē, “Kā 'i ai he taha 'oku ua tono soté, ke nā taki taha mo ia 'oku halá; pea ko ia 'oku ma'u he me'akaí, ke fai pehē mo ia foki.” ");
INSERT INTO num_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pea ha'u foki he kau tānaki tukuhau ke papitaiso, 'o notou 'eke ange kiā ia, “Tangata'aliki, ko te ā 'a mātou 'e motou faí?” ");
INSERT INTO num_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Pea iange 'e ia, “'Aua na'a kotou 'eke 'o lahi ange 'i te me'a kua tu'utu'uni kiā kōtoú.” ");
INSERT INTO num_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Pea fehu'i ange kiā ia foki 'e te kau taú, “Ko te ā 'e motou fai 'e mātoú foki?” Pea iange 'e ia, “'Aua na'a kotou fakamālohi'i he taha; pea 'aua na'a lohiaki'i; pea kotou fiamālie pē 'i te totongi 'oku 'avatú.” ");
INSERT INTO num_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pea 'i te fakakaukau 'e te kakaí, mo notou fifili kotoa pē 'i te notou lotó kiā Sione, na'a ko te Kalaisí iá, ");
INSERT INTO num_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ne'e toe lea 'e Sione kiā nātou kotoa pē, 'o pehē, “Ko au 'okou papitaiso kōtou 'aki te vai; kā 'oku ha'u he Toko Taha 'oku mālohi ange 'iā au, ko te Toko Taha ko iá 'oku kailoa kita taau ke vete te nono'o 'o Tono senitoló; he 'e papitaiso 'e Ia 'ia kōtou 'aki te Laumālie Mā'oni'oní mo te afi. ");
INSERT INTO num_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ko te Toko Taha ia 'oku 'i Tono nimá 'ia te huo sivi uite, pea 'e Ina sivi 'aki ke ma'a Tono haha'angá; pea 'e Ina tānaki 'ia te 'ū fe'i uité ki Tono faleokó; kā 'e Ina tutu 'ia te kafukafú 'aki te afi 'oku kailoa lava to'onó tāmate'i.” ");
INSERT INTO num_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ne'e lahi mo te 'ū tala mālie kehe, ne ina fai 'aki tana tokoni ki te kakaí. ");
INSERT INTO num_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ka ne'e valoki'i 'e ia 'ia Hēlota ko te tu'í, kote'uhí ko Helotiasi ko te mali 'o tono tehiná, pea kote'uhí ko te 'ū kovi kehekehe ne'e fai 'e Hēlotá; ");
INSERT INTO num_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","pea ne ina fakalahi 'aki 'eni kotoa pē, 'aki tana fakahū 'ia Sione ki te pilīsoné. ");
INSERT INTO num_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pea 'i te 'osi tono papitaiso 'o te kakai kotoa pē, pea kua papitaiso mo Sīsū foki, pea 'i te fai 'e Ia Tana huú, ne'e matangaki 'ia te langí, ");
INSERT INTO num_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","pea 'alu ifo kiā Ia 'ia te Laumālie Mā'oni'oní, 'i te sino ne'e tatau mo he fe'i lupe; pea ne'e 'i ai he le'o mei te langí ne'e pehē mai, “Ko Toku 'Alo Pelé 'ia Koe, ko Koe 'Okou hōifua ki aí.” ");
INSERT INTO num_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Pea ne'e tolungofulu ta'u nai 'ia Sīsū 'i Tana kamata ngāué; pea ne'e lau Ia ko te foha 'o Siosifa, 'a ia ko te foha 'o Hēlai, ");
INSERT INTO num_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","'a ia ko te foha 'o Mātati, 'a ia ko te foha 'o Līvai, 'a ia ko te foha 'o Melikai, 'a ia ko te foha 'o Sianai, 'a ia ko te foha 'o Siosifa, ");
INSERT INTO num_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","'a ia ko te foha 'o Matataiasi, 'a ia ko te foha 'o 'Ēmosi, 'a ia ko te foha 'o Nēhumi, 'a ia ko te foha 'o 'Esilai, 'a ia ko te foha 'o Nākai, ");
INSERT INTO num_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","'a ia ko te foha 'o Mā'ati, 'a ia ko te foha 'o Matataiasi, 'a ia ko te foha 'o Semaini, 'a ia ko te foha 'o Sioseki, 'a ia ko te foha 'o Siota, ");
INSERT INTO num_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","'a ia ko te foha 'o Sioanani, 'a ia ko te foha 'o Lesa, 'a ia ko te foha 'o Seluipepeli, 'a ia ko te foha 'o Saletili, 'a ia ko te foha 'o Nēlai, ");
INSERT INTO num_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","'a ia ko te foha 'o Melikai, 'a ia ko te foha 'o 'Ātai, 'a ia ko te foha 'o Kōsame, 'a ia ko te foha 'o 'Ēlimatami, 'a ia ko te foha 'o 'Ea, ");
INSERT INTO num_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","'a ia ko te foha 'o Sīsū, 'a ia ko te foha 'o 'Eliesa, 'a ia ko te foha 'o Siolimi, 'a ia ko te foha 'o Mātati, 'a ia ko te foha 'o Līvai, ");
INSERT INTO num_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","'a ia ko te foha 'o Simione, 'a ia ko te foha 'o Siuta, 'a ia ko te foha 'o Siosifa, 'a ia ko te foha 'o Sionami, 'a ia ko te foha 'o 'Ilaiakimi, ");
INSERT INTO num_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","'a ia ko te foha 'o Melea, 'a ia ko te foha 'o Mena, 'a ia ko te foha 'o Mātata, 'a ia ko te foha 'o Nētani, 'a ia ko te foha 'o Tēvita, ");
INSERT INTO num_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","'a ia ko te foha 'o Sese, 'a ia ko te foha 'o 'Ōpeti, 'a ia ko te foha 'o Poasi, 'a ia ko te foha 'o Solomone, 'a ia ko te foha 'o Nāsoni, ");
INSERT INTO num_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","'a ia ko te foha 'o 'Aminatape, 'a ia ko te foha 'o 'Atamaini, 'a ia ko te foha 'o 'Alanai, 'a ia ko te foha 'o 'Esilome, 'a ia ko te foha 'o Felesi, 'a ia ko te foha 'o Siuta, ");
INSERT INTO num_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","'a ia ko te foha 'o Sēkope, 'a ia ko te foha 'o 'Aisake, 'a ia ko te foha 'o 'Ēpalahame, 'a ia ko te foha 'o Tela, 'a ia ko te foha 'o Nēhoa, ");
INSERT INTO num_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","'a ia ko te foha 'o Sēluki, 'a ia ko te foha 'o Le'u, 'a ia ko te foha 'o Pēleki, 'a ia ko te foha 'o 'Epa, 'a ia ko te foha 'o Sela, ");
INSERT INTO num_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","'a ia ko te foha 'o Kēnani, 'a ia ko te foha 'o 'Āfakisate, 'a ia ko te foha 'o Semi, 'a ia ko te foha 'o Noa, 'a ia ko te foha 'o Lēmeki, ");
INSERT INTO num_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","'a ia ko te foha 'o Mētuisela, 'a ia ko te foha 'o 'Īnoke, 'a ia ko te foha 'o Sēleti, 'a ia ko te foha 'o Melilieli, 'a ia ko te foha 'o Kēnani, ");
INSERT INTO num_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","'a ia ko te foha 'o 'Īnosi, 'a ia ko te foha 'o Seti, 'a ia ko te foha 'o 'Ātama, 'a ia ko te foha 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Pea ne'e foki mai 'ia Sīsū mei Sioataní, kua fonu 'i te Laumālie Mā'oni'oní; pea ne'e tataki 'Ona ki te toafá 'i te mālohi 'o te Laumālié. ");
INSERT INTO num_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Pea ne'e 'ahi'ahi'i 'Ona 'e te tēvoló 'i te 'aho 'e fāngofulu: pea ko te 'ū 'aho ko iá ne'e kailoa Ina kai ai he me'a; pea 'i te hili ange ko iá ne'e hālofia leva Ia. ");
INSERT INTO num_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Pea iange 'e te tēvoló kiā Ia, “Kāpau ko te 'Alo 'ia Koe 'o te 'Atuá, fekau ki te fe'i maka nei ke hoko ko te fe'i mā.” ");
INSERT INTO num_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Pea tali ange 'e Sīsū kiā ia, “Kua tohi, ‘'E kailoa ma'uli te tangatá 'i te maá pē.’ ” ");
INSERT INTO num_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pea ne'e 'avake 'Ona 'e te tēvoló ki te potu mā'olunga, 'o faka'ali'ali ange kiā Ia 'ia te 'ū pule'anga kotoa pē 'o māmaní 'i te fe'i sio tu'a taha pē. ");
INSERT INTO num_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Pea iange 'e te tēvoló kiā Ia, “'E au 'avatu kiā Koe 'ia te pule ki te 'ū me'a nei kotoa pē, mo te notou nāunaú, he kua tuku mai kotoa pē ia kiā au, pea kā 'i ai he taha 'okou loto ki ai 'e au foaki ange 'eni kiā ia. ");
INSERT INTO num_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ko ia, kāpau 'e Ke punou 'o lotu mai kiā au 'e Koe, 'e 'O'ou kotoa pē ia.” ");
INSERT INTO num_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pea tali ange 'e Sīsū kiā ia, “Kua tohi, ‘'E ke lotu ki te 'Alikí ko tou 'Atuá, pea ko Ia pē Toko Taha 'e ke tauhi ki Aí.’ ” ");
INSERT INTO num_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pea 'ave leva 'e ia 'Ona ki Selusalema, 'o fokotu'u ki te tumutumu 'o te Temipalé, 'o iange kiā Ia, “Kāpau ko te 'Alo Koe 'o te 'Atuá, hopo ki lalo mei heni. ");
INSERT INTO num_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","He kua tohi, ‘'E kouna 'e Ia Tana kau 'āngeló ke malu'i 'Ou;’ ");
INSERT INTO num_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","mo 'eni foki, ‘'E notou hapahapai 'Ou, na'a tūkia Tou va'é 'i te maká.’ ” ");
INSERT INTO num_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Pea tali ange 'e Sīsū ki ai, “Kua folafola 'aki, ‘'Aua 'e ke 'ahi'ahi'i te 'Alikí ko tou 'Atuá.’ ” ");
INSERT INTO num_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pea kua faka'osi 'e te tēvoló ta'aná 'ahi'ahi kotoa pē, pea 'alu ia meiā Sīsū 'o lama faingamālie. ");
INSERT INTO num_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pea foki 'ia Sīsū ki Kāleli 'i te ivi 'o te Laumālié, pea mafola atu Tono ongoongó ki te feitu'u kotoa pē ko iá. ");
INSERT INTO num_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Pea ne'e fa'a faiako Ia 'i te notou 'ū falelotú, pea fakamālō kiā Ia 'e te kakai kotoa pē. ");
INSERT INTO num_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Pea 'alu atu Ia ki Nāsaleti, 'ā ē ne Ina nofo ai 'i Tana kei si'í. Pea hangē ko Tana fa'a faí, ne'e hū Ia ki te falelotú 'i te 'aho Sāpaté, 'o tu'u ake ke lau 'ia te Folafolá. ");
INSERT INTO num_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Pea ne'e 'avange kiā Ia 'ia te tohi 'a te palōfita ko 'Aiseá. Pea 'i Tana folahi te tohí, ne Ina 'ilo'i ai 'ia te potu tohi 'oku hiki ai 'ia te lea ko 'ení, ");
INSERT INTO num_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ko te Laumālie 'o te 'Alikí 'oku 'iā Au; he ne'e pani 'Oku ke Au 'alu mo te ongoongoleleí ki te masivá. Kua Ina fekau'i 'Oku ke fanongonongo te tukuangé ki te pōpulá, mo te faka'a'alá ki te kuí; ke vete ange 'ia nātou kua laveá; ");
INSERT INTO num_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ke fanongonongo 'ia te ta'u 'o te hōifua 'a te 'Alikí.” ");
INSERT INTO num_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pea toki takatakai'i 'e Ia 'ia te tohí, 'o 'avange ki te matu'a tauhí, 'o nofo ifo Ia ki lalo; pea sio fakamama'u kiā Ia 'ia te mata 'o nātou kotoa pē ne'e notou 'i te falelotú. ");
INSERT INTO num_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Pea ne'e kamata lea 'e Ia kiā nātou, 'o pehē, “Ko te 'aho nei kua fakamo'oni'i te fe'i Folafola ko 'ení 'i te kotou fanongó.” ");
INSERT INTO num_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Pea ne'e notou fakamo'oni ki ai kotoa pē; 'o notou ofo 'i te 'ū lea mālie ne'e tō mei Tono fofongá, mo notou pehē, “'Oku kailoa koā ko te foha pē 'eni ia 'o Siosifá?” ");
INSERT INTO num_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Pea iange 'e Ia kiā nātou, “Kua pau 'e kotou 'ai mai kiā Au 'ia te lea ko 'ení, ‘Faito'o, fakama'uli 'Ou; ko te 'ū me'a ne'e motou fanongo ne Ke fai 'i Kāpaneumé, fai foki 'i heni 'i Tou kolo 'O'oú.’ ” ");
INSERT INTO num_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Pea fai atu 'e Ia 'o iange, “Kā 'Okou tala mo'oni atu kiā kōtou, 'oku kailoa mamalu he palōfita ia 'i tono kolo 'o'oná. ");
INSERT INTO num_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ko te mo'oni 'eni 'Okou tala'i atú, ne'e tokolahi pē te kau fafine 'Isileli ne'e uitou 'i te kuonga 'o 'Ilaisiaá, 'i te taimi ne'e tāpuni'i ai 'ia te langí 'i te ta'u 'e tolu mo te māhina 'e onó, pea ne'e hoko ai he fu'u honge ki te fanuá fuli pē; ");
INSERT INTO num_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","kae tala'i'eaí ne'e kouna 'ia 'Ilaisiā ki he taha 'iā nātou, kā ki te fafine uitou pē 'i Salepita, 'i te fanua 'o Saitoní. ");
INSERT INTO num_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Pea ne'e tokolahi pē te tangata 'Isileli ne'e notou kilia 'i te kuonga 'o te palōfita ko 'Ilaisá; kae tala'i'eaí ne'e fakama'a he taha 'iā nātou, kā ko Neamani pē, 'a ia ko te tangata Sīlia.” ");
INSERT INTO num_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Pea ko nātou kotoa pē ne'e notou 'i te falelotú, ne'e notou mātu'aki lili 'i te notou fanongo ki te 'ū lea ko iá; ");
INSERT INTO num_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","pea notou tutu'u atu, 'o kapusi 'Ona ki tu'a kolo, 'o notou taki 'Ona ki te tumutumu 'o te ma'unga ne'e tu'u ai te notou koló, ko te 'aí ke sī ifo 'Ona 'i te lilifá. ");
INSERT INTO num_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ka ne'e moulu mai pē Ia 'i te lotolotonga 'o te kakaí, 'o 'alu. ");
INSERT INTO num_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Pea 'alu ifo Ia ki Kāpaneume, ko te kolo 'i Kāleli; 'o faiako kiā nātou 'i te 'ū 'aho Sāpaté. ");
INSERT INTO num_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Pea ne'e notou to'oa 'i te anga 'o Tana akonakí; he ko Ta'aná akonaki ne'e ha'u mo te mafai mālohi. ");
INSERT INTO num_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Pea ne'e 'i te falelotú he tangata ne'e 'āvea 'i te fa'ahikehe; pea ne'e kalanga le'o lahi ia, 'o pehē, ");
INSERT INTO num_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Tuku ai pē 'ia mātou ia! He ko Tou ā 'ia mātou, 'e Sīsū 'o Nāsaleti? Kua Ke ha'u ai ke faka'auha 'ia mātoú? 'Okou 'ilo'i lelei 'Ou, ko te Toko Taha Tapu Koe 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pea valoki'i 'ona 'e Sīsū, 'o iange ki ai, “Tuku tau leá, pea mahu'i mai meiā ia.” Pea toki sī atu 'ia te tangatá 'e te fa'ahikehé ki te ha'oha'ongá, 'o toki mahu'i atu; ka ne'e kailoa lavea 'ia te tangatá ia. ");
INSERT INTO num_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Pea ne'e ofo lahi 'ia te kakaí kotoa pē, 'o notou pehē, “Ko te folafola ā 'eni? He 'oku kapusi 'e Ia 'ia te 'ū fa'ahikehé, 'aki te mālohi mo te mafai lahi, pea notou mahu'i atu leva!” ");
INSERT INTO num_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Pea ne'e mafola atu Tono ongoongó ki te feitu'u kotoa pē 'i te fanua ko iá. ");
INSERT INTO num_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Pea 'i Tana mavahe atu mei te falelotú, ne'e hū Ia ki te fale 'o Saimoné. Pea ne'e 'i ai te fa'ē 'a te mali 'o Saimoné kua puke 'i te mofi lahi; pea notou kole ange kiā Ia kote'uhí ko ia. ");
INSERT INTO num_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Pea tu'u atu Ia ki ai, 'o lolomi 'ia te mofí; pea mahu'i leva ia mei te fafiné, pea ne'e tu'u ake ia 'o tauhi kiā nātou. ");
INSERT INTO num_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pea kua tō 'ia te la'aá, pea ko nātou kotoa pē ne'e 'i ai he notou kakai ne'e puke he fa'ahinga mahaki kehekehe, ne'e notou 'aumai nātou kiā Ia; pea kamata fakama'uli 'e Ia 'ia nātou, 'aki Tana hilifaki Tono nimá kiā nātou taki taha. ");
INSERT INTO num_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pea 'alu atu foki 'ia te 'ū fa'ahikehé mei te 'ihi, mo notou kalakalanga 'o pehē, “Ko te Kalaisí Koe ko te 'Alo 'o te 'Atuá.” Kae lolomi 'e Ia 'ia nātou, 'o kailoa Ina tuku ke notou lea; kote'uhí ne'e notou 'ilo'i ko Ia 'ia te Kalaisí. ");
INSERT INTO num_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pea kua 'aho leva, pea 'alu Ia ki tua'ā 'o mole atu ki te feitu'u lala. Pea ne'e fia ma'u 'Ona 'e te fu'u kakaí, 'o notou 'alu atu kiā Ia, 'o notou feinga'i ke 'aua na'a tē 'alu Ia meiā nātou. ");
INSERT INTO num_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ka ne'e iange 'e Ia kiā nātou, “Kua pau ke Au malanga 'aki 'ia te Pule'anga 'o te 'Atuá ki te 'ū kolo kehé foki; he ne'e fekau'i mai 'Okú ki te me'a ko iá.” ");
INSERT INTO num_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Pea ne'e malanga Ia 'i te 'ū falelotu 'o Siuteá. ");
INSERT INTO num_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Pea 'i te 'aho 'e taha ne'e feta'ota'omi mai kiā Ia he fu'u kakai, ke notou fanongo ki te Folafola 'a te 'Atuá, pea 'oku tu'u 'ia Sīsū 'i te matā anovai ko Kenesaletí. ");
INSERT INTO num_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Pea ne Ina vakai atu he ongo ki'i vaka 'oku nā tau mai 'i te mata anó, pea kua 'alu atu mei ai 'ia te kau tautaí, 'o fō te notou 'ū kupengá. ");
INSERT INTO num_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Pea heka leva Ia he taha 'o te ongo vaká, 'a ia ko te vaka 'o Saimoné; 'o kole ange kiā ia ke tukutuku si'i atu mei 'uta. Pea nofo ifo Ia 'o fai Tana ako ki te kakaí mei te vaká. ");
INSERT INTO num_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pea kua 'osi leva Tana leá, pea iange 'e Ia kiā Saimone, “Tukutuku atu ki te moaná, pea tuku ifo te kotou 'ū kupengá ki te ika.” ");
INSERT INTO num_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Pea tali 'e Saimone 'o iange kiā Ia, “'E 'Aliki, ko te talu ē te motou tautai 'anepō mo te kailoa he me'a 'e ma'u; kā 'i Tau me'á 'e au 'a'au pē te kupengá.” ");
INSERT INTO num_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Pea 'i te notou fai iá, pea ko te ika lahi mo'oni ne'e ma'ú, pea ne'e kamata mahae te notou 'ū kupengá. ");
INSERT INTO num_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Pea notou ta'alo leva ki te notou kaungā tautai 'i te vaka 'e tahá ke notou ōmai 'o tokoni, pea notou ha'u leva, 'o fakafonu 'ia te ongo vaká fakatou'osi, 'o hangē kā ngoto ifó. ");
INSERT INTO num_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pea 'i te sio leva ki ai 'ia Saimone Pitá, ne'e hinga atu ia ki te tui 'o Sīsuú, 'o iange, “Me'a atu mu'a, 'Aliki, meiā au, he ko te tangata angahala 'eni.” ");
INSERT INTO num_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","He ne'e 'ohovale lahi ia, pea pehē mo nātou ne'e notou 'iā iá, 'i te ola pehē fau te notou ha'ó. ");
INSERT INTO num_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Pea pehē foki kiā Sēmisi mo Sione ko te ongo foha 'o Sēpetí, 'a ē ne'e nā kaungā tautai mo Saimoné. Pea iange 'e Sīsū kiā Saimone, “'Aua 'e ke manahē; mei te taimi nei 'e ke tautai tangata.” ");
INSERT INTO num_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pea kua notou 'aumai te ongo vaká ki 'uta, 'o notou si'aki kotoa pē, 'o mulimuli kiā Ia. ");
INSERT INTO num_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Pea ne'e lolotonga Tana 'i te kolo 'e taha, pea vakai, ko he tangata kilia hoko; pea 'i tana sio leva kiā Sīsuú, ne'e tō tū'ulutui atu ia 'o hū kiā Ia, 'o pehē, “'Aliki, kāpau ne Ke loto ki ai, 'e Ke lava ke fakama'a 'oku.” ");
INSERT INTO num_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Pea mafao atu leva 'e Ia Tono nimá, 'o ala ki te tangatá, 'o iange, “'Okou loto pē: ke ma'a 'ia koe.” Pea matafi atu leva te kiliá meiā ia. ");
INSERT INTO num_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Pea na'ina'i 'e Ia ki te tangatá ke 'aua na'a tala'i 'eni ki he taha; mo iange 'e Ia, “Kā ke 'alu pē ke fakahā 'ou ki te taula'alikí, mo 'avange 'ia te me'á 'o fakatatau ki te tu'utu'uni 'a Mōsesé mo'o tou fakama'a, ko te fakamo'oni kiā nātou.” ");
INSERT INTO num_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ka ne'e 'āsili ange te mafola ia 'o te talanoa kau kiā Iá; pea ne'e fakataha leva 'ia te kakai tokolahi 'aupito ke notou fānonongo kiā Ia, pea mo fakama'uli 'ia nātou mei te notou 'ū alanga mahakí. ");
INSERT INTO num_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pea ne'e mavahe Ia mei ai ki te toafá, 'o fai Tana lotu. ");
INSERT INTO num_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pea ko te 'aho 'e taha lolotonga Tana faiakó, ne'e 'i te ha'oha'ongá he kau Fālesi mo he kau faiako lao, 'a ia kua notou ōmai mei te 'ū feitu'u kehekehe 'o Kāleli mo Siutea mo Selusalema; pea ko te mālohi 'o te 'Alikí ne'e toka ki te faito'ó. ");
INSERT INTO num_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Pea vakai, ko te kau siana 'ena 'oku notou 'aumai he tangata 'i tono moe'angá ne'e mamatea; 'o notou feinga'i ke fakahū 'ona ki loto ke tuku ifo ki mu'a 'iā Sīsū. ");
INSERT INTO num_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pea 'i te kailoa notou 'ilo'i pe ko te ala fea 'e notou fakahū ai 'oná, kote'uhí ko te tokolahi 'ia te kakaí, ne notou ō ake leva ki te tu'a falé, 'o notou tuku'i ifo 'ona mo te falá 'i te 'ató ki te loto falé 'i mu'a 'iā Sīsū. ");
INSERT INTO num_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Pea 'i Tana vakai leva ki te notou tuí, ne'e iange 'e Ia, “Toku foha, kua fakamolemole'i tau 'ū angahalá.” ");
INSERT INTO num_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pea kamata fifili 'ia te kau sikalaipé mo te kau Fālesí, 'o notou pehē, “Ko ai 'ia te Siana nei mo te lea fia 'Atuá? He ko ai ia 'oku mafai ke fakamolemole angahala, kā ko te 'Atuá Toko Taha pē?” ");
INSERT INTO num_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kā ne 'ilo'i pē 'e Sīsū te notou fakakaukaú, 'o toe iange 'e Ia kiā nātou, “Ko te ā ia 'oku kotou fifili ki ai 'i te kotou lotó? ");
INSERT INTO num_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","He ko te ā 'oku faingafuá, 'i te iange, ‘Kua fakamolemole'i tau 'ū angahalá,’ pē ko te iange, ‘Tu'u 'o 'eva'eva’? ");
INSERT INTO num_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kā kote'uhí ke kotou 'ilo'i, ko te Fanautama te Tangatá 'oku mafai 'e Ia 'i māmani ke fakamolemole angahala, (pea hanga leva Ia 'o iange ki te tangata mamateá,) 'Okou iatu kiā koe: tu'u, 'o to'o tou falá, pea 'alu ki tou 'apí.” ");
INSERT INTO num_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Pea tu'u ake leva ia 'i te notou 'aó, 'o to'o te me'a ne'e takoto aí, 'o 'alu atu ki tono 'apí, mo tana fakamālō'ina 'ia te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pea ne'e notou ofo ai kotoa pē, 'o notou fakamālō ki te 'Atuá, pea notou mate 'i te 'ilifiá, mo notou pehē, “Kua tou sisio 'eni he mana lahi 'i te 'aho nei!” ");
INSERT INTO num_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pea 'i te 'osi ange 'ení ne Ina 'alu atu, 'o fakatokanga'i atu he tangata tānaki tukuhau ne'e hingoa ko Līvai, 'oku nofo mai 'i te fale tuté; 'o iange kiā ia, “Mulimuli mai kiā Au.” ");
INSERT INTO num_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Pea tukuange leva 'e ia 'ia te me'a kotoa pē, 'o mulimuli kiā Ia. ");
INSERT INTO num_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pea fai 'e Līvai he fu'u kātoanga kiā Sīsū 'i tono falé; pea ko te fu'u tokolahi 'o te kau tānaki tukuhaú mo te kakai kehe ne'e notou 'i te kātoangá fakataha mo nātou. ");
INSERT INTO num_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pea kua lāunga 'ia te kau Fālesí mo te kau sikalaipé ki Tana kau akó, 'o notou iange, “Ko te ā 'oku kotou kai mo inu fakataha ai mo te kau tānaki tukuhaú mo te kau angahalá?” ");
INSERT INTO num_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Pea tali 'e Sīsū kiā nātou, “Ko te tangata faito'ó 'oku kailoa ma'a te ma'uli leleí, kā 'oku ma'a te mahaki'iná. ");
INSERT INTO num_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ne kailoa ke Au ha'ú ke ui 'ia te mā'oni'oní, kā ko te angahalá ke fakatomala.” ");
INSERT INTO num_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Pea notou fehu'i ange kiā Ia, “Ko te ā 'oku fa'a 'aukai ai 'ia te kau ako ia 'a Sioné, mo notou tauhi te 'ū feinga lotú; pehē foki ki te kau ako 'a te kau Fālesí; kae kai pē, mo inu nātou ia 'oku 'iā Koé?” ");
INSERT INTO num_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Pea tali ange 'e Sīsū kiā nātou, “He 'e kotou lava tono fakaloto'i te kau fakaafe 'o te tangata ta'ané ke notou fai he 'aukai, 'i te kei 'iā nātou te tangata ta'ané? ");
INSERT INTO num_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kae tokaange pē he taimi 'e hiki ai meiā nātou 'ia te tangata ta'ané, pea 'e notou toki 'aukai leva 'i te taimi ko iá.” ");
INSERT INTO num_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Pea lea 'aki foki 'e Ia he talanoa fakatātā kiā nātou, 'o pehē: “'Oku kailoa he taha 'e hae'i mei te kofu fo'oú he konga ke 'oposi 'aki he kofu matu'a; he kā pehē leva, 'e hae ia 'e te me'a fo'oú, pea ko te matu'á 'oku kailoa tu'unga tatau mo ia 'ia te konga mei te kofu fo'oú. ");
INSERT INTO num_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Pea 'oku kailoa he taha 'e 'utu he uaine fo'ou ki te 'ū hina leta matu'a; he kā pehē leva, 'e hae 'ia te 'ū hiná 'e te uaine fo'oú, pea mahua leva 'ia te uainé ia, pea maumau ai mo te 'ū hiná foki. ");
INSERT INTO num_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kā ko tono totonú ke 'utu he uaine fo'ou ki te 'ū hina fo'ou. ");
INSERT INTO num_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Pea 'oku kailoa he taha kua inu 'ia te uaine matu'a pea toe manako ki te fo'oú; he 'e pehē mai ia, ‘Ko te uaine matu'á pē 'oku saí.’ ” ");
INSERT INTO num_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pea ko 'eni, ko te Sāpate 'e taha ne Ina fononga atu 'o ala loto ngoue; pea toli 'e Tana kau akó 'ia te 'ū fe'i uite, 'o milimili 'i te notou nimá mo notou kai. ");
INSERT INTO num_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pea iange 'e te 'ihi 'o te kau Fālesí, “Ko te ā 'oku kotou fai ai te me'a 'oku kailoa ngafua 'i te Sāpaté?” ");
INSERT INTO num_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Pea tali 'e Sīsū kiā nātou, “'Io, ne kala kotou lau koā 'ia te me'a 'ā ē ne'e fai 'e Tēvitá, 'i te taimi ne'e hālofia ai ia mo nātou ne'e 'iā iá? ");
INSERT INTO num_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","He ne'e hū ia ki te Fale 'o te 'Atuá, 'o to'o mai 'ia te mā fonó 'o kai, mo 'avange kiā nātou ne'e notou 'iā iá; kā ko te me'a ia 'oku kailoa ngafua tono kaí, ngata pē 'i te kau taula'alikí?” ");
INSERT INTO num_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Pea toe iange 'e Ia kiā nātou, “Ko te Fanautama te Tangatá ko te 'Aliki Ia 'o te Sāpaté foki.” ");
INSERT INTO num_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pea hū 'ia Sīsū ki te falelotú he Sāpate 'e taha, 'o faiako 'i ai. Pea ne'e 'i ai he tangata kua mate tono nima mata'ú. ");
INSERT INTO num_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Pea ko te kau sikalaipé mo te kau Fālesí ne'e notou lamalama Hana fai he faito'o 'i te Sāpaté, ke notou ma'u ai he me'a ke faka'ilo'i 'aki 'Ona. ");
INSERT INTO num_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kā ne 'ilo'i pē 'e Ia te notou fakakaukaú, 'o iange 'e Ia ki te tangata nima maté, “Tu'u ake, 'o tu'u mai ki loto.” Pea tu'u ake leva ia 'o tu'u mai. ");
INSERT INTO num_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pea iange 'e Sīsū kiā nātou, “'Oku 'i ai Taku fehu'i ke fai atu, ko fea 'oku ngafua 'i te Sāpaté? Ke fai he lelei, pē ko te fai he kovi? Ke fakahaofi he ma'uli, pē ke tāmate'i?” ");
INSERT INTO num_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Pea vakai foli 'e Ia 'ia nātou kotoa pē, 'o iange ki te tangatá, “Mafao atu tou nimá.” Pea fai 'e ia ki ai, pea ne'e toe ma'uli mai tono nimá. ");
INSERT INTO num_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pea fakautuutu ai te notou seselé; 'o notou fealealea'aki ai, pe ko te ā koā he me'a 'e notou fai kiā Sīsuú. ");
INSERT INTO num_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pea ne'e hoko 'i te kuonga ko iá Tana 'alu atu ki te ma'ungá ke fai Tana lotu; pea ne'e 'osiki 'e Ia 'ia te poó 'i Tana lotu ki te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pea 'i tana 'aho aké, ne'e ui ange 'e Ia Tana kau akó, 'o fili'i meiā nātou he toko hongofulu mā ua, 'o Ina fakahingoa 'ia nātou ko te kau 'apōsetolo: ");
INSERT INTO num_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ko Saimone ('ā ē ne'e fakahingoa foki ko Pitá) mo 'Anitelū ko tono tehiná, mo Sēmisi mo Sione mo Filipe mo Pātolomiu ");
INSERT INTO num_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","mo Mātiu mo Tōmasi, ko Sēmisi ko te foha 'o 'Alefiusí, mo Saimone ne fa'a lau ko te mamahi'i fanuá, ");
INSERT INTO num_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","mo Siutasi ko te foha 'o Sēmisí, pea mo Siutasi 'Isikaliote 'ā ē ne'e hoko ko te lavakí. ");
INSERT INTO num_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pea 'alu ifo Ia fakataha mo nātou, 'o Ina tu'u he feitu'u ne'e toka lelei; pea ne'e 'i ai mo te tokolahi 'o Tana kau akó, mo he fu'u kakai tokolahi, mei Siutea fuli pē, mo Selusalema, mo te hāngai ki te tai 'o Taia mo Saitoní, kua ōmai ke notou fānonongo kiā Ia, mo faito'o 'ia nātou ne'e notou mahaki'iná. ");
INSERT INTO num_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ko nātou foki ne'e fakafiu'i 'e te 'ū fa'ahikehé ne'e fakama'uli. ");
INSERT INTO num_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Pea feinga 'ia te kakai kotoa pē ke ala kiā Ia, he ne'e 'alu atu meiā Ia he mālohi, 'o fakama'uli 'ia nātou fuli pē. ");
INSERT INTO num_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Pea hanga ake Ia Tono fofongá ki Tana kau akó, 'o pehē ange, “'Oku manū'ia 'ia kōtou 'oku masivá, he 'oku 'a kōtou 'ia te Pule'anga 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","'Oku manū'ia 'ia kōtou 'oku fiakaia ko 'ení, he 'e fakamākona 'ia kōtou. 'Oku manū'ia 'ia kōtou 'oku tangi ko 'ení, he 'e kotou kata. ");
INSERT INTO num_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","'Oku manū'ia 'ia kōtou, kā fihi'anakina'i 'e te kakaí, pea kā notou kapusi 'ia kōtou, mo manuki'i, mo notou keu'i te kotou hingoá hangē he me'a 'oku pangó, kote'uhí pē ko te Fanautama te Tangatá. ");
INSERT INTO num_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","'Ē, kotou fiafia 'i te taimi ko iá, mo kotou hākahaka; he vakai, 'oku lahi te kotou totongi 'i hēvaní; he ko te me'a pē ia ne'e fai 'e te notou mātu'á ki te kau palōfitá. ");
INSERT INTO num_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kae pohoē 'ia kōtou koloa'ina! He ko tono ngata 'ena te kotou fiamālie 'oku kotou ma'ú. ");
INSERT INTO num_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Pohoē 'ia kōtou 'oku kotou mākona nei! He 'e kotou fiakaia. Pohoē 'ia kōtou 'oku kotou kata nei! He 'e kotou mamahi mo kotou tangi. ");
INSERT INTO num_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Pohoē 'ia kōtou, 'o kā lau'i lelei 'e te kakai kotoa pē! He ko te me'a pē ia ne'e fai te notou mātu'á ki te kau palōfita lohí. ");
INSERT INTO num_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Kā 'Okou tala'i atu kiā kōtou 'oku kotou fānonongo nā: kotou 'ofa'i te kotou 'ū filí, failelei kiā nātou 'oku fihi'a atu kiā kōtoú, ");
INSERT INTO num_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","tāpuaki'i 'ia nātou 'oku kape'i 'ia kōtoú, hūfia 'ia nātou 'oku notou ngaahikovi'i kōtoú. ");
INSERT INTO num_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kā tuki'i 'ou he taha 'i tou kau'ahé, 'avange ki ai mo te kau'ahe 'e tahá; pea ko ia kua ina 'ave tou pulupulú, 'aua na'a ta'ofi meiā ia mo tou soté foki. ");
INSERT INTO num_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kā 'i ai he taha 'e fai atu he kole kiā koe, foaki kiā ia; pea kā 'ave he taha hau me'a, 'aua na'a toe 'eke'i ia. ");
INSERT INTO num_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pea hangē ko ia 'oku kotou loto ke fai 'e te kakaí kiā kōtoú, kotou fai tatau foki kiā nātou. ");
INSERT INTO num_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","He kāpau 'oku kotou 'ofa'i pē 'ia nātou 'oku notou 'ofa maí, ko he me'a ia ke fakafeta'ina? He na'a mo te kakai angahalá 'oku notou 'ofa'i pē 'ia nātou 'oku notou 'ofa maí. ");
INSERT INTO num_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Pea kāpau 'oku kotou failelei kiā nātou pē 'oku notou failelei maí, ko he me'a ia 'e fakafeta'ina? He na'a mo te kakai angahalá 'oku notou fai foki 'ia te me'a ko iá. ");
INSERT INTO num_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Pea kāpau 'e kotou tali he nō kiā nātou pē 'oku kotou 'amanaki ke toe ma'u mai mei aí, ko te me'a ia 'e fakafeta'ina? Na'a mo te kakai angahalá 'oku notou tali nō ki te kakai angahalá, kote'uhí ke notou ma'u mai tono tataú. ");
INSERT INTO num_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kae kotou 'ofa'i te kotou 'ū filí, pea kotou failelei mo tali nō, neongo pē 'oku kala kotou 'amanaki 'e toe ma'u mai he me'a; pea 'e lahi leva te kotou totongí, pea 'e kotou hoko ko te 'ū foha 'o te 'Aliki Taupotú; hē 'oku anga-lelei Ia ki te ta'ehoungá mo te faikoví. ");
INSERT INTO num_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","'Ē, 'ai ke kotou manava'ofa, 'o hangē foki 'oku manava'ofa 'ia te kotou Tamaí. ");
INSERT INTO num_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Pea 'aua na'a kotou fakaanga, pea 'e kailoa anga'ina 'ia kōtou; pea 'aua na'a fakahalaia, pea 'e kailoa fakahalaia'i kōtou; kotou fakamolemole, pea 'e fakamolemole'i kōtou. ");
INSERT INTO num_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","'Avange pea 'e toe 'aumai kiā kōtou, kua fua fakalaka, kua fa'o lolomi ifo, kua lulu'i, kua fonu makulu; 'e pehē pē te notou toe 'avatu ki te kotou koná. He ko te fua 'oku kotou fua 'akí, ko ia pē 'e fua 'aki kiā kōtoú.” ");
INSERT INTO num_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Pea lea 'aki foki 'e Ia he talanoa fakatātā kiā nātou, 'o pehē, “'E lava koā he kui ke takiala ki te kui? 'E kala koā nā fakatou tō ki te luo? ");
INSERT INTO num_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tala'i'eaí 'oku lahi te tama akó 'i te faiakó, kae kā 'i ai he taha kua haohaoa ta'aná ako 'e hangē pē ia ko te faiakó. ");
INSERT INTO num_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Pea ko te ā 'oku tokanga ai 'e koe ki te malamala'i 'akau 'i te mata 'o tou kāingá, kā ko te fu'u lalango 'ena 'i to'oú mata 'oku kala ke 'ilo ki aí? ");
INSERT INTO num_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","'E ke lava fefe'aki ke lea ki tou kāingá, ‘Nga'ata, tuku ke au to'o mai te malamala 'a 'ena 'i tou matá;’ 'osi angé, 'oku kala tokanga'i 'e koe te fu'u lalango 'i to'oú mata? 'Ia te mālualohi! Fu'aki to'o mai te lalango mei to'oú mata, pea 'e ke toki sio totonu ke to'o mai te malamala mei te mata 'o tou kāingá. ");
INSERT INTO num_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“He 'oku kailoa he 'akau lelei 'e tupu mei ai 'ia te fua kovi, pē he 'akau kovi 'e tupu mei ai he fua lelei. ");
INSERT INTO num_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kā 'oku mahino 'ia te fu'u 'akau taki taha mei tono fua 'o'oná. He 'oku kailoa tufi fiki 'i te vao talatala, pē he toli kālepi 'i te talatala'āmoa. ");
INSERT INTO num_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ko te tangata leleí 'oku fisi ki tu'a mei ai 'ia te lelei mei te koloa lelei kua fa'o ki tono lotó; pea ko te tangata koví 'oku fisi ki tu'a mei ai 'ia te kovi mei te koloa kovi kua fa'o 'i tono lotó. He ko te talanoa 'a te ngutú 'oku mei te me'a lahi 'oku 'i te lotó. ");
INSERT INTO num_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Pea ko te ā 'oku kotou ui ai 'Oku, ‘'Aliki, 'Aliki,’ kae kala kotou fai te 'ū me'a 'Okou tala'i atú? ");
INSERT INTO num_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ko ia ko 'ē 'oku ha'u kiā Au, 'o fanongo ki Taku 'ū talá, mo fai ki aí, 'e Au fakatātaa'i atu tono tataú: ");
INSERT INTO num_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","'oku tatau ia mo he tangata langa fale; 'a ia ne'e keli loloto ia, 'o 'ai te tu'ungá 'i te funga maká. Pea 'i te fā 'ia te vaitafé, pea pā atu ia ki te fale ko iá; pea ne'e kailoa mafai ia ke lulu'i 'ona, ko te me'a 'i te lelei tono langá. ");
INSERT INTO num_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kā ko ia 'oku fanongo 'o kailoa fai ki aí, 'oku tatau ia mo he tangata ne'e langa fale 'i te funga kelekelé, mo kailoa 'ai hana tu'unga. Pea ne'e pā atu ki ai 'ia te vaitafé, pea holo leva ia; pea ne'e hoko te maumau 'o te fale ko iá ko te maumau lahi.” ");
INSERT INTO num_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pea kua 'osi leva Tana 'ū tala kotoa pē kae fanongo 'ia te kakaí, pea toki 'alu Ia ki Kāpaneume. ");
INSERT INTO num_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Pea ne'e 'i ai he senituliō 'e taha, kua puke 'o teitei mate tana pōpulá, 'a ē ne'e mahu'inga'ina taha 'i aí. ");
INSERT INTO num_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pea kua fanongo ia ko Sīsū 'ená, ne ina fekau'i atu he 'ihi 'o te kau mātu'a 'o te kakai Siú, ke kole kiā Ia, ke ha'u mu'a 'o fakama'uli tana pōpulá. ");
INSERT INTO num_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pea notou ōmai leva kiā Sīsū, 'o kole fakamātoato kiā Ia, 'o pehē, “Ko te tangata 'eni 'oku taau ke Ke tokoni'í; ");
INSERT INTO num_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","he 'oku 'ofa'i 'e ia te tou kakaí, pea ne ina langa kiā mātou te motou falelotú.” ");
INSERT INTO num_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Pea 'alu atu 'ia Sīsū mo nātou. Pea kua mei a'u Ia ki te falé, mo te fekau ange mei te senitulioó he kāinga 'ihi ke iange kiā Ia, 'o pehē, “'E 'Aliki, 'aua na'a ongosia mai 'ia Koe, he 'oku kala u taau ke hū mai 'ia Koe ki toku poko'i falé. ");
INSERT INTO num_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Pea ko te me'a ia foki ne au pehē ai 'oku kala u taau ke 'alu atu kiā Koé. Kae fai pē mu'a he fe'i folafola, pea 'e ma'uli ai pē ta'akú tamaio'aliki. ");
INSERT INTO num_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","He ko aú foki ko te tangata 'okou fakaongo ki toku pule, pea 'oku 'i ai he kau sōtia 'oku notou fakaongo mai kiā au; pea 'e au iange ki te taha, ‘'Alu,’ pea 'e 'alu atu ia; pea ki te taha, ‘Ha'u,’ pea 'e ha'u leva ia; pea u iange ki taku pōpulá, ‘Fai ē,’ pea fai leva ia.” ");
INSERT INTO num_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Pea 'i te fanongo 'e Sīsū ki te me'a ko iá, ne'e ofo Ia 'i te tangatá; pea tafoki leva Ia ki te fu'u kakai ne'e notou mulimuli maí, 'o iange, “'Okou tala'i atu 'eni kiā kōtou, na'a mo 'Isilelí 'ē, ne kailoa 'aupito ke Au 'ilo'i ai he tui kua pehē fau!” ");
INSERT INTO num_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pea 'i te foki leva ki te falé 'ia te kakai ne fekau'i atú, ne'e notou 'ilo'i 'ia te pōpulá, kua ma'uli ia. ");
INSERT INTO num_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pea ko te 'aho tono hokó, ne Ina 'alu atu ki te kolo 'oku hingoa ko Neini; pea ne'e fononga mai Tana kau akó, mo he fu'u kakai. ");
INSERT INTO num_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pea 'i Tana ofi leva ki te matapā 'o te koló, pea vakai, ne'e fata mai ki tua'ā he pekia, ko te tama pē toko taha ia 'o tana fa'eé, pea ko te fafine uitou ia; pea ne'e 'iā ia he kakai tokolahi 'o te koló. ");
INSERT INTO num_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pea 'i te mamata 'e te 'Alikí ki te fafiné, ne'e langa Tono fatú 'i te 'ofa kiā ia, 'o pehē ange 'e Ia, “Tuku tau tangí.” ");
INSERT INTO num_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Pea 'alu atu Ia 'o ala ki te fatá; pea tu'u pē 'ia te kau fatá. Pea iange 'e Ia, “Tama, 'Okou iatu kiā koe, ke ke tu'u!” ");
INSERT INTO num_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Pea ta'utu ake 'ia te 'anga'angá, 'o kamata lea, pea tukuange 'ona 'e Sīsū ki tana fa'eé. ");
INSERT INTO num_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pea ne'e hoko he fu'u 'ilifia ki te kakaí kotoa pē, 'o notou fakamālō'ina 'ia te 'Atuá, 'o notou pehē, “Kua tupu ake 'i te tou lotolotongá he palōfita lahi,” mo 'eni, “Kua 'a'ahi mai 'ia te 'Alikí ki Tono kakaí.” ");
INSERT INTO num_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Pea mafola atu Tono ongoongo ko iá 'i Siutea fuli pē, kae'uma'ā 'ia te fu'u fanuá takatakai. ");
INSERT INTO num_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Pea ne'e talanoa'i foki kiā Sione 'e tana kau ako 'a'aná 'ia te 'ū me'a ko iá kotoa pē. ");
INSERT INTO num_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Pea ui ange 'e Sione he toko ua 'o tana kau akó, 'o fekau'i atu 'ia nāua ki te 'Alikí ke 'eke ange kiā Ia, “Ko Koe koā Ia ne'e pehē ke ha'ú, pē 'e tou toe talitali ki te taha kehe?” ");
INSERT INTO num_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pea 'i te a'u mai te ongo me'á kiā Iá, ne nā iange, “Ko Sione Papitaiso 'eni ne'e fekau'i mai 'ia māua kiā Koe, pea ko tana me'a maí, ‘Pē ko Koe koā Ia ne'e pehē ke ha'ú, pē 'e tou talitali ki te taha kehe?’ ” ");
INSERT INTO num_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ko te feitu'ula'ā ko iá ne'e fakama'uli ai 'e Ia 'ia te tokolahi mei te 'ū mahakí, pea mo te 'ū me'a fakamamahí, mo te 'ū fa'ahikehé, pea ne'e 'ofa 'e Ia ki he 'ihi kui, 'o faka'a'ala 'ia nātou. ");
INSERT INTO num_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pea tali ange 'e Ia 'o pehē ki te ongo me'á, “Kulā ō, 'o tala kiā Sione 'ia te 'ū me'a kua kulā mamata mo fanongo ki aí: kua 'a'ala te kuí, kua 'eva'eva te heké, kua fakama'a te kiliá, kua ongo te tulí, kua fokotu'u te pekiá, pea 'oku malanga 'aki 'ia te ongoongoleleí ki te masivá. ");
INSERT INTO num_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pea manū'ia ā kā ko ia 'oku kailoa tūkia 'iā Aú.” ");
INSERT INTO num_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pea kua ō atu 'ia te ongo talafekau 'a Sioné, pea hanga leva 'e Sīsū 'o lea ki te kakaí 'iā Sione, 'o pehē, “Ne kotou ō atu ki te toafá ke mamata ki te ā? Ko te kaho 'apē 'oku lulu'i 'e te matangí? ");
INSERT INTO num_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kā ko te ā nai ne'e kotou ō atu ke mātaa'í? Ko he tangata 'apē, 'oku teunga faka'ofa'ofa? 'Ē, ko te fa'ahinga 'oku kofu faka'ofa'ofá, mo nātou 'oku ma'uli faka'ali'alikí, 'oku notou nofo palasi 'ia nātou ia. ");
INSERT INTO num_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kā ko te kotou ō atu 'ia kōtoú ke mamata ki te ā? Ki te palōfita? 'Āua; 'Okou tala'i atu, 'oku lahi ia 'i te palōfitá. ");
INSERT INTO num_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ko 'eni ia ne'e tohi ki ai 'ia te Folafolá, ‘Vakai, 'Okou fekau atu Taku talafekaú ke mu'amu'a kiā Koe, 'a ia 'e teuteu'i 'e ia Tou alá Mo'ou.’ ");
INSERT INTO num_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","'Okou tala'i atu 'eni, ko te kakai kotoa pē kua fanau'i mei te fafiné, 'oku kala he taha ia 'oku lahi 'iā Sione; kā neongo pe ko ai 'oku mā'ulalo taha 'i te Pule'anga 'o te 'Atuá, 'oku lahi Ia 'iā Sione.” ");
INSERT INTO num_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Pea ko te kau 'Isileli kotoa pē ne'e notou fanongo ki aí, pea mo te kau tānaki tukuhaú, ne'e notou fakahaa'i te anga-tonu 'a te 'Atuá, 'aki te notou papitaiso 'i te papitaiso 'a Sioné. ");
INSERT INTO num_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kā ko te kau Fālesí mo te kau tufunga laó, ne'e notou fakata'e'aonga'i 'ia te finangalo 'o te 'Atuá kiā nātoú, pea ne'e kailoa notou papitaiso 'iā ia. ");
INSERT INTO num_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Pea pehē ange 'e Ia, “Kā 'e Au fakatatau ki te ā 'ia te kakai 'o te to'utangata nei? Pea 'oku notou hangē nai ko te ā? ");
INSERT INTO num_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","'Oku notou hangē ko he tamaliki 'oku notou nofo he mala'e fakatau, 'o notou fekālangaki, mo pehē, ‘Ne'e motou ifi fangufangu atu kiā kōtou, kae kala kotou me'e; ne'e motou hua'i atu te pohoeé, kae kala kotou tangi.’ ");
INSERT INTO num_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","He kua ha'u 'ia Sione Papitaiso, 'o kailoa kai mā, pe inu uaine; pea kotou pehē, ‘Kua 'iā ia he tēvolo.’ ");
INSERT INTO num_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kua ha'u 'ia te Fanautama te Tangatá, 'o kai mo inu; pea kotou pehē leva, ‘'Isa! Ko te tama fa'a kai mo inu uaine, ko te kaume'a Ia 'o te kau tānaki tukuhaú mo te kau angahalá!’ ");
INSERT INTO num_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kā ne fakatonuhia'i 'ia Poto 'e te fānau kotoa pē 'A'aná.” ");
INSERT INTO num_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pea ne'e fakaafe'i 'Ona 'e te Fālesi 'e taha ke nā kai, pea hū Ia ki te fale 'o te Fālesí, 'o nofo 'i ai ke kai. ");
INSERT INTO num_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Pea vakai, ko he fafine fai angahala 'i te koló, 'i tana 'ilo'i pau 'oku kainanga 'e Sīsū 'i te fale 'o te Fālesí, ne ina ha'u mo he hina 'alapasita ne'e fonu 'i te lolo tākai; ");
INSERT INTO num_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","'o tu'u mei Tono tu'á ofi ki Tono va'é, 'o tangi; pea kamata fufulu 'e ia Tono va'é 'aki tono lo'imatá, mo holoholo'i 'aki tono lau'i'ulú, mo toutou 'uma ki Tono va'é, mo tākai 'aki ia 'ia te loló. ");
INSERT INTO num_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pea 'i te vakai leva ki ai 'e te Fālesi 'a ē ne'e fakaafe'i 'Oná, ne'e pehē 'e ia 'i tono lotó, “Kāpau ko he palōfita 'eni, pehē kua 'ilo'i 'e Ia 'ia te fafine ko 'eni 'oku ala ange kiā Iá, mo tono angá; he ko te angahala ia.” ");
INSERT INTO num_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Pea tali 'e Sīsū 'o iange kiā ia, “'E Saimone, 'oku 'i ai Taku lea ke fai atu.” Pea iange ia, “Fai pē, Tangata'aliki.” ");
INSERT INTO num_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Ne'e 'i ai he ongo tangata ne'e nā ma'ua ki te matāpule tali-nō-pa'anga: ko te ma'ua 'o te taha ko te tēnali 'e nimangeau, ko te taha ko te tēnali 'e nimangofulu. ");
INSERT INTO num_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pea 'i te kailoa he nā me'a ke totongi 'akí, ne'e fakamolemole'i nāua fakatou'osi. Ko te fea nai 'iā nāua 'e lahi ange tana 'ofa ki te matāpulé?” ");
INSERT INTO num_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Pea tali 'e Saimone 'o pehē, “'Okou pehē, ko te toko taha ko 'ē ne'e lahi tana fakamolemolé ki aí.” Pea iange leva 'e Sīsū ki ai, “Mo'oni pē tau laú.” ");
INSERT INTO num_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Pea tafoki Ia ki te fafiné, mo iange kiā Saimone, “'Oku ke vakai ki te fafine nei? Ne Au hū mai ki tou falé, ka ne'e kailoa ke 'aumai he vai ki Toku va'é. Kā ko te fafine nei kua fakaviviku 'e ia To'okú va'e 'aki tono lo'imatá, pea holoholo'i 'aki tono laú. ");
INSERT INTO num_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ne'e kailoa ke ki'i 'uma mai kiā Au, kā ko te fafine nei, talu Taku hū mai mo te kailoa tuku ta'aná 'uma ki Toku va'é. ");
INSERT INTO num_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ne kailoa ke pani lolo Toku 'ulú. Kā ko te fafine nei kua ne pani 'aki te lolo tākai Toku va'é. ");
INSERT INTO num_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ko ia ai 'Okou tala'i atu, ko ta'aná angahala ne'e hulu atu, pea kua fakamolemole'i, he vakai kua lahi tana 'ofá. Kā ko ia 'oku si'isi'i te fakamolemolé ki aí pea si'isi'i leva ta'aná 'ofa.” ");
INSERT INTO num_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Pea iange 'e Ia ki te fafiné, “Kua fakamolemole'i ta'aú 'ū angahala.” ");
INSERT INTO num_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Pea ko nātou ne'e notou kainanga mo Iá, ne'e notou kamata lea 'i te notou lotó, 'o pehē, “Ko Ai 'eni, 'oku toe fakamolemole angahala Ia foki?” ");
INSERT INTO num_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pea iange 'e Sīsū ki te fafiné, “Kua fakama'uli 'ou 'e tau tuí; 'alu ā 'o fiamālie.” ");
INSERT INTO num_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pea 'i te 'osi leva ko iá, ne'e 'alu Ia ki te kolo lalahi mo te kolo liliki fuli pē, 'i Tana malanga'i te Pule'anga 'o te 'Atuá, mo tala tono ongoongoleleí. Pea ne'e notou ō holo mo te kau hongofulu mā uá, ");
INSERT INTO num_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","mo he kau fafine, 'a ia kua fakama'uli mei te notou 'ū fa'ahikehé, mo te notou 'ū vaivai'angá, ko Mele mei Makitalá, 'ā ē ne'e 'alu mei ai 'ia te fanga tēvolo 'e toko fitú, ");
INSERT INTO num_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","mo Sioana ko te mali 'o Kusa ko te tauhi koloa 'a Hēlotá, mo Sūsana, mo te tokolahi kehe, 'a ia ne'e notou tauhi kiā nātou 'aki te notou koloá. ");
INSERT INTO num_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pea kua fakataha mai he fu'u kakai tokolahi, ne notou ōmai mei te 'ū kolo kotoa pē kiā Ia, pea hanga leva 'e Ia 'o lea fakatātā kiā nātou: ");
INSERT INTO num_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ne'e 'alu atu he tangata tūtuu'i ke tūtuu'i tana pulapula. Pea 'i tana lulú, ne ngangana he me'a 'i te va'ealá; pea ne'e mala ai 'ia te kakaí, pea kai 'o 'osi 'e te fanga manupuna 'o te 'ataá. ");
INSERT INTO num_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pea toe ngangana he me'a ki te funga maká; pea 'i tana tupu aké ne'e mate ia ko te kailoa vivikú. ");
INSERT INTO num_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Pea ngangana he me'a 'e taha ki te tu'unga 'akau talatala; pea tupu ake fakataha mo ia 'ia te 'akau talatalá, 'o notou kāsia'i ia. ");
INSERT INTO num_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pea ngangana he me'a 'ihi ki te kelekele kua taau, pea 'i tana tupu aké ne'e fua ia, 'o fua teau.” Pea 'i te 'ai atu 'e Sīsū te me'a ko iá ne'e kalanga Ia, “Ko ia 'oku ma'u talinga ke fanongo 'akí, ke ongo'i ia.” ");
INSERT INTO num_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Pea ne'e 'eke ange kiā Ia 'e Tana kau akó, 'o pehē, “Ko te ā tono 'uhinga 'o te talanoa fakatātā ko 'ení?” ");
INSERT INTO num_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Pea iange 'e Ia, “Kua tuku mai kiā kōtou ke kotou 'ilo'i 'ia te 'ū misiteli 'o te Pule'anga 'o te 'Atuá; kā 'oku fai fakatātā pē ia ki tono toe 'o te kakaí; kote'uhí ke notou sio, kae kailoa tokanga, pea fanongo, kae kailoa mahino. ");
INSERT INTO num_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ko 'eni ia 'ia te talanoa fakatātā ko iá. Ko te pulapulá ko te Folafola ia 'a te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Pea ko nātou 'i te va'ealá, ko te kakai ia 'oku notou fanongo; pea toki ha'u te tēvoló, 'o 'ave 'ia te Folafolá mei te notou lotó, na'a notou tui pea mā'u'uli ai. ");
INSERT INTO num_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Pea ko nātou 'i te funga maká, ko te kakai ia 'oku notou fanongo leva mo tali fiafia 'ia te Folafolá; kā 'oku kailoa fai aka 'ia nātou, kā 'oku notou tui pē 'i te taimi ko iá, pea 'i te taimi 'ahi'ahí 'oku notou hinga leva. ");
INSERT INTO num_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Pea ko ia ne'e tō ki te 'akau talatalá, ko nātou ia ne'e fanongo ki te Folafolá, kā kote'uhí ko te lahi te notou tokanga ki te koloá mo te 'ū mālie 'o māmaní, pea 'oku kailoa ai notou fua. ");
INSERT INTO num_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pea ko ia 'oku 'i te kelekele kua leleí, ko te fa'ahinga ia 'oku notou tali 'ia te Folafolá 'aki te loto lelei mo taau, 'o notou pukenima'i ia, pea notou fua leva 'i te notou fa'a kātakí. ");
INSERT INTO num_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“'Oku kala tutu he taha tana maamá, pea pūlou'i 'aki he me'a, pē 'e tuku he lalo moe'anga; kā 'oku 'ai ia ki te tu'unga maama, kote'uhí ke sio ki tono maamá 'e nātou 'oku notou hū maí. ");
INSERT INTO num_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Hē 'oku kala he me'a 'oku lilo, kā 'e faifai pē pea e'a; pea 'oku kala he me'a 'oku fufuu'i kā 'e 'ilo'i pē ia, pea 'e hoko ia 'o fu'u mafola. ");
INSERT INTO num_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ko ia ai, kotou tokanga ki te anga 'o te kotou fanongó. He kā 'i ai he taha 'e ma'u he me'a, 'e 'avange ki ai mo he toe me'a; pea kā 'i ai he taha 'oku kailoa ina ma'u, na'a mo te me'a 'oku matamata ma'u 'e iá 'e to'o meiā ia.” ");
INSERT INTO num_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Pea ne'e ō ange kiā Ia Tana fa'eé mo Tono 'ū tokouá, ka ne'e kailoa notou lava ke ofi kiā Ia kote'uhí ko te fu'u kakaí. ");
INSERT INTO num_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Pea ne'e fakahaa'i ange kiā Sīsū, 'o pehē, “Ko Tau fa'eé mo Tou 'ū tokouá 'oku notou tutu'u mei tu'a, 'oku notou fia ma'u 'Ou.” ");
INSERT INTO num_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pea tali ange 'e Ia kiā nātou, “Ko Taku fa'eé mo Toku 'ū tokouá, ko 'eni ia, 'ia nātou pē 'oku fanongo ki te Folafola 'a te 'Atuá, mo fai ki aí.” ");
INSERT INTO num_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pea ko te 'aho 'e taha, ne'e heka Ia mo Tana kau akó he vaka; pea iange 'e Ia kiā nātou, “Tou ō ki te kauvai 'e tahá.” Pea notou tuku atu. ");
INSERT INTO num_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kā 'i te notou folaú ne'e moe Ia. Pea hifo mai he matangi mālohi ki te anovaí; pea ne'e fonu vai te vaká, pea hangē ko 'ē kā notou tu'utāmakí. ");
INSERT INTO num_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Pea notou 'unu'unu atu 'o fafangu'i 'Ona, “'Aliki, 'Aliki, 'oku tou tu'utāmaki!” Pea tu'u ake Ia, 'o lolomi te matangí mo te hou 'o te taí: pea nā tuku leva 'o tofukī. ");
INSERT INTO num_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pea iange 'e Ia kiā nātou, “Ko fea ia te kotou tuí?” Pea notou ofo 'aupito mo 'ilifia, 'o notou fepehē'aki, “Ko ai tū 'eni? He kua Ina angi'i 'ia te matangí mo te taí, pea nā fakaongo leva kiā Ia!” ");
INSERT INTO num_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Pea notou tau atu ki te fanua 'o te kakai Kēlasá, 'a ia ko he fanua 'oku hangatonu ki Kāleli. ");
INSERT INTO num_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pea 'i Tana hifo ki 'utá, ne'e fakafetaulaki mai kiā Ia he tangata mei te koló, 'a ia kua 'iā ia he fanga tēvolo, pea kua fualoa mo te kailoa tui 'e ia he kofu, mo kailoa nofo fale, kā ko te 'ū fanualotó pē. ");
INSERT INTO num_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pea 'i tana sio kiā Sīsuú, ne'e kaila ia, 'o hinga atu kiā Ia, mo pehē, “Ko Tou ā 'ia au, 'e Sīsū, ko te 'Alo 'o te 'Atua Taupotú? 'Okou kole kiā Koe, ke 'aua mu'a na'a Ke fakamamahi'i 'okú.” ");
INSERT INTO num_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","He kua fekau 'e Ia ki te fa'ahikehé ke mahu'i mai mei te tangatá. He kua fualoa tono 'āveá, pea ne'e fa'a ha'i seini 'ona, pea ma'u kii'i tono va'é; ka ne'e motuhi pē 'e ia tono 'ū ha'í, pea toki tekelele 'ona 'e te tēvoló ki te toafá. ");
INSERT INTO num_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Pea fehu'i ange 'e Sīsū kiā ia, “Ko ai tou hingoá?” Pea iange 'e ia, “Ko Kongakau 'eni,” he ne'e tokolahi te fanga tēvolo kua notou hū kiā iá. ");
INSERT INTO num_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Pea notou kole ange kiā Ia ke 'aua Ina tu'utu'uni ke notou ō mei ai ki te luo ta'ehanatakelé. ");
INSERT INTO num_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Pea ne'e 'i ai he fanga puaka tokolahi ne notou huhua 'i te ma'ungá, pea kole ange 'e te kau fa'ahikehé kiā Ia ke tukuange ke notou uulu ki te fanga monumanu ko iá. Pea tukuange leva 'e Ia. ");
INSERT INTO num_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Pea 'alu atu te fanga tēvoló mei te tangatá, 'o notou uulu ki te fanga puaká; pea 'o'oho leva te fanga monumanú 'i te taifoifo ki te anovaí, 'o notou malemo 'i ai. ");
INSERT INTO num_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pea 'i te sio ki ai 'ia te kakai ne'e tauhi nātoú, ne'e notou feholaki, 'o notou ongoongoa 'eni ki te koló mo te tuku'utá. ");
INSERT INTO num_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pea ne'e ō atu 'ia te kakaí ke vakai te me'a kua faí, pea notou ōmai kiā Sīsū, 'o 'ilo'i te tangata, 'ā ē ne'e 'alu mei ai 'ia te fanga tēvoló, kua ta'utu 'i te va'e 'o Sīsuú, kua kofu, pea kua poto; pea ne'e notou 'ilifia 'aupito. ");
INSERT INTO num_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Pea ne'e talanoa'i kiā nātou 'e te kakai ne'e notou mamata ki aí 'ia te anga tono fakama'uli 'o te tangata ne 'ulusino ai 'ia te 'ū fa'ahikehé. ");
INSERT INTO num_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pea kole ange leva 'e te kakai kotoa pē 'o te feitu'u 'o Kēlasá kiā Sīsū ke mavahe mu'a meiā nātou; he ne'e notou fu'u 'ilifia 'aupito. Ko ia ai, ne'e heka vaka Ia, 'o foki atu. ");
INSERT INTO num_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Pea ko te tangatá, 'ā ē ne'e 'alu mei ai 'ia te fanga tēvoló, ne'e kole ange 'e ia kiā Sīsū ke nā ō mo Ia; ka ne'e fekau 'ona ia 'e Sīsū ke 'alu, 'o iange ki ai, ");
INSERT INTO num_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Foki atu pē ki tou falé, 'o fakamatala'i 'ia te 'ū fu'u me'a kua fai 'e te 'Atuá ma'aú.” Pea 'alu leva ia, 'o ongoongoa ki te koló kotoa pē 'ia te 'ū fu'u me'a kua fai ma'ana 'e Sīsuú. ");
INSERT INTO num_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pea 'i te foki atu 'ia Sīsuú, ne'e talitali fiafia 'Ona 'e te kakaí; he kua notou talitali kotoa pē kiā Ia. ");
INSERT INTO num_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Pea vakai, ne'e ha'u kiā Ia he tangata, ne'e hingoa ko Sailosi, ko te toko taha ne'e pule 'i te falelotú. Pea tōmape'e atu ia 'i te va'e 'o Sīsuú, 'o kole kiā Ia ke 'alu ange mu'a ki tono 'apí, ");
INSERT INTO num_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","he 'oku taha tofu pē tono 'ofafiné, 'oku ta'u hongofulu mā ua, pea 'oku faka'a'au 'eni ia ke pekia. Pea 'i Tana 'alu angé ne'e fihia Ia 'i te fu'u kakaí. ");
INSERT INTO num_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Pea ne'e 'i ai he fafine kua ta'u hongofulu mā ua tana 'au totó, pea kua 'osi 'aupito tana me'a kotoa pē ki te kau faito'ó, mo te kala pē ha'aná sai; ");
INSERT INTO num_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","pea 'unu'unu atu ia 'i Tono tu'á, 'o ala ki te kapa 'o Tono kofú; pea matu'u ai pē tana 'aú. ");
INSERT INTO num_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Pea fehu'i 'e Sīsū 'o pehē, “Ko ai ia ne'e ala mai kiā Aú?” Pea 'i te notou tali kailoa kotoa peé, ne'e iange 'e Pita mo nātou ne'e 'iā Iá, “'Aliki, 'oku kāpui 'Ou 'e te kakaí, mo notou feta'omi atu.” ");
INSERT INTO num_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kae pehē ange 'e Sīsū, “Ka ne'e 'i ai pē te taha ia ne'e ala mai, he 'Okou 'ilo'i ne'e 'alu atu meiā Au he mālohi.” ");
INSERT INTO num_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pea 'i te mahino ki te fafiné kua kailoa tē lava ke pulí, ne'e ha'u tetetete ia, 'o hinga atu 'i Tono 'aó, 'o fakahaa'i 'i te 'ao 'o te kakai kotoa pē te 'uhinga 'o tana ala kiā Iá, pea mo tana ma'u leva te ma'ulí. ");
INSERT INTO num_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Pea toki iange 'e Sīsū kiā ia, “Nga'ata, kua fakama'uli 'ou 'e tau tuí; 'alu, 'o fiamālie pe ā.” ");
INSERT INTO num_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Pea 'i te lolotonga Tana kei leá mo te ha'u he taha mei te fale 'o te pule 'o te falelotú, 'o iange kiā ia, “Kua pekia tou 'ofafiné; 'aua toe fakaongosia'i te Tangata'alikí.” ");
INSERT INTO num_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kā 'i te fanongo ki ai 'ia Sīsuú ne'e iange 'e Ia, “'Aua 'e ke lotosi'i; kehe pē ke tui 'ia koe, pea 'e fakama'uli 'ona.” ");
INSERT INTO num_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pea 'i Tana hū leva ki te falé, ne'e kailoa Ina tuku he taha ke hū mo Ia, ngata pē 'iā Pita mo Sione, mo Sēmisi, pea mo te tamai 'a te ki'i fafiné mo tana fa'eé. ");
INSERT INTO num_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pea ne'e fai 'e te kakai kotoa pē tono tēngihiá, mo notou tangilāulau. Kae iange 'e Sīsū, “Tuku te kotou tangí; he 'oku kailoa pekia ia, kā 'oku moe pē.” ");
INSERT INTO num_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kā ne notou kakata mo manuki kiā Ia, he ne'e notou 'ilo'i lelei pē kua pekia ia. ");
INSERT INTO num_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pea puke 'e Ia tono nimá, mo iange, “Ta'ahine, tu'u ake.” ");
INSERT INTO num_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Pea ne'e foki mai tono laumālié, 'o tu'u ake ia; pea fekau 'e Sīsū ke notou 'avange he me'a ke kai. ");
INSERT INTO num_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Pea ne'e 'ohovale 'aupito te ongo mātu'a 'a te ki'i ta'ahiné, kae fekau 'e Ia kiā nāua, ke 'aua na'a nā talanoa'i te me'a nei ke 'ilo'i he taha. ");
INSERT INTO num_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Pea ne Ina fakataha'i 'ia te kau hongofulu mā uá, 'o tuku kiā nātou ke mālohi mo pule ki te kau tēvolo kotoa pē, pea ke notou fakama'uli mahaki. ");
INSERT INTO num_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Pea ne Ina fekau atu 'ia nātou ke notou malanga 'aki 'ia te Pule'anga 'o te 'Atuá, mo fakama'uli mahaki. ");
INSERT INTO num_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Pea iange 'e Ia kiā nātou, “'Aua 'e kotou to'o he me'a ki te alá, he tokotoko, pē ko he kato 'oho, pē he mā, pē he pa'anga, pē 'e kotou taki sote 'e ua. ");
INSERT INTO num_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Pea kā kotou hū he fale, kotou nofo pē 'i ai, pea toki hiki pē mei aí 'i te kotou 'alu ki te feitu'u kehe. ");
INSERT INTO num_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pea kā 'i ai he 'ihi 'e kailoa notou tali 'ia kōtou, pea kā kotou hū mai leva mei te kolo ko iá, kotou tūtuu'i tono efú mei te kotou va'é ko te faka'ilonga kiā nātou.” ");
INSERT INTO num_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Pea notou ō leva, 'o fononga atu 'i te ki'i kolo taki taha, 'o notou malanga 'aki 'ia te ongoongoleleí, mo notou fakama'uli mahaki 'i te feitu'u kotoa pē. ");
INSERT INTO num_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Pea ne'e fanongo 'e te Tu'i ko Hēlotá ki te 'ū me'a kua fai 'e Iá, pea hoha'a 'aupito ia, kote'uhí he ne'e lau he 'ihi, “Ko Sioné kua toetu'u mei te pekiá,” ");
INSERT INTO num_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","kae pehē he 'ihi, “Ko 'Ilaisiā kua hā mai;” mo te 'ihi, “Ko te toko taha 'o te kau palōfita mu'á kua toetu'u.” ");
INSERT INTO num_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pea iange leva 'e Hēlota, “Kua u tu'usi te 'ulu 'o Sioné; kā ko ai 'eni ia kua ongo mai Tana 'ū fu'u me'a peheé?” Pea ne'e feinga 'e ia ke nā fe'iloaki mo Sīsū. ");
INSERT INTO num_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pea ne'e foki mai 'ia te kau 'apōsetoló, 'o notou fakamatala kiā Sīsū 'ia te 'ū me'a kua notou faí. Pea 'ave Ia 'ia nātou, 'o ō fakaenātou pē ki te kolo ne'e ui ko Petesaita. ");
INSERT INTO num_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ka ne'e 'ilo'i pē ki ai 'e te fu'u kakaí, 'o notou mulimuli kiā Ia; pea Ina tali lelei 'ia nātou, 'o lea kiā nātou 'i te Pule'anga 'o te 'Atuá, 'o fakama'uli 'ia nātou ne'e fia ma'u faito'ó. ");
INSERT INTO num_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pea kua kamata tō te la'aá, pea ha'u te kau hongofulu mā uá, 'o notou iange kiā Ia, “Tukuange mu'a te kakaí ke notou ō ki te fanga ki'i kolo takatakaí, mo te 'ū ngoué, ke notou momoe 'i ai mo kumi 'oho; he ko te feitu'u lala 'eni 'oku tou 'i aí.” ");
INSERT INTO num_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kā ne iange 'e Ia kiā nātou, “'Avange 'e kōtou he notou kai.” Pea notou tali ange, “'Oku kala he motou me'a 'e ma'u, ko te fe'i mā pē 'e nima, mo te mata'i ika 'e ua; ka na'a ko te pehē ke motou ō 'o fakatau me'akai ma'a te fu'u kakai nei kotoa pē!” ");
INSERT INTO num_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","He ko te kakai tangatá ne'e fe'unga mo te toko nima afe nai. Pea me'a 'e Ia ki Tana kau akó, “Fekau ke notou nonofo ifo, 'o fakakalasi, 'o tautau toko nimangofulu.” ");
INSERT INTO num_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pea notou fai pehē, 'o fakanofonofo 'ia nātou kotoa pē. ");
INSERT INTO num_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pea to'o 'e Ia 'ia te fe'i mā 'e nimá, pea mo te ongo mata'i iká, 'o tangaki ake ki te langí, mo tāpuaki'i; pea pakipaki 'e Ia, mo 'avange ki Tana kau akó ke notou tufatufa ki te kakaí. ");
INSERT INTO num_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pea ne'e notou kakai, 'o mākokona kotoa pē; pea ne'e tānaki te notou mapakipaki'i mā ne'e toé, ko te kato 'e hongofulu mā ua. ");
INSERT INTO num_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pea ko te 'aho 'e taha, lolotonga te fai Tana lotú Toko taha pē, ne'e ōmai kiā Ia 'ia te kau akó; pea fehu'i ange 'e Ia kiā nātou, “Ko ai 'ia Au 'i te lau 'a te kakaí?” ");
INSERT INTO num_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Pea notou iange, “Ko Sione Papitaiso; kā ko te lau te 'ihi, ko 'Ilaisiā; pea ko te 'ihi, kua toetu'u he taha 'o te kau palōfita mu'á.” ");
INSERT INTO num_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Pea iange 'e Ia, “Kā ko ai 'ia Au 'i te kotou laú?” Pea tali 'e Pita, 'o pehē, “Ko te Kalaisi Koe 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pea ne Ina lolomi 'ia nātou, mo tu'utu'uni ke 'aua na'a notou tala'i 'eni ki he taha, ");
INSERT INTO num_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","'o iange 'e Ia, “Kua pau ki te Fanautama te Tangatá ke lahi Tono fakamamahi'í; pea 'e fakatale'i 'Ona 'e te kau mātu'á mo te kau taula'aliki lahí, mo te kau sikalaipé, pea 'e tāmate'i Ia; pea 'e fokotu'u ake Ia 'i tono 'aho tolú.” ");
INSERT INTO num_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pea lea ange 'e Ia kiā nātou kotoa pē, “Kā 'i ai he taha 'oku fia mulimuli mai kiā Au, kua pau ke tuku 'e ia tono lotó, pea fua tono kolosí 'i te 'aho kotoa pē, 'o mulimuli mai kiā Au. ");
INSERT INTO num_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","He ko ia 'oku feinga ke kalofaki tana ma'ulí, ko tana tuku ia ke molé; kā ko ia 'e tuku tana ma'ulí ke mole kote'uhí ko Aú, ko 'eni ia 'oku fakahaofi iá. ");
INSERT INTO num_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","He ko te ā tono 'aonga ki te tangatá kāpau 'e ma'u 'e ia 'ia māmani fuli pē, kae mole ai tana ma'ulí, pe si'aki ia? ");
INSERT INTO num_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","He ko ia 'e maa'i 'Oku mo Taku 'ū leá, 'e maa'i te toko taha ko iá 'e te Fanautama te Tangatá, 'o kā hā'ele mai Ia mo Tono nāunaú, pea mo te nāunau 'o Tana Tamaí, pea mo te nāunau 'o te kau 'āngelo mā'oni'oní. ");
INSERT INTO num_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pea 'Okou fakapapau atu, 'oku 'i ai he 'ihi 'iā nātou 'oku tutu'u hená, 'e kailoa notou mama'i lave ki te maté, kae'aua ke notou mamata ki te Pule'anga 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Pea kua 'osi nai he 'aho 'e valu, 'i te 'osi ange Tana 'ū lea ko iá, pea ne'e 'ave 'e Ia 'ia Pita mo Sione mo Sēmisi, 'o notou ō ake ki te ma'ungá ke lotu. ");
INSERT INTO num_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Pea 'i te lolotonga pē Tana kei lotú, kua liliu Tono fōtungá, mo Tono kofú ne'e hina ekiaki, pea tatapa ngingila ia hangē ko te 'uhilá. ");
INSERT INTO num_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Pea vakai, ko te ongo tangata 'ena 'oku nā talanoa mo Ia, 'a ia ko Mōsese mo 'Ilaisiā; ");
INSERT INTO num_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ne'e hā lāngilangi'ina 'ia nāua, 'o notou alea ki Tana pekiá, 'a ē 'oku Ina teu ke fai 'i Selusalemá. ");
INSERT INTO num_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pea ko Pita mo nāua ne'e notou 'i aí kua notou tulemoe; kā 'i te notou 'a'ala lelei aké ne'e notou sisio atu ki Tana lāngilangi'iná, pea mo te ongo tangata 'oku nā tutu'u mo Iá. ");
INSERT INTO num_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Pea 'i te faifaí pea nā kamata 'alu atu meiā Iá, ne'e iange 'e Pita kiā Sīsū, “'Aliki, 'oku sai te tou 'i hení, kae motou ngaahi mu'a he palepale 'e tolu; 'o taha Mo'ou, pea taha mo'o Mōsese, pea taha mo'o 'Ilaisiā;” ka ne'e kailoa 'ilo'i 'e ia tana lea ko iá. ");
INSERT INTO num_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pea 'i te lolotonga tana lea peheé, ne'e hoko mai he 'ao 'o fakapūlou'i nātou; pea ne'e notou manahē 'i te notou hū ki te 'aó. ");
INSERT INTO num_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pea ne'e hoko mai he le'o mei te 'aó 'oku folafola mai, “Ko Toku 'Alo Pelé 'ena kua U filí; kotou fakaongo kiā Ia!” ");
INSERT INTO num_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pea 'i te hoko mai te le'ó, ko Sīsū pē ne'e 'iloá Toko Taha pē. Pea ne'e notou fakalongolongo pē, pea ne'e kailoa notou fakahā ki he taha 'i te taimi ko iá he mama'i me'a 'e taha ne'e notou sisio ki ai. ");
INSERT INTO num_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pea 'i te pongipongi aké, ne'e notou 'ō ifo mei te ma'ungá, pea fakafetaulaki mai kiā Ia he fu'u kakai. ");
INSERT INTO num_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Pea vakai, ne'e kaila mai he tangata mei te loto kakaí, 'o pehē, “Tangata'aliki, 'okou kole atu kiā Koe, ke ke me'a mai ki toku 'uhikí; he ko si'aku ki'i fohá pē ia 'e taha. ");
INSERT INTO num_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Pea vakai ange, 'oku fa'a 'ohofi 'ona 'e te fa'ahikehe; pea fokifā pē kua kaila ia; mo tekelili, 'o a'u ki te koa tono ngutú; mo fu'u ha'aki 'e ia 'ona, pea 'oku faingata'a tana mahu'i mai mei aí. ");
INSERT INTO num_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Pea ne au kole ange ki Tau kau akó ke notou kapusi 'ona, ka ne'e kailoa notou lava.” ");
INSERT INTO num_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Pea tali ange 'e Sīsū, 'o pehē, “'Ia te fa'ahinga ta'etui mo ongongata'a, 'e ngata 'āfea Taku feangai mo kōtoú, mo Taku kātaki'i 'ia kōtoú? Taki mai ki heni tou fohá.” ");
INSERT INTO num_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pea lolotonga pē tana 'unu'unu maí, ne'e ha'aki 'ona 'e te tēvoló, mo 'ai tono fu'u fakatekelili'i. Ka ne'e lolomi 'e Sīsū 'ia te fa'ahikehé, 'o fakama'uli te tamá, mo 'avange ki tana tamaí. ");
INSERT INTO num_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pea ne'e notou fakatumutumu kotoa pē 'i te māfimafi 'o te 'Atuá. Pea 'i te lolotonga te notou ofoofo 'i te 'ū me'a kotoa pē ne'e faí, ne'e lea ange Ia ki Tana kau akó, ");
INSERT INTO num_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Tuku ke ongo ki te kotou talingá 'ia te 'ū lea ko 'ení: 'e tukuange 'ia te Fanautama te Tangatá ki te nima 'o te kakaí.” ");
INSERT INTO num_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ka ne'e kailoa notou 'ilo'i tono 'uhinga 'o te lea ko iá, pea ne'e tuku fufuu'i pē ia meiā nātou ke 'aua na'a notou 'ilo'i te me'a nei; pea ne'e notou manahē ke toe fehu'i kiā Ia 'i te lea ko iá. ");
INSERT INTO num_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Pea ne'e fai he felau'aki 'i te kau akó, pē ko ai koā 'iā nātou 'oku lahí. ");
INSERT INTO num_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kā ne 'ilo'i pē 'e Sīsū te fifili 'i te notou lotó, 'o puke mai 'e Ia he tamasi'i, 'o tuku 'i Tono tafa'akí, ");
INSERT INTO num_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","pea iange 'e Ia kiā nātou, “Ko ia ko 'ē 'e tali 'ia te tamasi'i nei 'i Toku hingoá, 'oku tali 'e ia 'ia Au; pea ko ia 'e tali 'ia Aú, kua ina tali 'ia Ia ne'e fekau mai 'Okú. He ko ia 'oku si'i taha 'iā kōtoú, ko 'eni ia 'oku lahí.” ");
INSERT INTO num_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Pea iange 'e Sione kiā Ia, “'Aliki, ne'e motou 'ilo'i he taha 'oku kapusi tēvolo 'i Tou huafá; pea ne'e motou ta'ofi ia, hē 'oku kailoa ina kau 'i te mulimulí fakataha mo mātou.” ");
INSERT INTO num_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ka ne'e iange 'e Sīsū kiā ia, “'Aua 'e ta'ofi iá; he ko ia 'oku kala angatu'u kiā kōtoú, 'oku tu'u ia ma'a kōtou.” ");
INSERT INTO num_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Pea faifaí pea kua vave te taimi ke 'avake ai 'ia Sīsū mei māmaní, pea ne'e fakapapau'i 'e Ia 'i Tono lotó ke 'alu ki Selusalema. ");
INSERT INTO num_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Pea ne Ina fekau'i atu he kau talafekau ke notou fakamelomelo kiā Ia; pea 'i te notou fononga atú, ne'e notou hū he ki'i kolo 'o te kau Samēliá kote'uhí ke notou teuteu ki Tana a'u atú. ");
INSERT INTO num_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ka ne'e kailoa notou fia talitali 'Ona, kote'uhí ko te hu'u Ta'aná fononga ki Selusalema. ");
INSERT INTO num_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pea 'i te sio ki ai Tana ongo akó, 'ia Sēmisi mo Sione, ne nā iange, “'Aliki, 'oku Ke loto ke mā fekau ke tō ifo he afi mei te langí, 'o faka'auha 'ia nātou?” ");
INSERT INTO num_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pea tafoki Ia 'o valoki'i 'ia nāua; ");
INSERT INTO num_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","pea notou ō leva ki te ki'i kolo kehe. ");
INSERT INTO num_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pea 'i te notou ō atu 'i te alá, ne'e lea ange he toko taha kiā Ia, 'o pehē, “'Aliki, 'e au mulimuli kiā Koe, neongo pe ko te fea he feitu'u 'e Ke me'a ki aí.” ");
INSERT INTO num_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Pea iange 'e Sīsū kiā ia, “Ko te fanga fōkisí 'oku 'i ai he notou tafu, mo te fanga manupuna 'o te 'ataá he notou pununga; kā ko te Fanautama te Tangatá 'oku kailoa si'a feitu'u ke 'olunga ai To'onó 'ulu.” ");
INSERT INTO num_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Pea me'a 'e Ia ki te toko taha kehe, “Mulimuli mai koe kiā Au.” Ka ne'e tali ange 'e ia, “'Aliki, tuku mai mu'a 'oku ke au 'alu 'o tanu si'aku tamaí.” ");
INSERT INTO num_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Pea iange 'e Sīsū ki ai, “Tuku ki te kau maté ke tanu te notou mate 'a nātoú; kā ke 'alu koe ia 'o malanga 'aki 'ia te Pule'anga 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Pea iange kiā Ia he taha kehe foki, “'Aliki, 'e au mulimuli kiā Koe; kae tuku mai ke au fu'aki 'alu 'o fakamāvae mo nātou 'i 'apí.” ");
INSERT INTO num_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ka ne'e iange 'e Sīsū kiā Ia, “Ko ia 'oku ala ke faka'uli 'ia te palaú, mo toe fakasio ki te 'ū me'a 'i mulí, 'oku kailoa tuha ia mo te Pule'anga 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pea 'i te 'osi ange te 'ū me'a ko iá, ne'e fakanofo 'e te 'Alikí he 'ihi kehe 'e toko fitungofulu, 'o fekau'i atu 'ia nātou, 'o tautau toko ua, ke notou fakamelomelo kiā Ia ki te kolo mo te feitu'u fuli pē 'oku teu 'alu atu Ia ki aí. ");
INSERT INTO num_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Pea iange 'e Ia kiā nātou, “Kua lahi 'ia te ta'ú, kā 'oku kaungatāmaki 'ia te kau ngāué. Ko ia ai kotou kole ki te 'Aliki 'oku 'A'ana te ta'ú, ke fekau'i atu mo he kau ngāue ke utu mai Tana ta'ú. ");
INSERT INTO num_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kotou ō; he ko 'eni, 'Okou tuku atu 'ia kōtou ke kotou hangē ko he fanga lami 'i te lotolotonga 'o te fanga ulofí. ");
INSERT INTO num_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","'Aua 'e kotou to'o he kato pa'anga, pē he kato 'oho, pē he 'ū senitolo; pea 'aua 'aupito 'e fetapa mo he taha 'i te alá. ");
INSERT INTO num_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pea 'ilonga he fale 'e kotou hū ki ai, kotou fu'aki iange 'o pehē, ‘Ke 'i te fale nei te fiamālié.’ ");
INSERT INTO num_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Pea kāpau leva 'oku 'i ai he hoani 'o te kotou 'ofá, pea 'e nofo mai kiā ia te kotou tāpuakí; kae kā kailoa, pea 'e foki pē ia kiā kōtou. ");
INSERT INTO num_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Pea kotou nonofo 'i te fale pē ko iá, 'o kotou kakai 'i ai mo iinu 'ia te 'ū me'a 'e notou 'aumaí. He 'oku taau 'ia te tangata 'oku ngāué ke ma'u ha'aná totongi. 'Aua 'e kotou hiki mei te fale ki te fale. ");
INSERT INTO num_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Pea kā 'i ai he kolo 'e kotou hū ki ai, pea notou tali 'ia kōtou, kotou kai 'ia te me'akai 'e notou tuku 'i te kotou 'aó. ");
INSERT INTO num_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pea kotou fakama'uli te kakai 'i te koló 'a ē 'oku mahaki'iná, pea kotou iange kiā nātou, “Kua ofi mai kiā kōtou 'ia te Pule'anga 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pea kā 'i ai leva he kolo 'e kotou hū ki ai, pea 'oku kala notou tali 'ia kōtou, kotou ō atu leva ki te 'ū mala'e 'o te koló, 'o kotou iange, ");
INSERT INTO num_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Na'a mo te efu 'o te kotou koló, 'a ē kua piki ki te motou va'é, 'oku motou holoholo'i atu; kā neongo ia, kotou 'ilo'i mu'a 'ia te me'a nei: kua ofi mai 'ia te Pule'anga 'o te 'Atuá.’ ");
INSERT INTO num_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Pea ko 'eni 'Okou tala'i atu, 'e kātaki'ingafua ange 'ia Sōtoma 'i te 'aho ko iá, 'i te kolo ko iá. ");
INSERT INTO num_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Pohoē 'ia koe, Kōlesini! Pohoē 'ia koe, Petesaita! He ka ne kua fai 'i Taia mo Saitoni 'ia te 'ū ngāue mamafa ne'e fai 'iā kōluá, ne fualoa pē te notou fakatomala, 'o nonofo mo te tauanga'a mo te pani efu. ");
INSERT INTO num_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kā 'e kātaki'ingafua ange 'i te 'Aho Fakamaaú 'ia Taia mo Saitoni 'iā kōlua. ");
INSERT INTO num_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Pea ko koe foki Kāpaneume, 'e hiki koā 'ou ki hēvani? 'E 'ave ifo 'ou ia ki Hētesi. ");
INSERT INTO num_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ko ia 'oku fakaongo kiā kōtoú, 'oku fakaongo kiā Au; pea ko ia 'oku si'aki 'ia kōtoú, 'oku si'aki 'e ia 'ia Au; pea ko ia kua ina si'aki 'ia Aú kua ina si'aki 'ia Ia ne Ina fekau'i mai 'Okú.” ");
INSERT INTO num_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pea ne'e foki fiafia mai 'ia te kau fitungofulú, 'o notou iange kiā Ia, “'Aliki, na'a mo te fanga tēvoló 'oku notou vaivai mai kiā mātou kote'uhí ko Tou huafá.” ");
INSERT INTO num_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Pea iange 'e Ia kiā nātou, “Ne Au sio ake ki te tō ifo 'ia Sētane mei te langí, hangē he 'uhilá. ");
INSERT INTO num_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Vakai, 'Okou tuku atu kiā kōtou 'ia te mafai ke malaki 'ia te fanga ngatá mo te fanga sikapió, pea mo te ngāue kotoa pē 'a te Filí; pea 'e kailoa 'aupito he me'a ia 'e lavea ai 'ia kōtou. ");
INSERT INTO num_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kā neongo iá, kae 'aua 'e kotou fiafia 'i te me'a ko iá, 'i te vaivai 'ia te 'ū fa'ahikehé kiā kōtoú; kā ko te me'a pē ke kotou fiafia aí, ko te tu'u te kotou 'ū hingoá 'i te tohi 'i hēvaní.” ");
INSERT INTO num_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","'I te houa pē ko iá ne'e fiafia 'ia Sīsū 'i te Laumālié Mā'oni'oní, 'o pehē 'e Ia, “'Okou fakafeta'i atu kiā Koe, 'e Tamai, ko te 'Aliki 'o langi mo māmaní, 'i Tau fufuu'i te 'ū me'a peheé mei he kakai 'oku poto mo 'ilo'iló, kā Ke tatala pē ki te kau tamaliki; 'io, 'e Tamai, tonuhia pē To'oú finangalo ke pehē. ");
INSERT INTO num_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kua tuku mai kiā Au 'e Taku Tamaí 'ia te 'ū me'a kotoa pē; pea 'oku kailoa he toko taha 'oku 'ilo'i pe ko ai 'ia te 'Aló, kā ko te Tamaí pē; pē ko ai 'ia te Tamaí, kā ko te 'Aló pē, pea mo he taha 'e loto te 'Aló ke faka'ilo 'Ona ki aí.” ");
INSERT INTO num_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pea toki tafoki leva Ia 'o lea ki te kau akó fakaenātou pē, 'o iange, “Manū'ia ā ko te 'ū mata kua notou sisio ki te 'ū me'a 'oku kotou sisio ki aí. ");
INSERT INTO num_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Hē 'Okou tala'i atu, kua tokolahi te kau palōfita, mo te 'ū tu'i, ne'e notou holi ke mamata ki te 'ū me'a 'oku kotou sisio ki aí, ka ne'e kailoa notou mamata; pea ke notou fanongo ki te 'ū me'a 'oku kotou fānonongo ki aí, ka ne'e kala notou fanongoa.” ");
INSERT INTO num_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Pea vakai, ne'e tu'u ake he tufunga lao ke 'ahi'ahi'i 'Ona, 'o iange 'e ia, “Tangata'aliki, ko te ā he me'a 'e au fai kae tō mo'oku 'ia te ma'uli ta'engatá?” ");
INSERT INTO num_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Pea iange leva 'e Ia ki ai, “Ko te ā te me'a kua tohi 'i te Laó? 'Oku fefe'aki tau laú?” ");
INSERT INTO num_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Pea tali ange ia 'o pehē, “'E ke 'ofa ki te 'Alikí ko tou 'Atuá, 'o fai 'aki te kotoa 'o tou lotó, mo te kotoa 'o tou laumālié, mo te kotoa 'o tou iví, mo te kotoa 'o tou 'atamaí; pea 'e ke 'ofa ki tou kaungā'apí 'o hangē pē ko tau 'ofa kiā koé.” ");
INSERT INTO num_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Pea me'a ange 'e Ia ki ai, “Totonu 'aupito ta'aú tali; fai leva ia, pea 'e ma'uli 'ia koe.” ");
INSERT INTO num_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kā 'i tana fia fakatonuhia'i iá, ne'e iange 'e ia kiā Sīsū, “He ko ai koā toku kaungā'apí?” ");
INSERT INTO num_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Pea tali ange 'e Sīsū, 'o pehē, “Ne'e 'i ai he tangata ne'e 'alu ifo mei Selusalema ki Selikō, pea ne'e 'ohofi 'ona 'e te kau kaiha'a; pea ne'e notou to'o tono kofú, mo taa'i 'ona, pea 'i te notou tukuange 'ona 'o notou 'alú, kua kafo lahi ia, 'o teitei mate. ");
INSERT INTO num_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Pea fe'unga mo iá mo te 'alu ifo he taula'aliki 'i te ala ko iá; pea 'i tana sio leva ki te tangatá, ne'e afe ia ki te kauala 'e tahá. ");
INSERT INTO num_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Pehē foki mo he matu'a Līvaite, ne'e 'alu ifo 'i te ala ko iá, pea 'alu atu ia 'o sió, pea afe mo ia 'i te kauala 'e tahá. ");
INSERT INTO num_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kā 'i te fononga mai leva he tangata Samēlia, ne'e a'u atu ia ki te tangatá, pea 'i tana sio ki aí ne'e langa tono fatú 'i te 'ofa; ");
INSERT INTO num_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","pea toki 'unu'unu atu ia, 'o tulu'i tono 'ū laveá 'aki te lolo mo te uaine, mo ha'iha'i; pea toki fakaheka 'e ia 'ona ki tana 'así, 'o taki atu ki te fale tali fonongá, 'o tauhi 'ona 'i ai. ");
INSERT INTO num_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pea 'i te pongipongi aké, ne'e to'o mai 'e ia he fe'i tēnali 'e ua, 'o 'avange ki te matu'a ne'e tauhi 'ia te fale tali fonongá, mo iange, ‘Ke ke tauhi pē te tangatá 'i heni; pea kāpau 'oku si'isi'i 'eni, pea 'i taku foki maí 'e au totongi atu 'e au hau me'a kua mole 'i ai.’ ");
INSERT INTO num_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ko ai leva ia 'i te toko tolu ko 'ení, 'i tau laú, ne'e hoko ko te kaungā'api 'o te siana ne'e ma'ua 'i te kau kaiha'á?” ");
INSERT INTO num_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Pea tali ange 'e ia, “Ko ia ko 'ē ne'e fai 'ofa ki te tangatá.” Pea iange 'e Sīsū kiā Ia, “'Alu, 'o fai pehē mo koe foki.” ");
INSERT INTO num_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Pea 'i te lolotonga te notou fonongá, takua ne'e 'alu atu Ia ki te ki'i kolo 'e taha; pea ko he fafine ne'e hingoa ko Mā'ata ne'e fakaafe'i 'Ona ki tono falé. ");
INSERT INTO num_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Pea ne'e 'i ai tono tehina ne'e ui ko Mele, pea ko te fafine ko iá ne'e fāite atu 'i te va'e 'o Sīsuú, 'o fakafanongo ki Tana 'ū fakahinohinó. ");
INSERT INTO num_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kae femo'uekina 'ia Mā'ata, 'i te fai 'o he fu'u teuteu; pea tu'u mai ia 'o iange, “'Aliki, 'oku kala Ke tokanga'i koā tono tukuange 'oku 'e toku tehiná ke au fai toko taha pē 'ia te teuteú? Ko ia ke Ke fekau mu'a kiā ia ke tokoni mai kiā au!” ");
INSERT INTO num_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kae toki tali ange 'e Sīsū kiā ia, “'E Mā'ata, Mā'ata, 'oku lotoma'ua 'ia koe mo hoha'a ki te 'ū me'a kehekehe, ");
INSERT INTO num_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kā 'oku mahu'inga pē he me'a 'e taha; pea vakai, kua fili 'e Mele 'ia te me'a 'oku leleí, 'a ia foki 'e kailoa to'o meiā ia.” ");
INSERT INTO num_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ne'e fai te lotu 'a Sīsū 'i te feitu'u 'e taha; pea 'i Tana tukú ne'e lea ange he toko taha 'i Tana kau akó, 'o pehē, “'Aliki, ako'i mu'a 'ia mātou ke fai he lotu, hangē foki ko tono ako'i 'e Sione tana kau ako 'a'aná.” ");
INSERT INTO num_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Pea iange 'e Ia kiā nātou, “Kāpau 'e kotou lotu, pea kotou pehē, ‘'E Tamai, ke tāpuhā Tou Huafá. Ke hoko mai Tau Pulé. ");
INSERT INTO num_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ke foaki mai he motou me'akai ki te 'ānaí, 'o hokohoko 'aho pē. ");
INSERT INTO num_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pea fakamolemole'i te motou 'ū angahalá, he ko mātoú foki 'oku motou fakamolemole'i 'ia nātou fuli pē 'oku ma'ua maí. Pea 'aua na'a fakahū 'ia mātou ki te 'ahi'ahí.’ ” ");
INSERT INTO num_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ne'e iange foki 'e Ia kiā nātou, “Ko ai 'iā kōtou 'e 'i ai tono kaume'a, 'e 'alu atu kiā ia 'i te tu'ulapoó, 'o iange, ‘'Alā, ke ke tuku mai mu'a he fe'i mā 'e tolu, ");
INSERT INTO num_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","he ko te kāinga 'o'oku kua afe mai kiā au, pea 'oku kala haku me'a ke tali 'aki.’ ");
INSERT INTO num_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Pea toki tali mai 'e ia mei falé, ‘Tuku tau fakafiu'i mai 'okú; he kua songo te matapaá, pea ko ta'akú fānau kua motou 'i te moe'angá mo au; 'oku kailoa ke au lava tu'u ake ke 'avatu.’ ");
INSERT INTO num_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Tala'i atu, 'e kala ina tu'u ia 'o 'avatu kote'uhí ko te nā kaume'á; kā kote'uhí ko tana ta'emangoí, 'e tu'u ake ai ia 'o 'avange kātoa tana fia ma'ú. ");
INSERT INTO num_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Tala'i atu foki: kole, pea 'e 'avatu kiā kōtou; kumi, pea 'e kotou 'ilo'i; tukituki, pea 'e to'o kiā kōtou. ");
INSERT INTO num_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","He ko ia kotoa pē 'oku kolé, 'oku ma'u; pea ko ia 'oku kumí, 'oku 'ilo'i; pea ko ia 'oku tukitukí 'e to'o kiā ia. ");
INSERT INTO num_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Pea ko te tamai fea ia 'iā kōtou, kāpau 'e kole mā ange tono fohá, 'e 'avange koā ia he fe'i maka? Pe ko he ika, 'e tuku 'ia te iká kae 'avange ki ai he ngata? ");
INSERT INTO num_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Pea kāpau 'e kole ange ia he fe'i moa, 'e 'avange koā ia he sikapio? ");
INSERT INTO num_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pea kāpau leva 'oku kotou 'ilo'i ke 'avatu me'a'ofa lelei ki te kotou fānaú, neongo ko te fa'ahinga kovi 'ia kōtou, huanoa te Tamai 'i te langí Tana 'avatu te Laumālie Mā'oni'oní kiā nātou fuli pē 'oku kole kiā Iá.” ");
INSERT INTO num_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pea ne'e kapusi ai 'e Ia he fa'ahikehe fakanoa. Pea 'i te mahu'i atu te fa'ahikehé ne'e toki lea te noá; pea ne'e ofo 'aupito heni 'ia te kakaí. ");
INSERT INTO num_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ka ne'e pehē he 'ihi ia, “'Oku fai 'e Ia Tana kapusi tēvoló 'iā Pelisipupe ko te 'aliki 'o te kau tēvoló.” ");
INSERT INTO num_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Pea ko te 'ihi kehe ne'e notou vili ange ke 'aumai 'e Ia he faka'ilonga mei langi, ko te notou 'ahi'ahi'i 'Ona. ");
INSERT INTO num_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ka ne'e mea'i pē 'e Ia te notou fakakaukaú, 'o iange kiā nātou, “Kā 'i ai leva he pule'anga 'oku māvahevahe mo fetu'usi, 'e 'auha ia; pea kā 'i ai he fāmili 'oku notou māvahevahe mo fetu'usi, 'e mavete ia. ");
INSERT INTO num_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Pea ko Sētane foki, kāpau leva 'e māvahevahe ia 'o fetu'usi mo ia pē, pea tu'u fefe'aki leva tono pule'angá? Kote'uhí foki kua kotou pehē, ko Pelisipupe 'Okou fai ai Taku kapusi tēvoló. ");
INSERT INTO num_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pea ko 'eni, kāpau leva 'Okou fai Taku kapusi tēvoló 'iā Pelisipupe, pea 'oku fai leva 'iā ai 'e te kotou kau tamá? Ko ia, ko nātou ia 'e kotou halaia mei aí. ");
INSERT INTO num_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kae kāpau leva ko te ivi 'o te 'Atuá 'Okou fai ai Taku kapusi tēvoló, pea tā kua a'u mai kiā kōtou 'ia te Pule'anga 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kā 'ai mahafu leva he to'a, 'o le'ohi tono falé, 'e malu tana 'ū me'á; ");
INSERT INTO num_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","kae kā 'iloangé 'e ha'u he toko taha 'oku mālohi angé, 'o ikuna'i 'ona, mo 'ave tana mahafu kotoa pē, 'a ē ne falala ia ki aí, pea 'e toki tufaki 'e ia ta'aná koloa. ");
INSERT INTO num_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ko ia 'oku kailoa kau mo Aú, 'oku angatu'u ia kiā Au; pea ko ia 'oku kailoa ina kau mo Au 'i te tānakí, 'oku fakamaveuveu ia. ");
INSERT INTO num_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kā 'alu atu leva 'ia te fa'ahikehé mei te tangatá, 'oku 'osiki ia 'ia te 'ū feitu'u moamoá tana 'alu'i, ko te kumi he mālōlō'anga; pea kā kailoa ma'u, 'oku pehē leva ia, ‘Ke au foki mu'a ki toku falé, 'a ē ne au 'alu mei aí.’ ");
INSERT INTO num_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Pea 'i tana a'u maí, 'oku sio atu ia kua tafi mo teuteu'i. ");
INSERT INTO num_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Toki 'alu leva ia 'o tānaki mai mo he fa'ahikehe 'e fitu kehe, ko he fa'ahinga 'oku kovi ange 'iā ia; pea notou uulu mai 'o nonofo 'i ai. Pea toki hoko ai ki te tangata ko iá 'o lahi ange tana kovi ki mulí 'i te kovi ki mu'á.” ");
INSERT INTO num_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Pea 'i te lolotonga Tana lea peheé, ne'e kalanga mai he fafine mei te kakaí, “Manū'ia ā ko te manava ne Ke takoto aí, mo te ongo huhu ne Ke huhu aí!” ");
INSERT INTO num_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kae tali ange 'e Ia, “'Ē, 'oku manū'ia pē 'ia nātou 'oku notou ma'u 'ia te Folafola 'a te 'Atuá, 'o tauhi ki aí.” ");
INSERT INTO num_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Pea 'i te tokolahi mai 'ia te fu'u kakaí, ne'e lea ange 'e Ia 'o pehē, “Ko te to'utangata anga-kovi 'eni. 'Oku fia ma'u 'e ia he faka'ilonga, kā 'oku kailoa he faka'ilonga 'e 'avange, ngata pē 'i te faka'ilonga 'o Sioná. ");
INSERT INTO num_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","He 'oku hangē ne'e hoko 'ia Siona ko te faka'ilonga ki te kakai Ninivé, 'e pehē foki mo te Fanautama te Tangatá ki te to'utangata nei. ");
INSERT INTO num_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","'E tutu'u 'i te fakamaaú 'ia te kuini 'o te feitu'u Tongá pea mo te kau tangata 'o te to'utangata nei, pea 'e fakahalaia'i 'e ia 'ia nātou; he ne'e ha'u ia mei te ngata'anga 'o māmaní ke fanongo ki te poto 'o Solomoné; kae vakai, 'oku 'i heni he Taha ia 'oku lahi ange 'iā Solomone. ");
INSERT INTO num_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","'E hopo mo te to'utangata nei 'i te fakamaaú 'ia te kakai Ninivé, pea 'e notou fakahalaia'i 'ona, he ne'e fakatomala 'ia nātou 'i te malanga 'a Sioná; kae vakai, 'oku 'i heni he Taha ia 'oku lahi ange 'iā Siona. ");
INSERT INTO num_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“'Oku kailoa he taha ia 'oku tutu maama pea fufuu'i 'i te loto 'ana, pe fa'o ki te loto puha; kā 'oku 'ai ia ki te tu'unga maama, kote'uhí ke sio ki tono maamá 'e nātou 'oku hū maí. ");
INSERT INTO num_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ko te māma'anga 'o te sinó ko tou matá: kā haohaoa te sio tou matá, pea 'e maama tou sinó kotoa; kae kāpau 'e kovi tou matá, pea fakapō'uli leva tou sinó. ");
INSERT INTO num_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ko ia, ke vakai'i 'ou na'a ko te koto pō'uli ia, 'ia te me'a 'iā koe ne'e ngaahi ke fakamaamá. ");
INSERT INTO num_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Pea kāpau 'oku māmangia tou sinó fuli pē, 'o kailoa hana feitu'u 'e fakapō'uli, pea 'e toki māmangia kotoa pē, 'o hangē ko te hulu'ina 'ou he maama 'oku ulo lahi.” ");
INSERT INTO num_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pea 'i te lolotonga Tana leá, kua fakaafe'i 'Ona 'e te matu'a Fālesi, ke nā ma'u me'atokoni. Pea hū leva Ia, 'o nofo ifo ke kai. ");
INSERT INTO num_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kā ko te Fālesí, 'i tana sio ki aí, ne'e 'ohovale lahi ia 'i te kailoa fu'aki fanofano Ia, pea toki kaí. ");
INSERT INTO num_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kae toki me'a ange te 'Alikí kiā ia, “Vakai ange ā 'ia kōtou Fālesí, 'oku kotou fufulu 'ia te tu'a ipú mo te peletí, kā ko te kotou lotó kua fonu ai 'ia te fakamālohí mo te faikoví. ");
INSERT INTO num_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","'Ia te kau vale! Ko Ia ne Ina ngaahi 'ia tu'á, ne'e kailoa koā ne Ina ngaahi mo loto foki? ");
INSERT INTO num_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kae kotou me'a'ofa 'aki mu'a ki te masivá 'ia te 'ū me'a 'oku kotou ma'ú, pea vakai, kua ma'a leva te 'ū me'a kotoa pē kiā kōtou. ");
INSERT INTO num_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Kae pohoē 'ia kōtou Fālesí! Hē 'oku kotou 'avatu te vahe hongofulu 'o te minité mo te pēkanó mo te fa'ahinga mahuku kai kehekehe; kae kotou si'aki 'ia te fakamaau totonú mo te 'ofa faka-'Atuá. Ne'e totonu ke kotou fai 'eni, pea 'aua foki na'a si'aki 'ena. ");
INSERT INTO num_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Pohoē 'ia kōtou Fālesí! Hē 'oku kotou manako ke nofo ki mu'a 'i te falelotú, mo tono faka'apa'apa'ina 'i te mala'e fakataú. ");
INSERT INTO num_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Pohoē 'ia kōtou! Hē 'oku kotou tatau mo te 'ū fanualoto 'oku kailoa hā mai, pea 'oku mala ai 'ia te kakaí 'o kailoa notou 'ilo'i.” ");
INSERT INTO num_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Pea toki lea mai he toko taha 'o te kau tufunga laó, “Tangata'aliki, ko Tau lea peheé leva 'oku lavea ai mo mātou foki.” ");
INSERT INTO num_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pea folafola ange 'e Ia, “Pohoē 'ia kōtou, kau tufunga laó! Hē 'oku kotou fakauta ki te kakaí he 'ū kavenga mamafa; kae kailoa kotou ala kōtou ki te 'ū kavenga ko iá 'aki he fe'i tuhu. ");
INSERT INTO num_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Pohoē 'ia kōtou! Hē 'oku kotou langafale'i 'ia te 'ū fanualoto 'o te kau palōfitá, kā ko te kotou mātu'a 'i mu'á ia ne'e tāmate'i 'ia nātoú. ");
INSERT INTO num_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Tā kua kotou fakamo'oni'i pē te 'ū ngāue 'a te kotou mātu'a 'i mu'á, mo fakahaa'i ai te kotou loto lelei ki aí; he ne'e 'a nātou 'ia te tāmate'í, pea 'a kōtou leva te notou langafale'í. ");
INSERT INTO num_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ko tono ō pē ia foki 'o te folafola mai 'e te poto 'o te 'Atuá, 'o pehē, ‘'E Au fekau atu kiā nātou he kau palōfita mo he kau 'apōsetolo, pea 'e notou tāmate'i te notou 'ihi mo fakatanga'i.’ ");
INSERT INTO num_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kote'uhí ke 'eke tāupaua'i ki te to'utangata nei 'ia te toto kotoa pē 'o te kau palōfitá, 'a ia kua lilingi talu mei te tanupou 'o māmaní, ");
INSERT INTO num_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","mei te toto 'o 'Ēpelí, 'o a'u ki te toto 'o Sākalaiá, 'ā ē ne'e tāmate'i 'i te vaha'a 'o te 'ōlitá mo te Fale Tapú. 'Io, 'Okou tala'i atu, 'e 'eke tāupaua'i ia ki te to'utangata ko 'ení. ");
INSERT INTO num_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Pohoē 'ia kōtou, 'ia te kau tufunga lao! Hē kua kotou 'ave te kī ki te potó; kua kailoa kotou hū ki ai 'e kōtou, pea kua kotou ta'ofi mo nātou ne'e notou mei huú.” ");
INSERT INTO num_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pea 'i Tana 'alu atu mei te feitu'u ko iá, ne'e hanga leva 'e te kau sikalaipé mo te kau Fālesí, 'o notou feta'omi mai, ko te me'a faka'ulia, mo notou fehu'i kiā Ia 'ia te 'ū me'a lahi; ");
INSERT INTO num_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ko te notou lamalama kiā Ia ke ma'u Ha'aná lea hala, ke notou tukuaki'i 'aki 'Ona. ");
INSERT INTO num_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Pea lolotonga iá kua fakataha ange he fu'u kakai 'oku ta'efa'alaua, pea ne'e iku ai 'o tāmalaki he 'ihi; pea toki lea Ia, 'o kamata mei Tana kau akó, 'o pehē, “Kotou lamalama 'ia kōtou, talia 'ia te lēvani 'a te kau Fālesí, 'a ia ko te koto mālualohi. ");
INSERT INTO num_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Hē 'oku kailoa he me'a ia kua 'ufi'ufi 'e ta'efakahaa'i; pē 'e fufū 'e ta'e'ilo'i. ");
INSERT INTO num_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ko ia ai, kā 'i ai he me'a 'oku kotou tala pō'uli, 'e ongona ia 'i te 'ahó; pea kā 'i ai he me'a kua kotou fanafana'aki ki te talingá 'i loki, 'e kalanga 'aki ia mei te tu'a falé. ");
INSERT INTO num_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Pea ko 'eni 'Okou lea atu kiā kōtou, si'aku tākanga, 'aua na'a kotou manahē kiā nātou 'oku notou tāmate'i te sinó pē, kae 'osi angé 'oku kala notou toe lava mo he me'a kehe. ");
INSERT INTO num_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kā 'e Au fakahaa'i atu kiā kōtou 'ia te Toko Taha ko ia 'e kotou manahē ki Aí: kotou manahē kiā Ia, 'a ē 'oku hili ange Tana tāmate'i 'ia te sinó pea toe mafai ke sī 'ia kōtou ki heli; 'io, 'Okou tala'i atu, kotou manahē ki te Toko Taha ko iá. ");
INSERT INTO num_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","'Oku kailoa koā fakatau he fanga ki'i misi 'e toko nima ki te konga sēniti 'e ua? Kā 'oku kailoa māngalo he notou toko taha 'i te 'afio 'a te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ka na'a mo te 'ū tu'ani lau'i'ulu 'i te kotou 'ulú kua 'osi lau fakalautelau. 'Aua 'e kotou manahē; 'oku kotou mahu'inga ange kōtou ia 'i te fanga misi tokolahi. ");
INSERT INTO num_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Pea 'Okou tala'i atu 'eni, kā 'i ai he taha 'e fakahaa'i 'e ia 'i te 'ao 'o te kakaí tana kau kiā Aú, 'e fakahaa'i foki 'e te Fanautama te Tangatá Tana kau kiā iá 'i te 'ao 'o te kau 'āngelo 'a te 'Atuá; ");
INSERT INTO num_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","kā ko ia kua ina fakafisinga'i 'Oku 'i te 'ao 'o te kakaí, 'e fakafisinga'i 'ona 'i te 'ao 'o te kau 'āngelo 'a te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Pea kā 'i ai he taha 'e lea kovi ki te Fanautama te Tangatá, 'e fakamolemole'i pē 'ona ia; kā ko ia kua lau kovi ki te Laumālie Mā'oni'oní 'e kailoa 'aupito fakamolemole'i. ");
INSERT INTO num_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Pea kāpau 'e notou 'ave 'ia kōtou ki te fakataha fakalotú, mo te hau'alikí, mo te kau pulé, 'aua 'e kotou lotoma'ua pe 'e fefe'aki he kotou fakamatala, pe ko te ā he me'a 'e kotou lea 'akí, ");
INSERT INTO num_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","he ko te Laumālie Mā'oni'oní 'e Ina ako'i 'ia kōtou 'i te taimi ko iá 'ia te lea 'oku totonu ke kotou lea 'akí.” ");
INSERT INTO num_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Pea lea mai he toko taha mei te kakaí, 'o pehē, “Tangata'aliki, ke ke iange ki toku tokouá, ke mā vaeua mo au 'ia te tofi'á.” ");
INSERT INTO num_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Kae tali ange 'e Sīsū kiā ia, “Siana, ko ai ne'e fakanofo 'Oku ke fai fakamaau 'iā kōtoú, pe ko te tufá?” ");
INSERT INTO num_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Pea toki lea 'e Ia kiā nātou, 'o pehē, “Kotou 'a'ala 'o le'ohi 'ia kōtou talia 'ia te mānumanú; hē neongo 'oku fu'u lahi te koloa he taha, kā 'oku kailoa hoko ai 'o tautau tana ma'ulí ki tana nga'ota'otá.” ");
INSERT INTO num_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pea lea 'aki 'e Ia he talanoa fakatātā kiā nātou, 'o pehē, “Takua ne'e 'i ai he tangata koloa'ina, ne'e fua lahi tana ngoué. ");
INSERT INTO num_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Pea pehē 'e ia 'i tono lotó, ‘Ko te ā taku me'a 'e faí, he 'oku kailoa haku kei fale ke tānaki ki ai taku 'ū fuá?’ ");
INSERT INTO num_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pea pehē 'e ia, ‘'Ē, ko 'eni pē te me'a 'e au faí: 'e au veteki toku 'ū faleokó pea langa'i ke notou lalahi; pea u toki tānaki ki ai taku 'ū fua kotoa pē mo taku 'ū me'a leleí. ");
INSERT INTO num_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pea 'e au pehē leva ki toku laumālié, “Si'i laumālie, kua lahi 'eni tau 'ū me'a lelei kua tānakí, 'o fe'unga mo he 'ū ta'u lahi; mālōlō ā, kai, inu, mo fiafia.” ’ ");
INSERT INTO num_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kae toki folafola ange kiā ia 'e te 'Atuá, 'o pehē, ‘'Ia te ta'eloto! Ko te pō neí 'e to'o mai ai tau ma'ulí; pea 'e 'a 'ai leva 'ia te 'ū me'a ne ke tokonakí?’ ");
INSERT INTO num_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ko te anga ia 'o he taha 'oku fakatupu koloa ma'aná, kā 'oku kailoa ina koloa'ina 'i te 'ū me'a 'a te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Pea toki lea Ia ki Tana kau akó, “Ko ia ai, 'Okou tala'i atu kiā kōtou, 'aua 'e kotou hoha'a kote'uhí ko te kotou ma'ulí, he me'a 'e kotou kai; pe ki te kotou sinó, he me'a 'e kotou 'ai ki aí. ");
INSERT INTO num_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","He 'oku lahi te ma'ulí 'i te me'akaí, mo te sinó 'i tono kofú. ");
INSERT INTO num_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kotou vakai angé ki te fanga lēvení, he 'oku kala notou tūtuu'i pē tu'usi; pea kala he notou faleoko, kā 'oku fafanga'i nātou 'e te 'Atuá. Hē 'oku kala koā mahu'inga ange pē 'ia kōtou ia 'i te fanga manupuná? ");
INSERT INTO num_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Pea neongo ai te kotou lotoma'uá, kā ko ai ia 'iā kōtou 'e lava ke fakaloaloa si'i atu tana ma'ulí? ");
INSERT INTO num_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","'Io, pea kāpau leva 'oku kala kotou lava'i he ki'i mama'i me'a pehē, ko te ā 'oku kotou lotoma'ua ai ki te 'ū me'a kehé? ");
INSERT INTO num_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Vakai angé ki te 'ū lilé, pe kua fefe'aki te notou tutupu aké: 'oku kala notou ngāue, pea 'oku kala notou filo, kā 'Okou tala'i atu: na'a mo Solomone, 'i tana 'ai tono nāunaú kotoa pē, ne'e kailoa tatau tono teungá mo he taha 'o te 'ū lile ko 'ení. ");
INSERT INTO num_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Pea kāpau leva 'oku fakakofu pehe'i 'e te 'Atuá 'ia te mahukú, 'ā ē 'oku 'i te kelekelé 'i te 'aho nei, kae tafu 'aki te 'ōvaní 'āpongipongi, huanoa 'ia kōtou, 'ia te kau tui vaivai! ");
INSERT INTO num_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kā ko kōtou, 'aua na'a kotou fa'a lotoma'ua he me'a ke kotou kai pe inu, pea 'aua na'a kotou loto tāla'a. ");
INSERT INTO num_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","He ko te 'ū me'a peheé 'oku hoha'a ki ai 'e te kakai 'o māmaní, pea 'oku mea'i 'e te kotou Tamaí 'oku kotou masiva 'i te 'ū me'a ko iá. ");
INSERT INTO num_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kehe pē ke kotou kumi ki Tono Pule'angá; pea 'e 'avatu mo ia foki 'ia te 'ū me'a ko iá. ");
INSERT INTO num_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“'Aua 'e kotou manahē, si'aku ki'i tākanga; he kua finangalo lelei te kotou Tamaí ke 'avatu kiā kōtou 'ia te pule'angá. ");
INSERT INTO num_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Fakatau atu te kotou nga'ota'otá, pea fai foaki 'aki tono pa'angá. Ngaahi ma'a kōtou 'ia te 'ū kato pa'anga 'e kailoa popó, mo he koloa 'i hēvani 'e kailoa 'osí, he ko te feitu'u ia 'oku kala ofi ai he kaiha'a, pe ko te maumau 'a te ané. ");
INSERT INTO num_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","He ko te feitu'u 'oku 'i ai te kotou koloá 'e 'i ai foki mo te kotou lotó. ");
INSERT INTO num_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Kotou mateuteu ma'u pē, mo ulo ai pē te kotou maamá; ");
INSERT INTO num_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","'o hangē ko he kau tangata 'oku talitali te notou 'alikí, hana foki mai mei te ta'ané; kote'uhí kā a'u mai ia, 'o tukituki, pea notou to'o leva kiā ia. ");
INSERT INTO num_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Manū'ia ā kā ko te kau tamaio'aliki ko iá, 'a ia 'e 'ilo'i nātou 'e te 'Alikí 'i Tana hā'ele maí 'oku notou lele'o pē. 'Okou tala mo'oni atu kiā kōtou, 'e hanga 'e Ia 'o huke Tono kofu 'O'oná, mo fakatangutu 'ia nātou ki te kaí, kae tu'u atu 'e Ia 'o teu kai ma'a nātou. ");
INSERT INTO num_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pea kāpau ko te tu'ulapoó 'oku ha'u aí, pe ko te hengihengí, kā 'oku 'ilo'i atu 'e Ia 'ia nātou 'oku notou pehē pē, pea manū'ia ā kā ko nātou. ");
INSERT INTO num_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pea ko te me'a ko 'ení 'oku kotou lāu'i'ilo ki ai, kāpau ne toka mea'i 'e te tangata'alikí pe ko te ā te taimi 'e ha'u ai te kaiha'á, pehē ne le'o ia, 'o kailoa tuku tono falé ke haea. ");
INSERT INTO num_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ko kōtoú foki ke kotou toka teuteu, he ko te ha'u 'ia te Fanautama te Tangatá 'e fai ia he taimi 'oku kailoa kotou 'amanaki ai kiā Iá.” ");
INSERT INTO num_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pea pehē 'e Pita kiā Ia, “'Aliki, ko Tau fai te 'ū talanoa fakatātā ko 'ení kiā mātou pē, pe 'oku kau ai mo te kakaí kotoa pē?” ");
INSERT INTO num_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Pea folafola ange 'e te 'Alikí, “'Io, ko ai nai 'ia te matāpule lototō mo fai fakapotopotó, 'a ia 'e fakanofo 'e tana 'alikí ke pule 'i tono kau nofo'angá, mo 'avange te me'akai kua tu'utu'uní 'i tono taimi totonú? ");
INSERT INTO num_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Manū'ia ā kā ko te tamaio'aliki ko iá, 'a ia 'e 'iloa 'e tana 'alikí 'i tana ha'ú 'oku fai pehē. ");
INSERT INTO num_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","'Okou tala mo'oni atu, 'e fakanofo 'e ia 'ona ke pule ki tana 'ū me'á kotoa pē. ");
INSERT INTO num_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kae kā pehē 'e te tamaio'aliki ko iá 'i tono lotó, ‘'Oku fakatuatuai taku 'alikí tana ha'ú,’ pea toki hanga 'e ia 'o haha te kau tamaio'alikí mo te kau kaunangá, pea kai mo inu ia mo konā; ");
INSERT INTO num_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","'e toki ha'u te 'aliki 'o te tamaio'aliki ko iá he 'aho 'oku kailoa tokanga ai iá pea mo he houa 'oku kailoa 'ilo 'e ia ki aí, pea 'e ina tu'utu'u 'ona, pea tu'utu'uni ke 'inasi fakataha ia mo te kau ta'etuí. ");
INSERT INTO num_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Pea ko te tamaio'aliki ko ia ne'e 'ilo'i lelei ki te finangalo 'o tana 'alikí, kae kailoa toka teuteu, pe fai ki tana tu'utu'uní, 'e taa'i 'ona 'aki he 'ū tā lahi. ");
INSERT INTO num_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kā ko ia ne kailoa ina 'ilo'i ki ai, kae fai pē te 'ū me'a 'oku taau mo he tauteá, 'e si'isi'i pē te fe'i tā 'e 'aí. Pea ko ia kua 'avange ki ai he me'a lahí, 'e fia ma'u mei ai he me'a lahi; pehē foki, kā tukuange 'e te kakaí he fu'u me'a ki he taha ke tauhi, pea hulu atu mo te me'a 'e 'eke kiā iá.” ");
INSERT INTO num_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Kua U ha'ú ke laku he afi ki māmani; pea ko Taku faka'amú, taumaiā kua tutu! ");
INSERT INTO num_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kā 'oku 'i ai Taku papitaiso ke Au papitaiso ai; pea 'Okou kukuta tu'u 'eni kae'aua leva ke lava! ");
INSERT INTO num_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","'Oku kotou mahalo koā ko Taku ha'ú ke tuku he melino ki māmani? Tala'i atu, kailoa, kā ko te māvahevahe. ");
INSERT INTO num_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Seuke, 'i te hili ange 'ení, tokaange he toko nima 'i te 'api pē taha 'e notou māvahevahe, 'o fetu'usi te toko tolu mo te toko ua, 'ia te toko ua mo te toko tolu. ");
INSERT INTO num_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","'E fetu'usi 'ia te tamai mo tono foha, mo te foha mo tana tamai; 'ia te fafine mo tana ta'ahine, mo te ta'ahine mo tana fa'ē; 'ia te finematu'a mo te mali 'o tana tamá, mo te ta'ahine mo tana fa'ē 'i te fonó.” ");
INSERT INTO num_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Pea ne Ina lea foki ki te kakaí 'o pehē, “Kā kotou sio leva he 'ao 'oku tu'u ake 'i te hihifó, 'oku kotou pehē leva, ‘'E 'ua;’ pea 'oku hoko ia. ");
INSERT INTO num_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Pea kā kotou vakai 'oku angi mei te tongá 'ia te matangí, 'oku kotou pehē leva, ‘'E pupuha;’ pea 'oku hoko ia. ");
INSERT INTO num_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","'Ia te kau mālualohi! 'Oku kotou vavanga koā ki te mata 'o te fanuá mo te langí, kae fefe'aki ai te kotou ta'evavanga ki te kuonga nei?” ");
INSERT INTO num_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“'Io, pea ko te ā 'oku kala kotou 'ilo'i ai pē te totonú 'iā kōtou peé? ");
INSERT INTO num_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","He ko 'eni 'oku lolotonga ō pē 'ia koe mo tou filí ki te fakamaaú, 'ē, ke ke feinga leva ke fakahaofi 'ou meiā ia lolotonga te kulā fononga 'i te alá; na'a faifaí pea toho 'ou ki te fakamaaú, pea 'avatu mei te fakamaaú ki te polisí, pea sī leva 'ou 'e te polisí ki te pilīsoné. ");
INSERT INTO num_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tala'i atu, 'e kailoa ke 'alu atu mei ai kae'aua ke 'osi 'aupito tou ma'uá tono totongi.” ");
INSERT INTO num_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Pea ne'e ōmai he 'ihi 'i te taimi ko iá, 'o notou fakahā kiā Sīsū 'ia te kau Kāleli 'ihi, ne'e hu'i te notou totó 'e Pailato fakataha mo te notou 'ū feilaulaú. ");
INSERT INTO num_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Pea pehē ange 'e Ia kiā nātou, “'Oku kotou mahalo koā ne'e angahala lahi ange 'ia te kau Kāleli ko iá 'i te kakai Kāleli kehé, ko te pehē te notou fakamamahi'í? ");
INSERT INTO num_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","'Okou tala'i atu, ne kailoa; kaikehe, 'e kotou tu'utāmaki pehē kotoa pē, 'o kāpau 'e kailoa kotou fakatomala. ");
INSERT INTO num_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Pea ko te toko hongofulu mā valu ko ia ne'e ta'omia 'o mate 'i te holo te taua 'i Sailoamé, 'oku kotou mahalo koā ne'e lahi ange te notou ma'uá 'i te kakai kotoa pē ne'e nofo 'i Selusalemá? ");
INSERT INTO num_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","'Okou tala'i atu, ne kailoa; kaikehe, 'e kotou tu'utāmaki pehē kotoa pē, 'o kāpau 'e kailoa kotou fakatomala.” ");
INSERT INTO num_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ne'e lea 'aki foki 'e Ia te talanoa fakatātā ko 'ení: “Takua ne'e 'i ai he toko taha ne'e 'i ai tana fu'u fiki kua tō 'i tana ngoue vainé; pea ha'u ia ko te kumi he fua 'i ai, kā ne hala ia. ");
INSERT INTO num_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Pea iange 'e ia ki te tauhi 'o te ngoue vainé, ‘Vakai angé, ko te ta'u 'eni 'e tolu mo taku ha'u 'o kumi he fua 'i te fu'u fiki nei, mo te kailoa pē ma'u. Taa'i ia, mo te maumau kelekele.’ ");
INSERT INTO num_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kae tali ange 'e ia, 'o pehē, ‘'Aliki, tuku pē mu'a 'i te ta'u nei foki, kae'aua leva ke au keli takai tono tafitó mo fafanga'i. ");
INSERT INTO num_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Hei'ilo 'e faifaí pea toe fua ia; pea kā kailoa, pea ke toki taa'i.’ ” ");
INSERT INTO num_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pea 'i te Sāpate 'e taha ne'e fai ai Tana ako 'i te falelotú. ");
INSERT INTO num_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Pea vakai, ne'e 'i ai he fafine kua hongofulu mā valu ta'u tana ma'ua he fa'ahikehe fakavaivai sino, pea kua pīkoua ia, 'o kailoa toe lava ke tu'u totonu. ");
INSERT INTO num_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pea 'i te vakai atu 'e Sīsū kiā iá, ne'e kalanga 'e Ia 'o pehē, “Fafine, kua vete ange 'ou mei tou vaivai'angá!” ");
INSERT INTO num_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Pea 'ai 'e Ia Tono ongo nimá kiā ia, pea kevakeva tonu leva ia, 'o fakamālō'ina 'ia te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ka ne'e 'ita 'aupito 'ia te pule 'o te falelotú, kote'uhí kua fai 'e Sīsū Tana faito'ó 'i te Sāpaté, pea hanga 'e ia 'o lea ki te kakaí, “'Oku 'i ai te 'aho 'e ono, 'oku ngafua ai ke kotou ngāue; ko ia ai kotou ōmai 'i te 'ū 'aho ko iá ke faito'o, 'o 'aua 'aupito 'i te 'aho Sāpaté.” ");
INSERT INTO num_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kae tali ange 'e te 'Alikí kiā ia, 'o pehē, “'Ia te kau mālualohi! 'Oku kala koā kotou taki taha vete ange mei te fale monumanú 'i te 'aho Sāpaté tana pulu pē ko tana 'asi, 'o taki atu ke fakainu? ");
INSERT INTO num_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kā ko te fafine nei ko te hako totonu ia 'o 'Ēpalahame, pea kua no'otaki 'ona 'e Sētane, 'io 'o ta'u 'e hongofulu mā valu 'eni, pea ne kailoa koā ngafua ke vete ange tono ha'isiá, neongo ko te 'aho Sāpate?” ");
INSERT INTO num_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Pea 'i Tana lea peheé, ne'e mā Tono 'ū fili kotoa pē. Kae toki fiafia 'ia te fu'u fakatahá kotoa pē 'i te 'ū me'a fungani ne'e fai 'e Iá. ");
INSERT INTO num_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Pea toki lea 'e Ia 'o pehē, “'Oku hangē nai ko te ā 'ia te Pule'anga 'o te 'Atuá? 'Io, 'e Au fakatatau nai 'Ona ki te ā? ");
INSERT INTO num_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","'Oku tatau Ia mo he pulapula'i mūsita, ne'e to'o he tangata, 'o tō 'i tana ngoué; pea tupu ake ia, 'o hoko ko te fu'u 'akau; pea ne'e nofo'i tono 'ū va'á 'e te fanga manupuna 'o te 'ataá.” ");
INSERT INTO num_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Pea toe iange 'e Ia, “Ko te ā nai he me'a 'e Au fakatatau ki ai 'ia te Pule'anga 'o te 'Atuá? ");
INSERT INTO num_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","'Oku tatau Ia mo he lēvani, 'a ia ne'e to'o he fafine, 'o natu 'aki te fua māhoa'a 'e tolu, kae'aua leva ke tupu 'ia te māhoa'á kotoa.” ");
INSERT INTO num_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Pea fononga atu Ia ki te 'ū kolo lalahí, mo te 'ū kolo lilikí, 'o faiako 'i ai, ko Tana faka'a'au atu ki Selusalema. ");
INSERT INTO num_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Pea iange kiā Ia he taha, “'Aliki, 'oku tokosi'i pē koā 'ia te kakai 'e fakama'ulí?” Pea iange 'e Sīsū kiā nātou, ");
INSERT INTO num_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kotou tōtōivi ke hū 'i te matapā fāsi'í. Hē 'Okou tala'i atu, 'oku 'i ai he tokolahi 'e notou feinga ke notou hū, kā 'e kailoa notou lava. ");
INSERT INTO num_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kā toki tu'u te Tangata'alikí, 'o tāpuni'i te matapaá, pea kotou toki tutu'u 'i tu'a 'o tukituki 'i te matapaá, mo kotou pehē, ‘'Aliki, ke Ke to'o kiā mātou.’ Pea 'e toki tali atu 'e Ia, ‘'Oku kala U 'ilo'i pe ko te kakai mei fea 'ia kōtou.’ ");
INSERT INTO num_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","'E toki fakamatala leva 'e kōtou, ‘'Ē, ne'e motou fa'a kakai mo iinu fakataha mo Koe pea ne'e faiako 'ia Koe 'i te motou 'ū mala'é.’ ");
INSERT INTO num_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kā 'e toki pehē atu 'e Ia, ‘'Okou tala'i atu 'eni, 'oku kailoa 'aupito ke Au 'ilo'i pe ko te kakai mei fea 'ia kōtou; tu'u atu meiā Au, 'ia kōtou kotoa pē 'oku fai angahalá.’ ");
INSERT INTO num_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ko te feitu'u ia 'e toki hoko ai 'ia te tangi mo te fengai'itaki 'o te nifó, 'o kā kotou sio kiā 'Ēpalahame, mo 'Aisake, mo Sēkope, mo te kau palōfita kotoa pē, 'oku notou 'i te Pule'anga 'o te 'Atuá, kā ko kōtou kua kapusi ki tua'ā. ");
INSERT INTO num_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pea 'e ōmai he kakai mei hahake, mo hihifo, mo te tokelaú, mo te tongá, pea 'e notou kainanga 'i te Pule'anga 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Pea vakai, 'oku 'i ai te 'ihi mulimuli 'e notou mu'amu'a, pea 'i ai te 'ihi mu'amu'a 'e notou mulimuli.” ");
INSERT INTO num_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","'I te taimi ko iá ne'e 'unu'unu mai he 'ihi 'o te kau Fālesí, 'o notou iange kiā Ia, “Ke hiki 'ia Koe mei heni, 'o fononga, hē 'oku loto 'ia Hēlota ke tāmate'i 'Ou.” ");
INSERT INTO num_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pea folafola ange 'e Ia kiā nātou, “Kotou ō 'o iange ki te fōkisi ko iá, ‘Ko 'eni, ko te 'aho nei mo te 'āpongipongí 'e Au fai ai Taku kapusi tēvoló, mo faka'osi Taku faito'ó, pea toki 'osi ia ki tono 'aho tolú.’ ");
INSERT INTO num_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kā 'e Au kei fononga pē 'i te 'aho nei, mo 'āpongipongi, mo te 'aho tono hokó; kote'uhí 'e kailoa tāmate'i he palōfita ia kā 'i Selusalema pē. ");
INSERT INTO num_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","'E Selusalema! Selusalema! 'Ia te kolo 'oku tāmate'i ai 'ia te kau palōfitá, mo tolomaka'i ai 'ia te kakai 'oku fekau'i atu ki aí! Kua tu'a fia 'eni Taku loto ke tānaki mai tau fānaú, hangē ko te tānaki 'e te matu'a moá tana fānganga 'a'aná ki tono lalo kapakaú, ka ne'e kala loto kōtou ia ki ai! ");
INSERT INTO num_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ko 'eni kua motuhi atu kiā kōtou te kotou falé. Pea 'Okou tala'i atu, 'e kailoa 'aupito kotou tē sio kiā Au, kae'aua leva ke kotou pehē, ‘'Oku manū'ia Ia 'oku hā'ele mai 'i te huafa 'o te 'Alikí.’ ” ");
INSERT INTO num_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Pea 'i te 'aho Sāpate 'e taha ne'e hū Ia ki te fale he taha 'o te hau'aliki Fālesí ke kai, pea ne'e 'i ai foki te hau'aliki ko iá, 'o notou lamasi 'Ona. ");
INSERT INTO num_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Pea tā, ne'e nofo fehangahangai mo Ia he tangata ne'e fefulafulasi tono va'é. ");
INSERT INTO num_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Pea folafola 'ia Sīsū 'o iange ki te kau tufunga laó mo te kau Fālesí, “'Oku ngafua koā ke faito'o 'i te 'aho Sāpaté, pe kailoa?” ");
INSERT INTO num_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pea ne'e kailoa he taha 'e tali mai. Pea puke mai 'e Ia te tangatá, 'o fakama'uli, 'o toki tukuange. ");
INSERT INTO num_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pea iange 'e Ia kiā nātou, “Ko ai 'iā kōtou, kāpau 'e tō tana 'así pe ko tana pulú he luo, 'e kailoa koā ina to'o leva ia mei ai 'i te 'aho Sāpaté?” ");
INSERT INTO num_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pea ne'e kailoa notou lava ke tali ange 'ia te me'a ko iá. ");
INSERT INTO num_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Pea lea 'aki 'e Ia he talanoa fakatātā kiā nātou ne'e notou 'i te kātoangá, ko Tana vakai atu 'oku notou fili'i pē 'e nātou te 'ū nofo'anga mu'á; pea toki iange 'e Ia kiā nātou, ");
INSERT INTO num_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kā fakaafe'i 'ou he taha ke ke ha'u ki tana kātoanga, 'aua na'a ke nofo 'i te nofo'a mu'á; na'a kua tala te kātoangá ia ki te toko taha 'oku mā'olunga ange 'iā koe. ");
INSERT INTO num_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Pea kā faifai angé pea hū mai te matāpule 'oku 'a'ana te kātoangá 'oku kulā fakatou 'i ai, pea toki pehē atu ia kiā koe, ‘Tuku mai te nofo'anga ia ko 'ená ki te toko taha nei;’ pea toki hiki 'ia koe ki mulí kua ke mā. ");
INSERT INTO num_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kae kāpau 'e fakaafe'i atu 'ou, 'alu 'o nofo 'i te nofo'anga ki mulí; kote'uhí kā hū mai te matāpule 'oku 'a'ana te kātoangá, pea iatu 'e ia, ‘Nga'ata, ma'uma'u ake ki mu'a,’ pea 'e toki faka'apa'apa'i 'ou 'e nātou kotoa pē 'oku kotou kainangá. ");
INSERT INTO num_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","He ko ia 'oku hākeaki'i 'oná 'e fakavaivai'i; pea ko ia 'oku fakavaivai'i 'oná 'e hākeaki'i.” ");
INSERT INTO num_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pea iange foki 'e Ia kiā ia ne'e 'a'ana te kātoangá, “Kā fai leva hau fu'u fakaafe pe ko he kātoanga kai, 'aua na'a tala ia ki tou 'ū kaume'á, pē ki tou 'ū tokouá, pē ki tou kāingá, pē ki tou kaungā'api 'oku koloa'iná; na'a toe tala kātoanga atu kiā koe 'e nātou, pea fai ai he totongi kiā koe. ");
INSERT INTO num_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kae kāpau 'e fai hau kātoanga, tala ia ki te kau masivá, mo te mamateá, mo te heké, mo te kuí, ");
INSERT INTO num_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","'e toki manū'ia 'ia koe, hē 'oku kailoa he notou me'a ke totongi 'aki kiā koe, kā 'e toki totongi kiā koe 'i te toetu'u 'a te anga-tonú.” ");
INSERT INTO num_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Pea ko te toko taha 'iā nātou ne'e notou kainangá, 'i tana fanongo leva ki te me'a ko iá, ne'e iange 'e ia kiā Sīsū, “He manū'ia ā kā ko ia 'e kai kātoanga 'i te Pule'anga 'o te 'Atuá!” ");
INSERT INTO num_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kae toki tali ange 'e Ia ki ai, “Takua ne'e 'i ai he tangata ne'e teu tana fu'u kātoanga kai, 'o tala'i atu ki te tokolahi. ");
INSERT INTO num_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pea 'i te hokosia te taimi 'o te kātoangá, ne ina fekau atu tana tamaio'alikí ke fanongonongo kiā nātou kua tala ki aí, ‘Kotou ōmai ā, he kua 'osi tono teu.’ ");
INSERT INTO num_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ka ne'e fāitaha te notou talí, 'o notou fakafisi kotoa pē. Ko te 'uluakí, ne'e iange 'e ia ki te tamaio'alikí, ‘'Ē, ko taku toki fakatau mai 'eni he ngoue'anga, pea kua pau ke au 'alu au ia 'o vakai; ke ke tala'i ange mu'a ke fakamolemole'i 'oku.’ ");
INSERT INTO num_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Pea iange tono uá, 'o pehē, ‘'Ē, ko taku toki fakatau 'eni ta'akú taulua'i pulu 'e nima, pea ko ta'akú 'eni 'alu ke 'ahi'ahi'i nātou; ke ke iange mu'a ke fakamolemole'i 'oku.’ ");
INSERT INTO num_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Pea iange tono tolú, 'o pehē, ‘'Ē, ko taku toki ma'u 'eni to'okú mali, ko ia ai 'e kala u lava atu.’ ");
INSERT INTO num_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Pea ha'u leva te tamaio'alikí, 'o tala'i ange te 'ū me'a ko iá ki tana 'alikí. Pea tuputāmaki ai te tangata'alikí, 'o iange ki tana tamaio'alikí, ‘'Alu vave ki te 'ū ala lalahi mo te 'ū ala liliki 'o te koló, 'o taki mai 'ia te kau masivá, mo te mamateá, mo te kuí, mo te heké.’ ");
INSERT INTO num_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Faifaí pea toki iange te tamaio'alikí, ‘'Aliki, kua fai kotoa pē te 'ū me'a ne ke tu'utu'uni maí, kā 'oku kei 'ata'atā pē.’ ");
INSERT INTO num_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Pea me'a ange leva te 'alikí ki tana tamaio'alikí, ‘'Alu ki te 'ū ala matu'á, mo te 'ū lalo 'akaú, pea 'aumai fakamālohi'i 'ia te kakaí, kehe pē ke fonu toku 'apí. ");
INSERT INTO num_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Hē 'okou tala'i atu kiā kōtou, 'e kailoa 'aupito he taha 'i te kau tangata 'a ē ne'e fu'aki fakaafe'í 'e mama he me'a 'i taku kātoangá.’ ” ");
INSERT INTO num_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Pea ne'e 'i ai he fu'u kakai tokolahi ne'e notou fononga fakataha mo Ia. Pea tafoki 'e Ia 'o lea kiā nātou, 'o pehē, ");
INSERT INTO num_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Kāpau 'e ha'u he taha kiā Au, kā 'oku kailoa fihi'a ki tana tamaí, mo tana fa'eé, mo tono malí, mo tana fānaú, mo tono 'ū tokouá, mo tono 'ū tu'afāfiné, 'io, mo tana ma'uli 'a'aná foki, 'e kala fa'a hoko ia ko Taku ako. ");
INSERT INTO num_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Pea ko ia 'e kailoa fua tono kolosí 'o mulimuli mai kiā Aú, 'e kailoa 'aupito hoko ia ko Taku ako. ");
INSERT INTO num_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","He ko ai 'iā kōtou 'oku loto ke langa he fu'u taua, kae kailoa fu'aki nofo ifo 'o fatu tono totongí, pe 'oku fe'unga tana pa'angá ke faka'osi 'aki? ");
INSERT INTO num_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Na'a faifai angé, kua 'osi tana 'ai te tu'ungá, 'oku kailoa ina lava ke faka'osi, pea ko te kakai kotoa pē 'e notou sio ki aí 'e notou hanga 'o luma'i 'ona, ");
INSERT INTO num_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","'i te notou pehē, ‘Ko te siana nei ne'e kamata ia ke langa, kae kala ina lava'i tono faka'osí!’ ");
INSERT INTO num_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Pea ko te tu'i fea ia 'oku teuteu tana tau mo he tu'i 'e taha, 'oku kala ina nofo ifo 'o fifili, pe 'e lava 'e ia mo tana taha manó ke tau'i 'aki te 'aliki 'oku ha'u ke tau'i 'ona mo te ua manó? ");
INSERT INTO num_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Pea kāpau 'e kailoa, pea lolotonga 'oku kei mama'o te filí 'e fekau atu 'e ia he fakafofonga ke kole ange he fakalelei. ");
INSERT INTO num_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Pehē foki, ko ia ko 'ē 'oku kailoa ina lava ke si'aki te 'ū me'a kotoa pē 'oku 'a'aná, 'e kailoa 'aupito lava ia ke hoko ko Taku ako. ");
INSERT INTO num_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“'Ē, ko te me'a 'aonga 'ia te māsimá; kae kāpau 'e mole mei te māsimá tono koná, 'e fakakonakona 'aki ia 'ia te ā? ");
INSERT INTO num_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","'Oku kala fe'unga ia ke laku ki te ngoué, pē ki te tu'unga vevé, kā ko tono laku pē ki tua'ā. Ko ia 'oku ma'u talinga ke fanongo 'akí, ke ongo'i ia.” ");
INSERT INTO num_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pea ne'e kātoa mai te kau tānaki tukuhau kotoa pē mo te kau angahalá ke fanongo kiā Ia. ");
INSERT INTO num_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pea ne'e lāunga ai 'ia te kau Fālesí, mo te kau sikalaipé, 'o notou pehē, “Ko te Siana nei 'oku tali pē 'e Ia 'ia te kau angahalá, 'o kai fakataha mo nātou!” ");
INSERT INTO num_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Pea toki lea 'aki 'e Ia te talanoa fakatātā nei kiā nātou, 'o pehē: ");
INSERT INTO num_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ko ai he taha 'iā kōtou 'oku 'i ai tana fanga sipi 'e toko teau pea kua mole he notou taha, 'e kailoa koā tuku 'e ia te toko hivangofulu mā hivá 'i te toafá, kae 'alu 'o kumi te taha kua molé kae'aua ke 'ilo'i 'ona? ");
INSERT INTO num_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Pea kā ma'u ia, 'e kala koā fiafia lahi ia, mo fua 'ona 'i tono uma 'o'oná? ");
INSERT INTO num_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Pea 'i tana a'u ki 'apí, 'e fakataha'i 'e ia tono 'ū kaume'á, mo tono kaungā'apí, mo iange kiā nātou, ‘Tou fakafiafia, he kua u ma'u mai taku sipi ne'e molé.’ ");
INSERT INTO num_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Tala'i atu, 'e pehē pē he fiafia 'i loto hēvani 'i te fakatomala he fe'i angahala 'e toko taha, 'io, 'o hulu atu ia 'i te toko hivangofulu mā hiva faitotonu, 'a ē 'oku kailoa he notou me'a ke fakatomala aí. ");
INSERT INTO num_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Pea ko ai he fafine, 'oku hongofulu tana pa'anga silivá, pea kā mole he fe'i pa'anga 'e taha, 'e kailoa koā tutu 'e ia he maama, mo tafi 'ia te falé, 'o kumi fakamātoato kae'aua ke 'ilo'i? ");
INSERT INTO num_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Pea 'i tana 'ilo'i leva iá, 'e fakataha'i 'e ia tono 'ū kaume'á, mo te kaungā'apí, 'o iange, ‘Tou fakafiafia, he kua u 'ilo'i te fe'i pa'anga ne'e molé.’ ");
INSERT INTO num_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","'Okou tala'i atu kiā kōtou, 'e hoko he fiafia pehē 'i te ha'oha'onga 'o te kau 'āngelo 'a te 'Atuá 'i te fakatomala he fe'i angahala 'e toko taha.” ");
INSERT INTO num_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Pea lea Ia 'o pehē, “Takua ne'e 'i ai he tangata mo tono ongo foha 'e toko ua. ");
INSERT INTO num_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Pea iange 'e te tehiná ki tana tamaí, ‘'E tamai, vahe'i mai mu'a toku 'inasi 'i te koloá.’ Pea tufa leva 'e ia kiā nāua, 'io, mo te me'a kotoa pē ne'e tauhi 'aki si'ana ma'ulí. ");
INSERT INTO num_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Pea 'osi mei ai te 'ū 'aho si'i, ne'e tānaki leva 'e te tehiná tana me'a kotoa pē, 'o hiki atu ki te fanua mama'o; pea 'i te feitu'u ko iá ne'e toloveka 'aki 'e ia tana koloá 'aki tana ma'uli fakalusá. ");
INSERT INTO num_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pea 'i te faifaí pea 'osi 'aupito tana me'á kotoa pē, pea kua honge lahi 'ia te fanua ko iá, pea kua kamata ia ke fiakaia. ");
INSERT INTO num_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Pea 'alu ia 'o ngāue totongi ki te toko taha ko te tangata 'o te fanua ko iá; pea ne'e fekau'i 'ona ke 'alu ki tana ngoue'angá, 'o tauhi tana fanga puaká. ");
INSERT INTO num_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pea ne'e faka'amu 'e ia ke kai mei te me'akai 'a te fanga puaká; he ne'e kailoa 'avange he taha hana me'a. ");
INSERT INTO num_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pea faifaí pea maama tono lotó, pea pehē 'e ia, ‘'Oku toko fia te kau ngāue totongi ki taku tamaí kua lahi mo toe te notou maá, kā 'i hení 'okou mate 'i te fiakaiá! ");
INSERT INTO num_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ke au tu'u mu'a 'o 'alu ki taku tamaí; pea u pehē kiā ia, “'E tamai, kua u fai angahala ki te langí, kae tau tonu kiā koe. ");
INSERT INTO num_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","'Oku kala u kei taau ke lau ko tou foha; kā ke fai mu'a kiā kita 'o hangē pē ko he taha 'o tau kau ngāue totongí.” ’ ");
INSERT INTO num_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Pea tu'u ia 'o 'alu ki tana tamaí. Pea 'i tana kei mama'ó, ne'e sio kiā ia 'e tana tamaí, pea langa tono fatú 'i te 'ofa, 'o ina lele atu, 'o tāupe 'i te u'a 'o te tamá, 'o 'uma lolomi kiā ia. ");
INSERT INTO num_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Pea lea ange leva te tamá, ‘'E tamai, kua u fai angahala ki te langí, kae tau tonu kiā koe. 'Oku kala kei taau 'eni ia ke lau ko tou foha.’ ");
INSERT INTO num_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kae pehē ange te tamaí ia ki tana kau tamaio'alikí, ‘'Aumai te pulupulu funganí, 'o 'ai kiā ia; pea 'ai mo te mama ki tono nimá, mo te senitolo ki tono va'é. ");
INSERT INTO num_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pea 'aumai ki heni te 'uhiki'i pulu sinó, 'o tāmate'i, pea tou kai mo fakafiafia. ");
INSERT INTO num_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Hē ko 'eni si'aku foha ne'e maté, pea kua toe ma'uli; ne'e molé, pea kua 'iloa.’ Pea ne'e notou kamata fiafia. ");
INSERT INTO num_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Kae lolotonga iá ne'e kei 'i 'uta tono foha lahí. Pea 'i te foki mai ia, 'o ofi ki 'apí, ne'e ongo mai he tā nafa mo te me'e. ");
INSERT INTO num_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Pea ui ange 'e ia he taha 'o te kau tamaio'alikí, 'o 'eke ange ki te 'uhinga 'o te 'ū me'a nei. ");
INSERT INTO num_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Pea iange 'e ia, ‘Kua ha'u tou tehiná, pea kua tāmate'i 'e tau tamaí 'ia te 'uhiki'i pulu sinó, kote'uhí ko tana toe ma'u ma'uli mai 'oná.’ ");
INSERT INTO num_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pea 'ita ai ia, 'o kailoa fia hū ki fale. Pea 'alu ki tu'a tana tamaí 'o fakakolekole kiā ia. ");
INSERT INTO num_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ka ne'e iange 'e ia, ‘'Ē, ko te 'ū ta'u lahi mo taku ngāue kiā koe 'o hangē ko he pōpulá; 'io, ne 'anefea haku si'aki hau fekau 'e taha? Kae 'anefea hau tuku mai, 'io, he ki'i kosi ke au fakafiafia 'aki mo toku 'ū kaume'á? ");
INSERT INTO num_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kā 'i te ha'u leva tou foha ko 'ená, 'a ia kua ina kai 'o 'osi tau koloá, 'aki tana fafanga te kau fe'auakí, pea ke tāmate'i leva ma'ana 'ia te 'uhiki'i pulu sinó!’ ");
INSERT INTO num_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Pea tali ange 'e ia ki ai, ‘Nga'ata, ko te me'a kiā koé, 'oku ke 'iā au ma'u pē, pea ko taku me'á kotoa pē ko tau me'a. ");
INSERT INTO num_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ka ne'e totonu pē foki ke tou fakafiafia mo nēkaneka, he ko si'au tehina 'eni ne'e maté, kua ma'uli; ne'e molé, kua toe ma'u.’ ” ");
INSERT INTO num_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Pea lea foki 'e Ia ki te kau akó, 'o pehē, “Takua ne'e 'i ai he tangata koloa'ina, mo te matāpule ne'e tauhi tana koloá. Pea ne'e faka'ilo 'ia te tauhi koloá kiā ia, takua 'oku toloveka 'aki 'e ia tana koloá. ");
INSERT INTO num_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Pea ui mai 'e ia 'ona, 'o iange ki ai, ‘Ko te ā 'eni 'okou fanongo ki ai 'o kau kiā koé? Tuku mai te tohi 'o tau tauhi koloá, he tala'i'eaí 'e lava ke ke toe tauhi.’ ");
INSERT INTO num_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Pea pehē 'e te tauhi koloá 'i tono lotó, ‘Ko te ā haku me'a 'e faí? He kua to'o meiā au 'ia te lakangá 'e taku 'alikí. 'Oku kailoa ke au mafai ke keli; pea 'okou mā ke ma'uli kolekole. ");
INSERT INTO num_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","'Ē, 'okou 'ilo'i pē te me'a 'e au fai, kote'uhí ke talitali 'oku he 'ihi ki te notou falé, 'o kā hifo 'oku mei te lakangá.’ ");
INSERT INTO num_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Pea ui ange tāutaha 'e ia 'ia te kakai ne'e ma'ua ki tana 'alikí, 'o iange ki te 'uluakí, ‘'Oku fia tou ma'ua ki taku 'alikí?’ ");
INSERT INTO num_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Pea tali ange 'e ia, ‘Ko te pōkete lolo 'e teau.’ Pea iange 'e ia ki ai, ‘Ko 'ena tau tohí, pea ke nofo leva 'o tohi'i ai ke nimangofulu pē.’ ");
INSERT INTO num_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Pea tē 'eke ia ki te taha kehe, ‘Mo koe foki, 'oku fia ta'aú ma'ua?’ Pea iange 'e ia, ‘Ko te tangai uite 'e teau.’ Pea iange leva 'e ia ki ai, ‘Ko 'ena tau tohí, pea ke tohi'i ai ke valungofulu pē.’ ");
INSERT INTO num_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Pea fakamālō'ina 'e tana 'alikí te tauhi koloa kākaá, kote'uhí ko te ngali poto tana faí. He ko te fānau 'o māmaní, 'i te fai mo te notou fa'ahingá, 'oku ngali poto ange te notou tō'ongá 'i te tō'onga 'a te fānau 'o te maamá. ");
INSERT INTO num_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Pea 'Okou pehē atu kiā kōtou: kotou ngāue 'aki te koloa kākaá ke tupu ai he kakai 'e 'ofa mai; kote'uhí 'o kā kotou mate, pea notou fia ma'u kōtou ki te 'ū tēniti ta'engatá. ");
INSERT INTO num_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ko ia 'oku faitotonu 'i te me'a 'oku si'í, 'e faitotonu foki 'i te me'a 'oku lahí; pea ko ia 'oku kākā 'i te me'a si'isi'í, 'e kākā foki ia 'i te me'a 'oku lahí. ");
INSERT INTO num_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","'Io, pea kāpau kua kailoa kotou faitotonu 'i te fai ki te koloa kākaá, ko ai leva ia 'e falala kiā kōtou 'o 'avatu 'ia te koloa mo'oní? ");
INSERT INTO num_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Pea kāpau kua kala kotou faitotonu 'i te ngāue 'aki te koloa he taha kehé, ko ai ia 'e 'avatu te koloa 'a kōtoú? ");
INSERT INTO num_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","'Oku kala lava he tamaio'aliki ke 'aliki 'aki te 'aliki 'e toko ua, he 'e fihi'a ia ki te taha, kae 'ofa'i te taha; pē 'e piki ia ki te taha, kae ta'etoka'i te taha. 'Oku kailoa kotou lava ke 'aliki 'aki 'ia te 'Atuá pea mo te koloá fakatou'osi.” ");
INSERT INTO num_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pea ne'e fanongo ki te 'ū me'a ko iá 'e te kau Fālesí, 'a ia ko te fa'ahinga ne'e mānumanu ki te pa'angá; pea ne'e notou fingofingo kiā Ia. ");
INSERT INTO num_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Pea iange 'e Ia kiā nātou, “Ko kōtou ia 'oku kotou ngāue pē ke hā totonu ki te kakaí; kā 'oku mea'i 'e te 'Atuá te kotou lotó. He ko te me'a 'oku fungani 'i te lau 'a te kakaí ko te fakalialia pē ia 'i te vakai 'a te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ne'e 'i ai 'ia te Laó mo te kau palōfitá 'o a'u mai kiā Sione; talu mei ai mo te malanga 'aki 'ia te Pule'anga 'o te 'Atuá, pea 'oku feinga mālohi ki ai 'ia te kakai kotoa pē. ");
INSERT INTO num_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kā 'oku faingafua ange ke mole 'ia te langí mo māmani 'i te tō kelekele he fe'i kohi 'e taha 'o te Laó. ");
INSERT INTO num_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Kā 'i ai he taha 'oku vete'i tono malí, 'o mali mo he fafine kehe, 'oku fe'auaki ia; pea ko ia 'e mali mo te fafine kua si'aki 'e tono malí, 'oku tono fafine ia. ");
INSERT INTO num_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ne'e 'i ai he tangata koloa'ina, ne'e tui ma'u pē te kofu kulakula mo te līneni mahu'inga, pea kai kātoanga ia 'i te 'aho kotoa pē. ");
INSERT INTO num_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pea ne'e 'i ai mo he matu'a masiva, ko tono hingoá ko Lāsalosi, ne'e fakatakoto atu ia fe'unga mo te hū'anga ki te fale 'o te matāpulé, ko te toko taha ne'e papala 'aupito. ");
INSERT INTO num_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Pea faka'amu 'e ia ke kai mai 'ia te 'ū momo ne'e ngangana mei te tēpile 'a te koloa'iná; kā ko te fanga kulií foki ne'e notou ōmai, 'o 'emo tono papalá. ");
INSERT INTO num_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Pea faifaí pea pekia 'ia te si'i masivá, pea fata ange 'ona 'e te kau 'āngeló ki te fatafata 'o 'Ēpalahamé. Ne'e pekia foki 'ia te matāpule koloa'iná, pea tanu. ");
INSERT INTO num_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Pea 'i tana 'i Hētesí ne'e ma'ua ia 'i te 'ū mamahí, pea sio atu ia, 'o 'ilo'i 'ia 'Ēpalahame 'oku nofo mama'o atu, pea mo Lāsalosi 'i tono fatafatá. ");
INSERT INTO num_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Pea kaila atu ia 'o pehē, ‘'Ēpalahame ē, 'ofa mai mu'a 'iā au, mo ke fekau 'ia Lāsalosi ke unu tono mu'a tuhú ki te vaí, mo'o fakamokomoko toku 'aleló; he 'okou mamahi lahi 'i te afi nei!’ ");
INSERT INTO num_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kae tali ange 'e 'Ēpalahame, ‘Si'aku foha, manatu'i ne ke ma'u ta'aú 'ū me'a lelei fuli pē 'i tau ma'ulí; pehē foki ne ma'u 'e Lāsalosi 'ia te 'ū koví; kā ko 'eni, 'i te feitu'u neí, 'oku ma'u 'e ia 'ia te fiamālié, kā ko koe 'ia te mamahí. ");
INSERT INTO num_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pea 'āsili aí, he ko te vaha'a 'o mātou mo koé 'oku 'i ai he fu'u vanu lahi kua fokotu'u, kote'uhí kā 'i ai he 'ihi 'oku fia ō atu mei heni kiā kōtoú ke 'aua na'a notou lava, 'uma'ā he laka mai kiā mātou mei hena.’ ");
INSERT INTO num_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Pea tali mai 'e ia, ‘Kāpau ko ia, pea ko taku kole kiā koé, 'e tamai, ke ke fekau'i mu'a 'ona ki te fale 'o taku tamaí, ");
INSERT INTO num_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","he 'oku 'i ai toku 'ū tokoua 'e toko nima; ke tala'i ange kiā nātou, ke 'aua na'a notou toe ha'u ki te feitu'u fakamamahi neí!’ ");
INSERT INTO num_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ka ne'e iange 'e 'Ēpalahame kiā ia, ‘'Oku notou ma'u 'ia Mōsese mo te kau palōfitá; ke notou fakaongo kiā nātou.’ ");
INSERT INTO num_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kae toe iange pē 'e ia, ‘Kailoa, 'Ēpalahame, kae kāpau 'e 'alu ange he taha 'iā nātou kua pekiá, kua pau 'e notou fakatomala!’ ");
INSERT INTO num_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pea toki tali ange 'e ia, ‘Kāpau 'e kala notou tokanga kiā Mōsese mo te kau palōfitá, 'e kailoa fakaloto'i nātou ia neongo 'e toetu'u he taha mei te pekiá.’ ” ");
INSERT INTO num_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Pea iange 'e Ia ki Tana kau akó, “'E kala lava ke ta'ofi 'ia te hoko mai 'o te 'ū tūkia'angá; kae pohoē te toko taha 'a ia 'e hoko mei aí! ");
INSERT INTO num_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","'Ē, ne'e mei sai ange ke tau he fu'u maka 'i tono kiá, 'o sī 'ona ki te taí, 'i tana ma'uli ke fakatūkia'i he fe'i toko taha 'iā nātou nei 'oku lilikí. ");
INSERT INTO num_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kotou lamasi 'ia kōtou. Kāpau 'e faihala te tou tokouá, valoki'i 'ona; pea kāpau 'e fakatomala ia, fakamolemole'i 'ona. ");
INSERT INTO num_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Pea neongo 'e tu'a fitu 'i te 'aho tana faihala kiā koé, kae tu'a fitu tana tafoki kiā koe, 'o pehē, ‘'Ē, 'okou fakatomala,’ kā pehē, 'e ke fakamolemole'i 'ona.” ");
INSERT INTO num_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Pea iange 'e te kau 'apōsetoló ki te 'Alikí, “Ke ke fakalahi te motou tuí.” ");
INSERT INTO num_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Pea folafola ange 'e te 'Alikí, “Ka ne 'i ai he kotou tui 'o tatau mo te fe'i pulapula'i mūsitá tono lahí, pea kā kotou kamata lea ki te fu'u fiki nei, ‘Fei mo mata'aki koe, pea hiki 'o tu'u 'i tai,’ kua ina fai leva ia 'o hangē ko te kotou leá. ");
INSERT INTO num_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Pea tou lau ko te toko taha 'iā kōtou 'oku 'i ai tana tamaio'aliki 'oku ngoue, pe tauhi monumanu; pea 'i te faifaí pea ha'u ia mei te ngoué, 'e ke pehē koā kiā ia, ‘Ha'u ai leva, 'o nofo ifo ke tā kai’? ");
INSERT INTO num_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","'E kailoa koā ko tau leá 'e pehē, ‘Ke ke teuteu'i mai mu'a taku me'akaí, pea nono'o tou kofú 'o tauhi kiā au, kae'aua ke 'osi taku kaí mo taku inú; pea 'i te 'osi ko iá, pea toki kai mo inu 'ia koe’? ");
INSERT INTO num_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ko te me'a koā ia ke fakamālō'ina 'i tono fai 'e tau tamaio'alikí 'ia te 'ū me'a ne ina tu'utu'uní? ");
INSERT INTO num_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pehē foki mo kōtou, neongo kua kotou fai kotoa pē 'ia te 'ū me'a ne tu'utu'uni atú, kae kotou pehē pē, ‘Ko te kau tamaio'aliki ta'e'aonga ai pē 'ia mātou, kua motou fai pē 'ia te me'a ne'e totonu ke motou faí.’ ” ");
INSERT INTO num_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Pea 'i Tana 'alu atu ki Selusalemá, ne'e fononga atu Ia 'i Samēlia mo Kāleli. ");
INSERT INTO num_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pea 'i Tana a'u ki he ki'i kolo 'e taha, ne'e fakafetaulaki mai kiā Ia he kau tangata 'e toko hongofulu ne'e kilia, 'o notou tutu'u mei te mama'ó. ");
INSERT INTO num_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Pea kalakalanga 'e te kau tangatá, 'o notou pehē, “'Aliki Sīsū, 'alo'ofa mai mu'a kiā mātou!” ");
INSERT INTO num_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pea 'i Tana vakai ki aí ne'e pehē ange 'e Ia, “Kotou ō pē, 'o fakahā 'ia kōtou ki te kau taula'alikí.” Pea 'i te notou kei ō atú, ne'e fakama'a 'ia nātou. ");
INSERT INTO num_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pea ko te toko taha 'iā nātou, 'i tana vakai leva kua ina ma'ulí, ne'e foki mai ia, 'o kalanga le'o lahi 'i tana fakamālō ki te 'Atuá; ");
INSERT INTO num_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","'o fo'oifo 'i te va'e 'o Sīsuú, 'o fakafeta'i kiā Ia. Pea ko te toko taha ko iá ko te Samēlia. ");
INSERT INTO num_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Pea tali 'e Sīsū, 'o iange, “Ne kailoa koā ko te toko hongofulu ne'e fakama'á? Pea ko fea leva te toko hivá ia? ");
INSERT INTO num_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kua kailoa 'iloa mai ai he notou taha ke fai he fakafeta'i ki te 'Atuá, kā ko te si'i muli pē ko 'ení!” ");
INSERT INTO num_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Pea iange 'e Ia ki te tangatá, “Tu'u ake, pea 'alu ā; kua fakama'uli 'ou 'e tau tuí.” ");
INSERT INTO num_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pea 'i tono fehu'i kiā Ia 'e te kau Fālesí, pē 'e hoko fakafea mai 'ia te Pule'anga 'o te 'Atuá, pea tali 'e Ia kiā nātou, 'o pehē, “Ko te hoko mai 'ia te Pule'anga 'o te 'Atuá 'e kailoa ala 'ilo'i ia, ");
INSERT INTO num_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","'uma'ā he fa'a pehē he 'ihi, ‘'Ē, ko 'eni ia;’ pe, ‘Ko 'ena;’ he vakai, ko te Pule'anga 'o te 'Atuá 'oku 'iā kōtou ia.” ");
INSERT INTO num_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Pea iange 'e Ia ki te kau akó, “Tokaange he taimi 'e kotou faka'amu ai ke toe mamata ki te taha 'o te 'ū 'aho 'o te Fanautama te Tangatá, kā 'e kailoa kotou mamata ki ai. ");
INSERT INTO num_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pea 'e iatu 'e te 'ihi kiā kōtou, ‘'Ē, ko 'eni ia;’ pe, ‘'Ē, ko 'ena ia.’ 'Aua 'e kotou afe atu, pe mulimuli ki ai. ");
INSERT INTO num_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","He 'oku hangē ko te tapa mai te 'uhilá mei te 'āfaki 'e taha 'o te langí, 'o hulu'i 'o a'u ki te 'āfaki 'e tahá, 'e pehē pē foki 'ia te Fanautama te Tangatá 'o kā hoko mai Tono 'ahó. ");
INSERT INTO num_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kā kua pau ke fu'aki lahi tono fakamamahi'í, mo tono si'aki 'Ona 'e te to'utangata nei. ");
INSERT INTO num_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Pea hangē ko ia ne'e fai 'i te kuonga 'o Noá, 'e pehē foki 'i te kuonga 'o te Fanautama te Tangatá. ");
INSERT INTO num_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ne'e notou kakai, ne'e notou iinu, ne'e notou ma'u 'unoho, ne'e notou foaki ke mali, 'o a'u ki te 'aho ko ia ne'e hū ai 'ia Noa ki te 'a'aké, mo te hoko mai 'ia te lōmakí, 'o faka'auha 'ia nātou kotoa pē. ");
INSERT INTO num_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","'E tatau foki mo ia ne'e hoko 'i te kuonga 'o Loté: ne'e notou kakai, ne'e notou iinu, ne'e notou fakatau mai, ne'e notou fakatau atu, ne'e notou tō ta'u, ne'e notou langa fale, ");
INSERT INTO num_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","kā 'i te 'aho ko ia ne'e hū atu ai 'ia Lote mei Sōtomá, ne'e faka'ua ifo 'ia te afi mo te maka vela mei langi, 'o faka'auha 'ia nātou fuli pē. ");
INSERT INTO num_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","'E tatau tofu pē mo ia 'ia te 'aho 'e fakahaa'i mai ai 'ia te Fanautama te Tangatá. ");
INSERT INTO num_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","'I te 'aho ko iá, kā 'i ai he taha 'oku 'i te tu'a falé, kae 'i loto fale tana nga'ota'otá, ke 'aua na'a 'alu ifo ke 'ave ia: pehē foki; ko ia 'oku 'i te ngoué, ke 'aua na'a tafoki ke 'aumai 'ia te 'ū me'a kua tuku 'i 'apí. ");
INSERT INTO num_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Manatu'i te hoa 'o Loté. ");
INSERT INTO num_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kā 'i ai he taha 'e feinga ke fakahaofi tana ma'ulí, 'e mole ia; kā ko ia kua tuku tana ma'ulí ke molé, 'e ma'u mai ia. ");
INSERT INTO num_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Tala'i atu, ko te pō ko iá 'e 'i ai he ongo tangata 'i te moe'anga pē taha; 'e 'ave te taha, kae tuku te taha. ");
INSERT INTO num_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","'E fakataha he ongo fafine 'o momosi; 'e 'ave te taha kae tuku te taha. ");
INSERT INTO num_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","'E 'i ai he ongo tangata 'e toko ua 'e nā 'i te ngoué; 'e 'ave te taha kae tuku te taha.” ");
INSERT INTO num_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Pea notou tali ange, 'o pehē ki Ai, “'I fea, 'Aliki?” Pea iange Ia kiā nātou, “Ko te feitu'u 'oku 'i ai te 'anga'angá, 'e fakataha foki ki ai 'ia te fanga 'īkalé.” ");
INSERT INTO num_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Pea lea 'aki 'e Ia he talanoa fakatātā kiā nātou ke fakahaa'i, ko tono tonú ke notou lotu ma'u pē, 'o 'aua na'a fiu. Pea iange 'e Ia, ");
INSERT INTO num_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Ne'e 'i ai he fakamaau 'i te kolo 'e taha, 'a ia ne'e kailoa ina 'apasia ki te 'Atuá, pe toka'i he tangata. ");
INSERT INTO num_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Pea ne'e 'i ai he fafine uitou 'i te kolo ko iá, ne'e fa'a ha'u kiā ia 'o pehē, ‘Ke ke fai fakamaau ma'aku mo fakahaofi 'oku mei toku filí.’ ");
INSERT INTO num_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pea kua fualoa mo te kailoa pē ha'aná tali. Kae toki fakakaukau 'e ia, 'o pehē, ‘Neongo pē 'oku kailoa ke au 'a'apa ki te 'Atuá, mo kailoa ke au toka'i he tangata, ");
INSERT INTO num_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kā kote'uhí ko te fakafiu mai 'ia te uitou nei, 'e au taukapo'i leva 'ona, na'a tautu'u mai ia 'o ta'engata, pea u kina 'iā ia.’ ” ");
INSERT INTO num_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Pea folafola ange te 'Alikí, “Fanongo ā ki te lea 'a te fakamaau kākaá. ");
INSERT INTO num_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Pea 'e kailoa koā fai 'e te 'Atuá 'ia te fakamaau ma'a Tono kakai filí, 'a ia 'oku notou tangi kiā Ia 'i te 'aho mo te pō, neongo Tana fakatuatuai kiā nātoú? ");
INSERT INTO num_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Tala'i atu, 'e fai pē he fakamaau ma'a nātou, pea 'e vave. Kae kā hoko mai 'ia te Fanautama te Tangatá, 'e kei ma'u koā 'e Ia he tui pehē 'i māmani?” ");
INSERT INTO num_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Pea ne'e lea 'aki 'e Ia 'ia te talanoa fakatātā neí ke tau ki te 'ihi ne'e notou 'afungi 'oku notou mā'oni'oni, mo notou sio lalo ki tono toe 'o te kakaí: ");
INSERT INTO num_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ne'e ō ake he ongo tangata ki te Temipalé ke fai te nā lotu; ko te Fālesi te taha pea ko te taha ko te tangata tānaki tukuhau. ");
INSERT INTO num_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ko te Fālesí ne'e tu'u taha atu ia, 'o lotu, 'o pehē, ‘'E 'Atua, 'okou fakafeta'i atu, 'oku kala u hangē ko tono toe 'o te kakaí, 'ia te kau fakamālohí, mo te kau kākaá, mo te kau fe'auakí, kae'uma'ā haku hangē ko te tangata tānaki tukuhau ko 'ení. ");
INSERT INTO num_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","'Okou 'aukai tu'a ua 'i te uike, 'okou 'avatu tono vahe hongofulu 'o te me'a kotoa pē 'okou ma'ú.’ ");
INSERT INTO num_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kā ko te si'i tangata tānaki tukuhaú ne'e tu'u pē ia mei te feitu'u mama'o atu, pea na'a mo tono matá ne kailoa fa'a hanga ake ki te langí; kae sī fatafata pē ia, mo pehē, ‘'E 'Atua, ke ke fakamolemole'i mu'a 'oku, 'ia au ko te angahala.’ ");
INSERT INTO num_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Tala'i atu, ne'e 'alu atu 'ia te toko taha ko iá ki tono 'apí, kua ne ma'u he tonuhia ne'e lahi ange 'i te tonuhia 'a te tangata 'e tahá. He ko ia 'oku hākeaki'i 'oná, 'e fakavaivai'i; pea ko ia 'oku fakavaivai'i 'oná, 'e hākeaki'i.” ");
INSERT INTO num_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Pea ne'e 'aumai 'e te kakaí kiā Ia te notou fānau lilikí, kote'uhí ke ala 'e Ia kiā nātou. Kā 'i te sio ki ai 'ia te kau akó ne'e notou lolomi 'ia te kakaí. ");
INSERT INTO num_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ka ne'e ui ange 'e Sīsū ke notou ōmai, 'o Ina iange, “Tukuange pē te tamalikí ke notou ha'u kiā Au, pea 'aua 'e ta'ofi nātou. Hē 'oku ma'a te fa'ahinga ko iá 'ia te Pule'anga 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","'Okou tala mo'oni atu kiā kōtou, ko ia 'e kailoa ina tali 'ia te Pule'anga 'o te 'Atuá 'o hangē ko he tamasi'í, 'e kailoa 'aupito hū ia ki ai.” ");
INSERT INTO num_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Pea toki fehu'i kiā Ia he toko taha, 'a ia ko te pule, 'o pehē, “Tangata'aliki lelei, ko te ā 'e au fai kae au ma'u 'ia te ma'uli ta'engatá?” ");
INSERT INTO num_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Pea iange 'e Sīsū kiā ia, “Ko te ā kua ke ui ai 'Oku ko te leleí? 'Oku kailoa he taha 'oku lelei, ngata pē 'i te 'Atuá toko taha. ");
INSERT INTO num_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","'Oku ke 'ilo'i pē 'ia te 'ū fekaú: ‘'Aua na'a ke fe'auaki, 'aua na'a ke fakapō, 'aua na'a ke kaiha'a, 'aua na'a ke fakamo'oni lohi, faka'apa'apa ki tau tamaí mo tau fa'eé.’ ” ");
INSERT INTO num_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Pea tali ange 'e ia, “Ko te 'ū fekau fuli pē ko iá kua u tauhi ki ai talu taku kei tamasi'í.” ");
INSERT INTO num_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Pea 'i te fanongo 'e Sīsū ki aí, ne'e iange leva 'e Ia, “'Oku kei toe he me'a 'e taha ke ke fai: fakatau atu te me'a kotoa pē 'oku ke ma'ú, pea tufa tono pa'angá ki te masivá, pea 'e 'i ai he fu'u koloa 'e fa'olaki ma'au 'i hēvani; pea ke ha'u leva, 'o mulimuli 'iā Au.” ");
INSERT INTO num_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pea 'i tana fanongo ki te lea ko iá, ne'e mamahi lahi ia, he ne'e koloa'ina 'aupito ia. ");
INSERT INTO num_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Pea 'i te sio 'e Sīsū ki tana mata mamahí, ne'e pehē ange 'e Ia, “'E faingata'a 'aupito kiā nātou 'oku koloa'iná ke hū ki te Pule'anga 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","He 'oku faingafua ange ke ulu he kāmeli 'i te ava'i hui tuitui, 'i te hū he koloa'ina ki te Pule'anga 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Pea ko nātou ne'e fanongo ki aí ne'e notou pehē, “Pea ko ai ia 'e ala ma'uli?” ");
INSERT INTO num_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Pea pehē ange 'e Ia, “Ko te 'ū me'a 'oku kailoa malava 'e te tangatá, 'oku malava pē ia 'e te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pea iange 'e Pita, “Vakai, ko mātou 'eni ia kua motou si'aki te 'ū me'a tonu 'a mātoú, 'o motou mulimuli kiā Koe!” ");
INSERT INTO num_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Pea iange 'e Ia kiā nātou, “'Okou tala mo'oni atu kiā kōtou, 'oku kailoa he taha kua si'aki he fale, pe mali, pe 'ū tokoua, pe mātu'a, pe fānau, kote'uhiā ko te Pule'anga 'o te 'Atuá, ");
INSERT INTO num_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kā 'e toe ma'u mai 'e ia 'o lōlahi 'i te nofo ko 'ení, pea 'i te maama kaha'ú ko te ma'uli ta'engata.” ");
INSERT INTO num_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Pea 'ave 'e Ia 'ia te kau hongofulu mā uá, 'o iange kiā nātou, “Ko 'eni, 'oku tou ō ake ki Selusalema, pea 'e fai 'i ai 'ia te 'ū me'a kotoa pē ne'e tohi 'e te kau palōfitá kau ki te Fanautama te Tangatá. ");
INSERT INTO num_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","He 'e tuku atu 'Ona ki te kau Senitailé, pea 'e notou manuki'i 'Ona, mo notou pā'usi'i mo 'anuhia; ");
INSERT INTO num_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","pea 'e notou haha 'Ona, mo tāmate'i, pea 'i tono 'aho tolú, 'e toetu'u Ia.” ");
INSERT INTO num_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ka ne'e kailoa 'aupito teitei mahino kiā nātou he me'a 'e taha 'o te 'ū lea ko iá; pea ne'e puli 'ia te 'ū lea ko 'ení meiā nātou, 'o notou ta'emahino'i ai pē 'ia te 'ū me'a ne Ina lea 'akí. ");
INSERT INTO num_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Pea 'i Tana ofi atu ki Selikoó, ne'e nofo mei te va'ealá he matu'a kui, 'o fai tana kolekole. ");
INSERT INTO num_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Pea 'i tana fanongo ki te 'alu ange te fu'u kakaí, ne'e fehu'i ange 'e ia pe ko te ā tono 'uhingá. ");
INSERT INTO num_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Pea notou iange, “Ko Sīsū ko 'ē mei Nāsaletí 'oku me'a mai heni.” ");
INSERT INTO num_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Pea toki kalanga ia, 'o pehē, “Sīsū ē! Hako 'o Tēvitá, 'alo'ofa mai mu'a kiā au!” ");
INSERT INTO num_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Pea ko nātou ne'e mu'amu'á ne'e notou kamata ta'ofi ia ke longo. Ka ko te sianá, ne'e fakautuutu pē ta'aná kalanga, “Hako 'o Tēvitá ē, 'alo'ofa mai mu'a kiā au!” ");
INSERT INTO num_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Pea tu'u ai 'ia Sīsū, 'o fekau ke taki mai 'ia te sianá. Pea 'i tana ofi maí, ne'e fehu'i ange 'e Ia, ");
INSERT INTO num_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ko te ā te me'a 'oku ke holi ke Au fai ma'aú?” Pea iange 'e ia, “'Aliki, ke au 'ala mu'a!” ");
INSERT INTO num_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Pea folafola 'e Sīsū kiā ia, “Ke 'ala 'ia koe; kua fakama'uli 'ou 'e tau tuí!” ");
INSERT INTO num_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Pea 'ala leva ia, 'o mulimuli kiā Sīsū, mo fakamālō'ina 'ia te 'Atuá. Pea ko te kakai kotoa pē ne'e notou sio ki aí, ne'e notou fakamālō lahi ki te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Pea ne'e ha'u 'ia Sīsū ki Selikō, 'o 'alu atu 'i te loto koló. ");
INSERT INTO num_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Pea vakai, ne 'i ai he tangata ne'e hingoa ko Sākeasi; pea ko te pule ia 'o te kau tānaki tukuhaú, pea ne'e koloa'ina ia. ");
INSERT INTO num_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Pea ne'e feinga 'e ia ke mamata kiā Sīsū, pe ko ai nai Ia; kā ne kala ina lava kote'uhí ko te fu'u kakaí, he ne'e pukupuku ia. ");
INSERT INTO num_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Pea lele mu'amu'a ia, 'o kake he fu'u sukamino, kote'uhí ke mamata kiā Sīsū; he ne'e hu'u Tana fonongá ki te feitu'u ko iá. ");
INSERT INTO num_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Pea 'i te a'u 'ia Sīsū ki te feitu'u ko iá, ne me'a ake 'e Ia, 'o iange kiā ia, “'E Sākeasi, fai vave, pea 'alu ifo; he kua pau ke Au 'apitanga 'i tou falé 'i te 'aho nei.” ");
INSERT INTO num_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Pea fakavave ia, 'o 'alu ifo, 'o talitali fiafia 'Ona. ");
INSERT INTO num_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pea lāunga 'ia te kakai kotoa pē 'i te notou sisio ki aí, 'o notou pehē, “'Ē, kua 'alu te Siana nei ke nā kai mo he siana angahala.” ");
INSERT INTO num_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Pea tu'u ai 'ia Sākeasi, 'o iange ki te 'Alikí, “'Aliki, ko 'eni 'e au 'avatu tono vaeua 'o taku nga'ota'otá ki te masivá; pea kāpau kua u ma'u he me'a 'i tono lohiaki'i he taha, 'e au toe totongi ange 'o liunga fā.” ");
INSERT INTO num_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Pea iange 'e Sīsū kiā ia, “Ko te 'aho neí kua hoko mai 'ia te fakama'ulí ki te fale nei, kae'uma'ā ko te hako foki 'eni 'o 'Ēpalahame. ");
INSERT INTO num_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","He ne'e ha'u 'ia te Fanautama te Tangatá ke kumi mo fakama'uli 'ia nātou kua molé.” ");
INSERT INTO num_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Pea 'i te notou fanongo ki te me'a ko iá, ne toe fokotu'u atu 'e Ia mo he talanoa fakatātā; ko tono 'uhingá, he kua ofi Ia ki Selusalema, pea 'oku 'amanaki te kakaí, 'oku vave 'aupito tono fakahaa'i mai 'ia te Pule'anga 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ko ia ai, ne'e lea 'e Ia 'o pehē, “Takua ne'e 'i ai he tangata, ko te fe'i 'aliki, ne ina 'alu ki te fanua mama'o ke ma'u mo'ona he pule'anga, pea toki foki mai. ");
INSERT INTO num_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pea ui 'e ia he toko hongofulu 'o tana kau tamaio'alikí, 'o tuku kiā nātou he mina pa'anga 'e hongofulu, 'o iange kiā nātou, ‘Fai fakatau 'aki ia 'i te lolotonga taku mama'ó.’ ");
INSERT INTO num_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kā ko te kakai 'o tono fanuá ne'e notou fihi'a kiā ia, 'o notou fekau atu he kau fakafofonga ke fakahaa'i, ‘'Oku kala motou loto ke ke fakanofo te siana nei ke tu'i kiā mātou.’ ");
INSERT INTO num_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pea faifaí pea foki mai ia, kua 'o'ona 'ia te pule'angá; pea fekau 'e ia ke ui mai te tu'unga tamaio'aliki ko iá, 'ā ē ne'e tuku ki ai 'ia te pa'angá, kote'uhí ke mea'i 'e ia pe kua fefe'aki te notou fakataú. ");
INSERT INTO num_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Pea tu'u mai 'ia te 'uluakí, 'o iange, ‘'Aliki, ko tau miná kua toe ma'u mai 'e ia mo he mina kehe 'e hongofulu.’ ");
INSERT INTO num_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Pea me'a mai 'e ia, ‘'Oi seuke! Mālō, si'i tamaio'aliki lelei! Pea ko te me'a 'i tau anga-tonu 'i te ki'i me'a si'isi'i peheé, 'e ke nofo koe ko te pule ki te kolo 'e hongofulu.’ ");
INSERT INTO num_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Pea ha'u mo tono uá, 'o iange 'e ia, ‘'Aliki, ko tau miná kua toe fakatupu mai mo he mina kehe 'e nima.’ ");
INSERT INTO num_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Pea ki te toko taha ko iá foki ne'e me'a mai 'e ia, ‘Mo koe, foki, 'e ke hoko ko te pule ki te kolo 'e nima.’ ");
INSERT INTO num_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Pea ha'u mo te toko taha, 'o iange, ‘'Aliki, ko 'ena tau miná, 'a ia kua u tauhi 'o kofu 'aki he holoholo; ");
INSERT INTO num_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","he ne au manahē kiā koe, kote'uhí ko te tangata faingata'a 'ia koe. He ko tou angá ke 'eke 'ia te me'a ne'e kala ke 'avangé, pea ke utu te me'a ne kala ke toó.’ ");
INSERT INTO num_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Pea pehē mai 'e ia, ‘'Ia te tamaio'aliki pau'u! 'E au fakamāu'i 'ou mei tau lea 'a'aú. Ne ke 'ilo'i koā ko te tangata faingata'a 'ia au, 'okou 'eke te me'a ne'e kala u 'avangé, mo utu te me'a ne kala u toó? ");
INSERT INTO num_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Pea ko te ā ne'e kala ke tuku ai taku pa'angá ki te pangikeé, pehē kua u ma'u mai ia mo tono tupú foki 'i taku ha'u nei?’ ");
INSERT INTO num_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Pea me'a 'e ia kiā nātou ne'e tutu'u 'i aí, ‘Kotou to'o te miná meiā ia, 'o 'ave kiā ia 'oku ma'u te hongofulú.’ ");
INSERT INTO num_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","(Pea notou iange kiā ia, ‘'Aliki, kā 'oku hongofulu ta'aná mina.’) ");
INSERT INTO num_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Tala'i atu, ko ia kotoa pē 'oku ma'ú, 'e 'avange ki ai mo he me'a; kā ko ia 'oku kailoa ma'ú, na'a mo te me'a 'oku ma'u 'e iá 'e to'o meiā ia. ");
INSERT INTO num_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kā ko toku 'ū fili kotoa pē ne kailoa notou loto ke au pule kiā nātoú, taki mai ki heni, pea tāmate'i 'i toku 'aó!’ ” ");
INSERT INTO num_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pea kua 'osi Tana 'ū lea ko iá, pea mu'amu'a Ia 'iā notou, ko Tana 'alu ake ki Selusalema. ");
INSERT INTO num_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Pea 'i te ofi mai Ia ki Petefesi mo Pētani, ki te ma'unga 'oku ui ko 'Ōlivé, ne Ina fekau atu he toko ua 'o Tana kau akó, ");
INSERT INTO num_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","'o iange, “Kulā ō ki te ki'i kolo 'oku hanga maí; pea 'i te kulā a'u atú, 'e kulā 'ilo'i he ki'i 'asi 'oku nono'o 'i ai, 'a ia kua he'iki ai heka ai he taha; pea kulā vete ia, 'o taki mai. ");
INSERT INTO num_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Pea kā 'i ai he taha 'e fehu'i atu, ‘Ko te ā 'oku kulā vete ai?’ pea kulā iange 'o pehē, ‘'Oku fia ma'u 'ona 'e te 'Alikí.’ ” ");
INSERT INTO num_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Pea ō atu te ongo me'á, 'o nā 'ilo'i pē 'o hangē ko Tana me'a kiā nāuá. ");
INSERT INTO num_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pea 'i te lolotonga te nā vete 'ia te ki'i 'así, mo te lea mai 'ia te kakai ne'e 'o nātou iá, “Ko te ā 'oku kulā vete ai te ki'i 'así?” ");
INSERT INTO num_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Pea nā iange, “'Oku fia ma'u ia 'e te 'Alikí.” ");
INSERT INTO num_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pea nā taki ia kiā Sīsū: pea notou 'ai te notou pulupulú ki te 'así, 'o fakaheka ki ai 'ia Sīsū. ");
INSERT INTO num_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Pea 'i Tana kamata me'a atú, ne'e notou falikiliki te alá 'aki te notou 'ū pulupulú. ");
INSERT INTO num_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pea 'i Tana ofi atu, 'o kamata 'alu ifo 'i te ma'unga ko 'Ōlivé, ne'e pā mavava 'ia te fu'u fakataha kātoa 'o te kau akó, 'o notou fakamālō fiafia mo le'o lahi ki te 'Atuá, kote'uhí ko te 'ū ngāue mamafa kua notou mamata ki aí. ");
INSERT INTO num_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ne'e notou pehē, “'Oku manū'ia 'ia te Tu'i 'oku hā'ele mai 'i te huafa 'o te 'Alikí! Ke 'i ai he melino 'i Langi, mo he kolōlia 'i Langi Taupotu!” ");
INSERT INTO num_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Pea ko te 'ihi 'o te kau Fālesi ne'e 'i te kakaí, ne'e notou pehē ange kiā Ia, “Tangata'aliki, fekau Tau kau akó ke notou lolongo!” ");
INSERT INTO num_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ka ne'e tali ange 'e Ia 'o pehē, “Tala'i atu, kāpau 'e notou fakalongolongo 'e nātou, 'e kaikaila 'ia te 'ū fe'i maká!” ");
INSERT INTO num_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Pea 'i Tana ofi atu, 'o hā mai 'ia te koló, ne'e tangi mamahi Ia, ");
INSERT INTO num_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","mo pehē, “'Ē, pehē ange mai ne ke lave'i, 'io, 'e koe, 'i tou 'aho nei, 'ia te 'ū me'a 'oku kau ki tau fiamālié! Kā kua fufuu'i 'eni ia meiā koe. ");
INSERT INTO num_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","'E hoko mai he 'aho 'e 'ākolo'i ai 'ou 'e tou 'ū filí, pea 'e notou kāpui 'ou, mo tāpuni'i 'ou mei te 'āfaki kotoa pē, ");
INSERT INTO num_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","pea 'e notou laiki 'ou mo tau fānaú foki. Pea 'e kailoa notou tuku hau fe'i maka 'o ta'eholoki; kote'uhí ne'e kailoa ke lave'i te taimi 'o tou 'a'ahí!” ");
INSERT INTO num_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pea hū Ia ki te Temipalé, 'o kamata tono tuli 'ia nātou ne'e notou fai fakatau 'i aí; ");
INSERT INTO num_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","'o iange 'e Ia, “Kua tohi, ‘Ko Toku falé ko te falelotu;’ kā kua kotou ngaahi ia ko te 'ana 'o he kau kaiha'a.” ");
INSERT INTO num_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pea ne'e faiako 'e Ia 'i te Temipalé 'i te 'aho kotoa pē. Pea ko te kau taula'aliki lahí mo te kau sikalaipé mo te kau takimu'a 'o te kakaí ne'e notou feinga ke tāmate'i 'Ona, ");
INSERT INTO num_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","kā ne kailoa notou 'ilo'i pe ko te ā 'e notou faí; he ko te kakaí kotoa pē ne'e notou tokanga lahi 'aupito ke notou fānonongo kiā Ia. ");
INSERT INTO num_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Pea ko te 'aho 'e taha, lolotonga Tana faiako ki te kakaí mo malanga 'aki 'ia te ongoongoleleí 'i te Temipalé, ne'e tutu'u mai 'ia te kau taula'aliki lahí mo te kau sikalaipé, fakataha mo te kau mātu'á, ");
INSERT INTO num_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","'o notou pehē, “Tala'i mai angé pe ko te mafai mei fea 'oku fai ai 'e Koe 'ia te 'ū me'a nei? Pea ko ai ne ina tuku kiā Koe 'ia te mafai ko iá?” ");
INSERT INTO num_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Pea tali ange 'e Ia, “Ke fai atu mo Au Ha'akú fehu'i, pea kotou tali mai: ");
INSERT INTO num_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ko te fai papitaiso 'a Sioné, ne'e mei hēvani ia, pe mei te tangatá?” ");
INSERT INTO num_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pea notou fealealea'aki leva 'iā nātou, 'o pehē, “Kāpau 'e tou tali, ‘Mei hēvani,’ 'e pehē mai 'e Ia, ‘Pea ko te ā ne'e kailoa kotou tuitala ai kiā iá?’ ");
INSERT INTO num_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pea kāpau 'e tou pehē, ‘Mei te tangatá,’ 'e tolongi tātou 'e te kakaí fuli pē; he 'oku notou tui 'aupito ko Sioné ko he palōfita.” ");
INSERT INTO num_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Pea notou iange leva, “'Oku kala motou 'ilo'i pe ne'e mei fea ia.” ");
INSERT INTO num_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Pea iange 'e Sīsū kiā nātou, “Pea 'e kailoa ā ke Au tala'i atu 'e Au, pe ko te ā Toku mafai 'Okou fai ai 'ia te 'ū me'a neí.” ");
INSERT INTO num_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pea lea 'aki 'e Ia ki te kakaí 'ia te talanoa fakatātā ko 'ení: “Takua ko he tangata ne'e tō tana ngoue vaine, pea tuku atu 'e ia ke lisi 'e te kau fa'a, kae 'alu ia ki muli, 'o fualoa 'i ai. ");
INSERT INTO num_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pea 'i tana a'u ki te to'ukaí, ne ina fekau'i atu he tamaio'aliki ki te kau fa'á, kote'uhí ke notou tuku mai kiā ia tono 'inasi mei te fua 'o te ngoué. Kā ko te kau fa'á ne'e notou haha ia, mo fakafoki nga'asi. ");
INSERT INTO num_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Pea toe fekau'i atu 'e ia mo he tamaio'aliki kehe. Pea notou toe haha mo pā'usi'i mo fakafoki nga'asi mo te toko taha ko iá. ");
INSERT INTO num_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pea ne ina toe fekau'i mai mo tono toko tolú. Pea notou taa'i mo ia foki, 'o sī 'ona ki tua'ā kua lavelavea. ");
INSERT INTO num_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Pea toki pehē 'e te 'aliki 'o te ngoue vainé, ‘Ko te ā taku me'a 'e faí? 'Ē, 'e au fekau'i atu toku foha 'ofa'angá; na'a notou toka'i ā 'ona.’ ");
INSERT INTO num_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kā 'i te vakai atu 'e te kau fa'á kiā iá, ne'e notou fepehē'aki, ‘Ko te 'eá 'ena; tou tāmate'i mu'a ia, kae 'o tātou 'ia te tofi'á.’ ");
INSERT INTO num_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Pea notou toho leva 'ona ki te tua'ā ngoué, 'o tāmate'i. Pea ko te ā leva 'e fai kiā nātou 'e te 'aliki 'o te ngoue vainé? ");
INSERT INTO num_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","'E hoko mai ia 'o faka'auha 'ia te kau fa'a ko iá, pea 'avange te ngoue vainé ki te 'ihi kehe.” Pea 'i te notou fanongo ki aí, ne'e notou pehē, “'Aua 'aupito!” ");
INSERT INTO num_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pea siofia 'e Ia 'ia nātou, mo iange, “Kā ko te ā ai 'eni kua tohí, ‘Ko te maka ne'e fakata'e'aonga'i 'e te kau tufungá, kua hoko ia ko te fungani maka 'o te tulikí’? ");
INSERT INTO num_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kā 'i ai he taha 'e tō ki te maka ko iá 'e mafasifasi; kā ko ia 'e tō 'ia te maká ki ai, 'e laiki 'ona ke efu.” ");
INSERT INTO num_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Pea ko te kau sikalaipé mo te kau taula'aliki lahí ne'e notou feinga ke puke'i 'Ona 'i te taimi ko iá; ka ne'e notou manahē ki te kakaí, he ne'e notou 'ilo'i kua Ina lea 'aki 'ia te talanoa fakatātā ko iá 'o kau kiā nātou. ");
INSERT INTO num_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pea notou lamalama faingamālie leva, 'o notou fekau'i atu he 'ihi kua ako'i ke notou fakamā'oni'oni lohi'i 'ia nātou, kote'uhí ke notou ma'u'i 'Ona 'i te aleá, kae notou tuku'i atu 'Ona ki te pule mo te mafai 'o te kōvaná. ");
INSERT INTO num_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Pea notou fehu'i ange kiā Ia, 'o pehē, “Tangata'aliki, 'oku motou 'ilo'i 'oku totonu pē Ta'aú lea mo te ako, pea 'oku kailoa Ke filifilimānako; pea 'oku Ke ako totonu 'aki 'ia te ala 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Pe 'oku ngafua ke motou totongi tukuhau kiā Sisa, pe kailoa?” ");
INSERT INTO num_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ka ne'e 'ilo'i lelei pē 'e Ia te notou kākaá, 'o iange kiā nātou, ");
INSERT INTO num_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Fakahaa'i mai he fe'i tēnali. Ko te fofonga mo te hingoa 'o ai 'oku 'i aí?” Pea notou tali ange, “'O Sisa.” ");
INSERT INTO num_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Pea iange 'e Ia kiā nātou, “'Āua; pe'i 'avange kiā Sisa 'ia te 'ū me'a 'a Sisá, pea ki te 'Atuá 'ia te 'ū me'a 'a te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Pea ne'e kailoa notou lava ke puke ki Tana leá 'i te 'ao 'o te kakaí, pea notou 'ohovale lahi 'i Tana talí, 'o notou fakalongolongo ai pē. ");
INSERT INTO num_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Pea ne'e ōmai he 'ihi 'o te kau Sātusí, 'ia nātou 'oku pehē 'oku kailoa he toetu'ú; pea notou fehu'i kiā Ia, 'o pehē, ");
INSERT INTO num_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Tangata'aliki, ne'e tohi mai 'e Mōsese 'o pehē, ‘Kāpau 'e pekia he taha 'o he tautēhina, 'a ia ne'e 'i ai tono hoa, kā 'oku kailoa hana fānau, pea ma'u leva 'e tono tokouá 'ia te finematu'á, ke fakatupu ai he hako ki tono tokouá.’ ");
INSERT INTO num_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pea ne'e 'i ai he tautēhina 'e toko fitu; pea ne'e ma'u hoa 'ia te 'uluakí, pea pekia ta'ehako ia. ");
INSERT INTO num_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ko tono uá foki, ");
INSERT INTO num_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","mo tono toko tolú ne nā ma'u 'ona; pea pehē pē mo te toko fitú; ne'e kailoa he notou hako, pea notou pekia. ");
INSERT INTO num_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pea toki pekia ki muli mai mo te fafiné. ");
INSERT INTO num_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Pea 'i te toetu'ú 'e hoko te fafine ko iá ko te mali 'o ai 'iā nātou? He ko te toko fitú kotoa ne'e notou ma'u 'ona ko te notou mali.” ");
INSERT INTO num_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Pea iange 'e Sīsū kiā nātou, “Ko te fānau 'o te maama ko 'ení 'oku notou mali mo foaki 'unoho, 'ia tangata mo fafine; ");
INSERT INTO num_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","kā ko nātou 'oku notou lava'i tono taau ke ma'u 'ia te maama ko 'ená, mo te toetu'u mei te pekiá, 'e kailoa notou ma'u mali, pe foaki 'unoho. ");
INSERT INTO num_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Hē 'oku kailoa foki notou kei lava ke pekia, kā 'oku notou tatau mo te kau 'āngeló; pea ko te fānau nātou 'a te 'Atuá, he ko te fānau 'o te toetu'ú. ");
INSERT INTO num_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kā ko te me'a ki te toe fokotu'u 'o te pekiá, na'a mo Mōsese ne ina lea 'aki 'i te vahe 'oku kau ki te talatala'āmoá, 'i tana lau ki te 'Alikí ko te 'Atua 'o 'Ēpalahame, mo te 'Atua 'o 'Aisake, mo te 'Atua 'o Sēkope. ");
INSERT INTO num_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Hē 'oku kala ko te 'Atua Ia 'o te maté kā 'o te ma'ulí, kote'uhí 'i Tana 'afio 'A'aná 'oku notou mā'u'uli kotoa pē.” ");
INSERT INTO num_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Pea tali ange he 'ihi 'o te kau sikalaipé, 'o pehē, “Tangata'aliki, kua mālō Tau leá.” ");
INSERT INTO num_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","He ne'e kailoa notou toe fakato'ato'a ke fai he fehu'i kiā Ia. ");
INSERT INTO num_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pea tē iange 'e Ia kiā nātou, “'Oku fefe'aki te notou lau ko te Kalaisí ko te Hako Ia 'o Tēvita? ");
INSERT INTO num_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kā 'oku lau 'e Tēvita 'i te Tohi Saamé: ‘Ne folafola te 'Alikí ki toku 'Alikí, Nofo Koe 'i Toku to'omata'ú, ");
INSERT INTO num_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kae'aua ke Au ngaahi Tou 'ū filí ko Tou tu'unga va'e.’ ");
INSERT INTO num_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kāpau 'oku ui Ia 'e Tēvita ko tono 'Aliki, pea ko tono hako fefe'aki leva Ia?” ");
INSERT INTO num_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Pea toki iange 'e Ia ki Tana kau akó 'i te 'ao 'o te kakaí kotoa pē, ");
INSERT INTO num_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kotou lamalama 'ia te kau sikalaipé, he ko te notou manakó ke 'eva'eva mo te kofu tōtōlofa, pea notou havala ke faka'apa'apa'ina 'i te mala'e fakataú, mo te nonofo ki mu'a 'i te falelotú, mo te 'ū kātoangá. ");
INSERT INTO num_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","'Oku notou folo 'ia te 'ū 'api 'o te kau uitoú, mo notou mounu 'aki te notou lotu loaloá. 'E ma'u 'e te kau siana ko iá he tautea 'oku kovi ange.” ");
INSERT INTO num_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Pea 'i Tana hanga aké ne'e mamata atu Ia ki te sī 'e te kakai koloa'iná te notou me'a'ofá ki te puha tānaki'anga me'a'ofá. ");
INSERT INTO num_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Pea sio Ia ki te fafine uitou masiva 'oku sī ki ai he ongo ki'i pa'anga kapa. ");
INSERT INTO num_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Pea iange leva 'e Ia, “'Okou tala'i mo'oni atu, ko te si'i uitou masiva ko 'ení, ne'e hulu atu ta'aná sī 'iā nātou kotoa pē. ");
INSERT INTO num_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","He ko nātoú kotoa pē, ne'e notou sī mei te pa'anga hulu 'o te notou koloá ki te me'a'ofá; kā ne fusimo'omo 'ia te si'i fafine nei, kae sī 'osi 'e ia 'ia te me'a ne'e ma'u ke tauhi 'aki si'ana ma'ulí.” ");
INSERT INTO num_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Pea 'i te lau he 'ihi ki te Temipalé, 'i tono teunga 'aki te 'ū maka matamataleleí, mo te 'ū me'a'ofá, ne'e iange 'e Ia, ");
INSERT INTO num_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ko te 'ū me'a ko 'eni 'oku kotou mamata ki aí, 'ē, 'e hoko mai te taimi 'e kailoa tuku ai heni he fe'i maka; he 'e holoki kotoa pē ia ki lalo.” ");
INSERT INTO num_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Pea notou fehu'i kiā Ia, 'o pehē, “Tangata'aliki, 'e hoko fakafea 'ia te 'ū me'a ko iá? Pea ko te ā te faka'ilonga 'o kā ene 'ia te 'ū me'a ko iá ke hoko?” ");
INSERT INTO num_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Pea iange 'e Ia, “Vakavakai na'a takihee'i kōtou; kote'uhí 'e 'i ai he tokolahi 'e notou ha'u 'i te hingoa 'O'okú, mo notou pehē, ‘Ko au ia;’ mo notou pehē foki, ‘Kua ofi tono taimí.’ 'Ē, 'aua 'e kotou mulimuli kiā nātou. ");
INSERT INTO num_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Pea kā kotou fānonongo leva ki te 'ū tau, mo he 'ū maveuveu, 'aua na'a kotou 'ilifia; he kua pau ke hoko te 'ū me'a peheé ia; kae kailoa hoko leva 'ia te ngata'angá.” ");
INSERT INTO num_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Pea toki iange 'e Ia kiā nātou, “'E tau te fanua mo te fanua, mo te pule'anga ki te pule'anga. ");
INSERT INTO num_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Pea 'e 'i ai te 'ū fu'u mofuike mo te 'ū honge mo te 'ū mahaki faka'auha 'i te 'ū feitu'u kehekehe; ko te 'ū fu'u me'a faka'ilifia foki, mo te 'ū faka'ilonga 'e hā mei langi. ");
INSERT INTO num_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kā 'i te he'iki ai hoko te 'ū me'a ko iá, 'e notou puke 'ia kōtou, 'o fakatanga'i, mo notou faka'ilo ki te 'ū fakataha falelotú, mo tuku ki te 'ū pilīsoné, pea 'e 'avatu 'ia kōtou ki te 'ū tu'í mo te 'ū kōvaná kote'uhí ko te hingoa 'O'okú. ");
INSERT INTO num_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kā 'e hoko ia ko te fakamo'oni ma'a kōtou. ");
INSERT INTO num_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ko ia, tukupau 'i te kotou lotó ke 'aua na'a fu'aki fa'u he kotou fakamatala, ");
INSERT INTO num_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","he 'e Au toki 'avatu kiā kōtou 'e Au 'ia te lea mo te poto, 'a ia 'e kailoa lava ke fa'a tali, pē ta'ofia, 'e te kotou 'ū fili kotoa pē. ");
INSERT INTO num_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pea 'e faka'ilo 'ia kōtou 'e te kotou mātu'á, he tokoua, he kāinga, he kaume'a; pea 'e notou tāmate'i he kotou 'ihi. ");
INSERT INTO num_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pea 'e fihi'anakina'i 'ia kōtou 'e te kakai kotoa pē kote'uhí ko te hingoa 'O'okú. ");
INSERT INTO num_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kā 'e kailoa mole he kotou tu'ani lau'i'ulu 'e taha. ");
INSERT INTO num_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","'I te kotou kītakí 'e kotou ma'u mai te kotou laumālié. ");
INSERT INTO num_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Kā kotou vakai leva ki te kāpui 'o Selusalema 'e te 'ū matataú, 'e kotou toki 'ilo'i kua ofi tono faka'auhá. ");
INSERT INTO num_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pea ke toki hola ki te ma'ungá 'ia nātou 'oku 'i Siuteá; pea ko nātou 'oku 'i loto koló ke hiki mei ai; pea ko nātou 'oku 'i 'utá ke 'aua na'a notou hū ki te koló. ");
INSERT INTO num_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","He ko te taimi ia 'o te sāuní, ke fakakakato 'ia te 'ū me'a kua tohí. ");
INSERT INTO num_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Pohoē 'ia nātou 'oku faitamá, mo nātou 'oku tautama 'i te taimi ko iá! Kote'uhí 'e 'i ai he fu'u faingata'a 'i māmani, mo te houhau ki te kakai 'Isileli neí. ");
INSERT INTO num_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","He 'e tō 'ia nātou 'i te heletaá, pea 'e taki pōpula 'ia nātou ki te Senitaile kehekehe; pea 'e tāmalaki 'ia Selusalema 'e te Senitailé, kae'aua ke kakato 'ia te kuonga 'o te Senitailé. ");
INSERT INTO num_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Pea 'e 'i ai he 'ū faka'ilonga 'i te la'aá, mo te māhiná, mo te 'ū fetu'ú; pea 'i māmaní 'e mamahi 'ia te 'ū pule'angá, ko te notou puputu'u 'i te longoa'a 'o te taí mo te peaú; ");
INSERT INTO num_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","'e pōngingia he 'ihi 'o te kakaí ko te notou 'ilifia, mo te tu'atamaki ki te 'ū me'a 'oku hoko ifo ki māmaní; kote'uhí 'e ngatōtō 'ia te 'ū mālohinga 'o te langí. ");
INSERT INTO num_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Pea 'e notou toki sisio ki te Fanautama te Tangatá 'oku ha'u 'i te 'ū 'aó, mo te mālohi mo te nāunau lahi. ");
INSERT INTO num_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Pea 'i te kamata hoko 'ia te 'ū me'a ko iá, kotou hihiki te kotou 'ulú, 'o hanga ake, he 'oku ofi mai te kotou huhu'í.” ");
INSERT INTO num_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Pea lea 'aki 'e Ia he talanoa fakatātā kiā nātou: “Kotou vakai 'ia te fikí, mo te 'ū 'akau kehekehé. ");
INSERT INTO num_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kā 'asi ake tono muká, 'oku kotou 'ilo'i 'i te kotou sisio ki aí, kua ofi te fa'ahita'u māfaná. ");
INSERT INTO num_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Pehē foki 'ia kōtou, kā kotou vakai leva kua hoko 'ia te 'ū me'a ko iá, pea kotou 'ilo'i kua ofi te Pule'anga 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","'Okou tala mo'oni atu kiā kōtou, 'e kailoa 'aupito mole 'ia te to'utangata nei, kae'aua ke hoko 'eni fuli pē. ");
INSERT INTO num_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","'E mole 'ia te langí mo māmani, kā ko Ta'akú 'ū lea 'e kailoa 'aupito mole. ");
INSERT INTO num_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Kae kotou lamasi 'ia kōtou, na'a faifaí pea mafatukituki te kotou lotó, ko te me'a 'i te fa'a kai, mo te fa'a inu, mo te fa'a lotoma'ua ki te ma'uli nei, pea lapasi ai kōtou 'e te 'aho ko iá 'o hangē ko he hele puná. ");
INSERT INTO num_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","He 'e hoko mai 'eni ki te kakai kotoa pē 'oku notou nofo 'i te funga 'o māmaní kātoa. ");
INSERT INTO num_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kae kotou 'a'ala pē, mo lotu 'i te taimi kotoa pē, kote'uhi ke kotou lava ke hao mei te 'ū me'a ko iá fuli pē 'oku ene ke hokó, pea ke tu'u 'i te 'ao 'o te Fanautama te Tangatá.” ");
INSERT INTO num_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Pea kā 'aho leva, ne'e nofo Ia 'i te Temipalé, 'o fai Tana ako; kae kā pō'uli, ne'e 'alu Ia 'o nofo 'i te ma'unga ko 'Ōlivé. ");
INSERT INTO num_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Pea ne'e fa'a uhu atu kiā Ia 'ia te kakai kotoa pē 'i te Temipalé ke notou fānonongo kiā Ia. ");
INSERT INTO num_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pea ne'e fakaofiofi mai 'ia te Kātoanga Kai Mā Ta'e Lēvaní, 'ā ē 'oku hingoa ko te Pāsová. ");
INSERT INTO num_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pea ko te kau taula'aliki lahí, mo te kau sikalaipé, ne'e notou fiu'a feinga pē 'e fefe'aki he notou fakapoongi 'Ona; kā kote'uhí ne'e notou manahē ki te kakaí. ");
INSERT INTO num_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Pea hū 'ia Sētane kiā Siutasi ne'e ui ko 'Isikalioté, 'ā ē ne'e kau 'i te kau hongofulu mā uá. ");
INSERT INTO num_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Pea 'alu ia mei ai 'o notou alea mo te kau taula'aliki lahí, mo te kau 'alikitaú, ki te anga 'o tana lavaki'i 'Ona kiā nātoú. ");
INSERT INTO num_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Pea notou fiafia leva, mo notou fakapapau'i ke 'avange hana pa'anga. ");
INSERT INTO num_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Pea ne'e loto ia ke fai 'ia te me'a ko iá, pea ne ina kumi he faingamālie ke lavaki'i ai 'Ona kiā nātou 'i te taimi 'oku mama'o ai 'ia te kakaí. ");
INSERT INTO num_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pea ne'e hoko ki te 'aho 'o te Mā Ta'e Lēvaní, 'a ē ne'e totonu ke tāmate'i ai 'ia te Pāsová. ");
INSERT INTO num_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Pea fekau atu Ia 'ia Pita mo Sione, 'o iange, “Kulā ō 'o teuteu'i ma'a tātou 'ia te Pāsová, ke tou kai.” ");
INSERT INTO num_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Pea nā fehu'i ange kiā Ia, “Ko te feitu'u fea 'oku loto 'ia Koe ke mā teuteu'i aí?” ");
INSERT INTO num_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Pea iange Ia kiā nāua, “Ko 'eni, kā kulā hū leva ki te koló, 'e kulā fetaulaki mo he tangata 'oku fua he hina vai; kulā mulimuli ki ai 'o a'u ki te fale 'oku ina 'alu ki aí. ");
INSERT INTO num_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Pea 'e kulā lea leva ki te matāpule 'o te falé, ‘'Oku pehē mai 'e te Tangata'alikí, pe ko fea 'ia te loki ke Au kai ai 'ia te Pāsová mo Taku kau akó?’ ");
INSERT INTO num_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Pea 'e ina taki 'ia kōlua ki te fu'u falekai 'i lunga, kua 'osi teu'i; kulā teuteu'i leva te feitu'u ko iá.” ");
INSERT INTO num_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Pea 'i te nā ō atú, ne'e nā 'ilo'i pē 'o hangē ko Tana iange kiā nāuá, 'o nā teuteu 'ia te Pāsová. ");
INSERT INTO num_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pea 'i te hokosia tono houá, ne'e nofo ifo Ia mo te kau 'apōsetoló. ");
INSERT INTO num_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Pea pehē ange Ia kiā nātou, “'Oku faka'amu lahi Toku lotó ke kai 'ia te Pāsova nei fakataha mo kōtou, 'i te he'iki ai hoko mai Taku mamahí. ");
INSERT INTO num_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Hē 'Okou tala'i atu, 'e kailoa 'aupito ke Au toe kai ia, 'o a'u ki te taimi 'e fakakakato ai ia 'i te Pule'anga 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Pea to'o 'e Sīsū he ipu, 'o fai he fakafeta'i, mo iange, “To'o 'eni 'o vahevahe kiā kōtou. ");
INSERT INTO num_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Hē 'Okou tala'i atu, 'i te hili ange 'ení, 'e kailoa 'aupito ke Au toe inu mei te fua 'o te vainé, kae'aua ke hoko mai 'ia te Pule'anga 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ne Ina to'o foki he fe'i mā, 'o fakafeta'i, mo pakipaki 'o 'avange kiā nātou, mo iange, “Ko Toku sinó 'eni, 'a ia 'oku 'avatu kote'uhí ko kōtou; kotou fai 'eni ko te fakamanatu kiā Au.” ");
INSERT INTO num_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ne'e to'o foki Ia 'ia te ipú, hili te 'ohomohé, 'o pehē ange, “Ko te ipu ko 'ení ko te Fuakava Fo'oú ia 'oku fai 'aki Toku totó, 'a ia 'oku lilingi kote'uhí ko kōtou. ");
INSERT INTO num_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kā neongo iá, ko te toko taha 'e lavaki'i 'Okú 'oku 'i heni 'i te tēpilé mo Au. ");
INSERT INTO num_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","'Ē, ko te fononga 'a te Fanautama te Tangatá 'e fou pē 'i te me'a kua tu'utu'uní; kae pohoē 'ia te tangata 'ā ē 'e lavaki'i 'Oná!” ");
INSERT INTO num_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pea notou kamata fe'ekenaki, pē ko ai tū ia 'iā nātou 'oku teu fai peheé. ");
INSERT INTO num_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pea ne'e fai he fakakikihi 'iā nātou, pē ko ai 'iā nātou 'oku tu'ukimu'a tahá. ");
INSERT INTO num_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pea toki pehē ange 'e Ia kiā nātou, “Ko te 'ū tu'i 'o te Senitailé 'oku notou pule fa'italiha kiā nātou; pea ko nātou 'oku pule'i 'iā nātoú 'oku lau ia ko te kau mateaki fanua. ");
INSERT INTO num_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kā 'e kailoa kotou pehē kōtou; kā ko ia 'oku mā'olunga 'iā kōtoú ke hoko ia 'o tatau mo te mā'ulalo; pea ko te takimu'á ke hoko ia ko te sevāniti. ");
INSERT INTO num_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","He ko ai 'oku mā'olungá, 'ia ia 'oku nofo 'i te kaí, pe ko ia 'oku sevānití? 'Oku kailoa koā ko ia 'oku nofo 'i te kaí? Kā ko Au, 'Okou 'i te kotou lotolotongá 'o hangē ko te sevāniti. ");
INSERT INTO num_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ko kōtou ia kua nonofo ma'u mo Au 'i Toku 'ū 'ahi'ahí. ");
INSERT INTO num_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Pea ko Aú 'Okou tu'utu'uni he pule'anga ma'a kōtou, hangē pē ko te tu'utu'uni he pule'anga Mo'oku 'e Taku Tamaí, ");
INSERT INTO num_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ke kotou kakai mo iinu 'i Taku tēpilé 'i Toku pule'angá, pea nonofo ki te 'ū taloni, 'o fakamāu'i 'ia te matakali 'e hongofulu mā ua 'o 'Isilelí.” ");
INSERT INTO num_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“'E Saimone, Saimone, vakai, 'oku holi 'ia Sētane ke ma'u 'ia kōtou, ke sivi'i kōtou 'o hangē ko te uité; ");
INSERT INTO num_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","kā kua U hūfia 'ou, ke 'aua na'a mate 'aupito ta'aú tui. Pea kā ke foki mai, ke ke poupou'i 'e koe tou 'ū tokouá.” ");
INSERT INTO num_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ka ne'e iange 'e Pita ki Ai, “'Aliki, kua 'osi teu'i to'okú loto ke 'alu fakataha mo Koe, 'io, ki te pilīsoné mo te maté.” ");
INSERT INTO num_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Pea iange Ia, “Pita, ko 'eni 'Okou tala'i atu, 'e kala 'u'ua te moá 'ānai, kae'aua ke ke fakafisinga'i 'Oku 'o tu'a tolu.” ");
INSERT INTO num_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pea iange 'e Ia kiā nātou, “'I Taku fekau atu 'ia kōtou 'o kailoa he kato pa'anga, pē he kato 'oho, pē he 'ū senitoló, ne kotou masiva he me'a?” Pea notou iange, “Kailoa.” ");
INSERT INTO num_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Pea toki lea ange 'e Ia kiā nātou, “Kā 'i te taimi nei, ko ia 'oku ma'u he kato pa'angá, ke to'o ia, pehē foki mo he kato 'oho; pea ko ia 'oku kailoa ma'u hana heletaá, ke fakatau atu ia tono pulupulú ke ma'u 'aki he heletā. ");
INSERT INTO num_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Hē 'Okou iatu kiā kōtou, kua pau ke fakamo'oni'i 'iā Au 'ia te me'a ko 'eni ne'e tohi 'o pehē: ‘Pea ne'e fakakau Ia fakataha mo te kau maumau laó.’ He ko 'eni kua faka'a'au ke 'osi 'ia te 'ū me'a ne'e tohi kiā Aú.” ");
INSERT INTO num_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Pea notou iange, “'Aliki, vakai, ko te heletā 'eni 'e ua.” Pea iange 'e Ia kiā nātou, “'Oku fe'unga pē ia.” ");
INSERT INTO num_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Pea ne'e 'alu atu Ia ki te ma'unga ko 'Ōlivé, 'o hangē ko Tana fa'a faí; pea mulimuli foki kiā Ia 'ia te kau akó. ");
INSERT INTO num_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pea 'i Tana a'u ki te feitu'u ko iá, ne'e iange 'e Ia kiā nātou, “Kotou lotu ke 'aua na'a kotou hū ki te 'ahi'ahi.” ");
INSERT INTO num_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Pea ki'i mavahe atu Ia meiā nātou, 'o tū'ulutui 'o lotu, ");
INSERT INTO num_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","'o pehē, “'E Tamai, kāpau ko Tou finangaló, ke to'o ange 'ia te ipu nei meiā Au; kaikehe ke 'aua na'a fai To'okú loto, kā ko To'oú pē finangalo.” ");
INSERT INTO num_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Pea ne'e hā kiā Ia he 'āngelo mei te langí, 'o 'avange Hana mālohi. ");
INSERT INTO num_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Pea ma'ua Ia 'i te mamahi lahi, pea fakautuutu Tana lotu fakamātoató. Pea ne'e hoko Tana tauta'á 'o hangē ko te 'ū tulutā ta'ata'a, 'oku ngangana ki te kelekelé. ");
INSERT INTO num_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pea 'i Tana tu'u ake mei Tana lotú, 'o 'alu ki te kau akó, ne Ina 'ilo'i atu 'ia nātou kua notou momoe 'i te notou mamahí. ");
INSERT INTO num_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Pea iange 'e Ia kiā nātou, “Ko te ā 'oku kotou momoe aí? Kotou tutu'u ake, 'o lotu ke 'aua na'a kotou tō ki te 'ahi'ahí.” ");
INSERT INTO num_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Lolotonga Tana kei leá, tā ko he fu'u kakai; pea ko te tangata ne'e hingoa ko Siutasí, ko te toko taha 'o te kau hongofulu mā uá, ne'e 'alu mu'amu'a 'iā nātou, 'o ha'u kiā Sīsū ke 'uma kiā Ia. ");
INSERT INTO num_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pea iange 'e Sīsū ki ai, “'E Siutasi, ko te 'umá koā kua ke lavaki'i 'aki 'ia te Fanautama te Tangatá?” ");
INSERT INTO num_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pea ko nātou ne'e 'iā Sīsuú, 'i te notou vakai 'ia te me'a 'e hokó, ne'e notou iange, “'Aliki, 'e motou taa'i 'aki te heletaá?” ");
INSERT INTO num_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Pea ko te toko taha 'iā nātou, ne'e taa'i te tamaio'aliki 'a te Taula'aliki Lahí, 'o tu'usi tono talinga mata'ú. ");
INSERT INTO num_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pea tali 'e Sīsū, 'o pehē, “Tuku ā, kua lahi 'eni.” Pea ala 'e Ia ki te lau'i talingá, 'o fakama'uli ia. ");
INSERT INTO num_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pea iange 'e Sīsū ki te kau taula'aliki lahí, mo te kau pule 'o te Temipalé, mo te kau mātu'a ne'e notou ōmai kiā Iá, 'o pehē, “Kua kotou ōmai mo te heletā mo te 'akau, 'o hangē ko he kaiha'a 'ia Aú! ");
INSERT INTO num_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ko te 'aho kotoa pē mo Taku 'iā kōtou 'i te Temipalé, pea ne'e kailoa kotou puke 'Oku. Kā ko tono 'uhingá, he ko te kotou taimí 'eni, pea mo te mālohi 'o te fakapō'ulí.” ");
INSERT INTO num_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Pea notou puke'i 'Ona, 'o taki atu ki te fale 'o te Taula'aliki Lahí. Kae mulimuli atu 'ia Pita mei te mama'ó. ");
INSERT INTO num_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pea kua tafu he afi 'i te loto'aá, mo notou nonofo fakataha, pea nofo 'ia Pita 'o lotolōtoi 'iā nātou. ");
INSERT INTO num_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ka ne'e mamata kiā ia he kaunanga 'e taha 'i tana nofo ofi ki te afí, 'o sio fakamama'u kiā ia, mo iange, “Ko te siana nei foki ne'e 'iā Ia.” ");
INSERT INTO num_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ka ne'e fakafisi ia, mo iange, “Fafine, 'oku kala u 'ilo'i Ia 'e au.” ");
INSERT INTO num_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pea fualoa si'i atú ne'e mamata kiā ia he toko taha kehe, ko te tangata, 'o iange 'e ia, “Ko koe foki 'oku kau ki te fa'ahinga ko iá.” Pea iange 'e Pita, “Tangata, 'oku kailoa.” ");
INSERT INTO num_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pea kua 'osi nai he houa 'e taha, pea fakapapau mai he tangata 'e taha, 'o pehē, “'Ē, ko te mo'oni, ne'e kau mo Ia 'ia te siana nei foki; he ko te Kāleli ia.” ");
INSERT INTO num_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pea pehē ange 'e Pita, “Tangata, 'oku kailoa u 'ilo'i 'ia te me'a 'oku lau 'e koe ki aí.” Pea fokifā pē, lolotonga tana kei leá, mo te 'u'ua 'ia te moá. ");
INSERT INTO num_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Pea tafoki leva te 'Alikí 'o sio fakamama'u kiā Pita. Pea manatu'i 'e Pita te folafola 'a te 'Alikí, 'i Tana pehē mai, “'I te he'iki ai 'u'ua te moá 'ānaí, 'e ke fakafisinga'i 'Oku 'o tu'a tolu.” ");
INSERT INTO num_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pea 'alu atu ia ki tua'ā, 'o tangi mamahi. ");
INSERT INTO num_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Pea ko te kau tangata ne'e notou puke 'ia Sīsuú ne'e notou pā'usi'i 'Ona, mo taa'i. ");
INSERT INTO num_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pea notou fakapūlou'i 'Ona, 'o notou 'eke ange, “Mate'i mai pe ko ai ne'e taa'i 'Oú!” ");
INSERT INTO num_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Pea lahi mo te 'ū lea kovi kehekehe ne'e notou lea 'aki kiā Ia. ");
INSERT INTO num_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pea 'i tana 'aho aké, ne'e fakataha mai 'ia nātou ne'e kau ki te Fakataha Fakamātu'a 'o te kakaí, mo te kau taula'aliki lahí, mo te kau sikalaipé; 'o notou taki ange 'Ona ki te Sanetalimí 'o notou pehē ange, ");
INSERT INTO num_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Ko Koe 'ia te Kalaisí? Pe'i tala'i mai.” Pea iange 'e Ia kiā nātou, “Kāpau 'e Au tala'i atu kiā kōtou, 'e kailoa pē tui kōtou ia. ");
INSERT INTO num_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Pea kāpau 'e Au fai atu he fehu'i, 'e kailoa he kotou tali. ");
INSERT INTO num_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kā 'i te hili ange 'ení, 'e nofo 'ia te Fanautama te Tangatá ki te to'omata'u 'o te 'Atua Māfimafí.” ");
INSERT INTO num_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Pea notou iange kotoa pē, “'Io! Pea ko te 'Alo 'o te 'Atuá 'ia Koe?” Pea iange 'e Ia kiā nātou, “'Oku kotou lea pehē; ko Au ia.” ");
INSERT INTO num_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Pea notou pehē, “Kote'uma'aki te tou toe kumi fakamo'oní? He kua tou fanongo tonu 'e tātou ki Ta'aná lea!” ");
INSERT INTO num_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pea tutu'u ake kātoa 'ia te fakatahá, 'o notou taki 'Ona kiā Pailato. ");
INSERT INTO num_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pea notou talatalaaki'i 'Ona, 'o pehē, “Ne motou 'ilo'i 'ia te Siana nei 'oku veuveuki 'e Ia te motou kakaí, mo ta'ofi te fai tukuhau kiā Sisá, mo Tana pehē ko Ia pē ko te Kalaisí ko te Tu'i.” ");
INSERT INTO num_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pea fehu'i 'e Pailato kiā Ia, 'o pehē, “Ko Koe koā 'ia te Tu'i 'o te kakai Siú?” Pea tali ange 'e Ia ki ai 'o pehē, “Ko ia pē.” ");
INSERT INTO num_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pea lea ange 'e Pailato ki te kau taula'aliki lahí mo te fu'u kakaí, “'Oku kailoa u 'ilo'i he fehālaaki 'a te Tangata nei.” ");
INSERT INTO num_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ka ne'e 'āsili ai te notou lilí, 'o notou pehē, “'Oku veuveuki 'e Ia 'ia te kakaí, 'aki Tana faiakó 'i Siutea kātoa, 'o kamata mai mei Kāleli ki heni.” ");
INSERT INTO num_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pea 'i te fanongo ki ai 'ia Pailató, ne ina fehu'i ange pe ko te tangata Kāleli Ia. ");
INSERT INTO num_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pea 'i tana mea'i 'oku ha'u 'ia Sīsū mei te feitu'u 'oku pule ai 'ia Hēlotá, ne'e fekau 'e ia ke 'ave 'Ona kiā Hēlota, he ne'e 'i Selusalema mo ia 'i te taimi ko iá. ");
INSERT INTO num_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Pea 'i te mamata 'e Hēlota kiā Sīsuú, ne'e fiafia lahi ia, he kua fualoa tana faka'amu ke mamata kiā Ia, kote'uhí ko tono fa'a ongoongoa maí, pea kua ina faka'amu ke sio he me'a mana 'e fai 'e Ia. ");
INSERT INTO num_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Pea lahi te 'ū fehu'i ne'e fai ange 'e Hēlota kiā Iá; ka ne'e kailoa mama'i tali 'e Ia he me'a. ");
INSERT INTO num_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pea tutu'u ai 'ia te kau taula'aliki lahí, mo te kau sikalaipé, 'o notou tōtōivi tono talatalaaki'í. ");
INSERT INTO num_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Pea ne'e manuki'i mo ngaahikovi'i 'Ona 'e Hēlota mo tana kau taú, pea notou 'ai kiā Ia he kofu ngingila; mo fekau ke toe 'ave 'Ona kiā Pailato. ");
INSERT INTO num_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pea ne'e kamata fe'ofa'ofani 'ia Pailato mo Hēlota 'i te 'aho ko iá; he ne'e nā vākovi ki mu'a. ");
INSERT INTO num_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pea fakataha 'e Pailato 'ia te kau taula'aliki lahí, mo te kau pulé, mo te kakaí, ");
INSERT INTO num_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","pea iange 'e ia kiā nātou, “Ne kotou 'aumai kiā au 'ia te Tangata nei, ko te Toko Taha takua, 'oku veuveuki te kakaí. Pea ko 'eni, ne au 'eke'i te Tangatá 'i te kotou 'aó 'e au, pea ne'e kailoa u 'ilo'i Hana mama'i hala 'e taha 'i te 'ū me'a ne kotou talatalaaki'i 'aki 'Oná. ");
INSERT INTO num_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Pea kua pehē pē mo Hēlota; he kua fekau 'e ia ke toe 'aumai 'Ona kiā tātou. Pea tā 'oku kailoa he me'a ia kua fai 'e Ia 'oku totonu ke mate ai. ");
INSERT INTO num_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ko ia, 'e au 'ai pē Hana tautea tā pea toki vete ange.” ");
INSERT INTO num_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","He kua totonu ke vete ange ia he pōpula 'e taha 'i te kātoangá. ");
INSERT INTO num_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pea notou kalanga fakataha kotoa pē, 'o pehē, “Tafi'i te Siana nā, kae vete mai 'ia Palāpasa!” ");
INSERT INTO num_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","('a ia ko te toko taha ne'e sī ki te pilīsoné, kote'uhí ko tana angatu'u 'i te koló, mo te hia fakapō). ");
INSERT INTO num_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pea toe lea 'e Pailato kiā nātou, ko tana loto ke vete ange 'ia Sīsuú. ");
INSERT INTO num_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ka ne'e kaikaila mai pē te kakaí ia, 'o pehē, “Kalusefai, kalusefai Ia!” ");
INSERT INTO num_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pea me'a 'e ia kiā nātou ko tono tu'a tolú, “He ko te ā he kovi kua fai 'e te Tangata nei? Kua kala u mama'i 'ilo'i Hana hiamatea. Ko ia 'e au 'ai Hana kinisi, pea toki tukuange.” ");
INSERT INTO num_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ka ne'e mālohi ange te notou kaikailá, 'o notou longoa'a lahi, 'i te notou kole ke kalusefai 'Oná. Pea ne'e lava'i 'eni 'e te notou longoa'á. ");
INSERT INTO num_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pea toki fekau 'e Pailato ke fai ki te notou lotó. ");
INSERT INTO num_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pea vete ange 'e ia 'ia te siana ne'e notou kole ki aí, 'ā ē ne'e sī ki te pilīsoné kote'uhí ko tana angatu'u mo te fakapō; kā ko Sīsuú ne'e tukuange atu 'e ia ke fai te notou lotó kiā Ia. ");
INSERT INTO num_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pea 'i te notou taki atu Iá, ne'e notou puke mai 'ia Saimone, ko te matu'a Sailine, 'i tana ha'u mei 'utá, 'o notou hili kiā ia te kolosí, ke fua atu 'o mulimuli kiā Sīsū. ");
INSERT INTO num_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Pea mulimuli atu kiā Ia he fu'u kakai tokolahi, mo te kau fafine, 'a ia ne'e notou sī fatafata mo pohoē kote'uhí ko Ia. ");
INSERT INTO num_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ka ne'e tafoki 'ia Sīsū 'o pehē ange kiā nātou, “Si'i kau fafine Selusalema, 'aua 'e kotou tangi kote'uhí ko Au, kae kotou tangi kote'uhí ko kōtou, pea mo te kotou fānaú. ");
INSERT INTO num_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","He vakai, kua 'unu mai pē te taimi 'e notou pehē ai, ‘'Oku manū'ia 'ia te pa'á, mo te manava ne'e kailoa fanaú, mo te huhu ne'e kailoa fai ai he huhú.’ ");
INSERT INTO num_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Pea 'e notou toki kamata ke lea ki te 'ū ma'ungá, ‘Hoholo mai kiā mātou,’ pea ki te 'ū mā'olungá, ‘'Ufi'ufi 'ia mātou.’ ");
INSERT INTO num_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","He kāpau 'oku notou fai pehē ki te 'akau matá, ko te ā 'e fai ki te moamoá?” ");
INSERT INTO num_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Pea ne'e taki ange fakataha mo Ia he ongo faihia 'e toko ua ke tāmate'i. ");
INSERT INTO num_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pea 'i te notou a'u ki te feitu'u 'oku ui ko 'Ulupoko, ne'e notou kalusefai ai Ia mo te ongo faihiá, ko te taha mei to'omata'u, mo te taha mei to'ohema. ");
INSERT INTO num_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Pea toki pehē 'e Sīsū, “'E Tamai, fakamolemole'i 'ia nātou; he 'oku kala notou 'ilo'i 'ia te me'a 'oku notou faí.” Pea notou vahevahe Tono 'ū kofú, mo talotalo ki ai. ");
INSERT INTO num_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Pea ne'e tu'u te kakaí 'o mamata. Pea manuki foki mo te kau pulé, 'o notou pehē, “Ne Ina fakama'uli 'ia te kakai kehé; 'ē, tuku ke fakahaofi 'e Ia 'Ona, 'o kāpau ko te Kalaisí Ia, ko te Toko Taha kua Ina filí.” ");
INSERT INTO num_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pea ne'e luma'i 'Ona 'e te kau taú, mo notou 'unu'unu atu 'o 'avange he vinika kiā Ia, ");
INSERT INTO num_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","mo pehē ange, “Kāpau ko te tu'i Koe 'o te kakai Siú, pe'i fakahaofi 'Ou.” ");
INSERT INTO num_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pea ne'e 'i ai mo he tohi ne 'ai 'i te 'ulu'i kolosí, 'o pehē, “KO TE TU'I 'ENI 'O TE KAKAI SIU.” ");
INSERT INTO num_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Pea ko te toko taha 'i te ongo faihia ne'e tautaú ne'e manuki kiā Ia, mo iange, “Kāpau ko te Kalaisí 'ia Koe, pe'i fakahaofi 'Ou mo māua.” ");
INSERT INTO num_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ka ne'e valoki'i 'ona 'e te faihia 'e tahá, mo pehē ange, “'Oku kala koā 'apasia 'ia koe ki te 'Atuá, hē 'oku kulā kaungā tautea mo Ia? ");
INSERT INTO num_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Pea 'oku tonu pē ia kiā tāua; hē ko te totongi totonu ia 'o te tā faihiá; kā ko te Toko Taha nei, kua kailoa Ha'aná mama'i kovi 'e taha ne fai.” ");
INSERT INTO num_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Pea toki iange 'e ia kiā Sīsū, “'E 'Aliki, manatu'i 'oku, 'o kā Ke hoko ki Tou pule'angá.” ");
INSERT INTO num_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Pea folafola ange 'e Sīsū ki ai, “'Okou tala mo'oni atu kiā koe, ko te 'aho nei 'e ke 'i Palataisi mo Au.” ");
INSERT INTO num_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Pea 'i te fe'unga nai mo te ho'atā mālié, ne'e fakapō'uli te fanuá fuli pē, 'o a'u ki te tolu afiafí. ");
INSERT INTO num_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Pea fakapō'uli 'ia te la'aá, pea mahaeua mālie 'ia te puipui 'o te Fale Tapú. ");
INSERT INTO num_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Pea kalanga le'o lahi 'ia Sīsū, 'o pehē, “'E Tamai, 'Okou tuku atu Toku laumālié ki To'oú nima!” Pea 'i te 'osi Tana lea peheé, pea pekia leva Ia. ");
INSERT INTO num_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pea 'i te vakai atu 'e te senitulioó ki te me'a ne'e hokó, ne'e fakaongoongolelei'i 'e ia 'ia te 'Atuá, 'aki tana pehē, “Tā ko te mo'oni pē, ko te Tangata mā'oni'oni 'eni!” ");
INSERT INTO num_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Pea ko te kakai kotoa pē ne'e notou fakataha ange ke mamata ki te me'a ko iá, 'i te notou vakai ki te 'ū me'a ne hokó, ne'e notou sī fatafata, 'o foki ki 'api. ");
INSERT INTO num_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ka ne'e tutu'u mei te mama'ó Tono kau fe'iloakí kotoa pē, mo te kau fafine ne'e mulimuli kiā Ia mei Kālelí, 'o notou mamata ki te 'ū me'a nei. ");
INSERT INTO num_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Pea tā ne'e 'i ai he matāpule ne'e hingoa ko Siosifa 'a ia ne'e kau 'i te Fakataha Fakamātu'á, ko te tangata lelei ia mo faitotonu, ");
INSERT INTO num_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","(ne'e kailoa loto ia ki te notou tu'utu'uní mo te notou ngāué,) ko te matāpule ia mei 'Alematea, ko te kolo Siu; pea ne'e nofo 'amanaki foki ia ki te Pule'anga 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ko te tangata nei ne'e 'alu kiā Pailato, 'o kole ange te sino 'o Sīsuú. ");
INSERT INTO num_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pea tuku ifo 'e ia 'ia te 'anga'angá, 'o teu 'aki he tupenu mahu'inga; 'o telio 'ia Sīsū 'i te fanualoto kua tā 'i te loto maká, 'a ia 'oku he'iki ai 'aupito toka ai he taha. ");
INSERT INTO num_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pea ko te 'aho Tokonaki ia, pea kua ofi mai te Sāpaté. ");
INSERT INTO num_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Pea ko te kau fafiné foki, 'ā ē ne'e fononga mai mo Ia mei Kālelí, ne'e notou mulimuli mai, pea notou vakai atu ki te fanualotó, mo te anga 'o te fakatoka Tono 'anga'angá. ");
INSERT INTO num_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pea notou foki, 'o teu te 'ū ahi mo te 'ū lolo tākai. Pea ne'e notou mālōlō 'i te 'aho Sāpaté 'o hangē ko te tu'utu'uní. ");
INSERT INTO num_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kā 'i te 'uluaki 'aho 'o te uiké, 'oku kei hengihengi 'aupitó, ne'e notou ō atu ki te fanualotó, 'o 'ave te ahi kua notou teú. ");
INSERT INTO num_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pea notou 'ilo'i ai 'ia te maká kua teka'i mei te fanualotó. ");
INSERT INTO num_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kā 'i te notou uulu ki aí, ne'e kailoa notou 'ilo'i te sino 'o te 'Aliki ko Sīsuú. ");
INSERT INTO num_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Pea 'i te lolotonga te notou puputu'u 'i te me'a ko iá, tā ne'e tu'u mai kiā nātou he ongo tangata ne'e huhulu te nā kofú. ");
INSERT INTO num_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Pea 'i te notou manahē fu'ú, mo fo'oifo ki te kelekelé, ne nā pehē ange kiā nātou, “Ko te ā 'oku kotou kumi ai 'ia Ia 'oku ma'ulí ki te kau pekiá? ");
INSERT INTO num_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","'Oku kala 'i heni Ia, kā kua toetu'u. Manatu'i Tana me'a kiā kōtou 'i Tana kei 'i Kālelí, 'o pehē, ");
INSERT INTO num_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Kua pau ki te Fanautama te Tangatá ke tukuange 'Ona ki te kakai angahalá, pea ke kalusefai, pea ke toetu'u 'i tono 'aho tolú.’ ” ");
INSERT INTO num_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Pea notou manatu ai ki Tana 'ū leá, ");
INSERT INTO num_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","pea notou foki mai mei te fanualotó, 'o notou tala 'ia te 'ū me'a ko iá ki te kau hongofulu mā tahá, pea mo tono toe 'o te kakaí. ");
INSERT INTO num_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Pea ko Mele mei Makitalá, mo Sioana, mo Mele ko te fa'ē 'a Sēmisí, pea mo te 'ihi ne'e 'iā nātoú, ne'e notou tala 'ia te 'ū me'a ko iá ki te kau 'apōsetoló. ");
INSERT INTO num_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ka ne'e hangē te notou fakamatalá ko he muná; pea ne'e kailoa notou tui ki te kau fafiné. ");
INSERT INTO num_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ka ne'e tu'u 'ia Pita, 'o lele atu ki te fanualotó, pea tulolo ia 'o sio ko te 'ū tupenú pē; pea 'alu atu ia, mo tana fakatumutumu 'i te me'a kua hokó. ");
INSERT INTO num_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Pea ko te toko ua 'o nātou ne'e nā fononga 'i te 'aho ko iá ki te ki'i kolo ne'e hingoa ko 'Emeasi, ko tono mama'o mei Selusalemá ko te maile nai 'e fitu. ");
INSERT INTO num_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Pea nā talatalanoa ki te 'ū me'a kehekehe kua toki hokó. ");
INSERT INTO num_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Pea 'i te lolotonga te nā talanoa mo fe'eké, ne'e fakaofiofi mai 'ia Sīsū, 'o ō fakataha mo nāua. ");
INSERT INTO num_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ka ne'e ta'ofi to'o nāuá mata ke 'aua na'a nā 'ilo'i Ia. ");
INSERT INTO num_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Pea iange 'e Ia kiā nāua, “Ko te ā te 'ū me'a 'oku kulā fekīhiaki ai 'i te kulā fonongá?” Pea nā tutu'u 'oku nā mata mamahi. ");
INSERT INTO num_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Pea tali ange 'e te toko taha ne'e hingoa ko Kaliopasi, 'o pehē, “Tā ko te sola 'apē 'ia koe ki Selusalema, 'i tau ta'e'ilo ki te 'ū fu'u me'a kua hoko 'i te 'ū 'aho nei?” ");
INSERT INTO num_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Pea iange 'e Ia kiā nāua, “'Ia te ā koā?” Pea nā iange, “'Ia te 'ū me'a 'oku kau kiā Sīsū mei Nāsaletí, 'a ia ko te tangata palōfita ne'e hā ki te 'Atuá mo te kakai kotoa pē Tono mafaí 'i te ngāue mo te lea; ");
INSERT INTO num_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","'i Tono tukuange foki 'e te kau taula'aliki lahí, mo te kau pule 'o mātoú, ke fakamāumatea, mo notou kalusefai Iá. ");
INSERT INTO num_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ka ne'e motou 'amanaki 'e mātou, ko Ia ia 'oku teuteu ke huhu'i 'ia 'Isilelí. Kae'uma'ā 'eni foki, ko tono 'aho tolú 'eni talu te fai 'o te me'a ko iá. ");
INSERT INTO num_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","'Io, pea ne'e fakalele ma'uli kiā mātou 'e te 'ihi 'o te motou kau fafiné, 'a ia ne'e notou uhu ki te fanualotó; ");
INSERT INTO num_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","pea 'i te kailoa notou 'ilo'i Tono sinó, ne'e notou ōmai 'o tala kua notou sio takua he vīsone, ko he ongo 'āngelo ne'e nā fakahaa'i kua ma'uli 'ia Ia. ");
INSERT INTO num_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Pea 'alu ki te fanualotó he 'ihi 'iā nātou 'oku motou kaú, 'o notou 'ilo'i 'o hangē tofu pē ko te lau 'a te kau fafiné; kā ne kailoa notou sio kiā Ia.” ");
INSERT INTO num_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Pea toki me'a 'e Ia kiā nāua, “'Ia te kau vale, pea tō'ohi ke tui ki te 'ū me'a ne lea 'aki 'e te kau palōfitá! ");
INSERT INTO num_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ne kailoa koā pau ke mamahi pehē 'ia Kalaisi, kae toki hoko ki Tana lāngilangi'iná?” ");
INSERT INTO num_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Pea kamata Ia meiā Mōsese, mo te kau palōfitá kotoa pē, 'o faka'uhinga mei te Tohitapú 'ia te 'ū me'a fuli pē 'oku kau kiā Iá. ");
INSERT INTO num_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pea 'i te notou a'u ki te ki'i kolo ne nā fononga ki aí, pea fai atu 'e Ia 'o hangē kā 'alú. ");
INSERT INTO num_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pea ta'ofi 'Ona 'e nāua, 'o nā iange, “Afe mai mu'a mo māua; he kua afiafi 'eni, pea kua pale 'aupito te la'aá.” Pea hū Ia ki te ki'i koló ke nofo mo nāua. ");
INSERT INTO num_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Pea ne'e hoko 'o pehē, 'i Tana nofo mo nāua ki te kaí, ne Ina to'o 'ia te maá, 'o fai he tāpuaki, 'o pakipaki mo 'avatu kiā nāua. ");
INSERT INTO num_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Pea 'a'ala ai te nā matá, 'o nā 'ilo'i tā ko Ia; ka ne'e puli leva Ia meiā nāua. ");
INSERT INTO num_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Pea nā fepehē'aki, “Tā ne'ine'i ke vela to'o tāuá loto lolotonga Tana talanoa mai 'i te alá, mo Tana vete kiā tāua 'ia te Tohitapú!” ");
INSERT INTO num_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Pea nā tutu'u ake 'i te houa pē ko iá, 'o nā foki ki Selusalema; pea 'i te nā a'u atú, tā kua fakatahataha 'ia te kau hongofulu mā tahá ia mo nātou ne'e notou kaú. ");
INSERT INTO num_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Pea notou pehē mai, “Kua toetu'u mo'oni te 'Alikí, pea kua hā Ia kiā Saimone!” ");
INSERT INTO num_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Pea fakamatala mo nāua foki 'ia te me'a ne'e hoko 'i te alá, pea mo tono 'ilo'i 'e nāua 'i te pakipaki 'o te maá. ");
INSERT INTO num_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pea 'i te lolotonga te notou talanoa peheé mo tana tu'u 'ia Sīsū 'i te notou ha'oha'ongá, 'o pehē kiā nātou, “Ke 'iā kōtou 'ia te melinó!” ");
INSERT INTO num_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pea ne'e notou manahē 'aupito mo tetetete, ko te notou mahalo ko he fa'ahikehe 'oku notou sisio ki aí. ");
INSERT INTO num_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pea iange 'e Ia kiā nātou, “Ko te ā 'oku kotou manahē aí? Pea ko te ā 'oku ake ai te 'ū fifili pehē 'i te kotou lotó? ");
INSERT INTO num_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Vakai mai ki Toku ongo nimá mo Toku va'é, ko Au mo'oni Ia. Fāfā 'ia Au 'o 'ilo'i; he 'oku kailoa kakano mo hui he fa'ahikehe, 'o hangē ko ia 'oku kotou sisio ai 'iā Aú.” ");
INSERT INTO num_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Pea 'i Tana lea peheé, ne'e faka'ali'ali ange 'e Ia Tono ongo nimá mo Tono ongo va'é. ");
INSERT INTO num_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pea 'i te notou kei tuingata'a, kote'uhí ko te notou fiafifia mo ofoofó, ne'e toe iange 'e Ia kiā nātou, “'Oku 'i ai he kotou me'akai heni?” ");
INSERT INTO num_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Pea notou 'avange kiā Ia he konga ika tunu. ");
INSERT INTO num_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Pea to'o 'e Ia, 'o kai 'i te notou 'aó. ");
INSERT INTO num_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pea iange 'e Ia kiā nātou, “Ko Taku 'ū lea ē ne Au fai kiā kōtou 'i Taku kei nofo mo kōtoú, 'o pehē: kua pau ke fakamo'oni'i 'ia te 'ū me'a kotoa pē kua tohi kiā Au 'i te Lao 'a Mōsesé, mo te kau palōfitá, mo te Saamé.” ");
INSERT INTO num_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Pea toki tatala 'e Ia te notou lotó ke notou 'ilo'i tono 'uhinga 'o te Tohitapú; ");
INSERT INTO num_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","'o folafola kiā nātou, “Ne'e pehē pē tono tohí, pea 'oku taau mo Kalaisi ke mamahi pehē, pea 'e toetu'u Ia mei te pekiá 'i tono 'aho tolú, ");
INSERT INTO num_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","pea 'e malanga 'aki 'i Tono hingoá 'ia te fakatomalá mo te fakamolemole angahalá ki te kakai kotoa pē, 'o kamata mei Selusalema. ");
INSERT INTO num_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ko kōtoú ko te kau fakamo'oni ki te 'ū me'a nei. ");
INSERT INTO num_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Pea ko Au 'eni 'Okou tuku atu 'ia te tala'ofa Taku Tamaí kiā kōtou; pea ko kōtoú 'e kotou nonofo 'i Selusalema, kae'aua ke fakakofu 'aki kōtou he mālohi mei lunga.” ");
INSERT INTO num_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pea taki atu 'e Ia 'ia nātou 'o a'u ki Pētani; pea hiki ake 'e Ia Tono ongo nimá 'o tāpuaki'i 'ia nātou. ");
INSERT INTO num_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Pea vakai, 'i te lolotonga Tana tāpuaki'i nātoú, ne'e mavahe Ia meiā nātou, 'o tukutuku ake ki te langí. ");
INSERT INTO num_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pea ne'e notou lotu kiā Ia, 'o notou toki foki ki Selusalema 'oku notou fiafifia 'aupito. ");
INSERT INTO num_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Pea ne'e notou ō ma'u pē ki te Temipalé 'o fakamālō ki te 'Atuá.");
INSERT INTO num_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","'I te kamata'angá ne'e 'i ai 'ia Folafola, pea ne'e feangai mo te 'Atuá 'ia Folafola, pea ne'e 'Atua 'ia Folafola. ");
INSERT INTO num_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ko te Toko Taha ko iá ne'e 'i te kamata'angá mo te 'Atuá. ");
INSERT INTO num_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ko te hoko mai 'o te me'a kotoa pē ne'e fou 'iā Ia; pea ne'e kailoa he mama'i me'a 'e taha 'e hoko mai, 'o 'ata'atā meiā Ia. ");
INSERT INTO num_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ne'e 'iā Ia 'ia te ma'ulí; pea ko te ma'uli ko iá 'ia te maama 'a te tangatá. ");
INSERT INTO num_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Pea 'oku ulo te maamá 'i te pō'ulí; pea ne'e kailoa lava'i 'ona 'e te pō'ulí. ");
INSERT INTO num_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ne'e 'i ai he tangata ne'e fekau mei te 'Atuá, ko tono hingoá ko Sione. ");
INSERT INTO num_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ne'e ha'u iá ko te fakamo'oni, ke fakamo'oni ki te Maamá, kote'uhí ke tui 'ia te kakai kotoa pē 'iā ia. ");
INSERT INTO num_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ne'e kailoa ko te Maamá ia, ka ne'e 'i aí ke fakamo'oni ki te Maama ko iá. ");
INSERT INTO num_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ko te Maama mo'oní 'eni, 'a ē 'oku Ina huluhulu 'ia te tangata kotoa pē, 'oku ha'u Ia ki māmani. ");
INSERT INTO num_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ne Ina 'i māmani, pea ko te ngaahi 'o māmaní 'e Ia, ka ne'e kailoa 'ilo'i 'Ona ia 'e māmani. ");
INSERT INTO num_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ne Ina ha'u ki Tono 'api tonú, ka ne'e kailoa fia tali 'Ona ia 'e To'onó kakai. ");
INSERT INTO num_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kā ko nātou kotoa pē ne'e notou tali Iá, ne Ina fakamafai'i 'ia nātou ke hoko ko te fānau 'a te 'Atuá, 'io, 'ia nātou pē 'oku tui pīkitai ki Tono huafá; ");
INSERT INTO num_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","'ia nātou ne'e kailoa fakatupu 'e te toto, pe 'e te loto 'o te kakano, pe 'e te loto 'o he tangata, kā 'e te 'Atuá. ");
INSERT INTO num_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Pea ne'e hoko 'ia Folafola ko te kakano, 'o 'afio 'i te tou lotolotongá, (pea ne'e tou mamata ki Tono kolōliá, ko te kolōlia 'o he 'Alo pē taha kua ha'u mei te Tamaí,) pea 'oku Ina fonu 'i te kelesi mo te mo'oni. ");
INSERT INTO num_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ne'e fakamo'oni ki Ai 'e Sione, 'o ina kalanga 'o pehē, “Ko 'eni Ia ne au lea ki aí, ‘Ko Ia 'oku mulimuli mai 'iā aú, 'oku lahi Ia 'iā au, he ne'e 'i mu'a noa pē Ia 'iā au.’ ” ");
INSERT INTO num_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","He ne'e tou ma'u kotoa pē mei Tana fonu ko iá, 'io, 'o taufetongi te kelesi mo he kelesi. ");
INSERT INTO num_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","He ne'e tuku mai 'ia te Laó 'iā Mōsese, ko te me'a tuku mai, ka ne'e fou 'ia te kelesí mo te mo'oní 'iā Sīsū Kalaisi, 'o mātu'aki hiki mai. ");
INSERT INTO num_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","'Oku kailoa he taha kua ina mamata ki te 'Atuá he kuonga; ko te 'Atua tofu pē tahá, 'a ē 'oku 'i te fatafata 'o te Tamaí, kua Ina fakahaa'i mai 'Ona. ");
INSERT INTO num_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Pea ko tono fakahaa'i 'eni 'e Sioné, 'i tono fekau'i mai 'e te kakai Siú mei Selusalema he kau taula'aliki mo he kau Līvaite, ke fehu'i kiā ia, 'o pehē, “Ko ai 'ia koe?” ");
INSERT INTO num_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Pea ne'e lea totonu pē ia, 'o kailoa ina fakafisinga'i; 'io, ne'e lea totonu pē ia, “'Oku kala ko te Kalaisí 'ia au.” ");
INSERT INTO num_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Pea notou fehu'i ange kiā ia, “Kā ko ai 'ia koe? Ko 'Ilaisiā?” Pea iange 'e ia, “Kailoa.” “Ko koe koā 'ia te palōfitá?” Pea iange 'e ia, “Kailoa.” ");
INSERT INTO num_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Pea notou iange kiā ia, “Pea ko ai leva 'ia koe? Kote'uhí ke 'i ai he motou tali kiā nātou ne'e fai te motou fekau'í. Ko te ā tau lau kiā koé?” ");
INSERT INTO num_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Pea iange leva 'e ia, “Ko au 'ia te le'o 'o he toko taha 'oku kalanga 'i te toafá: ‘Fakatonutonu te hā'ele'anga 'o te 'Alikí,’ hangē ko te lea 'a te palōfita ko 'Aiseá.” ");
INSERT INTO num_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pea kua fekau mai he 'ihi mei te kau Fālesí. ");
INSERT INTO num_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Pea fehu'i ange 'e nātou kiā ia, “Pea ko te ā tono 'uhinga 'oku fai papitaiso ai 'e koé, kāpau 'oku kailoa ko te Kalaisí 'ia koe, pe ko 'Ilaisiā, 'uma'ā 'ia te Palōfitá?” ");
INSERT INTO num_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Pea iange 'e Sione kiā nātou, 'o pehē, “Ko aú 'okou papitaiso vai, kā 'oku tu'u 'i te kotou lotolotongá he Toko Taha 'oku kala kotou 'ilo'i; ");
INSERT INTO num_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ko Ia ia 'oku mulimuli maí, kā 'oku lahi Ia 'iā au, pea ko te nono'o Tono senitoló 'oku kailoa taau 'ia kita ke vete ange.” ");
INSERT INTO num_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ne'e hoko 'ia te 'ū me'a nei 'i Pētani 'i Tu'a-Sioatani, ko te feitu'u ia ne'e fai ai 'e Sione tana papitaisó. ");
INSERT INTO num_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pea 'i te 'aho tono hokó, ne'e sio 'e Sione kiā Sīsū 'oku ha'u kiā ia, pea toki pehē 'e ia, “Kotou vakai, ko 'ena 'ia te Lami 'a te 'Atuá, 'a ē 'oku Ina 'ave 'ia te angahala 'a māmaní! ");
INSERT INTO num_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ko 'eni Ia ne au lea ki ai 'o pehē: 'oku mulimuli mai he Tangata, 'a ē 'oku lahi 'iā au, kote'uhí he ne'e 'i mu'a noa pē Ia 'iā au. ");
INSERT INTO num_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Pea ne'e kailoa ke au 'ilo'i Ia 'e au, kā ko tono fakahaa'i ki 'Isilelí, ko tono 'uhinga ia 'o taku ha'u 'o papitaiso vaí.” ");
INSERT INTO num_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Pea ne'e fakahā 'e Sione 'o pehē, “Kua u mamata ki te Laumālié 'oku 'alu ifo mei te langí 'i te tatau 'o he lupe, 'o nofo'i Ia. ");
INSERT INTO num_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Pea ne'e kailoa ke au 'ilo'i Ia 'e au, kā ko Ia ne'e fekau'i mai 'oku ke papitaiso vaí ne'e folafola Ia, 'o pehē: ‘Ko te Toko Taha 'e ke mamata ki aí, 'oku 'alu ifo te Laumālié, 'o nofo'i Ia, ko Ia ia 'oku fai papitaiso 'aki te Laumālie Mā'oni'oní.’ ");
INSERT INTO num_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Pea kua u mamata 'e au, pea kua u fakahaa'i: ko 'eni ia 'ia te 'Alo 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","'I te 'aho tono hokó ne'e tu'u ai pē 'ia Sione, pea 'i ai mo he toko ua 'o tana kau akó; ");
INSERT INTO num_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","pea 'i tana sio kiā Sīsū 'oku 'eva'eva aké, ne'e iange ia, “Vakai, ko te Lami 'ena 'a te 'Atuá!” ");
INSERT INTO num_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Pea 'i te fanongo 'e te ongo akó ki tana leá, ne'e nā mulimuli leva kiā Sīsū. ");
INSERT INTO num_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Pea tafoki ange 'e Sīsū, 'o vakai ki te nā mulimuli maí, pea iange 'e Ia kiā nāua, “Ko te ā ia 'oku kulā kumí?” Pea nā iange kiā Ia, “Lāpai” (ko tono 'uhingá, “Faiako”), “'oku nofo 'ia Koé 'i fea?” ");
INSERT INTO num_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Pea iange 'e Ia kiā nāua, “Kulā ōmai, 'o sio ki ai.” Pea nā ō, 'o mamata ki te feitu'u ne'e nofo Ia 'i aí, 'o notou nonofo mo Ia ke 'osi te 'aho ko iá, he ko te fā afiafí 'eni. ");
INSERT INTO num_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ko te taha 'o te ongo me'a ne'e fanongo ki te lea 'a Sione, 'o mulimuli ai kiā Sīsuú, ko 'Anitelū, ko te tehina 'o Saimone Pita. ");
INSERT INTO num_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ko ia ia ne'e matu'a ma'u tono tokoua 'o'oná 'ia Saimone, 'o iange kiā ia, “'Ē, kua mā 'ilo'i te Mīsaiá,” ('a ia ko tono hikí, ko Kalaisi). ");
INSERT INTO num_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Pea ne'e taki 'e ia 'ona kiā Sīsū. Pea 'i te mamata 'e Sīsū kiā iá, ne'e iange 'e Ia, “Ko Saimone koe, ko te foha 'o Sioná; 'e ui 'ou ko Kīfasi,” ('a ia ko tono hikí, ko Pita, pe ko Maka.) ");
INSERT INTO num_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pea 'i te 'aho tono hokó ne'e loto 'e Ia ke 'alu ki Kāleli; pea 'ilo'i ai 'e Sīsū 'ia Filipe, 'o iange kiā ia, “Mulimuli mai kiā Au.” ");
INSERT INTO num_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pea ko Filipé ko ta'aná ha'u mei Petesaita, ko te kolo ia 'o 'Anitelū mo Pitá. ");
INSERT INTO num_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pea ne'e kumi 'e Filipe 'ia Nātaniela, 'o iange kiā ia, “'Ē, kua motou 'ilo'i 'ia Ia, 'ā ē ne'e lau ki ai 'ia Mōsese 'i te Tohi Laó, mo te kau palōfitá, ko Sīsū mei Nāsaleti, ko te foha 'o Siosifá.” ");
INSERT INTO num_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Pea iange 'e Nātaniela, “He 'e lava koā ke tupu he lelei mei Nāsaleti?” Pea iange 'e Filipe kiā ia, “Ha'u 'o sio.” ");
INSERT INTO num_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Pea 'i te vakai atu 'e Sīsū kiā Nātaniela 'oku ha'u kiā Iá, ne'e iange 'e Ia, “'Ē, ko te 'Isileli mo'oni 'eni, 'oku kailoa he kākā 'iā ia!” ");
INSERT INTO num_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Pea iange 'e Nātaniela kiā Ia, “Ne'e fefe'aki Tau 'ilo'i 'okú?” Pea tali 'e Sīsū kiā ia, “'I te he'iki ai ui 'ou ia 'e Filipe, lolotonga tau 'i te lalo fikí, ne Au sio kiā koe.” ");
INSERT INTO num_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Pea iange 'e Nātaniela, “'E Lāpai, ko Koe ia 'ia te 'Alo 'o te 'Atuá! Ko Koe ia 'ia te Tu'i 'Isilelí!” ");
INSERT INTO num_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Pea iange 'e Sīsū kiā ia, “Ko tau tuí koā, kote'uhí ko Taku pehē atu: ‘Ne Au 'ilo'i 'ou 'i te lalo fikí’? 'E ke mamata he 'ū me'a 'oku lahi ange 'i te me'a nei!” ");
INSERT INTO num_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Pea toe iange 'e Ia, “Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu kiā kōtou: 'e kotou mamata 'āmuli ki te langí kua fakaava, pea 'oku 'alu ake mo 'alu ifo te kau 'āngelo 'a te 'Atuá 'i te Fanautama te Tangatá.” ");
INSERT INTO num_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Pea 'i tono tolu 'o te 'ahó ne'e fai ai he kātoanga mali 'i Kena 'i Kāleli; pea ne'e 'i ai te fa'ē 'a Sīsuú. ");
INSERT INTO num_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Pea ne'e tala foki te ta'ané kiā Sīsū, mo Tana kau akó. ");
INSERT INTO num_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Pea 'i te maha 'ia te uainé, ne'e lea kiā Sīsū 'e Tana fa'eé, “'Oku kala he notou uaine.” ");
INSERT INTO num_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Pea folafola ange 'e Sīsū kiā ia, “Fafine, ko te ā 'ia Au kiā koe? 'Oku he'iki ai hoko mai To'okú taimi!” ");
INSERT INTO num_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pea iange 'e Tana fa'eé ki te kau ngāué, “Ko te ā pē he me'a 'e iatu 'e Ia ke kotou faí, fai leva.” ");
INSERT INTO num_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Pea ne'e tu'u 'i ai he hina maka lalahi 'e ono, 'a ia ne'e tuku 'i ai kote'uhí ko te fakama'a faka-Siú, 'e hao ai taki taha he lita vai 'e valungofulu ki te teau uangofulu. ");
INSERT INTO num_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Pea folafola 'e Sīsū kiā nātou, “Kotou fakafonu vai 'ia te 'ū hiná.” Pea notou fakafonu vai 'ia te 'ū hiná 'o fonu lelei. ");
INSERT INTO num_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pea iange 'e Ia kiā nātou, “Fakatau leva, pea 'ave ki te 'aliki 'o te kātoangá.” Pea notou 'ave. ");
INSERT INTO num_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Pea 'i te kamata 'e te 'aliki 'o te kātoangá ki te vai kua hoko 'o uainé, kae kailoa 'ilo'i 'e ia pē ne 'aumaí mei fea, (kā ne 'ilo'i pē 'e te kau sevānití, 'ā ē ne'e notou fakatau 'ia te vaí) pea ui ange 'e te 'aliki 'o te kātoangá 'ia te 'aliki ta'ané, ");
INSERT INTO num_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","'o iange, “Ko te anga 'o te tangatá ke fu'aki 'aumai te uaine leleí, pea kā konā leva 'ia te kakaí, pea toki 'aumai te uaine koví; kā ko koe kua ke ta'ofi te uaine leleí ki te taimi nei!” ");
INSERT INTO num_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ne'e fai 'e Sīsū Tana fu'aki faka'ilonga mana ko 'ení 'i Kena 'i Kāleli, 'o fakae'a ai 'e Ia Tono lāngilangí; pea ne'e tui pīkitai kiā Ia Tana kau akó. ");
INSERT INTO num_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","'I te 'osi ange 'ení, ne'e 'alu ifo Ia ki Kāpaneume, mo Tana fa'eé, mo Tono 'ū tokouá, mo Tana kau akó, pea notou nofo 'i ai he 'ū 'aho si'i. ");
INSERT INTO num_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pea kua mei hoko 'ia te Pāsova 'o te ha'a Siú, pea 'alu ake 'ia Sīsū ki Selusalema. ");
INSERT INTO num_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pea 'ilo'i atu 'e Ia 'i te Temipalé he kau fakatau pulu mo te sipi mo te lupe, mo te kau fetongi pa'anga 'oku notou fetāngutu'i ai. ");
INSERT INTO num_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Pea ngaahi leva 'e Ia he uipi 'aki te 'ū afo, 'o kapusi 'ia nātou kotoa pē mei te Temipalé, mo te fanga sipí foki, mo te fanga pulú; 'o hua'i te pa'anga 'a te kau fetongi pa'angá, mo fulihi te notou 'ū tēpilé, ");
INSERT INTO num_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","pea folafola 'e Ia kiā nātou ne'e notou fakatau lupé, “'Ave te 'ū me'a nā mei heni, pea 'aua ngaahi 'ia te fale 'o Taku Tamaí ko te fale fakatau.” ");
INSERT INTO num_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Pea manatu Tana kau akó kua tohi 'o pehē, “Ko Taku mamahi'i Tou falé 'oku vela hangē he afí 'i Toku lotó.” ");
INSERT INTO num_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Pea tali 'e te ha'a Siú kiā Ia, “Ko te ā he faka'ilonga 'oku Ke tuku mai, 'i Tau fai te 'ū me'a nei?” ");
INSERT INTO num_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Pea folafola ange 'e Sīsū kiā nātou, “Holoki 'ia te fale tapu nei, pea 'e Au tē fokotu'u ia 'i te 'aho 'e tolu.” ");
INSERT INTO num_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Pea iange 'e te kau Siú, “Kua 'osi te ta'u 'e fāngofulu mā ono tono langa 'o te Fale Tapu nei, pea 'e Ke fokotu'u koā ia 'e Koe he 'aho pē 'e tolu?” ");
INSERT INTO num_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ka ne'e 'uhinga Ta'aná lea ki te fale tapu ko Tono sinó. ");
INSERT INTO num_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","He ko te taimi ko 'ē ne'e fokotu'u ai 'Ona mei te pekiá, ne'e manatu Tana kau akó ki Tana lea peheé; pea notou tui leva ki te Tohitapú, mo te lea kua fai 'e Sīsuú. ");
INSERT INTO num_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pea ko te lolotonga ē Tana 'i Selusalema 'i te fai 'o te kātoanga Pāsová, ne'e tui ai he kakai tokolahi ki Tono huafá, 'i te notou mamata ki Tana 'ū faka'ilonga mana ne'e faí. ");
INSERT INTO num_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ka ne'e kailoa falala 'e Sīsū ia kiā nātou, kote'uhí ko Tana 'afio'i lelei 'ia te kakai kotoa pē, ");
INSERT INTO num_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","pea ne'e kailoa fia ma'u 'e Ia ke faka'ilo ange he taha he me'a 'oku kau ki te tangatá, hē ne Ina mea'i lelei pē 'ia te me'a 'oku 'i te loto 'o te tangatá. ");
INSERT INTO num_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Pea ne'e 'i ai he tangata 'i te kau Fālesí, ko Nikotīmasi tono hingoá, ko he 'aliki ia 'i te kakai Siú. ");
INSERT INTO num_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Pea ha'u pō'uli ia kiā Sīsū, 'o iange, “Lāpai, 'oku motou 'ilo'i ko te faiako 'ia Koe kua Ke ha'u mei te 'Atuá, he 'oku kailoa he tangata kua ina fai he 'ū fu'u faka'ilonga mana pehē, hangē ko ia kua Ke faí, kā 'i te kau mo ia 'e te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Pea tali ange 'e Sīsū kiā ia, “Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu kiā koe: kāpau 'e kailoa fanau'i fo'ou he tangata, 'e kailoa 'aupito mamata ia ki te Pule'anga 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Pea iange 'e Nikotīmasi kiā Ia, “'O lava fefe'aki he tangata ke toe fanau'i kā kua matu'a? 'E lava koā 'e ia ke tē hū ki te manava 'o tana fa'eé, 'o fanau'i?” ");
INSERT INTO num_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Pea tali 'e Sīsū, “Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: kāpau 'e kailoa fanau'i he taha 'i te vaí mo te Laumālié, 'e kailoa 'aupito lava ia ke hū ki te Pule'anga 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ko te me'a kua fanau'i mei te kakanó ko te kakano ia, pea ko te me'a kua fanau'i mei te Laumālié ko te laumālie ia. ");
INSERT INTO num_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","'Aua na'a ke ofo 'i Taku pehē atu, ‘Kua pau ke kotou fanau'i fo'oú.’ ");
INSERT INTO num_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","'Oku feangi'aki fa'italiha pē 'ia te matangí, pea 'oku ke ongo'i tana mumuhú, kā 'oku kailoa ke 'ilo'i pe ko tana ha'ú mei fea, pe ko tana 'alú ki fea. Ko te anga ia 'o nātou kotoa pē kua fanau'i mei te Laumālié.” ");
INSERT INTO num_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Pea tali ange 'e Nikotīmasi kiā Ia, “'O lava fefe'aki 'ia te 'ū me'a nei?” ");
INSERT INTO num_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Pea tali 'e Sīsū kiā ia, “Ko koé ko he faiako 'Isilelí, pea 'oku kailoa koā ke 'ilo'i 'ia te 'ū me'a nei? ");
INSERT INTO num_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: 'oku motou lea 'aki 'ia te me'a 'oku motou 'ilo'i, pea motou fakahā 'ia te me'a kua motou sisio ki aí; kā 'oku kailoa kotou fia tali te motou fakamo'oní. ");
INSERT INTO num_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kāpau kua U tala kiā kōtou 'ia te 'ū me'a 'o te māmaní, kae kailoa pē he kotou tuí, pea 'e kotou tui fefe'aki ai, 'o kāpau 'e Au tala kiā kōtou 'ia te 'ū me'a 'o hēvaní? ");
INSERT INTO num_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Pea kua he'iki ai 'alu ake he toko taha ki hēvani, ngata pē 'iā Ia ne'e 'alu ifo mei hēvaní, ko te Fanautama te Tangatá.” ");
INSERT INTO num_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Pea hangē ko te hiki ki lunga 'e Mōsese 'ia te ngatá 'i te toafá, pehē foki kua pau ke hiki ki lunga 'ia te Fanautama te Tangatá, ");
INSERT INTO num_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kote'uhí ko ia kotoa pē 'oku tui kiā Iá ke 'aua na'a 'auha, kae ma'u 'ia te ma'uli ta'engatá. ");
INSERT INTO num_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","He ne'e pehē fau te 'ofa 'a te 'Atuá ki māmaní, ko ia ne Ina foaki Tono 'Alo pē tahá, kote'uhí ko ia fuli pē 'oku tui pīkitai kiā Iá ke 'aua na'a 'auha, kae ma'u 'ia te ma'uli ta'engatá. ");
INSERT INTO num_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","He ne'e kailoa fekau mai 'e te 'Atuá Tono 'Aló ki māmani ke fakamala'ia 'ia māmani, kā kote'uhí ke ma'uli 'ia māmani 'iā Ia. ");
INSERT INTO num_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ko ia 'oku tui pīkitai kiā Iá 'oku kailoa fakamala'ia ia, kā ko ia 'oku kailoa tuí, kua 'osi fakamala'ia ia; kote'uhí kua kailoa ina tui ki te huafa 'o te 'Alo pē taha 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Pea ko 'eni ia 'ia te mala'ia'angá: kua hoko mai 'ia te maamá ki māmani, kae kei 'ofa ange pē te kakaí ia ki te pō'ulí 'i te maamá, he ko te notou 'ū ngāué ne'e kovi. ");
INSERT INTO num_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","He ko te tangata faikovi fuli pē 'oku fihi'a ki te maamá, pea 'oku kailoa ha'u ia ki te maamá, na'a 'ilonga tana 'ū ngāué. ");
INSERT INTO num_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kā ko ia 'oku fai ki te mo'oní 'oku ha'u ia ki te maamá, kote'uhí ke fakahaa'i tana 'ū ngāué, he kua fai ia 'i te 'Atuá. ");
INSERT INTO num_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","'I te 'osi ange 'ení, ne'e ha'u 'ia Sīsū mo Tana kau akó ki te fanua ko Siuteá, pea nofo Ia 'i ai mo nātou, 'o fai papitaiso. ");
INSERT INTO num_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Pea ne'e 'i ai foki 'ia Sione, 'oku fai tana papitaiso 'i 'Ēnoni ofi ki Sēlemi, kote'uhí ne'e lahi te vaí 'i te feitu'u ko iá; pea ne'e ō ange 'ia te kakaí, 'o papitaiso 'i ai, ");
INSERT INTO num_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","he kua he'iki ai 'ave 'ia Sione ki te pilīsoné. ");
INSERT INTO num_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Pea ne'e fakakikihi ai he 'ihi 'o te kau ako 'a Sioné mo he matu'a Siu, 'o kau ki te fai fakama'á. ");
INSERT INTO num_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Pea notou ōmai kiā Sione, 'o iange ki ai, “Lāpai, ko te Toko Taha ko 'ē ne'e 'iā koe 'i Tu'a-Sioataní, 'a ia kua ke fakahā'iná, 'ē, 'oku fai papitaiso 'e Ia, pea 'oku ō ange 'ia te kakaí kotoa pē kiā Ia.” ");
INSERT INTO num_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Pea iange 'e Sione, “'Oku kailoa fa'a lava te tangatá ke ma'u he me'a, kā 'i tono 'avange kiā ia mei hēvani. ");
INSERT INTO num_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ko kōtoú foki 'oku kotou fakamo'oni ki taku lea ne'e pehē, ‘'Oku kailoa ko au ia 'ia te Kalaisí, kā kua fekau'i mai 'okú ke au mu'amu'a mai 'iā Ia.’ ");
INSERT INTO num_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ko Ia 'oku 'A'ana 'ia te ta'ahiné, ko Ia ia 'ia te Tangata Ta'ané; kā ko te moa'uli 'a te Tangata Ta'ané, 'a ē 'oku tu'u 'o fanongo kiā Iá, 'oku fiafia lahi ia 'i te ongo mai te le'o 'o te Tangata Ta'ané. Ko ia ai, ko ta'akú fiafia kua kakato. ");
INSERT INTO num_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kua pau ke faka'a'au Ia ki mu'a, kae faka'a'au kita ia ki muli.” ");
INSERT INTO num_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ko Ia 'oku 'alu ifo mei lungá 'oku mā'olunga Ia 'i te me'a kotoa pē; ko ia 'oku tupu mei te māmaní 'oku fakaemāmani ia, pea 'oku fakaemāmani mo ta'aná lea. Ko Ia 'oku 'alu ifo mei hēvaní 'oku mā'olunga Ia 'i te me'a kotoa pē. ");
INSERT INTO num_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Pea ko te me'a kua Ina fanongoa mo mātaa'í, 'a 'eni ia 'oku fakamo'oni ki aí, kā 'oku kailoa tali he taha Tana fakamatalá. ");
INSERT INTO num_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ko ia kotoa pē 'oku tali Tana fakamatalá, kua ina sila'i Tana fakamo'oní, 'oku mo'oni 'ia te 'Atuá. ");
INSERT INTO num_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","He ko Ia ne'e fekau mai 'e te 'Atuá, ko te 'ū Folafola 'a te 'Atuá ia 'oku Ina lea 'akí, hē 'oku kailoa 'avatu fakafōfua 'e te 'Atuá 'ia te Laumālié kiā Ia. ");
INSERT INTO num_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","'Oku 'ofa 'ia te Tamaí ki te 'Aló, pea kua tukuange 'e Ia 'ia te me'a kotoa pē ki Tono nimá. ");
INSERT INTO num_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ko ia 'oku tui pīkitai ki te 'Aló 'oku ma'u 'e ia 'ia te ma'uli ta'engatá, kā ko ia 'oku kailoa ina tui ki te 'Aló 'e kala mamata 'e ia ki te ma'ulí, kā 'oku nofo ma'u kiā ia 'e te houhau 'a te 'Atuá. ");
INSERT INTO num_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Pea 'i te mea'i 'e te 'Alikí kua fanongo 'e te kau Fālesí, 'o pehē 'oku fakaului mo papitaiso 'e Sīsū he kau ako, 'o tokolahi ange 'iā Sioné; ");
INSERT INTO num_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(kae tala'i'eaí ne'e fai papitaiso 'e Sīsū, kā ko Tana kau akó pē,) ");
INSERT INTO num_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ko ia ne Ina hiki mei Siutea, 'o tē 'alu mei ai ki Kāleli. ");
INSERT INTO num_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pea ne'e pau ke 'alu atu Ia 'i loto Samēlia. ");
INSERT INTO num_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pea fou atu Ia 'i te kolo 'o Samēlia, 'a ia ne'e ui ko Saika, 'oku ofi ki te konga fanua ne'e 'avange 'e Sēkope kiā Siosifa ko tono fohá. ");
INSERT INTO num_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Pea ne'e 'i ai te vaikeli 'o Sēkopé. Pea kua hela'ina 'ia Sīsū 'i te fonongá, pea ta'utu leva Ia ki te ngutu vaí; ne'e fe'unga nai 'eni mo te ho'atā mālie. ");
INSERT INTO num_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Pea ne'e 'alu ange he fafine Samēlia, ke 'utu vai. Pea iange 'e Sīsū kiā ia, “'Ē, mai mu'a Si'aku inu.” ");
INSERT INTO num_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(He kua ō Tana kau akó ki te koló ke fakatau me'akai.) ");
INSERT INTO num_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Pea iange 'e te fafine Samēliá kiā Ia, “Ko te Siu 'ia Koe, pea fefe'aki ai Tau kole inu mai kiā au, ko te fafine Samēlia?” He 'oku kailoa fe'ofa'ofani he Siu mo he Samēlia. ");
INSERT INTO num_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Pea tali 'e Sīsū kiā ia, “Ka ne ke 'ilo'i te me'a'ofa 'a te 'Atuá, mo Ia 'oku pehē atu, ‘Mai mu'a Si'aku inú,’ pehē kua ke kole kiā Ia, pea kua Ina 'avatu 'ia te vai ma'ulí.” ");
INSERT INTO num_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Pea iange 'e te fafiné kiā Ia, “'Aliki, 'oku kala Hau me'a ke 'utu 'aki, pea 'oku loloto 'ia te vaitupú; pea mei fea ai Tau ma'u te vai ma'uli nā? ");
INSERT INTO num_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Hē ko te lahi koā 'ia Koe 'i te tou kui ko Sēkopé, 'ā ē ne'e tuku mai kiā mātou 'ia te vai ko 'ení, pea ne'e inu ia mei ai, mo tana fānaú, mo tana fanga monumanú?” ");
INSERT INTO num_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Pea me'a ange 'e Sīsū kiā ia, “Ko ia kotoa pē 'oku inu mei te vai ko 'ená 'e toe fiainua, ");
INSERT INTO num_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kā ko ia 'e inu mei te vai 'e Au 'avatú, 'e kailoa 'aupito toe fiainua ia 'o ta'engata, kā ko te vai 'e Au 'avatu kiā iá, 'e tupu 'i loto 'iā ia, ko te matavai mapunapuna ake, 'o iku ki te ma'uli ta'engata.” ");
INSERT INTO num_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Pea iange 'e te fafiné kiā Ia, “'Aliki, foaki mai te vai ko 'ená kiā au, kote'uhí ke 'aua na'a u fiainua, pe toe hela'ina mai ki heni ke 'utu.” ");
INSERT INTO num_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Pea me'a ange 'e Sīsū kiā ia, “'Alu, ui mai tou malí, pea kulā ōmai ki heni.” ");
INSERT INTO num_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Pea tali ange 'e te fafiné, “'Oku kailoa si'aku mali.” Pea iange 'e Sīsū, “'Oku mo'oni pē ta'aú lea, ‘'Oku kailoa 'i ai si'aku mali;’ ");
INSERT INTO num_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","he ne ke ma'u te mali 'e toko nima, pea ko te tangata 'oku kulā nonofo nā, 'oku kala ko tou mali. Ko te mo'oni pē ta'aú lea.” ");
INSERT INTO num_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Pea lea ange 'e te fafiné kiā Ia, “'E 'Aliki, 'okou 'ilo'i 'eni ko te palōfita 'ia Koe. ");
INSERT INTO num_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ne'e lotu te motou mātu'á 'i mu'a 'i te ma'unga nei, kā ko kōtoú 'oku kotou pehē, ko Selusalema pē te feitu'u 'oku totonu ke fai ai te lotú.” ");
INSERT INTO num_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Pea iange 'e Sīsū kiā ia, “Fafine, tui mai kiā Au, 'oku 'unu mai 'ia te taimi, 'e kala toe fai ai 'i te ma'unga nei, pē 'i Selusalema, te kotou lotu ki te Tamaí. ");
INSERT INTO num_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ko kōtoú 'oku kotou lotu ki te me'a 'oku kailoa he kotou 'ilo ki ai; 'oku motou lotu mātou ki te me'a 'oku motou 'ilo'i, he 'oku mei te kakai Siú 'ia te fakama'ulí. ");
INSERT INTO num_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kā 'oku 'unu mai te taimi, 'io, kua hoko ia, 'a ia ko te kakai 'oku lotu mo'oní 'e notou fai 'i laumālie mo fai 'i mo'oni te notou lotu ki te Tamaí. He ko te Tamaí foki 'oku kumi 'e Ia 'ia te fa'ahinga ko iá, ke lotu kiā Ia. ");
INSERT INTO num_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ko te 'Atuá ko te Laumālie, pea ko nātou 'e lotu kiā Iá, kua pau ke notou fai 'i laumālie pea fai 'i mo'oni te notou lotú.” ");
INSERT INTO num_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Pea iange 'e te fafiné kiā Ia, “'Okou 'ilo'i 'oku ha'u 'ia te Mīsaiá ('ā ē 'oku ui ko Kalaisí); kā ha'u Ia, 'e toki fakahaa'i 'e Ia kiā mātou 'ia te me'a kotoa pē.” ");
INSERT INTO num_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Pea folafola ai 'e Sīsū kiā ia, “Ko Au ia, 'a 'eni 'oku lea kiā koé.” ");
INSERT INTO num_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Pea fe'unga iá mo te ōmai Tana kau akó, 'o notou 'ohovale 'i Tana talanoa mo te fafiné. Kae mole ke mama'o he notou taha 'e iange, “Ko te ā te me'a 'oku Ke kumí?” pe, “Ko te ā 'oku kulā talanoa ai mo te fafiné?” ");
INSERT INTO num_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pea ne'e si'aki 'e te fafiné tana hina vaí, kae foki ia ki kolo, 'o talanoa'i holo ki te kakaí, ");
INSERT INTO num_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Kotou ōmai angé, 'o mamata ki te Tangata kua Ina 'a'au mai taku me'a kotoa pē kua u faí. Ko te Kalaisí nai 'eni pe kailoa?” ");
INSERT INTO num_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Pea notou 'alu atu mei te koló, 'o ōmai kiā Ia. ");
INSERT INTO num_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Lolotonga iá ne'e kole ange 'e te kau akó kiā Ia, 'o pehē, “Lāpai, ke Ke tokoni mu'a.” ");
INSERT INTO num_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kae iange 'e Ia kiā nātou, “'Oku 'i ai Ta'akú kai 'oku kala kotou 'ilo ki ai.” ");
INSERT INTO num_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Pea pehē ai 'e te kau akó, “He kua 'avange he taha Hana me'a ke kai?” ");
INSERT INTO num_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pea iange 'e Sīsū kiā nātou, “Ko Ta'akú ē me'akai, ko te fai 'ia te finangalo 'o Ia ne Ina fekau'i mai 'Okú, mo faka'osi Ta'aná ngāue. ");
INSERT INTO num_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","'Oku kala koā kotou lau 'o pehē, ‘'Oku toe te māhina 'e fā, pea hoko te utu-ta'ú’? 'Ē, 'Okou tala'i atu: kotou hanga ake mu'a ki te 'ū ngoue nā; vakai, kua matu'atu'a lelei nātou ia ki te utu-ta'ú. ");
INSERT INTO num_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Pea ko ia 'oku utú 'oku ma'u 'e ia ta'aná totongi, 'o tānaki fua ki te ma'uli ta'engatá: kote'uhí ke nā fiafia fakataha, 'ia ia ne toó, mo ia ne utú. ");
INSERT INTO num_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Pea 'i te me'a nei 'oku mo'oni ai te leá, ‘'Oku tō te taha, kae utu te taha kehe.’ ");
INSERT INTO num_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ne Au fekau atu 'ia kōtou ke utu 'ia te me'a ne'e kailoa kotou hela'ina aí. Ko te kakai kehe ia ne'e notou hela'ina 'i aí, pea kua kotou ma'u pale kōtou ia 'i te notou kakavá.” ");
INSERT INTO num_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Pea ne'e tui kiā Ia te tokolahi 'o te kakai Samēlia mei te kolo ko iá, ko te me'a 'i te lea 'a te fafiné, 'i tana fakahā, “Kua tala'i mai 'e Ia kiā au 'ia te me'a fuli pē ne au faí.” ");
INSERT INTO num_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ko ia 'i te a'u ange te kau Samēliá kiā Iá, ne'e notou kole ange kiā Ia ke nofo ifo mu'a mo nātou; pea ne'e nofo Ia 'i ai 'i te 'aho 'e ua. ");
INSERT INTO num_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Pea ne'e tokolahi mo te kakai kehe ne'e notou tuí ko te me'a 'i te folafola 'A'aná. ");
INSERT INTO num_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Pea notou iange ki te fafiné, “'Oku kala motou kei tui kote'uhí pē ko tau talanoa ne'e faí; he kua motou fanongo tonu ki ai 'e mātou, pea kua motou 'ilo'i, ko 'eni mo'oni ia 'ia te Kalaisí, ko te Fakama'uli 'o māmaní.” ");
INSERT INTO num_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pea kua 'osi te 'aho 'e ua, pea 'alu Ia mei ai, 'o fononga ki Kāleli. ");
INSERT INTO num_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","He ko Sīsū pē ne'e fakamo'oni, 'oku kailoa faka'apa'apa'ina he palōfita 'i tono fanua tonu 'o'oná. ");
INSERT INTO num_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ko ia 'i Tana a'u leva ki Kālelí, ne'e tali lelei 'Ona 'e te kakai Kālelí, he kua notou mamata tonu ki te 'ū fu'u me'a ne'e fai 'e Ia 'i Selusalema 'i te kātoangá; he ne'e notou ō foki mo nātou ki te kātoangá. ");
INSERT INTO num_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Pea toe ha'u 'ia Sīsū ki Kena 'i Kālelí, 'ia te kolo ne'e liliu ai 'e Ia 'ia te vaí ke uainé. Pea ne'e 'i ai he 'aliki, ne'e puke tono fohá 'i Kāpaneume. ");
INSERT INTO num_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pea 'i te fanongo 'e te matāpule ko iá, kua ha'u 'ia Sīsū mei Siutea ki Kālelí, ne'e 'alu atu ia ki Ai, 'o kole ange ke me'a ifo mu'a 'o fakama'uli si'ana fohá, hē kua vave ta'aná mate. ");
INSERT INTO num_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Pea me'a ai 'e Sīsū kiā ia, “'Ē, kāpau 'e kailoa kotou mamata ki te 'ū faka'ilongá, mo te 'ū me'a fakaofó, 'e kailoa pē tui kōtou ia.” ");
INSERT INTO num_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pea lea ange te tangatá kiā Ia, “'Aliki, me'a mai mu'a, na'a pekia si'aku 'uhikí.” ");
INSERT INTO num_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Pea folafola ange 'e Sīsū kiā ia, “'Alu koe ia; kua ma'uli to'oú foha.” Pea ne'e tui te matāpulé ki te Folafola kua fai ange 'e Sīsuú, pea 'alu ia. ");
INSERT INTO num_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Pea 'i te lolotonga tana kei fononga atú, ne'e fakafetaulaki mai tana kau tamaio'alikí kiā ia, 'o notou iange, “Kua ma'uli tou fohá!” ");
INSERT INTO num_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Pea fehu'i ange 'e ia kiā nātou ki te houa ne'e kamata sai aí. Pea notou iange, “Ne'e mahu'i atu te mofí meiā ia 'i te taha hoataá 'aneafi.” ");
INSERT INTO num_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Pea 'ilo'i leva 'e te tamaí, tā ne'e 'i te houa pē ko iá, ne'e folafola ai 'e Sīsū kiā ia 'o pehē, “Kua ma'uli tou fohá.” Pea tui leva ia, mo tono fāmilí kātoa. ");
INSERT INTO num_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ko tono ua 'eni 'o te faka'ilonga mana ne'e fai 'e Sīsū, 'i Tana ha'u mei Siutea ki Kālelí. ");
INSERT INTO num_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pea 'i te 'osi ange 'ení, ne'e 'i ai he kātoanga 'a te ha'a Siú; pea fononga ake 'ia Sīsū ki Selusalema. ");
INSERT INTO num_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Pea 'oku tu'u 'i Selusalema, 'o ofi ki te Matapā Sipí, he lepa vai 'e taha, 'oku ui 'i te lea faka-Hepeluú ko Petesata, ne'e nima tono fakafaletoló. ");
INSERT INTO num_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ko te 'ū fale ala ko iá ne'e tākokoto ai he fu'u kakai mahaki, ko te kui, mo te heke, mo te mamatea, 'o talitali ki te ngaungaue 'ia te vaí. ");
INSERT INTO num_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Hē ne 'alu ifo he 'āngelo 'i te taimi pau ki te lepá, 'o ue'i 'ia te vaí; pea ko ia 'e fu'aki hopo ki te vaí 'i te 'osi tono ue'iná, ne'e fakama'uli 'ona mei tono mahaki fuli pē. ");
INSERT INTO num_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pea ne'e 'i ai he tangata 'i te feitu'u ko iá, kua ta'u tolungofulu mā valu tana mahaki'iná. ");
INSERT INTO num_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Pea 'i te mamata 'e Sīsū kiā ia 'oku takotó, mo 'ilo'i kua fualoa tana peheé, ne'e fehu'i ange 'e Ia, “'Oku loto 'ia koe ke ke ma'uli?” ");
INSERT INTO num_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Pea iange 'e te mahakí, “'E 'Aliki, 'oku kala u ma'u si'aku taha ke hiki 'oku ki te lepá, 'o kā ue'i 'ia te vaí; pea 'i te lolotonga si'aku feinga 'alu 'iā kita peé, kua laka ifo he taha kehe ia, 'o mu'amu'a 'iā au.” ");
INSERT INTO num_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Pea folafola 'e Sīsū kiā ia, “Tu'u ake, to'o tou moe'angá, pea 'alu.” ");
INSERT INTO num_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Pea ma'uli leva 'ia te tangatá, pea to'o 'e ia tono moe'angá, 'o 'alu. Pea tā ko te Sāpate 'ia te 'aho ko iá. ");
INSERT INTO num_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ko ia ne'e lea ai 'e te kau Siú ki te tangata kua fakama'ulí, “'Ē, ko te Sāpate 'eni, pea 'oku kala ngafua tau to'o moe'angá.” ");
INSERT INTO num_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ka ne'e iange 'e ia kiā nātou, “Ko Ia ko 'ē ne'e fakama'uli 'okú, ko Ia ia ne'e lea mai kiā au 'o pehē, ‘To'o tou moe'angá, pea 'alu.’ ” ");
INSERT INTO num_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Pea notou fehu'i kiā ia, “Ko ai te tangata ne'e iatu kiā koe, ‘To'o tou moe'angá 'o 'alú’?” ");
INSERT INTO num_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kā ko te tangata kua faito'ó ne'e kailoa 'ilo'i 'e ia pe ko ai koā Ia; he kua mavahe 'ia Sīsū ia mei ai, kote'uhí ne'e fonu te kakaí 'i te feitu'u ko iá. ");
INSERT INTO num_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Faifaí pea 'ilo'i 'ona 'e Sīsū 'i te Temipalé, pea me'a 'e Ia ki ai, “Ko 'eni kua fakama'uli 'ou; 'aua na'a ke toe fai angahala, na'a hoko kiā koe he kovi 'oku lahi ange.” ");
INSERT INTO num_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Pea 'alu 'ia te tangatá, 'o fakahaa'i ki te kau Siú, ko Sīsū 'ia te Toko Taha ne'e fakama'uli iá. ");
INSERT INTO num_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ko te 'uhinga 'eni tono fakatanga'i 'o Sīsū 'e te kau Siú, ko Tana fai pehē 'i te 'aho Sāpaté. ");
INSERT INTO num_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ka ne'e iange 'e Sīsū kiā nātou, “Kua ngāue Taku Tamaí 'o a'u mai ki te taimi nei, pea 'oku ngāue mo Au foki.” ");
INSERT INTO num_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ko tono 'uhinga ia ne'e 'āsili feinga ai 'e te kakai Siú ke tāmate'i 'Oná, kote'uhí he ne'e kailoa ngata pē 'i Tana maumau Sāpaté, kā kua lau foki 'e Ia 'ia te 'Atuá ko Tana Tamai tonu, 'o fakatatau ai 'Ona ki te 'Atuá. ");
INSERT INTO num_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ko ia ai ne'e folafola 'e Sīsū kiā nātou, “Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: 'oku kailoa lava te 'Aló ke fai he me'a 'iā Ia pē, ngata pē 'i te me'a 'oku vakai atu 'e Ia 'oku fai 'e te Tamaí. He ko te me'a kotoa pē 'oku fai 'e te Tamaí, 'oku fai ia 'e te 'Aló foki. ");
INSERT INTO num_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Hē 'oku 'ofa te Tamaí ki te 'Aló, 'o fakahā kiā Ia 'ia te 'ū me'a kotoa pē 'oku fai 'e Tana 'Afió. Pea 'e fakahaa'i foki 'e Ia ki Ai he 'ū ngāue 'oku hulu atu 'i te 'ū me'a nei, kote'uhí ke kotou ofo. ");
INSERT INTO num_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","He hangē ā 'oku fokotu'u 'e te Tamaí 'ia te kau pekiá, mo ngaahi 'ia nātou ke ma'ulí, 'oku pehē foki mo te 'Aló, 'oku ngaahi 'e Ia ke ma'uli 'ia nātou kotoa pē 'oku loto Ia ki aí. ");
INSERT INTO num_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","He 'oku kailoa fakamāu'i 'e te Tamaí he toko taha, kā kua tukuange 'e Ia 'ia te fakamaau kotoa pē ki te 'Aló, ");
INSERT INTO num_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","kote'uhí ke 'apasia 'e te kakai kotoa pē ki te 'Aló, 'o hangē ko te notou 'apasia ki te Tamaí. Ko ia 'oku kailoa 'apasia ki te 'Aló, 'oku kailoa 'apasia ia ki te Tamaí 'a ē ne'e fekau'i mai 'Oná. ");
INSERT INTO num_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: ko ia 'oku fanongo ki Taku leá, pea tui kiā Ia ne'e fekau mai 'Okú, 'oku ina ma'u 'ia te ma'uli ta'engatá, pea 'e kailoa fakamala'ia ia, kā kua hao ia mei te maté ki te ma'ulí. ");
INSERT INTO num_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: 'oku 'unu mai he taimi, 'io, ko 'eni ia, 'a ia 'e fānonongo ai 'e te kau maté ki te le'o 'o te 'Alo 'o te 'Atuá, pea ko nātou 'oku fanongó 'e notou ma'uli. ");
INSERT INTO num_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","He hangē 'oku ma'u ma'uli 'ia te Tamaí 'iā Ia peé, 'oku pehē foki Tana tuku ki te 'Aló ke ma'uli 'iā Ia pē; ");
INSERT INTO num_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","pea kua Ina tuku ke 'A'ana 'ia te fai fakamaaú, kote'uhí ko te Fanautama te Tangata Ia. ");
INSERT INTO num_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","'Aua 'e kotou ofo 'i te me'a ko iá, he 'oku 'unu mai he taimi, 'a ia 'e fānonongo ai ki Tono le'ó 'e te kakai kotoa pē 'oku 'i te 'ū fanualotó, ");
INSERT INTO num_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","pea 'e notou ō ake mei ai: ko nātou ne'e ngāue leleí, ki te toetu'u 'o te ma'ulí, mo nātou ne'e faikoví, ki te toetu'u 'o te fakamala'iá. ");
INSERT INTO num_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“'Oku kailoa U lava ke fai he mama'i me'a 'iā Au pē. 'Okou fakamaau 'o hangē ko Taku fanongó; pea ko te fakamaau 'A'akú 'oku totonu, kote'uhí 'oku kailoa U fai ki te loto 'O'okú, kā ki te finangalo 'o Ia ne'e fekau'i mai 'Okú. ");
INSERT INTO num_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kāpau ko Au pē 'oku fakamo'oni kiā Aú, tā 'oku kailoa mo'oni Ta'akú fakamo'oni. ");
INSERT INTO num_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ko te Taha kehe ia 'oku fakamo'oni kiā Aú, pea 'Okou 'ilo'i 'oku mo'oni Tana fakamo'oni 'oku fai kiā Aú. ");
INSERT INTO num_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ko kōtoú ne'e kotou fekau atu kiā Sione, pea ne'e fakamo'oni 'e ia ki te mo'oní. ");
INSERT INTO num_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kā ko Au 'oku kailoa U tali he fakamo'oni mei te tangatá, kā 'Okou lea peheé, kote'uhí ke kotou ma'uli. ");
INSERT INTO num_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ko Sioné ko te maama ia kua tutu pea ulo, pea ko kōtoú ne'e kotou loto ke hākahaka 'i tono maamá, 'o fualoa si'i. ");
INSERT INTO num_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Kā ko Taku fakamo'oni 'A'akú 'oku lahi Ia 'iā Sione. He ko te 'ū ngāue ne'e tuku mai 'e te Tamaí ke Au lavá, 'io, ko te 'ū ngāue 'Okou faí, 'oku notou fakamo'oni'i kua fekau mai 'Oku 'e te Tamaí. ");
INSERT INTO num_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","'Io, ko te Tamaí, 'a ē ne Ina fekau mai 'Okú, kua fakamo'oni 'e Ia kiā Au. Kae tala'i'eaí kua ongo Tono le'ó kiā kōtou he taimi, pea tala'i'eaí foki kua kotou mamata ki Hana 'ata. ");
INSERT INTO num_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Pea 'oku kala kotou ma'u Tana Folafolá 'iā kōtou, he 'oku kala kotou tui kōtou kiā Ia ne Ina fekau maí. ");
INSERT INTO num_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","'Oku kotou hakule 'ia te Tohitapú, kote'uhí 'oku kotou mahalo 'oku tu'u 'i ai te kotou ma'u 'ia te ma'uli ta'engatá, pea ko ia ia 'oku fakamo'oni kiā Aú. ");
INSERT INTO num_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kā 'oku kailoa kotou loto ke ha'u kiā Au, kote'uhí ke kotou ma'u ma'uli. ");
INSERT INTO num_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","'Oku kailoa U tali te fakahīkihiki 'oku fai mei te tangatá. ");
INSERT INTO num_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kā kua U 'ilo'i 'ia kōtou, 'oku kailoa 'iā kōtou te 'ofa ki te 'Atuá. ");
INSERT INTO num_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ko Aú ne Kita ha'u 'i te huafa 'o Taku Tamaí, kae tala'i'eaí 'oku kotou tali 'ia Au. Kāpau 'e ha'u he taha kehe 'i tono hingoa 'o'oná, 'e kotou tali te toko taha ko iá. ");
INSERT INTO num_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","'E lava fefe'aki ke kotou tui, 'ia kōtou 'oku kotou tali te fakahīkihiki 'oku kotou fefai'akí, kae kailoa kotou kumi ki te fakahīkihiki 'oku mei te 'Atua Taha tofu peé? ");
INSERT INTO num_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","'Aua na'a kotou pehē, 'e Au talatalaaki'i kōtou ki te Tamaí. 'Oku 'i ai he toko taha ia 'oku talatalaaki'i kōtou, ko Mōsese, 'a ē 'oku kotou falala ki aí. ");
INSERT INTO num_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","He kāpau ne'e kotou tui mo'oni kiā Mōsese, ne'e kotou tui foki kiā Au, he ne'e tohi 'e iá kiā Au. ");
INSERT INTO num_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kae kāpau 'oku kala kotou tui ki tana 'ū tohí, pea fefe'aki ai he kotou tui ki Ta'akú 'ū lea?” ");
INSERT INTO num_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pea 'i te 'osi ange 'ení, ne'e folau 'ia Sīsū ki te kauvai 'o te Tai 'o Kālelí, 'a ia ko te Tai 'o Taipilioó. ");
INSERT INTO num_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Pea ne'e mulimuli kiā Ia he fu'u kakai tokolahi, kote'uhí ko te notou mamata ki Tana 'ū faka'ilonga mana ne'e fai kiā nātou ne'e mahaki'iná. ");
INSERT INTO num_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Pea ne'e 'alu ake 'ia Sīsū ki te ma'ungá, 'o nofo ifo 'i ai mo Tana kau akó. ");
INSERT INTO num_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pea ne'e ofi 'ia te Pāsová, 'a ia ko te kātoanga 'o te ha'a Siú. ");
INSERT INTO num_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Pea hanga ake 'e Sīsū 'o vakai atu, tā ko te fu'u kakai 'ena 'oku notou ha'u kiā Ia; pea iange 'e Ia kiā Filipe, “'E tou fakatau mei fea he mā ke kai 'ia te kakai ko 'ená?” ");
INSERT INTO num_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Kā ko Tana lea peheé ko Tana 'ahi'ahi'i pē 'ona, he ne'e mea'i 'e Tana 'Afió 'ia te me'a 'oku 'amanaki 'e Ia ke faí. ");
INSERT INTO num_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pea tali 'e Filipe kiā Ia, “Neongo 'e ma'u mai he mā tēnali 'e uangeau, kā 'e kailoa pē fe'unga ia ke notou taki taha to'o he me'a si'isi'i.” ");
INSERT INTO num_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Pea lea kiā Ia he toko taha 'o Tana kau akó, ko 'Anitelū ko te tokoua 'o Saimone Pitá, 'o pehē, ");
INSERT INTO num_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“'Oku 'i ai he tamasi'i 'i heni, 'oku 'i ai tana fe'i mā pa'ale 'e nima, mo he mata'i ika 'e ua, kā ko te ā te me'a ko iá ki te fu'u kakai tokolahi pehē?” ");
INSERT INTO num_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Pea me'a ange 'e Sīsū, “Fekau te kakaí ke notou nonofo ki lalo.” Pea ne'e musie'ina 'ia te feitu'u ko iá. Pea ne'e nonofo ki lalo 'ia te kau tangatá; ne'e fe'unga nai mo te toko nima afe. ");
INSERT INTO num_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Pea to'o ai 'e Sīsū 'ia te 'ū fe'i maá, 'o fai he fakafeta'i, 'o toki tufa kiā nātou 'oku nonofo ki laló; pea pehē pē mo te ongo iká, 'o fai pē kae'aua ke notou mākona. ");
INSERT INTO num_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Pea kua notou fu'u mākokona, pea iange 'e Ia ki Tana kau akó, “Kotou tānaki 'ia te 'ū mapakipaki'i mā 'oku toé, ke 'aua na'a maumau he me'a.” ");
INSERT INTO num_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ko ia ne'e notou tānaki, 'o fakafonu he kato 'e hongofulu mā ua, 'aki te 'ū kongakonga mā mei te fe'i mā pa'ale 'e nimá, 'a ia ne'e toe 'iā nātou ne'e kaí. ");
INSERT INTO num_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Pea 'i te vakai 'e te kakaí ki te faka'ilonga mana kua fai 'e Sīsuú, ne'e notou pehē, “Ko 'eni mo'oni ia 'ia te palōfita kā ha'u ki māmaní.” ");
INSERT INTO num_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pea 'i te mea'i leva 'e Sīsū, 'oku notou teu ke ōmai 'o 'ave fakamālohi'i 'Ona, 'o fakanofo ke tu'í, ne'e toe 'alu ake Ia ki te ma'ungá toko taha pē. ");
INSERT INTO num_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pea kua afiafi, ne'e 'alu ifo Tana kau akó ki tai, ");
INSERT INTO num_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","pea notou heka ai he vaka, 'o notou kamata folau ki te kauvaí ki Kāpaneume. Pea ko 'eni kua pō'uli, pea kua he'iki ai a'u mai 'ia Sīsū kiā nātou. ");
INSERT INTO num_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ne'e hou foki 'ia te taí, ko te me'a 'i te fu'u matangi kua tō. ");
INSERT INTO num_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pea kua notou 'a'alo 'i te maile nai 'e tolu pe fā, pea notou vakai atu 'ia Sīsū 'oku hā'ele mai 'i te fukahi taí, pea 'oku fakaofiofi mai 'e Ia ki te vaká; pea ne'e notou 'ilifia 'aupito. ");
INSERT INTO num_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ka ne'e iange 'e Ia kiā nātou, “Ko Au pē ia; 'aua 'e kotou manahē.” ");
INSERT INTO num_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Pea notou loto leva ke ma'u Ia ki te vaká; pea ne'e tau leva 'ia te vaká ki te fanua ne'e notou folau ki aí. ");
INSERT INTO num_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pea 'i te pongipongi aké, ko te kakai ne'e tutu'u 'i te kauvaí ne'e notou vakai atú 'oku taha tofu pē 'ia te ki'i vaka 'i te feitu'u ko iá, pea ne'e kailoa heka vaka 'ia Sīsū mo Tana kau akó, kā ko te kau akó pē ne'e folaú. ");
INSERT INTO num_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","(Ka ne'e ha'u he fanga ki'i vaka kehe mei Taipiliō, 'o notou tau ofi ki te feitu'u ne'e notou kai ai 'ia te maá 'i te hili ange tono fakafeta'ina 'e te 'Alikí.) ");
INSERT INTO num_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ko ia 'i te 'ilo'i leva 'e te kakaí, tā 'oku kailoa 'i te feitu'u ko iá 'ia Sīsū, pe ko Tana kau akó, ne'e notou heka foki mo nātou ki te fanga ki'i vaka, 'o notou ō ki Kāpaneume, ko te kumi kiā Sīsū. ");
INSERT INTO num_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pea 'i te notou 'ilo'i 'Ona 'i te kauvaí, ne'e notou 'eke ange kiā Ia, “Lāpai, ne ha'u fakafea 'ia Koe ki hení?” ");
INSERT INTO num_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Pea iange 'e Sīsū kiā nātou, “Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: ko te kotou kumi kiā Aú, 'oku kala kote'uhí ne'e kotou mamata ki te 'ū faka'ilonga maná, kā kote'uhí ne'e kotou kai 'ia te 'ū fe'i maá, 'o mākokona ai. ");
INSERT INTO num_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kotou ngāue, 'o kailoa ki te kai 'oku molé, kā ki te kai 'oku tolongá, 'o iku ki te ma'uli ta'engatá, 'a ia 'e 'avatu kiā kōtou 'e te Fanautama te Tangatá. He ko te Toko Taha ko iá kua sila'i 'e te 'Atua ko te Tamaí.” ");
INSERT INTO num_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Pea notou 'eke ange kiā Ia, “Ko te ā tū 'e motou faí, kae motou feia 'ia te 'ū ngāue mei te 'Atuá?” ");
INSERT INTO num_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Pea tali 'e Sīsū kiā nātou, “Ko 'eni ia 'ia te ngāue mei te 'Atuá, ke kotou tui pīkitai kiā Ia ne'e fekau mai mei te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Pea notou 'eke ange kiā Ia, “Pea ko te ā ia he faka'ilonga 'oku fai 'e Koe, ke motou mamata ki ai 'o tui kiā Koé? Ko te ā Tau ngāue 'oku fai? ");
INSERT INTO num_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ko te tou mātu'á ne'e notou kai te maná 'i te toafá, 'o hangē ko ia kua tohí: ‘Ne'e 'avatu 'e Ia kiā nātou, he mā mei te langí ke notou kakai.’ ” ");
INSERT INTO num_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Pea folafola ai 'e Sīsū kiā nātou, “Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: ne'e kailoa ko Mōsese ne 'avatu kiā kōtou 'ia te mā mei te langí; kā ko Taku Tamaí 'oku 'avatu 'e Ia kiā kōtou te mā mo'oni mei te langí. ");
INSERT INTO num_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","He ko te mā 'a te 'Atuá, ko Ia ia 'oku 'alu ifo mei te langí, 'o foaki te ma'ulí ki māmani.” ");
INSERT INTO num_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Pea notou iange kiā Ia, “'Aliki, foaki mai kiā mātou 'ia te mā ko iá ma'u ai pē.” ");
INSERT INTO num_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Pea folafola 'e Sīsū kiā nātou, “Ko Au pē ko te Mā 'o te ma'ulí. Ko ia 'oku ha'u kiā Aú 'e kailoa 'aupito fiakaia ia, pea ko ia 'oku tui pīkitai kiā Aú, 'e kailoa 'aupito fiainua ia. ");
INSERT INTO num_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kā ne Au 'osi tala kiā kōtou 'o pehē, ‘Kua kotou mamata foki kiā Au, kae kailoa tui.’ ");
INSERT INTO num_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ko te me'a kotoa pē 'oku foaki mai 'e te Tamaí kiā Aú 'e ha'u kiā Au; pea ko ia 'oku ha'u kiā Aú, 'e kailoa 'aupito ke Au kapusi. ");
INSERT INTO num_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kote'uhí ne Au 'alu ifo mei te langí, 'o kala U fai ki te loto 'O'okú, kā ko te finangalo 'o Ia ne'e fekau mai 'Okú. ");
INSERT INTO num_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Pea ko 'eni ia 'ia te finangalo 'o Ia ne'e fekau mai 'Okú, kote'uhí ko ia kotoa pē kua foaki mai 'e Iá, ke 'aua na'a U tuku ke mole he toko taha, kaikehe ke Au fokotu'u ia 'i te 'aho fakamulí. ");
INSERT INTO num_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","He ko 'eni ia te finangalo 'o Taku Tamaí, ke 'ilonga pē ia 'oku mamata ki te 'Aló, mo tui pīkitai kiā Iá, ke ma'u 'ia te ma'uli ta'engatá, kae Au fokotu'u ia 'e Au 'i te 'aho fakamulí.” ");
INSERT INTO num_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ko ia ne'e lāunga ai 'ia te ha'a Siú kiā Ia, kote'uhí ko Tana pehē: “Ko Au pē ko te Mā ne 'alu ifo mei te langí.” ");
INSERT INTO num_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Pea notou pehē, “'Oku kala koā ko Sīsū 'eni, ko te foha 'o Siosifá, 'a ē 'oku tou lāu'ilo'i Tana tamaí mo Tana fa'eé? Pea fefe'aki ai Tana lea, 'o pehē, ‘Kua U 'alu ifo mei te langí’?” ");
INSERT INTO num_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Pea tali 'e Sīsū kiā nātou, “'Aua 'e kotou felāutu'u'aki. ");
INSERT INTO num_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","'Oku kailoa lava he taha ke ha'u kiā Au, kā 'i te tohoaki'i 'ona 'e te Tamaí ne'e fekau mai 'Okú, pea 'e Au fokotu'u 'ona 'i te 'aho fakamulí. ");
INSERT INTO num_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kua tohi 'i te Tohi Palōfitá: ‘Pea 'e notou hoko kotoa pē ko te kau akonakina 'e te 'Atuá.’ 'Ilonga pē ia kua fanongo mo akonakina mei te Tamaí, 'oku ha'u ia kiā Au. ");
INSERT INTO num_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","'Oku kailoa he tangata kua mamata ki te Tamaí, ngata pē 'i te Toko Taha 'a ia 'oku mei te 'Atuá; kua mamata Ia ki te Tamaí. ");
INSERT INTO num_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: ko ia 'oku tuí 'oku ina ma'u 'ia te ma'uli ta'engatá. ");
INSERT INTO num_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ko Au pē ko te Mā 'o te ma'ulí. ");
INSERT INTO num_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ne'e kai mana 'e te kotou mātu'á 'i te toafá, pea notou mate pē. ");
INSERT INTO num_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ko 'eni ia 'ia te Mā 'oku 'alu ifo mei te langí, ke kai ai he taha 'o 'aua na'a mate. ");
INSERT INTO num_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ko Au pē ko te Mā 'oku Ma'ulí, 'a ia ne'e 'alu ifo mei te langí. Kāpau 'e kai he taha mei te mā ko 'ení 'e ma'uli pē ia 'o ta'engata. Pea ko te mā 'e Au 'avatú ko Toku kakanó, kote'uhí ke ma'uli ai 'ia māmani.” ");
INSERT INTO num_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ko ia ne'e fekīhiaki ai te ha'a Siú, 'o pehē, “'O lava fefe'aki te siana nei ke tuku mai Tono kakanó ke kai?” ");
INSERT INTO num_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ko ia ne'e me'a ange 'e Sīsū kiā nātou, “Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: kāpau kua kailoa kotou kai 'ia te kakano 'o te Fanautama te Tangatá, mo inu Tono ta'ata'á, 'oku kala kotou ma'u he ma'uli 'iā kōtou. ");
INSERT INTO num_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ko ia pē 'oku keina Toku kakanó, mo inu Toku totó, 'oku ma'u 'e ia 'ia te ma'uli ta'engatá, pea 'e Au fokotu'u ia 'i te 'aho fakamulí. ");
INSERT INTO num_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","He ko Toku kakanó ko he kai mo'oni ia, pea ko Toku totó ko he inu mo'oni. ");
INSERT INTO num_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ko ia 'oku keina Toku kakanó, mo inu Toku totó, 'oku nofo ma'u ia 'iā Au, mo Au 'iā ia. ");
INSERT INTO num_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Hangē ne fekau mai 'Oku 'e te Tamaí 'oku ma'ulí, mo Taku ma'uli 'A'aku kote'uhí ko te Tamaí, pehē foki, ko ia 'oku keina 'ia Aú, 'e ma'uli foki 'ia ia kote'uhí ko Au. ");
INSERT INTO num_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ko 'eni ia 'ia te Mā ne 'alu ifo mei te langí, tala'i'eaí 'oku hangē ko te kai 'a te kotou mātu'á, pea notou mate pē. Ko ia 'oku keina te Mā ko 'ení 'e ma'uli ia 'o ta'engata.” ");
INSERT INTO num_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ko te 'ū lea ko iá ne'e fai 'e Ia 'i Tana faiako 'i te falelotú 'i Kāpaneume. ");
INSERT INTO num_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Pea 'i te fanongo ki ai he tokolahi 'o Tana kau akó, ne'e notou pehē, “Ko te lea fefeka 'eni; ko ai 'e kātaki'i ke fanongo kiā Ia?” ");
INSERT INTO num_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Pea 'i te mea'i 'e Sīsū 'i Tono finangaló 'oku hanu Tana kau akó 'i te me'a ko iá, ne'e iange 'e Ia kiā nātou, “'Oku kotou tūkia 'i te me'a nei koā? ");
INSERT INTO num_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Huanoa kā kotou siofia 'ia te Fanautama te Tangatá 'oku 'alu ake ki te feitu'u ne 'i ai ki mu'á. ");
INSERT INTO num_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ko te Laumālié pē 'oku foaki ma'ulí; ko te me'a ki te kakanó 'oku kailoa mama'i 'aonga ia. Ko te 'ū lea kua U fai 'e Au kiā kōtoú, ko te koto laumālie ia, mo te koto ma'uli. ");
INSERT INTO num_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kā 'oku 'i ai he 'ihi 'iā kotou 'oku kailoa tui.” Hē ne toka mea'i 'e Sīsū mei te kamata'angá 'ia nātou 'oku kailoa tuí, pea mo ia 'e lavaki'i 'Oná. ");
INSERT INTO num_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Pea iange 'e Ia, “Ko tono 'uhinga ia ne Au lea ai kiā kōtou, 'o pehē, ‘'Oku kailoa lava he taha ke ha'u kiā Au, kā 'i tono foaki kiā ia mei te Tamaí.’ ” ");
INSERT INTO num_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Pea 'i te me'a ko iá ne foki ai he tokolahi 'o Tana kau akó, 'o kailoa notou kei ō fano mo Ia. ");
INSERT INTO num_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ko ia ne'e iange 'e Sīsū ki te kau hongofulu mā uá, “'E kailoa koā fia ō mo kōtou foki?” ");
INSERT INTO num_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Pea tali ki Ai 'e Saimone Pita, “'Aliki, ke motou ō kiā ai? 'Oku 'iā Koe 'ia te 'ū lea 'o te ma'uli ta'engatá. ");
INSERT INTO num_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Pea kua motou tui, 'o 'ilo'i pau, ko Koe ia 'ia te Toko Taha Tapu 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Pea tali ange 'e Sīsū kiā nātou, “Ne kala koā ke fili'i 'e Au 'ia kōtou, 'ia te kau hongofulu mā uá? Pea ko te kotou toko taha ko te tēvolo.” ");
INSERT INTO num_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ko Tana lea ko iá kiā Siutasi, ko te foha 'o Saimone 'Isikaliote, he ko ia ia 'e lavaki'i 'Oná, pea ko te toko taha 'o te kau hongofulu mā uá. ");
INSERT INTO num_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pea 'i te 'osi ange 'ení, ne'e fononga fano 'ia Sīsū 'i Kāleli. He ne'e kailoa loto Ia ke 'alu holo 'i Siutea, kote'uhí ne'e feinga 'e te ha'a Siú ke tāmate'i 'Ona. ");
INSERT INTO num_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pea ne'e ofi te kātoanga 'a te ha'a Siú, ko te Kātoanga 'o te Nofo Fale Lau'i'akau. ");
INSERT INTO num_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Pea lea ai kiā Ia 'e Tono kāingá, 'o pehē, “Ke Ke hiki mei heni, pea 'alu ki Siutea, kote'uhí ke mamata Tau kau akó foki ki Tau 'ū ngāue 'oku faí. ");
INSERT INTO num_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","He tala'i'eaí 'oku 'i ai he taha 'oku fai fufuu'i he me'a, kae 'osi angé, 'oku feinga ia ke ongoongoa. Kāpau leva 'oku fai 'e Koe 'ia te 'ū me'a ko iá, pe'i 'ai ke e'a 'ia Koe ki māmani.” ");
INSERT INTO num_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","He na'a mo Tono 'ū tokouá ne kala notou tui kiā Ia. ");
INSERT INTO num_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Pea lea ange 'e Sīsū kiā nātou, “Kua he'iki ai hoko To'okú taimi, kā ko ta'a kōtoú taimi 'oku hoko ma'u pē. ");
INSERT INTO num_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","'Oku kala lava 'e māmani ke fihi'a kiā kōtou; kā 'oku fihi'a ia kiā Au, kote'uhí ko Au pē 'Okou fakahā ki ai, 'oku kovi tana 'ū ngāué. ");
INSERT INTO num_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kotou ō ake kōtou ki te kātoangá; 'e kailoa U 'alu leva ki te kātoanga nei, kote'uhí kua he'iki ai kakato Toku taimí.” ");
INSERT INTO num_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Hili ange Tana lea pehē kiā nātoú, ne'e nofo pē Ia 'i Kāleli. ");
INSERT INTO num_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kae hili ange te 'alu Tono kāingá ki te kātoangá, pea toki 'alu ake mo Ia foki, kā ne kailoa fakae'a, kae fakafufū pē. ");
INSERT INTO num_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ko ia ne'e kumi kiā Ia 'e te ha'a Siú 'i te kātoangá, 'o notou pehē, “Ko fea 'ia te Siana ko iá?” ");
INSERT INTO num_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Pea lahi foki mo te fefanafanahi 'e te kakaí 'iā Ia. He ne'e pehē he 'ihi, “Ko te tangata lelei Ia;” kae pehē he 'ihi, “'Oku kailoa, kā 'oku takiala'i 'e Ia 'ia te kakaí.” ");
INSERT INTO num_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kae tala'i'eaí ne'e 'i ai he taha 'e lea fakahāhā 'iā Ia, ko te notou manahē ki te ha'a Siú. ");
INSERT INTO num_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pea kua 'osi mai tono vaeua 'o te kātoangá, pea me'a ake 'e Sīsū ki te Temipalé, 'o faiako 'i ai. ");
INSERT INTO num_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Pea ofo ai 'ia te ha'a Siú 'o notou pehē, “Ko te fu'u poto 'o te Siana neí ko te ma'u mei fea? He tala'i'eaí ne'e ako!” ");
INSERT INTO num_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Pea tali 'e Sīsū kiā nātou, “Ko Taku tokāteliné 'oku kailoa 'A'aku ia, kā 'oku 'A'ana 'a ē ne Ina fekau'i mai 'Okú. ");
INSERT INTO num_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kā 'i ai he taha 'oku fia fai 'ia te finangalo 'o te 'Atuá, 'e faifaí pea mahino kiā ia Taku tokāteliné, pe ko te me'a mei te 'Atuá ia, pe ko Au pē ia 'Okou lea 'iā Aú. ");
INSERT INTO num_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ko ia 'oku lea meiā ia peé, 'oku tuli pē ia ki to'oná ongoongo, kā ko Ia 'oku tuli ki te ongoongo 'o Ia ne'e fekau mai 'Oná, ko te Toko Taha Ia 'oku mo'oni, pea 'oku kailoa he ta'etotonu 'iā Ia. ");
INSERT INTO num_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ne'e kailoa koā 'avatu 'e Mōsese 'ia te Laó kiā kōtou? Kae tala'i'eaí 'oku tauhi te Laó he kotou toko taha. Ko te ā 'oku kotou feinga ai ke tāmate'i 'Okú?” ");
INSERT INTO num_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Pea tali ange 'e te kakaí, “'Oku 'iā Koe he tēvolo; he ko ai ia 'oku feinga ke tāmate'i 'Oú?” ");
INSERT INTO num_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Pea tali ange 'e Sīsū, “Ko te fe'i ngāue ē 'e taha ne Au fai, pea ne'e kotou ofo kotoa pē 'i ai. ");
INSERT INTO num_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ko tono 'uhinga ia ne'e tuku ai 'e Mōsese kiā kōtou te kamú (ka ne'e kailoa meiā Mōsese ia, kā ko te me'a mei te mātu'á 'i mu'a,) pea neongo ko te 'aho Sāpate, kā 'oku kotou kamu ai pē he tangata. ");
INSERT INTO num_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Pea kāpau leva 'e kamu he tangata 'i te 'aho Sāpaté, kote'uhí ke 'aua na'a maumau'i te Lao 'a Mōsesé, pea 'oku kotou 'ita mai koā kiā Au, kote'uhí ko Taku fakama'uli haohaoa he tangata 'i te 'aho Sāpaté? ");
INSERT INTO num_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","'Aua 'e kotou fakaanga 'o fai ki te me'a 'oku hā ki tu'á, kae kotou fakaanga ke totonu.” ");
INSERT INTO num_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Pea lea ai he 'ihi mei Selusalema, “'Oku kailoa nai ko 'eni Ia 'oku notou tuli ke tāmate'í? ");
INSERT INTO num_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pea vakai, 'oku lea fakahāhā Ia, pea 'oku kailoa notou mama'i fai he lau ki ai. Kua 'ilo'i mo'oni koā 'e te hau'alikí ko te Kalaisí tonu 'eni? ");
INSERT INTO num_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kā ko te Tangata nei, 'oku tou 'ilo'i lelei 'ia te feitu'u 'oku ha'u Ia mei aí, kae kā hoko mai 'ia te Kalaisí, 'e kailoa 'aupito 'ilo'i he taha, pē 'oku mei fea Ia.” ");
INSERT INTO num_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Pea toki kalanga 'e Sīsū 'i te Temipalé 'i Tana faiakó, 'o pehē, “'Oku kotou 'ilo'i 'ia Au, pea 'oku kotou 'ilo'i 'ia te feitu'u 'Okou ha'u mei aí; pea 'oku kailoa ke Kita ha'u 'iā Au pē, kā 'oku 'i ai he Toko Taha, ko te mo'oni 'eni, ne Ina fekau mai 'Oku, 'ia Ia 'oku kailoa kotou 'ilo'i 'e kōtou. ");
INSERT INTO num_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","'Okou 'ilo'i Ia 'e Au, hē ko Aú meiā Ia, pea ko Ia ia ne'e fekau mai 'Okú.” ");
INSERT INTO num_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ko ia ne'e notou feinga ke puke Ia, ka ne'e kailoa ala kiā Ia he taha, kote'uhí kua he'iki ai hoko Tono taimí. ");
INSERT INTO num_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pea ne'e tui pīkitai kiā Ia he tokolahi 'o te kakaí, 'o notou pehē, “Neongo 'e ha'u 'ia te Kalaisí, 'e lahi ange koā Ta'aná faka'ilonga mana 'i te fai 'a te Tangata nei?” ");
INSERT INTO num_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pea fanongo 'e te kau Fālesí ki te muhumuhu pehē 'a te kakaí 'o kau kiā Iá; pea fekau atu 'e te kau taula'aliki lahí mo te kau Fālesí he kau le'o Temipale ke puke Ia. ");
INSERT INTO num_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Pea folafola ai 'e Sīsū, 'o pehē, “'Oku toe si'i pē Taku 'iā kōtoú, pea U 'alu kiā Ia ne Ina fekau'i mai 'Okú. ");
INSERT INTO num_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","'E kotou kumi 'Oku, kā 'e kailoa kotou 'ilo'i; pea ko te feitu'u 'Okou 'i aí, 'e kailoa kotou lava ke a'u ki ai.” ");
INSERT INTO num_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ko ia ne'e fealealea'aki ai 'ia te ha'a Siú, “Ko Tana teu 'alú ki fea, 'a ē 'e kailoa motou 'ilo'i ai Iá? Hē 'oku teu 'alu koā Ia ki muli, ki te feitu'u 'oku nofo ai te tou kakaí, mo ako'i te kakai Kalisí? ");
INSERT INTO num_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ko te ā te 'uhinga 'o Tana lea ne'e pehē, ‘'E kotou kumi 'Oku, kā 'e kailoa kotou 'ilo'i,’ pea ‘Ko te feitu'u 'Okou 'i aí, 'e kailoa lava ke kotou a'u ki ai’?” ");
INSERT INTO num_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","'I te 'aho faka'osí, 'a ia ko te 'aho lahí ia 'o te kātoangá, ne'e tu'u 'ia Sīsū 'o kalanga, 'o pehē, “Kā 'i ai he taha 'oku fiainua, ke ha'u kiā Au 'o inu. ");
INSERT INTO num_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ko ia 'oku tui pīkitai kiā Aú, pea hangē ko te lau 'a te Tohitapú, 'e tafe atu mei tono manavá he 'ū vaitafe 'o te vai ma'ulí.” ");
INSERT INTO num_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Kā ne kau Tana lea ko iá ki te Laumālié, 'a ia kā ma'u 'e nātou ne tui pīkitai kiā Iá. He kua he'iki ai 'ia te Laumālié, kote'uhí kua he'iki ai fakalāngilangi'i 'ia Sīsū.) ");
INSERT INTO num_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Pea ko te kakai 'ihi, 'i te notou fanongo ki te 'ū lea ko iá, ne'e notou pehē, “Tā ko te mo'oni, ko 'eni ia 'ia te Palōfitá.” ");
INSERT INTO num_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Pea pehē 'e te 'ihi, “Ko te Kalaisí 'eni.” Ka ne'e pehē 'e te 'ihi, “Hē 'oku ha'u koā 'ia te Kalaisí mei Kāleli? ");
INSERT INTO num_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ne'e kailoa koā lau 'e te Tohitapú 'o pehē: 'E tupu 'ia te Kalaisí mei te hako 'o Tēvitá, pea 'e ha'u Ia mei Pētelihema, ko te ki'i kolo ne'e 'i ai 'ia Tēvitá?” ");
INSERT INTO num_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Pea ne'e hoko he māvahevahe 'i te kakaí kote'uhí ko Ia. ");
INSERT INTO num_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Pea loto he 'ihi 'iā nātou ke puke'i 'Ona, ka ne'e kala he notou taha 'e ala kiā Ia. ");
INSERT INTO num_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Pea ōmai ai te kau le'o Temipalé ki te kau taula'aliki lahí mo te Fālesí; pea me'a kiā nātou 'e te kau taula'aliki ko iá, “Ko te ā kua kailoa kotou taki mai ai Iá?” ");
INSERT INTO num_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Pea tali ange te kau le'o Temipalé, “'Ē, kua he'iki ai 'aupito he taha 'e lea 'o hangē ko te Tangata nei!” ");
INSERT INTO num_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pea tali ange 'e te kau Fālesí kiā nātou, “Kua takihee'i mo kōtou foki? ");
INSERT INTO num_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","He kua 'i ai he taha 'o te hau'alikí kua tui kiā Ia, pe he taha 'o te kau Fālesí? ");
INSERT INTO num_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kā ko te kakai nā ta'e'ilo ki te Laó, ko te koto mala'ia 'ia nātou.” ");
INSERT INTO num_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pea iange 'e Nikotīmasi kiā nātou, ('a ia ne'e ha'u kiā Ia 'i mu'á, ko te toko taha foki ia 'iā nātou,) ");
INSERT INTO num_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“He ko te anga ia te tou laó ke fakamāu'i he tangata, he'iki ai ke tou fanongo ki hana fakamatala, pe mahino 'ia te me'a kua fai 'e iá?” ");
INSERT INTO num_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Pea notou iange leva kiā ia, “He ko te Kāleli foki mo koe? Hakule mu'a 'o 'ilo'i, 'oku kailoa he palōfita 'e tupu mei Kāleli.”  ");
INSERT INTO num_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pea notou ō taki taha ki tono 'api. ");
INSERT INTO num_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ka ne'e 'alu 'ia Sīsū ia ki te ma'unga ko 'Ōlivé. ");
INSERT INTO num_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pea toe uhu Ia ki te Temipalé, pea ne'e ha'u kiā Ia 'ia te kakaí kotoa pē; pea nofo ifo Ia 'o faiako kiā nātou. ");
INSERT INTO num_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Pea taki mai 'e te kau sikalaipé mo te kau Fālesí he fafine, ne'e ma'ua 'i te tono tangata, pea notou fokotu'u 'ona 'i te ha'oha'ongá. ");
INSERT INTO num_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Pea notou pehē kiā Ia, “Tangata'aliki, ne'e ma'u atu te fafine nei lolotonga tana tono tangata. ");
INSERT INTO num_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Pea ko Mōsese ne ina tu'utu'uni 'i te Laó, ke tolomaka'i te fa'ahinga peheé, kā ko te ā Ta'aú lau ki ai?” ");
INSERT INTO num_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ne'e notou lea peheé, ko te notou 'ahi'ahi'i 'Ona, kote'uhí ke notou talatalaaki'i ai Ia. Ka ne'e punou ifo 'e Sīsū ia, 'o kamata tohitohi 'i te kelekelé 'aki Tono tuhú. ");
INSERT INTO num_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pea 'i te hokohoko atu te notou fehu'í, ne Ina mālanga ake, 'o folafola ange kiā nātou, “Ko ia 'iā kōtou 'oku 'ata'atā mei te angahalá, ke 'a'ana te fu'aki tolo ki te fafiné.” ");
INSERT INTO num_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Pea toe punou Ia, 'o tohi 'i te kelekelé. ");
INSERT INTO num_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pea ko nātou ne'e fanongo ki aí, ne'e notou hū tahataha ki tu'a, 'o kamata mei te mātu'á. Pea ne'e toe pē 'ia Sīsū toko taha, pea mo te fafiné ne'e kei tu'u 'i te ha'oha'ongá. ");
INSERT INTO num_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Pea mālanga ake 'ia Sīsū, 'o iange ki te fafiné, “Ko fea 'ia nātou? Kua kailoa koā he taha 'e fakamāu'i 'ou?” ");
INSERT INTO num_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Pea iange te fafiné, “'E 'Aliki, 'oku kailoa he taha.” Pea me'a ange Ia, “Pea 'e kailoa ke fakamāu'i 'ou ia 'e Au. 'Alu ā, pea 'aua na'a ke toe fai angahala.” ");
INSERT INTO num_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Pea toe folafola 'e Sīsū kiā nātou, 'o pehē, “Ko Au pē ko te Maama 'o māmani; ko ia 'oku mulimuli mai kiā Aú, 'e kailoa 'aupito fononga ia 'i te pō'ulí, kā 'e ina ma'u 'ia te maama 'o te ma'ulí.” ");
INSERT INTO num_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ko ia ne'e lea ai 'ia te kau Fālesí kiā Ia, “'Oku fakamo'oni pē Koe kiā Koe; tā ko Tau fakamo'oní 'oku kailoa mo'oni.” ");
INSERT INTO num_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Pea me'a 'e Sīsū kiā nātou, “Neongo 'Okou fakamo'oni kiā Au 'e Au, kā 'oku mo'oni pē Ta'akú fakamo'oni, kote'uhí 'Okou 'ilo'i te feitu'u ne Au ha'u mei aí, mo te feitu'u 'Okou 'alu ki aí. Kā ko kōtou, 'oku kailoa kotou 'ilo'i pe ko Taku ha'ú mei fea, pe 'alú ki fea. ");
INSERT INTO num_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","'Oku fakaemāmani pē te kotou fakamaaú, kā ko Aú 'oku kala U fakamāu'i he taha. ");
INSERT INTO num_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pea kāpau 'e Au fakamaau, 'oku totonu pē Ta'akú fakamaau; kote'uhí 'oku kailoa ke Au toko taha, kā 'oku mā toko ua mo te Tamaí ne Ina fekau'i mai 'Okú. ");
INSERT INTO num_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Pea kua tohi foki 'i te kotou laó, ko te fakamo'oni 'a te ongo tangatá, 'oku mo'oni. ");
INSERT INTO num_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ko Au 'ia te Toko Taha 'oku fakamo'oni pē kiā Aú, pea ko te Tamaí, 'ā ē ne'e fekau'i mai 'Okú, 'oku fakamo'oni Ia kiā Au.” ");
INSERT INTO num_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Pea notou iange kiā Ia, “He ko fea ia Tau Tamaí?” Pea tali ange 'e Sīsū, “'Oku kala kotou 'ilo'i 'ia Au, pē ko Taku Tamaí. Ka ne kua kotou 'ilo'i 'ia Au, pehē ne kotou 'ilo'i mo Taku Tamaí foki.” ");
INSERT INTO num_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ko te 'ū lea ko iá ne'e fai 'e Sīsū 'i te feitu'u 'o te tuku'anga koloá, 'i Tana faiako 'i te Temipalé. Pea ne'e kailoa puke Ia he taha, kote'uhí kua he'iki ai hoko mai Tono taimí. ");
INSERT INTO num_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Pea toe me'a Ia kiā nātou, “'Okou 'alu Au, pea 'e kotou kumi kiā Au, pea 'e kotou mate 'i te kotou angahalá. Ko te feitu'u 'Okou 'alu ki aí, 'e kala lava kōtou ia ke a'u ki ai.” ");
INSERT INTO num_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Pea pehē leva 'e te kakai Siú, “He 'e tāmate'i koā Ia 'Ona, kote'uhí ko Tana pehē, ‘Ko te feitu'u 'Okou 'alu ki aí, 'e kailoa lava kōtou ia ke a'u ki ai’?” ");
INSERT INTO num_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Pea iange Ia kiā nātou, “Ko kōtoú 'oku kotou mei lalo nei; ko Aú 'Okou mei lunga nā. Ko kōtoú 'oku 'o te maama ko 'ení; ko Au 'oku kailoa 'o te maama ko 'ení. ");
INSERT INTO num_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ko te 'uhinga ia ne Au pehē ai kiā kōtou, ‘'E kotou mate 'i te kotou angahalá,’ he kāpau 'e kailoa kotou tui ko Au Ia, 'e kotou mate 'i te kotou angahalá.” ");
INSERT INTO num_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Pea notou pehē ange kiā Ia, “Ko ai tū 'ia Koe?” Pea folafola 'e Sīsū kiā nātou, “'Ē, 'a ia pē ne Au tala'i atu mei te kamata'angá. ");
INSERT INTO num_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","'Oku lahi pē Taku me'a ke lea ki aí, mo Taku fakaanga ke fai 'iā kōtoú, kā neongo iá, kā 'oku mo'oni pē Ia ne'e fekau mai 'Okú; pea ko te 'ū me'a kua U fanongo meiā Iá, 'Okou tala ia ki māmani.” ");
INSERT INTO num_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ne'e kailoa mahino kiā nātou, ko Tana lea kiā nātoú 'i te Tamaí. ");
INSERT INTO num_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ko ia ne'e folafola 'ia Sīsū, “Hili ange te kotou hiki ki lunga 'ia te Fanautama te Tangatá, 'e toki mahino kiā kōtou, ko Au Ia, mo te kailoa ke Au mama'i fai he me'a 'iā Au peé; kae hangē tofu pē ko Tono ako'i 'Oku 'e te Tamaí, 'oku pehē pē Taku lea ki te 'ū me'a nei. ");
INSERT INTO num_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Pea ko Ia ne'e fekau'i mai 'Okú 'oku 'iā Au Ia. Ne'e kailoa Ina tukuange 'Oku ke tuenoa; kote'uhí 'Okou fai ma'u pē 'ia te 'ū me'a 'oku hōhō'ina Ia 'i aí.” ");
INSERT INTO num_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Pea 'i Tana lea peheé, ne'e tui te tokolahi kiā Ia. ");
INSERT INTO num_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Pea pehē ange 'e Sīsū ki te kau Siu kua tui kiā Iá, “Kāpau 'e kotou nofo ma'u 'i Taku akonakí, ko Taku kau ako mo'oni 'ia kōtou; ");
INSERT INTO num_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","pea 'e toki mahino kiā kōtou 'ia te mo'oní, pea 'e fakatau'atāina'i kōtou 'e te mo'oní.” ");
INSERT INTO num_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Pea notou iange kiā Ia, “Ko te hako 'o 'Ēpalahame 'ia mātou, pea ne'e kailoa motou pōpula mātou ia ki he taha. Pea fefe'aki ai Tau lau nā, 'o pehē, ‘'E faifaí pea kotou tau'atāina’?” ");
INSERT INTO num_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Pea iange 'e Sīsū kiā nātou, “Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu kiā kōtou: ko ia 'oku fai angahalá, ko te pōpula ia ki te angahala. ");
INSERT INTO num_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Pea ko te pōpulá 'oku kailoa ina nofo ma'u 'i te falé 'o ta'engata; ko te 'Aló pē 'oku nofo ma'u 'o ta'engatá. ");
INSERT INTO num_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ko ia kāpau 'e fakatau'atāina'i kōtou 'e te 'Aló, 'e kotou toki tau'atāina mo'oni. ");
INSERT INTO num_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","'Okou 'ilo'i pē ko te hako 'o 'Ēpalahame 'ia kōtou, kā 'oku kotou feinga kōtou ia ke tāmate'i 'Oku, kote'uhí 'oku kailoa kotou fia tali Taku akonakí. ");
INSERT INTO num_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","'Okou tala'i atu 'ia te 'ū me'a kua U mamata ki ai 'i Taku Tamaí; pea 'oku kotou fai 'e kōtou 'ia te 'ū me'a ne'e kotou fanongo ai mei te kotou tamaí.” ");
INSERT INTO num_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Pea notou tali leva 'o iange kiā Ia, “Ko te motou tamaí 'ia 'Ēpalahame.” Pea iange 'e Sīsū kiā nātou, “Ka ne ko te fānau 'a 'Ēpalahame 'ia kōtou, 'e kotou fai te 'ū ngāue 'a 'Ēpalahamé. ");
INSERT INTO num_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kā ko 'eni, 'oku kotou feinga ke tāmate'i 'Oku, 'ia Au ko te Tangata kua U tala kiā kōtou 'ia te mo'oní, 'a ē ne Au fanongo ki ai mei te 'Atuá. Ne'e kailoa fai 'e 'Ēpalahame ia he me'a pehē. ");
INSERT INTO num_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kā ko kōtoú 'oku kotou fai 'ia te 'ū ngāue 'a te kotou tamaí.” Pea notou iange kiā Ia, “Kua kailoa motou tupu fe'auaki mātou; 'oku taha pē te motou tamaí, ko te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Pea folafola ange 'e Sīsū kiā nātou, “Ka ne ko te kotou tamaí 'ia te 'Atuá, pehē 'e kotou 'ofa kiā Au, he ne Au ha'ú mei te 'Atuá; pea ne'e kailoa ke Au ha'u 'iā Au pē, ka ne'e fekau mai 'Oku 'e Tana 'Afió. ");
INSERT INTO num_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ko te ā koā 'oku kailoa kotou 'ilo'i ai Taku leá? Kote'uhí pē 'oku kailoa kotou fia fanongo ki Taku akonakí. ");
INSERT INTO num_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ko te tamai kua kotou tupu mei aí ko te tēvoló, pea ko te 'ū manako 'a te kotou tamaí 'oku kotou loto ke faí. Ko te tāmate tangata ia mei te kamata'angá, pea ne'e kailoa nofo ma'u ia ki te mo'oní, kote'uhí 'oku kailoa he mo'oni 'iā ia. Kā lea lohi ia, 'oku lea 'aki ia tana me'a pē 'a'aná: he ko te toko taha lohi ia, pea ko te tamai ia 'a te lohi fuli pē. ");
INSERT INTO num_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pea kote'uhí 'Okou tala'i atu 'ia te mo'oní kiā kōtou, 'oku kailoa kotou tui kōtou kiā Au. ");
INSERT INTO num_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ko ai 'iā kōtou 'oku fakamo'oni'i Haku angahala? Pea kāpau 'Okou lea 'aki 'ia te mo'oní, ko te ā 'oku kala kotou fia tui mai ai kiā Aú? ");
INSERT INTO num_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ko ia 'oku mei te 'Atuá, 'oku ina tali 'ia te 'ū Folafola 'a te 'Atuá. Ko tono 'uhinga ē 'oku kailoa kotou fia tali aí, kote'uhí 'oku kala 'o te 'Atuá 'ia kōtou.” ");
INSERT INTO num_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Pea tali 'e te ha'a Siú kiā Ia, “Tono kala koā mo'oni 'ia te lea 'oku motou fai atú, 'o pehē, ko te Samēlia 'ia Koe, mo te 'iā Koe he tēvolo?” ");
INSERT INTO num_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Pea tali ange leva 'e Sīsū, “'Oku kala he tēvolo 'iā Au; kaikehe, 'Okou faka'apa'apa'ina Taku Tamaí, pea ko kōtou pē 'oku kotou fakalialia'i 'Okú. ");
INSERT INTO num_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Pea 'oku kailoa ke Au feinga'i te ongoongo 'O'okú pē; 'oku 'i ai he Toko Taha 'oku feinga'i ia, pea 'oku fakamāu'i 'e Ia 'ia te me'á. ");
INSERT INTO num_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: kāpau kua tauhi Taku leá he taha, 'e kailoa 'aupito ina mamata ki te maté 'o ta'engata.” ");
INSERT INTO num_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Pea lea ai kiā Ia 'e te ha'a Siú, “'Āua, kua motou 'ilo'i 'eni 'oku 'iā Koe he tēvolo. Ko 'Ēpalahamé ne'e pekia ia, pea mo te kau palōfitá; kā ko 'eni kua Ke pehē 'e Koe, ‘Kāpau kua tauhi Taku leá he taha, 'e kailoa 'aupito mama'i lave ia ki te maté, 'o ta'engata.’ ");
INSERT INTO num_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Hē 'oku lahi koā 'ia Koe ia 'i te tou tamai ko 'Ēpalahamé? Kā kua pekia ia, pea kua pekia mo te kau palōfitá. 'I te lau 'A'aú, ko ai 'ia Koe?” ");
INSERT INTO num_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Pea tali 'e Sīsū, “Kāpau 'e fakahīkihiki'i 'Oku 'e Au, ko te launoa To'okú ongoongo; ko Taku Tamaí ia 'oku fakahīkihiki'i 'Okú, 'a ē 'oku kotou pehē, ko te kotou 'Atuá Iá. ");
INSERT INTO num_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kae tala'i'eaí kua kotou 'ilo'i 'Ona, kā ko Aú 'Okou lāu'ilo'i 'Ona. Pea kāpau 'e Au pehē 'oku kailoa ke Au 'ilo'i 'Ona, tā 'e Au tatau mo kōtou, ko te lohi, kā 'Okou lāu'ilo'i pē 'Ona, pea 'Okou tauhi Tana Folafolá. ");
INSERT INTO num_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ko 'Ēpalahame, 'ia te kotou tamaí, ne'e fiafia ia 'i tana 'ilo'i 'e mamata ki Toku 'ahó; pea ne'e mamata ia ki ai, 'o fiafia.” ");
INSERT INTO num_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Pea iange 'e te kau Siú kiā Ia, “'Ē, kua he'iki ai ke Ke nimangofulu ta'u, pea kua Ke mamata koā kiā 'Ēpalahame?” ");
INSERT INTO num_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Pea folafola 'e Sīsū kiā nātou, “Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: 'i te he'iki ai fanau'i 'ia 'Ēpalahamé, 'Okou 'i ai.” ");
INSERT INTO num_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Pea notou to'o maka leva ke tolongi 'aki Ia, kā ne fufuu'i pē 'e Sīsū Ia, 'o moulu atu mei te Temipalé 'i te notou lotolotongá. ");
INSERT INTO num_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Pea 'i Tana 'alu angé, ne'e 'ilo'i atu Ia he tangata ne'e kui, talu pē mei tono fanau'í. ");
INSERT INTO num_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Pea fehu'i kiā Ia 'e Tana kau akó, “Lāpai, ko ai ne angahalá, 'ia te siana nei, pe ko tana mātu'á, 'o tupu ai tono fanau'i kuí?” ");
INSERT INTO num_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Pea iange 'e Sīsū, “Ne'e kailoa ko te angahala 'a te siana nei, pe ko Tana mātu'á, kā kote'uhí ke fakae'a 'iā ia 'ia te 'ū ngāue 'a te 'Atuá. ");
INSERT INTO num_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kua pau ke tou fai te ngāue 'A'ana ne'e fekau mai 'Okú 'i te lolotonga 'oku 'ahó; 'oku 'unu mai 'ia te poó, 'a ia 'e kailoa lava ai he taha ke toe ngāue. ");
INSERT INTO num_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kāpau kua U 'i māmani, ko te maama 'o māmaní 'ia Au.” ");
INSERT INTO num_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pea 'i Tana lea peheé, ne'e 'a'anu 'e Ia ki te kelekelé, 'o ngaahi 'aki te fāvaí he me'i pelapela, 'o pani 'aki te ongo fe'i matá, ");
INSERT INTO num_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","mo folafola ange kiā ia, “'Alu pē 'o fufulu 'i te anovai ko Sailoamé.” ('A ia ko tono hikí, “Ko te fekau'i.”) Ko ia ne'e 'alu atu ia 'o fufulu, 'o foki mai kua 'ala. ");
INSERT INTO num_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ko ia ko tono kaungā'apí, pea mo te kakai ne fa'a mamata mu'a kiā ia, ko te toko taha ne'e ma'uli kole peé, ne'e notou pehē, “'Oku kala nai ko te siana 'eni ne'e fa'a nofo hē, 'o kolekolé?” ");
INSERT INTO num_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Pea pehē he 'ihi, “Ko 'eni ia,” kae pehē he 'ihi, “'Oku kailoa, kā 'oku mata tatau pē mo ia.” Ka ne'e pehē ange 'e ia, “Ko au ia.” ");
INSERT INTO num_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Pea notou 'eke ange, “Ne'e faka'a'ala fefe'aki tou matá?” ");
INSERT INTO num_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Pea tali ange 'e ia, “Ko te tangata 'oku ui ko Sīsuú, ne Ina ngaahi he pelapela, 'o pani 'aki toku ongo fe'i mata nei, mo fekau mai 'e Ia: ‘'Alu ki Sailoame 'o fufulu.’ Ko ia ne au 'alu leva 'o fufulu, pea ko 'eni kua u 'ala.” ");
INSERT INTO num_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Pea notou 'eke ange, “Ko fea 'ia te tangata ko iá?” Pea iange 'e ia, “'Oku kala u 'ilo'i.” ");
INSERT INTO num_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pea notou taki atu 'ona, 'ā ē ne'e kuí, ki te kau Fālesí. ");
INSERT INTO num_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Pea tā ko te 'aho Sāpate ne'e ngaahi ai 'e Sīsū 'ia te pelapelá, 'o faka'ala 'aki tono matá. ");
INSERT INTO num_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ko ia ne'e toe fehu'i kiā ia 'e te kau Fālesí, pē ne fefe'aki tana 'ala aké. Pea iange 'e ia kiā nātou, “Ne 'ai 'e Ia he pelapela ki toku poko'i mata nei, pea u fufulu, pea u 'ala.” ");
INSERT INTO num_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pea lea ai he 'ihi 'o te kau Fālesí, 'o pehē, “'Oku kala ko he tangata 'eni Ia mei te 'Atuá, he 'oku kailoa tauhi 'e Ia 'ia te 'aho Sāpaté.” Kā ne pehē he 'ihi, “'O lava fefe'aki he tangata 'oku angahalá ke fai he faka'ilonga mana pehē?” Pea ne'e hoko ai he fakakikihi 'iā nātou. ");
INSERT INTO num_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Pea notou toe fehu'i ange ki te matu'a ne'e kuí, “Ko te ā hau lau ia 'a'au ki te tangata nā, 'i Tana faka'ala tou matá?” Pea iange 'e ia, “Ko he palōfita Ia.” ");
INSERT INTO num_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ka ne'e kailoa tui te kakai Siú ne'e kui 'ia te tangatá, pea toe 'ala, kae'aua leva ke notou ui ange tana ongo mātu'á. ");
INSERT INTO num_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Pea notou 'eke ange kiā nāua, “Ko 'eni koā te kulā tamasi'í, 'a ē 'oku kulā pehē ne'e fanau'i kuí? Pea 'oku fefe'aki ai tana 'ala nei?” ");
INSERT INTO num_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Pea tali ange tana ongo mātu'á 'o pehē, “'Oku mā 'ilo'i lelei ko te mā 'uhikí 'eni, pea ne'e fanau'i kui ia; ");
INSERT INTO num_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","kā 'oku kailoa mā lave'i pē ko tana 'ala neí 'i te ā; pea 'oku kailoa mā lave'i 'e māua pē ko ai ne'e faka'ala'i tono matá. Kotou 'eke pē kiā ia; he kua fatu tangata, pea 'e lea atu pē ia ma'ana.” ");
INSERT INTO num_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ne'e pehē te lea tana ongo mātu'á he ne'e nā manahē ki te kau Siú; he kua 'osi tu'utu'uni 'e nātou, kā 'ilonga he taha 'e fakamo'oni ko te Kalaisí 'ia Sīsū, 'e kapusi 'ona mei te falelotú. ");
INSERT INTO num_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ko tono 'uhinga ia 'o te pehē ange tana ongo mātu'á, “Kua fatu tangata ia; kotou 'eke pē kiā ia.” ");
INSERT INTO num_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ko ia ne'e notou toe ui ange te tangata ne'e kuí, 'o notou pehē ange, “Ke ke 'a'apa ki te 'Atuá. 'Oku motou 'ilo'i 'e mātou ko te Tangata nei ko te angahala.” ");
INSERT INTO num_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Pea tali ange te sianá, “Ko te me'a ki Ha'aná angahala, 'oku kala u 'ilo'i. Ko te me'a pē taha 'okou 'ilo'í, ne'e kui 'ia au, kā ko 'eni 'okou 'a'ala!” ");
INSERT INTO num_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Pea notou toe 'eke kiā ia, “Ko te ā te me'a ne'e fai atu 'e Ia kiā koé? Ne fefe'aki Tana faka'ala'i tou matá?” ");
INSERT INTO num_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Pea tali ange 'e ia kiā nātou, “Kua 'osi taku tala kiā kōtou, pea 'oku kailoa kotou tokanga. Ko te ā 'oku kotou toe fia fanongo ai ki aí? Na'a 'oku fia ului mo kōtou ki Tana kau akó foki?” ");
INSERT INTO num_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pea notou ngaahi'i 'ona, 'o notou iange, “Ko koe pē ko te ākonga 'a te Siana nā, kā ko te kau ako mātou ia 'a Mōsese. ");
INSERT INTO num_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","'Oku motou 'ilo'i ne'e folafola 'e te 'Atuá kiā Mōsese, kā ko te Siana ko 'ená, 'oku kala motou 'ilo'i pe 'oku mei fea Ia.” ");
INSERT INTO num_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Pea toki tali 'e te tangatá, 'o iange kiā nātou “Tā ko te toki me'a faikehe ia, 'i te kailoa 'ilo'i 'e kōtou pē 'oku mei fea Iá; 'osi, ko 'eni kua faka'ala'i 'e Ia toku poko'i mata nei! ");
INSERT INTO num_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","'Oku tou 'ilo'i lelei pē, ko te 'Atuá 'oku kailoa Ina ongo'i 'ia te kau angahalá, kae kā lotu he tangata ki te 'Atuá, mo fai Tono finangaló, 'oku ongo'i 'e Ia he toko taha pehē. ");
INSERT INTO num_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Talu mei te kamata'anga 'o māmaní kua he'iki ai he talanoa 'o pehē, kua faka'ala'i he taha 'ia te mata 'o he toko taha ne'e fanau'i kui. ");
INSERT INTO num_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kāpau ne'e kailoa mei te 'Atuá 'ia te Toko Taha nei, 'e kailoa 'aupito Ina lava he me'a 'e taha.” ");
INSERT INTO num_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Pea notou tali ange kiā ia, “Ko koé ne'e fanau'i ko te angahala, pea ko tau hanga mai ē ke ako'i 'ia mātou?” Pea notou kapusi 'ona ki tua'ā. ");
INSERT INTO num_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Pea kua fanongo 'e Sīsū kua notou kapusi 'ona ki tua'ā, pea 'i Tana fetaulaki mo iá, ne'e iange 'e Ia, “'Oku ke tui ki te Fanautama te Tangatá?” ");
INSERT INTO num_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Pea tali ange te sianá, “'Aliki, ko ai Ia, ke au tui kiā Ia?” ");
INSERT INTO num_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Pea folafola ange 'e Sīsū, “'Ē, kua ke mamata kiā Ia, pea ko Ia ia 'oku talanoa mo koé.” ");
INSERT INTO num_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Pea iange leva 'e ia, “'Aliki, 'okou tui.” Pea punou leva ia kiā Sīsū. ");
INSERT INTO num_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Pea folafola ange 'e Sīsū, “Ko Ta'akú ha'u ki māmani ke fai fakamaau, kote'uhí ko nātou 'oku kailoa 'alá ke notou 'a'ala; pea ko nātou 'oku 'a'alá, ke notou kui.” ");
INSERT INTO num_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pea ne'e fanongo ki te lea ko iá 'e nātou 'o te kau Fālesí ne'e 'iā Iá, 'o notou iange kiā Ia, “'Oku kui 'apē mo mātou foki?” ");
INSERT INTO num_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Pea folafola ange 'e Sīsū kiā nātou, “Kāpau ne'e kotou kui, pehē, 'oku kailoa he kotou angahala, kā ko 'eni 'oku kotou pehē: ‘'Oku motou 'a'ala,’ pea tā 'oku nofo ma'u te kotou angahalá. ");
INSERT INTO num_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: ko ia 'oku kailoa hū 'i te matapā ki te loto'ā sipí, kae kaka ake 'i te ala kehe, ko te kaiha'a ia mo te fakamālohi. ");
INSERT INTO num_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kā ko ia 'oku hū 'i te matapaá ko te tauhi ia 'o te fanga sipí. ");
INSERT INTO num_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","'Oku to'o 'e te le'o matapaá kiā ia; pea 'oku fānonongo 'e te fanga sipí ki tono le'ó. Pea 'oku ina ui te fanga sipi 'a'aná 'i te notou hingoa taki taha, 'o taki atu nātou ki tua'ā. ");
INSERT INTO num_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Pea kā 'osi leva tana tuku ki tua'ā tana fanga sipí, 'oku 'alu mu'amu'a ia 'iā nātou, pea mulimuli te fanga sipí kiā ia, he 'oku notou 'ilo'i tono le'ó. ");
INSERT INTO num_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kā 'e kailoa 'aupito notou mulimuli he taha kehe, kā 'e notou hola meiā ia, he 'oku kala notou 'ilo'i te le'o 'o te kehé.” ");
INSERT INTO num_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ne'e lea 'aki 'e Sīsū te fakatātā nei kiā nātou, ka ne'e kailoa 'aupito he notou 'ilo pe ko te ā tono 'uhingá. ");
INSERT INTO num_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Pea toe folafola ai 'e Sīsū kiā nātou, “Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: ko Aú ko te matapā 'o te fanga sipí. ");
INSERT INTO num_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ko nātou kotoa pē ne'e ha'u mu'amu'a 'iā Aú, ko te kau kaiha'a mo te fakamālohi, ka ne'e kailoa tokanga kiā nātou 'e te fanga sipí. ");
INSERT INTO num_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ko Au pē ko te matapā; kā ulu he taha 'iā Au, 'e fakama'uli ia, pea 'e ulu atu ia, pea ulu mai, 'o ma'u me'akai. ");
INSERT INTO num_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","'Oku kala ha'u te kaiha'á ia ko he me'a, kā ke kaiha'asi pē, mo tāmate'i, mo faka'auha. Kā 'Okou ha'u 'ia Aú ke notou ma'u te ma'ulí, pea ke notou ma'u ia 'o lahi 'aupito. ");
INSERT INTO num_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ko Au ko te Tauhi Sipi Lelei. Ko te anga 'o te tauhi sipi leleí ke 'avatu Tana ma'ulí kote'uhí ko te fanga sipí. ");
INSERT INTO num_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kā ko ia 'oku ngāue totongi peé, pea 'oku kailoa ko he tauhi sipí, mo kailoa 'a'ana totonu 'ia te fanga sipí, kā sio ia ko te ulofi 'ena 'oku ha'ú, pea si'aki leva 'e ia 'ia te fanga sipí, 'o hola; pea 'oku pō nātou 'e te ulofí, 'o fakamavetevete'i. ");
INSERT INTO num_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","'Oku hola te toko taha ko iá kote'uhí he ko te ngāue totongi pē, pea 'oku kailoa mamafa kiā ia 'ia te fanga sipí. ");
INSERT INTO num_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ko Au ko te Tauhi Sipi Lelei, pea 'Okou 'ilo'i 'ia te 'ū me'a 'A'atá, pea 'oku 'ilo'i Kita 'e te 'ū me'a 'A'atá, ");
INSERT INTO num_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","'o hangē 'oku 'ilo'i 'Oku 'e te Tamaí, pea mo Taku 'ilo'i te Tamaí 'e Aú. Pea 'Okou 'avatu Taku ma'ulí kote'uhí ko te fanga sipí. ");
INSERT INTO num_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Pea 'oku 'i ai mo Taku fanga sipi kehe, 'a ia 'oku kailoa kau ki te loto'ā ko 'ení. Kua pau ke Au taki 'ia te fa'ahinga ko iá foki, pea 'e notou tokanga ki Toku le'ó, pea 'e notou hoko ko te tākanga pē taha, mo te tauhi pē taha. ");
INSERT INTO num_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ko ia 'oku 'ofa'i ai 'Oku 'e te Tamaí, kote'uhí 'Okou 'avatu Taku ma'ulí kae Au toe to'o mai ia. ");
INSERT INTO num_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","'Oku kala to'o ia he taha meiā Au, kā ko Taku 'avatu pē ia 'e Au. 'Okou fa'italiha ki tono 'avatú, pea 'Okou fa'italiha ki tono toe to'ó. Ko te fekau 'eni ne Au ma'u mei Taku Tamaí.” ");
INSERT INTO num_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Pea ne'e toe hoko he māvahevahe 'i te kakai Siú, ko te me'a 'i te 'ū lea ko iá ");
INSERT INTO num_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Pea pehē 'e te notou tokolahi, “'Oku 'iā Ia he tēvolo, pea 'oku vale Ia; ko te ā 'oku kotou tokanga ai kiā Iá?” ");
INSERT INTO num_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ka ne'e pehē he 'ihi, “'Oku kala ko te lea 'eni he taha 'oku 'iā ia he tēvolo. 'E mafai koā he tēvolo ke faka'ala'i te mata 'o te kuí?” ");
INSERT INTO num_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pea ne'e fai 'i Selusalema 'ia te kātoanga, ko te fakamanatu 'o tono huufi fo'ou 'o te Temipalé, pea ko te fa'ahita'u momoko ia. ");
INSERT INTO num_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Pea ne'e hā'ele atu 'ia Sīsū 'i te Temipalé 'i te Fakafaletolo 'o Solomoné. ");
INSERT INTO num_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Pea ne'e ōmai te kakai Siú 'o kāpui 'Ona, 'o notou pehē kiā Ia, “Kua fualoa mo te kailoa Ke faka'ilo 'Ou kiā mātou! Kāpau ko te Kalaisí 'ia Koe, pe'i tala'i hangatonu mai.” ");
INSERT INTO num_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Pea tali ange 'e Sīsū kiā nātou, “Ne Au 'osi tala'i atu, ka ne'e kailoa kotou tui. Ko te 'ū ngāue 'Okou fai 'i te huafa 'o Taku Tamaí, ko ia 'oku fakahaa'i 'Okú. ");
INSERT INTO num_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kā 'oku kala pē kotou tui, kote'uhí 'oku kala ko Taku fanga sipi 'ia kōtou. ");
INSERT INTO num_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ko Ta'akú fanga sipi 'oku notou tokanga ki Toku le'ó, pea 'Okou 'ilo'i 'ia nātou; pea 'oku notou mulimuli kiā Au, ");
INSERT INTO num_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","pea 'Okou 'avatu kiā nātou 'ia te ma'uli ta'engatá; pea 'e kailoa 'aupito notou 'auha 'o ta'engata, pea 'e kailoa hamusi nātou he taha mei Toku nimá. ");
INSERT INTO num_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ko Taku Tamaí, 'ā ē ne'e foaki mai 'ia nātou kiā Aú, 'oku lahi Ia 'i te me'a kotoa pē; pea 'oku kailoa 'aupito lava he taha ke hamusi mei te nima 'o te Tamaí. ");
INSERT INTO num_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ko Au mo te Tamaí 'oku mā taha pē.” ");
INSERT INTO num_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pea toe to'o maka leva 'e te kakai Siú, ke notou tolomaka'i 'aki 'ia Sīsū. ");
INSERT INTO num_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kae tali ange 'e Sīsū kiā nātou, “Kua lahi te 'ū ngāue lelei kua U faka'ali'ali kiā kōtou mei te Tamaí; ko te ngāue fea ia 'oku kotou 'ai ai ke tolomaka'i 'Okú?” ");
INSERT INTO num_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Pea tali ange 'e te kau Siú kiā Ia, “'Oku kala ko he ngāue lelei ia 'oku motou tolomaka'i ai 'Oú, kā ko te lea fia 'Atuá; 'osi, ko te tangata 'ia Koe, kā kua Ke lau, ko te 'Atuá 'ia Koe!” ");
INSERT INTO num_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Pea tali leva 'e Sīsū kiā nātou, “Ne'e kailoa koā tohi 'i te kotou Laó, 'o pehē, ‘Ne Au lau ko te 'ū 'atua 'ia kōtou’? ");
INSERT INTO num_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ne'e ui 'e te Folafolá ko te 'ū ‘'atua’ 'ia nātou ne'e 'ave ki ai te Folafola 'a te 'Atuá, pea 'e kala ala tāmate'i 'ia te Folafolá. ");
INSERT INTO num_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Pea ko te ā 'oku kotou pehē ai 'Okou lea fia 'Atua, kote'uhiā ko Taku pehē ‘Ko te 'Alo 'o te 'Atuá 'ia Au’? Kae 'osi angé ko te Tamaí ia ne'e fakanofo 'Oku mo fekau mai 'Oku ki māmaní. ");
INSERT INTO num_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kāpau leva 'oku kailoa U feia 'ia te 'ū ngāue 'o Taku Tamaí, pea 'aua 'e kotou tui kiā Au. ");
INSERT INTO num_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kae kāpau leva 'Okou fai ia, pea neongo 'oku kala kotou tui kiā Au, tui pe ā ki te 'ū ngāué, kote'uhí ke kotou vakai 'o 'ilo'i, 'oku 'iā Au 'ia te Tamaí, mo Au 'i te Tamaí.” ");
INSERT INTO num_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Pea notou toe feinga ke puke'i 'Ona, ka ne'e moulu atu pē Ia mei te notou nimá. ");
INSERT INTO num_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Pea toe 'alu Ia ki Tu'a-Sioatani, ki te feitu'u ne'e fai papitaiso ai 'e Sione 'i te kamata'angá, pea nofo Ia 'i te feitu'u ko iá. ");
INSERT INTO num_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Pea ne'e ōmai he tokolahi kiā Ia, 'o notou pehē, “Ne'e kailoa 'aupito fai 'e Sione ia he faka'ilonga mana, kā ko te 'ū me'a ne'e fakahaa'i 'e Sione 'o kau ki te Toko Taha nei, tā ko te mo'oni kotoa pē.” ");
INSERT INTO num_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Pea ne'e tui he tokolahi kiā Ia 'i ai. ");
INSERT INTO num_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Pea ne'e 'i ai he toko taha ne'e mahaki'ina, ko Lāsalosi 'i Pētani, 'i te kolo 'o Mele mo tono tokoua ko Mā'atá. ");
INSERT INTO num_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Pea ko te Mele ko iá ne ina tākai 'ia te 'Alikí 'aki te lolo, mo holoholo'i Tono va'é 'aki tono lau'i'ulú, pea kua puke tono tu'anga'ané ko Lāsalosi.) ");
INSERT INTO num_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ko ia ne'e fekau atu kiā Ia 'e tono ongo tu'afāfiné, 'o pehē, “'Aliki, vakai angé, ko te siana 'oku Ke 'ofa aí 'oku puke.” ");
INSERT INTO num_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kā 'i te fanongo ki ai 'e Sīsuú ne'e iange 'e Ia, “Ko te mahaki 'eni ia 'oku kailoa hoko maí ke pekia ai, kā ko tono 'uhingá ko te lāngilangi 'o te 'Atuá, kote'uhí ke fakalāngilangi'i ai 'ia te 'Alo 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Pea ne'e 'ofa 'ia Sīsū kiā Mā'ata, mo tono tokouá, pea mo Lāsalosi. ");
INSERT INTO num_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ko ia 'i Tana fanongo leva 'oku puké, ne'e kei nofo pē Ia 'i te feitu'u ne'e 'i aí, 'o 'aho ua. ");
INSERT INTO num_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kae hili ange iá, ne'e iange 'e Ia ki te kau akó, “Tou toe ō ki Siutea.” ");
INSERT INTO num_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Pea iange kiā ia 'e te kau akó, “Lāpai, ne'e toki feinga pē te kau Siú ke tolongi 'Ou; pea ko Tau tē 'alu koā ē ki ai?” ");
INSERT INTO num_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Pea tali ange 'e Sīsū, “'Oku kailoa koā hongofulu mā ua te houá 'i te 'aho? Kā hā'ele he taha lolotonga 'oku 'ahó, 'e kailoa tūkia, kote'uhí 'oku mamata ia ki te maama 'o māmaní. ");
INSERT INTO num_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kae kāpau 'e hā'ele he taha 'i te pō'ulí 'e tūkia, kote'uhí 'oku kala 'iā ia 'ia te maamá.” ");
INSERT INTO num_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ne'e pehē Tana 'ū leá, pea toki pehē ange 'e Ia kiā nātou, “Ko te tou kaume'a ko Lāsalosí kua moe, kā ko Taku 'alu 'ení ke fafangu'i 'ona.” ");
INSERT INTO num_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Pea lea ange kiā Ia Tana kau akó, “'Aliki, kāpau kua moe ia, 'e ma'uli pē.” ");
INSERT INTO num_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ka ne'e lea 'e Sīsuú ia 'o kau ki tana pekiá, kae mahalo 'e nātou ia ko Tana me'á ki ha'aná toka 'o moe. ");
INSERT INTO num_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Pea toe 'ai mahino ange 'e Sīsū kiā nātou, 'o pehē, “Kua pekia 'ia Lāsalosi. ");
INSERT INTO num_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Pea 'Okou fiafia 'i te kailoa ke Au 'i aí, kote'uhí ko kōtou, kote'uhiā ke kotou tui. Kae tou ō pē kiā ia.” ");
INSERT INTO num_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Pea iange ai 'e Tōmasi, 'ā ē 'oku ui ko Titimasí ki tono kaungā akó, “Tou ō foki, ke tou mate fakataha mo ia.” ");
INSERT INTO num_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Pea 'i te a'u atu 'ia Sīsuú, ne Ina 'ilo'i ai tā kua 'osi te 'aho ia 'e fā tana 'i fanualotó. ");
INSERT INTO num_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Pea ne'e vāofi 'ia Pētani mo Selusalema, fe'unga nai mo te maile 'e ua. ");
INSERT INTO num_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Pea ha'u te tokolahi 'o te kau Siú kiā Mā'ata mo Mele, ke fakafiamālie kiā nāua kote'uhí ko te nā tu'anga'ané. ");
INSERT INTO num_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Pea ko Mā'ata, 'i tana fanongo leva 'oku ha'u 'ia Sīsuú, ne'e 'alu atu ia 'o fakafetaulaki kiā Ia, kae nofo pē 'ia Mele ia 'i fale. ");
INSERT INTO num_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Pea lea ai 'e Mā'ata kiā Sīsū, “'Aliki, kāpau ne Ke 'i heni, pehē ne'e kala pekia toku tu'anga'ané. ");
INSERT INTO num_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kā 'okou 'ilo'i pē, neongo pe ko te ā Hau kole 'e fai ki te 'Atuá, 'e 'avatu pē 'e te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Pea me'a ange 'e Sīsū kiā ia, “'E toetu'u tou tu'anga'ané.” ");
INSERT INTO num_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Pea tali ange 'e Mā'ata kiā Ia, “'Okou 'ilo'i 'e toetu'u ia 'i te toetu'u 'o te 'aho fakamulí.” ");
INSERT INTO num_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Pea toki me'a ange 'e Sīsū kiā ia, “Ko au pē ko te Toetu'u, pea mo te Ma'uli. Ko ia 'oku tui pīkitai kiā Aú, neongo kua pekia, kā 'e ma'uli pē, ");
INSERT INTO num_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","kā ko ia 'oku ma'uli mo tui pīkitai kiā Aú 'e kailoa 'aupito mate ia, 'o ta'engata. 'Oku ke tui ki te me'a ko iá?” ");
INSERT INTO num_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Pea iange ia, “'Io, 'Aliki; 'okou tui ko te Kalaisí 'ia Koe, ko te 'Alo 'o te 'Atuá, ko te Toko Taha kā ha'u ki māmaní.” ");
INSERT INTO num_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pea hili ange tana lea peheé, ne ina 'alu 'o ui ange 'ia Mele ko tono tehiná, 'o tala'i fakafufū kiā ia 'o pehē, “Kua me'a mai 'ia te Tangata'alikí, pea 'oku fia ma'u 'e Ia 'ou.” ");
INSERT INTO num_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Pea 'i tana fanongo ki aí, ne'e tu'u leva ia, 'o 'alu kiā Ia. ");
INSERT INTO num_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Pea kua he'iki ai a'u 'ia Sīsū ki te koló, kā 'oku kei 'i te feitu'u ne'e fakafetaulaki ai 'ia Mā'ata kiā Iá. ");
INSERT INTO num_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Pea ko te kau Siu ne'e notou 'iā Mele 'i te falé, 'o fakafiamālie kiā iá, 'i te notou vakai ki te tu'u vave 'ia Mele 'o hū ki tu'á, ne'e notou mulimuli kiá ia, 'i te notou mahalo ko tana 'alu ki te fanualotó ke tangi ai. ");
INSERT INTO num_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Pea 'i te a'u leva 'ia Mele ki te feitu'u ne'e 'i ai 'ia Sīsuú, 'o mamata kiā Iá, ne'e tū'ulutui atu ia ki Tono va'é, 'o iange kiā ia, “'Aliki, ka ne Ke 'i heni, ne'e kailoa pekia si'aku tu'anga'ané.” ");
INSERT INTO num_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Pea 'i te vakai atu 'e Sīsū kiā ia 'oku tangi, mo te kakai Siu ne'e ōmai mo iá, 'oku notou tangi, ne'e to'e Ia 'i Tono laumālié, mo mamahi, ");
INSERT INTO num_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","pea iange 'e Ia, “Kua kotou telio 'oná 'i fea?” Pea notou iange, “'Aliki, me'a mai, 'o mamata ki ai.” ");
INSERT INTO num_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Pea ne'e tutulu 'ia Sīsū. ");
INSERT INTO num_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Pea lea ai 'ia te kau Siú, “Vakai ange ā, tā ne'e lahi Tana 'ofa kiā Lāsalosí!” ");
INSERT INTO num_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kā ne pehē te notou 'ihi, “Ne kailoa koā mei lava pē te siana nei, 'ā ē ne'e faka'ā te mata 'o te kuí, ke ngaahi mo te tangata nei ke 'aua na'a mate?” ");
INSERT INTO num_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Pea tē to'e ai 'ia Sīsū 'i Tono lotó, mo 'alu atu ki te fanualotó. Pea ko te 'ana ia, pea ne'e tāpuni 'aki 'ia te maka. ");
INSERT INTO num_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Pea folafola ange 'e Sīsū, “To'o te maká.” Pea lea kiā ia 'e te tu'afafine 'o ia kua maté, 'ia Mā'ata, “'E 'Aliki, kua namuhāhā; he ko te 'aho 'eni 'e fā.” ");
INSERT INTO num_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pea me'a ange 'e Sīsū kiā ia, “Ne'e kailoa koā ke Au tala'i atu: kāpau 'e ke tui, 'e ke mamata ki te lāngilangi 'o te 'Atuá?” ");
INSERT INTO num_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Pea notou to'o leva 'ia te maká. Pea toki hanga ake 'e Sīsū Tono fofongá, 'o pehē, “'E Tamai, 'Okou fakafeta'i atu kote'uhí ne Ke ongo'i 'Oku. ");
INSERT INTO num_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Pea 'Okou 'ilo'i pē 'oku Ke ongo'i 'ia Au ma'u ai pē, kā ko Taku leá kote'uhí ko te fu'u kakai 'oku notou tutu'u nei, kote'uhí ke notou tui ko Koe kua Ke fekau mai 'Okú.” ");
INSERT INTO num_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pea hili ange Tana lea peheé, pea kalanga le'o lahi Ia, “Lāsalosi, tu'u mai ki tu'a!” ");
INSERT INTO num_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Pea hū ki tu'a 'ia te pekiá, kua ha'i tono ongo va'é mo tono ongo nimá 'aki te 'ū tupenu, pea ko tono fofongá ne'e takatakai 'aki he holoholo. Pea folafola 'e Sīsū kiā nātou, “Vete ange ia, pea tukuange ke 'alu.” ");
INSERT INTO num_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Pea ko te tokolahi 'o te kakai Siu ne'e ōmai kiā Melé, pea kua notou mamata ki te me'a ne'e fai 'e Sīsuú, ne'e notou tui pīkitai kiā Ia. ");
INSERT INTO num_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ka ne'e ō te notou 'ihi ki te kau Fālesí, 'o tala'i kiā nātou 'ia te 'ū me'a ne'e fai 'e Sīsuú. ");
INSERT INTO num_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ko ia ne'e fakataha 'e te kau taula'aliki lahí mo te kau Fālesí 'ia te Sanetalimí, 'o notou pehē, “Ko te ā he me'a 'e tou fai? He ko te tangata nei ko te me'a lahi Tana fai faka'ilonga maná. ");
INSERT INTO num_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kāpau 'e tou tuku noa'i ai pē 'Ona, 'e tui pīkitai kiā Ia 'ia te kakai kotoa pē, pea 'e ha'u 'ia te kau Lomá, 'o 'ave te tou fanuá mo te tou pule'angá fakatou'osi.” ");
INSERT INTO num_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pea ko te notou toko taha, ko Kaiafasi, 'a ia ne'e Taula'aliki Lahi 'i te ta'u ko iá, ne'e pehē 'e ia kiā nātou, “Tā ko kōtoú 'oku kala kotou mama'i 'ilo'i he me'a! ");
INSERT INTO num_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kotou fakakaukau'i angé, 'oku sai ange kiā tātou ke mate he fe'i tangata 'e toko taha kote'uhí ko te kakaí, kae'aua na'a 'auha 'ia te pule'angá kātoa.” ");
INSERT INTO num_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ka ne'e kailoa meiā ia pē 'ia te lea ko iá, kā ko te me'a 'i tana Taula'aliki Lahi 'i te ta'u ko iá, ko ia ne'e palōfisai ai, 'oku ene 'ia Sīsū ke pekia kote'uhí ko te pule'angá; ");
INSERT INTO num_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","'o kailoa kote'uhí ko te pule'angá pē, kā kote'uhí foki ke fakatahataha'i 'ia te fānau 'a te 'Atuá kua mavetevete 'i mulí. ");
INSERT INTO num_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Pea talu mei te 'aho ko iá ne'e notou fa'ufa'u ke tāmate'i 'Ona. ");
INSERT INTO num_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ko ia ai ne'e kailoa kei 'alu fakahāhā 'e Sīsū ki te ha'a Siú, kā ne 'alu Ia mei ai ki te tuku'utá, 'o ofi ki te toafá, ki te kolo ne'e hingoa ko 'Ifalemi, 'o nofo 'i ai mo Tana kau akó. ");
INSERT INTO num_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pea kua ofi mai te taimi 'o te Pāsova 'a te ha'a Siú; pea ne'e ō ake he tokolahi ki Selusalema mei te tuku'utá 'i te he'iki ai hoko 'ia te kātoangá, kote'uhí ke fakama'a 'ia nātou. ");
INSERT INTO num_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pea notou fekumi ai kiā Sīsū, 'o notou fetalanoa'aki 'i te notou tutu'u 'i te Temipalé, 'o pehē, “Ko te ā he kotou lau? 'Oku kotou pehē 'e kala 'aupito ha'u Ia ki te kātoangá?” ");
INSERT INTO num_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pea ko 'eni, kua fai tu'utu'uni 'e te kau taula'aliki lahí mo te kau Fālesí, 'o pehē, kā 'i ai he taha 'oku 'ilo'i pe 'oku 'i fea Ia, ke fakahaa'i ange, kote'uhí ke notou puke'i 'Ona. ");
INSERT INTO num_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pea toe te 'aho 'e ono pea fai 'ia te Pāsová, ne'e ha'u 'ia Sīsū ki Pētani, ko te feitu'u ne'e nofo ai 'ia Lāsalosi, 'ā ē ne'e fokotu'u 'e Sīsū mei te pekiá. ");
INSERT INTO num_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Pea notou fai ai he kātoanga Ma'ana 'i te feitu'u ko iá; pea tauhi tēpile 'ia Mā'ata, kā ko Lāsalosi ko te taha 'iā nātou ne'e nā nonofo mo Ia 'i te kaí. ");
INSERT INTO num_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Pea ne'e to'o 'e Mele he pāuni lolo tākai, ko te na'ati mo'oni pea mahu'inga lahi, 'o tākai 'aki te va'e 'o Sīsuú, mo holoholo'i Tono va'é 'aki tono lau'i'ulú. Pea ne'e fonu te falé 'i te ngangatu 'o te loló. ");
INSERT INTO num_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Pea lea ai te toko taha 'o Tana kau akó, ko Siutasi 'Isikaliote, 'ā ē 'oku ene ke lavaki'i 'Oná, 'o pehē 'e ia, ");
INSERT INTO num_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ko te ā ne'e kala fakatau ai te lolo neí, ke ma'u ai he tēnali 'e tolungeau, 'o foaki ki te masivá?” ");
INSERT INTO num_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kā ko tana lea ko iá, ne'e kailoa ko te pehē ne'e mamafa te masivá kiā ia, kā kote'uhí ko te kaiha'a ia, pea ne'e 'iā ia foki te notou puha pa'angá, pea ne'e fa'a 'ave 'e ia te 'ū me'a ne'e sī ki aí. ");
INSERT INTO num_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Pea me'a ange 'e Sīsū, “Tuku ai pē te fafiné, he ko ta'aná tauhi 'eni ki te 'aho 'o Toku tanú. ");
INSERT INTO num_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","He ko te masivá 'e kotou feangai ai pē mo nātou, kā 'e kailoa kotou feangai ai pē mo Au.” ");
INSERT INTO num_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Pea 'ilo'i 'e te tokolahi 'o te kakai Siú 'oku 'i ai 'ia Sīsū 'i te feitu'u ko iá, pea notou ō leva ki ai, 'o kailoa kote'uhí ko Sīsū pē, kā kote'uhí foki ke notou mamata kiā Lāsalosi, 'ā ē kua Ina fokotu'u mei te pekiá. ");
INSERT INTO num_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ka ne'e alea'i 'e te kau taula'aliki lahí ke tāmate'i mo Lāsalosi foki, ");
INSERT INTO num_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kote'uhí ko te me'a 'iā ia ne'e mole ai he tokolahi 'o te kakai Siú, 'o notou tui kiā Sīsū. ");
INSERT INTO num_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","'I te pongipongi aké, ne'e fanongo 'e te fu'u kakai tokolahi kua ōmai ki te kātoangá, 'oku me'a mai 'ia Sīsū ki Selusalema, ");
INSERT INTO num_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","pea ne'e notou to'o leva he 'ū va'a paame, 'o notou hū ki tua'ā ke fakafetaulaki kiā Ia, mo notou kalanga, “Hōsana! 'Oku manū'ia 'ia te Tu'i 'Isilelí 'a ia 'oku hoko mai 'i te huafa 'o te 'Alikí.” ");
INSERT INTO num_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Pea kua ma'u 'e Sīsū he 'asi mui, 'o Ina heka ki ai; 'o hangē ko ia kua tohí, ");
INSERT INTO num_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“'E ta'ahine 'o Saione, 'aua 'e manahē, vakai, ko tou Tu'í 'oku me'a mai kiā koe, 'oku heka 'i te ki'i 'asi.” ");
INSERT INTO num_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ko te 'ū me'a ko 'ení ne'e kailoa mahino ia ki Tana kau akó 'i te kamata'angá, kā 'i te hoko ki tono fakalāngilangi'i 'o Sīsuú, pea notou toki manatu'i, tā ne'e tohi 'ia te 'ū me'a nei kiā Ia, pea kua notou fai pehē 'eni kiā Ia. ");
INSERT INTO num_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Pea ne'e fakahaa'i foki 'Ona 'e te kakai kotoa pē ne'e 'iā Ia lolotonga Tana ui mai 'ia Lāsalosi mei te fanualotó, mo tono fokotu'u mei te pekiá. ");
INSERT INTO num_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ko tono 'uhinga foki ia ne'e fakafetaulaki ai kiā Ia 'e te fu'u kakaí, kote'uhí kua notou fanongo ki Tana fai te fu'u faka'ilonga mana ko iá. ");
INSERT INTO num_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ko ia ne'e fepehē'aki 'e te kau Fālesí, “'Oku kotou tokanga'i koā 'oku kala tou lava 'o mafohi he me'a? Vakai angé, kua hiki fu'u 'ia māmani 'o mulimuli kiā Ia!” ");
INSERT INTO num_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pea ne'e 'i ai he kau Kalisi 'i te kakaí ne'e ō ake ke fai te notou lotu 'i te kātoangá; ");
INSERT INTO num_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","pea notou ōmai kiā Filipe, mei Petesaita 'i Kālelí, 'o kole kiā ia 'o pehē, “'Aliki, 'oku motou fia fe'iloaki mo Sīsū.” ");
INSERT INTO num_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pea ha'u 'ia Filipe 'o tala kiā 'Anitelū, pea ōmai leva 'ia 'Anitelū mo Filipe 'o tala kiā Sīsū. ");
INSERT INTO num_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Pea tali ange 'e Sīsū kiā nāua, 'o pehē, “Kua hokosia te taimi ke fakalāngilangi'i ai 'ia te Fanautama te Tangatá. ");
INSERT INTO num_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: kāpau 'e kailoa tō ki te kelekelé 'ia te pulapula'i uité 'o mate, 'e teka taha ai pē ia; kae kāpau 'e mate, 'e fua lahi. ");
INSERT INTO num_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ko ia 'oku 'ofa pē ki ta'aná ma'uli, ko tana tuku ia ke molé, kā ko ia ko 'ē 'oku fihi'a ki tana ma'uli 'i te maama ko 'ení, ko tana tauhi ia 'o a'u ki te ma'uli ta'engatá. ");
INSERT INTO num_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kāpau 'e tauhi 'Oku he taha, ke mulimuli mai ia kiā Au; pea ko te feitu'u 'Okou 'i aí, 'e 'i ai foki Taku sevānití. Kāpau 'e tauhi 'Oku he taha, 'e fakahīkihiki'i 'ona 'e te Tamaí. ");
INSERT INTO num_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ko 'eni kua mamahi fu'u Toku laumālié; pea ko te ā ai Taku lea 'e faí? 'E Tamai, fakahaofi mu'a 'Oku mei te houa ko 'ení! Kā ko tono 'uhinga ē ne Au ha'u aí, kote'uhí ko te houa ko 'ení. ");
INSERT INTO num_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","'E Tamai, ke Ke fakalāngilangi'i To'oú huafa.” Pea ne'e hoko mai he le'o mei te langí, 'o pehē, “Kua U 'osi fakalāngilangi'i Ia, pea 'e Au toe fakalāngilangi'i foki.” ");
INSERT INTO num_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Pea ko te kakai ne'e notou tu'u 'i ai 'o fanongó, ne'e notou pehē kua mana. Kae pehē te 'ihi, “Ko te 'āngelo ne'e lea kiā Ia.” ");
INSERT INTO num_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kae lea ange 'e Sīsū 'o pehē, “Ne'e kailoa kote'uhí ko Au ne'e hoko mai ai te le'o ko 'ení, kā kote'uhí ko kōtou. ");
INSERT INTO num_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","'Ē, kua hoko 'eni te fakamaau 'o te maama nei; 'e kapusi leva ki tu'a te 'aliki 'o te maama ko 'ení. ");
INSERT INTO num_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pea ko Au, kāpau 'e hiki ake 'Oku ki lunga mei te kelekelé, 'e Au tohoaki'i te kakai kotoa pē kiā Au.” ");
INSERT INTO num_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ko Tana lea peheé, ko te fakatātaa'i atu 'ia te mate'anga 'e pekia aí. ");
INSERT INTO num_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Pea lea ange 'e te kakaí kiā Ia, “Kua motou fanongo mei te Laó, 'oku nofo 'ia te Kalaisí ia 'o ta'engata, pea fefe'aki ai Tau lau 'A'au 'o pehē, takua kua pau ke hiki ki lunga 'ia te Fanautama te Tangatá? Ko ai tū 'ia te Fanautama te Tangata ko iá?” ");
INSERT INTO num_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Pea folafola ange 'e Sīsū kiā nātou, “'Oku toe si'i pē te taimi 'o te 'iā kōtou te maamá. Kotou laka 'i te kotou kei ma'u 'ia te maamá, ke 'aua na'a lapasi kōtou 'e te pō'ulí. He ko ia 'oku ha'ele 'i te pō'ulí 'oku kala ina 'ilo'i pe ko tana 'alú ki fea. ");
INSERT INTO num_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","'I te kotou ma'u te Maamá, kotou tui pīkitai ki te Maamá, kote'uhí ke kotou hoko ko te fānau 'o te Maamá.” Ne'e pehē te Folafola 'a Sīsuú, pea hiki Ia mei ai, 'o fufuu'i 'Ona meiā nātou. ");
INSERT INTO num_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Pea neongo kua lahi fau Tana 'ū faka'ilonga mana kua fai 'e Ia 'i te notou 'aó, ka ne'e kailoa 'aupito notou tui kiā Ia. ");
INSERT INTO num_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Kote'uhiā ke fakamo'oni ki te lau 'a te palōfita ko 'Aiseá, 'a ia ne'e pehē, “'Aliki, ko ai kua tui ki te motou ongoongó? Pea kua fakahaa'i kiā ai 'ia te nima 'o te 'Alikí?” ");
INSERT INTO num_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ko tono 'uhinga ia ne'e kailoa notou lava ai ke tuí, kote'uhí ko te toe lea 'ia 'Aisea 'o pehē, ");
INSERT INTO num_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Kua Ina fakakuihi te notou matá, pea fakafefeka'i te notou lotó; kote'uhí ke 'aua na'a notou sio 'aki te notou matá, pea 'ilo'i 'aki te notou lotó, pea notou tafoki mai, kae Au fakama'uli 'ia nātou.” ");
INSERT INTO num_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ne'e lea pehē 'e 'Aiseá, 'i tana mamata ki Tono lāngilangí pea ne'e kau tana leá kiā Ia. ");
INSERT INTO num_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kā neongo iá, ne'e tui he tokolahi 'o te kau pulé kiā Ia kae fakapulipuli pē mei te kau Fālesí, na'a kapusi 'ia nātou mei te falelotú. ");
INSERT INTO num_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","He ne'e lahi ange te notou manako ki te fakahīkihiki 'oku fai mei te tangatá 'i te fakahīkihiki 'oku fai mei te 'Atuá. ");
INSERT INTO num_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Pea kalanga 'e Sīsū 'o pehē, “Kā 'i ai he taha 'oku tui pīkitai kiā Au, 'oku kailoa ko Au pē 'oku tui ia ki aí, kā ko Ia ne'e fekau mai 'Okú. ");
INSERT INTO num_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Pea ko ia 'oku ina siofia 'Okú, 'oku ina siofia 'ia Ia ne'e fekau mai 'Okú. ");
INSERT INTO num_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Kua U ha'u 'ia Au ki māmaní ko te maama, kote'uhí ko ia 'e tui pīkitai kiā Aú, pea 'aua na'a kei nofo ai pē 'i te fakapō'ulí. ");
INSERT INTO num_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pea kā fanongo he taha ki Taku 'ū leá, kae kailoa tauhi ki ai, 'e kailoa fakamāu'i 'ona ia 'e Au; he ne'e kailoa U ha'u ki māmaní ke fakamāu'i ia, kā ke fakama'uli 'ia māmani. ");
INSERT INTO num_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ko ia kua ina si'aki 'Oku, 'o kailoa tali Taku 'ū leá, kua 'i ai he toko taha ia 'oku fakamāu'i 'ona: ko te lea 'Okou lea 'akí, ko te me'a ia 'e fakamāu'i 'aki te tangata ko iá 'i te 'aho fakamulí. ");
INSERT INTO num_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kote'uhí ne'e kailoa 'A'aku Taku leá, kā ko te Tamaí ia ne Ina fekau'i mai 'Okú, ne tu'utu'uni mai 'e Ia ki te me'a 'e Au tala'i atú mo te lea 'e Au faí. ");
INSERT INTO num_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Pea 'Okou 'ilo'i ko Tana tu'utu'uní ko te ma'uli ta'engatá ia. Ko ia ko te me'a 'Okou lea 'akí, 'Okou lea 'aki 'o hangē pē ko Toku fekau 'e te Tamaí.” ");
INSERT INTO num_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pea 'i te he'iki ai fai te kātoanga 'o te Pāsová, ne'e mea'i 'e Sīsū kua hokosia Tono taimi ke hiki ai mei te maama ko 'ení ke 'alu ki te Tamaí. Pea ko te me'a 'i Tana 'ofa ki Tono kakai 'O'ona 'oku 'i māmaní, ne'e 'ofa Ia kiā nātou 'o a'u ki te ngata'angá. ");
INSERT INTO num_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pea ne'e fai he kai, pea kua 'osi 'ai 'e te tēvoló ki te loto 'o Siutasi, ko te foha 'o Saimone 'Isikalioté, ke lavaki'i 'Ona. ");
INSERT INTO num_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Pea kua mea'i 'e Sīsū kua tuku kiā Ia 'e Tana Tamaí 'ia te me'a kotoa pē ki Tono nimá, pea kua Ina ha'u mei te 'Atuá, pea 'oku 'alu Ia ki te 'Atuá; ");
INSERT INTO num_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","pea ne'e tu'u leva 'e Ia mei te kaí, 'o to'o Tono 'ū kofu tu'á, pea to'o 'e Ia he tauveli, 'o nono'o 'i Tono kongalotó. ");
INSERT INTO num_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Pea lingi 'e Ia he vai ki te kumeté, 'o kamata fufulu te va'e 'o te kau akó, pea holoholo 'aki te tauveli kua Ina no'o 'akí. ");
INSERT INTO num_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Pea 'i te a'u mai Ia kiā Saimone Pitá, ne'e iange 'e Pita kiā Ia, “'Aliki, 'e Ke fufulu toku va'é koā?” ");
INSERT INTO num_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Pea iange 'e Sīsū kiā ia, “Ko te me'a 'Okou faí, 'e kala 'ilo'i ia 'e koe 'i te taimi nei, kā 'e toki mahino 'āmuli ange.” ");
INSERT INTO num_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pea lea 'e Pita kiā Ia, “'E kailoa 'aupito fufulu 'e Koe to'okú va'e.” Pea tali 'e Sīsū kiā ia, “Kā kailoa ke Au fufulu 'ia koe, tā 'oku kailoa ha'aú kau mo Au.” ");
INSERT INTO num_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Pea iange 'e Saimone Pita, “'Aliki, 'aua na'a ngata 'i toku va'é pē, kae fai foki ki toku ongo nimá mo toku 'ulú.” ");
INSERT INTO num_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pea me'a ange 'e Sīsū kiā ia, “Ko ia kua kaukaú, 'oku kala 'aonga tana toe fufulu iá, ngata pē 'i tono va'é, he kua ma'a to'onó sino. Pea kua ma'a foki 'ia kōtou, kā 'oku kala kotou pehē kotoa pē.” ");
INSERT INTO num_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","He ne'e mea'i 'e Ia 'ia te toko taha 'e lavaki'i 'Oná; ko te 'uhinga ia Tana pehē: “'Oku kailoa ma'a 'ia kōtou kotoa pē.” ");
INSERT INTO num_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pea kua 'osi leva Tana fufulu te notou va'é, mo tui Tono 'ū kofu tu'á, pea toe nofo ifo Ia, 'o folafola ange kiā nātou, “'Oku kotou mahino'i 'ia te me'a ne Au fai kiā kōtoú? ");
INSERT INTO num_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","'Oku kotou ui 'Oku ko Lāpai, mo 'Aliki, pea ko te tonú ia, he ko Au Ia. ");
INSERT INTO num_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Pea kāpau ā kua U fufulu te kotou va'é, 'ia Au ko te 'Aliki mo te Lāpaí, 'oku totonu ke fai pehē 'ia kōtou foki, 'o kotou fefufulu'aki te kotou va'é. ");
INSERT INTO num_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Hē kua U tuku kiā kōtou he sīpinga, kote'uhí ke kotou fai foki, 'o hangē ko Taku fai kiā kōtoú. ");
INSERT INTO num_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: 'oku kailoa he tamaio'aliki 'e lahi 'i tana 'alikí, pē ko he talafekau 'iā ia ne'e fekau'i 'oná. ");
INSERT INTO num_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kāpau kua kotou 'ilo'i te me'a ko iá, ko te toki kakai manū'ia 'ia kōtou, 'o kāpau 'e kotou fai ia. ");
INSERT INTO num_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","'Oku kailoa kau Taku leá kiā kōtou kotoa pē; 'Okou 'ilo'i pē 'ia nātou ne Au fili'í. Kā ko tono 'uhingá, kote'uhí ke fakamo'oni ki te potu Folafola 'oku pehē: ‘Ko ia 'oku kai mā mo Aú, kua ina hiki tono muliva'é kiā Au.’ ");
INSERT INTO num_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Pea ko 'eni 'Okou fakahaa'i ia kiā kōtou 'i te he'iki ai hokó, kote'uhí kā hoko mai ia, ke kotou tui ko Au Ia. ");
INSERT INTO num_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: ko ia kua ina tali he taha pē 'e Au fekaú, kua ina tali 'Oku; pea ko ia kua ina tali 'Okú, kua ina tali 'ia Ia ne'e fekau'i mai 'Okú.” ");
INSERT INTO num_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Pea 'osi ange Tana folafola ko iá, ne'e mamahi Ia 'i Tono laumālié, pea fakapapau mai 'e Ia 'o pehē, “Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu kiā kōtou: 'e lavaki'i 'Oku 'e te kotou toko taha.” ");
INSERT INTO num_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Pea ne'e fesiofaki 'ia te kau akó mo fiu'a fifili pe ko Tana laú kiā ai. ");
INSERT INTO num_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Pea ne'e 'i ai te toko taha 'o Tana kau akó ne'e falala atu ki te fatafata 'o Sīsuú, ko te toko taha ne'e 'ofa ai 'ia Sīsū. ");
INSERT INTO num_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ko ia ne'e kamo ange 'e Saimone Pita kiā ia, 'o pehē, “'Eke ange, pe ko ai ia 'oku 'uhinga ki aí.” ");
INSERT INTO num_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Pea faaki atu ia ki te fatafata 'o Sīsuú, 'o 'eke ange, “'Aliki, ko ai ia?” ");
INSERT INTO num_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Pea tali ange 'e Sīsū, “Ko ia ko 'ē 'e Au unu Taku konga maá 'o 'avange ma'aná.” Pea unu 'e Ia Tana konga maá, 'o 'avange kiā Siutasi ko te foha 'o Saimone 'Isikalioté. ");
INSERT INTO num_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pea 'i te 'osi ange pē ko iá, ne'e hū leva kiā ia 'e Sētane. Pea folafola 'e Sīsū kiā ia, “Fai leva ke vave 'ia te me'a kua ke teu ke faí.” ");
INSERT INTO num_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ka ne'e kailoa he taha 'iā nātou 'i te kaí 'e mahino ki ai pe ko Tana lea ki aí ke ā. ");
INSERT INTO num_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","He ne'e mahalo te 'ihi, ko te me'a 'i te 'iā Siutasi te notou kato pa'angá, pea takua ko te lea 'a Sīsuú ke fakatau mai te notou 'ū me'a 'oku fia ma'u ki te kātoangá, pē ko te 'uhingá ke 'avange he me'a ki te masivá. ");
INSERT INTO num_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pea 'i te 'osi ange pē tana to'o te konga maá, ne'e 'alu leva ia ki tu'a; pea kua pō'uli. ");
INSERT INTO num_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Pea kua 'alu ia ki tua'ā, pea folafola ange 'e Sīsū, “Ko 'eni kua fakalāngilangi'i te Fanautama te Tangatá, pea kua fakalāngilangi'i te 'Atuá 'iā Ia. ");
INSERT INTO num_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kāpau 'oku fakalāngilangi'i 'ia te 'Atuá 'iā Ia, 'e fakalāngilangi'i 'Ona 'e te 'Atuá 'iā Ia, pea 'e vave pē Tana fakalāngilangi'i 'Oná. ");
INSERT INTO num_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Si'i fānau, 'oku toe si'i pē Taku 'iā kōtoú. 'E kotou kumi 'Oku, kae hangē ko Taku lea ki te ha'a Siú 'o pehē: ‘Ko te feitu'u 'Okou 'alu ki aí, 'e kala kotou lava ke a'u ki ai,’ 'oku pehē pē Taku lea ko 'eni kiā kōtoú. ");
INSERT INTO num_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ko te tu'utu'uni fo'ou 'eni 'Okou tuku atu kiā kōtoú: ke kotou fe'ofa'aki. Hangē ā ko Taku 'ofa'i kōtoú, ke pehē foki te kotou fe'ofa'akí. ");
INSERT INTO num_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ko te me'a 'eni 'e 'ilo'i ai 'e te kakai kotoa pē ko Taku kau ako 'ia kōtoú, 'o kāpau 'e kotou fe'ofa'aki.” ");
INSERT INTO num_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Pea lea ange 'e Saimone Pita kiā Ia, “'Aliki, ko Tau me'á ki fea?” Pea tali ange 'e Sīsū, “Ko te feitu'u 'Okou 'alu ki aí, 'e kala lava ke ke mulimuli mai ki ai 'i te taimi nei, kā 'e ke toki mulimuli kiā Au 'āmuli.” ");
INSERT INTO num_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pea iange 'e Pita, “'Aliki, ko te kailoa lava ke au mulimuli atu 'i te taimi neí, ko te ā? Na'a mo taku ma'ulí 'e au si'aki ia Ma'au.” ");
INSERT INTO num_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Pea tali ange 'e Sīsū kiā ia, “'E ke si'aki koā tau ma'ulí kote'uhí ko Au? Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: 'e kailoa 'u'ua te moá, kae'aua ke fakafisinga'i tu'a tolu 'Oku 'e koe. ");
INSERT INTO num_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“'Aua na'a tuku ke puputu'u te kotou lotó: tui pīkitai ki te 'Atuá, tui pīkitai foki kiā Au. ");
INSERT INTO num_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","'I te fale 'o Taku Tamaí 'oku lahi ai 'ia te 'ū nofo'angá; ka ne kailoa, pehē kua U tala'i kiā kōtou. Hē ko Taku 'alu 'eni ke teuteu'i he nofo'anga mo'o kōtou. ");
INSERT INTO num_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Pea kāpau 'e Au 'alu, 'o teuteu he nofo'anga mo'o kōtou, 'e Au toe ha'u pē, 'o ma'u 'ia kōtou kiā Au; kote'uhí ko te feitu'u 'e Au 'i aí, ke kotou 'i ai foki. ");
INSERT INTO num_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Pea ko te feitu'u 'Okou 'alu ki aí 'oku kotou 'ilo'i, pea 'oku kotou 'ilo'i mo tono alá.” ");
INSERT INTO num_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Pea lea ange 'e Tōmasi kiā Ia, “'Aliki, 'oku kala motou 'ilo'i pe ko Tau me'á ki fea; pea motou 'ilo'i fefe'aki ai 'ia te alá?” ");
INSERT INTO num_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Pea tali ange 'e Sīsū kiā ia, “Ko Au pē ko te Alá, pea mo te Mo'oní mo te Ma'ulí; 'oku kailoa ha'u he taha ki te Tamaí, kā 'i tana fou 'iā Au. ");
INSERT INTO num_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kāpau ne kotou 'ilo'i 'Oku, pehē 'e kotou 'ilo'i mo Taku Tamaí foki. Pea mei te taimi nei 'oku kotou 'ilo'i Tana 'Afió, pea kua kotou mamata kiā Ia.” ");
INSERT INTO num_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pea lea ange 'e Filipe kiā Ia, “'Aliki, fakahaa'i mai 'ia te Tamaí kiā mātou, pea 'e motou fiamālie leva.” ");
INSERT INTO num_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Pea tali ange 'e Sīsū kiā ia, “Kua fualoa fau Taku 'iā kōtoú, pea kua he'iki ai koā ke ke 'ilo'i 'Oku, Filipe? Ko ia kua ina mamata kiā Aú, kua ina mamata ki te Tamaí; pea fefe'aki ai tau pehē: ‘Fakahaa'i mai 'ia te Tamaí kiā mātou’? ");
INSERT INTO num_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","'Oku kailoa koā ke tui, 'Okou 'i te Tamaí, pea ko te Tamaí 'oku 'iā Au? Ko te 'ū lea 'Okou fai kiā kōtoú, 'oku kailoa U lea 'aki meiā Au pē, kā ko te Tamaí 'oku fai 'e Ia Tana 'ū ngāué, 'i Tana nofo'ina 'Okú. ");
INSERT INTO num_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tui mai kiā Au, 'Okou 'i te Tamaí, mo te Tamaí 'iā Au. Pea kā kailoa, pea kotou tui kote'uhí ko Tana 'ū ngāué. ");
INSERT INTO num_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: ko ia 'oku tui pīkitai kiā Aú, ko te 'ū ngāue 'Okou faí 'e fai 'e ia foki, 'io, 'e fai 'e ia te 'ū me'a 'oku hulu atu 'i te 'ū me'a nei; kote'uhiā ko Taku 'alu ki te Tamaí. ");
INSERT INTO num_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Pea ko te me'a kotoa pē 'e kotou kole 'i Toku hingoá, 'e Au fai ia, kote'uhí ke fakalāngilangi'i te Tamaí 'i te 'Aló. ");
INSERT INTO num_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ko te me'a kotoa pē 'e kotou kole 'i Toku hingoá, 'e Au fai ia. ");
INSERT INTO num_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Kāpau 'oku kotou 'ofa kiā Au, 'e kotou tauhi Taku 'ū fekaú. ");
INSERT INTO num_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Pea 'e Au kole ki te Tamaí, pea 'e 'avatu 'e Ia kiā kōtou he Taukapo 'e Toko Taha, kote'uhí ke nofo 'e Ia mo kōtou 'o ta'engata, ");
INSERT INTO num_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","'io, ko te Laumālie 'o te Mo'oní, 'a ē 'oku kailoa lava ke tali 'e māmani, kote'uhí 'oku kailoa sio ia ki Ai, pe 'ilo'i 'Ona. Kā 'e kotou 'ilo'i Ia, hē 'e nofo ma'u Ia mo kōtou, 'o 'afio 'iā kōtou. ");
INSERT INTO num_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","'E kala U si'aki 'ia kōtou ke tuenoa; 'e Au toe ha'u pē kiā kōtou. ");
INSERT INTO num_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","'Oku toe si'i pea kala kei sio 'e māmani kiā Au, kā 'e sisio ai pē kiā Au 'e kōtou; kote'uhí 'oku ma'uli 'ia Au, pea 'e kotou mā'u'uli ai pē. ");
INSERT INTO num_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","'I te 'aho ko iá 'e kotou 'ilo'i, ko Au 'i te Tamaí, mo kōtou 'iā Au, mo Au 'iā kōtou. ");
INSERT INTO num_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ko ia 'oku ma'u Taku 'ū tu'utu'uní, pea tauhi ki aí, ko te taha ia 'oku 'ofa kiā Aú. Pea ko ia 'oku 'ofa kiā Aú, 'e 'ofa'i 'ona 'e Taku Tamaí, pea 'e Au 'ofa mo Au kiā ia, pea 'e Au fakahaa'i 'Oku kiā ia.” ");
INSERT INTO num_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Pea pehē ange 'e Siutasi kiā Ia, ka ne'e kailoa ko 'Isikaliote, “'Aliki, ko te ā 'e Ke fakahaa'i ai 'Ou kiā mātou, kae kailoa ki māmaní?” ");
INSERT INTO num_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Pea tali ange 'e Sīsū kiā ia, “Kāpau 'oku 'ofa he taha kiā Au, 'e fai 'e ia ki Taku leá, pea 'e 'ofa kiā ia Taku Tamaí, pea 'e Mā ōmai kiā ia, 'o nofo ma'u mo ia. ");
INSERT INTO num_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ko ia 'oku kala 'ofa kiā Aú, 'oku kala tauhi 'e ia Taku 'ū leá. Pea ko te 'ū lea 'oku kotou fanongo ki aí, 'oku kailoa 'A'aku ia, kae 'a te Tamaí 'ā ē ne'e fekau'i mai 'Okú. ");
INSERT INTO num_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ko te 'ū me'a ko 'ení 'Okou tala'i atu 'i Taku kei 'iā kōtoú. ");
INSERT INTO num_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kā ko te Taukapó, ko te Laumālie Mā'oni'oní, 'ā ē 'e fekau'i mai 'e te Tamaí 'i Toku hingoá, 'e ako'i 'e Ia kiā kōtou 'ia te me'a kotoa pē, mo fakamanatu kiā kōtou 'ia te me'a kotoa pē 'Okou lea 'aki kiā kōtoú. ");
INSERT INTO num_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","'Okou tuku he fiamālie kiā kōtou; ko te fiamālie 'A'akú 'Okou 'avatu kiā kōtou. 'Oku kailoa hangē ko te foaki 'a māmaní, Taku foaki kiā kōtoú. 'Aua na'a puputu'u te kotou lotó, pea 'aua na'a manahē. ");
INSERT INTO num_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ne kotou fanongo ki Taku pehē atu, ‘Ko Taku 'alu 'eni pea U toe ha'u kiā kōtou.’ Ka ne kotou 'ofa kiā Au, 'e kotou fiafia 'i Taku pehē, ‘'Okou 'alu ki te Tamaí;’ kote'uhí 'oku lahi te Tamaí 'iā Au. ");
INSERT INTO num_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Pea 'Okou tala'i atu 'eni kiā kōtou 'i te he'iki ai hoko maí, kote'uhí kā hoko mai ia, pea kotou tui. ");
INSERT INTO num_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ngata mei heni, 'e kala U toe talanoa lahi mo kōtou, he kua ha'u te 'aliki 'o te maama ko 'ení, pea 'oku kailoa ha'aná mama'i me'a 'iā Au. ");
INSERT INTO num_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Kā kote'uhí pē ke 'ilo'i 'e māmani 'Okou 'ofa ki te Tamaí, pea 'Okou fai hangē ko Toku tu'utu'uni 'e te Tamaí. Kotou tutu'u ake ke tou ō mei heni. ");
INSERT INTO num_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ko Aú ko te Vaine Mo'onia, pea ko Taku Tamaí ko te tauhi ngoué Ia. ");
INSERT INTO num_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ko te va'a kotoa pē 'iā Au 'oku kailoa fua, 'e tu'usi 'e Ia; pea ko te va'a kotoa pē 'oku fuá, 'e 'auhani 'e Ia, ke 'āsili tana fuá. ");
INSERT INTO num_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kua kotou ma'a 'eni kōtou, ko te me'a 'i te lea 'Okou fai kiā kōtoú. ");
INSERT INTO num_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kotou nofo ma'u 'iā Au, mo Au 'iā kōtou. 'Oku kala lava ke fua te va'á 'iā ia pē, 'o kāpau 'e kala nofo ma'u 'i te vainé, pehē foki 'e kala kotou lava ke fua, 'o kāpau 'e kala kotou nofo ma'u 'iā Au. ");
INSERT INTO num_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ko Au pē ko te vaine, ko kōtoú ko te 'ū va'a. Ko ia ko 'ē 'oku nofo ma'u 'iā Aú, mo Au 'iā iá, 'oku fua lahi 'ia te toko taha ko iá; he kā māvae mo Au, 'e kailoa kotou lava ke fai he me'a. ");
INSERT INTO num_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kā kailoa nofo ma'u he taha 'iā Au, 'oku si'aki atu ia hangē ko te va'á, pea 'oku mae; pea 'oku tānaki ia 'e te kakaí, 'o laku ki te afí, ke vela ai. ");
INSERT INTO num_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kāpau 'e kotou nofo ma'u 'iā Au, pea kāpau 'e nofo ma'u Taku 'ū leá 'iā kōtou, pea neongo pe ko te ā 'e kotou loto ki aí, kotou kole, pea 'e fai ia kiā kōtou. ");
INSERT INTO num_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","'I te me'a ko iá kua fakalāngilangi'i ai Taku Tamaí, 'i te kotou fua lahí, pea 'e kotou hoko ai ko te kau ako 'A'aku. ");
INSERT INTO num_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Hangē ko te 'ofa'i 'Oku 'e te Tamaí, kua pehē Taku 'ofa'i kōtoú. Kotou nofo ma'u 'i Taku 'ofá. ");
INSERT INTO num_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kāpau 'e kotou tauhi Taku 'ū tu'utu'uní, 'e kotou nofo ma'u 'i Taku 'ofá; 'o hangē foki kua U tauhi 'e Au te 'ū tu'utu'uni mei te Tamaí, pea U nofo ma'u 'i Tana 'ofá. ");
INSERT INTO num_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ko te 'ū me'a ko 'ení 'Okou tala'i atu, kote'uhí ke 'iā kōtou Taku fiafiá, pea ke kakato ai te kotou fiafiá. ");
INSERT INTO num_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ko 'eni Taku tu'utu'uní, ke kotou fe'ofa'aki, 'o hangē ko Taku 'ofa kiā kōtoú. ");
INSERT INTO num_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","'Oku kailoa he taha 'e lahi ange tana 'ofá 'i te 'ofa ko 'eé, ke foaki Tana ma'ulí kote'uhí ko Tono 'ū kaume'á. ");
INSERT INTO num_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ko Toku 'ū kaume'a 'ia kōtou, 'o kāpau 'oku kotou fai te 'ū me'a 'Okou fekau kiā kōtoú. ");
INSERT INTO num_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ngata mei heni, 'oku kailoa ke Au kei ui 'ia kōtou ko te kau tamaio'aliki, he 'oku kala 'ilo'i 'e te tamaio'alikí 'ia te me'a 'oku fai 'e tana 'alikí; kā 'Okou ui 'ia kōtou ko Toku 'ū kaume'a, kote'uhí ko te me'a kotoa pē 'Okou fanongo ai mei Taku Tamaí, 'Okou faka'ilo ia kiā kōtou. ");
INSERT INTO num_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ne'e kailoa kotou fili 'e kōtou 'ia Au, kā ko Au ne Au fili 'ia kōtoú, pea U fakanofo 'ia kōtou, ke kotou 'alu 'o fua, pea ke nofo ma'u te kotou fuá, kote'uhiā ke 'ilonga he me'a 'e kotou kole ki te Tamaí 'i Toku hingoá, ke 'avatu 'e Ia. ");
INSERT INTO num_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ko te 'ū me'a nei 'Okou tu'utu'uni atú: ke kotou fe'ofa'aki. ");
INSERT INTO num_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Kāpau 'oku fihi'a 'e māmani kiā kōtou, manatu'i ne'e fualoa pē tana fihi'a kiā Aú 'iā kōtou. ");
INSERT INTO num_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kāpau ne'e 'o māmani 'ia kōtou, 'e 'ofa 'ia māmani ki te me'a 'a'aná. Kā kote'uhí 'oku kailoa 'o māmani 'ia kōtou, kā 'Okou fili kōtou mei māmani, ko tono 'uhinga ia 'oku fihi'a ai 'e māmani kiā kōtoú. ");
INSERT INTO num_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Manatu'i te lea ne Au fai kiā kōtoú: ‘'Oku kailoa he tamaio'aliki 'e lahi 'i tana 'alikí.’ Kāpau kua notou fakatanga'i 'Oku, 'e notou fakatanga'i 'ia kōtou foki; kāpau kua notou tauhi te lea 'A'akú, 'e notou tauhi te lea 'a kōtoú foki. ");
INSERT INTO num_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kā ko te 'ū me'a kātoa ko iá 'e notou fai kiā kōtou kote'uhí ko Toku hingoá, kote'uhí 'oku kailoa notou 'ilo'i 'ia Ia ne'e fekau mai 'Okú. ");
INSERT INTO num_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kāpau ne kala U ha'u 'o lea kiā nātou, pehē, ne'e kala he notou angahala; kā ko 'eni 'oku kailoa he 'ufi'ufi ki te notou angahalá. ");
INSERT INTO num_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ko ia 'oku fihi'a kiā Aú, 'oku fihi'a ia ki Taku Tamaí foki. ");
INSERT INTO num_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kāpau ne kailoa U fai te 'ū ngāue 'a ē kua he'iki ai fai he taha kehe 'i te notou 'aó, pehē ne kala 'i ai he notou angahala; kā ko 'eni kua notou mamata pea kua notou fihi'a kiā Au mo Taku Tamaí fakatou'osi. ");
INSERT INTO num_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ka ne'e pau ke hoko 'ia te me'a ko iá kote'uhí ke fakamo'oni'i te lea kua tohi 'i te notou laó: ‘Ne'e notou fihi'a noa pē kiā Au.’ ");
INSERT INTO num_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Kā hoko mai te Taukapó, 'a ē 'e Au fekau atu mei te Tamaí, 'io, ko te Laumālie 'o te Mo'oní, 'a ē 'e 'alu atu mei te Tamaí, 'e fakamo'oni 'e Ia kiā Au. ");
INSERT INTO num_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Pea ko te kau fakamo'oni foki 'ia kōtou, kote'uhí ne'e kotou 'iā Au mei te kamata'angá. ");
INSERT INTO num_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","'Okou lea 'aki atu 'ia te 'ū me'a nei kiā kōtou, kote'uhí ke 'aua na'a kotou tūkia. ");
INSERT INTO num_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","'E notou kapusi 'ia kōtou mei te falelotú. 'Io, 'oku 'unu mai te taimi, 'a ia kā 'i ai he taha 'e ina tāmate'i 'ia kōtou, 'e lau 'e ia kua ina fai he ngāue lelei ki te 'Atuá. ");
INSERT INTO num_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","'E notou fai pehē, kote'uhí ne'e kailoa notou 'ilo'i 'ia te Tamaí, pe ko Au. ");
INSERT INTO num_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kā 'Okou lea peheé, kote'uhí kā hokosia tono taimí pea kotou manatu'i ne Au 'osi fakahaa'i atu ia 'e Au. Pea ne'e kailoa U tala'i atu ia 'e Au mei te kamata'angá, kote'uhí ne Au 'iā kōtou 'e Au. ");
INSERT INTO num_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Kā ko 'eni, 'Okou 'alu atu kiā Ia ne Ina fekau mai 'Okú, pea 'oku kala fehu'i mai he kotou taha: ‘Ko Tau 'alú ki fea?’ ");
INSERT INTO num_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kā kote'uhí 'Okou tala'i atu te 'ū me'a ko 'ení kiā kōtou, kua fonu leva te kotou lotó 'i te mamahi. ");
INSERT INTO num_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kā ko te mo'oní 'eni 'Okou tala'i atú: 'oku lelei ange kiā kōtou Taku 'alú, he kāpau 'e kailoa U 'alu, pea 'e kailoa leva ha'u te Taukapó kiā kōtou; kae kāpau 'e Au 'alu, 'e Au fekau mai Ia kiā kōtou. ");
INSERT INTO num_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Pea kā ha'u Ia, 'e lea o'o Ia ki māmani 'i te angahalá, pea 'i te mā'oni'oní, pea 'i te fakamaaú: ");
INSERT INTO num_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","'i te angahalá, kote'uhí ko te kailoa notou tui kiā Aú; ");
INSERT INTO num_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","'i te mā'oni'oní, kote'uhí ko Taku 'alu ki te Tamaí, pea kailoa ai kotou kei sio kiā Aú; ");
INSERT INTO num_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","pea 'i te fakamaaú, kote'uhí kua fakamāu'i te 'aliki 'o te maama ko 'ení. ");
INSERT INTO num_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","'Oku kei toe lahi te me'a ke Au lea ai kiā kōtoú, kā 'e kailoa kotou lava kātaki'i 'i te taimi nei. ");
INSERT INTO num_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kā 'i te ha'u te Toko Taha ko iá, 'ia te Laumālie 'o te Mo'oní, 'e tataki 'e Ia 'ia kōtou ki te mo'oní kotoa pē. Hē 'e kailoa Ina lea 'iā Ia pē; kā ko te me'a kotoa pē 'e fanongo Ia ki ai, 'e lea 'aki 'e Ia; pea 'e Ina fakahā kiā kōtou 'ia te 'ū me'a 'oku ene ke hoko maí. ");
INSERT INTO num_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","'E fakaongoongolelei'i 'Oku 'e Ia, he 'e Ina to'o mei te me'a 'A'akú, 'o fakahaa'i kiā kōtou. ");
INSERT INTO num_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ko te me'a kotoa pē 'a te Tamaí 'oku 'A'aku ia; ko tono 'uhinga ē ne Au pehē atu ai, 'e Ina to'o mei te me'a 'A'akú 'o fakahaa'i kiā kōtou. ");
INSERT INTO num_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Toe si'i, pea kailoa kotou kei mamata kiā Au, pea toe si'i atu, pea kotou tē sio kiā Au.” ");
INSERT INTO num_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ko ia ne'e fepehē'aki ai te 'ihi 'o Tana kau akó, “Ko te ā 'eni Tana lau mai: ‘Toe si'i pea kala kotou kei mātā 'Oku, pea toe si'i atu, pea kotou tē sio kiā Au;’ pea mo Tana lau: ‘Ko Taku 'alu 'eni ki te Tamaí’?” ");
INSERT INTO num_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ko ia ai ne'e notou pehē, “Ko te ā tū te me'a ko 'ení Tana pehē, ‘Toe si'i’? 'Oku kala motou 'ilo'i pe ko Tana 'uhingá ki te ā.” ");
INSERT INTO num_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ka ne'e mea'i pē 'e Sīsū te notou fia fehu'i kiā Iá, 'o Ina pehē ange kiā nātou, “'Oku kotou fifili koā 'iā kōtou 'o kau ki Taku pehē: ‘Toe si'i pea kailoa kotou kei mātā 'Oku, pea toe si'i atu, pea kotou tē sio mai kiā Aú’? ");
INSERT INTO num_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: 'e kotou tangi mo tangilāulau, kā 'e fiafia 'ia māmani. 'E kotou mamahi, kā 'e liliu te kotou mamahí ko te koto fiafia. ");
INSERT INTO num_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kā langā he fafine 'e ongo'i mamahi ia, kote'uhí he kua hokosia tono taimí; pea kā fā'ele'i leva te tamá, 'oku kailoa toe manatu ia ki ta'aná mamahi, kote'uhí he kua fiafia ia 'i tono fanau'i mai he tangata ki māmani. ");
INSERT INTO num_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Pehē foki, 'oku kotou ma'u mamahi 'eni 'e kōtou 'i te taimi nei, kā 'e Au toe sio kiā kōtou, pea fiafia leva te kotou lotó, pea ko te kotou fiafiá 'e kailoa 'ave ia he taha meiā kōtou. ");
INSERT INTO num_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Pea 'i te 'aho ko iá 'e kala kotou tē fehu'i mai he me'a kiā Au. Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: ko te me'a kotoa pē 'e kotou kole ki te Tamaí 'i Toku hingoá, 'e 'avatu 'e Ia kiā kōtou. ");
INSERT INTO num_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kua he'iki ai kotou kole he me'a 'e taha 'i Toku hingoá, 'o a'u mai ki te taimi nei; kole, pea 'e kotou ma'u, kote'uhí ke kakato te kotou fiafiá. ");
INSERT INTO num_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ko te 'ū me'a neí 'Okou tala'i kiā kōtou 'i te 'ū lea fakatātā; 'oku 'unu mai te taimi 'a ia 'e kailoa U kei tala me'a ai kiā kōtou 'i te 'ū lea fakatātā, kā 'e Au lea fakapatonu kiā kōtou 'o kau ki te Tamaí. ");
INSERT INTO num_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","'I te 'aho ko iá, 'e kotou fai te kotou kolé 'i Toku hingoá, pea 'oku kala U pehē 'e Au fakakolekole ki te Tamaí kote'uhí ko kōtou, ");
INSERT INTO num_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","he ko te Tamaí 'oku 'ofa Ia kiā kōtou 'iā Ia pē, kote'uhiā kua kotou 'ofa kiā Au, pea kua kotou tui ne Au 'alu atu mei te Tamaí. ");
INSERT INTO num_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ne Au ha'u mei te Tamaí, pea 'Okou ha'u ki māmani; pea ko 'eni 'Okou tuku 'ia māmani kae Au 'alu ki te Tamaí.” ");
INSERT INTO num_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Pea pehē ange 'e Tana kau akó, “Tā ko 'eni kua Ke lea fakapatonu mai, pea kua kala Ke mama'i lau fakatātā. ");
INSERT INTO num_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","'Oku motou 'ilo'i 'eni kua Ke mea'i 'ia te me'a kotoa pē, pea 'oku kala 'aonga ke fehu'i he toko taha kiā Koe; ko te me'a ko iá 'oku motou tui ai ne Ke ha'u mei te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Pea tali ange 'e Sīsū kiā nātou, “'Oku kotou tui 'eni koā? ");
INSERT INTO num_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","'Ē, 'oku 'unu mai he taimi, 'io, kua hoko mai ia, 'a ia 'e vetekina ai 'ia kōtou taki taha ki to'onó 'api, pea 'e kotou si'aki 'Oku ke toko taha. Kā 'oku kala U toko taha, he ko te Tamaí 'oku 'iā Au Ia. ");
INSERT INTO num_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","'Okou tala'i atu kiā kōtou 'ia te 'ū me'a ko 'ení, kote'uhí ke kotou ma'u 'iā Au he fiamālie. 'I māmaní 'oku kotou ma'u fakamamahi, kae kotou lototo'a pē, kua U ikuna'i 'ia māmani 'e Au!” ");
INSERT INTO num_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pea kua fai 'e Sīsū 'ia te 'ū lea ko 'ení, pea hanga ake Tono fofongá ki te langí, 'o pehē, “'E Tamai, kua hokosia te taimí; ke Ke fakalāngilangi'i mu'a Tou 'Aló, kote'uhí kae fakalāngilangi'i 'Ou 'e te 'Aló foki; ");
INSERT INTO num_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","he kua Ke tuku kiā Ia te pule ki te kakai kotoa pē, kote'uhí ke foaki 'e Ia 'ia te ma'uli ta'engatá kiā nātou kotoa pē kua Ke foaki kiā Iá. ");
INSERT INTO num_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Pea ko 'eni ia 'ia te ma'uli ta'engatá: ke notou 'ilo'i 'Ou ko te 'Atua mo'oní pē taha, pea mo Sīsū Kalaisi, 'ā ē kua Ke fekau'i maí. ");
INSERT INTO num_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Kua U fakalāngilangi'i 'Ou 'i māmani, he kua U faka'osi te ngāue ne Ke tuku mai ke Au faí. ");
INSERT INTO num_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pea ko 'eni, 'e Tamai, ke Ke fakalāngilangi'i mu'a 'Oku 'e Koe fakataha mo te 'Afiona, 'aki te lāngilangi ne Au ma'u 'i te he'iki ai ke tu'u 'ia māmani, 'i Taku feangai mo Koé. ");
INSERT INTO num_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Kua U fakahaa'i Tou huafá ki te kakai ne Ke foaki mai kiā Au mei māmaní; ne'e 'O'ou 'ia nātou, pea ne Ke foaki mai 'ia nātou kiā Au; pea kua notou tauhi Tau Folafolá. ");
INSERT INTO num_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kua notou 'ilo'i 'eni ko te 'ū me'a kotoa pē ne Ke foaki maí, 'oku meiā Koe ia. ");
INSERT INTO num_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","He kua U 'osi 'avatu kiā nātou 'ia te 'ū lea ne Ke tuku mai kiā Aú; pea kua notou tali ia, pea kua notou 'ilo'i mo'oni ne Au ha'ú meiā Koe; pea kua notou tui ne Ke fekau mai 'Oku. ");
INSERT INTO num_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","'Okou lotu ma'a nātou; 'oku kailoa U lotú ma'a māmani, kae ma'a nātou pē ne Ke foaki maí, hē 'oku 'O'ou 'ia nātou. ");
INSERT INTO num_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ko Taku 'ū me'á kotoa pē 'oku 'A'au, pea 'oku 'A'aku 'ia te 'ū me'a kotoa pē 'oku 'A'aú, pea kua fakalāngilangi'i 'Oku 'iā nātou. ");
INSERT INTO num_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Pea ko 'eni, 'oku kailoa ke Au kei 'i māmani, kā 'oku 'i māmani pē 'ia nātou nei, pea ko Ta'akú 'alu atu kiā Koe. 'E Tamai Mā'oni'oni, ke tauhi mu'a 'ia nātou neí 'i Tou huafá, 'ia te huafa ne Ke tuku kiā Aú, kote'uhí ke notou taha, 'o hangē pē ko Tāuá. ");
INSERT INTO num_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Lolotonga Taku 'iā nātoú, ne Au tauhi nātou 'e Au 'i Tou huafá, 'ia te huafa ne Ke foaki mai. Kua U tauhi, pea kua kailoa mole he notou taha, ngata pē 'i te hako 'o malá, kote'uhiā pē ke fakamo'oni ki te Tohitapú. ");
INSERT INTO num_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Pea ko Taku 'alu atu 'eni kiā Koe, pea 'Okou lea pehē 'i māmani, kote'uhí ke notou ma'u kakato Taku fiafiá 'iā nātou. ");
INSERT INTO num_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Kua U tuku kiā nātou Tau Folafolá, pea kua fihi'a 'e māmani kiā nātou, kote'uhí 'oku kala notou 'o māmani, 'o hangē ko Aú, 'oku kala 'o māmani 'ia Au. ");
INSERT INTO num_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","'Oku kala U kolé, ke Ke to'o 'ia nātou mei māmani, kā ke Ke malu'i 'ia nātou mei te Filí. ");
INSERT INTO num_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","'Oku kala 'o māmani 'ia nātou, hangē ko Aú, 'oku kala 'o māmani 'ia Au. ");
INSERT INTO num_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Fakatāpui nātou 'i te mo'oní; ko te Folafola 'A'aú ko te mo'oní ia. ");
INSERT INTO num_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Hangē ne Ke fekau mai 'Oku ki māmaní, pehē foki kua U fekau'i atu 'ia nātou ki māmani. ");
INSERT INTO num_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Pea 'Okou fakatāpui 'ia Au kote'uhí ko nātou ko 'ení, kote'uhí ke fakatāpui 'ia nātou foki 'i te mo'oní. ");
INSERT INTO num_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Kā 'oku kailoa ko nātou pē ko 'ení 'oku kau ki ai Taku kolé, kā 'oku kau foki kiā nātou 'e notou tui pīkitai kiā Au 'i te notou malangá. ");
INSERT INTO num_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ko Taku kolé ke notou taha 'ia nātou kotoa pē; hangē pē ko Tau 'iā Aú, 'e Tamai, mo Au 'iā Koé, ke pehē foki te notou 'iā Tāuá, kote'uhiā pē ke tui 'e māmani ne Ke fekau'i mai 'Oku. ");
INSERT INTO num_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Pea ko te lāngilangi ne Ke tuku mai kiā Aú, kua U tuku ia kiā nātou, ke notou taha 'o hangē ko te Tā tahá: ");
INSERT INTO num_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ko Au 'iā nātou, mo Koe 'iā Au, kote'uhí ke fakahaohaoa'i 'ia nātou ke notou taha; kote'uhiā ke 'ilo'i 'e māmani ne Ke fekau'i mai 'Oku, pea kua Ke 'ofa kiā nātou, hangē pē ko Tau 'ofa kiā Aú. ");
INSERT INTO num_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","'E Tamai, ko nātou ko 'ē kua Ke foaki maí, ko Toku lotó, ko fea pē he feitu'u 'e Au 'i aí, ke notou 'i ai foki mo Au; ke notou siofia ai te lāngilangi 'O'okú, 'a ē kua Ke foaki maí; he ne Ke 'ofa kiā Au 'i te he'iki ai tanupou 'ia māmaní. ");
INSERT INTO num_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","'E Tamai mā'oni'oni, 'oku kala 'ilo'i 'Ou 'e māmani, kā kua U 'ilo'i 'Ou ia 'e Au, pea kua 'ilo'i 'e nātou ko 'ení ne Ke fekau'i mai 'Oku. ");
INSERT INTO num_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Pea kua U faka'ilo kiā nātou Tou huafá, 'io, pea 'e Au toe faka'ilo pē, kote'uhí ke 'iā nātou te 'ofa kua Ke 'ofa'i 'aki 'Okú, pea ke Au 'iā nātou foki 'e Au.” ");
INSERT INTO num_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Pea 'i te 'osi ange te folafola pehē 'ia Sīsuú, ne Ina 'alu atu mo Tana kau akó, 'o laka atu ki te tu'a vai ko Kitiloné; 'a ia ne'e tu'u ai he ngoue, pea ne Ina 'alu atu ki ai, mo Tana kau akó. ");
INSERT INTO num_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Pea ko Siutasi foki, ko Tono lavakí, ne ina 'ilo ki te feitu'u ko iá, he ne'e fa'a fakataha ki ai 'e Sīsū mo Tana kau akó. ");
INSERT INTO num_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Pea kua ma'u leva 'e Siutasi 'ia te vāhenga taú, mo he kau le'o Temipale mei te kau taula'aliki lahí mo te kau Fālesí, pea ha'u ia ki te feitu'u ko iá mo te 'ū tūhulu mo te 'ū maama mo te mahafu. ");
INSERT INTO num_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pea ne'e mea'i 'e Sīsū 'ia te 'ū me'a kotoa pē 'e hoko kiā Iá, pea hā'ele atu Ia, 'o folafola ange kiā nātou, “Ko ai ia 'oku kotou kumí?” ");
INSERT INTO num_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Pea notou tali ange, “Ko Sīsū mei Nāsaletí.” Pea folafola ange 'e Sīsū kiā nātou, “Ko Au 'eni.” (Pea ne'e tu'u mo nātou foki 'ia Siutasi ko Tono lavakí.) ");
INSERT INTO num_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pea 'i Tana me'a leva kiā nātou, 'o pehē, “Ko au 'ení,” ne'e notou holomuli, 'o tō ki te kelekelé. ");
INSERT INTO num_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Pea toe fehu'i ange Ia kiā nātou, “Ko ai ia 'oku kotou kumí?” Pea notou iange, “Ko Sīsū mei Nāsaletí.” ");
INSERT INTO num_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Pea tali ange 'e Sīsū, “Ne Au 'osi iatu kiā kōtou, ko Au 'eni. Ko ia kāpau ko Au 'oku kotou kumi ki aí, pe'i tukuange 'ia nātou nei ke notou 'alu.” ");
INSERT INTO num_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ko te fai 'ení kote'uhí ke fakamo'oni ki te Folafola ne'e fai 'e Ia, 'o pehē, “Ko nātou kua Ke foaki maí, 'e kala U tuku he notou taha ke mole.” ");
INSERT INTO num_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Pea ko Saimone Pita, 'ā ē kua ne ma'u heletaá, ne'e unuhi 'e ia, 'o taa'i te tamaio'aliki 'a te Taula'aliki Lahí, 'o tu'usi tono lau'i talinga to'omata'ú. Ko te hingoa 'o te tamaio'alikí ko Malikusi. ");
INSERT INTO num_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pea me'a ange 'e Sīsū kiā Pita, “'Ai tau heletaá ki tono 'ai'angá; ko te ipu kua tuku mai kiā Au 'e Taku Tamaí, 'e kala koā ke Au inu ia?” ");
INSERT INTO num_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Pea ko te vāhenga taú mo te 'alikitaú mo te kau le'o Temipale 'a te ha'a Siú ne'e notou puke 'ia Sīsū, 'o ha'i Ia, ");
INSERT INTO num_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","'o notou fu'aki taki 'Ona kiā 'Ānasi, he ko te tamai ia 'a te hoa 'o Kaiafasí, 'a ia ne'e Taula'aliki Lahi 'i te ta'u ko iá. ");
INSERT INTO num_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Pea ko Kaiafasi foki ia ne'e tala ki te kau Siú, 'o pehē, “Ko tono leleí ke mate he tangata 'e taha kote'uhí ko te kakaí.” ");
INSERT INTO num_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Pea ne'e mulimuli atu 'ia Saimone Pita kiā Sīsū, pea mo te tama ako 'e taha. Pea ko te tama ako ko iá ne'e maheni ia mo te Taula'aliki Lahí, pea ne'e hū fakataha ia mo Sīsū ki te loto'ā 'o te Taula'aliki Lahí. ");
INSERT INTO num_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ka ne'e tu'u 'ia Pita 'i tu'a, 'i te matapaá. Pea 'alu atu 'ia te tama ako 'e tahá, 'a ē ne'e maheni mo te Taula'aliki Lahí, 'o lea ki te fafine ne'e le'o matapaá, 'o fakahū mai 'ia Pita. ");
INSERT INTO num_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pea lea ai kiā Pita 'e te kaunanga ne'e le'o matapaá, “'Oku kailoa koā ko te taha 'ia koe 'i te kau ako 'a te Tangata nā?” Pea iange 'e ia, “'Oku kailoa.” ");
INSERT INTO num_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Pea ne'e tutu'u 'i ai 'ia te kau tamaio'alikí mo te kau le'o Temipalé, kua notou tafu he afi malala, he ne'e momoko; pea notou mūmū 'i ai. Pea ne'e 'iā nātou 'ia Pita foki, 'oku tu'u 'i ai 'o mūmū. ");
INSERT INTO num_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pea fakafehu'i 'e te Taula'aliki Lahí kiā Sīsū, 'o kau ki Tana kau akó, pea mo Tana tokāteliné. ");
INSERT INTO num_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Pea tali ange 'e Sīsū kiā ia, “Kua U lea fakapatonu ki māmani; ko Taku akó ne'e fai ma'u pē 'i te falelotu, pea 'i te Temipalé, 'ā ē 'oku fakataha ki ai 'ia te ha'a Siú kotoa pē. Pea ne'e kailoa ke Au fai fakapulipuli he me'a 'e taha. ");
INSERT INTO num_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ko te ā 'oku fehu'i mai ai 'e koe kiā Aú? Fehu'i pē kiā nātou kua notou fanongo kiā Aú, pe ko te ā Taku lea ne'e fai kiā nātoú; 'ē, 'oku 'ilo'i lelei 'e nātou nei 'ia te 'ū me'a kua U lea 'akí.” ");
INSERT INTO num_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pea 'i Tana lea peheé, ne'e pēkalae'i 'Ona 'e te toko taha 'i te kau le'o Temipalé, 'o iange, “'Oku pehē koā Tau tali ki te Taula'aliki Lahí?” ");
INSERT INTO num_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Pea tali ange 'e Sīsū kiā ia, “Kāpau kua kovi Si'aku lea, pe'i fakahaa'i te koví; kae kāpau kua lelei, ko te ā kua ke taa'i ai 'Okú?” ");
INSERT INTO num_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Pea fekau 'e 'Ānasi ke 'ave ha'isia 'Ona kiā Kaiafasi ko te Taula'aliki Lahí. ");
INSERT INTO num_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pea ne'e tu'u 'ia Saimone Pita, 'o mūmū. Pea notou pehē kiā ia, “'Oku kala koā ko te toko taha koe 'i Tana kau akó?” Kā ne fakafisi 'e ia, 'o iange, “'Oku kailoa.” ");
INSERT INTO num_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pea ko te toko taha 'i te kau tamaio'aliki 'a te Taula'aliki Lahí, ko te kāinga 'o ia ne'e tu'usi 'e Pita tono talingá, ne'e iange ia, “Ne kailoa koā ke au mātu'aki sio kiā koe 'i te ngoué fakataha mo Ia?” ");
INSERT INTO num_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pea toe fakafisi pē 'ia Pita. Pea 'u'ua leva 'ia te moá. ");
INSERT INTO num_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pea notou taki ai 'ia Sīsū mei te fale 'o Kaiafasí ki te palasí. Pea ne'e kei hengihengi; pea ne'e kailoa notou hū 'e nātou ki te Palasí, kote'uhí na'a notou ta'ema'a ai, ke notou kai 'ia te Pāsová. ");
INSERT INTO num_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pea 'alu atu 'ia Pailato ki tu'a kiā nātou, 'o iange, “Ko te ā te me'a 'oku kotou talatalaaki'i 'aki te tangata nei?” ");
INSERT INTO num_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Pea notou tali 'o pehē kiā ia, “Kā ne kala ko te Siana faikovi Ia, 'e kala motou tukuange 'Ona kiā koe.” ");
INSERT INTO num_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pea tali ange 'e Pailato kiā nātou, “Pe'i 'ave Ia 'e kōtou, pea kotou fakamāu'i 'Ona 'o fakatatau ki te kotou laó.” Ko ia ne'e lea ai 'e te kakai Siú kiā ia, “Kā 'oku kailoa ngafua ke motou tāmate'i he taha.” ");
INSERT INTO num_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ko te fai pē ke fakamo'oni ki te folafola 'a Sīsū, 'a ē ne'e fa'a fai 'e Ia, 'i Tana fakahā atu te mate'anga 'e pekia ai Iá. ");
INSERT INTO num_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ko ia ne'e toe hū 'ia Pailato ki te Palasí, 'o ui ange 'ia Sīsū, 'o iange ki Ai, “Ko te Tu'i Koe 'o te kakai Siú?” ");
INSERT INTO num_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Pea tali 'e Sīsū, “Ko tau lea peheé 'iā koe pē, pe 'oku 'i ai he 'ihi kua notou fakahā pehe'i 'Oku kiā koe?” ");
INSERT INTO num_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pea tali 'e Pailato, “He ko te Siu 'ia au? Ko To'oú pē kakai mo te kau taula'aliki lahí kua notou tuku mai 'Ou kiā aú. Ko te ā kua Ke fai?” ");
INSERT INTO num_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Pea tali ange 'e Sīsū, “Ko To'okú pule'anga 'oku kailoa 'o te maama ko 'ení. Ka ne 'o te maama ko 'ení Toku pule'angá, pehē 'e tau Ha'akú kau tau ke ta'ofi tono tukuange 'Oku ki te ha'a Siú. Kā ko 'eni, ko Toku pule'angá 'Oku, 'oku kailoa 'o 'eni.” ");
INSERT INTO num_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pea lea ai 'e Pailato kiā Ia, “Pea tā ko te tu'i 'ia Koe?” Pea tali 'e Sīsū, “Ko ia pē 'oku Ke me'a 'akí: ko te tu'i 'ia Au. Ko te me'a ko iá ne'e fanau'i ai 'Okú, pea ko te me'a ko iá kua U ha'u ai ki māmaní, kote'uhí ke Au fakahaa'i 'ia te mo'oní. Ko ia kotoa pē 'oku 'o te mo'oní 'oku tokanga ki Toku le'ó.” ");
INSERT INTO num_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pea pehē ange 'e Pailato kiā Ia, “Ko te ā tū 'ia te mo'oni?” Pea 'i tana lea peheé, ne'e tē 'alu ia ki tu'a ki te kakai Siú, 'o iange kiā nātou, “'Oku kailoa 'aupito ke au mama'i 'ilo'i he kovi 'a te Tangata nei. ");
INSERT INTO num_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kā 'oku 'i ai te kotou anga-maheni, ke au vete atu kiā kōtou he pōpula 'e taha 'i te Pāsová. Pea ko te kotou lotó koā ia ke au vete atu 'ia te Tu'i Siú?” ");
INSERT INTO num_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Pea toe kalanga 'ia nātou fuli pē, 'o pehē, “'Aua 'e tuku mai 'ia te Siana nā, kā ko Palāpasa!” Pea ko Palāpasá ko te tangata kaiha'a ia. ");
INSERT INTO num_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pea toki puke leva 'e Pailato 'ia Sīsū, 'o kau'imaea'i. ");
INSERT INTO num_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pea ne'e fī 'e te kau sōtiá he kalauni talatala, 'o 'ai takai ki Tono fofongá, pea notou 'ai leva kiā Ia he pulupulu kulakula, ");
INSERT INTO num_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","'o notou lau, “'Ēī, Tu'i 'o te kakai Siú!” Pea notou pēkalae'i 'Ona 'aki te notou nimá. ");
INSERT INTO num_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pea toe 'alu atu ai 'ia Pailato ki tu'a kiā nātou, 'o pehē ange, “Ko 'eni 'okou 'aumai 'Ona ki tu'a kiā kōtou, kote'uhí ke kotou 'ilo'i 'oku kala u 'ilo'i Hana mama'i hia 'e taha mātē.” ");
INSERT INTO num_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Pea ha'u leva 'ia Sīsū ki tu'a, kua 'ai kiā Ia te kalauni talatala, mo te pulupulu kulakula. Pea lea ange 'e Pailato kiā nātou, “Ko te tangatá 'ena!” ");
INSERT INTO num_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pea 'i te mamata leva kiā Sīsū 'e te kau taula'aliki lahí mo te kau le'o Temipalé, ne'e notou fekālanga'i 'o pehē, “Kalusefai Ia! Kalusefai Ia!” Pea lea ange 'e Pailato kiā nātou, “Pe'i kotou 'ave Ia 'o kalusefai 'e kōtou; 'oku kailoa 'aupito ke au 'ilo'i 'e au ha'a Nā hia.” ");
INSERT INTO num_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pea tali kiā ia 'e ha'a Siú, “Kā 'oku 'i ai te motou lao ia 'a mātou, pea 'i te lao ko iá 'oku totonu 'ia Ia ke mate, kote'uhí ne Ina lau 'o pehē: ko te 'Alo Ia 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pea 'i te fanongo leva 'e Pailato ki te Folafola ko iá, ne'e fakautuutu ai tana manaheé; ");
INSERT INTO num_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","pea toe hū ia ki te palasí, 'o fehu'i ange kiā Sīsū, “Mei fea tū 'ia Koe?” Ka ne'e kailoa toe fai 'e Sīsū ia he mama'i lea kiā ia. ");
INSERT INTO num_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pea pehē ange 'e Pailato kiā Ia, “'Oku kailoa Ke lea mai kiā au koā? 'Oku kala koā Ke 'ilo'i 'okou mafai ke tukuange, pea 'okou mafai foki ke kalusefai 'ia Koe?” ");
INSERT INTO num_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Pea tali ange 'e Sīsū kiā ia, “'Oku kailoa 'aupito ha'aú ia mafai kiā Au, ka ne ta'e'aua pē tono tuku kiā koe mei lungá; ko ia ai 'oku lahi ange te angahala 'a'ana ne'e tukuange atu 'Oku kiā koé.” ");
INSERT INTO num_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pea talu mei ai mo te feinga 'e Pailato ke tukuange 'Ona, kae fekālanga'i pē 'ia te kakai Siú ia 'o pehē, “Kāpau 'e ke tukuange 'ia te Siana ko 'ená, pea tā 'oku kala ko he tākanga koe 'o Sisa; he kā 'i ai he taha kua lau 'ona ko he tu'i, 'oku lea kovi ia kiā Sisa.” ");
INSERT INTO num_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pea 'i te fanongo leva 'e Pailato ki te 'ū lea ko iá, ne'e taki atu 'e ia 'ia Sīsū ki tu'a, kae nofo ifo ia ki te nofo'anga fakamaaú 'i te feitu'u 'oku ui ko “Falikimaka”, kā 'i te lea faka-Hepeluú ko “Kapata”. ");
INSERT INTO num_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pea ko te 'aho Tokonaki ia, ko te teuteu ki te Pāsová; pea kua mei ho'atā mālie. Pea pehē 'e ia ki te ha'a Siú, “Ko 'ena te kotou Tu'í!” ");
INSERT INTO num_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pea fekālanga'i leva te kakaí, “Tafi'i Ia! Tafi'i Ia! Kalusefai 'Ona!” Pea iange 'e Pailato kiā nātou, “Ke au kalusefai koā te kotou Tu'í?” Pea tali ange 'e te kau taula'aliki lahí, “'Oku kailoa he motou tu'i, ko Sisa pē!” ");
INSERT INTO num_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pea toki tukuange 'e ia 'ia Sīsū kiā nātou ke kalusefai. Ko ia ne'e notou ma'u leva 'ia Sīsū 'o taki atu. ");
INSERT INTO num_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Pea fua 'e Ia Tono kolosí, 'o 'alu atu ki te feitu'u 'oku ui ko “'Ulupoko”, kā 'i tono ui faka-Hepeluú ko “Kolokota”. ");
INSERT INTO num_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Pea ne'e notou kalusefai 'Ona 'i ai, mo te toko ua kehe, 'o nā taki taha te ongo tafa'akí, kae 'i loto 'ia Sīsū. ");
INSERT INTO num_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pea ne'e tohi 'e Pailato he tohi fakamatala, 'o 'ai ki te funga kolosí. Pea ne'e tohi'i ai 'o pehē, “KO SĪSŪ 'O NĀSALETI, KO TE TU'I 'O TE KAKAI SIU.” ");
INSERT INTO num_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Pea ne'e lau te tohi fakamatala ko iá 'e te tokolahi 'o te kakai Siú, he ne'e ofi ki kolo 'ia te feitu'u ne'e kalusefai ai 'ia Sīsuú; pea ne'e tohi foki ia 'i te lea faka-Hepeluú mo te lea faka-Lomá, mo te lea faka-Kalisí. ");
INSERT INTO num_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ko ia ne'e lea ai kiā Pailato 'e te kau taula'aliki lahi Siú 'o notou iange, “'Aua 'e ke tohi: ‘Ko te Tu'i Siu,’ kā ke tohi 'o pehē: ‘Ne'e pehē 'e Ia, Ko te tu'i Siu 'ia Au.’ ” ");
INSERT INTO num_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pea tali ange 'e Pailato, “Ko te me'a kua tohí, kua tohi.” ");
INSERT INTO num_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Pea 'i te 'osi ange tono kalusefai 'e te kau sōtiá 'ia Sīsuú, ne'e notou to'o leva Tono 'ū kofú, 'o notou vahe fā, 'o taki taha te sōtia tana vahe; pea pehē foki mo Tono kofu tu'á. Kā ko te anga te kofu tu'á, ne'e kailoa he hoko'anga, ka ne'e lalanga fua pē mei lunga ki lalo. ");
INSERT INTO num_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ko ia ne'e notou fepehē'aki, “'Aua na'a tou hae iá, kae tou talotalo ki ai, pē 'e 'o ai ia.” Ne'e hoko te me'a nei ke fakamo'oni ki te Folafola ne pehē, “Ne'e notou tufa kiā nātou Toku kofú, pea notou talotalo ki Toku kofu tu'á.” Ne'e pehē 'ia te ngāue 'a te kau sōtiá. ");
INSERT INTO num_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Pea ne'e tutu'u 'i te tafa'aki kolosi 'o Sīsuú Tana fa'eé, mo te tokoua 'o Tana fa'eé, mo Mele ko te hoa 'o Kaliopasí, mo Mele mei Makitalá. ");
INSERT INTO num_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Pea 'i te vakai atu 'e Sīsū ki Tana fa'eé, mo te tu'u ai te tama ako ne'e 'ofa aí, pea folafola 'e Ia ki Tana fa'eé, “Fafine, ko 'ena tou foha!” ");
INSERT INTO num_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Pea toe folafola 'e Ia ki te tama akó, “Ko 'ena tau fa'ē!” Pea mei te taimi ko iá ne'e 'ave 'e te tama akó 'ia te fafiné, ki tono 'apí. ");
INSERT INTO num_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pea 'i te 'osi ange 'ení, pea 'i te mea'i 'e Sīsū kua 'osi Tana fakakakato 'ia te me'a kotoa pē, pea kote'uhí ke fakamo'oni ki te Tohitapú, ne'e folafola mai 'e Ia, “'Okou fiainua!” ");
INSERT INTO num_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Pea ne'e tu'u 'i ai he ipu kua fonu 'i te vinika: ko ia ne'e notou unu he oma 'i te va'a 'īsope kua fonu 'i te viniká, 'o notou 'avake ki Tono fofongá. ");
INSERT INTO num_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Pea 'i te ma'u leva 'e Sīsū te viniká, ne'e folafola Ia, “Kua 'osi,” pea punou leva Tono fofongá, 'o tuku ake Tono laumālié. ");
INSERT INTO num_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pea ko te 'aho Tokonaki ia; ko ia ne'e feinga leva 'e te kau Siú ke 'aua na'a tautau 'i te kolosí he 'ū 'anga'anga 'i te 'aho Sāpaté (he ko te 'aho lahi te Sāpate ko iá). Pea notou kole kiā Pailato ke fasi'i te notou 'ū va'é, pea toki 'ave 'ia nātou. ");
INSERT INTO num_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ko ia ne'e ōmai te kau sōtiá, 'o notou fasi'i te kauva'e 'o te 'uluakí, pea mo te kauva'e 'o te siana 'e tahá 'a ē ne'e kaungā kalusefai mo Iá. ");
INSERT INTO num_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kā 'i te notou a'u atu kiā Sīsū, 'o vakai kua pekia Iá, ne'e kailoa leva notou fasi'i Tono va'é. ");
INSERT INTO num_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kā ko te toko taha 'o te kau sōtiá ne'e hoka'i 'e ia Tono vakavaká 'aki tono taó, pea ne'e tafe mei ai he ta'ata'a mo he vai. ");
INSERT INTO num_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Pea ko ia ne'e mamata ki aí kua 'osi fakamo'oni ia ki ai, pea ko tana fakamo'oní 'oku mo'oni; pea 'oku 'ilo'i 'e te toko taha ko iá 'oku mo'oni pē tana leá, kote'uhiā ke kotou tui foki. ");
INSERT INTO num_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","He ne'e hoko 'ia te 'ū me'a ko 'ení ke fakamo'oni'i te Tohitapú, 'a ia 'oku pehē 'i ai, “'E kailoa maumau he hui 'e taha 'O'ona.” ");
INSERT INTO num_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Pea 'oku pehē mo te tohi 'e taha, “'E notou mamata kiā Ia kua notou hoka'í.” ");
INSERT INTO num_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pea 'i te 'osi ange te 'ū me'a ko iá, ne'e 'alu fakafufū atu 'ia Siosifa mei 'Alemateá, ko te tama ako 'a Sīsū, ko tana manahē ki te ha'a Siú, 'o ina kole ange kiā Pailato ke 'ave 'e ia te sino 'o Sīsuú. Pea ne'e loto ki ai 'ia Pailato. Ko ia ne'e ha'u ia 'o 'ave te sino 'o Sīsuú. ");
INSERT INTO num_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Pea ne'e ha'u foki mo Nikotīmasi, ('ā ē ne'e ha'u pō'uli kiā Ia 'i te kamata'angá) mo he mula mo te 'ālosi kua fetuiaki, fe'unga nai tono mamafá mo te pāuni 'e teau. ");
INSERT INTO num_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ko ia ne'e notou to'o te sino 'o Sīsuú, 'o kofu 'aki he 'ū tupenu, pea 'ai fakataha ai pē mo te 'ū me'a fakanamulelei, he ko te anga ia 'o te teu pekia 'o te ha'a Siú ki fa'itoká. ");
INSERT INTO num_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Pea ne'e tu'u 'ia te feitu'u ne'e kalusefai ai 'ia Iá he ngoue; pea ne'e 'i te ngoué he fanualoto fo'ou, 'a ia kua he'iki ai telio ai he taha. ");
INSERT INTO num_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Pea kote'uhí ko te 'aho Tokonaki ia 'o te ha'a Siú, mo te ofi mai 'ia te fanualotó, ko ia ai ne'e notou telio 'ia Sīsū 'i te feitu'u ko iá. ");
INSERT INTO num_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","'I te fu'aki 'aho 'o te uiké, ne'e ha'u hengihengi 'ia Mele mei Makitalá ki te fanualotó, kei pō'uli, 'o vakai atú, tā kua to'o te maká mei te fanualotó. ");
INSERT INTO num_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Pea lele leva ia, 'o 'alu kiā Saimone Pita, mo te ākonga 'e taha, 'ā ē ne'e 'ofa ai 'ia Sīsuú, 'o iange kiā nāua, “Kua notou 'ave te 'Alikí mei te fanualotó, pea 'oku kala motou 'ilo'i pe kua notou tuku 'Oná ki fea.” ");
INSERT INTO num_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ko ia ne'e 'alu atu ai 'ia Pita ki tu'a mo te ako 'e tahá, 'o nā ō ki te fanualotó. ");
INSERT INTO num_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Pea nā felele'i fakataha; pea ne'e vave te lele 'ia te ako 'e tahá 'iā Pita, 'o fu'aki a'u ia ki te fanualotó. ");
INSERT INTO num_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Pea punou ia 'o vakai atu, tā 'oku tuku lelei pē te 'ū tupenú, kā ne kailoa ulu ia ki ai. ");
INSERT INTO num_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kae mulimuli atu pē 'ia Saimone Pita, 'o ulu ki te fanualotó, 'o sio ki te 'ū tupenu ne'e tuku 'i aí, ");
INSERT INTO num_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","mo te holoholo ko 'ē ne'e 'ai ki Tono fofongá, ne'e kailoa tuku fakataha mo te 'ū tupenú, kā kua fatufatu ia 'o tuku ki te tuliki kehe. ");
INSERT INTO num_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Pea toki ulu leva ki ai mo te ākonga 'e tahá, 'a ē ne'e fu'aki a'u ki te fanualotó, pea sio ia ki ai 'o tui. ");
INSERT INTO num_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","He kua he'iki ai mahino kiā nātou 'ia te Folafola ne'e pehē, kua pau ke toetu'u Ia mei te pekiá. ");
INSERT INTO num_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pea toe foki leva te ongo ākongá ki 'api. ");
INSERT INTO num_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kae tu'u ai pē 'ia Mele 'i te tu'a fanualotó, 'o tangi; pea lolotonga tana tangí, ne'e punou ia ke sio ki te fanualotó. ");
INSERT INTO num_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Pea vakai atu ia ki te ongo 'āngelo kofu hinahina 'oku nā nonofo maí, ko te taha mei 'ulu, mo te taha mei va'e, 'i te feitu'u ne'e fakatakoto ai 'ia te sino 'o Sīsuú. ");
INSERT INTO num_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Pea lea ange te ongo me'á kiā ia, “'E fafine, ko te ā 'oku ke tangi aí?” Pea iange 'e ia kiā nāua, “Kua notou 'ave toku 'Alikí, pea 'oku kailoa u 'ilo'i pe kua notou tuku 'Oná ki fea.” ");
INSERT INTO num_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Pea 'i te 'osi ange tana lea peheé, ne'e tafoki ia ki muli, 'o vakai atu kiā Sīsū 'oku tu'u maí, ka ne'e kala 'ilo'i ia 'e ia ko Sīsū. ");
INSERT INTO num_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Pea me'a ange 'e Sīsū kiā ia, “'E fafine, ko te ā 'oku ke tangi aí? Ko ai 'oku kumi 'e koe ki aí?” Pea mahalo 'e Mele ko te tauhi ngoué Ia, 'o iange kiā Ia, “'Aliki, kāpau ko Koe kua Ke 'ave Iá, pe'i tala'i mai te feitu'u kua Ke tuku 'Ona ki aí, kae au 'ave Ia 'e au.” ");
INSERT INTO num_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Pea toki folafola ange 'e Sīsū kiā ia, “Mele!” Pea tafoki ange ia, 'o pehē ange 'i te lea faka-Hepeluú, “Lāponai!” (ko tono 'uhingá, “'E Faiako!”) ");
INSERT INTO num_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Pea folafola ange 'e Sīsū kiā ia, “'Aua na'a ala mai kiā Au, he kua he'iki ai ke Au 'alu ake ki te Tamaí; kā ke 'alu leva ki Toku 'ū tokouá, 'o tala kiā nātou 'o pehē: ‘Ko Taku 'alu 'eni ki Taku Tamaí pea ko te kotou Tamai, pea ki Toku 'Atuá mo te kotou 'Atua.’ ” ");
INSERT INTO num_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ko ia ne'e ha'u 'ia Mele mei Makitalá, 'o fakahā ki te kau akó tana mamata ki te 'Alikí, pea mo Tana folafola pehē mo pehē kiā iá. ");
INSERT INTO num_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pea 'i te afiafi ko iá, 'i te fu'aki 'aho 'o te uiké, pea kua tātāpuni 'ia te 'ū matapā 'i te fale ne'e nofo ai 'ia te kau akó, he ne'e notou manahē ki te kau Siú, ne'e ha'u 'ia Sīsū, 'o tu'u ki te notou ha'oha'ongá, 'o folafola kiā nātou, “Ke 'iā kōtou 'ia te melinó.” ");
INSERT INTO num_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pea 'i Tana lea peheé, ne'e faka'ali'ali ange Ia kiā nātou Tono ongo nimá mo Tono vakavaká. Pea toki fiafia lahi 'ia te kau akó 'i te notou mamata ki te 'Alikí. ");
INSERT INTO num_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Pea toe folafola 'e Sīsū kiā nātou, “Ke 'iā kōtou 'ia te melinó; hangē ko tono fekau mai 'Oku 'e te Tamaí, pehē kua U fekau atu 'ia kōtou 'e Au.” ");
INSERT INTO num_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Pea 'osi ange Tana lea peheé, ne'e hō Ia kiā nātou, mo folafola ange, “Kotou ma'u ā 'ia te Laumālie Mā'oni'oní. ");
INSERT INTO num_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kāpau 'e kotou fakamolemole'i te hia 'a te 'ihi, kua fakamolemole'i ia; kāpau 'e kotou tuku te hia 'a te 'ihi, kua tuku pē ia.” ");
INSERT INTO num_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Kā ko Tōmasi, ko te toko taha 'i te kau hongofulu mā uá, 'a ē ne'e ui ko Titimasí, ne'e kala 'i ai ia 'i te ha'u 'ia Sīsuú. ");
INSERT INTO num_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ko ia ne'e lea kiā ia he 'ihi 'o te kau akó, “Kua motou mamata mātou ia ki te 'Alikí!” Kae pehē ange 'e ia kiā nātou, “Kā kailoa u sio 'i Tono ongo nimá ki te mata fa'ó, mo velo toku tuhú ki te mata fa'ó, mo velo toku nimá ki Tono vakavaká, 'e kailoa 'aupito tui 'eni ia.” ");
INSERT INTO num_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pea 'osi mei ai te 'aho 'e valu, ne'e toe nofo 'i te loto falé Tana kau akó, pea ne'e 'iā nātou 'ia Tōmasi. Ha'u pē 'ia Sīsū, kua tāpuni te 'ū matapaá, 'o tu'u 'i te notou ha'oha'ongá, 'o pehē ange, “Ke 'iā kōtou 'ia te melinó.” ");
INSERT INTO num_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Pea pehē ange 'e Ia kiā Tōmasi, “'Ai mai tou tuhú, 'o vakai Toku ongo nimá; pea 'ai mai tou nimá, 'o velo ki Toku vakavaká; pea 'aua na'a ke ta'etui, kae tui.” ");
INSERT INTO num_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Pea toki tali ange 'e Tōmasi 'o pehē kiā Ia, “Ko toku 'Alikí pē, mo toku 'Atuá!” ");
INSERT INTO num_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Pea folafola ange 'e Sīsū kiā ia, “'E Tōmasi, kua ke tui koā kote'uhí ko tau mamata kiā Aú? 'Oku manū'ia pē 'ia nātou ne'e kailoa mamata, kae notou tuí.” ");
INSERT INTO num_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Pea ne'e lahi foki mo te 'ū faka'ilonga mana kehekehe ne'e feia 'e Sīsū 'i te 'ao 'o te kau akó, 'a ia 'oku kala tohi 'i te tohi nei; ");
INSERT INTO num_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","kā kua tohi 'ení kote'uhí ke kotou tui ko Sīsuú ko te Kalaisí Ia, ko te 'Alo 'o te 'Atuá, pea 'i te kotou tuí ke kotou ma'u ma'uli 'i Tono huafá. ");
INSERT INTO num_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pea 'i te 'osi ange 'ení, ne'e tē fakahaa'i 'e Sīsū 'Ona ki te kau akó 'i te Tai 'o Taipilió, pea ko 'eni tono angá: ");
INSERT INTO num_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ne'e 'i ai 'ia Saimone Pita, mo Tōmasi 'ā ē ne'e ui ko Titimasí, mo Nātaniela mei Kena 'i Kālelí, mo te ongo foha 'o Sēpetí, mo te toko ua kehe 'o Tana kau akó. ");
INSERT INTO num_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Pea iange 'e Saimone Pita kiā nātou, “'E au 'alu au 'o tautai.” Pea notou iange kiā ia, “'Ē, tou ō mo mātou.” Pea notou ō atu leva 'o heka vaka; pea 'i te pō ko iá ne'e kailoa 'aupito notou ma'u he me'a. ");
INSERT INTO num_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Pea 'i te pongipongi aké, ne'e tu'u mai 'ia Sīsū 'i te matātaí, ka ne'e kailoa 'aupito 'ilo'i 'e te kau akó ko Sīsū ia. ");
INSERT INTO num_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Pea lea ange 'e Sīsū kiā nātou, “Tamaliki, 'oku 'i ai he kotou kiki?” Pea notou tali ange, “Kailoa.” ");
INSERT INTO num_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Pea ui mai 'e Ia kiā nātou, “'A'au te kupengá ki te mata'u 'o te vaká, pea 'e kotou ma'u.” Pea notou 'a'au te kupengá 'i ai, pea ne'e kailoa lava ke notou toho te kupengá kote'uhí ko te lahi 'o te iká. ");
INSERT INTO num_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ko ia ne'e lea ange kiā Pita 'e te ākonga ne'e 'ofa ai 'ia Sīsuú, “Ko te 'Alikí ia.” Pea 'i te fanongo 'e Saimone Pita ko te 'Alikí iá, ne'e nono'o 'e ia tono kofu tautaí (he ne'e vete ia,) 'o hopo ki tai. ");
INSERT INTO num_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Kae toki ōmai te toenga 'o te kau akó 'i te ki'i vaká, (he ne'e kala notou loko mama'o mei 'uta, fe'unga nai mo te kiupite 'e uangeau,) 'o notou taulani'i mai te kupengá mo te iká. ");
INSERT INTO num_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pea 'i te notou a'u mai ki 'utá, ne'e notou vakai ki te afi malala kua tafu, mo te mata'i ika kua tunu 'i ai, mo te fe'i mā. ");
INSERT INTO num_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Pea me'a ange 'e Sīsū kiā nātou, “To'o mai he me'a mei te kotou ika kua toki ma'ú.” ");
INSERT INTO num_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Pea tē heka 'ia Saimone Pita ki te vaká, 'o toho mai te kupengá ki 'uta, kua fonu 'i te 'ū ika lalahi, ko tono laú ko te ika 'e teau nimangofulu mā tolu. Pea neongo tana lahí, ka ne'e kailoa mahae ai te kupengá ia. ");
INSERT INTO num_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Pea me'a ange 'e Sīsū kiā nātou, “Kotou ōmai ā 'o kai.” Pea ne'e kailoa 'aupito he taha 'i te kau akó 'e lava ke 'eke ange kiā Ia 'o pehē, “Ko ai tū 'ia Koe?” He ne'e notou 'ilo'i ko te 'Alikí pē Ia. ");
INSERT INTO num_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Pea me'a mai 'e Sīsū, 'o to'o te fe'i maá, 'o 'avange kiā nātou, mo te mata'i iká foki. ");
INSERT INTO num_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ko te tu'a tolu 'eni te hā 'ia Sīsū ki Tana kau akó, hili ange Tana toetu'u mei te pekiá. ");
INSERT INTO num_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pea kua 'osi te notou kaí, pea me'a ange 'e Sīsū kiā Saimone Pita, “Saimone, foha 'o Sione, 'oku ke 'ofa kiā Au 'o lahi ake 'iā nātou ko 'ení?” Pea tali ange 'e Pita, “'Io, 'Aliki; kua Ke mea'i pē 'okou 'ofa kiā Koe.” Pea folafola Ia kiā Pita, “Fafanga Taku fanga lamí.” ");
INSERT INTO num_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Pea tē me'a ange 'e Sīsū kiā ia, ko tono tu'a uá, “Saimone, foha 'o Sione, 'oku ke 'ofa kiā Au?” Pea iange 'e Pita, “'Io, 'Aliki; kua Ke mea'i 'okou 'ofa kiā Koe.” Pea folafola Ia kiā Pita, “Fafanga Taku fanga sipí.” ");
INSERT INTO num_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Pea tē me'a 'e Ia kiā Pita, ko tono tu'a tolú, “Saimone, foha 'o Sione, 'oku ke 'ofa kiā Au?” Pea mamahi 'ia Pita 'i te tu'a tolu Tana fehu'i mai 'o pehē, “'Oku ke 'ofa kiā Au?” Pea iange leva 'e ia, “'Aliki, 'oku Ke mea'i te me'a kotoa pē; kua Ke mea'i 'okou 'ofa kiā Koe.” Pea folafola ange 'e Sīsū kiā ia, “Fafanga Taku fanga sipí. ");
INSERT INTO num_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ko te mo'oni, ko te mo'oni, 'Okou tala'i atu: lolotonga tau kei talavoú, ne ke nono'o 'ia koe, pea ke 'eva'eva he feitu'u pē 'e ke loto ki aí, kae kāpau 'e ke matu'a, 'e ke mafao atu leva tou ongo nimá, kae nono'o 'ou he taha kehe, pea 'e 'ave 'ou ki te feitu'u 'e kala ke loto ki aí.” ");
INSERT INTO num_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ne'e lea pehē Iá, ko Tana fakatātā atu te anga 'o te mate'anga 'e ina fakaongoongolelei'i ai 'ia te 'Atuá. 'Osi ange Tana lea ko iá, pea toki folafola ange 'e Ia, “Mulimuli mai kiā Au.” ");
INSERT INTO num_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pea tafoki ki muli 'ia Pita, 'o vakai ki te tama ako ne'e 'ofa ai 'ia Sīsuú 'oku mulimuli mai, ('ā ē ne'e takoto 'i te kaí, 'o faaki ki Tono fatafatá, 'o pehē ange kiā Ia, “'Aliki, ko ai ia 'e lavaki'i 'Oú?”) ");
INSERT INTO num_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","pea 'i te mamata 'e Pita kiā iá, ne'e pehē ange 'e ia kiā Sīsū, “'Aliki, kae ā 'ia te tangata nei ia?” ");
INSERT INTO num_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Pea folafola ange 'e Sīsū kiā ia, “Kāpau ko Toku lotó ke nofo pē ia kae'aua ke Au ha'u, he ko te ā ia kiā koe? Fai pē koe ta'aú mulimuli kiā Au.” ");
INSERT INTO num_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ko ia ne'e mafola ki te kāingá 'ia te lea ko 'ení, 'e kailoa takua toe pekia te tama ako ia ko iá; ka ne'e kailoa tala 'e Sīsū kiā iá, 'e kailoa mate ia; kā ko 'eni pē, “Kāpau ko Toku lotó ke nofo pē ia kae'aua ke Au ha'u, hē ko te ā ia kiā koe?” ");
INSERT INTO num_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ko 'eni ia 'ia te tama ako 'oku fakamo'oni ki te 'ū me'a ko 'ení, pea ne ina tohi 'ia te 'ū me'a ko iá; pea kua motou 'ilo'i 'oku mo'oni tana fakamo'oní. ");
INSERT INTO num_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Pea 'oku 'i ai mo te 'ū me'a kehekehe ne'e fai 'e Sīsū. Kāpau ne'e hiki tohi 'eni kotoa pē, 'e au pehē, na'a mo māmani fuli pē, 'e kailoa hao ai te 'ū tohi 'e faí.");
INSERT INTO num_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","'E Tiofilusi, ko te 'uluaki tohi ne au faí, ko te fakamatala ki te 'ū me'a kotoa pē ne'e fua fai mo ako 'aki 'e Sīsuú, ");
INSERT INTO num_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","'o a'u ki te 'aho ne'e 'ave ai Ia ki lungá, 'i te 'osi ange Tana tuku 'ia te 'ū fekaú 'i te Laumālie Mā'oni'oní, ki te kau 'apōsetolo kua fili 'e Iá. ");
INSERT INTO num_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ko nātou ia foki ne'e fakahaa'i 'Ona ki ai hili Tono feiá, pea lahi mo mahino Tana 'ū fakamo'oni kua ma'uli Iá; he ne'e hā Ia kiā nātou, 'o 'aho fāngofulu, mo Tana lea ki te 'ū me'a ne'e kau ki te Pule'anga 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Pea ne'e kai Ia mo nātou, 'o Ina tu'utu'uni ke 'aua na'a notou hiki mei Selusalema, kae talitali ki te tala'ofa 'a te Tamaí, 'ā ē (ne'e me'a mai Ia) “ne'e kotou fanongo ki ai 'iā Aú. ");
INSERT INTO num_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","He ne'e papitaiso vai pē 'e Sione; kā 'e papitaiso kōtou 'aki 'ia te Laumālie Mā'oni'oní hili te 'ū 'aho si'i.” ");
INSERT INTO num_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ko ia, 'i te notou fakataha mo Iá, ne'e notou fehu'i kiā Ia, 'o pehē, “'Aliki, 'e Ke toe 'avange 'i te kuonga nei te pule'angá ma'a 'Isileli?” ");
INSERT INTO num_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Pea folafola 'e Ia kiā nātou, “'Oku kailoa 'a kōtou ke 'ilo'i 'ia te 'ū taimi mo te 'ū kuonga, 'ā ē kua ta'ofi 'e te Tamaí ki Tana fa'italiha 'A'aná. ");
INSERT INTO num_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kā 'e kotou ma'u pē he mālohi, 'o kā hifo te Laumālie Mā'oni'oní kiā kōtou; pea 'e kotou hoko ko Taku kau fakamo'oni 'i Selusalema, mo Siutea kātoa, mo Samēlia, 'io, 'o a'u ki te ngata'anga 'o māmaní.” ");
INSERT INTO num_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pea 'i Tana folafola peheé, pea lolotonga pē te notou siofia Iá, ne'e 'ave 'Ona ki lunga; pea ne'e 'avake 'Ona 'e te 'aó, 'o pulia meiā nātou. ");
INSERT INTO num_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pea 'i te notou kei sio fakamama'u ki te langí, 'i te lolotonga Tana 'alu aké, fokifā pē kua tutu'u mai kiā nātou he ongo tangata kofu hinahina. ");
INSERT INTO num_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Pea nā iange, “'E kau tangata Kāleli, ko te ā 'oku kotou tutu'u ai, 'o sisio pehē ki te langí? Ko te Sīsū ko ia kua 'avake meiā kōtou ki te langí, 'e toe ha'u, pea 'e hangē tofu pē tono angá ko Tana hā'ele ake ki langi 'ā ē kua kotou toki mamata 'eni ki aí.” ");
INSERT INTO num_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Pea notou foki leva ki Selusalema, mei te ma'unga ko 'Ōlivé, 'a ia ko tono mama'o mei Selusalemá 'oku fe'unga mo te fononga 'aho Sāpate 'e taha. ");
INSERT INTO num_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pea kua notou hū ki kolo, 'o notou ō ake ki te loki 'i lunga 'a ia ne'e notou nonofo 'i aí: 'ia Pita mo Sione mo Sēmisi mo 'Anitelū, 'ia Filipe mo Tōmasi, 'ia Pātolomiu mo Mātiu, 'ia Sēmisi ko te foha 'o 'Alefiusí, mo Saimone 'o te kautaha mamahi'i fanuá, pea mo Siutasi ko te foha 'o Sēmisí. ");
INSERT INTO num_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ko nātou 'eni kotoa pē ne'e notou faka'utumauku te notou lotú 'o loto taha; pea 'i ai mo he kau fafine, kae'uma'ā 'ia Mele ko te fa'ē 'a Sīsuú, pea mo Tono 'ū tokouá. ");
INSERT INTO num_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pea 'i te 'ū 'aho ko iá ne'e tu'u ake 'ia Pita 'i te ha'oha'onga 'o te kāingá, (ko te lau fakataha 'o te kakaí ko te toko teau mo te toko uangofulu,) pea iange 'e ia, ");
INSERT INTO num_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“'E kāinga, ne'e pau ke hoko 'ia te Folafolá, 'a ia ne'e 'uluaki folafola 'aki 'e te Laumālie Mā'oni'oní 'i te fofonga 'o Tēvitá, 'o kau kiā Siutasi, 'a ia ne'e tataki 'ia nātou ne'e puke 'ia Sīsuú. ");
INSERT INTO num_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","He ne'e 'osi lau ia mo tātou, pea ne'e 'i ai tono tufakanga 'i te ngāue nei.” ");
INSERT INTO num_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Pea ko te siana ko iá ne'e ma'u 'e ia he konga kelekele 'aki te totongi 'o tana kākaá; 'o tō tū'ulu ia, pea mafahi tono fatú, pea fu'u mahua ki tu'a tono to'oto'ongá. ");
INSERT INTO num_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Pea ne'e faifaí pea 'ilo ki ai 'e te kakai kotoa pē ne'e nofo 'i Selusalemá; ko ia ne'e hingoa ai te 'api ko iá 'i te notou leá ko 'Akeletama, 'a ia 'oku tatau mo te 'Api 'o te Toto). ");
INSERT INTO num_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“He kua tohi 'i te tohi Saamé, ‘Ke lala tono loto'aá, pea ke 'aua na'a nofo ai he taha,’ pea, ‘Ke ma'u he taha kehe tono lakangá.’ ");
INSERT INTO num_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ko ia ai, 'oku totonu ke fokotu'u he taha 'i te kau tangata kua kau mo tātou, 'i te lolotonga te felemofafo 'a te 'Aliki ko Sīsuú 'iā tātoú, ");
INSERT INTO num_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","'o fai mei te Papitaiso 'a Sioné 'o a'u ki te 'aho 'o Tono 'avake meiā tātoú — 'io, ke 'i ai he toko taha 'i te kakai nei ke hoko ko te fakamo'oni 'o Tana toetu'ú, fakataha mo mātou.” ");
INSERT INTO num_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pea notou fili ai he toko ua: ko Siosifa ne'e ui ko Pasapa, 'a ia ne'e fakahingoa foki ko Siusitasa, pea mo Mataiasi. ");
INSERT INTO num_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Pea notou hū 'o pehē, “'Aliki, ko Koe ia 'oku tokaima'ananga ki ai 'ia te loto 'o te kakai kotoa pē; ke Ke fakahaa'i pe ko te fea he taha 'i te ongo me'a nei kua Ke filí, ");
INSERT INTO num_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ke ma'u te potungāue faka'apōsetolo nei 'a ē ne'e laka mei ai 'ia Siutasi ke 'alu ki tono feitu'u 'o'oná.” ");
INSERT INTO num_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pea notou talotalo ma'a nāua, pea tonu kiā Mataiasi. Pea ne'e lau fakataha ia mo te kau hongofulu mā taha 'apōsetoló. ");
INSERT INTO num_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pea 'i te hoko ki te 'aho Penitekosí, 'oku notou kātoa he feitu'u 'e taha. ");
INSERT INTO num_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Pea fokifā pē kua ongo ifo mei te langí he fu'u 'u'ulu, 'o hangē ko te mumuhu he matangi mālohi 'aupito, 'o fā'ofale 'i te fale kātoa ne'e notou nonofo 'i aí. ");
INSERT INTO num_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Pea ne'e hā kiā nātou he 'ū 'alelo hangē ko he afí, 'o māvahevahe, 'o nofo ifo kiā nātou taki taha. ");
INSERT INTO num_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Pea fā'ofale 'iā nātou fuli pē 'ia te Laumālie Mā'oni'oní; pea ne'e notou kamata lea 'aki 'ia te 'ū lea kehekehe, 'o fakatatau ki tono fakalea'i nātou 'e te Laumālié. ");
INSERT INTO num_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Pea ne'e nofo 'i Selusalema he kakai Siu, ko te mātu'a lotu mo'oni mei te 'ū fanua kotoa pē 'i te lalo langí. ");
INSERT INTO num_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pea 'i te hoko te longoa'a ko iá, ne'e fakatahataha ki ai he notou fu'u tokolahi; pea ne'e hangē he pēpelí, he ko te notou 'ū leá taki taha 'oku notou ongo'i tono lea 'aki mai 'e nātoú. ");
INSERT INTO num_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Pea notou fakatumutumu mo ofoofo, 'o notou pehē, “Vakai angé, 'oku kala koā ko te kau Kāleli kotoa pē 'ia nātou 'eni 'oku leá? ");
INSERT INTO num_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Pea 'oku fefe'aki ai te tou fanongo 'eni ki ta'a tātoú lea totonu ne tou taki taha tutupu ake mo iá? ");
INSERT INTO num_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ko tātou mei Pātia mo Mītia mo 'Ilami, mo te nofo ki Mesopotēmiá, ki Siutea foki mo Kapatōsia, ki Ponitō mo 'Ēsia, ");
INSERT INTO num_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ki Filisia foki mo Pamifilia, ki 'Isipite mo te 'ū feitu'u 'o Līpia 'oku ofi ki Sailiné, mo te nofo hili mai mei Lomá, ");
INSERT INTO num_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","'ia te Siu mo'oni mo te ului ki aí, 'ia te Kēliti mo te 'Ālepea, 'oku tou ongo'i 'eni te notou fai mai 'ia te 'ū lea 'a tātoú, te notou lea 'aki 'ia te 'ū me'a lalahi 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Pea ne'e notou fakatumutumu kotoa pē, mo tāla'a, 'o notou fepehē'aki, “Ko te ā nai te 'uhinga 'o te me'a neí?” ");
INSERT INTO num_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ka ne'e kata manuki te 'ihi, 'o notou pehē, “'Ā, 'oku notou konā 'i te uaine fo'ou.” ");
INSERT INTO num_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kā ko Pita, ne tutu'u ake ia mo te toko hongofulu mā tahá, 'o hiki ake tono le'ó 'o malanga kiā nātou, 'o pehē, “'Ia te kau tangata 'o Siutea, mo te nofo Selusalema kotoa pē, ke mahino mu'a 'ia te me'a nei kiā kōtou, pea kotou fānonongo mai ki taku leá. ");
INSERT INTO num_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","He 'oku kailoa konā te kakai ko 'ená, 'o hangē ko te kotou mahaló, he ko te hivá pongipongi pē 'eni. ");
INSERT INTO num_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kā ko 'eni ia ne'e folafola 'aki 'e te palōfita ko Sioelí: ");
INSERT INTO num_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘'Oku me'a mai 'e te 'Atuá: Pea 'e hoko 'i te kuonga fakamulí, 'e Au lilingi ai he me'a mei Toku Laumālié ki te kakai kotoa pē; pea 'e toki palōfisai te kotou 'ū fohá mo te kotou 'ū 'ofafiné, pea 'e mata vīsone te kotou kau talavoú, pea 'e fa'a misi te kotou mātu'á; ");
INSERT INTO num_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","'io, na'a mo Taku kau tamaio'alikí mo Taku kau kaunangá, 'e Au lilingi he me'a mei Toku Laumālié kiā nātou foki 'i te kuonga ko iá, pea 'e notou palōfisai. ");
INSERT INTO num_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Pea 'e Au 'ai he 'ū me'a fakaofo 'i te langí 'i lunga, mo he 'ū faka'ilonga ki māmani 'i lalo nei, ko te toto, mo te afi, mo te 'ū pou kohu; ");
INSERT INTO num_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","'e liliu 'ia te la'aá 'o pō'uli, mo te māhiná 'o toto, 'i te he'iki ai hoko te 'aho 'o te 'Alikí, ko te 'aho lahi mo fakamanahē. ");
INSERT INTO num_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pea toki hoko ai 'o pehē, kā 'i ai he taha 'e tautapa ki te huafa 'o te 'Alikí 'e fakama'uli 'ona.’ ");
INSERT INTO num_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","'E kau tangata 'Isileli, kotou fanongo mai ki taku fakamatala ko 'ení: ko Sīsū mei Nāsaletí, ko te Tangata ia ne'e fakamo'oni Ma'ana 'e te 'Atuá kiā kōtou, 'aki he 'ū mana mo te 'ū me'a fakaofo mo te 'ū faka'ilonga, 'a ia ne'e fai 'e te 'Atuá 'iā Ia 'i te kotou lotolotongá, hangē ko ia 'oku kotou lāu'i'ilo ki aí. ");
INSERT INTO num_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ko te Toko Taha ko iá ne'e tukuange 'e te 'Atuá, 'i Tana fakakaukau potó mo Tana fu'aki 'afio'í, pea kotou nima'aki he kau hīteni, ke kalusefai Ia mo tāmate'i. ");
INSERT INTO num_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pea ne'e vete 'e te 'Atuá Tono kafai 'e te maté, 'o toe fokotu'u Ia; he ne'e kailoa 'aupito lava ke mapuke 'Ona 'i ai. ");
INSERT INTO num_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","He 'oku pehē 'e Tēvita 'i tana lau kiā Iá, ‘Ne au mamata ma'u pē ki te 'Alikí 'i toku 'aó, he 'oku tu'u Ia mei Toku to'omata'ú ke 'aua na'a ue'i 'oku. ");
INSERT INTO num_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ko ia ne'e neka ai toku lotó, pea vīkiviki ai toku 'aleló, pea 'e mālōlō foki toku sinó 'i te 'amanaki lelei. ");
INSERT INTO num_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","He tala'i'eaí 'e Ke si'aki toku laumālié 'i Hētesi, 'uma'ā Hau tuku Tau Toko Taha Toputapú ke 'ilo'i 'ia te 'au'auhá. ");
INSERT INTO num_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kua Ke faka'ilo kiā au he 'ū ala 'oku notou tau ki te ma'ulí; 'e Ke 'ai ke au fonu nēkaneka, 'i te feangai mo Tou fofongá.’ ");
INSERT INTO num_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Kāinga, tuku mu'a ke au lea atu pē 'i te pēteliake ko Tēvitá; kua pekia ia pea telio foki, kae'uma'ā 'oku 'iā tātou tono fanualotó 'o a'u mai ki te 'aho nei. ");
INSERT INTO num_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Kā ko te me'a 'i tana palōfitá, mo tana 'ilo'i kua fuakava kiā ia 'e te 'Atuá, 'e 'i ai he toko taha 'i te kakano 'o tono manavá, 'e 'afio 'i tono taloní. ");
INSERT INTO num_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ko ia ai 'i tana sio fakalaka atú ne'e lea 'e ia ki te toetu'u 'a Kalaisí, he ne'e kailoa si'aki 'Ona ia 'i Hētesi, pē 'e 'ilo 'e Tono kakanó 'ia te 'au'auhá. ");
INSERT INTO num_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ko te Sīsū ko 'ení ne'e toe fokotu'u Ia 'e te 'Atuá, pea ko mātou kotoa pē ko 'ení ko te kau fakamo'oni ki ai. ");
INSERT INTO num_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ko ia ai, 'i Tono hākeaki'i 'e te nima to'omata'u 'o te 'Atuá, mo Tana ma'u foki mei te Tamaí 'ia te tala'ofa 'o te Laumālie Mā'oni'oní, kua Ina hua'i ifo ai 'eni, 'a ia 'oku kotou sisio mo fānonongo ki aí. ");
INSERT INTO num_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","He tala'i'eaí ne'e 'alu ake 'ia Tēvita ki te langí, kae'uma'ā foki ne pehē 'e ia, ‘Ne'e folafola te 'Alikí ki toku 'Alikí: Nofo Koe 'i Toku to'omata'ú, ");
INSERT INTO num_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kae'aua ke Au ngaahi tou 'ū filí ke hoko ko tou tu'unga va'e.’ ");
INSERT INTO num_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ko ia ai ke mātu'aki 'ilo'i 'e te ha'a 'Isileli kotoa pē, kua fakanofo 'e te 'Atuá 'ia te Sīsū ko 'ení ke 'Aliki mo Kalaisi fakatou'osi; 'io, 'ia Ia ko 'ē ne'e kotou kalusefaí.” ");
INSERT INTO num_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pea 'i te notou fanongo ki aí, ne'e puputu'u te notou lotó, pea notou pehē ange kiā Pita mo te toenga 'o te kau 'apōsetoló, “Kāinga, ko te ā leva 'a mātou 'e faí?” ");
INSERT INTO num_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pea iange 'e Pita kiā nātou, “Kotou fei mo fakatomala, pea taki taha papitaiso 'i te huafa 'o Sīsū Kalaisí, ki te fakamolemole te kotou 'ū angahalá, pea 'e kotou ma'u 'ia te me'a'ofa ko te Laumālie Mā'oni'oní. ");
INSERT INTO num_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","He 'oku ma'a kōtou 'ia te tala'ofá, pea mo te kotou fānaú foki, mo nātou mama'ó, 'io, 'ia nātou kotoa pē 'e ui ange 'e te 'Alikí ko te tou 'Atuá.” ");
INSERT INTO num_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pea ne'e lahi foki mo tana 'ū lea kehekehe ne'e fakamamafa'i 'aki, mo toutou enginaki 'aki 'ia nātou, 'i tana pehē, “Kotou tuku 'ia kōtou ke fakama'uli mei te fa'ahinga anga-kehe ko 'ení.” ");
INSERT INTO num_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pea ne'e notou tali tana leá, 'o notou papitaiso, pea ne'e fakaului mai 'i te 'aho pē ko iá he 'ū laumālie, fe'unga nai mo te toko tolu afe. ");
INSERT INTO num_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Pea ne'e notou nofo faka'utumauku ki te faiako 'a te kau 'apōsetoló, mo te fakakautaha, mo te pakipaki 'o te mā, mo te 'ū feinga lotu. ");
INSERT INTO num_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Pea ne'e hoko he 'ilifia ki te kakai kotoa pē; pea ne'e lahi foki te 'ū me'a fakaofo mo te 'ū faka'ilonga ne'e hoko 'i te kau 'apōsetoló. ");
INSERT INTO num_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Pea ko nātou fuli pē ne'e tuí ne'e notou fa'a nofo fakataha, mo notou me'a taha. ");
INSERT INTO num_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Pea ne'e notou fakatau atu te notou 'ū tofi'á mo te nga'ota'otá; mo notou tufa te pa'anga ne'e ma'u 'i aí ki te kakai kehekehe, 'o fakatatau ki te notou masivá. ");
INSERT INTO num_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Pea ko te 'aho kotoa pē ne'e notou faka'utumauku 'o loto taha 'i te ō ki te Temipalé, mo notou pakipaki mā 'i 'api; pea ne'e notou kai te notou 'inasí 'i te fiafia mo te loto hangamālie; ");
INSERT INTO num_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","'o notou fakamālō ki te 'Atuá, pea ne'e tokangaekina foki 'ia nātou 'e te kakai kotoa pē. Pea ne'e fakaului 'e te 'Alikí ki te notou fakatahá 'i te 'aho kotoa pē 'ia nātou ko 'ē kua kamata ma'ulí. ");
INSERT INTO num_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pea ne'e ō ake 'ia Pita mo Sione ki te Temipalé, ki te feinga lotu hū 'o te tolu afiafí. ");
INSERT INTO num_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Pea ne'e 'i ai he tangata ne'e heke talu tono fanau'í, pea ne'e fata ange 'i te 'aho kotoa pē, 'o tuku 'i te matapā 'o te Temipalé, 'a ē 'oku ui ko Masanisaní, kote'uhí ke fai tana kolekole pa'anga ki te kakai 'a ē 'oku notou hū ki te Temipalé. ");
INSERT INTO num_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pea 'i tana vakai kiā Pita mo Sione 'oku 'ai ke nā hū ki te Temipalé, ne'e kole ange ia hana pa'anga. ");
INSERT INTO num_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pea sio fakamama'u 'e Pita kiā ia, fakataha mo Sione, 'o pehē ange, “Sio mai angé kiā māuá.” ");
INSERT INTO num_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Pea tokanga atu ia, mo tana 'amanaki 'e ma'u hana me'a meiā nāua. ");
INSERT INTO num_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pea iange 'e Pita, “Ko te silivá mo te koulá 'oku kala u ma'u; kā ko te me'a 'okou ma'ú 'e au 'avatu ia: 'i te huafa 'o Sīsū Kalaisi mei Nāsaletí, tu'u pea hā'ele.” ");
INSERT INTO num_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pea hanga 'e ia 'o puke te tangatá 'i tono nima mata'ú, 'o fusi ake 'ona; pea ma'uli leva tono va'é mo tono tunga'i va'é. ");
INSERT INTO num_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Pea hopo ake ia 'o tu'u, pea ha'ele, pea hū ia mo nāua ki te Temipalé, kua ha'ele, mo hopohopo, mo fakamālō ki te 'Atuá. ");
INSERT INTO num_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Pea ne'e mamata kiā ia te fu'u kakaí kotoa pē, 'oku ha'ele mo fakamālō ki te 'Atuá. ");
INSERT INTO num_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Pea notou 'ilo'i foki ko te siana ia ne'e nofo 'o kole pa'anga 'i te Matapā Masanisani 'o te Temipalé. Pea ne'e notou ofo lahi mo fakatumutumu 'i te me'a kua hoko kiā iá. ");
INSERT INTO num_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pea 'i tana kei puke kiā Pita mo Sioné, ne'e felele'i mai te kakaí kotoa pē kiā nātou, ki te fakafaletolo 'oku hingoa kiā Solomoné, 'oku notou ofo lahi 'aupito. ");
INSERT INTO num_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pea 'i te sio leva ki ai 'ia Pitá, ne'e lea ange 'e ia ki te kakaí, “'E kāinga 'Isileli, ko te ā 'oku kotou ofo ai 'i te me'a nei? Pea ko te ā 'oku kotou sio fakamama'u mai ai kiā māua, 'o hangē ko māua kua mā ngaahi 'ona ke hā'ele 'aki he mafai 'o māua, pe lotu mo'oni? ");
INSERT INTO num_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ko te 'Atua pē 'o 'Ēpalahame mo 'Aisake mo Sēkopé, 'io, ko te 'Atua 'o te tou mātu'á, kua Ina fakalāngilangi'i Tana Sevāniti ko Sīsuú, 'ia te Toko Taha 'a ia ne'e kotou tukuange, pea fakafisinga'i 'i te 'ao 'o Pailató, lolotonga kua tu'utu'uni 'e ia ke vete'i angé. ");
INSERT INTO num_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kae fakafisinga'i 'e kōtou 'ia te Toko Taha Mā'oni'oni mo Anga-tonú, 'o kotou kole ke me'a'ofa 'aki mai kiā kōtou he tangata fakapō; ");
INSERT INTO num_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","kae kotou tāmate'i te 'Aliki 'o te ma'ulí, 'a ē kua fokotu'u 'e te 'Atuá mei te pekiá. Pea ko mātou 'eni ko te kau fakamo'oni ki ai. ");
INSERT INTO num_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Pea ko te me'a 'i te mā tui ki te huafa 'O'oná, ko ia kua fakama'uli ai 'e Tono huafá 'ia te tangata nei, 'a ia 'oku kotou siofia mo lāu'i'ilo'i ki aí. 'Io, ko te tui kiā Iá kua tuku ai ki te tangata nei 'ia te ma'uli haohaoa ko 'ení 'i te 'ao 'o kōtoú fuli pē. ");
INSERT INTO num_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Pea ko 'eni, kāinga, 'okou 'ilo'i ne'e kotou fai ia 'i te ta'e'ilo, pehē foki mo te kotou kau pulé. ");
INSERT INTO num_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kā kua fakaai 'e te 'Atuá 'ia te 'ū me'a ne Ina fu'aki fakahā 'i te ngutu 'o Tana kau palōfita kotoa pē, 'o pehē, 'e mamahi 'ia te Kalaisí. ");
INSERT INTO num_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ko ia ai kotou fakatomala leva, pea tafoki, ke fakamolemole ai te kotou 'ū angahalá, kote'uhí ke hoko mai 'ia te 'ū 'aho 'o te fakama'ulí mei te 'ao 'o te 'Alikí; ");
INSERT INTO num_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","mo fekau'i mai 'e Ia 'ia Sīsū Kalaisi, 'a ia ne'e fu'aki malanga 'aki kiā kōtoú, ");
INSERT INTO num_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","'a ia kua pau ke ma'u 'e te langí, kae'aua ke hoko mai 'ia te taimi 'o te Fakafo'ou 'o te me'a kotoa pē, 'a ia kua folafola ki ai 'e te 'Atuá 'i te ngutu 'o Tana kau palōfita mā'oni'oni fuli pē, talu mei mu'a. ");
INSERT INTO num_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","He ne'e lea mo'oni 'e Mōsese, 'o pehē, ‘'E fokotu'u 'e te 'Aliki ko te kotou 'Atuá he palōfita kiā kōtou 'i te kotou kāingá, 'o hangē ko aú; pea 'e kotou tokanga kiā Ia 'i te me'a fuli pē 'e folafola 'aki 'e Ia kiā kōtou. ");
INSERT INTO num_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Pea 'e hoko 'o pehē, kā 'i ai he taha 'e kailoa tokanga ki te palōfita ko iá, 'e faka'auha 'ona mei te kakaí.’ ");
INSERT INTO num_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Pea ko te kau palōfitá kotoa pē, meiā Sāmiuela mo nātou ne'e hokó, 'ilonga pē nātou ne'e notou leá ne'e notou fakamatala foki ki te 'ū 'aho ko 'ení. ");
INSERT INTO num_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ko te fānau kōtou 'a te kau palōfitá, mo te fuakava ne'e fai 'e te 'Atuá mo te tou mātu'á 'i mu'a, 'i Tana folafola kiā 'Ēpalahame 'o pehē, ‘Pea ko tou hakó 'e manū'ia ai 'ia te fa'ahinga kotoa pē 'o māmani.’ ");
INSERT INTO num_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Pea ko te 'Atuá, 'i Tana fokotu'u Tana Sevāniti ko Sīsuú, ne'e fu'aki fekau'i 'Ona kiā kōtou, ke fakamanū'ia'i 'e Ia 'ia kōtou 'i te fakatafoki mai kōtou taki taha mei tana 'ū faikoví.” ");
INSERT INTO num_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pea 'i te lolotonga te nā kei lea ki te kakaí, ne'e tu'u mai kiā nāua 'ia te kau taula'alikí, mo te 'alikitau 'o te Temipalé, mo te kau Sātusí, ");
INSERT INTO num_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","he ne'e notou mamahi 'i te nā ako'i te kakaí, mo te nā malanga 'aki 'iā Sīsū 'ia te toetu'u mei te pekiá. ");
INSERT INTO num_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Pea notou puke 'ia nāua, 'o tuku ki te pilīsoné ki te 'āpongipongí, he kua afiafi. ");
INSERT INTO num_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ka ne'e tui he tokolahi 'iā nātou ne'e notou fanongo ki te malangá; pea ne'e fe'unga mo te toko nima afe nai. ");
INSERT INTO num_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pea 'i te pongipongi aké ne'e fakataha 'i Selusalema te notou kau pulé, mo te kau mātu'á, mo te kau sikalaipé, ");
INSERT INTO num_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","mo 'Ānasi ko te Taula'aliki Lahí, mo Kaiafasi, mo Sione, mo 'Alekisānita, mo nātou ne'e kau ki te ha'a Taula'aliki Lahí. ");
INSERT INTO num_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pea notou fokotu'u nāua 'i te notou ha'oha'ongá, 'o notou fehu'i ange, “Ko te fa'ahinga ivi fea, mo te hingoa 'o ai, kua kulā fai 'aki te me'a nei?” ");
INSERT INTO num_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ne'e toki fakafonu 'ia Pita 'e te Laumālie Mā'oni'oní, 'o pehē ange 'e ia kiā nātou, “'E hau'aliki 'Isileli, mo te kau mātu'a, ");
INSERT INTO num_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kāpau kua 'eke'i māua 'i te 'aho nei 'i te ngāue lelei kua fai ki te tangata mahaki'iná, pe kua fakama'uli te siana nei 'i te ā, ");
INSERT INTO num_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ke mahino mu'a kiā kōtou kotoa pē, mo te kakai 'Isileli fuli pē: ko te huafa pē 'o Sīsū Kalaisi mei Nāsaletí, 'ā ē ne'e kotou kalusefaí, pea ne'e toe fokotu'u 'e te 'Atuá mei te pekiá, ko te Toko Taha ko iá kua tu'u mei ai 'ia te siana nei 'i te kotou 'aó kua ma'uli. ");
INSERT INTO num_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ko te Maka 'eni ne'e ta'etoka'i 'e kōtou ko te kau tufungá, 'a ē kua hoko ko te fungani maka 'o te tulikí. ");
INSERT INTO num_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","'Io, pea 'oku kailoa tu'u te fakama'ulí ia he taha kehe; he tala'i'eaí 'oku 'i ai mo he hingoa kehe 'i te lalo langí kua tuku 'i te lotolotonga 'o te kakaí, 'a ia kua tu'utu'uni ke tou mā'u'uli ai.” ");
INSERT INTO num_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pea 'i te notou tokanga'i te ta'emālu'ina 'ia Pita mo Sioné, kae'uma'ā ne'e notou 'ilo'i ko te ongo me'a ta'ekolisi 'ia nāua, mo ta'ema'u tu'ungá, ne'e notou ofo; pea notou vakai, tā ko te ongo me'a ne nā fa'a 'iā Sīsū. ");
INSERT INTO num_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kā 'i te notou vakai ki te tangata ne'e fakama'ulí 'oku tu'u fakataha mai mo nāuá, pea kailoa leva he notou mama'i me'a ke tali 'aki. ");
INSERT INTO num_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Pea notou fekau ke nā hū ki tu'a mei te Sanetalimí, 'o notou felāu'aki ");
INSERT INTO num_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","'o pehē, “Ko te ā leva he tou me'a 'e fai ki te ongo me'a nei? He ko te hoko 'iā nāua he faka'ilonga mana mo'oní, ko te me'a ia 'oku e'a ki te kakai kotoa pē 'oku nofo 'i Selusalema, pea tala'i'eaí 'e tou lava ke fakahalaki. ");
INSERT INTO num_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kā kote'uhí ke 'aua na'a kei mafola ia ki te kakaí, tou fakamana'i 'ia nāua, ke 'aua 'aupito nā toe talanoa holo kau ki te huafa ko 'ení.” ");
INSERT INTO num_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Pea notou ui ange 'iā nāua, 'o notou fekau mālohi ange ke 'aua na'a nā toe mama'i pu'aki te huafa 'o Sīsuú, pe toe ako 'aki. ");
INSERT INTO num_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ka ne'e tali ange 'e Pita mo Sione kiā nātou, “Kotou me'a lelei pē ki ai, pe ko fea te me'a 'oku totonu ki te finangalo 'o te 'Atuá, 'ia te mā talangafua kiā kōtoú, pē ki te 'Atuá. ");
INSERT INTO num_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","He 'e kailoa 'aupito tuku te mā lea ki te 'ū me'a ne'e mā sio tonu mo fānonongo ki aí.” ");
INSERT INTO num_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Pea tē 'āsili te notou fakamana'i nāuá, 'o notou toki tukuange, ko te kailoa notou 'ilo'i pē 'e notou tautea'i fefe'aki 'ia nāuá, talia te kakaí; he ne'e fakahīkihiki'i kotoa pē 'e nātou 'ia te 'Atuá 'i te me'a kua hokó. ");
INSERT INTO num_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","He kua ta'u fāngofulu tupu te tangatá, 'a ē kua fai ki ai te faka'ilonga mana fakama'ulí. ");
INSERT INTO num_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pea 'i tono tukuange 'o nāuá, ne nā ō ki te notou kakaí, 'o nā talanoa'i te 'ū lea kehekehe kua fai ange 'e te kau taula'aliki lahí mo te kau mātu'á kiā nāuá. ");
INSERT INTO num_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Pea 'i te notou fānonongo ki aí, pea notou ofa'aki loto taha te notou leá ki te 'Atuá, 'o notou pehē, “'E 'Aliki, ko Koe ia ne Ke ngaahi 'ia te langí, mo te fanuá, mo te taí, mo te 'ū me'a kotoa pē 'oku 'i aí. ");
INSERT INTO num_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ko Koe ia ne Ke folafola mai 'i te Laumālie Mā'oni'oní, mo te ngutu 'o te tou kui ko Tēvitá, ko Tau sevāniti, 'o pehē, ‘Ko te ā 'oku futefute ai 'ia te Senitailé, mo fakakaukau mūnoa ai 'ia te 'ū matakalí? ");
INSERT INTO num_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","'Ia te tu'u mai te 'ū tu'i 'o māmaní, pea fakatahataha te hau'alikí ke puleaki'i te 'Alikí, pea mo Tana Paní.’ ");
INSERT INTO num_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","He 'oku mo'oni ne'e fakataha 'i te kolo nei 'ia Hēlota mo Ponitō Pailato fakatou'osi, mo te Senitailé mo te kakai 'Isilelí, ke notou fai he me'a ke lavaki'i 'aki Tau Sevāniti Tapu ko Sīsuú, 'a ē ne Ke paní, ");
INSERT INTO num_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","'a ia ko te 'ū me'a ia ne'e fu'aki tālanga'i 'e Tou Māfimafí mo Tou Potó. ");
INSERT INTO num_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Pea 'i te me'a ko 'ení, 'Aliki, ke Ke me'a ki te notou 'ū fakamaná, pea tuku foki ki Tau kau tamaio'alikí, ke notou lea mālohi 'aki Tau Folafolá, ");
INSERT INTO num_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","'i Tau mafao mai Tou nimá ke faito'o, pea ke fai te 'ū faka'ilonga mana mo fakaofo 'i te huafa 'o Tou Sevāniti Mā'oni'oni ko Sīsuú.” ");
INSERT INTO num_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pea lolotonga te notou huú, ne'e ngalulululu 'ia te feitu'u 'oku notou fakataha 'i aí; pea ne'e fakafonu 'ia nātou kotoa pē 'aki te Laumālie Mā'oni'oní, 'o notou malanga mālohi 'aki te Folafola 'a te 'Atuá. ");
INSERT INTO num_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Pea ko nātou kotoa pē kua tuí, ne'e notou fāitaha, mo loto taha; 'io, ne'e kailoa he taha 'e lau tana me'a 'a'aná ko tana me'a; ka ne'e notou mātu'aki me'a taha pē. ");
INSERT INTO num_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Pea ne'e fakamo'oni 'e te kau 'apōsetoló 'aki te mālohi lahi ki te toetu'u 'a te 'Aliki ko Sīsuú; 'io, pea ne'e nofo'i 'ia nātou kotoa pē 'e te kelesi lahi. ");
INSERT INTO num_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","He tala'i'eaí ne'e 'i ai he notou toko taha 'e masiva, he 'ilonga pē 'ia nātou ne'e ma'u 'api mo te fale ne'e notou fakatau atu ia, pea ne'e toutou 'aumai 'ia te pa'anga mei te 'ū me'a kua fakataú, ");
INSERT INTO num_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","'o tuku atu ki te va'e 'o te kau 'apōsetoló, pea ne'e tufaki ki te tangata taki taha 'o fakatatau ki tana masivá. ");
INSERT INTO num_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Pea ne'e 'i ai he matu'a Līvaite ne'e tupu ake 'i Saipalo, ko Siosifa, ka ne'e fakahingoa 'ona ko Pānepasa 'e te kau 'apōsetoló, ('a ia ko tono hikí, ko te foha 'o te fakafiamālie). ");
INSERT INTO num_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ne'e fakatau atu 'e ia tono konga kelekelé, 'o 'aumai tono pa'angá, 'o tuku atu ki te va'e 'o te kau 'apōsetoló. ");
INSERT INTO num_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ka ne'e 'i ai he tangata, ne'e hingoa ko 'Ānanaia, ne'e fakatau atu 'e ia he 'api, pea kau ai 'ia Sāfaila ko tono 'unoho. ");
INSERT INTO num_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Pea ne'e tuku 'e ia ma'ana he konga mei te totongí, 'o 'ilo'i foki ki ai tono 'unohó, pea 'aumai 'e ia he konga pē, 'o tuku atu ki te va'e 'o te kau 'apōsetoló. ");
INSERT INTO num_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pea iange 'e Pita, “'E 'Ānanaia, ko te ā kua fā'ofale ai 'ia Sētane 'i tou lotó, ke lohiaki'i 'ia te Laumālie Mā'oni'oní, ke ke tuku ai he konga mei te totongi 'o te konga kelekelé? ");
INSERT INTO num_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","'I te he'iki ai ke fakataú, ne'e kailoa koā 'o'ou pē? Pea hili ange tono fakataú, ne'e kailoa koā 'a'au pē ke fa'italiha ki tono pa'angá? Ko te ā ne ke 'ai ai 'i tou lotó 'ia te me'a nei? Tala'i'eaí ko tau lohiaki'í he tangata, kā ko te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pea 'i te fanongo 'e 'Ānanaia ki te lea ko iá, ne'e tō ai pē ia ki lalo 'o pekia. Pea tō ai he fu'u 'ilifia ki te kakai kotoa pē ne'e fanongo ki aí. ");
INSERT INTO num_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Pea tutu'u atu 'ia te kau talavoú 'o teuteu'i ia, pea notou fata atu 'ona ki tua'ā, 'o tanu. ");
INSERT INTO num_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pea kua 'osi nai he houa 'e tolu, pea hū mai tono 'unohó, 'oku kala ina 'ilo'i te me'a kua hokó. ");
INSERT INTO num_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pea iange 'e Pita kiā ia, “Fakahaa'i mai angé pe ne'e kulā fakatau te 'apí 'aki te totongi ko 'ē pē?” Pea iange 'e ia, “'Io, ko ia pē.” ");
INSERT INTO num_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pea me'a ange 'e Pita kiā ia, “Ko te ā kua kulā alea ai ke 'ahi'ahi'i te Laumālie 'o te 'Alikí? Ko 'ena 'oku 'i te matapaá te va'e 'o te kakai ne'e notou tanu tou husepānití, pea 'e notou fata atu foki mo koe.” ");
INSERT INTO num_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pea hinga atu leva ia ki te va'e 'o Pitá, 'o pekia. Pea 'i te hū mai te kau tamá, tā kua pekia 'ia te fafiné; ne'e notou fata atu ia ki tua'ā, 'o tanu fakataha mo tono hoá. ");
INSERT INTO num_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Pea tō he fu'u 'ilifia ki te siasí kotoa pē, mo te kakai fuli pē ne'e notou fanongo ki te me'a ko iá. ");
INSERT INTO num_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Pea ne'e fai 'e te nima 'o te kau 'apōsetoló 'ia te 'ū faka'ilonga mana mo te 'ū me'a fakaofo lahi 'i te 'ao 'o te kakaí. Pea ne'e fa'a fakataha 'ia nātou kotoa pē 'i te fakafaletolo 'o Solomoné. ");
INSERT INTO num_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kā ko tono toé ne'e kailoa kau mo nātou he toko taha, ko te notou manaheé; ka ne'e faka'apa'apa 'ia te kakaí kiā nātou. ");
INSERT INTO num_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pea ne'e ului mai ki te 'Alikí he kakai tokolahi ne'e notou tui, ko te tangata mo te fafine. ");
INSERT INTO num_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Pea faifaí pea notou 'aumai ki tu'a 'ia te kau mahaki'iná, 'o tuku fakaholoholo 'i te alá 'i te notou fanga ki'i moe'anga mo te fala, hei'ilo na'a lave'i he notou toko taha 'e te 'ata 'o Pitá 'i hana me'a ange. ");
INSERT INTO num_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ne'e ha'u foki 'ia te kakaí mei te 'ū kolo vāofi mo Selusalemá, ko te 'aumai te notou kau mahaki'iná, mo nātou ne'e 'āvea 'e te 'ū fa'ahikehé, pea ne'e fakama'uli 'ia te fa'ahinga ko iá kotoa pē. ");
INSERT INTO num_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pea tutu'u ake ai 'ia te Taula'aliki Lahí, mo nātou kotoa pē ne'e kau mo iá, ('a ia ko te fa'ahi Sātusí,) kua vevele te notou meheká. ");
INSERT INTO num_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Pea notou puke 'ia te kau 'apōsetoló, 'o sī 'ia nātou ki te pilīsone fakakoló. ");
INSERT INTO num_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ka ne'e fakaava pō'uli 'ia te 'ū matapā 'o te pilīsoné 'e te 'āngelo 'a te 'Alikí; 'o taki atu foki Ia 'ia nātou ki tu'a, 'o pehē ange, ");
INSERT INTO num_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Kotou ō 'o tu'u 'i te Temipalé, 'o malanga 'aki ki te kakaí 'ia te 'ū Folafola kotoa pē 'oku kau ki te ma'uli ko iá.” ");
INSERT INTO num_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Pea 'i te notou fanongo ki aí, ne'e notou uhu atu leva ki te Temipalé, 'o faiako. Faifaí kua a'u ange 'ia te Taula'aliki Lahí mo tono fa'ahí, 'o notou ui ange te Sanetalimí, pea ke kātoa mai 'ia te fakataha fakamātu'a 'o ha'a 'Isilelí; pea notou fekau atu ki te pilīsoné ke taki mai 'ia nātou. ");
INSERT INTO num_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kā ko te kau le'o Temipale ne ō angé ne'e kala notou 'ilo'i 'ia nātou 'i te fale fakapōpulá. Pea notou foki mai 'o fakahā ange, ");
INSERT INTO num_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","'o pehē, “Ko te me'a ki te pilīsoné, ne'e motou 'ilo'i ia kua tāpuni'i, 'o malu 'aupito, pea ko te kau le'ó 'oku notou tutu'u pē ki te 'ū matapaá; kā 'i te motou to'o aké, ne'e kala motou 'ilo'i he mama'i toko taha 'i te loto falé.” ");
INSERT INTO num_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Pea 'i te notou fanongo ki te fakamatala ko iá, 'ia te 'alikitau 'o te Temipalé mo te kau taula'aliki lahí, ne'e notou fifili 'i te kau 'apōsetoló pe 'e iku ki te ā 'ia te me'a nei. ");
INSERT INTO num_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Pea toki 'alu ange he toko taha, 'o fakahaa'i kiā nātou, “Vakai, ko te kau tangata 'ē ne'e kotou fakahū pilīsoné, 'oku notou tutu'u 'i te Temipalé, 'o faiako ki te kakaí.” ");
INSERT INTO num_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Pea ō atu leva te 'alikitaú mo te kau le'o Temipalé, 'o taki mai 'ia nātou, ka ne'e kailoa notou 'aumai fakamālohi'i, he ne'e notou manahē ki te kakaí, na'a tolomaka'i 'ia nātou. ");
INSERT INTO num_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pea notou taki mai nātou, 'o fokotu'u 'i te lotolotonga 'o te Sanetalimí. Pea fakafehu'i kiā nātou 'e te Taula'aliki Lahí, ");
INSERT INTO num_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","'o pehē, “Ne'e motou mātu'aki fekau kiā kōtou ke 'aua 'e kotou ako 'aki te hingoa nei, pea ko 'eni kua kotou fakafonu 'ia Selusalema 'aki te kotou akonakí, pea 'oku kotou fai 'ení ke fakahinga mai kiā mātou te toto 'o te Tangata ko iá.” ");
INSERT INTO num_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pea tali ange 'e Pita mo te kau 'apōsetoló, 'o notou pehē, “'Oku totonu pē ke motou talangafua ki te pule 'a te 'Atuá 'i te pule 'a te tangatá. ");
INSERT INTO num_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ko te 'Atua 'o te tou mātu'a 'i mu'á, ne'e fokotu'u 'e Ia 'ia Sīsū, 'a ē ne'e kotou tāmate'i 'i Tono tautau 'i te kolosí. ");
INSERT INTO num_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Pea kua hākeaki'i Ia 'e te 'Atuá 'aki Tono nima to'omata'ú ko te 'Aliki mo Fakama'uli, ke foaki mo'o 'Isileli 'ia te fakatomalá mo te fakamolemole angahalá. ");
INSERT INTO num_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Pea ko mātoú ko te kau fakamo'oni 'o te 'ū me'a ko iá; pehē foki ki te Laumālie Mā'oni'oní, 'a ē kua foaki 'e te 'Atuá kiā nātou 'oku talangafua kiā Iá.” ");
INSERT INTO num_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pea 'i te notou fanongo ki aí, ne'e notou tekelili 'i te 'itá, pea notou alea'i leva te notou tāmate'í. ");
INSERT INTO num_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pea tu'u ake 'i te loto Sanetalimí he matāpule Fālesi ne'e hingoa ko Kāmelieli, ko te faiako ia 'i te Laó, pea ne'e tokangaekina 'e te kakai kotoa pē; pea fekau atu 'e ia ke tuku si'i atu ki tu'a te kau tangatá. ");
INSERT INTO num_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pea toki lea ange ia kiā nātou, “'E matāpule 'Isileli, vakavakai lelei angé ki te me'a 'oku kotou pehē ke fai ki te kau tangata nei. ");
INSERT INTO num_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","He ne'e 'i ai he toko taha ne'e tu'u 'i mu'a, ko Teutasi, 'o pōlepole ia takua 'oku taha 'ana; pea ne'e hinga ki ai he kau tangata 'e toko fāngeau nai. Pea ne'e mate tāmate'i ia, pea 'ilonga nātou ne'e tuitala kiā iá, ne'e notou mavete 'o 'osi'osingamālie. ");
INSERT INTO num_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Hili ange te siana ko iá, ne'e tu'u ake 'ia Siutasi mei Kālelí 'i te taimi 'o te tohi kakaí, pea tohoaki'i 'e ia he kakai ke angatu'u. Pea ne'e mole mo te tangata ko iá, pea ne'e fakamavete'i 'ia nātou kotoa pē ne'e tuitala kiā iá. ");
INSERT INTO num_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Pea 'i te me'a ko 'ení 'okou fakalea atu: tu'u 'atā mo te kau tangata ko 'ení, pea tuku ai pē 'ia nātou. He kāpau 'oku mei te tangatá 'ia te fakakaukau mo te ngāue ko 'ení, 'e ngata pē ia; ");
INSERT INTO num_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","kae kāpau 'oku mei te 'Atuá ia, 'e kailoa kotou lava ke fakangata 'ia nātou: kae'uma'ā foki na'a 'iloangé kua kotou tau'i 'ia te 'Atuá.” Pea ne'e notou tui kiā ia, ");
INSERT INTO num_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","'o notou ui ange te kau 'apōsetoló 'o haha, mo notou fekau ke 'aua na'a notou toe malanga 'aki te huafa 'o Sīsuú, 'o notou toki tukuange 'ia nātou. ");
INSERT INTO num_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Pea ō ai 'ia nātou mei te ha'oha'onga 'o te Sanetalimí, kua notou fiafifia kote'uhí kua lau 'ia nātou 'oku notou taau ke ngaahikovi'i kote'uhí ko te Huafá. ");
INSERT INTO num_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Pea ko te 'aho kotoa pē, 'i te Temipalé pea 'i 'api, ne'e kailoa tuku te notou ako mo malanga 'aki 'ia Sīsū Kalaisí. ");
INSERT INTO num_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kā 'i te 'ū 'aho ko iá, 'a ē ne'e tupu tokolahi ai 'ia te kau akó, ne'e hoko he lāunga mei te fa'ahinga ne'e lea faka-Kalisí ki te fa'ahinga ne'e lea faka-Hepeluú, kote'uhí ne'e kailoa tokanga'i te notou kau uitoú 'i te tufa tokoni ne'e fai 'i te 'aho kotoa pē. ");
INSERT INTO num_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Pea fakataha'i leva 'e te kau hongofulu mā uá 'ia te kau akó kotoa pē, 'o notou pehē, “'Oku kala motou loto ke tuku si'aki te Folafola 'a te 'Atuá kae motou nofo ki te fai 'o te tufa 'i te 'ū tēpilé. ");
INSERT INTO num_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ko ia ai, kāinga, kotou fili'i mai he toko fitu meiā kōtou, he kau tangata kua fakaongolelei maí, 'o mātu'aki fakalaumālie mo poto, pea 'e motou fakanofo leva 'ia nātou ki te ngāue ko iá. ");
INSERT INTO num_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kā ko mātoú, 'e motou faka'utumauku ki tono fai 'o te hūfiá, mo tono tufa 'o te Folafolá.” ");
INSERT INTO num_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Pea ne'e hā lelei 'ia te lea ko iá ki te kau fakatahá kotoa pē, pea notou fili leva 'ia Sitīveni, ko te tangata ne'e fonu 'i te tuí mo te Laumālie Mā'oni'oní, pea mo Filipe, mo Pōkolo, mo Naikano, mo Taimoni, mo Pāmina, pea mo Nīkola ko te matu'a mei 'Aniteoke ne'e tafoki ki te lotu faka-Siú. ");
INSERT INTO num_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Pea notou fokotu'u nātou 'i te 'ao 'o te kau 'apōsetoló; pea hili te notou lotú ne'e notou hilifaki nima kiā nātou. ");
INSERT INTO num_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Pea ne'e tupu ma'u pē 'ia te Folafola 'a te 'Atuá; pea fakatokolahi 'aupito te lau 'o te kau akó 'i Selusalema; kae'uma'ā ko te fu'u tokolahi 'o te kau taula'alikí ne'e notou fakavaivai'i nātou 'o tui. ");
INSERT INTO num_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Pea ko Sitīveni, ne'e fai 'e ia 'i te lotolotonga 'o te kakaí 'ia te 'ū ngāue fakaofo, mo te 'ū faka'ilonga ne'e mamafa, 'i tana fonu kelesi mo te mafai lahi. ");
INSERT INTO num_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ka ne'e tu'u ake he 'ihi ne'e kau ki te falelotu ne'e ui ko te falelotu 'o te kau Lipatainé, mo te kau Sailiné, mo te kau 'Alekisānitiá, mo te 'ihi 'i te kakai mei Silisia mo 'Ēsiá, 'o notou fakakikihi mo Sitīveni. ");
INSERT INTO num_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ka ne'e kala notou lava ke tali 'ia te poto pe ko te Laumālie ne'e fai ai tana leá. ");
INSERT INTO num_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Pea notou toki fale'i leva he kau tangata ke notou lau'i 'ona, 'o pehē, “Ne'e motou fanongo ki tana lau kovi kiā Mōsese pea mo te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Pea notou o'i foki 'ia te kakaí, mo te kau mātu'á, mo te kau sikalaipé; pea notou toki 'ohofi ia, 'o puke, 'o taki ki te Sanetalimí. ");
INSERT INTO num_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ne'e notou 'aumai foki he kau fakamo'oni lohi, 'a ia ne'e notou pehē, “Ko te tangata nei 'oku kala tuku tana lea tuki ki te Fale Tapú mo te Laó. ");
INSERT INTO num_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","He kua motou fanongo ki tana pehē, takua ko Sīsuú, ko te siana mei Nāsaleti, 'e faka'auha 'e Ia 'ia te Fale Tapú, mo fakakehe 'ia te 'ū 'ulungāanga ne'e tuku 'e Mōsese kiā tātoú.” ");
INSERT INTO num_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Pea sio fakamama'u kiā ia 'e te kakai kotoa pē ne'e notou nofo 'i te Sanetalimí, pea tā ko tono fofongá ne'e hangē ko te fofonga 'o he 'āngelo. ");
INSERT INTO num_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Pea me'a mai 'ia te Taula'aliki Lahí, “'Oku mo'oni koā 'ia te 'ū me'a nei?” ");
INSERT INTO num_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Pea pehē ange 'e ia, “Kāinga mo te mātu'a, kotou me'a mai. Ko te 'Atua 'oku 'A'ana 'ia te lāngilangí, ne'e fakahaa'i 'Ona ki te tou kui ko 'Ēpalahamé, lolotonga tana nofo 'i Mesopotēmia, kae he'iki ai nofo 'i Kālaná. ");
INSERT INTO num_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Pea ne Ina folafola kiā ia, ‘Hiki mei tou fanuá, pea mei tou kāingá, pea ha'u ki te fanua 'e Au toki fakahaa'i atú.’ ");
INSERT INTO num_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Pea 'alu leva ia mei te fanua 'o te kakai Kalitiá, 'o nofo 'i Kālana. Pea hili te pekia tana tamaí, ne'e hiki 'ona 'e te 'Atuá mei ai ki te fanua ko 'ení, 'a ia 'oku kotou nofo aí. ");
INSERT INTO num_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ka ne'e kailoa foaki kiā ia he konga kelekele 'i ai ke fe'unga mo tono topuva'é, pē ko hana 'api; ka ne'e tala'ofa 'e Ia 'e mātu'aki tuku ia mo'ona, pea mo tono hakó 'āmuli, 'osi angé 'oku kailoa he nā fānau. ");
INSERT INTO num_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Pea ne'e folafola ange 'e te 'Atuá, takua 'e nofo muli tono hakó 'i te fanua he kakai kehe, 'a ia 'e notou fakapōpula'i 'ia nātou, mo ngaahikovi'i, 'o fāngeau ta'u. ");
INSERT INTO num_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pea me'a mai 'e te 'Atuá, ‘'E Au fakamāu'i te kakai ko 'ē 'e notou nofo pōpula ki aí; pea hili iá 'e notou hiki atu leva mei ai, pea 'e notou fai te notou lotu kiā Aú 'i te feitu'u ko 'ení.’ ");
INSERT INTO num_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Pea ne'e tuku kiā ia 'ia te fuakavakamú. Pea 'i tana peheé, ne ina ma'u he foha ko 'Aisake, pea ne'e kamu 'ona 'i tono 'aho valú; pea ma'u leva 'e 'Aisake 'ia Sēkope; pea ma'u 'e Sēkope 'ia te kau hongofulu mā ua pēteliaké. ");
INSERT INTO num_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Pea meheka 'ia te kau pēteliaké kiā Siosifa, 'o notou fakatau 'ona ki 'Isipite; ka ne'e 'iā ia 'ia te 'Atuá, ");
INSERT INTO num_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","mo fakahaofi 'ona mei tana faingata'a'ina kotoa pē, mo tuku ke 'ofaina ia mo ngali poto 'i te 'ao 'o Felo ko te Tu'i 'Isipité, 'a ē ne'e fakanofo 'ona ko te pule 'o 'Isipite mo tono falé kotoa pē. ");
INSERT INTO num_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Pea ne'e tō he honge ki 'Isipite fuli pē mo Kēnani, pea lahi mo te faingata'á; pea ko te tou mātu'á ne'e kala notou ma'u he me'akai. ");
INSERT INTO num_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kā 'i te fanongo 'e Sēkope ki te uite'ina 'o 'Isipité, ne ina fekau atu ki ai te tou kau mātu'á, ko te fu'aki oó ia. ");
INSERT INTO num_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Pea 'i tono tu'a uá ne'e fakahaa'i 'e Siosifa 'ona ki tono 'ū tokouá; pea toki e'a leva kiā Felo 'ia te tupu'anga 'o Siosifá. ");
INSERT INTO num_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Pea ne'e fekau ange 'e Siosifa ke 'aumai 'ia Sēkope ko tana tamaí, mo tono kāingá kotoa pē, ko te toko fitungofulu mo te toko nima. ");
INSERT INTO num_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Pea ne'e 'alu ifo 'ia Sēkope ki 'Isipite, pea pekia ia 'i ai mo te tou kau mātu'á, ");
INSERT INTO num_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","pea ne'e hiki 'ia nātou ki Sikemi, 'o telio 'i te fanualoto ne'e fakatau pa'anga 'e 'Ēpalahame mei te fānau 'a Hēmoá 'i Sikemi. ");
INSERT INTO num_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Pea 'i te faka'a'au ke ofi mai te taimi 'o te tala'ofá, 'a ē ne'e fai 'e te 'Atuá kiā 'Ēpalahamé, pea tupu 'ia te kakaí 'i 'Isipite, 'o fu'u tokolahi 'aupito. ");
INSERT INTO num_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ka ne'e faifaí pea hau 'i 'Isipite he tu'i 'e taha, 'a ia ne'e kailoa ha'aná 'ilo kiā Siosifa. ");
INSERT INTO num_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Pea ne'e fai kākā ia ki te tou kāingá, mo ngaahikovi'i te tou kau mātu'á; ko ia ai ne'e notou laku ki tu'a te notou kau valevalé ke 'aua na'a notou ma'uli. ");
INSERT INTO num_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ko te kuonga pē ia ne'e fanau'i ai 'ia Mōsesé; pea ne'e faka'ofa'ofa lahi ia. Pea ne'e tauhi ia 'o māhina tolu 'i te fale 'o tana tamaí; ");
INSERT INTO num_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","pea 'i tono tuku 'ona ki tua'aá, ne'e fakaake'i 'ona 'e te 'ofafine 'o Feló, 'o tauhi 'ona ma'aná tama. ");
INSERT INTO num_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Pea ne'e ako'i 'ia Mōsese 'i te fa'ahinga poto kotoa pē 'o te kakai 'Isipité, pea kaukaua foki tana 'ū leá mo tana 'ū ngāué. ");
INSERT INTO num_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Pea 'i tana a'u ki tono fāngofulu ta'ú, pea ake 'i tono lotó ke 'a'ahi ki tono kāinga ko ha'a 'Isilelí. ");
INSERT INTO num_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Pea 'i tana sio leva he toko taha 'oku ngaahikovi'í, ne'e langomaki'i leva 'e ia 'ona, 'o fai sāuni ma'a te fakamālohiná, 'o taa'i 'e ia 'ia te tangata 'Isipité. ");
INSERT INTO num_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Pea ne'e mahalo ia 'e 'ilo'i leva tono kāingá 'oku nima'aki 'ona 'e te 'Atuá ke 'aumai he notou fakama'uli; kā ne kailoa notou 'ilo'i ia 'e nātou. ");
INSERT INTO num_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ko te 'aho leva tono hokó, ne'e fakahaa'i ia ki te notou toko ua ne'e nā keé, pea feinga ia ke fakalelei'i nāua, 'i tana iange, ‘'Oku kulā kāinga pē; ka ko te ā 'oku kulā fekainaki aí?’ ");
INSERT INTO num_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kā ko te tangata ne tupu ai te koví ne'e teke'i 'e ia 'ia Mōsese, 'o iange, ‘Ko ai ne'e fakanofo 'ou ko te motou pule mo te fakamaaú? ");
INSERT INTO num_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Na'a ko tou lotó ke fakapoongi 'oku, hangē ko tau fakapoongi te 'Isipite 'aneafí?’ ");
INSERT INTO num_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Pea hola ai 'ia Mōsese 'i te lea ko iá, pea 'āunofo ia 'i te fanua ko Mitianí, 'o ma'u ai he ongo foha 'e toko ua. ");
INSERT INTO num_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Pea 'osi he ta'u 'e fāngofulu, pea toki hā kiā ia he 'āngelo 'i te toafa 'o te ma'unga ko Sainaí, mei te loto afi ne'e ulo 'i te 'ulu 'akau. ");
INSERT INTO num_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Pea 'i te sio ki ai 'e Mōsesé, ne'e ofo ia 'i te me'a ne'e hā maí; pea 'i tana 'unu'unu atu ke fakasio ki aí, 'iloangé ko te le'o 'o te 'Alikí 'oku pehē mai, ");
INSERT INTO num_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ko Au ko te 'Atua 'o tou kau mātu'á, ko te 'Atua 'o 'Ēpalahame mo 'Aisake mo Sēkope.’ Pea toki tetetete 'ia Mōsese, 'o manahē 'aupito ia ke toe fakasio atu. ");
INSERT INTO num_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Pea folafola ange 'e te 'Alikí kiā ia, ‘To'o tou senitoló mei tou va'é, he ko te feitu'u 'oku ke tu'u aí ko te kelekele tapu. ");
INSERT INTO num_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kua U mātu'aki mamata ki te ngaahikovi'i Toku kakaí, 'a ē 'oku 'i 'Isipité, pea kua ongo mai te notou to'é, pea ko Taku 'alu ifo 'eni ke fakahaofi 'ia nātou. Pea ko 'eni, ha'u ā ke Au fekau atu 'ou ki 'Isipite.’ ");
INSERT INTO num_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ko Mōsese ko iá ne'e notou fakafisinga'i, 'i te notou pehē, ‘Ko ai ne'e fakanofo 'ou ko te motou pule mo te fakamaaú?’ — ko 'eni ia 'ia te tangata ne'e fekau atu 'e te 'Atuá ko te notou pule mo te huhu'i, 'o fakafou Tana fekaú 'i te 'āngelo ne'e hā kiā ia 'i te 'ulu 'akaú. ");
INSERT INTO num_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ko 'eni ia ne'e taki atu ki tua'ā 'ia nātoú, hili tana fai 'ia te 'ū me'a fakaofo, mo te 'ū faka'ilonga mana, 'i te fanua ko 'Isipité, mo te Tai Kulakulá, pea mo te toafá, 'o fāngofulu ta'u. ");
INSERT INTO num_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ko 'eni ia 'ia te Mōsese ne'e me'a ki te ha'a 'Isilelí, 'o pehē, ‘'E fokotu'u 'e te 'Atuá ma'a kōtou mei te kotou kāingá he palōfita 'oku hangē ko aú.’ ");
INSERT INTO num_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ko 'eni ia ne'e 'i te fakataha 'i te Toafá, 'o feangai mo te 'āngeló, 'i Tana folafola mai kiā ia 'i te ma'unga ko Sainaí; 'o feangai foki Ia mo te tou mātu'á. Ko ia ia 'ia te taha ne'e ma'u 'ia te 'ū Folafola ma'ulí ke 'aumai mo'o tātou. ");
INSERT INTO num_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ka ne'e kailoa fia talangafua ki ai te tou kau mātu'á, ka ne'e notou teke'i 'ona, 'o notou foki 'i te notou lotó ki 'Isipite, ");
INSERT INTO num_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","'o notou iange kiā 'Ēlone, ‘Ngaahi mai he tou fanga 'atua ke takiala kiā tātou; hē ko te me'a ki te siana nei ko Mōsesé, 'a ē ne'e 'aumai 'ia tātou mei 'Isipité, 'oku kala motou 'ilo'i pe ko te ā kua hoko kiā iá.’ ");
INSERT INTO num_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Pea notou ngaahi he ki'i pulu 'i te taimi ko iá, pea notou 'avake feilaulau ki te 'aitolí, 'o notou hākahaka 'i te me'a ne'e ngaahi 'e te nima 'o nātoú. ");
INSERT INTO num_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Pea tafoki ai te 'Atuá, 'o tukuange 'ia nātou ke notou lotu ki te hōsitē 'o langí, 'o hangē ā ko ia 'oku tohi 'i te Tohi Palōfitá, 'o pehē, ‘'E ha'a 'Isileli, he ne'e kotou tauhi mai koā he 'ū feilaulau, mo he 'ū me'a'ofa 'i te ta'u 'e fāngofulu ko ia 'i te toafá? ");
INSERT INTO num_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kae'uma'ā ne'e kotou to'o ake 'ia te tāpanekale 'o Moloké, mo te fetu'u 'o te kotou 'atua ko Lēfaná, ko te ongo fakatātā ne'e kotou ngaahi ke kotou lotu ki aí. 'Io, 'e Au hiki kōtou ki tu'a Pāpilone.’ ");
INSERT INTO num_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ne'e ma'u te tou kau mātu'á 'ia te tāpanekale 'o te fakamo'oní 'i te toafá, 'o hangē ko te tu'utu'uni 'e Ia ne'e folafola kiā Mōsesé, 'o fekau ke ngaahi ia ke hangē ko te fakatātā kua ina mamata ki aí. ");
INSERT INTO num_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Pea ne'e 'aumai 'e te tou kau mātu'á mo Siosiua ki te fanua 'o te kakai Senitailé, 'ia nātou ne'e kapusi 'e te 'Atuá mei te 'ao 'o te tou kau mātu'á, 'o a'u mai ki te 'ū 'aho 'o Tēvitá. ");
INSERT INTO num_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ne'e 'ofaina 'ona 'i te 'ao 'o te 'Atuá, pea kole ia ki te 'Atuá ke tukuange ke ina langa he fale mo'o te 'Atua 'o Sēkopé. ");
INSERT INTO num_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ne'e toki langa 'e Solomone Mo'ona he fale. ");
INSERT INTO num_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Kā neongo iá, kae tala'i'eaí 'oku 'afio 'ia te 'Aliki Taupotú he me'a 'oku ngaahi 'e te nimá; 'o hangē ko te lea 'a te palōfitá: ");
INSERT INTO num_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘'Oku folafola mai 'e te 'Alikí, ko te langí ko Toku taloni pē, pea mo māmani ko Toku tu'unga va'e pē. Pea ko te ā ai te anga 'o te fale 'e kotou langa maí? Pea ko fea 'ia te feitu'u ke Au mālōlō aí? ");
INSERT INTO num_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ne'e kailoa koā ngaahi 'e Toku nimá 'ia te 'ū me'a ko 'ení kotoa pē?’ ");
INSERT INTO num_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","'Ia te fa'ahinga kia kekeva, mo ta'ekamu te kotou lotó mo te talingá, 'oku kotou teke'i ma'u ai pē 'ia te Laumālie Mā'oni'oní, 'o hangē ko te kotou mātu'á 'i mu'a. ");
INSERT INTO num_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ko fea he taha 'o te kau palōfitá ne'e kailoa fakatanga'i 'e te kotou mātu'á 'i mu'a? Pea kua notou tāmate'i 'ia nātou ne'e notou fu'aki tala 'ia te hā'ele mai 'a te Toko Taha Anga-tonú; 'a ia kua kotou toki lavaki'i mo fakapoongí, ");
INSERT INTO num_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ko kōtou ne'e kotou ma'u te Laó 'i te 'ao 'o te kau 'āngelo, ka ne'e kala kotou tauhi ki ai.” ");
INSERT INTO num_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Pea 'i te notou fanongo ki te me'a ko iá, ne'e hangē kua kilisiuá te notou lotó, 'o notou 'ūtaki kaunifo kiā ia. ");
INSERT INTO num_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kā kua fonu 'ia Sitīveni 'i te Laumālie Mā'oni'oní; pea 'i tana sio fakamama'u ki te langí ne'e sio ia ki te Sikaina 'o te 'Atuá, mo Sīsū 'oku tu'u mei te to'omata'u 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Pea pehē 'e ia, “Vakai, 'okou sio 'eni ki te 'ū langí kua matangaki, pea ko te Fanautama te Tangatá 'oku tu'u mei te 'āfaki to'omata'u 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pea ne'e kaikaila te hau'aliki fakatahá, 'o notou tāpuni'i te notou talingá, pea notou 'oho taha kiā ia, ");
INSERT INTO num_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","'o notou toho'i 'ona ki te tu'a koló, 'o tolomaka'i. Pea ko te kau tukuaki'í ne'e notou tuku atu te notou 'ū koté ki te va'e 'o he talavou ne'e hingoa ko Saula. ");
INSERT INTO num_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Pea 'i te notou fai tono tolomaka'i 'o Sitīvení ne'e lotu pē ia 'o pehē, “'Aliki Sīsū, ke Ke ma'u atu Toku laumālié.” ");
INSERT INTO num_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Pea tū'ulutui leva ia, 'o kalanga le'o lahi, “'Aliki, 'aua na'a lau te angahala nei kiā nātou!” Pea hili tana lea peheé ne'e moe leva ia. ");
INSERT INTO num_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Pea ko Saula ne'e loto pē ia ki tono fakapoongí. Pea 'i te 'aho ko iá ne'e hoko ai he fu'u fakatanga ki te siasí 'i Selusalema. Pea ne'e mavetevete 'ia nātou kotoa pē ki te 'ū feitu'u 'o Siutea mo Samēliá; ko te kau 'apōsetoló pē ne'e kailoa. ");
INSERT INTO num_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Pea ne'e fai 'ia te putu 'o Sitīvení 'e te mātu'a lotu mo'oni, 'o notou tangilāulau 'iā ia. ");
INSERT INTO num_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Pea ko Saulá leva, ne ina have'i 'ia te siasí, 'aki tana hū ki te fale kotoa pē, mo toho 'ia te kakai tangatá mo fafine fakatou'osi, 'o fakahū pilīsone. ");
INSERT INTO num_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pea ko nātou ne'e vetekiná ne'e notou ō atu pē mo malanga 'aki 'ia te Folafolá. ");
INSERT INTO num_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pea 'alu ifo 'ia Filipe ki te kolo 'i Samēlia 'o malanga 'aki 'ia Kalaisi kiā nātou. ");
INSERT INTO num_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Pea ne'e tokanga taha 'ia te kakaí ki te 'ū fakamatala 'a Filipé, he ne'e notou fanongo mo mamata ki te 'ū faka'ilonga mana ne'e fai 'e iá. ");
INSERT INTO num_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","He ko te tokolahi 'iā nātou ne'e notou ma'ua 'i te fa'ahikehé ne'e notou hū mai ki tu'a mo te fu'u kaila; pea ne'e fakama'uli mo te tokolahi ne'e notou mamatea mo heké. ");
INSERT INTO num_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Pea ne'e lahi te fiafiá 'i te kolo ko iá. ");
INSERT INTO num_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pea ne'e 'i ai he tangata ne'e hingoa ko Saimone, ne'e nofo mu'amu'a ia 'i te koló, 'o fai tana ngāue maki; pea ne'e to'oa te loto 'o te kakai Samēliá 'iā ia, 'i tana pehē, takua, ko te toko taha ia 'oku kehe. ");
INSERT INTO num_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Pea ne'e tokanga kotoa pē kiā ia 'e te liliki mo te lalahi, 'o notou pehē, “Ko te toko taha nei ko te fe'i ivi mālohi ia 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Pea ne'e notou tokanga kiā ia, he kua fualoa te notou to'oa 'i tana 'ū ngāue makí. ");
INSERT INTO num_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kā 'i te notou tui kiā Filipé, mo tana malanga 'aki 'ia te Pule'anga 'o te 'Atuá, mo te Huafa 'o Sīsū Kalaisí, ne'e notou papitaiso, 'ia te kau tangatá mo te kau fafiné foki. ");
INSERT INTO num_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Pea ne'e tui foki mo Saimone; pea 'i te 'osi tono papitaisó ne'e ma'unganofo ia kiā Filipe, pea 'i tana mamata ki te 'ū faka'ilonga maná, mo te fu'u ngāue fakaofo ne'e faí, ne'e to'oa ai tono lotó. ");
INSERT INTO num_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Pea 'i te fanongo te kau 'apōsetoló mei Selusalema, takua kua tali 'e Samēlia 'ia te Folafola 'a te 'Atuá, ne'e notou fekau atu kiā nātou 'ia Pita mo Sione. ");
INSERT INTO num_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pea 'i te nā a'u ifó, ne'e nā hūfia 'ia nātou ke notou ma'u 'ia te Laumālie Mā'oni'oní; ");
INSERT INTO num_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","he kua he'iki ai hifo Ia ki te notou toko taha, ka ne'e notou ngata pē 'i te papitaiso ki te Huafa 'o te 'Aliki ko Sīsuú. ");
INSERT INTO num_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pea nā toki hilifaki te nā nimá kiā nātou, pea notou ma'u leva 'ia te Laumālie Mā'oni'oní. ");
INSERT INTO num_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Pea 'i te vakai 'e Saimone 'oku 'alu ifo 'ia te Laumālie Mā'oni'oní 'i te hilifaki te nima 'o te ongo 'apōsetoló, ne'e mono atu 'e ia he pa'anga kiā nāua, ");
INSERT INTO num_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","'o pehē ange, “Tuku mai foki kiā au 'ia te mafai ko iá, kote'uhí ke 'ilonga he taha 'e au hilifaki nima ki ai, pea ma'u 'e ia 'ia te Laumālie Mā'oni'oní.” ");
INSERT INTO num_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pea pehē ange 'e Pita kiā ia, “Ke 'alu 'ia koe mo tau pa'angá ki mala, kote'uhí ko tau fakakaukau ke fakatau 'ia te me'a'ofa 'o te 'Atuá 'aki he pa'anga. ");
INSERT INTO num_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","'Oku kailoa 'aupito hau 'inasi, 'uma'ā hau kaunga 'i te me'a ko 'ení, he 'oku kailoa totonu tou lotó 'i tau fakafeangai ki te 'Atuá. ");
INSERT INTO num_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ko ia ai fei mo liliu leva 'ia koe mei te anga-kovi ko 'ení, pea hū ki te 'Alikí; hei'ilo na'a fakamolemole'i ai te fakakaukau 'o tou lotó. ");
INSERT INTO num_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","He kua u vakai atú 'oku kei ma'ua 'ia koe 'i te kona 'o te 'ahú, mo te ha'i 'o te angahalá.” ");
INSERT INTO num_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Pea tali 'e Saimone 'o pehē ange, “Kulā hūfia mu'a 'oku ki te 'Alikí, ke 'aua na'a hoko kiā au he taha 'o te 'ū me'a kua kulā lea ki aí.” ");
INSERT INTO num_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pea ko nāua, hili te nā fakapapau'i mo te nā malanga 'aki te Folafola 'a te 'Alikí, ne'e nā foki leva ki Selusalema, 'o malanga 'aki 'ia te ongoongoleleí 'i te 'ū kolo lahi 'o te kau Samēliá. ");
INSERT INTO num_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Pea me'a kiā Filipe he 'āngelo 'a te 'Alikí, 'o pehē ange, “Tu'u 'o 'alu ki te feitu'u tongá, ki te ala 'oku 'alu ifo mei Selusalema ki Kesá; ko te ala ia 'oku 'alu 'i te lalá.” ");
INSERT INTO num_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Pea tu'u ia 'o 'alu atu. Pea tā ne'e 'i ai he matāpule 'Itiopea, pea ko te 'iunoke, ko te minisitā 'o Kanetake ko te kuini 'o te kakai 'Itiopeá, pea ko ia ia ne'e tauhi tana koloá kotoa pē. Pea kua 'alu ake ia ki Selusalema ke fai tana lotu, ");
INSERT INTO num_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","pea ko tana fokí 'eni, pea 'oku nofo ia 'i tana sālioté 'o lau 'ia te tohi 'a te palōfita ko 'Aiseá. ");
INSERT INTO num_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Pea folafola 'e te Laumālié kiā Filipe, “'Unu'unu atu 'o kulā ō mo te sāliote ko 'ená.” ");
INSERT INTO num_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pea 'i te lele atu 'ia Filipé, ne'e fanongo atu ia ki tana lau te tohi 'a te palōfita ko 'Aiseá, pea pehē atu 'e ia, “'Oku mahino kiā koe tau me'a 'oku laú?” ");
INSERT INTO num_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Pea me'a mai leva ia, “Ke au mahino'i fefe'aki, hē 'oku kailoa he taha ke fakahinohino'i 'oku?” Pea kole ange ia kiā Filipe ke heka mai ke nā nonofo. ");
INSERT INTO num_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Pea ko 'eni 'ia te potu tohi ne'e laú, “Ne'e taki atu Ia 'o hangē ko he sipi ke tāmate'í; pea hangē ko te longo he lami 'i tono ngaahi 'e te tangata 'oku kosi iá, ne'e pehē tofu pē te ta'emafa'a Tono fofongá. ");
INSERT INTO num_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","'I Tana mā'ulaloá ne'e fakamālohina Tono fakamaaú; pea ko ai 'e lea ki Hana hako? He kua 'ave Ta'aná ma'uli mei māmani.” ");
INSERT INTO num_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Pea lea ange 'e te 'iunoké kiā Filipe, 'o pehē, “Fakamolemole, ka ke tala'i mai mu'a, pe ko te lea 'eni 'a te palōfitá kiā ai? Kiā ia pē, pe ki te taha kehe?” ");
INSERT INTO num_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Pea hanga leva 'e Filipe 'o lea, 'o kamata mei te potu tohi ko iá tana malanga 'aki 'ia Sīsū kiā ia. ");
INSERT INTO num_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Pea 'i te nā fononga 'i te alá, ne'e nā a'u ki te vai; pea iange 'e te 'iunoké, “'Ē, ko te vai 'eni; 'oku 'i ai he 'uhinga ke ta'ofi 'aki toku papitaisó?” ");
INSERT INTO num_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pea tali 'e Filipe, “Kāpau 'e ke tui 'aki te kātoa tou lotó, 'e ke lava.” Pea tali ange 'e ia 'o pehē, “'Okou tui ko Sīsū Kalaisí ko te 'Alo Ia 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Pea fekau 'e ia ke tu'u te sālioté; pea nā ō ifo leva ki te vaí, 'ia Filipe mo te 'iunoké fakatou'osi, pea ne'e papitaiso 'ona 'e Filipe. ");
INSERT INTO num_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pea 'i te nā ō ake mei te vaí, ne'e punakaki 'ia Filipe 'e te Laumālie 'o te 'Alikí, pea ne'e kailoa toe sio kiā ia 'e te 'iunoké; pea ne'e fai atu ta'aná fononga kua fonu fiafia tono lotó. ");
INSERT INTO num_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ka ne'e hā 'ia Filipe ia 'i 'Asota, pea ne'e malanga 'aki ia 'ia te ongoongoleleí 'i te 'ū kolo ko iá fuli pē, 'o a'u atu ki Sesalia. ");
INSERT INTO num_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kā ko Saula ne'e kei mānava 'aki ia 'ia te fakamanamana mo te lau fakapō ki te kau ako 'a te 'Alikí, pea 'alu ai ia ki te Taula'aliki Lahí, ");
INSERT INTO num_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","'o kole kiā ia ke fai he 'ū tohi ki Tāmasikusi ki te 'ū falelotú, ke fakangafua tana ha'i mo taki mai ki Selusalema 'ia nātou 'e 'ilo'i 'i ai kua notou tali 'ia te 'alunga 'o te 'Alikí, 'ia te tangata mo fafine. ");
INSERT INTO num_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Pea 'i te fai tana fonongá, 'o fakaofiofi atu ki Tāmasikusí, fokifā pē kua malama mai takatakai kiā ia he maama mei te langí. ");
INSERT INTO num_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Pea tō ia ki te kelekelé, 'o fanongo ki te le'o 'oku pehē mai, “'E Saula, 'e Saula, ko te ā kua ke fakatanga'i ai 'Okú?” ");
INSERT INTO num_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Pea pehē ange ia, “'E 'Aliki, ko ai 'ia Koe?” Pea me'a mai 'e Ia, “Ko Au Sīsū, 'a ia 'oku ke fakatanga'í. ");
INSERT INTO num_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kā ke tu'u ake, 'o hū ki kolo; pea 'e fakahaa'i ai kiā koe 'ia te me'a kua pau ke ke faí.” ");
INSERT INTO num_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Pea ne'e tutu'u pē te kau tangata ne'e fononga mo iá 'oku notou mā'ulongoa, he ne'e notou fānonongo pē ki te le'ó, ka ne'e kailoa notou sio nātou ia he taha. ");
INSERT INTO num_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Pea kua tu'u ake 'ia Saula, 'o fakaava tono matá, pea tā kua kailoa toe 'ilo'i ia he me'a. Pea notou takinima'i 'ona 'o 'aumai ki Tāmasikusi. ");
INSERT INTO num_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Pea ne'e nofo ia 'i ai 'i te 'aho 'e tolu, kae kui pē; pea ne'e kailoa kai ia pe inu. ");
INSERT INTO num_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Pea ne'e nofo 'i Tāmasikusi he ako ne'e hingoa ko 'Ānanaia; pea ne'e folafola 'e te 'Alikí kiā ia 'i te vīsone, 'o pehē ange, “'E 'Ānanaia.” Pea pehē ange ia, “'Aliki, ko au 'eni.” ");
INSERT INTO num_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Pea folafola 'e te 'Alikí kiā ia, “Tu'u, pea ke 'alu ki te ala 'oku hingoa ko Totonú, 'o 'eke 'i te fale 'o Siutasí ki he matu'a Tāsusi ko tono hingoá ko Saula. He ko 'eni, 'oku fai ia tana lotu; ");
INSERT INTO num_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","pea kua ina mamata 'i te vīsone ki te tangata 'oku hingoa ko 'Ānanaia, 'oku hū mai 'o hilifaki tono nimá kiā ia, kote'uhí ke toe 'a'ala tono matá.” ");
INSERT INTO num_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Pea tali ange 'e 'Ānanaia, “'Aliki, kua u fanongo mei te tokolahi ki te tangata nei, mo tana ngaahikovi'i lahi Tou kakai tapú 'i Selusalema. ");
INSERT INTO num_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Pea 'i hení kua ne ma'u tu'utu'uni mei te kau taula'aliki lahí, ke ha'i 'ia te kakai kotoa pē 'oku notou tāpafua'i Tou huafá.” ");
INSERT INTO num_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pea folafola ange 'e te 'Alikí kiā ia, “'Alu koe ia; he ko te ipu mātu'aki fili 'eni ia 'A'aku, ke hapai Toku hingoá 'i te 'ao 'o te Senitailé, mo te ha'a tu'í, mo te ha'a 'Isilelí foki. ");
INSERT INTO num_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","He ko Aú 'e Au fakahaa'i kiā ia 'ia te 'ū fu'u mamahi 'e tō kiā ia kote'uhí ko Toku hingoá.” ");
INSERT INTO num_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Pea toki 'alu 'ia 'Ānanaia, 'o hū ki te falé; 'o hilifaki tono nimá kiā ia, 'o pehē ange, “'E Saula, ko te 'Aliki ko Sīsuú, 'ā ē ne'e hā atu kiā koe 'i te alá 'i tau fononga maí, kua Ina fekau mai 'oku kote'uhí ke toe 'ala tou matá, mo ke fonu 'i te Laumālie Mā'oni'oní.” ");
INSERT INTO num_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Pea ne'e ngangana leva mei tono ongo fe'i matá he me'a hangē he 'uno'i iká; pea ne'e 'ala ia, 'o tu'u ake 'o papitaiso. ");
INSERT INTO num_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Pea 'i te 'osi ange tana kaí, ne'e mālohi ia. Pea ne'e nofo ia mo te kau akó 'i Tāmasikusi 'i te 'ū 'aho 'ihi. ");
INSERT INTO num_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Pea ne'e kamata leva 'e ia ke malanga 'aki 'ia Sīsū 'i te 'ū falelotú, 'o pehē, “Ko te 'Alo Ia 'o te 'Atuá.” ");
INSERT INTO num_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Pea fakatumutumu 'ia nātou kotoa pē ne'e fānonongo ki aí, 'o notou pehē, “'Oku kailoa koā ko te siana 'eni ne'e laiki 'ia te kakai 'o Selusalema 'ā ē ne'e notou tāpafua'i 'ia te hingoa ko 'ení? Pea 'oku kailoa koā ko ta'aná ha'u 'ení ke fai te me'a tatau, 'o taki pōpula 'ia te kakaí ki te kau taula'aliki lahí?” ");
INSERT INTO num_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ka ne'e toe fakautuutu ai te mālohi 'o Saulá mo tana fakapuputu'u'i te kakai Siu ne'e nofo 'i Tāmasikusí, ko te mālohi tana fakamo'oni ko Sīsū 'ia te Kalaisí. ");
INSERT INTO num_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pea kua 'osi 'eni te 'ū 'aho lahi, pea kua fakakaukau'i 'e te kakai Siú ke notou tāmate'i 'ona; ");
INSERT INTO num_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ka ne'e 'ilo'i pē 'e Saula te notou fakakaukaú. Pea ne'e notou le'ohi 'ia te 'ū matapaá 'i te 'aho mo te pō ke notou tāmate'i ia. ");
INSERT INTO num_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ka ne'e 'ave pō'uli 'ona ia 'e tana kau akó, 'o notou tuku'i ifo 'ona 'i te 'aá, 'o tukutuku ifo ki lalo 'i te kato. ");
INSERT INTO num_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Pea 'i te ha'u 'ia Paula ki Selusalemá, ne ina feinga ke fakahoko 'ona ki te kau akó; ka ne'e notou teteki kotoa pē kiā ia, he ne'e kala notou falala 'e nātou ko he ākonga ia. ");
INSERT INTO num_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ka ne'e 'ave ia 'e Pānepasa, 'o taki 'ona ki te kau 'apōsetoló, pea fakamatala'i 'e ia kiā nātou tana mamata ki te 'Alikí 'i te alá, mo te folafola 'a te 'Alikí kiā iá, mo tana malanga mālohi 'aki te huafa 'o Sīsuú 'i Tāmasikusí. ");
INSERT INTO num_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Pea nofo ia 'i ai 'o felemofafo mo nātou 'i Selusalema, mo malanga mālohi 'aki 'ia te huafa 'o te 'Alikí; ");
INSERT INTO num_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","pea ne'e lea mālohi 'e ia ki te fa'ahinga ne'e lea faka-Kalisí, 'o fakakikihi mo nātou; ka ne'e feinga leva 'e nātou ia ke tāmate'i 'ona. ");
INSERT INTO num_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Pea 'i te 'ilo ki ai 'e te kāingá, ne'e notou holataki'i 'ona ki Sesalia, 'o fekau ke 'alu mei ai ki Tāsusi. ");
INSERT INTO num_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Pea ne'e toki ma'u fiamālie 'e te siasí 'i Siutea kātoa, mo Kāleli, mo Samēlia, pea ne'e langa'i ake ai pē 'ia nātou; mo notou 'a'eva 'i te 'apasia ki te 'Alikí. Pea 'i te tokoni mo te fakalotolahi ne'e fai 'e te Laumālie Mā'oni'oní ne'e notou tutupu 'o tokolahi. ");
INSERT INTO num_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pea ko 'eni, lolotonga tono fai 'e Pita tana 'a'ahi ki te kakai lotú kotoa pē, ne'e a'u ifo ia kiā nātou ne'e nofo 'i Litá. ");
INSERT INTO num_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Pea ne ina 'ilo'i ai he tangata ne'e hingoa ko 'Eneasi, 'a ia kua ta'u valu tana takotó he ko te mamatea. ");
INSERT INTO num_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pea lea 'e Pita kiā ia, “'E 'Eneasi, 'oku faito'o 'ou 'e Sīsū Kalaisi; tu'u 'o takai tou moe'angá 'e koe.” Pea tu'u leva ia. ");
INSERT INTO num_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Pea ne'e mamata kiā ia 'e te fu'u kakai kotoa pē ne'e notou nofo 'i Litá, mo te feitu'u ko Saloní, pea ne'e notou tafoki ai ki te 'Alikí. ");
INSERT INTO num_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Pea ne'e nofo 'i Siopa he fafine ako ne'e hingoa ko Tāpaita, pea 'oku ui 'i te lea 'e tahá ko Toakase, ne'e fa'a fai 'e ia te 'ū ngāue lelei mo te ngāue 'ofa ki te tu'utāmakí. ");
INSERT INTO num_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pea 'i te taimi ko iá ne'e tu'ina ia he mahaki, 'o pekia. Pea hili ange te notou tatafi iá, ne'e notou tuku tono sinó he loki 'i lunga. ");
INSERT INTO num_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Pea ko te me'a 'i te vāofi 'ia Lita mo Siopá, mo te fanongo 'e te kau akó 'oku 'i ai 'ia Pitá, ko ia ne'e notou fekau atu kiā ia he ongo tangata, ke nā kole ange 'o pehē, “'Aua ke fai tuai kā ke a'u vave mai kiā mātoú.” ");
INSERT INTO num_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pea tu'u leva 'ia Pita, 'o ō mo nātou. Pea 'i tana lava maí ne'e notou 'avake 'ona ki te loki 'i lungá. Pea ne'e tutu'u mai 'ia te kau uitoú kotoa pē 'oku notou tangi, mo faka'ali'ali ange te notou 'ū kofu loto mo te 'ū kofu tu'a, 'ā ē ne'e ngaahi 'e si'i Toakasé lolotonga tana kei ma'ulí. ");
INSERT INTO num_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pea ne'e kapusi 'ia nātou kotoa pē 'e Pita, pea tū'ulutui ia 'o lotu, 'o toki tafoki ange 'e ia 'o lea ki te 'anga'angá 'o pehē, “Tāpaita, tu'u ake!” Pea 'ala leva tono matá, pea 'i tana vakai kiā Pitá, ne'e tangutu ake ia. ");
INSERT INTO num_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pea mafao atu 'e Pita tono nimá ki te fafiné, 'o fokotu'u ia; pea ui mai 'e ia 'ia te kakai lotú mo te kau uitoú, 'o 'avatu 'ona kiā nātou kua ma'uli. ");
INSERT INTO num_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Pea ne'e ongoongoa 'eni 'i Siopa fuli pē, pea tui ai he tokolahi ki te 'Alikí. ");
INSERT INTO num_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pea ne'e nofo fualoa 'ia Pita 'i Siopa 'i te fale 'o he matu'a ko Saimone ko te tufunga kili'i manu. ");
INSERT INTO num_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Pea ne'e 'i ai he tangata 'i Sesalia ne'e hingoa ko Koliniusi, ko te senituliō ia 'i te vāhenga tau ne'e ui ko te “Vāhenga tau 'Ītali”; ");
INSERT INTO num_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ko te toko taha lotu mo'oni pea 'apasia ki te 'Atuá, 'e ia mo tono falé kotoa, pea ne'e lahi tana fai 'ofa ki te kakai Siu ne'e tu'utāmakí; pea ne'e lotu ia ki te 'Atuá ma'u ai pē. ");
INSERT INTO num_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Pea fe'unga nai mo te tolu afiafí 'i te 'aho 'e taha, ne'e mamata ia he vīsone ki te 'āngelo 'a te 'Alikí, 'oku hū ange 'o me'a mai, “'E Koliniusi.” ");
INSERT INTO num_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kae sio fakamama'u pē ia, mo manahē, 'o pehē atu, “'E 'Aliki, ko te ā?” Pea me'a mai 'e ia, “Kua tau ake tau 'ū lotú, mo tau 'ū foaki 'ofá, ko te me'a ke manatu ki ai 'e te 'Atuá. ");
INSERT INTO num_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Pea ko 'eni, fekau leva he kau tangata ki Siopa ke 'aumai te matu'a ko Saimone, 'a ia 'oku hingoa foki ko Pitá. ");
INSERT INTO num_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Pea 'oku nofo ia mo Saimone ko te tufunga kili'i manu, pea 'oku tu'u tono falé 'i matātaí.” ");
INSERT INTO num_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Pea kua sītu'a te 'āngelo ne'e lea kiā iá, pea ui ange 'e ia he toko ua 'o tana kau tamaio'alikí, mo he toko taha 'i te kau taú 'a ē ne'e ma'unganofo kiā iá, ko te sōtia lotu mo'oni; ");
INSERT INTO num_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","pea 'i te 'osi tana fakamatala'i kotoa pē te 'ū me'á kiā nātoú, ne ina fekau atu 'ia nātou ki Siopa. ");
INSERT INTO num_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Pea 'i te 'aho tono hokó, lolotonga te fononga mai 'ia te kau tangatá, 'o fakaofiofi atu ki te koló, kua 'alu ake 'ia Pita ki te tu'a falé ke fai tana lotu, fe'unga nai mo te ho'atā mālié. ");
INSERT INTO num_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pea kua hālofia ia, pea loto leva 'e ia ke ma'u he me'atokoni; pea lolotonga te notou teuteú ne'e 'āvea tono lotó. ");
INSERT INTO num_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Pea vakai atu ia 'oku matangaki 'ia te langí, pea 'oku 'alu ifo he 'angame'a hangē he fu'u laá, pea 'oku tukutuku ifo ia ki māmani 'oku puke 'aki tono 'ū tuliki 'e faá. ");
INSERT INTO num_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Pea ne'e 'i ai te fa'ahinga monumanu kehekehe 'o te kelekelé, 'ia te va'e fā mo te totolo, pea mo te manupuna 'o te 'ataá. ");
INSERT INTO num_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pea ne'e ongo mai he le'o kiā ia 'o pehē, “Tu'u, Pita, 'o tāmate'i 'o kai.” ");
INSERT INTO num_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ka ne'e pehē 'e Pita, “'E 'Aliki, 'e kala he me'a pehē; hē 'oku he'iki ai 'aupito ke au kai he 'ū me'a 'oku ta'etaau mo ta'ema'a.” ");
INSERT INTO num_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Pea tē hoko mai te le'o ko tono tu'a uá, 'o pehē ange, “Ko te 'ū me'a kua fakama'a 'e te 'Atuá, 'aua ke pehē 'e koe 'oku ta'etaau.” ");
INSERT INTO num_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ne'e fai pehē 'eni 'o tu'a tolu, pea toki 'avake 'ia te 'angame'á ki te langí. ");
INSERT INTO num_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pea lolotonga te fifili 'e Pita 'i tono lotó, pe ko te ā koā 'ia te vīsone ne'e mamata ki aí, mo tana a'u mai 'ia te kau talafekau 'a Koliniusí, 'a ia kua notou fehu'i holo ki te 'api 'o Saimoné, pea 'oku notou tutu'u ki te matapā hū'angá. ");
INSERT INTO num_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Pea ne'e notou ui, 'o fehu'i ange, pe 'oku 'apitanga ai 'ia Saimone, 'ā ē 'oku ui ko Pitá. ");
INSERT INTO num_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pea lolotonga te kei fakakaukau'i 'e Pita ki te 'uhinga 'o te vīsoné, mo te folafola 'e te Laumālié kiā ia, “Ko 'eni 'oku kumi 'ou 'e te kau tangata 'e toko tolu. ");
INSERT INTO num_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ko ia ke ke tu'u 'o 'alu ifo, 'o ō mo nātou, pea 'aua 'e ke mama'i tāla'a, he ko Ta'akú fekau 'ia nātou 'e Au.” ");
INSERT INTO num_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pea 'alu ifo 'ia Pita ki te kau tangatá, 'o pehē ange, “Ko au 'eni 'oku kotou kumi ki aí; ko te ā te me'a 'oku kotou ōmai aí?” ");
INSERT INTO num_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Pea notou tali ange, “Ko te senituliō ko Koliniusi, ko te matāpule faitotonu mo 'apasia ki te 'Atuá, pea fakaongolelei 'ona 'e te kakai Siú kotoa pē, pea ne'e fale'i 'ona he 'āngelo tapu ke 'aumai 'ou ki tono falé, ke ma'u fakamatala 'e ia meiā koe.” ");
INSERT INTO num_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pea ui ange 'e ia kiā nātou ke notou hū ange 'o 'apitanga 'i ai. Pea 'i te pongipongi aké ne'e tu'u ia 'o ō atu mo nātou, pea ne'e ō mo ia he 'ihi 'o te kāinga mei Siopá. ");
INSERT INTO num_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pea ne'e notou a'u ki Sesalia 'i te 'aho 'e tahá. Pea ne'e nofo talitali 'ia Koliniusi kiā nātou, kua fakataha mo tono kāingá pea mo tono 'ū kaume'á. ");
INSERT INTO num_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pea 'i te hū atu 'ia Pitá, ne'e fakafetaulaki kiā ia 'e Koliniusi, 'o hinga atu ki tono va'é, 'o hū. ");
INSERT INTO num_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ka ne'e langa'i 'ona ia 'e Pita, 'o pehē ange, “Tu'u pē, he ko te tangata foki mo au.” ");
INSERT INTO num_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pea nā hū atu pē mo talanoa mo ia; pea tā kua 'i ai he tokolahi kua fakataha. ");
INSERT INTO num_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pea lea ia kiā nātou, “'Oku kotou 'ilo'i, ko te me'a ia 'oku tāpuhā ki te tangata Siú ke feohi mo he toko taha 'i te fa'ahinga kehe, pe 'alu ki ai. Kā kua fakahā 'e te 'Atuá kiā au, ke 'aua na'a u toe ui he tangata kehe 'e toko taha 'oku ta'etaau pe ta'ema'a. ");
INSERT INTO num_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ko tono 'uhinga foki ia ne au ha'u ai 'i te kotou fekaú, 'o kailoa ke au toe tatalí. Ko ia ko taku fehu'í pe ko te ā ne'e kotou fia ma'u ai 'okú?” ");
INSERT INTO num_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Pea me'a ange 'e Koliniusi, “Ko te 'aho 'e fā kua 'osi angé, ne fai taku lotu 'i toku falé 'i te tolu afiafí, pea u fai atu ke a'u ki te feitu'ula'ā 'oku tou 'i ai ko 'ení; mo te 'ohovale pē kua tu'u mai he matāpule 'i toku 'aó kua kofu ngingila. ");
INSERT INTO num_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Pea pehē mai 'e ia, ‘'E Koliniusi, kua ongo ake tau huú, pea ko tau 'ū fai 'ofá kua manatu ki ai 'e te 'Atuá. ");
INSERT INTO num_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ko ia ke ke fekau leva ki Siopa, 'o iange ke ha'u 'ia Saimone, 'a ia 'oku hingoa foki ko Pitá; pea 'oku 'āunofo ia 'i te fale 'o Saimone ko te tufunga kili'i manu 'i te matātaí.’ ");
INSERT INTO num_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ko ia ne'e 'alu atu leva taku fekaú kiā koe; pea ko te me'a lelei ia ko tau lava maí. Pea ko 'eni kua motou tefua mai 'i te 'afio 'a te 'Atuá, ke fanongo ki te 'ū tu'utu'uni kua ha'u mo koe mei te 'Alikí.” ");
INSERT INTO num_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pea toki ofa'aki 'e Pita tana leá 'o pehē ange, “Tā ko tana toki mahino mai ē kiā au, 'oku kailoa filifilimānako 'ia te 'Atuá, ");
INSERT INTO num_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","kā neongo pe ko fea he kakai, kae 'ilonga pē ia 'oku 'apasia ki te 'Atuá, pea faitotonú, 'oku ngafua ke a'u mai kiā Ia. ");
INSERT INTO num_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tā ko te akonaki ia ne'e tuku atu ki te ha'a 'Isilelí 'i Tana fakahā 'iā Sīsū Kalaisi 'ia te ongoongolelei 'o te melinó; ko te 'Aliki Ia 'o te kakai kotoa pē. ");
INSERT INTO num_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","'Oku kotou 'ilo'i te ongoongo ne'e mafola 'i Siuteá kātoa, 'a ia ne'e kamata mei Kāleli, hili ange te papitaiso ne'e malanga 'aki 'e Sioné; ");
INSERT INTO num_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","'ia te ongoongo 'o Sīsū mei Nāsaletí, 'a ia ne'e pani 'e te 'Atuá 'aki te Laumālie Mā'oni'oní, mo te mālohi. Pea fe'alu'aki Ia mo failelei, mo faito'o 'ia nātou kotoa pē ne'e fakapōpula'i 'e te tēvoló; he ne'e kau ma'u pē mo ia 'e te 'Atuá. ");
INSERT INTO num_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Pea ko mātoú ko te kau fakamo'oni ki te 'ū me'a ne Ina fai 'i te fanua 'o te kakai Siú, pea pehē foki 'i Selusalema; 'a ia foki ne'e notou fakapoongí, 'i te notou tautau 'Ona 'i te kolosí. ");
INSERT INTO num_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ka ne'e fokotu'u 'Ona ia 'e te 'Atuá 'i tono 'aho tolú, 'o tuku 'Ona ke mātu'aki hā, ");
INSERT INTO num_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","'o kailoa ki te kakai kotoa pē, kā ki te kau fakamo'oni pē ne'e sinaki fili 'e te 'Atuá, 'a ia ko mātou, ko te tu'unga me'a ne'e motou kai mo inu fakataha mo Ia hili Tana toetu'u mei te pekiá. ");
INSERT INTO num_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Pea ne Ina fekau ke motou fanongonongo 'eni ki te kakai 'Isilelí, mo fakapapau'i ko 'eni ia 'ia te Toko Taha kua polo'i 'e te 'Atuá ko te Fakamaau 'o te kau ma'ulí mo te kau pekiá. ");
INSERT INTO num_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","'Oku fakamatala 'e te kau palōfita kotoa pē kiā Ia, 'o pehē, ‘'Ilonga pē he taha 'oku tui pīkitai kiā Ia, 'oku ma'u 'e ia 'ia te fakamolemole angahalá kote'uhí ko Tono huafá.’ ” ");
INSERT INTO num_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Lolotonga te kei lea 'aki 'e Pita 'ia te 'ū me'a ko iá, ne'e hifo 'ia te Laumālie Mā'oni'oní kiā nātou fuli pē ne'e fanongo ki te fakamatalá. ");
INSERT INTO num_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Pea ko nātou 'o te kau Siu ne'e tui kiā Sīsū, 'a ia kua notou ōmai mo Pitá, ne'e notou fakatumutumu kote'uhí ko te hua'i ki te Senitailé foki 'ia te me'a'ofa ko te Laumālie Mā'oni'oní. ");
INSERT INTO num_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","He ne'e notou fanongo kiā nātou 'oku notou lea 'aki 'ia te 'ū lea kehekehe, mo fakahīkihiki'i 'ia te 'Atuá. Toki lea ange 'e Pita, ");
INSERT INTO num_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ko ai 'e kākunga ke ta'ofi 'ia te vaí, ke 'aua na'a papitaiso ai 'ia nātou ko 'ená, he kua notou ma'u te Laumālie Mā'oni'oní 'o hangē ko tātoú?” ");
INSERT INTO num_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pea fekau 'e ia ke papitaiso 'ia nātou 'i te huafa 'o Sīsū Kalaisí. Pea ne'e notou kole kiā ia ke nofo ifo mo nātou 'o 'aho si'i. ");
INSERT INTO num_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Pea ne'e fanongo 'e te kau 'apōsetoló, mo te kāinga kehekehe 'i Siuteá, tā kua tali 'e te Senitailé foki 'ia te Folafola 'a te 'Atuá. ");
INSERT INTO num_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pea 'i te 'alu ake 'ia Pita ki Selusalemá, ne'e fakakikihi mo ia 'ia te kau Siu ne'e tui kiā Sīsuú, 'o notou pehē, ");
INSERT INTO num_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ne ke 'alu ki te kau tangata 'oku kailoa kamu, 'o kainanga mo nātou!” ");
INSERT INTO num_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pea hanga 'e Pita 'o fakamatala hokohoko kiā nātou, 'o pehē, ");
INSERT INTO num_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ne au 'i te kolo ko Siopá, 'o fai taku lotu; pea ne'e 'āvea toku lotó, pea u sio ki te vīsone: 'oku 'alu ifo he 'angame'a, 'o hangē ko he fu'u laá, 'a ia kua tukutuku ifo mei te langí 'aki he hiku'i maea 'e fā; pea ne'e a'u mai kiā au. ");
INSERT INTO num_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Pea 'i taku sio fakamama'u atu ki aí, ne au tokanga'i 'o 'ilo'i ai he fanga monumanu va'e fā 'o te kelekelé, mo te manu kaivao, mo te manu totolo, pea mo te manupuna 'o te 'ataá. ");
INSERT INTO num_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Pea ne'e ongo mai foki he le'o 'oku pehē mai, ‘Tu'u, Pita, 'o tāmate'i 'o kai.’ ");
INSERT INTO num_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Pea u pehē, ‘'E 'Aliki, 'e kala he me'a pehē, he kua he'iki ai 'aupito kita kai he me'a 'oku ta'etaau pe ta'ema'a.’ ");
INSERT INTO num_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Pea hoko mai 'ia te le'o mei te langí ko tono tu'a uá, 'o tali mai, ‘Ko te 'ū me'a kua fakama'a 'e te 'Atuá, 'aua ke pehē 'e koe 'oku ta'etaau.’ ");
INSERT INTO num_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ne'e fai pehē 'o tu'a tolu, pea tē fusi ake kotoa pē ki te langí. ");
INSERT INTO num_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Pea vakai, ne'e tutu'u mai he kau tangata 'e toko tolu ki te 'api ne'e motou 'i aí, kua fekau mai mei Sesalia kiā au. ");
INSERT INTO num_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Pea folafola mai 'ia te Laumālié ke au ō mo nātou, 'o 'aua na'a u mama'i tāla'a. Pea ne'e ō mo au foki te kāinga lotu 'e toko ono nei, pea motou hū ki te fale 'o te matāpulé. ");
INSERT INTO num_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Pea ne'e fakamatala mai 'e ia kiā mātou tana sio ki te 'āngelo 'i tono falé, 'oku tu'u ia 'o me'a mai, ‘Fekau angé ki Siopa ke 'aumai 'ia Saimone, 'a ia 'oku hingoa foki ko Pitá; ");
INSERT INTO num_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","pea 'e fai atu 'e ia he 'ū fakamatala kiā koe, 'a ia 'e ke ma'uli ai, 'ia koe mo tou falé kātoa.’ ");
INSERT INTO num_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Pea kamata ke au leá, kua 'alu ifo 'ia te Laumālie Mā'oni'oní kiā nātou, 'o hangē tofu pē ko te fua fai kiā tātou 'i te kamata'angá. ");
INSERT INTO num_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Pea u manatu ai ki te Folafola 'a te 'Alikí, 'i Tana pehē, ‘Ne'e papitaiso vai pē 'e Sione, kā 'e papitaiso kōtou 'aki 'ia te Laumālie Mā'oni'oní.’ ");
INSERT INTO num_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pea kāpau leva ne'e me'a'ofa tatau 'aki 'e te 'Atuá kiā nātou 'ia te tui ki te 'Aliki ko Sīsū Kalaisí, pea ko ai 'ia kita ke ta'ofi 'ia te ngāue 'a te 'Atuá?” ");
INSERT INTO num_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pea 'i te notou fānonongo leva ki te 'ū me'a ko iá, ne'e tuku leva te notou laú; 'o notou fakamālō'ina 'ia te 'Atuá, 'o notou pehē, “Tā kua tuku 'e te 'Atuá ki te Senitailé foki 'ia te fakatomalá, kote'uhí ke notou ma'uli.” ");
INSERT INTO num_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Pea ko 'eni, ko nātou ko 'ē ne'e vetekina 'i te kovi ne'e hoko 'iā Sitīvení, ne'e a'u te notou 'alú ki Finisia, mo Saipalo, mo 'Aniteoke, ka ne'e kailoa notou malanga 'aki 'ia te Folafolá ki te kakai kehe, ngata pē 'i te kakai Siú. ");
INSERT INTO num_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ka ne'e 'i ai he notou 'ihi ko te kau tangata mei Saipalo mo Sailine, pea ko nātou 'i te notou a'u ki 'Aniteoké ne'e notou lea ki te kakai Kalisí foki, 'i te notou malanga 'aki 'ia te 'Aliki ko Sīsuú. ");
INSERT INTO num_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Pea ne'e kau mo nātou 'ia te māfimafi 'o te 'Alikí; pea ne'e tui he fu'u tokolahi 'o tafoki ki te 'Alikí. ");
INSERT INTO num_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Pea ne'e ongo mai 'ia te me'a ko 'ení ki te siasi 'i Selusalemá, pea ne'e notou fekau atu 'ia Pānepasa ke 'alu ki 'Aniteoke. ");
INSERT INTO num_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Pea 'i tana lava mai, 'o vakai ki te 'alo'ofa 'a te 'Atuá, ne'e fiafia lahi ia, pea ne'e ako'i ia 'ia nātou kotoa pē ke notou pīkitai ki te 'Alikí mo te lotopau. ");
INSERT INTO num_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","He ko te tangata lelei ia, pea fonu 'i te Laumālie Mā'oni'oní mo te tui. Pea ne'e ului ki te 'Alikí he kakai tokolahi. ");
INSERT INTO num_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pea 'alu ia mei ai ki Tāsusi ke kumi kiā Saula; ");
INSERT INTO num_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","pea 'i tana 'ilo'i iá ne'e 'aumai 'e ia 'ona ki 'Aniteoke. Pea ne'e nā fa'a fakataha mo te siasí 'o ta'u kakato 'e taha, 'o nā akonakina he kakai tokolahi. Pea ne'e fu'aki ui ai 'i 'Aniteoke 'ia te kau akó ko te kau Kalisitiane. ");
INSERT INTO num_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","'I te taimi ko iá ne'e 'alu ifo he kau palōfita mei Selusalema ki 'Aniteoke. ");
INSERT INTO num_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Pea ne'e tu'u te notou toko taha ne'e hingoa ko 'Akapusi, 'i tono hā'elea 'ona 'e te Laumālié, 'o ina kikite ki te fu'u honge 'e hoko mai ki māmani fuli pē; 'ia te honge 'a ia ne'e hoko 'i te kuonga 'o Kalotiasí. ");
INSERT INTO num_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Pea ne'e tu'utu'uni 'e te kau akó ke tānaki he tokoni, 'o taki taha 'aumai he me'a 'e lavá, ke 'ave ki te kāinga ne'e nofo 'i Siuteá. ");
INSERT INTO num_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Pea ne'e notou fai ia 'o 'ave ki te kau faifekaú 'iā Pānepasa mo Saula. ");
INSERT INTO num_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Pea lolotonga iá, ne'e mafao atu 'ia te nima 'o te tu'i ko Hēlotá ki te 'ihi 'o te siasí ke ngaahikovi'i. ");
INSERT INTO num_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Pea ne ina tāmate'i 'aki te heletā 'ia Sēmisi ko te ta'okete 'o Sioné. ");
INSERT INTO num_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Pea 'i tana vakai 'oku lelei'ina ai 'ia te kakai Siú, ne ina hoko atu 'o puke mo Pita. Pea ko te 'ū 'aho ia 'o te Kātoanga Kai Mā Ta'e Lēvaní. ");
INSERT INTO num_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pea kua ma'u 'e ia 'ona, 'o tuku pilīsone, pea tuku tono le'ohí ki te kulupu 'e fā, 'o tautau toko fā te sōtia ki te kulupu; 'o ina tu'utu'uni ke toki 'aumai 'ona ki tua'ā ki te kakaí 'i te 'osi ange te Pāsová. ");
INSERT INTO num_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ko ia ne'e le'ohi pē si'i Pitá 'i te pilīsoné; ka ne'e 'i ai he lotu hūfia ne'e fai tōtōaki ki te 'Atuá 'e te siasí kote'uhí ko ia. ");
INSERT INTO num_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pea 'i te hoko ki te pō kae taki atu pongipongi 'ona 'e Hēlotá, ne'e moe 'ia Pita 'i te vaha'a 'o he ongo sōtia, kua ha'i 'aki 'ona he seini 'e ua, pea tutu'u 'ia te ongo le'o 'i te tu'a matapaá 'o tauhi te pilīsoné. ");
INSERT INTO num_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Mo te 'ohovale pē kua tu'u mai he 'āngelo 'a te 'Alikí, pea tapa takatakai he fu'u maama 'i te lokí; pea taa'i 'e ia te vakavaka 'o Pitá, 'o langa'i ake, mo iange, “Tu'u ke vave.” Pea ne'e ngangana mei tono ongo nimá te ongo seini ne'e ha'i 'aki 'oná. ");
INSERT INTO num_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Pea me'a 'e te 'āngeló kiā ia, “'Ai tou no'ó, pea fakama'u tou senitoló.” Pea fai ia ki ai. Pea toe pehē mai ia, “'Ai tou pulupulú 'o mulimuli mai 'iā au.” ");
INSERT INTO num_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pea hū atu ia 'o mulimuli kiā ia; pea ne'e kailoa 'ilo'i 'e ia pe ko te mo'oni 'ia te me'a 'oku fai 'e te 'āngeló, kae mahalo ia ko te vīsone pē 'oku mamata ki aí. ");
INSERT INTO num_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pea kua nā tuku ki muli 'ia te 'uluaki le'ó mo tono uá, pea kua nā a'u 'eni ki te matapā ukameá, 'a ia ko te hū'anga ki te koló. Pea mato'o ia kiā nāua 'iā ia pē; pea kua nā hū atu ki tu'a 'o nā laka atu, 'o 'osi mai he ala 'e taha. Pea toki puli te 'āngeló meiā ia. ");
INSERT INTO num_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pea 'i te matala leva 'ia te loto 'o Pitá, pea toki pehē ia, “Tā kua toki e'a 'eni kiā au, kua fekau mo'oni 'e te 'Alikí Tana 'āngeló, pea kua ina hamusi 'oku mei te nima 'o Hēlotá mo te fu'u 'amanaki 'a te kakai Siú.” ");
INSERT INTO num_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pea 'i te o'o kiā ia 'ia te me'á, ne'e 'alu leva ia ki te fale 'o Mele ko te fa'ē 'a Sioné, (ko tono hingoa 'e tahá ko Ma'ake,) 'a ia ne'e kātoa ki ai he tokolahi 'o lotu. ");
INSERT INTO num_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pea 'i tana tukituki ki te matapā 'i tua'aá, ne'e ha'u he kaunanga ne'e hingoa ko Lota ke fehu'i pe ko ai. ");
INSERT INTO num_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pea 'i tana 'ilo'i ko te le'o 'o Pitá, ne'e pehē fau tana fiafiá ne kailoa to'o 'e ia 'ia te matapaá kiā Pita, kae lele ia ki loto fale, 'o iange 'oku tu'u 'ia Pita 'i te matapaá. ");
INSERT INTO num_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Pea notou pehē kiā ia, “'Oku sesele 'ia koe!” Kae taukave pē 'ia te ta'ahiné, ko Pita pē. Pea notou pehē, “Tā ko tono 'āngeló pē ia.” ");
INSERT INTO num_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Kae hokohoko pē 'e Pita tana tukitukí; pea 'i te notou to'o te matapaá, ne'e notou mamata kiā ia, pea ne'e notou fakatumutumu lahi 'aupito. ");
INSERT INTO num_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pea ta'alo atu ia ke notou fakalongolongo, kae fakamatala'i 'e ia kiā nātou tono fakahaofi 'ona 'e te 'Alikí mei te pilīsoné. Pea pehē ange foki ia, “Kotou tala te me'a ko 'ení kiā Sēmisi mo te kāingá.” Pea hū atu ia 'o 'alu ki te feitu'u kehe. ");
INSERT INTO num_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pea 'i te 'aho aké, ne'e maveuveu lahi 'ia te kau sōtia le'ó pe 'oku 'i fea koā 'ia Pita. ");
INSERT INTO num_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Pea kua kumi 'e Hēlota kiā ia, 'o kailoa 'ilo'i, pea 'eke 'e ia 'ia te kau le'ó 'o fekau ke taki atu nātou 'o tāmate'i. Pea 'alu ifo 'ia Hēlota mei Siutea ki Sesalia, 'o nofo taimi si'i 'i ai. ");
INSERT INTO num_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Pea ko te taimi ko iá ne'e tuputāmaki lahi 'ia Hēlota ki te kakai 'o Taia mo Saitoní. Ka ne'e notou kautaha 'o notou ha'u kiā ia, pea notou fakaloto'i 'ia Palasito ko te tauhi 'o te fale moe 'o te tu'í ko te notou fakafofonga, 'o notou kole ke fakalelei; kote'uhí ne'e ma'u me'akai te notou fanuá mei te fanua 'o te tu'í. ");
INSERT INTO num_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Pea 'i te hokosia te 'aho ne'e kotofá, ne'e 'ai ai 'e Hēlota hana kofu fakatu'i, 'o nofo ifo 'i te taloní, 'o fai he fu'u malanga ki te kakaí. ");
INSERT INTO num_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Pea kalanga 'ia te kakaí, “Ko te folafola 'eni he 'atua, 'o kailoa ko he tangata!” ");
INSERT INTO num_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Pea te'ia leva 'ona 'e te 'āngelo 'a te 'Alikí, kote'uhí ko te kailoa ina tuku te kolōliá ki te 'Atuá; pea ne'e keina 'ona 'e te ponú 'o ina hala ai. ");
INSERT INTO num_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kā ko te Folafola 'a te 'Atuá ne'e tupulaki ma'u pē ia, 'o fakatokolahi. ");
INSERT INTO num_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Pea ko Pānepasa mo Saulá ne'e nā foki mei Selusalema 'i te 'osi te nā fekaú, 'o nā 'ave 'ia Sione, 'ā ē ne'e hingoa ko Ma'aké. ");
INSERT INTO num_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Pea ne'e nofo 'i 'Aniteoke, 'i te siasi ne tu'u 'i aí, he kau palōfita mo he kau akonaki; 'a ia ko Pānepasa, pea mo Simione ne'e hingoa ko Naiká, mo Lūsio mei Sailine; ko Maneno foki, 'ā ē ne'e huhu taha mo Hēlota ko te tu'í, pea mo Saula. ");
INSERT INTO num_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Pea lolotonga te fai te notou lotu ki te 'Alikí, mo te notou 'aukai, ne'e folafola mai 'e te Laumālie Mā'oni'oní, 'o pehē ange, “Vahe'i mai mu'a Ma'aku 'ia Pānepasa mo Saula ki te ngāue kua U tu'utu'uni ma'a nāua.” ");
INSERT INTO num_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Pea notou 'aukai, mo hūfia, mo hilifaki nima kiā nāua, 'o notou toki tukuange ke nā ō. ");
INSERT INTO num_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Pea ko 'eni, 'i te fekau ange 'ia nāua 'e te Laumālie Mā'oni'oní, ne'e nā a'u ifo ki Selusia; pea nā folau mei ai ki Saipalo. ");
INSERT INTO num_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pea nā hifo ifo 'i Salamisi, 'o nā malanga 'aki 'ia te Folafola te 'Atuá 'i te 'ū falelotu 'o te kakai Siú. Pea ne'e ō mo nāua 'ia Sione ko te nā tokoni. ");
INSERT INTO num_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Pea kua 'osi te motú 'i te notou 'alu'i, pea notou a'u ai ki Pafosi, 'o notou 'ilo'i ai he matāpule Siu, ko te maki mo te palōfita lohi, ko tono hingoá ko Pāsīsū, ");
INSERT INTO num_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","'a ia 'oku nā nonofo mo Sesio Paula ko te kōvaná, ko te tangata loto matala. Pea fekau 'e te 'aliki ko iá ke 'aumai 'ia Pānepasa mo Saula, 'o holi ia ke fanongo ki te Folafola 'a te 'Atuá. ");
INSERT INTO num_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kā ne fakafepaki'i nāua 'e te maki ko 'Elimá (he ko tono hingoá ia 'i te lea 'e tahá), 'o ina feinga ke ta'ofi 'ia te kōvaná ke 'aua na'a tui ia. ");
INSERT INTO num_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Pea ko Saula, 'a ia ko tono hingoá foki ko Paula, ne'e fakafonu ia 'e te Laumālie Mā'oni'oní, pea sio fakamama'u ia ki te tangatá, ");
INSERT INTO num_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","'o pehē ange, “'Ia te siana fonu ngutungutu 'i te kākā mo te pau'u, hako 'o te tēvoló, ko te fakafili ki te me'a kotoa pē 'oku totonú, 'e kailoa koā tuku ta'aú le'ei 'ia te 'ū ala totonu 'o te 'Alikí? ");
INSERT INTO num_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Pea ko 'eni vakai, kua ala 'eni te māfimafi 'o te 'Alikí kiā koe; pea 'e ke kui, 'o kailoa ke sio ki te maamá 'o 'osi tono taimí.” Pea ne'e tō leva kiā ia he nenefu mo he fakapō'uli; pea tautaufā holo ia ke piki he taha ke tataki tono nimá. ");
INSERT INTO num_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Pea 'i te vakai 'e te kōvaná ki te me'a kua hokó, ne'e tui leva ia, he kua to'oa ia 'i tono ako 'aki 'o te 'Alikí. ");
INSERT INTO num_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pea kua tuku atu mei Pafosi 'ia te folau 'a Paula mo tono kau fonongá, pea notou a'u ki Peaka 'i Pamifilia. Pea ne'e si'aki ai nāua 'e Sione, 'o foki ki Selusalema. ");
INSERT INTO num_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ka ne'e fou atu pē nāua mei Peaka, 'o nā a'u ki 'Aniteoke 'i Pisitiá; pea 'i te 'aho Sāpaté ne'e nā hū ki te falelotú 'o nofo ifo 'i ai. ");
INSERT INTO num_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Pea 'i te 'osi tono lau 'o te Tohi Laó mo te Tohi Palōfitá, ne'e fekau mai 'e te kau pule 'o te falelotú ke fakahā kiā nāua, “Kāinga, kāpau 'oku 'i ai he kulā akonaki ke fai ki te kakaí, pe'i kulā lea mai.” ");
INSERT INTO num_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pea tu'u 'ia Paula, 'o ta'alo ange 'o pehē, “'E tu'unga mātu'a 'Isileli, mo te taka 'apasia mai ki te 'Atuá, kotou me'a mai. ");
INSERT INTO num_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ko te 'Atua 'o te kakai 'Isilelí, ne'e fili 'e Ia Ma'ana te tou mātu'á, mo tāpuaki'i nātou lolotonga te notou 'āunofo 'i te fanua ko 'Isipité, 'o taki atu 'ia nātou mei ai kua hikitā Tono nimá. ");
INSERT INTO num_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Pea ne'e fualoa Tana kātaki'i te notou angá 'i te toafá, ko te ta'u nai 'e fāngofulu. ");
INSERT INTO num_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pea kua 'osi Tana faka'auha he kakai 'e fitu 'i te fanua ko Kēnaní, ne'e vahe'i leva 'e Ia 'ia te fanuá ma'a notou tofi'a; ");
INSERT INTO num_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","'o fe'unga ia mo te ta'u 'e fāngeau mā nimangofulu. Pea 'i te hili ange ko iá ne'e tuku 'e Ia he notou kau fakamaau, 'o a'u mai kiā Sāmiuela ko te palōfita. ");
INSERT INTO num_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Pea 'i te 'osi ange ko iá ne'e notou kole he tu'i; pea 'avange ma'a nātou 'e te 'Atuá 'ia Saula ko te foha 'o Kisi, ko he matāpule 'i te matakali 'o Penisimaní, 'o fāngofulu ta'u. ");
INSERT INTO num_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pea kua Ina liua ia, pea ne Ina fokotu'u 'ia Tēvita ko te notou tu'i; 'a ia ne Ina fakamo'oni ai 'o pehē, ‘Kua U toki 'ilo'i 'ia Tēvita ko te foha 'o Sesé, ko te tangata ia 'oku tatau mo Toku lotó, pea 'e fai 'e ia ki Ta'akú tu'utu'uni fuli pē.’ ");
INSERT INTO num_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ko te hako 'o'oná 'eni kua 'aumai mei ai 'e te 'Atuá ma'a 'Isileli, 'o hangē ko Tana tala'ofá, he fakama'uli, 'a ia ko Sīsū ia. ");
INSERT INTO num_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ka ne'e fu'aki malanga 'aki 'e Sione ki te kakai 'Isileli kotoa pē 'ia te papitaisofakatomalá, ko te fakamelomelo ki Tana hā'ele maí. ");
INSERT INTO num_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Pea 'i te faka'osi 'e Sione tana ngāué, ne ina pehē ange, ‘Ko ai 'ia au 'i te kotou laú? 'Ā, 'oku kala ko Ia 'ia au; kā ko 'eni, 'oku mulimuli mai 'iā au he Toko Taha 'oku kala kita taau ke vete To'onó senitolo.’ ");
INSERT INTO num_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Kāinga, ko te hako totonu 'o 'Ēpalahame, mo kōtou 'ia te taka 'apasia mai ki te 'Atuá, ko tātou ia kua fekau mai ki ai 'ia te tala 'o te ma'uli'anga ko iá. ");
INSERT INTO num_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","He ko te kakai 'oku nofo 'i Selusalema, mo te notou kau pulé, ko te me'a 'i te notou ta'e'ilo'i 'ia Sīsuú, mo te 'ū lea 'a te kau palōfitá, 'ā ē 'oku lau 'i te Sāpate hokohokó, kua notou fakamo'oni ki te 'ū palōfisai ko iá 'aki te notou fakamāu'i 'Ona ke mate. ");
INSERT INTO num_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Pea neongo ne'e kailoa notou 'ilo'i he mama'i me'a 'e taha ne'e totonu ke mate ai 'ia Ia, ka ne'e notou kole pē kiā Pailato ke tāmate'i 'Ona. ");
INSERT INTO num_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Pea kua notou fakahoko 'ia te 'ū me'a fuli pē ne'e tohi Ma'aná, ne'e notou 'ave ifo 'Ona mei te kolosí, 'o telio 'i te fanualoto. ");
INSERT INTO num_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ka ne'e fokotu'u 'Ona 'e te 'Atuá mei te pekiá, ");
INSERT INTO num_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","pea ne'e hā Ia 'i te 'ū 'aho lahi ki te kakai ne'e notou ō mo Ia mei Kāleli ki Selusalemá, 'a ia ko Tana kau fakamo'oni lolotonga 'eni ki te kakai 'Isilelí. ");
INSERT INTO num_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Pea ko māua 'eni, 'oku mā ongoongoa atu 'ia te tala leleí, 'o pehē: ko te tala'ofa ne'e fai ki te tou kau mātu'á, ");
INSERT INTO num_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","kua fakamo'oni'i ia 'e te 'Atuá kiā tātou ko te notou fānaú, 'aki Tana toe fokotu'u 'ia Sīsū; 'o hangē foki kua tohi 'i tono ua 'o te Saamé: ‘Ko Toku 'Aló 'ia Koe, kua U fakatupu 'Ou 'i te 'aho nei.’ ");
INSERT INTO num_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Pea ko te me'a ki te fokotu'u 'Ona 'e te 'Atuá mei te pekiá ke 'aua na'a toe foki ki te 'au'auhá, kua Ina folafola ai 'o pehē, ‘'E Au tuku kiā kōtou 'ia te 'ū tala'ofa ne'e fai kiā Tēvitá, 'a ia 'oku toputapu pea pau.’ ");
INSERT INTO num_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ko ia kua Ina pehē ai foki 'i te Saame 'e taha, ‘Tala'i'eaí 'e Ke tuku Tau Toko Taha Tapú ke 'ilo'i 'ia te 'au'auhá.’ ");
INSERT INTO num_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","He ko Tēvita, hili pē tana ngāue 'i tono to'utangatá 'o fakatatau ki te finangalo 'o te 'Atuá, ne'e moe ia, 'o tanu fakataha mo tana 'ū kuí, 'o 'ilo'i ia 'ia te 'au'auhá; ");
INSERT INTO num_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","kā ko te Toko Taha ko ia ne'e fokotu'u 'e te 'Atuá ne'e kala 'ilo'i 'e Ia 'ia te 'au'auhá. ");
INSERT INTO num_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ko ia ai ke mahino kiā kōtou, 'ia te kāinga, ko te me'a 'iā Ia, 'oku malanga 'aki ai kiā kōtou 'ia te fakamolemole angahalá; ");
INSERT INTO num_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","pea ko te me'a 'iā Ia foki, ko nātou kotoa pē 'oku tuí, 'oku fakatonuhia'i mei te me'a kotoa pē, 'a ia ne'e kala fa'a fakatonuhia mei ai 'e te Lao 'a Mōsesé. ");
INSERT INTO num_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ko ia kotou tokanga, na'a hoko atu 'ia te me'a ne'e folafola 'aki 'i te Tohi Palōfitá: ");
INSERT INTO num_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Vakai, 'ia kōtou ko te kau lumá, kotou ofo pea kotou toki 'auha ā; he ko Taku fai 'eni he ngāue 'i te kotou kuongá, he ngāue kehe, 'a ia 'e kala kotou tui ki ai, neongo tono 'a'au atu he taha 'o fakalautelau.’ ” ");
INSERT INTO num_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pea 'i te nā hū atú, ne'e notou kole ange ke toe malanga 'aki ange 'ia te 'ū me'a ko 'ení kiā nātou 'i te Sāpate kā hokó. ");
INSERT INTO num_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Pea 'i te tutuku leva 'ia te fakataha lotú, ko te tokolahi 'o te kakai Siú, mo te kakai kua ului mai ki te notou lotú ne'e notou mulimuli kiā Paula mo Pānepasa. Pea ne'e nā lea kiā nātou, 'o akonaki ke notou nofo ma'u 'i te 'ofa 'a te 'Atuá. ");
INSERT INTO num_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Pea 'i te Sāpate ne hokó, ne'e fakataha 'ia te kakai 'o te koló fuli pē, ke fanongo ki te Folafola 'a te 'Alikí. ");
INSERT INTO num_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pea 'i te mamata 'e te kau Siú ki te fu'u tokolahi peheé, ne'e vevele te notou meheká, pea notou fakafepaki'i 'ia te 'ū fakamatala 'a Paulá, 'o notou lea kovi 'aupito. ");
INSERT INTO num_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pea toki lea mālohi 'ia Paula mo Pānepasa, 'o nā pehē ange, “Ne'e pau pē ke fu'aki tala te Folafola 'a te 'Atuá kiā kōtou, kā 'i te kotou teke'i atu iá, 'oku kotou fakahaa'i ai 'e kōtou ki te kotou ta'etaau mo te ma'uli ta'engatá, pea vakai, ko te mā hiki 'eni ki te Senitailé. ");
INSERT INTO num_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","He ne'e pehē te motou tu'utu'uni 'e te 'Alikí, ‘Kua U fokotu'u 'ou ko he maama 'o te Senitailé, ke hoko 'ia koe ko te ma'uli'anga 'o a'u ki te ngata'anga 'o māmaní.’ ” ");
INSERT INTO num_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Pea 'i te fanongo ki ai 'ia te kau Senitailé ne'e notou fiafia, mo notou fakahīkihiki'i 'ia te Folafola 'a te 'Alikí; pea 'ilonga pē nātou ne'e tu'utu'uni ki te ma'uli ta'engatá ne'e notou tui. ");
INSERT INTO num_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Pea ne'e mafola te Folafola 'a te 'Alikí ki te fanuá fuli pē. ");
INSERT INTO num_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kā ne o'i 'e te kau Siú 'ia te kau fafine 'aliki kua tafoki 'o tui ki te 'Atuá, pea mo te hau'aliki 'o te koló, pea notou fakalanga'i he fakatanga kiā Paula mo Pānepasa, 'o notou kapusi 'ia nāua mei te notou feitu'ú. ");
INSERT INTO num_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pea nā tūtuu'i 'ia te efú mei to'o nāuá va'e, ko te faka'ilonga kiā nātou, 'o nā ō mei ai ki 'Aikoniume. ");
INSERT INTO num_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pea ne'e fonu 'ia te kau akó 'i te fiafia pea mo te Laumālie Mā'oni'oní. ");
INSERT INTO num_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pea 'i te lolotonga te nā 'i 'Aikoniumé, ne'e nā hū fakataha ki te falelotu 'o te kakai Siú; pea ko te me'a 'i te nā malangá, ne'e tui ai he fu'u tokolahi 'o te kakai Siú mo te kakai Kalisí fakatou'osi. ");
INSERT INTO num_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kā ko te kau Siu ne'e kailoa tuí, ne'e notou ue'i mo fakakovi'i 'ia te loto 'o te kau Senitailé ke notou fakafepaki'i 'ia te kāinga lotú. ");
INSERT INTO num_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ko ia ne'e fualoa te nā nofo 'i aí, 'o nā malanga mālohi mo nā falala ki te 'Alikí, pea ne'e poupou'i 'e Ia 'ia te tala 'o Tana 'alo'ofá, 'aki Tana tuku ke hā 'i te nā ngāué 'ia te 'ū faka'ilonga mana mo fakaofo 'aupito. ");
INSERT INTO num_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pea ne'e mavae ua 'ia te kakai 'o te koló, pea ne'e kau he 'ihi mo te ha'a Siú, kā ko te 'ihi mo te ongo 'apōsetoló. ");
INSERT INTO num_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Pea 'i te teu ke 'ohofi nāua 'e te kakai Senitailé, mo te kau Siú mo te notou kau pulé, kote'uhí ke ngaahikovi'i mo tolomaka'i 'ia nāuá, ");
INSERT INTO num_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ne'e nā fu'aki 'ilo ki ai, 'o nā hola ki te 'ū kolo 'o Laikoniá, ki Līsita mo Teape mo te 'ū feitu'u ko iá. ");
INSERT INTO num_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Pea ne'e notou nonofo 'o malanga 'aki 'ia te ongoongoleleí 'i te feitu'u ko iá. ");
INSERT INTO num_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Pea ne'e 'i ai he tangata 'i Līsita, ne'e va'e mate, pea kua heke ta'utu mei tono fanau'í, 'o kailoa 'aupito lava ke hā'ele. ");
INSERT INTO num_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Pea ne'e fanongo ia ki te lea 'a Paulá. Pea 'i te sio fakamama'u 'ia Paula kiā ia mo tana vakai atu 'oku tui ia 'e lava tono fakama'ulí, ");
INSERT INTO num_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ne'e lea le'o lahi ia, 'o pehē ange, “Tu'u ake ki lunga!” Pea hopo ake leva ia 'o hā'ele. ");
INSERT INTO num_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pea 'i te mamata 'e te kakaí ki te me'a kua fai 'e Paulá, ne'e notou hiki tuē, 'o notou kalanga 'i te lea faka-Laikoniá, “Kua hifo fakatangata mai he ongo 'atua!” ");
INSERT INTO num_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Pea ne'e notou ui 'ia Pānepasa ko Siupita, pea ui 'ia Paula ko Meakuli, he ko ia ia ne'e takimu'a 'i te leá. ");
INSERT INTO num_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Pea ko te taula'aliki 'o Siupitá, ko te 'atua ne'e 'afio 'i te matanikoló, ne'e 'aumai 'e ia mo he kakai 'ia te fanga pulu mo te 'ū tuinga kakala ki te 'ū matapā 'o te koló, ke notou feilaulau 'aki kiā nāua. ");
INSERT INTO num_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pea 'i te ongo mai te me'á ki te ongo 'apōsetoló, kiā Pānepasa mo Paula, ne'e nā hahae ifo te nā kofú, 'o nā 'oho atu mei te falé ki te kakaí, 'o nā kalanga atu, ");
INSERT INTO num_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“'E kau tangata, ko te ā kua kotou fai pehē aí? He 'oku mā alāanga mo kōtou, ko te ongo tangata pē, 'o mā tala'i atu 'ia te ongoongoleleí, ke kotou tafoki mei te 'ū 'atua noa ko 'ení ki te 'Atua Ma'ulí, 'a ia ne'e ngaahi 'ia te langí mo te fanuá mo te taí, mo te 'ū me'a kehekehe 'oku 'i aí. ");
INSERT INTO num_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","'I te kua hilí ne'e tukuange pē Ia 'ia te kakai kotoa pē ke notou fou 'i te founga pē 'a nātoú. ");
INSERT INTO num_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ka na'a mo ia, tala'i'eaí ne'e nofo 'ia Ia 'o kailoa he faka'ilonga; he ne'e failelei Ia, 'o 'avatu kiā kōtou mei te langí 'ia te 'uá, mo te 'ū ta'u mahu, pea 'ai 'e Ia ke fonu ngutungutu te kotou lotó 'i te me'atokoni mo te fakafiafia.” ");
INSERT INTO num_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Kā neongo te nā lea peheé, ne'e kailoa meimei lava ke nā ta'ofi 'ia te kakaí mei te fai feilaulau kiā nāuá. ");
INSERT INTO num_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ka ne'e ō ifo he kau Siu mei 'Aniteoke mo 'Aikoniume, 'o notou fakahinga'i te kakaí kiā nātou; pea notou tolomaka'i 'ia Paula, 'o notou toho 'ona ki tua'ā kolo, ko te notou mahalo kua pekia iá. ");
INSERT INTO num_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pea lolotonga te tu'u takai kiā ia 'ia te kau akó, ne'e tu'u ake ia 'o hū ki te koló; pea 'i te pongipongi aké ne'e nā ō atu mei ai mo Pānepasa ki Teape. ");
INSERT INTO num_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pea 'i te 'osi ange te nā malanga 'aki 'ia te ongoongoleleí 'i te kolo ko iá, mo fakaului he tokolahi ki te kau akó, ne'e nā foki ki Līsita mo 'Aikoniume mo 'Aniteoke, ");
INSERT INTO num_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","'o nā poupou'i te kau akó ke notou tu'u ma'u 'i te tuí, 'o nā pehē foki, “Ko te tou hū ki te Pule'anga 'o te 'Atuá, kua pau ke tou fou tātou 'i te 'ū mamahi lahi.” ");
INSERT INTO num_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pea ne'e hanga 'e Paula mo Pānepasa 'o fili he kau faifekau 'i te siasi tāutaha, pea nā fai he hūfia mo te 'aukai, 'o nā toki tuku 'ia nātou ki te 'Alikí, kua notou tui kiā Ia. ");
INSERT INTO num_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pea nā fou atu 'i Pisitia, 'o hoko atu ai ki Pamifilia. ");
INSERT INTO num_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pea 'i te 'osi te nā malanga 'aki 'ia te Folafolá 'i Peaká, ne nā a'u ifo ki 'Atalaia; ");
INSERT INTO num_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","pea nā folau mei ai ki 'Aniteoke, 'a ia ko te feitu'u ia ne'e fu'aki tukuange ai 'ia nāua ki te 'alo'ofa 'a te 'Atuá, ke nā fai te ngāue kua nā toki 'osi tono fai ko 'ení. ");
INSERT INTO num_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pea 'i te nā a'u leva ki aí ne'e nā fakataha 'ia te siasí, 'o nā fakamatala'i kiā nātou 'ia te fu'u me'a kua fai 'e te 'Atuá 'i Tana kau mo nāuá, pea mo Tana fakaava 'ia te matapā 'o te tuí ki te Senitailé. ");
INSERT INTO num_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pea ne'e nā nofo 'i ai mo te kau akó 'o fualoa. ");
INSERT INTO num_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Pea ne'e 'i ai he kau tangata ne'e notou ō ifo mei Siutea, 'o notou ako ki te kāinga lotú, 'o pehē, “Kāpau 'e kailoa kotou kamu, 'o hangē ko te tu'utu'uni 'a Mōsesé, 'e kailoa lava ke kotou ma'uli.” ");
INSERT INTO num_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pea ne'e hoko ai he fu'u fetu'usi mo te fe'eke 'iā Paula mo Pānepasa pea mo nātou, 'o notou tu'utu'uni leva ke ō ake ki Selusalema 'ia Paula mo Pānepasa, pea mo he 'ihi meiā nātou, ke 'ave 'ia te me'a nei ki te kau 'apōsetoló mo te kau faifekaú. ");
INSERT INTO num_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Pea kua moimoi'i 'ia nāua 'e te siasí, ne'e nā ō atu 'i Finisia mo Samēlia, 'o notou fakamatala ki te liliu 'a te Senitailé, pea ne'e fu'u fiafia lahi 'ia te kāingá kotoa pē. ");
INSERT INTO num_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pea 'i te nā a'u atu ki Selusalemá, ne'e tali lelei 'ia nāua 'e te siasí, mo te kau 'apōsetoló, mo te kau faifekaú; pea fakamatala'i foki 'e nāua 'ia te 'ū fu'u me'a kua fai 'e te 'Alikí 'i Tana kau mo nāuá. ");
INSERT INTO num_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kā ne'e tu'u mai he 'ihi 'oku tuí 'i te fa'ahinga 'o te Fālesí, pea notou pehē, “'Oku totonu ke kamu 'ia te kakai ko iá, pea tu'utu'uni foki ke notou tauhi 'ia te Lao 'a Mōsesé.” ");
INSERT INTO num_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ne'e fakataha foki 'ia te kau 'apōsetoló mo te kau faifekaú ke vakai'i te me'a ko 'ení. ");
INSERT INTO num_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pea kua fualoa te notou aleá, pea toki tu'u 'ia Pita, 'o pehē ange kiā nātou, “Kāinga, 'oku kotou lāu'ilo'i, kua fualoa foki tono fili 'oku 'e te 'Atuá meiā kōtou, ke fanongo 'e te kakai Senitailé mei toku ngutú ki te tala 'o te ongoongoleleí, 'o notou tui. ");
INSERT INTO num_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Pea ko te 'Atuá, 'a ia 'oku tokaima'ananga ki Ai 'ia te lotó, ne'e fakamo'oni Ia ma'a nātou, 'aki Tana foaki kiā nātou 'ia te Laumālie Mā'oni'oní, 'o hangē ko Tana fai kiā tātoú; ");
INSERT INTO num_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","pea ne'e kala he mama'i faikehekehe kiā tātou pea mo nātou, 'i Tana fakama'a te notou lotó 'aki te notou tuí. ");
INSERT INTO num_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Pea ko te ā 'eni 'oku kotou 'ahi'ahi'i ai 'ia te 'Atuá, 'o kotou pehē ke 'ai he kavenga ki te uma 'o te kau akó, 'a ia ne'e kailoa fa'a kātaki 'e te tou mātu'á, pē ko tātoú? ");
INSERT INTO num_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","'Osi angé 'oku tou tui 'e tou ma'uli 'i te kelesi 'a te 'Aliki ko Sīsū 'o hangē tofu pē ko nātoú.” ");
INSERT INTO num_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pea toki sīlongo ai 'ia te fakatahá kotoa pē, 'o notou fakafanongo kiā Pānepasa mo Paula, ki te nā fakamatala'i 'ia te 'ū faka'ilonga mana mo fakaofo ne'e fai 'e te 'Atuá 'iā nāua 'i te lotolotonga 'o te Senitailé. ");
INSERT INTO num_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pea kua longo leva 'ia nāua, pea tali 'e Sēmisi 'o pehē ange, “'E kāinga, kotou tokanga mai kiā au. ");
INSERT INTO num_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Kua fakamatala'i 'e Saimone te 'uluaki 'a'ahi mai 'a te 'Atuá ke to'o mei te Senitailé he kakai ke kau ki Tono Huafá. ");
INSERT INTO num_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Pea 'oku tatau mo ia 'ia te 'ū tala 'a te kau palōfitá, 'o hangē ko ia kua tohí, ");
INSERT INTO num_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Hili iá 'e Au foki mai, pea 'e Au toe langa'i te tēniti 'o Tēvita kua holó; pea 'e Au toe ngaahi Tono 'ū konga kua maumaú, pea 'e Au fokotu'u ia ke totonu, ");
INSERT INTO num_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","kote'uhí ke toki fekumi ki te 'Alikí tono toenga 'o te kakaí, pea mo te Senitaile kotoa pē; he kua ui 'aki 'ia nātou Toku hingoá, Ko te Folafola ē 'a te 'Alikí, 'a ia kua Ina fai 'ia te 'ū me'a nei, ");
INSERT INTO num_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ko te 'ū me'a 'iloa ia talu mei mu'a.’ ");
INSERT INTO num_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ko ia ai ko toku lotó, ke 'aua tou tē fakakina'i 'ia nātou mei te Senitailé kua tafoki mai ki te 'Atuá, ");
INSERT INTO num_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","kā ke tou tohi kiā nātou ke notou faka'ehi'ehi mei te 'ū me'a kua 'uli'i 'e te 'aitolí, mo te fe'auakí mo te manu kua sisiná mo te totó. ");
INSERT INTO num_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Hē 'oku 'i ai 'i te kolo kotoa pē, talu mei mu'a, 'ia nātou 'oku malanga 'aki 'ia Mōsese, hē 'oku lau tana tohí 'i te 'ū falelotú 'i te Sāpate kotoa pē.” ");
INSERT INTO num_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Pea ne'e toki hā lelei ki te kau 'apōsetoló mo te kau faifekaú, pea mo te siasí kotoa pē, ke fili he notou ongo tangata, 'o fekau atu ke ō mo Paula mo Pānepasa ki 'Aniteoke: ko Siutasi ne'e ui ko Pasapá, pea mo Sailosi, ko te ongo matāpule ne'e nā takimu'a 'i te kāinga lotú; ");
INSERT INTO num_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","pea notou fai leva he tohi 'o 'avatu 'iā nātou, 'o pehē: “Ko mātou 'eni ko te kau 'apōsetoló, mo te kau faifekaú mo te kāinga lotú, 'oku motou 'ofa atu ki te kāinga lotu Senitaile 'i 'Aniteoke, mo Sīlia, mo Silisiá. ");
INSERT INTO num_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ko te me'a 'i te motou fanongo kua 'i ai he 'ihi kua ō atu meiā mātou, 'o fakahoha'asi 'ia kōtou 'aki he 'ū koto lau, mo uesia ai te kotou laumālié, kā ne'e kailoa motou fekau 'ia nātoú, ");
INSERT INTO num_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ko ia ne'e hā lelei ai kiā mātou 'i te motou loto tahá ke fili'i he 'ihi 'o fekau atu kiā kōtou, fakataha mo te ongo 'ofa'anga 'o mātoú ko Pānepasa mo Paula, ");
INSERT INTO num_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ko te ongo me'a kua si'aki te nā ma'ulí kote'uhí ko te huafa 'o te tou 'Aliki ko Sīsū Kalaisí. ");
INSERT INTO num_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ko ia ai kua motou fekau atu 'ia Siutasi mo Sailosi, 'a ia 'e nā tala ngutu atu 'ia te 'ū me'a nei. ");
INSERT INTO num_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Hē kua hā lelei ki te Laumālie Mā'oni'oní mo mātou, ke 'aua na'a toe 'ai mo he kavenga kiā kōtou, kae ngata pē 'i te 'ū me'a ko 'ení: ");
INSERT INTO num_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ke kotou faka'ehi'ehi mei te 'ū me'a kua feilaulau'i ki te 'aitolí, mo te totó, mo te manu kua sisiná, pea mo te fe'auakí. Pea kāpau 'e kotou tauhi kōtou mei te 'ū me'a ko iá, 'e kotou lelei pē. 'Ofa atu.” ");
INSERT INTO num_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Pea kua tukuange 'ia nātou, pea notou a'u ifo ki 'Aniteoke, pea notou fakataha'i 'ia te kakaí, 'o 'avange te tohí. ");
INSERT INTO num_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Pea 'i te 'osi ange pē tono laú ne'e notou fiafia 'i te tokoni kua faí. ");
INSERT INTO num_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Pea ko Siutasi mo Sailosí ko he ongo palōfita foki 'ia nāua, pea ne'e lahi te nā lea 'o tokoni ki te kakaí mo poupou'i te notou lotó. ");
INSERT INTO num_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Pea kua fualoa si'i te nā nofo 'i aí, pea toki tukuange fiamālie atu 'ia nāua 'e te kāingá, ke nā foki kiā nātou ne'e notou fekau'i mai 'ia nāuá. ");
INSERT INTO num_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Kā neongo iá ne'e kei fiamālie pē 'ia Sailosi ia ke nofo atu 'i ai. ");
INSERT INTO num_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ka ne'e nofo atu pē 'ia Paula mo Pānepasa 'i 'Aniteoke, 'o nā faiako 'i ai mo nā malanga 'aki 'ia te Folafola 'a te 'Atuá fakataha mo he tokolahi kehe. ");
INSERT INTO num_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pea 'osi ange te 'ū 'aho 'ihi, ne'e iange 'e Paula kiā Pānepasa, “Tā tē foki, 'o 'a'ahi ki te kāingá 'i te 'ū kolo kehekehe ne tā 'osi malanga 'aki ai 'ia te Folafola 'a te 'Alikí, 'o vakai pe 'oku notou fefe'aki.” ");
INSERT INTO num_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Pea ne'e loto 'ia Pānepasa ke 'ave 'ia Sione foki, 'a ia 'oku ui ko Ma'aké. ");
INSERT INTO num_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Kā ne'e kailoa sai kiā Paula ke nā 'ave 'ona, he ne'e si'aki 'e ia 'ia nāua 'i Pamifilia, 'o kailoa ō mo nāua ki te ngāué. ");
INSERT INTO num_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Pea ne'e hoko ai he kē; ko ia ne'e nā māvae ai. Pea 'ave 'e Pānepasa 'ia Ma'ake, 'o nā folau ki Saipalo; ");
INSERT INTO num_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","kā ko Paula ne'e fili 'e ia 'ia Sailosi, 'o nā fononga, kua tukuange 'ia nāua 'e te kāinga lotú ki te 'alo'ofa 'a te 'Atuá. ");
INSERT INTO num_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pea ne'e nā fononga holo 'i Sīlia mo Silisia, 'o nā poupou'i 'ia te 'ū siasí. ");
INSERT INTO num_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pea ne'e 'alu ifo 'ia Paula ki Teape mo Līsita. Pea ne'e 'i ai te tama ako 'i te feitu'u ko iá ne'e hingoa ko Tīmote, ko te tama 'a te fafine Siu ne'e tui; kā ko tana tamaí ko te Kalisi; ");
INSERT INTO num_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","pea ne'e fakaongolelei'i 'ona 'e te kāinga lotu 'i Līsita mo 'Aikoniumé. ");
INSERT INTO num_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pea ne'e loto 'ia Paula ke nā fononga mo ia; pea hanga 'e ia 'o kamu 'ona talia 'ia te kau Siu ne'e notou nofo 'i te 'ū feitu'u ko iá, he ne'e notou 'ilo'i kotoa pē ko ta'aná tamai ko te Kalisi. ");
INSERT INTO num_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pea 'i te notou 'a'ahi ki te 'ū koló, ne'e notou tuku kiā nātou 'ia te 'ū fekau ne'e tu'utu'uni 'e te kau 'apōsetoló mo te kau faifekau 'o Selusalemá ke notou faí. ");
INSERT INTO num_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Pea ne'e faka'a'au ai 'o kaukaua 'ia te 'ū siasí 'i te tuí pea tē fakautuutu te notou tokolahí 'i te 'aho kotoa pē. ");
INSERT INTO num_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pea kua 'osi 'ia Filisia mo te fanua 'o Kalētiá 'i te notou takai'i; kā ne'e ta'ofi 'e te Laumālie Mā'oni'oní ia te notou malanga 'aki 'ia te Folafolá 'i 'Ēsiá. ");
INSERT INTO num_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pea 'i te notou a'u ki Misiá ne'e notou feinga ke ō ki Pitinia, kā ne ta'ofi 'ia nātou ia 'e te Laumālié. ");
INSERT INTO num_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Pea kua notou tukuange 'ia Misia, 'o notou a'u ifo ki Taloasi. ");
INSERT INTO num_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Pea ne'e hā he vīsone kiā Paula 'i te pō ko iá; ne'e tu'u mai ai he tangata, 'o kole ange kiā ia 'o pehē, “Laka mai ki Masitōnia 'o tokoni'i 'ia mātou.” ");
INSERT INTO num_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pea 'i tana mamata ki te vīsoné, ne'e motou feinga leva ke ō atu ki Masitōnia, he ne'e motou fakakaukau 'o pehē, kua ui 'ia mātou 'e te 'Atuá ke malanga 'aki 'ia te ongoongoleleí kiā nātou. ");
INSERT INTO num_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Pea kua motou tuku folau 'eni mei Taloasi, pea ne'e motou lele ki Samotēsia, 'o tau ki Neapolisi 'i te 'aho 'e tahá; ");
INSERT INTO num_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","pea mei ai ki Filipai, 'a ia ko te kolo lahi 'i te vahefanua Masitōniá, pea ko te kolo faka-Loma ia; pea ne'e motou nofo 'i te kolo ko iá 'i te 'ū 'aho 'ihi. ");
INSERT INTO num_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Pea 'i te 'aho Sāpaté ne'e motou ō ki te tua'ā koló, ki te 'āfaki vaitafé, ko te feitu'u ne motou mahalo 'oku fa'a fai ai te lotu; pea motou nofo ifo 'o talanoa mo te kau fafine kua fakataha ki aí. ");
INSERT INTO num_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Pea ko te toko taha 'iā nātou ne'e hingoa ko Litia, ne'e fai fakatau tupenu kulakula mei te kolo ko Taiatailá, pea ne'e lotu ia ki te 'Atuá, pea lolotonga tana fanongo 'e iá, ne'e tangaki 'e te 'Alikí tono lotó ke tokanga ki te 'ū me'a ne'e lea 'aki 'e Paulá. ");
INSERT INTO num_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Pea 'i te 'osi tono papitaisó, 'ia ia mo tono falé, pea kole mai ia 'o pehē, “Kāpau leva kua kotou lau 'oku ko te toko taha 'oku tui mo'oni ki te 'Alikí, pe'i kotou hū mai mu'a ki toku falé, 'o nofo 'i ai.” Pea puketu'u 'e ia 'ia mātou. ");
INSERT INTO num_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Pea ko 'eni, lolotonga te motou ō atu ki te lotú, mo te fakafetaulaki mai he kaunanga 'a ia ne'e ma'u 'e te fa'ahikehe kikite, pea ne'e lahi te koloa ne'e ma'u 'e te kakai ne'e 'o nātou 'ia te fafiné 'i tana kikité. ");
INSERT INTO num_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Pea ne'e fa'a mulimuli te fafine ko iá kiā Paula mo mātou, pea fa'a kaikaila ia 'o pehē, “Ko te kau siana nei ko te kau tamaio'aliki 'a te 'Atua Taupotú, pea 'oku notou fakahaa'i kiā kōtou 'ia te ala ki te fakama'ulí.” ");
INSERT INTO num_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Pea ne'e fai pehē ia 'o 'aho lahi. Pea ne'e mamahi ai 'ia Paula, 'o tafoki ia 'o lea ki te fa'ahikehé, “'Okou fekau kiā koe 'i te huafa 'o Sīsū Kalaisí ke ke hū mai mei te fafine ko 'ená!” Pea hū atu ia 'i te taimi pē ko iá. ");
INSERT INTO num_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pea ko te kakai ne'e 'o nātou 'ia te fafiné, 'i te notou vakai leva kua 'alu mo te fa'ahikehé te notou 'amanaki ma'u koloá, ne'e notou puke 'ia Paula mo Sailosi, 'o toho ki te mala'e fakataú, ko te 'ave ki te hau'alikí. ");
INSERT INTO num_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Pea notou taki 'ia nāua ki te ongo 'alikitaú, 'o notou pehē, “Ko te ongo siana Siu 'ení 'oku nā veuveuki lahi 'ia te tou koló, ");
INSERT INTO num_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","pea 'oku nā enginaki 'aki te 'ū anga 'oku kailoa ngafua kiā tātou ke fanongo ki ai, pe fai ki ai, he ko te kau Loma 'ia tātou.” ");
INSERT INTO num_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Pea ne'e kau 'ia te kakaí 'i tono tautea'i nāuá; pea ne'e hae te nā kofú 'e te hau'aliki taú 'o fekau ke haha 'ia nāua. ");
INSERT INTO num_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pea 'i te 'osi te notou haha 'ia nāuá 'o tu'a lahi, ne'e notou sī 'ia nāua ki pilīsone, 'o notou fekau ki te seilá ke tauhi 'ia nāua ke ma'u. ");
INSERT INTO num_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Pea ko te tangata ko iá, 'i tana ma'u leva he tu'utu'uni pehē, ne'e sī 'e ia 'ia nāua ki te loki lotolotó, 'o fakama'u te nā va'é ki te 'akau kii'i. ");
INSERT INTO num_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kā 'i te tu'ulapoó ne'e hiva fakamālō ki te 'Atuá 'ia Paula mo Sailosi, ko te fai te nā lotu, pea ne'e fakafanongo kiā nāua 'e te kau pōpulá. ");
INSERT INTO num_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Pea fakafokifā pē, kua hoko he mofuike ne'e pehē tono lahí he ne'e lulu'i te tu'unga 'o te pilīsoné. Pea ne'e matangaki leva 'ia te 'ū matapaá kotoa pē, pea mavete 'ia te ha'i 'o te kakaí kotoa pē. ");
INSERT INTO num_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Pea 'i te 'ala ake leva 'ia te seilá, 'o vakai atu kua matangaki 'ia te 'ū matapā 'o te pilīsoné, pea unuhi ia tana heletaá, 'o fai ke tāmate'i 'ona, ko tana mahalo kua feholaki 'ia te kau pōpulá. ");
INSERT INTO num_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ka ne'e kalanga le'o lahi 'ia Paula, 'o pehē atu, “'Aua na'a ke fai he kovi kiā koe, hē 'oku motou kei katokātoa 'i heni.” ");
INSERT INTO num_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Pea fekau 'e ia ke 'aumai he 'ū maama, 'o toki 'oho mai ki loto, 'o hinga tetetete atu 'i te 'ao 'o Paula mo Sailosí, ");
INSERT INTO num_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","pea 'aumai 'e ia 'ia nāua ki tu'a, 'o pehē ange, “Hau'aliki, ko te ā taku me'a ke fai kae au ma'ulí?” ");
INSERT INTO num_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Pea nā pehē ange, “Tui falala leva ki te 'Aliki ko Sīsuú ka ke ma'uli, 'ia koe mo tou falé.” ");
INSERT INTO num_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Pea nā lea kiā ia 'i te Folafola 'a te 'Alikí, pea ne'e 'i ai ia mo tono fāmilí kotoa pē. ");
INSERT INTO num_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Pea ne'e 'ave 'ia nāua 'e te seilá 'i te taimi ko iá, 'o tafitafi'i te nā 'ū laveá; pea ne'e papitaiso ia, 'ia ia mo nātou kotoa pē ne'e 'iā iá. ");
INSERT INTO num_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ne ina 'avake foki 'ia nāua ki tono falé, 'o teuteu'i he nā me'atokoni; pea ne'e fiafia ia kote'uhí kua notou tui ki te 'Atuá mo tono fāmilí kotoa pē. ");
INSERT INTO num_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pea kua 'aho leva, pea ne'e fekau mai 'e te ongo 'alikitaú 'ia te kau 'ōfisá ke iange, “Vete ange 'ia te ongo siana ko 'ená.” ");
INSERT INTO num_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Pea ne'e 'aumai 'e te seilá 'ia te tala ko iá kiā Paula, “Ko 'eni kua fekau mai 'e te ongo 'alikitaú ke vete ange 'ia kōlua; ko ia kulā hū atu leva, pea kulā ō fiamālie ā.” ");
INSERT INTO num_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Kā ne tali ange 'e Paula kiā nātou, “Kua notou haha 'ia māua 'i te 'ao 'o te kakaí he'iki ai fakamāu'i, kā ko te ongo Loma 'ia māua, pea kua nā sī ki te pilīsoné; pea 'oku nā pehē 'eni koā ke tukuange fakafufū pē 'ia māua? 'E kailoa 'aupito; kaikehe, 'oku totonu ke nā ōmai 'e nāua 'o taki atu 'ia māua.” ");
INSERT INTO num_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Pea 'ave 'e te kau 'ōfisá 'ia te lea ko iá ki te ongo 'alikitaú; pea ne'e nā manahē 'i te nā fanongo ko te ongo Loma 'ia nāuá. ");
INSERT INTO num_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Pea nā ōmai leva, 'o fakakolekole kiā nāua, mo nā taki atu, 'o iange ke nā hiki ā mei te koló. ");
INSERT INTO num_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pea nā ō atu mei te pilīsoné, 'o hū ki te fale 'o Litiá. Pea 'i te 'osi ange te notou fe'iloaki mo te kāingá, mo lea fakalotolahi kiā nātoú, pea nā toki ō leva. ");
INSERT INTO num_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pea ne'e notou fou atu 'i 'Amifipoli mo 'Apolonia, 'o notou a'u ki Tesalonaika, 'a ia ne'e tu'u ai he falelotu 'o te kakai Siú. ");
INSERT INTO num_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pea hū 'ia Paula ki ai, 'o hangē ko tana fa'a faí, 'o kau mo nātou; pea ko te Sāpate hokohoko 'e tolu ne ina alea ai mo nātou mei te Tohitapú, ");
INSERT INTO num_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","'o faka'uhinga'i mo fakamo'oni'i 'o pehē, “Ne'e pau ke feia 'ia te Kalaisí, pea ke toetu'u Ia mei te pekiá; ko 'eni ia 'ia te Kalaisi ko iá, 'ia Sīsū 'okou malanga 'aki kiā kōtoú.” ");
INSERT INTO num_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Pea ne'e 'i ai te notou 'ihi ne'e tui, 'o notou kau leva kiā Paula mo Sailosi, mo te fu'u tokolahi 'o te kau Kalisi kua lotu faka-Siú, mo te tokolahi 'o te kau fafine tu'ukimu'á. ");
INSERT INTO num_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pea ne'e meheka ai 'ia te kau Siú, 'o notou 'ave he kau siana pau'u ne'e notou tutu'u noa pē 'i te mala'e fakataú, 'o notou tānaki he fu'u kakai, mo notou veuveuki 'ia te koló. Pea notou 'ohofia 'ia te 'api 'o Sēsoní, 'o notou kumi kiā Paula mo Sailosi ke taki atu ki tu'a ki te kakaí. ");
INSERT INTO num_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pea 'i te kailoa notou ma'u 'ia nāuá, ne'e notou toki toho 'ia Sēsoni mo te 'ihi 'o te kāingá ki te kau pulekoló, 'o notou kalanga, “Ko te kau siana ko 'ená, 'a ia kua notou takihee'i 'ia māmaní, kua notou ha'u foki ki heni! ");
INSERT INTO num_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Pea kua fakaafe'i 'ia nātou 'e Sēsoni. Pea ko te kau siana ko iá kotoa pē 'oku notou talangata'a ki te 'ū tu'utu'uni 'a Sisá, 'aki te notou pehē, 'oku tu'i he taha kehe, ko Sīsū takua.” ");
INSERT INTO num_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Pea ne'e notou fakahoha'asi 'ia te kakaí mo te kau pulekoló 'aki te notou tala 'ia te 'ū me'a ko iá. ");
INSERT INTO num_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Pea ne'e notou 'eke'i he pa'anga malu'i meiā Sēsoni mo te kāingá, 'o notou toki tukuange 'ia nātou. ");
INSERT INTO num_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Pea hanga leva 'e te kāingá 'o tuku atu pō'uli 'ia Paula mo Sailosi ki Pēlea; pea 'i te notou a'u ki aí, ne'e ō ai pē 'ia nāua ki te falelotu 'o te kakai Siú. ");
INSERT INTO num_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Pea ne'e anga-lelei ange 'ia te kakai ko 'ení 'iā nātou 'i Tesalonaiká, hē ne'e notou tali loto lelei 'aupito 'ia te Folafolá, 'o notou kumi 'i te Tohitapú 'i te 'aho kotoa pē ki te mo'oni 'o te 'ū me'a ko iá. ");
INSERT INTO num_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ko ia ne'e tokolahi te notou kakai ne'e tuí, pea mo te hau'aliki fafine 'o te kakai Kalisí, pea mo te kau tangatá. ");
INSERT INTO num_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kā 'i tono 'ilo'i 'e te kakai Siu mei Tesalonaiká, kua malanga 'aki 'i Pēlea foki 'ia te Folafola te 'Atuá 'e Paulá, ne'e notou ōmai, 'o notou o'i mo fakahoha'asi 'ia te kakai 'i te kolo ko iá. ");
INSERT INTO num_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Pea tukuange leva 'e te kāingá 'ia Paula ke 'alu atu ki tai, kā ne'e nofo pē 'ia Tīmote mo Sailosi 'i ai fakatou'osi. ");
INSERT INTO num_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pea ko nātou ne'e notou 'ave 'ia Paulá ne'e notou 'aumai 'ona ki 'Atenisi; pea kua notou ma'u tana fekau kiā Sailosi mo Tīmote ke nā vave 'aupito mai, pea notou toki ō. ");
INSERT INTO num_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pea lolotonga te talitali 'e Paula kiā nāua 'i 'Atenisí, ne'e 'ita tono laumālie 'o'oná 'i tana vakai kua tamapua'ina 'ia te koló. ");
INSERT INTO num_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ko ia ne'e talanoa fakakikihi ia 'i te falelotú mo te kau Siú, mo te kakai kua lotu ki te 'Atuá, pea 'i te mala'e fakataú ne'e fai 'e ia 'i te 'aho kotoa pē kiā nātou ne'e notou fe'iloakí. ");
INSERT INTO num_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Pea ne'e 'i ai he 'ihi 'o te kau filōsefa mei te fa'ahinga 'Epikuliō, mo te fa'ahinga Sitoikó, ne'e notou fakakikihi mo ia. Pea ne'e pehē he 'ihi, “Ko te ā nai te 'uhinga 'o te lau te siana pālalau nei?” Pea ko te 'ihi ne'e notou pehē, “'Oku matamata ko he toko taha tu'uaki 'atua fo'ou;” ko tono 'uhingá ko tana malanga 'aki 'ia Sīsū mo te toetu'ú. ");
INSERT INTO num_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Pea notou puke'i 'ona, 'o taki ki te kosilio 'o te 'Aleopeikó, 'o notou iange, “'E ngafua koā ke motou 'ilo'i pe ko te ā 'ia te tokāteline fo'ou nei, 'a 'eni 'oku lea 'aki 'e koé? ");
INSERT INTO num_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","He kua ke 'aumai ki te motou talingá he 'ū me'a fo'ou; ko ia ai 'oku motou fia 'ilo'i, pe ko te ā te 'uhinga 'o te 'ū me'a ko iá.” ");
INSERT INTO num_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(He ko te kau 'Atenisi kotoa pē, mo te muli ne 'āunofo ki aí, ne'e kala notou tē fai he me'a kehe, kā ko te nofo pē ke talanoa, mo fakafanongo me'a fo'ou.) ");
INSERT INTO num_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pea kua tu'u 'ia Paula 'i te loto kosilio 'Aleopeikó, pea pehē ange 'e ia, “Kau tangata 'o 'Atenisi, 'okou vakai, tā ko te kakai 'ia kōtou 'oku hulu atu 'i te tauhi fa'ahikehé. ");
INSERT INTO num_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","He ko te lolotonga taku 'alu fanó, ne au fakatokanga'i 'ia te 'ū me'a 'oku kotou lotu ki aí, pea u 'ilo'i he 'ōlita ne'e tohi'i ai 'ia te lea ko 'ení, ‘MO'O TE 'ATUA 'OKU KAILOA 'ILOA.’ Pea ko te me'a 'oku kotou lotu ta'e'ilo ki aí, ko 'eni ia 'okou fakahaa'i atu kiā kōtoú. ");
INSERT INTO num_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ko te 'Atua ne'e ngaahi 'ia te 'univeesí, mo te me'a kotoa pē 'oku 'i aí, ko te 'Aliki Ia 'o te langí mo māmani; pea 'oku kailoa 'afio Ia he 'ū temipale kua ngaahi 'e te nimá; ");
INSERT INTO num_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","pea 'oku kailoa tauhi Ia 'e te nima 'o te tangata, 'o hangē kua masiva Ia he me'a — hē ko Tana 'Afió 'oku 'A'ana tono foaki mai kiā tātou kotoa pē 'ia te ma'ulí, mo te mānavá, mo te me'a kotoa pē! ");
INSERT INTO num_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Pea ne'e ngaahi 'e Ia mei te tangata pē taha 'ia te kakai kotoa pē ke nofo 'i te funga 'o māmaní fuli pē, pea kua fu'aki tukupau 'ia te 'ū kuongá mo te ngata'anga 'o te notou taki taha nofo'anga; ");
INSERT INTO num_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","kote'uhí ke notou kumi ki te 'Atuá, hei'ilo 'e notou fāfā Ia 'o 'ilo'i, kae tala'i'eaí 'oku mama'o Ia mei te tou fe'i toko taha. ");
INSERT INTO num_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Hē 'oku 'iā Ia 'ia te tou ma'ulí, mo te tou ngāué, mo te tou 'i aí; 'o hangē foki ko te lau 'e te 'ihi 'o te kau punake 'oku 'iā kōtoú 'o pehē, ‘He ko Tono hako foki 'ia tātou.’ ");
INSERT INTO num_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Pea kāpau leva ko te hako 'o te 'Atuá 'ia tātou, tala'i'eaí 'oku totonu te tou lau Tana 'Afió 'oku tatau mo he konga koula, pe siliva, pe maka, he me'a kua tongitongi, ko te ngāue mo te fakakaukau 'a te tangata. ");
INSERT INTO num_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Pea neongo ne'e kailoa fia 'afio'i 'e te 'Atuá 'ia te 'ū kuonga 'o te ta'e 'ilo ko 'ení, kā 'i onopooni 'oku Ina fekau ki te kakai kotoa pē 'i te feitu'u kotoa pē ke notou fakatomala. ");
INSERT INTO num_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kote'uhí kua Ina kotofa he 'aho, ke fakamaau mā'oni'oni ai 'ia māmani, 'o fou 'i te tangata kua Ina fakanofó; pea kua Ina fakapapau'i ia ki te kakai kotoa pē, 'i Tana fokotu'u 'Ona mei te pekiá.” ");
INSERT INTO num_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pea 'i te notou fanongo ki te lau toetu'u 'o te pekiá, ne'e luma he 'ihi; ka ne'e pehē he 'ihi, “'Aua leva ke motou tē fanongo kiā koe 'i te me'a ko iá 'āmuli ange.” ");
INSERT INTO num_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ne'e pehē te 'alu atu 'ia Paula mei te notou ha'oha'ongá. ");
INSERT INTO num_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ka ne'e 'i ai he kau tangata ne'e notou piki kiā ia, 'o notou tui; ko te notou taha ko Taionisio, 'a ia ne'e kau ki te ha'a 'Aleopeikó, pea mo he fafine ne'e hingoa ko Temalisi, mo te 'ihi kehe. ");
INSERT INTO num_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pea 'i te 'osi ange te 'ū me'a ko iá, ne'e 'alu 'ia Paula mei 'Atenisi, 'o a'u atu ki Kolinitō. ");
INSERT INTO num_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Pea ne'e fetaulaki ai ia mo he matu'a Siu, ko 'Akuila tono hingoá, 'a ia ne'e tupu ake 'i Ponitō; kua nā toki hiki mai mei 'Ītali mo tono hoá ko Pīsila, hē kua tu'utu'uni 'e Kalotiasi ke hiki 'ia te kakai Siu kotoa pē mei Loma. ");
INSERT INTO num_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pea kote'uhí ko te notou faiva tahá, ko ia ai ne'e nofo ia 'iā nāua 'o notou ngāue fakataha, he ko ta'a nāuá faiva ko te tufunga tēniti. ");
INSERT INTO num_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pea fai atu 'e Paula tana talanoa mo nātou 'i te falelotú 'i te Sāpate kotoa pē, 'o fakaului ai 'e ia he kau Siu mo he kau Kalisi. ");
INSERT INTO num_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Kā 'i te a'u mai leva 'ia Sailosi mo Tīmote mei Masitōniá, ne'e tokanga lahi 'ia Paula ki tana malangá, 'o fakamo'oni mālohi ia ke mahino ki te kakai Siú, ko Sīsū 'ia te Kalaisí. ");
INSERT INTO num_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ka ne'e notou fakafepaki'i ia mo lau'ikovi'i, pea toki tuu'i ia tono kofú mo iange kiā nātou, “Ke 'i te 'ulu pē 'o kōtoú 'ia te kotou totó; kua 'ata'atā 'ia au ia. Ko te 'osi 'ení, 'e au 'alu au ia ki te Senitailé.” ");
INSERT INTO num_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pea 'alu ia mei ai, 'o hū ki te 'api 'o he matu'a ne'e hingoa ko Siusitasa, 'a ia kua lotu mo'oni ki te 'Atuá, pea ko tono 'apí ne'e vāofi mo te falelotú. ");
INSERT INTO num_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Pea ko Kalisipō, ko te pule 'o te falelotú, ne'e lotu ia ki te 'Alikí mo tono fāmilí kotoa; pea ne'e fanongo mo tui 'ia te kakai Kolinitō tokolahi, 'o notou papitaiso. ");
INSERT INTO num_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Pea ne'e folafola mai te 'Alikí kiā Paula 'i te vīsone 'i te pō 'e taha, 'o pehē, “'Aua 'e ke manahē, ka ke lea pē, pea 'aua 'e mama'i fakalongolongo, ");
INSERT INTO num_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","hē ko 'eni 'Okou kau mo koe, pea 'e kailoa ala he taha kiā koe ke fai tou ngaahikovi'i, hē 'oku 'i ai he fu'u kakai tokolahi ia 'A'aku 'i te kolo ko 'ení.” ");
INSERT INTO num_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pea ne'e nofo ia 'i ai ko te ta'u 'e taha mo te māhina 'e ono, 'o ako 'aki te Folafola 'a te 'Atuá. ");
INSERT INTO num_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Pea 'i te lolotonga te kōvana 'ia Kalio 'i 'Ākeiá, ne'e kau fakataha 'ia te kakai Siú, 'o notou puke 'ia Paula, 'o taki 'ona ki te fakamāu'angá, ");
INSERT INTO num_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","'o notou pehē, “Ko te siana ko 'ení 'oku fakaloto'i 'e ia 'ia te kakaí, ke notou lotu ki te 'Atuá kae kala hangē ko te Laó.” ");
INSERT INTO num_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pea 'i te kamata lea ake 'ia Paulá, ne'e me'a 'e Kalio ki te kakai Siú, “Kau tangata Siu, kāpau ne'e 'i ai he maumau lao, pe ko he kākā kovi, pehē ne au mei tali te kotou me'á. ");
INSERT INTO num_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kae kāpau ko te koto lau pē ia ki te akonaki, mo te 'ū hingoa, mo te kotou laó, pe'i kotou tokanga ki ai 'e kōtou; hē kua pau toku lotó 'e kailoa u fakamāu'i he 'ū me'a pehē.” ");
INSERT INTO num_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Pea ne ina kapusi leva 'ia nātou mei te fakamāu'angá. ");
INSERT INTO num_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Pea toki hanga ai 'e te kakaí kotoa pē, 'o puke 'ia Sositene, ko te pule falelotú, 'o notou taa'i 'ona 'i te 'ao 'o te fakamāu'angá. Kā ne kailoa he mama'i tokanga 'e taha 'e Kalio kiā nātou. ");
INSERT INTO num_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pea ne'e kei nofo ai pē 'ia Paula 'o fualoa, pea toki māvae ia mo te kāingá, 'o folau mei ai ki Sīlia, pea ne'e ō fakataha mo ia 'ia Pīsila mo 'Akuila. Ka ne'e fu'aki tele 'e Paula to'onó 'ulu 'i Senikelea; kote'uhí ne'e 'i ai tana fuakava ne'e fai. ");
INSERT INTO num_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Pea 'i te notou a'u ki 'Efesoó, ne'e tuku ifo 'e ia 'ia nāua 'i ai; kae 'alu pē ia ki falelotu, 'o fai tana talanoa lotu mo te kakai Siú. ");
INSERT INTO num_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Pea 'i te notou kole ange ke ki'i nofonofo ifo mu'a mo nātoú, ne'e kailoa tali 'e ia, ");
INSERT INTO num_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ka ne'e lea māvae ange ia kiā nātou 'o pehē, “'E au foki mai kiā kōtou 'o kāpau ko te finangalo ia 'o te 'Atuá.” Pea folau atu leva ia mei 'Efesō. ");
INSERT INTO num_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Pea 'i tana tū'uta ki Sesaliá, ne'e 'alu ake ia 'o fe'iloaki 'i ai mo te siasí, pea toki 'alu ifo mei ai ki 'Aniteoke. ");
INSERT INTO num_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pea ne'e nofo ai pē ia 'i ai 'o fualoa ange, pea toki 'alu atu 'o 'a'ahi ki te 'ū feitu'u kotoa pē 'o Kalētia mo Filisiá 'o poupou'i te kau ako kotoa pē 'i aí. ");
INSERT INTO num_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Pea ne'e ha'u ki 'Efesō he matu'a Siu ne'e hingoa ko 'Āpolosi, 'a ia ne'e fanau'i 'i 'Alekisānitia, ko te tangata tufunga lea, pea ne'e mafai lahi 'aupito ia 'i te Tohitapú. ");
INSERT INTO num_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Pea kua akonakina 'ia te tangata nei ki te 'alunga 'o te 'Alikí, pea ko te toko taha loto māfana 'aupito; ko ia ne'e lea 'aki 'e ia mo ako totonu 'aki 'ia te 'ū me'a ne'e kau kiā Sīsuú, neongo ko te papitaiso pē 'a Sioné ne'e 'ilo 'e ia ki aí. ");
INSERT INTO num_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Pea ne'e kamata lea mālohi ia 'i te falelotú; pea 'i te fanongo ki ai 'e Pīsila mo 'Akuilá, ne'e nā fakaafe'i 'ona, 'o nā fakamatala'i kiā ia 'ia te 'alunga 'o te 'Atuá ke mahu'inga mālie kiā ia. ");
INSERT INTO num_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Pea 'i tana tokanga ke 'a'ahi ki 'Ākeiá, ne'e tohi te kāingá ki te kau akó, 'o kole ke notou tali lelei 'ona. Pea 'i tana a'u ki aí, ne'e 'aonga lahi ia ki te kakai kua tuí, ko te me'a 'i te kelesi 'a te 'Atuá. ");
INSERT INTO num_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","He ne'e tōtōivi ia 'i te fai fakakikihi mo te kau Siú 'i te 'ao 'o te kakaí, pea fakamahino'i 'e ia mei te Tohitapú ko Sīsuú ko te Kalaisí Ia. ");
INSERT INTO num_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Pea 'i te lolotonga te 'i Kolinitō 'ia 'Āpolosí, ne'e takai foli 'e Paula 'ia te 'ū feitu'u 'o tuku'utá, 'o a'u ifo ai ki 'Efesō. Pea ne'e 'ilo'i ai 'e ia he kau ako 'ihi 'i ai; ");
INSERT INTO num_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","pea pehē ange ia kiā nātou, “Ne'e kotou ma'u 'ia te Laumālie Mā'oni'oní 'i te taimi ne kotou tui aí?” Pea notou tali ange kiā ia, “Kailoa. Kua he'iki ai motou fanongo mātou ia 'oku 'i ai he Laumālie Mā'oni'oni.” ");
INSERT INTO num_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pea iange 'e ia kiā nātou, “Ka ne'e kotou papitaisó ki te ā?” Pea notou iange, “Ki te papitaiso 'a Sioné.” ");
INSERT INTO num_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pea iange 'e Paula, “Ko te papitaiso ne'e fai 'e Sioné ko te papitaiso fakatomala; pea iange 'e ia ki te kakaí ke notou tui kiā Ia 'oku mulimuli mai 'iā iá, 'a ia ko Sīsū.” ");
INSERT INTO num_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Pea 'i te notou fanongo ki aí, ne'e notou papitaiso ki te huafa 'o te 'Aliki ko Sīsuú. ");
INSERT INTO num_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pea 'i te hilifaki 'e Paula tono nimá kiā nātoú, ne'e hoko ifo kiā nātou 'ia te Laumālie Mā'oni'oní; pea notou kamata lea 'aki 'ia te 'ū lea kehekehe mo palōfisai. ");
INSERT INTO num_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ko te kau tangatá ne'e fe'unga nai mo te toko hongofulu mā ua. ");
INSERT INTO num_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pea hū atu ia ki te falelotú, pea ne'e māhina 'e tolu tana malanga mālohi 'aki 'ia te 'ū me'a ne'e kau ki te Pule'anga 'o te 'Atuá; 'o ina fakakikihi 'i ai, ke fakatui'i 'ia nātou. ");
INSERT INTO num_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Pea 'i te loto fefeka te notou 'ihi, mo kailoa notou tuitalá, mo notou lea kovi ki te 'alunga 'o te 'Alikí 'i te 'ao 'o te kakaí, ne'e hiki leva ia meiā nātou, pea ne'e vahe'i mai 'e ia 'ia te kau akó, 'o talanoa lotu 'i te 'aho kotoa pē 'i te fale ako 'o Tilanó. ");
INSERT INTO num_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pea ne'e fai pehē ia 'o ta'u 'e ua; ko ia ne'e fanongo ki te Folafola 'a te 'Alikí 'e te nofo 'Ēsiá kotoa pē, 'ia te Siu mo te Kalisí fakatou'osi. ");
INSERT INTO num_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ne'e fai foki 'e te 'Atuá 'iā Paula he fa'ahinga mana ne'e kehe atu, ");
INSERT INTO num_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","he ne'e 'ave pē he 'ū holoholo ki te kau mahakí, mo he 'ū vala, kua lave ki tono sinó, pea ne'e mahu'i leva meiā nātou te 'ū alanga mahakí, pea 'alu atu ki tu'a foki 'ia te 'ū fa'ahikehé. ");
INSERT INTO num_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Pea ne'e 'i ai he 'ihi foki 'o te kau Siú ne'e notou ō fano pē 'o faito'o 'āvea, pea ne'e notou 'ahi'ahi lea 'aki ki te kakai kua fa'ahikeheá 'ia te huafa 'o te 'Aliki ko Sīsuú, 'o pehē ange, “Ko taku kouna atu 'i te huafa 'o Sīsū 'oku fakahaa'i 'e Paulá.” ");
INSERT INTO num_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Pea ne'e fai pehē 'e te 'ū foha 'e toko fitu 'o Siva, ko he Siu ne'e taula'aliki lahi. ");
INSERT INTO num_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Pea tali ange 'e te fa'ahikehé 'o pehē, “Kua u 'ilo'i mo'oni 'ia Sīsū, pea kua u 'ilo'i foki 'ia Paula, kā ko te ā fua 'ia kōtou?” ");
INSERT INTO num_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Pea hopo kiā nātou 'ia te tangata ne'e 'ulusino ai 'ia te fa'ahikehé, 'o lava'i 'ia nātou, mo fai mālohi kiā nātou, ko ia ne'e notou feholaki mei te fale ko iá kua notou tēlefua mo mākafokafo. ");
INSERT INTO num_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Pea ne'e 'iloa 'ia te me'a ko 'ení ki te nofo 'Efesō kotoa pē, 'ia te Siu mo te Kalisi fakatou'osi; pea ne'e tō ai he 'ilifia kiā nātou kotoa pē, pea ne'e fakahīkihiki'i 'ia te huafa 'o te 'Aliki ko Sīsuú. ");
INSERT INTO num_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ko te tokolahi foki 'o te kakai kua tuí ne'e notou ōmai, 'o vete mo fakamatala'i te notou 'ū ngāué. ");
INSERT INTO num_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Pea ko te 'ihi 'o te fa'ahinga ne'e notou ngāue fiamaná ne'e notou tānaki mai te notou 'ū tohí 'o tutu 'i te 'ao 'o te kakaí. Pea ne'e notou fatu te mahu'inga 'o te 'ū tohí, pea tā ne'e fe'unga mo te konga siliva 'e nima mano. ");
INSERT INTO num_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ne'e pehē tana mātu'aki tupulakina pea mālohi 'ia te Folafola 'a te 'Atuá. ");
INSERT INTO num_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Pea kua 'osi te 'ū me'a ko iá, pea tu'utu'uni leva 'e Paula 'i tono laumālié ke 'a'ahi ki Masitōnia mo 'Ākeia, pea toki 'alu mei ai ki Selusalema; 'o pehē ia, “Kā hili pē taku 'alu ki aí, kua pau leva ke au mātā 'ia Loma foki.” ");
INSERT INTO num_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Pea fekau atu 'e ia he toko ua 'o tana kau tokoní ki Masitōnia, ko Tīmote mo Elasito; kā ne toe ta'ofi si'i ifo ia ki te ngāué 'i 'Ēsia. ");
INSERT INTO num_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Pea ne'e tupu 'i te 'ū 'aho ko iá he maveuveu lahi kote'uhí ko te lotú. ");
INSERT INTO num_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","He ne'e 'i ai he tangata ne'e hingoa ko Temetelio, ko te tufunga tuki siliva, pea ne'e ngaahi 'e ia te fanga ki'i fale siliva ko te fakatātā 'o te temipale 'o Taianá, pea ko te me'a lahi 'ia te koloa ne'e ma'u 'e te kau tufungá 'iā iá. ");
INSERT INTO num_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Pea ne ina fakataha'i 'ia nātou, pea mo te kakai ne'e ngāue ki te 'ū me'a peheé, pea iange ia, “Kau matāpule, 'oku kotou 'ilo'i ko te faiva ko 'ení 'oku tou tu'umālie ai. ");
INSERT INTO num_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Pea kua kotou sio mo fanongo, ko te siana ko Paulá kua ne fakaloto'i mo taki kehe'i he fu'u kakai, 'o kailoa 'i 'Efesō pē, kae meimei ko tono kātoa 'o 'Ēsiá, 'aki tana pehē 'oku kailoa ko he 'ū 'atua ia 'ā ē kua ngaahi 'e te nima 'o te tangatá. ");
INSERT INTO num_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Pea ko tono fakatu'utāmakí he 'e ongoongokovi ai te tou lakanga ko 'ení; 'o kala ko ia pē, kae hangē kā faifai pea lau 'ia te temipale 'o te fu'u 'atua fafine ko Taianá ko te me'a va'inga, pea hifo ai mei tono tu'unga lāngilangi'iná tana 'afió, 'ā ē 'oku lotu ki ai 'ia 'Ēsiá kātoa, 'io, mo māmani foki.” ");
INSERT INTO num_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Pea 'i te notou fanongo ki aí, ne'e notou mātu'aki lili 'aupito, pea notou kalanga 'o pehē, “Lāngilangi ā kā ko Taiana, ko te 'atua 'o te kakai 'Efesoó!” ");
INSERT INTO num_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Pea ne'e maveuveu lahi 'ia te koló; pea notou 'oho taha pē ki te fale faivá, pea kua notou puke 'ia Keio mo 'Alisitako, ko te ongo me'a Masitōnia, 'a ia ne'e kaungā fononga mo Paulá. ");
INSERT INTO num_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Kā 'i te tokanga 'ia Paula ke hū ki te fakatahá, ne'e ta'ofi 'ona 'e te kau akó. ");
INSERT INTO num_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Pea ko te 'ihi foki 'o te hau'aliki 'Ēsiá 'ā ē ne'e notou 'ofa kiā iá, ne'e notou fekau ange 'o kole ke 'aua na'a hū ia ki te fale faivá. ");
INSERT INTO num_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Pea ne'e kalanga 'aki te 'ihi 'a ē, pea ko te 'ihi ko 'ē, he ne'e hangē he pēpelí 'ia te fakatahá, pea ko te notou tokolahi ne'e kailoa notou 'ilo'i pe ko te ā te me'a kua notou fakataha ki aí. ");
INSERT INTO num_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Pea ko te 'ihi 'o te kakaí ne'e notou fusi ake 'ia 'Alekisānita; pea ne'e teke ake foki 'ona 'e te kakai Siú. Pea ta'alo atu 'ia 'Alekisānita ko tana fia fai he fakamatala ki te fakatahá. ");
INSERT INTO num_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kā 'i te notou vakai atu ko te Siu iá, ne'e hangē he le'o pē tahá 'ia te notou kalangá kotoa pē, 'o 'osi nai he houa 'e ua, “Lāngilangi ā kā ko Taiana ko te 'atua 'o tātou 'Efesoó!” ");
INSERT INTO num_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Pea kua lolomi 'ia te kakaí 'e te sekelitali 'o te koló, pea iange 'e ia, “'E kāinga 'Efesō, ko ai he tangata 'i māmani 'oku kailoa ina 'ilo'i, ko te kolo 'o tātou 'Efesoó ko te tauhi 'o te temipale 'o tana 'afió ko Taiana, mo te 'aitoli ne'e tō ifo meiā Siupitá? ");
INSERT INTO num_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ko te me'a ko iá 'e kailoa ala fakahalaki ia, ko ia ne'e mei sai ange ke kotou fakama'uma'u mu'a, 'o 'aua tou 'ohonoa ke fai he me'a. ");
INSERT INTO num_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","He kua kotou taki mai 'ia te ongo matāpule nei, 'a ia kua kailoa he nā maumau'i te tapu 'o te temipalé, pe lea kovi ki te tou 'atuá. ");
INSERT INTO num_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Pea ko te me'a kiā Temetelio, mo te kau tufunga 'oku notou kau mo iá, kāpau leva kua 'i ai he me'a 'oku notou kovi'ina ai he taha, ko te 'ū 'aho 'eni 'o te fai fakamaau, pea 'oku 'i ai te hau'aliki kōvana: ō nātou 'o 'ave te notou lāungá ki ai. ");
INSERT INTO num_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Pea kāpau ko te kotou fehu'í he me'a ange, 'e fakatonutonu ia 'i te fakataha kua tu'utu'uni 'e te laó. ");
INSERT INTO num_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Pea kala ko ia pē kae kāpau 'e 'ekea kiā tātou 'ia te fu'u angatu'u kua fai 'i te 'aho nei, tala'i'eaí 'oku 'i ai he tou fakamatala ke 'avatu ke 'uhinga ai 'ia te fakataha makehe ko 'ení.” ");
INSERT INTO num_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Pea 'i te hili ange tana lea peheé, ne'e tukuange 'e ia 'ia te fakatahá. ");
INSERT INTO num_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Pea 'i te nonga ifo 'ia te maveuveú, ne'e ui ange 'e Paula te kau akó, 'o fai he tokoni, mo he fekita kiā nātou, pea toki mahu'i atu ia ke 'alu ki Masitōnia. ");
INSERT INTO num_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Pea 'i te 'osi ange tana 'a'ahi ki te 'ū feitu'u ko iá, mo fai tana 'ū tokoni lahi kiā nātoú, pea toki 'alu ia ki Kalisi, ");
INSERT INTO num_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","'o māhina 'e tolu 'i ai. Pea 'i tono puleaki'i 'ona 'e te kakai Siú 'i tana teu ke tuku folau atu ki Sīliá, ne'e fakakaukau leva ia ke foki ake 'i Masitōnia. ");
INSERT INTO num_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Pea ne'e ō fakataha mo ia 'i tana fonongá 'ia Sōpeta ko te tangata Pēlea, ko te foha 'o Pulo; mo 'Alisitako mo Sekunio mei Tesalonaiká; mo Keio ko te tangata Teape, mo Tīmote, pea mo Tikiko mo Talofima mei 'Ēsia. ");
INSERT INTO num_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Pea ne'e mu'amu'a 'ia nātou ko 'ení 'o talitali mai kiā mātou 'i Taloasi. ");
INSERT INTO num_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Kā ko mātoú ne'e motou toki folau atu mei Filipai, 'i te 'osi 'ia te 'ū 'aho 'o te Mā Ta'e Lēvaní, pea ne'e motou toki a'u ake kiā nātou ki Taloasi 'i te 'aho tono nimá; 'o motou nofo ai 'i te 'aho 'e fitu. ");
INSERT INTO num_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Pea 'i te fu'aki 'aho 'o te uiké ne'e motou fakataha 'o pakipaki mā; pea ne'e malanga 'ia Paula kiā nātou, 'o a'u ki te tu'ulapoó, he ne'e teu ta'aná folau ki te 'āpongipongí. ");
INSERT INTO num_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Pea ne'e lahi te maama 'o te loki 'i lungá, 'ā ē ne'e motou fakataha 'i aí. ");
INSERT INTO num_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Pea ne'e 'i ai te talavou ne hingoa ko 'Utiko, ne'e hekaheka 'i te matapā teké; pea ne'e tule ifo ia 'o ma'u tana moé 'i te malanga fualoa fau 'a Paulá. Pea ne'e hinga ifo ia 'i tana moé, 'o patū ifo mei te funga vaka tono tolu 'o te falé, pea 'i tono hiki aké, kua pekia ia. ");
INSERT INTO num_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pea 'alu ifo 'ia Paula 'o fo'oifo kiā ia, mo fā'ufua ki ai, 'o iange, “'Aua kotou puputu'u; he kua 'iā ia ta'aná ma'uli.” ");
INSERT INTO num_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pea 'alu ake leva ia 'o fai te pakipaki 'o te maá, 'o notou kai; pea ne'e notou talanoa 'o fualoa, 'o a'u ki te ma'a 'o te 'ahó, pea toki mavahe ia 'o 'alu. ");
INSERT INTO num_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Pea notou toki taki mai 'ia te tamá kua ma'uli, pea ne'e notou fiamālie lahi 'aupito. ");
INSERT INTO num_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pea ne'e motou mu'amu'a 'ia mātou ia ki te vaká, 'o tuku folau atu ki 'Āsosi, ke motou fakaheka 'ia Paula 'i ai, he ko tana tu'utu'uní ia, he ne'e fia 'alu ala 'uta pē ia. ");
INSERT INTO num_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Pea kua motou fetaulaki 'i 'Āsosi, pea motou fakaheka ia, 'o hoko atu ki Mitilene. ");
INSERT INTO num_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Pea ne'e motou folau atu mei ai 'i te 'aho 'e tahá, 'o fe'unga ake mo Kaio; pea 'i te 'aho tono uá ne'e motou a'u ake ki Samo; pea 'i te 'aho leva tono hokó ne'e motou a'u ai ki Mileto. ");
INSERT INTO num_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","He kua fai tu'utu'uni 'e Paula ke fakalaka atu 'i 'Efesō, kote'uhí ke 'aua na'a tē mole he taimi 'i 'Ēsia, he ne'e fakavavevave ia, hei'ilo na'a lava ke 'Aho Penitekosi ki Selusalema. ");
INSERT INTO num_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pea fekau mai ia mei Mileto ki 'Efesō ke ōmai kiā ia 'ia te kau faifekau 'o te siasí. ");
INSERT INTO num_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Pea kua notou ōmai, pea iange leva 'e ia kiā nātou, “Ko kōtou 'eni, kua kotou 'ilo'i lelei 'ia te anga 'o taku nofo 'iā kōtoú, talu pē mei te fu'aki 'aho 'o taku a'u mai ki 'Ēsiá; ");
INSERT INTO num_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","'i taku ngāue fakatamaio'aliki ki te 'Alikí, 'a ia ne au fai mo te fakavaivai mo'oni, mo te tangi lo'imata; pea pehē foki ki te 'ū 'ahi'ahi ne'e hoko mai kiā au 'i tono puleaki'i 'e te kakai Siú. ");
INSERT INTO num_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Pea kua kotou 'ilo'i foki ne'e kailoa u ta'ofi he me'a 'e taha, kae au fakahaa'i pē mo ako 'aki kiā kōtou 'i te 'ao 'o te kakaí, pea 'i te fale taki taha; ");
INSERT INTO num_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","pea u fakapapau'i atu ki te Siu mo te Kalisí fakatou'osi 'ia te fakatomala 'o tafoki ki te 'Atuá, mo te tui pīkitai ki te tou 'Aliki ko Sīsuú. ");
INSERT INTO num_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Pea ko 'eni, ko taku 'alu 'eni ki Selusalema kua no'otekina 'oku 'e te Laumālié, pea 'oku kailoa u 'ilo'i pe ko te ā he me'a 'e hoko mai 'i ai kiā aú. ");
INSERT INTO num_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ngata pē 'i tono tala'i fakapatonu mai 'e te Laumālie Mā'oni'oní 'i te kolo taki taha, 'o pehē, 'oku talitali mai kiā au te 'ū ha'i, mo te fakamamahi. ");
INSERT INTO num_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Kae tala'i'eaí 'okou lau taku ma'ulí ko te me'a mahu'inga, pe 'oku tatau ia kiā au, mo te faka'osi 'o toku fatongiá, mo te lakanga ne au ma'u mei te 'Aliki ko Sīsuú, ke fakamo'oni ki te ongoongolelei 'o te 'ofa lahi 'a te 'Atuá. ");
INSERT INTO num_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Pea ko 'eni kua u 'ilo'i 'eni 'e kailoa he kotou taha 'e toe vakai mai ki toku matá, 'ia kōtou kotoa pē kua u malanga 'aki ki ai 'ia te Pule'anga 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ko ia kua u fakamo'oni atu kiā kōtou 'i te 'aho nei, 'oku 'ata'atā 'ia au ia mei te toto 'o te kakai kotoa pē. ");
INSERT INTO num_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","He ne'e kala u ta'ofi tono fakahaa'i kakato kiā kōtou 'ia te finangalo 'o te 'Atuá. ");
INSERT INTO num_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ko ia ai kotou lamasi 'ia kōtou, mo te fanga sipí kotoa pē, 'ā ē kua fakanofo kōtou ki ai 'e te Laumālie Mā'oni'oní ko te notou kau faifekau pule, kote'uhí ke kotou tauhi 'ia te siasi 'o te 'Atuá 'ā ē ne 'osi fakatau 'e Ia 'aki Tono ta'ata'a 'O'oná. ");
INSERT INTO num_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","He kua u 'ilo'i, kā 'osi ange ta'akú mavahe, 'e hū atu he fanga ulofi anga-mālohi, 'a ia 'e kailoa mamae ki te fanga sipí. ");
INSERT INTO num_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Pea na'a mo kōtou 'e ha'u mei ai te kau tangata 'oku lea 'aki te 'ū me'a 'oku 'alu kehe, ke tohoaki 'aki 'ia te kau akó ke mulimuli kiā nātou. ");
INSERT INTO num_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ko ia ai kotou le'o, pea manatu'i, ko te ta'u 'e tolu, 'i te pō mo te 'aho, ne'e kailoa u tuku taku na'ina'i 'ia kōtoú tāutaha, 'o fai pē mo te tangi. ");
INSERT INTO num_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Pea ko 'eni kua u tuku 'ia kōtou ki te 'Atuá, mo te Folafola 'o Tana kelesí, kiā Ia 'e mafai ke langa ake 'ia kōtoú, pea ke 'avatu te tofi'á fakataha mo te kakai kotoa pē kua fakatāpui. ");
INSERT INTO num_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ne'e kala u mānumanu he konga siliva 'a te toko taha kehe, pe koula, pe kofu. ");
INSERT INTO num_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","'Io, 'oku kotou 'ilo'i pē 'e kōtou ne'e ngāue toku ongo nima nei ki te tauhi 'o'oku mo te kakai ne'e notou 'iā aú. ");
INSERT INTO num_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ko taku ngāue kotoa pē ne fakahaa'i kiā kōtoú, kotou fai pehē, ke tokoni'i 'ia te vaivaí; pea ke manatu'i ai foki 'ia te Folafola 'a te 'Aliki ko Sīsuú, 'i Tana me'a mai, ‘'Oku manū'ia lahi ange tata fai he foaki atú 'i tata ma'u he foaki mai.’ ” ");
INSERT INTO num_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pea 'i te 'osi ange tana lea ko iá, ne'e tū'ulutui ia fakataha mo nātou kotoa pē 'o lotu. ");
INSERT INTO num_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Pea ne'e notou fetāngihi kotoa pē, 'o notou tāupe 'i te u'a 'o Paulá, 'o toutou 'uma lolomi kiā ia. ");
INSERT INTO num_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Pea ne'e 'ā'āsili te notou mamahí kote'uhí ko tana lea ne'e fai 'o pehē, 'e kala notou tē mamata ki tono fofongá. Pea notou ō leva mo ia ki te vaká. ");
INSERT INTO num_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Pea kua motou māvae mo nātou, 'o motou folau, pea motou lele 'o a'u ki Kusa; pea ko te 'aho tono hokó ne'e motou tau ki Lota, pea mei ai ki Patala. ");
INSERT INTO num_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Pea 'i te motou 'ilo'i 'i ai he vaka ne'e teu tana folau ki Finisiá, pea motou heka ki ai 'o folau. ");
INSERT INTO num_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Pea 'i te motou sio ki Saipaló, ne'e motou tuku ia ki to'ohema, kae motou taumu'a ki Sīlia, 'o motou tau ki Taia, he ko te feitu'u ia ke hifo ai te uta 'a te vaka nei. ");
INSERT INTO num_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ka ne'e motou kumi ki te kau akó, 'o motou nofo ifo ai 'i te 'aho 'e fitu. Pea ko te kau ako ko iá ne'e notou pehē ange kiā Paula, 'i te notou Laumālie'iná, ke 'aua na'a 'alu ake ia ki Selusalema. ");
INSERT INTO num_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Pea 'i te faifai pea kakato 'ia te 'ū 'aho ko iá, ne'e motou ō, 'o kamata fononga atu; pea ne'e lue fakataha mo mātou 'e te kau akó kātoa mo te notou 'ū 'unohó mo te fānaú ki te tua'ā koló. Pea ne'e motou tū'ulutui 'i te matātaí 'o lotu. ");
INSERT INTO num_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Pea kua motou māvae mo nātou, 'o motou heka ki vaka; kae notou foki nātou ia ki 'api. ");
INSERT INTO num_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Pea motou folau leva mei Taia ki Tolimeasi, 'o ngata 'i ai te motou folaú; pea motou fe'iloaki leva mo te kāingá, 'o motou nofo mo nātou 'i te 'aho 'e taha. ");
INSERT INTO num_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Pea 'i te pongipongi aké ne'e motou fononga atu 'o a'u ki Sesalia, 'o motou hū ai ki te fale 'o Filipe ko te 'evangeliō, 'a ia ne'e kau 'i te Toko Fitú; 'o motou nonofo mo ia. ");
INSERT INTO num_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Pea ne'e 'i ai tono 'ū 'ofafine tāupo'ou 'e toko fā, pea ne'e fa'a palōfisai 'e nātou. ");
INSERT INTO num_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Pea 'i te motou nofo 'i ai 'o 'aho lahí ne'e 'alu ifo mei Siutea he palōfita ne'e hingoa ko 'Akapusi. ");
INSERT INTO num_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Pea ha'u ia kiā mātou, 'o to'o 'ia te no'o 'o Paulá, 'o ha'i 'aki tono va'é mo tono nima 'o'oná pē, mo iange, “Ko 'eni te folafola 'a te Laumālie Mā'oni'oní, ‘Ko te tangata 'oku 'a'ana 'ia te no'o ko 'ení, 'e pehē pē tono ha'i 'i Selusalema 'e te kakai Siú, pea 'e notou tukuange 'ona ki te Senitailé.’ ” ");
INSERT INTO num_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Pea 'i te motou fanongo ki te me'a ko iá, 'ia mātou mo te kakai 'o te feitu'u ko iá, ne'e motou kole ange ke 'aua na'a 'alu ake ia ki Selusalema. ");
INSERT INTO num_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Kā ne tali mai 'e Paula, 'o pehē, “Ko te ā 'eni 'oku kotou faí, 'i te kotou fetāngihi ke fakavaivai'i toku lotó? He kua 'osi maau ta'akú teu, 'o kailoa ki te ha'isiá pē, kā ki te mate tāmate'i foki 'i Selusalema, kote'uhí ko te huafa 'o te 'Aliki ko Sīsuú.” ");
INSERT INTO num_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Pea 'i te kailoa lava tono fakaloto'í, ne'e motou tuku leva, 'o motou pehē, “Ke fai pē 'ia te finangalo 'o te 'Alikí.” ");
INSERT INTO num_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Pea 'i te 'osi ange te 'ū 'aho ko iá ne'e motou fakamā'opo'opo te motou 'ū me'á, 'o motou ō ake ki Selusalema. ");
INSERT INTO num_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Pea ne'e fononga mo mātou he 'ihi 'o te kau akó mei Sesalia, 'o notou 'aumai 'ia mātou kiā Manasoni mei Saipalo, ko te toko taha ia 'o te fu'aki kau akó, 'a ē 'e motou 'āunofo ki aí. ");
INSERT INTO num_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Pea 'i te motou a'u leva ki Selusalemá, ne'e talitali fiafia 'ia mātou 'e te kāingá. ");
INSERT INTO num_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Pea 'i te 'aho tono hokó, ne'e hū 'ia Paula mo mātou kiā Sēmisi; pea ne'e 'i ai foki mo te kau faifekau kotoa pē 'o te siasí. ");
INSERT INTO num_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pea kua fe'iloaki ia mo nātou, pea toki fakamatala faka'āuliliki ia 'ia te 'ū me'a kua fai 'e te 'Alikí ki te Senitailé 'i tana ngāué. ");
INSERT INTO num_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Pea 'i te 'osi ange te notou fanongo ki aí, ne'e notou tuku kolōlia ki te 'Atuá, mo notou iange kiā ia, “Kua ke vakai, 'e tokoua, ki te laui mano 'o te kakai Siu kua notou tuí; pea 'oku notou mamahi'i kotoa pē takua 'ia te Laó. ");
INSERT INTO num_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Pea kua fakahā ange 'e te 'ihi kiā nātou, 'o pehē takua, 'oku enginaki'i 'e koe 'ia te kau Siu kotoa pē 'oku nofo fakataha mo te Senitailé ke notou hiki mei te lao 'a Mōsesé, 'o lau takua 'e koe ke 'aua notou kamu te notou fānaú, pē ke 'aua na'a notou fou 'i te 'ū tu'utu'uní. ");
INSERT INTO num_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Pea fefe'aki leva? He kua pau ke fakataha mai he fu'u kakai, he 'e notou fanongo kua ke 'osi ha'u. ");
INSERT INTO num_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ko ia ai ke ke fai leva 'ia te 'ū me'a ko 'eni 'oku motou tala'i atú: 'oku 'i ai he kau tangata heni 'e toko fā, kua 'i ai te notou fuakava. ");
INSERT INTO num_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ke 'alu 'ia koe mo nātou, 'o kotou fakama'a fakataha, pea ke totongi 'e koe ma'a nātou, kote'uhí ke lava te notou tele 'ulú. Pea 'e toki 'ilo'i kotoa pē, tā ko te launoa 'ia te 'ū me'a ne'e notou talatalaaki'i 'aki 'oú; kaikehe 'oku fou founga 'ia koe, mo tauhi 'e koe 'ia te Laó. ");
INSERT INTO num_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Kā ko te me'a ki te kakai Senitaile kua tuí, kua motou tohi atu 'o tu'utu'uni, ke notou ngata pē 'i te faka'ehi'ehi mei te me'a kua feilaulau'i ki te 'aitolí, pea mei te totó, mo te manu kua sisiná, mo te fe'auakí.” ");
INSERT INTO num_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Pea ne'e toki 'ave 'e Paula 'ia te kau tangatá, pea 'i te 'aho leva tono hokó, ne'e fakama'a ia fakataha mo nātou, pea ne'e hū ia ki te Temipalé ke fakaongo ki te faka'osi 'o te taimi 'o te tapú, kae'aua ke fai he feilaulau ma'a nātou taki taha kotoa pē. ");
INSERT INTO num_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Pea kua mei 'osi 'ia te 'aho 'e fitú, ne'e fakatokanga'i 'ona 'i te Temipalé 'e te kau Siu mei 'Ēsiá; pea ne'e notou ue'i ai 'ia te kakaí kotoa pē, 'o notou ala fakamālohi kiā ia, ");
INSERT INTO num_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","mo notou kalanga, 'o pehē, “'Ia te kau tangata 'Isileli, kotou tokoni mai! Ko 'eni 'ia te tangata kua 'alu holo 'o fakaongoongokovi'i 'ia te kakai tapú, mo te Laó, mo te Temipale ko 'ení, 'i tana ako ki te kakaí 'i te feitu'u kotoa pē. 'Io, pea kua ne fakahū mai foki he kau Kalisi ki te Temipalé, 'o maumau'i ai 'ia te tapu 'o te Potu Tapu nei.” ( ");
INSERT INTO num_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ko tono 'uhingá, he ne'e notou mamata 'i mu'a kiā ia mo Talofima mei 'Efesō, 'oku nā ō holo mo ia 'i te koló, pea notou mahalo leva kua fakahū 'ona 'e Paula ki te Temipalé.) ");
INSERT INTO num_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Pea ne'e maveuveu 'ia te koló kātoa, pea felele'i mai 'ia te kakaí. Pea notou puke 'ia Paula, 'o toho 'ona ki tu'a 'i te Temipalé; pea notou tāpuni'i 'ia te 'ū matapaá. ");
INSERT INTO num_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Pea 'i te notou feinga ke tāmate'i 'oná, ne'e 'avake tono tala ki te 'aliki 'o te kau taú, 'o pehē, kua maveuveu 'ia Selusalema kātoa. ");
INSERT INTO num_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Pea 'alu leva ia mo he kau tau mo he kau senituliō, 'o notou felele'i ifo kiā nātou. Pea 'i te sio 'e te kakaí ki te 'alikitaú mo tana kau taú, ne'e notou tuku tono haha 'o Paulá. ");
INSERT INTO num_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Pea 'i te a'u mai 'ia te 'alikitaú, ne'e puke 'e ia 'ona, 'o fekau ke ha'i 'ona 'aki he seini 'e ua. Pea ne'e 'eke ange kiā ia pe ko ai ia, pea ko te ā 'ia te me'a kua faí 'e iá. ");
INSERT INTO num_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Pea toki kalanga 'aki he 'ihi 'o te kakaí 'a ē, pea ko te 'ihi 'a ē; pea 'i te kailoa lava ke 'ilo'i pau te mo'oní kote'uhí ko te longoa'á, ne'e fekau ke taki 'ona ki te loto kolotaú. ");
INSERT INTO num_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Pea 'i tana a'u ki te 'ū kaka'anga ki lungá, ne'e hiki'i 'ona 'e te kau taú, he kua 'oho mālohi mai 'ia te kakaí. ");
INSERT INTO num_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","He ne'e fe'ohofi mai ai pē 'ia te fu'u fakatahá, 'o notou kaila, “Fei mo tāmate'i!” ");
INSERT INTO num_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Pea 'i te notou feinga ke fakahū 'ia Paula ki te tauá, ne'e lea ange 'e ia ki te 'alikitaú, “'E ngafua ke au ki'i lea atu?” Pea pehē ange 'e ia, “'Oku poto koā 'ia koe 'i te lea faka-Kalisí? ");
INSERT INTO num_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Tā 'oku kailoa ko te matu'a 'Isipité 'ia koe, 'ā ē ne'e fakatupu angatu'u 'i te 'ū 'aho kua hili angé, mo taki atu ki te toafá 'ia te kau tangata fakapō 'e toko fā afe?” ");
INSERT INTO num_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pea iange leva 'e Paula, “Ko te tangata Siu 'ia au mei Tāsusi 'i Silisia, pea ko te kolo 'iloa ia 'okou kau ki aí. Ko ia ai 'okou kole atu ke ke tuku mu'a ke au lea ki te kakaí.” ");
INSERT INTO num_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Pea kua tukuange 'e ia ke lea, pea tu'u leva 'ia Paula 'i te 'ū kaka'anga ki lungá, 'o ta'alo tono nimá ki te kakaí. Pea 'i te notou fakalongolongó leva, ne'e lea atu ia 'i te lea faka-Hepeluú, 'o pehē: ");
INSERT INTO num_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Kāinga mo te mātu'a, kotou me'a lelei mai ki taku fakamatala 'oku fai atu ko 'ení.” ");
INSERT INTO num_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Pea 'i te notou fanongo 'oku lea 'aki mai 'e ia kiā nātou 'i te lea faka-Hepeluú, ne'e 'āsili ai te notou fakalongolongó. Pea fai atu ia, ");
INSERT INTO num_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ko aú ko te matu'a Siu; ne'e fanau'i 'oku 'i Tāsusi 'i Silisia, kā ne au tupu ake 'i te kolo ko 'ení, 'o ta'utu 'i te va'e 'o Kāmelielí, pea ne'e akonakina 'oku ke au talangafua ki te 'ū lao kotoa pē kua tukufakaholo mai mei te tou mātu'á. Pea ne au mamahi'i 'ia te 'Atuá, 'o hangē ko kōtoú fuli pē 'i te 'aho nei. ");
INSERT INTO num_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Pea ne au fakatanga'i 'ia te 'alunga ko 'ení 'o kala u toe afe mei te tāmaté, pea ne au ha'i 'o fakahū pilīsone 'ia te tangata mo te fafine fakatou'osi. ");
INSERT INTO num_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Pea 'oku fakamo'oni kiā au 'ia te Taula'aliki Lahí mo te Fakataha Fakamātu'á kotoa pē. Hē ne au ma'u tohi meiā nātou ke 'alu mo au ki te kāinga 'i Tāmasikusí, ke puke mo ha'i he kakai 'i ai, 'o taki mai ki Selusalema ke tautea'i. ");
INSERT INTO num_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Pea 'i taku fakaofiofi atu ki Tāmasikusí 'i te meimei ho'atā mālié, ne'e fokifā pē kua tapa takatakai kiā au he fu'u maama lahi mei te langí. ");
INSERT INTO num_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Pea ne'e tō 'ia au ki lalo, pea u fanongo ki te le'o 'oku pehē mai, ‘'E Saula, 'e Saula, ko te ā kua ke fakatanga'i ai 'Okú?’ ");
INSERT INTO num_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Pea u tali ange, ‘He ko ai 'ia Koe, 'Aliki?’ Pea folafola mai Ia, ‘Ko Sīsū 'eni mei Nāsaletí, 'ā ē 'oku fakatanga'i 'e koé.’ ");
INSERT INTO num_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Pea ko nātou ne'e 'iā aú ne'e notou sio ki te maamá, ka ne'e kailoa ongo'i 'e nātou 'ia te le'o 'o Ia ne'e lea mai kiā aú. ");
INSERT INTO num_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Pea u fehu'i atu, ‘'Aliki, ko te ā 'a'aku 'e faí?’ Pea folafola mai te 'Alikí kiā au, ‘Tu'u 'ia koe, 'o 'alu ki Tāmasikusi; pea 'e fakahaa'i atu ai kiā koe 'ia te 'ū me'a kua tu'utu'uni ke ke faí.’ ");
INSERT INTO num_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Pea 'i te kui toku matá, ko te me'a 'i te fu'u ngingila 'o te maama ko iá, ne'e takinima'i 'oku 'e te kakai ne'e motou oó, pea u a'u ai ki Tāmasikusi. ");
INSERT INTO num_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Pea ko te toko taha ko 'Ānanaia, ko te tangata lotu ne'e mātu'aki tauhi ia 'ia te Laó, pea ne'e fakaongolelei'i 'e te kakai Siu kotoa pē ne'e nofo 'i aí, ");
INSERT INTO num_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ne'e ha'u ia kiā au, pea tu'u mai ia 'o pehē mai, ‘Si'aku tokoua ko Saula, 'a'ala ake tou matá.’ Pea u sio ake leva 'i te taimi pē ko iá, 'o 'ilo'i ia. ");
INSERT INTO num_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Pea toki pehē mai ia, ‘Kua fili 'ou 'e te 'Atua 'o te tou mātu'á, ke ke 'ilo'i Tono finangaló, mo mamata ki te Toko Taha Anga-tonu ko iá, pea ke ke fanongo ki te le'o mei Tono fofongá. ");
INSERT INTO num_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kote'uhí ke hoko 'ia koe ko Tana fakamo'oni 'o te 'ū me'a kua ke mamata mo fanongo aí ki te kakai kotoa pē. ");
INSERT INTO num_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Pea ko te toe tatalí ke ā? Tu'u, pea papitaiso 'ia koe, 'o fufulu 'ou mei tau 'ū angahalá, pea ui ki Tono huafá.’ ");
INSERT INTO num_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Pea 'i taku toe foki ki Selusalemá, ne'e 'āvea 'ia au, lolotonga taku lotu 'i te Temipalé. ");
INSERT INTO num_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Pea ne au mamata kiā Ia, pea me'a mai Ia kiā au, ‘Fakato'oto'o, pea 'alu vave 'ia koe mei Selusalema; kote'uhí he 'e kailoa notou tali hau fakamatala kiā Au.’ ");
INSERT INTO num_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Kā ne au pehē ange, ‘'Aliki, kā ko nātou 'eni 'oku notou 'ilo'i lelei, ko au ia ne au fa'a fakahū pilīsone, mo haha 'i te 'ū falelotu kehekehe, 'ia te kakai 'oku lotu kiā Koé. ");
INSERT INTO num_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Pea 'i te notou fai te lilingi 'ia te toto 'o te Tou mā'ata ko Sitīvení, ne au tu'u foki mo au 'i ai, pea u loto ki tono tāmate'í, mo tauhi te 'ū kofu 'o te kakai ne'e notou tāmate'i 'oná.’ ");
INSERT INTO num_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Pea folafola mai Ia kiā au, ‘'Alu pē, he ko Au 'e Au tuku atu 'ou ke 'alu ki te mama'ó, ke fai Taku fekaú ki te Senitailé.’ ” ");
INSERT INTO num_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Pea ne'e notou fakafanongo kiā ia 'o a'u ki te lea ko iá, pea notou toki kalanga le'o lahi, “'Ave te siana ko 'ená mei māmani! He 'oku kailoa tonu ia ke ma'uli!” ");
INSERT INTO num_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Pea 'i te notou kaikaila, mo tupetupe'i te notou kofú, mo notou laku efu ki lungá, ");
INSERT INTO num_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ne'e fekau 'e te 'alikitaú ke 'aumai 'ona ki te tauá, 'o 'eke'i mo taa'i 'ona, kote'uhí ke 'ilo'i pe ko te ā tono 'uhinga 'o te notou kaila pehē kiā iá. ");
INSERT INTO num_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Kā 'i te lolotonga te notou ha'i 'o Paula ke fai tono kau'imaeá, ne'e lea ange 'e Paula ki te senituliō ne'e tu'u 'i aí, “'Oku ngafua koā 'i te laó ke kotou tautea taa'i he tangata Loma, kua he'iki ai fakamāu'i?” ");
INSERT INTO num_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Pea 'i te fanongo ki ai te senitulioó, ne'e 'alu leva ia 'o tala ki te 'alikitaú, 'o pehē, “Ko te ā tau me'a 'oku pehē ke faí, he ko te siana Loma 'eni!” ");
INSERT INTO num_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Pea ha'u leva 'ia te 'alikitaú, 'o iange kiā ia, “Tala'i mai pe ko te Loma 'ia koe?” Pea iange 'e ia, “Ko ia.” ");
INSERT INTO num_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Pea tali ange 'e te 'alikitaú, “Na'a mo au ne au totongi'i lahi ke au kau ki te kakai ko iá.” Pea iange 'e Paula, “Kā ko aú ne'e fā'ele'i ko te Loma.” ");
INSERT INTO num_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Pea vave leva te hiki atu meiā ia 'ia te kakai ne'e notou fai ke fakamamahi'i 'oná, pea ko te 'alikitaú foki ne'e manahē ia 'i tana 'ilo'i ko te Loma 'ia Paulá, he kua ne ha'i foki ia ke ma'u. ");
INSERT INTO num_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Kā 'i te 'aho tono hokó, kote'uhí ko tana fia 'ilo ki tono mo'oni 'o te me'a kua tukuaki'i 'aki 'ona 'e te kakai Siú, ne'e vete ange 'e ia tono ha'í, mo fekau ki te kau taula'aliki lahí mo te kau mēmipa 'o te Sanetalimí ke notou fakataha, pea toki 'aumai 'e ia 'ia Paula ki lalo 'o fokotu'u 'i te notou 'aó. ");
INSERT INTO num_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pea sio fakamama'u 'e Paula ki te Sanetalimí, 'o ina lea ange kiā nātou, “'E kāinga, talu pē mei mu'a 'o a'u mai ki te 'aho nei mo taku fai fatongia ma'a te 'Atuá mo te loto tau'atāina!” ");
INSERT INTO num_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Pea ne'e fekau 'e te Taula'aliki Lahí ko 'Ānanaia kiā nātou ne'e tu'u ofi 'i aí, ke notou taa'i tono ngutú. ");
INSERT INTO num_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pea pehē ange 'e Paula kiā ia, “'E taa'i 'ou 'e te 'Atuá, 'ia koe ko te holisi kua vali hinahina! He kua ke nofo ke fakamāu'i 'oku 'o fakatatau ki te laó, kae fekau 'e koe ke taa'i 'oku, 'a ē 'oku tapu 'i te laó?” ");
INSERT INTO num_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Pea ko nātou ne'e tu'u ofi maí ne notou iange, “'Oku pehē koā tau lea kovi ki te Taula'aliki Lahi 'a te 'Atuá?” ");
INSERT INTO num_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pea tali ange 'e Paula, “'E kāinga, ne kailoa u 'ilo'i, ko te Taula'aliki Lahí ia; he kua tohi, ‘'E kailoa ke lea kovi ki te pule 'o tou kakaí.’ ” ");
INSERT INTO num_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pea 'i te 'ilo'i 'e Paula, ko te 'āfaki 'e tahá ko te kau Sātusi, pea ko te 'āfaki 'e tahá ko te kau Fālesi, pea kaila leva ia 'i te lotolotonga 'o te Sanetalimí, 'o pehē, “'E kāinga, ko aú ko te Fālesi, ko te foha 'o te matu'a Fālesi; ko te me'a 'oku tou 'amanaki ki aí, 'io, 'ia te toetu'u 'o te pekiá, ko 'eni ia 'oku 'eke'i ai 'okú.” ");
INSERT INTO num_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Pea 'i tana lea peheé, ne'e hoko leva he fetu'usi 'i te kau Fālesí mo te kau Sātusí, pea mavae ua ai 'ia te fakatahá. ");
INSERT INTO num_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","He kua lau 'e te ha'a Sātusí, takua 'oku kala he toetu'u, pē he 'āngelo, pē he laumālie; kā 'oku tui 'ia te kau Fālesí 'oku 'i ai 'ia te 'ū me'a kātoa ko iá. ");
INSERT INTO num_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Pea ne'e hoko leva he fu'u vālau, pea tutu'u ake he 'ihi 'o te kau sikalaipé ne'e kau ki te fa'ahi Fālesí, 'o notou taukave'i 'o pehē, “'Oku kala motou 'ilo'i 'e mātou ia he kovi 'a te tangata nei; pea na'a kua lea kiā ia he laumālie pē he 'āngelo.” ");
INSERT INTO num_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Pea 'i te fakalalahi te fetu'usí, ne'e manahē 'ia te 'alikitaú na'a haehae 'ia Paula 'e nātou, pea ne ina fekau te kau taú ke ō ifo, 'o 'ave fakamālohi'i 'ona mei te notou lotolotongá, pea ke notou taki foki 'ona ki te tauá. ");
INSERT INTO num_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Pea 'i te pō ko iá ne'e tu'u mai 'ia te 'Alikí, 'o folafola ange kiā Paula 'o pehē, “'Aua ke lotosi'i; he 'e hangē pē ko tau fakamatala 'i Selusalema 'ia te 'ū me'a 'oku kau kiā Aú, pehē foki kua pau 'e ke fakamatala 'i Loma.” ");
INSERT INTO num_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Pea kua 'aho ake, pea ne'e fai 'e te kakai Siú te notou fefuakava'aki, 'o pehē, ke 'aua 'aupito na'a notou toe kai pe inu kae'aua leva kua notou tāmate'i 'ia Paula. ");
INSERT INTO num_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Pea ne'e toko fāngofulu tupu 'ia te kakai ne'e notou fai te fuakava ko iá. ");
INSERT INTO num_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Pea ne'e ō 'ia nātou ki te kau taula'aliki lahí, mo te kau mātu'á, 'o notou iange, “Kua fai te motou fuakava ki te 'Atuá, 'o pehē, 'e kala motou toe mama he me'a kae'aua ke motou tāmate'i 'ia Paula. ");
INSERT INTO num_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Pea ko 'eni, ke 'a kōtou mo te Sanetalimí tono fakahā ki te 'alikitaú, ke 'ave ifo 'ia Paula kiā kōtou, 'o hangē pē ko he kotou fia 'eke'i ke mahu'inga mālie 'ia te 'ū me'a 'oku kau kiā iá. Pea ko mātou leva, 'i te he'iki ai ofi mai iá, 'e motou 'i ai ke tāmate'i 'ona.” ");
INSERT INTO num_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kā ne'e 'ilo'i te notou fa'ufa'ú 'e te 'ilamutu 'o Paulá, 'o 'alu ia 'o hū ki te tauá, 'o tala'i kiā Paula. ");
INSERT INTO num_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pea ui ange leva 'e Paula he taha 'o te kau senitulioó, 'o pehē, “Ke 'ave mu'a te talavou nei ki te 'alikitaú, he 'oku 'i ai tana me'a ke fakahā ange kiā ia.” ");
INSERT INTO num_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ko ia ne'e 'ave leva te talavoú ki te 'alikitaú, 'o iange, “Ko te pōpula ko Paulá ne'e ui ange 'oku, 'o kole ke au 'aumai te talavou ko 'ení kiā koe, he 'oku 'i ai tana lea ke fai atu.” ");
INSERT INTO num_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Pea puke'i tono nimá 'e te 'alikitaú, 'o 'ave ke nā fakaenāua pē, 'o fehu'i ange ia, “Ko te ā tau me'a 'oku fia fakahaa'i mai kiā aú?” ");
INSERT INTO num_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Pea iange ia, “Kua alealea 'e te kau Siú ke kole atu kiā koe, ke 'ave ifo 'ia Paula 'āpongipongi ki te Sanetalimí, 'o hangē 'oku notou fia 'eke ke mahu'inga mālie 'ia te me'a 'oku kau kiā iá. ");
INSERT INTO num_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ko ia 'aua na'a ke tui kiā nātou; hē 'oku toitoi he notou kau tangata 'e toko fāngofulu tupu, kua notou 'osi fuakava, 'e kailoa 'aupito notou kai pe inu kae'aua ke notou tāmate'i 'ona. Pea kua notou 'osi teuteu, 'o talitali pē ki ha'aú tali te notou kolé.” ");
INSERT INTO num_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Pea tukuange leva 'e te 'alikitaú 'ia te talavoú, 'o fekau kiā ia, “'Aua na'a ke teitei tala'i ki he taha ne ke 'osi fakahaa'i mai te me'a ko 'ení kiā au.” ");
INSERT INTO num_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Pea ui ange 'e te 'alikitaú he toko ua 'o te kau senitulioó, 'o iange, “Teuteu mai te kau sōtia 'e toko uangeau, ke notou ō ki Sesalia, 'i te hivá pō'uli 'ānai, mo te kau tangata heka hoosi 'e toko fitungofulu, mo te kau tangata to'o tao 'e toko uangeau; ");
INSERT INTO num_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","pea teuteu foki mo he fanga monumanu, kote'uhí ke heka ai 'ia Paula, 'o a'utaki lelei 'ona kiā Filike ko te kōvaná.” ");
INSERT INTO num_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ne'e fai foki ia he tohi, 'o pehē: ");
INSERT INTO num_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Ko au Kalotiasi Lisia kiā Filike ko te 'aliki kōvana, 'ofa atu. ");
INSERT INTO num_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ko te tangata ko 'ení ne'e puke 'e te kau Siú 'o teuteu ke tāmate'i 'ona; kā ne au ha'u 'ia au mo taku kau taú, 'o fakahaofi, he 'okou 'ilo'i ko te Loma ia. ");
INSERT INTO num_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Pea 'i taku fia 'ilo foki ki te 'uhinga ne'e notou tukuaki'i 'aki iá, ko ia ne au 'ave ifo leva 'ona ki te Sanetalimi 'o nātoú. ");
INSERT INTO num_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Pea ne au toki 'ilo'i ai kua tukuaki'i 'ona 'i te me'a pē 'oku kau ki te notou laó, kā 'oku kailoa he me'a ia 'i te notou talatalaakí 'oku totonu ke mate ai, pē ke nofo pilīsone ai ia. ");
INSERT INTO num_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Pea 'i tono fakahaa'i mai kiā au takua kua toitoi he kau Siu ki te tangatá, ne au tuku atu leva 'ona kiā koe, pea ne au fekau foki ki te kau tukuakí ke fai te notou talatalaakí kiā koe. 'Ofa atu.” ");
INSERT INTO num_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Pea ne'e toki 'ave 'e te kau taú 'ia Paula, 'o hangē ko te fekau kiā nātoú, 'o notou taki pō'uli 'ona ki Anitepeta. ");
INSERT INTO num_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Pea 'i te pongipongi aké, ne'e notou tukuange te kau tangata heka hoosí ke notou ō mo ia, kae notou foki nātou ia ki te tauá. ");
INSERT INTO num_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Pea 'i te notou a'u atu ki Sesaliá, 'o notou 'ave te tohí ki te kōvaná, ne'e notou tuku atu foki 'ia Paula kiā ia. ");
INSERT INTO num_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Pea kua lau 'ia te tohí, pea fehu'i ange 'e ia kiā Paula pē 'oku mei te fanua fea ia. Pea 'i tana 'ilo'i ko te toko taha ia mei Silisiá, ");
INSERT INTO num_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ne'e iange 'e ia, “'E au toki fakamāu'i tau me'á 'o kā a'u mai tou kau tukuakí.” Pea fekau 'e ia ke tauhi 'ona 'i te palasi 'o Hēlotá. ");
INSERT INTO num_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pea 'i te 'osi mei ai te 'aho 'e nim