﻿USE sofia;
DROP TABLE IF EXISTS sofia.nuj_vpl;
CREATE TABLE nuj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nuj_vpl WRITE;
INSERT INTO nuj_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Mu hutandiha, Hatonda gatonda egulu nʼehyalo. ");
INSERT INTO nuj_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ehyalo hyali hiŋumamo hiitu hyosihyosi, ni hiri aŋo hiityo hiityo era ehiirema ni hiri hiisi ŋaatu hu maaji. NgʼOmwoyo wa Hatonda geereeranga hu maaji. ");
INSERT INTO nuj_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ngʼaŋo Hatonda alagira ati, “Ŋabeŋo enjase,” era nga yibaŋo. ");
INSERT INTO nuj_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nga Hatonda abona enjase ni yiri ndaŋi era nga gaabula enjase hu hiirema. ");
INSERT INTO nuj_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Nga Hatonda alanga enjase ati, “Muusi” ngʼehiirema ahiranga ati, “Wiire.” Ngʼegulo lyola era nga buhya, olwo njʼolwali oludaalo oludaayi. ");
INSERT INTO nuj_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Nga nindi Hatonda alagira ati, “Ŋabeŋo ebbanga ŋagati wʼamaaji ohwawula amaaji hu gahye.” ");
INSERT INTO nuj_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Nga Hatonda ataaŋo ebbanga ohwawula amaaji agaŋamugulu mu bbanga nʼagaŋaasi. Era hiityo pohyali. ");
INSERT INTO nuj_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Nga Hatonda alanga ebbanga ati, “Egulu.” Ngʼegulo lyola era nga buhya, olwo njʼolwali oludaalo olwohubiri. ");
INSERT INTO nuj_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ngʼaŋo Hatonda alagira ati, “Amaaji hu hyalo gehumbaanie mu hifo hirala, ŋabeŋo owoomu.” Era hiityo pohyali. ");
INSERT INTO nuj_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Nga Hatonda alanga owoomu ati, “Hyalo,” ngʼamaaji agalanga ati, “Nyanja.” Hatonda gabona ehi aholire ni hiri hiraŋi. ");
INSERT INTO nuj_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Nga Hatonda alagira ati, “Ebiitu ebya hiisi hiha bimeruhe hu hyalo: ebimera ebirimo owumo nʼemisaala ejaama ebibala ni mulimo nʼowumo.” Era hiityo pohyali, ");
INSERT INTO nuj_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ehyalo himeruhaho ebimera ebya hiisi hiha: emisaala ejaama ebibala ni mulimo nʼowumo. Hatonda gahibona ni hiri hiraŋi. ");
INSERT INTO nuj_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ngʼegulo lyola era nga buhya, olwo njʼolwali oludaalo olwohudatu. ");
INSERT INTO nuj_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Nga Hatonda alagira ati, “Leha ŋabeŋo ebyaduha mu bbanga ohwawulanga omuusi nʼowiire, biragenga endaalo nʼebiro nʼemyaha ");
INSERT INTO nuj_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","era byaduhenga ohuŋa ehyalo enjase.” Era hiityo pohyali. ");
INSERT INTO nuj_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Nga Hatonda ahola ebyaduha ebibbala bibiri, ehyaduha ehihira obubbala ohwaduhanga mu muusi, nʼehyaduha ehitono ohwaduhanga owiire. Era ngʼatonda nʼemunyeenye. ");
INSERT INTO nuj_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ngʼaŋo Hatonda abita mu bbanga biŋenga ehyalo enjase, ");
INSERT INTO nuj_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","biŋugenga mu muusi nʼowiire era byawulengaŋo ŋagati wʼenjase nʼehiirema. Hatonda gabona ehi aholire ni hiri hiraŋi. ");
INSERT INTO nuj_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ngʼegulo lyola era nga buhya, olwo njʼolwali oludaalo olwohune. ");
INSERT INTO nuj_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ngʼaŋo Hatonda alagira ati, “Amaaji gabemo ebitonde eduuli era ŋabeŋo nʼenyuni jiguluhe mu bbanga.” ");
INSERT INTO nuj_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Era Hatonda gatonda ebitonde ebibba ebya hiisi hiha, hiisi biramu era ebigenda mu maaji ebya hiisi hiha ko nʼenyuni eja hiisi hiha. Hatonda gabona ehi aholire ni hiri hiraŋi. ");
INSERT INTO nuj_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Nga Hatonda abiŋa ekabi abiroma ati, “Musaale mwale era mweyongere obungi, mwijule enyanja era nʼenyuni jeyongere obungi hu hyalo.” ");
INSERT INTO nuj_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ngʼegulo lyola era nga buhya, olwo njʼolwali oludaalo olwohutaanu. ");
INSERT INTO nuj_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ngʼaŋo Hatonda alagira ati, “Leha ehyalo hisaale hiisi hiitu ehiri nʼobulamu: ebisolo ebyomu mago, ebitonde ebyeŋalula hwiroba ko nʼesolo ejomwisugu mu biha byajo.” Era hiityo pohyali. ");
INSERT INTO nuj_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Nga Hatonda atonda ebyayo ebya hiisi hiha nʼesolo ejomwisugu eja hiisi hiha nʼebitonde ebyeŋalula hwiroba. Hatonda gabona ehi aholire ni hiri hiraŋi. ");
INSERT INTO nuj_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ngʼaŋo Hatonda aloma ati, “Hutonde omuutu mu hifaananyi hyefe, abe hyefe. Era baŋuge enyeeni mu nyanja nʼenyuni nʼebisolo ebyomu mago nʼehyalo hyosihyosi nʼebitonde byosibyosi ebigenda hwiroba.” ");
INSERT INTO nuj_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Nga Hatonda awumba omuutu mu hifaananyi hihye ehyene, mu hifaananyi hya Hatonda gamuwumba, omusinde nʼomuhasi polu gabawumba. ");
INSERT INTO nuj_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ngʼaŋo Hatonda abaŋa ekabi, abaloma ati, “Musaale mwale mweyongere obungi, mwijule ehyalo, muhiŋuge. Muŋuge enyeeni mu nyanja, hiisi nyuni era muŋuge hiisi hitonde ehigenda hu hyalo.” ");
INSERT INTO nuj_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Nga Hatonda aloma abaatu abo ati, “Mbaŋaaye hiisi wumo era hiisi musaala ogwama ebibala nʼowumo waagwo. Byosibyosi bija huba bibyo byahulya. ");
INSERT INTO nuj_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Era hiisi hisolo hu hyalo, hiisi nyuni era hiisi hiitu ehiramu ehigenda hu hyalo, kiŋaaye enyaasi ohuba mere.” Era hiityo pohyali. ");
INSERT INTO nuj_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Nga Hatonda abona hiisi ehi gahola ni hiri hiraŋi bugali. Ngʼegulo lyola era nga buhya, olwo njʼolwali oludaalo olwomukaaga. ");
INSERT INTO nuj_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Mu ngeri eyo, ngʼohutonda hwegulu nʼehyalo nʼebiitu byosibyosi, huŋwa. ");
INSERT INTO nuj_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Oludaalo olwomusanvu ko lwole, Hatonda gaali ahenire emirimo jije josijosi era nga aŋuumula hu ludaalo olwomusanvu. ");
INSERT INTO nuj_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Nga Hatonda aŋa oludaalo olwomusanvu ekabi, alufuula lwawufu hu jahye olwohuba njʼolu gaŋuumuliraho nʼahenire ohuhola omulimo ogwohutonda. ");
INSERT INTO nuj_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Bino njʼebyaliŋo mu hutonda hwegulu nʼehyalo: Musengwa Hatonda ni gatonda egulu nʼehyalo, ");
INSERT INTO nuj_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ŋaali ŋaŋuma misaala oba ebimera byosibyosi. Hyali hiityo olwohuba Musengwa Hatonda gaali ahiiri hutonyesa efula hu hyalo era ŋaali ŋaŋuma muutu owʼohulima. ");
INSERT INTO nuj_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Aye mu hiseera ehyo olume lwadoosanga eroba hiisi ŋaatu. ");
INSERT INTO nuj_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ngʼaŋo Musengwa Hatonda awumba omuutu mwiroba ngʼahena amufuuŋamo omuuya ogwʼobulamu mu suulu, ngʼomuutu afuuha mulamu. ");
INSERT INTO nuj_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ngʼaŋo Musengwa Hatonda ategeha endimiro ebuŋwalyuba mu hifo ehi balanga baati Edeni, ngʼaŋamba omuutu oyu gawumba amuta omwo. ");
INSERT INTO nuj_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Era Musengwa Hatonda amesa emisaala ejisangaasa ohubona era emiraŋi ohulya. Ŋagati wʼendimiro eyo, mwalimo omusaala oguleeta obulamu nʼomusaala oguleetera omuutu ohumanya ehiraŋi nʼehibi. ");
INSERT INTO nuj_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ŋahaani mu Edeni omwo mwasimuhamo olwabi olwajuhiiriranga endimiro eyo. Era olwabi olwo lweyabulamo esaga ene. ");
INSERT INTO nuj_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Olusaga olusooka balulanga baati Pisoni. Olwo lubita lwetoloola mu hyalo hyʼe Kavira hyosihyosi omuli ezaabbu. ");
INSERT INTO nuj_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Era ezaabbu eyomu hyalo ehyo ndaŋi bugali, mulimo nʼebyahawoowo ebi balanga baati bbedula ko nʼamabaale agʼebbeeyi aga balanga baati sokamu. ");
INSERT INTO nuj_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Olusaga olwohubiri ni balulanga baati Gihoni, lwetoloola mu hyalo hyʼe Kuusi hyosihyosi. ");
INSERT INTO nuj_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Olusaga olwohudatu balulanga baati Tigiriisi, lubita hutulo wʼebuŋwalyuba wa Busuuli. Olusaga olwohune balulanga baati Yufuleeti. ");
INSERT INTO nuj_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Musengwa Hatonda ni gaŋamba omuutu gamuta mu ndimiro Edeni, gamutamo ayirabirirenga. ");
INSERT INTO nuj_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Nga Musengwa Hatonda aloma omuutu ati, “Oli wʼedembe ohulya hu bibala byʼomusaala gwosigwosi hu misaala ejomu ndimiro ");
INSERT INTO nuj_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","aye sooli nʼohulya hu bibala byʼomusaala oguleetera omuutu ohumanya ehiraŋi nʼehibi olwohuba mu butuufu olu olibiryaho oja hufa.” ");
INSERT INTO nuj_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Nga Musengwa Hatonda aloma ati, “Sihiraŋi omuutu ohuba yeŋene. Nja humuholerayo omuyeedi amusaanira.” ");
INSERT INTO nuj_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ngʼaŋo Musengwa Hatonda atonda hiisi solo nʼenyuni ohuŋwa mwiroba. Ni gahena, ngʼabiŋirira omuutu abigulihe amasiina era hiisi ehi gabiranga, eryo njʼesiina lyahyo. ");
INSERT INTO nuj_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ngʼomuutu aguliha ebyayo nʼenyuni era nʼesolo ejomwisugu amasiina. Aye Adamu sigasunamo muyeedi amusaanira. ");
INSERT INTO nuj_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Olwʼehyo, Musengwa Hatonda gamuleetera ero eryʼamaani, gaŋenyuha. Ni gaali nʼaŋenyuha nga Hatonda amwomolamo olubafu ngʼahena asembaŋo nʼenyama. ");
INSERT INTO nuj_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ngʼaŋo Musengwa Hatonda aŋamba olubafu olugatusa mu musinde aluholamo omuhasi, ahena amumuŋirira. ");
INSERT INTO nuj_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Adamu ni gabona hu muhasi, galoma ati, “Ono njʼegumba eriŋooye mu magumba gange era mubiri oguŋooye mu mubiri gwange. Baja humulanganga baati ‘muhasi,’ olwohuba bamutuhiise mu musinde.” ");
INSERT INTO nuj_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Olwʼehyo omusinde analehenga semwana ni nyina, nga geŋimba nʼomuhasi wuwe nga bombi bafuuha mubiri mulala. ");
INSERT INTO nuj_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Omusinde nʼomuhasi wuwe baali majula aye ni baŋumaho soni. ");
INSERT INTO nuj_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Musengwa Hatonda gatonda esolo josijosi aye omusota gwali mugesigesi ohuhira josijosi. Ngʼaŋo lulala guloma omuhasi guuti, “Kaho Hatonda galoma ati, ‘Simulyanga hu bibala byʼomusaala gwosigwosi hu misaala jomu ndimiro’?” ");
INSERT INTO nuj_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ngʼomuhasi agugobolamo ati, “Huli badembe ohulya hu bibala byʼemisaala jomu ndimiro ");
INSERT INTO nuj_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ohutusaho Hatonda galoma ati, ‘Simulyanga hu bibala byʼomusaala oguli ŋagati wʼendimiro era nʼohuguŋambaho simuguŋambangaho, ni muli hihola muja hufa.’ ” ");
INSERT INTO nuj_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ngʼomusota gumuloma guuti, “Mu butuufu simuja hufa. ");
INSERT INTO nuj_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Hiri hiityo olwohuba Hatonda amanyire ati olu muligulyaho, emoni jenywe jija hulimbuha era mwesi mube hya Hatonda, ohumanya ehiraŋi nʼehibi.” ");
INSERT INTO nuj_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Omuhasi ni gabona ehibala hyʼomusaala ni hiboneha bulaŋi era ni hisaanira ohulya nga gegomba ohuhirya olwohuba hyali hireeta amagesi, kale nga anoga alya. Ngʼaŋaho ni wamwe yeesi owaali ŋalala ni naye. ");
INSERT INTO nuj_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ngʼaŋo emoni jaawe bombi jiiguha nga betegeera baati baali majula. Olwʼehyo banabanabania amahoola gʼemitiini, nga betaaho. ");
INSERT INTO nuj_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Egulo ni lyola, ngʼAdamu nʼomuhasi wuwe baŋulira Musengwa Hatonda nʼagenda mu ndimiro. Ni baŋulira, behweha hu Musengwa Hatonda ŋagati mu misaala ejomu ndimiro. ");
INSERT INTO nuj_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Nga Musengwa Hatonda alanga Adamu amubuusa ati, “Oli ŋeena?” ");
INSERT INTO nuj_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","NgʼAdamu amugobolamo ati, “Ni puliiye nʼogenda mu ndimiro, obuti bupambire nga nehweha olwohuba mbaye majula.” ");
INSERT INTO nuj_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ngʼamubuusa ati, “Omanyire otye oti oli majula? Oliiye hu bibala byʼomusaala ogu nahugaana ohulyaho?” ");
INSERT INTO nuj_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","NgʼAdamu amugobolamo ati, “Omuhasi oyu waapa ohubanga ni neese njʼowupaaye ehibala, nga ndya.” ");
INSERT INTO nuj_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Nga Musengwa Hatonda abuusa omuhasi ati, “Oholire hiina ehyo?” Ngʼomuhasi aloma ati, “Omusota njʼogukooŋire, nga ndya.” ");
INSERT INTO nuj_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Nga Musengwa Hatonda aloma omusota ati, “Olwohuba ohooŋire omuhasi, osunire ehiraamo ohuhiraho ebyayo ko nʼesolo josijosi ejomwisugu! Onagenderenga hida era onalyenga fuuhe endaalo josijosi ejʼobulamu buwo. ");
INSERT INTO nuj_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Era nja hutaaŋo obulabe ŋagati wuwo nʼomuhasi, naŋagati wʼolulyo lulwo nʼolwomuhasi. Omwana wuwe aja hutetenula omutwe gugwo era weesi oja hubbonja ehibbonje hihye.” ");
INSERT INTO nuj_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ngʼaloma omuhasi ati, “Nja huhwongeraho obulumi nʼosaala era oja husaaliranga mu bulumi. Onaŋembenga hu wamwo era aja huhuŋuganga.” ");
INSERT INTO nuj_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ngʼaloma Adamu ati, “Olwohuba oŋulirihiise omuhasi wuwo, walya hu hibala hyʼomusaala ehi nahugaana, hu lulwo eroba lisunire ehiŋwabo. Onahalabanenga ko wasuna ehyohulya endaalo josijosi ejʼobulamu buwo. ");
INSERT INTO nuj_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Eroba linamerenga amaŋwa amahosa nʼamanani era onalyenga bimera byomwisugu. ");
INSERT INTO nuj_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Onahahaluhanenga era watuyaana ko wasuna ehyohulya ohwola olu olyagama mwiroba, olwohuba omwo pomu waŋwa. Era olwohuba oli loba, mwiroba muweene omwo pomu olyagama.” ");
INSERT INTO nuj_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ebyo ni baŋwa, ngʼAdamu aguliha omuhasi wuwe esiina ati Kaawa, olwohuba gaali aja hufuuha nyina wʼabaatu bosibosi. ");
INSERT INTO nuj_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Nga Musengwa Hatonda aholera Adamu nʼomuhasi wuwe ebyambalo mu byanjo, ngʼabambasa. ");
INSERT INTO nuj_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Nga Musengwa Hatonda aloma ati, “Ŋaahani omuutu afuuhire hyefe, amanyire ehiraŋi nʼehibi. Hutamuleha hunoga alye hu musaala oguleeta obulamu ohuwangala emirembe nʼemirembe.” ");
INSERT INTO nuj_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Nga Musengwa Hatonda amubbinga ohuŋwa mu ndimiro Edeni, amuŋindiha aje alime eroba omu gamuwumba. ");
INSERT INTO nuj_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Oluvanyuma lwʼohubbinga omuutu mu ndimiro Edeni, Hatonda gaata ebuŋwalyuba wʼendimiro abakerubbi nʼepiima emasamasa ni yetala, ohuhuuma omuutu ohutalya hu musaala oguleeta obulamu. ");
INSERT INTO nuj_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ehiseera hyola, ngʼAdamu aŋenyuha nʼomuhasi wuwe Kaawa, ngʼasuna ehida asaala Kayini. Nga Kaawa aloma ati, “Musengwa yebale ohuupa omwana omuseere.” ");
INSERT INTO nuj_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Oluvanyuma ngʼasaala omwana owundi nga bamuguliha baati Abbiri. Ni bahula, Abbiri ngʼaba mwayi wʼetaama, Kayini ngʼaba mulimi. ");
INSERT INTO nuj_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ehiseera hyola, nga Kayini aŋira birala hu birime bibye ohuŋonga eyiri Musengwa. ");
INSERT INTO nuj_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","NgʼAbbiri aŋamba ndala hu taama jije eyaali endaayi mu husaaliwa, ayisala atusaamo ebitundu byayo ebyali ni bisinga ohuba ebisava abiŋongayo. Nga Musengwa asiima ebi Abbiri gaŋonga, ");
INSERT INTO nuj_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","aye ngʼatala ebya Kayini. Ehyo nga hiruŋia Kayini bugali weene era gasusuŋala nomu moni. ");
INSERT INTO nuj_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Nga Musengwa abuusa Kayini ati, “Lwahiina oluŋire era wasusuŋala nomu moni? ");
INSERT INTO nuj_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Nja huhusiima singa ohola ebiraŋi. Aye nʼotahola ebiraŋi, ehibi hibundaaye ŋa lwigi hyenda hihuŋuge aye oli nʼohuhiŋangula.” ");
INSERT INTO nuj_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ngʼaŋo Kayini aloma mugandawe Abbiri ati, “Hutiine mu ndimiro.” Ni baali ni bali eyo mu ndimiro, nga Kayini agwa hu mugandawe Abbiri, amwita. ");
INSERT INTO nuj_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Nga Musengwa abuusa Kayini ati, “Mugandawo Abbiri ali ŋe?” Nga Kayini amugobolamo ati, “Simanyire, ndiise omuhuumi wa muganda yange?” ");
INSERT INTO nuj_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Nga Musengwa aloma Kayini ati, “Oholire hiina ehyo? Amafugi ga mugandawo gaali hundiririra ohuŋwa mwiroba. ");
INSERT INTO nuj_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ŋaahani oliho ehiŋwabo era kubbingire nomu loba erinyooye amafugi ga mugandawo. ");
INSERT INTO nuj_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Onahalabanenga aye eroba sirinahwamirenga mere. Oja hubererera nʼolerenga hu hyalo nʼoŋuma aŋa weŋogoma.” ");
INSERT INTO nuj_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ngʼaŋo Kayini aloma Musengwa ati, “O-o, ehibonerezo ehi wupaaye hibbala bugali era sisobola nahuhigumira. ");
INSERT INTO nuj_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Wumbingire ohuŋwa hwiroba lino era wumbingire nʼohuŋwa aŋa oli. Ŋaahani nja hulerenga hu hyalo ni kaya aŋa neŋogoma era singa ŋabaŋo oyu ndigwamo, alinjita.” ");
INSERT INTO nuj_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Nga Musengwa aloma Kayini ati, “Bbe sihija huba hiityo era yesiyesi alihwita, aja husuna ehyegalulo emirundi musanvu.” Nga Musengwa ata eraama hu Kayini hiisi amubona atamwita. ");
INSERT INTO nuj_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Nga Kayini ahena aŋwa mu moni ja Musengwa, atiina mu hyalo hyʼe Noodi ebuŋwalyuba wʼEdeni. ");
INSERT INTO nuj_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ngʼehiseera hyola, Kayini aŋenyuha nʼomuhasi wuwe era omuhasi wuwe ngʼagwamo ehida asaala omwana musinde bamuguliha baati Enoka. Mu hiseera ehyo Kayini gaali alihutongola ehibuga era ngʼahitaho esiina lyʼomusaani ati Enoka. ");
INSERT INTO nuj_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ngʼaŋo Enoka asaala Yiradi nga Yiradi asaala Mekuyayeri nga Mekuyayeri asaala Mesusayeeri nga Mesusayeeri asaala Lameeka. ");
INSERT INTO nuj_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Nga Lameeka aleeta abahasi babiri, omudaayi gaali njʼAda, owohubiri gaali nje Ziira. ");
INSERT INTO nuj_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","NgʼAda asaala Yabbaali semwana wʼabo abamenya mu weema era abaayi bʼebyayo. ");
INSERT INTO nuj_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Mugandawe gaali nje Yubbali, oyo nje semwana wʼabo abahubbi bʼebidongo nʼemirere. ");
INSERT INTO nuj_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Nga Ziira yeesi asaala omwana omusinde oyu balanganga baati Tubbali Kayini. Oyo gaali mubboti wa hiisi hiitu ohuŋwa mu byoma. Mboojo ya Tubbalu Kayini gaali nje Naama. ");
INSERT INTO nuj_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Olwola, nga Lameeka aloma abahasi babe ati, “Ada ni Ziira enywe abahasi ba Lameeka mupulirise, muŋulire ebibono byange. Ese, neeta omuutu olwohuba gaafumita, neeta omuvubuka olwʼehisago ehi gaataho. ");
INSERT INTO nuj_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Obanga owiita Kayini balimwegalula emirundi musanvu, balyegalula emirundi sanvu namusanvu olwa Lameeka.” ");
INSERT INTO nuj_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","NgʼAdamu nindi aŋenyuha nʼomuhasi wuwe, asaala omwana museere nga bamuguliha baati Seezi, mula nʼaloma ati, “Hatonda gapaaye omwana owundi mu hifo hyʼAbbiri oyu Kayini geeta.” ");
INSERT INTO nuj_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seezi ni gahula nga yeesi asaala omwana museere bamuguliha baati Enosi. Ebiseera ebyo mbebi baatu batandihiramo ohujumirya Musengwa. ");
INSERT INTO nuj_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Luno njʼolwanji lwʼamasiina gʼabaatu abomu lulyo lwʼAdamu. Hatonda ni gawumba omuutu, gamuwumba mu hifaananyi hihye. ");
INSERT INTO nuj_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Gawumba omusinde nʼomuhasi, ngʼahena abaŋa ekabi. Ngʼabalanga ati baatu. ");
INSERT INTO nuj_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamu ni gahena emyaha cikumi mwasatu, gasaala omwana museere owaali nʼamufaanana, mu hifaananyi hihye ehyene era ngʼamuguliha esiina ati Seezi. ");
INSERT INTO nuj_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Oluvanyuma lwʼohusaala Seezi, Adamu gahena emyaha lunaana, ngʼasaala abaana abandi abaseere nʼabahaana. ");
INSERT INTO nuj_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ŋosiŋosi Adamu gahena emyaha lwenda nʼadatu, ngʼafa. ");
INSERT INTO nuj_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seezi ni gahena emyaha cikumi nʼetaanu, ngʼasaala Enosi. ");
INSERT INTO nuj_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Oluvanyuma lwa Seezi ohusaala Enosi, gahena emyaha lunaana namusanvu ngʼasaala abaana abandi abaseere nʼabahaana. ");
INSERT INTO nuj_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ŋosiŋosi, Seezi gahena emyaha lwenda ehumi nʼebiri, ngʼafa. ");
INSERT INTO nuj_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosi ni gahena emyaha cenda, gasaala Kenani. ");
INSERT INTO nuj_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Oluvanyuma lwʼEnosi ohusaala Kenani, gahena emyaha lunaana ehumi nʼetaanu, gasaala abaana abandi abaseere nʼabahaana. ");
INSERT INTO nuj_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ŋosiŋosi Enosi gahena emyaha lwenda nʼetaanu, ngʼafa. ");
INSERT INTO nuj_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenani ni gahena emyaha sanvu, gasaala Mahalalyeri. ");
INSERT INTO nuj_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Oluvanyuma lwa Kenani ohusaala Mahalalyeri, gahena emyaha lunaana mu ana, gasaala abaana abandi abaseere nʼabahaana. ");
INSERT INTO nuj_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ŋosiŋosi Kenani gahena emyaha lwenda nʼehumi, ngʼafa. ");
INSERT INTO nuj_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalyeri ni gahena emyaha kaaga nʼetaanu, gasaala Yaledi. ");
INSERT INTO nuj_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Oluvanyuma lwa Mahalalyeri ohusaala Yaledi, gahena emyaha lunaana mwasatu, gasaala abaana abandi abaseere nʼabahaana. ");
INSERT INTO nuj_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ŋosiŋosi Mahalalyeri gahena emyaha lunaana mu cenda nʼetaanu, ngʼafa. ");
INSERT INTO nuj_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaledi ni gahena emyaha cikumi nakaaga nʼebiri, gasaala Enoka. ");
INSERT INTO nuj_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Oluvanyuma lwa Yaledi ohusaala Enoka, gahena emyaha lunaana, ngʼasaala abaana abandi abaseere nʼabahaana. ");
INSERT INTO nuj_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ŋosiŋosi Yaledi gahena emyaha lwenda kaaga nʼebiri, ngʼafa. ");
INSERT INTO nuj_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoka ni gahena emyaha kaaga nʼetaanu, gasaala Mesuseela. ");
INSERT INTO nuj_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Oluvanyuma lwʼEnoka ohusaala Mesuseela, ngʼaba nʼekolagana endaŋi ni Hatonda ohuhena emyaha bidatu era gahena gasaala abaana abandi abaseere nʼabahaana. ");
INSERT INTO nuj_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ŋosiŋosi, Enoka gahena emyaha bidatu kaaga nʼetaanu. ");
INSERT INTO nuj_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Mu bulamu wuwe, Enoka gaali nʼekolagana endaŋi ni Hatonda era lwali lulala nga Hatonda amutusa mu hyalo muno nʼahiiri mulamu. ");
INSERT INTO nuj_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mesuseela ni gahena emyaha cikumi mukinaana namusanvu, gasaala Lameeka. ");
INSERT INTO nuj_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Oluvanyuma lwa Mesuseela ohusaala Lameeka, gahena emyaha lusanvu kinaana nʼebiri ngʼasaala abaana abandi abaseere nʼabahaana. ");
INSERT INTO nuj_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ŋosiŋosi, Mesuseela gahena emyaha lwenda kaaga namwenda, ngʼafa. ");
INSERT INTO nuj_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameeka ni gahena emyaha cikumi kinaana nʼebiri, gasaala omwana omuseere. ");
INSERT INTO nuj_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Omwana oyo gamuguliha esiina ati nje Nuwa, nʼaloma ati, “Omwana ono alituleetera ehiŋuumulo ohuŋwa mu huhalabana nʼohutegana ohwaja Musengwa ni gaholimira eroba.” ");
INSERT INTO nuj_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Oluvanyuma lwʼohusaaliwa hwa Nuwa, Lameeka gahena emyaha bitaanu cenda nʼetaanu ngʼasaala abaana abandi abaseere nʼabahaana. ");
INSERT INTO nuj_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ŋosiŋosi, Lameeka gahena emyaha lusanvu sanvu namusanvu, ngʼafa. ");
INSERT INTO nuj_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Oluvanyuma lwa Nuwa ohuhena emyaha bitaanu, gasaala Seemu ni Kaamu ko ni Yafeesi. ");
INSERT INTO nuj_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Abaatu ni batandiiha ohweyongera obungi hu hyalo, basaala abaana bahaana. ");
INSERT INTO nuj_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ngʼabaana ba Hatonda babona abahaana bʼabaatu ni baali baŋoono, nga babaŋira ohuba bahasi baawe ngʼolu basiimanga mu myoyo jaawe abeene. ");
INSERT INTO nuj_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Nga Musengwa aloma ati, “Sinja huleha muutu huwangaala emirembe nʼemirembe olwohuba mubiri bubiri. Ŋaahani aja huhenanga emyaha cikumi mwabiri joŋene.” ");
INSERT INTO nuj_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Mu hiseera ehyo era nʼebyalondaho, ŋaaliŋo Abanefuuli hu hyalo era babasaala olu baana ba Hatonda baŋenyuhanga nʼabahaana bʼabaatu. Ahale hale, Abanefuuli abo baali baatu abʼamaani era ni bamanyiheene. ");
INSERT INTO nuj_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Nga Musengwa abona ebibi byʼomuutu ni biri bingi hu hyalo era hiisi hufumitiriza hwʼebiŋeego bibye habuhyabuhya ni huli hu huhola bibi hyoŋene. ");
INSERT INTO nuj_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Era ehyo hyanakuŋasa Musengwa, gehebulisa lwahiina gawumba omuutu. ");
INSERT INTO nuj_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Nga Musengwa aloma ati, “Nja husihiirisa omuutu oyu samwene newumbira mutuse hu hyalo. Era omuutu nʼesolo nʼebyeŋalula hwiroba nʼenyuni, nja hubisihiirisa olwohuba nehebulisa lwahiina nabitonda.” ");
INSERT INTO nuj_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Aye wayire ebyo byali biityo, Nuwa niye gaali muhoda eyiri Musengwa. ");
INSERT INTO nuj_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Bino njʼebiŋamba hu Nuwa: Nuwa mu mulembe gugwe gaali muutu mugwalaafu ni ŋaŋuma hyahumweŋambya. Era gaali nʼekolagana endaŋi ni Hatonda. ");
INSERT INTO nuj_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuwa gaali nʼabasaani badatu: Seemu ni Kaamu ko ni Yafeesi. ");
INSERT INTO nuj_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Abaatu hu hyalo baali mu gwa huhola bibi mu moni ja Hatonda era ni bejuuye buhambwe bwoŋene. ");
INSERT INTO nuj_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Hatonda gabona ehyalo ni hyejuuye bibi olwohuba hiisi muutu hu hyalo gaali hu gwahuhola bibi. ");
INSERT INTO nuj_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Nga Hatonda aloma Nuwa ati, “Ekomerero ya hiisi muutu yoolire olwohuba ehyalo hyejuuye ebikolwa byawe ebibi. Ŋaahani nja husihiirisa ehyalo nʼabaatu bosibosi. ");
INSERT INTO nuj_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Olwʼehyo, baaja meeri mu musaala ogu balanga baati gofeeri. Emeeri eyo yija huba ya kalina era oyiŋaheho kolansi mugati nohu mugulu. ");
INSERT INTO nuj_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Baaja meeri eyʼefuuti bina nʼataanu obuleeŋi, obugalamu efuuti sanvu nʼetaanu, obuleeŋi ŋamugulu efuuti ane nʼetaanu. ");
INSERT INTO nuj_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Lehaho amadegeyi agʼeyiici ehumi namunaana, ohene oteho nʼomulyango mu mbafu. Emeeri eyo yija huba lya kalina edatu. ");
INSERT INTO nuj_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nja huleeta amataba hu hyalo ohusihiirisa hiisi hiitu ehiramu. Era hiisi hiitu hija hufa. ");
INSERT INTO nuj_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Aye ndihola endagaano yange ni neewe. Ewe nʼomuhasi wuwo nʼabasaani babo ko nʼabahasi baawe, muja hwingira mu meeri. ");
INSERT INTO nuj_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Era oja hwingisa hiisi hitonde mu meeri ohuba ni neewe ko biŋone. Oja hwingisa bibiri bibiri, ehisinde nʼehihasi. ");
INSERT INTO nuj_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Oja huŋamba hiisi hiha hyʼenyuni nʼehyesolo era hiisi hitonde ehigenda hwiroba, ehihasi nʼehisinde mwingire ni nabyo mu meeri bitasihiiriha. ");
INSERT INTO nuj_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Oja huhumbaania hiisi hiha hyʼemere, obunge mu meeri. Ewe nʼamago gago ko nʼebitonde muja hulyangaho.” ");
INSERT INTO nuj_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Era Nuwa gahola ebyo byosibyosi ngʼolu Hatonda gamulagira. ");
INSERT INTO nuj_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ehiseera hyola nga Musengwa aloma Nuwa ati, “Ewe nʼamago gago mwesimwesi, mwingire mu meeri olwohuba oli mugwalaafu mu moni jange mu mulembe guno. ");
INSERT INTO nuj_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ŋamba hiisi hiha hyʼehisolo ehirongoofu musanvu musanvu ehihasi nʼehisinde era ohene oŋambe bibiri bibiri hu bitali birongoofu ehihasi nʼehisinde, ");
INSERT INTO nuj_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","oŋambe hiisi hiha hyʼenyuni musanvu musanvu, ehihasi nʼehisinde byahasaala mu hyalo oluvanyuma lwʼamataba. ");
INSERT INTO nuj_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Hiri hiityo olwohuba oluvanyuma lwʼendaalo musanvu ohuŋwa olwa leero, nja hutonyesa efula hu hyalo yigwe omuusi nʼowiire ohuhena endaalo amahumi ane. Era nja husihiirisa hiisi hiitu ehiŋeera ehi natonda.” ");
INSERT INTO nuj_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Era Nuwa gahola hiisi hiitu ngʼolu Musengwa gamulagira. ");
INSERT INTO nuj_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Mu hiseera ehi mataba gaali hu hyalo, Nuwa gaali nʼemyaha lukaaga. ");
INSERT INTO nuj_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Era Nuwa nʼomuhasi wuwe nʼabasaani babe ko nʼabahasi baawe bengira emeeri ohuŋona amataba. ");
INSERT INTO nuj_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ebisolo ebirongoofu nʼebitali birongoofu ko nʼenyuni nʼebitonde byosibyosi ebigendera hwiroba ");
INSERT INTO nuj_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","bibiri bibiri ehisinde nʼehihasi, byengira ni Nuwa mu meeri ngʼolu Hatonda gamulagira. ");
INSERT INTO nuj_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Era oluvanyuma lwʼendaalo omusanvu ejo, amataba gaaja hu hyalo. ");
INSERT INTO nuj_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nuwa ni gaali nʼaŋesa emyaha lukaaga, mu mwesi ogwohubiri ngʼehumi namusanvu, esulo josijosi ohuŋwa mwiroba jiiguha nʼegulu lyosi nga liŋomoha. ");
INSERT INTO nuj_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Era efula yajofumuha hu hyalo endaalo amahumi ane mu muusi nʼowiire. ");
INSERT INTO nuj_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Hu ludaalo olwo olu efula yatandihiraho ohujofumuha, Nuwa nʼomuhasi wuwe nʼabasaani babe badatu, Seemu ni Kaamu ni Yafeesi ko nʼabahasi baawe, bengira emeeri. ");
INSERT INTO nuj_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Bengira meeri nahiisi hiha hyʼesolo ejomwisugu ko nʼebyayo, hiisi hitonde ehigenda hwiroba, hiisi hiha hyʼenyuni, josijosi ejiri nʼamabaŋa. ");
INSERT INTO nuj_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Hiisi bitonde byatiina bibiri bibiri eyiri Nuwa nga byengira emeeri. ");
INSERT INTO nuj_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ebisolo ebyengira emeeri byali ehisinde nʼehihasi ebya hiisi hiha ngʼolu Hatonda gamulagira. Nga Musengwa ahena amwigalira mugati. ");
INSERT INTO nuj_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ohuhenera erala endaalo amahumi ane, amataba geyongera hu hyalo era amaaji geyongera ohuniina gadunda emeeri ohuŋwa hwiroba. ");
INSERT INTO nuj_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Amaaji geeyongera bugali hu hyalo, emeeri niyo ni yiseeyeeya huseeyeeya hu mugulu wʼamaaji. ");
INSERT INTO nuj_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Era amaaji geeyongeranga hweyongera bugali weene hu hyalo goola ohumiraho esozi endeeŋi josijosi ŋaasi wʼeryuba. ");
INSERT INTO nuj_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ni geeyongera obungi, gamiraho esozi endeeŋi nʼohuhiraho efuuti amahumi abiri. ");
INSERT INTO nuj_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Hiisi hitonde hu hyalo hyafa: enyuni nʼebyayo nʼesolo ejomwisugu ko nʼabaatu bosibosi. ");
INSERT INTO nuj_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Hiisi hiitu hu hyalo ehiri nʼomuuya ogwʼobulamu hyafa. ");
INSERT INTO nuj_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Mu ngeri eyo, Musengwa gasihiirisa hiisi hiitu ehiramu ehyali hu hyalo: abaatu nʼesolo nʼenyuni. Era owaŋonaho gaali nje Nuwa yeŋene ko ni naabo aba gaali ni nabo mu meeri. ");
INSERT INTO nuj_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Amataba gaahena hu hyalo endaalo cikumi nʼataanu. ");
INSERT INTO nuj_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Hatonda sigerabira Nuwa nʼebisolo byosibyosi ebi gaali ni nabyo mu meeri. Olwʼehyo, gaŋindiha embeŋo yafuuŋa hu hyalo ngʼamaaji gahendera. ");
INSERT INTO nuj_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Mu hiseera ehyo, esulo hu hyalo jegalira ndijitusa maaji nʼegulu lyosi lyaleheraŋo ohujofumuha. ");
INSERT INTO nuj_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Amaaji geyongera ohuhendeera hu hyalo mu ndaalo cikumi mwataanu. ");
INSERT INTO nuj_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Mu ndaalo ejo, mu mwesi ogwomusanvu hu ludaalo olwʼehumi namusanvu, emeeri yihala hu lusozi Ararati. ");
INSERT INTO nuj_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Amaaji hu hyalo geeyongera ohuhenderera erala era nga lulala omwesi ogwʼehumi esozi jaali jitandihire ohubonehahuho. ");
INSERT INTO nuj_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ngʼoluvanyuma lwʼendaalo amahumi ane, Nuwa gegulaŋo edinisa lyʼemeeri. ");
INSERT INTO nuj_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ngʼaŋamba nahinywamalwa amutusa ewulafu. Ni gatula, ngʼaguluha atiina era pogaagama ni getoloola hiisi ŋaatu ohwola olu maaji gomeera hu hyalo. ");
INSERT INTO nuj_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ngʼaŋo aŋindiha eŋuusi litiine libone obanga amaaji gomeeye hu hyalo. ");
INSERT INTO nuj_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Aye siryabona ŋa hugwa olwohuba ehyalo hyali hihiiri maaji mereere. Olwʼehyo, lyagamayo nga Nuwa atusa omuhono aliŋamba alingisa mu meeri. ");
INSERT INTO nuj_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ni ŋabitaŋo endaalo musanvu, nga nindi aliŋindiha ohuŋwa mu meeri litiine libone oba amaaji gomeeye. ");
INSERT INTO nuj_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Eŋuusi lyagamayo ehyʼegulo nʼahahoola ahabisi ahʼomusaala omuzayiti mu hanwa! Ngʼaŋo Nuwa ategeera ati amaaji gomeeye hu hyalo. ");
INSERT INTO nuj_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Nga nindi abisyaŋo endaalo musanvu aŋindiha eŋuusi, aye ni lyatiina, siryagobola. ");
INSERT INTO nuj_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Hu ludaalo oludaayi olwʼomwesi omudaayi, Nuwa ni gaali nʼaŋesa emyaha lukaaga namulala, amaaji gaali gomeeye hu hyalo. Hu ludaalo olwo, gawihulaho ehitundu hya hasolya hʼemeeri ngʼalengeesa ebulafu ngʼabona amaaji ni gomeeye. ");
INSERT INTO nuj_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Mu mwesi ogwohubiri ngʼabiri namusanvu, ehyalo hyali hyomeeye erala. ");
INSERT INTO nuj_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ngʼaŋo Hatonda aloma Nuwa ati, ");
INSERT INTO nuj_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ŋaahani ewe nʼomuhasi wuwo nʼabasaani babo ko nʼabahasi baawe, mutule mu meeri. ");
INSERT INTO nuj_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Tusa hiisi hitonde ehibaaye ni hiri ni neewe mu meeri: enyuni nʼebisolo era hiisi hitonde ehigendera hwiroba, bisaale byale biŋere hu hyalo.” ");
INSERT INTO nuj_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nga Nuwa nʼomuhasi wuwe nʼabasaani babe ko nʼabahasi baawe batula mu meeri. ");
INSERT INTO nuj_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ebisolo byosibyosi ko nʼebitonde ebindi ebigendera hwiroba byosibyosi nʼenyuni josijosi, hiisi hitonde ehiri hu hyalo ehya hiisi hiha hyatula mu meeri. ");
INSERT INTO nuj_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ngʼaŋo Nuwa atongolera Musengwa ehituuti ohuŋeeraho eŋongo ngʼaŋamba hiisi hiha hyʼehisolo nʼenyuni enongoofu, abiŋonga ebyohye biguhuliha hu hituuti ohwo. ");
INSERT INTO nuj_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Nga Musengwa aŋunyira olusyololo aloma mu mwoyo gugwe ati, “Sinja huŋwaba hyalo nindi olwʼomuutu wayire hiisi ehi aŋeega hibi ohuŋwa mu buŋere buwe. Era sinja husihiirisa ebitonde nʼamataba ngʼolu nabisihiirisa. ");
INSERT INTO nuj_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Ehyalo ni hihiriŋo, ohuhoma nʼohuhungula ebirime, ebiseera byʼefula ko nʼebyendobooli, omuusi nʼowiire, sibija huhoma.” ");
INSERT INTO nuj_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Nga Hatonda aŋa Nuwa nʼabasaani babe ekabi aloma ati, “Musaale mwale era mweyongere mwijule ehyalo. ");
INSERT INTO nuj_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Esolo josijosi nʼenyuni nʼenyeeni mu nyanja ko nʼebitonde ebindi byosibyosi ebigendera hwiroba, binabatyenga. Era byosibyosi mbibaŋaaye ohuba ŋaasi wenywe, mu biŋuge. ");
INSERT INTO nuj_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Mbaŋaaye hiisi hiitu ehiramu ehigenda ohuba mere yenywe. Ngʼolu nabaŋa ebimera, mbaŋa hiisi hiitu. ");
INSERT INTO nuj_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Aye simulyanga enyama ehiirimo amafugi olwohuba obulamu buli mu mafugi. ");
INSERT INTO nuj_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Era nja huvunaananga omuutu owiita owahye. Era nja huvunaana esolo eyiita omuutu nʼomuutu owiita owahye. ");
INSERT INTO nuj_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Hatonda gawumba omuutu mu hifaananyi hihye. Olwʼehyo, hiisi owiita owahye, yeesi baja humwitanga. ");
INSERT INTO nuj_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Musaale mwale era mweyongere hu hyalo.” ");
INSERT INTO nuj_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ngʼaŋo Hatonda aloma Nuwa nʼabasaani babe ati, ");
INSERT INTO nuj_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Kola endagaano yange ni nenywe nʼolulyo lwenywe, ");
INSERT INTO nuj_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","nga muweene omwo pomuli hiisi hitonde: enyuni nʼebyayo nʼesolo ejomwisugu, ejo josijosi eji obaaye nʼoli ni najo mu meeri, ebitonde byosibyosi hu hyalo. ");
INSERT INTO nuj_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Kola endagaano yange ni nenywe. Sinja husihiirisa hyalo nʼamataba nindi oba ohusihiirisa ebiitu hu hyalo.” ");
INSERT INTO nuj_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Nga Hatonda aloma Nuwa ati, “Hano njʼahaja ohuba ahabonero ahʼendagaano ŋagati wange ni neewe ko nʼebitonde byosibyosi, endagaano eyʼemirembe nʼemirembe: ");
INSERT INTO nuj_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","taaye olufudu lwange hu bireri era luja huba habonero ahʼendagaano yange eyi ndageene ni neewe nʼehyalo hyosihyosi. ");
INSERT INTO nuj_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Olu naleetenga ebireri hwigulu byawiiha ehyalo, olufudu lwaboneha hu bireri, ");
INSERT INTO nuj_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","nja huhebuliranga endagaano yange eyi kolire ni nenywe nʼebitonde byosibyosi ebya hiisi hiha. Sinja husihiirisa hyalo nʼamataba nindi. ");
INSERT INTO nuj_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Hiisi olu lufudu lunajenga hu bireri, nja hulubonanga nga kebulira endagaano yange eyʼemirembe nʼemirembe eyiri ŋagati wange nʼebitonde byosibyosi ebya hiisi hiha hu hyalo.” ");
INSERT INTO nuj_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Nga Hatonda aloma Nuwa ati, “Aho njʼahabonero hʼendagaano ŋagati wange nʼebitonde byosibyosi hu hyalo.” ");
INSERT INTO nuj_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Abasaani ba Nuwa abaaŋwa mu meeri baali Seemu ni Kaamu ko ni Yafeesi. Era Kaamu njʼowaali semwana ya Kanani. ");
INSERT INTO nuj_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Abo bondatu njʼabaali abasaani ba Nuwa era mu bo pomwaŋwa abaatu abeejula ehyalo. ");
INSERT INTO nuj_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuwa gaali mulimi era njʼowatandiha ohulima emizabbibbu. ");
INSERT INTO nuj_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Lulala, ganywa hu mwenge ogwomu mizabbibbu, gameera ngʼaŋenyuha mu weema nʼali wereere. ");
INSERT INTO nuj_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kaamu semwana ya Kanani, gabona semwana nʼali wereere ngʼatiina alomeraho abaganda babe bombi abaali ewulafu wʼeweema. ");
INSERT INTO nuj_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Aye Seemu ni Yafeesi baŋamba olugoye balwanjulusa balulerejesa ni baluŋambiiye hu mabega gaawe batiina hinyuma nyuma baludanya hu saawe. Era bamuwiiha ni batamuhejireho hubona wereere wuwe. ");
INSERT INTO nuj_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Omwenge ni gwaŋwa hu Nuwa, gategeera ehi omusaani oyo omuŋere amuholire ");
INSERT INTO nuj_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","galoma ati, “Ehiraamo hibe hu Kanani! Era eyiri abaganda babe, anaabenga mwidu asinga ohuba owa ŋaasi.” ");
INSERT INTO nuj_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Era galoma ati, “Gebasiwe Musengwa Hatonda wa Seemu! Era Kanani afuuhe mwidu wa Seemu. ");
INSERT INTO nuj_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Hatonda agalamye omuŋuluko gwa Yafeesi. Yafeesi amenye mu weema ja Seemu. Era Kanani afuuhe mwidu wuwe.” ");
INSERT INTO nuj_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Oluvanyuma lwa mataba, Nuwa gahena emyaha bisatu mwataanu. ");
INSERT INTO nuj_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ŋosiŋosi, Nuwa gahena emyaha lwenda nʼataanu, ngʼafa. ");
INSERT INTO nuj_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Bino njʼebiŋamba hu Seemu ni Kaamu ko ni Yafeesi abasaani ba Nuwa, boosi basaala abaana oluvanyuma lwʼamataba. ");
INSERT INTO nuj_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Abasaani ba Yafeesi baali nje Gomeri ni Magogi ni Madayi ni Yovaani ni Tubbali ni Meseki ko ni Tirasi. ");
INSERT INTO nuj_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Abasaani ba Gomeri baali njʼAsukenaazi ni Lifaasi ko ni Togaluma. ");
INSERT INTO nuj_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Abasaani ba Yovaani baali njʼElisa ni Talusiisi ni Kitimu ko ni Dodanimu. ");
INSERT INTO nuj_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Mu basaani abo njʼomwaŋwa abaatu abamenyanga mu matwale hu bizinga, hiisi baatu nʼolulimi lwawe mu biha nomu mawanga gaawe. ");
INSERT INTO nuj_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Abasaani ba Kaamu, baali nje Kuusi ni Mizulayimu ni Puuti ko ni Kanani. ");
INSERT INTO nuj_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Abasaani ba Kuusi, baali nje Seebba ni Kavira ni Sabbuta ni Laama ko ni Sabbuteka. Abasaani ba Laama, baali nje Seebba ko ni Dedani. ");
INSERT INTO nuj_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuusi gasaala Nimuloodi era Nimuloodi oyo njʼowasooka ohuba omusooli owʼamaani hu hyalo huno. ");
INSERT INTO nuj_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Era gaali muŋiimi hu lwʼamaani ga Musengwa. Cʼehifa hiromwa hiiti, “Hya Nimuloodi omuŋiimi owʼamaani olwʼamaani ga Musengwa.” ");
INSERT INTO nuj_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Mu husooka, owahabaha buwe waali mu hyalo hyʼe Sinali ni buŋiriramo ebibuga Bbabberi nʼEreeki nʼAkudi ko ni Kalune. ");
INSERT INTO nuj_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ohuŋwa mu hyalo hyʼe Sinali, gatiina e Busuuli ngʼatongola Nineeve ni Lekobbosi Yira ni Kala ");
INSERT INTO nuj_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ko ni Leseni ŋagati wa Nineeve ni Kala ehibuga ehibbala. ");
INSERT INTO nuj_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizulayimu gaali semwana ya Ludimu nʼAnamimu ni Lekabbimu ni Nafutukimu ");
INSERT INTO nuj_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ni Pasulusimu ni Kafutooli ni Kasulukimu, omu Bafirisuuti baasibuha. ");
INSERT INTO nuj_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanani gaali semwana ya Sidoni omudaayi wuwe, ni Keesi ");
INSERT INTO nuj_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","nʼAbayebbusi nʼAbamooli nʼAbagirugaasi ");
INSERT INTO nuj_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","nʼAbahiivi nʼAbaluki nʼAbasiini ");
INSERT INTO nuj_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","nʼAbaluvada nʼAbazemali nʼAbahamasi. Oluvanyuma, ebiha ebyʼAbakanani nga bisasaana. ");
INSERT INTO nuj_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Era esalo eyʼAbakanani yaŋwa e Sidoni ohutiina e Gerali nga yoola e Gaaza nindi nga yitiina e Sodoma ni Gomora nʼAduma ni Zebboyiimu paka e Laasa. ");
INSERT INTO nuj_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Abo njʼabasaani ba Kaamu mu biha byawe nomu lulimi lwawe nomu matwale gaawe era nʼegwanga lyawe. ");
INSERT INTO nuj_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Era ni Seemu yeesi gasaala abaana. Muhulu ya Seemu gaali nje Yafeesi. Seemu gaali nje sehulu yʼabasaani bʼEbberi bosibosi. ");
INSERT INTO nuj_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Abasaani ba Seemu baali nje Elamu nʼAsuuli nʼAlupakusaadi ni Luudi ko nʼAlaamu. ");
INSERT INTO nuj_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Abasaani bʼAlaamu baali nje Wuuzi ni Kuuli ni Geseri ko ni Miseki. ");
INSERT INTO nuj_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Ngʼaŋo Alupakusaadi asaala Seera nga Seera asaala Ebberi. ");
INSERT INTO nuj_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","NgʼEbberi asaala abaseere babiri. Mulala hu bo gaali nje Peleegi olwohuba mu ndaalo jije, abaatu basasaana. Mugandawe gaali nje Yokutaani. ");
INSERT INTO nuj_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Nga Yokutaani asaala Alumodaadi ni Serefu ni Hazalumaveesi ni Yera ");
INSERT INTO nuj_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ni Kadolaamu ni Wuzali ni Dikila ");
INSERT INTO nuj_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","nʼObbali nʼAbbimayeeri ni Seebba ");
INSERT INTO nuj_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","nʼOfiri ni Kavira ko ni Yobbabbu. Abo bosibosi baali basaani ba Yokutaani. ");
INSERT INTO nuj_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Etwale omu bamenyanga lyaŋwanga e Mesa lyatiina e Sefari mu hyalo ehyʼesozi, ebuŋwalyuba. ");
INSERT INTO nuj_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Abo njʼabasaani ba Seemu mu biha byawe nomu lulimi lwawe nomu matwale gaawe era nʼegwanga lyawe. ");
INSERT INTO nuj_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ebyo njʼebiha byʼabasaani ba Nuwa, hiisi muutu ngʼolu lulyo lulwe lwali mu mawanga gaawe. Era mu bo pomwaŋwa amawanga agasasaana ehyalo hyosihyosi oluvanyuma lwʼamataba. ");
INSERT INTO nuj_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Halehale, abaatu bosibosi hu hyalo balomanga olulimi lulala. ");
INSERT INTO nuj_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ehiseera hyola nga basenguha ni bendula aŋohumenya, baŋwa ebuŋwalyuba boola mu hyalo ehiduleere e Sinali nga bamenya eyo. ");
INSERT INTO nuj_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Lulala behobana baati, “Bahyange, huhubbe amatafaali hugoohye bulaŋi weene.” Era mu hiseera ehyo, baali batambisa amatafaali mu hifo hyʼamabaale, ni kolansi mu hifo hyʼomujehe. ");
INSERT INTO nuj_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Nga baloma baati, “Muhole hutongole ehibuga ehiri nʼomunaala ogwola mwigulu hweholere esiina. Ehyo hija hutuyeeda ohutasalanihira mu hyalo.” ");
INSERT INTO nuj_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Aye nga Musengwa geeha ohuŋwa mwigulu ohubona ebibuga nʼomunaala ebi baali ni batongola. ");
INSERT INTO nuj_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ngʼaloma ati, “Abaatu bano bali bulala era bʼolulimi lulala. Ngʼolu batandihire ohuhola ehyo, ŋaŋuma ehibategehire ohuhola ehija ohubahaya. ");
INSERT INTO nuj_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Muuje hwihe eyi bali hutabujule olulimi lwawe hiisi muutu atategeera ebi wahye aloma.” ");
INSERT INTO nuj_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Olwʼehyo, Musengwa gatiina ngʼabasalaania hu hyalo hyosihyosi nga baleheraŋo ohutongola ehibuga. ");
INSERT INTO nuj_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Cʼehifa ehifo ehyo bahiranga baati Bbabberi, olwohuba eyo peyi Musengwa gatabujula olulimi lwʼabaatu hu hyalo. Ngʼahena abasalaania mu hyalo hyosihyosi. ");
INSERT INTO nuj_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Bino njʼebiŋamba hu Seemu: Emyaha ebiri oluvanyuma lwʼamataba, Seemu ni gaali nʼaŋesa emyaha cikumi, gasaala Alupakusaadi. ");
INSERT INTO nuj_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Oluvanyuma lwʼohusaala Alupakusaadi, Seemu gahena emyaha bitaanu, ngʼasaala abaana abandi abaseere nʼabahaana. ");
INSERT INTO nuj_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Alupakusaadi ni gahena emyaha adatu nʼetaanu, gasaala Seera. ");
INSERT INTO nuj_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Oluvanyuma lwʼAlupakusaadi ohusaala Seera, gahena emyaha bine nʼadatu, ngʼasaala abaana abandi abaseere nʼabahaana. ");
INSERT INTO nuj_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Nga Seera ahena emyaha adatu, ngʼasaala Ebberi. ");
INSERT INTO nuj_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Oluvanyuma lwʼohusaala Ebberi, Seera gahena emyaha bine nʼadatu ngʼasaala abaana abandi abaseere nʼabahaana. ");
INSERT INTO nuj_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebberi ni gahena emyaha adatu neene gasaala Peleegi. ");
INSERT INTO nuj_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Oluvanyuma lwʼohusaala Peleegi, ngʼEbberi ahena emyaha bine nʼadatu ngʼasaala abaana abandi abaseere nʼabahaana. ");
INSERT INTO nuj_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleegi ni gahena emyaha adatu, gasaala Reewu. ");
INSERT INTO nuj_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Oluvanyuma lwʼohusaala Reewu, Peleegi gahena emyaha bibiri namwenda ngʼasaala abaana abandi abaseere nʼabahaana. ");
INSERT INTO nuj_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reewu ni gahena emyaha adatu nʼebiri gasaala Serugi. ");
INSERT INTO nuj_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Oluvanyuma lwʼohusaala Serugi, Reewu gahena emyaha bibiri namusanvu ngʼasaala abaana abandi abaseere nʼabahaana. ");
INSERT INTO nuj_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugi ni gahena emyaha adatu gasaala Naholi. ");
INSERT INTO nuj_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Oluvanyuma lwʼohusaala Naholi, Serugi gahena emyaha bibiri ngʼasaala abaana abandi abaseere nʼabahaana. ");
INSERT INTO nuj_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naholi ni gahena emyaha abiri namwenda, gasaala Teera. ");
INSERT INTO nuj_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Oluvanyuma lwʼohusaala Teera, Naholi gahena emyaha cikumi nʼehumi namwenda ngʼasaala abaana abandi abaseere nʼabahaana. ");
INSERT INTO nuj_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Oluvanyuma lwa Teera ohuhena emyaha sanvu, gasaala Yibbulaamu ni Naholi ko ni Harani. ");
INSERT INTO nuj_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Bino njʼebiŋamba hu Teera: Teera gasaala Yibbulaamu ni Naholi ko ni Harani. Nga Harani asaala Luuti. ");
INSERT INTO nuj_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Saawe Teera ni gaali nʼahiiri mulamu, nga Harani afiira e Wuuli ehyalo hyʼAbakaludaaya omu bamusaalira. ");
INSERT INTO nuj_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ngʼaŋo Yibbulaamu ni Naholi baleeta abahasi. Omuhasi wa Yibbulaamu gaali nje Salaayi, omuhasi wa Naholi gaali nje Mirika omuhaana wa Harani. Harani gaali nʼabahaana babiri: Mirika ko ni Yisika. ");
INSERT INTO nuj_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Salaayi gaali mugumba. ");
INSERT INTO nuj_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Nga Teera aŋamba Yibbulaamu omusaani wuwe ni Salaayi omulya wuwe ko nʼomwijuhulu wuwe Luuti omwana wa Harani baŋwa e Wuuli ehyalo hyʼAbakaludaaya batiina mu hyalo hyʼe Kanani. Ne ni boola e Harani, nga bamenya eyo. ");
INSERT INTO nuj_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Teera gahena emyaha bibiri nʼetaanu ngʼafiira eyo e Harani. ");
INSERT INTO nuj_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Lulala Musengwa galoma Yibbulaamu ati, “Ŋwa mu gwanga liryo nomu hiha hihyo ko nomu hidaala hya lataawo otiine mu hyalo ehi nahahulage. ");
INSERT INTO nuj_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Nja huhufuula egwanga eryʼamaani era nja huhuŋa ekabi, nja huhufuula omuutu owʼeŋono era abandi baja husuna ekabi olwʼewe. ");
INSERT INTO nuj_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nja huŋa ekabi abo abahuŋa ekabi era nja huŋwaba oyo ahuŋwaba era abaatu bosibosi hu hyalo baja husuna ekabi ni babita mu ewe.” ");
INSERT INTO nuj_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Olwʼehyo Yibbulaamu gaŋwa e Harani gaŋamba engira gatiina ngʼolu Musengwa gamuloma. Era Luuti yeesi gatiina ni naye. Yibbulaamu gaali ali nʼemyaha sanvu nʼetaanu aŋa gaŋwera e Harani. ");
INSERT INTO nuj_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Nga Yibbulaamu aŋamba engira atiina ni Salaayi omuhasi wuwe nʼebiitu byawe byosibyosi ebi baali ni nabyo. Batiina ni Luuti omusaani wa mugandawe nʼabeedu babe aba gasuna nʼali e Harani. Baŋamba engira batiina mu gwanga lyʼe Kanani era nga boola. ");
INSERT INTO nuj_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Yibbulaamu nʼabaatu aba gaali ni nabo bagenda mu gwanga eryo nga boola mu hifo ehi balanga baati Sekemu, aŋaali omutumba omubba ogwa Moole. Mu hiseera ehyo, Abakanani baali bamenya mu gwanga eryo. ");
INSERT INTO nuj_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ngʼaŋo Musengwa abonehera Yibbulaamu amuloma ati, “Nja huŋa olusaaye lulwo ehyalo hino.” Nga Yibbulaamu atongolera Musengwa owamubonehera ehituuti ehyohuŋeeraho eŋongo mu hifo ehyo. ");
INSERT INTO nuj_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Yibbulaamu gaŋwa aŋo gatiina mu hyalo ehyʼesozi ehiri ebuŋwalyuba wʼe Bbeseeri ngʼahomeha eyo eweema yiye. Bbeseeri hyali hu lubega lwʼebugwalyuba, Ayi ni hiri hu lubega lwʼebuŋwalyuba. Ngʼatongolera Musengwa ehituuti ehyʼohumuŋeeraho eŋongo mu hifo ehyo, ngʼamujumiryanga. ");
INSERT INTO nuj_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ehiseera hyola nga Yibbulaamu geyongera ohugenda nʼatiina mu twale lyʼe Negevu. ");
INSERT INTO nuj_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Enjala yagwa mu hyalo hyʼe Kanani nga Yibbulaamu nʼomuhasi wuwe behirira batiina e Misiri ohubaaho eyo olwohuba enjala yaali mbitiirifu. ");
INSERT INTO nuj_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ni baali huupi ohwola e Misiri, Yibbulaamu galoma Salaayi omuhasi wuwe ati, “Wange ese manyire ti oli muhasi muŋoono. ");
INSERT INTO nuj_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Era abaatu bʼe Misiri ni baja huhubona, baaja humanya baati oli muhasi wange. Ehyo, hiija hupweramo ohunjita, bahwegoboseho. ");
INSERT INTO nuj_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Olwʼehyo olomanga oti oli mboojo yange, hamunga bambisya bulaŋi naŋonia obulamu wange olwʼewe ohuloma otyo.” ");
INSERT INTO nuj_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Yibbulaamu ni goola e Misiri, Abamisiri babona Salaayi nʼali muhasi omuŋoono bugali. ");
INSERT INTO nuj_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Abahungu ba Falaawo ni baheja hu Salaayi, batiina nga bamupaaha eyiri Falaawo ngʼolu ali muhasi muŋoono. Era bamuŋira mu lubiri lwa Falaawo. ");
INSERT INTO nuj_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Falaawo gabisya Yibbulaamu bulaŋi hulwa Salaayi. Ngʼaŋa Yibbulaamu etaama nʼeŋombe nʼengamiya esinde nʼekasi ni nasugirya ko nʼabeedu abahasi nʼabasinde. ");
INSERT INTO nuj_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ne Musengwa galeetera Falaawo nʼamago gage ohulwala olwa Salaayi muha Yibbulaamu. ");
INSERT INTO nuj_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Olwʼehyo, Falaawo galanga Yibbulaamu gamuloma ati, “Hiina hino ehyo ehi waakola? Lwahiina siwandomera oti Salaayi muhasi wuwo? ");
INSERT INTO nuj_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Lwahiina waloma oti Salaayi mboojoyo? Olwʼohuloma otyo, cʼehyagira namuŋira ni nenda abe muhasi wange. Kale omuhasi wuwo njʼoyo, mutiine.” ");
INSERT INTO nuj_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ngʼaŋo Falaawo alagira abahungu babe babbinge Yibbulaamu nʼomuhasi wuwe nʼebiitu bibye byosibyosi ebi gaali ni nabyo, aŋwe mu gwanga lyʼe Misiri. ");
INSERT INTO nuj_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ngʼaŋo Yibbulaamu aŋwa e Misiri aniinaniina nʼomuhasi wuwe nʼebiitu bibye byosibyosi ebi gaali ni nabyo, atiina mu lulafu lwʼe Negevu. Era Luuti gatiina ni naye. ");
INSERT INTO nuj_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Yibbulaamu gaali nʼobuŋinda bungi owʼebyayo nʼefeeza ko nʼezaabbu. ");
INSERT INTO nuj_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ni gaŋwa e Negevu gatiinanga nʼasega ŋano ni naŋala ohwola olu goola e Bbeseeri, ehifo ehiri ŋagati wa Bbeseeri ni Ayi aŋa gaali nʼahomehire eweema yiye oludaayi. ");
INSERT INTO nuj_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Mu hifo ehyo pomu Yibbulaamu gaali nʼatongoye ehituuti ehyohuŋeeraho eŋongo era aŋo paŋa gajumirihisyanga Musengwa. ");
INSERT INTO nuj_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ŋaahani Luuti yeesi gaali nʼetaama nʼembusi nʼeŋombe ko nʼabeedu. ");
INSERT INTO nuj_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Kale olwʼobungi wʼebyayo ebi Yibbulaamu ni Luuti baali ni nabyo, baŋuma ŋa hwayira aŋahena. Olwʼehyo baali sibasobola humenya ŋalala. ");
INSERT INTO nuj_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Era nga ŋabaŋo obuyoga ŋagati wʼabaayi ba Yibbulaamu nʼaba Luuti. Mu hiseera ehyo, Abakanani nʼAbapereezi boosi baali bamenya mu gwanga eryo. ");
INSERT INTO nuj_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Nga Yibbulaamu aloma Luuti ati, “Sihiraŋi ohuba nʼobuyoga ŋagati weefe oba ŋagati wʼabaayi bange nʼababo olwohuba huli balebe. ");
INSERT INTO nuj_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ehyalo hibbala, osobola ohusalaŋo ŋeena aŋa wenda ohumenya. Olwʼehyo, hwawuhane era ewe onatiina hu lubega lwʼomuhono omugooda, ese nja hutiina hu mulungi. Onatiina hu mulungi, ese nja huŋamba engira tiine hu mugooda.” ");
INSERT INTO nuj_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Nga Luuti agangamusa emoni alengera eroba egimu mu hifo ehiduleere ohuupi nʼolwabi Yoludaani ni mulimo amaaji agahena hyomu Edeni endimiro ya Musengwa, hyomu hyalo hyʼe Misiri nʼolengereeye olwʼe Zowaali. Luuti gaasiima ehifo ehyo. Mu hiseera ehyo, Musengwa gaali ahiiri husihiirisa Sodoma ni Gomora. ");
INSERT INTO nuj_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Nga Luuti gesaliraŋo ohuŋira eroba egimu mu hifo ehiduleere ohuupi nʼolwabi Yoludaani. Era Luuti gaŋamba engira gafuluha ngʼatiina ebuŋwalyuba. Kale nga bawuhana baatyo. ");
INSERT INTO nuj_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Yibbulaamu niye gamenya mu hyalo hyʼe Kanani ne Luuti gatiina gamenya ŋaapi nʼehibuga mu hifo ehiduleere ehyʼe Sodoma. ");
INSERT INTO nuj_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Aye abaatu bʼe Sodoma baali babbengi era ni bahola ebibi ebya hiisi ngeri mu moni ja Musengwa. ");
INSERT INTO nuj_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Luuti nʼahenire ohusenguha, Musengwa galoma Yibbulaamu ati, “Gangamusa emoni oheje mu maniino nomu mehiriro, ohene oheje ebuŋwalyuba nʼebugwalyuba. ");
INSERT INTO nuj_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ewe nʼabejuhulu babo, nja hubaŋa ehyalo ehyo, hibe hyenywe emirembe nʼemirembe. ");
INSERT INTO nuj_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Abejuhulu babo nja hubafuula bangi ni batabaliha hyʼomujehe. Era singa omuutu asobola ohubala omujehe, aja husobola nʼohubala abejuhulu babo. ");
INSERT INTO nuj_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Tiina ogende nʼolambuula obugalamu nʼobuleeŋi wʼehyalo ehi ndi huhuŋa.” ");
INSERT INTO nuj_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ngʼaŋo Yibbulaamu adunda eweema jije afulusa amago atiina amenya e Kebbulooni aŋaapi nʼemitumba jʼe Mamule. Ngʼatongolera Musengwa ehituuti ehyohuŋeeraho eŋongo mu hifo ehyo. ");
INSERT INTO nuj_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Mu hiseera ehyo, Amulafeeri habaha wʼe Sinali ni Ariyooki habaha wʼErasaali ni Kedolawomeeri habaha wʼElamu ni Tidali habaha wʼe Goyiimu, ");
INSERT INTO nuj_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","basoola ni Bbeera habaha wʼe Sodoma ni Bbiruusa habaha wʼe Gomora ni Sinaabbu habaha wʼAduma ni Semebbeeri habaha wʼe Zebboyiimu ko ni habaha wʼe Bbeera (oba Zowaali). ");
INSERT INTO nuj_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Abahabaha abataanu bosibosi beŋimba, basoosa bala abane mu hiiho eri balanga baati Sidimu oba erungu lyʼEnyanja Eŋumamo Ehiramu. ");
INSERT INTO nuj_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Baali bahenire emyaha ehumi nʼebiri ni bali ŋaasi wa habaha Kedolawomeeri. Nga mu mwaha ogwʼehumi nedatu bamujeemera. ");
INSERT INTO nuj_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mu mwaha ogwʼehumi nʼene, Kedolawomeeri nʼabahabaha bala abadatu, batiina basoosa abahabaha abataanu nga baŋangula Abareefa mu Asuterosi Kalumayimu nʼAbazuuzi e Kaamu nʼAbbeemi e Saave Kiriyasayimu ");
INSERT INTO nuj_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ko nʼAbakooli e Seyiri mu hyalo ehyʼesozi. Nga bababbinga baboosa Elupalaani huupi nʼolulafu. ");
INSERT INTO nuj_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ni bahena, bagamayo Eni Misapaati (oba e Kadesi), nga baŋangula abaatu bomu twale lyʼAbameleki lyosiryosi era bahubba nʼAbamooli abaali ni bamenya e Kazazoni Tamali. ");
INSERT INTO nuj_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Oluvanyuma lwa bahabaha bala abane ohuŋangula, balumba abahabaha bala abataanu. Nga habaha wʼe Sodoma ni habaha wʼe Gomora ni habaha wʼAduma ni habaha wʼe Zebboyiimu ni habaha wʼe Bbeera oba Zowaali, batiina mu hiiho hyʼe Sidimu ohusoosa ");
INSERT INTO nuj_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Kedolawomeeri habaha wʼElamu ni Tidali habaha wʼe Goyiimu nʼAmulafeeri habaha wʼe Sinali ko ni Ariyooki habaha wʼErasaali. Baali abahabaha bane ni basoosa abahabaha bataanu. ");
INSERT INTO nuj_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ehiiho hyʼe Sidimu hyali hyejuuye amaloŋo ga kolaasi era abahabaha bʼe Sodoma ni Gomora ni badulumanga nga bagwamo, abandi nga badulumira mu hyalo ehyʼesozi. ");
INSERT INTO nuj_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ngʼabahabaha abane abo, banyaga ebiitu byosibyosi mu Sodoma ni Gomora nʼebyohulya byosibyosi nga bahena betiinira. ");
INSERT INTO nuj_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Era baŋiriramo ni Luuti omusaani wa muganda ya Yibbulaamu nʼebiitu bibye olwohuba gaali amenyire e Sodoma. ");
INSERT INTO nuj_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Mulala hu bakabonawo, gatiina ngʼalomera Yibbulaamu Omubbebbulaniya ati Luuti yeesi gaali alutiiniyemo. Yibbulaamu gaali amenyire huupi nʼemitumba ja Mamule Omwamooli, muganda yʼEsukoli ni Aneri. Abadatu abo bosibosi baali bameeri ba Yibbulaamu. ");
INSERT INTO nuj_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Yibbulaamu ni gaŋulira ati baŋiriyeemo ni Luuti omwana wa mugandawe, ngʼayungula eŋe eryʼabaatu bidatu ehumi namunaana aba basaalira mu mago gage era ni bali batendehe. Balonda hu bahabaha abo abane nga babagaana mu hifo ehi balanga baati Daani. ");
INSERT INTO nuj_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Nga mu wiire, Yibbulaamu agabaniamo abasooli babe ohubalumba, nga babahubba bababbinga ohwola e Kobba, ehyʼengulu nʼolengereeye e Damasiko. ");
INSERT INTO nuj_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ngʼagobosa Luuti nʼebiitu bibye byosibyosi nʼabahasi ko nʼabaatu abandi. ");
INSERT INTO nuj_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Oluvanyuma lwa Yibbulaamu ohuŋangula Kedolawomeeri nʼabahabaha abandi, habaha owʼe Sodoma gatiina ohwagaanana ni naye mu hiiho eri balanga baati Saave. Ehiiho ehyo aŋandi bahiranganga baati lwiho lwa habaha. ");
INSERT INTO nuj_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ngʼaŋo Melukezedeki habaha wʼe Saalemu abaŋirira emere nʼomwenge ogwomu mizabbibbu. Melukezedeki gaali musengi wa Hatonda Ali Ŋamugulu Obugali. ");
INSERT INTO nuj_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Nga Melukezedeki aloma ati, “Hatonda Ali Ŋamugulu Obugali, owatonda egulu nʼehyalo, aŋe Yibbulaamu ekabi. ");
INSERT INTO nuj_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Era aŋeewe eŋono Hatonda Ali Ŋamugulu Obugali, ahuŋambiyeho waŋangula abalabe babo.” Ngʼaŋo Yibbulaamu aŋamba hirala ehyʼehumi ehyʼebyo ebi ganyaga, aŋa Melukezedeki. ");
INSERT INTO nuj_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ngʼaŋo habaha wʼe Sodoma aloma Yibbulaamu ati, “Kusunga wuupe abaatu aba ogobohiise aye osigase ebiitu.” ");
INSERT INTO nuj_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ne Yibbulaamu ngʼaloma habaha wʼe Sodoma ati, “Kolire endagaano ni Musengwa Hatonda Ali Ŋamugulu Obugali, owatonda egulu nʼehyalo, ");
INSERT INTO nuj_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ti sinja huŋira hiitu hihyo hyosihyosi wayire ahahoba hʼengayito oba olubuuzi olwohuba ohanda waloma oti, ‘Yibbulaamu gagagaŋalira mu biitu byange.’ ");
INSERT INTO nuj_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ŋaŋuma ehi nja ohuŋira ohutusaho ebi basooli bange baliiye. Aye Aneri ni Esukoli ni Mamule, bali nʼohuŋiraho omugabo olwohuba batiinire ni neese mu lutalo luno.” ");
INSERT INTO nuj_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ebyo ni byaŋwa, nga Musengwa aloma Yibbulaamu mu hwolesewa ati, “Yibbulaamu otatya, ndiise engabo yiyo era nja huhuŋa omuhemba ogwʼamaani.” ");
INSERT INTO nuj_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Aye nga Yibbulaamu amugobolamo ati, “O Musengwa Omwene Buŋangi, ehyo sihija hunjeeda olwohuba mbula mwana, Eliyezeeri ohuŋwa e Damasiko nje aja husikira ebyange.” ");
INSERT INTO nuj_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Nga Yibbulaamu ameedaho ati, “Musengwa, ohiiri huupa hu mwana, Elyeza omwidu wange nje aja ohuba omusika wange.” ");
INSERT INTO nuj_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ngʼaŋo Musengwa aloma Yibbulaamu ati, “Omwidu wuwo oyo, sinje aja ohuba omusika wuwo aye omwana omuseere ohuŋwa mu tumbu jijo, nje aja ohuba omusika wuwo.” ");
INSERT INTO nuj_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ngʼaŋo Musengwa amutusa ebulafu wʼeweema amuloma ati, “Heja ŋamugulu obale emunyeenye ejo hanye osobola. Nʼabejuhulu babo boosi baatyo pobaliba obungi.” ");
INSERT INTO nuj_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Nga Yibbulaamu afugiirira ebi Musengwa gamuloma era ngʼamubala ohuba mugwalaafu. ");
INSERT INTO nuj_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Nga Hatonda nindi amuloma ati, “Ndiise Musengwa owahutusa e Wuuli mu hyalo hyʼAbakaludaaya ohuhuŋa ehyalo hino.” ");
INSERT INTO nuj_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Aye nga Yibbulaamu amuloma ati, “O Musengwa Omwene Buŋangi, nja humanyira hu hi ti nja huŋira ehyalo hino?” ");
INSERT INTO nuj_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Nga Musengwa amuloma ati, “Ndetere eŋombe esodi nʼembusi omulusi ko nʼemiigu, josijosi ni jiri jʼemyaha edatu ohene oleete eŋuusi nʼenjiiwa eperepere.” ");
INSERT INTO nuj_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Nga Yibbulaamu amuŋirira ebiitu ebyo byosibyosi. Ni gahena ohubibaaga ngʼabyaŋulamo ŋabiri ŋabiri. Ni gahena, ngʼatiina nʼapanga ebitundu bya hiisi hyayo ebi gaaŋulamo ni birengereene aye eŋuusi nʼenjiiwa gabireha nʼataŋuuyemo ŋabiri. ");
INSERT INTO nuj_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ngʼesega jiŋwa eyi jaŋwera ni jenda ohulya enyama aye Yibbulaamu ngʼajiŋema. ");
INSERT INTO nuj_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Esaawa ni yaali ni yenda ohugwa mu maaji ngʼero eryʼamaani liŋamba Yibbulaamu. Era ehiirema ehitiisa nga hiba aŋa gaali. ");
INSERT INTO nuj_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ngʼaŋo Musengwa aloma Yibbulaamu ati, “Nenda ohimanye oti abejuhulu babo baja huba babuli mu gwanga eritali lyawe, baliba beedu era baligada ohuhena emyaha bine. ");
INSERT INTO nuj_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Aye nja hugadya abo abalibahosa owiidu. Oluvanyuma abejuhulu babo abo, baliŋwayo nʼebiitu ebyene ebingi. ");
INSERT INTO nuj_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Aye ewe oja hufa nʼoŋangaaye era otiine e magombe eyiri abasehulu babo, miyaaya. ");
INSERT INTO nuj_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Era ni bahenireyo emyaha bine, baligobola ŋano olwohuba ebibi byʼAbamooli bihiiri huŋera ohwola aŋa nja hubabonerehesa, mbatuse mu hyalo muno omu bamenyire.” ");
INSERT INTO nuj_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Esaawa ni yagwa mu maaji era ehiirema hyaŋamba, ehiitu ni hirimo amanda agaduha omuliro nga hibita ŋagati wʼenyama jʼebyayo nʼeŋuusi ko nʼenjiiwa yira. ");
INSERT INTO nuj_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Era hu ludaalo olwo Musengwa gahola endagaano ni Yibbulaamu ati, “Olulyo lulwo nduŋaaye ehyalo hino, ohuŋwa hu lwabi lwʼe Misiri ohwola hu lwabi Yufuleeti, ");
INSERT INTO nuj_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ehyalo omwihaaye Abakeeni nʼAbakenizi nʼAbakadumooni ");
INSERT INTO nuj_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","nʼAbahiiti nʼAbapereezi nʼAbareefa, ");
INSERT INTO nuj_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","nʼAbamooli nʼAbakanani nʼAbagirugaasi ko nʼAbayebbusi.” ");
INSERT INTO nuj_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Mu hiseera ehyo, Salaayi muha Yibbulaamu gaali ahiiri husaalaho mwana. Aye gaali ali nʼomwidu, omuhaana Mumisiri oyu balanganga baati Agali. ");
INSERT INTO nuj_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Nga Salaayi aloma Yibbulaamu ati, “Wange, ngʼolu Musengwa ahiiri huupa hu mwana, ŋenyuha nʼomwidu wange hamunga gaasaalira hu omwana.” Nga Yibbulaamu afugiirira ehi Salaayi gamuloma. ");
INSERT INTO nuj_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Mu hiseera ehyo, baali bahenire emyaha ehumi ni bali mu gwanga lyʼe Kanani. Nga Salaayi aŋamba Agali omuhaana Mumisiri amuŋa wamwe Yibbulaamu ohufuuha muhasi wuwe. ");
INSERT INTO nuj_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Nga Yibbulaamu aŋenyuha nʼAgali era ngʼaba hida. Agali ni gabona nʼali hida, gatandiha ohunyooma musengwawe Salaayi. ");
INSERT INTO nuj_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Nga Salaayi aloma Yibbulaamu ati, “Ndiiwe ogira ni banyooma. Nahuŋa omwidu wange ohuba muhasi wuwo. Ŋaahani gambisyamo emoni olwohuba mbo ali hida. Aye Musengwa omwene asale omusango ŋagati wange ni neewe.” ");
INSERT INTO nuj_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Nga Yibbulaamu amugobolamo ati, “Omwidu wuwo ali ŋaasi wuwo, kale hola ehi onende. Ngʼaŋo Salaayi atandiha ohubisya Agali bubi, ehyaŋwamo ngʼamudulumaho.” ");
INSERT INTO nuj_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Malayika wa Musengwa nga gagaana Agali hu sobere mu lulafu. Esobere eyo yaali hu ngira eyitiina e Suuri. ");
INSERT INTO nuj_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Nga malayika amubuusa ati, “Agali omwidu wa Salaayi, oŋwa ŋeena era oja ŋeena?” NgʼAgali amugobolamo ati, “Ndi huduluma hu Salaayi musengwa yange.” ");
INSERT INTO nuj_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Nga malayika wa Musengwa amuloma ati, “Yagama eyiri musengwawo, omugondere.” ");
INSERT INTO nuj_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Nga malayika wa Musengwa ameedaho ati, “Nja huhuŋa abejuhulu abeene abangi ni batabaliha.” ");
INSERT INTO nuj_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Nga malayika wa Musengwa amuloma ati, “Oli hida era oja husaala omwana museere. Olimuguliha esiina oti Yisimayiri, olwohuba Musengwa amanyire ngʼolu oli hubonaabona. ");
INSERT INTO nuj_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Omwana oyo aja huba wahibbuuli hya nasugirya eyomwisugu, aja huŋiriŋanianga hiisi muutu era hiisi muutu aja humuŋiriŋanianga, aja huba wabulabe eyiri abaganda babe bosibosi.” ");
INSERT INTO nuj_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ngʼaŋo Agali aŋa Musengwa owaloma ni naye esiina ati, “Ndiiwe Hatonda owumbona.” Ehyo gahiroma olwohuba galoma ati, “Mbwene oyo owumbona.” ");
INSERT INTO nuj_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Cʼehyaŋwaho balanga esobere eyo eyiri ŋagati wa Kadesi ni Bberedi baati Bberirakalooyi era esobere eyo ehiriŋo nʼolwa leero luno. ");
INSERT INTO nuj_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ehiseera ni hyola ngʼAgali asaalira Yibbulaamu omwana museere era nga Yibbulaamu amuguliha esiina ati nje Yisimayiri. ");
INSERT INTO nuj_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Yibbulaamu gaali nʼemyaha cinaana namukaaga aŋa Agali gasaalira Yisimayiri. ");
INSERT INTO nuj_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Yibbulaamu ni gaali nʼaŋesa emyaha cenda namwenda, nga Musengwa amubonehera amuloma ati, “Ndiise Hatonda Omwene Buŋangi wosiwosi, nenda bungonderenga era oholenga ebiruŋamu. ");
INSERT INTO nuj_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Nja hunywania endagaano yange ni neewe era nja huhuŋa abejuhulu abeene abangi.” ");
INSERT INTO nuj_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ngʼaŋo Yibbulaamu ahubba amafuha ajumirya Hatonda. Nga Hatonda amuloma ati, ");
INSERT INTO nuj_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Yino njʼendagaano yange ni neewe, oja huba sehulu wʼamawanga. ");
INSERT INTO nuj_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Sibahihulanga baati Yibbulaamu aye ŋaahani ndiiwe Yibbulayimu olwohuba kufuuye sehulu wʼamawanga. ");
INSERT INTO nuj_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nja huhwasa kene kufuule sehulu wʼamawanga mangi. Era bangi abomu mawanga ago baliba bahabaha. ");
INSERT INTO nuj_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Nja huhola endagaano yange eyʼemirembe nʼemirembe ni neewe nʼabejuhulu babo, ohuba Hatonda wuwo era Hatonda waawe. ");
INSERT INTO nuj_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nja huhuŋa ehyalo hino ehyʼe Kanani ehi omenyiremo hyʼomulugendwa hatyane. Nja huhihuŋa, ewe nʼabejuhulu babo ohuba obutaka emirembe nʼemirembe era nja huba Hatonda waawe.” ");
INSERT INTO nuj_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ngʼaŋo Hatonda aloma Yibbulayimu ati, “Buvunanyiziwa wuwo ohuhuuma endagaano yange, ewe nʼabejuhulu babo emirembe nʼemirembe. ");
INSERT INTO nuj_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Endagaano yange ni neewe ko nʼabejuhulu babo eyi bali nʼohuhuuma nje yino: Hiisi musinde mu nywe ali nʼohuhomola. ");
INSERT INTO nuj_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Munahomolenga era haja huba habonero hʼendagaano ŋagati wange ni neewe. ");
INSERT INTO nuj_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Mu hiisi mulembe, omwana nʼanasaaliwenga aja huhenanga endaalo munaana nga bamuhomola. Hino hija huŋambirangamo ababasaalira mu mago gago nʼabamugula hugula ohuŋwa hu banamawanga. ");
INSERT INTO nuj_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Hiisi musinde ali nʼohuhomola, oba gasaaliwa mu mago gago oba wamugula bugule. Aho haja huba habonero ahohu mugulu hu mibiri jenywe, ahanalagenga haati endagaano yange ni nenywe yʼemirembe nʼemirembe. ");
INSERT INTO nuj_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Omuutu yesiyesi agaana ohuhomola, sibanamubalenga ohuba mulala hu baatu bange olwohuba anaabenga abbwagire endagaano yange.” ");
INSERT INTO nuj_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Nga Hatonda aloma Yibbulayimu ati, “Nʼomuhasi wuwo ŋahani sibahimulanga baati Salaayi aye ŋahani nje Saala. ");
INSERT INTO nuj_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nja humuŋa ekabi, mu butuufu nja huhuŋa omwana omuseere ohubita mu ye. Nja humuŋa ekabi, aja huba nyina wʼamawanga era abahabaha baliŋwa mu ye.” ");
INSERT INTO nuj_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Nga Yibbulayimu ahubba amafuha ajumirya Hatonda. Aye mu mwoyo gugwe gejeha galoma ati, “Mu butuufu, hu myaha ecikumi eji ndi ni najo, sobola ohusaala omwana? Mbona ti Saala yeesi gohiise emyaha cenda, ahisaala?” ");
INSERT INTO nuj_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Nga Yibbulayimu aloma Hatonda ati, “Kusunga ekabi ejo ojiŋe Yisimayiri!” ");
INSERT INTO nuj_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Nga Hatonda amugobolamo ati, “Bbe, sihija huba hiityo Saala omuhasi wuwo nje alihusaalira omwana era olimuguliha esiina oti Yisaka. Nja huhola endagaano yange ni naye ko nʼabejuhulu babe eyʼemirembe nʼemirembe. ");
INSERT INTO nuj_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ne puliiye ebi olomire hu Yisimayiri era ngʼolu wusungire, nja humuŋa ekabi era nja humuŋa nʼolusaaye, gaale. Aja huba semwana wʼabaŋugi ehumi nʼababiri era nja humufuula egwanga ebbala. ");
INSERT INTO nuj_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Aye nja huhola endagaano yange ni Yisaka oyu Saala alihusaalira omwaha oguuja mu biseera hya bino.” ");
INSERT INTO nuj_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Hatonda ni gahena ohuloma ni Yibbulayimu, ngʼaŋwaŋo. ");
INSERT INTO nuj_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Nga hu ludaalo olwene olwo Yibbulayimu aŋamba omusaani Yisimayiri ko nʼabasinde bosibosi aba basaalira mu mago gage, ni naabo aba gagula obugule, abahomola ngʼolu Hatonda gamuloma. ");
INSERT INTO nuj_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Yibbulayimu gahomola nʼali hu myaha cenda namwenda, ");
INSERT INTO nuj_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ne omusaani Yisimayiri gaali hu myaha ehumi nedatu. ");
INSERT INTO nuj_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Bombi bahomola hu ludaalo njʼolwene. ");
INSERT INTO nuj_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Era abasinde bosibosi ababasaalira mu mago ga Yibbulayimu ko ni naabo aba gagula obugule, babahomola hu ludaalo olwo ni naye. ");
INSERT INTO nuj_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Lulala, Musengwa gabonehera Yibbulayimu ŋaapi nʼemitumba jʼe Mamule ko ni gaali ni gehaaye ŋa mulyango ogwingira mu weema yiye mu saawa ejomu muusi. ");
INSERT INTO nuj_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Mu hiseera ehyo, Yibbulayimu ni gagangamusa emoni gabona abasinde badatu ni bemire ŋaapi aŋo ni naye. Ni gababona, nga mangumangu genyoha atiina aŋa baali, ahubba amafuha ohulaga ati abaŋa eŋono. ");
INSERT INTO nuj_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ngʼaŋo amuloma ati, “Musengwa, kusunga wupambire ehisa, otabita hubita ŋa wʼomwidu wuwo. ");
INSERT INTO nuj_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Leha baleete amaaji, musaabeho amagulu, muhene muŋuumulireho mu musaala guno. ");
INSERT INTO nuj_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Mbaŋeho nʼehyohulya, mwahagobolamo amaani ko mweyongereyo mu lugendo lwenywe. Mbasunga muganye ngʼolu mwolire ŋa wʼomwidu wenywe.” Ngʼaŋo bamuloma baati, “Ŋaŋuma bubi, hola otyo ngʼolu oteesa.” ");
INSERT INTO nuj_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ngʼaŋo Yibbulayimu aŋitaŋitaho atiina gengira mu weema eyaali Saala omuhasi wuwe, amuloma ati, “Wange husunire abageni, tegehaŋo mangumangu ebideeja bidatu ebyʼobusyanu obulaŋi, obanyiiyireŋo ehyohulya.” ");
INSERT INTO nuj_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Nga Yibbulayimu ganguŋaho atiina mu hidooli, aleeta eŋombe ehitobbwatobbwa ayiŋa omwidu ohuyisala, ayinyiiye mangumangu. ");
INSERT INTO nuj_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ni yanya, nga Yibbulayimu aŋamba omuzigo nʼamabere nʼenyama abiŋira abiiŋula abageni. Ngʼahena atiina gemeerera hu tulo mu musaala aŋaapi naŋa bageni baali ni baliira, abaŋeerese. ");
INSERT INTO nuj_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ni bahena ohulya, nga bamubuusa baati, “Saala omuhasi wuwo ali ŋe?” Ngʼabagobolamo ati, “Aliŋo, ali mu weema.” ");
INSERT INTO nuj_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ngʼaŋo Musengwa aloma Yibbulayimu ati, “Mu butuufu ehiseera hya hino omwaha oguuja aŋa nja hugobolera, Saala omuhasi wuwo aliba asaaye omwana omuseere.” Saala gaali ŋa mulyango gwʼeweema eyi bageni baali ni bahubbire omugongo nʼaŋulira ebyo byosibyosi. ");
INSERT INTO nuj_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Yibbulayimu ni Saala baali basahuluŋire ehibitiriiye era Saala gaali gabisya emyaha ejʼohusaala. ");
INSERT INTO nuj_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Olwʼehyo nga Saala ajeha nʼaloma ati, “Obanga ese nesahuluŋiiye era ni musengwa yange yeesi gesahuluŋiiye, kinyumirwa ebiitu hyʼebyo?” ");
INSERT INTO nuj_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Nga Musengwa aloma Yibbulayimu ati, “Lwahiina Saala ajehire nʼaloma ati, ‘Mu butuufu sobola ohusuna omwana ate nesahuluŋiiye?’ ");
INSERT INTO nuj_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ŋaliŋo ehihaya Musengwa? Nja hugobola mu hiseera hya hino omwaha oguuja, Saala aliba asaaye omwana museere.” ");
INSERT INTO nuj_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Olwʼobuti nga Saala aloma nʼadulinga ati, “Sinjehe bbe.” Aye nga Musengwa amuloma nʼamuhamiirisa ati, “Otegaana, ojehire.” ");
INSERT INTO nuj_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ngʼaŋo abasinde abo benyoha batiina aŋa baali ni basobola ohulengera ehibuga hyʼe Sodoma. Era Yibbulayimu gabaŋereheraho. ");
INSERT INTO nuj_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Nga Musengwa aloma ati, “Sinja huhweha Yibbulayimu ehi nenda ohuhola ");
INSERT INTO nuj_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","olwohuba nja humufuula egwanga ebbala eryʼamaani era amawanga gosigosi hu hyalo gaja husuna ekabi ohubitira mu niye. ");
INSERT INTO nuj_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Mutobooye ohutangirira olulyo lulwe ohuŋamba engira ya Musengwa bahole ebiruŋamu ni batehubbira, noherese ehi namusuubisa.” ");
INSERT INTO nuj_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Nga Musengwa aloma ati, “Ohulira hwʼabaatu hu biŋamba hu Sodoma ni Gomora hubitiirifu era nʼebibi byawe birumya, ");
INSERT INTO nuj_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","nja hutiina mbone oba ebi bahola biŋeraŋerana nʼohulira ohupulira. Ebikolwa byawe binaba ni biri biraŋi, sinja hubasihiirisa.” ");
INSERT INTO nuj_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Abasinde abo, baaŋwaŋo batiina e Sodoma aye Yibbulayimu gasigala nʼahyemire mu moni ja Musengwa. ");
INSERT INTO nuj_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Nga Yibbulayimu gesendaho aŋali Musengwa amuloma ati, “Oja husihiirisa abagwalaafu nʼababbengi ŋalala? ");
INSERT INTO nuj_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ne singa ebaayo abagwalaafu amahumi ataanu mu hibuga hyʼe Sodoma, oja huhisihiirisa? ");
INSERT INTO nuj_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Kusunga otasihiirihisa abagwalaafu ŋalala nʼababbengi, ni ŋaŋumaŋo njabulo ŋagati wʼabagwalaafu nʼababbengi. Ewe Omulamuzi wʼehyalo hyosihyosi, oja hwehubbira?” ");
INSERT INTO nuj_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ngʼaŋo Musengwa aloma Yibbulayimu ati, “Singa ebaayo abagwalaafu ataanu mu hibuga Sodoma, sinja huhisihiirisa hu lwawe.” ");
INSERT INTO nuj_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Nga Yibbulayimu aloma ati, “Onaasoniŋe ohuloma ni Musengwa wayire nga ndi muutu wuutu. ");
INSERT INTO nuj_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ne singa abagwalaafu baba amahumi ane nʼabataanu, onasihiirihise ehibuga hyosihyosi? Oja husihiirisa ehibuga olwohuba huŋumiraho bataanu?” Nga Musengwa amuloma ati, “Singa mubamo amahumi ane nʼabataanu, sinja husihiirisa hibuga ehyo.” ");
INSERT INTO nuj_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Nga nindi Yibbulayimu amuloma ati, “Ne singa ebaayo abagwalaafu amahumi ane goŋene?” Nga Musengwa amuloma ati, “Sinja husihiirisa hibuga olwʼamahumi ane ago.” ");
INSERT INTO nuj_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ngʼaŋo Yibbulayimu amuloma ati, “Musengwa, kusunga otanduŋira aye handomeho: ne singa ebaayo adatu abagwalaafu, onabasihiirise?” Nga niye amugobolamo ati, “Bbe, sinja hubasihiirisa singa nagaanayo amahumi adatu.” ");
INSERT INTO nuj_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Nga Yibbulayimu aloma Musengwa ati, “Onaasoniŋe ohweyongera ohuloma ni neewe, ne singa ebaayo amahumi abiri boŋene?” Nga Musengwa amugobolamo ati, “Sinja husihiirisa hibuga ehyo olwʼabagwalaafu amahumi abiri.” ");
INSERT INTO nuj_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ngʼaŋo Yibbulayimu amuloma ati, “Musengwa, kusunga otanduŋira aye fugiirire ndomeho omulundi ogusembayo guno gwoŋene. Ne singa ebaayo ehumi boŋene?” Nga Musengwa amugobolamo ati, “Sinja husihiirisa hibuga ehyo olwʼabaatu ehumi abagwalaafu.” ");
INSERT INTO nuj_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Musengwa ni gahena ohuloma ni Yibbulayimu, gaŋamba engira getiinira nga Yibbulayimu yeesi gagamayo. ");
INSERT INTO nuj_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ebyo ni byaŋwa, ngʼabamalayika babiri batiina e Sodoma ehyʼegulo. Luuti gaali geehaye ŋa mulyango ogwingira mu hibuga Sodoma. Ni gababona, genyoha ohubasangaalira, geyala hwiroba ohulaga ati abaŋa eŋono. ");
INSERT INTO nuj_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ngʼabaloma ati, “Basengwa, ese omwidu wenywe mbasunga hutiine ewange musaabeho era muŋenyuhe eyo ko olwejo mu mugamba mutiine eyi muja.” Nga bamugobolamo baati, “Bbe, sihunatiine yiwuwo, hunaŋenyuhe hu hyeya hyʼehibuga.” ");
INSERT INTO nuj_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Aye Luuti gabomeraho bahanda batiina ni naye baŋenyuha e wuwe. Ngʼabanyiira ahena abeŋula emigaati ejibatatayemo ehisimbulusa. ");
INSERT INTO nuj_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Aye ni bahiiri huŋenyuha, ehiŋindi hyʼabasinde bomu hibuga Sodoma baŋwerehereramo, bosibosi abaŋere nʼabahulu nga baja beswanigirisa enyumba ya Luuti. ");
INSERT INTO nuj_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Nga bamubuusa baati, “Abasinde aba oŋenyuhise ŋano bali ŋe? Batuse ebulafu, hubaŋenyuheho.” ");
INSERT INTO nuj_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Nga Luuti atula ebulafu alome ni nabo. Ni gatula, nga gegalaŋo omulyango ");
INSERT INTO nuj_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ahena abaloma ati, “Bahyange, mbegayiriiye mutahola ehibi hyehyo. ");
INSERT INTO nuj_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ŋano ndiŋo nʼabahaana bange babiri abahiiri huŋenyuhangaho nʼomusinde. Leha mbaleete, mubahole ehi munende. Aye mulehe abasinde abo mutabahola hiitu hyosihyosi, olwohuba bageni bange era ndi nʼohubalabirira.” ");
INSERT INTO nuj_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Aye nibo nga baloma Luuti baati, “Tuŋwereŋo.” Nga bacuuha batandiiha ohuloma abeene nʼabeene baati, “Omusinde ono mubuli ŋagati weefe, ŋahani njʼowenda atulomere ehyohuhola.” Nga bacuuhira Luuti bamuloma baati “Ewe, hunahubisye bubi nʼohuhiraho abasinde abo.” Nga bamuŋamba bamusindiha era, nga batiina hu lwigi ohulubbwaga. ");
INSERT INTO nuj_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Aye abageni bala begulaŋo, bahwesa Luuti bamwingisa mu nyumba bahena begalaŋo nʼolwigi. ");
INSERT INTO nuj_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ngʼabahena baŋofuŋasa abasinde abo abaali ŋa mulyango, abahulu nʼabaŋere, nga batandiiha ohumamaata aye ni batabona nʼomulyango aŋa guli. ");
INSERT INTO nuj_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ngʼabageni baloma Luuti baati, “Ŋaliŋo abaatu babo abandi: abahaana nʼabasaani babo, abahwe babo oba omuutu wuwo yesiyesi mu hibuga muno? ");
INSERT INTO nuj_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ehyo huhiroma olwohuba hwenda husihiirisa ehibuga hino, ohulira hweyongeeye bugali mu moni ja Musengwa era atutumire ohuhisihiirisa.” ");
INSERT INTO nuj_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ngʼaŋo Luuti atula atiina aloma nʼabasinde abaali ni benda ohuŋira abahaana babe ati, “Bahyange mwanguŋeho, muŋwe mu hibuga hino, olwohuba Musengwa genda huhisihiirisa.” Aye abasinde abo baŋeega baati Luuti gaali amooca. ");
INSERT INTO nuj_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ni wahya mu mawiiwi, ngʼabamalayika baloma Luuti baati, “Yinyoha mangumangu, oŋambe omuhasi wuwo nʼabaana babo abahaana bombi, muŋwe mu hibuga hino mutasihiiriha.” ");
INSERT INTO nuj_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Aye Luuti ni gaali nʼagayaala, ngʼabamalayika bamuŋamba hu muhono, baŋamba nohu gwʼomuhasi wuwe nohu bahaana babe bombi, babatusa ebulafu wʼehibuga, olwohuba Musengwa gabaŋambira ehisa. ");
INSERT INTO nuj_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ni baŋwa mu hibuga baati pa, nga mulala hu bamalayika abaloma ati, “Ale ŋaahani muŋiteŋiiteho! Mutaheja yigongo era mutemeerera ŋaatu ŋosiŋosi mu hifo ehiduleere! Mudulumire hu lusozi mwahaŋona.” ");
INSERT INTO nuj_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Aye Luuti ngʼabaloma ati, “Bbe, basengwa mbasunga, ");
INSERT INTO nuj_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ngʼolu mundagire ehisa ehyʼamaani mwaponia ohusihiiriha, olusozi lundi ŋaleeŋi. Pangire ohufa olwagaane. ");
INSERT INTO nuj_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Leha ndulumire aŋaapi mu habuga aho. Aŋo naŋonie obulamu wange.” ");
INSERT INTO nuj_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Nga malayika amugobolamo ati, “Kale kufugiiriiye tiina, sinja husihiirisa ehibuga ehi olomaho ehyo. ");
INSERT INTO nuj_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ale yanguŋaho odulume otiine eyo, olwohuba sinja huhola hiitu hyosihyosi ohutusaho ni woolire.” Cʼehigima balanga ehibuga ehyo baati Zowaali. ");
INSERT INTO nuj_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ehiseera ehi Luuti goolera mu habuga Zowaali, esaawa yaali etulire. ");
INSERT INTO nuj_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Nga Musengwa aŋeeresa omuliro ohuŋwa mwigulu hu Sodoma ni Gomora. ");
INSERT INTO nuj_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Gasihiirisa ebibuga ebyo nʼomulirano gwosigwosi mu hifo ehiduleere, abo bosibosi abaali mu bibuga ko ni hiisi hiitu hyosihyosi. ");
INSERT INTO nuj_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Aye omuhasi wa Luutu gaheja enyuma ngʼafuuha etuumo ya cumbi. ");
INSERT INTO nuj_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Nga mu mugamba pwipwipwi, Yibbulayimu atiina mu hifo aŋa gaali ni gemereeye mu moni ja Musengwa. ");
INSERT INTO nuj_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ngʼalengera e Sodoma ni Gomora mu hifo ehiduleere, ngʼabona eriisi eryʼamaani ni liduunya. ");
INSERT INTO nuj_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Hatonda ni gasihiirisa ebibuga ebyo mu hifo ehiduleere, gahebulira Yibbulayimu ngʼaŋonia Luuti ohusihiiriha ohwahenaŋo ebibuga omu gaali ni gehala. ");
INSERT INTO nuj_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ngʼaŋo Luuti aŋamba abahaana babe batiina ohumenya mu sozi olwohuba gatya ohumenya mu Zowaali. Ngʼaŋo Luuti nʼabahaana babe bombi, bamenya mu pungulu. ");
INSERT INTO nuj_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Lulala, omuhaana omuhulu galoma omuŋere ati, “Wange, seefe asahuluŋire era eŋuma musinde hu hyalo huno oja ohutufumbirwa. ");
INSERT INTO nuj_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Olwʼehyo, humunywese omwenge ameere, huŋenyuhe ni naye hwahasaala hu baana, amago geefe gaheyongera mu moni.” ");
INSERT INTO nuj_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Nga banywesa saawe omwenge owiire owo, ngʼomuhaana omuhulu atiina aŋenyuha ni naye. Olwʼobumeesi, Luuti sigategeera nʼaŋenyuha nʼomuhaana wuwe era sigategeera omuhaana nʼaŋwaŋo. ");
INSERT INTO nuj_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Oludaalo olwagobolaho, omuhaana omuhulu galoma omuŋere ati, “Owiire obuhyehise olwa leero, penyuhire ni Bbaabba. Nindi humunywese omwenge owiire wuno, weesi oŋenyuhe ni naye, amago geefe gaheyongera.” ");
INSERT INTO nuj_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ngʼowiire owo woosi banywesa saawe omwenge, ngʼomuhaana omuŋere yeesi aŋenyuha ni naye. Olwʼobumeesi, Luuti sigategeera nʼaŋenyuha nʼomuhaana wuwe era sigategeera omuhaana oyo nʼaŋwaŋo. ");
INSERT INTO nuj_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ehyaŋwamo, ngʼabahaana ba Luuti abo bombi, baba bida bya saawe. ");
INSERT INTO nuj_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ngʼomuhaana omuhulu asaala omwana omuseere, nga bamuguliha esiina ati Mowaabbu. Era oyo nje sehulu wʼAbamowaabbu hatyane. ");
INSERT INTO nuj_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Omuhaana omuŋere yeesi ngʼasaala omwana museere, ngʼamuguliha esiina ati Bbeeni Ami, oyo nje sehulu wʼAbamooni hatyane. ");
INSERT INTO nuj_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ehiseera hyola nga Yibbulayimu aŋwa e Mamule atiina mu twale lyʼe Negevu mu hifo ehiri ŋagati wa Kadesi ni Suuri, ngʼamenya eyo. Oluvanyuma gatiina e Gerali gamenyahoyo. ");
INSERT INTO nuj_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Yibbulayimu ni gaali eyo, galomeranga abaatu ati, “Saala mboojo yange.” Abbimereki habaha wʼe Gerali ni gaŋulira ati Saala mboojo ya Yibbulayimu, gatumisa bamuŋirire Saala abe muhasi wuwe. ");
INSERT INTO nuj_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Aye Hatonda gaaloma Abbimereki owiire mu hirooto ati, “Luhwageene olwʼohuŋira omuhasi wabeene.” ");
INSERT INTO nuj_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Cooka Abbimereki gaali ahiiri huŋenyuhaho ni Saala, kale ngʼaloma Musengwa ati, “Musengwa, wenda hunjita wayire nga puma musango? ");
INSERT INTO nuj_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Yibbulayimu omwene njʼowaloma ati Saala mboojo era Saala yeesi galoma cʼehyene. Ehyo nahihola mu mwoyo omulaŋi, ni mbula ehi manyire.” ");
INSERT INTO nuj_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ngʼaŋo Hatonda amuloma mu hirooto ati, “Hituufu manyire ti oŋuma musango. Cʼehyagira ndikuleha huŋenyuha ni naye ohwonoona mu moni jange. ");
INSERT INTO nuj_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Olwʼehyo, olwohuba Yibbulayimu naabbi, mwagamihisye omuhasi wuwe ahusabire kulehe obe mulamu. Aye onagaana ohumumwagamihisya, oli nʼohuhitegeera oti ewe nʼamago gago mwesimwesi, muja hufa.” ");
INSERT INTO nuj_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ni wahya mu mugamba, ngʼAbbimereki alanga abahungu babe bosibosi, ngʼabalomera ebyo byosibyosi ebyali ni bibayeŋo mu hirooto. Ebyo ni byabagwa mu hutwi, obuti owʼamaani wabaŋamba. ");
INSERT INTO nuj_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ngʼaŋo Abbimereki alanga Yibbulayimu amuloma ati, “Hiina hino ehi watuhola? Nahuhola hi ohutuleetera endibo jino, ese nʼowahabaha wange? Bukolire ehi wahali nʼotakola.” ");
INSERT INTO nuj_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","NgʼAbbimereki abuusa Yibbulayimu ati, “Waali nʼehigendererwa hi ohukola otyo?” ");
INSERT INTO nuj_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Nga Yibbulayimu amugobolamo ati, “Naŋeega ti, ‘Mu butuufu abaatu mu gwanga lino sibatya Hatonda, olwʼehyo baja hunjita olwʼohwenda ohuŋira omuhasi wange.’ ");
INSERT INTO nuj_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ne mu butuufu oweene Saala mboojo yange. Seefe gaali mulala ohutusaho abanyineefe njʼababuhana, ni hwahula ngʼafuuha muhasi wange. ");
INSERT INTO nuj_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Hatonda ni gandoma ohuŋwa mu gwanga lyange, nʼaloma Saala ti ‘Ohulaga ti wunyenda, hiisi eyi hunatiinenga balomenga oti ndi mboojoyo.’ ” ");
INSERT INTO nuj_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ngʼaŋo Abbimereki aŋamba etaama nʼeŋombe nʼabeedu abahasi ko nʼabasinde abaŋa Yibbulayimu, ngʼamugobohesa ni Saala omuhasi wuwe. ");
INSERT INTO nuj_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","NgʼAbbimereki aloma Yibbulayimu ati, “Oli wʼedembe ohumenya aŋaatu ŋosiŋosi mu gwanga lyange.” ");
INSERT INTO nuj_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ngʼaloma Saala ati, “Nja huŋa mboojoyo ebitundu byʼefeeza lukumi, hirage abaatu babo hiiti ŋaŋuma hibi hyosihyosi ehi oholire.” ");
INSERT INTO nuj_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ngʼaŋo Yibbulayimu alomba Hatonda era nga Hatonda aŋonia Abbimereki nʼomuhasi wuwe nʼabeedu babe abahasi basobole ohusaala abaana. ");
INSERT INTO nuj_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Ehyo hyaliŋo olwohuba Musengwa gaali asidihire abahasi abomu mago gʼAbbimereki ohutasaala olwohuba gaali aŋirire Saala muha Yibbulayimu. ");
INSERT INTO nuj_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ehiseera hyola, nga Musengwa aŋambira Saala ehisa ngʼolu gamuloma era ngʼamuŋa ehi gamusuubisa. ");
INSERT INTO nuj_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Nga Saala aba hida asaalira Yibbulayimu omwana omuseere mu hiseera ehyene nʼehyene ehi Hatonda gamulagaania. Mu hiseera ehyo Yibbulayimu gaali asahuluŋire. ");
INSERT INTO nuj_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Nga Yibbulayimu aguliha omwana oyu Saala gamusaalira ati Yisaka. ");
INSERT INTO nuj_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Yisaka ni gahena endaalo munaana nga Yibbulayimu amuhomola ngʼolu Hatonda gamulagira. ");
INSERT INTO nuj_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Yibbulayimu gaali aŋesa emyaha cikumi aŋa basaalira omwana wuwe Yisaka. ");
INSERT INTO nuj_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Nga Saala aloma ati, “Hatonda gapaaye enjeho era hiisi anaŋulirenga ati ŋahani sundya omwana, yeesi aja hujehanga.” ");
INSERT INTO nuj_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Era ngʼameedaho ati, “Mu biseera ebyegongo eyo, njʼani owahalomire Yibbulayimu ati Saala alyokesa hu mwana? Aye mu busahulu wuwe musaaliiye omwana museere.” ");
INSERT INTO nuj_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Nga Yisaka ahula aŋwa hwibeere era Yibbulayimu ganyiiya embaga hasiigu hu ludaalo olu baatusa Yisaka hu beere. ");
INSERT INTO nuj_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Aye Saala ngʼabona ati omwana oyu Agali Omumisiri gasaalira Yibbulayimu, gaali ajeeja Yisaka. ");
INSERT INTO nuj_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Nga Saala aloma Yibbulayimu ati, “Bbinga omuhasi oyo omwidu era atiine nʼomwana wuwe olwohuba omwana oyo abula mugabo mu byʼobusika nʼomwana wange Yisaka.” ");
INSERT INTO nuj_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ehiitu ehyo hyaluma Yibbulayimu bugali olwohuba hyali hiŋamba hu mwana wuwe Yisimayiri. ");
INSERT INTO nuj_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Aye Hatonda galoma Yibbulayimu ati, “Ebiŋamba hu muhasi omwidu nʼomwana wuwe bitahulumya mutwe. Ŋuliirisa ehi Saala ahuloma olwohuba abejuhulu aba nahusuubisa baaja huŋwa mu nje Yisaka. ");
INSERT INTO nuj_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Era nja huŋa omwana wʼomuhasi omwidu yeesi ekabi afuuhe egwanga olwohuba mwana wuwo.” ");
INSERT INTO nuj_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ni wahya, nga Yibbulayimu genyoha mu mugamba pwipwipwi aŋamba emere nʼamaaji mu saŋu eyʼehyanjo abiŋa Agali. Nga Yibbulayimu atwiha Agali ebiitu ebyo ahena amuseebula. Ngʼaŋo Agali asimbuha nʼomwana atiina agenda atyo atyo mu lulafu lwʼe Bberuseebba. ");
INSERT INTO nuj_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Amaaji ni gaŋwa mu saŋu eyʼehyanjo, ngʼAgali ata aŋo omwana ŋaasi wʼogusiiku. ");
INSERT INTO nuj_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ngʼaŋo atiina gehala ŋaatu ni gesambireho ahanaaŋiro. Ngʼaloma mu mwoyo gugwe ati, “Sinenda hubona omwana wange nʼafa.” Agali ni gaali ni geehaye eyo gatandiha ohulira. ");
INSERT INTO nuj_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Oluvanyuma, Hatonda gaŋulira Yisimayiri nʼalira, nga malayika wa Hatonda nʼali mwigulu alanga Agali ati, “Agali, olirira hi? Otatya, Hatonda aŋuliiye ohulira hwʼomwana wuwo. ");
INSERT INTO nuj_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tiina omuŋambe hu muhono omwinyose ohene omuŋoyerese olwohuba nja humufuula egwanga bbala.” ");
INSERT INTO nuj_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ngʼaŋo Hatonda gegula emoni jʼAgali abona esobere ni yirimo amaaji. Ngʼatiina adaŋa amaaji gejusa esaŋu yʼehyanjo eyi gaali ni nayo, ngʼaŋaho Yisimayiri ohunywa. ");
INSERT INTO nuj_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Nga Hatonda aba ŋalala ni Yisimayiri, ngʼahula, abanga mu lulafu era gafuuha omuŋiimi haŋunye. ");
INSERT INTO nuj_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Olulafu olu gamenyangamo baali balulanga baati Parani era nʼali eyo nga nyina amusunirayo omuhasi ohuŋwa e Misiri. ");
INSERT INTO nuj_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Lulala, habaha Abbimereki ko ni Fikoli omuhulu wʼeŋe lirye bahyala ewa Yibbulayimu. Nga habaha amuloma ati, “Mbona Hatonda ali ŋalala ni neewe mu byosibyosi ebi ohola. ");
INSERT INTO nuj_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Kusunga olayire mu moni ja Hatonda oti oja huba wʼamazima eyi ndi nʼeyiri abaana oba abejuhulu bange. Ese mbaye wa hisa eyi oli. Kale kusunga weesi obe wahisa eyi ndi ko nʼabaatu bomu gwanga lyange omu oli ngʼomubuli.” ");
INSERT INTO nuj_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Nga Yibbulayimu amugobolamo ati, “Kusuubisa ohuhola tyo.” ");
INSERT INTO nuj_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ngʼaŋo Yibbulayimu gemulugunya eyiri Abbimereki olwʼesobere eyi abeedu babe bamutusaho. ");
INSERT INTO nuj_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","NgʼAbbimereki amugobolamo ati, “Simanyire owahutusaho esobere eyo. Siwundomerangaho oti abeedu bange bayihuŋiraho, ko kiŋulira lwa leero luno.” ");
INSERT INTO nuj_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Nga Yibbulayimu atiina aŋamba etaama nʼesaame abiŋa Abbimereki, nga bombi bahola endagaano. ");
INSERT INTO nuj_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ngʼaŋo Yibbulayimu atiina mu higo aŋamba etaama enduusi musanvu, ajabula ajita eruuyi. ");
INSERT INTO nuj_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","NgʼAbbimereki abuusa Yibbulayimu ati, “Otegeesa hi ohuŋamba etaama enduusi omusanvu wajita ŋa joŋene?” ");
INSERT INTO nuj_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Nga Yibbulayimu amugobolamo ati, “Kusunga oŋire etaama jino ohebulirirengaho oti ndiise owayaba esobere yino.” ");
INSERT INTO nuj_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ngʼehifo ehyo bahiranga baati Bberuseebba olwohuba abo bombi baholeraŋo endagaano. ");
INSERT INTO nuj_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Oluvanyuma lwʼohuhola endagaano mu hifo ehi balanga baati Bberuseebba, ngʼAbbimereki ni Fikoli omuhulu wʼeŋe lirye, baŋamba engira bagamayo mu twale lyʼAbafirisuuti. ");
INSERT INTO nuj_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Nga Yibbulayimu ahoma omunyulira e Bberuseebba, ngʼajumirihisyangamo Musengwa Hatonda owʼEmirembe nʼEmirembe. ");
INSERT INTO nuj_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Nga Yibbulayimu amenya mu twale lyʼAbafirisuuti ohuhena ehiseera hireeŋi. ");
INSERT INTO nuj_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Oluvanyuma Hatonda gagesesya Yibbulayimu. Gamuloma ati, “Yibbulayimu!” Ngʼamugobolamo ati, “Wanji Musengwa.” ");
INSERT INTO nuj_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Nga Hatonda amuloma ati, “Ŋamba Yisaka omwana wuwo, omulala wogobbo oyu wenda, otiine mu hyalo hyʼe Moliya, omuŋeyo ngʼeŋongo era omohye aguhulihe mulamba hu lusozi olu nja huhulaga.” ");
INSERT INTO nuj_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ni wahya mu mugamba pwipwipwi, nga Yibbulayimu ahumbaania ekwi ejʼohwohyera eŋongo ajita hu nasugirya yiye. Ngʼaŋamba olugendo, niye nʼabeedu babe babiri ko ni Yisaka omwana wuwe batiina mu hifo eyi Hatonda gamuloma. ");
INSERT INTO nuj_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Hu ludaalo olwohudatu mu lugendo lulwe nga Yibbulayimu alengera ehifo ehyo. ");
INSERT INTO nuj_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Nga Yibbulayimu aloma abeedu babe ati, “Musigale ŋano ni nasugirya, ese nʼomuseere hwesendeho mu moni. Huja hujumirya Hatonda, oluvanyuma hunagobole.” ");
INSERT INTO nuj_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Nga Yibbulayimu aŋamba ekwi ejʼohwohyera eŋongo ajitwiha Yisaka omwana wuwe. Nga niye aŋamba omuliro nʼengeso mu ngalo, batiina bombi. ");
INSERT INTO nuj_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Nga Yisaka alanga semwana ati, “Bbaabba!” Nga Yibbulayimu amugobolamo ati, “Hiina mwana wange?” Nga Yisaka amuloma ati, “Omuliro nʼekwi biriŋo ne etaama eyʼohuŋayo ngʼeŋongo eyi bohya yaguhuuliha, eriŋe?” ");
INSERT INTO nuj_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Nga Yibbulayimu amugobolamo ati, “Mwana wange, Hatonda aja hugabirira etaama eyʼohwohya ngʼeŋongo.” Nga bombi beyongera nʼolugendo. ");
INSERT INTO nuj_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ni boola mu hifo aŋa Hatonda gamuloma, nga Yibbulayimu atongola ehituuti ehyohuŋeeraho eŋongo, nga ganjaho ekwi. Ni gahena, ngʼasidiha Yisaka omwana wuwe, amugalamisa hu mugulu wʼekwi ejo hu hituuti. ");
INSERT INTO nuj_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Nga Yibbulayimu asoŋolayo epiima ohusala omwana wuwe. ");
INSERT INTO nuj_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Aye malayika wa Musengwa nʼali mwigulu gamulanga ati, “Yibbulayimu! Yibbulayimu!” Nga Yibbulayimu amugobolamo ati, “Wanji Musengwa.” ");
INSERT INTO nuj_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Nga malayika amuloma ati, “Oteeta mwana. Otamuhola hiitu hyosihyosi. Ŋaahani manyire ti oŋa Hatonda eŋono olwohuba siweganie huŋayo mwana wuwo omulala wogobbo.” ");
INSERT INTO nuj_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Yibbulayimu ni gagangamusa emoni, gaali aheja abona etaama emiigu, ameega ni gaŋegeeme mu mboŋa. Nga Yibbulayimu atiina aŋamba emiigu eyo ayiŋayo ngʼeŋongo enjohye, mu hifo hyʼomwana wuwe. ");
INSERT INTO nuj_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ngʼaŋo Yibbulayimu alanga ehifo ehyo esiina lyahyo ati, “Musengwa aja hutugabirira.” Era nʼohwola olwa leero baloma baati, “Hu lusozi lwa Musengwa, baja hutuŋa.” ");
INSERT INTO nuj_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Nga malayika wa Musengwa aloma Yibbulayimu omulundi ogwohubiri, ");
INSERT INTO nuj_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ati, “Ese Musengwa nerayirira ese omwene ti olwohuba ndibunjima mwana wuwo omulala wogobbo, ");
INSERT INTO nuj_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","mu butuufu nja huhuŋa ekabi era nja hufuula abejuhulu babo ohuba bangi hyʼemunyeenye mu bbanga, bangi hyʼomujehe hwigobo lyʼenyanja. Abejuhulu babo baliŋira ebibuga bya balabe baawe. ");
INSERT INTO nuj_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Era abaatu mu mawanga gosigosi hu hyalo baja husuna ekabi ohubitira mu bejuhulu babo olwohuba wungondeeye.” ");
INSERT INTO nuj_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ngʼaŋo Yibbulayimu aŋamba engira gagamayo eyiri abeedu babe bagamayo e Bberuseebba. Nga Yibbulayimu amenya e Bberuseebba. ");
INSERT INTO nuj_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Oluvanyuma lwʼahaseera ŋaaliŋo abalomera Yibbulayimu baati, “Mirika muha mugandawo Naholi yeesi amusaaliiye abaana baseere: ");
INSERT INTO nuj_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Wuuzi njʼomudaayi waawe, Bbuuzi njʼowohubiri, Kemweli semwana yʼAlaamu njʼowohudatu ");
INSERT INTO nuj_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesedi njʼowohune, Kaazo wahutaanu ni Perudaasi ni Yidulaafu ni Bbesweri.” ");
INSERT INTO nuj_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bbesweri gasaala Labbeka. Mirika gasaalira Naholi muganda ya Yibbulayimu abaana munaana. ");
INSERT INTO nuj_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Naholi gaali nʼomuhasi owundi hutulo, oyu balanganga baati Lewuma. Era yeesi gasaala abaana abandi: Tebba ni Gahamu ni Takasi ni Maaka. ");
INSERT INTO nuj_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saala gahena emyaha cikumi abiri namusanvu ");
INSERT INTO nuj_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ngʼafiira mu hibuga Kiriyaasi Arubba (esiina erindi baati Kebbulooni), mu hyalo hyʼe Kanani. Era ni gafa, nga Yibbulayimu gengira mu weema omu mulambo gwali, ngʼalira. ");
INSERT INTO nuj_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ngʼaŋo Yibbulayimu genyoha aŋwa aŋaali omulambo gwʼomuhasi wuwe, atiina aloma abatangirisi bʼAbahiiti ati, ");
INSERT INTO nuj_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ese ŋano ndi mubuli era sindi wʼegwanga lyenywe. Mbasunga munguse ehifo ohusiihangamo abaatu bange, siihemo omuhasi wange.” ");
INSERT INTO nuj_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","NgʼAbahiiti bamugobolamo baati, ");
INSERT INTO nuj_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Muhulu, efe huhuŋira ohuba omuutu owʼeŋono. Kale oli wʼedembe ohusiiha omuutu wuwo mu pungulu yosiyosi eyi onasiime, ŋaŋuma anagaane.” ");
INSERT INTO nuj_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ngʼaŋo Yibbulayimu genyoha ahotama mu moni jaawe ohulaga ati abaŋa eŋono, ");
INSERT INTO nuj_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ngʼabaloma ati, “Ale ngʼolu muloma muuti ndi wʼedembe, mbasunga mundomereho nʼEfulooni omusaani wa Zokali, ");
INSERT INTO nuj_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ganguse epungulu eyiri e Makupeera aŋa hisugu hihye hihoma. Mumulome ganguse hu bbeeyi eyi genda, siihemo omuutu wange.” ");
INSERT INTO nuj_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ŋahani Efulooni yeesi gaali gehaaye nʼAbahiiti bahye mu hifo omu bahumbaaniranga ohuupi nʼomulyango gwʼehikomera hyʼehibuga. Ngʼaŋo agobola mu Yibbulayimu ati, ");
INSERT INTO nuj_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Bbe, musengwa yange sinahihuguse aye kuŋa ehisugu ehyo nʼepungulu yawaho hu wereere. Era kuŋa mu moni jʼabahyange bano, siihamo omuutu wuwo.” ");
INSERT INTO nuj_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Nga nindi Yibbulayimu ahotama mu moni jʼAbahiiti abaali aŋo. ");
INSERT INTO nuj_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ngʼaloma Efulooni, abaatu bosibosi abaaliŋo ni baŋulira ati, “Ese mbaye ndoma ti, hanye oganyire ohuupa eroba eryo, ganya ndi huguleho bugule, kusasulemo ebbeesa. Kusunga ofugiirire.” ");
INSERT INTO nuj_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","NgʼEfulooni agobola mu Yibbulayimu ati, ");
INSERT INTO nuj_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Musengwa yange, ehisugu hijaamo esekeri jʼefeeza ebihumi bine. Aye ebbeesa ejo njʼehiina ŋagati wange ni neewe? Olwʼehyo, hiŋire osiihemo omuutu wuwo.” ");
INSERT INTO nuj_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Nga Yibbulayimu afugiirira ebbeeyi eyo era ngʼapimira Efulooni esekeri jʼefeeza ebihumi bine Abahiiti ni babona. Ehyo gahihola nʼatambisa ehipimo ehi basubuuzi batambisanga mu hiseera ehyo. ");
INSERT INTO nuj_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Eyo njʼengeri eyi hisugu hyʼEfulooni e Makupeera aŋaapi nʼe Mamule ko nʼepungulu yawaho ko nʼemisaala josijosi ejaali mu lwaha ohwetoloola ");
INSERT INTO nuj_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","byafuuha bya Yibbulayimu mu moni jʼAbahiiti bosibosi abaali ni bahumbeene ohuupi nʼomulyango gwʼehikomera hyʼehibuga. ");
INSERT INTO nuj_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Oluvanyuma lwʼohugula ehisugu ehyo, Yibbulayimu gasiiha omuhasi wuwe Saala mu pungulu eyomu Makupeera aŋaapi nʼe Mamule (ko nje Kebbulooni), mu gwanga lyʼAbakanani. ");
INSERT INTO nuj_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ngʼehisugu nʼepungulu ebyali ebyʼAbahiiti oludaayi, bifuuha bya Yibbulayimu ohuba ehifo hihye ehyʼohusiihangamo abafu. ");
INSERT INTO nuj_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ŋaahani ehiseera hyola Yibbulayimu gaaba nʼasahuluŋire era nabitiriiye mu myaha. Musengwa gaali amuŋaaye ekabi mu hiisi hiitu ehi gaholanga. ");
INSERT INTO nuj_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Lwali lulala, nga Yibbulayimu aloma omuhulu wʼabeedu babe era nga njʼowalabiriranga ebiitu byosibyosi mu mago gage ati, “Yigerera ŋano oŋambe ŋaasi wʼehisambi hyange. ");
INSERT INTO nuj_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Nenda olayire mu moni ja Musengwa Hatonda owatonda egulu nʼehyalo oti sooja hufunira musaani yange omuhaana Mukanani ");
INSERT INTO nuj_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","aye oti oja hutiina mu gwanga lyange era mu balebe bange, eyo osunire musaani yange Yisaka omuhasi.” ");
INSERT INTO nuj_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ngʼomwidu amubuusa ati, “Ne singa omuhasi oyu ndisuna safugiirira ohuuja ni neese ohufumbirwa omwana wa musengwa yange, kolanga tye? Ndiŋamba omwana wuwo namuŋira mu hyalo ehyo eyi waŋwa ko waaja eno?” ");
INSERT INTO nuj_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Nga Yibbulayimu amugobolamo ati, “Kadi naŋatotono! Soŋiranga mwana wange eyo.” ");
INSERT INTO nuj_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ngʼameedaho ati, “Musengwa Hatonda owatonda egulu, omwene huutusa mu mago ga Bbaabba, mu gwanga lyange era gaasuubisa nʼalayira nʼohulayira ati, ‘Mazima nja huŋa abejuhulu babo eroba lino.’ Hatonda oyo aja hutuma malayika wuwe ahutangirire osunire omwana wange omuhasi ohuŋwa eyo. ");
INSERT INTO nuj_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Omuhasi nʼaliba nʼatenda huuja ni neewe, oliba oŋumaaho omusango. Ohutusaho sooŋiranga mwana wange eyo.” ");
INSERT INTO nuj_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ngʼaŋo omwidu aŋamba ŋaasi wʼehisambi hya Yibbulayimu musengwawe, amulayirira ati aja huhola atyo. ");
INSERT INTO nuj_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ngʼaŋo omwidu oyo aŋambaho hu ngamiya ja musengwawe ehumi, ajitwiha ebirabo ebyʼebbeeyi ebi musengwawe gamuŋwa ohuŋira, ngʼaŋamba olugendo ohutiina mu hibuga omu Naholi gamenyanga ehyali mu hyalo ehi balanganga baati Mesopotamya. ");
INSERT INTO nuj_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ni goola eyo, nga abundaasa engamiya ohuupi nʼesobere ebulafu wʼehibuga omu Naholi gamenyanga. Aŋa goleraŋo, jaali saawa jʼegulo eji bahasi baajirangamo amaaji. ");
INSERT INTO nuj_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ngʼaŋo omwidu oyo asaba ati, “O Musengwa, ewe Hatonda wa musengwa yange Yibbulayimu, pe ekabi olwa leero, ohulaga ngʼolu oli nʼehisa eyiri musengwa yange, oŋambire musengwa yange Yibbulayimu ehisa. ");
INSERT INTO nuj_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Nemereeye ŋano hu sobere yino ohu bahaana abomu hibuga hino bali huuja ohudaŋa amaaji. ");
INSERT INTO nuj_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kusunga ti omuhaana oyu nalome ti, ‘Peeho amaaji nyweho,’ ngʼaloma ati, ‘Ngagano era nanywese nʼengamiya jijo.’ Leha abe njʼoyo oyu wendesa Yisaka omwidu wuwo. Ehyo hiija hundaga hiiti oŋambiiye musengwa yange ehisa.” ");
INSERT INTO nuj_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Gaali ahiiri hugwisa saala eyo, nga Labbeka goola nʼesongo yiye hwibega. Labbeka gaali muhaana wa Bbesweri omusaani wa Mirika omuhasi wa Naholi muganda ya Yibbulayimu. ");
INSERT INTO nuj_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Omuhaana oyo gaali muŋoono bugali, najoŋire era nʼataŋenyuhangaho nʼomusinde. Ngʼomuhaana oyo geeha mu sobere adaŋa amaaji gejusa esongo yiye ngʼatula. ");
INSERT INTO nuj_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ni gaali ni gahatula ohuŋwa mu sobere, ngʼomwidu ola aŋaalaŋaala atiina eyi ali amuloma ati, “Kusunga wupeho amaaji nyweho.” ");
INSERT INTO nuj_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ngʼaŋo ni naaŋo Labbeka getwihula esongo aloma omwidu oyo ati, “Ngagano, muhulu nywaho.” ");
INSERT INTO nuj_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Oluvanyuma lwʼohumuŋa amaaji, gamuloma ati, “Nʼengamiya jijo joosi najidaŋire amaaji janywa jeguta.” ");
INSERT INTO nuj_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ngʼaŋo ajuha amaaji agaali ni gasigaaye mu songo mu hiitu omu byayo byanyweranga, ngʼaŋiitaŋitaho adaŋa agandi aleeta ajuhamo ohwola olu engamiya josijosi janywa jeguta. ");
INSERT INTO nuj_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Labbeka gaholanga ebyo nʼeno omwidu ola amutayeeho emoni maŋoleeye ni gebuusa mu mwoyo obanga dala Musengwa gaali ali humugobolangamo esaala yiye eyi gasaba nʼamusunga amuŋe ekabi mu lugendo lulwe. ");
INSERT INTO nuj_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Engamiya ni jahena ohunywa amaaji, omwidu gaŋamba epeta eyʼomuŋendo eyi babbota mu zaabbu, nʼekeeke embala ebiri eji babbota mu zaabbu ngʼabyambasa Labbeka. ");
INSERT INTO nuj_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ngʼaŋo amubuusa ati, “Oli muhaana wʼani? Lataawo aŋanga ohuba nʼehifo omu ese nʼabahyange aba ndi ni nabo huŋanga ohuŋenyuha?” ");
INSERT INTO nuj_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ngʼamuloma ati, “Ndi muhaana wa Bbesweri omusaani wa Mirika, oyu gasaala ni Naholi.” ");
INSERT INTO nuj_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ngʼameedaho ati, “Engo huliyo nʼenyaasi lyʼebyayo lingi ko nʼehifo ehyʼohuŋenyuhamo.” ");
INSERT INTO nuj_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ngʼomwidu oyo ahubba amafuha ajumirya Musengwa ");
INSERT INTO nuj_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ati, “Musengwa Hatonda wa Yibbulayimu musengwa yange, gebasiwe olwohuba otiinire nʼomulaga ngʼolu oli nʼehisa era omwesigwa eyi ali. Era keesi Musengwa ganduŋamisye ganjosa mu mago ga balebe ba musengwa yange.” ");
INSERT INTO nuj_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Labbeka ni gaŋwaŋo gaduluma gatiina mu nyumba ya nyina galomera hiisi muutu ebibono ebyo ebiŋamba hu mwidu ola. ");
INSERT INTO nuj_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ŋaahani Labbeka gaali ni mboojo ni bamulanga baati Labbaani. ");
INSERT INTO nuj_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Era Labbaani ni gabona Labbeka ni gambaaye epeta hu suulu ko nʼekeeke hu ngalo era gaŋulira ebibono ebyo ebi mugeni gamuloma, gatula mbiro gaduluma gatiina hu sobere. Ni goola, nga gagaana omuutu oyo ni gemeereye aŋo nʼengamiya jije. ");
INSERT INTO nuj_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Nga Labbaani aloma omwidu wa Yibbulayimu oyo ati, “Ewe oyu Musengwa aŋaaye ekabi, nja hutiine engo. Lwahiina wemeereye ŋano ebulafu? Kutegeheeye enyumba nʼehifo omu ngamiya jijo jinaabe.” ");
INSERT INTO nuj_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ngʼomwidu oyo atiina ni Labbaani nga gengira mu nyumba eyi bamutegehera. Nga Labbaani asitula ebiitu ebyali hu ngamiya era nga bajiŋirira enyaasi. Nga baŋirira omwidu nʼaba gaali ni nabo amaaji agʼohusaaba. ");
INSERT INTO nuj_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ni bahena nga babeŋula aye ngʼomwidu ola aloma ati, “Sinalye ni kiiri hubalomera ehindetire.” Nga Labbaani amuloma ati, “Ale tulomere.” ");
INSERT INTO nuj_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ngʼomwidu atandiha ohubiroosa ati, “Ese ndi mwidu wa Yibbulayimu. ");
INSERT INTO nuj_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Musengwa aŋaaye musengwa yange ekabi nyingi bugali era afuuhire muŋinda. Amuŋaaye embusi nʼeŋombe nʼengamiya ni nasugirya nʼefeeza nʼezaabbu ko nʼabeedu abahasi nʼabasinde. ");
INSERT INTO nuj_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Era ni Saala omuhasi wa musengwa yange, gamusaalira omwana museere mu busahulu wuwe. Era omwana oyo, bamuŋa obusika owa hiisi hiitu. ");
INSERT INTO nuj_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Era musengwa yange gandayisa ati, ‘Sofuniranga musaani yange omuhaana Mukanani, aba menyiremo hatyane. ");
INSERT INTO nuj_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Aye tiina eyiri abalebe ba Bbaabba era mu hiha hyange eyo osunire musaani yange Yisaka omuhasi.’ ” ");
INSERT INTO nuj_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Ngʼaŋo mbuusa musengwa yange ti, ‘Ne singa omuhaana oyo saafugiirira ohuuja ohufumbirwa musaani ya musengwa yange, kola tye?’ ” ");
INSERT INTO nuj_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Nga gangobolamo ati, “Musengwa oyu peeresa, aja hutuma malayika wuwe ahutangirire mu lugendo lulwo osunire musaani yange omuhasi ohuŋwa mu hiha hyange era mu balebe ba Bbaabba. ");
INSERT INTO nuj_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Nʼoja hutiina mu hiha hyange, omuhaana oyo gagaana, soolibaho musango. ");
INSERT INTO nuj_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Olwaleero ni noolire hu sobere, sabire ti, ‘O Musengwa Hatonda wa Yibbulayimu musengwa yange, kusunga oŋe olugendo lwange luno ekabi. ");
INSERT INTO nuj_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Neemire ŋano hu sobere yino, omuhaana anaaje ohudaŋa amaaji, namuloma ti, “Peeho, amaaji nyweho,” ");
INSERT INTO nuj_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","gandoma ati, “Ngagano nywa era nʼengamiya jijo joosi najidaŋire,” leha abe njʼoyo oyu Musengwa atoboleeye omusaani ya musengwa yange.’ ");
INSERT INTO nuj_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Ni mbaye ni kiiri huhena saala eyo mu mwoyo gwange, nga Labbeka gaaja nʼesongo yiye hwibega. Gehire mu sobere ngʼadaŋa amaaji. Nga muloma ti, ‘Peeho amaaji nyweho.’ ");
INSERT INTO nuj_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Aŋo ni naaŋo atwihuuye esongo yiye nga gandoma ati, ‘Ngagano nywa era naaŋe nʼengamiya jijo joosi.’ ");
INSERT INTO nuj_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Nga mubuusa ti, ‘Oli muhaana wʼani?’ Nga gangobolamo ati, ‘Ndi muhaana wa Bbesweri, omusaani wa Naholi era maama nje Mirika.’ Nga pamba ekeeke mwambasa hu muhono, ngʼamuta nʼepeta hu suulu. ");
INSERT INTO nuj_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ni kenire, nga kubba amafuha njumirya Musengwa. Nga pa Musengwa Hatonda wa Yibbulayimu musengwa yange, eŋono, owutangiriiye mu lugendo lwange hu mwijuhulu wa Naholi muganda ya musengwa yange. ");
INSERT INTO nuj_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ebyo njʼebibayeŋo, musengwa yange mumuholire muutye? Mbasunga mumulage ehyere era mube balwatu eyi ali. Munamuŋe omuhaana oba bbe? Ohungobolamo hwenywe hunanjeede ohumanya ehyohuhola.” ");
INSERT INTO nuj_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Nga Labbaani ni Bbesweri bamugobolamo baati, “Musengwa ali mu hiitu hino. Olwʼehyo, ŋaŋuma ehi huloma. ");
INSERT INTO nuj_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Labbeka njʼono ŋano, muŋire abe muhasi wʼomusaani wa musengwawo ngʼolu Musengwa ahutangiriye.” ");
INSERT INTO nuj_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Omwidu wa Yibbulayimu ni gaŋulira ebibono ebyo, ngʼahubba amafuha ajumirya Musengwa. ");
INSERT INTO nuj_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ngʼaŋo omwidu atusayo ebyamajolobera ebi bahasi bambala ebi baabbota mu feeza nʼezaabbu ko nʼengoye abiŋambya Labbeka era ngʼaŋa ni mboojo ni nyina ebirabo ebyʼomuŋendo bugali. ");
INSERT INTO nuj_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ni bahena, nga ko babeeŋula balya, banywa era nga baŋenyuhayo. Ni wahya, benyoha mu mugamba, ngʼomwidu aloma abeene mago ati, “Bahyange, hubaweneho muuseebule hahwagame eyiri musengwa yange.” ");
INSERT INTO nuj_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Aye nyina ni mboojo ya Labbeka nga bamuloma baati, “Leha omuhaana asigale ŋano ni neefe ohuhena endaalo ngʼehumi ko mutiine.” ");
INSERT INTO nuj_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Aye ola ngʼabaloma ati, “Mbasunga mutandwisa, ngʼolu Musengwa aŋaaye olugendo lwange ekabi, muuseebule tiine eyiri musengwa yange.” ");
INSERT INTO nuj_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Nga bamuloma baati, “Hahulange omuhaana omwene humubuuse, hubone ehi aloma.” ");
INSERT INTO nuj_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ngʼaŋo balanga Labbeka bamubuusa baati, “Onatiine nʼomusinde ono?” Ngʼabagobolamo ati, “Natiine ni naye.” ");
INSERT INTO nuj_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ngʼababoojo baseebula Labbeka era nga bamuŋa nʼomuhasi owamulerire atiine ni naye. Ngʼomwidu wa Yibbulayimu ko nʼabasinde aba gaali ni nabo bagamayo ni Labbeka. ");
INSERT INTO nuj_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ne ko Labbeka asimbuhe, bamusabira ekabi baati, “Mboojo yeefe, Hatonda ahuŋe ekabi osalagane ekasi nʼesinde, abejuhulu babo basikire ebibuga byʼabalabe baawe.” ");
INSERT INTO nuj_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ngʼaŋo Labbeka nʼabeedu babe betegehera olugendo, ni bahena nga baniina engamiya batiina nʼomwidu oyo. ");
INSERT INTO nuj_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Mu hiseera ehyo, Yisaka gaali aŋooye e Bberirakalooyi nʼamenya e Negevu. ");
INSERT INTO nuj_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Lulala, gatiina mu ndimiro ehyʼegulo. Ni gaali eyo, gaali aheja alengera engamiya ni jiija. ");
INSERT INTO nuj_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Labbeka ni gagangamusa emoni, ngʼalengera Yisaka. Ngʼaŋo ni naaŋo aŋwa hu ngamiya. ");
INSERT INTO nuj_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Ngʼabuusa omwidu wa Yibbulayimu ati, “Omusinde oyo ali mu ndimiro ali huuja eyi huli, njʼani?” Ngʼomwidu amugobolamo ati, “Nje musengwa yange.” Labbeka ni gaŋulira ehyo, ngʼabugula olugoye gewihirira mu moni. ");
INSERT INTO nuj_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ngʼaŋo omwidu alomera Yisaka byosibyosi ebi gaali nʼaholire. ");
INSERT INTO nuj_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Nga Yisaka aŋamba Labbeka amuŋira mu weema omu Saala nyina gamenyanga. Nga Labbeka afuuha muhasi wuwe era nga Yisaka amwenda bugali. Era ehyo hyamutusaho obutahi obu galimo olwʼohufa hwa nyina. ");
INSERT INTO nuj_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Oluvanyuma lwʼohufa hwa Saala, Yibbulayimu gasuna omuhasi owundi oyu baali ni balanga baati Ketula. ");
INSERT INTO nuj_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketula gamusaalira Zimulaani ni Yokusani ni Medani ni Midiyaani ni Yisibbaki ko ni Suuwa. ");
INSERT INTO nuj_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokusani gasaala Seebba ni Dedani. Abʼolulyo lwa Dedani baali njʼAbasulimu nʼAbaletusimu nʼAbalewumimu. ");
INSERT INTO nuj_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Abasaani ba Midiyaani baali nje: Efa nʼEferi ni Kanoki nʼAbbida ko nʼEluda. Abo bosibosi baali baana ba Ketula. ");
INSERT INTO nuj_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Yibbulayimu gaŋamba byosibyosi ebi gaali ni nabyo ngʼabiŋa Yisaka. ");
INSERT INTO nuj_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Aye ni gaali nʼahiiriŋo mulamu, abaana aba bahasi abandi gabaŋa ebirabo ngʼahena abaseebula batiina ebuŋwalyuba, baleha Yisaka omusaani wuwe. ");
INSERT INTO nuj_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ŋosiŋosi, Yibbulayimu gahena emyaha cikumi sanvu nʼetaanu, ");
INSERT INTO nuj_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","nga ko afa nʼaŋangaliiye erala bulaŋi era nʼaliiyeho. Nga bamuŋira bamusiiha. ");
INSERT INTO nuj_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Nga Yisaka ni Yisimayiri, abasaani babe bamusiiha mu pungulu e Makupeera ŋaapi nʼe Mamule, ehifo ehigagula hu Efulooni omusaani wa Zokali Omuhiiti. ");
INSERT INTO nuj_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ehifo ehyo njʼehi Yibbulayimu gagula hu Bahiiti. Ŋaweene aŋo paŋa gaali nʼasiihire Saala omuhasi wuwe. ");
INSERT INTO nuj_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Oluvanyuma lwʼohufa hwa Yibbulayimu, Hatonda gaŋa Yisaka ekabi. Nga Yisaka amenyanga ohuupi nʼesobere eyi balanganga baati Bberirakalooyi. ");
INSERT INTO nuj_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Bino njʼebiŋamba hu Yisimayiri omwana wa Yibbulayimu oyu Agali Omumisiri, omwidu wa Saala gamusaalira ");
INSERT INTO nuj_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","era amasiina gʼabaana ba Yisimayiri ngʼolu basaaliwa ngagano: omudaayi gaali nje Nebbayoosi, owohubiri gaali nje Kedali, ngʼotaaho Adubbeeri. Nga hulondaho Mibbusamu ");
INSERT INTO nuj_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ni Misuma ni Duma ni Maasa ");
INSERT INTO nuj_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadadi ni Tema ni Yeturi ni Nafisi ko ni Kedema. ");
INSERT INTO nuj_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ago njʼamasiina gʼabaana ba Yisimayiri era ameene ago njʼamasiina gʼabatangirisi baawe ehumi nʼababiri ngʼolu bamenyanga. ");
INSERT INTO nuj_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Yisimayiri gahena emyaha cikumi adatu namusanvu, ngʼafa bamuŋira bamugalamirisa aŋali abasehulu babe. ");
INSERT INTO nuj_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Abejuhulu babe baamenya ohuŋwa e Kavira ohwola e Suuri ohuupi nʼesalo ni Misiri, nʼolengereeye e Busuuli. Era baali nʼepalaana nʼabaliranwa babe bosibosi. ");
INSERT INTO nuj_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Bino njʼebiŋamba hu Yisaka omusaani wa Yibbulayimu: Yibbulayimu gasaala Yisaka ");
INSERT INTO nuj_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","era Yisaka gaali ali nʼemyaha ane aŋa gahwera Labbeka omuhaana wa Bbesweri era mboojo ya Labbaani. Bbesweri gaali wʼegwanga lyʼAbalaamu mu hyalo hyʼe Mesopotamya. ");
INSERT INTO nuj_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ŋaahani Labbeka omuhasi wa Yisaka gaali mugumba. Olwʼehyo Yisaka nga gegayirira Musengwa amuŋe olusaaye. Nga Musengwa aŋulira ohusaba huhwe era nga Labbeka aba hida. ");
INSERT INTO nuj_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Abaana nga basoolanga mu hida wuwe. Nga nyinaawe aloma ati, “Lwahiina hino hiriŋo?” Olwʼehyo, ngʼatiina ohwebuusaho hu Musengwa. ");
INSERT INTO nuj_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ngʼaŋo Musengwa amuloma ati, “Abaana babiri bali mu hida wuwo era baliŋwamo amawanga abiri. Era abaatu abo ababiri baja hwawuhana. Mulala hu bo aja huhira owahye amaani. Era omuhulu aja huba muŋeeresa womuŋere.” ");
INSERT INTO nuj_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ehiseera hyʼohusaala ni hyola, Labbeka gasaala balongo, bombi ni bali baseere. ");
INSERT INTO nuj_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Muhwana gaali nʼomubiri mulando era omubiri gugwe gwosigwosi ni guhwene amooya oti hani bbulangiti eyʼamooya. Olwʼehyo, nga bamutaho esiina baati Esawu. ");
INSERT INTO nuj_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Oluvanyuma nga Mulongo yeesi atula nʼanywanywahise ehibbonje hyʼEsawu. Olwʼehyo, nga bamutaho esiina baati Yakobbo. Labbeka gasaala abalongo abo Yisaka nʼaŋesa emyaha kaaga. ");
INSERT INTO nuj_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Abaseere abo ni bahula, Esawu ngʼafuuha muŋiimi haŋunye era nʼasinga hugendera mwisugu. Aye Yakobbo gaali muutu muŋoleeri era ni getolooleranga ŋango. ");
INSERT INTO nuj_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Yisaka nga genda nyo Esawu olwohuba ganyumirwanga bugali ohulya enyama yʼesolo eji gaŋiimanga. Aye Labbeka gendanga nje Yakobbo. ");
INSERT INTO nuj_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Lulala, Yakobbo gaali ali hunyiiya ehifulugo, ngʼEsawu gagama engo nʼaŋwa ohuŋiima nʼadembire era enjala nʼemuluma. ");
INSERT INTO nuj_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","NgʼEsawu aloma Yakobbo ati, “Ndi bubi, enjala yenda hunjita. Peeho ebyohulya bibyo ebyo ebirulire ndyeho.” Cʼehyagima bamulanga baati Edomu. ");
INSERT INTO nuj_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Nga Yakobbo amuloma ati, “Sooka wusuubise oti onapemo omugabo gugwo ogu oli nʼohusuna ngʼomwana omudaayi.” ");
INSERT INTO nuj_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","NgʼEsawu amugobolamo ati, “Enjala yenda hunjita, omugabo gwange ngʼomwana omudaayi gungasa hi?” ");
INSERT INTO nuj_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Aye Yakobbo ngʼamuloma ati, “Sooka wundayirire oti onapemo omugabo gugwo.” Ehyaŋwamo ngʼEsawu amulayirira amugusa omugabo gugwe. ");
INSERT INTO nuj_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ngʼaŋo Yakobbo aŋa Esawu ehifulugo. NgʼEsawu alya era ngʼanywa ahena genyoha aŋwaŋo. Atyo Esawu poganyooma era gatunda obusika wuwe. ");
INSERT INTO nuj_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ehiseera hyola nga nindi ŋagwaŋo enjala mu hyalo hyʼe Kanani ngʼolu yaluma mu ndaalo ja Yibbulayimu. Olwʼenjala, Yisaka gatiina e Gerali ewa Abbimereki habaha wʼAbafirisuuti. ");
INSERT INTO nuj_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Nga Musengwa abonehera Yisaka amuloma ati, “Otatiina yi Misiri, nenda omenye mu hyalo omu nja ohuhuloma ohumenya. ");
INSERT INTO nuj_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Nenda omenyeho mu hyalo hino, nja huba ni neewe era nja huhuŋa ekabi. Ewe nʼabejuhulu babo nja hubaŋa amawanga gano gosigosi era ehyo hija huhahasa ehi nʼaloma Yibbulayimu lataawo. ");
INSERT INTO nuj_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nja hwasa abejuhulu babo babe bangi hyʼemunyeenye ŋamugulu mu bbanga era nja hubaŋa e twale lino lyosiryosi. Era abaatu mu mawanga gosigosi hu hyalo baja husuna ekabi ohubitira mu bejuhulu babo ");
INSERT INTO nuj_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","olwohuba Yibbulayimu gagondera ebiragiro nʼamagambi gange.” ");
INSERT INTO nuj_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Olwʼehyo, Yisaka gamenya e Gerali. ");
INSERT INTO nuj_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Abaatu abomu hitehere ehyo ni bamubuusa ebiŋamba hu muhasi wuwe, gabagobolamo ati, “Oyo mboojo yange.” Ehyo gahiroma olwohuba gaali atya ohuloma ati, “Oyo muhasi wange.” Naŋeega ati, “Abaatu bomu hitundu hino baja hunjita olwa Labbeka olwohuba muhasi muŋoono.” ");
INSERT INTO nuj_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Aye ni ŋabitaŋo ehiseera, Abbimereki habaha wʼAbafirisuuti gaali mu dinisa lirye gaabona Yisaka nʼagudusa Labbeka mu ngeri eyiraga yiiti gaali muhasi wuwe. ");
INSERT INTO nuj_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ngʼaŋo Abbimereki alanga Yisaka amuloma ati, “Mu butuufu oweene, Labbeka muhasi wuwo! Lwahiina waloma oti mboojoyo?” Nga Yisaka amugobolamo ati, “Naloma tyo olwohuba naŋeega ti baaja hunjita hu lulwe bamuŋire.” ");
INSERT INTO nuj_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","NgʼAbbimereki amuloma ati, “Hiina hino ehi otuholire? Singa mulala hu baatu bange gaŋenyuha nʼomuhasi wuwo, hyahatuleeteeye endibo.” ");
INSERT INTO nuj_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ngʼaŋo Abbimereki aŋa abaatu bosibosi ehiragiro ati, “Omuutu yesiyesi, ajooga Yisaka oba omuhasi wuwe, aja hufa.” ");
INSERT INTO nuj_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Nga mu mwaha ogwo Yisaka alima mu hyalo ehyo emere, nga geeta ebiryo cikumi hu cikumi olwohuba Musengwa gamuŋa ekabi. ");
INSERT INTO nuj_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Yisaka gasuna obuŋinda era gatiina ni geeyongera ohusuna obuŋinda ohwola olu gaali muŋinda bugali weene. ");
INSERT INTO nuj_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Gasuna embusi nʼetaama nʼeŋombe ko nʼabeedu eduuli era ehyo hyagongeesa Abafirisuuti. ");
INSERT INTO nuj_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ehyo hyaleetera Abafirisuuti ohusiiha esobere eji beedu ba Yibbulayimu semwana bayaba, bajijusa eroba. ");
INSERT INTO nuj_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","NgʼAbbimereki aloma Yisaka ati, “Tuŋwere mu gwanga lyefe, ofuuhire wa hifuba ohutuhira.” ");
INSERT INTO nuj_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ngʼaŋo Yisaka aŋwaŋo atiina mu hiiho hyʼe Gerali geemeha eyo eweema jije, amenya omwo. ");
INSERT INTO nuj_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Nga Yisaka gegula bunyaha esobere eji bayaba Yibbulayimu semwana nʼahiiriŋo mulamu, atusamo eroba olwohuba Abafirisuuti baali baajiigala oluvanyuma lwa Yibbulayimu ohufa. Era gajiranga amasiina gaajo amahalehale aga semwana gajitaho. ");
INSERT INTO nuj_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Abeedu ba Yisaka nga bayaba esobere mu hiiho babona ni hirimo amaaji amalaŋi. ");
INSERT INTO nuj_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ne abaayi abomu Gerali baduhana nʼabaayi ba Yisaka baati, “Esobere eyo yeefe, siyenywe.” Olwʼehyo, Yisaka galanga esobere eyo ati Eseki olwohuba bayihaabira. ");
INSERT INTO nuj_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ngʼaŋo bayaba esobere eyindi era yoosi bayihaabira, ngʼayiranga ati Situna. ");
INSERT INTO nuj_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ngʼatiina mu hifo ehindi ayaba esobere eyindi aye yino ŋaaŋuma owayihaabira. Olwʼehyo, gayiranga ati Lekobbosi era ngʼaloma ati, “Ŋaahani Musengwa atugalamisye era huuja huhulahulana mu hyalo hino.” ");
INSERT INTO nuj_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ohuŋwa aŋo, gaŋamba engira gaatiina e Bberuseebba. ");
INSERT INTO nuj_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Nga mu wiire, Musengwa amubonehera amuloma ati, “Ndiise Hatonda wa lataawo Yibbulayimu. Otatya olwohuba ndi ni neewe era nja huhuŋa ekabi. Nja hwasa abejuhulu babo babe bangi olwa Yibbulayimu omuŋeeresa wange.” ");
INSERT INTO nuj_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Nga Yisaka atongola ehituuti ehyohuŋeeraho eŋongo, nga ajumiryanga Musengwa. Nga geemeha eweema mu hifo ehyo era ŋaweene aŋo abeedu babe bayabaŋo esobere eyindi. ");
INSERT INTO nuj_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Mu hiseera ehyo, Abbimereki ni meriiwe Akuzasi owamuŋanga amagesi ko ni Fikoli omuduumisi wʼeŋe lirye baŋwa e Gerali bahyalira Yisaka. ");
INSERT INTO nuj_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Nga Yisaka ababuusa ati, “Enywe mwambinga ewenywe, hiina ehi baleetire?” ");
INSERT INTO nuj_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Nga bamugobolamo baati, “Hiri ŋalafu ti Musengwa ali ni neewe. Cʼehyagima hwaloma huuti, ‘Hiraŋi ohuŋandiiha endagaano ŋagati weefe ni neewe.’ Leha huhole endagaano ni neewe ");
INSERT INTO nuj_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","huuti sooja hutuhola habi hosihosi ngʼolu hwesi hwahubisyanga bulaŋi ohwola olu hwabuhana miyaaya. Era ŋaahani Musengwa ahuŋaaye ekabi.” ");
INSERT INTO nuj_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ngʼaŋo Yisaka abanyiiyira embaga, balya era banywa. ");
INSERT INTO nuj_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ni wahya mu mugamba, nga bahola endagaano ŋagati waawe. Ngʼaŋo Yisaka abaseebula bagamayo miyaaya. ");
INSERT INTO nuj_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Oludaalo olwo, ngʼabeedu ba Yisaka batiina bamuŋayira ebiŋamba hu sobere eyi baali ni bayabire. Nga bamuloma baati, “Hwolire hu maaji.” ");
INSERT INTO nuj_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ngʼesobere eyo Yisaka ayitaho esiina ati Sibba era ehibuga ehiri ohuupi nʼesobere eyo njʼehigira bahiranga baati, Bberuseebba. ");
INSERT INTO nuj_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esawu ni gaali hu myaha ane, gahwa Yudeesi omuhaana wʼomusinde Omuhiiti oyu baali ni balanga baati Bbeeri. Ngʼahwa ni Bbasimaasi omuhaana wʼEloni yeesi Omuhiiti. ");
INSERT INTO nuj_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Abahaana abo bombi bafuuha higosi eyiri muhwe yaawe Yisaka ko ni masaala yaawe Labbeka. ");
INSERT INTO nuj_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Olwola, Yisaka nʼahayiriŋire era nʼohubona nʼatasobola hubona, gatumisa Esawu omusaani wuwe omuhulu, ngʼamuloma ati, “Mwana wange.” NgʼEsawu amugobolamo ati, “Wanji, Bbaabba.” ");
INSERT INTO nuj_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Nga Yisaka amuloma ati, “Ese sahuluŋire era natere ohufa. ");
INSERT INTO nuj_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ŋamba ahasaale otiine mwisugu wupiimire esolo. ");
INSERT INTO nuj_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ohene otegeheŋo emere eyahawoowo eyipomera, oyindetere ndye, kene kusabire ekabi ni tafa.” ");
INSERT INTO nuj_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Mu hiseera ehyo, Labbeka gaali aŋaatu nʼaŋulira Yisaka nʼaloma nʼomusaani Esawu. Esawu ni gatiina ohuŋiima, ");
INSERT INTO nuj_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","nga Labbeka aloma Yakobbo omwana wuwe ati, “Ewe! Pwahuŋulira lataawo nʼaloma mugandawo Esawu ati, ");
INSERT INTO nuj_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Tiina wupiimire esolo, otegeheŋo emere eyahawoowo, eyipomera ndye, kene kusabire ekabi mu moni ja Musengwa.’ ");
INSERT INTO nuj_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Olwʼehyo, mwana wange, ŋuliirisa bulaŋi weene ohole ehi kuloma. ");
INSERT INTO nuj_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Tiina wundeetere embusi ebiri eperepere era ejiboneha obulaŋi, piyiire lataawo emere emuŋomera. ");
INSERT INTO nuj_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ni yinaanye, ngʼoyiŋirira lataawo alye, gahahusabira ekabi nʼatafa.” ");
INSERT INTO nuj_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ne Yakobbo ngʼaloma nyina Labbeka ati, “Ohimanyire bulaŋi oti Esawu aliho amooya hu mubiri aye ese pumaaho. ");
INSERT INTO nuj_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ne singa Bbaabba ganjabaabaho, gafaania ati ndi humudulinga, nereetere hiŋwabo mu hifo hyʼekabi.” ");
INSERT INTO nuj_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Nga nyina amuloma ati, “Mwana wase, leha ehiŋwabo hibe hu ese. Hola ehi kuloma, tiina wundeetere ŋano embusi.” ");
INSERT INTO nuj_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Nga Yakobbo atiina mu lugo atusaamo embusi ebiri ajiŋirira nyina. Nga nyina anyiiya enyama enyene enoli. ");
INSERT INTO nuj_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Nga Labbeka aŋamba ebyambalo ebiraŋi ebyʼEsawu omwana wuwe omuhulu, ebyali mu nyumba, gambasa Yakobbo omwana wuwe omuŋere. ");
INSERT INTO nuj_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ngʼaŋamba ebyanjo ebi babaaga hu mbusi jira amuwiiha hu mihono nomu gosi. ");
INSERT INTO nuj_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ngʼaŋo aŋambya omwana wuwe oyo Yakobbo emere eyahawoowo eyi gaali nʼayiiyire. ");
INSERT INTO nuj_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Nga Yakobbo ayiŋirira semwana, amulanga ati, “Bbaabba.” Ngʼamugobolamo ati, “Oloma otye, mwana wange. Ewe, ndiiwe ani?” ");
INSERT INTO nuj_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Nga Yakobbo aloma semwana ati, “Ndiise Esawu omwana wuwo omudaayi. Kolire ngʼolu wundomire, yinyoha wihale, olye wahasabira ekabi.” ");
INSERT INTO nuj_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Nga Yisaka abuusa omusaani ati, “Nga soolweyo, mwana wange?” Nga niye amugobolamo ati, “Musengwa Hatonda wuwo gatangiriiye.” ");
INSERT INTO nuj_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ngʼaŋo Yisaka aloma Yakobbo ati, “Yigerera ŋano, kwabaabeho mwana wange, nahafaania mu butuufu, obanga ndiiwe Esawu mwana wange, oba bbe.” ");
INSERT INTO nuj_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Nga Yakobbo gigerera eyiri Yisaka semwana. Ni gamwabaabaho, ngʼaloma ati, “Ejanjaasi lya Yakobbo aye engalo jʼEsawu.” ");
INSERT INTO nuj_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Yisaka sigafaania ati nje Yakobbo, olwohuba emihono jije jaaliho amooya hyʼeja mugandawe Esawu, ehyaŋwamo ngʼamusabira ekabi. ");
INSERT INTO nuj_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ngʼamuloma ati, “Mu butuufu ndiiwe omwana wange Esawu?” Ngʼola amugobolamo ati, “Bbaabba, ndiise.” ");
INSERT INTO nuj_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Nga Yisaka amuloma ati, “Ale mwana wange, peerese enyama eyi oŋiimire ndye, kene kusabire ekabi.” Nga Yakobbo amuŋa alya, ngʼamuŋa nʼomwenge ogwʼemizabbibbu anywa. ");
INSERT INTO nuj_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Nga Yisaka semwana amuloma ati, “Yigerera wungwe mu hifuba, mwana wange.” ");
INSERT INTO nuj_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Nga gigerera amugwa mu hifuba. Yisaka ni gaŋunyira olusu lwʼebyambalo byʼEsawu, gamusabira ekabi ati, “O, ahaloosa hʼomwana wange hali hyʼahaloosa hʼendimiro eyi Musengwa aŋaaye ekabi.” ");
INSERT INTO nuj_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Hatonda ahuŋe hu olume oluŋwa mwigulu, ahuŋe nʼobuŋinda wohu hyalo, ebyohulya nʼohunywa. ");
INSERT INTO nuj_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Amawanga hu hyalo gahuŋeeresenga era nʼabaatu bahubbenga amafuha mu moni jijo, obe mwami eyiri abaganda babo. Era abasaani ba maawo bahuhubbire amafuha. Oyo ahuŋwaba himulonde omwene era ni nʼoyo ahuŋa ekabi abe wʼekabi. ");
INSERT INTO nuj_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Yisaka ko ni gaali ni gahaheneresa ohumusabira ekabi, Yakobbo nʼahiiri aŋo mu moni ja semwana, nga mugandawe Esawu goleraho nʼaŋwa mu huŋiima. ");
INSERT INTO nuj_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Era yeesi ngʼanyiiya enyama eyahawoowo, ayiŋirira semwana. Ngʼamuloma ati, “Bbaabba yinyoha, olye wahaapa ekabi.” ");
INSERT INTO nuj_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ngʼaŋo semwana amubuusa ati, “Ndiiwe ani?” Ngʼamugobolamo ati, “Ndiise Esawu omwana wuwo omudaayi.” ");
INSERT INTO nuj_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Yisaka gateetema bugali ngʼamuloma ati, “Njʼani atiinire gaŋiima esolo, gahena gandetera enyama? Pwahulya era nahamusabira ekabi ko ohene woole era aja hujisuna.” ");
INSERT INTO nuj_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esawu ni gaŋulira ebibono bya semwana, gatemuha gaalira nʼamaani nʼenaku nyingi, ngʼaloma semwana ati, “Keesi Bbaabba sabireho ekabi.” ");
INSERT INTO nuj_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Aye nga Yisaka amuloma ati, “Mugandawo gajire gandulinga era ahuŋirireho ekabi jijo.” ");
INSERT INTO nuj_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","NgʼEsawu aloma ati, “Sihyeŋunjisa olwohuba esiina lirye nje Yakobbo? Gandulingire emirundi ebiri: gaapiraho obusika wange era nindi aŋirire nʼekabi jange!” NgʼEsawu ahena abuusa semwana ati, “Ŋaŋumaŋo kabi ejindi josijosi?” ");
INSERT INTO nuj_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Nga Yisaka agobola mu Esawu ati, “Musabiiye ekabi ohuba musengwawo era abalebe babe baja huba baŋeeresa babe. Muŋaaye obuŋinda wohu hyalo nʼebyohulya nʼohunywa byosibyosi. Olwʼehyo, mwana wange, nahuholere hi?” ");
INSERT INTO nuj_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","NgʼEsawu abuusa semwana ati, “Bbaabba, oliŋo nʼekabi jengeri ndala yoŋene? Keesi Bbaabba sabireho ekabi.” Ngʼaŋo Esawu atemuha alira. ");
INSERT INTO nuj_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Nga semwana Yisaka amuloma ati, “Enyumba yiyo yinaabenga ŋaleeŋi nʼobuŋinda wohu hyalo, ŋaleeŋi nʼolume oluŋwa mwigulu ŋamugulu. ");
INSERT INTO nuj_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Oja huliiranga mu huŋiriŋana era oja huba muŋeeresa wa mugandawo. Aye nʼolisalaŋo ohuba wʼedembe, olimwetasulyaho ko atasobola huhuŋuga.” ");
INSERT INTO nuj_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","NgʼEsawu acaawa Yakobbo olwohuba semwana gamusabira ekabi ejaali ejohuba ejije. Ngʼaloma mu mwoyo gugwe ati, “Bbaabba njʼono ali huupi hufa. Kasita hulihena ebyʼohulira nga niita muganda yange Yakobbo.” ");
INSERT INTO nuj_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ne ni balomera Labbeka ebi Esawu omwana wuwe omudaayi gaali naŋeega, gatumisa Yakobbo omwana wuwe omuŋere, ngʼamuloma ati, “Esawu mugandawo, asala amagesi ohuhwita. ");
INSERT INTO nuj_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Olwʼehyo, mwana wange, hola ehi kuloma, duluma otiine e Harani ewa hoojaayo Labbaani, mboojo yange. ");
INSERT INTO nuj_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Obeeyo, ohwola olu mugandawo anaheese obusungu. ");
INSERT INTO nuj_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Mugandawo nʼanahabe ni gehiise obusungu, ni gerabiiye ehi wamuhola, nja hutuma omuutu ahulome ogobole. Sinenda hubafiirwa mwembi hu ludaalo lulala.” ");
INSERT INTO nuj_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ngʼaŋo Labbeka aloma Yisaka ati, “Ndembire esambo jʼabahaana Bahiiti, abahasi bʼEsawu. Yakobbo yeesi nʼanahaleete mulala hu bahaana Abahiiti mu gwanga lino, ohufa hunahabe husingira ohuba omulamu ni menya ŋalala ni nabo.” ");
INSERT INTO nuj_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ebyo ni byaŋwa, nga Yisaka atumisa Yakobbo, amulombera ekabi ngʼahena amuloma ati, “Soleetanga ŋano muhaana Mukanani ohuba muhasi wuwo. ");
INSERT INTO nuj_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Otiinanga e Padani Alaamu, ewa sehulu wuwo Bbesweri semwana ya maawo, osune omuhaana wa hoojaayo Labbaani, mboojo ya maawo. ");
INSERT INTO nuj_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Hatonda Omwene Buŋangi wosiwosi ahuŋe ekabi, ahufuule egwanga ebbala eryʼebiha ebyene ebingi. ");
INSERT INTO nuj_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Era ahuŋe ewe nʼabejuhulu babo ekabi eji gasuubisa Yibbulayimu, osikire ehyalo omu omenyire ngʼomuwuli. Ehyalo ehi Hatonda gaŋa Yibbulayimu.” ");
INSERT INTO nuj_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Yisaka ni gahena ohumulombera ekabi ngʼamuseebula atiine e Padani Alaamu ewa Labbaani, omusaani wa Bbesweri Omwalaamu, mboojo ya Labbeka, nyina ya Yakobbo nʼEsawu. ");
INSERT INTO nuj_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","NgʼEsawu afaania ngʼolu Yisaka galombera Yakobbo ekabi era gamusindiha ohutiina e Padani Alaamu, asune eyo omuhasi. Era ngʼolu gamusabira ekabi gahena gamuhamirisa ati, “Soleetanga ŋano muhaana Mukanani ohuba muhasi wuwo.” ");
INSERT INTO nuj_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Era gahitegeera ati Yakobbo gagondera semwana ni nyina gatiina e Padani Alaamu, ");
INSERT INTO nuj_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ngʼEsawu ko ahifaania ati Yisaka semwana gaali sigenda abahasi Bakanani. ");
INSERT INTO nuj_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ngʼaŋo aŋamba engira atiina ewa Yisimayiri, ngʼahwa Mahalasi ohuba muhasi wuwe. Mahalasi oyo, gaali mboojo ya Nebbayoosi omusaani wa Yisimayiri, omusaani wa Yibbulayimu. Ehyo gahihola, ni gongesa hu bahasi aba gaali ni naabo. ");
INSERT INTO nuj_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ŋaahani Yakobbo ni gaŋwa e Bberuseebba gaŋamba olugendo gasimba olwʼe Harani. ");
INSERT INTO nuj_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ni goola aŋaatu, gasalaŋo aŋenyuhe aŋo olwohuba esaawa yaali yiguuye mu maaji, gaŋenyuha aŋo owiire owo. Gaŋamba erala hu mabaale mu hifo ehyo, nga geŋigiha, aŋenyuha. ");
INSERT INTO nuj_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ni gaali nʼaŋenyuha ngʼaloota. Mu hirooto ehyo, gabona amadaala ameene amaleeŋi ni goola mwigulu nʼabamalayika ba Hatonda ni baniinuha era ni baniina. ");
INSERT INTO nuj_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Era ŋamugulu wamadaala ago, Musengwa ni gemeereye, ngʼaloma ati, “Ndiise Musengwa Hatonda ya sehulu wuwo Yibbulayimu era Hatonda wa Yisaka. Nja huhuŋa ewe nʼabejuhulu babo eroba eryo aŋoŋenyuhire. ");
INSERT INTO nuj_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Abejuhulu babo baja huba hyʼomujehe ni batabaliha era baja husalaaniha ohuŋwa ebuŋwalyuba ohwola ebugwalyuba, ohuŋwa mu maniino ohwola mu mehiriro. Abaatu bosibosi hu hyalo balisuna ekabi ohubitira mu ewe nʼabejuhulu babo. ");
INSERT INTO nuj_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Nja huba ŋalala ni neewe era nahuhuumenga hiisi aŋa anaajenga era ndi hugobosa mu gwanga lino. Sindihulehulira ohwola olu ndyoheresa ehi suubisa.” ");
INSERT INTO nuj_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakobbo ni gasisimuha mwiro, galoma ati, “Mu butuufu, Musengwa ali mu hifo hino aye mbaye sikimanyire.” ");
INSERT INTO nuj_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Gatya, ngʼaloma ati, “Ngʼehifo hino hitiisa! Ehifo hino sihiitu hindi ohutusaho nyumba ya Hatonda era ŋano ŋaliŋo omulyango oguja mwigulu.” ");
INSERT INTO nuj_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ni wahya mu mugamba pwipwipwi, Yakobbo gaŋamba ebaale eri gaali ni geŋigihire, galihomeha aŋo hyʼehihondo ohuba ahabonero ahohuhebuliriraho, ngʼahena alijuhaho amafuta agahaloosa. ");
INSERT INTO nuj_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ngʼehifo ehyo ahiguliha esiina ati Bbeseeri, wayire ngʼehibuga ehyo baali bahiranga baati Luuzi. ");
INSERT INTO nuj_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Nga Yakobbo geeyama ati, “Hatonda nʼanabenga ŋalala ni neese era gakuuma mu lugendo luno, gaapa ebyohwambala nʼebyohulya, ");
INSERT INTO nuj_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ehiseera hyola nagamayo engo ewa Bbaabba miyaaya, Musengwa aja huba Hatonda wange, ");
INSERT INTO nuj_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","nʼebaale lino eri komire ohuba ehihondo ehyʼohuhebulirirangaho, lija huba nyumba ya Hatonda era hiisi ehi wuupa, keesi nja huhuŋangaho hirala ehyʼehumi.” ");
INSERT INTO nuj_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ngʼaŋo Yakobbo geyongera nʼolugendo, atiina goola mu gwanga eriri ebuŋwalyuba. ");
INSERT INTO nuj_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ngʼabona esobere aŋadulere, ebidooli byʼetaama bidatu ni bigandaaye aŋo olwohuba paŋa janyweranga. Ebaale eri batambisanga ohuwiiha hu sobere lyali bbala. ");
INSERT INTO nuj_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Abaayi ni bahahenire ohuhumbaania etaama ngʼolu kola yaawe yaali, nga baŋiringisya ebaale eryo balitusa hu munwa gwʼesobere nga bajinywesa. Oluvanyuma nga baligobosaŋo hu munwa gwʼesobere. ");
INSERT INTO nuj_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Nga Yakobbo abuusa abaayi ati, “Balebe bange, muŋwera ŋe?” Nga bamugobolamo baati, “Huŋwera e Harani.” ");
INSERT INTO nuj_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ngʼababuusa ati, “Mumanyire Labbaani omwijuhulu wa Naholi?” Nga bamugobolamo baati, “E e, humumanyire.” ");
INSERT INTO nuj_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Nga Yakobbo ababuusa ati, “Aliyo mulaŋi?” Nga bamugobolamo baati, “Aliyo mulaŋi era Lakeeli omuhaana wuwe njʼoyo owuuja nʼetaama.” ");
INSERT INTO nuj_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ngʼabaloma ati, “Guhiiri muusi ohuhumbaania ebyayo ohuŋenyuha. Mujinywese muhene mujagamyeyo mu hyayo.” ");
INSERT INTO nuj_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Nga bamugobolamo baati, “Sihuhola huutyo, husooka huhumbaania etaama josijosi ko hwaŋiringisya ebaale hwalitusa hu munwa gwʼesobere nga ko josijosi jinywa omulundi mulala.” ");
INSERT INTO nuj_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ni gaali nʼahiroma ni nabo, nga Lakeeli goola nʼetaama ja Labbaani olwohuba njʼowajeemeranga. ");
INSERT INTO nuj_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakobbo ni gabona Lakeeli omuhaana wa Labbaani mboojo ya nyina nʼetaama, gatiina ngʼaŋiringisya ebaale alitusa hu munwa gwʼesobere, ngʼanywesa etaama ja hoojaye. ");
INSERT INTO nuj_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Nga Yakobbo agwa Lakeeli mu hifuba, ngʼatandiha nʼohulira. ");
INSERT INTO nuj_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Gaali alomeeye Lakeeli ati mulebe ya semwana era musaani wa Labbeka. Olwʼehyo, Lakeeli gadduluma embiro gatiina engo galomera semwana. ");
INSERT INTO nuj_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Aŋo ni naaŋo, ni balomera Labbaani hu Yakobbo omwana wa mboojo, gaduluma ohuja ohwagaanana ni naye. Ni goola ngʼamugwa mu hifuba, ngʼamufumberera era ngʼahena amuŋira engo. Nga Yakobbo alomera Labbaani byosibyosi ebimufaho. ");
INSERT INTO nuj_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Nga Labbaani amuloma ati, “Mu butuufu, oli mafugi era mubiri gwange.” Oluvanyuma lwa Yakobbo ohumenya ni Labbaani omwesi mulala, ");
INSERT INTO nuj_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labbaani galoma Yakobbo ati, “Olwohuba oli mulebe yange oli nʼohuutambira huwereere? Ndomere, kusasulenga jinga?” ");
INSERT INTO nuj_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labbaani gaali nʼabahaana babiri, omuhulu gaali nje Leeya, omuŋere gaali nje Lakeeli. ");
INSERT INTO nuj_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leeya gaali aheja bulaŋi aye Lakeeli gaali muŋoono era nʼasangaasa. ");
INSERT INTO nuj_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakobbo gasiima Lakeeli, ngʼaloma hoojaye ati, “Nja huhutambira emyaha musanvu wuupe Lakeeli omuhaana wuwo omuŋere.” ");
INSERT INTO nuj_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Nga Labbaani amuloma ati, “Mala gahuŋa ewe ohuhira ohumuŋa omuutu owundi. Ba ŋano ni nange.” ");
INSERT INTO nuj_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Olwʼehyo, Yakobbo gatamba emyaha musanvu bamuŋe Lakeeli aye jafaanana hyʼendaalo enyene endiidiri olwʼohwenda ohu gaali nʼamwendamo. ");
INSERT INTO nuj_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Emyaha omusanvu ni jaŋwaho, nga Yakobbo aloma Labbaani ati, “Ŋaahani pe omuhasi wange olwohuba endaalo jange ejohutamba jiŋooyeho. Nenda ohuba ni naye.” ");
INSERT INTO nuj_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Olwʼehyo, Labbaani gahumbaania abaatu bosibosi abomu hitehere ehyo, ngʼanyiiya embaga. ");
INSERT INTO nuj_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Aye egulo ni lyola, gaŋamba Leeya omuhaana wuwe omuhulu gaaba njʼoyu amuŋa era nga Yakobbo aŋenyuha ni naye! ");
INSERT INTO nuj_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Nga Labbaani aŋamba Zilupa omwidu wuwe amuŋa Leeya omuhaana wuwe, ohuba omwidu.) ");
INSERT INTO nuj_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ni wahya mu mugamba, Yakobbo ngʼahifaania ati bamuŋaaye nje Leeya mu hifo hya Lakeeli. Olwʼehyo, Yakobbo gatiina eyiri Labbaani gamuloma ati, “Hino hiina ehi wakolire? Sinahutambira wuupe Lakeeli? Lwahiina wandulingire?” ");
INSERT INTO nuj_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Nga Labbaani amugobolamo ati, “Efe ŋano sipohuhola huutyo, ohugaba omuhaana omuŋere ni huhiiri hugaba omudaayi. ");
INSERT INTO nuj_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Hena endaalo musanvu ejʼobugole wʼoyo, ko huhuŋe obundi nindi wutambire emyaha omusanvu.” ");
INSERT INTO nuj_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Nga Yakobbo ahola atyo. Gahena endaalo musanvu ni Leeya nga Labbaani amuŋa Lakeeli omuhaana wuwe ohuba muhasi wuwe. ");
INSERT INTO nuj_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Nga Labbaani aŋamba Bbiluha amuŋa Lakeeli omuhaana wuwe ohuba mwidu wuwe. ");
INSERT INTO nuj_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Nga Yakobbo aŋenyuha ni Lakeeli yeesi era nga genda Lakeeli ohuhira Leeya. Era ngʼatambira Labbaani nindi emyaha musanvu ejindi. ");
INSERT INTO nuj_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Musengwa ni gabona Leeya nʼali nabunobe, gamuŋa olusaaye aye Lakeeli gaali mugumba. ");
INSERT INTO nuj_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Nga Leeya aba hida, asaala omwana museere ngʼamulanga ati Lubbeeni olwohuba galoma ati, “Musengwa aweene enaku yange. Mu butuufu wamwange ŋaahani aja hunyenda.” ");
INSERT INTO nuj_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Nga nindi aba hida asaala omwana museere, ngʼaloma ati, “Olwohuba Musengwa amanyire ati wamwange siganyenda, gapaaye ono yeesi.” Olwʼehyo, ngʼamulanga ati Simyoni. ");
INSERT INTO nuj_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Nga nindi asuna ehida, asaala omwana museere, ngʼaloma ati, “Hu luno wamwange aja huholagana ni nange, olwohuba musaaliiye abaana abaseere badatu.” Ngʼamutaho esiina ati Leevi. ");
INSERT INTO nuj_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Nga nindi Leeya aba hida asaala omwana museere, ngʼaloma ati, “Omulundi guno nja hujumirya Musengwa.” Olwʼehyo, galanga omwana oyo ati Yuda. Ngʼahoma aŋo ohusaala. ");
INSERT INTO nuj_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Lakeeli ni gabona nʼatasaalira Yakobbo abaana, gaŋambira mugandawe esaalwa, ngʼaloma Yakobbo ati, “Pe abaana, oba sicehyo fe pwe hu hyalo!” ");
INSERT INTO nuj_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ngʼehyo hisunguŋasa Yakobbo ngʼamuloma ati, “Ndiise Hatonda owahwima olusaaye?” ");
INSERT INTO nuj_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Nga Lakeeli aloma Yakobbo ati, “Kuŋaaye Bbiluha omwidu wange, ohufuuha muhasi wuwo, ŋenyuha ni naye gahasaalira abaana, keesi nahabaaho nʼolulyo.” ");
INSERT INTO nuj_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Nga Lakeeli aŋamba Bbiluha omwidu wuwe aŋa Yakobbo ohufuuha muhasi wuwe. Era nga Yakobbo aŋenyuha ni naye. ");
INSERT INTO nuj_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Nga Bbiluha aba hida, asaalira Yakobbo omwana museere. ");
INSERT INTO nuj_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Nga Lakeeli aloma ati, “Hatonda aŋuliiye ohusaba hwange, gaapa omwana omuseere.” Cʼehyagira gamulanga esiina ati Daani. ");
INSERT INTO nuj_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bbiluha omwidu wa Lakeeli ngʼaba hida nindi, ngʼasaalira Yakobbo omwana omuseere owohubiri. ");
INSERT INTO nuj_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Nga Lakeeli aloma ati, “Piriŋeene nʼamaani ni muganda yange era muhirire.” Ngʼomwana oyo amulanga esiina ati Nafutaali. ");
INSERT INTO nuj_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leeya ni gabona nʼahomire aŋo ohusaala, ngʼaŋamba Zilupa omwidu wuwe, amuŋa Yakobbo ohufuuha muhasi wuwe. ");
INSERT INTO nuj_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Nga Zilupa omwidu wa Leeya asaalira Yakobbo omwana museere. ");
INSERT INTO nuj_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Nga Leeya aloma ati, “Nga ndi nʼekabi!” Ngʼomwana oyo amulanga esiina ati Gaadi. ");
INSERT INTO nuj_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Nga Zilupa omwidu wa Leeya asaalira Yakobbo omwana omuseere owohubiri. ");
INSERT INTO nuj_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Nga Leeya aloma ati, “Hino hisangaahiise! Era abahasi baaja hundanga wasangaalo.” Ngʼamulanga esiina ati Aseri. ");
INSERT INTO nuj_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Lulala mu hiseera hyʼohugesa engaano, Lubbeeni gatiina mu ndimiro yʼengaano, ngʼagwirihirira ehimera ehi balanga baati mandulake, ngʼaŋirira nyina Leeya. Ngʼaŋo Lakeeli aloma Leeya ati, “Peeho mandulake yʼomwana wuwo.” ");
INSERT INTO nuj_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Nga Leeya aloma Lakeeli ati, “Ehyohunyagaho wamwange sihihuhena, wenda humeedaho nʼohuutusaho mandulake yʼomwana wange?” Ngʼaŋo Lakeeli amugobolamo ati, “Ale ha huswane. Ewe peeho mandulake yʼomusaani wuwo, kulehere Yakobbo aŋenyuhe ni neewe owiire wolwa leero.” ");
INSERT INTO nuj_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Olwʼehyo, Yakobbo ni gagamayo engo ehyʼegulo nʼaŋwa mu ndimiro, Leeya gamuloma ati, “Oli nʼohuŋenyuha ni neese owiire wolwa leero olwohuba kugulire ni mandulake yʼomusaani wange ohuhutusa hu Lakeeli omuhasi wuwo.” Nga Yakobbo aŋenyuha ni naye ehiire ehyo. ");
INSERT INTO nuj_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Nga Hatonda aŋulira ohusaba hwa Leeya. Nga Leeya aba hida, asaalira Yakobbo omwana omuseere owohutaanu. ");
INSERT INTO nuj_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Nga Leeya aloma ati, “Hatonda gapaaye omuhemba, olwohuba naŋa wamwange omwidu wange.” Ngʼomwana oyo amulanga ati Yisikaali. ");
INSERT INTO nuj_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Nga nindi Leeya aba hida, asaalira Yakobbo omwana omuseere owomukaaga. ");
INSERT INTO nuj_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ngʼaŋo Leeya aloma ati, “Hatonda gapaaye ehirabo ehyʼomuŋendo. Hu luno wamwange aja humbisyanga bulaŋi olwohuba musaaliiye abaana mukaaga abaseere.” Ngʼomwana oyo amulanga Zebbulooni. ");
INSERT INTO nuj_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Oluvanyuma gasaala omwana omuhaana, ngʼamulanga ati Dina. ");
INSERT INTO nuj_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ngʼaŋo Hatonda ahebulira Lakeeli, aŋulira ohusaba huhwe ngʼamwigula ehida. ");
INSERT INTO nuj_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ngʼaba hida asaala omwana omuseere ngʼaloma ati, “Hatonda gatuhiseeho eduho.” ");
INSERT INTO nuj_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ngʼomwana oyo amulanga ati Yosefu, nʼaloma ati, “Musengwa ganyongeyeho omwana owundi omuseere.” ");
INSERT INTO nuj_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Oluvanyuma lwa Lakeeli ohusaala Yosefu, nga Yakobbo aloma Labbaani ati, “Kusunga wuseebule, nagame e weefe. ");
INSERT INTO nuj_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Mbaye mutambi wuwo era ni kalabana, ne ngʼolu hiseera hyolire, fugiirire tiine nʼabahasi ko nʼabaana bange.” ");
INSERT INTO nuj_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Aye Labbaani gamuloma ati, “Kusunga wupambire ehisa osigale, endagu yindomeeye yiiti Musengwa gapaaye ekabi olwʼewe.” ");
INSERT INTO nuj_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ngʼahena amuloma ati, “Wenda kusasule hiina? Loma hyosihyosi ehi wenda nahusasule?” ");
INSERT INTO nuj_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Nga Yakobbo amuloma ati, “Omanyire ngʼolu mbayenga ni kuhalabanira era ebyayo bibyo byeyongeye. ");
INSERT INTO nuj_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ebitono ebi waali ni nabyo byeyongeye obungi era Musengwa ahuŋaaye ekabi hiisi aŋambayenga ni naayira ebyayo. Ŋaahani keesi njʼehiseera ohulabirira ebyange.” ");
INSERT INTO nuj_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Nga Labbaani amubuusa ati, “Wenda kuŋe hi?” Nga Yakobbo amugobolamo ati, “Mbula ehi kwendaho aye kusunga wuupe ehiitu hirala hyoŋene. Era nʼoja huhihola, nja hweyongera ohwemera nʼohulabirira ebyayo bibyo. ");
INSERT INTO nuj_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Fugiirire ngende mu taama nʼembusi jijo josijosi, ni tusamo hiisi erimo ebihosa nʼebimali nʼeyamasosogo. Ebyo njʼebija huba omuhemba gwange. ");
INSERT INTO nuj_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Mu moni eyo oja humanya owesigwa wange. Era singa wagaanamo eyitali yamasosogo oba eŋumamo ebihosa nʼebimali, eyo eja huba ya wiibi.” ");
INSERT INTO nuj_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Nga Labbaani aloma ati, “Fugiiriye, leha hibe ngʼolu olomire.” ");
INSERT INTO nuj_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Nga hu ludaalo olwo, Labbaani aŋamba embusi epaya ejoluwombye nʼejamatonatona nʼekasi josijosi ejamasosogo nʼejamatonatona, hiisi ejaliho ebala ehosa, ko nʼetaama enando josijosi, ngʼajiŋa abasaani babe ne ni jiri ja Yakobbo. ");
INSERT INTO nuj_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Nga Labbaani niye nʼabaana baŋamba ebisolo ebyo bagenda olugendo olwʼendaalo edatu ohuŋwa aŋa Yakobbo gaali. Yakobbo niye gasigala ni gemera etaama nʼembusi ja Labbaani. ");
INSERT INTO nuj_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Nga Yakobbo aŋamba obusaala bwʼomulibine omubisi, nʼowomusakedi nʼowomwalamoni, nga gobulaho emisitaale emihosa, ne sigaheneraho moola. ");
INSERT INTO nuj_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ngʼaŋamba obusaala owo obu gaŋalagataho mu biitu ebi taama nʼembusi janywerangamo amaaji, jibubone ni jiija ohunywa amaaji. ");
INSERT INTO nuj_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Etaama nʼembusi ejo nga jeruhiranga mu moni jʼobusaala owo, nga jisaala enyana ejoluwombye nʼebitonatona. ");
INSERT INTO nuj_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Mu hiseera ohyohwiruha, Yakobbo gawulanga ekasi ŋa joŋene ngʼajirengeresa ejoluwombye nʼejebimali. Nga jisaala enyana ejamasosogo nʼejebimali ngʼahena ajabula hu ja Labbaani. Mu ngeri eyo, ebyayo bibye byeyongera obungi. ");
INSERT INTO nuj_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Etaama nʼembusi ejʼamaani ni jendanga ohwiruha, Yakobbo gaŋambanga obusaala gabuta mu moni waajo, ohweruhira aŋali obusaala owo. ");
INSERT INTO nuj_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Aye etaama nʼembusi eniambiniambi ni jendanga ohwiruha, ngʼabutusaŋo. Etaama eniambiniambi gajiŋanga Labbaani, ne ejʼamaani jatiinanga hu luda lwa Yakobbo. ");
INSERT INTO nuj_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Mu ngeri eyo, nga Yakobbo geeyongera bugali ohuhulahulana, ngʼaba nʼebisolo bingi nʼabeedu abahasi nʼabasinde nʼengamiya ko ni nasugirya. ");
INSERT INTO nuj_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ehiseera hyola Yakobbo gaŋulira ati abasaani ba Labbaani baali bemulugunya baati, “Yakobbo aŋirire obuŋinda wa Bbaabba wosiwosi era agagaŋaliiye mu biitu bya Bbaabba.” ");
INSERT INTO nuj_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Era Yakobbo gabona Labbaani nʼatamuheja bulaŋi. ");
INSERT INTO nuj_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Nga Musengwa aloma Yakobbo ati, “Yagamayo mu hyalo hyʼabasehulu nʼabalebe babo, naabenga ŋalala ni neewe.” ");
INSERT INTO nuj_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ngʼaŋo Yakobbo atuma bamulangira Lakeeli ni Leeya batiine mu hyayo eyi gaali. ");
INSERT INTO nuj_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ngʼabaloma ati, “Mu ndaalo jino, mbona engeri eyi senywe gakeja, sinje eyabulijo aye Hatonda wa Bbaabba ali ni nange. ");
INSERT INTO nuj_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Era muhimanyire ngʼolu tambiiye senywe nʼamaani gange gosigosi. ");
INSERT INTO nuj_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Wayire senywe gakolakolanisye emirundi nʼemirundi aye Hatonda sigamuganya hukola habi hosihosi. ");
INSERT INTO nuj_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ni gahalomire ati, ‘Ejamasosogo njʼejinaabenga omuhemba gugwo,’ ngʼetaama nʼembusi josijosi jisaala ejamasosogo. Ngʼaŋo acuusa ati, ‘ejamawombwe njʼejinaabenga omuhemba gugwo,’ nga nindi etaama nʼembusi josijosi jitandiha ohusaala ejamawombwe. ");
INSERT INTO nuj_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Mu ngeri eyo, Hatonda abatuhiiseho ebyayo, gabiipa. ");
INSERT INTO nuj_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Mu mwesi ogu etaama nʼembusi jitera ohweruhiramo, nasuna ehirooto era mu hirooto omwo, nabona embusi epaya ejerusanga ni jiri jamawombwe nʼejamasosogo neja matonatona. ");
INSERT INTO nuj_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Nga Malayika wa Hatonda mu hirooto gandanga ati, ‘Yakobbo,’ ngʼamugobolamo ti, ‘Wanji Musengwa.’ ");
INSERT INTO nuj_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Nga gandoma ati, ‘Gangamusa emoni jijo obone embusi josijosi epaya ejerusa, jamawombwe nʼejamasosogo, neja matonatona olwohuba mbona byosibyosi ebi Labbaani ahuhola. ");
INSERT INTO nuj_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ndiise Hatonda owahubonehera e Bbeseeri, aŋa wajuha amafuta ngʼehihondo ehyʼohuhebulirirangaho era wahena wahola oweyamo. Nenda oŋwe mu hyalo hino ogoboleyo ewenywe eyi bahusaala.’ ” ");
INSERT INTO nuj_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Nga Lakeeli ni Leeya bamugobolamo baati, “Huŋuma mugabo hu buŋinda wa Bbaabba. ");
INSERT INTO nuj_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Atuŋira hyabagwira olwohuba gatutunda era nʼebiitu gahena hale ohubirya. ");
INSERT INTO nuj_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Mu butuufu obuŋinda wosiwosi obu Hatonda atuhiise hu seefe, weefe nʼabaana beefe. Olwʼehyo, hola ehi Hatonda ahuloma ohuhola.” ");
INSERT INTO nuj_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ngʼaŋo Yakobbo getegeha ohwagamayo ewaawe, ngʼaŋamba abaana nʼabahasi babe abata hu ngamiya, ");
INSERT INTO nuj_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ngʼahubba ebyayo bibye byosibyosi ko nʼebiitu byosibyosi ebi gasuna ni gaali nʼahiiri e Padani Alaamu. Ngʼaŋamba engira ohutiina e Kanani eyi Yisaka semwana gaali nʼamenyire. ");
INSERT INTO nuj_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ehiseera ehi basimbuhiramo, Labbaani gaali atiinire ohusala hu taama jije amooya. Kale nga Lakeeli atambisa ekabi eyo ohwiba abagasani ba semwana. ");
INSERT INTO nuj_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Mu ngiso, Yakobbo gategeha nga geyiba hu Labbaani Omwalaamu. Sigalomeraho Labbaani ati gaali genda hwagama ewaawe. ");
INSERT INTO nuj_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ngʼaŋo Yakobbo nʼebibye byosibyosi amweyibaho, atiina gambuha olwabi Yufuleeti, ngʼaluŋama atiina e Giliyaadi mu hyalo ehyʼesozi. ");
INSERT INTO nuj_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Oluvanyuma lwʼendaalo edatu, nga balomera Labbaani baati Yakobbo gamudulumaho. ");
INSERT INTO nuj_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Nga Labbaani nʼabalebe babe baŋamba engira balonda hu Yakobbo. Hu ludaalo olwomusanvu, nga bamwolaho e Giliyaadi mu hyalo ehyʼesozi. ");
INSERT INTO nuj_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Nga Hatonda abonehera Labbaani Omwalaamu mu hirooto owiire amuloma ati, “Wehuume ohutaloma ehiraŋi oba ehibi hu Yakobbo.” ");
INSERT INTO nuj_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yakobbo gaali gemeehire eweema yiye e Giliyaadi mu hyalo ehyʼesozi, Labbaani nʼabalebe babe ni boola nga boosi bemeha aŋo ejaawe. ");
INSERT INTO nuj_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Nga Labbaani aloma Yakobbo ati, “Wukolire hi, ohweyiba weyibe ni tamanyire. Ese ndiise owohudulinga, ngʼohena wiibahwiba nʼabahaana bange hyababanyagire mu lutalo? ");
INSERT INTO nuj_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Lwahiina waŋwayo mu ngiso? Lwahiina siwandomeraho nahola omukolo nahuseebula bulaŋi nʼebivuga? ");
INSERT INTO nuj_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Wagira siseebuleho bahaana nʼabejuhulu bange? Wahola hyabuŋubeebe. ");
INSERT INTO nuj_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ndi nʼobuŋangi ohuhukosa aye mu hirooto owiire, Hatonda wa lataawo gandomire ati, ‘Wehuume ohutaloma ehiraŋi oba ehibi hu Yakobbo.’ ");
INSERT INTO nuj_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Manyire ti otiina olwohuba oŋemba ohwagama ewenywe. Aye lwahiina mwiba abagasani bange?” ");
INSERT INTO nuj_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Nga Yakobbo agobola mu Labbaani ati, “Sinahulomera olwohuba natya, ni peega ti oja hutusaho abahaana babo. ");
INSERT INTO nuj_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Aye singa obona omuutu yesiyesi nʼali nʼabagasani babo, saaja husigala nʼali mulamu. Abalebe beefe ni babona, yendula ehyihyo hyosihyosi, onahyagaana hiŋire.” Yakobbo galoma atyo olwohuba gaali samanyire Lakeeli ni geeba abagasani ba semwana. ");
INSERT INTO nuj_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Nga Labbaani atiina gendula mu weema ya Yakobbo nomu ya Leeya nomu ja bahasi abeedu bombi aba bahaana babe aye sigagaanamo hiitu hyosihyosi. Ni gaŋwa mu weema ya Leeya, nga atiina gengira mu weema ya Lakeeli ohwendulamo mwosi. ");
INSERT INTO nuj_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Lakeeli gaali gebire abagasani ba semwana nʼabataaye mu hisaŋu hyohu ngamiya, ngʼahena ahibundalaho. Labbaani gendula mu weema yosiyosi aye sigabonamo hiitu hyosihyosi. ");
INSERT INTO nuj_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Nga Lakeeli aloma semwana ati, “Musengwa yange otanduŋira olwʼohutemeerera nahuŋa efaasi wendula. Hiri hiityo olwohuba ndi mu songa yeefe eyabahasi.” Labbaani gendula aye sigabona bagasani babe. ");
INSERT INTO nuj_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ehyo hyaluŋia Yakobbo. Ngʼabuusa Labbaani ati, “Sobisye hi? Kolire hibi hi ehigimire wapiima oti? ");
INSERT INTO nuj_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Osinguuye ebiitu byange byosibyosi, hiina ehi oweene hu biitu byosibyosi ebyomu nyumba? Hireete ŋano mu moni jʼabalebe babo nʼabange, batusalire omusango fembi. ");
INSERT INTO nuj_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Mbaye ni neewe emyaha abiri, etaama nʼembusi jijo sijisumulangaho, nʼohulya sindyangaho emiigu yiyo kadi ndala. ");
INSERT INTO nuj_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Sikuleeterangaho hyayo hihyo hyosihyosi ehi solo yalya. Era esolo ni yalyangaho ndala, nasasulanga. Era wakazanga ohusasula ehiitu hyosihyosi ehyagotanga. ");
INSERT INTO nuj_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Omumwi gwapwerangaho omuusi gwosigwosi, embeŋo yafuuŋa owiire wuli huno era sinalimbanga hwiro. ");
INSERT INTO nuj_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Hibaaye hiityo emyaha ejo abiri josijosi ejimbereeyemo mu mago gago. Kutambiiye emyaha ehumi nʼene ohuŋira bahaana babo bombi, ohwo gataho emyaha mukaaga ohuŋira ebisolo era hiisi hiseera obaayenga ocuusacuusania omuhemba gwange. ");
INSERT INTO nuj_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Singa Hatonda wa Bbaabba Yisaka ni sehulu yange Yibbulayimu, abanga nʼatali ni neese, hani nahaŋooye ewuwo nʼemihono myereere. Aye Hatonda gabona ohufabiina hwange era owiire ahulomire ohwehuuma ohutandomaho hiraŋi oba ehibi.” ");
INSERT INTO nuj_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ngʼaŋo Labbaani amugobolamo ati, “Abahaana aba olomaho, bahaana bange era nʼabaana baawe baana bange, etaama nʼembusi, byayo byange. Byosibyosi ebiri ŋano byange. Aye ŋaahani ŋaŋuma ehi panga ohuhola ohweyongera ohuhuuma abahaana bange bano oba abaana baawe? ");
INSERT INTO nuj_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ŋaahani huhole endagaano ŋagati weese ni neewe ohuba bujulizi.” ");
INSERT INTO nuj_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Nga Yakobbo aŋamba ebaale ngʼehihondo ehyʼohuhebulirirangaho, alihomeha ohuba ehyʼohuhebulirirangaho. ");
INSERT INTO nuj_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ngʼaloma abalebe babe ati, “Muhumbaanie amabaale.” Nga bahumbaania amabaale bawungiha etuumo, nga baliira aŋo emere. ");
INSERT INTO nuj_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Nga Labbaani alanga etuumo eryo ati, “Yegali Sahadusa,” Yakobbo niye galiranga ati, “Galeedi.” ");
INSERT INTO nuj_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Nga Labbaani aloma Yakobbo ati, “Etuumo yino bujulizi ŋagati weese ni neewe.” Cʼehyagira ehifo ehyo bahiranga Galeedi. ");
INSERT INTO nuj_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Nindi bahiranga baati “Mizupa” olwohuba galoma ati, “Musengwa abonanga ehitiina mu moni ŋagati wange ni neewe hiisi muutu nʼatiinire eyi aba. ");
INSERT INTO nuj_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Nʼobisyanga abahaana bange bubi oba nʼoleetanga abahasi abandi ohugaata hu bahaana bange, wayire ŋaŋuma muutu yesiyesi ohundomera, ohebuliranga oti Hatonda aliŋo era mujulizi ŋagati wange ni neewe.” ");
INSERT INTO nuj_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ngʼaŋo Labbaani ameedaho aloma Yakobbo ati, “Etuumo eyʼamabaale yino eyi komehire, bujulizi ŋagati wange ni neewe. ");
INSERT INTO nuj_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Etuumo yino nʼamabaale gano gaja huba obujulizi ti sindiŋwa ewange natuuma etuumo yino ohuhulumba ohuhuholaho ehibi era ti weesi sooliŋwa ewuwo ohukolaho obubi. ");
INSERT INTO nuj_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Leha Hatonda wa Yibbulayimu ni Naholi nʼabasaawe, abe njʼomulamuzi ŋagati weefe.” Ngʼaŋo Yakobbo alayira nʼatya Hatonda wa semwana Yisaka. ");
INSERT INTO nuj_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Nga Yakobbo aŋaayo eŋongo nʼali eyo mu hyalo ehyʼesozi ngʼahena alanga abalebe babe ohulya emere era baahena baŋenyuha eyo owiire owo. ");
INSERT INTO nuj_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ni wahya mu mugamba, nga Labbaani agwa abahaana nʼabejuhulu babe mu hifuba, abaŋa ekabi abaseebula. Ngʼaŋo abaleeha gagamayo e wuwe. ");
INSERT INTO nuj_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Oluvanyuma nga Yakobbo geyongerayo mu lugendo lulwe. Nga ŋabaŋo abamalayika ba Hatonda abaagaanana ni naye. ");
INSERT INTO nuj_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakobbo ni gababona galoma ati, “Yino kambi ya Hatonda.” Ngʼalanga ehifo ehyo ati Mahanayimu. ");
INSERT INTO nuj_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Nga Yakobbo atuma abahwenda ohutangiramo batiine mu hyalo hyʼe Seyiri egwanga lyʼEdomu eyiri Esawu mugandawe. ");
INSERT INTO nuj_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ngʼaloma ati, “Mutiine mulome Esawu musengwa yange muuti, ‘Ese Yakobbo omwidu wuwo mbaye menyire ni Labbaani ohwola hatyane. ");
INSERT INTO nuj_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Sunire eŋombe ni nasugirya nʼetaama nʼembusi nʼabeedu abahasi nʼabasinde. Ŋaahani pindiiha obuhwenda buno ni nenda wupambire ehisa.’ ” ");
INSERT INTO nuj_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Oluvanyuma lwʼohwosa obuhwenda eyiri Esawu, abahwenda abo bagamayo eyiri Yakobbo bamuloma baati, “Hutiinire eyiri Esawu mugandawo era ali huuja ohwagaanana ni neewe era ali nʼabasinde ebihumi bine.” ");
INSERT INTO nuj_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Olwʼobuti obungi, Yakobbo gagabaniamo abaatu aba gaali ni nabo, ŋabiri. Ngʼahola atyo embusi nʼetaama nʼeŋombe nʼengamiya. ");
INSERT INTO nuj_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Mula gaŋeega ati, “Singa Esawu alumba ehibinja hirala, ehindi hiŋona.” ");
INSERT INTO nuj_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ngʼaŋo Yakobbo asaba ati, “O Hatonda wa Yibbulayimu sehulu yange, Hatonda wa Yisaka Bbaabba, O Musengwa owandoma oti, ‘Yagamayo mu gwanga lyʼewenywe era eyiri abalebe babo, nja huhuŋa ekabi era nja huba ni neewe.’ ");
INSERT INTO nuj_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Sisaanira ehyere nʼowesigwa obu bundagire, ese omwidu wuwo. Aŋa nambuhira olwabi Yoludaani ni tiina e Mesopotamya naali nʼomuhoomero gwoŋene aye ŋaahani sunire obuŋinda bungi nʼebibinja bibiri ebyʼabaatu. ");
INSERT INTO nuj_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Kwegayiriiye wuponie Esawu muganda yange atanjita, olwohuba tya ti ahanda gaaja gambwaagala gatusihiirisa, abahasi nʼabaana. ");
INSERT INTO nuj_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Aye wandoma oti, ‘Mu butuufu nahuŋenga ekabi era naabenga ni neewe era ndihuŋa abejuhulu bangi hyʼomujehe hu nyanja ogutabaliha.’ ” ");
INSERT INTO nuj_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Nga Yakobbo aŋenyuha aŋo owiire owo. Ni wahya gaŋamba hu ebyo ebi gaali ni nabyo ngʼatobolamo ehirabo hyʼEsawu mugandawe: ");
INSERT INTO nuj_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","embusi ekasi bibiri nʼepaya abiri, etaama ekasi bibiri nʼemiigu abiri, ");
INSERT INTO nuj_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","engamiya adatu nʼenyana jowaaho, eŋombe ebisonga amahumi ane ko nʼebunwa ehumi, nasugirya ekasi abiri ko nʼenyana jowaaho ehumi. ");
INSERT INTO nuj_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ngʼahena abiŋambya abeedu babe, hiisi muutu hidooli hihye, hiisi taama nʼembusi nʼeŋombe nʼengamiya ko nasugirya ŋa joŋene, ngʼaloma abeedu babe ati, “Mutangiriremo mutiine aye muleheŋo ebbanga ŋagati wʼebyayo.” ");
INSERT INTO nuj_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ngʼaloma omuhulu wʼabeedu babe ati, “Esawu muganda yange anahwagaana, gahubuusa ati, ‘Muli beedu bʼani era muja ŋe? Era njʼani omwene byayo ebi mutangirihiise?’ ");
INSERT INTO nuj_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Munamugobolemo muuti, ‘Bya Yakobbo omwidu wuwo, birabo ebi aŋeerehise Esawu musengwawe. Ne omwene yeesi ali enyuma weefe atulondaho.’ ” ");
INSERT INTO nuj_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ngʼaloma nʼomwidu owohubiri nʼowohudatu ko nʼabandi bosibosi ati, “Mwesimwesi mulome Esawu muutyo, munamwagaana. ");
INSERT INTO nuj_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Era muli nʼohumuloma muuti, ‘Yakobbo omwidu wuwo atulondaho egongo, yeesi ali huuja.’ ” Galoma atyo olwohuba gaali aŋeega ati, “Hatangirise ebirabo ebyo, muŋooyeŋooye hamunga gahasangaalira ni anamboneho.” ");
INSERT INTO nuj_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Ngʼebirabo ebyo bimutangiriramo aye omwene ngʼaŋenyuha owiire owo mu kambi. ");
INSERT INTO nuj_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ngʼowiire owo Yakobbo genyoha aŋamba abahasi babe bombi nʼabeedu babahasi babe bombi ko nʼabasaani babe ehumi namulala, ngʼabambusa olwabi olu balanga baati Yabboki. ");
INSERT INTO nuj_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Oluvanyuma lwʼohubambusa, gambusa ebibye byosibyosi ebi gaali ni nabyo. ");
INSERT INTO nuj_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Nga Yakobbo asigala yeŋene, ngʼeŋwayo omusinde owaŋiriŋana ni naye ohwola olu Masaaba yasala. ");
INSERT INTO nuj_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Omusinde oyo ni gabona nʼatasobola humuhira amaani, ngʼaŋamba hu higudigudi hya Yakobbo amuŋigula efungufu. ");
INSERT INTO nuj_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ngʼomusinde oyo amuloma ati, “Ndehe, olwohuba Masaaba esalire.” Aye Yakobbo gamuloma ati, “Sinahulehule, ohutusaho nga wupaaye ekabi.” ");
INSERT INTO nuj_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ngʼamubuusa ati, “Esiina liryo ndiiwe ani?” Ngʼamugobolamo ati, “Ndiise Yakobbo.” ");
INSERT INTO nuj_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ngʼomusinde oyo amuloma ati, “Sibahihulanga Yakobbo aye banahulangenga baati Yisirayiri, olwohuba oŋiriŋeene ni Hatonda nʼabaatu era waŋangula.” ");
INSERT INTO nuj_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Nga Yakobbo amubuusa ati, “Kusunga wundomere esiina liryo. Ndiiwe ani?” Ngʼomusinde oyo amugobolamo ati, “Lwahiina wumbuusa esiina lyange?” Ngʼaŋo aŋa Yakobbo ekabi. ");
INSERT INTO nuj_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Nga Yakobbo alanga ehifo ehyo ati Penweri, olwohuba galoma ati, “Mbwene Hatonda moni hu moni aye nasigala ni kiiri mulamu.” ");
INSERT INTO nuj_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Eryuba ni lyali ko ni liŋwayo, Yakobbo gaŋwa e Penweri gatiina nʼaŋegera olwʼefungufu eryali ni liŋiguhire. ");
INSERT INTO nuj_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ehyo cʼehigira Abayisirayiri ni batalya enyama yohu fungufu nʼohwosa olwa leero olwohuba baŋamba Yakobbo hu higudigudi bamuŋigula efungufu. ");
INSERT INTO nuj_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Oluvanyuma hu ludaalo olwene olwo, Yakobbo gaali agangamusa emoni ngʼalengera Esawu nʼatiina eyi ali, nʼali nʼabasinde bine. Olwʼehyo, gagabaniamo abaana, hiisi muhasi nʼabaana babe, ehiri ti Leeya nʼababe, Lakeeli nʼowuwe, nʼabeedu babahasi babe hiisi mulala nʼabaana babe. ");
INSERT INTO nuj_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ngʼaŋamba abeedu nʼabaana baawe abatangirisa, ngʼalosaho Leeya nʼabaana babe, ngʼasembyayo Lakeeli ni Yosefu omwana wuwe. ");
INSERT INTO nuj_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Nga Yakobbo omwene atangiriramo, ni goola ohuupi ni mugandawe, ngʼahotama mu moni jije emirundi musanvu ohumuŋa eŋono. ");
INSERT INTO nuj_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Aye ngʼEsawu aduluma aja amugwa mu hifuba. Nga bombi balira olwʼesangaalo. ");
INSERT INTO nuj_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ngʼaŋo Esawu agangamusa emoni abona abahasi nʼabaana, ngʼamubuusa ati, “Abo mbaba ani?” Nga Yakobbo amugobolamo ati, “Abo njʼabaana aba Hatonda olwʼehisa hihye, gaaŋa omwidu wuwo.” ");
INSERT INTO nuj_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ngʼabeedu babahasi babe nʼabaana batiina bahoma ekumbo mu moni jʼEsawu. ");
INSERT INTO nuj_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Nga Leeya nʼabaana babe boosi begeerera mu moni jʼEsawu, nga batiina bahoma ekumbo. Yosefu ni Lakeeli mbabasembayo era boosi baatiina nga bahubba amafuha mu moni jʼEsawu. ");
INSERT INTO nuj_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","NgʼEsawu amubuusa ati, “Ebyayo ebi mbwene ebyo, bitegeesa hi?” Nga Yakobbo amugobolamo ati, “Bya huhusunga ewe musengwa yange, wupambire ehisa.” ");
INSERT INTO nuj_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Aye ngʼEsawu amugobolamo ati, “Mwana weefe, ebi ndi ni nabyo bikena, olwʼehyo ebyo sigasa.” ");
INSERT INTO nuj_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Nga Yakobbo amuloma ati, “Bbe, ngʼolu wusangaaliye kusunga wupambire ehisa ofugiirire ehirabo hyange olwohuba ohumbonaho wasangaalira, hibaaye oti hani mbwene nje Hatonda, hiri hyʼohuheja hu Hatonda. ");
INSERT INTO nuj_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Kwegayiriiye ganya oŋire ehirabo hyange ehi kuleeteye. Hiisi ehi nahali ni nenda ndi ni nahyo olwohuba Hatonda gandaga ehyere.” Era olwohuba Yakobbo gamwegayirira bugali, Esawu gafugiirira ngʼaŋira ebiitu ebyo. ");
INSERT INTO nuj_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ngʼaŋo Esawu aloma Yakobbo ati, “Huŋambe engira hutiine era leha kutangiriremo.” ");
INSERT INTO nuj_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Nga Yakobbo amugobolamo ati, “Musengwa yange omanyire oti abaana bahiiri baŋere sibasobola hwanguŋaho. Era ndi nʼohufayo hu etaama nʼeŋombe ejihyokesa olwohuba onajigesya bugali ni ŋaŋuma huŋuumulaho, jiŋangire ohufa. ");
INSERT INTO nuj_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Olwʼehyo, leha musengwa yange otangirire mu mwidu wuwo, ese ni kulondaho nʼabaana ko nʼebyayo polapola ohwola olu nahwoleho ewuwo e Seyiri.” ");
INSERT INTO nuj_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ngʼaŋo Esawu amuloma ati, “Leha kulehere balala hu baatu aba ndi nabo bano bahuyeedeho.” Nga Yakobbo amugobolamo ati, “Bbe otafayo musengwa yange, ese ehisangaahise njʼohubona ti wusangaaliye.” ");
INSERT INTO nuj_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ngʼaŋo Esawu aŋamba engira gagamayo e Seyiri hu ludaalo olwo. ");
INSERT INTO nuj_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Aye Yakobbo niye ngʼatiina e Sukosi abbota eyo ehidaala ngʼahena aholera nʼebyayo bibye ebigangu. Cʼehigira ehifo ehyo baliranga baati Sukosi. ");
INSERT INTO nuj_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Oluvanyuma lwa Yakobbo ohugenda ohuŋwa e Padani Alaamu, gagenda goola mu hibuga Sekemu ehiri mu hyalo hyʼe Kanani, nga geemeha eweema ŋaapi nʼehibuga ehyo. ");
INSERT INTO nuj_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ngʼagula ehisugu efeeza cikumi hu bʼolulyo lwʼabaana ba Hamoli semwana ya Sekemu. Ŋaweene aŋo paŋa geemeha eweema jije. ");
INSERT INTO nuj_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Era mu hifo ehyo gatongolamo ehituuti ehyohuŋeeraho eŋongo ahena ahitaho esiina ati Elu Elohe Yisirayiri. ");
INSERT INTO nuj_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Lulala, Dina omuhaana oyu Leeya gasaalira Yakobbo gatiina ohuhyalira balala hu bahaana abohu hyalo abomu hyalo omu baali ni bamenyire. ");
INSERT INTO nuj_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sekemu omusaani wa Hamoli Omuhiivi, omutangirisi wʼehyalo ehyo, ni gamubona gamwegomba. Ngʼamufuhumira aja amuŋagia ohuŋenyuha ni naye. ");
INSERT INTO nuj_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Era nga Dina omuhaana wa Yakobbo asikiriza Sekemu amwenda bugali era gatandiha ohumuhobya. ");
INSERT INTO nuj_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Nga Sekemu aloma semwana Hamoli ati, “Kusunga wukwere omuhaana ono.” ");
INSERT INTO nuj_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Nga Yakobbo aŋulira ati Dina omuhaana wuwe, Sekemu amuŋagisye gaŋenyuha ni naye. Mu hiseera ehyo, abasaani babe baali batiinire ohwemera ebyayo bibye. Olwʼehyo Yakobbo gaŋolera ohwola olu basaani bagobola engo. ");
INSERT INTO nuj_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ngʼaŋo Hamoli semwana ya Sekemu atiina eyiri Yakobbo ateese ni naye hu songa ya Dina ohufumbirwa omusaani. ");
INSERT INTO nuj_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Abasaani ba Yakobbo ni baŋwa mu hyayo, bahitegeera baati Sekemu gaali aŋagisye Dina mboojo yaawe gaŋenyuha ni naye. Ehiitu ehyo hyabaŋambya enaku hyahena hyabasunguŋasa bugali, olwohuba Sekemu ni gaŋagia Dina omuhaana wa Yakobbo gaŋenyuha ni naye, gahola hiitu ehyʼembiho ehitaholeha era ehiswasa Yisirayiri. Ehiitu ehyali ni hitasaana huhola. ");
INSERT INTO nuj_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Aye nga Hamoli abaloma ati, “Omuseere wange Sekemu asiimire omuhaana wenywe. Olwʼehyo, mbasunga mumumuŋe amufumbirwe. ");
INSERT INTO nuj_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Era hwenda abahaana nʼabeseere wenywe ko nʼabahaana nʼabaseere beefe, bafumbirigane. ");
INSERT INTO nuj_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Era muli bʼedembe ohumenya ni neefe mu gwanga lyefe. Mumenye mwabeene aŋa mwesimiiye, mwetaaye muhene mwesunire nʼebyobusuni.” ");
INSERT INTO nuj_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ngʼaŋo Sekemu aloma semwana ya Dina nʼababoojo ati, “Mbasunga mukolere ehi hubasungire era nja hubaŋa hyosihyosi ehi munende. ");
INSERT INTO nuj_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Muusalire emaali nʼehirabo ehi mwenda mbaŋe era nja hubaŋa hyosihyosi ehi munende kasita munaganye ohuupa omuhaana oyo abe muhasi wange.” ");
INSERT INTO nuj_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ngʼabasaani ba Yakobbo bagobola mu Sekemu ni semwana Hamoli ni babahiina hubahiina olwohuba Sekemu gaali aswahiise Dina mboojo yaawe. ");
INSERT INTO nuj_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Era nga babagobolamo baati, “Sihusobola huŋa mboojo yeefe omusinde atali muhomole, olwohuba hituswasa. ");
INSERT INTO nuj_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Huuja hufugiirira singa mufuuha mwaba hyefe, mwahomola hiisi musinde. ");
INSERT INTO nuj_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Hinaba hiityo, huuja hubaŋa abahaana beefe era hwesi huuja huŋira abahaana benywe. Huuja humenya ŋalala ni nenywe, hufuuhe muutu mulala. ");
INSERT INTO nuj_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Aye ni munagaane ohuhomola, hunagamyeyo mboojo yeefe.” ");
INSERT INTO nuj_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ehyo hyasangaasa Hamoli nʼomusaani Sekemu. ");
INSERT INTO nuj_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sekemu oyu baali ni basinga ohuŋa eŋono mu mago ga semwana, sigegania ohuhola ehi baali ni bamwendaho olwohuba omuhaana wa Yakobbo gaali amuliiye omwoyo. ");
INSERT INTO nuj_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Nga Hamoli nʼomusaani wuwe Sekemu benyoheramo baŋamba engira batiina ŋa mulyango gwʼehibuga hyawe balomera abahyawe ababamenyanga ni nabo mu hibuga ehyo baati, ");
INSERT INTO nuj_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Bahyefe, abaatu bano balaŋi, kale habeehale ni neefe mu gwanga lyefe betaaye olwohuba eroba huli nʼebbala. Huja huŋira abahaana baawe era boosi baŋire abeefe. ");
INSERT INTO nuj_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ohutusaho ti abaatu abo baja hufugiirira ohwehala ni neefe ngʼomuutu omulala, singa hufugiirira ohuhomola hya nibo. ");
INSERT INTO nuj_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Bahyefe, hunafugiirira ohuhola ehi batulomire, ebyayo ko nʼebiitu ebindi ebyawe byosibyosi biija hufuuha byefe. Olwʼehyo, hufugiirire bamenye ni neefe.” ");
INSERT INTO nuj_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ngʼaŋo abaatu bosibosi abaali ŋa mulyango gwʼehibuga bafugiirira ebi Hamoli nʼomusaani Sekemu baabaloma, nga bahomola hiisi omusinde mu hibuga ehyo. ");
INSERT INTO nuj_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Oluvanyuma lwʼendaalo edatu, ni baali ni bali mu bulumi, babiri hu basaani ba Yakobbo, Simyoni ni Leevi ababoojo ba Dina, baŋamba epiima balumba abaatu mu hibuga abaali ni baŋuma ehi baali ni bamanyire, nga beeta abasinde bosibosi. ");
INSERT INTO nuj_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Era nga beetiramo ni Hamoli nʼomusaani Sekemu nga baŋamba Dina bamutusa mu nyumba ya Sekemu, nga bagamayo ewaawe. ");
INSERT INTO nuj_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Simyoni ni Leevi ni bahena ohwita hiisi musinde, abasaani ba Yakobbo abandi batiina bagaana mirambo, nga banyaga ebiitu mu hibuga ehyo ni besasusa olwa mboojo yaawe oyu Sekemu gaali nʼafuhumiiye gamuŋagia ohuŋenyuha ni naye. ");
INSERT INTO nuj_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Baanyaga etaama nʼembusi nʼeŋombe ni nasugirya nʼebiitu ebindi mu hibuga ko nʼebyali mu ndimiro. ");
INSERT INTO nuj_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Banyaga ebyʼobuŋinda byosibyosi nʼabahasi nʼabaana bosibosi era baanyaga nʼebiitu byosibyosi ebyali mu mayumba. ");
INSERT INTO nuj_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ngʼaŋo Yakobbo aloma Simyoni ni Leevi ati, “Mundeteeye ebigosi! Ŋaahani fuuhire ehyʼembiho mu moni jʼAbakanani nʼAbapereezi, abaatu abamenya mu gwanga lino. Efe huli batono, nibo banegaata banumba batusihiirisa, ese nʼabomu mago gange bosibosi.” ");
INSERT INTO nuj_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Aye nibo nga bamugobolamo baati, “Sihuŋanga hubaleha bulehe atenga Sekemu gabisya mboojo yeefe oti hani malaaya.” ");
INSERT INTO nuj_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ngʼaŋo Hatonda aloma Yakobbo ati, “Tiina e Bbeseeri omenye eyo era otongolere Hatonda ehituuti ehyʼohumuŋeeraho eŋongo, Hatonda oyo owahubonehera ni waali nʼoduluma Esawu mugandawo.” ");
INSERT INTO nuj_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Nga Yakobbo aloma abomu mago gage ni naabo bosibosi aba gaali nʼamenya ni nabo ati, “Mweyambule abahatonda aba muli ni nabo, mweyoge mwerongose era mucuuse nʼebyambalo. ");
INSERT INTO nuj_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ni muhena hutiine e Bbeseeri eyi nja hutongolera Hatonda ehituuti ehyohuŋeeraho eŋongo, Hatonda oyo owagobolamo ohusaba hwange olu naali nʼebigosi era abaaye ni nange hiisi eyi tiinire.” ");
INSERT INTO nuj_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ngʼaŋo baŋamba abahatonda aba baali ni nabo bosibosi, nʼekeeke ejaali hu matwi gaawe babiŋambya Yakobbo ngʼabisiiha ŋaasi wʼomusaala ogwali e Sekemu. ");
INSERT INTO nuj_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Nga batandiiha olugendo lwawe era etiisa ya Hatonda yaŋamba abaatu bosibosi abomu bibuga ebyohu mulirano. Olwʼehyo, ŋaŋuma muutu yesiyesi owabalumba. ");
INSERT INTO nuj_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakobbo ko nʼabaatu bosibosi aba gaali ni nabo batiina boola e Luuzi (hatyane ehi balanga Bbeseeri) mu gwanga lyʼe Kanani. ");
INSERT INTO nuj_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Mu hifo ehyo, gatongolamo ehituuti ehyohuŋeeraho eŋongo ngʼalanga ehifo ehyo ati Elu Bbeseeri olwohuba eyo peyi Hatonda gamwehwehulira olu gaali nʼaduluma hu Esawu mugandawe. ");
INSERT INTO nuj_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Nga Debora omuhasi owalera Labbeka gaaja afa, nga bamusiiha mu mutumba e Bbeseeri. Ngʼehifo ehyo baaja bahiranga baati Aloni Bbakusi. ");
INSERT INTO nuj_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Oluvanyuma lwa Yakobbo ohuŋwa e Padani Alaamu, Hatonda gamubonehera era ngʼamuŋa ekabi nindi. ");
INSERT INTO nuj_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Nga Hatonda amuloma ati, “Ndiiwe Yakobbo, aye sibaja huhulanganga baati Yakobbo, ndiiwe Yisirayiri.” Kale nga Hatonda amutaho esiina ati Yisirayiri. ");
INSERT INTO nuj_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Nga Hatonda amuloma ati, “Ndiise Hatonda Omwene Buŋangi, mwale mweyongere obungi. Abejuhulu babo baliba bangi bafuuha egwanga era abahabaha baliŋwa mu tumbu jijo. ");
INSERT INTO nuj_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ehyalo ehi naŋa Yibbulayimu ni Yisaka, kihuŋa weesi era oja huhirya nʼabejuhulu babo.” ");
INSERT INTO nuj_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ngʼaŋo Hatonda ahena aŋwa mu hifo ehyo nʼahenire ohuloma ni naye. ");
INSERT INTO nuj_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Nga Yakobbo ahomeha ebaale mu hifo ehyo omu Hatonda galoma ni naye ohuba ehyʼohuhebulirirangaho, ngʼahena aliŋongayo nʼalijuhaho omwenge ogwʼemizabbibbu nʼamafuta ogwʼomuzayiti. ");
INSERT INTO nuj_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Nga Yakobbo alanga ehifo ehyo omu Hatonda galomeramo ni naye ati Bbeseeri. ");
INSERT INTO nuj_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Oluvanyuma Yakobbo nʼabomu mago gage baŋwa e Bbeseeri. Ni baali ni bahiiriŋo nʼahanaŋiro ohwola Efulaasi, ebiseera bya Lakeeli ohusaala nga byola era gatandiha ohulumwa bugali. ");
INSERT INTO nuj_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ni gaali nʼalumwa ebyʼamaani ebyene, ngʼomusaalisa amuloma ati, “Otatya, onasaale omwana omuseere owundi.” ");
INSERT INTO nuj_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Aye Lakeeli gaali gamuŋooye nʼali wa hufa. Ni gaali nʼanatere ohuŋeera omuuya ogusembayo, gaguliha omwana oyu gaali nʼasaala esiina ati Bbeeni Oni. Ne semwana niye gamulanga ati Bbenjamini. ");
INSERT INTO nuj_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Nga Lakeeli gaaja afa, bamusiiha hu ngira eyitiina Efulaasi (hatyane ehi balanga Bbeserekemu). ");
INSERT INTO nuj_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Hu higombe hya Lakeeli, Yakobbo gataho ebaale ngʼahabonero ahohuhebulirirangaho, eririŋo nʼohwola olwa leero luno. ");
INSERT INTO nuj_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Nga Yisirayiri geyongera mu moni nʼolugendo lulwe nga geemeha eweema yiye nʼobitireho e Migidala Ederi. ");
INSERT INTO nuj_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Yisirayiri ni gaali nʼahimenyire mu matwale ago, nga Lubbeeni atiina aŋenyuha ni Bbiluha omuhasi wa semwana. Nga Yisirayiri gaaja ahiŋulira. Era abasaani ba Yakobbo baali ehumi nʼababiri. ");
INSERT INTO nuj_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Abasaani ba Leeya baali nje: Lubbeeni owaali omudaayi wa Yakobbo, Simyoni ni Leevi ni Yuda ni Yisikaali ko ni Zebbulooni. ");
INSERT INTO nuj_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Abasaani ba Lakeeli baali nje Yosefu ni Bbenjamini. ");
INSERT INTO nuj_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Abasaani ba Bbiluha omwidu wa Lakeeli baali nje Daani ni Nafutaali. ");
INSERT INTO nuj_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Abasaani ba Zilupa omwidu wa Leeya baali nje Gaadi ko nʼAseri. Abo njʼabaana ba Yakobbo abagasaala nʼali e Padani Alaamu. ");
INSERT INTO nuj_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Nga Yakobbo atiina eyiri Yisaka semwana e Mamule aŋaapi ni Kiriyaasi Arubba hatyane ehi balanga baati Kebbulooni. Eyo peyi Yibbulayimu ni Yisaka bamenyanga. ");
INSERT INTO nuj_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Yisaka gahena emyaha cikumi nacinaana. ");
INSERT INTO nuj_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Ngʼaŋo aŋeera omuuya ogusembayo aŋuumula, alonda hu baatu babe, nʼasahuluŋire era nʼaliiyeho. Era Esawu ni Yakobbo abasaani babe, baamusiiha. ");
INSERT INTO nuj_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Bino njʼebiŋamba hu lusaaye lwʼEsawu (oba Edomu). ");
INSERT INTO nuj_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esawu gaŋira hu bahaana Abakanani: Ada omuhaana wʼEloni Omuhiiti, ngʼaŋira nʼOkolibbama omuhaana wʼAna omwijuhulu wa Zibbyoni Omuhiivi, ");
INSERT INTO nuj_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","gaŋira ni Bbasimaasi omuhaana wa Yisimayiri. Bbasimaasi gaali mboojo ya Nebbayoosi. ");
INSERT INTO nuj_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","NgʼAda asaalira Esawu Elifaazi, nga Bbasimaasi amusaalira Ruweeli, ");
INSERT INTO nuj_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","nga Okolibbama amusaalira Yewusi ni Yalamu ko ni Koora. Abo njʼabasaani bʼEsawu aba bamusaalira e Kanani. ");
INSERT INTO nuj_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","NgʼEsawu aŋamba abahasi babe nʼabaana abahaana nʼabaseere nʼabaatu bosibosi abaali mu mago gage, nʼebyayo ko nʼebiitu bibye byosibyosi ebi gasuna nʼali e Kanani, ngʼatiina mu hyalo ehindi aŋaleeŋi ni Yakobbo mugandawe. ");
INSERT INTO nuj_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Esawu gatiina aŋaleeŋi olwohuba hiisi mulala gaali nʼebyayo bingi ni bataŋanga humenya ŋalala. Aŋa baali ŋaali ŋafunda ni bataŋanga hwayira ŋalala ebyayo byawe. ");
INSERT INTO nuj_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Olwʼehyo, Esawu (oba oyu balanga Edomu) gatiina gamenya e Seyiri mu hyalo ehyʼesozi. ");
INSERT INTO nuj_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Bino njʼebiŋamba hu lulyo lwʼEsawu sehulu wʼAbedomu e Seyiri mu hyalo ehyʼesozi. ");
INSERT INTO nuj_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Amasiina ga basaani bʼEsawu ngagano: Elifaazi omwana wʼAda omuhasi wʼEsawu, Ruweeli omwana wa Bbasimaasi omuhasi wʼEsawu. ");
INSERT INTO nuj_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Abasaani bʼElifaazi baali Temani nʼOmali ni Zeefo ni Gatamu ko ni Kenazi. ");
INSERT INTO nuj_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifaazi omusaani wʼEsawu gaali nʼomuhasi oyu baali ni balanga baati Timuna, gamusaalamo Ameleki. Abo njʼabejuhulu bʼAda omuhasi wʼEsawu. ");
INSERT INTO nuj_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Abasaani ba Ruweeli baali nje Nahasi ni Zeera ni Saama ni Miiza. Abo njʼabejuhulu ba Bbasimaasi omuhasi wʼEsawu. ");
INSERT INTO nuj_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Abasaani bʼOkolibbama omuhasi wʼEsawu owaali omuhaana wʼAna era omwijuhulu wa Zibbyoni gasaala, baali nje Yewusi ni Yalamu ko ni Koora. ");
INSERT INTO nuj_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Abejuhulu bʼEsawu abaali abaami, baali basaani bʼomudaayi wuwe Elifaazi era baali nje: Temani nʼOmali ni Zeefo ni Kenazi, ");
INSERT INTO nuj_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ni Koora ni Gatamu nʼAmeleki. Abo njʼabahungu ohuŋwa mu Elifaazi mu Edomu, abo baali bejuhulu bʼAda. ");
INSERT INTO nuj_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Abasaani ba Ruweeli omusaani wʼEsawu abaali abahungu baali nje: Nahasi ni Zeera ni Saama ko ni Miiza. Abo njʼabaali abahungu ohuŋwa mu Ruweeli mu hyalo hyʼEdomu. Abo baali bejuhulu ba Bbasimaasi omuhasi wʼEsawu. ");
INSERT INTO nuj_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Abasaani bʼOkolibbama omuhasi wʼEsawu baali nje: Yewusi ni Yalamu ko ni Koora. Abo njʼabahungu ohuŋwa mu Okolibbama omuhasi wʼEsawu, owaali omuhaana wʼAna. ");
INSERT INTO nuj_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Abo baali njʼabasaani bʼEsawu (oba Edomu) era baali bahungu. ");
INSERT INTO nuj_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Abasaani ba Seyiri Omukooli, abaali ni bamenya mu twale eryo, baali nje: Lotani ni Sobbali ni Zibbyoni nʼAna, ");
INSERT INTO nuj_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ni Disoni nʼEzeri ni Disani. Abasaani ba Seyiri mu Edomu baali bahungu bʼAbakooli. ");
INSERT INTO nuj_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Abasaani ba Lotani baali nje: Kooli ko ni Hemani. Timuna gaali mboojo ya Lotani. ");
INSERT INTO nuj_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Abasaani ba Sobbali baali nje: Aluvani ni Manahasi nʼEbbali ni Seefo ko nʼOnamu. ");
INSERT INTO nuj_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Abasaani ba Zibbyoni baali nje: Aya ko nʼAna. Ana njʼowabona esulo jʼamaaji agoohya mu lulafu ni gaali ni gemera nasugirya ja semwana Zibbyoni. ");
INSERT INTO nuj_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Abasaani bʼAna baali nje: Disoni nʼOkolibbama omuhaana wʼAna. ");
INSERT INTO nuj_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Abasaani ba Disoni baali nje: Kamudaani nʼEsubbani ni Yisulani ko ni Kerani. ");
INSERT INTO nuj_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Abasaani bʼEzeri baali nje: Bbilihaani ni Zavani ko nʼAkani. ");
INSERT INTO nuj_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Abasaani ba Disani baali nje: Wuuzi nʼAlani. ");
INSERT INTO nuj_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Abahungu abaaŋuga Abakooli baali nje: Lotani ni Sobbali ni Zibbyoni nʼAna ");
INSERT INTO nuj_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ni Disoni nʼEzeri ni Disani. Abo baali bahungu bʼAbakooli mu biha byawe e Seyiri. ");
INSERT INTO nuj_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ni ŋaali ni ŋahiiri hubaŋo habaha afuga Yisirayiri, bano njʼabahabaha abafuga ehyalo hyʼEdomu: ");
INSERT INTO nuj_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bbeera omusaani wa Bbewori gafuuha muŋugi wʼEdomu. Ehibuga hihye bahiranganga baati Dinakabba. ");
INSERT INTO nuj_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bbeera ni gafa, nga Yobbabbu omusaani wa Zeera ohuŋwa e Bbozira, agobola mu magulu gage. ");
INSERT INTO nuj_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobbabbu ni gafa, Kusamu ohuŋwa mu hyalo hyʼAbatemani, gagobola mu magulu gage nga habaha. ");
INSERT INTO nuj_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Kusamu ni gafa, Hadadi omusaani wa Bbedadi, owaŋangula Abamidiyaani e Mowaabbu, ngʼagobola mu magulu gage nga habaha. Ehibuga hihye bahiranganga baati Avisi. ");
INSERT INTO nuj_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadi ni gafa, nga Samula ohuŋwa e Masuleka agobola mu magulu gage nga habaha. ");
INSERT INTO nuj_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samula ni gafa, nga Sawulo ohuŋwa e Lekobbosi ohulirana olwabi, agobola mu magulu gage nga habaha. ");
INSERT INTO nuj_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sawulo ni gafa, nga Bbaali Hanani omusaani wʼAkubbooli, agobola mu magulu gage nga habaha. ");
INSERT INTO nuj_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Bbaali Hanani omusaani wʼAkubbooli ni gafa, Hadali gagobola mu magulu gage nga habaha. Ehibuga hihye bahiranganga baati Paawu, nʼomuhasi wuwe baali bamulanga baati Meketabbeeri era gaali muhaana wa Matuledi, owaali omuhaana wa Mezahaabbu. ");
INSERT INTO nuj_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Gano njʼamasiina ga bahungu ohusizira hu biha nʼamatwale gaawe mu Edomu: Timuna nʼAluva ni Yesesi, ");
INSERT INTO nuj_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","nʼOkolibbama nʼEra ni Pinoni ");
INSERT INTO nuj_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ni Kenazi ni Temani ni Mibbuzali ");
INSERT INTO nuj_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ni Magudyeri ko ni Yiramu. Abo njʼabaali abahungu bʼEdomu, mu bitundu ebyʼobutaka waawe. Esawu nje sehulu wʼAbedomu. ");
INSERT INTO nuj_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Nga ŋaahani Yakobbo amenya e Kanani, ehyalo omu semwana gamenyanga. ");
INSERT INTO nuj_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Bino njʼebiŋamba hu mago ga Yakobbo: Yosefu mulala hu baana ba Yakobbo ni gaali muvubuka owʼemyaha ehumi namusanvu, gemeeranga etaama nʼabaganda babe, abaana ba Bbiluha ni Zilupa abahasi ba semwana. Nga Yosefu atiina alomera semwana ebiŋamba hu sambo embi ejʼabaganda babe abo. ");
INSERT INTO nuj_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ŋaahani Yisirayiri gendanga Yosefu ohuhira abaana babe abandi, olwohuba gamusaala nʼasahuluŋire. Era gamutungira ehyambalo ehyʼamabala amangi. ");
INSERT INTO nuj_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Abaganda babe ni babona baati saawe genda Yosefu ohubahira bosibosi, bamucaawa ndibalomanga ni naye bulaŋi. ");
INSERT INTO nuj_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Lwali lulala Yosefu galoota ehirooto. Cooka ni galomeraho abaganda babe ehirooto ehyo, beeyongera humucaawira erala. ");
INSERT INTO nuj_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Beyongera ohumucaawa olwohuba gabaloma ati, “Leha mbalomereho ehirooto ehi ndootire. ");
INSERT INTO nuj_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ndootire ni huli mu ndimiro ni husidiha ebinywa byʼengaano. Ngʼaŋo ni naaŋo ehinywa ehyange hyenyoha hyemeerera, ngʼebyenywe bitiina bihyeswanigirisa bitandiha ohuhihubbira amafuha.” ");
INSERT INTO nuj_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ngʼaŋo abaganda babe bamuloma baati, “Olwo oŋeega oti oja hufuuha habaha, otuŋuge? Mu butuufu, oŋeega oti oja hutuŋuga?” Era nga beyongera ohumucaawira erala olwʼehirooto hihye nʼolwebigaloma. ");
INSERT INTO nuj_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Nga nindi aloota ehirooto ehindi era ngʼahiromeraho abaganda babe ati, “Ndootire ehirooto ehindi era mu hirooto ehyo, eryuba nʼomwesi nʼemunyeenye ehumi nandala byali bikubbira amafuha.” ");
INSERT INTO nuj_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ni gahiromera semwana nʼabaganda babe, nga semwana amuhayula, amuloma ati, “Olotire hirooto hiina ehyo? Ese ni maawo nʼabaganda babo hulihuhubbira amafuha?” ");
INSERT INTO nuj_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ngʼaŋo abaganda babe bamuŋambira esaalwa aye ehiitu ehyo hyasigala mu mwoyo gwa semwana. ");
INSERT INTO nuj_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Lulala abaganda ba Yosefu batiina ohwaya ebyayo bya saawe ohuupi nʼehibuga Sekemu. ");
INSERT INTO nuj_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Nga Yisirayiri aloma Yosefu ati, “Ngʼolu omanyire, abaganda babo baali hwemera ebyayo ohuupi nʼe Sekemu. Olwʼehyo hola kutume eyi bali.” Nga Yosefu amugobolamo ati, “Kale Bbaabba.” ");
INSERT INTO nuj_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ngʼamuloma ati, “Ale tiina obone abaganda babo ngʼolu baali, obone nʼebisolo byosi. Ohene ogobole wundomere ebibaŋambaho.” Ngʼaŋo amutuma ohuŋwa eyi baali ni bamenyire mu hiiho hyʼe Kebbulooni atiina e Sekemu eyi baganda babe baali ni baayira. ");
INSERT INTO nuj_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ni goola eyo, ngʼomuutu amubona nʼali hwewuluga mu sugu ni gendula abaganda babe, ngʼamubuusa ati, “Oheja hi?” ");
INSERT INTO nuj_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Nga Yosefu amugobolamo ati, “Keja baganda bange abali hwemerera ebyayo. Wahamanyaho eyi bali?” ");
INSERT INTO nuj_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Yosefu ni goola e Sekemu, nga ŋabaŋo omuutu owamubona ni gebuluga mwisugu ngʼamubuusa ati, “Ŋano baŋooyeŋo, ne puliiye ni baloma baati batiina e Dosani.” Nga Yosefu alonda hu baganda babe, abagaana ohuupi nʼe Dosani. ");
INSERT INTO nuj_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Aye ni gaali nʼahiiriho ŋale, abaganda babe bamulengera nga behobana ohumwita. ");
INSERT INTO nuj_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Nga baloma baati, “Nabirooto njʼoyo gaaja. ");
INSERT INTO nuj_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Muhole humwite, humudanye mu erala hu maloŋo gano, huhene hulome huuti, ‘Esolo ekambwe yamulya,’ ko hubone ngʼolu ebirooto bibye biryolerera.” ");
INSERT INTO nuj_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Lubbeeni ni gaŋulira, gagesyaho ohumuŋonia. Ngʼabaloma ati, “Hulehe hutamwita. ");
INSERT INTO nuj_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Muteeta muutu, mumudanye mwiroŋo lino eriri ŋano mu lulafu aye mutamuhola habi hosihosi.” Lubbeeni galoma atyo olwʼohwenda ohumuŋonia, amwagamye eyiri semwana. ");
INSERT INTO nuj_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yosefu ni goola aŋa baganda babe baali, bamuŋamba bamwambula ehyambalo hihye ehyʼebbeeyi ehyʼamabala amangi ehi gaali ni gambaaye, ");
INSERT INTO nuj_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","nga bamuŋira bamudanya mwiroŋo. Eroŋo eryo lyali liŋumamo maaji. ");
INSERT INTO nuj_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ni baali ni balya, nga babona ehibinja hyʼAbayisimayiri ni baŋwa e Giliyaadi nʼengamiya jaawe ni jetwihire ebyahaloosa ebyohuta mu mere nʼebyahawoowo ebi balanga baati bbaamu ni miira, ni batiina e Misiri. ");
INSERT INTO nuj_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Nga Yuda aloma abaganda babe ati, “Hiraŋi hi ehi hunasune mu hwita muganda yeefe? ");
INSERT INTO nuj_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Muhole humuguse Abayisimayiri abo, efe hutamuhola habi hosihosi olwohuba muganda yeefe era mubiri gwefe.” Nga abaganda babe bafugiirira ehi gabaloma. ");
INSERT INTO nuj_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Olwʼehyo, abasubuuzi bala ohuŋwa e Midiyaani ni baali ni babitaŋo, nga baŋalula Yosefu ohuŋwa mwiroŋo, nga bamugusa Abayisimayiri efeeza amahumi abiri. Ngʼabaatu abo abamugula baŋira Yosefu e Misiri. ");
INSERT INTO nuj_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Oluvanyuma Lubbeeni ni gaŋwa eyi gaali gatiina hwiroŋo, Yosefu sigaalimo. Enaku yamuleetera ohunabula engoye jije. ");
INSERT INTO nuj_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ngʼaŋo atiina eyiri abaganda babe, abaloma ati, “Omwana mwiriŋo aŋumamo, naholetye ese?” ");
INSERT INTO nuj_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ngʼabaganda babe basala embusi bahena baŋamba olugoye lwa Yosefu, balumitya mu mafugi. ");
INSERT INTO nuj_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Nga baŋamba ehyambalo ehyo ehyʼamabala amangi, bahiiŋirira saawe, bamuloma baati, “Hwaweene ehyambalo hino. Gesyaho ohuhifaania hamunga njʼehyomwana wuwo.” ");
INSERT INTO nuj_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Nga saawe ahifaania ati nje nihyo. Ngʼaloma ati, “Hino njʼehyambalo hyʼomwana wange, esolo ekambwe yamulya. O-o, hituufu esolo yagusulagusula Yosefu wange.” ");
INSERT INTO nuj_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Nga Yakobbo anabujula engoye eji gaali ni gambaaye, gesidiha ehigwali, ngʼalira omwana wuwe ohuhena endaalo nyingi. ");
INSERT INTO nuj_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Abasaani nʼabahaana babe bosibosi batiina ohumugumya aye enaku siyamuŋwa hu mwoyo. Ngʼabaloma ati, “Mundehe mu naku yange! Nditiina e magombe ni kiirira omwana wange!” Kale nga atiina mu moni nʼohulira hu lwʼomwana wuwe. ");
INSERT INTO nuj_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Abamidiyaani ni baŋira Yosefu e Misiri, bamugusa Potifaali, mulala hu bahungu ba Falaawo era owaali omuhulu wʼabahuumi babe. ");
INSERT INTO nuj_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ŋaahani ehiseera hyola Yuda gaŋwa mu baganda babe geehirira gatiina gamenya nʼomusinde oyu balanganga baati Kira mu hitundu ehi balanganga baati Adulamu. ");
INSERT INTO nuj_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Nga Yuda abonayo omuhaana wa Suwa Omukanani era ngʼamuŋira obufumbo. ");
INSERT INTO nuj_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ngʼomuhaana oyo aba hida asaala omwana omuseere, nga bamulanga baati Eri. ");
INSERT INTO nuj_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nga nindi aba hida, asaala omwana museere, ngʼamulanga ati Onani. ");
INSERT INTO nuj_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Era nindi ngʼaba hida asaala omwana museere, nga bamulanga baati Seera. Aŋa gasaalira Seera, Yuda gaali amenyire yi Kezibba. ");
INSERT INTO nuj_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Omusaani wa Yuda omuhulu oyu balanga baati Eri ni gahula, nga semwana amuhwera omuhasi oyu balanganga baati Tamali. ");
INSERT INTO nuj_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Eri omudaayi wa Yuda, gaali muhosi wa bibi mu moni ja Musengwa, olwʼehyo Musengwa gamwita. ");
INSERT INTO nuj_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Nga Yuda aloma Onani ati, “Sika omuhasi wa mugandawo wooherese obuvunanyiziwa wuwo owobusika eyiri mujiiwo wahamusaalamo abaana hulwa mugandawo.” ");
INSERT INTO nuj_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Aye Onani gamanya ati abaana abo sibaliba babe. Olwʼehyo olu gahaŋenyuhire ni muha mugandawe, ebiseera ni byaholire ohujuha gajuhanga ŋaasi olwohutenda husaalira mugandawe abaana. ");
INSERT INTO nuj_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ehyo ehi gahola hyali hibi mu moni ja Musengwa, nga yeesi amwita. ");
INSERT INTO nuj_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ngʼaŋo Yuda aloma Tamali muha omusaani ati, “Kusunga otiine ewenywe obe eyo nga namwandu, ohwola olu Seera musaani yange alihula ko ahusike.” Hino gahiroma olwohuba gaŋeega ati, “Yeesi aŋanga ohufa hya baganda babe.” Nga Tamali atiina gehala ewaawe, ewa semwana. ");
INSERT INTO nuj_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ni ŋabitaŋo ehiseera ehyene ehireeŋi, Suwa omuhasi wa Yuda, gafa. Endaalo jʼohulira ni jaŋwaho, nga Yuda aŋamba engira atiina e Timuna ewa basinde abaali ni basala amooya hu taama jije. Nga Kira Omwadulamu amuŋereheraho. ");
INSERT INTO nuj_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ni balomera Tamali baati, “Muhwewo ali hutiina e Timuna ohusala amooya hu taama jije,” ");
INSERT INTO nuj_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","geyambula ebyambalo ebyʼowanamwandu nga gambala ebindi, nga gewihirira olugoye hu mutwe nomu moni batamufaania, nga gehala hu ngira eyitiina e Timuna ŋa mulyango ogwingira mu habuga hʼEnayimu. Hino gahihola olwohuba gabona ati wayire Seera gaali ahenire ohuhula, sibamumuŋa ohumusika. ");
INSERT INTO nuj_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuda ni gabona Tama, gaŋeega ati malaaya olwohuba gaali gewihiriiye mu moni. ");
INSERT INTO nuj_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ngʼatiina aŋa gaali amuloma ati, “Nja hutiine penyuhe ni neewe.” Galoma atyo olwohuba sigategeera ati njʼomulya wuwe. Nga Tamali amubuusa ati, “Onaape hi ohuŋenyuha ni neewe?” ");
INSERT INTO nuj_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Nga Yuda amugobolamo ati, “Nja huhuŋeeresa embusi ohuŋwa mu hidooli hyange.” Ngʼamuloma ati, “Onaape ehiitu ngʼomusingo ohwola olu oliyiŋeeresa?” ");
INSERT INTO nuj_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ngʼamubuusa ati, “Musingo hi ogu wenda kuŋe?” Ngʼamugobolamo ati, “Nenda wuupe epeta yiyo eriho esiina liryo ko nʼesimbo eyo eyi oŋambire mu ngalo.” Ngʼaŋo Yuda amuŋa ebiitu ebyo, ngʼaŋenyuha ni naye ngʼamuŋa ehida. ");
INSERT INTO nuj_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamali ni gagama engo, geetusaho olugoye olu gaali ni gewihiriiye nga nindi gambala ebyambalo ebyobunamwandu. ");
INSERT INTO nuj_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Oluvanyuma Yuda ni gagamayo engo gaŋa meriiwe Kira Omwadulamu embusi ayiŋirire omuhasi ola ahene amugobohese omusingo ogu gaali nʼamuŋaaye. Aye sigagaanaŋo Tamali amugobohese omusingo. ");
INSERT INTO nuj_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Nga Kira Omwadulamu abuusa balala hu basinde abʼEnayimu ati, “Malaaya womu masabo ga bahatonda bʼe hitundu hino owihalanga ŋano hu tulo wʼengira, ali ŋe?” Ngʼabasinde abo bamugobolamo baati, “Ŋano sihubangaŋo ni malaaya owomu masabo ga bahatonda.” ");
INSERT INTO nuj_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Nga Kira gagamayo eyiri Yuda, amulomera ati, “Ndimubona era nʼabalala hu basinde abomu hitundu ehyo bandomire baati, ‘Ŋano sihubangaŋo ni malaaya owomu masabo ga bahatonda.’ ” ");
INSERT INTO nuj_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ngʼaŋo Yuda aloma meriiwe Kira ati, “Leha aŋire omusingo ogwo, olwohuba huŋanga nʼohuswalira aŋo abaatu ni batujeherera olwa malaaya. Kasita mbaye muŋeerehiise embusi aye somuweene.” ");
INSERT INTO nuj_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ni ŋabitaŋo emyesi ngʼedatu nga balomera Yuda baati, “Wange, Tamali omulya wuwo gaahola obuhwedi era aŋa hulomera ŋano ali hida.” Nga Yuda aloma ati, “Mumutuse mu hibuga, mumwohye mulamu.” ");
INSERT INTO nuj_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ne ni baali ni batusa Tamali ebulafu wʼehibuga baje bamwohye, ngʼatuma omuutu eyiri muhwewe nʼomusingo gula ati, “Ndi hida aye hyʼomwene biitu bino.” Ngʼahena ameedaho ati, “Kusunga obyetegeerese obone obanga ofaania epeta yino eriho esiina ko nʼesimbo yino.” ");
INSERT INTO nuj_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda ni gabifaania, ngʼaloma ati, “Tamali mugwalaafu ohusingaho olwohuba sinamuŋa Seera omusaani wange ohumusika.” Era sigaŋenyuha ni naye nindi. ");
INSERT INTO nuj_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ehiseera ehyʼohusaala ni hyola, nga bahifaania baati Tamali gaalimo balongo. ");
INSERT INTO nuj_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ni gaali nʼasaala, nga mulala atusa engalo, ngʼaŋo omusaŋu asaalisa amusidihaho ahagoye ahalando hu ngalo yiye aloma ati, “Ono njʼowehereeye ohutula.” ");
INSERT INTO nuj_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Aye ni gagobosayo engalo, mugandawe njʼowatula, ngʼomusaŋu omusaalisa aloma ati, “E e, posalireŋo ohutula otyo!” Nga bamutaho esiina baati Pereezi. ");
INSERT INTO nuj_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Oluvanyuma nga mugandawe owaali nʼahagoye ahalando hu ngalo nga kwatula era nga bamulanga esiina baati Zeera. ");
INSERT INTO nuj_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ŋaahani oluvanyuma lwʼohutunda Yosefu, Abamidiyaani abamugula beehirira ni naye bamuŋira e Misiri. Omumisiri oyu baali ni balanga baati Potifaali, mulala hu bahungu era omuhulu wʼabahuumi ba Falaawo, gamugula hu Bayisimayiri abo. ");
INSERT INTO nuj_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Musengwa ngʼaba ŋalala ni Yosefu era gaamuŋa ekabi mu biitu byosibyosi ebi gaholanga nʼaŋeeresa musengwawe Omumisiri oyo. ");
INSERT INTO nuj_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Era musengwa ya Yosefu ni gabona Musengwa nʼali ŋalala ni naye era ti hiisi ehi ahola, Musengwa ahiŋa ekabi, ");
INSERT INTO nuj_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Nga Yosefu aba muhoda eyiri musengwawe oyo era gamufuula muŋeeresa wuwe owenjabulo. Ngʼamuŋa ogwohulabiriranga amago gage era ngʼamwesiga amuŋa ogwʼohuhuuma ebiitu byomu mago gage byosibyosi. ");
INSERT INTO nuj_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ohuŋwa olu Potifaali gaŋambya Yosefu ebyʼamago gage nʼebiitu bibye byosibyosi, Musengwa gaŋa amago gʼOmumisiri oyo ekabi olwa Yosefu. Ekabi ja Musengwa nga jiba hu hiisi hiitu ehi Potifaali gaali ni nahyo, mu nyumba nomu ndimiro. ");
INSERT INTO nuj_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Olwʼehyo Potifaali gaŋambya Yosefu ebibye byosibyosi abirabirire. Era byosibyosi ni biri ŋaasi wa Yosefu, Potifaali sigafanga hu hiitu hyosihyosi ohutusaho emere eyi gaalyanga. Ŋaahani Yosefu gaali munegene era nʼaboneha bulaŋi. ");
INSERT INTO nuj_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Olwʼehyo, ehiseera hyola omuhasi wa musengwawe gamwegomba era ngʼamuloma ati “Hola oŋenyuheho ni neese.” ");
INSERT INTO nuj_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Aye Yosefu ngʼagaana amuloma ati, “Musengwa yange gapambya ebiitu byosibyosi ebi ali ni nabyo era ŋaŋuma ehigeralihirira hu biitu bibye olwohuba ndiŋo ohubirabirira. ");
INSERT INTO nuj_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ŋaŋuma owukira obuŋangi mu mago gano era ŋaŋuma ehi musengwa yange atapambya ohutusaho ewe, olwohuba oli muhasi wuwe. Olwʼehyo, sobola tye ohuhola ehibi hyehyo, nonoona mu moni ja Hatonda?” ");
INSERT INTO nuj_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Era wayire nga hiisi ludaalo omuhasi oyo gadebanga Yosefu aŋenyuhe ni naye aye niye gagaana wayire ohwehala ohuŋaya ni naye. ");
INSERT INTO nuj_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Lulala Yosefu gengira mu nyumba ohuhola emirimo era ni ŋaŋuma mwidu yesiyesi owaalimo. ");
INSERT INTO nuj_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Nga muha Potifaali afahira ehyambalo hya Yosefu amuloma ati, “Nja oŋenyuhe ni nange.” Aye nga Yosefu amulehera ehyambalo hihye aduluma atula ebulafu. ");
INSERT INTO nuj_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ni gabona nʼamuleheeye ehyambalo hihye mu ngalo era nʼadulumire gaŋwa mu nyumba, ");
INSERT INTO nuj_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","galanga abeedu babe gabaloma ati, “Mubone, Omubbebbulaniya ono baamuleeta ŋano hutugudujuliraho! Abaaye gengiiye muno ohufutaganiraho aye ni kubbire enduulu, ngʼaduluma. ");
INSERT INTO nuj_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ni kubbire enduulu, adulumire ngʼaleha ŋano ehyambalo hihye ngʼatula nomu nyumba.” ");
INSERT INTO nuj_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ngʼaŋo omuhasi oyo abiiha ehyambalo hya Yosefu ohwola olu musengwawe gagobola. ");
INSERT INTO nuj_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ngʼamulomera ati, “Omwidu Omubbebbulaniya oyu watuleetera ŋano, abaye gapamba. ");
INSERT INTO nuj_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Aye ni kubbire enduulu, ngʼaduluma aleha ehyambalo hihye era cʼehino.” ");
INSERT INTO nuj_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Musengwa ya Yosefu ni gaŋulira ebibono ebi omuhasi wuwe gamulomera, obusungu wamuŋamba. ");
INSERT INTO nuj_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Musengwa ya Yosefu gamuŋamba gamuŋira gamudanya mu komera omu basidihiranga abasibe ba habaha. Aye Yosefu ni gaali eyo mu komera, ");
INSERT INTO nuj_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Musengwa gaali ŋalala ni naye era gamuŋambira ehisa, hino hyamuleetera ohuba muhoda eri omuhulu wʼekomera. ");
INSERT INTO nuj_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ngʼomuhulu wʼekomera aŋa Yosefu owanyapala wʼabasibe bosibosi mu komera era ngʼamuŋa nʼogwohulabirira emirimo josijosi eji baholanga mu komera. ");
INSERT INTO nuj_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Omuhulu wʼekomera sigafangayo hu hiitu hyosihyosi ehi gaali nʼaŋambisye Yosefu. Musengwa gaali ŋalala ni Yosefu era gamuŋa ekabi mu hiisi hiitu ehigaholanga. ");
INSERT INTO nuj_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Oluvanyuma ni ŋaabitaŋo ehiseera, omuhulu wabanyiiyi abanyiiyiranga Falaawo omuŋugi wʼe Misiri nʼowamuŋeeresanga ebyohunywa, basobya hu musengwa yaawe. ");
INSERT INTO nuj_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Nga Falaawo aluŋira abaŋeeresa babe abo bombi, omuhulu wabanyiiyi abamunyiiyiranga nʼowamuŋeeresanga ebyohunywa. ");
INSERT INTO nuj_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ngʼababaŋira babata mu komera mu nyumba eyʼomuhulu wʼekomera, mu hifo ehyene ehyo omu basidihira Yosefu. ");
INSERT INTO nuj_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Omuhulu wʼabahuumi abaŋa Yosefu ohuba omwidu waawe. Oluvanyuma lwʼababiri abo ohuba mu komera ehiseera ehitali hitono, ");
INSERT INTO nuj_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","bombi, omuhulu wabanyiiyi abanyiiyiranga Falaawo nʼowamuŋeeresanga ebyohunywa abaali mu komera, basuna ebirooto owiire bulala owo era hiisi hirooto hyali nʼamahulu gaahyo. ");
INSERT INTO nuj_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ni wahya mu mugamba, Yosefu gaatiina eyi baali ngʼababona ni banakuŋaaye. ");
INSERT INTO nuj_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ngʼababuusa ati, “Hiina ehi banakuŋahiise hiityo olwa leero?” ");
INSERT INTO nuj_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Nga bamugobolamo baati, “Hwembi hulootire ebirooto, ne eŋuma aŋanga ohutuvunulira amahulu gaabyo.” Nga Yosefu abaloma ati, “Hatonda yeŋene njʼasobola ohuvunula amahulu gʼebirooto. Kale mundomere ebirooto byenywe.” ");
INSERT INTO nuj_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ngʼaŋo owaŋeeresanga Falaawo ebyohunywa alomera Yosefu ehirooto hihye ati, “Mbwene omuzabbibbu ni gwetengehire mu moni wange, ");
INSERT INTO nuj_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","era hu muzabbibbu ogwo ni huliho amasaga adatu. Aŋo ni naaŋo nga gutusa amahoose, nga gwamiraŋo emizabbibbu era nga jirabiraŋo. ");
INSERT INTO nuj_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Mbaye pambire ehihopo hya Falaawo mu ngalo. Ngʼaŋo noga emizabbibbu ejo jihamulira mu hihopo ehyo. Ni kenire nga ciŋambya Falaawo.” ");
INSERT INTO nuj_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Nga Yosefu amuloma ati, “Gano njʼamahulu gʼehirooto ehyo: amasaga adatu njʼendaalo edatu. ");
INSERT INTO nuj_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ni ŋabitireŋo endaalo edatu, Falaawo aja hulagira bahuboŋolole wagame mu hifo hihyo era wagameyo ohumuŋanga ehihopo, ngʼolu waholanga ahale. ");
INSERT INTO nuj_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Aye ohebuliranga wandaga ehyere walomeraho Falaawo ebipambaho, nahaŋwa mu komera muno. ");
INSERT INTO nuj_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Hiri hiityo olwohuba baatunda hutunda ohuŋwa mu hyalo hyʼeweefe ehyʼAbabbebbulaniya era eŋuma ehi nahola ohundanya mu komera muno.” ");
INSERT INTO nuj_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Omuhulu wabanyiiyi ni gabona Yosefu nʼavunuliiye ola bulaŋi, ngʼamuloma ati, “Keesi mbaye nʼehirooto. Hu mutwe gwange hubayeho ebisero bidatu ni birimo emere. ");
INSERT INTO nuj_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Mu hisero ehya ŋamugulu, mubayemo hiisi hiraŋi Falaawo ohulya aye enyuni jiriiyenga emere eyo ebaaye mu hisero hu mutwe gwange.” ");
INSERT INTO nuj_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Nga Yosefu amugobolamo ati, “Gano njʼamahulu gʼehirooto ehyo: ebisero ebidatu njʼendaalo edatu. ");
INSERT INTO nuj_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Endaalo edatu ni jibitireŋo, Falaawo aja hulagira bahutuse mu komera bahutemeho omutwe. Era baŋanihe omulambo gugwo hu musaala enyuni jigulye.” ");
INSERT INTO nuj_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Endaalo endatu ni jabitaŋo, gaali mazaaliwa ga Falaawo era ganyiiyira abahungu babe bosibosi embaga. Ngʼalagira batusa owamuŋeeresanga ebyohunywa ko nʼomuhulu wabanyiiyi mu komera, nga babaŋira mu moni ja bahungu babe. ");
INSERT INTO nuj_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ngʼasoniŋa omuhulu owamuŋeeresanga ebyohunywa amugobohesa obuhulu wuwe era ngʼatandiha ohumuŋeeresanga nindi. ");
INSERT INTO nuj_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Aye omuhulu wabanyiiyi nga bamuŋira bamwita ngʼolu Yosefu gaŋa amahulu gʼehirooto hihye. ");
INSERT INTO nuj_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Aye omuhulu owaŋeeresanga Falaawo ebyohunywa, nga gerabira Yosefu. ");
INSERT INTO nuj_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ni ŋabitaŋo emyaha ebiri miramba, oluvanyuma lwʼohugobosa omuhulu wʼebinywewa hu mulimo gugwe, nga Falaawo aloota ni gemereeye hu lwabi olu balanga baati Kiyira. ");
INSERT INTO nuj_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ngʼabona eŋombe musanvu ejiboneha obulaŋi era engeeji ni jiŋwera mu lwabi olwo nga jitandiha ohwaya mu ngada. ");
INSERT INTO nuj_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Oluvanyuma, eŋombe ejindi musanvu jaŋwera mu lwabi. Jino jaali nyondi era ni jiboneha bubi, joosi jatiina jemeerera hu gobo lyʼolwabi aŋaali eŋombe jira engeeji era ejiboneha obulaŋi. ");
INSERT INTO nuj_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Mu hirooto ehyo, gabona eŋombe omusanvu enyondi era ejiboneha obubi ni jirya eŋombe jira omusanvu engeeji era ejiboneha obulaŋi. Ngʼaŋo Falaawo asisimuha mu hirooto. ");
INSERT INTO nuj_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Nga nindi aŋenyuha aloota ehirooto ehindi. Hu luno gabona ebigala byʼengaano musanvu, ebigimu era ebiboneha obulaŋi ni bihulira hu hiholo hirala. ");
INSERT INTO nuj_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Nga ŋabaŋo ebigala ebindi musanvu ebi gabona cooka nibyo ni biri biŋotohi olwʼembeŋo embalire eyaŋwa mu lulafu yabihubba byaŋotoha. ");
INSERT INTO nuj_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ngʼaŋo ebigala ebyo omusanvu ebiŋotohi, bimira bira omusanvu ebigimu era ebiboneha obulaŋi. Falaawo ni gasisimuha, gafaania ati hyali hirooto. ");
INSERT INTO nuj_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ni wahya mu mugamba, ehyo hyatawanya Falaawo. Olwʼehyo, gatumisa balanga abafumu nʼabaŋi bamagesi bosibosi mu hyalo hyʼe Misiri. Nga Falaawo abalomera ebirooto bibye aye ŋaŋuma owasobola ohumulomera amahulu gʼebirooto ebyo. ");
INSERT INTO nuj_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ngʼaŋo owaŋeeresanga Falaawo ebyohunywa amuloma ati, “Musengwa, olwa leero kebuliiye esobi yange. ");
INSERT INTO nuj_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Lulala, Falaawo ganyigira abeedu babe, ngʼasidiha omuhulu wabanyiiyi ni nange mu komera mu nyumba eyʼomuhulu wʼabahuumi babe. ");
INSERT INTO nuj_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ni hwali mu komera omwo, nga ŋabaŋo ehiire omu ese nʼowahyange oyo hwaloota hiisi mulala ehirooto. ");
INSERT INTO nuj_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ŋaliŋo omuseere Omubbebbulaniya, omwidu owʼomuhulu wʼabahuumi owaali mu komera ni neefe. Ni hwamulomera ebirooto byefe ngʼatulomera hiisi muutu amahulu gʼehirooto hihye. ");
INSERT INTO nuj_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Hiisi hiitu nga hiba ngʼolu gahiroma mu huvunula huhwe: ese nga wungobohesa omulimo gwange, ola nga bamuŋira bamwita.” ");
INSERT INTO nuj_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ngʼaŋo Falaawo alagira baje baleete Yosefu. Ngʼaŋo ni naaŋo baja bamutusa mu komera. Ni bahena ohumubega efiiri, gacuusa ebyambalo bibye, nga bamuŋira eyiri Falaawo. ");
INSERT INTO nuj_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ni bamwosa nga Falaawo amuloma ati, “Nalootire ehirooto aye ŋaŋuma asobola ohuvunula amahulu gaahyo. Aye bandomeeye baati mbo ewe osobola ohuvunula amahulu gʼehirooto singa bahihulomera.” ");
INSERT INTO nuj_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Nga Yosefu amugobolamo ati, “Ese, sisobola huvunula birooto aye Hatonda aja huhulomera amahulu wiihe omwoyo.” ");
INSERT INTO nuj_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ngʼaŋo Falaawo aloma Yosefu ati, “Mu hirooto hyange, mbaye nemereeye hu gobo lyʼolwabi Kiyira, ");
INSERT INTO nuj_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","nga mbona eŋombe musanvu engeeji era ejiboneha obulaŋi ni jaaya mu ngada. ");
INSERT INTO nuj_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Oluvanyuma nabona eŋombe ejindi musanvu ejiboneha obubi, enyondi era mbaye kiiri hubonangaho mu hyalo hyosihyosi ehyʼe Misiri, eŋombe enyondi hyejo ejinabona mu hirooto. ");
INSERT INTO nuj_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Eŋombe ejo enyondi era ejiboneha obubi, nga jirya eŋombe jira omusanvu engeeji era ejiboneha obulaŋi. ");
INSERT INTO nuj_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Aye oluvanyuma lwʼenyondi ohulya engeeji, enyondi jasigala ni jihiiri nyondi era ni jiboneha bubi. Ngʼaŋo sisimuha mwiro. ");
INSERT INTO nuj_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Nga nindi penyuha era nga ndoota ehirooto ehindi. Mu hirooto ehyo, nabona amagala gʼengaano musanvu amagimu era agaboneha obulaŋi. ");
INSERT INTO nuj_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Naali keja nga mbona obugala obundi musanvu ni buli buŋotohi olwʼembeŋo embalire eyaŋwa ewuŋwalyuba yabihubba. ");
INSERT INTO nuj_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ngʼobugala owo obuŋotohi, bumira amagala gala omusanvu amagimu era agaboneha obulaŋi. Bino byosibyosi mbiromeeye abafumu aye ŋaŋumire asobooye ohundomera amahulu gaabyo.” ");
INSERT INTO nuj_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Nga Yosefu aloma Falaawo ati, “Ebirooto ebi Falaawo alootire, biri nʼamahulu njʼameene. Hatonda ahwehuliiye Falaawo ebi ali huupi huhola. ");
INSERT INTO nuj_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Eŋombe omusanvu ejiboneha obulaŋi, njʼemyaha omusanvu era amagala omusanvu amagimu, njʼemyaha omusanvu. Ebirooto ebyo biri nʼamahulu njʼameene. ");
INSERT INTO nuj_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Nʼeŋombe omusanvu enyondi era ejiboneha obubi, njʼemyaha omusanvu era obugala omusanvu obuŋotohi olwʼembeŋo embalire ohuŋwa ewuŋwalyuba, njʼemyaha omusanvu ejʼenjala. ");
INSERT INTO nuj_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Ehyo hiri ngʼolu ndomire ti Hatonda alagire Falaawo ehi ali huupi huhola. ");
INSERT INTO nuj_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ŋanahabeŋo emyaha emiraŋi musanvu ejʼemere mu gwanga lyʼe Misiri lyosiryosi. ");
INSERT INTO nuj_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Aye oluvanyuma lwajo, ŋaja hubaŋo emyaha musanvu ejʼenjala. Era enjala eyo erireetera abaatu ohwibirira ohwama hwʼemere ohwʼamaani ohwasooka. Enjala eriruma ehyalo ohubitirira. ");
INSERT INTO nuj_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ŋaliŋumaŋo ehiriraga hiiti ŋaalihoŋo emyaha eji emere yabereyemo enyingi olwohuba enjala eriba nyingi bugali. ");
INSERT INTO nuj_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ehigendererwa hya Hatonda ohuŋa Falaawo ehirooto mu ngeri ebiri, hiri ti Hatonda asalireŋo ehi aja huhola era aja huhyoheresa mu hiseera ehitali hya ŋale. ");
INSERT INTO nuj_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Olwʼehyo, Falaawo aheje omusinde omulabuhi era owʼamagesi, amuŋe obuŋangi ohudulumya ehyalo hyʼe Misiri. ");
INSERT INTO nuj_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Falaawo ateŋo abatangirisi mu hiisi hitundu ohusoloosa hirala ehyohutaanu ehyʼamakungula mu gwanga lyʼe Misiri mu myaha ejo omusanvu ejʼemere embitiirifu. ");
INSERT INTO nuj_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Era mu buŋangi wa Falaawo, bahumbaanie emere mu myaha ejo josijosi emiraŋi ejiija mu moni, bahene bayibiihe mu bibuga bateŋo nʼabasirikale ohuyihuuma. ");
INSERT INTO nuj_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Emere eyo bayibiihe eyo ni betegehera emyaha omusanvu ejʼenjala eyiija mu gwanga lyʼe Misiri, ohwehuumisa abaatu batafa njala.” ");
INSERT INTO nuj_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ebibono ebi Yosefu galoma byali byʼamagesi eyiri Falaawo nʼabahungu babe bosibosi. ");
INSERT INTO nuj_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ngʼaŋo Falaawo abuusa abahungu babe ati, “Husobola hwagaana ŋeena omusinde hyʼono ali nʼOmwoyo wa Hatonda?” ");
INSERT INTO nuj_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Nga Falaawo aloma Yosefu ati, “Hatonda ahulagire amahulu gʼebirooto byange byosibyosi, ŋaŋuma omuutu omulabuhi era owʼamagesi hyʼewe. ");
INSERT INTO nuj_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Oja huhulira olubiri lwange era abaatu bʼe Misiri bosibosi bali nʼohugonderanga ebiragiro bibyo. Oja huba wahubiri hu ese.” ");
INSERT INTO nuj_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Nga Falaawo aloma Yosefu ati, “Kuŋa obuŋangi ohuŋuga ehyalo hyʼe Misiri hyosihyosi.” ");
INSERT INTO nuj_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Era nga Falaawo gefihula epeta yiye eyʼobuŋugi hu lwala lulwe, ayifiiha Yosefu. Ngʼahena amwambasa ehimolo ehi baatunga mu lugoye olulaŋi olwa laasi, ngʼaŋamba ahajegere ahʼezaabbu amwambasa mu mamiro. ");
INSERT INTO nuj_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ngʼalagira bamugeehesya mu higaali hihye ehindi ohulaga ti njʼowaali owohubiri hu ye mu buŋangi. Ngʼabasirikale aba bamuŋa ohumuhuuma bamutangirira ni bahabuhira abaatu baati, “Mwawuhe!” Kale nga Falaawo aŋa Yosefu obuŋangi ohuŋuga ehyalo hyʼe Misiri hyosihyosi. ");
INSERT INTO nuj_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Nga Falaawo aloma Yosefu ati, “Wayire ndiise Falaawo aŋuga Misiri, kuŋaaye obuŋangi ŋaŋume muutu ahola ehiitu hyosihyosi nʼatahwebuhiiseho.” ");
INSERT INTO nuj_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Nga Falaawo aŋa Yosefu esiina ati Zafenasi Paneeya, ngʼahena amuŋa Asenaasi omuhaana wa Potifeera omusengi womu hibuga Oni, ohuba muhasi wuwe. Kale nga Yosefu aŋuga egwanga lyʼe Misiri. ");
INSERT INTO nuj_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yosefu gaali aŋesa emyaha adatu aŋa gatandihira ohuŋeeresa Falaawo habaha wʼe Misiri. Nga Yosefu aŋwa mu lubiri ewa Falaawo, atiina agenda nʼalambula ahenaho Misiri yosiyosi. ");
INSERT INTO nuj_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Mu myaha omusanvu emiraŋi ejʼemere, ehyalo hyʼe Misiri hyama emere mu bungi. ");
INSERT INTO nuj_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Nga Yosefu ahumbaania emere yosiyosi eyi baatu bomu Misiri bafuna mu myaha omusanvu emiraŋi bayibiiha aŋaatu mu bibuga. Mu hiisi hibuga gatangamo ehifo aŋa ohubiihamo emere ohuŋwa mu bitundu ohweswanigirisa. ");
INSERT INTO nuj_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Nga Yosefu abunga ebibbiryo byʼemere ebibba ebyene ebingi byaba oti hani mujehe hu nyanja. Olwohuba emere yaali nyingi bugali, galeeheraŋo nʼohuŋandiiha omuŋendo. ");
INSERT INTO nuj_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Mu hiseera ehyo, emyaha jʼenjala ko joole, ngʼAsenaasi omuhaana wa Potifeera omusengi womu hibuga Oni asaalira Yosefu abaana abaseere babiri. ");
INSERT INTO nuj_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Nga Yosefu alanga omwana omudaayi esiina ati Manase, aloma ati, “Olwohuba Hatonda ganjerabihiise ohutegana hwange ko nʼamago ga Bbaabba.” ");
INSERT INTO nuj_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ngʼowohubiri amulanga esiina ati Efulayimu nʼaloma ati, “Olwohuba Hatonda gapaaye olusaaye mu hyalo omu mbonaboneeye.” ");
INSERT INTO nuj_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ngʼaŋo emyaha omusanvu ejʼemere ohuba mu bungi mu gwanga lyʼe Misiri, jiŋwaho. ");
INSERT INTO nuj_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Ngʼemyaha omusanvu ejʼenjala jitandiha, ngʼolu Yosefu gaaloma. Enjala yaluma ehyalo hyosihyosi aye mu gwanga lyʼe Misiri mwosimwosi mwalimo emere. ");
INSERT INTO nuj_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Abaatu bʼe Misiri ni batandiiha ohulumwa enjala, baliririra Falaawo abaŋe emere. Nga Falaawo abaloma ati, “Mutiine eyiri Yosefu, muhole ngʼolu anabalome.” ");
INSERT INTO nuj_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Enjala ni yahwana mu gwanga lyʼe Misiri lyosiryosi, nga Yosefu gegulaŋo amasitoowa gosigosi, ngʼagusa Abamisiri emere, olwohuba enjala yaali nyingi mu gwanga lyʼe Misiri lyosiryosi. ");
INSERT INTO nuj_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ngʼabaatu ohuŋwa mu byalo ebindi byosibyosi batiina e Misiri eyiri Yosefu ohugula emere, olwohuba enjala yaali nyingi mu hyalo hyosihyosi. ");
INSERT INTO nuj_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakobbo ni gategeera e Misiri nʼeriyo engaano, galoma abasaani babe ati, “Lwahiina mwihaaye hwihala ni muhejanaho ni ŋabula ehi muhola?” ");
INSERT INTO nuj_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nga geeyongera abaloma ati, “Pulira ti e Misiri eriyo emere, muserengete mutiineyo mutusahireyo emere hutafiira ŋano njala.” ");
INSERT INTO nuj_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ngʼabaganda ba Yosefu ehumi abahulu, beehirira batiina e Misiri ohugula emere. ");
INSERT INTO nuj_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Aye Yakobbo sigafugiirira Bbenjamini muganda ya Yosefu ohutiina nʼabaganda babe, olwohuba gaali atya ati hamunga yeesi ehiitu ehibi hiŋanga ohumwolaho. ");
INSERT INTO nuj_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Abasaani ba Yisirayiri baali balala hu mutoolo gwʼabaatu abaatiina ohusaha engaano olwohuba enjala yaali mu gwanga lyʼe Kanani lyosi. ");
INSERT INTO nuj_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yosefu njʼowaali omuŋugi wʼegwanga lyʼe Misiri era njʼowaali nʼagusa abaatu baayo bosibosi emere. Olwʼehyo, abaganda ba Yosefu ni batiina boola e Misiri, nga bagwa mu moni jije bafumaaye olwʼohumuŋa eŋono. ");
INSERT INTO nuj_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Aŋo ni naaŋo Yosefu ni gabona abaganda babe, gabafaania aye nga gehosa oti sabamanyire, ngʼabaloma nʼabogoha ati, “Muŋwera ŋeena?” Nga bamugobolamo baati, “Huŋwera mu hyalo hyʼe Kanani. Hujire ohugula emere.” ");
INSERT INTO nuj_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Wayire Yosefu gafaania abaganda babe nibo sibamufaania. ");
INSERT INTO nuj_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ngʼaŋo Yosefu ahebulira ebirooto bibye ebi galootanga hu bo, ngʼabaloma ati, “Enywe mujire huheeta ohumanya obunafu obuli mu gwanga lyefe ko mugobole mutusoose.” ");
INSERT INTO nuj_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Nga bamugobolamo baati, “Bbe, musengwa yeefe, abeedu babo bajire hugula emere. ");
INSERT INTO nuj_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Muhulu, hwesihwesi ngʼolu otubona ŋano huli baana bʼomuutu mulala. Efe abeedu babo huli baatu bʼamazima, sihuli huheeta.” ");
INSERT INTO nuj_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Nga Yosefu abagobolamo ati, “Bbe mudulinga, enywe mujire huheeta ebiri mu gwanga lyefe.” ");
INSERT INTO nuj_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Aye bamugobolamo baati, “Efe abeedu babo hwali ehumi nʼababiri, abaana bʼomuutu mulala amenya mu gwanga lyʼe Kanani, muŋere yeefe gasigayeyo ni seefe, muganda yeefe owundi njʼowafa.” ");
INSERT INTO nuj_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Nga Yosefu abaloma ati, “Soobona, hiri ngʼolu ndomire, enywe muli huheeta. ");
INSERT INTO nuj_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Hino cehi nahole ohuhahasa oba ehi muloma hituufu: Falaawo ngʼolu ali omulamu, simuja huŋwa ŋano ohutusaho nga muleetire ŋano muŋere yenywe. ");
INSERT INTO nuj_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Mweyangalemo mulala hu nywe atiine aleete muganda yenywe omuŋere, abasigaaye nenda hubata mu komera ohwola olu hunahahahase hanye ebimuloma bituufu. Ni muba ni mutaloma mazima, ngʼolu Falaawo ali mulamu, mu butuufu muba muli baheeti.” ");
INSERT INTO nuj_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ngʼabata bosibosi ŋalala mu komera ohuhena endaalo edatu. ");
INSERT INTO nuj_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ni ŋabitaŋo endaalo ebiri, hu lwalondaho nga Yosefu alagira baleeta abaganda babe abo abaloma ati, “Ese ndi muutu atya Hatonda, olwʼehyo muhole ehi mbaloma ko muŋone. ");
INSERT INTO nuj_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ni muba ni muloma amazima, mulala hu enywe asigale ŋano aye olwʼamago genywe agali hulumwa enjala, abasigayeŋo bagameyo baŋirire abaatu bomu mago genywe abali hulumwa enjala, emere. ");
INSERT INTO nuj_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Aye muli nʼohundeeterea ŋano nakoma wenywe ko kahase ebi muloma era ko muŋone.” Nga bahola baatyo. ");
INSERT INTO nuj_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Nga baloma abeene nʼabeene baati, “Mu butuufu ehi hwahola muganda yeefe sihyali hiraŋi. Hwabona enaku eyi gaali ni nayo nʼatwegayirira humulehe aye sihwaŋulirisa bibye. Cʼehigima bino bitwolireho.” ");
INSERT INTO nuj_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Nga Lubbeeni abagobolamo ati, “Sinabaloma ti omuseere mutamwosaho habi hosihosi aye enywe mwagaana ohuŋulira ebyange? Ŋaahani huli nʼohubiroosa.” ");
INSERT INTO nuj_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Sibamanya Yosefu ni gaali nʼaŋulira ebi baloma olwohuba gaali atambisa omutafuta ohuloma ni nabo. ");
INSERT INTO nuj_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Nga Yosefu aŋwa aŋa bali atiina aŋaatu akukumusa amasiga, nga gagamayo eyi bali, ngʼaloma ni nabo nindi. Ngʼalagira baŋamba Simyoni bamudanya mu komera, bosibosi ni babona. ");
INSERT INTO nuj_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Nga Yosefu alagira bejusa esaŋu jʼabaganda babe emere, baŋamba nʼebbeesa eja hiisi muutu baajita mu saŋu jaawe, nga babawoŋera nʼemere eyʼohulya ni bali mu lugendo. ");
INSERT INTO nuj_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ngʼaŋo abaganda babe batwiha emere yaawe hu nasugirya jaawe basimbuha ohwagamayo engo. ");
INSERT INTO nuj_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Owiire ni waberirira nga basalaŋo baŋenyuhe aŋaatu. Mulala hu bo ni gasitula esaŋu yiye ohuŋa nasugirya yiye emere, ngʼabona ebbeesa jije ni jiri hu mugulu wʼesaŋu yiye. ");
INSERT INTO nuj_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ngʼaloma baganda babe ati, “Bangoboheseye ebbeesa jange, njʼeji mu saŋu yange.” Ngʼemyoyo jibahubba mu bifuba ni bateetema huteetema ni bebuusa abeene nʼabeene baati, “Hatonda atuholire hi hino?” ");
INSERT INTO nuj_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ni boola engo e Kanani, nga balomera Yakobbo laata yaawe byosibyosi ebyabolaho baati, ");
INSERT INTO nuj_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Omusinde aŋuga egwanga eyi hwatiina ohugula emere, gaaloma ni neefe nʼebbogo nʼatulobohesamo ohuba baheeti. ");
INSERT INTO nuj_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Aye nga humulomera huuti, ‘Efe sihuli baheeti, ");
INSERT INTO nuj_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","hwali ehumi nʼababiri, abaana abʼomuutu mulala, mulala gafa, muŋere yeefe gaasigalayo ni seefe engo mu gwanga lyʼe Kanani.’ ");
INSERT INTO nuj_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Ngʼaŋo omusinde omuŋugi wʼegwanga eryo, atuloma ati, ‘Hino cehi nja hutegereraho ti muli huloma hyʼamazima: mulehe ŋano mulala hu nywe, ko enywe abandi muŋirire abaatu benywe emere olwʼenjala eyiruma. ");
INSERT INTO nuj_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Aye mundeeteranga ŋano muganda yenywe omuŋere, ehyo njʼehinditegereraho ti simuli baheeti, ko ndehule muganda yenywe ono. Era muja huba bʼedembe ohwihala mu gwanga lino mwetaaye.’ ” ");
INSERT INTO nuj_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ni begula esaŋu jaawe, hiisi muutu gagaanamo ebbeesa jije! Bo ni saawe ni babona ebbeesa ejo, ngʼobuti bubaŋamba. ");
INSERT INTO nuj_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Nga saawe Yakobbo abaloma ati, “Mukenireho abaana bange. Yosefu gaatiina era ni Simyoni yeesi hiŋirire era mwenda ohutusaho ni Bbenjamini yeesi. Hiisi hiitu hiri hutiinira bubi.” ");
INSERT INTO nuj_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Nga Lubbeeni aloma semwana ati, “Wiitanga abaana bange bombi, singa sindigobosa Bbenjamini. Njesige keesi nja humugobosa.” ");
INSERT INTO nuj_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Aye nga Yakobbo aloma ati, “Omwana wange saaja hutiina eyo ni nenywe, olwohuba mugandawe gaafa, niye njʼasigayeŋo yeŋene. Singa agwira ehigosi hu ngira, ehyo hiija hundeetera ohutiina e magombe nʼobutahi bungi bugali.” ");
INSERT INTO nuj_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Enjala yeyongera ohuluma abaatu bugali mu gwanga lyʼe Kanani. ");
INSERT INTO nuj_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ni baali ni bahenire ohulya emere yosiyosi eyi baatusa e Misiri, nga Yakobbo aloma abasaani ati, “Mwagameyo e Misiri mutugulireho emere.” ");
INSERT INTO nuj_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Nga Yuda amuloma ati, “Omusinde ola omuŋugi waayo gatulabula ati, ‘Simuja hugobolayo huloma ni nange ohutusaho nga mujire ni muganda yenywe.’ ");
INSERT INTO nuj_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Nʼonafugiirire Bbenjamini ohutiina ni neefe, hunatiine e Misiri hwabagulirayo emere eyindi. ");
INSERT INTO nuj_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Aye nooba nʼotafugiirira hutiina ni naye, sihunatiine olwohuba omusinde ola gatuloma ati, ‘Sinja hugobolayo huloma ni nenywe ohutusaho ni mujire ni muŋere yenywe.’ ” ");
INSERT INTO nuj_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Nga Yisirayiri amuloma ati, “Lwahiina mwalomera omusinde oyo muuti muli ni muganda yenywe owundi, ohundeetera obugosi buno?” ");
INSERT INTO nuj_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Nga bamugobolamo baati, “Omusinde oyo gatubuusa bugali ebituŋambaho, gaabuusa nʼebifa hu mago geefe ati, ‘Senywe ahiiriŋo mulamu? Muli ni muganda yenywe owundi?’ Efe hwagobolangamo hugobolamo ebi gatubuusanga. Hwahamanyiiye hu hi huuti anatulome ati, ‘Muje muleete muganda yenywe oyo’?” ");
INSERT INTO nuj_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Nga Yuda aloma semwana Yisirayiri ati, “Fugiirira hutiina e Misiri nʼomwana mangumangu hugule emere, ehyo hija huleetera ewe ni neese ko nʼamago geefe ohuŋona enjala. ");
INSERT INTO nuj_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ese suubisa ohumuhuuma butiiribiri. Era ni tamugobosa ŋano, ogwo guja huba musango gwange. ");
INSERT INTO nuj_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Singa ebiseera sibiŋwereeye hu huloma hu hiitu hino, engeri hwali huhulomeeyeho hale, aŋa ndomera ŋano hwahali hugobolayo mulundi ogwohubiri.” ");
INSERT INTO nuj_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ngʼaŋo saawe Yisirayiri abaloma ati, “Hinaba ni hiri hiityo, muhole muuti: muŋambeho birala hu biitu ebihirira erala obulaŋi mu hyalo hyefe hino, mute mu saŋu jenywe muŋirireho omusinde oyo ngʼehirabo. Muŋire ebyahawoowo ebi balanga baati bbaamu ni miira nʼomudugere ko nʼebibala ebi balanga baati alumondi. ");
INSERT INTO nuj_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Muŋire ebbeesa ejʼemirundi ebiri olwohuba muli nʼohugobosayo ebbeesa jira ejibabateera mu esaŋu jenywe. Hamunga sihyali higenderere. ");
INSERT INTO nuj_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Muŋire ni muganda yenywe yeesi, mwagame eyiri omusinde oyo omuŋugi. ");
INSERT INTO nuj_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Sunga Hatonda Omwene Buŋangi, omuŋugi oyo abalehulire muganda yenywe Simyoni ni Bbenjamini, bagobole. Ese nimba wohufiirwa abaana bange, hahibe hiityo, puma hyahuhola.” ");
INSERT INTO nuj_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ngʼabasaani babe abo baŋamba ebirabo ebyo nʼebbeesa ejʼemirundi ebiri nga beehirira batiina e Misiri beyanjula eyiri Yosefu ni bali ni Bbenjamini. ");
INSERT INTO nuj_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yosefu ni gababona ni bali ni Bbenjamini, galoma alabirira amago gage ati, “Ŋira abasinde bano mu nyumba ewange, osale ehyayo otegehe ehiiŋulo olwohuba banaalye ehyomu muusi ni nange.” ");
INSERT INTO nuj_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ngʼolabirira amago gage, ahola ngʼolu Yosefu gamuloma, ngʼaŋira abasinde abo mu nyumba ewa Yosefu. ");
INSERT INTO nuj_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Abaganda ba Yosefu batya ni babaŋira mu nyumba ewa Yosefu. Baŋeega baati, “Batuleetire ŋano olwʼebbeesa ejibata mu saŋu jeefe hu ludaayi. Atuleetire eno atuhubbe owiibi ahene alagire batuhadaase bahene batufuule beedu babe era baŋire ni nasugirya jeefe.” ");
INSERT INTO nuj_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Olwʼehyo, batiina eyiri alabirira amago ga Yosefu, owaali ŋa mulyango gwʼenyumba bamuloma baati, ");
INSERT INTO nuj_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Muhulu, hwaja ŋano omulundi omudaayi ohugula emere. ");
INSERT INTO nuj_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Aye ni hwagamayo, hwola aŋaatu aŋa hwaŋenyuha, ni hwaboŋolola esaŋu jeefe, hiisi mulala gagaanamo ebbeesa enyene nʼenyene eji gasasuulira emere, ni jiri hu mugulu wʼemere. Olwʼehyo, hujigobohiise. ");
INSERT INTO nuj_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Sihumanyire owajita mu saŋu jeefe. Huleetire nʼebbeesa ejindi ohugula emere.” ");
INSERT INTO nuj_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ngʼalabirira amago ga Yosefu abagobolamo ati, “Eŋuma bubi, mutatya. Hatonda wenywe era Hatonda wa senywe, gabaŋa obuŋinda mu saŋu jenywe. Nasuna ebbeesa jenywe eji mwasasula.” Ni gahena ohuloma, ngʼabatuhisa Simyoni. ");
INSERT INTO nuj_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ngʼaŋo alabirira amago ga Yosefu abengisa mu nyumba ewa Yosefu, ngʼabaŋa amaaji basaaba amagulu, ngʼaŋa ni nasugirya jaawe enyaasi ohulya. ");
INSERT INTO nuj_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Nga bategeha ohuŋambya Yosefu ebirabo olwohuba baali babalomire baati gaali aja huliira ŋalala ni naabo ehyomu muusi. ");
INSERT INTO nuj_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yosefu ni gagobola engo, nga bamuŋirira ebirabo nga bahena bahubba amafuha mu moni jije. ");
INSERT INTO nuj_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ngʼababuusa ngʼolu baali, ngʼahena ababuusa ati, “Senywe oyu mwandomeraho, ali atye? Aliyo mulamu?” ");
INSERT INTO nuj_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Nga bamugobolamo baati, “Omwidu wuwo, seefe aliyo, ahiiriyo mulamu.” Nga bahubba amafuha ohulaga baati bamuŋa eŋono. ");
INSERT INTO nuj_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yosefu ni gabetoloosamo emoni, gabona Bbenjamini muganda yaawe, omwana wa nyina, ngʼababuusa ati, “Oyo nje muganda yenywe ohirira erala obuŋere oyu mwandomeraho?” Ngʼahena amuloma ati, “Mwanawe, Hatonda ahuŋambire ehisa.” ");
INSERT INTO nuj_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yosefu ni gaabona Bbenjamini omwana wa nyina era mutoowe, ganyanguha ohuŋwaŋo ohuheja ehifo aŋʼohulirira. Gatiina mu hisenge hihye ehyʼenjabulo ngʼalirira omwo. ");
INSERT INTO nuj_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ni gahena ohulira, ngʼasaaba mu moni, atula, ni gegumirisa ohutenda abaaliŋo bamanye ngʼaloma alabirira amago gage ati, “Yiiŋula emere.” ");
INSERT INTO nuj_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ngʼabeeŋula Yosefu yeŋene, nʼabaganda babe ŋa boŋene nʼAbamisiri abaliiranga ŋalala ni naye ŋa boŋene. Bahola baatyo olwohuba hyali hya mbiho eyiri Abamisiri ohuliira ŋalala nʼAbabbebbulaniya. ");
INSERT INTO nuj_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Beehasa abaganda babe abo ni bamulengereeye ni beema hu myaha jaawe, ohuŋwa hu mudaayi ohwola hu muŋere. Nga bahejanaho ni beeŋunja olwohubeehasa baatyo. ");
INSERT INTO nuj_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Nga babeŋula emere ni bayituhisa hu meeza ya Yosefu, cooka eya Bbenjamini yasinga eyabahye bosibosi emirundi etaanu. Balya era banywa ni Yosefu era ni baali basangaafu. ");
INSERT INTO nuj_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ni bahena ohulya, nga Yosefu alagira alabirira amago gage ati, “Yoolera abasinde emere mu saŋu jaawe hiisi muutu nʼomuteeramo eyi asobola ohugega. Era hiisi muutu muteere ebbeesa jije hu mugulu wʼemere mu saŋu yiye. ");
INSERT INTO nuj_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Nʼohena oŋambe ehihopo hyange ehi babbota mu feeza ohite hu mugulu wʼesaŋu eyamuto yaawe era taamo nʼebbeesa eji asasuuye.” ");
INSERT INTO nuj_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ni wahya mu mugamba pwipwipwi, ngʼaseebula abasinde abo baniina nasugirya jaawe. ");
INSERT INTO nuj_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ni baali ni bahiiri hwola ŋaleeŋi ohuŋwa mu hibuga, nga Yosefu aloma alabirira ŋa wuwe ati, “Londa hu basinde abo, nʼonaboleho obalome oti, ‘Lwahiina mutusasuuye ehibi mu hiraŋi ehi hubaholire? ");
INSERT INTO nuj_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Hino njʼehihopo ehi musengwa yange anyweramo era njʼehi atambisa ohumanya ebiija hubaŋo mu moni. Muholire hibi ohuhiiba.’ ” ");
INSERT INTO nuj_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Era ni gabalondaho ngʼabagaana abaloma ehi Yosefu gamuloma. ");
INSERT INTO nuj_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Aye nibo nga bamuloma baati, “Muhulu, hiina ehigema waloma ebibono ebyo? Sihusobola huhola ehiitu hyehyo. ");
INSERT INTO nuj_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Obanga hwagobohiise ebbeesa eji hwagaana mu saŋu jeefe ni hwola e Kanani, lwahiina hwiba efeeza oba ezaabbu ohuŋwa mu nyumba ya musengwawo? ");
INSERT INTO nuj_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Singa ŋabaŋo mulala hu efe abeedu babo, oyu onabone nahibihire, embwa enjibi yegula omugogo. Aye abasigayeŋo hwesihwesi huja hufuuha beedu babo.” ");
INSERT INTO nuj_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ngʼalabirira amago ga Yosefu, amugobolamo ati, “Mutehiise bulaŋi. Oyo oyu nagaane nʼehihopo njʼanafuuhe omwidu wange yeŋene. Abasigaayeyo nibo sibanabeho musango.” ");
INSERT INTO nuj_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ngʼaŋo hiisi mulala hu bo atwihula esaŋu yiye ayita ŋaasi, ngʼahena ayiboŋolola. ");
INSERT INTO nuj_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ngʼalabirira ewa Yosefu, atandihira hu yʼomuhulu yaawe ohwaza paka olu goola hu yomuŋere. Nga bagaana ehihopo mu saŋu ya Bbenjamini. ");
INSERT INTO nuj_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ni hyazuuha hiiti ehihopo ehyo hyali mu saŋu ya Bbenjamini, nga bahanula engoye jaawe olwʼowusiba, nga bahena bagobosa esaŋu jaawe hu nasugirya jaawe bagama mu hibuga. ");
INSERT INTO nuj_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Mu hiseera ehyo, Yosefu gaali ahiiri mu nyumba e wuwe, Yuda nʼabaganda babe ni boola mu nyumba, nga bahubba amafuha mu moni jije ni bajooleeye. ");
INSERT INTO nuj_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Nga Yosefu ababuusa ati, “Muholire hiina ehyo? Simumanyire muuti omuutu hyʼese asobola ohulagula gamanya ebiitu ebija hubaŋo mu moni?” ");
INSERT INTO nuj_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Nga Yuda amugobolamo ati, “Hunaalome hi musengwa yange? Huŋuma hya huloma. Huneŋosyeho huutye ohulaga huuti huŋuma musango? Hatonda ganihire obubi weefe, efe abeedu babo. Ŋahani huli beedu ba musengwa yeefe, efe ŋalala ni nooyo oyu baageene nʼehihopo mu saŋu yiye.” ");
INSERT INTO nuj_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Aye Yosefu galoma ati, “Sipanga huhola ehiitu hyehyo, oyu bageene nʼali nʼehihopo njʼaja ohufuuha omwidu wange. Abasigaaye mweyagamire eyiri senywe, miyaaya.” ");
INSERT INTO nuj_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Nga Yuda gegerera aŋa Yosefu gaali amuloma ati, “Kusunga musengwa yange, wunjihirise ohubaaho nʼehindoma eyi oli. Kusunga otanyigira ese omwidu wuwo, olwohuba manyire ti oli nʼobuŋangi hyʼowa Falaawo era ehi olagira njʼehi bahola. ");
INSERT INTO nuj_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Muhulu, watubuusa efe abeedu babo oti, ‘Muli ni senywe oba muganda yenywe?’ ");
INSERT INTO nuj_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nga huhugobolamo huuti, ‘Huli ni seefe aye asahuluŋire era huliyo ni muganda yeefe oyu seefe gasaala mu wusahulu. Muganda yeefe owundi, gaafa. Ŋahani muganda yeefe oyo njʼomwana yeŋene aliŋo hu nyina era seefe amwenda bugali.’ ");
INSERT INTO nuj_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ngʼaŋo otuloma oti, ‘Mumuleetanga ŋano muboneho ko kahase ti ebi muloma bituufu.’ ");
INSERT INTO nuj_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Nga muhulu, huhugobolamo huuti, ‘Bbaabba sasobola hwihirisa omwana oyo ohumulehaŋo, asobola nʼohufa ogwʼomwana wuwe.’ ");
INSERT INTO nuj_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Aye ngʼotuloma oti, ‘Ohutusaho ni muleetire ŋano muto yenywe, sinja hubehirisa hugobola ŋano hwemeerera mu moni jange nindi.’ ");
INSERT INTO nuj_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Era muhulu, ni hwagama engo hwalomera seefe ehi watuloma. ");
INSERT INTO nuj_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Emere ni yatuŋwaho, nga seefe atuloma ati, ‘Mwagame e Misiri mutugulireho emere nindi.’ ");
INSERT INTO nuj_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Aye hwamugobolamo huuti, ‘Sihuja hutiina e Misiri ohutusaho ni hutiinire ni muganda yeefe Bbenjamini olwohuba omuŋugi waayo gatuloma ati sigenda hutiineyo ni huŋuma muganda yeefe ahira ohuba omuŋere.’ ");
INSERT INTO nuj_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Nga Bbaabba atugobolamo ati, ‘Mumanyire muuti nyinenywe gaasaalira abaana abaseere babiri. ");
INSERT INTO nuj_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Mulala gangota hu moni era aŋaŋuma hubuusabuusa esolo yamulya. Ohuŋwa hulwo simubonangaho. ");
INSERT INTO nuj_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Singa muŋira ono yeesi, ŋabaŋo ehigosi hu ngira, muja hugira tiine e magombe ni ndi nʼenaku eyʼamaani.’ ” ");
INSERT INTO nuj_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Yuda geeyongera ohuloma ati “Olwʼehyo, singa nagama engo wereere aŋaŋuma Bbenjamini, ngʼolu bulamu wa Bbaabba buholera bugali hu mwana oyo, ");
INSERT INTO nuj_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","kasita anabone ni hutagemeyo ni mulebe yeefe oyo, aja hufa. Efe abeedu babo huja huba ndiife ohuleeteeye Bbaabba olumbe ohumwita. ");
INSERT INTO nuj_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ehyo nʼohitaaye aŋo, nahahasa Bbaabba ti nja humuhuuma. Namuloma ati, ‘Singa simugobosa nʼali mulamu, omusango guliba hu ndiise.’ ");
INSERT INTO nuj_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Kale kusunga ofugiirire omuseere ono gagame engo nʼabaganda babe, ese kole owiidu mu hifo hihye. ");
INSERT INTO nuj_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Olwohuba nagama tye eyiri Bbaabba, omwana oyo nʼaŋumaŋo? Kusunga wunjeede tagama ohubona ehija ohwola hu Bbaabba.” ");
INSERT INTO nuj_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yuda nʼahenire ohweririgana, Yosefu gaali saahisobola hweyongera ohwehweherera eyiri abaganda babe mu moni jʼabaŋeeresa babe. Olwʼehyo, galagira Abaŋeeresa abo baŋweŋo batule ebulafu. Kale ni ŋaali ni ŋaŋumaŋo omuutu owundi yesiyesi ohutusaho abalebe babe, ngʼabaloma ati, “Ese ndiise Yosefu.” ");
INSERT INTO nuj_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ngʼahena alira nʼejanjaasi eryʼamaani, nʼAbamisiri abaali ebulafu baaŋulira era batiina balomeraho nʼabomu mago ga Falaawo. ");
INSERT INTO nuj_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Nga Yosefu aloma abaganda babe ati, “Ese ndiise Yosefu! Bbaabba ahiiriŋo mulamu?” Aye abaganda babe ni baŋulira ehyo, sibamugobolamo olwʼesisi. ");
INSERT INTO nuj_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ngʼaŋo Yosefu aloma abaganda babe ati, “Mwigerere ŋano.” Ni beegerera aŋa gaali ngʼabaloma ati, “Ndiise Yosefu muganda yenywe, oyu mwagusa abaatu bʼe Misiri. ");
INSERT INTO nuj_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Aye ŋaŋume aluŋira owahye era muteralihirira olwohuba mwatunda hyapweramo ohuba ŋano, olwohuba Hatonda gapindiha eno mbeherereyo ponie obulamu wʼabaatu. ");
INSERT INTO nuj_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ŋaahani myaha ebiri enjala nʼeruma aye emyaha etaanu mu moni, ŋaja huŋumaŋo ohuhoma nʼohuhungula. ");
INSERT INTO nuj_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ne Hatonda gapindiha eno ohubehererayo, ko enywe nʼabejuhulu benywe mwahaŋona mu ngeri eyeŋunjisa, mwahasigalaŋo ni muli balamu hu hyalo huno. ");
INSERT INTO nuj_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Sindiinywe omwagira naaja ŋano aye Hatonda. Gafuula omuŋi wʼamagesi omuhulu owa Falaawo, omuhungu wʼamago gage era omuŋugi wʼehyalo hyʼe Misiri hyosihyosi. ");
INSERT INTO nuj_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Kale mwagameyo mangu mulomere Bbaabba muuti, ‘Yosefu omwana wuwo aloma ati Hatonda gamufuula muŋugi wʼegwanga lyʼe Misiri lyosiryosi. Olwʼehyo, yanguŋaho wuuje eno mangumangu. ");
INSERT INTO nuj_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Oja humenyanga mu twale lyʼe Goseni era oja huba ŋaapi ni neese, ewe nʼabaana ko nʼabejuhulu babo nʼetaama nʼembusi nʼeŋombe ko ni neebyo byosibyosi ebi oli ni nabyo. ");
INSERT INTO nuj_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Nja huhulabirira nʼoli eno, olwohuba enjala ehiiruma emyaha etaanu ejomu moni. Ŋano sooja hulumwa enjala.’ ");
INSERT INTO nuj_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Enywe mwabeene ko ni muganda yange Bbenjamini, mubona muuti mu butuufu oweene, ndiise ali huloma ni nenywe. ");
INSERT INTO nuj_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Mutiine mulomere Bbaabba hu ŋono eri ndi ni nalyo ŋano mu gwanga lyʼe Misiri nʼebiŋamba hu biitu ebindi byosibyosi ebi muweene era muhene mumuleete ŋano mangu.” ");
INSERT INTO nuj_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ngʼaŋo ahena agwa mugandawe Bbenjamini mu hifuba nga bombi bakukumusa amasiga olwʼesangaalo. ");
INSERT INTO nuj_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ni gahena ngʼagwa abaganda babe bosibosi mu bifuba nakukumusa amasiga olwʼesangaalo. Oluvanyuma ngʼabaganda babe batandiiha ohuŋaya ni naye. ");
INSERT INTO nuj_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Amaŋuliro ni goola mu lubiri lwa Falaawo ti abaganda ba Yosefu baali bajire, Falaawo nʼabahungu babe bosibosi baali basangaafu. ");
INSERT INTO nuj_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Nga Falaawo aloma Yosefu ati, “Loma abaganda babo oti, ‘Mutwihe emigugu hu nasugirya jenywe mwagame e Kanani, ");
INSERT INTO nuj_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","muleete senywe nʼamago genywe, muuje mube eno. Nja hubaŋa e twale erisingira erala obulaŋi era muja huba nʼemere.’ ");
INSERT INTO nuj_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Era balome oti, ‘Mutiine nʼebigaali ohuŋwa ŋano e Misiri, ohugegeramo abaana abaŋere nʼabahasi benywe, muleete ni senywe.’ ");
INSERT INTO nuj_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Era mutafaayo hu biitu byenywe ebi muli ni nabyo eyo olwohuba ebiraŋi byosibyosi ebyomu gwanga lyʼe Misiri, biija huba byenywe.” ");
INSERT INTO nuj_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ngʼabasaani ba Yisirayiri bahola baatyo. Nga Yosefu abaŋa ebigaali, ngʼolu Falaawo galagira era gabaŋa nʼemere eyohulira mu ngira. ");
INSERT INTO nuj_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Nga hiisi mulala hu bo amuŋa ebyambalo ebinyaaha aye ngʼaŋa Bbenjamini ebitundu byʼefeeza ebihumi bidatu nʼebyambalo emigigi etaanu. ");
INSERT INTO nuj_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ngʼaŋeeresa semwana nasugirya ehumi ni jetwihire ebiraŋi ebyomu gwanga lyʼe Misiri, ni nasugirya ekasi ehumi ni jetwihire engaano nʼemere nʼebyohulira mu ngira ni batiina. ");
INSERT INTO nuj_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ngʼaŋo aseebula abaganda babe abo ahena abaloma ati, “Mutaduhanira mu ngira.” ");
INSERT INTO nuj_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ngʼabaganda babe batiina baŋwa e Misiri, boola mu hyalo hyʼe Kanani eyiri Yakobbo laata yaawe. ");
INSERT INTO nuj_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Nga bamuloma baati, “Yosefu ahiiriyo mulamu era muhulu njʼaŋuga ehyalo hyʼe Misiri.” Aye ehyo hyamuŋoleresa era sigahifugiirira. ");
INSERT INTO nuj_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Aye ni bamulomera byosibyosi ebi Yosefu gabaloma, gabona nʼebigaali ebi Yosefu gaŋindiha ohumugega ohumuŋira e Misiri, nga Yakobbo laata yaawe agobolamo amaani. ");
INSERT INTO nuj_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ngʼaŋo Yisirayiri aloma ati, “Ŋaahani fugiirira! Yosefu omwana wange ahiiriyo mulamu. Nja hutiina muboneho ni kiiri hufa.” ");
INSERT INTO nuj_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Nga Yisirayiri aŋamba olugendo atiina nʼebiitu bibye byosibyosi ebi gaali ni nabyo era ni goola e Bberuseebba, gaŋayo eŋongo eyiri Hatonda wa Yisaka semwana. ");
INSERT INTO nuj_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Nga Hatonda aloma ni Yisirayiri mu hirooto owiire ati, “Yakobbo, Yakobbo.” Nga Yakobbo amugobolamo ati, “Wanji Musengwa.” ");
INSERT INTO nuj_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Nga Hatonda amuloma ati, “Ndiise Hatonda, Hatonda wa lataawo, otatya hutiina e Misiri, olwohuba ndihufuulira eyo egwanga ebbala. ");
INSERT INTO nuj_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nja hwehirira ni neewe ohutiina mu gwanga lyʼe Misiri era mu butuufu oweene ndihugobosa ŋano. Era nʼolifa, Yosefu alihugolola.” ");
INSERT INTO nuj_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ngʼaŋo Yakobbo aŋwa e Bberuseebba, ngʼabaana ba Yisirayiri bagega Yakobbo laata yaawe, nʼabaana nʼabahasi baawe, mu bigaali ebi Falaawo gabaŋindihira ohugenderamo. ");
INSERT INTO nuj_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Nga baŋira ebisolo byawe ko nʼebiitu byawe ebi baasuna mu gwanga lyʼe Kanani, nga Yakobbo nʼolulyo lulwe lwosirwosi batiina e Misiri. ");
INSERT INTO nuj_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Gatiina e Misiri nʼabasaani nʼabahaana ko nʼabejuhulu babe, olulyo lulwe lwosirwosi. ");
INSERT INTO nuj_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Amasiina gʼabasaani ba Yisirayiri (Yakobbo nʼabasaani babe) abaatiina e Misiri ngagano: Lubbeeni omusaani wa Yakobbo omudaayi. ");
INSERT INTO nuj_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Abasaani ba Lubbeeni baali nje Kanoki ni Paalu ni Kezirooni ni Karumi. ");
INSERT INTO nuj_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Abasaani ba Simyoni baali nje Yemweli ni Yamini nʼOkadi ni Yakini ni Zokali ni Sawulo omwana wuwe mu muhasi Omukanani. ");
INSERT INTO nuj_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Abasaani ba Leevi baali nje Girisoni ni Kohasi ni Merari. ");
INSERT INTO nuj_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Abasaani ba Yuda baali nje Eri nʼOnani ni Seera ni Pereezi ni Zeera. Aye Eri nʼOnani baafiira mu hyalo hyʼe Kanani. Abasaani ba Pereezi baali nje Kezirooni ni Hamuli. ");
INSERT INTO nuj_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Abasaani ba Yisikaali baali nje Toola ni Puuva ni Yobbu ni Simurooni. ");
INSERT INTO nuj_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Abasaani ba Zebbulooni baali nje Seredi nʼEloni ni Yaleeri. ");
INSERT INTO nuj_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Abo njʼabasaani ba Leeya aba gasaalira Yakobbo mu Padani Alaamu ohwongera hu ba Dina omuhaana wuwe gasaala. Abaana babe bosibosi, abaseere nʼabahaana baali adatu nabadatu. ");
INSERT INTO nuj_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Abasaani ba Gaadi baali nje Zifooni ni Hagi ni Suuni nʼEzibboni nʼEri nʼArodi nʼAleeri. ");
INSERT INTO nuj_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Abasaani bʼAseri baali nje Yimuna ni Yisuva ni Yisuvi ni Bberiya. Mboojo yaawe gaali nje Seera. Abasaani ba Bberiya baali nje Hebberi ni Malukiyeeli. ");
INSERT INTO nuj_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Abo njʼabaana aba Zilupa gasaalira Yakobbo. Zilupa njʼoyu Labbaani gaaŋa Leeya omuhaana wuwe ohuba omwidu wuwe. Bosibosi ŋalala, Yakobbo gamusunamo abaatu ehumi namukaaga. ");
INSERT INTO nuj_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Abasaani ba Lakeeli muha ya Yakobbo baali nje Yosefu ni Bbenjamini. ");
INSERT INTO nuj_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yosefu gasaala Manase nʼEfulayimu nʼali e Misiri. Asenaasi omuhaana wa Potifeera omusengi wa Oni njʼowaali nyinaawe. ");
INSERT INTO nuj_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Abasaani ba Bbenjamini baali nje Bbeera ni Bbekeri nʼAsubbeeli ni Geera ni Naamani nʼEki ni Roosi, Mupiimu ni Hupimu nʼArudi. ");
INSERT INTO nuj_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Abo njʼabasaani ba Lakeeli aba gasaalira Yakobbo, ŋalala baali ehumi nabane. ");
INSERT INTO nuj_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Omusaani wa Daani gaali nje Husimu. ");
INSERT INTO nuj_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Abasaani ba Nafutaali baali nje Yahizeeri ni Guuni ni Yezeri ni Silemu. ");
INSERT INTO nuj_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Abo njʼabasaani ba Yakobbo aba Bbiluha gamusaalira. Bbiluha oyo njʼoyu Labbaani gaaŋa Lakeeli omuhaana wuwe, abe mwidu wuwe. Era njʼowamusaalira abaana musanvu ŋosiŋosi. ");
INSERT INTO nuj_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Abo bosibosi abaatiina e Misiri ni Yakobbo, abomu lulyo lulwe nʼotuhiiseho abahasi bʼabaana babe, baali abaatu kaaga namukaaga. ");
INSERT INTO nuj_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Nʼogataho abasaani ba Yosefu ababiri aba gasaalira e Misiri, ohuŋirira ŋalala, abaatu abomu mago ga Yakobbo abaatiina e Misiri bosibosi baali sanvu. ");
INSERT INTO nuj_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Nga Yakobbo atuma Yuda eyiri Yosefu ohumuŋa endagiriro eyitiina e Goseni. Ni boola mu twale lyʼe Goseni, ");
INSERT INTO nuj_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","nga Yosefu aŋamba ehigaali hihye, atiina mu Goseni ohwagaanana Yisirayiri semwana. Yosefu ni gahubba emoni hu semwana ati bbepa, gatiina gamugwa mu hifuba, ngʼalira ohuhena ehiseera ehyene ehireeŋi olwʼesangaalo. ");
INSERT INTO nuj_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Oluvanyuma, nga Yisirayiri aloma Yosefu ati, “Ŋaahani nʼolu fa nefiira olwohuba kuweene nʼemoni jange nabona ti ohiiri mulamu.” ");
INSERT INTO nuj_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ngʼaŋo Yosefu aloma abaganda babe nʼabaatu abandi abaatiina e Misiri ni semwana ati, “Nahatiine eyiri Falaawo mulome ti, ‘Abaganda bange nʼabaatu abandi abaajire ni Bbaabba ababaaye ni bamenya mu hyalo hyʼe Kanani, bajire ohumenya eno ni neese. ");
INSERT INTO nuj_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Abaatu abo baayi bʼebyayo era bajire nʼebyayo ko nʼebiitu byawe byosibyosi.’ ");
INSERT INTO nuj_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Falaawo nʼabalanga gababuusa ati, ‘Muhola mirimo hi?’ ");
INSERT INTO nuj_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Mumugobolangamo muuti, ‘Efe abeedu babo huli baayi byʼebyayo ohuŋwa mu buŋere weefe hyʼabasehulu beefe ngʼolu baali.’ Ehyo hiija humuleetera ohubaleha mumenye mu twale lyʼe Goseni olwohuba Abamisiri benyinyalya abaayi.” ");
INSERT INTO nuj_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Nga Yosefu atiina alomera Falaawo ati, “Bbaabba gajire ohuŋwa e Kanani nʼabaganda bange nʼebyayo byawe ko nʼebiitu byawe byosibyosi era bali e Goseni.” ");
INSERT INTO nuj_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Era gatobolamo hu baganda babe bataanu ngʼabaŋira ewa Falaawo. ");
INSERT INTO nuj_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Nga Falaawo abuusa abaganda babe abo ati, “Muhola mirimo hi?” Nga bamugobolamo baati, “Efe abeedu babo huli baayi hya basehulu beefe.” ");
INSERT INTO nuj_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Nga bamuloma baati, “Hujire ohubaaho eno olwohuba enjala yʼamaani e Kanani era ebyayo byefe biŋuma nʼenyaasi eryʼohwaya. Huhusunga otufugiirire humenye mu twale lyʼe Goseni.” ");
INSERT INTO nuj_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Nga Falaawo aloma Yosefu ati, “Lataawo nʼabaganda babo bajire eyi oli, ");
INSERT INTO nuj_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","egwanga lyʼe Misiri liri mu mihono jijo, leha lataawo nʼabaganda babo beehale mu twale erihira obulaŋi. Hababe e Goseni. Nʼoba nʼomanyire mulala hu bo ali nʼomuhono ogwohwaya, muŋe alabirirenga ebyayo byange.” ");
INSERT INTO nuj_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ngʼaŋo Yosefu aŋira Yakobbo semwana eyiri Falaawo. Yakobbo nʼahenire ohuheesa Falaawo nʼohumusabira ekabi, ");
INSERT INTO nuj_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","nga Falaawo amubuusa ati, “Oli nʼemyaha jinga?” ");
INSERT INTO nuj_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Nga Yakobbo agobola mu Falaawo ati, “Kenire emyaha cikumi nʼadatu ni senguujuha mu hyalo muno. Emyaha jange mitono era ja bigosi aye sijoola hu myaha ja basehulu bange abaali abagendi.” ");
INSERT INTO nuj_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Nga Yakobbo asabira Falaawo ekabi ahena aŋwaŋo atiina. ");
INSERT INTO nuj_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ebyo ni byaŋwa, nga Yosefu aŋamba semwana nʼabaganda babe abaŋa eroba mu twale lyʼe Lameseesi erihirayo obulaŋi mu gwanga lyʼe Misiri bamenyamo ngʼolu Falaawo galagira. ");
INSERT INTO nuj_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Nga Yosefu aŋa semwana nʼabaganda babe ko nʼabaatu aba gaali ni nabo emere ohusizira hu bungi wʼabaana baawe. ");
INSERT INTO nuj_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Mu hiseera ehyo, ŋaali ŋaŋumaŋo mere mu hyalo hyosihyosi olwohuba enjala yaali nyingi bugali. ");
INSERT INTO nuj_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Nga Yosefu ahumbaania ebbeesa josijosi ejaali mu gwanga lyʼe Misiri nomu Kanani eji batundanga mu ngaano ngʼajiŋira mu lubiri lwa Falaawo. ");
INSERT INTO nuj_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Abaatu bʼe Misiri nʼe Kanani ni batambisa ebbeesa jaawe josijosi jabaŋwaho, batiina eyiri Yosefu bamuloma baati, “Muhulu, tuŋe emere. Otatuleha hufa enjala. Ebbeesa jituŋoyeeho.” ");
INSERT INTO nuj_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Nga Yosefu abaloma ati, “Ngʼolu bbeesa jibaŋoyeho, ŋahani muleete ebyayo byenywe mbaŋemo emere.” ");
INSERT INTO nuj_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Nga bamuŋirira embalaasi nʼetaama nʼeŋombe ni nasugirya jaawe, abaŋamo emere. Ngʼomwaha ogwo gaaja abaŋa emere mu byayo byawe byosibyosi. ");
INSERT INTO nuj_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Omwaha ogwo ni gwaŋwaho, nga nindi abaatu batiina eyiri Yosefu omwaha ogwalondaho bamuloma baati, “Sihuŋanga hwehweherera musengwa yeefe, mu butuufu oweene ebbeesa jatuŋwaho nʼebyayo byefe byosibyosi ŋahani bibyo. Ŋahani huŋuma hiitu hyosihyosi ohutusaho emibiri nʼamaloba geefe. ");
INSERT INTO nuj_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Huhusunga otatuleha hufa enjala hulehe aŋo amaloba geefe. Tugule era ogule nʼamaloba geefe otuŋemo emere. Efe huja hufuuha beedu ba Falaawo nʼamaloba geefe gafuuhe gage. Tuŋe emere hwahaŋona enjala, amaloba geefe gatasigala aŋo ni muŋumamo muutu.” ");
INSERT INTO nuj_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Olwʼenjala ohubitiirira mu gwange lyʼe Misiri, abaatu bagusa Yosefu amaloba gaawe, nga gafuuha ga Falaawo. Hiisi Mumisiri gaali nʼohutunda eroba lirye olwʼenjala, ngʼeroba lifuuha lya Falaawo. ");
INSERT INTO nuj_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Nga Yosefu afuula abaatu beedu ohuŋwa hu salo lyʼe gwanga lyʼe Misiri ohwola hu yindi. ");
INSERT INTO nuj_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Aye sigagula loba lyʼabasengi olwohuba basunanga omugabo ohuŋwa ewa Falaawo era balinga nʼemere eyibahena. Ehyo nje hyagira ndibatunda byawe. ");
INSERT INTO nuj_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Nga Yosefu aloma abaatu ati, “Ale ŋahani ngʼolu mbagulire, muli baatu ba Falaawo nʼeroba lyenywe lyosiryosi lya Falaawo. Owumo mbobuno muje muhome. ");
INSERT INTO nuj_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Aye ni mugesa emere, muli nʼohuŋa Falaawo hirala ehyohutaano, efikaho esigale yenywe nʼabaana benywe ko nʼabaatu abamenya ni nenywe.” ");
INSERT INTO nuj_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ngʼabaatu bamugobolamo baati, “Muhulu hufugiirira ohuba beedu ba Falaawo olwohuba obaaye wahyere eyi huli otuŋonisye ohufa enjala.” ");
INSERT INTO nuj_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Nga Yosefu ahitaŋo ngʼegambi mu gwanga lya Misiri nʼohwosa hatyane ti hirala ehyohutaano ehyʼamakungula bya Falaawo. Eroba lyʼabasengi lyoŋene njeritafuuha lya Falaawo. ");
INSERT INTO nuj_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Nga Abayisirayiri bamenya mu gwanga lyʼe Misiri mu twale lyʼe Goseni. Basuna obuŋinda era hiisi ehi baŋambangaho hyalimo ehyasa era beyongera obungi bugali. ");
INSERT INTO nuj_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Nga Yakobbo ahena emyaha ehumi namusanvu mu gwanga lyʼe Misiri. Nga ŋalala ŋosiŋosi aba nʼemyaha cikumi ane namusanvu. ");
INSERT INTO nuj_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ehiseera ni hyali huupi ohwola Yisirayiri ohufa, galanga omusaani wuwe Yosefu ngʼamuloma ati, “Pambire ehisa ote omuhono gugwo ŋaasi wʼehisambi hyange, olayire oti oja hundaga ehyere era obe mwesigwa eyi ndi mutasiiha mu gwanga lyʼe Misiri. ");
INSERT INTO nuj_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Aye ni fanga, wungeganga watusa e Misiri, wapira wasiiha ŋalala nʼabaatu bange.” Nga Yosefu amugobolamo ati, “Nja huhola ngʼolu olomire.” ");
INSERT INTO nuj_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Nga Yisirayiri amuloma ati, “Layira oti oja huhola ngʼolu oli husuubisa.” Ngʼaŋo Yosefu amulayirira. Nga Yisirayiri gediira hu muhoomero gugwe ajumirya Hatonda. ");
INSERT INTO nuj_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Oluvanyuma lwʼendaalo sinyingi, balomera Yosefu baati, “Lataawo mulwaye bugali.” Ngʼaŋo Yosefu atiina nʼabasaani babe bombi Manase nʼEfulayimu ohubona semwana. ");
INSERT INTO nuj_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ni balomera Yakobbo baati, “Omusaani wuwo Yosefu gajire ohuhubona,” Yisirayiri gahahamuha gehala hu hitanda. ");
INSERT INTO nuj_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Nga Yakobbo aloma Yosefu ati, “Hatonda Omwene Buŋangi gambonehera e Luuzi mu gwanga lyʼe Kanani, nga gaapa ekabi, ");
INSERT INTO nuj_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","aloma ati, ‘Nja huhwasa ni ngalamya olusaaye lulwo. Nja hufuula olusaaye lulwo ohuba amawanga mangi era ndibaŋa ehyalo hino ohuba obutaka emirembe nʼemirembe.’ ");
INSERT INTO nuj_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ŋaahani abasaani babo bombi Efulayimu ni Manase, aba wasaalira mu gwanga lyʼe Misiri muno, ni kiiri huuja baaja hufuuha bange. Abaana abo Efulayimu ni Manase baaja hufuuha bange ngʼolu Lubbeeni ni Simyoni baali baana bange. ");
INSERT INTO nuj_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Abaana abawasaala oluvanyuma, baaja huba babo era baaja husuna emiŋuluho ohuŋwa hu bahyawe abo ababiri. ");
INSERT INTO nuj_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Kola hino olwʼehyo ehyola hu maawo Lakeeli. Ni naali ni pwa e Padani, ehyʼenaku nga gafiiraho mu ngira mu hyalo hyʼe Kanani ni ŋahiiriŋo ahanaaŋiro ohwola Efulaasi. Kale nga musiiha eyo hu engira eyitiina e Efulaasi” (nje Bbeserekemu). ");
INSERT INTO nuj_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Yisirayiri ni gabona abasaani ba Yosefu, ngʼabuusa ati, “Bano baana bʼani?” ");
INSERT INTO nuj_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Nga Yosefu agobolamo mu semwana ati, “Bano njʼabaana aba Hatonda gaapera ŋano.” Nga Yisirayiri amuloma ati, “Baleete ŋano mbasabire ekabi.” ");
INSERT INTO nuj_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Emoni ja Yisirayiri jaali sijibona bulaŋi olwʼobusahulu. Nga Yosefu abegeresa ŋaapi ni semwana, Ngʼaŋo Yisirayiri abagwa mu hifuba abafumbeerera. ");
INSERT INTO nuj_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Nga Yisirayiri aloma Yosefu ati, “Naali sipeega ti nja huhubonaho nindi. Ne Hatonda gapaaye ekabi naabona nohu lusaaye lulwo lwosi.” ");
INSERT INTO nuj_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Nga Yosefu abatusa mu magulu ga sehulu yaawe geyala hwiroba mu moni jije. ");
INSERT INTO nuj_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Nga Yosefu abaŋamba bombi, Efulayimu amuluŋamya hu muhono gwa Yisirayiri omugooda. Era ngʼaŋamba Manase mu muhono gugwe omugooda amuluŋamya hu muhono gwa Yisirayiri omulungi. ");
INSERT INTO nuj_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Aye Yisirayiri gajanula emihono ni jibitangeene, gaŋamba omuhono gugwe omulungi gaguta hu mutwe gwʼEfulayimu owaali omuŋere aye ngʼaŋamba omuhono gugwe omugooda aguta hu mutwe gwa Manase owaali omudaayi. ");
INSERT INTO nuj_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ngʼasabira Yosefu ekabi ati, “Hatonda wʼabasehulu bange Yibbulayimu ni Yisaka, mu bulamu waawe bagendanga ngʼolu genda, Hatonda owundabiriiye ohuŋwa obuŋere wange wosiwosi ohwola hatyane, ");
INSERT INTO nuj_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Malayika oyo owununuuye mu bigosi byosibyosi, aŋe abaseere bano ekabi. Abaatu bakebulirenga era bahebulirenga ni Yisaka Bbaabba ni Yibbulayimu sehulu yange olwʼabaseere bano, basalagane ekasi nʼesinde beyongere era baale hu hyalo.” ");
INSERT INTO nuj_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yosefu ni gabona semwana nʼataaye omuhono gugwe omulungi hu mutwe gwʼEfulayimu, sihyamusangaasa. Olwʼehyo, gaŋamba omuhono gwa semwana omulungi ni genda agutuse hu mutwe gwʼEfulayimu agute hu mutwe gwa Manase. ");
INSERT INTO nuj_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Nga Yosefu aloma semwana ati, “Bbe, Bbaabba, Manase njʼomudaayi, ŋamba omuhono gugwo omulungi ogute hu mutwe gugwe.” ");
INSERT INTO nuj_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Aye semwana gagaana gaaloma ati, “Manyire, mwana wange, manyire. Yeesi alifuuha gwanga era yeesi aliba muhulu. Ne mugandawe omuŋere alimuhira era abejuhulu babe balifuuha mawanga mangi.” ");
INSERT INTO nuj_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Yisirayiri gabasabira ekabi hu ludaalo olwo ati, “Abayisirayiri banasabenga ekabi ni baloma baati, ‘Hatonda ahufuule hyʼEfulayimu ni Manase.’ ” Kale mu hubasabira ekabi, gatangirisa Efulayimu mu hifo hya Manase. ");
INSERT INTO nuj_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Nga Yisirayiri aloma Yosefu ati, “Ese ndi huupi hufa aye Hatonda anaabenga ŋalala ni nenywe era alibagobosayo mu hyalo hya basehulu benywe. ");
INSERT INTO nuj_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Era ewe ndiiwe oyu paaye eroba eryomu twale lyʼe Sekemu eri nasuna olu nasoosa Abamooli nʼepiima nʼobusaale. Omugabo gugwo guli nʼohuhira ogwabahyo.” ");
INSERT INTO nuj_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ngʼaŋo Yakobbo alanga abasaani babe abaloma ati, “Muhumbaane mbalomere ebiribabaho mu biseera ebiija mu moni. ");
INSERT INTO nuj_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Muhumbaane, muŋulire, enywe abasaani ba Yakobbo. Muŋulire ehi senywe Yisirayiri aloma. ");
INSERT INTO nuj_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Lubbeeni, ndiiwe namudaayi wange, ndiiwe oweeta amaseere gange, eŋono nʼamaani gago gahira aga bosibosi. ");
INSERT INTO nuj_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ewe otabuha hyʼamaaji agabanda, sooja huba wʼeŋono olwohuba waniina hu hitanda hya lataawo, hu buliri wange wawonoona, waŋenyuha nʼomuhasi wange. ");
INSERT INTO nuj_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simyoni ni Leevi baganda, epiima jaawe bisoosa ebisihiirisa. ");
INSERT INTO nuj_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Sinja hubeŋimbaho mu huteesa hwawe, sinja huba mu luhiiho lwawe, olwʼetima lyawe beeta abasinde, era balemasa eŋombe ebunwa ohwenda ohwesangaasa. ");
INSERT INTO nuj_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Obusungu waawe buholimirwe, olwohuba bungi, obuhambwe waawe obuleeta olusisimo. Ndi sasaania abejuhulu babo mu Yisirayiri mwosimwosi. ");
INSERT INTO nuj_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Ewe Yuda, abaganda babo baja huhutendanga, banahuhubbirenga amafuha, olwohuba oja huŋangula abalabe babo. ");
INSERT INTO nuj_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Mwana wange Yuda oli musira hyʼepologoma, eyigobola ohuŋwa mu huŋiima. Mwana wange Yuda oli musira hyʼepologoma, njʼani ahusagadula? ");
INSERT INTO nuj_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Esimbo yʼowaami siyija huŋwa mu ngalo ya Yuda, oba esimbo yʼobuŋugi ohuŋwa mu ngalo yʼabejuhulu babe, ohwola olu omweneeyo aliija ohuyiŋira oyo oyu baatu bosibosi mu hyalo baligondera. ");
INSERT INTO nuj_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Emizabbibbu jije jiryama bugali, jiryama goola nʼohujirobbaho nasugirya era alyosa engoye mu mwenge omutwahaali ogwomu mizabbibbu. ");
INSERT INTO nuj_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Emoni jije jiritwahaala ohuhiraho omwenge gwʼemizabbibbu, nʼameeno gage galiba mahosa hyʼamabeere. ");
INSERT INTO nuj_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zebbulooni aja humenya hu gobo lyʼenyanja, eyo hu mwalo eyi amaato gagobera. Esalo yiye eja huba yi Sidoni. ");
INSERT INTO nuj_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Yisikaali ali hya nasugirya eyʼamaani, egalamira ŋagati wʼemigugu ne ni tasobola hwenyoha. ");
INSERT INTO nuj_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Cooka nʼabona ehifo ehi ali huŋuumuliramo ni hiri hiraŋi era ni hyesiimisa, agonda bamutwiha emigugu, gaahola owiidu. ");
INSERT INTO nuj_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Ewe Daani oja hulamulanga abaatu babo nʼotehubbira, nga hirala hu biha bya Yisirayiri. ");
INSERT INTO nuj_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Daani oja huba wahabi hyʼomusota ogweteegire hu tulo wʼoluguudo, hyʼefulugudu hu tulo wʼoluguudo, ebooja ohugulu hwʼembalaasi yesinduha ngʼoyo ayihayeho agwa hinyumanyuma.” ");
INSERT INTO nuj_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ni gahena ngʼalomba ati, “O Musengwa, kusunga wuuje wunoŋole.” ");
INSERT INTO nuj_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Nga Yakobbo atiina mu moni nʼohulaamira abaana babe ati, “Ewe Gaadi, ehibinja hyʼabasigu hirihuwaagala, aye olyesoolaho wahibbinga era baduluma ni bataheja nʼegongo. ");
INSERT INTO nuj_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Ewe Aseri, eroba liryo lija huba gimu bugali, abejuhulu babo balimanga emere eyi bahabaha baliryanga. ");
INSERT INTO nuj_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Ewe Nafutaali wuuja huba hyʼemaadu eyetaaya mwisugu era esaala otwana otuboneha obulaŋi. ");
INSERT INTO nuj_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yosefu oja huba hyʼomuzabbibbu ogwamera hu tulo wʼolwabi, oguleremala nʼamasaga gagwo ganiina gasingaho nʼehiteepe. ");
INSERT INTO nuj_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Abalabe babo bahuwaagala nʼobuhambwe owʼamaani, nga ko balasa obusaale nʼehabyo. ");
INSERT INTO nuj_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Aye waguma wanywanywasa ehisoosa hihyo, olwohuba Omwene Buŋangi, Hatonda wa Yakobbo, Oyo Amulabirira era Ogubaale omu Yisirayiri geŋogoma, ");
INSERT INTO nuj_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Hatonda wa lataawo, gahuyeeda, Hatonda Omwene Buŋangi ahuŋe ekabi, ekabi eja ŋamugulu mwigulu, ekabi ejiŋwa ŋaasi mwiroba, ahuŋe ekabi osaale ekasi nʼesinde era nʼebyayo bibyo bisaalagane. ");
INSERT INTO nuj_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ekabi eji lataawo ali huhuŋa jihiriraho erala ejo ejiŋwa mu sozi, esozi ejibaŋo emirembe nʼemirembe, era eŋingi ejolubeerera ekabi ejo josijosi jibe hu Yosefu olwohuba ewe onaabenga mulangira mu balebe babo. ");
INSERT INTO nuj_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Ŋaahani ewe Bbenjamini oli hya nahinywamalwa, mu mugamba ahafuula ehyaŋiimire era ehyʼegulo gaheneresa ehi asigahiise.” ");
INSERT INTO nuj_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ebyo byosibyosi njʼebiha bya Yisirayiri ehumi nabibiri era ebyo mbebi saawe galomaho nʼabasabira ekabi, hiisi muutu namuŋa ekabi ejimusaanira. ");
INSERT INTO nuj_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ngʼaŋo saawe Yakobbo abaloma nʼabahamiirisa ati, “Ndi huupi hufa aye ni fanga, musiihanga ŋalala nʼabasehulu bange mu pungulu eyiri mu hisugu ehyali ehyʼEfulooni Omuhiiti, ");
INSERT INTO nuj_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","mu pungulu eyiri e Makupeera ŋaapi ni Mamule mu hyalo hyʼe Kanani. Ehisugu ehyo Yibbulayimu gahigula hu Efulooni Omuhiiti ohusiihangamo abaatu babe. ");
INSERT INTO nuj_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ŋaweene aŋo, paŋa baasiiha Yibbulayimu ni Saala omuhasi wuwe, ŋaweene aŋo paŋa baasiiha Yisaka ni Labbeka omuhasi wuwe era aŋo paŋa nasiiha Leeya. ");
INSERT INTO nuj_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ehisugu omuli epungulu eyo, bahigula hu Bahiiti.” ");
INSERT INTO nuj_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakobbo ni gahena ohulaabbira abasaani nʼebibono ebyo, ngʼadunda amagulu agata hu hitanda gegolola, nga geesa omuuya ogusembayo, ngʼafa. ");
INSERT INTO nuj_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Nga Yosefu agwa hu semwana, alira nʼamufumbereeye olwobulumi nʼohwenda ohu gaali nʼamwendamo. ");
INSERT INTO nuj_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Nga Yosefu alagira abeedu babe abasaŋu ohuta obulesi hu mulambo gwa semwana Yisirayiri, gutabola. Ngʼabasaŋu abo bahola ngʼolu babalagira. ");
INSERT INTO nuj_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ohuhola hu mulambo gutabola hyaŋiranga endaalo amahumi ane. Era Abamisiri bahena endaalo sanvu ni bamulira. ");
INSERT INTO nuj_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Endaalo ejʼohumulira ni jaŋwa, nga Yosefu aloma abahungu abaŋa Falaawo amagesi ati, “Ni muba ni mupambirwa ehisa, mundomere Falaawo muuti, ");
INSERT INTO nuj_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Bbaabba gandayisa ati, “Ndi huupi hufa era ni fanga wusiihanga mu pungulu eyi nayaba mu gwanga lyʼe Kanani.” Kale kusunga wufugiirire tiine siihe Bbaabba, oluvanyuma ko ngobole.’ ” ");
INSERT INTO nuj_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Nga Falaawo amuloma ati, “Tiina osiihe lataawo ngʼolu gahulayisa.” ");
INSERT INTO nuj_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Nga Yosefu atiina ohusiiha semwana. Abahungu ba Falaawo bosibosi bamuŋereheraho: abahulu bʼembuga ko nʼabasaaja bahulu mu gwanga lyʼe Misiri nʼabasaaja bahulu abomu nyumba yiye ");
INSERT INTO nuj_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","nʼabomu mago ga Yosefu bosibosi nʼabaganda babe ni naabo abaali mu mago ga semwana Yakobbo. Abaana baawe abaŋere nʼetaama nʼeŋombe jaawe, ebyo byoŋene njʼebyasigala e Goseni. ");
INSERT INTO nuj_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ebigaali era nabohu mbalaasi boosi bamuŋereheraho ohuja ohusiiha semwana. Ehibinja ehyamuŋerehera hyali hibbala bugali. ");
INSERT INTO nuj_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ni boola mu hifo hyʼAtadi aŋa baasiritiranga engaano, ŋaapi ni Yoludaani, abaatu bahubba enduulu era balira bugali. Nga Yosefu ahena endaalo musanvu nʼahola omukolo gwʼohulira semwana mu hifo ehyo. ");
INSERT INTO nuj_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Abakanani abaali ni bamenya mu hitundu ehyo omwali ehifo hyʼAtadi aŋa baasiritiranga engaano, baloma baati, “Abamisiri balirire bugali olwʼenaku.” Cʼehyagira ehifo ehyo ŋaapi ni Yoludaani bahiranga baati Abbiri Mizirayimu. ");
INSERT INTO nuj_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Abasaani ba Yakobbo baahola ngʼolu gabalagira: ");
INSERT INTO nuj_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","nga baŋira omulambo gwa saawe bagusiiha e Kanani mu pungulu mu hisugu hya Makupeera ŋaapi ni Mamule, ehi Yibbulayimu gagula hu Efulooni Omuhiiti ohusiihangamo abaatu babe. ");
INSERT INTO nuj_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yosefu ni gahena ohusiiha semwana, niye nʼabaganda babe ko nʼabaatu abandi bosibosi abaatiina ni naye ohusiiha semwana, baagamayo e Misiri. ");
INSERT INTO nuj_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Abaganda ba Yosefu ni baabona saawe nʼafuuye, nga baloma baati, “Ŋaahani ngʼolu Bbaabba gahenire ohufa, Yosefu asobola ohwenda ohutwesasusa olwʼehihwamuhola.” ");
INSERT INTO nuj_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ehyaŋwamo nga batuma omuutu eyiri Yosefu baati, “Lataawo ni gaali nʼahiiri hufa, galoma ati, ");
INSERT INTO nuj_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Mulomanga Yosefu muuti: Kusunga osoniŋe abaganda babo ebisirisinye ebi bahuhola.’ Ŋahani huhusunga osoniŋe abeedu ba Hatonda wa lataawo.” Ni balomera Yosefu obuhwenda owo, galira amasiga. ");
INSERT INTO nuj_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ngʼabaganda babe batiina bahubba amafuha mu moni jije, bamuloma baati, “Huli beedu babo.” ");
INSERT INTO nuj_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Nga Yosefu abaloma ati, “Mutatya. Sindi Hatonda. ");
INSERT INTO nuj_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Mwali mwendire ohukosa aye Hatonda gahicuusamo olwʼohwenda ohwoheresa ehiriŋo hatyane, ohuŋonia abaatu bangi. ");
INSERT INTO nuj_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Olwʼehyo, mutatya. Nja hubahuuma, enywe nʼabaana benywe.” Ngʼabahahasa ati eŋuma higosi hyosihyosi ehija huboolaho. Era galoma ni nabo nʼeŋoyo. ");
INSERT INTO nuj_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yosefu gamenya e Misiri nʼabomu mago ga semwana bosibosi. Gawangaala emyaha cikumi mu kumi. ");
INSERT INTO nuj_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yosefu gabona abaana bʼEfulayimu abʼomulembe ogwohudatu. Gabona nʼabaana ba Makiri omusaani wa Manase, aba boosi gabala ohuba baana babe. ");
INSERT INTO nuj_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ehiseera hyola, nga Yosefu aloma abaganda babe ati, “Ese ndi huupi hufa. Aye mu butuufu Hatonda alibanunula gabatusa mu gwanga lino gabaŋira mu hyalo ehi gasuubisa galayirira Yibbulayimu ni Yisaka ni Yakobbo ati aja hubaŋa.” ");
INSERT INTO nuj_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Nga Yosefu alayisa abasaani ba Yisirayiri ati, “Hatonda alibanunula era mugeganga amagumba gange mwagatusa mu gwanga lino.” ");
INSERT INTO nuj_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Nga Yosefu afa nʼaŋesa emyaha cikumi mu kumi. Nga bamuhalirira bamuta mu sanduuku e Misiri.");
INSERT INTO nuj_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Yakobbo oyu baali ni balanga erindi baati Yisirayiri ko nʼabasaani babe baatiina e Misiri, hiisi muutu nʼabomu mago gage. Era abasaani abo baali nje ");
INSERT INTO nuj_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Lubbeeni ni Simyoni ni Leevi ni Yuda ");
INSERT INTO nuj_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ni Yisikaali ni Zebbulooni ni Bbenjamini ");
INSERT INTO nuj_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ni Daani ni Nafutaali ni Gaadi ko nʼAseri. ");
INSERT INTO nuj_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Abaatu bosibosi abʼolulyo lwa Yakobbo baali sanvu. Mu hiseera ehyo, Yosefu gaali amenyire e Misiri. ");
INSERT INTO nuj_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Oluvanyuma, nga Yosefu nʼabalebe babe ko nʼabaatu abandi bosibosi abomu mulembe ogwo, baŋwa ohufa. ");
INSERT INTO nuj_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Aye Abayisirayiri basaala era beyongera obungi bugali, nga bejula ehyalo hyʼe Goseni. ");
INSERT INTO nuj_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ngʼaŋo Falaawo omunyaha, owaali nʼatamanyire hyosihyosi ehyali ni hiŋamba hu Yosefu, gehala hu tebe yʼobuŋugi wʼegwanga lyʼe Misiri. ");
INSERT INTO nuj_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Nga Falaawo oyo aloma abaatu babe Abamisiri ati, “Bahyange mwetegerese hino ehi njahubalomera, Abayisirayiri beyongeeye obungi bugali era bʼamaani ohutuhira. ");
INSERT INTO nuj_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Olwʼehyo, hubasalire amagesi, ni hitali cʼehyo baja hweyongera obungi era singa ŋabaaŋo olutalo baja hweŋimba nʼabalabe beefe batusoosa nga bahena bedulumiraŋo.” ");
INSERT INTO nuj_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Olwʼehyo, baabataho abanyapala ohubanyigirisa nʼemirimo emigumu, batongolera Falaawo ebibuga ebi balanganga baati Pisomu ni Lameseesi, ebyohubungangamo ebiitu. ");
INSERT INTO nuj_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Aye Abamisiri aŋa bahomya ohunyigirisa Abayisirayiri, paŋa Abayisirayiri bahoma ohweyongera obungi nʼohuhwana mu gwanga eryo. Abamisiri beesinya Abayisirayiri ");
INSERT INTO nuj_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","era babagudya bugali. ");
INSERT INTO nuj_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Abamisiri bahalubya obulamu wʼAbayisirayiri ni babatambisanga emirimo emigumu ejʼohuhubba amatafaali nʼohuholanga mu ndimiro nomu mago. Nga babatambisa byosibyosi ni batabasaasira. ");
INSERT INTO nuj_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Nga habaha wʼe Misiri aloma abasaŋu abahasi Ababbebbulaniya abasaalisa, aba baali ni balanga baati Sifura ni Puuwa ati, ");
INSERT INTO nuj_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Ni mubanga ni musaalisa abahasi Ababbebbulaniya, ne mwabona omwana nʼali museere, mumwitanga. Aye nʼabanga muhaana, mumulehanga.” ");
INSERT INTO nuj_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Aye abasaŋu abasaalisa abo, baaŋa Hatonda eŋono, sibahola ngʼolu habaha wʼe Misiri gaali nʼabalagiiye, sibeeta baana abaseere. ");
INSERT INTO nuj_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ngʼaŋo habaha wʼe Misiri atumisa bamulangira abasaalisa abo ababuusa ati, “Lwahiina muleha abaana abaseere baaba balamu?” ");
INSERT INTO nuj_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ngʼabasaalisa bagobola mu Falaawo baati, “Abahasi Ababbebbulaniya sibali hya bahasi Abamisiri, olwohuba nibo bali nʼamaani, aŋa abasaalisa baboleraho, baba bahenire hale ohwesaalira.” ");
INSERT INTO nuj_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Nga Hatonda aŋa abasaŋu abasaalisa abo ekabi era Abayisirayiri beyongera hweyongera ohwala. ");
INSERT INTO nuj_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Era olwohuba abasaŋu abasaalisa baaŋa Hatonda eŋono, gaabaŋa amago. ");
INSERT INTO nuj_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ngʼaŋo Falaawo aŋa abaatu babe bosibosi ehiragiro ati, “Hiisi mwana omuseere Omubbebbulaniya oyu basaala, mumudanyanga mu lwabi Kiyira, ne omwana omuhaana mumulehanga gabaŋo mulamu.” ");
INSERT INTO nuj_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Lulala, omusinde owomu hiha hya Leevi gaŋira omuhasi yeesi owomu lulyo lwa Leevi. ");
INSERT INTO nuj_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ngʼomuhasi oyo aba hida, asaala omwana museere. Ni gabona omwana nʼali muŋoono, gamuhweha emyesi edatu. ");
INSERT INTO nuj_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Aye ni gabona nʼataŋanga hweyongera ohumuhweha, gaŋamba ehisero ehi baluha mu mafunjo, ngʼahiŋahaho obudobo. Ngʼaŋo ataamo omwana oyo, ahena ahiŋamba ahita mu masati hwigenya wʼolwabi Kiyira. ");
INSERT INTO nuj_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Nga mboojo yʼomwana oyo gemeerera ni gesambireho, abone ehinamwoleho. ");
INSERT INTO nuj_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ngʼaŋo omuhaana wa Falaawo geehirira atiina hu lwabi Kiyira ohusaaba, nʼabeedu babe baali bagendera hu hwigenya wʼolwabi ni naye. Ni baali ni bagenda, ngʼabona ehisero mu masati ngʼatuma omwidu wuwe ahinaaŋe ahimuŋirire. ");
INSERT INTO nuj_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ni gahifunuhula, gaali aheja abona omwana. Omwana oyo gaali alihulira. Ngʼehisa himuŋambira omwana oyo. Ngʼaloma ati, “Ono mulala hu baana Ababbebbulaniya.” ");
INSERT INTO nuj_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ngʼaŋo mboojo yʼomwana oyo abuusa omuhaana wa Falaawo ati, “Tiine kulangire omuhasi Omubbebbulaniya ahwokehese omwana oyo?” ");
INSERT INTO nuj_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ngʼamugobolamo ati, “Tiina omuleete.” Omuhaana gatiina gamuleetera omuhasi nyina yʼomwana. ");
INSERT INTO nuj_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ngʼomuhaana wa Falaawo aloma omuhasi oyo ati, “Ŋira omwana ono omunjokehese, nja huhuŋanga omuhemba.” Ngʼomuhasi oyo aŋira omwana, amuhuuma. ");
INSERT INTO nuj_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Omwana oyo ni gahula, ngʼamuŋamba amuŋirira omuhaana wa Falaawo, ngʼafuuha musaani wuwe, ngʼamutaho esiina ati Musa olwohuba galoma ati, “Namutusa mu maaji.” ");
INSERT INTO nuj_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Lulala, oluvanyuma lwa Musa ohuhula, gatiina eyaali abalebe babe Ababbebbulaniya, ngʼabona ngʼolu Bamisiri baali ni babanyigirisa. Ngʼabona Omumisiri nʼahubba Omubbebbulaniya, mulala hu bʼegwanga lirye. ");
INSERT INTO nuj_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Musa ni gaheja enjuyi nʼenjuyi, ngʼabona ni ŋaŋuma muutu, gaŋamba Omumisiri gamwita, ngʼahena amwoŋeraho omujehe. ");
INSERT INTO nuj_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ni wahya, Musa ni gaali nʼagenda genda, ngʼabona abasinde Ababbebbulaniya babiri ni basoola, ngʼaloma oyo owaali omusobya ati, “Hiina ehi ohubbira Omubbebbulaniya wahyo?” ");
INSERT INTO nuj_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ngʼomusinde oyo amugobolamo ati, “Njʼani owahufuula omuhulu era omulamuzi weefe? Keesi wenda hunjita ngʼolu weetire Omumisiri?” Musa ni gaŋulira, gatya ngʼaloma mu mwoyo gugwe ati, “Abaatu bamanyire ehi naholire!” ");
INSERT INTO nuj_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Falaawo ni gaŋulira ehi Musa gahola, genda ohumwita yeesi. Aye Musa gaduluma ngʼatiina e Midiyaani. Ni goola, gatiina gehala hu sobere. ");
INSERT INTO nuj_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Mu hiseera ehyo, omusengi wʼe Midiyaani gaali nʼabahaana musanvu, abatiinanga ohudaŋa amaaji, bejusa ebiitu ebyʼohunywehesamo etaama nʼembusi ja saawe. ");
INSERT INTO nuj_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Abaayi bʼetaama nʼembusi batiina nga babbinga abahaana abo. Aye Musa genyoha gabayeeda, ganywesa ebyayo byawe. ");
INSERT INTO nuj_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Abahaana abo ni baagamayo eyiri Ruweeli saawe, gabaloma ati, “Nga mugaluhire mangu olwa leero!” ");
INSERT INTO nuj_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Nga bamugobolamo baati, “Ŋaliŋo Omumisiri atuyeedire gatuŋonia abaayi abatutaganyanga era gaadaŋa amaaji, ganywesa ebyayo byefe.” ");
INSERT INTO nuj_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Nga Ruweeli abuusa abahaana babe ati, “Ali ŋeena? Lwahiina mumulehireeyo? Mutiine mumulange, anyweho amaaji.” ");
INSERT INTO nuj_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Ngʼaŋo Musa afugiirira ohumenya ni Ruweeli owamuŋa omuhaana wuwe oyu balanganga baati Zipola, ohuba omuhasi wuwe. ");
INSERT INTO nuj_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Nga Zipola asaala omwana museere, nga Musa amutaho esiina ati nje Girisomu olwohuba ati, “Mbaye mubuli mu gwanga eritali lyange.” ");
INSERT INTO nuj_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ni ŋabitaŋo emyaha, nga habaha wʼe Misiri afa. Abayisirayiri basigala ni bahibinda olwʼowiidu obu baalimo. Nga balira era ohulira hwawe olwʼowiidu nga hwolera Hatonda. ");
INSERT INTO nuj_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Hatonda gaŋulira ohubinda hwawe ngʼahebulira endagaano yiye eyi gahola ni Yibbulayimu ni Yisaka ni Yakobbo. ");
INSERT INTO nuj_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nga Hatonda abona ohugada hwʼAbayisirayiri, gabaŋambira ehisa. ");
INSERT INTO nuj_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Lulala, Musa ni geemera ebyayo bya Yesero semwana yʼomuhasi wuwe era omusengi wʼe Midiyaani, gatiina ŋaleeŋi eyo mu lulafu, nga goola e Horebbu hu lusozi lwa Hatonda. ");
INSERT INTO nuj_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Nga malayika wa Musengwa amubonehera mu hifaananyi hyʼahadeŋo ahaali ni haaduha omuliro. Musa gabona ahadeŋo ni haaduha omuliro aye ni hataguguliha. ");
INSERT INTO nuj_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Nga Musa aloma mu mwoyo gugwe ati, “Hino hyeŋunjisa, leha nigerere mbone ehiitu hino, lwahiina ahadeŋo sihaguhuliha.” ");
INSERT INTO nuj_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Musengwa ni gabona Musa ni gegereeye ohubona ehyali ni hitiina mu moni, nga Hatonda nʼali mu hadeŋo amulanga ati, “Musa, Musa!” Nga Musa amugobolamo ati, “Wanji.” ");
INSERT INTO nuj_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Nga Hatonda amuloma ati, “Otegeerera eno. Tusamo engayito olwohuba ehifo aŋa wemereeye, hyawufu.” ");
INSERT INTO nuj_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ngʼaŋo ameedaho ati, “Ndiise Hatonda wa lataawo, Hatonda wa Yibbulayimu ni Yisaka era ni Yakobbo.” Musa ni gaŋulira ebibono ebyo, gewiiha mu moni olwohuba gatya nʼohuheja hu Hatonda. ");
INSERT INTO nuj_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ngʼaŋo Musengwa aloma Musa ati, “Mu butuufu mbwene ohubonaabona hwʼabaatu bange abali e Misiri era puliiye ohulira hwawe ni basunga ohubaŋonia abanyapala abo ababatambisa ngʼabeedu. Era manyire enaku yaawe. ");
INSERT INTO nuj_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Olwʼehyo, nihire ohubaŋonia obuŋugi wʼAbamisiri nʼohubatusa mu gwanga eryo, mbaŋire mu hyalo ehituluha amabeere nʼomudugere, hatyane ehirimo Abakanani nʼAbahiiti nʼAbamooli nʼAbapereezi nʼAbahiivi ko nʼAbayebbusi. ");
INSERT INTO nuj_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Hituufu, ohulira hwʼAbayisirayiri hwolire eyi ndi era mbwene engeri eyi Bamisiri babatulugunyamo. ");
INSERT INTO nuj_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Olwʼehyo, kutuma e Misiri eyiri Falaawo, otuseyo abaatu bange Abayisirayiri.” ");
INSERT INTO nuj_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Aye Musa galoma Hatonda ati, “Ndiise ani ohutiina eyiri Falaawo ohutusa Abayisirayiri e Misiri?” ");
INSERT INTO nuj_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Nga Hatonda amugobolamo ati, “Nja huba ŋalala ni neewe. Era hano njʼahaja ohuba ahabonero ohuhahasa haati ndiise ahutumire: Nʼohenire ohutusa abaatu abo e Misiri, mulijumirya Hatonda hu lusozi luno.” ");
INSERT INTO nuj_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ngʼaŋo Musa aloma Hatonda ati, “Singa tiina eyiri Abayisirayiri nga mbaloma ati, ‘Hatonda wa basehulu benywe gaatumire eyi muli,’ nga bambuusa baati, ‘Esiina lirye njʼani?’ Ndibaloma tye?” ");
INSERT INTO nuj_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Nga Hatonda aloma Musa ati, “Ndiise NDI. Oli nʼohulomera Abayisirayiri oti, ‘NDI gaatumire eyi muli.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Galoma Musa ati, “Loma Abayisirayiri oti, ‘Musengwa Hatonda wʼabasehulu benywe, Hatonda wa Yibbulayimu ni Yisaka ni Yakobbo, gaatumire eyi muli.’ Eryo njʼesiina lyange eri bali nʼohukebuliriraho emirembe nʼemirembe. ");
INSERT INTO nuj_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Tiina ohumbaanie abatangirisi bʼAbayisirayiri obalome oti, ‘Musengwa Hatonda wʼabasehulu benywe, Hatonda wa Yibbulayimu ni Yisaka ni Yakobbo, gamboneheeye nga gandoma niije eyi muli mbalome ti, “Mbwene ebi babaholire e Misiri. ");
INSERT INTO nuj_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Era salireeŋo ohubatusa e Misiri mu hyalo ehyohubonaabona, mbaŋire mu hyalo ehituluha amabeere nʼomudugere omuli Abakanani nʼAbahiiti nʼAbamooli nʼAbapereezi nʼAbahiivi nʼAbayebbusi.” ");
INSERT INTO nuj_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“ ‘Abatangirisi bʼAbayisirayiri baja huhuŋulirisa. Era ewe nʼabatangirisi abo mutiine eyiri habaha wʼe Misiri mumulome muuti, “Musengwa Hatonda wʼAbabbebbulaniya gaatubonehera. Olwʼehyo, tufugiirire hutiine mu lugendo olwʼendaalo edatu mu lulafu, huŋeyo eŋongo eyiri Musengwa Hatonda weefe.” ");
INSERT INTO nuj_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Aye manyire ti habaha wʼe Misiri saaja hubafugiirira hutiina ne nja humuŋagia. ");
INSERT INTO nuj_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Olwʼehyo, nja hutambisa obuŋangi wange ohuhola ebyamaliholiho e Misiri ohuyiboneresa. Oluvanyuma lwʼebyo, aja hubafugiirira ohutiina. ");
INSERT INTO nuj_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“ ‘Era nja hufuula abaatu bange bahoda mu moni jʼAbamisiri, konyo ni muba ni muŋwa e Misiri, mutaŋwayo nʼengalo njereere. ");
INSERT INTO nuj_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Hiisi muhasi Omuyisirayiri atiine eyiri omuhasi wahye Omumisiri muliranwawe, nʼeyiri omuhasi ali ewʼOmumisiri, amusunge efeeza nʼezaabbu ko nʼengoye mujiŋe abaana benywe abaseere nʼabahaana. Mu ngeri eyo muja huŋira obuŋinda bwʼAbamisiri.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Oluvanyuma, nga Musa aloma Hatonda ati, “Aye singa sibafugiirira oba ohuŋuliirisa ehi mbaloma, ni baloma baati ‘Musengwa sigahubonehera!’ ” ");
INSERT INTO nuj_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Nga Musengwa amubuusa ati, “Hiina ehi oŋambire mu ngalo?” Nga Musa amugobolamo ati, “Simbo.” ");
INSERT INTO nuj_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ngʼaŋo Musengwa amuloma ati, “Yidanye ŋaasi.” Nga Musa ayidanya ŋaasi nga yifuuha temu, ayiduluma. ");
INSERT INTO nuj_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ngʼaŋo Musengwa aloma Musa ati, “Yiŋambe omuhira.” Nga Musa aŋamba etemu eyo, nga yifuuha simbo. ");
INSERT INTO nuj_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Nga Musengwa amuloma ati, “Oholanga ahabonero aho basobole ohufugiirira baati Musengwa Hatonda wa basehulu baawe, Hatonda wa Yibbulayimu ni Yisaka ni Yakobbo, gahwehwehulira.” ");
INSERT INTO nuj_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ngʼaŋo Musengwa amuloma ati, “Yingisa omuhono gugwo mu lugoye.” Nga Musa gengisa omuhono gugwe mu lugoye. Ni gagutusamo, gwaliho ebigenge era ni guli muhosa hyʼamabaale gʼefula. ");
INSERT INTO nuj_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Nga Hatonda amuloma ati, “Yagamya omuhono gugwo mu lugoye.” Nga Musa agwagamyamo. Ni gagutusamo, gwali gutereeye ni guli hyʼebitundu ebindi ebyʼomubiri gugwe. ");
INSERT INTO nuj_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ngʼaŋo Musengwa aloma Musa ati, “Ni batahafugiirire olwʼehyamaliholiho ehisooka, baja hufugiirira olwʼehyohubiri. ");
INSERT INTO nuj_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Aye banagaana ohufugiirira olwʼebyamaliholiho ebyo byombi, odaŋanga amaaji agomu lwabi Kiyira wahena wagajuha hu woomu. Amaaji ago gaja hufuuha mafugi.” ");
INSERT INTO nuj_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ngʼaŋo Musa aloma Musengwa ati, “O Musengwa, ohuŋwa hale simanyire huloma bulaŋi era sicuuhangaho ohuŋwa olu waloma ni nange omwidu wuwo. Ese simanyire huloma bulaŋi era ndi nʼenguguma.” ");
INSERT INTO nuj_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Nga Musengwa amubuusa ati, “Njʼani ahola omuutu gahena gaamutaho omunwa? Njʼani amufuula ataloma oba omusiŋa? Era njʼani amuŋa emoni eji bona oba amuleetera ohuba omuŋofu? Sindiise Musengwa? ");
INSERT INTO nuj_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Olwʼehyo, tiina, nja huhuyeeda ohuloma era nja huhuŋa ehyʼohuloma.” ");
INSERT INTO nuj_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Aye Musa gamugobolamo ati, “O Musengwa, kusunga otume omuutu owundi.” ");
INSERT INTO nuj_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ehyo hyaleetera Musengwa ohuluŋira Musa, ngʼamuloma ati, “Obona otye omulebe wuwo oyu balanga baati Alooni Omuleevi? Manyire ti asobola ohuloma bulaŋi. Alihuuja musaŋanaane era hinamusangaase ohuhubona. ");
INSERT INTO nuj_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Olwʼehyo, onaalome ni naye, omulomere ehyohuhola. Nja hubayeeda mwembi era nja hubasomesanga ehyʼohuhola. ");
INSERT INTO nuj_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Alooni aja huloma nʼabaatu hu lulwo era aja huba oti munwa gugwo eyiri abaatu era weesi oja huba oti Hatonda eyi ali. ");
INSERT INTO nuj_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Aye tiina nʼesimbo eyo, oyitambise ohuhola ebyamaliholiho.” ");
INSERT INTO nuj_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ngʼaŋo Musa agobolayo eyiri Yesero semwana yʼomuhasi wuwe ngʼamuloma ati, “Kusunga naagame e Misiri eyiri abaganda bange, mbone oba bahiiri balamu.” Nga Yesero agobolamo mu Musa ati, “Tiina miyaaya.” ");
INSERT INTO nuj_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Musa ni gaali nʼahiiri e Midiyaani, Musengwa gaali amulomire ati, “Yagamayo e Misiri olwohuba abo bosibosi abaali ni benda ohuhwita, bafuuye baŋooyeŋo.” ");
INSERT INTO nuj_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Kale Musa gaŋamba omuhasi nʼabasaani babe gabata hu nasugirya nga gagamayo mu gwanga lyʼe Misiri. Era gaŋamba esimbo ya Hatonda ngʼatiina ni nayo. ");
INSERT INTO nuj_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Nga Musengwa aloma Musa ati, “Ŋaahani olihwagamayo e Misiri, oholanga ebyamaliholiho byosibyosi ebi kuŋaaye obuŋangi ohuholera mu moni ja Falaawo. Aye nja huhahanyasa omwoyo gugwe ohutafugiirira abaatu bange hutiina. ");
INSERT INTO nuj_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Olomanga Falaawo oti, ‘Musengwa aloma ati, Yisirayiri njʼomusaani wange omudaayi. ");
INSERT INTO nuj_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Nahuloma ti “Leha musaani yange atiine ganjumirye.” Aye ogaana ohumuleha atiine. Olwʼehyo, nja hwita omusaani wuwo omudaayi.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Musa nʼamago gage ni baali mu lugendo ni batiina e Misiri, baŋenyuha aŋaatu nga Musengwa amwagaana era gaali huupi amwite. ");
INSERT INTO nuj_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Ngʼaŋo Zipola muha Musa aŋamba ebaale eryogi, ahomola omusaani waawe. Ngʼadanya ehigode ehyo hu magulu ga Musa, amuloma ati, “Mu butuufu oli wamwange owʼamafugi!” ");
INSERT INTO nuj_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Ngʼaŋo Musengwa aleha Musa. (Mu hiseera ehyo ehi muhasi wuwe galomeramo ati, “wamwange owʼamafugi,” gaali ategeesa ohuhomola.) ");
INSERT INTO nuj_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Nga Musengwa aloma Alooni ati, “Tiina mu lulafu wagaanane ni Musa.” Ngʼatiina amwagaana hu lusozi lwa Hatonda era ngʼamugwa mu hifuba. ");
INSERT INTO nuj_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ngʼaŋo Musa alomera Alooni byosibyosi ebi Musengwa gamuloma nʼebyamaliholiho byosibyosi ebi gamulagira ohuhola. ");
INSERT INTO nuj_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Nga Musa nʼAlooni batiina bahumbaania abatangirisi bosibosi abʼAbayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Nga Alooni abalomera byosibyosi ebi Musengwa galoma Musa. Era Musa gahola ebyamaliholiho mu moni jʼabaatu abo, ");
INSERT INTO nuj_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ngʼabatangirisi bafugiirira. Era ni baŋulira baati Musengwa gaali afaayo hu bulamu waawe era ati gaali aja hubanunula, bahubba amafuha bamujumirya. ");
INSERT INTO nuj_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Lulala, nga Musa nʼAlooni batiina eyiri Falaawo bamuloma baati, “Musengwa Hatonda wʼAbayisirayiri aloma ati, ‘Leha abaatu bange batiine banyiiye embaga mu lulafu ohuupa eŋono.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Nga Falaawo ababuusa ati, “Musengwa wenywe oyo njʼani oyu ndi nʼohugondera fugiirire Abayisirayiri ohutiina? Simanyire hiitu hyosihyosi ehiŋamba hu Musengwa oyo era sinja huleha Abayisirayiri hutiina.” ");
INSERT INTO nuj_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Nga Musa nʼAlooni bamugobolamo baati, “Hatonda wʼAbabbebbulaniya gatubonehera. Huhusunga otufugiirire hutiine mu lugendo olwʼendaalo edatu huŋeyo eŋongo eyiri Musengwa Hatonda weefe mu lulafu, atatuleetaho haŋupuli oba hutuleetera lutalo.” ");
INSERT INTO nuj_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Aye habaha wʼe Misiri galoma Musa nʼAlooni ati, “Lwahiina mwenda ohulehesa abaatu emirimo jaawe? Mwagame hu mirimo jenywe.” ");
INSERT INTO nuj_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ngʼaŋo Falaawo abaloma ati, “Enywe muli nʼohuhimanya muuti Abayisirayiri beyongeeye obungi mu gwanga, nindi mwenda balehe emirimo jaawe!” ");
INSERT INTO nuj_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Hu ludaalo olwene olwo, Falaawo galagira abanyapala nʼabatangirisi bʼAbayisirayiri ati, ");
INSERT INTO nuj_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Mulehere aŋo ohuŋa abaatu enyaasi eryohuhubbisa amatafaali. Mulehe abeene batiine baleete. ");
INSERT INTO nuj_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Aye bali nʼohuhubba obungi wʼamatafaali ngʼolu babayenga ni bahubba. Mutahendesa namba yʼamatafaali. Abaatu abo badoto, cʼehigira baloma mbo baati, ‘Tulehe hutiine huŋeyo eŋongo eyiri Hatonda weefe.’ ");
INSERT INTO nuj_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Leha abasinde abo bahole emirimo ni ŋaŋuma hubasaasira balehere aŋo ohuŋuliirisa ebyʼobudulingi.” ");
INSERT INTO nuj_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ngʼaŋo abanyapala nʼabatangirisi bʼAbayisirayiri batiina nga baloma abaatu baati, “Falaawo aloma ati, ‘Sibaja hubaŋanga nyaasi. ");
INSERT INTO nuj_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Enywe wabeene mutiine mwendule enyaasi eyi munalisaŋaane. Aye enamba yʼamatafaali aga muhubba, sinja hubahendesaho naŋadiidiri.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Olwʼehyo, Abayisirayiri batiina hiisi ŋaatu mu gwanga lyʼe Misiri ni baheja enyaasi. ");
INSERT INTO nuj_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Abanyapala Abamisiri beyongera ohunyigirisa Abayisirayiri ni babaloma baati, “Mwoherese obungi wʼamatafaali aga babendaho hiisi ludaalo hyahale olu baali ni babaŋa enyaasi.” ");
INSERT INTO nuj_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Abanyapala aba Falaawo gataŋo ohulabirira emirimo eji Abayisirayiri baali ni bahola, babahubbanga ni bababuusa baati, “Lwahiina olwejo nʼolwa leero simwoherehiise bungi wʼamatafaali hyʼahale?” ");
INSERT INTO nuj_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ngʼaŋo abatangirisi bʼAbayisirayiri batiina eyiri Falaawo ni bemulugunya baati, “Lwahiina efe abeedu babo, otubisya otyo? ");
INSERT INTO nuj_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Sibatuŋa nyaasi aye batuloma ohuhubba enamba yʼamatafaali enyene eyo! Abeedu babo batuhubba. Aye esobi yiŋwera hu baatu babo.” ");
INSERT INTO nuj_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Nga Falaawo amugobolamo ati, “Muli bidoto, ŋaŋuma hindi muli bidoto! Cʼehigira musunga muuti mbo babalehe mutiine muŋonge eyiri Musengwa. ");
INSERT INTO nuj_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Olwʼehyo, mwagameyo muhole emirimo. Sibaja hubaŋa nyaasi aye muli nʼohuhubba obungi wʼamatafaali ngʼolu mubaaye ni muholanga.” ");
INSERT INTO nuj_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ehyo hyaleetera abatangirisi bʼAbayisirayiri ohumanya baati baali mu higosi, Falaawo ohubaloma ati, “Simuli nʼohuhendesa enamba yʼamatafaali aga muli nʼohuhubba hiisi ludaalo.” ");
INSERT INTO nuj_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ni baŋwa ewa Falaawo, basaŋaana Musa nʼAlooni ni babahuumire. ");
INSERT INTO nuj_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ngʼabatangirisi abo babaloma baati, “Musengwa abasalire omusango olwohuba mutuleeteeye obusuule mu moni ja Falaawo ko nʼabahungu babe era ehi mutuholire, hiri hyʼohubaŋa epiima ohutwita.” ");
INSERT INTO nuj_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Ngʼaŋo Musa agobolayo eyiri Musengwa amuloma ati, “O Musengwa, lwahiina oleeteeye abaatu bano ebigosi? Ehyo njʼehyagima waatuma? ");
INSERT INTO nuj_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ohuŋwa ni natiina ewa Falaawo ohuloma ni naye mu siina liryo, hireeteeye abaatu babo ebigosi. Ne ewe ŋaŋuma ehi oholireŋo ohubanunula!” ");
INSERT INTO nuj_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ngʼaŋo Musengwa aloma Musa ati, “Ŋaahani oja hubona ehi nja huhola Falaawo. Era olwʼobuŋangi wange, aja huleha abaatu bange batiine. Era olwʼobuŋangi wange, omwene aja hubabbinga mu gwanga lirye.” ");
INSERT INTO nuj_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Nga Hatonda aloma Musa ati, “Ndiise Musengwa. ");
INSERT INTO nuj_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ndiise owabonehera Yibbulayimu ni Yisaka ni Yakobbo nga Hatonda Omwene Buŋangi. Aye sinabehwehulira nga Musengwa. ");
INSERT INTO nuj_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Era nʼehindi, nanywania endagaano yange ni nabo, nabasuubisa ohubaŋa egwanga lyʼe Kanani eri bamenyamo ngʼabalugendwa. ");
INSERT INTO nuj_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Puliiye ohubinda hwʼAbayisirayiri, abʼAbamisiri babafuuye beedu era kebuliiye endagaano yange. ");
INSERT INTO nuj_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Olwʼehyo, loma Abayisirayiri oti, ‘Ndiise Musengwa era nja hubanoŋola mu hijoogi hyʼAbamisiri nʼohuba abeedu baawe. Nja hubanunula ohuŋwa mu wiidu wʼAbamisiri era nja hubanunula nʼomuhono gwange ogwʼamaani ni kola ebyamaliholiho ni sala omusango. ");
INSERT INTO nuj_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Enywe, nja hubafuula ohuba baatu bange era nja huba Hatonda wenywe. Mulimanya muuti Ndiise Musengwa Hatonda wenywe owabatusa mu hijoogi hyʼAbamisiri. ");
INSERT INTO nuj_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Era nja hubaŋira mu hyalo ehi nalayira ohuŋa Yibbulayimu ni Yisaka ko ni Yakobbo. Nja huhibaŋa ngʼomubuluko gwenywe. Ndiise Musengwa.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Nga Musa alomera Abayisirayiri ebiitu ebyo ebi Hatonda gamuloma aye sibabifugiirira baati bituufu olwohuba baali baŋoyeemo amaani nʼolwembisya embi eyʼowiidu eyi baali ni bababisyamo. ");
INSERT INTO nuj_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ngʼaŋo Musengwa aloma Musa ati, ");
INSERT INTO nuj_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Tiina olome Falaawo owʼe Misiri, alehe Abayisirayiri baŋwe mu gwanga lirye.” ");
INSERT INTO nuj_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Aye Musa galoma Musengwa ati, “Obanga Abayisirayiri sibafugiirira ebi wundomera, olwʼehyo ni Falaawo yeesi saaja hufugiirira ebi ndoma. Ese simanyire huloma bulaŋi.” ");
INSERT INTO nuj_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Musengwa galagira Musa nʼAlooni ati, “Mulome Abayisirayiri ni habaha wʼe Misiri muuti, ‘mbalagiiye ohutusa Abayisirayiri mu gwanga lyʼe Misiri.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Gano njʼamasiina gʼemitwe jamago gʼabaana ba Yisirayiri: Abasaani ba Lubbeeni omwana omudaayi owa Yisirayiri, baali nje Kanoki ni Paalu ni Kezirooni ko ni Karumi. Abo njʼabomu hiha hya Lubbeeni. ");
INSERT INTO nuj_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Abasaani ba Simyoni baali nje Yemweli ni Yamini nʼOkadi ni Yakini ni Zokali ni Sawulo omwana wʼomuhasi Omukanani. Abo njʼabomu hiha hya Simyoni. ");
INSERT INTO nuj_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Abasaani ba Leevi ngʼolu balondehana mu husaaliwa baali nje Girisoni ni Kohasi ni Merari. Leevi gahena emyaha cikumi adatu namusanvu. ");
INSERT INTO nuj_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Girisoni gasaala Libbuni ni Simeeyi, abaŋwamo abejuhulu eduuli. ");
INSERT INTO nuj_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohati gasaala Amulaamu ni Yizuhaari ni Kebbulooni ni Wuziyeeli. Kohasi gahena emyaha cikumi adatu nedatu. ");
INSERT INTO nuj_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari gasaala Mahuli ni Muusi. Abo njʼabomu hiha hya Leevi ŋalala nʼabejuhulu baawe. ");
INSERT INTO nuj_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amulaamu gaŋira Yokebbedi masengewe, ngʼamusaalamo Alooni ni Musa. Era Amulaamu gahena emyaha cikumi adatu namusanvu. ");
INSERT INTO nuj_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Abasaani ba Yizuhaari baali nje Koora ni Nefegi ko ni Zikuri. ");
INSERT INTO nuj_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Abasaani ba Wuziyeeli baali nje Misayeeli nʼElizafaani ko ni Sitiri. ");
INSERT INTO nuj_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Nga Alooni aŋira Eliseebba omuhaana wʼAminadabbu, mboojo ya Nasoni era gamusaalira Nadabbu ni Abbihu nʼElyazaali ko ni Yisamaari. ");
INSERT INTO nuj_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Abasaani ba Koora baali njʼAsiiri nʼElukaana nʼAbbiyasafu. Abo njʼabomu lulyo lwa Koora. ");
INSERT INTO nuj_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Elyazaali omusaani wʼAlooni gaŋira omuhaana wa Putiyeeli ngʼamusaalamo Fenekaasi. Abo njʼabomu hiha hya Leevi. ");
INSERT INTO nuj_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Alooni ni Musa abeene abo, njʼaba Musengwa galoma ati, “Mutangirire Abayisirayiri nʼebiha byawe ohuŋwa mu gwanga lyʼe Misiri.” ");
INSERT INTO nuj_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Abo mbabaloma Falaawo habaha wʼe Misiri ebiŋamba hu Bayisirayiri ohuŋwa e Misiri. ");
INSERT INTO nuj_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ŋaahani Musengwa ni galoma ni Musa mu gwanga lyʼe Misiri, ");
INSERT INTO nuj_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","gamuloma ati “Ndiise Musengwa. Lomera Falaawo, habaha wʼe Misiri hiisi ehi kuloma.” ");
INSERT INTO nuj_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Aye Musa galoma Musengwa ati, “Ese simanyire huloma bulaŋi, olwʼehyo Falaawo njʼoja hupulirisa?” ");
INSERT INTO nuj_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Nga Musengwa aloma Musa ati, “Nja huhufuula obe hya Hatonda eyiri Falaawo era mulebe wuwo Alooni aja huba hya naabbi wuwo. ");
INSERT INTO nuj_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Oli nʼohulomera Alooni hiisi ehi kuloma era yeesi ali nʼohuhiromera Falaawo ohuleha Abayisirayiri baŋwe mu gwanga lirye. ");
INSERT INTO nuj_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Aye nja huhahanyasa omwoyo gwa Falaawo, wayire mu gwanga lyʼe Misiri nja huhola obubonero oweŋunjisa, ");
INSERT INTO nuj_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","saaja huhuŋulirisa. Nja hulaga obuŋangi wange hu baatu bʼe Misiri era nja huhola ebyamaliholiho ni tusaayo Abayisirayiri, abaatu bange mu gwanga eryo. ");
INSERT INTO nuj_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ni nahalage obuŋangi wange hu Bamisiri, baja hutegeera baati ndiise Musengwa nga kena tusaayo Abayisirayiri mu gwanga eryo.” ");
INSERT INTO nuj_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa nʼAlooni baahola ngʼolu Musengwa gabalagira. ");
INSERT INTO nuj_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ehiseera ehi Musa nʼAlooni balomeramo ni Falaawo, Musa gaali ali nʼemyaha cinaana, Alooni nʼali nʼecinaana nedatu. ");
INSERT INTO nuj_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Nga Musengwa aloma Musa nʼAlooni ati, ");
INSERT INTO nuj_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Singa Falaawo abaloma ati, ‘Mukolereho ehyamaliholiho,’ Musa olomanga Alooni oti, ‘Ŋamba esimbo yiyo oyidanye ŋaasi mu moni ja Falaawo,’ yija hufuuha temu.” ");
INSERT INTO nuj_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ngʼaŋo Musa nʼAlooni batiina eyiri Falaawo, nga bahola ngʼolu Musengwa gaali nʼabalagiye. Alooni gadanya esimbo yiye ŋaasi mu moni ja Falaawo ko nʼabahungu babe era nga yifuuha temu. ");
INSERT INTO nuj_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ngʼaŋo Falaawo alanga abafumu nʼabalogo era abafumu Abamisiri boosi bahola ehiitu cʼehyene mu magesi gaawe agekweho. ");
INSERT INTO nuj_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Hiisi mulala gadanya ŋaasi aŋo esimbo yiye, nga yifuuha temu. Aye esimbo yʼAlooni yamira ejaawe josijosi. ");
INSERT INTO nuj_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Wayire ehyo hyali hiityo, Falaawo gahahanyasa omwoyo gugwe, sigaŋulirisa bya Musa nʼAlooni, ngʼolu Musengwa galoma. ");
INSERT INTO nuj_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ngʼaŋo Musengwa aloma Musa ati, “Omwoyo gwa Falaawo muhahanyafu era ageene ohuleha abaatu ohutiina. ");
INSERT INTO nuj_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Tiinayo mu mugamba omwagaane nʼatiina hu lwabi, omuhuumirire hwigenya nʼoŋambire esimbo yiyo eyafuuha etemu. ");
INSERT INTO nuj_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Omulome oti, ‘Musengwa Hatonda wʼAbabbebbulaniya gatumire eyi oli ohuhuloma ti, “Leha abaatu bange batiine banjumirye mu lulafu.” Aye nʼohwosa ŋaahani ogeene ohuŋulira. ");
INSERT INTO nuj_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Olwʼehyo, Musengwa aloma ati hino pohu oja humanyira ti ndiise Musengwa. Nja huhubba amaaji gomu lwabi nʼesimbo nga gafuuha mafugi. ");
INSERT INTO nuj_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Enyeeni mu lwabi jija hufa era ŋaja hubaŋo ohuŋunya ehibulu, Abamisiri sibaja hunywa amaaji ago.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ngʼaŋo Musengwa aloma Musa ati, “Loma Alooni oti, ‘Ŋamba esimbo yiyo, ojanuule omuhono gugwo hu maaji agʼe Misiri gosigosi, enjabi josijosi nʼebidiba nʼamaaji gosigosi hiisi ŋaatu, gaja hufuuha mafugi. Amafugi gaja huba hiisi ŋaatu mu gwanga lyʼe Misiri lyosiryosi, mu bibya ebi bahola mu bisaala ko nomwiroba.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Ngʼaŋo Musa nʼAlooni bahola ngʼolu Musengwa gaali nʼabalagiye. Nga Alooni aŋamba esimbo mu moni ja Falaawo nʼabahungu babe ngʼajanuula omuhono gugwe hu maaji agomu lwabi Kiyira, ngʼamaaji gosigosi gafuuha mafugi. ");
INSERT INTO nuj_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ngʼenyeeni ejomu lwabi Kiyira jifa, ngʼolwabi luduuha ehibulu era Abamisiri sibasobola hunywa maaji gaamo. Ngʼamafugi gaba hiisi ŋaatu mu gwanga lyʼe Misiri. ");
INSERT INTO nuj_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Aye abafumu Abamisiri boosi bahola ebiitu njʼebyene mu magesi gaawe agekweho. Era ngʼomwoyo gwa Falaawo guhahanyala, sigaŋulira bya Musa ni Alooni, ngʼolu Musengwa gaali nʼalomire. ");
INSERT INTO nuj_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Ohutusaho gacuuha gaŋamba engira gagamayo mu lubiri lulwe era ebyo sigabifaho naŋadiidiri. ");
INSERT INTO nuj_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","NgʼAbamisiri bosibosi batiina bayaba esobere hu gobo wʼolwabi basune amaaji gʼohunywa olwohuba baali sibaŋanga hunywa maaji agomu lwabi. ");
INSERT INTO nuj_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ŋabitaŋo endaalo musanvu Musengwa nʼahenire ohufuula amaaji gomu lwabi Kiyira, mafugi. ");
INSERT INTO nuj_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Nga Musengwa aloma Musa ati, “Tiina eyiri Falaawo omulome oti Musengwa aloma ati, ‘Leha abaatu bange batiine banjumirye. ");
INSERT INTO nuj_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Aye singa ogaana ohubalehula ohutiina, nja huboneresa abaatu bʼegwanga liryo lyosiryosi ni mbaleetaho agahere. ");
INSERT INTO nuj_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Olwabi Kiyira luja hwijula agahere era gaja hwingira mu lubiri lulwo nomu hisenge hihyo nohu buliri wuwo, nomu manyumba ga bahungu babo nomu jʼabaatu babo nomu bibange nomu ndubi ko nomu tubindi. ");
INSERT INTO nuj_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Agahere gaja hubejulaho, ewe nʼabahungu ko nʼabaatu babo.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ngʼaŋo Musengwa aloma Musa ati, “Loma Alooni oti ‘Ŋamba esimbo yiyo ohubbe hu maaji gomu lwabi nʼemyala ko nʼebidiba era ehyo hija huleeta agahere ohuŋwera eyi gaja huŋwera gamaamire egwanga lyʼe Misiri.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Nga Alooni aŋamba esimbo ajanuula omuhono hu maaji mu gwanga lyʼe Misiri, ngʼagahere gaŋwa eyi gaŋwera gamaamira egwanga lyʼe Misiri lyosiryosi. ");
INSERT INTO nuj_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Aye abafumu boosi bahola baatyo mu magesi gaawe agomu ngiso, amahere gaali mu gwanga lyʼe Misiri. ");
INSERT INTO nuj_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ngʼaŋo Falaawo atuma balanga Musa ni Alooni, ngʼabaloma ati “Mbasunga musabe Musengwa atutuseho amahere, ese nʼabaatu bange era keesi nja huleha abaatu babe batiine baŋonge eyiri Musengwa.” ");
INSERT INTO nuj_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Nga Musa aloma Falaawo ati “Kulehire wamwene ohusalaŋo ehiseera ehyʼohuhusabira ewe nʼabahungu babo nʼabaatu babo, agahere gahulehe nʼabaatu babo ko nomu nyumba jenywe ohutusaho gasigale mu lwabi mwoŋene.” ");
INSERT INTO nuj_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Nga Falaawo aloma ati “Leha lube ludaalo lwejo.” Ngʼaŋo Musa amugobolamo ati “Hija huba ngʼolu olomire, ko wahamanya oti ŋaŋuma ali hya Musengwa Hatonda weefe. ");
INSERT INTO nuj_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Agahere gaja huhuŋwaho, gaŋwe nohu bahungu babo ko nohu baatu babo, gaja husigala mu lwabi Kiyira mwoŋene.” ");
INSERT INTO nuj_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Oluvanyuma lwa Musa nʼAlooni ohuŋwa ewa Falaawo, Musa galomba Musengwa ohutusaŋo agahere aga gaali nʼaleetire hu Falaawo. ");
INSERT INTO nuj_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Nga Musengwa ahola ngʼolu Musa gamusunga. Ngʼaŋo amahere agaali mu nyumba nomu lunya nomu ndimiro, gafa. ");
INSERT INTO nuj_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Abamisiri bahumbaania etuumo nʼetuumo jʼagahere era ehyalo hyaduuha ehibulu. ");
INSERT INTO nuj_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Aye Falaawo ni gabona ni ŋaliŋo ahalembekeresa, gahahanyasa omwoyo gugwe, sigaŋulirisa bya Musa nʼAlooni. Ehyo hyali ngʼolu Musengwa gaali nʼalomire. ");
INSERT INTO nuj_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ngʼaŋo Musengwa aloma Musa ati, “Loma Alooni oti ‘Ŋamba esimbo yiyo ohubbe hwiroba, lifuuhe bugujwi mu gwanga lyʼe Misiri lyosiryosi.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Nga bahola baatyo. Nga Alooni aŋamba esimbo yiye ahubba hwiroba, ngʼefuuhe mu gwanga lyʼe Misiri lyosiryosi lifuuha bugujwi, nga bumaamira abaatu nʼesolo. ");
INSERT INTO nuj_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ngʼabafumu boosi batambisa amagesi gaawe agomu ngiso ohuleeta obugujwi aye byabahaya. Ngʼobugujwi bumaamira hiisi ŋaatu hu baatu nʼesolo. ");
INSERT INTO nuj_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ngʼabafumu baloma Falaawo baati “Hatonda njʼoli huhola bino.” Aye Falaawo gahahanyasa omwoyo gugwe era sigaŋulirisa bya Musa nʼAlooni ngʼolu Musengwa gaali nʼalomire. ");
INSERT INTO nuj_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ngʼaŋo Musengwa aloma Musa ati, “Olwejo yinyoha mu mugamba pwipwipwi, otiine wagaanane ni Falaawo nʼatiina hu lwabi, omulome oti Musengwa aloma ati, ‘Leha abaatu bange batiine banjumirye. ");
INSERT INTO nuj_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Aye nʼotaleehe abaatu bange ohutiina banjumirye, nja huleeta agasoŋera hu ewe nʼabahungu babo ko nʼabaatu babo nomu mayumba genywe. Enyumba jʼAbamisiri ko nʼehyalo hyosihyosi hija hwijula agasoŋera. ");
INSERT INTO nuj_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Aye hu ludaalo olwo olu nja huleeteraho agasoŋera, ehitundu hyʼe Goseni omu baatu bange beehala hija huba hyanjabulo, agasoŋera sigaja hubayo ko mumanye muuti ese Musengwa ndi mu gwanga lyʼe Misiri lino. ");
INSERT INTO nuj_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Nja hutaŋo enjabulo ŋagati wʼabaatu bange nʼAbamisiri. Era ehyamaliholiho hino hija hubaŋo olwejo.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Musengwa gahola atyo, gaŋindiha agasoŋera gamaala mu lubiri lwa Falaawo nomu nyumba jʼabahungu babe. Egwanga lyʼe Misiri lyosiryosi lyejula era hiisi ŋaatu ŋabiiŋa olwʼagasoŋera. ");
INSERT INTO nuj_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Ngʼaŋo Falaawo atumisa bamulangira Musa nʼAlooni ngʼabaloma ati “Mutiine muŋeyo eŋongo eyiri Hatonda wenywe aye mu gwanga muweene muno.” ");
INSERT INTO nuj_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Aye nga Musa amugobolamo ati “Sihiraŋi ohuhola huutyo, olwohuba eŋongo lyefe eji huŋongera Musengwa Hatonda weefe, jija huba jambiho mu moni jʼAbamisiri. Era singa huŋaayo ebiitu ebyʼembiho mu moni jʼAbamisiri, sibaja hutuhubba amabaale? ");
INSERT INTO nuj_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Huli nʼohuŋamba olugendo olwʼendaalo edatu hutiine mu lulafu, huŋonge eyiri Musengwa Hatonda weefe, ngʼolu atulagira.” ");
INSERT INTO nuj_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Nga Falaawo amuloma ati “Nja hubaleha mutiine mu lulafu muŋeyo eŋongo eyiri Musengwa Hatonda wenywe, ni muba ni mutatiine ŋaleeŋi. Musabireho.” ");
INSERT INTO nuj_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Nga Musa aloma ati “Ni naaŋwe mu moni jijo ti bbepa, nalombe Musengwa era olwejo agasoŋera gaja huŋwa hu Falaawo nʼabahungu ko nʼabaatu babe. Aye Falaawo ateholaholania nindi gagaana abaatu ohutiina ohuŋonga eyiri Musengwa.” ");
INSERT INTO nuj_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Nga Musa aŋwa mu moni ja Falaawo ngʼalomba Musengwa. ");
INSERT INTO nuj_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Nga Musengwa ahola ngʼolu Musa gamusunga. Nga gasoŋera galeha Falaawo nʼabahungu ko nʼabaatu babe era ŋaŋuma esoŋera wayire ndala eyasigala. ");
INSERT INTO nuj_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Aye ebyo ni byaŋwa, Falaawo gahahanyasa omwoyo gugwe, sigafugiirira Abayisirayiri ohutiina. ");
INSERT INTO nuj_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ngʼaŋo Musengwa aloma Musa ati, “Tiina eyiri Falaawo omulome oti Musengwa Hatonda wʼAbabbebbulaniya aloma ati, ‘Leha abaatu bange batiine banjumirye. ");
INSERT INTO nuj_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ni weyongera ohubagaana ohutiina, ");
INSERT INTO nuj_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Musengwa aja huleeta haŋupuli omuhambwe hu byayo bibyo: embalaasi ni nasugirya nʼengamiya nʼeŋombe nʼetaama ko nʼembusi. ");
INSERT INTO nuj_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Aye Musengwa aja hutaaŋo enjabulo ŋagati wʼebyayo byʼAbayisirayiri nʼAbamisiri, ŋaja huŋuma hyayo hyʼOmuyisirayiri ehija hufa.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ngʼaŋo Musengwa ataaŋo ehiseera aloma ati, “Ehyo olwejo Musengwa aja huhihola mu gwanga lino.” ");
INSERT INTO nuj_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Era ni wahya, nga Musengwa ahihola: ebyayo byosibyosi ebyʼAbamisiri nga bifa. Aye ŋaŋuma hyayo hu byʼAbayisirayiri wayire hirala ehyafa. ");
INSERT INTO nuj_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Ngʼaŋo Falaawo aŋindiha abaatu ohubona obanga hituufu ŋaŋuma hyayo hu byʼAbayisirayiri ehifuuye. Era nga babona ti ŋaŋuma wayire hirala ehyʼAbayisirayiri ehyafa. Aye Falaawo gahahanyasa omwoyo gugwe, sigaleha abaatu abo hutiina. ");
INSERT INTO nuj_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ngʼaŋo Musengwa aloma Musa nʼAlooni ati “Mutiine muŋambe amadeeja abiri agʼegohe eryomu mayiga, Musa alyoŋe ŋamugulu Falaawo nʼabona. ");
INSERT INTO nuj_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Egohe eryo lija hufuuha efuuhe enukuule era hiisi muutu nʼebyayo bija husuna amawute mu gwanga lyʼe Misiri lyosiryosi.” ");
INSERT INTO nuj_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ngʼaŋo baŋamba egohe eryomu mayiga, nga baja bemeerera mu moni ja Falaawo. Nga Musa aliŋaanya ŋamugulu. Ngʼamawute gahwana hu hiisi muutu nʼebyayo. ");
INSERT INTO nuj_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Abafumu sibasobola hwemeerera mu moni ja Musa olwohuba bo nʼAbamisiri bosibosi baali bahwene mawute mereere. ");
INSERT INTO nuj_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Aye Musengwa gahahanyasa omwoyo gwa Falaawo, nasaŋulirisa bya Musa nʼAlooni ngʼolu Musengwa gaali nʼalomire. ");
INSERT INTO nuj_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Nga Musengwa aloma Musa ati, “Yinyoha mu mugamba pwipwipwi, otiine eyiri Falaawo omulome oti Musengwa Hatonda wʼAbabbebbulaniya aloma ati, ‘Leha abaatu bange batiine banjumirye. ");
INSERT INTO nuj_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Singa sobaleha hutiina, hu mulundi guno nja huhuboneresa bugali, ewe nʼabahungu babo nʼabaatu bʼegwanga liryo, ko otegeere oti mu hyalo hyosihyosi ŋaŋumaŋo ali hyʼese. ");
INSERT INTO nuj_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Mu butuufu oweene, mbanga ni nahuŋindihira haŋupuli owʼamaani, hani ewe nʼegwanga liryo mwasihiiriha hale mwesimwesi. ");
INSERT INTO nuj_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Aye nahuhusa nahuŋa obuhulu olwʼohwenda ohulaga amaani gange, ko abaatu mu hyalo hyosihyosi, baape eŋono. ");
INSERT INTO nuj_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Nʼohwola hatyane ohigeene ohuleha abaatu bange batiine banjumirye. ");
INSERT INTO nuj_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Olwʼehyo, olwejo mu hiseera hyʼehino, nja huŋindiha efula embi eyʼamabaale etabangaŋo mu gwanga lyʼe Misiri buhye libeŋo. ");
INSERT INTO nuj_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Lagira bengise ebyayo nʼebiitu bibyo byosibyosi ebiri ebulafu, efula eyʼamabaale yiija huhubba ehyalo era hiisi ehiramu ehiri ebulafu, haabe muutu oba ehyayo bija hufa.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Abahungu ba Falaawo batya olwʼebibono bya Musengwa, banguŋaho nga batusayo abeedu nʼebyayo byawe. ");
INSERT INTO nuj_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Aye abo abatafayo hu ebi Musengwa galoma, baleha abeedu nʼebyayo byawe ebulafu. ");
INSERT INTO nuj_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ngʼaŋo Musengwa aloma Musa ati, “Golola omuhono eyiri egulu, efula eyʼamabaale yigwe hu hyalo hyosihyosi ehyʼe Misiri, hu baatu nohu solo ko nohu bimera byosibyosi mu ndimiro.” ");
INSERT INTO nuj_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Musa ni gadunda esimbo yiye ŋamugulu, Musengwa gaŋindiha ohubbwabbwanuha nʼamabaale ko nʼohumyasa. Musengwa gaŋindiha amabaale hu hyalo hyʼe Misiri, ");
INSERT INTO nuj_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","efula eyʼamabaale nʼohumyasa byali hiisi ŋaatu. Efula eyo yaali njʼesinga ohuba embi bugali ohuŋwa olu Misiri lyafuuha egwanga. ");
INSERT INTO nuj_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Mu hyalo hyʼe Misiri hyosihyosi amabaale gahubba hiisi hiitu ehyali ebulafu, abaatu nʼesolo. Gahubba ebimera byosibyosi mu ndimiro era gasabagulya nʼebisaala byosibyosi. ");
INSERT INTO nuj_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ehifo ehi mabaale gatahubba hyali hyʼe Goseni hyoŋene, omu Abayisirayiri baali ni bamenya. ");
INSERT INTO nuj_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ngʼaŋo Falaawo atuma balanga Musa ni Alooni, abaloma ati “Hu luno ndi mubbengi, Musengwa mutuufu. Ese nʼabaatu bange ndiife abasobya. ");
INSERT INTO nuj_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Musunge Musengwa, ahomye ohubbwabbwanuha. Ebyo bihena. Nja hubaleha mutiine, sinenda mweyongere ohuba muno.” ");
INSERT INTO nuj_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Nga Musa amugobolamo ati, “Ni naŋwe mu hibuga, nja hugolola emihono jange eyiri Musengwa ni saba. Ohubbwabbwanuha hwʼefula nʼamabaale bija huhoma era oja hutegeera oti Musengwa njʼomwene hyalo hino. ");
INSERT INTO nuj_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Aye manyire ti ewe nʼabahungu babo simutya Musengwa Hatonda.” ");
INSERT INTO nuj_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Ŋaahani ebimera ebi balanga baati fulakisi ni bbaale bisihiirihire nʼefula eyʼamabaale olwohuba bibaaye byenda hulaba. ");
INSERT INTO nuj_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Aye engaano yiraba luvanyuma, niyo siyasihiiriha. ");
INSERT INTO nuj_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Ngʼaŋo Musa aleha Falaawo, aŋwa mu hibuga era ngʼagolola emihono jije eyiri Musengwa, ngʼohubbwabbwanuha nʼamabaale gʼefula, bireheraaŋo. ");
INSERT INTO nuj_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Aye Falaawo ni gabona ati efula nʼamabaale nʼohubbwabbwanuha bihomire, nga nindi abbenga mu moni ja Hatonda. Niye nʼabahungu babe bahahanyasa emyoyo jaawe. ");
INSERT INTO nuj_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Era Falaawo gahahanyasa omwoyo gugwe, sigaleha Abayisirayiri hutiina. Ehyo hyali hiityo ngʼolu Musengwa galomera mu Musa. ");
INSERT INTO nuj_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Olwola nga Musengwa aloma Musa ati, “Tiina eyiri Falaawo, olwohuba kahanyahiise omwoyo gugwe neja bahungu babe, ko nahalaga ebyamaliholiho byange bino mu bo, ");
INSERT INTO nuj_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ko mwahalomeraho abaana nʼabejuhulu benywe ebi nahola Abamisiri era ngʼolu nahola ebyamaliholiho ebi nahola mu bo, ko mwahamanya muuti ndiise Musengwa.” ");
INSERT INTO nuj_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ngʼaŋo Musa nʼAlooni batiina ewa Falaawo bamuloma baati, “Musengwa Hatonda wʼAbabbebbulaniya aloma ati, ‘Olyosa ŋe ohugaana ohweŋomeha mu moni jange? Leha abaatu bange batiine banjumirye. ");
INSERT INTO nuj_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Aye onagaana ohuleha abaatu bange ohutiina, olwejo nja huleeta esige mu gwanga liryo. ");
INSERT INTO nuj_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Jija humaalaala hiisi ŋaatu, ŋaŋume aŋaboneha. Jija hulya hiisi ehi efula eyʼamabaale galeha era jija hulya nʼebisaala ebirihusebuha mu ndimiro jenywe. ");
INSERT INTO nuj_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Esige jija hwijula enyumba jijo neja bahungu babo neja Bamisiri bosibosi. Ehiitu ehitabangaŋo wayire abasenywe oba abasehulu babasehulu babo sibahibonangaho ohuŋwa ahalehale nʼohwola hatyane.’ ” Nga Musa aŋwa aŋa Falaawo gaali, atiina. ");
INSERT INTO nuj_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ngʼabahungu baloma Falaawo baati, “Omusinde ono aja hwosa ŋe ohututaganya? Leha Abayisirayiri batiine bajumirye Musengwa Hatonda waawe. Soobona oti Misiri esihiirihire?” ");
INSERT INTO nuj_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ngʼaŋo batiina bagobosa Musa nʼAlooni mu moni ja Falaawo, babaloma baati, “Kale mutiine muŋeerese Musengwa Hatonda wenywe. Aye njʼabaani abaja hutiina?” ");
INSERT INTO nuj_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Nga Musa amugobolamo ati, “Huja hutiina nʼabaana beefe abaŋere, nʼabaatu beefe abasaahulu, nʼabaana beefe abaseere nʼabahaana. Era huja huŋira etaama nʼeŋombe jeefe, olwohuba hutehwa ohuholera Musengwa embaga.” ");
INSERT INTO nuj_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Nga habaha abaloma ati, “Ndayira mu mazima ga Musengwa ti sinja hubaleha hutiina nʼabahasi benywe nʼabaana benywe. Hiboneha hiiti ehigendererwa ehi muli ni nahyo mu myoyo jenywe, hibi. ");
INSERT INTO nuj_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Olwʼehyo, abasinde mweŋene ndinywe muba mutiine muŋeerese Musengwa, ehyo hinaba njʼehimwenda.” Nga babbinga Musa nʼAlooni ohuŋwa mu moni ja Falaawo. ");
INSERT INTO nuj_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ngʼaŋo Musengwa aloma Musa ati, “Golola omuhono gugwo hu gwanga lyʼe Misiri, esige jiije jimaalaale egwanga lyʼe Misiri, jirye hiisi himera hyosihyosi ehyali ni hiŋonire efula eyʼamabaale.” ");
INSERT INTO nuj_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Nga Musa aŋaniha esimbo yiye hu gwanga lyʼe Misiri, nga hu ludaalo olwo Musengwa aleeta epunga eyaŋwa ebuŋwalyuba, ngʼehubba hu hyalo, mu muusi nʼowiire. Ni wahya mu mugamba, ngʼepunga eyo yireeta esige. ");
INSERT INTO nuj_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ngʼesige jimaalaala hiisi ŋaatu mu gwanga lyʼe Misiri lyosiryosi. Era ŋaali siŋabangaŋo esige jiityo era sijija hubaŋo nindi. ");
INSERT INTO nuj_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Esige jawiiha egwanga lyʼe Misiri lyosiryosi era hiisi ŋaatu ŋamaliŋa olwʼesige. Nga jirya hiisi himera hyosihyosi, nʼebibala ebyohu misaala ebyali ni biŋonire amabaale. Era siŋasigala hihoola wayire hirala ehibisi hu misaala, wayire hu himera ehindi hyosihyosi, mu gwanga lyosiryosi eryʼe Misiri. ");
INSERT INTO nuj_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Nga habaha atumisa Musa nʼAlooni mangumangu, ngʼabaloma ati, “Mbengire mu moni ja Musengwa Hatonda wenywe ko nomu moni jenywe. ");
INSERT INTO nuj_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Olwʼehyo, ŋaahani mbegayirira nindi muusoniŋe ebibi byange efunda ndala yoŋene era musunge Musengwa Hatonda wenywe, gaatuseho olumbe luno.” ");
INSERT INTO nuj_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Nga Musa aŋwa aŋali Falaawo, ngʼalomba Musengwa. ");
INSERT INTO nuj_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Nga Musengwa aleeta epunga eyʼamaani bugali ohuŋwa ebugwalyuba, ngʼeŋira esige ejo mu Nyanja Enando era siŋasigala sige wayire ndala mu gwanga lyosiryosi eryʼe Misiri. ");
INSERT INTO nuj_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Aye Musengwa gahahanyasa omwoyo gwa Falaawo, sigaleha Bayisirayiri ohutiina. ");
INSERT INTO nuj_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ngʼaŋo Musengwa aloma Musa ati, “Golola omuhono gugwo eyiri egulu, ehiirema hiŋambe hiiti ngu, hibe hu hyalo hyʼe Misiri.” ");
INSERT INTO nuj_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Nga Musa agolola omuhono gugwe eyiri egulu, ehiirema ehiŋambire hiitu ngu nga hiwiiha egwanga lyʼe Misiri lyosiryosi, ohuhena endaalo edatu. ");
INSERT INTO nuj_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ŋaŋuma Mumisiri owaali nʼasobola ohubona owahye era ŋaŋuma owaŋwa mu hifo omu gaali, ohuhena endaalo edatu. Aye Abayisirayiri baali nʼenjase ewaawe eyi bamenyanga. ");
INSERT INTO nuj_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Nga habaha alanga Musa amuloma ati, “Mutiine muŋeerese Musengwa. Abaana benywe abaŋere boosi batiine ni nenywe. Eŋombe nʼetaama nʼembusi njʼejiba ni jisigala.” ");
INSERT INTO nuj_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Aye Musa ngʼamugobolamo ati, “Tuŋe ebyayo ebyohuŋayo ngʼeŋongo, nʼebyohwohya byaguhuliha ni biri bihwiye, ohuŋaayo eyiri Musengwa Hatonda weefe. ");
INSERT INTO nuj_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Huli nʼohutiina nʼebyayo byefe byosibyosi, ŋaŋuma hyayo wayire hirala ehi huleha egongo, olwohuba huli nʼohulondamo ejohuŋa Musengwa Hatonda weefe. Era sihumanyire hyayo ehyʼohuŋa Musengwa, ohwola olu hunahahene ohwolayo.” ");
INSERT INTO nuj_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Aye Musengwa gahahanyasa omwoyo gwa Falaawo, sigabaleha hutiina. ");
INSERT INTO nuj_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Nga Falaawo aloma Musa ati, “Pwe nomu moni! Era wemanya ohutagobola ŋano nindi. Oludaalo olu oligobola, oja hufa.” ");
INSERT INTO nuj_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Nga Musa amugobolamo ati, “Olomire bulaŋi, sinja hugobola ŋano nindi.” ");
INSERT INTO nuj_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ngʼaŋo Musengwa aloma Musa ati, “Nja huleeta hu Falaawo nohu baatu bʼe Misiri ehiguudyo ehindi hirala hyoŋene. Oluvanyuma lwʼehyo, aja hubalehula nababbinga hubabbinga mutiine muŋwere erala mu Misiri muno. ");
INSERT INTO nuj_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Lomera abasinde nʼabahasi Abayisirayiri, basunge abaliranwa baawe, babaŋe ebiitu ebyʼefeeza nʼebyezaabbu.” ");
INSERT INTO nuj_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Musengwa gaaŋa Abayisirayiri obuhoda eyiri Abamisiri. Ohusingira erala abahungu ba Falaawo nʼabaatu bosibosi mu gwanga lyʼe Misiri baaŋa Musa eŋono bugali. ");
INSERT INTO nuj_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ngʼaŋo Musa aloma Falaawo ati, “Musengwa aloma ati, ‘Olwaleero mu wiire ŋagati nja hubita mu gwanga lyʼe Misiri, ");
INSERT INTO nuj_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","era hiisi mwana omuseere omudaayi mu gwanga lyʼe Misiri aja hufa, ohuŋwera erala hu aja ohuba omusika wa Falaawo ohwolera erala hu wʼomwidu owa ŋaasi. Nʼenyana jʼebyayo endaayi joosi jija hufa. ");
INSERT INTO nuj_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ŋaja hubaaŋo amaliro agʼamaani agatabangaŋo hiisi ŋaatu mu gwanga lyʼe Misiri era amaliro ago nindi sigalibaŋo. ");
INSERT INTO nuj_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Aye Abayisirayiri nʼebyayo byawe baja huba miyaaya ni ŋaŋumaŋo nʼembwa ohusama olwʼomuutu oba olwʼehisolo. Muja humanyira hwihyo muuti ese Musengwa taaŋo enjabulo ŋagati wʼAbamisiri nʼAbayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Era abahungu babo bano bosibosi baja huuja bahubbe amafuha mu moni jange ni baloma baati, “Tiina nʼabaatu babo bosibosi.” Ebyo ni biŋooye, nja hutiina.’ ” Nga Musa nʼobusungu oweene obungi aŋwa mu moni ja Falaawo, atiina. ");
INSERT INTO nuj_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ngʼaŋo Musengwa aloma Musa ati, “Falaawo saaja hufugiirira hulehula baatu bange ohutiina, ko neyongere ohuhola ebyamaliholiho mu gwanga lyʼe Misiri.” ");
INSERT INTO nuj_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa nʼAlooni bahola ebyamaliholiho bino byosibyosi mu moni ja Falaawo. Aye Musengwa gahahanyasa omwoyo gwa Falaawo, sigaleha Bayisirayiri huŋwa mu gwanga lirye. ");
INSERT INTO nuj_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Nga Musengwa aloma Musa nʼAlooni mu gwanga lyʼe Misiri ati, ");
INSERT INTO nuj_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Omwesi guno gunaabenga njʼomwesi omudaayi mu mwaha eyi muli. ");
INSERT INTO nuj_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Mulomere ehibbubbu hyʼAbayisirayiri hyosihyosi muuti hu ludaalo olwʼehumi olwʼomwesi guno, hiisi musinde aŋambanga etaama eperepere olwʼabomu mago gage, etaama ndala hiisi mago, bayiita. ");
INSERT INTO nuj_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Singa abomu mago gage baba batono ni batahenaŋo etaama eyo, begaate nʼabomu mago ga muliranwa wuwe, ni beema hu bungi wʼabaatu abasobola ohuyirya. ");
INSERT INTO nuj_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ebyayo ebi mutobola ohwita, biri nʼohuba bya mwaha mulala, ni biŋumaho buleme wosiwosi, niiri paya yʼembusi oba emiigu. ");
INSERT INTO nuj_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Muyihuume ohwola hu ludaalo olwʼehumi nʼene olwʼomwesi guno, hiisi muutu ngʼehibbubbu hyʼAbayisirayiri hyosihyosi, ali nʼohuyiita ehyʼegulo. ");
INSERT INTO nuj_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Bali nʼohuŋamba amafugi baŋahe hu myango jombi ejʼenjigi, naŋamugulu wʼenjigi jʼenyumba omu baliira enyama eyo. ");
INSERT INTO nuj_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Owiire oweene owo, balye enyama eyo ni boohyire hwohya ko nʼeryani erulu nʼEmigaati Ejiŋumamo Ehisimbulusa. ");
INSERT INTO nuj_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Simuyiryanga embisi oba epiiye aye mwohyanga hwohya: omutwe nʼamagulu nʼebyomuhida. ");
INSERT INTO nuj_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Era simusigasangaho enyama yosiyosi ohwola mu mugamba. Ni ŋaba ni ŋaliŋo eyisigayeho, muyiguhulisanga hu muliro. ");
INSERT INTO nuj_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Muja huyirya mu ngeri yino: mulyanga ni mufunyihiise engoye mu musibiro, nʼesimbo ni muŋambire mu ngalo, ni mwambaaye nʼengayito ohulaga ti mwetegeheeye olugendo. Muyiryenga mangumangu, eyo Mbaga yʼOhubihisya hwa Musengwa. ");
INSERT INTO nuj_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Owiire oweene owo nja hugenda mu gwanga lyʼe Misiri, nja hwita hiisi hiitu ehidaayi: omuutu nʼebyayo era nja huboneresa abahatonda bosibosi abʼe Misiri. Ese ndiise Musengwa. ");
INSERT INTO nuj_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Amafugi hu myango jʼenjigi jʼamayumba genywe gaja huba ahabonero ahalaga amago genywe. Era ni nja hubona amafugi hu myango jʼenjigi, nja hubabihisya. Ŋaŋuma habi ahaja huboolaho ni pambire Abamisiri hu nyama. ");
INSERT INTO nuj_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Olwo njʼoludaalo olu muli nʼohuhebuliranga, ludaalo lwʼembaga eyiri Musengwa era muyiryanga hu ludaalo olwo ngʼegambi eryʼemirembe nʼemirembe. ");
INSERT INTO nuj_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Mulyanga Emigaati Ejibatatayemo Ehisimbulusa ohuhena endaalo musanvu. Hu ludaalo oludaayi, mutusanga ehisimbulusa mu manyumba genywe, olwohuba mu ndaalo ejo hiisi aja hulya ehiitu hyosihyosi ehirimo ehisimbulusa, baja humuŋira hyʼotali mulala hu Bayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Hu ludaalo oludaayi munahumbaanenga ŋalala ohunjumirya era nga nindi muhumbaana hu ludaalo olwomusanvu. Simuholanga mulimo gwosigwosi mu ndaalo ejo, ohutusaho ohunyiiya emere eya hiisi muutu ohulya. Ehyo hyoŋene njʼehi muli nʼohuhola. ");
INSERT INTO nuj_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Mulye Embaga eyʼEmigaati Ejibatatayemo Ehisimbulusa olwohuba olwo njʼoludaalo olu natuhisamo ebiha byenywe ohuŋwa mu gwanga lyʼe Misiri. Era muyiryanga hu ludaalo olwo ngʼegambi eryʼemirembe nʼemirembe. ");
INSERT INTO nuj_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Mu mwesi ogusooka muli nʼohulya Emigaati Ejibatatayemo Ehisimbulusa. Ehyo muhiholanga egulo hu ludaalo olwʼehumi nʼene olwʼomwesi omudaayi ohwola egulo hu ludaalo olwʼamahumi abiri nalulala. ");
INSERT INTO nuj_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Ohuhena endaalo musanvu, ehisimbulusa sihibanga mu nyumba jenywe. Era hiisi alirya ehiitu hyosihyosi ehirimo ehisimbulusa, aliba sibahimubala mulala hu hibbubbu hyʼAbayisirayiri, haabe mugwira oba musaale. ");
INSERT INTO nuj_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Simulyanga hiitu ehirimo ehisimbulusa. Eyo mu mago genywe, muli nʼohulya Emigaati Ejiŋumamo Ehisimbulusa.” ");
INSERT INTO nuj_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Nga Musa atumisa abatangirisi bosibosi abʼAbayisirayiri, abaloma ati, “Mutiine mutobole enyana yʼetaama oba yʼembusi eperepere, musale eyʼOhubihisya. ");
INSERT INTO nuj_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Muŋambe omuganda gwʼobusaala obu balanga baati hayisopu, muŋambe ebbaafu muyijuhemo amafugi muhene mubutimyemo muŋahe hu myango jombi ko naŋamugulu wʼenjigi jʼenyumba jenywe. Siŋabangaŋo wayire mulala hu nywe atula mu nyumba ohwola mu mugamba. ");
INSERT INTO nuj_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Musengwa nʼagenda mu gwanga lyʼe Misiri ohwita Abamisiri, nʼanabone amafugi ŋamugulu wʼenjigi nohu myango jombi, nʼabita saaja hufugiirira malayika aleeta ohufa ohwingira mu nyumba jenywe ohwita abaana abadaayi, aja hubabihisya. ");
INSERT INTO nuj_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Enywe nʼabaana benywe muli nʼohuhuumanga ehiragiro ehyo emirembe nʼemirembe. ");
INSERT INTO nuj_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ni mutiinanga mu hyalo ehi Musengwa alibaŋa ngʼolu gasuubisa, hiisi mwaha muholanga omukolo ogwo emirembe nʼemirembe. ");
INSERT INTO nuj_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Era abaana benywe ni bababuusanga baati, ‘Omukolo guno gutegeesa hi?’ ");
INSERT INTO nuj_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","mubagobolangamo muuti, ‘Njʼomukolo ogwʼOhubihisya ogwa Musengwa, owabihisya amago gʼAbayisirayiri e Misiri, olu geeta Abamisiri.’ ” Ngʼaŋo Abayisirayiri bahubba amafuha bajumirya Hatonda. ");
INSERT INTO nuj_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","NgʼAbayisirayiri batiina bahola ngʼolu Musengwa galagira Musa nʼAlooni. ");
INSERT INTO nuj_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Nga mu wiire ŋagati, Musengwa geeta abaana abaseere bosibosi abadaayi mu gwanga lyʼe Misiri, ohuŋwa hu musaani omudaayi owa Falaawo owaali ni geehaye hu etebe eyʼowahabaha, ohwolera erala hu mudaayi owʼomusibe mu komera. Era nʼenyana endaayi ejʼebyayo joosi jafa. ");
INSERT INTO nuj_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Falaawo nʼabahungu babe ko nʼAbamisiri bosibosi ni benyoha owiire owo, ŋaaliŋo ohuhubba enduulu mu gwanga lyʼe Misiri, olwohuba ŋaŋuma nyumba omutafamo muutu. ");
INSERT INTO nuj_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Nga mu wiire owo, Falaawo atumisa ohulanga Musa nʼAlooni abaloma ati, “Muŋwe mu gwanga lyange, enywe nʼAbayisirayiri. Mutiine muŋeerese Musengwa ngʼolu mwasunga. ");
INSERT INTO nuj_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Muŋire etaama nʼembusi nʼeŋombe jenywe ngʼolu mwasunga. Era keesi musabire ekabi.” ");
INSERT INTO nuj_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","NgʼAbamisiri bahubbirisa abaatu banguŋe ohuŋwa e Misiri, olwohuba baali baloma baati, “Huja hufa huŋweŋo hwesihwesi!” ");
INSERT INTO nuj_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ngʼabaatu bejusa endubi jaawe obusyanu wʼengaano obubafutire aye ni batatayemo ehisimbulusa, nga basidiha mu ngoye jaawe, bagegera hu mabega. ");
INSERT INTO nuj_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Abayisirayiri bahola ngʼolu Musa gabalabbira nga batiina basunga Abamisiri ohubaŋaaho efeeza nʼezaabbu ko nʼengoye. ");
INSERT INTO nuj_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Musengwa gaŋa Abayisirayiri obuhoda ohuŋwa mu Bamisiri era babaŋa ebi basunga. Nga baŋira ebyʼobuŋinda wʼAbamisiri. ");
INSERT INTO nuj_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","NgʼAbayisirayiri bageehesya magulu ohuŋwa e Lameseesi ohwola e Sukosi. Baali abasinde ngʼemitwalo kaaga, ni batabaliyeho abahasi nʼabaana. ");
INSERT INTO nuj_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Abaatu bangi bugali abatiina nʼAbayisirayiri nʼebidooli byʼetaama nʼembusi nʼeŋombe. ");
INSERT INTO nuj_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Nga baŋamba obusyanu obu batusa e Misiri, banyiiya emigaati Ejiŋumamo Ehisimbulusa, olwohuba banguŋa mangu ohuŋwa e Misiri ni bahiiri hubutaamo ehisimbulusa era ni bahiiri hunyiiya mere. ");
INSERT INTO nuj_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Abayisirayiri bahena e Misiri emyaha ebihumi bine nʼadatu. ");
INSERT INTO nuj_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Hu komerero yʼemyaha ejo ebihumi bine nʼadatu hu ludaalo olusembayo, ebiha byosibyosi ebyʼabaatu ba Musengwa, byaŋwa e Misiri. ");
INSERT INTO nuj_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Owiire owo Musengwa gahuuma ehisuubiso hihye gabatusa e Misiri. Olwʼehyo, owiire owo Abayisirayiri bosibosi bali nʼohuhebulirirangaho Ohubihisya hiisi myaha, emirembe nʼemirembe. ");
INSERT INTO nuj_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Nga Musengwa aloma Musa nʼAlooni ati, “Gano njʼamagambi agaŋamba hu Mbaga eyʼOhubihisya: Eŋuma omulugendwa alyanga hu mbaga eyo. ");
INSERT INTO nuj_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Omwidu oyu mwagula, oluvanyuma lwʼohumuhomola, alyanga Embaga eyo. ");
INSERT INTO nuj_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Aye omugeni nʼomutambi aholerera omuhemba, sibayiryangaho. ");
INSERT INTO nuj_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Muli nʼohuyiriira mu nyumba, ŋaŋumangaŋo enyama eyitula ebulafu wʼenyumba. Era simubbwaganga gumba lyosiryosi. ");
INSERT INTO nuj_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Ehibbubbu hyʼAbayisirayiri hyosihyosi hiri nʼohuhusanga Embaga eyo. ");
INSERT INTO nuj_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Aye omulugendwa owesengire mu enywe, owenda ohuhusa Embaga eyʼOhubihisya, ohuŋa Musengwa eŋono, ali nʼohuhomola abasinde bosibosi abomu mago gage, oluvanyuma banamuŋirenga ngʼOmuyisirayiri omusaale. Ŋaŋuma atali muhomole, alyanga hu mbaga eyo. ");
INSERT INTO nuj_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Amagambi ago gaŋamba hu Bayisirayiri ko nʼabalugendwa abesengire mu enywe.” ");
INSERT INTO nuj_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Abayisirayiri bosibosi baahola ngʼolu Musengwa galagira Musa ni Alooni. ");
INSERT INTO nuj_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Era hu ludaalo olwo Musengwa gatusa ebiha byʼAbayisirayiri mu gwanga lyʼe Misiri. ");
INSERT INTO nuj_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Nga Musengwa aloma Musa ati, ");
INSERT INTO nuj_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Njabulire abaana abaseere bosibosi abadaayi. Mu Bayisirayiri, hiisi mwana omuseere omudaayi nʼebyayo ebidaayi ebisinde byosibyosi byange.” ");
INSERT INTO nuj_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Nga Musa aloma abaatu ati, “Muhebuliranga oludaalo luno olu mwaŋweramo e Misiri, ehyalo ehyʼowiidu olwohuba Musengwa gabatusayo nʼobuŋangi buwe owʼamaani. Hu ludaalo luno simulyanga migaati eji basimbuluhise. ");
INSERT INTO nuj_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Olwaleero, mu mwesi ogwa Abbibbu, muli hutiina. ");
INSERT INTO nuj_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Muhusanga Embaga eyʼOhubihisya mu mwesi guno, Musengwa nʼabaŋira mu hyalo hyʼAbakanani nʼAbahiiti nʼAbamooli nʼAbahiivi nʼAbayebbusi, ehyalo ehi galayirira abasehulu benywe ohubaŋa, ehyalo ehituluha amabeere nʼomudugere. ");
INSERT INTO nuj_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Mulyenga Emigaati Ejiŋumamo Ehisimbulusa ohuhena endaalo musanvu era hu ludaalo olwomusanvu mulyanga Embaga eyʼOhubihisya ohuŋa Musengwa eŋono. ");
INSERT INTO nuj_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Mulyenga Emigaati Ejibatatayemo Ehisimbulusa mu ndaalo ejo omusanvu. Siŋabangaŋo emigaati eji basimbuluhise era siŋabangaŋo ehisimbulusa mu gwanga lyenywe. ");
INSERT INTO nuj_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Hu ludaalo olwo, olomeranga abasaani babo oti ‘Kola hino olwʼehi Musengwa gakolera olu naŋwa e Misiri.’ ");
INSERT INTO nuj_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Embaga eyo yinaabenga hyahabonero hu muhono oba mu weeni wuwo, ohuhuhebulisanga amagambi ga Musengwa ohubanga mu hanwa henywe, olwohuba gaahutusa e Misiri nʼobuŋangi buwe owʼamaani. ");
INSERT INTO nuj_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Oli nʼohuhuumanga ehiragiro hino mwaha hu mwaha. ");
INSERT INTO nuj_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Oluvanyuma lwa Musengwa ohubaŋira mu hyalo hyʼAbakanani ngʼolu gabasuubisa nʼohulayira pohu ataaye, enywe nʼabasehulu benywe, ");
INSERT INTO nuj_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","muli nʼohuŋayo abaana abadaayi bosibosi abaseere eyiri Musengwa. Ebyayo ebisinde byosibyosi ebidaayi bya Musengwa. ");
INSERT INTO nuj_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Mununulenga nasugirya ni muswanisamo nʼetaama eperepere. Aye nʼotenda huyinunula, muyibbwanganga egosi. Mununulenga hiisi baana benywe abaseere abadaayi. ");
INSERT INTO nuj_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Era mu biseera ebiija, omusaani wuwo nʼahubuusanga ati, ‘Hino hitegeesa hi?’ Omugobolangamo oti, ‘Musengwa gaatutusa e Misiri nʼobuŋangi buwe owʼamaani, ehyalo ehyʼowiidu. ");
INSERT INTO nuj_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Falaawo ni gaali nʼageene ohutufugiirira ohutiina, Musengwa geeta hiisi baana abaseere abadaayi abʼAbamisiri, abaatu ko nʼebyayo. Ehyo cʼehigira huŋonga eyiri Musengwa hiisi hyayo ehidaayi aye hununula abaana bosibosi abaseere abadaayi.’ ");
INSERT INTO nuj_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Era haja huba habonero hu mihono oba mu weeni byenywe, ohubahebulisanga ti Musengwa gaatutusa e Misiri, nʼobuŋangi buwe owʼamaani.” ");
INSERT INTO nuj_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Falaawo ni galeha Abayisirayiri ohutiina, Hatonda sigababisya mu ngira eyibita hu mwalo mu gwanga lyʼAbafirisuuti, wayire nga nje yaali eyʼohuupi. Olwohuba Hatonda galoma ati, “Ni baja hwolehera olutalo, baja hucuusa ebiŋeego byawe bagobolayo e Misiri.” ");
INSERT INTO nuj_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Olwʼehyo Hatonda gatangirira abaatu babe beholoobya mu lulafu hutulo wʼEnyanja Enando. Abayisirayiri baŋwa e Misiri ni bali nʼebyohusoosa. ");
INSERT INTO nuj_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Nga Musa aŋira amagumba ga Yosefu ngʼolu Yosefu galayisa Abayisirayiri ati, “Mu butuufu Hatonda alibanunula era mugeganga amagumba gange ni muŋwa mu gwanga lino.” ");
INSERT INTO nuj_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Abayisirayiri ni baŋwa e Sukosi batiina baata ekambi mu hifo ehi balanga baati Etamu hu salo nʼolulafu. ");
INSERT INTO nuj_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Mu muusi, Musengwa gabatangirirangamo mu hireri ehyali oti siiro ohubalaga engira, ngʼowiire abatangiriramo mu muliro ogwali oti siiro ohubaŋa enjase, ko basobole ohugenda omuusi nʼowiire. ");
INSERT INTO nuj_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Wayire omuusi oba owiire ehireri ehyali hyʼesiiro oba omuliro ogwali hyʼesiiro, sibyaŋwanga mu moni jʼAbayisirayiri ohubatangirirangamo. ");
INSERT INTO nuj_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Nga Musengwa aloma Musa ati, ");
INSERT INTO nuj_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Loma Abayisirayiri bagobole egongo, babe ŋaapi nʼehifo ehi balanga baati Payi Hahiroosi, ŋagati wa Migidooli nʼenyanja Enando. Bali nʼohuhola ekambi mu moni wa Bbaali Zefoni. ");
INSERT INTO nuj_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Falaawo aja huŋeega ati Abayisirayiri bagendana ni baŋuma eyi baja mu lulafu. ");
INSERT INTO nuj_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Nja huhahanyasa omwoyo gwa Falaawo, aja hubalondaho. Aye nja hwesunira eŋono ni mbitira mu ye nʼabasirikale babe. Abamisiri bajahumanya baati ndiise Musengwa.” Era Abayisirayiri baahola ngʼolu babaloma. ");
INSERT INTO nuj_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ni balomera habaha wʼe Misiri baati Abayisirayiri badulumire, niye nʼabahungu babe bacuusa ebiŋeego baloma baati, “Hiina hino ehi huholire? Huleehire Abayisirayiri ohutiina, hufiiriye obuŋeeresa waawe.” ");
INSERT INTO nuj_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Olwʼehyo, bategeha egaali yiye nga niye nʼeŋe lirye batiina ni naye. ");
INSERT INTO nuj_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Falaawo gaŋamba ebigaali lukaaga agahira obulaŋi ko nʼagandi gosigosi mu gwanga lyʼe Misiri, nʼabagaduumira. ");
INSERT INTO nuj_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Musengwa gahahanyasa omwoyo gwa habaha wʼe Misiri, ngʼalonda hu Bayisirayiri abaali ni batiina nʼobugumu. ");
INSERT INTO nuj_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Abamisiri ko nʼembalaasi nʼebigaali ga habaha gosigosi nʼabasirikale abandi, balonda hu Bayisirayiri era nga baboolaho ni bali ohuupi nʼenyanja, hutulo wa Payi Hahiroosi mu moni wa Bbaali Zefoni. ");
INSERT INTO nuj_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Falaawo ni gaali naali huupi hubolaho, Abayisirayiri benyosa emoni, balengera Abamisiri ni babolireho. Ehyo hyabatiisa nga baliririra Musengwa abayeede. ");
INSERT INTO nuj_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Nga baloma Musa baati, “Yaŋumayo bigombe e Misiri, cʼehigira watuleeta hufiire mu lulafu muno? Wagenderera hi ohututusa e Misiri? ");
INSERT INTO nuj_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Sihwahulomera ni huli e Misiri huuti ‘Tulehe, otatudambya, leha huŋeerese Abamisiri?’ Hyahali hiraŋi efe ohuŋeeresa Abamisiri, ohuhira ohufiira mu lulafu muno!” ");
INSERT INTO nuj_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Nga Musa aloma Abayisirayiri ati, “Mutatya! Mugume, muja hubona obununuzi obu Musengwa aja hubaholera olwa leero. Abamisiri abamubona olwa leero luno, simuligobolayo hubabona nindi. ");
INSERT INTO nuj_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Musengwa aja hubasoolerera. Mwihahane hyoŋene.” ");
INSERT INTO nuj_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Nga Musengwa aloma Musa ati, “Lwahiina bundiririra? Loma Abayisirayiri batiine mu moni. ");
INSERT INTO nuj_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ŋamba esimbo yiyo, ojanuule omuhono gugwo hu nyanja yegabulemo ŋabiri, Abayisirayiri bayibitemo ni yoomire. ");
INSERT INTO nuj_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Nja huhahanyasa emyoyo jʼAbamisiri babalondeho, nahefunira eŋono ni panguye Falaawo nʼeŋe lirye lyosiryosi nʼebigaali ko nʼabaduumira embalaasi. ");
INSERT INTO nuj_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Abamisiri baja humanya ngʼolu ndi Musengwa, ni panguye Falaawo nʼamaŋe nʼebigaali ko nʼembalaasi.” ");
INSERT INTO nuj_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ngʼaŋo malayika wa Hatonda owatangirirangamo Abayisirayiri, abaŋwa mu moni agobola egongo. Ngʼehireri oti siiro hyosi hibaŋwa mu moni hitiina hyemeerera egongo waawe ");
INSERT INTO nuj_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ŋagati wʼAbamisiri nʼAbayisirayiri. Owiire wosiwosi, ehireri hyaleeta ehiirema hu luuyi lulala nʼobutangaafu hu luuyi olundi era eŋuma Mumisiri owegerera eyiri Omuyisirayiri. ");
INSERT INTO nuj_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Nga Musa ajanuula omuhono hu nyanja era owiire owo wosiwosi Musengwa gaŋindiha omuyaga ogwʼamaani hu nyanja ohuŋwa ebuŋwalyuba nga guhubba ni gutiina hu woomu. Ngʼamaaji geyawulamo ŋabiri. ");
INSERT INTO nuj_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","NgʼAbayisirayiri babita mu nyanja hu woomu, amaaji gahola ehiteepe hu muhono omulungi nohu mugooda. ");
INSERT INTO nuj_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","NgʼAbamisiri babalondaho mu nyanja, ni bali nʼembalaasi josijosi eja Falaawo, nʼebigaali gage nʼeŋe eryohu mbalaasi. ");
INSERT INTO nuj_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Aye owiire ni waali huupi ohuhya, Musengwa nʼali mu hireri nʼomuliro ogwali oti siiro, gaheja ŋaasi gabona eŋe lyʼAbamisiri, ngʼabaleetera ohutabuhatabuha. ");
INSERT INTO nuj_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Gabotolabotola amagata gʼamagaali gaawe, ehyo hyagaleetera ohuhalubirirwa ohugenda. Ngʼaŋo Abamisiri baloma baati, “Hulehe Abayisirayiri betiinire olwohuba Musengwa alihutusoosa efe Abamisiri!” ");
INSERT INTO nuj_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ngʼaŋo Musengwa aloma Musa ati, “Januula omuhono gugwo hu nyanja, amaaji gagoboleyo gamire Abamisiri nʼamagaali gaawe ko nʼabembalaasi.” ");
INSERT INTO nuj_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Nga Musa ajanuula omuhono gugwe hu nyanja, nga mu mugamba amaaji mu nyanja gagobolayo mu hifo hyago. Abamisiri ni babona amaaji ni gagobolayo, bagesyaho ohuduluma aye Musengwa gababulungulira mu maaji. ");
INSERT INTO nuj_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Ngʼamaaji gaagamayo gawiiha amagaali nʼabohu mbalaasi nʼeŋe lya Falaawo lyosiryosi eryalonda hu Bayisirayiri mu nyanja. Eŋuma wayire mulala hu bo owaŋona. ");
INSERT INTO nuj_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Aye Abayisirayiri bagendera hu woomu mu nyanja nʼamaaji agaali oti hiteepe hu luuyi lwʼomuhono omulungi nohu mugooda. ");
INSERT INTO nuj_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Hu ludaalo olwo, Musengwa ganoŋola Abayisirayiri mu buŋugi wʼAbamisiri. Era Abayisirayiri babona Abamisiri ni balambagaye hwigobo lyʼenyanja. ");
INSERT INTO nuj_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Abayisirayiri ni babona obuŋangi owʼamaani, Musengwa nʼaŋanguye Abamisiri, baatya Musengwa, bamutamo owesige era bafugiirira ni Musa omuŋeeresa wuwe. ");
INSERT INTO nuj_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ngʼaŋo Musa nʼAbayisirayiri bembera Musengwa olwembo baati, “Nja hwembera Musengwa, olwohuba aŋanguye abalabe babe nʼobuŋangi. Adanyire embalaasi nʼabayihalaho mu nyanja. ");
INSERT INTO nuj_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Musengwa njʼamaani era njʼolwembo lwange. Njʼobunoŋosi wange. Niye nje Hatonda wange era nja humujumiryanga, Hatonda wa Bbaabba era nja humugulumisanga. ");
INSERT INTO nuj_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Musengwa ali hyʼomusooli era esiina lirye nje Musengwa. ");
INSERT INTO nuj_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Amagaali ga Falaawo nʼeŋe lirye babiholoŋire mu Nyanja Enando. Abahungu ba Falaawo abahira ohuba abaŋamugulu banywoye etubbi mu Nyanja Enando. ");
INSERT INTO nuj_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Amaaji amaleeŋi gabamirire era beyinihire mu njuho hyʼebaale. ");
INSERT INTO nuj_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“O Musengwa, omuhono gugwo omulungi, gwʼamaani era gwʼeŋono. O Musengwa, omuhono gugwo omulungi guhubbire omusigu. ");
INSERT INTO nuj_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Mu buŋangi wuwo ohubbiyeŋo abo abahuŋahania. Ehiruŋi hihyo hibalire hyʼomuliro era baguhulihire oti binyaasi. ");
INSERT INTO nuj_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ofuuŋire omuuya ohuŋwa mu suulu yiyo ngʼamaaji geŋamba etuumo. Era gahena gemeerera hyʼehiteepe. Amaaji getengereye mu wuliba. ");
INSERT INTO nuj_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“Omulabe gepaahire ati, ‘Nja hubabbinga kene mbagaane era mbaheneŋo. Nja huŋira ebyʼobuŋinda byawe byosibyosi ebinenda. Nja hugolola epiima yange, omuhono gwange guja hubasihiirisa.’ ");
INSERT INTO nuj_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Aye wafuuŋa omuuya ngʼenyanja ebamira. Beeyiniha mu maaji hyʼehyoma ehisito. ");
INSERT INTO nuj_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“Hu bahatonda baawe, njʼani ali hyʼewe, O Musengwa? Njʼani owʼeŋono hyʼewe, omwawufu, atiisa era owʼetendo ahola ebyeŋunjisa? ");
INSERT INTO nuj_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Wagolola omuhono gugwo omulungi, ngʼeroba libamira. ");
INSERT INTO nuj_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Mu hwenda huhwo ohubitiirifu oja hutangirira abaatu babo abawanunula. Mu buŋangi wuwo oja hubatangirira oboose mu hifo hihyo ehyawufu. ");
INSERT INTO nuj_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Amawanga gaja huŋulira, gateeteme. Obuti buja huŋamba abaatu bʼe Firisuuti. ");
INSERT INTO nuj_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Abahungu bʼEdomu baja hweŋendeherera, olusisimo luja huŋamba abatangirisi bʼe Mowaabbu. Abeehasi bomu Kanani baja huŋwamo amaani. ");
INSERT INTO nuj_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ohutya ohwʼamaani nʼetiisa bija hubagwaho. Olwʼobuŋangi wʼomuhono gugwo baja huba hyʼebaale eritatengeta mu hifo, ohwola olu abaatu babo babitaŋo, O Musengwa, ohwola olu abaatu babo abawanunula babitaŋo. ");
INSERT INTO nuj_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Olibaŋira era wabahoma hu lusozi lwʼobusika buwo, ehifo ehi ewe watobola ohubangamo O Musengwa, Yekaalu eyi wetongolera O Musengwa. ");
INSERT INTO nuj_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Musengwa aliŋuga emirembe nʼemirembe.” ");
INSERT INTO nuj_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Abayisirayiri baabita mu nyanja oti bagendera hu woomu. Aye amagaali nʼembalaasi nʼeŋe eryohu mbalaasi erya Falaawo ni bengira mu nyanja, nga Musengwa agobosaŋo amaaji, gabamira. ");
INSERT INTO nuj_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ngʼaŋo Miryamu naabbi, mboojo yʼAlooni, aŋamba etambulini, ngʼabahasi bosibosi baŋwerehereramo bamulondaho ni bacakasa etambulini jaawe ni bahina. ");
INSERT INTO nuj_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Nga Miryamu gemba olwembo ati, “Mwembere Musengwa, olwohuba aŋanguye. Adanyire embalaasi nʼabayihayeho, mu nyanja.” ");
INSERT INTO nuj_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ngʼaŋo Musa atangirira Abayisirayiri ohuŋwa hu Nyanja Enando, nga batiina boola hu lulafu e Suuri. Nga bagenda mu lulafu endaalo edatu ni batabona maaji. ");
INSERT INTO nuj_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ni boola e Maara, sibasobola hunywa maaji gaayo olwohuba gaali malulu. (Cʼehifa ehifo ehyo bahiranga baati Maara.) ");
INSERT INTO nuj_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ngʼabaatu bemulugunya eyiri Musa ni baloma baati, “Hunanywe hi?” ");
INSERT INTO nuj_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Nga Musa gegayirira Musengwa, nga Musengwa amulaga ehisaala. Nga Musa ahiŋamba ahidanya mu maaji. Ngʼamaaji ago gafuuha malaŋi. Eyo Musengwa peyi gabaŋeera amagambi nʼebiragiro bibye era eyo peyi gabagezesya. ");
INSERT INTO nuj_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ngʼabaloma ati, “Ni muja hugondera Musengwa Hatonda wenywe nʼohwegenderesa era mwahola ebiraŋi mu moni jije, ni muja hutayo omwoyo hu magambi gange era mwaŋamba ebiragiro bibye byosibyosi, sindibaleetaho bulwaye obu naleeta hu Bamisiri, olwohuba ndiise Musengwa abaŋonia.” ");
INSERT INTO nuj_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ngʼaŋo batiina boola mu Elimu, eyo yaaliyo esulo ehumi nʼebiri ejʼamaani nʼebihindu esanvu, nga bahomeha eweema jaawe aŋo ŋaapi nʼamaaji. ");
INSERT INTO nuj_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ngʼehibbubbu hyʼAbayisirayiri hyosihyosi hiŋwa Elimu hitiina mu lulafu lwʼe Siini ŋagati wʼElimu ni Sinaayi ngʼehumi nʼetaanu mu mwesi ogwohubiri oluvanyuma lwʼohuŋwa e Misiri. ");
INSERT INTO nuj_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Eyo mu lulafu, ehibbubbu hyʼAbayisirayiri hyosihyosi hyemulugunya hu Musa nʼAlooni, ");
INSERT INTO nuj_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","hiiti, “Singa Musengwa gatwitira e Misiri. Eyo hweyihaliranga hu tamu jʼenyama nʼemere era hwalya hweguta. Aye mwatuleeta mu lulafu ŋano ohwitisa hibbubbu hino hyosihyosi enjala.” ");
INSERT INTO nuj_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ngʼaŋo Musengwa aloma Musa ati, “Nja hubamagalihisa ebyohulya ohuŋwa mwigulu. Abaatu banatulenga hiisi ludaalo ohuhumbaania ebyohulya ebyo ebihena oludaalo olwo. Mu ngeri eyo nja hubagezesya mbone oba banahuumenga ebiragiro byange. ");
INSERT INTO nuj_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Hu ludaalo olwomukaaga banahumbaanienga ebyʼemirundi ebiri ohuhiraho ebi bahumbaanianga hiisi ludaalo.” ");
INSERT INTO nuj_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ngʼaŋo Musa nʼAlooni baloma Abayisirayiri bosibosi baati, “Olwaleero ehyʼegulo muja humanya muuti Musengwa njʼowabatusa mu gwanga lyʼe Misiri. ");
INSERT INTO nuj_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Era mu mugamba mubone eŋono lya Musengwa olwohuba aŋuliiye ohwemulugunya hwenywe. Ndiife abʼani aba mwemulugunyaho?” ");
INSERT INTO nuj_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Nga Musa geyongera abaloma ati, “Muja humanya muuti nje Musengwa nabaŋa enyama ohulya ehyegulo ko nʼemere hiisi mu mugamba. Muli hwemulugunya hu Musengwa sosi hu efe era aŋuliiye ohwemulugunya hwenywe.” ");
INSERT INTO nuj_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Nga Musa aloma Alooni ati, “Loma ehibbubbu hyʼAbayisirayiri hyosihyosi oti, ‘Muuje mu moni ja Musengwa olwohuba aŋuliiye ohwemulugunya hwenywe.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Alooni ni gaali nʼaloma nʼehibbubbu hyʼAbayisirayiri hyosihyosi, ni baheja mu lulafu ngʼaŋo ni naaŋo babona Musengwa mwiŋono lirye nʼali mu hireri. ");
INSERT INTO nuj_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Nga Musengwa aloma Musa ati, ");
INSERT INTO nuj_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Puliiye ohwemulugunya hwʼAbayisirayiri. Balome oti, ‘Ehyegulo muja hulya enyama era mu mugamba muja huba nʼehibbiryo hyʼemere. Olwo ko mumanye muuti ndiise Musengwa Hatonda wenywe.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ngʼehyegulo ehyo, enyuni eji balanga baati esindu jimaalaala ekambi yʼAbayisirayiri era mu mugamba olume lwadoosa ekambi yosiyosi. ");
INSERT INTO nuj_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Olume ni lwaŋwangaho, nga ŋabaaŋo obuutu owabonehanga hwiroba mu lulafu. Obuutu owo, waali bugondi era ni bunialuluha. ");
INSERT INTO nuj_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Abayisirayiri ni babubona, nga bebuusa abeene nʼabeene baati, “Obuutu buno, wiina?” Hino bahiroma olwohuba baali sibabubonangaho. Nga Musa abaloma ati, “Eyo njʼemere eyi Musengwa abaŋaaye ohulya. ");
INSERT INTO nuj_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Era Musengwa alagira ati, ‘Hiisi muutu ahumbaanie eyimuhena era aŋirire hiisi muutu owomu mago gage ekilo ebiri.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","NgʼAbayisirayiri bahola ngʼolu babaloma. Abandi bahumbaania nyingi, abandi tono. ");
INSERT INTO nuj_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ni bapimanga, oyo owahumbaanianga ebingi, sigaali nʼebingi era ni nooyo owahumbaanianga ebitotono, sigaali nʼebitotono, gafunanga eyimuhena. Hiisi muutu galinga neyimuhena. ");
INSERT INTO nuj_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Nga Musa abaloma ati, “Ŋaŋumeŋo abiiha hu mere eyo ohuhyesa owiire.” ");
INSERT INTO nuj_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Aye abandi hu bo sibaŋulira bya Musa, babiihaho ohwola mu mugamba. Aye wahya ni yijuuye enyende era neŋunya. Ehyo hyaluŋia Musa. ");
INSERT INTO nuj_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Mu mugamba, hiisi muutu gahumbaanianga obusito obu gendanga. Ne omumwi ni gwaduhanga, ngʼesanuuha. ");
INSERT INTO nuj_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Hu ludaalo olwomukaaga, bahumbaanianga emaanu eyʼendaalo ebiri, ekilo ene eja hiisi omuutu. Ngʼaŋo abatangirisi bʼehibbubbu hyʼAbayisirayiri batiina eyiri Musa nga bamulomera. ");
INSERT INTO nuj_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Nga Musa abaloma ati, “Musengwa galagira ati, ‘Oludaalo lwʼejo Sabbaato, lwa huŋuumula, ludaalo lwawufu eyiri Musengwa. Munyiiye ebi mwenda ohunyiiya, mubaseho ebi mwenda ohubasaho. Esigalaho muyibiihe ebe yʼolwejo mu mugamba.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Nga bayibiiha ohwola mu mugamba ngʼolu Musa galagira era siyaŋunya wayire ohugwamo enyende. ");
INSERT INTO nuj_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Ni wahya nga Musa abaloma ati, “Muyirye olwohuba olwa leero Sabbaato ya Musengwa. Simuja husaŋaanaŋo ebiryo ebyo ebulafu wʼekambi olwa leero. ");
INSERT INTO nuj_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Muhumbaanienga ebiryo ebyo mu ndaalo omukaaga aye hu ludaalo olwomusanvu, olwa Sabbaato ebiryo ebyo sibinabengayo.” ");
INSERT INTO nuj_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Hu ludaalo olwomusanvu, abandi batiina ohuhumbaania aye siyaaliyo. ");
INSERT INTO nuj_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ngʼaŋo Musengwa aloma Musa ati, “Mulyosa ŋe ohutaŋamba amagambi nʼebiragiro byange? ");
INSERT INTO nuj_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Muhebulire muuti ese Musengwa nabaŋa Sabbaato, cʼehigira hu ludaalo olwomukaaga mbaŋa ebiryo ebibahenesaho endaalo ebiri. Hiisi muutu ali nʼohuba ŋa wuwe hu ludaalo olwomusanvu, ŋaŋume aŋwa mu mago gage.” ");
INSERT INTO nuj_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Olwʼehyo, Abayisirayiri baŋuumulanga hu ludaalo olwomusanvu. ");
INSERT INTO nuj_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","NgʼAbayisirayiri balanga emere eyo baati maanu. Yaali yifaana hyahamo ahadiidiri ahahosa era ni yiŋooma hyʼobugaati obu batabuyemo omudugere. ");
INSERT INTO nuj_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Nga Musa abaloma ati, “Musengwa alagiiye ati, ‘Mubiiheho hu maanu era bayibiihe emirembe nʼemirembe olwʼabejuhulu benywe, bahabonaho emere eyi nabaŋa mu lulafu olu nabatusa e Misiri.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Nga Musa aloma Alooni ati, “Ŋamba ehibya otemo ekilo ebiri ejʼemaanu. Ohene ohite mu moni ja Musengwa bayibiihe olwʼabejuhulu benywe.” ");
INSERT INTO nuj_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Nga Alooni aŋamba emaanu ayibiiha mu Sanduuku yʼEndagaano ngʼolu Musengwa galagira Musa. ");
INSERT INTO nuj_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Abayisirayiri balya emaanu emyaha amahumi ane ohwola olu boola hu salo nʼegwanga lyʼe Kanani. ");
INSERT INTO nuj_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Ehipimo ehi batambisanga hyali hyagaagana nʼekilo ebiri.) ");
INSERT INTO nuj_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Ngʼehibbubbu hyʼAbayisirayiri hyosihyosi hiŋwa mu lulafu lwʼe Siini, ni hitiina ŋano ni naŋala ni hyeyongerayo ngʼolu Musengwa galagiranga. Nga batiina mu hifo ehi balanga baati Refidimu aye yaŋuma maaji agʼohunywa. ");
INSERT INTO nuj_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Nga baduhania Musa bamuloma baati, “Ale tuŋe amaaji hunywe!” Nga Musa ababuusa ati, “Lwahiina munduhania? Era lwahiina muhema Musengwa?” ");
INSERT INTO nuj_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Aye enduŋo yaluma abaatu nga bemulugunya hu Musa baati, “Lwahiina watutusa e Misiri ohutwitisa nʼabaana nʼebisolo byefe enduŋo?” ");
INSERT INTO nuj_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ngʼaŋo Musa gegayirira Musengwa ati, “Musengwa, kolire tye abaatu bano? Baali huupi hukubba amabaale!” ");
INSERT INTO nuj_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Nga Musengwa aloma Musa ati, “Ŋamba esimbo eyi wahubbisa olwabi Kiyira otiine nʼabalala hu batangirisi bʼAbayisirayiri, otangirire mu baatu. ");
INSERT INTO nuj_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Nja hwemeerera mu moni wuwo hwibaale eryo hu lusozi olu balanga baati Horebbu. Hubba ebaale eryo nʼesimbo yiyo, muja huŋwamo amaaji abaatu banywe.” Nga Musa ahola atyo mu moni jʼabatangirisi bʼAbayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Musa galanga esiina lyʼehifo ehyo ati Maasa ni Meribba, olwohuba Abayisirayiri baduhana era bahema Musengwa ni bebuusa baati, “Hituufu Musengwa ali ŋalala ni neefe?” ");
INSERT INTO nuj_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Ngʼaŋo Abameleki batiina balumba Abayisirayiri e Refidimu. ");
INSERT INTO nuj_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Nga Musa aloma Yoswa ati, “Tobolamo abasinde batiine basoole nʼAbameleki. Olwejo nja hutiina nemeerere hu lusozi ni pambire esimbo ya Hatonda.” ");
INSERT INTO nuj_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Nga Yoswa ahola ngʼolu Musa gamulagira. Ni wahya, gaŋamba abasinde abagatobola batiina ohusoola nʼAbameleki. Musa nʼAlooni ni Huuri nibo baniina olusozi. ");
INSERT INTO nuj_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Musa ni gaŋanihanga emihono mu bbanga, ngʼAbayisirayiri baŋangula aye ni gajisanga ŋaasi, ngʼAbameleki babahira amaani. ");
INSERT INTO nuj_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Musa ni galuŋirira ohuŋaniha emihono mu bbanga, baŋamba ebaale nga gehalaho. Nga Alooni ni Huuri bemeerera hu luuyi nohu luuyi ni bamuŋambiriiye emihono ŋamugulu ohwola olu lyuba lyagwa mu maaji. ");
INSERT INTO nuj_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Nga Yoswa aŋangula eŋe lyʼAbameleki nʼatambisa epiima. ");
INSERT INTO nuj_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ngʼaŋo Musengwa aloma Musa ati, “Ŋandiiha ehiitu ehyo mu hitabo, hibe hyʼohuhebulirirangaho era Yoswa ali nʼohuhimanya olwohuba nja husihiirihisa erala Abameleki baŋwe hu hyalo.” ");
INSERT INTO nuj_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Nga Musa atongola ehituuti, ngʼahiranga esiina ati “Musengwa nje bbendera yange.” ");
INSERT INTO nuj_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Galoma ati, “Olwohuba baŋaniha emihono eyiri Musengwa hu tebe yiye eyʼobuŋugi! Musengwa anasoolenga nʼAbameleki emirembe nʼemirembe.” ");
INSERT INTO nuj_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Olwola, nga Yesero omusengi wʼe Midiyaani, semwana ya muha Musa, aŋulira byosibyosi ebi Hatonda gaholera Musa nʼabaatu babe abʼAbayisirayiri era ngʼolu Musengwa gabatusa e Misiri. ");
INSERT INTO nuj_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Oluvanyuma lwa Musa ohuŋindiha Zipola omuhasi wuwe ohuja ohubonaho ebʼewaawe, Yesero semwana amusaalira omuhasi, gamusangaalira ");
INSERT INTO nuj_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","nʼabasaani babe ababiri. Omusaani mulala baali bamulanga baati Girisomu, olwohuba Musa galoma ati, “Mbaye mulugendwa mu hyalo ehitali hyʼeweefe.” ");
INSERT INTO nuj_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Obundi baali bamulanga baati Eliyezeeri, olwohuba Musa galoma ati, “Hatonda wa Bbaabba ganyeeda, gaponia epiima ya Falaawo.” ");
INSERT INTO nuj_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Nga Yesero semwana yʼomuhasi wa Musa ŋalala ni Zipola muha Musa nʼabasaani bombi batiina eyiri Musa mu lulafu eyi gaali nʼahomehire eweema ŋaapi nʼolusozi lwa Hatonda. ");
INSERT INTO nuj_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yesero gaali atumire omuutu eyiri Musa ohumuloma ati, “Ese semwana yʼomuhasi wuwo nʼabasaani babo bombi ko nʼomuhasi wuwo, huli huuja.” ");
INSERT INTO nuj_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Ngʼaŋo Musa aŋwayo atiina ohwagaanana ni semwana yʼomuhasi wuwe. Ni goola gahotama ohulaga ati amuŋa eŋono, ngʼahena amugwa mu hifuba, nga bahesania bengira mu weema. ");
INSERT INTO nuj_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Nga Musa aŋayira Yesero byosibyosi ebi Musengwa gahola Falaawo nʼAbamisiri olwʼAbayisirayiri. Era ngʼamuŋayira hu bigosi byosibyosi ebyabolaho mu lugendo lwawe era ngʼolu Musengwa gabaŋonia. ");
INSERT INTO nuj_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yesero gasangaala ohuŋulira ebiraŋi byosibyosi ebi Musengwa gaholera Abayisirayiri ohubanunula mu buŋugi wʼAbamisiri. ");
INSERT INTO nuj_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ngʼaloma ati, “Gebasiwe Musengwa owabanunula mu buŋugi wʼAbamisiri ni Falaawo! Gebasiwe Musengwa owanoŋola abaatu babe ohuŋwa mu wiidu! ");
INSERT INTO nuj_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ŋaahani tegeeye ti Musengwa ahira abahatonda bosibosi obuŋangi olwohuba gaŋonia Abayisirayiri ohuŋwa mu buŋugi wʼAbamisiri ohu bababisyangamo nʼobunyoomi.” ");
INSERT INTO nuj_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Nga Yesero semwana ya muha Musa aŋayo eŋongo eyi bohya ni yiri kwiye nʼeŋongo ejindi ejʼohuŋayo eyiri Hatonda. Nga Alooni nʼabatangirisi bosibosi abʼAbayisirayiri batiina ohuliira ŋalala ehiiŋulo ni semwana ya muha Musa, mu moni ja Hatonda. ");
INSERT INTO nuj_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ni wahya, nga Musa gehala hu tebe eyʼohusala emisango. Abaatu baali aŋo ni bamweswanigirihiise ohuŋwa mu mugamba ohwola ehyʼegulo. ");
INSERT INTO nuj_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Semwana yʼomuhasi ni gabona byosibyosi ebi Musa gaali nʼoholera abaatu, ngʼamubuusa ati, “Hiina hino ehi ohola? Lwahiina weehala ohusala emisango weŋene, abaatu bahweswanigirihisa ohuŋwa mu mugamba ohwola ehyʼegulo?” ");
INSERT INTO nuj_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Nga Musa amugobolamo ati, “Ehyo kihola olwohuba abaatu baaja eyi ndi ohumanya ebi Hatonda genda bahole. ");
INSERT INTO nuj_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ni baba nʼohutategeeragana, baaja nga ndengerera mu songa jaawe mbalomera amagambi nʼebiragiro bya Hatonda.” ");
INSERT INTO nuj_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Ngʼaŋo semwana yʼomuhasi wa Musa amuloma ati, “Ehi ohola sihiraŋi. ");
INSERT INTO nuj_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ewe nʼabaatu bano, muja hudemba. Guno mulimo mugosi bugali, soosobola huguhola weŋene. ");
INSERT INTO nuj_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ale tega ohutwi kuŋe hu magesi era Hatonda abe ni neewe. Oli nʼohweyongera ohuba muhwenda wʼabaatu eyiri Hatonda era woosenga esonga jaawe eyi ali. ");
INSERT INTO nuj_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Somesa abaatu amagambi nʼebiragiro bya Hatonda era obasomese engeri eyi bali nʼohwebisyangamo. ");
INSERT INTO nuj_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Sunayo abasinde abamagesi, abatya Hatonda, abamazima era abatenda nguzi, obateŋo ohutangirira ebibbubbu ebyʼabaatu olukumi nʼecikumi nʼataanu ko nʼehumi, ");
INSERT INTO nuj_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","babe balamuzi bʼabaatu ebiseera byosibyosi. Baholenga hu busonga obutonotono aye bahuleeterenga esonga embala. Bahwetwihirengaho omugugu, ehyo hija hwanguŋia omulimo gugwo. ");
INSERT INTO nuj_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Nʼonaŋire amagesi gange era Hatonda anaba nʼahuluŋamya atyo, soonehenengamo ndasi era abaatu bano bosibosi banagobolengayo engo waawe, ebigosi byawe ni babiholireho.” ");
INSERT INTO nuj_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Ngʼaŋo Musa aŋira amagesi aga semwana yʼomuhasi gamuŋa era byosibyosi ebi gamuloma gabiholeraho. ");
INSERT INTO nuj_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Ngʼatobola mu Bayisirayiri bosibosi abasinde abamagesi ngʼabataŋo ohutangirira ebibbubbu ebyʼabaatu olukumi nʼecikumi nʼataanu ko nʼehumi. ");
INSERT INTO nuj_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Nga baholanga hu songa jʼabaatu ebiseera byosibyosi. Era esonga engosi bajiŋiriranga Musa aye baholanga hu songa etonotono. ");
INSERT INTO nuj_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Ebiseera ni byola ebya semwana yʼomuhasi wuwe ohwagama mu gwanga lyʼewaawe, nga Musa amuseebula gagamayo. ");
INSERT INTO nuj_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Mu mwesi ogwohudatu oluvanyuma lwʼAbayisirayiri ohuŋwa e Misiri, boola mu lulafu ŋaapi nʼolusozi Sinaayi. ");
INSERT INTO nuj_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Oluvanyuma lwʼohuŋwa e Refidimu, bahomeha ekambi yaawe mu lulafu mu moni jʼolusozi Sinaayi. ");
INSERT INTO nuj_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Nga Musa aŋamba engira atiina hu lusozi eyiri Hatonda. Nga Musengwa amulanga ohuŋwa hu lusozi ati, “Abayisirayiri abejuhulu ba Yakobbo balome oti, ");
INSERT INTO nuj_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Enywe mwabeene mwebonera hu ebi nahola Abamisiri era ngʼolu nabagega hu mabaŋa hya haŋungu olu egega owaana waayo, nabaleeta aŋa ndi. ");
INSERT INTO nuj_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Kale ni muja hungondera nʼomwoyo mulala era mwoseresa ebiri mu ndagaano yange, muja huba baatu bange abatobole. Wayire ehyalo hyosihyosi hyange, ");
INSERT INTO nuj_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","muja huba basengi bange era egwanga eryawufu.’ Owo njʼobuhwenda obu oli nʼohulomera Abayisirayiri.” ");
INSERT INTO nuj_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ngʼaŋo Musa gagamayo atumisa abatangirisi bʼAbayisirayiri, ngʼabalomera byosibyosi ebi Musengwa gamulagira ohubalomera. ");
INSERT INTO nuj_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","NgʼAbayisirayiri bosibosi bamugobolamo baati, “Huja huhola byosibyosi ebi Musengwa alomire.” Nga nindi Musa gagamayo eyiri Musengwa amulomera ebi baatu bagobolamo. ");
INSERT INTO nuj_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Nga Musengwa aloma Musa ati, “Nja huuja eyi oli mu hireri ehimali zigizigi, abaatu baŋulire ni ndoma ni neewe era baja huhwesiganga.” Nga Musa alomera Musengwa ebi abaatu bagobolamo. ");
INSERT INTO nuj_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Nga Musengwa amuloma ati, “Yagamayo eyiri abaatu, obalome begwalaase olwa leero nʼejo era boose ebyambalo byawe. ");
INSERT INTO nuj_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Era oludaalo olwohudatu babe ni betegehire olwohuba hu ludaalo olwo, Musengwa aja hwiha hu lusozi Sinaayi abaatu bosibosi ni babona. ");
INSERT INTO nuj_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Era oja hubateraŋo esalo ohweswanigirisa olusozi aŋa bali nʼohuhoma, ohene obalome oti, ‘Mwehuume ohutatiina hu lusozi wayire ohwigerera huupi huupi. Hiisi atiina ohuupi nʼolusozi, baja humwita. ");
INSERT INTO nuj_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Baja humuhubba amabaale oba bamulase ahasaale, ŋaliŋuma humwosaho ngalo.’ Omuutu oba ehyayo, ehyegerera ohuupi nʼolusozi, hija hufa. Banafuuŋa egwala nʼamaani, abaatu baja hwigerera ohuupi nʼolusozi.” ");
INSERT INTO nuj_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ngʼaŋo Musa aŋwa hu lusozi geeha eyiri abaatu abagwalaasa, boosa ebyambalo byawe. ");
INSERT INTO nuj_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ngʼabaloma ati, “Mwetegehe hu ludaalo olwohudatu. Ŋaŋume musinde yesiyesi aŋenyuha nʼomuhasi.” ");
INSERT INTO nuj_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ni wahya mu mugamba hu ludaalo olwohudatu, ŋaaliŋo ohubbwabbwanuha nʼohumyasa nʼehireri ehikwafu ni hiri hu lusozi nʼejanjaasi lyʼegwala eryʼamaani amangi. Hiisi muutu mu kambi gateetema. ");
INSERT INTO nuj_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Nga Musa atusa abaatu mu kambi abatangiriramo ohutiina aŋa Hatonda gaali, nga bemeerera ŋaasi wʼolusozi. ");
INSERT INTO nuj_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ni baali hu lusozi Sinaayi, lwosirwosi lwali lwijuuye liisi lyereere Musengwa ni galwihaho nʼomuliro. Eriisi lyadunyanga oti hani hirombe era olusozi lwosirwosi lwateetemanga nʼamaani. ");
INSERT INTO nuj_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Era nʼejanjaasi lyʼegwala lyeyongeranga hweyongera ohufuga. Musa galomanga, nga Hatonda amugobolangamo nʼohubbwabbwanuha. ");
INSERT INTO nuj_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Musengwa geeha ŋamugulu hu lusozi Sinaayi, galoma Musa ohuniina. Nga Musa aniina hu lusozi. ");
INSERT INTO nuj_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Nga Musengwa amuloma ati, “Niinuha wagameyo olabule abaatu balehe ohutuuma esalo ohuuja ohubona Musengwa, bangi baja husihiiriha. ");
INSERT INTO nuj_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Nʼabasengi ba Hatonda boosi abamusemberera bali nʼohwegwalaasa oba sicehyo, Musengwa anababonerese.” ");
INSERT INTO nuj_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Nga Musa aloma Musengwa ati, “Abaatu sibasobola huniina hu lusozi luno Sinaayi, olwohuba watulabbira oti, ‘Muteho esalo ohulweswanigirisa era mulwabule hu jahye ohuba lwawufu.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Nga Musengwa amuloma ati, “Ninuha otiine oleete Alooni. Aye abasengi nʼabaatu batatuuma esalo ohuuja eno eyiri Musengwa oba sicehyo aja hubaboneresa.” ");
INSERT INTO nuj_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Nga Musa aniinuha atiina eyiri abaatu abalomera ebi Musengwa gamuloma. ");
INSERT INTO nuj_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Nga Hatonda aloma ebibono bino byosibyosi ati, ");
INSERT INTO nuj_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ndiise Musengwa Hatonda wuwo owahutusa mu hyalo hyʼe Misiri eyi waali nʼohola owiidu. ");
INSERT INTO nuj_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Sojumiryanga abahatonda abandi ohutusaho ese. ");
INSERT INTO nuj_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Siwebajiranga hifaananyi ehyʼehiitu hyosihyosi ehyomwigulu oba ehyohu hyalo oba ehyomu nyanja ŋaasi. ");
INSERT INTO nuj_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Sohubbiranga bifaanani ebyo amafuha ohubijumirya olwohuba ese Musengwa Hatonda wuwo ndi nʼewuba era mboneresa abaana nʼehijuhulu ehyohudatu nʼehyohune olwʼebibi byʼabasehulu baabo abacaawa. ");
INSERT INTO nuj_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Aye ndaga ohwenda hwange ohubitiirifu eyiri abaatu aba hiisi mulembe abanyenda era abaŋamba ebiragiro byange. ");
INSERT INTO nuj_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Sotambisanga esiina lyange mu binambulamo olwohuba ese Musengwa Hatonda wuwo ndiboneresa hiisi muutu ajagiija esiina lyange. ");
INSERT INTO nuj_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Hebuliranga ohuhuuma oludaalo olwa Sabbaato ni luli lwawufu. ");
INSERT INTO nuj_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Oli nʼendaalo mukaaga ejʼohuholeraho emirimo jijo. ");
INSERT INTO nuj_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Aye oludaalo olwomusanvu lwa Sabbaato eyiri Musengwa Hatonda wuwo. Hu ludaalo olwo, ŋaŋumengaŋo muutu yesiyesi hu bomu mago gago aluholeraho omulimo gwosigwosi, ewe nʼabaana babo abaseere nʼabahaana nʼabeedu babo abasinde nʼabahasi nʼebyayo bibyo nʼabalugendwa abamenyire ni nenywe. ");
INSERT INTO nuj_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Hiri hiityo olwohuba mu ndaalo omukaaga ese Musengwa njomu natonderamo egulu nʼehyalo nʼenyanja ko nʼebiitu byosibyosi ebirimo, ni nahena nga pumula hu ludaalo lwa Sabbaato. Era cʼehigira naŋa oludaalo olwo ekabi era nalwabula. ");
INSERT INTO nuj_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Oŋanga lataawo ni maawo eŋono ko wahawangaala mu hyalo ehi Musengwa Hatonda wuwo alihuhuŋa. ");
INSERT INTO nuj_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Siwiitanga. ");
INSERT INTO nuj_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Soholanga buhwedi. ");
INSERT INTO nuj_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Siwiibanga. ");
INSERT INTO nuj_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Otabeŋeranga wahyo ehi ataholire. ");
INSERT INTO nuj_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Siwegombanga nyumba yabeene. Siwegombanga muhasi wabeene oba omwidu wuwe omusinde oba omuhasi, oba esaame yiye oba nasugirya yiye wayire ehiitu hyosihyosi ehyabeene.” ");
INSERT INTO nuj_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Abaatu ni baŋulira ohubbwabbwanuha nʼegwala, babona nʼohumyasa nʼolusozi ni lweduuha eriisi, bateetema olwʼobuti. Era bemeerera ŋaleeŋi eyo. ");
INSERT INTO nuj_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Nga baloma Musa baati, “Ba ndiiwe otulomera, huja huŋulira era huhole ehyo ehi oba nʼolomire. Aye Hatonda ataloma eyi huli olwohuba nʼaneyongere ohuloma ni neefe, huja hufa.” ");
INSERT INTO nuj_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Nga Musa aloma abaatu ati, “Mutatya olwohuba Hatonda gajire ohubalaga amaani gage ko muteyongera hwonoona mu moni jije.” ");
INSERT INTO nuj_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Abaatu basigala ŋaleeŋi ne Musa gegerera ohuupi nʼehireri ehiŋambire zigizigi eyi Hatonda gaali. ");
INSERT INTO nuj_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ngʼaŋo Musengwa aloma Musa ati, “Loma Abayisirayiri oti, ‘Mweweneyeho ngʼolu ndomire ni nenywe ohuŋwa mwigulu. ");
INSERT INTO nuj_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Simujumiryanga bahatonda abandi, simubbotanga bahatonda oba mu feeza oba mu zaabbu. ");
INSERT INTO nuj_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Tongolere ehituuti mwiroba era oŋongerengaho eŋongo eyi bohya yaguguliha, eŋongo eyohuleetaŋo emiyaaya: etaama nʼembusi ko nʼeŋombe. Oja hutongolera ehituuti mu hifo ehi nasalengaŋo ohunjumirihisyangamo era nja huuja aŋo nga kuŋa ekabi. ");
INSERT INTO nuj_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Singa butongolera ehituuti, sihibanga hyʼamabaale amabaaje olwohuba muja huhifuula ehitasaanira ni mutambisa ehiitu ohubaaja. ");
INSERT INTO nuj_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Era sootongolanga ehituuti ehyʼamadaala, olwohuba nʼoniina ohuja ohuŋaayo eŋongo osobola ohweŋemula.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Ngʼaŋo Musengwa aloma Musa ati, “Ebiragiro ebi oja huŋa Abayisirayiri mbebino: ");
INSERT INTO nuj_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","‘Singa omuutu agula Omubbebbulaniya ohuba omwidu wuwe, aja humuŋeeresa ohuhena emyaha mukaaga. Mu mwaha ogwomusanvu, amuŋanga edembe lirye gatiina ni ŋaŋuma ehi asasuuye. ");
INSERT INTO nuj_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Nʼaba ni gaali muŋuulu aŋa wamugulira ohuba omwidu wuwo, sigagamangayo ewaawe nʼomuhasi. Anaba ni gaali nʼomuhasi, atiinanga nʼomuhasi wuwe. ");
INSERT INTO nuj_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Singa musengwawe amusunira omuhasi, gamusaalira abaana abaseere oba abahaana, omuhasi nʼabaana abo baliba ba musengwawe, omusinde aja hwagamayo ewaawe ngʼolu gaaja. ");
INSERT INTO nuj_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Aye singa omwidu aloma ati, ‘Nenda musengwa yange nʼomuhasi nʼabaana bange, olwʼehyo sinenda hundehula,’ ");
INSERT INTO nuj_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Musengwawe aja humuŋira aŋa bajumirihisya Hatonda ngʼamwemeeresa ŋa mwango gwʼolwigi, ngʼamuŋundula ohutwi nʼehyoma ehyogi ngʼamusigasa ngʼomwidu wuwe emirembe nʼemirembe. ");
INSERT INTO nuj_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Singa omuutu atunda omuhaana wuwe ohuba omwidu, sibamuleehanga hutiina ohuhola owiidu ngʼolu abeedu abasinde bahola. ");
INSERT INTO nuj_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Anaba nʼatasangaasa musengwawe owamugula ohuba muhasi wuwe owohutulo, aleehanga semwana yʼomuhasi oyo gamununula. Musengwawe aŋuma buŋangi ohumugusa abalugendwa olwohuba aba abbwangire endagaano. ");
INSERT INTO nuj_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Aye singa aŋamba omwidu oyo gamuŋa musaani wuwe ngʼomuhasi, amubisyanga hyʼomuhaana wuwe. ");
INSERT INTO nuj_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Omusaani oyo nʼaleetanga omuhasi owohubiri, ali nʼohweyongera ohumuŋa emere nʼengoye nʼohubanga ni naye ngʼomufumbo. ");
INSERT INTO nuj_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Nʼatamuŋenga ebyo byondatu, amuleehanga gatiina ewaawe ni ŋaŋuma husasula hiitu hyosihyosi. ");
INSERT INTO nuj_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Hiisi anahubbenga omuutu ngʼamwita, yeesi bamwitanga. ");
INSERT INTO nuj_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Aye anaba natagendereeye, adulumiranga mu hifo ehi njahutaŋo batamuholaho habi hosihosi. ");
INSERT INTO nuj_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ne anagenderera ohwita owahye, wayire aba atiinire nʼali hu hituuti hyange ohweŋonia, bamutusangaho bamwita. ");
INSERT INTO nuj_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Hiisi anahubbenga semwana oba nyina, bamwitanga. ");
INSERT INTO nuj_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Hiisi anagosyengaŋo owahye gamutunda, bamusaŋaana ni naye, yeesi bamwitanga. ");
INSERT INTO nuj_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Hiisi anaŋwabenga semwana oba nyina, bamwitanga. ");
INSERT INTO nuj_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Abaatu ni banaduhanenga ngʼomulala ahubba owahye ebaale oba ehikonde aye ndaafe ne bamulwasa hu hitanda, ");
INSERT INTO nuj_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","bataboneresanga owamuhubba singa omuhubbe atandiha ohugenda hu simbo, ohutusaho anamuliŋenga ebiseera bibye ebi afiiriiye, ngʼamujanjaba ohwola olu aŋonera erala. ");
INSERT INTO nuj_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Singa omuutu aŋamba esimbo ngʼahubba omwidu wuwe omusinde oba omuhasi, ngʼoyu bahubbire afiiraŋo, oyo ahubbire bamuboneresenga. ");
INSERT INTO nuj_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Aye omwidu nʼanahenenga oludaalo lulala oba ebiri nʼahiiri hufa, sibaboneresanga musengwawe, olwohuba omwidu oyo baamugula bugule. ");
INSERT INTO nuj_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Singa abasinde basoola nga bakosa omuhasi ali hida, ngʼehida ehyo hiŋwamo aye omuhasi ndakosewa bugali, amukohiise aja huliŋa hyosihyosi ehi yamwe yʼomuhasi oyo aba nʼamusaliiye ehi balamuzi baba ni bafugiiriiye. ");
INSERT INTO nuj_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Aye omuhasi oyo anakosewa, ehibonerezo hinabenga hyahuliŋa bulamu olwʼobulamu, ");
INSERT INTO nuj_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","moni hu lwʼemoni, liino hu lwʼeriino, muhono hu lwʼomuhono, hugulu hu lwʼohugulu, ");
INSERT INTO nuj_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","owohye hu lwʼowohyere, ebbwa hu lwʼebbwa, ehinubuulire hu lwʼehinubuulire. ");
INSERT INTO nuj_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Omuutu nʼahubbanga omwidu wuwe omusinde oba omuhasi ngʼemoni yifaamo, amuleehanga gatiina ewaawe, ohuliŋa emoni yiye. ");
INSERT INTO nuj_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Omuutu anahubbenga omwidu wuwe omusinde oba omuhasi ngʼamubbwagamo eriino, amuleehanga gatiina ewaawe olwʼohuliŋa eriino lirye. ");
INSERT INTO nuj_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Ebunwa yʼeŋombe ni gunyanga omuutu yamwita, bayihubbanga amabaale bayiita, nʼenyama yaayo sibayiryanga. Era sibavunananga mweneeyo. ");
INSERT INTO nuj_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Aye eŋombe eyo yinaba ni yibaaye nʼomuze ogwohugunya abaatu, balabula omweneeyo, cooka sayisidihe, ni gunyanga omuutu yamwita, bayihubbanga amabaale bayita era biitanga nʼomweneeyo. ");
INSERT INTO nuj_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Aye omweneeyo ni banamusaliranga endiŋi ohununula obulamu wuwe batamwita, aŋangayo byosibyosi ebi bamusalira. ");
INSERT INTO nuj_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Egambi lino linaŋambenga hu mwana omuhaana oba omuseere oyu ebunwa yʼeŋombe yiba ni yigunyire. ");
INSERT INTO nuj_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Singa ebunwa yʼeŋombe egunya omwidu omusinde oba omuhasi ngʼemwita, omwene eŋombe anasasulenga omwene mwidu ebitundu amahumi adatu ebyʼefeeza, ne eŋombe eyo bayihubbenga amabaale bayite. ");
INSERT INTO nuj_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Omuutu nʼanayabenga eroŋo aye ndalisiiha, ne eŋombe oba nasugirya yagwamo, ");
INSERT INTO nuj_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","omwene eroŋo eryo ali nʼohuliŋa omwene hyayo ehyo, ngʼaŋira efuuye yiba yiye. ");
INSERT INTO nuj_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Singa ebunwa yigunya eyobundi nga yiita, batundanga endamu nga bagabana ebbeesa nga bahena bagabana neefu. ");
INSERT INTO nuj_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Aye ebunwa eyo yinaba ni yibaaye ngwiri, ni baali ni balabulaho omweneeyo cooka saayisidihe, ali nʼohuliŋa ngʼaŋira efu. ");
INSERT INTO nuj_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Singa omuutu geeba eŋombe ngʼayisala oba gayitunda, aja huliŋa eŋombe etaanu. Ne aniiba etaama gayisala oba gayitunda, aja huliŋa ene. ");
INSERT INTO nuj_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Singa basaŋaana omwibi nʼabbwaga enyumba owiire ngʼabamwita, amwitire saaba nʼomusango ogwʼobutemu. ");
INSERT INTO nuj_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Aye singa wuba wuhyeye, amwitire aba nʼomusango ogwʼobutemu. “Omwibi ali nʼohuliŋa, ne anaŋuma hiitu hyosihyosi, bamutundanga gahola owiidu ohuliŋa ehi aba ni geebire. ");
INSERT INTO nuj_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Singa bamusaŋaana nʼehyayo ehi aba ni geebire ni hiri hiramu, wayire saame oba nasugirya oba taama, ali nʼohuliŋa ebiri. ");
INSERT INTO nuj_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Singa omuutu aleha ebyayo bibye byayiira mu birime oba endimiro yʼemizabbibbu eyobundi, ali nʼohuliŋa hu birime bibye oba ebyomu ndimiro yiye eyʼemizabbibbu ebihirira erala obulaŋi. ");
INSERT INTO nuj_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Singa omuutu aŋambya omuliro nga gulanda gutiina gwohya endimiro yʼengaano yʼabaatu abandi, oyo aba nʼaŋambisye omuliro ali nʼohuliŋa. ");
INSERT INTO nuj_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Singa omuutu abiihisa owahye ebbeesa oba ebiitu, nga bengira mu nyumba eyo babiiba, banaŋamba omwibi oyo, ali nʼohuliŋa emirundi ebiri. ");
INSERT INTO nuj_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Aye singa sibaŋamba mwibi, omwene nyumba bamuŋiranga mu moni jʼabalamuzi babone obanga saŋambanga hu biitu byʼowahye ebyo. ");
INSERT INTO nuj_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ni ŋabangaŋo obuyoga ni buŋamba hu ŋombe oba nasugirya oba etaama oba olugoye oba ehiitu ehindi hyosihyosi ehigotire, ehi muutu aloma ati ‘Hino hyange,’ bombi abahihayanira batiinanga owʼomulamuzi. Era oyo oyu Hatonda asalira omusango ohumusinga, aja huliŋa owahye emirundi ebiri. ");
INSERT INTO nuj_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Singa omuutu gegeha owahye nasugirya oba eŋombe oba etaama oba ehyayo hyosihyosi, ne hyafa oba hyabbwagiha oba bahyiiba ni ŋaŋuma amanyire, ");
INSERT INTO nuj_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","bombi batiinanga mu moni ja Musengwa, ngʼoyu babiihisa alayira ati saaŋambangaho hu hyayo ehyo. Omweneeyo afugiiriranga era owahye saaja huliŋa. ");
INSERT INTO nuj_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Aye singa hizuuha ti oyu baŋa ohwaya njʼomwibi, ali nʼohuliŋa. ");
INSERT INTO nuj_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Singa esolo njʼeyalya, aŋambanga ebitundu ebisigayeho gabiŋira mu moni jʼabalamuzi ohuba obujulizi era saliŋanga. ");
INSERT INTO nuj_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Singa owahyo geyasiha ehyayo hyihyo, hyabbwagiha oba nga hifa omweneehyo nʼaŋumaŋo, ali nʼohumuliŋa. ");
INSERT INTO nuj_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Aye singa omweneehyo abaaŋo, oweyasiha saaja huliŋa. Ne ni hiba ni hyali hipangise, ebbeesa ejo jihenanga. ");
INSERT INTO nuj_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Singa omuutu adulingadulinga omuhaana ataŋenyuhangaho nʼomusinde era aŋuma amwenda obufumbo, ngʼaŋenyuha ni naye, ali nʼohuhwa omuhaana oyo amuŋire abe muhasi wuwe. ");
INSERT INTO nuj_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Aye semwana yʼomuhaana anagaana, omusinde ali nʼohuliŋa aŋe semwana yʼomuhaana oyo emaali hyali ohuhwa omuhasi. ");
INSERT INTO nuj_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Simuleehanga muhasi omufumu yesiyesi ohuba mulamu. ");
INSERT INTO nuj_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Mwitanga omuutu yesiyesi aŋenyuha nʼehisolo. ");
INSERT INTO nuj_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Hiisi muutu aŋonga eyiri abahatonda ohutusaho ese Musengwa, mumusihiirisanga. ");
INSERT INTO nuj_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Simubisyanga mulugendwa wubi, wayire ohumutulugunya olwohuba mwesi mwali balugendwa mu gwanga lyʼe Misiri. ");
INSERT INTO nuj_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Simubisyanga namwandu oba mulekwa wubi. ");
INSERT INTO nuj_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Singa mubabisya bubi, bandiririra, nja huŋulira ohulira hwawe. ");
INSERT INTO nuj_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Nja hubaluŋira mbeete nʼepiima, ngʼabahasi benywe boosi bafuuha banamwandu nʼabaana benywe nga bafuuha bamulekwa. ");
INSERT INTO nuj_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Singa oŋola mulala hu baatu bange mu nywe abagadi ebbeesa, somuterangaho magoba ngʼolu basubuuzi bahola. ");
INSERT INTO nuj_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Singa owahyo ahusingira ehyambalo hihye, omugobohesanga eryuba ni lihiiri hugwa mu maaji, ");
INSERT INTO nuj_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","olwohuba ehyambalo ehyo njʼehigedanya hu meeno. Ni ganyeŋundereranga, nja huŋulira ohulira huhwe namuyeeda olwohuba ndi nʼehisasabirisi. ");
INSERT INTO nuj_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Sofodogolanga Hatonda era soolomanga wubi hu mutangirisi wʼabaatu babo. ");
INSERT INTO nuj_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Sosigasanga hiitu hyosihyosi ni wuupa eŋongo eyʼebirime oba eyomu mizabbibbu. “Oli nʼohuupa omwana omuseere omudaayi. ");
INSERT INTO nuj_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Oholanga otyo nohu ŋombe nʼetaama jijo. Eŋombe oba etaama yinasaala enyana esinde, leha ebe ni nyina endaalo musanvu, ngʼoyiŋongayo hu ludaalo olwomunaana. ");
INSERT INTO nuj_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Muli baatu bange abawufu. Olwʼehyo simulyanga nyama eyi solo yisire. Muyidanyiranga embwa.” ");
INSERT INTO nuj_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Nga Hatonda geyongera aloma ati, “Soolomanga byakalebule era soŋanga obujulizi owobudulingi ohubeera omuutu omucaamu. ");
INSERT INTO nuj_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Sootiiniranga hu guŋindi gwʼabaatu abahola ebibi. Era ni bahulomanga ohuŋa obujulizi mu kooti, sobbalangatanianga olwʼohwenda owagire oguŋindi gwʼabaatu ogucaamu. ");
INSERT INTO nuj_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Era siwehubbiranga hu luuyi lwʼomugadi ahire omusango wayire mucaamu. ");
INSERT INTO nuj_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Singa osaŋaana eŋombe oba nasugirya yʼomulabe wuwo eyigotire, oyimugobohesanga. ");
INSERT INTO nuj_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Nʼobonanga nasugirya yʼomuutu atahwenda ni yiguuye olwʼobusito obu yetwihire, oyiyeedanga wayinyosa. Sooyibitangaho huyibitaho. ");
INSERT INTO nuj_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Singa omugadi aba nʼomusango mu kooti, simugumusalirisanga humusinga olwohuba mugadi. ");
INSERT INTO nuj_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Abalamuzi ni banasalenga emisango, bali nʼohubona baati sibehubbira. Sibasaliranga omuutu omuluŋamu ogwʼohufa. Banahola baatyo, sinja hubasoniŋa. ");
INSERT INTO nuj_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Soofugiiriranga huhuŋa nguzi olwohuba enguzi yiigala emoni soofayo hu hituufu era yicaamya endoma yabaluŋamu. ");
INSERT INTO nuj_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Soobisyanga mugwira bubi, mwesi mwaliho bagwira mu gwanga lyʼe Misiri. ");
INSERT INTO nuj_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Muhomanga ebirime mu ndimiro jenywe ohuhena emyaha mukaaga era ni muhungulanga hiisi mwaha. ");
INSERT INTO nuj_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Aye mu mwaha ogwomusanvu simulimanga, muleehanga eroba lyaŋuumula. Abagadi mu nywe basune ebyohulya ebimerire ebyene omwaha ogwo era nʼesolo joosi jirye ebi baleehaho. Muholanga cʼehyene endimiro ejʼemizabbibbu nʼejemizayiti. ");
INSERT INTO nuj_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Mu ndaalo mukaaga, oholanga emirimo jijo aye oŋuumulanga hu ludaalo olwomusanvu, abeedu babo nʼabagwira nʼesaame ni nasugirya jijo jiŋuumulenga. ");
INSERT INTO nuj_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Mwegenderese ohuhuumanga byosibyosi ebi mbalomire. Simujumiryanga bahatonda abandi wayire nʼohulomaho hu masiina gaawe. ");
INSERT INTO nuj_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Emirundi edatu hiisi mwaha, mulyanga embaga ohuutaamo eŋono. ");
INSERT INTO nuj_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Mulyanga Embaga eyʼEmigaati Ejibatatayemo Ehisimbulusa ohuhena endaalo musanvu ngʼolu nabalagira. Ehyo muhiholanga mu hiseera ehi nataŋo mu mwesi gwʼAbbibbu, olwohuba omwesi ogwo njʼogu mwaŋweramo e Misiri. “Ŋaŋumeŋo muutu yesiyesi obuja mu moni jange nʼengalo enjereere. ");
INSERT INTO nuj_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Mulyanga Embaga eyʼAmakungula ni mutandiha ohuhungula ebibala. “Mulyanga Embaga eyʼEbisiisira ni mu hungula ebidaayi mu ndimiro jenywe hu komerero yʼomwaha. ");
INSERT INTO nuj_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Hiisi mwaha abasinde bosibosi bali nʼohutiina ohunjumirya ese Musengwa Omwene Buŋangi hu mbaga ejo edatu. ");
INSERT INTO nuj_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Simuupanga mafugi gʼehyayo ehi muŋongire ŋalala nʼomugaati ogu bataayemo ehisimbulusa. “Era amasavu gʼehyayo ehi baŋongire hu mbaga, sigaŋenyuhanga ohwola mu mugamba. ");
INSERT INTO nuj_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Ni muhungulanga ebibala ohuŋwa mu ndimiro jenywe, muŋambanga ebihirira erala obulaŋi mwaŋira mu nyumba ya Musengwa Hatonda wenywe. “Simunyiiyanga enyama eyʼenyana yʼembusi ni mutabuyemo amabeere. ");
INSERT INTO nuj_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Nja hutuma malayika abatangiriremo era abahuume mu ngira aboose mu hifo ehi nategeha. ");
INSERT INTO nuj_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Mumuŋe eŋono era mumugondere. Simumujeemeranga olwohuba saaja hubasoniŋa, muŋaaye obuŋangi wange. ");
INSERT INTO nuj_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Singa mumugondera nʼomwoyo mulala mwahola hiisi ehi mbaloma, aja hufuuha mulabe wabalabe benywe era nja huŋiriŋania abo ababaŋiriŋania. ");
INSERT INTO nuj_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Malayika wange aja hubatangiriramo aboose mu mawanga gʼAbamooli nʼAbahiiti nʼAbapereezi nʼAbakanani nʼAbahiivi ko nʼAbayebbusi era nja hubasihiirisa bosibosi. ");
INSERT INTO nuj_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Simuhubbiranga bahatonda baawe mafuha oba mwabajumirya era simuhopanga sambo jaawe. Musihiirisanga abahatonda baawe abo era muteteenulanga agabaale gaawe. ");
INSERT INTO nuj_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Mujumiryanga Musengwa Hatonda wenywe era aja huŋa emere nʼamaaji genywe ekabi. Nja hutusaŋo obulwaye mu nywe. ");
INSERT INTO nuj_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Era siŋalibaŋo muhasi aŋwamo ehida oba omugumba mu nywe. Muli wangalanga emyaha mingi. ");
INSERT INTO nuj_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Ndi ŋindiha etiisa yange emutwe eyi mutiina nʼaleeta ohutabuhatabuha mu baatu ababalumba era ndireetera abalabe benywe bosibosi ohubaduluma. ");
INSERT INTO nuj_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ndi ŋindiha etiisa emutwe wenywe ohubatangiriramo yadulumya Abahiivi nʼAbakanani nʼAbahiiti. ");
INSERT INTO nuj_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Aye sinja hubabbinga mu mwaha mulala olwohuba ehyalo hija husiiha, ngʼesolo jaala ohubahira obungi. ");
INSERT INTO nuj_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ne ndibabbinganga polapola ohwola olu mulyeyongera obungi, mwala mwaŋira emiwuluko. ");
INSERT INTO nuj_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Esalo lyʼehyalo hyenywe lija huŋwa hu Nyanja Enando ohwola hu nyanja eyʼAbafirisuuti, nʼohuŋwa hu lulafu ohwola hu lwabi Yufuleeti. Ndibaŋa obuŋangi hu beehasi bomu hyalo eyo era muli babbingamo. ");
INSERT INTO nuj_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Simuholanga ndagaano ni nabo wayire nʼabahatonda baawe. ");
INSERT INTO nuj_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Simuleehanga baatu abo humenya mu gwanga lyenywe olwohuba baja hubaleetera ohwonoona mu moni jange, nʼohujumirya abahatonda baawe huja huba hyʼomutego eyi muli.” ");
INSERT INTO nuj_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Oluvanyuma lwa Musengwa ohuŋa amagambi, galoma Musa ati, “Niina wuuje eno hu lusozi, ewe nʼAlooni nʼabasaani babe bombi, aba Nadabbu nʼAbbihu ko nʼabatangirisi esanvu abʼAbayisirayiri. Enywe muja hunjumirya ni muliho ŋaleeŋi. ");
INSERT INTO nuj_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Aye ewe Musa weŋene ndiiwe oja hwigerera ŋaapi, abandi batagesyaho ohwigerera. Abaatu bataniina hu lusozi ni neewe.” ");
INSERT INTO nuj_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musa ni gatiina galomera abaatu byosibyosi ebi Musengwa galagira, nga bamugobolamo baati, “Huja huhola byosibyosi ebi Musengwa alomire.” ");
INSERT INTO nuj_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Nga Musa aŋandiiha byosibyosi ebi Musengwa galoma. Ni wahya mu mugamba, ngʼatongola ehituuti mu meeho gʼolusozi ngʼataaŋo amabaale ehumi nabiri ohuhebuliriraho ebiha bya Yisirayiri. ");
INSERT INTO nuj_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ngʼatuma abavubuka Abayisirayiri nga baŋaayo eŋongo eyiri Musengwa eyi bohya ehwiye yaguhuuliha era nga baŋonga ebunwa jʼeŋombe ohutabagana. ");
INSERT INTO nuj_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Nga Musa aŋamba ehitundu hyʼamafugi gʼeŋombe eji baŋonga agata mu bibya, ngʼaŋamba agasigalaho agaŋwanyusa hu hituuti. ");
INSERT INTO nuj_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ngʼaŋamba ehitabo hyʼendagaano ahisomera abaatu. Ni gahena, nga bagobolamo baati, “Huja huhola byosibyosi ebi Musengwa alomire era huja hubigondera.” ");
INSERT INTO nuj_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ngʼaŋo Musa aŋamba amafugi aga gaali nʼataaye mu bibya agaŋwanyusa hu baatu, aloma ati, “Gano njʼamafugi aganywania endagaano eyi Musengwa aholire ni nenywe ngʼolu alomire ebibono bibye ebyo byosibyosi.” ");
INSERT INTO nuj_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ngʼaŋo Musa nʼAlooni nʼabasaani babe bombi aba Nadabbu nʼAbbihu ko nʼabatangirisi esanvu abʼAbayisirayiri baniina olusozi, ");
INSERT INTO nuj_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","nga babona Hatonda wa Yisirayiri. Ŋaasi wamagulu gage ŋaaliŋo ehiitu ehifaana hyʼomwaliriro ogwʼamabaale aga balanga baati safiro ni gali gabbululu hyʼegulu. ");
INSERT INTO nuj_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Aye Hatonda sigahola habi hosihosi abatangirisi abo abʼAbayisirayiri. Baabona Hatonda, nga baliira era banywera mu moni jije. ");
INSERT INTO nuj_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Nga Musengwa aloma Musa ati, “Niina hu lusozi wuuje eno era nʼoli eno, nja huhuŋa ebipande ebyʼamabaale ohupandiihire amagambi nʼebiragiro, ebi oja husomesa abaatu.” ");
INSERT INTO nuj_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ngʼaŋo Musa genyoha ni Yoswa omuŋeeresa wuwe batiina baniina olusozi lwa Hatonda. ");
INSERT INTO nuj_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Nga Musa aloma abatangirisi bʼAbayisirayiri ati, “Mutuhuumire ŋano ohwola olu hunagobole. Alooni ni Huuri bali aŋo ni nenywe. Hiisi aba nʼehigosi ni genda obuyeedi atiine eyi bali bamuholeho.” ");
INSERT INTO nuj_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Musa ni gatiina hu lusozi, ngʼehireri hiija hiruwihaho, ");
INSERT INTO nuj_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ngʼeŋono lya Musengwa liba hu lusozi olwo Sinaayi. Ehireri hyaluwihaho ohuhena endaalo mukaaga. Nga hu ludaalo olwomusanvu, Musengwa nʼali mu hireri, alanga Musa. ");
INSERT INTO nuj_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Eyiri Abayisirayiri, eŋono lya Musengwa ŋamugulu wʼolusozi lyafaana hyʼomuliro ogwohya gwaguhuulisa. ");
INSERT INTO nuj_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Nga Musa aniina ŋamugulu wʼolusozi gengira mu hireri, ngʼahenayo endaalo amahumi ane omuusi nʼowiire. ");
INSERT INTO nuj_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Nga Musengwa aloma Musa ati, ");
INSERT INTO nuj_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Loma ehibbubbu hyʼAbayisirayiri bandetere ebirabo. Hiisi muutu mula owenda ohuupa ehirabo, ahupeere. ");
INSERT INTO nuj_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Bahupeere ebirabo ebyʼezaabbu nʼefeeza nʼehihomo, ");
INSERT INTO nuj_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","nʼengoye endaŋi eja laasi nʼewuuzi eja bbululu nʼeja namasyoma nʼenando nʼengoye eji baahola mu mooya gʼembusi ekasi, ");
INSERT INTO nuj_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","nʼebyanjo byʼetaama emiigu ebi babamba byafuuha birando, nʼebyanjo byʼembusi nʼembaawo ejomu musaala ogu balanga baati kasiya, ");
INSERT INTO nuj_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","nʼamafuta gʼetaala nʼebyahaloosa ebyohutawula mu mafuta agʼohutambisa mu hwawula nʼobubbaani owʼohudunyisa ");
INSERT INTO nuj_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","nʼamabaale agʼebbeeyi aga balanga baati onikisi ohuta hu efodi ko nʼamabaale agandi ohuta hu hyambalo ehyomu hifuba ehyʼomuhulu wʼabasengi. ");
INSERT INTO nuj_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Era abaatu bakolere ehifo ehyawufu era nja hubanga mu bo. ");
INSERT INTO nuj_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Muholanga Eweema Enjawufu eyo nʼebiitu ebyʼohubamo, mu kola enyene nʼenyene eyi nja huhulaga.” ");
INSERT INTO nuj_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Nga Musengwa aloma Musa ati, “Loma abaatu bahole e Sanduuku mu mbaawo ohuŋwa mu musaala kasiya. Obuleeŋi, eyiici ane nʼetaanu, obugalamu eyiici abiri namusanvu, obuleeŋi ohuja ŋamugulu eyiici abiri namusanvu. ");
INSERT INTO nuj_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Mumaalanga mugati nʼohumugulu wʼEsanduuku eyo nʼezaabbu enyene nʼenyene era muyiteho omugo ogwʼezaabbu ohuyeswanigirisa. ");
INSERT INTO nuj_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Muholanga emihobyo ene ejʼezaabbu mwajita hu magulu, ebiri hu luuyi nʼoluuyi. ");
INSERT INTO nuj_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Muhole emirabba ejʼohugingira ohuŋwa mu muŋwa omuhosa mujimaaleho nʼezaabbu. ");
INSERT INTO nuj_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Muŋambe emirabba ejo mujingise mu mihobyo hu hiisi luuyi olwʼe Sanduuku ohweyeedesa mu huyibbeeda. ");
INSERT INTO nuj_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Emirabba ejo ejʼohweyeedesa ohuyibbeeda mujirehanga mu mihobyo ejʼe Sanduuku era simujitusangamo. ");
INSERT INTO nuj_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Oŋambanga ebipande ebyʼamabaale ohuli amagambi wabita mu Sanduuku. ");
INSERT INTO nuj_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Muŋambanga ezaabbu enyene nʼenyene, nga muyiholaamo ehisembo ehyohu Sanduuku, obuleeŋi eyiici ane nʼetaanu, obugalamu eyiici abiri namusanvu. ");
INSERT INTO nuj_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Mubbote mu zaabbu enyene nʼenyene ebifaanani byʼabamalayika abakerubbi babiri, babe hu luuyi nʼoluuyi olwʼehisembo ehyo. ");
INSERT INTO nuj_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Kerubbi mulala abe hu luuyi lulala, owundi abe hu luuyi olundi aye bombi babe hiitu hirala nʼehisembo hyʼe Sanduuku ni ŋaŋumaŋo buyungiro. ");
INSERT INTO nuj_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Abakerubbi bombi bahotamirire ni balengereene era ni banjuluhisiiye nʼamabaŋa gaawe hu hisembo hyʼe Sanduuku. ");
INSERT INTO nuj_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ebipande ebyʼamabaale ebi nja huhuŋa oja hubita mu Sanduuku eyo, ohene oyiwiheho nʼehisembo hyayo. ");
INSERT INTO nuj_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ŋamugulu wʼehisembo ehyo, ŋagati wʼabakerubbi abo bombi hu Sanduuku yʼEndagaano eyo, paŋa huja hwagananiranga era kulomere ebiragiro byange byosibyosi ebi oja hulomera Abayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Mubbote emeeza mu musaala ogu balanga baati kasiya, obuleeŋi eyiici adatu namukaaga, obugalamu eyiici ehumi namunaana, obuleeŋi ŋamugulu eyiici abiri namusanvu. ");
INSERT INTO nuj_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Muyimaalanga nʼezaabbu enyene nʼenyene era muyiteho omugo ogwʼezaabbu ohuyeswanigirisa. ");
INSERT INTO nuj_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Muyinioleheseho omugo, eyiici edatu ohuyeswanigirisa, muyimaaleho ezaabbu. ");
INSERT INTO nuj_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Oja hubbota emihobyo ejʼezaabbu ene, ohene ote ndala mu hiisi sonda hu magulu gʼemeeza eyo. ");
INSERT INTO nuj_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Emihobyo ejo jiri nʼohuba huupi nʼomugo omu baja ohwengisa emirabba ejʼemeeza eyo. ");
INSERT INTO nuj_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Oŋambe emirabba ebiri ejʼomuŋwa omuhosa, mujimaaleho nʼezaabbu. Emirabba ejo, jahubbeedesanga emeeza. ");
INSERT INTO nuj_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Era mubbotanga esaani nʼebikopo nʼejaaga nʼebibya ohuŋwa mu zaabbu enyene nʼenyene ebyʼohutambasanga hu binywewa. ");
INSERT INTO nuj_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Muja huta emigaati emyawufu hu meeza eyo jibenga mu moni wange hiisi ludaalo. ");
INSERT INTO nuj_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Oja hubbota ehihondo hyʼetaala ohuŋwa mu zaabbu enyene nʼenyene, owihaliro nʼenduli yahyo nʼebikopo ebyohujuhamo amafuta ebiri hyʼebimuli era byosibyosi ni biri hiitu hirala ni ŋaŋuma buyungiro. ");
INSERT INTO nuj_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Ehihondo hyʼetaala hiribaaho amasaga mukaaga, adatu hu luuyi nʼoluuyi. ");
INSERT INTO nuj_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Hiisi lusaga lubeho ebimuli bidatu ebifaana hyʼebyalumondi ni biwumbuluhire. ");
INSERT INTO nuj_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Era hu nduli yʼehihondo hyʼetaala hubeho ebihopo bine ebifaana hyʼebimuli alumondi. ");
INSERT INTO nuj_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ŋaasi wa hiisi masaga abiri ohuŋwa hu nduli yʼehihondo, hubeŋo ehiitu hyʼehimuli alumondi. ");
INSERT INTO nuj_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Babbote ehihondo hyʼetaala nʼamasaga ko nʼebiitu ebiri hyʼebimuli byʼalumondi biri nʼohuba hiitu hirala ohuŋwa mu zaabbu enyene nʼenyene. ");
INSERT INTO nuj_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Nʼohenire ebyo, obbotanga etaala musanvu ejʼohuta hu hihondo era banajiŋambyenga ohuŋa enjase mu hifo ehyo. ");
INSERT INTO nuj_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Oja hubbota esuniya nʼehiitu ehyohutambisa ohulongoosa etambi ohuŋwa mu zaabbu enyene nʼenyene. ");
INSERT INTO nuj_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Oŋambanga ekilo amahumi adatu nʼetaanu ejʼezaabbu enyene nʼenyene wabbotamo ehihondo hyʼetaala nʼebitiiniraho byosibyosi. ");
INSERT INTO nuj_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Ebyo byosibyosi obiholanga nʼolonderera endagiriro eyi wasuna ni waali hu lusozi Sinaayi.” ");
INSERT INTO nuj_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Nga Musengwa aloma Musa ati, “Muhole Eweema Enjawufu ni mutambisa etimbe ehumi eji baahola mu ngoye endaŋi eja laasi batunga nʼewuuzi eja bbululu nʼeja namasyoma nʼenando. Era mu timbe ejo baahubbamo nʼebifaanani byʼabamalayika aba balanga baati abakerubbi. ");
INSERT INTO nuj_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Etimbe josijosi jiri nʼohuŋeraŋerana, obuleeŋi efuuti ane nʼebiri, obugalamu efuuti mukaaga. ");
INSERT INTO nuj_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Oŋambe etimbe etaanu ojiŋimbye ŋalala era nʼetaanu ejindi joosi ojiŋimbye ŋalala. ");
INSERT INTO nuj_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ohene ohole endiba mu lugoye olwa bbululu ejohuŋambihisya etimbe ejo eji bagaata ataanu ataanu. ");
INSERT INTO nuj_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Hola epeta amahumi ataanu hutulo wʼetimbe engaate ejo, endiba ejohu luuyi lulala ni gaŋeraŋerana nʼejohu luuyi olundi. ");
INSERT INTO nuj_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Era ohole emirobo amahumi ataanu mu zaabbu ohugaata ŋalala etimbe jombi, ko Eweema Enjawufu ebe pimbe ŋalala. ");
INSERT INTO nuj_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Hola etimbe ehumi nandala ohuŋwa mu mooya gʼembusi, ohuwiiha hu Weema Enjawufu. ");
INSERT INTO nuj_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Obuleeŋi, etimbe ehumi nandala ejo jiri nʼohuba efuuti ane nʼetaanu, obugalamu efuuti mukaaga. ");
INSERT INTO nuj_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Oŋimbe etimbe etaanu ŋalala, ohene oŋimbe nʼomukaaga joosi ŋalala. Oja hufumbamo ŋabiri olutimbe olwomukaaga olwomu moni wʼEweema Enjawufu. ");
INSERT INTO nuj_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ohole endiba amahumi ataanu hu sonda nohu sonda wʼetimbe eji oŋimbire ŋalala. ");
INSERT INTO nuj_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ohole emirobo amahumi ataanu ejʼehihomo, ohene ojite mu ndiba ohugumya eweema ŋalala. ");
INSERT INTO nuj_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ehitundu hira ehija husigalaho ni bahenire ohufumba hu timbe, bahirerejese enyuma wʼEweema Enjawufu. ");
INSERT INTO nuj_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Obuleeŋi, etimbe jija huba eyiici ehumi namunaana enjuyi nʼenjuyi, ni jiwiiha hu Weema Enjawufu. ");
INSERT INTO nuj_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Oholangayo ehyohuwiiha hu weema mu hyanjo hyʼetaama emiigu ehi beeniha hyafuuha hirando, oholeyo nʼehyanjo ehindi ehyʼembusi ohuta hu mugulu. ");
INSERT INTO nuj_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Olihola embaawo ejomu musaala kasiya ejʼohutongolamo Eweema Enjawufu. ");
INSERT INTO nuj_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Obuleeŋi wa hiisi lubaawo buja huba efuuti ehumi nʼetaanu, obugalamu jibe efuuti ebiri nʼeyiici edatu. ");
INSERT INTO nuj_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Hola ekondo ebiri ohuba ŋaasi wa hiisi lubaawo. Era embaawo ejo josijosi, jiri nʼohuba ni jagaagana. ");
INSERT INTO nuj_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Oja huhola embaawo abiri ejʼoluuyi lwomu mehiriro gʼEweema Enjawufu, ");
INSERT INTO nuj_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","era ohole nʼebiihaliro amahumi ane mu feeza ŋaasi waajo: ekondo ebiri ŋaasi wa hiisi lubaawo. ");
INSERT INTO nuj_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ohole embaawo amahumi abiri ejohu luuyi olwomu mehiriro gʼEweema Enjawufu, ");
INSERT INTO nuj_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","nʼebiihaliro amahumi ane ebyʼefeeza, ebiihaliro bibiri ŋaasi wa hiisi lubaawo. ");
INSERT INTO nuj_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ohole embaawo mukaaga ejohu luuyi lwʼebugwalyuba lwʼEweema Enjawufu, ");
INSERT INTO nuj_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ohene ohole nʼembaawo ebiri ejomu sonda. ");
INSERT INTO nuj_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Oŋimbanga embaawo ejo jombi ohuŋwa ŋaasi ohwolera erala ŋamugulu ni bajisidihire nʼepeta ndala. Jombi jiri nʼohuba jiityo. ");
INSERT INTO nuj_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ŋosiŋosi, embaawo jija huba munaana nʼebiihaliro ehumi namukaaga ebyʼefeeza, bibiri ŋaasi wa hiisi lubaawo. ");
INSERT INTO nuj_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Ohole embaawo ehumi nʼetaanu ohuŋwa mu musaala kasiya ohuba emihiihiro: etaanu jibe hu luuyi olwʼengulu lwʼEweema Enjawufu, ");
INSERT INTO nuj_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","etaanu ejohu luuyi lwomu meenamo. Era ohole emihiihiro etaanu ejohu luuyi lwʼebugwalyuba olwʼEweema Enjawufu. ");
INSERT INTO nuj_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Omuhiihiro ogwa ŋagati wʼembaawo guliŋwa hu luuyi ohwola hu luuyi lwʼefuleemu. ");
INSERT INTO nuj_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Olimaala embaawo ejo nʼezaabbu era ohene obbote epeta mu zaabbu ejohusidihira emihiihiro era joosi ojimaalangaho nʼezaabbu. ");
INSERT INTO nuj_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Olitongola Eweema Enjawufu mu ngeri eyi kulagire hu lusozi luno. ");
INSERT INTO nuj_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Era oja huhola olutimbe mu ngoye endaŋi eja laasi nʼewuuzi eja bbululu neja namasyoma nʼenando, omuhugu galutungaho ebifaanani byʼabamalayika aba balanga baati abakerubbi. ");
INSERT INTO nuj_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Muja huluŋambya nʼebyoma ebiri oti mirobo ohuŋwa mu zaabbu hu bisindi bine ebyomu musaala kasiya ni babimaayeho nʼezaabbu ni biri mu biihaliro bine ebyʼefeeza. ");
INSERT INTO nuj_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Oŋanihanga olutimbe hu mirobo ni luleereja, nga muta egongo waalwo e Sanduuku yʼEndagaano. Olutimbe olwo luja hwawulanga Ehifo Ehyawufu nʼEhifo Ehyawufu Obugali. ");
INSERT INTO nuj_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Oŋambanga ehisembo wafunihira hu Sanduuku yʼEndagaano eyiri mu Hifo Ehyawufu Obugali. ");
INSERT INTO nuj_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Oŋambanga emeeza eyʼohutangaho emigaati, wayita hu luuyi olwamehiriro hu muhono omulungi mu Eweema Enjawufu. Ehihondo hyʼetaala muhite hu luuyi lwʼomuhono omugonda mu weema. ");
INSERT INTO nuj_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Era oja huhola omulyango ogwengira mu Weema Enjawufu otemo olutimbe olu baahola mu ngoye endaŋi eja laasi batunga nʼewuuzi eja bbululu neja namasyoma nʼenando. Era hu timbe ejo ni bataho nʼomuleera. ");
INSERT INTO nuj_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Olutimbe olwo muliruholera ebisindi bitaanu ebyomu musaala kasiya era nga mubimaalaho nʼezaabbu nga muhena mubiŋambya nʼendobo ejʼezaabbu. Oholanga nʼebiihaliro bitaanu ebyʼehihomo.” ");
INSERT INTO nuj_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Ngʼaŋo Musengwa geyongera aloma Musa ati, “Obbotanga ehituuti mu musaala kasiya ohuŋeerangaho eŋongo, obuleeŋi hibe efuuti musanvu nʼehitundu, obugalamu efuuti musanvu nʼehitundu, obuleeŋi ŋamugulu efuuti ene nʼehitundu. ");
INSERT INTO nuj_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ohole ameega ane, mu hiisi sonda ene ejo otemo olwiga lulala era gali nʼohuba hiitu hirala nʼehituuti, ohene omaaleho nʼehihomo. ");
INSERT INTO nuj_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Era olihola ebyʼohuyolerangamo egohe, nʼebijiiko nʼebibya nʼewuuma nʼesuniya, ebyʼohutambisanga hu hituuti. Ebiitu ebyo byosibyosi olibibbota mu hihomo. ");
INSERT INTO nuj_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Muliyiholera oluhaliriro olwʼehihomo, nga mutaaho epeta ene hu sonda jaahyo ene. ");
INSERT INTO nuj_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Era oluhaliriro olwo, mulutanga mugati wʼehituuti ehyo, nga luhoma ŋagati. ");
INSERT INTO nuj_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Oŋambanga emirabba ohuŋwa mu muŋwa omuhosa ejʼohubbedera ehituuti era ohene ojimaaleho nʼehihomo. ");
INSERT INTO nuj_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Mwingisanga emirabba ejo mu mihobyo mu hiisi luuyi lwʼehituuti ohuyeeda mu huhibbeeda. ");
INSERT INTO nuj_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Mubbotanga ehituuti ehyo mu mbaawo ni hiri nʼeroŋo mugati. Ohiholanga mu ngeri eyi nahulaga hu lusozi.” ");
INSERT INTO nuj_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Nga Musengwa aloma Musa ati, “Otanga olunya hu Weema eyʼOhwagananirangamo, obuleeŋi wʼoluuyi lwomu meenamo buuja huba efuuti cikumi nʼataanu, etimbe endaŋi eja laasi ni jitigaliiye. ");
INSERT INTO nuj_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Ŋaja hubaaŋo esiiro amahumi abiri ejʼohujomeha mu biihaliro amahumi abiri ebyʼehihomo aye ebiitu oti mirobo ohuŋambya etimbe, bija huba byʼefeeza. ");
INSERT INTO nuj_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Engulu wʼeweema yoosi ejahubaayo esiiro mahumi abiri ejʼohujomeha mu biihaliro amahumi abiri ebyʼehihomo ko nʼebiitu ebyʼefeeza oti mirobo ohuŋambya etimbe. ");
INSERT INTO nuj_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Hu luuyi olwʼebugwalyuba wʼeweema, ŋalibaaŋo etimbe obuleeŋi efuuti sanvu nʼetaanu nʼesiiro ehumi nʼebiihaliro ebyʼehihomo ehumi. ");
INSERT INTO nuj_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Hu luuyi olwʼebuŋwalyuba, obugalamu wʼolunya buja huba efuuti sanvu nʼetaanu. ");
INSERT INTO nuj_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Obuleeŋi wʼetimbe ejo, buja huba efuuti abiri nʼebiri nʼehitundu hu luuyi lulala olwʼomulyango era hubeho esiiro edatu ejʼehihomo ko nʼebiihaliro bidatu. ");
INSERT INTO nuj_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Hu luuyi olundi olwʼomulyango, ŋabeŋo etimbe efuuti abiri nʼebiri ko nʼesiiro edatu nʼebiihaliro bidatu ebyʼebyoma. ");
INSERT INTO nuj_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Olutimbe olwomu mulyango luja huba efuuti adatu obuleeŋi olu baahola mu lugoye olulaŋi olwa laasi batunga nʼewuuzi eja bbululu neja namasyoma nʼenando era bataho nʼomuleera. Ŋaja hubaaŋo esiiro ene ko nʼebiihaliro bine, ohuludiira. ");
INSERT INTO nuj_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Baja hugaata esiiro josijosi nʼefeeza ohweswanigirisa olunya lwʼeweema era emirobo jaajo baja hujihola ni jiri jʼefeeza nʼebiihaliro ni biri byʼehihomo. ");
INSERT INTO nuj_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Obuleeŋi wʼolunya, buja huba efuuti cikumi nʼataanu, obugalamu efuuti sanvu nʼetaanu, obuleeŋi ŋamugulu efuuti musanvu nʼehitundu nʼebiihaliro bija huba byʼehihomo. Etimbe ejo bajihole mu lugoye olulaŋi olwa laasi. ");
INSERT INTO nuj_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ebiitu byosibyosi ebyohutambisa mu Weema Enjawufu, ekondo josijosi ejʼeweema ko nʼekondo ejʼolunya, jija huba jʼehihomo.” ");
INSERT INTO nuj_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Nga Musengwa geyongera aloma Musa ati, “Lagira Abayisirayiri bahuleetere amafuta agomu mizayiti ohuta mu taala, yaduhenga hiisi hiseera. ");
INSERT INTO nuj_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Alooni nʼabasaani babe bali nʼohwadusa etaala mu Weema eyʼOhwagananirangamo, yaduhirenga mu moni ja Musengwa ohuŋwa ehyʼegulu ohwola mu mugamba, egongo wʼolutimbe oluli mu moni wʼe Sanduuku yʼEndagaano. Abayisirayiri bali nʼohuhuuma egambi eryo emirembe nʼemirembe.” ");
INSERT INTO nuj_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Nga Musengwa aloma Musa ati, “Tumisa mugandawo Alooni nʼabasaani babe: Nadabbu nʼAbbihu nʼElyazaali ni Yisamaari ohuŋwa mu Bayisirayiri, nenda bapeeresenga ngʼabasengi. ");
INSERT INTO nuj_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Holera mugandawo Alooni ebyambalo ebyawufu, ebimubonesa obulaŋi era ebimuŋeesa eŋono. ");
INSERT INTO nuj_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Lomera abasinde abo aba naŋa amagesi agʼehikugu mu biitu hyʼebyo, batungire Alooni ebyambalo ebyawufu ebyo, gapeeresenga ngʼomusengi. ");
INSERT INTO nuj_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Bino njʼebyambalo ebi baja hutunga: ehyomu hifuba nʼefodi nʼeganduula nʼekaaso eyi basonire, nʼehyohu mutwe ko nʼomusibiro. Balitungira mugandawo Alooni nʼabasaani babe ebyambalo ebyo ebyawufu, bambalenga ni bapeeresa ngʼabasengi. ");
INSERT INTO nuj_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Abatungi abo, baja hutunga olugoye olulaŋi olwa laasi nʼewuuzi ejʼezaabbu neja bbululu neja namasyoma nʼenando. ");
INSERT INTO nuj_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Baja hutunga efodi mu lugoye olulaŋi olwa laasi mu ngeri eyʼehikugu nʼewuuzi ejʼezaabbu neja bbululu neja namasyoma nʼenando. ");
INSERT INTO nuj_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Hu mabega gʼefodi eyo, baja hutunga ni bagaata enjuyi jombi lweŋambe mu moni nʼegongo. ");
INSERT INTO nuj_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Batunge omusibiro nʼamagesi agʼehikugu mu lugoye njʼolwene olwo nʼefodi eyo nʼewuuzi ejʼezaabbu neja bbululu neja namasyoma nʼenando ko nʼolugoye olulaŋi olwa laasi. ");
INSERT INTO nuj_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Oŋambanga amabaale abiri agaboneha obulaŋi aga balanga baati onikisi waŋandihaho amasiina gʼabasaani ba Yisirayiri. ");
INSERT INTO nuj_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Amasiina omukaaga oja hugaŋandiiha hwibaale erala nʼagandi omukaaga hu baale erindi, ngʼolu balondehana mu husaaliwa hwawe. ");
INSERT INTO nuj_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Omukugu mu husala amabaale, aŋandiihe hu mabaale abiri ago amasiina ga basaani ba Yisirayiri, ahene agate mu fuleemu ejʼezaabbu. ");
INSERT INTO nuj_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ehyo ni hiŋooye, osidihanga amabaale ago hu mabega gʼefodi yʼomuhulu wʼabasengi ohuba ehyʼohuhebulirirangaho abaana ba Yisirayiri. Alooni gambale amasiina ago hu mabega ohukebulisa ese Musengwa ohuterabira baatu bange. ");
INSERT INTO nuj_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ohole efuleemu ejʼezaabbu, ");
INSERT INTO nuj_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","nʼejegere ebiri ejʼezaabbu enyene nʼenyene, ni jiri hyʼemigoye, ojisidihe hu fuleemu jʼezaabbu ejo. ");
INSERT INTO nuj_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Tunga ehyambalo ehyomu hifuba ehi omuhulu wʼabasengi anambalenga ohufaania ebyo ebi Hatonda genda. Olihihola mu lugoye olulaŋi olwa laasi hyʼefodi batunge nʼewuuzi ejʼezaabbu neja bbululu nʼeja namasyoma nʼenando. ");
INSERT INTO nuj_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ehyambalo ehyo hyagaagana enjuyi josijosi, bahifunyemo ŋabiri obuleeŋi eyiici mwenda, obugalamu eyiici mwenda. ");
INSERT INTO nuj_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Olihitamo enyiriri ene ejʼamabaale agʼebbeeyi, olunyiriri oludaayi lwali lwahubaho Sarudiyo ni topazi ni karubukulo. ");
INSERT INTO nuj_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Olunyiriri olwohubiri lwali lwahubaho emeraludo ni safiro ko ni dayamondi. ");
INSERT INTO nuj_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Olunyiriri olwohudatu lulibaamo yasiso nʼagate nʼamesiti. ");
INSERT INTO nuj_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Olunyiriri olwohune lubeho bberulo nʼonikisi ni yasipero. Amabaale ago gosigosi balihena nga bagata mu fuleemu ejʼezaabbu. ");
INSERT INTO nuj_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Ŋabeŋo amabaale ehumi nabiri, hu hiisi baale baŋandiheho esiina erala hu gʼabasaani ba Yisirayiri ehumi nʼababiri. ");
INSERT INTO nuj_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Ehyambalo ehyomu hifuba, olihiholera otujegere mu zaabbu enyene nʼenyene, ni babuluha hyʼemigoye. ");
INSERT INTO nuj_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Obbote epeta ebiri mu zaabbu, ngʼojita hu sonda jombi ŋamugulu wʼehyambalo ehyomu hifuba. ");
INSERT INTO nuj_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Oŋambe obujegere obubiri owʼezaabbu owo, obute mu peta mu sonda nomu sonda ejʼehyambalo ehyomu hifuba. ");
INSERT INTO nuj_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ohene osidihe esonda ejindi ebiri jira olisidihira hu ebiri ejʼefuleemu, ngʼohena ohitungira hu hohumabega mu moni hu efodi. ");
INSERT INTO nuj_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Obbote epeta ebiri mu zaabbu, ojite hu sonda jombi ejʼehyambalo ehyomu hifuba mugati hu efodi. ");
INSERT INTO nuj_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ohene obbote epeta ebiri ejindi mu zaabbu, ojite hu mabega gʼefodi, hu luuyi olwomu moni, huupi ŋamugulu wʼomusibiro gwʼefodi. ");
INSERT INTO nuj_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Basidihe epeta ejomu hifuba hu johu efodi batunge nʼewuuzi eja bbululu ni bajiŋimbya nʼahasibiro ahabbululu ahohu efodi ko ehyambalo ehyomu hifuba hitahuhamo huŋwa hu efodi. ");
INSERT INTO nuj_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Olu Alooni anengirenga mu Hifo Ehyawufu, ni gambaaye ehyambalo ehyomu hifuba ehyo ehi baaŋandihaho amasiina gʼebiha bya Yisirayiri hu mwoyo gugwe, ese Musengwa kebulirenga abaatu bange. ");
INSERT INTO nuj_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Oja huta Wurimu ni Samimu mu hyambalo ehyomu hifuba, bibenga hu mwoyo gwʼAlooni ni gaaja mu moni jange. Mu biseera hyʼebyo, anambalenga ehyambalo ehyomu hifuba galangirira eyiri Abayisirayiri ebi ese Musengwa nenda. ");
INSERT INTO nuj_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Era olitunga eganduula ohwambaliranga mu efodi, baja huyitunga nʼewuuzi eja bbululu. ");
INSERT INTO nuj_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ŋagati wʼolugoye olwo, otangaho ehituli omubefihira omutwe. Era ohweswanigirisa ehituli ehyo, oja hutaaho ehiitu oti hitogi ko hitanawuha. ");
INSERT INTO nuj_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Oja hutaaho ebifaanani ebya komamawanga ebya bbululu ohweswanigirisa ehirenge hyʼohuganduula eryo, ohitunge nʼewuuzi eja bbululu neja namasyoma nʼenando oteho nʼendege eji babbota mu zaabbu. ");
INSERT INTO nuj_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Baholanga endege ejʼezaabbu nʼebifaanani bya komamawanga ohweswanigirisa ehirenge hyʼehyambalo era birerejenga. ");
INSERT INTO nuj_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Alooni ali nʼohuhyambalanga nʼaŋeeresa ngʼomusengi. Nʼanengirenga oba nʼanatulenga mu Hifo Ehyawufu mu moni jange, banaŋulirenga ejanjaasi lyʼendege, ko atafa. ");
INSERT INTO nuj_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Oja hubbotayo esaani eyʼezaabbu enyene nʼenyene, oŋandiheho oti ‘NJAWUFU EYIRI Musengwa.’ ");
INSERT INTO nuj_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Oyisidihe nʼewuuzi ejʼerangi erya bbululu mu moni wʼehyambalo ehyohu mutwe. ");
INSERT INTO nuj_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Esaani eyo eja hubanga hu weeni wʼAlooni ohulaga ti afugiirira esobi jʼAbayisirayiri nʼaŋayo ebirabo byawe ko Musengwa gahabifugiirira. ");
INSERT INTO nuj_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Olitungira Alooni ekaaso mu lugoye olulaŋi olwa laasi era nʼehyohu mutwe hyosi, olihitunga mu lugoye olwa laasi. Batunganga omusibiro mu kola eyehikugu. ");
INSERT INTO nuj_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Oliholera abasaani bʼAlooni amakaaso nʼemisibiro ko nʼehyohu mutwe ohubabonesa obulaŋi nʼohubaŋeesa eŋono. ");
INSERT INTO nuj_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Nʼohenire ohwambasa mugandawo Alooni nʼabasaani babe ebyambalo ebyo, olibaŋaha amafuta obaabule ohubafuula benjabulo bapeeresenga ngʼabasengi. ");
INSERT INTO nuj_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Olibatungira ehyohwambala mugati ehiŋwera mu hihunya ohwola mu bisambi ohuwiiha huwereere waawe. Ehyohwambala ehyo, hija huŋwa mu lugoye olulaŋi olwa laasi. ");
INSERT INTO nuj_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Alooni nʼabasaani babe bali nʼohwambalanga ebyambalo ebyo hiisi olu banengirenga mu Weema yʼOhwagananirangamo, oba olu banatiinenga hu hituuti ohuŋeeresa mu Hifo Ehyawufu, ko batabaho musango ohubaŋweramo ohufa. Egambi lino lija huba lyʼemirembe nʼemirembe eyiri Alooni nʼolusaaye lulwe.” ");
INSERT INTO nuj_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Nga Musengwa geyongera aloma Musa ati, “Bino njʼebi oli nʼohuhola ohwawula Alooni nʼabasaani babe ohubagwalaasa ko bapeeresenga ngʼabasengi bange: oŋambanga ebunwa eperepere nʼemiigu ebiri ejiŋumaho buleme. ");
INSERT INTO nuj_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Era ohande obusyanu owʼengaano obunohi obubatatayemo ehisimbulusa, oholemo emigaati nʼobugaati ni batabuyemo nʼamafuta ogomu mizayiti ko nʼobukeeki ni baŋahireho nʼamafuta ameene ago. ");
INSERT INTO nuj_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Nʼohenire, ojite mu hisero ojiŋeyo ŋalala nʼebunwa ko nʼemiigu ebiri jira. ");
INSERT INTO nuj_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Oŋambe Alooni nʼabasaani babe obaŋire hu mulyango gwʼEweema eyʼOhwagananirangamo ohole omukolo ogwʼohubagwalaasa nʼamaaji. ");
INSERT INTO nuj_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Oŋambe Alooni omwambase ekaaso nʼeganduula nʼefodi nʼehyomu hifuba ko nʼomusibiro. ");
INSERT INTO nuj_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Era omusidihe ehitambala hu mutwe ohene oterese engule enjawufu bulaŋi hu hitambala ehyo. ");
INSERT INTO nuj_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Oŋambe amafuta omujuhe hu mutwe ohumwawula. ");
INSERT INTO nuj_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Era oŋambe abasaani babe obambase ekaaso, ");
INSERT INTO nuj_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","nʼebyohu mitwe. Era osidihe Alooni nʼabasaani emisibiro. Egambi lino eriŋamba hu byʼobusengi, lija huba lyʼemirembe nʼemirembe eyiri Alooni nʼolusaaye lulwe. ");
INSERT INTO nuj_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Ohene oŋambe ebunwa oyiŋire mu moni wʼEweema yʼOhwagananirangamo, Alooni nʼabasaani bayiteho emihono jaawe hu mutwe. ");
INSERT INTO nuj_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Oluvanyuma oyisalire mu moni ja Musengwa, ŋa mulyango gwʼEweema eyʼOhwagananirangamo. ");
INSERT INTO nuj_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Oŋambanga amalasire waŋaha hu meega gʼehituuti nʼotambisa olwala, ngʼagasigaaye ogajuha hu musingi gwʼehituuti. ");
INSERT INTO nuj_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ngʼaŋo oŋamba amasavu gosigosi agohu byenda nʼagohu hini nʼagohu sigosigo jombi, ngʼobyohyera hu hituuti. ");
INSERT INTO nuj_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Aye wohyeranga enyama eyo nʼehyanjo ko nʼebyomuhida ebulafu wʼekambi. Eyo ŋongo eyi baŋaayo ohusoniŋa ebibi. ");
INSERT INTO nuj_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Oŋambanga emiigu ndala hu ebiri jira, ngʼAlooni nʼabasaani bayitaho emihono jaawe hu mutwe. ");
INSERT INTO nuj_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Ohene oyisale olegehe amalasire ogaŋwanyuse hu njuyi josijosi ejʼehituuti. ");
INSERT INTO nuj_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ehyo ni hiŋooye, otematemanga mu nyama eyo ebitundutundu, nga woosa ebyomuhida nʼamagulu ohena obita ŋalala nʼomutwe nʼebitundu ebindi. ");
INSERT INTO nuj_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Nga wohya emiigu eyo yosiyosi ehwiye hu hituuti. Eyo ŋongo eyi bohya yaguhuuliha hu lwange Musengwa era ahaloosa aho hasangaasa, hirabo hya Musengwa ehibohya. ");
INSERT INTO nuj_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Ŋamba emiigu eyohubiri, Alooni nʼabasaani babe bayiteho emihono jaawe hu mutwe. ");
INSERT INTO nuj_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ohene oyisale, oŋambe amalasire ogaŋahe hu hutwi ohulungi ohwʼAlooni nohu matwi agohu muhono omulungi agʼabasaani babe, oŋahe nohu njala embala ejohu mihono emirungi, nohu njala embala ejohu magulu agohu muhono omulungi. Nʼohenire, osaasale hu njuyi josijosi ejʼehituuti. ");
INSERT INTO nuj_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ngʼaŋo oŋamba nohu malasire agali hu hituuti nʼamafuta agohwawula ogaŋwanyuse hwʼAlooni nohu basaani nʼebyambalo byawe. Ehyo ni hiŋwa, oliba ohenire ohufuula Alooni nʼabasaani babe ko nʼebyambalo byawe, byawufu. ");
INSERT INTO nuj_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Oŋambanga amasavu agʼemiigu eyo, amasavu agʼomuhira nʼamasavu hu byenda, ehini nʼesigosigo jombi nʼamasavu gawaho nʼehiŋinga ehyohu luuyi olwʼomuhono omulungi. Eyo njʼetaama eyohuŋongayo ohwawula abasengi. ");
INSERT INTO nuj_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Oja hubgula omugaati oguŋumamo ehisimbulusa ohuŋwa mu hisero ehiri mu moni ja Musengwa, ni keeki eyi batabuyemo nʼamafuta nʼahagaati halala ahabaŋahaho amafuta. ");
INSERT INTO nuj_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Era oliŋambya Alooni nʼabasaani omugaati ko nʼenyama eyʼemiigu eyo, ngʼaŋo babiŋuuba mu moni jange. ");
INSERT INTO nuj_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ni bahenire, olibinaaŋa ngʼobyohyera hu hituuti ŋalala nʼebirabo ebi bohya ni biri bihwiiye, ahaloosa aho hasangaasa, hirabo hya Musengwa ehibohya. ");
INSERT INTO nuj_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Oliŋamba ehifuba hyʼetaama emiigu eyʼomukolo ogwʼohwawula Alooni, ngʼohiŋuuba nʼohiŋongayo mu moni jange eyi ndi, ehyo njʼehiriba omugabo gugwo. ");
INSERT INTO nuj_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Mu hwawula omusengi, ehifuba nʼehiŋinga ebyʼemiigu eyo banabiŋengayo eyi ndi ni babiŋuuba, ni bahenire nga babiginga babiŋambya abasengi ohuba omugabo gwawe. ");
INSERT INTO nuj_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Emirembe nʼemirembe, ogwo guli nʼohuba mugabo gwʼabasengi ohuŋwa mu Bayisirayiri ni baŋayo eŋongo eyohuleetaŋo emiyaaya, ehifuba nʼehisambi binabenga byʼabasengi. Era ehyo njʼehinabenga ehirabo hyange ohuŋwa eyiri Abayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Oluvanyuma lwʼAlooni ohufa, ebyambalo bibye ebyʼobusengi, biriba byʼabasaani abalimugobola mu magulu ngʼabasengi abahulu. Babambasanga ebyambalo ebyo ko babajuhaho amafuta ni babaawula. ");
INSERT INTO nuj_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Omusaani owomu lulyo lulwe amusikira ngʼomusengi, gengiranga mu Weema eyʼOhwagananirangamo ohuŋeeresa mu Hifo Ehyawufu, gambalanga ebyambalo ebyo ohuhena endaalo musanvu. ");
INSERT INTO nuj_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Oŋambanga enyama yʼemiigu eyʼomukolo ogwʼohwawula, ngʼoyinyiiyira mu hifo ehyawufu. ");
INSERT INTO nuj_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Alooni nʼabasaani babe baliriira enyama ko nʼemigaati jira mu hisero hira, ŋa mulyango gwʼEweema yʼOhwagananirangamo. ");
INSERT INTO nuj_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Abasengi boŋene njʼabali nʼohulya enyama nʼemigaati ejo eji baŋongire olwʼohusoniŋiwa ebibi ni babawula, olwohuba byawufu. ");
INSERT INTO nuj_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Era singa ŋabaaŋo enyama oba emigaati ejisigayeho ohwola mu mugamba, ŋaŋumeŋo obirya aye obyohyanga hubyohya byaguhuliha olwohuba byawufu. ");
INSERT INTO nuj_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Ebyo ebi kulomire, njʼebi oli nʼohuhola ohwawula Alooni nʼabasaani era omukolo ogwʼohwawula guli nʼohuhena endaalo musanvu. ");
INSERT INTO nuj_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Hiisi ludaalo oŋangayo ebunwa yibe eŋongo eyʼohusoniŋa ebibi. Gwalaasa ehituuti nʼohiŋaha amafuta ohuhyawula ohuba hyawufu. ");
INSERT INTO nuj_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Olihena endaalo musanvu nʼogwalaasa ehituuti nga hifuuha hyawufu bugali. Era hiisi ahiŋambaho oba ehiitu hyosihyosi ehi hyehonyaho, hinabenga hyawufu. ");
INSERT INTO nuj_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Era hiisi ludaalo onaŋengayo hu hituuti etaama ebiri epere ejihenire omwaha mulala. ");
INSERT INTO nuj_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Oŋongangayo ndala mu mugamba, eyindi ehyegulo. ");
INSERT INTO nuj_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Etaama esooka oyiŋongangayo ŋalala nʼekilo ndala eyʼobusyanu owʼengaano obunohi era obubatawuyemo erita ndala eyʼamafuta amalaŋi agʼemizayiti. Ojuhanga erita ndala eyʼomwenge ogwʼemizabbibbu ngʼeŋongo. ");
INSERT INTO nuj_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Etaama epere eyindi, oyiŋonganga ehyegulo ŋalala nʼobusyanu owʼengaano nʼehinywewa ngʼolu oba nʼoholire mu mugamba, obite hu muliro ohuŋwamo ahaloosa ahalaŋi eyiri Musengwa. ");
INSERT INTO nuj_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Emirembe nʼemirembe, eŋongo eryo eri bohya lyaguhuliha, baja huliŋangayo hiisi ludaalo mu moni jange ŋa mulyango gwʼEweema eyʼOhwagananirangamo. Aŋo paŋa nja hubagaananga naloma ni nenywe. ");
INSERT INTO nuj_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Era aŋo paŋa nja hwagananiranga nʼAbayisirayiri, ngʼeŋono lyange ligwalaasa ehifo ehyo. ");
INSERT INTO nuj_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Nja hugwalaasa Eweema eyʼOhwagananirangamo, ngwalaase nʼehituuti ehyohuŋeeraho eŋongo. Era nja hugwalaasa Alooni nʼabasaani babe bapeeresenga ngʼabasengi. ");
INSERT INTO nuj_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Nja huba mu Bayisirayiri era nja huba Hatonda waawe. ");
INSERT INTO nuj_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Era baja humanya baati ndiise Musengwa Hatonda waawe, owabatusa mu gwanga lyʼe Misiri ohubanga mu bo. Ndiise Musengwa Hatonda waawe.” ");
INSERT INTO nuj_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Ngʼaŋo Musengwa aloma Musa ati, “Oja hubbota ehituuti ehyʼohudunyisangaho obubbaani. Oja huhihola mu mbaawo ejʼomuŋwa omuhosa. ");
INSERT INTO nuj_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Era hija huŋeraŋerana enjuyi nʼenjuyi; obuleeŋi hija huba efuuti ndala nʼehitundu nʼobugalamu woosi efuuti ndala nʼehitundu, obuleeŋi ŋamugulu hija huba efuuti edatu. Ameega gaahyo galiba gembaawo ejomu musaala njʼomwene ogwo ogwʼakasiya. ");
INSERT INTO nuj_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Olihimaalaho hu mugulu nʼezaabbu enyene nʼenyene, enjuyi nʼenjuyi ko nohu meega, oteho nʼomugo ogwʼezaabbu ohuyeswanigirisa. ");
INSERT INTO nuj_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Oja hubbota emihobyo ejʼezaabbu ebiri ebiri hu luuyi nʼoluuyi ngʼohena ojita ŋaasi wʼomugo ohuŋamba emirabba ejʼohuyeedanga mu hugega. ");
INSERT INTO nuj_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Emirabba jija huba jʼomuŋwa omuhosa era ojimaaleho nʼezaabbu. ");
INSERT INTO nuj_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Oja huta ehituuti ehyo ehyʼohudunyisangaho obubbaani mu moni wʼolutimbe olwawula Ehifo Ehyawufu nʼEhifo Ehyawufu Obugali omuli Esanduuku yʼEndagaano. Hu Sanduuku ohwo, pohu nja hwagananiranga ni neewe. ");
INSERT INTO nuj_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Era hiisi mu mugamba, Alooni aja hutiinanga ohulongoosa etaala, ngʼaniokehesa obubbaani hu hituuti ehyo. ");
INSERT INTO nuj_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Era anaŋambyenga etaala ehyegulo ganiokesa obubbaani mu moni ja Musengwa emirembe nʼemirembe. ");
INSERT INTO nuj_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Otaniokesanga obubbaani obubagaana oba ohuŋeeraho ebirabo ebi bohya bihwiye byaguguliha, oba eŋongo eyʼembehe eyʼebirime, wayire eŋongo eyʼehinywewa. ");
INSERT INTO nuj_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Alooni anaholenga omukolo ogwʼohugwalaasa ehituuti ehyo omulundi mulala mu mwaha. Anaŋambenga amafugi gʼebyayo ebibasalire olwʼohusoniŋa ebibi ngʼagaŋaha hu meega lulala mu mwaha emirembe nʼemirembe. Ehituuti ehyo hyawufu bugali eyiri Musengwa.” ");
INSERT INTO nuj_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Nga Musengwa aloma Musa ati, ");
INSERT INTO nuj_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Nʼobala Abayisirayiri ohumanya obungi waawe, hiisi muutu anaŋenga Musengwa ebbeesa olwʼohwenda ohuŋonia obulamu wuwe ko haŋupuli atabalumba nʼobabala. ");
INSERT INTO nuj_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Era hiisi oyu banahenenga ohubala, anabugulenga hirala hyahubiri ehya sekelo, omuŋendo ogu baagereha ohusasulanga mu Hifo Ehyawufu. Era ebbeesa ejo jinabenga hirabo ehi aŋayeyo eyiri Musengwa. ");
INSERT INTO nuj_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Hiisi aŋesa emyaha amahumi abiri ohutiina mu moni, ni banahenenga ohumubala, aja huŋanga Musengwa ehirabo. ");
INSERT INTO nuj_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Omuŋinda saaja hubugulanga ehisingaho aŋo era nʼomugadi yeesi saaja hubugulanga ejitaŋera hitundu ehya sekelo, ni baŋayo ebbeesa ejo olwʼohubasoniŋa. ");
INSERT INTO nuj_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Oja husoloosa ebbeesa mu Bayisirayiri olwʼohubasoniŋa ebibi, ohene ojitambise hu mirimo ejohu wʼEweema eyʼOhwagananirangamo. Baja husasula ebbeesa ejo, nja huhuuma obulamu waawe.” ");
INSERT INTO nuj_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Ngʼaŋo Musengwa geyongera aloma Musa ati, ");
INSERT INTO nuj_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Olihola ebbaafu eyʼehihomo nʼehihondo hyayo ehyʼehihomo, abaatu ohusaabirangamo. Oja huyitengeha ŋagati wʼehituuti nʼEweema eyʼOhwagananirangamo era ohene ojuhemo amaaji. ");
INSERT INTO nuj_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Alooni nʼabasaani babe banasaabirengamo engalo nʼamagulu. ");
INSERT INTO nuj_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Ni banabenga ni batiina mu moni ja Musengwa mu Weema eyʼOhwagananirangamo, oba ni batiina hu hituuti ohuŋeeresa, ohwohya eŋongo yaguguliha, banasaabenga amaaji ago ko hitabaleetera hufa. ");
INSERT INTO nuj_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Banasaabenga engalo nʼamagulu gaawe ko hitabaleetera hufa. Ehyo hiragiro eyiri Alooni nʼabasaani ko nʼabejuhulu baawe emirembe nʼemirembe.” ");
INSERT INTO nuj_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Nga Musengwa aloma Musa ati, ");
INSERT INTO nuj_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Ŋamba ebyahaloosa ebihirira erala obulaŋi, ekilo mukaaga eja miira owʼamaaji nʼekilo edatu eja kinamooni aŋunya obulaŋi, nʼekilo edatu eja kaani. ");
INSERT INTO nuj_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Era oja huŋamba nʼekilo mukaaga eja kasiya, mu bipimo ebitongole ebyomu Hifo Ehyawufu, nʼelita ene ejʼamafuta agomu mizayiti, ");
INSERT INTO nuj_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","obiholemo amafuta amawufu agʼohutambisanga mu hwawula. Amafuta ago baja hugatabulamo ebyahaloosa mu kola eyʼehikugu. Era gaja hufuuha mawufu. ");
INSERT INTO nuj_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Oja huŋamba amafuta ago oŋahe hu Weema eyʼOhwagananirangamo ko nohu Sanduuku yʼEndagaano, ");
INSERT INTO nuj_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","nohu meeza, nohu biitu byayo byosibyosi, nohu hihondo hyʼetaala, nohu biitu byahyo, nohu hituuti hyʼobubbaani, ");
INSERT INTO nuj_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","nohu ehituuti ehyohwohyerangaho eŋongo, nohu biitu ebitiiniraho byosibyosi, nohu bbaafu, nʼehihondo hyayo. ");
INSERT INTO nuj_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Oja hugwalaasa ebiitu ebyo ohubifuula byawufu bugali era hiisi ehi bihonyaho, hinabenga higwalaafu. ");
INSERT INTO nuj_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Oja hujuha hu Alooni nʼabasaani babe amafuta, obawule bapeeresenga ngʼabasengi. ");
INSERT INTO nuj_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ohene olomere Abayisirayiri oti, ‘Amafuta gange gano agohwawula, gaja huba mawufu emirembe nʼemirembe. ");
INSERT INTO nuj_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Sibagajuhanga hu muutu owabulijo era simuholanga mafuta agandi agali hyanigo. Nigo mawufu era mugaŋirenga muuti mawufu. ");
INSERT INTO nuj_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Era hiisi alitabula amafuta agandi agagafaanana, oba hiisi aligatambisa hu muutu atasaana, aliba sibahimubala ohuba mulala hu baatu bange.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Ngʼaŋo Musengwa aloma Musa ati, “Ŋamba ebyahaloosa bino: sitakite nʼonika ni galibbanumu ŋalala nʼobubbaani obulaŋi, byosibyosi ni biŋeraŋerana obusito, ");
INSERT INTO nuj_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","obiholemo obubbaani ngʼolu muhugu mu hutabula ebyahaloosa, atabulamo. Era olitabulamo cumbi, ohuhihuuma ni hiri hirongoofu era hyawufu. ");
INSERT INTO nuj_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Oja hutusaho ehitundu waŋuula wafuuhira erala wunohi, ngʼotaho obundi mu Weema eyʼOhwagananirangamo, mu moni wʼe Sanduuku yʼEndagaano aŋa nja hwagananira ni neewe. Hija huba hyawufu bugali eyi muli. ");
INSERT INTO nuj_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Simutabulanga obubbaani mu ngeri njʼenyene ohutambisa hu biitu ebindi. Eyiri ewe, hija huba hyawufu olwa Musengwa. ");
INSERT INTO nuj_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Era hiisi aja huhitabula mu ngeri njʼenyene, aliba sibahimubala ohuba mulala hu baatu bange.” ");
INSERT INTO nuj_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Ngʼaŋo Musengwa aloma Musa ati, ");
INSERT INTO nuj_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Tobooye Bbezaleeri omusaani wa Wuuli era omwijuhulu wa Huuri owomu hiha hya Yuda. ");
INSERT INTO nuj_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Mwijuhiise Omwoyo wange, muŋaaye amagesi nʼohutegeera nʼohumanya ohwehikugu ohuhola emirimo eja hiisi ngeri. ");
INSERT INTO nuj_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Muŋaaye obuhugu ohutetekania amajolobera mu zaabbu nomu feeza nomu hihomo, ");
INSERT INTO nuj_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","nomu husala amabaale agʼebbeeyi nʼembaawo era nʼohuhola emirimo eja hiisi ngeri. ");
INSERT INTO nuj_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Era tobooye nʼOholiyaabbu omusaani wʼAhisamaki owomu hiha hya Daani. Nʼabasinde abandi boosi mbaŋaaye obusobozi ohuhola byosibyosi ebi kulagiiye: ");
INSERT INTO nuj_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Eweema eyʼOhwagananirangamo nʼEsanduuku yʼEndagaano nʼehisembo hyowaho ko nʼebiitu byosibyosi ebyomu Weema. ");
INSERT INTO nuj_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Muŋaaye obusobozi ohubbota emeeza nʼebitiiniraho, ehihondo hyʼetaala ehyʼezaabbu enyene nʼenyene nʼebitiiniraho byosibyosi ko nʼehituuti ehyohudunyihisaho obubbaani, ");
INSERT INTO nuj_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","nʼehituuti ehyohwohyerangaho eŋongo ko nʼebitiiniraho byosibyosi ko nʼebbaafu nʼehihondo hyayo. ");
INSERT INTO nuj_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Batunge ebyambalo mu ngeri eyʼehikugu era ebyawufu ebyʼAlooni nʼabasaani babe, ohwambala ni baŋeeresa ngʼabasengi, ");
INSERT INTO nuj_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","amafuta ogohuŋaha ko nʼobubbaani obuŋunya ahaloosa, ebyomu Hifo Ehyawufu. Baja huhola ebiitu byosibyosi ngʼolu kulagiiye.” ");
INSERT INTO nuj_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Ngʼaŋo Musengwa aloma Musa ati, ");
INSERT INTO nuj_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Loma Abayisirayiri oti, ‘Muhuumanga oludaalo lwa Sabbaato ndimulutambiraho emirimo olwohuba njʼahabonero ahali ŋagati wange ni nenywe emirembe nʼemirembe, ohubalaga ti ndiise Musengwa abafuula ohuba bagwalaafu. ");
INSERT INTO nuj_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Muhuumanga oludaalo lwa Sabbaato ni luli lwawufu olwohuba lwahuŋuumuliraho. Era hiisi ataluhusenga, galuholeraho emirimo, ateehwa hufa, sibaja humubala huba mulala hu baatu bange. ");
INSERT INTO nuj_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Muli nʼendaalo mukaaga ejʼohutambiraho emirimo aye oludaalo olwomusanvu lwa huŋuumula, lwawufu eyiri Musengwa. Era hiisi ahola omulimo gwosigwosi hu ludaalo olwa Sabbaato, bamwitanga. ");
INSERT INTO nuj_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Olwʼehyo, Abayisirayiri bali nʼohuhusanga oludaalo lwa Sabbaato emirembe nʼemirembe ohulaga baati bahuuma endagaano. ");
INSERT INTO nuj_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Hiri hiityo olwohuba njʼahabonero ahali ŋagati wange nʼAbayisirayiri ahʼemirembe nʼemirembe ti Musengwa gatonda egulu nʼehyalo mu ndaalo mukaaga, nga hu ludaalo olwomusanvu, aŋuumula.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Hatonda ni gahena ohuloma ni Musa hu lusozi Sinaayi, ngʼamuŋa ebipande bibiri ebyʼamabaale, ebi omwene gaŋandiihaho nʼolwala lulwe. ");
INSERT INTO nuj_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Olwola, abaatu ni baabona Musa nʼaluyeyo hu lusozi, behumbaania aŋʼAlooni gaali, nga bamuloma baati, “Sihumanyire ehyolire hu Musa, owatutusa mu hyalo hyʼe Misiri. Olwʼehyo, tuholereeyo abahatonda abanatutangirirenga.” ");
INSERT INTO nuj_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ngʼehyo hireetera Alooni ohubaloma ati, “Mutuse epeta ejʼezaabbu ejiri hu matwi gʼabahasi benywe nʼabaana benywe abaseere nʼabahaana, mujindetere.” ");
INSERT INTO nuj_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ngʼabaatu bosibosi betusamo epeta jaawe ejʼezaabbu ejaali hu matwi gaawe, bajiŋirira Alooni. ");
INSERT INTO nuj_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Nga Alooni anaaŋa ezaabbu ejo ahena ajisanuusa, awumbamo enyana yʼeŋombe. Ngʼaŋo abaatu baloma baati, “Yisirayiri, bano njʼabahatonda abahutusa mu hyalo hyʼe Misiri.” ");
INSERT INTO nuj_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Alooni ni gabona ebyo, gatongola ehituuti mu moni wʼehiwumbe ehyo, ngʼahena alangirira ati, “Olwejo, mu mugamba ŋaja hubaaŋo embaga ya Musengwa.” ");
INSERT INTO nuj_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ni wahya, mu mugamba pwipwipwi abaatu benyoha baŋayo eŋongo eri bohya kwiye yaguguliha nʼeryohutabagana. Ngʼabaatu beehala balya, banywa era benyoha ohuhina mu ngeri eyʼobuŋemu. ");
INSERT INTO nuj_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ngʼaŋo Musengwa aloma Musa ati, “Teremuha ogoboleyo, olwohuba abaatu babo aba watusa mu hyalo hyʼe Misiri, babbengire. ");
INSERT INTO nuj_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Mangu mangu baŋooye hale hu ngira eyi nabalagira ohugenderangamo. Babbotire enyana yʼeŋombe ohuŋwa mu zaabbu era nga bahena bayijumirya, bayiŋa nʼeŋongo baloma baati, ‘Yisirayiri, bano njʼabahatonda aba hutusa mu hyalo hyʼe Misiri.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Nga Musengwa aloma Musa ati, “Abaatu bano mbaweene bʼemyoyo mihahanyafu. ");
INSERT INTO nuj_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Olwʼehyo, ndehe mbahenereho obusungu wange, mbasihiirise. Aye ndihufuula ewe egwanga ebbala.” ");
INSERT INTO nuj_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Aye Musa gegayirira Musengwa Hatonda wuwe ati, “O Musengwa, lwahiina wenda ohenere obusungu buwo hu baatu babo aba watusa mu hyalo hyʼe Misiri nʼotambisa amaani amangi nʼobuŋangi? ");
INSERT INTO nuj_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Lwahiina wenda Abamisiri balome baati, ‘Watusa abaatu babo e Misiri nʼehigendererwa hyʼohubetira mu sozi, ohubasihiirihisa erala ohuŋwa hu hyalo?’ Kusunga wehubbe mu hifuba, otoosa habi hu baatu babo. ");
INSERT INTO nuj_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Hebulira Yibbulayimu ni Yisaka ni Yakobbo abaŋeeresa babo, aba ewe wamwene werayirira waloma oti, ‘Ndifuula abejuhulu benywe duuli hyʼemunyeenye hwigulu era nja hubaŋa ehyalo hino hyosihyosi ehi nasuubisa ohuba hyawe emirembe nʼemirembe!’ ” ");
INSERT INTO nuj_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ngʼaŋo Musengwa gehubba mu hifuba, ndaleeta ndibo hu baatu babe ngʼolu gaali nʼalomire. ");
INSERT INTO nuj_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Nga Musa ateremuha ohuŋwa hu lusozi nʼaŋambire mu ngalo jije ebipande bibiri ebyʼamabaale, ebi baŋandiihaho hu njuyi jombi, mu moni nʼegongo. ");
INSERT INTO nuj_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Hatonda omwene njʼowahola ebipande ebyo ebyʼamabaale era njʼowabiŋandiihaho. ");
INSERT INTO nuj_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yoswa ni gaŋulira abaatu ni bahayaana, ngʼaloma Musa ati, “Pulira abaatu mu kambi oti hani basoola.” ");
INSERT INTO nuj_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Aye Musa gamugobolamo ati, “Eryo sijanjaasi lyʼabahayaana olwʼobuŋangusi oba lyahulira olwʼohubawagala aye ejanjaasi eri pulira lyʼabaatu abemba.” ");
INSERT INTO nuj_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Musa ni gasembera ŋaapi nʼekambi, gaabona enyana yʼeŋombe nʼabaatu ni bahina, ehyo hyamusunguŋasa bugali gadanya ŋaasi ebipande byʼamabaale ebi gaali nʼaŋambire mu ngalo, mu materemuhiro gʼolusozi nga bibbwagijihamo. ");
INSERT INTO nuj_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ngʼaŋo aŋamba enyana yʼeŋombe eyo eyi baali ni babbotire mu zaabbu ngʼayisanuusa nʼomuliro, ngʼahena ayiŋuula yifuuha oti gohe, ngʼayitabula mu maaji, aŋagia Abayisirayiri ohuganywa. ");
INSERT INTO nuj_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ni gahena ngʼacuhira Alooni amuloma ati, “Abaatu bano baahuŋa hi, ko obaleetere ohuhola ehibi ehyola aŋo?” ");
INSERT INTO nuj_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","NgʼAlooni amugobolamo ati, “Musengwa yange, otanyiigira, omanyire oti abaatu bano bulijo baŋeega hu huhola bibi. ");
INSERT INTO nuj_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Bandoma baati, ‘Tuholere abahatonda abanatutangiriremo, olwohuba sihumanyire ehyolire hu Musa, owatutusa mu hyalo hyʼe Misiri.’ ");
INSERT INTO nuj_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Nga ese ko mbaloma ati, ‘Hiisi ali nʼezaabbu ayireete.’ Ni bayireeta, nayidanya mu muliro, nga muŋwamo enyana yʼeŋombe yino.” ");
INSERT INTO nuj_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa ni gabona Alooni naleteeye abaatu ohuŋaba baŋwa hu hituufu era ni bafuuhire njeho jababita eyiri abalabe baawe, ");
INSERT INTO nuj_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","nga Musa gemeerera ŋa mulyango gwʼekambi abaloma ati, “Hiisi ali hu luuyi lwa Musengwa gaaje ŋano.” NgʼAbaleevi bosibosi bahumbaanira aŋa gaali bamweswanigirisa. ");
INSERT INTO nuj_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ngʼabaloma ati, “Musengwa Hatonda wa Yisirayiri aloma ati, ‘Hiisi mulala hu enywe aŋambe epiima yiye abite mu kambi ohuŋwa hu mulyango ohwola hu mulyango ogundi, giite mugandawe nʼowemihago ni muliranwawe.’” ");
INSERT INTO nuj_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Era Abaleevi baahola ngʼolu Musa galagira, biita abaatu ngʼekumi edatu hu ludaalo olwo. ");
INSERT INTO nuj_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Nga Musa aloma Abaleevi ati, “Olwaleero babangaye ohuba baŋeeresa ba Musengwa olwʼohwita abaana benywe nʼabaganda benywe era Musengwa abaŋaaye ekabi.” ");
INSERT INTO nuj_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Oludaalo olwalondaho nga Musa aloma abaatu ati, “Mwaholire ehibi hibbala bugali! Leha tiine eyiri Musengwa nindi oba oli aŋo gabasoniŋa.” ");
INSERT INTO nuj_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ngʼaŋo Musa agobolayo eyiri Musengwa amuloma ati, “Abaatu bano baahola hibi nyo, babbotire abahatonda mu zaabbu! ");
INSERT INTO nuj_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Olwʼehyo kwegayirira, obasoniŋe. Aye nʼotabasoniŋe, sanguule mu hitabo hihyo.” ");
INSERT INTO nuj_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Aye Musengwa galoma Musa ati, “Hiisi aholire ehibi, namusangule mu hitabo hyange. ");
INSERT INTO nuj_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ŋaahani tiina, oŋire abaatu mu hifo ehi nahuloma. Malayika wange anahutangirirenga. Aye ehiseera hija ohwola mbonerese abaatu abo olwʼehibi hyawe.” ");
INSERT INTO nuj_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Era Musengwa gabaŋindihira haŋupuli olwohuba bajumirya enyana yʼeŋombe eyi Alooni gababbotera. ");
INSERT INTO nuj_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Ngʼaŋo Musengwa aloma Musa ati, “Ewe nʼabaatu babo abawatusa mu hyalo hyʼe Misiri, muŋwe mu hifo hino, mutiine mu hyalo ehi nalayirira Yibbulayimu ni Yisaka ko ni Yakobbo ti, ‘Nja huhiŋa abejuhulu babo.’ ");
INSERT INTO nuj_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Nja huloma malayika ahutangiriremo era nja hubbingamo Abakanani nʼAbamooli nʼAbahiiti nʼAbapereezi nʼAbahiivi ko nʼAbayebbusi. ");
INSERT INTO nuj_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Mutiine mu hyalo ehituluha amabeere nʼomudugere. Aye ese sinja hutiina ni nenywe olwohuba muli nʼemyoyo mihahanyafu, sobola nabasihiirihisa hu ngira.” ");
INSERT INTO nuj_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Abaatu ni baŋulira ebibono ebyo banakuŋala era sibambala nʼemihomyo. ");
INSERT INTO nuj_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Sibambala olwohuba Musengwa gaali alomire Musa ati, “Loma Abayisirayiri oti, ‘Muli nʼemyoyo mihahanyafu. Era singa hutiina ni nenywe wayire ahaseera hadiidiri, nja hubahenaŋo. Olwʼehyo, mweyambulemo emihomyo, ko mbone ehi nabaholere.’ ” ");
INSERT INTO nuj_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Olwʼehyo, ohuŋwa hu lusozi Horebbu ohutiina mu moni, Abayisirayiri baalehera aŋo ohwambala emihomyo. ");
INSERT INTO nuj_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Musa gaŋiranga eweema gayemeha ebulafu wʼekambi ni ŋaliŋo ahanaaŋiro, ngʼayiranga ati “eweema yʼohwagananirangamo.” Era hiisi owendanga ohwebuusaho hu Musengwa, gatiinanga mu weema eyaali ebulafu wʼekambi. ");
INSERT INTO nuj_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Hiisi olu Musa gatulanga ebulafu wʼekambi gatiina mu weema yʼohwagananirangamo, hiisi muutu genyohanga gemeerera ŋa mulyango gwʼeweema yiye gamulengerera ohwola olu Musa gahengiiye. ");
INSERT INTO nuj_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Musa ni gengiranga mu weema, ngʼehireri ehyali oti hani siiro hitiina hiiha ŋa mulyango gwʼeweema eyo, nga Musengwa aloma ni naye. ");
INSERT INTO nuj_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Abaatu ni babonanga ehireri ehyali oti hani siiro ni hiwihire ŋa mulyango gwʼeweema yʼohwagananirangamo, nga hiisi muutu ahubba amafuha ŋa mulyango gwʼeweema yiye, ajumirya Musengwa. ");
INSERT INTO nuj_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Musengwa galomanga ni Musa moni hu moni ngʼolu muutu aloma ni meriiwe. Musa ni gagamangayo mu kambi, omuloobera wuwe, Yoswa omusaani wa Nuuni, niye gasigalanga mu weema. ");
INSERT INTO nuj_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Ngʼaŋo Musa aloma Musengwa ati, “Wundoma oti tangirire abaatu bano mbaŋire mu hyalo ehisuubise aye sibundomera oyu nja hutiina ni naye. Ate waloma oti wumanyire bulaŋi era osiima ebi kola. ");
INSERT INTO nuj_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Kale ehyo ni hiba ni hiri hituufu, somese etegeha yiyo naheyongera ohuhumanya nʼohuhusangaasanga. Era oterabira oti watobola egwanga lino ohuba baatu babo.” ");
INSERT INTO nuj_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Nga Musengwa amugobolamo ati, “Nja hutiina ni neewe mu lugendo luno era nja huhuŋa ehiŋuumulo.” ");
INSERT INTO nuj_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Nga Musa amugobolamo ati, “Singa sootiina ni neefe, otatuleha huŋwa ŋano. ");
INSERT INTO nuj_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Hiri hiityo olwohuba nʼotatiina ni neefe, abaatu balimanyira hu hi baati ese kwesiimisa, ese nʼabaatu babo? Ehija ohuleetaŋo enjabulo ŋagati weefe nʼabaatu abandi bosibosi hu hyalo, sihutiina ni neefe?” ");
INSERT INTO nuj_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ngʼaŋo Musengwa aloma Musa ati, “Nja huhola ngʼolu busungire, olwohuba kumanyire bulaŋi era wunesiimisa.” ");
INSERT INTO nuj_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Nga Musa amuloma ati, “Kusunga wundage eŋono liryo.” ");
INSERT INTO nuj_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Nga Musengwa amugobolamo ati, “Nja huhutangiramo obone hu bulaŋi wange era nja hulangirira esiina lyange ti, ‘Musengwa.’ Nja huŋambira ehisasabirisi oyo oyu nja huŋambira ehisasabirisi era nja husaasira oyo oyu nja husaasira.” ");
INSERT INTO nuj_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ne geyongera gamuloma ati, “Soosobola humbona moni hu moni olwohuba ŋaŋuma owumbona gasigala nʼahiiri mulamu.” ");
INSERT INTO nuj_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Nga Musengwa aloma ati, “Ŋaliŋo aŋaatu ohuupi ni nange aŋa oja hwemeerere hu baale. ");
INSERT INTO nuj_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Era ni naabe ni mbitaŋo mu ŋono lyange, nahute mwiroŋo mwibaale, nahuwiiheho ehyaba hyange, ohwola olu nahene ohubitaŋo. ");
INSERT INTO nuj_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Oluvanyuma natuseŋo ehyaba hyange, obone omugongo gwange. Aye sooja humbona mu weeni.” ");
INSERT INTO nuj_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ngʼaŋo Musengwa aloma Musa ati, “Tiina obaaje ebipande bibiri ebyʼamabaale, ebiri hyʼebidaayi ebi wabbwanga, nja huŋandiihaho ebibono ebyene bira ebi naali ni pandiihire oludaayi. ");
INSERT INTO nuj_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Wetegehe mu mugamba olwejo oniine hu lusozi Sinaayi aŋa ndi ŋamugulu wʼolusozi. ");
INSERT INTO nuj_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Sibuujanga nʼomuutu wayire mulala era ŋataba muutu yesiyesi asembera ohuupi nʼolusozi, ŋaŋume taama oba eŋombe eyaayira ŋaapi nʼolusozi luno.” ");
INSERT INTO nuj_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Olwʼehyo, Musa gabaaja ebipande bibiri ebyʼamabaale hyʼebidaayi. Era ni wahya mu mugamba, gaŋamba ebipande ebyo ganiina ni nabyo hu lusozi Sinaayi ngʼolu Musengwa gamulagira. ");
INSERT INTO nuj_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ngʼaŋo Musengwa geehira mu hireri, gemeerera ni naye era ngʼalangirira esiina lirye ati, “Musengwa.” ");
INSERT INTO nuj_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Musengwa gabita era ngʼalangirira esiina lirye ati, “Ndiise Musengwa, Musengwa Hatonda ali nʼehisa nʼehisasabirisi, alwaŋo ohuluŋa, ali nʼohwenda ohubitiirifu era omwesigwa. ");
INSERT INTO nuj_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Era genda abaatu aba hiisi mulembe era asoniŋa ebibi nʼohwonoona ko nʼobujeemu waawe. Aye aboneresa abo abahola ebibi nʼatagihira hu abaana baawe nʼabejuhulu, ohwola hu hijuhulu ehyohudatu nʼehyohune olwʼebibi byʼabasaaye baawe.” ");
INSERT INTO nuj_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Ngʼaŋo Musa ahubba amafuha ajumirya Musengwa ati, ");
INSERT INTO nuj_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“O Musengwa, nimba ni kwesiimisa, kwegayiriiye otiine ni neefe. Wayire abaatu bano bʼemyoyo mihahanyafu aye tusoniŋe ebibi nʼohwonoona hwefe era otufugiirire ohuba baatu babo.” ");
INSERT INTO nuj_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ngʼaŋo Musengwa aloma Musa ati, “Ŋaahani kola endagaano nʼAbayisirayiri. Nja huhola ebyeŋunjisa bingi bugali ebitabangaŋo ŋaatu ŋosiŋosi hu hyalo. Era ewe nʼabaatu babo bosibosi baja hubona ebyamaliholiho, beŋunje. ");
INSERT INTO nuj_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Muhuumanga ebiragiro ebi mbaŋa olwa leero. Nja hubbinga Abamooli nʼAbakanani nʼAbahiiti nʼAbapereezi nʼAbahiivi ko nʼAbayebbusi. ");
INSERT INTO nuj_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Mwehuumanga ohutahola ndagaano nʼabaatu abali mu hyalo ehyo ehi muja ohusikira. Hiri hiityo olwohuba ni muli hihola, muja huŋamba esambo jaawe embi mubbaame. ");
INSERT INTO nuj_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Aye muli nʼohubbwagabbwaga ebituuti byawe ebyohuŋeeraho eŋongo, mubbwagebbwage amabaale gaawe era mutemateme nʼepaango jʼAsera hatonda waawe. ");
INSERT INTO nuj_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Simujumiryanga bahatonda abandi, olwohuba ese Musengwa ndi Hatonda owewuba. ");
INSERT INTO nuj_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Mwehuumanga ohutahola ndagaano nʼabaatu abali mu hyalo ehyo, ni bahola obuhwedi era ni baŋa abahatonda baawe eŋongo, baja hubalanga ohuyiryaho. ");
INSERT INTO nuj_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Era mutahanda mwahwera abasaani benywe abahaana baawe olwohuba bajumirya abahatonda baawe, ehyo hija huleetera abasaani benywe ohuhola cʼehyene. ");
INSERT INTO nuj_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Simwebboteranga hifaananyi hyʼehiitu hyosihyosi mu hyoma ehi basanuhiise ohuba Hatonda. ");
INSERT INTO nuj_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Muhuumanga Embaga eyʼEmigaati eji batatayemo Ehisimbulusa. Era endaalo musanvu mu mwesi gwʼAbbibbu, mulyanga Emigaati Ejiŋumamo Ehisimbulusa ngʼolu nabalagira, muholanga muutyo olwohuba omwesi ogwo jogumwaŋweramo e Misiri. ");
INSERT INTO nuj_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Hiisi mwana omuseere omudaayi anaabenga wange era hiisi hyayo ehisinde ehidaayi hinabenga hyange. ");
INSERT INTO nuj_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Muŋangayo enyana yʼetaama ohununula enyana ya nasugirya endaayi. Ni munaabenga ni mutenda huyinunula, munayibbwagenga egosi. Hiisi mwana omuseere omudaayi, munamununulenga. Era siŋabagaŋo omuutu obuuja mu moni jange nʼengalo njereere. ");
INSERT INTO nuj_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Muli nʼendaalo mukaaga ejʼohutambirangamo emirimo aye muŋuumulanga hu ludaalo olwomusanvu. Muŋuumulanga mu biseera ebyʼerima nʼebyegesa. ");
INSERT INTO nuj_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Mulyanga Embaga eyʼAmakungula, ni muhunguuye ebibala ebidaayi ebyʼengaano era muholanga Embaga eyʼEbisiisira ni mubunga ebibala hu komerero yʼomwaha. ");
INSERT INTO nuj_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Emirundi edatu hiisi mwaha, abasinde bosibosi baja hutiinanga ohujumirya Musengwa Omwene Buŋangi, Hatonda wa Yisirayiri. ");
INSERT INTO nuj_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Nja hubbinga abʼamawanga agandi era nja hugalamya esalo jenywe, ŋaja huŋumaŋo alyegomba eroba lyenywe ni mulitiinanga ohujumirya Musengwa Hatonda wenywe, emirundi edatu mu mwaha. ");
INSERT INTO nuj_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Simuupanga mafugi gʼehyayo ehi muŋongire ŋalala nʼomugaati ogu bataayemo ehisimbulusa. Era simuleehanga ŋongo eyohu Mbaga yʼOhubihisya, siyiŋenyuhanga ohwola mu mugamba. ");
INSERT INTO nuj_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Ni muhungulanga ebibala ohuŋwa mu ndimiro jenywe, muŋambanga ebihirira erala obulaŋi mwaŋira mu nyumba ya Musengwa Hatonda wenywe. “Simunyiiyanga enyama eyʼenyana yʼembusi ni mutabuyemo amabeere.” ");
INSERT INTO nuj_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ngʼaŋo Musengwa aloma Musa ati, “Ŋandiiha ebibono bino, olwohuba mbebi nemireho ohuhola endagaano ni neewe ko nʼAbayisirayiri.” ");
INSERT INTO nuj_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa gamenya eyo ni Musengwa endaalo amahumi ane omuusi nʼowiire, sigalyaho hamere oba hunywaho haatu hosihosi. Era Musengwa gaŋandiiha Amagambi Ehumi hu bipande byʼamabaale. ");
INSERT INTO nuj_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Musa ni geeha ohuŋwa hu lusozi Sinaayi, nʼaŋambire ebipande bibiri ebyʼamabaale ebyaliho ebiragiro ehumi, sigamanya ati oweeni wuwe waali bumeregenya olwohuba gaali aŋwa huba ni Hatonda. ");
INSERT INTO nuj_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Alooni nʼAbayisirayiri bosibosi babona oweeni wa Musa ni bumeregenya, nga batya ohumusemberera. ");
INSERT INTO nuj_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Aye Musa gabalanga, nga Alooni nʼabatangirisi bosibosi abʼehibbubbu hyʼAbayisirayiri bagamayo batiina aŋa gaali, aloma ni nabo. ");
INSERT INTO nuj_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Oluvanyuma, Abayisirayiri bosibosi basembera aŋa gaali, ngʼabaŋa amagambi gosigosi aga Musengwa gamuŋeera hu lusozi Sinaayi. ");
INSERT INTO nuj_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Musa ni gahena ohuloma ni nabo, nga gewiiha mu moni. ");
INSERT INTO nuj_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Aye hiisi olu Musa gegiranga mu weema ohuloma ni Musengwa, galeeherangaŋo ohwewiihirira ohwola olu gatulanga ebulafu. Era ni gahatulire ebulafu, galomera Abayisirayiri bosibosi ebi Musengwa galagiranga. ");
INSERT INTO nuj_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Era Abayisirayiri babonanga oweeni wa Musa ni bumeregenya. Gewiihiriranga, ohwola olu gagamangayo ohuloma ni Musengwa. ");
INSERT INTO nuj_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Nga Musa alanga ehibbubbu hyʼAbayisirayiri hyosihyosi hihumbaana, ngʼabaloma ati, “Bino mbebi Musengwa abalagira ohuhola. ");
INSERT INTO nuj_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Muli nʼendaalo mukaaga ejʼohuholerangaho emirimo aye oludaalo olwomusanvu lwawufu era eyiri Musengwa lwa huŋuumula. Hiisi analuholerangaho emirimo, ali nʼohufa. ");
INSERT INTO nuj_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Simuŋambyanga muliro mu mago genywe hu ludaalo lwa Sabbaato.” ");
INSERT INTO nuj_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Nga Musa aloma ehibbubbu hyʼAbayisirayiri hyosihyosi ati, “Hino njʼehi Musengwa alagiiye. ");
INSERT INTO nuj_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Muleetere Musengwa ehirabo. Era hiisi ali nʼomwoyo omugabi aŋeyo ehirabo eyiri Musengwa. Aŋeyo ezaabbu nʼefeeza nʼehihomo, ");
INSERT INTO nuj_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","nʼengoye endaŋi eja laasi nʼeji bahola mu mooya gʼembusi nʼewuuzi eja bbululu neja namasyoma nʼenando, ");
INSERT INTO nuj_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","nʼebyanjo byʼemiigu ebi babamba byafuuha birando, nʼebyanjo byʼembusi nʼembaawo ejomu musaala kasiya, ");
INSERT INTO nuj_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","nʼamafuta gʼetaala nʼebyahaloosa ebi batabula mu mafuta agohutambisa mu hwawula, nʼobubbaani ");
INSERT INTO nuj_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","nʼamabaale agʼebbeeyi aga balanga baati onikisi ohuta hu efodi ko nʼehyambalo hyomu hifuba ehyʼomuhulu wʼabasengi. ");
INSERT INTO nuj_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Hiisi muutu omukugu mu byohubaaja, aŋweyo gaaje ahole byosibyosi ebi Musengwa alagiiye. ");
INSERT INTO nuj_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Eweema Enjawufu nʼebyohuwihaho nʼemirobo nʼembaawo nʼemihiihiro nʼesiiro nʼebiihaliro, ");
INSERT INTO nuj_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","e Sanduuku yʼEndagaano nʼemirabba nʼehisembo nʼolutimbe olwawulamo, ");
INSERT INTO nuj_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","emeeza nʼemirabba nʼebiitu byayo ebyohutambisa byosibyosi, nʼemigaati eji baŋongire eyiri Hatonda, ");
INSERT INTO nuj_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","nʼehihondo hyʼetaala nʼetaala nʼamafuta gaayo ko nʼebitiiniraho ");
INSERT INTO nuj_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","nʼehituuti ehyʼohudunyisangaho obubbaani nʼemirabba jowaho, amafuta agohutambisa mu hwawula ko nʼobubbaani, olutimbe olwomu mulyango gwʼEweema Enjawufu, ");
INSERT INTO nuj_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ehituuti ehi bohyeraho ebi baŋongire nʼoluhaliriro olwʼehihomo nʼemirabba jaahyo nʼebiitu ebyohutambisa byosibyosi ko nʼebbaafu nʼehihondo hyowaho, ");
INSERT INTO nuj_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","nʼetimbe ejʼohweswanigirisa olunya, nʼebisindi byajo ko nʼebiihaliro nʼolutimbe olwomu mulyango gwomu lunya, ");
INSERT INTO nuj_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ekondo ejʼEweema Enjawufu, ejʼolunya ko nʼemigoye jaajo, ");
INSERT INTO nuj_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","nʼebyambalo ebyʼabasengi, ebyʼohuŋeerehesangamo mu hifo Ehyawufu, ebyambalo ebyawufu ebyʼAlooni nʼabasaani babe ebyohwambala ni baŋeeresa ngʼabasengi.” ");
INSERT INTO nuj_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ngʼaŋo ehibbubbu hyʼAbayisirayiri hyosihyosi hiŋwa mu moni ja Musa ohutiina ohuhola ehyo ehi gabaloma. ");
INSERT INTO nuj_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Era hiisi muutu owaali nʼomwoyo ogwenda ohuleetera Musengwa ehirabo gaŋira ohutambisa ohubbota Eweema eyʼOhwagananirangamo nʼohuhola ebyetaagisa mu weema, ko nʼohuhola ebyambalo byʼabasengi. ");
INSERT INTO nuj_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Abasinde nʼabahasi bosibosi abendire, baŋira emihomyo ejʼezaabbu, epeta ejohu matwi nʼejohu ngalo, nʼembira nʼebyezaabbu byosibyosi, nga babiŋayo eyiri Musengwa. ");
INSERT INTO nuj_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Era hiisi owaali nʼolugoye olulaŋi olwa laasi, nolwa bbululu nolwa namasyoma nʼolulando ko nʼolubahola mu mooya gʼembusi, ebyanjo byʼemiigu ebi beeniha byafuuha birando nʼebyanjo byʼembusi, babiŋira babiŋaayo. ");
INSERT INTO nuj_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Hiisi muutu owasobola ohuŋaayo ebirabo ebyʼefeeza oba ebyʼehihomo, ngʼabiŋirira Musengwa. Hiisi muutu owaali nʼomusaala ogwa kasiya ogu basobola ohutambisa hu mulimo ogwo, gaŋira gaŋayo. ");
INSERT INTO nuj_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Era hiisi muhasi amanyire ebyʼemihono gaŋira engoye endaŋi eja laasi nʼewuuzi eja bbululu neja namasyoma nʼenando. ");
INSERT INTO nuj_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Era hiisi muhasi oyu mwoyo gugwe gwalumiirisa ohuŋaayo, gahola engoye mu mooya gʼembusi. ");
INSERT INTO nuj_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Abatangirisi baŋaayo amabaale agʼebbeeyi aga balanga baati onikisi agohuta hu efodi nohu hyambalo ehyomu hifuba ehyʼomusengi wa Hatonda. ");
INSERT INTO nuj_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Nga baŋira nʼebyahaloosa nʼamafuta agohuta mu taala nʼamafuta agohutambisa mu hwawula ko nʼobubbaani obuŋunya obulaŋi. ");
INSERT INTO nuj_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Abayisirayiri bosibosi, abasinde nʼabahasi, mula abaŋulira mula baati baŋeyo ehiitu olwʼomulimo ogu Musengwa galagira Musa ohuhola, baŋirira Musengwa ni ŋaŋuma hubaŋalirisa. ");
INSERT INTO nuj_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Ngʼaŋo Musa aloma Abayisirayiri ati, “Musengwa atobooye Bbezaleeri omusaani wa Wuuli, omwijuhulu wa Huuri, owomu hiha hya Yuda. ");
INSERT INTO nuj_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Era Hatonda amwijuhise Omwoyo wuwe, gamuŋa amagesi nʼohutegeera nʼohumanya ohuhola emirimo eja hiisi ngeri, ");
INSERT INTO nuj_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ohutetekania amajolobera mu zaabbu nomu feeza ko nomu hihomo, ");
INSERT INTO nuj_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","nomu husala amabaale agʼebbeeyi nʼembaawo nʼohuhola emirimo ejʼehikugu eja hiisi ngeri. ");
INSERT INTO nuj_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Era amuŋaaye niye nʼOholiyaabbu omusaani wʼAhisamaki owomu hiha hya Daani, amagesi ohusomesa abaatu abandi ohuhola hya nibo. ");
INSERT INTO nuj_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Abaŋaaye amagesi ohuhola emirimo eja hiisi ngeri, ohubaaja amabaale, abatungi bʼengoye endaŋi mu wuuzi eja bbululu neja namasyoma nʼenando ko nʼengoye endaŋi eja laasi. Baasobola ohuhola emirimo josijosi eja hiisi ngeri era nʼohuyiiya ebyʼehikugu. ");
INSERT INTO nuj_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Bbezaleeri nʼOholiyaabbu nʼabatambi abandi bosibosi Musengwa abaŋaaye amagesi nʼohutegeera ohumanya ohuhola hiisi hiitu ehi benda mu hutongola Eweema Enjawufu ngʼolu Musengwa gaalagira.” ");
INSERT INTO nuj_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Ngʼaŋo Musa alanga Bbezaleeri nʼOholiyaabbu nʼabatambi abandi abahugu bosibosi aba Musengwa gaaŋa obuhugu, hiisi oyu mwoyo gugwe gwali ni gumuhubbirisa ohutiina ohuhola emirimo. ");
INSERT INTO nuj_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ngʼabaŋambya ebirabo byosibyosi ebi Bayisirayiri baŋira ebyʼomulimo ogwʼohutongola eweema. Era abaatu beyongera hiisi ludaalo ohuŋirira Musa ebiitu ni ŋaŋuma hubaŋalirisa. ");
INSERT INTO nuj_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Olwʼehyo, abahugu bosibosi abaali ni bahola omulimo ogwʼohutongola eweema, baŋwayo ");
INSERT INTO nuj_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","baloma Musa baati “Abaatu baleetire ebiitu bibitiirifu bugali ebyohuhola omulimo ogu Musengwa gatulagira ohuhola.” ");
INSERT INTO nuj_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Ngʼaŋo Musa atusa ehiragiro mu kambi yosiyosi ati “Ŋaahani abasinde nʼabahasi muleehera aŋo obuyeedi owohutongola eweema.” Ngʼabaatu ko balehera aŋo ohuŋira ebiitu, ");
INSERT INTO nuj_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","olwohuba ebi baali ni baŋirire byali bihena omulimo byasigalaho nʼohusigala. ");
INSERT INTO nuj_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Abatambi abaali ni basinga obumanyi njʼabahola eweema ni mulimo etimbe ehumi eji baahola mu ngoye endaŋi eja laasi nʼewuuzi eja bbululu neja namasyoma nʼenando. Era mu timbe ejo bahubbamo nʼebifaanani byʼabamalayika aba balanga baati abakerubbi. ");
INSERT INTO nuj_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Etimbe josijosi jaali jiŋeraŋerana, obuleeŋi efuuti ane nʼebiri, obugalamu efuuti mukaaga. ");
INSERT INTO nuj_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Etimbe etaanu bajigaata ŋalala era gaŋamba nʼetaanu ejindi joosi bajiŋimbya ŋalala. ");
INSERT INTO nuj_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Era gaahola endiba mu lugoye olwa bbululu hutulo wʼetimbe ejo eji bagaata etaanu etaanu. ");
INSERT INTO nuj_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Baahola endiba amahumi ataanu hutulo wʼetimbe engaate jira era endiba ejohu luuyi lulala ni gaŋeraŋerana nʼejohu luuyi olundi. ");
INSERT INTO nuj_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Era baahola emirobo amahumi ataanu mu zaabbu ohugaata ŋalala etimbe jombi, ko Eweema Enjawufu yibe pimbe ŋalala. ");
INSERT INTO nuj_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Nga bahola etimbe ehumi nandala ohuŋwa mu mooya gʼembusi, ohuwiiha hu Weema Enjawufu. ");
INSERT INTO nuj_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Etimbe ehumi nandala, obuleeŋi jaali efuuti ane nʼetaanu, obugalamu efuuti mukaaga. ");
INSERT INTO nuj_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Gaŋimba etimbe etaanu ŋalala era gahena gaŋimba nʼomukaaga joosi ŋalala. ");
INSERT INTO nuj_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Era gahola endiba amahumi ataanu mu sonda nomu sonda wʼetimbe eji baŋimbya ŋalala. ");
INSERT INTO nuj_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Baahola ebiitu amahumi ataanu mu hihomo ohugumya etimbe ŋalala era ebiitu ebyo byali oti mirobo. ");
INSERT INTO nuj_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Era baahola ehyohuwiiha hu weema mu hyanjo hyʼetaama emiigu ehibenihire hyafuuha hirando, ehyanjo ehindi hyali hyʼembusi. ");
INSERT INTO nuj_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ngʼaŋo bahola embaawo ejomu musaala kasiya ejʼohutongolamo Eweema Enjawufu. ");
INSERT INTO nuj_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Obuleeŋi wa hiisi lubaawo waali efuuti ehumi nʼetaanu, obugalamu ni jiri efuuti ebiri nʼeyiici edatu. ");
INSERT INTO nuj_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Bahola ekondo ebiri ohuba ŋaasi wa hiisi lubaawo. Embaawo ejo josijosi ejʼEweema Enjawufu bajihola ni jagaagana. ");
INSERT INTO nuj_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Baahola embaawo abiri ejʼoluuyi lwomu mehiriro gʼEweema Enjawufu, ");
INSERT INTO nuj_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","era baahola nʼebiihaliro amahumi ane mu feeza: ebiihaliro bibiri ŋaasi wa hiisi lubaawo. ");
INSERT INTO nuj_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Nga bahola embaawo amahumi abiri ejohu luuyi olwʼengulu lwʼEweema Enjawufu, ");
INSERT INTO nuj_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","nʼebiihaliro amahumi ane ebyʼefeeza, ebiihaliro bibiri ŋaasi wa hiisi lubaawo. ");
INSERT INTO nuj_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Baahola embaawo mukaaga ejohu luuyi lwʼebugwalyuba lwʼEweema Enjawufu, ");
INSERT INTO nuj_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","nʼembaawo ebiri ejomu sonda jayo. ");
INSERT INTO nuj_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Embaawo ejo jombi ohuŋwa ŋaasi oholera erala ŋamugulu, ni bajisidihire nʼepeta ndala. Jombi bajihola baatyo. ");
INSERT INTO nuj_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ŋosiŋosi, embaawo jaali munaana nʼebiihaliro ehumi namukaaga ebyʼefeeza, bibiri ŋaasi wa hiisi lubaawo. ");
INSERT INTO nuj_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Era baahola emihiihiro ehumi nʼetaanu ohuŋwa mu musaala kasiya: etaanu hu luuyi olwʼengulu lwʼEweema Enjawufu, ");
INSERT INTO nuj_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","etaanu ejohu luuyi lwomumenamo. Era gaahola emihiihiro etaanu ejohu luuyi lwʼebugwalyuba olwʼEweema Enjawufu. ");
INSERT INTO nuj_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Baahola omuhiihiro ogwa ŋagati ni guŋwa hu luuyi ohwola hu luuyi lwʼefuleemu. ");
INSERT INTO nuj_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Nga bamaala embaawo ejo nʼezaabbu era babbota epeta mu zaabbu ejohusidihira emihiihiro era joosi bajimaalaho nʼezaabbu. ");
INSERT INTO nuj_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Era baahola olutimbe mu ngoye endaŋi eja laasi nʼewuuzi eja bbululu neja namasyoma nʼenando, omuhugu galutungaho ebifaanani byʼabamalayika aba balanga baati abakerubbi. ");
INSERT INTO nuj_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Baluŋambya nʼebyoma ebiri oti mirobo ohuŋwa mu zaabbu hu bisindi bine ebyomu musaala kasiya ni babimaayeho nʼezaabbu nga babingisa mu biihaliro bine ebyʼefeeza. ");
INSERT INTO nuj_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Mu mulyango ogwengira mu Weema Enjawufu baatamo etimbe eji baahola mu ngoye endaŋi eja laasi nʼewuuzi eja bbululu neja namasyoma nʼenando. Era hu timbe ejo, bataho nʼomuleera. ");
INSERT INTO nuj_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Baahola esiiro etaanu mu musaala kasiya era nga bajimaalaho nʼezaabbu, emirobo ni jijiŋambiriiye. Baahola nʼebiihaliro bitaanu ebyʼehihomo. ");
INSERT INTO nuj_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Nga Bbezaleeri abbota e Sanduuku mu mbaawo ohuŋwa mu musaala kasiya. Obuleeŋi, eyiici ane nʼetaanu, obugalamu eyiici abiri namusanvu, obuleeŋi ohuja ŋamugulu eyiici abiri namusanvu. ");
INSERT INTO nuj_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Ngʼamaala mugati nʼohumugulu wʼe Sanduuku eyo nʼezaabbu enyene nʼenyene era gaayitaho omugo ogwʼezaabbu ohuyeswanigirisa. ");
INSERT INTO nuj_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ngʼabbota epeta ejʼezaabbu ene, ebiri hu luuyi nʼoluuyi hu magulu ane agʼe Sanduuku. ");
INSERT INTO nuj_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ngʼaŋo ahola emirabba ejʼomuŋwa omuhosa ejʼohuta mu mihobyo, nga byosi babimaalaho nʼezaabbu. ");
INSERT INTO nuj_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Era ngʼaŋamba emirabba ejo ajingisa mu mihobyo hu hiisi luuyi lwʼe Sanduuku ohweyeedesa mu huyidunda. ");
INSERT INTO nuj_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Bbezaleeri gaŋamba ezaabbu enyene nʼenyene, ngʼayiholamo ehisembo ehyohu Sanduuku, obuleeŋi eyiici ane nʼetaanu, obugalamu eyiici abiri namusanvu. ");
INSERT INTO nuj_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ngʼabbota mu zaabbu enyene nʼenyene ebifaanani byʼabamalayika abakerubbi babiri, babata hu luuyi nʼoluuyi olwʼehisembo. ");
INSERT INTO nuj_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Gaŋamba kerubbi mulala gamuta hu luuyi lulala, owundi gamuta hu luuyi olundi. Aye bombi baali hiitu hirala nʼehisembo hyʼe Sanduuku ni ŋaŋumaŋo buyungiro. ");
INSERT INTO nuj_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Abakerubbi bombi bahotamirira ni balengereene ni banjuluhise nʼamabaŋa gaawe era ni gawihiriiye hu hisembo hyʼe Sanduuku. ");
INSERT INTO nuj_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Ngʼaŋo Bbezaleeri abbota emeeza mu musaala kasiya, obuleeŋi eyiici adatu namukaaga, obugalamu eyiici ehumi namunaana, obuleeŋi ŋamugulu eyiici abiri namusanvu. ");
INSERT INTO nuj_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Ngʼayimaalaho nʼezaabbu enyene nʼenyene era ngʼayiniolehesaho omugo ogwʼezaabbu ohuyeswanigirisa. ");
INSERT INTO nuj_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Ngʼayiniolehesaho omugo, eyiici edatu ohuyeswanigirisa ni bayiŋahaho nʼezaabbu. ");
INSERT INTO nuj_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ngʼabbota epeta ejʼezaabbu ene, bahena bata ndala mu hiisi sonda hu magulu gʼemeeza eyo. ");
INSERT INTO nuj_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Epeta ejo bajita huupi nʼomugo omubengisa ebidundiro ebyʼemeeza eyo. ");
INSERT INTO nuj_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Gaŋamba emirabba ejʼomuŋwa omuhosa, gajimaalaho nʼezaabbu. Emirabba ejo jahugegerangaho emeeza. ");
INSERT INTO nuj_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Hiisi hiitu ehyohutambisa hu meeza hyʼesaani nʼebikopo nʼejaaga nʼebibya gabibbota mu zaabbu enyene nʼenyene. ");
INSERT INTO nuj_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Ngʼaŋo Bbezaleeri abbota ehihondo hyʼetaala mu zaabbu enyene nʼenyene, owihaliro nʼenduli yahyo nʼebikopo ebyohujuhamo amafuta ebiri hyʼebimuli, byosibyosi ni biri hiitu hirala ni ŋaŋuma buyungiro. ");
INSERT INTO nuj_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Ehihondo hyʼetaala hyaliho amasaga mukaaga, adatu hu luuyi nʼoluuyi. ");
INSERT INTO nuj_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Hiisi lusaga lwaliho ebimuli bidatu ebifaana hyʼebyalumondi ni biwumbuluhire. ");
INSERT INTO nuj_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Era hu nduli yʼehihondo hyʼetaala, baataho ebihopo bine ebifaanana hyʼebimuli alumondi. ");
INSERT INTO nuj_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Ŋaasi wa hiisi masaga abiri ohuŋwa hu nduli yʼehihondo, ŋaaliŋo ehiitu hyʼehimuli alumondi. ");
INSERT INTO nuj_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ehihondo hyʼetaala nʼamasaga ko nʼebiitu ebiri hyʼebimuli byʼalumondi byali hiitu hirala ohuŋwa mu zaabbu enyene nʼenyene. ");
INSERT INTO nuj_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Gaabbota etaala musanvu nʼetambi nʼesuniya, byosibyosi mu zaabbu enyene nʼenyene. ");
INSERT INTO nuj_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Gaŋamba ekilo adatu nʼetaanu ejʼezaabbu enyene nʼenyene, gabbotamo ehihondo hyʼetaala nʼebitiiniraho byosibyosi. ");
INSERT INTO nuj_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ngʼaŋo Bbezaleeri ahola ehituuti mu mbaawo ejʼomusaala kasiya ehyʼohudunyisangaho obubbaani. Ehituuti ehyo hyali hiŋeraŋerana enjuyi nʼenjuyi, obuleeŋi efuuti ndala nʼehitundu, obugalamu efuuti ndala nʼehitundu, obuleeŋi ŋamugulu efuuti edatu. Ameega gaahyo gaali gʼomusaala njʼomwene. ");
INSERT INTO nuj_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Hu mugulu, oluuyi nʼoluuyi ko nʼohumeega, ahimaalaho nʼezaabbu enyene nʼenyene era gaayitaho nʼomugo ogwʼezaabbu ohuyeswanigirisa. ");
INSERT INTO nuj_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Ngʼabbota epeta ebiri ejʼezaabbu ajita ŋaasi wʼomugo hu njuyi ebiri ohuŋamba emirabba ejʼohweyeedesanga mu hubbeeda. ");
INSERT INTO nuj_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Gaahola emirabba ejomu muŋwa omuhosa, ngʼahena amaalaho nʼezaabbu. ");
INSERT INTO nuj_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Era gaahola amafuta amawufu agohutambisanga mu hwawula, gatabulamo ebyahaloosa mu kola eyʼehikugu, ngʼahola nʼobubbaani obuŋunya ahaloosa bugali. ");
INSERT INTO nuj_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ngʼaŋo Bbezaleeri aŋamba embaawo ejʼomusaala kasiya abbotaamo ehituuti ehyohwohyerangaho eŋongo, obuleeŋi efuuti musanvu nʼehitundu, obugalamu efuuti musanvu nʼehitundu, obuleeŋi ŋamugulu efuuti ene nʼehitundu. ");
INSERT INTO nuj_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ngʼahola ameega ane, hiisi lwiga baaluta mu hiisi sonda era gaali hiitu hirala nʼehituuti. Ni gaahena, ngʼamaalaho nʼehihomo. ");
INSERT INTO nuj_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Era gaahola ebyohutambisa hu hituuti: ebyʼohuyolerangamo egohe nʼebijiiko nʼebibya nʼewuuma nʼesuniya, byosibyosi gabibbota mu hihomo. ");
INSERT INTO nuj_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Gayiholera oluhaliriro olwʼehihomo, ngʼata mugati wʼehituuti, ni luli luleeŋi ŋamugulu. ");
INSERT INTO nuj_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Ngʼaŋamba emihobyo ejʼehihomo ene ajitamo emirabba ejʼohweyeedesanga mu huginga. ");
INSERT INTO nuj_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ngʼahola emirabba ejʼomuŋwa omuhosa era ngʼajimaalaho nʼehihomo. ");
INSERT INTO nuj_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Ngʼaŋo gengisa emirabba ejo mu mihobyo mu hiisi luuyi lwʼehituuti, ohweyeedesanga mu hubbeeda. Gaahola ehituuti ni hiri oti sanduuku. ");
INSERT INTO nuj_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Ngʼabbota ebbaafu eyʼehihomo nʼehihondo hyayo mu ndabirwamu ejʼabahasi abaaŋeeresanga ŋa mulyango gwʼEweema yʼOhwagananirangamo. ");
INSERT INTO nuj_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ngʼaŋo Bbezaleeri ahola olunya lwʼEweema Enjawufu. Obuleeŋi wʼoluuyi lwomu mehiriro lwali efuuti cikumi nʼataanu era hwaliho nʼetimbe ejomu lugoye olulaŋi olwa laasi, ");
INSERT INTO nuj_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","nʼebisindi amahumi abiri ebyʼohujomeha mu biihaliro ebyʼehihomo amahumi abiri gataho ebiitu ebyʼefeeza oti mirobo ohuŋambya etimbe. ");
INSERT INTO nuj_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Engulu wʼEweema yoosi gaatayo ebisindi amahumi abiri ebyʼohujomeha mu biihaliro ebyʼehihomo amahumi abiri ko nʼebiitu oti mirobo ebyʼefeeza ohuŋambya etimbe ejʼefuuti cikumi nʼataanu. ");
INSERT INTO nuj_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Hu luuyi lwʼebugwalyuba wʼEweema, obuleeŋi waali efuuti sanvu nʼetaanu. Ebisindi byali ehumi nʼebiihaliro ebyʼehihomo ehumi ko nʼebiitu ebyʼefeeza oti mirobo. ");
INSERT INTO nuj_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Hu luuyi olwʼebuŋwalyuba, olunya lwali obugalamu efuuti sanvu nʼetaanu. ");
INSERT INTO nuj_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Hu luuyi lulala olwʼomulyango gaataho etimbe obuleeŋi efuuti abiri nʼebiri nʼehitundu, nʼebisindi bidatu ko nʼebiihaliro bidatu. ");
INSERT INTO nuj_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Hu luuyi olundi olwʼomulyango, gaataho etimbe obuleeŋi efuuti abiri nʼebiri nʼehitundu ko nʼebisindi bidatu nʼebiihaliro bidatu. ");
INSERT INTO nuj_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Etimbe ejo josijosi jaali jomu lugoye olulaŋi olwa laasi. ");
INSERT INTO nuj_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Gaŋimbya ebisindi byosibyosi nʼatambisa ehihomo ohweswanigirisa olunya lwʼEweema era ebiitu oti mirobo ohuŋambya ebisindi byali byʼefeeza ko nʼebiihaliro ebyʼehihomo. ");
INSERT INTO nuj_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Olutimbe olwa ŋa mulyango gwʼEhifo Ehyawufu baluhola mu lugoye olulaŋi olwa laasi nga balutunga nʼewuuzi eja bbululu neja namasyoma nʼenando mu kola eyʼehikugu. Obuleeŋi wʼolutimbe waali efuuti adatu ne obuleeŋi ŋamugulu waali efuuti musanvu nʼehitundu ohweswanigirisa olunya. ");
INSERT INTO nuj_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Gaahola nʼebisindi bine, ebiihaliro byabyo bine byali byʼehihomo era ebiitu oti mirobo nʼepeta babbota mu feeza. ");
INSERT INTO nuj_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Ekondo jʼEweema Enjawufu josijosi ko nʼekondo ejʼolunya ohweswanigirisa, jaali ja hihomo. ");
INSERT INTO nuj_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Luno njʼolukalala lwʼebiitu ebi batambisa ohutongola Eweema Enjawufu. Musa galagira Abaleevi ohubiŋandiha era Yisamaari omusaani wʼAlooni omusengi njʼowaali omuŋandiisi. ");
INSERT INTO nuj_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bbezaleeri omusaani wa Wuuli era omwijuhulu wa Huuri owomu hiha hya Yuda, gaahola byosibyosi ebi Musengwa galagira Musa. ");
INSERT INTO nuj_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Era Bbezaleeri gaahola emirimo jije ni Oholiyaabbu omusaani wʼAhisamaki, owomu hiha hya Daani, omusali wʼamabaale, omutetekania era nʼamanyire ohutunga engoye mu wuuzi eja bbululu neja namasyoma nʼenando ko nʼengoye endaŋi eja laasi. ");
INSERT INTO nuj_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Ezaabbu josijosi eji baatu baŋaayo ohutongola Eweema Enjawufu, yaali talanta abiri namwenda, ni sekeeli lusanvu nʼadatu, mu bipimo ebitongole ebyomu Hifo Ehyawufu. ");
INSERT INTO nuj_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Ehibbubbu hyʼAbayisirayiri hyosihyosi hyaŋayo efeeza eyaŋera etalanta cikumi ko ni sekeeli lukumi lusanvu musanvu nʼetaanu, mu bipimo ebitongole ebyomu hifo ehyawufu. ");
INSERT INTO nuj_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Abo abaali ni baŋesa emyaha amahumi abiri ejʼobuhulu nʼohuhiraho, baali emitwalo kaaga, nʼekumi edatu nʼebihumi bitaanu nʼataanu. Hiisi mulala gaŋayo omuŋendo ogu baagereha, ogwali bbeka ndala, njʼehitundu hya sekeeli, mu bipimo ebitongole. ");
INSERT INTO nuj_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Hiisi hiihaliro ehyʼEweema, hyaŋiranga ekilo adatu nʼene ejʼefeeza ohuhibbota. Ŋosiŋosi, ebiihaliro byali cikumi. ");
INSERT INTO nuj_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Bbezaleeri gatambisa sekeeli lukumi nalusanvu nasanvu nʼetaanu, ohujiholamo ebiitu oti mirobo ohuŋambya ebisindi. ");
INSERT INTO nuj_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Era abaatu baaŋayo etalanta sanvu ejʼehihomo ko ni sekeeli ekumi ebiri nabine. ");
INSERT INTO nuj_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Batambisa talanta ejo ejʼehihomo ohubbotamo ebiihaliro byʼomulyango gwʼEweema eyʼOhwagananirangamo nʼehituuti nʼoluhaliriro ko nʼebiitu byosibyosi ebyohu hituuti. ");
INSERT INTO nuj_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Era batambisa ehihomo ohubbota ebiihaliro ebyʼemyango ohubaata etimbe ni jeswanigirisa olunya nʼebiihaliro ebyʼetimbe eja ŋa mulyango ogwingira mu lunya ko nʼekondo josijosi ko nʼebiihaliro ohweswanigirisa Eweema Enjawufu. ");
INSERT INTO nuj_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Nga batambisa ewuuzi eja bbululu neja namasyoma nʼenando ohutunga ebyambalo ebyʼabasengi ebyʼohwambalanga ni baŋeeresa mu Hifo Ehyawufu. Era baholera Alooni ebyambalo ebyawufu ngʼolu Musengwa galagira Musa. ");
INSERT INTO nuj_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Nga batunga efodi mu lugoye olulaŋi olwa laasi nʼewuuzi ejʼezaabbu neja bbululu neja namasyoma nʼenando. ");
INSERT INTO nuj_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Nga bahubba ezaabbu basalamo obuutu oti wuuzi batunga mu lugoye olulaŋi olwa laasi nʼewuuzi eja bbululu neja namasyoma nʼenando mu ngeri eyʼehikugu. ");
INSERT INTO nuj_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Hu mabega gʼefodi baholeraho obusibiro bubiri enjuyi nʼenjuyi, ohuŋimba mu moni nʼegongo ohuyigumya. ");
INSERT INTO nuj_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Baatunga omusibiro nʼamagesi agʼehikugu mu lugoye njʼolwene olwo nʼefodi ni ŋaŋuma buyungiro, nʼewuuzi ejʼezaabbu neja bbululu neja namasyoma nʼenando nʼendaŋi eja laasi ngʼolu Musengwa galagira Musa. ");
INSERT INTO nuj_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Nga baŋamba amabaale onikisi bagata mu fuleemu ejʼezaabbu. Nga hu mabaale ohwo baŋandiihaho amasiina gʼabasaani ba Yisirayiri ehumi nʼababiri. ");
INSERT INTO nuj_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Nga bagasidiha hu mabega gʼefodi ohuba ehyʼohuhebulirirangaho abasaani ba Yisirayiri ngʼolu Musengwa galagira Musa. ");
INSERT INTO nuj_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Nga bahola ehyambalo ehyomu hifuba mu lugoye olulaŋi olwa laasi, bahitunga mu kola eyʼehikugu mu ngeri njʼenyene nʼefodi: nʼewuuzi ejʼezaabbu neja bbululu neja namasyoma nʼenando. ");
INSERT INTO nuj_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Hyali hyagaagana obuleeŋi eyiici mwenda, obugalamu eyiici mwenda, ni bayifunyamo ŋabiri. ");
INSERT INTO nuj_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ngʼaŋo bataho enyiriri ene ejʼamabaale agʼebbeeyi. Olunyiriri oludaayi lwali lwa sarudiyo ni topazi ko ni karubukulo. ");
INSERT INTO nuj_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Olunyiriri olwohubiri lwali lwʼemeraludo ni safiro ko ni dayamondi. ");
INSERT INTO nuj_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Olunyiriri olwohudatu lwali lwa yasiso nʼagate nʼamesiti. ");
INSERT INTO nuj_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Olunyiriri olwohune lwali lwa bberulo nʼonikisi ko ni yasipero, ni biri mu fuleemu ejʼezaabbu. ");
INSERT INTO nuj_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Ŋaaliŋo amabaale ehumi nabiri, hiisi baale ni baŋandiihaho esiina erala hu biha ehumi nabibiri hu gʼabasaani ba Yisirayiri. ");
INSERT INTO nuj_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Nga bahola otujegere mu zaabbu enyene nʼenyene, batuta hu hyambalo ehyomu hifuba ni babuluha hyʼemigoye. ");
INSERT INTO nuj_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Nga bahola efuleemu ejʼezaabbu ebiri ko nʼepeta ebiri ejʼezaabbu. Epeta ejo ebiri bajita hu sonda jombi ŋamugulu wʼehyambalo ehyomu hifuba. ");
INSERT INTO nuj_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Nga bata obujegere owʼezaabbu owo wombi mu peta ebiri mu sonda nomu sonda ejʼehyambalo ehyomu hifuba. ");
INSERT INTO nuj_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Nga basidiha oluuyi olundi olwa hajegere mu fuleemu ebiri ni baŋimba hu hohumabega mu moni hu efodi. ");
INSERT INTO nuj_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Nga bahola epeta ebiri mu zaabbu, nga bajita hu sonda jombi eja ŋaasi wʼehyambalo ehyomu hifuba, mugati hu efodi. ");
INSERT INTO nuj_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ngʼaŋo bahola epeta ejʼezaabbu ejindi ebiri, bajiŋambya hu mabega gʼefodi ŋaasi hu luuyi olwomu moni, ŋamugulu wʼomusibiro gwʼefodi. ");
INSERT INTO nuj_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Nga baŋambya epeta ejohu hyambalo ehyomu hifuba nʼahasibiro ahabbululu ahohu efodi ko ehyambalo ehyomu hifuba hitahuhamo. Ebyo byosibyosi babihola ngʼolu Musengwa galagira Musa. ");
INSERT INTO nuj_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Ngʼaŋo bahola eganduula ohwambaliranga mugati wʼefodi era balitunga nʼewuuzi eja bbululu. ");
INSERT INTO nuj_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Ehituli omubefihira omutwe, bahyeswanigirisa nʼehiitu oti hitogi ko hitanawuha. ");
INSERT INTO nuj_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Eganduula eryo balihola mu lugoye olulaŋi olwa laasi. Era ohweswanigirisa egemo lyʼeganduula, ŋaasi hutulo baataho ebifaanani ebya komamawanga era batunga nʼewuuzi eja bbululu neja namasyoma nʼenando. Baataho nʼendege eji baabbota mu zaabbu enyene nʼenyene ngʼolu Musengwa galagira Musa. ");
INSERT INTO nuj_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Era baahola endege ejʼezaabbu enyene nʼenyene, nga bajita ŋagati wa komamawanga. ");
INSERT INTO nuj_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Baahola endege bajita ŋagati wa komamawanga ohweswanigirisa ehirenge hyʼAlooni ohwambalanga nʼaŋeeresa. Ebyo byosibyosi babihola ngʼolu Musengwa galagira Musa. ");
INSERT INTO nuj_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Nga baholera Alooni nʼabasaani babe amakaaso mu lugoye olulaŋi olwa laasi. ");
INSERT INTO nuj_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Nga babaholera ehyohu mutwe nʼepale enyipi mu ngoye endaŋi eja laasi. ");
INSERT INTO nuj_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Omusibiro gwali gwomu lugoye olulaŋi olwa laasi olu batunga nʼepisyo mu ngeri eyʼehikugu nʼewuuzi eja bbululu neja namasyoma nʼenando ngʼolu Musengwa galagira Musa. ");
INSERT INTO nuj_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Nga bahola ahapande ahʼezaabbu enyene nʼenyene, bahaŋandihaho baati, “Hyawufu eyiri Musengwa.” ");
INSERT INTO nuj_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Nga bahaŋambya mu moni wʼehyambalo ehyohu mutwe nʼewuuzi ejʼerangi erya bbululu ngʼolu Musengwa galagira Musa. ");
INSERT INTO nuj_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Ngʼaŋo omulimo gwosigwosi ogwʼohutongola Eweema Enjawufu, Eweema eyʼOhwagananirangamo guŋwa. Abayisirayiri baahola hiisi hiitu ngʼolu Musengwa galagira Musa. ");
INSERT INTO nuj_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Nga baŋira Eweema Enjawufu aŋa Musa gaali: eweema nʼebibatambisa byosibyosi nʼemirobo nʼefuleemu nʼemihiihiro nʼebisindi nʼebiihaliro, ");
INSERT INTO nuj_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ebyanjo byʼembusi nʼebyeŋombe nʼebyemiigu ebi bacuusa byafuuha birando ko nʼolutimbe ");
INSERT INTO nuj_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","nʼEsanduuku yʼEndagaano nʼemirabba jowaho nʼehisembo nʼolutimbe ");
INSERT INTO nuj_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","nʼemeeza nʼebiitu byayo byosibyosi nʼemigaati eji baŋayo eyiri Hatonda, ");
INSERT INTO nuj_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","nʼehihondo hyʼetaala ehyʼezaabbu enyene nʼenyene nʼetaala nʼamafuta gaayo ko nʼebitiiniraho byosibyosi. ");
INSERT INTO nuj_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Bamuŋirira nʼehituuti ehyʼezaabbu ehyʼohudunyisangaho obubbaani nʼamafuta agohutambisa mu hwawula nʼobubbaani ko nʼolutimbe olwomu mulyango gwʼEweema Enjawufu, ");
INSERT INTO nuj_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","nʼehituuti ehyʼehihomo nʼoluhaliriro lwahyo olwʼehihomo nʼemirabba jaahyo nʼebiitu ebyohutambisa byosibyosi ko nʼebbaafu nʼehihondo hyowaho, ");
INSERT INTO nuj_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","nʼetimbe ejʼohweswanigirisa olunya, nʼebisindi byajo ko nʼebiihaliro nʼolutimbe olwomu mulyango gwomu lunya, nʼemigoye nʼebihondo byʼeweema ebyomu lunya era nʼebiitu byosibyosi ebyʼohutambisa mu Weema Enjawufu, ");
INSERT INTO nuj_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","nʼebyambalo ebyʼabasengi ebyʼohuŋeerehesangamo mu hifo Ehyawufu, ebyambalo ebyawufu ebyʼAlooni nʼabasaani ebyohwambala ni baŋeeresa ngʼabasengi. ");
INSERT INTO nuj_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Abayisirayiri baahola omulimo gwosigwosi ngʼolu Musengwa galagira Musa. ");
INSERT INTO nuj_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Nga Musa ahebera omulimo gwosigwosi, abona ati baali baguholire ngʼolu Musengwa galagira. Ngʼaŋo abasabira ekabi. ");
INSERT INTO nuj_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ngʼaŋo Musengwa aloma Musa ati, ");
INSERT INTO nuj_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Hu ludaalo oludaayi mu mwesi omudaayi, oja hwemeha Eweema eyʼOhwagananirangamo. ");
INSERT INTO nuj_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Oja huta Esanduuku yʼEndagaano mu Weema eyo ohene oteŋo olutimbe ohwawula Ehifo Ehyawufu nʼEhyawufu Obugali. ");
INSERT INTO nuj_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Oŋiremo emeeza ko nʼebitiiniraho. Otemo nʼehihondo hyʼetaala, oteho nʼamataala. ");
INSERT INTO nuj_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Oŋambe ehituuti ehi baabbota mu zaabbu ohudunyihisangaho obubbaani, ohite mu moni wʼEsanduuku yʼEndagaano, ohene ote olutimbe mu mulyango ogwʼEweema Enjawufu. ");
INSERT INTO nuj_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Oja huta ehituuti ehyohwohyerangaho eŋongo mu moni wʼomulyango gwʼEweema eyʼOhwagananirangamo. ");
INSERT INTO nuj_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Oŋambe ebbaafu oyitengehe ŋagati wʼEweema eyʼOhwagananirangamo nʼehituuti, ohene oyijuhemo amaaji. ");
INSERT INTO nuj_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ŋabeŋo olunya ohweswanigirisa eweema era oteŋo olutimbe mu mulyango ogwingira mu lunya. ");
INSERT INTO nuj_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Nʼohena ohuhola otyo, oŋambanga amafuta agohutambisa mu hwawula oŋahe hu biitu byosibyosi ebyomu Weema Enjawufu era hiisi hiitu hirifuuha hyawufu. ");
INSERT INTO nuj_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Era otambise amafuta ohwawula ehituuti ehyohuŋeeraho eŋongo era wawule hiisi hiitu ehi batambisa hu hituuti ehyo, bibe byawufu bugali. ");
INSERT INTO nuj_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Era oŋambe amafuta oŋahe hu bbaafu nʼehihondo hyayo, bifuuhe byawufu. ");
INSERT INTO nuj_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Nʼohena ebyo, oŋambanga Alooni nʼabasaani wabaŋira ŋa mulyango ogwingira mu Weema eyʼOhwagananirangamo, obooge nʼamaaji. ");
INSERT INTO nuj_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Wambase Alooni ebyambalo ebyawufu, omujuheho amafuta, omwabule gapeerese ngʼomusengi. ");
INSERT INTO nuj_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Oŋambe abasaani babe, obambase amakaaso ");
INSERT INTO nuj_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","obajuheho amafuta ngʼolu oŋahire saawe, bapeeresenga ngʼabasengi. Era obuŋeeresa waawe ngʼabasengi buja huba wʼemirembe nʼemirembe.” ");
INSERT INTO nuj_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Nga Musa ahola ebiitu ebyo byosibyosi ngʼolu Musengwa gamulagira. ");
INSERT INTO nuj_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Olwʼehyo, hu ludaalo oludaayi mu mwesi omudaayi mu mwaha ogwohubiri ohuŋwa olu Bayisirayiri baŋwa e Misiri, nga bemeha Eweema Enjawufu. ");
INSERT INTO nuj_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa ni gaabona ohutongola Eweema Enjawufu ni huŋooye, gataŋo ebiihaliro nʼembaawo ko nʼemihiihiro jaayo, nga genyosa nʼebisindi byayo. ");
INSERT INTO nuj_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Nga ganjulusa ehyohuwiha hu Weema Enjawufu, ngʼayitaho nʼebyohwalaho hu mugulu, ngʼolu Musengwa galagira. ");
INSERT INTO nuj_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ngʼaŋamba ebipande byʼamabaale ebibiri, abita mu Sanduuku yʼEndagaano. Ngʼaŋamba emirabba ajijomeha mu mihobyo jʼEsanduuku, ohuyeeda mu hubbeeda. Ngʼahena ataaho ehisembo ohufunihiraho. ");
INSERT INTO nuj_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Nga gengisa Esanduuku yʼEndagaano mu Weema Enjawufu, ahena ayitigalira nʼolutimbe ngʼolu Musengwa gamulagira. ");
INSERT INTO nuj_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Nga Musa aŋamba emeeza ayiŋira mu Weema eyʼOhwagananirangamo mu Hifo Ehyawufu hu luuyi lwomu mehiriro. ");
INSERT INTO nuj_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Ngʼahena ayitaho emigaati eji baŋaayo eyiri Musengwa, ngʼolu Musengwa gamulagira. ");
INSERT INTO nuj_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ngʼaŋamba ehihondo hyʼetaala aŋira mu Weema eyʼOhwagananirangamo, ahita mu moni wʼemeeza, hu luuyi olwomu mehiriro gʼeweema. ");
INSERT INTO nuj_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ngʼaŋo aŋambya etaala mu moni ja Musengwa, ngʼolu Musengwa gamulagira. ");
INSERT INTO nuj_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ngʼaŋamba ehituuti ehyʼezaabbu ahita mu Weema eyʼOhwagananirangamo, mu moni jʼolutimbe ");
INSERT INTO nuj_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ngʼaniokehesaho obubbaani obuŋunya ahaloosa, ngʼolu Musengwa gamulagira. ");
INSERT INTO nuj_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ngʼaŋo ata olutimbe mu mulyango gwʼEweema Enjawufu. ");
INSERT INTO nuj_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ngʼaŋamba ehituuti ehyohuŋeerangaho eŋongo ahita huupi nʼomulyango gwʼEweema eyʼOhwagananirangamo, ngʼaŋongeraho embehe ejʼebirime ko nʼeŋongo eyibohya kwiye yaguguliha ngʼolu Musengwa gamulagira. ");
INSERT INTO nuj_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ngʼaŋamba ebbaafu ayitengeha ŋagati wʼEweema eyʼOhwagananirangamo ko nʼehituuti, ngʼahena ayijuhamo amaaji agʼohusaabanga. ");
INSERT INTO nuj_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musa nʼAlooni nʼabasaani babe, basaabirangamo engalo nʼamagulu, ");
INSERT INTO nuj_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","hiisi olu bengiranga mu Weema eyʼOhwagananirangamo oba batiina ŋa hituuti, ngʼolu Musengwa galagira Musa. ");
INSERT INTO nuj_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ngʼaŋo Musa ahola olunya ohweswanigirisa Eweema Enjawufu nʼehituuti era ngʼatimba olutimbe mu mulyango gwʼolunya. Nga ahena omulimo gugwe. ");
INSERT INTO nuj_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ngʼaŋo ehireri hiiha hiwiiha hu Weema eyʼOhwagananirangamo era eŋono lya Musengwa liijula Eweema Enjawufu. ");
INSERT INTO nuj_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa sigasobola hwengira mu Weema eyʼOhwagananirangamo olwohuba ehireri hyali hiyihireho era eŋono lya Musengwa liijula Eweema Enjawufu. ");
INSERT INTO nuj_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Mu lugendo lwʼAbayisirayiri lwosirwosi, olu ehireri hyedundanga ohuŋwa hu Weema Enjawufu, basimbuhanga batandiiha ohugenda. ");
INSERT INTO nuj_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Aye ehireri ni hitedundire, boosi sibahasimbuuye lugendo lwawe, ohwola oludaalo olu hyahedundire nga ko basimbula. ");
INSERT INTO nuj_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Olwʼehyo, ehireri hya Musengwa ohulaga ohubaŋo huhwe hyawiihanga hu Weema Enjawufu mu muusi, ngʼowiire omuliro guba mu hireri ehyo Abayisirayiri bosibosi ni babona. Hino hyaliŋo mu ngendo jaawe josijosi.");
INSERT INTO nuj_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Mu hitabo hino, mulimo ebiitu ebi Musa galoma Abayisirayiri ni bali mu lulafu, hu lubega lwʼebuŋwalyuba wʼolwabi Yoludaani. Baali mu hiiho wʼolwabi Yoludaani mu lulafu Arabba mu hifo ehi balanga baati Suufu, ŋagati wʼebibuga Parani ni Tofeli ni Labbaani ni Hazeroosi ni Dizahabbu. ");
INSERT INTO nuj_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Ohuŋwa e Horebbu ohutiina e Kadesi Bbaruneya, nʼobitire e Seyiri ehyalo ehyʼesozi, ŋaaliŋo olugendo lwʼendaalo ehumi nalulala. ");
INSERT INTO nuj_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Mu mwaha ogwamahumi ane hu ludaalo oludaayi mu mwesi ogwʼehumi namulala oluvanyuma lwʼohuŋwa e Misiri, nga Musa alomera Abayisirayiri byosibyosi ebi baŋambaho ebi Musengwa gamulagira. ");
INSERT INTO nuj_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Bino byaliŋo nʼahenire ohuŋangula Sihoni habaha wʼAbamooli owaali ni gehala e Hesibboni era Ogi habaha wʼe Bbasani ni gehala Asitaroosi nʼEdereeyi. ");
INSERT INTO nuj_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Abayisirayiri ni baali ebuŋwalyuba wʼolwabi Yoludaani mu hyalo hyʼe Mowaabbu, Musa gatandiha ohunyonyola amagambi ati, ");
INSERT INTO nuj_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“Ni huli hu lusozi Horebbu, Musengwa Hatonda weefe galoma ni neefe ati, ‘Ehiseera ehi mubaaye hu lusozi luno, hihena. ");
INSERT INTO nuj_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Ŋaahani mwinyohe, mweyongere nʼolugendo mutiine mu hyalo ehyʼesozi ehyʼAbamooli, nomu matwale gosigosi agaliriheene ehiiho hyʼolwabi Yoludaani mu Arabba ehyalo hyʼesozi, nomu hitundu hyʼebugwalyuba, ni Negevu era nʼohwigobo lyʼenyanja Meditereniani. Mutiine mu hyalo hyʼAbakanani, nʼe Lebbanooni ohwolera erala hu Yufuleeti olwabi olubbala. ");
INSERT INTO nuj_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Mbaŋaaye ehyalo hino hyosihyosi. Mutiine muŋambe emiŋuluko olwohuba njʼehyalo ehi Musengwa galayira ati aja huŋa Yibbulayimu ni Yisaka ni Yakobbo abasehulu benywe ko nʼabejuhulu baawe.’ ” ");
INSERT INTO nuj_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Nga Musa geyongera aloma ati, “Sisobola hubatangirira seŋene. ");
INSERT INTO nuj_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Musengwa Hatonda wenywe abahiise era muli bangi, ŋaahani muli bangi hyʼemunyeenye hwigulu. ");
INSERT INTO nuj_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Musengwa Hatonda wʼabasehulu benywe, geyongere ohubaasa emirundi lukumi ohuhiraho aŋo era abaŋe ekabi ngʼolu gasuubisa. ");
INSERT INTO nuj_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","“Aye ese seŋene sisobola hwetwiha ebigosi nʼemigugu ko nʼohwemulugunya hwenywe. ");
INSERT INTO nuj_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Olwʼehyo, sunayo abasinde ohuŋwa mu biha byenywe abagesi, abategeefu era aba baatu baŋa eŋono, mbafuule batangirisi benywe ohulamulanga esonga hyʼejo. ");
INSERT INTO nuj_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","“Nga mungobolamo muuti, ‘Otehiise bulaŋi.’ ");
INSERT INTO nuj_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","“Olwʼehyo, naŋamba abasinde abagesi era aba baatu baŋa eŋono ohuŋwa mu biha byenywe nabaŋa ohuba abatangirisi benywe, ohutangirira ebibbubbu ebyʼabaatu olukumi lukumi, nʼecikumi cikumi nʼataanu ataanu ko nʼehumi ehumi. ");
INSERT INTO nuj_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Era mu hiseera ehyo nalabbira abatangirisi benywe abo ti, ‘Muŋulirisenga esonga jʼabaganda benywe era mujisalenga ni mutehubbira, wayire omusango guba ŋagati wʼabaganda benywe Abayisirayiri hu Bayisirayiri oba Omuyisirayiri nʼOmulugendwa. ");
INSERT INTO nuj_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Simwehubbiranga mu sala yenywe eyʼemisango. Muŋulirisenga abagadi nʼabaŋinda aŋaŋuma husosola. Simutyanga muutu yesiyesi ni musala emisango, olwohuba muja hujisalanga hu lwʼobuŋangi wa Hatonda. Ne esonga engosi, muyipindihiranga nayiholaho.’ ");
INSERT INTO nuj_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Era mu hiseera ehyo, nabalomera byosibyosi ebi mwali ni muli nʼohuhola.” ");
INSERT INTO nuj_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Nga Musa geyongera aloma ati, “Ngʼolu Musengwa Hatonda weefe gatulagira, hwaŋwa e Horebbu nga hutiina mu hyalo ehyʼesozi ehyʼAbamooli mu lulafu olubbala lwosirwosi era olutiisa, ngʼolu mwabona nga hwola e Kadesi Bbaruneya. ");
INSERT INTO nuj_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Nga mbaloma ti ‘Mwolire mu hyalo ehyʼesozi ehyʼAbamooli, ehi Musengwa Hatonda weefe, ali hutuŋa. ");
INSERT INTO nuj_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Musengwa Hatonda wuwo ahuŋaaye ehyalo ehyo otiine oŋambe emiŋuluko ngʼolu Musengwa Hatonda wʼabasehulu babo gahuloma. Otatya era otaŋwamo maani.’ ");
INSERT INTO nuj_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","“Ngʼaŋo mwesimwesi muuja eyi ndi mundoma muuti, ‘Hweherere hutumeyo embega batuhetere ehyalo ehyo, bagobole batulomere engira eyʼohubitamo era batulomere nʼebibuga byayo ngʼolu biri.’ ");
INSERT INTO nuj_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","“Ehyo hyali hiraŋi. Nga tobola mu enywe abasinde ehumi nʼababiri, mulala mulala ohuŋwa mu hiisi hiha. ");
INSERT INTO nuj_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Abasinde abo batiina mu hyalo ehyʼesozi, nga boola paka mu hiiho hyʼEsukoli, nga baheeta. ");
INSERT INTO nuj_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Era banogaho hu bibala ebyomu hyalo ehyo, nga bagobola ni nabyo. Nga batulomera baati, ‘Ehyalo ehi Musengwa Hatonda weefe ali hutuŋa, hiraŋi.’ ");
INSERT INTO nuj_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“Aye enywe mwajeemera ehiragiro hya Musengwa Hatonda wenywe, nga mugaana ohutiina ohuŋamba emiŋuluko. ");
INSERT INTO nuj_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Nga mwemulugunyira mu weema jenywe muuti, ‘Musengwa satwenda cʼehyagira gaatutusa e Misiri, ohutuŋaayo eyiri Abamooli batusihiirise. ");
INSERT INTO nuj_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Ehyalo ehi hutiinamo, nga hyamafa! Abahyefe batuheniremo amaani, baloma baati, “Abaatu baayo bʼamaani era baleeŋi ohutuhiraho. Ebibuga byawe bigalamu era babitongoleraho olukomera oluleeŋi ohwola mwigulu. Era hwabonayo nʼabejuhulu ba Anaki.” ’ ");
INSERT INTO nuj_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","“Ngʼaŋo ese mbaloma ti, ‘Mutaŋwamo maani era mutabatya. ");
INSERT INTO nuj_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Musengwa Hatonda wenywe abatangiriyemo, aja hubasoolerera ngʼolu mwabona byosibyosi ebi gabaholera e Misiri, ");
INSERT INTO nuj_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","nomu lulafu. Era wabona engeri eyi Musengwa Hatonda wuwo gahugegamo hiisi ŋaatu mu lulafu ohwola ŋano ngʼolu musaaye agegamo omwana wuwe.’ ");
INSERT INTO nuj_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","“Aye wayire nabahebulisa ebyo byosibyosi, mwagaana ohwesiga Musengwa Hatonda wenywe, ");
INSERT INTO nuj_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","owabatangiriranga mu lugendo lwenywe nʼomuliro owiire, nʼehireri mu muusi, ohubalaga ehifo aŋʼohwemeha eweema jenywe era nʼohubalaga engira eyʼohubitamo. ");
INSERT INTO nuj_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","“Era Musengwa ni gaŋulira ebi mwaloma, gabaluŋira era ngʼalayira ati, ");
INSERT INTO nuj_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘Ŋaŋuma muutu yesiyesi hu bʼomulembe omubi guno alisuna omuŋuluko hu hyalo ehiraŋi ehyo ehi neerayirira ohuŋa abasehulu benywe, ");
INSERT INTO nuj_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","ohutusaho Kalebbu omwana wa Yefune. Nja humuŋa niye nʼabolulyo lulwe omuŋuluko hwiroba eri galambuula olwohuba gagondera Musengwa nʼomwoyo mulala.’ ");
INSERT INTO nuj_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","“Era Musengwa keesi ganduŋira olwenywe, ngʼandoma ati, ‘Sooja hwola mu hyalo ehyo. ");
INSERT INTO nuj_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Ne omuloobera wuwo Yoswa omusaani wa Nuuni, njʼolihingira. Kale mugoboseemo amaani olwohuba alitangirira Abayisirayiri ohubaŋira ohusikira ehyalo ehyo. ");
INSERT INTO nuj_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Era nʼabaana benywe abamwaloma muuti baja hubaŋira mu buŋaŋanguse, abaana abatasobola hwawulaŋo ehiraŋi nʼehibi, njʼabaja hutiina mu hyalo ehyo. Era nja hubaŋa emiŋuluko. ");
INSERT INTO nuj_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Aye enywe mucuuhe mugende ni mugobola mu lulafu, ni muŋambire engira eyitiina hu Nyanja Enando.’ ");
INSERT INTO nuj_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","“Nga mugobolamo muuti, ‘Hwonoonire mu moni ja Musengwa. Ŋaahani ha hutiine husoole nʼabalabe ngʼolu Musengwa Hatonda weefe gatulagira.’ Ngʼaŋo hiisi muutu gambala ebyohusoosa bibye, ni muŋeega muuti hyangu ohuwaagala abaatu abomu hyalo ehyʼesozi. ");
INSERT INTO nuj_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","“Aye Musengwa gandoma mbalome ti, ‘Mutatiina, olwohuba sinja hutiina ni nenywe. Abalabe benywe baja hubaŋangula.’ ");
INSERT INTO nuj_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Nga mbalomera ebiitu ebyo aye simwaŋulirisa. Mwajeemera ehiragiro hya Musengwa era olwʼembaha jenywe, mwalumba abaatu abomu hyalo ehyʼesozi. ");
INSERT INTO nuj_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Ngʼaŋo Abamooli abomu hyalo ehyo ehyʼesozi, baŋwayo hyʼenjuhi babafulumusa, bababbinga ohuŋwa e Seyiri mu hyalo ehyʼesozi baboohesa erala e Horuma. ");
INSERT INTO nuj_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Ni mwagobola, mwaliririra Musengwa abayeede, ne sigabafaho. ");
INSERT INTO nuj_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Ehyo hyabaŋweramo ohumenya e Kadesi ehiseera ehyene ehireeŋi.” ");
INSERT INTO nuj_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Nga Musa geyongera aloma ati, “Oluvanyuma hwacuuha hwagama mu lulafu, hwaŋamba engira eyitiina hu Nyanja Enando ngʼolu Musengwa gandagira. Era hwahena ehiseera ehireeŋi ni hwetoloolera e Seyiri mu hyalo ehyʼesozi. ");
INSERT INTO nuj_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","“Oluvanyuma nga Musengwa gandoma ati, ");
INSERT INTO nuj_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‘Muhenire ehiseera hibbala ni mwetoololera mu hyalo hino ehyʼesozi. Ŋaahani mucuuhe mugende ni mutiina engulu.’ ");
INSERT INTO nuj_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Era Musengwa nga gandoma ati, ‘Ŋa abaatu ebiragiro bino oti: “Muli huupi hubita mu hyalo hya balebe benywe, abejuhulu bʼEsawu, abamenyire mu Seyiri. Abaatu abo baja huba beralihirifu olwenywe aye mumanya ");
INSERT INTO nuj_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","mutabasoosa, olwohuba sinja hubaŋa hitundu wayire hirala ehyʼohugulu hwiroba lyawe. Hiri hiityo olwohuba olusozi Seyiri naluŋa Esawu ohuba omuŋuluko gugwe. ");
INSERT INTO nuj_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Era ni munendenga emere nʼamaaji, munabibagulengaho bugule nʼebbeesa. ");
INSERT INTO nuj_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Musengwa Hatonda wuwo, ahuŋaaye ekabi mu hiisi hiitu ehi ohola. Ahulabiriiye mu lugendo lulwo mu lulafu era abaaye ŋalala ni neewe emyaha amahumi ane emihwiye ni ŋaŋuma nʼehi odamba kadi hirala.” ’ ");
INSERT INTO nuj_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","“Olwʼehyo, hwatiina hwabita hubita hu balebe beefe abejuhulu bʼEsawu, abamenyire mu Seyiri. Hwaleha engira eyitiina mu lulafu Arabba, ni yiŋwa Elati nʼEziyoni Gebberi, hwacuuha hwabita mu ngira eyomu lulafu lwʼe Mowaabbu. ");
INSERT INTO nuj_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","“Ngʼaŋo Musengwa gandoma ati, ‘Muteegula lutalo hu baatu bʼe Mowaabbu olwohuba enywe sinja hubaŋaaho wayire ahatundu hwiroba lyawe ohuba omuŋuluko gugwe. Hiri hiityo olwohuba ehibuga Ari nahena hale ohuhiŋa abejuhulu ba Luuti ohuba emiŋuluko jaawe.’ ” ");
INSERT INTO nuj_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Musengwa ni gaali nʼahiiri huŋa Abamowaabbu ehyalo ehyo, hyamenyangamo eduuli lyʼabaatu abʼamaani. Abaatu abo baali babalanga baati Ababbeemi era ni bali baleeŋi hyʼAbanaki. ");
INSERT INTO nuj_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Abanaki balanganga abaatu abo baati Abareefa, ne Abamowaabbu nibo babalanganga baati Babbeemi. ");
INSERT INTO nuj_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Abakooli njʼabeherera ohumenya mu Seyiri. Aye abejuhulu ba Esawu bababbingamo nga bamenya mu hifo ehyo era babasihiirisa ngʼolu Abayisirayiri baahola abaatu abaali ni bamenya mu hyalo ehi Musengwa gabaŋa ohuba emiŋuluko. ");
INSERT INTO nuj_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","“Nga Musengwa aloma ati, ‘Ŋaahani mwambuhe ehiiho hyʼe Zeredi.’ Nga hwambuha olwabi olwo. ");
INSERT INTO nuj_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","“Emyaha adatu namunaana jabitaŋo ohuŋwa olu hwaŋwa e Kadesi Bbaruneya, ohwola olu hwambuha ehiiho hyʼe Zeredi. Abasinde bosibosi abʼomulembe ogwo abaali ni basobola ohusoola, baali bafuuye ni baŋooyeŋo ngʼolu Musengwa gaberayirira. ");
INSERT INTO nuj_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Musengwa gabasoosa ohwola olu gabasihiirisa gabaheneraŋo erala. ");
INSERT INTO nuj_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","“Ŋaahani abasembayo hu basooli abo bosibosi ni bafa, ");
INSERT INTO nuj_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","nga Musengwa gandoma ati, ");
INSERT INTO nuj_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‘Olwaleero mutiine mubite mu twale lyʼe Mowaabbu aŋaapi nʼehibuga Ari. ");
INSERT INTO nuj_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Ni mwola mu hyalo hyʼAbamooni, mutabalomaho oba hubasoosa olwohuba sinja hubaŋa wayire hatundu hadyagala hu hyalo hyawe olwohuba ehyalo ehyo, nahiŋa abejuhulu ba Luuti ohuba obusika waawe.’ ” ");
INSERT INTO nuj_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Ehyalo ehyo bahiŋiranga ohuba hyʼAbareefa abaali ni bamenyamo. Aye Abamooni babalanga baati Bazamuzumayiti. ");
INSERT INTO nuj_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Abareefa baali bʼamaani era bangi era ni bali baleeŋi hyʼAbanaki. Aye Musengwa gabasihiirisa nʼatambisa Abamooni, bababbinga mu hyalo ehyo nga bahena bamenyamo. ");
INSERT INTO nuj_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Mu ngeri njʼenyene, Musengwa gayeeda abejuhulu bʼEsawu gasihiirisa Abakooli abaali ni bamenya e Seyiri. Era abejuhulu bʼEsawu abo bamenya mu hyalo ehyo nʼohwola hatyane. ");
INSERT INTO nuj_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Era Abakafutooli ohuŋwa e Kureete, basihiirisa Abaavi abaali ni bamenya mu bitehere ebyo ohuŋwa hu nyanja ohwolera erala e Gaaza, nga bahena bamenyamo. ");
INSERT INTO nuj_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Musa geyongera galoma ati, “Ni hwahena ohubita e Mowaabbu, Musengwa galoma ati, ‘Mutiine mu hiiho hyʼolwabi Arunooni mwambuhe, olwohuba mbaŋaaye Sihoni Omwamooli habaha wʼe Hesibboni nʼegwanga lirye mu buŋangi wenywe, mumwiguleho olutalo. Mutandihe ohuŋira ehyalo hihye ngʼemiŋuluko. ");
INSERT INTO nuj_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Ohuŋwa olwa leero luno, amawanga gosigosi hu hyalo gaja hubatya olwʼetiisa eyi nja hubataaho. Baja huŋulira efuma yenywe, baja huteetemanga era beŋendeherere hu lwenywe.’ ” ");
INSERT INTO nuj_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Musa geyongera galoma ati, “Ni hwali mu lulafu lwʼe Kedemoosi, natuma abahwenda eyiri Sihoni habaha wʼe Hesibboni ni nenda ŋabeŋo emiyaaya ŋagati weefe ni nabo ni muloma ti, ");
INSERT INTO nuj_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‘Tufugiirire hubite mu hyalo hihyo. Huja hubita ngira hyoŋene, ni ŋaŋuma humagamaga eyi ni neeyi. ");
INSERT INTO nuj_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Huja hugula hugula emere nʼamaaji. Huhusunga otufugiirire hubite mu hyalo hihyo, ");
INSERT INTO nuj_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","ngʼolu bejuhulu bʼEsawu mu hyalo hyʼe Seyiri nʼAbamowaabbu mu hyalo hyʼAri batufugiirira hwabita mu hyalo hyawe. Hwenda hutiine hwambuhe olwabi Yoludaani, hwingire mu hyalo ehi Musengwa Hatonda weefe ali hutuŋa.’ ");
INSERT INTO nuj_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","“Cooka Sihoni habaha wʼe Hesibboni gatugaana ohubita mu hyalo hihye, olwohuba Musengwa Hatonda wuwo gamuhahanyasa omwoyo era gaali mujeemu. Ehyo Hatonda gahihola ko hwahaŋangula habaha oyo. ");
INSERT INTO nuj_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","“Nga Musengwa gandoma ati, ‘Tandihire ohubaŋa Sihoni nʼegwanga lirye. Ŋaahani, mutiine muŋangule ehyalo ehyo, muhiŋire hibe miŋuluko jenywe.’ ");
INSERT INTO nuj_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","“Sihoni nʼabasirikale babe bosibosi ni batulumba e Yahazi ohutusoosa, ");
INSERT INTO nuj_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Musengwa Hatonda weefe gamutuŋa nʼabasaani babe ko nʼabasirikale babe bosibosi, hwabaŋangula. ");
INSERT INTO nuj_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Era mu hiseera ehyo, hwasihiirisa ebibuga bibye byosibyosi: abaatu bosibosi, abasinde nʼabahasi ko nʼabaana. Ŋaŋuma muutu yesiyesi owaŋona. ");
INSERT INTO nuj_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Aye hwaŋira eŋombe ŋalala nʼebiitu ebi hwanyaga mu bibuga ebyo. ");
INSERT INTO nuj_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","“Ohuŋwa hu Aroweeri mu hiiho Arunooni, nʼehibuga ehiri mu hiiho ehyo ohwolera erala e Giliyaadi, ŋaŋuma hibuga hyosihyosi ehyatuhayisa. Byosibyosi Musengwa Hatonda weefe gabituŋa hwabiŋangula. ");
INSERT INTO nuj_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Aye olwʼehiragiro hya Musengwa Hatonda weefe, simwatiina ŋaapi nʼeroba lyʼAbamooni, oba eryohwigobo wʼolwabi Yabboki oba ebibuga ebyomu hyalo ehyʼesozi.” ");
INSERT INTO nuj_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Nga Musa geyongera aloma ati, “Ni hwahena ohuŋangula habaha Sihoni, hwacuuha hwaŋamba engira eyitiina e Bbasani. Nga Ogi habaha wʼegwanga lyʼe Bbasani aŋwayo nʼeŋe lirye lyosiryosi batulumba Edereeyi. ");
INSERT INTO nuj_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Ngʼaŋo Musengwa gandoma ati, ‘Otatya Ogi olwohuba muŋayeyo nʼabaatu babe bosibosi nʼehyalo hihye, mu buŋangi wuwo. Musihiirise ngʼolu wasihiirisa Sihoni habaha wʼAbamooli e Hesibboni.’ ");
INSERT INTO nuj_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","“Nga Musengwa Hatonda weefe atuŋa Ogi habaha wʼe Bbasani nʼeŋe lirye lyosiryosi. Hwabasihiirisa bosibosi era ŋaŋuma wayire mulala hu bo, owatuŋona. ");
INSERT INTO nuj_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Mu hiseera ehyo, hwaŋangula etwale lyosiryosi erya Arugobbu era mwalimo ebibuga nkaaga mu wa habaha wa Ogi owʼe Bbasani. Era ŋaŋuma wayire hibuga hirala ehi hutaŋamba. ");
INSERT INTO nuj_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Ebibuga ebyo byosibyosi baali babitongoleraho olukomera olwene oluleeŋi, nʼebihiihiro ko nʼenjigi ejʼebyoma. Era hwaŋamba nʼebitehere bingi ebyaŋumaho olukomera. ");
INSERT INTO nuj_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Hwasihiirihisa erala owahabaha wa Ogi ngʼolu hwasihiirisa Sihoni habaha wʼe Hesibboni. Hwasihiirisa ebibuga byosibyosi ko nʼabaatu: abasinde nʼabahasi nʼabaana. ");
INSERT INTO nuj_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Aye hwanyaga ebyayo byosibyosi nʼebiitu ebyali mu bibuga ebyo. ");
INSERT INTO nuj_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","“Sihoni ni Ogi baali baŋuga Abamooli ababanga ebuŋwalyuba wa Yoludaani. Amatwale gaawe gaali gaŋwa mu hiiho hyʼolwabi Arunooni ohwola engulu hu lusozi Herumooni. Hwaŋamba amatwale ago gosigosi. ");
INSERT INTO nuj_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","Abasidoni balanga olusozi Herumooni baati Siryoni aye Abamooli balulanga baati Seniri. ");
INSERT INTO nuj_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Hwaŋamba ebibuga byosibyosi ebyali aŋagwalaali hu sozi nʼamatwale agʼe Giliyaadi nʼe Bbasani, ohwolera erala mu bibuga byʼe Saleka nʼEdereeyi, ebyali birala hu bibuga bya Ogi habaha wʼe Bbasani. ");
INSERT INTO nuj_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Ogi habaha wʼe Bbasani gaali nje yeŋene owaali nʼasigayeŋo hu Bareefa. Ehitanda hihye hyali hyʼehyoma era obuleeŋi hyali hya fuuti ehumi nedatu, obugalamu hyali efuuti mukaaga. Nʼohwola hatyane, ehitanda ehyo hihiiriŋo mu Raabba ehibuga hyʼAbamooni. ");
INSERT INTO nuj_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","“Ni hwaŋamba ehyalo hyʼe Aroweeri, ehiri hutulo wʼehiiho hyʼolwabi Arunooni, nʼehitundu ehyomu sozi ejʼe Giliyaadi, nʼebibuga byamo, nahiŋa abaatu abomu hiha hya Lubbeeni ni Gaadi. ");
INSERT INTO nuj_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Ehitundu hya Giliyaadi ehyasigalaŋo ko ni Bbasani hyosihyosi, mu owahabaha wa Ogi, nahiŋa ehitundu hyʼehiha hya Manase. Etwale lya Arugobbu lyosiryosi mu Bbasani baliranganga hyalo hyʼAbareefa. ");
INSERT INTO nuj_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Yayiri ohuŋwa mu hiha hya Manase gaŋira etwale lya Arugobbu lyosiryosi eryomu Bbasani ohwolera erala hu salo yʼAbagesuri ko nʼAbamaaka. Ebyalo ebyo byosibyosi gabiguliha esiina lirye era ebibuga ebyo babiranga baati ebibuga bya Yayiri nʼohwola hatyane. ");
INSERT INTO nuj_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Ehiha hya Makiri nahiŋa Giliyaadi. ");
INSERT INTO nuj_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Ne naŋa abʼehiha hya Lubbeeni ni Gaadi ehitundu hyʼetwale lyʼe Giliyaadi. Nabaŋa ohuŋwa mu hiiho Arunooni ohwola hu lwabi Yabboki hu salo nʼAbamooni. ");
INSERT INTO nuj_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Hu luuyi lwʼebuŋwalyuba, abaatu bomu hiha hya Lubbeeni ni Gaadi baali bahoma hu lwabi Yoludaani, ohuŋwa hu nyanja yʼe Galilaaya ohwihirira erala hu Nyanja Eŋumamo Ehiramu, ohwola ebugwalyuba wʼehiiho ngʼolusozi Pisiga. ");
INSERT INTO nuj_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","“Mu hiseera ehyo, naloma abaatu bomu biha bya Lubbbeeni ni Gaadi ko nʼehitundu hya Manase ti, ‘Musengwa Hatonda wenywe abaŋaaye ehyalo hino. Olwʼehyo, abasooli bosibosi, baŋambe ebisoosa bambuhe Yoludaani batangiriremo abaganda baawe Abayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Aye abahasi nʼabaana benywe nʼebyayo byenywe ebi muli ninabyo ebingi, bisigale mu bibuga ebi naabaŋa. ");
INSERT INTO nuj_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Muyeede abaganda benywe ohusuna obusika waawe boosi baŋire eroba eri Musengwa Hatonda wenywe ali hubaŋa engereha wʼebugwalyuba wa Yoludaani. Oluvanyuma, hiisi muutu aja hwagamayo hu muŋuluko gugwe Abayisirayiri bahye ni bahenire ohuŋangula abalabe baawe.’ ");
INSERT INTO nuj_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","“Mu hiseera ehyo, naloma Yoswa ti, ‘Weboneyeeho nʼemoni, byosibyosi ebi Musengwa Hatonda wenywe gaahola abahabaha bala ababiri. Era Musengwa aja huhola atyo abahabaha abandi aba oja huwaagala. ");
INSERT INTO nuj_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Olwʼehyo, mutabatya olwohuba Musengwa Hatonda wenywe, aja hubasoolera.’ ");
INSERT INTO nuj_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","“Mu hiseera ehyo negayirira Musengwa ti, ");
INSERT INTO nuj_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‘O Musengwa Omwene Buŋangi otandihire ohulaga omuŋeeresa wuwo amaani. Eŋuma hatonda owundi mwigulu oba hu hyalo asobola ohuhola ebyʼamaani nʼebyamaliholiho ebi ohola. ");
INSERT INTO nuj_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Kusunga wufugiirire tiine engereha wa Yoludaani mu hyalo ehiraŋi ehyʼesozi ni Lebbanooni.’ ");
INSERT INTO nuj_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","“Aye Musengwa ganduŋira olwenywe, sigapuliirisa. Gandoma ati, ‘Ehyo sohiromangaho nindi. ");
INSERT INTO nuj_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Tiina hu lusozi Pisiga, oheje ebuŋwalyuba ko nʼebugwalyuba, mu maniino ko nomu mehiriro. Webonereho eroba olwohuba sooja hwambuha lwabi luno Yoludaani. ");
INSERT INTO nuj_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Aye laabbira Yoswa era omugumye, olwohuba nje aja hwambuha gatangirira abaatu bano ohusuna eroba eri oja hulengera.’ ");
INSERT INTO nuj_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Kale hwamenya mu hiiho ŋaapi nʼehibuga Bbesi Pewori.” ");
INSERT INTO nuj_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Nga Musa geyongera aloma ati, “Tega ohutwi ewe Yisirayiri oŋulire amagambi nʼebiragiro ebi kusomesa. Obigonderenga ko obe nʼobulamu era ko wahengira mu hyalo ehi Musengwa Hatonda wʼabasehulu babo, alihuhuŋa ngʼomuŋuluko. ");
INSERT INTO nuj_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Siwongerangaho oba sotusangaho hu biragiro ebi kuŋa. Ogonderanga Musengwa Hatonda wenywe. ");
INSERT INTO nuj_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","“Hiri hiityo olwohuba mwabeene mweboneraho nʼemoni jenywe, olu Musengwa Hatonda wenywe gasihiirisa hiisi oyo owajumirya Bbaali hu sozi Pewori. ");
INSERT INTO nuj_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Aye hiisi mulala hu enywe mwesimwesi abaali abesigwa eyiri Musengwa Hatonda wenywe, muhiiri balamu nʼohwola hatyane. ");
INSERT INTO nuj_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","“Nabasomesa amagambi nʼebiragiro ngʼolu Musengwa Hatonda wange gandagira. Mubiŋambanga ni muli mu hyalo ehi mutiina ohuŋira ohuba emiŋuluko. ");
INSERT INTO nuj_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Mubiŋambanga nʼohwegenderesa era ehyo hiija hulaga abaatu abʼamawanga agandi ti muli nʼamagesi era mutegeera. Era ni banaŋulirenga amagambi ago gosigosi, baja huloma baati, ‘Mu butuufu, abaatu bano bʼamaani, bamagesi era bategeera.’ ");
INSERT INTO nuj_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Era eŋuma gwanga erindi eryʼamaani eriri ni hatonda hya Musengwa Hatonda weefe ali huupi ni neefe hiisi olu humusunga. ");
INSERT INTO nuj_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Era gwanga hi eryʼamaani eriri nʼebiragiro ebyawufu nʼamagambi hya gandi hubaŋa olwa leero luno? ");
INSERT INTO nuj_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","“Ohutusaho mwehuume! Mwegenderesenga ohutebirira ebi mwabeene mweboneraho. Mutaleha biitu ebyo ohubaŋwa mu biŋeego byenywe era mubiromeranga abaana nʼabejuhulu benywe. ");
INSERT INTO nuj_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Siwibiriranga oludaalo olu wemeerera mu moni ja Musengwa Hatonda wuwo hu lusozi Horebbu, eyi gandoma ati, ‘Ndangire abaatu, baaje, samwene nja huloma ni nabo. Baja hwega ohuutyanga endaalo josijosi ejʼobulamu waawe era balisomesa nʼabaana baawe ohuutyanga.’ ");
INSERT INTO nuj_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","“Mwegerera mwemeerera huupi nʼolusozi olu muliro gwaduha ohuŋwa mu lusozi, eriisi lyatumbiira ŋamugulu. Ebireri ebimali zigizigi nʼehiirema byawiha hu lusozi. ");
INSERT INTO nuj_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Era Musengwa galoma ni nenywe naali mu muliro. Mwaŋulira ejanjaasi lirye lyoŋene aye simwamubona omwene ngʼolu afaana. ");
INSERT INTO nuj_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Gabaloma nʼalangirira ebi muli nʼohuholanga ohwoheresa endagaano yiye, Amagambi Ehumi aga gaŋandiiha hu bipande bibiri ebyʼamabaale. ");
INSERT INTO nuj_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Musengwa gandagira mu hiseera ehyo ohubasomesa amagambi aga muli nʼohugonderanga mu hyalo eyi mutiina ohwingira ohuba omuŋuluko gwenywe. ");
INSERT INTO nuj_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“Hu ludaalo olu Musengwa galoma ni nenywe mu muliro hu lusozi Horebbu, simwabona ngʼolu afaana olwʼehyo, mwegenderesenga bugali. ");
INSERT INTO nuj_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","Kale mwegenderese mutonoona mwebajira ebitali hatonda mu hifaanani hyʼomuutu yesiyesi omusinde oba omuhasi, ");
INSERT INTO nuj_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","ehyʼesolo oba ehyʼenyuni eyʼamabaŋa eyiguluha mu bbanga, ");
INSERT INTO nuj_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","oba ehyʼehiitu hyosihyosi ehyeŋalula hwiroba oba ehiri hyʼenyeeni mu maaji. ");
INSERT INTO nuj_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Oba wahejanga ŋamugulu wabona eryuba nʼomwesi ko nʼemunyeenye, byosibyosi ebyo ebiri mu bbanga, byahusendasenda ohubijumirya, ebiitu ebi Musengwa Hatonda wuwo gateeraŋo abaatu bosibosi abali hu hyalo. ");
INSERT INTO nuj_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Aye muhebuliranga muuti Musengwa gabanunula ohuŋwa mu muliro mu hyalo hyʼe Misiri, abafuule baatu babe ngʼolu muli ŋaahani. ");
INSERT INTO nuj_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","“Aye Musengwa ganduŋira hu lwenywe era galayira ati sinja hwambuha lwabi Yoludaani ohwingira mu hyalo ehiraŋi ehi Musengwa Hatonda wenywe abaŋa ohuba omuŋuluko. ");
INSERT INTO nuj_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Muja hwambuha olwabi Yoludaani mutiine mu hyalo ehyo ehiraŋi aye ese nja hufiira ŋano. Ne enywe muuja hwambuha mutiine mwesunire ehyalo ehyo, ohuba omuŋuluko gwenywe. ");
INSERT INTO nuj_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Mwenenekeresanga ohutebirira endagaano eyi Musengwa Hatonda wenywe gaahola ni nenywe, nga mwehwolera ehitali hatonda hyosihyosi, ehi Musengwa Hatonda wuwo gahugaana. ");
INSERT INTO nuj_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Hiri hiityo olwohuba Musengwa Hatonda wuwo ali hyʼomuliro ogusihiirisa era ali nʼewuba. ");
INSERT INTO nuj_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","“Ni muliba ni muhenire ebbanga ereeŋi mu hyalo ehyo, ni musaaye nʼabaana era ni muli nʼabejuhulu, simugesyangaho mwonoona ni mwehwolera ebibbote byosibyosi. Ehyo hibi mu moni ja Musengwa Hatonda wuwo era hija humusunguŋasa. ");
INSERT INTO nuj_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","Olwʼehyo, ndanga egulu nʼehyalo ohuba mujulizi olwa leero ti singa mubbwaga endagaano, muja husihiiriha mu hiseera hitono bugali, muŋwereŋo erala hu hyalo engereha wa Yoludaani eyi muli huupi hutiina ohusuna omuŋuluko. Simuja humenyamo ebbanga ereeŋi, muja husihiiriha muŋwereŋo erala. ");
INSERT INTO nuj_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Musengwa alibasasaania mu mawanga agandi era batono abaliŋona. ");
INSERT INTO nuj_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Mu mawanga eyo, muja hujumirya ebibbote ohuŋwa mu mbaawo nʼamabaale, abahatonda abatabona wayire ohuŋulira era abatalya wayire ohuŋunyira. ");
INSERT INTO nuj_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Aye nʼoli eyo, olyendula Musengwa Hatonda wuwo. Era nʼolimwendula nʼomwoyo gugwo gwosigwosi nʼobulamu wuwo wosiwosi, oja humubona. ");
INSERT INTO nuj_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","“Era nʼoliba mu bulumi mu ndaalo ejʼoluvanyuma, nʼobonaabona, oja hugobola eyiri Musengwa Hatonda wuwo, wagondera ebi ahuloma. ");
INSERT INTO nuj_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Hiri hiityo olwohuba Musengwa Hatonda wuwo, Hatonda wʼehisa. Saaja huhuhubba mugongo oba huhusihiirisa oba hwibirira endagaano eyi gahola nʼabasehulu babo. ");
INSERT INTO nuj_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","“Ale ni yendulirisa hu byafaayo ebiŋamba hu huŋwa Hatonda atonde omuutu hu hyalo. Obuuse hu hyalo hyosihyosi obanga ŋabaaye ŋabangaŋo ehiitu ehibba hyʼehino oba ŋaliŋo owaali nʼahiŋuliyeho. ");
INSERT INTO nuj_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Ŋalihuŋo egwanga eryali ni liŋuliiyeho ejanjaasi lya Hatonda nʼaloma ohuŋwa mu muliro, ngʼolu ewe waŋulira, wasigala nʼohiiri balamu? ");
INSERT INTO nuj_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Oba ŋaliŋo hatonda yesiyesi owaali nʼagehisyeho ohweŋirira egwanga ohuŋwa mu gwanga erindi nʼatambisa ebyamaliholiho nʼebyeŋunjisa nʼobuŋangi nʼolutalo nʼamaani nʼebitiisa ebyene ebingi, ngʼolu Musengwa Hatonda wenywe gaahola e Misiri ni mubona? ");
INSERT INTO nuj_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","“Musengwa gahulaga ebiitu ebyo wahamanya oti nje Hatonda yeŋene era ŋaŋuma owundi. ");
INSERT INTO nuj_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Waŋulira ejanjaasi lirye ohuŋwa mwigulu, ko waheega ohuba mugondi. Gahulaga omuliro gugwe ogwʼamaani, waŋulira ejanjaasi lirye ohuŋwa ŋagati mu muliro ogwo. ");
INSERT INTO nuj_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Olwʼohwenda abasehulu benywe, gatobolamo abejuhulu babo gabaŋa ekabi era gahutusa e Misiri nʼamaani gage amangi. ");
INSERT INTO nuj_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Gabbinga amawanga agahuhira obubbala nʼamaani, olwohuba gendire ohuhuŋa ehyalo hyawe ohuba muŋuluko gugo ngʼolu hiri ŋaahani. ");
INSERT INTO nuj_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","“Kale hino ohihebuliranga era ohihuume mu mwoyo gugwo, Musengwa nje Hatonda mwigulu ko nohu hyalo, eŋuma wundi. ");
INSERT INTO nuj_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Singa ohuumanga amagambi nʼebiragiro bibye, ebi kuŋa olwa leero, ebiitu byosibyosi binahutiinirenga bulaŋi, ewe nʼabaana babo. Era owangaalire mu hyalo ehi Musengwa Hatonda wuwo ahuŋa ohuba hihyo emirembe nʼemirembe.” ");
INSERT INTO nuj_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Ngʼaŋo Musa atobolamo ebibuga bidatu ebuŋwalyuba wʼolwabi Yoludaani ohuba ebyʼohweŋogomamo. ");
INSERT INTO nuj_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","Omuutu yesiyesi owahetire owahye nʼatagendereeye, ni ŋabaaye ni ŋaŋuma kayaana ŋagati waawe bombi, gahadulumiiye mu hirala hu bibuga ebyo, ohuŋonia obulamu wuwe. ");
INSERT INTO nuj_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Ebibuga ebyo byali Bbezeri mu lulafu aŋagwalaali, hu lwʼehiha hya Lubbeeni, ehibuga Ramosi mu twale lyʼe Giliyaadi hu lwʼehiha hya Gaadi. Ehibuga ehindi, hyali Golani mu twale lyʼe Bbasani, hu lwʼehiha hya Manase. ");
INSERT INTO nuj_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Huno njʼohulaabbira ohu Musa galaabbira Abayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Gano njʼamagambi nʼebiragiro ebi Musa gaŋa Abayisirayiri ni baŋwa e Misiri, ");
INSERT INTO nuj_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","ni baali mu hiiho ohuupi nʼehibuga hyʼe Bbesi Pewori, ebuŋwalyuba wʼolwabi Yoludaani. Egwanga eryo lyali lya Sihoni habaha wʼAbamooli, nʼaŋugira e Hesibboni, ne Musa nʼAbayisirayiri bamuŋangula ni baŋwa e Misiri. ");
INSERT INTO nuj_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Abayisirayiri baŋangula owahabaha owo ko nʼowa Ogi habaha wʼe Bbasani, abahabaha bombi abʼAbamooli, ebuŋwalyuba wa Yoludaani. ");
INSERT INTO nuj_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Abayisirayiri baŋangula ŋosiŋosi ohuŋwa hu hibuga Aroweeri hu hiteremuho wʼehiiho hyʼolwabi Arunooni, ohwolera erala hu lusozi Siriyooni, aŋandi olu balanga baati Herumooni. ");
INSERT INTO nuj_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","Era baŋangula nʼehyalo hyosihyosi ehyʼebuŋwalyuba wʼolwabi Yoludaani, ohwolera erala hu Nyanja Eŋumamo Hiramu, mu hiiho hyʼolusozi Pisiga. ");
INSERT INTO nuj_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Nga Musa alanga Abayisirayiri bosibosi abaloma ati, “Tega ohutwi ewe Yisirayiri, oŋulire amagambi nʼebiragiro ebi ndi hubaŋa olwa leero. Mugeege era muhene mubigonderenga. ");
INSERT INTO nuj_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","“Musengwa Hatonda weefe gahola endagaano ni neefe hu lusozi Horebbu. ");
INSERT INTO nuj_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Endagaano eyo, sigayihola nʼabasehulu beefe boŋene aye gayihola ni neefe hwesihwesi abahiiri abalamu. ");
INSERT INTO nuj_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Era hu lusozi olwo, Musengwa galoma ni nenywe moni hu moni, ejanjaasi lirye ni liŋwera ŋagati wʼomuliro. ");
INSERT INTO nuj_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Mu hiseera ehyo, naali muhwenda ŋagati wenywe ni Musengwa, ni mbalomera ebi Musengwa gaali nʼabaloma olwohuba mwali mutiiye omuliro hyabaloberehiise ohutiina hu lusozi. Era galoma ati, ");
INSERT INTO nuj_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“Ndiise Musengwa Hatonda wuwo owahutusa mu hyalo hyʼe Misiri, eyi waali nʼohola owiidu. ");
INSERT INTO nuj_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“Sojumiryanga abahatonda abandi ohutusaho ese. ");
INSERT INTO nuj_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","“Siwebajiranga hifaananyi ehyʼehiitu hyosihyosi ehyomwigulu, oba ehyohu hyalo oba ehyomu nyanja ŋaasi. ");
INSERT INTO nuj_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Sohubbiranga bifaananyi ebyo amafuha ohubijumirya, olwohuba ese Musengwa Hatonda wuwo ndi nʼewuba era mboneresa abaana nʼehijuhulu ehyohudatu nʼehyohune olwʼebibi byʼabasehulu babo abacaawa. ");
INSERT INTO nuj_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Aye ndaga ohwenda hwange ohubitiirifu eyiri abaatu aba hiisi mulembe abanyenda era abaŋamba ebiragiro byange. ");
INSERT INTO nuj_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","“Sotambisanga siina lyange mu binambulamo, olwohuba ese Musengwa Hatonda wuwo ndiboneresa hiisi muutu ajagiija esiina lyange. ");
INSERT INTO nuj_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","“Huumanga oludaalo olwa Sabbaato, ni luli lwawufu ngʼolu ese Musengwa Hatonda wuwo nahulagira. ");
INSERT INTO nuj_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Oli nʼendaalo mukaaga ejʼohuholeraho emirimo jijo. ");
INSERT INTO nuj_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","Aye oludaalo olwomusanvu lwa Sabbaato eyiri Musengwa Hatonda wuwo. Hu ludaalo olwo, ŋaŋumengaŋo muutu yesiyesi hu bomu mago gago aluholeraho omulimo gwosigwosi, ewe nʼabaana babo abaseere nʼabahaana nʼabeedu babo abasinde nʼabahasi, esaame jijo ni nasugirya jijo nʼebyayo bibyo ebindi byosibyosi, nʼabalugendwa abamenyire ni nenywe. Abeedu babo abasinde nʼabahasi bali nʼohuŋuumula hu ludaalo olwo hyʼewe. ");
INSERT INTO nuj_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Hebulira oti mwesi mwali beedu mu gwanga lyʼe Misiri, ndiise Musengwa Hatonda wuwo onahutusayo nʼobuŋangi era nʼamaani gange. Cʼehigira Musengwa Hatonda wuwo ahulagira ohuŋuumulanga hu ludaalo olwa Sabbaato. ");
INSERT INTO nuj_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","“Oŋanga lataawo ni maawo eŋono ngʼolu Musengwa Hatonda wuwo ahulagira, ko wahawangaala mu hyalo ehi alihuhuŋa. ");
INSERT INTO nuj_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","“Siwiitanga. ");
INSERT INTO nuj_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","“Soholanga buhwedi. ");
INSERT INTO nuj_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","“Siwiibanga. ");
INSERT INTO nuj_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","“Otabeŋeranga wahyo ehi ataholire. ");
INSERT INTO nuj_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","“Siwegombanga muhasi wabeene. Era siwegombanga nyumba yabeene, wayire eroba oba omwidu omusinde oba omuhasi oba esaame oba nasugirya oba ehiitu hyosihyosi ehyabeene. ");
INSERT INTO nuj_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","“Ebyo njʼebiragiro ebi Musengwa galangirira eyi muli mwesimwesi hu lusozi nʼejanjaasi eryʼamaani ohuŋwa mu muliro nʼebireri nʼehiirema ehimali ngungungu era sigongeraho bindi bbe. Mu hiseera ehyo, ebyo njʼebigaloma era gabiŋandiiha hu bipande bibiri ebyʼamabaale, ngʼahena abipambya. ");
INSERT INTO nuj_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","“Aye ni mwaŋulira ejanjaasi ni liŋwera mu hiirema era nʼolusozi ni lwaduha omuliro, abatangirisi nʼabahulu bʼebiha baaja eyi ndi. ");
INSERT INTO nuj_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Nga bandoma baati, ‘Musengwa Hatonda weefe atulagire eŋono nʼamaani gage era huŋuliiye ejanjaasi lirye ohuŋwa mu muliro. Olwaleero huweene huuti Hatonda asobola ohuloma ni neefe abaatu obuutu hwasigala ni huhiiriŋo balamu! ");
INSERT INTO nuj_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Aye ŋaahani hufiira hi? Omuliro ogwʼamaani guno, guja hutusihiirisa! Singa Musengwa Hatonda weefe aloma ni neefe nindi, huja hufa. Omuliro ogwo gunatusihiirise. ");
INSERT INTO nuj_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Ŋaliŋo owaali nʼaŋuliiye ejanjaasi lya Hatonda Omwene Bulamu ohuŋwa mu muliro, ngʼolu efe huŋuliiye, gasigala nʼahiiri mulamu? ");
INSERT INTO nuj_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Ewe tiina oŋuliirise ebi Musengwa Hatonda weefe atuloma, ogobole obe ndiiwe otulomera byosibyosi. Huja huŋulira era hubigondere.’ ");
INSERT INTO nuj_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","“Musengwa gaŋulira ohusunga hwenywe nga gandoma ati, ‘Puliiye ebi abaatu bahusungire era hiisi ehi balomire hiraŋi. ");
INSERT INTO nuj_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Singa babererera nʼomwoyo guutyo oguutya, bahuumanga ebiragiro byange byosibyosi! Singa baholanga baatyo, nibo nʼabejuhulu baawe bahali bulaŋi emirembe nʼemirembe! ");
INSERT INTO nuj_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Kale yagamayo obalome oti, “Mwagameyo mu weema jenywe.” ");
INSERT INTO nuj_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Aye ewe ba ŋano nja huhuŋa amagambi nʼebiragiro byange byosibyosi. Oli nʼohubasomesa ko bahabigondera mu hyalo ehi mbaŋa ohuba omuŋuluko gwawe.’ ” ");
INSERT INTO nuj_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Ngʼaŋo Musa aloma ati, “Mufubengaho bugali ohugondera ebiragiro byosibyosi ebi Musengwa Hatonda wenywe abalagira, ni ŋaŋuma hutangatanga. ");
INSERT INTO nuj_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Mugenderenga mu ngira eyi Musengwa Hatonda wenywe abalagira, ko mwahawangaalira mu hyalo ehi muja husuna ngʼomuŋuluko.” ");
INSERT INTO nuj_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Nga Musa geyongera aloma ati, “Gano njʼamagambi nʼohulabbira nʼebiragiro ebi Musengwa Hatonda wenywe gandagira ohubasomesa. Muli nʼohubigonderanga mu hyalo ehi muli huupi ohuŋira ngʼomuŋuluko. ");
INSERT INTO nuj_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Era ewe nʼabaana babo ko nʼabejuhulu, muli nʼohutyanga Musengwa Hatonda wuwo mu bulamu wuwo wosiwosi. Oja huwangaala singa onahuumenga amagambi nʼebiragiro bibye byosibyosi. ");
INSERT INTO nuj_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Tega ohutwi ewe Yisirayiri era wehuumenga obe mugondi ko byosibyosi bihutiinirenga bulaŋi era oja husaalagana ekasi nʼesinde mu hyalo ehituluha amabeere nʼomudugere ngʼolu Musengwa Hatonda wʼabasehulu babo, gahusuubisa. ");
INSERT INTO nuj_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","“Tega ohutwi ewe Yisirayiri, Musengwa Hatonda weefe, nje Musengwa mulala yeŋene. ");
INSERT INTO nuj_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Yendanga Musengwa Hatonda wuwo nʼomwoyo gugwo gwosigwosi nʼobulamu wuwo wosiwosi nʼamaani gago gosigosi. ");
INSERT INTO nuj_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Amagambi gano aga kuŋa olwa leero luno, sigahuŋwanga hu mwoyo. ");
INSERT INTO nuj_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Mugahebulisanga abaana benywe, mugalomengaho ni muli ŋango era nʼolu muba mu ngundo ni mugenda, ni mugalamiriye hu buliri era nolu muba ni mwenyohire. Ogasomesanga abaana babo. Ogabalomerangaho ni mwihaaye ŋango era nʼogendanga mu ngira, nʼogalamiriye hu buliri oba ni wenyohire. ");
INSERT INTO nuj_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Mugesidihenga hu mihono era mugetimbanga mu byeni byenywe ngʼahabonero ahohubahebulisanga. ");
INSERT INTO nuj_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Era mugaŋandiihanga hu myango jʼenjigi jʼenyumba jenywe. ");
INSERT INTO nuj_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","“Musengwa Hatonda wuwo gasuubisa olu galayirira abasehulu babo, Yibbulayimu ni Yisaka ni Yakobbo ohubaŋa ehyalo eyi ali huhuŋira. Ehyalo ehyo hirimo ebibuga ebibbala era ebiraŋi ebi otatongola. ");
INSERT INTO nuj_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","Enyumba jaayo, jijuuye ebiraŋi ebyʼengeri nʼengeri ebi mutamanyire eyi byaŋwa. Era muja hudaŋanga amaaji mu sobere eji mutayaba, nʼendimiro jʼemizabbibbu nʼemizayiti eji mutahoma. Ni muliryanga mweguta mu hyalo ehyo, ");
INSERT INTO nuj_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","mwegenderesanga mutebirira Musengwa owabanunula ohuŋwa mu hyalo hyʼe Misiri eyi mwaholanga owiidu. ");
INSERT INTO nuj_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Otyanga nje Musengwa Hatonda wuwo era omuŋeeresenga. Era nʼobanga ni weyama, otambisanga siina lirye lyoŋene. ");
INSERT INTO nuj_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","“Simujumiryanga bahatonda ababaliranwa benywe. ");
INSERT INTO nuj_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Hiri hiityo olwohuba Musengwa Hatonda wuwo, ali nʼewuba. Era ni oja hujumirya abahatonda abandi, Musengwa wuwo, aja huhuluŋira ahusihiirise ohuŋwa hu hyalo. ");
INSERT INTO nuj_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Sohemanga Musengwa Hatonda wenywe ngʼolu mwamuhema e Maasa. ");
INSERT INTO nuj_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Mufubengaho ohuhuuma amagambi nʼebiragiro ebi Musengwa Hatonda wenywe, gabaŋa. ");
INSERT INTO nuj_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Muholenga ebiitu ebituufu era ebiraŋi mu moni ja Musengwa, ko ebiitu bibatiinirenga bulaŋi. Era mutiine mu hyalo ehiraŋi ehi Musengwa galayirira abasehulu benywe ohuba emiŋuluko jenywe, ");
INSERT INTO nuj_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","era muja hubbinga abalabe benywe bosibosi ngʼolu Musengwa galoma. ");
INSERT INTO nuj_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","“Mu moni eyo, omwana wuwo nʼahubuusanga ati, ‘Amagambi nʼebiragiro ebyo byosibyosi ebi Musengwa Hatonda weefe gatuŋa, byʼamahulu hi?’ ");
INSERT INTO nuj_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","“Omugobolangamo oti, ‘Hwali beedu ba Falaawo e Misiri aye Musengwa gatutusayo nʼobuŋangi wuwe owʼamaani. ");
INSERT INTO nuj_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Hwabona Musengwa nʼahola ebyamaliholiho nʼobubonero oweŋunjisa era owʼamaani hu Bamisiri nohu Falaawo nʼabaatu babe bosibosi. ");
INSERT INTO nuj_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Gatutusa e Misiri era gatuleeta ohutuŋa ehyalo hino ehi galayira ohuŋa abasehulu beefe. ");
INSERT INTO nuj_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Era Musengwa Hatonda weefe gatulagira ohugondera amagambi nʼebiragiro byosibyosi, nʼohumuŋanga eŋono, ko geyongere ohutuŋa ekabi era ahuumenga obulamu weefe ngʼolu hiri hatyane. ");
INSERT INTO nuj_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Singa hwegenderesanga ohuhola hiisi ehi Musengwa Hatonda weefe gatulagira, huja huba huhola ehi asiima.’ ” ");
INSERT INTO nuj_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Nga Musa geyongera aloma ati, “Musengwa Hatonda wuwo alihuŋira mu hyalo ehi oli huupi huŋira ngʼomuŋuluko. Aja hubbingamo eduuli lyʼamawanga agʼAbahiiti nʼAbagirugaasi nʼAbamooli nʼAbakanani nʼAbapereezi nʼAbahiivi ko nʼAbayebbusi, amawanga musanvu amabbala era agʼamaani ohuhuhira. ");
INSERT INTO nuj_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Musengwa Hatonda wuwo nʼaliŋayo amawanga ago mu mihono jijo, wabaŋangula, oli nʼohubasihiirihisa erala. Wehuumanga ohutahola ndagaano ni nabo era sobaŋambiranga hisa. ");
INSERT INTO nuj_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Simufumbiriganwanga ni nabo. Era abahaana benywe sibafumbirwanga basaani baawe, nʼabeseere benywe sibaŋiranga bahaana baawe. ");
INSERT INTO nuj_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Hiri hiityo olwohuba olu muli hihola, abaatu abo baja huleetera abaana benywe ohujumirya abahatonda baawe. Ehyo hija huleetera Musengwa ohubaluŋira ngʼabasihiirisa nʼeŋuma hugayaala. ");
INSERT INTO nuj_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Era bino njʼebi muli nʼohuhola: muli nʼohubbwagabbwaga ebituuti byawe ebyohuŋeeraho eŋongo, mutemateme nʼepaango jʼAsera hatonda waawe, muhene mwohye ebifaananyi byawe. ");
INSERT INTO nuj_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Hiri hiityo olwohuba oli mwawufu, muutu wa Musengwa Hatonda wuwo. Mu baatu bosibosi hu hyalo hino, gahutobola ohuba egwanga lirye eryenjabulo era eryʼomuŋendo mu gosigosi hu hyalo. ");
INSERT INTO nuj_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","“Musengwa gabenda era gabatobolamo, sirwahuba ti mwali bangi ohuhira amawanga agandi, enywe mwali ndinywe omuhira obutono mu mawanga gosigosi. ");
INSERT INTO nuj_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Ne Musengwa abenda hubenda era gendire ohuhuuma ehirayiro hihye eyiri abasehulu benywe. Ehyo cʼehyagira Musengwa gabanunula nʼatambisa obuŋangi wuwe owʼamaani, gabatusa mu wiidu nʼohunyigirisa ohu habaha Falaawo gaali nʼabanyigirisa. ");
INSERT INTO nuj_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Olwʼehyo, mumanye muuti Musengwa Hatonda wenywe, nje Hatonda. Ye mwesigwa ahuuma endagaano yiye, alaga ohwenda huhwe ohubitiirifu eyiri abaatu aba hiisi mulembe abamwenda era abaŋamba ebiragiro bibye. ");
INSERT INTO nuj_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Aye sigegania huboneresa nʼohusihiirisa abo abamucaawa. ");
INSERT INTO nuj_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Olwʼehyo, mwegenderesenga ohugondera amagambi nʼebiragiro bibye ebi mbaŋa olwa leero. ");
INSERT INTO nuj_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","“Nʼoja hugondera ebiragiro ebyo nʼomwoyo mulala, Musengwa Hatonda wuwo aja huhuuma endagaano yiye ohuhulaga ohwenda huhwe ohubitiirifu ngʼolu galayira nʼasuubisa abasehulu babo. ");
INSERT INTO nuj_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Aja huhwendanga era ahuŋe ekabi osalagane ekasi nʼesinde. Aja hugimusanga eroba liryo era aja hwasa nʼebyayo bibyo. Nʼoja hwola mu hyalo ehi galayira ohuŋa abasehulu babo, oja husunanga amakungula mangi agʼengaano nʼomwenge ogwomu mizabbibbu omunyaaha nʼamafuta ogomu mizayiti. Era eŋombe nʼembusi nʼetaama jijo jija hwala. ");
INSERT INTO nuj_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Aja hubaŋa ekabi ohuhira amawanga gosigosi mu hyalo. Ŋaja huŋumaŋo hunywe omusinde oba omuhasi aja huba mugumba oba ebyayo byenywe ohuba ebisaata. ");
INSERT INTO nuj_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Musengwa aja hubahingirisanga obulwaye ohutabaŋambanga. Era saaja huleeha obulwaye owo obu mwabona e Misiri aye aja hubuta hu balabe benywe bosibosi. ");
INSERT INTO nuj_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","“Osihiirisanga amawanga gosigosi aga Musengwa Hatonda wuwo aja huhuŋa ohusihiirisa. Sobaŋambiranga hisa era sojumiryanga bahatonda baawe, olwohuba ehyo hija huhufuuhira mutego. ");
INSERT INTO nuj_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Siweralihiriranga webuusa oti mbo ‘Nja husihiirisa tye amawanga ago olwohuba baakira amaani?’ ");
INSERT INTO nuj_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Aye sobatyanga, ohebuliranga ehi Musengwa Hatonda wuwo gaahola Falaawo nʼabaatu bʼe Misiri bosibosi. ");
INSERT INTO nuj_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Ohebuliranga ebiguudyo ebyʼamaani ebi gaahola abaatu bomu hyalo ehyo. Ebyo byosibyosi, wabyeboneraho nʼemoni jijo! Era hebuliranga obubonero oweŋunjisa nʼebyamaliholiho nʼobuŋangi nʼamaani, obu Musengwa Hatonda wuwo gatambisa ohuhununula ohuŋwa e Misiri. Musengwa Hatonda wuwo alitambisa amaani njʼameene hu baatu abo aba mutya. ");
INSERT INTO nuj_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Era Musengwa Hatonda wuwo aja huŋindiha etiisa mu abo abatono abaliba ni behwehire ohwola olu balisihiiriha. ");
INSERT INTO nuj_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","“Sobatyanga, olwohuba Musengwa Hatonda wuwo ali ni neewe, wʼamaani era ŋaŋuma amuhira. ");
INSERT INTO nuj_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Musengwa Hatonda wuwo aja hubbinganga amawanga ago hyʼerala erala. Saaja hubabbinga mulundi mulala gwoŋene olwohuba esolo ejomwisugu jija hubabitiiriraho obungi. ");
INSERT INTO nuj_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Aye Musengwa Hatonda wuwo aja huŋaayo abalabe babo mu mihono jijo. Aja hubadanyamo etiisa eyʼamaani ohwola olu olisihiirisa abatono abo. ");
INSERT INTO nuj_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Alihuleetera ohuŋangula abahabaha baawe era eriŋuma aja huhebulira ati baaliho hu hyalo huno. Eriŋuma muutu yesiyesi aja husobola ohwemeerera mu moni jijo era oja hubasihiirihisa erala. ");
INSERT INTO nuj_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","“Oŋambanga abahatonda baawe wabohya era soluluhaniranga feeza oba zaabbu eyi baaŋahaho. Sobiŋiranga olwohuba bija huhufuuhira mutego. Ehyo hyʼembiho eyiri Musengwa Hatonda wuwo. ");
INSERT INTO nuj_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Soŋiranga hiitu ehyʼembiho mu mago gago, olwohuba weesi oja husihiirira hya nibyo. Ocaawiranga erala abahatonda baawe olwohuba bembiho mu moni ja Musengwa.” ");
INSERT INTO nuj_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Nga Musa geyongera aloma ati, “Ofubangaho bugali ohugondera ebiragiro byosibyosi ebi kuŋa, ko osobole ohuba mulamu, waale mu hyalo ehi Musengwa galayira ohuŋa abasehulu babo hibe omuŋuluko. ");
INSERT INTO nuj_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Era hebulira ngʼolu Musengwa Hatonda wuwo gahutangirira mu lulafu ohuhena emyaha amahumi ane. Ehyo gahihola ni genda ohuhugesesya abone epeega yiyo nʼohuhwihahania oŋambe ebiragiro bibye. ");
INSERT INTO nuj_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Era galeha enjala yahuluma aye oluvanyuma ngʼahuŋa emaanu, eyi ewe nʼabasehulu babo mwali ni mutamanyire. Ehyo gahihola ohuhusomesa ati omuutu saanabenga mulamu lwʼemere yoŋene aye nʼolwa hiisi hibono hya Musengwa. ");
INSERT INTO nuj_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Mu myaha amahumi ane ejo josijosi, engoye jenywe sijanawuha wayire amagulu genywe ohusimba. ");
INSERT INTO nuj_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Himanye mu mwoyo gugwo oti ngʼolu omusaaye aŋamo omwana wuwe endabusi, ni Musengwa Hatonda wuwo yeesi ahuŋamo endabusi. ");
INSERT INTO nuj_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","“Olwʼehyo gonderanga ebiragiro bya Musengwa Hatonda wuwo, ogenderenga mu ngira yiye era omutyenga. ");
INSERT INTO nuj_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Hiri hiityo olwohuba Musengwa Hatonda wuwo ali huhuŋira mu hyalo ehigimu omuli enjabi nʼesobere nʼesulo jʼamaaji agahuluhuta ni gaŋwa mu hiiho nomu sozi. ");
INSERT INTO nuj_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","Ehyalo ehyo, hyama engaano ni bbaale, eriyo emizabbibbu nʼemitiini ni komamawanga nʼamafuta ko nʼomudugere. ");
INSERT INTO nuj_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","Era hyalo ehijuuye emere, ŋaŋuma hiitu hyosihyosi ehiŋumayo. Eriyo ebyoma bingi bugali hyʼamabaale era mu sozi jaayo basobola ohuyabamo kopa. ");
INSERT INTO nuj_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","“Nʼolyanga weguta, weyaasanga Musengwa Hatonda wuwo olwʼehyalo ehiraŋi ehi gahuŋa. ");
INSERT INTO nuj_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","“Ofubangaho ohutebirira era wehuume ohubona oti nʼosunire obusuni bungi, siwerabiranga Musengwa Hatonda wuwo, wajeemera amagambi nʼebiragiro bibye ebi kuŋa olwa leero. ");
INSERT INTO nuj_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Ni musunanga ebyohulya ebihena era mwatongola nʼamayumba amalaŋi, ");
INSERT INTO nuj_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","era nʼebidooli byʼeŋombe nʼembusi nʼetaama byasalagana bugali weene, nʼefeeza nʼezaabbu ko nʼebiitu ebindi byala, mweŋomehanga. ");
INSERT INTO nuj_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","Wegenderesanga, ebyo byosibyosi ni bibangaŋo, siwehudumbase. Siwebiriranga Musengwa Hatonda wuwo owahutusa mu hyalo hyʼe Misiri, eyi waali mu wiidu. ");
INSERT INTO nuj_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Siwibiriranga oti gahutangirira mu lulafu olubba era olwali ni lutiisa ni mulimo emisota ejʼobusagwa ni namaala. Era mu lulafu olwo, ehyalo ehyomu, gabaŋa amaaji ohuŋwa mu lwanda! ");
INSERT INTO nuj_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Ni waali mu lulafu, gaahuŋa emaanu, emere eyi abasehulu babo baali ni batamanyire. Era gahuŋindihira ebiguudyo ebyo ohwenda ohuhugesesya wihahane hihuyeede ebiitu byahahutiiniranga bulaŋi. ");
INSERT INTO nuj_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Ebyo byosibyosi gabihola ko otaŋeeganga mu mwoyo gugwo oti, ‘Obuŋinda buno nawusuna olwʼamaani gange.’ ");
INSERT INTO nuj_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Aye ohebuliranga oti Musengwa Hatonda wuwo njʼahuŋa amaani ohugagaŋala olwʼohwenda ohwoheresa endagaano eyi gaahola nʼabasehulu babo, ngʼolu hiri hatyane. ");
INSERT INTO nuj_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","“Aye kuhahasa ti ni webiriranga Musengwa Hatonda wuwo wajumirya abahatonda abandi, mu butuufu kulomera ti muja husihiiriha. ");
INSERT INTO nuj_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Ngʼolu Musengwa alisihiirisa amawanga ago ni mubona, mwesi muja husihiiriha olwʼohujeemera Musengwa Hatonda wenywe.” ");
INSERT INTO nuj_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Nga Musa geyongera aloma ati, “Tega ohutwi ewe Yisirayiri, olwa leero oli huupi hwambuha olwabi Yoludaani, muŋire ehyalo ehyʼamawanga amabba agabahiraho amaani. Abaatu abo bamenya mu bibuga era babitongoleraho olukomera oluleeŋi bugali. ");
INSERT INTO nuj_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Era abaatu abo bʼamaani era baleeŋi, bejuhulu bʼAnaki hirimaani oyu mumanyire. Era waŋulira nʼendoma eyiri yiiti, ‘Njʼani aŋanga ohuŋiriŋania Abanaki gabaŋangula?’ ");
INSERT INTO nuj_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Aye ewe himanye oti Musengwa Hatonda wuwo nje aja huhutangiriramo hyʼomuliro ohubasihiirisa. Aja hubanafuŋia ko ewe obaŋangule era obabbinge era obasihiirise ohuŋwa hu hyalo ngʼolu Musengwa gasuubisa. ");
INSERT INTO nuj_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","“Oluvanyuma lwa Musengwa Hatonda wuwo ohuhena ohuhubbingira abaatu abo ohuŋwa mu hyalo ehyo hibe omuŋuluko, soŋeeganga mu mwoyo gugwo oti, ‘Musengwa gaapa ehyalo hino olwohuba ndi mugwalaafu.’ Bbe, ali hutusa abaatu abamawanga ago mu hyalo ehyo olwʼebibi byawe. ");
INSERT INTO nuj_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Sirwahuba ti oli mugwalaafu oba mwesigwa mu mwoyo gugwo ti cehigira oli huupi hwingira mu hyalo hyawe hibe omuŋuluko. Aye olwʼebibi byʼabaatu abo, cʼehigira Musengwa Hatonda wuwo aja hubbinga amawanga ago, ohwoheresa ehi galayirira Yibbulayimu ni Yisaka ni Yakobbo, abasehulu babo. ");
INSERT INTO nuj_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Olwʼehyo himanye oti Musengwa Hatonda wuwo saali huhuŋa ehyalo ehiraŋi ehyo olwohuba oli mugwalaafu. Omwoyo gugwo muhahanyafu. ");
INSERT INTO nuj_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","“Hebulira era siwebiriranga ngʼolu wasunguŋasa Musengwa Hatonda wuwo mu lulafu. Ohuŋwera erala hu ludaalo olu waŋwa e Misiri ohwola hatyane, otiinire nʼojeemera Musengwa. ");
INSERT INTO nuj_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Era nohu lusozi Horebbu mwaleetera Musengwa Hatonda ohubaluŋira bugali weene, huupi abasihiirise. ");
INSERT INTO nuj_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Ebyo byaliŋo olu naali hu lusozi Sinaayi ohupambya ebipande byʼamabaale ni huliho ebibono ebyʼendagaano eyi Musengwa gaahola ni nenywe. Naaliyo ohuhena endaalo mahumi ane omuusi nʼowiire. Era endaalo ejo josijosi sinahombaho hyamu tamu oba hu tuuji. ");
INSERT INTO nuj_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Musengwa gaapa ebipande bibiri ebyʼamabaale ebi Hatonda omwene gaŋandiihaho nʼomuhono gugwe, ebibono byosibyosi ebi galoma ni nenywe nʼali mu muliro, hu ludaalo olu mwahumbaanira mu meeho gʼolusozi. ");
INSERT INTO nuj_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","“Oluvanyuma lwʼendaalo amahumi ane omuusi nʼowiire, Musengwa gaapambya ebipande bibiri ebyʼamabaale, ohu gaŋandiiha endagaano. ");
INSERT INTO nuj_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Ngʼaŋo Musengwa gandoma ati, ‘Yinyoha oserengete mangumangu olwohuba abaatu aba watusa e Misiri banjeemeeye baleha engira eyi nabaloma ohugenderamo. Basanuhiise ezaabbu babbotamo enyana yʼeŋombe.’ ");
INSERT INTO nuj_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","“Nga Musengwa Hatonda nindi aloma ati, ‘Mbwene ngʼolu abaatu abo bali nʼemyoyo mihahanyafu era bajeemu, mu butuufu oweene. ");
INSERT INTO nuj_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Kale ndehe mbasihiirise, baŋwere erala hu hyalo era baberabire. Nja hutusa mu ewe egwanga ebbala era eryʼamaani ohubahiraho nibo.’ ");
INSERT INTO nuj_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","“Olusozi ni lwali ni luhyaduha omuliro, ngʼateremuha ohuŋwa hu lusozi ni pambire ebipande bibiri ebyʼamabaale ebi baŋandiihaho endagaano. ");
INSERT INTO nuj_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Ni naali ni teremuha, nabalengera ni mwonoonire ni muŋooye hu biragiro bya Musengwa Hatonda wenywe ebi gabalagira, ni mubbotire enyana yʼeŋombe mu zaabbu. Ni muŋooye hu ngira ya Musengwa eyi gabalagira ohugenderangamo. ");
INSERT INTO nuj_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Olwʼehyo, nadanya ŋaasi ebipande byombi, nga bibbwagijihira mu moni jenywe. ");
INSERT INTO nuj_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","“Nga kubba amafuha mu moni ja Musengwa ngʼolu nahola oludaayi hu lusozi. Era nahena endaalo amahumi ane, omuusi nʼowiire. Sinalyaho hiitu hyosihyosi oba hunywa maaji gosigosi olwʼehibi ehi mwali ni muholire mu moni ja Musengwa mwamusunguŋasa. ");
INSERT INTO nuj_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Natya olwohuba Musengwa gabaliho ehiruŋi ni peega ti aja hubasihiirisa. Aye hu mulundi ogwo nindi gaapulirisa, sabasihiirise. ");
INSERT INTO nuj_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Musengwa galuŋira Alooni bugali weene, ni genda nʼohumusihiirisa. Aye ese namusabira. ");
INSERT INTO nuj_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Mwahola hibi mu moni ja Hatonda ohubbota enyana yʼeŋombe mwahena mwayijumirya. Ehi naahola, nayiŋamba nayisanuusa nʼomuliro, nga njiŋuula yitetenuha bulaŋi yiba hyʼefuuhe. Nga njiŋaanya mu mwala ogwehirira ohuŋwa hu lusozi. ");
INSERT INTO nuj_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","“Era nindi mwasunguŋasa Musengwa ni muli e Tabbera nʼe Maasa ko nʼe Kiburoosi Hatava. ");
INSERT INTO nuj_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","Era Musengwa gabasindiha ohuŋwa e Kadesi Bbaruneya gabalagira ati, ‘Mutiine muŋire ehyalo ehi mbaŋaaye,’ aye mwajeemera ehiragiro hya Musengwa Hatonda wenywe era simwamugondera wayire ohumwesiga. ");
INSERT INTO nuj_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Ohuŋwa olu nabamanya, mujeemera Musengwa. ");
INSERT INTO nuj_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","“Cʼehyagira nahubba amafuha mu moni ja Musengwa ohuhena endaalo amahumi ane omuusi nʼowiire, olwohuba Musengwa gaali alomire ati aja hubasihiirisa. ");
INSERT INTO nuj_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","Negayirira Musengwa ti, ‘O Musengwa Omwene Buŋangi, otabasihiirisa. Abaatu abo, baatu babo abenjabulo aba wanunula nʼobuŋangi nʼamaani gago ohuŋwa e Misiri. ");
INSERT INTO nuj_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Kwegayirira osoniŋe ebibi nʼobuhahanyafu wʼabaatu bano. Hebulira Yibbulayimu ni Yisaka ni Yakobbo, abaŋeeresa babo. ");
INSERT INTO nuj_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","Singa osihiirisa abaatu bano, Abamisiri baja huloma baati, “Abayisirayiri baafa olwohuba Musengwa sigasobola huboosa mu hyalo ehi gasuubisa ohubaŋa.” Oba bahanda baloma baati, “Gabasihiirisa olwohuba gabacaawa, cʼehyagira gabaŋira mu lulafu ohubeetira eyo.” ");
INSERT INTO nuj_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Aye bano baatu babo abenjabulo, aba watusa e Misiri nʼobuŋangi nʼamaani gago.’ ” ");
INSERT INTO nuj_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","Nga Musa geyongera aloma ati, “Mu hiseera ehyo, Musengwa gandoma ati, ‘Baaja ebipande bibiri ebyʼamabaale, ebiri hyʼebidaayi. Ohene obaaje nʼe Sanduuku mu mbaawo omwohubihanga ebipande ebyo. Nʼohenire, oja huuja eno hu lusozi. ");
INSERT INTO nuj_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","Nja huŋandiiha hu bipande ebyo ebibono ebyene bira ebi naali ni pandiihire oludaayi. Oŋambe ebipande ebyo obite mu Sanduuku.’ ");
INSERT INTO nuj_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","“Ngʼaŋo mbaaja e Sanduuku mu mbaawo jʼomuŋwa omuhosa. Nga pamba ebipande bibiri ebyʼamabaale hyʼebidaayi niina hu lusozi. ");
INSERT INTO nuj_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Nga nindi Musengwa aŋandiiha Amagambi Ehumi hu bipande ngʼahena abipambya. Byali bibono njʼebyene hyʼebyasooka ebi Musengwa gabaloma ŋagati mu muliro hu ludaalo olu mwahumbaanira mu meeho gʼolusozi. ");
INSERT INTO nuj_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Nga ngobola ohuŋwa hu lusozi, pamba ebipande ebyo mbibiiha mu Sanduuku yʼEndagaano eyi nabaaja ngʼolu Musengwa gandagira. Era ebipande ebyo biri mu Sanduuku omwo.” ");
INSERT INTO nuj_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","Abayisirayiri baaŋwa hu sobere jʼAbajakaani nga batiina boola e Mosera eyi Alooni gafiira era nga bamusiiha eyo. Ngʼomusaani wuwe oyu balanga baati Elyazaali agobola mu magulu gage aŋeeresa ngʼomuhulu wʼabasengi. ");
INSERT INTO nuj_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Ngʼaŋo baŋwayo batiina e Gudugooda. Ni baŋwa e Gudugooda batiina e Yotibbasa, ehyalo ehirimo amaaji amangi. ");
INSERT INTO nuj_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","Mu hiseera ehyo, nga Musengwa atobola abasinde abʼehiha hya Leevi ohuba basengi babe ohubbedanga Esanduuku eyʼendagaano ya Musengwa, nʼohuŋayo eŋongo nʼohusabiranga abaatu ekabi mu siina lirye. Ejo njʼemirimo jaawe nʼohwola hatyane. ");
INSERT INTO nuj_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Ehyo cʼehigira Abaleevi baŋuma muŋuluko gwʼeroba hyʼebiha byʼAbayisirayiri ebindi. Musengwa omwene njʼomuŋuluko gwawe ogwenjabulo, ngʼolu Musengwa Hatonda wuwo gaaloma. ");
INSERT INTO nuj_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","Nga Musa geyongera aloma ati, “Naali hu lusozi ohuhena endaalo amahumi ane omuusi nʼowiire, ngʼolu nahola hu mulundi ogwasooka. Nga nindi omulundi ogwo, Musengwa aŋulira ohusaba hwange, afugiirira ohutahusihiirisa. ");
INSERT INTO nuj_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","Ngʼaŋo Musengwa gandoma ati, ‘Yinyoha mweyongere nʼolugendo, otangirire abaatu, batiine basune emiŋuluko mu hyalo ehi nalayirira abasehulu baawe, ohubaŋa.’ ");
INSERT INTO nuj_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","“Ŋaahani ewe Yisirayiri, Musengwa Hatonda wuwo ahwendaho hiina? Genda omutyenga era ogenderenga mu ngira emusangaasa. Omwendenga era omuŋeeresenga nʼomwoyo gugwo gwosigwosi nʼobulamu wuwo wosiwosi. ");
INSERT INTO nuj_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","Era oli nʼohugonderanga mu magambi nʼebiragiro bibye, ebi kuŋa olwa leero ko obe bulaŋi. ");
INSERT INTO nuj_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","“Egulu eryaŋamugulu obugali nʼehyalo ko nʼebirimo byosibyosi bya Musengwa Hatonda wuwo. ");
INSERT INTO nuj_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Ne Musengwa gendire abasehulu benywe bugali era ngʼatobolamo enywe abejuhulu baawe mu mawanga gosigosi, ngʼolu hiri hatyane. ");
INSERT INTO nuj_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Olwʼehyo, muhomole emyoyo jenywe, mulehere aŋo ohuba bahahanyafu. ");
INSERT INTO nuj_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Hiri hiityo olwohuba Musengwa Hatonda wenywe nje Hatonda wabahatonda era nje Musengwa wʼabasengwa. Nje Hatonda omubbala, owʼamaani era owʼetiisa, atehubbira era saalya nguzi. ");
INSERT INTO nuj_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Esonga ja bafuubbi nʼabanamwandu, ajiŋamba nʼatehubbira. Alumirwa abalugendwa, gabaŋa ebyohulya nʼebyohwambala. ");
INSERT INTO nuj_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Kale mwendenga abalugendwa olwohuba mwesi mwali balugendwa mu hyalo hyʼe Misiri. ");
INSERT INTO nuj_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Oli nʼohutyanga Musengwa Hatonda wuwo, omuŋeeresanga era obe mu bulala ni naye. Olayirenga mu siina lirye lyoŋene. ");
INSERT INTO nuj_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Niye yeŋene nje Hatonda wuwo. Niye njʼoyu osaana ohujumiryanga, owahola ebyamaliholiho nʼebyeŋunjisa ebyo ebi wabonaho nʼemoni jijo. ");
INSERT INTO nuj_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Abasehulu babo ni baali ni batiina e Misiri, baali sanvu boŋene. Aye ŋaahani Musengwa Hatonda wuwo, ahuleteeye ohwala, muli bangi hyʼemunyeenye hwigulu.” ");
INSERT INTO nuj_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","Nga Musa geyongera aloma ati, “Yendanga Musengwa Hatonda wuwo, ogonderenga amagambi nʼebiragiro bibye nʼebiitu byosibyosi ebi genda ohole. ");
INSERT INTO nuj_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","Muhimanye muuti sindi huloma nʼabaana benywe abaŋere abahiiri hubona ngʼolu Musengwa Hatonda wenywe aŋamo endabusi oba abahiiri hubonangaho amaani nʼobubbala ko nʼobuŋangi wuwe. ");
INSERT INTO nuj_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","Abaana benywe sinje abaabona aye enywe ndinywe abaabona obubonero oweŋunjisa nʼebyamaliholiho ebi gahola e Misiri hu Falaawo nʼehyalo hihye hyosihyosi ehyʼe Misiri. ");
INSERT INTO nuj_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","Abaana benywe sinje abaabona ngʼolu Musengwa gasihiirisa eŋe lyʼe Misiri, nʼembalaasi nʼamagaali gaawe, ngʼolu banywa etubbi mu nyanja eyi balanga baati Enando, olu baali ni bababbinga era gabasihiirisa. ");
INSERT INTO nuj_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","Abaana benywe sinje abaabona ngʼolu Musengwa gabalabirira mu lulafu, ohwola olu mwola mu hifo hino. ");
INSERT INTO nuj_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","Sibaabona ebi gaahola hu Dasani nʼAbbiraamu abasaani bʼEliyaabbu owomu hiha hya Lubbeeni, nʼamago gaawe olu eroba lyasama lyabamira nʼamago nʼeweema jaawe ko nʼebyawe byosibyosi, Abayisirayiri ni babona. ");
INSERT INTO nuj_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","Aye ebyo byosibyosi ndinywe abaabibona nʼemoni jenywe Musengwa nʼabihola.” ");
INSERT INTO nuj_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","Nga Musa geyongera aloma ati, “Olwʼehyo, mufubengaho ohugondera ebiragiro byosibyosi ebi mbaŋa olwa leero, ko mube nʼamaani ohwambuha Yoludaani muŋire ehyalo ehi muli huupi hwingiramo. ");
INSERT INTO nuj_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","Singa muba bagondi, muja huwangaalira mu hyalo ehituluha amabeere nʼomudugere ehi Musengwa galayira ohuŋa abasehulu benywe ko ni nenywe abejuhulu baawe. ");
INSERT INTO nuj_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Ehyalo ehi muli huupi hwingiramo ohufuuha hyenywe, sihiri hyʼe Misiri eyi mwaŋwa, eyi mwahomanga owumo mwafululuhana ni mujuhirira endimiro ko mwasuna emere. ");
INSERT INTO nuj_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","Aye ehyalo ehi muli huupi hwambuha Yoludaani mutiinemo, hyʼesozi nʼebiiho era eriyo efula, ");
INSERT INTO nuj_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","hyalo ehi Musengwa Hatonda wuwo alabirira ebiseera byosibyosi mu mwaha. ");
INSERT INTO nuj_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","“Ni munafubenga ohugondera ebiragiro bibye byosibyosi ebi mbaŋa olwa leero era singa munendenga Musengwa Hatonda wenywe, mwamuŋeeresanga nʼemyoyo jenywe josijosi nʼobulamu wenywe wosiwosi, ");
INSERT INTO nuj_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","aja hugwisanga efula mu biseera byayo, musobolenga ohuhungula engaano nʼomwenge omunyaaha ogwomu mizabbibbu nʼamafuta agomu mizayiti. ");
INSERT INTO nuj_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","Era nomwisugu omwohwayihisanga ebyayo byenywe, muja hubangamo enyaasi. Muja hulyanga emere, mwiguta. ");
INSERT INTO nuj_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Ne mwegenderesanga, ebiŋeego byenywe ohutababbaamya mwaŋaba ohuŋwa hu Musengwa nga mutandiha ohuŋeeresa abahatonda abandi. ");
INSERT INTO nuj_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","Ni muja huhola muutyo, Musengwa aja hubaluŋira galobera efula ohugwa ngʼehyalo hiŋalahala yaaŋuma bibala. Ehyo hija hubaleetera ohusihiiriha mangu mu hyalo ehiraŋi ehi Musengwa abaŋa. ");
INSERT INTO nuj_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","“Olwʼehyo, mweŋeyo ohuhuumanga amagambi gange gano nʼomwoyo mulala. Mugasidihenga hu mihono jenywe era mugetimbanga mu byeni byenywe ngʼahabonero ahohubahebulisanga. ");
INSERT INTO nuj_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Mugasomesanga abaana benywe, mugalomengaho ni muli ŋango era nʼolu muba mu ngundo ni mugenda, ni mugalamiriye mu buliri era nʼolu muba ni mwinyohire. ");
INSERT INTO nuj_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","Era mugaŋandiihanga hu myango jʼenjigi jʼenyumba jenywe. ");
INSERT INTO nuj_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","Ni muja huhola muutyo, enywe nʼabaana benywe muliwangaalira mu hyalo ehyo ehi Musengwa gasuubisa ohuŋa abasehulu benywe. Mulihibamo ehiseera hyosihyosi ehi egulu lija huba ŋamugulu wʼehyalo. ");
INSERT INTO nuj_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","“Mufubengaho ohugondera ebiragiro bino byosibyosi ebi mbaŋa. Mwendenga Musengwa Hatonda wenywe ni mugendera mu ngira yiye era mumweŋambeho, ");
INSERT INTO nuj_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","Musengwa aja hubbinga mu hyalo ehyo amawanga ago gosigosi era muja huŋira omuŋuluko gwʼamawanga amabbala era agabahira amaani. ");
INSERT INTO nuj_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Hiisi aŋa munatenga ohugulu, ŋanaabenga ŋa wenywe. Esalo jenywe jinaŋwenga hu lulafu mu hiiho ohwola e Lebbanooni engulu, nʼohuŋwa hu lwabi Yufuleeti ebuŋwalyuba, ohwola hu nyanja Meditereniani e bugwalyuba. ");
INSERT INTO nuj_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Ŋaja huŋumaŋo muutu yesiyesi aja hubaŋiriŋania gabasobola, olwohuba Musengwa Hatonda wenywe aja hubaŋa obuti ni bateetema huteetema babaduluma ngʼolu gabasuubisa. ");
INSERT INTO nuj_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","“Olwaleero musaleŋo ŋagati wʼebiitu bibiri: ekabi oba ebiŋwabo, ");
INSERT INTO nuj_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","ni munagonderanga ebiragiro bya Musengwa Hatonda wenywe ebi mbaŋa olwa leero, munasunenga ekabi. ");
INSERT INTO nuj_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","Ne ni mutagonderenga ebiragiro bya Musengwa Hatonda wenywe, mwabbama mwajumirya abahatonda abandi aba mutamanyire, munasunenga ehiŋwabo. ");
INSERT INTO nuj_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","Era Musengwa Hatonda wuwo nʼahuyeedanga waŋira ehyalo ehyo ngʼomuŋuluko gugwo, wemanga hu lusozi Gerizimu walangiriranga ekabi aye ni hiri hiŋwabo, wemanga hu lusozi Ebbali. ");
INSERT INTO nuj_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","Ngʼolu mumanyire, esozi ejo jombi jiri ebugwalyuba wʼolwabi Yoludaani, mu hyalo hyʼAbakanani abamenyire mu hiiho hya Yoludaani huupi nʼehibuga Gilugaali, siŋaleeŋi nʼemitumba ja Moole. ");
INSERT INTO nuj_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Muli huupi hwambuha olwabi Yoludaani, mwingire mu hyalo ehi Musengwa Hatonda wenywe ali hubaŋa hibe omuŋuluko. Ni muŋiranga ehyalo ehyo, nga mutandiha ohumenyamo, ");
INSERT INTO nuj_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","mufubangaho ohugonderanga amagambi nʼebiragiro byosibyosi ebi mbaŋa olwa leero.” ");
INSERT INTO nuj_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Nga Musa geyongera aloma ati, “Gano njʼamagambi nʼebiragiro ebi muli nʼohufubaho ohugondera mu hyalo ehi Musengwa Hatonda wʼabasehulu benywe abaŋa ohuba omuŋuluko. Muli nʼohugagonderanga endaalo josijosi ejʼobulamu wenywe. ");
INSERT INTO nuj_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Ni muhena ohubbinga amawanga ago agamenyiremo, muli nʼohusihiirihisa erala ebifo byosibyosi omu bajumirihisya abahatonda baawe: hu sozi ŋamugulu, hu ngingi ko naŋaasi wʼemisaala. ");
INSERT INTO nuj_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Mubbwanganga ebituuti byawe ohubaŋeera eŋongo era mutematemanga esiiro jaawe. Mwohyanga ebifaananyi byʼAsera era mwabbwagabbwaga nʼebifaananyi bya bahatonda baawe ebibbote, mutuhiseŋo erala amasiina ga bahatonda baawe mu byalo ebyo. ");
INSERT INTO nuj_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","“Simujumiryanga Musengwa Hatonda wenywe ngʼolu abaatu abo bajumirya abahatonda baawe. ");
INSERT INTO nuj_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","Aye muli nʼohujumirihisyanga Musengwa Hatonda wenywe mu hifo ehi aja hutobola mu hyalo eyi mutiina. Mu hifo ehyo, ");
INSERT INTO nuj_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","peyi muja huŋiranga ebirabo ebi bohya bihwiye byaguguliha nʼeŋongo jenywe nʼehirala ehyʼehumi nʼebirabo ebyawufu, ebyʼoweyamo nʼebirabo ebi wamwene osalaŋo ohuŋaayo ko nʼebyayo ebidaayi mu husaaliwa. ");
INSERT INTO nuj_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","Enywe nʼabomu mago genywe mutiinanga mu hifo ehyo mwalya embaga mu moni ja Musengwa Hatonda wenywe, mwasangaala olwʼebyo byosibyosi ebi munaabenga ni musunire, olwohuba Musengwa Hatonda wenywe abaŋaaye ekabi. ");
INSERT INTO nuj_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","“Simuholanga biitu ngʼolu mubihola hatyane, ngʼolu hiisi muutu aba nabona ");
INSERT INTO nuj_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","olwohuba muhiiri hwola mu hifo ehyʼehiŋuumulo, ehyalo ehi Musengwa Hatonda wenywe ali hubaŋa ngʼobusika. ");
INSERT INTO nuj_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Aye muli huupi hwambuha olwabi Yoludaani, mumenye mu hyalo ehi Musengwa Hatonda wenywe ali hubaŋa. Nabaŋonianga abalabe benywe ababetooloye, mwasuna emiyaaya, ");
INSERT INTO nuj_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","muŋiranga ebirabo ebi bohya ebihwiye byaguguliha nʼeŋongo lyenywe nʼehirala ehyʼehumi nʼebirabo ebyʼoweyamo nʼebirabo ebi omuutu omwene asalaŋo ohuŋaayo ko nʼebyayo ebidaayi mu husaaliwa, mu hifo ehi Musengwa Hatonda wenywe alitobola ohumujumirihisyangamo. ");
INSERT INTO nuj_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","Eyo njʼeyi muja huliiranga embaga mu moni ja Musengwa Hatonda wenywe nʼesangaalo. Mutiinanga nʼabaana benywe abaseere nʼabahaana ko nʼabeedu benywe abahasi nʼabasinde bosibosi. Era muhebuliranga ohutiina nʼAbaleevi abali mu bibuga byenywe, olwohuba nibo sibaja husuna muŋuluko. ");
INSERT INTO nuj_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","Wegenderesanga ohutaŋongeranga aŋaatu ŋosiŋosi ebirabo ebi bohya ebihwiye byaguguliha. ");
INSERT INTO nuj_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","Oja huŋangayo eŋongo mu hifo ehi Musengwa alitobola mu twale erala hu biha byenywe. Eyo njʼeyi oja huŋeeranga eŋongo era njʼeyi oja huŋeeranga ebirabo ebi bohya ebihwiye byaguguliha era eyo peyi oja huholeranga byosibyosi ebi kulagira. ");
INSERT INTO nuj_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","“Aye osaliranga ebyayo bibyo aŋaatu ŋosiŋosi aŋa oba ni wendire, walya enyama mu hibuga hyosihyosi. Olyanga enyama ngʼolu Musengwa Hatonda wuwo anaabenga nʼahuŋaaye ekabi. Mwesimwesi abalongoofu oba abatali balongoofu, mulyenga ebyayo ngʼolu mulya namaamya nʼenjobe. ");
INSERT INTO nuj_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Aye simulyanga malasire, mugajuhanga ngʼolu mujuha amaaji. ");
INSERT INTO nuj_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","Nʼonaabenga nʼosalireŋo ohuŋaayo eŋongo eyiri Musengwa, soyiriranga mu bibuga byenywe omu mumenya. Wayire hiba hirala ehyʼehumi ehyʼengaano oba omwenge ogwomu mizabbibbu oba amafuta oba eŋombe nʼetaama nʼembusi jenywe endaayi mu husaaliwa, oba ebirabo ebyʼoweyamo nʼebirabo ebi wamwene osalaŋo ohuŋaayo oba ebirabo ebindi byosibyosi. ");
INSERT INTO nuj_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","Oliranga ebiitu ebyo mu moni ja Musengwa Hatonda wuwo mu hifo ehi aja hutobola. Oliranga ŋalala nʼabaana babo abaseere nʼabahaana nʼabeedu babo abasinde nʼabahasi ko nʼAbaleevi abamenya mu bibuga benywe. Era osangaalanga mu moni ja Musengwa Hatonda wuwo olwʼebiitu ebyo byosibyosi. ");
INSERT INTO nuj_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Wegenderesanga ohutadanyirira Baleevi, endaalo jʼobulamu wuwo josijosi hu hyalo. ");
INSERT INTO nuj_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","“Musengwa Hatonda wuwo nʼagalamyanga esalo jijo ngʼolu gahusuubisa, waŋemba hu hulya enyama, oja hulyanga ehiseera ehi wenderamo. ");
INSERT INTO nuj_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Singa ehifo ehi Musengwa Hatonda wuwo alitobola ohumujumirihisyangamo hiba ŋaleeŋi bugali, oja huŋambanga eŋombe oba etaama oba embusi eji Musengwa Hatonda wuwo aba nʼahuŋaaye, wasalira mu bibuga bibyo, ngʼolya enyama ngʼolu kulagira. ");
INSERT INTO nuj_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Omuutu yesiyesi omulongoofu oba atali mulongoofu analyenga hu nyama eyo, ngʼolu balya enjobe ni namaamya. ");
INSERT INTO nuj_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","Aye simulya malasire olwohuba obulamu buli mu mafugi. Olwʼehyo, simulyanga enyama ehiirimo amafugi. ");
INSERT INTO nuj_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","Mujuhanga amafugi ngʼolu mujuha amaaji. ");
INSERT INTO nuj_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","Simulyanga malasire, ko ebiitu bibatiinire bulaŋi, enywe nʼolulyo lwenywe, olwohuba munahola muutyo, muba muholire ehisangaasa Musengwa. ");
INSERT INTO nuj_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Oŋambanga ebirabo bibyo ebyawufu ko nʼebyoweyamo wabiŋira mu hifo ehi Musengwa alitobola. ");
INSERT INTO nuj_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","Oŋonganga hu hituuti hya Musengwa Hatonda wuwo, enyama nʼamafugi ebyʼeŋongo eyi bohya ni yiri kwiye yaguguliha. Aye amafugi gʼeŋongo ejindi ogajuhanga hu hituuti hya Musengwa Hatonda wuwo, ne enyama mwayirya. ");
INSERT INTO nuj_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","Singa ofubangaho ohugonderanga ebiragiro ebyo byosibyosi ebi kulagira, ewe nʼabolulyo lulwo, oja huba bulaŋi emirembe nʼemirembe, olwohuba onaahabe ohola ehiitu ehiraŋi era ehisaana mu moni ja Musengwa Hatonda wuwo. ");
INSERT INTO nuj_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","“Musengwa Hatonda wuwo nʼasihiirisanga abaatu abamawanga ago, wababbinga ngʼohena omenya mu hyalo hyawe, ");
INSERT INTO nuj_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","siwingiranga mu mutego gwawe wajumirya abahatonda baawe. Sobuusanga nʼohubuusa oti, ‘Abaatu abamawanga gano bajumirya baatye abahatonda baawe? Nenda keesi mbajumirye.’ ");
INSERT INTO nuj_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Sojumiryanga Musengwa Hatonda wuwo mu ngeri eyi abaatu abamawanga ago bajumiryamo abahatonda baawe, olwohuba bajumirya abahatonda baawe ni bahola ebiitu ebyʼembiho ebi Musengwa acaawa. Boohya nʼabaana baawe ngʼeŋongo eyiri abahatonda baawe. ");
INSERT INTO nuj_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","“Ofubangaho bugali ohugondera ebiragiro byosibyosi ebi kuŋa. Siwongerangaho oba huhendesaho hiitu hyosihyosi.” ");
INSERT INTO nuj_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","Nga Musa geyongera aloma ati, “Singa ŋabaluhaŋo naabbi mu nywe oba omuutu aloota ebirooto, galoma ehija hubaŋo mu moni era gasuubisa obubonero oweŋunjisa oba ebyamaliholiho, ");
INSERT INTO nuj_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","era nga obubonero oweŋunjisa oba ebyamaliholiho ebyo, byolerera era ngʼomuutu oyo abaloma ati, ‘Bahyange hujumirye abahatonda abandi abo,’ abahatonda aba mutamanyire. ");
INSERT INTO nuj_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","Simuŋulirisanga naabbi oba avunula ebirooto oyo. Musengwa Hatonda wenywe aliba ali hwenda hubona mu butuufu obanga mumwenda nʼemyoyo jenywe josijosi nʼobulamu wenywe wosiwosi. ");
INSERT INTO nuj_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","Muŋeeresenga nje Musengwa Hatonda wenywe yeŋene era njʼoyu muba ni mutyanga. Mugonderanga ebiragiro bibye, mumuŋulirisenga era mumweŋenga. ");
INSERT INTO nuj_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","Abanaabbi abʼobudulingi oba abaloota ebirooto abagesyaho ohubabbaamya, bateehwa ohwitiwa olwohuba baleetera abaatu ohujeemera Musengwa Hatonda wenywe, owabanunula ohuŋwa mu wiidu mu hyalo hyʼe Misiri. Omuutu hyʼoyo genda ababbaamye abatuse hu ngira eyi Musengwa Hatonda wenywe gabalagira ohuŋamba. Olwʼehyo, mumwite mutuseŋo ehibi ohuŋwa mu enywe. ");
INSERT INTO nuj_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","“Singa omuutu, oba mugandawo oba musaani wuwo oba muhaana wuwo, oba muhasi wuwo oyu wenda bugali, oba meriiwo ahusendasenda mu ngiso gahuloma ati, ‘Hutiine hujumirye abahatonda,’ aba ewe nʼabasehulu babo mutamanyire, ");
INSERT INTO nuj_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","gasobola ohuhuŋa amagesi ohujumirya abahatonda ababaliranwa oba aba baatu abaŋaleeŋi, ");
INSERT INTO nuj_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","soŋulirisanga ebi omuutu hyʼoyo aloma era somuŋambiranga hisa. Somulehanga gaŋona wayire ohumusoniŋa aye omwanihanga mu lwijuuye. ");
INSERT INTO nuj_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","Oli nʼohumwita era ndiiwe oli nʼohusooka ohumuhubba amabaale, ko abandi bosibosi bahweŋimbeho. ");
INSERT INTO nuj_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","Omuhubbanga amabaale gaafa, olwohuba genda ohuhubbaamya ahutuse hu Musengwa Hatonda wuwo, owahutusa mu hyalo hyʼe Misiri eyi waholanga owiidu. ");
INSERT INTO nuj_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","Abayisirayiri abandi ni baja huŋulira, baja hutya era siŋalibaŋo muutu yesiyesi mu enywe aja huba muhosi wʼebibi. ");
INSERT INTO nuj_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","“Nʼoliba nʼoli mu hyalo ehi Musengwa Hatonda wuwo ahuŋa ohumenyamo, waŋulira ni baloma hu hirala hu bibuga bibyo, ");
INSERT INTO nuj_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","baati mulimo abaatu abʼegwanga liryo abali hubbaamya abaatu ni babaloma baati, ‘Hujumirye abahatonda abo,’ abahatonda aba mutamanyire, ");
INSERT INTO nuj_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","wendulirisanga bulaŋi nʼohwegenderesa era ni hiba ni hiri hituufu ti ŋaliŋo ahola ehyʼembiho ehyo mu enywe, ");
INSERT INTO nuj_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","oŋambanga epiima wawaagala abaatu bomu hibuga ehyo bosibosi wabasihiirihisa erala nʼebyayo byawe. ");
INSERT INTO nuj_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","Ohumbaanianga ebiitu byʼabaatu abo byosibyosi wabibunga ŋagati wʼehibuga ngʼobyohya. Oja hohya hiisi muutu ŋalala nʼehibuga ehyo, hyʼeŋongo eyi bohya ehwiye lyaguguliha ngʼehirabo eyiri Musengwa Hatonda wuwo. Ehibuga ehyo hisigalanga gunda emirembe nʼemirembe era sibagobolangamo huhitongola. ");
INSERT INTO nuj_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","Simwesigahisanga hiitu hyosihyosi ehi bali nʼohusihiirisa ko Musengwa alehera aŋo ohubaluŋira abaŋambire ehisa, musalagane mube bangi ngʼolu galayirira abasehulu benywe. ");
INSERT INTO nuj_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","Oja hugonderanga Musengwa Hatonda wuwo, ohuume ebiragiro bibye byosibyosi ebi kuŋa olwa leero nʼoholanga ebiraŋi mu moni ja Musengwa Hatonda wuwo.” ");
INSERT INTO nuj_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","Nga Musa geyongera aloma ati, “Ngʼolu muli baatu ba Musengwa Hatonda wenywe, ni muba ni mufiiriiye, simwebeganga oweeni oti muli nʼepaata hyʼabaatu abandi ngʼolu bahola ni balira abafu. ");
INSERT INTO nuj_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","Musengwa Hatonda wuwo gahwawula ohuba wuwe era gahutobola ohuba egwanga eryenjabulo mu mawanga gosigosi agali hu hyalo. ");
INSERT INTO nuj_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","“Simulyanga hisolo hyosihyosi ehitali hirongoofu. ");
INSERT INTO nuj_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","Luno njʼolukalala lwʼebisolo ebyʼohulyanga: eŋombe nʼetaama nʼembusi, ");
INSERT INTO nuj_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","nʼenjaza nʼetalaganya namaamya nʼemaadu nʼembulabuzi nʼenjobe nʼesirabo, ");
INSERT INTO nuj_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","hiisi solo eyiri nʼebibbobbolo ebyaŋulemo era eyigalusa wekulumu. ");
INSERT INTO nuj_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","Aye singa ehyayo ehyo, hiŋuma ebibbobbolo ebyaŋulemo era ni hitagalusa wekulumu, simuhiryanga. Olwʼehyo, simulyanga nasugirya nʼenduuyu ni munyala. Ejo jigalusa owekulumu aye jiŋuma ebibbobbolo ebyaŋulemo. Ejo sinongoofu. ");
INSERT INTO nuj_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","Era simulyanga mbiiji olwohuba siyigalusa wekulumu wayire yiri nʼebibbobbolo ebyaŋule. Olwʼehyo, sinongoofu. Simulyanga nyama jʼebisolo ebyo wayire hujiŋambaho ni jifuuye. ");
INSERT INTO nuj_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","“Hu biba mu maaji, mulyanga enyeeni ejiri nʼamaŋwa nʼamagalagambwe. ");
INSERT INTO nuj_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","Aye simulyanga ejiŋumaho amaŋwa nʼamagalagambwe. Ejo sinongoofu. ");
INSERT INTO nuj_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","“Mulyanga enyuni enongoofu josijosi. ");
INSERT INTO nuj_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","Aye simulyanga haŋungu nʼesega nʼekujulu ");
INSERT INTO nuj_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","wonzi nʼeduudu nʼekongooja eja hiisi hiha ");
INSERT INTO nuj_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","hiisi hiha hya nahinywamalwa ");
INSERT INTO nuj_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","ni maaya nʼembugambugi nʼesogo nʼekwambu nʼejindi ejiri hyʼejo ");
INSERT INTO nuj_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","ni woogu owa hiisi hiha nʼekukufu ");
INSERT INTO nuj_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","nʼenyange nʼekoobyo ");
INSERT INTO nuj_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","ni namusiida ni munaha owa hiisi hiha nʼekokonyagirisi ni pundopundo. ");
INSERT INTO nuj_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","“Simulyanga biwuuka ebiri nʼamabaŋa byosibyosi olwohuba sibirongoofu. ");
INSERT INTO nuj_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","Aye mulyanga ebirongoofu ebiri nʼamabaŋa byosibyosi. ");
INSERT INTO nuj_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","“Simulyanga hiitu hyosihyosi ehifuuye. Musobola ohuhiŋa oba mwahigusa abalugendwa ababa ni bamenya ni nenywe oba ni bahyaye. Aye mwabeene, simuhiryanga olwohuba Musengwa Hatonda wenywe gabatobola ohuba bawufu mu moni jije. Simusalanga nyana yʼembusi eyi hyoka. ");
INSERT INTO nuj_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","“Oŋambanga hirala ehyʼehumi hu ebi ohungula mu hiisi mwaha, wahyabula. ");
INSERT INTO nuj_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","Era ohiŋiranga mu hifo ehi Musengwa Hatonda wuwo aja hutobola ohumujumirihisyangamo, ngʼoliira eyo mu moni jije. Ehyo hiŋamba hu hirala ehyʼehumi hihyo ehyʼengaano nʼomwenge ogwomu mizabbibbu nʼamafuta agomu mizayiti nʼeŋombe nʼetaama nʼembusi jijo endaayi mu husaaliwa. Obiriiranga mu hifo ehyo. Ehyo hija huhusomesa ohutyanga Musengwa Hatonda wuwo. ");
INSERT INTO nuj_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","“Singa Musengwa Hatonda wuwo ahuŋa ekabi, ehifo ehi alitobola ohumujumirihisyangamo hyaaba ŋaleeŋi, nʼotasobola hugega hirala ehyʼehumi ohuhiŋira eyo, ");
INSERT INTO nuj_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","otundanga hirala ehyʼehumi ehyo wasunamo ebbeesa, ngʼotiina mu hifo ehi Musengwa Hatonda wuwo alitobola. ");
INSERT INTO nuj_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","Ni woolanga mu hifo ehyo, oŋambanga ebbeesa ejo ngʼogulamo eŋombe oba etaama oba omwenge ogwomu mizabbibbu oba omwenge epiiraŋo, oba ehiitu ehindi hyosihyosi. Ngʼoliira eyo mu moni ja Musengwa Hatonda wuwo, nʼosangaalira ŋalala nabomu mago gago. ");
INSERT INTO nuj_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","Ne simwibiriranga Abaleevi abomu bibuga byenywe olwohuba sibaja husuna muŋuluko. ");
INSERT INTO nuj_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","“Hu komerero yʼomwaha ogwohudatu, sotambisanga hirala ehyʼehumi hu mbaga, ohiŋiranga mu bibuga byenywe babibiiha mu sitoowa. ");
INSERT INTO nuj_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","Ohiŋiriranga Abaleevi olwohuba baŋuma mugabo gwʼeroba, nʼabalugendwa nʼabafuubbi nʼabanamwandu abali mu bibuga byenywe, balye begute. Musengwa Hatonda wuwo aja huhuŋa ekabi mu byosibyosi ebi ohola.” ");
INSERT INTO nuj_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","Nga Musa geyongera aloma ati, “Hiisi myaha musanvu olu ginaŋwengaho, oja husoniŋanga abaatu amabanja. ");
INSERT INTO nuj_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","Yino njʼengeri eyi oja huhiŋambangamo: hiisi muutu asalanga mu bbanja eri gaali nʼaŋolire Omuyisirayiri wahye. Sagobolangayo hubanja muliranwa oba awoluganda oyu gaali nʼaŋolire, olwohuba ehiseera hya Musengwa ohusoniŋa abamabanja, hyolire. ");
INSERT INTO nuj_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","Ohusoniŋa abamabanja hiŋamba hu Bayisirayiri boŋene, sosi abalugendwa abamenyire ni nenywe. ");
INSERT INTO nuj_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","“Siŋaja hubaŋo muutu yesiyesi omugadi mu enywe, olwohuba Musengwa Hatonda wuwo aja huhuŋa ekabi mu hyalo ehi ali huhuŋa hibe omuŋuluko ogwenjabulo. ");
INSERT INTO nuj_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","Aja huhuŋa ekabi singa ofubangaho bugali ohugondera ebiragiro byosibyosi ebya Musengwa Hatonda wuwo ebi kuŋa olwa leero. ");
INSERT INTO nuj_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","Musengwa Hatonda wuwo aja huhuŋa ekabi ngʼolu gasuubisa. Oja huŋolanga amawanga ameene amangi aye sooja hweŋolanga. Era oja huŋuganga amawanga mangi aye ŋaja huŋumaŋo abahuŋuga. ");
INSERT INTO nuj_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","“Aye singa ŋabaaŋo Omuyisirayiri nʼali mugadi mu hirala hu bibuga byenywe mu hyalo ehi Musengwa Hatonda wuwo ahuŋa, sobanga muhodo eyi ali. ");
INSERT INTO nuj_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","Aye omuŋambiranga ehisa, wamuŋola hyosihyosi ehi aba ni getaaga. ");
INSERT INTO nuj_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","Sogaananga huŋola muutu olwohuba omwaha ogwʼohusoniŋa abaatu amabanja guli huupi hwola. Singa omugadi oyo geŋunderera Musengwa, oja huba wonoonire. ");
INSERT INTO nuj_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","Oyeedanga abagadi ni ŋaŋuma hwemulugunya olwohuba Musengwa Hatonda wuwo aja huhuŋa ekabi mu byosibyosi ebi oja huholanga. ");
INSERT INTO nuj_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","Abagadi baja hubangaŋo mu hyalo. Cʼehigira kulagira ohuyeedanga Abayisirayiri bahyo ababa ni baŋuma. ");
INSERT INTO nuj_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","“Singa Omubbebbulaniya wahyo, omusinde oba omuhasi, getunda eyi oli ohufuuha mwidu wuwo era ngʼahola owiidu ewuwo ohuhena emyaha mukaaga, mu mwaha ogwomusanvu omulehulanga gatiina ewaawe. ");
INSERT INTO nuj_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","Era nʼolehulanga omwidu omusinde, somulehulanga gaagama nʼengalo njereere. ");
INSERT INTO nuj_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","Omuseebulanga bulaŋi, obugulanga hu taama oba embusi, nohu mere eyʼembehe nohu mwenge ogwomu mizabbibbu, wamuŋa. Omuŋanga ohusiziira hu kabi eji Musengwa Hatonda wuwo, gaahuŋa. ");
INSERT INTO nuj_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","Hebulira oti weesi waali mwidu mu hyalo hyʼe Misiri, Musengwa Hatonda wuwo ngʼahununula, cʼehigira kuŋa ehiragiro ehyo. ");
INSERT INTO nuj_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","“Aye singa omwidu wuwo oyo aloma ati, ‘Cenda ohuba ni neewe nʼabomu mago gago, olwohuba wumbisya bulaŋi era neŋulira bulaŋi ohusigala ni neewe.’ ");
INSERT INTO nuj_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","Analoma atyo, oŋambanga olukato, wamuŋira hu lwigi wamuŋundula ohutwi, ngʼomwidu oyo afuuha mwidu wuwo emirembe nʼemirembe. Era poholanga otyo nohu mwidu wuwo omuhasi. ");
INSERT INTO nuj_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","Sohibonanga oti oli hufiirwa ohulehula omwidu wuwo. Hebulira oti ahuholeeye emyaha mukaaga, emirimo eji ahuholeeye jirimo emirundi ebiri hu jʼomutambi owʼomuhemba. Era singa oholanga otyo, Musengwa Hatonda wuwo aja huhuŋa ekabi mu byosibyosi ebi ohola. ");
INSERT INTO nuj_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","“Oŋambanga eŋombe nʼembusi nʼetaama jijo endaayi mu husaaliwa wajitobola mu jahye, ohuba ja Musengwa Hatonda wuwo. Soŋambanga byayo ebyo ebidaayi ohuhuholera emirimo era sobisalangaho mooya. ");
INSERT INTO nuj_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","Hiisi mwaha, ewe nʼabomu mago gago, oŋiranga ebyayo ebyo wabiriira mu moni ja Musengwa Hatonda wuwo, mu hifo ehi alitobola. ");
INSERT INTO nuj_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","Aye ehyayo ehyo hinabaho obuleme oba obuŋofu oba ahamogo hosihosi, sohiŋongangayo eyiri Musengwa Hatonda wuwo. ");
INSERT INTO nuj_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","Oŋambanga ehyayo ehyo mwaliira mu bibuga byenywe. Omuutu yesiyesi omulongoofu oba atali mulongoofu, aja huhiryaho ngʼolu balya enjobe oba epala. ");
INSERT INTO nuj_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","Ne solyanga malasire aye ogajuhanga ngʼolu ojuha amaaji.” ");
INSERT INTO nuj_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","Nga Musa geyongera aloma ati, “Ohuŋa Musengwa Hatonda wuwo eŋono, olyanga Embaga eyʼOhubihisya mu mwesi ogwʼAbbibbu olwohuba lulala owiire mu mwesi ogwo, Musengwa Hatonda wuwo gahununula ohuŋwa e Misiri. ");
INSERT INTO nuj_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","Otiinanga mu hifo ehi Musengwa Hatonda wuwo alitobola ohumujumirihisyangamo, wasala etaama oba eŋombe hu Mbaga eyʼOhubihisya. Ebyo obiholanga ohuŋa Musengwa eŋono. ");
INSERT INTO nuj_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","Solyanga nyama eyo nʼemigaati eji bataayemo ehisimbulusa. Ohenanga endaalo musanvu nʼolya emigaati eji batatayemo ehisimbulusa ngʼolu wahola olu waŋwa mu hyalo hyʼe Misiri mangumangu. Lya emigaati ejiraga ohubonaabona. Ehyo mu bulamu wuwo wosiwosi, hihuhebulisenga oludaalo olu waŋwa e Misiri. ");
INSERT INTO nuj_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","Siŋabangaŋo muutu yesiyesi abanga nʼehisimbulusa mu nyumba yiye ohuhena endaalo omusanvu mu hyalo hyenywe hyosihyosi. Era enyama eyi muba ni muŋongire egulo hu oludaalo oludaayi, siyiŋenyuhanga ohwola mu mugamba ni yihiiriŋo. ");
INSERT INTO nuj_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","Soŋangayo eŋongo eyʼEmbaga eyʼOhubihisya mu hibuga hyosihyosi ehi Musengwa Hatonda wuwo ali huhuŋa. ");
INSERT INTO nuj_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","Aye oli nʼohuyiŋongayo mu hifo hyoŋene ehi Musengwa Hatonda wuwo aja hutobola ohumujumirihisyangamo. Eyo peyi oli nʼohuyiŋerayo ehyʼegulo, esaawa ni yija hugwa mu maaji, ohuhebulira ohuŋunuha e Misiri. ");
INSERT INTO nuj_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","Oyinyiiyanga wayiriira mu hifo ehi Musengwa Hatonda wuwo alitobola. Nʼohena, nga mu mugamba wagamayo mu weema yiyo. ");
INSERT INTO nuj_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","Endaalo omukaaga ejirondaho, mulyanga emigaati eji batatayemo ehisimbulusa. Hu ludaalo olwomusanvu, muhumbaananga mwajumirya Musengwa Hatonda wenywe. Era hu ludaalo olwo, simuluholerangaho mulimo gwosigwosi. ");
INSERT INTO nuj_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","“Obalanga ewiiki musanvu ohuŋwa olu mutandiha ohuhungula engaano, ");
INSERT INTO nuj_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","ngʼolya Embaga eyʼAmakungula ni weyaasa Musengwa Hatonda wuwo olwʼamakungula. Omuŋiriranga ehirabo ehi womwene osalireŋo mu hwenda huhwo ngʼolu Musengwa Hatonda aba nʼahuŋaaye ekabi. ");
INSERT INTO nuj_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","Ehyo hiseera hyahusaŋalihisya mu moni ja Musengwa Hatonda wuwo, mu hifo ehi alitobola ohumujumirihisyangamo. Musaŋalihisyanga ŋalala nʼabaana benywe abaseere nʼabahaana nʼabeedu benywe abasinde nʼabahasi ko nʼAbaleevi abomu bibuga byenywe, nʼabalugendwa nʼabafuubbi nʼabanamwandu abamenya ni neewe. ");
INSERT INTO nuj_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","Ohebuliranga oti waali mwidu e Misiri, olwʼehyo ofubangaho ohugondera amagambi ago gosigosi. ");
INSERT INTO nuj_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","“Nʼohenanga ohubunga engaano era nʼojungire nʼomwenge, olyanga Embaga eyʼEbitiira ohuhena endaalo musanvu. ");
INSERT INTO nuj_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","Osaŋalihisyanga ŋalala nʼabaana babo abaseere nʼabahaana, nʼabeedu babo abasinde nʼabahasi ko nʼAbaleevi abomu bibuga bibyo, nʼabalugendwa nʼabafuubbi nʼabanamwandu abali mu bibuga bibyo. ");
INSERT INTO nuj_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","Olwʼohuŋa Musengwa Hatonda wuwo eŋono, olyanga Embaga eyo ohuhena endaalo musanvu, mu hifo ehi alitobola, olwohuba njʼahuŋa ekabi ohusuna amakungula amangi era ahuŋa ekabi mu hiisi ehi ohola. Embaga eyo yija huba ya husangaala. ");
INSERT INTO nuj_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","“Emirundi edatu hiisi mwaha, abasinde bosibosi bali nʼohutiinanga ohujumirya Musengwa Hatonda wuwo hu Mbaga eyʼEmigaati Ejibatatayemo Ehisimbulusa, Embaga eyʼAmakungula ko nʼEmbaga eyʼEbitiira, mu hifo ehi alitobola. Ne ŋaŋuma atiina nʼengalo njereere mu moni ja Musengwa. ");
INSERT INTO nuj_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","Hiisi muutu aŋangayo ehi asobola ngʼolu Musengwa Hatonda wuwo aliba nʼamuŋaaye ekabi. ");
INSERT INTO nuj_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","“Tobola abalamuzi nʼabaŋugi ohuŋwa mu hiisi hiha hyenywe mu bibuga byosibyosi ebi Musengwa Hatonda wuwo ali huhuŋa. Era bali nʼohusala emisango ni batehubbira. ");
INSERT INTO nuj_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","Sosaliranga muutu musango nʼotya oba ni wehubbira. Era solyanga nguzi olwohuba enguzi yigala emoni jʼabaatu abali nʼamagesi era yagodamya ebibono byʼabagwalaafu, nga baŋa esala embi. ");
INSERT INTO nuj_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","Ŋabeŋo ohutehubbira mu hiisi hiitu ko osobole ohuba mulamu era osikire ehyalo ehi Musengwa Hatonda wuwo ahuŋa. ");
INSERT INTO nuj_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","“Sohomehanga siiro eyʼAsera huupi nʼehituuti ehi oja hutongolera Musengwa Hatonda wuwo. ");
INSERT INTO nuj_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","Era siwebboteranga esiiro ejʼamabaale ohujumirihisyaho olwohuba Musengwa Hatonda wuwo, abicaawa.” ");
INSERT INTO nuj_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","Nga Musa geyongera aloma ati, “Soŋongeranga Musengwa Hatonda wuwo eŋombe oba etaama oba embusi endwaye oba eriho embalo, olwohuba ebirabo ebiri hyʼebyo byambiho. ");
INSERT INTO nuj_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","Ni muliba ni mumenyire mu bibuga ebi Musengwa Hatonda wenywe aja huhuŋa, ne mweyagaana mulala hu enywe omusinde oba omuhasi naholire ehibi mu moni ja Musengwa Hatonda wuwo gabbwanga endagaano, ");
INSERT INTO nuj_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","gajumirya era gaŋeeresa abahatonda abandi oba eryuba oba omwesi oba emunyeenye, oba ehiitu hyosihyosi ehiri mu bbanga, ebiitu ebi nagaana, ");
INSERT INTO nuj_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","nʼoŋulirangaho ehiitu hyehyo, wendulirisanga bulaŋi weene wafaania ehituufu. Singa hiba hituufu ti ehiitu hyehyo ehyʼembiho hiriŋo mu Yisirayiri, ");
INSERT INTO nuj_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","oŋambanga omusinde oba omuhasi oyo ahola ehiitu ehyo, wamuŋira ŋa mulyango gwʼehibuga, wamuhubba amabaale, gaafa. ");
INSERT INTO nuj_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","Aye siwiitanga muutu hu lwʼobujulizi wʼomuutu mulala. Bali nʼohuba abajulizi babiri oba badatu abamulumiirisa. ");
INSERT INTO nuj_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","Abajulizi abo njʼabasookanga ohumuhubba amabaale ko abaatu abandi boosi balondaho. Mu ngeri eyo, oja hutusaŋo ehibi ohuŋwa mu enywe. ");
INSERT INTO nuj_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","“Singa mu mbuga ŋabaaŋo esonga engosi yʼohusalaŋo, ngʼehyohuboneraho, oba omuutu omusango gumuhira ni gagenderera oba sigagenderera ohwita owahye. Ehiitu hyehyo hinabaŋo, otiinanga mu hifo ehi Musengwa Hatonda wuwo alitobola, ");
INSERT INTO nuj_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","nga wanjula esonga eyiri abasengi Abaleevi oba omulamuzi aba nʼali hu lugobo mu hiseera ehyo. Baja huheja mu songa ejo, basaleŋo. ");
INSERT INTO nuj_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","Mu hifo ehyo ehi Musengwa aja hutobola ohumujumirihisyangamo, baja husalaŋo ehyohuhola. Era oli nʼohuhola ehyene nʼehyene ehi bahuloma ohuhola. ");
INSERT INTO nuj_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","Ofugiiriranga esala yaawe eyʼomusango era wahola hiisi ehi baba ni basalireŋo ni ŋaŋuma hulehayo oba hwongesaho hiitu hyosihyosi. ");
INSERT INTO nuj_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","Omuutu yesiyesi ajerega ehi omulamuzi oba omusengi aŋeeresa Musengwa Hatonda wuwo aba nʼasalireŋo, ali nʼohufa. Mu ngeri eyo oja hutusaŋo ehibi mu Yisirayiri. ");
INSERT INTO nuj_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","Hiisi aja huŋulira, aja hutya, ngʼagondera ehiragiro hyʼembuga. ");
INSERT INTO nuj_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","“Oli huupi hwola mu hyalo ehi Musengwa Hatonda wuwo ahuŋa. Nʼoliba nʼohenire ohwihala mu hyalo ehyo, osobola ohuŋeega oti, ‘Hiraŋi hwesi ohuba ni habaha ngʼolu abamawanga agandi agandireene gali ni naye.’ ");
INSERT INTO nuj_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","Otobolanga omuutu oyu Musengwa Hatonda wuwo aliba nʼatobooye era ali nʼohuba mulala hu enywe. Simufuulanga omulugendwa ohuba habaha wenywe. ");
INSERT INTO nuj_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","Habaha oyo sigehumbaanihisyangaho embalaasi, oba gaatuma abaatu e Misiri ohugula embalaasi, olwohuba Musengwa Hatonda wuwo gabaloma ati, ‘Simwagamanga e Misiri.’ ");
INSERT INTO nuj_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","Habaha sigehumbaanihisyangaho bahasi bangi, olwohuba baja huleetera omwoyo gugwe ohuŋwa hu Musengwa. Era atehumbaanihisyangaho efeeza nʼezaabbu. ");
INSERT INTO nuj_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","“Nʼatandihanga ohuŋuga nga habaha, atiinanga ewʼabasengi Abaleevi gaŋandiiha amagambi ago mu hitabo. Abeho nʼekopi yiye. ");
INSERT INTO nuj_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","Ali nʼohugasomanga hiisi hiseera mu bulamu wuwe wosiwosi. Ehyo hija humuleetera ohutya Musengwa Hatonda wuwe nʼagondera amagambi nʼebiragiro ebyo byosibyosi. ");
INSERT INTO nuj_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","Ehyo hija humuleetera ohutehudumbasanga hu bahye naŋeega ati wanjabulo. Era hija hugira atabbaama ohuŋwa hu biragiro wayire ŋadiidiri. Ehyo hija humuleetera niye nʼabolulyo lulwe ohuŋuga Yisirayiri emyaha nʼemyaha.” ");
INSERT INTO nuj_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","Nga Musa geyongera aloma ati, “Mu Bayisirayiri bosibosi, ehiha hyʼAbaleevi sihija husuna muŋuluko. Aye abasengi nʼAbaleevi baja husunanga ehyohulya hu birabo ebi baŋongera Musengwa. Ebyo njʼebija ohuba omugabo gwawe. ");
INSERT INTO nuj_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","Mu biha byosibyosi ebyʼAbayisirayiri, Abaleevi sibaja husuna omuŋuluko. Aye nibo omugabo gwawe, guja huŋwanga mu mulimo gwawe ogwʼobusengi Musengwa ngʼolu gabasuubisa. ");
INSERT INTO nuj_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","Abaatu banaŋonga eŋombe oba embusi oba etaama, abasengi baja huŋiranga omuhono nʼesaya ko nʼebyomuhida. ");
INSERT INTO nuj_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","Oŋanga abasengi engaano eyomu egesa edaayi nʼomwenge ogwomu mizabbibbu oguweheerera ohunyisa ohuŋwa mu mizabbibbu jijo nʼamafuta agomu mizayiti jijo ko nʼamooya aga weheerera ohusala hu taama jijo. ");
INSERT INTO nuj_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","Hiri hiityo olwohuba mu biha bibyo byosibyosi, Musengwa Hatonda wuwo gatobolamo ehiha hya Leevi ohumuŋeeresanga emirembe nʼemirembe. ");
INSERT INTO nuj_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","Singa Omuleevi asenguha ohuŋwa mu hibuga hyosihyosi mu Yisirayiri, gatiina mu hifo ehi Musengwa aja hutobola ohumujumirihisyangamo, ");
INSERT INTO nuj_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","aŋeeresenga Musengwa Hatonda wuwe hyʼAbaleevi bahye abandi bosibosi abaŋeeresa Musengwa eyo. ");
INSERT INTO nuj_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","Aja husunanga omugabo hu ŋongo nʼebirabo hyabahye, wayire aja huba nʼasunire omugabo hu ebi aliba nʼatundire hu bibye nʼasenguha. ");
INSERT INTO nuj_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","“Ni wolanga mu hyalo ehi Musengwa Hatonda wuwo ahuŋa, wegenderesanga ohutahoopa esambo jʼabaatu abo aba omenyiremo. ");
INSERT INTO nuj_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","Ngʼehyohuboneraho, soŋongangayo abaana babo ngʼebirabo ebi bohya ebihwiye byaguguliha. Era solehanga muutu yesiyesi ohulagula oba ohuloga oba ohuhola obufumu, ");
INSERT INTO nuj_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","wayire ohuhubba ebidaada oba ohusenga emisambwa oba ohwebuusa hu bafu. ");
INSERT INTO nuj_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","Hiisi ahola ebiitu hyʼebyo, aba wambiho eyiri Musengwa. Olwʼamawanga agandi ago ohuhola ebiitu ebyʼembiho hyʼebyo, cʼehigira Musengwa Hatonda wuwo aja hugabbinga gahuŋweremo. ");
INSERT INTO nuj_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","Aye ewe oli nʼohuba nga oŋumaaho hamogo mu moni ja Musengwa Hatonda wuwo. ");
INSERT INTO nuj_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Abaatu abamawanga agomu hyalo omu oli hutiina era aba oli huupi hubbinga, bebuusa hu balagusi nʼabamayembe. Aye Musengwa Hatonda wuwo ahugaana ohuholanga ebiitu hyʼebyo. ");
INSERT INTO nuj_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","“Musengwa Hatonda wuwo alihutumira naabbi ohuŋwa mu balebe babo abeene ngʼolu gaatuma ese. Nʼaliija mudembuhiranga byosibyosi ebi alibaloma. ");
INSERT INTO nuj_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","Hiri hiityo olwohuba ewe womwene wasunga hu ludaalo olu watiina ŋaapi hu lusozi Horebbu oti, ‘Ndehe teeyongera ohuŋulira ejanjaasi lya Musengwa Hatonda wange oba ohubona omuliro ogwʼamaani guno, olwohuba nja hufa.’ ");
INSERT INTO nuj_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","“Ngʼaŋo Musengwa gandoma ati, ‘Ehi asunga, hiraŋi. ");
INSERT INTO nuj_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Ndinyosaŋo naabbi ali hyʼewe ohuŋwa mu balebe baawe. Nja humuŋa obuhwenda era aja hulomera abaatu ebi mulagira. ");
INSERT INTO nuj_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Hiisi atalihola ebi aloma ohuŋwa eyi ndi, nja humuvunaana. ");
INSERT INTO nuj_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","Aye singa naabbi yesiyesi aloma ati obuhwenda obu alomera abaatu, buŋwa eyiri Musengwa oba aloma hu lwʼobuŋangi wa hatonda owundi yesiyesi, naabbi oyo ali nʼohufa.’ ");
INSERT INTO nuj_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","“Ne osobola ohwebuusa oti, ‘Nja hufaanihisyanga hu hi ti obunaabbi owo buŋwa eyiri Musengwa oba bbe?’ ");
INSERT INTO nuj_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","Singa naabbi aloma ati ebi aloma biŋwa eyiri Musengwa aye ndibyolerera, mumanyanga muuti obuhwenda wa naabbi oyo, sibuŋwa yiri Musengwa. Olwʼehyo aloma hu lulwe, simumutyanga.” ");
INSERT INTO nuj_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","Nga Musa geyongera aloma ati, “Musengwa Hatonda wuwo nʼalisihiirisa abaatu abali mu hyalo ehi ali huhuŋa, oja humenya mu bibuga nomu mago gaawe. ");
INSERT INTO nuj_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","Olitobolamo ebibuga bidatu ebyʼohweŋogomamo mu hyalo ehi Musengwa Hatonda wuwo ali huhuŋa hibe omuŋuluko. ");
INSERT INTO nuj_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","Wabulanga amatwale adatu mu hyalo ehyo ehi Musengwa Hatonda wuwo ali huhuŋa. Hiisi twale mubemo ehibuga hirala ehyohweŋogomamo. Ehibuga ehyo hiri nʼohuba aŋaatu aŋa muutu asobola ohwola mangumangu. Omuutu aba ni getire owahye nʼatagendereeye, asobole ohudulumira mu hirala hu bibuga ebyo. ");
INSERT INTO nuj_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","Singa omuutu yesiyesi geeta owahye nʼatagendereeye era nʼatabaaye mulabe wuwe, adulumiranga mu hirala hu bibuga ebyo, gaŋonia obulamu wuwe. ");
INSERT INTO nuj_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","Ehyʼohuboneraho, singa omuutu atiina nʼowahye mu hibira ohutema ebisaala, ngʼembasa ejonohamo, ehubba owahye ngʼafa, oyo oyu embasa yiŋunuhire, adulumiranga mu hirala hu bibuga ebyo, gaŋonia obulamu wuwe. ");
INSERT INTO nuj_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","Singa ohugenda ohwola hu hibuga ehyohweŋogomamo ehya ŋaapi ŋaba ŋaleeŋi, omulebe wʼomufu nʼobusungu aŋangire ohwenda gesasuse olwʼomuutu afuuye, singa alonda hu geetire era gamwolaho aja humwita, ate ola sigagenderera. ");
INSERT INTO nuj_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","Cʼehigira mbalagira ohutobolamo ebibuga bidatu ebyʼohweŋogomamo. ");
INSERT INTO nuj_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","“Singa Musengwa Hatonda wuwo agalamya esalo jijo ngʼolu galayirira abasehulu babo era gahuŋa ehyalo hyosihyosi ehi gasuubisa, ");
INSERT INTO nuj_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","otobolangamo ebibuga ebindi bidatu ebyʼohweŋogomamo. Aja huhuŋa ehyalo ehyo singa ofubangaho ohugondera ebiragiro bibye byosibyosi ebikuŋa olwa leero, nʼoja hwendanga Musengwa Hatonda wuwo, wahola ebi genda nʼogendera mu magira gage. ");
INSERT INTO nuj_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","Ehyo hija huleetera ohuhinga ohwita abaatu abaŋumaho musango mu hyalo hihyo ehi Musengwa Hatonda wuwo ali huhuŋa ohuba muŋuluko gugwo. Era solibaho musango ogwohwita omuutu. ");
INSERT INTO nuj_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","“Aye singa omuutu acaawa owahye, ngʼamweteega gamuhubba gaafa, ngʼahena adulumira mu hirala hu bibuga ebyo, ");
INSERT INTO nuj_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","abatangirisi bʼehibuga hyʼewaawe batumanga abaatu bamutusayo, bamuŋaayo mu mihono jʼomuutu oli nʼohwesasusa, yeesi amwite. ");
INSERT INTO nuj_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","Soŋambiranga omuutu hyʼoyo ehisa. Oli nʼohutusaŋo omusango ogwʼohwita aŋumaho songa mu Yisirayiri, ko ebiitu bihutiinirenga bulaŋi. ");
INSERT INTO nuj_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","“Ni wolanga mu hyalo ehi Musengwa Hatonda wuwo ahuŋa, sonyaganga eroba lya muutu yesiyesi nʼohuula ebiroowa ebi basehulu babo baahoma. ");
INSERT INTO nuj_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","“Omujulizi mulala yeŋene saahena hulumirisa muutu ni bamusalira omusango. Hiisi songa bayihahasenga ni ŋaliŋo obujulizi owʼabaatu babiri oba badatu. ");
INSERT INTO nuj_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","Singa omuutu yesiyesi gemeerera ohulumiirisa owahye omusango naaŋa obujulizi owobudulingi, ");
INSERT INTO nuj_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","abaatu bombi batiinanga mu hifo ehi Musengwa aliba nʼotobooye ohumujumirihisyangamo, bemeerera mu moni jʼabasengi nʼabalamuzi mu hiseera ehyo. ");
INSERT INTO nuj_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","Abalamuzi bendulirisanga esonga eyo bulaŋi weene. Ne banazuula baati omujulizi mudulingi era aŋaayirisa owahye, ");
INSERT INTO nuj_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","mumuŋanga ehibonerezo ehi abaaye ni gendesa owahye. Muli nʼohutusaŋo ehibi. ");
INSERT INTO nuj_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","Abaatu abandi ni baja huŋulira, baja hutya era ŋaja huŋumaŋo aja huloma ebyakalebule hu wahye. ");
INSERT INTO nuj_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","Simuŋambiranga omuutu hyʼoyo ehisa. Ehibonerezo hyʼoyo akosa obulamu wowahye, husasulwa obulamu, akosa emoni yeesi bamukose emoni, linaba liino yeesi bamukose liino, gunaba muhono yeesi bamukose omuhono, hunaba hugulu yeesi bamukose ohugulu.” ");
INSERT INTO nuj_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","Nga Musa geyongera aloma ati, “Nʼotiinanga ohusoosa abalabe babo, wabona embalaasi nʼamagaali nʼeŋe erisinga eriryo obubbala, sotyanga, olwohuba Musengwa Hatonda wuwo owahutusa e Misiri, aja huba ŋalala ni neewe. ");
INSERT INTO nuj_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","Ko mutiine mu lutalo, omusengi wa Hatonda aja huloma abasooli ati, ");
INSERT INTO nuj_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","‘Tega ohutwi ewe Yisirayiri! Olwaleero otiina ohusoosa omulabe wuwo. Otatya wayire ohuteetema mu moni jaawe. ");
INSERT INTO nuj_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","Hiri hiityo olwohuba Musengwa Hatonda wenywe njʼali hutiina ni nenywe ohusoola nʼabalabe benywe era aja hubaŋa obuŋangusi.’ ");
INSERT INTO nuj_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","“Ngʼaŋo abaduumisi baloma abasooli abo baati, ‘Eriyo owamba atongola enyumba aye ahiiri hu yiŋonga eyiri Hatonda? Leha gagameyo ewuwe olwohuba aŋanga gafiira mu lutalo, ngʼowundi ayiŋongayo, ayeyingirira. ");
INSERT INTO nuj_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","Eriyo owahoma endimiro eyʼemizabbibbu, ne ahiiri hulyaho ebibala? Leha yeesi gagame ewuwe. Atafiira mu lutalo ngʼowundi geyagalira mu bibala bibye. ");
INSERT INTO nuj_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","Eriyo owasuna omuhasi ne ahiiri humuŋira? Leha yeesi gagameyo ewaawe, olwohuba asobola ohufiira mu lutalo, omuutu owundi gamuŋiraho omuhasi.’ ");
INSERT INTO nuj_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","Nindi abaduumisi baja hubuusa abasooli baati, ‘Ŋaliŋo ali hutya oba aŋoyemo omwoyo? Gagameyo ewaawe, olwohuba asobola ohuleetera abahye boosi ohuŋwamo omwoyo.’ ");
INSERT INTO nuj_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","Ŋaahani abaduumisi bʼamaŋe ni bahena ohulaabbira abasooli, baja hwangala abatangirisi abohuduumira ebibinja. ");
INSERT INTO nuj_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","“Ni wolanga hu hibuga ehyohusoosa, osookanga waŋa abaatu bamo ekabi ohweŋaayo ni ŋaŋuma husoola. ");
INSERT INTO nuj_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","Singa bafugiirira ohweŋaayo, bahweguliraŋo emiryango jʼehibuga hyawe wengira, abaatu abo bosibosi obafuulanga beedu babo. ");
INSERT INTO nuj_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","Ne singa bagaana ohweŋaayo eyi oli, ni benda bahusoose, weswanigirisanga ehibuga ehyo paka olu olihiŋangula. ");
INSERT INTO nuj_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","Musengwa Hatonda wuwo nʼahiŋangayo mu mihono jijo, osihiirisanga abasinde bosibosi. ");
INSERT INTO nuj_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","Aye abahasi nʼabaana abaŋere, nʼebyayo ko nʼebiitu ebindi byosibyosi mu hibuga ehyo, weŋiriranga. Era otambisanga ebyʼomunyago byosibyosi ebi Musengwa Hatonda wuwo, ahuŋa. ");
INSERT INTO nuj_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","“Ohulaabbira huno huŋamba hu bibuga byosibyosi ebi bali aŋaleeŋi, ebitali byʼomulirano. ");
INSERT INTO nuj_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","Aye ebibuga ebyomu hyalo ehi Musengwa Hatonda wuwo ahuŋa ohuba obusika, solehanga hiitu ehiramu hyosihyosi ni hiŋeera. ");
INSERT INTO nuj_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","Osihiirisanga abaatu bosibosi: Abahiiti nʼAbamooli nʼAbakanani nʼAbapereezi nʼAbahiivi ko nʼAbayebbusi, ngʼolu Musengwa Hatonda wuwo gahulagira. ");
INSERT INTO nuj_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","Hiri hiityo olwohuba baja hubaleetera ohuhola ebiitu ebyʼembiho byosibyosi ebi bahola ni bajumirya abahatonda baawe, nga mwonoona eyiri Musengwa Hatonda wenywe. ");
INSERT INTO nuj_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","“Nʼoneswanigirisenga ehibuga ohuhena ehiseera ehireeŋi, nʼosoosa abaatu baamo ohubaŋamba, sosihiirisanga bisaala, olwohuba osobola ohulyaho ebibala era sobitemanga. Ebisaala balabe benywe ko obiteme? ");
INSERT INTO nuj_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","Osobola ohutema emisaala ejo eji omanyire oti sijaama bibala, wabitambisa ohubbota ebi wetaaga mu husoosa ehibuga ehyo, ohwola olu ohiŋangula.” ");
INSERT INTO nuj_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","Nga Musa geyongera aloma ati, “Singa mu hyalo ehi Musengwa Hatonda wuwo ahuŋa, obona omuutu yesiyesi oyu batemuuye ne nʼotamanyire amwitire, ");
INSERT INTO nuj_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","abatangirisi nʼabalamuzi babo banatiinenga bapima ebbanga ohuŋwa hu mulambo ohwola hu bibuga ebirireene. ");
INSERT INTO nuj_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","Abatangirisi bʼehibuga ehisinga ohuba ohuupi nʼomulambo gwʼomuutu oyo oyu batemuuye, baŋambanga omusodi gwʼeŋombe oguhiiri huholaho mulimo gwosigwosi era ogutagegangaho hijoogi. ");
INSERT INTO nuj_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","Abatangirisi bʼehibuga ehyo, baŋambanga omusodi ogwo baguŋira mu hiiho, ehifo ehiŋumamo bulimire ehirimo amaaji agahulumuta. Ngʼaŋo bagubbwaga egosi mu hifo ehyo. ");
INSERT INTO nuj_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","Abasengi, ohuŋwa mu lulyo lwa Leevi boosi bali nʼohutiinayo olwohuba Musengwa Hatonda wuwo gabatobola ohumuŋeeresanga nʼohusabiranga abaatu ekabi mu siina lya Musengwa. Gabaŋa obuŋangi ohugonjoola ebiba ni bidobire. ");
INSERT INTO nuj_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","Era abatangirisi bosibosi abomu hibuga ehyo ehisingira erala ohuba ohuupi nʼomulambo ogwo, baja husaabira mu ngalo hu sodi eyo eyibabbwagire egosi mu hiiho omwo, ");
INSERT INTO nuj_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","ni baloma baati, ‘Efe sindiife ohwatemula omuutu ono era sihumanyire nʼowamutemula. ");
INSERT INTO nuj_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","O Musengwa, soniŋa abaatu babo Abayisirayiri aba wanunula, batabaho musango ogwʼobutemu.’ Era baja hubasoniŋa. ");
INSERT INTO nuj_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","Kale mu ngeri eyo munetusengaho omusango ogwʼohujuha omusaayi gwʼomuutu aŋumaho musango olwohuba munabenga muholire ehiitu ehiraŋi mu moni ja Musengwa. ");
INSERT INTO nuj_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","“Nʼotiinanga mu lutalo ohusoola nʼabalabe babo, nga Musengwa Hatonda wuwo ahuleetera ohubaŋangula, waŋiraho abandi ngʼabasibe, ");
INSERT INTO nuj_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","nga mu basibe abo obonaamo omuhasi omuŋoono oyu wegomba ohuŋira obufumbo, ");
INSERT INTO nuj_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","oja humuŋira mu nyumba ewuwo ngʼabegaho efiiri era omusalaho nʼebidete. ");
INSERT INTO nuj_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","Aja hucuusa ebyambalo ebi gaalimo ni bamuŋamba mu lutalo. Aja huba mu nyumba yiyo ohuhena omwesi omuhwiye nʼalira nyina ni semwana. Oluvanyuma lwʼomwesi, omufuulanga muhasi wuwo era yeesi aja hufuuha wuwo. ");
INSERT INTO nuj_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","Ne ni ŋabitireŋo ehiseera, anaba nʼatahusangaasa, omuleehanga getiinira eyi aba ni genda. Somutundanga oba ohumubisya hyʼomwidu olwohuba abaaye muhasi wuwo. ");
INSERT INTO nuj_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","“Singa omuutu aba nʼabahasi babiri: nawende ni nawunobe, ne bombi bamusaalira abaana, cooka ngʼomwana omuseere omudaayi aba wʼomuhasi nawunobe, ");
INSERT INTO nuj_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","saawe ni gosanga ehiseera ehyʼohugaba abaana babe ebiitu, safuulanga mwana wa nawende ohuba omusika mu hifo hyʼomwana omuseere omudaayi owa nawunobe. ");
INSERT INTO nuj_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","Aye ali nʼohulaga ati omwana owʼomuhasi nawunobe njʼomudaayi, gamuŋa emigabo ebiri hu biitu bibye byosibyosi ebi ali ni nabyo, olwohuba njʼomwana omudaayi owamwita amaseere. ");
INSERT INTO nuj_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","“Singa ŋabaaŋo omuutu ali nʼomwana owehingubere era omujeemu, otagondera semwana oba nyina era saŋulira wayire bamuŋamo endabusi, ");
INSERT INTO nuj_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","abasaaye babe baja humuŋamba bamuŋire eyiri abatangirisi bʼehibuga ehi bamenyamo. ");
INSERT INTO nuj_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","Ni boola, baja huloma abatangirisi baati, ‘Omwana weefe ono musiŋa era mujeemu, saŋulira ebi humuloma. Ali nʼomulyerye era mumeesi.’ ");
INSERT INTO nuj_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","Ohutusaŋo ehibi, abasinde bosibosi abomu hibuga ehyo, baja huŋamba amabaale bamuhubbe, bamwite. Era hiisi Muyisirayiri aja huŋulira, aja hutya geŋomehe. ");
INSERT INTO nuj_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","“Singa omuutu ahola ehibi bamusalira ogwʼohufa ni bamubambire hu musaala, ");
INSERT INTO nuj_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","omulambo gugwe siguŋenyuhanga hu musaala gwahyesa aye omusihanga hu ludaalo olwene olwo, olwohuba omuutu oyu babambire hu musaala aliho ehiŋwabo hya Hatonda. Sofuulanga ehyalo ehi Musengwa Hatonda wuwo ali huhuŋa ngʼobusika, ohuba ehyʼembiho.” ");
INSERT INTO nuj_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","Nga Musa geyongera aloma ati, “Singa obona eŋombe oba etaama yʼowahyo ni yiri hugota, otagaana humuyeeda. Oyiŋambanga wamwagamihisya. ");
INSERT INTO nuj_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","Ne omweneeyo anaba nʼali ŋaleeŋi oba nʼotamumanyire, oyiŋiranga ewuwo wayihuuma ohwola olu aliija nʼayendula, ngʼoyimuŋa. ");
INSERT INTO nuj_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","Era pooja huholanga otyo ni wageene nasugirya oba olugoye oba ehiitu hyosihyosi ehyʼowahyo ehiba ni higotire. Sohibitangaho huhibitaho. ");
INSERT INTO nuj_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","Era singa obona nasugirya oba eŋombe yʼowahyo ni yiguuye hu ngira, omuyeedanga wayenyosa. ");
INSERT INTO nuj_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","“Omuhasi sigambalanga hyambalo hyʼomusinde era nʼomusinde yeesi sigambalanga hyambalo hyʼomuhasi olwohuba hiisi ahola atyo, aba afuuhire hyambiho eyiri Musengwa Hatonda wuwo. ");
INSERT INTO nuj_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","“Singa osaŋaana ehitala hyʼenyuni, hu musaala oba aŋaatu ŋosiŋosi nʼegonera oba nʼefumbereeye owaana waayo, soŋiranga nyuni eyo nʼobwana waayo woosi. ");
INSERT INTO nuj_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","Oŋiranga owaana aye waleha nyina, ko ebiitu bihutiinirenga bulaŋi era olisuna obuwangazi. ");
INSERT INTO nuj_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","“Singa otongola enyumba, oli nʼohugadirira ŋamugulu ohu baatu beyalihisa ko omuutu atagwa ohweleetaho omusango ogwʼohwita. ");
INSERT INTO nuj_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","“Singa ohoma emizabbibbu, sotangamo ehibala oba ehiitu ehindi mu ndimiro eyo. Ne singa ohomaamo ehiitu ehindi, sibibala ebi oba nʼohomiremo byoŋene aye nʼemizabbibbu joosi jiba jambiho. ");
INSERT INTO nuj_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","Sosidihanga esaame ni nasugirya hu hijoogi hirala, ohulima. ");
INSERT INTO nuj_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","Siwambalanga ehyambalo ehya mooya gʼetaama nʼejehiha hya laasi. ");
INSERT INTO nuj_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","“Oja hutunganga obujwenge hu sonda ene ejʼehyambalo hihyo. ");
INSERT INTO nuj_vpl VALUES ("DT22_13","006_22_13","DEU","22","13","13","“Singa omuutu aŋira omuhasi obufumbo, ngʼaŋenyuha ni naye era oluvanyuma olwʼehiseera hidiidiri ngʼamucaawa, ");
INSERT INTO nuj_vpl VALUES ("DT22_14","006_22_14","DEU","22","14","14","nga gonoona esiina lyʼomuhasi oyo ati, ‘Naŋira omuhasi oyo ohufuuha muhasi wange aye navumbula ti gaali aŋenyuhireho nʼabasinde abandi.’ ");
INSERT INTO nuj_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","Singa ehyo hibaaŋo, abasaaye bʼomuhaana oyo batiinanga ŋa mulyango gwʼehibuga balaga abatangirisi amasuuka ohuhahasa ti ebi omusinde oyo aloma byakalebule. ");
INSERT INTO nuj_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","Era semwana yʼomuhaana aja huloma abatangirisi ati, ‘Naŋa omusinde ono omuhaana wange ohumufumbirwa aye ŋaahani samwenda, ");
INSERT INTO nuj_vpl VALUES ("DT22_17","006_22_17","DEU","22","17","17","amulomaho ebyakalebule ati mbo omuhaana wange gaali aŋenyuhireho nʼabasinde abandi. Ne amasuuka ngagano galiho nʼamafugi ehiraga hiiti ehi oyo aloma sihituufu.’ Ngʼabasaaye bʼomuhaana oyo, banjulusa amasuuka ago agaliho amafugi mu moni jʼabatangirisi bʼehibuga. ");
INSERT INTO nuj_vpl VALUES ("DT22_18","006_22_18","DEU","22","18","18","Abatangirisi bʼehibuga baja huŋamba omusinde oyo bamuŋemo endabusi ");
INSERT INTO nuj_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","olwohuba aloma ebyakalebule hu muhasi wuwe. Baja humuliŋisa efeeza cikumi ajiŋe semwana yʼomuhaana oyo era sibamufugiiriranga hulehaŋo muhaana oyo. ");
INSERT INTO nuj_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","“Aye singa omusinde aba mutuufu era ni ŋaŋumaŋo ehiraga hiiti omuhaana gaali saŋenyuhangaho nʼomusinde, ");
INSERT INTO nuj_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","baŋambanga omuhaana oyo bamuŋira hu mulyango gwʼenyumba ya semwana, ngʼabasinde abomu hibuga ehyo bamuhubba amabaale bamwita, olwohuba gaahola ehiitu ehyʼesoni mu Yisirayiri, ohuŋenyuha nʼomusinde otali wamwe nʼahiiri hu lunya lwa semwana. Era muli nʼohutusaŋo ehibi. ");
INSERT INTO nuj_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","“Singa bagaana omusinde nʼali hu muhasi wabeene, bombi bali nʼohufa. Ehyo hija hutusaŋo ehibi mu Yisirayiri. ");
INSERT INTO nuj_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","“Singa omuutu gagaana omuhaana mu hibuga ataŋenyuhangaho nʼomusinde era omuhaana oyu bahena hale ohuhwa, ngʼomuutu oyo aŋenyuha hu muhaana oyo, ");
INSERT INTO nuj_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","muŋambanga bombi mwabaŋira ŋa mulyango gwʼehibuga ehyo, mwabahubba amabaale, baafa. Ehitisa omuhaana oyo, huba mu hibuga nasahubba nduulu, bamutaase. Omusinde aja hufa olwohwetambagania hu muhabeene. Ehyo hija hutusaŋo ehibi. ");
INSERT INTO nuj_vpl VALUES ("DT22_25","006_22_25","DEU","22","25","25","Aye singa omusinde gagaana omuhaana oyu bahena hale ohuhwa nʼali mu ndimiro hutulo wʼehibuga eyo, ngʼamufahira amuŋenyuhaho, omusinde yeŋene njʼoyu baja ohwita. ");
INSERT INTO nuj_vpl VALUES ("DT22_26","006_22_26","DEU","22","26","26","Simuholanga muhaana oyo hibi hyosihyosi olwohuba aŋuma hibi ehi aholire ehimwosa hu humwita. Omuhaana oyo afaana hyʼomuutu oyu bagwira hugwira beeta, ");
INSERT INTO nuj_vpl VALUES ("DT22_27","006_22_27","DEU","22","27","27","olwohuba omuhaana oyo gaali mu ndimiro eyi musinde gamwagaana ngʼamufuhumira. Wayire omuhaana gahubba enduulu, ŋaŋuma owadulumirira ohumutaasa. ");
INSERT INTO nuj_vpl VALUES ("DT22_28","006_22_28","DEU","22","28","28","Singa omuutu gagaana omuhaana ataŋenyuhangaho nʼomusinde era oyu bahiiri huhwa, ngʼamuŋenyuhaho era babagaana, ");
INSERT INTO nuj_vpl VALUES ("DT22_29","006_22_29","DEU","22","29","29","omusinde oyo ali nʼohuŋa semwana yʼomuhaana oyo esekeeli ataanu ejʼefeeza. Ngʼomuhaana oyo afuuha muhasi wuwe, olwohuba amusobisyeho. Era sibamufugiiriranga hulehaŋo muhaana oyo ngʼomuhasi wuwe. ");
INSERT INTO nuj_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","Ŋaŋumangaŋo muutu aŋira muha semwana, olwohuba ohwo huba hunyooma semwana.” ");
INSERT INTO nuj_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","Nga Musa geyongera aloma ati, “Omuutu oyu basaama oba oyu basalaho ehitundu hyomu hyama, satiinanga mu luhumbaano lwʼabaatu ba Musengwa. ");
INSERT INTO nuj_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","“Omuutu oyu basaalira hutulo satiinanga mu luhumbaano lwʼabaatu ba Musengwa, wayire ehijuhulu hihye ehyʼomulembe ogwʼehumi. ");
INSERT INTO nuj_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","“Eŋume Omwamooni oba Mumowaabbu oba ehijuhulu hyawe ehyʼomulembe ogwʼehumi abatiinanga mu luhumbaano lwʼabaatu ba Musengwa. ");
INSERT INTO nuj_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","Hiri hiityo olwohuba ni waali nʼoŋwa e Misiri, bagaana ohuhudulumirira nʼemere wayire amaaji. Era bagula ni Bbalamu omusaani wa Bbewori ohuŋwa mu hibuga hyʼe Pesori mu twale lyʼe Mesopotamya, ahuŋwabe. ");
INSERT INTO nuj_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","Aye Musengwa Hatonda wuwo gagaana ohuŋuliirisa ebya Bbalamu. Era Musengwa Hatonda gacuusa ehiŋwabo hyafuuha kabi, olwohuba ahwenda. ");
INSERT INTO nuj_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","Sosalanga muhago ni nabo oba ohubendesa ekabi emirembe nʼemirembe. ");
INSERT INTO nuj_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","“Sonyoomanga bejuhulu bʼEdomu, olwohuba baganda babo. Era sonyoomanga Abamisiri, olwohuba waaliho mu hyalo hyawe ngʼomulugendwa. ");
INSERT INTO nuj_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","Osobola ohufugiirira abejuhulu bʼEdomu nʼAbamisiri abʼomulembe ogwohudatu ohubanga mu luhumbaano lwʼabaatu ba Musengwa.” ");
INSERT INTO nuj_vpl VALUES ("DT23_9","006_23_9","DEU","23","9","9","Nga Musa geyongera aloma ati, “Nʼotiinanga ohusoosa abalabe babo, weŋalenga ebiitu byosibyosi ebiŋanga ohuhufuula atali mulongoofu. ");
INSERT INTO nuj_vpl VALUES ("DT23_10","006_23_10","DEU","23","10","10","Singa ŋabaaŋo omuutu yesiyesi mu nywe atali mulongoofu olwʼohuloota nʼali nʼomuhasi mu buliri, abaŋwangamo gatiina gaba ebulafu wʼekambi ohuhena oludaalo oluhwiye. ");
INSERT INTO nuj_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","Aye ehyʼegulo esaawa aŋa yigwira mu maaji, asaabanga omubiri, gagobola mu kambi. ");
INSERT INTO nuj_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","“Oja hutaaŋo ehifo ewulafu wʼekambi aŋa onatiinenga ohweŋereha. ");
INSERT INTO nuj_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","Era omuutu ayabanga eroŋo, galisiiha nahenire ohweŋereha. ");
INSERT INTO nuj_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","Hiri hiityo olwohuba Musengwa Hatonda wuwo anaabenga ni neewe mu kambi ohuhunoŋola nʼohuhuyeeda ohuŋangula abalabe babo. Olwʼehyo, ekambi yiyo yiri nʼohuba nyonjo, ko atabona ehitali hiyonjo mu enywe, gabahubba omugongo. ");
INSERT INTO nuj_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","“Singa omwidu geyiba hu musengwawe gadulumira ewuwo, somuŋangayo. ");
INSERT INTO nuj_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","Omuleehanga gamenya hiisi aŋa aba ni gendire, nomu hibuga hyosihyosi ehi aliba ni genda. Somubisyanga bubi. ");
INSERT INTO nuj_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","“Siŋabangaŋo omuhasi oba omusinde Omuyisirayiri ahola owamalaaya mu yekaalu. ");
INSERT INTO nuj_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","Omuhasi oba omusinde owetunda mu yekaalu yaawe saŋiranga bbeesa ejʼobuhwendi mu nyumba ya Musengwa Hatonda wuwo wayire jiba jahwoheresa oweyamo. Hiri hiityo olwohuba Musengwa Hatonda wuwo acaawa ebiitu hyʼebyo. ");
INSERT INTO nuj_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","“Sosunganga magoba hu bbeesa oba hu mere oba ehiitu hyosihyosi ehi oba nʼoŋolire Omuyisirayiri wahyo. ");
INSERT INTO nuj_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","Osunanga amagoba hu banamawanga hu biitu ebi obaŋola, ne sosasusanga Muyisirayiri wahyo. Onaholanga otyo, Musengwa Hatonda wuwo aja huhuŋa ekabi mu byosibyosi ebi onaholenga mu hyalo ehi oja ohusuna hibe omuŋuluko. ");
INSERT INTO nuj_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","“Sogayalanga hwoheresa ehi oba nʼosuubihiise Musengwa Hatonda wuwo, olwohuba Musengwa Hatonda wuwo salireha huhihubuusa, nga hihuŋweramo omusango. ");
INSERT INTO nuj_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","Aye ni muteyamenga, simunabengaho hibi ehi muholire. ");
INSERT INTO nuj_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","Aye hiisi ehi osuubisanga, oli nʼohuhyoheresa, olwohuba wasuubisa nje Musengwa Hatonda wuwo mu hweyendera. ");
INSERT INTO nuj_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","“Singa otiina mu ndimiro eyʼemizabbibbu eyʼowahyo, olyanga emizabbibbu josijosi eji oba ni wenda aye sogeganga jindi mu hiseero waŋira engo. ");
INSERT INTO nuj_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","Singa otiina mu ndimiro yʼengaano eyʼowahyo, oŋululanga amagala walya aye soŋambanga ngeso watandiha hugesa ebitali bibyo.” ");
INSERT INTO nuj_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","Nga Musa geyongera aloma ati, “Singa omuutu asuna omuhasi, ne oluvanyuma ngʼazuula ehitali hiraŋi hu muhasi oyo, amuŋanga ebbaluŋa eyihahasa yiiti amubbingire. ");
INSERT INTO nuj_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","Singa omuhasi oyo atiina ngʼomusinde owundi amuŋira, ");
INSERT INTO nuj_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","era nga omusinde owohubiri amucaawa, nga yeesi amuŋandiihira ebbaluŋa emubbinga, oba singa wamwe owohubiri oyo afa, ");
INSERT INTO nuj_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","omusinde omudaayi sagobolangayo humufumbirwa nindi olwohuba ŋaahani omuhasi oyo simulongoofu. Ohugobolamo ohumuŋira hiba hyʼembiho mu moni ja Musengwa. Soholanga hiitu hyehyo ohwonoona ehyalo ehi Musengwa Hatonda wuwo ahuŋa ohuba obusika. ");
INSERT INTO nuj_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","“Singa omuutu aba ni gahasunanga omuhasi, sibamuŋiranga mu lutalo, wayire ohuhola omulimo ogundi ogwʼolukale. Aja hubanga ŋa ngo nʼasangaasa omuhasi wuwe ohuhena omwaha omuhwiye. ");
INSERT INTO nuj_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","“Singa oŋola Omuyisirayiri wahyo ebbeesa, osobola ohuŋira olubaale ngʼomusingo. Ne soŋiranga eso yoosi atafa enjala olwʼohuŋuma ehyohulya. ");
INSERT INTO nuj_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","Singa omuutu yesiyesi aŋamba Omuyisirayiri wahye gamugosyaŋo era gamubisya hyʼomwidu oba gamutunda ngʼomwidu, ahola ehiitu hyehyo ali nʼohufa. Muli nʼohutusaŋo ehibi ohuŋwa mu enywe. ");
INSERT INTO nuj_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","“Singa obulwaye wʼolugode buba buŋambire omuutu, wegenderesanga ohuhola ngʼolu abasengi Abaleevi bahusomesa ohuhola. Ogonderanga amagambi gosigosi aga nahulagira. ");
INSERT INTO nuj_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","Hebulira ehi Musengwa Hatonda wuwo gaahola Miryamu ni mwali ni muŋwa e Misiri. ");
INSERT INTO nuj_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","Singa oŋola Omuyisirayiri wahyo ehiitu hyosihyosi, siwingiranga mu nyumba yiye ohutusamo ehyambalo hihye ngʼomusingo. ");
INSERT INTO nuj_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","Oli nʼohusigala ebulafu, oyu oŋolire omwene gengire mu nyumba ahihuleetere. ");
INSERT INTO nuj_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","Singa oyo oyu oŋola aba mugadi, gasingayo ehyambalo, sobanga ni nahyo ohuhyesa. ");
INSERT INTO nuj_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","Omugobohesanga ehyambalo hihye ehyʼegulo asobole ohwewiiha owiire embeŋo yitamufuuŋa, gahahusabira ekabi era Musengwa Hatonda wuwo aja husangaala. ");
INSERT INTO nuj_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","“Sobisyanga bubi omuutu omugadi ahuholera ni genda asune ehyohwebesaŋo, wayire aba nʼali Muyisirayiri wahyo oba mulugendwa aba nʼamenya mu bibuga byenywe. ");
INSERT INTO nuj_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","Omusasulanga hiisi ludaalo olu aba nʼaholire eryuba ni lihiiri hugwa mu maaji, ehyo njʼehi aja hulyamo olwohuba mugadi. Singa somuŋa, aja huliririra Musengwa era aja huhuluŋira olwʼehibi ehi omuholire. ");
INSERT INTO nuj_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","“Simwitanga musaaye olwʼehibi hyʼomwana wuwe oba omwana olwʼehibi hyʼomusaaye wuwe. Omuutu omwene aba nʼaholire ehibi njʼali nʼohufa olwʼehibi hihye. ");
INSERT INTO nuj_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","“Simucaamyanga sala yʼomusango ogwʼomulugendwa nʼomufuubbi era simuŋiranga hyambalo hya namwandu ngʼomusingo olwʼebbanja. ");
INSERT INTO nuj_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","Ohebuliranga oti waali mwidu e Misiri, Musengwa Hatonda wuwo gahununula, cʼehigira kuŋa egambi eryo. ");
INSERT INTO nuj_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","“Singa ohungula ebirime bibyo ne webirira ehiganda hyʼengaano mu ndimiro, siwagamangayo ohuhitusamo. Ehyo ohireheranga abalugendwa ko nʼabafuubbi nʼabanamwandu, Musengwa Hatonda wuwo aja huhuŋa ekabi mu byosibyosi ebi ohola. ");
INSERT INTO nuj_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","Nʼohungulanga emizayiti, sogobolangayo hu musaala ohunoga ebisigayeho. Obireheranga abalugendwa nʼabafuubbi ko nʼabanamwandu. ");
INSERT INTO nuj_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","Nʼohungulanga emizabbibbu mu ndimiro yiyo, sogobolangamo huhenereramo ebyasigala. Obireheranga abalugendwa nʼabafuubbi ko nʼabanamwandu. ");
INSERT INTO nuj_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","Muhebulire muuti mwali beedu mu hyalo hyʼe Misiri, cʼehifa mbaŋa egambi lino.” ");
INSERT INTO nuj_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","Nga Musa geyongera aloma ati, “Singa ŋabaaŋo abaatu babiri ni bali nʼesonga bajiŋira embuga ngʼabalamuzi basalira mulala hu bo omusango ohumuhira, ");
INSERT INTO nuj_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","era banasalira oyu musango guhirire ohumuŋa efaalu ejimusaana, omulamuzi ali nʼohumulagira alambaale bajimuŋeere aŋo mu moni jije. ");
INSERT INTO nuj_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","Aye efaalu ejamusaliranga jitabita mu mahumi ane, olwohuba ehyo hija huswasa Omuyisirayiri wahyo. ");
INSERT INTO nuj_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","“Otasidihanga munwa gwʼesaame ni yirima wayirobeeresa ohwaya. ");
INSERT INTO nuj_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","“Singa abaganda babiri bamenya ŋalala ne mulala gaafa nʼatasaayeho mwana museere, namwandu safumbirwanga musinde owundi atali muganda yʼomufu. Mugandaawe ateehwa ohumusika amusaalire abaana. ");
INSERT INTO nuj_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","Omwana omuseere omudaayi, baja humubala ohuba wʼomugeezi ko esiina lyʼomufu litagota mu Yisirayiri. ");
INSERT INTO nuj_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","Aye muganda wʼomufu anagaana ohumusika, namwandu oyo atiinanga eyiri abatangirisi ŋa mulyango gwʼehibuga gabaloma ati, ‘Muganda ya wamwange agaana ohusunira mugandawe omusika mu Yisirayiri. Sigenda huusika goherese obuvunanyiziwa wa mugandawe eyi ndi.’ ");
INSERT INTO nuj_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","Abatangirisi bʼehibuga baaja humulanga balome ni naye. Ne singa agaanira erala era galoma ati, ‘Sinenda humusika,’ ");
INSERT INTO nuj_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","namwandu oyo hutiinanga aŋa musinde oyo ali, gamufihulamo engayito ngʼamufuujaho amate mu weeni mu moni jʼabatangirisi abo, ngʼaloma ati, ‘Hino njʼehi bahola omuutu agaana ohusika ohusaalira mugandawe abaana!’ ");
INSERT INTO nuj_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","Amago gage mu Yisirayiri banagalangenga baati, ‘Amago agʼomuutu oyu batusamo engayito.’ ");
INSERT INTO nuj_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","“Singa Abayisirayiri babiri basoola, omuhasi wʼomulala hu abo gayeeda wamwe, ngʼaŋamba ola ebitundu ebyʼehyama, ");
INSERT INTO nuj_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","omuhasi oyo omusalangaho omuhono era somuŋambiranga ehisa. ");
INSERT INTO nuj_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","13","“Simubanga nʼebipimo bibiri, ehituufu nʼehitali hituufu. ");
INSERT INTO nuj_vpl VALUES ("DT25_14","006_25_14","DEU","25","14","14","Era muli nʼohutambisanga ebipimo ebituufu. ");
INSERT INTO nuj_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","Oli nʼohutambisanga ebipimo ebituufu ko wangaalire mu hyalo ehi Musengwa Hatonda wuwo ali huhuŋa. ");
INSERT INTO nuj_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","Abo bosibosi abalyakula abahyawe nʼebipimo byawe ebitoola, bambiho mu moni ja Musengwa Hatonda wuwo. ");
INSERT INTO nuj_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","“Ohebuliranga ehi Abameleki bahuhola ni waali nʼoŋwa e Misiri. ");
INSERT INTO nuj_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","Bahulumba nʼodembire era nʼoŋooyemo amaani nga beeta abo bosibosi abaali egongo ni baŋegera. Baaŋuma hutya Hatonda. ");
INSERT INTO nuj_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","Olwʼehyo Musengwa Hatonda wuwo nʼahuŋanga ehiŋuumulo nʼoŋanguuye abalabe babo bosibosi mu hyalo ehi ali huhuŋa hibe omuŋuluko gugwo, oli nʼohusihiirihisa erala Abameleki. Era siwebiriranga huhihola.” ");
INSERT INTO nuj_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","“Ni wolanga mu hyalo ehi Musengwa Hatonda wuwo ali huhuŋa, watandiha ohumenyamo, ");
INSERT INTO nuj_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","obugulanga hu hiisi hiha hyʼebibala ebidaayi ehi oba nʼohunguuye, waata mu hisero waŋira mu hifo ehi Musengwa Hatonda wuwo alitobola ohumujumirihisyangamo. ");
INSERT INTO nuj_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","Ni woola mu hifo ehyo, otiinanga eyiri omusengi aba nʼali hu lubu mu hiseera ehyo wamuloma oti, ‘Olwaleero luno nijire nʼehirabo hino ehiraga ti ndi mu hyalo ehi Musengwa Hatonda wuwo oyu ŋeeresa galayirira abasehulu beefe ati aja hutuŋa.’ ");
INSERT INTO nuj_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","Ngʼomusengi oyo anaaŋa ehisero ahita hu hituuti hya Musengwa Hatonda wuwo. ");
INSERT INTO nuj_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","“Ngʼaŋo mu moni ja Musengwa Hatonda wuwo oloma oti, ‘Sehulu yange Yakobbo gaali Mwalaamu asengujuha, gatiina gamenya e Misiri. Abaatu abomu mago gage baali batono aye ni bali e Misiri, basaala bafuuha egwanga ebbala era eryʼamaani. ");
INSERT INTO nuj_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","Abamisiri ni batubisya wubi era batubonyaabonya, batufuula beedu baawe. ");
INSERT INTO nuj_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","Ngʼaŋo huliririra Musengwa Hatonda wʼabasehulu beefe. Era gaŋulira ohulira hwefe, gabona enaku nʼohutubisya owubi ko nʼohunyigirisa ohu baali ni batunyigirisa. ");
INSERT INTO nuj_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","Olwʼehyo, Musengwa gatutusa ohuŋwa e Misiri nʼobuŋangi nʼamaani gage ko nʼobubonero oweŋunjisa nʼebyamaliholiho. ");
INSERT INTO nuj_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","Gatuleeta ŋano era gatuŋa ehyalo hino ehihuluhuta amabeere nʼomudugere! ");
INSERT INTO nuj_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","Era ŋahani Musengwa ndetiire amakungula agasooka ohuŋwa mu binalima.’ Nʼohena ohuloma otyo, oŋambanga ehisero wahita mu moni ja Musengwa Hatonda wuwo, ngʼohubba amafuha omujumirya. ");
INSERT INTO nuj_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","Ewe nʼabomu mago gago nʼAbaleevi nʼabalugendwa abamenyire ni nenywe, musaŋalyanga mwaliira ŋalala olwʼebiraŋi byosibyosi Musengwa Hatonda wuwo abaŋaaye. ");
INSERT INTO nuj_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","“Hiisi luvanyuma lwʼemyaha edatu, oŋambanga hirala ehyʼehumi wahiŋirira Abaleevi nʼabalugendwa nʼabafuubbi ko nʼabanamwandu mu bibuga bibyo, bahaba nʼebyohulya balye beegute. ");
INSERT INTO nuj_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","Ngʼaŋo oloma mu moni ja Musengwa Hatonda wuwo oti, ‘Pambire hu biwaapa mu mago gange nʼaleeta ohubiŋa Abaleevi nʼabalugendwa nʼabafuubbi nʼabanamwandu, ngʼolu wandagira ohuhola. Ŋaŋuma hiragiro ehimbwagire oba ehi nerabiiye. ");
INSERT INTO nuj_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","Era ŋaŋuma hirala ehyʼehumi ehi nalya ni naali hu magombe oba ni tali mulongoofu era ŋaŋuma ehi naŋongera abafu. Ngondeeye Musengwa Hatonda wange era kolire hiisi hiitu ehi wandagira. ");
INSERT INTO nuj_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","Kale heja ŋaasi hu hyalo, nʼoli mu hifo hihyo ehyawufu, oŋe abaatu babo Abayisirayiri ekabi, nʼeroba eri walayirira abasehulu beefe ohutuŋa, ehyalo ehihuluhuta amabeere nʼomudugere.’ ");
INSERT INTO nuj_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","“Olwaleero, Musengwa Hatonda wuwo alagira ohugondera amagambi nʼebiragiro bibye. Ofubanga ohubigondera nʼomwoyo gugwo gwosigwosi nʼobulamu wuwo wosiwosi. ");
INSERT INTO nuj_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","Olangiriiye olwa leero oti Musengwa nje Hatonda wuwo. Era musuubihiise ohugenderanga mu magira gage nʼohuhuumanga amagambi nʼebiragiro bibye era muuti munaholenga ebi abaloma. ");
INSERT INTO nuj_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","Era Musengwa alangiriiye olwa leero luno ati muja huba baatu babe abenjawulo ngʼolu gasuubisa era ati mugonderenga ebiragiro bibye. ");
INSERT INTO nuj_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","Era aja huhufuula mwegingihiriri hu mawanga gosigosi aga gatonda. Oja huba gwanga eryʼeŋono era erimanyiheene. Oja huba gwanga eryawufu eyiri Musengwa Hatonda wuwo ngʼolu gasuubisa.” ");
INSERT INTO nuj_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","Ngʼaŋo Musa nʼabatangirisi ba Yisirayiri baloma abaatu baati, “Muhuumenga ebiragiro bino byosibyosi ebi mbaŋa olwa leero. ");
INSERT INTO nuj_vpl VALUES ("DT27_2","006_27_2","DEU","27","2","2","Ni muliba ni muhenire ohwambuha olwabi Yoludaani, mwatiina mu hyalo ehi Musengwa Hatonda wuwo ali huhuŋa, oŋambanga amabaale amabba wagaŋahaho erangi ehosa. ");
INSERT INTO nuj_vpl VALUES ("DT27_3","006_27_3","DEU","27","3","3","Oŋandiihanga amagambi gano gosigosi hu mabaale ago nʼohenire ohwambuha olwabi ohutiina mu hyalo ehi Musengwa Hatonda wuwo ali huhuŋa, ehyalo ehihuluhuta amabeere nʼomudugere ngʼolu Musengwa Hatonda wʼabasehulu babo gabasuubisa. ");
INSERT INTO nuj_vpl VALUES ("DT27_4","006_27_4","DEU","27","4","4","Nʼolyambuha Yoludaani, oŋambanga amabaale ago wagaŋira hu lusozi Ebbali, wagaŋahaho erangi ngʼolu kulagira olwa leero. ");
INSERT INTO nuj_vpl VALUES ("DT27_5","006_27_5","DEU","27","5","5","Ngʼotongolera Musengwa Hatonda wuwo ehituuti ehyʼamabaale agatali mabaaje mu ngeri yosiyosi, ohuŋeeraho eŋongo. ");
INSERT INTO nuj_vpl VALUES ("DT27_6","006_27_6","DEU","27","6","6","Otongole ehituuti ehyʼamabaale agatali mabaaje era ohitambisenga ohuŋeeraho Musengwa Hatonda wuwo eŋongo eyi bohya ehwiye lyaguguliha. ");
INSERT INTO nuj_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","Era oŋonganga eŋongo eryʼohutabagana waliira mu moni ja Musengwa Hatonda wuwo nʼoli musangaafu. ");
INSERT INTO nuj_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","Era oŋandiihanga amagambi hu mabaale ago mu ngeri esomeha bulaŋi.” ");
INSERT INTO nuj_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","Ngʼaŋo Musa nʼabasengi ohuŋwa mu hiha hyʼAbaleevi baloma Yisirayiri baati, “Ŋoleera, tega ohutwi Yisirayiri, oŋulire bino! Olwaleero ofuuhire muutu wa Musengwa Hatonda wuwo. ");
INSERT INTO nuj_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","Olwʼehyo, oli nʼohugonderenga Musengwa Hatonda wuwo era oŋambe amagambi nʼebiragiro bibye byosibyosi ebi kuŋa olwa leero.” ");
INSERT INTO nuj_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","Hu ludaalo olwene olwo, Musa galagira abaatu ati, ");
INSERT INTO nuj_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","“Ni mwambuhanga olwabi Yoludaani, abʼehiha ehya Simyoni nʼehya Leevi nʼehya Yuda nʼehya Yisikaali nʼehya Yosefu ko nʼehya Bbenjamini, bemeereranga hu lusozi Gerizimu ohusabira abaatu ekabi. ");
INSERT INTO nuj_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","Ne abʼehiha ehya Lubbeeni nʼehya Gaadi nʼehya Aseri nʼehya Zebbulooni nʼehya Daani ko nʼehya Nafutaali, balyemeerera hu lusozi Ebbali ohulangirira ngʼolu Musengwa aligudya abaatu. ");
INSERT INTO nuj_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","“Abaleevi baja hulangirira nʼejanjaasi eryaŋamugulu eyiri Abayisirayiri baati, ");
INSERT INTO nuj_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","“Ehiŋwabo hibe hu muutu abbota ehifaananyi mwibaale, oba mu lubaawo oba mu hyoma gahijumirya mu kweho. Ebibbote ebyo era ebi babboti babbota, byambiho eyiri Musengwa.” Abaatu bosibosi baja hugobolamo baati, “Amiina.” ");
INSERT INTO nuj_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","“Ehiŋwabo hibe hu muutu ataŋa semwana ni nyina eŋono.” Abaatu bosibosi baja hugobolamo baati, “Amiina.” ");
INSERT INTO nuj_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","“Ehiŋwabo hibe hu muutu acuusa esalo jʼehibanja hya muliranwawe.” Abaatu bosibosi baja hugobolamo baati, “Amiina.” ");
INSERT INTO nuj_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","“Ehiŋwabo hibe hu muutu agosya omuŋofu galeha engira etuufu.” Abaatu bosibosi baja hugobolamo baati, “Amiina.” ");
INSERT INTO nuj_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","“Ehiŋwabo hibe hu muutu abisya bubi omulugendwa oba omufuubbi oba namwandu.” Abaatu bosibosi baja hugobolamo baati, “Amiina.” ");
INSERT INTO nuj_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","“Ehiŋwabo hibe hu muutu aŋenyuha ni muha semwana olwohuba aba aswahiise semwana.” Abaatu bosibosi baja hugobolamo baati, “Amiina.” ");
INSERT INTO nuj_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","“Ehiŋwabo hibe hu muutu aŋenyuha nʼesolo.” Abaatu bosibosi baja hugobolamo baati, “Amiina.” ");
INSERT INTO nuj_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","“Ehiŋwabo hibe hu muutu aŋenyuha ni mboojo, owa semwana oba owa nyina.” Abaatu bosibosi baja hugobolamo baati, “Amiina.” ");
INSERT INTO nuj_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","“Ehiŋwabo hibe hu muutu aŋenyuha ni masaalawe.” Abaatu bosibosi baja hugobolamo baati, “Amiina.” ");
INSERT INTO nuj_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","“Ehiŋwabo hibe hu muutu alumba muliranwawe mu ngiso ngʼamwita.” Abaatu bosibosi baja hugobolamo baati, “Amiina.” ");
INSERT INTO nuj_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","“Ehiŋwabo hibe hu muutu oyu bagula ohwita owahye aŋumaho musango.” Abaatu bosibosi baja hugobolamo baati, “Amiina.” ");
INSERT INTO nuj_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","“Ehiŋwabo hibe hu muutu atahuuma era atoheresa magambi gano.” Abaatu bosibosi baja hugobolamo baati, “Amiina.” ");
INSERT INTO nuj_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","Nga Musa geyongera aloma ati, “Singa ogonderenga Musengwa Hatonda wuwo nʼomwoyo mulala era wafuba ohuŋamba ebiragiro bibye byosibyosi ebi kuŋa olwa leero, Musengwa Hatonda wuwo aja huhufuula egwanga eryegingihiriri ohuhira amawanga gosigosi hu hyalo. ");
INSERT INTO nuj_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","Nʼoja hugonderanga Musengwa Hatonda wuwo, onasunenga ekabi jije josijosi: ");
INSERT INTO nuj_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","“Onaabenga nʼekabi mu bibuga bibyo nomu ndimiro jijo. ");
INSERT INTO nuj_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","Oja huba nʼekabi wasaala abaana bangi era waasa ebirime nʼebidooli byʼeŋombe nʼebyetaama ko nʼembusi. ");
INSERT INTO nuj_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","Ehiŋonolero hihyo nʼehibange hihyo binaabenga nʼekabi ejʼehyaasa. ");
INSERT INTO nuj_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","Oja hubanga nʼekabi hiisi aŋa onatiinenga era nomu hiisi ehi onaholenga. ");
INSERT INTO nuj_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","“Musengwa aja huŋangula abalabe babo ni bahulumba. Baja huhulumbiranga mu ngira ndala ne baja hufulumuhiranga mu ngira musanvu. ");
INSERT INTO nuj_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","Musengwa aja huhuŋa ekabi mu byosibyosi ebi ohola era aja hwejusa ebyagi bibyo nʼemere. Musengwa Hatonda wuwo aja huhuŋa ekabi mu hyalo ehi ali huhuŋa. ");
INSERT INTO nuj_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","“Singa ogonderanga ebiragiro bya Musengwa Hatonda wuwo era wagenderanga mu magira gage, Musengwa aja huhufuula wenjabulo ngʼolu galayira ohuhihola. ");
INSERT INTO nuj_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","Amawanga gosigosi hu hyalo ganabatyenga, olwohuba muli baatu ba Musengwa. ");
INSERT INTO nuj_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","Era Musengwa aja hubahulahulania mu hyalo ehi galayirira ohuŋa abasehulu benywe. Aja hubaŋa ekabi musaale abaana bangi era mwaba nʼebiraalo byʼebyayo bingi ko nʼemere mbitiirifu. ");
INSERT INTO nuj_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","Era Musengwa aja hutonyesa efula ohuŋwa mwigulu. Era alihuŋa ekabi mu byosibyosi ebi ohola. Oja huŋola amawanga mangi aye ewe sooja hweŋola. ");
INSERT INTO nuj_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","13","Nʼoja hugonderanga ebiragiro bya Hatonda ebi ndi huhuŋa olwa leero era wafubangaho ohubyoheresa, Musengwa Hatonda wuwo aja huhutangirisa sosi ohuba sembo. Era oja hubanga ŋamugulu waawe sosi ŋaasi waawe. ");
INSERT INTO nuj_vpl VALUES ("DT28_14","006_28_14","DEU","28","14","14","Sogesyangaho huŋaba waŋwa hu magambi aga ndi huhuŋa olwa leero, oba wajumirya abahatonda abandi. ");
INSERT INTO nuj_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","“Ne singa ogaana ohugonderanga Musengwa Hatonda wuwo, wagaana ohuŋamba amagambi nʼebiragiro ebi kuŋa olwa leero, ebiŋwabo bino byosibyosi bija huhubaaho: ");
INSERT INTO nuj_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","“Onaabengaho ehiŋwabo mu hibuga nomu ndimiro jijo. ");
INSERT INTO nuj_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","Ehiŋonolero hihyo nʼehibange hihyo binaabengaho ehiŋwabo ehyʼohutabamo hyaasa. ");
INSERT INTO nuj_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","Abaana babo nʼebirime nʼeŋombe nʼetaama ko nʼembusi jijo jija hubaaho ehiŋwabo. ");
INSERT INTO nuj_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","Oja hubaaho ehiŋwabo mu hiisi ehi ohola. ");
INSERT INTO nuj_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","“Musengwa aja hubaŋindihira endibo nʼebiitu ebitiisa mu hiisi ehi muhola, ohwola olu mulisihiirira mwaŋwaŋo olwʼohumuhubba omugongo. ");
INSERT INTO nuj_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","Musengwa aja huhuŋindihira haŋupuli ohwola olu ŋataja husigalaŋo muutu yesiyesi mu hyalo ehi oli huupi huŋira hibe omuŋuluko gugwo. ");
INSERT INTO nuj_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","Musengwa aja hubaŋindihira obulwaye, nʼomusuuja nʼohusimbuluha nʼohubabuuhirira. Era aja hubaŋindihira omumwi gwohye ebirime byenywe. Ebyo byosibyosi bija huboolaho ohwola olu muja husihiiriha. ");
INSERT INTO nuj_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","Egulu lija hutangaala, ehyaalo hyome ti bbwe hyʼebaale. ");
INSERT INTO nuj_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","Musengwa aja hubadumuhisa efuuhe mu hifo hyʼohubatonyehesa efula ohwola olu mulisihiiriha. ");
INSERT INTO nuj_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","“Musengwa aja huleetera abalabe babo ohubaŋangula. Oja hulumba abalabe babo mu ngira ndala aye oja hufulumuhira mu magira mangi. Era ebija huhwolaho bija hutiisa amawanga gosigosi hu hyalo. ");
INSERT INTO nuj_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","Era esega nʼesolo jiryetebeya hu mulambo gugwo ni ŋaŋuma ajiŋema. ");
INSERT INTO nuj_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","Musengwa ali badanyaho amabbwa nʼebizimba nʼamabute nʼohusiiŋa ohutalehera, obulwaye obutaŋona ngʼolu gaahola Abamisiri. ");
INSERT INTO nuj_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","Era Musengwa aja hubaŋofuŋasa nʼohubalalusa emitwe ni mutategeera nʼebi muhola. ");
INSERT INTO nuj_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","Oja humamaatanga mu muusi tangalwe hyʼomuŋofu amamaata mu hiirema aye sooja hubona ngira. Mu hiisi ehi ohola, sooja hubitamo. Baja huhunyigirisa era hiisi hiseera baja huhukondolanga ni ŋaŋuma ahuyeeda. ");
INSERT INTO nuj_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","“Oja husunanga omuhasi owohuhwa aye ngʼabandi bamuhuŋiraho. Era oja hutongolanga enyumba aye soliŋenyuhamo. Olihoma emizabbibbu mu endimiro aye sooja huhungulanga. ");
INSERT INTO nuj_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","Baja husala eŋombe jijo nʼobona aye sooja huhomba hu nyama. Era baja hunyaga nasugirya jijo aye eriŋuma alijihugobohesa. Abalabe babo baja huŋira etaama nʼembusi jijo, ne eriŋuma alihuyeeda. ");
INSERT INTO nuj_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","Baliŋira abasaani babo nʼabahaana babo ohuhola owiidu aye nʼolengereeye hulengerera. Era omwoyo gulihuluma aye oliŋuma amaani ohubanunula. ");
INSERT INTO nuj_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","Abaatu abʼotaŋulirangaho, balirya ebirime ebi watuyanira ohulima. Oja hubonaabona ni bahutulugunya era balihubisya wubi. ");
INSERT INTO nuj_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","Oligwa eralu olwʼembeera embi eyi oliba nobitamo. ");
INSERT INTO nuj_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","Musengwa aja huhudanyaho amabbwa agʼehimaama. Mu butuufu gali hwana omubiri gugwo gwosigwosi. ");
INSERT INTO nuj_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","“Musengwa aja hubaŋamba, ewe ni habaha wuwo abaŋire mu buŋaŋanguse mu hyalo ehi ewe nʼabasehulu babo mutamanyire. Era eyo mu buŋaŋanguse, mulijumirya abahatonda aba babbota mu misaala nomu mabaale. ");
INSERT INTO nuj_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","Olifuuha njeho jababita, balihunyooma era olifuuha eduho mu mawanga gosigosi eyi Musengwa alihuŋira. ");
INSERT INTO nuj_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","“Olihomanga bingi aye wahungula bidiidiri olwohuba esige jirirya ebirime bibyo. ");
INSERT INTO nuj_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","Oja huhoma endimiro ejʼemizabbibbu era wajirabirira bulaŋi aye soolinywa hu mwenge oba ohulyaho emizabbibbu, olwohuba ebisiisa birijirya. ");
INSERT INTO nuj_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","Oja huba nʼemisaala emizayiti hiisi ŋaatu aye oliŋuma amafuta agʼohutambisa olwohuba jirikukumusa ebibala byajo. ");
INSERT INTO nuj_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","Olisaala abaana abaseere nʼabahaana aye solimenya ni nabo, olwohuba balibaŋira mu buŋaŋanguse. ");
INSERT INTO nuj_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","Esige jija husihiirisa emisaala nʼebirime bibyo byosibyosi. ");
INSERT INTO nuj_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","“Abalugendwa abaliba ni bamenyire ni neewe balyeyongera ohuba nʼamaani aye ewe oli henderanga huhendera amaani. ");
INSERT INTO nuj_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","Era abalugendwa abo balihuŋolanga aye ewe oliŋuma hiitu ehyʼohubaŋola. Era baja huba mitwe jijo aye ewe oja huba muhira. ");
INSERT INTO nuj_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","“Singa ogaana ohuŋuliirisa Musengwa Hatonda wuwo, ohugondera amagambi nʼebiragiro bibye ebi ahuŋaaye, ebiŋwabo bino byosibyosi bija huhubaaho era bihusihiirise. ");
INSERT INTO nuj_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","Ebiguudyo bino bija huba habonero ahʼohulabula eyiri ewe nʼabaana babo emirembe nʼemirembe. ");
INSERT INTO nuj_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","Singa soŋeeresanga Musengwa Hatonda wuwo nʼohweyaasa nʼesangaalo olwʼebiraŋi ebi ahuŋa. ");
INSERT INTO nuj_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","Oja husigala nʼoli muyala, nʼolumwa enduŋo nʼoŋuma hyohwambala era ni weyagira lujo, oja huhola owiidu ewa balabe babo aba Musengwa aja huhuŋindihira. Aja huhutaaho ehijoogi ehyʼehyoma mu gosi ohwola olu olisihiiriha. ");
INSERT INTO nuj_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","Musengwa aja huleeta egwanga eryaŋaleeŋi era eryʼolulimi olu otategeera, bahugwaho hya haŋungu. ");
INSERT INTO nuj_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","Abaatu abo baliŋuma hisa era ba myoyo mibi, sibasasira basahulu nʼowaana obuŋere. ");
INSERT INTO nuj_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","Abasirikale baawe baja hulya ebyayo ko nʼebirime bibyo era oja husihiiriha. Sibaja huhuleehera ngaano nʼomwenge epiiraŋo ohuŋwa mu mizabbibbu, nʼamafuta gomu mizayiti, nʼeŋombe nʼetaama nʼembusi ohwola olu olisihiiriha. ");
INSERT INTO nuj_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","Abalabe babo balyeswanigirisa ebibuga bibyo ohwola olu balihubbiraŋo olukomera olu wesiga ohuhugagirira. Baja hweswanigirisa ebibuga byosibyosi mu hyalo ehi Musengwa Hatonda wuwo ahuŋa. ");
INSERT INTO nuj_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","“Ohuhweswanigirisa ohu balabe babo bali hweswanigirisamo huli huleetera ohubonaabona woola nʼohudamba ehyohulya hyahuŋweremo nʼohulya abaana babo aba Musengwa Hatonda wuwo gaahuŋa. ");
INSERT INTO nuj_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","54","Omusinde asinga ohuba owʼehisa mu nywe alirya emere, nʼomuhasi wuwe oyu genda oti hi, nʼabaana babe abaliba ni bahiiriŋo balamu ko ni mugandaawe, ni balengereeye. ");
INSERT INTO nuj_vpl VALUES ("DT28_55","006_28_55","DEU","28","55","55","Aligaana ohubaŋaaho enyama yʼomulala hu baana babe. Ehyo alihihola nʼamanyire ati ŋaŋuma ŋandi aŋa aja hutusa ehyohulya olwohuba aŋuma ehyohulya ehindi mu hiseera ehyo ehi balabe balireeta hu bibuga bibyo. ");
INSERT INTO nuj_vpl VALUES ("DT28_56","006_28_56","DEU","28","56","56","Era nʼomuhasi asingayo ohuba obulaŋi era omuŋoono atasobola hugeesya amagulu amereere, aja hwima ni wamwe omuhoda era alirya abaana babe boosi ni balengereeye. ");
INSERT INTO nuj_vpl VALUES ("DT28_57","006_28_57","DEU","28","57","57","Aja husaala ngʼahweha ehitani nʼomwana wuwe omwiwo olwʼohwenda ohubirya mu ngiso, geeme ni wamwe oyu genda oti hi era geema nʼabaana babe. Ehyo alihihola olwʼabalabe abaliba ni beswanigirihiise ebibuga. ");
INSERT INTO nuj_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","58","“Singa ogaana ohuŋamba amagambi gano gosigosi agali mu hitabo hino era wagaana ohutya Musengwa Hatonda wuwo owʼeŋono era atiisa, ");
INSERT INTO nuj_vpl VALUES ("DT28_59","006_28_59","DEU","28","59","59","Musengwa alihuleetera ewe nʼabaana babo endwaye embi ejitaŋona. Era obulwaye owo, bulibaleetera ohugada. ");
INSERT INTO nuj_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","Era aja huhuleetera ohulwala obulwaye wosiwosi owʼe Misiri obu watyanga era oliŋuma buŋonere. ");
INSERT INTO nuj_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","Musengwa alihuleetera hiisi bulwaye nʼohubonaabona ohwʼamaani ebi bataŋandiiha mu hitabo ehyʼamagambi hino ohwola olu oja husihiiriha. ");
INSERT INTO nuj_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","Era wayire muliba bangi hyʼemunyeenye, mulisigalaŋo batotono olwohuba simwagondera Musengwa Hatonda wuwo. ");
INSERT INTO nuj_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","Ngʼolu hyasangaasa Musengwa Hatonda wenywe ohubaŋa ekabi gabaasa mweyongera obungi, atyo pwaliba musangaafu nʼabasihiirisa. Era alibadyedyesa gabatusa mu hyalo ehi muli hwingiramo ohuŋira. ");
INSERT INTO nuj_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","“Musengwa alihusalanihisya mu mawanga gosigosi ohuŋwa aŋa ehyalo hitandihira ohwola aŋa hihoma. Ni muliba eyo, muja hujumirya abahatonda aba babaaja mu bisaala nʼabomu mabaale, aba enywe nʼabasehulu benywe mutamanyire. ");
INSERT INTO nuj_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","Era mu mawanga ago, simuja husuna aŋa hwihala aŋatuufu naŋʼohuŋuumulira. Era Musengwa alibaleetera ohutya era muliŋuma suubi mu bulamu wenywe. ");
INSERT INTO nuj_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","Mu bulamu wuwo soliba nʼesuubi ohugobola mu mbeera endaŋi. Era oja hubanga mu hutya omuusi nʼowiire. ");
INSERT INTO nuj_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","Mu mugamba oja hulomanga oti, ‘Singa hyʼegulo!’ Ngʼehyegulo olome oti, ‘Singa mu mugamba!’ Ebyo ebi oliba nʼobona, birihutiisanga. ");
INSERT INTO nuj_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","Musengwa ali hwagamya e Misiri mu maato, wayire galoma ati simugobolangayo. Ni munahoole eyo, mwabeene mulyeŋaayo eyiri abalabe benywe, babagule mube beedu baawe aye siŋanahabeeŋo ababagula.” ");
INSERT INTO nuj_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","Bino njʼebi Abayisirayiri baali nʼohuhola ohuhuuma endagaano eyi Musengwa galagira Musa ni baali e Mowaabbu, ohwongera hu ndagaano eyi gaahola ni nabo hu lusozi Horebbu. ");
INSERT INTO nuj_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","Musa galanga Abayisirayiri bosibosi gabaloma ati, “Mwabona byosibyosi ebi Musengwa gaahola mu hyalo hyʼe Misiri hu Falaawo nʼabahungu babe ko nʼabaatu babe bosibosi. ");
INSERT INTO nuj_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","Mweboneraho nʼemoni jenywe enyene Musengwa nʼahola obubonero oweŋunjisa ko nʼebyamaliholiho. ");
INSERT INTO nuj_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","Aye nʼohwola olwa leero luno, Musengwa ahiiri hwigula emoni jenywe ohubona oba amatwi ohuŋulira, wayire ohutegeera hwenywe ko mwahamanya amahulu gʼebiitu ebyo. ");
INSERT INTO nuj_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","Era Musengwa aloma ati, ‘Emyaha amahumi ane, nabatangiirira mu lulafu aye ebyambalo byenywe sibyanabuha wayire ebirayito ohuhapuha. ");
INSERT INTO nuj_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","Simwalya mere oba ohunywa omwenge ogwʼemizabbibbu omuli ehimeesa hyosihyosi aye nabalabirira mwahamanya muuti ndiise Musengwa Hatonda wenywe.’ ” ");
INSERT INTO nuj_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","Nga Musa aloma ati, “Ni hwola mu hifo hino, Sihoni habaha wʼe Hesibboni ni Ogi habaha wʼe Bbasani, batulumba ohutusoosa aye hwabaŋangula. ");
INSERT INTO nuj_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","Hwaŋamba ehyalo hyawe, hwahiŋa ehiha hya Lubbeeni nʼehya Gaadi nʼehitundu hyʼehiha hya Manase. ");
INSERT INTO nuj_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","“Olwʼehyo, mufubengaho ohuhuuma endagaano yino, ko mube nʼekabi mu byosibyosi ebi muhola. ");
INSERT INTO nuj_vpl VALUES ("DT29_10","006_29_10","DEU","29","10","10","Olwaleero mwemire mu moni ja Musengwa Hatonda wenywe, mwesimwesi abahulu bʼebiha byenywe, abatangirisi benywe, abaŋugi benywe nʼabasinde mu Yisirayiri, ");
INSERT INTO nuj_vpl VALUES ("DT29_11","006_29_11","DEU","29","11","11","nʼabahasi, abaana abaŋere, nʼabalugendwa ababa mu enywe ababaŋulira ekwi era ababasombera amaaji. ");
INSERT INTO nuj_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","Olwaleero muli ŋano ohuhola endagaano ni Musengwa Hatonda wuwo ni weyama ohuyoheresanga era endagaano yino erimo nʼebiŋwabo ");
INSERT INTO nuj_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","nʼohubahahasa ti muli baatu babe, niye abe Hatonda wenywe ngʼolu galayirira Yibbulayimu ni Yisaka ni Yakobbo, abasehulu benywe. ");
INSERT INTO nuj_vpl VALUES ("DT29_14","006_29_14","DEU","29","14","14","Aye sindinywe mweŋene aba ndi huhola ni nabo endagaano yino erimo nʼebiŋwabo byawaho. ");
INSERT INTO nuj_vpl VALUES ("DT29_15","006_29_15","DEU","29","15","15","Ndi huhola endagaano yino ni nenywe abali ŋano mu moni ja Musengwa Hatonda weefe olwa leero luno era ko nʼabejuhulu benywe ababanahasaale mu moni eyo. ");
INSERT INTO nuj_vpl VALUES ("DT29_16","006_29_16","DEU","29","16","16","“Muhebulira obulamu obu hwalimo mu hyalo hyʼe Misiri era ngʼolu hwabita mu mawanga agandi ohwola ŋano. ");
INSERT INTO nuj_vpl VALUES ("DT29_17","006_29_17","DEU","29","17","17","Mwabona ebyʼembiho ebibbote ohuŋwa mu mbaawo nomu mabaale nomu feeza ko nomu zaabbu ebi bajumirya. ");
INSERT INTO nuj_vpl VALUES ("DT29_18","006_29_18","DEU","29","18","18","Kola endagaano yino ni nenywe ko ŋaŋumeŋo musinde oba omuhasi oba amago oba hiha oba gwanga, erinahabbaame ohuŋwa hu Musengwa Hatonda weefe, bajumirya abahatonda bʼamawanga agandi. Era singa omuutu yesiyesi ahola atyo, aja huba hyʼomulandira omululu era ogwita. ");
INSERT INTO nuj_vpl VALUES ("DT29_19","006_29_19","DEU","29","19","19","“Ŋatabaŋo aŋulira ebibono byʼendagaano yino gedulinga mu mwoyo gugwe ati, ‘Ndi bulaŋi nja hweholera ebyange ni ŋaŋuma amanyire.’ Ehyo hija hubaleetera ohusihiiriha mwesimwesi, abalaŋi nʼababi. ");
INSERT INTO nuj_vpl VALUES ("DT29_20","006_29_20","DEU","29","20","20","Musengwa saaja husoniŋa muutu hyʼoyo. Aye Musengwa aja humuhangavula nʼehiruŋi. Ebiŋwabo ebiri mu hitabo hino byosibyosi bija huba hu baatu abo era Musengwa aja husangula amasiina gaawe ŋaasi wʼegulu. ");
INSERT INTO nuj_vpl VALUES ("DT29_21","006_29_21","DEU","29","21","21","Era Musengwa aja humusolohesaho ebiŋwabo byosibyosi ebiri mu ndagaano yino ebi baŋandiiha mu hitabo hino ehyʼAmagambi. ");
INSERT INTO nuj_vpl VALUES ("DT29_22","006_29_22","DEU","29","22","22","“Mu mirembe ejomu moni, abejuhulu benywe nʼabagwira ohuŋwa mu byalo ebyaŋaleeŋi, baja hubona ebibonyoobonyo nʼobulwaye obu Musengwa alireeta hu hyalo. ");
INSERT INTO nuj_vpl VALUES ("DT29_23","006_29_23","DEU","29","23","23","Ehyalo hyosihyosi hiriba oti bahyohyire era ni hiri gohe ni cumbi. Sibaja huhomangamo haatu hosihosi haahula era muja huŋumamo nʼenyaasi. Hija huba oti Sodoma ni Gomora, Aduma ni Zebboyiimu, ebi Musengwa gasihiirisa nʼehiruŋi. ");
INSERT INTO nuj_vpl VALUES ("DT29_24","006_29_24","DEU","29","24","24","Amawanga gosigosi agabeswanigirihiise galyebuusa gaati, ‘Lwahiina Musengwa aholire abaatu abo atyo? Hiina ehyamusunguŋasa ohwola aŋo?’ ");
INSERT INTO nuj_vpl VALUES ("DT29_25","006_29_25","DEU","29","25","25","“Abaatu banahabagobolemo baati, ‘Ehyo hiriŋo olwohuba babbwaga endagaano ya Musengwa Hatonda wʼabasehulu baawe, eyi gaahola ni nabo nabatusa mu hyalo hyʼe Misiri. ");
INSERT INTO nuj_vpl VALUES ("DT29_26","006_29_26","DEU","29","26","26","Nibo batandiiha huŋeeresa nʼohujumirya abahatonda aba baali ni batamanyire era aba Musengwa atabaloma hujumiryanga. ");
INSERT INTO nuj_vpl VALUES ("DT29_27","006_29_27","DEU","29","27","27","Cʼehyagira Musengwa galuŋira abaatu babe, gabaleetaho ebiŋwabo byosibyosi ebi baŋandiiha mu hitabo hino. ");
INSERT INTO nuj_vpl VALUES ("DT29_28","006_29_28","DEU","29","28","28","Mu busungu nʼehiruŋi, Musengwa gaatusa abaatu babe mu hyalo hyawe, ngʼabaholoŋa mu hyalo ehindi ngʼolu hiri hatyane.’ ");
INSERT INTO nuj_vpl VALUES ("DT29_29","006_29_29","DEU","29","29","29","“Musengwa Hatonda weefe ali nʼebyama aye ebyo ebi gahwehula byefe nʼabaana beefe emirembe nʼemirembe, ko husobole ohugonderanga ebyo byosibyosi ebiri mu ndagaano yino.” ");
INSERT INTO nuj_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","Ngʼaŋo Musa geyongera aloma ati, “Mu moni eyo, nʼobanga nʼekabi oba ebiŋwabo ebitaaye mu moni jijo, ebija hubaŋo, ne wabihebulira nʼoli eyo mu mawanga eyi Musengwa Hatonda wuwo aliba nʼahudanyire, ");
INSERT INTO nuj_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","ngʼogobola eyiri Musengwa Hatonda wuwo, ewe nʼabaana babo nʼomwoyo gugwo gwosigwosi nʼobulamu wuwo wosiwosi, wagondera ebiragiro bibye byosibyosi ebi kuŋa olwa leero, ");
INSERT INTO nuj_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","Musengwa Hatonda wuwo aja huhuŋambira ehisa gahuhumbaania nindi ohuŋwa mu mawanga gosigosi eyi aliba nʼahusalanihisiiye. ");
INSERT INTO nuj_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","Wayire aliba ahusalanihisiiye mu byalo ebyaŋaleeŋi eyo, Musengwa Hatonda wuwo alihuhumbaania gahugobosaŋo. ");
INSERT INTO nuj_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","Aja huhugobosaŋo mu hyalo ehi basehulu babo baalimo, weesi omenyemo. Era aja huhuŋa ekabi era ahwase ohuhira abasehulu babo. ");
INSERT INTO nuj_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","Musengwa Hatonda wuwo aja huhomola omwoyo gugwo nʼejabaana babo, ko wahamwenda nʼomwoyo gugwo gwosigwosi nʼobulamu wuwo wosiwosi, weyongere ohumenya mu hyalo ehyo. ");
INSERT INTO nuj_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","Era Musengwa Hatonda wuwo aja huta ebiŋwabo ebyo byosibyosi hu balabe babo. ");
INSERT INTO nuj_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","Nindi oligondera Musengwa era wahuuma ebiragiro bibye byosibyosi ebi kuŋa olwa leero. ");
INSERT INTO nuj_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","Musengwa Hatonda wuwo aja hubaŋa ekabi mu byosibyosi ebi muhola, wasaala abaana eduuli, nʼebyayo bibyo byeyongera ohwala era waasa nʼemere. Hirisangaasa Musengwa ohubaŋa ekabi ngʼolu hyamusangaasanga ohuŋa abasehulu babo. ");
INSERT INTO nuj_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","Singa ogonderanga Musengwa Hatonda wuwo era wahuuma ebiragiro nʼamagambi gage, aga baaŋandiiha mu hitabo ehyʼAmagambi era wagobola eyiri Musengwa Hatonda wuwo nʼomwoyo gugwo gwosigwosi nʼobulamu wuwo wosiwosi, aja huhuŋa ekabi. ");
INSERT INTO nuj_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","“Ehiragiro hino ehi kuŋa olwa leero sihigosi oba ti hiri ŋaleeŋi sosobola hwolayo. ");
INSERT INTO nuj_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","Sihiri mwigulu ko webuuse oti, ‘Njʼani anahatiine mwigulu agobole gandomere nahahigondera?’ ");
INSERT INTO nuj_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","Era sihiri yingereha wʼenyanja ko webuuse oti, ‘Njʼani aja hwambuha enyanja ahindetere sobole ohuhigondera?’ ");
INSERT INTO nuj_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","Aye ehibono ehyo hihuli ŋaapi, hihuli mu hanwa nomu mwoyo gugwo, kale higondere. ");
INSERT INTO nuj_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","“Olwaleero taaye mu moni jijo obulamu nʼekabi, ohufa nʼohusihiirira. ");
INSERT INTO nuj_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","Hiri hiityo olwohuba kulagira olwa leero ohwendanga Musengwa Hatonda wuwo, ohugenderanga mu magira gage nʼohuhuumanga amagambi nʼebiragiro bibye byosibyosi, ko Musengwa Hatonda wuwo ahuŋe ekabi waale mu hyalo ehi otiina ohuŋira ngʼomuŋuluko. ");
INSERT INTO nuj_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","“Aye omwoyo gugwo ni guja humuŋwaho, wamujeemera era singa otiina mu byʼohuhubba amafuha wajumirya abahatonda abandi, ");
INSERT INTO nuj_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","mu butuufu kulomera olwa leero luno ti oja husihiirira. Sooja humenya hiseera hireeŋi mu hyalo eyi oli hutiina ohwambuha olwabi Yoludaani ohusuna omuŋuluko. ");
INSERT INTO nuj_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","“Olwaleero luno, ndanga egulu nʼehyalo ohuba bajulizi ti taaye mu moni jijo obulamu nʼohufa, ekabi nʼebiŋwabo. Olwʼehyo, tobola obulamu, wahaba nʼekabi ko ewe nʼolulyo lulwo mube balamu. ");
INSERT INTO nuj_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","Yendanga Musengwa Hatonda wuwo, omuŋulirenga era omweŋe. Hiri hiityo olwohuba Musengwa njʼobulamu wuwo era aja huhuleetera ohuwangaala mu hyalo ehi galayira ohuŋa Yibbulayimu ni Yisaka ni Yakobbo, abasehulu babo.” ");
INSERT INTO nuj_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","Ngʼaŋo Musa geyongera aloma Abayisirayiri bosibosi ati, ");
INSERT INTO nuj_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","“Ese ŋaahani ndi nʼemyaha cikumi nabiri. Sikisobola huba mutangirisi wuwo, ne Musengwa gandoma ati, ‘Sooja hwambuha lwabi Yoludaani.’ ");
INSERT INTO nuj_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","Musengwa Hatonda wuwo omwene aja huhutangirira ohwambuha Yoludaani, aja husihiirisa amawanga ago era obaŋangule. Yoswa njaja huhutangirira ngʼolu Musengwa gaaloma. ");
INSERT INTO nuj_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","Era Musengwa alisihiirisa abaatu abo ngʼolu gasihiirisa Sihoni ni Ogi, abahabaha bʼAbamooli. ");
INSERT INTO nuj_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","Musengwa aliŋaayo abaatu abo mu mihono jenywe era obaholanga byosibyosi ngʼolu gahulagira. ");
INSERT INTO nuj_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","Guma omwoyo, otatya era otaŋwamo maani olwohuba Musengwa Hatonda wuwo ali ni neewe. Salihuleha era salihwabulira.” ");
INSERT INTO nuj_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","Ngʼaŋo Musa alanga Yoswa, amuloma mu moni jʼAbayisirayiri bosibosi ati, “Otatya, guma omwoyo, olwohuba oja hutangirira abaatu bano ohutiina mu hyalo ehi Musengwa galayira ohuŋa abasehulu benywe era ewe oja hubaŋambya emiŋuluko jaawe. ");
INSERT INTO nuj_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","Musengwa omwene aja huhutangirira era aja huba ni neewe. Saaja huhuleeha era salihwabulira. Otatya era otaŋwamo maani.” ");
INSERT INTO nuj_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","Nga Musa aŋandiiha amagambi ago, agaŋambya abasengi abasaani bʼAbaleevi nʼabatangirisi bosibosi aba Yisirayiri. Abaleevi abo njʼababbedanga esanduuku eyʼendagaano ya Musengwa. ");
INSERT INTO nuj_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","Ngʼaŋo Musa abalagira ati, “Hiisi myaha omusanvu olu jiŋwaho, ehiseera ehyʼohusoniŋa abaatu amabanja, hu Mbaga eyʼEbitiira, ");
INSERT INTO nuj_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","Abayisirayiri bosibosi olu banahumbaanenga ohujumirya Musengwa Hatonda wenywe, mu hifo ehi aliba nʼatobooye ohumujumirihisyangamo, muja husomanga Amagambi gano Abayisirayiri bosibosi ni baŋulira. ");
INSERT INTO nuj_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","Muhumbaanianga abaatu bosibosi: abasinde nʼabahasi nʼabaana abaŋere nʼabalugendwa ababa ni bamenya mu bibuga byenywe, baŋulire era beege ohutyanga Musengwa Hatonda wenywe, bafubengaho ohuŋamba amagambi gano gosigosi. ");
INSERT INTO nuj_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","Era muholanga muutyo ko abaana baawe abaliba ni bahiiri huŋulirangaho bahatyanga Musengwa Hatonda wenywe emirembe nʼemirembe mu hyalo ehi mutiina ohwambuha Yoludaani muŋire emiŋuluko.” ");
INSERT INTO nuj_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","Nga Musengwa aloma Musa ati, “Ŋaahani ehiseera hihyo ehyohufa, hyolire. Langa Yoswa, mutiine mu Weema eyʼOhwagananirangamo, mulaabbire.” Era nga Musa ni Yoswa batiina mu Weema eyʼOhwagananirangamo. ");
INSERT INTO nuj_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","Nga Musengwa gebonesa eyi bali nʼali mu hireri ehyali oti siiro. Era esiiro eyo, yemeerera ŋamugulu wʼolwigi lwʼeweema eyo. ");
INSERT INTO nuj_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","Nga Musengwa aloma Musa ati, “Oli huupi hufa olonde hu basehulu babo. Abaatu bano sibaliba besigwa eyi ndi era balibbwaga endagaano eyi nahola ni nabo. Baja hujumirya abahatonda abomu hyalo eyi batiina ohumenya. ");
INSERT INTO nuj_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","Ndibaluŋira mu hiseera ehyo. Nja hubaŋwaho kene mbehwehe, babasihiirise. Ohubonaabona nʼebigosi bingi biriboolaho. Hulwo balyebuusa baati, ‘Ebigosi bino sibitwolireho olwohuba Hatonda saali ŋalala ni neefe?’ ");
INSERT INTO nuj_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","Era nja hubehweha olwʼebibi byosibyosi ebi baliba ni baholire, olwohuba baliba bajumirya abahatonda abandi. ");
INSERT INTO nuj_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","“Kale muŋandiihe olwembo luno era olusomese Abayisirayiri, lube bujulizi ŋagati wange nʼAbayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","Hiri hiityo olwohuba ni ndibaŋira mu hyalo ehihuluhuta amabeere nʼomudugere, ehi nalayira ohuŋa abasehulu baawe, baba ti balya ni beguta era bali bulaŋi, baja hutandiha ohujumirya nʼohuŋeeresanga abahatonda abandi ni baanyooma era babbwaga endagaano yange ni nabo. ");
INSERT INTO nuj_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","Ehiseera ehyo, ohubonaabona nʼebigosi ni biri babitiiriraho obungi, olwembo olwo luja huba bujulizi, olwohuba nʼabejuhulu baawe baliba balumanyire. Hiri hiityo olwohuba manyire ehi baŋeega ohuhola ni kiiri nʼohubaŋira mu hyalo ehi nalayira ohubaŋa.” ");
INSERT INTO nuj_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","Olwʼehyo, Musa gaŋandiiha olwembo olwo hu ludaalo olwo, ngʼalusomesa Abayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","Nga Musengwa alaabbira Yoswa omusaani wa Nuuni ati, “Guma omwoyo era otaŋwamo maani, olwohuba oja huŋira Abayisirayiri mu hyalo ehi nalayira ohubaŋa. Ese samwene, nja huba ni neewe.” ");
INSERT INTO nuj_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","Musa ni gahena ohuŋandiiha amagambi ago mu hitabo, nahenire hiisi hiitu, ");
INSERT INTO nuj_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","ngʼalagira Abaleevi ababbedanga esanduuku eyʼendagaano ya Musengwa ati, ");
INSERT INTO nuj_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","“Muŋire ehitabo hino ehyʼamagambi, muhite hutulo wʼesanduuku eyʼendagaano ya Musengwa Hatonda wenywe, hibenga bujulizi ohubalumiirisa. ");
INSERT INTO nuj_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","Hiri hiityo olwohuba manyire ngʼolu muli bajeemu era bahahanyafu, mubaaye mujeemera Musengwa ni kiiri mulamu aye mulyosaŋe ni fuuye! ");
INSERT INTO nuj_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","Mundangire abahulu bʼebiha byenywe bosibosi nʼabatangirisi benywe, bahumbaane mbalomere ebibono bino, egulu nʼehyalo bibe bajulizi, ");
INSERT INTO nuj_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","olwohuba manyire ti oluvanyuma lwange ohufa, mulicuuha mwaŋwa hu ebi mbalagira ohuhola. Era eyi buuja mu moni eyo, ebigosi biribaajira olwʼohuhola ebitoola mu moni ja Musengwa, mwamuleetera ohubaluŋira.” ");
INSERT INTO nuj_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","Nga Musa agobolamo ebibono byʼolwembo olwo byosibyosi ohuŋwa aŋa lutandihira ohwola aŋa luhoma, Abayisirayiri bosibosi ni bategire amatwi. ");
INSERT INTO nuj_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","“Ewe egulu, tegere ohutwi ndome, era leha ehyalo hiŋulire ebindoma. ");
INSERT INTO nuj_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","Esomesa yange yitonye hyʼefula, ebi ndoma bigwe hyʼolume, hyʼefula eyigwa obulaŋi hu nyaasi egondi, eyi basasalya hu nyaasi eŋere. ");
INSERT INTO nuj_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","Nja hulangirira esiina lya Musengwa, mbutule ngʼolu Hatonda weefe ali wʼamaani. ");
INSERT INTO nuj_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","“Musengwa njʼolwanda, ebi ahola biŋumaaho hamogo, era nʼasala esonga sigehubbira. Hatonda mwesigwa era wʼamazima, ahola ebituufu era ebiruŋamu. ");
INSERT INTO nuj_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","Abaatu babe sibesigwa, era sibasaana nʼohuba baana babe. Aye bafuuhire badulingi, abaatu abʼomulembe omugodami. ");
INSERT INTO nuj_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","Musengwa mumusasula muutyo, enywe abaatu abasirusiru era abaŋuma magesi? Musengwa sinje senywe owabatonda? Sinje owabafuula egwanga? ");
INSERT INTO nuj_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","“Muhebulire ebiseera ebyahale, muŋeege hu mirembe ejahale. Mubuuse abasenywe babalomere, abasehulu benywe babalomere ebyaliŋo. ");
INSERT INTO nuj_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","Musengwa oyo Ali Ŋamugulu Obugali ni gaaŋa amawanga ebyʼobusika, olu gaawulamo abaatu, ngʼataŋo esalo jaawe ni geema hu bungi wʼabaana ba Yisirayiri. ");
INSERT INTO nuj_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","Ne Musengwa omwene, nje Hatonda wʼAbayisirayiri, abejuhulu ba Yakobbo. ");
INSERT INTO nuj_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","“Gabagaana mu lulafu eŋuma baatu, ni mugendaana mu mbeŋo, gabahumbaania ngʼabalabirira, hyʼomuutu alabirira emunge yʼemoni yiye. ");
INSERT INTO nuj_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","Hya haŋungu ngʼolu asomesa owaana waayo ohuguluha, gabuŋira mu bbanga, era gahena gataŋo amabaŋa ohubuŋonia ohugwa, ni Musengwa yeesi pwahola atyo ohuŋonia Abayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","Musengwa yeŋene njʼowabatangirira, era eŋuma hatonda obundi owabayeeda. ");
INSERT INTO nuj_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","“Gabaŋa ohuba abaŋugi mu hyalo ehyʼesozi, nga balya ebibala ebi balima mu ndimiro. Bagaana omudugere mu mabaale, era emizayiti jaawe jahula mu mabaale. ");
INSERT INTO nuj_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","Eŋombe nʼembusi jaawe jaŋwamo amabeere ameene amangi, jiŋwamo amabeere ameene amangi agʼeŋombe, nʼemiigu nʼembusi engeji, jʼembego endaŋi nʼengaano yoosi endaŋi ohuŋwa e Bbasani. Banywa omwenge ogwomu mizabbibbu omulando hyamafugi. ");
INSERT INTO nuj_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","“Aye Yesuramu mangu nyo bafunduŋala nga bafuuha bajeemu. Baalya emere beguta, nga baŋwa hu wabatonda, era banyooma Olwanda, Omunoŋosi waawe. ");
INSERT INTO nuj_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","Bamuleetera ewuba, olwʼohujumirya abahatonda abandi. Bamuleetera ehiruŋi olwʼohujumirya ebiitu ebibbote. ");
INSERT INTO nuj_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","Baŋongera emisambwa, ejitali Hatonda, abahatonda aba baali ni batamanyire, abahatonda aba baali ni bahamanyanga, aba basehulu baawe batajumiryanga. ");
INSERT INTO nuj_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","Sibahebulira oyo Olwanda owabatonda, beebirira Hatonda owabawumba. ");
INSERT INTO nuj_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","“Musengwa ni gahibona gabaluŋira. Abaana babe abahaana nʼabaseere bamusunguŋasa. ");
INSERT INTO nuj_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","Ngʼabaloma ati, ‘Nja hubehweha, ko mbone ngʼolu banahahenerese, abo abatali besigwa, abaatu bʼomulembe omugodami. ");
INSERT INTO nuj_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","Bapambisa ewuba ni beeŋa ebitali Hatonda. Basunguŋahise ni besiga ebiitu ebibbote. Keesi nja hubaŋambya ewuba, ni ndumirwa abaatu aba muŋeega muuti mbo baŋuma punga yiita hiswa. Nja hubaleetera ohuluŋa olwʼegwanga lyʼabo abaŋubeebe. ");
INSERT INTO nuj_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","Obusungu wange wohya hyʼomuliro ogwohya hiisi ehiri hu hyalo. Era gwohya ohwola emagombe ŋaasi eyo, gwohya emisingi jʼesozi. ");
INSERT INTO nuj_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","Ndi babungihaho ebigosi era nja hubaheneraho obusaale wange. ");
INSERT INTO nuj_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","Nja hubaŋindihira enjala nʼomusuuja, obulwaye owahabi buja hubahenaŋo. Nja huŋindiha esolo ekambwe jibalye, nʼemisota ejʼobusagwa jibabooje. ");
INSERT INTO nuj_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","Baja hufiira ebulafu mu nguudo nʼomugati mu nyumba obuti buja hubaŋamba, abaseere nʼabahaana, omuhayire owʼefi nʼomuŋere owooka, baja hufanga hufa. ");
INSERT INTO nuj_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","Hani nabaheneeyeŋo erala hu hyalo, ŋabuleŋo abahebulira. ");
INSERT INTO nuj_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","Aye sinendire abalabe baawe ohwepaaha mbo njʼababahenireŋo. Baja huloma baati, “Olwʼamaani geefe hubaŋanguuye, Musengwa sinje aholire ebyo.” ’ ” ");
INSERT INTO nuj_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","Nga Musa geyongera aloma ati, “Yisirayiri gwanga lyʼabaatu abaŋubeebe, baŋuma hutegeera. ");
INSERT INTO nuj_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","Singa balimo amagesi bahategeeye ehyo ehija huboolaho. ");
INSERT INTO nuj_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","Omulabe mulala abbinga atye Abayisirayiri olukumi, oba abalabe babiri bafulumusa omutwalo, ohutusaho oyo Olwanda nʼabaŋayeeyo, ohutusaho nga Musengwa abalehireeŋo? ");
INSERT INTO nuj_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","Abalabe beefe bamanyire baati abahatonda baawe sibamaani hyʼOlwanda lwefe. ");
INSERT INTO nuj_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","Abalabe beefe bali hyʼendimiro jʼemizabbibbu eji bahoma e Sodoma ni Gomora, emizabbibbu ejiri nʼobutwa nʼebibala byajo birulu. ");
INSERT INTO nuj_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","Omwenge gwajo guli hyʼobusagwa wʼemisota, wiita hyʼobusagwa wʼefulugundu. ");
INSERT INTO nuj_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","“Musengwa aloma ati, ‘Sindihubiiha ebiitu ebyo byosibyosi ni mbihweha mu sitoowa yange? ");
INSERT INTO nuj_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","Ohwegalula hwange, ndibesasula. Ebiseera bija hwola bagwe, oludaalo olwʼohubonaabona luboolireeho.’ ");
INSERT INTO nuj_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","“Musengwa aja hununula abaatu babe, era saaja hubasalira musango. Aja huŋambira abaŋeeresa babe ehisa, olu alibona ni baŋoyemo amaani, era ni ŋaŋumamo asigaaye, omusibe nʼowedembe. ");
INSERT INTO nuj_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","Musengwa alibabuusa ati, ‘Abahatonda benywe bali ŋe, abʼamaani aba mwesiganga? ");
INSERT INTO nuj_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","Abahatonda abalyanga amasavu gʼeŋongo lyenywe, era banywa omwenge ogwʼemizabbibbu ogu mwabaŋanga? Baaje babayeede, babahuume. ");
INSERT INTO nuj_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","Ese samwene ndiise era ŋaŋuma hatonda wundi. Ese ndiise owiita era ndiise agaba obulamu. Fumita era naŋonia ŋaŋuma asobola ohunyagulaho ehiba ni hiri mu buŋangi wange. ");
INSERT INTO nuj_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","Ngolola omuhono gwange ŋamugulu nalayira ti, “Ngʼolu ndi ndiise omwene bulamu emirembe nʼemirembe, ");
INSERT INTO nuj_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","nja huŋagala epiima yange emasamasa, mbone ti ŋabaaŋo ohutehubbira. Nja hwesasusa abalabe bange, nja huboneresa abatanyenda. ");
INSERT INTO nuj_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","Obusaale wange bulihwana amafugi, nʼepiima yange eja hunabulanabula emibiri. Nja huhenaŋo hiisi oyu pamba, era nja husalaho emitwe jʼabatangirisi baawe.” ’ ” ");
INSERT INTO nuj_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","Nga Musa geyongera aloma ati, “Enywe amawanga, musaŋalye olwʼesangaalo, musangaale nʼabaatu ba Musengwa, aja hwesasusa olwʼabaŋeeresa babe, aja hwegalula abalabe babe aja husoniŋa abaatu babe.” ");
INSERT INTO nuj_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","Nga Musa atiina ni Yoswa omusaani wa Nuuni agobolamo ebibono byʼolwembo, abaatu ni baŋulirisa. ");
INSERT INTO nuj_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","Era Musa ni gahena ohulomera Abayisirayiri ebibono ebyo byosibyosi, ");
INSERT INTO nuj_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","ngʼabaloma ati, “Muŋeegenga hu biitu byosibyosi ebi mbalagiiye olwa leero, mulagire nʼabaana benywe bafubengaho ohwoheresa byosibyosi ebiri mu magambi ago. ");
INSERT INTO nuj_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","Esomesa yino sibibono ebinambulamo, olwohuba ebiitu bino bibaleetera obulamu. Mubigondere ko muwangaale mu hyalo ehi muja hwambuha olwabi Yoludaani ohuŋira.” ");
INSERT INTO nuj_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","Nga hu ludaalo olwene olwo Musengwa aloma Musa ati, ");
INSERT INTO nuj_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","“Tiina hu sozi ejʼe Abbariimu, hu lusozi Nebbo mu hyalo hyʼe Mowaabbu, ohuupi nʼehibuga Yeriko, olengere ehyalo hyʼe Kanani, ehyalo ehi ndi huŋa Abayisirayiri ohuba obusika waawe. ");
INSERT INTO nuj_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","Hu lusozi olwo, oja hufiira eyo otiine wegaate hu basehulu babo, ngʼolu mugandawo Alooni gafiira hu Lusozi Hoori, ngʼatiina hu basehulu babe. ");
INSERT INTO nuj_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","Hiri hiityo olwohuba enywe mwembi simwali besigwa eyi ndi mu moni jʼAbayisirayiri ni mwali hu maaji gʼe Meribba Kadesi, mu lulafu lwʼe Ziini, simwatamo ŋono. ");
INSERT INTO nuj_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","Olwʼehyo, oja hulengera ehyalo ehi ndi huŋa Abayisirayiri aye sooja hu hyolamo.” ");
INSERT INTO nuj_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","Musa, omuutu wa Hatonda nʼahiiri hufa, gasabira Abayisirayiri ekabi ati, ");
INSERT INTO nuj_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","“Musengwa gaŋwa hu lusozi Sinaayi, geeha ohutuyeeda era gaŋwayo hyʼesaawa gaaduha ohuŋwa e Seyiri, era gaaduha ohuŋwa hu lusozi Parani. Ekumi nʼekumi jʼabamalayika babe baali ni naye, nʼomuliro ogwaduha ni gumuli mu mehiriro. ");
INSERT INTO nuj_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","Mu butuufu Musengwa genda abaatu babe abawufu. Era ahuuma ababe. Olwʼehyo humuhubbira amafuha era hugondera ebiragiro bibye. ");
INSERT INTO nuj_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","Hugondera amagambi aga Musa gatuŋa, amagambi ago hiitu hyʼomuŋendo bugali eri egwanga lya Yakobbo. ");
INSERT INTO nuj_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","Musengwa gafuuha habaha wa Yesuramu, olu biha nʼabatangirisi Bayisirayiri bahumbaana.” ");
INSERT INTO nuj_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","Musa gaaloma hu hiha hya Lubbeeni ati, “Leha abaatu ba Lubbeeni batafa wayire baatu batono.” ");
INSERT INTO nuj_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","Hu hiha hya Yuda galoma ati, “Musengwa ŋulira ohulira hwa Yuda. Bagobose ŋalala nʼebiha ebindi. Basoolere, O Musengwa, era obaŋonie abalabe baawe.” ");
INSERT INTO nuj_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","Hu hiha hya Baleevi galoma ati, “Musengwa, hwehula ohwenda huhwo nʼobitira mu Wurimu ni Samimu. Nʼobita mu baŋeeresa babo Abaleevi abesigwa, wabagesesya e Maasa. Era wabategeera oti batuufu eyo hu maaji gʼe Meribba. ");
INSERT INTO nuj_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","Abaleevi balaga baati ewe ohira abasaaye baawe, nʼabaganda baawe era nʼabaana baawe. Baaŋulira ebiragiro bibyo, bahuuma endagaano yiyo. ");
INSERT INTO nuj_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","Baja husomesa Yakobbo ohugondera ebiragiro, Yisirayiri ohuŋamba amagambi gago. Adunyisa obubbaani hu hituuti hihyo. ");
INSERT INTO nuj_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","O Musengwa yeeda ehiha hyawe ohuba nʼamaani, Era ebi bahola bihusangaase. Tetenula abalabe baawe, abo ababacaawa batagobolamo hwinyoha nindi.” ");
INSERT INTO nuj_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","Hu hiha hya Bbenjamini gaaloma ati, “Hino njʼehiha ehi Musengwa genda era ahuuma. Abagadirira hiisi haseera era anaabenga mu bo.” ");
INSERT INTO nuj_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","Hu hiha hya Yosefu gaaloma ati, “Musengwa aŋe ehyalo hyawe efula, ahiŋe amaaji agaŋwa mwiroba. ");
INSERT INTO nuj_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","Ehyalo hyawe hibeemo ebibala ebi mumwi guleetera ohulaba, era libemo ebiraŋi ebya hiisi makungula. ");
INSERT INTO nuj_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","Leha engingi jaawe ekalekale muŋwemo ebiraŋi. ");
INSERT INTO nuj_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","Ehyalo hyawe hiijule ebiraŋi byereere ebi bulaŋi wa Musengwa buŋa ekabi, oyo owalomera mu hadeŋo ahaaduha omuliro. Ekabi jino jibe hu Yosefu, olwohuba gaali mutangirisi mu baganda babe. ");
INSERT INTO nuj_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","Yosefu ali nʼamaani hya gʼebunwa yʼeŋombe, ali nʼameega hyʼagembogo. Ameega gago, njʼemitwalo jʼAbamanase, njʼemitwalo nʼemitwalo jʼAbefulayimu. Agagunyisa amawanga, era agasindigirisa eyo eyi hyalo hihoma.” ");
INSERT INTO nuj_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","Hu biha bya Zebbulooni ni Yisikaali gaaloma ati, “Leha Zebbulooni abe wʼekabi mu byamaguzi gage hu nyanja, era leha obuŋinda wa Yisikaali weyongere engo. ");
INSERT INTO nuj_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","Baliranga abamawanga agandi ohutiina hu lusozi lwawe, era baŋayo eŋongo etuufu. Basuna ebyʼobuŋinda waawe mu nyanja, nomu mujehe hwigobo.” ");
INSERT INTO nuj_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","Hu hiha hya Gaadi gaaloma ati, “Aŋeewe eŋono Hatonda oyo owagalamya ehyalo hya Gaadi. Gaadi awundala hyʼepologoma, ohunawulanawula omuhono oba ehyanjo hyohu mutwe gwʼomuutu. ");
INSERT INTO nuj_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","Baŋira ehitundu ehihirira erala obulaŋi, bamubiihira omugabo gwʼomuŋugi. Abatangirisi ba Yisirayiri ni bahumbaana ŋalala, Gaadi gaahola ebiruŋamu ebi Musengwa genda era ebigalagira Abayisirayiri.” ");
INSERT INTO nuj_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","Hu hiha hya Daani gaaloma ati, “Daani ali hyʼenyana yʼepologoma, Atuumatuuma ohuŋwa e Bbasani.” ");
INSERT INTO nuj_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","Hu hiha hya Nafutaali gaaloma ati, “Nafutaali, Musengwa owʼehisa ahuŋaaye ekabi nyingi. Ehyalo hihyo hiŋwa mu mehiriro hu nyanja eyʼe Galilaaya.” ");
INSERT INTO nuj_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","Hu hiha hyʼAseri gaaloma ati, “Aseri ali nʼekabi ohuhira ebiha ebindi. Leha abe muhoda eyiri abaganda babe. Era ehyalo hihye hiijule amafuta gʼemizayiti. ");
INSERT INTO nuj_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","Ebibuga bibye bibeho obuhuumi wʼenjigi ejʼehyoma nʼejehihomo. Era amenyenga mu miyaaya. ");
INSERT INTO nuj_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","“Enywe Yesuramu, eŋuma hatonda ali hya Hatonda wenywe, owefuga hwigulu mu bbanga, mu ŋono eryʼamaani ohubayeeda. ");
INSERT INTO nuj_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","Hatonda owʼemirembe nʼemirembe, njʼehyehwehero hyenywe. Emihono jije ejʼemirembe nʼemirembe njʼeji badederera. Abbinga abalabe benywe, ngʼabaloma ati, ‘Mubasihiirise.’ ");
INSERT INTO nuj_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","Olwʼehyo, Yisirayiri yija humenya mu miyaaya, abejuhulu ba Yakobbo banabenga nʼobuhuumi mu hyalo omuli engaano nʼomwenge gwʼemizabbibbu, ni bahijuhirira nʼolume ohuŋwa mwigulu. ");
INSERT INTO nuj_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","Wesiimire ewe Yisirayiri! Njʼani obundi ali hyʼewe, egwanga eri Musengwa anoŋola? Musengwa njʼengabo, era njʼepiima yenywe eyibaŋa obuŋangusi! Abalabe benywe baaja ni batya, era oja hubatyakirira hu migongo.” ");
INSERT INTO nuj_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","Ngʼaŋo Musa aŋwa mu hifo aŋagwalaali e Mowaabbu, nga gambuha hu lusozi Nebbo, ŋamugulu wa Pisiga, ohwola e Yeriko. Nga Musengwa amulaga ehyalo hyosihyosi ehyʼe Giliyaadi, ohwola e Daani, ");
INSERT INTO nuj_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","nʼehitundu hyosihyosi ehya Nafutaali, nʼehyalo hya Efulayimu ni Manase, nʼehyalo hyosihyosi ehya Yuda, ohwola ebugwalyuba hu nyanja Meditereniani, ");
INSERT INTO nuj_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","nʼe Negevu nomu hiiho hya Yoludaani ehyʼe Yeriko, ehibuga hyʼesaasa, ohwola e Zowaali. ");
INSERT INTO nuj_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","Nga Musengwa aloma Musa ati, “Ehyo njʼehyalo ehi nalayirira Yibbulayimu ni Yisaka ni Yakobbo ti, ‘Ndihiŋa olusaaye lulwo.’ Ŋahani kulehire ohirengere huhirengera nʼemoni jijo aye sooja hwambuha hutiinamo.” ");
INSERT INTO nuj_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Ngʼaŋo Musa omuŋeeresa wa Musengwa, afiira eyo mu hyalo hyʼe Mowaabbu, ngʼolu Musengwa galoma. ");
INSERT INTO nuj_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","Nga Musengwa amusiiha mu hiiho mu hyalo hyʼe Mowaabbu huupi nʼehibuga Bbesi Pewori. Aye nʼohwola hatyane, ŋaŋuma amanyire ehifo ehyene nʼehyene aŋa bamusiiha. ");
INSERT INTO nuj_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","Aŋa Musa gafiira, gaali aŋesa emyaha cikumi nabiri. Cooka gaali ahibona bulaŋi era nʼahiiri nʼamaani. ");
INSERT INTO nuj_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","Abayisirayiri balira Musa ohuhena endaalo amahumi adatu e Mowaabbu, ohwola ehiseera ehyʼohulira ni hyaŋwaho. ");
INSERT INTO nuj_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","Yoswa omusaani wa Nuuni geejula amagesi olwohuba Musa gaali amutayeeho emihono. Kale Abayisirayiri bagondera Yoswa era baŋamba nʼamagambi aga Musengwa gaŋa Musa. ");
INSERT INTO nuj_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","Siŋabangaŋo naabbi mu Yisirayiri ali hya Musa, oyu Musengwa gaalomanga ni naye moni hu moni. ");
INSERT INTO nuj_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","Musengwa gaatuma Musa ohuhola ebyamaliholiho nʼebyeŋunjisa hu habaha wʼe Misiri nʼabatangirisi babe nʼehyalo hihye hyosihyosi. ");
INSERT INTO nuj_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","Era ŋaŋuma naabbi owundi yesiyesi owahola ebyʼamaani era ebitiisa hya Musa, Abayisirayiri bosibosi ni babona.");
INSERT INTO nuj_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Oluvanyuma lwa Musa omuŋeeresa wa Musengwa ohufa, Musengwa galoma Yoswa omusaani wa Nuuni era omuloobera wa Musa ati, ");
INSERT INTO nuj_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“Musa omuŋeeresa wange afuuye. Ŋaahani ewe nʼAbayisirayiri bosibosi, mwetegehe mwambuhe olwabi Yoludaani, mwingire mu hyalo ehi ndi huupi hubaŋa. ");
INSERT INTO nuj_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Ngʼolu nasuubisa Musa, nja hubaŋa hiisi hifo ehi mulyolamo. ");
INSERT INTO nuj_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Olwaha lwʼetwale lyenywe luja huŋwera mu lulafu ohwola hu lusozi Lebbanooni, nindi luŋwe hu lwabi olubbala olu balanga baati Yufuleeti e buŋwalyuba lubite mu hyalo hyʼAbahiiti, ohwola hu Nyanja Meditereniani e bugwalyuba. ");
INSERT INTO nuj_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Ŋaŋuma muutu wayire mulala olisobola ohuhuŋangula endaalo josijosi ejʼobulamu wuwo. Nja huba ni neewe ngʼolu mbaaye ni mba ni Musa. Sinjahuhuleha oba ohuhubba omugongo. ");
INSERT INTO nuj_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Guma omwoyo era otatya olwohuba oja hutangiriira abaatu abo, basikire ehyalo ehi nasuubisa ohuŋa abasehulu baawe. ");
INSERT INTO nuj_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","“Guma omwoyo era otatya. Wegenderesanga ohugondera amagambi gosigosi aga Musa omuŋeeresa wange gaahuŋa. Sogaŋwangaho watiina eyi oba eyi, wahaŋangula hiisi aŋa onatiinenga. ");
INSERT INTO nuj_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Ehitabo ehyo ehyʼAmagambi, ohisomanga habuhyabuhya. Oŋeganga hu birimo omuusi nʼowiire era wegenderesanga ohugondera hiisi hiitu ehi baŋandiihamo. Hija huhuleeteranga ohuhulahulana bugali. ");
INSERT INTO nuj_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Kulomire, guma omwoyo era otatya. Otaŋwamo maani olwohuba Musengwa Hatonda wuwo, aja hubanga ni neewe hiisi aŋʼonatiinenga.” ");
INSERT INTO nuj_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Nga Yoswa alagira abatangirisi ati, ");
INSERT INTO nuj_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“Mutiine mu kambi mulomere abaatu muuti, ‘Mutegehe emere olwohuba mu ndaalo edatu ohuŋwa hatyane muja hwambuha olwabi Yoludaani, mutiine mwesunire omuŋuluko ogu Musengwa Hatonda wenywe ali hubaŋa.’” ");
INSERT INTO nuj_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Nga Yoswa aloma abʼehiha ehya Lubbeeni nʼehya Gaadi nʼehitundu hyʼehiha hya Manase ati, ");
INSERT INTO nuj_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“Muhebulire ehiragiro ehi Musa omuŋeeresa wa Musengwa gabaŋa olu gabaloma ati, ‘Musengwa Hatonda wenywe aja hubaŋa ehifo ehyʼohuŋuumuliramo era aja hubaŋa ehyalo ehiri ebuŋwalyuba wʼolwabi Yoludaani. ");
INSERT INTO nuj_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Abahasi nʼabaana abaŋere nʼebyayo byenywe bija husigala ŋano, aye abasinde abʼamaani abetegefu baja hwambuha nʼebisoosa batiine mu lutalo bayeede abalebe benywe, ");
INSERT INTO nuj_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","ohwola olu balihena ohusuna aŋohumenya ebugwalyuba wʼolwabi Yoludaani, ehyalo ehi Musengwa Hatonda wenywe gabategehera. Ni mulihena nga enywe mwagamayo mumenya ebuŋwalyuba wʼolwabi Yoludaani, mu hyalo ehi Musa omuŋeeresa wa Musengwa gabaŋa.’” ");
INSERT INTO nuj_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Ngʼaŋo bagobola mu Yoswa baati, “Byosibyosi ebi otulagiiye, huja hubihola era hiisi aŋa onatutumenga huja hutiinanga. ");
INSERT INTO nuj_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Ngʼolu hwagonderanga Musa mu hiisi hiitu, weesi huja huhugondera. Hulomba hirala Musengwa Hatonda wuwo abenga ni neewe ngʼolu abaaye naaba ni Musa. ");
INSERT INTO nuj_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Omuutu yesiyesi ojeemera ehiragiro hihyo, ndaŋulira bibono bibyo, aja hufa. Olwʼehyo guma omwoyo era otatya.” ");
INSERT INTO nuj_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Ngʼaŋo Yoswa omusaani wa Nuuni atuma abambega babiri ohuŋwa e Sitimu, ngʼabaloma ati, “Mutiine mwetegerese ehyalo hyʼe Kanani ohusingira erala ehibuga Yeriko.” Nga batiina, ni boola bengira mu nyumba yʼomuhasi malaaya oyu balanganga baati Rahabbu, nga baŋenyuha eyo. ");
INSERT INTO nuj_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Nga balomera habaha wʼe Yeriko baati, “Bona! Balala hu Bayisirayiri baajire ehyegulo hino ohuheeta ehyalo hyefe.” ");
INSERT INTO nuj_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Nga habaha wʼe Yeriko aŋindiha abasirikale ewa Rahabbu bamuloma baati, “Tusayo abaatu abaajire mu nyumba yiyo olwohuba ehi baleetire huheeta hyalo hyefe.” ");
INSERT INTO nuj_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","Aye omuhasi oyo gaali aŋambire abasinde abo bombi nʼabahwehire. Ngʼabagobolamo ati, “Hituufu abasinde abo baajire aye simanyire eyi baŋwereeye. ");
INSERT INTO nuj_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","Ehiirema ni hyenda ohuŋamba, mu hiseera ehyohwigalaŋo omulyango gwʼehibuga, paŋa basinde abo baŋwereeyeŋo. Sinamanyire ngira eyi baŋambire. Mubalondeho mangu, muŋanga mwabagaana.” ");
INSERT INTO nuj_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","Aye gaali abaŋirire ŋamugulu hu nyumba nʼabahwehire mu bihangala ebi gaali ni ganjaaye bulaŋi hu hasolya. ");
INSERT INTO nuj_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Ngʼabasirikale abo basimbuha balonda hu bambega abo hu luguudo olutiina aŋa bambuhira olwabi Yoludaani. Aye ni batula baati mu hibuga, nga begalaŋo omulyango. ");
INSERT INTO nuj_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Abambega abo ni baali ni bahiiri huŋenyuha, nga Rahabbu atiina aŋa baali hu nyumba ");
INSERT INTO nuj_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","abaloma ati, “Manyire ti Musengwa abaŋaaye ehyalo hino. Era hiisi muutu mu hyalo hyefe hino ali hulebera ekoba olwenywe. ");
INSERT INTO nuj_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Hwaŋulira ngʼolu Musengwa gomeesa amaaji gʼEnyanja Enando ni muŋwa e Misiri. Era hwaŋulira ehi mwahola abahabaha ababiri abʼAbamooli, Sihoni ni Ogi, abaali ebuŋwalyuba wʼolwabi Yoludaani, aba mwasihiirihisa erala. ");
INSERT INTO nuj_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Ni hwaŋulira ebyo, hwaŋwamo amaani olwenywe. Musengwa Hatonda wenywe, nje Hatonda owa ŋamugulu mwigulu nohu hyalo huno. ");
INSERT INTO nuj_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","“Ŋaahani mundayirire mu moni ja Musengwa, muuti muja humbisya ese nʼolulyo lwange bulaŋi ngʼolu ese mbabihisye bulaŋi. Era muupe ahabonero ahanahahase ");
INSERT INTO nuj_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","haati simuja hwita bbaabba ni maama nʼababoojo bange nʼabaganda bange ko nʼabomumago gaawe era mutuŋonie ohufa.” ");
INSERT INTO nuj_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Ngʼabasinde abo beeyama baati, “Hatonda atusihiirisanga singa sihuhola ehi huhuloma. Huhuhahasa huuti, singa solomera muutu yesiyesi ehi hubaaye ni huhola ŋano, Musengwa nʼalituŋa ehyalo hino, hulibabisya bulaŋi.” ");
INSERT INTO nuj_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Ngʼaŋo Rahabbu aŋamba omugoye abehisaho ŋaasi nʼababisya mu dinisa. Enyumba yiye baali bayitongooye hu hiteepe ehyeswanigirisanga ehibuga. ");
INSERT INTO nuj_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Ngʼabaloma ati, “Mutiine mu hyalo hyʼesozi ko ababaŋiima batababona. Mwehwehe eyo ohuhena endaalo edatu ohwola olu banahagoboleŋo, oluvanyuma mwetiinire eyi mwetiinira.” ");
INSERT INTO nuj_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Ngʼabasinde abo bamuloma baati, “Ehirayiro ehi otulomire ohulayira, sihija huhola ni hunahaaje ohuwaagala ehyalo hino ");
INSERT INTO nuj_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","ohutusaho nʼosidihire olugoye olulando mu dinisa muno omu oja hutwihisa ŋaasi era wengisa mu nyumba yiyo lataawo ni maawo nʼababoojo babo nʼabaganda babo ko ni naabo bosibosi abomu nyumba ya lataawo. ");
INSERT INTO nuj_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Ni ŋalibaŋo omuutu yesiyesi atula mu nyumba yiyo, nʼafanga omwene guliba gugwe sosi efe. Aye anahasune ehigosi hyosihyosi nʼali ni neewe mu nyumba, ehyo hinahabe hituŋambaho. ");
INSERT INTO nuj_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Aye singa olomeraho omuutu yesiyesi gamanya ebi huliho, ehyo hija huba hibbwagireŋo oweyamo obu otulomire ohweyama.” ");
INSERT INTO nuj_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Ngʼaŋo Rahabbu abagobolamo ati, “Fugiriiye, leha hibe ngʼolu mulomire.” Ngʼahena abaseebula batiina. Nga Rahabbu asidiha olugoye olulando mu dinisa. ");
INSERT INTO nuj_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Abasinde abo nga basimbuha batiina mu hyalo hyʼesozi, nga babaayo endaalo edatu ohwola olu abaali ni babaŋiima bagamayo. Babaheja mu magira gosigosi aye sibababona. ");
INSERT INTO nuj_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Ngʼaŋo abasinde ababiri abo baserengeta baŋwa mu hyalo hyʼesozi bambuha olwabi Yoludaani, nga bagamayo eyiri Yoswa omusaani wa Nuuni, nga bamuŋayira byosibyosi ngʼolu byali. ");
INSERT INTO nuj_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Ngʼaŋo baloma Yoswa baati, “Mu butuufu Musengwa alihutuŋa ehyalo ehyo hyosihyosi. Abaatu baayo balihulebera ekoba olwefe.” ");
INSERT INTO nuj_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Ni wahya mu mugamba pwipwipwi, Yoswa nʼAbayisirayiri basimbuha ohuŋwa e Sitimu nga batiina hu lwabi Yoludaani eyi beemeha ekambi ni bahihuumire ohwambuha. ");
INSERT INTO nuj_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Oluvanyuma lwʼendaalo edatu, abatangirisi bagenda mu kambi yosiyosi, ");
INSERT INTO nuj_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","ni balagira abaatu baati, “Kasita mubona Esanduuku yʼEndagaano ya Musengwa Hatonda wenywe nʼAbaleevi ni bayibbeedire, muli nʼohuŋwa aŋa muli, muyirondeho. ");
INSERT INTO nuj_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Ni mulonda hu Sanduuku yʼEndagaano mutayiba huupi ko mwahamanya bulaŋi engira eyʼohuŋamba olwohuba simubangaho eno. Aye ŋabeŋo ahanaaŋiro nga ahʼemayiro ndala ŋagati wenywe nʼEsanduuku yʼEndagaano.” ");
INSERT INTO nuj_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Nga Yoswa aloma abaatu ati, “Mwegwalaase olwohuba olwejo Musengwa aja huhola ebyeŋunjisa mu enywe.” ");
INSERT INTO nuj_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Nga Yoswa aloma abasengi ba Hatonda ati, “Mubbeede Esanduuku yʼEndagaano, mutangirire abaatu.” Nga bayibbeeda babatangiriramo. ");
INSERT INTO nuj_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Ngʼaŋo Musengwa aloma Yoswa ati, “Olwaleero nja hutandiha ohugulumisa mu moni jʼAbayisirayiri, bahamanya baati ndi ŋalala ni neewe ngʼolu mbayenga ni mba ni Musa. ");
INSERT INTO nuj_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Era lagira abasengi ba Hatonda ababbeedire Esanduuku yʼEndagaano oti, ‘Ni boola hu lwabi Yoludaani, bengire mu maaji bemeerere.’” ");
INSERT INTO nuj_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Nga Yoswa aloma Abayisirayiri ati, “Muuje ŋano muŋulire ebi Musengwa Hatonda wenywe aloma. ");
INSERT INTO nuj_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Hino njʼohu munahategerere muuti Hatonda Omwene Bulamu ali mu enywe era ti salihaya hubbinga Abakanani nʼAbahiiti nʼAbahiivi nʼAbapereezi nʼAbagirugaasi nʼAbamooli nʼAbayebbusi babaŋwereŋo. ");
INSERT INTO nuj_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","Esanduuku yʼEndagaano ya Musengwa wʼehyalo hyosihyosi yija hubatangiriramo yibesooke mu lwabi Yoludaani. ");
INSERT INTO nuj_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Ŋaahani tobola abasinde ehumi nʼababiri, mulala mulala ohuŋwa mu hiisi hiha hya Yisirayiri. ");
INSERT INTO nuj_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Era Abasengi ba Hatonda ababbeedire Esanduuku ya Musengwa kasita baja huta amagulu gaawe mu lwabi Yoludaani baati pa, ngʼaŋo ni naaŋo amaaji galehera ohuduluma gebungiha etuumo.” ");
INSERT INTO nuj_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Ŋaahani abaatu ni baaŋwa mu kambi ohutiina ohwambuha Yoludaani, abasengi ni babbeedire Esanduuku yʼEndagaano, babatangiriramo. ");
INSERT INTO nuj_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","Mu biseera byʼegesa, Yoludaani paŋa lwabandiranga era lwali lubandire. Ne abasengi ababbeeda Esanduuku ni boola hu lwabi, amagulu gaawe geema mu maaji, ");
INSERT INTO nuj_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","ngʼaŋo amaaji galehera aŋo ohuduluma. Gebungiha etuumo ohuupi nʼehibuga ehi balanga baati Adamu ehiririheene Zaresaani. Ŋaŋuma maaji agaduluma ni gatiina mu Nyanja Eŋumamo Ehiramu. Ngʼabaatu bagendera hu woomu bambuha ohuupi nʼe Yeriko. ");
INSERT INTO nuj_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Abasengi abaali ni babbeedire Esanduuku yʼendagaano ya Musengwa beemerera hu woomu ŋagati wʼolwabi Yoludaani, ngʼAbayisirayiri bosibosi babitaŋo bambuha ohwola egwanga lyosiryosi olu lyahena ohwambuha ni bagendera hwiroba eryomu. ");
INSERT INTO nuj_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Abayisirayiri bosibosi ni bahena ohwambuha Yoludaani, nga Musengwa aloma Yoswa ati, ");
INSERT INTO nuj_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“Tobola abasinde ehumi nʼababiri, mulala mulala ohuŋwa mu hiisi hiha, ");
INSERT INTO nuj_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","obalagire bangale amabaale ehumi nʼabiri ni bagatusa ŋagati wa Yoludaani, mu hifo aŋa basengi ba Hatonda bemereeye, mwambuhe ni nago mugate mu hifo ehi muja huŋenyuhamo ehiire hyʼolwa leero.” ");
INSERT INTO nuj_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Nga Yoswa alanga abasinde ehumi nʼababiri aba gatobola mu Bayisirayiri, mulala mulala ohuŋwa mu hiisi hiha, ");
INSERT INTO nuj_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","ngʼabaloma ati, “Mutiine ŋagati wa Yoludaani aŋali Esanduuku ya Musengwa Hatonda wenywe. Hiisi mulala hu enywe ohuŋwa mu biha ehumi nabibiri ebya Yisirayiri abugule ebaale alite hwibega. ");
INSERT INTO nuj_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","Amabaale ago gaja huba habonero eyi muli. Mu moni eyo, abaana benywe ni bababuusanga ehi mabaale ago gategeesa, ");
INSERT INTO nuj_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","mubalomeranga muuti amaaji gomu Yoludaani galehera ohugenda gasigulira Esanduuku yʼEndagaano ya Musengwa. Ni baali ni bayisomosa Yoludaani amaaji galehera ohuduluma. Amabaale ago gaja huba hyʼohuhebulirirangaho eyiri Abayisirayiri emirembe nʼemirembe.” ");
INSERT INTO nuj_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","NgʼAbayisirayiri bahola ngʼolu Yoswa gabalagira. Nga batiina babugula amabaale ehumi nʼabiri ŋagati wa Yoludaani ngʼolu biha bya Yisirayiri biri era ngʼolu Musengwa galagira Yoswa. Ni bahena nga babbeeda amabaale ago bagaŋira bagatwihula mu kambi yaawe. ");
INSERT INTO nuj_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Nga Yoswa ahomeha amabaale ehumi nʼabiri ago agabatusa ŋagati wʼolwabi Yoludaani, mu hifo aŋa basengi ababbeeda Esanduuku yʼEndagaano aŋa bemeerera. Era amabaale ago gahiiriŋo nʼolwa leero luno. ");
INSERT INTO nuj_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Abasengi ababbeeda Esanduuku yʼEndagaano basigala ni bemereeye ŋagati wa Yoludaani ohwola olu baatu baahola hiisi hiitu ehi Musengwa gaali nʼalagiiye Yoswa, nʼabita mu Musa. Ebyo ni byaŋwa ngʼabaatu banguŋa bambuha. ");
INSERT INTO nuj_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","Ni bahena bosibosi ohwambuha, ngʼabasengi abaali nʼEsanduuku yʼEndagaano ya Musengwa boosi nga bambuha abaatu ni babatayeho emoni. ");
INSERT INTO nuj_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Abasinde ohuŋwa mu hiha hya Lubbeeni nʼehya Gaadi ko nʼehitundu hyʼehiha hya Manase batangiriramo, ni bali betegefu ohusoola. Baali mu moni jʼAbayisirayiri ngʼolu Musa gabalagira. ");
INSERT INTO nuj_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","Abasinde huupi emitwalo ene, ni bali nʼebisoosa basomoha Musengwa nʼali ni nabo, batiina mu hifo ehiduleere aŋaapi nʼe Yeriko. ");
INSERT INTO nuj_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Hu ludaalo olwo, ebi Musengwa gahola byaleetera Abayisirayiri ohuŋanga Yoswa eŋono mu bulamu wuwe wosiwosi ngʼolu baŋanga Musa. ");
INSERT INTO nuj_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Ngʼaŋo Musengwa aloma Yoswa ati, ");
INSERT INTO nuj_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“Lagira abasengi ababbeedire Esanduuku yʼEndagaano, baŋwe mu lwabi Yoludaani.” ");
INSERT INTO nuj_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Nga Yoswa alagira abasengi ati, “Muŋwe mu Yoludaani muuje eno.” ");
INSERT INTO nuj_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","Ngʼabasengi baŋwa mu lwabi Yoludaani ni babbeedire Esanduuku yʼEndagaano ya Musengwa. Kasita baŋwa ŋagati wʼolwabi beema hwigobo baati pa, ngʼaŋo ni naaŋo amaaji gagobolamo ohuduluma nindi era nga gabanda ngʼolu gaali oludaayi. ");
INSERT INTO nuj_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Hu ludaalo olwʼehumi mu mwesi omudaayi mu mwaha, abaatu basomoha olwabi Yoludaani, batiina bemeha ekambi yaawe e Gilugaali olwʼebuŋwalyuba wʼesalo lya Yeriko. ");
INSERT INTO nuj_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Nga Yoswa ahomeha amabaale ehumi nʼabiri e Gilugaali aga batusa mu lwabi Yoludaani. ");
INSERT INTO nuj_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","Ngʼaloma Abayisirayiri ati, “Mu moni eyo abaana benywe ni bababuusanga baati amabaale gano gategeesa hi?” ");
INSERT INTO nuj_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","“Mubalomeranga muuti, ‘Abayisirayiri basomoha olwabi Yoludaani ni bagendera hu woomu.’ ");
INSERT INTO nuj_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Musengwa Hatonda wenywe gomeesa olwabi Yoludaani mwasomoha. Musengwa Hatonda wenywe goomya olwabi Yoludaani ngʼolu gomeesa Enyanja Enando paka olu hwambuha.” ");
INSERT INTO nuj_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","“Hino Musengwa gahihola olwohuba gendire abaatu bosibosi hu hyalo bategeere baati ali nʼamaani era musobole ohutya Musengwa Hatonda wenywe.” ");
INSERT INTO nuj_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Abahabaha bosibosi abʼAbamooli abaali hu luuyi olwʼebugwalyuba wʼolwabi Yoludaani nʼabahabaha abʼAbakanani abaali hwigobo wʼEnyanja Meditereniani baŋulira ngʼolu Musengwa gomeesa amaaji mu Yoludaani hyaleetera Abayisirayiri ohwambuha, balebera ekoba baŋwamo amaani agalumba Abayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Mu hiseera ehyo, Musengwa galoma Yoswa ati, “Bbota obugeso ohuŋwa mu mabaale, ohomole Abayisirayiri abasinde ababahiiri huhomola.” ");
INSERT INTO nuj_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Olwʼehyo, Yoswa gahola ngʼolu Musengwa gamulagira ngʼahomola Abayisirayiri ni bali mu hifo ehi balanga baati Olusozi olwʼEbigode. ");
INSERT INTO nuj_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","Ehyo gahihola olwohuba abasinde abahulu bosibosi abaaŋwa e Misiri abaali mu myaha ejʼohuba abasooli, baali bafiriiye mu lulafu. ");
INSERT INTO nuj_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","Abaatu bosibosi abaaŋwa e Misiri baali babahomooye aye abo ababasaala ni bahiiri mu lulafu sibaali bahomole. ");
INSERT INTO nuj_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","Abayisirayiri bahena emyaha ane ni batangatangira mu lulafu ohwola olu basinde abaali mu myaha ejʼohuba basooli aŋa baŋwera e Misiri baafa olwʼohujeemera Musengwa. Hyali hiityo olwohuba Musengwa gaali aberayiriiye ati sibaja hubona hu hyalo ehi gasuubisa abasehulu baawe ati aja huhituŋa, ehyalo ehituluuha amabeere nʼomudugere. ");
INSERT INTO nuj_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Nga Musengwa agobosa abasaani mu magulu gaawe era abo njʼaba Yoswa gahomola olwohuba ni baali mu lugendo baali sibabahomole. ");
INSERT INTO nuj_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Ni baahena ohuhomola hiisi musinde, nga basigala aŋa baali mu kambi ohwola olu baŋona. ");
INSERT INTO nuj_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Ngʼaŋo Musengwa aloma Yoswa ati, “Olwaleero mbatuhiseeho ehiswalo ehyʼe Misiri.” Era ohuŋwa hulwo nga ehifo ehyo bahiranga baati Gilugaali. ");
INSERT INTO nuj_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Egulo hu ludaalo olwʼehumi neene mu mwesi omwene ogwo, Abayisirayiri ni baali ni bahiiri e Gilugaali mu hifo aŋaapi nʼe Yeriko, baalya Embaga EyʼOhuhebuliraho Ohubihisya. ");
INSERT INTO nuj_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Ni wahya mu mugamba, baalya hu mere ohuŋwa mu hyalo hyʼe Kanani, omwali ebiryo ebyʼembehe ekalange nʼemigaati eji batatayemo ehisimbulusa. ");
INSERT INTO nuj_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Ni baalya hu mere eyo, ngʼoludaalo olwene olwo emaanu eyi balyanga nga yirehera aŋo ohugwa. Era omwaha ogwo baalya emere ohuŋwa hwiroba lyʼe Kanani. ");
INSERT INTO nuj_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Lulala Yoswa ni gaali ohuupi nʼe Yeriko, galengera omusinde ni gemeereye nʼaŋambire epiima. Nga gegeerera aŋa gaali amubuusa ati, “Oli bulala ni neefe oba oli bulala nʼabalabe beefe?” ");
INSERT INTO nuj_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Ngʼomusinde oyo amugobolamo ati, “Mbe, aye ndi muduumisi wʼeŋe lya Musengwa, noolire.” Ngʼaŋo Yoswa ahubba amafuha mu moni jije ohumuŋa eŋono. Era ngʼamuloma ati, “Musengwa yange, hiina ehi wenda ese kole?” ");
INSERT INTO nuj_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Ngʼomuduumisi wʼeŋe lya Musengwa aloma Yoswa ati, “Fihulamo engayito olwohuba ehifo ehi wemeereyemo hyawufu.” Nga Yoswa afihulamo engayito. ");
INSERT INTO nuj_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Ŋaahani mu hiseera ehyo enjigi jʼehibuga Yeriko baali bajigaaye ni bajigunyiiye olwʼohwerinda Abayisirayiri. Yaali eŋuma owingira wayire otula. ");
INSERT INTO nuj_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Nga Musengwa aloma Yoswa ati, “Ehibuga Yeriko ni habaha nʼabasirikale baamo mbaŋaayeyo mu mihono jijo. ");
INSERT INTO nuj_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Ewe nʼabasirikale babo, muhumbe ni mwetoloola ehibuga omulundi mulala hiisi ludaalo, ohuhena endaalo mukaaga. ");
INSERT INTO nuj_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Suna abasengi ba Hatonda musanvu, hiisi mulala aŋambe egwala eryʼolwiga lwʼemiigu, babe mu moni wʼEsanduuku yʼEndagaano. Hu ludaalo olwomusanvu muja huhumba ni mwetoloola ehibuga emirundi musanvu abasengi ni bafuuŋa amagwala. ");
INSERT INTO nuj_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Nʼoŋuliranga ni bafuuŋa amagwala nʼamaani, loma abasirikale bosibosi bahubbe oluhero, ebiteepe ebyʼehibuga binahatepuluhe nga hiisi muutu atiina gengira butereefu mu hibuga.” ");
INSERT INTO nuj_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Nga Yoswa omusaani wa Nuuni alanga abasengi ba Hatonda abaloma ati, “Mubbeede Esanduuku yʼEndagaano, abasengi musanvu batangiriremo Esanduuku ya Musengwa ni baŋambire amagwala agʼameega gʼemiigu.” ");
INSERT INTO nuj_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Ngʼalagira abasirikale ati, “Muhumbe ni mwetoloola ehibuga nʼabahuumi ni baŋambire ebisoosa ni bali mu moni wʼEsanduuku yʼEndagaano ya Musengwa.” ");
INSERT INTO nuj_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Yoswa ni gahena ohuŋa abasirikale ehiragiro, ngʼabasengi omusanvu abaali mu moni ja Musengwa ni baŋambire amagwala omusanvu agʼemiigu, batiina ni bagafuuŋa nga ko abasengi abaali ni babbeedire Esanduuku ya Musengwa babaŋwaho egongo. ");
INSERT INTO nuj_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Abahuumi abaali nʼebisoosa batangiriramo abasengi abaali ni bafuuŋa amagwala, nga hulondaho abaali ni babbeedire Esanduuku yʼEndagaano ngʼabahuumi abayihuuma balondaho. Era mu hiseera ehyo baali bafuuŋa amagwala. ");
INSERT INTO nuj_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Aye Yoswa gaali alagiiye abasirikale babe ati, “Mutahubba nduulu oba oluhero lwosirwosi era ŋatabaŋo ehibono hyosihyosi ehi muloma ohwola hu ludaalo olu ndibaloma ohuhubba oluhero nga ko muhubba!” ");
INSERT INTO nuj_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Hu ludaalo oludaayi, galagira abaatu babbeeda Esanduuku yʼEndagaano ya Musengwa bayetoloosa ehibuga omulundi mulala. Ngʼabasirikale bagobola mu kambi baŋenyuha owiire ohuhya. ");
INSERT INTO nuj_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Hu ludaalo olwagobolaho, Yoswa genyoha mu mugamba pwipwipwi, ngʼabasengi babbeeda Esanduuku ya Musengwa. ");
INSERT INTO nuj_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","Abasirikale batangiriramo, ngʼabasengi omusanvu abaali ni baŋambire amagwala omusanvu ni bagafuuŋa balondaho, ngʼEsanduuku yʼEndagaano ya Musengwa yirondaho, abasirikale abenyuma nga balondaho. Era mu hiseera ehyo hyosihyosi amagwala gaali gafuga. ");
INSERT INTO nuj_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Era hu ludaalo olwohubiri bahumba betoloola ehibuga omulundi mulala, nga bagamayo mu kambi. Ehyo bahihola ohuhena endaalo mukaaga. ");
INSERT INTO nuj_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Hu ludaalo olwomusanvu benyoha mu mawiiwi nga bahumba betoloola ehibuga mu ngeri njʼenyene. Aye hu mulundi ogwo, betoloola emirundi musanvu. ");
INSERT INTO nuj_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Omulundi ogwomusanvu abasengi ni bafuuŋa amagwala, nga Yoswa alagira abaatu ati, “Muhubbe oluhero olwohuba Musengwa abaŋaaye ehibuga! ");
INSERT INTO nuj_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Ehibuga nʼebihirimo byosibyosi babiŋeyo eyiri Musengwa. Ohutusaho Rahabbu malaaya nʼabaatu bosibosi abali mu nyumba yiye boŋene, njʼabamuli nʼohubihisya olwohuba gahweha abambega beefe aba hwaŋindiha. ");
INSERT INTO nuj_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Aye mumanya ohutabugula hu biitu byosibyosi ebibaŋongire eyiri Musengwa. Singa muhihola muja hwereetera ohusihiiriha. Era muleetere nʼekambi ya Abayisirayiri ebigosi nʼohusihiiriha. ");
INSERT INTO nuj_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Ebiitu byosibyosi ebi baabbota mu feeza nomu zaabbu nomu bihomo nomu byoma, byawufu eyiri Musengwa era baja hubita aŋa babiiha ebiitu bya Musengwa.” ");
INSERT INTO nuj_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Abasengi ni bafuuŋa amagwala, ngʼabasirikale bahubba oluhero ngʼaŋo ni naaŋo ehiteepe ehyali ni hyeswanigirihiise ehibuga hitepuluha higwa ŋaasi. Nga hiisi muutu gengira baŋamba ehibuga. ");
INSERT INTO nuj_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Basihiirisa hiisi hiitu ehyali mu hibuga ni batambisa epiima, omwali abasinde nʼabahasi, abaŋere nʼabahulu, eŋombe nʼetaama ko ni nasugirya. ");
INSERT INTO nuj_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Nga Yoswa aloma abasinde ababiri abaahola ogwʼohuheeta ati, “Mutiine mu nyumba ya malaaya mumutuse ebulafu nʼabaatu abali mu nyumba yiye bosibosi ngʼolu mwamusuubisa.” ");
INSERT INTO nuj_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Nga batiina batusa Rahabbu ni semwana ni nyina nʼabalebe babe nʼabomu mago gage abandi bosibosi, nga babaŋira mu hifo ohulirihana ekambi yʼAbayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Ni bahena ohubatusa ngʼaŋo bohya ehibuga nʼebyalimo byosibyosi. Ne efeeza nʼezaabbu nʼebiitu ebibabbota mu hihomo nʼebyehyoma babiŋira babibiiha omu babiihanga ebiitu bya Musengwa. ");
INSERT INTO nuj_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Aye Yoswa gaŋonia obulamu wa Rahabbu malaaya, nʼabomu mago gage nʼabaatu abaali mu nyumba yiye olwohuba gahweha abasinde bala abambega aba gaali natumire e Yeriko. Era Rahabbu nʼohwola olwa leero luno amenya nʼAbayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Era mu hiseera ehyo nga Yoswa alabula ati, “Hiisi aligesyaho ohutongola bunyaaha ehibuga Yeriko, aliba geleetireho ehiŋwabo hya Musengwa. “Hiisi alitaŋo omusingi gwʼehibuga ehyo, alifiirwa omuseere wuwe omudaayi. Era hiisi aliwanga enjigi mu miryango jʼehibuga ehyo, alifiirwa omwana wuwe naakoma.” ");
INSERT INTO nuj_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Musengwa gaali ni Yoswa era Yoswa gafuma mu hyalo ehyʼe Kanani hyosihyosi. ");
INSERT INTO nuj_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Musengwa gaaloma Abayisirayiri ohutabugula hu biitu ebi baali ni baja husihiirisa. Aye Akani omusaani wa Karumi omwijuhulu wa Zabbudi omusaani wa Zeera ohuŋwa mu hiha hya Yuda, gaaŋira birala hu biitu ebyo nga aleetera Musengwa ohuluŋira Abayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","Nga Yoswa aŋindiha abasinde ohuŋwa e Yeriko batiine baheete ehibuga Ayi ehiririheene Bbesi Aveni ebuŋwalyuba wa Bbeseeri nʼabaloma ati, “Mutiine muheete ehibuga ehyo.” Nga batiina bahiheeta. ");
INSERT INTO nuj_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","Ni bagobola eyiri Yoswa nga bamuloma baati, “Sihyetagisa basirikale bosibosi ohutiina ohulumba ehibuga Ayi. Abasirikale ekumi ebiri oba ekumi edatu bahena, abaatu abalimo batono.” ");
INSERT INTO nuj_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","Nga Yoswa aŋindiha abasirikale ekumi edatu ohulumba ehibuga ehyo. Aye abasirikale bomu hibuga Ayi babafulumusa, ");
INSERT INTO nuj_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","nga bababbinga ohuŋwa hu mulyango gwʼehibuga baboosa hu birombe byʼamabaale ni behirira era beeta abasirikale adatu namukaaga. NgʼAbayisirayiri baŋwamo amaani, balebera ekoba. ");
INSERT INTO nuj_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","Nga Yoswa anabula ebyambalo bibye ngʼahena agwa mafumaaye mu moni wʼEsanduuku ya Musengwa. Ngʼabaaŋo ohwola egulo. Abatangirisi ba Yisirayiri boosi bahola baatyo era beyoŋa efuuhe hu mitwe jaawe ohulaga baati banakuŋafu. ");
INSERT INTO nuj_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","Nga Yoswa aloma ati, “O Musengwa Omwene Buŋangi, lwahiina watwambusa olwabi Yoludaani? Wendire hutuŋaayo eyiri Abamooli batusihiirise? Hani hwamala gasigala engereha wa Yoludaani! ");
INSERT INTO nuj_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","O Musengwa, bona Abayisirayiri badulumire abalabe baawe, olwo ese ŋaahani ndome hiina? ");
INSERT INTO nuj_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","Abaatu baja huŋeega baati siwasobola husolerera baatu babo. Ŋaahani Abakanani nʼabaatu abandi bosibosi mu gwanga lino ni banahaŋulire, baja hutweswanigirisa batusihiirise huŋwe hu hyalo. Olwo sooliba nʼodanyire esiina liryo?” ");
INSERT INTO nuj_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","Ngʼaŋo Musengwa aloma Yoswa ati, “Yemeerera! Ohola hiina mafumaaye? ");
INSERT INTO nuj_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","Abayisirayiri bonoonire, babbwagire endagaano yange eyi nabalagira ohuhuuma. Baaŋira hu biitu ebi baali nʼohusihiirisa, babiiba era badulinga bahena babita ŋalala nʼebiitu byawe. ");
INSERT INTO nuj_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","Ehyo cʼehigira Abayisirayiri ni batasobola huŋangula balabe baawe. Baduluma abalabe baawe olwohuba boosi abeene bereeteye ohusihiiriha. Sinja hweyongera hubayeeda ohutusaho nga musihiirihiise ebiitu ebi muli nʼohusihiirisa. ");
INSERT INTO nuj_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","“Yinyoha otiine ogwalaase abaatu obategehe ohuuja mu moni jange. Balome oti, ‘Mwegwalaase ni mwetegehera olwejo olwohuba Musengwa Hatonda wa Yisirayiri aloma ati, “Enywe Abayisirayiri muli nʼebiitu ebi mwabiihire ebi mwali nʼohusihiirisa. Simuja husobola abalabe benywe ohutusaho ni mubituhiiseŋo.” ’ ");
INSERT INTO nuj_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","“Mu mugamba, baaje eyi ndi hiha hu hiha. Ehiha ehi Musengwa atobolamo, baja hwesoŋolayo lulyo hu lulyo era olulyo olu Musengwa atobolamo, luja huŋwamo mago hu mago. Amago aga Musengwa atobolamo gaja huŋwamo muutu mulala mulala. ");
INSERT INTO nuj_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","Oyo oyu banahagaane nʼebiitu ebyohusihiirisa, baja humuŋwanaho omuliro era aja husihiiriha nʼebiitu bibye byosibyosi olwʼohuleeta ehiswalo hu Bayisirayiri nʼolwohubbwaga endagaano yange gahola ehiitu ehyʼembiho.” ");
INSERT INTO nuj_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","Mu mugamba pwipwipwi Yoswa galeeta Abayisirayiri hiha hu hiha. Nga batobola ehiha hya Yuda. ");
INSERT INTO nuj_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","Ngʼehiha hya Yuda hitiina hyemeerera, ngʼabatobola olulyo lwa Zeera, nga baŋwayo batiina mago hu mago. Nga batobola amago ga Zabbudi. ");
INSERT INTO nuj_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","Nga Zabbudi atusaayo abaatu abomu mago gage, omuutu hya mulala mulala. Akani omusaani wa Karumi era omwijuhulu wa Zabbudi omwijuhulu wa Zeera owomu hiha hya Yuda, njʼoyu batobolamo. ");
INSERT INTO nuj_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","Nga Yoswa aloma Akani ati, “Mwana wange ndomere amazima mu moni ja Musengwa Hatonda wa Yisirayiri, otakweha ehi waholire.” ");
INSERT INTO nuj_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Nga Akani amugobolamo ati, “Hituufu nabbenga mu moni ja Musengwa Hatonda wa Yisirayiri. Era leha kulomere ehi nahola: ");
INSERT INTO nuj_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","Ni nabona mu munyago ogujoola gwʼengoye ogulaŋi ohuŋwa e Sinali nʼesekeeli bihumi biri ejʼefeeza nʼezaabbu esekeeli bihumi bitaanu, omwoyo gwatiiniraho nga mbiŋira. Nabihweha ŋaasi mwiroba mu weema yange, nasookayo efeeza nga ebisigaaye mbita hu mugulu.” ");
INSERT INTO nuj_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","Ngʼaŋo Yoswa atuma abahwenda, nga baduluma batiina mu weema ya Akani era nga batuuhirayo ebiitu ebyo mu weema yiye, nʼefeeza ni yiri ŋaasi nʼebindi hu mugulu. ");
INSERT INTO nuj_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","Nga baŋamba ebiitu ebyo babitusa mu weema babiŋirira Yoswa nʼAbayisirayiri bosibosi, nga babyanjala mu moni ja Musengwa. ");
INSERT INTO nuj_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","Nga Yoswa nʼAbayisirayiri bosibosi baŋamba Akani omusaani wa Zeera, nʼefeeza nʼehijoola hyʼengoye nʼezaabbu nʼabaana babe abahaana nʼabaseere nʼeŋombe ni nasugirya nʼetaama nʼeweema yiye ko nʼebiitu byosibyosi ebi gaali ni nabyo babaŋira mu hiiho ehi balanga baati Akori. ");
INSERT INTO nuj_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","Nga Yoswa amuloma ati, “Lwahiina otuleteeye ebigosi bino? Olwaleero luno, weesi Musengwa aja huhwosaho ebigosi!” NgʼAbayisirayiri bosibosi bamuhubba amabaale ngʼafa. Era oluvanyuma olwʼohumuhubba amabaale nga bahubba nʼabamago gage amabaale. Ni bahena nga babaŋwanaho omuliro era nga baŋwana nohu biitu bibye byosibyosi. ");
INSERT INTO nuj_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","Nga babungiha emungo yʼamabaale hu Akani era emungo eyo ehiiriŋo nʼohwola olwaleero luno. Ehifo ehyo cʼehifa bahiranga baati erungu lya Akori. Ohuŋwa hulwo nga Musengwa atusa ehiruŋi hihye hu Bayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","Nga Musengwa aloma Yoswa ati, “Simbuha nʼabasirikale babo bosibosi mutiine mulumbe ehibuga Ayi. Otatya, guma. Nja huhuŋangusa habaha wa Ayi nʼabaatu babe nʼehibuga ko nʼehyalo hihye bija huba bibyo. ");
INSERT INTO nuj_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","Ebi waahola ehibuga Yeriko ni habaha waamo njʼehi obe nʼohola ehibuga Ayi ni habaha waamo. Aye hu mulundi guno ebiitu nʼebyayo byawe byosibyosi muja hubyesigahisa. Mulumbe ehibuga ehyo ni muhiŋwera egongo.” ");
INSERT INTO nuj_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","Ngʼaŋo Yoswa nʼabasirikale bosibosi batiina balumba ehibuga Ayi. Gatobola abasirikale abʼamaani emitwalo edatu, ngʼabasindiha batiina owiire. ");
INSERT INTO nuj_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","Ngʼabaŋa ebiragiro ati, “Mupulirise bulaŋi. Mutiine mweteege egongo wʼehibuga, ne mutahiba ŋaleeŋi era mwesimwesi mube butebute. ");
INSERT INTO nuj_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","Ese nʼabasirikale huja hulumba ehibuga. Aye abasirikale ba Ayi ni baja huŋwayo ohutulumba ngʼolu baahola hu ludaayi, huja hubaduluma. ");
INSERT INTO nuj_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","Baja hutubbinga ohwola olu baja huba ŋaleeŋi nʼehibuga ni baŋeega baati huli hubaduluma ngʼolu hwahola hu ludaayi. Aŋa huja hubemululiraho, ");
INSERT INTO nuj_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","aŋo enywe paŋa muli nʼohuŋwerayo mu hyehwehere, mutiine muŋambe ehibuga. Musengwa Hatonda wenywe aja huhibaŋa. ");
INSERT INTO nuj_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","Ni muhenire ohuŋamba ehibuga, muhiŋwanangaho omuliro. Muhole ehi Musengwa alagiiye. Era mubone muuti muhola ebi mbalomire.” ");
INSERT INTO nuj_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","Ngʼaŋo Yoswa abasimbula batiina ohweteega ŋagati wa Bbeseeri ni Ayi ebugwalyuba wa Ayi. Aye Yoswa gasigala nʼabaatu abaali ni basigaaye mu kambi owiire obwo. ");
INSERT INTO nuj_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","Nga mu mugamba pwipwipwi Yoswa ahumbaania abasirikale babe. Era nga omwene nʼabatangirisi ba Yisirayiri babatangirira ohulumba ehibuga Ayi. ");
INSERT INTO nuj_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","Abasirikale bosibosi aba gaali ni nabo nga baniinaniina batiina boola mu moni wʼehibuga, ehiiho ni hiri njʼehyabula ŋagati waawe ni Ayi. ");
INSERT INTO nuj_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","Yoswa gaali atiinire nʼabasirikale ekumi etaanu, ni beteegire ebugwalyuba wʼehibuga ŋagati wa Bbeseeri ni Ayi. ");
INSERT INTO nuj_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","Nga bata abasirikale mu bifo ebyenjabulo ngʼehibinje ehibbala hiba mu maniino gʼehibuga nʼeŋe erindi ni liri ebugwalyuba wʼehibuga. Owiire obwo Yoswa gatiina mu hiiho. ");
INSERT INTO nuj_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","Habaha wʼehibuga Ayi ni gabona abasooli ba Yoswa, genyoheramo nʼabasirikale babe bosibosi batiina ena hiiho hyʼe Yoludaani ohusoola nʼAbayisirayiri mu hifo ehyene hira ehi basooleramo oludaayi. Aye sigamanya ati baali bamweteegire enyuma. ");
INSERT INTO nuj_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","Yoswa nʼAbayisirayiri bosibosi beholesa oti hani baduluma, baluŋama mu lulafu. ");
INSERT INTO nuj_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","Abatangirisi bomu hibuga Ayi balanga abasirikale baawe bosibosi baŋwerehereramo ohubbinga Yoswa. Yoswa gabaŋubania oti hani abaduluma ngʼabaŋira ŋaleeŋi nʼehibuga. ");
INSERT INTO nuj_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","Ŋaŋumaŋo musirikale owasigala mu Ayi oba Bbeseeri, bosibosi batiina ohubbinga Abayisirayiri. Baaleha emiryango jʼehibuga ni jiri miigule ni ŋaŋuma mu huumi. ");
INSERT INTO nuj_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","Ngʼaŋo Musengwa aloma Yoswa ati, “Sosya efumo liryo hu hibuga Ayi olwohuba nja huhiŋaayo mu mihono jijo.” Nga Yoswa ahola ngʼolu bamuloma. ");
INSERT INTO nuj_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","Ni gahena ohusosya hu hibuga efumo, ngʼaŋo ni naaŋo abasirikale abaali ni behwehire benyoheramo baduluma beyoŋa mu hibuga bahiŋamba. Era amangu ago nga bahiŋwanaho omuliro. ");
INSERT INTO nuj_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","Abasirikale bomu Ayi ni baheja enyuma balengera eriisi ni liduunya ohuŋwa mu hibuga, byabasobera ni ŋaŋuma ŋa hudulumira olwohuba Abayisirayiri abaali ni badulumira ena lulafu, bacuuhaŋo babalumba. ");
INSERT INTO nuj_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","Yoswa nʼAbayisirayiri bosibosi ni baabona baati abahyawe baŋambire ehibuga era bahiŋwanireeho nʼomuliro, nga bacuuha batagiha ohwita abasirikale ba Ayi. ");
INSERT INTO nuj_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","Abayisirayiri abandi abaali mu hibuga, nga boosi batula babalumba. Nga bata aba Ayi ŋagati, babeswanigirisa hu njuyi jombi. Abayisirayiri bababulungula era ŋaŋuma wayire mulala owaŋona. ");
INSERT INTO nuj_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","Aye baŋamba habaha wʼe Ayi mulamu nga bamuŋirira Yoswa. ");
INSERT INTO nuj_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","Abayisirayiri ni bahena ohwita abasirikale ba Ayi abaali mu lulafu eyi baali ni badulumiiye era ni baali ni bahenire ohwita hiisi muutu hu bo, bagamayo mu hibuga Ayi nga beeta hiisi muutu owaalimo. ");
INSERT INTO nuj_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","Abahasi nʼabasinde abaafa hu ludaalo olwo mu Ayi baali omutwalo mulala nʼekumi ebiri, eŋuma muutu wayire mulala owasigala. ");
INSERT INTO nuj_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","Yoswa geyongera ohulengeresa efumo lirye ehibuga Ayi ohwola olu bahena ohwita hiisi owaali nʼahimenyamo. ");
INSERT INTO nuj_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","Era Abayisirayiri baŋira ebyayo nʼebiitu ebindi ohuŋwa mu hibuga ngʼolu Musengwa galagira Yoswa. ");
INSERT INTO nuj_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","Yoswa goohya ehibuga Ayi hyasigala mungo ya maŋuupu era hyaba gunda nʼohwola hatyane. ");
INSERT INTO nuj_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","Geeta habaha wʼe Ayi gaahena gaŋaniha omulambo gugwe hu musaala era gagulehaho ohwola ehyʼegulo. Eryuba aŋa ligwira mu maaji, Yoswa galagira baŋanula omulambo ogwo bagudaanye ŋa mulyango ogwingira mu hibuga. Nga bahena bagubungihaho emungo yʼamabaale era yihiiriŋo nʼohwola hatyane. ");
INSERT INTO nuj_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","Ebyo ni byaŋwa, nga Yoswa atongolera Musengwa Hatonda wa Yisirayiri ehituuti hu lusozi Ebbali ");
INSERT INTO nuj_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","ngʼolu Musa omuŋeeresa wa Hatonda galagira Abayisirayiri. Gahitongola nʼatiinira hu ndagiriro eyiri mu hitabo hyʼAmagambi aga Hatonda gaaŋa Musa eyiroma yiiti, “Babbotanga ehituuti mu mabaale amahwiye agabatahubbire nʼehyoma hyosihyosi.” Hu hituuti ohwo baŋeerangaho Musengwa eŋongo eyi bohya ehwiye lyaguguliha nʼeŋongo eyi baŋayo olwʼohufaaŋana. ");
INSERT INTO nuj_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","Ni baali eyo, Abayisirayiri bosibosi bahumbaana, ngʼaŋo ni naaŋo mu moni jaawe Yoswa agobolamo ohuŋandiiha amagambi aga Hatonda gaaŋa Musa. ");
INSERT INTO nuj_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","Abayisirayiri bosibosi nʼabaatu abahulu mu gwanga nʼabahungu nʼabalamuzi, baali bemereeye hu njuyi jombi ejʼEsanduuku yʼEndagaano ya Musengwa ohulengerera Abaleevi abayibbeedanga. Abagwira nʼabasaale baamo baaliŋo. Abaatu abandi baali mu moni wʼolusozi Gerizimu nʼabandi mu moni wʼolusozi Ebbali. Musa omuŋeeresa wa Musengwa galagira bahole baatyo ehiseera ehyohusuna ekabi ni hyolire. ");
INSERT INTO nuj_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","Oluvanyuma nga Yoswa asoma Amagambi gosigosi, ekabi nʼebiŋwabo, ngʼolu babiŋandiiha mu hitabo hyʼAmagambi. ");
INSERT INTO nuj_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","Hiisi hibono ehyali mu hitabo hyʼamagambi aga Musengwa gaaŋa Musa, Yoswa gahisomera Abayisirayiri bosibosi abaali ni bahumbeene nga pomuli abahasi nʼabaana nʼabagwira abaali ni bamenya ni nabo. ");
INSERT INTO nuj_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","Abahabaha bosibosi abʼebugwalyuba wʼolwabi Yoludaani ni baŋulira ngʼolu Abayisirayiri baŋangula abalabe baawe, abahabaha abʼebugwalyuba mu hyalo ehyʼesozi ni naabo abamenyanga hwigobo lyʼEnyanja Meditereniani ohwola e Lebbanooni, abahabaha bʼAbahiiti nʼAbamooli nʼAbakanani nʼAbapereezi nʼAbahiivi nʼAbayebbusi, ");
INSERT INTO nuj_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","abo bosibosi behobaana begula olutalo hu Yoswa nʼAbayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","Aye abaatu bʼe Gibbyoni ni baŋulira ebi Yoswa gaali nʼaholire Yeriko ni Ayi, ");
INSERT INTO nuj_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","nga basalaŋo ohwefuula oti hani bahwenda ohuŋwa aŋaleeŋi ohuuja eyiri Abayisirayiri. Nga baŋamba ebisaŋu ebihayire nʼebisaŋu ebindi ebyʼomwenge gwʼemizabbibbu ebihayire ebyadiha nga babidabirisa bunyaaha, babitwiha nasugirya jaawe. ");
INSERT INTO nuj_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","Nga bambala engoye enabujuhi nʼebigayito ebyʼebiraka. Nʼemere yaawe yosiyosi eyi baboŋa ohulirangaho mu ngira, yaali yenonoohire era ni yiŋambire omunani. ");
INSERT INTO nuj_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","Nga batiina eyiri Yoswa mu kambi e Gilugaali, nga baloma Yoswa nʼAbayisirayiri baati, “Huŋooye mu hyalo ehya ŋaleeŋi. Hwenda muhole endagaano ni neefe mutatulumba era hwesi hutabalumba.” ");
INSERT INTO nuj_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","NgʼAbayisirayiri baloma Abahiivi abo baati, “Musobola ohuba ni mumenyire huupi ni neefe, hu lwʼehyo huŋanga huutye ohuhola endagaano ni nenywe?” ");
INSERT INTO nuj_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","Nga baloma Yoswa baati, “Huli baŋeeresa babo.” Nga Yoswa ababuusa ati, “Ndinywe abaani era muŋwera ŋeena?” ");
INSERT INTO nuj_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","Nga bamugobolamo baati, “Huli baŋeeresa babo ohuŋwa mu hyalo ehyaŋaleeŋi bugali. Huujire ŋano olwohuba hubaaye huŋulira efuma lya Musengwa Hatonda wuwo. Hwaŋulira ebi gaahola e Misiri, ");
INSERT INTO nuj_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","nʼebi gaahola abahabaha ababiri abʼAbamooli abaali e buŋwalyuba wa Yoludaani. Abahabaha abo nje Sihoni habaha wʼe Hesibboni ni Ogi habaha wʼe Bbasani owaŋugiranga mu Asitaroosi. ");
INSERT INTO nuj_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","Abatangirisi beefe nʼabaatu bosibosi mu hyalo hyefe batulomire baati, ‘Mubugule ebyʼohweyeedesa mu lugendo mutiine mwaganane ni nabo mubalome muuti, “Efe huli baŋeeresa benywe, husunga muhole ni neefe endagaano.”’ ");
INSERT INTO nuj_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","Emere yeefe yino yaali ndaŋi aŋa hwayiboŋera ni huhiiri engo hu ludaalo olu hwatagihiraho olugendo ohuuja eyi muli. Ne ŋaahani mubone ngʼolu yiŋandalaaye yaŋamba nʼomunani. ");
INSERT INTO nuj_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","Ebisaŋu bino byali binyaaha era hwabiijusa omwenge gwʼemizabbibbu aye mubone ngʼolu byesalire efa. Era nʼebyambalo byefe binabuhire nʼengayito jaŋwerera olwʼolugendo oluleeŋi obugali olu hubaayemo.” ");
INSERT INTO nuj_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","Abayisirayiri balya hu mere yaawe ngʼahabonero ahobulala aye sibebuusa hu Musengwa hubona oba hyali hiraŋi ohuhola endagaano ni nabo. ");
INSERT INTO nuj_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","Nga Yoswa ahola endagaano ohutabaŋambaho era ngʼabatangirisi bʼoluhumbaano bataaho emihono. ");
INSERT INTO nuj_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","Oluvanyuma lwʼohuhola ni nabo endagaano ŋabitaŋo endaalo edatu ngʼAbayisirayiri bahitegeera baati abaatu abo baali baliranwa baawe era bamenya huupi ni nabo. ");
INSERT INTO nuj_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","Olwʼehyo benyoheramo batiina ohwendulirisa era bahena endaalo edatu nga boola mu hibuga hyʼe Gibbyoni ni Kefira ni Bbeerosi ni Kiriyaasi Yeyariimu. ");
INSERT INTO nuj_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","Aye Abayisirayiri sibabasoosa olwohuba abatangirisi bʼoluhumbaano baali baholire oweyamo mu siina lya Musengwa Hatonda wa Yisirayiri ni bafugiriiye ohumenya ni nabo miyaaya. Ehyo hyaleetera abaatu abaali mu luhumbaano bosibosi ohwemulugunya hu batangirisi baawe. ");
INSERT INTO nuj_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","Aye abatangirisi bosibosi nga babagobolamo baati, “Hweyama mu moni ja Musengwa Hatonda wa Yisirayiri olwʼehyo sihusobola hubosaho bulabe wosiwosi. ");
INSERT INTO nuj_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","Huja hubaleha babeŋo balamu olwʼoweyamo obu hwahola ko Musengwa atatuboneresa olwohubbwaga oweyamo weefe.” ");
INSERT INTO nuj_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","Olwʼehyo babaleha sibabiita aye babaŋa omulimo ogwʼohubatenyerenga ekwi nʼohubasomberanga amaaji. ");
INSERT INTO nuj_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","Nga Yoswa alanga abaatu bʼe Gibbyoni, ngʼababuusa ati, “Lwahiina mwatudulinga muuti mumenya ŋaleeŋi ni neefe atenga ko mumenya ŋaapi? ");
INSERT INTO nuj_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","Ale ŋaahani mweretireeho ehiŋwabo. Munaabenga beedu ni mutenyanga ekwi era ni musomba nʼamaaji gomu nyumba ya Hatonda wange.” ");
INSERT INTO nuj_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","Ngʼaŋo bagobola mu Yoswa baati, “Efe abeedu babo, hwaŋulira bulaŋi weene ngʼolu Musengwa Hatonda wuwo galagira Musa omuŋeeresa wuwe ohubaŋa ehyalo hino hyosihyosi era mubuye abaatu baamo bosibosi. Obuti watuŋamba era ehyo njʼehyagira hweholaholania. ");
INSERT INTO nuj_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","Ŋaahani huli mu mihono jijo. Tuhole hyosihyosi ehi obona oti njʼehiraŋi era ehituufu.” ");
INSERT INTO nuj_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","Olwʼehyo Yoswa gabaŋonia Abayisirayiri ohubeeta. ");
INSERT INTO nuj_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","Aye ohuŋwa hu ludaalo olwo Yoswa galagira Abagibbyoni ohutenyanga ekwi nʼohusomberanga Abayisirayiri amaaji ko nʼohutenyeranga abasengi ba Hatonda ekwi ejʼeŋongo eryohu hituuti mu hifo ehi Musengwa anaabenga natobooye. Ogwo njʼomulimo ogu bahola nohwola olwa leero luno. ");
INSERT INTO nuj_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","Adoni Zedeki habaha wʼe Yerusaalemu ngʼaŋulira ngʼolu Yoswa gaŋamba ehibuga Ayi gahisihiirisa era gahola habaha wa Ayi ngʼolu gahola Yeriko ni habaha waawe. Nga nindi aŋulira ati Abagibbyoni baholire endagaano nʼAbayisirayiri era bali bulala. ");
INSERT INTO nuj_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","Adoni Zedeki nʼabaatu babe esisi yabaŋamba olwohuba Gibbyoni hyali hibuga hyʼamaani era hyʼomugaso. Mu bibuga omwali owahabaha, Gibbyoni hyali hibuga hibbala ni hihira Ayi era abasirikale baayo baali basooli abʼamaani. ");
INSERT INTO nuj_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Olwʼehyo, Adoni Zedeki habaha wa Yerusaalemu gasunga obuyeedi ohuŋwa ewa Hohamu habaha wʼe Kebbulooni ni Piramu habaha wʼe Yarumusi ni Yafiya habaha wʼe Lakisi ni Debbiri habaha wʼe Egulooni ati, ");
INSERT INTO nuj_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","“Muuje munjeede hulumbe ehibuga hyʼe Gibbyoni olwohuba abaatu baamo baholire endagaano ni Yoswa nʼAbayisirayiri.” ");
INSERT INTO nuj_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","Ngʼaŋo abahabaha abo abataanu abʼAbamooli, ko nje habaha wʼe Yerusaalemu nowe Kebbulooni nowe Yarumusi nowe Lakisi nowe Egulooni nga bagaata ŋalala amaŋe gaawe nga beswanigirisa ehibuga hyʼe Gibbyoni bahigulaho olutalo. ");
INSERT INTO nuj_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Ngʼaŋo abaatu bʼe Gibbyoni baŋeeresa Yoswa obuhwenda mu kambi e Gilugaali eyi gaali baati, “Otatuleha efe abeedu babo. Nja mangu otununule! Tuyeede olwohuba abahabaha bosibosi abʼAbamooli ohuŋwa mu hyalo hyʼesozi bataaye ŋalala amaŋe gaawe era batulumbire.” ");
INSERT INTO nuj_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Olwʼehyo Yoswa genyoheramo ohuŋwa e Gilugaali nʼeŋe lirye lyosiryosi nga pomuli abasirikale abʼamaani. ");
INSERT INTO nuj_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Nga Musengwa aloma Yoswa ati, “Otabatya, kenire ohubaŋaayo mu mihono jijo. Siŋaja hubaŋo wayire mulala aja hu husobola.” ");
INSERT INTO nuj_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Nga Yoswa agenda owiire wosiwosi owo nʼeŋe lirye ohuŋwa e Gilugaali ngʼasinduhirisa Abamooli. ");
INSERT INTO nuj_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","Nga Musengwa atabujula Abamooli, Abayisirayiri ni babona. Nga Yoswa nʼAbayisirayiri babasihiirihisa erala e Gibbyoni. Abayisirayiri baŋiima abaali ni basigaaye hu ngira eyitiina Bbesi Horoni era babeetira mu hibuga Azeka ni Makeda. ");
INSERT INTO nuj_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Ni baali ni baduluma Abayisirayiri ohwihirira hu ngira eyiŋwa e Bbesi Horoni ni yitiina Azeka, nga Musengwa akukumusa agabaale agʼefula gabahubba era bangi abafa nʼohuhiraho ababeeta nʼepiima. ");
INSERT INTO nuj_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Hu ludaalo olu Musengwa gaŋayo Abamooli eyiri Abayisirayiri, Yoswa galomba Musengwa Abayisirayiri ni baŋulira ati, “Ewe eryuba yemeerera ŋamugulu wa Gibbyoni otatenga, era ewe omwesi yemeerera ŋamugulu wʼehiiho hyʼe Ayijalooni.” ");
INSERT INTO nuj_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Ngʼeryuba lyemeerera, nʼomwesi nga gwetegemeha, ohwola olu gwanga lya Yisirayiri lyahena ohuŋangula abasigu balyo ngʼolu babiŋandiiha mu hitabo hya Yasari. Eryuba lyemeerera ŋagati wʼebbanga lyahena huupi oludaalo lulamba ko lyagwa mu maaji. ");
INSERT INTO nuj_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Siŋabangaŋo ludaalo hyʼolwo enyuma eyo era siŋalibaŋo ludaalo hyʼolwo olu Musengwa gaŋulira ohusaba hwʼomuutu. Mu butuufu oweene Musengwa gasoolerera Yisirayiri! ");
INSERT INTO nuj_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Ebyo ni byaŋwa, nga Yoswa nʼAbayisirayiri bosibosi bagamayo mu kambi e Gilugaali. ");
INSERT INTO nuj_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","Abahabaha abataanu abʼAbamooli baali badulumire ni behwehire mu pungulu yʼe Makeda. ");
INSERT INTO nuj_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","Ni balomera Yoswa baati abahabaha abataanu babageene ni behwehire mu pungulu e Makeda, ");
INSERT INTO nuj_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","ngʼabaloma ati, “Muŋiringisye agabaale mwigale omulyango gwʼepungulu era muhene muteŋo nʼabahuumi. ");
INSERT INTO nuj_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","Aye enywe mutasigala aŋo, mweyongere ohulumba abalabe benywe ni mubaŋwera enyuma era mutabaganya hwingira mu bibuga byawe olwohuba Musengwa Hatonda wenywe abataaye mu mihono jenywe.” ");
INSERT INTO nuj_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","Yoswa nʼAbayisirayiri baŋangulira erala abaatu abo era batono bugali abeŋunula boola mu bibuga byawe ebi batongoleraho olukomera. ");
INSERT INTO nuj_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","Eŋe lyosiryosi lyagobola miyaaya mu kambi e Makeda eyi Yoswa gaali. Era ohuŋwa hulwo ŋaŋuma muutu wayire mulala owagobolayo ohwenyanyira hu Bayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","Nga Yoswa aloma abasirikale babe ati, “Ŋaahani muŋigule ogubaale ŋa mulyango gwʼepungulu muleete abahabaha abataano abo ŋano.” ");
INSERT INTO nuj_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","Nga batusa abahabaha abo abataanu mu pungulu, habaha wʼe Yerusaalemu nowe Kebbulooni nowe Yarumusi nowe Lakisi ko nowe Egulooni. ");
INSERT INTO nuj_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","Yoswa ni gahena ohulanga abasooli Abayisirayiri bosibosi, ngʼalambaasa abahabaha bala abataanu, ahena aloma abaduumisi aba gatiina ni nabo ati, “Muuje ŋano mute amagulu genywe mu mamiro gʼabahabaha bano.” Nga baŋwayo babataho amagulu mu mamiro. ");
INSERT INTO nuj_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","Nga Yoswa abaloma ati, “Mutatya era mutaŋwamo maani. Mugume emyoyo era mutatya olwohuba Musengwa aja huhola atyo abalabe benywe bosibosi aba muja husoola ni nabo.” ");
INSERT INTO nuj_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","Ngʼaŋo Yoswa geeta abahabaha abo abataanu ngʼahena alagira babaŋaniha hu misaala ohwola egulo. ");
INSERT INTO nuj_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","Eryuba aŋa ligwira mu maaji, Yoswa gaŋa ehiragiro baŋanula emirambo jaawe hu misaala bajidanya mu pungulu omu babatuuhira ni behwehire. Hu mulyango gwʼepungulu eyo, begaliraŋo agabaale era gahiiriho nʼohwola olwaleero luno. ");
INSERT INTO nuj_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","Hu ludaalo olwo Yoswa gaŋamba ehibuga Makeda. Nga geeta habaha waamo nʼabaatu bosibosi abaali mu hibuga ehyo, ndalehaŋo wayire mulala ngʼolu gahola habaha wʼe Yeriko. ");
INSERT INTO nuj_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","Ni bahena ohusihiirisa Makeda, nga Yoswa nʼAbayisirayiri bosibosi balumba ehibuga Libbuna. ");
INSERT INTO nuj_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","Nga nindi Musengwa aŋa Abayisirayiri ehibuga hya Libbuna ehyo hyosi bahiŋangula. Ŋaŋuma eyi galeha nʼali mulamu. Era nga beeta habaha nʼabaatu bosibosi ngʼolu gahola habaha wʼe Yeriko. ");
INSERT INTO nuj_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","Ni baahena ehibuga ehyo nga Yoswa nʼAbayisirayiri bosibosi baŋwa e Libbuna batiina mu hibuga Lakisi bahyeswanigirisa era bahiwaagala. ");
INSERT INTO nuj_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","Nga Musengwa aŋa Abayisirayiri ehibuga hyʼe Lakisi era nga Yoswa geeta abaatu bosibosi ahiŋangula hu ludaalo olwohubiri ngʼolu baahola e Libbuna. ");
INSERT INTO nuj_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","Nga habaha Horamu owʼe Gezeri atiina ohuyeedaho Lakisi aye Yoswa gamusihiirisa nʼabasirikale babe ohwola olu ŋaŋuma owasigalaŋo. ");
INSERT INTO nuj_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","Nga Yoswa nʼAbayisirayiri bosibosi baŋwa e Lakisi, batiina mu hibuga hyʼe Egulooni bahyeswanigirisa, nga bahiwaagala. ");
INSERT INTO nuj_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","Bahiŋamba hu ludaalo olwene olwo nga beeta abaatu bosibosi ngʼolu bahola e Lakisi. ");
INSERT INTO nuj_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","Yoswa nʼAbayisirayiri baniinaniina ohuŋwa e Egulooni batiina balumba ehibuga hyʼe Kebbulooni. ");
INSERT INTO nuj_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","Nga bahiŋamba era nga beeta habaha nʼabaatu bosibosi abaali ni bahimenyamo ko nʼabaatu bomu byalo ebyʼohumulirano. Ŋaŋuma oyu baaleha nʼahiŋeera. Gasihiirisa hiisi muutu ngʼolu basihiirihisa ehibuga hyʼe Egulooni. ");
INSERT INTO nuj_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","Nga Yoswa nʼAbayisirayiri bosibosi bacuuhira ehibuga Debbiri bahiwaagala. ");
INSERT INTO nuj_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","Gaŋamba ehibuga ni habaha waawe nʼebyalo ebiririheene nga babeeta. Basihiirihisa erala hiisi muutu. Era ŋaŋuma kadi mulala oyu baleha nʼahiŋeera. Yoswa gahola abaatu bomu hibuga hyʼe Debbiri ni habaha waawe ngʼolu gahola ehibuga hyʼe Libbuna ni Kebbulooni. ");
INSERT INTO nuj_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","Yoswa gaŋangula amatwale gosigosi nga pomuli nʼehyalo ehyʼesozi ni Negevu nʼabomu mehiriro gʼebugwalyuba nʼabahabaha abandi bosibosi. Ŋaŋuma oyu galeha nʼahiŋeera. Gasihiirihisa erala bosibosi ngʼolu Musengwa Hatonda wa Yisirayiri gaali nʼalagiiye. ");
INSERT INTO nuj_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","Yoswa gababbulyaga ohuŋwera erala e Kadesi Bbaruneya ohwola e Gaaza, nʼohuŋwa e Goseni ohwolera erala e Gibbyoni. ");
INSERT INTO nuj_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","Yoswa gabbulyaga abahabaha abo bosibosi nʼebyalo byawe omulundi mulala olwohuba Musengwa Hatonda wa Yisirayiri gabasoolerera. ");
INSERT INTO nuj_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","Ebyo ni byaŋwa, nga Yoswa gagamayo nʼAbayisirayiri bosibosi mu kambi e Gilugaali. ");
INSERT INTO nuj_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","Olwola, nga Yabbini habaha wa Hazori aŋulira ngʼolu Abayisirayiri baŋanguuye amatwale ago gosigosi. Ngʼaŋo atumisa Yobbabbu habaha wʼe Madoni ni habaha wʼe Simurooni ko ni habaha owe Akusafu, ");
INSERT INTO nuj_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","nʼabahabaha abomu maniino mu hyalo ehyʼesozi, nʼabahabaha bomu hiiho hyʼe Yoludaani mu mehiriro gʼenyanja Galilaaya, nʼabahabaha bomu meeho gʼolusozi ebugwalyuba ko nʼabahabaha bomu Naposi Doori ebugwalyuba ohutiina bamuyeede ohusoosa Abayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","Era gatumisa nʼabahabaha bomu Kanani abʼebuŋwalyuba nʼabebugwalyuba nʼabahabaha bʼAbamooli nʼAbahiiti nʼAbapereezi nʼAbabayebbusi mu hyalo hyʼesozi era nʼAbahiivi mu hyalo hyʼe Mizupa mu meenamo gʼolusozi Herumooni. ");
INSERT INTO nuj_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","Nga baŋwayo nʼamaŋe gaawe gosigosi nʼembalaasi enyene enyingi nʼebigaali era abasirikale baali babitiirifu ni batabaliha hyʼomujehe hwigobo lyʼenyanja. ");
INSERT INTO nuj_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","Abahabaha abo bosibosi baŋimba ŋalala amaŋe gaawe nga bata ekambi ŋʼamaaji gʼe Meromu ohusoosa Yisirayiri. ");
INSERT INTO nuj_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","Nga Musengwa aloma Yoswa ati, “Otabatya, olwohuba olwejo esaawa hyʼejino, nja hubaŋaayo bosibosi eyiri Yisirayiri bafe. Mutemanga embalaasi jaawe mwajiremasa era mwahena mwohya nʼebigaali byawe.” ");
INSERT INTO nuj_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","Ngʼaŋo Yoswa nʼeŋe lirye lyosiryosi batiina babagwaho ni batamanyire ŋʼamaaji gʼe Meromu ");
INSERT INTO nuj_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","era Musengwa gabaŋayo mu ngalo jʼAbayisirayiri. Babaŋangula bababbingirira bababisya e Misurefoosi Mayimu mbabo e Sidoni nga baboosa mu hiiho hyʼebuŋwalyuba wʼe Mizupa. Ŋaŋuma owaluŋona. Oluvanyuma lwʼolutalo ohuŋwa Abayisirayiri bagamayo nga bohya ebigaali byʼabalabe baawe. ");
INSERT INTO nuj_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","Yoswa gabahola ngʼolu Musengwa gamulagira, gaatema amagulu gʼembalaasi nga goohya nʼebigaali byawe. ");
INSERT INTO nuj_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","Mu hiseera ehyo, Yoswa gagobolayo ngʼawaagala Hazori nga geeta habaha waayo. Habaha wʼe Hazori njʼowaali omutangirisi wa bahabaha bala bosibosi abeŋimba ohusoosa Yisirayiri. ");
INSERT INTO nuj_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","Abayisirayiri basihiirihisa erala abaatu bosibosi abaali ni bamenya mu hibuga Hazori, ŋaŋuma wayire mulala oyu baaleha era nga Yoswa goohya ehibuga ehyo. ");
INSERT INTO nuj_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","Yoswa gaŋamba ebibuga ebyo byosibyosi nʼabahabaha baawe ngʼabeeta ngʼolu Musa omuŋeeresa wa Musengwa galagira. ");
INSERT INTO nuj_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","Aye Abayisirayiri sibasihiirisa bibuga ebibatongola hu sozi wayire hirala ohutusaho ehibuga hyʼe Hazori ehi Yoswa goohya omuliro. ");
INSERT INTO nuj_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","Abayisirayiri baŋira ebyʼomunyago byosibyosi nʼebyayo ohuŋwa mu bibuga ebyo. Aye nga beeta hiisi muutu ndibaleheŋo wayire mulala. ");
INSERT INTO nuj_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","Ngʼolu Musengwa galagira Musa omuŋeeresa wuwe, Musa yeesi galaabbira Yoswa era nga Yoswa yeesi ahola ngʼolu bamuloma. Gahola hiisi hiitu ngʼolu Musengwa galagira Musa. ");
INSERT INTO nuj_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","Kale Yoswa nʼeŋe lirye baŋamba ehyalo hya Yisirayiri hyosihyosi ehyʼesozi ohwola mu mehiriro. Baŋamba etwale lya Goseni lyosiryosi nʼehyalo ehyomu lulafu ko nomu hiiho hyʼe Yoludaani, ");
INSERT INTO nuj_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","ohuŋwa hu lusozi Halaki ohutiina wehoonya e Seyiri ohwola e Bbaali Gaadi mu hiiho hyʼe Lebbanooni ŋaasi wʼolusozi Herumooni. Yoswa gaŋamba abahabaha baawe bosibosi ngʼabeeta. ");
INSERT INTO nuj_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","Yoswa gahena ehiseera hireeŋi nʼasoola nʼabahabaha abo bosibosi. ");
INSERT INTO nuj_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","Ohutusaho Abahiivi abaali ni bamenya e Gibbyoni, eŋuma hibuga ehindi wayire hirala ehyahola endagaano ohuba bulala nʼAbayisirayiri. Ebibuga ebindi byosibyosi Abayisirayiri babisoosa, babiŋangula. ");
INSERT INTO nuj_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","Musengwa omwene njʼowahahanyasa emyoyo jaawe bahegula hu Bayisirayiri olutalo ko gahabasihiirihisa erala ni ŋaŋuma hubaŋambira ehisa ngʼolu Musengwa galagira Musa. ");
INSERT INTO nuj_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","Mu hiseera ehyo, Yoswa nʼeŋe lirye batiina basihiirisa Abanaki abaali ni bamenya mu hibuga Kebbulooni nomu Debbiri nomu Anabbu ko nomu twale lyʼabehiha hya Yuda nomu Yisirayiri ebyalo ebyʼesozi. Yoswa gabasihiirihisa erala bosibosi ko nʼebibuga byawe. ");
INSERT INTO nuj_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","Mu twale lya Yisirayiri ŋaŋuma Munaki wayire mulala owasigala ohutusaho mu Gaaza nomu Gaasi ko nomu Asidodi. ");
INSERT INTO nuj_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","Yoswa gawamba ehyalo ehyo hyosihyosi ngʼolu Musengwa galoma Musa. Nga Yoswa aŋa Abayisirayiri ehyalo ehyo ohuba muŋuluko gwawe nʼatiinira hu biha byawe. Ngʼaŋo etalo jihoma Abayisirayiri bamenya miyaaya. ");
INSERT INTO nuj_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","Bano njʼabahabaha abʼAbayisirayiri baŋangula era njʼabaali abeene matwale agʼebuŋwalyuba wa Yoludaani ohuŋwera erala mu hiiho Arunooni ohwola hu lusozi Herumooni nʼebuŋwalyuba wʼehiiho hyʼe Yoludaani aga Bayisirayiri baŋira. ");
INSERT INTO nuj_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","Mulala hubo gaali nje Sihoni habaha wʼAbamooli ni gehala e Hesibboni. Gaŋuganga ohuŋwa Aroweeri hu tulo wʼehiiho ehya Arunooni, ohwola hu lwabi Yabboki hu lwaha nʼAbamooni ohwo nga puhuli nʼehitundu hyʼetwale lyʼe Giliyaadi. ");
INSERT INTO nuj_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","Era gaŋuganga ebuŋwalyuba wa meeho ga Yoludaani ohuŋwa hu nyanja yʼe Galilaaya mu mehiriro ohwola e Bbesi Yesimoosi ebuŋwalyuba wʼEnyanja Eŋumamo Ehiramu paka mu mehiriro gʼolusozi Pisiga. ");
INSERT INTO nuj_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","Era baŋangula ni Ogi habaha wʼe Bbasani owaali mulala hu Bareefa asembayo ni gehala Asitaroosi ko nʼe Edereeyi. ");
INSERT INTO nuj_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","Gaŋuganga ohwola hu lusozi Herumooni ni Saleka ni Bbasani paka hu salo ya Gesuri ni Maaka nʼehitundu ehya Giliyaadi ohwola hu salo ya Sihoni habaha wʼe Hesibboni. ");
INSERT INTO nuj_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","Musa omuŋeeresa wa Musengwa nʼAbayisirayiri baŋangula abahabaha abo. Era nga Musa omuŋeeresa wa Musengwa, aŋa abʼehiha hya Lubbeeni nʼabehiha hya Gaadi nʼehitundu hyʼabehiha hya Manase, ehyalo ehyo ohuba omuŋuluko gwawe. ");
INSERT INTO nuj_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","Luno njʼolukalala lwʼamasiina gʼabahabaha aba Yoswa nʼAbayisirayiri baŋangula ebugwalyuba wa Yoludaani ohuŋwa e Bbaali Gaadi mu hiiho hyʼe Lebbanooni ohwola hu lusozi Halaki ohwehoonya e Seyiri. Yoswa gagaba Abayisirayiri ebyalo byawe ohuba miŋuluko jaawe ngʼolu biha byawe byali. ");
INSERT INTO nuj_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","Mwiroba omwo mwalimo ehyalo ehyʼesozi ehyali ebugwalyuba mwabamo nʼehiiho hyʼe Yoludaani nʼameeho gʼolusozi nʼolulafu ni Negevu. Abaatu abamenyanga mu matwale ago baali Abahiiti nʼAbamooli nʼAbakanani nʼAbapereezi nʼAbahiivi ko nʼAbayebbusi. ");
INSERT INTO nuj_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","Bano njʼabahabaha abʼAbayisirayiri baŋangula: habaha wʼe Yeriko ni habaha wʼe Ayi ehirireene Bbeseeri ");
INSERT INTO nuj_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","ni habaha wʼe Yerusaalemu ni habaha wʼe Kebbulooni ");
INSERT INTO nuj_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","ni habaha wʼe Yarumusi ni habaha wa Lakisi ");
INSERT INTO nuj_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","ni habaha wʼe Egulooni ni habaha wʼe Gezeri ");
INSERT INTO nuj_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","ni habaha wʼe Debbiri ni habaha wʼe Gederi ");
INSERT INTO nuj_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","ni habaha wʼe Horuma ni habaha wʼe Aradi ");
INSERT INTO nuj_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","ni habaha wʼe Libbuna ni habaha wʼe Adulamu ");
INSERT INTO nuj_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","ni habaha wʼe Makeda ni habaha wʼe Bbeseeri ");
INSERT INTO nuj_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","ni habaha wʼe Tapuwa ni habaha wʼe Heferi ");
INSERT INTO nuj_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","ni habaha wʼe Afeki ni habaha wʼe Lasarooni ");
INSERT INTO nuj_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","ni habaha wʼe Madoni ni habaha wʼe Hazori ");
INSERT INTO nuj_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","ni habaha wʼe Simurooni Meroni ni habaha wʼe Akusafu ");
INSERT INTO nuj_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","ni habaha wʼe Tanaki ni habaha wʼe Megido ");
INSERT INTO nuj_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","ni habaha wʼe Kedesi ni habaha wʼe Yokuneyaamu hu lusozi Karumeeli ");
INSERT INTO nuj_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","ni habaha wʼe Doori hu mwalo ni habaha wʼe Goyiimu mu Gilugaali ");
INSERT INTO nuj_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","ni habaha wʼe Tiruza. Ŋosiŋosi ŋalala baali abahabaha amahumi adatu namulala. ");
INSERT INTO nuj_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","Olwola, Yoswa nʼasahuluŋire bugali, Musengwa gamuloma ati, “Osahuluŋire aye ŋahiiriŋo ebyalo bingi ebyohuŋamba ngʼomuŋuluko. ");
INSERT INTO nuj_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","Amatwale agasigaaye ngagano: Amatwale gosigosi agʼAbafirisuuti nʼAbagesuri, ");
INSERT INTO nuj_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","etwale ebbala eryʼAbakanani ohuŋwa hu lwabi Sihori hu lwaha nʼe Misiri mu maniino ko woole hu salo nʼEkurooni. Etwale eryo liŋiriramo etwale lyʼabaŋugi bʼAbafirisuuti abataanu, owʼe Gaaza nowe Asidodi nowe Asikelooni nowe Gaasi nowe Ekurooni. Muteehwa ohuŋamba ehyalo hyʼAbaava ");
INSERT INTO nuj_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","mu mehiriro, ehyalo hyʼAbakanani hyosihyosi ni Meyala ehyʼAbasidoni ohwola hu Afeki hu salo nʼAbamooli, ");
INSERT INTO nuj_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","etwale lyʼAbagebbali nʼerya Lebbanooni lyosiryosi nʼehyalo ehyʼesozi ebuŋwalyuba ohuŋwa e Bbaali Gaadi mu meeho gʼolusozi Herumooni ohwola e Lebbo Hamasi. ");
INSERT INTO nuj_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","“Ebyalo ebyo pomuli amatwale gʼAbasidoni gosigosi abamenya mu hyalo ehyʼesozi ŋagati wʼesozi ja Lebbanooni ni Misurefoosi Mayimu. Ese samwene nja hubbinga abaatu abo mu hyalo ehyo basigulire Abayisirayiri. Era omanya ohuŋa Abayisirayiri ehyalo ehyo ohuba muŋuluko gwawe ngʼolu nahulagira. ");
INSERT INTO nuj_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","Ogabiranga ebiha omwenda ko nʼehitundu ehyʼehiha hya Manase ehyalo ehyo ohuba omuŋuluko gwawe.” ");
INSERT INTO nuj_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","Ehiha hya Lubbeeni nʼehya Gaadi, nʼehitundu hyʼehiha hya Manase, Musa omuŋeeresa wa Musengwa gaali ahenire ohubaŋa emiŋuluko jaawe ebuŋwalyuba wʼolwabi Yoludaani. ");
INSERT INTO nuj_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","Etwale lyawe lyali lyehoonya hu hibuga hyʼe Aroweeri hu tulo wʼehiiho ehyʼe Arunooni ko nʼehibuga ehiri ŋagati wʼehiiho ehyo. Etwale eryo lyali liŋiriramo ehifo ehigwalaali ehyomu lulafu lwʼe Medebba ohwola hu lwaha nʼehibuga Dibboni. ");
INSERT INTO nuj_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","Etwale lyawe lyatiinanga paka ebuŋwalyuba wʼesalo lyʼAbamooni. Era lyaŋambirangamo ebibuga byosibyosi ebi Sihoni habaha wʼAbamooli owihalanga mu hibuga Hesibboni, gaŋuganga. ");
INSERT INTO nuj_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","Era lyali liŋiriramo ni Giliyaadi, nʼamatwale gʼe Gesuri ni Maaka, lyaŋambiramo nʼolusozi Herumooni lwosirwosi ni Bbasani ohwola hu Saleka. ");
INSERT INTO nuj_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","Lyali liŋambiramo etwale lya habaha Ogi lyosiryosi mu Bbasani, owihalanga mu Asitaroosi nʼEdereeyi era njʼOmureefa yeŋene owasembayo. Musa gabaŋangula gabaŋiraho nʼeroba lyawe. ");
INSERT INTO nuj_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","Aye Abayisirayiri sibabbinga Bagesuri nʼAbamaaka era bahimenya nʼAbayisirayiri nʼohwola olwa leero luno. ");
INSERT INTO nuj_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","Aye Musa sigaŋa hiha hya Leevi omuŋuluko olwohuba emere eyi baŋangayo nga eŋongo eyiri Musengwa Hatonda wa Yisirayiri, njʼeyaali ni yija huba omugabo gwawe ngʼolu Musengwa gabasuubisa. ");
INSERT INTO nuj_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","Musa gaŋa abʼehiha hya Lubbeeni omuŋuluko ngʼolu endyo jaawe jaali. ");
INSERT INTO nuj_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","Omuŋuluko gwawe gwatandihira hu hiiho hyʼe Aroweeri hutulo wʼehiiho hyʼe Arunooni nʼohuŋwa hu hibuga ehiri ŋagati wʼehiiho ehyo ohwola mu hirafu hyʼe Medebba. ");
INSERT INTO nuj_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","Era mwaŋambiramo ni Hesibboni nʼebibuga byosibyosi ebyomu hirafu omuli: Dibboni ni Bbamosi Bbaali ni Bbesi Bbaali Mewoni ");
INSERT INTO nuj_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","ni Yahaza ni Kedemoosi ni Mefaasi ");
INSERT INTO nuj_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","ni Kiriyasayimu ni Sibbuma ni Zeresi Sakari ehiri hu lusozi olwomu hiiho ");
INSERT INTO nuj_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","ni Bbesi Pewori nʼamenamo gʼolusozi Pisiga ni Bbesi Yesimoosi. ");
INSERT INTO nuj_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","Ebyo njʼebibuga byosibyosi ebyomu hirafu ko nʼehitehere ehi Sihoni habaha wʼAbamooli gaŋuganga ni gehala e Hesibboni. Musa gaali amuŋanguuye era naŋanguuye nʼabatangirisi bʼe Midiyaani omwali Evi ni Rekemu ni Zuuri ni Huuri ni Rebba abayeedangaho habaha Sihoni ohuŋuga ebitehere ebyo. ");
INSERT INTO nuj_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","Mu abo abʼAbayisirayiri beeta, njʼomwali nʼomuŋeŋa oyu balanganga baati Bbalamu omusaani wa Bbewori. ");
INSERT INTO nuj_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","Olwabi Yoludaani njʼolwali esalo yʼomuŋuluko gwʼehiha hya Lubbeeni hu luuyi lwʼebugwalyuba. Ebibuga nʼebitehere ebyo njʼomuŋuluko ogu baŋa abʼehiha hya Lubbeeni ngʼolu endyo jaawe jaali. ");
INSERT INTO nuj_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","Musa gaŋa abʼehiha hya Gaadi omuŋuluko ngʼolu endyo jaawe jaali. ");
INSERT INTO nuj_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","Omuŋuluko gwawe gwaŋiriramo ehibuga hyʼe Yazeri nʼebibuga byosibyosi ebyomu Giliyaadi nʼehitundu ehyʼegwanga lyʼAbamooni ohwolera erala hu Aroweeri ebugwalyuba wa Raabba. ");
INSERT INTO nuj_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","Babaŋa ohuŋwa e Hesibboni ohwola hu Lamasi Mizupa ni Bbetonimu nindi ohuŋwera e Mahanayimu ohwola hu lwaha ni Lodebbaari. ");
INSERT INTO nuj_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","Babaŋa mu meeho ga Yoludaani ni Bbesi Haramu ni Bbesi Nimura ni Sukosi ni Zafoni nʼehitundu ehyali mu buŋugi wa Sihoni habaha wʼe Hesibboni. Esalo yaawe e bugwalyuba yaali lwabi Yoludaani ohwolera erala mu maniino, hwigenya lyʼenyanja Galilaaya. ");
INSERT INTO nuj_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","Ebibuga nʼebitehere ebyo njʼomuŋuluko ogu baŋa abʼehiha hya Gaadi ngʼolu endyo jaawe jaali. ");
INSERT INTO nuj_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","Musa gaŋa ehitundu hyʼabehiha hya Manase omuŋuluko ngʼolu endyo jaawe jaali. ");
INSERT INTO nuj_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","Etwale lyawe lyali lyola hu hibuga hyʼe Mahanayimu ni liŋiriramo ehyalo hyʼe Bbasani hyosihyosi ŋalala nʼebitehere byosibyosi enkaaga ebi Yayiri ganyaga mu twale eryo. Habaha Ogi owʼe Bbasani gaali aŋugireeho amatwale ago gosigosi. ");
INSERT INTO nuj_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","Hyaŋirirangamo ehitundu hyʼe Giliyaadi ŋalala nʼAsitaroosi nʼEdereeyi, ebibuga ebihulu ebyʼowahabaha wa Ogi e Bbasani. Ebyo byosibyosi babiŋa ehiha hya Makiri omusaani wa Manase ngʼolu endyo jaawe jaali. ");
INSERT INTO nuj_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","Ogwo njʼomuŋuluko ogu Musa gabaŋa nʼali ebuŋwalyuba wʼolwabi Yoludaani aŋaapi nʼe Mowaabbu ko nʼebuŋwalyuba wa Yeriko. ");
INSERT INTO nuj_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","Aye Musa sigaŋa abomu hiha hya Leevi omuŋuluko, Musengwa Hatonda wa Yisirayiri njʼomugabo gwawe ngʼolu gabasuubisa. ");
INSERT INTO nuj_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","Elyazaali omusengi wa Hatonda ni Yoswa omusaani wa Nuuni nʼabahulu bʼebiha bya Yisirayiri bagabira Abayisirayiri ebitehere mu hyalo hyʼe Kanani ebugwalyuba wa Yoludaani. Era bagabaniamo baati: ");
INSERT INTO nuj_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","ebiha omwenda nʼehitundu ebyʼAbayisirayiri babiŋa emiŋuluko ni bahubba ahalulu ngʼolu Musengwa galagira nʼabitira mu Musa. ");
INSERT INTO nuj_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","Musa gaali ahenire ohuŋa ebiha ebibiri nʼehitundu omuŋuluko gwawe ebuŋwalyuba wa Yoludaani aye nataŋaaye Baleevi muŋuluko. ");
INSERT INTO nuj_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","Mu hiseera ehyo, abomu lulyo lwa Yosefu baali bafuuhire ebiha bibiri, ehya Manase nʼehya Efulayimu. Eŋuma muŋuluko ogu baaŋa Abaleevi, aye babaŋa ebibuga ebyʼohumenyangamo nʼaŋohwayiranga ebyayo byawe. ");
INSERT INTO nuj_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","Abayisirayiri bagabana ebitehere ngʼolu Musengwa galagira Musa. ");
INSERT INTO nuj_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","Lulala abaatu ohuŋwa mu hiha hya Yuda batiina e Gilugaali eyi Yoswa gaali, nga Kalebbu omusaani wa Yefune Omukenizi aloma Yoswa ati, “Omanyire ehi Musengwa galoma Musa omuutu wa Hatonda e Kadesi Bbaruneya ebiŋamba hu ese ni neewe. ");
INSERT INTO nuj_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","Ni hwali e Kadesi Bbaruneya, Musa omuŋeeresa wa Musengwa aŋa gaatumira ohuheeta ehyalo hyʼe Kanani, naali pesa emyaha amahumi ane. Era namuŋirira amaŋuliro ngʼolu naali ni mbwene hyalo ehyo. ");
INSERT INTO nuj_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","Aye abahyange abanatiina ni nabo bagira abaatu baatya. Aye ese naholera hu bya Musengwa Hatonda wange nʼomwoyo mulala naloma ebituufu. ");
INSERT INTO nuj_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","Nga Musa gandayirira hu ludaalo olwo ati, ‘Ehyalo ehi magulu gago gemireho, hija huba muŋuluko gugwo nʼabaana babo emirembe nʼemirembe olwohuba obaaye mwesigwa eyiri Musengwa Hatonda wange.’ ");
INSERT INTO nuj_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","“Era ŋaahani ngʼolu Musengwa gasuubisa, gakuumire emyaha ane nʼetaanu ohuŋwera erala mu hiseera ehi Musengwa galomeramo ni Musa ebibono ebyo, Abayisirayiri ni balengalengera mu lulafu, ŋaahani pesa emyaha cinaana nʼetaanu. ");
INSERT INTO nuj_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","Era kiirimo amaani ngʼolu naali hu ludaalo olu Musa gaatumiraho. Kiiri nʼamaani ohusoola etalo era nʼohuhola ebiitu ebindi ngʼolu naali. ");
INSERT INTO nuj_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","Olwʼehyo ŋaahani pe ehitehere ehyo ehyʼesozi ehi Musengwa gasuubisa hu ludaalo olwo. Ewe wamwene weŋuliriraho nʼamatwi gago oti Abanaki njʼabaali ni bamenya eyo era ebibuga byawe bibbala ate bisitirire nʼolukomera. Aye Musengwa aja hunjeeda mbabbinge ngʼolu galoma.” ");
INSERT INTO nuj_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","Nga Yoswa asabira Kalebbu omusaani wa Yefune ekabi ngʼahena amuŋa ehibuga hyʼe Kebbulooni ohuba muŋuluko gugwe. ");
INSERT INTO nuj_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","Ohuŋwa hulwo nʼohwola hatyane, ehibuga Kebbulooni hyafuuha hya Kalebbu omusaani wa Yefune Omukenizi olwohuba gagondera Musengwa Hatonda wa Yisirayiri nʼomwoyo mulala. ");
INSERT INTO nuj_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","Konyo ehibuga hyʼe Kebbulooni hifuuhe hya Kalebbu, bahiranganga baati Kiriyaasi Arubba olwohuba Arabba njʼowaali nʼahira ohuba owʼamaani mu Banaki. Ngʼaŋo ehyalo hiŋuumula etalo. ");
INSERT INTO nuj_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","Abaatu bʼehiha hya Yuda basuna omuŋuluko ngʼolu endyo jaawe jaali. Omuŋuluko gwawe gwatiina ni guserengeta ohwola hu Edomu nga gutiina paka hu lulafu lwʼe Ziini oluli mu mehiriro. ");
INSERT INTO nuj_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","Olubibi mu mehiriro lwatandiihira mu mehiriro wʼEnyanja Eŋumamo Ehiramu, ");
INSERT INTO nuj_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","nga lubita mu Akurabbimu lwola mu lulafu lwʼe Ziini. Ngʼolubibi olwo luniinaniina luŋwa mu mehiriro gʼehibuga hyʼe Kadesi Bbaruneya. Nga lubita hu hibuga hyʼe Kezirooni lwola hu hibuga hyʼe Adari, nga lucuuha lubita hu hibuga hyʼe Kalika, ");
INSERT INTO nuj_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","nga lutiina hu hibuga hyʼe Azimooni nga luluŋama mu mwombe hu lubibi ni Misiri ohwolera erala hu nyanja Meditereniani. Olwo njʼolubibi lwʼomuŋuluko gwʼabaatu bʼehiha hya Yuda olwomu mehiriro. ");
INSERT INTO nuj_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","Enyanja Eŋumamo Ehiramu, njʼolubibi lwʼebuŋwalyuba ohwola hu njagamo yʼolwabi Yoludaani. Olubibi olwomu maniino lutandihira aŋo, ");
INSERT INTO nuj_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","nga lutiina ohwola e Bbesi Hogula nga lweyongerayo mu maniino gʼe Bbesi Arabba nga lutiina ohwola hwibaale lya Bbohani omusaani wa Lubbeeni. ");
INSERT INTO nuj_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","Ngʼolubibi olwo lubita lutiina hu hiiho ehyʼe Akori ohwola e Debbiri. Nga lucuuha luŋwa mu maniino lutiina e Gilugaali ohulengera Adumiimu engereha hu luuyi olwomu mehiriro gʼehiiho. Nga lweyongerayo ohwola hu maaji ga Eni Semesi nga lutulira Eni Rogeli. ");
INSERT INTO nuj_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","Ngʼaŋo olubibi olwo lubita mu hiiho hyʼe Bbeni Hinomu hu luuyi lwʼamehiriro gʼe Yerusaalemu, ehibuga hyʼAbayebbusi. Nga lubita ŋamugulu wʼolusozi oluli ebugwalyuba wʼehiiho ehi balanga baati Hinomu ehiri mu maniino wʼehiiho hyʼe Refayiimu. ");
INSERT INTO nuj_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","Ohuŋwa hu lusozi olwo, nga lutiina hu sulo jʼamaaji ga Nefutowa nga lwola hu bibuga ebyohu lusozi lwʼEfulooni. Ngʼaŋo lwiha lucuuha lwola hu hibuga hyʼe Bbaala aŋandi bahiranga baati Kiriyaasi Yeyariimu. ");
INSERT INTO nuj_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","Eyo peyi lwetololera ebugwalyuba wa Bbaala ohwola hu lusozi lwʼe Seyiri nga lubita mu maniino gʼolusozi lwʼe Yeyariimu olu balanga esiina erindi baati Kesaloni, nga lwihirira e Bbesi Semesi nga lutiina e Timuna. ");
INSERT INTO nuj_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","Olubibi olwo nga lutiina lwola mu maniino gʼolusozi Ekurooni nga luŋeta lwola hu hibuga hyʼe Sikerooni, nga lubita hu lusozi Bbaala nga lwola hu hibuga hyʼe Yabbineeli, nga luhoma hu nyanja Meditereniani. ");
INSERT INTO nuj_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","Ebugwalyuba wʼenyanja Meditereniani, njʼolwali olubibi. Ejo njʼejaali embibi jʼabaatu ba Yuda ngʼolu endyo jaawe jaali. ");
INSERT INTO nuj_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","Ngʼolu Musengwa galagira Yoswa, ehitundu hyʼetwale lyʼabaatu bʼehiha hya Yuda bahiŋa Kalebbu omusaani wa Yefune ohuŋwa mu hiha hya Yuda. Gasuna e Kebbulooni, ehibuga hya Kiriyaasi Arubba owaali sehulu wa Anaki. ");
INSERT INTO nuj_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","Kalebbu gabbinga abejuhulu ba Anaki mu hibuga hyʼe Kebbulooni. Abejuhulu ba Anaki abo abadatu ohuŋwa mu basaani baali nje: Sesayi ni Ahimani ko ni Talumayi. ");
INSERT INTO nuj_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","Ni gaŋwa eyo, ngʼalumba abomu hibuga hyʼe Debbiri, ahale hale ehi balanganga baati Kiriyaasi Seferi. ");
INSERT INTO nuj_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","Kalebbu galoma ati, “Omusinde oja hulumba ehibuga hyʼe Kiriyaasi Seferi gahiŋangula, nja humuŋa omuhaana wange Akusa abe muhasi wuwe.” ");
INSERT INTO nuj_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","Nga Osiniyeeli omusaani wa Kenazi muganda ya Kalebbu, alumba ehibuga ehyo ahiŋangula, nga Kalebbu amuŋa omuhaana wuwe Akusa afuuha muhasi wuwe. ");
INSERT INTO nuj_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","Hu ludaalo olu baholeraho embaga eyʼobufumbo, Osiniyeeli galoma Akusa asunge semwana amuŋe omuŋuluko. Akusa ni ganiinuha hu nasugirya yiye, nga Kalebbu amubuusa ati, “Wenda kuholere hi?” ");
INSERT INTO nuj_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","Nga Akusa amugobolamo ati, “Ŋaliŋo ehiitu ehyenjabulo ehi nenda wukolere. Ngʼolu waapa ehyalo ehyʼe Negevu, kusunga wuupe nʼesobere ejʼamaaji.” Nga Kalebbu amuŋa esobere ejʼomumanino nʼejomumenamo. ");
INSERT INTO nuj_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","Guno njʼomuŋuluko gwʼehiha hya Yuda ngʼolu endyo jaawe jaali: ");
INSERT INTO nuj_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","Ebibuga ebyʼendyo jʼabaatu bomu hiha hya Yuda, ebisemberayo erala mu mehiriro hu lubibi ni Edomu byali: Kabbuzeeli ni Ederi ni Yaguri ");
INSERT INTO nuj_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","ni Kina ni Dimona ni Adada ");
INSERT INTO nuj_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","ni Kedesi ni Hazori ni Yisinani ");
INSERT INTO nuj_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","ni Ziifu ni Telemu ni Bbeyaloosi ");
INSERT INTO nuj_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","ni Hazori Hadata ni Keriyoosi Kezirooni ehi balanga esiina erindi baati Hazori, ");
INSERT INTO nuj_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","ni Amamu ni Sema ni Molada ");
INSERT INTO nuj_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","ni Hazari Gaada ni Hesibboni ni Bbesi Peleti ");
INSERT INTO nuj_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","ni Hazari Suwaali ni Bberuseebba ni Bbiziyosiiya ");
INSERT INTO nuj_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","ni Bbaala ni Yimu ni Ezemu ");
INSERT INTO nuj_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","nʼElitoladi ni Kesili ni Horuma ");
INSERT INTO nuj_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","ni Zikilagi ni Madimana ni Sasaana ");
INSERT INTO nuj_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","ni Lebbawoosi ni Siluhiimu ni Ayini ni Rimooni. Ŋosiŋosi byali ebibuga abiri namwenda nʼebitehere ebibyeswanigirihiise. ");
INSERT INTO nuj_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","Ebibuga ebyomu hyalo hyʼebugwalyuba ehyʼesozi byali: Esitawooli ni Zoora ni Asina ");
INSERT INTO nuj_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","ni Zanowa ni Eni Ganiimu ni Tapuwa ni Enamu ");
INSERT INTO nuj_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","ni Yarumusi nʼAdulamu ni Sooko ni Azeka ");
INSERT INTO nuj_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","ni Sarayiimu nʼAdisayiimu ni Gedera ehi balanga erindi baati Gederosayiimu. Ŋalala byali ebibuga ehumi nabine nʼebitehere ebibyeswanigirihiise. ");
INSERT INTO nuj_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","Ŋaaliŋo nʼebibuga Zenani ni Hadasa ni Migidalo Gaadi ");
INSERT INTO nuj_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","ni Dileyaani ni Mizupa ni Yokoseeli ");
INSERT INTO nuj_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","ni Lakisi ni Bbozikasi nʼEgulooni ");
INSERT INTO nuj_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","ni Kabboni ni Lahimaasi ni Kitilisi ");
INSERT INTO nuj_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","ni Gederoosi ni Bbesi Dagoni ni Naama ni Makeda. Ŋosiŋosi ebibuga byali ehumi namukaaga nʼebitehere ebibyeswanigirihiise. ");
INSERT INTO nuj_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","Era ŋaaliŋo nʼebibuga Libbuna ni Eteri ni Asani ");
INSERT INTO nuj_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","ni Yifuta ni Asina ni Nezibbu ");
INSERT INTO nuj_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","ni Keyila ni Akuzibbu ni Maresa. Ŋosiŋosi ebibuga byali mwenda nʼebitehere ebibyeswanigirihiise. ");
INSERT INTO nuj_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","Etwale lyʼehiha hya Yuda lyali liŋiriramo ehibuga Ekurooni ko nʼebitehere ebibyeswanigirihiise. ");
INSERT INTO nuj_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","Ohuŋwa Ekurooni olwaha lwatiina ebugwalyuba nga luŋiriramo ebibuga ebirireene Asidodi nʼebitehere ebibyeswanigirihiise. ");
INSERT INTO nuj_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","Mwaŋiriramo Asidodi nʼebitehere ebibyeswanigirihiise taaho ni Gaaza nʼebitehere ebibyeswanigirihiise. Nga lutiina ohwola hu mwombe oguli hu salosalo ni Misiri paka hwigenya lwʼenyanja Meditereniani. ");
INSERT INTO nuj_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","Mu hyalo ehyʼesozi mwalimo ebibuga Samiri, Yatiri, ni Sooko ");
INSERT INTO nuj_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","ni Daana ni Kiriyaasi Saana ehi balanga esiina erindi baati Debbiri ");
INSERT INTO nuj_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","ni Anabbu ni Esutemo ni Animu ");
INSERT INTO nuj_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","ni Goseni ni Koloni ni Giilo. Ŋosiŋosi byali ebibuga ehumi nahirala nʼebitehere ebibyeswanigirihiise. ");
INSERT INTO nuj_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","Ŋaaliŋo ebibuga Arabbu ni Duma ni Esani ");
INSERT INTO nuj_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","ni Yanimu ni Bbesi Tapuwa ni Afeka ");
INSERT INTO nuj_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","ni Humuta ni Kiriyaasi Arubba ehi balanga esiina erindi baati Kebbulooni ni Ziyori. Ŋosiŋosi byali ebibuga mwenda nʼebitehere ebibyeswanigirihiise. ");
INSERT INTO nuj_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","Ŋaaliŋo ebibuga Mawoni ni Karumeeli ni Ziifu ni Yuuta ");
INSERT INTO nuj_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","ni Yezireeli ni Yokudeyaamu ni Zanowa ");
INSERT INTO nuj_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","ni Kayini ni Gibbeya ni Timuna. Ŋosiŋosi byali ebibuga ehumi nʼebitehere ebibyeswanigirihiise. ");
INSERT INTO nuj_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","Ŋaaliŋo ebibuga Halihuli ni Bbesi Zuuri ni Gedori ");
INSERT INTO nuj_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","ni Maarasi ni Bbesi Anoosi nʼElitekooni. Ŋosiŋosi byali ebibuga mukaaga nʼebitehere ebibyeswanigirihiise. ");
INSERT INTO nuj_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","Ŋaaliŋo ebibuga Kiriyaasi Bbaali ehi balanga esiina erindi baati Kiriyaasi Yeyariimu ni Raabba, ŋosiŋosi byali ebibuga bibiri nʼebitehere ebibyeswanigirihiise. ");
INSERT INTO nuj_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","Mu lulafu yaaliyo Bbesi Arabba ni Midini ni Sekaka ");
INSERT INTO nuj_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","ni Nibbusani nʼehibuga ehyʼOmunyu ni Eni Geedi. Ŋosiŋosi byali ebibuga mukaaga nʼebitehere ebibyeswanigirihiise. ");
INSERT INTO nuj_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","Aye abaatu bʼehiha hya Yuda sibasobola hubbinga Bayebbusi abaali ni bamenya e Yerusaalemu. Era nʼohwola hatyane bamenya ŋalala ni nabo mu Yerusaalemu. ");
INSERT INTO nuj_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","Olubibi lwʼomuŋuluko ogu baaŋa abomu lulyo lwa Yosefu lwatandiihira mu mehiriro wʼolwabi Yoludaani ohuupi nʼehibuga Yeriko ebuŋwalyuba wʼesobere jʼe Yeriko, nga lutiina mu lulafu ohwola e Bbeseeri mu hyalo ehyʼesozi. ");
INSERT INTO nuj_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","Ohuŋwa e Bbeseeri lwatiina e Luuzi, nga lusala lutiina mu hitehere hyʼe Ataroosi Adaali eyi Abaruki bamenyanga. ");
INSERT INTO nuj_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","Nga luŋwa eyo lwihirira ebugwalyuba wʼAbayafuleeti nga lwihirira ohwola mu hitundu hya Bbesi Horoni ehya ŋaasi. Nga lwola e Gezeri nga luhoma hu nyanja Meditereniani. ");
INSERT INTO nuj_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","Ogwo njʼomuŋuluko ogu baaŋa abejuhulu ba Yosefu mu biha ebibiri, ehya Manase nʼehya Efulayimu. ");
INSERT INTO nuj_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","Omuŋuluko gwʼabehiha hya Efulayimu ngʼolu endyo jaawe jaali gwali guuti: olubibi lwʼomuŋuluko gwawe lwali luŋwa e Ataroosi Adari hu luuyi olwʼebuŋwalyuba ohwola hu Bbesi Horoni ehya ŋamugulu, ");
INSERT INTO nuj_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","nga lutiina lwehoonya hu nyanja Meditereniani. Ohuŋwa e Mikimesasi mu maniino, lwatiina e buŋwalyuba ohwola e Tanasi Siilo nga lusala lutiina e Yanowa hu luuyi olwʼebuŋwalyuba. ");
INSERT INTO nuj_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","Nga lwihirira ohuŋwa e Yanowa ohutiina Ataroosi ni Naara, nga lwehoonya e Yeriko lwibbuhira hu lwabi Yoludaani. ");
INSERT INTO nuj_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","Ohuŋwa e Tapuwa lwatiina ebugwalyuba hu lwabi Kaana nga luhoma hu nyanja Meditereniani. Ogwo njʼogwali omuŋuluko gwʼabehiha hya Efulayimu ngʼolu endyo jaawe jaali. ");
INSERT INTO nuj_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","Abaatu bʼehiha hya Efulayimu basuna ebibuga nʼebitehere ebyali mu muŋuluko gwʼabehiha hya Manase. ");
INSERT INTO nuj_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","Aye sibabbinga Bakanani abaali ni bamenya e Gezeri. Era nʼohwola hatyane Abakanani bahimenya ŋalala nʼAbefulayimu aye bafuuha beedu ohutambiranga Abefulayimu emirimo. ");
INSERT INTO nuj_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","Guno njʼogwali omuŋuluko gwa Manase omwana wa Yosefu omudaayi. Makiri semwana wa Giliyaadi era omusaani wa Manase omudaayi gaali haŋunye mu husoola etalo, bamuŋa Giliyaadi ni Bbasani ebuŋwalyuba wa Yoludaani. ");
INSERT INTO nuj_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","Omuŋuluko ogwali ebugwalyuba wa Yoludaani baguŋa abejuhulu ba Manase abandi, abaseere abaali ni basigaaye. Era mu bejuhulu abo njʼomwali olulyo lwa Abbiyezeeri nʼolwa Heleki nʼolwa Asiriyeeli nʼolwa Sekemu nʼolwa Heferi nʼolwa Semida. ");
INSERT INTO nuj_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","Zelofehaadi omusaani wa Heferi omusaani wa Giliyaadi omusaani wa Makiri, Makiri omusaani wa Manase, sigasaala hu mwana omuseere aye gasaala bahaana boŋene. Amasiina gaawe baali nje Mahula ni Noowa ni Hogula ni Mirika ko ni Tiruza. ");
INSERT INTO nuj_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","Abahaana abo batiina eyiri Elyazaali omusengi ni Yoswa omusaani wa Nuuni nʼabatangirisi, nga babaloma baati, “Musengwa galagira Musa batuŋe omuŋuluko hyʼabalebe beefe abasinde.” Olwʼehyo Yoswa gaabaŋa omuŋuluko ŋalala nʼabalebe baawe abasinde ngʼolu Musengwa galagira. ");
INSERT INTO nuj_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","Emiŋuluko eji Manase gaasuna jaali emigabo ehumi nga ko ogataho Giliyaadi ni Bbasani ebuŋwalyuba wa Yoludaani ");
INSERT INTO nuj_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","olwohuba abejuhulu babe abahaana nʼabaseere basuna omuŋuluko. Omuŋuluko gwomu twale lyʼe Giliyaadi gwali gwʼabejuhulu ba Manase abandi bosibosi. ");
INSERT INTO nuj_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","Etwale lyʼabehiha hya Manase lyali liŋwa hu hiha hya Aseri ohwola hu Mikimesasi ebuŋwalyuba wa Sekemu. Ngʼolubibi lutiina mu mehiriro luŋambiramo abaatu be Eni Tapuwa. ");
INSERT INTO nuj_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","Hu lubibi ŋagati wʼetwale lyʼabehiha hya Manase nʼehiha hya Efulayimu ŋaaliŋo ehibuga hyʼe Tapuwa. Ehibuga ehyo hyali hyʼabomu hiha hya Efulayimu aye omuŋuluko ohweswanigirisa gwali gwʼabehiha hya Manase. ");
INSERT INTO nuj_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","Olubibi lweyongera lwola mu mehiriro hu mwombe ogu balanga baati Kaana. Ebibuga mu mehiriro gʼolwabi olwo byali bya bomu hiha hya Efulayimu wayire nga byali mu twale lyʼabehiha hya Manase. Olubibi olwo, lweyongera lwatiina mu maniino gʼomwombe ogwo nga lwola hu nyanja Meditereniani. ");
INSERT INTO nuj_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","Mu mehiriro, omuŋuluko gwali gwʼabehiha hya Efulayimu aye mu maniino gwali gwʼabehiha hya Manase. Etwale lyʼabehiha hya Manase lyatiina lyola hu nyanja Meditereniani lyabuhana nʼabehiha hya Aseri mu maniino. Ne hu luuyi lwʼebuŋwalyuba lyabuhana nʼabehiha hya Yisikaali. ");
INSERT INTO nuj_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","Mu matwale gʼabehiha hya Yisikaali nʼabehiha hya Aseri, Manase bamuŋayo ehibuga hyʼe Bbesi Saani ni Yibbuleyamu nʼabaatu bomu Doori ehi balanga esiina erindi baati Nafasi ni Endori ni Tanaki ni Megido nʼebyalo ebibyeswanigirihiise. ");
INSERT INTO nuj_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","Aye abaatu bʼehiha hya Manase sibasobola hubbinga Bakanani mu bibuga ebyo olwʼehyo beyongera ohubimenyamo. ");
INSERT INTO nuj_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","Ehiseera hyola Abayisirayiri basuna amaani nga bafuula Abakanani abo beedu baawe ohubatambiranga emirimo aye sibababbingiramo erala. ");
INSERT INTO nuj_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","Lulala abejuhulu ba Yosefu batiina eyiri Yoswa bamuloma baati, “Lwahiina sotumeedaho omuŋuluko ogundi? Musengwa atuŋaaye ekabi hwalire era huli bangi bugali ohumenya mu haloba hano ahadidiri.” ");
INSERT INTO nuj_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","Nga Yoswa abagobolamo ati, “Ehyalo hyʼabehiha hya Efulayimu ehyʼesozi hinaba ni hitabahena olwohuba muli bangi, mutiine mu hibira ehyʼAbapereezi nʼAbareefa musaaŋe mumenye eyo.” ");
INSERT INTO nuj_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","Nga abejuhulu ba Yosefu bamugobolamo baati, “Ehyalo ehyʼesozi sihituhena humenyamo aye Abakanani abamenya mu hifo ehiduleere nʼabamenya mu hibuga hyʼe Bbesi Saani nʼebibuga ebibyeswanigirihiise nʼabali mu hiiho hyʼe Yezireeli, bosibosi bali nʼebigaali ebyʼebyoma ohutambisa mu lutalo.” ");
INSERT INTO nuj_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","Nga Yoswa abaloma ati, “Muli bangi bugali era bʼamaani. Simuja husuna mugabo mulala gwonyene. ");
INSERT INTO nuj_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","Ehyalo hyosihyosi ehyʼesozi hija huba hyenywe. Wayire hijuuye amadeŋo aye muuja huhisaaŋa, hibe hyenywe ohuŋwa hu sonda ohwola hu sonda eyindi. Era muja hubbinga Abakanani wayire bʼamaani era bali nʼebigaali ebyʼebyoma.” ");
INSERT INTO nuj_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","Lulala, Abayisirayiri ni bahena ohuŋamba ehyalo nga bosibosi bahumbaanira mu hibuga hyʼe Siilo nga beemeha eweema eyʼOhwagananirangamo. ");
INSERT INTO nuj_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","Mu Bayisirayiri, mwali muhiirimo ebiha musanvu ebyali ni bihiiri husuna miŋuluko. ");
INSERT INTO nuj_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","Nga Yoswa aloma Abayisirayiri ati, “Mulyosa ŋeena ohubererera aŋo ni muhiiri husuna loba eri Musengwa Hatonda wʼabasehulu benywe gabaŋa? ");
INSERT INTO nuj_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","Mutobole abasinde badatu badatu ohuŋwa mu hiisi hiha, mbatume batiine baheete bahene baleete eripooti eŋamba hu hyalo ehi bahendire ohuŋira, ni bahena bagobole ŋano bandomere. ");
INSERT INTO nuj_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","Muja ohwabula mu hyalo ehyo emiŋuluko musanvu. Abʼehiha hya Yuda baja husigala mu twale lyawe mu mehiriro, nʼabebiha bya Yosefu babe mu twale lyawe mu maniino. ");
INSERT INTO nuj_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","Ni muhena ohuŋandiiha ngʼolu emiŋuluko ejo omusanvu jiri nʼohuba, mundeetere eripooti eyo, nja hwebuusa hu Musengwa Hatonda weefe ehyʼohuhola. ");
INSERT INTO nuj_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","Aye Abaleevi sibaja husuna muŋuluko hyenywe olwohuba omugabo gwawe njʼohuba basengi ba Musengwa. Abʼehiha hya Gaadi nʼehya Lubbeeni ko nʼehitundu hyʼehiha hya Manase, baahena hale ohubaŋa emiŋuluko ebuŋwalyuba wa Yoludaani. Musa omuŋeeresa wa Musengwa gabaŋa omuŋuluko gwawe.” ");
INSERT INTO nuj_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","Abasinde abo ko basimbuhe ohutiina, Yoswa gabalagira ati, “Mutiine mweheneenye ehyalo ehyo, muŋandiihe ebihifaho mugobole ŋano e Siilo, nja huhubba ahalulu ni nebuusa hu Musengwa.” ");
INSERT INTO nuj_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","Ngʼabasinde abo batiina betoloola mu hyalo ehyo nga baŋandiiha eripooti hu hiisi hibuga ehyali mu miŋuluko omusanvu ejo. Ni baahena nga baagama e Siilo mu kambi eyiri Yoswa. ");
INSERT INTO nuj_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","Nga Yoswa ahubba ahalulu ni gebuusa hu Musengwa e Siilo. Era ngʼagabira Abayisirayiri emiŋuluko abaali ni bahiiri husuna. ");
INSERT INTO nuj_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","Ehiha hya Bbenjamini njʼehyali ehidaayi ohusuna omuŋuluko era etwale lyawe lyali ŋagati wʼabaatu ba Yuda mu mehiriro nʼabaatu ba Yosefu mu maniino. ");
INSERT INTO nuj_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","Mu maniino, olubibi lwatandiihira hu lwabi Yoludaani, nga lubita mu hiinamo hyʼe Yeriko mu maniino nga lusimba ebugwalyuba lutulira mu hyalo ehyʼesozi mu lulafu lwe Bbesi Aveni. ");
INSERT INTO nuj_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","Ohuŋwa eyo ngʼalusala lutiina mu mehiriro mu hiinamo hyʼe Luuzi ehi balanga baati Bbeseeri, nga lwihirira e Ataroosi Adari hu lusozi oluli mu mehiriro gʼe Bbesi Horoni ehya ŋaasi. ");
INSERT INTO nuj_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","Ohuŋwa hu lusozi olulengereeye Bbesi Horoni mu mehiriro, olubibi olwo ngʼaluŋetera mu mehiriro ohutiina ebugwalyuba nga lugwihisa e Kiriyaasi Bbaali ehi balanga baati Kiriyaasi Yeyariimu, ehibuga hyʼabaatu bomu hiha hya Yuda. Olwo njʼolwali olubibi olwʼebugwalyuba. ");
INSERT INTO nuj_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","Olubibi mu mehiriro lwatandiihira hu salo ni Kiriyaasi Yeyariimu ebugwalyuba nga lwiguhira hu sobere eyi balanga baati Nefutowa. ");
INSERT INTO nuj_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","Nga lwihirira ŋaasi wʼolusozi olulengereeye ehiiho hyʼe Bbeni Hinomu mu maniino wʼehiiho hyʼe Refayiimu. Nga lweyongerayo lwihirira mu hiiho hya Hinomu mu mehiriro mu hiinamo hyʼehibuga hyʼAbayebbusi nga lwola Eni Rogeli. ");
INSERT INTO nuj_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","Ngʼaluŋetera mu maniino lutiina Eni Semesi, nga lweyongera e Geliloosi ohulengerera engira eyi tiina e Adumiimu, nga lwihirira hwibaale lya Bbohani omusaani wa Lubbeeni. ");
INSERT INTO nuj_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","Era nga lweyongerayo lubita mu hiinamo hya Bbesi Arabba mu maniino nga nindi lwihirira mu hiiho hyʼe Yoludaani. ");
INSERT INTO nuj_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","Ngʼaŋo nindi lutiina mu hiiho hyʼe Bbesi Hogula mu maniino nga lutulira hu hiiho ehyomu maniino wʼEnyanja Eŋumamo Ehiramu hwigobo lyʼolwabi Yoludaani hu luuyi lwe mehiriro. Olwo njʼolwali olubibi lwomu mehiriro. ");
INSERT INTO nuj_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","Olwabi Yoludaani njʼolwali olwaha hu luuyi olwʼebuŋwalyuba. Ejo njʼembibi ejabula omuŋuluko gwʼabaatu ba Bbenjamini hu njuyi josijosi ngʼolu endyo jaawe jaali. ");
INSERT INTO nuj_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","Ehiha hya Bbenjamini ohusiziira hu endyo jaawe babaŋa ebibuga bino: Yeriko ni Bbesi Hogula ni Emeki Kezizi ");
INSERT INTO nuj_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","ni Bbesi Arabba ni Zemarayimu ni Bbeseeri ");
INSERT INTO nuj_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","ni Avimu ni Paara ni Ofura ");
INSERT INTO nuj_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","ni Kefari Amooni ni Ofuni ni Geebba. Ŋalala byali ebibuga ehumi nabibiri nʼebitehere ebibyeswanigirihiise. ");
INSERT INTO nuj_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","Etwale erindi erya Bbenjamini mwalimo ebibuga bino: Gibbyoni ni Raama ni Bbeerosi ");
INSERT INTO nuj_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","ni Mizupa ni Kefira ni Mooza ");
INSERT INTO nuj_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","ni Rekemu ni Yirupeeli ni Taraala ");
INSERT INTO nuj_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","ni Zeela ni Helefu ni Yebbusi ehi balanga esiina erindi baati Yerusaalemu ni Gibbeya ni Kiriyaasi Yeyariimu. Ŋalala ebibuga byali ehumi nabine nʼebitehere byabyo. Ogwo njʼogwali omuŋuluko gwʼabaatu ba Bbenjamini ngʼolu endyo jaawe jaali. ");
INSERT INTO nuj_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","Abʼehiha hya Simyoni njʼabaali obohubiri ohusuna omuŋuluko ngʼolu endyo jaawe jaali. Omuŋuluko gwawe gwali ŋagati bomu muŋuluko gwʼabaatu ba Yuda. ");
INSERT INTO nuj_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","Etwale eryo lyalimo ebibuga: Bberuseebba ni Seebba ni Molada ");
INSERT INTO nuj_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","ni Hazari Suwaali ni Bbaala ni Ezemu ");
INSERT INTO nuj_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","ni Elitoladi ni Bbesuli ni Horuma ");
INSERT INTO nuj_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","ni Zikilagi ni Bbesi Marikabboosi ni Hazari Suusa ");
INSERT INTO nuj_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","ni Bbesi Lebbawoosi ko ni Sarukeni. Ŋalala byali ebibuga ehumi nabidatu nʼebitehere ebibyeswanigirihiise. ");
INSERT INTO nuj_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","Ŋaaliŋo ni Ayini ni Rimooni ni Eteri ni Asani. Ŋalala ebibuga bine nʼebitehere byabyo. ");
INSERT INTO nuj_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","Etwale lya Simyoni lyosi lyali liŋira Bbalasi Bbeera ehi balanga esiina erindi baati Raama ehyomu mehiriro. Ogwo njʼomuŋuluko ogu bʼehiha hya Simyoni basuna ngʼolu endyo jaawe jaali. ");
INSERT INTO nuj_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","Omuŋuluko ogu baaŋa abʼehiha hya Simyoni bagwabula hu muŋuluko ogu baaŋa abʼehiha hya Yuda olwohuba baali basunire mubbala bugali. ");
INSERT INTO nuj_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","Abʼehiha hya Zebbulooni njʼabaali abohudatu ohusuna omuŋuluko ngʼolu endyo jaawe jaali. Omuŋuluko ogu basuna gwali gwolera erala hu hibuga hyʼe Saridi. ");
INSERT INTO nuj_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","Ngʼetwale eryo liruŋama ebugwalyuba ohwola e Marali ohwehoonya hu hibuga hyʼe Dabbesesi nohu haabi ahaali ebuŋwalyuba wʼehibuga hyʼe Yokuneyaamu. ");
INSERT INTO nuj_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","Hu luuyi lwʼebuŋwalyuba wʼehibuga hyʼe Saridi, olubibi lwatiina ebuŋwalyuba ohwola hu salo nʼehibuga hyʼe Kisuloosi Tabbori ohwola hu hibuga hyʼe Dabberaasi, nga luniina ohwola hu hibuga hyʼe Yafiya. ");
INSERT INTO nuj_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","Nga lweyongerayo ebuŋwalyuba ohwola hu hibuga hyʼe Gaasi Heferi ni Esi Kazini nga lutulira hu hibuga hyʼe Rimooni nga lucuuha lutiina lwola hu hibuga hyʼe Neeya. ");
INSERT INTO nuj_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","Ohuŋwa aŋo nga lutiina lwetoloola mu maniino lwola hu hibuga hyʼe Hanasoni ngʼaluhoma mu hiiho hyʼe Yifuta Eli. ");
INSERT INTO nuj_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","Etwale lyawe lyaŋiriramo nʼebibuga byʼe Katasi ni Nahalaali ni Simurooni ni Yidala ni Bbeserekemu. Ŋalala ebibuga ehumi nabibiri nʼebitehere ebibyeswanigirihiise. ");
INSERT INTO nuj_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","Ebibuga ebyo nʼebitehere byabyo njʼebyali omuŋuluko ogwʼabaatu bʼehiha hya Zebbulooni ngʼolu endyo jaawe jaali. ");
INSERT INTO nuj_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","Abʼehiha hya Yisikaali njʼabaali abohune ohusuna omuŋuluko ngʼolu endyo jaawe jaali. ");
INSERT INTO nuj_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","Etwale lyawe lyaŋiriramo ebibuga bino: Yezireeli ni Kesuloosi ni Sunemu ");
INSERT INTO nuj_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","ni Hafarayimu ni Siyooni ni Anaharasi ");
INSERT INTO nuj_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","ni Rabbisi ni Kisiyooni ni Ebbezi ");
INSERT INTO nuj_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","ni Remesi ni Eni Ganiimu ni Eni Hada ko ni Bbesi Pazezi. ");
INSERT INTO nuj_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","Olubibi lwaŋambiramo Tabbori ni Sahasuma ni Bbesi Semesi nga luhoma hu Yoludaani. Ebibuga byali ehumi namukaaga nʼebitehere abyali ni bibyeswanigirihiise. ");
INSERT INTO nuj_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","Ebibuga ebyo nʼebitehere ebibyeswanigirihiise njʼebyali omuŋuluko ogwʼabaatu bʼehiha hya Yisikaali ngʼolu endyo jaawe jaali. ");
INSERT INTO nuj_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","Abʼehiha hya Aseri njʼabaali abohutaanu ohusuna omuŋuluko ngʼolu endyo jaawe jaali. ");
INSERT INTO nuj_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","Etwale lyawe lyaŋiriramo ebibuga bino: Helukasi ni Hali ni Bbeteni ni Akusafu ");
INSERT INTO nuj_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","ni Alamu Meleki ni Amadi ni Misali. Ebugwalyuba olubibi lwali lwehoonya hu Karumeeli ni Sihori Libbunasi. ");
INSERT INTO nuj_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","Nga lucuuhira ebuŋwalyuba lwola e Bbesi Dagoni lutiina lwehoonya hu twale lyʼabehiha hya Zebbulooni nohu hiiho hyʼe Yifuta Eli. Nga luŋwa eyo lutiina mu maniino ga Bbesi Emeki ni Neyeli. Nga lubita e Kabbuli hu luuyi lwʼomuhono omugooda. ");
INSERT INTO nuj_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","Nga lutiina Ebbulooni ni Rehobbu ni Hamoni ni Kaana nga lwola e Sidoni ehibuga ehibbala. ");
INSERT INTO nuj_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","Nga olubibi luŋeta luluŋama e Raama nga lutiina mu hibuga Tiiro ehibagadiriraho ehiteepe, ngʼaluŋeta lutiina luluŋama e Hoosa nga lwibbuhira hu nyanja Meditereniani mu twale lyʼAkuzibbu ");
INSERT INTO nuj_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","ni Wuma ni Afeki ni Rehobbu. Byali ebibuga mahumi abiri nabibiri hiisi hibuga ni hiri mu hitehere hyahyo. ");
INSERT INTO nuj_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","Ebibuga ebyo nʼebitehere byawaho njʼebyali omuŋuluko gwʼabaatu bʼehiha hya Aseri ngʼolu endyo jaawe jaali. ");
INSERT INTO nuj_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","Abʼehiha hya Nafutaali njʼabaali abomukaaga ohusuna omuŋuluko ngʼolu endyo jaawe jaali. ");
INSERT INTO nuj_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","Olubibi lwawe mu maniino lwaŋwa e Helefu nohu mutumba omubba ogwʼe Zananiimu nga lubita hu Adami Nekebbu nomu Yabbineeli lwola e Lakumu nga luhoma hu lwabi Yoludaani. ");
INSERT INTO nuj_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","Nga luŋwa eyo lutiina ebugwalyuba lubita mu Azunoosi Tabbori nga lwibbuhira e Hukoki. Lwehoonya hu twale lyʼabehiha hya Zebbulooni mu mehiriro nohu twale lya bomu hiha hya Aseri hu luuyi lwʼebugwalyuba, nohu lwabi Yoludaani hu luuyi lwʼebuŋwalyuba. ");
INSERT INTO nuj_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","Ebibuga ebi baali ni bagadiriiyeho ebiteepe ohubyeswanigirisa byali: Zidimu ni Zeri ni Hamasi ni Rakasi ni Kinereesi ");
INSERT INTO nuj_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","ni Adama ni Raama ni Hazori ");
INSERT INTO nuj_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","ni Kedesi ni Edereeyi ni Eni Hazori ");
INSERT INTO nuj_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","ni Yirooni ni Migudali Eli ni Horemu ni Bbesi Anaasi ni Bbesi Semesi. Byali ebibuga ehumi namwenda hiisi hibuga ni hiri mu hitehere hyahyo. ");
INSERT INTO nuj_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","Ebibuga ebyo nʼebitehere byabyo njʼebyali omuŋuluko ogwʼabaatu bʼehiha hya Nafutaali ngʼolu endyo jaawe jaali. ");
INSERT INTO nuj_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","Abʼehiha hya Daani njʼabaali abomusanvu ohusuna omuŋuluko ngʼolu endyo jaawe jaali. ");
INSERT INTO nuj_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","Etwale lyʼomuŋuluko gwawe lyalimo ebibuga bino: Zoora ni Esitawooli ni Yiru Semesi ");
INSERT INTO nuj_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","ni Salabbiini ni Ayijalooni ni Yisila ");
INSERT INTO nuj_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","ni Eloni ni Timuna ni Ekurooni ");
INSERT INTO nuj_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","ni Eluteke ni Gibbesooni ni Bbalasi ");
INSERT INTO nuj_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","ni Yekudi ni Bbene Bberaki ni Gaasi Rimooni, ");
INSERT INTO nuj_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","ni Meyarikooni ni Rakoni ko nʼehitundu ehirengereeye Yoopa. ");
INSERT INTO nuj_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","Abasigu ni batusa hu baatu bʼehiha hya Daani etwale lyawe, baniinaniina batiina bawaagala ehibuga hyʼe Lesemu beeta abaatu baamo nga begobosaho ehibuga ehyo. Bamenya mu Lesemu era ehibuga ehyo bahitaho esiina baati Daani eryali esiina lya sehulu yaawe. ");
INSERT INTO nuj_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","Ebibuga ebyo nʼebitehere byabyo njʼebyali omuŋuluko ogwʼabaatu bʼehiha hya Daani ngʼolu endyo jaawe jaali. ");
INSERT INTO nuj_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","Abayisirayiri ni bahena ohusuna emiŋuluko jaawe, nga baŋa Yoswa omusaani wa Nuuni omuŋuluko ");
INSERT INTO nuj_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","ngʼolu Musengwa gaali nʼalagiiye. Bamuŋa ehibuga ehi gasunga ehyʼe Timunasi Seera ehyali mu hyalo ehyʼabehiha hya Efulayimu ehyʼesozi. Ngʼatongola ehibuga ehyo bunyaaha ngʼamenyamo. ");
INSERT INTO nuj_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","Ago njʼamatwale aga Elyazaali omusengi wa Hatonda ni Yoswa omusaani wa Nuuni nʼabatangirisi bʼebiha bya Yisirayiri bagaba ni bahubba ahalulu e Siilo mu moni ja Musengwa ŋa mulyango gwʼEweema eyʼOhwagananirangamo. ");
INSERT INTO nuj_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","Ebyo ni byaŋwa, nga Musengwa aloma Yoswa ati, ");
INSERT INTO nuj_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","“Loma Abayisirayiri batobole ebibuga ebyʼohweŋogomamo ngʼolu nabalagira ni mbita mu Musa. ");
INSERT INTO nuj_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","Omuutu onaabenga ni geetire owahye nʼatagendereeye, anadulumirenga omwo ohuŋunuha oyo amwendula ohwegalula. ");
INSERT INTO nuj_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","Nʼanadulumenga gatiina mu hirala hu bibuga ebyo, anasookenga hwemeerera ŋa mulyango ogwingira mu hibuga ehyo, nga geromaho mu moni jʼabatangirisi bʼehibuga ehyo. Aŋo abatangirisi banahejenga mu songa nga ko bamufugiirira ohwingira nga bamusunira ehifo ehyʼohumenyamo. ");
INSERT INTO nuj_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","Oyo omwendula ohumwegalula anatiinayo nʼamuŋiima, abatangirisi bʼehibuga ehyo sibamuŋangayo olwohuba sigagenderera humwita era gaali amuŋumaho busungu. ");
INSERT INTO nuj_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","Owiita owahye anasigalenga mu hibuga omwo ohwola olu banamuleetenga bamwemeha mu luhumbaano lwʼabaatu bomu hibuga ohumuŋosesya ngʼahena aba omwo ohwola olu muhulu wʼabasengi ba Hatonda aliho mu hiseera ehyo alifa nga ko gagamayo ewuwe mu hibuga hyʼewawe eyi gadulumamo.” ");
INSERT INTO nuj_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","Nga batobola ehibuga Kedesi mu twale lyʼe Galilaaya mu hyalo ehyʼabehiha hya Nafutaali ehyʼesozi, nʼehibuga hyʼe Sekemu mu hyalo ehyʼabehiha hya Efulayimu ehyʼesozi, nʼehibuga Kiriyaasi Arubba ehi balanga esiina erindi baati Kebbulooni mu hyalo ehyʼabehiha hya Yuda ehyʼesozi. ");
INSERT INTO nuj_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","Ebuŋwalyuba wʼolwabi Yoludaani hu luuyi nʼoŋwa e Yeriko, nga batobola ehibuga hyʼe Bbezeri mu twale lyʼehiha hya Lubbeeni mu lulafu aŋwagwalaali, nʼehibuga hyʼe Ramosi mu twale lyʼe Giliyaadi eryʼabehiha hya Gaadi, nʼehibuga hyʼe Golani mu Bbasani ehyʼabehiha hya Manase. ");
INSERT INTO nuj_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","Ebyo njʼebibuga ebyʼohweŋogomamo ebi batobolera Omuyisirayiri oba omugwira amenya ni nabo, byaba byahudulumirangamo oyo aba ni getire owahye nʼatagendereeye ko ŋatabaŋo amwegalula ni batasokire hu mwemeha geŋosyeho mu luhumbaano lwʼabaatu. ");
INSERT INTO nuj_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","Abatangirisi bʼamago gʼabehiha hya Baleevi, batiina eyiri Elyazaali omusengi wa Hatonda nʼeyiri Yoswa omusaani wa Nuuni ko nʼeyiri abatangirisi bʼebiha bya Yisirayiri ");
INSERT INTO nuj_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","e Siilo mu hyalo hyʼe Kanani nga babaloma baati, “Musengwa galagira nʼabita mu Musa ohutuŋa ebibuga ebyʼohumenyamo nʼaŋohwayiranga ebyayo byefe.” ");
INSERT INTO nuj_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","Olwʼehyo ngʼAbayisirayiri baŋa Abaleevi ebibuga nʼaŋohwayiranga mu miŋuluko jaawe ngʼolu Musengwa gaali nʼalagiiye. ");
INSERT INTO nuj_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","Abʼolulyo lwa Kohasi ohuŋwa mu hiha hyʼAbaleevi, njʼabaali abadaayi ohusuna omuŋuluko. Abaleevi abo abejuhulu ba Alooni basuna ebibuga ehumi nabidatu mu matwale gʼabomu hiha hya Yuda nʼehya Simyoni ko nʼehya Bbenjamini. ");
INSERT INTO nuj_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","Abakohasi abandi babaŋa ebibuga ehumi mu matwale gʼabehiha hya Efulayimu nʼehya Daani ko nomu hitundu hyʼehiha hya Manase. ");
INSERT INTO nuj_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","Abʼolulyo lwa Girisoni babaŋa ebibuga ehumi nabidatu mu matwale gʼabomu hiha hya Yisikaali nʼehya Aseri nʼehya Nafutaali ko nomu hitundu hyʼehiha hya Manase e Bbasani. ");
INSERT INTO nuj_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","Abʼolulyo lwa Merari babaŋa ebibuga ehumi nabibiri mu matwale gʼabomu hiha hya Lubbeeni nʼehya Gaadi nʼehya Zebbulooni. ");
INSERT INTO nuj_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","Abayisirayiri bahubba ahalulu baŋa abʼehiha hyʼAbaleevi ebibuga ebyo nʼaŋohwayiranga ngʼolu Musengwa galagira nʼabita mu Musa. ");
INSERT INTO nuj_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","9","Gano njʼamasiina gʼebibuga ohuŋwa mu matwale agʼehiha hya Yuda nʼehya Simyoni ebi baŋa ");
INSERT INTO nuj_vpl VALUES ("JS21_10","007_21_10","JOS","21","10","10","abejuhulu ba Alooni abomu lulyo lwa Kohasi abasimuha mu hiha hyʼAbaleevi. Ahalulu njʼabaheheerera ohugwaho: ");
INSERT INTO nuj_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","Babaŋa ehibuga hyʼe Kiriyaasi Arubba hatyane ehi balanga baati Kebbulooni nʼaŋohwayira ohweswanigirisa ehyalo hyʼabehiha hya Yuda ehyʼesozi. Arubba gaali semwana ya Anaki. ");
INSERT INTO nuj_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","Aye eroba nʼebitehere ebyeswanigirihiise ehibuga ehyo baali bahenire ohubiŋa Kalebbu omusaani wa Yefune ngʼomuŋuluko gugwe. ");
INSERT INTO nuj_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","Abejuhulu ba Alooni omusengi wa Hatonda, babaŋa Kebbulooni ehirala hu bibuga ebyʼohweŋogomamo nga babameedaho nʼehibuga hye Libbuna. ");
INSERT INTO nuj_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","Babaŋa nʼehibuga hye Yatiri nʼehye Esitemowa ");
INSERT INTO nuj_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","nʼehye Koloni nʼehye Debbiri. ");
INSERT INTO nuj_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","Nga babaŋa nʼehibuga hye Ayini nʼehye Yuuta ko nʼehye Bbesi Semesi, nʼaŋohwayira ebyayo mu hiisi hibuga. Ŋosiŋosi byali ebibuga mwenda ebi baatusa hu hiha ehya Yuda nʼehya Simyoni. ");
INSERT INTO nuj_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","Ohuŋwa mu matwale gʼabehiha hya Bbenjamini babaŋa ebibuga bine: Gibbyoni ni Geebba ");
INSERT INTO nuj_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","ni Anasoosi ni Alumooni ko nʼaŋohwayira ebyayo. ");
INSERT INTO nuj_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","Ebibuga ebi baaŋa abasengi ba Hatonda, abejuhulu ba Alooni byali ehumi nabidatu ni mulimo nʼaŋohwayiranga ebyayo. ");
INSERT INTO nuj_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","Abʼolulyo lwa Abakohasi abandi abasimuha mu Baleevi babaŋa ebibuga mu twale lyʼehiha hya Efulayimu. ");
INSERT INTO nuj_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","Baabaŋa ebibuga bine: Sekemu ehibuga ehyʼohweŋogomamo mu hyalo ehyʼabehiha hya Efulayimu ehyʼesozi ni Gezeri ");
INSERT INTO nuj_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","ni Kibbuzayimu ni Bbesi Horoni nʼaŋohwayira ebyayo mu hyalo hyʼabehiha hya Efulayimu ehyʼesozi. ");
INSERT INTO nuj_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","Ohuŋwa mu twale lyʼabehiha hya Daani, babaŋa ebibuga bine: Eluteke ni Gibbesooni ");
INSERT INTO nuj_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","ni Ayijalooni ni Gaasi Rimooni nʼaŋohwayiranga ebyayo. ");
INSERT INTO nuj_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","Nga nindi babaŋa ebibuga bibiri mu twale lyʼehitundu hyʼabehiha hya Manase: Tanaki ni Gaasi Rimooni nʼaŋohwayira ebyayo. ");
INSERT INTO nuj_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","Kale ŋalala ŋosiŋosi abomu lulyo lwa Kohasi abasigala basuna ebibuga ehumi nʼaŋohwayira ebyayo. ");
INSERT INTO nuj_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","Abaleevi abʼolulyo lwa Girisoni babaŋa ebibuga bibiri: mu twale lyʼehitundu hyʼabehiha hya Manase, nʼehibuga Golani ehyohweŋogomamo mu twale lyʼe Bbasani ni Bbesitera ko nʼaŋohwayira ebyayo. ");
INSERT INTO nuj_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","Ohuŋwa mu twale lyʼabehiha hya Yisikaali babaŋa ebibuga bine: Kisiyooni ni Dabberaasi ");
INSERT INTO nuj_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","ni Yarumuusi ni Eni Ganiimu ko nʼaŋohwayira ebyayo. ");
INSERT INTO nuj_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","Era babaŋa ebibuga bine mu twale lyʼehiha hya Aseri: Misali ni Abbudooni ");
INSERT INTO nuj_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","ni Helukasi ni Rehobbu ko nʼaŋohwayira ebyayo. ");
INSERT INTO nuj_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","Nga babaŋa ebibuga bidatu mu twale lyʼehiha hya Nafutaali: Ehibuga Kedesi ehyohweŋogomamo e Galilaaya ni Hamosi Doori ni Karutaani nʼaŋohwayira ebyayo. ");
INSERT INTO nuj_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","Ŋalala ŋosiŋosi, ebibuga ebi baŋa abʼolulyo lwa Girisoni byali ehumi nabidatu ko nʼaŋohwayira ebyayo. ");
INSERT INTO nuj_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","Abaleevi abasigala abomu lulyo lwa Merari babaŋa mu twale lyʼehiha hya Zebbulooni ebibuga bine: Yokuneyaamu ni Karita ");
INSERT INTO nuj_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","ni Dimuna ni Nahalaali ko nʼaŋohwayira ebyayo. ");
INSERT INTO nuj_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","Nga babaŋa ebibuga bine mu twale lyʼehiha hya Lubbeeni. Ebibuga ebyo byali Bbezeri ni Yahaza ");
INSERT INTO nuj_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","ni Kedemoosi ni Mefaasi nʼaŋohwayira ebyayo. ");
INSERT INTO nuj_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","Babaŋa ebibuga bine mu twale lyʼehiha hya Gaadi. Era ebibuga ebyo byali: Ramosi e Giliyaadi ni Mahanayimu ");
INSERT INTO nuj_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","ni Hesibboni ni Yazeri ko nʼaŋohwayira ebyayo. ");
INSERT INTO nuj_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","Ŋalala ŋosiŋosi abomu lulyo lwa Merari abasigala babaŋa ebibuga ehumi nabibiri. ");
INSERT INTO nuj_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","Ebibuga ebi Baleevi basuna mu matwale gʼAbayisirayiri byali ane namunaana ŋalala nʼaŋohwayira ebyayo. ");
INSERT INTO nuj_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","Hiisi hibuga hyali nʼaŋohwayira ebyayo ohuhyeswanigirisa. ");
INSERT INTO nuj_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","Mu ngeri eyo Musengwa gaaŋa Abayisirayiri eroba ngʼolu gaali nʼasuubihise abasehulu baawe era nga boosi baŋira eroba eryo ngʼomuŋuluko, bamenyamo. ");
INSERT INTO nuj_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","Musengwa gabaŋa ehiŋuumulo hu njuyi josijosi ngʼolu gaali nʼasuubihise abasehulu baawe. Ŋaŋuma mulabe waawe owabaŋangula olwohuba Musengwa gabata ŋaasi waawe. ");
INSERT INTO nuj_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","Ŋaŋuma hiraŋi wayire hirala ehi Musengwa gasuubisa Yisirayiri ehitolerera. Hiisi ehi gabasuubisa hyolerera. ");
INSERT INTO nuj_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","Ebyo ni byaŋwa, nga Yoswa alanga abomu hiha hya Lubbeeni nʼehya Gaadi nʼehitundu hyʼehiha hya Manase ehyʼebuŋwalyuba, ");
INSERT INTO nuj_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","ngʼabaloma ati, “Muholire byosibyosi ebi Musa omuŋeeresa wa Musengwa gabalagira ohuhola era mugondeeye ebiragiro byange byosibyosi. ");
INSERT INTO nuj_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","Simulehulireŋo Bayisirayiri bahyenywe ebiseera ebyo byosibyosi nʼohwola hatyane aye mwoherehiise ebiragiro ebi Musengwa Hatonda wenywe gabalagira. ");
INSERT INTO nuj_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","Ŋaahani ngʼolu Musengwa Hatonda wenywe aŋaaye Abayisirayiri ehiŋuumulo ngʼolu gasuubisa, mwagameyo ewenywe mu twale eri Musa omuŋeeresa wa Musengwa gabaŋa ohuba omuŋuluko gwenywe e buŋwalyuba wa Yoludaani. ");
INSERT INTO nuj_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","Aye mwegenderesanga ohwoheresanga amagambi nʼebiragiro ebi Musa omuŋeeresa wa Musengwa gabaŋa: ohwendanga Musengwa Hatonda wenywe nʼohumugonderanga nʼohuŋambanga ebiragiro bibye, mumutemo owesige nʼohumuŋeeresanga nʼemyoyo jenywe josijosi nʼobulamu wenywe wosiwosi.” ");
INSERT INTO nuj_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","Ngʼaŋo Yoswa abalombera ekabi, abaseebula bagama ewaawe. ");
INSERT INTO nuj_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","Musa gaali aŋaaye ehitundu hyʼehiha hya Manase omuŋuluko e Bbasani hu luuyi lwʼebuŋwalyuba wa Yoludaani, ehitundu ehindi ehya Manase Yoswa ngʼahiŋa omuŋuluko ebugwalyuba wa Yoludaani mu Bayisirayiri bahyawe. Yoswa ni gaali nʼabaseebula ohwagama ewaawe, gabalombera ekabi ");
INSERT INTO nuj_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","ati, “Mwagame mu mago genywe nʼobuŋinda wenywe obungi obugali nʼebidooli byʼebyayo ebingi nʼefeeza nʼezaabbu nʼebihomo nʼebyoma nʼengoye enyene enyingi. Mugabane nʼAbayisirayiri bahyenywe ebyʼobuŋinda ebi mwanyaga hu balabe benywe.” ");
INSERT INTO nuj_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","Ngʼabehiha hya Lubbeeni nʼehya Gaadi nʼehitundu hyʼehiha hya Manase bagamayo ewaawe. Baleha Abayisirayiri abandi e Siilo mu hyalo hyʼe Kanani, nga nibo batiina e Giliyaadi mu hyalo hyawe ehi babaŋa ohuba omuŋuluko gwawe ngʼolu Musengwa galagira nʼabita mu Musa. ");
INSERT INTO nuj_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","Abʼehiha hya Lubbeeni nʼehya Gaadi nʼehitundu hyʼehiha hya Manase ni boola e Geliloosi ohuupi nʼolwabi Yoludaani mu hyalo hyʼe Kanani, batongola ehituuti ehi muutu ataŋanga hubisyamo moni. ");
INSERT INTO nuj_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","Abayisirayiri bahyawe ni baŋulira baati batongoye ehituuti hu lubibi ni Kanani e Geliloosi huupi ni Yoludaani hu luuyi lwawe, ");
INSERT INTO nuj_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","Abayisirayiri bosibosi bahumbaanira e Siilo batiine babasoose. ");
INSERT INTO nuj_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","Olwʼehyo, batuma Fenekaasi omusaani wa Elyazaali omusengi wa Hatonda eyiri abomu hiha hya Lubbeeni nʼehya Gaadi nʼehitundu hyʼehiha hya Manase mu hyalo hyʼe Giliyaadi. ");
INSERT INTO nuj_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","Nga bamutaho abatangirisi ehumi ohuŋwa mu hiisi hiha hya Yisirayiri. ");
INSERT INTO nuj_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","Nga batiina e Giliyaadi ohuloma nʼabomu hiha hya Lubbeeni nʼehya Gaadi nʼehitundu hyʼehiha hya Manase baati, ");
INSERT INTO nuj_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","Oluhumbaano lwʼabaatu ba Musengwa lwosirwosi nga luloma luuti, “Lwahiina musalireeŋo ohwetusa hu Musengwa Hatonda wa Yisirayiri? Mwetongolera ehituuti ohulaga muuti mumuŋoyeeho!” ");
INSERT INTO nuj_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","“Muhebulire ehibi ehi hwahola ni huli e Pewooli, Musengwa gaboneresa abaatu babe ni haŋupuli. Era huli hubonaabona olwʼehibi ehyo ehi hwahola. Muli batuufu nindi ohwongeraho ehibi hu hibi? ");
INSERT INTO nuj_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","Ŋaahani nindi musalireeŋo ohuhubba Musengwa omugongo? Munajeemera Musengwa, aja huluŋira Abayisirayiri bosibosi. ");
INSERT INTO nuj_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","Ehyalo hyenywe ni hiba ni hitali hiraŋi ohujumirihisyamo Hatonda, mwambuhe muuje eno eyiri eweema ya Musengwa, mugabane ni neefe ehyalo ehyo. Aye mutajeemera Musengwa oba ohujeemera efe mwatongola ehituuti ehyenywe ohuleha ehya Musengwa Hatonda weefe. ");
INSERT INTO nuj_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","Muhebulire muuti Akani omusaani wa Zeera ni gajeemera ehiragiro ehiŋamba hu biitu ebi baali ni baŋongire eyiri Musengwa, Abayisirayiri bosibosi basuna ehibonereso. Akani sinjowafa yeŋene olwʼehibi ehi gahola.” ");
INSERT INTO nuj_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","Ngʼaŋo abʼehiha ehya Lubbeeni nʼehya Gaadi nʼehitundu hyʼehiha hya Manase bagobola mu batangirisi bʼebiha byʼAbayisirayiri abo baati, ");
INSERT INTO nuj_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","“Omwene Buŋangi, Hatonda Musengwa, Omwene Buŋangi, Hatonda Musengwa amanyire lwahiina hwahola huutyo era hwenda mwesi muhimanye. Ni huba ni hwahihola olwʼohujeemera Musengwa, muli nʼedembe ohutwita. ");
INSERT INTO nuj_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","Era ni huba ni hwajeemera Musengwa, hwatongola ehituuti ehyefe hu weefe olwʼohwenda ohuŋongeraho eŋongo eyi bohya ehwiye lyaguguliha oba ohuŋeeraho eŋongo eyʼembehe nʼeŋongo eryʼohuleeta emiyaaya, leha Musengwa omwene atugudye. ");
INSERT INTO nuj_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","“Mu mazima hwatongola ehituuti ehyo olwʼohutya ti mu moni eyo, abejuhulu benywe baŋangire ohuloma abeefe baati, ‘Kolagana hi eyi muli ni nayo ŋagati wenywe ni Musengwa Hatonda wa Yisirayiri? ");
INSERT INTO nuj_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","Musengwa gataŋo Yoludaani ohuba olubibi ŋagati weefe ni nenywe: enywe abomu hiha hya Lubbeeni nʼehya Gaadi, muŋuma mugabo hu Musengwa.’ Mu engeri hyeyo, abejuhulu benywe baŋanga baleetera abeefe ohuleheraŋo ohujumiryanga Musengwa. ");
INSERT INTO nuj_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","“Ehyo njʼehyagima hwatongola ehituuti, sihuŋeeraho ŋongo ");
INSERT INTO nuj_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","aye hibe obujulizi ŋagati weefe ni nenywe ko nʼabaatu bʼemirembe ejirigobolaho ohulaga ti huja hujumiryanga Musengwa era huja huleetanga eyo mu weema ya Musengwa, eŋongo eyi bohya ehwiye lyaguguliha nʼeŋongo eyohuleetaŋo emiyaaya ko abejuhulu benywe mu moni eyo bataloma abeefe baati, ‘Muŋuma lulebe ŋagati wenywe ni Musengwa.’ ");
INSERT INTO nuj_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","“Eyo nje yaali epeega yeefe ni huloma huuti singa ehyo hibaaŋo abejuhulu beefe baliroma baati, ‘Mubone ehituuti hya Musengwa ehi basehulu beefe batongola, sihuŋeerangaho eŋongo eyi bohya ehwiye lyaguguliha oba eŋongo eyindi aye ngʼobujulizi ŋagati weefe ni nenywe.’ ");
INSERT INTO nuj_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","“Sihusobola hujeemera Musengwa oba ohumuŋwaho hwesi hwatongola ehituuti ehyʼohuŋeeraho eŋongo eyi bohya ehwiye lyaguguliha nʼeŋongo eryʼembehe oba eŋongo eyindi. Sihusobola huhihola ni ŋaliŋo ehituuti hya Musengwa Hatonda weefe mu moni wʼeweema yiye.” ");
INSERT INTO nuj_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","Fenekaasi omusengi wa Hatonda nʼabatangirisi bʼAbayisirayiri abaali abahulu bʼebiha byʼAbayisirayiri, ni baŋulira ebibono ebyo, bagwalaala emyoyo. ");
INSERT INTO nuj_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","Nga Fenekaasi omusaani wa Elyazaali era omusengi wa Hatonda aloma abʼehiha hya Lubbeeni nʼehya Gaadi ko nʼehitundu hyʼehiha hya Manase ati, “Ŋaahani hutegeeye huuti Musengwa ali ni neefe. Simuli humujeemera. Era olwʼehyo, muŋonisye Abayisirayiri ehiguudyo hya Musengwa ehyahabajireho.” ");
INSERT INTO nuj_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","Ngʼaŋo Fenekaasi nʼabatangirisi abo bagamayo e Giliyaadi mu hyalo hyʼe Kanani ohuŋwa mu luhiiho nʼabehiha hya Lubbeeni nʼehya Gaadi nga balomera Abayisirayiri ebyaliyo. ");
INSERT INTO nuj_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","Abayisirayiri ni baŋulira, basangaala bugali era bajumirya Hatonda. Bahomya ohuloma hu byʼohutiina ohusihiirisa ehyalo ehi bʼehiha hya Lubbeeni nʼehya Gaadi baali ni bamenyamo. ");
INSERT INTO nuj_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","Ngʼabehiha hya Lubbeeni nʼehya Gaadi baguliha ehituuti ehyo esiina baati, “Obujulizi ŋagati weefe ti Musengwa nje Hatonda.” ");
INSERT INTO nuj_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","Ni ŋabitaŋo ehiseera ehireeŋi, Musengwa nʼaŋaaye Abayisirayiri ehiŋuumulo natuhiseŋo balabe baawe ababateganyanga era mu hiseera ehyo Yoswa nʼasahuluŋire bugali, ");
INSERT INTO nuj_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","galanga Abayisirayiri bosibosi nʼabasaaja bahulu nʼabatangirisi nʼabalamuzi nʼabahungu ngʼabaloma ati, “Ese sahuluŋire bugali weene. ");
INSERT INTO nuj_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","Muweene byosibyosi ebi Musengwa Hatonda wenywe aholire amawanga gosigosi hu lwenywe. Musengwa Hatonda wenywe abayeeŋo hu lwenywe nʼabasolerera. ");
INSERT INTO nuj_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","Muhebulire ngʼolu naabulira ebiha byenywe emiŋuluko mwiroba ohuŋwa hu lwabi Yoludaani ohwola e bugwalyuba wʼenyanja Meditereniani. Nabaŋa eroba eryʼamawanga gosigosi aganaŋangula ko nʼeroba lyʼamawanga ago aga huhiiri huŋangula. ");
INSERT INTO nuj_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","Musengwa Hatonda wenywe omwene aja hugira babaŋwereŋo era aja hubbinga amawanga ago ni mubona. Muja huŋira ehyalo hyawe ngʼolu Musengwa Hatonda wenywe gabasuubisa. ");
INSERT INTO nuj_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","“Mube bagumu beene era mwegenderese ohugonderanga ebyo byosibyosi ebi baŋandiiha mu Hitabo ehyʼAmagambi aga Hatonda gaaŋa Musa, ni ŋaŋuma husagasagana. ");
INSERT INTO nuj_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","Simuholanga muhumba nʼabanamawanga abasigala bamenya ŋalala ni nenywe wayire ohuloma hu masiina gʼabahatonda baawe oba ohugatambisanga ni mulayira oba ohujumiryanga abahatonda abo wayire ohubahubbiranga amafuha. ");
INSERT INTO nuj_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","Aye mwesigenga Musengwa Hatonda wenywe ngʼolu mubaaye ni muhola ohwolera erala olwaleero luno. ");
INSERT INTO nuj_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","“Musengwa gabbinga amawanga amabba era agʼamaani ngʼolu mwagalumbanga era nʼohwola olwaleero luno ŋaŋuma gwanga eribaŋangulangaho. ");
INSERT INTO nuj_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","Omulala hu enywe abbinga olukumi olwohuba Musengwa Hatonda wenywe abasoolera ngʼolu gasuubisa. ");
INSERT INTO nuj_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","Olwʼehyo, mwegenderesenga era mwendenga Musengwa Hatonda wenywe. ");
INSERT INTO nuj_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","“Aye ni munacuuhe mwatandiha ohuba nʼomuhumba nʼabanamawanga abasigaayeŋo era mwafumbiriganwa, ");
INSERT INTO nuj_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","ngʼaŋo muhimanya muuti Musengwa Hatonda wenywe saaja hubbinga mawanga ago ohubaŋweraŋo. Aye baja hubafuhira hagumba wegoge era mutego, baja hubanga faalu hu migongo jenywe era amaŋwa mu moni jenywe ohwola olu munahasihiirihe mwaŋwa hu hyalo hino ehiraŋi ehi Musengwa Hatonda wenywe gabaŋa. ");
INSERT INTO nuj_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","“Ŋaahani ehiseera hyange ehyʼohufa hyolire. Hiisi muutu hu enywe amanyire mu mwoyo wuwe nomu bulamu wuwe ngʼolu Musengwa Hatonda wenywe abaŋaaye ebiraŋi byosibyosi ebi gasuubisa. Hiisi ehi gasuubisa ahyoherehiise era ŋaŋuma wayire hirala ehimuhayire. ");
INSERT INTO nuj_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","Aye ngʼolu Musengwa Hatonda wenywe goherehiise hiisi ehi gasuubisa, mu ngeri njʼenyene aja hubaleetaho hiisi ndibo musihiirihe muŋwe hu hyalo hino ehiraŋi ehi gabaŋa. ");
INSERT INTO nuj_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","Singa muŋwa hu ndagaano eyi Musengwa Hatonda wenywe gabalagira ohuhuuma, mwatandiha ohuŋeeresa abahatonda abandi era mwabahubbira amafuha, Musengwa aja hubaluŋira musihiirihe, simuja huhena hiseera hireeŋi mu hyalo ehiraŋi ehi gaabaŋa.” ");
INSERT INTO nuj_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Yoswa galoma abaatu bomu biha bya Yisirayiri bosibosi ohuhumbaanira e Sekemu. Ngʼalanga abasaaja bahulu nʼabatangirisi nʼabalamuzi batiine bemeerere mu moni jʼeweema ya Musengwa. ");
INSERT INTO nuj_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Nga Yoswa aloma abaatu bosibosi ati, “Bino mbebi Musengwa Hatonda wa Yisirayiri aloma, ‘Ahalehale abasehulu benywe bamenyanga engereha wʼolwabi Yufuleeti ni bajumirya abahatonda abandi. Mulala hu basehulu benywe abo nje Teera semwana wa Yibbulayimu ni Naholi. ");
INSERT INTO nuj_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Aye natusa sehulu yenywe Yibbulayimu engereha wʼolwabi Yufuleeti, namutangirira mu hyalo hyʼe Kanani hyosihyosi nga muŋa ni Yisaka nʼabejuhulu abeene bangi. ");
INSERT INTO nuj_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","Naŋa Yisaka abaana abaseere babiri, Yakobbo ni Esawu. Nga pa Esawu ehyalo ehi balanga baati Seyiri ehyʼesozi. Aye Yakobbo nʼabomu mago gage behirira batiina e Misiri. ");
INSERT INTO nuj_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","“ ‘Oluvanyuma natuma Musa ni Alooni era nahola Abamisiri ebiguudyo, nga tusaayo abasehulu benywe. ");
INSERT INTO nuj_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","Ni nabatusa e Misiri, Abamisiri bababbingirira ni batambisa abasirikale abagendera hu bigaali nohu mbalaasi. Aye abasehulu benywe ni boola hu nyanja Enando, ");
INSERT INTO nuj_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","baliririra Musengwa abayeede, nga taaŋo ehiirema ŋagati waawe nʼAbamisiri era nga Abamisiri bagwa mu nyanja ebamira. Mweboneraho nʼemoni jenywe ebi nahola Abamisiri. Mwamenya mu lulafu ehiseera ehyene ehireeŋi. ");
INSERT INTO nuj_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","“ ‘Ngʼaŋo mbaŋira mu hyalo hyʼAbamooli, abaali ni bamenya ebuŋwalyuba wʼolwabi Yoludaani. Babasoosa aye nabaŋayo eyi muli mwabaŋangula. Nabasihiirisa ni mubona era nga muŋira ehyalo hyawe. ");
INSERT INTO nuj_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","Bbalaki habaha wʼe Mowaabbu era omusaani wa Zipori, gendire asoose Abayisirayiri. Ngʼatumisa Bbalamu omusaani wa Bbewori namusunga abaŋwabe. ");
INSERT INTO nuj_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","Aye nagaana ohuŋuliirisa ebya Bbalamu era mu hifo hyʼohubaŋwaba, gabalombera hubalombera ekabi. Ngʼaŋo mbaŋonia Bbalaki. ");
INSERT INTO nuj_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","“ ‘Nga mwambuha olwabi Yoludaani mwola e Yeriko. Abaatu bʼe Yeriko nga babasoosa ngʼolu Abamooli nʼAbapereezi nʼAbakanani nʼAbahiiti nʼAbagirugaasi nʼAbahiivi nʼAbayebbusi baahola. Aye nabaŋayo eyi muli mwabaŋangula. ");
INSERT INTO nuj_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","Abalabe benywe sibabaduluma olwohuba ti mwali nʼepiima nʼobusaale aye nabaŋindihamo etiisa baduluma ngʼolu nahola abahabaha bombi abʼAbamooli. ");
INSERT INTO nuj_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","Nabaŋa ehyalo ehi mutaholerera nʼebibuga ebi mutatongola era ŋaahani mubimenyamo, nʼohulya mulya emizabbibbu nʼemizayiti eji mutaahoma.’” ");
INSERT INTO nuj_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","Nga Yoswa geyongera aloma ati, “Olwʼehyo mutyenga Musengwa era mumuŋeeresenga nʼobuhenerefu. Mweyambule abahatonda aba basehulu benywe bajumiryanga engereha wʼolwabi Yufuleeti nʼe Mesopotamya nʼe Misiri, muŋeeresenga nje Musengwa. ");
INSERT INTO nuj_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Aye ni muba ni mutenda huŋeeresa Musengwa, musaleŋo olwaleero njʼani oyu munaŋeeresenga: oba abahatonda aba basehulu benywe baŋeeresanga e Mesopotamya oba abahatonda bʼAbamooli abomu hyalo ehi mulimo hatyane. Aye ese nʼabomu mago gange, huja huŋeeresenga Musengwa.” ");
INSERT INTO nuj_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Ngʼabaatu bamugobolamo baati, “Efe ehyʼohuŋwa hu Musengwa hwaŋeeresa abahatonda bandi, hituŋwereŋo! ");
INSERT INTO nuj_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Musengwa Hatonda weefe njʼowatutusa efe nʼabasehulu beefe mu wiidu eyi hwali mu hyalo hyʼe Misiri. Era hwabona nʼemoni jeefe obubonero oweŋunjisa obu gahola. Gatuhuumanga hiisi aŋa hwatiinanga mu mawanga gosigosi aga hwabitangamo. ");
INSERT INTO nuj_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Ni hweyongeranga ohutiina mu moni, Musengwa gabbingangamo abamawanga agandi gosigosi nga pomuli nʼAbamooli abaali ni bamenyamo. Olwʼehyo, hwesi huja huŋeeresanga Musengwa olwohuba nje Hatonda weefe.” ");
INSERT INTO nuj_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Nga Yoswa aloma abaatu ati, “Aye muŋanga ohutasobola huŋeeresa Musengwa. Hatonda niye mwawufu era ali nʼewuba. Saaja hubasoniŋa olwʼobujeemu nʼebibi byenywe. ");
INSERT INTO nuj_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","Singa muhubba Musengwa omugongo mwaŋeeresa abahatonda abamawanga agandi, aja hubaboneresa muŋwereŋo erala wayire abaaye mulaŋi eyi muli.” ");
INSERT INTO nuj_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Aye abaatu bamugobolamo baati, “Mbe, efe huja huŋeeresanga nje Musengwa.” ");
INSERT INTO nuj_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","Nga Yoswa abaloma ati, “Enywe mwabeene muli bajulizi hu hi musalireeŋo muuti muja huŋeeresanga nje Musengwa.” Nga bamugobolamo baati, “Cehyo, huli bajulizi.” ");
INSERT INTO nuj_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Nga Yoswa abaloma ati, “Ŋaahani mweyambule abahatonda abamawanga agandi aga mumenyamo. Muŋereyo erala emyoyo jenywe eyiri Musengwa Hatonda wa Yisirayiri.” ");
INSERT INTO nuj_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Ngʼabaatu baloma Yoswa baati, “Huja huŋeeresenga Musengwa Hatonda weefe era hunamugonderenga.” ");
INSERT INTO nuj_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","Hu ludaalo olwo, nga Yoswa ahola endagaano nʼabaatu e Sekemu. Era ngʼabaŋa amagambi nʼebiragiro. ");
INSERT INTO nuj_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","Nga Yoswa aŋandiiha ebiitu ebyo mu Hitabo ehyʼAmagambi ga Hatonda. Ngʼaŋamba ogubaale agwemeha ŋaasi wʼomutumba ohuupi nʼehifo hya Musengwa ehyawufu. ");
INSERT INTO nuj_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Ngʼaloma abaatu abo bosibosi ati, “Ebaale lino linaabenga mujulizi eyi huli. Liŋuliiye byosibyosi ebi Musengwa atulomire. Lija hubasalira omusango ni mutaja husigala bʼamazima eyiri Hatonda wenywe.” ");
INSERT INTO nuj_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Nga Yoswa aseebula abaatu abo, hiisi muutu nga gagamayo mu muŋuluko gugwe. ");
INSERT INTO nuj_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Ebyo ni byaŋwa, Yoswa omusaani wa Nuuni era omuŋeeresa wa Musengwa, gafa nʼaŋesa emyaha cikumi nʼehumi. ");
INSERT INTO nuj_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Nga bamusiiha mu muŋuluko gugwe e Timunasi Seera mu hyalo ehyʼabehiha hya Efulayimu ehyʼesozi hu luuyi lwomu maniino gʼolusozi Gaasi. ");
INSERT INTO nuj_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Mu ndaalo eji Yoswa gabeeramo mulamu, Abayisirayiri baŋeeresanga Musengwa ohwola olu mulembe gwʼabaatu abahulu mu gwanga abaali ni baweene ebi Musengwa gabaholera gwaŋwaho. ");
INSERT INTO nuj_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Abayisirayiri babbeeda amagumba ga Yosefu ni baŋwa e Misiri nga bagasiiha e Sekemu mwiroba eri Yakobbo gagula hu basaani ba Hamoli semwana ya Sekemu efeeza cikumi. Eroba eryo, njʼeryali omuŋuluko gwʼabejuhulu ba Yosefu. ");
INSERT INTO nuj_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Elyazaali omusaani wa Alooni ngʼafa era nga bamusiiha e Gibbeya mu hibuga ehyomu hyalo hyʼabehiha hya Efulayimu ehyʼesozi ehi baaŋa omusaani wuwe Fenekaasi.");
INSERT INTO nuj_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Yaliyo eyo omusinde oyu balanganga baati Elukaana owamenyanga mu hibuga Raamasayimu Zofimu mu hyalo hyʼesozi ehya Efulayimu. Omusinde oyo gaali womu hiha hyʼEfulayimu era nʼali musaani wa Yerohaamu era omwijihulu wʼElihu. Sehuluwe Elihu niye nʼali musaani wa Tohu omwijihulu wa Zuufu Omwefulayimu. ");
INSERT INTO nuj_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Elukaana oyo gaali nʼabahasi babiri: Kaana ni Penina. Penina gaali nʼabaana aye Kaana nʼaŋuma. ");
INSERT INTO nuj_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Hiisi mwaha, Elukaana gaŋwanga mu hibuga hihye gatiina e Siilo ohujumirya nʼohuŋongera Musengwa Omwene Maŋe. Hofini ni Fenekaasi abasaani ba Eli, njʼabaali abasengi ba Musengwa mu hiseera ehyo. ");
INSERT INTO nuj_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Oludaalo ni lwolanga Elukaana ohuŋaayo eŋongo, gaŋambanga enyama gaŋa Penina omuhasi wuwe nʼabaana babe abahaana nʼabaseere ngʼomugabo gwawe. ");
INSERT INTO nuj_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Aye Elukaana gaŋanga Kaana omugabo oguhiraho ogwʼabandi olwohuba gamwendanga bugali aye Musengwa gaali ndamuŋe lusaaye. ");
INSERT INTO nuj_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Era olwohuba Musengwa gaali ndamuŋe lusaaye, muŋalihwawe gamujojoberesanga ohumusaalisa. ");
INSERT INTO nuj_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Era ehyo gahiholanga mwaha hu mwaha. Hiisi olu Kaana gatiinanga mu nyumba ya Musengwa, muŋalihwawe gamujojoberesanga gamuleetera ohulira amangi era hyamuŋweramo nʼohutahombaho hu hya mutamu. ");
INSERT INTO nuj_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Elukaana gabuusanga Kaana ati, “Lwahiina olira? Lwahiina siwenda hulya? Lwahiina oli munakuŋafu? Sikuhirira baana ehumi?” ");
INSERT INTO nuj_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","Lulala ni baali ni bahenire ohulya nʼohunywa e Siilo, nga Kaana genyoha atiina asaba. Eli omusengi wa Hatonda gaali gehaaye hu tebe ŋa mulyango gwa Yekaalu ya Musengwa. ");
INSERT INTO nuj_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","Kaana nʼenaku hu mwoyo, gasunga Musengwa nʼohulira amasiga nga pohwataaye. ");
INSERT INTO nuj_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Ngʼaŋaayo oweyamo ati, “O Musengwa Omwene Maŋe, bona enaku yʼomuŋeeresa wuwo era wukebulire, otebirira muŋeeresa wuwo aye muŋe hu mwana omuseere, nja humuhuŋa ahuŋeeresenga obulamu wuwe wosiwosi era sibaja humubegaho fiiri hu mutwe.” ");
INSERT INTO nuj_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Kaana ni geeyongera ohusaba, Eli geetegeresa omunwa gugwe. ");
INSERT INTO nuj_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","Kaana gaali asaba maŋoleeye mu mwoyo gugwe. Eminwa jaali jigenda aye ejanjaasi ni litaŋulirihana. Nga Eli aŋeega ati gehapiiye mwenge. ");
INSERT INTO nuj_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","Nga Eli amuloma ati, “Olyosa ŋeena ohumeera? Leheraŋo ohwehapira omwenge.” ");
INSERT INTO nuj_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Aye Kaana gamugobolamo ati, “Bbe, musengwa yange, sinywe mwenge oba ehimeesa ehindi hyosihyosi aye ndi nʼenaku hu mwoyo gwange eyi pwa huliririranga Musengwa. ");
INSERT INTO nuj_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Otaŋeega oti ndi muhasi aŋuma mahulu. Olwʼenaku nʼebiŋeego ebingi ebi ndi ni nabyo, mbaye ndi husaba.” ");
INSERT INTO nuj_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Nga Eli amuloma ati, “Tiina miyaaya era Hatonda wa Yisirayiri ahuŋe ehi oŋwa humusunga.” ");
INSERT INTO nuj_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Nga Kaana amuloma ati, “Mubbala webale ohundaga ehisa.” Ni gahena ohumuloma atyo, nga gagamayo alya hu mere ngʼasuna amaani. ");
INSERT INTO nuj_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Ni wahya mu mugamba pwipwipwi, nga Elukaana nʼabamago gage benyoha bajumirya Musengwa, nga bahena bagamayo ewaawe e Raama. Nga Elukaana aŋenyuha ni Kaana omuhasi wuwe, Musengwa ngʼamuhebulira aberega ehida. ");
INSERT INTO nuj_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Mu hiseera ehyo Kaana gagwamo ehida ngʼasaala omwana omuseere amuguliha esiina ati Samwiri nʼaloma ati, “Olwohuba namusunga Musengwa.” ");
INSERT INTO nuj_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Elukaana ni gatiina nʼamago gage ohuŋaayo eŋongo eya hiisi mwaha eyiri Musengwa nʼohwoheresa oweyamo wuwe, ");
INSERT INTO nuj_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Kaana sigatiina, galoma wamwe ati, “Oluvanyuma lwʼomwana ohuŋwa hwibeere ndi muŋira namuŋonga eyiri Musengwa era aja husigalayo nʼamuŋeeresanga.” ");
INSERT INTO nuj_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Nga wamwe Elukaana amuloma ati, “Hola ehi obona oti njʼehiraŋi. Sigala ohwola olu olitusa omwana hwibeere. Era Musengwa ahuyeede woherese ehisuubiso hihyo.” Ngʼaŋo omuhasi asigala gookesa omwana wuwe ohwola olu gamutusa hwibeere. ");
INSERT INTO nuj_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Oluvanyuma lwʼohumutusa hwibeere gaŋamba omwana wayire gaali ahiiri muŋere ko nʼebunwa eyʼemyaha edatu nʼobusyanu ngʼekilo mwenda nʼesaŋu eyʼehyanjo eyʼomwenge ogwomu mizabbibbu nga batiina e Siilo mu nyumba ya Musengwa. ");
INSERT INTO nuj_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Ni bahena ohuŋongayo ebunwa eyo, baŋamba omuseere bamuŋira aŋa Eli gaali. ");
INSERT INTO nuj_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Nga Kaana amuloma ati, “Muhulu, Wukebulira? Ndiise omuhasi owaaja ŋano neŋunderera Musengwa. ");
INSERT INTO nuj_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Nasunga Musengwa ohuupa omwana ono era gaŋulira ohulomba hwange. ");
INSERT INTO nuj_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Olwʼehyo, muŋongayo eyiri Musengwa era aja huba ŋano mu moni ja Musengwa ehiseera hyosihyosi ehyʼobulamu wuwe.” Ni baali eyo nga bajumirya Musengwa. ");
INSERT INTO nuj_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Nga Kaana asaba ati, “Omwoyo gwange musangaafu olwa Musengwa, nga ndi musangaafu olwʼebi Musengwa gakoleeye. Era njeherera abalabe bange, nga ndi musangaafu olwohuba Hatonda ganjeedire. ");
INSERT INTO nuj_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","“Ŋaŋumaaŋo omwawufu hya Musengwa, ŋaŋumaaŋo ali hyʼewe ŋaŋumaaŋo aŋanga ohutuhuuma hya Hatonda weefe.” ");
INSERT INTO nuj_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","“Muhomye endoma yenywe eyʼohwepaahapaaha era mulehere aŋo ohweginiha olwohuba Musengwa nje Hatonda amanyire era njʼopima byosibyosi ebi baatu bahola. ");
INSERT INTO nuj_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","“Abbwagabbwagire obusaale wʼabanamaani aye aŋaaye abanafu amaani. ");
INSERT INTO nuj_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Aŋahyali sibalwa huhyendula, abaatu abaalinga nʼemere ni basambira amagulu, ŋaahani baŋuuna hupakasa ko balya aye abaŋumanga hyahulya, ŋaahani baagwa mu biitu. Omuhasi owaali omugumba asaaye abaana musanvu aye oyo owasaaye abangi, ŋaŋuma kadi mulala oyu asigahiiseŋo. ");
INSERT INTO nuj_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","“Musengwa aleeta ohufa era njʼagaba obulamu, abaatu abandi abaŋira emagombe nindi galamusa abandi. ");
INSERT INTO nuj_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","Musengwa aleetera abaatu abandi ohuba bagadi aye abandi ngʼabafuula baŋinda, genyosa abandi aye abandi gabiisa ŋaasi. ");
INSERT INTO nuj_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","Atusa abagadi mu fuuhe era ayeeda abali mu wetaavu. Gabeehasa ŋalala nʼabahombe mu bifo ebyʼeŋono. “Musengwa njʼomwene musingi ohu hyalo hiri era ohwo pohu gatengeha ehyalo. ");
INSERT INTO nuj_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","Aja huhuuma abahola ebiruŋamu aye abahosi bʼebibi balibasimya. “Ŋaŋuma asobola ohubitamo hu lwʼamaani gage. ");
INSERT INTO nuj_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","Abo abaŋahania Musengwa, baja husihiiriha. Aja hubabbwabbwanuhiraho nʼali mwigulu. Musengwa aja husalira ehyalo hyosihyosi omusango. “Aja huŋa habaha wuwe obuŋangi era owuwe oyu getobolera aja humwongesa amaani.” ");
INSERT INTO nuj_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Ebyo ni byaŋwa, nga Elukaana ni Kaana bagamayo ewaawe e Raama. Ne Samwiri niye gatandiha ohuŋeeresa Musengwa ŋaasi wʼobutangirisi wa Eli. ");
INSERT INTO nuj_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","Abasaani ba Eli baali bahosi bʼebibi bugali era ni bataŋa Musengwa eŋono. ");
INSERT INTO nuj_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","Ŋaahani yaali sambo yʼabasengi ti omuutu ni gaŋangayo eŋongo era enyama ni yaalinga ni yiri hunya, omuŋeeresa wʼomusengi gahatiinire nʼewuuma eyiriho ameeno adatu ");
INSERT INTO nuj_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","ngʼafumita mu sefuliya oba mu bbinika oba mu hibange oba mu saha. Ehifi ehyajirangaho, njʼehi omusengi gahaŋirire. Era babisyanga baatyo hiisi Muyisirayiri owatiinanga e Siilo ohuŋaayo eŋongo. ");
INSERT INTO nuj_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","Ne baabanga bahiiri hwohya amasavu, ngʼomuŋeeresa wʼomusengi gatiina aloma omuutu oyo ali huŋonga ati, “Peeyo enyama omusengi aje goohye, saaja huŋira enyama epiiye, genda embisi.” ");
INSERT INTO nuj_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","Ni gahamugoboyemo ati, “Leha boohye amasavu ko oŋire enyama eyi wenda,” omuŋeeresa oyo gahamulomire ati, “Mbe, yiipe hu nyanga yino, hanye ogaana, nayiŋire mbaha.” ");
INSERT INTO nuj_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","Abaseere abo bahola ehibi ehibba mu moni ja Musengwa olwohuba sibaŋanga ŋongo lya Musengwa eŋono. ");
INSERT INTO nuj_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","Aye Samwiri niye gaali aŋeeresa Musengwa, era omuseere gambalanga efodi eyʼolugoye olwa laasi. ");
INSERT INTO nuj_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Hiisi mwaha, nyina gamutungiranga ehiganduula gamuŋirira olu gatiinanga ni wamwe ohuŋaayo eŋongo erya hiisi mwaha. ");
INSERT INTO nuj_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Eli gasungiranga Elukaana nʼomuhasiwe ekabi, galoma Elukaana ati, “Musengwa ahuŋe abaana abandi mu muhasi ono bagobole mu hifo hyʼono oyu gaŋongera Musengwa.” Ni gahenanga ohubasungira ekabi nga bagamayo e waawe. ");
INSERT INTO nuj_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Nga Musengwa aŋa Kaana ekabi asaala abaana abaseere abandi badatu ko nʼabahaana babiri. Aye Samwiri gahulira mu Yekaalu ya Musengwa. ");
INSERT INTO nuj_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","Ŋaahani Eli gaali asahuluŋire bugali, era gaŋuliranga byosibyosi ebi basaani baali ni bahola Abayisirayiri, era ngʼolu bahwedesanianga nʼabahasi abaŋeeresanga hu mulyango gwʼe Weema eyʼOhwagananirangamo. ");
INSERT INTO nuj_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","Nga abaloma ati, “Hiisi muutu gaaja eyindi nʼabemulugunyaho olwʼebibi ebi muhola. Lwahiina mwebisya muutyo? ");
INSERT INTO nuj_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","Muhihomye baana bange. Ebi pulira ohuŋwa eyiri abaatu ba Musengwa sibiraŋi naŋadiidiri. ");
INSERT INTO nuj_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","Singa omuutu asobya hu muutu wahye, Hatonda gengira mu songa jaawe gajitereesa. Aye omuutu anabbenga hu Musengwa, njʼani aja hwengira mu songa ejo?” Aye wayire gabalomaho, sibaŋulirisa bya saawe olwohuba Musengwa gaali asalireeŋo ohubeeta. ");
INSERT INTO nuj_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","Aye Samwiri niye geyongera ohuhula mu hirangi nʼali muhoda eyiri Musengwa nʼabaatu. ");
INSERT INTO nuj_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","Lulala, ŋaaliŋo omuutu wa Hatonda owatiina eyiri Eli gamuloma ati, “Musengwa aloma ati, ‘Nehwehulira abasehulu babo Abayisirayiri ni baali mu wiidu e Misiri. ");
INSERT INTO nuj_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","Era natobola sehulu wuwo Alooni mu biha byosibyosi ebya Yisirayiri namufuula musengi wange. Gapongerenga eŋongo hu hituuti hyange nʼohudunyisa obubbaani ko nʼohwambalanga efodi ni gapeeresa. Era naaŋa abasehulu babo eŋongo yosiyosi eyi bohya kwiye yaguguliha eyi Abayisirayiri baŋonga. ");
INSERT INTO nuj_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","Lwahiina mululuhanira eŋongo eyi baatu baapa? Lwahiina oŋa abasaani babo eŋono ohuhiraho ese? Mwola nʼohugeeja olwʼenyama eyihira obulaŋi eyi baatu bange baapa?’ ");
INSERT INTO nuj_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","“Olwʼehyo, Musengwa Hatonda wa Yisirayiri aloma ati, ‘Nasuubisa ti amago gago nʼehiha hihyo muja hupeeresanga ngʼabasengi emirembe nʼemirembe. Aye ŋahani sihija hweyongera ohuba hiityo. Abo abaapa eŋono keesi nja hubaŋa eŋono, ne abo abaatala keesi nja hubatala. ");
INSERT INTO nuj_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","Era ehiseera hiri huuja olu ndisihiirisa amago ga lataawo ŋaŋume wayire mulala alyola mu myaha ejʼobusahulu. ");
INSERT INTO nuj_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","Hija huhutawanya era esalwa yija huhuŋamba nʼobona ni ngabira Abayisirayiri ekabi. Aye ŋaŋuma wayire mulala hu bʼamago gago ali wangaala emyaha emingi. ");
INSERT INTO nuj_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","Abejuhulu babo balifa ni bahiiri baŋere aye omuutu owomu mago gago oyu ndirehaŋo aja huba musengi wange aye aja huhunakuŋasanga era ahulisye amangi.’” ");
INSERT INTO nuj_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","“Era ehija ohwola hu basaani babo bombi, Hofini ni Fenekaasi, hija huba habonero eyi oli ohulaga ti hiisi ehi ndomire hija hwolerera. Baja hufa hu ludaalo lulala. ");
INSERT INTO nuj_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","Nja hwesunirayo omusengi omwesigwa aja hupeeresanga era nʼahola ebi nenda. Nja humuŋa olulyo oluja huŋeeresanga mu moni ja habaha wange omutobole. ");
INSERT INTO nuj_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","Aye ni ŋanahabeŋo omuutu owomu lulyo lulwo aliba nʼahisigayeŋo, alitiina eyiri omusengi wange oyo amusunge ebbeesa nʼemere nʼamuloma ati, ‘Peeho omulimo ogwʼobusengi nahasunangaho emere.’ ” ");
INSERT INTO nuj_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Ŋahani, omwana ola Samwiri gaali atiina mu moni nʼohuŋeeresa Musengwa ŋaasi wʼobutangirisi wa Eli. Mu hiseera ehyo siŋateranga hubaŋo buhwenda ohuŋwa eyiri Musengwa era ni ŋabula hwolesewa aŋa ni naŋa. ");
INSERT INTO nuj_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Mu hiseera ehyo, Eli gaali sabona bulaŋi, lulala mu wiire nʼaŋenyuhire mu hisenge hihye, ");
INSERT INTO nuj_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Samwiri nʼaŋenyuhire mu hifo ehyawufu omwali Esanduuku ya Hatonda. Aŋa wuhyera etaala ni yihyaduha, ");
INSERT INTO nuj_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","ngʼaŋo Musengwa alanga Samwiri. Nga Samwiri amugobolamo ati, “Wanji.” ");
INSERT INTO nuj_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Nga genyoha aduluma atiina eyiri Eli amuloma ati, “Wundangire ndiise oyu nijire.” Nga Eli amuloma ati, “Sikulange, yagamayo oŋenyuhe.” Nga Samwiri gagamayo aŋenyuha. ");
INSERT INTO nuj_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","Nga nindi Musengwa amulanga ati, “Samwiri.” Nga Samwiri nindi genyoha atiina eyiri Eli amuloma ati, “Wundangire ndiise oyu nijire.” Nga Eli amugobolamo ati, “Mwana wange, sikulange, yagamayo oŋenyuhe.” ");
INSERT INTO nuj_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Samwiri gaali samanyire ati Musengwa njʼowaali nʼamulanga olwohuba gaali ahiiri humwehwehulira. ");
INSERT INTO nuj_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Nga Musengwa alanga Samwiri omulundi ogwohudatu. Nga Samwiri genyoha atiina eyiri Eli amuloma ati, “Wundangire ndiise oyu nijire.” Ngʼaŋo Eli ategeera ati Musengwa njʼowaali nʼamulanga. ");
INSERT INTO nuj_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Olwʼehyo nga Eli amuloma ati, “Tiina oŋenyuhe nanahulange nindi, onagobolemo oti, ‘Musengwa, loma omuŋeeresa wuwo ategire ohutwi.’” Nga Samwiri gagamayo mu hifo hihye aŋenyuha. ");
INSERT INTO nuj_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Musengwa gatiina gemeerera aŋo gamulanga ngʼolu gamulanga oludaayi ati, “Samwiri! Samwiri!” Nga Samwiri amugobolamo ati, “Loma, omuŋeeresa wuwo ategire ohutwi.” ");
INSERT INTO nuj_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Nga Musengwa aloma Samwiri ati, “Ndi huupi huhola ehiitu mu Yisirayiri ehija huhanga hiisi muutu ali hiŋulira. ");
INSERT INTO nuj_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Ehiseera ehyo, nja huboneresa Eli nʼamago gage ngʼolu nasuubisa. ");
INSERT INTO nuj_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Namuloma ti nja husalira amago gage omusango, ngasihiirise gaŋwereŋo erala olwohuba gamanya ebibi byʼabaana babe era ni bafodogola Hatonda aye ndabalomeho. ");
INSERT INTO nuj_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Ndayirira amago ga Eli ti ŋaŋuma eŋongo oba ehirabo ehisobola ohutuhisaŋo erala ehibi hyawe.” ");
INSERT INTO nuj_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Samwiri gaŋenyuha ohwola mu mugamba. Ni genyoha nga gegulaŋo enjigi jʼenyumba ya Musengwa. Aye gaatya ohulomera Eli ebi Musengwa gamulomera mu hirooto. ");
INSERT INTO nuj_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","Ne Eli galanga Samwiri ati, “Mwana wange Samwiri!” Nga Samwiri amugobolamo ati, “Wanji.” ");
INSERT INTO nuj_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Nga Eli amubuusa ati, “Musengwa gahulomire hiina? Otakweha. Era Hatonda ahugudye nʼobuhambwe owʼamaani nʼonangise ehiitu hyosihyosi ehi gahulomeeye.” ");
INSERT INTO nuj_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Samwiri gamulomera byosibyosi era ŋaŋuma ehi gamugisa wayire hirala. Nga Eli aloma ati, “Nje Musengwa leha omwene ahole ehi genda.” ");
INSERT INTO nuj_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Mu huhula hwa Samwiri, Musengwa gaali ŋalala ni naye era hiisi ehi galomanga hyolereranga. ");
INSERT INTO nuj_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Ngʼabaatu mu Yisirayiri bosibosi ohuŋwera erala e Daani ohwola e Bberuseebba bategeera baati Samwiri gaali naabbi wa Musengwa. ");
INSERT INTO nuj_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Musengwa geyongera ohwehwehulira Samwiri e Siilo nʼamulomera ehyʼohuloma. Era hiisi ehi Samwiri galomanga Abayisirayiri bosibosi baŋulirisanga. ");
INSERT INTO nuj_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","Lulala Abayisirayiri batiina ohusoola nʼAbafirisuuti. Nga bata ekambi yaawe ohuupi ni Ebbeneeza, ngʼAbafirisuuti bata eyaawe mu Afeki. ");
INSERT INTO nuj_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","NgʼAbafirisuuti bawaagala Abayisirayiri era olutalo ni lwatiina mu moni, beeta abaatu ekumi ene. ");
INSERT INTO nuj_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","Abasirikale ni bagobola mu kambi, ngʼabaatu abahulu mu Yisirayiri bebuusa baati, “Lwahiina Musengwa aleehire Abafirisuuti ohutuŋangula baati? Leha hutiine e Siilo hutuseyo Esanduuku yʼEndagaano ya Musengwa yahatuyeeda ohuŋangula abalabe beefe.” ");
INSERT INTO nuj_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","Olwʼehyo, batuma abaatu e Siilo batusayo Esanduuku yʼEndagaano eya Musengwa Omwene Maŋe owihala ŋagati wʼabakerubbi. Abasaani ba Eli, aba Hofini ni Fenekaasi bombi baali eyo nʼEsanduuku yʼEndagaano ya Hatonda. ");
INSERT INTO nuj_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","Ni boosa Esanduuku yʼEndagaano eya Musengwa mu kambi, Abayisirayiri bosibosi bahubba oluhero olwʼamaani ehyalo hyateetema. ");
INSERT INTO nuj_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","Abafirisuuti ni baŋulira oluhero nga bebuusa baati, “Hiina ehigira Ababbebbulaniya ni bahubba oguhero?” Ne Abafirisuuti ni bategeera baati Esanduuku ya Musengwa bayireetire mu kambi yaawe, ");
INSERT INTO nuj_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","basuna ohutya nga baloma baati, “Jitwageene! Abahatonda baajire mu kambi. Ehiitu hyehyo hibaaye sihibangaŋo. ");
INSERT INTO nuj_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","Jitwageene! Njʼani oja hutuŋonia abahatonda abʼamaani abo? Abo nje abahatonda abaleeta haŋupuli hu Abamisiri mu lulafu. ");
INSERT INTO nuj_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","Enywe Abafirisuuti, mube bagumu, musoole hisinde!” Ni mutasoole, huuja hufuuha beedu bʼAbabbebbulaniya ngʼolu babaaye beedu beefe olwʼehyo musoole hisinde. ");
INSERT INTO nuj_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","NgʼAbafirisuuti basoola nga baŋangula Abayisirayiri era hiisi muutu ngʼaduluma ni gagama ewuwe. Bangi aba beeta era Abayisirayiri bafiira abasirikale abohu magulu emitwalo edatu. ");
INSERT INTO nuj_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","Abafirisuuti banyaga Esanduuku ya Hatonda era abasaani ba Eli bombi, Hofini ni Fenekaasi bafa. ");
INSERT INTO nuj_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","Hu ludaalo olwo yaaliyo omusinde ohuŋwa mu hiha hya Bbenjamini owaduluma mu lutalo gatiina e Siilo. Omusinde oyo gaali anabujuuye engoye jije nʼomutwe gugwe ni gwijuuye efuuhe ohulaga enaku eyi gaali ni nayo. ");
INSERT INTO nuj_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","Ni goola mu hibuga, galomera abaatu ebyali ni bifa mu lutalo, bosibosi batemuha balira. Ŋaahani Eli gaali gehaaye hu tebe yiye hu tulo wʼengira nahuumiriiye ohuŋulira ebihya mu lutalo. Gahola atyo olwohuba omwoyo gugwe gwali mweralihirifu hu lwʼesanduuku ya Hatonda. ");
INSERT INTO nuj_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","Eli ni gaŋulira amaliro gabuusa ati, “Amaliro ago gaŋwa hu hi?” Ngʼomusinde oyo ganguŋaho atiina aŋa gaali, ");
INSERT INTO nuj_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","Eli gaali aŋesa emyaha cenda namunaana era nʼemoni ni jitabona. ");
INSERT INTO nuj_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","Omusinde oyo ngʼalomera Eli ati, “Ndulumire mu lutalo olwa leero luno.” Nga Eli amubuusa ati, “Mwana wange, bitiinire biitye?” ");
INSERT INTO nuj_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","Ngʼomusinde oyo amulomera ati, “Abafirisuuti baŋanguuye Abayisirayiri era hufiriiye abaatu bangi. Hiŋiriyeemo nʼabasaani babo bombi, Hofini ni Fenekaasi. Era batunyagireho nʼesanduuku ya Hatonda.” ");
INSERT INTO nuj_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","Ni gahoonya hu sanduuku ya Hatonda ati pa, nga Eli aŋwa hu tebe agenguha magalamiriiye ohuupi nʼomulyango. Gaali musahulu era musito era olu gagwa ŋaasi, gabbwagiha egosi ngʼafa. Eli gaali atangiriiye Yisirayiri emyaha ane. ");
INSERT INTO nuj_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","Omulya wuwe, muha Fenekaasi gaali ŋasito nʼali huupi husaala. Ni gaŋulira ati esanduuku ya Hatonda bayinyagire era muhwewe ni wamwe bafuuye, ebise byamutandiha era ngʼasaala aye yeesi gatiinirayo. ");
INSERT INTO nuj_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","Ni gaali nʼafa, abahasi abasaalisa bamugumya baati, “Otatya, osaaye omwana museere.” Aye niye sigabasimula wayire hubaŋulirisa. ");
INSERT INTO nuj_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","Gaguliha omwana oyo esiina ati Yikabboodi, naloma ati, “Eŋono lya Yisirayiri litiinire.” Olwʼohunyaga esanduuku ya Hatonda ko nʼohufa hwa muhwewe ni wamwe. ");
INSERT INTO nuj_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","Galoma ati, “Eŋono lya Yisirayiri litiinire olwohuba bayinyagire esanduuku ya Hatonda.” ");
INSERT INTO nuj_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","Abafirisuuti ni banyaga esanduuku ya Hatonda, bayitusa mu Ebbeneeza bayiŋira e Asidodi. ");
INSERT INTO nuj_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","Ni bayoosa eyo, nga bayita mu yekaalu ya Dagoni. Era bayitengeha aŋo ohumulirana. ");
INSERT INTO nuj_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","Abaatu bʼe Asidodi ni benyoha mu mugamba pwipwipwi, batuhira Dagoni nʼaguuye mafumaaye mu moni wʼesanduuku ya Musengwa. Nga bagangamusa Dagoni bamugobosa mu hifo hihye. ");
INSERT INTO nuj_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","Aye ni wahya mu mugamba ni benyoha batiina mu yekaalu, leero hulwo batuhira Dagoni nʼaguuye mafumaaye mu moni wʼesanduuku ya Musengwa. Omutwe nʼemihono ni bibbwagihireho, ni biri ŋa mulyango era omubiri gwoka njʼogwasigala. ");
INSERT INTO nuj_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","Ehyo cʼehigira abasengi ba Dagoni ni bengira mu yekaalu ya Dagoni, sibeema ŋa mulyango aŋa basiritira engaano mu Asidodi nʼohwola olwa leero luno. ");
INSERT INTO nuj_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","Musengwa gaboneresa bugali abaatu bomu Asidodi nʼebitehere ebyeswanigirihiise baatya. Gabadanyaho ebizimba. ");
INSERT INTO nuj_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","Abaatu bomu Asidodi ni babona ebyaboolaho nga baloma baati, “Esanduuku ya Hatonda wʼAbayisirayiri siyija hweyongera ni yiri ŋano olwohuba Hatonda waawe ali hutugudya efe ni Dagoni hatonda weefe bugali.” ");
INSERT INTO nuj_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","Olwʼehyo batumisa abatangirisi bʼAbafirisuuti bosibosi nga bababuusa baati, “Esanduuku ya hatonda wʼAbayisirayiri huyihole huutye?” Nga babagobolamo baati, “Esanduuku ya hatonda wa Yisirayiri muyiŋire e Gaasi.” Olwʼehyo, bayiŋira e Gaasi ehibuga ehindi ehyʼAbafirisuuti. ");
INSERT INTO nuj_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","Aye oluvanyuma lwʼohuyoosayo, Musengwa gaboneresa abaatu bomu hibuga ehyo, olusisimo olwʼamaani lwabaŋamba. Abaatu bomu hibuga ehyo, abahulu nʼabaŋere gabadanyaho ebizimba. ");
INSERT INTO nuj_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","Olwʼehyo baŋeeresa esanduuku ya Hatonda mu hibuga Ekurooni. Aye ni bayoosa eyo abaatu bomu Ekurooni nga bahayaana baati, “Batuleteeye esanduuku ya Hatonda wa Yisirayiri ohutwita hwesihwesi!” ");
INSERT INTO nuj_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","Olwʼehyo abaatu bomu Asidodi balanga abatangirisi bʼAbafirisuuti bahumbaana babaloma baati, “Mwagamyeyo esanduuku ya Hatonda wa Yisirayiri mu hifo hyayo etatwita hutuhenaŋo.” Baloma baatyo olwohuba ohufa hwali huleetire olusisimo lubitiirifu mu hibuga. Hatonda gababoneresa bugali weene. ");
INSERT INTO nuj_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","Abo abaŋunuha ohufa, babadanyaho amabute era ohulira hwali hungi mu hibuga. ");
INSERT INTO nuj_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","Esanduuku ya Musengwa ni yaali nehenire emyesi musanvu mu hyalo hyʼe Firisuuti. ");
INSERT INTO nuj_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","Abafirisuuti balanga abasengi nʼabafumu nga bababuusa baati, “Esanduuku ya Musengwa huyihole huutye? Mutulomere, huyagamya huutye?” ");
INSERT INTO nuj_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","Nga babagobolamo baati, “Ni muba ni mwagamyayo esanduuku ya Hatonda wa Yisirayiri, mutayagamyayo njereere, muyagamye nʼehirabo ohutusaŋo ebibi byenywe. Munaŋona, muuja humanya muuti Hatonda njʼobaaye nʼaboosaho ebiguudyo.” ");
INSERT INTO nuj_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","NgʼAbafirisuuti babuusa baati, “Hirabo hi ehyʼohuŋindihiraho?” Ngʼabasengi nʼabafumu babagobolamo baati, “Baŋambe ezaabbu bawumbemo ebiwumbe ebiri hyʼamabute bitaanu, nʼebiri hyʼembeba bitaanu, hiisi hirala hu ebyo ni hiri hya mulala hu baŋugi bʼAbafirisuuti abataanu olwohuba haŋupuli oyu babasindihira njʼoyu basindihira nʼabaŋugi bʼAbafirisuuti abataanu. ");
INSERT INTO nuj_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","Olwʼehyo muŋambe ezaabbu mubbotemo ebiitu bitaanu ebiri hyʼamabute, muhene mubbote ebindi bitaanu ebiri ti hani mbeba ejihenireŋo ebirime mu gwanga lyenywe. Singa muŋa Hatonda wa Yisirayiri ebirabo bino, mwamuŋa eŋono somanya aŋanga galehera aŋo ohubaboneresa nʼabahatonda benywe nʼebirime mu gwanga lyenywe. ");
INSERT INTO nuj_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","Lwahiina muhahanyasa emyoyo jenywe ngʼolu Abamisiri ni habaha waawe bahola? Ne Hatonda wʼAbayisirayiri ni gabanoneresa Abamisiri sibaaleha Abayisirayiri batiina? ");
INSERT INTO nuj_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","“Ŋaahani musune ehigaali ehinyaaha muhisidiheho eŋombe ebiri eji bahama eji batatangaho hijoogi ne enyana jaajo mujiboŋe hu hihongo. ");
INSERT INTO nuj_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","Muŋambe esanduuku ya Musengwa muyite hu higaali ehyo. Muŋambe ebiitu bira ebiri oti mabute agʼezaabbu nʼembeba ejʼezaabbu mubite musaŋu yabyo muhene mubite hu higaali ohulirana esanduuku ya Musengwa. Ni muhenire, muyiseebule etiine. ");
INSERT INTO nuj_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","Era muhene muyiteho emoni ohubona eyi luŋama. Singa yiruŋama engira eyitiina e Bbesi Semesi, nga hutegeera huuti Musengwa njʼobaaye nʼatugudya. Aye singa siyiruŋama eyo nga hutegeera huuti ebiguudyo byatugwira hutugwira.” ");
INSERT INTO nuj_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","NgʼAbafirisuuti bahola ngʼolu babaloma. Nga baŋamba eŋombe ebiri eji bahama bajisidiha hu higaali ngʼenyana bajisidiha hu bihongo. ");
INSERT INTO nuj_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","Nga batengeha esanduuku ya Musengwa hu higaali nʼebbokisi eyaalimo ebibbote ebyʼezaabbu ebyali hyʼembeba nʼamabute agababbota mu zaabbu. ");
INSERT INTO nuj_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","Ngʼeŋombe jisimbuha jiruŋama buterefu jitiina e Bbesi Semesi era sijacaamaho hutiina hu muhono omugooda oba omulungi wayire. Era jatiinanga mu ngira omwo mwosimwosi ni jimoola. Abatangirisi bʼAbafirisuuti bajirondereraho ohwolera erala hu salo ni Bbesi Semesi. ");
INSERT INTO nuj_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","Abaatu bʼe Bbesi Semesi baali mu hiiho ni bahungula engaano. Ni bagangamusa emoni, babona esanduuku eyo, basangaala bugali. ");
INSERT INTO nuj_vpl VALUES ("S16_14","010_6_14","1SA","6","14","14","Eŋombe nga jaŋira ehigaali ehyo mu ndimiro ya Yoswa owʼe Bbesi Semesi nga jemeerera ohulirana ogubaale. NgʼAbaatu babbwaga ehigaali ohusuna ekwi nga basala eŋombe bajiŋonga eyiri Musengwa ngʼeŋongo eyi bohya ehwiye lyaguguliha. ");
INSERT INTO nuj_vpl VALUES ("S16_15","010_6_15","1SA","6","15","15","Abaleevi babbeeda esanduuku ya Musengwa nʼebbokisi eyaalimo ebibbote ebyʼezaabbu ebyali oti hani mbeba nʼamabute agababbota mu zaabbu nga babita hu gubaale. Era hu ludaalo olwo abaatu bʼe Bbesi Semesi baŋa Musengwa eŋongo eyi bohya lyaguguliha ko nʼamaŋongo agandi. ");
INSERT INTO nuj_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","Abatangirisi abataanu abʼAbafirisuuti babona ebyo byosibyosi era hu ludaalo olwene olwo bagamayo Ekurooni. ");
INSERT INTO nuj_vpl VALUES ("S16_17","010_6_17","1SA","6","17","17","Ebibbote ebiri oti mabute agʼezaabbu ebitaanu ebi Abafirisuuti baaŋa Musengwa ohuba eŋongo etusaŋo ebibi byawe, byali birabo ohuŋwa mu baŋugi bʼe Asidodi ni Gaaza ni Asikelooni ni Gaasi ni Ekurooni. ");
INSERT INTO nuj_vpl VALUES ("S16_18","010_6_18","1SA","6","18","18","Era baŋeeresa ebibbote ebiri oti mbeba ebi babbota mu zaabbu ohuŋaayo ngʼeŋongo hu lwʼebibuga ebitaanu ebyaliho olukomera ko nʼebitehere byabyo. Ogubaale ohu baata esanduuku ya Musengwa mu ndimiro ya Yoswa owʼe Bbesi Semesi, lihiririŋo ngʼobujulizi nʼohwola olwa leero luno ohuhahasa ebyo ebyaliŋo. ");
INSERT INTO nuj_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","Aye Musengwa geeta abaatu sanvu abʼe Bbesi Semesi olwohuba balengeesa mu sanduuku yiye. Abaatu balira bugali olwehikangabo ehyo ehi Musengwa gaboosaho. ");
INSERT INTO nuj_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","Ngʼabaatu bʼe Bbesi Semesi bebuusa baati, “Njʼani asobola ohwemeerera mu moni ja Musengwa, Hatonda ono omwawufu gaabaŋo mulamu? Esanduuku yino huyiŋire ŋe?” ");
INSERT INTO nuj_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","Nga batuma abahwenda eyiri abaatu bʼe Kiriyaasi Yeyariimu babalome baati, “Abafirisuuti bagobohiise esanduuku ya Musengwa. Mwihirire mu yibbede muyininieninie muyiŋire mu hibuga hyenywe.” ");
INSERT INTO nuj_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","Ngʼabaatu bʼe Kiriyaasi Yeyariimu batiina baginga esanduuku ya Musengwa. Bayiŋira mu hidaala hya Abbinadabbu ehyali hu lusozi. Nga baabula omusaani wuwe oyu baali ni balanga baati Elyazaali nga bamuŋa omulimo ogwʼohuyirabiriranga. ");
INSERT INTO nuj_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","Esanduuku ya Musengwa, yaali e Kiriyaasi Yeyariimu ohuhena ehiseera hireeŋi, emyaha abiri. Mu hiseera ehyo Abayisirayiri baliririra Musengwa abayeede. ");
INSERT INTO nuj_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","Nga Samwiri aloma Abayisirayiri bosibosi ati, “Ni muba ni muli baheneerefu ohugobola eyiri Musengwa nʼomwoyo mulala, mwetuseho abahatonda aba baatu abandi bajumirya nga pomuli nʼAsitaroosi. Mweŋeereyo erala eyiri Musengwa era muŋeerese nje niye yeŋene, aja hubaŋonia Abafirisuuti.” ");
INSERT INTO nuj_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","Olwʼehyo, Abayisirayiri begaana Bbaali nʼAsitaroosi, baŋeeresa Musengwa yeŋene. ");
INSERT INTO nuj_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","Ngʼaŋo Samwiri aloma ati, “Mulalihe Abayisirayiri bosibosi bahumbaanire e Mizupa, negayirire Musengwa hu lwenywe.” ");
INSERT INTO nuj_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","Bosibosi ni bahumbaanira e Mizupa, nga badaŋa amaaji bagajuha ngʼeŋongo eyiri Musengwa. Hu ludaalo olwo, basiiba era nga benenya baati, “Huholire ebibi mu moni ja Musengwa.” Ebyo byosibyosi byali e Mizupa eyi Samwiri galamuliranga Abayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","Abafirisuuti ni baŋulira baati Abayisirayiri bahumbaaniiye e Mizupa, abatangirisi baawe baahoba eŋe lyawe nga batiina babawaagala. Abayisirayiri ni bategeera baati Abafirisuuti babalumbire beralihirira bugali. ");
INSERT INTO nuj_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","Nga baloma Samwiri baati, “Otalehera aŋo ohweriririra Musengwa Hatonda weefe gahatuŋonia Abafirisuuti.” ");
INSERT INTO nuj_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","Nga Samwiri aŋamba etaama epere eyaali nʼehyoka ngʼayiŋayo eyiri Musengwa ngʼeŋongo eyi bohya lyaguguliha. Galiririra Musengwa hulwa Yisirayiri era nga Musengwa aŋulira ohulira huhwe. ");
INSERT INTO nuj_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","Samwiri ni gaali naŋayo eŋongo eyi bohya lyaguguliha, Abafirisuuti balumba Abayisirayiri ohusoola ni nabo. Aye hu ludaalo olwo Musengwa mu janjaasi eryʼamaani gabbwabbwanuha, ngʼobuti buŋamba Abafirisuuti, nga baduluma Abayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","NgʼAbayisirayiri baŋwa e Mizupa babbinga Abafirisuuti ohwolera erala ŋaasi e Bbesi Kaari ni beeta hwita hiisi oyu bagaananga. ");
INSERT INTO nuj_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","Oluvanyuma lwʼolutalo Samwiri gahomeha ebaale ŋagati wa Mizupa ni Seeni. Ngʼaliguliha esiina ati Ebbeneeza nʼaloma ati, “Musengwa njʼotuyeedire ohwola ŋano.” ");
INSERT INTO nuj_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","Mu engeri hyʼeyo baŋangula Abafirisuuti era ŋabitaŋo ehiseera hireeŋi ni batawaagala Abayisirayiri. Hyali hiityo olwohuba Samwiri nʼahiiriŋo mulamu Musengwa gaata obuhuumi wʼamaani hu Bayisirayiri nʼataganya eŋe lyʼAbafirisuuti hubaŋangula. ");
INSERT INTO nuj_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","Ebibuga byosibyosi ebi Abafirisuuti baali ni baŋambire hu Bayisirayiri ohuŋwa Ekurooni ohwola e Gaasi, babyegobohesa. NgʼAbayisirayiri begobohesa amatwale gaawe ohuŋwa mu mihono jʼAbafirisuuti. Era ŋaaliŋo emiyaaya ŋagati wʼAbayisirayiri nʼAbamooli. ");
INSERT INTO nuj_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","Nga Samwiri geyongera ohulamula Yisirayiri endaalo josijosi ejʼobulamu wuwe. ");
INSERT INTO nuj_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","Hiisi mwaha gatiinanga e Bbeseeri nʼe Gilugaali nʼe Mizupa nʼalamula Abayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","Aye gagamanga e Raama eyi mago gage gaali era yoosi galamula emisango jaayo. Era e Raama eyo, gatongolerayo Musengwa ehituuti. ");
INSERT INTO nuj_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","Samwiri ni gasahuluŋa gataŋo abasaani ohulamulanga Abayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","Esiina lyʼomusaani omudaayi gaali nje Yoweeri, owohubiri gaali nje Abbiya era bombi balamuliranga e Bberuseebba. ");
INSERT INTO nuj_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Aye abasaani sibaali hya saawe. Baali nʼomulungo gwʼebbesa era ehyo hyabaleetera ohulya enguzi, basalanga emisango ni behubbira. ");
INSERT INTO nuj_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","NgʼAbatangirisi bomu Yisirayiri bosibosi bahumbaana batiina ewa Samwiri e Raama. ");
INSERT INTO nuj_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","Nga bamuloma baati, “Osahuluŋire era abasaani babo sibali hyʼewe. Olwʼehyo, tuteereŋo habaha atulamulenga hyʼamawanga agandi ngʼolu gali.” ");
INSERT INTO nuj_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Aye ni baloma baati, “Tuteereŋo habaha atulamulenga,” ehyo sihyasangaasa Samwiri. Olwʼehyo, gebuusa hu Musengwa. ");
INSERT INTO nuj_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Nga Musengwa amuloma ati, “Fugiirira byosibyosi ebi abaatu bahuloma, sibagaane ndiiwe aye bageene ndiise ohuba habaha waawe. ");
INSERT INTO nuj_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Ohuŋwera erala hu ludaalo olu nabatusa e Misiri ohwola hatyane, bakubba omugongo nga baŋeeresa abahatonda abandi era bali huhuhola cʼehyene. ");
INSERT INTO nuj_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Fugiirira ebi bahuloma aye balabule era obalomere ebi habaha aja hubahola.” ");
INSERT INTO nuj_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Nga Samwiri alomera abaatu abaali ni bamusunga ohubaŋa habaha byosibyosi ebi Musengwa galoma. ");
INSERT INTO nuj_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","Ngʼabaloma ati, “Bino njʼebiitu ebi habaha aja hubaŋuga aja hubahola: Aja huŋamba abasaani benywe abengise mu maŋe gage era balala hu bo baaja hufuga ebigaali bibye ebyʼamaŋe, abandi bagendere hu mbalaasi jije nʼabandi baja hutangiririranga mu magaali gage. ");
INSERT INTO nuj_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Abandi baja huba baduumisi ba basirikale lukumi, abandi baduumisi ba basirikale ataanu, nʼabandi ohulima nʼohuhungula ebirime mu ndimiro jije era nʼabandi baja ohubbotanga ebisoosa ko nʼebyoma byʼebigaali bibye ebyʼamaŋe. ");
INSERT INTO nuj_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Aja huŋira abahaana benywe ohumuholeranga ebyahaloosa nʼohumunyiiyiranga emere nʼemigaati. ");
INSERT INTO nuj_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Aliŋamba endimiro jenywe ejʼemizabbibbu nʼejemizayiti ko nʼejindi ejiboneha obulaŋi, gajiŋa abaŋeeresa babe. ");
INSERT INTO nuj_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Era aliŋira hirala ehyʼehumi hu mere yenywe eyʼembehe nʼebibala ebyʼemizabbibbu, gabigabira abahungu nʼabaŋeeresa babe. ");
INSERT INTO nuj_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Aja huŋira abeedu benywe abasinde nʼabahasi nʼabafubuka benywe nasugirya jenywe ejiboneha obulaŋi jimuholere emirimo jije. ");
INSERT INTO nuj_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Era aja huŋira hirala ehyʼehumi ehyʼetaama nʼembusi jenywe. Era enywe mwesi muja hufuuha beedu babe. ");
INSERT INTO nuj_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Ehiseera ehyo ni hiryola, muja hulira ohubanunula mu mihono ja habaha oyu mwetobolera aye Musengwa saaja hubayeeda.” ");
INSERT INTO nuj_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Wayire Samwiri gabalomera ebyo byosibyosi aye sibamuŋulirisa. Baloma baati, “Bbe, efe hwenda habaha anatuŋuge,” ");
INSERT INTO nuj_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","hwenda hube hyʼamawanga agandi ni huli ni habaha atuŋuga era atutangirira mu talo jeefe. ");
INSERT INTO nuj_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Samwiri ni gaŋulira ebibono ebyo byosibyosi ebi abaatu baaloma, nindi gatiina gabiromera Musengwa. ");
INSERT INTO nuj_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Nga Musengwa amugobolamo ati, “Baholere ehi benda, baŋe habaha.” Nga Samwiri aloma Abayisirayiri ati, “Hiisi muutu gagame mu mago gage.” ");
INSERT INTO nuj_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Yaaliyo omusinde omuŋinda era abaatu ni bamuŋa eŋono. Omusinde oyo baali bamulanga baati Kiisi nʼaŋwera mu hiha hya Bbenjamini. Kiisi gaali musaani wa Abbiyeeli, gaaba mwijihulu wa Zerori, Zerori omusaani wa Bbekorasi, Bbekorasi omusaani wa Afiya. ");
INSERT INTO nuj_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Kiisi gaali nʼomusaani oyu balanganga baati Sawulo. Sawulo oyo gaali muŋoono bugali ohuhira abasinde bosibosi mu Yisirayiri era gaali muleeŋi ohuŋwa hu mabega ohutiina ŋamugulu nʼahiraho abandi bosibosi. ");
INSERT INTO nuj_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Lulala, nasugirya ja Kiisi, semwana ya Sawulo jagota. Nga Kiisi aloma omusaani ati, “Tiina nʼomulala hu beedu mwendule nasugirya.” ");
INSERT INTO nuj_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","Nga Sawulo nʼomwidu batiina babita mu Efulayimu ehyalo ehyʼesosi nomu hyalo hyʼe Saalisa ni bendula nasugirya aye sibajibona. Nga batiina bajendula mu hyalo hyʼe Saalimu era yoosi jaŋumayo. Nga batiina mu hyalo hyʼe Bbenjamini era yoosi sibajibona. ");
INSERT INTO nuj_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","Ni boola mu hyalo hyʼe Zuufu nga Sawulo aloma omwidu oyu gaali ni naye ati, “Hwagameyo engo, bbaabba aja huleheraŋo ohuŋemba hu nasugirya abe huhweralihirira ndiife.” ");
INSERT INTO nuj_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","Aye omwidu gamuloma ati, “Bona, mu hibuga muno mulimo omuutu wa Hatonda oyu baatu baŋa eŋono era hiisi ehi aloma hyolerera. Hutiineyo oba olyaŋo gatulomera eyi huŋanga ohujisaŋaana.” ");
INSERT INTO nuj_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","Nga Sawulo amuloma ati, “Singa hutiina, hunamuŋe hi? Emere yituŋoyeho mu saŋu jeefe. Huŋuma hirabo ehi hunaŋirire omuutu wa Hatonda. Hiina ehi huli ni nahyo?” ");
INSERT INTO nuj_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","Ngʼomwidu amugobolamo ati, “Ndiŋo nʼahabbeesa ahʼefeeza. Nja hujiŋa omuutu wa Hatonda gahatulomera engeri eyʼohugendamo.” ");
INSERT INTO nuj_vpl VALUES ("S19_9","010_9_9","1SA","9","9","9","Halehale mu Yisirayiri, omuutu ni gatiinanga ohwebuusa hu Hatonda, bahalomire baati, “Nja hutiine eyiri omuboni abona ebi baatu abandi batasobola hubona,” olwohuba naabbi owa olwa leero bamulanganga baati muboni. ");
INSERT INTO nuj_vpl VALUES ("S19_10","010_9_10","1SA","9","10","10","Nga Sawulo aloma ati, “Ehyo hiraŋi hola hutiine.” Nga batiina mu hibuga eyi omuutu wa Hatonda gamenyanga. ");
INSERT INTO nuj_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","Ni baali ni baniinaniina olusozi ni batiina mu hibuga ehyo, baasaŋana abahaana ni baŋwa mu hibuga ni batiina ohudaŋa amaaji, nga bababuusa baati, “Omuboni aliyo?” ");
INSERT INTO nuj_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","NgʼAbahaana babagobolamo baati, “Aliyo era mweyongereyo mu moni. Mwanguŋeho, ko gahajanga mu hibuga hyefe olwa leero luno olwohuba abaatu bali nʼeŋongo eryohuŋayo mu hifo ehyawufu. ");
INSERT INTO nuj_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","Ni munengire muuti mu hibuga, munamusaŋaane nʼahiiri hutiina mu hifo ehyʼohujumirihisyamo ohulya. Abaatu sibanatandiihe ohulya nʼahiiri hwola olwohuba ateehwa ohusabira eŋongo abageni abalange ko balye. Mutiine esaawa yino munamutuuhire.” ");
INSERT INTO nuj_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","Nga batiina mu hibuga era ni baali ni bengira nga babona Samwiri nʼatula nʼatiina mu hifo ehyohujumirihisyamo. ");
INSERT INTO nuj_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Nʼehibulayo oludaalo lulala Sawulo ko gaaje, Musengwa gaali ahwehuliiye Samwiri ati, ");
INSERT INTO nuj_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","“Olwejo esaawa hya jino, nja huhuŋindihira omusinde ohuŋwa mu hyalo hya Bbenjamini. Mujuheho amafuta afuuhe mutangirisi wʼabaatu bange Abayisirayiri. Aja hununula abaatu bange ohuŋwa mu mihono jʼAbafirisuuti. Mbwene ohubonaabona ohu baatu bange balimo era puliiye ohulira hwawe.” ");
INSERT INTO nuj_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Samwiri ni gahubba emoni hu Sawulo, nga Musengwa amuloma ati, “Oyo njʼomusinde oyu nahulomeeye aja huŋuga abaatu bange.” ");
INSERT INTO nuj_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","Nga Sawulo gagaanana ni Samwiri hu mulyango gwʼehibuga ngʼamuloma ati, “Kusunga wundagirireho omuboni aŋa aba?” ");
INSERT INTO nuj_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","Nga Samwiri amugobolamo ati, “Ndiise omuboni. Tangiriiremo otiine mu hifo ehyʼohujumirihisyamo, oliireho ŋalala ni neese. Olwejo mu mugamba, nja huhulomera ehi huli hu mwoyo ohene wagame. ");
INSERT INTO nuj_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","Oteralihirira nasugirya ejagota endaalo edatu enyuma, jiwonehire. Era kulomera ti emoni jʼAbayisirayiri bosibosi, jiri hu ndiiwe nʼabomu mago genywe.” ");
INSERT INTO nuj_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","Nga Sawulo amugobolamo ati, “Ese ndi wa mu hiha hya Bbenjamini, ehiha ehisingirayo erala ohuba ehidiidiri mu Yisirayiri era amago geefe njʼagahira ohuba aga ŋaasi. Olwʼehyo, lwahiina wundoma otyo?” ");
INSERT INTO nuj_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","Ngʼaŋo Samwiri aŋira Sawulo nʼomwidu wuwe abengisa mu nyumba abeehasa mu moni jʼabageni abaali ni baŋera ngʼadatu. ");
INSERT INTO nuj_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","Nga Samwiri aloma omunyiiyi ati, “Leeta ehifi hyʼenyama ehi kuŋaaye ohubiiha hutulo.” ");
INSERT INTO nuj_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","Ngʼaŋo omunyiiyi aŋamba ehiŋinga hyʼenyama ahitengeha mu moni wa Sawulo. Nga Samwiri aloma Sawulo ati, “Yino nyama yiyo, lya olwohuba bayihutegeheeye olwʼomukolo guno ohuŋwa olu naloma ti ndiŋo nʼabageni abalange.” Nga Sawulo aliira ŋalala ni Samwiri hu ludaalo olwo. ");
INSERT INTO nuj_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","Ni baŋwa mu hifo ehyʼohujumirihisyamo, behirira mu hibuga, nga Samwiri aŋaya ni Sawulo ŋamugulu hu nyumba yiye. ");
INSERT INTO nuj_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","Era Sawulo gaŋenyuhayo. Ni wahya mu mugamba, nga Samwiri alanga Sawulo ŋamugulu hu nyumba yiye amuloma ati, “Wetegehe, nenda huhuseebula, wagame.” Sawulo ni gahena ohwetegeha, niye ni Samwiri nga batula ebulafu. ");
INSERT INTO nuj_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","Ni baali ni baserengeta ni batiina hu butuliro wʼehibuga, nga Samwiri aloma Sawulo ati, “Loma omwidu wuwo atutangiriremo.” Nga yeesi ahola ngʼolu bamuloma. Nga Samwiri aloma Sawulo ati, “Aye ewe sigalaho egongo ŋatotono kulomere obuhwenda ohuŋwa eyiri Hatonda.” ");
INSERT INTO nuj_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Ngʼaŋo Samwiri aŋamba ejaaga yʼamafuta gomu mizayiti agajuha hu mutwe gwa Sawulo ngʼahena amugwa mu hifuba amuloma ati, “Musengwa ahutobooye ohuba mutangirisi wʼabaatu babe Abayisirayiri. Oja huŋuga abaatu babe era oja hubanunula mu maani ga balabe baawe. Hano njahabonero ahahahasa haati Musengwa ahutobooye ohuba mutangirisi wʼabaatu babe.” ");
INSERT INTO nuj_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","Ni hunaseebulane olwa leero, oja hwagaanana nʼabasinde babiri ohuupi nʼehigombe hya Lakeeli e Zeluza mu twale lya Bbenjamini. Abasinde abo baja huhuloma baati nasugirya ejiwendula jibonehire era ŋaahani lataawo saali huŋeega hu nasugirya aye mweralihirifu hu lulwo. Alihwebuusa ati, “Nahole tye omwana wange?” ");
INSERT INTO nuj_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","Oja hutiina woole hu mutumba ogwʼe Tabbori oja hubona abasinde badatu ni batiina e Bbeseeri ohujumirya Hatonda. Mulala hu abo aja huba agingire embusi eperepere edatu, obundi nʼali nʼemigaati edatu, owohudatu aja huba agingire esaŋu yʼehyanjo ni yirimo omwenge gwʼemizamibbu. ");
INSERT INTO nuj_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","Banahuheese bahene bahuŋe emigaati ebiri, ojinaaŋe. ");
INSERT INTO nuj_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","Ebyo ni biŋooye, onatiine hu lusozi lwa Hatonda e Gibbiya ohuli ekambi yʼAbafirisuuti. Nʼonaabe huupi ohwola mu hibuga onagaane ehibbubbu hyʼabanaabbi ni beehirira ohuŋwa enahituuti mu hifo ehyʼohujumirihisyamo ni baŋa obunaabbi era ni bahubba obutongooli nʼetambulini nʼemirere nʼagatongooli. Abanaabbi abo banaabe bahina era ni bembera ŋamugulu. ");
INSERT INTO nuj_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","Omwoyo wa Musengwa anahumaamire oŋe obunaabbi. Oja hufuuha omuutu owenjabulo. ");
INSERT INTO nuj_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Obubonero obwo ni buhena ohubaaŋo, oholanga hiisi ehi Hatonda ahutangirira ohuhola. ");
INSERT INTO nuj_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","Yihirira otiine e Gilugaali. Nja huhwagaanayo ohuŋaayo eŋongo eyi bohya ehwiye lyaguguliha nʼeŋongo eyʼohuleetaŋo emiyaaya. Aye oli nʼohukuuma endaalo musanvu niije kulomere ehyʼohuhola. ");
INSERT INTO nuj_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Sawulo ni gacuuha gahubba Samwiri omugongo amulehe atiine, nga Hatonda acuusa omwoyo gwa Sawulo. Era obubonero wosiwosi nga wolerera hu ludaalo olwo. ");
INSERT INTO nuj_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","Sawulo nʼomwidu wuwe ni boola e Gibbeya, ehibbubbu hyʼabanaabbi hyamwagaana era aŋo ni naaŋo ngʼOmwoyo wa Hatonda amumaamira nʼamaani, ngʼabeŋimbaho muhuŋa obunaabbi. ");
INSERT INTO nuj_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Abaatu abaali ni bamumanyire, ni bamubona nga bebuusa abeene nʼabeene baati, “Hiina ehyolire hu Sawulo omusaani wa Kiisi? Yeesi afuuhire naabbi?” ");
INSERT INTO nuj_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","Mulala hu baatu abaali ni bemereeye aŋo ngʼaloma ati, “Ne semwana yʼabanaabbi abo njʼani?” Ni galoma atyo, nga eyo efuuha endoma ti, “Sawulo yeesi mulala hu banaabbi?” ");
INSERT INTO nuj_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","Sawulo ni gahena ohuŋa obunaabbi, ngʼatiina aniina mu hifo ehyʼohujumirihisyamo. ");
INSERT INTO nuj_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","Nga semwana muto abuusa Sawulo nʼomwidu wuwe ati, “Mubaye muli ŋeena?” Nga Sawulo amugobolamo ati, “Hubaayenga huli mu hwendula nasugirya ja bbaabba. Ni jituhayihise ohubona, nga hutiina ohubona Samwiri.” ");
INSERT INTO nuj_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","Nga Semwana muto oyo amubuusa ati, “Hiina ehi Samwiri ahulomire?” ");
INSERT INTO nuj_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Nga Sawulo amugobolamo ati, “Atulomire nʼatuhahasa ati nasugirya ejihubaaye ni hwendula, jibonehire.” Aye Sawulo sigamulomera hu hyʼohufuuha habaha. ");
INSERT INTO nuj_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Olufanyuma Samwiri gatuma abahwenda ohuloma Abayisirayiri ohwehumbaanihisya e Mizupa mu moni ja Musengwa ");
INSERT INTO nuj_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","ngʼabaloma ati, Musengwa Hatonda wa Yisirayiri aloma ati, “Nabatusa e Misiri nabaŋonia Abamisiri nʼamawanga agandi gosigosi agaali ni gabanyigirisa.” ");
INSERT INTO nuj_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Aye ŋahani mwegeene Hatonda wenywe obaŋonia ebitibbotibbo nʼebiŋeeriŋeeri. Nga muloma muuti, “Tuŋe habaha anatuŋuge. Olwʼehyo, muhumbaane mu moni ja Musengwa hiisi muutu mu gwanga nʼehiha hihye.” ");
INSERT INTO nuj_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Samwiri ni gahumbaania ebiha bya Yisirayiri byosibyosi, nga Musengwa atobola ehiha hya Bbenjamini. ");
INSERT INTO nuj_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Nga nindi Samwiri aleeta egwanga lya Bbenjamini nga Musengwa atobola ehiha hya Maturi. Oluvanyuma nga Musengwa atobola Sawulo omusaani wa Kiisi. Aye ni bahubbahubba emoni, sibamubona. ");
INSERT INTO nuj_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Nga babuusa Musengwa baati, “Ali ŋeena?” Nga Musengwa abagobolamo ati, “Ali mu biitu gehwehire.” ");
INSERT INTO nuj_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Olwʼehyo, baduluma batiina bamwendula era ni bamubona, nga bamutusaayo. Sawulo ni gemeerera mu baatu gaali muleeŋi nʼasinga hiisi muutu owetwihiro. ");
INSERT INTO nuj_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Nga Samwiri aloma abaatu bosibosi ati, “Muweene omusinde oyu Musengwa atobooye? Ŋaŋuma muutu yesiyesi mu baatu bano ali hya niye.” NgʼAbaatu bosibosi bahayaana baati, “Wangaala habaha!” ");
INSERT INTO nuj_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","Nga Samwiri anyonyola abaatu emirimo ja habaha. Era ngʼahena abiŋandiiha mu hitabo, ahibiiha mu hifo ehyawufu. Ngʼaseebula abaatu bagamayo ewaawe. ");
INSERT INTO nuj_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","Nga Sawulo yeesi gagama ewuwe e Gibbeya. Abasinde abʼamaani aba Hatonda gaali nʼacuuhise emyoyo jaawe batiina ni naye. ");
INSERT INTO nuj_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","Aye ŋaaliŋo abasinde abahafuyo abaloma baati, “Omusinde oyo aŋanga ohutununula ohuŋwa mu basigu beefe?” Bamutala era nga bagaana ohumuŋirira ebirabo. Aye Sawulo gaŋoleera huŋoleera. ");
INSERT INTO nuj_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","Ehiseera hyola, nga habaha Nahasi Omwamooni gambuha awaagala ehibuga Yabbesi mu twale lyʼe Giliyaadi. NgʼAbaatu bosibosi abʼe Yabbesi bamuloma baati, “Hola endagaano ni neefe, huja huba ŋaasi wuwo.” ");
INSERT INTO nuj_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","Nga Nahasi Omwamooni abaloma ati, “Nja huhola endagaano ni nenywe kasita mufugiirira ohubomolamo emoni eyohu muhono omulungi, hireetere Abayisirayiri eduho.” ");
INSERT INTO nuj_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","Ngʼabatangirisi ba Yabbesi bamuloma baati, “Tuŋeemo endaalo musanvu hutume abahwenda batiine mu Yisirayiri yosiyosi, singa siŋabaŋo owuuja ohutununula, huuja hweŋaayo mu mihono jijo.” ");
INSERT INTO nuj_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","Abahwenda ni batiina e Gibbeya mu hibuga hya Sawulo balomera abaatu ebifa e Yabbesi. Abaatu ni babiŋulira, bosibosi batemuha babbolooga. ");
INSERT INTO nuj_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","Mu hiseera ehyo Sawulo gaali aŋwa mu ndimiro nʼesaame jije, ngʼabuusa ati, “Higosi hi ehiguuye hu baatu? Lwahiina bali hulira?” Nga bamulomera ebi abasinde abaŋooye e Yabbesi balomire. ");
INSERT INTO nuj_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","Sawulo ni gaŋulira ebibono ebyo, nga Mwoyo wa Hatonda amumaamira nʼamaani ameene amangi, ngʼobusungu bumuŋamba bugali. ");
INSERT INTO nuj_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","Ngʼaŋamba esaame ebiri, ajitematema mu bugusugusu babuŋa abahwenda babuŋira babulaga hiisi muutu mu Yisirayiri ni baloma baati, “Hino njʼehija hwola hu saame jʼomuutu ataja hulonda hu Sawulo ni Samwiri mu lutalo.” Nga Musengwa aleetera abaatu ohutya era nga bosibosi bafuuha hirala. ");
INSERT INTO nuj_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","Sawulo ni gabahumbania abaatu e Bbezeki gabengisa mu maŋe, Abayisirayiri baali emitwalo adatu nʼAbayudaaya emitwalo edatu. ");
INSERT INTO nuj_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","Nga baloma abahwenda batiine balome abaatu bʼe Yabbesi Giliyaadi baati, “Olwejo ko eryuba litandihe ohwohya, banahabanunule.” Ngʼabahwenda batiina balomera abaatu bʼe Yabbesi baatyo, esangaalo lyali huupi hubeeta! ");
INSERT INTO nuj_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","Nga baloma Abamoni baati, “Olwejo huja hweŋaayo eyi muli, mutuhole hiisi ehi mwenda.” ");
INSERT INTO nuj_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","Ni wahya, mu mawiiwi nga Sawulo gabulamo abasirikale babe ebibbubbu bidatu. Nga bengira mu kambi yʼAbamooni nga babatirimbula ohwolera erala esaawa mukaaga ejomu muusi. Abo abaŋunuha, basalaniha hiisi mulala gaŋamba lirye era ŋaŋuma abasigala ni bali babiri. ");
INSERT INTO nuj_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","Ebyo ni byaŋwa, ngʼabaatu batiina eyiri Samwiri bamuloma baati, “Abasinde baliŋe abaloma baati Sawulo saŋanga huba habaha weefe?” Baleete ŋano hubasimye hubasimya. ");
INSERT INTO nuj_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","Aye Sawulo gabaloma ati, “Eŋuma muutu anaafe olwa leero olwohuba olwa leero luno Musengwa anunuuye Yisirayiri.” ");
INSERT INTO nuj_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","Nga Samwiri aloma abaatu ati, “Muuje hutiine e Gilugaali hulangirire ni huhahasa Sawulo ohuba habaha weefe.” ");
INSERT INTO nuj_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","Era ngʼabaatu bosibosi baŋwerehereramo batiina e Gilugaali beehasa Sawulo ohuba habaha mu moni ja Musengwa. Ni baali eyo, mu moni ja Musengwa, baŋayo eŋongo eyʼohuleetaŋo emiyaaya. Era Sawulo nʼAbayisirayiri bosibosi, bahola omukolo nʼesangaalo eryʼamaani. ");
INSERT INTO nuj_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","Ngʼaŋo Samwiri aloma Abayisirayiri bosibosi ati, “Naŋulirisa hiisi ehi mwandoma era nʼabaŋa habaha. ");
INSERT INTO nuj_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","Ŋaahani muli ni habaha ngʼomutangirisi wenywe. Ese njono kulire, ndimo nʼefi era nʼabaana bange mbabano bali ni nenywe. Mbaaye mutangirisi wenywe ohuŋwa mu buvubuka wange ohwola hatyane. ");
INSERT INTO nuj_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","Ndiise ono, mundumirise mu moni ja Musengwa ni nooyo oyu gajuhaho amafuta. Nyagangaho eŋombe yʼomuutu yesiyesi? Njʼani oyu nanyagaho nasugirya yiye? Era njʼani oyu ndyakulangaho? Njʼani oyu nyigirisangaho? Njʼani oyu nalyaho enguzi hyandeetera ohwitaho emoni ni saala omusango? Nja huliŋa ni mba ni nahola hirala hu ebyo.” ");
INSERT INTO nuj_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","Ngʼabaatu bamugobolamo baati, “Bbe sotulyakulangaho, wayire ohutunyigirisa oba ohulya enguzi hu muutu yesiyesi.” ");
INSERT INTO nuj_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","Nga Samwiri abaloma ati, “Musengwa nʼomutobole wuwe nja bajulizi bange hu ebi ndomire olwa leero.” Nga bagobolamo baati, “Ehyo hituufu.” ");
INSERT INTO nuj_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","Ngʼaŋo Samwiri aloma abaatu ati, “Musengwa njʼowatobola Musa ni Alooni era njʼowatusayo abasehulu benywe e Misiri. ");
INSERT INTO nuj_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","Ale ŋahani mwemeerere ŋano maŋoleeye mu moni ja Musengwa mbahebulise ebiraŋi byosibyosi ebi Musengwa abaholeeye enywe nʼabasehulu benywe. ");
INSERT INTO nuj_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","“Yakobbo ni gatiina e Misiri, abasehulu benywe beriririra Musengwa abayeede era nga Musengwa atuma Musa nʼAlooni batusa abasehulu benywe e Misiri babaleeta ohumenya mu hyalo hino. ");
INSERT INTO nuj_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","“Aye abasehulu benywe beebirira Musengwa Hatonda waawe ngʼabaŋayo mu buŋangi wa Sisera omuduumisi wʼeŋe lya Hazori nʼeyiri Abafirisuuti nʼeyiri habaha wʼAbamowaabbu nga babahubba. ");
INSERT INTO nuj_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","Ngʼabasehulu benywe beriririra Musengwa baati, ‘Hwonoonire, huhubbire Musengwa omugongo, huŋeerehiise Bbaali nʼAsitaroosi. Aye ŋahani tununule ohuŋwa mu mihono jʼabalabe beefe, huja huhuŋeeresanga.’ ");
INSERT INTO nuj_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","Ngʼaŋo Musengwa atuma Yerubbu Bbaali ni Bbaraka ni Yefusa ni neese nga abanunula ohuŋwa mu basigu benywe abaali ni babeswanigirihiise enjuyi josijosi, nga mumenya miyaaya. ");
INSERT INTO nuj_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","“Aye ni mwabona Nahasi habaha wʼAbamooni nʼabalumba, nga mundoma muuti, ‘Bbe, efe hwenda habaha ohutuŋuga’ wayire nga Musengwa Hatonda wenywe njʼowaali habaha wenywe. ");
INSERT INTO nuj_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","Ŋaahani, habaha oyu mwatobola njʼono. Mwamusunga era Musengwa gamubaŋa ohubaŋuga. Mumuweene? ");
INSERT INTO nuj_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","Enywe ni habaha wenywe ni munatyenga Musengwa Hatonda wenywe, mwamuŋeeresanga era mwamugonderanga, nandimujeemerenga ebiragiro bibye, ebiitu biija hubatiiniranga bulaŋi. ");
INSERT INTO nuj_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","Aye ni mutagonderenga Musengwa era singa mujeemera ebiragiro bibye, Musengwa aja hubaboneresa ngʼolu gaboneresa abasehulu benywe. ");
INSERT INTO nuj_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","“Ale ŋahani mugume, mubone ehyeŋunjisa ehi Musengwa ali huupi ohuhola. ");
INSERT INTO nuj_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","Sihuli mu ndaalo jʼendobooli? Aye nja husunga Musengwa aleete ohubbwabbwanuha nʼefula. Muja hufaania muuti mwahola hibi hibba ohusunga habaha.” ");
INSERT INTO nuj_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","Ngʼaŋo Samwiri alomba Musengwa era hu ludaalo olwene olwo nga ŋabaaŋo ohubbwabbwanuha nʼefula. Olwʼehyo, abaatu bosibosi batya bugali Musengwa ni Samwiri. ");
INSERT INTO nuj_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","Ngʼabaatu bosibosi baloma Samwiri baati, “Sunga Musengwa Hatonda wuwo atatwita olwohuba ni hwasunga ohutuŋa habaha, hwameeda hibi hu hibi.” ");
INSERT INTO nuj_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","Nga Samwiri abaloma ati, “Mutatya, wayire nga mwahola ehibi ohusunga ohuba ni habaha aye simuhubbanga Musengwa omugongo aye mumuŋeeresanga nʼomwoyo mulala.” ");
INSERT INTO nuj_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","Simujumiryanga ebiitu ebibbote olwohuba biŋuma mahulu. Sibisobola hubayeeda oba ohubanunula mu bugosi olwohuba biŋuma mugaso. ");
INSERT INTO nuj_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","Olwʼesiina lirye, Musengwa saaja hulehaŋo baatu babe olwohuba hyamusangaasa ohubafuula babe. ");
INSERT INTO nuj_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","Aye ese, sihiraŋi ohubbenga mu moni ja Musengwa ohugaana ohubasabira. Era nja hubasomesa ebiraŋi ebyʼohuhola era ebituufu. ");
INSERT INTO nuj_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","Aye mube baheneerefu ohutya Musengwa era mumuŋeerese mu wesigwa nʼemyoyo jenywe josijosi. Muhebulire muuti abaholeeye ebyeŋunjisa ebyene bingi. ");
INSERT INTO nuj_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","Ne ni munagumire hu huhola ebibi, enywe ni habaha wenywe, baja husihiiriha. ");
INSERT INTO nuj_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","Sawulo gafuuha habaha nali nʼemyaha adatu era gaŋuga Yisirayiri emyaha ane nʼebiri. ");
INSERT INTO nuj_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","Sawulo gatobola abasinde ekumi edatu ohuŋwa mu Yisirayiri ohuba basirikale. Abasinde ekumi ebiri baali ni naye e Mikumasi nʼe Bbeseeri ehyalo ehyʼesozi era lukumi basigala ni Yonasaani e Gibbeya mu twale lyʼe Bbenjamini. Abasigalaŋo gabaloma ohwagamayo mu mago gaawe. ");
INSERT INTO nuj_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","Nga Yonasaani awaagala era asihiirisa ekambi yʼAbafirisuuti e Geebba era Abafirisuuti baŋulira amaŋuliro ago. Nga Sawulo aloma abahwenda bafuuŋe egwala abaatu bahumbaane ni babaloma baati, “Leha Ababbebbulaniya baŋulire!” ");
INSERT INTO nuj_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","NgʼAbayisirayiri bosibosi baŋulira baati, “Sawulo awagaaye gasihiirisa ekambi yʼAbafirisuuti era ti ŋahani Yisirayiri esunire obucaayi ohuŋwa eyiri Abafirisuuti.” Olwʼehyo basunga Abayisirayiri ohweŋimba hu Sawulo e Gilugaali. ");
INSERT INTO nuj_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","NgʼAbafirisuuti bahumbaana ohusoola nʼAbayisirayiri. Baali nʼebigaali byʼamaŋe emitwalo edatu nʼabasirikale kakaaga abaali hu mbalaasi ko nʼabasirikale abandi bangi bugali hyʼomujehe gwohwigobo lyʼenyanja. Batiina bahola ekambi yaawe e Mikumasi, ebuŋwalyuba wa Bbesi Aveni. ");
INSERT INTO nuj_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","Abayisirayiri ni babona ebiitu ni biri bibi hu luuyi lwawe era ni bali hunyigirisa eŋe lyawe, nga behweha mu pungulu nomu madeŋo ko nomu mbagaanwa jʼagabaale, nomu maloŋo nomu sobere ejaali ni jiŋumamo maaji. ");
INSERT INTO nuj_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","Ababbebbulaniya abandi baduluma bambuha olwabi Yoludaani batiina e Gaadi nʼe Giliyaadi. Sawulo gasigala e Gilugaali era abasirikale bosibosi aba gaali ni nabo baali muhulebera ekoba. ");
INSERT INTO nuj_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","Sawulo gaali e Gilugaali nʼalindire Samwiri olwohuba gaali amulomire ohumulindaho endaalo musanvu. Aye ngʼabaatu batandiiha ohusalaana. ");
INSERT INTO nuj_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","Nga Sawulo aloma ati, “Mundeetere eŋongo eyi bohya ehwiye lyaguguliha nʼeŋongo eyʼohuleetaŋo emiyaaya.” Nga Sawulo aŋaayo eŋongo eyi bohya ehwiye lyaguguliha. ");
INSERT INTO nuj_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","Gaali gahahenanga ati ohuŋaayo eŋongo eyi bohya lyaguguliha, ngʼaŋo ni naaŋo Samwiri goola, nga Sawulo atiina ohumuheesa. ");
INSERT INTO nuj_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","Nga Samwiri amubuusa ati, “Oholire hiina ehyo?” Nga Sawulo amugobolamo ati, “Mbwene abaatu ni basalaana ate ewe notaaja, nʼAbafirisuuti ni bali huhumbaanira e Mikumasi, ");
INSERT INTO nuj_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","nga mula ndoma ti, ‘Abafirisuuti baja huserengeta banumbe ŋano e Gilugaali ni kiiri husunga Musengwa buyeedi.’ Olwʼehyo, hipalirihiise ohuŋaayo eŋongo eyi bohya ehwiye lyaguguliha.” ");
INSERT INTO nuj_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Nga Samwiri amuloma ati, “Oholire hya buŋubeebe. Ndoŋambe hiragiro ehi Musengwa Hatonda wuwo gahuŋa. Obanga huhiŋamba, gahaŋaaye nʼabejuhulu babo ohuŋuga Yisirayiri emirembe nʼemirembe. ");
INSERT INTO nuj_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Aye ŋaahani obuŋugi buwo sibuja huba bwa sikiranos, Musengwa getoboleeye omuutu omwene oyu genda, aja hutangirira abaatu babe olwohuba ewe soŋambe biragiro bibye.” ");
INSERT INTO nuj_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","Ngʼaŋo Samwiri aŋwa e Gilugaali asomoha e Gibbeya mu twale lyʼe Bbenjamini. Nga Sawulo abala abasirikale abaali ni basigaaye ni naye ni bali lukaaga. ");
INSERT INTO nuj_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","Sawulo nʼomusaani wuwe Yonasaani nʼabasirikale aba baali ni nabo, baali bataaye ekambi yaawe e Gibbeya mu twale lyʼe Bbenjamini, Abafirisuuti nibo ni bataaye ekambi yaawe e Mikumasi. ");
INSERT INTO nuj_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","NgʼAbafirisuuti batusa mu kambi yaawe ebibbubbu bidatu ebyʼabasirikale ohutiina ohunyagulula ebiitu. Ngʼehibbubbu hirala hiŋamba engira hitiina mu Ofura mu twale lyʼe Suwaali. ");
INSERT INTO nuj_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","Ehibbubbu ehindi nga hitiina e Bbesi Horoni. Ngʼehibbubbu ehyohudatu hiŋamba engira hitiina hu lwaha ohulengerera ameeho ga Zebboyiimu nʼotiina mu lulafu. ");
INSERT INTO nuj_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","Mu hiseera ehyo, mu Yisirayiri mwaŋumamo muutu wayire mulala owaali nʼamanyire ohubbota ebisoosa olwohuba Abafirisuuti baloma baati, “Ababbebbulaniya baja hubbota epiima oba amafumo.” ");
INSERT INTO nuj_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","Abayisirayiri ni bendanga ohuŋagala embago ejʼemihono nʼejeŋombe nʼembasa nʼamafumo, babiŋiriranga Bafirisuuti. ");
INSERT INTO nuj_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","Basasulanga ebbeesa enyene enyingi ohuŋagala embago, nʼesuluulu, nʼemisolobyo, nʼemisabbi, nʼembasa. ");
INSERT INTO nuj_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","Olwʼehyo, hu ludaalo olwʼolutalo, ŋaŋuma muutu yesiyesi owaali nʼepiima oba efumo ohutusaho Sawulo nʼomusaani Yonasaani. ");
INSERT INTO nuj_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","Ŋaahani Abafirisuuti baŋindiha ehibbubbu hyʼabasirikale baawe ohuhuuma hu ngira yʼe Mikumasi. ");
INSERT INTO nuj_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","Lulala, nga Yonasaani omusaani wa Sawulo aloma omuvubuka owamugingiranga ebisoosa ati, “Nja husomohe hutiine mu kambi yʼAbafirisuuti.” Aye sigalomeraho semwana. ");
INSERT INTO nuj_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","Sawulo gaali amenya hu butulilo ni Gibbeya ŋaasi wʼomusaala ogu balanga baati omukomamawanga ogwali e Miguroni. Gaali nʼabasirikale lukaaga. ");
INSERT INTO nuj_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","Mu abasirikale abo mwalimo Ahiya owaali ni gambaaye efodi eyʼolugoye olwa laasi. Ahiya oyo gaali musaani wa Ahituubbu muganda wa Yikabboodi omusaani wa Fenekaasi omusaani wa Eli owaali omusengi wa Musengwa e Siilo. Ŋaŋuma owategeera Yonasaani nʼatiinire. ");
INSERT INTO nuj_vpl VALUES ("S114_4","010_14_4","1SA","14","4","4","Hu luuyi nʼoluuyi olwʼengira omu Yonasaani gaali nʼaja hubita ko goole mu kambi yʼAbafirisuuti hwaliho agabaale agaleeŋi. Ogubaale ogundi ni bagulanga baati Bbozezi, nʼogundi baati Seene. ");
INSERT INTO nuj_vpl VALUES ("S114_5","010_14_5","1SA","14","5","5","Ogubaale ogundi gwali mu maniino nʼotiina e Mikumasi, ogundi gwali mu mehiriro nʼotiina e Geebba. ");
INSERT INTO nuj_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","Nga Yonasaani aloma omuvubuka wuwe owamugingiranga ebisoosa ati, “Nja hweŋunguleŋo hutiine mu kambi yʼabatali bahomole, somanya Musengwa gatuŋambiraho. Ŋaŋuma ehiŋanga ohuhaya Musengwa ohununula omuutu, nʼatambisa Abasirikale bangi oba badiidiri ohuŋangula olutalo.” ");
INSERT INTO nuj_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","Ngʼomuvubuka amugobolamo ati, “Hola hiisi ehi huli hu mwoyo, ndi ŋalala ni neewe.” ");
INSERT INTO nuj_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","Nga Yonasaani amuloma ati, “Hola hutiine hwambuhe hwerage Abafirisuuti batubone. ");
INSERT INTO nuj_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","Singa baloma baati, ‘Mutuhuumire eyo ohwola olu hunaaje eyi muli,’ huuja husigala aŋa huli. ");
INSERT INTO nuj_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","Aye singa batuloma baati, ‘Muuje eyi huli,’ nga hutiina olwohuba aho haja huba ahabonero ahalaga haati Musengwa abaŋayeeyo mu mihono jeefe.” ");
INSERT INTO nuj_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","Nga bombi benyoha bemeerera aŋa Abafirisuuti basobola ohubabona. Abafirisuuti ni babalengera nga baloma baati, “Bona, Ababbebbulaniya batulire mu maloŋo omu babaaye ni behwehire!” ");
INSERT INTO nuj_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","NgʼAbasirikale bʼAbafirisuuti baloma Yonasaani nʼomuvubuka owaali nʼebisoosa baati, “Muuje ŋano hubasomese esomo.” Nga Yonasaani aloma omugegi wʼebisoosa wuwe ati, “Nʼondeeho hubalumbe olwohuba Musengwa abaŋayeeyo mu mihono jʼAbayisirayiri.” ");
INSERT INTO nuj_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","Nga Yonasaani ahalambana nʼatambisa emihono nʼamagulu aniina ŋamugulu, nʼoginga ebisoosa nʼamulondaho egongo. Yonasaani gabulungula Abafirisuuti abaŋweranga mu moni wuwe. Ne abagalehanga enyuma ni baguuye, owaginganga ebisoosa njʼowabahenereranga. ");
INSERT INTO nuj_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","Mu hulumba ohudaayi ohwo, Yonasaani nʼowebisoosa bibye, beeta abasinde abiri mu hitundu huupi ehyʼeyiika. ");
INSERT INTO nuj_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","Abafirisuuti bosibosi, abatiinanga ni banyaga nʼabasirikale abaali mu kambi bateetema era ŋaaliŋo ohutya hungi olwohuba Hatonda gaŋindiha musisi gateetemia ehyalo. ");
INSERT INTO nuj_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","Abahuumi ba Sawulo abaali e Gibbeya mu twale lyʼe Bbenjamini babona Abafirisuuti ni baŋwerera embiro ni badulumira mu njuyi josijosi. ");
INSERT INTO nuj_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","Nga Sawulo aloma abasirikale abaali ni naye ati, “Mubale abasirikale mubone abulaŋo.” Ni baabala, bahifaania baati Yonasaani nʼamugegera ebisoosa njʼabaali ni baŋumaŋo. ");
INSERT INTO nuj_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","Nga Sawulo aloma Ahiya ati, “Leeta esanduuku ya Hatonda.” Mu hiseera ehyo, yaali nʼAbayisirayiri. ");
INSERT INTO nuj_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","Sawulo ni gaali nʼahiroma nʼomusengi wa Hatonda nga ohutabujuha hweyongera mu kambi yʼAbafirisuuti. Olwʼehyo Sawulo galoma omusengi wa Hatonda ati, “Otafayo, leha hutiine.” ");
INSERT INTO nuj_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","Ngʼaŋo Sawulo nʼabasirikale babe balumba Abafirisuuti. Bagaana Abafirisuuti ni bagwijeenemo ebyʼamaani, ni basimitana epiima abeene nʼabeene. ");
INSERT INTO nuj_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","Ababbebbulaniya abaali nʼAbafirisuuti mu kambi yaawe, batiina begaata hu Bayisirayiri abaali ni Sawulo ni Yonasaani. ");
INSERT INTO nuj_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","Abayisirayiri abaali ni behwehire mu Efulayimu ehyalo ehyʼensozi ni baŋulira baati Abafirisuuti balihuduluma, nga baŋwa mu byehwehere beŋimba hu bahyawe ohubbinga Abafirisuuti. ");
INSERT INTO nuj_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","Musengwa ganunula Abayisirayiri hu ludaalo olwo era ni baali ni basoola batiina babisyaŋo e Bbesi Aveni. ");
INSERT INTO nuj_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","Abasirikale Bayisirayiri baali banafu olwʼenjala hu ludaalo olwo olwohuba Sawulo galayira ati, “Ehiŋwabo hibe hu muutu yesiyesi ahomba hu hyomu tamu egulo ni lihiiri hwola ni kiiri hwesasusa abalabe bange.” Olwʼehyo, ŋaŋuma owahomba hu hyomu tamu oludaalo lwosirwosi. ");
INSERT INTO nuj_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","Abasirikale bosibosi batiina mwideŋo nga basaŋaana ebiyali byʼomudugere ni gutonya hwiroba. ");
INSERT INTO nuj_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","Aye ŋaŋuma wayire mulala owaguhombaho olwohuba baali batya oweyamo wa Sawulo. ");
INSERT INTO nuj_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","Aye Yonasaani gaali samanyire ati semwana gaali ageene abaatu ohulya ehiitu hyosihyosi. Kale gaŋamba esimbo gatimya mu biyali, gahomba omudugere ngʼaŋo atandiha ohumoga bulaŋi. ");
INSERT INTO nuj_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","Nga mulala hu basirikale amuloma ati, “Lataawo alayiiye ati ‘Ehiŋwabo hibe hu oyo analye emere olwa leero.’ Era cʼehigira abasirikale ni banafuŋire.” ");
INSERT INTO nuj_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","Nga Yonasaani aloma ati, “Laata yange aleeteeye abaatu ebigosi. Mubone ngʼolu ndi humoga bulaŋi olwotudugere otu pwa huhombaho. ");
INSERT INTO nuj_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","Singa abaatu baliyeeho hu munyago ogu basunire ohuŋwa hu Bafirisuuti. Hani Abafirisuuti abafuuye bahali bangi bugali.” ");
INSERT INTO nuj_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","Hu ludaalo olwo oluvanyuma lwʼAbayisirayiri ohwita Abafirisuuti ohuŋwera erala e Mikumasi ohwola Ayijalooni, baŋulira ni badembire. ");
INSERT INTO nuj_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","Olwʼehyo, baŋamba emere eyi banyaga hu Bafirisuuti nga balya. Era beeta etaama nʼeŋombe nʼenyana jʼeŋombe nga balya ni batahenenuyemo nʼamafugi. ");
INSERT INTO nuj_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","Nga ŋabaaŋo owalomera Sawulo ati, “Bona, abaatu balihubbenga mu moni ja Musengwa ni balya enyama eyirimo amafugi.” Nga Sawulo aloma ati, “Ehyo hibi bugali! Muŋiringisye ogubaale muguleete ŋano.” ");
INSERT INTO nuj_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","Ngʼaloma ati, “Mutiine eyiri abaatu mubalome muuti, ‘Hiisi muutu aleete eŋombe nʼetaama mujiisalire ŋano, mujirye. Mutabbenga mu moni ja Musengwa ni mulya enyama eyi hirimo amafugi.’ ” Ngʼowiire owo hiisi muutu aŋira esaame yiye ngʼayisala. ");
INSERT INTO nuj_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","Nga Sawulo atongolera Musengwa ehituuti. Era ogwo, njʼogwali omulundi omudaayi ohuhola atyo. ");
INSERT INTO nuj_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","Ebyo ni byaŋwa, nga Sawulo aloma ati, “Muhole hwihirire huwaagale Abafirisuuti owiire buno hubanyagulule paka mu mugamba era hubeete hutalehaŋo kadi mulala.” Nga bamugobolamo baati, “Hola hiisi ehi onabone oti njʼehiraŋi.” Aye omusengi wa Hatonda galoma ati, “Muhole hwebuuseho hu Hatonda.” ");
INSERT INTO nuj_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","Olwʼehyo, Sawulo gebuusa hu Hatonda ati, “Tiine numbe Abafirisuuti onabaŋeyo mu mihono jʼAbayisirayiri?” Aye Hatonda sigamugobolamo hiitu hu ludaalo olwo. ");
INSERT INTO nuj_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","Nga Sawulo aloma abaduumisi bamaŋe ati, “Muuje ŋano enywe abatangirisi bamaŋe hufaanie ehibi ehi huholire olwa leero. ");
INSERT INTO nuj_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","Mu butuufu oweene ngʼolu Musengwa ali njʼOmwene Bulamu aŋa Yisirayiri obuŋangusi, nolu anaabe nje Yonasaani omwana wange, ali nʼohufa.” Aye ŋaŋuma wayire mulala owamusimula. ");
INSERT INTO nuj_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","Nga Sawulo aloma Abasirikale bosibosi ati, “Mwemeerere hu luuyi olwo, ese ni Yonasaani huja hwemeerera hu luuyi luno.” Nga bagobolamo baati, “Hola ehi obona oti njʼehiraŋi.” ");
INSERT INTO nuj_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","Nga Sawulo alomba Musengwa Hatonda wa Yisirayiri ati, “Lwahiina ndiwungobolemo olwa leero?” Husunga otulomere njʼani omubbengi. Mwana wange Yonasaani, ndiise oba abaatu babo Abayisirayiri? Nga ahalulu hagwa hu Yonasaani ni Sawulo, nga ehyo hyejereesa Abayisirayiri abandi ");
INSERT INTO nuj_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","Nga Sawulo aloma ati, “Muhubbe ahalulu ŋagati wange ni Yonasaani musaani yange.” Ni bahubba ahalulu, hagwa hu Yonasaani. ");
INSERT INTO nuj_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","Nga Sawulo aloma Yonasaani ati, “Ndomere ehi oholire.” Nga Yonasaani amulomera ati, “Kombireho omudugere mutotono guuti ni tambisa esimbo yange. Ŋaahani ndi nʼohufa!” ");
INSERT INTO nuj_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","Nga Sawulo aloma ati, “Hatonda gangudye nʼobuhambwe singa Yonasaani soofa!” ");
INSERT INTO nuj_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","Aye ngʼabaatu baloma Sawulo baati, “Sihusobola huganya Yonasaani ohufa olwohuba njʼoleteeye Yisirayiri ohuŋangula etalo! Bbe. Mu butuufu ngʼolu Musengwa ali njʼomwene bulamu, ŋaŋuma wayire lufiiri oluuja ohuŋwa hu mutwe gugwe olwohuba ehi aholire olwa leero ahiholire olwʼamaani ga Hatonda.” Olwʼehyo nga balehula Yonasaani bamuŋonia ohufa. ");
INSERT INTO nuj_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","Nga Sawulo alehera aŋo ohulonda hu Abafirisuuti era nga bagamayo e waawe. ");
INSERT INTO nuj_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","Oluvanyuma lwa Sawulo ohufuuha habaha wa Yisirayiri gasoola nʼabalabe babe abo bosibosi abaali hiisi ŋaatu: Abamowaabbu nʼAbamooni nʼAbedomu nʼabahabaha ba Zoobba nʼAbafirisuuti. Era hiisi aŋa gacuuhiranga, gabaŋangulanga. ");
INSERT INTO nuj_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","Gasoola hisira hyene gaŋangula Abameleki, ganunula Abayisirayiri ohuŋwa mu mihono jʼabo ababawaagalanga. ");
INSERT INTO nuj_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","Abasaani ba Sawulo baali mbaba: Yonasaani ni Yisivi ni Malukisuwa. Omuhaana wuwe omuhulu gaali nje Mirabbu era omuŋere gaali nje Mikaali. ");
INSERT INTO nuj_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","Omuhasi wa Sawulo gaali nje Ahinowaamu omuhaana wa Ahimaazi. Omuduumisi wʼeŋe lirye gaali nje Abbuneeri omusaani wa Neeri. Neeri gaali muŋere wa semwana wa Sawulo. ");
INSERT INTO nuj_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","Kiisi semwana wa Sawulo ni Neeri semwana wʼAbbuneeri bombi baali basaani bʼAbbiyeeli. ");
INSERT INTO nuj_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","Mu biseera byʼobuŋugi wa Sawulo byosibyosi, gaali mu huŋiriŋana nʼAbafirisuuti. Olwʼehyo, Sawulo ni gabonanga omuutu owʼamaani oba omusira, gamuŋambanga gengira eŋe lirye. ");
INSERT INTO nuj_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Lulala, Samwiri galoma Sawulo ati, “Ndiise oyu Musengwa gatuma ohuhujuhaho amafuta ofuuhe habaha wa Yisirayiri. Olwʼehyo, ŋuliirisa obuhwenda ohuŋwa eyiri Musengwa. ");
INSERT INTO nuj_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Musengwa Omwene Maŋe aloma ati, ‘Nja huboneresa Abameleki olwohuba basoosa Abayisirayiri ni baali ni baŋwa e Misiri. ");
INSERT INTO nuj_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Ŋaahani lumba ere wiite Abameleki osihiirise hiisi ehi bali nahyo. Otaleha hiitu hyosihyosi, yiita abasinde nʼabahasi nʼabaana era osihiirise eŋombe nʼetaama nʼeŋamiya ni nasugirya.’ ” ");
INSERT INTO nuj_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Ngʼaŋo Sawulo alanga abasirikale babe bahumbaanira e Telayimu ngʼababala. Abasirikale abohu magulu ohuŋwa mu Yisirayiri baali emitwalo abiri, nʼabasirikale omutwalo mulala ohuŋwa mu hiha hya Yuda. ");
INSERT INTO nuj_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","Nga Sawulo nʼabasirikale babe batiina mu hibuga hyʼAbameleki, babeteegera mu hiiho. ");
INSERT INTO nuj_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","Nga Sawulo aloma Abakeeni ati, “Muŋweŋo mulehe Abameleki tabasihiirihisa ŋalala ni nabo olwohuba mwalaga Abayisirayiri bosibosi ehyere ni baŋwa e Misiri.” Olwʼehyo, ngʼAbakeeni baŋwaŋo baleha Abameleki. ");
INSERT INTO nuj_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Ngʼaŋo Sawulo awaagala Abameleki ohuŋwa e Kavira ohwola e Suuri, ebuŋwalyuba wʼe Misiri. ");
INSERT INTO nuj_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Gaŋamba Agagi habaha wʼAbameleki gamuŋira mulamu ngʼasihiirihisa erala abaatu babe bosibosi nʼepiima. ");
INSERT INTO nuj_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Aye Sawulo nʼeŋe lirye nga basaasira Agagi nʼetaama nʼeŋombe ejaali ni jiboneha obulaŋi nʼenyana jʼeŋombe ko nʼetaama ejasava, hiisi hiitu ehyali ehiraŋi. Ebyo sibabisihiirisa ohutusaho basihiirihisa erala hiisi ehyali hiniambiniambi. ");
INSERT INTO nuj_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Ngʼaŋo Musengwa aloma Samwiri ati, ");
INSERT INTO nuj_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","“Nehebulisa lwahiina nafuula Sawulo ohuba habaha olwohuba gapooyeho era saholera hu biragiro byange.” Ehyo hyadambya Samwiri era galiririra Musengwa owiire owo wosiwosi. ");
INSERT INTO nuj_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Mu mugamba pwipwipwi Samwiri genyoha ngʼatiina eyiri Sawulo. Aye ni goolayo bamulomera baati, “Sawulo atiinire e Karumeeli, eyo atongoyeeyo ehyʼohumuhebuliriraho olwʼohuŋangula Abameleki gahena gatiina e Gilugaali.” ");
INSERT INTO nuj_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Samwiri ni goola nga Sawulo amuloma ati, “Musengwa ahuŋe ekabi! Kolire ehi Musengwa gandoma.” ");
INSERT INTO nuj_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Nga Samwiri amuloma ati, “Ne ohubbalala hwʼetaama nʼohumoola hwʼeŋombe ohupulira hubaaye huutye?” ");
INSERT INTO nuj_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Nga Sawulo amugobolamo ati, “Ejo abasirikale bajituhise hu Abameleki, babuyeemo eŋombe nʼetaama ejisingirayo erala obulaŋi ohujiŋongera Musengwa Hatonda wuwo. Aye husihiirihisye ebindi byosibyosi.” ");
INSERT INTO nuj_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Nga Samwiri amuloma ati, “Ŋoleera. Leha kulomere ebi Musengwa gandomire mu hiire ehihyehiise olwa leero.” Nga Sawulo amuloma ati, “Ndomere.” ");
INSERT INTO nuj_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Nga Samwiri amuloma ati, “Wayire waali webona oti ŋaŋuma ehi oli, Musengwa gahutobola gahufuula habaha wʼebiha bya Yisirayiri. ");
INSERT INTO nuj_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Ngʼahena ahutuma nʼahuloma ati, ‘Tiina osihiirihise erala abahosi bʼebibi abo, Abameleki, basoose ohwola olu oja hubasihiirisa obahenereŋo erala.’ ");
INSERT INTO nuj_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","Lwahiina siwagondeye Musengwa? Lwahiina waluluhaniiye ebyayo wereetera ohuhola ehibi mu moni ja Musengwa?” ");
INSERT INTO nuj_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Nga Sawulo amugobolamo ati, “Ese nagondeye Musengwa era nahola omulimo ogu gaatuma. Nasihiirihisa erala Abameleki, naŋamba habaha Agagi namuleeta. ");
INSERT INTO nuj_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Abasirikale baaŋamba etaama nʼeŋombe eji banyaga mu lutalo ejiboneha obulaŋi bajireete ŋano e Gilugaali ohuŋongera Musengwa Hatonda wuwo.” ");
INSERT INTO nuj_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Aye Samwiri gamugobolamo ati, “Oŋeega oti Musengwa asangaalira eŋongo eri bohya ehwiye lyaguguliha nʼebirabo aye ehi ahira ohwenda ohumugondera. Ohumugondera hihira ohuŋaayo etaama ejamasavu. ");
INSERT INTO nuj_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Ohujeemera Musengwa hibi era hiri hyʼohuhola ebyʼobufumu nʼohuba mutengu hiri hyʼojumirya ebibbote. Era olwohuba ojemeeye ehiragiro hya Musengwa, yeesi ahutuhiseeho owahabaha.” ");
INSERT INTO nuj_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Ngʼaŋo Sawulo aloma Samwiri ati, “Hituufu mbengire. Ndipambe hiragiro hya Musengwa nʼohulaabbira huhwo. Tiiye abasirikale natiinira hu byawe. ");
INSERT INTO nuj_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","Ŋaahani kwegayirira soniŋe ebibi byange, ogoboleŋo nahajumirya Musengwa.” ");
INSERT INTO nuj_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","Nga Samwiri amugobolamo ati, “Sinja hwagama. Ojemeeye ehiragiro hya Musengwa era yeesi ahutuhiseeho hu wahabaha wa Yisirayiri.” ");
INSERT INTO nuj_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Samwiri ni gaali nʼacuuha aŋweŋo, Sawulo gafuhumira ehiganduula hihye nga hidyebuuha. ");
INSERT INTO nuj_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Nga Samwiri amuloma ati, “Musengwa ahumamuyeho owahabaha wa Yisirayiri olwa leero era gabuŋa muliranwawo, omuutu owundi ahuhira ewe. ");
INSERT INTO nuj_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Oweŋono Hatonda wa Yisirayiri simuutu ti anadulinge oba ohucuusa ebiŋeego bibye.” ");
INSERT INTO nuj_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","Nga Sawulo amuloma ati, “Mbengire aye kusunga otaswasa mu moni jʼabatangirisi bʼabasirikale nʼAbayisirayiri, hwagameyo ni neewe njumirye Musengwa Hatonda wuwo.” ");
INSERT INTO nuj_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","Ngʼaŋo Samwiri gagamayo ni Sawulo nga Sawulo ajumirya Musengwa. ");
INSERT INTO nuj_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","Nga Samwiri aloma ati, “Mundeetere ŋano Agagi habaha wʼAbameleki.” Nga Agagi aŋwayo mula nʼaŋeega ati, “Sibasobola hunjita ŋaahani. Ebyo byaŋooye.” ");
INSERT INTO nuj_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","Aye Samwiri gamuloma ati, “Ngʼolu obaayenga nʼoleetera abahasi ohufiirwa abaana baawe, ni maawo yeesi aja huŋuma mwana.” Nga Samwiri geetira Agagi mu moni ja Musengwa e Gilugaali. ");
INSERT INTO nuj_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Ngʼaŋo Samwiri ahena atiina e Raama aye Sawulo niye gatiina mu mago gage e Gibbeya ehibuga hya Sawulo. ");
INSERT INTO nuj_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Enaku yaŋamba Samwiri olwa Sawulo aye sigagobolayo humuhubbaho moni nindi ohwola olu gafa. Era Musengwa gehebulisa olwʼohufuula Sawulo habaha wa Yisirayiri. ");
INSERT INTO nuj_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Lulala Musengwa galoma Samwiri ati, “Olyosa ŋeena ohweŋunamira olwa Sawulo? Mutuhiseeho owahabaha wa Yisirayiri. Yiijusa olwiga amafuta, oŋambe engira otiine e Bbeserekemu ewa Yese. Tobooye mulala hu basaani babe ohuba habaha.” ");
INSERT INTO nuj_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Aye Samwiri gamuloma ati, “Natiine tye? Ni hinahagwe Sawulo mu hutwi, aja hunjita!” Nga Musengwa amuloma ati, “Tiina nʼesodi yʼeŋombe, olome oti, ‘Nijire ohuŋa Musengwa eŋongo.’ ");
INSERT INTO nuj_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Onahalome Yese abeŋo hu mukolo ogwʼohuŋayo eŋongo, nahahulage ehyʼohuhola. Onahajuhe amafuta hu oyo oyu nahahulage.” ");
INSERT INTO nuj_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Samwiri gahola ehi Musengwa gamuloma. Ni goola e Bbeserekemu, abatangirisi bʼehibuga ni bamubona, bateetema. Era nga bamubuusa baati, “Wuujire lwʼobulaŋi?” ");
INSERT INTO nuj_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Nga Samwiri abagobolamo ati, “Lwʼobulaŋi. Nijire ohuŋa Musengwa eŋongo. Mwegwalaase muuje mu neŋimbeho mu huŋayo eŋongo.” Ngʼaŋo agwalaasa Yese nʼabasaani ngʼahena abaniirisa hu mukola ogwʼohuŋayo eŋongo. ");
INSERT INTO nuj_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Ni boola, nga Samwiri alengera Eliyaabbu, ngʼaŋeega ati, “Mu butuufu, omusinde ono owemereeye mu moni ja Musengwa, njʼoyu atobooye.” ");
INSERT INTO nuj_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Aye Musengwa ngʼaloma Samwiri ati, “Otafa hu mboneha yiye oba obuleeŋi wuwe, ese mugeene. Musengwa sabona ngʼolu abaatu babona. Abaatu babona byahu mugulu aye Musengwa alengera ehiri mu mwoyo.” ");
INSERT INTO nuj_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Ngʼaŋo Yese alanga Abbinadabbu, abita mu moni ja Samwiri. Aye Samwiri gamuloma ati, “Era wayire njʼono Musengwa samutobole.” ");
INSERT INTO nuj_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Nga Yese aleeta Saama, nga Samwiri amuloma ati, “Wayire njʼoyo, Musengwa samutobole.” ");
INSERT INTO nuj_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Yese gaŋira abasaani babe omusanvu babita mu moni ja Samwiri. Ne Samwiri gamuloma ati, “Mu abo paamo oyu Musengwa atobooye.” ");
INSERT INTO nuj_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Olwʼehyo, Samwiri gabuusa Yese ati, “Bano njʼabasaani babo aba oli ni nabo boŋene?” Nga Yese amugobolamo ati, “Ehisigaayeyo naakoma ne ali hwemera etaama.” Nga Samwiri amuloma ati, “Tuma bamuleete, sihunehale ohwola olu anaaje.” ");
INSERT INTO nuj_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Ngʼamutumisa bamuleeta. Gaali afaana bulaŋi era nʼali muŋoono. Ngʼaŋo Musengwa aloma Samwiri ati, “Yinyoha omujuheho amafuta. Oyo nje niye.” ");
INSERT INTO nuj_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Nga Samwiri aŋamba olwiga olwijuuye amafuta ngʼamujuhaho nʼabalebe babe ni babona. Era ohuŋwa hu ludaalo olwo, ngʼOmwoyo wa Musengwa geeha hu Dawudi ngʼabanga ni naye mu bulamu wuwe. Ngʼaŋo Samwiri gagama e Raama. ");
INSERT INTO nuj_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Ŋaahani Omwoyo wa Musengwa gaali aŋooye hu Sawulo ngʼomwoyo omubi ohuŋwa ewa Musengwa gumugudyanga. ");
INSERT INTO nuj_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","Abaŋeeresa ba Sawulo bamuloma baati, “Bona, omwoyo omubi ohuŋwa ewa Hatonda ali huhugudya. ");
INSERT INTO nuj_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Leha musengwa yeefe, alagire abaŋeeresa babe bendule omuutu am