﻿USE sofia;
DROP TABLE IF EXISTS sofia.ntu_vpl;
CREATE TABLE ntu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ntu_vpl WRITE;
INSERT INTO ntu_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Mzli kc tqngi trgalr king r Israel, kzdq kc ncblo drtqde Elimelek, nide nqvi lr Efrata, x mnc Betleem mz nrlarnrlc kc Judz, nidr mz olvz rde, drtqde Naomi, x mrlxdr nzling, drtqdr Malon x Kilion. Mzli lcde tao kc dzbi mrkc Israel, murde trpnzngr tewa. Mz nzmu-krde lcde, nzvzng mz kandre kc Moab mz nzmnc-krpwzlr elr. ");
INSERT INTO ntu_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Kx nzmncng kc Moab, Elimelek sc tqbzszpele Naomi x mrlxde kcng nzling. ");
INSERT INTO ntu_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Zbz mrlxdeng nzyrlzng rlilrdrng Moab. Kilion yrlztile Opa x Malon yrlztile Rut. Nzmnctilr Moab yiz nzpnu-esz'. ");
INSERT INTO ntu_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Zbz mzle-lzbq lcng, Malon x Kilion nzbz-kzng elr. Mzli lc Naomi trpengr ncblo ngrde x trpe-kzngr mrlxde. ");
INSERT INTO ntu_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","7","Mz nibr kzdung mzli, Naomi xlrle kx Yawe okatr-moule lr Israel mz nzrka-kr-mopwzle nzkqlukr dakxnzng. Kx xlr Naomi nrpa lc, sc tzoliqpeng badr lvxbqde kcng nzling, nzvz-krdr badr Israel. X sc tzrkalzpemqng. ");
INSERT INTO ntu_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","A' mzli lcde, Naomi tekqtr-moule drtwrde, x sc tqrpipebzle mz Opa x Rut kx, “Yzlutx-mouamu mz ma nyzmu badr lxemung. X krka'-ngrne kx Yawe namrlztile nimu da kc tqwaisr-ngrnamu ncblo ngrmung x ninge. ");
INSERT INTO ntu_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","X naokatrle nimu mz nzmnc-zpwx-krmu badr ncblo kx nangi mou ncblo ngrmung.” Zbz sc tqtcngitipeng Naomi x sc tzyrni-katopeng badr. ");
INSERT INTO ntu_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","X nzrpibzlr bade kx, “Trtingr, navzbzku mz lr mrnyzmqng.” ");
INSERT INTO ntu_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","A' rpibz Naomi kx, “Bzkq vz-nqblqmamu ninge, kx inyxngeng. ?Murde nike naokatr-ngrne nimu? ?Ninge la narmika-moux doa ncblo kx nangi ncblo ngrmung? ");
INSERT INTO ntu_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Yzlutxpeamu mrnyzmung. Murde nipenge blang mz nzryrlzti-moungr kzdq ncblo. X kxmule-esz' yrlzti-moux dq ncblo kcma mz nrlckxbq x rnginegr doa ncblo, ");
INSERT INTO ntu_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","a' rblxbz bamu nzaenzli-krmu nidr, vz vz mzli kx nznginidr ncblo x sc tqyrlzti-ateamu nidr. Da amrlx rblxm bange myaszlzle nzrblx-krbz da bamu. Murde Yawe atrkatile ninge mz zmatq ngrde. Bzkq vz-nqblqmamu ninge, murde da amrlx ma tqrblx-kzpz bamu.” ");
INSERT INTO ntu_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Mz nzycmne-krbzle lc, sc tzyrnipe-moung. Zbz Opa tcngitxde lvxbqde x sc tqarlrpele. A' Rut lolvz-amqngile Naomi, x tr-rlaszleu nide. ");
INSERT INTO ntu_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Rpibz Naomi bade kx, “Obqbz, ilem yzlupebz mz kxnginideng x mz gct ngrdrng. Yzluamu rlirmu.” ");
INSERT INTO ntu_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","A' rpibz Rut kx, “Bzkq rtulrtr-ngrme nzaki-lzbq-krgi o nzrlasz-krnge nim. Murde drlve ke navzkiq, navzki. X drlve ke namnc-ngrn, namncki. X lr mrnyzm, nangi kz lr mrnyznge. X Gct rm, nangi kz Gct rnge. ");
INSERT INTO ntu_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Drlve ke nabz-ngrn, nabz-kzx elr x nayrtzmq-kznge elr. Nzmu kx tqrlaszx nim, Yawe na-ayrplapx-zlwzle ninge. Nzbzngr txpwz kx na-aki-lzbq-ngrgi.” ");
INSERT INTO ntu_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Naomi kx krlztr-zpwxpebzle kc mz Rut nzsuti-zlwzkr drtwrde nzvz-krdr ncdr, sc tqmetxpebz x trycmnepepwzu bade. ");
INSERT INTO ntu_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Olvz lcng nzling nzvzng nzvzng mzli kx nzkrlz-ngrbzlr mztea Betleem. Kx nzkaputrpzlr kc Betleem, lr mztea kc sc tzabrtzlvzpelr nidr x tzyrlwrlvzpelr nidr. Olvz lr mrkc sc tzrpipelr kx, “Doa lcng, Naomi yzlupem!” ");
INSERT INTO ntu_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","A' rpibz Naomi badr kx, “Bzkq rpimamu ninge Naomi, murde drtwr ngr Naomi ‘mrlzvxi.’ A' kqle-ngrmamu ninge Mara, drtwr ngrde ‘rblx.’ Murde Gct kc Tqaclvele da amrlx batrple nzrblxkr da amrlx bange. ");
INSERT INTO ntu_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Murde mz nzvz-krgr kc kqlukr, a' mz nzvzmi-mou-krpqng Yawe lc ninge, vz-nrbalqpemc. Delc bzkq rpi-ngrmamu ninge Naomi kxmrlzvxi. Murde Yawe kc Tqaclvele da amrlx aetqpemle drtqnge, mz nzrpi-krde kx vz-rbrx.” ");
INSERT INTO ntu_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Krlc be angidr ngr Naomi mz nzyzlu-krmle Moab nidr mz lvxbqde Rut, kc tqngi olvz lr Moab. Nzkaputrpqng Betleem mz zbq kc kai tzrkqngr nra nabr kc tqngi bali mz nzbrpe-krde. Nra bali nzkqti-txpwzle zbq tq o pwx. ");
INSERT INTO ntu_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Mzli lcde, kzdq kc ncblo drtqde Boas mnc Betleem. Nide bcnyr x Naomi krlzle nide murde ngi kxngini ncblo ngrde. ");
INSERT INTO ntu_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Mz zbq kzble mz nourla, Rut rpibzle mz Naomi kx, “Rlr-ngrm bange nzvz-krnge mz lclr bali. Mwx kzdq ncblo kxmrlz sa na-abrtzlvzle nzrmikatine-krnge drpwr nra bali kxyrlwrtxo mrnyzde.” Rpibz Naomi bade kx, “Vz inyxnge, sa tqmrlz ye.” ");
INSERT INTO ntu_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Zbz Rut kc tqvzpe tqrmikatipe drpwr nra bali kx nzrlasztipe leplz kxnzawzng. Mz lclr bali lc, kzdung leplz nzrpakilzmqng bali, x kzdu-kzng leplz nzvz-nqblqlr nidr mz nztalvz-krdrleng. X mz nibr nzrtwz-krdr rtalvz kcng, nzkrlz leplz nzrmikatingr nra bali kxyrlwrtxo. Mz zbq lcdepwz, sc tqkrlztipele kx lclr bali kc nyz Boas. ");
INSERT INTO ntu_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Mz nourla lcdepwz, Boas rkalzm Betleem x kaputrpz mz lclr bali nyzde. X sc tqrpipebzle mz kxnzawz nedeng amrlx kx, “Nimu la.” X nzayzlu-ngrbzlr natqde kx, “Nim la.” X rpi-mopwzle kx, “Rlxtibo mz Yawe kx naokatrle nimu.” X nzrpi-kzpzlr kx, “X nim kz!” ");
INSERT INTO ntu_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Boas kc tqveapebz mz ncblo kc tqaclvele kxnzawzng, rpibzle kx, “?Doa olvz lcmonr ne neke?” ");
INSERT INTO ntu_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Rpibz ncblo kc kx, “Krla doa olvz lr Moab, kx nzvzmqng mz Naomi, mz nzyzlu-krmle kc Moab. ");
INSERT INTO ntu_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Rpimle bange kx, ‘?Nzmu rlr-ngrme bange nzrmikatine-krbo nra bali mz nibrdr kxnzawzng?’ X sa tqbrngzti-zpwxle nzrmikatingr nra bali abzo-pnzle kcma mz nourla, x sa tqvzbe. A' amapx-ngrmle matelq mzli kx mrbcne.” ");
INSERT INTO ntu_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Zbz sc tqrpibz Boas mz Rut kx, “Lalztqm bange, kx inyxnge. Rpix naokatrpo nim. Bzkq rmikatiq nra bali mz nrlc nyz ncblo kzble x bzkq rlaszq mrka. A' mncamu badr olvi kxnzawz nengeng. ");
INSERT INTO ntu_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Mcpwz mrkc tzrpakingr ncblo lcng bali, x nim kc tqrmikanebzme mz nibr olvi kcng tzrtalvzng. Pipebo badr ncblo lcng kx bzkq nzesotrpzng bam. X drtwrm kx tqbrlxkzle, vz, x rmnqtr mz belue kcng tzangqbatipe ncblo kcng.” ");
INSERT INTO ntu_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Zbz, Rut yrngzobz bade mz drtc' mz nzamrluengr. X sc tqrpipebzle kx, “?Memule tqmrlzti-zlwz-ngrn ninge x tqamrlue-ngrn ninge? Murde ninge olvz lr narnrlc.” ");
INSERT INTO ntu_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Ayzlu-ngrbz Boas natqde kx, “Da amrlx kcng tqalebzme mz lxem Naomi, mz nibr nzbzkr mrlxde kc tqngi ncblo ngrm, nzyapwxtipem bange bq mz nibr nzkaputr-krmamu. X kxmu nzrlasz-krme trtem x lxem x mrnyzm, x vzme mz nzmnc-krmu badr leplz kx nqmq krdr blepx. ");
INSERT INTO ntu_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Rlxtibo mz Yawe, Gct rgr, kx na-ayzlubzle bamu nike aletiqng, mz nzamrlz-zlwz-krde nim. Nide ka tqmnclzpebzme bade mz nzvz-krme lc, x nide me rlakitrq, mz nzapu-krm nei kio kx mnclzbz mz nabx lxede.” ");
INSERT INTO ntu_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rpibz Rut kx, “Trtenge, yc zlwz mz drtwrm ninge. X awxopeme nabznge mz nzycmne-nivzlrpe-krme lc bange, kxmule-esz' trmatqnewxu myaszlzle olvi nem kcng tzwztrpzng bam.” ");
INSERT INTO ntu_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Mzli kc namupengr bea, rpibz Boas mz Rut kx, “Vzm namupeku. X leo kz bret nam mz waen lc pipz.” Mzli kc Rut tqwxbutr-ngrbzle mz olvi kcng, Boas kabzle bade kcng bali kx nztqngq, mz nzapusr-krde nide kxmnctrpz bade. Rut mu x nelzde krlc. X nade kcng ycpwz. ");
INSERT INTO ntu_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Mzli kc Rut tqvz-ngrde mz nzrmika-mou-krde nra bali, rpibz Boas badr ncblo nedeng kx, “Nzmu kx tqrmika-abeanetrpzle me yrlwr ngr rtalvz ngr bali, bzkq amyabzmu drtqde, murde rlr-ngrbo bade. ");
INSERT INTO ntu_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","A' vecpxbzmu du bali mz rtalvz ngrde kx namikatile x bzkq lclvzbzmu.” ");
INSERT INTO ntu_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Rut rmika bali mz lclr bali lc vz-krlzbzle milzpq. Zbz sc tqtalqtipele drpwr bali kcng tqmikatile. Nulvzole mz bxli x yrbulzm. X bxli lc takitr kilo kx nzpnu-esz'-nrade-tq. ");
INSERT INTO ntu_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Zbz sc tqglqpele bali kc mz mztea, x Naomi mcle bxli r bali kc etu tqglqmle. X ka-kzpz Rut dakxnzng kcng tqmutr-ngrde mzli kc bea. ");
INSERT INTO ntu_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Naomi rveabz kx, “?Mzbq ka drlve kc tqrmika-ngrn bali? Krka'-ngrne kx Gct na-amrlzle ncblo kc tqokatrle nim.” Zbz sc tqpipebz Rut mz lxede kx, “Drtq ncblo kc tqngi nyzde lclr bali kc tqwz-ngrne kcma, Boas.” ");
INSERT INTO ntu_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Rpibz Naomi bade kx, “Eu, rlxtibo mz Yawe kx na-amrlzle nide. Murde tresakiu nzbatr-krbzle nzrmrlznr-krde leplz kxnzlubeng x kxnzbzpeng. Ncblo la tqngi Boas, ngi kzdq kxnginigu kx takitrde nzxpepx-krde drtc' nyzgu x nzaopx-krde nqvi lr ncblo ngrgu.” ");
INSERT INTO ntu_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Zbz rpi-mopwz Rut kx, “Boas rpi-kzple bange kx, ‘Mncamu badr kxnzawz nengeng nakrlz-zpwxbzle nzyrkrpxkr nzrkqngr bali x wit.’” ");
INSERT INTO ntu_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Naomi rpibzle kx, “Inyxnge, mrlzvxitx nzvzne-krmu badr olvi nedeng, murde ma tzatrkam mz nrlc nyz ncblo kzble, mz nzngini-krm lr narnrlc kx esz'trpz badr.” ");
INSERT INTO ntu_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Mz zbq kang kqlu, Rut sc tqmnctr-zvzbz badr olvi kxnzawz ne Boas, mz nzrmikati-krde, vz vz mzli kx yrkrpxngr nzrkqngr bali x wit. X nzmncpwzng mz lvxbqde Naomi. ");
INSERT INTO ntu_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Mzli lcde, rpibz Naomi mz lvxbqde kx, “Inyxnge, mzli ka namcpo dq ncblo kx nayrlztiq. Kx na-amncle nim brma x na-aclvele nim. ");
INSERT INTO ntu_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Rmikatiq bali vz-nqblqq olvi kcng tzwztrpzng mz Boas. X krlzq nzngini-krde kxnginigu. Koma mz nrlckxbq sa na-akipxle be bali mrkc tzrtaklrpxngr nra bali. ");
INSERT INTO ntu_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Kipotx x aeluti-lzbq tolo kx ngi pzpium. X pxingr lrpzm kxmrlz, x vz mrkc tzrtaklrpxngr nra bali. A' bzkq krlztile nzmnc-krm mrlcde, mzli kc tryrkrpxkangr nzmu-krde x nzrmnq-krde waen. ");
INSERT INTO ntu_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Aokztipwz mrkc navzkile mz nzmwi-krde. X mzli kc tqmwipe-ngrde, vz-kzpz x kalvxlzbz lrpz kc tqkq-ngrde, x ayrbq-lxlr-ngrbz nanycde x sc tqmnztrpebzme mz nanycde. X mzli kc nabaongr nanycde, sa nadwalzm x napibzle da kx na-aleq.” ");
INSERT INTO ntu_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rpibz Rut kx, “Sa na-alex nikeng pitime.” ");
INSERT INTO ntu_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Zbz Rut kc tqvzope mrkc tzrtaklrpxngr nra bali, tqalepele da amrlx kcng tqpibz lxede. ");
INSERT INTO ntu_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Mz nibr nzmukr Boas x nzrmnq-krde, drtqde otxpx. Sc tqvzkiopebzle mz nrlarde kc tzayrlwrngr nra bali, tqmnzope mz nzmwipengr. Mzli trboiu Rut kc tqprngeipebz mrkc tqmwingr Boas. Kalvxlzbzle lrpz mrkc tqobqkio nanycde x sc tqmnzlzpebz elr. ");
INSERT INTO ntu_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Mzli kcpe mz aurnrlc Boas dwalzm sc tqyzplrpe, x tqmcpele kzdq olvz nzmnzlz-krbzle mrkc tqobqkio nanycde. ");
INSERT INTO ntu_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Boas kc tqveapebz kx, “?Nim neke?” Rpibzle kx, “Ninge kxnzawz nem Rut. Kawxpx lrpz la x akq-bubz ninge, nangi rkx kx suti drtwrm nzyrlzti-krm ninge. Murde nim kx kxnginigr kx takitrde nzxpepxngr drtc' nyzgr x nzaopx-krbzle nqvi lr ncblo rnge.” ");
INSERT INTO ntu_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Rpibz Boas kx, “Krka'-ngrne kx Yawe na-amrlzle nim, kx inyxnge. Murde nzaodu-krm lc mz nzsutikr drtwrm nzaopxngr nqvi lr Malon mz nzyrlzngr lc, myaszlzle nzaodu-krm kc kai, mz nzvz-krmamu mz lvxbqm. X tr-rtangrwq nrpr kztem, nzmu kxrngisc o kxtr-rngiscu, a' mcpxpeq ninge. ");
INSERT INTO ntu_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Mzli ka, kx inyxnge, bzkq drtwrm li. Sa na-alebo da kcng amrlx tqrlxtiq. Leplz amrlx mz mztea ka nzkrlzlr kx nim olvz angidr kxmrlzvxi. ");
INSERT INTO ntu_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Da zpwxtx, ninge kxnginim kx takitrde nzale-krnge da lc. A' kzdq kc ncblo kx ngi kxnginigu kx esotr-zlwzbz bam myaszpxle ninge. X nide kx na-alele da lc, nzmu kx tqaolvzlele. ");
INSERT INTO ntu_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","A' mwi txpwz mrka mz nrlckxbq ka. X sa naycmne-krlzpwzkr bade mz nourla. Nzmu kx tqrpile nayrlztile nim, mrlz. A' nzmu kx tqpx-ngrdele, esalz-ngrbo bam mz drtq Yawe kx tqlu, kx nayrlztipex nim. Mnzpwz mrlc nakrlzbzle mzli kc tqprtz-ngrm paglxnrlc.” ");
INSERT INTO ntu_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Rut mwilzbz mz nanycde krlzbzle mzli lcde, mzli lc trnzrglxkangr leplz. X Boas rpile mz nide esz'-krde kx, “Bzkq kx rkrlzti nzmnckr olvz lc mrka.” ");
INSERT INTO ntu_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","X rpi-kzpzle bade kx. “Aolz nzkq scm kc tqrmnrtr-ngrbz x prlxo mrlc.” Prlxtxole x yrngiobz Boas elr bali nzkqlu-krde esolzbz mz kilo kx nzpnu-tq (30). Petxbz Boas x sc tqglqlzpebzle mz nabx Rut, x sc tqvzpe mz mztea. ");
INSERT INTO ntu_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Mzli kc Rut tqkrlz-ngrbzle brma, Naomi sc tqveapebz kx, “?Myx kxmu mz nzvz-krm kc, kx inyxnge?” Zbz sc tqpipebzle da kcng amrlx tqalebz Boas bade. ");
INSERT INTO ntu_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","X rpi-kzpzle kx, “Boas ka-kzple bali lc tqtwzmc, x rpimle bange kx, ‘Bzkq vz-nrbalqbzme mz lxem, a' twzbz bali lc bade.’” ");
INSERT INTO ntu_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Zbz sc tqrpipebz Naomi kx, “Inyxnge, aenzlipwz. Bzkq nabzm talvzo. Murde Boas nzmu trmnc-nrwx-ngru mzbq ka kx tqmnc-nrwxpe-ngrde da tubqpe.” ");
INSERT INTO ntu_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Mz nourla lcde, Boas vz mz naobz ngr taon lc x sc tqwxbupe elr, murde krlc me nzatubqtingr lrtzlvz ngrdr da. X kxnginide kc tqesotr-zlwzbz, krkc tqpibzle mz Rut, sc tqmcpele nzvz-krde. X sc tqkqlepxpele nzrpi-krbzle kx, “Vz-kaip mrka, kx mzlenge, x wxbu kai mrlc.” Ncblo kc vzbz, sc tqwxbupe. ");
INSERT INTO ntu_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Zbz Boas kapxmle lrtzlvz nzpnu-esz' kx nzmncng mrlcde. X rpibzle badr kx, “Nawxbuku ena x okatrpa'mu nigr.” ");
INSERT INTO ntu_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Zbz Boas sc tqrpipebzle mz mzlede lc kx, “Naomi kc tqyzlupem Moab, sc tqamwale drtc' nyz mzlegu Elimelek. ");
INSERT INTO ntu_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Vzdzm mz drtwrnge nzpi-krbole bam. Kx tqsuti drtwrm nzxpengr drtc' lc, e xpe mzli ka tzmncngr lrtzlvz ngrgu lcng, badr mrlx lcng. Kx tqsuti drtwrm naxpepxqle murde nayzlu-mop mz nqvi lrgu, ale. A' nzmu kx trtingrde, pim bange, murde trpnzngr kx takitrde nzxpepxngr drtc' lc, a' nim txpwz, x krali ninge.” X ayzlubzle natqde kx, “Sa naxpepxbo.” ");
INSERT INTO ntu_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Rpi-mopwz Boas kx, “Mzli kc naxpepx-ngrbzme drtc' lc mz Naomi, yrlzti kz Rut kc Moab, olvz r mzlegu kc tqbz. Murde mrlxmu ncdr Rut kalr nalolvzle drtc' nyz Malon kc tqbz x nqvi lrde bzkq mztr.” ");
INSERT INTO ntu_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Rpibz mzlede lc kx, “Mz nzmu-krde lcde, trpengr nzxpepx-krnge drtc' lc, murde ma tqamnctxpxle ninge x trpnzngr da kx na-aprcbo mz mrlxngeng. A' xpepxpe, murde trtakitrpepleu ninge.” ");
INSERT INTO ntu_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","8","X sc tqkapxpele sadol scde tqkapebzle mz Boas. Murde mzli kc tqprtzngr da lc, nqmq kr lr Israel mz nzxpepxngr x nzaprcngr dztu, kxmule sele. Kzdq ncblo nzmu kapxle sadol scde x kabzle mz mrlx kztede, aelwapx-ngrde kx drtwrdr rlilrdr esz'ti mz nike nzaolvzlr. ");
INSERT INTO ntu_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Boas sc tqycmnepebz mz lrtzlvz x leplz kcng mrkc, mz nzrpi-krbzle kx, “Mzbq ka mcpeamu x xlrpeamu kx sa naxpepxbo mz Naomi drtc' nyz Elimelek kc tqbzszbzle mz mrlxdeng Kilion x Malon, kcng tzbzpe-kzng. ");
INSERT INTO ntu_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","X nayrlzti-kzx Rut kc Moab tqbzsz Malon, nangi olvz rnge. Murde mrlxgr kc kai ncdr Rut kalr nalolvzle drtc' nyz Malon x nqvi lrde bzkq mztr, a' drtqde nadcpxpwz mz mztea nyzgu. Mzbq ka sc tqmc-lxblrpeamu.” ");
INSERT INTO ntu_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Zbz lrtzlvz x leplz amrlx kcng tzmncng mz naobz nzrpibzlr kx, “Eu, sc tqmc-lxblrpekr. X krka'-ngrgr kx Yawe nangi-batrpzle mz olvz kc nayrlztiq nzrngine-krde doa kxkqlu mz nzapu-krde Resel x Lea kcng tzakqlunepxlr lr Israel. X nanginim bcnyr x namatq-esz'-ngrn Betleem. ");
INSERT INTO ntu_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","X krka'-kz-ngrgr kx doa kx nakabz Yawe bam, navzpxmqng mz olvz lc, nakqlu-zlwzng na-apule doa neng melrmqgu Peres, mrlx Judz badr Tama, lr mrkzble.” ");
INSERT INTO ntu_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Zbz Boas sc tqyrlztipele Rut. Nzmwi-lxblrng x okatr Yawe nidr mz nzyrkr Rut. X rmika nede doa ncblo. ");
INSERT INTO ntu_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Nzrpibz olvz kcng tzmncng mrkc mz blrkq mrlx Rut kx, “Naomi, takitrde nzrglqlzngr Yawe, murde rkabz nem doa ncblo mzbq ka. Krka'-ngrgr kx doa lc nakrlzti lr Israel nide. ");
INSERT INTO ntu_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","X rlxtibzkr mz Yawe kx doa ncblo lc na-aelalzmle drtwrm x naokatrle nim mzli ka nzngini-krm blang. Murde lvxbqm, kc tqmrlzti-zlwzle nim mikale nide. X kxmule-esz' narnginem doa ncblo kxnzkqlung, a' nzokatr-krdr nim trmyaszpxleu nzokatrkr Rut lc nim.” ");
INSERT INTO ntu_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Naomi brlcle doa kc. Zbz sc tqokatrpele Rut nzabutingr. ");
INSERT INTO ntu_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Olvz lr Betleem nzrpilr kx, “Naomi nepede kc doa ncblo.” X nzyrlqbzlr drtqde Obed. Obed lc nide kc tqngi trte Jesi kc tqngi trte King Devet. ");
INSERT INTO ntu_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Krlc nqvi lr ncblo kx vzpxm mz Peres. Peres mrlxde Hesron. ");
INSERT INTO ntu_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hesron mrlxde Ram, Ram mrlxde Aminadab. ");
INSERT INTO ntu_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab mrlxde Nason, Nason mrlxde Salmon. ");
INSERT INTO ntu_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmon mrlxde Boas, Boas mrlxde Obed. ");
INSERT INTO ntu_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obed mrlxde Jesi x Jesi mrlxde Devet. ");
INSERT INTO ntu_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Nzmnc-zpwxngr trvzpxpuu mz nzvz-nqblqngr nqmq kr kxdrka'-ngrng, X nztu-ngrbz mz lrpzki nyz kxnzaleng alwx. X trvzpxpuu mz nzprtr-ngrbz mz kxnzxtrnga-ngrdr Yawe. ");
INSERT INTO ntu_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","A' nzabrtzngr angidr lc vzpxm mz drtwr kx elalzm mz nzvz-nqblqngr Loukxtr sc Yawe, X mz nzaoti-zvzkr drtwr natqde ngrlx x nrlckxbq. ");
INSERT INTO ntu_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Leplz lcng nzapulr nounc kcng dzbrdr tzkrlzobzlr lue, X leu rdr trnzbloung. X nzdo-zlwzng mz nzvz-krm nrpr angidr. Da kx nzalelr nradr yc-zvzbz. ");
INSERT INTO ntu_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","A' kxdrka'-ngrng trnzwailru. Nzapulr leu kxglr kcng tztakitrpwzlr nzngcngr. ");
INSERT INTO ntu_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Delc trnatu-amqngi-ngrdru mzli kc na-ayzlu-ngrbz Gct da mz leplz. X trnaprtrpwzung mz kxnztubqng. ");
INSERT INTO ntu_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Murde lrpzki rdr tutr me nzayrplapxngr. A' Yawe aclvebzle nzti r leplz kxnztubqng. ");
INSERT INTO ntu_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Lr mrkzbleng nzngqngung mz nzngyatikr drtwrdr Yawe. Murde mane nzyrlqtingr drtwr mz nzatrkatingr nide. ");
INSERT INTO ntu_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","King rdrng x kxnzrmailz rdrng nzyrlwr-lxblrng Mz nzoliqti-krdr nzota-krdr badr Yawe x Kxnzmcpx nede. ");
INSERT INTO ntu_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Nzrpilr kx, “Na-axtxbzku nzmnclz-krbzku mz zmatq ngrdr, Mz nznikitx-krgu nqvi kc tzpe-ngrdr nigu, murde drtqgu naopx.” ");
INSERT INTO ntu_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","A' King Yawe kc tqmncom Heven yrpalelvzle nidr, X xtrnga-ngrde drtwr kcng tzyrlqlr. ");
INSERT INTO ntu_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Ycmne-zngyabz badr, X nzmwxlr-ngrdr natqde kxpq. ");
INSERT INTO ntu_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Murde rpile kx, “Yrlqpex King kc tqmcpxpex Jerusalem Mrkc Saeon, newz kxtr nyznge.” ");
INSERT INTO ntu_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","X King kc tqmcpx Gct, rpile kx, “Napibo nike pim Yawe bange. Rpimle kx, ‘Nim Mrlxnge, abzo mzbq ka, sa na-aelwapx-ngrbo mz leplz nzngini-krnge Trtem. ");
INSERT INTO ntu_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Rlxtim bange x sa nakabo bam zmatq ngr nzaclvengr neidung amrlx, Murde leplz mz nrlc tulvzo nangi nemqng. ");
INSERT INTO ntu_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Sa na-aovxioq mrnyzdr mz nzxplr-zlwz-krm, Kc na-apule bz kc tqrniglc botol.’” Natq kx pibz Yawe mz Mevalu nede delcng. ");
INSERT INTO ntu_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Delc nimu king x kxnzrmailzng mz nrlc nayrplapxamu, X nalalztq-angidramu, mzli ka tqycbe-ngrbz mzli. ");
INSERT INTO ntu_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Narnrctrpzmu mz nzamrlue-krmu Yawe, X mz nzwztr-krbzmu bade. ");
INSERT INTO ntu_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Yrngzobzmu mz Mrlxde, Murde ma tqodatile nimu, Mz zngya ngr drtwrde kc tqwou. A' nimu amrlx kcng tzrlatrpzng bade, sa namnc-zpwxamu. ");
INSERT INTO ntu_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Nabz ne Devet, kc tqyrle mzli kc tqdwasz-ngrde mrlxde Absalom. Yawe, enqmi rngeng nzkqlu-zlwzng, X nztutitr zvz nardr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Nzrpilr mz nzyapwxti-krdr ninge kx, “Gct trtxpnzngr nzokatr-krde nide.” ");
INSERT INTO ntu_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","A' Yawe, nim kx mnc-ngale-zvzle ninge. Nim nou nzaovxio-krnge x nim kx apqtrp drtwrnge. ");
INSERT INTO ntu_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Delc tqrlxti-ngrbo nzokatr-krm ninge, X ayzluome natqnge mz newz kxtr nyzm. ");
INSERT INTO ntu_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Murde namwi-angidrx mz nrlckxbq x melz-mopwc' mz nourla, Mz nzaclve-angidrq ninge. ");
INSERT INTO ntu_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Kxmule-esz' nztu-ngalelvzlr ninge siu ngr enqmi, A' trtxpnzngr nzmwxlr-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Murde krka'-ngrne kx, “Yawe, Gct rnge, vzm arlapx ninge, X katxpxbz zmatq ngrdrng.” ");
INSERT INTO ntu_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Yawe, nim nou nzarlapxngr, X da kxmrlzting amrlx kabzme mz leplz nemqng. ");
INSERT INTO ntu_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Nabz ne Devet. Gct, ayzlum nzkrka'-krnge, Murde dwaki-zvzme bange. X mzli kc tqkxpu-ngrne, okatrq ninge. Delc naycngr mz drtwrm ninge x naxlr-ngrme natqnge. ");
INSERT INTO ntu_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","?Nimu leplz, myx mzli kx naesakingr nzatrkati-krmu nzmyalz-krnge? ?X myx mzli kx naesakingr nzmrlzkr bamu da kx ngi brmrda x nzpokiangr? ");
INSERT INTO ntu_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Murde nakrlzamu kx Yawe mcpxle nigr leplz kxnztubqng kx nanginedeng. X mzli kc nakrka'-ngrbo bade, sa na-ayzlumle natqnge. ");
INSERT INTO ntu_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Bzkq nabztq ngr nelzmu mailzle nimu mz alwx. A' na-aoti drtwrmu nqmq krmu mz nzyrbq-lrpi-krmu mz nelvq nyzmu mz nrlckxbq. ");
INSERT INTO ntu_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Zbz na-abrtrpzmu drtwrmu bade, X nakabzmu bade blz, mz nzvz-nqblq-krgu natq kc tqkapxmle bagu. ");
INSERT INTO ntu_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Yawe, leplz nemqng nzkqlung kx nzrpimlr bange kx, “?Myx mzli kx namnc-zpwx-ngrgu?” Delc tqkrka'-ngrbo kx na-amrlzq nigr. ");
INSERT INTO ntu_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Murde mzli kc tqamrlz-ngrn ninge, abrtz-zlwzx Myaszpxle nzabrtzkr leplz kx dakxnzng nadr x waen mqdr kqlu. ");
INSERT INTO ntu_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Mzli kc tqyrbq-ngrne, mwi-angidrx mz nrlckxbq, Murde nim kx aclve-zpwxle ninge. ");
INSERT INTO ntu_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","2","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Yawe, nim King x Gct rnge. Rlxtibo bam kx naxlrme natqnge, X na-aoti kz drtwrm, mz nzatutr-krm nzkrka'-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Kxetu, mz nourla kang kqlu natqnge sa navzbz bam. X nakrka'-zvzbo bam, mz nzaenzli-krbo natqm kxmrlz. ");
INSERT INTO ntu_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Yawe, trnginipqu Gct kx abrtzlvzle da kxtrka. X trmnc-lxblrwamuu mz kxdrka'-ngrng. ");
INSERT INTO ntu_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Leplz kx nzglqpx-lzbqng trtxpnzngr nzmnctr-krbzlr bam, Murde rblxbz mz leplz kx mrlz-zvzbz badr nzale-krdr alwx nztutr-krbzlr mz mzpq. ");
INSERT INTO ntu_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Odatiq kxnzpokiang, X obqszo-zvzq kxnzrnibqng x kxnzesabrting. ");
INSERT INTO ntu_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","A' mz nzaodu-zvz-krm, delc navztr-ngrne Mangr-nzangiongr nim, X nayrngzobo mz nzamatqngr nim. ");
INSERT INTO ntu_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Yawe, mailz ninge mz nqmq krm kxtubq, murde enqmi rnge nzkqlu-zlwzng. X aelwa-zpwx-ngrm bange me pnz drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Da angidr trvzpxpuu mz nao enqmi rngeng. Murde mz nabzdr la nzodatingr txpwz. X mz nzycmne-krdr nzmailzlr leplz Mz nzbatr-krbzlr nzbz-krdr esz'-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Gct, plzpx alwx ngrdr x ayrplapx nidr, Mz nzprtz-mou-krdr mz trtxki scdr. Mapulrpxngr nidr mz nzkqlukr alwx ngrdrng, Murde nzpxtxpx-zvz-ngrdr nim. ");
INSERT INTO ntu_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","A' leplz amrlx kcng tzabrtrpzlr drtwrdr bam na-abrtzng. X nangr-along mz nzelalz-krm drtwrdr. Aclve-angidr kxnzmrlztilr nim Murde nabilvzlr nim. ");
INSERT INTO ntu_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Yawe, amrlz-zvzq kxnztubqng. X nivz lrm o-ngalelvzle nidr Mz nzapu-krde temz ngr lomrdr kc tqyrputrngr nipna. ");
INSERT INTO ntu_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Yawe, kxmule-esz' drtwrm ngya, A' bzkq pnanatiq x ayrplapxq ninge. ");
INSERT INTO ntu_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Kxetu, nayc mz drtwrm ninge murde yangrngapex. X axplr mou nrkrdrtqnge murde yagox-zlwzx. ");
INSERT INTO ntu_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","?Rnrcti-lzbqtrpo bam mz zmwxlr, X aenzli-alopex nzokatr-krm ninge? ");
INSERT INTO ntu_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Yawe, tekqtr drtwrm x arlapx ninge, Mz nzaodu-krm kc tqyc tqyc. ");
INSERT INTO ntu_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Murde mz nzbzngr trpengr nzrglqlzngr nim. X mz gq nzangiongr nim kc tqyrkrpxpebz. ");
INSERT INTO ntu_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Drtqnge mewepe mz nzkrka'-zvz-krbo bam. X mz nrlckxbq kang kqlu, nqni x pilo pnrnge nzlrpr-ngrdr drle mzke'. ");
INSERT INTO ntu_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Mzke' vaotxtrpebz x tropxpeu, Murde nzyrni-krnge lc nzngi-batrplr enqmi rngeng. ");
INSERT INTO ntu_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Nimu leplz kxdrka'-ngrng amrlx, dwaszpeamu ninge! Murde Yawe sa tqlalztqpem mz nzyrni-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Xlrpemle nike rlxtibo, X sa na-ayzlumle natqnge. ");
INSERT INTO ntu_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Krka'-ngrne kx drtq enqmi rngeng namya x narnrcti-lzbq-kzng mz zmwxlr, X naplc-aning mz nzaovxio-krnge nidr. ");
INSERT INTO ntu_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Nabz ne Devet, kx ngr-ngrbzle mz Yawe, mzli kc Kus, ncblo ngr nqvi lr Benjamin, tqatrkati-ngrde nide. Yawe, Gct rnge, arlapxbz ninge mz mq ncblo kcng tzayotilr ninge. Murde nim me rlakitrx. ");
INSERT INTO ntu_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Murde ma tzkivztibzlr nrkrdrtqnge mz nzapu-krdr laion, X nzkilznedr ninge me trpnzngr kx naokatrle ninge. ");
INSERT INTO ntu_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","?Yawe, Gct rnge, nike ale-rbrx? ?Mqnge alele dq da kxtrtubqu? ");
INSERT INTO ntu_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","?Myx kxmule, alebo dq da kxtrka mz kztengeng? ?O atrkatix dzbede negrng mz nzarlapx-krnge enqmi rgrng? ");
INSERT INTO ntu_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","Nzmu kx tqmule lcde, sa tqmrlz nzrlr-krbzme ninge mz mq enqmi rngeng, Mz nzmaneuti-krdr ninge mz nzapu-krdr kuli x nzlolvz-krdr ninge. X natabrtilr ninge x narnzbrtiolr ninge mz drtc', X na-ayrbqtxdr namz rnge elr. ");
INSERT INTO ntu_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Yawe, tumilzm zngya x aesaki leplz kcng tzngyati drtwrdr ninge. Okatr ninge murde yrlqpeq mzli r nzpipx-krm nztubqkr leplz amrlx o nzvz-rbr-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Ayrlwr leplz mz nrlc tulvzo murde natu-ngalelvzlr nim, Mz nzaclve-krm nidr Heven. ");
INSERT INTO ntu_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Yawe, nim kx rpibz mz leplz kx nztubqng o nzvz-rbrng. Pipxbz mz leplz kx mnctr-zpwxpebo bam murde nabznge opx x tubq. ");
INSERT INTO ntu_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Aesaki nqmq krdr kxdrka'-ngrng x tu-zvzbz mz nibr kxnztubqng. Murde nim kxtubq-esz'ngr x obqplxq nabz x nzvzkr nardr. ");
INSERT INTO ntu_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Gct kxmyatxlz, nim temz ngr lomrnge kc tqyrputrngr nipna. X arlapxq krkcng nabzdr tqlq. ");
INSERT INTO ntu_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Tubqq mz nzryrlq-krm drtwr. X pipxq kx takitrde nzayrplapxngr kxnzvz-rbrng. ");
INSERT INTO ntu_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","13","Nzmu kx trnztekqtrlru nqmq krdr kxtrka, sa nayrlamzq toki r vea scm, X nalalvzq popz' scm mz nzpnz-krm nidr mz nipna kxngc. ");
INSERT INTO ntu_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Kxdrka'-ngrng nzpetilr rtq da kxtrka. X lvclzm nc nzodatingr. X nrade yrlqbzle ngi nzpokiangr. ");
INSERT INTO ntu_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Trtxki kc tzamwiti-ngrdr leplz, Sa naprtz-mou-ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Drtwr ngr nzkxpungr kcng tzesabrti-ngrdr leplz, sa nangq-moulr nidr. X nzodangr kc tzalelr sa naetq-moungr drtqdr. ");
INSERT INTO ntu_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Nangrx mz nzglqlz-krnge Yawe kc tqmyalz-esz'ngr! X na-awibo bade murde tubq-esz'ngr! ");
INSERT INTO ntu_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Yawe, nim Kxetu rgr. Drtqm myalz-esz'ngr mz nrlc tulvzo. X nzmyalz-krm myaszlzle bongavz. ");
INSERT INTO ntu_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Mz nzvz-nqblq-krde me pnz drtwrm, doa kxnztopwzng nzglqlzlr nim. X natqdr ailvzole nzrpibqtikr enqmi rmqng x awx-nabule nidr. ");
INSERT INTO ntu_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Kxrpalz, mzli kc tqobqlz-ngrne mz bongavz, Mclzx nzlulikr temz x vri kcng tqwz-ngrnqng. ");
INSERT INTO ntu_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","?A' memule tqmatq-ngrgr mz drtwrm? ?X memule tqmrlzti-ngrn nigr leplz txneng? ");
INSERT INTO ntu_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Murde wz-ngrn leplz vzo kxpipz mz lr Heven, X kabzme badr zmrlue x nzamatqngr. ");
INSERT INTO ntu_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Yrlqq nidr mz nzaclve-krdr da kcng tqwz-ngrn, X da amrlx nzyclzbzng mz zmatq ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Nzaclvelr animol krbzq, X animol kzpeto kz. ");
INSERT INTO ntu_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","X nidr kxnzetung r utc x nc, X da amrlx kx nzwrneng prla. ");
INSERT INTO ntu_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Yawe, nim Kxetu rgr, Drtqm myalz-esz'ngr mz nrlc tulvzo. ");
INSERT INTO ntu_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Awi Yawe! Naglqpx-atwrnr-ngrne nim. Ale-zvzq da kcng tzkctipxng, x napipxxng. ");
INSERT INTO ntu_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Angrlvzx drtqm. Bilvzx nim kc tqmyalz-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Brngzvxitx nzyzlukr enqmi rnge mz nzmc-krde nim. Bz x tao-ngrde nzulrm. ");
INSERT INTO ntu_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Clvetio-lzbqx x rpiq kx tubqx. Clveq leplz amrlx mz nzwxbuo-krme mz tron, x ayzlu-ngrbzme da badr. ");
INSERT INTO ntu_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Dalr nrlc nzmailzlr kxdrka'-ngrng. Delc napnanati-ngrn nidr x Drtqdr na-amrbrtx-alobzme. ");
INSERT INTO ntu_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Doa ngr alwx lcng nzyrkrtrpeng. Enqmi rngeng trpengr nzdcpx-krdr mz drtwr leplz x mztea nyzdr amznrpe-ngrnq. ");
INSERT INTO ntu_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Eu, a' Yawe ngini-alom King. Elalvzx nzwxbuo-krme mz tron nyzm murde nzayzlu-krbzme da mz leplz tubq. ");
INSERT INTO ntu_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Eu, murde nzaclve-krm nrlc tubq-esz'ngr, Esakrlrngr nzpipx-krm nztubqkr leplz o trtingr. ");
INSERT INTO ntu_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Gct, nim lrpalvc nyz kxnzobqszong. Glxx kx nim me nzrlakitrkr mzli kx prtzngr da. ");
INSERT INTO ntu_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Gct, krkcng tzkrlzlr nim nzabrtrpzlr drtwrdr bam. Itoto x doa amrlx kcng tzrtangrtilr nim, trmrbrtru mz drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Itoto x nigu amrlx napipxbzku mz kxnzmnc-mrbrng da kcng tqale Yawe. Jerusalem ngi mzteadau nyzde mrkc tqmnc-ngrde. Na-angrlvzku nide. ");
INSERT INTO ntu_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Jzsle krkcng tzrnibqting leplz mz nzayzlu-kr-mopwzle badr da kcng tqtrka tzalelr. Kxnzmncng mz drtq kxetq sa na-ayzlu-kzpzle badr natq ngr nzyrni-krbzlr bade. ");
INSERT INTO ntu_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Kxetu, nayc mz drtwrm ninge x mcom kxmu nzaetq-krm enqmi rngeng drtqnge. Kxrpalz, bzkq rlrpx-ngrn nzbz-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Kxarlapx, naelalz-ngrm drtwrnge nzarlapx-krm ninge. Leplz kxkqlu Jerusalem sa naxlrlr nzglqlz-krnge nim. ");
INSERT INTO ntu_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","16","Lalztqmamu! Yawe aelwapx-lzbqngr mz nztubqkr nzayzlu-krbzle da mz leplz. Murde lr mrkzbleng nztao-moung mz gq kx nzekqtilr. Mz br kx nzatu-kapqlr, nzdwatr-moung elr. Mz trtxki kx nzamwilr, nzprtz mou kxdrka'-ngrng elr. ");
INSERT INTO ntu_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Mz nzesablqti-krdr Gct, Nabz-ngrdr leplz ngr nrlc. ");
INSERT INTO ntu_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Nzmu nakxpung, trtxpnzngr nzmrbrtitrkr drtwr Gct nidr. Nzobqtipxngr kxtrnzrngiscung trtxpnzngr nzbotxpx-krde. ");
INSERT INTO ntu_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Natulzme Yawe, mz nzaryplapx-krm lr mrkzbleng amrlx. Na-aelwapx-ngrn kx drtwr kxnzetung amrlx ngi brmrda. ");
INSERT INTO ntu_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Namwxlrtilr x na-amrluelr nim. Nakrlzlr kx nidr leplz txneng, x sa nabzng. ");
INSERT INTO ntu_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Opxm kx mncme rlru, Yawe. Opxm kz kx mnc-kapqq mzli kc tqkxpu-ngrgr. ");
INSERT INTO ntu_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Obqm! Kxdrka'ngr glqpx-lzbqmile nzayoti-krde leplz kxnzkxpung. Pnz drtwrnge kx sa namwati-lzbq mz br scde. ");
INSERT INTO ntu_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Pipxle kx nzaotikr drtwrde da kxtrka zlwz ngi da kxmrlz mz nzbilvz-zvz-krdele. Pivxile Yawe x pxtxpx-ngrde nide, a' amrlzle leplz kx nztrkibrng. ");
INSERT INTO ntu_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Rblx nzrtangrti-krde Gct murde glqpx-lzbq. Rblx nzrmcti-krde Gct murde mz drtwrde trtxpnzngr Gct. ");
INSERT INTO ntu_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Rlr! Xplrmi-zlwzle nzmncngr kxtrka, a' pxtxpx-ngrde me pnz drtwrm. Suti txpwz drtwrde nzyrpalelvz-krde enqmi rdeng. ");
INSERT INTO ntu_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Sc tqrpipele kx, “Trpnzngr da kxtrka kx naprtzm bange, X trpnzngr nzodatingr ninge kalr.” ");
INSERT INTO ntu_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Sc tqglqlz-zvzle alwx x nzpokiangr. Natqdeng amrlx ngi dalr nzrpikitingr, nzrpibqtingr, x nzrpilzngr. ");
INSERT INTO ntu_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Trmrlzu nzmnc-kapq-aepztr-krde mztea mz nzrnibq-krde kx nabzdr lq. Tu zvz mz nzaenzli-krde ncblo kxesz'nebz. ");
INSERT INTO ntu_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Tqtu-kapq apule laion kc Tqtcngzpxm mz gq nyzde mz nzkivzti-krde ncblo kx trxplru. ");
INSERT INTO ntu_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Vz zvz nzxplr-zlwz-krde. Vz zvz nzatrkati-krde nzmnckr kxnzkxpung. ");
INSERT INTO ntu_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Vz-rbr kxdrka'ngr mz nzrpi-krde kx, “Gct trobqpepuu bange. Wzx a' trkrlzleu da kcng trka tqalex.” ");
INSERT INTO ntu_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Wztitxpxbz nzwzkr ncblo kxdrka'ngr, kx Yawe, mz nzayrplapx-krm nide. Wai-ngrn da lc murde bzkq mrbrtr mz drtwrm kxnzkxpung. ");
INSERT INTO ntu_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Wai-ngrdele kxdrka'ngr pxtxpx-ngrde nim. X rpile kx, “Gct trtxpnzngr nzayrplapx-krde ninge.” ");
INSERT INTO ntu_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Xlqkqamu nimu kxdrka'-ngrng, murde Gct mcle da kxtrka lcng amrlx tqaleamu. X oliqtile nzokatr-krde kxnzkxpung kcng tzrtangrtilr nide. Xlrle nidr murde nide kc tqokatr zvz kxnzobqszong. ");
INSERT INTO ntu_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Yawe, katxpxbz zmatq ngr kxdrka'-ngrng. Yrpalelvz nidr x ayrplapxng mz da kxtrka kcng tzalelr, navz x naesaki zpwx. ");
INSERT INTO ntu_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Yawe, nim King. Yc zvz nzaclve-krm nrlc. Yrlqtxpx mz drtc' nyzm krkcng trnzangiolru nim. ");
INSERT INTO ntu_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Zmatq ngrm etu-esz'ngr, murde krlzpe-kaiq nike narlxtibz kxnztubqng. Zbq kalvz axplrq nidr x kabzme badr nike nzrlxtilr. ");
INSERT INTO ntu_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Zbo ngr leplz kxnzobqszong x kxnzkxpung, sa na-arlapxbzmeng mz zmatq ngr leplz mz nrlc ka. Zmwxlr amrlx sa na-aesaki-zvzq. ");
INSERT INTO ntu_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Kztengeng, Yawe nide me rlakitrx. A' myx kxmule tqrpi-ngrnamu kx, “Ngrlrlz mz newz mz nzrlapx-krm. ");
INSERT INTO ntu_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Murde leplz kxdrka'-ngrng nzmnc-kapqti-zvzlr leplz kxnztubqng, Mz nzpnz-krdr nidr mz nipna. ");
INSERT INTO ntu_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Trpengr doa x da kx na-abrkitrku drtwrgu, X nigu kxnabzdr lqngi, trpengr da kx na-aleku.” ");
INSERT INTO ntu_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Bzkq kxmu nzycmne-krmamu lc bange, murde Yawe kc tqmncbe mz Mangr-nzangiongr nide, X sc tqwxbube mz tron nyzde Heven mz nzobqplx-krde nabz leplz amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Yawe sc tqobqtr zvz mz nzmnckr kxnztubqng x kxdrka'-ngrng. X pxtxpx-ngrde nzrmcngr kxnzrnibqng. ");
INSERT INTO ntu_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","X mz nzayrplapx-krde nidr, sa nartctio-ngrbzle badr muli rplz kxngc na-apule nzdckr tewa. X sa na-abxutile nidr mz nzulr nenq kxpq. ");
INSERT INTO ntu_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","A' krkcng nabzdr tqlqngi sa namncng badr, Murde Gct tubq-esz'ngr x mrlz bade da kxtubq. ");
INSERT INTO ntu_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Yawe, okatrp ninge murde trpengr mrlx kxtubq kx mnc mzli ka. Murde mz nrlc tulvzo leplz kxnzmrlzng nzayrkrtxtrpeng. ");
INSERT INTO ntu_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Leplz amrlx mz nrlc nzapokiati-lzbqng. Nzalqngitilr nzycmnengr mz drtwr kx xlva. ");
INSERT INTO ntu_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Rlxtibo bam nzaesaki-krm natq leplz kxnzpokiang, X odati nidr mz nzglqpx-lzbq-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Murde nzrpilr kx, “Naogr nalctwz txpwz mz nztwz-krgr da kx suti drtwrgr. X trpnzngr kx naetum bagr.” ");
INSERT INTO ntu_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","A' Yawe rpile kx, “Mcpex nzaetq-ngrbz drtq kxnzkxpung, X nztangqgxkr kxnzmwati drtwrng. Delc na-arlapxx nidr mzli ka. Da kc tqwai nzsutikr drtwrdr le.” ");
INSERT INTO ntu_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Yawe, abrtrpzkr drtwrgr mz natqm lcng, tqtubq tqlq. Murde nzopx-krdr apule silvz kc tzayrleni-ebirngr mz nyr. ");
INSERT INTO ntu_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","8","Kxmule-esz' leplz lcng trmya-ngru drtqdr nzglqpx-lzbq-krdr, X nzrglqlz-krdr da kxtrka mz nrlc tulvzo, A' lxngitikr kx sa na-aclve-zpwxq nigr, X sa na-arlapx-zvzbzme nigr mz mq leplz lcng tzdrka'ngr. ");
INSERT INTO ntu_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. ?Yawe, myx kxmule, namrbrtitr-alope drtwrm ninge? ?Namnc-rlru-alopeme bange? ");
INSERT INTO ntu_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","?Nelznge navzdz-alopem? ?X drtwrnge navz-alope? ?X namnclz-alopebo mz zmatq ngr enqmi rngeng? ");
INSERT INTO ntu_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Yawe, obqm bange x ayzlum natqnge. Ka-mop bange nzxplr-krnge murde ma tqbzx. ");
INSERT INTO ntu_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Bzkq rlr-ngrbzme mz enqmi rngeng nzpi-krdr kx nzaovxiopelr ninge. X bzkq rlr-ngrbzme nzabrtzlvz-krdr nzrnrcti-lzbq-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Murde abrtrpo drtwrnge mz nzaodu-krm kc tqyc tqyc. X sa na-abrtz-zlwz-ngrne nzarlapx-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Yawe, sa nangrbo bam murde amrlz-zlwzpeq ninge. Mz da amrlx kx kame bange, Yawe, sa nangrbo bam. ");
INSERT INTO ntu_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Leplz kxnzngqngung mz drtwrdr nzrpilr kx, “Trpnzngr Gct.” Leplz lcng nzvz-rbrng x nzale-txpwzng da kxtrka zlwz. Trpnzngr leplz lcng kxtubq. ");
INSERT INTO ntu_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Yawe mncom Heven, x sc tqmcomle leplz amrlx, Mz nzmc-krde neke yrplapx mz nzrtangrti-krde nide. ");
INSERT INTO ntu_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","A' nzesablqtilr Gct amrlx ngrdr x drtwrdr esz'ti mz nzale-krdr da kxtrka. Trpnzngr nidr kxesz' kxtubq. ");
INSERT INTO ntu_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Delc tqrpingr Yawe kx, “Leplz lcng tztrkang nznibqtitxdr leplz nengeng Nzapulr kx nzrnibqng da kx nangqdr. X mrbrtr mz drtwrdr nzkrka'-krmlr bange. ?Myx kxmule, trnzkrlzlru da kxtubq?” ");
INSERT INTO ntu_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","A' narngidrtio-lzbqng x namwxlrlvzti-lzbqng, Murde Gct tedr badr kxnztubqng. ");
INSERT INTO ntu_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Vz zvz nzrpwa'-krbzlr me pnz drtwr kxnzrlxngiting. A' Yawe mnc-ngalelvzle leplz nedeng. ");
INSERT INTO ntu_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Sutitx zlwz drtwrnge kx Gct rgu kc Saeon na-arlapxle leplz nedeng. Murde mzli kc nayzlu-mou-ngrmle, namnc-zpwxku badr. X nigu lr Jekop drtwrgu sa naelalzm. X nigu lr Israel sa na-abrtz-ngrgu da lc. ");
INSERT INTO ntu_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Nabz ne Devet. ?Yawe, neke navztrpz Mangr-nzangiongr nim? ?X neke takitrde nzangio-krde mz newz kxtr nyzm? ");
INSERT INTO ntu_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Doa kxmule lc nabzde nalqngi. Nqmq krde natubq. X natqde nangi da angidr. ");
INSERT INTO ntu_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","A' bzkq rpibqti leplz. Bzkq atrkatile kztede. X bzkq pikitile kxnzesotrpzng bade. ");
INSERT INTO ntu_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Napxtxpx-ngrde kxdrka'-ngrng. A' na-amatqle kxnzamrluelr Yawe Gct. Na-atutr-zvzle nzesalz-krdeng, Kxmule-esz' rblxbz bade. ");
INSERT INTO ntu_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Narlxtile kxnzrbilqngr kx takitrde trau scde kc tqrlrpx-ngrde. Bzkq pokiatitrle mrlx kxtubq, Kxmule-esz' leplz nzrpilr naxpelr nide. Doa kx vz-nqblqle natq lcng sa natu-amqngi zvz. ");
INSERT INTO ntu_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Nabz ne Devet. Yawe, arlapx ninge, Murde nim kx abrkitrx drtwrnge. ");
INSERT INTO ntu_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Nim Kxetu rnge X nou da kxmrlzting amrlx kcng tqngiscngeng. ");
INSERT INTO ntu_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Leplz nemqng kcng tztrng mrka mz nrlc, Nzmyalz-zlwzng x mrlz bange nzmnc-krgr badr. ");
INSERT INTO ntu_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Nzkxpukr krkcng tzangiolr kxtrngiu Gct angidr sa nartxlvzlz zvz. A' trna-angiowxu gct rdr kxnzmncng mzlilxlr, X trnakrka'pou badr. X trtxpnzngr nzpulio-krnge mepyr ngr blz mz olta nyzdr. ");
INSERT INTO ntu_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Yawe, apume bange drtc' kxmrlz nyznge x tzme bange lrpzki kx nao-zlix. X nzlu-krnge yctrpz bam. ");
INSERT INTO ntu_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","X mrlzm bange me ngi bz ngr da kx katimeng x da kx trkatipwe'u bange. Murde mrlzm bange da amrlx kcng tqkatimeng mz nzngini-krme bange trtenge. ");
INSERT INTO ntu_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Yawe, naglqlz-zvzx nim mz nzmailz-krm ninge. Murde mz nrlckxbq aopxme nabznge mz nzaongr drtwr kxmrlz. ");
INSERT INTO ntu_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Dcpx zvz mz drtwrnge kx mnc-zvzme bange. X trpnzngr doa x da kx na-aycngrlrle ninge, murde tu-zvzme mz nibrnge. ");
INSERT INTO ntu_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Delc nabznge tqabrtz-zlwz-ngrde x drtwrnge tqelalz-ngrmle. X tqmnc-zpwxpe-ngrne. ");
INSERT INTO ntu_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Murde tr-rlrpx-ngrwq zmatq ngr nzbzngr nzaovxio-krde ninge, ncblo kxtr nem. X trayrbqtxwq nrkrdrtqnge mz gq mz nzmibi-krde. ");
INSERT INTO ntu_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","A' aelwa-zvz-ngrm bange drtwr ngr nzmnc-zpwxngr: Nzabrtz-zlwzngr kxmyalz vzpxm mz nzxngi-ngrbz nim. X da kxmrlzting nzvzpx-zvzmqng mz mqm. ");
INSERT INTO ntu_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Nabz ne Devet. Yawe, lalztqm mz nzrlxti-krbo nztubqngr. Xlrm natqnge murde nzkrka'-krbo bam trvzpxpuu mz naonge, a' vzdz-zpwxm mz nabznge. ");
INSERT INTO ntu_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Mzli kc napipx-ngrn neke vz-rbr, mnc mz nrlarde nyznge, Murde nim kx rkrlz nike tubq. ");
INSERT INTO ntu_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","X krlz-zvzq nzao-krnge drtwrnge X obqplxq nabznge mz nrlckxbq. A' trpnzngr da kx vz-rbr kx rmctiq. X pnzpe drtwrnge kx naonge trna-akawi-ngrwxu alwx. ");
INSERT INTO ntu_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Tralewxu da kx nzrtulrtrngr, da kc tzwai kzdung leplz. Murde vz-nqblq-zvzx natqm. ");
INSERT INTO ntu_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Trtaowxu mz nzatalzngr, Murde o-zli-zvzx lrpzki rm. ");
INSERT INTO ntu_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Gct, krka'bo bam murde lalztq-zvzme bange. Kxetu, xlrm natqnge. ");
INSERT INTO ntu_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Delc na-aelwa-ngrme bange nzaodu-krm kc tqyc tqyc. Murde mzli kc tzrlatr-ngrbz leplz bam, arlapxbzme nidr mz mq enqmi rdrng. ");
INSERT INTO ntu_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Aclve angidr ninge na-apule dztum kx matq zlwz mz drtwrm. X amnc-kapqbz ninge da kc tqwai kio mz nzwxbulvzo-krde neideng. ");
INSERT INTO ntu_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","Murde ma kxdrka'-ngrng tzlolvzlr x tznibqlr ninge, Mz nztu-ngalelvz-krdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Trpnzngr nzrycngr mz drtwr kx ycbz badr. A' nzglqpx-lzbq-zvzng. ");
INSERT INTO ntu_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Trpengr nrlarde kx navzkix, murde nzmnc-ngalelvzpelr ninge. X tzryrlqng drtwr kx nametxbo badr. ");
INSERT INTO ntu_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Nzapulr laion kcng tzaenzli-kapqlr Mzli kx nadwa-ngrmlr mz nzpesaliti-krdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","14","Yawe, otaamu badr enqmi rngeng x aovxiong. Kapxm ninge mz mq kxdrka'ngr lcng mz zmatq ngrm. Arlapx ninge x ayrkrtxtr nidr. Murde nzabrtz-krdr yc txpwz mz nrlc ka. Ayrplapx leplz ngr nrlc mz zvetq kc tqoliqtipeq nakabzme badr, Navz navz nakrlzbzle doa nedrng x doa ne doa nedrng. ");
INSERT INTO ntu_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","A' krlzx kx sa namcx mzpq mz nzvz-nqblq-krde nztubq-krnge. X mzli kc natulz-ngr-mopwc', sa na-abrtz-ngrne nzmnc-krbo bam. ");
INSERT INTO ntu_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Nabz ne Devet, ncblo ne Yawe, kx yrbzle mz kxrmailz ngr dzbe kxnzngrng, mzli kc Yawe tqarlapx-ngrbzle nide mz zmatq ngr enqmi rdeng x King Sol. Yawe, mrlztix nim Murde axplrq ninge. ");
INSERT INTO ntu_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Nim Gct rnge, x butqbr kx rlakitrx. Nim lrpalvc nyznge peto, X Mevalu rnge kx arlapxle ninge. Nim nou zmatq rnge apule temz ngr lomrnge kc tqyrputrngr nipna. ");
INSERT INTO ntu_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Kqle-zvzx nim kc tqtakitrde nzrglqlzngr, X vzme arlapxq ninge mz mq enqmi rngeng. ");
INSERT INTO ntu_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","6","Yawe, mzli ka tqkxpu-ngrne kqlex nim mz nzokatr-krm ninge. Murde ycpe pipz nzbz-krnge. Opxm kx zmatq ngr nzbzngr sa na-aovxiole ninge, Mz nzpe-amqngi-krde ninge. A' krlzx kx sa naxlrme ninge mz Mangr-nzangiongr nim, Mz nzayzlu-krme natqnge. ");
INSERT INTO ntu_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Mzli kc Yawe nakaputr-ngrmle, zmatq ngrde myalz apule nengq. Nrlc ycngrlr-atwrnrngr x wai-kzle nou newzng. Murde Gct ngyati zlwz drtwrde enqmi rngeng. ");
INSERT INTO ntu_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","X natqde apu-kzle trmami kc tqyrpupx. X ncte vzpx-ngrm zsikapu. X naode rlxpx-ngrm nyr x rplz kxpq. ");
INSERT INTO ntu_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Lvxpxle bongavz, X vzom tuom mz dcbz kx botapz'. ");
INSERT INTO ntu_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","X kzdq enjrl lvcmio-animle nide. Mz nzrtwz-krdr nenq. ");
INSERT INTO ntu_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Nzlo ngr zbo ngr tewa Apule lrpz kx mnc-kapqpx-ngrmle. ");
INSERT INTO ntu_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","X aelwapx-ngrde zmatq ngrde mz zyzlr kxluli. Mz nabz zbo lc bzlrpc tqpctipx x muli-aes tqrlxtiom vzmi rplz kxngc. ");
INSERT INTO ntu_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Yawe myatxlz-esz'ngr, ngi-batrpzle nzyrpupxkr bzlrmei. X natqde nzxlr mz nrlc tulvzo. ");
INSERT INTO ntu_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Rpna-ngrbzle nipna x aodalitile enqmi rngeng. Vz-nqblqbz bzlrpc x nzvo-alo-ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Mzli kc Yawe tqpnanati-ngrde enqmi rngeng, Natqde apzlzmle me boo-ngrng, X atu-lxlr-ngrde nou nrlc. ");
INSERT INTO ntu_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Yawe rtrngztiomle ninge mz nzokatr-krde ninge Apule kx veclzmle ninge me boongr prla. ");
INSERT INTO ntu_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Kxmule-esz' yangrngatrpo mz nzxplrkr enqmi rngeng, A' sc tqvz zvz nzarlapx-krde ninge. ");
INSERT INTO ntu_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Nzvzmqng mz nzota-krgr badr mzli kc tqprtilz-ngrde ninge nzkxpu-ngrng. A' Yawe sc tqtum mz nibrnge. ");
INSERT INTO ntu_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Mailzle ninge me nzmnc-zpwx-ngrne, X arlapxle ninge, murde abrtzlvzle ninge. ");
INSERT INTO ntu_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Yawe rka-zvzm bange da kxmrlzting mz nzvz-nqblq-krde nztubq-krnge. X ayzlu-ngrmle da bange murde nabznge lqngi. ");
INSERT INTO ntu_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Vz-nqblq-zvzx nqmq kr Gct rnge, X tresablqtiwxu nide. ");
INSERT INTO ntu_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Yrlq-angidrx Lou kxtr scdeng, X aoti zvz drtwrnge natqdeng. ");
INSERT INTO ntu_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Trvz-rbrwxu mz nzmnc-krnge, A' yrlqpx-lzbqnge mz nzalengr alwx. ");
INSERT INTO ntu_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Yawe ayzlu-ngrmle da bange mz nztubq-krnge, Murde nabznge lqngi mz nzobq-krde. ");
INSERT INTO ntu_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Yawe, yrlq-zvzbz natqm mz krkcng tzyrlqbzlr natqdr bam. X amrlzq krkcng nqmq krdr tqmrlz. ");
INSERT INTO ntu_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Tubqbzme mz krkcng nabzdr tqtubq. A' lolvzq mz br scm krkcng tzesabrng. ");
INSERT INTO ntu_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Avzdzq krkcng tzavzo-lzbqng. X avzoq krkcng tzglqlz-lzbqng. ");
INSERT INTO ntu_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Yawe, nim nou nzlu-krnge, mz nzapu-krm kxrtekatr lam pnrnge. X ayrkrpxq da kxtrka amrlx mz nzmnc-krnge, mz nzapu-krm zyzlr x nyr kxpq. ");
INSERT INTO ntu_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Gct, rka-zvzme bange zmatq ngr nzota-krgr badr enqmi rngeng. X axplr-zvzq ninge mz nzdwa-ngaletr-krbo nabxbz ngr lrpalvc nyzdr. ");
INSERT INTO ntu_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Nqmq kr Yawe tubq-esz'ngr, x natqde ngi da angidr zvz. X nginibzle lrpalvc nyzdr krkcng tzrlatrpzng bade. ");
INSERT INTO ntu_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Yawe nide txpwz Gct angidr, X butqbr nyzgu. ");
INSERT INTO ntu_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Nide Gct kc tqaxplr-zvzle ninge, X tzbzle lrpzki rnge kxtubq kx nao-zlix. ");
INSERT INTO ntu_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Axplr-zvzbzle nanycnge Mz nzvzne-krnge mz nartrkla ngr newz. ");
INSERT INTO ntu_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Alvztrple bange nzrpnangr, Murde nakrlzx nzrvecngr nalr popz'. ");
INSERT INTO ntu_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Yawe, apume bange temz ngr lomrnge kc tqyrputrngr nipna. X zmatq ngrm ngi popz' ngr nibrnge. Vzome murde namyalzx. ");
INSERT INTO ntu_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Okatr-zvzq ninge, x rblx enqmi rngeng nzlolvz-krdr ninge. X trnzta-pulro-ngrdru ninge mz drtc'. ");
INSERT INTO ntu_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Maneux enqmi rngeng, Vz vz x lolvz-zpwxxng mz nzodati-krnge nidr. ");
INSERT INTO ntu_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Tzx nidr, vz vz x nztaong amrlx mz drtc'. X trpnzngr kx tulzm. ");
INSERT INTO ntu_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Axplrq ninge mz nzotangr. Delc tqaovxio-ngrne enqmi rngeng. ");
INSERT INTO ntu_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Nim kx rngi-batrp nzdwaszkr enqmi rngeng ninge, Murde naodatix krkcng tzpxtxpx-ngrdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Nzbztidr nzyrningr kx naokatrng. Nzkqlelr Yawe. A' trpnzngr kx arlapxle nidr. ");
INSERT INTO ntu_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Wibrtix nidr, vz vz nzapulr bq kc tqtwz nenq. X rnzbrtix nidr, vz vz nzapulr dxlrbi ngr lrpzki. ");
INSERT INTO ntu_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Arlapxbzme ninge mz mq leplz kx nzmwati drtwrdr ninge. X yrlqq ninge mz nzaclve-krnge drtc' nyzdrng, Murde lr mrkzbleng namnclzmqng mz zmatq rnge. ");
INSERT INTO ntu_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Nzyrngzomqng bange X nzvz-nqblqlr natqnge. ");
INSERT INTO ntu_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Nzrnrctitr-lzbqmqng bange. Nzprpxmqng mz lrpalvc nyzdr. X nzmetxmqng bange. ");
INSERT INTO ntu_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Yawe, nim Gct kx lu. Glqpxx nim murde nim butqbr nyznge. Glqlz-zvz-ngrne nim murde arlapx-zvzq ninge. ");
INSERT INTO ntu_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Ayrplapx-zvzq enqmi rngeng. X okatrq ninge nzaovxio-krnge lr mrkzbleng, ");
INSERT INTO ntu_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Mz nzarlapx-krm ninge mz mqdr. Yawe, ngi-batrpe' nzaovxio-krnge enqmi rngeng. X tu-zvzme mz nibrnge mzli kc ncblo nzrpilr naota-ngrgr badr. ");
INSERT INTO ntu_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Gct, sa naglqlzx nim mz mzlir lr drtqbrng amrlx, Mz nzangrlvz-krnge nim. ");
INSERT INTO ntu_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Yawe, ninge Devet, king nem, x okatr-zvzq ninge mz nzaovxio-krngeng. Aodu-zvzq ninge kc tqmcpxq x leplz ngr nqvi lrnge, tqyc, tqyc. ");
INSERT INTO ntu_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Nzmyalzkr Gct nzmc mz bongavz, X dalr bongavz amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Mz nrlckxngrlx, nepi aelwa-ngrde zmatq rde, Da kc tzwai temz x vri mz nrlckxbq. ");
INSERT INTO ntu_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Kxmule-esz' bongavz trpnzngr naode x nepi trycmneu, X trpnzngr natq kxnztwz temz x vri, ");
INSERT INTO ntu_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","A' nrpa scdr vzpx, krlzbzle leplz amrlx mz nrlc tulvzo. Gct yrlqbzle nrlckxbq nangi ma nyz nepi kx mwipx-ngrmle. ");
INSERT INTO ntu_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Mz nourla, nzvzpx-ani-krm nepi ma nyzde apule nzabrtzkr ncblo kx yrlz ate. X apu-kzle ncblo menrpa kc tqoliq mz nzesangr. ");
INSERT INTO ntu_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Nepi lc prtzm mz nzngrlr-krde mz bongavz. Ngrlr, krlzbzle nrlarde kc tqtakiole. X zyzlr ngrde yzlro-ngrm mz da amrlx. Da kc tqwai Natq Yawe mz nzyzlro-krmle mz leplz amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Natq Yawe amrnale nzlukr nabz leplz mz nzmrlzvxi-krde. Akrlztrle kxnzngqngung murde trycngrlru. ");
INSERT INTO ntu_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Natq Gct aelalzmle drtwr kxnzrvz-nqblqng mz nztubq-krde. Aelwapx-ngrde da kx yc-kapq mz nzobqplx-krde nabz. ");
INSERT INTO ntu_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Nzamrluengr Yawe tqyc tqyc murde lq-esz'ngr. Natq Yawe rsakrlrngr murde da angidr zvz. ");
INSERT INTO ntu_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Delc nzsutikr drtwrnge natqde namyaszpxle trau kxkqlu, Murde vzpx-ngrm nzabrtzngr kx myaszpxle dakxnzng kcng tqbrngzvxi. ");
INSERT INTO ntu_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Mz nzvz-nqblq-krnge natqde, aelwapx-ngrmle bange da kxmrlzting. X mz nzlalztq-krnge mz natqde, atubqtimle nzmnc-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Kxetu Yawe, ipq ninge mz alwx kznikeng yc-kapqtrp bange, Murde rblxm bange nzmc-krngeleng. ");
INSERT INTO ntu_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","X lolvz-amqngi ninge, Murde ma tqvz zvz nzale-krnge alwx Kcng tqotr ngr drtwrnge nzale-krngeleng. Murde nabznge natr x natubqbo mz nzobq-krm. ");
INSERT INTO ntu_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Yawe, nim butqbr kx rlakitrx. Krka'-ngrne kx natqngeng x nzaotikr drtwrnge navz-nqblq-zvzlr me pnz drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Yawe, nim Gct r melrmqgr Jekop. X krka'-ngrgr kx na-ayzlume natq king rgr. X mzli kc nakxpu-ngrde okatrpz nide. ");
INSERT INTO ntu_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Mz nzmnc-krm Newz Saeon mz Mangr-nzangiongr, Aclve x axplr nide. ");
INSERT INTO ntu_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Abrtzlvz da kx rlr-ngrbzle bam. X suti drtwrgr nzelalz-krm drtwrm mz blz kx angcle mz olta nyzm. ");
INSERT INTO ntu_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Kabz bade da kcng tqsuti drtwrde, X angidatibz nepu nr drtwrdeng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","X sa namalqlvzkr nzaovxio-krde. X naglqlzkr nim, Gct rgr. Yawe, ayzlum natqdeng amrlx. Eu, angida. ");
INSERT INTO ntu_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Yawe, ninge king kc tqmcpxq. X mzli ka krlzpex kx okatrq ninge mz nzaovxiongr. X sa na-ayzluome natqnge mrla tqmnc-ngrn Heven kxtr, X nakame bange zmatq ngr nzngini-krnge Ngrlrvea. ");
INSERT INTO ntu_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","8","Kzdung leplz nzabrtrpzlr drtwrdr mz ami nedrng, X kzdung mz dalr nzotangr. Da lcdeng trnaokatrlru nidr x nztaong mz vea. A' Yawe Gct rgr, tu-amqngi-zvzkr, murde abrtxtrpwzkr drtwrgr bam. ");
INSERT INTO ntu_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Yawe, kabz zmatq ngr nzaovxiongr mz king nem. X mz nzkqle-krbzkr nim, ayzlum natqgr. ");
INSERT INTO ntu_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Nabz ne Devet. Yawe, ninge king nem x abrtz-zlwzx murde nzrka-krme bange zmatq. Bilvzx nzaovxio-krbzme enqmi rngeng. ");
INSERT INTO ntu_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Da amrlx kcng tqsuti drtwrnge, tqrlxtibo. X sc tqkatimeng x alebzmeng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Vzpeme bange mz nzrka-krme da kxmrlzting. X alaome mz narnge kraon kx ngi gol. ");
INSERT INTO ntu_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Rlxtibo nzlungr bam, X kapeme bange nzlungr lc tqboi. ");
INSERT INTO ntu_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Leplz kxkqlu nzxlrlr nrpa ngr drtqnge, murde okatr-zvzq ninge. X nzamatqlr ninge, murde armyalzq ninge mz nzngini-krnge King. ");
INSERT INTO ntu_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Da kxmrlz kcng tqkatimeng bange, sa nayc-alomqng bange. X abrtz-zvz-ngrne nzmnc-krme bange. ");
INSERT INTO ntu_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Yawe kc tqrninr, ninge king nem x abrtrpo drtwrnge bam, Murde namnc-zpwxx mz nzaodu-krm kc tqyc tqyc. ");
INSERT INTO ntu_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Yawe, aovxio-zvzq enqmi rmqng, X lolvztiq krkcng amrlx tzpxtxpx-ngrdr nim. ");
INSERT INTO ntu_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","X mz nzlolvzti-krm lc nidr, odatiq nidr, apule nyr kc tqangcle nrlc. Yawe, milxtxo-zvzq nidr x ayrkrtxtrq nidr mz nyr. ");
INSERT INTO ntu_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Trpnzngr kx rlapx mz nqvi lrdr, Murde nibqtiqng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Mz nzyrlq-krdr drtwr ngr nzota-krmu badr mz vea, Trna-angidalru drtwr lc tzyrlqlr. ");
INSERT INTO ntu_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Murde nzdwaszlr nim Mz nzpnz-krm nidr mz nipna scmqng. ");
INSERT INTO ntu_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Yawe, glqlz-ngrgr nim nzxplr-esz'ngr-krm. X angrlvzkr nim mz zmatq ngrm. ");
INSERT INTO ntu_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Gct! Gct o! ?Memule tqvzszpe-ngrn ninge? ?X memule tqpxtxpx-ngrn nzokatr-krm ninge x trlalztqpepqu mz nzkrka'-krnge? ");
INSERT INTO ntu_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Yrniti-zvzbo bam ngrlx x nrlckxbq, A' trmnc-zpwxwxu murde trayzlumeu natqnge. ");
INSERT INTO ntu_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Nim King rgr kxtr-esz'ngr kc tqaclvele nigr lr Israel. X angio-zvzkr nim. ");
INSERT INTO ntu_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Melrmqgrng nzabrtrpzlr drtwrdr bam. Nzlxngitilr nim x arlapxq nidr. ");
INSERT INTO ntu_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Nzmnc-xglelr nim x tu-zvzbzme mz nibrdr. Nzrlxtibzlr nzokatr-krm nidr x angidatibzme natqdr. ");
INSERT INTO ntu_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","A' nzapusrngr ninge brmrda. Nzngangr-ngrdr ninge mz nzobqszo-krdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Nzycngrlrmlr nardr bange x nzmabqtimlr benaodr bange. X nzxtrnga-ngrdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Nzrpimlr kx, “Abrtrpzme drtwrm mz Yawe, a' namckr ena nzarlapxkr Gct nim mzli ka. Murde trokatrleu nim, kxmule-esz' rpiq kx mrlzti-zlwzle nim.” ");
INSERT INTO ntu_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","10","Yawe, yzuo mz zbq kc tzmcngr mzke', krlzmle mzli ka, Abrtr-zvzbo drtwrnge bam mz nzngini-krm Gct rnge. Murde aclve-angidrq ninge mz nzrmcngr mzke', X mz nzyq-krnge neyr lxenge. ");
INSERT INTO ntu_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Bzkq rlaszq ninge, murde trpnz-moungr kx naokatrle ninge, Mz nzesotrpe-krm enqmi rngeng bange. ");
INSERT INTO ntu_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Yawe, enqmi lcng tztu-ngalelvzlr ninge. X nzrpilr nanibqlr ninge mz nzapu-krdr poi kz peto. ");
INSERT INTO ntu_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Naodr mznem mz nzvz-krmlr bange, Mz nzmakx-krdr ninge mz nqngidr kxmalc. ");
INSERT INTO ntu_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Nzxplr-krnge yrkrpxpe apule lue kc tzpulio mz drtc' kx mingr. Mrkcng tzaxvctrngr nrvr rngeng nzbxplctipeng, x nqmq nr nabznge baonepe. ");
INSERT INTO ntu_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Mzli trnaboipeu nzbatr-krme nzbz-krnge. Murde mewe-zvzpex x drtwrnge brlxkz apule nabr kxngibr mz nepi. ");
INSERT INTO ntu_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Kxdrka'-ngrng nztu-ngalelvzlr ninge, nzapulr kuli kx namaneutilr ninge, X sc tzmaplxtitrpebzlr mqngeng x nanycngeng. ");
INSERT INTO ntu_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Mcx kx ninge nrvr-nrbalqtxpe. X nzobqszneopelr x nzyrpalelvzpelr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Nzakiti-lzbq-ngrdr nctq lrpz scnge, X nzkq scnge kc boi nzayrleo-ngrdr daes, mz nzkrlz-krdr doa kx narngisc. ");
INSERT INTO ntu_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Yawe, bzkq mncme rlru. A' vz-anim mz nzokatr-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","X arlapxbz nzlu-krnge mz mq ncblo kxayo lcng, Tzmaneutilr ninge mz nzapu-krdr kuli kz peto. ");
INSERT INTO ntu_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","X mnc-ngalelvz ninge, murde ma tzluplxtilr ninge mz toki r vea scdr Tzapulr nqngi poi kz peto. ");
INSERT INTO ntu_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Mz nzyrlwr-lxblrkr leplz nemqng, Sa nabilvzx nim, mz nzrpi-krbo mz mzlengeng da kx aleme bange. ");
INSERT INTO ntu_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Murde sa napipxbo badr kx, “Nigu kxnzawz neng Yawe, naglqlzku nide! Eu. Nigu lr Israel na-amrlueku nide mz nzamatq-zvz-krgu nide! ");
INSERT INTO ntu_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Kxmule-esz' nigu kxnzobqszong, a' Gct trobqszoleu nzkxpu-krgung, Murde trpxtxpx-ngrdeu nzayzlu-krmle natqgung.” ");
INSERT INTO ntu_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Delc Yawe, narka-ngrbo blz ngr nzawingr kc tqpibo, mz nzyrlwr-lxblrkr leplz nemqng. Murde nim nou nzrglqlz-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","X mz nibrde, sa nakrlcng mz dakxnzng kx vzpxm mz blz kc tqkabo bam. X sa naglqlzlr nim mz nzbrtikr drtwrdr nim. Amrlz-zvzbz nidr mz nzmnc-zpwx-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Yawe, lr mrkzbleng amrlx sa na-aoti drtwrdr nim mz nzplzpx-krbzlr alwx ngrdr bam. X neidu lcng amrlx sa na-angiolr nim, ");
INSERT INTO ntu_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Mz nzngini-krm King kx matq-esz'ngr Kc tqaclve-zvzle nidr. ");
INSERT INTO ntu_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Delc kxnzetung badr leplz nedrng sa nayrngzobzng bam, Mz nzavzo-lzbq-krbzlr bam. ");
INSERT INTO ntu_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","X doa negrng kz sa nawztrpzng bam, Mzli kc naxlrtr-ngrmlr bagr nrpa ngrm, ");
INSERT INTO ntu_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Mz nzrpi-krbzkr badr kx, “Yawe arlapx-zvzle leplz nedeng.” ");
INSERT INTO ntu_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Nabz ne Devet. Yawe, aclve-zvzq ninge apux sip nem. X trtxpnzngr da kx mnctxpx-ngrne. ");
INSERT INTO ntu_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Mailz-zvzq ninge me ycngr lue x dakxnzng, Murde na-amax mrkc tqycngr nrwx. ");
INSERT INTO ntu_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Amrnaq nzlu-krnge. X aelwa-zvz-ngrme lrpzki kxtubq, murde drtqm tr zlwz. ");
INSERT INTO ntu_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Nctoko scm tzmle nzti bange. X bz scm abrmle drtwrnge mz da kx prtz. Kxmule-esz' vztrx mz nzlo, a' trtxpnzngr da kx namwxlrtix. Murde nim Yawe, kc tqmncme bange. ");
INSERT INTO ntu_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Alebzme nange dakxnzng, Mz mzlir enqmi rngeng. Aelubzme narnge tolo, X drtwrnge elalzm. ");
INSERT INTO ntu_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Krlz-angidrx kx sa naka-zvzme bange zmrlz ngrm x nivz lrm, X sa namnc-zvzx ma nyzm. ");
INSERT INTO ntu_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Nabz ne Devet. Nrlc atwrnrngr nyz Yawe, X doa amrlx mz nrlc nedeng x da amrlx mz nrlc scdeng. ");
INSERT INTO ntu_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Murde nide Kxrpalz kc tqwz-ngrde nrlc, X yrlqbzle prla x drtc' mz zmatq ngrde. ");
INSERT INTO ntu_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","?Mz nzaotikr drtwrgu zmatq lc, neke tubqbz bade nzvzdzbz mz newz nyz Yawe? ?X neke takitrde nzprtr-krde Mangr-nzangiongr nide? ");
INSERT INTO ntu_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Leplz kx nabzdr lq x nzmnc-krdr tubq Nztakitrdr nzodutr-lxblr-krbzlr mz Yawe. Natqdr nzangidati-zvzlr. X trnzangiolru mqngr da kx nzlz. ");
INSERT INTO ntu_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Leplz kxnzmulr lcng nztubqbzng mz nzobqkr Yawe. X Gct r Jekop lc sa na-amrlzle x na-arlapxle nidr. ");
INSERT INTO ntu_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Leplz lcng nzrtangrtilr me pnz drtwrde, X suti drtwrdr nzxngi-krbzlr nzulrde mz Mangr-nzangiongr nide. ");
INSERT INTO ntu_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Lvxpxbzmu bade naonrx ngr Jerusalem, X naonrx ngr Mangr-nzangiongr kcng tqblzlongr, Murde King kc Tqmatq navztrp. ");
INSERT INTO ntu_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","?King kznilc tqmatq? Krlc Yawe, kc tqrninr, tqxplr. Krkc tqaovxio zvz mz vea. ");
INSERT INTO ntu_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Lvxpxbzmu bade naonrx amrlx, X naonrx kcng tqblzlongr, Murde King kc Tqmatq navztrp. ");
INSERT INTO ntu_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","?King kznilc tqmatq? Krlc Yawe, Ngrlrvea ngr ami nedeng. Nide King kc Tqmatq. ");
INSERT INTO ntu_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","2","Nabz ne Devet. Awi Yawe mz nzngini-krm Gct rnge. Abrtr-zvzbo drtwrnge bam mz nzkrka'-krbo bam. Bzkq rlr-ngrbzme mz enqmi rngeng nzaovxio-krdr ninge. Bzkq nzamyatimlr drtqnge. ");
INSERT INTO ntu_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Clvebz doa kc tqabrtr-zvzbzle drtwrde bam, murde drtqde ma tzamyatibz. Clveti-lzbq zvz doa lc, a' mrlx kx ani txpwz nzota-krmu ncdr, mrlz nzmyakr drtqde. ");
INSERT INTO ntu_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Da kx sutitx-zlwzbz drtwrnge bam, nzalvztr-krme bange nqmq krmqng amrlx. Delc nakrlz-zpwx-ngrne lrpzki rm. ");
INSERT INTO ntu_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Elalvzx nzokatr-krme ninge mz nzvz-nqblq-krnge natqm. Eu. Murde nim Gct rnge kc tqarlapxle ninge, x tqabrkitr-zvzx drtwrnge nim. ");
INSERT INTO ntu_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Gct, aelwapx-zvzm nzaodu-krm x nivz lrm bange. Gct, ale da lc, da kc tqwai-pnzq mzli kc bqnc. ");
INSERT INTO ntu_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Ipq ninge mz alwx kcng tqalexng mzli kc tqngini-ngrne obla, murde nim mrlz-esz'ngr. Ipqpx nzvz-rbr-krngeng amrlx mz nzdcpxkr mz drtwrm nzaodu-zvz-krm. ");
INSERT INTO ntu_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Jzs-zvzq leplz mz nzmncngr kxmrlz x kxtubq. Jzsiq mz nzalvztr-krm kxnzaleng alwx, murde nao-zlilr nzti rm. ");
INSERT INTO ntu_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Kxrmailz, aelwapx-ngrbzme mz kxnzavzo-lzbqng da kxtubq. Kxakrlz, alvztr-zvz-ngrn nidr me pnz drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Lrpzki rmqng amrlx nzaelwapxbzlr mz leplz nemqng nzaodu-krm x nzangidati-krm natqm. Leplz lcng nzyrlq-zvzlr nzalvztr-krm x nzesz'tikr drtwrmu badr. ");
INSERT INTO ntu_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Ma-nqblq natqm kc tqesalz-ngrn mz nzipqpx-krm alwx rngeng, Murde nzkqlu-zlwzng. ");
INSERT INTO ntu_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Nekeng nzlxngiti-angidrlr natqm, Nzo-zlilr lrpzki angidr mz nzalvztr-krm nidr. ");
INSERT INTO ntu_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Olvz x ncblo lcng sa namnc-zpwxng. Oliqtibz drtc' kc tqpibzme, murde doa nedrng namnc-kzng elr. ");
INSERT INTO ntu_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Pqtr mz drtwrm leplz kcng tzamrluelr nim. Pipx-zvzbzme da kx na-alelr mz nzvz-nqblq-krdr nzesz'tikr drtwrmu badr. ");
INSERT INTO ntu_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Rtxtrpwo nibrnge bam mz nzmnc-xgle-krnge nim. Rlapx-zvzx mz nzokatr-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Suti drtwrnge kx naobqme bange x nayc mz drtwrm ninge. Sutitx drtwrnge murde trpengr kztenge x trmnc-zpwxpewxu. ");
INSERT INTO ntu_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Trte, katxpxbz nztalvzokr nabznge. Tekqtr drtwrm x arlapxbz ninge mz nzkxpu-krngeng. ");
INSERT INTO ntu_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Vz zvz nzaotikr drtwrm nzkxpu-krnge x nzetqkr drtqnge, Vzm x ipqpxbz alwx rngeng. ");
INSERT INTO ntu_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Wx-nzlongr nabznge nzkqlu-zlwzkr enqmi rngeng. Wzpx zlwz mz drtwrdr nzatrkati-krdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Xplrlvzbz ninge mz enqmi rngeng mz nztu-krme mz nibrnge. X bzkq rlr-ngrbzme badr nzamyati-krmlr drtqnge, murde nim me rlakitrx. ");
INSERT INTO ntu_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Yawe, arlapx ninge murde tubqx x nabznge lqngi. Yrlqtr-zvzbo nzlu-krnge bam. ");
INSERT INTO ntu_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Zmatq ngrm, navzm mz nzarlapx-krbzle nigr lr Israel mz Ztrkang amrlx kcng tqrmctikr mzli ka. ");
INSERT INTO ntu_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Nabz ne Devet. Yawe, pipxbz kx ninge ncblo kx nabzde lq. Murde o-zli-zvzx nzti kxtubq, X abrtr-zvzbo drtwrnge bam. ");
INSERT INTO ntu_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Obqtr angidr mz nabznge, X mc kxmu nzvzkr nqmq nr drtwrnge. ");
INSERT INTO ntu_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Murde nivz lrm rtwayz-zvzm bange, X nzaodu-krm mailz-zpwxle ninge. ");
INSERT INTO ntu_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Traodu-lzbqkru badr leplz kxnztrkang. X trabrtzlvzwxu kxnzpokiang. ");
INSERT INTO ntu_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Pxtxpx-ngrne nzngi-te-krgr badr kxnzaleng alwx. X drtqnge sa nzmnc-krgr badr kxdrka'-ngrng. ");
INSERT INTO ntu_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Yawe, ycpqx mqnge mz nzvz-nqblq-krnge Loukxtr scm, murde natubqbo mz nzobq-krm, X naprtrpo mz leplz nemqng mz nzvz-ngale-krgr olta nyzm. ");
INSERT INTO ntu_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","X ngr-ngrgr nabz ngr nzawingr Mz nzale-krm da kxmrlzvxiting. ");
INSERT INTO ntu_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Mrlzm bange Mangr-nzangiongr nim, Mrkc tzmcngr nzmyalz-krm. ");
INSERT INTO ntu_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","10","Mz nzmilxtxo-krm leplz kcng tztakitrdr nzayrplapxngr, Bzkq apusr-ngrn ninge kxnzaleng alwx, x kxnzrnibqng, X kxdrka'-ngrng kcng tzrtwz-zvzng dalr nzamcti-rbrngr, ");
INSERT INTO ntu_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Murde o-zli-zvzx nzti kxtubq. Ycngr mz drtwrm x arlapx ninge. ");
INSERT INTO ntu_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","X sa naglqlz-ngrne nim mz mzlir leplz nemqng Murde tu-zvzme mz nibrnge x tubqbo mz nzobq-krm. ");
INSERT INTO ntu_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Yawe, nim Mevalu rnge kx arlapx-zvzle ninge. X trpnzngr kx namwxlrtix. Trnarnrcti-lzbq-ngrneu murde nim lrpalvc nyznge. ");
INSERT INTO ntu_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Mzli kc kxdrka'-ngrng natz-ngrdr ninge mz nznibq-krdr ninge, Enqmi lcng sa nataong. ");
INSERT INTO ntu_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Kxmule-esz' ami kxetu navzm mz nzoti-krmlr ninge, a' trpnzngr nzmwxlr-krnge. X kxmule-esz' otakr badr, a' drtwrnge sc tqabrtr-zvzbo bam. ");
INSERT INTO ntu_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Yawe, da kx rlxtitxpwo bam nide sele: Sutitx zlwz drtwrnge nzmnc-zvz-krnge mz ma nyzm. Murde naxngi-zvzbo nzulr nzmyalz-krm mz nzaoti-zvzkr drtwrnge me pnz drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Murde krlzx kx sa na-aclve-angidrq ninge mz mzli r nzkxpu-krnge. X na-amnc-kapqq ninge mz Mangr-nzangiongr nim, mz nzngini-krm butqbr kx rlakitrx. ");
INSERT INTO ntu_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Sa nabatrpe' nzaovxio-krnge enqmi lcng tztu-ngalelvzlr ninge. X sa namalq-zlwzx nzka-krbo bam blz mz Mangr-nzangiongr nim. X nangr-ngrbo bam nabz ngr nzawingr. ");
INSERT INTO ntu_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Yawe, xlrm nzkrka'-krnge mz nzkqle-krnge nim. X nayc mz drtwrm ninge mz nzayzlu-krme natqnge. ");
INSERT INTO ntu_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Mzli kc tqrpi-ngrme kx, “Vzm mz nzangio-krm ninge.” X ayzlubo natqm kx, “Eu, ninge la navzbo.” ");
INSERT INTO ntu_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Delc, bzkq mnc-rlrume bange. Ninge kxnzawz nem. X bzkq esablqtiq ninge mz nzngyatikr drtwrm ninge. Murde okatr-zvzq ninge mzli kc. Mevalu rnge, bzkq pxtxpx-ngrn ninge mz nzaxtx-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Kxmule-esz' trtenge x lxenge nzaxtxtxdr ninge, A' nim la tqaclve-angidrq ninge. ");
INSERT INTO ntu_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Alvztrp nqmq krmqng bange. X mailz ninge mz nzo-zli-zvz-krnge nzti kx tubq murde enqmi rngeng sa tzaukztilr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Bzkq rlr-ngrbzme nzlolvz-krdr ninge. Nzpokiatitrlr ninge x nzamwxlr-ngrdr ninge mz nzycmne-zngya-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Yawe, krlzpex kx nzmrlz-zlwz-krm Sa nakrlzmle ninge mzli ka mz nrlc. ");
INSERT INTO ntu_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Mzlengeng, na-abrtr-ngrbzku drtwrgu mz Yawe. X naxplrku mz nzlxngiti-krgule. Bzkq matitr drtwrgu nide, A' drtwrgu na-abrtr-zvzbzku bade. ");
INSERT INTO ntu_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Nabz ne Devet. Yawe, kqlex nim murde nim butqbr kx rlakitrx. Bzkq apume bange kxnradrtqde ngq. Murde ma tqbzx nzmu napx-ngrn nzxlrngr nzyrni-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Mzli kc tqobqtr-ngrbo Mrkc Tqtr mz nzmnc-krnge Mangr-nzangiongr nim, x glalzx mqnge mz nzkrka'-krbo bam, Xlrm natqnge x okatrp ninge. ");
INSERT INTO ntu_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Bzkq apusr-ngrn ninge kxdrka'-ngrng kcng tzrtrngz-zvzbzng da kxtrka. X nzrpilr kx nidr ncblo ngr nivz, a' trtingr. ");
INSERT INTO ntu_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Ayzlu-mopwz mz nzayrplapx-krm nidr mz da kxtrka x nzrtrkalrngr kcng tzalelr, Kabz badr da kx takitrde nzvz-rbr-krdrng. ");
INSERT INTO ntu_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Murde matitrpe drtwrdr da kcng tqwz-ngrn x da kxetuting tqaleqng. Dekc namilxtxo-ngrn nidr x bzkq da kx na-ale-moulr. ");
INSERT INTO ntu_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Yawe, glqlz-lxblrkr nim Murde ayzlume natqnge mz nzokatr-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Nim lrpalvc nyznge x temz ngr lomrnge kc tqyrputrngr nipna. Abrtrpo drtwrnge bam x okatr-zvzq ninge. Delc tqelalz-ngrm drtwrnge X tqawi-zvz-ngrbo bam mz nzngrngr. ");
INSERT INTO ntu_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Yawe, nim lrpalvc nyzgr kx rlakitrkr. X nim nzxplr-krnge, ninge king kc tqmcpxbzme. ");
INSERT INTO ntu_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Amrlz nigr leplz nemqng mz nzarlapx-krm nigr, Mz nzngini-krgr sip nemqng kcng tqaclve-zvzq. ");
INSERT INTO ntu_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Nabz ne Devet. Nimu enjrl ngr Heven nayrngzobzmu mz Yawe, Mz nzmc-krmu nzmyalz-krde x zmatq ngrde. ");
INSERT INTO ntu_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Napipxamu kx takitrde nzamrluengr drtqde, Mz nzangio-krmu nztr-esz'ngr-krde. ");
INSERT INTO ntu_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Murde natq Yawe aelwapx-lzbqngr mz trlipu. Nate kxmatq o-zlile dcpwe mz nzapu-krde bzlrmei prla. ");
INSERT INTO ntu_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Natq Yawe matq-esz'ngr. Eu. Natqde xplr zlwz. ");
INSERT INTO ntu_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Natq Yawe rpesaliti nc trpili, Mz nzapu-krdr nounc kx nzlapizting. ");
INSERT INTO ntu_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Natq Yawe aycngrlrle newz nyzgung, Mz nzapu-krdr ncblo kx nzelang. ");
INSERT INTO ntu_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","8","Natq Yawe batrpzle bzlrpc. X bzlrmei ngrde aycngrlrle peto. ");
INSERT INTO ntu_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Natq Yawe apule nenq kc tqrkqtuti nc yrni x krlxpqtile leu rdr. X kxnzangiong amrlx mz Mangr-nzangiongr nzrpilr kx, “Gct, nzmyalz-esz'ngr-krm glqlz-ngrgr nim!” ");
INSERT INTO ntu_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Nubla ngr tewa kxetu yclzbz mz zmatq ngr Yawe, Mz nzngini-krde King kc tqaclve alo. ");
INSERT INTO ntu_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","X mz zmatq lc axplrle nigu leplz nedeng Murde namnc-zpwxku. ");
INSERT INTO ntu_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Nabz ne Devet. Yawe, glqpxx nim mz nzarlapx-krm ninge mz mq enqmi rngeng. Murde tr-rlr-ngrpwzmeu badr nzaovxio-krdr ninge murde ma tzbilvzlr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Yrnibo bam mz nzokatr-krm ninge, X amrlz-mowq nrkrdrtqnge. ");
INSERT INTO ntu_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Mzli kc tqycpe pipz nzbz-krnge, Arlapxq ninge x nrkrdrtqnge trnavzopeu mz gq. ");
INSERT INTO ntu_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Yawe, tr-esz'ngrn, x nigr leplz nemqng na-angrlvzkr nim, Mz nzawi-krbzkr bam da kx aletiqng. ");
INSERT INTO ntu_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Zngya ngr drtwrm trboiu, A' nzaodu-krm nigr tqyc tqyc. Kxmule-esz' yrnibutikr nrlckxbq, A' nzyrni-krgr sa nalrtipxle nzabrtz-krgr mz nzmc-krgr zyzlr mz nourla kxtopwz. ");
INSERT INTO ntu_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Yawe, mzli kc tqmnc-zpwx-ngrne, rpi-zvzx kx, “Trpengr doa x da kx namwxlrtix.” ");
INSERT INTO ntu_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Murde xngibo nzamrlz-krm ninge, mz nzapu-krm rtabu kx xplr kx tu-ngalelvzle ninge. A' mzli kc tqprtz-ngrm da kxtrka bange, opxm kx esablqtime ninge, sc tqmwxlr-zlwzpex. ");
INSERT INTO ntu_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Delc Yawe, tqkqle-ngrne nim. X rlxtibo nzyzluti-krme ninge. ");
INSERT INTO ntu_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","Rpibo bam kx, “Bzkq rlrpx-ngrn nzvzo-krnge mz gq, Murde trpnzngr da kx mrlz kx naprpxm mz nzbz-krnge. X rblxpe nzyapwxtipx-krbo mz leplz mz nzangidati-krm, Nzmu namibilzpemc mz drtc'. ");
INSERT INTO ntu_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Yawe, xlrm natqnge mz nzyckr drtwrm ninge. Kxetu rnge, okatrp ninge.” ");
INSERT INTO ntu_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Alrtibzme nzyrnibu-krnge mz nzelalz-krm drtwrnge, Mz nztekqtr-krbzme nzvzkr drtwrnge mz nzabrtz-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","X rblxm bange nzmnc-lrpi-krnge. A' navz zvz nzangrlvz-krnge nim. Awi kxetu, Yawe! ");
INSERT INTO ntu_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Yawe, nim me rlakitrx. Bzkq rlrpx-ngrn nzaovxiokr enqmi rngeng ninge. A' arlapx ninge, murde ale-zvzq da kxtubq. ");
INSERT INTO ntu_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Ayzlu-anim nzyrni-krnge mz nzarlapx-krm ninge. Nanginim butqbr kx namnc-kapqpx-ngrmc. ");
INSERT INTO ntu_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Mz nzngini-krm lrpalvc ngr nzrlapxngr, Aclve x mailz ninge mz nzvz-nqblq-krde natqm. ");
INSERT INTO ntu_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Bzkq rlr-ngrme nzprtz-krnge mz trtxki kc tzamwi-kapq enqmi rngeng, Murde nim me rlakitrx. ");
INSERT INTO ntu_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Yawe, aprcbo mqngrnge mz mqm. Murde nim Gct kc tqbrti drtwr mz nzxpepx-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Kxetu, abrtxtrpo drtwrnge bam, A' pxtxpx-ngrne krkcng tzangiolr mqngr da txneng kx nzlz. ");
INSERT INTO ntu_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Drtwrnge sa naelalzm x na-abrtzlvzx nzaodu-zvz-krm, Murde okatr-zvzq ninge mz mzlir nzetqkr drtqnge x nzkxpu-krngeng. ");
INSERT INTO ntu_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","X tr-rlr-ngrpwzmeu ninge mz mq enqmi rngeng, A' amnc-nrwx-ngrbzme nabznge mz nzvzne-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Yawe, nayc mz drtwrm ninge murde nabznge talvzo. Mzke' vaotxpe-ngrde nzyrni-zlwz-krnge x nrkrdrtqnge mewetxpengr. ");
INSERT INTO ntu_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Yangrngapex mz nzvzkr drtwrnge x drtqnge satxpe murde bztipenge nzyrningr. Drtqnge yayrpe-ngrde nzmnc-rbr-krnge x nipenge nrvr-nrbalq. ");
INSERT INTO ntu_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Enqmi rngeng nznelvztilr ninge X kxnzmnc-aepztrpqng bange nzobqszopelr ninge. Kxkrlzti-lzbqkr badr nzapusr-ngrdr ninge da kxtrka X krkcng tzmclr ninge mz lrpzki nzdwa-ngrdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Leplz amrlx mrbrtinetrpe drtwrdr ninge, opxm kx bzpex. Apunepebo badr brmrda. ");
INSERT INTO ntu_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Mnc-zvzx mz zmwxlr mz nzxlr-krnge nzlc-awakr enqmi rngeng, Kcng tzyrlqlr drtwr kx nanibq-ngrdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","A' Yawe, nim Gct rnge, X abrtrpo drtwrnge bam. ");
INSERT INTO ntu_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Arlapx ninge mz enqmi rngeng kcng tzayotilr ninge, Mz nzaclve-angidr-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Amrlz ninge, kxnzawz nem, Mz nzarlapx-krm ninge murde nzaodu-krm tqyc tqyc. ");
INSERT INTO ntu_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Yawe, bzkq rlrpx-ngrn nzkqle-krnge nim nzamyati-ngrm drtqnge. A' amyatibz drtq kxdrka'-ngrng murde napwrkilvc-ngrdr nzbz-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","X na-aesakile natq kxnzpokiang x kxnzglqpx-lzbqng, Kcng tzxtrnga-ngrdr kxnztubqng. ");
INSERT INTO ntu_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Myatxpx zlwz da kxmrlzti kcng tqyrlqq nangi sc krkcng tzamrluelr nim. Murde aelwapxpe-ngrn kx aclve-zpwxq krkcng tzrlatrpzng bam. ");
INSERT INTO ntu_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Leplz nemqng nzrlapxng mz drtwr kx nzyrlq enqmi rdrng x nznelvztingr nidr, Murde amnc-aepztrpzme nidr bam. ");
INSERT INTO ntu_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Yawe, glqpx-ngrne nim nzaodu-krm ninge. Murde mzli kc enqmi rngeng tztu-ngalelvz-ngrdr lrpalvc nyznge, mnc-zpwxx mz nzetukr nivz lrm. ");
INSERT INTO ntu_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Mwxlrx murde opxm kx maszlrpx-ngrn ninge. A' xlrme nzkqle-krnge nim kx naokatrq ninge. ");
INSERT INTO ntu_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Nigu leplz neng Yawe naka-lzbqbzku bade. Murde aclvele kxnzvz-nqblq-zpwxlr nide, a' ayrplatipxle kxnzglqpx-lzbqng. ");
INSERT INTO ntu_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Bzkq nabzgu tzprlzm, a' natu-amqngiku Mz nzbrtikr drtwrgu nide. ");
INSERT INTO ntu_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Kzdq nzaongr drtwr kx yr Devet. Doa kx nzipq mz alwx ngrde Drtwrde elalz-zlwzm. ");
INSERT INTO ntu_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Murde mz nzobqkr Yawe trvz-rbrpeu. A' plzpxle alwx rdeng murde ma tqyc-kapq da kxtrka mz nabzde. ");
INSERT INTO ntu_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Yawe, mzli kc tqpxtxpx-ngrne nzplzpx-krbo alwx rngeng bam, Drtqnge satx zlwz mz nzetq-zvz-krde. ");
INSERT INTO ntu_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","X drtqnge tropx-pnzu mz nzayrplapx-krm ninge ngrlx x mz nrlckxbq. X yangrngatxpex nzapu-krnge lxbi kcng tqngibr mz nepi. ");
INSERT INTO ntu_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Pnzpe drtwrnge kx naplzpxbo alwx rngeng bam. X mz nzplzpx-krboleng, trpnzngr kx yrlq-kapqbo bam. Delc tqipqpe-ngrn ninge, X katxpx-ngrbzme nzmrlepukr alwx rngeng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","X nigr leplz nemqng nakrka'bzkr bam mzli ka. Murde mzli kc nzkxpungr na-apune-ngrmle nrc kc tqoda, Trtxpnzngr nzkrlz-krmlr nigr. ");
INSERT INTO ntu_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Nim me rlakitrx x ayrbqpxq ninge mz da kxprtz. Mzli lc tqxlrx nabz kxyrlvi kx nim nou nzrlapxngr. ");
INSERT INTO ntu_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Rpim Yawe kx, “Sa na-aelwa-ngrbo bam lrpzki kc nao-zliq, Mz nzmailz-krnge nim. ");
INSERT INTO ntu_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","A' bzkq apuq hcsi kx narde mqngi, Kx vz-nqblqle me pnz drtwr ncblo mz nqvi kcng tzpetrpz bade.” ");
INSERT INTO ntu_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Kxdrka'-ngrng sa na-ayrplapxng mz alwx ngrdrng. A' nigu kcng tqbrti drtwrgu Yawe sa namcku kx aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Nigu kxnztubqng na-angrlvz-ngrgu Yawe. Na-abrtz-ngrgu nide. ");
INSERT INTO ntu_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Nabz ne Devet. Naelalvzku Yawe, nigu kx nztubqng. Murde mrlzvxi nzglqpx-krgu nide. ");
INSERT INTO ntu_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Na-angrlvzku nide mz nabz kx yrlvi mz nzawingr, X mz nzayrni-krgu gita x ukzlele. ");
INSERT INTO ntu_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Nangr-ngrbzku bade nabz kxmrna, Mz nzmalqlvz-krgu nide. ");
INSERT INTO ntu_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Murde natqdeng amrlx tubq-esz'ngr, X da amrlx kcng tqaletileng takitrde nzbrtikr drtwrgu. ");
INSERT INTO ntu_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Mrlz bade da kx mrlz x tubq. X mz nrlc tulvzo nzaodukr Yawe tqvzpe tqvzpe. ");
INSERT INTO ntu_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Yawe wz-ngrde bongavz mz natq kx kapxle, X nepi, temz, x vri amrlx mz nzycmne-krde. ");
INSERT INTO ntu_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Ata-lxblrtrle dcpwe me esz', X yrlqbzle bz ngr prla amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Nigu leplz amrlx mz nrlc, ncblo, olvz, x doa kxnztopwzng, Na-amrlueku x na-amatqku Yawe, Kxrpalz. ");
INSERT INTO ntu_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Murde wz-ngrde nrlc mz nzycmne-krde, X mz nzrkapx-krde natq dekc tqycngr. ");
INSERT INTO ntu_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Yawe atrkatile drtwr kx nzyrlq leplz, X ngi-batrpzle trnzngidati-kru mrkc tqpnz drtwrdr. ");
INSERT INTO ntu_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","A' drtwr kx yrlqleng ngidati zvz, X nqmq nr nabzde tqvzpe tqvzpe. ");
INSERT INTO ntu_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Sa namrlzbz mz lr drtqbr kcng tzangiolr Yawe murde nide Gct rdr. Murde leplz kcng tqmcpxle kx nangi nedeng nzabrtz-zvzng. ");
INSERT INTO ntu_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","14","Yawe obqom mrkc tqwxbuo-ngrmle mz tron nyzde Heven, Mz nzmco-krmle leplz amrlx mz nrlc ka. ");
INSERT INTO ntu_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Ngi batrpzle nzao-krdr drtwrdr, X krlzle da amrlx kcng tzalelrng. ");
INSERT INTO ntu_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","17","King traovxiou mz nzxplrkr ami nede. X ncblo ngr vea tr-rlapx-kzu mz nzxplr-krde x hcsi nede. ");
INSERT INTO ntu_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","A' Yawe kc tqaclvele krkcng tzamatqlr nide, X nzbrti drtwrdr nzaodu-zvz-krde nidr. ");
INSERT INTO ntu_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","Arlapxle nidr mz nzbzngr, X axplrle nidr mz mzli r dzbi. ");
INSERT INTO ntu_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Mnc-xgleku Yawe nzokatr-krde nigu. Murde nide temz ngr lomrgu kc tqyrputrngr nipna. ");
INSERT INTO ntu_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Abrtzlvzku nide, X drtwrgu abrtrpzku mz drtqde kxtr. ");
INSERT INTO ntu_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Krka'ku kx Yawe na-aodu-zvzle nigu Mz nzbrtikr drtwrgu nide. ");
INSERT INTO ntu_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Nabz ne Devet, mzli kc narpi-ngrbz nalukurnr-ngrde mz mz Abimilek, kc tqmapulr-ngrde nide x sc tqvzpe. Awi-zvzbo mz Yawe, X tramawxu nzglqpx-krnge nide. ");
INSERT INTO ntu_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Bilvz-zvzx Yawe mz nabznge, Murde nimu kx nzaetqbz drtqmu na-abrtzlvzamu da kcng tqaleleng. ");
INSERT INTO ntu_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Clve Yawe doa x da amrlx. Naglqlzku drtqde. X napipx-lxblr-ngrgu nzetu-krde. ");
INSERT INTO ntu_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Da kcng tqmwxlrtix, arlapxpebz Yawe ninge mz da lcng amrlx. Murde mzli kc tqkrka'-ngrbo bade, ayzlumle natqnge. ");
INSERT INTO ntu_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Elr! Na-abrtrpzmu drtwrmu mz Yawe, murde ma drtqmu tqmya, X na-abrtzlvzamu nzokatr-krde nimu. ");
INSERT INTO ntu_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Gct, mzli kc nzmnc-krnge tqtrka-ngrde, arlapxq ninge, Mz nzatutr-krm nzkrka'-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Ili! Enjrl ne Yawe arlapxle leplz mzli kc drtqdr tqetq-ngrde, Murde aclvele krkcng tzmyatitrlr Yawe. ");
INSERT INTO ntu_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Jzsamu ena nzmrlzkr Yawe x na-abrtr-krbzmu drtwrmu bade. Murde krkcng tqaclveleng nzabrtz-zvzng. ");
INSERT INTO ntu_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Kxnzvz-nqblqlr natq Yawe nzrngiscng da amrlx. Delc nimu leplz nedeng na-amrlue-ngrnamu nide. ");
INSERT INTO ntu_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Laion kx nzxplrng nzkrlzlr nzbrtalengr, Leplz kx nzvz-nqblqlr Yawe, trpnzngr da kx mrbrpxm badr. ");
INSERT INTO ntu_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Mrlxngeng x inyxngeng, lalztqmamu bange, Murde na-alvztrpo bamu kxnamu nzamrluengr Yawe. ");
INSERT INTO ntu_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","?Nike suti drtwrm? ?Nzlungr kxmrlz kxboi? ");
INSERT INTO ntu_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Obq zpwx, x bzkq pokiaq. Bzkq ycmne-atrkatiq leplz, ");
INSERT INTO ntu_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Prszpx nqmq kxtrka. X ale zvz da kxmrlz. X nasuti drtwrm nzmnc-zpwx-krmu badr leplz mz nrwx. ");
INSERT INTO ntu_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Rlxtibz ncblo kxtubq mz Yawe nzokatr-krde nide. X Yawe sa naxlrbzle nzkrka'-krde mz nzaclve-krde nide. ");
INSERT INTO ntu_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Sa napnanatile krkcng tzale-zvzng da kxtrka. Trobqpwzu badr x mzli kc nabz-ngrdr, ani txpwz nzmrbrtrkr mz drtwr nidr. ");
INSERT INTO ntu_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Takitrde nzxlr-krbz Yawe natq leplz kxnztubqng mzli kc tzyrni-ngrbzlr bade, Murde ngi nqmq krde nzokatr-krde leplz nedeng. ");
INSERT INTO ntu_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Vz zvz nzesolvzti-krde krkcng drtwrdr tqvz, X nzamnc-lrpi-krde krkcng nabzdr tqyrnibu. ");
INSERT INTO ntu_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Wzpxtx zlwz nzkxpukr ncblo kxtubq. A' Yawe sa na-arlapxle nide mz da lcng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","X mz nzaclve-zpwx-krde nide, Trpnzngr nrvr ngrdeng kx nztavxi. ");
INSERT INTO ntu_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Yawe sa na-ayrplapxle kxdrka'-ngrng kcng tztrkalr-ngrdr kxnztubqng. X nqmq krdr lc tqtrka sa nanibq-moule nidr. ");
INSERT INTO ntu_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Zvz Yawe nztu-krbzle mz nibr kxnzawz nedeng. X trpnzngr nzayrplapx-krde krkcng tzabrtrpzlr drtwrdr bade. ");
INSERT INTO ntu_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Nabz ne Devet. Yawe, tu-ngalelvz ninge, murde enqmi rngeng nztu-ngalelvz-kzlr ninge, X vecamu badr krkcng tqveckr badr. ");
INSERT INTO ntu_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","3","Yrlqbz temz ngr lomrm kc tqyrputrngr nipna, X twzm popz' x nipna scmqng, Mz nzarlapx-krm ninge mz ncblo kcng tzmaneutilr ninge. X apqtrp drtwrnge kx tume mz nibrnge. ");
INSERT INTO ntu_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Aovxiong x amyatibz drtq leplz kcng tzrpilr nanibqlr ninge. X krkcng tzrpilr na-atrkatilr ninge, nabzdr nzmu natalvzo x nadwaszlr nim. ");
INSERT INTO ntu_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Atwzlr-ngrm enjrl nem mz nzmaneuti-krde nidr. Na-apusr-ngrde nidr leu kxglr kxyrklz kcng tqvxu-pulrtine nenq. ");
INSERT INTO ntu_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Navoneng mz lrpzki kx miglq x tu r nzlo, Murde nataong mz nzdwasz-krdr enjrl lc. ");
INSERT INTO ntu_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Kxmule-esz' trpnzngr da kxtrka kx alebo badr, A' se tzatu-kapqng br scdr x tzekqng gq mz nzlolvz-krdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Mz drtwrnge mrlz nzpwrkilvc-krdr nzodatingr nidr, Mz nztao-mou-krdr mz br x trtxki kcng tzyrlqlr. ");
INSERT INTO ntu_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Gct, mzli lcde sa na-abrtzlvzx nim, X drtwrnge elalzm mz nzarlapx-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","X mz nabznge atwrnrngr, sa narpix kx, “Trpnzngr kx apule nim. Murde arlapxq kxtrnzxplrung mz mq kxnzxplrng, X kxtrpnzngr scdr zmatq mz kxnzrngiscng zmatq.” ");
INSERT INTO ntu_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","A' kxdrka'-ngrng nzabetitrlr ninge mz da kx tralewxu. Nzrpilr kx ninge kc tqrwzngr dalr nzkxpungr. ");
INSERT INTO ntu_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Alebo badr da kxmrlz, a' nzayzlu-ngrmlr mz da kxtrka, Kx talvzongr nabznge. ");
INSERT INTO ntu_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","14","Mz nzyagox-krdr, vzti drtwrngeng. X axtx-zvzx dakxnzng, X biox narnge mz nzkrka'-krnge nidr, Da kc tqwaisr-ngrne mzlengeng x kztengeng. Murde yc-zlwzngr drtwrnge nidr, Apule kx vzngr drtwrnge x yrnitix lxenge mzli kc tqbz-ngrde. ");
INSERT INTO ntu_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","A' mzli kx mnc-ngrne mz nzkxpungr, Nzyrlwr-lxblrng mz nzyrpalelvz-krdr ninge. Leplz kxtrkrlzwxung delcng tzatrkati-zvzlr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Nzxtrnga-ngrdr ninge mz da kx prtilzleng ninge, X nzmadqtimlr nqngidr bange. ");
INSERT INTO ntu_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","?Yawe, nzatrkatingr ninge lc, nakrlzbzle mzli kznike? Arlapx ninge mz leplz lcng tzapulr laion kx nangqdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","X sa na-awibo bam mz mz leplz nemqng Mzli kc nayrlwrngr mz nzangio-krgr nim. ");
INSERT INTO ntu_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Leplz lcng nzpxtxpx-krdr ninge trpnzngr noude. Bzkq rlr-ngrbzme badr nzabrtzlvz-krdr nzkxpu-krngeng, X nzyrpalelvz-krdr nzvzkr drtwrnge. ");
INSERT INTO ntu_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Trnzkrlzlru nzycmnengr mz nrwx. A' nzpikiti-zvzlr krkcng tzmnc-lrping mz ma nyzdr. ");
INSERT INTO ntu_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","X nzpibqti-kzlr ninge mz nzrpi-krdr kx, “Eke! A' mcpekr da kxtrka kc tqaleq.” ");
INSERT INTO ntu_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Yawe, krlzq nikeng nzalemlr bange. Bzkq mnc-lrpiq x obqlvztx-ngrn nidr. ");
INSERT INTO ntu_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","A' vzm, tum mz nibrnge, X ota-ngrbz ninge. ");
INSERT INTO ntu_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Bzkq rlr-ngrbzme badr nzbilvz-krdr ninge. A' pim bange trnzvz-rbr-krpwc'u murde tubqq mz nzryrlq-krm drtwr. ");
INSERT INTO ntu_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Bzkq rlr-ngrbzme nzrpi-krdr kx sc tzaovxiopelr ninge, X me pnz drtwrdr ngidape. ");
INSERT INTO ntu_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Amyatibz drtqdr krkcng tzabrtzlvzlr nzetqkr drtqnge. Krkcng tzobqszolr ninge drtqdr nzmu namya-zlwzng mz mz leplz x namanepeng. ");
INSERT INTO ntu_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","A' kztengeng kcng tzsuti drtwrdr kx natubqbo mz nzobq-krm, batrpz badr nzmalqlvz-krdr nim, Mz nzrpi-zvz-krdr kx, “Yawe, myalz-esz'-ngrn! X abrtzlvzq nzmnc-zpwxkr kxnzawz nem.” ");
INSERT INTO ntu_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","X mz zbq lc sa naglqlz-zvzx nim, Mz nzangrlvz-krnge nztubq-zlwz-krm. ");
INSERT INTO ntu_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Nabz ne Devet, kxnzawz ne Yawe. Gct, nzmncngr kxtrka vzdz-zvzm mz nabz kxdrka'-ngrng, X sc tqrpipebzle badr kx, “Bzkq amrlueamu Gct.” ");
INSERT INTO ntu_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","X batrpzle nzglqpx-lzbq-krdr. Murde nzrpilr trmcwq alwx rdrng x trna-ayrplapxwq nidr. ");
INSERT INTO ntu_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Natqdr trka-esz'ngr x yctr-ngrpwz nzpokiangr. Delc trtxpnzngr nzale-krdr da kxmrlz x tubq. ");
INSERT INTO ntu_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Mz nrlckxbq sc tzaoti drtwrdr nzryrlq-krdr drtwr kxtrka. Nzpxtxpx-ngrdr nzti kxtubq mz nzmrlzkr badr lrpzki kx vz-rbr. ");
INSERT INTO ntu_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Yawe, nzmyatxlzkr nzaodu-zvz-krm X nzangidati-zvz-krm natqm nzkrlzlzlr bongavz. ");
INSERT INTO ntu_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Nztubq-krm vzdz krlzbzle newz kxnzmyalzng, x vzo kz la me boongr. Murde aclve-zpwxq leplz x animol mz nzrsakrlrngr. ");
INSERT INTO ntu_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Gct, nzaodu-krm leplz mrlz-zlwzm bagr, Murde apusr-ngrm nigr nei kio kcng tzwxbulvzong lxedr. ");
INSERT INTO ntu_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Mz nzrka-zvz-krme nagr dakxnzng, dakxnzng lcng yctxpxng zvz. Murde avzo-zvzme zmrlz ngrm bagr, apule lue kc tqyrletx alo. ");
INSERT INTO ntu_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","X nim narlue r nzlu-krgr, Kc tqapu-zvzmle bagr nzyrlelz-krm aulz. ");
INSERT INTO ntu_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Yawe, navz zvz nzaodu-krm nigr kcng tzvz-nqblqlr nim, Mz nzamrlz-krm kx nabzdr tubq. ");
INSERT INTO ntu_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Bzkq rlrpx-ngrn mq kxdrka'-ngrng nzlolvz-krdr ninge, X kxnzglqpx-lzbqng bzkq nanycdr nzrnzlvzolr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Murde brti drtwrnge nzaovxio-krm kxdrka'-ngrng. X mz nztao-krdr, trpengr nztulz-mou-krmlr. ");
INSERT INTO ntu_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","4","Nabz ne Devet. Abrtzlvz nzwztr-krbzme mz Yawe, X sa nakabzle da kcng tqpq mz nabzm. Ale da kxmrlz x abrtrpz drtwrm bade, Murde namnc-zpwxq mz drtc' kc tqpile kx nakabzle bamu. Bzkq witibz nelzm nzmnckr kxdrka'-ngrng, Murde mzli trnaboiu x sc tzbzpeng. Bzkq kcmnz-ngrbzme nzalengr da kcng tzalelr, Murde nzlu-krdr sa namrbc nzapulr nabr kxglr mz mzli r nepi. ");
INSERT INTO ntu_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","7","Clveti-lzbq, x aenzli-lrpi mz nzabrtr-krbzme drtwrm mz Yawe. Bzkq nabzm talvzo mz nzrmc-krm leplz kxnzrngiscng nzvz-nqblq-krdr nqmq krdr kxtrka. Da kx na-aleq, mnc-xgle txpwz Yawe, X abrtrpz drtwrm bade, murde sa naokatrle nim. Delc sa na-aelwapx-ngrbzle nzopxkr nztubq-krm, Mz nzapu-krde nilz r nepi kc tqvz-esz'ngr mzli kc bea. ");
INSERT INTO ntu_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","11","Eu, bzkq drtwrm ngya x nabzm talvzo Murde da lcng li ma tzrkatrpzng bam drtwr kxtrka. Eu, murde kxnzabrtrpzlr drtwrdr mz Yawe sa nangi nyzdr drtc' kc tqpile nakabzle badr, A' kxdrka'-ngrng sa namaszlrtxpx-ngrng. Glqpx Yawe kx mzli trnaboipeu x kxdrka'-ngrng sc tzmrbrpeng. Kxmule-esz' rtangrtiq nidr a' trpengr nzmc-krmleng. Gct rlr-ngrbzle drtc' nyzde mz kxnzavzo-lzbqng. X sa na-abrtzng mz nzmnc-zpwx-krdr elr. ");
INSERT INTO ntu_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","15","Ili! Kxnztubqng x kxtrnzrngiscung na-aclvetio-lzbqng Murde kxdrka'-ngrng nzglalzpelr toki r vea x popz' scdr. Ili! A' kxdrka'-ngrng na-aclvetio-lzbq-kzng murde toki r vea scdr sa nanibq-moule nidr, X Yawe sa naplameitibzle popz' scdr. Jzs Yawe krkcng tzryrlqng drtwr kx na-atrkati-ngrdr kxnztubqng X nzmadqti-zvzbzlr nqngidr badr. Jzsle nidr mz nzodati-krde nidr, X yrpalelvz-zvzle nidr murde trpnzngr nzxplr-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","22","Kxetu Yawe aclve-zvzle kxnzvz-nqblqlr nide, X nikeng kabzle badr nangisc-alopedr. Kabzle badr dakxnzng kxkqlu mz mzli r dzbi, X okatrle nidr mzli kx prtzngr da. Lalztqmamu! Murde kxdrka'-ngrng sa nabzng, mz nzapu-krdr nrpq da kc tqplclqom X enqmi r Yawe lcng sa nangiliang na-apulr zsikapu. Mclr ncblo kxtubq, kxmule-esz' kxpipzne, Myaszpxle da kxkqlu kxngisc ncblo kxdrka'ngr. Murde Yawe sa nakatxpxbzle zmatq ngrdr kxdrka'-ngrng, A' sa naokatrle kxnztubqng. Ncblo kxdrka'-ngrng nzbi-txpwzlr nzrlxngr, x trnzkrlzlru nzrka-niwzlrngr. A' kxnzmrlzng yc mz drtwrdr nzrka-niwzlr-krdr vzmi kxnzamnzo-mzleu. Ncblo kcng tqamrlzng Yawe sa nangi nyzdr drtc' kc tqpile nakabzle badr. A' leplz kcng tqpilzleng sa nabzng. ");
INSERT INTO ntu_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","26","Oblamzngeng, bztipex nzmncngr, x ninge ka tqnginipenge lrtzlvz. X mcx kx nqmq kr ncblo kxtubq nide sele. Okatr-zvzle leplz mz nzrlr-nrbalq-krde dztudeng, x doa nedeng ngi da kxmrlz kx kabz Gct bade. Yawe okatr-zvzle nide x doa nedeng trnzyrnitrpwzung nadr dakxnzng. Pq mz drtwr Yawe nzaelwa-krbzle mz leplz lrpzki kx nao-zlilr, X mailz-zvzle krkcng tzabrtz-ngrdr nqmq krde. Pipxle kx kxmule-esz' nanycdr miglqpx, a' trnztaoung, Murde sc tqlolvz-amqngileng. ");
INSERT INTO ntu_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","29","Rtxtiamu nibrmu da kxtrka, x aleamu da kxmrlz, Murde neidu nemung namnc-along mz drtc' kc tqpi Yawe nakabzle bamu. Rpi Yawe kx mrlz bade da kxtubq, X okatr-zvzle kxnzabrtrpzlr drtwrdr bade. Sa naokatr-zvzle nidr, A' doa ne kxdrka'-ngrng sa nabzng. Sa nangi nyz leplz kxnzmrlzng drtc' kc tqpi Yawe nakabzle badr, X sa namnc-alopeng elr. ");
INSERT INTO ntu_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","33","Takitrde kx ncblo kxmrlz dekc tqvzkipxm natq ngr nzyrplapxngr, X nikeng pitileng tubq. Takitr-kzde nzkrlz-angidr-krde Lou amrlx sc Gct rde, X nzlolvz-amqngi-zvz-krdeleng. Vz zvz kxdrka'-ngrng nzaukzti-krdr leplz kxnzmrlzng, Murde nanibqlrng. Vz zvz Yawe nzkapx-krmle ncblo kxmrlz mz mq enqmi rdeng, X mzli kc natwz-ngrdr nide mz kot, trnzaovxiolru nide. ");
INSERT INTO ntu_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","36","Wz zvz mz nzabrtr-krbzmu drtwrmu bade, Murde sa nangi nyzmu drtc' kc tqpile nakabzle bamu mz nzamatq-krde nimu. X sa namcamu nzmaneutipx-krde kxdrka'-ngrng. Xlrmamu natqnge. Mcx kzdq ncblo kxdrka'ngr kxtrka-esz'ngr, x atrkati-zvzle leplz. Xplr-esz'ngr x obqszo-ngrde leplz amrlx. X kxmule-esz' rtangrtix nide, a' trmcpewxu, murde mrbrpe. ");
INSERT INTO ntu_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","40","Yrlq angidr mz drtwrm ncblo kxmrlz kxtubq, murde mnc mz nrwx, X doa kxnzmika mz neidu lrde nzkqlu-zlwzng. Yrpalelvzx kxdrka'-ngrng murde sa nabzting, X doa lr neidu lrdr sa nayrkrtxong. Zvz Yawe na-arlapxle kxnztubqng. Murde nide me nzrlakitrlr mz mzli r nzkxpu-krdr. Zvz Yawe na-arlapxbzle nidr mz mq kxdrka'-ngrng, Murde nzbrti drtwrdr nide nzokatr-krde nidr. ");
INSERT INTO ntu_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Nabz ne Devet. Yawe, kxmule-esz' ngyati drtwrm ninge, A' bzkq ayrplapxq ninge. ");
INSERT INTO ntu_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Murde nipna scmqng tupe bange, X pnzplrope-ngrn ninge. ");
INSERT INTO ntu_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Xngitxtr-zlwzpex nzngyatikr drtwrm ninge. X yangrnga-zlwz-ngrne alwx rngeng. ");
INSERT INTO ntu_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Zmrlepu r alwx lcng sc tqayrngzpupele ninge, X apupex ncblo kx boo mz alwx ngrdeng. ");
INSERT INTO ntu_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Nzngqngu-plxsr-krnge aetqpemle drtqnge, Apule kxsqki kx mibi x brtu. ");
INSERT INTO ntu_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Alwx rngeng nzyrlamyro-ngrdr ninge. Delc drle mzke' tqtao zvz mz zbq kang kqlu. ");
INSERT INTO ntu_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Nzyagox-krnge apule nyr kx ngcpxm mz nrkrdrtqnge. X nzxplr-krnge yrkrtxpxpebz. ");
INSERT INTO ntu_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Nzetqkr drtqnge wibrti-zlwzpe-ngrde ninge. X bztipenge nzyrningr murde drtqnge rkrkx-zlwzpe. ");
INSERT INTO ntu_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Yawe, krlzpeq da amrlx kcng tqpq zlwz mz drtwrnge murde namnc-zpwxx. X xlrpe-kzpe' nzyrke-zlwz-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Mzli ka drtqnge mewepe x nzycmini-krnge vz-ebirpengr, X mzke' obqkipele mrkzble. ");
INSERT INTO ntu_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Kztengeng nzngangrpe-ngrdr ninge murde kxsqki rngeng. X kxnginingeng trnzesotrpepqngqu bange. ");
INSERT INTO ntu_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Krkcng tzrpilr nanibqlr ninge, Nzamwipelr trtxki rnge. X krkcng tzaetqmlr drtqnge, sc tzrpilr naodatilr ninge. X sc tzryrlq-zvzng drtwr mz nzatrkati-krdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","A' opxm kx trxlrwxu nzycmnekr enqmi rngeng. X trkrlzwxu nzycmnengr. ");
INSERT INTO ntu_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Eu, apubo badr kx nradrtqde ngq, X trayzlupwc'u natqdr. ");
INSERT INTO ntu_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Murde nim Yawe kx na-ayzlubzle nike nzalemlr bange, Mz nzngini-krm Gct rnge kc tqabrtrpo drtwrnge bade. ");
INSERT INTO ntu_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Bzkq rlr-ngrbzme nzabrtzlvz-krdr nzetqkr drtqnge. X bzkq nzglqpx-lzbqng mz nzaovxio-krdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Murde ycpe pipz nzodati-krdr ninge, X nzetq-zvzkr drtqnge tryrkrtxpxpeu. ");
INSERT INTO ntu_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Naplztxpxx nzvz-rbr-krngeng, Murde nzbatrplr nzkxnekr drtqnge. ");
INSERT INTO ntu_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Enqmi rngeng nzxplrng x nzlu-zpwxng. X nzkqlung kx nztrkati nivz lrdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Da kxmrlz kcng tqalebo badr, nzayzlumlr mz da kxtrka. Nzpxtxpx-ngrdr ninge murde vz-nqblqx nzmncngr kxtubq. ");
INSERT INTO ntu_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Yawe, bzkq amnctxnq ninge esz'-krnge, X bzkq mnc-zvzme rlru. ");
INSERT INTO ntu_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Kxetu, vz-anim mz nzokatr-krm ninge, Murde nim Mevalu rnge. ");
INSERT INTO ntu_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Nabz ne Devet. Yawe, pnzpe drtwrnge kx namnc-lrpitxpwo, a' bzkq alex alwx mz nzlctr-krbz drtwrnge bam mz nzkxpu-krngeng. Murde kxdrka'-ngrng lcng tzmnc-aepztrpqng bange, ma tzxtrnga-ngrdr nzlqngi-krm. ");
INSERT INTO ntu_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","X kxmule-esz' trycmnewxu, A' nzkxpu-krngeng etunepx zvz, delc tqtalvzongr nabznge. ");
INSERT INTO ntu_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","X mz nzaotikr drtwrnge nzkxpu-krngeng, nztalvzokr nabznge mrilvzole ninge. X mzli kc tqrblxm bange nzmnc-lrpi-krnge, sc tqrpipebo bam kx, ");
INSERT INTO ntu_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","“Yawe, nzlu-krnge mrbcnepwz. ?Memule tqpxlavxpx-ngrbzme nzkxpu-krnge? ?Myx mzli kx naesakingr trnzmnc-zpwx-krpwc'u lc?” ");
INSERT INTO ntu_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Murde nim kx amrbctrp nzlu-krnge. X mzli kx lutix ngi da txne mz nzobq-krm. Nzlukr leplz mrbcnepwz apule nzyrplaokr nrc kxesz'. ");
INSERT INTO ntu_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Nzwz-katongr ngi brmrdakr apule nounc kc trpnzngr nrade. X mz nzbzkr leplz trpnzngr dztudrng kx natwzlr. ");
INSERT INTO ntu_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","?Kxetu nike naobqtipxx mz nzmnc-krnge lc tqngi brmrda? Mwx namrlz nzbrti-zvzkr drtwrnge nim. ");
INSERT INTO ntu_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Murde na-arlapxq ninge mz alwx rngeng amrlx, X kxnzlukurnrng ma tzyrpalelvzlr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Mzli ka, dcpxpe mz drtwrnge kx vz-rbrx nzlctr-krbz drtwrnge bam mz nzkxpu-krngeng. Murde tubq nzayrplapx-krm ninge mz alwx rngeng. ");
INSERT INTO ntu_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","A' bzkq ayrplatipx-zvzq ninge, Murde ycpe pipz nzbztr-krbo mz mqm. ");
INSERT INTO ntu_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Mz nzayrplapx-krm leplz, odatibzme dztudrng kcng tqmrlzbz badr. Apusr-ngrbzmeleng da kx yrti ninr, Murde nakrlzlr kx nzvz-rbrng mz nzobq-krm. Nzlukr leplz mrbcnepwz apule nzyrplaokr nrc kxesz'. ");
INSERT INTO ntu_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Yawe, xlrm nzkrka'-krnge x nzyrni-krnge. Murde nzmrbckr nzmncngr mz nrlc apunepwzle nzwoukr betepu. ");
INSERT INTO ntu_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Ayrkrtxpx nzetqkr drtqnge x aotxpxbz drtqnge, Murde mwx na-abrtztx-kaix mzli kxpipz x ninge kc tqbz ate. ");
INSERT INTO ntu_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Yawe, sc tqaenzli-lrpipebo bam nzokatr-krm ninge. X mzli kc tqkqle-ngrne nim, xlrme nzkrka'-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Veclzme ninge mz gq ngr nzbzngr x mz nabz mu kxrluo. Atuome ninge mz rplz kxetu, x trpengr doa x da kx namwxlrtix. ");
INSERT INTO ntu_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Alvztrpe' bange kc nabz kxmrna mz nzrglqlzngr nim. X mzli kc naxlrngr leplz nzngr-krngele, sa na-angiolr nim x na-abrtrpzlr drtwrdr bam. ");
INSERT INTO ntu_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Namrlzbz mz leplz kcng tzabrtrpzlr drtwrdr bam, Krkcng trnzprtrpwzung mz leplz kcng tzglqpx-lzbq-ngrdr x tzpokiang. ");
INSERT INTO ntu_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Yawe, nim Gct rgr x trpnzngr kx apule nim. Aleme bagr da kxkqlu mz nzatutr-krm drtwr kx yrlqq mz nzamrlz-krm nigr. Drtwrnge yrpz'trpz nzrlwxngr da lcng amrlx, Murde nzkqlu-zlwzng. ");
INSERT INTO ntu_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Trsutiu drtwrm nzrka-ngrbz bam dalr nrlanc ayrnrngr x dalr nzrkatxngr alwx. X tr-rlx-kzpe'u blz x animol kx na-angcom mz olta nyzm. A' da kx suti txpwz drtwrm nzxlr-krbo natqm, Murde narlrpx-ngrbo nrkrdrtqnge bam. ");
INSERT INTO ntu_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Delc tqrpi-ngrbo bam kx, “Ninge kape. Na-atutrx natq kcng tqyclzm mz Nzryrngrkxtr. ");
INSERT INTO ntu_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Gct rnge, abrtzlvzx nzale-krnge me pnz drtwrm, Murde nabznge lolvz-amqngipele nzalvztr-krmqng.” ");
INSERT INTO ntu_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","10","Yawe, trnayrlq-kapqpou nzaodu-krm x nzangidati-krm mz leplz nemqng. A' sa napipx-zvzbo nrpa ngr nzarlapx-krm nigr Mz nzyrlwrpx-lxblr-krgr. X krlzq kx vz zvz nzpipx-krngele. ");
INSERT INTO ntu_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Yawe, krlzx kx yckqti zvz drtwrm ninge. X nzaodu-krm x nzangidati-krm nzngini-zvzmlr lrpalvc kx mncpx-ngrmc. ");
INSERT INTO ntu_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","A' mzli ka, rblx nzrlwx-krnge nzkxpungr amrlx kx nzprtztimqng bange. X alwx rngeng nzmrilvzolr ninge x nzayc-kapqmlr bange da kxtubq. Murde nzkqlu-zlwz-krdr nzmyaszpxlr nqnginarnge. X nabznge tqtalvzo-zlwz-ngrde. ");
INSERT INTO ntu_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Yawe, vz-anim mz nzarlapx-krm ninge. Kxetu, rnekim mz nzokatr-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Okatrp ninge nzaovxio-krnge kxnzrpilr naodatilr ninge, Murde drtqdr namya x naobqszong mzli kc nadwasz-ngrdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","X leplz lcng tzxtrnga-ngrdr ninge nelzdr navzdzm Mzli kc nametx-ngrmlr bange. ");
INSERT INTO ntu_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","A' amrlz krkcng tzbrti drtwrdr nim Mz rka-krbzme badr nzabrtz-zlwzngr, Murde na-awi-zvz-ngrbzlr bam nzarlapx-krm nidr Mz nzrpi-krbzlr kx, “Gct, nim kx myatxlz-esz'ngr.” ");
INSERT INTO ntu_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Kxetu, trxplrwxu x trpnzngr scnge zmatq. Bzkq mrbrtr mz drtwrm ninge. Murde nim txpwz Mevalu rnge. Bzkq asaq nzokatr-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Namrlzbz mz doa kcng tzmrlztilr leplz kxnzmaneng, Murde Yawe sa naokatrle nidr mzli kc nakxpu-ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Sa na-aclvebzle nzlu-krdr. X trtxpnzngr nzrlr-krbzle nidr mz mq enqmi rdrng. Delc tzrpi-ngrbz kx Yawe amrlzpele lr mrnyzdr Israel. ");
INSERT INTO ntu_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Sa naokatrng Yawe mz nzamrlz-mou-krde nrkrdrtqdr Mzli kc nayagox-ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Yawe, krka'-ngrne kx nayc mz drtwrm ninge X na-amrlz mou ninge. Zyagox kc tqycpxm mz nabznge Vzpxm mz alwx rngeng kcng tzatrkatilr nim. ");
INSERT INTO ntu_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Enqmi rngeng nzpibqtilr ninge, Nzrpilr kx, “?Myx mzli kx nabz-ngrde, murde namrbrtxtr mz drtwr nide?” ");
INSERT INTO ntu_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Kzdung leplz lcng tzoklatimlr ninge, nzpokiatilr kx nzyc mz drtwrdr ninge. A' nzrpilr nakrlzlr kxmu nzkxpu-krnge, murde nayapwxtinedr mz mztea amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Nztrkati nivz lrdr ninge nzpikiti-lrpi-zvzlr ninge. X nzaoti txpwz drtwrdr da kxtrka kx nadwatimle ninge. ");
INSERT INTO ntu_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Nzrpi-awalr kx, “Mrlztxpe! Mzli ka prtilz-zlwzpe zyagox kxtrka, X mzli trnaboiu x sc tqbzpe.” ");
INSERT INTO ntu_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Mzli ka, kztenge kc tqabrtr-zlwzbo drtwrnge bade, X tqmukr ncdr, nipe-kzde enqmi rnge. ");
INSERT INTO ntu_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Yawe, krka'-ngrne kx nayc mz drtwrm ninge. Amrlz-mopwz nrkrdrtqnge murde na-ayzlu-mopwc' da kcng tqtrka tzalemlr bange. ");
INSERT INTO ntu_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","X mzli kc trna-aovxio-ngrdru ninge, Sa nakrlz-angidrpex kx abrtzlvzq ninge. ");
INSERT INTO ntu_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Sa naokatrq ninge nzale-krnge da kxtubq, X namnc-alotrpebo bam. ");
INSERT INTO ntu_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Naglqpxku Yawe, Gct r lr Israel. Mzli ka x tqyc tqyc, naglqpxku Yawe. ");
INSERT INTO ntu_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Nabz ne nqvi lr Kora. Gct, nzmingrti-zlwzkr drtwrnge nim Apule animol kc drtwrde tqbrlxkz mqde lue. ");
INSERT INTO ntu_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Nim Gct kc tqlu x nzsutikr drtwrnge nim apule nzbrlxkztikr drtwrnge lue kxbao. ?Myx mzli kx naxngi-ngrbo nzmnc-krme bange? ");
INSERT INTO ntu_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Mz zbq kang kqlu yrni-zvzx x mnqtxpwo drlemzke' kx piz. A' enqmi rngeng nzyrpalelvzlr ninge, nzrpimlr kx, “?Memule Gct rm trokatrpe-ngrdeu nim? ?Bzpe?” ");
INSERT INTO ntu_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Gct, mzli ka drtwrnge yrnibutx zlwz. A' dcpx mou mz drtwrnge mzli kc ena tqmailztr-ngrne leplz Mangr-nzangiongr nim. Mzli lcde abrtz-zlwzkr x ngr-katokr mz nzglqlz-krgr nim. ");
INSERT INTO ntu_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Kxmule-esz' nabznge talvzo x nelznge vzdzm, A' sa na-abrtxtrpwo drtwrnge bam. Murde naglqlz-mou-ngrne nim kalr, Mzli kc na-arlapxq ninge. ");
INSERT INTO ntu_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","7","Gct rnge, mzli boipe trnzkrlzpe-krpou Israel. ?Memule tqpulio-zvz-ngrme bange nzkxpungr mz nzapu-krde lue kxvo? Nzvzdz-krm nelznge vz-ebirnrpe-ngrm bange apule nrc kcng tzyrplalvzolr ninge. X nztalvzokr nabznge xplr-zlwzpe apule nzyrpukr lue kxtalio mz nabzde. X ebio ngr srkau amrlx kcng tqatwzlr-ngrme nzalxlvrtine-zvzlr ninge. A' nadcpx mz drtwrnge da kcng tqmyalz tqaleq Israel, Mrkc tqyrlengr LueJodzn x tqycngr Newz Hemon x Newz Misa. ");
INSERT INTO ntu_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Murde vz zvz nzpulio-krme nivz lrm mz zbq kang kqlu. X ngrbo bam mz nrlckxbq vzmi nzkrka'-krnge murde nim Gct kx rkam nzlungr bange. ");
INSERT INTO ntu_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Gct, nim butqbr nyznge. ?Memule tqmrbrtitrpengr drtwrm ninge? ?X memule tqkxpu-zvz-ngrne Mz nzaetqti-krm enqmi rngeng drtqnge? ");
INSERT INTO ntu_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Nzrpi-zvzmlr bange kx, “?Memule Gct rm trokatrpe-ngrdeu nim? ?Bzpe?” X sc tqvz zvz nzngzlilvzti-krdr ninge natq kxtrka. ");
INSERT INTO ntu_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Kxmule-esz' nabznge talvzo x nelznge vzdzm, A' sa na-abrtxtrpwo drtwrnge bam. Murde naglqlz-mou-ngrne nim kalr, Mzli kc na-arlapxq ninge. ");
INSERT INTO ntu_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Gct, pipxbz mz krkcng trnzangiolru nim kx trvz-rbrwxu. Arlapx ninge mz mq krkcng tztrkating x tzpokiang. ");
INSERT INTO ntu_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Nim me rlakitrx. ?Memule tqrlasz-ngrn ninge? ?X memule tqkxpu-zvz-ngrne Mz nzaetqti-krm enqmi rngeng drtqnge? ");
INSERT INTO ntu_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Atwzlr-ngrm bange zyzlr ngrm x nzalvztrngr angidrng, Mz nzmailz-mou-krdr ninge Saeon, mz newz kxtr nyzm. Murde nakrlzlzbo Mangr-nzangiongr kc tqmnc-ngrn, ");
INSERT INTO ntu_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","X na-angiox nim mz olta nyzm, Mz nzngini-krm nou nzabrtz-krnge. X na-angrlvzx nim mz nzayrni-krbo gita bam. ");
INSERT INTO ntu_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Kxmule-esz' nabznge talvzo x nelznge vzdzm, A' sa na-abrtxtrpwo drtwrnge bam. Murde naglqlz-mou-ngrne nim kalr, Mzli kc na-arlapxq ninge. ");
INSERT INTO ntu_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Nabz ne nqvi lr Kora kx nzyrbzlr mz kxrmailz ngr dzbe kxnzngrng. Gct, xlrpekr nrpa ngr da kxetuting kcng tqalebzme mz melrmqgrng mzli kc bqnc, Mz nzpi-krmlrle bagr mzli kc. ");
INSERT INTO ntu_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Nzayrplapx-krm lr mrkzbleng apule lxbi kc tzbolvzti mz nrlanc nyzm. X petio-alzuq leplz nemqng mz drtc' nyzdr mz nzamnc-zpwx-krm nidr. ");
INSERT INTO ntu_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Melrmqgr lcng trnzaovxiolru enqmi rdrng mz toki r vea scdr x mz zmatq ngrdr esz'-krdr. A' leplz nemqng nzaovxiong mz zmatq ngrm, mz nzxplr-krm, x mz nzmnc-krbzme badr mz nzaodu-krm nidr. ");
INSERT INTO ntu_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Gct, nim King rnge. Nim kx rngi-batrp nzaovxio-krgr, nigr neidu lr Jekop. ");
INSERT INTO ntu_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Milxtxopekr enqmi rgrng mz nzxplr-krm. X rnzlvzokr kxnzatrkatilr nigr mz zmatq ngr drtqm. ");
INSERT INTO ntu_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Murde trbrtiu drtwrnge popz' x toki r vea scnge Nzarlapx-krdr ninge mz nzotangr. ");
INSERT INTO ntu_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","A' ni-txpwzme kx arlapxle nigr mz enqmi rgrng, Mz nzamyati-krbzme drtqdr. ");
INSERT INTO ntu_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Sa naglqlz-zvzkr nim. X nzawi-krbzkr bam tqvzpe tqvzpe. ");
INSERT INTO ntu_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","?A' memule drtqm tqsatrpe-ngrmle bagr, trokatrpe-ngrnqu ncblo ngr vea negrng? Mzli ka rlrtx-ngrpwzme mz enqmi rgrng nzamyati-krmlr drtqgr. ");
INSERT INTO ntu_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","X ngi-batrpeme nzdwasz-krgr nidr, X nztwz-krdr dztugrng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","X rlr-ngrbzme badr nznibq-krdr nigr mz nzapu-krgr sip, X nzvzmilr nigr mz drtc' nyzdrng mz nzwz-nrbalqtr-krbzkr badr. ");
INSERT INTO ntu_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Apule kx amwabzme nigr badr mz narncbr kx topwzne, Mz nzapusr-krm nigr brmrda. ");
INSERT INTO ntu_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Lr mrkzbleng kcng tzmnc-aepztrpqng bagr nznelvzlr nigr mz nzamyati-krmlr drtqgr, X nzxtrnga-ngrdr nigr. ");
INSERT INTO ntu_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","X neidu mz nrlc tulvzo nzobqszo-ngrdr nigr Mz nzyrpalelvz-krdr nigr. ");
INSERT INTO ntu_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Aputr-zvzbo da kxtrka mz nzobqkr leplz lcng, X drtqnge mya zvz. ");
INSERT INTO ntu_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","Murde xlrx natq kxtrka kcng tzpimlr bange, X mcx nzmnc-krm enqmi rngeng. ");
INSERT INTO ntu_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Kxmule-esz' nzprtzmqng bagr da lcng A' trmrbrtru mz drtwrgr nim x Nzesz'tikr Drtwrgu. ");
INSERT INTO ntu_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Kxmule-esz' traxtxpekru nim, X o-zli-zvzkr nzti rm, ");
INSERT INTO ntu_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","A' katrpzme nigr mz mq enqmi rgrng mz nzrnzbrti-krdr nigr, mz nzapu-krdr kuli kzpetong. X nzaovxiolr nigr x kzdung nigr nzyrtzmqpeng mz gq. ");
INSERT INTO ntu_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Gct rgr, nzmu navecpx-lzbqmgr bam, Mz nzangio-krgr gct kzble, ");
INSERT INTO ntu_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","Tryc-kapqpwzu bam, Murde obqplxq nabzgr. ");
INSERT INTO ntu_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","A' mz nzngini-krgr doa nemqng, vz zvz nznibqti-krdr nigr, Mz nzapusr-krdr nigr sip kcng tzmnc-nabung mz nzrnibqngr nidr. ");
INSERT INTO ntu_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Kxetu rgr, bzkq esablqme. ?Memule tro-lxlvr-ngrpwe'u bagr? Vz-anim, x bzkq pxtxpx-ngrn nigr. ");
INSERT INTO ntu_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Lxlvrm bagr, Mz nzdcpxkr mz drtwrm nzetqkr drtqgr x nzkxpu-krgr. ");
INSERT INTO ntu_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Drtwrgr esz'tipe kx sa nabzpekr, Mz nztangqgxlz-krmgr mz drtc'. ");
INSERT INTO ntu_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Gct, vz-anim x okatrp nigr. Arlapx nigr murde aodu-zvzq nigr. ");
INSERT INTO ntu_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Nabz ngr nivz kx nzyr nqvi lr Kora. King rnge, krlc nabz nenge kx nangr-ngrbo bam. Nabznge esz'ngr natq kxmrlzting. X nzngqpx-krm natq mz naonge Apule nzyrlepx-krm lue mz butqbr. ");
INSERT INTO ntu_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Nzobq-krm lqngipx-esz'ngr. X natq ngr nzamrlzngr ngqpx-zvzm mz naom. Delc tqamrlz-zvz-kzngr Gct nim. ");
INSERT INTO ntu_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Nim ncblo kxmyalz-esz'ngr x xplr zlwz mz nzotangr. Alvco toki r vea scm mz bxli rde kc mz nrkalom. ");
INSERT INTO ntu_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Murde kalr mz nzvo-krm mz vea na-aovxioq enqmi rmqng mz nzxplr-krm. X nalolvz-amqngiq da kxtubq x leplz kxnzavzo-lzbqng mz zmatq ngrm. ");
INSERT INTO ntu_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","X nipna scmqng natu x nalvctrng mz lomr enqmi rmqng, X lr mrkzbleng amrlx namnclzbzng bam. ");
INSERT INTO ntu_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Nzyrlqkr Gct lc nzngini-krm King tqyc tqyc, Mz nzaclve-krm leplz nemqng mz nzmncngr kx tubq-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Mrlzbz bam da kxtubq, a' px-ngrn da kxtrka. Dekc Yawe, Gct rm, tqmcpxpe-ngrde nim mz nzmyaszlz-krm kztemqng. X tqglqlz-ngrde nim, Murde na-aelule nim tolo ngr nzabrtzngr. ");
INSERT INTO ntu_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Lrpzmqng nzaeluti zvz mz tolo kx mnrte mrlzvxi. X ncblo sc tzayrnibzng gita bam Murde na-aelalzmle drtwrm, Mz nabz ma nyzm kx mzte luli-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","X olvi kc nangi kwin ngrm tutrpz mz nrlarm kxrtc, nzangrlopliti da kx nzwzngr mz gol kxpnapr. Olvi lc nide kzdq inyx king kcng tzmncng ma nyzm. ");
INSERT INTO ntu_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","11","Nim la nanginim Kwin. Lalztqm bange x aclvetio-lzbq. Mzli kznike ncblo ngrm suti-zlwzngr drtwrde nim mz nzlqngivxikr mzpq, Mnclzbz bade mz nzngini-krde King x Kxetu rm. X bzkq matq-zlwzpe mz drtwrm trtem x kxnginimqng. ");
INSERT INTO ntu_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Kxmule-esz' lr Taea nzrkabzng da kxlqlwx bam, A' bzkq nzbatrpzlr nzrnzlvzo-krm me pnz drtwr ncblo ngrm, kc tqngi king. ");
INSERT INTO ntu_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Mzpq lxngipx-esz'ngr mz nzprtr-krm ma nyz king. X lrpzmqng nzkxsilvztitr gol. ");
INSERT INTO ntu_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Nim kc tqkq lrpz kxluli nzvzmibzlr nim mz king. X kztemqng kx nzmnc-kamelrng nzvz-nqblqlr nim, mz nztutr-krbzmu mz mzte. ");
INSERT INTO ntu_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Mz nzprtr-krmu lc ma nyzde, Drtwrmu elalzm x abrtz-zlwzamu. ");
INSERT INTO ntu_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","King rnge, doa ncblo kcng mztr namc mz nqvi lrm sa nangini-kzdr king, da kc tzwai melrmqdrng mzli kc. X nangi-batrpzme nzaclve-atwrnr-krdr drtc' nyzm. ");
INSERT INTO ntu_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Nabz nenge sa narkatrpz nabztq mz leplz nzamatq-zvz-krdr drtqm, X nzglqlz-krdr nim tqvzpe tqvzpe. ");
INSERT INTO ntu_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Nabz ne nqvi lr Kora. Gct kc tqmyatxlz, nide me rlakitrku x axplrle nigu, X mz nzkqle-krgu nide mz mzli kx nzkxpungr, okatrle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","3","Kxmule-esz' nengq aycngrlrle nrlc, x newz nzbrkaong prla, X kxmule-esz' dxvo votrp x nrc oda, X newz nzycngrlr-ngrdr kz nzyrpukr nrc kxetuting, A' trmwxlrkuu murde abrtrpzku drtwrgu mz Gct. ");
INSERT INTO ntu_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Gct kc tqmyatxlz mnc mz mztea kxtr nyzde, Jerusalem, Mrkc tqpulio-ngrmle nzabrtzngr bagu, Mz nzngini-krgu lr mrnyzde. Nzvzo-krmle bagu apule lue kx yrle-kato. ");
INSERT INTO ntu_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","X rblx nzodatingr Jerusalem murde Gct mncm bagu, X naokatrle nigu mz zbq kxmrna. ");
INSERT INTO ntu_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","A' mz nzxlrkr lr nrlc natqde nzmwxlr-zlwzng. X ngyati drtwrdr nide murde aovxio-zvzle ami ngr kandre amlrx. ");
INSERT INTO ntu_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Yawe nide ngrlrvea ngrgu, X nide lrpalvc nyzgu. ");
INSERT INTO ntu_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Obqmamu! Mcamu da kc tqale Yawe. Murde aletile da kx nzodating mz nrlc ka. ");
INSERT INTO ntu_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Aesakile vea amrlx mz nrlc tulvzo. Plameitile popz' x nipna x dalr vea amrlx x rtclz-ngrdeng mz nyr. ");
INSERT INTO ntu_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","X rpile kx, “Bzkq ota-zvzamu. A' metxpemamu bange murde ninge txpwz Gct. X ninge txpwz kx myatxlzbz mz neidu amrlx mz nrlc tulvzo.” ");
INSERT INTO ntu_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Yawe kc tqrninr mncpem bagu, X nide lrpalvc nyzgu. ");
INSERT INTO ntu_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Nabz ne nqvi lr Kora. Nigu leplz amrlx na-ayrlewzku da Mz nzngr-abrtz-kato-krbzku mz Yawe, Gct rgu. ");
INSERT INTO ntu_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Murde na-amrlueku nide kc tqmyatxlz-esz'ngr, Mz nzngini-krde King kxmatq kc tqaclvele nrlc. ");
INSERT INTO ntu_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Batrpzle nzaovxio-krgu lr mrkzbleng, Mz nzmnclz-krmlr bagu. ");
INSERT INTO ntu_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Nigu leplz ngr nqvi lr Jekop kcng tqmrlzting Yawe, Bilvzpeku drtc' kc tqmcpxbzle nangi nyzgu. ");
INSERT INTO ntu_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Mzli kc Yawe tqwxbuo-ngrmle mz tron nyzde Mangr-nzangiongr, Sc tqrvxupeku trpu x tqmalq-katopeku mz nzabrtzlvz-krgu nide. ");
INSERT INTO ntu_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Nangr-katobzku mz Yawe Gct rgu. Murde nide King rgu, nangr-katobzku bade. ");
INSERT INTO ntu_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Naglqlzku nide mz nabz kxyrlvi, Murde nide King r nrlc tulvzo. ");
INSERT INTO ntu_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","X wxbu mz tron kxtr nyzde, Mz nzaclve-krde neidu amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Kxnzmailzlr lr mrkzbleng nzaxvctr-lzbqmqng bagu, nigu leplz neng Gct r Ebraam. Murde Gct kc tqmyatxlz-esz'ngr myaszpxle king amrlx mz nrlc. ");
INSERT INTO ntu_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Nabz ne nqvi lr Kora. Yawe myatxlz-esz'ngr. X takitrde nzglqlz-krgu nide Mz mzteadau nyzde kc tqycom Saeon, newz kxtr nyzde. ");
INSERT INTO ntu_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Nide king kx rngisc zmatq. X Newz Saeon myatxlz x mzte opx. X Mzteadau nyzde rkatrpz nzabrtzkr leplz mz nrlc tqlvzo. ");
INSERT INTO ntu_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Gct aelwapxpe-ngrde kx trpnzngr da kx nakx mz drtqgu, Mz nzmncpx-krmgu badr mz lrpalvc nyzdeng mz mzteadau lc. ");
INSERT INTO ntu_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Kzdung king nzvzmqng nztung me esz'. Nzrpilr naotang badr lr mzteadau lc. ");
INSERT INTO ntu_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","A' kx nzmclr nzmatq-zlwzkr mzteadau Jerusalem, Nzkctipx-ngrdr x sc tzdwapeng mz zmwxlr, ");
INSERT INTO ntu_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","7","Kc tqprtilzle nidr Apule zvetq ngr drtq olvz kx narmika. X nzrnrcti-lzbqng Apule lcsu kxrtcnengr srkau ngr nounenq. ");
INSERT INTO ntu_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","X mzli lcpwz, tqmnc-ngrgu mzteadau nyz Gct rgu, Sc tqmcpe-kzku kx Yawe nide Gct kc tqrninr. X atu-amqngi-zvzle mzteadau lc, Da kc tzwai nzyapwxtipxkr melrmqgung le mzli kc. ");
INSERT INTO ntu_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Gct, aoti zvz drtwrgr nzaodu-krm Mz nzvztr-krgr Mangr-nzangiongr nim. ");
INSERT INTO ntu_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Leplz amrlx mz nrlc tulvzo sa naglqlzlr nim mz nzxlr-krdr nzmyalz-krm. Murde nzaclve-angidr-krm tubq. ");
INSERT INTO ntu_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","X nigr lr Israel amrlx nzabrtz-ngrgr kz Nztubqkr da kx pipxq. ");
INSERT INTO ntu_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Nigu leplz neng Gct, naolvxtiku Jerusalem, X nabrti mzku mrkcng tztu-ngrdr kxnzaukz nedeng. ");
INSERT INTO ntu_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Naobqlvzti-zpwxku drkq ngrdeng x nzmqngikr lrpalvc ngrdeng, Murde nayapwxtipx-zvzbz mz doa ne doa negung. ");
INSERT INTO ntu_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Nzmyalzkr Gct rgu sc tqaelwapx-lzbqngr mz mzteadau lc. X sc tqmailzle nigu tqyc tqyc. ");
INSERT INTO ntu_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","2","Nabz ne nqvi lr Kora. Lalztqmamu x xlrmamu natqnge, nimu neidung mz nrlc tulvzo, Kxmule-esz' nimu kxnzetung, leplz txneng, bcnyrng, x kxtrnzrngiscung. ");
INSERT INTO ntu_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Murde natqnge otxpx, X alvztr-ngrne nzyrplapxngr, ");
INSERT INTO ntu_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Mz nzpipx-krnge natq lrtzlvz ngrgung. Murde nayokaetipxx drtwr ngrdr mz nabz nenge. ");
INSERT INTO ntu_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Kxmule-esz' kxpux mz nztu-ngalelvzkr enqmi rngeng ninge, A' trmwxlrwxu. ");
INSERT INTO ntu_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Murde kxdrka'ngr lcng nzabrtrpzlr drtwrdr mz trau, X nzglqpx-lzbqng mz nzngini-krdr bcnyrng. ");
INSERT INTO ntu_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","9","A' trpnzngr kxrkrlz nzxpepx-krde nzlu-krde esz'-krde. Murde ncblo trtakitrdeu nzkapx-krde narncbr ngr nzlu-alongr kx yrlq Gct, Kxmule-esz' ka-atwrnr-ngrde trau x dztudeng amrlx. Murde rblx nzxpe-krde da kx na-arlapxle nide mz gq. ");
INSERT INTO ntu_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Leplz amrlx sa nabzng, kxmule-esz' kxnzyrplapxng o kxnzngqngung. X dztudrng amrlx sa nabzszbzlr mz kzdung kz leplz. ");
INSERT INTO ntu_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","X kxmule-esz' mzli ka nzrnginyzng drtc', A' gq lrdr dela nangipe ma nyzdr mz nzmnc-alope-krdr elr. ");
INSERT INTO ntu_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Da amrlx kcng tqmatq mz drtwrdr sa nayrkrpx-kzng. Leplz sa nabzng da kc tzwai animol amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Lrpzki r kxnzngqngung kcng tzabrtrlr drtwrdr mz nidr esz'-krdr x mz dztudrng, Yrkrtxpxpwz mz nzbzngr. ");
INSERT INTO ntu_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Apule kx nzbzngr nide kxetu rdr kc tqmailzle nidr mz gq lrdr, Mz nzapu-krdr sip. X kxnztubqng sa navzneng wq mrkc tzyrtzmqngr namz ngrdr. X mz nzmibi-krdr, nzyc-rlrubzng mz ma nyzdr. ");
INSERT INTO ntu_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","A' Gct sa naxpetrle ninge mz zmatq ngr nzbzngr, Mz nzarlapx-krde ninge mz gq. ");
INSERT INTO ntu_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Bzkq nabzmu talvzo mz nzmc-krmu bcnyrng, X nzkqlunepxkr dztudrng. ");
INSERT INTO ntu_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Murde rblx nzrtwzmingr dztung mz nzbzngr. Dztung la tqyc, a' nrkrdrtq la namibi. ");
INSERT INTO ntu_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Kxmule-esz' bcnyrng nzabrtz-zvzng mzli kc tzlube-ngrdr, X nzamatq leplz nidr murde sc tzakqlunepx-zvzlr dztudrng, ");
INSERT INTO ntu_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","A' sa navzo-kzng mz gq, da kc tzwai melrmqdrng, Mz nzmnc-alo-krdr mz nzlo. ");
INSERT INTO ntu_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Da amrlx kcng tqmatq mz drtwrdr mane x nardr tryrplatrpwzu. Leplz sa nabzng da kc tzwai animol amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","3","Nabz ne Asaf. Yawe, nide Gct kc tqxplr esz'ngr. X zluli rde pnamilxtile mzteadau Jerusalem kc tqlqngi. A' nrlc ycngrlrlzm mz nzvz-krmle, Murde nyr wounepx kai mz nzangc-krde da amrlx, X nounenq o-ngalelvzle nide. X kqlele lr Heven mz nzayrlwr-lxblr-krdr leplz amrlx mz nrlc. ");
INSERT INTO ntu_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Navzmqng mz nzmc-krdr nztubqkr natqde, Mz nzpipx-krde nzvz-rbrkr leplz nedeng. ");
INSERT INTO ntu_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","X rpibzle mz lr Heven kx, “Vzmimamu krkcng tzlxngitilr ninge, X drtwrgr badr tqesz'ti mz nzangc-krmlr bange blz krdr, murde nayrlwr-ngalelvzlr ninge.” ");
INSERT INTO ntu_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","X lr Heven nzrpilr kx, “Gct, nzaclve-krm rsakrlrngr. Murde tubqq mz nzryrlq-krm drtwr.” ");
INSERT INTO ntu_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Rpi Gct kx, “Leplz nengeng, xlrmamu natqnge. Murde ninge Gct rmu x na-aelwa-ngrbo mrkc tqvz-rbrtiamu. ");
INSERT INTO ntu_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Animol kc tqngi blz tqkamamu bange, trngiu da kx myapxbz, Mz nzangco-zvz-krmamuleng mz olta. ");
INSERT INTO ntu_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","X trngi-kzu da kx myapxbz nzangc-krmamu bange Gout x kzu kxncblongr dalr nardzng nyzmu. ");
INSERT INTO ntu_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Murde dalr peto amrlx nyzngeng, X wai-kzle kzu amrlx kcng tzmncng mz siu r newz. ");
INSERT INTO ntu_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Utc ngr peto amrlx nengeng, Nidr badr animol ngr nardzng. ");
INSERT INTO ntu_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Nzmu nabrtalex x drtwrnge brlxkz tr-rlxpwc'u bamu da. Murde nrlc nyznge x dalrdeng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","X trmuwxu ncvr kzu. X tr-rmnqwxu mepyr ngr gout. ");
INSERT INTO ntu_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","A' blz angidr nangi nzawi-krmamu bange, X nzangidati-krmu da kx esalz-ngrmamu bange. ");
INSERT INTO ntu_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","X mrlz nzkrka'-krmamu bange mzli kc tqkxpu-ngrnamu, Murde naglqlzamu ninge kalr mz nzarlapx-krnge nimu.” ");
INSERT INTO ntu_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","A' rpibz Gct mz leplz kxdrka'-ngrng kx, “Trtakitrdeu nzyapwxti-zvz-krmu Loukxtr scnge, Mz nzycmnetr-krmu Nzryrngrkxtrng. ");
INSERT INTO ntu_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Murde pxtxpx-ngrnamu nzatubqti-krnge nimu, X rtctx-ngrnamu natqnge. ");
INSERT INTO ntu_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Alwx ngrmung nidr seleng: Mrlzbz bamu nzngi-kzte-krmu ncblo kx pna da, X nzprtr-ngrbz mz leplz kcng tzrmwimi-abeaneng leplz kx trngiu krnalzdr. ");
INSERT INTO ntu_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Ycmnetrpwzmu mz da kxtrka, X naomu tresakiu nzrpi-twzti-krdr da kx nzesabrtingr. ");
INSERT INTO ntu_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Pikiti-zvzamu kztemung, X pibqti-kzamu mzlemung. ");
INSERT INTO ntu_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Mz nzale-krmu da lcng sc tqmnc-lrpinebo. X rpiamu mz drtwrmu, mrlzm bange nzale-krmuleng. A' trtingr! Murde da kcng tqvz-rbrtiamu delcng tqaplxtipx-atebo bamu. ");
INSERT INTO ntu_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","“Mzli ka natekqtramu nqmq krmu, Murde ma tqodatitxne nimu X sc trpengr kx na-arlapxle nimu. X bzkq mrbrtr mz drtwrmu nzamatq-krmu ninge. ");
INSERT INTO ntu_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Blz angidr nangi nzawi-krmamu bange. Murde narmctiamu nzarlapx-krnge nimu, mz nzvz-nqblq-krmu ninge.” ");
INSERT INTO ntu_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Nabz ne King Devet, kx yrle mz nibr nzycmne-plztitr-krbz Profet Neitzn mz nzmwimi-krde Batsibz. Gct, nayc mz drtwrm ninge, X atubqtim nzvz-rbr-krngeng, murde aodu-zvzq ninge. ");
INSERT INTO ntu_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Wztibz nabznge mz alwx rngeng amrlx Kcng tzatrkatilr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Murde opxpe mz mzke' nzvz-rbr-krngeng. X plzpxbo nzesablqti-zvz-krnge nim, ");
INSERT INTO ntu_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","X myapxbz nim kc tqxpqbrlr-ngrne Mz nzrnzlvzo-krnge Loukxtr scm. Delc, tubqq mz nzrpi-krme bange kx vz-rbrx, X mz nzyrlq-krm nzayrplapxngr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Mrlzm bange nzale-krnge alwx Murde mzli kc tqmncbe-ngrne mz nelz lxenge, alwx rnge ycpebz. ");
INSERT INTO ntu_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","A' suti drtwrm kx nabznge navz-nqblqle nzmncngr angidr. Delc, na-alvztr-ngrn ninge murde nayrplapxx. ");
INSERT INTO ntu_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Wzti-angidrbz nabznge, Murde nzprki-krnge namyaszpxle nqbya r nrc. ");
INSERT INTO ntu_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Ipq ninge murde na-abrtzx, X drtwrnge kc tqavzbzme naelalz-mop. ");
INSERT INTO ntu_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Bzkq obqtrpeq nzmyakr drtqnge mz alwx rngeng, A' ipqpxbz alwx rngeng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Gct, tekqtrpz nabznge murde natubqx, X amrnale mqngrnge murde navz-nqblqx nim. ");
INSERT INTO ntu_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Bzkq maszlrpx-ngrn ninge mz nzmnctr-krbo bam. X bzkq katxpxq nzokatrkr Mqngrm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Okatrp ninge murde na-abrtz-mou-ngrne nzarlapx-krm ninge, X drtqnge navq mz nzvz-nqblqngr natqm. ");
INSERT INTO ntu_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Zbz sa na-alvztrpo nqmq krmqng mz kxdrka'-ngrng, Murde nayzlu-mopwzlr bam. ");
INSERT INTO ntu_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Gct, bzkq ayzlu-mope' bange nzrnibq-krnge ncblo, Murde na-angrlvzx nim mz nzarlapx-krm lc ninge. ");
INSERT INTO ntu_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Kxetu, okatrp ninge Murde naglqlz-ngrne nim nivz lrm. ");
INSERT INTO ntu_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","17","Trabrtz-ngrwq nzangco-ngrm blz mz olta nyzm. A' blz kx mrlzbz bam nabz leplz kx avzo-lzbq x plzpxle alwx ngrdeng. Delc trna-angco-ngrpwc'u blz mz olta nyzm, A' avzo-lzbq-zvztxpwo bam. ");
INSERT INTO ntu_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Krka'-ngrbo bam kx naokatrpe' nigr leplz nemqng Mz nzamqngi-mou-krgr drkq ngr Jerusalem. ");
INSERT INTO ntu_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Murde nzangco-krmgr blz mz olta nyzm navzpxm mz nzka-lzbq-krbzkr bam. X krlc blz kxtubq mz nzobq-krm. ");
INSERT INTO ntu_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng, mzli kc Doek kc Edom tqvz-ngrbzle mz Sol mz nzrpi-krbzle kx, “Devet mncpe ma nyz Ahimelek.” Kxmule-esz' nim ncblo kxetu kxmatq, a' bzkq glqpx-lzbqq mz da kxtrka kcng tqaleq, Murde Gct vz zvz nzangidati-krde natqde. ");
INSERT INTO ntu_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","A' ryrlq-zvzq drtwr kx na-atrkati-ngrn leplz. X mzli kc tqycmne-ngrn, natqm apule toki kx malc, mz nzpibqti-krm nidr. ");
INSERT INTO ntu_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Nzmrlz-zlwz-krbz da kxtrka bam myaszpxle da kxmrlz. X mz drtwrm, nzpokia-krm myaszpxle nzrpi-krm da angidr. ");
INSERT INTO ntu_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Nim Mepokia, X abrtz-zvz-ngrn nzaetq-krbzme drtq leplz mz natqmqng. ");
INSERT INTO ntu_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Delc sa nakilzpx-ngrm Gct nim ma nyzm mz nzodati-alope-krde nim. X sa na-ayrkrpxbzle nzlu-krm mz nrlc ka. ");
INSERT INTO ntu_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","X kxnztubqng sa na-amrlue-ngrdr Gct nzayrplapx-krde nim. X sa nayrpalelvzlr nim mz nzrpi-krdr kx, ");
INSERT INTO ntu_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Mcamu ena ncblo kc trmnc-xgleleu Gct. A' axplr-lzbq mz nzatrkati-krde leplz x nztwz-krde trau kxkqlu mz zmatq ngrde.” ");
INSERT INTO ntu_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","A' ninge sa na-apux nc olivi kc dzbrde tqtu-amqngi mz nzmncpx-krmc Mangr-nzangiongr, Murde vz zvz nzbrtikr drtwrnge nzaodu-alokr Gct. ");
INSERT INTO ntu_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Delc Yawe, sa na-awi-zvz-ngrbo bam da kcng tqaletiqng. X sa napipxbo mz leplz nemqng nzmrlz-zlwz-krm. ");
INSERT INTO ntu_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Leplz kx nzngqngung mz drtwrdr nzrpilr kx, “Trpnzngr Gct.” Leplz lcng nzvz-rbrng x nzale-txpwzng da kxtrka zlwz. Trpnzngr leplz lcng kxtubq. ");
INSERT INTO ntu_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Gct mncom Heven, x sc tqmcomle leplz amrlx, Mz nzmc-krde neke yrplapx mz nzrtangrti-krde nide. ");
INSERT INTO ntu_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","A' nzesablqtilr Gct amrlx ngrdr x drtwrdr esz'ti mz nzale-krdr da kxtrka. Trpnzngr nidr kxesz' kxtubq. ");
INSERT INTO ntu_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Delc tqrpingr Gct kx, “Leplz lcng tztrkang tznibqtitxdr leplz nengeng Nzapulr kx nzrnibqng da kx nangqdr. X mrbrtr mz drtwrdr nzkrka'-krmlr bange. ?Myx kxmule, trnzkrlzlru da kxtubq?” ");
INSERT INTO ntu_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","A' mzli ka nzmwxlr-zlwz-krdr myaszpxpele mzli kc. Murde Gct sa napxtxpx-ngrde enqmi rgung. X drtqdr sa namya mz nzaovxio-alo-krgu nidr. X namz ngrdr sa narlxbuliane-ngrbz Gct mz nrlc. ");
INSERT INTO ntu_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Sutitx zlwz drtwrnge kx Gct rgu kc Saeon na-arlapxle leplz nedeng. Murde mzli kc nayzlu-mou-ngrmle, namnc-zpwxku badr. X nigu lr Jekop drtwrgu sa naelalzm. X nigu lr Israel sa na-abrtz-ngrgu da lc. ");
INSERT INTO ntu_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng, mzli kc lr Sifz tzvz-ngrbzlr mz Sol mz nzrpi-krbzlr kx, “?Krlzq kx Devet sc tqmnc-kapq mztea nyzgr?” Gct, arlapx ninge mz zmatq ngr drtqm, X aelwzpx-ngrbz nztubq-krnge mz nztu-krbzme mz nibrnge. ");
INSERT INTO ntu_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Xlrm natqnge Mz nzkrka'-krbo bam. ");
INSERT INTO ntu_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Kxnzaetqng drtq nzglqpx-lzbqng nzrpilr natzlr ninge, X krkcng tzxpqbrlr-ngrdr nim, nzrpilr nanibqlr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","A' nim Gct kx okatr-zvzle ninge, Mz nzngini-krm Kxetu rnge kc tqmnc-xgle-zvzx. ");
INSERT INTO ntu_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Yawe Gct, ayzlu-mopwz badr da kxtrka kcng tzwaisr-ngrdr ninge. X nibq nidr murde nim kx brti drtwr. ");
INSERT INTO ntu_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Zbz sa na-abrtzlvzx nzrka-krbo bam blz mz olta nyzm. X na-awi-ngrbo bam nzmrlz-zlwz-krm. ");
INSERT INTO ntu_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Murde arlapxq ninge mz nzkxpu-krngeng amrlx, X okatrq ninge mz nzaovxio-krnge enqmi rngeng. ");
INSERT INTO ntu_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng, mz nzayrningr gita. Gct, xlrm nzkrka'-krbo bam. X bzkq drtqm satrp nzycmne-krbo bam. ");
INSERT INTO ntu_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Lalztqm bange x ayzlum natqnge, Murde nabznge tropxpeu mz nztalvzo-krde. ");
INSERT INTO ntu_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Enqmi rngeng nzrkatrpqng bange nzkxpungr, Mz nzxngitr-krnge nzycmne-kato-krdr, Mz nzrnzlvzo-krdr ninge, X nzobq-krmlr bange mz zngya. ");
INSERT INTO ntu_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Nelznge vzdz-zlwzm, Murde ycpe pipz nzbz-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Rnrcti-lzbqpenge mz zmwxlr, X nrkrdrtqnge esz'pe-ngrde. ");
INSERT INTO ntu_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","X rpix mz drtwrnge kx, “Nzmu nabxnge naycbzle, da kc tqwai bona, Nalvcx x nartangrx me namnc-zpwx-ngrne. ");
INSERT INTO ntu_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Nalvctr-rlrux lzke, X namnc-lrpix esz'-krnge mrlcde. ");
INSERT INTO ntu_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Na-anitxpwo nzrtangrti-krnge me narlakitrx Mz tewa x nounenq.” ");
INSERT INTO ntu_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Kxetu, akipx kxdrka'-ngrng mz nzarlxlvrti-krbzme natqdr. Murde nzota-zvzng x nznani-lzbq-zvzng mz mztea. ");
INSERT INTO ntu_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Mz nrlckxngrlx x nrlckxbq Mztea esz'tx-ngrpwz nzxpqbrlrngr lou x nzkxpungr. ");
INSERT INTO ntu_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Nzodangr prtz-zvzm mrlcng kqlu mz mztea. X me nzamwangr da tresakipxpuu nzpokiangr x nzangqngutingr leplz. ");
INSERT INTO ntu_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","14","Kztenge, mzli kc ryapwx-angidrki mz nzodu-krgi, X vztr-lxblrki mz Mangr-nzangiongr Gct. A' mzli ka trngiu enqmi rnge kc tqxtrnga-ngrde ninge, A' krlc nim, kc tqmuki me esz' x line-zvzki. X trngiu kxpxtxpx-ngrde ninge kc tqyrpalelvzle ninge, A' krlc nim, mrlxkztenge. Mz nzatrkatikr enqmi rnge ninge Nabznge trtalvzou x krlzx nzmnc-kapqngr, A' nzamwa-krm lc ninge, kx mzlenge, Delc tqvztx-zlwzngr drtwrnge. ");
INSERT INTO ntu_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Gct, ayrkrpx-anibz enqmi lcng nabzdr x nzao-krdr drtwrdr tqdrka'ngr, Murde napwrkilvc-ngrdr nzbz-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Yawe, mzli kc nayrni-ngrbo bam, Krlzx kx sa na-arlapxq ninge. ");
INSERT INTO ntu_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Murde sa naxlrme natqnge mz nourla, bea, x mz nrlckxbq, Mz nzkalz-zvz-krbo bam nzlckr drtwrnge x nztalvzokr nabznge. ");
INSERT INTO ntu_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Kxmule-esz' enqmi rngeng nzkqlung, a' mzli kcpe naota-ngrgr badr, Sa na-amnc-zpwxq ninge mz mzlirdr. ");
INSERT INTO ntu_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Murde nim Gct kc nzaclve-krde tqyc tqyc. X sa na-ayzlume natqnge lcng mz nzaovxio-krm nidr mz nzotangr. Murde nzpxtxpx-ngrdr nztekqtr-krdr nqmq krdr, X trnzamrlue-kzlru nim. ");
INSERT INTO ntu_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Mrlxkztenge lc, mzli kc nigr badr dzbede kxesz', a' mzli ka yrlqpx-lzbq mz nzesz'tikr drtwrgr badr. A' se tqrtwztipele nigr zngya tqotapekr badr. ");
INSERT INTO ntu_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Nzprlxpx-krde nivz narpi-ngrbz nide ncblo ngrde, A' mz nabzde la poi kx mu ncblo. Mz nzycmne-krde nide pakrle, A' natqdeng malc apule toki r vea. ");
INSERT INTO ntu_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Yawe, napipxbzkr nzkxpu-krgrng bam, murde nalolvz-amqngiq nigr. X tr-rlrpx-ngrwq leplz kxnztubqng nzaxtx-krbzlr nzlxngiti-krdr nim. ");
INSERT INTO ntu_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Murde sa nartco-ngrn mz gq lrdr Krkcng tzrnibqng x tzpokiang, Mzli lc tznginibe-ngrdr obla. A' sa na-abrtr-zvzbo drtwrnge bam. ");
INSERT INTO ntu_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","2","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng, mzli kc tzlolvzngr lr Filistia nide mrkc mztea Gat. Yawe, nayc mz drtwrm ninge. Murde enqmi rngeng nzkqlu-zlwzng. X vz zvz nzmaneuti-krdr ninge x nzatrkati-krdr ninge, Murde nzrpilr na-aovxiolr ninge mz nzrnzlvzo-krdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","A' mzli kznike mwxlr-ngrne, Abrtrpo drtwrnge bam. ");
INSERT INTO ntu_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Trmwxlrtiwxu zmatq ngrdr murde abrtrpo drtwrnge mz natqm, Nim Gct kc tqglqlz-zvzx. ");
INSERT INTO ntu_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Yawe, enqmi rngeng vz zvz nzrtangr-krdr drtwr kx na-atrkati-ngrdr ninge, Mz nzrkatr-zvz-krmlr nzkxpungr bange. ");
INSERT INTO ntu_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","X nzyrlwr-lxblrng me nzmnc-kapq-ngrdr, Mz nzaukzti-krdr ninge, murde nanibqlr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Bzkq rlr-ngrbzme nzdwa-krdr, A' ayrplapxng mz zngya ngr drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Krlz-angidrq nzrkrkxkr drtqnge. Murde aplxtipxpeq nztaliokr drlemzke' amrlx, mz nzyrtio-krmlr mz buk scm. ");
INSERT INTO ntu_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","X krlz-zpwxx kx mz nzkqle-krnge nim, sa navzme x enqmi rngeng nadwaszlr ninge. Murde tu-zvzme mz nibrnge. ");
INSERT INTO ntu_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","11","Trmwxlrtiwxu zmatq ngrdr murde abrtrpo drtwrnge mz natqm, Yawe, nim Gct kc tqglqlz-zvzx, x brti drtwrnge natqm amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","X sa na-alebo bam da kcng tqpibo, Mz nzrka-krbo blz ngr nzawingr. ");
INSERT INTO ntu_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Awi mz nzarlapx-krme ninge mz mq enqmi rngeng. Murde trpnzngr nznibq-krdr ninge, X trmetxpou badr. Gct nawztr-zvzbo bam, nzmnc-krnge mz nrlc. ");
INSERT INTO ntu_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng, mzli kc tqrlatr-ngrde mz butqbr mz nzdwasz-krde King Sol. Gct, nayc mz drtwrm ninge mz nzaelwa-krme bange nzmrlz-esz'ngr-krm, Murde mnc-xglex nim mz nzmnc-zpwx-krnge mz mzlir nzkxpungr kxtrka. X na-apux nei bona kc tqmnclzbz mz nabx lxede, Mz nztu-krme mz nibrnge, navz navz mzli kx ayrkrpx-ngrn nzodangr. ");
INSERT INTO ntu_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Gct, myalz-esz'ngrn, x sa nakqlex nim, Murde angidati-zvzq me pnz drtwrm mz nzmnc-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Sa na-ayzlume natqnge Heven mz nzarlapx-krm ninge. X na-amyatibzme drtq krkcng tzrnzlvzolr ninge. Murde aodu-zvzq ninge, X angidati-zvzq natqm. ");
INSERT INTO ntu_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Nztu-ngalelvzlr ninge ncblo ngr nzodangr. Spiz x nipna scdr nzapulr nqngi kx malc, X natqdr nzaetq-krdr drtq apule nzrluplxtikr toki r vea. ");
INSERT INTO ntu_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Lr Heven namclr nzmyalz-esz'ngr-krm. X lr nrlc namclr nzaovxio-krm. ");
INSERT INTO ntu_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Kxmule-esz' nabznge talvzo zlwz murde enqmi rngeng nzrtxtiolr ninge br, A' awi Gct, kx naprtz-moung mz trtxki kx nzamwiti-ngrdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","8","Sa na-angrlvzx nim mz nabznge atwrnrngr mz nzayrni-krbo gita bam. Murde abrtr-zvzbo drtwrnge bam. Nilz r nepi adwalzmle ninge mz zbq kang kqlu. A' mz nzdwalz-krmc mz nourla kx topwz, Na-apule nabz nenge adwalzmle nepi, Mzli lc naglqlzpex nim. ");
INSERT INTO ntu_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Kxetu, sa na-awibo bam mz mzlir lr mrkzbleng, X na-angrlvzx nim mz mzlir neidung. ");
INSERT INTO ntu_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Murde nzaodu-zvz-krm myalz krlzlzle bongavz, X nzangidati-zvz-krm natqm. ");
INSERT INTO ntu_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Lr Heven namclr nzmyalz-esz'ngr-krm, X lr nrlc namclr nzaovxio-krm. ");
INSERT INTO ntu_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. ?Kxnzetung, myx kxmule, nzaclve-krmu tubq, X rsakrlrngr angidr? ");
INSERT INTO ntu_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Trtingr! Murde yrlqamu drtwr kx atrkatile leplz nemung, Mz nzaetq-krbzmu drtqdr mz nrlc ka. ");
INSERT INTO ntu_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Nimu kxdrka'-ngrng. X ale-zvzamu da kxtrka, Yzuo pnz mzli kc tzmcngr mzpu. ");
INSERT INTO ntu_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Apuamu ningidoe kcng tzrmakxng Mz nzatrkati-krmu leplz. ");
INSERT INTO ntu_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","X apu-kzamu kxnradrtqdr ngq murde pxtxpx-zvz-ngrnamu nzxlr-krmu nzyrni-krdr, X nzayzlu-krbzmu natqdr. ");
INSERT INTO ntu_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Yawe, ayrplapx leplz lcng tzapulr ningidoe, mz nzyrvilz-krme nipna scdr. X mz nzapu-krdr poi kz peto, taglctr-kzpz nqngidr. ");
INSERT INTO ntu_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Mrlzvxitx nzbatr-krbzme nzmyakr nipna scdr, X nzmrbr-krdr na-apule lue kc tqmrbrlqo mz drtc'. ");
INSERT INTO ntu_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","X mrlzvxi kz nzapu-krdr zwqwq r wagq kc tqlrprnebz mq mz nzngrla-krde x mz nibrde sc tqmrbrpe mou mz nztiokr nepi le. X na-apu-kzlr itoto kx bz murde nzmika mzli kc tqpoobe-ngrde. ");
INSERT INTO ntu_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Gct, mzli kc tzlube-ngrdr, apusrngr nidr nabr kc tzikzti, Mz nzodati-krm nidr mz zngya ngr drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Zbz nigr kxnztubq nemqng sa na-abrtz-zlwz-ngrgr nznibqti-krm kxdrka'ngr lcng. X sa naelalvzkr nzyrlekr mepyr ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","X sa napibzkr bam kx, “Gct, da zpwxtx! Sa nakabzme da kxmrlzting mz leplz kxnztubqng, Murde nzaclve-krm lr nrlc tubq-esz'ngr.” ");
INSERT INTO ntu_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng, mzli kc King Sol tqatwzlr-ngrde ncblo mz nzaukzti-krdr ma nyz Devet, murde nanibqlr nide. Gct rnge, arlapxbz ninge mz enqmi rngeng, X tum mz nibrnge mzli kc naoti-ngrmlr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Arlapx ninge mz kxdrka'ngr lcng, Tzkrlzlr nzrnibqngr leplz. ");
INSERT INTO ntu_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Yawe, obqm! Ncblo lcng tzyrlwr-lxblrng nanibqlr ninge. A' trpnzngr da kxtrka kx alebo badr. ");
INSERT INTO ntu_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Kxmule-esz', a' se tzoliqtilr nztz-krdr ninge. Tulzm x vzm mz nzokatr-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Yawe, nim Gct kc tqrninr, Gct r lr Israel. Dwalzm mz nzayrplapx-krm lr mrkzbleng. X bzkq ycngr drtwrm krkcng tzryrlqng drtwr kxtrka. ");
INSERT INTO ntu_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Nzyzluti-zvzmlr mztea mzli kc milzpq, Nzapulr kuli kzpeto kcng tzkclwzng mz nzvzne-krdr mztea. ");
INSERT INTO ntu_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Drtwrdr nzamqmqlr x natqdr nzapulr toki r vea kxmalc. Mz drtwrdr nzrpilr trpnzngr kx rkrlztrpz x trpnzngr nzayrplapxngr nidr. ");
INSERT INTO ntu_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","A' nim Yawe, yrpalelvzq kxnzmnc-mrbr lcng, X xtrnga-ngrn nidr. ");
INSERT INTO ntu_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Gct rnge, abrtr-zvzbo drtwrnge mz nzxplr-krm, Murde nim lrpalvc nyznge. ");
INSERT INTO ntu_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","X krlzx kx sa na-aovxiox enqmi rngeng, Murde naokatrq ninge mz nzaodu-zvz-krm. ");
INSERT INTO ntu_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Yawe, nim temz ngr lomrgr kc tqyrputrngr nipna. Nibqti nidr, murde leplz nengeng nadcpx mz drtwrdr Kx nim Gct kc tqayrplapxle kxnzaleng alwx. Aodaliti nidr mz zmatq ngrm, murde nataong mz drtc'. ");
INSERT INTO ntu_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Batrpz mz nzglqpx-lzbq-krdr nzatao-mou-krde nidr. Murde mz nzycmne-krdr natqdrng ngi dalr alwx, mz nzrpibqtingr x nzpokiangr. ");
INSERT INTO ntu_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Odati nidr mz nzmilxtxo-krm nidr mz zngya ngr drtwrm. Murde leplz nakrlzlr kx nim Gct kc tqaclvele lr Israel x lr nrlc tulvzo. ");
INSERT INTO ntu_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Nzyzluti-zvzmlr mztea mzli kc milzpq, Nzapulr kuli kzpeto kcng tzkclwzng mz nzvzne-krdr mztea. ");
INSERT INTO ntu_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Nzrtangrng nadr dakxnzng me yctxpqng, X drtwrdr nzamqmqlr mz trnzkrlc-kru nelzdr. ");
INSERT INTO ntu_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","A' sa nangr-kato-zvzx mz nourla kang kqlu, Mz nzpipx-krnge zmatq ngrm x nzaodu-zvz-krm. Murde apu-zvzme bange lrpalvc nyznge Kxrlakitrx mz mzli r nzkxpungr. ");
INSERT INTO ntu_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Sa na-angrlvz-zvzx nim, Gct kc tqaodu-zvzle ninge. Murde nim lrpalvc nyznge kx xplr-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","3","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng, mzli kc ami nzling nzrpilr narnzlvzo-ngrdr Israel nzprtrpqng mz kzdq nrlar Israel. X ami ngr lr Edom nzprtrpqng mz kzdq nrlarde, Nabzlwa ngr Dcpwe, mrkc Joab kc tqmailzle ami ngr Israel, tzabz-ngrdr ncblo siu-nzpnu-esz'-nrade-li (12,000). Gct, mz nzngyatikr drtwrm nigr, drtqm satrpem bagr. X batrpeme mz enqmi rgrng nzprtr-krmlr mz nzawxo-krdr bz ngr nrlc nyzgr. Nzatrkati-krdr nigr apule nengq mz nzaglqwiti-krde drtc'. X da amrlx trnzaxvctrpeung. Dea-ngrgr vznepe mz nzvzne-krgr apukr ncblo kxnzrmnqng, Mz nzaetqtitx-zlwz-krbzme drtqgr, nigr leplz nemqng. A' suti drtwrgr nayzlu-mopwe' bagr Mz nzamrlz-mou-krm drtc' nyzgr, murde namnc-zpwx-moukr. ");
INSERT INTO ntu_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Nim Ngrlrvea ngrgr. Glalzm nc nqngq bagr, nigr kcng tzamrluelr nim, Murde navzmgr bam mz nztu-mou-krgr me esz'. ");
INSERT INTO ntu_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Mz zmatq ngrm, arlapx nigr kcng tqaodu-zvzq, X ayzlu-ngrm natqgr. ");
INSERT INTO ntu_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Gct, natqmqng nzvzpxmqng mz Mangr-nzangiongr, mz nzrpi-krdr kx, “Mzli kc na-aovxio-ngrne, sa na-akipxbo mz leplz nengeng Drtc' kcng mz nrlar LueJodzn rlilr. ");
INSERT INTO ntu_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Murde neidu lr Gilead nengeng. X nqvi lr Manase nenge-kzng. X neidu lr Efrem tum mz nibrnge. X nqvi lr Judz kx na-aclve-zvzng mz zmatq rnge. ");
INSERT INTO ntu_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","A' enqmi rmung trna-aovxiolru nimu. Murde lr Moab sa nawztrpqng bange X lr Edom sa nametxmqng bange. X sa namalqlvzx nzmilxtxo-krnge lr Filistia.” ");
INSERT INTO ntu_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","?Myx kxmule, sa na-atutrq natqm lc mz nzokatr-krm ninge Nzprtr-krnge mz lrpalvc ngr mzteadau nyzdr lr Edom? ");
INSERT INTO ntu_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Murde mzli kc pxtxpxpe-ngrn nigr, X trokatrwq ami negr mz nzotangr. ");
INSERT INTO ntu_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Gct, okatrp nigr mz nzota-krgr badr enqmi rgrng mzli ka. Murde mane nzmnc-xgle-krgr ncblo nzarlapx-krdr nigr. ");
INSERT INTO ntu_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","X krlzkr kx mz nzmnc-krme bagr, Sa narnzlvzokr enqmi rgrng mz nzokatr-krm. ");
INSERT INTO ntu_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Gct, xlrm nzyrni-krnge, X lalztqm mz nzkrka'-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Kqlex nim murde mncx esz'-krnge, x nabznge talvzo zlwz. Vzmibz ninge mz butqbr kxmqngi. ");
INSERT INTO ntu_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Murde nim lrpalvc nyznge, Me rlakitrx mz mq enqmi rngeng. ");
INSERT INTO ntu_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Rlr-ngrm bange nzmncpx-alo-krmc mz ma nyzm. Murde na-apux nei kio kx mnc-kapqlzbz mz nabx lxede. ");
INSERT INTO ntu_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Gct, abrtzlvzq nzesalz-krnge nzangrlvz-zvz-krnge nim. Murde krlc takitrde leplz kcng tzamrluelr nim. ");
INSERT INTO ntu_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Kam bange nzlungr kxboi, ninge king nem, Murde nzmnc-krnge navz zvz. ");
INSERT INTO ntu_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Okatrp ninge mz nzaclve-angidr-krnge leplz nengeng mz nzmnclz-krbo mz zmatq ngrm. Ayrbqpx ninge mz nzaodu-zvz-krm ninge x nzangidati-krm natqm. ");
INSERT INTO ntu_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Delc na-angrlvz-zvzx nim, Mz nzale-krnge da kc tqesalz-ngrbo bam. ");
INSERT INTO ntu_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Gct txpwz kx mnc-xgle-zvzx mz nabznge, Murde nzmnc-zpwx-krnge vzpxm bade. ");
INSERT INTO ntu_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Nide butqbr nyznge x mevalu rnge. Nide lrpalvc nyznge kx tu-amqngio-ngrne. ");
INSERT INTO ntu_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Delc nimu kxdrka'-ngrng bzkq tz-zvzpeamu ninge mzli ka trxplrpewxu. X bzkq apusr-ngrnamu ninge nzawxo-krmu ma kx blzlongr. ");
INSERT INTO ntu_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Ryrlqamu drtwr ngr nzapotxo-krmamu ninge me matq kc tqmnco-ngrmc. X abrtzlvzamu nzpokiatitr-krmu ninge. Murde nivz lr naomu prlxmamu bange, A' mz nabzmu la, ngyati drtwrmu ninge. ");
INSERT INTO ntu_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Gct txpwz kx mnc-xgle-zvzx mz nabznge, Murde nzmnc-zpwx-krnge vzpxm bade. ");
INSERT INTO ntu_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Nide butqbr nyznge kx abrkitrx drtwrnge. Nide lrpalvc nyznge kx tu-amqngio-zvz-ngrne. ");
INSERT INTO ntu_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Nzarlapx-krnge x nzmrlue-krnge yctr txpwz bade, Mz nzngini-krde butqbr nyznge kxmqngi kx rlakitrx. ");
INSERT INTO ntu_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Leplz nengeng, mz nzangidati-krbzle da kx yc mz drtwrmu, na-abrtxtrpwzmu drtwrmu bade. Murde nide txpwz me rlakitrku. ");
INSERT INTO ntu_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","A' bzkq brti drtwrmu leplz, murde nigu amrlx apu-txpwzku zsikapu, Kxmule-esz' nigu kxnzetung o leplz txneng. Murde nzmu na-arsakrlrku nzmrlekr Gct x nigu, Nide kx mrle txpwz, a' nginigu da-nrbalq. ");
INSERT INTO ntu_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","X mz nzrtwz-krmu da kx suti drtwrmu, bzkq brti drtwrmu nzamwxlr-krmu leplz x nzpna-krmu dztudrng. X kxmule-esz' nimu bcnyrng, bzkq abrtrpzmu drtwrmu mz trau scmu. ");
INSERT INTO ntu_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","A' na-amqtrku drtwrgu mz nzxlr-krgu natq lcng. Murde Gct txpwz kc tqmatq. ");
INSERT INTO ntu_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","X da kx myapxbz, nzaodu-krde nigu tresakiu. Rpimle kx, “Mzli lcde, nzayzlu-krbo da mz doa navz-nqblqle da kx aleleng mz nrlc ka.” ");
INSERT INTO ntu_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Nabz ne Devet mzli kc tqmnc-ngrde lzke ngr Judz. Gct rnge, rtangrtix nim. Murde nim kc tqbatrple nzesatxpx-zpwxkr drtwrnge. Apux ncblo kx drtwrde brlxkz x mzte tclvr mrkc lzke, Mz nzsutitx-zlwzkr drtwrnge nzmnctr-krbo bam. ");
INSERT INTO ntu_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Suti drtwrnge nzxngi-krbo nzulrm Mangr-nzangiongr Mz nzmc-krnge zmatq x zluli rm. ");
INSERT INTO ntu_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Nzkrlz-krnge nivz lrm myaszpx-zlwzle nzlu-krnge mz nrlc. X glqlz-zvzx nim mz nzaodu-zvz-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","X sa na-awi-zvzbo bam Mz nzglalz-krbo mqnge mz nzkrka'-krbo bam. ");
INSERT INTO ntu_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Drtwrnge sa naesatxpx zpwx nzmnctr-krbo bam. X sa na-angrlvzx nim mz nabz kxyrlvi. ");
INSERT INTO ntu_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Mz nrlckxbq kang kqlu aoti zvz drtwrnge nim, Vz vz nrlc ngrlxtxpx. ");
INSERT INTO ntu_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","X angrlvzx nim mz nzabrtzngr Murde okatr-zvzq ninge x tu-zvzme mz nibrnge. ");
INSERT INTO ntu_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Mnc-amqngitrpo bam, X lolvz-amqngiq ninge mz mqm kx xplr. ");
INSERT INTO ntu_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","A' ayrkrtxong mz drtc' Krkcng tzrpilr nanibqlr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Nibqting nidr mz vea, Murde kuli kzpeto nangqtilr namz ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","X ninge, king nem, sa na-abrtzlvzx nim, Murde ngi-batrpe' nzaovxio-krnge. X krkcng tzabrtrpzlr drtwrdr bam, sa nabilvzlr nim. Murde sa nangi-batrpzme mz kxnzpokiang nzmnc-lrpi-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Gct, kxputxpex. Xlrm nzkrka'-krnge. Mwxlrti-zlwzx enqmi rngeng. Arlapx ninge. ");
INSERT INTO ntu_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Tum mz nibrnge murde kxdrka'-ngrng nzyrlqng drtwr Mz nzesabrti-krdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Nzxngitrkr leplz nzycmne-krdr apule nzrlakikr toki r vea kx malc. X nzpnz-krdr leplz mz natq kxtrka apule nipna. ");
INSERT INTO ntu_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Nzmnc-kapqng mz nzpnz-krdr kxnztubqng mz natq ngr nzpokiangr. X trnzmwxlrung nzaniti-krdr nzatrkati-krdr nidr. ");
INSERT INTO ntu_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","6","Nzapqtrlr drtwrdr mz drtwr kxtrka kx nzyrlqlr. X nzamyatxlzpwzlr nzrkrlzkr leplz, Mz nzrpi-lxblr-krdr kx, “Na-amwiku trtxki mz nzesabrti-krgu leplz. X nzbrngztio-krgu lc da kxvz-rbr trpnzngr kx narmc x kx narkrlzti.” ");
INSERT INTO ntu_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","A' Gct sa na-ayrplapx-anile nidr, na-apule kx pnzle nidr mz nipna scde. X napwrkilvc-ngrdr nztupekr nipna ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Sa na-atrkatile nidr murde nzrpiting natq kxtrka. X sa nayrpalelvzng krkcng tzrmcng nidr. ");
INSERT INTO ntu_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","X leplz amrlx sa namwxlrtilr Gct. X sa na-aoti drtwrdr da kxmatq kc tqaleleng x nayapwxtipxlr. ");
INSERT INTO ntu_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Leplz kxnztubqng sa na-abrtzlvzlr Yawe x sa na-abrtrpzlr drtwrdr bade. Leplz kx nabzdr lq sa na-awibzng bade. ");
INSERT INTO ntu_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Gct, nzglqlz-krgr nim Jerusalem tubq-esz'ngr, X rpikr na-atutr-zpwxkr nzesalz-krbzkrng bam. ");
INSERT INTO ntu_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Murde xlrme nzkrka'-krgr, Mz nzmnc-xgle-krgr nim. ");
INSERT INTO ntu_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","X kxmule-esz' nzvz-rbr-krgrng nzmrilvzlr nigr, A' ipqpx zvz alwx rgrng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Namrlz-ngrmle bagr, nigr kcng tqmcpxqng X tqvzmitrqng Mangr-nzangiongr nim. Murde sa namnc-zpwxkr Mz nzrtwzngr da kxmrlzting mz ma nyzm. ");
INSERT INTO ntu_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Mevalu rgr, mzli kc tqyrni-ngrbzkr bam, ayzlume natqgr Mz nzbatr-krme nzaovxio-krgr. Lr mrkzbleng nzmncng drtc' x trmctu mz nrlc tulvzo. X sc tzabrtr-kzpzlr drtwrdr bam. ");
INSERT INTO ntu_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Murde mz nzxplr-krm atulzq newz kxetuting, Mz nzaelwapx-krm nzmyalzkr zmatq ngrm. ");
INSERT INTO ntu_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Aoq nrwx mz nzyclwzkr srkau x aesakiq nzyrpukr natq nrc. X amnc-nabuq leplz kcng tzxpqbrlr-ngrdr nim. ");
INSERT INTO ntu_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Nzamrluengr nim mz nzetukr zmatq ngrm. X mz nrlc tulvzo nzmalqlvzlr da kcng tqaleqng. ");
INSERT INTO ntu_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Gct, aclve-angidrq nrlc mz nzadc-krm tewa, Murde dakxnzng nalvc angidr mz drtc'. ");
INSERT INTO ntu_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Tewa lc tqayayrtile drtc' nyzgr, Murde da kx petikr mz nrlanc nyzgr nalvcpulzmqng. ");
INSERT INTO ntu_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Ycngr dakxnzng kxkqlu mrkcng amrlx tqvzkiq. X bxli scgrng yrbuti zvz mz da kxmrlzting. ");
INSERT INTO ntu_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","X abrtz-zlwz-ngrgr Nzmc-krgr nzplckr nra nounc nyzgrng. ");
INSERT INTO ntu_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Angrlvzkr nzyrlvzbqtikr animol negrng, X malqkr murde nrlanc nyzgrng brtipeng x ycpe pipz nzrkqlzngr. ");
INSERT INTO ntu_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Nabz kx nzyrbz mz kxrmailz ngr dzbe kxnzngrng. Lr nrlc amrlx Namalqlvzlr Gct, ");
INSERT INTO ntu_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Mz nzangrlvz-krdr nzmyalzkr drtqde, X mz nzglqlz-krdr nide mz nabz kxyrlvi. ");
INSERT INTO ntu_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","X narpibzku bade kx, “Da amrlx kcng tqaleqng nzkctitxpxng. X enqmi rmqng nzmetxpebzng bam mz nzetu-zlwzkr zmatq ngrm. ");
INSERT INTO ntu_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","X lr nrlc amrlx nzangiolr nim, Mz nzglqlz-krdr nim x nzarmyalz-krdr drtqm.” ");
INSERT INTO ntu_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Nadcpx mz drtwrgu da kx nzkctipxng, Kcng tqalemqng Gct bagu, nigu leplz nedeng. ");
INSERT INTO ntu_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Akipxle Prla Bla x aesakile nzyrlekr LueJodzn Mz nzyrlq-krbzle me mingrng kx navzki melrmqgung. X mzli ka na-awi-ngr-kzpzku bade da lcng. ");
INSERT INTO ntu_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Murde aclve-alole mz zmatq ngrde. X yrlq zvz mzte lr mrkzbleng murde ma tzglqpx-lzbqng mz nzxpqbrlr-krdr nide. ");
INSERT INTO ntu_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","A' nimu lr mrkzbleng naglqlz-kzamu Gct rgr, Mz nzangrlvz-kato-krmu nide. ");
INSERT INTO ntu_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Murde nide kc tqaclve-zvzbzle nzlu-krgr, X tr-rlrpx-ngrdeu nzaovxiokr enqmi nigr. ");
INSERT INTO ntu_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Gct, kxmule-esz' atubqtipeq nigr, kx nabzgr nalqngi, Mz nzapu-krgr silvz kc tqyrleni, x zblqki rde navztx. ");
INSERT INTO ntu_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","X kxmule-esz' rlrpx-ngrn nzesabrtingr nigr, X batrpzme nzrglq-krgr da kx mrlepu. ");
INSERT INTO ntu_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","X kxmule-esz' rlr-ngrbzme mz enqmi rgrng nzrnzbrti-krdr nigr, X vztrkr mz nabz nzkxpungr Kx apule nyr x nrc kxoda, A' mzli ka sc tqyzlumipe-mope' nigr me na-arlapx-ngrgr. ");
INSERT INTO ntu_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","15","X ayzlu-kzpe' natqnge mz mzlir nzkxpu-krngeng, X delc naka-ngrbo bam da kcng tqpibo. Rtwzmc animol kxncblongr kx oliqtix mz olta nyzm, Mz nzangc-krbzlr bam mz Mangr-nzangiongr. Murde zsikapu ngrdr navzdzbz, Nangi dalr nzawi-krbo bam. ");
INSERT INTO ntu_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Nimu amrlx kcng tzangiolr Gct, lalztqmamu bange, Mz nzpi-krbo bamu da kcng tqalemleng bange. ");
INSERT INTO ntu_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Mz nzbrtikr drtwrnge nide, krka'bo bade, Mz nzoliqti-krnge nzawi-krbo bade mz nzayzlu-krmle natqnge. ");
INSERT INTO ntu_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","19","X ayzlu-zpwxmle natqnge murde plztipxbo alwx rngeng. A' rblx nzxlr-krde nzkrka'kr doa kx nabzde blqki. ");
INSERT INTO ntu_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Awitx-zlwzbo mz Gct murde trpx-ngrdeu nzkrka'-krnge, X trpx-kz-ngrdeu nzaodu-krde ninge. ");
INSERT INTO ntu_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Gct, nayc mz drtwrm nigr, Mz nzamrlz-krm x nzokatr-krm nigr. ");
INSERT INTO ntu_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Murde lr nrlc nakrlz-zpwxlr nqmq krm Mz nzarlapx-krm nigr. ");
INSERT INTO ntu_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Mrlz neidung amrlx nzglqpx-krdr nim, X na-awi-ngrbzlr bam! ");
INSERT INTO ntu_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Mrlz lr mrkzbleng amrlx nzangrlvz-krdr nim, Murde nzaclve-krm nidr tubq mz nzmailz-krm. ");
INSERT INTO ntu_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Mrlz neidung amrlx nzglqpx-krdr nim, X na-awi-ngrbzlr bam! ");
INSERT INTO ntu_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Gct rgu amrlzle nigu, Mz nzrkqlzngr dakxnzng. ");
INSERT INTO ntu_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","X sa na-amrlz-zvzle nigu, Murde leplz amrlx na-amrluelr nide. ");
INSERT INTO ntu_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Mz nzvz-krm Gct, enqmi rdeng nzodalitipeng. X kxnzpxtxpx-ngrdr nide nzdwaszlr nide. ");
INSERT INTO ntu_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Milxtxole nidr mz nzapu-krdr zsikapu kc tqwqplx nenq. X nibqtile kxdrka'-ngrng mz nzapu-krdr kadol kc tqyrle mz nzngc-krde. ");
INSERT INTO ntu_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","A' nigu kxnztubqng abrtzlvzku nzmnc-aepztr-krbzku bade, Mz nzbilvz-krgu x nzmalqlvz-krgu nide mz nzelangr. ");
INSERT INTO ntu_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Naglqlzku Gct mz nzangrlvz-krgu drtqde. Na-amyalzku nide kc tqvoom mz dcbz. Drtqde Yawe x na-abrtz-ngrgu nzmnctr-krbzku mz mzte. ");
INSERT INTO ntu_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Gct mnc Mangr-nzangiongr. Apubzle trte mz doa kxnzbzszng x aclve-kzle olvz kx nzbzszng ncblo ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Kxnzmncng esz'-krdr amnctr-lxblr-kzleng mz neidung, X kx drtqdr tropxu vzmi-kzleng Murde namnc-zpwxng. A' krkcng tzesablqtilr nide, avzpx-nrbalqleng. ");
INSERT INTO ntu_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Mz nzrlaszkr leplz ne Gct Ijipt, vzmitrleng lzke. X mz nzmailz-krde nidr, mncpxm mz nyr x dcbz. ");
INSERT INTO ntu_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","Nide Gct r lr Israel kc tqaelwapxle zmatq ngrde mz Newz Saenae. Murde mz nzvz-krmle, nengq x tewa kxnzetung nzvz-kzpqng. ");
INSERT INTO ntu_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Gct avzo-ngrmle tewa, Murde na-alu-moule drtc' nyzde kc tqmingrpe. ");
INSERT INTO ntu_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Neidu lrde kxtrnzrngiscung amncleng mz drtc' lc, Mz nzrka-krbzle badr da kx nzmnctxpx-ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Kxetu rgu Gct kapxle natq Kx olvz kxnzkqlung napipxlr nrpa lcde seng, ");
INSERT INTO ntu_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","“King x ami nedrng nzdwang. X nigr olvz akitikr dztu enqmi kcng tztwz ncblo ngr vea negrng. ");
INSERT INTO ntu_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Akitikr da kxlqngi kxlqlwx kx nzwzngr mz silvz x gol. ?Myx kxmule, kzdung nimu ncblo trnzprtr-ngrdru mz vea? ");
INSERT INTO ntu_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Murde Gct kc tqrninr milxtxole king kcng, X namz ngrdr nztwzbene-krdr apule lrdz kx lvxlz nrc mepz.” ");
INSERT INTO ntu_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Mzli kc King Devet tqyrlq-ngrde Mzteadau nyzde mz Newz Saeon, Newz Basan apule ncblo kx angya drtwrde nzyckr Mzteadau mrlc. A' Devet ayzlubzle natqde mz nzrpi-krbzle kx, “Newz Basan, kxmule-esz' matq-esz'ngrn x myatxlzq, X nra nyzmqng ngi rtrngr, ");
INSERT INTO ntu_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","A' bzkq obqszoq newz kc tqmcpx Yawe kx namnc-ngrde, Murde sa namnc alo elr.” ");
INSERT INTO ntu_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Gct vom mz siu ngr sariot scdeng, Mz nzprpx-krmle mz Newz Saenae x nzprtr-krde Mangr-nzangiongr. ");
INSERT INTO ntu_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Kxetu vzdz-ngrde wq, X aovxiole enqmi kxkqlu. X nzkabzlr da bade, mz nzmetx-krbzlr bade, Kxmule-esz' kxnzxpqbrlr-ngrdr nide mzli kc. ");
INSERT INTO ntu_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Naglqlzku Kxetu kc tqatu-amqngile nigu mz zbq kang kqlu. Murde nide Mevalu rgu. ");
INSERT INTO ntu_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Gct rgu nide Gct kc tqarlapxle leplz. Yawe nide Kxetu kc tqkapxmle nigu mz mq enqmi rgung. ");
INSERT INTO ntu_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","X sc tqtaputibzle nardr, Murde nzvz-rbr-zvzng. ");
INSERT INTO ntu_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Rpimle bagu kx, “Kxmule-esz' enqmi rmung nzdwalzng mz newz O drlve keng mz nzakitikr nrlc nidr, a' sa nayzlutibong. ");
INSERT INTO ntu_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","Murde navznenamu mz nzrnzlvzo-krmu mepyr ngrdrng, X kuli nemqng drtwrdr naesatxpx zpwx mz nzrmnq-krdrle.” ");
INSERT INTO ntu_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Leplz amrlx nzmclr nzvztr-krmqng leplz neng Gct Mrkc Tqtr, Mz nzangrlvz-krdr Gct x King rdr. ");
INSERT INTO ntu_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Dzbe kxnzngrng nzrtwayzbzng, vz-nqblqbz olvi kx nzelang x nzayrlewzng nrasrpwale. X kxnzayrning gita nzrmnr-ngrmqng. ");
INSERT INTO ntu_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Kxmu nzngr-krdr nide sele, “Naglqlzku Yawe, nigu leplz nedeng, mz nzyrlwr-lxblr-krgu. Naglqlzku Yawe, nigu kcng tqngi nqvi lr Jekop.” ");
INSERT INTO ntu_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Neidu lcng tzvz-kzpqng, Benjamin, Judz, Sebyulon, x Naftzli. Neidu ne Benjamin krkc tqtopwz rtwayzbz badr, X mz nibrdr kxnzetung r Judz x leplz nedrng. X rmnr-ngrbz neidu kx nzmncomqng mz nort, kxnzetu r Sebyulon x Naftzli. ");
INSERT INTO ntu_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Gct, aelwapx-moungr zmatq ngrm, Kc tqaelwapx-ngrn tqokatr-ngrn nigr mzli kc. ");
INSERT INTO ntu_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Kapxbz natq kx king kcng tqaovxiopeq nartwzmqng da bam, Mz nzmnc-krm Mangr-nzangiongr. ");
INSERT INTO ntu_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Ayrplapx Ijipt kc tqapule trmwzlogo kc tqmnc-kapqpxm mz nabr kc tqlvcpulzm mz nqlvi lr Lue Nael, Ayrplapx nidr badr kztedeng murde mrlz-zvzbz badr nzotangr. Aodali lr mrkzble lcng, Navz navz nakrlzbzle mzli kc tzyrngzo-ngrbzlr bam. ");
INSERT INTO ntu_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Murde kxnzetung ngr Ijipt navzmqng bam, Nidr badr lr narnrlc amrlx kcng tzaxvctrng badr, X naxpeng trau, silvz, x da kxlqlwx Mz nzaovxio-krm nidr mz vea. ");
INSERT INTO ntu_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Nimu lr nrlc amrlx, Nangrlvzamu Kxetu Gct. ");
INSERT INTO ntu_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Murde sc tqvzne mz bongavz, kc tqwz-ngrde mzli kc bqnc. X nzxplrkr natqde apule natq bzlrmei. ");
INSERT INTO ntu_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Napipxku zmatq ngr Gct, kc tqaelwapx-ngrde mz dcbz, X mz nzaclve-krde nigu lr Israel. ");
INSERT INTO ntu_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Kctitxpx-zlwzku Gct rgu Mrkc Tqtr. X nide kc tqrkam bagu nzxplrngr x zmatq. Takitrde nzrglqlz-zvzngr nide. ");
INSERT INTO ntu_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Gct, pi-zvzbo bam kx, “Arlapx ninge!” Murde nzkxpu-krngeng nzaetunepxpeng. X apupex rplz kc namrbropebz mz nrlr. ");
INSERT INTO ntu_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","X apu-kzx kx twznede ninge drlr ngr nrc. X mz nzboo-krnge, nabzpex, murde trpnzngr me nakcblztr-ngrne. ");
INSERT INTO ntu_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Gct, drtqnge satxpe x drtwrnge kaatxpe mz nzkqle-zvz-krnge nim. Mzke' ngqbqtxtrpebz mz nzaenzli-zvz-krnge nzvz-krme. ");
INSERT INTO ntu_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Enqmi rngeng nzrpilr nanibqlr ninge murde nzxplr-zlwzng. X nzpxtxpx-krdr lc ninge trpnzngr noude. X nzkqlu-krdr nzmyaszpxlr nqnginarnge. Nzpokiatitrlr ninge mz nzrpi-krdr kx nakabo trau rde. ?A' myx kxnamu nzka-krbo trau r da kx tralewxu?! ");
INSERT INTO ntu_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","A' Gct, nim txpwz kx rkrlz alwx rngeng, Murde trnzyc-kapqpwzung bam. ");
INSERT INTO ntu_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","7","Yawe, nim Ngrlrvea r ami nem, X nim Gct r lr Israel. Nzatrkatilr ninge murde lxngitix nim, X nzamyati-zvz-ngrm drtqnge. A' bzkq rlr-ngrme bange nzamyati-krbo drtq leplz nemqng, Kcng tzlxngitilr x tzangiolr nim. ");
INSERT INTO ntu_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Murde apubo lr mrkzble mz lr mrnyznge, X mzlengeng nzmapulrtr-ngrdr ninge peto. ");
INSERT INTO ntu_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","10","Kxmule-esz' nzxtrnga-ngrdr ninge Nzaxtx-krnge dakxnzng mz nzavzo-lzbq-krnge, A' mz nzpq-zlwzkr nzaotikr drtwrnge Mangr-nzangiongr nim, Apusr-ngrde ninge da kx nzangc mz nyr x yrkrtxo. X natq kcng tzpikiti-ngrdr nim, Yrplatr-kzpqng bange. ");
INSERT INTO ntu_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Nzyrpalelvzlr ninge Mz nzpxi-krnge lrpz ngr nzvzkr drtwr. ");
INSERT INTO ntu_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Lr mztea nzpikitinedr ninge. X ncblo kxnzrmnqng nzngr-xtrnga-ngrdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Yawe, arlapx ninge mzli kznike mrlzbz bam Mz nzmyalzkr zmrlz ngrm. ");
INSERT INTO ntu_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","A' veclzm ninge mz mu ngr nzkxpu-krngeng. X arlapxbz ninge mz nzngyatikr drtwr enqmi rngeng ninge. ");
INSERT INTO ntu_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Bzkq rlrpx-ngrn nzyrlemikr drlr ngr nrc ninge, X bzkq botxo-alox mz nzbzlz-krmc mz gqpr. ");
INSERT INTO ntu_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","17","Yawe, ninge kxnzawz nem. Ayzlum natqnge murde aodu-zvzq ninge. X amrlz ninge murde yc mz drtwrm ninge. Bzkq mnc-rlrume bange. A' okatr ninge, murde nabznge talvzo. ");
INSERT INTO ntu_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Vzm bange X xpepxbz ninge mz mq enqmi rngeng. ");
INSERT INTO ntu_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Murde krlzq enqmi rngeng amrlx, Kxmu nzpibqti-krdr ninge x nzamyati-krmlr drtqnge. ");
INSERT INTO ntu_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Nzobqszo-krdr ninge yrnibungr nabznge. Yrni-ngrne nzvzkr drtwrnge, A' trpnzngr kxnaokatrle x na-amqtrple drtwrnge. ");
INSERT INTO ntu_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","A' nzrkamqng nange dakxnzng kxpiz, X mz nzbrlxkzkr drtwrnge, nzrkamqng mqnge waen kxrkx. ");
INSERT INTO ntu_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Yawe, kxmu nzmukr leplz lcng badr kztedrng Mangr-nzangiongr trtubqu mz nzobq-krm. Delc, tzrtxlvzlz-mou-ngrdr alwx ngrdrng x takitrde nzodati-krm nidr. ");
INSERT INTO ntu_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Akcbz mztr, X ayangrnga-zvzbz nrkrdrtqdr. ");
INSERT INTO ntu_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Ayrplapx nidr mz zngya ngr drtwrm, Kc tqapule nyr kx nangc-ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","X batrpz nzbz-krdr, Murde ma nyzdr namznrtx-alongr. ");
INSERT INTO ntu_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Rlxtibo bam da lcng murde ayrplapxpeq ninge, A' nzrtxlvzlz-moplr nzetqkr drtqnge. ");
INSERT INTO ntu_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Delc alwx ngrdrng nartxlvzlz-kz-ngrdeng, Murde ma tzprtrng mz nzripqpx-krm alwx. ");
INSERT INTO ntu_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Bzkq yroq drtqdr mz Buk ngr Nzlungr, Mrkc tqyclz-ngrm drtq kxnztubq nemqng. ");
INSERT INTO ntu_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Gct, tangigx-zvzx mz nzetqkr drtqnge, Mzli ka tqaenzlix nzmnc-zpwxngr kc navzm mz nzarlapx-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Murde na-angrlvzx nim, X naglqlzx nim mz nzawingr. ");
INSERT INTO ntu_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Murde sa na-abrtz-ngrm nzangio-krnge nim Namyaszlzle nzangc-krbo blz bam. ");
INSERT INTO ntu_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","X leplz txneng na-abrtzng mz nzokatr-krm nidr, Murde apqtr-mopwzme nabzdr. ");
INSERT INTO ntu_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Murde lalztqbzme mz kxtrnzrngiscung, X trmrbrtru mz drtwrm leplz nemqng kcng tzkxpung. ");
INSERT INTO ntu_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Nimu bongavz x drtc' naglqpxamu Kxrpalz. Nimu prla x dalr prla amrlx naglqlz-kzamu nide. ");
INSERT INTO ntu_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Murde sa na-arlapxle Mzteadau nyzde x sa na-atulz-moule mztea ngr Judz amrlx. X kxnzwztrpzng bade namncng elr x nangi nyzdr drtc'. ");
INSERT INTO ntu_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","X sa na-aprcbzle drtc' mz doa ne leplz nedeng, Murde leplz kcng tzmrlztilr nide namnc-zvzng elr. ");
INSERT INTO ntu_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Gct, vz-anim mz nzarlapx-krm ninge. Kxetu, rnekim mz nzokatr-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Okatrp ninge mz nzaovxio-krnge kxnzrpilr na-abzlr ninge, Murde drtqdr namya mzli kc nadwasz-ngrdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","X leplz lcng tzxtrnga-ngrdr ninge drtqdr namya Mzli kc nametx-ngrmlr bange. ");
INSERT INTO ntu_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","A' amrlz krkcng tzbrti drtwrdr nim Mz nzrka-krbzme badr nzabrtz-zlwzngr, Murde na-awi-zvz-ngrbzlr bam nzarlapx-krm nidr Mz nzrpi-krbzlr kx, “Gct, nim kx myatxlz-esz'ngr.” ");
INSERT INTO ntu_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Yawe Gct, trxplr-zvzwxu, x trpnzngr scnge zmatq. Vz-anim, kx Gct. Murde nim txpwz Mevalu rnge. Bzkq asaq nzokatr-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Yawe, mnc-xglex nim nztu-krme mz nibrnge. X bzkq rlrpx-ngrn nzaovxiokr enqmi rngeng ninge. ");
INSERT INTO ntu_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Lalztqm bange mz nzokatr-krm ninge. X arlapx ninge murde tubq-esz'ngrn. ");
INSERT INTO ntu_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Nangini-kzp me rlakitrx mz nzmnc-kapqtr-krbo bam. Murde nim butqbr x lrpalvc nyznge. ");
INSERT INTO ntu_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Gct rnge, arlapx ninge mz mq leplz kxdrka'-ngrng, Kcng tzrpilr naodatilr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Murde nim, Kxetu Yawe, kx brti drtwrnge, yzutr pnz mzli kc tqngi-oblabe-ngrne. X sc tqvzbe nzabrtr-krbo drtwrnge bam. ");
INSERT INTO ntu_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Abzo mzli kc tzmcngr mzke', krlzmle mzli ka, mnc-xgletxpwo nim, Mz nzaclve-zvz-krm ninge. Delc naglqlz-zvz-ngrne nim. ");
INSERT INTO ntu_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Nzrpi leplz kx ninge rkx ngr da kxtrka, A' nim lrpalvc kxmqngi kx rlakitrx. ");
INSERT INTO ntu_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","X glqlz-zvzx nim mz zbq kang kqlu, Mz nzyapwxtipx-krnge nzmyalz-esz'ngr-krm. ");
INSERT INTO ntu_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Delc kxmule-esz' nipenge lrtzlvz, a' bzkq drtqm satrp bange, X bzkq rlaszq ninge mzli ka tqyangrngape-ngrne. ");
INSERT INTO ntu_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Murde enqmi rngeng nzycmnetr-ngrdr ninge X nzryrlqpeng drtwr, ");
INSERT INTO ntu_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Mz nzrpi-krdr kx, “Gct sc tqrlaszpele nide. Vzmamu, nalolvzpeku murde trpengr kx na-arlapxle nide.” ");
INSERT INTO ntu_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Gct rnge, bzkq mnc-rlrume bange, A' vz-anim mz nzarlapx-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Aovxio x odati krkcng tzrpilr natzlr x na-atrkatilr ninge, Mz nzamyati-krbzme drtqdr x nzbatr-krbzme nzobqszokr leplz nidr. ");
INSERT INTO ntu_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Sa na-abrtr-zvzbo drtwrnge bam, X naglqlz-ebir-ngrne nim. ");
INSERT INTO ntu_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Kxmule-esz' da kcng tqaleq nzkqlu-zlwzng, A' mz zbq kang kqlu sa nayapwxtipxx nztubq-krm, x zmatq ngrm mz nzarlapx-krm leplz. ");
INSERT INTO ntu_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","X sa navzbo bam mz nzglqlz-krnge zmatq ngrm, Murde nim txpwz kx tubq-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Gct, alvztrq ninge, abzo mzli kc tqngi-oblabe-ngrne. X sc tqyapwxtipxbex da kx nzkctitxpx kcng tqwz-ngrn. ");
INSERT INTO ntu_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Mzli ka nipenge lrtzlvz x nqnginarnge prkipe, bzkq rlaszq ninge. A' mncm bange mz nzyapwxtipx-krbo zmatq ngrm mz nrpr ngr leplz amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Gct, nzetukr nztubq-krm krlzlzle bongavz. X trpnz-moungr kx apule nim kc tqaleti da kxetuting. ");
INSERT INTO ntu_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","X kxmule-esz' batrpe' nzetukr nzkxpu-krngeng, a' krlzx kx sa na-amrna-mowq nzlu-krnge, Mz nzarlapx-krm ninge mz gq. ");
INSERT INTO ntu_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Sa na-aetunepxbzme nzamatqkr leplz ninge, Mz nzaelalz-mou-krme drtwrnge. ");
INSERT INTO ntu_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Gct rnge, nim Gct rgr, nigr lr Israel, x sa nangrbo bam mz nzayrni-krbo gita x ukzlele. Tr-esz'ngrn x sa naglqlzx nim murde ngida angidrme bagr. ");
INSERT INTO ntu_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Sa namalq-katox mz nzabrtz-krnge, X mz nabznge atwrnrngr sa nangrbo bam murde arlapxpeq ninge. ");
INSERT INTO ntu_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Mz zbq kang kqlu sa napipxbo nztubq-krm mz nzokatr-krm ninge. Murde krlcng tzrpilr na-atrkatilr ninge aovxiopeqng x drtqdr myape. ");
INSERT INTO ntu_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Nabz ne Solomon. Gct, batrpz nzaxvctr-krbz king rgr mz zmrlz ngrm, X okatrpz nide mz nzvz-nqblq-krde nztubq-krm. ");
INSERT INTO ntu_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Murde nzaclve-krde nigr leplz nemqng namrlz, X na-atubqtibzle da mz kxnzobqszong. ");
INSERT INTO ntu_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","X nigr amrlx sa namnc-zpwxkr, Mz nzmnclz-krbzkr mz nztubqkr nzaclvekr king rgr. ");
INSERT INTO ntu_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Sa natubz mz nibr kxnzobqszong, X sa na-arlapxle kx trpnzngr scdr zmatq mz nzaovxio-krde kxnzakxputilr nidr. ");
INSERT INTO ntu_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Nzamrluekr leplz nim sa navz zvz, Da kc tqwai nzyzlr-zvzkr nepi x temz. ");
INSERT INTO ntu_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","X King nem sa na-amrlzle nigr leplz nedeng, Mz nzapu-krde tewa kc tqdcom mz nrlanc. ");
INSERT INTO ntu_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Mzli kc tqngini-ngrde king nztubqngr naetunepx mz nrlc, X nzmnc-zpwxkr leplz navz zvz da kc tqwai nzyzlr-zvzkr temz. ");
INSERT INTO ntu_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Nzaclve-krde yzutrle mz Lue Yufretis, Nakrlzbzle mz nrlc tulvzo. ");
INSERT INTO ntu_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Enqmi rdeng sa na-aovxioleng, X nayrngzobzng bade. ");
INSERT INTO ntu_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","King mz nrlc tulvzo sa nartwzmqng bade dalr nzrle-kangr, Myapxbz king r trmctung, x Arabia, x Afrika, murde namnc-lxblrng badr mz nrwx. ");
INSERT INTO ntu_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","King amrlx sa nayrngzobzng bade, X leplz amrlx sa na-angiolr nide. ");
INSERT INTO ntu_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","King lc sa natubz mz nibr kx trpnzngr scdr da, mz nzkqle-krdr nide. X naokatrle kxnzobqszong kcng tzmncng esz'-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Sa naycngr drtwrde kxtrnzxplrung x kx trpnzngr scdr zmatq. X na-arlapxle nra-nzlung ngr leplz. ");
INSERT INTO ntu_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Sa naxpepxle nidr mz mq kxnzakxputing x kxnzatrkatilr nidr, Murde matq mz drtwrde nzlu-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Leplz amrlx sa nakrka'-ngrdr nide Murde Gct na-amrlz-zvzle nide, Mz nzrpi-krdr kx, “Gct, king lc nalu angidr zvz. X lr Arabia narkabzng gol kxpnapr bade.” ");
INSERT INTO ntu_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Krka'-ngrgr kx nrlanc nyzgrng nalvc-angidrngr dakxnzng. X nounc nyzgrng nadobeting na-apule nounc ngr drtc' kc Lebanon. X taon nyzgrng nayrbu mz leplz Na-apule nzyrukr nabr ngr nardzng. ");
INSERT INTO ntu_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","King lc nadcpx zvz mz drtwr. X drtqde nayc zvz mz nzapu-krde nzti-zvzkr nepi. Murde sa nanginide nou nzamrlzkr Gct leplz amrlx mz nrlc, Mz nzkrlz-krdr kx matq-esz'ngr mz nzobqkr Gct. ");
INSERT INTO ntu_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Naglqlzku Yawe, Gct r melrmqgung. Nide txpwz kxnzkctipx. Naglqlzku Yawe. ");
INSERT INTO ntu_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Navz navz zvz nzangiongr drtqde. Nzrglqlzngr nide navz navz zvz. ");
INSERT INTO ntu_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Krlc me yrkrpxngr nabz x nzkrka'-ngrng kx yr King Devet, mrlx Jesi. ");
INSERT INTO ntu_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Nabz ne Asaf. Kxmule-esz' rpiku kx, “Gct mrlzti nivz lrde nigu lr Israel, X amrlzle kx nabzdr lq,” ");
INSERT INTO ntu_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","A' nabznge ngrgo. X nzrlxngiti-krnge ycpwz pipz nzaxtx-krbole. ");
INSERT INTO ntu_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Murde mcx nzrngisc-zlwzkr kxdrka'-ngrng, X kcmnztx-ngrne dztu kxnzglqpx-lzbq lcng. ");
INSERT INTO ntu_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Mz nzaotikr drtwrnge, trpnzngr nzetqkr drtq kx nzxngitrlr, A' nzyrlvz-angidrng x nzxplrng. ");
INSERT INTO ntu_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Leplz lcng trpnzngr zyagox kx prtzbz badr, X trnzrmctilru nzkxpungr. ");
INSERT INTO ntu_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Delc tzbi-zlwz-ngrdr mz nzglqpx-lzbq-krdr, X drtqdr trmyau nzrtulrtr-krbzlr me pnz drtwrdr. ");
INSERT INTO ntu_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Da kxtrka nzvzpxmqng mz nabzdr x drtwrdr, Apule lue kc tqyrlepxm mz nzwxplikr kxpqbu. ");
INSERT INTO ntu_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Nzryrpalelvzng leplz kxnztubqng x nzycmnetxtrpwzng mz da kxtrka. X nabzdr nzbilvzlr zmatq ngrdr mz natq ngr nzamwxlr-krdr leplz. ");
INSERT INTO ntu_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Nzycmne-atrkatilr Gct kc Heven, X nzrpilr kx nidr kxnzetu r leplz mz nrlc mz nzrka-krbzlr natq badr. ");
INSERT INTO ntu_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Mzli ka kzdung leplz neng Gct nzlalztqpe-kzpzng badr, Mz nzlxngiti-krbzlr natqdr. ");
INSERT INTO ntu_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Nzrpibzlr badr kx, “Vz-nqblqmamu nigr, Murde Gct kc Heven trtxpnzngr nzmc-krde nimu.” ");
INSERT INTO ntu_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Krlc nqmq kr leplz kxdrka'-ngrng. X kxmule-esz' nzrngiscpeng da kxkqlu, a' drtwrdr trpnzngr nzesapx-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Gct, mz nzmc-krnge nidr, rpix esz'-krnge kx, “Mane nzalqti-lzbq-krnge. X mane nzyrlqpx-lzbq-krnge mz alwx. ");
INSERT INTO ntu_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","15","Murde drtqnge etq zvz mz zbq kalvz, mz nzkxpu-zlwz-krnge.” A' trvz-nqblqwxu natq kxdrka'-ngrng, Mz nzrpi-krdr kx trmcwq alwx ngrgrng, Murde ma tqmailzx leplz nemqng mz nzvz-rbr-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Rblxm bange nzkrlz-krnge drtwr ngr nzrlr-krbzme mz kxnztubqng nzkxpu-krdr, A' trayrplapxwq kxdrka'-ngrng. ");
INSERT INTO ntu_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Zbz kx vztrx Mangr-nzangiongr nim mz nzmnc-lrpi-krnge, Sc tqkrlz-atex kx kxdrka'-ngrng lcng trpnzngr nzmnctr-krbzlr bam Heven. ");
INSERT INTO ntu_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Murde rlr-ngrbzme badr nzvz-nqblq-krdr me pnz drtwrdr, kc tqbatrpzle nzodatingr nidr. Nzapulr kx nzvzneng mz drtc' kxmiglq kc tqrbatrpz nztao-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","X nzodatingr lc nidr na-ani txpwz, X nzvzdz-krm nelzdr mz zmwxlr sa naprtrpz badr mzli kc nabz-ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Mz nzbz-ani-krdr lc, nzapulr nzrmwiblengr Kc tqmrbrtr mou mz nzdwalz-ngrm. ");
INSERT INTO ntu_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Mzli kc tqxngitr-ngrne mz nabznge nzaetq-krme drtqnge, X zngya ngr drtwrnge lolvztxne, ");
INSERT INTO ntu_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","Apux poi kzpeto Mz nzpqbrtxnekr narnge x nzngqngu-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Kxmule-esz', a' mnc-zvzme bange, Mz nzlolvz-amqngi-krm mqnge. ");
INSERT INTO ntu_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","X vz zvz nzmailz-krm ninge mz nzalvztr-krm ninge. Murde naprtrx mz nzarmyalz-krm ninge kalr. ");
INSERT INTO ntu_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Trpnzngr da kx wz-ngrn Heven x nrlc Kx suti drtwrnge, a' nim txpwz, Trte. ");
INSERT INTO ntu_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Kxmule-esz' nabznge ngrgo, a' nim nzxplr-krnge, X namncme bange, tqvzpe tqvzpe. ");
INSERT INTO ntu_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Gct, krkcng tzpx-ngrdr nim, trnamnctrpzu bam mz nibr nzbz-krdr, Murde sa naodatiq kxtrnzabrtrpzlru drtwrdr bam. ");
INSERT INTO ntu_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Kxetu Yawe, mrlzvxitxm bange nzmnc-aepztr-krbo bam Mz nzrlatr-krbo bam, murde napipx-zvzbo nqmq krm mz leplz. ");
INSERT INTO ntu_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Nabz ne Asaf. ?Gct, memule tqrtctx-alope-ngrn nigr, Mz nzngyatikr drtwrm nigr sip nemqng? ");
INSERT INTO ntu_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Nadcpx mz drtwrm nigr kcng tqmcpxqng mzli kc bqnc, mz nzarlapx-krbzm nigr mz mq kxnzakxputilr nigr, X mz nzmnc-krme bagr mz Newz Saeon. ");
INSERT INTO ntu_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Vztr ena mrlcde mz Mangr-nzangiongr nim Jerusalem, Murde namcq nzodati-atwrnrkr enqmi rgrng da amrlx mrka. ");
INSERT INTO ntu_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Enqmi lcng nzmalqlvzlr Mangr-nzangiongr nim, Nzpetr-krdr nc nqngq ngr nibr kxrmailz ngrdr mz nounc kx nzatulr mrlcde mz nzaelwapx-krdr nzaovxio-krdr nigr. ");
INSERT INTO ntu_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","6","Nztaglctilr mz xks x hama scdrng da kcng tzlzting amrlx mrlcde, Mz nzapu-krdr ncblo kx narlaking nounc. ");
INSERT INTO ntu_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Nzkatrpzlr nyr ngr Mangr-nzangiongr nim, Mz nzmatinetrkr drtwrdr nztr-esz'ngr-krm. ");
INSERT INTO ntu_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","X nzangctitxdr mrkcng amrlx tqangio-ngrgr nim mz drtc' nyzm, Murde narnzlvzo-atwrnr-ngrdr nigr. ");
INSERT INTO ntu_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Dalr nzangio-krgr nim lcng amrlx nzmrbrtipeng, X trpengr profet kx narpim bagr mzli kx naesakingr nzkxpungr lc. ");
INSERT INTO ntu_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","?Gct, myx mzli kx nakrlzbz enqmi rgrng nzxtrnga-krdr nim? ?Myx kxmule, narlrtx-alope-ngrbzme nzycmne-atrkati-krdr drtqm? ");
INSERT INTO ntu_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Bzkq mnc-lrpitxn, A' odati nidr mz nzokatr-krm nigr. ");
INSERT INTO ntu_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Gct, kxmule-esz' nzmusrnepegr lc, a' nim King rgr yzutr pnz mzli kc bqnc. X nzwrde kqlu kx arlapx-ngrn nigr. ");
INSERT INTO ntu_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Sc tqakipxq Prla Bla mz zmatq ngrm. X tqtamyrnr-ngrn nardr mepwz kc tqngi Ijipt. ");
INSERT INTO ntu_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Murde aovxioq kxnzetu rdrng, X kabzme nrkrdrtqdr nangq animol ngr lzke. ");
INSERT INTO ntu_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Sc tqaglqwiq mrkc tqrpnakilzm aulz x narlue. X apz-kzq me nakawicngr LueJodzn. ");
INSERT INTO ntu_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Nim kxrpalz kc tqwz-ngrde ngrlx x nrlckxbq, X nim kc tqryrlq nepi x temz mrnyzdr. ");
INSERT INTO ntu_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","X nim kc tqryrlqbz me nangi bz ngr prla x drtc', X yrlq-kzpzme mzli r zbao x zpq. ");
INSERT INTO ntu_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","A' Yawe, nadcpx mz drtwrm kx enqmi rgrng nzxtrnga-ngrdr nim, X nzatrkatilr drtqm mz nzycmne-krdr mz nzobqszo-krdr nim. ");
INSERT INTO ntu_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Bzkq mrbrtr mz drtwrm kxnzakxpu nemqng, Mz nzapusr-krm nigr bona kx nalolvzti kuli kzpeto. ");
INSERT INTO ntu_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Nadcpx mz drtwrm Nzesz'tikr Drtwrgu mz nzarlapx-krm nigr, Murde mzli ka ncblo kxayo nzkqlupeng kxnzmnc-kapqneng mz nzlo. ");
INSERT INTO ntu_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Bzkq rlr-ngrbzme badr nzaovxio-krdr nigr kxnzakxpung, Murde nigr leplz txneng kx trpnzngr scdr zmatq naglqlzkr nim. ");
INSERT INTO ntu_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Gct, vzm mz nzatubqti-krm drtwr kxnzobqszolr nim, Mz nzdcpxkr mz drtwrm kx nzxtrnga-zvz-ngrdr nim. ");
INSERT INTO ntu_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Bzkq mrbrtr mz drtwrm enqmi rmqng kx nznemi-zvzlr zngya mz nzatrkati-krdr nim. A' vzm mz nzawx-nabu-krm nidr mz natqdr. ");
INSERT INTO ntu_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Nabz ne Asaf. Gct, awitx-ngrbzkr bam mz nzmnc-aepztr-krme bagr. Aleq da kxmrlzting. Gct, awitx-zlwzbzkr bam. ");
INSERT INTO ntu_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Gct rpile kx, “Yrlqpex mzli kx napipx-ngrne doa kx tubq x kx vz-rbr. X nzayzlu-krbo da badr narsakrlrngr. ");
INSERT INTO ntu_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Kxmule-esz' nrlc badr leplz ngrdeng nzrnrcng, A' sa nalolvz-amqngix nou nrlc. ");
INSERT INTO ntu_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","5","Pibo mz kxnzglqpx-lzbqng kx bzkq nzglqpx-lzbqng Mz nzbilvz-krdr zmatq ngrdr. X pi-kzpo mz kxdrka'-ngrng kx bzkqpe nzarmyalz-lzbqng, Mz nzailvzo-krdr kztedrng.” ");
INSERT INTO ntu_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Murde trpnzngr me vzkipxm nzarmyalzngr Mrka mz nrlc. ");
INSERT INTO ntu_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","A' Gct txpwz kx na-ayzlu-ngrbzle da mz leplz amrlx, Mz nzayrplapx-krde kxdrka'-ngrng x mz nzarmyalz-krde kxnztubqng. ");
INSERT INTO ntu_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Yawe ngyati zlwz drtwrde kxdrka'-ngrng. X mz nzayrplapx-krde nidr Na-apule kx rkabz badr kap ngr waen kx xplr. X mz nzmnq-krdrle trpnzngr kxpipz kx nayctxo, a' nayrkrtxlzm. ");
INSERT INTO ntu_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","A' trtxpnzngr nzesakikr nzyapwxtine-krnge Gct r Jekop, X sa na-angrlvz-zvzx nide. ");
INSERT INTO ntu_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Murde rpile kx, “Sa naodatix zmatq ngr kxdrka'-ngrng, A' zmatq ngr kxnztubqng sa na-aetunepxbo.” ");
INSERT INTO ntu_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Nabz ne Asaf. Lr Israel nzangiolr Gct. X drtqde nzkrlz-zlwzlr. ");
INSERT INTO ntu_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Ma nyzde tuom Jerusalem, Mz newz Saeon. ");
INSERT INTO ntu_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Mrlc dekc tqtwz-ngrde temz ngr lomr, toki r vea, x nipna scdr enqmi rdeng, Mz nzodati-krde dalr nzotangr amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Gct, nim Ngrlrvea kxmyatxlz zlwz. X myaszlzq newz kcng bqnc tzmyatxlzng. ");
INSERT INTO ntu_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","6","Gct ngr Jekop, mzli kc tqpnanati-ngrn enqmi rmqng, Odatipeq zmatq ngr ncblo ngr vea nedrng x rblxbz badr nzotangr. Ncblo amrlx kcng tzvoneng mz hcsi x hcsi nedrng nztatio-lxblrng x nzbzng. Nibqtiq nidr amrlx x twzq dztudrng. ");
INSERT INTO ntu_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Delc leplz amrlx tzmyatitr-zlwz-ngrdr nim, Murde nzngyakr drtwrm trpnzngr kx nayatrpz. ");
INSERT INTO ntu_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","9","Gct, mzli kc tqpio-ngrme Heven nzvz-rbrkr lr nrlc, Mz nzarlapx-krm kxnzobqszong, Lr nrlc lcng amrlx nzmwxlr-zlwzng X nzmnc-lrpitxng. ");
INSERT INTO ntu_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Leplz amrlx sa naglqlz-ngrdr nim Mz nzaovxio-krm enqmi rmqng kcng tzngyati drtwrdr nim. Murde ncblo ngr vea kcng trnibqtiwqng tzmetxbzng bam, Nzpipxbzlr kx nanginipedr ncblo nemqng. ");
INSERT INTO ntu_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Delc na-angidati-ngrgu da kx esalz-ngrbzku mz Yawe, Gct rgu. X lr mrkzbleng kcng tzesotrpzng nartwzmqng dztudrng kxmrlzvxing mz Gct kc tzmyatitr zlwz, murde aovxiole nidr. ");
INSERT INTO ntu_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Murde nide kc tqavzole kxnzetung. X king amrlx mz nrlc tzmwxlrti-zlwz-ngrdr nide. ");
INSERT INTO ntu_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Nabz ne Asaf. Yrnibo mz Gct. Yrni-katobo bade murde naxlrmle natqnge. ");
INSERT INTO ntu_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Mzli ka tqkxpu-ngrne, glalzbo mqnge mz Kxetu. Kxmule-esz' krka'tix nzwr nrlckxbq, a' trxngipwc'u nzamqtr-ngrm drtwrnge. ");
INSERT INTO ntu_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Gct, kx aoti drtwrnge nim, nabznge ngrgo. X sc tqyrni-katopex mz nzetqkr drtqnge. ");
INSERT INTO ntu_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Nzkxpu-krngeng aobqtx-zvzle ninge mz nrlckxbq, X rblx-kzp bange nzycmnengr mz nztalvzokr nabznge. ");
INSERT INTO ntu_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Aoti drtwrnge zbq kcng pnz X yiz kcng bqnc. ");
INSERT INTO ntu_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","X drtwrnge ao-zlwzx mz nrlckxbq. A' drtwrnge kc tqveabe kx, ");
INSERT INTO ntu_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","?Myx kxmule, Kxetu sa napxtxpx-alope-ngrde nigr? ?X trpengr nzmrlzti-mou-krde nigr? ");
INSERT INTO ntu_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","?Nzaodu-krde nigr sa nayrkrpx-alope? ?X nzesz'tikr drtwrgr badr naesakipe? ");
INSERT INTO ntu_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","?Myx kxmule, Gct trnaycpeu mz drtwrde nigr? ?X nzngya-zlwzkr drtwrde mrilvzole nivz lrde? ");
INSERT INTO ntu_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Xngitxtr-zlwzx Gct kc tqmyalz-esz'ngr traelwapxpe-ngrpleu zmatq ngrde bagr. ");
INSERT INTO ntu_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Yawe, sa tqdcpx mz drtwrnge nqmq krmqng, X da kxnzkctipx kcng tqaletiqng mzli kc bqnc. ");
INSERT INTO ntu_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","X sa na-aoti zlwz drtwrnge da kxmrlz kxetuting Kcng tqwz-ngrn mz zmatq ngrm. ");
INSERT INTO ntu_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Gct, nqmq krmqng amrlx tr-esz'ngr, X trpnz-moungr gct kx myaszpxle nim. ");
INSERT INTO ntu_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Nim txpwz Gct kc tqaleti da kxnzkctipxng, Mz nzbatr-krbzme mz lr mrkzbleng nzmc-krdr nzxplr-krm. ");
INSERT INTO ntu_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Arlapxpeq nqvi lr Jekop x Josip, murde nidr leplz nemqng, Mz nzaovxio-krm enqmi rdrng mz zmatq ngrm. ");
INSERT INTO ntu_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Gct, mzli kc tqvz-ngrme, prla rnrcti-lzbq, X wai-kzle meboo-ngrng. ");
INSERT INTO ntu_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","18","X drtc' ycngrlrlzm mz trlipu. X zbo nzadclr tewa kxetu. X bzlrpc rpnakile nrlc apule nipna Mz nzpnamilxti-krde nrlc. X bzlrmei yrpu-zlile bongavz Mz nzpro-krm nounenq. ");
INSERT INTO ntu_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Kxmule-esz' trpnzngr kxrmc nabzlvz r nanycm x lrpzki rm, A' sc tqkawicpeq meboongr ngr Prla Bla. ");
INSERT INTO ntu_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","X mailzq leplz nemqng mz nzapu-krdr sip, Mz mq Mosis x Eron. ");
INSERT INTO ntu_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Nabz ne Asaf. Leplz nengeng, lalztqmamu mz nzalvztr-krnge, Mz nzxlr-angidr-krmamu natqngeng. ");
INSERT INTO ntu_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Sa naryapwxbo bamu mz nzycmne-ebzpxngr. X sa nayokaetipxbo dalr mzli kc bqnc kx trgalr kxrkrlz. ");
INSERT INTO ntu_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Da lcng tqxlrpeku x tqkrlzpeku Murde nzpipem melrmqgung bagu. ");
INSERT INTO ntu_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Bzkq yrlq-kapqbzkung mz doa negung, A' nayapwxtibzku badr. ");
INSERT INTO ntu_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Yawe yrlqbzle loukxtr scde mz lr Israel, Mz nzka-krbzle natqde mz nqvi lr Jekop. X rngidrlvz-ngrbzle mz melrmqgu lcng Kx na-alvztr-ngrdr doa nedrng mz lou lcng. ");
INSERT INTO ntu_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","Murde nayrlqlr lou lcng, X na-alvztr-kzpzlr mz doa nedrng. ");
INSERT INTO ntu_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Mz nzmu-krde lcde, nrpr ngr doa amrlx na-abrtrpzlr drtwrdr mz Gct, X na-aoti drtwrdr da kxnzkctipxng kcng tqalele mz nzvz-nqblq-krdr natqdeng. ");
INSERT INTO ntu_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","X bzkq na-apulr melrmqdrng kcng nardr tqmqngi x tzxpqbrlr-ngrdr Gct. Trtegu lcng nabzdr bao x nzvecpx-lzbqmqng bade. ");
INSERT INTO ntu_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Mzli kc bqnc kzdung lr Israel, ncblo ngr vea nedrng nzoliq-angidrpeng mz popz' x nipna scdrng, A' mz zbq kc navecpengr, sc tzdwapeng. ");
INSERT INTO ntu_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Murde trnzatutrlru Nzesz'tikr Drtwrdr badr Gct, X nzpxtxpx-ngrdr lou scdeng. ");
INSERT INTO ntu_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","12","Kxmule-esz' nzmcpelr zmatq ngr Gct, A' trmatqu mz drtwrdr da kxnzkctipxng kcng tqaleleng mrkc Ijipt. ");
INSERT INTO ntu_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Akipxle Prla Bla x mz nrlarde rlilr atule apule nztukr drkq, Mz nzmailzo-krde leplz nedeng elr. ");
INSERT INTO ntu_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","X mz nzvz-krdr ngrlx, mailzle nidr mz dcbz, X nyr rtwayzbz badr mz nrlckxbq. ");
INSERT INTO ntu_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","16","Mzli kc tzmnc-ngrdr lzke, amrplxtrpzle rplz Kx yrlepx-ngrm lue x ningali. Murde narmnqng x drtwrdr naesatxpx zpwx Mz lue lc tqkabzle badr, tqxplrm nzyrle-krde. ");
INSERT INTO ntu_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Kxmule-esz', a' vz zvz nzatrkati-krdr Gct kc tqmyalz-esz'ngr, Mz nzale-krdr alwx x nzxpqbrlr-ngrdr nide. ");
INSERT INTO ntu_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Mz nzmqngikr nabzdr nzabzlr nzatalzngr Gct, Mz nzka-krbzle dakxnzng kx naesapxngr drtwrdr. ");
INSERT INTO ntu_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","20","Nzpibqtilr Gct, nzrpilr kx, “Kxmule-esz' luplxtrle rplz x lue yrlepx-katom elr, A' rblxbz bade nzrka-krmle nagu dakxnzng, Mz nzaclve-krde nigu leplz nedeng.” ");
INSERT INTO ntu_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Yawe kx xlrle kc nzycmne-krdr, drtwrde trmrlzlzpuu. X zngya ngr drtwrde kc tzapqtr-zlwzbzlr. ");
INSERT INTO ntu_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Murde trnzlxngitilru nide, X drtwrdr trnzabrtrpwzlru bade mz nzaclve-krde nidr. ");
INSERT INTO ntu_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","24","Kxmule-esz', a' lvxpxbzle bongavz, Mz nzatwzlro-krmle badr dakxnzng ngr Heven. ");
INSERT INTO ntu_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","X mzli lcde, leplz txneng nzmung dakxnzng nan enjrl, Mz nzangidati-krbz Gct zbrtale ngr nelzdr. ");
INSERT INTO ntu_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","X mz zmatq ngrde kz Sc tqawqpele nenq tonga x trlaki. ");
INSERT INTO ntu_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","X nenq lcng li nzrtwzmqng blzmr kio, X nzyrlwrne-krdr apule drta' ngr prla. ");
INSERT INTO ntu_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Kio lcng nztatiomqng mz drtc' O-ngalele ma nyzdrng. ");
INSERT INTO ntu_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Gct kabzle badr nikeng nzsuti zlwz drtwrdr. Nzngqdr x nelzdr krlc. ");
INSERT INTO ntu_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Kxmule-esz', a' drtwrdr tresapxu. X mzli lc tzmube-ngrdr, ");
INSERT INTO ntu_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","Gct sc tqnibqtipebzle obla nedr kcng tzxplrng, Mz nzngyatikr drtwrde nidr. ");
INSERT INTO ntu_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Kxmule-esz' Gct ayrplapx-katole nidr mz alwx ngrdrng, a' sc tzale-zvzng alwx. X kxmule-esz' nzmcpelr nzale-krde da kxnzkctipxng, a' trnzlxngitilru nide. ");
INSERT INTO ntu_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Zbz sc tqnibq-anipele nidr Mz nzapusr-krdeleng lue kc tqmilqpx mz leu r nya x tqmrbro mz drtc'. ");
INSERT INTO ntu_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Kx nibqle kcng, opxm kx drtwr kxnzlubeng sc tqyzlu-mopwz bade, Mz nzplzpx-krbzlr alwx ngrdr x nzkrka'-krbzlr bade. ");
INSERT INTO ntu_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","X opxm kz kx dctipx mou drtwrdr kx Gct kc tqrninr nide butqbr nyzdr, Kc tqarlapx-zvzle nidr. ");
INSERT INTO ntu_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Kxmule-esz', a' nzpokiatilr nide Mz nzrpi-krbzlr bade kx nzmrlztilr nide. ");
INSERT INTO ntu_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Kxmule-esz' nabzdr bao, X trnzatutrlru Nzesz'tikr Drtwrdr badr, ");
INSERT INTO ntu_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","A' trodatileu nidr, murde yckqti mou drtwrde nidr x ipqpxbzle alwx ngrdrng. X nzwrde kqlu kx ngyatingr drtwrde nidr, a' lolvztxde zngya ngr drtwrde. ");
INSERT INTO ntu_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Murde krlzle kx nidr leplz x nzkrlzlr nzbzngr, Mz nzapu-krdr nenq kc tqwq x sc tqamaneope. ");
INSERT INTO ntu_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Nzwrde kqlu lzke nzxpqbrlr-ngrdr nide, Mz nzavzti-krbzlr drtwrde. ");
INSERT INTO ntu_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Zvz nzale-ebir-krdr da kx nzangyati-ngrbzlr drtwrde, Mz drtwrdr kx lctr-zvzbz mz Gct kc Tqtr-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Mrbrtr mz drtwrdr zmatq ngrde Mz nzarlapx-krde nidr mz mq enqmi rdrng. ");
INSERT INTO ntu_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","Mzli kc tqale-ngrde da kxnzkctipxng Mz nzvzmipx-krde nidr Ijipt. ");
INSERT INTO ntu_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","X mzli kc tzmnc-ngrdr Ijipt, ngi-batrpzle lue kxetung nzlrtipx-krdr mepyr, Murde lr Ijipt ma tzrmnqng lue. ");
INSERT INTO ntu_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Atwzlr-ngrmle frck kxkqlu kx na-atrkatilr mrnyzdr, X mc kxkqlu kx namakxtilr nidr. ");
INSERT INTO ntu_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","48","Nibqtibzle kzu, sip, x gout nedrng Mz kzdq zyagox kxtrka. X mz nibrde atwzlr-ngrmle trlipu kxetu, Mz nzamzti-krbzle nounc x dalr nrlanc nyzdrng mz nzatatio-krmleleng muli-aes. Zbz sc tqatwzlrpe-ngrmle kionabr Mz nzngqti-krdr dakxnzng amrlx kx nzlutinepwzng mz nrlanc. ");
INSERT INTO ntu_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","X mz nzngyati-zlwzkr drtwrde lr Ijipt kcng tzakxputilr leplz nedeng, Atwzlr-ngrmle enjrl kxnzkqlung mz nzpulio-krmlr nyr mz nzayrplapx-krdeleng. ");
INSERT INTO ntu_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Trlolvzleu zngya ngr drtwrde, A' xplr-esz'ngr apule nubla ngr lue mz nznibqti-krde nidr. ");
INSERT INTO ntu_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Nibqtibzle doa ncblo kx ayrnrngr nedrng, Nidr kcng tzvzpxmqng mz nqvi lr Ham, doa ne Noa. ");
INSERT INTO ntu_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Mz nibrde sc tqrtwayzpebz mz leplz nedeng mz nzrlasz-krdr Ijipt. X mailztrle nidr lzke mz nzapu-krdr sip nedeng. ");
INSERT INTO ntu_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Aclve-angidrle nidr, x trnzmwxlru. A' aboobzle enqmi rdrng amrlx prla. ");
INSERT INTO ntu_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","X mz nibrde sc tqvzmitr-atele nidr mz drtc' kxtr nyzde, Kenan, Mrkc tqtungr Newz Saeon, kx nztwz mz zmatq ngr nzaovxio-krde. ");
INSERT INTO ntu_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Maneutipxle leplz kxnzmnc-mrbrng mrlcde, mz nzvztrkr leplz nedeng mz drtc' lc. X sc tqakipxpebzle drtc' lc mz neidu lr Israel kcng nzpnu-esz'-nrade-li, x nzmncpx-alzupq'ng mz ma nyzdr. ");
INSERT INTO ntu_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Kxmule-esz' nzmncpeng mz drtc' kxtr, a' sc tzycmne-plztitrlr x nzxpqbrlr-ngrdr Gct kc tqrninr mz nzpxtxpx-krdr natqdeng. ");
INSERT INTO ntu_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Leplz lcng nzapulr melrmqdr kcng bqnc mz nzesablqti-krdr nide x nzvecpx-lzbq-krmlr bade. Mz nzmu-krde lcde, trpengr kx brti drtwrde nidr. ");
INSERT INTO ntu_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Nzangyatibzlr drtwrde mz nzangio-krdr kx trngiu Yawe Gct angidr, X mz nzyrngzo-krbzlr mz mqngr da kxnzlz. ");
INSERT INTO ntu_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Kx mcle da lcng tzaletilr, ngyati zlwz drtwrde leplz nedeng, X sc tqpxtxpxpe-ngrde nidr. ");
INSERT INTO ntu_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Rlasz-pnzle Tentkxtr nyzde kc mztea Saelc, mz drtc' nyz Efrem. Mrkc tzmnc-kai-ngrdr badr leplz nedeng. ");
INSERT INTO ntu_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","X rlr-ngrbzle mz enqmi nztwz-krdr Bokis kc tqyclz-ngrm Nzesz'tikr Drtwrdr Badr, Kc tqngi rkx ngr zmatq x nzmyapx-esz'ngr-krde. ");
INSERT INTO ntu_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","X mz nzngyati-zlwzkr drtwrde leplz nedeng, Rlr-ngrbzle mz enqmi rdrng nznibqti-krdr nidr. ");
INSERT INTO ntu_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","X obla nedrng amrlx nzbzting mz vea, X olvi nedrng trpengr obla kx naryrlzting. ");
INSERT INTO ntu_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Pris nedrng nzbzti-kzng mz vea, X olvz ngrdr nzmwxlr-zlwzng x trpnzngr mzli kx nayrnimi-ngrdr namz ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Mz nibrde, mz drtwrdr opxm kx Kxetu apule ncblo kx melz-atem Mz nzmwingr mz nzrmnq-krde waen. ");
INSERT INTO ntu_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","X mzli lcpwz aovxiole enqmi rdeng, Mz nzamyati-alo-krbzle drtqdr. ");
INSERT INTO ntu_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Gct trsutiu drtwrde doa neng Josip, X sc tqrlaszpele drtc' nyz Efrem, kzdq mrlxde. ");
INSERT INTO ntu_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","A' mcpx-alzule neidu lr Judz, Mz nzmnc-krde Newz Saeon, kc tqmrlz-zlwzbz bade. ");
INSERT INTO ntu_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Mrlc dekc tqwztio-ngrde Mrkc Tqtr murde nayc alo elr, Da kc tqwai nzyc-alokr Heven x nrlc. ");
INSERT INTO ntu_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","71","X mcpx-kzle Devet kx nawztrpz bade. X kapxmle nide mz nzaclve-krde sip neng trtede, Murde nanginide king r lr Israel, Mz nzaclve-krde leplz neng Gct. ");
INSERT INTO ntu_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","X nzaclvekr Devet nidr tubq, Mz nzmailz-zpwx-krde nidr. ");
INSERT INTO ntu_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Nabz ne Asaf. Gct, leplz kxnzmnc-mrbrng nzvztrpqng x nztztilr nigr, Murde natwzlr drtc' lc tqkame bagr. Nzatrkatipelr Mangr-nzangiongr nim, X nzodati-atwrnrpe-ngrdr Jerusalem. ");
INSERT INTO ntu_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Namz ngr leplz nemqng nzayrlwrtxnedr Ngi dakxnzng nanq utc x animol kzpetong. ");
INSERT INTO ntu_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Enqmi lcng tzlakitilr leplz amrlx Jerusalem, X mepyr ngrdr yrlenepe apule lue. Mz nzmu-krde lcde, trpnzngr nigr kx rlapx, Kx nayrtzmqlr namz ngr kztedrng. ");
INSERT INTO ntu_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Lr mrkzbleng kcng tzmnc-aepztrpqng bagr nznelvzlr nigr mz nzamyati-ngrm drtqgr, X nzxtrnga-ngrdr nigr. ");
INSERT INTO ntu_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","?Yawe, ngyati-alope drtwrm nigr? ?Myx kxmule, zngya ngr drtwrm lc tqapule nyr, kx na-angc-alopele nigr? ");
INSERT INTO ntu_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Bzkq, a' kx nangyati drtwrm kxtrnzrlxngitiung ngr mrkzbleng, Kcng trnzamatqlru x trnzangiolru nim. ");
INSERT INTO ntu_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Murde sc tznibqtipelr nigr leplz ngr nqvi lr Jekop, X tzatrkatipelr drtc' kc tqkame bagr. ");
INSERT INTO ntu_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Gct, bzkq ayrkrpx-ngrn nigr alwx ngr melrmqgrng, A' nayc mz drtwrm nigr murde nqmq nr nabzgr bao-zlwzpe. ");
INSERT INTO ntu_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Mevalu rgr, okatrp x arlapx nigr, x ipqpxbz alwx ngrgrng, Murde leplz ma tzobqszolr nim, ");
INSERT INTO ntu_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Mz nzrpi-krmlr bagr kx, “?Myxpe Gct rmu?” A' rlr-ngrm nzmc-krgr nzayrplapx-krm leplz lcng, Mz nzayzlu-krbzme badr nznibqti-krbzlr leplz nemqng. ");
INSERT INTO ntu_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","12","Kxetu, ayzlu-ebir-ngr-mopwz badr Nikeng nzalelr mz nzobqszo-krdr nim. X arlapx kz nigr leplz nemqng kcng tzlolvztilr, murde ma tqbzkr, Mz nzayzlu-krme nzyrni-krbzkr bam. ");
INSERT INTO ntu_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Murde apukr sip nemqng, X sa na-awi-zvzpebzkr bam mz nzglqlz-alo-krgr nim. ");
INSERT INTO ntu_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Nabz ne Asaf. Gct, myaszlzq enjrl kxnzetung. X aclve-zvzq nigr doa neng Josip, Mz nzapu-krgr sip nemqng. Lalztqm bagr, nigr doa neng Israel. ");
INSERT INTO ntu_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","X aelwa-ngrm zmatq ngrm bagr, Nigr nqvi lr Efrem, Benjamin, x Manase. Vzm mz nzxplr-krm mzli ka X arlapxbz nigr mz mq enqmi rgrng. ");
INSERT INTO ntu_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Gct, mz nzaodu-zvz-krm nigr, arlapx nigr, X ka-mop bagr nzxplr-krgr kc pnz. ");
INSERT INTO ntu_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Yawe Gct kc tqrninr, bzkq drtwrm ngya-zvzm bagr, A' ayzlum nzkrka'-krgr. ");
INSERT INTO ntu_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Tekqtrpebzme dakxnzng nagr mz nzavz-krbzme drtwrgr. X mz lue amnqtr-zvzpeq nigr mz drlemzkr. ");
INSERT INTO ntu_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Rlrtx-ngrpwzme mz lr mrkzbleng kcng tzmnc-ngalelr nigr nzyrpalelvz-krdr nigr X nzotalvz-krdr drtc' nyzgr kx neke nartwz. ");
INSERT INTO ntu_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Gct kc tqrninr, mz nzaodu-zvz-krm nigr, arlapx nigr, X ka-mop bagr nzxplr-krgr kc pnz. ");
INSERT INTO ntu_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","9","Apusr-ngrn nigr nqvi lr grep ngr nrlanc nyzm. Murde mz nzvzmipx-krme nigr Ijipt, Apule kx bolvztipeq leplz kxnzmnc-mrbrng mrkc Kenan, Murde nqvi lr grep nyzm natu-amqngi mz drtc' lc. ");
INSERT INTO ntu_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","11","X bz ngr nrlanc kc tqoliqtime bagr yzutr mz drtc' ngr Lebanon, Vz krlzbzle Lue Yufretis. X vzki-kzple mz newz kxnzetung, Vz x krlzbzle Prla Meditrenia. ");
INSERT INTO ntu_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","A' mzli ka opxm kx awxlikiq nabxbz ngr nrlanc nyzgr, Mz nzrlr-krbzme mz enqmi rgrng nzrtwz-abeane-krdr dalr nrlanc. ");
INSERT INTO ntu_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Lr mrkzbleng nzapulr poi kzpeto kcng tzayabetilr nrlanc, Mz nzapusr-krdr nigr dakxnzng nadr. ");
INSERT INTO ntu_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Gct kc tqrninr, obqom bagr Heven. X okatr-mop nigr mz nzapu-krgr nqvi lr grep nyzm, ");
INSERT INTO ntu_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Kc tqpetiq Murde naxplrkr mz nzmnc-krgr mz drtc'. ");
INSERT INTO ntu_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","17","Ngaprbz ncpa'bu ngrgr kx nao-zlilzkr, Mz nztu-zvz-krme mz nibrgr, nigr leplz nemqng. Murde enqmi rgrng nzapusr-ngrdr nigr nounc kc tzlakitxo x nzangc mz nyr. Delc naodati-ngrbzme nidr mz zngya ngr drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Zbz trnaesablqtikru nim, A' naglqlz-zvzpekr nim mz nzalu-krm nigr. ");
INSERT INTO ntu_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Yawe Gct kc tqrninr, mz nzaodu-zvz-krm nigr, arlapx nigr, X ka-mop bagr nzxplr-krgr kc pnz. ");
INSERT INTO ntu_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Nabz ne Asaf kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Namalqlvzku Gct murde nide lrpalvc nyzgu. Nangr-katobzku mz Gct ngr Jekop. ");
INSERT INTO ntu_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Na-ayrnitiku gita x ukzlele x na-ayrlewzku nrasrpwale Mz nzngr-krbzku bade nabz kxyrlvi. ");
INSERT INTO ntu_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Trpu navxutr mz nzrkqlengr leplz mz zbq kxnzetuting, Mz zbq ngr nzpokr temz x zbq ngr nzyc-atwrnr-krde. ");
INSERT INTO ntu_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Murde krlc natq kx kam Gct bagu, nigu lr Israel, Mz nzka-krbzle loukxtr scde mz nqvi lr Jekop. ");
INSERT INTO ntu_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Pipxbzle mz melrmqgung, nidr neidu lr Josip, Mzli kc tqatrkati-ngrde lr Ijipt. X ninge Asaf, mzli kc nzryr-krnge tqkrlzpe-ngrbzle me tavau, Xlrx kc natq kx trglxwxu, a' mz nibrde sc tqglx-atex. ");
INSERT INTO ntu_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Rpimle kx, “Sc tqrkatxobo da kxmrlepu kcng tqglqamu. X aopxbo drtqmu mz nzwz-kato-krmu Ijipt. ");
INSERT INTO ntu_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Mzli lc tqkxpu-ngrnamu, kqleamu ninge, x sc tqarlapxpex nimu. X sc tqokatrpele nimu tqvzmc mz bzlrmei. X ni-kznge kc tqabzle nimu mrkc lzke Mz aulz ngr Meriba.” ");
INSERT INTO ntu_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","“Naxlrmamu da kx narngidrlvz-ngrbo bamu, kx leplz nengeng. X nalalztqmamu mz natqnge. ");
INSERT INTO ntu_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Bzkq angioamu kx trngiu Yawe Gct angidr, Mz nzyrngzo-krbzmu badr. ");
INSERT INTO ntu_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Murde ninge Yawe, Gct rmu, Kc tqvzmile nimu mz nzrlasz-krmu Ijipt. X sa na-amrlzx nimu mzli kx abrtrmamu drtwrmu bange. ");
INSERT INTO ntu_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Kxmule-esz', a' tryrlq-angidrwamuu natqnge, kx leplz nengeng, Mz nzpxtxpx-krmu ninge. ");
INSERT INTO ntu_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Mz nzmu-krde lcde, rlrpx-ngrbo bamu nzvz-nqblq-krmu narmu, X nzale-krmu nike suti drtwrmu. ");
INSERT INTO ntu_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","A' sutitx zlwz drtwrnge kx nalalztqmamu bange, kx leplz nengeng, Mz nzlolvz-amqngi-krmu nqmq krnge. ");
INSERT INTO ntu_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Murde na-aovxiobo enqmi rmung Mz nzota-krgr badr. ");
INSERT INTO ntu_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","X Krkcng tzpxtxpx-ngrdr ninge, sa narnrcng mz nzyrngzo-krmlr bange, X na-ayrplapx-alox nidr. ");
INSERT INTO ntu_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","A' na-amrlzx nimu leplz nengeng, Murde na-abrtz-zlwzamu mz nzmnc-zpwx-krmu.” ");
INSERT INTO ntu_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Nabz ne Asaf. Gct wxbuom me matq nyzde, Murde napipxle kx kxnzetung nzvz-rbrng. ");
INSERT INTO ntu_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Rpibzle badr kx, “Nzaclve-krmu leplz narsakrlrngr. A' bzkq okatramu kxdrka'-ngrng nzmyaszpx-krdr kxnztubqng. ");
INSERT INTO ntu_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Murde mz nzwz-krmu natubzmu mz nibr kx trpnzngr scdr da x doa kxnzbzszng, X naokatramu kxnzkxpung x kxtrnzxplrung. ");
INSERT INTO ntu_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Murde na-arlapxbzmu krkcng trpnzngr scdr zmatq Mz mq kxdrka'-ngrng. ");
INSERT INTO ntu_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Ngqngu-plxsramu x trpnzngr da kx krlzamu, murde nqmq krmung amrlx trka-zlwzng. X trpnzngr da kx opxm mzli ka mz nrlc. ");
INSERT INTO ntu_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Nimu kxnzetung murde kapebo bamu zmatq ngr nzrmailz-krmu. X nimu amrlx apuamu mrlxng Gct kc tqmyalz-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Kxmule-esz', a' mrbrtr mz drtwrmu Kx zmatq kc tqwz-xgleamu nzkrlz nzrkatxpx-ngrbz, Da kc tzwai nzrkatxpxpe-ngrbz zmatq mz kzdung kxnzetung. X nabz-kzamu da kc tzwai leplz amrlx mz nzbz-krdr.” ");
INSERT INTO ntu_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Gct, vzm mz nzaclve-krm leplz mz nrlc tulvzo, Murde lr drtc' amrlx nzmnclzbzng mz zmatq ngrm. ");
INSERT INTO ntu_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","2","Nabz ne Asaf. Gct, bzkq mnc-lrpitxn, Murde enqmi rmqng nzxpqbrlr-ngrdr nim. ");
INSERT INTO ntu_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Sa tzryrlqng drtwr kxyc-kapq kx na-atrkati-ngrdr nigr. X nigr leplz nemqng kcng tqmrlzti-zlwzq. ");
INSERT INTO ntu_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Nzrpilr kx, “Naodatitxbzku mrnyzdr, Murde drtq Israel namrbrtxtr alo mz drtwr.” ");
INSERT INTO ntu_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","8","Enqmi kcng tzmnc-ngalelr Israel drtwrdr esz'ti Mz nzprtr-krbzlr mz lr Amcn x lr Mcab, neidu lcng li nzvzpxmqng mz nqvi lr Lot. Kxnztupeng badr me esz' nidr seleng: Nqvi lr Isc, nqvi lr Ismael, neidu lr Haga, x neidu lr Amalek, Lr mztea Taea, lr Gebal, x lr Filistia. X lr Asiria kxnzxplrng nzngi tedr kz badr. ");
INSERT INTO ntu_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","11","Gct, aovxio kz enqmi lcng mzli ka, da kc tqwai pnz nzaovxio-zvz-krm enqmi r melrmqgrng. Ayrplapx nidr, da kc tqwai nzayrplapx-krm ami ne Jabin, King r lr Kenan x Ngrlrvea nede Sisera, Mzli kc tqmilxtxo-ngrn nidr mz Lue Kison kc tqyc-aepztr mztea Endo, X namz ngrdr mibio mrlcde mz mzli nyz Profet Debra. X rlxti-kzpzkr nanibqti-kzq enqmi rgrng, da kc tqwaisr-ngrn mz lr Midizn mz nznibq-krm Oreb x Seeb, ngrlrvea ngrdrng. X maneuti nidr da kc tqwai nzmaneuti-krm king rdr, Sebz x Salmuna, mz nznibq-krm nidr mz mq profet Gidion. ");
INSERT INTO ntu_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Murde leplz lcng pnz nzrpilr kx, “Natwzku Israel, drtc' nyz Gct, nangi nyzgu.” ");
INSERT INTO ntu_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Gct, mz nzmu-krde lcde, apusrngr nidr bq r drtc', X leu kxglr kx wqplr nenq. ");
INSERT INTO ntu_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Odati-atwrnrngr nidr, apubz badr nyr kxetu Kc tqyrkrtxongr dalr peto x nardzng mz mzli r nepi. ");
INSERT INTO ntu_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","Maneuting x amwxlrng Mz nzapu-krbzme badr nounenq. ");
INSERT INTO ntu_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","Yawe, amyatitx-zlwzbz drtqdr, Murde nakrlz-ngrdr zmatq ngrm. ");
INSERT INTO ntu_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Aovxio alo x amwxlr alo nidr Murde nzmya-zlwzkr drtqdr nanibqle nidr. ");
INSERT INTO ntu_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","X mzli lc, sc tzkrlz-atepelr kx nim txpwz Gct kc tqmyatxlz-esz'ngr x drtqm Yawe. X nim King kc tqaclvele nrlc tulvzo. ");
INSERT INTO ntu_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","2","Nabz ne nqvi lr Kora kx nzyrbzlr mz kxrmailz ngr dzbe kxnzngrng. Yawe kc tqrninr, nim Gct kc tqlu. X mrlz-zlwzm bange Mangr-nzangiongr nim. Murde sutitx zlwz drtwrnge nzmncpx-krmc makoa ngrde, Mrkc tqngr-abrtz-ngrbo bam mz nabznge atwrnrngr. ");
INSERT INTO ntu_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Yawe kc tqrninr, nim Gct x King rnge. Kxnzvzdzng Jerusalem mz nzangio-krdr nim nzrlatrng mz olta nyzmqng. Murde olta nyzm apule ma nyz doa nemqng. Da kc tqwai utc tzwz-ngrdr ma nyz neidr, mz nztapirpx-krdr neimrdr. ");
INSERT INTO ntu_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","X doa lcng tzmncpxmqng Mangr-nzangiongr nim nzmnc-zpwxng Mz nzangrlvz-zvz-krdr nim. ");
INSERT INTO ntu_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Namrlzbz mz leplz kcng tzvzdzng mz Newz Saeon mz nzangio-krdr nim, Murde sa na-axplr-mowq nidr. ");
INSERT INTO ntu_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Mz nzkawi-krdr nabzlwa kxmingr narmctilr nabzde kx lrting Mz nibr nzdckr tewa. ");
INSERT INTO ntu_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","X mz nzesotr-krdr Jerusalem nzxplr-krdr sa naetunepx, Murde ycpe pipz nzkrlz-krbzlr Newz Saeon mz nzangio-krdr nim. X nim Gct rgr kxmyaszlzle krkcng tzmncng mzlilxlr amrlx Tzangiolr lr mrkzbleng. ");
INSERT INTO ntu_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Yawe Gct kc tqrninr, nim Gct r melrmqgr Jekop. Xlrm nzkrka'-krnge mz nzvztr-krnge ma nyzm. ");
INSERT INTO ntu_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Rlxtibo bam Kx amrlz-zvzbz king rgr kc tqmcpxq. ");
INSERT INTO ntu_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Murde nzmnctr-ngrbz bam mz Mangr-nzangiongr nim mz zbq kxesz', Myaszpxle nzmncngr drlve keng mz nrlc mz zbq kang kqlu. X nzprtr-ate-krbo mz naonrx ngr ma nyzm, Myaszpxle nzmnc-zvz-krnge mz ma kxnzetung nyz kxdrka'-ngrng. ");
INSERT INTO ntu_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Murde Yawe, nim King rgr kc tqbatrple nzamatqngr nigr. X nim temz ngr lomrgr kc tqyrputrngr nipna. X aclveq nigr mz zmrlz ngrm, Mz nzrlrpx-zvz-krbzme da kxmrlzting mz kxnztubqng. ");
INSERT INTO ntu_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Yawe kc tqrninr, Krkcng tzabrtrpzlr drtwrdr bam nzmnc-zpwxng. ");
INSERT INTO ntu_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Nabz ne nqvi lr Kora kx nzyrbzlr mz kxrmailz ngr dzbe kxnzngrng. Yawe, yc ngr drtwrm lr Israel mzli kc pnz, Mz nzamnc-zpwx-mou-krm nidr mz drtc' nyzm. ");
INSERT INTO ntu_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Sc tqipqpeq nidr, leplz nemqng, mz nzvz-rbr-krdr, X katxpxbzme alwx ngrdrng. ");
INSERT INTO ntu_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Mzli lcde, lolvzo-mowq zngya ngr drtwrm, X nrwx kc tqprlxpebzme badr. ");
INSERT INTO ntu_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Mevalu rgr, mzli ka, amnc zpwx mou kz nigr, X nikitx nzngyatikr drtwrm nigr. ");
INSERT INTO ntu_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","?Myx kxmule, nangyati-alope drtwrm nigr, X trpengr nzyzlukr drtwrm? ");
INSERT INTO ntu_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Trtingr! Axplr-mop nzlu-krgr, Murde na-abrtz-ngrgr nim. ");
INSERT INTO ntu_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Yawe, aelwa-ngrm bagr nzaodu-krm kc tqyc tqyc, Mz nzarlapx-krm nigr. ");
INSERT INTO ntu_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Nabrti drtwrgu natq Yawe, Murde esalz-ngrmle nrwx bagu mz nzyrlqpx-lzbq-krgu mz dalr nzngqngungr. ");
INSERT INTO ntu_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","X oliq zvz nzarlapx-krde kxnzamrluelr nide, Murde nzulrde naxngi-alope mz drtc' nyzgu. ");
INSERT INTO ntu_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Yawe aodu-zvzle nigu, murde nangida-zpwxbzku bade. X nzaclve-krde tubq, murde namnc-zpwxku. ");
INSERT INTO ntu_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Mz nzavzo-krmle nztubqngr lc bagu, Ayzlubzku mz nzngida-zpwx-krbzku bade. ");
INSERT INTO ntu_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","13","Apule kx nztubqngr lc rtwayzbz bade mz nzatubqti-krde nabz leplz, Murde naoliqti-ngrdr nzvz-krmle. Mz nzoliqngr lc, Yawe sa narkatim bagu da kxmrlzting, X drtc' nyzgu sa nalvcngr dakxnzng kxkqlu. ");
INSERT INTO ntu_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Nabz ne Devet. Yawe, xlrm nzkrka'-krnge, Murde trxplrwxu x ninge ncblo txne. ");
INSERT INTO ntu_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Nim Gct rnge. Arlapx ninge mz nzbzngr murde tenge nim, X ninge kxnzawz nem kc tqmnc-xgle-zvzle nim. ");
INSERT INTO ntu_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Nayc mz drtwrm ninge, Murde vz zvz nzkrka'-krbo bam. ");
INSERT INTO ntu_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Kxetu rnge, aelalzm drtwrnge, Murde abrtrpo drtwrnge bam. ");
INSERT INTO ntu_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Murde mrlz-esz'ngrn nzripq-zvzngr. X aodu-zvzq krkcng tzkrka'bzng bam. ");
INSERT INTO ntu_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Yawe, lalztqm mz nzyrni-krnge, X ayzlum natqnge. ");
INSERT INTO ntu_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Mzli ka kqlex nim mz nzkxpu-krnge, Murde angidati-zvzme nzrlx-krbo da bam. ");
INSERT INTO ntu_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Kxetu, trpnz-moungr gct kx apule nim, Murde trpnzngr nidr kx rkrlz nzalengr da kxnzkctipxng kcng tqale-zvzq. ");
INSERT INTO ntu_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Kxrpalz, lr drtc' amrlx kcng tqwz-ngrn Sa nayrngzobzng bam mz nzarmyalz-krdr nim. ");
INSERT INTO ntu_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Murde nim txpwz Gct, Kc tqmatq-esz'ngr mz nzale-krm rkx kxetuting. ");
INSERT INTO ntu_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Yawe, aelwa-ngrm bange me pnz drtwrm, murde navz-nqblqx natqm. X alvztrp bange nzamrlue-zvz-krnge nim. ");
INSERT INTO ntu_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Murde nabznge atwrnrngr na-awibz bam mz nzngini-krm Gct x Kxetu rnge, X na-angio-zvzx drtqm. ");
INSERT INTO ntu_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Murde nzaodu-zvz-krm ninge etu-esz'ngr, Mz nzarlapx-krm ninge mz nzbzngr. ");
INSERT INTO ntu_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Gct, kxnzglqpx-lzbqng nztutitr nardr ninge. Zbo ngr ncblo kxayo lc nzrpilr nanibqlr ninge, murde nzpxtxpx-ngrdr nim. ");
INSERT INTO ntu_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","A' yc zvz mz drtwrm leplz, x zmrlz ngrm myalz-esz'ngr. X drtwrm trngya-aniu, a' nzaodu-krm x nzangidati-krm tqvzpe tqvzpe. ");
INSERT INTO ntu_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Mz nzmu-krde lcde, yzlum x nayc mz drtwrm ninge. Axplr x arlapx ninge, murde wztrpo bam da kc tqwai lxenge mz nzwztr-krbzle bam. ");
INSERT INTO ntu_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Yawe, okatrp ninge mz nivz lrm, murde drtq enqmi rngeng namyatx-zlwzng Mzli kc namc-ngrdr nzaxplr-krm ninge x nzapqtr-krme drtwrnge. ");
INSERT INTO ntu_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Nabz ne nqvi lr Kora. Yawe wz-ngrde mzteadau Jerusalem Mz newz kxtr nyzde. ");
INSERT INTO ntu_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","X mzteadau lc nzmrlzba-krdele Myaszpxle mztea kc-kzng ngr Israel. ");
INSERT INTO ntu_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Delc nimu lr mztea nyzde, Naxlr-ngrnamu natq kxmrlz kcng tzycmnetr-ngrdr Jerusalem. ");
INSERT INTO ntu_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Gct rpile kx, “Mzli kc na-aplxtipx-ngrbo leplz nengeng, lr mrkzble kcng tzmnc-ngalelr Israel sa naprtr-kzng mz dzbede nenge, Krlcng Ijipt, Bxbilon, Filistia, Taea, x Itiopia. ");
INSERT INTO ntu_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","X sa narpibzlr kx Jerusalem lxe neidu amrlx murde nzrmctitrpzlr nzlungr bade. X ninge, Yawe kc tqmyatxlz-esz'ngr, sa na-atu-amqngix nide. ");
INSERT INTO ntu_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","X sa nayrox drtq leplz amrlx kcng tzbrti drtwrdr ninge, Mz nzprtr-krdr mz neidu lr Israel. ");
INSERT INTO ntu_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","X mzli lcde, leplz nengeng lcng amrlx sa naelang x narpilr mz nzngr-krdr kx, ‘Mztea nyzgu, Jerusalem, ngi narlue ngr me vzkipxm da kxmrlzting amrlx.’” ");
INSERT INTO ntu_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Nabz ne nqvi lr Kora. Yawe, nim Gct kx arlapxle ninge, X yrni-katobo bam ngrlx x nrlckxbq. ");
INSERT INTO ntu_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Xlrm natqnge X lalztqm mz nzkrka'-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Murde prtilzpele ninge nzkxpungr kxkqlu, X ycpe pipz nzbz-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Mzli ka mewepex, X trpengr da kx nawaitrpem bange. ");
INSERT INTO ntu_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Nzapusr-ngrdr ninge namz kx nzyrtzmqng mz gq. Murde krlcng tzbzpeng nzmrbrtitrpe drtwr nidr x trpengr nzrmcti-krdr nzokatr-krm. ");
INSERT INTO ntu_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Rtcope-ngrn ninge mz gq kx vzo la, X tutx-ngrpwz nzlo. ");
INSERT INTO ntu_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Nzngyatikr drtwrm ninge batrpzle nzetq-zlwzkr drtqnge, Mz nzmrilvzo-krde nabznge apule nrc kc tqyrplalvzo-ebir-ngrde ninge. ");
INSERT INTO ntu_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Ngi-batrpe' nzngangrkr kztengeng ninge mz nzmwxlrti-krdr zyagox lc tqdwatimle ninge. X trpengr me nayrbqkipxx. ");
INSERT INTO ntu_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Yawe, mzke' vaotxtrpebz mz nzyrningr mz nzvzkr drtwrnge. Kxmule-esz', a' mz zbq kang kqlu glalz-zvzbo mqnge mz nzkrka'-krbo bam. ");
INSERT INTO ntu_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Bzkq rlr-ngrme nzbz-krnge Murde ma tqrblxpem bange nzyapwxtipx-krbo nim mz leplz. Murde kxnzlu-txpwzng kcng tqalebzme badr da kxnzkctipxng. X namz ngr leplz trnztulzpeung mz nzglqlz-krdr nim. ");
INSERT INTO ntu_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Trnzycmnetrpe-ngrdru nzaodu-zvz-krm mz nabz gq kc tqngi me nzodatingr nidr. A' nzangidati-krm nzpipxbz mz krkcng tzlubeng mz nrlc ka. ");
INSERT INTO ntu_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","X rblxpebz mz kxnzyrtzmqng nzrmc-krdr nzmyalz-esz'ngr-krm murde nzmncng mz nabz nzlo, X nivz lrm mrbrtr-alope kz mz drtwr, mz gq lr kxnzbzng. ");
INSERT INTO ntu_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","A' krka'-zvzbo bam mz zbq kang kqlu, kx Yawe, Murde nayc mz drtwrm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","A' opxm kx drtqm satrpem bange, X sc tqesablqtipeq ninge. ");
INSERT INTO ntu_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Murde ayrplatxpx-zlwzq ninge, yzutr pnz mzli kc tqngi-oblabe-ngrne. X mzli ka nzetq-zvzkr drtqnge ycpe pipz nzayrkrpx-krde ninge. ");
INSERT INTO ntu_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Nzngyati-zlwzkr drtwrm ninge apule nubla kc tqtwzle ninge, Mz nzbatr-krbzle nzmrbrkr nzlu-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","X nzkxpu-krnge lcng nzngrlelvzlr ninge, X trpengr me nayrbqkipxx. ");
INSERT INTO ntu_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Ngi-batrpe' kztengeng kxnzmrlzng nzngangr-krdr ninge. X mzli ka nabznge talvzo zlwz mz nzmnc-krnge esz'-krnge mz nabz nzlo. ");
INSERT INTO ntu_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","2","Nabz ne Etan. Yawe, sa nangr-zvz-ngrne nzaodu-krm, Kc tqyc tqyc. X sa nayapwxtipx-alox nzangidati-krm natqm, Kc tqyctx alo, da kc tqwai bongavz. ");
INSERT INTO ntu_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","X sa nayrlq-zvzq natqm kc tqpibzme mz kxnzawz nem, Devet, Kc tqmcpxq, mz Nzesz'tikr Drtwrmu ncdr. ");
INSERT INTO ntu_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","Rpibzme bade kx, “Ncblo kcng tzvzpxmqng mz neidu lrm, sa nanginipwzlr king, Murde nqvi lrm na-aclve alo.” ");
INSERT INTO ntu_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","7","Yawe, lr Heven nzglqpxlr nzangidati-krm, Mz nzangrlvz-krdr da kxnzkctipx kcng tqaleq. Enjrl amrlx nzamrlue-zlwzlr nim, Murde trpnzngr lr Heven kx apule nim, kc tqmyaszlzle nidr amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Yawe Gct kc tqrninr, nim txpwz kx xplr-esz'ngr, Mz nzangidati-krm me pnz drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Kxmule-esz' srkau xplr, a' sc tqlolvzq, X mz nzprtz-krm nrc kxoda, lclvzbzme murde nrwx navo. ");
INSERT INTO ntu_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","X aovxio-zvzq enqmi rmqng mz nzxplr-esz'ngr-krm, Da kc tqwai nztabrti-krm Mepwz ngr prla kc bqnc. ");
INSERT INTO ntu_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Kxrpalz, bongavz x drtc' nyzmqng, Murde nim kx rwzngr nrlc x dalrdeng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","X doa x da amrlx mz nrlc tulvzo Nzaxvctr-lxblrng mz nzangrlvz-krdr drtqm, ");
INSERT INTO ntu_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Mz nzrpi-krdr kx, “Nim kc tqmatq-esz'ngr, X nzxplr-krm etu-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Nou nzaclve-krm nrlc nidr seleng: Nztubqngr, nzrsakrlrngr, nzaodu-zvzngr, x nzangidatingr.” ");
INSERT INTO ntu_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Yawe, ngi da kxmrlz nzmalq-abrtzlvz-krgr nim, Murde xngibzkr nzulrm. ");
INSERT INTO ntu_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","X ngi da kxmrlz nzbilvz-krgr drtqm, X nzglqlz-krgr nztubq-esz'ngr-krm mz zbq kang kqlu. ");
INSERT INTO ntu_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Murde axplrq nigr, X aovxiokr enqmi rgrng mz nzokatr-krm. ");
INSERT INTO ntu_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Yawe, nim Gct kc tqtr-esz'ngr x angio-txpwzkr nim. Murde mcpxbzme king rgr lc tqaclve-zpwxle nigr. ");
INSERT INTO ntu_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Mzli kc bqnc, mz nzyrlq-krm Devet nzngini-krde king, vzme mz profet nemqng, X rpibzme mz nzrmwiblengr kx, “Aprcbo zmatq mz kzdq ngrlrvea kx xplr, Mz nzarmyalz-krnge nide mz leplz txneng, murde nanginide king. ");
INSERT INTO ntu_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Ncblo kxnzawz nenge lc tqmcpxx, Devet, X aelux nide mz tolo kxtr. ");
INSERT INTO ntu_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Sa namailzx nide mz mqnge. X sa na-axplrx nide mz zmatq rnge. ");
INSERT INTO ntu_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Kxdrka'-ngrng kcng tzngi enqmi rdeng, trtxpnzngr nzyatr-krbzlr bade Mz nzamyati-krbzlr drtqde. ");
INSERT INTO ntu_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Murde sa natamyr-ngrbo nidr Mz nznibqti-krbo kxnzpxtxpx-ngrdr nide. ");
INSERT INTO ntu_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Sa na-aodu-zvzx nide x nanginide kztenge. X sa nabatrpo bade nzaovxio-krde mz drtqnge. ");
INSERT INTO ntu_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Sa nakabo bade zmatq ngr nzaclve-krde Prla Meditrenia, Navz nakrlzbzle Lue Yufretis. ");
INSERT INTO ntu_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Sa namcle kx ninge trtede, Kc tqngi Gct rde x butqbr nyzde kc tqrlakitrle. ");
INSERT INTO ntu_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","X sa na-apusr-ngrne nide mrlxnge krdau, Mz nzarmyalz-zlwz-krbo nide mz king amrlx mz nrlc. ");
INSERT INTO ntu_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Drtwr kxesz'ti kc tqyrlqbo bade, trtxpnzngr nzyzpr-krde, Mz nzangidati-krnge nzaodu-zvz-krnge nide. ");
INSERT INTO ntu_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","X nzyrlq-krbo nzaclvekr nqvi lrde tqyc tqyc, Da kc tqwai nzyc-alokr bongavz.” ");
INSERT INTO ntu_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","X rpi-mopwz Gct kx, “A' nzmu doa nedeng naesablqtilr loukxtr scnge, Mz trnzlolvz-amqngi-krdru nzalvztr-krnge ");
INSERT INTO ntu_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","X nzmu trnavz-nqblqlru me pnz drtwrnge Mz nzpxtxpx-krdr natqnge, ");
INSERT INTO ntu_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","Sa na-ayrplapxxng mz alwx ngrdr, Mz nzaetq-krbo drtqdr mz nikeng nzvz-rbrtilr. ");
INSERT INTO ntu_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","A' trpnzngr nzatao-krnge da kc tqesalz-ngrbo mz Devet, A' sa na-aodu-zvzx nide. ");
INSERT INTO ntu_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","X trpnzngr nztekqtr-krnge natqnge, A' sa na-atutr-zvzx nzesz'tikr drtwr kc tqyrlqbo bade. ");
INSERT INTO ntu_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Esalzpex mz drtqnge kxtr X amqngipex kx trtxpnzngr nzesabrti-krnge nide. ");
INSERT INTO ntu_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","37","X nzaclvekr nqvi lrde tqyc tqyc, Da kc tqwai nzti-alokr nepi x nzprtz-krm temz x nztao-krde.” ");
INSERT INTO ntu_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Yawe, rpiq da lc, a' mzli ka drtqm satrpem bange x rlaszpeq ninge, Mz nzngyati-moukr drtwrm ninge, king kc tqmcpxq. ");
INSERT INTO ntu_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Nikipeq Nzesz'tikr Drtwr kx yrlqbzme mz melrmqgr Devet, kx natu-zvzbzme mz nibr nqvi lrde, Mz nzapusr-krbzme kraon ngr narnge brmrda. ");
INSERT INTO ntu_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Awxlikitxopebzme drkq ngr mzteadau nyznge. X odati-atwrnr-ngrbzme lrpalvc nyzgrng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Enqmi rgrng amrlx nzatrkati-zlwzlr nigr. X lr mrkzbleng kcng tzmnc-aepztrpqng bagr nzyrpalelvzlr ninge, king nem. ");
INSERT INTO ntu_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Murde ngi-batrpzme nzxplrkr ncblo ngr vea nedrng. X mzli ka sc tzbilvzpelr. ");
INSERT INTO ntu_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Amyatibzme nipna scngeng mz nzrpna-krnge, X rlr-ngrbzme nzaovxio-krdr nigr. ");
INSERT INTO ntu_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Odatipeq tron nyznge, Mz nzkatxpx-krbzme zmatq ngr nzngini-krnge king. ");
INSERT INTO ntu_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Amyatibzme drtqnge mz mz leplz. X ngi-batrpe' nzngini-ani-krnge lrtzlvz. ");
INSERT INTO ntu_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","Yawe, bzkq mnc-rlrume bagr. X bzkq apqtipeq nigr mz nzngya-zlwzkr drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","A' na-aoti drtwrm nzmrbcnekr nzlu-krgr nigr leplz Mz nzmnc-krgr mz nrlc. ");
INSERT INTO ntu_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Trpnzngr leplz kx na-arlapx-lzbq, Murde nigr amrlx mnclzbzkr mz zmatq ngr nzbzngr. ");
INSERT INTO ntu_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Kxetu, opxm kx trangidatipewq natqm kc tqpibzme mz Devet, Murde trxngipepwzkru nzaodu-zvz-krm kc bqnc. ");
INSERT INTO ntu_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Bzkq mrbrtr mz drtwrm nzobqszokr leplz ninge, kxnzawz nem, Murde kxnzmnc-mrbr lcng sc tzbilvztipelr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Yawe, enqmi rmqng nznelvztilr ninge, king kc tqmcpxq, Mz nzxtrnga-krdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Na-armyalzku Yawe, kc tqngi Kxetu rgu. Tqvzpe, tqvzpe. Eu. Na-armyalzku Yawe. ");
INSERT INTO ntu_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Nabz ne Mosis, ncblo ne Gct. Kxetu, yzutr pnz mzli kc, krlzmle mzbq ka Nzngini-krm me rlakitrkr. ");
INSERT INTO ntu_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Mzli kc trwzka-ngrn nrlc x newz ngrdeng, mncpe-kaiq. Murde nim Gct, x nzmnc-krm la tqyc tqyc. ");
INSERT INTO ntu_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Rpime bagr kx, “Yzlu-mouamu,” X mz nzbz-krgr yzlu-moukr mz drtc' kc tqwz-ngrn nigr. ");
INSERT INTO ntu_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Mz drtwrgr, yiz kx siu mz nrlc ngi mzli kxboi, a' mz drtwrm mzli mrbcnepwz, Apunede zbq kx esz' kx yrkrpxpe. ");
INSERT INTO ntu_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","6","Mz nzmilxtxo-krm nigr rblx nzrlolvzngr, Apunede nzrmwiblengr kc tqmrbrtr ani mz drtwr. X nzmnc-krgr mrbcne apunekr nabr kx yru mz nourla x nrpqdr mztr luli. A' kx krlzbzle milzpq sc tzblopeng x tztatiopeng murde nzpqkr nzulr nepi. ");
INSERT INTO ntu_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Da kc tqwai nzodati-krm nigr Mz nzpqkr zngya ngr drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Murde zyzlr ngrm pnamilxtile alwx rgrng Kcng tqyrlq-kapqkrng. ");
INSERT INTO ntu_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","X zngya ngr drtwrm amrbctrple nzlu-krgr. X mz nzbz-ani-krgr apukr zycmini kx esz'. ");
INSERT INTO ntu_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Nzmnc-krgr krlz-txpwzle yiz kxnzpnu-rlimz (70), A' nzmu nrkrdrtqgr kx tqxplrle krlzbzkr yiz kxnzpnu-rtqmz (80). Yiz lcng tqyctrngr nzwz-katongr x nzetqkr drtq, Nzyrkrpx-aning x sc tqbzpekr. ");
INSERT INTO ntu_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Nzmu namckr nzxplrkr nzngyatikr drtwrm alwx Nzamrlue-krgr nim naetunepx kz mz nabzgr. ");
INSERT INTO ntu_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Okatrp nigr mz nzkrlz-krgr drtwr ngr nzmrbcnekr nzlu-krgr, Murde nzmnc-krgr mz nrlc navz-nqblqle nzyrplapx-krm. ");
INSERT INTO ntu_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Yawe, bzkq ngyati-alo drtwrm nigr, kxnzawz nemqng, A' tekqtr drtwrm x nayc mz drtwrm nigr. ");
INSERT INTO ntu_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Namc-zvzkr nzaodu-krm nigr mz nourla kang kqlu, Murde navz zvz nzangrlvz-krgr nim mz nzabrtzngr. ");
INSERT INTO ntu_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Kxmule-esz' yiz kqlu avz-ngrbzme drtwrgr mz nzkxpu-krgr mzli kc, A' tekqtrpz yiz lcng mz nzaelalz-krme drtwrgr mzli ka. ");
INSERT INTO ntu_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","X aelwa-mou-ngrm bagr rkx kcng tzkctipxng mz zmatq ngrm, Murde doa negrng namc-kzlr nzmyalz-krm. ");
INSERT INTO ntu_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Gct, Kxetu rgr, okatrp nigr mz zmrlz ngrm. Murde nra nzwz-krgr nayc-zvzbz. ");
INSERT INTO ntu_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Mz nzmnc-xgle-krm Yawe kc tqmyalz-esz'ngr Sa natubz mz nibrm. ");
INSERT INTO ntu_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","X narpibzme mz Gct kc tqrninr kx, “Nim Gct rnge kc tqabrkitrx drtwrnge, Mz nzapu-krme bange lrpalvc kx rlakitrx.” ");
INSERT INTO ntu_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Murde sa na-arlapxle nim mz nzatrkangr kx yc kapq, X mz nzrpibqtingr. ");
INSERT INTO ntu_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Sa na-aclve-zpwxle nim, Na-apule kio kc tqwxbulvzole neideng. X sa na-angidatibzle natqdeng Mz nzapu-krbzle bam temz ngr lomrm kc tqyrputrngr nipna. ");
INSERT INTO ntu_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","6","Bzkq mwxlrq mz nrlckxbq x nrlckxngrlx, Mz nzmwxlrti-krm drka', ncblo kxayo, x zyagox kxnabzngr. ");
INSERT INTO ntu_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","8","Murde kxmule-esz' siu ngr leplz nzbz-aepztrpzng bam, Mzli kc Gct na-ayrplapx-ngrde kxdrka'-ngrng, X mcq mz mzpq nzbz-krdr, A' trtxpnzngr nzatrkati-krdr nim. ");
INSERT INTO ntu_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Murde mz nzrpi-krbzme mz Yawe kx nide me rlakitrq, X mz nzmnc-xgle-krm nide kc tqmyalz, ");
INSERT INTO ntu_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Trpnzngr doa x da kx na-atrkale nim, X trpnzngr kz zyagox kx navztrpq ma nyzm. ");
INSERT INTO ntu_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Murde pipebz Yawe mz enjrl nedeng nztu-krbzlr mz nibrm, X nzaclve-zpwx-krdr nim drlvekeng vzkiq. ");
INSERT INTO ntu_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Naglqlr nim mz mqdr, Murde nanycm ma tqtcprtr mz rplz. ");
INSERT INTO ntu_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Mz nzrmcti-krm ningidoe kc bqnc, sa na-aovxioq nide. Kxmule-esz' nide drka' kxmatq, a' sa narnzlvzoq nide. ");
INSERT INTO ntu_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Murde Yawe Gct rpile kx, “Sa na-arlapxx doa kx mrlztile ninge, X sa na-aclvex nide mz nzmnc-xgle-krde ninge. ");
INSERT INTO ntu_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Mz nzkqle-krde ninge, sa na-ayzlubo natqde. Kxmule-esz' da kx prtz, a' sa namnc-aepztrpo bade, X sa nakatxpxx nide mz nzkxpu-krdeng, X sa na-armyalzx nide. ");
INSERT INTO ntu_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","X doa lc sa namcle nzarlapx-krnge nide, X nakabo bade nzlungr kxboi kx na-abrtz-ngrde.” ");
INSERT INTO ntu_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","3","Nabz ngr Sabat, zbqkxnzamati. Yawe myatxlz-esz'ngrn. X mrlzvxitxm bange nzawi-krbo bam X nzglqlz-krnge nim, Mz nzayrningr gita x ukzlele, Mzli kznike angrlvz-ngrne nivz lrm mz nourla, X nzyrlq-angidr-krm natqmqng mz milzpq. ");
INSERT INTO ntu_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Murde aelalz-ngrme drtwrnge da kxetuting kcng tqwz-ngrn. X nangrbo mz nzabrtzngr mz da lcng tqaleq. ");
INSERT INTO ntu_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Yawe, nzwz-krmqng matq-esz'ngr, X nqmq nr drtwrm vzo zlwz la. ");
INSERT INTO ntu_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Kxnzglqpx-lzbqng nzngqngung X nardr mqngi mz nztatrkr nzalvztr-krmqng mz nardr. ");
INSERT INTO ntu_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Leplz kxdrka'-ngrng nzetu-krdr Nzapulr nabztqkr betepu kc tqwou mzli kx mrbcnepwz. X da kxtrka kcng tzalelr nradr trnayc-zvzu, A' nzodati-krdr tqvzpe tqvzpe. ");
INSERT INTO ntu_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Krlc tqmu-ngrde lc, Murde nim kx rmyalz zvz. ");
INSERT INTO ntu_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Yawe, obq ena! Murde enqmi rmqng sa nabzng Mz nzaovxio-krm kxdrka'-ngrng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","A' ninge kx xplr zlwz, Mz nzrka-krme bange zmatq ngrm. ");
INSERT INTO ntu_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Mcpex nzaovxio-krm kxnzmnc-kapqng mz nznibq-krdr ninge. X xlrpex nzyrnikr kxdrka'-ngrng lcng mz nzaetq-ngrbz drtqdr. ");
INSERT INTO ntu_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","13","Leplz kxnztubqng kcng tztung ma nyz Yawe, X nzyrlwr-lxblrng mz makoa nyzde nzapulr nounc kxetung. X nzmnc-zpwxng x nzxplrng Murde dzbrdr nzvzong mz drtc' kc tqngi natqde. ");
INSERT INTO ntu_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","X kxmule-esz' nznginipedr lrtzlvz, A' sa navz zvz nzvz-nqblq-krdr me pnz drtwrde, X nradr nayc-zvzbz, Mz nzapu-krdr nounc kc tqpa zvz. ");
INSERT INTO ntu_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Krlc aelwapx-ngrde nzmrlzkr Yawe, X nztubq-krde mz nzngini-krde butqbr kc tqrlakitrx. ");
INSERT INTO ntu_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Yawe, nim King kc tqmyatxlz-esz'ngr, x rngiscm zmatq. Wz-ngrn nrlc x tu-amqngio me yc-ngrde x trycngrlru. ");
INSERT INTO ntu_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Nzmnc-krm tqyc tqyc. X nzngini-krm King yc pnz kai, x sc tqwz-ate-ngrn dalr nrlc ka. ");
INSERT INTO ntu_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Yawe, srkau ngr prla, nzalxlvrti-ebir-ngrdr da. X natq nrc ngrde aycngrlrle nrlc, mz zmatq kx xplr. ");
INSERT INTO ntu_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","A' nzmyalz-krm myaszpxle srkau. X zmatq ngrm myaszpxle nzmatqkr natq nrc, murde nim kc tqmnctxlz tqmatq-esz'ngrn. ");
INSERT INTO ntu_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Yawe, Loukxtr scmqng tqvzpe, tqvzpe. X Mangr-nzangiongr nim nztr-zlwz-krde tqyc, tqyc. ");
INSERT INTO ntu_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Yawe, nim Gct kc tqayzlubz mz leplz kxnzvz-rbrng da kxnzalelr. Aelwapxngr zmatq ngrm. ");
INSERT INTO ntu_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Nim kx na-ayzlubz da mz lr nrlc. Ayrplapx kxnzglqlz-lzbqng navz-nqblqle nike nzalelrng. ");
INSERT INTO ntu_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Yawe, bzkq rlr-ngrbzme mz kxdrka'-ngrng Nzabrtz-krdr mz da kxtrka kcng tzalelr. ");
INSERT INTO ntu_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Nzpivxitilr da kxtubq, X nzbilvzlr nzale-krdr alwx. ");
INSERT INTO ntu_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Nzatrkatilr nigr, leplz nemqng, Mz nzaetqti-krbzlr drtqgr. ");
INSERT INTO ntu_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Kxnzetung nznibqtilr olvz kxnzabzong, x doa kxnzbzszng, X lr mrkzbleng kx mnckrng badr. ");
INSERT INTO ntu_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Nzrpilr kx, “Trtxpnzngr nzmckr Yawe nigu. X trycneu mz drtwr Gct rdr da lcng tqaletikung.” ");
INSERT INTO ntu_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","A' nimu kx nardr mqngi, nalalztqmamu bange. ?Myx mzli kx nayrplapx-krlzu-rnamu? ");
INSERT INTO ntu_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","?Mz drtwrmu rpiamu kx Gct kc tqwz-ngrde nradrtqgu x mzku, Nradrtqde ngq x mzte mwi? ");
INSERT INTO ntu_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","X sc tqayrplapxpele lr mrkzbleng. ?Myx kxmule, trtxpnzngr nzayrplapx-kz-krde nimu? X alvztrle leplz amrlx. ?Mz drtwrmu trpnzngr da kx krlzle? ");
INSERT INTO ntu_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Yawe obqplxle nzaokr drtwr leplz, X krlzle kx drtwr kx nzyrlqlr mane. ");
INSERT INTO ntu_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Yawe, namrlzbz mz krkcng tqpnanatiqng, Mz nzalvztr-krm nidr mz loukxtr scm. ");
INSERT INTO ntu_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","X trnarlrpx-ngrnqu nzkxpu-krdr, a' amnc-zpwxq nidr, Vz vz mzli kx ayrkro-ngrn kxdrka'-ngrng mz gq. ");
INSERT INTO ntu_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Yawe, trpxtxpx-ngrnqu leplz nemqng, X tr-rlasz-ngrnqu nigr kcng tqmcpxq. ");
INSERT INTO ntu_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Mzli kc navzm, nzaclvekr kxnzrmailzng sa natubq, X krkcng nabzdr tqlqngi sc tzabrtz-ateng. ");
INSERT INTO ntu_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Yawe, nim txpwz kx tum mz nibrnge, X nim kztenge mz nzarlapx-krbzme ninge mz kxdrka'-ngrng. ");
INSERT INTO ntu_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Nzmu trnaokatrwq ninge, Mzli trnaboiu x ninge kc tqbzpex. ");
INSERT INTO ntu_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","A' mzli kc tqkqle-ngrne nim mz nzkxpu-krnge, Lolvz-amqngiq ninge mz nivz lrm. ");
INSERT INTO ntu_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","X mzli kc tqtalvzongr drtwrnge, Zvz amqtrpe' drtwrnge x abrtz-moux. ");
INSERT INTO ntu_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Px-ngrn nzngi-te-krmu badr kxnzetung kxdrka'-ngrng Mz nzrnzlvzo-krdr loukxtr scm. ");
INSERT INTO ntu_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Murde nzyrlwrpx-lxblr-ngrdr mz nzrpwa'-krdr kxnztubqng, X nzaprc-krdr kxnzmrlzng mz nzrnibqngr. ");
INSERT INTO ntu_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","A' Yawe, Gct rnge, nide lrpalvc nyznge, X butqbr kc tqrlakitrx. ");
INSERT INTO ntu_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Yawe, Gct rgr, sa naodatile nidr mz nqmq krdr kc tqtrka, Mz nzrtxlvzlz-krdr alwx ngrdrng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Nangrbzku mz Yawe mz nzabrtzngr. Murde nide butqbr kc tqrlakitrku. ");
INSERT INTO ntu_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Na-awibzku bade Mz nzngr-kato-krbzku bade mz nabz kxyrlvi! ");
INSERT INTO ntu_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Murde Yawe nide Gct kc tqmyalz-esz'ngr, X King kc tqmyaszlzle kxnzmncng mzlilxlr amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Me boongr yc mz mqde. X nyz-kzde newz kxmyalzng. ");
INSERT INTO ntu_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Prla x drtc' nyzdeng Murde wz-ngrde mz nzngini-krde Kxrpalz. ");
INSERT INTO ntu_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Na-angioku Yawe kc tqwz-ngrde nigu Mz nzyrngzlvzo-krgu nide. ");
INSERT INTO ntu_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Murde nide Gct rgu, x nigu leplz nedeng, Apuku sip kx aclveleng. X naxlramu natqde mzbq ka, Mz nzrpi-krbzle bamu kx, ");
INSERT INTO ntu_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","9","“Bzkq nabzmu mqngipe, da kc tzwailr melrmqmung. Murde kxmule-esz' nzmc-zvzlr nzrkati-krbo da kxmrlzting badr, Mz nzmnc-krdr mrkc lzke, a' otablrkr badr mrkc Meriba, X nzatalzlr ninge mrkc Masa, mz nzxpqbrlr-krdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Mz yiz lcng nzpnu-pwx ngyati zvz ngr drtwrnge nidr. Murde nidr leplz kx nzvz-rbrng mz nabzdr x trnzvz-nqblqlru nqmq krngeng. ");
INSERT INTO ntu_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","X mz nzangya-krmlr drtwrnge, sc tqesalzpex kx, Trtxpnzngr nzprtr-krdr mz nzmnc-zpwxngr kc nakabo badr.” ");
INSERT INTO ntu_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Nigu lr nrlc amrlx Nangr-ngrbzku mz Yawe nabz kxmrna! ");
INSERT INTO ntu_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Na-angrlvzku nide Mz nzyapwxtipx-krgu kx arlapxle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Napipxbzku mz leplz amrlx Da kxmatq x da kxmyapxbz kcng tqaletileng. ");
INSERT INTO ntu_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Takitrde nzrglqlzngr Yawe kc tqmyalz-esz'ngr, Murde nzmrlue-krde namyaszlzle kxnzmncng mzlilxlr amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Lr mrkzbleng nzangio-txpwzlr mqngr da kxnzlz, A' Yawe txpwz kx rwzngr bongavz x nrlc atwrnrngr. ");
INSERT INTO ntu_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Mz nzmncpx-krm Yawe Mangr-nzangiongr, Xngibzku zmrlue, zyzlr, zmatq x zluli rdeng. ");
INSERT INTO ntu_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","8","Napibzku mz lr mrkzbleng kx naglqlz-kzlr nide Mz zmatq, zluli, x zmrlue lcng. Murde takitrde nzale-krgu da lcng, Mz nzrtwz-krmgu da bade mz makoa nyzde. ");
INSERT INTO ntu_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Na-angioku Yawe murde tr-esz'ngr. Na-amrlueku nide x narnrctrpzku bade. ");
INSERT INTO ntu_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Eu, napipxbzku mz neidung amrlx kx Yawe nide King r nrlc, x atu-amqngile nrlc mz trnzycngrlr-krdeu. X sa na-aclvele lr nrlc amrlx mz nzrsakrlrngr. ");
INSERT INTO ntu_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Nimu bongavz x drtc' naelalvzamu nide! X nim prla x dalrmqng amrlx drtwrmu naelalzm! ");
INSERT INTO ntu_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Nimu nardzng x dalrmqng amrlx na-abrtz-kzamu! Nimu nounc ngr peto amrlx na-angrlvz-kzamu Yawe. ");
INSERT INTO ntu_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","Murde sa tqvzm mz nzaclve-krde lr nrlc. X nzayzlu-krbzle da mz leplz amrlx sa namrlz x tubq. ");
INSERT INTO ntu_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Mrlz lr nrlc amrlx nzabrtz-krdr murde Yawe nide King kc tqmyatxlz-esz'ngr. X lr trmctu naelalz-ngrm drtwrdr kz nide. ");
INSERT INTO ntu_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Zbo kxve x nzlo nzngrlelvzlr nide. X nzaclve-krde leplz mrlz x tubq. ");
INSERT INTO ntu_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Nyr rtwayznepx kai mz nzvz-krde, Nyr kx nangcngr enqmi kcng tztulvz-ngrdr nzti rde. ");
INSERT INTO ntu_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Bzlrpc ngrde kx pcpxle pnamilxtile nrlc, X drtc' ycngrlrlzm. ");
INSERT INTO ntu_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Yawe nide Kxetu r nrlc tulvzo. X mz nzmc-krdr nide newzng nzwxong nzapulr nzwxokr gq. ");
INSERT INTO ntu_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Lr Heven amrlx nzpipxlr nztubq-esz'ngr-krde, X lr nrlc amrlx nzmclr nzmyatxlz-zlwz-krde. ");
INSERT INTO ntu_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Krkcng amrlx tzangiolr kx trngiu Yawe Gct angidr, drtqdr la namya zlwz. X kxnzmncng mzlilxlr amrlx nzmu na-angiolr nide. ");
INSERT INTO ntu_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Yawe Gct rgr, nigr lr Jerusalem x lr mztea amrlx ngr nqvi lr Judz abrtz-zlwz-ngrgr nim Nzayrplapx-krm enqmi rgrng. ");
INSERT INTO ntu_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Murde lr nrlc amrlx nzmnclzbzng mz zmatq ngrm, X nzmyalz-zlwz-krm myaszpxle kxnzmncng mzlilxlr amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Nigu kcng tzmrlztilr Yawe napxtxpx-ngrgu da kxtrka. Murde tu-zvzbz mz nibr kxnztubqng mz nzarlapx-krbzle nidr mz mq kxdrka'-ngrng. ");
INSERT INTO ntu_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Yawe amrlzle kxnztubqng, kx nabzdr lqngi. Murde na-abrtzlvzlr nzngini-krde Gct kxtr. ");
INSERT INTO ntu_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Delc, nigu kcng tztubqng na-abrtzlvzku Yawe, Mz nzawi-krbzku bade. ");
INSERT INTO ntu_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Nangr-ngrbzku mz Yawe nabz kxmrna mz nzale-krde da kcng tqmyapxbzng. Murde aovxiole enqmi rdeng mz nzetukr zmatq ngrde. ");
INSERT INTO ntu_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","X sc tqaelwapxpe-ngrbzle nztubq-krde mz lr mrkzbleng amrlx, Mz nzarlapx-krbzle leplz nedeng mz mq enqmi rdrng. ");
INSERT INTO ntu_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","X aodule nigu lr Israel mz nzatutr-zvz-krde natqde. Murde leplz mz nrlc tulvzo nakrlzlr kx arlapxle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Nigu leplz amrlx mz nrlc na-angrlvzku Yawe Mz nabz kx yrlvi. ");
INSERT INTO ntu_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Naglqpxku nide Mz nzayrni-krbzku bade gita, ");
INSERT INTO ntu_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","X mz nzvxu-krbzku trpu. Na-angrlvzku Yawe, kc tqngi King! ");
INSERT INTO ntu_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Nimu prla x drtc' x dalrmung amrlx Drtwrmu naelalzm! ");
INSERT INTO ntu_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Nimu lue na-amqmq-lzbqamu mz nztalio-krmu mz nabzde. X nimu newz na-angrlvzamu Yawe! ");
INSERT INTO ntu_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","Nigu amrlx nangrbzku bade. Murde sa tqvzm mz nzaclve-krde lr nrlc, X nzayzlu-krbzle da mz leplz sa natubq x narsakrlrngr. ");
INSERT INTO ntu_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Yawe nide King, kx myaszlzle enjrl kcng tzmatqng tztu-ngalelvzlr tron nyzde. X leplz amrlx mz nrlc tulvzo narnrcti-lzbqtr-ngrbzlr bade. ");
INSERT INTO ntu_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Yawe matq-esz'ngr Jerusalem. X nzmyalz-esz'ngr-krde myaszpxle lr mrkzbleng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Leplz amrlx naglqlzlr drtqde, Murde nide kc tqtr-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","King kc tqrninr, mrlz-zvzbz bam da kxmrlz. Delc nzaclve-zvz-krm nigr tqtubq-zvz-ngrde x rsakrlrngr. ");
INSERT INTO ntu_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Nayrngzobzku mz nanyc Yawe, Mrkc tqwxbu-ngrde mz tron nyzde. Na-angioku x naglqlzku Gct rgu, Murde nide kc tqtr-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Mosis x Eron nidr pris neng Yawe, x profet Samwel krka'bz bade. Nzyrnitrpzng bade x ayzlubzle natqdr. ");
INSERT INTO ntu_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Ycmnepxm badr mz nabz dcbz, X nzvz-nqblqlr natqde x lou scdeng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Yawe, nim Gct rgr, X ayzlume natqgr, nigr leplz nemqng. Kxmule-esz' ayrplapx-kaiq nigr mz alwx ngrgrng, A' sc tqaelwapxpe-ngrn kx nim Gct kx krlzle nzipq-krde leplz. ");
INSERT INTO ntu_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Naglqlzku Yawe, Gct rgu, mz nzangio-krgu nide mz newz kxtr nyzde, Murde nide kc tqtr-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Nigu leplz amrlx mz nrlc Na-angrlvzku Yawe! ");
INSERT INTO ntu_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Na-angioku x naglqpxku nide Mz nzelalz-krm drtwrgu! ");
INSERT INTO ntu_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Nalxngitiku kx Yawe nide Gct, x nigu leplz nedeng murde wz-ngrde nigu. X apuku sip ngr nardzng nyzde. ");
INSERT INTO ntu_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Mz nzvztr-krgu mz naonrx x makoa ngr Mangr-nzangiongr Yawe, Navz zvz nzawi-krbzku bade x nzangio-kz-krgu nide. ");
INSERT INTO ntu_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Murde Yawe mrlz-esz'ngr. X aodule nigu mz nzatutr-zvz-krde natqde. ");
INSERT INTO ntu_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Nabz ne Devet. Yawe, nangr-ngrbo bam Nabz ngr da kxtubq x nzangidatingr. ");
INSERT INTO ntu_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","X namnc-nqblqx nztubqkr nqmq krm mz nzokatr-krm ninge. X nabznge nalqngi zvz mz nzmnc-krgr badr lr ma nyznge. ");
INSERT INTO ntu_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Tr-rlr-ngrpwc'u nzprtr-krm da kxtrka brma. X pxtxpx-ngrne krkcng tzesablqtilr nim. ");
INSERT INTO ntu_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Delc, nartctx-ngrne nqmq kr kxdrka'-ngrng, X nayrlqpx-lzbqnge mz da kxvz-rbr. ");
INSERT INTO ntu_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Sa narpwa'-ngrbo krkcng tzpikiti-awalr kxnzmnc-aepztrpzng badr. X kxnzglqpx-lzbqng trmrlzu mz nzobq-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","A' kxnzlxngiti-zpwxlr nim nanginidr kztengeng, X kx nabzdr lqngi sa nawztrpqng bange. ");
INSERT INTO ntu_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","A' krkcng tzesabrng x tzpokia-zvzng, Trtxpnzngr nzmnctr-krmlr bange. ");
INSERT INTO ntu_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Murde mz zbq kang kqlu sa nalolvztix kxdrka'-ngrng X namaszlrpx-ngrne nidr mz mzteadau nyzm. ");
INSERT INTO ntu_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Yawe, lalztqm mz nzkrka'-krbo bam. X xlrm nzyrni-krnge mz nzokatr-krm. ");
INSERT INTO ntu_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Mzli ka tqprtz-ngrm nzkxpungr bange, Bzkq mnc-rlrume bange. A' ayzlu-anim natqnge Mz nzkqle-krnge nim. ");
INSERT INTO ntu_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Nrkrdrtqnge nzpq-krde apule nyr. X mzli trnaboiu ninge kc tqbzpex, tqapupex zsikapu kc tqmrbr ani. ");
INSERT INTO ntu_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Nabznge talvzo apupele nabr kxglr, X trmupewxu. ");
INSERT INTO ntu_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Bztipenge nzyrningr mz nzetqkr drtqnge. X nginitxpenge nrvr-nrbalq. ");
INSERT INTO ntu_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Apux nc kx nzrtclzngr mepz, x sc tqtaligxpe, Mz nzmnc-krnge esz'-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Mnzx, a' trkrlzpewxu nzmwingr. Apux ncblo kx trpnzngr kxnginide kx naoklatile nide. ");
INSERT INTO ntu_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Enqmi rngeng nzatrkati-zvzlr ninge mz nzycmne-krdr. Nzpitrpzlr drtqnge mz nzrpibqti-krdr leplz. ");
INSERT INTO ntu_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","Yawe, nzvzkr drtwrnge dekc tqkrlcngr nelznge tqngi dakxnzng nange, X drle mzke' dekc tqngi lue pqnge. ");
INSERT INTO ntu_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","Murde ngyati zlwz drtwrm ninge. X apux brmrda kc tqrtctxpe-ngrn. ");
INSERT INTO ntu_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Nzmnc-krnge apule zmyo ngr milzpq Kc tqmrbr mz nzyrkrpxkr ngrlx. ");
INSERT INTO ntu_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Kxmule-esz', a' nzngini-krm King tqyc tqyc. Nrpr ngr ncblo amrlx sa nadcpx zvz mz drtwrdr nim. ");
INSERT INTO ntu_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Murde sa nayc mz drtwrm Jerusalem. X mzli ka mzli r nzokatrpe-krmle. ");
INSERT INTO ntu_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Kxmule-esz' enqmi rm nzodatipelr mztea lc, x trkape, A' sc tqsutibe drtwrgr x tqvztibe drtwrgr. ");
INSERT INTO ntu_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Yawe, lr mrkzbleng amrlx sa na-amrluelr drtqm. X king amrlx mz nrlc sa na-amatqlr nim. ");
INSERT INTO ntu_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","Murde mzli kc na-aelwapx-ngrn nzlulikr zmatq ngrm, Mz nzwz-mou-krm Jerusalem, ");
INSERT INTO ntu_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Drtwr ngrde kx ayzlu-ngrme nzkrka'-krgr, Nigr kcng trpnzngr scgr da. ");
INSERT INTO ntu_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Nayroku da kcng tqaleting Yawe, Murde krkcng mztr trnzmcka naglqpx-kzlr nide. ");
INSERT INTO ntu_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Kxnamu nzyr-krgule sele: Yawe mnc Heven, Mz ma nyzde kc tqtr tqmyalz, x sc tqobqom mz nrlc. ");
INSERT INTO ntu_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","Xlrle nzyrni-krgu mz presin, X aopxbzle drtqgu, nigu kcng tzpipx kx nanibqng. ");
INSERT INTO ntu_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","22","X xlrpe-kzle nzngrkr leplz ngr mrkcng amrlx Mzli kc tzyrlwr-lxblr-ngrdr Jerusalem, Mz nzangio-krdr nide, X nzglqpx-krdr drtqde. ");
INSERT INTO ntu_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Yawe, ngi-batrpe' nzyangrnga-krnge, Mz nzamrbctr-krme nzlu-krnge, mzli ka tqngi-oblabe-ngrne. ");
INSERT INTO ntu_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","A' rpibo bam kx, “Gct rnge, nzlu-krm tqyc tqyc. Suti drtwrnge nakrlz-zpwxbo nzngi-lrtzlvz-krnge, x ninge kc tqbz-atex. ");
INSERT INTO ntu_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Mzli kc mz noude wz-ngrn nrlc, Bongavz x dalrdeng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Nrlc x bongavz sa nayrkrpxng kalr. A' nim txpwz kx namnctx alo. Mzli trnaboiu x sc tztrkapeng, tzapupelr lrpz kxblzlongr, Kx nzrtctxngr x nztekqtr zvz mz kxmrna. ");
INSERT INTO ntu_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","A' trtxpnzngr nzrtekqtrngr nim. X trtxpnzngr nzbz-krm mz kzdq mzli. ");
INSERT INTO ntu_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Delc doa negrng sa namnc-zpwxng mz nrlc, Murde sa na-aclve-angidrq nidr.” ");
INSERT INTO ntu_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Naglqpxx Yawe mz nabznge atwrnrngr! Naglqpx-zvzx drtqde kxtr. ");
INSERT INTO ntu_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Na-aoti zvz drtwrnge nivz lrde, X da kxmrlz kcng tqalemle bange. ");
INSERT INTO ntu_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Murde katxpxbzle alwx rngeng amrlx. X amrlzle ninge mz zyagox amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Arlapxle ninge mz nzbzngr. Aodu-zvzle ninge. ");
INSERT INTO ntu_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Okatrle ninge mz da kxmrlz Murde nzlu-krnge naboi x nrkrdrtqnge naxplr, mz nzapu-krnge lr. ");
INSERT INTO ntu_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Yawe okatrle kxnzobqszong murde ale-zvzle da kxtubq Mzli kc tqayzlu-ngrbzle da mz leplz. ");
INSERT INTO ntu_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Aelwa-ngrbzle me pnz drtwrde mz Mosis, X zmatq ngrde mz lr Israel. ");
INSERT INTO ntu_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Yawe mrlz-esz'ngr x aodu-zvzle nigu. Drtwrde trngya-aniu, a' okatr-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Trkrlzleu nzaboitr-krmle zngya ngr drtwrde bagu, A' ani txpwz nzipq-mou-krde nigu. ");
INSERT INTO ntu_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Kxmule-esz' takitrde nzayrplapx-zlwz-krde nigu, A' ycngr drtwrde nigu, x trayzlupleu bagu mz nzvz-nqblq-krde nzvz-rbr-krgung. ");
INSERT INTO ntu_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Murde sc tqaodu-zvzpele nigu kcng tzamrluelr nide, Murde nzetu-krm nivz lrde bagu myaszpxle bongavz. ");
INSERT INTO ntu_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","X mz nzipqpx-krbzle alwx rgung, Apule kx rtctx-ngrbzle rlru, me trpengr nzrmc-moungr. ");
INSERT INTO ntu_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","X Yawe amqtrple drtwrgu, Da kc tqwai trte nzamqtr-krbzle drtwr doa nedeng. ");
INSERT INTO ntu_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Dcpx mz drtwrde kx nigu leplz kxtrnzxplrung, Murde wztx-ngrpwzle nigu mz drtc'. ");
INSERT INTO ntu_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","16","X nzlu-krgu mrbcnepwz, Apule nepi kc tqprtzm mz nourla, x tqxplr mzli kc bea. A' sc tqtaope mou milzpq. Murde mzli kc nabzngr leplz trpengr nzrmc-moungr nidr. ");
INSERT INTO ntu_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","18","A' Yawe aodu-zvzle x amrlz-zvzle nigu, Kcng tzamrluelr nide, Mz nzyrlq-angidr-krgu natqde, X mz nzlolvz-amqngi-krgu Nzesz'tikr Drtwrgu badr. ");
INSERT INTO ntu_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","King Yawe wxbu mz tron nyzde Heven, Mrkc tqaclve-ngrde nrlc atwrnrngr. ");
INSERT INTO ntu_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Nimu enjrl kxnzmatq kcng tzvz-nqblqlr natqde, Naglqpxamu nide! ");
INSERT INTO ntu_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","X nimu ami ngr Heven kcng tzwztrpzng bade mz nzatutr-krbzmu me pnz drtwrde, Naglqpx-kzamu nide. ");
INSERT INTO ntu_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","X nigu amrlx mz nrlc tulvzo naglqpx-kzku nide. Naglqpxx Yawe mz nabznge atwrnrngr! ");
INSERT INTO ntu_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","3","Yawe Kxrpalz, naglqpxx nim mz nabznge. Murde nim Gct kc tqluli, tqmyalz-esz'ngr. Nzmyalz-krm x zmatq ngrm nzngrlelvzlr nim nzapulr lrpz kx kq-ngrn. X zyzlr ngrm apule lrpzu scm. Bongavz apule nqni kxetu kc tqprlxpxq. X atuome elr nctrpou ngr ma nyzm. Dcbz apule lika kx lvc-ngrn, Mz nztwz-krde nim nenq kxwq. ");
INSERT INTO ntu_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Zmatq ngrm batrpzle mz enjrl nemqng nzlvc-ani-krdr mz nzapu-krdr nenq. X menrpa lcng tzwztrpzng bam nzapu-kzlr bzlrpc kc tqpctipx. ");
INSERT INTO ntu_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Wztioq nrlc mz nou rplz kxmqngi, Murde trpnzngr nzycngrlr-krde. ");
INSERT INTO ntu_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Mzli kc ayrnrngr, drtc' mrbrobz prla, X newz amrlx akq-atwrnr-ngrde. ");
INSERT INTO ntu_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Zbz mzli kc tqpnanati-ngrn prla sc tqpzneope, Mz nzxlr-krde natqm kc tqapule bzlrmei. ");
INSERT INTO ntu_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Prla pzneom mz nar-newzng, vzo krlzobzle nabzlwang, Vzo mrkc tqyrlqbzme kx nalrlz-ngrmle. ");
INSERT INTO ntu_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","X yrlqbzme bz ngr me naesakingr prla, Murde ma tqakq-atwrnr-mou-ngrde drtc'. ");
INSERT INTO ntu_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Wz-ngrn aulz, nzaulzmqng mz nabzlwa amrlx, Lue lcng nzvzong x lue kxetung nzyrleng mz mzlir newz amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Animol amrlx nzrmnqng lue lcng, Mz nzbrlxkzkr drtwrdr. ");
INSERT INTO ntu_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Utc nzrwzpe-ngrng ma nyzdr x nzngr-zvzng Mz nounc mz nqlvi r lue lcng. ");
INSERT INTO ntu_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Adcme tewa mz ma nyzm bongavz. Dcom mz newz amrlx. X amrlzle drtc' murde kxnzlung kcng tqwz-ngrn namnc-zpwxng. ");
INSERT INTO ntu_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Wz-ngrn nabr x dakxnzng nztuting mz drtc' Nangi nan animol x leplz. ");
INSERT INTO ntu_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","Rkame waen kx na-aelalz-ngrm drtwrgr, X tolo kx na-alqngr nrkrdrtqgr, X dakxnzng kx naxplrngr nigr. ");
INSERT INTO ntu_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Yawe, nounc nyzm kc tqpetiq Nzdo-zlwz-krdr vzpxm mz nzadco-krme tewa badr. ");
INSERT INTO ntu_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","X utc kang kqlu nzmncpxng mz nounc lcng. X nzwzpx-ngrdr ma nyzdr elr. ");
INSERT INTO ntu_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Gout nzmncomqng mz newz, X animol kxnztopwzng nzmnc-kapqneng me rplzngr. ");
INSERT INTO ntu_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Yawe, wz-ngrn temz nangi noabx ngr mzli, X nepi noabx ngr zbq. ");
INSERT INTO ntu_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Nim kx rwzngr nzlo ngr nrlckxbq, Mzli r nzprpx-krm animol kzpeto me nzmnc-ngrdrng. ");
INSERT INTO ntu_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Laion nzyrni-katong mz nzrtangr-krdr dakxnzng Kx nakabzme badr. ");
INSERT INTO ntu_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","A' mzli kc tqprtz-ngrm nepi, Sc tzyzlupeng ma nyzdr, tzmwipeng. ");
INSERT INTO ntu_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","X mz nrlc kxngrlx, leplz nzvzng mz nzale-krdr nzwz-krdr, Nzwzng vz vz krlzbzle milzpq. ");
INSERT INTO ntu_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","Yawe, animol kcng tqwz-ngrn kqlu-esz'ngr. Nrlc ka yrbulzm mz da lcng amrlx tqwz-ngrn mz nzyrplapx-krm. ");
INSERT INTO ntu_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Dcpwe yrlwrlz-ngrm nc kxkqlu x rblx nzrlwx-krgrleng. Kzdu nc lcng nzetuting x kzdu nztopwzneng. ");
INSERT INTO ntu_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Lcsu kxnzkqlung nzvoneng prla. X nc kxbe kc tqwz-ngrn drtqde besilr ayone kz elr. ");
INSERT INTO ntu_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Animol lcng nzmnc-xglelr nim, X rka-zvzbzme nadr dakxnzng. ");
INSERT INTO ntu_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","X mz nzrka-krbzme da kxmrlz badr Amrlz-zvzq nidr. ");
INSERT INTO ntu_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","30","Mzli kc tqrka-ngrbzme zycmini sc tzlupeng, Murde nim Kxrpalz. X ngi-batr-zvzbzme nzlukr animol amrlx mz nrlc. A' mzli kc tqpxtxpx-ngrn nidr, nelzdr vzdzm. Murde mz nzrkatxpx-krbzme zycmini lc, nzbzng. X nzyzlu-moung mz drtc' kc tqwz-ngrn nidr. ");
INSERT INTO ntu_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Nzmyalzkr Yawe navz zvz, X nzabrtzlvz-krde nikeng wz-ngrdeng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Mz nzobqo-krmle, drtc' ycngrlrlzm apule nengq kx vzm, X ngi-batrpzle nzsikapukr trmami mz nzmaletr-krde newzng. ");
INSERT INTO ntu_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Na-angrlvz-zvzx Yawe Gct rnge, Navz nakrlzbzle nzesakikr nzycmini-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Mrlzvxitx Yawe nzabrtzlvz-krde natqngeng mz nzngr-krbo bade, Murde nide kc tqrngi-batr-zvzm nzabrtz-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Mrlzvxitx nznibqti-krde kxdrka'-ngrng Murde nzatrkatilr nrlc kc tqwz-ngrde mz nzpxtxpx-krdr nzglqlz-krdr nide. Yawe naglqpxx nim mz nabznge. Eu. Naglqlz-zvzkr nim. ");
INSERT INTO ntu_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Naglqpxku Yawe, Na-awibzku mz Yawe mz nzmyalz-esz'ngr-krde. X napipxbzku mz lr mrkzbleng da kcng tqaletileng. ");
INSERT INTO ntu_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Na-angrlvzku mz nzangio-krgu nide. X napipxku da kxnzkctipxng kcng tqwz-ngrdeng. ");
INSERT INTO ntu_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Nabilvzku drtqde kxtr. X nigu kcng tzamrluelr nide drtwrgu naelalzm. ");
INSERT INTO ntu_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Namnc-xgleku Yawe x nzxplr-krde. X nasuti drtwrgu nzxngi-krbzku nzulrde. ");
INSERT INTO ntu_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","6","Vzpxmgu mz nqvi lr Ebraam, kxnzawz ne Yawe, X nqvi lr Jekop kc tqmcpxle. Delc nadcpx zvz mz drtwrgu rkx kcng tqmatq tqaleleng, X nztubqkr nqmq krde. ");
INSERT INTO ntu_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Yawe nide Gct rgu. X kapxbzle natqdeng mz leplz amrlx mz nrlc. ");
INSERT INTO ntu_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Nzesz'tikr Drtwrgu badr tqyc tqyc. X trmrbrtru mz drtwrde nzesalz-krde. ");
INSERT INTO ntu_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","Nzesz'tikr Drtwr lc tzyrlq-kailr mz Ebraam. X pipx-kzpzle nzesalz-krde lc mz Aesak. ");
INSERT INTO ntu_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Amqngi-mopwzle mz Jekop x doa nedeng, Murde navz alo. ");
INSERT INTO ntu_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","Rpibzle badr kx, “Sa nakabo bamu drtc' kc Kenan Murde nangi drtc' nyzmu.” ");
INSERT INTO ntu_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","A' nqvi lr ncblo lc tqngi nyz Gct nzpipzbeng mzli lcde, Mz nzngini-krdr lr mrkzbleng kx trpnzngr me nzmqngio-ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","X nzayo-txpwzng Mz nzrlasz-krdr kc mrkzble x nzvzki-mou-krdr mrkzble. ");
INSERT INTO ntu_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","A' Yawe tr-rlrpx-ngrdeu nzaovxiongr nidr, Murde aclvele nidr mz nzlc-amq-krbzle mz king kxnzkqlung, ");
INSERT INTO ntu_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","Mz nzrpi-krbzle badr kx, “Bzkq atrkatibzmu leplz nengeng kx mcpxx. X bzkq aetqbzmu drtq menrpa nenge lcng.” ");
INSERT INTO ntu_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Mz nibr kzdung mzli, Yawe atwzlr-ngrmle dzbi mz drtc' nyz leplz nedeng, X katxpx-kzle dakxnzng nadr amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","A' atwzlr-kai-ngrde kzdq ncblo Ijipt kx nangibz lrpzki badr. Krlcde Josip, mrlx Jekop, kc tzamwalr murde nanginide kxnzawz-nrbalq. ");
INSERT INTO ntu_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","X mz nibrde sc tqmncpxpem mz presin, X nzatolva-ngrdr nide mz nqvi. ");
INSERT INTO ntu_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","Vz vz x natqde sc tqyokaetipxpele nzrmwiblekr king r Ijipt, Mz nzpipx-krde natq angidr kc tqkabz Yawe bade. ");
INSERT INTO ntu_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Zbz king r Ijipt kc tqaclvele mrkcng kqlu, Aopxbzle drtq Josip mz nzkapx-krmlele mz presin. ");
INSERT INTO ntu_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","X sc tqyrlqpele Josip nzngini-krde kxetu elr, Murde na-aclvele dalr Ijipt amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","Zbz Josip rngisc zmatq mz nzrkapx-krbzle natq mz kxnzetung amrlx, X mz nzalvztr-krde ncblo kcng tzyrplapxng. ");
INSERT INTO ntu_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Mz nibrde Jekop badr doa nedeng sc tzvzpeng Ijipt, Mz nzmnc-krdr elr, murde dzbi lc tqtaope mz drtc' nyzdr. ");
INSERT INTO ntu_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Nqvi lr Jekop nzmncting Ijipt trtqki r yiz, x Yawe batrpzle nzkqlunepx-krdr. X nzxplr-krdr myaszpxle lr Ijipt, enqmi rdrng. ");
INSERT INTO ntu_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Delc lr Ijipt tzngyatingr drtwrdr leplz nedeng kcng tzangiolr nide. X sc tzatrkatipelr nidr mz nzawz-nrbalq-krdrleng x sc tznibqtipe-kzpzlr doa ncblo nedrng mzli kc mztr tzmc-ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Delc Yawe tqatwzlr-ngrbzle Mosis kxnzawz nede, Nidr mz Eron kc tqmcpxle, murde naokatrlr leplz nedeng Ijipt. ");
INSERT INTO ntu_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","X sc tzale-ngrdr rkx ngr Gct kxmatq kxkqlu elr, Mz nzngi-batr-krbzle nzrwzngr da kxnzkctipxng mz mqdr x mz natqdr. ");
INSERT INTO ntu_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Awx-nzlo-ngrbz Yawe mrnyzdr, A' natqde trnzvz-nqblqpwzlru lr Ijipt. ");
INSERT INTO ntu_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Ngi-batrpzle nzlrtipxkr lue nyzdrng mepyr X nzbztingr nc nedrng. ");
INSERT INTO ntu_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Drtc' atwrnrngr yrbuti mz frck, X nznulvzpx-kzplr ma nyz king. ");
INSERT INTO ntu_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Yawe kapxle natqde X mc badr mclrla nzyrkrpx-pnz-ngrng nrlarnrlc nyzdr. ");
INSERT INTO ntu_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Atwzlr-ngrmle muli-aes apule tewa kxdc, X bzlrpc tqpctipx zlwz mrnyzdr. ");
INSERT INTO ntu_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Odatile nqvi lr dakxnzng mz nrlanc nyzdr X plameitio-kzle nounc nyzdr amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Yawe kapxle natqde X blzmr kionabr kx rblx nzrlwxngr nzlvcmqng. ");
INSERT INTO ntu_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Nzngqtilr dakxnzng kxnzpeting Mz nrlanc nyzdr amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Zbz Yawe sc tqnibqtipe-kzle doa ncblo kx ayrnrngr Mz ma nyz lr Ijipt amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Mz nibrde sc tqmailzpele lr Israel mz nzrlasz-krdr Ijipt, nzrtwzng silvz x gol. X trpnzngr nidr kxnzyagoxng, a' nzxplrng. ");
INSERT INTO ntu_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","X lr Ijipt nzabrtzlvzlr nzrlasz-krdr nidr. Murde nzmwxlrtilr da kx naprtzbz badr mz nzlolvz-mou-krdrleng. ");
INSERT INTO ntu_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Yawe yrlqbzle dcbz ngrlx murde navz-nqblq leplz nedeng, X mz nrlckxbq yrlq-kzpzle nyr nayzlrbz badr. ");
INSERT INTO ntu_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Nzrlxbzng bade dakxnzng x atwzlro-ngrmle kio kxkqlu X dakxnzng kxkqlu kx nakrlcngr nelzdr. ");
INSERT INTO ntu_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Ayrlepxmle lue mz kzdq rplz kxetu, X lue lc yrle lzke apule lue kxvo. ");
INSERT INTO ntu_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Delc Yawe sc tqyc-zvzngr mz drtwrde natqde kxtr Kc tqpibzle mz kxnzawz nede, Ebraam. ");
INSERT INTO ntu_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Zbz sc tqmailzpxpele leplz nedeng kcng tqmcpxle, X nzngr-zvzng x nzmalq-zvz-kzng mz nzabrtz-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Kabzle drtc' ngr lr mrkzbleng mz leplz nedeng, X nztwz-kzlr nrlanc nyzdrng x da amrlx kx nzvzpxmqng mz nzwz-krdrng. ");
INSERT INTO ntu_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","Murde leplz nedeng navz-nqblqlr loukxtr scdeng X nayrlq-angidrlr natqdeng. Naglqpxku Yawe. ");
INSERT INTO ntu_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Naglqpxku Yawe! Murde aodu-zvzle nigu. Awi-ngrbzku bade nzmrlz-esz'ngr-krde. ");
INSERT INTO ntu_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Trpnzngr leplz kx rkrlz nzrpipx-angidrngr rkx amrlx kcng tqwz-ngrde, X nzrglqlzngr amrlx trkrlzpxpwzleu nzmyalz-esz'ngr-krde. ");
INSERT INTO ntu_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Yawe, natqm rpile kx sa namrlzbz mz leplz kcng tzaleng da kxtubq, X trpnzngr da kxtrka mz nzao-krdr drtwrdr. ");
INSERT INTO ntu_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Nadcpxngr mz drtwrm ninge, mzli kc naokatr-ngrn leplz nemqng, X aprtr-kzpz ninge badr, mzli kc na-arlapx-ngrn nidr. ");
INSERT INTO ntu_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","Murde na-axvctr-kzpo badr mz nzamnc-zpwx-krm nidr, X mz nzabrtz-krdr x nzbilvz-krdr nzngini-krdr leplz nemqng. ");
INSERT INTO ntu_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","A' axvctr-lzbq-kzpzkr mz melrmqgrng mz alwx ngrdrng. X vz-nqblq-kzkr nzvz-rbr-krdr mz da kxtrka. ");
INSERT INTO ntu_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Mzli kc tzmncngr melrmqgrng Ijipt, Trnzkrlz-zpwxlru rkx kcng tqaletiqng, X trnzaotiu drtwrdr nzwrde kcng kqlu tqaelwa-ngrbzme nivz lrm badr. X mrkc Prla Bla nzrnzlvzolr nim kc tqmyalz-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Kxmule-esz', a' arlapxq nidr mz nzvz-nqblq-krde nzesalz-krm. Murde na-aelwapx-ngrn nzmyapxkr zmatq ngrm. ");
INSERT INTO ntu_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Lclvzq Prla Bla x sc tqakipx-lzbqpe x noude pzlz-kzp. X sc tqmailzpeq leplz nemqng elr. ");
INSERT INTO ntu_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Arlapxq nidr mz nzaopx-krbzme drtqdr mz mq lr Ijipt, Enqmi rdr kcng tzpxtxpx-ngrdr nidr. ");
INSERT INTO ntu_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","A' prla yrle-etr mou x akq-pnzle enqmi rdrng, X trpnzngr nidr kx rlapx. ");
INSERT INTO ntu_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Mzli lcpe sc tzlxngiti ate leplz nemqng natqmqng, X sc tzngrpeng mz nzglqlz-krdr nim. ");
INSERT INTO ntu_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","A' mzli trboiu sc tqmrbrtrpe mz drtwrdr nikeng aletiq, Mz nzvz-nqblq-kai-krdr me pnz drtwrdr x nim kc ate. ");
INSERT INTO ntu_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Mzli kc tzmnc-ngrdr lzke nzabzlr nim, Mz nzrlx-krbzlr ncvr animol, murde drtwrdr rblx nzesapx-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","X kabzme badr da kc tzsuti drtwrdr, Vzmi zyagox kxtrka mz nzayrplapx-krm nidr. ");
INSERT INTO ntu_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Mzli lcng li kzdung ncblo tzrnzlvzolr Mosis, Ncdr Eron kc tqngi kxnzawz kxtr nem. ");
INSERT INTO ntu_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Zbz drtc' glqwi x lvxpx-lzbq mz nzyrtzmq-amrna-krde kxnzrmailz lcng, Datan ncdr Abiram, nidr badr lr ma nyzdr x kztedrng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","X atwzlr-kz-ngrpe' nyr mz kzdq ncblo x kxdrka'ngr kc-kzng tzvz-nqblqlr nide, X nzngcting amrlx ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","X mz nou Newz Saenae nzwz-ngrdr mz gol kc mqngr kzu. X sc tzangiopelr nide. ");
INSERT INTO ntu_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Nztekqtrlr nzangio-krdr Kxrpalz kc tqmyalz, tqrwzngr kzu amrlx, Mz nzangio-alzu-krdr mqngr kzu kc tzwz-ngrdr esz'-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","22","Trycneu mz drtwrdr nim kc tqarlapxle nidr. Tqrtrngzbz rkx kxmatq mrkc Ijipt, Tqwz-ngrde da kcng tqmrlzvxing elr, X tqalele da kcng tzkctipxng mrkc Prla Bla. ");
INSERT INTO ntu_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Delc tqrpipe-ngrn kx naodatipeq leplz nemqng. A' Mosis kc tqmcpxq, awxobzle zngya ngr drtwrm, x trodatiwq nidr. ");
INSERT INTO ntu_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","A' mz nibrde nzpxtxpx-ngrdr nzprtrngr mz drtc' kxmrlz kc tqkabzme badr, Murde nzmwxlr-zlwzng x trnzlxngitilru nzesalz-krm. ");
INSERT INTO ntu_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Nzmnc-txpwzng lzke x drtwrdr lctrpz mz kztedrng mz nzlitr-krbz drtwrdr bam. X trnzvz-nqblqlru nim. ");
INSERT INTO ntu_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Zbz sc tqesalzpebzme badr Kx sa nanibqtiq nidr lzke. ");
INSERT INTO ntu_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","X sa nangi-batrpzme mz doa nedrng nzakitikr nrlc nidr, Mz nzmnc-krdr badr kxtrnzrlxngitiung x nabztineng mrkzbleng. ");
INSERT INTO ntu_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Zbz mz Newz Peo, leplz nemqng nzprtr-kzpzng mz nzangio-krdr gct kc drtqde Baal. X nzmu-kzng blz krde, kxmule-esz' nide gct kxbz kxnzlz. ");
INSERT INTO ntu_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Delc tqngyatingr drtwrm nidr X sc tqdwatipebz zyagox kx nabz-ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","A' Finizs twzpele zmatq x nibqle doa kcng li tqvzkipxm nzkxpungr, X zyagox kc sc tqayrkrpxpeq. ");
INSERT INTO ntu_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Nzwzkr Finizs lc tubq mz nzobq-krm. X nzryapwxtipxngr nide trpnzngr nzmrbr-krde. ");
INSERT INTO ntu_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","33","Mz aulz ngr Meriba, nzangyati-kzpzlr drtwrm. X da kcng tzalelrng atalvzobzle drtwr Mosis, X sc tqvz-rbrpe mz nzycmne-ani-krde. Delc tr-rlr-ngrpwzmeu nzprtr-krde mz drtc' nyzm, X nzkxpu-krde lc vzpxm mz natq kc tqpibzle Mz leplz lcng nardr tqmqngi. ");
INSERT INTO ntu_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Mz nzprtrkr leplz nemqng mz drtc' nyzm Pibzme badr kx nanibqtilr lr Kenan kcng tzmncng elr. A' nzpxtxpx-ngrdr nzvz-nqblq-krdr natqm, Mz nzrlr-krbzlr nzrlapx-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","X nzyrlz-etrng badr kxnzmnc-mrbrng, X nztwzlr nqmq krdrng. ");
INSERT INTO ntu_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Nzangiolr mqngr drka' rdr. X krlc lrpzki r nzodatingr nidr. ");
INSERT INTO ntu_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","38","Nzrlr-ngrbzlr doa ncblo x doa olvz nedrng Nzngini-krdr blz kx nzkabz mz mqngr drka' kxnzlz lr Kenan. X mz nzpulio-krdr mepyr ngr doa nedrng kxnzmrlzng, Nzatrkati-zlwz-ngrdr drtc' kc tqkabzme badr. ");
INSERT INTO ntu_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","X nzatrkati-lzbq-kzng mz da lc tzalelr, Mz nzapusr-lzbq-krdr olvz kc tqrlaszle krnalzde. ");
INSERT INTO ntu_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Mz nzmu-krde lcde, sc tqngyatipe drtwrm leplz nemqng, X pxtxpx-ngrn nidr. ");
INSERT INTO ntu_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Rlrpx-ngrn nzaovxiokr kxnzmnc-mrbrng nidr, Murde na-aclvepeng enqmi rdrng. ");
INSERT INTO ntu_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","X enqmi lcng nzayrplatipxlr nidr, Mz nzmnclz-krbzlr badr. ");
INSERT INTO ntu_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Nzwrde kqlu kx arlapx-ngrn nidr, A' sc tqsuti zvz drtwrdr nzmncngr kx na-atrkatingr nim. ");
INSERT INTO ntu_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","A' mzli kc tzyrni-ngrbzlr bam, xlrbzme natqdr. X vztitx drtwrm nidr murde nzkxpu-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","Leplz lcng nemqng, dekc tqycngr mz drtwrm Nzesz'tikr Drtwrmu Badr, X trayrplapx-zvzwq nidr, murde aodu-zvz-kzq nidr. ");
INSERT INTO ntu_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","X ngi-batrpzme nzyckr mz drtwr enqmi rdr Kcng tzaovxiolr nidr. ");
INSERT INTO ntu_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","Yawe, Gct rgr, arlapx nigr mz mq kxtrnzrlxngitiung, Mz nzvzmi-kr-mope' nigr mz drtc' nyzgr. Murde na-awibzkr bam X naglqlzkr drtqm kxtr. ");
INSERT INTO ntu_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Naglqlzku Yawe, Gct rgu, nigu lr Israel, Tqvzpe, tqvzpe. Naglqlzku Yawe. Leplz narpilr kx, “Eu, angida!” Naglqpxku Yawe. ");
INSERT INTO ntu_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Na-awi-ngrbzku mz Yawe nzmrlz-esz'ngr-krde. Murde aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Naglqlz-zvzku nide, Murde arlapxbzle nigu mz mq enqmi rgung, ");
INSERT INTO ntu_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","Mz nzkapx-krmle nigu mrkzbleng mz nrlc tulvzo. Murde nayrlwr-lxblrku mz drtc' nyzde. ");
INSERT INTO ntu_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Kzdung nigu nzayoneng lzke, Me trpnzngr lrpzki kx narmcti-ngrdr mztea kx namnc-ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Kztegu lcng nzbrtale-zlwzng, nzbrlxkz-zlwzng, X mztr tclvrting. ");
INSERT INTO ntu_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Zbz sc tzkqlepelr Yawe, Kc tqkatxpxpebzle nzkxpu-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Mailzle nidr mz lrpzki kxtubq, Vz, vz nzkrlzbzlr mztea kx namnc-zpwx-ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","9","Rkabz lue mz kxnzbrlxkzng, X dakxnzng kxmrlzting mz kxnzbrtaleng. “Awi Yawe, mz nivz lrm kc tqyc tqyc, eu. Okatr-zvzq nigr. Awi Yawe, mz nivz lrm.” ");
INSERT INTO ntu_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Kzdung nigu nzatolva-ngrng mz presin, Mz nzmncpx-krmlr me tungr nzlo. ");
INSERT INTO ntu_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","Murde nzrnzlvzolr lou sc Gct kc tqmyatxlz-esz'ngr, X drtqdr sa kz nzrlolvzngr nzalvztr-krdeng. ");
INSERT INTO ntu_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Delc tqngi-batr-ngrbzle nzetqkr drtqdr mz nzwz-kato-krdr. X nzyangrngapeng, a' trpnzngr kx naokatrle nidr. ");
INSERT INTO ntu_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Zbz sc tzkqlepelr Yawe, Kc tqkatxpxpebzle nzkxpu-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Aopxbzle drtqdr mz da kc tzatolva-ngrdr, X vzmipxmleng mz nabz nzlo mz zyzlr. ");
INSERT INTO ntu_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","16","Zmatq ngrde myaszpxle naonrx ngr presin, Mz nzodati-atwrnr-krdele. “Awi Yawe, mz nivz lrm kc tqyc tqyc, eu. Okatr-zvzq nigr. Awi Yawe, mz nivz lrm.” ");
INSERT INTO ntu_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Kzdung nigu nzpxtxpx-ngrdr Yawe mz nzngqngu-krdr, X ayrplapxle nidr mz alwx ngrdrng mz nzbatr-krbzle nzyagox-zlwz-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Mzli lc nzpxpe-ngrdr nzmungr, X nabzpeng. ");
INSERT INTO ntu_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Zbz sc tzkqlepelr Yawe, Kc tqkatxpxpebzle nzkxpu-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Yawe amrlzle nrkrdrtqdr mz zyagox lcng mz nzycmnetx-krpwzle. Delc tzrlapx-ngrdr mz nzbzngr. ");
INSERT INTO ntu_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","“Awi Yawe, mz nivz lrm kc tqyc tqyc, eu. Okatr-zvzq nigr. Awi Yawe, mz nivz lrm. ");
INSERT INTO ntu_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Abrtz-zlwz-ngrgr nim nzkatxpx-krbzme Nzkxpu-krgrngq. Abrtz-zlwz-ngrgr nim. Naglqpx-zvzkr nim mz nzngr-krgr nabz, X mz nzale-krgr blz. Naglqpx-zvzkr nim.” ");
INSERT INTO ntu_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Kzdung nigu nzalilvcneng mz lcsu prla, Murde nzrtrngztibzlr nzmabz-krdr elr. ");
INSERT INTO ntu_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Kztegu lcng nzmclr zmatq ngr Yawe, Mz da kx aleting dcpwe. ");
INSERT INTO ntu_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Mzli kc tqycmneti-ngrdr nenq, x trlipu r nenq kc tqwqpe. X batrpzle nzvzdz-krm ebio wq. ");
INSERT INTO ntu_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Ebio lc glqtxlzle lcsu scdr wq. X twzo-moule mrbrobz mz mzlirdr mz kztedeng. Trlipu lc avzdzmle nelzdr x alibzle drtwrdr. ");
INSERT INTO ntu_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Dea-ngrdr tqvzne x nztaneng nzapulr ncblo kxnzrmnqng. X trpengr da kx nakrlzlr kx nartrngztibzlr. ");
INSERT INTO ntu_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Zbz sc tzkqlepelr Yawe, Kc tqkatxpxpebzle nzkxpu-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Ycmnebz mz nenq x sc tqamaope, Mz ebio x nrwx kc tqvope. ");
INSERT INTO ntu_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Kztegu lcng nzabrtztx-zlwz-ngrdr nzvopekr nrwx, X sc tqmailztrpeng Gct mz nabzn kc naokitrlr. ");
INSERT INTO ntu_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","“Awi Yawe, mz nivz lrm kc tqyc tqyc, eu. Okatr-zvzq nigr. Awi Yawe, mz nivz lrm. ");
INSERT INTO ntu_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Napipxbzkr nimq mz mz lrtzlvzng, X mz leplz amrlx. Napipxbzkr nimq.” ");
INSERT INTO ntu_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Yawe apztx-atwrnr-ngrde lue kxnzetuting, X aesakile nzyrlelz-krm aulzng, ");
INSERT INTO ntu_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","X apiz-kzle drtc' murde trpnzngr da kx nalvcpu mrlcde, Mz nzayrplapx-krde kxdrka'-ngrng kcng tzmncng elr. ");
INSERT INTO ntu_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","A' me ngi drta'ngr ngi nabzdeng kx lrngr lue, X drtc' kx mingrting yrlelz-ngrm aulzng. ");
INSERT INTO ntu_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Murde navzmimle melrmqgung kxnzbrtaleng namncng mrlcde, Mz nzwz-krdr mztea nyzdr kx namnc-ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Nzrwz-ngrng nrlanc x nzpetilr nounc, X nzrnginanqng dakxnzng x nranc kxkqlu. ");
INSERT INTO ntu_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Amrlz-zvzle nidr x ngi-batrpzle nzrmika-krdr doa kxkqlu, X nzkqlunepxkr animol nedrng. ");
INSERT INTO ntu_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Mzli kznike leplz nzobqszo-ngrdr nigu Mz nzatalvzo-krbzlr drtwrgu x nzaetq-zlwz-krbzlr drtqgu, ");
INSERT INTO ntu_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","Gct kc tqobqszo-ngrde kxnzetung kxnzglqpx-lzbqng, X batrpzle nzayone-krdr nzapulr kx trpnzngr me tutrngr nzvzne-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","A' katxpxbzle nzkxpu-krgu, nigu leplz txneng, X aclvele nigu mz nzapu-krgu sip nedeng. ");
INSERT INTO ntu_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Kxnztubqng nzmclr nqmq krde x nzabrtz-zlwz-ngrdr. A' kxdrka'-ngrng nzwx-nabu-txpwzng. ");
INSERT INTO ntu_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Krkcng tzyrplapxng nakrlzlr da lcng Mz nzaotikr drtwrdr nzetukr nzaodukr Yawe nigu. ");
INSERT INTO ntu_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","2","Nabz ne Devet. Sa na-angrlvzx nim mz nabznge atwrnrngr mz nzayrni-krbo gita bam, Murde abrtr-zvzbo drtwrnge bam. Nilz r nepi adwalzmle ninge mz zbq kang kqlu. A' mz nzdwalz-krmc mz nourla kx topwz, Na-apule nabz nenge adwalzmle nepi, Mzli lc tqglqlzpex nim. ");
INSERT INTO ntu_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Yawe, sa na-awibo bam mz mzlir lr mrkzbleng, X na-angrlvzx nim mz mzlir neidung. ");
INSERT INTO ntu_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Murde nzaodu-zvz-krm myalz krlzlzle bongavz, X nzangidati-zvz-krm natqm. ");
INSERT INTO ntu_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Lr Heven namclr nzmyalz-esz'ngr-krm, X lr nrlc namclr nzaovxio-krm. ");
INSERT INTO ntu_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Mz zmatq ngrm, arlapx nigr kcng tqaodu-zvzq, X ayzlu-ngrme natqgr. ");
INSERT INTO ntu_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Gct, natqmqng nzvzpxmqng mz Mangr-nzangiongr, mz nzrpi-krdr kx, “Mzli kc na-aovxio-ngrne, sa na-akipxbo mz leplz nengeng Drtc' kcng mz nrlar LueJodzn rlilr. ");
INSERT INTO ntu_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Murde neidu lr Gilead nengeng. X nqvi lr Manase nenge-kzng. X neidu lr Efrem tum mz nibrnge. X nqvi lr Judz kx na-aclve-zvzng mz zmatq rnge. ");
INSERT INTO ntu_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","A' enqmi rmung trna-aovxiolru nimu. Murde lr Moab sa nawztrpqng bange X lr Edom sa nametxmqng bange. X sa namalqlvzx nzmilxtxo-krnge lr Filistia.” ");
INSERT INTO ntu_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","?Gct, sa na-atutrq natqm lc mz nzokatr-krm ninge, Nzprtr-krnge mz lrpalvc ngr mzteadau nyzdr lr Edom? ");
INSERT INTO ntu_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Murde mzli kc axtxpeq nigr, X trokatrwq ami negr mz nzotangr. ");
INSERT INTO ntu_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Gct, okatrp nigr mz nzota-krgr badr enqmi rgrng mzli ka. Murde mane nzmnc-xgle-krgr ncblo nzarlapx-krdr nigr. ");
INSERT INTO ntu_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","X krlzkr kx mz nzmnc-krme bagr, Sa narnzlvzokr enqmi rgrng mz nzokatr-krm. ");
INSERT INTO ntu_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Nabz ne Devet. Gct, glqlz-zvzx nim. Bzkq anabume bange x obqlvz-txpwzme ninge. ");
INSERT INTO ntu_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","Murde kxdrka'-ngrng kxnzesabrng nzycmnetr-ngrdr ninge Mz nzpokiatitr-krdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Nzatrkati-krdr ninge trpnzngr noude, A' nzrpiting natq kx trmrlzu. ");
INSERT INTO ntu_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Kxmule-esz' aodux x krka'-ngrneng nidr, A' nzayzlu-alzuplr mz natq ngr nzpokiangr. ");
INSERT INTO ntu_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Kxmule-esz' alebo badr da kxmrlzting mz nzngini-krnge kztedr, A' nzale-alzupqng bange da kxtrka mz nzapu-krdr enqmi rngeng. ");
INSERT INTO ntu_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Yawe, suti drtwrnge kx na-ayrplapxq ncblo kc tqycmne-atrkatile ninge Mz nzvz-nqblq-krde natqnge kcng napibo bam mz nzngini-krnge kxnzawz nem. Mzli kc navz-ngrde mz kot, kzdq kxdrka'ngr natubz mz nibrde, X mrlz kzdq enqmi rde nanginide majzstret. ");
INSERT INTO ntu_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Bzkq rlr-ngrbzme nzaovxio-krde, A' nzkrka'-krde na-aelwapx-ngrde nzvz-rbr-krde. ");
INSERT INTO ntu_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Bzkq amrlzq nide, a' nabz ani, X natekqtr ncblo kzble mz nzngini-krde kxrmailz. ");
INSERT INTO ntu_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Nabzsz-kzle doa nedeng x olvz rde, Murde trpengr kx na-aclve-angidrle nidr. ");
INSERT INTO ntu_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Naodatitxde ma nyz doa nedeng, Murde navztxneng mz nzrlx-krdr dakxnzng. ");
INSERT INTO ntu_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Mz nzrka-niwzlr-krdr trau kx rlxti trtedr, nayrkrtxpxngr dztudrng amrlx. X lr mrkzbleng napnatibzlr da kx atatrple mz nzwz-krde. ");
INSERT INTO ntu_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Bzkq kx nivz lrde mrlzbz bade, X bzkq kx ycngr drtwrde doa nedeng. ");
INSERT INTO ntu_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Nabzng badr lr ma nyzdeng amrlx, Murde bzkq kx nardctipx mou drtwr nqvi lrde. ");
INSERT INTO ntu_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Nadcpx mz drtwrm nqmq kr melrmqdeng kc tqtrka, X bzkq ipqpxq alwx ngr lxede. ");
INSERT INTO ntu_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Mrkc Heven nadcpx zvz mz drtwrm alwx ngrdrng, A' mz nrlc enqmi lcng namrbrtr alo mz drtwr. ");
INSERT INTO ntu_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Rlxtibo bam da lcng murde mrlx lc trpnzngr kx mrlzti nivz lrde, A' armzkiti x rnibqti leplz txneng kxtrnzrngiscung x kx drtwrdr talvzo zlwz. ");
INSERT INTO ntu_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Mrlzbz bade nzpilz-zvz-krde leplz. Delc mrlzvxitx na-ayzlu-mou-ngrbz bade nzpilz-krdeng. X pxtxpx-ngrde nzale-krbzle da kxmrlz mz leplz. Delc tqpxtxpx-ngrne nzrka-ngrbz da kxmrlz bade. ");
INSERT INTO ntu_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Tresakiu nzpilz-krde leplz. Delc nzayzlu-krbzmeleng bade naxngitx-pnzbzle. Mrlz nzpilz-krm nide na-apule lue kx mingrtr mz nrkrdrtqde, X tolo kx na-alqtipwzle me xvcngr nrvr ngrde. ");
INSERT INTO ntu_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","X na-apu-kzle lrpz kc tqkq-ngrde X amqngitr nrkalo. ");
INSERT INTO ntu_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","21","Yawe, Kxetu rnge, kxmule-esz' rlxtibo bam nzayrplapx-krm enqmi rngeng Kcng tzpibqtilr ninge, A' rlxti-kzpo bam nzamrlz-krm ninge x nzokatr-krm ninge mz nzvz-nqblq-krde Natqm. X arlapx ninge mz nzvz-nqblq-krde nzmrlzkr nzaodu-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Murde ninge ncblo txne kx tr-rngiscu, X drtwrnge vztx zlwz. ");
INSERT INTO ntu_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","24","Nrkrdrtqnge ngi nrvr-nrbalqpe mz trnzmupe-krpwc'u, Mz nzapu-krnge zmyo ngr milzpq kc namrbr-anipe. X apunepe-kzx br kc tqlvcne tqwqplxne nenq, Mz nzyangrnga-zlwz-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Kx nzmc ninge nzyrpalelvzlr ninge, X nzmcpxmlr nctqdr bange. ");
INSERT INTO ntu_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Yawe, Gct rnge, okatrp ninge, kxnzawz nem! Arlapx ninge mz nzvz-nqblq-krde nzaodu-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Murde enqmi rngeng nakrlz-zpwxlr kx arlapxq ninge Mz zmatq ngrm kx xplr-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Yawe, kxmule-esz' enqmi rngeng nzpibqtilr ninge, a' amrlz ninge, X aovxio nidr murde nabilvzx nim. ");
INSERT INTO ntu_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Batrpz nzavzo-lzbq-krdr, Murde nzamyati-krbzme drtqdr naopx mz mz leplz. ");
INSERT INTO ntu_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Yawe, sa na-awi-zlwzbo bam, Mz nzglqlz-krnge nim mz mzlir leplz nemqng. ");
INSERT INTO ntu_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Murde nim kc tqtubz mz nibr ncblo txne, Mz nzarlapx-krm nide mz mq kxnzabetitrlr nide, murde nabz-ngrde. ");
INSERT INTO ntu_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Nabz ne Devet. Yawe rpibzle mz King kc tqngi Kxetu rnge kx, “Wxbu mrlc tqmatq-esz'ngr mz nrlarnge kxrtc, Navz nakrlz-zpwxbzle mzli kc nangi-batr-ngrbo mz enqmi rmqng nzmetx-krbzlr bam.” ");
INSERT INTO ntu_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Murde Yawe sa nangi-batr-kzpzle nzetunepxkr zmatq ngrm mz nzvzpx-krme Jerusalem, Mz nzaovxio-krm enqmi lcng. ");
INSERT INTO ntu_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","X mzli lcde, drtq leplz nemqng sa navq zlwz nzprtr-krbzlr mz ami nem, Murde namailzq nidr mz zmatq ngrm kc tqluli, tqtr. X obla nemqng sa navzmqng naprtr-kzpzng bam mz nzaxplr-mou-krdr ami nem. Na-apubzlr badr mi kc tqvzom mz nzrka-krbzle nzlungr kxmrna mz nabr. ");
INSERT INTO ntu_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","X Yawe esalz-ngrde drtqde x trnatekqtrleu drtwrde. Rpile kx, “Nim King nenge, nangini-alo-kzp pris mz nzvz-nqblq-krde nzwzkr Melkesidek.” ");
INSERT INTO ntu_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","X Yawe sa natubz mz nibrm, Mz nzmilxtxo-krde king kxnzkqlung mz zngya ngr drtwrde. ");
INSERT INTO ntu_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","X sa na-ayrplapxle lr mrkzbleng mz nznibqti-krde nidr amrlx. X sa na-aovxio-atwrnr-ngrde king rdrng mz nrlc tulvzo. ");
INSERT INTO ntu_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","X nim, King rnge, mz nzvz-krm lc, nzxplr-kato-krm sa namatqnepx kz. X sa na-aovxio-atwrnr-ngrn nrlc. ");
INSERT INTO ntu_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Awi Yawe! Glqpxku Yawe! Bilvzx nide mz nabznge atwrnrngr, mz nzyrlwr-lxblr-krgr badr leplz nedeng. ");
INSERT INTO ntu_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Clvele nrlc x da kcng tqwz-ngrde, tqaletileng nzmyalzng. Delc, leplz amrlx na-aotingr drtwrdr da lcng mz nzabrtzlvz-krdrleng. ");
INSERT INTO ntu_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Eu, da lcng amrlx nzaelwapx-ngrdr zmrlue x zmatq rde. Glqpxku nztubq-krde kc tqvzpe tqvzpe. ");
INSERT INTO ntu_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Ipqle nigu mz zmrlz ngrde kxmyalz x ycngr drtwrde nigu. Jzsle nigu x nayc zvz mz drtwrgu rkx ngrdeng. ");
INSERT INTO ntu_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Kabzle dakxnzng mz leplz kcng tzamrluelr nide. Lolvz-amqngile mz drtwrde da kx esalz-ngrbzle badr. ");
INSERT INTO ntu_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Mz nzaprc-krbzle drtc' ngr lr mrkzbleng mz doa nedeng, Nide kc tqaelwapx-ngrbzle zmatq rde badr. ");
INSERT INTO ntu_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Okatrle nidr mz nzaclve-krdeng kxtubq. Prlxpx-zvzle da angidr x nzrsakrlrngr. ");
INSERT INTO ntu_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Rkapx zvz natq kx rsakrlrngr. Sa na-atutrleng murde nqmq krde mrlz x tubq. ");
INSERT INTO ntu_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","10","Takitrde nzangio-krgu drtqde kxtr mz nzamrluengr murde Vz-nqblq-zvzle nzesalz-krde x Witi nelzde nzarlapx-krde leplz nedeng. X aelwapx-ngrgu nzyrplapx-krgu mz nzamrlue-krgu nide. Yawe kabzle nzrkrlz-angidrngr mz krkcng tzyrlq-angidrlr natqde. Zbq kalvz nzrglqpxngr nide navz zvz x tqvzpe, tqvzpe. ");
INSERT INTO ntu_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Awibzku mz Yawe! Murde amrlzle ncblo kx Bilvzle natqde x amrluele nide. ");
INSERT INTO ntu_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Clvele mrnyzde kcng naxplrng mz nzaclve-krdr. Doa nedeng kxnztubqng, sa na-amrlz Gct. ");
INSERT INTO ntu_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Esalz-ngrbz Gct bade da kxmrlzting kxkqlu. Gct okatrle nide murde natubq. ");
INSERT INTO ntu_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Ipq ncblo lc kztedeng mz nzvz-nqblq-krde zmrlz ngrde, nzryckr drtwrde, x nztubq-krde. Jzsle da kx naokatrle leplz kc-kzng, mz nzngini-krbzle lrpzki badr. ");
INSERT INTO ntu_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Kabzle da kxkqlu mz krkcng trnzrngiscung. Lalztqbzle mz Gct x alele da kx rsakrlrngr mz nzwz-krde. ");
INSERT INTO ntu_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Murde ncblo kxtubq kxtr-rnrcti-lzbqu Nadcpx zvz mz drtwr leplz. ");
INSERT INTO ntu_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Obqtipx-zvzle Yawe x Prlxpxle kx nabzde trtaprlzpuu mz nrpa kxtrka. ");
INSERT INTO ntu_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","?Rnrcti-lzbq-ngrde? Trtingr, a' tu-amqngile. Sa namcle nzaovxiokr Yawe enqmi rdeng. ");
INSERT INTO ntu_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Tresakiu nzrka-krbzle da mz kxrsuti drtwr. Vz zvz nzayzlu-krbz Gct bade mz nqmq krde lc tqtubq. Wxbu me matq mz mzlir leplz. ");
INSERT INTO ntu_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","X angya drtwr kxdrka'-ngrng mzli kc namc-ngrdr nide. Ycpwz pipz kxdrka'-ngrng lcng sa namrbr, x mane nzmadqti-krdr nqngidr mz zngya. Zbz da amrlx kcng tqmrlzbz badr sa nangitx brmrda x sa na-apulr zsikapu kx ngilia. ");
INSERT INTO ntu_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Naglqlzku Yawe! Nigu kxnzawz nedeng na-armyalzku drtqde. ");
INSERT INTO ntu_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Nayzuo mzli ka nzrglqpxngr drtqde Tqvzpe, tqvzpe. ");
INSERT INTO ntu_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Mz zbq kang kqlu nigu leplz mz nrlc tulvzo Na-awi-ngrbzku bade nqmq krde. ");
INSERT INTO ntu_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Murde aclve-atwrnr-ngrde lr mrkzbleng amrlx. X nzetukr zmatq ngrde krlzlzbzle bongavz. ");
INSERT INTO ntu_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Trpnzngr kx apule Yawe kc tqngi Gct rgu, Mz nzwxbutxlz-krde mz tron nyzde Heven. ");
INSERT INTO ntu_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","Sc tqobqlvztile bongavz x drtc', Mz nzaclve-angidr-krdeleng. ");
INSERT INTO ntu_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Murde naokatrle leplz kx trnzrngiscung, Mz nzkapx-krmle nidr mz nzkxpu-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","X armyalzle nidr murde nanginidr nradrtq kxnzetung Kcng tzmailzlr leplz nedeng. ");
INSERT INTO ntu_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Ngi-batrpzle mz olvz kxvz-nrbalq nzrngine-krde doa kxnztopwzng, Murde na-abrtz-ngrde doa nede lcng. Naglqlzku Yawe! ");
INSERT INTO ntu_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Mzli kc lr Israel nzrlasz-ngrdr Ijipt, Mz nzngini-krdr lr mrkzbleng elr, ");
INSERT INTO ntu_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","Lr Judz lcng tznginipedr leplz kxnztrng ne Yawe, Mz nzaclve-krde drtc' nyzdr, Israel. ");
INSERT INTO ntu_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Prla Bla akipx-lzbq x pzlzm. X LueJodzn lvxpxbzle lrpzki badr. ");
INSERT INTO ntu_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","X mzli lc newz x nra nzyameng, Nzapulr nzblc-abrtznekr nei sip. ");
INSERT INTO ntu_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","?Myx kxmule, Prla Bla tqakipx-lzbq-ngrde, X LueJodzn tqlvxpx-ngrde lrpzki? ");
INSERT INTO ntu_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","?X nike nzyamengr newz x nra amrlx Mz nzapu-krdr nzabrtzkr nei sip? ");
INSERT INTO ntu_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Da kcng tqwzngr Yawe nzvz-nqblqlr natqde. Nzelalvzlr nzaelwapx-krde zmatq ngrde, mz nzngini-krde Gct r lr Israel. ");
INSERT INTO ntu_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Murde batrpzle nzyrlepx-krm lue mz rplz, Lue lc tqngi aulz mz rplz. ");
INSERT INTO ntu_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Yawe, nim txpwz kx takitrde nzarmyalzngr, a' trngiu nigr. Murde nim txpwz kx aodu zvz x trataowq natqm kcng tqyrlqq. ");
INSERT INTO ntu_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Delc trtakitrdeu lr mrkzbleng nzrpi-zvz-krmlr bagu kx, “?Myxpe Gct rmu?” ");
INSERT INTO ntu_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Murde Gct rgu mncom Heven, X rngisc zmatq ngr nzale-krde nikeng suti drtwrde. ");
INSERT INTO ntu_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","A' kxnzmnc-mrbrng nzangiolr mqngr da kxnzlz Kcng tzwzngr leplz mz mqdr. ");
INSERT INTO ntu_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","7","A' mqngr da kxnzlz lcng trnzycmneung x trnzobqung. Trnzxlrung, trnzycminiung, X trnzrtcngiung da. Trnzrmaleung x trnzvzneung. ");
INSERT INTO ntu_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Leplz kcng tzrwz-ngrng mqngr drka' lcng tzlz X krkcng tzangiolr nidr nzapu-kzlr nidr mz trnzrngisc-krdru zmatq. Nznabung, mztr mwi, nradrtqdr ngq, trnzycngrlrung, Trnzrtcngiung da, trnzxngitrung, x trnzvzneung. ");
INSERT INTO ntu_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","11","Nimu kcng tzaxvctr-lzbq-kzpqng bagr mz nzangio-krgr Yawe, X nimu pris nedeng mz nqvi lr Eron, X nigu lr Israel amrlx na-abrtrpzku drtwrgu bade. Murde nide temz ngr lomrgu kc tqyrputrngr nipna. ");
INSERT INTO ntu_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","13","Yc zvz mz drtwrde nigu x sa na-amrlz-zvzle nigu. A' sa na-amrlzle nimu kcng tzaxvctr-lzbqmqng mz nzangiongr nide, X nimu nqvi lr Eron, x nigu lr Israel amrlx. Kxmule-esz' nigu leplz txneng o kxnzetung, ");
INSERT INTO ntu_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","15","Krka'-ngrne kx Yawe kc tqwz-ngrde Heven x nrlc Na-amrlz-ebir-ngrde nimu badr doa nemung. ");
INSERT INTO ntu_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Heven mztea nyz Yawe, A' kamle bagu, nrlc ka. ");
INSERT INTO ntu_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","18","X nigu kxnzlung mz nrlc ka na-awibzku bade, Murde kxnzbzpeng kcng tzyrtzmqpeng mz gq, rblx nzglqlz-krdr nide. Naglqlzku Yawe na-abzo mzli ka x tqvzpe tqvzpe. Naglqlzku Yawe! ");
INSERT INTO ntu_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","2","Yawe xlrmle natqnge. Mrlzti-zlwzx nide. Kqle-zvzx nide. Yawe xlrmle natqnge. ");
INSERT INTO ntu_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Ycpwz pipz nzbz-krnge, x sc tqmwxlr-ngrne. Nabznge talvzo-ngrde ycpwz pipz nzbz-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Sc tqkqlepex nide mz nzrpi-krbo bade kx, “Yawe, arlapx ninge!” Sc tqkqlepex nide. ");
INSERT INTO ntu_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Zmrlz ngr Yawe myalz-esz'ngr mz nzokatr-krde leplz. Ycngr drtwrde nigu. Zmrlz ngr Yawe myalz-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Okatrle kxtrnzxplrung, murde arlapxbzle ninge Mz nzkxpu-krngeng. Okatrle kxtrnzxplrung. ");
INSERT INTO ntu_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","8","Amnc-zpwx-moule ninge. Trmetx-ngrpwc'u mz enqmi. Trbz-ngrneu, tryrni-ngrneu. Amnc-zpwx-moule ninge. ");
INSERT INTO ntu_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Navz-nqblq-zvzx nide x me pnz drtwrde. Mz nzmnc-krnge mz nrlc navz-nqblq-zvzx nide. ");
INSERT INTO ntu_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","11","Kxmule-esz' ycpe pipz nzmwxlrti-lzbq-krnge, A' mzli kc tqkxpu-zlwz-ngrne, Pipxx murde abrtrpo drtwrnge mz Yawe, X krlzx kx mane nzbrtikr drtwrnge leplz. ");
INSERT INTO ntu_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Kxmule-esz' rblx nzayzlu-krbo mz Yawe Da kxmrlzting kcng tqaletimleng bange, ");
INSERT INTO ntu_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","A' sa natwzmc bade waen, Nangi dalr nzawi-krbo bade mz nzarlapx-krde ninge. ");
INSERT INTO ntu_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","X sa nakabo bade nike esalz-ngrbo bade, Mz nzangiopx-lxblrkr leplz nedeng. ");
INSERT INTO ntu_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","X napipxbo badr kx, “Drtwr Yawe vztx zlwz Mz nzmc-krde nzbzkr kzdq doa nedeng. Delc tqmrlz-ngrbzle bade nzarlapx-krde nigu, Tqmyaszpx-ngrde nzrlrpx-krde nzbz-krgu.” ");
INSERT INTO ntu_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","Yawe, ninge kxnzawz nem, da kc tqwai lxenge mzli kc. Awi mz nzarlapx-krm ninge mz nzbzngr. ");
INSERT INTO ntu_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Kabo bam blz kx na-awi-ngrbo bam, Mz nzkrka'-krbo bam. ");
INSERT INTO ntu_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Delc tqka-ngrbo bam da kc tqesalz-ngrbo bam, Mz mzlir leplz nemqng, ");
INSERT INTO ntu_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","Mz nzamrlue-lxblr-krgr nim Mangr-nzangiongr Jerusalem. Naglqlzku Yawe! ");
INSERT INTO ntu_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Glqpxamu Yawe nimu lr mrkzbleng amrlx. X nimu leplz mz nrlc tulvzo naglqlz-kzamu nide. ");
INSERT INTO ntu_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Murde nzaodu-zvz-krde nigu etu-esz'ngr. X nzngida-angidr-krmle bagu tqyc tqyc. Naglqlzku Yawe! ");
INSERT INTO ntu_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Aodu-zvzle nigu. Awi-ngrbzku bade Nzmrlz-esz'ngr-krde. Aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Aodu-zvzle nigu. Lr Israel amrlx Napipxku kx, “Aodu-zvzle nigu.” ");
INSERT INTO ntu_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Aodu-zvzle nigu. X nimu pris nedeng Napipxamu kx, “Aodu-zvzle nigu.” ");
INSERT INTO ntu_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Aodu-zvzle nigu. X nimu kcng tzaxvctrmqng, Napipx-kzamu kx, “Aodu-zvzle nigu.” ");
INSERT INTO ntu_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Mzli kc tqmnc-ngrne mz nzkxpungr, kqlex Yawe, Ayzlumle natqnge x aopxbzle drtqnge. ");
INSERT INTO ntu_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Trtxpnzngr nzmwxlr-krnge, murde Yawe tu-zvzm mz nibrnge. X trtxpnzngr leplz kx krlzle nzatrkati-krde ninge. ");
INSERT INTO ntu_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","X sa namcx nzaovxio-krbzle enqmi rngeng, Murde mnc mz nrlarde nyznge. ");
INSERT INTO ntu_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Mrlzvxitx nzmnc-xgle-krgu nzokatrkr Yawe Murde myaszpxle nzokatrkr leplz nigu. ");
INSERT INTO ntu_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","X mrlzvxitx nzabrtr-krbzku drtwrgu bade mz nzrlapx-krgu, Murde myaszpxle nzrmctitr-krbzkule mz kxnzrmailzng. ");
INSERT INTO ntu_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Aovxiox mz zmatq ngrde mzli kc enqmi rngeng Tztu-ngalelvz-ngrdr ninge. Aovxiox mz zmatq ngrde. ");
INSERT INTO ntu_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Aovxiox mz zmatq ngrde mzli kc tzavztio-ngrdr Ninge mz trtxki. Aovxiox mz zmatq ngrde. ");
INSERT INTO ntu_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Aovxiox mz zmatq ngrde dzbe meningilo lc. Nzapulr nabr kx ngc. Aovxiox mz zmatq ngrde. ");
INSERT INTO ntu_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Kxnzyrkrtilzlr ninge mz nzotangr, ycpwz pipz na-aovxio-krdr ninge. A' Yawe kx okatrle ninge. ");
INSERT INTO ntu_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Nide oa kx xplr kc tqmailzle ninge mz vea, X tqarlapxle ninge. ");
INSERT INTO ntu_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","16","Mz nzmnc-krdr matelq ngr vea nyzdr, Ncblo ngr vea nedeng nzngr-abrtz-ngrdr nzaovxio-krde, nzrpi-krdr kx, “Yawe, oa ngr vea, kc tqaovxio zvz Mz zmatq ngrde. Yawe, oa ngr vea.” ");
INSERT INTO ntu_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Delc trbz-ngrneu, a' lubex Murde napipxbo da kcng tqmatq tqaleting Yawe. ");
INSERT INTO ntu_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Kxmule-esz' rlrpx-ngrde nzakxpu-zlwz-krdr ninge, A' trngiu dalr nzbz-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","King malqtrpz yz, rpile kx, “Lvxpxm bange naonrx ngr Mangr-nzangiongr Yawe, Murde navztrx elr mz nzawi-krbo bade.” ");
INSERT INTO ntu_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","X pris neng Yawe nzayzlubzlr natqde kx, “Krlc naonrx nyz Yawe, X kxnztubqng txpwz kx navztrng elr.” ");
INSERT INTO ntu_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Mz nzvztrkr King elr, rpile kx, “Yawe, awi-zvzbo bam murde ayzlu-ngrme nzkrka'-krnge, Mz nzarlapx-krme ninge mz mq enqmi rngeng.” ");
INSERT INTO ntu_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Leplz amrlx kcng tzyrlwr-lxblrng Mangr-nzangiongr nzrpilr kx, “Rplz kc etu tzpxtxpx-ngrdr ncblo kcng tzrwz-ngrng ma, Nzaelwapxngr kx nide nou rplz kc tqmyatxpx-zlwzbz.” ");
INSERT INTO ntu_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Da lc Yawe kxrwzngr. X abrtztx-zlwz-ngrgu. ");
INSERT INTO ntu_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Krlc zbq kx wzpxngr Yawe. X na-awi-ngrbzku bade. Murde nide kc tqrbatrp zbq lc Nzrmulvzngr nzaovxio-krgu mz vea. ");
INSERT INTO ntu_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Ayzlu-ngrmle natqgu kx, “Yawe, arlapx nigr Mz nzokatr-krm nzaovxio-krgu.” ");
INSERT INTO ntu_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Yawe, glqlzkr nide kc tqvzm mz drtqm. Glqlzkr nide mrka mz Mangr-nzangiongr. ");
INSERT INTO ntu_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Yawe nide Gct kc tqokatr-zlwzle nigu. Delc naelami-ngrgu leu ngr nzaovxiongr, Mz nzvz-ngale-krgu olta nyzde Kc tqtr-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Yawe, nim Gct rnge x na-awi-ngrbo bamq Nzmyalz-esz'ngr-krmq. Yawe, nim Gct rnge. ");
INSERT INTO ntu_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Aodu-zvzle nigu. Awi-ngrbzku bade Nzmrlz-esz'ngr-krde. Aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Awi Yawe! Namrlzbz mz leplz kx trnzvz-rbrung, A' nzvz-nqblqlr Loukxtr scm, ");
INSERT INTO ntu_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","X namrlz-kzpz mz krkcng tzlxngitilr natqm, X nzrtangrtilr nim mz nabzdr atwrnrngr, ");
INSERT INTO ntu_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","X krkcng tzalelr da kxtubq, X nzo-zlilr lrpzki rm. ");
INSERT INTO ntu_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Alvztr-zvzq nigr Murde nalolvz-amqngikr nqmq krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Navz zvz Nzrtangrti-krnge me pnz drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Murde ma tqmyangr drtqnge Mz nzaoti-zvzkr drtwrnge Nzryrngrkxtr. ");
INSERT INTO ntu_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Alqngitipeq ninge, Glqlz-ngrne nim nztubqkr nabznge. ");
INSERT INTO ntu_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Alex da kx pitimeng bange. A' bzkq amnctxn ninge esz'-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","10","Bzkq rlr-ngrme nzrlasz-krnge nim, Murde sa tqabzx nzwztr-krbo bam mz drtwr kxpq. Nzlolvz-amqngikr obla natqm okatrle nide Mz nztu-amqngi-krde mz nzmncngr kxtubq. ");
INSERT INTO ntu_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Abrtz-ngrne Nzryrngrkxtr Murde natubq-zvzbo mz nzobq-krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Yawe, glqlzx nim. X suti drtwrnge nzkrlz-zpwx-krnge nqmq krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Natqnge etu zvz Mz nzpipx-krnge Loukxtr scm. ");
INSERT INTO ntu_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Nzabrtzngr kx vzpxm mz nzvz-nqblq-krnge nim Myaszpxle nzrngisc-krnge trau kxkqlu. ");
INSERT INTO ntu_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Nadcpx mz drtwrnge me pnz drtwrm. Mz nzaoti-zvzkr drtwrnge nzalvztr-krmqng. ");
INSERT INTO ntu_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Bilvz-zlwzx nzti rm, X trmrbrtru mz drtwrnge natqm. ");
INSERT INTO ntu_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Clve ninge murde ninge kxnzawz nem, X nayrlq-zvzx natqm mz nzmnc-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Okatrp ninge mz nzrmcti-krnge Da kxmrlzting kx nzprpxmqng mz Loukxtr scm. ");
INSERT INTO ntu_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Ninge kxvztimle nrlc. Bzkq yrlq-kapqme bange me pnz drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Pq zvz mz drtwrnge Nzkrlz-krnge nqmq krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Ayrplapxq kxnzglqpx-lzbqng Kcng tzrnzlvzolr natqm. ");
INSERT INTO ntu_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Bzkq rlrpx-ngrn nzobqszo-krdr x nzyrpalelvz-krdr ninge, Murde vz-nqblqx natqm. ");
INSERT INTO ntu_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","X kxmule-esz' kxnzetung nzpikitilr ninge, A' sa tqotr-zvzngr drtwrnge nzalvztr-krmqng. ");
INSERT INTO ntu_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Clve ninge mz Nzryrngrkxtr Murde abrtz-ngrne nzmailz-krdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Drtqnge mewetx-zlwzpe x ycpe pipz nzbz-krnge. Ka-mop nzlungr bange, mz nzvz-nqblq-krde natqm. ");
INSERT INTO ntu_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Mzli kc tqplzpx-ngrbo bam alwx rngeng, ayzlu-ngrme natqnge, X alvztrpe' bange nqmq krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Okatrp ninge mz nzrkrlz-krnge Loukxtr scm, Murde na-aoti zvz drtwrnge nzwz-krmqng kcng tqmyalz. ");
INSERT INTO ntu_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Nzrtxlvzlzkr nzvzkr drtwrnge etutx-zlwzpe. Amqtrp drtwrnge da kc tqwai nzesalz-krmle. ");
INSERT INTO ntu_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Okatrp ninge mz nzo-zli-zvz-krnge nzti kxtubq, X alvztrp bange Nzryrngrkxtr mz zmrlz ngrm. ");
INSERT INTO ntu_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Pnzpe drtwrnge kx navz-nqblq-zvzpex nim, Mz nzale-zvz-krnge me pnz drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Yawe, bzkq rlrpx-ngrn nzamyati-ngrm drtqnge, Murde lolvz-amqngix nzalvztr-krmqng. ");
INSERT INTO ntu_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Da kx mailzle ninge nangi lrpzki rm Mz nzokatr-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Eu Yawe, alvztrp bange me pnz drtwrm, Murde nayrlq-zvzx. ");
INSERT INTO ntu_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","X okatrp ninge mz nzvz-nqblq-krnge Loukxtr scm, Murde naesz'-ngrde nabznge. ");
INSERT INTO ntu_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Abrtz-ngrne lrpzki rm Mrkc tqmailz-zvz-ngrn ninge. ");
INSERT INTO ntu_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Okatrp ninge mz nzpqtikr drtwrnge natqm, Murde myaszpxle nzrngisc-krnge da kxkqlu. ");
INSERT INTO ntu_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","X bzkq rlr-ngrme nzsutikr drtwrnge da kxmane, A' axplr-mop ninge mz nzo-zli-krnge nzti rm. ");
INSERT INTO ntu_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Angidatim bange nzesalz-krmqng, Da kc tqwaibzme mz leplz kcng tzamrluelr nim. ");
INSERT INTO ntu_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Okatrp ninge murde mwxlrtix enqmi rngeng nzxtrnga-krdr ninge. A' mrlz-esz'ngrm bange nzpnana-krmqng. ");
INSERT INTO ntu_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Esalz-ngrm bange kx na-alvztrq ninge, Murde nztubq-krm naka-mople bange nzxplrngr. ");
INSERT INTO ntu_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Gct, arlapx ninge mz nivz lrm, Mz nzangidati-krm nzesalz-krmqng. ");
INSERT INTO ntu_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Murde na-ayzlu-ngrbo natq krkcng tzyrpalelvzlr ninge, Mz nzbrtikr drtwrnge natqm. ");
INSERT INTO ntu_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Okatrp ninge mz nzrpi-zvz-krnge da angidr, Murde brti kz drtwrnge drtwr kcng tqyrlqqng. ");
INSERT INTO ntu_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","X nzmqngitr-zlwzkr drtwrnge mz Loukxtr scm Tqvzpe, tqvzpe. ");
INSERT INTO ntu_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","X drtqnge sa naopx mz nzvzne-krngeng Murde o-zlix lrpzki rm. ");
INSERT INTO ntu_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","X trtxpnzngr nzmyamikr naonge Nzpipx-krbo natqm mz kxnzetung. ");
INSERT INTO ntu_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","48","Gct, abrtz-ngrne nzyrlq-angidr-krnge Nqmq krm x me pnz drtwrm. Murde nzmrlzmqng bange x nzmatqng mz drtwrnge. X na-aoti zvz drtwrnge nzalvztr-krmqng. ");
INSERT INTO ntu_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Ipqpeq ninge mz nzdcpxkr mz drtwrm nzesalz-krm. Murde obqtipxx zmrlz ngrm. ");
INSERT INTO ntu_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","X amqtrple drtwrnge mz mzlir nzkxpungr. Murde rmcti-ngrne nzlungr mz nzrlwx-krnge Loukxtr scm. ");
INSERT INTO ntu_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Kxmule-esz' kxnzglqpx-lzbqng nzxtrnga-ngrdr ninge, A' tresablqtiwxu Nzryrngrkxtr. ");
INSERT INTO ntu_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Yawe, mz nzaotr-zvzkr drtwrnge Lou scm kc bqnc, Okatrple ninge. ");
INSERT INTO ntu_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Drtwrnge apulzmle nyr, Mz nzpxtxpxkr kxdrka'-ngrng nqmq krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Mzli ka tqlube-ngrne mz nrlc, Natqm nangi zvz nabz nenge. ");
INSERT INTO ntu_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Yawe, mwible-zvzx nim mz nrlckxbq, X suti drtwrnge nzyrlq-angidr-krnge me pnz drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Iklr ninge murde nabznge napq, X na-ale-zvzx nzalvztr-krmqng. ");
INSERT INTO ntu_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Jzs ninge, murde suti txpwz drtwrnge nim, X mrlzm bange nzlolvz-amqngi-krnge natqm. ");
INSERT INTO ntu_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Mz nabznge atwrnrngr, rlxtibo bam Nzmrlzti-krm ninge da kc tqwai nzesalz-krmle. ");
INSERT INTO ntu_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Mzli kc tqdwa-rbrti-ngrne lrpzki rnge mz nzvz-nqblq-krnge nim, Yzlu-mopwc' nzo-zli-krnge nzti rm. ");
INSERT INTO ntu_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","X trasatiwxu nzyrlq-krnge Loukxtr scm. A' rnekititxpwo nzale-krnge me pnz drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","X kxmule-esz' prtzx mz trtxki sc kxdrka'-ngrng, A' trmrbrtru mz drtwrnge Nzryrngrkxtr. ");
INSERT INTO ntu_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Tulzmc mz nzawi-krbo bam mzli kc mz aurnrlc, Murde drtwr kcng tqyrlqq tubq-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Ninge kzte krkcng tzamrluelr nim, Tzalelr nzalvztr-krmqng. ");
INSERT INTO ntu_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Yawe, mz nzaodu-krm kc tqyc-ngalelvzle nrlc tulvzo, Alvztrp bange nqmq krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Kxetu, aleme bange da kxmrlz, Mz nzvz-nqblq-krde nzesalz-krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Kxakrlz, alvztrp bange nzrkrlzngr x drtwr kxmrlz, Mz nzlxngiti-krnge Nzryrngrkxtr. ");
INSERT INTO ntu_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Mzli kc ena vz-rbrpex, x ayrplapxq ninge, A' mzli ka ale-zvzpex da kxtubq mz nzobq-krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Mz nzmrlz-esz'ngr-krm x nqmq krm kx mrlzvxi Alvztrp bange nqmq krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","70","Drtwrnge elalzm mz Loukxtr scm. A' kxnzglqpx-lzbqng trpnzngr nzrkrlz-krdr. Kxmule-esz' nzpokiatitrlr ninge, A' lolvz-amqngi-zvzx nzalvztr-krm mz drtwr kxbr. ");
INSERT INTO ntu_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Mrlzm bange nzayrplapx-krm ninge, Murde nakrlz-ngrne nzvz-rbr-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Kxakrlz, natqm nzmrlz-krmle bange Myaszpxle blzmr trau mz nrlc. ");
INSERT INTO ntu_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Lalztqm mz nzkrka'-krnge murde nakrlzx me pnz drtwrm, Murde wz-ngrn ninge x aclve-angidrq ninge. ");
INSERT INTO ntu_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Krkcng tzamrluelr nim na-abrtzlvzlr ninge Mz nzlxngiti-krnge natqm. ");
INSERT INTO ntu_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","Yawe, krlzx kx takitrde nzayrplapx-krm ninge Murde vz zvz nzokatr-krm leplz nemqng. ");
INSERT INTO ntu_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Amqtrp drtwrnge mz nzaodu-zvz-krm ninge, Da kc tqwai nzesalz-krme bange. ");
INSERT INTO ntu_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Mz nzabrtzlvz-krnge Loukxtr, Nayc mz drtwrm ninge, murde ma tqbzx. ");
INSERT INTO ntu_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Amyatxbz drtq kxnzglqpx-lzbqng mz nzpokiatitr-krdr ninge, Murde aoti zvz drtwrnge nzalvztr-krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Batrpz mz kxnzamrluelr nim nzaxvctr-lzbq-krmlr bange, Krkcng tzkrlz-angidrlr Loukxtr scm. ");
INSERT INTO ntu_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Lod, batrpz mz nabznge nztubq-krde mz nzobq-krm, Murde drtqnge ma tqmya. ");
INSERT INTO ntu_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","82","Mevalu, mewepengr drtqnge x mzke' ngqbqtxtrpebz Mz nzaenzli-krnge nim. ?Myx mzli kx na-arlapx-ngrn ninge, Mz nzangidati-krm nzesalz-krm kc tqbrti drtwrnge? ");
INSERT INTO ntu_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Kxmule-esz' nzobqszonge apux da kx nzrtctxpengr, A' dcpx zvz mz drtwrnge me pnz drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","?Myx mzli kx nayrkrpxngr nzkxpu-krngeng? ?X myx mzli kx na-ayrplapx-ngrn krkcng tzatrkatilr ninge? ");
INSERT INTO ntu_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Kxnzglqpx-lzbqng nzekqng gq kx nangi trtxki rnge, Mz nzpxtxpx-krdr Loukxtr scm. ");
INSERT INTO ntu_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Mailz ninge mz nzbrtikr drtwrnge Nzryrngrkxtrng amrlx. Murde trpnzngr badr nou nzatrkati-krdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Kxmule-esz' ycpwz pipz nzayrkrpx-krdr ninge, A' sc tqlolvz-amqngix nzalvztr-krmqng. ");
INSERT INTO ntu_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Mevalu, arlapx ninge mz nzaodu-krm ninge. Murde nayrlq-angidrx natqm. ");
INSERT INTO ntu_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Natqm tqyc, tqyc, X yc amqngi zvz Heven. ");
INSERT INTO ntu_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Wz-ngrn nrlc x yc amqngi zvz. Delc tqbrti-zvzngr drtwr nim. ");
INSERT INTO ntu_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Da amrlx mz nrlc nzvz-nqblqlr me pnz drtwrm, Murde nzwztrpzng bam. ");
INSERT INTO ntu_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Trbz-ngrneu nzkxpu-krngeng, Murde Loukxtr scm okatrle ninge mz nzaelalz-krmle drtwrnge. ");
INSERT INTO ntu_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","X trtxpnzngr nzmrbrtrkr mz drtwrnge Nzryrngrkxtrng, Murde nzrpwa'-ngrmlr bange mz nzvz-rbrngr. ");
INSERT INTO ntu_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Arlapx ninge, murde ninge doa nem, X abz-zvzx nzale-krnge nzalvztr-krmqng. ");
INSERT INTO ntu_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Kxmule-esz' kxdrka'-ngrng nzyrlqlr br ngr nznibq-krdr ninge, A' na-aoti zvz drtwrnge nqmq krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Natqm tqyc tqyc, Kxmule-esz' da kxmyapxbz amrlx nzyrkrpxng, ");
INSERT INTO ntu_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Oliq-zvzx nzaotikr drtwrnge Loukxtr scm, Murde mrlz-zlwzm bange. ");
INSERT INTO ntu_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Nzrkrlz-krnge myaszpxle enqmi rngeng, Murde Nzryrngrkxtr yc zvz mz drtwrnge. ");
INSERT INTO ntu_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","X nzwzkr narnge myaszpxle kxnzalvztrlr ninge, Murde ale-zvzx me pnz drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","X nzyrplapx-krnge myaszpxle lrtzlvzng, Murde yrlq-angidrx natq kx kame bange. ");
INSERT INTO ntu_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Yrlqpx-lzbqnge mz nzmncngr kxdrka'ngr, Mz nzvz-nqblq-krnge da kx tubq mz nzobq-krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Trpxtxpx-ngrneu drtwr kcng tqyrlqq, Murde nzalvztrlr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Natqm nzlqngi-esz'ngr-krde mz nzxlrngr Myaszpxle nzmrlzkr dakxnzng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Okatr-zvzq ninge mz nzalvztr-krm murde nakrlzx nzti kxtubq. Delc tqmamwe-ngrne nqmq kx vz-rbr amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Pqtr zvz mz drtwrnge natqm, Kc tqngi zyzlr ngr nzti rnge mz nzmailz-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Nzesalz-krngeng nayrlq-angidr-zvzxng, Mz nzo-zli-krnge nztubqkr lrpzki rm. ");
INSERT INTO ntu_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Okatrp ninge da kc tqwai nzesalz-krmle, Murde nzkxpu-krngeng amrlx ma tznibqlr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Yawe, alvztrp bange nzaolvz-krmqng X abrtzlvz nabz nenge mz nzangrlvz-krnge nim. ");
INSERT INTO ntu_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Kxmule-esz' da kxtrka prtzm bange, A' trmrbrtru mz drtwrnge Loukxtr scm. ");
INSERT INTO ntu_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","X kxmule-esz' kxdrka'-ngrng nzamwitiolr ninge trtxki, A' vz zvz nzatutr-krnge nzalvztr-krmqng. ");
INSERT INTO ntu_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","X lolvz-amqngi-zvzx Nzryrngrkxtrng, Murde nzaelalzmlr drtwrnge. ");
INSERT INTO ntu_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Pnzpe drtwrnge kx navz-nqblq-zvzx me pnz drtwrm, Murde nzokatrngr kx vzpxm elr vztx alo. ");
INSERT INTO ntu_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Rblxm bange nzmrlzti-krnge krkcng drtwrdr tqlitrpz bam, A' mrlz-zlwzm bange Loukxtr scm. ");
INSERT INTO ntu_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Nim me rlakitrx x temz ngr lomrnge kc tqyrputrngr nipna, X abrtrpo drtwrnge mz natqm. ");
INSERT INTO ntu_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Esablqtix kxdrka'-ngrng Murde navz-nqblqx nqmq krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Bzkq mya ngr drtqnge nzbrtikr drtwrnge nim, A' arlapx ninge da kc tqwai nzesalz-krmle, murde ma tqbzx. ");
INSERT INTO ntu_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Natu-ngrme mz nibrnge mz nzarlapx-krm ninge, Murde namatq zvz mz drtwrnge drtwr kcng tqyrlqq. ");
INSERT INTO ntu_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Pxtxpx-ngrn krkcng tzpxtxpx-ngrdr Nzryrngrkxtr. Murde nzesabrng x nzpokiang. ");
INSERT INTO ntu_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Obqszoq kxdrka'-ngrng mz nzapu-krdr dcvi. Delc tqmrlz-ngrm bange nzalvztr-krmqng. ");
INSERT INTO ntu_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Rnrcti-lzbqnge mz nzmwxlrti-krnge nim, Murde ma trtubqwxu mz nzobq-krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Suti drtwrnge nzarlapx-krme ninge mz mq enqmi rngeng, Murde nqmq krnge rsakrlrngr x tubq. ");
INSERT INTO ntu_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Bzkq rlr-ngrbzme mz kxnzglqpx-lzbqng nzatrkati-krdr ninge. A' amnc zpwx ninge. ");
INSERT INTO ntu_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Mzke' ngqbqtxtrpebz mz nzaenzli-krnge Nzvz-nqblq-krm nztubqkr nzesalz-krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Alvztrp bange nqmq krm Mz nzaodu-zvz-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Okatrp nzyrplapx-krnge, Murde nakrlz-angidrx nzaolvz-krmqng. ");
INSERT INTO ntu_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Yawe, mzli r nzayrplapx-krm leplz dekape. Murde nzrnzlvzo-zvzlr Loukxtr scm. ");
INSERT INTO ntu_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Mz nzmu-krde lcde, natqm nzmrlz-krmle bange Myaszpxle da kx lqlwx amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Sa natubq-zvzm bange nzalvztr-krmqng amrlx. X mamwe-ngrne nqmq amrlx kx vz-rbr. ");
INSERT INTO ntu_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Takitrde nzlolvz-amqngi-krnge nzalvztr-krmqng Murde nzmrlz-zlwzng. ");
INSERT INTO ntu_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Natqm apule zyzlr, Murde aelwa-ngrbzle lrpzki kxtubq mz leplz amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Nzsutikr drtwrnge nqmq krm apule nzbrlxkztikr drtwrnge lue, Murde narmcti-ngrne nzlungr angidr. ");
INSERT INTO ntu_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Nayc mz drtwrm ninge, Da kc tqwaibzme mz krkcng tzamrluelr nim. ");
INSERT INTO ntu_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Okatrp ninge mz nzvz-nqblq-krnge me pnz drtwrm, Murde alwx ma tqmailz-rbrle ninge. ");
INSERT INTO ntu_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Arlapxbz ninge mz mq leplz kcng tzakxputilr ninge, Murde nayrlq-zvzx da kx tubq mz nzobq-krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Okatrp ninge mz nzxngi-krnge nim, X alvztrp bange Nzryrngrkxtr. ");
INSERT INTO ntu_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Trtakitrdeu nzrnzlvzongr Loukxtr scm. X yrnitx-zlwz-ngrne alwx ngrdr lc. ");
INSERT INTO ntu_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Vz-nqblq-zvzq nzmncngr kxtubq-esz'ngr, X drtwr kcng tqyrlqq rsakrlrngr. ");
INSERT INTO ntu_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Natq kcng tqkapxq nzabrkitr drtwr, Murde nztubq-zvzng. ");
INSERT INTO ntu_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Zngya ngr drtwrnge apule nyr kc tqngc, Murde enqmi rngeng mrbrtr mz drtwrdr Nzryrngrkxtr. ");
INSERT INTO ntu_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Nzesalz-krm pq zlwz mz drtwrnge Murde angidati-zvzme bange. ");
INSERT INTO ntu_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Kxmule-esz' leplz nzobqszolr ninge, A' trmrbrtru mz drtwrnge nzalvztr-krmqng. ");
INSERT INTO ntu_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Yawe, nztubq-krm tqyc, tqyc, X Loukxtr scm ngi da angidr zvz. ");
INSERT INTO ntu_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Delc kxmule-esz' nzkxpungr x nzvzkr drtwr nzprtzmqng bange, A' abrtz-ngrne nzo-zli-zvz-krnge nzti rm. ");
INSERT INTO ntu_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Vz zvz nzokatr-krm ninge nzmc-krnge Nztubq-zvzkr natqm, murde ma tqbzx. ");
INSERT INTO ntu_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","Wztx-ngrpwo nzkrka'-krbo bam. X ayzlum natqnge, murde nao-zlix lrpzki rm. ");
INSERT INTO ntu_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Yrnimi-zvzbo bam nzarlapx-krm ninge, Murde nayrlq-angidrx Loukxtr scm. ");
INSERT INTO ntu_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Kqle-zvzx nim mz nourla kxtopwz mz nzokatr-krm ninge, Murde abrtrpo drtwrnge mz nzesalz-krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Obqtx-zvzx mz nrlckxbq, Mz nzaotikr drtwrnge me pnz drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Mz nzaodu-zvz-krm ninge, xlrm natqnge, X mailz ninge mz nzalvztr-krmqng. ");
INSERT INTO ntu_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Kxmule-esz' kxnzxpqbrlr-ngrdr nqmq krm Nzesolvztilr ninge, a' trmwxlrwxu. ");
INSERT INTO ntu_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Murde eso-aepztrpe' bange, X drtwr amrlx kcng tqyrlqq da angidr zvz. ");
INSERT INTO ntu_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Wz-ngrn natqm murde nayc-alo, Da kc tqwai nzkrlz-krngele, abzo mzli kc pnz. ");
INSERT INTO ntu_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Xlrm natqnge x arlapx ninge mz nzkxpu-krnge, Murde dcpx zvz mz drtwrnge Loukxtr scm. ");
INSERT INTO ntu_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","X pipxbz mz leplz kx nqmq krnge tubq, Da kc tqwai nzesalz-krmle, murde ma tqbzx. ");
INSERT INTO ntu_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Kxdrka'-ngrng trtxpnzngr nzrlapx-krdr, Murde trnzrtangrtilru nzti rm. ");
INSERT INTO ntu_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Yawe, axplr mou ninge mz nzetukr nzaodu-krm, Murde vz-nqblqx me pnz drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Kxmule-esz' enqmi rngeng nzkqlu-zlwzng, A' trtxpnzngr nzesablqti-krnge Nzryrngrkxtr. ");
INSERT INTO ntu_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Pxtxpx-ngrne kx drtwrdr litrpz bam, Murde trnzlxngitilru da kxtubq mz nzobq-krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Yawe, arlapx ninge mz nivz lrm, Murde mrlzm bange nzalvztr-krmqng. ");
INSERT INTO ntu_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","X natqm mqngio mz da kxtubq. Delc drtwr amrlx kcng tqyrlqq nztubq-kzng. ");
INSERT INTO ntu_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Yawe, kxnzetung nzatrkati-krdr ninge trpnzngr noude, A' amatq-zlwzx natqm. ");
INSERT INTO ntu_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Apux bcnyr kc tqrmctile da kxpqtr mz nabzde, Murde abrtz-ngrne Nzryrngrkxtr ");
INSERT INTO ntu_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Trkam bange natq ngr nzpokiangr, A' mrlzm bange natqm. ");
INSERT INTO ntu_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Glqpx-zvzx nim mz zbq kang kqlu, Murde drtwr kcng tqyrlqq tubq-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Krkcng tzmrlz badr Loukxtr scm, nzmnc-zpwxng. X trpnzngr doa x da kx na-ataole nidr. ");
INSERT INTO ntu_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","Yawe, brti drtwrnge nzarlapx-krm ninge, Mz nzale-zvz-krnge da kx pitimeng. ");
INSERT INTO ntu_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Lolvz-amqngix nqmq krm, Mz nzmrlz-zlwz-krmle bange. ");
INSERT INTO ntu_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Yrlq-angidrx nzalvztr-krm, Da kc tqwai nzmc-krmle. ");
INSERT INTO ntu_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","Zyzlr ngrm napnamilxtile nabznge, Mz nzayzlu-krme natqnge mz nzvz-nqblq-krde nzesalz-krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Lalztq-ngrm nzkrka'-krnge, X arlapx ninge mz nzvz-nqblq-krde natqm. ");
INSERT INTO ntu_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Naglqlz-zvz-ngrne nim Mz nzalvztr-krme bange nqmq krm. ");
INSERT INTO ntu_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Na-angrlvzx nzesalz-krm, Murde drtwr amrlx kcng tqyrlqq tubq-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Oliqm mz nzokatr-krm ninge, Murde lolvz-amqngi-zvzx me pnz drtwrm. ");
INSERT INTO ntu_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","Yawe, obqtipxx nzarlapx-krm ninge, Murde mrlzm bange Loukxtr scm. ");
INSERT INTO ntu_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Okatrp ninge mz Nzryrngrkxtr Murde naglqpxx nim mzli ka tqlu-ngrne. ");
INSERT INTO ntu_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Zmrlz ngrm nakqlelvzti-zvzle ninge. Murde kxmule-esz' vecpx-lzbqbo bam, A' trmrbrtitru mz drtwrnge lrpzki rm. ");
INSERT INTO ntu_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Nabz kx nzngrnelzngr Jerusalem mz nzangiongr. Mzli kc tqmnc-ngrne mz nzkxpungr, kqlex Yawe, X ayzlu-ngrmle natqnge. ");
INSERT INTO ntu_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","Rpibo bade kx, “Yawe, arlapxbz ninge Mz leplz kxnzpokiang x nzesabrng.” ");
INSERT INTO ntu_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","?Nimu leplz kxnzpokiang, Krlzpeamu da kx nawaisrngr Yawe nimu? ");
INSERT INTO ntu_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Sa na-ayrplapx-zlwzle nimu Mz nipna sc ncblo ngr vea x mz nyr kxpq zlwz. ");
INSERT INTO ntu_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Nzmnc-lxblr-krgu trka-zlwzm bange, Apule kx mnckr badr leplz kxdrka'-ngrng. ");
INSERT INTO ntu_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Mzli boitx zlwz mnctibo bamu, Nimu leplz kcng tzpxtxpx-ngrdr nrwx. ");
INSERT INTO ntu_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Dekc mzli kc tqryapwxtr-ngrne mz nrwx, Suti alzu drtwrmu nzotangr. ");
INSERT INTO ntu_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Nabz kx nzngrnelzngr Jerusalem mz nzangiongr. ?Myx me narmcti-ngrne kxnaokatrle ninge? ?Sa navzom mz newz ngr nrlc ka? ");
INSERT INTO ntu_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Trtingr. Murde Yawe Kxrpalz kc tqwz-ngrde bongavz x drtc', Nide txpwz kx naokatrle ninge. ");
INSERT INTO ntu_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","4","Da zpwx! Murde Yawe obq zvz, X aclve-angidrle nigu lr Israel, Mz nzapu-krgu sip nedeng. A' tramau x trmwiu, murde ma tqtaoku. ");
INSERT INTO ntu_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Yawe ngi tegu badr, X tu-zvzm mz nibrgu, ");
INSERT INTO ntu_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Murde trtxpnzngr doa x da kx na-atrkatile nigu Mz nrlckxgrlx x mz nrlckxbq. ");
INSERT INTO ntu_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Yawe arlapxle nigu mz nzkxpu-krgung amrlx, Murde namnc-zpwxku. ");
INSERT INTO ntu_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","X aclve-zvzle nzvz-krgu x nzmnc-krgu, Mzli ka x tqyc, tqyc. ");
INSERT INTO ntu_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","2","Nabz ne Devet kx nzngrnelzngr Jerusalem mz nzangiongr. Drtwrnge elalzm mz nzrpi-ngrm bange kx, “Navzdzpeku mz Mangr-nzangiongr Yawe.” Zbz sc tqvztrpekr mz naobz ngr mzteadau nyzde. ");
INSERT INTO ntu_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Jerusalem lc nzlrmztio nzrwzngr, X mzte opx nzmwitr-lxblrkr ma ngrdeng. ");
INSERT INTO ntu_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Nigu neidu lr Israel vzmgu mrlcde mz nzawi-krbzku mz Yawe, Da kc tqwai nzpi-krdele. ");
INSERT INTO ntu_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","X Jerusalem ngi mzteadau nyz king rgung, kcng tzvzpxmqng mz nqvi lr Devet. X nzaclvelr leplz nedrng elr mz nzwxbuo-krdr mz tron. ");
INSERT INTO ntu_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","7","Delc, nakrka'-ngrgu Jerusalem mz nzrpi-krgu kx, “Gct rgr, aclve zpwx nigr lr Jerusalem, Murde leplz nemqng kcng tzmrlztilr nim Namnc-zpwxng mz ma nyzdr, X narmctilr nrwx mz nzmncpx-krmlr mz drkq ngr mzteadau nyzm. ");
INSERT INTO ntu_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","9","Yawe, rlxtibzkr bam Kx na-aclve-kzpzme lr mrnyzgr x kztegrng kcng tzmncng elr. Amrlz zvz leplz amrlx kcng tzmncng elr Mz nzmrlzti-krdr Mangr-nzangiongr nim. Eu, angida.” ");
INSERT INTO ntu_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","Nabz kx nzngrnelzngr Jerusalem mz nzangiongr. Yawe, mnc-xglex nim Mz nzwxbu-krm mz tron nyzm Heven. ");
INSERT INTO ntu_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","X nzmnc-xgle-zvz-krgr nim navz navz nakrlzbzle mzli kx ycngr mz drtwrm nigr. Murde apukr ncblo x olvz kx nzawzng kx nzmnc-xglelr kxnzetu rdrng. ");
INSERT INTO ntu_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Yawe, nayc mz drtwrm nigr mz nzokatr-krm nigr. Murde kxnzakxputing nzapusr-ngrdr nigr brmrda. ");
INSERT INTO ntu_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","X drtqgr satxtrpebz nzxtrngatitrkr kxnzrngiscng nigr, X kxnzglqlz-lzbqng nzobqszo-zvzlr nigr. ");
INSERT INTO ntu_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Nabz ne Devet kx nzngrnelzngr Jerusalem mz nzangiongr. Nigu lr Israel nakrlz-angidrku Kx Yawe ngi-te-zvzku badr mz nzotangr. ");
INSERT INTO ntu_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","X mz nzngi-te-zvz-krgu badr Mzli kc enqmi rgung nzrpilr na-atrkati-ngrdr nigu, ");
INSERT INTO ntu_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","Rblxbz badr nzmilxtxo-krdr nigu Mz nzngyati-zlwzkr drtwrdr nigu. ");
INSERT INTO ntu_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","5","X trnznibqlru nigu mz nzapu-krdr srkau kx mrilvzole nigu. X nrc kxetu ngr srkau lc trabooleu nigu. ");
INSERT INTO ntu_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Delc na-awi-ngrbzku mz Yawe Mz trnzrlr-krpwzleu nigu mz mq enqmi rgung. ");
INSERT INTO ntu_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Mzli lc sc tqapupeku utc mz nzdwapx-krmgu mz br sc kxnzmwang, X drtqgu opxpe murde Yawe pingebzle br scdr. ");
INSERT INTO ntu_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Yawe nide Kxrpalz kc tqwz-ngrde bongavz x drtc', X Mevalu kc tqokatrle nigu, mz zmatq drtqde. ");
INSERT INTO ntu_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Nabz kx nzngrnelzngr Jerusalem mz nzangiongr. Nigu kcng nzabrtrpzlr drtwrdr mz Yawe, Apuku Newz Saeon kx trycngrlru, a' tutx alo. ");
INSERT INTO ntu_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","X Yawe apule newz kcng tztu-ngalelvzlr Jerusalem, Murde vz zvz nztu-krmle mz nibrgu, nigu leplz nedeng. ");
INSERT INTO ntu_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","X tr-rlr-ngrpwzleu mz kxdrka'-ngrng nzaclve-alo-krdr mrnyzgu, nigu kxnztubqng. Murde ma tqvz-nqblqku nqmq krdr kxtrka. ");
INSERT INTO ntu_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Delc Yawe, krka'-ngrgr kx na-amrlzq nigr lr Israel kxnztubqng Mz nzyrlq-angidr-krgr natqm. ");
INSERT INTO ntu_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","A' mzli kc na-ayrplapx-ngrn kxdrka'-ngrng, Mrlzm bagr nzayrplapx-kz-krm kzdung nigr Kcng tzpxtxpx-ngrdr nzvz-nqblqngr nim. A' amnc zpwx nigr lang. ");
INSERT INTO ntu_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Nabz kx nzngrnelzngr Jerusalem mz nzangiongr. Mzli kc Yawe tqamnc-zpwx-mou-ngrde nigu lr Jerusalem, Opxm kx trngiu da zpwx, a' rmwibleku. ");
INSERT INTO ntu_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Mzli lcde, yrpale-twzku x ngr-katoku, mz nzabrtz-zlwz-krgu. Zbz sc tzrpipe lr mrkzbleng kx, “Yawe rwz-ngrbz da kxetuting kx okatr-ngrde nidr.” ");
INSERT INTO ntu_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","X abrtztx-zlwz-ngrgu Da lcdeng tqetuting tqwz-ngrmleng bagu. ");
INSERT INTO ntu_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Delc Yawe, na-amnc-zpwx-mou-ngrde nigu mzli ka, Da kc tqwai tewa nzdc-krde x lrti-moungr ningali kx pztipeng. ");
INSERT INTO ntu_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Murde leplz kcng tzyrning mzli kc tzpe-ngrdr dakxnzng mz drtc', Na-abrtzng mzli kc narkqlz-ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","X leplz kcng tzyrning mzli kc tzrtwz-ngrdr dakxnzng kx napetilr mz nrlanc, Sa nangr-abrtzng mzli kc nartwz-ngrmlr dakxnzng brma mz mzli r nzrkqlzngr. ");
INSERT INTO ntu_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Nabz ne Solomon kx nzngrnelzngr Jerusalem mz nzangiongr. Nzmu Yawe trnangiu Kxetu r nqvi lrgu le, Mane nzaetunepx-krgu nqvi lrgu. Nzmu trna-aukztileu lr mrnyzgu, Mane nzaclve-krgu nidr. ");
INSERT INTO ntu_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Nzmu trna-abrtrpwzkuu drtwrgu mz Yawe Mz nzrka-krmle dakxnzng bagu, Mane nzo-rlangr mz nzwz-katongr x nzyzlu-ngrm mz nina, Murde krlz-kzle nzrka-krmle da bagu mzli kc tqmwi-ngrgu. ");
INSERT INTO ntu_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","5","X Yawe nide kz kx rkam doa kxnztopwzng mz nqvi lrgu, Mzli kc tqngi-oblabe-ngrgu. Murde mzli kc tqngi-lrtzlvzpe-ngrgu, doa lcng na-aclvelr nigu. Sa namrlzbz mz ncblo kc mrlxde tqkqlu. Murde mzli kc kzdq ncblo narnqniti-lzbq-ngrdr bade, Mrlxdeng sa natubzng mz nibrde. X mz nzrka-krbz kxnzrmailzng drtwr kxtubq, Drtqde trnamyau murde nztu-krbz mrlxdeng lcng mz nibrde. ");
INSERT INTO ntu_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Nabz kx nzngrnelzngr Jerusalem mz nzangiongr. Yawe sa na-amrlzle trte kx amrluele nide, X o-zli-zvzle nzti rde. ");
INSERT INTO ntu_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Murde da kx naokatrle lr ma nyzde navzpxm mz nzwz-krde, X na-abrtz-ngrde nzmnc-zpwx-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Olvz nalzde na-apule nc bia kc nrade tqkqlu, Murde doa nedrng kalr na-apulr nrtr ngr nc brpi mz nzwxbu-ngalelvz-krdr nyr pnrde. ");
INSERT INTO ntu_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Delc Yawe tqamrlz-ngrde Trte kx amrluele nide. ");
INSERT INTO ntu_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","6","Yawe, mz nzmncpx-krme Mangr-nzangiongr, Amrlz nigr lr Israel, murde namnc-zpwxkr. X trtegr lcng namc-zvzlr da kxmrlzting kcng tqaleme bagr, nigr lr Jerusalem. X namc-kzlr nzmnckr doa ne doa nedrng, x sc tzbz-ateng. ");
INSERT INTO ntu_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Nabz kx nzngrnelzngr Jerusalem mz nzangiongr. Nigu lr Israel nadcpx mz drtwrgu kx enqmi rgung nzatrkatilr nigu Yzuo mzli kc tqpipzbe-ngrgu mrnyzgu. ");
INSERT INTO ntu_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","A' kxmule-esz' enqmi rgung nzatrkati-zlwzlr nigu, Yzuo mzli kc tqpipzbe-ngrgu mrnyzgu, a' trnzaovxio-pnzlru nigu. ");
INSERT INTO ntu_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","X kxmule-esz' nzikla-zlwzlr nigu, X bzmrde mnz-aboitxtr-alom mz nibrgu, ");
INSERT INTO ntu_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","A' Yawe kc tqtubq-esz'ngr, Aopxpebzle drtqgu mz mqdr. ");
INSERT INTO ntu_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Delc Yawe, nigr lr Saeon rlxtibzkr bam, nzmaneutipx-krbzme enqmi rgrng amrlx, Murde drtqdr namyatx-zlwzng. ");
INSERT INTO ntu_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","X ayangrnga nidr Mzli lc tztopwzbe-ngrdr. ");
INSERT INTO ntu_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","Murde ma tqtakitrde nidr nzota-moungr, Nzmu enqmi rgr kc-kzng tzrlxtibzlr badr nzokatr-krdr nidr mz vea. ");
INSERT INTO ntu_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","X bzkq rlrpx-ngrn nzrpi-krbz badr kx, “Amrlzkr nimu mz drtq Yawe!” ");
INSERT INTO ntu_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Nabz kx nzngrnelzngr Jerusalem mz nzangiongr. Yawe, kqlex nim mz nzokatr-krm ninge Mz mzlir nzkxpu-krngeng. ");
INSERT INTO ntu_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Lalztqm mz nzkrka'-krnge, kx Kxetu, X ayzlum natqnge. ");
INSERT INTO ntu_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Yawe, nzmu napx-ngrn nzipqpx-krm alwx rgrng, Trpnzngr kx narlapxbz mz nzayrplapxngr. ");
INSERT INTO ntu_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","A' oliq-zvzq nzipq-krm nigr, Murde na-amrluekr nim. ");
INSERT INTO ntu_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","6","Yawe, obqtipxx nzokatr-krm ninge. X brti drtwrnge kx sa na-atutrq natqm. Da kc tzwai kxnzaukzng mz nzaenzli-krdr rngalx nzpnamilxtilz-ani-krmle, Murde nzkrlzlr kx nepi sa naprkilz-zvzm mz nourla kang kqlu. A' suti zlwz drtwrnge nzvz-ani-krme, Myaszpxle nzsutikr drtwrdr nzprtz-krm nepi. ");
INSERT INTO ntu_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","X nigu lr Israel, na-abrtrpzku drtwrgu mz Yawe, murde aodu-zvzle nigu. X oliq zvz nzarlapx-krde nigu. ");
INSERT INTO ntu_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","X sa naxpepxle nigu Mz alwx ngrgung amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Nabz ne Devet kx nzngrnelzngr Jerusalem mz nzangiongr. Yawe, trglqpx-lzbqpc'u bam, mz nzvz-lvi-krnge bz kc tqyrlqme bange. X tramatq-lzbqwxu murde naprtrpo mz kxnzetung mz nzycmnetr-krdr mz da kxmyaszpxle nzrkrlz-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Murde abrtz-ngrne nzapu-krnge doa kxtopwz kx yrpz lxede. Delc tqmnc-zpwx-ngrne mz nrlc. ");
INSERT INTO ntu_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","X nigu lr Israel navz zvz nzabrtr-krbzku drtwrgu mz Yawe, Murde namnc-zpwx-kzku. ");
INSERT INTO ntu_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Nabz kx nzngrnelzngr Jerusalem mz nzangiongr. Yawe, na-aoti drtwrm nzkxpukr Devet, Mz nzwztr-krbzle bam. ");
INSERT INTO ntu_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","Nim Gct kc tqrninr tqangio Jekop. X Devet esalzbz bam. ");
INSERT INTO ntu_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","4","Rpibzle kx, “Yawe, trtxpnzngr nzvz-krnge ma nyznge o mz nelvq nyznge, X trtxpnzngr nzama-krnge x nzmwi-krnge, ");
INSERT INTO ntu_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","A' nawzti-kaix dq ma kx namnc-ngrn, Mz nzngini-krm Gct r Jekop.” ");
INSERT INTO ntu_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Mzli kc Devet badr ncblo nedeng tzmnc-ngrdr Efrata, Nzxlrlr nrpa ngr Bokis kc tqyclz-ngrm Nzesz'tikr Drtwrdr Badr Gct. X sc tzrmctipelr mz mztea Jerim mz nrlarnrlc lcde. ");
INSERT INTO ntu_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","X sc tzrpipelr kx, “Naglqpeku Bokis lc mz Tentkxtr nyz Yawe. Mz nzangio-krgu nide mrkc tqwxbu-ngrde mz tron.” ");
INSERT INTO ntu_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","X sc tzrpipebzlr mz Gct kx, “Yawe, vzm mz Tentkxtr nyzm, Murde namnc-zvzq mrkc tqycngr Bokis ngr zmatq ngrm. ");
INSERT INTO ntu_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Murde pris nemqng nayapwxtipxbzlr nztubq-esz'ngr-krm mz leplz nedrng, Kcng na-angrlvzlr nim.” ");
INSERT INTO ntu_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Yawe, mzli ka bzkq pxtxpx-ngrn king rgr kc tqmcpxbzme, A' atutr nzesalz-krbzme mz kxnzawz nem, King Devet. ");
INSERT INTO ntu_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Murde esalz-ngrbzme bade da kx trnzkatxu, Mz nzrpi-krbzme bade kx, “Sa nayrlqbo dq mrlxm kx nanginide king kx na-aclvele lr Israel mz nibrm. ");
INSERT INTO ntu_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","X nzmu mrlxdrng nayrlq-angidrlr nzesz'tikr drtwrgr badr, X navz-nqblqlr natqnge kc tqkapxbo badr, Sa nangini-zvzdr king, Badr mrlxdrng, tqyc tqyc.” ");
INSERT INTO ntu_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Yawe, rlxtibzkr nzamrlz-krm king nem. Murde mcpxq Jerusalem nangi mztea nyzm, ");
INSERT INTO ntu_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","Mz nzrpi-krm kx, “Krlc mztea kx namnc-alo-ngrne, Mz nzvz-nqblq-krde me pnz drtwrnge. ");
INSERT INTO ntu_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Sa nakabo mz lr mztea nyznge lc da kxmrlzting kxkqlu. X sa na-aputrx kxtrnzrngiscung murde nelzdr nakrlc x naesatxpx zpwx. ");
INSERT INTO ntu_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Sa nabatrpo mz pris nengeng nzyapwxtipx-krbzlr mz leplz nengeng nzarlapx-krnge nidr, Murde leplz kxnztr lcng namalqlvzlr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Sa nayrlqx king kc tqmatq Jerusalem kx navzpxm mz nqvi lr Devet, X nzaclve-krde trtxpnzngr nzesaki-krde. ");
INSERT INTO ntu_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Sa na-amyalzx nide mz nzalao-krbo kraon mz narde, A' sa nabatrpo nzmyakr drtq enqmi rdeng.” ");
INSERT INTO ntu_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Nabz ne Devet kx nzngrnelzngr Jerusalem mz nzangiongr. Lqngipx x mrlzvxi Mzli kc leplz tzmnctr-lxblr-ngrdr mz nzesz'tikr drtwrdr. ");
INSERT INTO ntu_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Nzesz'tikr drtwr lqngipx apule nzyrleokr tolo mz nar Eron x nrpnr naode, krlzo-kzpzle lrpzde, Mzli kc tzaelu-ngrde tolo mz nzngini-krde Nardr Pris. ");
INSERT INTO ntu_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","X nzesz'tikr drtwr mrlzvxi apule nzdco-krm tewa Mz newz nyzgung mrkc tqmingr zvz. Murde da kc tqmrlzting amrlx tqkam Yawe bagu nzvzpxmqng Jerusalem, Myapxbz nzmnc-zpwx-zvz-krgu mz drtc' nyzgu. ");
INSERT INTO ntu_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Nabz kx nzngrnelzngr Jerusalem mz nzangiongr. Naglqpxku Yawe, nigu kxnzawz nedeng. Naprtrku mz Mangr-nzangiongr nide. ");
INSERT INTO ntu_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Glalzku mqgu Mrkc Tqtr. Glqpxku Yawe mz nrlckxbq. ");
INSERT INTO ntu_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","X krka'-ngrgr kx Yawe na-amrlzle nimu mz nzmnc-krde Mzteadau nyzde. Nide kc tqwz-ngrde bongavz x drtc'. ");
INSERT INTO ntu_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","2","Nabz kx nzngrnelzngr Jerusalem mz nzangiongr. Naglqlz-zvzku Yawe, Murde nide Gct rgu. X nigu kxnzawz nedeng na-amrlueku nide Mz nzkrka'-krmu mz Mangr-nzangiongr x makoa ngrde. ");
INSERT INTO ntu_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","Na-amatqku nide murde mrlz-esz'ngr. X na-angrlvz-ngrgu nide nivz lrde. ");
INSERT INTO ntu_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Murde mcpxle nqvi lr Jekop, nigu lr Israel, Mz nzngini-krgu leplz nedeng. ");
INSERT INTO ntu_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Krlzku kx Kxetu rgu, Yawe, nide Gct kc tqmyatxlz-esz'ngr, Myaszlzle kxnzmncng mzlilxlr amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Vz-nqblq-txpwzle me pnz drtwrde mz da kx alele Kxmule-esz' mz bongavz, nrlc, prla, x me boo-ngrng. ");
INSERT INTO ntu_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Wz-ngrde zbo nzvzdz-krdr mz lclxlr mz bongavz, X bzlrpc nzvzmi-krm trlipu le. X batrpzle nzwqkr nenq. ");
INSERT INTO ntu_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Sc tqnibqtile ncblo kx ayrnrngr Ijipt, Kr neng leplz x kr neng animol. ");
INSERT INTO ntu_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","Rwzngr da kxnzkctipxng kxkqlu mrlcde, Mz nzayrplapx-krde king rdr x kxnzetu nedeng. ");
INSERT INTO ntu_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Aovxiole lr mrkzbleng kxkqlu Mz nznibqti-krde king kxnzxplr-zlwzng. ");
INSERT INTO ntu_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Krlcng King Sihon, King Og, x kzdu-kzng king Kcng tzaclveng mz drtc' Kenan. ");
INSERT INTO ntu_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","X drtc' nyzdrng katimleng bagu, Nigu lr Israel, da kc tqwai nzpi-krmlele bagu. ");
INSERT INTO ntu_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Nqmq kr Yawe tqyc tqyc. X nzrkrlzngr drtqde tqvzpe tqvzpe. ");
INSERT INTO ntu_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","Yawe sa napipxbzle mz leplz nedeng kxnzvz-rbrng o trtingr, X sa na-aodu-zvzle nidr. ");
INSERT INTO ntu_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Kxnzmnc-mrbrng nzangiolr mqngr da kx nzlz, Kcng tzwzngr ncblo mz silvz x gol. ");
INSERT INTO ntu_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Mqngr da kxnzlz lcng naodr x mztr ycbz, A' trnzycmneung x trnzrmcung da. ");
INSERT INTO ntu_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","Nradrtqdr x nctqdr ycbz, A' trnzxlrung da x trnzycmini-kzung. ");
INSERT INTO ntu_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Leplz kcng tzrwz-ngrng nzapu-kzlr mqngr lcng. Murde nznabung, trnzobqung, nradrtqdr ngq, x trpnzngr nzlungr badr. ");
INSERT INTO ntu_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","A' Nigu nqvi lr Israel, naglqlzku Yawe. X nimu pris, nqvi lr Eron, na-amrlue-kzamu nide. ");
INSERT INTO ntu_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","X nimu kxnzawz nedeng, nqvi lr Livae, na-amatqamu nide. Nigu amrlx kcng tzamrluelr nide, na-angrlvzku nide. ");
INSERT INTO ntu_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Na-angioku Yawe Jerusalem, mz Newz Saeon. Naglqlz-zvzku Yawe. ");
INSERT INTO ntu_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Aodu-zvzle nigu. Awi-ngrbzku bade Mz nzmrlz-esz'ngr-krde. Aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","3","Aodu-zvzle nigu. Kxetu r kxnzetung Myaszlzle kxnzmncng mzlilxlr. Aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","5","Aodu-zvzle nigu. Wz-ngrde rkx kxmatq, Bongavz mz nzyrplapx-krde. Aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Aodu-zvzle nigu. Wznedz-ngrmle drtc' Me boongr prla. Aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","8","Aodu-zvzle nigu. X wz-ngrde nepi Nayzlr mz nrlckxngrlx. Aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","Aodu-zvzle nigu. Wz-ngrde temz badr vri Nayzlrng mz nrlckxbq. Aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Aodu-zvzle nigu. Nibqtile enqmi rgung, Kxmztr nzmc kai ne lr Ijipt. Aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","Aodu-zvzle nigu. Rkamilzmle nigu Lr Israel mz mzlir lr Ijipt. Aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","14","Aodu-zvzle nigu. Mz zmatq ngrde kx xplr, Akipxle Prla Bla. Aodu-zvzle nigu. Aodu-zvzle nigu. X mailzkimle nigu, Leplz nedeng mz nzti rde. Aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","Aodu-zvzle nigu. A' rtco-ngrde prla King x ami r lr Ijipt. Aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","Aodu-zvzle nigu. X mailztrle nigu Leplz nedeng lzke. Aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","18","Aodu-zvzle nigu. Nibqtile king kxnzxplrng. Apoopemle king kxnzmatqng. Aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Aodu-zvzle nigu. Nibqle King Sihon, King r lr Amctq. Aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","Aodu-zvzle nigu. X aovxiole King Og, Kc tqngi king r lr Basan. Aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","22","Aodu-zvzle nigu. Aprcmle drtc' nyzdr Bagu, nigu lr Israel. Aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Aodu-zvzle nigu. Trmrbrtru mz drtwrde Nzkxpu-zlwz-krgung. Aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","Aodu-zvzle nigu. Arlapxbzle nigu Mz mq enqmi rgung. Aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Aodu-zvzle nigu. X rkabz dakxnzng Mz krkcng tzlung amrlx. Aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Aodu-zvzle nigu. Glqlzku Gct kc Heven, X awibzku bade, aodu-zvzle nigu. ");
INSERT INTO ntu_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Kx dcpx mz drtwrgr nzodatingr Jerusalem, Sc tqyrnipekr mz nzwxbune-krgr mrkzble mz nqlvi r ningaling Bxbilon. ");
INSERT INTO ntu_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","X gita negrng adotxlzpekrng Mz nounc kx nztung mrlcde. ");
INSERT INTO ntu_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","Krkcng tzlolvztilr nigr, tzxtrnga-ngrdr nigr, nzrpimlr bagr kx, “Ngr-ngrmamu du bagr nabz kxtr nemung.” ");
INSERT INTO ntu_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","A' mz drtwrgr rpikr kx, “Rblx nzngr-abrtz-krbzkr mz Yawe, Mz nzmnc-krgr mz mztea nyz kxtrnzrlxngitiung. ");
INSERT INTO ntu_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","Murde nzmu kx tqmrbrtitr drtwrnge Jerusalem, Namrbrtitr kz drtwrnge kxmu nzayrni-krnge gita nenge. ");
INSERT INTO ntu_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","X nzmu kx tqrblx nzdcpx-kaikr Jerusalem mz nabznge, Narblx kz nzngr-krnge nabz ngrdeng.” ");
INSERT INTO ntu_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","Yawe, nadcpxpwz mz drtwrm alwx ngr lr Edom. Murde mzli kc lr Bxbilon tzodati-ngrdr Jerusalem, Sc tzrpibzlr badr kx, “Odatiamu! Odatiamu x natutx-lxlrngr.” ");
INSERT INTO ntu_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Yawe, rlxtibzkr bam nzamrlz-krm ncblo kc naodati-atwrnr-ngrde lr Bxbilon, Mz nzayzlu-krbzle badr da kcng tzwaisr-ngrdr nigr. ");
INSERT INTO ntu_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Murde na-abrtz-ngrde nzlolvzti-krde doa lcng, Mz nztamyrtitx-krde nidr. ");
INSERT INTO ntu_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Nabz ne Devet. Yawe, awibo bam mz nabznge atwrnrngr. X angrlvzx nim mz mz kxnzmatqng. ");
INSERT INTO ntu_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Lxlvrkibo Mangr-nzangiongr nim mz nzglqlz-krnge drtqm. X awi-ngrbo bam nqmq krm, Nzaodu-krm, x nzangidati-krm. Murde drtqm x natqm nzmyatxpx-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Mzli kc tqkrka'-ngrbo bam, ayzlume natqnge, Mz nzaetunepx-krm nzxplr-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Yawe, king amrlx mz nrlc sa naglqlzlr nim, Mz nzxlr-krdr nzmrlzkr natqm. ");
INSERT INTO ntu_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","X sa na-angrlvzlr kxmu nzale-krmqng da, Mz nzmc-krdr kx myatxlz-esz'ngrn. ");
INSERT INTO ntu_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Kxmule-esz' myalz-esz'ngrn, a' sc tqaclve-zvzq kxnzavzo-lzbqng. X avzome kxnzglqpx-lzbqng. ");
INSERT INTO ntu_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","X kxmule-esz' nzkxpungr nzprtzmqng bange, a' amnc-zpwxq ninge. X tu-zvzme mz nibrnge mz nzngyatikr drtwr enqmi rngeng ninge. X arlapxq ninge mz zmatq ngrm. ");
INSERT INTO ntu_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Yawe, krlzx kx sa na-angidatiq drtwr amrlx kcng tqyrlq-pz'liti-ngrn ninge. Murde nzaodu-krm tqyc tqyc. Bzkq esaki nzaclve-krm krkcng amrlx tqwz-ngrn. ");
INSERT INTO ntu_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Yawe, obqplxq nabznge, X krlz-atwrnr-ngrn ninge. ");
INSERT INTO ntu_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Krlzq da amrlx kcng tqalex. Kxmule-esz' mncme rlru, a' krlz-zvzq nzao-krnge drtwrnge. ");
INSERT INTO ntu_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Kxmule-esz' wzx o amax, a' sa tqmc-zvzq ninge. X krlz-kaiq da amrlx kcng nartrngztibo mz zbq kxesz'. ");
INSERT INTO ntu_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Abzo pnz mzli kc trycmneka-ngrne Nzkrlz-kai-krm natq kznike napixng. ");
INSERT INTO ntu_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Zmatq ngrm okatrle ninge Mz nztu-ngalelvz-krde ninge. ");
INSERT INTO ntu_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Nzkrlz-krm ninge etu zlwz. X trtakitrpwc'u nzrkrlz-krm. ");
INSERT INTO ntu_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","?Drlve kc navzkix murde trnamcwq ninge? Trpnzngr kxnamule lc murde esz'-ngrn nrlc. ");
INSERT INTO ntu_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","X kxmule-esz' vzdzx Heven, a' sc tqmncq elr. X kxmule-esz' bzx x nzyrtzmqnge, a' sc tqmnc-kzq elr. ");
INSERT INTO ntu_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Kxmule-esz' alilvc-kzx me prkilzm nepi O me takiole, ");
INSERT INTO ntu_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","A' sc tqmncq elr mz nzokatr-krm ninge X nzrmailz-krm ninge mz mqm. ");
INSERT INTO ntu_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Kxmule-esz' mnc-kapqx mz nzlo X mz drtwrnge nrlckxngrlx nangitx nrlckxbq, ");
INSERT INTO ntu_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","A' nzlo x nrlckxbq rblx nzamnc-kapq-krdr ninge, Murde nzlo x zyzlr kxnamu-txpwzlr esz' mz nzobq-krm. ");
INSERT INTO ntu_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","15","Murde mzli kc tqmclq ninge mz nelz lxenge Nim txpwz kx rkrlz nzmnc-lrpipx-krmc mrlcde. Wz-ngrn dalr nrkrdrtqnge x nrvr rngeng. X amwitr-lxblr-kzqng amrlx, mz nzvz-nqblq-krde me pnz drtwrm. X kctipxx x awitx-ngrbo bam Nzlrmztio-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","X mzli kc trnzmckangr mzke', Yrlqpe-kaiq me nakrlzbz me nangi bz ngr nzlu-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","A' rblxm bange nzkrlz-angidr-krnge nzao-krm drtwrm Murde nzkqlu-zlwzng. ");
INSERT INTO ntu_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","A' nzmu narlwxxleng drtwrnge mrbrtrpz, Murde nzmyaszpxlr drta' ngr prla amrlx. X kxmule-esz' nayrkrpx nzrlwx-krngeleng, A' tryatrkapc' nzkrlz-angidr-krnge nim. ");
INSERT INTO ntu_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Murde rblxbep bange drtwr ngr nqmq krm. ?Memule tqasa-ngrn nzayrplapx-krm kxdrka'-ngrng? ?Myx kxmule trnamilxtxokalq nidr? ");
INSERT INTO ntu_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Murde nzpiti-ngrdr nim natq kxtrka, X nzrnzlvzolr nqmq krm. ");
INSERT INTO ntu_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","22","Yawe, pxtxpx-ngrne krkcng tzpxtxpx-ngrdr nim x ni-kzdr enqmi rngeng. Murde trnzmnclzpwzung mz zmatq ngrm. ");
INSERT INTO ntu_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Gct, obqplxti zpwx nqmq nr nabznge Mz nzkrlz-krm nzao-krnge drtwrnge. ");
INSERT INTO ntu_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Murde na-aelwa-ngrme bange nqmq krnge kxtrka, X namailzq ninge mz nzti kxtubq. ");
INSERT INTO ntu_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","Nabz ne Devet kx yrbzle mz kxrmailz ngr dzbe kxnzngrng. Yawe, arlapxbz ninge mz kxdrka'-ngrng Kcng tzsuti drtwrdr nzatrkati-krdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","Nzryrlq-zvzng drtwr kxtrka mz nabzdr, X nzapqtr-zvzlr drtwr ngr nzotangr. ");
INSERT INTO ntu_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Natqdr nzlvati apule nipna kr ningidoe kc tqrtq, Mz nzrpikitingr x nzrpibqtingr. ");
INSERT INTO ntu_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","Yawe, arlapxbz ninge mz zmatq ngrdr. X aclve-angidrbz ninge mz krkcng tzryrlqng drtwr kx na-atrkati-ngrdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Sc tzglqpx-lzbqng nzamwi-kapqlr trtxki kx naprtz-ngrne mz nzatu-krdr br mz nzti rnge. X tzryrlqng drtwr kx nalolvz-ngrdr ninge. ");
INSERT INTO ntu_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","Yawe, xlrm nzkrka'-krnge, Murde rpi-zvzbo bam kx, “Yawe, nim Gct rnge.” ");
INSERT INTO ntu_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","Kxetu rnge, nzxplr-krm arlapxle ninge. X amyaq narnge mz nzvecngr. ");
INSERT INTO ntu_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","Bzkq rlr-ngrbzme nzngidatikr drtwr kcng tzyrlq kxdrka'-ngrng lcng Mz nzbilvz-krdr nzlolvz-krdr ninge, kxmule-esz' nzsuti zlwz drtwrdr. ");
INSERT INTO ntu_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Enqmi lcng tztu-ngalelvzlr ninge. Batrpz nzayzlu-krbz badr natq ngr zngya kcng tzpimlr bange, murde nangq-moule nidr. ");
INSERT INTO ntu_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","X nyr natatiom nangc-ngrdr, X nartctiongr nidr mz gq kx trnarlapx-ngrdru. ");
INSERT INTO ntu_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Suti drtwrnge kx krkcng tzpokiang nzmnc-krdr mz drtc' natangqneo. X da kxtrka nadwatibzle krkcng tzota-zvzng mz nzodati-krde nidr. ");
INSERT INTO ntu_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Yawe, krlzx kx tu-zvzbzme mz nibr kx trpnzngr scde zmatq, X okatrq kxnzkxpung mz nzatubqti-krm da kx vz-rbr. ");
INSERT INTO ntu_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Leplz kxnztubqng sa na-awibzng bam, X namnc-zvzamu badr. ");
INSERT INTO ntu_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","Nabz ne Devet. Yawe, kqle-zvzx nim. Xlrm natqnge. Vz-anim x okatrp ninge. Yawe, kqle-zvzx nim. ");
INSERT INTO ntu_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Abrtzlvz nzkrka'-krnge nzvzdz-krbzle bam na-apule zsikapu ngr bqlr nc ninz kc tzangcbz bam. X nzglalz-krnge mqnge na-apubzle bam blz ngr milzpq. ");
INSERT INTO ntu_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Yawe, mailz ninge murde ma tqrpitix natq kxtrka, A' nzycmne-krnge natubqpwz. ");
INSERT INTO ntu_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Bzkq rlr-ngrme nzsutikr drtwrnge da kxdrka'ngr, Murde ma tqprtrpo badr kxnzaleng alwx Mz nzale-krdr da kxvz-rbr, X ma tqprlvz mzke' da kxtrka. ");
INSERT INTO ntu_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","A' mz nzprtr-krbo badr, mrlzvxitx nzayrplapxngr ninge. Murde nzatubqtingr apule tolo ngr nzamrlzngr. Bzkq narnge mqngi, Murde krka'-zvz-ngrne kx nayrlqpx-lzbqnge mz nzvz-rbr-krdr. ");
INSERT INTO ntu_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","X ncblo sa na-abrtz-ngrdr natq ngr nzatubqti-krnge nidr Mzli kc namc-ngrdr nzbzkr kxnzetu r kxdrka'-ngrng mz nzayrplapxngr nidr. ");
INSERT INTO ntu_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","X nrvr ngrdr sa natwzbetxne mz drtc' Mz nzapu-krdr lrdz kcng tqalvxlz nrc. ");
INSERT INTO ntu_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Yawe, nim Gct rnge, abrtr-zvzbo drtwrnge bam. Nanginim lrpalvc nyznge, murde ma tqmnc-lxlrx. ");
INSERT INTO ntu_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Mailz ninge murde ma tqprtzx mz trtxki sc kxdrka'-ngrng, X ma tqtaox mz gq kx nzekqtilr. ");
INSERT INTO ntu_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Mrlzvxitx nzdwatr-mou-krdr mz br scdr, A' drtqnge naopx zvz. ");
INSERT INTO ntu_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Nabz ne Devet mzli kc tqmncpx-ngrmle mz butqbr. Yawe, yrni-katobo bam, Murde naokatrq ninge. ");
INSERT INTO ntu_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","X pibo bam da kx lctr-ngrbz drtwrnge, X nzkxpungr kcng tqprtzmqng bange. ");
INSERT INTO ntu_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Kxmule-esz' nabznge baonepe, a' nim kc tqrtwayz zvz mz nzvz-krnge. Murde enqmi rngeng nzryrlq-kapqpeng trtxki mz lrpzki rnge. ");
INSERT INTO ntu_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","X kx obq-ngalex kc nrlc, trpnzngr kx mcx kx naokatrle ninge, X trpnzngr kz kx na-aclve-zpwxle ninge. ");
INSERT INTO ntu_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Yawe, kqlex nim, Murde nim me rlakitrx, x nim nou nzmnc-zpwx-krnge. ");
INSERT INTO ntu_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Ayzlum natqnge Murde nabznge talvzo zlwz. ");
INSERT INTO ntu_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Aopxbz drtqnge mz nzkxpu-krngeng murde na-awibo bam, X kxnztubqng natu-ngalelvzlr ninge mz nzglqlz-krdr nim mz nzamrlz-zlwz-krm ninge. ");
INSERT INTO ntu_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Nabz ne Devet. Yawe, xlrm nzkrka'-krnge x ayzlum natqnge, Murde tubq-esz'ngrn x angidati-zvzq. ");
INSERT INTO ntu_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Bzkq ayrplapxq ninge, kxnzawz nem, Murde trpnzngr leplz mz nrlc kxtubq mz nzobq-krm. ");
INSERT INTO ntu_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Enqmi rngeng nzmaneutilr ninge x nzrnzbrtiolr ninge mz drtc', X nzadwatrlr ninge mz nzlo, apux kxbz kx mnclzm mz gq. ");
INSERT INTO ntu_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Nabznge baonepe, X talvzo zlwz. ");
INSERT INTO ntu_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","A' amqtrx drtwrnge mz nzaotikr drtwrnge zbq kcng tqvztxpeng. X dcpx mz drtwrnge da kxnzkctipxng kcng tqalemeng bagr. ");
INSERT INTO ntu_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Delc tqglalz-ngrbo mqnge bam, Murde brlxkztitx zlwz drtwrnge nim. ");
INSERT INTO ntu_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Yawe, ayzlu-anim natqnge murde nabznge baonepe. Bzkq rlaszq ninge, murde ma tqbzx. ");
INSERT INTO ntu_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","A' pi-zvzm bange mz rngalx kang kqlu kx aodu-zvzq ninge, Murde abrtrpo drtwrnge bam. X mailz ninge mz lrpzki kx nao-zlix, Murde mnc-xgle-zvzx nim. ");
INSERT INTO ntu_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Yawe, bzkq rlr-ngrbzme mz enqmi rngeng nzlolvz-krdr ninge, Murde nim me rlakitrx. ");
INSERT INTO ntu_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Gct rnge, alvztrp bange nzale-krnge me pnz drtwrm. X rtwayzm bange mz zmrlz ngrm, murde namnc-zpwxx. ");
INSERT INTO ntu_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Yawe, arlapx ninge da kc tqwai nzpi-krmle murde ma tqbzx. X tum mz nibrnge mz nzkxpu-krngeng amrlx, murde tubq-esz'ngrn. ");
INSERT INTO ntu_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Lolvzting enqmi rngeng x milxtxo alo nidr. Murde aodu-zvzq ninge, kxnzawz nem. ");
INSERT INTO ntu_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Nabz ne Devet. Yawe, glqpxx nim, murde nim butqbr nyznge. X alvztrpe' bange nzrpnangr x axplrq ninge mz nzotangr. ");
INSERT INTO ntu_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Brti drtwrnge nzngini-krm lrpalvc nyznge. Nim Mevalu kx xplr x me rlakitrx. Nim temz ngr lomrnge kc tqyrputrngr nipna. X okatr-zvzq ninge mz nzaovxio-krnge lr mrkzbleng. ");
INSERT INTO ntu_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","?A' memule tqmatq-ngrgr mz drtwrm? ?X memule tqmrlzti-ngrn nigr leplz txneng? ");
INSERT INTO ntu_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Nzmrbcnekr nzlukr leplz apule nzyrplaokr nrc kxesz'. X apu-kzle zmio kc tqmrbr mz milzpq. ");
INSERT INTO ntu_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","Yawe, lvxpx bongavz mz nzvzo-krme. Maletr newz murde nasikapung nzapulr trmami. ");
INSERT INTO ntu_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Atwzlro-ngrm bzlrpc mz nzaodaliti-krm enqmi rngeng. Pnzting nidr mz nipna scmqng murde navotxng. ");
INSERT INTO ntu_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Yawe, rtrngztiom ninge mz nzokatr-krm ninge, Na-apule kx veclzme ninge me boongr prla. X arlapxbz ninge mz mq lr mrkzbleng. ");
INSERT INTO ntu_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","Murde nzmrlzti-txpwzlr nigr mz nzycmne-krdr. A' trnzatutrlru nzesz'tikr drtwrgr badr. ");
INSERT INTO ntu_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","Gct, sa nangr-ngrbo bam nabz kxmrna. X na-angrlvzx nim mz nzayrni-krnge gita. ");
INSERT INTO ntu_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","Murde okatr-zvzq king nemqng mz nzaovxio-krdrng. X sc tqarlapxpebzme ninge mz toki r vea kxmalc, murde ninge kxnzawz nem. ");
INSERT INTO ntu_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Mzli ka arlapx-mopwz ninge mz mq lr mrkzbleng murde nzmrlzti-txpwzlr nigr mz nzycmne-krdr. A' trnzatutrlru nzesz'tikr drtwrgr badr. ");
INSERT INTO ntu_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Delc mz nzkqlukr enqmi rgrng, Krka'-ngrgr kx na-amrlzq nigr lr mrnyzm. Murde obla negrng naxplrnelzm mz nzapu-krdr nounc kx xplr. X olvi negrng naxplr-kzng x mztr nalqngi mz nzapu-krdr nctrpou ngr ma nyz king. ");
INSERT INTO ntu_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Dalr nrlanc nyzgrng nalvc-angidrng, Murde bxli scgrng nayrbu zvz mz dakxnzng. X animol negrng naeloting Murde neidrng nayrlwrtxne. ");
INSERT INTO ntu_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","X kxnzrmailz rgrng na-ale-zpwxlr nzwz-krdr, Murde leplz ma tztangetrplr drkq ngr mztea nyzgr mz nzvzmi-krdr nigr mrnyzdr, X lr mztea nyzgrng ma tzodalineng mz nzvzdz-krm nelzdr. ");
INSERT INTO ntu_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Yawe, leplz kcng tqokatrq mz da lcng, sa na-abrtz-ngrdr nzmnc-zpwx-krdr. Murde leplz amrlx kcng tqnginim Gct rdr sa namnc-zpwx-zvzng. ");
INSERT INTO ntu_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Nabz ngr nzrglqpxngr ne Devet. Awi-zvzbo bam mz nzglqpx-krnge nim, Murde nim Gct rnge x mnclzbo bam. ");
INSERT INTO ntu_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Bilvzx nim mz nzawi-krbo bam. X sa naglqpx-zvzx nim mz zbq kang kqlu. ");
INSERT INTO ntu_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Clveq nrlc mz zmatq ngrm kx trpnzngr kxrkrlz. Yawe, myatxlz-esz'ngrn x takitrde nzrglqlzngr nim. ");
INSERT INTO ntu_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Doa nemqng sa nayapwxti-zvzbzlr mz doa nedrng, Da kcng tqetuting tqmatq tqaletiqng. ");
INSERT INTO ntu_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Eu, x sa na-aoti-zvz-kzx drtwrnge nzwz-krmqng kxmrlzvxing, X nzetu-esz'ngr-krm mz zmatq. ");
INSERT INTO ntu_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Gct, sa nayapwxtipx leplz da kxnzkctipxng kcng tqwz-ngrn. X sa napipxx nzmyalz-esz'ngr-krm. ");
INSERT INTO ntu_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","8","Ipq-aniq leplz murde yc mz drtwrm nidr. Murde nivz lrm x nzaodu-krm tqyc tqyc. Jzsiq leplz mz nztubqngr x sa na-angrlvzlr nim. Sa nalepxlr nrpa ngr nzmrlz-esz'ngr-krm. ");
INSERT INTO ntu_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Kxetu, mrlztiq leplz amrlx, X yc zlwz mz drtwrm doa amrlx kcng tqwz-ngrn. ");
INSERT INTO ntu_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Leplz nemqng amrlx sa na-awibzng bam, X doa amrlx kcng tqwz-ngrn sa naglqlzlr nim. ");
INSERT INTO ntu_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Mz nrlc tulvzo, sa nayapwxtipxlr nzmyalz-esz'ngr-krm, X nzetukr zmatq ngrm mz nzngini-krm king. ");
INSERT INTO ntu_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","Nrpa ngr nzwz-krmqng etu, mz da kxmrlzting kcng tqwz-ngrn mz nzaclve-krm, Sa nakrlz leplz amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Obqom mz nrlc mz nzaclve-krm kc tqyc tqyc, X nzngini-krm king tqvzpe tqvzpe. Pipx-zvzq natq kx na-angidatiq, X aelwapx-zvzq nivz lrm mz da amrlx kcng tqaleq. ");
INSERT INTO ntu_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Rngiscm zmatq kx okatrle leplz kcng tzkxpung, X axplrle nabz leplz kcng tqtalvzo. ");
INSERT INTO ntu_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Sa narkabzme dakxnzng mz kxnzlung amrlx, Mz nzmnc-xgle-krdr nim mz da amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Tekqtrq nzbrtale-krdr mz nzakrlc-krbzme nelzdr, X drtwrdr esatxpx zpwx. ");
INSERT INTO ntu_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Vz zvz nzale-krm da kx tubq-esz'ngr, X aelwapx-zvzq nivz lrm mz da amrlx kcng tqaleq. ");
INSERT INTO ntu_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Wxbu-aepztrpzme mz krkcng tzkqlelr nim, Mz nzbrti-zpwxkr drtwrdr nim. ");
INSERT INTO ntu_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Xlrq nzyrnikr leplz kcng tzamrluelr nim, X ayzlubzme natqdr mz nzarlapx-krm nidr. ");
INSERT INTO ntu_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Yawe, tu-zvzbzme mz nibr leplz kx nzmrlztilr nim, A' odati-atwrnr-ngrn kxdrka'-ngrng. ");
INSERT INTO ntu_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Zbq kalvz sa naglqlzx nim. X krkcng tzlung tqwz-ngrn, nzangio-krdr nim tqvzpe tqvzpe. ");
INSERT INTO ntu_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Naglqlzku Yawe! Na-angiox nide mz nabznge. ");
INSERT INTO ntu_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Naglqlzx Gct rnge mzli ka tqlube-ngrne, X na-angrlvzx nide. ");
INSERT INTO ntu_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Bzkq abrtrpzku drtwrgu mz kxnzrmailzng, Murde leplz trnzkrlzlru nzarlapx-krdr nigu. ");
INSERT INTO ntu_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Nabzng x nzyrtzmqng mz drtc', X mzli lcpwz drtwr kcng tzyrlqlr botxpx-kzpz. ");
INSERT INTO ntu_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","A' nangi da kxmrlz nzabrtr-krbzku drtwrgu mz Yawe. Murde takitrde mz nzmnc-xgle-krgu Gct r Jekop. ");
INSERT INTO ntu_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","X Yawe nide Kxrpalz, Kc tqwz-ngrde bongavz, nrlc, x prla, x dalrdrng amrlx. X atutr-zvzle natqdeng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Nzatubqti-krbz Yawe da mz kxnzkxpung tubq. X rka-zvzbz dakxnzng mz kxnzbrtaleng. X aopxbzle drtq kxnzmnclzbzng mz mq enqmi rdrng. ");
INSERT INTO ntu_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","9","X nide kz kx aopxbzle mzku. X atulzmle kxnzobqszong. Yawe aclvele lr mrkzbleng kx mnckung badr. X okatrle kxnzbzszng x kxnzabzong. Mrlztile kxnztubq nedeng, A' odatile drtwr kcng tzyrlq kxdrka'-ngrng. ");
INSERT INTO ntu_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Yawe ni-alode King! Nzaclvekr Gct rgu, nigu lr Jerusalem, tqvzpe tqvzpe. Naglqlzku Yawe! ");
INSERT INTO ntu_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Naglqlzku Yawe! Mrlzvxitx nzangrlvz-krgu Gct rgu. Brngzvxitx x takitrde nzglqlz-krgu nide. ");
INSERT INTO ntu_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Yawe yrlq-zpwx-moule Jerusalem, Mz nzvzmi-kr-mople lr Israel kcng tzlolvzting enqmi rdrng. ");
INSERT INTO ntu_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Rka-mopwz nzabrtzngr mz leplz lcng drtwrdr tqtalvzo, Mz nzawxo-krbzle drtwrdr apule kx pnutibzle kxsqki rdr. ");
INSERT INTO ntu_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Krlzle me krlzbz nzkqlukr vri, X yrlqtibzle drtqdrng amrlx. ");
INSERT INTO ntu_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Yawe etu-esz'ngr x rngisc zmatq kx xplr. X trpnzngr kx rkrlzlzbz nzyrplapx-krde. ");
INSERT INTO ntu_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Atubxlzle kxnzobqszong, A' rnzbrtiole kxdrka'-ngrng mz drtc'. ");
INSERT INTO ntu_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Nangr-ngrgu nabz kx yrlvi mz nzayrni-krbzku gita mz Yawe, Mz nzawi-krbzku bade. ");
INSERT INTO ntu_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Murde yrlqtibzle dcbz mz bongavz x adco-ngrmle tewa nalrprngr drtc', Murde nalutingr nabr kxvo mz nra. ");
INSERT INTO ntu_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Rkabz dakxnzng mz animol amrlx, X aputrle nei utc amrlx mz nzyrni-krbzlr bade mz dale ngr nelzdr. ");
INSERT INTO ntu_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Delc trmrlz-ngrpwzleu mz Yawe nzabrtr-ngrbzku drtwrgu mz nzxplrkr hcsi ngr vea negung, X nzaovxiokr ncblo ngr vea negung. ");
INSERT INTO ntu_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","A' mrlzbz bade krkcng tzamrluelr nide, X tzmnc-xglelr nzaodu-zvz-krde nidr. ");
INSERT INTO ntu_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","Nigu lr Jerusalem kcng tzangiolr Yawe mz Newz Saeon, Naglqlzku nide, kc tqngi Gct rgu. ");
INSERT INTO ntu_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","14","Murde amqngitibzle naonrx ngr Jerusalem x bz ngr mrnyzgr. Amrlz-zvzle lr mzteadau nyzde, X amnc-zpwxle nigu leplz nedeng amrlx Mz nzrka-krmle bagu da kxmrlzting. ");
INSERT INTO ntu_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Mzli kc tqycmnepx-ngrde Dalr nrlc nzvz-nqblq-anilr natqde. ");
INSERT INTO ntu_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Mz mzli r zbao, sncu prlxlvztxde drtc' apule lrpz kxprki. X dcbz vzom mz nrlc apule zsikapu. ");
INSERT INTO ntu_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","X muli-aes rlxom mrkcng amrlx. Murde da amrlx lcng nayclzbzng mz zmatq ngr zbao. ");
INSERT INTO ntu_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","A' mz nzycmne-mou-krde, nrlc kc tqpqpe, X nzwqkr nenq kxpq ayrle-mouleng lue kcng tqngi aes. ");
INSERT INTO ntu_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","X natq lc tqmatq tqpim Yawe bagu, nigu leplz nedeng, Murde nayrlq-angidrku nzalvztr-krdeng x Loukxtr scde. ");
INSERT INTO ntu_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Trpipxpwzleu lou scdeng mz lr mrkzbleng, A' nigu txpwz, mz nzngini-krgu leplz nedeng. Naglqlzku Yawe. ");
INSERT INTO ntu_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","2","Glqlz-zvzamu Yawe, nimu lr Heven amrlx. Nimu enjrl nedeng, glqlz-zvzamu Yawe. ");
INSERT INTO ntu_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Glqlz-zvzamu Yawe, nepi ncdr temz. X nimu vri amrlx, glqlz-zvzamu Yawe. ");
INSERT INTO ntu_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Glqlz-zvzamu nide, dalr bongavz amrlx. X nimu lue kcng wq, glqlz-zvzamu nide. ");
INSERT INTO ntu_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Glqlz-zvzamu drtqde. Kxrpalz wz-ngrde nimu, Mz natq kx kapxle. Glqlz-zvzamu drtqde. ");
INSERT INTO ntu_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Natqde tqyc tqyc. Yrlqti-lxblrbzle Me namnc-alo-ngrnamu. Natqde tqyc tqyc. ");
INSERT INTO ntu_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Glqlz-zvzamu Yawe, nimu nc x mepwz amrlx Ngr prla x me boongr. Glqlz-zvzamu Yawe. ");
INSERT INTO ntu_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","Vz-nqblqamu natqde, bzlrpc x muli aes. Dcbz, nenq x tewa, vz-nqblqamu natqde. ");
INSERT INTO ntu_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","Glqlz-zvzamu Yawe, newz x nra amrlx. Nimu nounc ngr peto, glqlz-zvzamu Yawe. ");
INSERT INTO ntu_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","Glqlz-zvzamu nide, animol x utc amrlx. X da kx nzngrlaneng, glqlz-zvzamu nide. ");
INSERT INTO ntu_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","Naglqlz-kzku Yawe, nigu lr nrlc amrlx. Kxnzetung x kxnzrmailzng, naglqlz-kzku Yawe. ");
INSERT INTO ntu_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","Naglqlz-kzku nide, nigu obla x olvi. Itoto x lrtzlvzng, naglqlz-kzku nide. ");
INSERT INTO ntu_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","Naglqlzku drtqde, nigu amrlx ngrgu. Drtqde myatxlz-esz'ngr. Naglqlzku drtqde. Nzmyalz-esz'ngr-krde myaszlzle drtc', X bongavz kz. Nzmyalz-esz'ngr-krde! ");
INSERT INTO ntu_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Naglqlz-zvzku Yawe, nigu lr Israel nedeng. Axplrle x aodule nigu, naglqlz-zvzku Yawe. ");
INSERT INTO ntu_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","Naglqlzku Yawe! Nangr-ngrbzku bade nabz kxmrna. Naglqlzku nide mz nzyrlwrpx-krm leplz nedeng mz Mangr-nzangiongr nide. ");
INSERT INTO ntu_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Nigu lr Israel na-abrtzlvzku Yawe mz nzngini-krde Kxrpalz. X nigu lr Jerusalem naelalz-ngrm drtwrgu King rgu. ");
INSERT INTO ntu_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Naelabzku bade Mz nzrta-krgu kcte x nzayrni-krgu gita. ");
INSERT INTO ntu_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","Murde Yawe abrtz-zlwz-ngrde nigu leplz nedeng, X aovxiole enqmi rgung mz nzmnc-xgle-krgu nide. ");
INSERT INTO ntu_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Delc nigu kxnztrng nabilvzku nzaovxio-krgu. X nangr-abrtzku mz nrlckxbq krlzbzle mz nrlckxngrlx. ");
INSERT INTO ntu_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Naogu namalqlvzlr Gct. X narmaleku toki r vea mz mqgu. ");
INSERT INTO ntu_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","Murde na-ayzlubzku da mz lr mrkzbleng, Mz nzatutr-krgu nzaryplapxkr Gct leplz lcng. ");
INSERT INTO ntu_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","X nape-amqngiku king rdrng, Badr kxnzrmailz rdrng amrlx mz nzaovxio-krgu nidr. ");
INSERT INTO ntu_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","Mz nzamatqkr Gct nigu, rlr-ngrmle bagu, nigu leplz nedeng, Nzprtr-krgu mz nzatutr-krde natqde mz nzayrplapx-krgu lr mrkzbleng. Naglqlzku Yawe! ");
INSERT INTO ntu_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Naglqlzku Yawe mz nzmnc-krde Mangr-nzangiongr, X nzmnc-krde Heven kc tqmyalz. ");
INSERT INTO ntu_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Na-angrlvzku nide nzmyalz-esz'ngr-krde Mz nzale-krde da kcng tqmatq. ");
INSERT INTO ntu_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","5","Naelamibzku nrasrpwale X natz-katobzku bade kcte. Naelabzku bade navzmi nzayrpla-krgu da, Nzrta-krgu da, x nzayrlewz-krgu da mz mqgu. Navxubzku trpu x ncblei. X na-ayrniku gita x ukzlele mz nzglqlz-krgu nide. ");
INSERT INTO ntu_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Nigu kxnzlung amrlx, naelalz-ngrm drtwrgu Yawe. Naglqlzku Yawe! ");
INSERT INTO ntu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Krlc nzryapwxtrngr mz be ngr melrmqng Jiszs Kxnzmcpx. Jiszs Kxnzmcpx vzpxm mz nqvi lr King Devet, x King Devet vzpxm mz nqvi lr Ebraam. ");
INSERT INTO ntu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebraam mrlxde Aesak, x Aesak mrlxde Jekop. Jekop lc mrlxde Judz nidr badr mzledeng kcng nzpnu-esz'-nrade-esz', (kcng tzvzpx-ngrmqng nqvi lr ncblo kcng nzpnu-esz'-nrade-li (12) Israel, kc tqngi kzdq drtq Jekop). ");
INSERT INTO ntu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judz mrlxde Peres x Seera, lxedr kxtrngiulrJiu, drtqde Tama. Peres mrlxde Hesron, x Hesron mrlxde Ram. ");
INSERT INTO ntu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram mrlxde Aminadab, Aminadab mrlxde Nason, x Nason mrlxde Salmon. ");
INSERT INTO ntu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon mrlxde Boas. Boas lc lxede drtqde Reab, kxtrngiulrJiu. X Boas mrlxde Obed, x lxede drtqde Rut, kxtrngiulrJiu kz, murde vzkimle mz drtc' ngr Moab. X Obed mrlxde Jesi. ");
INSERT INTO ntu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi lc, mrlxde King Devet. ");
INSERT INTO ntu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Devet x Batsibz mrlxdr King Solomon. Batsibz nide kc tqngi kai olvz ngr Yuriz mzli kc trnznibqka-ngrde. Solomon mrlxde Reoboam. X Reoboam mrlxde Abaeja. X Abaeja mrlxde Asa. ");
INSERT INTO ntu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa mrlxde Jeosafzt. X Jeosafzt mrlxde Jehoram. Yusaea melrmqde Jehoram. ");
INSERT INTO ntu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yusaea mrlxde Jotam. Jotam mrlxde Eas. Eas mrlxde Hesekaea. ");
INSERT INTO ntu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaea mrlxde Manase. Manase mrlxde Amon. X Amon mrlxde Josaea. ");
INSERT INTO ntu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jekonaea nidr badr mzledeng, melrmqdr Josaea. Mz mzli nyz mzle-lzbq lcng, nide kc tzrtulrtr-ngrbz mz lr Israel nzvz-krdr Bxbilon mz nzngini-krdr kxnzawz-nrbalqng elr. ");
INSERT INTO ntu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mz nibr nzrvzmingr lr Israel Bxbilon, Jekonaea mrlxde Sealtil, Serubabel melrmqde Sealtil. ");
INSERT INTO ntu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel mrlxde Abiud. Abiud mrlxde Eliakim, x Eliakim mrlxde Aso. ");
INSERT INTO ntu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aso mrlxde Sadok. Sadok mrlxde Akim. X Akim mrlxde Eliud. ");
INSERT INTO ntu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud mrlxde Eliesa, Eliesa mrlxde Matan x Matan mrlxde Jekop. ");
INSERT INTO ntu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop mrlxde Josip, Josip lc yrlztile Mxri, kc tqngi lxede Jiszs, kc tzrpibz Kxnzmcpx. ");
INSERT INTO ntu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nzmu narlwxq nrpr ngr leplz lcng, yzuo mz mzli nyz Ebraam, krlzbzle King Devet, e nrpr ngr leplz nzpnu-esz'-nrade-pwx. X yzuo mou, mz mzli nyz King Devet krlzbzle mzli kc lr Israel tzapusr-ngrdr kxnzawz-nrbalqng mrkc Bxbilon, nrpr ngr leplz krlz-mopwzle kx nzpnu-esz'-nrade-pwx. Yzuo mou, mzli lc x sc tqkrlzpebzle mzli kc tzrmcngr mz Jiszs Kxnzmcpx, nrpr ngr leplz nzpnu-esz'-nrade-pwx mou. ");
INSERT INTO ntu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Krlc be ngr nzrmcngr mz Jiszs Kxnzmcpx. Kzdq kc nzyrlzngr nzatubqtibz mz mzlir Mxri kc tqngi lxede x kzdq ncblo drtqde Josip. Josip xpepxpele Mxri mz nzyrlzngr. Kxmule-esz' Mxri trnzmwi-lxblrkang mz Josip, a' yrpe kai mz zmatq ngr Mqngrkxtr. ");
INSERT INTO ntu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kx adcpxbz Mxri nzyrpe-krde mz Josip, Josip aotitx pnz drtwrde nzaxtx-krde Mxri, murde nide ncblo kx mnc-nqblq-zvzle Lou sc Mosis. A' rpile na-ale-kapqle murde ma tqamyabzle drtq Mxri mz nzobqkr leplz kxkqlu. ");
INSERT INTO ntu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mzli kc tqaotipengr drtwrde da lcng, kzdq enjrl ne Gct adcpx-lzbqbz bade mz nzrmwible-krde, rpibzle bade kx, “Josip, bzkq mwxlrq nztwz-krm Mxri nzngini-krde olvz rm. Murde nim nqvi lr King Devet, x doa la tqyr-ngrde ngi-batrpz Mqngrkxtr, a' trngiu ncblo. ");
INSERT INTO ntu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Sa narmc mz doa x napibzme drtqde Jiszs, kc drtwr ngrde Yawe arlapx, murde sa na-arlapxle leplz mz nzbz-krdr mz alwx ngrdrng.” ");
INSERT INTO ntu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Krlc atutrle natq kc tqpibz Yawe mz profet Asaea mz nzrpi-krde kx, ");
INSERT INTO ntu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kzdq doa olvz kxmnc-kamelr, narngine doa ncblo, x drtqde narpibz Imanuel,” kc drtwr ngrde Gct mncm bagu. ");
INSERT INTO ntu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Zbz Josip dwalzm x sc tqyrlztipele Mxri, da kc tqwai nzpi-krbz enjrl kc le bade. ");
INSERT INTO ntu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","A' Josip trmwimileu Mxri vz, vz, x krlzbzle mzli kx nzrmcngr mz doa nede. X yrlq-kzpz Josip drtqde Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jiszs mzte nzmc mz taon kc Betleem mrkc Judiz provins mzli kc Herot Kc Tqmyalz tqngini-ngrde King. Mzli trboiu kzdung ncblo kx nzkrlz-angidrlr drtwr ngr vri sc tzvzpemqng Jerusalem. Ncblo lcng nzvzmqng rlru me prkilzm nepi. ");
INSERT INTO ntu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mzli kc tzkrlzpe-ngrmlr Jerusalem, sc tzveatipebzlr mz leplz kx, “?Myx me nzrmcngr mz doa kc tqtopwz nanginide King r lr Jiu? Mckr vri kc tqplzpxle nzrmcngr mzte mz nzmnc-krgr mrkc tqprkilzm nepi. X vz-ngrmgr mz nzangio-krgr nide.” ");
INSERT INTO ntu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","King Herot mz nzxlrpe-krde nrpa lc, nabzde kc tqtalvzope, murde king lc mzte tzmc ate ma tqmyaszlzle nide. X nabz lr Jerusalem amrlx talvzo kz, murde nzmwxlrtilr nzngyakr drtwr King Herot. ");
INSERT INTO ntu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herot ayrlwrtr-lxblrle kxnzetu rdr pris x kxnzalvztrng mz Lou sc Mosis mz nzveati-krbzle badr kx, “?Drlve ke nzpi profet neng Gct namcngr mz Kxnzmcpx?” ");
INSERT INTO ntu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nzrpibzlr kx, “Kxnzmcpx mzte namc mztea Betleem, mrka mz Judiz provins. Murde profet Maekz yrle natq Yawe kx, ");
INSERT INTO ntu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Nimu lr Betleem, kxmule-esz' taon nyzmu mrkc tzmncngr nqvi lr Judz, ngi taon kxtopwz, a' nangi kz taon kxmyalzbz mz drtc' nyz Judz. Murde sa naprpxm dq bamu kxetu kx na-aclvele lr Israel, kcng tznginidr leplz nengeng.’” ");
INSERT INTO ntu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Zbz King Herot esz'-krde sc tqkqlepele ncblo kcng tzvzkimlr mrkc tqprkilzm nepi x nzpi-angidrbzlr bade mzli kx nzmc-ayrnr-ngrdr vri kc. ");
INSERT INTO ntu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","A' rngidrtx-ngrbzle mz nzrpi-krbzle badr kx, “Vzamu Betleem x rtangrtiamu doa la topwz. X kx tqmcamu nide, sutitx zlwz drtwrnge nzyzlu-mou-kramu bange, murde navz-kzpo mz nzangio-krnge nide.” King Herot kc tqkxmu nzycmne-krbzle lc badr murde naesabrtile nidr. ");
INSERT INTO ntu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","X sc tzrkalzpe-mopqng mz nzvz-krdr. A' mzli kc tzvzne-ngrpwzlr mz lrpzki, sc tzmcpe-moulr vri kcpwz tzmc-pnz-kailr mrkc tqprkilzm nepi. X mzli kc tzmcpe-mou-ngrdr vri kc, sc tzabrtztx-zlwzpe-moung. Vri kc sc tqrtwayzpe-kaipz badr, vzbz krlz-zpwxbzle nztuo-amc-krbzle ma kc tqmncpx-ngrm doa kc tqtopwz mrkc Betleem. ");
INSERT INTO ntu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nzdwatrpzng brma, sc tzmcpelr doa kc tqtopwz ncdr lxede Mxri. X sc tzatuopebzng zpr mz nzangio-krdr nide. X sc tzkapebzlr bade da kcng tqmyapxbz badr, krlcng gol, frankinsens x mrr. ");
INSERT INTO ntu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mz nzyzlupe-mou-krdr mrnyzdr nzo-zli-alzulr kc lrpzki kzble, murde Gct ycmnebz badr mz nzrmwiblengr kx bzkq nzyzlupebzng mz King Herot. ");
INSERT INTO ntu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mz nibr ncblo kcng nzvzpe-krdr, enjrl ne Yawe kc tqadcpx-lzbqpe-mopwz mz Josip mz nzrmwible-krde. Rpibzle kx, “King Herot sa na-atwzlrpx-ngrde kzdung ncblo mz nzrtangrti-krdr doa ncblo lc topwz mz nznibq-krdrle. Mz nzmu-krde lc, tutxlz-anipwzmu badr doa la x lxede, x plc-aniamu mrkc Ijipt. Mnc-txpwzmu elr. X napi-zpwxbo mzli r nzrlasz-mou-krmule.” ");
INSERT INTO ntu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josip tumitxlz-animle Jiszs x lxede mz nrlckxbq kc, x sc tzvzki-anipelr mrkc Ijipt. ");
INSERT INTO ntu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nzmncng Ijipt krlz-zpwxbzle mzli kx Herot bz-ngrde. Dekc Yawe tqatutrle nike pi-pnzbzle mzli kc bqnc mz profet Hosia, mz nzrpi-krde kx, “Ninge Yawe, kqletrx mrlxnge mz nzvzpx-krmle Ijipt.” ");
INSERT INTO ntu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mzli kc Herot tqkrlzpe-ngrde kx ncblo kcng tzvzkimlr mrkc tqprkilzm nepi nzangqngutitrpelr nide, drtwrde kc tqngyape. Zbz sc tqpipebzle mz ncblo ngr vea nedeng nanibqtilr doa ncblo amrlx kx yiz ngrdr libe x kxnztopwztx-zlwzbeng tzmncng Betleem x kzdung kz mztea kxnzesotrpzng. Murde drtwr lc vz-nqblqle natq ncblo kcng mz nzpi-krbzlr bade mzli kx vri kc aelwapx-lzbq-ayrnr-ngrbzle badr. ");
INSERT INTO ntu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mz nzmu-krde lcde, lr Betleem nzyrnitipelr doa nedr kcng tzbztipeng. X nzyrningr lc sc tqatutrpele nzyr-pnzkr profet Jeremaea mz kzdq mztea kx esotrpz Jerusalem, mz nzrpi-krde kx, ");
INSERT INTO ntu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Kzdq kc natq tzxlrtrpz mztea Rama, x krlc natq ngr nzyrningr mz drtwr kx vz zlwz. Resel tqyrnimile doa nedeng. Rblx nzamnc-lrpingr nide, murde doa nedeng nzbztipeng.” ");
INSERT INTO ntu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Zbz Herot kc tqbzpe, x enjrl ne Yawe sc tqadcpx-lzbqpe-mopwz mz nzrmwiblekr Josip, mzli kc tqmncbe-ngrde Ijipt. ");
INSERT INTO ntu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","X rpibz enjrl kc bade kx, “Tulz, otibz doa ncblo la x lxede kz x yzlukipe-mouamu mz mrnyzmu mrkc Israel, murde leplz kcng tzsuti drtwrdr nzrnibqngr doa la topwz nzbzpeng.” ");
INSERT INTO ntu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","X Josip ncdr doa ncblo kc x lxede sc tzyzlukipe-moulr Israel. ");
INSERT INTO ntu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mzli kc Josip tqxlrpe-ngrde kx mrlx King Herot, drtqde Akelezs kc tqnginipede king r Judiz Provins, sc tqmwxlrpe nzmnc-mou-krdr mrlcde. X Gct ycmne-mopwz bade mz nzrmwiblengr nike na-alele, x sc tqvzkipele Gzlili Provins. ");
INSERT INTO ntu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Naszret sc tqngipe mztea nyzde. Mz nzmu-krde lc, natq kx nzpi-pnzngr Kxnzmcpx sc tqtutr-angidrpe, mz nzrpi-krde kx, “Kxnzmcpx narpipe-ngrbz nide doa lr Naszret.” ");
INSERT INTO ntu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mzli lcde, Jon Kxawrkxtr vzpxm lzke ngr Judiz Provins, x sc tqryapwxpebz mz leplz. ");
INSERT INTO ntu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Rpibzle kx, “Tekqtramu nqmq nr drtwrmu mzli ka, murde Gct ycpe pipz nzvectr-krmle leplz mz nzmnclz-krbzlr bade mz nzngini-krde King rdr.” ");
INSERT INTO ntu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon nide kc tqycmnetrngr profet Asaea mz nzryr-krde kx, “Natq kzdq ncblo kx natqde etu mz nzryapwx-krbzle mz leplz lzke. Natq lcde rpile kx, ‘Oliqtiamu nabzmu mz nzvz-krm Kxetu Gct. Atubqtibzmu lrpzki kx nangi nyzde, na-apule nzoliqtikr leplz kzdq lrpzki kx navzkim king.’” ");
INSERT INTO ntu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon lc nide kzdq ncblo kx rpxingr lrpz kx nzwzngr mz nrpnr kamel x nrkalode ngi bekzu. Dakxnzng nade ngi txpwz kionabr x hane kzpeto. ");
INSERT INTO ntu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Leplz kxnzkqlung mrkc Jerusalem x me nzyc-aepztimqng mz provins kc Judiz, x mrkcng amrlx tqo-ngalele LueJodzn, nzvzmqng mz nzlalztq-krbzlr mz Jon. ");
INSERT INTO ntu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nzplxtipxbzlr alwx ngrdrng mz Gct, x sc tqawrkxtrpeng Jon mz LueJodzn. ");
INSERT INTO ntu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mzli kc tqmcngr Jon kx Farzsi x Sadiusi kxnzkqlung sc tzvzpe-kzpqng bade mrkc tqawrkxtr-ngrde leplz, drtwrde trmrlzu, x sc tqrpipebzle badr kx, “Nimu doa neng kxdrka'-ngrng kxnzodang! ?Neke rpibz bamu nzwrkxtrngr na-ayrbqpxle nimu mz nzayrplapxkr Gct kc navzm? ");
INSERT INTO ntu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nzwrkxtrtx-ngrpwz esz'-krde trna-arlapxleu nimu, a' na-aleamu da kx aelwapx-ngrde kx tekqtrpeamu nqmq nr drtwrmu kxtrka kx ycpxm mz nabzmu. ");
INSERT INTO ntu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","X bzkq rpiamu mz nimu esz'-krmu kx, ‘Rlapxpekr murde Ebraam ngi melrmqgr. X nigr angidr leplz kx mcpx Gct.’ Murde napibo bamu kx nzmu trnavz-nqblqwamuu lrpzki r Gct mz nzarlapx-krde leplz, krlzle nzbatr-krbzle neidu lr Ebraam nzvzpx-krmlr mz rplz lcng, mz nzatutr-krde da kx esalz-ngrbzle bade. ");
INSERT INTO ntu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Gct apule ncblo kx twzle akes scde x oliqtile nzrlakitiongr nounc x rtctxlz-ngrde mz nyr, murde trnzpapx-ngrdru nradr kxmrlz. Sa tqoliqtile mzli ka nzangc-krde leplz mz nyr ngr nzayrplapxngr, murde nqmq krdr trtubqu x nzpxtxpx-ngrdr nztekqtr-krdrle. ");
INSERT INTO ntu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Awrkxtrx leplz mz lue txpwz namcngr kx tekqtrpeamu nqmq nr drtwrmu kc tqtrka. A' kzdq la ncblo sa navzm mz nibrnge. X da kx na-alele namyaszlz-moule ninge. Murde kxmule-esz' ninge kzdq profet, a' trtakitrdeu ninge nzwztr-krbo bade, x trtakitr-kzpwc'u nzrmalene-ngrbz sadol scde, murde myaszlz-zlwzle ninge. Sa na-awrkxtrle nimu mz Mqngrkxtr x nyr kx na-alqngile nimu. ");
INSERT INTO ntu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Mz nzvz-krmle naoliqtinemle nzrpipx-krde nqmq kr leplz. Nakapxmle leplz kx nzmrlzng mz leplz kx nztrkang, mz nzamnc-angidrpe-krdeleng Heven. A' leplz kxnztrkang sc tqangcpeleng mz nyr kx ngc alo.” ");
INSERT INTO ntu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mzli lcde Jiszs rkalzm Gzlili Provins x vzm mz Jon mrkc mz LueJodzn mz nzawrkxtrkr Jon nide. ");
INSERT INTO ntu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","A' Jon abzle nzarlapx-lzbqngr mz nzawrkxtr-krde Jiszs. Rpibz Jon kx, “Nzmu na-awrkxtrbzme ninge! Trtakitrdeu nzawrkxtr-krbo nim!” ");
INSERT INTO ntu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","A' ayzlu-ngrbz Jiszs natqde kx, “Rlr-ngrbz kx nakxmupele lc mzli ka. Murde mz nzale-krgi da lc, dekc na-atutr-ngrgi me pnz drtwr Gct.” Zbz sc tqaolvzpebz Jon natqde. ");
INSERT INTO ntu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Mz nibr nzwrkxtrkr Jiszs, mzli kcpwz tqvzdz-ngrmle mz lue kc, Heven lvxpx-lzbqbz bade. X mcle Mqngrkxtr vzom bade apule nran, x wxbuobz bade. ");
INSERT INTO ntu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Zbz kzdq natq rpiomle Heven kx, “Mrlx lc nide Mrlxnge Kxnzmrlzti. X abrtzlvz-zlwzx nide.” ");
INSERT INTO ntu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Zbz Mqngrkxtr sc tqmailztrpele Jiszs lzke, murde narlr-ngrbzle mz Setzn nzrtamitingr nide. ");
INSERT INTO ntu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Mnctile lzke zbq nzpnu-pwx mzli kc tqaxtx-ngrbzle dakxnzng mz nzkrka'-krde. X mz nibrde nelzde kc tqbrtalepe. ");
INSERT INTO ntu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mzli lc Setzn sc tqvzpem bade, rpibzle kx, “Kx tqnginim Mrlx Gct, e aelwapx-ngrm bange x pibz mz rplz lcng nalrtipxlr bret.” ");
INSERT INTO ntu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","A' ayzlu-ngrbz Jiszs natqde kx, “Trtingr, murde nzyro mz Nzryrngrkxtr kx, ‘Doa trlutx-ngrpwzleu nzmu-krde dakxnzng, a' lu-kz-ngrde natq Gct.’” ");
INSERT INTO ntu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Zbz Setzn kc tqvzmipele Jiszs Jerusalem, mzteadau kxtr, sc tqamncopemle mz kzdq me yctxlz zlwz mz Mangr-nzangiongr Yawe. ");
INSERT INTO ntu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Sc tqrpipebzle kx, “Kx tqnginim Mrlx Gct, e atao-lzbq mrka. Trpnzngr nztakr-krm murde Nzryrngrkxtr rpile kx, ‘Pipebz Yawe mz enjrl nedeng nzaclve-krdr nim. Nzglqlr nim mz mqdr, murde nanycm ma tqtcprtr mz rplz.’” ");
INSERT INTO ntu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","A' rpibz Jiszs kx, “Trtingr. Murde Nzryrngrkxtr rpi-kzle kx, ‘Bzkq atalzamu Kxetu Yawe, Gct rmu.’” ");
INSERT INTO ntu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Zbz Setzn vzmilz-kzle Jiszs mz newz kx myatxlz. Sc tqaelwape-ngrbzle mrkcng amrlx tqluli tzaclvelr king r nrlc. ");
INSERT INTO ntu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Zbz rpibz Setzn mz Jiszs kx, “Nzmu narweome bange zpr mz nzangio-krm ninge mzli ka, e da lcng amrlx sc tqkatipebong bam.” ");
INSERT INTO ntu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Rpibz Jiszs kx, “Rlasz ninge Setzn! Nzmu trangiowxu nim, murde nzyr mz Nzryrngrkxtr kx, ‘Angio txpwz Kxetu Yawe, kc tqngi Gct ngrm x wztxtrpwz bade!’” ");
INSERT INTO ntu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Zbz Setzn kc tqrlaszpele Jiszs, x enjrl neng Gct nzvzmqng sc tzaclvepelr nide x tzrkapebzng nade dakxnzng. ");
INSERT INTO ntu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Zbz kzdq ncblo adcpxbzle mz Jiszs kx Jon Kxawrkxtr nzadwatrpe mz presin. Zbz Jiszs sc tqrkalzpem Judiz Provins tqyzlupe Gzlili Provins. ");
INSERT INTO ntu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Mz nzyzlu-krde mrlcde trmncu mztea Naszret, a' mnc Kzpznizm, kzdq taon kx yco mz nqlvi r Dxbu Gzlili. Kzpznizm yc mz nrlarnrlc kc tzmncngr neidu lr Sebyulon x Naftzli, lr Israel kcng bqnc. ");
INSERT INTO ntu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Da lc tqale Jiszs atutrle natq profet Asaea kc bqnc, mz nzrpi-krde kx, ");
INSERT INTO ntu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nimu lr Jiu namncamu mz mzlir kxtrngiulrJiu mz nrlarnrlc kcng Sebyulon x Naftzli. Drtc' nyzmu yc-aepztrpz mz lrpzki kc tqo-zlile Dxbu Gzlili, krlzbzle nqlvi r LueJodzn me prkilzm nepi. ");
INSERT INTO ntu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Alwx ngr leplz kxnzmnc-mrbrng akamrbr-ngrde da mz nabzdr. Kxmule-esz' a' sa namclr ncblo kc na-apule zyzlr, kc tqpnamilxtile nabzdr, murde na-aopxbzle badr lrpzki kx navzkilr mz nzrlapx-krdr.” ");
INSERT INTO ntu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mzli lc tqmncpengr Jiszs Kzpznizm, sc tqayzutrpele nzwz-krde. Rpibzle mz leplz kx, “Tekqtramu nqmq nr drtwrmu mzli ka, murde Gct ycpe pipz nzvectr-krmle leplz bade mz nzmnclz-krbzlr bade mz nzngini-krde King rdr.” ");
INSERT INTO ntu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kzdq zbq Jiszs kx o-zlile kc nabz drta' ngr Dxbu Gzlili, rmctile ncblo nzling kx nzmwang. Saemon kc tqngi kz drtqde Pita, x mzlede Adru. Sc tzapoong br Dxbu Gzlili. ");
INSERT INTO ntu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Zbz sc tqkqlepxpeng Jiszs, rpibzle badr kx, “Vz-nqblqmamu ninge, murde na-alvztrpo bamu nzrtangrngr leplz kx nangi nengeng.” ");
INSERT INTO ntu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","X mzli kcpwz nzrlasztx-pnzlr nzwz-krdr x sc tzvz-nqblqpelr nide. ");
INSERT INTO ntu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jiszs o-zli-mopwzle nabz drta', rmcti-moule mzle-lzbq nzling, Jemes x Jon, mrlxng Sebedi. Nzmncomqng badr trtedr mz bot scdr, tzngqtitrlr br scdr. Zbz sc tqkqlepxpebz Jiszs nidr. ");
INSERT INTO ntu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Mzli kcpwz nzyrlqtxdr nzwz-krdr, x nzrlasztrplr trtedr mz bot scdr, x sc tzvz-nqblqpe-kzlr Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Zbz Jiszs sc tqvztipele mztea ngr Gzlili amrlx, tqalvztrpe mz mangr-nzkrka'ngr nyzdr lr Jiu, x tqyapwxtipxle Nrpakxmrlz kx Gct sa tqvectrpemle leplz bade mz nzngini-krde King rdr. Mzli lc Jiszs amrlz-kzle kxnzyagoxng x kxnzdwatibzng zyagox kxtrka. ");
INSERT INTO ntu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Zbz nrpa ngr Jiszs sc tqvzpe tqtalvzpxpele provins kc Siriz. X leplz ngr mztea lcng amrlx nzrvzmimqng mz Jiszs lr ma nyzdr kxnzdwatibz zyagox kx bletipx-lxblrng. Kzdung nzyagox-zpwxng, kzdung drtqdr vetq, kzdung nrkrdrtqdr bz, kzdung nzglqng nimz, x kzdung nzdwaszng drka'. Jiszs amrlz-moule leplz lcng amrlx. ");
INSERT INTO ntu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mzli lc, zbo ngr leplz kxetu sc tzma-nqblqtipelr Jiszs, kxmule-esz' nznginidr lr Jiu o kxtrngiulrJiu, murde namclr da kx na-alele. Leplz lcng nzprpxmqng mz nrlarnrlc kcng mz taon kcng nzpnu-esz', mz Provins kc Gzlili, Provins kc Judiz, x mzteadau Jerusalem x mz nrlar LueJodzn kc tqprkilzm nepi. ");
INSERT INTO ntu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mzli kc tqmcngr Jiszs zbo ngr leplz kcng tzvzmqng bade, sc tqvzdzpe mz kzdq nra mz nzalvztr-krde nidr. X ncblo nedeng nzwxbu-ngalelvzlr nide mrkc tqwxbu-ngrde. ");
INSERT INTO ntu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","X sc tqrpipebzle mz nzalvztr-krde nidr kx, ");
INSERT INTO ntu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ngi da kxmrlz nzkrlz-krmu kx mnc-xgleamu nzokatrkr Gct, murde Gct sa nakabzle bamu da kx vzpxm mz nzngini-krde King rmu. ");
INSERT INTO ntu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Ngi da kxmrlz nzvzkr drtwrmu, murde Gct sa na-amqtrpzle nabzmu. ");
INSERT INTO ntu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Ngi da kxmrlz nzavzo-lzbq-krmu, murde Gct sa nakabzle bamu zmatq mz nzaclve-krmu mz nrlc. ");
INSERT INTO ntu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Ngi da kxmrlz nzpqkr nabzmu mz nzrtangrti-krmu Gct, murde Gct sa naokatrle nimu mz nzvz-nqblq-krmu me pnz drtwrde. ");
INSERT INTO ntu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Ngi da kxmrlz nzyckr drtwrmu leplz mz nzokatr-krmu nidr, murde Gct sa nayc kz mz drtwrde nimu. ");
INSERT INTO ntu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Ngi da kxmrlz nztubqkr nabzmu, murde sa nakrlz-angidramu Gct x nqmq kxtubq. ");
INSERT INTO ntu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Ngi da kxmrlz nzaodutr-lxblr-krmu leplz mz nzmnc-krdr mz nrwx, murde Gct sa narpile kx nimu doa nedeng. ");
INSERT INTO ntu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Ngi da kxmrlz nzatrkatingr nimu mz nzale-krmu da kxtubq, murde mnclzbzmu mz Gct mz nzngini-krde King rmu. ");
INSERT INTO ntu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ngi da kxmrlz nzatrkatingr x nzrpibqtingr x nzobqszongr nimu mz nzvz-nqblq-krmu ninge mz nrlc ka. ");
INSERT INTO ntu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mzli ka na-abrtzlvzamu nzapu-krmu profet ne Gct kcng tzatrkati pnz melrmqmung. Murde mz nrlc kc navzm, sa natwz-kzamu da kc tqmyapx-esz'ngr.” ");
INSERT INTO ntu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jiszs rpi-mopwzle mz nzycmne-ebzpxngr kx, “Na-apuamu dcpiz kxmrlz mz nrlc ka. Murde na-amnc-angidr-kzamu leplz da kc tqwai dcpiz nzayc-angidr-krde dakxnzng. A' nzmu nilwz dcpiz kx tqmrbrle la, trpengr nzamrlz-moungr. Trpnzngr da kx takitrde, a' takitxtrpwzle nzrtctxngr mrkc tzvz-ngrdr leplz. Mz nzmu-krde lcpwz, bzkq esaki nzvectr-krmamu leplz bange mz nzarlapx-krnge nidr. ");
INSERT INTO ntu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","X nzmu na-apu-kzamu zyzlr kc namailzbzle leplz mz Gct. Murde nztubqkr nqmq krmu naopx-angidrbz badr, da kc tqwai zyzlr ngr taon kx ycom mz newz tryc-kapqu. ");
INSERT INTO ntu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","X navz zvz nzale-krmu da kxmrlz, murde trpnzngr doa kx rtekatr lam sc tqyrlq-kapqpele. X tralalvzo-kzleu topla. A' lam nzadolzpwz wq, murde leplz namclr zyzlr mz nzdwatr-krmlr brma. ");
INSERT INTO ntu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mz nqmq lcpwz, na-aelwapx-ngrbzmu mz leplz nztubqkr nqmq krmu, kc navz-nqblqbzlr mz Trtemu kc Heven, mz nzglqlz-krdr nide.” ");
INSERT INTO ntu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Rpi-mopwz Jiszs kx, “Bzkq rpiamu kx vzmc mz nzayrkrpx-krnge Natq Gct kxnzyro mz Lou sc Mosis x nzalvztrkr profet. Murde trvz-ngrpwc'u mz nzayrkrpx-krngele, a' mz nzatukztr-krngele. ");
INSERT INTO ntu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Dekc tqvz-ngrmc mz nrlc. X trpnzngr natq kxpipz mz Lou sc Gct kx nakatxpx mzli ka bongavz x nrlc tqycbe-ngrdr. A' natqdeng amrlx na-atutr-kaing. ");
INSERT INTO ntu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mz nzmu-krde lcde, doa kx rnzlvzole kzdq natq Gct, x alvztr-rbrle da, sa nanginide ncblo kxmane mz leplz amrlx kcng tzmnclzbzng mz Gct, kxmule-esz' ncblo lc rpile kx natq lc mane. A' kx vz-nqblq-zvzle natq Gct x alvztr-angidr-ngrde leplz, sa nanginide ncblo kxetu mz drtwr Gct. ");
INSERT INTO ntu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Napibo bamu, rblx nzmnclz-krbzmu mz Gct mz nzngini-krde King rmu, a' ngi txpwz nzmu nzvz-nqblq-krmu natq Gct namyaszpxle Farzsi x kxnzalvztrng mz Lou sc Mosis kcng tzvz-nqblqlr drtwrdr esz'-krdr.” ");
INSERT INTO ntu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jiszs rpi-mopwzle kx, “Krlzamu kx mzli kc bqnc Gct kabzle natq lc mz melrmqgung, mz nzrpi-krde kx, ‘Bzkq rnibqq leplz. Murde sa na-ayrplapxx doa kx rnibq leplz.’ ");
INSERT INTO ntu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","A' rpibo bamu kx Gct sa na-ayrplapx-kzle mrlx kc tqngyati drtwrde kztede, kxmule-esz' tratrkatileu nide. X nide kc tqrpibzle mz kztede kx, ‘Nim dcvi r leplz,’ o ‘Nim brmrda ngr leplz,’ sa navzmi nide mz Kansrl. X nekc mz drtwrde rpile kztede takitrde Hxl, mz nzrpi-krbzle bade kx, ‘Nim bo-ngqngu,’ takitrde Gct nzrtctr-krde nide mz nyr ngr Hxl. ");
INSERT INTO ntu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“Mz nzmu-krde lcde, tubqti-lzbq-kaiamu mz kztem kc tqngyati drtwrde nim. Na-aleq da lc nzmu navzq mz Mangr-nzangiongr Yawe mz nzrka-krm blz mz olta, a' dcpx mz drtwrm kx kzdq doa ngyati drtwrde nim. Bzkq kaq blz kc, a' yrlq txpwz ena, x tubqti-lzbq-kaiamu mz kztem. Zbz takitrde nzyzlu-kr-mopwe' Mangr-nzangiongr mz nzrka-krm blz kc. ");
INSERT INTO ntu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Mz nqmq kcpwz, mz nzvz-krmu mz lrpzki, tubqti-lzbq-kaiamu mz ncblo kc natwzle nim mz kot. Murde ma tqaprcbzle nim mz majzstret kc na-aprc-alzupwzle nim mz pulis, x pulis sc tzadwatrpelr nim mz presin, ");
INSERT INTO ntu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","mrkc namnc-ngrn x nakrlz-zpwxbzle nzxpepx-krm trau amrlx kcng nakapxq.” ");
INSERT INTO ntu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jiszs rpi-mopwzle kx, “Krlzamu kx mzli kc bqnc Gct kabzle natq lc mz melrmqgung, mz nzrpi-krde kx, ‘Bzkq rmwimiq doa kx trngiu krnalzm.’ ");
INSERT INTO ntu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","A' rpibo bamu kx mrlx kx mzte rkcmnzngr doa, x rpile namwimile, mz nabzde rnzlvzopele natq Gct kc tqrpile kx bzkq rmwimiq doa kx trngiu krnalzm. ");
INSERT INTO ntu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","30","“Mz nzmu-krde lcde, aclveti-lzbq kz. Bzkq rlr-ngrbzme mz alwx nzaclve-krde nim. A' mz mzli r nzatalzngr arlapx-lzbq. X katxpx-lzbqm mz nzatalzngr kx batrpzle nztao-zvz-krm. Murde nzwz-kato-krm mz nzmncngr kxtubq mzli ka, x nzmnc-zvz-krm Heven kalr, myaszpx-zlwzle nzaxtx-krbzme nzrlxngiti-krm mzli ka, x nzmnc-zvz-krm mz Hxl kalr.” ");
INSERT INTO ntu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jiszs rpi-mopwzle kx, “Krlzamu kx mzli kc bqnc Gct kabzle natq lc mz melrmqgung, mz nzrpi-krde kx, ‘Ncblo kx na-axtxde krnalzde, naka-kaipzle bade pepz ngr nzaki-lzbq-krdr.’ ");
INSERT INTO ntu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","A' rpibo bamu kx ncblo kx axtxde olvz rde kx tr-rmwimiu ncblo kzble batrpzle bade nztao-krde mz alwx ngr nzrmwingr ncblo kzble nzmu nayrlz-moule. X ncblo kc tqyrlztile olvz lcde tao kz mz alwx lcdepwz.” ");
INSERT INTO ntu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jiszs rpi-mopwzle kx, “Krlzamu kx mzli kc bqnc Gct kabzle natq lc mz melrmqgung, mz nzrpi-krde kx, ‘Bzkq pokiaq mz nzesalz-krm, a' atutr zvz da kx esalz-ngrbzme mz Gct.’ ");
INSERT INTO ntu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","A' rpibo bamu kx bzkq yrlqq nzesalz-krm mz kzdq da, murde rblxbz bam nzatutr-krm natqm, a' da amrlx yc mz mq Gct. Bzkq yrlqq nzesalz-krm mz Heven murde ngi me mncngr Gct. ");
INSERT INTO ntu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","X bzkq yrlqq nzesalz-krm mz nrlc ka, murde nyz-kzde. X bzkq yrlq-kzq nzesalz-krm mz Jerusalem, murde krlc mzteadau kx nzangiongr Gct, King kxmatq. ");
INSERT INTO ntu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","X bzkq yrlqq nzesalz-krm mz narm, murde rblxbz bam nzaprkingr x nzabongr nqnginarm, murde da lc yc kz mz mq Gct. ");
INSERT INTO ntu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Setzn kc Tqdrka'ngr tqngi nou da kxtrka amrlx batrpzle mz leplz nzpokia-krdr x nzrpilr nayrlqlr nzesalz-krdr mz kzdq da. Mz nzmu-krde lcde, da kx napi-txpwzme mz nzycmne-krm, ‘Eu’ o ‘Trtingr.’ A' bzkq pokiaq x bzkq yrlqq nzesalz-krm mz kzdq da.” ");
INSERT INTO ntu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jiszs rpi-mopwzle kx, “Krlzamu kx mzli kc bqnc Gct kabzle natq lc mz melrmqgung, mz nzrpi-krde kx, ‘Nzayrplapxngr narsakrlr-ngrpwz mz nike nzvz-rbrngr. Doa kx tz-batrpzle mz kztede, natz-batr-kzpzle mzte. X doa kx tzlqpxbzle nqngi kztede, natzlqpx-kzpzle nqngide.’ ");
INSERT INTO ntu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","A' rpibo bamu kx bzkq ayzlubzme nike nzwaisr-ngrm, a' ayzlu-alzupwz mz nivz. Nzmu ncblo naobqszole nim mz nztztr-krbzle blzmznaom kxrtc, bzkq ayzluq, a' ao-lxlvr-kzpz nrlarde kxmc mz nztz-kz-krpzlele. ");
INSERT INTO ntu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","X nzmu ncblo natwzle nim mz kot murde rpile nrz scmqng nangi scdeng, ka-kzpz bade bot scm. ");
INSERT INTO ntu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","X nzmu kzdq kxetu kx rtulrtrpzle bam nzglq-krbzme bxli scde mz kilomita kxesz', bzkq kabzme, a' glqtibzle kilomita nali. ");
INSERT INTO ntu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Doa kx rlxbz bam da murde rpile nangi scde, x mcq kx takitrde nzokatrngr, kabz. X kx rlxtibzle da scmqng mzli kxmrbcne, rlr-ngrbz.” ");
INSERT INTO ntu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jiszs rpi-mopwzle kx, “Krlzamu kx mzli kc bqnc Gct kabzle natq lc mz melrmqgung, mz nzrpi-krde kx, ‘Mrlzti kztemqng, a' namwati drtwrm enqmi rmqng.’ ");
INSERT INTO ntu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","A' rpibo bamu kx namrlzti-kzamu enqmi rmung. X nakrka'-ngrnamu leplz kcng tzatrkatilr nimu. ");
INSERT INTO ntu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Murde mz nzale-krmu da lc, sa nanginimu mrlxng Gct Trtemu kc Heven x na-apuamu nide. Murde mrlztile leplz kxmule-esz' kxdrka'-ngrng o kxnzmrlzng, mz nzati-krbzle nepi x nzadc-krbzle tewa mz leplz amrlx. ");
INSERT INTO ntu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nzmu namrlzti-txpwzmu kxnzmrlztilr nimu, Gct ma trkapwzleu da kxmrlz bamu. Murde tr-rblxu nzalengr, x kxnzatakqting takes nzale-kzlr da lc. ");
INSERT INTO ntu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nzmu narpi-txpwzmu kx, ‘Nimu la,’ mz kztemung, trmyaszpxleu leplz kc-kzng. Murde tr-rblxu nzalengr, x kxnzmnc-mrbrng nzale-kzlr da lc. ");
INSERT INTO ntu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mz nzmu-krde lcde, namrlztiamu leplz amrlx, da kc tqwai Trtemu kc Heven nzmrlzti-zlwz-krde leplz amrlx.” ");
INSERT INTO ntu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jiszs rpibzle kx, “Bzkq glqpx-lzbqq mz nzale-krm da kxmrlz me nzyrlwr-lxblrngr, kx muq naglqpxngr leplz nim. Murde nzrglqpxngr lc sa nangipepwz da kx natwzq, a' trtxpnzngr nztwz-mou-krm da kx nakabz Trtem kc Heven. ");
INSERT INTO ntu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Mz nzmu-krde lc, mzli kznike rka-ngrn da mz nzokatr-krm leplz, bzkq aleq mz mz leplz kxnzkqlung, da kc tzwai leplz kx narpi-rbz kxnzrlxngiting. Nzalelr da lc murde naglqlzngr leplz nidr. A' napi-angidrbo bam kx trpengr da kx natwz-moulr kx nakabz Trtem kc Heven, a' ngi txpwz nzglqlzkr leplz nidr. ");
INSERT INTO ntu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","A' mz nzokatr-krm doa, bzkq rlr-ngrbzme mz leplz nzkrlztitr-krbzlr. ");
INSERT INTO ntu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Murde Trtem kc Heven tqrkrlz angidr da amrlx sa nakabzle bam da mz nzabrtzlvz-krde da kc tqale-kapqq.” ");
INSERT INTO ntu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jiszs rpi-mopwzle kx, “Mz nqmq lcpwz, mzli kznike krka'-ngrn, bzkq apuq leplz kx narpi-rbz kxnzrlxngiting. Murde nzkrka'ng mz mz leplz kxnzkqlung x nzobq-kztilr nidr. A' napi-angidrbo bam kx trpengr da kx natwz-moulr, a' ngi txpwz nzglqlzkr leplz nidr. ");
INSERT INTO ntu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","A' nim, mz nzkrka'-krbzme mz Gct kc trnzmcu, krka' me trnamc-ngru leplz nim. Murde Gct kc tqmcle da amrlx, sa narkabz bam da mz nzabrtzlvz-krde da kc tqale-kapqq. ");
INSERT INTO ntu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“X mz nzkrka'-krm, bzkq apuq kxtrnzrlxngitiung kcng tzrpiting natq kxkqlu kx trpnzngr drtwr ngrdeng. Murde mz drtwrdr krkcng tzangiolrng sa nakabzlr badr da navz-nqblqle nzboikr nzkrka'-krdr. ");
INSERT INTO ntu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bzkq kxmule lc mz nzkrka'-krm da kc tzwailr, murde Gct Trtem krlzpe-kaile da kcng narlxtibzme trycpwzu bam. X suti drtwrde nzka-krbzle da lcng bam. ");
INSERT INTO ntu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Mz nzmu-krde lcde, mz nzkrka'-krm rpi kx, ‘Gct Trte, batrp bagr, nigr lr nrlc, nzamatq-krgr drtqm kxtr-esz'ngr, ");
INSERT INTO ntu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","x nzmnclz-krbzkr bam mz nzngini-krm King rgr. Murde navz-nqblq-kzkr me pnz drtwrm, da kc tzwai lr Heven. ");
INSERT INTO ntu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kam bagr dzu r da kx natakitrde mzbq ka. ");
INSERT INTO ntu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","X ipqpxbz nzvz-rbr-krgr navz-nqblqle nzipq-krgr krkcng tzaletrpqng da kx vz-rbr bagr. ");
INSERT INTO ntu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","X arlapx nigr mz zmatq ngr Setzn, mz nzokatr-krm nigr mz nztu-amqngi-krgr mz nzatalzngr. X awi mz nzayzlu-krme natqgr, mz nzngini-alo-krm king rgr, mz zmatq ngrm kc tqyc tqyc. Eu, angida.’” ");
INSERT INTO ntu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Jiszs rpi-mopwzle kx, “Murde nzmu naipqq krkcng tzaletrpzng da kx vz-rbr bam, e Trtem kc Heven sa naipq-kzle nim. ");
INSERT INTO ntu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","A' nzmu trnaripqwq leplz, e Trtem kc Heven tripq-kzleu nim.” ");
INSERT INTO ntu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jiszs rpibzle kx, “Mzli kznike axtx-ngrn da mz nzmnc-aepztr-krbzme mz Gct, ale txpwz mz Gct. X bzkq apuq leplz kx narpi-rbz nidr kxnzrlxngiting. Leplz lcng nzablqkiti-lzbqng mz nzaxtx-krdr da, murde leplz namclr kx nidr kxnztrng. A' napi-angidrbo bam kx trpengr nztwz-mou-krdr da, a' ngi txpwz nzglqlzkr leplz nidr. ");
INSERT INTO ntu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","A' mz nzaxtx-krm da, yangi narm x abrngzti-lzbq. ");
INSERT INTO ntu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Murde ma tzkrlztrpz leplz kx axtxq da, a' namc txpwz Gct kc trnzmcu. Murde Gct kc tqrkrlzle da amrlx sa nakabzle bam da mz nzabrtzlvz-krde da kc tqale-kapqq.” ");
INSERT INTO ntu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jiszs rpibzle kx, “Bzkq atamutilzq nzrngisc-krm da mz nrlc ka, murde ma tqyrti ninr x ma tqpnz mepyr rde, x tzpnati ncblo. ");
INSERT INTO ntu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","A' na-atamutilzq nzrngisc-krm da Heven, mrkc trpnzngr da kx atrkati da, x trpnzngr kx pna da elr. ");
INSERT INTO ntu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Murde mrkc tqyrlq-ngrn dztum, dekc tqyc-kzngr nabzm. ");
INSERT INTO ntu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mz nzmu-krde lcde, da kcng tqpqtr mz nabzm nzaelwapx-ngrdr nzngini-krm doa kxmrlz o kxtrka. X doa kxmrlz aelwapx-ngrde kx nabzde yrbulzm mz da angidr x nivz lr Gct mz nzrka-nrbalq-krbzle da mz leplz. ");
INSERT INTO ntu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","A' doa kxtrka aelwapx-ngrde kx nabzde kamrbrngr. Murde trkibrlvzle nzrngisc-krde mz nrlc ka. X rblxbz bade nzobqplxtr-krde natq Gct. Delc tqale-zvz-ngrde alwx. ");
INSERT INTO ntu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Rblx doa nzwztr-krbzle mz kxetu kxli mz mzli kxesz'. Murde sa napqtitrpe drtwrde kzdq, x sa namatitrpe drtwrde kzdq kz, mz nzrvz-nqblq-ngrng. Mz nzmu-krde lcpwz, rblx nzwztr-krbzmu mz Gct x mz nzrngiscngr da. ");
INSERT INTO ntu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Mz nzmu-krde lcde, rpibo bamu kx bzkq da kx nakxne drtqmu mz nzmnc-krmu, mz da kx nangqamu x namnqamu, x lrpz kx napxi-ngrnamu. Murde nzmnc-zpwxngr tryctxtrpwzu mz dakxnzng x lrpz. ");
INSERT INTO ntu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","A' na-aoti drtwrmu utc. Trpnzngr da kx nzpetilr x trnzekqlzung dakxnzng, x trpnzngr nyzdr ma ngr dakxnzng, murde Trtemu Gct aclvele nidr. A' nakrlzamu kx nzmyalz-krmu myaszpxle utc! X mz nqmq lc, Trtemu sa narkatibz bamu da. ");
INSERT INTO ntu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mane nzyc-zvzkr drtwrmu da, murde trokatrleu nimu x rblxbz bamu nzaboinepx-krmu nzlu-krmu. ");
INSERT INTO ntu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“X mane nzyc-zvzkr drtwrmu mz trnzrngisc-ngru lrpz. Na-aoti drtwrmu nzpqpxkr mqmya. Trnzwzung x trnzrkxsilvzung scdr lrpz. ");
INSERT INTO ntu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kxmule-esz' King Solomon kc tqngi nceapu, a' nzlulikr lrpzdeng trmyaszpxleu nrpq mqmya lcng. ");
INSERT INTO ntu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Murde Gct la tqapqtipx mqmya nangi lrpzdr nc mqmya. Noude lang trnztu-aboiu, murde sa namrbrng mz nzngc-krdr mz nyr, nzngikr nanr leng. Mrla tqyc-ngrde, nakrlzamu kx Gct sa na-apxi-kzle nimu, mz nzmnc-krmu mz nrlc. Murde myaszlz-zlwzamu nounc. A' nzrlxngiti-krmu bzkq topwz! ");
INSERT INTO ntu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Mz nzmu-krde lc, bzkq yc zlwz mz drtwrmu da kx nangqamu, lue kx namnqamu, x lrpz kx napxi-ngrnamu. ");
INSERT INTO ntu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","X bzkq apuamu kxtrnzrlxngitiung kx nzaoti txpwz drtwrdr da lcng. Murde trnzkrlzlru kx Gct rkale doa nedeng da kx tryctrpwzu badr. A' nadcpx mz drtwrmu kx Trtemu kc Heven krlzle da kx trycpwzu bamu. ");
INSERT INTO ntu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","X narlr-lzbqbzmu mz nzmnclz-ngrbz bade x mz nzvz-nqblqngr natqde, x mz nibrde da lcng sc tqkape-kzpzle bamu. ");
INSERT INTO ntu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mz nzmu-krde lcde, bzkq yc zlwz mz drtwrmu da kx naprtz kalrla. Murde kalrla sa na-aoti drtwrmu da kx takitrde kalrla. X dalr zbqka takitxtrpwzle mzbq ka. Bzkq atamutilzamu dalr kalrla mz nzwzkr mzbq ka.” ");
INSERT INTO ntu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jiszs rpibzle kx, “Bzkq rpiamu kx takitrde doa nzayrplapx-katongr mz alwx ngrdeng, murde ma tqrpi kz Gct kx takitrde nzayrplapx-kato-krde nimu mz alwx ngrmung. ");
INSERT INTO ntu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Murde Gct sa na-ayrplapxle nimu mz nqmq krmu mz nqmq kcpwz tqrpi-ngrnamu kx na-ayrplapxle leplz mz nqmq krdr. X sa napi-kzpzle bamu kx navz-nqblqamu natq kcngpwz tqpibzmu mz leplz, kx navz-nqblqlrng. ");
INSERT INTO ntu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Murde mz nzrpi-krm kx doa takitrde nzayrplapxngr mz alwx ngrde, obqtiq alwx ngrde kc tqtopwzne, a' trmcwq alwx ngrm kc tqwzpx. Opxm kx obqtitrpzme dcvi kc tqtopwzne mz mz mzlem. A' trmcwq dapunounc kc tqyrbqpxm mz mzpq. ");
INSERT INTO ntu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Dekc tqrpi-ngrbzme mz mzlem kx, ‘E mzlenge e, nakatxpxbo ena dcvi la tqtopwzne tqycpxm mz mzpq.’ ?Memule tqkxmu nzycmne-krm lc? Murde dapunounc kxwzpx la tqycpxm mz mzpq! ");
INSERT INTO ntu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nim leplz kx narpi-rbz kx rlxngitiq! Kapx kai dapunounc la wzpx tqyrbqpxm mz mzpq, x nzmu mzpq kc tqopxpe mz nzrmcngr dcvi kc tqtopwzne tqycpxm mz mz mzlem. Atubqti-lzbq kai mz alwx ngrmqng x kztemqng kc ate. ");
INSERT INTO ntu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“A' bzkq abzq nzalvztrngr leplz kcng tzpxtxpx-zvz-ngrdr Nzryrngrkxtr. Murde mz nzale-krm da lc opxm kx katxnebzme natq kxtr mz kuli kzpeto, kcng nalxlvrtimlr nim mz nzmakx-krdr nim. X apu-kzle nzrtctx-krbzme dztu Gct mz poi, kcng narnzlvztineolrng mz drtc'.” ");
INSERT INTO ntu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jiszs rpi-mopwzle kx, “Rlxbz da mz Gct, x sa nakabzle. Rtangr da x sa narmctiq. Abc x naonrx sa nalvxpxbz. ");
INSERT INTO ntu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Murde doa kx rlx da kx takitrde nide, sa natwzle. X kx rtangrtile nzokatrkr Gct, sa nangida. X kx abctr-zvzbz mz Gct, naonrx nyz Gct sa nalvxpxbz bade. ");
INSERT INTO ntu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Murde trpnzngr trte doa kx rkabz mz mrlxde rplz mzli kx rlx-ngrbzle nade dakxnzng. ");
INSERT INTO ntu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","X trkapwzleu ningidoe mzli kx rlx-ngrbzle nc. ");
INSERT INTO ntu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nimu kcng trnztubq-zvzung krlzamu nzale-krmu da kxtubq mz nzrka-ngrbz da kxmrlz mz doa nemung. A' myapx-mopwz, Trtemu kc Heven krlzle nzale-krde da kxtubq mz nzrka-zvz-krbzle da kxmrlzti zlwz mz krkcng tzrlxbzng bade da. ");
INSERT INTO ntu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ale-zvzbzmu mz leplz da kx suti drtwrmu na-alebz bamu, kxmule-esz' trnzalepwzlru bamu. Murde krlc nzatutrngr nzalvztrngr amrlx mz Nzryrngrkxtr.” ");
INSERT INTO ntu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Jiszs rpi-mopwzle kx, “Mz nqmq lcpwz, naprtrq mz naonrx kxtotaki mz nzkrlz-krbzme lrpzki kc tqvz Heven. A' nakrlzq kx naonrx lc tqtotaki x lrpzki lc tqtopwzne rblx nzo-zlingr. Leplz trnzkqluung kx nzrmctilr naonrx lc. A' bzkq prtrq mz naonrx kc tqetu, murde ma tqrmctiq lrpzki kc tqvzkile mrkc tzodatingr leplz mz Hxl. Leplz kxnzkqlung nzvz-rbrng mz nzo-zli-krdr lrpzki lc tqyryz murde tr-rblxu nzo-zlingr.” ");
INSERT INTO ntu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Zbz rpibz Jiszs kx, “Mz nqmq lcpwz, bzkq vz-nqblqamu lrpzki r profet kxnzalvztr-rbrng. Sa naprtrpzng bamu mz nzapu-krdr kxnzrlxngiting, a' nzrpilr naodatilr nzrlxngiti-krmu, murde nidr angidr kxdrka'-ngrng. ");
INSERT INTO ntu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Sa naglxamu nidr, murde nqmq krdr aelwapx-ngrde namrlzu r leplz kc tqnginidr. Apule nounc amrlx kx nzglx-ngrdr nradr kcng tzpapx-ngrdr. Murde tr-rkeopwx'u naq mz nc nole, x dx mz nc lrpz. ");
INSERT INTO ntu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","A' nounc kxmrlz papx-ngrde nranc kxmrlz. X nounc kxtrka papx-ngrde nranc kxtrka. ");
INSERT INTO ntu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Opx angidr kx nounc kxmrlz trpapx-ngrdeu nranc kxtrka. X trpnz-kzngr nounc kxtrka kx papx-ngrde nranc kxmrlz. ");
INSERT INTO ntu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nounc kx trnzpapx-ngrdru nradr kxmrlz nzlakitiong x nzrtclz-ngrng mz nyr. ");
INSERT INTO ntu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mz nzmu-krde lcde, sa naglx-ngrnamu kxnzalvztr-rbrng mz da kxtrka kx nzvzpxmqng mz nqmq krdr.” ");
INSERT INTO ntu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jiszs rpibzle kx, “Leplz kcng amrlx tzrpimlr bange kx ninge Kxetu Lod rdr trnaprtrung amrlx ngrdr Heven, a' nangi txpwz krkcng tzvz-nqblqlr me pnz drtwr Trtenge kc Heven. ");
INSERT INTO ntu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Murde mz Mzli Kxmatq kc na-ayzlu-ngrbz Gct da mz leplz, leplz kxnzkqlung narpimlr bange kx, ‘Kxetu Lod! Plzpxbzkr mz leplz natq Gct mz drtqm, x rmaszlrpxkr drka', x ale-kzkr da kxmatqng kxkqlung mz drtqm!’ ");
INSERT INTO ntu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kxmule-esz', a' sa narpi-angidrbo badr kx, ‘Nimu kxdrka'-ngrng! Vzkipeamu kc! Trkrlzwxu nimu murde trvz-nqblq-angidrwamuu ninge.’” ");
INSERT INTO ntu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jiszs rpi-mopwzle kx, “Mz nzmu-krde lcde, doa kx xlrmle natqngeng, x yrlq-angidrleng, apule ncblo kxyrplapx kx wzti-angidrle ma nyzde. Ekqtiole gq lr nctrpou ngrdeng kxmqngi, vzo la mz rplz. ");
INSERT INTO ntu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mz nibrde, trlipu r tewa x nenq kc tqvzpem. Nenq wqq x nubla ngr lue yrle-zlwz-kzp, nzrpilr na-awxolr x nayrvilr ma kc. A' trmrtuu murde nctrpou ngrde tu-amqngio mz rplz. ");
INSERT INTO ntu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“A' doa kx xlrmle natqngeng x tryrlq-angidrleu, apule ncblo kxngqngu kx awxbutxopwzle ma nyzde mz drta'. ");
INSERT INTO ntu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mz nibrde, trlipu r tewa x nenq kc tqvzpem. Nenq wqq x nubla ngr lue yrle-kzp nzvztitrlr ma kc. X ma kc mrtuo x ngilialz-pnzm mz trlipu kc.” ");
INSERT INTO ntu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Mzli kc tqyrkrpxpengr nzalvztrkr Jiszs, zbo ngr leplz kcng nzkctitxpx-zlwzlr nzalvztr-krde. ");
INSERT INTO ntu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Murde trapuleu Kxnzalvztrng mz Loukxtr, a' ycmnemile zmatq angidr. ");
INSERT INTO ntu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mzli kc Jiszs tqvzo-ngrmle mz nra kc mz nibr nzalvztrngr lc, zbo ngr leplz kxnzetung sc tzma-nqblqpelr nide. ");
INSERT INTO ntu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Zbz kzdq ncblo kx ycngr lepz vzm, x rwetxobz zpr mz Jiszs. X rpibzle bade kx, “Kx tqsuti drtwrm le, krlzx kx krlzq nzamrlzngr ninge!” ");
INSERT INTO ntu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kxmule-esz' mz Lou sc Mosis batrpzle trnztakitr-krdeu nzprtrngr mz nzangiongr, a' maletxtrpzle nide. X sc tqrpipebzle kx, “Mrlzm bange. Namrlzq.” X mzli kcpwz kxsqki lepz kc mztxtr pnz kz. ");
INSERT INTO ntu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Zbz rpi-kzpzle bade kx, “Bzkq ena ncblo kx napi-nebanle. A' vz-kaipz mz pris, x pibz bade napwxlitibzle nrkrdrtqm, murde namcpzle kx mrlzpeq. Zbz sa napipxbzle mz leplz, murde namnc-lxblr-mouamu badr. X kabz blz mz Gct, da kc tqwai nzpikr Lou sc Mosis le, x nakrlzngr leplz amrlx kx tubqpeq mz Loukxtr.” ");
INSERT INTO ntu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jiszs badr ncblo nedeng nzvzng mz taon Kzpznizm, mz nqlvi r Dxbu Gzlili. X kzdq lr Rom kc tqngi kxetu r dzbe ncblo ngr vea kx trtqki-esz' (100), vzm mz nzrmcti-krde Jiszs, murde rpile Jiszs naokatrpzle nide. ");
INSERT INTO ntu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","X sc tqrpipebzle bade kx, “Kxetu, kxnzawz-nrbalq nenge sc tqyrbqpe ma nyznge. Nrkrdrtqde bz x sc tqtangigx zlwz.” ");
INSERT INTO ntu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Rpibz Jiszs bade kx, “Mrlz. Sa navzmc ma nyzm na-amrlzbo nide.” ");
INSERT INTO ntu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","A' rpibz kxetu kc mz Jiszs kx, “Eke, Kxetu! Bzkq kxpuneme nzvz-ngrm ma nyznge. Murde trtakitrpwc'u nzdwatr-krme ma nyznge. Krlzx kx rngiscm zmatq kxmyalz zlwz. Pi txpwz dq ye natq, x ncblo nenge sc tqmrlzpe. ");
INSERT INTO ntu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Murde mnclz-kzpo mz zmatq ngr kamadz rnge. X ncblo ngr vea nengeng nzmnclzmqng bange. Kx narpibo mz kzdq kx, ‘Vz!’ x sc tqvzpe. X kx narpibo mz kzdq kz kx, ‘Vzm!’ x sc tqvzpem. X kx narpibo mz kxnzawz nenge kx, ‘Da kx na-aleq se!’ x sc tqalepele.” ");
INSERT INTO ntu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kx xlrbz Jiszs natqdeng, kctitxpx-zlwzle. X sc tqrpipebzle mz leplz kcng tzvz-nqblqlr nide kx, “Napi-zpwxbo bamu, nzrlxngitikr lr Israel trmyaszpxleu nzrlxngitingr lc! ");
INSERT INTO ntu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","X napi-kzpo bamu, mz nrlc tulvzo leplz kxkqlu kxtrngiulrJiu sa naprtrng mz nzmungr kxetu x namu-lxblrng badr melrmqgung Ebraam x Aesak x Jekop, mzli kc Gct na-aclve-ngrde nrlc kxmrna kalr mz nzngini-krde king. ");
INSERT INTO ntu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","A' nimu lr Jiu kcng tqrpiamu kx sa naprtramu Heven, sa nartctxtrngr Gct nimu mz nzlo ngr Hxl, murde trvz-nqblqwamuu nqmq krde. X mz nzmnc-krmu mrlcde, sa nayrni-aloamu mz nzetqkr drtqmu x sa namadqtiamu nqngimu mz zngya, murde mnc-rlrupebzmu bade.” ");
INSERT INTO ntu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Zbz Jiszs sc tqrpipebzle mz kxetu kc kx, “Vzpe ye ma nyzm. Mzli ka da kc tqlxngitiq, sa narmctiq.” X mzli lcpwz, doa kc sc tqmrlzpe. ");
INSERT INTO ntu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jiszs badr ncblo nedeng nzvzng mz ma nyz Pita. Jiszs kx dwatrpzle kc brma, sc tqmcpele kzdo Pita kc tqngi olvz, sc tqmnz me mnz-ngrde murde drtqde pqpxm. ");
INSERT INTO ntu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Zbz Jiszs vzbz malebzle mqde mz nzamrlz-krde nide, x zyagox kc yrkrtxpx pnz. X tulzm sc tqoliqtipebzle dakxnzng nadr. ");
INSERT INTO ntu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mzli kc nepi tqtaope-ngrde, x Sabat kc tqyrkrpxpe-kzpz, lr Kzpznizm sc tzryrkrmipemqng doa kxkqlu kx nzdwaszng drka'. Zbz Jiszs sc tqmaszlrpxpe-ngrde drka' amrlx mz leplz lcng mz zmatq ngr natqde. X amrlzti-kzle leplz kx nzyagoxting amrlx. ");
INSERT INTO ntu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","X mz nzalekr Jiszs le, atutrle natq kc tqplzpx pnz profet Asaea mz nzycmnetr-krde mz Kxnzmcpx. Rpile kx, “Ncblo lc ayrkrpxpele nzmewe-krgung, x amrlzpele nzyagox-krgung.” ");
INSERT INTO ntu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Mzli kc Jiszs tqmc-ngrde leplz kxkqlu nzyrlwr-ngalelvz-krdr nide, sc tqrpipebzle mz ncblo nedeng nzalilvckio-krdr badr mz nrlar dxbu kc. ");
INSERT INTO ntu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","A' mzli kc tzoliq-ngrdr nzalilvc-krdr, kzdq kxalvztr mz Lou sc Mosis vzm mz Jiszs, sc tqrpipebzle bade kx, “Kxakrlz, sa navz-nqblqx nim drlve keng vzkiq.” ");
INSERT INTO ntu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","A' rpibz Jiszs kx, “?Krlz-angidr-kzq da kx ycpxm mz nzrvz-nqblqngr ninge? Murde fokis nzmnc-zpwxng mz ma nyzdr kx yclzm mz gq. X utc nzmnc-zpwx-kzng mz ma nyzdr kx ngi nrla r nounc. A' ninge Mrlx Leplz, trmnc-zpwxwxu, murde lr mrnyzngeng nzpxtxpx-ngrdr ninge. X sa napxpx-kz-ngrdr nim. ?Myx kxmule, navz-nqblqpeq ye ninge?” ");
INSERT INTO ntu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Zbz kzdq kz ncblo kx vz-nqblq-kzle Jiszs, rpibzle bade kx, “Kxetu rnge, na-ale-kaipo nikeng pnz drtwr trtenge mzli ka, a' mz nibr nzbz-krde sc tqvz-nqblq-atex nim.” ");
INSERT INTO ntu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","A' rpibz Jiszs bade kx, “Trtingr! Rlrpe-ngrbz ye mz krkcng mqngrdr nzbzpeng nzyrtzmq-krdr kxnginidr kx nabzng. A' nim, vz-nqblq ninge!” ");
INSERT INTO ntu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Mz nibrde, sc tqprtzpe mz bot scdr kxetu, x ncblo nedeng nzprtz-kzpzng x sc tzalilvcopeng. ");
INSERT INTO ntu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Zbz sc tzpwrkilvcpe-ngrdr kzdq nenq kxetu. X dxka kxetuting sc tqvzopebz mz nabz bot kc. A' mzli lc, Jiszs sc tqmwi. ");
INSERT INTO ntu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Zbz ncblo nedeng nzvzbzng bade x sc tzameopelr nide. Nzrpibzlr kx, “Kxetu, arlapx nigu! Nabzpeku!” ");
INSERT INTO ntu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","A' rpibz Jiszs badr kx, “?Memule tqmwxlrtx-zlwz-ngrnamu? ?X memule nzlxngiti-krmu ninge tqtopwzbe-ngrde?” Zbz tulzm, sc tqlclvzpele nenq x dxka. X mzli kcpwz nrwx otx pnz. ");
INSERT INTO ntu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","X nidr amrlx ngrdr sc tzkctitxpxpelr Jiszs, tzrpi-etrpelr kx, “Eke! ?Ncblo kznika? Nenq x dxka nzvz-nqblqlr natqde!” ");
INSERT INTO ntu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Zbz Jiszs badr ncblo nedeng sc tzkrlzopebzlr nrlar dxbu kc, mz nrlarnrlc kc taon Gergesa, me nzmnc-ngrdr kxtrngiulrJiu. X ncblo nzling kx dwasz drka', nzmncng mz butqbr mrkc tzyrlqngr leplz kxbz. Mrlx lcng nzxplr-zlwzng x nzatrkati-kzlr leplz. X leplz nzmwxlrng mz nzvzki-krbzlr mrkc tzmnc-ngrdr. Ncblo lcng sc tzvzpxpemqng mz butqbr nyzdr mz nzrmcti-krdr Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","X sc tzkabomipebzlr bade kx, “Vrr! Mrlx Gct! ?Nike tqotime? Bzkq ayrplapxq nrkrdrtqgr mzli ka, murde trkrlzkapzle Mzli Kxmatq kc na-ayrplapxngr.” ");
INSERT INTO ntu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","X mnc-aepztrpz mrkc kzdq nrtrq r poi kxetu, sc tzmung. ");
INSERT INTO ntu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Drka' kcng nzyrnititrpzlr bade kx, “Kx tqmaszlrpx-ngrn nigr, atwzlr-ngrbz nigr mz nrtrq r poi kc.” ");
INSERT INTO ntu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Zbz sc tqrpipebz Jiszs mz drka' kcng kx, “Prpxamu!” X drka' kcng kx nzprpxlr, nzdwasz-pnzlr poi kcng. X nrtrq r poi kc, sc tzvopxpeng mz nqngitrlqli, nztaong mz nabz dxbu kc, x nzbzting amrlx ngrdr mz lue. ");
INSERT INTO ntu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Zbz ncblo kcng tzaclveng, nzngrlrng, sc tzpinepelr nrpa ngrde mz mztea, myapxbz kxmu nzmncpekr doa kcng nzling tzprszpxpelr drka'. ");
INSERT INTO ntu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mz nzmu-krde lcde, leplz kxnzkqlung ngr taon kcma sc tzyrkrpeng mz nzmc-krdr Jiszs. X kx nzkrlzbzlr nide, nzyrnititrpzlr bade kx navzpe. ");
INSERT INTO ntu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Zbz Jiszs prtz mz bot, nidr badr ncblo nedeng x sc tzalilvcope-moung mz taon Kzpznizm mrkc tzmnc-ngrdr. ");
INSERT INTO ntu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kx nzkrlzbzlr kc Kzpznizm, kzdung ncblo nzvzmqng, nzglqmlr kc ncblo kx nrkrdrtqde bz. Nzglqtimlr kzdq nqni. Kx krlztrpz Jiszs nzbrtikr drtwrdr nide mz nzamrlz-krbzle kztedr, sc tqrpipebzle bade kx, “Mrlxnge, bzkq nabzm talvzope, murde alwx ngrmqng ipqpxpebo.” ");
INSERT INTO ntu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kx nzxlrbz kzdung lr Jiu kcng tzalvztrng mz Loukxtr nzycmne-krde lc, sc tzrpipelr mz drtwrdr kx, “Rlr! Mrlx lc pivxile Gct. ?Mz drtwrde apule Gct?” ");
INSERT INTO ntu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jiszs krlztitrpebzle da kx ycpxm mz nabzdr. X sc tqrpipebzle badr kx, “Bzkq aoti drtwrmu da kxtrka kxmule lc. ");
INSERT INTO ntu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nzmu narpibo mz ncblo lc kx, ‘Ipqpxpebo alwx ngrm,’ rblx nzrmcngr. A' nzmu narpibo bade kx, ‘Tulz x vzpe,’ opx angidr nzrmcngr. ");
INSERT INTO ntu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mz nzmu-krde lcde, na-amrlzbo nrkrdrtqde mz nzaelwapx-krnge kx ninge, Mrlx Leplz, rngisc-kznge zmatq ngr nzipqpxngr alwx mrka mz nrlc.” X sc tqrpipebzle mz ncblo kc nrkrdrtqde tqbz kx, “Mrlxnge, tulz, oti nqni pnrm x vzpe mrnyzm!” ");
INSERT INTO ntu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","X ncblo kc tulzm x sc tqvzpe mrnyzde. ");
INSERT INTO ntu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kx nzmc zbo ngr leplz da lc, nzamatqlr Gct. X nzglqpxlr nide x awi-ngrbzlr bade nzrka-krbzle zmatq ngrde mz ncblo murde na-amrlzngr leplz x naipqpxngr alwx ngrdr. ");
INSERT INTO ntu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jiszs rlaszle mrlc, x mz nzvz-krde mcle ninge, ncblo kx atakqti takes drtqnge Matiu. Sc tqwxbux mz ofis nyznge kc tzxpekitr takes, x rpim Jiszs bange kx, “Vz-nqblqm ninge.” Zbz tutxlzmc, axtxbo da amrlx, x sc tqvz-nqblqpex nide. ");
INSERT INTO ntu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mz nibrde, Jiszs sc tzmupeng badr ncblo nedeng mz ma nyznge. X kztengeng kx nzatakqting takes x kzdu-moung leplz kx nqmq krdr trka mz nzobqkr leplz mu-lxblr-kzkr badr. ");
INSERT INTO ntu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mzli kc tzmc-ngrm Farzsi da lc, drtwrdr trmrlzpeu. Murde mz drtwrdr trtakitrdeu ncblo kxmrlz nzngini-krde kzte ncblo kxnztrkang. X sc tzveapebzng mz ncblo nedeng kx, “?Nike kxakrlz ngrmu tzmu-lxblr-ngrdr badr leplz kxnzmulr lcng?” ");
INSERT INTO ntu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Xlrbz Jiszs natqdr x sc tqrpipebzle badr kx, “Leplz kx trnzyagoxung trnzsutiu drtwrdr dckta. A' kxnzyagoxng la tzsuti drtwrdr dckta. ");
INSERT INTO ntu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Na-aoti drtwrmu drtwr ngr Nzryrngrkxtr kc tqrpile kx, ‘Da kx mrlzm bange, doa nengeng nayc mz drtwrdr leplz mz nzokatr-krdr nidr namyaszpxle nzrka-krmlr bange blz.’ Murde trvz-ngrpwc'u nzrkqlengr leplz kx nzrpilr nztubqng. A' vz-ngrmc nzrkqlengr kxnzaleng alwx, murde naesablqtilr alwx ngrdrng.” ");
INSERT INTO ntu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mz nqmq krgr, nigr lr Jiu, nzaxtx-krgr dakxnzng zbq li mz wiki kxesz' mz nzkrka'ngr. Zbz oblamzng Jon Kxawrkxtr nzvzmqng mz Jiszs x sc tzveapebzng bade kx, “Nigr badr Farzsi axtxbzkr dakxnzng. ?A' nike ncblo nemqng trnzaxtx-ngr-kzpzlru da?” ");
INSERT INTO ntu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jiszs rpibzle kx, “Apux ncblo kxnayrlz. Mz nzmu-krde lcpwz trtakitrdeu drtwr leplz nzvz-krdr mz mzli r nzabrtzngr mz nzyrlzngr, trtakitr-kzdeu ncblo nengeng nzaxtx-krdr dakxnzng mzli ka. Murde nzabrtz-ngrdr ninge lc tqmncbepo badr. A' mz nibrde, mzli kc nakatxpx-ngrmc badr, sc tqtakitr-atede nzaxtx-krdr dakxnzng mz nzkrka'-krdr.” ");
INSERT INTO ntu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jiszs rpi-mopwzle kx, “Nzycmne-ebzpxngr lcng li nzaelwxpx-ngrdr nqmq krnge kxmrna. Murde trpnzngr ncblo kx rkxsilvztr dzlvq lrpz kxmrna mz nzakqlvztr-krde me bxnge mz lrpz kxblzlongr. Nzmu nawailele, dzlvq lrpz kc sc tqbxplipxpem mz lrpz kcma tqblzlongr. X sc tqbxplipx-zlwzpe myaszpxle mzli kc kai tqbxpli-ngrde. ");
INSERT INTO ntu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","X trpnz-kzngr ncblo kx narbzlutr dakxnzng kxmrna mz ncblei kx nzrbzlutrpengr dakxnzng. Murde ncblei kxmule lcde ngcplxtxtr kai mz nzmrnabekr dakxnzng, x da lcng li sc tzatrkatipeng. A' dakxnzng kxmrna nabzlutrpwz mz ncblei kxmrna murde namrlzpwzng rlilrdr.” ");
INSERT INTO ntu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mzli kc Jiszs tqycmnebe-ngrde, kzdq kxetu r mangr-nzkrka'ngr nyzdr vzbz x rweobz zpr bade. Rpibzle kx, “Inyxnge mwx bzpe mzli ka. A' vzm, maletrpz nrkrdrtqde, x sa nalu mou.” ");
INSERT INTO ntu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Zbz Jiszs tulzm x sc tzvzpeng ncdr x nigr ncblo nedeng kz. ");
INSERT INTO ntu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mzli lc kzdq olvz kx tresakiu nzrpwx-krde temz vzm mz nibr Jiszs. Nzrpwx-alo-krde lc temz, twztipelele yiz nzpnu-esz'-nrade-li (12). Sc tqmaletrpebzle lrpzde. ");
INSERT INTO ntu_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Murde rpi drtwrde kx, “Nzmu namaletxtrpwo ye lrpzde, nrkrdrtqnge sc tqmrlzpe.” ");
INSERT INTO ntu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Zbz Jiszs lxlvrkimle mq, sc tqmcpele olvz kc. X rpibzle bade kx, “Inyxnge, bzkq nabzm talvzope, murde nzlxngiti-krm ninge sc tqamrlzpele nim.” X mzli lcpwz olvz lc sc tqmrlzpe. ");
INSERT INTO ntu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Mz nibr nzamrlzkr Jiszs olvz kc, sc tqvzpe mou. X kx krlzbzkr ma nyz kxetu kc, sc tqmcpele kxnzvxutrng ncblei x zbo ngr leplz kcng tzyrni-katong mz mzli r nzbzngr. ");
INSERT INTO ntu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Zbz sc tqrpipebzle badr kx, “Yrkrpxamu yz! Doa lc trbzu, a' mwine ye!” A' nzyrpalelvzlr nide. ");
INSERT INTO ntu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mz nibr nzvzpxkr leplz amrlx kcng yz, sc tqvztrpe brma. Rtrngztiobzle mq doa olvz kc x sc tqtulzpem. ");
INSERT INTO ntu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","X nrpa ngr nzamrlz-krde doa olvz kc vz x talvzpxle nrlarnrlc kc. ");
INSERT INTO ntu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jiszs rkalzm mz ma kc, x mzli kc tqvz-ngrde nzrvz-nqblqbzng kcng ncblo kx mztr mwi nzling. Sc tzkqlepelr nide, nzrpibzlr kx, “Mrlx Devet! Nayc mz drtwrm nigr!” ");
INSERT INTO ntu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Zbz Jiszs kc tqvztrpe mz kzdq ma, ncblo kcng nzling sc tzvztrpe-kzpzng bade. X rveabz badr kx, “?Lxngitiamu kx krlzx nzamrlz-ngrbz nimu?” X nzrpibzlr bade kx, “Eu, Kxetu!” ");
INSERT INTO ntu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Zbz Jiszs bxtrpzle mztr x rpibzle kx, “Amrlzx nimu murde drtwrmu br kx rngiscnge zmatq ngr nzalengr da lc tqrlxtiamu.” ");
INSERT INTO ntu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","X mzli lcpwz mztr kc tqobqpxpe. A' xplrmibz natq Jiszs mz nzrpi-krbzle badr kx, “Bzkq pinebzmu da lc mz leplz!” ");
INSERT INTO ntu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kxmule-esz', a' nzvzng x sc tzyapwxtinepelr nrpa mz nrlc amrlx mz nrlarnrlc kc. ");
INSERT INTO ntu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mz nibr nzvzpekr ncblo kc nzling, kzdung leplz nzvzmimlr kc mz Jiszs ncblo kx batrpz drka' nznabu-krde. ");
INSERT INTO ntu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","X mzli kcpwz tqmaszlrpxpe-ngrbz Jiszs drka' kc, ncblo kc sc tqycmnepe. X zbo ngr leplz kcng nzkctitxpxlr da lc x nzrpilr kx, “Rlr! Trgalr da kx mcku kxmule ka mrka Israel!” ");
INSERT INTO ntu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","A' kzdung Farzsi nzrpilr kx, “Setzn ela, kxetu r drka', nide kc tqrkabz zmatq mz Jiszs mz nzmaszlrpx-krdeleng.” ");
INSERT INTO ntu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Zbz Jiszs sc tqvztipele mztea amrlx mrlcdeng, tqalvztrpe mz mangr-nzkrka'ngr nyzdrng, x tqyapwxtipxle Nrpakxmrlz kx Gct sa tqvectrpemle leplz mz nzmnclz-krbzlr bade mz nzngini-krde King rdr. Mzli lc Jiszs amrlz-kzle kxnzyagoxng x kxnzdwatibzng zyagox kxtrka. ");
INSERT INTO ntu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mzli lc tqmcpengr Jiszs zbo ngr leplz kcng, sc tqyctx-zlwzpengr drtwrde nidr. Murde nabzdr talvzo x rblx nzokatr-lzbq-krdr mz nzrmcti-krdr Gct, a' nzapulr sip kcng trtxpnzngr kxaclvele nidr. ");
INSERT INTO ntu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Rpimle bagr, nigr ncblo nedeng kx, “Kxmule-esz' leplz kxkqlu nzoliqng mz nzlxngiti-krdr Nrpakxmrlz murde nanginidr doa neng Gct, a' mzli ka kxnzwzng nzpipzbeng kx nzaelwapx-ngrbzlr lrpzki angidr mz leplz. ");
INSERT INTO ntu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mz nzmu-krde lcde, krka'-ngrbzmu mz Trte kc tqoliqtile nabz leplz kcng tzbrti drtwrdr ninge. Rlxtibzmu bade nzatwzlr-krmle kzdung mou kxnzawzng kx naokatrng mz nzvzmi-krmlr leplz bange.” ");
INSERT INTO ntu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Zbz Jiszs sc tqkqlepele nigr aposol kcng nzpnu-esz'-nrade-li (12). Mz nzmnclz-krbzkr bade, sc tqrkapem bagr zmatq kx narmaszlrpx-ngrgr drka' x na-amrlz-ngrgr kxnzyagoxng x kxnzdwatibzng zyagox kxtrka. ");
INSERT INTO ntu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Drtqgr nigr aposol kcng nzpnu-esz'-nrade-li (12) nidr seleng: kx ayrnrngr Saemon, kc kzdq drtqde Pita, x mzlede Adru, Jemes mrlx Sebedi, nidr mz mzlede Jon, ");
INSERT INTO ntu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, x Batolomiu (mrlx Tolmai, kc kzdq drtqde Natzniel), Tomas x ninge Matiu kc tqatakqti ena takes, (kzdq kz drtqnge Livae), x Jemes kc tqngi mrlx Alfizs, x Tadizs (kc tzrpi-kzpz Judzs), x ");
INSERT INTO ntu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saemon kc tqprtr ena mz dzbede kc tzrpilr namaszlrtxpx-ngrdr gzpman ngr Rom mz nzmnc-krdr Israel, x Judzs Iskariot, kc tqamwabzle Jiszs mz enqmi rdeng. ");
INSERT INTO ntu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jiszs atwzlrpx-ngrde nigr aposol mz nzryapwxpx-krgr Nrpakxmrlz. Rpimle bagr kx, “Bzkq vznamu mz mztea nyz kxtrngiulrJiu x mztea nyz lr Szmariz. ");
INSERT INTO ntu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","A' vzbzmu mz leplz negung mrka Israel murde trnzvz-nqblqlru nqmq kr Gct mz nzapu-krdr sip kcng tzmrbrneng. ");
INSERT INTO ntu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Drlve keng vzkiamu, yapwxtipxamu Nrpakxmrlz lc mz nzrpi-krbzmu kx, ‘Gct sa tqvectrpemle leplz bade. X mzli ka mzli r nzmnclz-krbzmu bade mz nzngini-krde King rmu.’ ");
INSERT INTO ntu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","X amrlzamu kxnzyagoxng x kxnzyc-ngrng lepz, x maszlrpx-ngrnamu drka', x alu-mouamu kxnzbzng. A' mz nzokatr-krmu nidr, bzkq rlxamu da, murde mz nzokatr-krnge nimu, da amrlx ka-nrbalqbo bamu. ");
INSERT INTO ntu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","X bzkq rtwzamu trau mz nzvz-krmu. ");
INSERT INTO ntu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","X bzkq rtwz-kzamu bxli, nzkq krali, sadol krali, x nctoko. Murde leplz kcng naokatramu takitrde nzka-krbzlr da lcng bamu. ");
INSERT INTO ntu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Mztea kznike nzabrtzlvzlr nzmnc-krmu badr, ma kznike nzrlr-ngrbz namnc-ngrnamu, mncamu ma lcde esz', nakrlzbzle mzli kx rlasz-ngrnamu mztea lcde. ");
INSERT INTO ntu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mzli kc tqdwatr-ngrnamu mz kzdq ma, rpibzmu mz lr ma lcde kx, ‘Krka'-ngrne kx Gct na-amnc-zpwxle nimu!’ ");
INSERT INTO ntu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nzmu leplz lcng kx tzabrtzlvzlr nimu, Gct sa na-angidatibzle nzkrka'-krmu. A' nzmu leplz lcng kx tzpxtxpx-ngrdr nimu, trpnzngr nzangidatingr natqmu, a' sa nayzlu-mop bamu. ");
INSERT INTO ntu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","X nzmu kzdung lr ma o lr mztea kznike nzpxtxpx-ngrdr nimu x trnzlalztqpwzung bamu, mzli kc tqrlaszpe-ngrnamu nidr rtc-ngrbzmu rplz, nakrlz-ngrdrle kx nqmq krdr trka mz nzapu-krdr kxnzmnc-mrbrng. ");
INSERT INTO ntu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","A' napi-angidrbo bamu kx mzli kc na-ayzlu-ngrbz Gct da mz leplz kalr, nzayrplapx-krde nidr sa namyaszpxle lr Sodom x lr Gomora, kxdrka'-ngrng kcng bqnc.” ");
INSERT INTO ntu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Rpi-mop Jiszs bagr kx, “X nakrlz-angidramu kx na-atwzlrpx-ngrne nimu mz nzryapwx-krbzmu mz leplz kxdrka'-ngrng, mz nzapu-krmu sip mz mzlir kuli kzpeto. Mz nzmu-krde lcde, aclvetioamu nidr x bzkq vz-rbramu. ");
INSERT INTO ntu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Aclvetio-angidramu, murde leplz sa nalolvzlr nimu x navzmilr nimu mz kot. X naiklapxmlr nimu mz nabz mangr-nzkrka'ngr. ");
INSERT INTO ntu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","X navzmibzlr nimu mz kxnzetu ngr mrkzbleng x mz king mz nzayrplapx-krdr nimu, murde vz-nqblqamu ninge. X mzli nyzmu lcpe kz mz nzyapwxtipx-krbzmu Nrpakxmrlz mz kxnzetu lcng x kxtrngiulrJiu kxnzkqlung. ");
INSERT INTO ntu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mzli kc nalolvz-ngrmu, bzkq da kx nakxne drtqmu mz nrpa kx napiamu x kxnamu nzycmne-krmu. Murde mzli lcde Gct sa nakabzle bamu nrpa kc napiamu. ");
INSERT INTO ntu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","X natq lcng trnavzpxpwqung bamu, a' nabatrpz Mqngrkxtr mz nzvz-nqblq-krde me pnz drtwr Gct Trtemu. ");
INSERT INTO ntu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Mzli lcde, leplz sa nakabzlr mzledrng kcng tzvz-nqblqlr ninge mz enqmi rdrng mz nznibq-krdrleng. X trte doa kz sa nawaisr-ngrde kz doa nedeng mz nzrnibqngr nidr. X doa na-atrkati-kzlr trtedr x lxedr x naka-kzpzlr mz enqmi rdrng mz nznibq-krdrleng. ");
INSERT INTO ntu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Leplz kxnzkqlung sa napxtxpx-ngrdr nimu, murde nimu leplz nengeng. A' nzmu natu-amqngi-zvzamu mz nzrlxngiti-krmu krlzbzle nzbz-krmu, sa na-arlapx Gct nimu. ");
INSERT INTO ntu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mzli kc tzatrkati-ngrmu mz kzdq mztea, vzki-alzuamu dq mztea kzble. X nakrlz-angidramu kx trpnzngr nzayrkrpx-krmu nzyapwxtipx-krbzmu Nrpakxmrlz mz lr mztea amrlx mrka Israel, x ninge Mrlx Leplz sc tqyzlupemc. ");
INSERT INTO ntu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Trpnzngr oblamz kx myaszlzle kxakrlz ngrde, x kxnzawz trmyaszlzleu kxetu rde. ");
INSERT INTO ntu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","A' nimu oblamzngeng x kxnzawz nengeng na-abrtzlvzamu nzapu-krmu ninge, kxetu rmu. A' kx tzrpilr ninge kc tqngi Trtemu Beelsebol kc tqngi Kxetu r Drka', sa nakqle-ngrbzlr nimu drtq kx nztrka-zlwzng mz nzngini-krmu lr ma nyzngeng.” ");
INSERT INTO ntu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Rpi-mop Jiszs kx, “Kxmule-esz' leplz na-atrkatilr nimu murde vz-nqblqamu ninge, a' bzkq mwxlrtiamu nzryapwx-krbz badr. A' ayrbq-zpwx-ngrbz da kx nzyrlq-kapqting. X pipxbz da kx nzxpqbrlvzlr me naxlr-lxblr-ngrdrle. ");
INSERT INTO ntu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mz nqmq lcpwz, nike pibo bamu esz'-krmu, aopxbzmu mz leplz me nzyrlwrpx-lxblrngr. ");
INSERT INTO ntu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Bzkq mwxlrtiamu nzrnibqkr leplz. Murde krla tznibq-txpwzlr nrkrdrtqmu. A' namwxlrti-txpwzmu Kxetu kc tqodatile nrkrdrtq x mqngr leplz kxnztrkang mz Hxl. ");
INSERT INTO ntu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","31","Kxmule-esz' nzamwangr boblz kxli trau rde pipzne, a' trpnzngr boblz kx nabz, a' ngi txpwz kx rlrpxngr Gct nzbz-krde. A' nimu myaszlzamu boblz kxkqlu! Murde nqnginarmu amrlx, rlwxti kz Trtemu kc tqaclvele nimu. Mz nzmu-krde lcde, bzkq mwxlrtiamu leplz. ");
INSERT INTO ntu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Murde doa kx abrtzlvzle ninge mz mz leplz mz nrlc ka, sa na-abrtzlvz-kzx nide mz mz Trtenge mrkc Heven. ");
INSERT INTO ntu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","A' doa kx pxtxpx-ngrde ninge mz mz leplz mz nrlc ka, sa napxtxpx-kz-ngrne nide mz mz Trtenge.” ");
INSERT INTO ntu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Rpi-mop Jiszs bagr kx, “Bzkq rpiamu kx vz-ngrmc nzrtwz-krmc nrwx mz leplz mz nrlc ka. A' vz-ngrmc murde kxnzrlxngiting x kxtrnzrlxngitiung drtwrdr trnaesz'tiu. ");
INSERT INTO ntu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Mz nzmu-krde lcde, enqmi r doa sa navzpxm mz ma nyzde. Kxmule-esz' trte, o lxe, o mrlx, o inyx, o mzle-lzbq, o ile-lzbq, o kzdo-lzbq, o lvxbq-lzbq, a' doa lcng amrlx sa na-aki-lzbqng mz nzrlxngitingr ninge. ");
INSERT INTO ntu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Doa kx takitrde nzvz-nqblq-krde ninge, namrlzti nivz lrde ninge namyaszpxle kxnginideng, kx apule trtede, lxede, mrlxde o inyxde. X bzkq rlr-ngrbzle nzrpwa'-krbzlr bade nzvz-nqblq-angidr-krde ninge. ");
INSERT INTO ntu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Murde doa kx takitrde nzvz-nqblq-krde ninge, naglqlzle kros ngrde mz nzrlr-lzbq-krmle bange, navz zvz kxmule-esz' bztrp bange. ");
INSERT INTO ntu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Murde doa kx otr-zvzngr drtwrde nzlu-krde mz nrlc ka, sa namale-lvile nzlungr kxboi. A' doa kx yrlqtxole nzlu-krde murde vz-nqblqle ninge, sa naprtr mz nzlungr kxboi.” ");
INSERT INTO ntu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Rpi-mop Jiszs bagr kx, “Mrlx kx abrtzlvzle nimu mz nzngini-krmu doa nengeng, lxngiti-kzle ninge. X krkc tqlxngitile ninge, lxngiti-kzle Trtenge kc tqatwzlr-ngrmle ninge. ");
INSERT INTO ntu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mrlx kx abrtzlvzle doa kx ngi menrpa ne Trtenge murde plzpxle natq Trte, Trtenge sa nakabzle bade da kxmrlz kcpwz tqtwz menrpa lcde. X mrlx kx abrtzlvz-kzle doa kxtubq murde nztubq-krde, Trtenge sa nakabzle bade da kxmrlz kcpwz tqtwz doa lc tqtubq. ");
INSERT INTO ntu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mrlx kx rkabz lue kxbao kx namnq doa txne kx vz-nqblqle ninge, Trtenge sa naka-angidrbzle bade da kxmrlz mz nzabrtzlvz-krde nide.” ");
INSERT INTO ntu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Mz nibr Jiszs nzalvztr-krde nigr aposol kcng nzpnu-esz'-nrade-li (12) mz da kx napibzkr mz leplz, nigr kc tqvzpekr. Zbz Jiszs rkalz-kzp mrlcde, x sc tqvzpe mz nzalvztr-krde x nzryapwxpx-krde mz kzdung kz mztea ngr Gzlili Provins. ");
INSERT INTO ntu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Mzli lc Jon Kxawrkxtr sc tqmnc mz presin. Kx xlrle da kcng tqale Kraes, sc tqatwzlrpe-ngrbzle kcng oblamzdeng bade. ");
INSERT INTO ntu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Sc tzveapebzng bade kx, “?Nim Kxnzmcpx kc tzpi kx navzm, o na-aenzli-moukr dq ncblo kzble?” ");
INSERT INTO ntu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ayzlu-ngrbz Jiszs natqdr kx, “Yzluamu x pibzmu mz Jon da kcng tqxlramu x tqmcamu mrka mz nzatutr-krnge natq Profet Asaea mz nzycmnetr-krde Kxnzmcpx. ");
INSERT INTO ntu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Rpile kx, ‘Kxmztr kcba nzobqpeng, kxnzbxplong nzvznepeng, kxnzyc-ngrng zkrkqlu nzlqngipe-moung, kxnradrtqdr ngq nzxlrpeng da, kxnzbzpeng nztulz-moung, x Nrpakxmrlz nzyapwxtipxbz mz leplz kxnzobqszong.’ ");
INSERT INTO ntu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Sa namrlzbz mz ncblo kx trpxpx-ngrdeu ninge mz trnzale-krngeu nike pnz drtwr leplz kx nangi nzwzkr Kxnzmcpx.” ");
INSERT INTO ntu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mzli kc tzvzpe-ngrdr menrpa neng Jon, Jiszs kc tqpipebzle mz leplz kcng nzmyalzkr Jon. Rpibzle kx, “Trvz-ngrpwzmuu mz Jon mrkc lzke mz nzmc-krmu ncblo kx tekqtr-zvzle da kx pile, mz nzapu-krde neni kx yamengr nenq mrkang kqlu. A' kc tqvz-ngrbzmu naxlramu natq angidr. ");
INSERT INTO ntu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","X trvz-ngrpwzmuu nzmc-krmu ncblo kxrngisc, kx pxi-ngrde lrpz kx nzxpengr lqlwx. Murde ncblo kxmule lc trnzmcu mrkc lzke, a' nzmcpwz mz ma nyz king. ");
INSERT INTO ntu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Krlc tqvz-ngrbzmu murde namcamu kzdq profet. A' napibo bamu ncblo lc tqmcamu myaszlzle profet kcng bqnc. Murde nzwz-krde myaszlzle nzwzkr profet amrlx. ");
INSERT INTO ntu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Murde Jon nide menrpa kc tqplzpxle nzvz-krm Kxnzmcpx. Da kc tqwai nzpipxkr Gct le mz Nzryrngrkxtr kx, ‘Krlc menrpa nenge. Sa na-atwzlr-ngrne nartwayz-kaipz bam, murde naokatrle leplz nengeng mz nzoliqti-krdr nzvz-krbzme.’” ");
INSERT INTO ntu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Rpi-mopwz Jiszs kx, “Napibo bamu, trpnzngr ncblo mz nrlc, kx myaszlzle Jon Kxawrkxtr, abzo mzli kc krlzmle mzli ka. A' abzo mzli ka, leplz txne amrlx kx nzrlr-lzbq-ngrmqng bange mz nzmnclz-krbz mz Kxetu namyaszlzlr nide. ");
INSERT INTO ntu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Murde abzo mzli kc Jon tqryapwxpx-ngrde nrpa ngr nzrtekqtrngr drtwr krlzmle mzli ka, Gct sa tqvectrpemle leplz bade mz lrpzki kxmrna, mz zmatq kx xplr-esz'ngr. X leplz kcng drtwrdr tqpqtr mz nzngini-krde King rdr, nztwz-anilr x nzlolvz-amqngilr lrpzki rde mz nzarlapx-krde nidr. ");
INSERT INTO ntu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","A' mzli kc pnz nzryrkr profet x Mosis amrlx nzyapwxtimlr bagu kx Gct mrlz x sa na-atwzlr-ngrmle Kxnzmcpx bagu. A' mzli ka Jon Kxawrkxtr pipxle kx vzpem. ");
INSERT INTO ntu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","X nzmu nalxngitiq natq profet lcng, nalxngiti-kzq kx Jon nide profet kc tqapule Elaeja, tqrpi Nzryrngrkxtr kx navz-kaip x Kxnzmcpx kc ate. X nalxngiti-kzq da kx ycmnetr-ngrde mz Kxnzmcpx. ");
INSERT INTO ntu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Doa kx yrplapx, na-abzle nztwz-krde drtwr ngr natq lc.” ");
INSERT INTO ntu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Zbz Jiszs rpi-mopwzle kx, “Naryapwxtr-mopwc' mz nimu leplz kcng tzmncng mzli ka. Apuamu doa kxnztopwz kcng drtwrdr tresapxu. Kzdq dzbede tzrkrkxbzng mz kzdq kz dzbede. Tzrpibzlr kx, ");
INSERT INTO ntu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ngr-ngrbzkr nabz ngr nzabrtzngr, a' trelawamuu. Ngr-ngrbzkr nabz ngr nzyrningr, a' tryrniwamuu!’ ");
INSERT INTO ntu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Apuamu nidr murde Jon Kxawrkxtr vzm x trmuneu bret x tr-rmnqne-kzu waen. A' nzrpi leplz kx, ‘Drka' mncpxm bade!’ ");
INSERT INTO ntu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","X ninge Mrlx Leplz vzmc, x mux dakxnzng x rmnq-kzx waen. A' nzrpilr kx, ‘Mcamu ena mrlx ka! Mrlx kx mutu x rmnq kato! Kzte ncblo kxnzatakqting takes x leplz kx nztrka-kzng!’ A' nadcpx mz drtwrmu kx nztubqkr natq opx zlwz mz nztubqkr doa kx atutr. X sa namcamu kalr nztubq-krgr rlilrgr mz da kc navzpxmqng mz nzmnckr leplz kcng tzatutrlr natqgr.” ");
INSERT INTO ntu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","A' leplz ngr taon kcng tqalengr Jiszs da kxnzmatqng kxkqlu trnztekqtrlru nqmq nr drtwrdr mz alwx ngrdrng. Mz nzmu-krde lcde, ycmne-plztitrle nidr kx Gct sa na-ayrplapxle nidr. ");
INSERT INTO ntu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Rpibz Jiszs kx, “Agrmplz nimu lr Korasin. X agrmplz kz nimu lr Betsaeda! Murde Gct sa na-ayrplapxle nimu. Trtekqtrwamuu nqmq nr drtwrmu, kxmule-esz' mcamu da kcng tqmatq tzalepxm mz taon nyzmu. A' lr Taea x lr Saedon kxnzmnc-mrbrng kxdrka'-ngrng nzmyaszpxlr nimu. Murde nzmu rkx lcng na-alepx-pnzmlr mz taon nyzdrng, lr mztea lcdeng nzmu nzpxi-pnzng dzlvq lrpz x nzrlung bq, ngi dalr nztekqtr-krdr nqmq nr drtwrdr. ");
INSERT INTO ntu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","X napi-angidrbo bamu kx mz Mzli Kxmatq kc navzm, nzayrplapxkr Gct nimu namyaszpxle nzayrplapx-krde lr Taea x Saedon. ");
INSERT INTO ntu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","X agrmplz nimu lr Kzpznizm murde pxtxpx-ngrnamu ninge. Kxmule-esz' glqlz-lzbqamu wq murde rpiamu natakitrmu Heven, a' Gct sa na-adwatrle nimu mz Hxl! Lr Sodom kxdrka'-ngrng nzmyaszpxlr nimu. Murde nzmu rkx lcng na-alepx-pnzmlr mz taon nyzdr, e lr taon lcde natekqtrlr nqmq nr drtwrdr x taon lc naycbe mzbq ka. ");
INSERT INTO ntu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","X napi-angidrbo bamu kx mz Mzli Kxmatq kc navzm, nzayrplapxkr Gct nimu namyaszpxle lr Sodom.” ");
INSERT INTO ntu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mzli lc tqkrka'ngr Jiszs, rpile kx, “Trte, Kxetu r lr Heven x lr nrlc! Awibo bam murde aelwapx-ngrbzme mz doa kcng tzavzo-lzbqng da kcng tqyrlq-kapqbzme mz ncblo kcng tzsiklung x tzrpilr kx nzyrplapxng. ");
INSERT INTO ntu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Trte, da lc vz-nqblqle me pnz drtwrm. Eu.” ");
INSERT INTO ntu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jiszs rpi-mopwzle kx, “Nzrkrlzngr x zmatq amrlx kapem Trtenge bange. Trpnzngr leplz kx rkrlzti angidr ninge, a' ngi txpwz Trtenge. X trpnz-kzngr leplz kx rkrlzti angidr Trtenge, a' nitxpwo, x leplz kcng tqmcpxx mz nzaelwapx-krbo nide badr. ");
INSERT INTO ntu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mz nzmu-krde lc, nimu amrlx navzmamu bange. Murde nzkxpu-krmung nzmrlepu-zlwzbzng bamu, x rblxbz bamu nzvz-nqblq-krmu natq amrlx kcng tzkapxbz kxnzetu rmung bamu. X sutitx zlwz drtwrnge naokatrpo nimu mz nzmnc-zpwx-krmu. ");
INSERT INTO ntu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mnclzm bange x rlr-ngrm nzalvztr-krnge nim, murde nawztr-lxblrki. X avzo-lzbqx murde nabzmu nayc-zpwxng. ");
INSERT INTO ntu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mzli lc nzalvztr-krngeng x natqngeng kcng nakabo bamu, trnarblxpwzung bamu murde trnzapulru natq kxnzetu rmung.” ");
INSERT INTO ntu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mz kzdq zbq ngr nzangiongr, zbq lc nzrpibz Sabat, Jiszs x nigr ncblo nedeng o-zlikr lrpzki kx vztr mz kzdung lclr wit. Zbz sc tqcpqpxpekr nra wit x sc tqngqtipekr, murde nelzgr brtale. (Lou sc Mosis rlrpx-ngrde nzcpqpxngr wit nyz ncblo kzbleng, a' bzkq nzlakilzm noude.) ");
INSERT INTO ntu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nzmcpz kzdung Farzsi, sc tzrpipebzlr mz Jiszs kx, “Mc ena da kc tzale ncblo nemqng! ?Nike tzxpqbrlr-ngrdr Lou sc Mosis mz nzwz-krdr mz Sabat?” ");
INSERT INTO ntu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","A' mz nzaelwapxkr Jiszs kx takitrde nzokatrngr ncblo mz Sabat, sc tqayzlupe-ngrbzle natqdr, mz nzrpi-krbzle kx, “Krlz-angidr-kzamu da kc tqale melrmqmu King Devet kc tqamatqamu mzli kc tzbrtale-ngrdr badr ncblo nedeng! ");
INSERT INTO ntu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nzvztrng mz ma nyz Gct badr kztedeng, x nzngqdr bret kxtr kc tzngqpwzlr pris.” ");
INSERT INTO ntu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Rpi-mopwz Jiszs kx, “X na-aoti kz drtwrmu pris neng Gct kcng tzxpqbrlr-ngrdr Lou sc Mosis mz Sabat kang kqlu mz nzwz-krdr mz zbq lc. A' mz nzobqkr Gct, trnzvz-rbrung mz nzale-krdr nzwz-krdr kc tqkabzle badr. Mz nzmu-krde lcde, nzrkrlz-krmu mz Lou ngr Sabat vz-rbr. ");
INSERT INTO ntu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","A' nakrlz-angidramu kx myaszpxx Mangr-nzangiongr x Lou ngrdeng. ");
INSERT INTO ntu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","8","Murde ninge Mrlx Leplz, kc tqngininge Kxetu r Sabat. X tqrngiscnge zmatq mz nzpnzkr drtwrnge da kx takitrde nzalengr mz Sabat. Otxpx angidr kx trkrlz-angidrwamuu drtwr ngr natq Gct mz nzrpi-krde kx, ‘Da kx mrlzm bange, doa nengeng nayc mz drtwrdr leplz mz nzokatr-krdr nidr namyaszpxle nzrka-krmlr bange blz.’ Murde nzmu nakrlz-angidramu drtwr ngr Natq Gct lc, e tr-rpiwamuu kx ncblo nengeng nzvz-rbrng.” ");
INSERT INTO ntu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jiszs rlaszle mrlcde, x sc tqvztrpe mz mangr-nzkrka'ngr nyzdr Farzsi lcng. ");
INSERT INTO ntu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","X rmctile kzdq ncblo kx mqde bz. Kzdung nidr nzrtangrtrpzng da kx vz-rbrti Jiszs. Zbz sc tzveapebzng bade, nzrpibzlr kx, “?Mz drtwrm, tubq nzamrlz-moungr doa kxnzyagoxng mz Sabat o trtingr?” ");
INSERT INTO ntu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Zbz Jiszs ayzlu-ngrbzle natqdr kx, “Nzmu kzdq nimu nede kc sip kx tatxo mz gq kx vzo la mz Sabat, e navectxlz-pnzmle mzli lapwz, kxmule-esz' xpqbrlr-ngrde lou ngr Sabat! ");
INSERT INTO ntu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Leplz nzmyaszpxlr sip! Delc Lou scgu rlr-ngrmle bagu nzokatr-krgu leplz mz Sabat!” ");
INSERT INTO ntu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Zbz sc tqrpipebzle mz ncblo kc kx, “Atwztqpx mqm.” X atwztqtxpxle mqde, x mrlztx pnz mzli kcpwz, da kc tqwai mqde kc tqmrlz. ");
INSERT INTO ntu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","A' Farzsi kcng nzrlasztxdr mangr-nzkrka'ngr, x sc tzycmne-etrpe-ngrdr kxnamu nznibq-krdr Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jiszs krlzle drtwr kc tzyrlqlr Farzsi, x sc tqrlaszpele mrkc. Leplz kxnzkqlung nzvz-nqblqlr nide x amrlzle amrlx ngrdr kcng tzyagoxng. ");
INSERT INTO ntu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","A' tr-rlr-ngrpwzleu badr nzpine-krdr nide. ");
INSERT INTO ntu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Alele da lcng murde na-angidatingr natq profet Asaea mz nzrpi-krde kx, ");
INSERT INTO ntu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Gct rpile kx, ‘Krlc kxnzawz nenge kx mcpxx. X nzmrlzti-krnge nide myapx-esz'ngr x abrtzlvz-zlwzx nide. Sa na-avzobo Mqngrkxtr bade murde narngisc zmatq ngr nzvz-nqblq-krde me pnz drtwrnge. X sa nayapwxtipxbzle mz leplz amrlx nztubqkr nzmnc-krdr mz nzobq-krnge. ");
INSERT INTO ntu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Trtxpnzngr kalr nzrnqniti-lzbq-krdr badr leplz x nzycmne-kato-krbzle badr. X nate trnaetuneu mz lrpzki mz nzbatr-krbzle mz leplz nzvz-nqblq-krdr nide. ");
INSERT INTO ntu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","A' Kxnzmcpx lc sa natubz mz nibr leplz kx nabzdr ngrgo, mz nzatubx-krde nidr. X sa na-apqtrpzle drtwr leplz kx talvzo, mz nzapu-krdr nyr kx rpile namzpe mz nzyaglqtitr-mou-krde nidr. X sa navz zvz, nakrlzbzle mzli kx aovxio-ngrde, mz nzngini-krde lrpzki r nzatubqtikr Gct leplz. ");
INSERT INTO ntu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","X kzdung leplz kcng tzycmneng mz natq amrlx mz nrlc sa na-abrtrpzlr drtwrdr bade mz nzarlapx-krde nidr.’” ");
INSERT INTO ntu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Zbz kzdung leplz nzvzmibzlr mz Jiszs ncblo kx mncpx-ngrm drka' kx batrpzle nzmwikr mzte x nznabu-krde. A' mzli kc Jiszs tqamrlzpe-ngrde nide, sc tqobqpe x tqycmnepe. ");
INSERT INTO ntu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Zbz leplz nzkctitxpxlr da lc x sc tzrpipelr kx, “Mwx krlc Kxnzmcpx kc navzpxm mz nqvi lr King Devet!” ");
INSERT INTO ntu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","A' kx nzxlrlr natq lc, sc tzrpipelr kx, “Beelsebol ela, kxetu r ma ngr wq, nide kc tqaclvele drka' amrlx x sc nide kc tqrkabz bade zmatq mz nzmaszlrpx-krde drka' mz leplz.” ");
INSERT INTO ntu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","A' Jiszs krlztitrpebzle drtwrdr. X mz nzaelwapx-krbzle badr kx nzvz-rbrng, sc tqrpipebzle kx, “Kandre kx akipx-lzbq mz dzbede sc tzota-etrpeng, x mzli kxpipzne sa naodating. Mz nqmq lcpwz doa lr mztea o ma kxesz' kx nzamnc-dali-lzbqng, sa nayrkrtxpxbzng. ");
INSERT INTO ntu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","X mou, nzmu Setzn namaszlrpx-ngrde drka' nedeng mz leplz, apule kx nzotablrng mz nidr esz'-krdr. Nzmu namule lc, e zmatq ngrde mz nzaclve-krde leplz sc tqmanepe. ");
INSERT INTO ntu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kxmule-esz' rpiamu kx rmaszlrpx-ngrne drka' mz zmatq ngr Setzn, a' tr-rpiwamuu kx oblamzmung nzrmaszlrpx-kzng mz zmatq ngrde. Mz nzmu-krde lc, nzkrlzlr nzrpi-ngrbz bamu kx vz-rbramu! ");
INSERT INTO ntu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","A' me ngi daki-angidrle se. Mz nzmaszlrpx-krnge drka' mz zmatq ngr Mqngrkxtr, aelwapx-ngrne kx Gct sa tqvectrpemle leplz bade mz nzngini-krde King rdr. ");
INSERT INTO ntu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","A' Setzn apule ncblo kx xplr zlwz. X napebqtx kai, x ncblo kc tqdwatr-atebz mz ma nyzde mz nztwz-krde dztudeng. Da kc tqwai nzarlapx-ngrbz leplz mz mqde. ");
INSERT INTO ntu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Na-aoti drtwrmu nrlarde kx namnckiamu. Neke trmnckileu mz nrlarde nyznge nide enqmi rnge. Krkc trokatrleu ninge mz nzrvzmi-ngrm leplz mz Gct, nide kx rmaszlrpxngr leplz mz nzvz-krmlr bade. ");
INSERT INTO ntu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Da angidrtx lc napibo bamu. Gct krlzle nzipqpx-krde alwx x nzrpivxitingr amrlx. A' mz nzrpi-krmu lc, kx zmatq rnge vzpxm mz Setzn, pivxitiamu Mqngrkxtr kc tqngi angidr nou zmatq lc. X rblx nzipqkr Gct doa kx pivxitile Mqngrkxtr. ");
INSERT INTO ntu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Doa kx pibqtile ninge, krlz Gct nzipqpx-ngrbz alwx ngrde, nzmu natekqtrle nqmq nr drtwrde. A' trpnzngr nzipqkr Gct leplz kx pivxitile Mqngrkxtr, kxmule-esz' mzli ka x mzli kc navzm. ");
INSERT INTO ntu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Na-aoti drtwrmu ninge x na-aolvzamu nzngini-krnge ncblo kxmrlz o ncblo kxdrka'ngr mz da kcng tqalexng. Murde nzmrlzkr nounc aelwapxngr nrade kxmrlz. A' nztrkakr nounc aelwapxngr nrade kxtrka. Nounc amrlx nzglx-ngrdr nradr kcng tzpapx-ngrdr. ");
INSERT INTO ntu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nimu doa neng kxdrka'-ngrng kxnzodang. X rblxbz bamu nzrpi-krmu da kxmrlz. Murde ncblo krla tqpipxle da kx yclzm mz nabzde. ");
INSERT INTO ntu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nabz ncblo kxmrlz yclz-ngrm da kxmrlz. X aelwapx-lzbqngr mz nzmrlzti-krde leplz. A' nabz ncblo kxtrka yclz-ngrm da kxtrka. X aelwapx-lzbqngr mz nzatrkati-krde leplz. ");
INSERT INTO ntu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Nakrlz-angidramu kx mz Mzli Kxmatq kc navzm, Gct sa na-ayrplapxle leplz mz natqdrng amrlx kcng trmrlzu mz nzobq-krde. ");
INSERT INTO ntu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mz nzmu-krde lcde, na-aclvetio-lzbqamu mz nikeng piti-ngrnamu ninge. Murde Gct sa na-ayzlubzle da bamu mz nzvz-nqblq-krde natqmung. X mzli lcde, nztubqkr doa o nzvz-rbr-krde sa navzpxm mz natqdeng kcng tqpitileng mz nrlc ka. X doa kx natqde trka takitrde nzayrplapxngr nide.” ");
INSERT INTO ntu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Zbz kzdung Farzsi x kxnzalvztrng mz Lou sc Mosis nzrpibzlr bade kx, “Kxakrlz, ale dq da kxmatq mz nzaelwapx-krm kx vzpx-angidrme mz Gct.” ");
INSERT INTO ntu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jiszs ayzlu-ngrbzle natqdr kx, “Nimu leplz kcng tzmncng mzli ka kxdrka'-ngrng kcng tzesablqtilr Gct. Rlxtiamu kx na-alebo dq rkx kxmatq-esz'ngr mz nzaelwapx-krnge kx vzpxmc mz Gct. A' trpnzngr rkx kx na-aelwa-ngrbo bamu, a' nangi txpwz rkx kc tqalebz Gct mz profet Jona kc bqnc. ");
INSERT INTO ntu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","“Jona mnctipxmle mz nelz besilr zbq tq.” X mz nqmq lcpwz, ninge Mrlx Leplz, sa namnctilz-kzpc' mz gq zbq natq. ");
INSERT INTO ntu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mzli kc bqnc leplz ngr taon kxetu Ninive nzlxngitilr nrpa ngr Gct kc tqyapwxtipxbz Jona badr x nztekqtrlr nqmq nr drtwrdr mz alwx ngrdr. Kxmule-esz', a' mzli ka, doa kx myaszpx-zlwzle Jona vzpem mz nzyapwxtipx-krbzle nrpa ngr Gct bamu, a' trtekqtrwamuu nqmq nr drtwrmu. Mz nzmu-krde lcde, mz Mzli Kxmatq kc navzm, lr Ninive sa naycmne-kzng mz kot mz nzpipx-krdr kx vz-rbramu, murde trlxngitiwamuu nrpa ngr Gct da kc tzwailr. ");
INSERT INTO ntu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","X mz nqmq lcpwz, mzli kc bqnc kwin kc tqaclvele kandre kc Seba mrkc Arabia, vzm rlru mz nzlalztq-krbzle mz Solomon mz natq ngr nzyrplapxngr. Kxmule-esz', a' mzli ka doa kx myaszpx-zlwzle Solomon vzpem, a' pxtxpx-ngrnamu nzlalztq-krbzmu bade. Mz nzmu-krde lcde, mz Mzli Kxmatq kc navzm, Kwin kc Seba sa naycmne kz mz kot mz nzpipx-krde kx vz-rbramu, murde trlalztqpwzmuu mz Gct mz natq ngr nzyrplapxngr.” ");
INSERT INTO ntu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Rpi-mopwz Jiszs kx, “Mzli kx kzdq drka' nzmaszlrpx-ngrde mz kzdq ncblo, drka' la vzne lzke, rtangrne me na-ama-ngrde mz nabz leplz. A' nzmu trnamcleu kzdq nrlc, ");
INSERT INTO ntu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","sc tqrpipele mz nide esz'-krde kx, ‘Nayzlupe-moux mz ma nyznge kc tqrlaszpemc.’ Zbz yzlu mou x mcle ncblo kc mrlzpe x nqmq krde mrlzpe x trpnzngr mqngr kzble kx mncpxm bade. ");
INSERT INTO ntu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Zbz vzpx x vzmitrple drka' rlimz kx nztrka-zlwzng mz nide. Nzvzmqng sc tzmncpxpemqng bade. X nzmnckr ncblo kc sc tqtrkatx-zlwzpe, myaszpxle mzli kc kai. X mz nqmq lcpwz, nimu kxdrka'-ngrng kang mzli ka trkatx-zlwzamu myaszpxle mzli kc trvzka-ngrpc'. Murde pxtxpx-ngrnamu ninge!” ");
INSERT INTO ntu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mzli kc Jiszs tqycmnebe-ngrbzle mz zbo ngr leplz kcng, lxede x mzledeng sc tzkaputrpe-kzpqng. Nztutrpqng yz x nzpitrpzlr mz kzdung leplz kx naycmneng badr Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Zbz kzdq nidr rpibzle bade kx, “Lxem x mzlemqng la tztutrpqng yz, nzrpilr naycmneamu badr.” ");
INSERT INTO ntu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kx krlz Jiszs krlc mzli kxmrlz nzalvztrngr mz da kxmyapxbz, sc tqrpipebzle kx, “?A' nekeng tqngi angidr lxenge x mzlengeng?” ");
INSERT INTO ntu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Zbz sc tqlxpemle nigr ncblo nedeng x tqrpipebzle kx, “Doa kxnzmulr lcng nidr lang tqngi lxenge x mzlengeng. ");
INSERT INTO ntu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Murde doa kcng tzvz-nqblqlr me pnz drtwr Trtenge kc Heven, nidr lang mzlengeng x inwengeng x lxenge angidrng.” ");
INSERT INTO ntu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mz zbq lc, Jiszs kx dwapxmle ma kc, sc tqvzope mz nabz drta' ngr Dxbu Gzlili. X sc tqwxbuope mz nzalvztr-krde leplz. ");
INSERT INTO ntu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Zbz zbo ngr leplz kxnzetunepxlr kc, sc tzyrlwr-ngalelvzpelr nide. X sc tqdwaope mz bot, mz nzalvztr-krde nidr kcng tzyrlwrpxbzng mepz. ");
INSERT INTO ntu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yapwxtipxbzle badr kzdung nzycmne-ebzpxngr mz nzalvztr-krde nidr da kxkqlu. X mz zbq lcde, Jiszs yapwxtipxbzle badr nzycmne-ebzpxngr lcde seleng. Rpibzle kx, “Lalztqmamu bange! Kzdq mzli kzdq kc ncblo oliqtile drtc' ngr nrlanc nyzde. Zbz sc tqarlxpele nra wit nyzdeng. X mz nibrde rpile nayrkqlvzoleng mz drtc'. ");
INSERT INTO ntu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","A' mzli kc tqarlx-ngrdeleng, kzdung nztationg mz lrpzki kx drtc' ngrde mqngi, x nzngqtilzmqng utc. ");
INSERT INTO ntu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","X kzdung nztaong mz drtc' kxmelx, murde ycom mz rplz. Nzlvcpulz-animqng, a' nzglrtxng x nzmztx-ani-moung mz nepi, murde dzbrdr trvzou la. ");
INSERT INTO ntu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","X kzdung mou nztationg mz drtc' ngr ncngrbz. Krlcng nzlvcpumilzmqng lxbi x nzyrlvilvzo lxbi nidr. ");
INSERT INTO ntu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","X kzdung nztaong mz drtc' kxmrlz. Krlcng nzyrlvzlzmqng x nzpang. Kzdung nradr kqlutx zlwz, kzdung nradr kqlu, x kzdung nradr pipz. ");
INSERT INTO ntu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Doa kx yrplapx, na-abzle nztwz-krde drtwr ngr natq lc.” ");
INSERT INTO ntu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Mz nibrde vzbzkr bade rpibzkr kx, “?Nike tqrycmne-ebzpx-ngrbzme da mz leplz?” ");
INSERT INTO ntu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","12","Rpim Jiszs kx, “Ayrbq-angidrbo bamu nqmq kr Gct mz nzngini-krde King r leplz nedeng, kc tqyc-kapq mzli kc. Murde neke lxngitile Gct, Gct sa na-aetunepxbzle nzrkrlz-krde da angidr x sa na-axplrbzle nzrlxngiti-krde. A' leplz kcng trnzrlxngitiung, rblxbz badr nzkrlz-krdr da angidr, murde drtqdr sa nzlalztq-krmlr bange. Mz nzmu-krde lcde, Gct sa nakatxpxbzle nzrkrlzngr kznike ycbz badr. ");
INSERT INTO ntu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ycmne-ebzpxbo da badr murde kxtrnzlxngitilru ninge nzmcpelr da kx alex, a' trnztwzlru drtwr ngrde. X kxmule-esz' nzxlrpelr natqngeng, a' drtwr ngr nzycmne-ebzpx-krngeng tryrplatitrpwzu nardr. ");
INSERT INTO ntu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nidr leplz kcng tqycmnetrngr profet Asaea mz nzrpipxkr Gct kx, ‘Kxmule-esz' nzlalztqng, a' nardr tryrplatrpwzu. X kxmule-esz' nzobqng, a' trnzkrlzlru da angidr. ");
INSERT INTO ntu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nardr nzamqngipebz, nradrtqdr nzangq, x mztr nzakcpebz, murde nzpxtxpx-ngrdr nzmc-krdr, nzxlr-krdr, x nzlxngiti-krdr da angidr. Mz nzmu-krde lcde, rblxbz badr nzyzlu-krmlr bange mz nzatubqti-krnge nabzdr.’” ");
INSERT INTO ntu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Zbz Jiszs rpi-mople bagr kx, “A' mrlzbz bamu mz nzbatr-krbz Gct bamu nztwz-krmu drtwr ngr natqngeng x rkx kcng tqalexng. ");
INSERT INTO ntu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Murde profet x leplz neng Gct nzkqlung mzli kc nzrpilr namc-kzlr ninge, Kxnzmcpx ne Gct, x da kang tqalepexng, a' trnzmc-pnzlru. X nzrpilr naxlr-kzlr da kang tqxlramu, a' trtxpnzngr.” ");
INSERT INTO ntu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Rpi-mop Jiszs kx, “Lalztqmamu bange mz nztwz-krmu drtwr ngr drtc' lcng pwx. ");
INSERT INTO ntu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nra drtwr ngrde nrpa kx Gct sa tqvectrple leplz bade mz nzngini-krde King rdr. Drtc' kc pwx ngi nqmq kr leplz. Murde leplz kcng nardr tryrplatitrlru natq Gct nzapulr lrpzki lc drtc' ngrde tqmqngi, murde Setzn kc Tqdrka'ngr vzm x katxpxbzle nrpa lc mz nabzdr. ");
INSERT INTO ntu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Leplz kcng nabzdr tqngrgo nzapulr drtc' kc tqmelx, murde nzxlrlr natq Gct x nzabrtzlvzlr nztwz-krdrle. ");
INSERT INTO ntu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","A' natq Gct trpnzngr dzbrde x trvzou la mz nabzdr. Nzrlxngiti-krdr mrbcnepwz, murde rblx nzlolvz-amqngi-krdrle mzli kc tqprtztingr nzkxpungr x nzatalzngr kcng tzvzpxmqng mz nzrlxngitingr. ");
INSERT INTO ntu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Leplz kcng drtwrdr tresz'tiu nzapulr drtc' ngr nibr ncngrbz. Kxmule-esz' nzxlrlr natq Gct, a' trnzbrtiu drtwrdr. Murde nzaoti-zlwzkr drtwrdr dalr nrlc kxkqlu nzapulr lxbi kcng tzyrlvilvzolr nabzdr, x trpnzngr nradr. ");
INSERT INTO ntu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Drtc' kxmrlz drtwr ngrde leplz kcng nabzdr tzoliqtilr nzlxngiti-krdr natq Gct. Murde nztwzlr mz nzmnc-krdr, x nra nzrlxngiti-krdr yc-zvzbz, mz nzvectr-krmlr leplz mz nzmnc-nqblq-krdr Gct. Kzdung mzli leplz kcng tzvectrplr nzkqlutx-zlwzng, kzdung mzli nzkqlung, x kzdung mzli nzpipzneng.” ");
INSERT INTO ntu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jiszs yapwxti-mopwzle kc nzycmne-ebzpxngr mz zbo ngr leplz kcng. Rpibzle kx, “Nzaclvekr Gct leplz kcng tzmnclzbzng bade mz nzngini-krde King rdr apule lrnardzng kx arlx nra wit mz nrlanc nyzde. ");
INSERT INTO ntu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Zbz mz nrlckxbq mzli kc tzmwipengr leplz, ncblo kx mwati drtwrde nide vzm, sc tqarlxpele nra nabr kxtrka mz mzlir wit. Yrkrpxbz x sc tqvzpe. ");
INSERT INTO ntu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Zbz wit x nabr kxtrka sc tzyrblalzpemqng x sc tzetulzpemqng. X nabr lcng rlilrdr kxmu nzobq-krdr esz'. A' mz nibr nzpa-bclzkr wit kcng, sc tqglxtipx-lzbqpe kx kzdung nabr kxtrka nztu-lxblrng badr wit kcng. ");
INSERT INTO ntu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kx nzmc ncblo kcng tzwz-nrbalqng nabr kxtrka kcng mz nrlanc nyz kxetu rdr, nzvzbzng bade x sc tzrpipebzlr kx, ‘Kxetu, nra wit txpwz kcng tqarlxq mz nrlanc nyzm. ?A' myx me nztwztim nabr kxtrka kcng tztu-lxblrpeng badr wit nyzm?’ ");
INSERT INTO ntu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Rpibz kxetu kc kx, ‘Nabr lang arlx ncblo kx mwati drtwrde ninge.’ Sc tzrpipebzlr mz kxetu rdr kx, ‘?Suti drtwrm naotibzkr x nabolvztitxbzkr?’ ");
INSERT INTO ntu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Rpibzle badr kx, ‘Bzkq, murde nzmu nabolvztilzmamu nabr kcng tqtrka, sc tqvzmilzpe-kzp kzdung wit. ");
INSERT INTO ntu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","A' natu-txpwzng ena rlilrdr nakrlz-zpwxbzle mzli r nzbrkr wit. X mzli lc sa napibo mz ncblo kx nzwztrng mz wit kx, Yrviti-kaiamu nabr kcng tqtrkating x rtclz-ngrnamu mz nyr. Zbz sc tqlakilz-atemamu wit, x twzamu me nayc-ngrdr.’” ");
INSERT INTO ntu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jiszs ycmne-ebzpx-moule da mz nzrpi-krde kx, “Nzkqlukr leplz kcng namnclzbzng mz Trtenge mz nzngini-krde King rdr apule rtq nc seri, kx peti ncblo mz nzmq nyzde. ");
INSERT INTO ntu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kxmule-esz' topwz zlwz, a' mz nibr kzdung mzli etulzm x sc tqngipe kzdq nounc kxetu. X utc kxkqlung nzmncng mz nrlardeng.” ");
INSERT INTO ntu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","X Jiszs yapwxtipx-mopwzle kc nzycmne-ebzpxngr. Rpibzle kx, “Nzwzkr leplz kcng tzmnclzbzng mz Trtenge apule yisti kxpipz kx oti kzdq olvz. Sc tqayabemipele flawa mz kzdq dis kxetu. X mz nibrde yisti kc sc tqapwzpupele flawa kc.” ");
INSERT INTO ntu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jiszs yapwxtibzle nzycmne-ebzpxngr mz nzalvztr-krde zbo ngr leplz lcng. X trpnzngr mou da kx alvztr-ngrde, a' ngi txpwz mz nzycmne-ebzpxngr. ");
INSERT INTO ntu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Krlc atutrle natq Gct mz nzrpi-krde kx, “Sa naryapwxbo mz leplz mz nzycmne-ebzpxngr. X sa nayokaetipxbo dalr mzli kc bqnc kx trgalr kxrkrlz.” ");
INSERT INTO ntu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mzli kc Jiszs tqrlasz-ngrde zbo ngr leplz kc x tqvztrpe brma, vzbzkr bade, sc tqrpipebzkr kx, “Yokaetipxm ena bagr drtwr ngr nabr kxtrka kcng tztung mz mzlir wit.” ");
INSERT INTO ntu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Rpim Jiszs bagr kx, “Ncblo kc tqarlx nra kxmrlz drtwr ngrde ninge, Mrlx Leplz. ");
INSERT INTO ntu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nrlanc drtwr ngrde nrlc ka. X nra kxmrlz drtwr ngrde doa neng Gct kcng tzmnclzbzng bade mz nzngini-krde King rdr. A' nabr kxtrka drtwr ngrde doa neng Setzn kc Tqdrka'ngr. ");
INSERT INTO ntu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","X kxmwati drtwrde ninge drtwr ngrde Setzn. Mzli kc tqbrpengr dalr nrlanc drtwr ngrde Mzli Kxmatq kc na-ayrplapxngr. X kxnzwzng mz nrlanc drtwr ngrde enjrl neng Gct. ");
INSERT INTO ntu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Murde mz Mzli Kxmatq lc, kzdung leplz sa nartctxlz-ngrng mz nyr mz nzapu-krdr nabr kxtrka. ");
INSERT INTO ntu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Murde mzli lcde, ninge Mrlx Leplz sa na-atwzlrpx-ngrne enjrl nengeng mz nzayrlwr-lxblr-krdr leplz kcng amrlx tzalebzng da kxdrka'ngr, badr leplz kcng amrlx tzbatrpzlr mz doa nzale-krdr alwx. ");
INSERT INTO ntu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","X leplz lcng amrlx sa nartclz-ngrng mz nyr mz Hxl, mrkc nayrni-alo-ngrdr mz nzetqkr drtqdr x namadqtilr nqngidr mz zngya. ");
INSERT INTO ntu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","A' Trte sa navzmile doa nedeng Heven mrkc tqngini-ngrde King. X sa nayzlrpxng nzapulr nepi murde nztubq-esz'ngrng. Doa kx yrplapx, na-abzle nztwz-krde drtwr ngr natq lc.” ");
INSERT INTO ntu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jiszs yapwxti-mople kc nzycmne-ebzpxngr. Rpimle kx, “Nzmyapx-esz'ngrkr nznginingr doa ne Gct apule ncblo kc tqwz mz kzdq drtc'. A' mz nzekq-krde, sc tqrmctipele kzdq da kx yrbulzm mz gol. Gol lc yrlq pnz kzdq ncblo, a' bzszpele x trpnzngr kx rkrlz mrlcde. X trpnzngr ncblo kzble kx rngisc, a' ngi txpwz ncblo kc tqrtwz drtc' kc. Mz nzmu-krde lcde, kx mc ncblo kc le, abrtzlvzle x ekqlvzo-moule. Zbz vz x amwale dztudeng amrlx mz nzrngisc-krde trau kx takitrde nzxpengr drtc' lc. ");
INSERT INTO ntu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“X mz nqmq lcpwz, nzmyapx-esz'ngrkr nznginingr doa ne Gct apu-kzle ncblo kc tqrtangr da kx mrlzvxi. ");
INSERT INTO ntu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Zbz sc tqrmctipele da kx otr-zlwzngr drtwrde. Zbz vz x amwale dztudeng amrlx mz nzrngisc-krde trau kx natakitrde nzxpengr da lc tqmrlz-esz'ngr.” ");
INSERT INTO ntu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jiszs yapwxti-kzple nzycmne-ebzpxngr lc. Rpimle kx, “Nzaclvekr Gct leplz kcng tzmnclzbzng bade apule kzdung ncblo kxnzmwang kx nzapoong br. ");
INSERT INTO ntu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mzli kc br scdr tqyrbupe-ngrde mz nc, sc tzvectrpemlr mepz. X sc tzakipxpelr nc kcng. Nc kxmrlz nzyrlqolr mz topla. A' nc kxtrka nzrtctx-ngrdr. ");
INSERT INTO ntu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","X mz Mzli Kxmatq kc navzm, enjrl nengeng sa na-akipxlr leplz kxdrka'-ngrng mz kxnztubqng. ");
INSERT INTO ntu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","X kxdrka'-ngrng amrlx sa nartclz-ngrng mz nyr mz Hxl, mrkc nayrni-alo-ngrdr mz nzetqkr drtqdr x namadqtilr nqngidr mz zngya.” ");
INSERT INTO ntu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Mz nibrde Jiszs sc tqrpipemle bagr kx, “?Narmu yrplatr-kzpz mz nzycmne-ebzpxngr lcng?” X rpibzkr kx, “Eu.” ");
INSERT INTO ntu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Zbz Jiszs sc tqrpipemle kx, “Sa tqmrlz, murde twzpeamu nzalvztrkr Nzryrngrkxtr kc pnz, x mzli ka twzpe-kzamu nzalvztr-krngeng kxmrna. Mz nzmu-krde lcde, narmu yrbupxpem mz nzalvztrngr lcng li. X doa kznike kx apule nimu mz nzmnclz-krbzle mz Gct, apule ncblo kx ngi bcnyr kx rnginyz me nzryrlqngr da kxnzmrlzting scde. Murde narde ngi me yrlq-ngrde nzrkrlz-krdeng amrlx. X krlzle nzalvztr-krde leplz mz nzrkrlzngr lcng, apule bcnyr kx rkapxm da mz nzaelwapx-krbzle mz leplz, kxmule-esz' da kx blzlongr o da kxmrna.” ");
INSERT INTO ntu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Mz nibr nzyapwxti-krm Jiszs nzycmne-ebzpxngr lcng, sc tqrkalzpemgr badr mrlcde. ");
INSERT INTO ntu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","X sc tqvzpekr badr mztea nyzde, Naszret. Zbz sc tqalvztrpele nidr mz mangr-nzkrka'ngr nyzdr. X nzkctipxlr nzalvztr-krdeng. Zbz drtwrdr lctrpz bade murde mz nzobq-krdr nide ncblo txne a' alvztrle nidr apule kxrngisc zmatq. Nzrpilr kx, “?Nzyrplapxkr nar kznika tqycbz bade? ?Myx kxmu nzale-krde rkx kcng tqxlrkung? ");
INSERT INTO ntu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","?Trnipleu mrlx ncblo kc tqrlrmzti da kx wz-ngrdeng, mrlx Mxri? ?X trngiu mzledeng Jemes, Josip, Saemon x Jud? ");
INSERT INTO ntu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","?X trngiu inwedeng lcng amrlx tqmncku badr mrka? ?Myx me twzkimle nzalvztrngr lc? Mrlx lc trngiu ncblo kxmatq.” ");
INSERT INTO ntu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Zbz sc tzpxpxpe-ngrdr nide x nzalvztr-krdeng, x trnzlxngiti-kzlru nide. Zbz sc tqrpipebz Jiszs badr kx, “Kxmule-esz' lr mztea amrlx nzamatqlr profet, a' lr mztea nyzde x lr ma nyzdeng trnzamrluelru nide.” ");
INSERT INTO ntu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","X mz trnzlxngiti-krdru lc nide, trpnzngr da kxmatq kx alele mz mztea nyzde. ");
INSERT INTO ntu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mzli lc King Herot Antipas, kc tqaclvele lr Gzlili, xlrle nrpa ngr da kcng tqaleti Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","X sc tqrpipebzle mz kxnzawz nedeng kx, “Mwx ncblo lc, Jon Kxawrkxtr elc, tulzpe-mop mz nzbzngr. Dekc tqale-ngrde rkx kcng tqmatq-esz'ngr.” ");
INSERT INTO ntu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Nzbzkr Jon kxmule sele. Herot twzle olvz r mzlede Filip. X Filip lc sc tqlube, kx tqyrlzti Herot kc olvz rde. Drtq olvz lc Herodizs. A' Jon pi-zvzbzle mz Herot kx ngibz alwx mz nzobqkr Gct mz nzyrlzti-krde olvz r mzlede. Zbz Herot atwzlr-ngrbzle ncblo ngr vea nedeng, nzlolvzlr Jon x na-adwatrlr mz presin. ");
INSERT INTO ntu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot rpile nanibqle Jon, a' rblx murde mwxlrtile leplz kxkqlu ma tzotablrng. Murde mz drtwrdr, Jon nide profet ne Gct. ");
INSERT INTO ntu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Zbz mz zbq kc tqkaputr-ngrm nzrmcngr mz Herot, alebzle kc nzmungr mz ncblo nedeng. Zbz abrtzlvzle inyx Herodizs, mz nzela-krbzle badr mz nzelangr kx batrpzle ncblo nzrkcmnzngr nide. ");
INSERT INTO ntu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Rpibz Herot bade kx, “Nike narlxtime bange, esalz-ngrne kx sa nakabo bam!” ");
INSERT INTO ntu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","X mz nzvz-nqblq-krde natq lxede, rpibzle kx, “Suti drtwrnge nalakipxbzme nar Jon Kxawrkxtr x katim dis bange mzli ka, murde nakrlzx kx bz-angidrpe.” ");
INSERT INTO ntu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herot drtwrde vztx, a' ycakalqpe. Murde esalzpe kai, x nzmu trnakapwzleu nike suti drtwr doa olvz lc, ngi da kx myangr drtqde mz mzlir kxnzetu kcng. ");
INSERT INTO ntu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","X sc tqatwzlrpe-ngrde kc ncblo ngr vea mz presin, kx nalakipxbzle nar Jon. Ncblo ngr vea lc vz mz presin, sc tqlakipxpebzle narde. ");
INSERT INTO ntu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","X sc tqtwztipemle dis, tqkapebzle mz doa olvz kc. X sc tqtwzpebzle mz lxede. ");
INSERT INTO ntu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Zbz oblamzng Jon sc tzotipelr namz ngrde, tzyrtzmqpelr. X sc tzvzpemqng mz Jiszs, tzrlwape-ngrbzlr da kc tqprtz. ");
INSERT INTO ntu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Mzli kc tqxlrngr Jiszs nrpa ngr Jon, sc tqprtzpekr badr mz bot, mz nzalilvc-krgr mz kzdq nrlc kx namnc-ngrgr esz'-krgr. A' kx nzxlr leplz ngr taon nzrkalz-krmgr mz bot, sc tzyrkrkipemlr mepz, mz nzrmcti-krdr nigr mrkc na-alilvckitrkr. ");
INSERT INTO ntu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Zbz mzli kc Jiszs tqvztrpe-ngrmle mepz, sc tqmcpele zbo ngr leplz kcng tzyrlwrng mrkc tzaenzlilr nide. X sc tqyctx-zlwzpengr drtwrde nidr x amrlzle kxnzyagoxng. ");
INSERT INTO ntu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","A' mzli kcpe mz milzpq, sc tqrpipebzkr bade kx, “Nrlc ycpe pipz nzbq-krde, a' trpnzngr me narmctingr leplz lcng dakxnzng. Atwzlrpengr nidr mz mztea kcng tzyctineng mrlang, murde naxpeng nadr dakxnzng.” ");
INSERT INTO ntu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","A' ayzlu-ngrm Jiszs natqgr kx, “Trmrlzu nzvz-krdr mz nelzdr kxbrtale. A' nimu kx narkabz nadr dakxnzng.” ");
INSERT INTO ntu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Rpibzkr kx, “Yctxpqng bagr bret nzlvqn kx topwztine x nc kxsupe li.” ");
INSERT INTO ntu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Rpim Jiszs kx, “Twzmamu bange.” ");
INSERT INTO ntu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Sc tqpipebzle mz leplz kcng nzwxbuo-krdr mz nabr. Mz nibr nzwxbuo-krdr, Jiszs kalzmle bret kcng nzlvqn x nc kcng li, x obqlz mz bongavz mz nzkrka'ngr x sc tqawipebz mz Gct. Zbz lopxitile bret kcng, x sc tqkapemle bret x nc kcng bagr, tqakipebzkr mz leplz kcng. ");
INSERT INTO ntu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nzmung x nelz leplz amrlx krlctxtrpz. Mz nibr nzmu-krdr, nulvzokr topla nzpnu-esz'-nrade-li (12) mz nctq dakxnzng kcng tqyctxo. ");
INSERT INTO ntu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ycpwz pipz nzkrlz-krbzle siu-nzlvqn (5,000) mz ncblo, a' trnzrlwxtrpwzu olvz x doa kxnztopwzng. ");
INSERT INTO ntu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mzli lcde, Jiszs pimle bagr kx naprtzkr mz bot x na-alilvckio-kaikr mz nrlar dxbu kc, mzli kc tqatwzlr-ngrde leplz kcng mrnyzdr. ");
INSERT INTO ntu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Mz nibrde, sc tqvzdzpe mz newz esz'-krde mz nzkrka'ngr. X mz nina sc tqmncbe esz'-krde. ");
INSERT INTO ntu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A' bot scgr sc tqdwatrbep mz zpzu r Dxbu Gzlili, sc tqtzpeng ebio x tqalxngitine ebio ngr nenq. ");
INSERT INTO ntu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mzli kc tqkya'pengr kio, sc tqvzpem bagr mz lue. ");
INSERT INTO ntu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","A' mzli kc tqmc-ngrbzkr nzvzne-krmle mz lue, sc tqmwxlrpekr. X tqneplapekr x tqrpipekr kx, “Eke! Drka'!” ");
INSERT INTO ntu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","A' mzli kcpwz Jiszs sc tqycmnepem bagr. Rpimle kx, “Ninge lc ye! Bzkq mwxlramu!” ");
INSERT INTO ntu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Zbz Pita rpibzle bade kx, “Kxetu, kx tqngini-zpwxm la, pim bange napoobo mz lue x navzbo bam.” ");
INSERT INTO ntu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Rpibz Jiszs bade kx, “Vzm!” Zbz Pita poom mz bot x sc tqvzpebz mz Jiszs mz lue. ");
INSERT INTO ntu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","A' kx mcle ebio nzprtz-krmle, sc tqboope mz nzmwxlr-krde. X sc tqkqlepele Jiszs, tqrpipebzle kx, “Kxetu! Okatrp ninge!” ");
INSERT INTO ntu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Mzli kcpwz Jiszs vzbz, otibzle mqde, x sc tqveclzpemle. X sc tqrpipebzle mz Pita kx, “?Memule tqrnrc-ngrn x trbrti-ngru drtwrm ninge? ?X memule nzlxngiti-krm ninge tqtopwzbe-ngrde?” ");
INSERT INTO ntu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Mzli kcpwz sc tzprtzpemqng mz bot, x nenq kc tqamaope. ");
INSERT INTO ntu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Zbz nigr kcng tzmncng mz bot sc tqangiopekr nide mz nzrpi-krbzkr bade kx, “Ni-zpwxm Mrlx Gct!” ");
INSERT INTO ntu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Zbz sc tqalilvckipe-moukr mz kzdq nrlar dxbu kc. Sc tqkaputrpebzkr mz nrlarnrlc kc tqycngr mztea Ganeszret. ");
INSERT INTO ntu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","X leplz ngr mrlc nzglxlr Jiszs, x sc tzpi-anipebzlr nrpa ngrde mz leplz amrlx ngr nrlarnrlc lcde. X nzvzmibzlr kxnzyagoxng bade. ");
INSERT INTO ntu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","X nzyrnititrpzlr bade kx narlr-ngrbzle mz kztedrng nzbxtxtr-krpwzlr nctq lrpz scde. X leplz kcng tzyagoxng tzbxtrpzlr lrpzde nzmrlzng amrlx. ");
INSERT INTO ntu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kzdq zbq kzdung Farzsi x kxnzalvztrng mz Lou sc Mosis nzvzkimlr Jerusalem. X nzveatibzlr mz Jiszs kx, ");
INSERT INTO ntu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“?Memule ncblo nemqng tzrnzlvzo-ngrdr nqmq kr melrmqgung? Trnzvz-nqblqlru nqmq krgu mz nzrycpq-kaingr mq x ncblo kc tqmu ate.” ");
INSERT INTO ntu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jiszs ayzlu-ngrbzle natqdr kx, “?A' memule tqrnzlvzo-ngrnamu Lou sc Gct mz nztekqtr-krmule mz nzalvztr-krmu nqmq krmung? ");
INSERT INTO ntu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Murde mz Nzryrngrkxtr Gct rpibzle kx, ‘Amrlue zvz trtem x lxem. Murde doa kx tramrlueleu trtede x lxede, a' pibqtile nidr, takitxtrpwzle nzrnibqngr.’ ");
INSERT INTO ntu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","A' rpi-alzu-ngrnamu kx takitrde doa trokatr-ngrdeu trtede x lxede mz trau scde, nzmu dzu r da kx naokatrle nidr yrlqpx-bekapele nangi blz kxtr sc Gct. A' mz nzale-krmu da lc yrlqtxpxamu Lou sc Gct, murde navz-nqblqamu nzalvztr-krmu nqmq krmung. ");
INSERT INTO ntu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nimu leplz kx narpi-ngrbz kx rlxngitiamu, murde narpi-ngrbz kx vz-nqblqamu Lou sc Gct, a' mrlz txpwz bamu nzalvztr-krmu nqmq krmu! Gct ycmnetr-ngrde leplz kxnzapulr nimu mz nzngi-batr-krbzle mz profet Asaea nzryr-krde kx, ");
INSERT INTO ntu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Leplz lcng nzamrlue-txpwzlr ninge mz naodr. A' trnzvz-nqblqlru natqnge murde nqmq nr nabzdr yc-rlrup bange. ");
INSERT INTO ntu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nzangio-krdr ninge mane mz drtwrnge murde nzrpilr da kcng tzalvztr-ngrdr leplz nzvzpxmqng bange. A' trtingr.’” ");
INSERT INTO ntu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Zbz Jiszs kqle-moule zbo ngr leplz kcng, sc tqrpipebzle kx, “Lalztq-angidrmamu bange x abzamu nzyrlq-krmu da kc napibo bamu. ");
INSERT INTO ntu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Da kcng tzmale leplz mz mqdr x tzyrlqtrlr mz naodr trnzbatrpwzlru trnztakitr-krdru nidr nzprtrngr mz nzangiongr. Trtingr. A' ngi da kcng tzvzpxmqng mz nao leplz kx nzbatrpzlr trnztakitr-krdru nidr.” ");
INSERT INTO ntu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Zbz vzkr x rpibzkr bade kx, “?Krlz-kzq kx nzycmne-krm nzxngitrlr Farzsi?” ");
INSERT INTO ntu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jiszs ayzlu-ngrmle natqgr kx, “Trtenge kc Heven sa natabotilzmle nzalvztrngr amrlx kcng trnzvz-nqblqlru me pnz drtwrde. ");
INSERT INTO ntu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mz nzmu-krde lcde, bzkq lalztqbzmu mz Farzsi lcng. Murde kxnzetu lcng nzapulr ncblo kx mztr mwi kcng tzmailzbzlr leplz kcng mztr tzmwing mz Gct. A' mz nzale-krdr da lc, dzbede lcng li nztaong rlilrdr mz gq mz nzvz-rbr-krdr.” ");
INSERT INTO ntu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Zbz Pita rpibzle bade kx, “Yokaetipxm bagr nzycmne-ebzpx-krm mz da kcng tzvzpxmqng mz nao leplz.” ");
INSERT INTO ntu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jiszs rpimle bagr kx, “Rlr! ?Narmu tryrplatrkapz mz natq lc? ");
INSERT INTO ntu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","?Trkrlz-zpwxkalamu kx da kcng tzyrlqtr leplz mz naodr vztr mz lzng krdr, x mz nibrde sc tqvzpxpe-mop mz nrkrdrtq? Da kxnzmulr lcng trnzbatrpwzlru trnztakitr-krdru nidr. ");
INSERT INTO ntu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Natq kxtrka amrlx kcng tzvzpxmqng mz nao leplz, nzvzdz-kaipqng mz nabzdr. X nzbatrpzlr trnztakitr-krdru nidr. ");
INSERT INTO ntu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Murde drtwr kxtrka lcng nzvzdzmqng mz nabz leplz. X nzmailzlr nidr mz nzale-krdr alwx lcde seleng: nzrpibqtingr leplz, nzrpokiatitrngr leplz, nzpnangr da, nzrnibqngr, nzrmwimingr leplz kx trngiu krnalzdr, x kzdung kz da kxtrka. ");
INSERT INTO ntu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Da kxnzmulr lcng nzbatrpzlr trnztakitr-krdru leplz x trnztubq-krdru mz nzobqkr Gct. A' mz trnzycpq-ngru mq x leplz kc tqmupe, trbatrpwzleu trnztakitr-krdru leplz.” ");
INSERT INTO ntu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Zbz rlaszkr badr Gzlili Provins, x sc tqvzkipekr mz nrlarnrlc kc Fonisiz mrkc Siriz Provins, mz taon kcng etu Taea x Saedon. Provins lc nyz leplz kxtrngiulrJiu. ");
INSERT INTO ntu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Zbz kzdq olvz kxtrngiulrJiu kx mnc mrlcde, vzm mz Jiszs x sc tqycmne-katopebz bade, mz nzrpi-krbzle kx, “Kxetu, Mrlx Devet, nayc mz drtwrm ninge! Inyxnge drtqde etqtx zlwz mz drka' kc tqmncpxm bade.” ");
INSERT INTO ntu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kxmule-esz', a' Jiszs traotrpwzleu nrlarde bade x trayzlupwzleu natqde. Zbz sc tqrpipebzkr bade kx, “Ayzlutxpe olvz lc, murde sc tqkq-nqblq-zvzmle nigu.” ");
INSERT INTO ntu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Zbz sc tqrpipebz Jiszs bade kx, “Gct atwzlr-ngrmle ninge mz nzokatr-krnge txpwz lr Israel kcng tzmnc-mrbrng.” ");
INSERT INTO ntu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kx xlrbzle natqde lcng, vzm x sc tqrweopebz zpr bade, mz nzrpi-krbzle kx, “Kxetu, okatrp ninge!” ");
INSERT INTO ntu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jiszs ycmnebz bade mz kzdq nzycmne-ebzpxngr kx, “Trmrlzu nzoti-krbzme dakxnzng nan doa kxnztopwzng x kabzme mz kuli.” ");
INSERT INTO ntu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Rpibz olvz kc kx, “Kxetu, da zpwxtx la tqpiq, a' nzrlr-kz-ngrbz mz kuli nzngq-krdr dakxnzng kc tqtao mz nabz tebol.” ");
INSERT INTO ntu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Zbz Jiszs rpibzle bade kx, “Olvz lc, nzbrtikr drtwrm ninge etu-esz'ngr! Sa na-alebo da kc tqsuti drtwrm.” X mzli kcpwz drka' kc sc tqprszpxpele inyxde x sc tqmnc-zpwxpe mou. ");
INSERT INTO ntu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Rlaszkr badr nrlarnrlc kc, x sc tqyzlupe-moukr Dxbu Gzlili. Vzdzkr mz nrlar kzdq nra x Jiszs sc tqwxbuope. ");
INSERT INTO ntu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Zbo ngr leplz nzvzmqng bade. Nzrvzmimqng kxnzvz-tengineng, kxnzbxplong, kx mztr mwi, kxnznabung, x kzdung kz kxnzdwatibzng zyagox kx bletipx-lxblrng. X amrlzle nidr. ");
INSERT INTO ntu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","X leplz kxkqlu nzkctipx-zlwzlr nzrmc-krdr nzvznekr kxnzvz-tengineng, nzmrlz-moukr kxnzbxplong, nzobqkr kx mztr mwi, x nzycmnekr kxnznabung. X nzglqlzlr x nzawibzng mz Gct rdr, nidr lr Israel. ");
INSERT INTO ntu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jiszs kc tqkqlepemle nigr x tqrpipemle bagr kx, “Ycpengr drtwrnge leplz lcng. Murde nzmnctipemlr bagu mrka zbq tqpe x dakxnzng nadr yrkrtxpe. Trmrlzu nzatwzlrtxngr nidr mz nelzdr kxbrtale, ma mztr tqtclvrne mz lrpzki.” ");
INSERT INTO ntu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","A' rpibzkr bade kx, “Trpnzngr me nzxpe-ngrgr dakxnzng kx natakitrde leplz lcng mrka.” ");
INSERT INTO ntu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","A' Jiszs veam bagr kx, “?Bret tqlvr kx ycbz bamu?” Rpibzkr kx, “Rlimz, x nc kxsupe pipzne.” ");
INSERT INTO ntu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Rpibz Jiszs mz leplz kcng amrlx nawxbuong. ");
INSERT INTO ntu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Zbz otitxde dapu bret kcng rlimz x nc kcng, awitx-ngrbzle mz Gct, lopxititxdeng, x sc tqkatipemleng bagr tqakipebzkr mz leplz kcng amrlx. ");
INSERT INTO ntu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nzmung amrlx x nelzdr krlc. X atakqtikr mulide kcng tqyctxo x nulvzo-ngrgrle topla kxetu rlimz. ");
INSERT INTO ntu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","X mz nzrlwxngr ncblo txpwz krlzbzle siu-pwx (4,000) kcng tzmung mz zbq lcma, a' trnzrlwxtrpwzu olvz x doa kxnztopwzng. ");
INSERT INTO ntu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Zbz sc tqatwzlrpengr Jiszs leplz kcng mz mztea nyzdrng. X sc tqprtzpekr mz bot, sc tqalilvckiopekr mz nrlarde kc Magadan. ");
INSERT INTO ntu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Zbz kzdung Farzsi x Sadiusi nzvzmqng mz nzatalz-krdr Jiszs. Nzrlxtibzlr bade nzale-krde kzdq rkx kxmatq mz nzaelwapx-krde kx vzpx-angidrm mz Gct, murde nzrpilr na-amyabzlr drtqde mz trnzale-krdeleu. ");
INSERT INTO ntu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","A' Jiszs rpibzle badr kx, “Mz nzrmcngr nzpckr dcbz mzli kc mz nina, nzrpingr kx, ‘Kcma mz nrlckxbq nrlc namrlz.’ ");
INSERT INTO ntu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","A' mz nourla, mz nzrlxlvzkr bongavz, nzrpingr kx, ‘Nrlc trnamrlzpeu.’ Kxmule-esz' krlzamu drtwr ngr nzrmcngr rkx mz bongavz, a' rblxbz bamu nzkrlz-krmu drtwr ngr nzrmcngr rkx ngr nzwz-krnge. ");
INSERT INTO ntu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nimu leplz kcng tzmncng mzli ka kxdrka'-ngrng kcng tzesablqtilr Gct. Rlxtiamu kx na-alebo dq rkx kxmatq-esz'ngr mz nzaelwapx-krnge kx vzpxmc mz Gct. A' trpnzngr rkx kx na-aelwa-ngrbo bamu, a' nangi txpwz rkx kc tqalebz Gct mz Jona kc bqnc.” Zbz sc tqrlaszpele nidr. ");
INSERT INTO ntu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Zbz sc tqprtzpekr badr mz bot. X mzli kc tqalilvcope-ngrgr mz dxbu, mrbrtr mz drtwrgr nzrtwz-krgr bret. ");
INSERT INTO ntu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jiszs rpimle bagr kx, “Rngidrtioamu yisti scdr Farzsi x Sadiusi.” ");
INSERT INTO ntu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Zbz sc tqycmnetrpe-ngrgr, mz nzxlr-krgr kc yisti, sc tqrpi-etrpekr kx, “Jiszs tqkxmu nzycmne-krmle lc murde trpnzngr bret kx twzmgu.” ");
INSERT INTO ntu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kx xlrm Jiszs da kc tqycmnetr-ngrgr, sc tqrpipemle bagr kx, “?Memule nzlxngiti-krmu ninge tqtopwzbe-ngrde? ?Nike tqyc-zlwzngr mz drtwrmu trnzrtwzne-krmuu bret? ");
INSERT INTO ntu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","?Myx kxmule, trkrlzkalamu? Nadcpx mz drtwrmu mzli kc tqlopxiti-ngrne bret kcng nzlvqn tqapu-ngrne ncblo kcng siu-nzlvqn (5,000). Mzli lcde nulvzoamu topla nzpnu-esz'-nrade-li (12) mz muli dakxnzng kx yctxo. ");
INSERT INTO ntu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","X nadcpx kz mz drtwrmu mzli kc tqlopxiti-ngrne bret kcng rlimz tqapu-ngrne ncblo kcng siu-pwx. Mzli lcde nulvzoamu topla rlimz mz muli dakxnzng kx yctxo. ");
INSERT INTO ntu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mzli ka na-aopxbz bamu kx Gct krlzle nzka-krbzle bret. A' trycmnetrwxu mz bret, murde da kc tqpibo bamu narngidrtioamu yisti scdr Farzsi x Sadiusi.” ");
INSERT INTO ntu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Zbz nargr kc tqyrplatr-atebz, kx trpipleu bagr nzrngidrtio-krgr yisti mz bret, a' rpimle kx narngidrtiokr nzalvztr-rbrkr Farzsi x Sadiusi. ");
INSERT INTO ntu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Rlaszkr badr Gzlili Provins x sc tqvzdzpekr, vztrkr mz nrlarnrlc kc tqycngr taon kc Sisaria Filipae. Mzli kc tqkaputrpe-ngrbzkr, Jiszs rveam bagr kx, “?Myx kxmu nzglxkr leplz ninge, Mrlx Leplz?” ");
INSERT INTO ntu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Rpibzkr kx, “Kzdung leplz nzrpilr kx nim Jon Kxawrkxtr yzlupe-mop mz nzbzngr. X kzdung nzrpilr kx nim profet Elaeja o profet Jeremaea yzluope-mop Heven. X kzdu-kzng nzrpilr kx nim dq profet kxmyalz kc bqnc.” ");
INSERT INTO ntu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Zbz rpimle bagr kx, “?A' nimu, myx kxmu nzglx-krnamu ninge?” ");
INSERT INTO ntu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Rpibz Saemon Pita kx, “Nim Mrlx Gct kc tqlu alo, x Mevalu kc tqmcpxle.” ");
INSERT INTO ntu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Rpibz Jiszs bade kx, “Saemon, mrlx Jon, sa namrlzbz bam, murde Trtenge kc Heven nide kc tqrkabz drtwr lc bam. A' trvzpxpuu mz ncblo. ");
INSERT INTO ntu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","X mz nzmu-krde lcde, pibo bam kx nim Pita. Drtqm drtwr ngrde rplz. X natqm lc apule nou rplz murde sa na-axvctr-ngrmc leplz mz lrmakxtr. X rblxbz mz zmatq ngr nzbzngr nzlolvz-amqngi-krde leplz kcng tzlxngitilr natq angidr lc. ");
INSERT INTO ntu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","X sa nakabo bam ki mz nzlvxpx-krm naonrx ngr Heven mz nzprtrkr leplz elr. X mz nzwztr-krme bange, Gct kc Heven sa natubz mz nibrm mz nzesz'ti-kzkr drtwrde mz da kcng tqrpwa'-ngrn x da kcng tqrlrpx-ngrn mz nrlc ka.” ");
INSERT INTO ntu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Zbz Jiszs rngidrlvz-ngrmle bagr kx trkrlzkapzle mzli r nzyapwxtine-krbzkr mz leplz nzngini-krde Kxnzmcpx ne Gct. ");
INSERT INTO ntu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Abzo mzli lcde, Jiszs alvztr-ngrde nigr da kx naprtzbz bade. Rpile kx navz Jerusalem mrkc na-aetqti-ngrbz drtqde mz da kxkqluting. X kxnzetung r lr Jiu sa napxtxpx-ngrdr nide, krlcng lrtzlvz ngrdr, kxnzetu rdr pris, x kxnzalvztrng mz Lou sc Mosis. X sa nanibqlr nide. A' mz zbq kratq mz nibr nzbz-krde, sc tqlupe-mop. ");
INSERT INTO ntu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","A' katxpxm Pita bagr x sc tqvzmitxpxpele rlru kxpipz. X rpibzle bade kx, “Bzkq kxmu nzycmne-krm lc. Murde da kxmule lc nzmu trnawaisr-ngrpqngqu!” ");
INSERT INTO ntu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","A' Jiszs lxlvrbz x sc tqpnanatipele Pita. Rpibzle kx, “Esopx Pita! Bzkq apume bange Setzn, mz nzrpwa'-krme bange nzvz-nqblq-krnge me pnz drtwr Gct. Murde nzrkrlz-krm vz-nqblqle drtwr leplz.” ");
INSERT INTO ntu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Zbz Jiszs rpimle bagr kx, “Doa kx navz-nqblq-angidrle ninge, narlrpx-lzbq mz nzaetq-ngrbz drtqde. X naesablqtile me pnz drtwrde esz'-krde, x bzkq axtxbzle nzo-zli-krde lrpzki rnge. ");
INSERT INTO ntu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Murde doa kx otr-zvzngr drtwrde nzlu-krde, sa namale-lvile nzlungr kxboi. A' doa kx yrlqtxole nzlu-krde murde vz-nqblqle ninge, sa naprtr mz nzlungr kxboi. ");
INSERT INTO ntu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mane nznginingr bcnyr mz nrlc ka x amrbrtxtrle nzlu-krde mz nrlc kc navzm. Murde trpnzngr da mz nrlc ka kx takitrde nzxpepxngr nzlungr kxboi. ");
INSERT INTO ntu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Murde ninge, Mrlx Leplz, mzli trnaboiu x ninge kc tqyzlupemc mz nzvzmi-krmc enjrl kxnztrng mz zluli r Trtenge. X mzli lcde, nzayzlu-krbo da mz doa navz-nqblqle da kx aleleng mz nrlc ka. ");
INSERT INTO ntu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","A' da angidrtx lc napibo bamu. Kzdung nimu sa nalubeng mzli kc ninge, Mrlx Leplz na-aelwapx-ngrne zmatq rnge mz nzvectr-krmc leplz bange mz nzngini-krnge King rdr.” ");
INSERT INTO ntu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mz nibr zbq kcng esz'mz, Jiszs vzmile Pita, Jemes x mzlede Jon, x sc tzvzdzpeng mz kzdq newz kxetu mz nzmnc-krdr esz'-krdr. ");
INSERT INTO ntu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mzli lcpwz, ncblo kcng nztqng nzobqbzng nrkrdrtq Jiszs tekqtr-lzbqpe mz zluli. X mzte nzpnapr-krde apule nepi, x lrpz scde prkitxpxpe apule zyzlr. ");
INSERT INTO ntu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Zbz nzmclr Mosis nidr mz Elaeja, profet kcng bqnc, nzycmne-krdr badr Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Zbz sc tqrpipebz Pita mz Jiszs kx, “Kxetu, mrlztx angidr nzmnc-krgu mrka. Mwx nawztibo du matelq natq, nangi nyzm dq, nangi nyz dq Mosis, x nangi nyz dq Elaeja.” ");
INSERT INTO ntu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mzli kc tqycmnebe-ngrde, kzdq dcbz aelwatxpx-lzbqngr x akqlvztxde nidr zmyo ngrde. Natq Gct vzpxm mz dcbz kc, mz nzrpi-krbzle badr kx, “Krlc mrlxnge Kxnzmrlzti. Abrtzlvz-angidrx nide. Lalztqbzmu bade!” ");
INSERT INTO ntu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kx nzxlrlrle kc, nzmwxlr-zlwzng x sc tzlaopeng mz drtc'. ");
INSERT INTO ntu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Zbz Jiszs vzm, x bxtrpzle nrkrdrtqdr, x rpibzle kx, “Tulzamu. Bzkq mwxlramu.” ");
INSERT INTO ntu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","X nzobq-mopwzng, Jiszs kc tqtutxpepwz mrkc esz'-krde. ");
INSERT INTO ntu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mzli kc tzvzneobe-ngrmlr mz newz kc, rpibz Jiszs badr kx, “Bzkq pinenamu nike mcamu nakrlz-zpwxbzle nztulz-krmc ninge Mrlx Leplz, mz nzbz-krnge.” ");
INSERT INTO ntu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Zbz ncblo kc nztqng sc tzrpipebzlr bade kx, “?Nike kxnzalvztrng mz Lou sc Mosis tzrpi-ngrdr kx profet Elaeja nayzluo-kaip mrka mz nrlc x Kxnzmcpx kc tqvz-atem?” ");
INSERT INTO ntu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jiszs ayzlu-ngrbzle natqdr kx, “Kxnzalvztrng nztubq-angidrng mz nzrpi-krdr kx Elaeja navz-kaip mz nzoliqti-krde da amrlx. ");
INSERT INTO ntu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","A' napibo bamu kx ncblo kc tqngi Elaeja vzpem. A' leplz trnzglxlru nide x nzatrkati-kzlr nide, da kc tzwai nzatrkati-krdr Elaeja kc bqnc. X mz nqmq lcpwz sa na-aetq-kzpzlr drtqnge.” ");
INSERT INTO ntu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Zbz kztegrng nardr kc tqyrplatr-atebz kx krlc tqycmnetr-ngrde Jon Kxawrkxtr. ");
INSERT INTO ntu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mzli kc Jiszs badr Pita, Jemes x Jon tzkrlz-ngrmlr mrkc tqmnc-ngrgr badr zbo ngr leplz kcng, kzdq ncblo vzm mz Jiszs x yrngzobz bade. ");
INSERT INTO ntu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Rpibzle kx, “Kxetu, naokatrpzme mrlxnge. Murde dwatibz drka'lz x aetq-zlwzbzle drtqde mz nzglqkr nimz le. X zvz nztalz-krde mz nyr x nztao-zvz-krde kz mz lue kxvo. ");
INSERT INTO ntu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Vzmimc mz ncblo nemqng mz nzamrlz-krbzlr nide, a' trnzyatrpwzu.” ");
INSERT INTO ntu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jiszs rpimle kx, “?Nike nawai-mopwc' bamu? Nzmnc-krbo bamu mzli boipe! A' trkrlzkalamu nzrlxngitingr x narmu kc tqmqngibe. Vzmimamu doa la bange.” ");
INSERT INTO ntu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Zbz sc tqpnanatipele drka' kc, x sc tqpipebzle nzprszpx-krde doa kc. X mzli kcpwz sc tqprszpxpele doa kc x sc tqmrlzpe mou. ");
INSERT INTO ntu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Zbz mzli kc tqmncpe-ngrgr esz'-krgr badr Jiszs, veabzkr bade kx, “?Nike tqrblxti-ngrde nigr nzrmaszlrpxngr drka' lc?” ");
INSERT INTO ntu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jiszs ayzlu-ngrmle natqgr kx, “Da angidr lc napibo bamu. Rblxbz bamu murde nzlxngiti-krmu Gct topwz-zlwzbe. A' kxmule-esz' nzlxngiti-krmu Gct topwz apule nztopwzkr rtq nra seri, doa kxesz' mz nimu krlzle nzrpi-ngrbz mz kzdq newz kx, ‘Dwasz mrla x vzki mrkc,’ x Gct sa nabatrpzle nzvz-krde. Nzmu nzrlxngiti-krmu nakxmule lc trpnzngr da kx narblxbz bamu. ");
INSERT INTO ntu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","A' drka' kxmule la nzmaszlrpx-ngrpwz mz nzkrka'ngr vzmi nzaxtxngr dakxnzng.” ");
INSERT INTO ntu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Zbz yrlwr-lxblr-moukr badr Gzlili Provins. X Jiszs sc tqrpipemle bagr kx, “Ninge Mrlx Leplz sa na-aprcbz mz zmatq ngr kxnzmwati drtwrdr ninge. ");
INSERT INTO ntu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nanibqlr ninge, a' mz zbq kratq mz nibr nzbz-krnge, ninge kc tzatulzpe-mop mz nzlungr.” Zbz drtwrgr kc tqvz-zlwzpe. ");
INSERT INTO ntu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mzli kc tqkaputr-ngrmgr badr mz taon Kzpznizm, kzdung ncblo kcng tzatakqting takes ngr Mangr-nzangiongr Yawe Jerusalem nzvzbzng mz Pita. X nzrpibzlr kx, “?Myx kxmule, kxakrlz ngrmu xpe kz takes ngr Mangr-nzangiongr?” ");
INSERT INTO ntu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita ayzlu-ngrbzle natqdr kx, “Eu, xpe kz.” Mzli kc Pita tqvztr-ngrbzle brma, Jiszs sc tqycmnepe-kaipz bade. Rpibzle kx, “?Saemon, myx kxmu nzkrlz-krmle? ?King nzatakqtibz trau mz mrlxdrng o mz leplz kcng tzmnclzbzng badr?” ");
INSERT INTO ntu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita ayzlu-ngrbzle natqde kx, “Kxnzmnclzbzng mz king.” Rpibz Jiszs kx, “Mz nzmu-krde lcde, mrlxng king trnzxpelru takes. ");
INSERT INTO ntu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kxmule-esz', a' naxpeki, murde ma tqbatrpzki nzxngitr-krdrle. Vzo mz dxbu x rtcpxngr trmrtao scm mz nzmwangr. Mz nao nc kc naveclz-ayrnr-ngrme, sa namcq trau kx natakitrde nzxpe-krm takes scgi. Twz x kabz badr.” ");
INSERT INTO ntu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kzdq zbq vzmgr mz Jiszs, sc tqveapebzkr bade kx, “?Neke myalz-zlwzbz mz leplz amrlx kx nzrlr-lzbq-ngrbzng mz Gct?” ");
INSERT INTO ntu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Zbz vzmim Jiszs kzdq doa kxtopwz x atumle mz mzlirgr. ");
INSERT INTO ntu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","X sc tqrpipemle bagr kx, “Nakrlzamu kx trpnzngr nzmnclz-krbzmu mz Gct mz nzngini-krde King rmu nzmu kx trtekqtrwamuu nqmq krmu mz nzapu-krmu doa lc. ");
INSERT INTO ntu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mz nzmu-krde lcde, mrlx kx avzo-lzbq mz nzapu-krde doa lc, nide kx myalz-zlwzbz mz leplz amrlx kx nzrlr-lzbq-ngrbzng mz Gct. ");
INSERT INTO ntu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mrlx kx vz-nqblqle ninge mz nzabrtzlvz-krde doa kxtopwz kxmule lc mz drtqnge, abrtzlvz-kzle ninge.” ");
INSERT INTO ntu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","7","“A' aclvetio-lzbq murde ma tqatrkatiq nzrlxngitikr doa nengeng. Murde Gct sa na-ayrplapx-zlwzle ncblo kx ataole mz alwx doa kxpobe mz nzrlxngitingr. Mwx mrlz nzbz-kai-krde mz nrlc ka, mzli ka tratrkatika-ngrde nzrlxngitikr doa kxmule lcng. Murde nzayrplapxngr nide na-apule mrlx kx nzpetrpz rplz kxetu mz drtwrde x nzrtcongr me boongr prla. Da kcng tzataolr leplz mz alwx sa nakaputrp. Kxmule-esz', a' agrmplz mrlx kx ataole kzdq kz doa mz alwx! Murde kalr Gct sa na-ayrplapx-alole nide mz alwx lc mz Hxl. ");
INSERT INTO ntu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","9","Mz nzmu-krde lcde, aclvetio-lzbq kz. Bzkq rlr-ngrbzme mz alwx nzaclve-krde nim. Mz mzli r nzatalzngr arlapx-lzbq. X katxpx-lzbqm mz nzatalzngr kx batrpzle nztao-zvz-krm. Murde nzwz-kato-krm mz nzmncngr kxtubq mzli ka, x nzmnc-zvz-krm Heven kalr, myaszpx-zlwzle nzaxtx-krbzme nzrlxngiti-krm mzli ka, x nzmnc-zvz-krm mz Hxl kalr.” ");
INSERT INTO ntu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Rpi-mop Jiszs bagr kx, “Bzkq obqszoamu kzdq doa kxtopwz kxmule lc, murde nzmyapxbzng mz nzobqkr Gct Trtenge. X enjrl kcng tzaclvelr nidr nzkrlzlr nzrlwa-ngrbz bade mrkc tzmnctr-ngrbzlr bade Heven. ");
INSERT INTO ntu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ninge Mrlx Leplz vz-ngrmc mz nrlc mz nzrtangrti-krnge x nzarlapx-krnge doa kxnzmrbrng.” ");
INSERT INTO ntu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Zbz yapwxtibz Jiszs nzycmne-ebzpxngr lc, mz nzaelwapx-krbzle kx Gct yc mz drtwrde doa kcng tzmnc-mrbrng. Rpibzle kx, “?Nzmu kzdq nimu kx nede sip trtqki-esz' x mrbr kc esz', nike na-alele? Nzmu amnctxde krkcng nzpnu-rpwxmz-nrade-rpwxmz mz nra, me namnc-zpwx-ngrdr. X sc tqvzpe mz nzrtangrti-krde krkc tqvztxne. ");
INSERT INTO ntu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","X mz nzmc-krdele, nzabrtzlvz-krdele myaszpxle nzabrtzlvz-krde krkcng nzpnu-rpwxmz-nrade-rpwxmz tzmnc-zpwxng. ");
INSERT INTO ntu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","X mz nqmq lcpwz, Trtemu kc Heven trsutiu drtwrde kzdq doa kxtopwz kxmule lc nzmrbr-krde x nzprtr-krde mz Hxl.” ");
INSERT INTO ntu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Rpi-mop Jiszs bagr kx, “Nzmu kzdq kztem kxrlxngiti nataole mz alwx, vz-kaipz x pibz bade nzvz-rbr-krde. A' bzkq nzkrlztibz nzycmneti-krbzme alwx ngrde. Murde nzmu kx tqlxngitibzle nzycmne-krbzme x tekqtrle nqmq nr drtwrde, sa namnclz-mopwz mz Gct. ");
INSERT INTO ntu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","A' nzmu kx trtekqtrleu nqmq nr drtwrde, vzbzmu du badr leplz naesz' o nali mz nzycmne-kr-mopwzmu bade. Mz nzmu-krde lc, vz-nqblqamu nzalvztrkr Nzryrngrkxtr kc tqrpile kx, ‘Bzkq rpiq kx doa vz-rbrpe, a' mz nzycmne-krbzme natubz du mz nibrm leplz naesz' o nali kx nzmc-kzlr nzvz-rbr-krde.’ ");
INSERT INTO ntu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","A' nzmu kx tqvz-zvzle trnzlalztq-krpwzleu bamu, pibzmu da amrlx mz lrmakxtr. X rlr-ngrbzmu mz mq kxnzetu ngr lrmakxtr mz nzycmne-krbzlr bade. Nzmu kx tqvz-zvzle trnztekqtr-krdeu nqmq nr drtwrde, nimu lrmakxtr na-aprtxpxpeamu nide murde apule kxmnc-mrbr.” ");
INSERT INTO ntu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Napibo bamu kx Gct kc Heven sa natubz mz nibrmu mz nzesz'ti-kzkr drtwrde mz da kcng tqrpwa'-ngrnamu x da kcng tqrlrpx-ngrnamu mz nzokatr-krmu leplz mz nrlc ka. ");
INSERT INTO ntu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","X napi-mopwc' bamu kx mzli kznike krka'ngr kzdu nimu kxli o kxtq mz nzesz'tikr drtwrmu kx da kx rlxtibzmu mz Trtenge vz-nqblq-zpwxle me pnz drtwrde, sa nakabzle bamu. ");
INSERT INTO ntu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Murde mzli lc tzmnctr-lxblr-ngrdr mz drtqnge, ninge la tqmnckr badr mz nzmailz-krnge nidr.” ");
INSERT INTO ntu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Zbz Pita vzm mz Jiszs, rpibzle kx, “?Kxetu, nzwrde natqlvr kx naipq-ngrne kztenge kx alem da kxtrka bange? ?Nzwrde kxrlimz mrlz?” ");
INSERT INTO ntu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ayzlu-ngrbz Jiszs natqde kx, “Trtingr. Murde nzipq-krm kztem trnaesakiu, kxmule-esz' krlzbzle nzwrde kx nzkqlu-zlwzng, a' sc tqvz ye. ");
INSERT INTO ntu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Murde nqmq kr Gct mz nzaclve-krde leplz nedeng apule nzycmne-ebzpxngr lc nayapwxtibo. “Kzdq mzli kzdq kc king rpile narlwx-lxblrle kaon scdr kxnzawz nedeng. ");
INSERT INTO ntu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mzli kc tqabzo-ngrdele, nzvzmim kzdq nidr kc tqkaontibzle bade dola kxnyrmz. ");
INSERT INTO ntu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","A' kxnzawz lc tryatrpepwzu nzxpe-krde kaon lc Murde trpnzngr kx rtakitr nzrtekqtrngr. Zbz king kc sc tqpipebzle mz kxnzawz nedeng kx ncblo kc na-amwatx x navzmitr olvz rde x doa nedeng mz nzngini-kz-krdr kxnzawz-nrbalqng. X na-amwa kz dztudrng amrlx naxpengr kzdu kz kaon kcng. ");
INSERT INTO ntu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","A' ncblo kc tqrweobz zpr mz king x sc tqyrnititrpebzle bade kx, ‘Krlzu ena, a' kam du bange mzli mz nzxpepx-krbo kaon kcng amrlx!’ ");
INSERT INTO ntu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Zbz sc tqycpengr drtwr king kc nide, tqipqpele nide x katxde kaon kc. X sc tqrlrpe-ngrbzle nzvz-krde. ");
INSERT INTO ntu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“A' ncblo kc kx vzle, rmctipele kzdq kz kxnzwzng badr kx kaontibzle bade trtqki r dola (100). Lolvzbqbzle drtwrde x sc tqamwxlrpele nide mz nzrpi-krbzle kx, ‘Ka-dwzlr-ngrm trau kc tqkaontime!’ ");
INSERT INTO ntu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","A' ncblo kc rweobz zpr bade x sc tqyrnititrpebzle bade kx, ‘Krlzu ena, a' kam du bange mzli mz nzxpepx-krbo kaon kc atwrnrngr!’ ");
INSERT INTO ntu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","A' trlalztqpwzu bade, x adwatrle ncblo kc mz presin, namncpxm mrlcde krlzbzle mzli kx nzxpepxngr kaon scde. ");
INSERT INTO ntu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kx nzmcpz kxnzwzng badr da lc, drtwrdr vztx zlwz. Nzvzbzng mz king, sc tzrlwape-ngrbzlr da amrlx bade. ");
INSERT INTO ntu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Zbz sc tqkqlepe king kc kxnzawz kc. X rpibzle bade kx, ‘Ni-zlwzm kxnzawz kxdrka'ngr. Katxpxbo kaon scm amrlx murde yrnititrpe' bange. ");
INSERT INTO ntu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","X takitrde nzyc-kzkr drtwrm kztem x naipqq nide, da kc tqwaisr-ngrne nim. A' tryc-ngru drtwrm nide.’ ");
INSERT INTO ntu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","King kc drtwrde ngyatx zlwz, sc tqpipebzle mz kxnzaclveng mz presin kx navzmilr ncblo kc x na-aetq-zvzbzlr drtqde murde tryatrpepwzu nzxpe-krde kaon scde.” ");
INSERT INTO ntu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","X rpi-mop Jiszs bagr kx, “Mz nqmq lcpwz, Trtenge kc Heven sa na-ayrplapx-alole mrlx kx tripq-angidrleu kztede mz nabzde mz da kxtrka kcng tqalebzle bade.” ");
INSERT INTO ntu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jiszs kx yrkrpxbz kc nzalvztr-krde, sc tqrlaszpekr badr Gzlili Provins x tqvztrpekr Judiz Provins mz nrlar LueJodzn kc tqprkilzm nepi. ");
INSERT INTO ntu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Zbo ngr leplz kxetu nzvz-nqblqmlr nigr mrlcde, x amrlzbzle kztedr kxnzyagoxng. ");
INSERT INTO ntu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kzdung Farzsi nzvzmqng mz Jiszs nzabzlr nzatalzngr nide mz kzdung da kxvz-rbr. Nzrpibzlr bade kx, “?Nzpnzkr drtwrm le, Lou sc Gct rlrpx-ngrde ncblo nzaxtx-krde olvz rde mz nzvz-nqblq-krde drtwrde esz'-krde?” ");
INSERT INTO ntu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jiszs ayzlu-ngrbzle natqdr kx, “Gct aelwapx-ngrde me pnz drtwrde mzli kc tqwz-ngrde nrlc. Murde rlwxamu mz Nzryrngrkxtr kx mzli kc ayrnrngr ‘Gct wz-ngrde ncblo esz' x olvz esz' kx namnctr-lxblrng. ");
INSERT INTO ntu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Delc mzli kc tzetupe-ngrdr, nayrlzng. X nzamatq-lzbq-krdr namyaszpxle nzamatq-krdr kxnginidrng. X ncblo namnctr-amqngipebz mz olvz rde. Murde doa lcng li nznginipedr nrkrdrtq x leplz kxesz'.’ ");
INSERT INTO ntu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","X napibo bamu kx trnzlipeung, a' nznginipedr leplz kxesz'. Mz nzmu-krde lcde, trpnzngr leplz kx takitrde nzakipx-krde krkcng tqaxvctrpeng Gct mz nzyrlzngr.” ");
INSERT INTO ntu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Zbz Farzsi nzveabzng bade kx, “?A' memule tqrlrpxngr Mosis le mz nzrpi-krde kx nzmu ncblo nayrbzle dq letz mz olvz rde napibzle kx pxtxpe-ngrde nide x sc tqatwzlr-ate-ngrde nide?” ");
INSERT INTO ntu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Rpibz Jiszs kx, “Mosis yr-ngrde natq lc murde nar leplz mqngi. A' trkxmuleu lc mzli kc ayrnrngr tqwzngr Gct leplz. ");
INSERT INTO ntu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mzli kc ncblo tzaki-lzbq-ngrdr mz olvz rde kx tr-rmwimiu ncblo kzble, x yrlzti-moule kc olvz kzble, olvz krali lc trngiu olvz rde angidr. Murde mz nzobqkr Gct, sa tqyrlztibele olvz rde kc ayrnrngr. Mz nzmwimi-krde olvz krali lc, ayzprtxde nzesalz-krbzle kc mz olvz rde kc ayrnrngr mz nzyrlzngr mz mz Gct.” ");
INSERT INTO ntu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Zbz rpibzkr bade kx, “Kx tqmule lcde, rlrpxngr Gct leplz nzaki-lzbq-krdr mz da lc esz'txu, mwx takitrde bzkq nzyrlzng.” ");
INSERT INTO ntu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jiszs ayzlu-ngrmle natqgr kx, “Leplz trnzkqluung kx mrlzbz badr trnzyrlz-krdru, a' ngi txpwz krkcng tqokatrng Gct mz nzmnc-nqblq-krdr nqmq lc. ");
INSERT INTO ntu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mz ncblo kcng tqrblxbz badr nzrmwimi-krdr olvz, kzdung nidr nrkrdrtqdr trmrlzu mzli kc mztr tzmc-ngrdr. X kzdung nidr nrkrdrtqdr nzvzpx, murde narblxbz badr nzrmwimi-krdr olvz. X kzdung leplz nzmcpxlr trnzyrlz-krdru murde nawztxtrpwzng mz Gct. X leplz kcng tzkrlzlr nzmnc-nqblq-krdr nqmq lc, nzabrtzlvzlr nqmq lc murde vzpxm mz Gct.” ");
INSERT INTO ntu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Zbz kzdung leplz nzvzmimlr doa kxnztopwzng mz Jiszs mz nzmaletr-krbzle nrkrdrtqdr x nzkrka'-krbzle badr. A' lclvzbzkr. ");
INSERT INTO ntu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Zbz Jiszs rpimle bagr kx, “Bzkq rpwa'-ngrbzmu mz doa lang tztopwzng nzvz-krmlr bange. Murde leplz kxnzmulr lcng nzlxngitilr Gct mz nzngini-krde King rdr.” ");
INSERT INTO ntu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Mz nibr nzyrlqo-krbzle mqde badr mz nzamrlz-krde nidr, sc tqrlaszpele mrkc. ");
INSERT INTO ntu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mzli lc kzdq ncblo vzm mz Jiszs, rpibzle kx, “?Kxakrlz, da kxmrlz kznike na-alex natwz-ngrne nzlungr kxboi?” ");
INSERT INTO ntu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jiszs ayzlu-ngrbzle natqde kx, “?Nike tqveati-ngrme bange da kxmrlz? Murde trpnzngr kxmrlz, a' ngi txpwz Gct esz'-krde. Mz nzprtr-krm mz nzlungr kxboi, navz-nqblqq natq kcng tqkapx Gct.” ");
INSERT INTO ntu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ncblo lc vea-mopwz kx, “?Natq kznikeng?” Rpibz Jiszs kx, “Krlcde seleng: ‘Bzkq kx narnibq. Bzkq kx narmwimi doa kxtrngiu krnalzde. Bzkq kx napna da. Bzkq kx narpokiati leplz. ");
INSERT INTO ntu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Amrlue zvz trtem x lxem. X kzdung mou. X mrlzti kztemqng da kc tqwaiq nzmrlzti-lzbq-krm.’” ");
INSERT INTO ntu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ncblo lc rpibzle bade kx, “Vz-nqblq-angidrx natq lcng amrlx. A' mwx trtakitrdeu. ?Nike mou na-alex narlapx-ngrne?” ");
INSERT INTO ntu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Rpibz Jiszs bade kx, “Kx tqrpiq natubq-esz'ngrn mz nzobqkr Gct, amwa mclrm amrlx x kabz trau rde mz leplz kx trpnzngr scdr. Nzmu na-aleq da lc, nzrngiba-krm sa namyalz mou mrkc Heven. Zbz vzm x vz-nqblqm ninge.” ");
INSERT INTO ntu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","A' ncblo lc drtqde tqbrpe, kx xlrbzle kc natq Jiszs. Sc tqvzpe, drtwrde vztx zlwz. Murde nzrngiba-krde etu x trsutiu drtwrde nzalvetx-krdele mz nzvz-nqblq-krde Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Zbz Jiszs rpimle bagr kx, “Da angidrtx lc napibo bamu. Rblxtx-atwrnr-ngrbz mz kxnzrngiscng nzmnclz-krbzlr mz Gct! ");
INSERT INTO ntu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Napi-mopwc' bamu kx kamel trkrlzleu nzdwatr-krde mrkc tqmrplxngr nidil. X nzrblxkr kxnzrngiscng nzmnclz-krbzlr mz Gct myaszpxle da lc.” ");
INSERT INTO ntu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kx xlrbzkr natq lc kctitxpxkr. Zbz sc tqrpipebzkr kx, “E kx tqmule lcde, trpengr kx narlapx!” ");
INSERT INTO ntu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jiszs mzte aprtxmle bagr x rpimle kx, “Rblxbz mz ncblo, a' tr-rblxpwzu mz Gct. Murde trpnzngr da kx rblxbz bade.” ");
INSERT INTO ntu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Zbz rpibz Pita bade kx, “Rlaszpekr dztugr amrlx mz nzvz-nqblq-krgr nim. ?A' nike natwzkr kalr?” ");
INSERT INTO ntu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jiszs rpimle bagr kx, “Nakrlzamu kx mz mzli kxmrna kc navzm, sa nangininge King mz nzwxbuo-krmc mz tron nyznge kxmatq. X nimu lcng tqvz-nqblq-angidramu ninge, sa na-apu-kzamu king mz nzwxbuo-krmamu mz tron mz nzaclve-krmu nqvi lr ncblo kcng Israel nzpnu-esz'-nrade-li (12). ");
INSERT INTO ntu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Murde mrlx kx rlaszpxle ma nyzde, o mzledeng, o inwedeng, o lxede, o trtede, o doa kxnztopwz nedeng, o drtc' nyzdeng mz nzvz-nqblq-krde ninge, Gct sa naxpe-moule nide nzwrde nangi trtqki lxblr (100) mz nikeng rlaszpxle. X sa natwz-kzle nzlungr kxboi. ");
INSERT INTO ntu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mzli lc, kzdung leplz kxnzetung mz nrlc ka, sa nangi leplz txneng mz nrlc kc navzm. X kzdung leplz txneng mz nrlc ka, sa nanginidr kxnzetung mz nrlc kc navzm.” ");
INSERT INTO ntu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Rpi-mop Jiszs bagr kx, “Nzprtrkr leplz mz nzlungr kxboi apule nzycmne-ebzpxngr lcde sele. Kzdq kc ncblo nyzde kc nrlanc. Kzdq zbq, mzli kc mz nourla kxtopwz, vz mz nzrtangr-krde ncblo kx nawzng mz nrlanc nyzde. ");
INSERT INTO ntu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Rmctile kcng ncblo mz nzwztr-krbzlr bade mz zbq lc. X rpibzle badr trau kc nakabzle badr trnablepxu, a' narsakrlrtx-ngrpwz, krlc trau kxesz'. Murde krlc narncbr mz nzxpengr leplz mzli lc. ");
INSERT INTO ntu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Zbz mz nabz nepi kc tqrpwxmz, sc tqvzpe me nzamwangr da, sc tqrmctipele kzdung ncblo kx nzmnc-txneng. ");
INSERT INTO ntu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Sc tqrpipebzle badr kx, ‘Vzamu x wz-kzamu mz nrlanc nyznge. X sa nakabo bamu narncbr kx takitrde.’ ");
INSERT INTO ntu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Zbz sc tzvzpeng. X sc tqvzpe mou mz nzale-krde da kcpwz mzli kc bea x mz nabz nepi kc tqtq. ");
INSERT INTO ntu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Zbz mz nabz nepi kc tqnzlvqn, sc tqvzpe, x sc tqrmctipele kzdu-kzng ncblo kx nzmnc-txneng. Rpibzle badr kx, ‘?Memule tqmnctxne-ngrnamu mzbq ka boi?’ ");
INSERT INTO ntu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nzrpibzlr kx, ‘Trpnzngr ncblo kx rpim bagr nzwzngr.’ Rpibzle badr kx, ‘Vz-kzamu mz nzwzngr mz nrlanc nyznge.’ ");
INSERT INTO ntu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Zbz mzli kc nataopengr nepi, ncblo kc tqrnginyz nrlanc kc, rpibzle mz kxetu r kxnzawzng kx, ‘Kqle ncblo kcng tzawzng. X xpe nidr, yzutr mz leplz kcng tzwz-belqng x nayrkrpx mz krkcng tzabzo-kailr nzwzngr.’ ");
INSERT INTO ntu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ncblo kcng nzyzutrlr nzwzngr mz nabz nepi kc nzlvqn nzrtwz-lxblrng trau kxesz'. ");
INSERT INTO ntu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mz nzmu-krde lcde, mzli kc naxpepengr krkcng tzwz-kaing, mz drtwrdr nartwzng trau kxkqlu murde nzwztilr nabz nepi nzpnu-esz'-nrade-li (12). A' nztwz-kzlr trau kcpwz esz'. ");
INSERT INTO ntu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nztwzlr trau scdr x drtwrdr kc tqlctrpebz mz kxetu r nrlanc kc. ");
INSERT INTO ntu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Nzrpibzlr kx, ‘Ncblo lcng nzwzti-txpwzlr nabz nepi esz'. A' nigr wztikr mzbq ka atwrnrngr mz nepi. A' se tqarsakrlrkr badr mz nzrka-krme bagr trau kcpwz tqkabzme badr!’ ");
INSERT INTO ntu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kx rnginyz nrlanc kc rpibzle mz kzdq nidr kx, ‘Mzlenge, trangqngutitrwxu nim. Murde krlzpeq kx natwzq trau kxesz' mz nzwz-krm mz zbq kxesz'. ");
INSERT INTO ntu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Twz trau lc, x vzpe. Murde trpnzngr scm drtwr kx yctr elr. A' suti drtwrnge nzka-krbo mz leplz kcng tzwz-belqng trau kcpwz tqkabo bam. ");
INSERT INTO ntu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","?Myx kxmule, mz drtwrm trmrlzu nzvz-nqblq-krnge me pnz drtwrnge mz nzayrbzkq-krnge trau scnge? ?Nide kc tqdobu-ngrn murde nivz lrnge nzmrlz-krbzle badr?’” ");
INSERT INTO ntu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Zbz rpi-mop Jiszs bagr kx, “X nzprtrkr leplz mz nzlungr kxboi kxnamu-kzle lc. Murde kzdung leplz txneng mzli ka sa na-avzdzng, x kzdung leplz kxnzetung mzli ka sa na-avzong.” ");
INSERT INTO ntu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Mzli kc tqvz-ngrgr mz lrpzki mz nzvzkilz-krgr Jerusalem, Jiszs katxpxmle nigr ncblo nedeng, vzkitxpxkr rlru kxpipz x rpimle bagr kx, ");
INSERT INTO ntu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ninge Mrlx Leplz. X mzli kc nakrlztr-ngrbzku Jerusalem, sa nakaobz ninge mz mqdr kxnzetu rdr pris x kxnzalvztrng mz Lou sc Mosis. Zbz navzmibzlr ninge mz Kansrl x drtwrdr sa naesz'ti kx nabzx. ");
INSERT INTO ntu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Zbz nakao-mopwzlr ninge mz mqdr lr Rom kxtrngiulrJiu mz nzrnibqngr ninge. X lr Rom lcng sa naxtrnga-ngrdr ninge, naviplalr ninge x natqlvztrlr ninge mz kros. A' mz zbq kratq mz nibr nzbz-krnge, ninge kc tzatulzpe-mop mz nzlungr.” ");
INSERT INTO ntu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zbz olvz r Sebedi vzm mz Jiszs, nidr badr Jemes x Jon, mrlxde kcng li. Rweobz zpr bade x rlxtibzle da kx na-alebzle bade. ");
INSERT INTO ntu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jiszs rveabz bade kx, “?Nike suti drtwrm na-alebo bam?” Ayzlu-ngrbzle natqde kx, “Rlr-ngrbz mz mrlxnge lcng li nzwxbu-krmu badr, kzdq mz nrlarm kxrtc, x kzdq kz mz nrlarm kxmc, murde nanginidr kxnzetung kxnzmyapxbzng.” ");
INSERT INTO ntu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","A' rpibz Jiszs badr kx, “Trkrlz-angidrwamuu nike tqrlxtiamu! ?Nzmu rlrpx-lzbq-ngrnamu mz nzprtrngr mz nzetqkr drtq kc naprtilzle ninge?” Nzayzlu-ngrbzlr natqde kx, “Eu, krlzkr nzalengr da lc!” ");
INSERT INTO ntu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Zbz rpibz Jiszs badr kx, “Da zpwxtx, drtqmu la naetq kz, da kc nawai nzetqkr drtqnge. A' trpnzngr scnge zmatq mz nzka-krbo me matq lcng. Murde Trtenge kx rmcpxpwz krkcng nawxbuong mz tron lcng.” ");
INSERT INTO ntu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Mzli kc tqxlr-ngrbzkr da lc, drtwrgr kc tqlctrpebz badr rlilrdr. ");
INSERT INTO ntu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Zbz Jiszs sc tqkqlepemle nigr amrlx ngrgr x rpimle bagr kx, “Krlzamu kx king mz nrlc ka nzrtulrtr-ngrbzlr mz leplz nzalengr da mz nzmnclz-krbzlr badr. ");
INSERT INTO ntu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","A' bzkq mz nimu. Murde mrlx kx rpile namyapxbz mz nimu mz nzaclve-krde leplz nengeng, nawztrpz bamu. ");
INSERT INTO ntu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","X mrlx kx rpile nangi kxetu kxmyalz, na-avzo-lzbq x nawz-nrbalqtrpz bamu. ");
INSERT INTO ntu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ninge Mrlx Leplz. X kxmule-esz' ninge kxetu rmu, a' vz-ngrmc mz nrlc mz nzwztr-krbo mz leplz, a' trngiu leplz kx nawztrpqng bange. X vz-ngrmc nzrlrpx-krbo nzlu-krnge mz nzxpepx-krbo leplz kxnzkqlung mz zmatq ngr nzbzngr.” ");
INSERT INTO ntu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Mzli kc tqrlaszpe-mou-ngrgr badr Jeriko, nzyrkr-nqblqmlr nigr zbo ngr leplz kxetu. ");
INSERT INTO ntu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","X mz nrlar lrpzki lc tqo-zlikr, nzwxbung elr ncblo li kx mztr mwi. Mzli kc tzxlrpe-ngrdr kx Jiszs sc tqvzpe mz lrpzki, sc tznepxpeng mz nzrpi-krdr kx, “Mrlx Devet, nayc mz drtwrm nigr!” ");
INSERT INTO ntu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","A' leplz lcng nzlclvzlr nidr x nzrpibzlr namnc-lrping. A' sc tzaetunelz-zlwzlr natqdr, mz nzrpi-krdr kx, “Kxetu! Mrlx Devet, nayc mz drtwrm nigr!” ");
INSERT INTO ntu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jiszs kc tqtupe, tqkqlepele ncblo kcng li, rpibzle kx, “?Nike suti drtwrmu na-alebo bamu?” ");
INSERT INTO ntu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nzrpibzlr kx, “Kxetu, naobq-moukr.” ");
INSERT INTO ntu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jiszs yc mz drtwrde nidr x maletrpzle mztr. X mzli kcpwz mztr obqtxpx pnz. X sc tzvz-nqblqpe-kzlr nide. ");
INSERT INTO ntu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Zbz krlzbzkr badr Jiszs mztea Betpeji mrkc mz Newz ngr Nc Olivi. Mrlc esotrpebz Jerusalem. ");
INSERT INTO ntu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","X Jiszs sc tqrpipebzle mz kzdu nigr nzling kx, “Vznamu mz mztea lcmonr tzmcpz. Mzli kc navztr-ngrbzmu, sa namcamu dq dcngki nidr mz neide, nzatolvangr mz nqvi. Yokaepxamu nqvi lrdr x vzmimamu. ");
INSERT INTO ntu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nzmu kx tzrpibz kzdu leplz nike tqvzmi-ngrnamu dcngki lang, rpibzmu kx, ‘Suti drtwr Kxetu.’ X mzli lcpwz ncblo la sa narlr-ani-ngrbzle bamu.” ");
INSERT INTO ntu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Da lc atutrle nzrpikr Profet kx, ");
INSERT INTO ntu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Pibz mz lr Jerusalem kx, ‘King rmu dese tqvzpem mz nrwx, votrp mz nei dcngki.’” ");
INSERT INTO ntu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kztegrng nzvzng x sc tzalepelr da kc tqpibz Jiszs badr. ");
INSERT INTO ntu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nzvzmimlr dcngki kc x neide mz Jiszs, nzprlxobzlr nzkq scdr mz nibrdr, x Jiszs sc tqwxbuopem mz nei dcngki kc. ");
INSERT INTO ntu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kzdq zbo ngr leplz kxetu nzprlxtiolr nzkq scdr krali mz lrpzki mrkc navokipx Jiszs. X kzdung nzrplamesitipxmqng nabx nc paam, nzprlxlvzti-kzlr lrpzki. ");
INSERT INTO ntu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Leplz kxkqlu kcng tzrtwayzng x krkcng tzvzbzng mz nibr Jiszs, sc tzkabo-katomipelr kx, “Hosana! Glqpxkr nim Mrlx Devet! Glqpxkr Kxnzmcpx kc tqvzm mz drtq Yawe! Ngrlvzkr Gct kc tqmyalz-esz'ngr!” ");
INSERT INTO ntu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mz nzvotr-krbz Jiszs kc Jerusalem, lr mzteadau amrlx drtwrdr rvea x nzyrkr-lxblrqmng. X leplz kxnzkqlung nzrpilr kx, “?Nelc krlc?” ");
INSERT INTO ntu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Zbo ngr leplz kcng nzayzlu-ngrbzlr natqdr kx, “Krlc Jiszs, profet ngr mztea Naszret mrkc Gzlili.” ");
INSERT INTO ntu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jiszs vztr Mangr-nzangiongr Yawe. X sc tqmaszlrpxpe-ngrde leplz kcng tzxpeting x tzamwating dalr nzrkangr blz. X alzngubzle tebol nyzdr lr Jiu kcng tztekqtrpzlr trau r mrkzbleng mz trau r Mangr-nzangiongr. X alzngu-kzpzle da kx nzwxbulvzo leplz kcng tzamwang nran kx nangi blz. ");
INSERT INTO ntu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Rpibzle mz leplz kcng tzmncng elr kx, “Nzyro mz Nzryrngrkxtr rpi Gct kx, ‘Ma nyznge nangi ma ngr nzkrka'kr leplz.’ A' apusr-ngrnamule me nzamwangr da kcng tqangqnguti-lzbq-ngrnamu!” ");
INSERT INTO ntu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Zbz leplz kxkqlu kcng mztr tqmwiti x kxnzvz-tengineng nzvzbzng bade Mangr-nzangiongr, x sc tqamrlzpebzle nrkrdrtqdr. ");
INSERT INTO ntu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","A' kxnzetu rdr pris x kxnzalvztrng mz Lou sc Mosis drtwrdr ngyatx zlwz mzli kc tzmc-ngrdr da kcng amrlx tqmrlzting tqalele. X drtwrdr lc, mzli kc tzxlr-ngrdr doa kxnztopwzng mrkc Mangr-nzangiongr mz natqdr nztu-krde mz nzrpi-krdr kx, “Hosana! Glqpxkr nim, kx Mrlx Devet!” ");
INSERT INTO ntu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nzveatibzlr mz Jiszs kx, “?Xlr-kzq da kc tqvz-rbr tzpilr?” Ayzlu-ngrbz Jiszs natqdr kx, “Eu. A' trvz-rbru. Murde rlwx-zvzamu mz Nzryrngrkxtr kx, ‘Gct, mz nzvz-nqblq-krde me pnz drtwrm, doa kxnztopwzng nzglqlzlr nim.’” ");
INSERT INTO ntu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sc tqrlaszpekr nidr mrkc Jerusalem, nigr badr Jiszs. X sc tqvzpekr mztea Betzni mz nzmwi-krgr. ");
INSERT INTO ntu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nrlc kx ngrlxobzle mz nourla, nigr kc tqvzpe-moukr Jerusalem. Jiszs nelzde brtale. ");
INSERT INTO ntu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Mcle kc nc fiki mz nrlar lrpzki. Vztrpz mz noude, a' mc-txpwzle leu rde. X sc tqrpipebzle bade kx, “Trpnz-moungr nzpa-krm!” X mzli kcpwz nounc kc sc tqglrpe. ");
INSERT INTO ntu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kx mckr kc nzglrtx-ani-krde, kctitxpxkr x rpibzkr bade kx, “?Myx kxmule nounc lc tqglr-anitx-ngrpwzle?” ");
INSERT INTO ntu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ayzlu-ngrm Jiszs natqgr kx, “Da angidr lc napibo bamu. Bzkq drtwrmu li, a' nzmu drtwrmu nabrle, krlzamu nzalengr da kcpwz tqwaisz-ngrne nounc lc. X krlz-kzamu nzrpi-krbzmu mz newz lc kx, ‘Brkalzm x tao prla mz zmatq ngr Gct.’ X Gct sa narlr-ngrbzle bamu nike rlxtiamu. ");
INSERT INTO ntu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mz nzmu-krde lcde, Gct sa nakabzle da amrlx kx rlxtiamu vzpxm mz nzrlxngiti-krmu.” ");
INSERT INTO ntu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jiszs vztrpz mz makoa ngr Mangr-nzangiongr Yawe. X mzli kc tqalvztr-ngrde leplz, kxnzetu rdr pris x lrtzlvzng nzvzmqng mz nzvea-krbzlr bade kx, “?Neke rkabz bam zmatq mz nzale-krm da lcng tqaleq?” ");
INSERT INTO ntu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Rpibz Jiszs badr kx, “Sa napibo me twzkimc zmatq kc tqale-ngrne da, a' ayzlu-kaipa'mu nzvea-krbo bamu. ");
INSERT INTO ntu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","?Zmatq ngr nzawrkxtrkr Jon twzmle drlve? ?Kaom Gct o kabz ncblo?” Sc tztalwzpeng mz nidr esz'-krdr, tzrpipelr kx, “Nzmu narpiku kx, ‘Zmatq kx kaom Gct,’ sa narpimle kx, ‘?E memule trlxngiti-ngrwamuu natqde?’ ");
INSERT INTO ntu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","A' nzmu narpiku kx, ‘Zmatq kx kabz ncblo,’ namwxlrtiku leplz kxkqlu ma tznibqlr nigu, murde nzlxngitilr kx Jon nide profet.” ");
INSERT INTO ntu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Zbz sc tzrpipebzlr mz Jiszs kx, “Trkrlzkru.” Rpibz Jiszs badr kx, “X trpengr nzpi-kz-krbo me twzkimc zmatq kc tqwz-ngrne.” ");
INSERT INTO ntu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Rpi-mopwz Jiszs badr kx, “Na-aoti ena drtwrmu be lc. Kzdq kc ncblo mrlxde nzling. Vzbz mz mrlxde kxetu x rpibzle bade kx, ‘Mrlxnge, vztx x wz mz nrlanc kc.’ ");
INSERT INTO ntu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mz trnzamrlue-krdeu trtede, rpibzle kx, ‘Bzkqtxnge.’ A' mz nibrde tekqtr-moule drtwrde x sc tqvzpe mz nzwzngr. ");
INSERT INTO ntu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mzli lc trtede vz-kzpz mz mrlxde kc tqtopwz x pi-kzpzle da kcpwz. X rpibzle mz trtede kx, ‘Eu. Ninge la navzx.’ A' trvz-pnzu mz nzwzngr. ");
INSERT INTO ntu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Pimamu ena bange. ?Kznike tqotibzle nzwzngr kc tqpibz trtedr?” Kxnzetu r lr Jiu kcng nzrpibzlr kx, “Krkc tqetu.” Zbz rpibz Jiszs badr kx, “Da kx napi-angidrbo bamu desele. Mz nqmq lcpwz, srlx x kxnzatakqting takes nztekqtrlr nqmq nr drtwrdr, nzmnclzbzng mz Gct x sa naprtr-kaing Heven. A' nimu kc tqvz-zvzbeamu nzpxtxpx-krmu nide. ");
INSERT INTO ntu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Murde Jon Kxawrkxtr vzm mz nzaelwapx-krbzle bamu lrpzki r Gct mz nzatubqti-krde leplz mz nzobq-krde, a' trlxngitiwamuu nide. A' srlx x kxnzatakqting takes nzlxngitilr nide. Kxmule-esz' mclamu da lc, a' trtekqtr-kzwamuu nqmq nr drtwrmu mz nzlxngiti-krmu nide.” ");
INSERT INTO ntu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Rpi-mopwz Jiszs kx, “Lalztq-mouamu mz kzdq kz nzycmne-ebzpxngr. Kzdq ncblo petile kc nrlanc ngr grep mz drtc' nyzde. Lvztrle bz ngrde, oliqtile kc da kx narwzngr waen, x wz-kz-ngrde kc me na-aukzngr mz nrlanc kc. Zbz sc tqrlrpe-ngrbzle mz kzdung ncblo kx narbilqng x naxpebzlr bade kzdung nra grep mz nrlanc lc. Zbz sc tqrlaszpele mrnyzde, tqvzpe rlru mrkzble. ");
INSERT INTO ntu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Zbz mzli kc tqbrpengr grep, sc tqatwzlrpe-ngrbzle kcng kxnzawz nedeng kx nayzlumibzlr du nra grep kx nangi mqde. ");
INSERT INTO ntu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","A' kx nzkrlzbzlr nrlanc kc, nzlolvztitxdr krkcng tzrbilqng nrlanc kc. Nztztilr kc, nznibqlr kc, x nzvaeputilr kc. ");
INSERT INTO ntu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Zbz atwzlr kcng kxnzawz nedeng badr, nzmyaszpxlr krkc kaing. A' ncblo kcng tzrbilqng nrlanc kc nzatrkati-kzlr nidr, da kc tzwaisr-ngrdr krkc kaing. ");
INSERT INTO ntu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Zbz mz nibrde sc tqatwzlrpe-ngrbzle mrlxde. Murde mz drtwrde rpile kx, ‘Ncblo kcng sa na-amrluebzlr mrlxnge x sa nakabzlr du bade nra grep kx nangi dalr nzrbilqngr.’ ");
INSERT INTO ntu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","A' mrlxde kc kx nzmc ncblo kcng tzrbilqng nrlanc kc le, sc tzrpi-etrpelr kx, ‘Mrlx kxetu kc tqrnginyz nrlanc ka nide kape. Nanibqpeku, murde da nyz trtede nangi nyzpegu.’ ");
INSERT INTO ntu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nzlolvzlr nide, nzrtctxpx-ngrdr mz nrlanc kc, x nznibqlr nide. ");
INSERT INTO ntu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“X mzli kc navz-ngrm kxetu r nrlanc kc, krlzpeamu da kx na-alebzle mz ncblo kcng tzrbilqng!” ");
INSERT INTO ntu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","X leplz kcng tzlalztqbzng bade nzrpibzlr kx, “Sa navzm nanibqtile ncblo lang. X nrlanc kc sa nabilq-alzupwz ncblo kzbleng kx narkabzng bade nra grep mz mzli r nzbrpe-krdr, nangi dalr nzrbilqngr.” ");
INSERT INTO ntu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","X rpibzle badr kx, “Zpwxtx! Krlz-angidramu Nzryrngrkxtr lc tqrpile kx, ‘Rplz kc etu tzpxtxpx-ngrdr ncblo kcng tzrwz-ngrng ma, nzaelwapxngr kx nide nou rplz kc tqmyatxpx-zlwzbz. Da lc, Yawe kxrwzngr. X abrtztx-zlwz-ngrgu.’ ");
INSERT INTO ntu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Mz nzmu-krde lcde, Gct sa nakatxpxle nimu lr Jiu mz nzngini-krmu leplz nedeng. X sa navectrple bade leplz kxtrngiulrJiu kcng namnc-nqblqlr nqmq krde, murde namnclzbzng bade mz nzngini-krdr leplz nedeng. ");
INSERT INTO ntu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Leplz kcng trnzabrtzlvzlru rplz lc tqmcpx Gct, apule kx nztaong elr x nzataki-lzbqng. X leplz kcng tzvz-zvzng nzpxtxpx-krdr rplz lc, sa na-ayrplapxng kalr mz Mzli Kxmatq kc navzm, apule kx rplz kc nataobz badr x natamyr-ngrde nidr.” ");
INSERT INTO ntu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kx nzxlr kxnzetu rdr pris x Farzsi nzycmne-ebzpxkr Jiszs lcng, nzkrlzlr kx Jiszs ycmnetr-ngrde trnzvz-nqblq-krdru nqmq kr Gct. ");
INSERT INTO ntu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Zbz nzrpilr nalolvzlr nide. A' nzmwxlrtilr leplz kxkqlu ma tznibqlr nidr, murde nzlxngitilr kx Jiszs nide profet. ");
INSERT INTO ntu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Zbz Jiszs yapwxti-mopwzle kc nzycmne-ebzpxngr mz leplz kcng tzyrlwrng Mangr-nzangiongr. ");
INSERT INTO ntu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Rpibzle badr kx, “Napibo bamu kxmu nzvectr-krm Gct leplz bade mz be lc. Kzdq kc king oliqtile kc nzmungr kxetu mz nzyrlzkr mrlxde. ");
INSERT INTO ntu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Atwzlr-ngrbzle kxnzawz nedeng kx napibzlr mz kxnzaveating kx navzpemqng. A' nzpxtxpx-ngrdr nzvz-krmlr. ");
INSERT INTO ntu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mz nibrde atwzlr-mou-ngrbzle kxnzawz nedeng mz kxnzaveating mz nzrpi-krbzlr badr kx, ‘Mzli ka da amrlx mrlzpe. Murde kzu nznibqtipe x nzbipeng. Vzpemamu mz nzmungr mzli ka!’ ");
INSERT INTO ntu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Kxmule-esz', a' leplz kcng trnzlxngitilru nrpa kc. X matitr drtwrdr zbq lc x nzvz-bekang mz nepu nr drtwrdr. Kzdung nzvzng mz nrlanc nyzdr. X kzdung nzvzng mz nzwzngr. ");
INSERT INTO ntu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","X kzdung nzlolvzlr kxnzawz neng king, nztzlr nidr, vz x nzbzng. ");
INSERT INTO ntu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","King kc drtwrde ngyatx zlwz. X atwzlr-ngrde ami nede x nznibqtilr leplz kcng tznibqtilr kxnzawz nedeng x nzkatrpzlr nyr ngr mztea nyzdr. ");
INSERT INTO ntu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Zbz kqlele kxnzawz nedeng x rpibzle badr kx, ‘Nzmungr oliqtxpe.’ A' leplz kcng tqaveatixng trnztakitrdru nidr nzprtr-krdr mz nzmungr lc. ");
INSERT INTO ntu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Vznamu mz lrpzki amrlx x rvzmimamu leplz amrlx kx rmctiamu, navzmqng mz nzmungr lc. ");
INSERT INTO ntu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kxnzawz nedeng nzvzng mz lrpzki x nzayrlwr-lxblrlr leplz amrlx kcng tzrmctilr, kxmule-esz' kxnzmrlzng o kxnztrkang. X ma nyz King yrbupxm mz leplz. ");
INSERT INTO ntu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“A' mzli kc king tqvzpe-ngrmle mz nzmc-krde leplz amrlx, rmctile kc ncblo kx trpxi-ngrdeu lrpz kx kabzle mz leplz lcng amrlx, mz nztakitr-krde nidr nzprtr-krdr mz nzmungr lc. ");
INSERT INTO ntu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Rpibz king bade kx, ‘?Mzlenge, memule tqvztr-ngrme mrka, trpxiwq lrpz kxmyapxbz kc tqkabo?’ A' ncblo kc anabu txpwz. ");
INSERT INTO ntu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Rpibz king mz kxnzawz nedeng kx, ‘Peamu mrlx lc x rtcpx-ngrnamu yz, mrkc tqtungr nzlo x tzyrningr leplz mz nzetqkr drtqdr x tzmadqti-ngrdr nqngidr mz zngya.’” ");
INSERT INTO ntu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Zbz Jiszs ayrkrpxle nzycmne-ebzpxngr lc mz nzrpi-krbzle kx, “Kxmule-esz' Gct aveatile leplz kxnzkqlung mz nzmnclz-krbzlr bade mz nzngini-krde king, a' kxnzmcpxng nzpipzng.” ");
INSERT INTO ntu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Zbz Farzsi nzvzng x sc tzyrlwr-lxblrpeng mz nzryrlq-krdr drtwr ngr nzrtxtio-krdr Jiszs br mz nzycmne-krde, murde nalolvzlr nide. ");
INSERT INTO ntu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nzatwzlr-ngrbzlr bade kcng oblamzng Farzsi x kzdung leplz ngr dzbede kc mz Herot. Nzvzbzng nzrpibzlr kx, “Kxakrlz, krlzkr kx nike piq x alvztr-ngrn tubq zvz. X krlz-kzkr kx tu-amqngi-zvzq mz nzalvztr-krbzme nqmq kr Gct mz leplz, kxmule-esz' trna-abrtzlvzu kxnzetung. ");
INSERT INTO ntu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mz nzmu-krde lcde, pim ena bagr nike pnz drtwrm. ?Tubq mz Lou sc Mosis nzxpe-krbzku takes mz King r Rom o trtingr?” ");
INSERT INTO ntu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","A' mcplxtrpebz Jiszs nzatalz-krdr. Murde mz nzrpi-krbzle Eu, lr Jiu lcng nangyati drtwrdr nide mz nzokatr-krde enqmi rdr. X mz nzrpi-krbzle Trtingr, ncblo neng King Herot nalolvzlr nide mz nzxpqbrlr-krde lou sc gzpman ngr Rom. Rpibzle badr kx, “Nimu blzpokiang! ?Memule tqrpi-ngrnamu na-atalz-ngrnamu ninge? ");
INSERT INTO ntu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Aelwa-ngrmamu dq ena srlrni kc tqxpe-ngrnamu takes.” Nzaelwa-ngrbzlr kc srlrni. ");
INSERT INTO ntu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","X sc tqveapebz kx, “?Mqngr nar nelc tqmnztr mz srlrni lc, x drtq nelc tzyrtr elr?” ");
INSERT INTO ntu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nzrpibzlr kx, “King r Rom.” Zbz rpibzle badr kx, “Mz nzmu-krde lcde, kabzmu mz king da kx takitrde king x kabzmu mz Gct da kx takitrde Gct.” ");
INSERT INTO ntu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ncblo kcng kx nzxlrbzlr da lc nzkctitxpxlr natqde, murde trprtz-pnzu mz trtxki scdr. X sc tzdwaszpelr nide. ");
INSERT INTO ntu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mz zbq lcpwz, kzdung Sadiusi nzvzmqng mz Jiszs Mangr-nzangiongr. Nidr dzbe lr Jiu kx trnzlxngitilru nztulz-mou-ngrm mz nzbzngr. Nzveatibzlr da kx na-atrkati-ngrbzlr nzalvztr-krde mz nzlu-mou-ngrm mz nzbzngr. ");
INSERT INTO ntu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Nzrpibzlr kx, “Kxakrlz, rpi Mosis kx, ‘Nzmu ncblo kx bzszle olvz rde x trpnzngr nedr doa, mzlede nayrlzti-alzule olvz lc, murde nzrngine-krdr doa na-apule kx ngi doa ne mzlede kc tqbzpe. X doa lc natekqtrle nzmrbrpx-krbz nqvi lr ncblo kc tqbz x natwzle dztudeng.’ ");
INSERT INTO ntu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nzmu narpingr kx kzdung mzle-lzbq nzrlimzng. Mzledr kc tqetu yrlz. Zbz mzli trboiu sc tqbzszpele olvz rde, trpnzngr nedr doa. X olvz rde natwz alzu mzlede krali. ");
INSERT INTO ntu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Da lc nzwai mzlede krali x kratq. Vz, vz, olvz kc nzyrlzti mzle-lzbq kcng nzrlimz. ");
INSERT INTO ntu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","A' trpnzngr nedr doa. X mz nibrde olvz kc sc tqbzpe kz. ");
INSERT INTO ntu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Alvztr-ngrn kx leplz tulz-mop mz nzbzngr. ?Kx tqmule lcde, neke nartwz olvz kc mzli kc natulz-moungr leplz amrlx? Murde mzle-lzbq kcng rlimz nzyrlztilr nide. ?Myx kxmule, Gct batrpzle mz olvz lc nzxpqbrlr-krde natqde mz nzyrlzti-krde ncblo kcng rlimz mz mzli kxesz'?” ");
INSERT INTO ntu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jiszs ayzlu-ngrbzle natqdr kx, “Nzao-krmu drtwrmu vz-rbrtx atwrnrngr. Murde tryrplatitru narmu zmatq ngr Gct x drtwr ngr Nzryrngrkxtr. ");
INSERT INTO ntu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Mzli kc na-alu-moungr Gct leplz mz nzbzngr, sa na-apupelr enjrl kcng tzmncng Heven. Trnzyrlzpeung, x trpnzngr nzyrlz-mou-krdr kalr. ");
INSERT INTO ntu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","X Gct aelwapx-ngrde kx krkcng tzbzpeng sa na-atulzmqng mz nzlungr. Krlz-angidramu natq Gct kc tqrpibzle bamu kx, ");
INSERT INTO ntu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ninge Gct ngr Ebraam, Aesak x Jekop.’ Kxmule-esz' ncblo lcng tq nzbz-pnzng, a' trpileu kx nide Gct ngrdr mzli kc pnz. Murde nibede Gct ngrdr mz nzlu-krdr Heven mzli ka.” ");
INSERT INTO ntu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kx nzxlrbz zbo ngr leplz natq lc, nzkctitxpxlr nzalvztr-krde. ");
INSERT INTO ntu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kx nzxlr dzbe Farzsi nzamyati-krbz Jiszs drtq dzbe Sadiusi x awx-nabule nidr, sc tzyrlwr-lxblrpeng mz nzryrlq-krdr drtwr ngr nzatalz-krdr nide. ");
INSERT INTO ntu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Zbz kzdq nidr kc tqngi kz kxalvztr mz lou sc Mosis, vzbz bade x sc tqveapebz bade kx, ");
INSERT INTO ntu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“?Kxakrlz, lou kznike myaszpxle lou amrlx?” ");
INSERT INTO ntu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ayzlu-ngrbz Jiszs natqde kx, “Doa kxesz' mz nimu, namrlztiq Yawe, Gct rmu mz nabzm atwrnrngr, x mz nzwikr nelzm atwrnrngr, x mz drtwrm atwrnrngr. ");
INSERT INTO ntu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Krlc lou sc Gct kx ayrnrngr x kx myapxbz. ");
INSERT INTO ntu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","X lou krali apupwzle nide. Rpile kx, ‘Esz' mz nimu, namrlztiq kztemqng da kc tqwaiq nzmrlzti-lzbq-krm.’ ");
INSERT INTO ntu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Lou lcng li ngi nou da amrlx mz Lou sc Mosis x nzalvztrkr profet.” ");
INSERT INTO ntu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mzli kc tzyrlwrbengr Farzsi kcng mrkc, Jiszs rveabz badr kx, ");
INSERT INTO ntu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“?Mz drtwrmu neke tqngi Kxnzmcpx, x vzpxm mz nqvi lr ncblo kznike?” Nzrpibzlr bade kx, “Vzpxm mz nqvi lr King Devet.” ");
INSERT INTO ntu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Zbz Jiszs rvea-mopwz badr kx, “A' memule tqbatr-ngrbz Mqngrkxtr mz Devet nzrpi-krde kx Kxnzmcpx nide kxetu rde. Murde rpi Devet kx, ");
INSERT INTO ntu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Yawe rpibzle mz King kc tqngi kxetu rnge kx, Wxbu mrlc tqmatq-esz'ngr mz nrlarnge kxrtc, navz nakrlz-zpwxbzle mzli kc nangi-batr-ngrbo mz enqmi rmqng nzmetx-krbzlr bam.’ ");
INSERT INTO ntu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mz Sam lc Devet rpile kx, Kxnzmcpx ngi kxetu rde. ?A' myx kxnamu Kxnzmcpx nznginikr doa mz nqvi lrde kc mzte trnzmcka, x mzli kcpwz ngi kz kxetu rde?” ");
INSERT INTO ntu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","A' nzveakr Jiszs trpnzngr kx ayzlubz. X abzo mz zbq lc, trpnz-moungr kx veabz bade da, murde ma drtqdr tqmya zvz. ");
INSERT INTO ntu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Zbz Jiszs sc tqalvztrpele nigr badr zbo ngr leplz kcng. ");
INSERT INTO ntu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Rpimle kx, “Kxnzalvztrng mz Lou sc Mosis x Farzsi nzrngisc zmatq mz nzalvztr-krdr x nzyokaetipx-krdr Nzryrngrkxtrng. ");
INSERT INTO ntu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mz nzmu-krde lcde, navz-nqblqamu da amrlx kcng tzalvztr-ngrdr nimu. A' bzkq vz-nqblqamu nqmq krdr, murde trnzvz-nqblqlru da kcng tzalvztr-ngrdr leplz. ");
INSERT INTO ntu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nzaleti-katong nqmq krdr kxkqlu kx nayrlqtr-mopwzlr mz Lou sc Mosis. X rblxbz mz leplz nzma-nqblq-krdrleng. Murde nqmq lcng nzapupelr da kxmrlepu, kx nzyrlqlzbzlr mz nabx leplz kx naglqlr. A' nidr esz'-krdr, trnzvz-nqblqlru nqmq lcng. X trnzokatrlru leplz nzrglqngr da kcng tqmrleputi. ");
INSERT INTO ntu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“A' da kx myapxbz badr, leplz na-amrluelr nidr mz nzrpi-krdr kx nidr ncblo kxnztrng. Krlc nou da amrlx kcng tzalelr. Murde bokis kxtopwz kcng tzpetrlr mz rtrlrmztr x mqdr tqyctrngr Nzryrngrkxtr, nzaetunepxlr. X nctq nqvi kcng tzdotitrng mz lrpz scdr nzaboiti-kzlr. Murde nzrpilr narpingr leplz kx nzaoti zvz drtwrdr nzvz-nqblq-krdr natq Gct. A' trtingr. ");
INSERT INTO ntu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","X mrlzbz badr nzwxbu-zvz-krdr me matq mz mangr-nzkrka'ngr x mz mzli r nzmulvzngr, murde nzglqpx-lzbqng. ");
INSERT INTO ntu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","X mrlz-kzpz badr nzamatqkr leplz nidr mz nzrpi-ngrbz badr kx, ‘Nim la, kxetu,’ mz nzvzne-krdr me nzamwangr da. ");
INSERT INTO ntu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","A' bzkq pibzmu mz kztemung kx na-amrluelr nimu mz nzalvztr-krmu nidr me pnz drtwr Gct. Murde nimu amrlx ngrmu mzle-lzbq x ile-lzbq mz nzmnclz-krmamu bange. X ninge kxakrlz kxmyapxbz kx takitrde nzamrluengr. ");
INSERT INTO ntu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","X bzkq rpiamu kx rblxbz mz kxnzakrlz ngrmung nzvz-rbrngr. X bzkq armyalzamu nidr x rpibzmu badr trte. Murde nimu amrlx ngrmu trtemu esz'txu kc tqmncm Heven. X mz nzalvztr-krde nimu tubq zvz x trvz-rbru. ");
INSERT INTO ntu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","X bzkq pibzmu mz kztemung kx nalalztq-txpwzng bamu mz nzrpi-krbzmu badr drtwr ngr natq Gct. Murde ninge Kxnzmcpx, kxaclve kxmyapxbz kc tqyokaetipxbzle bamu natqdeng. ");
INSERT INTO ntu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Murde mrlx kx namyapxbz mz nimu mz nzaclve-krde leplz nengeng, nawztrpz bamu. ");
INSERT INTO ntu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Murde mrlx kx amyalz-lzbq mzli ka, sa na-avzo Gct nide yu. A' doa kx avzo-lzbq mzli ka, sa na-amyalz Gct nide.” ");
INSERT INTO ntu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Jiszs rpi-mopwzle kx, “Agrmplz nimu blzpokiang, nimu Farzsi x kxnzalvztrng mz Lou sc Mosis! Murde Gct sa na-ayrplapxle nimu! Murde tr-rlrpx-lzbq-ngrwamuu nzmnclz-ngrbz bade. X nzalvztr-rbr-krmu rpwa'-ngrbzle mz leplz nzlxngiti-krdr nide. ");
INSERT INTO ntu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Agrmplz nimu blzpokiang, nimu Farzsi x kxnzalvztrng mz Lou sc Mosis! Murde Gct sa na-ayrplapxle nimu! Murde mz zmatq ngr nzngini-krmu kxnzrmailzng, angqngutitramu olvz kxnzbzszng mz nztwz-pnati-krmu dztudrng amrlx. X mzli kcpwz aboitiamu nzkrka'-krmu mz nzyrlq-kapq-krmu alwx ngrmung. Mz nzmu-krde lcde, nzayrplapxngr nimu kalr mz Hxl namyatxpx esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Agrmplz nimu blzpokiang, nimu Farzsi x kxnzalvztrng mz Lou sc Mosis! Murde Gct sa na-ayrplapxle nimu! Murde vznenamu rlru x alilvcamu rlru mz nzrmcti-krmu kzdq doa kx naprtrpz bamu mz nzangiokr lr Jiu. A' mz nzalvztr-krmu nide, nqmq krde myaszpx-zlwzle nztrkakr nqmq krmu. ");
INSERT INTO ntu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Agrmplz nimu kxnzrmailz-rbrng. Murde Gct sa na-ayrplapxle nimu! Rpibzmu mz leplz kx nzmu naesalz-ngrdr Mangr-nzangiongr Yawe, trmatqneu. A' nzmu naesalz-ngrdr gol ngr Mangr-nzangiongr, na-atutrlr nzesalz-krdr. ");
INSERT INTO ntu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","A' trtingr! ?Neke angqngule nimu? Me pnz drtwrmu vz-rbrtx. Mangr-nzangiongr myaszpxle gol murde nide kc tqatrle gol kc tqycpxm elr. ");
INSERT INTO ntu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Rpi-kzpzmu mz leplz kx nzmu naesalz-ngrdr olta ngr Mangr-nzangiongr, trmatqneu. A' nzmu naesalz-ngrdr da kc tqycom mz olta, na-atutrlr nzesalz-krdr. ");
INSERT INTO ntu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Narmu kc! Olta myaszpxle da kc tqycom elr murde nide kc tqatrle da lcdeng. ");
INSERT INTO ntu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mz nzmu-krde lcde, mz nzesalzkr leplz olta, nzesalz-ngrdr nide x da kcng amrlx tqycong elr. ");
INSERT INTO ntu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","X mz nzesalz-krdr Mangr-nzangiongr, nzesalz-ngrdr nide x Gct kc tqmnc elr. ");
INSERT INTO ntu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","X mz nzesalz-krdr Heven, nzesalz-ngrdr tron nyz Gct x Gct kc tqwxbuom elr. ");
INSERT INTO ntu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Agrmplz nimu blzpokiang, nimu Farzsi x kxnzalvztrng mz Lou sc Mosis! Murde Gct sa na-ayrplapxle nimu! Kxmule-esz' kabzmu da kranzpnu ngr da amrlx bade mz da kxtopwzng kx trmyapxpwzu. A' trkxtx-pnzu drtqmu da kxmyapxbz. Murde tralewamuu da kcng tqtubqbz mz leplz, tryc-ngru drtwrmu nidr, x tratutr-kzwamuu natqmu. A' takitrde nzale-kai-krmu da lcng tqmyapxbz, x ale-kzamu da kcng trmyapx-zlwzpwzung. ");
INSERT INTO ntu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mz nzale-krmu da lc, rmailz-rbramu! Murde yc zlwz mz drtwrmu da kxtopwzting mz Lou sc Gct, a' yrlqtxoamu da kcng tqmyapxbz. Apule kx rbotilzamu lxbi kxtopwzting mz nrlanc nyzmu, a' trkxu mz drtqmu poi kc etu tqekqtile nrlanc nyzmu atwrnrngr. ");
INSERT INTO ntu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Agrmplz nimu blzpokiang, nimu Farzsi x kxnzalvztrng mz Lou sc Mosis! Murde Gct sa na-ayrplapxle nimu! Yc zlwz mz drtwrmu nzale-krmu da kxmrlz mz nzobqkr leplz, murde rpiamu na-amatqlr nimu. A' mzli kcpwz nabzmu drka'-ngrng murde trkibramu x prlvz mzpu da. Apule kx ycpq-txpwzmu nibr kap x plet, a' da kxtrka kcng tqycpxm mz nabzmu tzatrkatilr nimu. ");
INSERT INTO ntu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nimu Farzsi vz-rbramu! A' na-atubqti-kaiamu nabzmu, murde Gct na-abrtzlvzle nimu x da kcng amrlx tqaleamu natubq-kzng mz nzobq-krde. ");
INSERT INTO ntu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Agrmplz nimu blzpokiang, nimu Farzsi x kxnzalvztrng mz Lou sc Mosis! Murde Gct sa na-ayrplapxle nimu! Nabzmu nzapulr gq lr kxbz kcng tzabrngzti, a' mz nabzdr la yrbulz-ngrm nrvr, zmibi, x zbrtu. ");
INSERT INTO ntu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mz nqmq lcpwz, mz nzmckr leplz nimu, mz drtwrdr nimu ncblo kxnztubqng, a' nabzmu yrbupxm mz nzpokiangr x da kxdrka'ngr. ");
INSERT INTO ntu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Agrmplz nimu blzpokiang, nimu Farzsi x kxnzalvztrng mz Lou sc Mosis! Murde Gct sa na-ayrplapxle nimu! Angrlotiamu gq lr profet x aluliti-kzamu gq lr kxnztubqng. ");
INSERT INTO ntu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","X rpiamu kx, ‘Nzmu namnckr mz mzli nyz melrmqgrng, e trprtrpwzkru badr mz nzrnibqngr profet neng Gct.’ ");
INSERT INTO ntu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","A' mz nzycmne-krmu lc, plzpxamu kx vzpxmamu mz nqvi lr kxdrka'-ngrng lcng tznibqlr profet neng Gct murde nzpxtxpx-ngrdr nzlalztq-krbzlr badr. ");
INSERT INTO ntu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","?Myx kxmule, pxtxpx-kz-ngrnamu natqnge? Sa tqmrlz ye. Nibq-kzamu ninge, da kc tzwai melrmqmung nznibqti-krdr profet kcng bqnc. Murde trblepxpwzmuu badr. ");
INSERT INTO ntu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Nimu kxdrka'-ngrng kxnzodang x doa neng kxdrka'-ngrng, x mrnyzmu kalr Hxl. ");
INSERT INTO ntu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","A' vz zvz, murde rpibo bamu kx profet, ncblo kxnzyrplapxng, x kxnzakrlzng nengeng sa navzmqng bamu mz nzpipx-krbzlr bamu natqnge. A' kzdung sa nanibqamu mz nztqlvztr-krmu nidr mz kros. X kzdu-kzng sa naiklaamu mz mangr-nzkrka'ngr nyzmung. Zbz sa namaneutipx-zvzamu nidr mz mztea amrlx. ");
INSERT INTO ntu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mz nzmu-krde lcde, sa narmcti-ngrnamu nzayrplapx-zlwzngr nimu. Murde Gct sa na-atamutilzbzle bamu alwx ngr nzrnibqngr kxnztubqng amrlx, abzo mz Ken nznibq-krde Ebol, krlzmle nzrnibqngr Sekaraea, mrlx Berekaea, kc tznibq mz mzlir Mrkc Tqtr x olta. ");
INSERT INTO ntu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Napibo bamu, Gct sa na-atamutilzbzle bamu nzayrplapxngr kx nzvzpxmqng mz nzrnibqngr kxnztubqng amrlx, murde nzbz-krdr vzpxm mz da kcng tqaletiamu. ");
INSERT INTO ntu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Kosae lr Jerusalem! Nibqtiamu profet neng Gct x vaebqtiamu menrpa kcng tqatwzlr-ngrmle bamu! Kxmule-esz' aodu-zvzx nimu x mzli kqlu kx rpi-ngrne na-apubo bamu kio kx wxbulvzole neideng a' tr-rlr-lzbq-ngrpwa'muu bange. ");
INSERT INTO ntu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nakxmupele lape! Murde Gct sa nartxmle nibrde bamu mz nzngini-krmu leplz nedeng. X trpnzngr nzokatr-mou-krde nimu. ");
INSERT INTO ntu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Napibo bamu, trpengr nzmc-mou-krmu ninge nakrlzbzle Mzli Kxmatq kc navzm x sa narpi-ngrnamu kx, ‘Yawe, glqlzkr Kxnzmcpx kc tqvzm mz drtqm.’” ");
INSERT INTO ntu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Mzli kc Jiszs narlaszpe-ngrde Mangr-nzangiongr Yawe, vzmgr bade sc tqlxtipebzkrng kxmu nzlrmztiongr nzrwzngr. ");
INSERT INTO ntu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Rpim Jiszs bagr kx, “Napi-angidrbo bamu kx da lcng amrlx tqmcamu, x Mangr-nzangiongr lc trnatu-alou. Trpnzngr rplz ngrde kx nablio me yc-ngrde. Murde sa naodati enqmi rmung kalr.” ");
INSERT INTO ntu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kx krlzbzkr kc Newz ngr Nc Olivi, Jiszs sc tqwxbupe elr, mrlcde nzmcpz Mangr-nzangiongr. Zbz kzdung kztegrng sc tzvz-lrpipebzng mrkc tqwxbu-ngrde. Nzrpibzlr kx, “Pim ena bagr mzli kc naodatingr Mangr-nzangiongr, x rkx kznikeng namc nakrlztingr mzli r nzyzlu-krme mzli kc nayrkrpx-ngrbz nrlc.” ");
INSERT INTO ntu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Rpim Jiszs bagr kx, “Aclvetio-lzbqamu mz da lcng. Bzkq rlr-ngrbzmu mz leplz nzapokiati-krdr nimu mz da kznikeng naprtz. ");
INSERT INTO ntu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ncblo nakqlung sa navzmqng mz drtqnge, narpibzlr mz leplz kx, ‘Ninge Mevalu Kxnzmcpx.’ X leplz nakqlung kalr nalxngitilr nidr mz nzpokia-krdr. ");
INSERT INTO ntu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“X mou, bzkq nelzmu tzprlzm mz nzxlr-krmu natqdr dalr nzotangr mz vea kx esotrpq x nrpa ngr vea kx ycm rlru. Da kxnzmulr lcng naprtzti-kaing, a' trngiu drtwr ngr nzyrkrpxpe-krbz nrlc. ");
INSERT INTO ntu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Murde mrkcng kqlu mz nrlc sa napnz-lzbqng. Dzbi kxetu sa navzmqng, x nengq kxetu sa navz-kzpqng. ");
INSERT INTO ntu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","A' da lcng tqprtzting nzapulr nztangqgx-zlwzkr olvz kxyr, mzli kc tqvz-ebir-ngrm nimz ngr doa kxtopwz, x sc tqrmika ate. ");
INSERT INTO ntu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Mzli lc sa na-aetqbzlr drtqmu, x sa nalolvzlr nimu, x nanibqlr nimu. Murde leplz mz natq amrlx x drtc' amrlx mz nrlc kcng tzmwati drtwrdr ninge sa namwati kz drtwrdr nimu mz nzngini-krmu leplz nengeng. ");
INSERT INTO ntu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mz mzli r nzkxpungr lcng, kzdung leplz kcng tzvz-nqblq-kailr ninge, sa trnalxngitilru ninge. Zbz mz nzmwatikr drtwrdr leplz nengeng, sa na-aprcbzlr nidr mz kxdrka'-ngrng. ");
INSERT INTO ntu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","X profet kxnzpokiang nakqlung. X sa naesabrtilr leplz mz nzmailz-rbr-krdr nidr mz nzalvztrngr angidr. ");
INSERT INTO ntu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mzli lc, nqmq kr leplz kxdrka'-ngrng sa naetunepx mz nzbatr-krbzlr nzbaokr nivz mz nrlc. ");
INSERT INTO ntu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","A' nimu kcng tztu-amqngi-zvzng mz nzrlxngiti-krmu krlzbzle mz nzbz-krmu, sa na-arlapx Gct nimu. ");
INSERT INTO ntu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","“X mzli lc, leplz nengeng sa nayapwxtipxbzlr Nrpakxmrlz mz leplz ngr drtc' x natq amrlx mz nrlc, kx Gct vectrple leplz mz nzngini-krde King rdr murde narlapxng, x nrlc kc tqyrkrpx ate.” ");
INSERT INTO ntu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Rpi-mop Jiszs bagr kx, “Kxdrka'ngr kxmyapxbz kc tqtrka-esz'ngr sa navzm, mz nzatutr-krde da kx yro Daniel mz buk scde. X nimu kcng tzrlwxlr da lc nakrlz-angidramu drtwr ngrde. Murde Kxdrka'ngr lc sa natuom Mrkc Tqtr Mangr-nzangiongr Yawe, a' trtakitrdeu nide nztuo-krmle elr. ");
INSERT INTO ntu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Mzli lc nimu kcng tzmncng Judiz nangrlrlzamu mz newz murde namnc-kapq-ngrnamu nzodangr kc tqycpe pipz nzkaputr-krmle. ");
INSERT INTO ntu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nzmu kx tqmncome mz nibr ma nyzm, bzkq asaq nzvoo-krme x bzkq otrpeq dztum ma nyzm. A' ngrlrtx pnz. ");
INSERT INTO ntu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","X nzmu kx tqwzq mz nrlanc, bzkq vzpeq ma nyzm mz nzoti-krm lrpzm, x sc tqngrlr-ateq. ");
INSERT INTO ntu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Agrmqng olvz kcng tzyrng x krkcng tzayqng itoto, murde rblxtile nidr nzngrlrlz-ani-krdr mz newz mz nzmnc-kapq-krdr. ");
INSERT INTO ntu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Krka'-ngrbzmu mz Gct murde ma nzrdwasz-krmu tqkaputrp mz Sabat kc tqngi zbq kxnzamati o mz mzli r zbao, mzli kc nrlc tqbao-zlwz-ngrde. ");
INSERT INTO ntu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Murde ztrka ngr nzkxpungr lcng sa namyaszpxlr ztrka amrlx abzo mz mzli kc ayrnrngr tqwzngr Gct nrlc krlzmle mzli ka. X trpengr nzwrde kxnamule lc kx naprtz kalr. ");
INSERT INTO ntu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Gct aotipe drtwrde nzamrbcnetr-krmle mzli lc, murde leplz ma tzyrkrtxtrng. X amrbcnetrple mzli lc mz nzokatr-krde leplz kcng tqmcpxpeleng. ");
INSERT INTO ntu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Mzli lcde, nzmu kx tzrpibz leplz bamu kx, ‘Obqki lcmonr Kxnzmcpx kc tqmnc mrkc!’ o ‘Obqkim ka nide se tqmnckibzle ka!’ bzkq lxngitiamu nidr. ");
INSERT INTO ntu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Murde mevalu kxnzpokiang x profet kxnzalvztr-rbrng sa navzmqng. X na-aleting rkx x da kx nakctipxng mz nzesabrti-krdr leplz kcng tqmcpxpeng Gct, nzmu nakrlzlr nzyatr-krbzlr. ");
INSERT INTO ntu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Lalztq-angidramu! Napi-kaipo da lcng bamu x mzli rdr kc tqvz-atem. ");
INSERT INTO ntu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Mz nzmu-krde lcde, nzmu kx tzrpibz leplz bamu kx, ‘Obqki lcmonr Kxnzmcpx kc tqmnc lzke!’ o ‘Obqkim ka nide se tqmncpxm ma ka!’ bzkq lxngitiamu nidr. ");
INSERT INTO ntu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Murde ninge Mrlx Leplz nzyzlu-krmc sa naotxpx mz mzpu. Sa na-apule nzrpnapxkr bzlrpc mz nzayzlrpx-krde bongavz, abzo mz kzdq nrlarde krlzbzle kzdq nrlarde. ");
INSERT INTO ntu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","X mz nzmc-krdr da lc, me mnc-ngrne naopxbz mz leplz amrlx.” ");
INSERT INTO ntu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Rpi-mop Jiszs bagr kx, “Mz nibr mzli r nzkxpungr lcng, ‘Gct sa na-aycngrlrtile dalr bongavz kcng tzmatq amrlx. Nepi nawx-nzlongr x temz trnapnzpxu. X vri sa natatio-lxblrmqng mz bongavz.’ ");
INSERT INTO ntu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ninge Mrlx Leplz. X mzli lc, sa namclz rkx rnge mz bongavz. X kxtrnzrlxngitiung amrlx sa namclr Mrlx Leplz mz nzvz-krmc mz nabz dcbz ngr bongavz mz zluli kxetu x zmatq. X sa nayrning murde nzkrlzlr kx mzli trnaboipeu x sc tzayrplapxpeng. ");
INSERT INTO ntu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","X mzli lc, trpu kxetu nayrni x sa na-atwzlrpx-ngrne enjrl nengeng mz nrlc tulvzo. X sa navzmimlr leplz neng Gct kcng tqmcpxleng.” ");
INSERT INTO ntu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Zbz rpi-mop Jiszs bagr kx, “Mwx natwzamu drtwr ngr nzplcokr leu r nc fiki. Mrka Israel mzli kc namc-ngrnamu nrlar nc fiki tzpooti-ngrdr x nzyrlqbzlr leu rdr kxmrna, sc tqkrlzpeamu kx mzli r nrpr ngr nranc sa tqesopem. ");
INSERT INTO ntu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mz nqmq lcpwz, mzli kc namc-ngrnamu kx da lcng tqpibo bamu sc tqtutrpemqng, sc tqkrlzpe-kzamu kx mzli r nzvz-krmc esotrpem. ");
INSERT INTO ntu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nakrlz-angidramu kx da lcng amrlx nangidati-kaing, x leplz kcng tzmncng mz nrlc sc tzyrkrtr-ateng. ");
INSERT INTO ntu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kxmule-esz' bongavz x nrlc sa nayrkrpxng kalr, a' natqngeng trtxpnzngr nzyrkrpx-krdr, murde sa nangidating amrlx.” ");
INSERT INTO ntu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Rpi-mop Jiszs bagr kx, “Trpnzngr kxrkrlz zbq x nabz nepi kc nayzlu-ngrmc. Trnzkrlzlru enjrl ngr Heven amrlx x trkrlz-kzwxu, a' krlz txpwz Trtenge esz'-krde. ");
INSERT INTO ntu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nayzlumc mzli kc leplz napxtxpx-ngrdr nzlalztqngr mz natq Gct, da kc tqwaile mz mzli nyz Noa. ");
INSERT INTO ntu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mzli lcde leplz nzmung, nzyrlzng, x nzpxtxpx-ngrdr nzlalztqngr mz natq Gct, vz vz krlzmle mzli kc Noa badr mrlxdeng tzdwatr-ngrdr mz lcsu kc etu. X nubla kc tqvo-atem. ");
INSERT INTO ntu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Murde kxdrka'-ngrng lcng trnzkrlzlru kx Gct sa naodatile nidr, a' dcpxpengr drtwrdr nzvo-krm nubla mz nzaboo-krde nidr. X kxnamu-kzle lc mz zbq kc nayzlu-ngrmc. ");
INSERT INTO ntu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mzli lc ncblo nzling nawz-lxblrng mz nrlanc kxesz'. Navzmipe Gct krkc tqtubq. X narlaszpe krkc trvz-nqblqleu ninge, mz nzodatingr nide. ");
INSERT INTO ntu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","X olvz nzling naoliq-lxblrng mz dakxnzng. Navzmipe kc x narlaszpe kc. ");
INSERT INTO ntu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mz nzmu-krde lcde, oliq-zvzamu murde trkrlzwamuu zbq kxnanginide. ");
INSERT INTO ntu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ncblo kx pna da trnzkrlzu zbq kx napna-ngrde da brma. Mz nzmu-krde lcde naoliqti zvz nzvz-krmle. ");
INSERT INTO ntu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","X mz nqmq lcpwz, naoliqti-zvzamu nzvz-krmc, murde ninge Mrlx Leplz sa navzmc mz mzli kx trnakrlzwamuu.” ");
INSERT INTO ntu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jiszs rpi-mople bagr kx, “Napibo bamu kxmu kxnzawz nenge kx brti drtwrnge. Sa na-apule kc kxetu kx aprcbzle mz kzdq kxnzawz nede mz nzaclve-krde kztedeng x mz nzapu-krde nidr. Zbz sc tqvzpe mz kzdq nrlc. Kxnzawz kxyrplapx x brti drtwr kxetu rde sa navz-nqblq-zvzle natq kxetu lc. ");
INSERT INTO ntu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mz nzmu-krde lcde, mzli kc navz-ngrm kxetu rde, kxnzawz lc sa na-abrtzlvzle nzale-krde nzwz-krde. ");
INSERT INTO ntu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Da angidr lc napibo bamu. Kxetu kc sa nayrlqle kxnzawz lc mz nzaclve-krbzle dztudeng amrlx. ");
INSERT INTO ntu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","A' nzmu nanginide kxnzawz kxtrka, sa narpile mz drtwrde kx, ‘Kxetu rnge trpnzngr nzvz-ani-krmle.’ ");
INSERT INTO ntu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Zbz sc tqabzope-kzle nzibrti-krde kztedeng. A' nide kc tqmu x tqangqnguti-lzbq-ngrde nzrmnqngr. ");
INSERT INTO ntu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","A' kxetu kc yzlum mz mzli kx trpnzu drtwr kxnzawz lc. ");
INSERT INTO ntu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Zbz kxetu kc sa na-ayrplapx-zlwzle nide x na-atwzlr-ngrde nide mrkc leplz nayrni-alo-ngrdr mz nzetqkr drtq x namadqtilr nqngidr mz zngya, badr leplz kx narpi-ngrbz kxnzrlxngiting.” ");
INSERT INTO ntu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jiszs rpi-mople bagr kx, “Mzli kc nayzlu-ngrmc mz nzngini-krnge King, sa naglx-angidrx leplz kcng tzvz-nqblqlr ninge x navzmix nidr Heven. Mzli lc leplz mz nrlc ka sa na-apulr olvi kcng mz be lc nayapwxtibo. “Kzdq nrlckxbq kzdu kcng olvi nzpnu-esz' tzaenzling mz ma nyz olvi kc nayrlz. Nzwz-krdr nzyangrle-krdr nyr mz lrpzki kc nao-zli ncblo kc nayrlz mzli kc navz-ngrmle, mz nibr nzatubqtingr narncbr ngr nzyrlz-krde. ");
INSERT INTO ntu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Olvi lcng nzlvqn nzyrplapxng, murde nzoliqtilr da kqlu kx nayangrlelr mzli kxboi. A' nzlvqn nzngqngung, murde nzoliqti-txpwzlr da kx esz' kx nayangrlelr mzli kxmrbc txpwz. ");
INSERT INTO ntu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ncblo kc nayrlz trvz-anipuu. X mztr kc tqone-mwitipe, x sc tzmwipeng. ");
INSERT INTO ntu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“A' mzli kc mz aurnrlc, sc tzxlrpelr ncblo kx nate etu, rpile kx, ‘Ncblo kc nayrlz sa tqvzpem! Dwalzmamu x rmctiamu nide.’ ");
INSERT INTO ntu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Olvi kcng nzpnu nzdwalzmqng, x sc tztekatrpelr da kcng nayangrlelr. ");
INSERT INTO ntu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Olvi kcng tzngqngung nzrpibzlr mz krkcng tzyrplapxng kx, ‘Kamamu du bagr da scmu kcng tzyangrle, murde kx pnrgrng yrkrtrpe.’ ");
INSERT INTO ntu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","A' krkcng tzyrplapxng nzayzlu-ngrbzlr natqdr kx, ‘Trtingr. Trtakitrpepleu nigu amrlx ngrgu. Murde mz nzyangrlengr nyr, navz nakrlzbzle ma nyz trte ncblo kc nayrlz. Mz nzmu-krde lcde, vznamu x rpwxamu scmu da kx nayangrleamu x nayctrpz du.’ ");
INSERT INTO ntu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","A' mzli kc tzvz-ngrdr mz nzxpengr da lcng, ncblo kc nayrlz sc tqkaputrpem. X olvi kcng tzoliq-angidrng, sc tzvzpebzng badr mz ma nyz trtede, mz nzprtr-krdr mz nzmungr kc etu mz nzyrlzngr lc. ");
INSERT INTO ntu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mz nibrde olvi kcng tzngqngung sc tzkaputrpemqng ma kc. X sc tzrpi-katotrpebzlr kx, ‘Kxetu! Kxetu! Lvxpxm naonrx! X nadwatr-kzpzkr!’ ");
INSERT INTO ntu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","A' rpipxmle brma kx, ‘Trtingr. Trkrlzwxu nimu.’” ");
INSERT INTO ntu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Zbz Jiszs ayrkrpxle natqde, nzrpi-krde kx, “Mz nzmu-krde lcde, naoliqti-zvzamu nzyzlu-krmc. Murde trkrlzwamuu zbq o nabz nepi kx nayzlu-ngrmc.” ");
INSERT INTO ntu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Rpi-mop Jiszs bagr kx, “Mzli kc nayzlu-ngrmc mz nzngini-krnge King, sa na-ayzlu-ngrbo da mz leplz nengeng mz nzvz-nqblq-krde da kx nzalelr. X sa nakabo da kxmrlz mz krkcng tzaleng da kxmrlz. Mzli lc, leplz mz nrlc ka sa na-apulr kxnzawzng mz be lc. “Kzdq mzli kzdq kc kxetu oliq mz nzvz-krde mz nrlarnrlc. A' kqle-kaile kxnzawz nedeng nztqng kx brti drtwrde mz nzaclve-krbzlr dztudeng. ");
INSERT INTO ntu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Aprc-lxblrbzle badr da kx takitrde nidr. Kabzle badr bxli r srlrni kx ngi gol. Kzdq twzle bxli nzlvqn, kzdq bxli li, x kzdq bxli esz'. Zbz sc tqrkalzpem. ");
INSERT INTO ntu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ncblo kc tqrtwz bxli kxnzlvqn, vz x sc tqmwapxpe-ngrde gol kcng. X atatrple bxli nzlvqn mou kx nangi sc kxetu rde. ");
INSERT INTO ntu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","X mz nqmq lcpwz, ncblo kc tqrtwz bxli kxli, atatr-kzple bxli li mou kx narngisc kz kxetu kc. ");
INSERT INTO ntu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","A' ncblo kc tqrtwz bxli kxesz', twzle x yrtzmqle mz drtc' murde mz drtwrde nayc angidr. ");
INSERT INTO ntu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“X mzli kzblepe, kxetu rdr sc tqyzlupem. X kqleleng rtqlrdr mz nzrlwa-krbzlr bade nikeng nzatatrplr mz gol scde. ");
INSERT INTO ntu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ncblo kc tqrtwz bxli kx nzlvqn, vzm bade x rpibzle kx, ‘Kxetu rnge, kame bange bxli nzlvqn, x mwapxpe-ngrne x atatr-mopwc' bxli nzlvqn kx nangi scm.’ ");
INSERT INTO ntu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","X rpibz kxetu kc kx, ‘Mrlzvxitx angidr. Nim kxnzawz kxmrlz kc tqvz-nqblq-zvzle natqnge! X nayrlqpex nim mz nzaclvengr da kxkqlu, murde atutr-angidrq nzwz-krm mz da kxpipz. Vzm x prtr mz nzmungr lc etu murde abrtzlvzx nim.’ ");
INSERT INTO ntu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Zbz ncblo kc tqrtwz bxli kxli, vzm bade x rpibzle kx, ‘Kxetu rnge, aprcme bange bxli li, x mwapxpe-ngrne x atatr-mopwc' bxli li kx nangi scm.’ ");
INSERT INTO ntu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","X kxetu lc rpi-kzpzle bade kx, ‘Mrlztx angidr. Nim kxnzawz kxmrlz! X nayrlqpex nim mz nzaclvengr da kxkqlu, murde atutr-angidrq nzwz-krm mz da kxpipz. Vzm x prtr mz nzmungr lc etu murde abrtzlvzx nim.’ ");
INSERT INTO ntu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Zbz ncblo kc tqrtwz bxli kxesz', vzm bade x rpibzle kx, ‘Kxetu rnge, suti drtwrm kx nike na-ale kxnzawz nemqng nradr naycbz. X atatrpe' gol mz da kx trvzpxpuu mz nzwz-krm. ");
INSERT INTO ntu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mwxlrlvzx gol scm murde ma tqamrbrbo. Mz nzmu-krde lcde, yrtzmqtxbo mz drtc' murde nayc angidr. Gol scm kc tqkame bange dese.’ ");
INSERT INTO ntu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Rpibz kxetu kc bade kx, ‘Nim kxnzawz kxtrka x drtqm sa! Krlzq kx suti drtwrnge kx nike na-ale kxnzawz nengeng nradr naycbz. X atatrpc' gol mz da kx trvzpxpuu mz nzwz-krnge. ");
INSERT INTO ntu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","?A' memule tryrlqtr-ngrpwzmeu gol scnge mz bxng, murde mz nzyzlu-krmc, gol kxmwatipxle nayctrpebz x na-atatr-mople du trau?’ ");
INSERT INTO ntu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Zbz kxetu kc sc tqrpipebzle mz leplz nedeng kx, ‘Kapxbzmu bxli scnge bade x kabzmu mz kxnzawz kc tqryrlq bxli kx nzpnu.’” ");
INSERT INTO ntu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","X Jiszs ayrkrpx-ngrde natqde kx, “Mzli kc nayzlu-ngr-mopwc', doa kx aclve-angidrle da kx kabo bade, sa nartxlvzlzbo nikeng kabo bade, murde dztudeng nakqlu-zlwzng. A' doa kx traclve-angidrleu da kx kabo bade, kxmule-esz' nike scde pipz, sa nakatxpxbo bade. ");
INSERT INTO ntu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","X sa na-apux kxetu kc tqrpibzle mz kxnzawz nedeng kx, ‘Kxnzawz kxtrka elc, rtcpx-ngrnamu yz, mrkc tqtungr nzlo x tzyrningr leplz mz nzetqkr drtqdr x tzmadqti-ngrdr nqngidr mz zngya.’” ");
INSERT INTO ntu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jiszs rpi-mople bagr kx, “Mzli kc ninge Mrlx Leplz nayzlu-ngrmc mz nzngini-krnge King kxluli, sa navzmimc enjrl nengeng amrlx. X sa nawxbuomc mz tron nyznge kxmyalz-esz'ngr mz nzpipx-krbo mz leplz mz nrlc tulvzo nztubq-krdr o nzvz-rbr-krdr. ");
INSERT INTO ntu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Leplz amrlx mz drtc' amrlx mz nrlc tulvzo sa nayrkrmqng bange. X sa na-akipxx nidr mz dzbede kxli, da kc tqwai kxaclve sip nzakipx-krde sip mz gout nedeng. ");
INSERT INTO ntu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mzli lc sa na-amncx leplz kcng tztubqng mz nzobqkr Gct mz nrlarnge kxrtc, x leplz kzbleng mz nrlarnge kxmc. ");
INSERT INTO ntu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Zbz sa narpibo mz leplz kcng tzmncng me matq mz nrlarnge kxrtc kx, ‘Trtenge amrlzle nimu amrlx. Vzmamu x twzamu da kxmrlzting amrlx kcng Gct tqesalz-ngrde nakabzle bamu Heven, mz nzngini-krnge King rmu. Murde oliqti-pnzle da kxmrlz lcng mzli kc tqwz-ngrde nrlc. ");
INSERT INTO ntu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Takitrde nztwz-krmu da kxmrlz lcng murde mzli kc tqbrtale-ngrne rkamamu nange dakxnzng, x mzli kc tqbrlxkzngr drtwrnge rkamamu mqnge lue, x mzli kc tqngini-ngrbo lrnarnrlc bamu adwatramu ninge ma nyzmung, ");
INSERT INTO ntu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","x mzli kc trpnzngr scnge lrpz rkamamu bange lrpz, x mzli kc tqyagox-ngrne aclveamu ninge, x mzli kc tqmncpx-ngrmc mz presin oklatimamu ninge.’ ");
INSERT INTO ntu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Zbz leplz kxnztubqng sa narpimlr bange kx, ‘?Kxetu, mzli kznike mc-ngrgr nzbrtale-krm x rkabzkr nam dakxnzng? ?X mzli kznike mc-ngrgr nzbrlxkzkr drtwrm x rkabzkr mqm lue? ");
INSERT INTO ntu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","?X mzli kznike mc-ngrgr nzngini-krm lrnarnrlc x adwatrkr nim ma nyzgrng? ?X mzli kznike mc-ngrgr trpnzngr scm lrpz x rkabzkr scm? ");
INSERT INTO ntu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","?X mzli kznike mc-ngrgr nzyagox-krm o nzmncpx-krme mz presin x oklatibzkr nim?’ ");
INSERT INTO ntu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","X sa na-ayzlu-ngrbo natqdr kx, ‘Da angidr lc napibo bamu. Mzli kznike okatr-ngrnamu leplz nengeng, kxmule-esz' nidr leplz txneng, mz drtwrnge okatrpeamu ninge.’ ");
INSERT INTO ntu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“X mzli lc sa napi-kzpo mz leplz kcng tzmncng mz nrlarnge kxmc kx, ‘Nimu kcng tzmnclzbzng mz zngya ngr drtwr Gct, vzpeamu. X vznamu mz nyr ngr Hxl kc tqngctx alo, tqoliqti Gct mz nzayrplapx-krde Setzn badr drka' nedeng amrlx. ");
INSERT INTO ntu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nzayrplapxngr lc takitrde nimu murde mzli kc tqbrtale-ngrne tr-rkapwa'muu nange dakxnzng, x mzli kc tqbrlxkzngr drtwrnge tr-rkapwa'muu mqnge lue, ");
INSERT INTO ntu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","x mzli kc tqngini-ngrbo lrnarnrlc bamu tradwatrwamuu ninge ma nyzmung, x mzli kc trpnzngr scnge lrpz tr-rkapwa'muu bange lrpz, x mzli kc tqyagox-ngrne x tqmncpx-ngrmc mz presin traclvewamuu ninge.’ ");
INSERT INTO ntu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Zbz leplz lcng sa narpimlr bange kx, ‘?Kxetu, mzli kznike mc-ngrgr nzbrtale-krm x nzbrlxkzkr drtwrm, x nzngini-krm lrnarnrlc, x trpnzngr scm lrpz, x nzyagox-krm x nzmncpx-krme mz presin x trokatrkru nim?’ ");
INSERT INTO ntu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","X sa na-ayzlu-ngrbo natqdr kx, ‘Da angidr lc napibo bamu. Mzli kznike pxtxpx-ngrnamu nzokatr-krmu leplz, kxmule-esz' nidr leplz txneng, mz drtwrnge pxtxpx-ngrnamu nzokatr-krmu ninge.’ ");
INSERT INTO ntu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Zbz leplz lcng sa naprtrng mz Hxl mz nzayrplapxngr kc tqyctx alo. A' kxnztubqng sa naprtrng Heven mz nzlungr kxboi.” ");
INSERT INTO ntu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Mzli kc Jiszs tqayrkrpxpe-ngrde nzalvztrngr lcng, rpimle bagr kx, ");
INSERT INTO ntu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Krlzamu kx ycbep zbq lang li x zbq kxtr kc tzrpibz Nzamyangr sc tqkaputrpem. Mzli lc ninge Mrlx Leplz sa nalolvz x natqlvztr ninge mz kros.” ");
INSERT INTO ntu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kxnzetu rdr pris x lrtzlvzng r lr Jiu nzyrlwr-lxblrng mz ma kc etu nyz Kaefzs, kc tqngi Nardr Pris. ");
INSERT INTO ntu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nzyrlqlr drtwr ngr nzlolvz-kapq-krdr Jiszs x nanibqlr. ");
INSERT INTO ntu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","A' nzrpilr kx, “Bzkq lolvzku nide mz nabz zbq kcng tqetung, murde ma tqrkatrpzku mz leplz kxkqlu nzotablrngr.” ");
INSERT INTO ntu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jiszs mnc mztea Betzni mz ma nyz kzdq kc ncblo drtqde Saemon. Ncblo lc amrlz Jiszs mzli kc mz lepz kx dwatibzle nide. ");
INSERT INTO ntu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mzli kc tqmungr Jiszs ma lcde, dwatrpz kc olvz. Twzbzle kc botol ngr tolo kx narncbr ngrde lqlwx x mnrte mrlz zlwz. X sc tqaelupebzle nar Jiszs mz nzarmyalz-krde nide. ");
INSERT INTO ntu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kx mckr da lc, drtwrgr ngya, sc tqrpi-etrpekr kx, “?Nike olvz lc tqayrkrtitx-ngrde tolo lc narncbr ngrde lqlwx? ");
INSERT INTO ntu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Takitrde nzamwatxngr mz narncbr kc tqlqlwx, x nakabz trau ngrde mz nzokatrngr leplz kxtrnzrngiscung!” ");
INSERT INTO ntu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","A' rpim Jiszs bagr kx, “Bzkq drtwrmu lctrpz bade. ?Memule tqrpi-ngrnamu narpwa'-ngrbzmu da lc tqalele? Da kxmrlz-esz'ngr lc tqalemle bange. ");
INSERT INTO ntu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Doa kx trnzrngiscung mnc-zvzamu badr, a' ninge trnamnc-zvzpou bamu. ");
INSERT INTO ntu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Aelule ninge tolo, mz nzoliqti-krbzle nrkrdrtqnge mzli kc nabz-ngrne x nzryrtzmqngr ninge kc ate. ");
INSERT INTO ntu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Napi-angidrbo bamu, drlve keng nzyapwxtipxngr Nrpakxmrlz lc mrka mz nrlc, da kxmrlz lc tqalem olvz lc bange sa napipx kz, mz nzrdctipxngr drtwr nide mz nrlc tulvzo.” ");
INSERT INTO ntu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Zbz Judzs Iskariot, kzdq nigr kcng nzpnu-esz'-nrade-li (12), vzbz mz kxnzetu rdr pris. ");
INSERT INTO ntu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Rpibzle badr kx, “?Nakamamu bange natqlvr mz nzaprc-krbo Jiszs bamu mz nzlolvz-krmu nide?” X sc tzrlwxpxpebzlr bade trau kx ngi silvz nzpnu-tq (30). ");
INSERT INTO ntu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Zbz Judzs sc tqrtangrtipele mzli kxmrlz kx na-aprc-ngrbzle Jiszs badr. ");
INSERT INTO ntu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mz zbq kc kai ngr Nzmulvzngr Bret kx Trpnzngr Yisti Ngrde, veatibzkr mz Jiszs kx, “?Myx me naoliqti-ngrbzkr dakxnzng kx nangq mz Nzamyangr?” ");
INSERT INTO ntu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jiszs rpile kx navzbzng mz kzdq ncblo mzteadau x narpibzlr bade kx, “Kxakrlz ngrgr rpibzle bam kx, ‘Mzli kc tqmcpx Gct mz nzbz-krnge ycpe pipz nzkaputr-krmle. X sa namulvzkr badr ncblo nengeng Nzamyangr mz ma nyzm.’” ");
INSERT INTO ntu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kzdung kztegrng nzalelr da kc tqpibzle badr mz nzoliqti-krdr Nzamyangr. ");
INSERT INTO ntu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kx krlzbzle kc milzpq, Jiszs x nigr kcng nzpnu-esz'-nrade-li (12) sc tqwxbuopekr mz nzmu-krgr. ");
INSERT INTO ntu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","X mzli kc tqmupe-ngrgr, rpim Jiszs bagr kx, “Napi-angidrbo bamu kx kzdq nimu esz' sa na-amwabzle ninge mz enqmi rngeng.” ");
INSERT INTO ntu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kx xlrbzkr le, drtwrgr vztx pnz. X sc tqycmne-esz'-lxblrpebzkr bade, tqtulzm kc nigr tqrpibzle kx, “?Kxetu, trnipwc'u la tqpiq kx?” ");
INSERT INTO ntu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ayzlu-ngrm Jiszs natqgr kx, “Mrlx kc naleole bret nade mz dis lc, tqwxbutrp bange, sa na-amwale ninge. ");
INSERT INTO ntu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ninge Mrlx Leplz nabzx navz-nqblqle Nzryrngrkxtr. A' agrmplz ncblo la na-amwale ninge. Murde takitrde bzkq mzte nzmc pnz, murde nzayrplapxngr nide kalr sa namyatxpx-esz'ngr.” ");
INSERT INTO ntu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Zbz Judzs kc na-amwale nide, rpibzle bade kx, “?Kxakrlz, trnipwc'u la tqpiq kx?” Jiszs ayzlu-ngrbzle natqde kx, “Dela tqplzpxpeq.” ");
INSERT INTO ntu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mzli kc tqmube-ngrgr, Jiszs kalzmle bret. Awitx-ngrbzle mz Gct, lopxile, kamle bagr x rpimle kx, “Twzamu x ngqnamu murde krlc ncvr drtqnge.” ");
INSERT INTO ntu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Zbz glqlzmle kap. Awitx-ngrbzle mz Gct, kamle bagr x rpimle bagr kx, “Mnqamu amrlx ngrmu. ");
INSERT INTO ntu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Murde krlc mepyr rnge kc tqyrlepx-ngrde leplz kxkqlu, mz Nzesz'tikr Drtwr Gct badr leplz, mz nzipqpx-krde alwx ngrdr. ");
INSERT INTO ntu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Da zpwxtx, trpengr nzrmnq-krnge waen, navz nakrlzbzle mzli kc narmnq-lxblr-ngrgu waen kxmrna mz nrlc kxmrna kc na-aclve Trtenge kalr.” ");
INSERT INTO ntu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mz nibrde ngrtx-ngrgr kc Sam ngr nzrglqpxngr x sc tqrlaszpekr mzteadau, tqvzdzpekr mz Newz ngr Nc Olivi. ");
INSERT INTO ntu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Zbz rpim Jiszs bagr kx, “Koma mz nrlckxbq mzli kc nalolvzngr ninge nimu amrlx ngrmu sa nadwaszamu ninge. X krlc sa na-atutrle Nzryrngrkxtr mz nzrpi-krde kx, ‘Ninge Yawe, sa nanibqx kxaclve sip, x sip nedeng sa na-akiting nrlc.’ ");
INSERT INTO ntu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","A' mz nibr nzatulz-moungr ninge mz nzbzngr, sa nartwayz-kaipo Gzlili x navz-kzpzmu mz nzrmcti-lzbq-krgu elr.” ");
INSERT INTO ntu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","A' Pita rpibzle kx, “Trtxpnzngr nzdwasz-krnge nim mzli kc nalolvzngr nim, kxmule-esz' kztenge lcng nzdwang amrlx!” ");
INSERT INTO ntu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jiszs rpibzle mz Pita kx, “Napi-angidrbo bam, koma mz nrlckxbq, nzwrde natq nzrpi-krm trkrlzwq ninge x kio kc tqkya' ate.” ");
INSERT INTO ntu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","A' Pita rpi-kzpzle bade kx, “Trtxpnzngr nzrpi-krnge kx trkrlzwxu nim! Kxmule-esz' nzabzminge nim!” X pi-kzpzkr nigr kztede kcng amrlx. ");
INSERT INTO ntu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Zbz vzokr badr Jiszs krlzbzkr kzdq nrlc drtqde Getsemzni. Jiszs rpimle bagr kx, “Wxbupwzmu mrka mzli kc nakrka'-ngrne mrkc.” ");
INSERT INTO ntu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Vzmile Pita, x mrlx Sebedi kcng nzling. Mzli lc nabz Jiszs talvzope x mrlepupe-ngrde nzvzkr drtwrde. ");
INSERT INTO ntu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Sc tqrpipebzle mz rtqlrdr kx, “Nzvzkr drtwrnge etutx-zlwzpe x rpile nanibqle ninge. Mncpwzmu mrka x aukzpwzmu.” ");
INSERT INTO ntu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Vzszpxle nidr kxpipz x sc tqrtco-lzbqpengr mz drtc' mz nzkrka'-krde. Rpile kx, “Trtenge, nzmu kx tqrlrpx-ngrnle, trsutiu drtwrnge nzrlrpx-lzbq-krnge mz nzetqkr drtqnge x nzbzngr. A' bzkq vz-nqblqq me pnz drtwrnge, a' nangi zvz me pnz drtwrm.” ");
INSERT INTO ntu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mz nibr nzkrka'-krde, yzlum mz ncblo kcng nztq, a' sa tzmwing. Sc tqrpiopebzle mz Pita kx, “?Rblx-zlwzbz bam nzobq-krm ninge mz nabz nepi kxesz'? ");
INSERT INTO ntu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Aukzpwzmu x krka'namu murde natu-amqngiamu mz nzatalzngr. Murde kxmule-esz' suti drtwrmu nzalengr da kxtubq, a' nzxplr-krmu esz'-krmu trtakitrdeu.” ");
INSERT INTO ntu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Zbz Jiszs vz mou mz nzkrka'-krde nzwrde krali, x rpi-moule kx, “Trtenge, nzmu kx tqpnz drtwrm nzrlrpx-lzbq-krnge mz nzetqkr drtqnge x nzbzngr, kxnamupele lape!” ");
INSERT INTO ntu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kx yzlu-mople kc badr, mcle kx nzmwipe-moung rtqlrdr, murde mztr one mwi. ");
INSERT INTO ntu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Zbz Jiszs yzlu mou mz nzkrka'-krde nzwrde kratq. X pi-moule natqde kcng pwz. ");
INSERT INTO ntu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","X kx yzlu-mople badr, mz nzyrkrpx-krbz nzkrka'-krde, mcle sc tzmwibeng. Sc tqrpipebzle kx, “Elr! Nimu ka tqmwibeamu. A' mzli kc tqpi-pnzbo bamu sc tqkaputrpem. Obqbzmu, ninge Mrlx Leplz se na-aprcpebz mz zmatq ngr ncblo kx nzaleng alwx. ");
INSERT INTO ntu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tulzamu, navzbzku narmcti-lzbqku badr. Obqbzmu, ncblo kc tqamwale ninge sa tqvzpem.” ");
INSERT INTO ntu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mzli kc Jiszs tqycmnebe-ngrde, Judzs sc tqkaputrpebz. Nide kzdq nigr kcng nzpnu-esz'-nrade-li (12), x vz-nqblqm zbo ngr ncblo kxetu. Nzatwzlrpx-ngrmqng kxnzetu rdr pris x lrtzlvzng. Nzrmaleng dalr nzotangr, bz x toki r vea. ");
INSERT INTO ntu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judzs rka-kaipz badr rkx mz nzrpi-krbzle kx, “Krkc natcngix kcma, nide kc nalolvzamu.” ");
INSERT INTO ntu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Zbz Judzs vzm mz Jiszs. Rpibzle kx, “Nim la, Kxakrlz!” x sc tqtcngipebzle mqde. ");
INSERT INTO ntu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jiszs ayzlu-ngrbzle natqde kx, “Mzlenge, aniti nike nartrngztibzme.” Zbz ncblo kcng sc tzlolvzpelr nide. ");
INSERT INTO ntu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","A' kzdq nigr kx tu mrlcde yrlqbzle toki r vea scde x lakitxpxbzle kzdq nradrtq kxnzawz-nrbalq ne Nardr Pris. ");
INSERT INTO ntu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","A' rpibz Jiszs kx, “Toki r vea scm alvco mou mz bxli rde. Murde krkcng tzotang mz toki r vea, sa na-abz-kzng mz toki r vea. ");
INSERT INTO ntu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","?Trkrlzwamuu kx nzmu narlxtibo mz Trtenge nzokatr-krde ninge, mzli lcpwz sa na-atwzlr-ngrmle ami ngr enjrl kx myaszpxle nzpnu-esz'-nrade-li (12) mz nztu-ngalelvz-krdr ninge? ");
INSERT INTO ntu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","A' nzmu na-alex le, Nzryrngrkxtr kcng tzrpilr kx da lc nakaputrp sc trna-atutrpeung.” ");
INSERT INTO ntu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Rpibz Jiszs mz zbo ngr ncblo kcng kx, “?Memule tqrtwz-ngrmamu bz x toki r vea mz nzlolvz-krmu ninge? ?Opxm kx ninge kxrmailz ncblo mz nzrnzlvzongr zmatq ngr gzpman? Mz zbq kang kqlu alvztr-zvz-ngrne Mangr-nzangiongr. ?Memule trlolvz-ngrwamuu ninge elr? ");
INSERT INTO ntu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","A' krlc tqmusr-ngrnamule lc, na-angidale natq profet kcng mz Nzryrngrkxtr.” Zbz nigr amrlx sc tqdwaszpekr nide. ");
INSERT INTO ntu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kx nzlolvzlr kc Jiszs nzvzmilr mz ma nyz Kaefzs, kc tqngi Nardr Pris, mrkc tzyrlwrpx-lxblr-ngrdr lrtzlvzng x kxnzalvztrng mz Lou sc Mosis. ");
INSERT INTO ntu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita kc tqma-nqblqnebzle nidr. X dwatr-kzpz mz makoa ngr ma kc, sc tzwxbu-lxblrpeng badr pulis ngr Mangr-nzangiongr mz nzmc-krde nike naprtz. ");
INSERT INTO ntu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kxnzetu rdr pris x Kansrl nzrtangrng ncblo kxnzpokiang kx napilr da kx vz-rbrti Jiszs, murde nanibqlr nide. ");
INSERT INTO ntu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","A' trpnzngr kxnzrmctilr, murde kxmule-esz' leplz nzkqlung nzpokiatitrlr Jiszs, a' nzryapwx-krdr tresz'tiu. Zbz ncblo nzling nztulzmqng. ");
INSERT INTO ntu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Nzrpibzlr mz Kansrl kc kx, “Xlrkr nzrpikr Jiszs kx, ‘Sa na-awxtxobo Mangr-nzangiongr Gct, x nayctitxde zbq nali x zbq kratq dekc nawzti-mou-ngrnele.’” ");
INSERT INTO ntu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Zbz Nardr Pris tulzm, sc tqveapebz mz Jiszs kx, “?Myx kxmule, trpnzngr natq kx na-ayzlu-ngrbzme natq ncblo lcng?” ");
INSERT INTO ntu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","A' Jiszs anabu txpwz. Zbz Nardr Pris rpi-mopwzle kx, “Mz drtq Gct kc tqlu, napi-angidrme bagr. ?Ngini-angidrm Kxnzmcpx? ?Nim Mrlx Gct, o trtingr?” ");
INSERT INTO ntu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ayzlu-ngrbz Jiszs natqde kx, “Eu, ninge mrlxde. X napibo bamu kx sa namcamu ninge, Mrlx Leplz, nzwxbu-krnge me matq esz'ngr mz nrlar Gct kxrtc. X ninge la nayzlu-mopwc' kalr mz nabz dcbz ngr bongavz.” ");
INSERT INTO ntu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Zbz Nardr Pris sc tqpesali-zlwzpele nzkq scde, x sc tqrpipebzle mz Kansrl kx, “Pivxipele Gct! Trpengr nzrtangr-krgu ncblo kx narpim bagu da kx vz-rbrti mrlx lc! Murde sa tqxlrpebzmu natq kx pivxiti-ngrde Gct! ");
INSERT INTO ntu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","?Nike aotitrpz drtwrmu mz mrlx lc?” Nzrpibz ncblo kcng mz Kansrl kx, “Vz-rbrtx-atwrnrngr x takitxtrpwzle nzbz-krde.” ");
INSERT INTO ntu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Zbz kzdung nidr nzbyatitrpzlr mzte, x nztzlr mz mqdr. X kzdung nidr nzviplatilr mz mqdr. ");
INSERT INTO ntu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Tzrpibzlr kx, “Mz nzngini-krm kc Kxnzmcpx, pim ena bagr krkc tqtzle nim.” ");
INSERT INTO ntu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mzli kc Pita tqmnclz-ngrmle mz makoa ngr ma kc, kzdq olvz kxnzawz vzm mrkc tqwxbu-ngrde. X sc tqrpipebzle bade kx, “Nim dq kz kx mnctrpz mz Jiszs kc Gzlili.” ");
INSERT INTO ntu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","A' Pita pokiatxbz, rpibzle kx, “Trkrlzwxu da la tqycmnetr-ngrn.” ");
INSERT INTO ntu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Zbz tulzm x sc tqtutrpe mz naonrx. Kzdq kz olvz kx mcle Pita, sc tqrpipebzle mz leplz kxnztung mrkc kx, “Mrlx lc nide dq kz ncblo ne Jiszs kc Naszret.” ");
INSERT INTO ntu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Zbz Pita pokia mou. Rpibzle kx, “Naesalzbo bamu kx da zpwx lc tqpibo bamu. Trkrlzwxu ncblo la tqpimamu bange.” ");
INSERT INTO ntu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Zbz mzli trboiu kzdung leplz kx nztung mrkc nzvzmqng mz Pita nzrpi-kzpzlr kx, “Krlztx-angidrkr kx nim kzdq nidr, murde rblx nzyrlq-kapq-krm nzngini-krm lr Gzlili.” ");
INSERT INTO ntu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Zbz rpibz Pita kx, “Naesalzbo bamu kx nangi bongavz, da zpwx lc tqpibo bamu. Trkrlzwxu ncblo la. Nzmu kx tqpokiabo na-ayrplapx zvz Gct ninge.” X mzli kcpwz kio kc tqkya'pe. ");
INSERT INTO ntu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","X sc tqdcpxpe mz drtwr Pita nzrpi-krbz Jiszs bade kx, “Napibo bam, nzwrde natq nzrpi-krm trkrlzwq ninge, x kio kc tqkya' ate.” Zbz Pita sc tqvzpxpe, x tqbztipele nzyrningr. ");
INSERT INTO ntu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mzli kc mz nourla kc topwz, kxnzetu rdr pris x lrtzlvzng nzycmne-lxblrng x drtwrdr esz'ti kx Jiszs nabz. ");
INSERT INTO ntu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nzpetxbzlr mqde x sc tzvzmipelr tzaprcpebzlr mz mq Pcntizs Paelzt, lr Rom kc tqaclvele Judiz Provins. ");
INSERT INTO ntu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judzs kc tqamwabzle Jiszs mz enqmi rdeng, kx mcle kx sa nanibqlr Jiszs, drtwrde vztx zlwz. X twz-mopwzle trau kcng nzpnu-tq (30) tqngi silvz mz kxnzetu rdr pris x lrtzlvzng mz Mangr-nzangiongr. ");
INSERT INTO ntu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","X rpibzle badr kx, “Alex alwx kxetu zlwz mz nzamwatx-krbo bamu ncblo kc trvz-rbru. X mzli ka sa nabzpe-ngrde da kc tqalex.” Nzayzlu-ngrbzlr natqde kx, “Trpnzngr scgr da kx yctrpz mz da la tqpiq. Krla me pnz drtwrm.” ");
INSERT INTO ntu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Zbz Judzs rtctxo-ngrde trau kcng mz Mangr-nzangiongr, x sc tqdwapxpe. Vz x sc tqado-lzbqpe. ");
INSERT INTO ntu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kxnzetu rdr pris nzkalzmlr trau kcng, x nzrpilr kx, “Lou scgu tr-rlrpx-ngrdeu nzyrlqtr-krgu trau lcng mz Mangr-nzangiongr. Murde trau lc ngi dalr nzbzkr ncblo.” ");
INSERT INTO ntu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Zbz sc tzaotipe drtwrdr nzxpengr drtc' nyz ncblo kc tqrwzngr pct mz drtc', kx nangi me nzyrtzmqngr lr mrkzbleng. ");
INSERT INTO ntu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","A' mzbq ka nzrpibz drtc' kx yrleongr mepyr, murde nzxpeng mz trau kx ngi dalr nzbzkr ncblo. ");
INSERT INTO ntu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","X krlc atutrle natq profet mz Nzryrngrkxtr, mz nzrpi-krde kx, “Nztwzlr trau kcng nzpnu-tq (30) kx ngi silvz, murde krlc narncbr kx nzyrlq lr Israel nzxpengr nide. ");
INSERT INTO ntu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","X nzxpelr drtc' nyz ncblo kc tqrwzngr pct mz drtc'. Da lc vz-nqblqle natq kc tqkam Gct bange.” ");
INSERT INTO ntu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Mzli lc, Jiszs sc tqaycmnetrpe Paelzt, lr Rom kc tqngi gavzna, mz nzvea-krbzle bade kx, “?Myx kxmule, nim king r lr Jiu?” Ayzlu-ngrbz Jiszs natqde kx, “Sa tqplzpxpeq kx ninge.” ");
INSERT INTO ntu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","A' mzli kc tzrpi-ngrbz kxnzetu rdr pris x lrtzlvzng kx vz-rbr, trayzlupwzleu natqdr. ");
INSERT INTO ntu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Zbz Paelzt sc tqveape-mopwz bade kx, “?Trxlrwq da kxkqlu kcng tzrpilr kx oti-rbrbzme?” ");
INSERT INTO ntu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","A' Jiszs sc tqvz zvz trnzycmne-krdeu. X trpnzngr natq kxesz' kx ayzlu-ngrbzle natqdr. X Paelzt sc tqkctitxpxpele nzanabu-krde. ");
INSERT INTO ntu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mz Nzamyangr amrlx, Paelzt aprpxmle kzdq doa lr Jiu kx mnc mz presin kx nzrlxtitrpz lr Jerusalem. ");
INSERT INTO ntu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mzli lc kzdq ncblo kxayo drtqde Barabas mnc mz presin. ");
INSERT INTO ntu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mzli kc tzyrlwrngr leplz kxkqlu, Paelzt rveabz badr kx, “?Neke suti drtwrmu narlr-ngrbo bamu, Barabas o Jiszs kc nzrpibz Kxnzmcpx?” ");
INSERT INTO ntu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Krlc tqkxmu nzycmne-krbz Paelzt lc murde krlzle kx Jiszs nzaprcpebz kxnzetu rdr pris bade mz nzdobulvz-krdr nzsuti-zlwzkr drtwr leplz nide. ");
INSERT INTO ntu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mzli kc Paelzt tqwxbuo-ngrbeple mrkc tzrpipxngr nztubqkr doa o trtingr, olvz rde atwzlr-ngrbzle nrpa. Rpibzle kx, “Bzkq da kx nawaisr-ngrn ncblo la. Murde trpnzngr da kx ale-rbrle. X mwiblex nide kau x atalvzo-zlwzmle drtwrnge.” ");
INSERT INTO ntu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","A' kxnzetu rdr pris nzapqtrpzlr drtwr zbo ngr leplz kcng kx narlxti-alzubzlr mz Paelzt Barabas, x nanibqle Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Paelzt rveabz mz zbo ngr leplz kcng kx, “?Neke mz mrlx lcng li kx suti drtwrmu narlr-ngrbo bamu?” Nzrpibzlr bade kx, “Barabas!” ");
INSERT INTO ntu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Zbz Paelzt vea-mopwz badr kx, “?Nike nawaisr-ngrne Jiszs kc tzrpibz Kxnzmcpx?” A' nzrpibzlr kx, “Natqlvztr mz kros!” ");
INSERT INTO ntu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Rpi-mopwz Paelzt kx, “?A' memule? ?Da kxtrka kznike alele?” A' sc tznemi-katobzlr kx, “Natqlvztr mz kros!” ");
INSERT INTO ntu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Paelzt krlzpele kx rblxpebz bade nztekqtr-krbzle drtwrdr, x ycpe pipz nzotablrkr leplz kxkqlu mz nzngyatikr drtwrdr nide mz nzycmne-krde. Zbz otile lue, sc tqycpqpele mqde, x rpibzle badr kx, “Krlc rkx kx aelwapx-ngrde kx nzbzkr ncblo lc trtutrpuu bange. A' nzbz-krde tutrpz bamu.” ");
INSERT INTO ntu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","X leplz lcng nzayzlu-ngrbzlr natqde kx, “Nzbz-krde natutrp bagr x doa negrng.” ");
INSERT INTO ntu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Zbz sc tqrlrpe-ngrbzle Barabas badr. X rpibzle mz ncblo ngr vea nedeng kx naiklalr Jiszs x natqlvztrlr nide mz kros. ");
INSERT INTO ntu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kzdung ncblo ngr vea nzvzmitrlr Jiszs mz nabxbz ngr ma kxetu nyz Paelzt, x sc tzkqlepelr ncblo ngr vea kztedrng amrlx. ");
INSERT INTO ntu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nzavotxobzlr nzkq scdeng, x sc tzakqpelr mz nzkq kxpc. ");
INSERT INTO ntu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","X nzngrlelr kc nqvi nzku ngi kraon scde, nzalaobzlr mz narde. Nzyrlqtrpzlr kc mz mqde dapunc sc kxrmailz. Zbz sc tzrweopebzng zpr bade mz nzapusr-krdr nide king. Sc tzxtrngalvztitrpelr x tzmrgepe-ngrdr nide kx, “Nim la, King r lr Jiu! Nzmnc-krm naboi.” ");
INSERT INTO ntu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nzbyatilr nide x nzkatxpxbzlr dapunc kc x nztakrti-ngrbzlr narde nzwrde kqlu. ");
INSERT INTO ntu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mz nibrde sc tzavopxpebzlr nzkq kc pc x nzavoo-mopwzlr nzkq scde. X sc tzvzmipxpelr mz nzrtqlvztrngr nide mz kros. ");
INSERT INTO ntu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kx nzprpxbzlr kc mz nrlarde kx yz ngr mzteadau, sc tzrmctipelr kc ncblo drtqde Saemon. Nide dalr taon kxetu Saerin, mrkc Afrika. X sc tzrtulrtrpe-ngrbz ncblo ngr vea kcng bade nzglq-krbzle kros, murde drtq Jiszs mewetx-zlwzpe. ");
INSERT INTO ntu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ncblo ngr vea kcng nzvzmilr Jiszs mz kzdq newz drtqde Gclgata, drtwr ngrde Bekrlz, murde nzobq-krde apule bekrlz. ");
INSERT INTO ntu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nzkabzlr bade kc waen kx ycmi luekxpiz nzrpibz mrr. Abztrle kxpipz, a' trmnq-pnzleu. ");
INSERT INTO ntu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Zbz sc tztqlvztrpelr nide mz kros. X nctq lrpz scdeng nzayrleti ncblo ngr vea kcng daes. ");
INSERT INTO ntu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Zbz ncblo ngr vea kcng sc tzwxbupeng x tzaukztipwzlr nide. ");
INSERT INTO ntu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mz nzaelwapxngr da kc tqbzngr Jiszs, nzyrtr kcng natq mz kzdq da x nztqlvztr mrkc tqyc-zbzlz narde. Nzyr kx, Krlc Jiszs, King r Lr Jiu. ");
INSERT INTO ntu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","X nztqlvztr kz mz kros kzbleng ncblo nzling kxnzpnang da taplxsr nrlar Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mzli kc tqdoo-ngrm Jiszs mz kros, kzdung leplz kx nzvzkimlr mrlcde nzrpitilzbzng natq kxtrkating bade. Nzycngrlrlzbzlr nardr. ");
INSERT INTO ntu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","X nzrpilzbzlr kx, “Kx tqrpiq kx matq-esz'ngrn mz nzawxo-krm Mangr-nzangiongr x wzti-mowq mz zbq kxtqtxu, e vzom mz kros la mz nzarlapx-lzbq-krm! Krlzq nzale-krmle nzmu nangi-zwpxm mrlx Gct!” ");
INSERT INTO ntu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mz nzmu-krde lcdepwz, kxnzetu rdr pris x kxnzalvztrng mz Lou sc Mosis, x lrtzlvzng nzxtrnga-kz-ngrdr Jiszs mz mzlirdr. ");
INSERT INTO ntu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Nzrpilr kx, “Krlzle nzarlapx-krde kzdu-kzng leplz, a' trkrlzleu nzarlapx-lzbq-krde. Nzmu kx tqngini-angidrle King r Israel, navzopem mz kros mzli ka x sc tqlxngitipeku nide. ");
INSERT INTO ntu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Drtwrde abrtrpzle mz Gct, x rpile kx nide mrlx Gct. Namcku ena na-arlapxkr Gct nide mzli ka, nzmu mrlzti-zlwzle nide.” ");
INSERT INTO ntu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","X mz nqmq lcpwz, ncblo kcng nzling tzpnang da tzdo-kzng mz kros, nzrpiti-kzpzng natq kxtrka bade. ");
INSERT INTO ntu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mzli kc tqtavauo-ngrm nepi, nzlo akqlvztx-pnzle nrlc tulvzo, krlzbzle nabznepi kc tqtq. ");
INSERT INTO ntu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","X mzli lcpwz, Jiszs sc tqetumipe natqde, nzrpi-krde kx, “Eli! Eli! ?Lama sabaktani?” Drtwr ngrde kx, “Gct! Gct o! ?Memule tqvzszpe-ngrn ninge?” ");
INSERT INTO ntu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kzdung leplz mrkc nzxlr-rbrbzlr natq Jiszs, x sc tzrpipelr kx, “?Xlrbzmu? Kqlepele Profet Elaeja kc bqnc mz nzokatr-krde nide!” ");
INSERT INTO ntu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kzdq nidr otile kc kzdq da, petrle mz nounc, leole mz waen kxrkx, x sc tqglalzpebzle x katrpzle mz nao Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","A' kzdung kz leplz nzrpibzlr kx, “Na-aenzliku ena, namcku nzvz-krm Elaeja mz nzarlapx-krde nide.” ");
INSERT INTO ntu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Zbz Jiszs netxpx-kato mou x sc tqrlrpe-ngrbzle mqngrde mz Gct. ");
INSERT INTO ntu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","X mzli lcpwz, lotqbr kc tqdo Mrkc Tqtr Mangr-nzangiongr nzpesalikiomle wq tatxo mz noude, ncte li. X mzli lc nengq kxetu vzm x rplz kxetuting nzbxpizting. ");
INSERT INTO ntu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","X butqbr x gq kcng tzyrbqpx-ngrm namz nzlvxpx-lzbqng x nrkrdrtq leplz neng Gct kxkqlu nztulz-mopqng mz nzbzngr. ");
INSERT INTO ntu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nzrlaszlr butqbr kcng x mz nibr nztulz-mou-krm Jiszs mz nzbzngr, sc tzvztrpeng mzteadau kxtr Jerusalem, x nzmc leplz kxnzkqlung nidr elr. ");
INSERT INTO ntu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kzdq kxetu kx aclvele dzbe ncblo ngr vea ngr Rom kc trtqki-esz' (100) tulzbz mz nou kros badr kzdung kz ncblo ngr vea mz nzaukzlz-krbzlr mz Jiszs. Kxnzmclr nengq x da lcng tqprtzting, nzmwxlr-zlwz-ngrdr. X sc tzrpipelr kx, “Da zpwxtx, ncblo ka nide Mrlx Gct.” ");
INSERT INTO ntu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kzdung olvz nzmnc-kzng mrlcde, sc tztumqng rlru, x nzmclr da kcng tzwaisrngr Jiszs. Olvz lcng nzvzkimlr Gzlili x nzvzdzng badr Jiszs Jerusalem mz nzokatr-krdr nide. ");
INSERT INTO ntu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kzdung olvz lcdeng nidr seleng, Mxri kc Makdala, Mxri lxe Jemes x Josip, x lxe Jemes x Jon. ");
INSERT INTO ntu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mzli kc tqycpe pipz nztaokr nepi x Sabat kc tqyzutrpe, kzdq bcnyr vzm. Nide ncblo ngr taon Arimatia, drtqde Josip x lxngitile Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Vzbz mz Paelzt x sc tqrlxtipebzle nrkrdrtq Jiszs, kx nayrtzmqle. X sc tqpipebz Paelzt mz ncblo nedeng kx narlr-ngrbzlr bade. ");
INSERT INTO ntu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Zbz Josip glqle nrkrdrtq Jiszs x sc tqbxtipele lrpz kxprki. ");
INSERT INTO ntu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","X sc tqyrlqtrpele namz ngr Jiszs mz gq lr kxnzbz nyzde, kc tqekqtitr-atele mz butqbr. Alqlitrpzle kc rplz kxetu kx na-apqbrtr-ngrbzle naonrx ngrde, x sc tqvzpe. ");
INSERT INTO ntu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mxri kc Makdala x kzdq kz Mxri nzwxbutrpzng yz mz butqbr kc, x nzmclr da amrlx kcng tqaleting Josip. ");
INSERT INTO ntu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Zbq kc navz-mop ngi Sabat. X kxnzetu rdr pris x Farzsi nzvzbzng mz Paelzt. ");
INSERT INTO ntu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Nzrpibzlr bade kx, “Kxetu, dcpx mz drtwrgr mzli kc tqlubengr blzpokia kc, rpile kx, ‘Zbq naotx natq, x ninge kc tqlupe-mopwc'.’ ");
INSERT INTO ntu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mz nzmu-krde lcde, kapx natqm kx navz du ncblo ngr vea nemqng mz nzaukz-krdr mrkc tzyrtzmqngr nide, nakrlz-zpwxbzle nzyrkrpxkr zbq kcng tq. Murde ncblo nedeng ma tzvzmqng, tzpnatipelr namz ngrde, x sc tzpipebzlr mz leplz kx lupe mou. Nzpokiangr lc sa naetutx zlwz namyaszpxle nzpokiangr kx nide Kxnzmcpx.” ");
INSERT INTO ntu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Rpibz Paelzt badr kx, “Vzmiamu du ncblo ngr vea nengeng x namctr mz nzaukz-krdr kx trpnzngr kx vznebz mrlcde.” ");
INSERT INTO ntu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Zbz sc tzvzpeng x tzamqngitrpelr butqbr mz nzamnc-krdr ncblo ngr vea kcng mz nzaukz-krdr elr, x mz nzayrlenitrngr kadol mrkc tqmwitrngr rplz kc mz butqbr kc. Murde nakrlz-ngrdr kx rlvxtrpe kc naonrx mz nzmrglckr dalr kadol kc. ");
INSERT INTO ntu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mz nibr Sabat kc, mz nourla kxtopwz mz Sade, Mxri kc Makdala x kzdq kz Mxri nzvzng mz nzoklati-krdr butqbr kc tzyrtzmqngr Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Zbz kzdq enjrl ne Gct vzom Heven, vzmim nengq kxetu. Vztr mz butqbr kc, x sc tqalqlipxpele rplz kc etu tzapqbrtrngr naonrx kc, x sc tqwxbuopem elr. ");
INSERT INTO ntu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nzpnapr-krde apule bzlrpc, x lrpz scde prkitxpx apule nqbya ngr nrc. ");
INSERT INTO ntu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ncblo kcng tzaukzng nzmwxlrng x nzrnrcti-lzbqng x nztaong mz drtc' nzapulr ncblo kxnzbzpeng. ");
INSERT INTO ntu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Enjrl kc rpibzle mz olvz kcng kx, “Bzkq mwxlramu. Krlzpebo kx rtangrtiamu Jiszs kc tztqlvztr mz kros. ");
INSERT INTO ntu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tryrbqpeu mrka, murde lupe mou, da kc tqwai nzpi-krbzlele bamu. Vzmamu x mc-zpwxamu mrkc tzayrbqngr namz ngrde. ");
INSERT INTO ntu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","A' yzlu-aniamu x pibzmu mz ncblo nedeng kx, ‘Jiszs tulzpe-mop mz nzbzngr, x sa nartwayzpe kai Gzlili. Sa narmctiamu nide elr.’ Nrpa kx napibo bamu delape.” ");
INSERT INTO ntu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Zbz olvz kcng sc tzngrlr-anipeng mz nzpi-krmlrle bagr. Kxmule-esz' nzmwxlrbeng, a' drtwrdr elalz-zlwz-kzp. ");
INSERT INTO ntu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","A' mz nzvz-krdr, nzpwrkilvc-ngrdr nzadcpx-lzbq-krbz Jiszs badr. X sc tqrpipebzle badr kx, “Nimu la!” Nzvzmqng x nzyrngzobzng bade, x nzmaletrpzlr nanycde, mz nzangio-krdr nide. ");
INSERT INTO ntu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Zbz rpibzle badr kx, “Bzkq mwxlramu. A' vznamu x pibzmu mz mzlengeng kx navzng Gzlili x sa narmctilr ninge elr.” ");
INSERT INTO ntu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mzli kc tzvzngr olvz kcng, ncblo kcng tzaukzng nztulzmqng, x kzdung nidr nzvzng Jerusalem, sc tzrlwape-ngrbzlr mz kxnzetu rdr pris da amrlx kcng tqprtz. ");
INSERT INTO ntu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Zbz kxnzetu rdr pris nzyrlwr-lxblrng badr lrtzlvzng x sc tzryrlqpeng drtwr. Mz drtwr lc, nzrkabzng trau kxkqlu mz ncblo ngr vea kcng. ");
INSERT INTO ntu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","X nzrpibzlr badr kx, “Mz da kc tqprtz, napibzmu mz leplz kx, ‘Ncblo nedeng nzvzmqng mz nrlckxbq mzli kc tqmwi-ngrgr x nzpnatilr nrkrdrtqde.’ ");
INSERT INTO ntu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","X nzmu Paelzt, kxetu rmu kc tqngi Gavzna naxlrle da lc, sa naycmnebzkr bade ma tzayrplapxlr nimu.” ");
INSERT INTO ntu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mz nzmu-krde lcde, ncblo ngr vea lcng nztwzlr trau kcng x nzvz-nqblqlr natq pris kcng. X krlc be kx nzyapwxtine zvz mz mzlir lr Jiu, vz-krlzmle mzli ka tqyr-ngrne buk lc. ");
INSERT INTO ntu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nigr kcng nzpnu-esz'-nrade-esz' (11) vzkr Gzlili mz newz kc tqpim Jiszs navzdz-ngrgr. ");
INSERT INTO ntu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mzli kc tqmc-ngrgr nide, angiokr nide, kxmule-esz' kzdung nigr drtwrdr litrbepz bade. ");
INSERT INTO ntu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jiszs vzm bagr x rpimle kx, “Gct aprcpemle bange zmatq mz doa x da amrlx Heven x mz nrlc ka. ");
INSERT INTO ntu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mz nzmu-krde lcde, vznamu mz zmatq rnge. X okatramu leplz ngr mrkcng kqlu x natq amrlx mz nrlc tulvzo mz nzvz-nqblq-krdr ninge. X awrkxtramu nidr mz drtq Gct mz nzngini-krde Trte, Mrlx, x Mqngrkxtr. ");
INSERT INTO ntu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","X alvztramu nidr mz nzvz-nqblq-krdr natq amrlx kcng tqkabo bamu. X sa namnc-zvzbo bamu mz nzokatr-krnge nimu, navz nakrlzbzle mzli kc tqmcpx Trte nayzlu-ngr-mopc'.” ");
INSERT INTO ntu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Krlc nzyzutrkr Nrpa ngr Jiszs Kxnzmcpx, Mrlx Gct. A' mzli kc tryzutr-ngrka nzwz-krde, Jon Kxawrkxtr vz-kaip mz nzyapwx-krbzle mz leplz. ");
INSERT INTO ntu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","3","Asaea, profet kc bqnc, yrole da kx pibz Gct mz mrlxde. Ycmnetr-ngrde Jon Kxawrkxtr mz nzrpi-krde kx, “Krlc menrpa nenge. Sa na-atwzlr-ngrne nartwayz-kaipz bam, murde naokatrle leplz nengeng mz nzoliqti-krdr nzvz-krbzme. Natq kzdq ncblo kx natqde etu mz nzryapwx-krbzle mz leplz lzke. Natq lcde rpile kx, ‘Oliqtiamu nabzmu mz nzvz-krm Kxetu Gct. Atubqtibzmu lrpzki kx nangi nyzde na-apule nzoliqtikr leplz kzdq lrpzki kx navzkim king.’” ");
INSERT INTO ntu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Zbz mz nzatutr-krde Nzryrngrkxtr lc, Jon Kxawrkxtr tupxm lzke mrkc Provins kc Judiz. X yapwxtipxbzle nrpa lcde seleng, “Tekqtramu nqmq nr drtwrmu kxtrka. X rlr-lzbq-ngrmamu mz nzawrkxtr-krbo nimu mz nzaelwapx-krmu nzvzkr drtwrmu mz alwx ngrmu, murde Gct naipqle nimu.” ");
INSERT INTO ntu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Leplz kxkqlu zlwz mrkc Jerusalem x mz provins kc Judiz, vz zvz nzvzpx-krmlr mz nzlalztq-krbzlr mz Jon. Nzplxtitxpxbzlr alwx ngrdrng, x sc tqawrkxtrpeleng mz LueJodzn. ");
INSERT INTO ntu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon vz-nqblqnepwzle nqmq kr ncblo kx tr-rngibau, da kc tzwai profet kcng bqnc. Pxine-ngrpwzle lrpz kx nzwzngr mz nrpnr kamel. X amqngitr-ngrde lrpxi rde nrkalo kx nzwzpx-ngrm mz bekzu. X dakxnzng nade ngi txpwz dalr lzke, krlcng kionabr x hane. ");
INSERT INTO ntu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","X Jon sc tqyapwxtipxbzle kx, “Kzdq la ncblo kc sa navzm mz nibrnge, namyaszlzle ninge. X trtakitrpwc'u nzwztr-ngrbz bade, kxmule-esz' nzryokaepxngr nqvi lr sadol ngr nanycde. ");
INSERT INTO ntu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Awrkxtrtxpwo nimu mz lue, a' sa na-awrkxtrle nimu mz Mqngrkxtr.” ");
INSERT INTO ntu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mzli lcde, Jiszs vzkimle mztea Naszret mrkc Gzlili Provins. Vzm mz Jon x sc tqawrkxtrpe Jon nide mz LueJodzn. ");
INSERT INTO ntu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mzli kcpwz Jiszs tqvzdz-ngrmle mz lue kc, mcle Heven nzlvxpx x Mqngrkxtr vzom bade, apule nran. ");
INSERT INTO ntu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","X natq Gct vzom Heven, rpile kx, “Nim Mrlxnge Kxnzmrlzti. X abrtzlvz-zlwzx nim.” ");
INSERT INTO ntu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","X mzli kcpwz Mqngrkxtr sc tqngi-batrpebzle nzvztr-krde lzke. ");
INSERT INTO ntu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","X mnctipxmle mrkc zbq nzpnu-pwx, tqtamiti Setzn nide mz nzatao-krde nide mz alwx, a' trtao-pnzu. Kxmule-esz' animol kxnztrkating nzmncng badr, a' enjrl neng Gct nzaclve-angidrlr nide. ");
INSERT INTO ntu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mz nibr King Herot Antipas nzadwatr-krde Jon Kxawrkxtr mz presin, Jiszs kc tqvzpe mz Gzlili Provins mz nzyapwxtipx-krde nrpa ngr Gct. ");
INSERT INTO ntu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Rpile kx, “Tekqtramu nqmq nr drtwrmu x rlxngititramu mz Nrpakxmrlz lc. Murde mzli ka Gct sc tqvectrple leplz bade, mz nzmnclz-krbzlr bade mz nzngini-krde King rdr.” ");
INSERT INTO ntu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kzdq zbq Jiszs kx vznede kc mz nrlar Dxbu Gzlili, sc tqrmctipele kc ncblo kxnzmwang nzling, Saemon nidr ncdr mzlede Adru. Tzmwaneng mz br scdr. ");
INSERT INTO ntu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Zbz rpibz Jiszs badr kx, “Vz-nqblqmamu ninge, murde na-alvztrpo bamu nzrtangrngr leplz, kx nangi nengeng.” ");
INSERT INTO ntu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","X mzli kcpwz nzrlasztx-pnzlr nzwz-krdr x sc tzvz-nqblqpelr Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Zbz Jiszs vznebz kxpipz mz nrlar dxbu kc x sc tqrmctipe-kzle kzdq mou mzle-lzbq nzling, Jemes x Jon. Trtedr drtqde Sebedi. Tzmnclzmqng mz nabz bot scdr, tzngqtitrlr br scdrng. ");
INSERT INTO ntu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","X mzli kcpwz sc tqkqlepe-kzng Jiszs nidr mz nzvz-nqblq-krdr nide. X nzrlasztxdr trtedr Sebedi mz nabz bot kc badr ncblo kcng tzawzlrng, x sc tzvz-nqblqpe-kzlr nide. ");
INSERT INTO ntu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Zbz Jiszs badr ncblo nedeng nzpwxng sc tzvzpeng mz taon Kzpznizm mrkc Dxbu Gzlili. Kx nzkrlzbzlr kc Kzpznizm, sc tzvztrpeng mz mangr-nzkrka'ngr nyzdr lr Jiu mz nzalvztr-krde leplz mz Satde, kc tqngi Sabat nyzdr. ");
INSERT INTO ntu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Leplz amrlx nzkctitxpx-zlwzlr nzalvztr-krde. Murde trapuleu kxnzakrlz kcng tzalvztrng mz Loukxtr, a' ycmnemile zmatq angidr. ");
INSERT INTO ntu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Zbz kzdq kc ncblo kx mncpx-ngrm drka' sc tqdwatrpebz mz mangr-nzkrka'ngr. Sc tqnetxpxpe mz natqde kxwzpx. ");
INSERT INTO ntu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Rpipele kx, “Vrr! Vzpe Jiszs kc Naszret! Vz, dwasz nigr! Vz-ngrme nzodati-krm nigr! Krlzx ncblo kznike tqnginim! Nim Ncblo Kxtr kc tqatwzlr-ngrm Gct!” ");
INSERT INTO ntu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ycmne-plztitxtr Jiszs drka' kc. Rpibzle kx, “Mnc-lrpi! Dwapxm mz ncblo la!” ");
INSERT INTO ntu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","X drka' kc arnrctitxde ncblo kc, netxpx, x sc tqprszpxpele nide. ");
INSERT INTO ntu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Dzbe leplz kcng nzkctitxpx-pnzlr x sc tzveatine-etrpelr mz nzrpi-krdr kx, “Eke! ?Nike tqpile? ?Krlc nzalvztrngr kxmrna? Rngisc zmatq mz nzrka-krbzle natq mz drka' kcng, x nzlxngitibzlr natqde!” ");
INSERT INTO ntu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Zbz nrpa ngr da lcng tqaleti Jiszs sc tqvztx-anipepwz mz Gzlili Provins tqlvzo. ");
INSERT INTO ntu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mzli kc tqyrkrtxpx-ngrpwz nzkrka'-krdr, Jiszs badr Jemes, Jon, Saemon x Adru, ncblo kcng tzvz-nqblq-kailr nide nzrlasztxdr mangr-nzkrka'ngr kc. X sc tzdwatrpeng mz ma nyz Saemon ncdr Adru. ");
INSERT INTO ntu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kzdo Saemon kc tqngi olvz sc tqmnz me mnz-ngrde murde yagox x drtqde pqpxm. Mzli kc Jiszs tqkrlzpe-ngrbzle mrkc, lr nabz ma kc sc tzpipebzlr bade olvz lc tqyagox. ");
INSERT INTO ntu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jiszs vzbz bade, otibzle mqde x sc tqokatrpele nzatulz-krmlele. Zyagox kc yrkrtxpx pnz, zbz sc tqoliqtipebzle dakxnzng nadr. ");
INSERT INTO ntu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mzli kc nepi tqtaope-ngrde, x Sabat kc tqyrkrpxpe-kzpz, lr Kzpznizm nzvzmitimlr mz Jiszs kztedrng kxnzyagoxng x kxnzmncpx-ngrmqng drka'. ");
INSERT INTO ntu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Lr mztea kxnzkqlung nzyrlwrtrpzng yz mz ma kc tqmncpx-ngrm Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","X amrlztibzleng leplz kxkqlu mz nzyagox-krdrng amrlx. X maszlrpx-kzpzleng drka' mz leplz kxkqlu. A' tr-rlr-ngrpwzleu mz drka' lcdeng nzycmne-krdr, murde nzkrlzlr kx nide Mevalu kc tqmcpx Gct. ");
INSERT INTO ntu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mzli kc nrlc tqbqbe-ngrde, mzli boibe x nrlc kc tqbrlawxpxpe, Jiszs dwalzm x rlasztxde ma kc, vzpx mz nrlarde kx yz mz taon kc me tu-nabungr, x sc tqkrka'pe. ");
INSERT INTO ntu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Mzli kc tzdwalz-ngrmlr, Saemon nidr badr kztedeng trnzmcpelru Jiszs. X sc tzvznepeng mz nzrtabrti-krdr nide. ");
INSERT INTO ntu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mzli kc tzrmcti-ngrdr nide sc tzrpipebzlr kx, “Leplz kcng tzrtabrtilr nim!” ");
INSERT INTO ntu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","A' ayzlu-ngrbz Jiszs natqdr kx, “Kxmule-esz', a' navzki-kzx du mztea kzbleng mz nzryapwxpx-kz-krbong badr Nrpakxmrlz. Murde delc tqngi nou nzvzo-krmc mz nrlc ka.” ");
INSERT INTO ntu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Zbz sc tzolvxtipe-kzlrng mztea amrlx mz Gzlili Provins. X sc tqyapwxtipxpebz Jiszs Nrpakxmrlz mz leplz mz mangr-nzkrka'ngr nyzdrng, x tqrmaszlrpx-kz-ngrbz drka' kxkqlu badr. ");
INSERT INTO ntu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kzdq zbq kzdq ncblo kx ycngr lepz vzm x rwetxobz zpr mz Jiszs. X sc tqyrnitrpebz bade mz nzrpi-krde kx, “Kx tqsuti drtwrm le, krlzx kx nzmu krlzq nzamrlzngr ninge!” ");
INSERT INTO ntu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jiszs yctx pnz mz drtwrde mrlx kc. Kxmule-esz' mz Lou sc Mosis batrpzle trnztakitr-krdeu nide mz nzprtrngr mz nzangiongr, a' maletxtrpzle nide. Sc tqrpipebzle kx, “Mrlzm bange. Namrlzq.” ");
INSERT INTO ntu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","X mzli kcpwz lepz kc dwasztx-pnzle ncblo kc, x nrkrdrtqde mrlztx pnz. ");
INSERT INTO ntu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Zbz Jiszs rkabz natq, rpibzle bade kx, “Vzpe! X da lc, bzkq ena ncblo kx napi-nebanle. A' vz-kaipz mz pris, x pibz bade napwxlitibzle nim, kx namcpzle kx mrlzpeq. Zbz sa napipxbzle mz leplz, murde namnc-lxblr-mouamu badr. X kabz mz Gct blz kx nangi dalr nzamrlzngr nim, da kc tqwai nzpikr Lou sc Mosis le, x nakrlzngr leplz amrlx le kx tubqpeq mz Loukxtr.” ");
INSERT INTO ntu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","A' mrlx kc pitxnede da lc mrkcng kqlu tqvzkile. X rblxbz mz Jiszs nzvztr-krde mz mztea lcng murde dzbe leplz kx nzyrlwrng mrkc nzkqlu-aning. Delc tqmncpe-ngrmle rlru, a' kxmule-esz' lr mztea kang kqlu sc tzvzmqng ye bade. ");
INSERT INTO ntu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mz nibr kzdung zbq, Jiszs sc tqyzlupe mou Kzpznizm. A' leplz kxnzkqlu nzxlrlr kx sc tqmnc mrkc. ");
INSERT INTO ntu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","3","Zbz sc tzyrkrpebzng mz ma kc tqmnc-ngrde. Nznulvzlr ma kc x nzyrlwrtrpz kcng yz. Mzli kc Jiszs tqyapwxtipx-ngrbzle Nrpakxmrlz badr, ncblo nzpwxng nzvzmqng, nzglqmlr kc ncblo kx nrkrdrtqde bz. Nzglqtimlr nqni. ");
INSERT INTO ntu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","A' rblxtx nzglqtr-krbzlrle mz Jiszs murde leplz kqlu zlwz mrkc. X sc tzglqlz-alzupelr mz nibr ma kc, x nzlvxlzlr mrkc tqmnc-zbzlzbz Jiszs. Zbz sc tzavoopebzlr ncblo kc mz nqni mnrde. ");
INSERT INTO ntu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kx krlztrpz Jiszs nzbrtikr drtwrdr nide mz nzamrlz-krde kztedr, sc tqrpipebzle mz ncblo kc tqyagox kx, “Mrlxnge, alwx ngrmqng ipqpxpebo.” ");
INSERT INTO ntu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kzdung lr Jiu kcng tzalvztrng mz Loukxtr kcng tzwxbung mrkc, sc tzrpipelr mz drtwrdr kx, ");
INSERT INTO ntu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Rlr! Mrlx lc tqpivxitile Gct. Murde Gct txpwz kx krlzle nzipqpxngr alwx!” ");
INSERT INTO ntu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mzli lcdepwz mz nzokatrkr Mqngrkxtr, Jiszs krlztitrpebzle mz mqngrde da kx yc mz nabzdr. X sc tqrpipebzle badr kx, “Bzkq nzao-krmu drtwrmu da kxmule lc. ");
INSERT INTO ntu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nzmu narpibo mz ncblo kxyagox lc kx, ‘Ipqpxbo alwx ngrm,’ rblx nzrmcngr. A' nzmu narpibo bade kx, ‘Tulz, oti nqni pnrm, x vzpe,’ opx angidr nzrmcngr. ");
INSERT INTO ntu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mz nzmu-krde lcde, na-amrlzbo nrkrdrtqde mz nzaelwapx-krnge kx ninge, Mrlx Leplz, rngisc-kznge zmatq ngr nzipqpxngr alwx mrka mz nrlc.” X sc tqrpipebzle mz ncblo kc nrkrdrtqde tqbz kx, ");
INSERT INTO ntu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Mrlxnge, tulz, oti nqni pnrm x vzpe mrnyzm!” ");
INSERT INTO ntu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","X ncblo kc sc tqtulzpem mz mztr amrlx ngrdr, otile nqni mnrde x sc tqvzpe. Leplz amrlx nzkctitxpx-atwrnr-ngrdr nide, x nzglqpxlr Gct mz nzrpi-krdr kx, “Rlr! Trgalr da kx mcku kxmule ka.” ");
INSERT INTO ntu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jiszs yzlu mou mz nabz drta' Dxbu Gzlili. Zbo ngr leplz nzyrkrmqng bade x sc tqabzopele nzalvztr-krde nidr. ");
INSERT INTO ntu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mzli kc tqvzne-ngrde mz nabz drta' kc, mcle kc ncblo drtqde Livae. X kzdq kz drtqde Matiu. Ncblo lc nide mrlx Alfizs, x sc tqwxbu mz ofis nyzde kc tzxpekitr takes. Rpibz Jiszs bade kx, “Vz-nqblqm ninge.” Livae tutxlzm, axtxbzle da amrlx, x sc tqvz-nqblqpele Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mz nibrde, Jiszs sc tzmupeng badr ncblo nedeng mz ma nyz Livae. Zbz kzdung ncblo kx nzatakqting takes x kzdu-moung leplz kx nqmq krdr trka mz nzobqkr leplz nzmu-lxblr-kzng badr. Murde leplz kxnzmulr lcng nzkqlung nzvz-nqblq-kzlr nide. ");
INSERT INTO ntu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mzli kc tzmc-ngrbzlr Farzsi x krkcng tzalvztrng mz Lou sc Mosis da lc, drtwrdr trmrlzpeu. Murde mz drtwrdr trtakitrdeu ncblo kxmrlz nzngini-krde kzte ncblo kxnztrkang. X sc tzveapebzng mz ncblo nedeng kx, “?Nike Jiszs tzmu-lxblr-ngrdr badr leplz kxnzmulr lcng?” ");
INSERT INTO ntu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Xlrpebz Jiszs natqdr x sc tqrpipebzle badr kx, “Leplz kx trnzyagoxung trnzsutiu drtwrdr dckta. A' kxnzyagoxng la tzsuti drtwrdr dckta. Trvz-ngrpwc'u nzrkqlengr leplz kx nzrpilr nztubqng. A' vz-ngrmc nzrkqlengr kxnzaleng alwx, murde naesablqtilr alwx ngrdrng.” ");
INSERT INTO ntu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mz nqmq kr lr Jiu nzaxtx-ngrbz dakxnzng zbq li mz wiki kxesz' mz nzkrka'-krdr. Kzdq zbq oblamzng Jon Kxawrkxtr x kr nedrng Farzsi kcng nzaxtx-ngrbzlr dakxnzng. X kzdung leplz nzvzmqng mz Jiszs, x sc tzveapebzng kx, “?Nike ncblo nemqng trnzaxtx-ngr-kzpzlru dakxnzng?” ");
INSERT INTO ntu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","20","Jiszs rpibzle kx, “Apux ncblo kxnayrlz. Mz nqmq lcpwz trtakitrdeu leplz nzaxtx-krdr dakxnzng mz mzli r nzabrtzngr mz nzyrlzngr, trtakitr-kzdeu ncblo nengeng nzaxtx-krdr dakxnzng mzli ka mz nzmnc-aepztr-krbzlr mz Gct. Murde nzabrtz-ngrdr ninge lc tqmncbepo badr. A' mz nibrde, mzli kc nakatxpx-ngrmc badr, sc tqtakitr-atede nzaxtx-krdr dakxnzng mz nzkrka'-krdr. ");
INSERT INTO ntu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nzycmne-ebzpxngr lcng li nzaelwapx-ngrdr nqmq krnge kxmrna. Murde trpnzngr ncblo kx rkxsilvztr dzlvq lrpz kxmrna mz nzakqlvztr-krde me bxnge mz lrpz kxblzlongr. Nzmu nawailele, dzlvq lrpz kc tqmrna sc tqbxplipxpem mz lrpz kcma tqblzlongr, x sc tqbxplipx-zlwzpe myaszpxle mzli kc kai tqbxpli-ngrde. ");
INSERT INTO ntu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","X trpnz-kzngr ncblo kx narbzlutr dakxnzng kxmrna mz ncblei kx nzrbzlutrpengr dakxnzng. Murde ncblei kxmule lcde ngcplxtxtr kai mz nzmrnabekr dakxnzng, x da lcng li sc tzatrkatipeng. A' dakxnzng kxmrna nabzlutrpwz mz ncblei kxmrna.” ");
INSERT INTO ntu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mz kzdq zbq ngr nzangiongr, zbq lc nzrpibz Sabat, Jiszs badr ncblo nedeng nzo-zlilr lrpzki kx vztr mz kzdung lclr wit. Ncblo nedeng, sc tzcpqpxpemqng nra wit mz nc ngrdr. ");
INSERT INTO ntu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Zbz kzdung Farzsi sc tzrpipebzlr bade kx, “Mc ena da kc tzalelr! ?Nike tzxpqbrlr-ngrdr Lou sc Mosis mz nzwz-krdr mz Sabat?” ");
INSERT INTO ntu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","A' mz nzaelwapxkr Jiszs kx takitrde nzokatrngr ncblo mz Sabat, sc tqayzlupe-ngrbzle natqdr, rpibzle kx, “Krlz-angidr-kzamu da kc tqale melrmqmu King Devet kc tqamatqamu, mzli kc tzbrtale-ngrdr badr ncblo nedeng. ");
INSERT INTO ntu_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nzvztrng mz ma nyz Gct mzli kc Abiata tqngini-ngrde Nardr Pris. X Nardr Pris lc kabzle mz Devet bret kc tqngi blz, kxmule-esz' rpwa'ngr Loukxtr scgu. Murde bret kxtr nangqpwz pris. A' Devet ngqde bret lcde x ka-kzpzle mz dzbede nede. X nakrlzamu kx mz nzobqkr Gct, Devet trpnzngr da kx avz-rbrle. Murde Lou sc Gct rlr-ngrmle bagu nzokatrngr leplz. ");
INSERT INTO ntu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Murde Gct wz-ngrde Sabat mz nzokatr-krde leplz. A' trwz-ngrdeu leplz mz nzvz-nqblq-krdr lou ngr Sabat. ");
INSERT INTO ntu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Delc ninge Mrlx Leplz, tqngininge Kxetu r Sabat. X tqrngiscnge zmatq mz nzpnzkr drtwrnge da kx takitrde nzalengr mz Sabat.” ");
INSERT INTO ntu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mz kzdq mou Sabat, mz nzvztrkr Jiszs mz kzdq mangr-nzkrka'ngr, rmctile kc ncblo kx mqde bz. ");
INSERT INTO ntu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kzdu kcng Farzsi tzyrlwr-kzng mrkc nzrtangrtrpzng da kx vz-rbrti Jiszs. Sc tzaukzti-angidrpelr mz nzmc-krdr nzmu na-amrlzle doa kxyagox mz Sabat. Murde mz drtwrdr nzamrlzngr doa kxnzyagoxng ngi nzwzngr. ");
INSERT INTO ntu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sc tqrpipebz Jiszs mz mrlx kc mqde tqbz kx, “Vzpxm x tu mrlc.” ");
INSERT INTO ntu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Zbz sc tqrpipebz Jiszs mz leplz kcng kx, “?Nike rlrpxngr Loukxtr scgu nzalengr mz Sabat? ?Nzokatrngr leplz o nzatrkatingr? ?Nzarlapxngr nzlukr ncblo o nzrlr-ngrbz nzbz-krde? Murde krlz-angidramu kx Loukxtr scgu rlrpx-ngrmle bagu nzalengr da kxmrlzti mz Sabat.” A' leplz kcng nzmnc-lrpi-txpwzng murde nzkrlzlr kx mrkc tqvzki nardr vz-rbr. ");
INSERT INTO ntu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jiszs obq-ngale-ngrde nidr amrlx ngrdr. X drtwrde ngya x talvzo-ngrde nzrsaprlr-krdr natqdeng. X sc tqrpipebzle mz ncblo kc kx, “Atwztqpx mqm.” X atwztqtxpxle mqde, x mrlztx pnz mou. ");
INSERT INTO ntu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Zbz Farzsi kcng nzrlasztxdr mangr-nzkrka'ngr. X sc tzvz-anipeng mz nzycmne-etr-krdr badr ncblo neng King Herot Antipas, mz nzrpi-krdr kxnamu nznibq-krdr Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jiszs badr ncblo nedeng nzabrkapx-lzbqmqng mz mztea, x sc tzvzpeng Dxbu Gzlili. A' kzdq zbo ngr leplz kxetuting ngr Gzlili Provins sc tzvz-nqblqpelr nidr. ");
INSERT INTO ntu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","X leplz kzbleng nzyrkr-kzpqng mz Jiszs mzli kc tzxlrti-ngrdr rkx kcng tqaletileng. Nzvzkimlr taon kxetu Jerusalem, x mz mztea ngr Judiz Provins amrlx, krlzbzle me nzmncngr lr Edom kcng trngiulrJiu. Nzvz-kzpqng kcng mz nrlar LueJodzn kc tqyctxo. X nzvz-kzpqng kcng Taea x Saedon, taon kxetuting nyz lr mrkzbleng, mrkc Prla Meditrenia. ");
INSERT INTO ntu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Leplz kxnzyagoxng amrlx sc tzapetr-lzbqbzng mz zbo ngr leplz kcng mz nzbxtr-krbzlr nide. Murde nzrpilr na-amrlz-kzpzle nidr da kc tqwai nzamrlzpe-krde leplz kxkqlu. Zbz rpibzle mz ncblo nedeng kx naoliqtibzlr dq bot kx nadwatr-ngrmle dxbu mz nzalvztr-krde nidr. Murde ma tzolikilvztilr nide mz nzalvztr-krde. ");
INSERT INTO ntu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","X mzli kznikeng drka' kxnzmncpx mz leplz nzmcpebzlr nide, sc tztaopebzng bade, tzrpipelr mz nznepx-krdr kx, “Nim mrlx Gct!” ");
INSERT INTO ntu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","A' Jiszs rngidrlvztx-ngrbzle badr kx bzkq nzpinebzlr da lc mz leplz. ");
INSERT INTO ntu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Zbz Jiszs vztxlz-ngrde kc newz x sc tqaveatipele krkcng tqsuti drtwrde, sc tzyrkrpebzng bade. ");
INSERT INTO ntu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Mcpxle ncblo nzpnu-esz'-nrade-li (12) kx nanginidr ncblo nedeng kxnzmyatxpxbzng, kx na-alvztrleng. Murde, mz nibrde na-atwzlrpx-ngrdeng mz nzyapwxtipx-krdr Nrpakxmrlz. ");
INSERT INTO ntu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","X narngiscng zmatq mz nzrmaszlrpx-krbzlr drka' mz leplz mz drtqde. ");
INSERT INTO ntu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Krkcng nzpnu-esz'-nrade-li (12) tqmcpxleng nidr seleng: Saemon, kc tqyrlq-kzpz Jiszs drtqde Pita, Jemes nidr mz mzlede Jon kcng tznginidr mrlx Sebedi, x Jiszs kabzle badr drtqdr Boanrjis, drtwr ngrde mrlxng bzlrmei, murde nardr mrbc, Adru (mzle Saemon Pita), Filip, Batolomiu (mrlx Tolmai, kc kzdq drtqde Natzniel), Matiu (kc kzdq drtqde Livae), Tomas, Jemes kc tqngi mrlx Alfizs, Tadizs (kc tzrpi-kzpz Judzs, mrlx Jemes), Saemon kc tqprtr ena mz dzbede kc tzrpilr namaszlrtxpx-ngrdr gzpman ngr Rom mz nzmnc-krdr Israel, x Judzs Iskariot, kc tqamwabzle Jiszs mz enqmi rdeng. ");
INSERT INTO ntu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Zbz Jiszs yzlu mou bzq mrkc mztea Kzpznizm. X kzdq zbo ngr leplz kxetuting nzyrlwr-ngalelvz-moulr nidr badr ncblo nedeng. Sc tqrblxtxpe nzmu-krdr kxpipz mz nzokatr-krdr leplz lcng. ");
INSERT INTO ntu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mzli kc lr ma nyz Jiszs tqxlr-ngrdr da lcng, sc tzrkalzpemqng mz nzoti-krdr nide. Murde nzrpilr leplz kx ngqngupe-ngrde nzwz-kato-krde. ");
INSERT INTO ntu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","X mzli lcpwz kzdung kxnzalvztrng mz Lou sc Mosis kx nzvzkimlr Jerusalem sc tzrpipelr kx, “Mrlx la mncpx-ngrm Beelsebol, kxetu r ma ngr wq, nide kc tqaclvele drka' amrlx, x sc tqrkabz bade zmatq mz nzmaszlrpx-krde drka' mz leplz.” ");
INSERT INTO ntu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Zbz Jiszs sc tqrpipebzle kx nayrkrmqng bade. X sc tqryapwxpebz badr mz nzycmne-ebzpxngr lcde sele. Rpibzle kx, “Trtingr! Murde Setzn rblx nzmapulrpx-krde drka' kztedeng mz nabz leplz! ");
INSERT INTO ntu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Murde kandre kx akipx-lzbq mz dzbede sc tzota-etrpeng, e mzli kxpipzne trnatu-amqngiung. ");
INSERT INTO ntu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mz nqmq lcpwz doa lr ma kxesz' kx nzamnc-dali-lzbqng, nzatrkati-lzbqng. ");
INSERT INTO ntu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","X mou, nzmu Setzn badr kztedeng naotablrlr mz nidr esz'-krdr x nzaki-lzbqng, e zmatq ngrde mz nzaclve-krde leplz sc tqmanepe x tqyrkrpxpebz. ");
INSERT INTO ntu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mz nzmu-krde lcde, Setzn apule ncblo kx xplr zlwz. A' napebqtx kai, x ncblo kc tqdwatr-atebz ma nyzde mz nztwz-krde dztudeng. Da kc tqwai nzarlapx-ngrbz leplz mz mqde. ");
INSERT INTO ntu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","“Rpiamu kx nabznge mncpx-ngrm drka'. A' da angidrtx lc napibo bamu. Gct krlzle nzipqpx-krde alwx x nzrpivxitingr amrlx. A' mz nzrpi-krmu lc zmatq rnge vzpxm mz drka', pivxitiamu Mqngrkxtr kc tqngi nou angidr zmatq lc. X trpnzngr nzipqkr Gct leplz kx pivxitile Mqngrkxtr, murde atao-lzbq mz alwx kx yctx alo.” ");
INSERT INTO ntu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Zbz lxede Jiszs x mzledeng nzkrlzbzlr ma kc tqmnc-ngrde. A' rblx nzprtr-krbzlr brma, murde zbo ngr leplz kcng tzmncong mrkc. Nzatwzlrtr-ngrbzng nrpa bade kx navzpx-kaip badr. ");
INSERT INTO ntu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kzdu leplz mz zbo ngr leplz kcng tzwxbu-ngalelvzlr Jiszs, nzrpibzlr bade kx, “Lxem x mzlemqng sc tztutrpqng yz, nzrpilr namclr nim.” ");
INSERT INTO ntu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","X sc tqrpipebzle kx, “?A' nekeng tqngi angidr lxenge x mzlengeng?” ");
INSERT INTO ntu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Obqtxbz mz kxnzrlxngiting kcng tzwxbu-ngalelvzlr nide, x sc tqrpipebzle badr kx, “Doa kxnzapulr nimu lang tqngi lxenge x mzlengeng! ");
INSERT INTO ntu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Murde krkc tqvz-nqblqle me pnz drtwr Gct, nide la mzlenge x inwenge x lxenge angidrng.” ");
INSERT INTO ntu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mz nibrde, Jiszs dwapx ma kc x sc tqvzope mz nabz drta' ngr Dxbu Gzlili. Zbz zbo ngr leplz kcng kxnzetunepxlr kc, sc tzyrlwr-ngalelvzpelr nide. X sc tqdwaope mou mz bot, mz nzalvztr-krde nidr kcng tzyrlwrpxbzng mepz. ");
INSERT INTO ntu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yapwxtibzle badr kzdung nzycmne-ebzpxngr mz nzalvztr-krde nidr da kxkqlu. X mz zbq lcde Jiszs yapwxtibzle badr nzycmne-ebzpxngr lcde seleng. ");
INSERT INTO ntu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Lalztqmamu bange! Kzdq mzli kzdq kc ncblo oliqtile drtc' ngr nrlanc nyzde. Zbz sc tqarlxpele nra wit nyzdeng, murde rpile nayrkqlvzle mz drtc' mz nibrde. ");
INSERT INTO ntu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","A' mzli kc tqarlx-ngrdeleng, kzdung tationg mz lrpzki kx drtc' ngrde mqngi, x nzngqtilzmqng utc. ");
INSERT INTO ntu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","X kzdung nztaong mz drtc' kxmelx, murde ycom mz rplz. Nzlvcpulz-animqng, a' nzglrting x nzmztx-ani-moung mz nepi, murde dzbrdr trvzou la. ");
INSERT INTO ntu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","X kzdung mou nztationg mz drtc' ngr ncngrbz. Krlcng nzlvcpumilzm lxbi x nzyrlvilvzo lxbi nidr x trnzpa-pnzung. ");
INSERT INTO ntu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","X kzdung nztao mz drtc' kxmrlz. Krlcng nzyrlvzlzmqng x nzpang. Kzdung nradr pipz, kzdung nradr kqlu, x kzdung nradr kqlutx zlwz. ");
INSERT INTO ntu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Doa kx yrplapx, na-abzle nztwz-krde drtwr ngr natq lc.” ");
INSERT INTO ntu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mz nibrde mzli kc Jiszs tqmnc-ngrde esz'-krde, aposol badr kzdung kz leplz nedeng, sc tzrpipebzlr bade kx nayapwx-dalitipxbzle badr nike tqngi drtwr ngr nzycmne-ebzpxngr lc. ");
INSERT INTO ntu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Sc tqrpipebz Jiszs kx, “Ayrbq-angidrbo bamu nqmq kr Gct kc tqyc-kapq mzli kc mz nzngini-krde King r leplz nedeng. Murde doa kx lxngitile Gct, Gct sa na-aetunepxbzle nzrkrlz-krde da angidr x sa na-axplrbzle nzrlxngiti-krde. A' mz leplz kcng tzpxpx-ngrdr nzxlr-krdr da angidr, napipxbo badr mz nzycmne-ebzpxngr. ");
INSERT INTO ntu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nidr leplz kcng tqycmnetrngr profet Asaea mz nzrpipxkr Gct kx, ‘Kxmule-esz' nzobqng, a' trnzkrlzlru da angidr. X kxmule-esz' nzlalztqng, a' nardr tryrplatrpwzu. Mz nzmu-krde lcde, rblxbz badr nzyzlu-krmlr bange mz nzatubqti-krnge nabzdr.’” ");
INSERT INTO ntu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kctipx Jiszs trnzkrlz-krdru nzycmne-ebzpxngr lc, sc tqrpipebzle badr kx, “?Tryrplatitru narmu nzycmne-ebzpxngr lc? Nzmu kx tqmule lcde, sa narblxbz bamu nztwz-krmu drtwr ngr nzycmne-ebzpxngr amrlx. ");
INSERT INTO ntu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Drtwr ngr nzycmne-ebzpxngr kc nide sele: Nra wit kcng tqarlx ncblo ngi natq Gct. ");
INSERT INTO ntu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Drtc' pwx ngi nqmq kr leplz. Lrpzki lc drtc' ngrde tqmqngi, drtwr ngrde leplz kcng nardr tqmqngi mz nzxlr-krdr natq Gct. Murde mzli kznikeng nzxlr-ngrdr nrpa ngr Gct, Setzn vzm x katxpxbzle badr. ");
INSERT INTO ntu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Drtc' kc tqmelx drtwr ngrde leplz kcng nabzdr tqngrgo. Kxmule-esz' nzxlrlr natq Gct x nzabrtzlvzlr nztwz-krdrle, a' natq Gct trpnzngr dzbrde x trvzou la mz nabzdr. Nzrlxngiti-krdr mrbcnepwz, murde rblx nzlolvz-amqngi-krdrle mzli kc tqprtztingr nzkxpungr x nzatalzngr kcng tzvzpxmqng mz nzrlxngitingr. ");
INSERT INTO ntu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Drtc' ngr nibr ncngrbz drtwr ngrde leplz kcng drtwrdr tresz'tiu. Kxmule-esz' nzxlrlr natq Gct, a' trbrtiu drtwrdr. Murde nzaoti-zlwzkr drtwrdr dalr nrlc kxkqlu nzapulr lxbi kcng tqyrlvilvzolr nabzdr, x trpnzngr nardr. ");
INSERT INTO ntu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Drtc' kxmrlz drtwr ngrde leplz kcng nabzdr tzoliqtilr nzlxngiti-krdr natq Gct. Murde nztwzlr x nzlxngitilr natqde, x nra nzrlxngiti-krdr yc-zvzbz, mz nzvectr-krmlr leplz mz nzmnc-nqblq-krdr Gct. Kzdung mzli leplz kcng nzvectrplr nzpipzneng, kzdung mzli nzkqlung, x kzdung mzli nzkqlutx-zlwzng.” ");
INSERT INTO ntu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Mz nzaelwapxkr Jiszs kx Nrpakxmrlz na-apule zyzlr, rpibzle kx, “Lam trnztekatru sc tzalalvzope topla. X trnzawxbulzpwzu mz nabz da. A' lam nzadolzpwz wq, murde leplz namctr zyzlr mz nzdwatr-krmlr brma. ");
INSERT INTO ntu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mz nqmq lcpwz, kxmule-esz' Nrpakxmrlz trkrlzkapzle leplz amrlx, a' sa naopxbz badr kalr. Murde mzli lc, sa nayrplatitr nardr x na-aelwapx-ngrbzle da kx yc-kapqbepz badr. ");
INSERT INTO ntu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Doa kx yrplapx, na-abzle nztwz-krde drtwr ngr natq lc.” ");
INSERT INTO ntu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Rpi-mopwz Jiszs badr kx, “Na-aoti angidr drtwrmu natq Gct kc tqxlramu murde natwz-kzamu mz nzmnc-krmu. Mz nqmq kcpwz tqrka-ngrnamu, sa na-ayzlubz Gct bamu. A' nzrka-krde myaszlzle kxmu nzrka-krmu. ");
INSERT INTO ntu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Murde doa kx twzle natq Gct mz nzmnc-krde, sa natwz-moule nzyrplapxngr mz kzdung kz natq Gct. A' doa kx trtwzleu natq Gct mz nzmnc-krde, trnatwz-mouleu nzyrplapxngr. Kxmule-esz' nzrkrlzngr kx topwzne ycbz bade, a' sa nakatxpx-kzpz Gct bade.” ");
INSERT INTO ntu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jiszs pi-mopwzle kzdq nzycmne-ebzpxngr. Rpibzle kx, “Nzwzkr Gct mz nzvectr-krmle leplz bade mz nzngini-krde King rdr apule ncblo kx pe rtq wit mz nrlanc nyzde. ");
INSERT INTO ntu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mz nibrde sc tqaletipele kzdung kz nzwzngr. Mwi angidr mz nrlckxbq x traotipeu drtwrde rtq wit kcng tqpetile. Nzlvcpulzmqng x nzetulzmqng, a' ncblo kc tqpe, trkrlzleu kxmu nzyrlvzlz-krmlr. ");
INSERT INTO ntu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Murde drtc' esz'-krde kc tqwztr mz nzyrlvzlz-krmlr x nzpa-krdr. Da ayrnrngr kx yrlqbzle nzpa-bclz-krdr, x mz nibrde nztcngzlzkr nrpq nradr. Zbz nradr kcng tztutrpebzng. ");
INSERT INTO ntu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","X mzli kc tzbrpengr nradr, kx ngi nyz nrlanc lc otile toki scde, sc tqlakitilzpemleng, murde mzli r nzrkqngr nradr kaputrpem.” ");
INSERT INTO ntu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Zbz sc tqrpipebz Jiszs kx, “?Nzkqlukr leplz kcng namnclzbzng mz Gct kalr mz nzngini-krde King rdr apule nike? ?Nzycmne-ebzpxngr kznike takitrde nayokaetipx-ngrbole? ");
INSERT INTO ntu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Apule rtq nc seri kx peti ncblo mz drtc'. Kxmule-esz' topwz zlwz, ");
INSERT INTO ntu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","a' mz nibr kzdung mzli etulzm x sc tqngipe kzdq nounc kxetu. X utc kxkqlung nzmncng mz zmyo ngrde.” ");
INSERT INTO ntu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","34","Jiszs yapwxtibzle nzycmne-ebzpxngr kxkqlu kxmule lcng mz nzalvztr-krde leplz mz nrpa ngr Gct. Alvztrle zbo ngr leplz mz nzycmne-ebzpxngr txpwz, murde da kx takitrde nzyrplatitr-krbz nardr kxpipz nzalvztr-krde delc. A' mz nibrde, mzli kc namncpe-ngrdr esz'-krdr badr ncblo nedeng, sc tqyapwxtipebzleng drtwr ngr nzycmne-ebzpxngr lcng badr. ");
INSERT INTO ntu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mz zbq lcpwz mzli kc tqvzopengr nepi, Jiszs rpibzle mz ncblo nedeng kx, “Na-alilvckiopeku mz nrlar dxbu kc.” ");
INSERT INTO ntu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Zbz sc tzrlaszpelr zbo ngr leplz kcng x sc tzprtzpe-kzpzng mz bot kxetu kc tqwxbuope-ngrm Jiszs, x sc tzalilvcopeng. X kzdung kz leplz nzvo-nqblqopebzlr nidr mz bot kcng tzdwa-kzng mrkc. ");
INSERT INTO ntu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Zbz sc tzpwrkilvcpe-ngrdr kzdq nenq kxetu. Ebio kxnzetuting prtzm x nzvztiobzng mz nabz bot kc. X sc tzmulr naboopeng. ");
INSERT INTO ntu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","A' mzli lc Jiszs sc tqmwi mz mrtwz' kxrm, glz mz pilo. Nzvzbzng bade sc tzameopelr. Nzrpibzlr kx, “Kxakrlz, okatr nigu! Nabzpeku!” ");
INSERT INTO ntu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jiszs tulzm x lclvztxde nenq x ebio, rpibzle kx, “Esakiamu! Mnc-lrpiamu!” X mzli kcpwz nrwx kc tqvope. ");
INSERT INTO ntu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Zbz sc tqrpipebzle mz ncblo nedeng kx, “?Memule tqmwxlr-zlwz-ngrnamu? ?Trlxngitikalamu ninge?” ");
INSERT INTO ntu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","A' nzmwxlr-zlwzbeng, sc tzrpi-etrpelr kx, “Eke! ?Ncblo kznika? Nenq x ebio nzvz-nqblqlr natqde.” ");
INSERT INTO ntu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jiszs badr ncblo nedeng nzkaputrpzng mz nrlar Dxbu Gzlili mz nrlarnrlc kc tqycngr taon kcng nzpnu-esz', mrkc tzmncngr leplz kcng trngiulrJiu. X kzdq taon lcdeng dekc tqngi Gergesa. ");
INSERT INTO ntu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Mzli kcpwz Jiszs tqpoo-ngrmle mz bot, vzm bade kc ncblo kx mncpx-ngrm drka'. ");
INSERT INTO ntu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Dekc tqmncpx-ngrmle mz butqbr kx nzryrtzmqpx-ngrm namz ngr leplz. Apule ncblo kxayo, xplr-esz'ngrtx x rblx nzamnc-moungr nide x nzatolvangr. Nzwrde kqlupe kx nzpe-ngrbz mqde x nanycde mz nqvi x sen, a' zvz tqnikitileng x sa tqvz. ");
INSERT INTO ntu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Zvz, ngrlx x nrlckxbq, nzvzne-krde mz butqbr x mz nra, tqkabo x tqtakrti-lzbq mz rplz. ");
INSERT INTO ntu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kx mcpxmle kc Jiszs rlru, sc tqngrlrpebz, rweobz zpr bade mz nzangio-krdele. ");
INSERT INTO ntu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Rpibz Jiszs mz drka' kc kx, “Drka', prszpx mrlx la!” Sc tqnepe, tqrpipele kx, “Vrr! Jiszs, Mrlx Gct kc tqmyalz-esz'ngr! ?Nike tqotime? Esalzngr mz drtq Gct kx bzkq ayrplapxq nrkrdrtqnge!” ");
INSERT INTO ntu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jiszs veabz kx, “?Drtqm neke?” Rpibzle kx, “Drtqnge Siu Kqlu, murde kqlu-zlwzkr.” ");
INSERT INTO ntu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","X sc tqyrnititr-zvzbzle mz Jiszs kx bzkq atwzlr-ngrde nidr mz nrlarnrlc kzble. ");
INSERT INTO ntu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","X mnc-aepztrpz mrkc kzdq nrtrq r poi kxetu sc tzmung mz nra. ");
INSERT INTO ntu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","X drka' kcng nzyrnititr-mopwzlr mz Jiszs kx, “Atwzlr-ngrbz nigr mz nrtrq r poi kc, murde namncpx-alzupgr badr.” ");
INSERT INTO ntu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Zbz sc tqrlrpe-ngrbz Jiszs nzvz-krdr. Drka' kcng nzprsrpxlr mrlx kc x nzdwatr-alzung mz poi kcng. X nrtrq r poi kc, poi ngrde siu-li (2,000), tzngrlropeng mz nqngitrlqli, nztaong mz nabz dxbu kc, x nzboong amrlx. ");
INSERT INTO ntu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Zbz ncblo kcng tzaclveng, nzngrlrng sc tzpinepelr nrpa ngrde mz mztea x nabz nrlanc kcng. X leplz kxnzkqlung sc tzyrkrpebzng mz nzmc-krdr da kc tqprtz. ");
INSERT INTO ntu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nzvzmqng mz Jiszs x nzmcpelr ncblo kc tzprszpx drka' siu kqlu, wxbu-lrpipe, drtwrde opxpe, x pxipe. Kx nzmc leplz kxnzkqlule, sc tzmwxlrpe-ngrdr zmatq ngr Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Leplz kcng nzrmc-kaing da amrlx kcng tqprtz nzpinebzlr mz kzdung kz leplz be ngr Jiszs ncdr ncblo kc, x drka' x poi kcng. ");
INSERT INTO ntu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Zbz leplz kcng nzyrnitrpzlr mz Jiszs kx navzpe. ");
INSERT INTO ntu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mzli kc Jiszs naprtzpe-ngrde mz bot, ncblo kc tqamrlzle vzm bade sc tqyrnititrpebzle mz Jiszs kx navzng badr. ");
INSERT INTO ntu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","A' tr-rlrtx-ngrpwzu Jiszs. Rpi-alzupwzle bade kx, “Yzlubz mz lr mrnyzm x pibz badr da kxmrlz kc tqalebz Gct bam mz nzokatr-krde nim.” ");
INSERT INTO ntu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Zbz mrlx kc rkalzm x sc tqayotipele nrlarnrlc kc mz taon kcng nzpnu-esz'. Tqyapwxtinepele da kxmrlz kcng tqalebz Jiszs bade. X leplz amrlx kcng tzxlrbzlr nzyapwx-krde nzkctitxpxlr zmatq ngr Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jiszs badr ncblo nedeng nzalilvckio-moulr nrlar dxbu kc x zbo ngr leplz sc tzyrlwr-ngalelvzpe-moulr nide mz nabz drta'. ");
INSERT INTO ntu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Zbz kzdq ncblo drtqde Jaerzs sc tqkaputrpem. Nide kzdq kxetu r mangr-nzkrka'ngr. Rtctxo-lzbq-ngrbz mz nanyc Jiszs x sc tqyrnititrpebzle kx, “Inyxnge yagox x sc nabzpe. Vzm bagr x maletrpz nrkrdrtqde x sa namnc zpwx mou.” ");
INSERT INTO ntu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Zbz Jiszs sc tzvzpeng ncdr. Nzmncpxmqng mz mzlir leplz kxkqlu, kxnzrdrlvzti-lzbqng mz nzvz-krdr. ");
INSERT INTO ntu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Zbz kzdq olvz kx tresakiu nzrpwx-krde temz prtr-kzpz mz zbo ngr leplz kcng. Nzrpwx-alo-krde lc temz, twztipelele yiz nzpnu-esz'-nrade-li (12). ");
INSERT INTO ntu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nzabzpebz dckta kxnzkqlung nzamrlz-krbzlr nzetqkr drtqde, x trau scdeng yrkrtipe mz nzxpeti-krde nidr x lue kxpiz kxkqlu. Tzrpilr nzamrlzngr drtqde, a' trpnzngr. X sc tqetunepx zlwz. ");
INSERT INTO ntu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Olvz lc xlrle nrpa ngr nzamrlzkr Jiszs kxnzyagoxng. Sc tqrpipe drtwrde kx, “Nzmu namaletxtrpo ye lrpzde, drtqnge kc tqmrlzpe.” Sc tqrbinginetrpebz mz zbo ngr leplz kcng mz nibr Jiszs, x sc tqmaletrpebzle lrpzde. ");
INSERT INTO ntu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","X mzli kcpwz mepyr ngr drtqde sc tqmingrtrpe x tqxngipebzle kx drtqde mrlzpe. ");
INSERT INTO ntu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","X sc tqxngipe-kzpz Jiszs kx zmatq vzpxpem kcng mz drtqde x amrlzpele kzdq leplz. Lxlvrkimle mq x mzte kc tqvecpe mz nabz zbo ngr leplz kcng x sc tqveapebz kx, “?Neke tqmaletrple lrpznge?” ");
INSERT INTO ntu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ncblo nedeng nzayzlu-ngrbzlr natqde kx, “Rlr! ?Trmcwq zbo ngr leplz kang tqmncpx-ngrme? ?Memule tqveati-ngrn kx maletrpzle nim?” ");
INSERT INTO ntu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","A' Jiszs mzte sc tqvec zvz, murde namc-zpwxle leplz kc tqbxtrpzle lrpzde. ");
INSERT INTO ntu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Olvz kc kx krlztrpele mz drtqde nzmrlzpe-krde, sc tqrnrcnepxpebz mz zmwxlr. Kxmule-esz' mwxlr a' atuobz zpr mz Jiszs mz nzangio-krdele, x sc tqpipebzle da angidr kc tqveatile. ");
INSERT INTO ntu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Rpibz Jiszs kx, “Inyxnge. Nzlxngiti-krm ninge amrlzpele nim. Vzpe x bzkq da kx pnzpe drtwrm, nzmrlz-alo-krm lape.” ");
INSERT INTO ntu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mzli kc tqycmne-ngrbe Jiszs, kzdung ncblo kxnzatwzlr-ngrmqng mz ma nyz Jaerzs sc tzkaputrpemqng. Nzrpibzlr mz Jaerzs kx, “Kxetu, inyxm bzpe. Bzkq akxputipeq kxakrlz la.” ");
INSERT INTO ntu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","A' rpibz Jiszs bade kx, “Kxmule-esz', bzkq drtwrm talvzo, a' lxngiti ninge.” ");
INSERT INTO ntu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","X trpnzngr mou leplz kx rlr-ngrbzle nzvz-krdr badr, a' ngi txpwz Pita, Jemes, x mzlede Jon. ");
INSERT INTO ntu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kx nzkrlzbzlr kc ma nyz Jaerzs, sc tzxlrpelr nzyrni-katokr leplz kcng amrlx mrkc. ");
INSERT INTO ntu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nzdwatrpzng x sc tqrpipebzle kx, “Bzkq yrni-katopeamu. Doa lc trbzu, a' mwine ye!” ");
INSERT INTO ntu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","A' nzyrpalelvzlr nide. Mz nzmu-krde lcde, avztxpxleng yz amrlx ngrdr. X sc tzvztrpeng badr trte x lxe doa kc mrkc tqyrbqngr nide. ");
INSERT INTO ntu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Zbz malebzle mqde, sc tqrpipebzle kx, “Tzlitz, koum!” drtwr ngrde “Doa olvz lc, tulzm!” ");
INSERT INTO ntu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","X mzli kcpwz doa olvz kc tulzm x sc tqvznepe. Kx nzmc lxede x trtede da lc nzkctitxpxlr. (Yiz ngr doa olvz lc nzpnu-esz'-nrade-li.) ");
INSERT INTO ntu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","A' rngidrtxtr-ngrbz Jiszs badr kx bzkq nzlenedr nrpa ngr da kc. X rpi-kzpzle kx, “Kabzmu du dakxnzng namu doa la.” ");
INSERT INTO ntu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jiszs rkalzm mrkc, sc tzvzpeng badr ncblo nedeng mz mztea nyzde Naszret. ");
INSERT INTO ntu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kx krlzbzle kc Sabat, Jiszs sc tqvztrpe mz mangr-nzkrka'ngr nyzdr, mz nzalvztr-krde leplz nzkqlung kx nzlalztqng. X nzkctipxlr nzalvztr-krdeng. Zbz drtwrdr lctrpz bade murde mz nzobq-krdr nide ncblo txne a' alvztrle nidr apule kxrngisc zmatq. Sc tzveatipe-moulr nide mz nzrpi-etr-krdr kx, “?Myx me twzkimle nzalvztrngr lc? ?Nzyrplapxkr nar kznika tqycbz bade? ?Myx kxmu nzale-krde rkx kcng tqxlrkung? ");
INSERT INTO ntu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","?Trnipleu mrlx ncblo kc tqrlrmzti da kx wz-ngrdeng, mrlx Mxri? ?X trngiu mzledeng Jemes, Joses, Jud, x Saemon? ?X trngiu inwedeng lcng tqmncku badr mrka? Mrlx lc trngiu ncblo kxmatq.” Zbz sc tzpxpxpe-ngrdr nide x nzalvztr-krdeng, x trnzlxngiti-kzlru nide. ");
INSERT INTO ntu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Zbz sc tqrpipebz Jiszs badr kx, “Kxmule-esz' lr mztea amrlx nzamatqlr profet, a' lr mztea nyzde, x kxnginideng, x lr ma nyzdeng trnzamrluelru nide.” ");
INSERT INTO ntu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","X mz trnzlxngiti-krdru lc nide, rblxbz bade nzale-krde da kxmatq mrlcde, a' ngi txpwz nzbxtrkr mqde kxnzyagoxng kxnzpipzneng x nzmrlzng. ");
INSERT INTO ntu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jiszs kctitxpx-zlwzle trnzlxngiti-krdru nide. Mz nibrde Jiszs sc tqvzpe mz kzdung kz mztea mrlcde mz nzalvztr-krde. ");
INSERT INTO ntu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Zbz sc tqkqlepele ncblo nedeng kcng nzpnu-esz'-nrade-li (12). Mz nzmnclz-krbzlr bade, sc tqrkapebz badr zmatq ngr nzrmaszlrpx-krdr drka'. Mrlz, sc tqatwzlrpxpe-ngrdeng nzli-lxblrng mz mztea kxesz'. ");
INSERT INTO ntu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Rpibzle badr bzkq da kx natwzlr, da kx apule dakxnzng, bxli, x trau. A' nangi txpwz nctoko scdr, ");
INSERT INTO ntu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","x sadol ngr nanycdr. A' bzkq nzrtwzng lrpz krali. ");
INSERT INTO ntu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","X rpi-kzpzle badr kx, “Mztea kznike nzabrtzlvzlr nzmnc-krmu badr, ma kznike nzrlr-ngrbz namnc-ngrnamu, mncamu ma lcde esz', navz mzli kx rlasz-ngrnamu mztea lcde.” ");
INSERT INTO ntu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nzmu lr mztea kx trnzamnc-zpwxlru nimu x trnzlalztq-kzpwzung bamu, rlaszamu mztea la. X rtc-ngrbzmu rplz nakrlz-ngrdrle kx nqmq krdr trka mz nzapu-krdr kxnzmnc-mrbrng, x sa na-ayrplapx Gct nidr. ");
INSERT INTO ntu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Zbz ncblo neng Jiszs sc tzvzpeng mz mztea kxkqlu, mz nzpine-krbzlr mz leplz nztekqtr-krdr nqmq nr drtwrdr mz alwx ngrdrng. ");
INSERT INTO ntu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","X nzrmaszlrpxng drka' kxnzkqlu mz leplz, x nzamrlz-kzng kxnzyagoxng mz nzaelu-krdr nidr mz tolo. ");
INSERT INTO ntu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mz mzli lcng, nrpa ngr Jiszs x da kx aletileng xlrti kz King Herot Antipas, kc tqaclvele Provins kc Gzlili, murde leplz ngr mrkang kqlu sc tzycmnetr-ngrdr Jiszs. Kzdung nidr nzrpilr kx, “Mwx ncblo lc, Jon Kxawrkxtr elc, tulzpe-mop mz nzbzngr. Dekc tqale-ngrde rkx kcng tqmatq-esz'ngr.” ");
INSERT INTO ntu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mz drtwr kzdung leplz Jiszs nide Profet Elaeja kc tqaleti rkx kxkqlu mzli kc bqnc. X kzdung leplz nzrpilr kx nide profet kxmrna kx apule profet kcng bqnc tzrngiscng zmatq. ");
INSERT INTO ntu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kx xlr kz Herot nrpa ngr Jiszs, sc tqrpipele kx, “Jon Kxawrkxtr kc tqpibo mz ncblo ngr vea nengeng nalakipx-krbzlr narde, lupe mou.” ");
INSERT INTO ntu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Nzbzkr Jon kxmule sele. Herot twzle olvz r mzlede Filip. X Filip lc sc tqlube kx tqyrlzti Herot kc olvz rde. Drtq olvz lc Herodizs. A' Jon pi-zvzbzle mz Herot kx ngi-alwxbz mz Gct nzyrlzti-krde olvz r mzlede. Natq lc ngyangr drtwr Herodizs x rpile nanibq-ngrde Jon. Zbz Herot atwzlr-ngrde ncblo ngr vea nedeng, nzlolvzlr Jon x na-adwatrlr mz presin. A' rblx nznibqkr Herodizs le, murde Herot mrlue mz drtwrde Jon x krlzle kx nide ncblo kxmrlz x tr, dekc tqamnc-zpwx-ngrdele. Suti drtwrde nzvz-krbz Jon bade mz nzlalztq-krbzle mz nzryapwx-krde, kxmule-esz' narde tryrplatrpwzu mz natqdeng amrlx. ");
INSERT INTO ntu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","A' kzdq zbq mrkc tqpnz drtwr Herodizs mz nznibq-krde Jon sc natutrpe. Mz zbq kc tqkaputr-ngrm nzrmcngr mz Herot, alebzle kc nzmungr badr ncblo kxnzmatq nedeng x kxnzetung mz provins nyzde. ");
INSERT INTO ntu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Mzli lc tzyrlwr-ngrdr, nzabrtzlvzlr inyx Herodizs mz nzela-krbzle badr mz nzelangr kx batrpzle ncblo nzrkcmnzngr nide. Sc tqrpipebz King Herot mz doa olvz kc kx, “Nike suti drtwrm, rlxtim bange mzli ka, x sa nakabo bam. Nike narlxtime bange esalz-ngrne kx sa nakabo bam, kxmule-esz' kzdq nctq drtc' ka tqaclvex o dztungeng kxkqlu!” ");
INSERT INTO ntu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Zbz doa olvz kc sc tqvzpebz mz lxede, rpibzle kx, “?Nike narlxtibo mz King?” Rpibz lxede kx, “Rlxtibz nar Jon Kxawrkxtr.” ");
INSERT INTO ntu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Doa olvz kc ngrlrbz mz King, rpibzle kx, “Suti drtwrnge nalakipxbzme nar Jon Kxawrkxtr x katim dis bange mzli ka, mz nzkrlz-krnge kx bz-angidrpe.” ");
INSERT INTO ntu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","King Herot trsutiu drtwrde nznibq-krde Jon. Drtwrde vztx, a' ycakalqpe. Murde esalz lukurnrngr nzmu trnakapwzleu nike suti drtwr doa olvz kc, ngi da kx myangr drtqde mz mzlir kxnzetu kcng. ");
INSERT INTO ntu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","X sc tqatwzlrpe-ngrde kc ncblo ngr vea mz presin kx nalakipxbzle nar Jon. Ncblo ngr vea lc vz mz presin, sc tqlakipxpebzle narde. ");
INSERT INTO ntu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Zbz sc tqtwztipemle dis, tqkapebzle mz doa olvz kc. X tqtwzpebzle mz lxede. ");
INSERT INTO ntu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kx nzxlr oblamzng Jon nzrnibqngr nide, sc tzotipelr namz ngrde tzyrtzmqpelr mz gq kx nzwztrngr mz butqbr mz nra. ");
INSERT INTO ntu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ncblo neng Jiszs nzyzlumqng bade mz nibr nzwz-krdr mz nzalvz-krdr x nzamrlzti-krdr kxnzyagoxng, x sc tzpipebzlr bade da amrlx kcng tzalelrng x tzalvztr-ngrdrng. ");
INSERT INTO ntu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Zbz sc tqrpipebz Jiszs badr kx, “Narlasztx-kaiku ena zbo ngr leplz kang, navzku me yc-nrwxngr x na-amatxku.” Pibzle da lc murde trtxpengr scdr mzli kx namu-ngrdr x na-amatilr. A' leplz kxnzkqlung sc nzyrkrmqng mz Jiszs, tzvzmqng kcng x tzyzlung kcng. ");
INSERT INTO ntu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Zbz sc tzprtzpeng mz bot x tzalilvcopeng mz kzdq nrlc kx trngiu mztea murde namncng elr. ");
INSERT INTO ntu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","A' leplz nzkqlung nzmclr nzrkalz-krmlr x nzglxlr nidr. Zbz leplz lcng, nidr badr leplz ngr mztea kxkqlu ngr nrlarnrlc lcde, sc tzvzkipebzlr mepz, x nzmnc-kaing mrkc na-alilvckitrlr. ");
INSERT INTO ntu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Zbz mzli kc Jiszs tqvztrpe-ngrbzle mepz, sc tqmcpele zbo ngr leplz kcng tzyrlwrng tzaenzlilr nide. X sc tqyctx-zlwzpengr drtwrde nidr. Murde rblx nzokatr-lzbq-krdr mz nzkrlz-krbzlr Gct, a' nzapulr sip kcng trpnzngr kxaclvele nidr. Mz nzmu-krde lcde, kxmule-esz' Jiszs badr ncblo nedeng nzrpilr na-amang, a' alvztr-ngrde leplz lcng da kqlu. ");
INSERT INTO ntu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","A' mzli kcpe mz milzpq ncblo nedeng sc tzrpipebzlr bade kx, “Nrlc ycpe pipz nzbq-krde, a' trpnzngr me narmctingr leplz lcng dakxnzng. ");
INSERT INTO ntu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Atwzlrpengr nidr mz mztea x mz nrlanc kcng tzyctineng mrlang, murde naxpeng nadr dakxnzng.” ");
INSERT INTO ntu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","A' ayzlu-ngrbz Jiszs natqdr kx, “Nimu kx narkabz nadr dakxnzng.” Nzrpibzlr bade kx, “Rblx nzvz-krgr nzxpe-krgr dakxnzng kx natakitrde leplz lcng murde trau kqlu ela naxpengr.” ");
INSERT INTO ntu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Rpibz Jiszs badr kx, “Vzamu x mcamu kx yrlqamu dakxnzng tqlvr.” Nzmctxdr x sc tzpipebzlr bade kx, “Yctxpqng bagr bret nzlvqn x nc kxsupe li.” ");
INSERT INTO ntu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Zbz Jiszs sc tqrpipebzle badr kx na-awxbuong leplz mz nabr mz dzbedeng kx krlzbzle trtqki-esz' (100) x nzpnu-nzlvqn (50). ");
INSERT INTO ntu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mz nibr nzwxbuo-krdr, Jiszs kalzmle bret kcng nzlvqn x nc kcng li, x obqlz mz bongavz mz nzkrka'ngr, x sc tqawipebz mz Gct. Zbz lopxitile bret, x sc tqkapebzle mz ncblo nedeng, tzakipebzlr mz leplz kcng. Zbz aki-kzpzle nc kcng li mz leplz amrlx. ");
INSERT INTO ntu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","X nzmung x nelzdr krlctxtrpz. ");
INSERT INTO ntu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Mz nibr nzmu-krdr, ncblo nedeng nznulvzolr topla nzpnu-esz'-nrade-li mz nctq bret x nc kcng tqyctxo. ");
INSERT INTO ntu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","X mz nzrlwxngr ncblo txpwz krlzbzle siu-nzlvqn (5,000), a' trnzrlwxtrpwzu olvz x doa kxnztopwzng. ");
INSERT INTO ntu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mzli lcde, Jiszs pibzle mz ncblo nedeng kx naprtzng mz bot x na-alilvckio-kailr mz nrlar dxbu kc tqycngr mztea Betsaeda, mzli kc tqatwzlr-ngrde leplz kcng mrnyzdr. ");
INSERT INTO ntu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Mz nibrde, sc tqvzdzpe mz newz mz nzkrka'ngr. ");
INSERT INTO ntu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mz nina, ncblo nedeng sc tzmnctrpqng mz bot mz zpzu r Dxbu Gzlili, x Jiszs sc tqmncbe esz'-krde mepz. ");
INSERT INTO ntu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Zbz kzdq nenq kxetu sc tqwqpe x sc tzavzopelr nqni ngr bot scdr, x tzyapeng. Mz nibr nzkrka'kr Jiszs, mzli kc tqkya'pengr kio, sc tqmcpxbzle nzyalvzkr ncblo nedeng nenq lc, x sc tqvzpebz badr mz lue. X mz nzvz-krbzle lc rpile namyape-ngrde nidr. ");
INSERT INTO ntu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","A' mzli kc tzmc-ngrbzlr nzvzne-krmle mz lue, sc tzmwxlrpeng x tzneplapeng murde nzrpilr kx nzrmcpeng drka'. A' mzli kcpwz Jiszs sc tqycmnepebz badr. Rpibzle kx, “Ninge lc ye! Bzkq mwxlramu!” ");
INSERT INTO ntu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Zbz sc tqprtzpebz mz bot, x nenq kc tqamaope. X nzkctitxpx-pnzlr nide. ");
INSERT INTO ntu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Murde trnzkrlzti-angidrkalr nzrngisc-krde zmatq amrlx, kxmule-esz' nzmctipelr rkx kc tqalele mz nzapu-krde zbo ngr leplz. Nabzdr mqngibe nztwz-krdr drtwr ngr rkx lcng tqaletileng. ");
INSERT INTO ntu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Zbz sc tzalilvckio-moulr mz nrlar dxbu kc, sc tzkaputrpebzng mz nrlarnrlc kc tqycngr mztea Ganeszret, x sc tzadwatrpebzlr bot scdr mz nctq drta'. ");
INSERT INTO ntu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mzli kc tzpoope-ngrmlr mz bot kc, leplz ngr mrkc nzglxtx-pnzlr Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","X nzpine-anibzlr nrpa ngrde mz lr mztea amrlx ngr nrlarnrlc lcde. X drlvekeng vzkile, kxnzyagoxng nzglqtibzlr nqni bade. ");
INSERT INTO ntu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","X drlvekeng vzkile, mz mztea, mz taon, o nrlanc, leplz nzrglqtimqng kztedrng kxnzyagoxng me nzyrlwrpx-lxblrngr. X nzyrnititrpzlr bade kx narlr-ngrbzle mz kztedrng nzbxtrtx-krpwzlr nctq lrpz scde. X leplz kxnzyagoxng kcng tzbxtrpzlr lrpzde nzmrlzng amrlx. ");
INSERT INTO ntu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Nakrlzamu kx nigr lr Jiu rngiscgr kzdung nqmq kxyc pnz mzli kc bqnc. Kxnzalvztrng kxnzetung mz Lou sc Mosis nzyrlqlr nqmq lcng mz nzbatr-krbzlr mz leplz nzvz-nqblq-krdr Lou sc Mosis mz nzvz-nqblq-krdr nzalvztr-krdr. A' trpiu Lou sc Mosis kx leplz na-alelr da lcng. Murde nqmq lcng nzyrlqnetrpzlr leplz. A' Farzsi nzalvztr-ngrdr kx ncblo kx trvz-nqblqleu nqmq kr melrmqgrng, trvz-nqblq-kzleu Lou sc Gct. Kzdq nqmq kr melrmqgrng lcng rpile kx leplz naycpq-kailr mqdr mz lue, x sc tzmu-ateng. Mz nqmq lcpwz, mzli kc tzyzlu-ngrmlr me nzyrlwrpx-lxblrngr leplz kxkqlu, naycpq-kailr mqdr o nakipong, x sc tzmu-ateng. Nzalvztr-ngrdr kx navz-nqblqkr nqmq kr melrmqgrng lcng murde natubqbzkr mz nzobqkr Gct. X nzkqlung mz nigr nzvz-nqblqlr nqmq kqluti-moung mz nzrycpq-krdr da kx nzmutiong: kap, belue, baol, x tebol. Kzdq zbq kzdung Farzsi x kxnzalvztrng mz Lou sc Mosis nzvzkimlr mrkc Jerusalem mz nzrmcti-lzbq-krdr badr Jiszs. Ncblo lcng nzkrlzlr kx ncblo neng Jiszs trnzvz-nqblqlru nqmq kr lr Jiu mz nzrycpq-kaingr mq x ncblo kc tqmu ate. ");
INSERT INTO ntu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Zbz nzveabzng bade kx, “?Memule ncblo nemqng tzrnzlvzo-ngrdr nqmq krgung?” ");
INSERT INTO ntu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jiszs rpibzle badr kx, “Gct ycmnetr-ngrde leplz kx nzapulr nimu mz nzngi-batr-krbzle mz profet Asaea nzryr-krde kx, ‘Leplz lcng nzamrlue-txpwzlr ninge mz naodr. A' trnzvz-nqblqlru natqnge murde nqmq nr nabzdr yc-rlrup bange. ");
INSERT INTO ntu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nzangio-krdr ninge mane mz drtwrnge, murde nzrpilr da kcng tzalvztr-ngrdr leplz nzvzpxmqng bange. A' trtingr.’” ");
INSERT INTO ntu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Rpi-mopwz Jiszs kx, “Trvz-nqblqwamuu Lou sc Gct, a' krlang tqvz-nqblqamu nqmq kx nzyrlq leplz. ");
INSERT INTO ntu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Krlztx-angidramu nzrkatxpxngr lou angidr sc Gct, murde navz-nqblqpwzmu nqmq krmu. ");
INSERT INTO ntu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kzdq me aleki-kzamule nide sele: Gct rpile mz Lou kc tqkabzle mz Mosis kx, ‘Amrlue zvz trtem x lxem.’ x ‘Doa kx tramrlueleu trtede x lxede, a' pibqtile nidr, takitxtrpwzle nzrnibqngr.’ ");
INSERT INTO ntu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","A' rpi-alzu-ngrnamu kx takitrde doa trnzamrlue-krdeu trtede x lxede mz nzrlr-krbzle trau scde badr mz nzokatr-krde nidr, nzmu dzu r da kx naokatrle nidr yrlqpx-bekapele kx nangi blz kxtr sc Gct. ");
INSERT INTO ntu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","A' mz nzale-krmu da lc yrlqtxpxamu Lou sc Gct, murde navz-nqblqamu nzalvztr-krmu nqmq krmu. X vz zvz nzale-krmu da kxkqluting kx nzbatrpzlr mz leplz nzvz-nqblq-krdr nqmq kr melrmqmung x nzrpwa'-ngrbzlr badr nzvz-nqblq-krdr natq Gct.” ");
INSERT INTO ntu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Zbz Jiszs kqle-moule zbo ngr leplz kcng, sc tqrpipebzle kx, “Lalztq-angidrmamu bange x yrlqamu da kc napibo bamu. ");
INSERT INTO ntu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Da kcng tzyrlqtr mz nrkrdrtq leplz trnzbatrpwzlru trnztakitr-krdru nidr mz nzprtrngr mz nzangiongr. Trtingr. A' ngi da kcng tzvzpxmqng mz leplz kx nzbatrpzlr trnztakitr-krdru nidr. ");
INSERT INTO ntu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Doa kx yrplapx, na-abzle nztwz-krde drtwr ngr natq lc.” ");
INSERT INTO ntu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Zbz Jiszs badr ncblo nedeng sc tzrlaszpelr zbo ngr leplz kcng x tzdwatrpe-ngrdr kc ma. X sc tzveatipebzlr bade nike drtwr ngr nzalvztr-krde lc. ");
INSERT INTO ntu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Sc tqrpipebz Jiszs kx, “Rlr! ?Narmu tryrplatrkapz mz natq lc? Trngiu dakxnzng x mq kx trnzycpqu kx nzbatrpzlr trnztakitr-krdru leplz mz nzprtrngr mz nzangiongr. ");
INSERT INTO ntu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Murde vztr mz lzng kr leplz, x mz nibrde sc tqvzpxpe-mop mz nrkrdrtq.” Natq Jiszs lc drtwr ngrde kx takitrde nzmungr dakxnzng amrlx. ");
INSERT INTO ntu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","X sc tqrpipe-mopwzle kx, “A' da kx nzvzdzmqng mz nabz leplz, nidr lang tzbatrpzlr trnztakitr-krdru nidr mz nzprtrngr mz nzangiongr. ");
INSERT INTO ntu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Murde drtwr kxtrka lcng nzvzdzmqng mz nabz leplz. X nzmailzlr nidr mz nzale-krdr alwx lcde seleng: nzrkcmnzngr, nzdobungr, nzglqpx-lzbqngr, nzngqngungr, nzesabrtingr, nzrpibqtingr leplz, nzpnangr da, nzrnibqngr, drtwr kxmwa, nzrmwimingr leplz kx trngiu krnalzdr, nzamqmiti-rbrngr mz nrkrdrtq, x kzdung kz da kxtrka. ");
INSERT INTO ntu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Da kxdrka'ngr lcng amrlx nzvzdzmqng mz nabz leplz x alwx lcng nzbatrpzlr trnztakitr-krdru leplz x trnztubq-krdru mz nzobqkr Gct.” ");
INSERT INTO ntu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Zbz Jiszs badr ncblo nedeng nzrlaszlr Gzlili Provins, x sc tzvzkipelr mz nrlarnrlc kc Fonisiz mrkc Siriz Provins, mz taon kc etu Taea. Provins lc nyz leplz kxtrngiulrJiu. Mz drtwr Jiszs namnc-nrwxngr mrlc murde trpnzngr kx naglxle nide. A' nrpa ngr nzkaputr-krbzle ani txpwz nztalvzpx-krde mrkc. ");
INSERT INTO ntu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Kzdq olvz lr Taea, kx xlrle kc nrpa, sc tqvzpem bade, murde inyxde kxtopwz mncpx-ngrm drka' kxtrka. Olvz lc trngiulrJiu, sc tqyrngzopebz bade mz nzyrnitr-krbzle nzmaszlrpx-krbzle drka' kc mz inyxde. ");
INSERT INTO ntu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jiszs ycmnebz bade mz kzdq nzycmne-ebzpxngr kx, “Doa kxnztopwzng namu-kaing. Murde trmrlzu nzoti-krbzme dakxnzng nandr x kabzme mz kuli.” ");
INSERT INTO ntu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Rpibz olvz kc kx, “Kxetu, kxmule-esz', a' nzrlr-ngrbz mz kuli nzngq-krdr dakxnzng kc tqtao mz nabz tebol.” ");
INSERT INTO ntu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jiszs rpibzle bade kx, “Nzayzlu-krme natqnge mrlzvxitx! Vzpe ma nyzm murde drka' kc rlaszpele inyxm.” ");
INSERT INTO ntu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","X mzli kc tqkrlz-ngrbzle ma nyzde, sc tqmcpele inyxde nzaonepxpe-krde drtqde mz bet nyzde. Drka' kc rlaszpele nide. ");
INSERT INTO ntu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Zbz Jiszs badr ncblo nedeng sc tzrlaszpe-moulr taon Taea. Sc tzo-ngalekipemlr nrlarnrlc nyzdr leplz kcng trngiulrJiu x nzkrlzbzlr taon Saedon, x nrlarnrlc kc mztea nzpnu, mz nzyzlu-krdr Dxbu Gzlili. ");
INSERT INTO ntu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kzdung leplz nzvzmi-moplr kc bade kzdq ncblo kx nradrtqde ngq x nzycmne-krde tropxu. Nzrlxtibzlr bade nzyrlqo-krbzle mqde mz ncblo kc murde namrlz mou. ");
INSERT INTO ntu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jiszs vzmitxpxle ncblo kc rlru mrkc tzyrlwr-ngrdr zbo ngr leplz kcng. X yrlqtrpzle nratoki r mqde mz nradrtq ncblo kc, byatx x bxtr-kzpzle nalzpqde. ");
INSERT INTO ntu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","X mz nzyckr drtwrde nide, krka'lz mz bongavz, x rpibzle kx, “Lvxpx!” Natq lc nzrpibz lr Jiu kx, “Efata!” ");
INSERT INTO ntu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mzli kcpwz nradrtqde kc tqxlrpe x nzycmne-krde otxpx pnz kz. ");
INSERT INTO ntu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Pibz Jiszs mz leplz kcng bzkq nzpititxnedr da lc. Kxmule-esz' rpwa'-zlwz-ngrbz Jiszs nzpine-krdrle, a' sc nzyapwxtitx-zlwzlr. ");
INSERT INTO ntu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","X mzli kc tzxlrpe-ngrdr leplz nrpa, nzkctipxlr x sc tzrpipelr kx, “Jiszs da amrlx kx aleleng mrlzvxi esz'ngr! Amrlzpeleng leplz kcng nradrtqdr tqngq x krkcng tqrblx nzycmne-krdr.” ");
INSERT INTO ntu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mzli trboiu mz nibr nzyzlu-krmlr Dxbu Gzlili, kzdq zbo ngr leplz kxetu nzvz-mopqng mrkc tqmncngr Jiszs. X mz nibr kzdung zbq dakxnzng nadr kc tqyrkrpe. Jiszs kc tqkqlepele ncblo nedeng x tqrpipebzle badr kx, ");
INSERT INTO ntu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Yctxpe mz drtwrnge leplz lcng. Murde nzmnctipemlr bagu mrka zbq tqpe x dakxnzng nadr yrkrtxpe. ");
INSERT INTO ntu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Trmrlzu nzatwzlrtxngr nidr mz nelzdr kxbrtale, ma mztr tqtclvrne mz lrpzki, murde kzdung nidr nzvzkimlr rlru.” ");
INSERT INTO ntu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ncblo nedeng nzrpibzlr bade kx, “Trpnzngr me nzxpe-ngrgr dakxnzng kx natakitrde leplz lcng mrka.” ");
INSERT INTO ntu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","A' Jiszs veabz badr kx, “?Bret tqlvr kx ycbz bamu?” Nzrpibzlr kx, “Rlimz.” ");
INSERT INTO ntu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Zbz Jiszs rpibzle mz leplz kcng amrlx nawxbuong. Zbz otitxde dapu bret kcng rlimz, awitx-ngrbzle mz Gct, lopxititxdeng, x sc tqkatipebzle mz ncblo nedeng tzakipebzlr mz leplz kcng amrlx. ");
INSERT INTO ntu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","X yc-kzpz badr kcng nc kxtopwzting. Zbz awi-kz-ngrbzle nc kcng x rpibzle badr kx na-aki-kzpzlr mz zbo ngr leplz kcng. ");
INSERT INTO ntu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Leplz kcng amrlx nzmung x nelzdr krlc. X nzatakqtilr mulide kcng tqyctxo x nznulvzo-ngrdrle topla kxetu rlimz. ");
INSERT INTO ntu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Zbz sc tqatwzlrpengr Jiszs leplz kcng mz mztea nyzdrng mz nibr nzmupe-krdr amrlx ngrdr. Ycpwz pipz nzkrlz-krbzle siu-pwx (4,000) mz ncblo txpwz kcng tzmung mz zbq lcma. ");
INSERT INTO ntu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Mzli lcde, sc tzprtzpeng mz bot badr ncblo nedeng x sc tzalilvckiopelr mz nrlarde kc Dalmanuta. ");
INSERT INTO ntu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Zbz kzdung Farzsi nzvzmqng x sc tztalwzpeng badr Jiszs. Nzrlxtibzlr bade nzale-krde kzdq da kxmatq mz nzaelwapx-krde kx vzpx-angidrm mz Gct. ");
INSERT INTO ntu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","A' Jiszs nabzde talvzotx murde nzpxtxpx-ngrdr nike aelwapxpe-ngrbz Gct badr. X rpibzle badr kx, “Trpengr nzaelwapx-krbo rkx kc tqrlxtiamu.” ");
INSERT INTO ntu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Zbz Jiszs badr ncblo nedeng sc tzalilvckiopelr mztea Betsaeda. ");
INSERT INTO ntu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","16","Mz nzalilvcobe-krdr dxbu, Jiszs rpibzle badr kx, “Rngidrtioamu yisti sc Farzsi x King Herot.” Zbz sc tzycmnetrpe-ngrdr, x mz nzxlr-krdr kc yisti, mz drtwrdr Jiszs kc tqycmne-ngrbzle lc murde trnzrtwzne-krdru bret, x bret esz'txu kx ycnebz badr mz bot. ");
INSERT INTO ntu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kx xlrbz Jiszs nike tzycmnetr-ngrdr, sc tqrpipebzle badr kx, “?Nike tqyc-zlwzngr mz drtwrmu trnztwzne-krmuu bret? ?Myx kxmule, trkrlzkalamu? ?Drtqmu sa nzrtwzngr nikeng aelwapx-ngrbz Gct bamu? ");
INSERT INTO ntu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Opxm kx trpnzngr mzpu x trpnzngr nradrtqmu. Murde mrbrtr mz drtwrmu rkx kcng tqmctipeamu. ");
INSERT INTO ntu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","?Mzli kc tqlopxiti-ngrne bret kcng nzlvqn, tqapu-ngrne ncblo kcng siu-nzlvqn (5,000), topla tqlvr kx nulvzoamu muli dakxnzng kcng tqyctxo?” Nzrpibzlr kx, “Nzpnu-esz'-nrade-li (12).” ");
INSERT INTO ntu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Rpi-mopwz Jiszs kx, “Dela. ?X mzli kc tqlopxiti-ngrne bret kcng rlimz tqapu-ngrne ncblo kcng siu-pwx (4,000), topla tqlvr kx nulvzoamu muli dakxnzng kcng tqyctxo?” Nzrpibzlr kx, “Topla rlimz.” ");
INSERT INTO ntu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jiszs rveabz badr kx, “?Myx kxmule, mz drtwrmu alvztr-ngrne nimu bret o nzalvztr-rbrkr Farzsi?” ");
INSERT INTO ntu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mzli kc tzkrlzpe-ngrbzlr mztea Betsaeda, kzdung leplz nzvzmimlr kc ncblo kx mzte kcba mz Jiszs x nzyrnititrpzlr bade nzmaletr-krbzle drtqde. ");
INSERT INTO ntu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jiszs malebzle mqde, vzmitxpxle rlru mz mztea kc. Zbz byatrpz mz mzte x yrlqtr-kzpzle mqde mz mzte. Jiszs rveabz bade kx, “?Myx kxmule, rmcpeq da?” ");
INSERT INTO ntu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mrlx kc obqlvxtxde nrlc x sc tqrpipele kx, “Eu, mcpex leplz, a' tropx-angidrka nzmc-krnge nidr. Nzapunebelr nounc kxnzvzneng.” ");
INSERT INTO ntu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Zbz Jiszs yrlqtr-mopwzle mqde mz mzte. X mzli lc mzte kc tqopx ate x tqrmc-angidrpe. ");
INSERT INTO ntu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jiszs rpibzle bade kx, “Vzpe, a' mz nzvz-krm bzkq tavaunetrq mz mztea mz nzvz-krm ma nyzm.” ");
INSERT INTO ntu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jiszs badr ncblo nedeng nzrlaszlr Gzlili Provins x sc tzvzdzpeng x nzvztrng mz nrlarnrlc kc tqycngr mztea Sisaria Filipae. Mzli kc tzvzne-ngrbzlr mz lrpzki, Jiszs rveabz badr kx, “?Myx kxmu nzglxkr leplz ninge?” ");
INSERT INTO ntu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nzrpibzlr kx, “Kzdung leplz nzrpilr kx nim Jon Kxawrkxtr yzlupe-mop mz nzbz-krde. X kzdung nzrpilr kx nim profet Elaeja yzluope-mop Heven. X kzdu-kzng leplz nzrpilr kx nim dq profet kxmyalz kc bqnc.” ");
INSERT INTO ntu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Zbz rpibzle badr kx, “?A' nimu, myx kxmu nzglx-krnamu ninge?” Rpibz Pita kx, “Nim Kxnzmcpx!” ");
INSERT INTO ntu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","A' Jiszs rngidrlvz-ngrbzle badr kx trkrlzkapzle mzli r nzyapwxtine-krbzlr mz leplz nzngini-krde Kxnzmcpx ne Gct. ");
INSERT INTO ntu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Zbz Jiszs alvztr-ngrde nidr da kx naprtzbz bade mz nzngini-krde Mrlx Leplz. Rpile kx drtqde sa na-aetqbz mz da kxkqluting. X kxnzetung r lr Jiu sa napxtxpx-ngrdr nide, krlcng lrtzlvz ngrdr, kxnzetu rdr pris, x kxnzalvztrng mz Lou sc Mosis. X sa nanibqlr nide. A' mz zbq kratq mz nibr nzbz-krde, sc tqlupe mou. ");
INSERT INTO ntu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nzpi-krbzle badr da lc opx angidr. A' katxpxm Pita mz kztedeng x vzmitxpxle rlru kxpipz. X rpibzle bade kx, “Bzkq kxmu nzycmne-krm lc.” ");
INSERT INTO ntu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","A' Jiszs lxlvrbz x obqtxbz mz ncblo nedeng, sc tqpnanatipele Pita. Rpibzle kx, “Esopx Pita! Bzkq apume bange Setzn. Murde nzrkrlz-krm vz-nqblqle drtwr leplz, a' trngiu me pnz drtwr Gct.” ");
INSERT INTO ntu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Zbz Jiszs kqlele ncblo nedeng badr leplz kcng amrlx, x rpibzle badr kx, “Doa kx navz-nqblq-angidrle ninge, narlrpx-lzbq mz nzaetq-ngrbz drtqde. X naesablqtile me pnz drtwrde esz'-krde, x bzkq axtxbzle nzo-zli-krde lrpzki rnge. ");
INSERT INTO ntu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Murde doa kx otr-zvzngr drtwrde nzlu-krde, sa namale-lvile nzlungr kxboi. A' doa kx yrlqtxole nzlu-krde murde lxngitile ninge x Nrpakxmrlz, sa naprtr mz nzlungr kxboi. ");
INSERT INTO ntu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mane nznginingr bcnyr mz nrlc ka x amrbrtxtrle nzlu-krde mz nrlc kc navzm. ");
INSERT INTO ntu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Murde trpnzngr da mz nrlc ka kx takitrde nzxpepx-krde nzlungr kxboi. ");
INSERT INTO ntu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Leplz ngr nrlc ka nidr kxdrka'-ngrng kcng trnzangiolru Gct. Krkcng tzpxtxpx-ngrdr ninge x natqngeng mz nzngini-krnge Mrlx Leplz, sa napxtxpx-kz-ngrne nidr mzli kc nayzlu-ngr-mopwc' mz nzvzmi-krmc enjrl kxnztrng mz zmatq ngr Trtenge.” ");
INSERT INTO ntu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Zbz rpibz Jiszs badr kx, “A' da angidrtx lc napibo bamu. Kzdung nimu sa nalubeng mzli kc Gct na-aelwapx-ngrde zmatq ngrde mz nzvectr-krmle leplz mz nzmnclz-krbzlr bade mz nzngini-krde King rdr.” ");
INSERT INTO ntu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","3","Mz nibr zbq kcng esz'mz, Jiszs vzmile Pita, Jemes x Jon, x sc tzvzdzpeng mz kzdq newz kxetu mz nzmnc-krdr esz'-krdr. Mzli lcpwz, ncblo lcng nztqng nzobqbzng nrkrdrtq Jiszs tekqtr-lzbqpe mz zluli x lrpz scde prkitxpxpe x aglqpz'pe, myaszpxle lrpz kxprki mz nrlc tulvzo. ");
INSERT INTO ntu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Zbz nzmclr Mosis nidr mz Elaeja, profet kcng bqnc, nzycmne-krdr badr Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Mz nibrde sc tqrpipebz Pita mz Jiszs kx, “Kxakrlz, mrlztx angidr nzmnc-krgu mrka. Mwx nawztibzkr du matelq natq, nangi nyzm dq, nangi nyz dq Mosis x nangi nyz dq Elaeja.” A' krlc tqycmne-ngrbz Pita lc, murde nidr badr kztedeng nzmwxlr-zlwzng x trkrlzleu da kx napile. ");
INSERT INTO ntu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Zbz kzdq dcbz akqlvztxde nidr mz zmyo ngrde. X natq Gct vzpxm mz dcbz kc, rpibzle badr kx, “Krlc mrlxnge Kxnzmrlzti. Lalztqbzmu bade.” ");
INSERT INTO ntu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mz nibr natq lc, nzobq-mopwzng, Jiszs kc tqtutxpepwz mrkc esz'-krde. ");
INSERT INTO ntu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mzli kc tzvzneobe-ngrmlr mz newz kc, rpibz Jiszs badr kx bzkq nzpinedr nike nzmclr nakrlz-zpwxbzle nztulz-kr-mop Mrlx Leplz mz nzbz-krde. ");
INSERT INTO ntu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yc-lrpi mz nabzdr esz'-krdr, a' vz zvz nzveati-etr-krdrle kx nikeng tqpnz drtwr Jiszs mz nztulz-kr-mople mz nzbzngr. ");
INSERT INTO ntu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Zbz sc tzrpipebzlr mz Jiszs kx, “?Nike kxnzalvztrng mz Lou sc Mosis tzrpi-ngrdr kx profet Elaeja nayzluo-kaip mrka mz nrlc x Kxnzmcpx kc tqvz-atem?” ");
INSERT INTO ntu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jiszs ayzlu-ngrbzle natqdr kx, “Kxnzalvztrng nztubq-angidrng mz nzrpi-krdr kx Elaeja navz-kaip mz nzoliqti-krde da amrlx. A' trnzaopxpwzu badr kx Nzryrngrkxtr rpi-kzle kx Mrlx Leplz na-aetqbz drtqde x naobqszo nide x na-atrkati nide. ");
INSERT INTO ntu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","A' napibo bamu kx ncblo kc tqngi Elaeja vzpem. A' leplz nzatrkati-kzlr nide, da kc tzwai nzatrkati-krdr Elaeja kc bqnc, mz nzvz-nqblqngr Nzryrngrkxtr.” ");
INSERT INTO ntu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mzli kc Jiszs badr Pita, Jemes x Jon tzkrlzope-ngrmlr nou newz kc, sc tzrmctipelr zbo ngr leplz kxetu tzyrlwr-ngalelvzlr ncblo nedeng kcng tzmnclzbzng mrkc. X sc tztalwzti-lzbqng badr kxnzalvztrng mz Lou sc Mosis. ");
INSERT INTO ntu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mzli kc leplz kcng tzmcpe-ngrdr Jiszs, nzkctipxlr x sc tzngrlrpebzng bade x tzelalvzpelr nide. ");
INSERT INTO ntu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jiszs rveabz badr kx, “?Nike tqtalwzti-lzbq-ngrnamu?” ");
INSERT INTO ntu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kzdq ncblo rpibzle kx, “Kxakrlz, vzmimc mrlxnge mrka mz nzamrlz-krbzme nide, murde drka' kc tqmncpxm bade tr-rlr-ngrpwzleu bade nzycmne-krde. ");
INSERT INTO ntu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","X mzli kznikeng drka' lc dwasz-ngrde nide, sc tqprtilzpe nimz x tqrtctxope-ngrde mz drtc', vz vz nqbya ngr naode tqwxbutxtrpebz, madqlvztxde nqngide, x sc tqlulwxkz'pe. Rlxtibo mz ncblo nemqng nzmaszlrpx-krbzlrle, a' rblxtile nidr.” ");
INSERT INTO ntu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jiszs rpibzle kx, “?Nike nawai-mopwc' bamu? Nzmnc-krbo bamu mzli boipe! A' trkrlzkalamu nzrlxngitingr x narmu kc tqmqngibe. Vzmimamu doa la bange.” ");
INSERT INTO ntu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Zbz sc tzvzmipebzlr bade. A' mzli kc drka' kc tqmcpe-ngrbzle Jiszs, sc tqprtilzpe nimz tqrnrcpe x sc tqrtcope-ngrde mz drtc'. Sc tqtaligxpe x nqbya ngr naode kc tqwxbutrpebz. ");
INSERT INTO ntu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jiszs veabz mz trte doa kc kx, “?Myx mzli kx dwa-ngrbz zyagox lc bade?” Rpibzle kx, “Abzo pnz mzli kc tqtopwzbe-ngrde. ");
INSERT INTO ntu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Vz zvz nzngi-batr-krbz drka' lc nztalz-krde mz nyr x nztao-krde mz nabzde kxlr, murde rpile nanibqle nide. Nayc mz drtwrm nigr x okatrp nigr, nzmu kx tqkrlzq nzale-ngrbz da bade.” ");
INSERT INTO ntu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Rpibz Jiszs bade kx, “?Nike tqrpi-ngrme kx nzmu krlzx? Trpnzngr da kx rblxbz mz doa kxnzlxngitilr Gct.” ");
INSERT INTO ntu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","A' trte doa kc ani txpwz nzrpi-krbzle kx, “Eu, lxngiti-angidrx. A' okatr-kzp ninge mz nzngrgokr nzrlxngiti-krnge.” ");
INSERT INTO ntu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Mzli kc Jiszs tqmc-ngrde leplz kxnzkqlung tzngrlr-ngrmlr bade mz nzmc-krdr nike tqalele, sc tqpnanatipele drka' kc mz nzrpi-krbzle kx, “Drka' ngr nzangqngr nradrtq x nzanabukr leplz, rngidrlvz-ngrbo bam prszpx doa la x bzkq dwatr-mopwzme bade!” ");
INSERT INTO ntu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Zbz drka' kc sc tqnepe, x sc tqrtcope-ngrde doa kc mz drtc'. Zbz sc tqprszpxpele nide. Doa kc sc tqyrbqtxpe mrkc mz drtc' trycngrlrpeu x apupele kxbzpe. Kxnzmc leplz kxnzkqlung le, sc tzrpipelr kx, “Doa la bzpe.” ");
INSERT INTO ntu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","A' mz nzkrlzkr Jiszs kx doa kc mrlztx-angidrpe, rtrngztiobzle mqde x sc tqokatrpele nztulz-mou-krmle. ");
INSERT INTO ntu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Zbz mzli kc Jiszs badr ncblo nedeng tzmncpxpe-ngrmlr mz kzdq ma, nzveabzng bade kx, “?Nike tqrblxti-ngrde nigr nzrmaszlrpxngr drka' kc?” ");
INSERT INTO ntu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Rpibz Jiszs kx, “A' drka' kxmule la nzmaszlrpxpwz mz nzkrka'ngr vzmi nzaxtxngr dakxnzng.” ");
INSERT INTO ntu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jiszs badr ncblo nedeng nzrlaszlr nrlarnrlc kc tqycngr mztea Sisaria Filipae x sc tzvzkitrpelr Gzlili Provins. Jiszs trsutiu drtwrde nzkrlztikr leplz me mnc-ngrde. ");
INSERT INTO ntu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Murde rpile namnc-txpwzng esz'-krdr badr ncblo nedeng mz nzalvztr-krde nidr. Pibzle badr kx, “Ninge Mrlx Leplz sa na-aprcbz mz zmatq ngr kxnzmwati drtwrdr ninge. Nanibqlr ninge, a' mz zbq kratq mz nibr nzbz-krnge, ninge kc tqtulzpe-mopwc'.” ");
INSERT INTO ntu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","A' ncblo nedeng trnzkrlzlru drtwr ngr nzrpi-krde kx Kxnzmcpx sa nabz. A' naodr mya nzveati-krbzlr drtwr ngrde. ");
INSERT INTO ntu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mz nibr nzyzlu-kr-mop Jiszs badr ncblo nedeng mztea Kzpznizm, sc tzvztrpeng mz ma kc tzmnc-ngrdr. Zbz Jiszs rveabz badr kx, “?Nikeng tqycmnetr-ngrnamu mzli kc tqvz-ngrmgu mz lrpzki?” ");
INSERT INTO ntu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","A' naodr mya nzayzlu-krbzlr natqde, murde tztalwzti-lzbq-ngrdr neke kx myatxpxbz mz nzobq-krde. ");
INSERT INTO ntu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","X sc tqawxbupele aposol kcng, tqrpipebzle badr kx, “Mrlx kx nangi doa kxmyalz, na-avzo-lzbq x nawztrpz mz kztedeng amrlx.” ");
INSERT INTO ntu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Zbz vzmibz Jiszs kc doa kxtopwz, atubzle mz mzlirdr. X lolvztrple doa kc bade x rpibzle badr kx, ");
INSERT INTO ntu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mrlx kx vz-nqblqle ninge mz nzabrtzlvz-krde doa kxtopwz mz drtqnge, abrtzlvz-kzle ninge. X krkc tqabrtzlvzle ninge, trabrtzlvzleu ninge esz'-krnge, a' abrtzlvz-kzle Trte kc tqatwzlr-ngrmle ninge.” ");
INSERT INTO ntu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Zbz Jon rpibzle bade kx, “Kxakrlz, mckr kc ncblo kx rmaszlrpxngr drka' mz drtqm. A' pibzkr bade kx naesakipe, murde trprtrpuu bagu.” ");
INSERT INTO ntu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","A' rpibz Jiszs kx, “Bzkq rpwa'-ngrbzmu bade! Mrlx kx alele da kxmatq mz drtqnge, rblxbz bade nzpibqti-krde ninge. ");
INSERT INTO ntu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Murde mrlx kx tr-rpwa'-ngrmleu bagu nzale-krgu nzwz-krgu, tukile mz nrlarde nyzgu. ");
INSERT INTO ntu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Da angidrtx lc napibo bamu. Mrlx kx rkabz mqmu lue mz nzngini-krmu doa nengeng, sa nakabz Gct bade da kxmrlz mz nzabrtzlvz-krde nide. ");
INSERT INTO ntu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Aclvetio-lzbq murde ma tqatrkatiq nzrlxngitikr doa neng Gct. Murde Gct sa na-ayrplapx-zlwzle ncblo kx ataole mz alwx doa kxpobe mz nzrlxngitingr. Nzayrplapxngr nide namyaszlzle mrlx kx nzpetrpz rplz kxetu mz drtwrde x nzrtcongr prla me boongr. Mwx mrlz nzrnibqngr nide mz nrlc ka mzli kc tratrkatika-ngrde nzrlxngitikr doa ne Gct, myaszpxle nzayrplapx-alokr Gct nide mz alwx lc kalr. ");
INSERT INTO ntu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","48","Mz nzmu-krde lcde, aclvetio-lzbq kz murde ma tqatrkati-lzbqq. Mz mzli r nzatalzngr dwatx ani. Mz nzatalzngr kx batrpzle nztao-zvz-krm mz alwx, katxpx-lzbqm bade. Nzvztr-krm Heven kalr myaszpxle nzmnc-nrwx-krm mz nrlc ka. X nzaetq-krm drtqm mz nzmncngr kxtubq mz nrlc ka, myaszpx-zlwzle nzprtr-krm mz Hxl kalr, mrkc nzayrplapxkr Gct kxnzaleng alwx tresakiu apule be kc trbzu, x nzetqkr drtqdr tryrkrpxpwzu apule nyr kx ngctx alo. ");
INSERT INTO ntu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kxmule-esz', a' mz nrlc ka nzkxpu-krmung nzapulr nyr mz nzalqngi-krdr nzrlxngiti-krmu. ");
INSERT INTO ntu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nzkxpungr lcng mrlz. A' rblx nzlolvz-amqngi-krmu nzrlxngiti-krmu nzmu napxtxpx-ngrnamu nzatubqtingr kc navzpxm mz nzkxpungr lcng. Rlr-ngrbzmu nzkxpungr lcng nzatubqti-krdr nimu murde namnc-zpwx-mouamu badr kztemung.” ");
INSERT INTO ntu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Zbz Jiszs badr ncblo nedeng nzrlaszlr mztea Kzpznizm mrkc Gzlili Provins x nzvztrng Judiz Provins mz nrlar LueJodzn kc tqprkilzm nepi. X kzdq zbo ngr leplz nzvz-mopqng bade mrlcde, x Jiszs sc tqalvztrpele nidr, da kc tqwai-zvzle. ");
INSERT INTO ntu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kzdung Farzsi nzvzmqng mz Jiszs mz nzatalz-krdr nide mz nzale-krde kzdung da kxvz-rbr. Nzveatibzlr bade kx, “?Nzpnzkr drtwrm le, Lou sc Gct rlrpx-ngrde ncblo nzaxtx-krde olvz rde?” ");
INSERT INTO ntu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jiszs rvea-mopwz badr kx, “?Myx kxmule nike pi Mosis mz nzaxtxngr?” ");
INSERT INTO ntu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nzrpibzlr kx, “Mosis rlrpx-ngrde. Murde rpile kx nzmu ncblo nayrbzle dq letz mz olvz rde, napibzle kx nzaxtx-lzbqpeng ncdr x sc tqatwzlr-ate-ngrde nide.” ");
INSERT INTO ntu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Rpibz Jiszs kx, “Mosis yr-ngrde natq lc murde leplz nzdrka'-ngrng x nardr mqngi. ");
INSERT INTO ntu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","A' Gct aelwapx-ngrde me pnz drtwrde mzli kc tqwz-ngrde nrlc. Murde Nzryrngrkxtr rpimle bagu kx mzli lc ayrnrngr, ‘Gct wz-ngrde ncblo esz' x olvz esz' mz nzmnctr-lxblr-krdr.’ ");
INSERT INTO ntu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Delc mzli kc tzetupe-ngrdr, nayrlzng. X nzamatq-lzbq-krdr namyaszpxle nzamatq-krdr kxnginidrng. X ncblo namnctr-amqngipebz mz olvz rde. ");
INSERT INTO ntu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Murde doa lcng li nznginipedr nrkrdrtq x leplz kxesz'.’ X napibo bamu kx trnzlipeung, a' nznginipedr leplz kxesz'. ");
INSERT INTO ntu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mz nzmu-krde lcde, trpnzngr leplz kx takitrde nzakipx-krde krkcng tqaxvctrpeng Gct mz nzyrlzngr.” ");
INSERT INTO ntu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mz nibrde, mzli kc tzmncnepe-ngrdr esz'-krdr brma badr ncblo nedeng, nzveati-mopwzlr bade nike drtwr ngrde. ");
INSERT INTO ntu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Rpibzle badr kx, “Mzli kc ncblo nzaki-lzbq-ngrdr mz olvz rde x yrlzti-moule kc olvz kzble, olvz krali lc trngiu olvz rde angidr, murde mz nzobqkr Gct sa tqyrlztibele olvz rde kc ayrnrngr. Mz nzmwimi-krde olvz krali lc, ayzprtxde nzesalz-krbzle kc mz olvz rde kc ayrnrngr mz nzyrlzngr mz mz Gct. ");
INSERT INTO ntu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","X kxmu-kzle lc mz olvz kx axtxde ncblo ngrde x yrlzti-moule kc ncblo kzble.” ");
INSERT INTO ntu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kzdq zbq kzdung leplz nzvzmimlr doa kxnztopwzng mz Jiszs mz nzmaletr-krbzle nrkrdrtqdr x nzamrlz-krde nidr. A' ncblo nedeng nzlclvzlr leplz lcng. ");
INSERT INTO ntu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","A' mzli kc tqmc-ngrbz Jiszs, drtwrde ngyatx. Sc tqrpipebzle badr kx, “Bzkq rpwa'-ngrbzmu mz doa lang tztopwzng nzvz-krmlr bange. Murde leplz kxnzmulr lcng nzlxngitilr Gct mz nzngini-krde King rdr. ");
INSERT INTO ntu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","X trpnzngr nzmnclz-krbzmu mz Gct mz nzngini-krde King rmu nzmu kx trapuwamuu doa lcng.” ");
INSERT INTO ntu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Zbz sc tqbrlctipele doa kxnztopwz kcng mz mqde, yrlqo-ngrbzle mqde badr, x sc tqamrlztipele nidr. ");
INSERT INTO ntu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Zbz mzli kc Jiszs badr ncblo nedeng narkalzpe-ngrmlr, kzdq ncblo ngrlrm mz Jiszs, atuobz zpr bade, x rveabz bade, rpibzle kx, “Kxakrlz, krlzx kx nim ncblo kxmrlz. ?Nike na-alex mz nztwz-krnge nzlungr kxboi?” ");
INSERT INTO ntu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Rpibz Jiszs bade kx, “?Memule tqrpi-ngrme bange mrlzx? Murde trpnzngr kxmrlz, a' ngi txpwz Gct esz'-krde. ");
INSERT INTO ntu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Krlzq natq kcng tqkapx Gct. Krlcde seleng: ‘Amrlue zvz trtem x lxem. X bzkq kx narnibq. Bzkq kx narmwimi doa kxtrngiu krnalzde. Bzkq kx napna da. Bzkq kx narpokiati leplz. Bzkq kx naryrlqpx da kx nakabz mz leplz.’ X kzdung kz da mou kxnzmulr lcng.” ");
INSERT INTO ntu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","A' rpibz ncblo kc kx, “Kxakrlz, abzo pnz mzli kc tqngini-ngrne obla vz-nqblq-angidrx natq lcng amrlx.” ");
INSERT INTO ntu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jiszs obqtxbz mz ncblo kc mz nzmrlzti-krde nide. Zbz rpibzle bade kx, “Mrbrpxbep da esz' kx na-aleq. Amwa mclrm amrlx x kabz trau rde mz leplz kx trpnzngr scdr. Nzmu na-aleq da lc, nzrngiba-krm namyalz mou mrkc Heven. Vzm x vz-nqblqm ninge.” ");
INSERT INTO ntu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mzli kc ncblo kc tqxlr-ngrbzle natq Jiszs, drtqde blotx pnz x sc tqvztxpe, drtwrde vztx zlwz. Murde nzrngiba-krde etu x trsutiu drtwrde nzalvetx-krdeleng mz nzvz-nqblq-krde Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jiszs obqlvztxde nrlc, zbz rpibzle mz ncblo nedeng kx, “Rblxtx-atwrnr-ngrbz mz leplz kx nzrngiscng nzmnclz-krbzlr mz Gct, murde trnzkrlzlru kx nzmnc-xglelr nide mz da amrlx!” ");
INSERT INTO ntu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nzpwrkilvc-ngrdr natqdeng. A' Jiszs rpi-mopwzle kx, “Doa nengeng, rblxtx-atwrnr-ngrbz mz leplz nzmnclz-krbzlr mz Gct. ");
INSERT INTO ntu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel trkrlzleu nzdwatr-krde mrkc tqmrplxngr nidil. X nzrblxkr kxnzrngiscng nzmnclz-krbzlr mz Gct myaszpxle da lc.” ");
INSERT INTO ntu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ncblo nedeng nzpwrkilvc-zlwz-ngrdr natqde x nzrpibzlr bade kx, “E kx tqmule lcde, trpengr kx narlapx!” ");
INSERT INTO ntu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jiszs mzte aprtxbzle badr x rpibzle kx, “Rblxbz mz ncblo, a' tr-rblxpwzu mz Gct. Murde trpnzngr da kx rblxbz bade.” ");
INSERT INTO ntu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Zbz rpibz Pita bade kx, “Rlaszpekr dztugrng amrlx mz nzvz-nqblq-krgr nim.” ");
INSERT INTO ntu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Rpibz Jiszs kx, “Napi-angidrbo bamu. Mrlx kx rlaszpxle ma nyzde, o mzledeng, o inwedeng, o lxede, o trtede, o doa kxnztopwz nedeng, o drtc' nyzdeng mz nzvz-nqblq-krde ninge x nzlepx-krde Nrpakxmrlz, ");
INSERT INTO ntu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Gct sa naxpe-moule nide nzwrde nangi trtqki lxblr (100) mz nikeng rlaszpxle. Mz nrlc ka sa natwz-moule du ma nyzde, mzledeng, inwedeng, lxedeng, doa kxnztopwz nedeng x drtc' nyzdeng, vzmi nzatrkati-zlwzkr leplz nide murde vz-nqblqle ninge. X mz nrlc kc navzm, sa natwz-kzle nzlungr kxboi. ");
INSERT INTO ntu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","A' nadcpx mz drtwrmu kx kzdung leplz kxnzetung mz nrlc ka, sa nangi leplz txneng mz nrlc kc navzm. X kzdung leplz txneng mz nrlc ka, sa nanginidr kxnzetung mz nrlc kc navzm.” ");
INSERT INTO ntu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mzli kc tzvz-ngrdr mz lrpzki mz nzvzkilz-krdr Jerusalem, Jiszs rtwayzbz mz leplz amrlx kcng tzvz-nqblqlr nide. X ncblo nedeng nzmwxlr-zlwzng murde nzkrlzlr kx kxnzetu r lr Jiu nzrpilr nanibqlr nide. Zbz katxpxmle nidr, vzmitxpxleng rlru kxpipz x sc tqpipe-mopwzle badr nikeng naprtzbz bade. ");
INSERT INTO ntu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Rpibzle badr kx, “Ninge Mrlx Leplz. X mzli kc nakrlztr-ngrbzku Jerusalem, sa nakaobz ninge mz mq kxnzetu r pris x kxnzalvztrng mz Lou sc Mosis. Zbz navzmibzlr ninge mz Kansrl x drtwrdr sa naesz'ti kx nabzx. Zbz nakao-mopwzlr ninge mz doa lr gzpman ngr Rom kxtrngiulrJiu mz nzrnibqngr ninge. ");
INSERT INTO ntu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","X lr Rom lcng naxtrnga-ngrdr ninge, nabyatilr ninge, naviplalr ninge x nanibqlr ninge. A' mz zbq kratq ninge kc tqlupe-moux.” ");
INSERT INTO ntu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zbz Jemes x Jon, mrlx Sebedi kcng nzling, nzvzbzng mz Jiszs x nzycmneng badr. Nzrpibzlr kx, “Kxakrlz, nayc mz drtwrm nigr x kam bagr nike suti drtwrgr.” ");
INSERT INTO ntu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jiszs rveabz badr kx, “?Nike suti drtwrmu na-alebo bamu?” ");
INSERT INTO ntu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nzrpibzlr kx, “Mzli kc na-amrluengr nim mz nzngini-krm king, rlr-ngrm bagr nzwxbukr kzdq nigr mz nrlarm kxrtc, x kzdq nigr mz nrlarm kxmc, mz nzngini-krgr kxnzetung kxnzmyapxbzng.” ");
INSERT INTO ntu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","A' rpibz Jiszs badr kx, “Trkrlz-angidrwamuu nike tqrlxtiamu! ?Krlzamu nzprtrngr mz nzetqkr drtq kc naprtilzle ninge? ?X narlrpx-lzbq-ngrnamu mz da kznike naprtzbz bamu, da kc nawaix mzli lc navztrp?” ");
INSERT INTO ntu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nzayzlu-ngrbzlr natqde mz nzrpi-krbzlr kx, “Eu, krlzkr nzalengr da lc!” Zbz rpibz Jiszs badr kx, “Da zpwxtx, drtqmu la naetq kz, da kc nawai nzetqkr drtqnge. ");
INSERT INTO ntu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","A' trpnzngr scnge zmatq mz nzka-krbo me matq lcng. Murde Trtenge kx rmcpxpwz krkcng nawxbuong mz tron lcng.” ");
INSERT INTO ntu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mzli kc tzxlr-ngrbz kztedrng da kc tzrlxtilr, drtwrdr kc tqlctrpebz mz Jemes x Jon. ");
INSERT INTO ntu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Zbz Jiszs sc tqkqlepele nidr amrlx ngrdr, x rpibzle badr kx, “Krlzamu kx king mz nrlc ka nzrtulrtr-ngrbzlr mz leplz nzalengr da mz nzmnclz-krbzlr badr. ");
INSERT INTO ntu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","A' bzkq mz nimu. Murde doa kx rpile namyapxbz mz nimu mz nzaclve-krde leplz nengeng, nawztrpz bamu. ");
INSERT INTO ntu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","X doa kx nangi kxetu kxmyalz, na-avzo-lzbq x nawz-nrbalqtrpz mz leplz amrlx. ");
INSERT INTO ntu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ninge Mrlx Leplz. X kxmule-esz' ninge kxetu rmu, a' vz-ngrmc mz nrlc mz nzwztr-krbo mz leplz, a' trngiu leplz kx nawztrpqng bange. X vz-ngrmc nzrlrpx-krbo nzlu-krnge mz nzxpepx-krbo leplz kxnzkqlung mz zmatq ngr nzbzngr.” ");
INSERT INTO ntu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mz nzvz-krdr kc Jerusalem, nzvztrng mz mztea Jeriko. X mzli kc tzrlaszpe-mou-ngrdr Jeriko, nzyrkr-nqblq zbo ngr leplz kxetu. X mz nrlar lrpzki lc tzo-zlilr, wxbu zvz elr kc ncblo kx mzte kcba, drtqde Batimezs, mrlx Timezs, mz nzrlx-krbzle trau mz leplz. ");
INSERT INTO ntu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mzli kc tqxlrpe-ngrde kx Jiszs kc Naszret sc tqvz mz lrpzki, sc tqnepxpe mz nzrpi-krde kx, “Jiszs, Mrlx Devet, nayc mz drtwrm ninge!” ");
INSERT INTO ntu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Leplz kcng nzlclvzlr nide x nzrpibzlr namnc-lrpi. A' sc natqde tqaetunelz zlwz, mz nzrpi-krde kx, “Mrlx Devet, nayc mz drtwrm ninge!” ");
INSERT INTO ntu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jiszs kc tqtupe, tqrpipebzle mz leplz kx, “Kqlebzmu, navzm mrka.” Sc tzkqlepelr ncblo kc mzte tqkcba x tzrpipebzlr bade kx, “Tulzm x drtwrm naelalzm, murde nide la tqkqlemle nim!” ");
INSERT INTO ntu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Zbz Batimezs aotxole lrpz ngr zbao, tutxlz-anim x sc tqvzpebz mz Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jiszs rpibzle bade kx, “?Nike suti drtwrm na-alebo bam?” Rpibzle kx, “Kxetu, naobq-moux.” ");
INSERT INTO ntu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Zbz rpibz Jiszs bade kx, “Vzpe. Murde nzlxngiti-krm ninge dela tqamrlz-angidrpele nim.” X mzli kcpwz mzte obqtxpx pnz. X sc tqvz-nqblqpe-kzle Jiszs mz lrpzki. ");
INSERT INTO ntu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jiszs badr ncblo nedeng nzkrlzbzlr mztea kcng li Betpeji x Betzni mrkc mz Newz ngr Nc Olivi. Mrlc esotrpebz Jerusalem. Sc tqrpipebzle mz kzdung ncblo nede nzling kx, ");
INSERT INTO ntu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Vznamu mz mztea lcmonr tzmcpz. Mzli kc navztr-ngrbzmu, sa namcamu kzdq nei dcngki kx nzatolvangr kx trnzvonekangr. Yokaepxamu x vzmimamu. ");
INSERT INTO ntu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nzmu kx tzrpibz kzdu leplz, nike tqvzmi-ngrnamu dcngki la, rpibzmu kx, ‘Suti drtwr Kxetu.’ X mzli lcpwz sa na-atwzlr-ngr-mople mrka.” ");
INSERT INTO ntu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ncblo kcng nzli nzvzng. Sc tzmcpelr dcngki kc nztu-krde mz lrpzki, nzpetr mz kzdq nrlar naonrx ngr ma. ");
INSERT INTO ntu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mzli kc tzyokaepx-ngrmlr nqvi lrde, kzdu leplz kx nztung mrlcde sc tzrveapebzng kx, “?Memule tqyokaepx-ngrnamule la?” ");
INSERT INTO ntu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Sc tzpipebzlr natq Jiszs kcng tqpibzle badr, x sc tzrlrpe-ngrbzlr nzvzmi-krdrle. ");
INSERT INTO ntu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nzvzmimlr dcngki kc mz Jiszs, nzprlxobzlr nzkq scdr mz nibr dcngki kc x Jiszs sc tqwxbuopem elr. ");
INSERT INTO ntu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Leplz nzkqlu nzprlxtiolr nzkq ngr zbao scdr mz lrpzki mrkc navokipx Jiszs. X kzdung nzrplameitipxmqng nabx nc paam, nzprlxlvzti-kzlr lrpzki. ");
INSERT INTO ntu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Leplz kxkqlu kcng tzrtwayzng x krkcng tzvzbzng mz nibr Jiszs, sc tzkabo-katomipelr kx, “Hosana! Glqpxkr King Kxnzmcpx kc tqvzm mz drtq Yawe. ");
INSERT INTO ntu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nim King kc tqmcpx Gct, tqvzpxm mz nqvi lr melrmqgr Devet! Gct, ngrlvzkr nim kc tqmyalz-esz'ngr!” ");
INSERT INTO ntu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jiszs votr Jerusalem, zbz sc tqvztrpe Mangr-nzangiongr Yawe. Kx obqlvztile da amrlx elr, sc tzyzlupe-moung mztea Betzni murde nrlc milzpqpengr. ");
INSERT INTO ntu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nrlc kx ngrlxobzle mz nourla x sc tzrlaszpelr Betzni. Jiszs nelzde brtale. ");
INSERT INTO ntu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kx nzvzbzlr kc mz lrpzki, mcle kc nc fiki kxyrlvi. Mz drtwrde sc tqdo kz, a' kx vztrpzle trpnzngr nrade kx mclzbzle, murde trngiu mzli r nzpakr nc fiki. ");
INSERT INTO ntu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Sc tqrpipebz Jiszs mz nc fiki kc kx, “Trpnzngr doa kx namu mou nram.” X ncblo nedeng nzxlrbzlr nzpi-krdele. ");
INSERT INTO ntu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kx nzkaputr-mopwzlr kc Jerusalem, Jiszs vztr mou Mangr-nzangiongr Yawe. X sc tqmaszlrpxpe-ngrde leplz kcng tzxpeting x tzamwating dalr nzrkangr blz. X alzngubzle tebol nyzdr lr Jiu kcng tztekqtrpzlr trau r mrkzbleng mz trau r Mangr-nzangiongr. X alzngu-kzpzle da kx nzwxbulvzo leplz kcng tzamwang nran kx nangi blz. ");
INSERT INTO ntu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","X rpwa'-ngrbzle mz leplz kxnzkqlung mz nzrprwi-krmlr mz makoa ngr Mangr-nzangiongr mz nzvz-krdr mz kzdq nrlarde ngr mzteadau. ");
INSERT INTO ntu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Sc tqalvztrpeleng, rpibzle kx, “Nzyro mz Nzryrngrkxtr rpi Gct kx, ‘Ma nyznge nangi ma ngr nzkrka'kr leplz ngr mrkcng kqlu mz nrlc.’ A' apusr-ngrnamule me nzamwangr da kc tqangqnguti-lzbq-ngrnamu!” ");
INSERT INTO ntu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kx nzxlr kxnzetu rdr pris x kxnzalvztrng mz Lou sc Mosis da kc tqale Jiszs, sc tzyrlqpelr drtwr ngr nzrnibqngr nide. Murde nzdobutilr nide mz nzkctipxkr leplz amrlx nzalvztr-krde x nzabrtzlvzlr nide. ");
INSERT INTO ntu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","X mz milzpq lcng, Jiszs badr ncblo nedeng sc tzrlaszpe-moulr Jerusalem. ");
INSERT INTO ntu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nrlc ngrlxobz mz nourla, Jiszs badr ncblo nedeng nzkrlz-moplr nc fiki kc tqlcbqle. X nzmcpelr kx nzglrnedz-krmle kc mz dzbrde, krlztxlzle wq. ");
INSERT INTO ntu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita dcpx mz drtwrde nike pitrpz Jiszs mz nounc kc mz zbq kc kai, sc tqrpipebzle kx, “Kxarklz, mc ena, nc fiki kc tqlcbqq, leu rde glrtipe!” ");
INSERT INTO ntu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Rpibz Jiszs badr kx, “Nabrti drtwrmu Gct. ");
INSERT INTO ntu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Da angidr lc napibo bamu. Mzli kznike rlx-ngrbzmu da mz Gct, bzkq drtwrmu li. A' drtwrmu nabr kx sa na-ayzlu-ngrbzle natqmu, x delc natwz-ngrnamu nike rlxtiamu. Apule mrlx kc tqpibzle mz newz kc kx, ‘Brkalzm x tao prla mz zmatq ngr Gct.’ X Gct sa narlr-ngrbzle bade nike rlxtile. ");
INSERT INTO ntu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mz nzmu-krde lcde, da kznike kx rlxtibzmu mz Gct, sa nakabzle bamu, nzmu nalxngitiamu kx sa natwzamu da lcde. ");
INSERT INTO ntu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","A' mzli kc tqkrka'-ngrnamu, naipq-kaiamu leplz kx ngyati drtwrmu, x Trtemu kc Heven sa naipq-kzle nimu x nakabzle nike rlxtiamu. ");
INSERT INTO ntu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","A' nzmu trnaipqwamuu leplz, Trtemu kc Heven tripq-kzleu nimu mz alwx ngrmung.” ");
INSERT INTO ntu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jiszs badr ncblo nedeng nzvz-moung Jerusalem. Kx nzvznedr kc Mangr-nzangiongr Yawe, kxnzetu rdr pris, kxnzalvztrng mz Lou sc Mosis x lrtzlvzng, nzvzmqng mz nzvea-krbzlr bade. ");
INSERT INTO ntu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nzrpibzlr kx, “?Neke rkabz bam zmatq mz nzale-krm da lcng tqaleq?” ");
INSERT INTO ntu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Rpibz Jiszs badr kx, “Sa napibo me twzkimc zmatq kc tqale-ngrne da, nzmu na-ayzlu-kaipamu nzvea-krbo bamu. ");
INSERT INTO ntu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","?Pimamu bange, zmatq ngr nzawrkxtrkr Jon kaom Gct o kabz ncblo?” ");
INSERT INTO ntu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Sc tztalwzpeng mz nidr esz'-krdr, tzrpipelr kx, “Nzmu narpiku kx, ‘Zmatq kx kaom Gct,’ sa narpimle kx, ‘?E memule trlxngiti-ngrwamuu natqde?’ ");
INSERT INTO ntu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","A' nzmu narpiku kx, ‘Zmatq kx kabz ncblo,’ namwxlrtiku leplz kxnzkqlung ma tznibqlr nigu, murde nzlxngitilr kx Jon nide profet.” ");
INSERT INTO ntu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Zbz sc tzrpipebzlr mz Jiszs kx, “Trkrlzkru.” Rpibz Jiszs badr kx, “X ninge kz trpengr nzpi-krbo me twzkimc zmatq kc tqwz-ngrne.” ");
INSERT INTO ntu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Zbz sc tqyapwxtipebz Jiszs nzycmne-ebzpxngr lc. Rpibzle mz leplz kcng tzmncng Mangr-nzangiongr kx, “Kzdq ncblo petile kc nrlanc ngr grep. Lvztrle bz ngrde, oliqtile kc da kx narwzngr waen, x wz-ngrde kz kc me na-aukzngr mz nrlanc kc. Zbz sc tqrlrpe-ngrbzle mz ncblo kx narbilqng, kx naxpebzlr bade kzdung nra grep mz nrlanc lc. Zbz sc tqrlaszpele mrnyzde, vzpe rlru mrkzble. ");
INSERT INTO ntu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Zbz mzli kc tqbrpengr grep, sc tqatwzlrpe-ngrbzle kc kxnzawz nede kx nayzlumibzle du nra grep kx nangi mqde. ");
INSERT INTO ntu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ncblo kc tqatwzlr-ngrbzle, kx krlzbzle kc ncblo kcng tzrbilqng nrlanc, sc tzlolvzpelr nztztxdr x sc tzayzlu-nrbalqpelr. ");
INSERT INTO ntu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Zbz Kxetu kc atwzlr-ngr-mopwzle kc kxnzawz nede badr. A' nzdwatibz ncblo kcng tzrbilqng, nztakrtibzlr narde x nzamyatibzlr drtqde. ");
INSERT INTO ntu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Zbz atwzlr-mou-ngrbzle kc kxnzawz, krlc nzotibzlr nznibqlr. Mz nqmq lcpwz, kxnzawz kxkqlu kx atwzlr-ngrbzle badr, nztztilr kcng x nznibqtilr kcng. ");
INSERT INTO ntu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ncblo kc mncbepz bade doa esz'txu kx na-atwzlr-mou-ngrbzle badr. Krlc mrlxde kx mrlzti-zlwzle. Sc tqatwzlrpe-ngrbzle, murde mz drtwrde rpile kx, ‘Ncblo kcng na-amrluebzlr mrlxnge x sa nakabzlr du bade nra grep kx nangi dalr nzrbilqngr.’ ");
INSERT INTO ntu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","A' kx nzmc ncblo kcng nide, sc tzrpi-etrpelr kx, ‘Mrlx kxetu kc tqrnginyz nrlanc ka nide ka. Nanibqpeku nide, x da nyz trtede sa nangi nyzpegu.’ ");
INSERT INTO ntu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nzlolvzlr nide, nznibqlr x nrkrdrtqde nzrtctxpx-ngrdr mz nibr bz ngr nrlanc kc. ");
INSERT INTO ntu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“X krlzpeamu da kx na-alebz ncblo kc tqrnginyz nrlanc! Sa navzm nanibqtile ncblo lang. X nrlanc kc sa nakabzle mz ncblo kzbleng.” ");
INSERT INTO ntu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Jiszs rpi-mopwzle kx, “Zpwxtx! Krlz-angidramu Nzryrngrkxtr lc tqrpile kx, ‘Rplz kc etu tzpxtxpx-ngrdr ncblo kcng tzrwz-ngrng ma, nzaelwapxngr kx nide nou rplz kc tqmyatxpx-zlwzbz. Da lc Yawe kxrwzngr. X abrtztx-zlwz-ngrgu.’” ");
INSERT INTO ntu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Zbz kxnzrmailzng ngr lr Jiu nzkrlztrpebzlr kx nzyapwxkr Jiszs lc tutrpz badr, x nzrpilr nalolvzpe-ngrdr nide. A' nzmwxlrtilr zbo ngr leplz ma drtwrdr tzngya. Zbz sc tzrlaszpelr nide. ");
INSERT INTO ntu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mzli kc Jiszs tqmncbe-ngrde Mangr-nzangiongr, kxnzrmailz ngr lr Jiu nzatwzlr-ngrbzlr bade kzdung Farzsi x kzdung leplz ngr dzbede kc mz Herot. Nzrpilr naesabrtilr Jiszs mz nzycmnengr murde nalolvzlr nide. ");
INSERT INTO ntu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nzvzbzng nzrpibzlr kx, “Kxakrlz, krlzkr kx nike piq x alvztr-ngrn tubq zvz. X krlz-kzkr kx tu-amqngi-zvzq mz nzalvztr-krbzme nqmq kr Gct mz leplz, kxmule-esz' trna-abrtzlvzu kxnzetung. Mz nzmu-krde lcde, pim ena bagr. ?Tubq mz Lou sc Mosis nzxpe-krbzku takes mz King r Rom o trtingr? ");
INSERT INTO ntu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","?Naxpeku o bzkq?” A' mcplxtrpebz Jiszs drtwrdr mz nzatalz-krdr nide. Murde mz nzrpi-krbzle ‘Eu,’ lr Jiu lcng nangyati drtwrdr nide mz nzokatr-krde enqmi rdr. X mz nzrpi-krbzle ‘Trtingr,’ ncblo ne Herot nalolvzlr nide mz nzxpqbrlr-krde lou sc gzpman ngr Rom. Delc tqrpi-ngrbzle kx, “?Memule tqrpi-ngrnamu na-atalz-ngrnamu ninge? Kamamu dq ena srlrni namcx.” ");
INSERT INTO ntu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nzkabzlr kc x sc tqveapebz kx, “?Mqngr nar nelc tqmnztr mz srlrni lc, x drtq nelc tzyrtr elr?” Nzrpibzlr kx, “King r Rom.” ");
INSERT INTO ntu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Zbz Jiszs rpibzle kx, “Mz nzmu-krde lc, kabzmu mz king da kx takitrde king x kabzmu mz Gct da kx takitrde Gct.” X ncblo kcng nzkctitxpxlr natqde, murde trprtz-pnzu mz trtxki scdr. ");
INSERT INTO ntu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kzdung Sadiusi nzvzmqng mz Jiszs Mangr-nzangiongr. Nidr kzdq dzbe lr Jiu kx trnzlxngitilru nztulz-ngr-mop mz nzbzngr. Nzveatibzlr da kx na-atrkati-ngrbzlr nzalvztr-krde mz nztulz-ngr-mop mz nzbzngr. ");
INSERT INTO ntu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Nzrpibzlr kx, “Kxakrlz, Mosis yrpxle kzdq lou kx nangi scgu. Rpile nzmu ncblo kx bzszle olvz rde x trpnzngr nedr doa, mzlede nayrlzti-alzule olvz kc. Murde nzrngine-krdr doa na-apule kx ngi doa ne mzlede kc tqbzpe. X doa lc natekqtrle nzmrbrpx-krbz nqvi lr ncblo kc x natwzle dztudeng. ");
INSERT INTO ntu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nzmu narpingr kx kzdung mzle-lzbq nzrlimzng. Mzledr kc etu yrlz. Zbz mzli trboiu sc tqbzpe, trpnzngr nede doa. ");
INSERT INTO ntu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Zbz mzledr krali yrlzti-alzule olvz kc, x bz kz trpnzngr nede doa. X wai-kzle mzledr kratq. ");
INSERT INTO ntu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Vz, vz, olvz kc nzyrlzti mzle-lzbq kcng nzrlimz, x trpnzngr nedr doa. X mz nibrde olvz kc sc tqbzpe kz. ");
INSERT INTO ntu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Alvztr-ngrn kx leplz tulz-mop mz nzbzngr. ?Kx tqmule lcde, neke nartwz olvz kc mzli kc natulzngr mou leplz amrlx? Murde mzle-lzbq kcng rlimz nzyrlztilr nide. ?Myx kxmule, Gct batrpzle mz olvz lc nzxpqbrlr-krde natqde mz nzyrlzti-krde ncblo kcng rlimz mz mzli kxesz'?” ");
INSERT INTO ntu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jiszs ayzlu-ngrbzle natqdr kx, “Nzao-krmu drtwrmu vz-rbrtx atwrnrngr. Murde tryrplatitru narmu zmatq ngr Gct x drtwr ngr Nzryrngrkxtr. ");
INSERT INTO ntu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mzli kc Gct na-alu-ngr-mople leplz mz nzbzngr, sa na-apupelr enjrl kcng tzmncng Heven. Trnzyrlzpeung, x trpnzngr nzyrlz-mou-krdr kalr. ");
INSERT INTO ntu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","X Mosis aelwapx-ngrde kx krkcng tzbzpeng sa na-atulzmqng mz nzlungr. Murde krlz-angidramu natq Mosis mz be ngr nounc kc tqmrbz tqwou. Mzli lc Gct tqrpi-ngrbzle mz Mosis kx, ‘Ninge Gct ngr Ebraam, Aesak x Jekop.’ ");
INSERT INTO ntu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kxmule-esz' ncblo lcng tq nzbz-pnzng, a' trpileu kx nide Gct ngrdr mzli kc pnz. Murde nibede Gct ngrdr mz nzlu-krdr Heven mzli ka. Delc mrkc tqpnzki drtwrmu le vz-rbrtx atwrnrngr.” ");
INSERT INTO ntu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mzli kc dzbe Sadiusi tztalwzti-lzbq-ngrdr badr Jiszs, kzdq kxalvztr mz Loukxtr rpibzle mz Jiszs kx, “?Lou kznike myaszpxle lou amrlx?” ");
INSERT INTO ntu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ayzlu-ngrbz Jiszs natqde kx, “Lou kx myapxbz nide sele, ‘Lxngitiamu, nimu lr Israel. Murde Yawe nide Gct rgu. X Yawe nide Gct kc esz'txu. ");
INSERT INTO ntu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Doa kx esz' mz nimu namrlztiq Yawe, Gct rmu mz nabzm atwrnrngr, x mz nzwikr nelzm atwrnrngr, x mz drtwrm atwrnrngr, x mz zmatq ngrm atwrnrngr.’ ");
INSERT INTO ntu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","“Lou krali nide sele. ‘Mrlzti kztemqng da kc tqwaiq nzmrlzti-lzbq-krm.’ Trpnz-moungr lou kx nzmyaszpxlr lou lcng li.” ");
INSERT INTO ntu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kxalvztr mz lou kc rpibzle mz Jiszs kx, “Eu, da zpwxtx la tqpiq. Yawe nide Gct kc esz'txu x trpnzngr mou gct kzble. ");
INSERT INTO ntu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","X namrlztiq nide mz nabzm atwrnrngr, x mz drtwrm atwrnrngr, x mz nzxplr-krm atwrnrngr. X namrlzti kztemqng da kc tqwai nzmrlzti-lzbq-krm. Da lcng li nzmyaszpxlr nzrka-ngrbz da mz Gct x mz nzangc-ngrbz blz bade.” ");
INSERT INTO ntu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kx xlrbz Jiszs nzycmne-angidr-krde, sc tqrpipebzle bade kx, “Opxm kx ycpe pipz nzmnclz-krbzme mz Gct mz nzngini-krde King rm.” Mz nibrde leplz amrlx nzmwxlrtxng nzvea-mou-ngrbz natq, murde ma tqamyatx-mopwzle drtqdr. ");
INSERT INTO ntu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mzli kc tqalvztrpengr Jiszs Mangr-nzangiongr, rpibzle mz leplz kcng kx, “Kxnzalvztrng mz Lou sc Mosis nzpilr kx Mevalu kc Tqmcpx Gct navzpxm mz nqvi lr melrmqde Devet. ");
INSERT INTO ntu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Murde Mqngrkxtr batrpzle mz Devet nzycmnetr-krde Kxnzmcpx mz nzrpi-krde kx, ‘Yawe rpibzle mz King kc tqngi kxetu rnge kx, Wxbu mrlc tqmatq-esz'ngr mz nrlarnge kxrtc, navz nakrlz-zpwxbzle mzli kc nangi-batr-ngrbo mz enqmi rmqng nzmetx-krbzlr bam.’ ");
INSERT INTO ntu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Mz Sam lc Devet rpile kx Kxnzmcpx ngi kxetu rde. ?A' myx kx namu Kxnzmcpx nznginikr doa mz nqvi lrde kc mzte trnzmcka, x mzli kcpwz ngi kz kxetu rde?” Zbo ngr leplz kcng nzabrtz-ngrdr nzlalztq-krbzlr bade. ");
INSERT INTO ntu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mzli kc tqalvztrngr Jiszs leplz, rpibzle badr kx, “Bzkq apuamu kxnzalvztrng mz Lou sc Mosis. Murde mrlzbz badr nzkq-krdr nzkq kxboi mz nzvzne-krdr, x nzamatqkr leplz nidr mz nzrpi-ngrbz badr kx, ‘Nim la trte,’ mz nzvzne-krdr me nzamwangr da. ");
INSERT INTO ntu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","X mrlz-kzpz badr nzwxbu-zvz-krdr me matq mz mangr-nzkrka'ngr x mz mzli r nzmulvzngr, murde nzglqpx-lzbqng. ");
INSERT INTO ntu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","X mz zmatq ngr nzngini-krdr kxnzrmailzng, nzangqngutitrlr olvz kxnzbzszng mz nztwz-pnati-krdr dztudrng amrlx. A' mzli kcpwz nzaboitilr nzkrka'-krdr mz nzyrlq-kapq-krdr alwx ngrdr. Mz nzmu-krde lcde, leplz kxnzmulr lcng nzayrplapxngr nidr kalr mz Hxl namyatxpx-esz'ngr.” ");
INSERT INTO ntu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Mzli lcng tqalvztrngr Jiszs, wxbu aepztr mrkc Mangr-nzangiongr tzryrlqongr trau. Tqobqlvz-ngrde leplz amrlx nzrkatr-krdr trau. Leplz kxkqlu kxnzrngiscng nzryrlqong blzmr trau. ");
INSERT INTO ntu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Zbz kzdq olvz kxtr-rngiscu x bzszpe ncblo ngrde vztrpz yrlqole srlrni kxtopwzne li. ");
INSERT INTO ntu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jiszs kqlele ncblo nedeng, rpibzle badr kx, “Napibo bamu, mz nzobqkr Gct olvz lc tqabzope, srlrni kc topwz tqkapxle myaszpxle blzmr trau kcng tzkapxlr kxnzrngiscng. ");
INSERT INTO ntu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Murde kxmule-esz' kxnzrngiscng nzkapxlr kqlu a' kxpipzne la ye mz nzrngisc-krdr. A' olvz lc tr-rngiscu katxpxpele da kcng amrlx namnc-xglele.” ");
INSERT INTO ntu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mzli kc narkalzpe-ngrm Jiszs Mangr-nzangiongr Yawe, kzdq ncblo nede rpibzle bade kx, “Kxakrlz, mc ena kxmu nzlrmztiongr nzrwzngr Mangr-nzangiongr ka mz rplz lcng etuti, x mzte nzluli-krde lxngipx-esz'ngr.” ");
INSERT INTO ntu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Rpibz Jiszs bade kx, “Mangr-nzangiongr lc tqpime mzte tqluli trnatu-alou. X trpnzngr rplz ngrde kx nablio me yc-ngrde. Murde sa naodati enqmi rmung kalr.” ");
INSERT INTO ntu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kx nzkrlzbzlr kc Newz ngr Nc Olivi, Jiszs sc tqwxbupe elr, mrlcde nzmcpz Mangr-nzangiongr Yawe. Zbz Pita, Jemes, Jon x Adru sc tzvz-lrpipebzng mrkc tqwxbu-ngrde. ");
INSERT INTO ntu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Nzrpibzlr kx, “Pim ena bagr mzli kc naodatingr Mangr-nzangiongr, x rkx kznikeng namc nakrlztingr mzli lcde.” ");
INSERT INTO ntu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Rpibz Jiszs badr kx, “Aclvetio-lzbqamu mz da lcng. Bzkq rlr-ngrbzmu mz leplz nzpokiati-krdr nimu mz da kznikeng naprtz. ");
INSERT INTO ntu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ncblo nakqlung sa navzmqng mz drtqnge, narpibzlr mz leplz kx, ‘Ninge Kxnzmcpx.’ X leplz nakqlung kalr nalxngitilr nidr mz nzpokia-krdr. ");
INSERT INTO ntu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“X mou, bzkq nelzmu tzprlzm mz nzxlr-krmu nrpa ngr nzotangr mz vea kx esotrpq x nrpa ngr vea kx ycm rlru. Da kxnzmulr lcng naprtzti-kaing, a' trngiu drtwr ngr nzyrkrpxpe-krbz mz nrlc. ");
INSERT INTO ntu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Murde mrkcng kqlu mz nrlc sa napnz-lzbqng. Nengq kxetuting sa navzmqng, x dzbi kxetuting sa navz-kzpqng. A' da lcng naprtzting nzapulr nztangqgx-zlwzkr olvz kxyr, mzli kc tqvz-ebir-ngrm nimz ngr doa kxtopwz, x sc tqrmika ate. ");
INSERT INTO ntu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Aclvetio-angidramu, murde nimu lang tzlxngitilr ninge sa nalolvz kai kxnzetung nimu. Sa navzmilr nimu mz kot x naiklapxmlr nimu mz nabz mangr-nzkrka'ngr. X navzmibzlr nimu mz kxnzetu mrkzbleng x mz king kxtrngiulrJiu mz nzayrplapx-krdr nimu. X mzli nyzmu lcpe kz mz nzyapwxtipx-krbzmu Nrpa rnge badr. ");
INSERT INTO ntu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Murde Nrpakxmrlz lc nale-kaipz mz neidu amrlx mz nrlc, x Mzli Kxmatq kc na-ayzlu-ngrbz Gct da mz leplz kc ate. ");
INSERT INTO ntu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mzli lc nalolvz-ngrmu mz nzvzmi-krdr nimu mz kot, bzkq da kx nakxne drtqmu mz da kx napiamu. Murde natq kcng napiamu trngiu nrpa kx aoti drtwrmu, a' ngi nrpa kx nakatrpz Mqngrkxtr mz nabzmu. ");
INSERT INTO ntu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Mzli lcde, leplz sa nakabzlr mzledrng kcng tzvz-nqblqlr ninge mz enqmi rdr mz nznibq-krdrleng. X trte doa kz sa nawaisr-ngrde kz doa nedeng mz nzrnibqngr nidr. X doa na-atrkati-kzlr trtedr x lxedr x naka-kzpzlr mz enqmi rdrng mz nznibq-krdrleng. ");
INSERT INTO ntu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Leplz kxnzkqlung sa napxtxpx-ngrdr nimu, murde nimu leplz nengeng. A' nimu kcng tztu-amqngi-zvzng mz nzrlxngiti-krmu krlzbzle mz nzbz-krmu, sa na-arlapx Gct nimu. ");
INSERT INTO ntu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Rpi-mopwz Jiszs kx, “Kxdrka'ngr kxmyapxbz kc tqtrka-esz'ngr sa navzm, mz nzatutr-krde da kx yro Daniel mz buk scde. X nimu kcng tzrlwxlr da lc nakrlz-angidramu drtwr ngrde. Murde Kxdrka'ngr lc sa natuom Mrkc Tqtr Mangr-nzangiongr, x trtakitrdeu nide nztuo-krmle elr. Mzli lc nimu kcng tzmncng Judiz nangrlrlzamu mz newz, mz nzmnc-kapq-krnamu nzodangr kc tqycpe pipz nzkaputr-krmle. ");
INSERT INTO ntu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nzmu kx tqmncome mz nibr ma nyzm, bzkq asaq nzvzo-krme x bzkq otrpeq dztum ma nyzm. A' ngrlrtx pnz. ");
INSERT INTO ntu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","X nzmu kx tqwzq mz nrlanc, bzkq vzpeq ma nyzm mz nzoti-krm lrpzm, x sc tqngrlr-ateq. ");
INSERT INTO ntu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","“Agrmqng olvz kcng tzyrng x krkcng tzayqng itoto, murde rblxtile nidr nzngrlrlz-ani-krdr mz newz mz nzmnc-kapq-krdr. ");
INSERT INTO ntu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Krka'-ngrbzmu mz Gct murde da lcng ma tzkaputrpqng mz mzli r zbao, mzli kc nrlc tqbao-zlwz-ngrde. ");
INSERT INTO ntu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Murde ztrka ngr nzkxpungr lcng sa namyaszpxlr ztrka amrlx abzo mz mzli kc ayrnrngr tqwzngr Gct nrlc krlzmle mzli ka. X trpnz-moungr nzwrde kxnakxmule lc kx naprtz kalr. ");
INSERT INTO ntu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Gct aotipe drtwrde nzamrbcnetr-krmle mzli lc, murde leplz ma tzyrkrtxtrng. X amrbcnetrple mzli lc mz nzokatr-krde leplz kcng tqmcpxpeleng. ");
INSERT INTO ntu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mzli lcde, nzmu kx tzrpibz leplz bamu kx, ‘Obqki lcmonr, Kxnzmcpx kc tqmnc mrkc!’ o ‘Obqkim ka, nide se tqmnckibzle ka!’ bzkq lxngitiamu nidr. ");
INSERT INTO ntu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Murde Mevalu kxnzpokiang x profet kxnzalvztr-rbrng sa navzmqng. X na-aleting rkx x da kx nakctipxng mz nzesabrti-krdr leplz kcng tqmcpxpeng Gct, nzmu nakrlzlr nzyatr-krbzlr. ");
INSERT INTO ntu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Aclvetio-angidramu, murde napi-kaipo da lcng bamu x mzli rdr kc tqvz-atem.” ");
INSERT INTO ntu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","Rpi-mopwz Jiszs kx, “Mz nibr mzli r nzkxpungr lcng, Gct sa na-aycngrlrtile dalr bongavz kcng tzmatqng amrlx. Nepi nawx-nzlongr x temz trnapnapxu. X vri sa natatio-lxblrmqng mz bongavz. ");
INSERT INTO ntu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ninge Mrlx Leplz. X mzli lc leplz amrlx mz nrlc tulvzo sa namclr ninge mz nzvz-krmc mz nabz dcbz mz zmatq kxetu x zluli. ");
INSERT INTO ntu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","X sa na-atwzlrpx-ngrne enjrl nengeng mz nrlc tulvzo, mz nzvzmi-krmlr leplz neng Gct kcng tqmcpxpeleng.” ");
INSERT INTO ntu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Zbz rpi-mopwz Jiszs kx, “Mwx natwzamu drtwr ngr nzplcokr leu r nc fiki. Mrka Israel mzli kc namc-ngrnamu nrla nc fiki tzpooti-ngrdr x nzyrlqbzlr leu rdr kxmrna, sc tqkrlzpeamu kx mzli r nrpr ngr nranc sa tqesopem. ");
INSERT INTO ntu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mz nqmq lcpwz, mzli kc namc-ngrnamu kx da lcng tqpibo bamu sc tqkaputrpemqng, sc tqkrlzpeamu kx mzli esotrpem mz nzvz-krmc. ");
INSERT INTO ntu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nakrlz-angidramu kx da lcng amrlx nangidati-kaing, x leplz kcng tzmncng mz nrlc sc tzyrkrtr-ateng. ");
INSERT INTO ntu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kxmule-esz' bongavz x nrlc sa nayrkrpxng kalr, a' natqngeng trtxpnzngr nzyrkrpx-krdr murde sa nangidating amrlx.” ");
INSERT INTO ntu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Rpi-mopwz Jiszs kx, “Trpnzngr kxrkrlz zbq x nabz nepi kc nayzlu-ngrmc. Trnzkrlzlru enjrl ngr Heven amrlx x trkrlz-kzwxu, a' krlz txpwz Trtenge esz'-krde. ");
INSERT INTO ntu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mz nzmu-krde lcde, oliq-zvzamu murde trkrlzwamuu mzli rde. ");
INSERT INTO ntu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kxnamu narkalz-ngrmc x ninge kc tqvzpemc, na-apule ncblo kc tqrkalzm ma nyzde tqvz mz narnrlc. X rkabz nzwzngr mz kxnzawz nedeng amrlx. X rpibzle mz ncblo kc tqaclvele naonrx, na-aukz zvz mzli kx yzlu-ngrmle. ");
INSERT INTO ntu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Mz nzmu-krde lcde, oliq-zvzamu, murde trkrlzwamuu mzli kc nakaputr-ngrmc, ma tqngi milzpq o aurnrlc o mz natq kio kc kai o mz nourla. ");
INSERT INTO ntu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Trmrlzu trnzoliqti-krmuu nzyzlu-krmc, x tqrmctipex nzpwrkilvc-krmu nzyzlu-krmc. ");
INSERT INTO ntu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mz nzmu-krde lcde, natqnge lcng tqpibo bamu, pi-kzpo mz leplz amrlx, kx naoliqti-zvzamu nzyzlu-krmc!” ");
INSERT INTO ntu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ycbep lang zbq li x zbq kxtr kc tzrpibz Nzamyangr sc tqkaputrpem. Zbq lc tqyzutrngr nzmulvzngr kxtr, mzli kc tzmutx-ngrpwzlr bret kc trpnzngr yisti ngrde. Zbq ngrde rlimz. Kxnzetu rdr pris x kxnzalvztrng mz Lou sc Mosis nzrpilr nalolvz-kapqlr Jiszs x nanibqlr, bzkq nzkrlzti leplz kxkqlu. ");
INSERT INTO ntu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","A' nzrpilr kx, “Bzkq lolvzku nide mz nabz zbq kcng tqetung, murde ma tqrkatrpzku mz leplz kxkqlu nzotablrngr.” ");
INSERT INTO ntu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jiszs mnc mztea Betzni mz ma nyz kzdq ncblo drtqde Saemon. Mrlx lc amrlz Jiszs mzli kc mz lepz kx dwatibzle nide. Mzli kc tqmungr Jiszs ma lcde, dwatrpz kc olvz. Twzbzle kc botol ngr tolo kx narncbr ngrde lqlwx x mnrte mrlz zlwz. Lvxlzle botol kc x sc tqaelupebzle nar Jiszs mz nzarmyalz-krde nide. ");
INSERT INTO ntu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kzdung leplz kcng tzmncng mrkc drtwrdr ngya, sc tzrpi-etrpelr kx, “?Nike olvz lc tqayrkrtitx-ngrde tolo lc narncbr ngrde tqlqlwx? ");
INSERT INTO ntu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Takitrde nzamwatxngr tolo la mz narncbr kx tqlqlwx. Narncbr kx rsakrlrmingr nzxpengr ncblo mz yiz kxesz'. X nakabz trau rde mz kxtrnzrngiscung.” Sc tzpibqtipelr olvz kc. ");
INSERT INTO ntu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","A' rpibz Jiszs badr kx, “Bzkq ycmnebzmu bade. ?Memule tqrpi-ngrnamu narpwa'-ngrbzmu da lc tqalele? Da kxmrlz-esz'ngr lc tqalemle bange. ");
INSERT INTO ntu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Doa kx trnzrngiscung mnc-zvzamu badr, x krlzamu nzokatrngr nidr mzli kznike pnz ngr drtwrmu le. A' ninge trnamnc-zvzpc'u bamu. ");
INSERT INTO ntu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Da lc tqale olvz lc, takitrde nide nzale-krmlele bange. Aelule ninge tolo mzli ka mz nzoliqti-krbzle nrkrdrtqnge mzli kc nabz-ngrne x nzyrtzmqngr namz ngrnge kc ate. ");
INSERT INTO ntu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Napi-angidrbo bamu, drlve keng nzyapwxtipxngr Nrpakxmrlz lc mrka mz nrlc, da kxmrlz lc tqalem olvz lc bange sa napipx kz, mz nzrdctipxngr drtwr nide mz nrlc tulvzo.” ");
INSERT INTO ntu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judzs Iskariot nide kzdq ncblo neng Jiszs kcng nzpnu-esz'-nrade-li (12). Vzbz mz kxnzetu rdr pris mz nzamwa-krbzle Jiszs badr. ");
INSERT INTO ntu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kxnzxlrlr da lc, nzabrtztxng x nzrpibzlr naxpebzlr Jiszs bade. Zbz Judzs sc tqrtangrtipele mzli kxmrlz kx na-aprc-ngrbzle Jiszs badr. ");
INSERT INTO ntu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mz zbq kc kai ngr Nzmulvzngr Bret kx Trpnzngr Yisti Ngrde, nei sip kx nangq mz Nzamyangr sc tznibqpe. X mzli kc tqtaopengr nepi sc tzmulvz-atelr Nzamyangr. Ncblo nedeng nzveabzng bade kx, “?Myx me naoliqti-ngrbzkr dakxnzng ngr Nzamyangr?” ");
INSERT INTO ntu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jiszs atwzlr-ngrde kzdu nidr nzling, rpibzle badr kx, “Vztramu mzteadau Jerusalem, x sa narmctiamu kzdq ncblo kx rglqne da kx lrti lue. Vz-nqblqamu nide. ");
INSERT INTO ntu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","X kx tqkrlzbzmu la, ma kc nadwakitrle, rpibzmu mz ncblo kc tqrnginyz ma kc kx, ‘?Kxakrlz rpile nakrlzle myx me namnc-ngrdr badr ncblo nedeng mz nzmulvz-krdr Nzamyangr?’ ");
INSERT INTO ntu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Sa navzmilzle nimu wq mz nelvq rde kxetu mrlcde nzamrlzpqpe-ngrde nigu. Mrlcde dekc naoliqti-ngrnamu dakxnzng nagu.” ");
INSERT INTO ntu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ncblo nede kcng tzvztrng Jerusalem, x da amrlx kcng tqpibz Jiszs badr sc tqngi-datipeng. Zbz sc tzoliqtipelr Nzamyangr. ");
INSERT INTO ntu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kx krlzbzle kc milzpq, Jiszs badr aposol kcng nzpnu-esz'-nrade-li (12) sc tzvzpem ma kcma. ");
INSERT INTO ntu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","X mzli kc tzmulzpe-ngrdr mz tebol, rpibz Jiszs kx, “Napi-angidrbo bamu kx kzdq nimu esz' sa na-amwabzle ninge mz enqmi rngeng. Kzdq nimu kang tqmu-lxblrku mzli ka.” ");
INSERT INTO ntu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Drtwrdr vztx pnz, x sc tzycmne-esz'-lxblrpebzng bade, tqtulzm kc nidr tqrpibzle kx, “?Trnipwc'u la tqpiq kx?” ");
INSERT INTO ntu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ayzlu-ngrbz Jiszs natqdr kx, “Kzdq nimu kang ncblo nengeng, kzdq nimu kc naleole bret nade mz dis lc tqwxbutrp bange. ");
INSERT INTO ntu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ninge Mrlx Leplz nabzx navz-nqblqle Nzryrngrkxtr. A' agrmplz ncblo la na-amwale ninge. Murde takitrde bzkq mzte nzmc pnz, murde nzayrplapxngr lc nide kalr namyatxpx-esz'ngr.” ");
INSERT INTO ntu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mzli kc tzmube-ngrdr, Jiszs kalzmle bret. Awitx-ngrbzle mz Gct, lopxile, kabzle badr x rpibzle kx, “Twzamu murde krlc ncvr drtqnge.” ");
INSERT INTO ntu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Zbz glqlzmle kap. Awitx-ngrbzle mz Gct, kabzle badr x nzrmnqong amrlx ngrdr elr. ");
INSERT INTO ntu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Rpibzle badr kx, “Krlc mepyr rnge kc tqyrlepx-ngrde leplz kxkqlu, mz Nzesz'tikr Drtwr Gct badr leplz. ");
INSERT INTO ntu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nakrlz-angidramu kx trpengr nzrmnq-mou-krnge waen, navz nakrlzbzle mzli kc narmnq-ngrne waen kxmrna mz nrlc kc na-aclve Gct kalr.” ");
INSERT INTO ntu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mz nibrde nzngrtx-ngrdr kc Sam ngr nzrglqpxngr, x sc tzrlaszpelr mzteadau, tzvzdzpeng mz Newz ngr Nc Olivi. ");
INSERT INTO ntu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Zbz rpibz Jiszs badr kx, “Koma mz nrlckxbq nimu amrlx ngrmu sa nadwaszamu ninge, mz nzatutrngr Nzryrngrkxtr mz nzrpi-krde kx, ‘Ninge Yawe, x sa nanibqx kxaclve sip, x sip nedeng sa na-akiting nrlc.’ ");
INSERT INTO ntu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","A' mz nibr nzatulz-moungr ninge mz nzbzngr, sa nartwayz-kaipo Gzlili x navz-kzpzmu mz nzrmcti-lzbq-krgu elr.” ");
INSERT INTO ntu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","A' Pita rpibzle kx, “Trtxpnzngr nzdwasz-krnge nim, kxmule-esz' kztenge lcng nzdwang amrlx!” ");
INSERT INTO ntu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jiszs rpibzle mz Pita kx, “Napi-angidrbo bam, koma mz nrlckxbq, nzwrde natq nzrpi-krm trkrlzwq ninge x kio nzkya'-krde nzwrde krali kc ate.” ");
INSERT INTO ntu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","A' Pita natqde xplr-zlwzbz mz Jiszs nzrpi-krbzle bade kx, “Trtxpnzngr nzrpi-krnge kx trkrlzwxu nim! Kxmule-esz' nzabzminge nim!” X nzpi-kzpzlr kztede kcng amrlx. ");
INSERT INTO ntu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mz nzvzo-kr-moplr nzkrlzbzlr kzdq nrlc drtqde Getsemzni. Jiszs rpibzle badr kx, “Wxbupwzmu mrka mzli kc nakrka'-ngrne.” ");
INSERT INTO ntu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Vzmile Pita, Jemes x Jon. Mzli lc nabz Jiszs talvzope x mrlepupe-ngrde nzvzkr drtwrde. ");
INSERT INTO ntu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Sc tqrpipebzle badr rtqlrdr kx, “Nzvzkr drtwrnge etutx-zlwzpe x rpile nanibqle ninge. Mncpwzmu mrka x aukzpwzmu.” ");
INSERT INTO ntu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Vzszpxle nidr kxpipz x sc tqrtco-lzbqpengr mz drtc' mz nzkrka'-krde. Krka'-ngrde kx nzmu kx tqrlrpxngr Gct le e bzkq drtqde nzaetq x nzabz. ");
INSERT INTO ntu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Rpile kx, “Abba! Trte! Rngiscm zmatq ngr nzalengr da amrlx. Trsutiu drtwrnge nzrlrpx-lzbq-krnge mz nzetqkr drtqnge x nzbzngr. A' bzkq vz-nqblqq me pnz drtwrnge, a' nangi zvz me pnz drtwrm.” ");
INSERT INTO ntu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mz nibr nzkrka'-krde, yzlum mz ncblo kcng nztqng, a' sa tzmwing. Sc tqrpiopebzle mz Pita kx, “Saemon! ?Nike tqmwilvzq? ?Rblx-zlwzbz bam nzobq-krm mz nabz nepi kxesz'? ");
INSERT INTO ntu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Aukzpwz x krka' murde natu-amqngiq mz nzatalzngr. Murde kxmule-esz' suti drtwrm nzalengr da kxtubq, a' nzxplr-krm esz'-krm trtakitrdeu.” ");
INSERT INTO ntu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Zbz Jiszs vz mou mz nzkrka'-krde, x pi-moule natqde kcng pwz. ");
INSERT INTO ntu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kx yzlu-mople kc badr, mcle kx nzmwipe-moung rtqlrdr, murde mztr one mwi zlwz. X trnzkrlzlru da kx napibzlr bade. ");
INSERT INTO ntu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","X kx yzlu-mople kc mz nzwrde kratq mz nzyrkrpx-krbz nzkrka'-krde, sc tzmwibeng. Sc tqrpipebzle kx, “Elr! Nimu ka tqmwibeamu. Mrlzpe ena. Mzli kc tqpi-pnzbo bamu sc tqkaputrpem. Obqbzmu, ninge Mrlx Leplz se na-aprcpebz mz zmatq ngr ncblo kx nzaleng alwx. ");
INSERT INTO ntu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tulzamu, navzbzku narmcti-lzbqku badr. Obqbzmu, ncblo kc tqamwale ninge sa tqvzpem.” ");
INSERT INTO ntu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mzli kc Jiszs tqycmnebe-ngrde, Judzs sc tqkaputrpebz. Judzs lc nide kzdq ncblo nedeng kcng nzpnu-esz'-nrade-li (12), x vz-nqblqm zbo ngr ncblo. Nzatwzlrpx-ngrmqng kxnzetu rdr pris x kxnzalvztrng mz Lou sc Mosis x lrtzlvzng. Nzrmaleng dalr nzotangr, bz x toki r vea. ");
INSERT INTO ntu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judzs rka-kaipz badr rkx mz nzrpi-krbzle kx, “Krkc natcngix kcma, nide kc nalolvzamu x vzmiamu.” ");
INSERT INTO ntu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Zbz Judzs vzm mz Jiszs. Rpibzle kx, “Kxakrlz!” x sc tqtcngipebzle mqde. ");
INSERT INTO ntu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Zbz sc tzlolvzpelr Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","A' kzdq ncblo nede kx tu mrlcde yrlqbzle toki r vea scde x lakitxpxbzle kzdq nradrtq kxnzawz-nrbalq ne Nardr Pris. ");
INSERT INTO ntu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Rpibz Jiszs badr kx, “?Memule tqrtwz-ngrmamu bz x toki r vea mz nzlolvz-krmu ninge? ?Opxm kx ninge kx rmailz ncblo mz nzrnzlvzongr zmatq ngr gzpman? ");
INSERT INTO ntu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mz zbq kang kqlu alvztr-zvz-ngrne Mangr-nzangiongr. ?Memule trlolvz-ngrwamuu ninge elr? A' kxmusr-ngrnamule lc mz nzangida-krde Nzryrngrkxtr.” ");
INSERT INTO ntu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Zbz ncblo nedeng amrlx sc tzdwaszpelr nide. ");
INSERT INTO ntu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mzli lcde kzdq obla vz-nqblqne-kzle Jiszs mz nrlckxbq kcpwz, pxi txpwz lrpz. X nzrpilr nalolvz-kzlr nide. ");
INSERT INTO ntu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","A' nzmale-lvitxdr nide x dwaszle lrpz scde, x sc tqvope ycblq. ");
INSERT INTO ntu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jiszs nzvzmilr mz ma nyz kx ngi Nardr Pris, mrkc tzyrlwrpx-lxblr-ngrdr kxnzetu rdr pris, lrtzlvzng, x kxnzalvztrng mz Lou sc Mosis. ");
INSERT INTO ntu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita kc tqma-nqblqnebzle nidr. X dwatr-kzpz mz makoa ngr ma kc, sc tzwxbu-lxblrpeng badr pulis ngr Mangr-nzangiongr mz nzmulq-krde nyr. ");
INSERT INTO ntu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kxnzetu rdr pris x Kansrl nzrtangrng kzdq da kx vz-rbrti Jiszs, murde nzrpilr nanibqlr nide, a' trpnzngr da kxnzrmctilr. ");
INSERT INTO ntu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Murde leplz nzkqlung nzpokiatitrlr Jiszs, a' nzryapwx-krdr tresz'tiu. ");
INSERT INTO ntu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Zbz kzdu leplz nztulzmqng, sc tzpokiape-kzng. ");
INSERT INTO ntu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Nzrpilr kx, “Xlrkr nzrpikr Jiszs kx, ‘Sa na-awxtxobo Mangr-nzangiongr lc tzwzti ncblo, x nayctitxde zbq nali, x zbq kratq sa nawzti-mopwc' dq kxmrna kx trnzkrlzu ncblo nzrwzngr.’” ");
INSERT INTO ntu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","A' natq kcng tzpiti-lxblrlr tresz'ti-kzu. ");
INSERT INTO ntu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Zbz Nardr Pris tutxlzm mz mzlirdr, sc tqveapebz mz Jiszs, rpibzle kx, “?Myx kxmule, trpnzngr natq kx na-ayzlu-ngrbzme natq ncblo lcng?” ");
INSERT INTO ntu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","A' Jiszs anabu txpwz. Zbz Nardr Pris vea-mopwz bade, rpibzle kx, “?Ngini-angidrm Kxnzmcpx? ?Nim Mrlx Gct kc tqglqlzkr?” ");
INSERT INTO ntu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ayzlu-ngrbz Jiszs natqde kx, “Eu, ninge mrlxde. X sa namcamu ninge, Mrlx Leplz, nzwxbu-krnge me matq esz'ngr mz nrlar Gct kxrtc. X ninge la nayzlu-mopwc' kalr mz nabz dcbz ngr bongavz.” ");
INSERT INTO ntu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Zbz Nardr Pris sc tqpesali-zlwzpele nzkq scde, tqrpipebzle mz Kansrl kx, “Trpengr nzrtangr-krgu ncblo kx narpim bagu da kx vz-rbrti mrlx lc! ");
INSERT INTO ntu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Murde sa tqxlrpebzmu natq kx pivxi-ngrde Gct. ?Nike aotitrpz drtwrmu mz mrlx lc?” Rpibz Kansrl kx vz-rbrtx zlwz x takitxtrpwzle nzbz-krde. ");
INSERT INTO ntu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Zbz kzdung ncblo kcng mz Kansrl sc tzbyatipelr Jiszs. X nzpe-kilvzbzlr mzte lrpz x sc tztzpelr mz mqdr, tzrpipebzlr kx, “Mz nzngini-krm kc profet, pim ena bagr krkc tqtzle nim.” X Jiszs nzvzmi-kzlr pulis ngr Mangr-nzangiongr x nztz-kzlr. ");
INSERT INTO ntu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Mzli kc Pita tqmnclz-ngrmle mz nabxbz ngr ma kc, kzdq olvz kxwz mz ma nyz Nardr Pris vzm mrkc tqwxbu-ngrde. ");
INSERT INTO ntu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kx mcle kc Pita nzmulq-krde nyr, sc tqobqlvzpele, x tqrpipebzle bade kx, “Nim dq kz kx mnctrpz mz Jiszs kc Naszret.” ");
INSERT INTO ntu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","A' Pita pokiatxbz, rpibzle kx, “Trkrlzwxu da la tqycmnetr-ngrn.” Zbz tulzm x sc tqtutrpe mz naonrx, x kio kc tqkya'pe. ");
INSERT INTO ntu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kx mc mou olvz kc Pita, sc tqrpipebzle badr leplz kxnztung mrkc kx, “Mrlx lc nide dq kz ncblo ne Jiszs.” ");
INSERT INTO ntu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Zbz Pita pokia mou, rpile kx trngiu da zpwx kc tqpi olvz kc. Zbz mzli trboiu kzdung leplz kx nztung mrkc nzrpi-kzpzlr mz Pita kx, “Krlztx-angidrkr kx nim kzdq nidr, murde mz nzycmne-krm otxpx kx nim lr Gzlili.” ");
INSERT INTO ntu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Zbz rpibz Pita kx, “Naesalzbo bamu kx nangi bongavz, da zpwx lc tqpibo bamu. Trkrlzwxu ncblo la tqpimamu bange. Nzmu kx tqpokiabo na-ayrplapx zvz Gct ninge.” ");
INSERT INTO ntu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","X mzli kcpwz kio kc tqkya'pe mz nzwrde krali. X sc tqdcpxpe mz drtwr Pita nzrpi-krbz Jiszs bade kx, “Napibo bam, nzrpi-krm trkrlzwq ninge nzwrde natq, x natq kio krali kc ate.” Zbz Pita sc tqyrnitxpe, bztitxde nzyrningr. ");
INSERT INTO ntu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mzli kc mz nourla kc topwz, kxnzetu rdr pris, lrtzlvzng, kxnzalvztrng mz Lou sc Mosis, x leplz amrlx mz Kansrl nyzdr lr Jiu nzycmne-lxblrng x sc tzryrlqpeng drtwr. Nzpetxbzlr mq Jiszs x sc tzvzmipelr tzaprcpebzlr mz mq Pcntizs Paelzt, lr Rom kc tqaclvele Judiz Provins. ");
INSERT INTO ntu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Paelzt veabz mz Jiszs kx, “?Myx kxmule, nim king r lr Jiu?” Ayzlu-ngrbz Jiszs natqde kx, “Sa tqplzpxpeq kx ninge.” ");
INSERT INTO ntu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kxnzetu rdr pris nzrpibzlr kx Jiszs alele da kqlu kxtrkating. ");
INSERT INTO ntu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Zbz Paelzt sc tqveape-mopwz bade, rpibzle kx, “?Memule trayzlu-ngrpwe'u natqnge? ?Trxlrwq da kcng kqlu tzrpilr kx oti-rbrbzme?” ");
INSERT INTO ntu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","A' Jiszs sc tqvz zvz trnzycmne-krdeu. Sc tqkctitxpxpe Paelzt nznabu-krde. ");
INSERT INTO ntu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mz Nzamyangr amrlx, Paelzt aprpxmle kzdq doa lr Jiu kx mnc mz presin kx nzrlxtitrpz lr Jerusalem. ");
INSERT INTO ntu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mzli lc kzdq ncblo kxayo drtqde Barabas mnc mz presin. Murde nidr badr kztedeng nznibqlr kcng ncblo ngr vea ne Rom mz nzota-krdr badr mz nzmaszlrpx-krdr nzaclvekr lr Rom nidr. ");
INSERT INTO ntu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Zbz mz Nzamyangr kc, lr Jerusalem nzrlxtitrpzlr mz Paelzt kzdq ncblo mz nzvz-nqblq-krde nqmq krde. ");
INSERT INTO ntu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","X rpibzle kx, “?Narlr-ngrbo bamu King rmu, King r lr Jiu?” ");
INSERT INTO ntu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Krlc tqkxmu nzycmne-krbz Paelzt lc murde krlzle kx Jiszs nzaprcbz kxnzetu rdr pris bade mz nzdobulvz-krdr nzsuti-zlwzkr drtwr leplz nide. ");
INSERT INTO ntu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","A' kxnzetu rdr pris nzapqtrpzlr drtwr zbo ngr leplz kcng kx narlxti-alzubzlr mz Paelzt Barabas. ");
INSERT INTO ntu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Zbz Paelzt vea-mopwz badr kx, “?Nike nawaisr-ngrne ncblo lc tqrpiamu King r lr Jiu?” ");
INSERT INTO ntu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","A' sc tznemipebzlr, tzrpibzlr kx, “Natqlvztr mz kros!” ");
INSERT INTO ntu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Rpi-mopwz Paelzt kx, “?A' memule? ?Da kxtrka kznike alele?” A' sc tznemi-katobzlr kx, “Natqlvztr mz kros!” ");
INSERT INTO ntu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Paelzt suti drtwrde nzaelalz-krmle drtwr zbo ngr leplz kcng, x sc tqaprpxpebzle Barabas badr. A' rpibzle mz ncblo ngr vea nedeng naiklalr Jiszs x natqlvztrlr nide mz kros. ");
INSERT INTO ntu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kzdung ncblo ngr vea nzvzmitrpelr Jiszs mz makoa ngr ma kxetu nyz Paelzt, x sc tzkqlepelr ncblo ngr vea kztedrng amrlx. ");
INSERT INTO ntu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nzotilr kc nzkq kxprpol sc king, sc tzakqpe-ngrdr Jiszs. X nzngrlelr kc nqvi nzku ngi kraon scde, nzalaobzlr mz narde. ");
INSERT INTO ntu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sc tzxtrngalvztitrpelr x tzmrgepe-ngrdr nide kx, “Nim la, King r lr Jiu! Nzmnc-krm naboi.” ");
INSERT INTO ntu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nztakrtibzlr narde mz dapunc x nzbyatilr nide. Zbz sc tzrweopebzng zpr bade mz nzapusr-krdr nide king. ");
INSERT INTO ntu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mz nibrde sc tzavopxpebzlr nzkq kc prpol x nzavoo-mopwzlr nzkq scde. X sc tzvzmipxpelr mz nzrtqlvztrngr nide mz kros. ");
INSERT INTO ntu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nzvzng, x sc tzrmctipelr kc ncblo drtqde Saemon. Nide dalr taon kxetu Saerin, mrkc Afrika. X mrlxdeng drtqdr Aleksada x Rufzs. Tqvz-atem x navztrpe Jerusalem. A' ncblo ngr vea kcng sc tzrtulrtrpe-ngrbzlr bade nzglq-krbzle kros ngr Jiszs, murde drtqde mewetx-zlwzpe. ");
INSERT INTO ntu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ncblo ngr vea kcng nzvzmilr Jiszs mz kzdq newz drtqde Gclgata, drtwr ngrde Bekrlz, murde nzobq-krde apule bekrlz. ");
INSERT INTO ntu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nzkabzlr bade kc waen kx ycmi luekxpiz nzrpibz mrr, a' trmnq-pnzleu. ");
INSERT INTO ntu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Zbz sc tztqlvztrpelr nide mz kros. X nctq lrpz scdeng nzayrleti ncblo ngr vea kcng daes, mz nzkrlz-krde doa kx narngisc. ");
INSERT INTO ntu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nztqlvztrlr Jiszs mz kros mz nabznepi kc tqrpwxmz mz nourla. ");
INSERT INTO ntu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","X mz nzaelwapxngr da kc tqbzngr Jiszs, nzyr kcng natq x nzatu mrkc tztqlvztr-ngrdr nide mz kros. Rpile kx, “King r lr Jiu.” ");
INSERT INTO ntu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","X nztqlvztr kz mz kros kzbleng ncblo nzling kxnzpnang da taplxsr nrlar Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mz nzmu-krde lcde, natq profet Asaea sc tqngidatipe, mz nzrpi-krde kx, “Mz nzaotikr drtwr leplz, ni-kzde ncblo kx xpqbrlr-zvz-ngrde lou.” ");
INSERT INTO ntu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mzli kc tqdoo-ngrm Jiszs mz kros, kzdung leplz kx nzvzkimlr mrlcde nzrpitilzbzng natq kxtrka bade. Nzaycngrlrlzbzlr nardr, nzrpilzbzlr kx, “Kx tqrpiq kx matq-esz'ngrn mz nzawxo-krm Mangr-nzangiongr x wzti-mowq mz zbq kxtqtxu, ");
INSERT INTO ntu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","e vzom mz kros la mz nzarlapx-lzbq-krm!” ");
INSERT INTO ntu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mz nzmu-krde lcdepwz, kxnzetu rdr pris x kxnzalvztrng mz Lou sc Mosis nzxtrnga-kz-ngrdr Jiszs mz mzlirdr, nzrpilr kx, “Krlzle nzarlapx-krde kzdu-kzng leplz, a' trkrlzleu nzarlapx-lzbq-krde. ");
INSERT INTO ntu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nzmu kxtqngini-angidrde King Kxnzmcpx ngr Israel, navzopem mz kros mzli ka x sc tqlxngitipeku nide.” X ncblo kcng nzling tzdo-kzng mz kros, nzrpiti-kzpzng natq kxtrka mz Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mzli kc tqtavauo-ngrm nepi, nzlo akqlvztx-pnzle nrlc atwrnrngr, krlzbzle nabznepi kc tqtq. ");
INSERT INTO ntu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","X mzli lcpwz, Jiszs sc tqetumipe natqde, nzrpi-krde kx, “Eloi! Eloi! ?Lama sabaktani?” Drtwr ngrde kx, “Gct! Gct o! ?Memule tqvzszpe-ngrn ninge?” ");
INSERT INTO ntu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kzdung leplz mrkc nzxlr-rbrbzlr natq Jiszs, x sc tzrpipelr kx, “?Xlrbzmu? Kqlepele Profet Elaeja kc bqnc mz nzokatr-krde nide!” ");
INSERT INTO ntu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kzdq nidr otile kc kzdq da, petrle mz nounc, leole mz waen kxrkx, x sc tqglalzpebzle mz nao Jiszs. Sc tqrpipebzle kx, “Na-aenzliku ena, namcku nzvz-krm Elaeja mz nzglqo-krmle nide mz kros.” ");
INSERT INTO ntu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Zbz Jiszs netxpx-kato mou x sc tqbzpe. ");
INSERT INTO ntu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","X mzli lcpwz lotqbr kc tqdo Mrkc Tqtr Mangr-nzangiongr nzpesalikiomle wq tatxo mz noude, ncte li. ");
INSERT INTO ntu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kzdq kxetu r dzbe ncblo ngr vea ne Rom kx trtqki-esz' (100) tulzbz mz nou kros. Kx mcle kxmu nzbzkr Jiszs, sc tqrpipele kx, “Da zpwxtx, ncblo ka nide Mrlx Gct.” ");
INSERT INTO ntu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kzdung olvz nzmnc-kzng mrlcde, sc tztumqng rlru, x nzmclr da kcng tzwaisrngr Jiszs. Olvz lcdeng seng, Mxri kc Makdala, Salome, x Mxri lxede Jemes kc tqtopwz x Joses. ");
INSERT INTO ntu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Olvz lcng nzvz-nqblqne-zvzlr Jiszs x nzokatrlr nide mzli kc tqmnc-ngrde Gzlili Provins. Olvz nzkqlu kx nzmncng mrlcde kx nzvzkimlr Gzlili x nzvzdzng badr Jiszs Jerusalem. ");
INSERT INTO ntu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Zbqkranzlvqn ngi zbq ngr nzoliqtikr lr Jiu mz Sabat. Sabat yzutr mzli kc tqtaopengr nepi. Josip kc Arimatia trmwxlru, vzbz mz Paelzt x sc tqrlxtipebzle nrkrdrtq Jiszs mz nzyrtzmq-krdele. Josip lc nide kzdq kxetu mz Kansrl nyzdr lr Jiu. X tqobqtipxle mzli kc Kxnzmcpx ne Gct nangini-ngrde King r lr Jiu. ");
INSERT INTO ntu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Paelzt kctipxle nzxlr-krde kx Jiszs bz-anipe. Kqlele kxetu r ncblo ngr vea kc tqaclvele Jiszs, sc tqveatipebzle kx Jiszs bz-zpwxpe. ");
INSERT INTO ntu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mz nibr nzrlwa-krbz ncblo nede, Paelzt sc tqrlrpe-ngrbzle namz ngr Jiszs mz Josip. ");
INSERT INTO ntu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Zbz Josip xpele kc lrpz kxprki. Kaomle namz ngr Jiszs mz kros, x sc tqbxtipele lrpz kc, mz nzvz-nqblq-krde nqmq kr lr Jiu x sc tqglqtr-anipele mz gq lr kxbz kx nzekqtitr mz butqbr. Mrlz, sc tqalqlitrpebzle kc rplz kxetu kx nzapqbrtr-ngrbzle naonrx ngr butqbr kc. ");
INSERT INTO ntu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mxri kc Makdala x Mxri lxede Joses nzmclr butqbr kc tqayrbqpx-ngrm Josip namz ngr Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mz nibr Sabat mzli kc mz nina, Mxri kc Makdala, Mxri lxede Jemes, x Salome nzvzng sc tzxpepeng da kx na-aelu-ngrdr namz ngr Jiszs. ");
INSERT INTO ntu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Zbz mz nourla kc topwz mz Sade, olvz kcng nztqng sc tzvzpeng mz butqbr kc. ");
INSERT INTO ntu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mzli kc tzvz-ngrdr mz lrpzki, sc tzpi-etrpelr kx, “?Neke naokatrle nigu mz nzalqlipxngr rplz kc? Murde etu zlwz x mrlepu.” ");
INSERT INTO ntu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","A' kx nzkrlzbzlr butqbr kc, nzmcpelr rplz kc nzalqlipxpe. ");
INSERT INTO ntu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nzdwatrpzng mz butqbr kc, nzpwrkilvc-ngrdr kzdq enjrl kx apule obla, x kq lrpz kxprki wxbu mz nrlarde kxrtc ngr gq kc. ");
INSERT INTO ntu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","A' rpibzle kx, “Bzkq mwxlramu. Krlzpebo kx rtangrtiamu Jiszs kc Naszret tztqlvztr mz kros. Mc-zpwxamu mrkc tzayrbq-ngrdr namz ngrde. Tryrbqpeu mrka, murde tulzpe mou. ");
INSERT INTO ntu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","A' yzluamu x pibzmu mz ncblo nedeng badr Pita kx, ‘Jiszs sa tqrtwayzpe kai Gzlili, x navz-kzpzmu mz nzrmcti-lzbq-krmu badr elr, da kc tqwai nzpi-pnz-krbzlele bamu.’” ");
INSERT INTO ntu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Olvz kcng nzvzpxmqng mz butqbr kc, nzrnrcti-lzbqng mz zmwxlr x sc tzngrlrpeng. Mzli lcde trpnzngr doa kx nzpine badr le, nike nzmctr mz butqbr kc. ");
INSERT INTO ntu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mz nibr nztulz-krm Jiszs mz nourla mz Sade, adcpx-lzbqbz mz Mxri kc Makdala, kc tqmaszlrpx-ngrbz Jiszs bade drka' rlimz. ");
INSERT INTO ntu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Vz x sc tqpipebzle mz ncblo nedeng kcng drtwrdr tzvzbeng x tzyrning. ");
INSERT INTO ntu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kx nzxlrbzlr nzrpi-krbzle kx Jiszs lupe mou x mcle nide, trnzlxngitipwzlru natqde. ");
INSERT INTO ntu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mz nibrde, mz zbq kcpwz, Jiszs adcpx-lzbq-kzpz mz leplz nedeng nzling kx nzrkalzmqng Jerusalem. Mzli kc tqadcpx-lzbq-ngrbz Jiszs badr, nzobq-krde blepxngr x trnzglxlru nide mzli kc kai. ");
INSERT INTO ntu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","A' kx nzglxlr kc nide, sc tzyzlupe-moung Jerusalem, x tzrlwape-ngrbzlr mz kztedrng amrlx, a' trnzlxngiti-kzlru natqdr. ");
INSERT INTO ntu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mz nibrde Jiszs adcpx-lzbq-kzpz mz ncblo kcng nzpnu-esz'-nrade-esz' (11) mz nzmu-krdr. X ycmnetxbz badr, murde trnzbr-kru drtwrdr, x nzmqngikr nardr, x trnzlxngiti-krdru leplz kcng tzmclr nide mz nibr nztulz-krmle mz nzbz-krde. ");
INSERT INTO ntu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Zbz sc tqrpipebz Jiszs badr kx, “Vzpxamu mz nrlc tulvzo x lebzmu Nrpakxmrlz mz leplz amrlx. ");
INSERT INTO ntu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","X krkcng nzrlxngiting x nzwrkxtrng sa na-arlapx Gct nidr. A' krkcng trnzrlxngitiung trtxpnzngr nzrlapx-krdr. ");
INSERT INTO ntu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kxnzlxngitilr ninge sa nartwzng zmatq mz nzale-krdr rkx lcde seng: mz drtqnge sa narmaszlrpx-ngrng drka', x naycmneng mz natq lr mrkzbleng mz zmatq ngr Mqngrkxtr. ");
INSERT INTO ntu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","X kxmule-esz' nzrmaleng ningidoe kxrmakx x nzrmnqng lue kxrlq, a' trtxpnzngr nznibq-krdr nidr. X mzli kc tzmaletr-ngrbzlr drtq kxnzyagoxng, zyagox ngrdr nayrkrpxbz x namrlz-moung.” ");
INSERT INTO ntu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mz nibr nzycmne-krbz Kxetu Jiszs badr, sc tqavzdzpe Gct Heven. X wxbutxom me matq mz nrlar Gct kxrtc. ");
INSERT INTO ntu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Zbz ncblo nedeng sc tzvzpxpeng mz nrlc tulvzo mz nzrlepxngr Nrpakxmrlz. X Jiszs okatr-zvzle nidr mz nzale-krdr da kxnzkctipxng mz nzaelwapxngr kx nzalvztr-krdr da zpwx. Eu. Delape. ");
INSERT INTO ntu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Ninge Luk, ryrbo bam kx Kxetu Teofilzs. Krlc be ngr da kcng amrlx tqprtz mzli kc tqabzongr nzwzkr Jiszs, krlzbzle mzli kc tqvzdzpe-mou-ngrde Heven. Da lcng nzaprcpe-mop bagu, mz nzryrngr nzalvztrkr leplz kcng tzrmc-angidrng da lcng nzngida-krde. X nznginipedr kxnzryapwxpxng Nrpakxmrlz. Leplz kqlupe nzabzlr mz nabztq, nzryrngr kzdq da kx naycmnetrngr nzmnckr Jiszs Kxnzmcpx, x da kcng tqalemleng mz mzlirgr. ");
INSERT INTO ntu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mz nqmq kcpwz, aoti drtwrnge kx mrlz nzryr-krbo, mz nzaopx-krbo bam da lcng amrlx. Murde veati-angidrpex da amrlx, abzo mz nzayzuokr nzryapwxngr, vz-krlzbzle me yrkrkipxle. X krlzx nzryr-angidrngr. ");
INSERT INTO ntu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Yrbo bam da lcng murde nakrlzq da amrlx kx ngida, mz da kcng tzalvztrpz bam. ");
INSERT INTO ntu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mzli kc ena Herot Kc Tqmyalz tqngini-ngrde king r Provins kc Judiz, mnc kz kc pris drtqde Sxkaraezs, prtr mz dzbe pris kc tzrpibz Abaeja. Olvz rde drtqde Elszbet. Elszbet ni-kzde neidu lr Eron. ");
INSERT INTO ntu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nqmq krdr tubq-esz'ngrbz mz nzobqkr Yawe, murde nzvz-nqblq-angidrlr Loukxtr scde. X nzvz-nqblq-angidr-kzlr natqde. ");
INSERT INTO ntu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","A' Sxkaraezs nidr mz Elszbet trpnzngr nedr doa, murde Elszbet tr-rngineu, vz-nrbalq. X nide blangpe x Sxkaraezs ngipe kz olman. ");
INSERT INTO ntu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Zbz sc tqkrlzbzle mzli kx dzbede ne Sxkaraezs nawz-ngrdr mz Mangr-nzangiongr Yawe mrkc Jerusalem. Kzdq zbq, mz nzvz-nqblq-krde nqmq krdr pris, Sxkaraezs kc tzmcpxpe kx nanginide pris kc na-angcom bqlr nc ninz mz olta mzbq lcde. Sc tqdwatrpe Mrkc Tqtr mz Mangr-nzangiongr mz nzale-krde da lc. Mzli kcpwz tqale-ngrde nzwz-krde, ");
INSERT INTO ntu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","zbo ngr lr Jiu kcng sc tzyrlwrtrpzng yz tzkrka'ng, mz nabznepi kc tzangc-ngrpwz bqlr nc ninz. ");
INSERT INTO ntu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kzdq enjrl ne Yawe adcpx-lzbqbz mz Sxkaraezs. Enjrl kc tukibzle me nzamatqngr mz nrlar olta kxrtc, mrkc tqngcngr bqlr nc ninz. ");
INSERT INTO ntu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kx mctx Sxkaraezs enjrl lc, drtwrde alititx-pnzle, x sc tqmwxlrtxpe. ");
INSERT INTO ntu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","A' rpibz enjrl kc kx, “Bzkq mwxlrq, kx Sxkaraezs! Nzkrka'-krm xlrpe Gct. X olvz rm la namikabzle dq doa ncblo. Yrlqbz drtqde nangi Jon. ");
INSERT INTO ntu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mzli kc mzte namc-ngrde, na-abrtzlvztxn x leplz kxkqlu na-abrtzlvztx-kzlr nide! ");
INSERT INTO ntu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nanginide ncblo kx myatxlzpebz mz nzobqkr Yawe. Bzkq rmnq pnz waen x lue kx xplr, mz nzwztr-krbzle bade. Mqngrkxtr naprsrle nide, abzo mz mzli kc tqmncpxbe-ngrmle mz nelz lxede. ");
INSERT INTO ntu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mzli kc naetupe-ngrde, nzryapwx-krde na-ayzlu-mople doa lr Israel kxkqlu, mz Yawe, Gct ngrdr. ");
INSERT INTO ntu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jon nartwayz-kaipz mz Kxetu. Natwzle zmatq kcpwz tqtwz profet Elaeja, mz nzale-krde nzwzngr kcpwz. Murde na-amnctr-lxblr-moule trte badr doa nedrng. Na-ayzlu-mopleng krkcng trnzlxngitilru Gct mz drtwr kxtubq. Naokatrle leplz neng Gct mz nzoliqtingr nabzdr mz nzvz-krm Kxnzmcpx.” ");
INSERT INTO ntu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Rpibz Sxkaraezs mz enjrl kc kx, “Trlxngitiwxu natqm murde nipenge olman, x olvz rnge ngipe kz blang.” ");
INSERT INTO ntu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Rpibz enjrl kc kx, “Ninge Gebrel. Mnctrpo mz Gct. X atwzlr-ngrmle ninge mz nzycmne-krbo bam. Rpimle napibo nrpa kxmrlz lc bam. ");
INSERT INTO ntu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","A' trlxngitiwq natqnge, mz nzrnginengr doa ncblo. Mz nzmu-krde lc, trpengr nzycmne-krm, x nznabu-krm navz nakrlzbzle mzli kc tqyrlq Gct na-angidati-ngrde da lc.” ");
INSERT INTO ntu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Leplz kcng tzkrka'ng sc tzaenzlitrpzlr Sxkaraezs. Sc tzveatipe drtwrdr, nike mzli tqboipengr Sxkaraezs nzmncpx-krmle mz Mangr-nzangiongr. ");
INSERT INTO ntu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kx vzpxpemle, nabutxpengr. Sc tzkrlzpelr kx obq-rmwiblepe mz Mangr-nzangiongr. Sxkaraezs trpengr natq kx adcpxle. A' ycmnetxpepwz mz mqde. ");
INSERT INTO ntu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","X mzli nyzde mz nzwz-krde Mangr-nzangiongr kx yrkrpxpebzle, sc tqrkalzpem Jerusalem x vzkipele mrnyzde, mz kzdq taon ngr Judiz Provins. ");
INSERT INTO ntu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mz nibrde, olvz r Sxkaraezs, Elszbet, sc tqyrpe. A' temz nzlvqn trdwapx-pnzu yz. ");
INSERT INTO ntu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Zbz sc tqrpipele kx, “Esae ninge! Yawe okatrpele ninge mzli ka, murde ngi-batrpemle nzyr-krnge. Katxpxpebzle zmya ngr drtqnge!” ");
INSERT INTO ntu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mzli kc temz ngr Elszbet tqesz'mzpe-ngrde mz nzyr-krde, Gct kc tqatwzlrpe-ngrbzle enjrl Gebrel mz mztea Naszret mrkc Gzlili Provins. ");
INSERT INTO ntu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Twzbzle kc natq mz kzdq olvi kxmnc-kamelr drtqde Mxri. Olvi lc, nayrlzng mz kzdq kc ncblo drtqde Josip. Josip lc vzpxm mz neidu lr King Devet. ");
INSERT INTO ntu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Enjrl kc vzm bade, sc tqrpipebzle bade kx, “Nim la, Mxri! Yawe mncbz bam x mcpxpele nim mz nzamrlz-krde nim!” ");
INSERT INTO ntu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mxri trmnc-nrwx-pnz-ngru mz nabzde mz natq enjrl kc, murde tryrplatitru narde da kcng tqpibzleng. X dekc drtwrde tqvea-zvz-ngrde kx nike drtwr ngrde. ");
INSERT INTO ntu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Rpibz enjrl kc bade kx, “Mxri, bzkq mwxlrq. Murde Gct abrtzlvzle nim. ");
INSERT INTO ntu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","X nim la nayrq. X mrlxm la mzte namc, yrlqbz lc drtqde nangi Jiszs. ");
INSERT INTO ntu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nide namyalz, murde nide Mrlx Gct kc tqmyalz-esz'ngr. Gct Yawe nayrlqle nide nzngini-krde king mz nqvi lr melrmqde King Devet. ");
INSERT INTO ntu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nangini-alode king r lr Israel. X zmatq ngrde trpnzngr nzyrkrpx-krbzle!” ");
INSERT INTO ntu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Rpibz Mxri mz enjrl kc, kx, “Tryrlzwxu x ninge olvi kxmnc-kamelr. ?Nzmu-krde ke, myx kxnamule?” ");
INSERT INTO ntu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Rpibz enjrl kc kx, “Mqngrkxtr sa navzom bam. X zmatq ngr Gct kc tqmyalz-esz'ngr naprtrpz bam x na-ayrle nim. Mz drtwr lc itoto nanginide Mrlx Gct, doa kxtr. ");
INSERT INTO ntu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Napibo bam kx kxnginim Elszbet yrpe mzli ka. Kxmule-esz' blangpengr x nzrpibz vz-nrbalq murde trpnzngr nede doa, a' mzli ka temz ngrde esz'mzpe. ");
INSERT INTO ntu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Da lcng tqpibo nangida murde trpnzngr da kx rblxbz mz Gct.” ");
INSERT INTO ntu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Sc tqrpipe Mxri kx, “Nipenge kxnzawz ne Gct. Mrla tqpikimele, nangidapem ye bange.” X sc tqrlaszpe enjrl kc. ");
INSERT INTO ntu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mz nibrde Mxri oliqtx, sc tqngrlrtx-anipe mz mztea nyz Elszbet, mrlcde kc newz ngrde tqkqlu, mrkc Judiz Provins. ");
INSERT INTO ntu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mzli kc tqkrlz-ngrbzle mrkc, dwatrpz mz ma nyzde. Sc tqycmnepebz mz Elszbet, olvz r Sxkaraezs. ");
INSERT INTO ntu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kx xlrbz Elszbet nzycmnekr Mxri, itoto kc tqmncpxm mz nelzde, sc tqblcpe. X mzli kcpwz Mqngrkxtr prsrle Elszbet kcma. ");
INSERT INTO ntu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Sc tqngi-batrpebzle, nzetumipe-krbz natqde, nzrpi-krbzle mz Mxri kx, “Gct amrlzle nim myaszpxle olvz kang kqlu. X amrlz-kzle doa kc namikaq! ");
INSERT INTO ntu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kxmule-esz' ninge olvz kxnzobqszo, a' nim, lxe Kxetu Lod rnge, oklatime ninge. A' nzpnzkr drtwrnge le trnakxmuleu ka! ");
INSERT INTO ntu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Murde mzli kc tqxlrtx-ngrpwc' natqm, itoto kc tqmncpxm mz nelznge, blcmitx-pnzle nzabrtzngr. ");
INSERT INTO ntu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Amrlztxpe Yawe nim, murde nzlxngiti-krm da kx pi-ngrde nim.” ");
INSERT INTO ntu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Rpi Mxri kx, “Bilvz-zvzx Yawe mz nabznge. ");
INSERT INTO ntu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","X drtwrnge elalzm mz Gct, mz nzarlapx-krde ninge. ");
INSERT INTO ntu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Murde yc mz drtwrde ninge kxnzobqszo. X abzo mzli ka leplz narpimlr kx ninge olvz kxnzamrlz, tqvzpe tqvzpe. ");
INSERT INTO ntu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Murde Gct kc tqrninr, alepemle bange da kx myapxbzng. Drtqde tr-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Aodu-zvzle krkcng tzamrluelr nide. ");
INSERT INTO ntu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Murde aovxiole enqmi rdeng mz nzetukr zmatq ngrde. X kxnzglqpx-lzbqng nzodalitipeng. ");
INSERT INTO ntu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Apoopemle king kxnzmatqng. X avzdzbzle kx nzavzo-lzbqng. ");
INSERT INTO ntu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Rkabz dakxnzng kxmrlzting mz kxnzbrtaleng. A' krkcng tzesablqtilr nide, avzpx-nrbalqleng. ");
INSERT INTO ntu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Gct angidapele da kx esalz-ngrbzle mz melrmqgung, Ebraam, x nigu neidu lrdeng. Murde yc zvz mz drtwrde nigu lr Israel, x atwzlr-ngrmle bagu Mevalu Kxnzmcpx.” ");
INSERT INTO ntu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Zbz Mxri nzmnctilr badr Elszbet temz tq, krlzbzle mzli kx Elszbet rmika-ngrde. X mz nibrde sc tqyzlupe mou mrnyzde Naszret. ");
INSERT INTO ntu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Zbz kx krlzpebzle kc mzli nyz Elszbet nzrmc-krde mz doa, mz mrlxde kc tzmcpe. ");
INSERT INTO ntu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Lr mrnyzdeng x kxnginideng, nzxlrpelr kx Yawe amrlzpele nide mz nzrmika-krde, sc tzabrtz-lxblrpeng badr. ");
INSERT INTO ntu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mzli kc itoto kc zbq rde tqrtqmzpe-ngrde, sc tzvzpemqng mz nzrpakrngr nide, mz nzaelwapx-krde kx nide doa ne Gct. Krlc nzvz-nqblq-krde Lou sc Mosis. Nzrpilr nayrlqpebzlr drtqde nangi Sxkaraezs, drtq trtede. ");
INSERT INTO ntu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","A' rpibz lxede kx, “Trtingr. Drtqde nangi Jon.” ");
INSERT INTO ntu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nzrpibzlr bade kx, “A' trpnzngr kxnginimu kx ngi drtqde Jon!” ");
INSERT INTO ntu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Zbz sc tzycmnepebzng mz Sxkaraezs mz mqdr. Tzveatibzlr drtq kx nangi drtq doa nede. ");
INSERT INTO ntu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sxkaraezs kc tqycmnepebz mz mqde, tqrlxpebz da kx naryrongr. X yrole kx, “Drtqde Jon.” X leplz amrlx nzkctitxpxlr. ");
INSERT INTO ntu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mzli lcpwz, Sxkaraezs kc tqycmnepe mou, tqglqpxpele Gct. ");
INSERT INTO ntu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Lr mrnyzdeng amrlx prsrpeng nzmwxlrngr. Zbz nrpa ngr da lcng sc tqvzpe, talvzpxpele lr nrlar Judiz kc newz ngrde tqkqlu. ");
INSERT INTO ntu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Leplz kcng tzxlrng, sc tzaotipe drtwrdr x tzveapeng kx, “?Doa ka topwz nanginide lc elx nike?” Otxpx kx zmatq ngr Yawe ycbz bade. ");
INSERT INTO ntu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zbz Mqngrkxtr prsrle trtede, sc tqplzpxpele natq Gct kxyc-kapq, kx ycmnetr-ngrde Kxnzmcpx. ");
INSERT INTO ntu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Rpibzle kx, “Naglqpxku Yawe, Gct rgu, nigu lr Israel! Murde vzpem mz nzxpepx-krbzle nigu mz enqmi rgu. ");
INSERT INTO ntu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","X atwzlrpe-ngrmle bagu Mevalu kxmatq kx vzpxm mz nqvi lr King Devet, ncblo nede. ");
INSERT INTO ntu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Gct esalz-ngrde mz natq profet nedeng kcng bqnc, ");
INSERT INTO ntu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kx na-arlapxbzle nigu mz mq leplz kcng tztrkalr-ngrdr nigu. ");
INSERT INTO ntu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","X aelwapx-ngrmle nzyckr drtwrde melrmqgung, mz nzatutr-krde Nzesz'tikr Drtwrdr badr, ");
INSERT INTO ntu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","kc tqesalz-kai-ngrbzle mz melrmqgu Ebraam. ");
INSERT INTO ntu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Rpibzle kx sa na-arlapxbzle nigu mz mq enqmi rgung, murde ma tqmwxlrtiku nidr. A' nawztrpzku bade mz nzmncngr kxtubq x kxtr, mz zbq kang kqlu.” ");
INSERT INTO ntu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Zbz Sxkaraezs kc tqycmnetrpe-ngrde mrlxde Jon. Rpile kx, “Nim, kx mrlxnge, nanginim profet ne Gct kc tqmyalz-esz'ngr. Murde sa naokatrq leplz nedeng mz nzoliqtingr nabzdr mz nzvz-krmle. ");
INSERT INTO ntu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Napibzme badr kx naplzpxbzlr alwx ngrdrng mz Gct, murde naipqle x na-arlapxle nidr. ");
INSERT INTO ntu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","X mou, mz nzvz-nqblq-krde nzryc-zlwzkr drtwr Gct, sa na-atwzlro-ngrmle Kxnzmcpx bagu. X na-apule zyzlr. ");
INSERT INTO ntu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Murde alwx ngr leplz kxnzmnc-mrbrng akamrbr-ngrde da mz nabzdr. Kxmule-esz', a' sa namclr ncblo kc na-apule zyzlr, kc tqpnamilxtile nabzdr, murde na-aopxbzle badr lrpzki kx navzkilr mz nzrlapx-krdr.” ");
INSERT INTO ntu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Zbz doa kc yrlvzlzm x vz-nqblqle Gct mz nabzde atwrnrngr. X mzli kc tqetupe-ngrde, sc tqmncnepe lzke, vz-krlzbzle mzli kc tqaelwapxpe-ngrbz Gct le mz lr Israel mz nzngini-krde profet. ");
INSERT INTO ntu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mzli kc Herot Kc Tqmyalz tqngini-ngrde king r Judiz Provins, King kxetu ngr lr Rom kc tqmnc kz, drtqde Agzstzs. X Herot mnclzbz bade. King Agzstzs atwzlrpx-ngrde natqde kx leplz amrlx kcng tqaclvele, drtqdr nayro mz nzxpe-lxblr-krdr takes. ");
INSERT INTO ntu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Krlc nzryrongr drtq kx ayrnrngr kx krlzbzle lr Jiu mz natq kx kapx King r Rom. Mzli lcde kzdq ncblo drtqde Kwaerinizs aclvele Provins kc etu Siriz. X Herot kc tqaclvele lr Jiu mnclz-kzpz bade. ");
INSERT INTO ntu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Zbz lr Jiu amrlx sc tzyrkrpe-kzng. Ncblo esz' kc vzkipele mz taon nyz melrmqde, mz nzryrongr drtqde. ");
INSERT INTO ntu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Zbz Josip mz Mxri kc tzrkalzpemqng mztea Naszret mrkc Gzlili Provins, x sc tzvzpeng mztea Betleem mrkc Judiz Provins. Krlc mztea nyz King Devet mzli kc bqnc. Josip vzkile Betleem murde vzpxm mz neidu lr Devet. ");
INSERT INTO ntu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josip nzvzng ncdr Mxri kc tqyr, murde nzpipe kx nayrlzng ncdr x drtqdr nayc lxblr mz nzryrongr. ");
INSERT INTO ntu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mzli kc tzmnc-ngrdr Betleem, sc tqkrlzpebzle mzli kx Mxri narmc-ngrde mz doa kxtopwz. ");
INSERT INTO ntu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nzmwipxmqng mz ma nyz kzu, murde trpnzngr ma kx namnc-ngrdr. Mikatxde mrlxde kx ayrnrngr, x otibzle bulvztile lrpz. Sc tqayrbqlzpemle mz da kx nzmutio kzu. ");
INSERT INTO ntu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mz nrlckxbq lcde kzdung ncblo nzaclvelr sip nedrng mz nardzng, me esotrpz Betleem. ");
INSERT INTO ntu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kzdq enjrl ne Yawe adcpx-lzbqbz badr, zbz zyzlr kxetu kxluli rpnaobz badr, o-ngaletxde nidr. Ncblo kcng nzmwxlrszbqtx-pnzng. ");
INSERT INTO ntu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","A' rpibz enjrl kc badr kx, “Bzkq mwxlramu. Murde rtwzmc bamu nrpa kxmrlz. Nrpa lc narkabz nzabrtzngr kxetu mz leplz amrlx. ");
INSERT INTO ntu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mz nrlckxbq ka, mrkc mz taon nyz Devet, Mevalu nzmika, Kxnzmcpx kc tqngi Kxetu Lod! ");
INSERT INTO ntu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kxnamu nzglx-krmu doa lc nide sele. Namcamu dq itoto nzbulvzti lrpz, x yrbqlzm mz da kx nzmutio kzu.” ");
INSERT INTO ntu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nzpwrkilvc-ngrdr dzbe enjrl kxetu kx ngi ami kx vzom Heven, nzadcpx-lzbqpe-kzpzng. X enjrl lcng amrlx nzangrlvzlr Gct. ");
INSERT INTO ntu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Nzrpilr kx, “Takitrde nzamatqngr Gct kc tqmnc Heven kc tqyctxlz. X mz nrlc, nzmnc-zpwxngr sa naycbz mz leplz kcng tqabrtzlvzleng!” ");
INSERT INTO ntu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Zbz Enjrl kcng sc tzrlaszpelr nidr, tzyzlulzpe-moung Heven. Zbz ncblo kcng sc tzrpi-etrpelr kx, “Navzpeku ena Betleem mz nzmc-krgu da kc tqprtz, tqpipem Yawe bagu, mz natqde kc tqtwzm enjrl bagu.” ");
INSERT INTO ntu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Zbz sc tzngrlrpeng Betleem, tzmcpelr Mxri, Josip, x itoto kc nzyrbqlz-krmle mz da kx mutio kzu, da kc tqwai nzpi-krbz enjrl le. ");
INSERT INTO ntu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kx nzmcpelr itoto kc, sc tzpipebzlr mz Josip x Mxri nike enjrl kc pi-ngrde itoto kc. ");
INSERT INTO ntu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","X leplz kcng amrlx tzxlrlr nrpa lc tzkctitxpxlr da lcng. ");
INSERT INTO ntu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","X Mxri yrlq-amqngile da lcng mz nabzde, sc tqaoti-zvzpe drtwrde. ");
INSERT INTO ntu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Zbz ncblo kcng sc tzyzlupe-mopwzng mz sip nedrng, tzangrlvzlr Gct mz da kc tzxlrlr x tzmcpelr, da kc tqwai nzpi-krbz enjrl kc le badr. ");
INSERT INTO ntu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mzli kc itoto kc zbq rde tqrtqmzpe-ngrde, sc tqkrlzpebzle mzli kx napakrpe-ngrde mz nzvz-nqblq-krde Lou sc Mosis. Murde nzrpakrngr ngi rkx kx nide doa ne Gct. X sc tzyrlqpebzlr drtqde Jiszs. Drtq lc pi-pnzbz enjrl kc mz Mxri mzli kc itoto trabzoka-ngrde mz nelzde. ");
INSERT INTO ntu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Zbq nzpnu-pwx (40) otx mz nibr nzrmcngr mz Jiszs, sc tqkrlzpebzle mzli kx Mxri navz-ngrde mz Mangr-nzangiongr Yawe mrkc Jerusalem, mz nzalqngi-moungr mz nzvz-nqblq-krde Lou kxtr. X sc tzvzmipe-kzlr doa kc topwz mz nzrlrpx-krbzlrle mz mq Yawe, x nakrka'lvz kx natr x nawztrpz mz Gct kalr. ");
INSERT INTO ntu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Murde navz-nqblqlr Loukxtr mz nzrpi-krde kx, “Doa kx ngi doa ncblo kx ayrnrngr amrlx, narlrpx-ngrbz mz mq Yawe.” ");
INSERT INTO ntu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mxri x Josip nzvz-kz-ngrdr mz nzka-krdr blz ngr nzalqngingr mz nzvz-nqblq-krde Loukxtr, mz nzrpi-krde kx, “Nakabz mz pris nran nali, a' kx trpnzngr le e bona nali, nanibqbz mz Yawe.” ");
INSERT INTO ntu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mzli lcde kzdq kc ncblo mncne mrkc Jerusalem, drtqde Simion, kc tqtubq-esz'ngr mz nzobqkr Gct. Amatqle Gct mz da amrlx. X sc tqaenzlile nzvz-krm Kxnzmcpx mz nzarlapx-krde lr Israel. X Mqngrkxtr kc tqmncpxm bade, ");
INSERT INTO ntu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","pibzle bade kx namc-kaile Kxnzmcpx ne Yawe, x sc tqbz ate. ");
INSERT INTO ntu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kzdq zbq Simion mailz Mqngrkxtr Mangr-nzangiongr. Mz zbq lcde Mxri ncdr Josip nzprmitrpzlr itoto Jiszs elr, mz nzvz-nqblq-krdr Lou sc Mosis. ");
INSERT INTO ntu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","X kx mc Simion itoto kc, sc tqotipebzle, tqbrlcpele. X sc tqglqpxpele Gct x tqawipebz bade. ");
INSERT INTO ntu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","X sc tqrpipebzle kx, “Yawe, ninge kxnzawz nem. X mzli ka takitrpede nzbz-krnge. Murde atutrpeq natqm ");
INSERT INTO ntu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","mz nzmctx-angidrpe-krnge mz mzke' Mevalu nem kc tqatwzlr-ngrme mz nzarlapx-krde leplz. ");
INSERT INTO ntu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","X aelwapx-ngrbzme nide mz mz leplz amrlx. ");
INSERT INTO ntu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Murde na-apule zyzlr kc tqaelwapxbzle nqmq krm mz kxtrngiulrJiu. X nabatrpzle mz leplz nzamatq-krdr nigr lr Israel, mz nzngini-krgr doa nemqng.” ");
INSERT INTO ntu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Trte Jiszs x lxede nzkctitxpxlr natq kcng tqpingr Simion Jiszs. ");
INSERT INTO ntu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Zbz krka'lvztxbzng Simion nidr. X sc tqrpipebzle mz Mxri kx, “Doa lc mcpx Gct mz nzngini-krde rkx. X nigu lr Israel kxkqlu kxnzpxtxpx-ngrdr nide nataong. A' nigu kcng tzabrtzlvzlr nide narlapxng. ");
INSERT INTO ntu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Da kx aoti drtwr leplz sa na-aelwapx-lzbqngr mz nzabrtzlvz-krdr nide o nzpxtxpx-krdr nide. X mz nibrde nzaetq-ngrbz drtqde sa na-apule toki kx luplxtrpzle nabzm.” ");
INSERT INTO ntu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","X kzdq kc blang, mncne kz mzli lcde. Drtqde Ana kc tqngi profet. Nide inyx Fanwel, vzpxm mz nqvi lr Asz. Ana yrlz pnz mzli kc tqnginibe-ngrde olvi, x nzmnctilr mz ncblo ngrde yiz rlimz x ncblo kc sc tqbzpe. ");
INSERT INTO ntu_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Yiz ngrde nzpnu-rtqmz-nrade-pwx (84). X olvz lc vz zvz mz Mangr-nzangiongr. X mzli kang kqlu, nzangio-krde Gct vzmi nzaxtx-krbzle dakxnzng mz nzkrka'-krde. ");
INSERT INTO ntu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","X mz nabznepi lcdepwz tqmncngr Simion badr Josip x Mxri, Ana kc tqkaputrpe-kzpz mrkc tzmnc-ngrdr. Kx xlrpele natq Simion, sc tqawipebz mz Gct mz nzatwzlr-krmle Kxnzmcpx nede. X sc tqycmnetrpe-ngrde doa kc topwz, murde naxlrbz leplz kcng tzobqtipxlr Gct nzarlapx-krde lr Jerusalem, x lr Israel amrlx. X tresakiu nzpi-krbzlele mz leplz kxkqlu. ");
INSERT INTO ntu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mz nibr nzyrkrpx-krbz nzalengr da lcng amrlx tzyr mz Loukxtr, sc tzyzlupe-moung Naszret, mrkc Gzlili Provins. ");
INSERT INTO ntu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","X doa kc yrlvzlzm x xplr. X nzyrplapx-krde etu-esz'ngr murde Gct okatr-zvzle nide. ");
INSERT INTO ntu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Mz yiz kang kqlu trte Jiszs badr lxede nzvz-zvzng Jerusalem, mz nzprtrngr mz nzmungr kc tqetu tzrpibz Nzamyangr. ");
INSERT INTO ntu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Mzli kc Jiszs tqkrlzpe-ngrbzle yiz kx nzpnu-esz'-nrade-li (12), sc tzvzmipe-kzlr mz nzmungr kc mrkc Jerusalem, mz nzvz-nqblq-krde nqmq krdr. ");
INSERT INTO ntu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Zbq ngr nzmungr kcng kx yrkrpxpebzle, sc tzrkalzpemqng mz nzyzlungr mrnyzdr Naszret. A' trtede x lxede trnzkrlzlru kx Jiszs mnctxpe Jerusalem. ");
INSERT INTO ntu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Murde nzpnzkr drtwrdr kx prtrpebz mz leplz kcng tzrtwayzpe-kaing mrnyzdr. X nzvztilr zbq kxesz'. Zbz sc tzrtangrtitrpebzlr mz mzlir kxnginidrng x leplz kx nzkrlzti-lzbqng badr. ");
INSERT INTO ntu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","A' mz trnzmc-krdru nide, sc tzyzlupe-moung Jerusalem, tzrtangrtipe-moulr. ");
INSERT INTO ntu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mz zbq kratq, sc tzmcpelr mz nabz Mangr-nzangiongr Yawe. Tqwxbu mz mzlir kxnzalvztrng mz Lou sc Mosis. Tqlalztqbz badr x tqveabz badr natq. ");
INSERT INTO ntu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Leplz kcng tzlalztqbzng bade nzkctitxpxlr nzyrplatitrkr narde da x nzayzlu-krde natq kx nzrveati. ");
INSERT INTO ntu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nzpwrkilvcpengr trtede x lxede. Sc tqrpipebz lxede kx, “?Mrlxnge, nike tqale-ngrme da lc bagr? Nigr mz trtem, vztipe drtwrgr nim. Bztitxpegr nzrtangrtingr nim.” ");
INSERT INTO ntu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Rpibzle kx, “?Memule trkrlz-ngrwamuu me namnc-ngrne? ?Trkrlzwamuu kx namncx mz ma nyz Trtenge?” ");
INSERT INTO ntu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","A' tryrplatitru nardr da kc tqpibzle badr. ");
INSERT INTO ntu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Zbz sc tzvzpe-moung badr Naszret. Nzmnc-krdr kc Naszret lxngiti-txpwzle trtede x lxede. X lxede yrlqle mz nabzde da lcng amrlx. ");
INSERT INTO ntu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","X Jiszs yrlvzlzm mz nrkrdrtq. X nzyrplapx-krde etunelz, x nzabrtzlvzkr Gct nide etunepx zlwz, da kc tqwai nzabrtzlvzkr leplz nide. ");
INSERT INTO ntu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mzli kc Taebirizs tqngini-ngrde king kxetu r Rom, kzdung kz gavzna x king nzmnclzbzng bade. Kzdq nidr Pcntizs Paelzt nide gavzna ngr Judiz. Kzdq mou Herot Antipas nide king kx aclvele Gzlili. X mzle Herot, Filip, nide king kx aclvele Provins kcng Itiria x Trakonaetis. X kzdq mou Laesanias nide king kc tqaclvele Abilin Provins. ");
INSERT INTO ntu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Mzli lcde Anas nidr mz Kaefzs nidr Nardr Pris. Mz yiz kranzpnu-esz'-nrade-nzlvqn (15) kx King Taebirizs aclve-ngrde nrlc, natq Gct vzm mz Jon, mrlx Sxkaraezs, mrkc lzke. ");
INSERT INTO ntu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Mz nzlxngiti-krbz Jon natq Gct, sc tqvz-ngalepe-ngrde nrlar LueJodzn mz nzryapwx-krbzle mz leplz. Rpibzle kx, “Kx tqrpiamu kx Gct naipqpxbzle alwx ngrmu, natekqtramu nqmq nr drtwrmu x nawrkxtramu.” ");
INSERT INTO ntu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Krlc atutrle natq Profet Asaea mz nzrpi-krde kx, “Natq kzdq ncblo kx natqde etu mz nzryapwx-krbzle mz leplz lzke. Natq lcde rpibzle kx, ‘Oliqtiamu nabzmu mz nzvz-krm Kxetu Gct. Atubqtibzmu lrpzki kx nangi nyzde na-apule nzoliqtikr leplz lrpzki kx navzkim king. ");
INSERT INTO ntu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nabzlwa nayrngilvztio, newz x me yrulrtingr namnzpz'. Me ngaluti ngr lrpzki na-atubqti, x me vzo mz lrpzki nayrngilvztio. ");
INSERT INTO ntu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Murde leplz amrlx namclr Mevalu kc tqatwzlr-ngrm Gct!’” ");
INSERT INTO ntu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Zbo ngr leplz nzyrkrpxmqng mz Jon mz nzawrkxtr-krdeng nidr. Mz drtwrde kx trmrlzu, sc tqrpipebzle mz kzdung nidr kx, “Nimu kxdrka'-ngrng! Tqpokiamu! ?Neke rpibz bamu nzwrkxtrngr na-ayrbqpxle nimu mz nzayrplapxkr Gct kc navzm? ");
INSERT INTO ntu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nzwrkxtrtx-ngrpwz esz'-krde trna-arlapxleu nimu, a' na-aleamu da kx na-aelwapx-ngrde kx tekqtrpeamu nqmq nr drtwrmu kxtrka. X bzkq rpiamu mz drtwrmu kx, ‘Rlapxpekr murde Ebraam ngi melrmqgr. X nigr angidr leplz kx mcpx Gct.’ Murde napi-pnzbo bamu kx nzmu trnavz-nqblqwamuu lrpzki r Gct mz nzarlapx-krde leplz, krlzle nzbatr-krbzle doa neng Ebraam nzvzpx-krmleng mz rlpz lcng, mz nzatutr-krde da kx esalz-ngrbzle bade. ");
INSERT INTO ntu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Gct apule ncblo kx twzle akes scde x oliqtile nzrlakitiongr nounc x rtctxlz-ngrde mz nyr, murde trnzpapx-ngrdru nradr kxmrlz. Sa tqoliqtile mzli ka nzangc-krde leplz mz nyr ngr nzayrplapxngr, nidr kcng nqmq krdr trtubqu x nzpxtxpx-ngrdr nztekqtr-krdrle.” ");
INSERT INTO ntu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Zbz leplz kcng nzveabzng mz Jon, nzrpibzlr kx, “?Nike nawaipekr?” ");
INSERT INTO ntu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Rpibzle kx, “Kxrngisc nzkq kxli nakabzle kzdq mz kx trpnzngr scde nzkq. X kxrnginan dakxnzng narka-ngrde.” ");
INSERT INTO ntu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kzdung mrlx kcng tzatakqting takes nzvz-kzpqng mz nzawrkxtrngr nidr. Zbz sc tzrpipebzlr kx, “Kxakrlz! ?E nike nawaikr?” ");
INSERT INTO ntu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Rpibz Jon kx, “Takes kx otibzmu mz leplz, bzkq myaszlzle narncbr kc tqyrlq gzpman ngr Rom naxpe ncblo kxesz'.” ");
INSERT INTO ntu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kzdung ncblo ngr vea nzvea-kzpzng, nzrpibzle kx, “?X nigr x? ?Nike nawaikr?” Rpibzle kx, “Bzkq amwxlramu leplz mz nzrka-krbzlr bamu trau. X bzkq pokiatitramung. A' naesapxngr drtwrmu trau kx nzxpe-ngrmu.” ");
INSERT INTO ntu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Leplz amrlx tzobqtipxlr nzvz-krm Kxnzmcpx, x kx nzmcpelr kc Jon drtwrdr kc tzaotrpebzlr kx, “Mwx Kxnzmcpx nide kape.” ");
INSERT INTO ntu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Krlztitrpebz Jon nzaotikr drtwrdr kc, sc tqrpipebzle badr kx, “Awrkxtrx nimu mz lue. A' kzdq la ncblo navzm mz nibrnge, kc tqmyaszlzle ninge. X trtakitrpwc'u nzwztr-ngrbz bade, kxmule-esz' nzryokaepxngr nqvi lr sadol ngr nanycde. Na-awrkxtrle nimu mz Mqngrkxtr x nyr ngr nzalqngingr. ");
INSERT INTO ntu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Mz nzvz-krmle sa napipxle kx leplz nztubqng o trtingr. X nakapxmle leplz kxnzmrlzng mz leplz kxnztrkang, x sc tqamnc-angidrpeleng Heven. A' leplz kxnztrkang sa na-angcpeleng mz nyr kx ngc alo.” ");
INSERT INTO ntu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mz natq kxkqlu mou, rngidrlvz-ngrbzle da mz leplz lcng, mz nzryapwxpx-krbzle badr kxmu Gct nzarlapx-krde leplz. ");
INSERT INTO ntu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","X Jon lclvz-kzpzle King Herot Antipas mz da kxkqlu kxtrka kx aletile. X tqrpipebzle kx natekqtrle nqmq nr drtwrde. Murde krnalz mzlede, drtqde Herodizs, tqyrlztibzle. A' mzlede lc sc tqlube. ");
INSERT INTO ntu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Zbz king Herot ale-moule kc da kx trkatxpxbz mz nzngyatikr drtwrde Jon, murde tqlclvzbz Jon nqmq krde kcng tqtrka. Atwzlr-ngrbzle kcng ncblo ngr vea, sc tzadwatrpelr Jon mz presin. ");
INSERT INTO ntu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","X kzdq zbq mzli kc Jon trvztrka-ngrde mz presin, mz nibr leplz amrlx nzwrkxtr-krdr, Jiszs kc tqwrkxtrpe kz. X mzli kc tqkrka'-ngrpwzle, Heven nzlvxpx, ");
INSERT INTO ntu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","x Mqngrkxtr vzom bade mz nrkrdrtq kx apule nran. X kzdq natq rpiomle Heven, rpile kx, “Nim Mrlxnge Kxnzmrlzti. X abrtzlvz-zlwzx nim.” ");
INSERT INTO ntu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Mwx yiz ngr Jiszs nzpnu-tqpe (30) mzli kc tqabzo-ngrde nzwz-krde. Nzpnzkr drtwr leplz le ngi mrlx Josip. Josip ngi mrlx Heli. ");
INSERT INTO ntu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli ngi mrlx Matat. Matat ngi mrlx Livae. Livae ngi mrlx Malakai. Malakai ngi mrlx Janai. Janai ngi mrlx Josip. ");
INSERT INTO ntu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josip ngi mrlx Matataeas. Matataeas ngi mrlx Emos. Emos ngi mrlx Naham. Naham ngi mrlx Esli. Esli ngi mrlx Nagae. ");
INSERT INTO ntu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagae ngi mrlx Maat. Maat ngi mrlx Matataeas. Matataeas ngi mrlx Semen. Semen ngi mrlx Josxk. Josxk ngi mrlx Joda. ");
INSERT INTO ntu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda ngi mrlx Joanzn. Joanzn ngi mrlx Resz. Resz ngi mrlx Serubabel. Serubabel ngi mrlx Seltiel. Seltiel ngi mrlx Nerae. ");
INSERT INTO ntu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerae ngi mrlx Mxlki. Mxlki ngi mrlx Adae. Adae ngi mrlx Kosam. Kosam ngi mrlx Elmadam. Elmadam ngi mrlx Er. ");
INSERT INTO ntu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ngi mrlx Josua. Josua ngi mrlx Eliesa. Eliesa ngi mrlx Jorim. Jorim ngi mrlx Matat. Matat ngi mrlx Livae. ");
INSERT INTO ntu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livae ngi mrlx Simion. Simion ngi mrlx Judz. Judz ngi mrlx Josip. Josip ngi mrlx Jonam. Jonam ngi mrlx Eliakim. ");
INSERT INTO ntu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim ngi mrlx Melea. Melea ngi mrlx Mena. Mena ngi mrlx Matata. Matata ngi mrlx Neitzn. Neitzn ngi mrlx King Devet. ");
INSERT INTO ntu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","King Devet ngi mrlx Jesi. Jesi ngi mrlx Obed. Obed ngi mrlx Boas. Boas ngi mrlx Salmon. Salmon ngi mrlx Nason. ");
INSERT INTO ntu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason ngi mrlx Aminadab. Aminadab ngi mrlx Admin. Admin ngi mrlx Arnae. Arnae ngi mrlx Hesron. Hesron ngi mrlx Peres. Peres ngi mrlx Judz. ");
INSERT INTO ntu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judz ngi mrlx Jekop. Jekop ngi mrlx Aesak. Aesak ngi mrlx Ebraam. Ebraam ngi mrlx Tera. Tera ngi mrlx Neor. ");
INSERT INTO ntu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neor ngi mrlx Seruk. Seruk ngi mrlx Reu. Reu ngi mrlx Pelek. Pelek ngi mrlx Ebr. Ebr ngi mrlx Sela. ");
INSERT INTO ntu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela ngi mrlx Kainzn. Kainzn ngi mrlx Arpaksat. Arpaksat ngi mrlx Sem. Sem ngi mrlx Noa. Noa ngi mrlx Lamxk. ");
INSERT INTO ntu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamxk ngi mrlx Mxtusxla. Mxtusxla ngi mrlx Inck. Inck ngi mrlx Jarxt. Jarxt ngi mrlx Maalalil. Maalalil ngi mrlx Kenzn. ");
INSERT INTO ntu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenzn ngi mrlx Enos. Enos ngi mrlx Set. Set ngi mrlx Adzm. Adzm wzngr Gct. ");
INSERT INTO ntu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Mz nzprtz-krm Jiszs mz LueJodzn mz nibr nzwrkxtr-krde, mncpx-ngrm Mqngrkxtr vz-krlzbzle nzvzdz-krde Heven. Zbz Mqngrkxtr sc tqmailztrpele nide lzke. ");
INSERT INTO ntu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Zbq nzpnu-pwx (40) mnctile lzke, tqtamiti Setzn, murde rpile na-ataole mz alwx, a' trtao-pnzu. Mzli kcng tqmnctile mrkc tqaxtx-ngrbzle dakxnzng mz nzkrka'-krde. X kx ycpe pipz nzyrkrpx-krdeng, nelzde kc tqbrtalepe. ");
INSERT INTO ntu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Zbz sc tqrpipebz Setzn bade kx, “Kx tqnginim Mrlx Gct, e aelwapx-ngrm bange x pibz mz rplz lc nalrtipxle bret.” ");
INSERT INTO ntu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Rpibz Jiszs kx, “Trtingr. Murde nzyro mz Nzryrngrkxtr kx, ‘Doa trlutx-ngrpwzleu nzmu-krde dakxnzng.’” ");
INSERT INTO ntu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Zbz Setzn kc tqmailzlzpele Jiszs mz newz kx ycpx wq, sc tqaelwape-ngrbzle mrkcng amrlx tzaclve king r nrlc, mzli kxpipzpwz. ");
INSERT INTO ntu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Rpibz Setzn bade kx, “Sa nakabo bam drtc' lcng tzmailz king x zmatq ngrdr. X naka-kzpo nzmyalz-krdrng. Nzkatipem bange amrlx x mrlc tqycpe-ngrde, krlzx nzrka-ngrbz mz doa kc suti drtwrnge naka-nebangeleng. ");
INSERT INTO ntu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nzmu nayrngzome bange mz nzangio-krm ninge, da amrlx sc tqngiscpem na-aclveq.” ");
INSERT INTO ntu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Rpibz Jiszs kx, “Trtingr. Trna-angiowxu nim murde Nzryrngrkxtr rpile kx, ‘Angio txpwz Kxetu Yawe kc tqngi Gct ngrm x wztxtrpwz bade!’” ");
INSERT INTO ntu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Zbz Setzn kc tqmailzpele Jiszs Jerusalem, sc tqamncopemle mz kzdq nctq bute' kx yctxlz zlwz mz Mangr-nzangiongr. Sc tqrpipebzle kx, “Kx tqnginim Mrlx Gct, e atao-lzbq mrka. ");
INSERT INTO ntu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Trpnzngr nztakr-krm murde Nzryrngrkxtr rpile kx, ‘Pipebz Yawe mz enjrl nedeng nztu-krbzlr mz nibrm, x nzaclve-angidr-krdr nim drlvekeng vzkiq. ");
INSERT INTO ntu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Naglqlr nim mz mqdr, murde nanycm ma tqtcprtr mz rplz.’” ");
INSERT INTO ntu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","A' rpibz Jiszs kx, “Trtingr. Murde Nzryrngrkxtr rpi-kzle kx, ‘Bzkq atalzamu Yawe, Gct rmu.’ ” ");
INSERT INTO ntu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mz nibr Setzn nztamiti-krde Jiszs mz nzrtamitingr lcng amrlx, sc tqvzpe mz nzaenzlingr nzwrde kzble. ");
INSERT INTO ntu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Zbz Jiszs kc tqyzlupe mou mz provins kc Gzlili, x zmatq ngr Mqngrkxtr ycbz bade. Nrpa ngr da kcng tqaletileng sc tqtalvzpx-atwrnrpe-ngrde Gzlili. ");
INSERT INTO ntu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Alvztrpe mz mangr-nzkrka'ngr nyzdrng x nzglqtxpx leplz amrlx. ");
INSERT INTO ntu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Zbz Jiszs kc tqvzpe Naszret, kc tzabuti-ngrde. X mzli kcpe mz kzdq Sabat, sc tqvztrpe mz mangr-nzkrka'ngr, da kc tqwai-zvzle. Sc tqtulzpe mz nzrlwxngr Nzryrngrkxtr. ");
INSERT INTO ntu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Sc tzkapebz bade buk sc Profet Asaea kc bqnc. Kawxtxpxle buk kc, sc tqmcpele mrkc tqrpile kx, ");
INSERT INTO ntu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Mqngr Kxetu Yawe sa tqprsrle ninge, x mcpxle ninge mz nzyapwxtipx-krbo Nrpakxmrlz mz leplz kcng tzobqszongr. Atwzlr-ngrmle ninge mz nzodati-krnge zmatq ngr alwx, murde leplz amrlx narlapxng. X vz-ngrmc nzamrlz-krbo mz krkcng mztr tqkcba, murde naobq-moung. Gct atwzlr-ngrmle ninge mz nzarlapx-krnge krkcng tzatrkating. ");
INSERT INTO ntu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","X vz-ngrmc mz nzrpipxngr kx krlzpemle mzli r nzaodukr Yawe leplz nedeng mz nzarlapx-krdeleng.” ");
INSERT INTO ntu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Zbz Jiszs apqbrtxtrle buk kc, sc tqkape-mopwzle mz kxaclve ma kc, x sc tqwxbuope mz nzalvztr-krde nidr. Mztr leplz kcng amrlx tzyrlwrpxmqng mangr-nzkrka'ngr kc tutxpepwz bade, murde nzrpilr naxlrbzlr da kx na-alvztr-ngrde nidr. ");
INSERT INTO ntu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","X sc tqycmnepebz badr, tqrpipebzle kx, “Natq Gct lc sa tqtutrpe mzli kapwz tqxlr-ngrnamule mzbq ka!” ");
INSERT INTO ntu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Leplz lcng nzkctitxpxlr natq kcng tqabrngztile nzrpingr. A' mz drtwrdr trmrlzu badr, x sc tzrpipelr kx, “Krlc mrlx Josip xke!” ");
INSERT INTO ntu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jiszs krlztitrpebzle drtwrdr, sc tqrpipebzle kx, “Krlzx kx sa narpimamu bange kx, ‘Abrngz-lzbq, kx dckta.’ Murde rpiamu kx namc-kzamu mrka mz mztea nyzmu rkx kcpwz tqalex Kzpznizm! ");
INSERT INTO ntu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","A' da zpwxtx lc napibo bamu. Kxmule-esz' lr mztea amrlx nzamatqlr profet, a' lr mztea nyzde trnzamrluelru nide. ");
INSERT INTO ntu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kxmule-esz', a' lalztqmamu bange, murde naycmne-ebzpxbo da nali. Da kx ayrnrngr, mz mzli nyz profet Elaeja, tewa trdctileu yiz tq x ncte kc. X tao kc dzbi kxetu mz nrlc tulvzo. Kxmule-esz' olvz kxnzbzsz ncblo ngrdr nzkqlung mrkc Israel, ");
INSERT INTO ntu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","a' Gct tratwzlr-pnz-ngrpwzleu Elaeja mz kzdq nidr mz nzokatr-krdele. A' atwzlr-alzu-ngrpwzle mz kzdq kz olvz kxtrngiulrJiu. Ni-kzde kxbzsz ncblo ngrde, a' ngi olvz lr mztea Sarefzt, mz nrlarnrlc kc mz taon kc etu Saedon. ");
INSERT INTO ntu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","X da krali, mz mzli nyz profet Elaesa, kxmule-esz' leplz kx zti lepz nzkqlung kx nzmncng Israel, a' trpnzngr nidr kx amrlz mou profet kx atwzlr-ngrm Gct. A' ngi txpwz Naaman kxtrngiulrJiu, doa lr Siriz Provins.” ");
INSERT INTO ntu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Zbz leplz kcng tzyrlwrpxmqng mz mangr-nzkrka'ngr kc, drtwrdr sc tzngyape kx nzxlrbzlr natqde lcng. ");
INSERT INTO ntu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nztulzmqng sc tzapepxpelr Jiszs mz mztea kc. Nzvzmilzbzlr mz nar newz kc tqyco-ngrm mztea kc. Murde nzrpilr na-apeolr mz nqngitrlqli kc. ");
INSERT INTO ntu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","A' Jiszs prtxtrpz mz mzlirdr, sc tqvzpe. ");
INSERT INTO ntu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Zbz Jiszs kc tqvzpe mz mztea Kzpznizm mrkc Gzlili. Sc tqalvztrpele leplz kcng mz Sabat kc. ");
INSERT INTO ntu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nzkctitxpx-zlwzlr nzalvztr-krde, murde ycmnemile zmatq angidr. ");
INSERT INTO ntu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","X kzdq kc ncblo kx mncpx-ngrm drka' mncpxm mz mangr-nzkrka'ngr kc. Sc tqnetxpxpe mz natqde kxwzpx. ");
INSERT INTO ntu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Rpipele kx, “Vrr! Vzpe Jiszs kc Naszret! Vz, dwasz nigr! Vz-ngrme nzodati-krm nigr! Krlzx ncblo kznike tqnginim! Nim Ncblo Kxtr kc tqatwzlr-ngrm Gct!” ");
INSERT INTO ntu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","A' ycmne-plztitxtr Jiszs drka' kc. Rpibzle kx, “Mnc-lrpi! Dwapxm mz ncblo la!” Drka' kc rtctxo-ngrbzle ncblo kc mz mztr. X sc tqprszpxpe mz ncblo kc. A' drka' kc trataki-pnzleu nide. ");
INSERT INTO ntu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Leplz lcng nzkctitxpxlr, x sc tzrpi-etrpelr kx, “?Nike tqpiq? Murde mz natq kx kabzle mz drka' kcng, vzmi pnz zmatq x nzxplrngr. X drka' kcng nzprpx-pnzmqng mz ncblo kc!” ");
INSERT INTO ntu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Zbz nrpa ngr Jiszs sc tqtalvzpxpele Gzlili Provins. ");
INSERT INTO ntu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jiszs rkalzm mz mangr-nzkrka'ngr kc, x sc tqvzpe ma nyz Saemon. A' kzdo Saemon kc tqngi olvz, sc tqyagox, drtqde tqpqpxm. Sc tzrpipebzlr mz Jiszs kx na-alebzle du da bade kx nabrngz-ngrde. ");
INSERT INTO ntu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jiszs vzbz, yrngzobz bade x ycmne-plztitrle zyagox kc. X zyagox kc yrkrtxpx pnz. X mzli kcpwz tutxlzm, sc tqoliqtipebzle dakxnzng nadr. ");
INSERT INTO ntu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mzli kc nepi tqtaope-ngrde, mz nibr Sabat, leplz kcng nzvzmimlr mz Jiszs kztedrng kcng tzyagoxting, mz nzyagoxngr kx bletipx lxblr. Mqde yrlqobzle mz leplz amrlx, x amrlzleng nidr mz nzyagox-krdr. ");
INSERT INTO ntu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","X maszlrpx-kz-ngrbzleng drka' mz leplz kxkqlu. Drka' kcng tzneng, tzrpilr kx, “Nim Mrlx Gct!” A' ycmne-plztitxtr Jiszs drka' lcdeng. X tr-rlr-ngrpwzleu nzycmne-krdr, murde nzkrlzlr kx nide Kxnzmcpx. ");
INSERT INTO ntu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mzli kc nrlc tqngrlxnepxpe-ngrde, Jiszs rkalzm mz mztea kc, x sc tqvzpxpe mz kzdq me nakrka'-ngrde. Zbz leplz kcng sc tzrtangrtipelr nide. X kx nzmcpelrle, nzrpilr narpwa'pe-ngrdr kx bzkq vzpe. ");
INSERT INTO ntu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","A' rpibzle badr kx, “Nayapwxtipx-kzpo Nrpakxmrlz mz leplz mz kzdung kz mztea, kx Gct sa tqvectrpemle leplz mz nzmnclz-krbzlr bade mz nzngini-krde King rdr. Murde delc tqngi nou nzvzo-krmc mz nrlc ka.” ");
INSERT INTO ntu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Zbz Jiszs kc tqryapwxpxpem mz mangr-nzkrka'ngr kxkqlung mrkcng tzmnc-ngrdr lr Jiu. ");
INSERT INTO ntu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kzdq mzli Jiszs tu mz nabz drta' ngr Dxbu Gzlili. Leplz nzdrlvztxtr-lzbqpwzng mz nzyrlwr-ngalelvz-krdr nide, mz nzlalztq-ngrbz bade mz natq Gct. ");
INSERT INTO ntu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Mcle bot li kx nzaminilz mz nabz drta', prszopeng mrlx kcng tzrmwa-ngrng. Nzpoopemqng, sc tzwztipelr br scdrng. ");
INSERT INTO ntu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jiszs prtxlz mz kzdq bot lcdeng, kx ngi sc Saemon. Murde naycmnebz badr amrlx ngrdr, x ma tzbolikilvztilr nide. Sc tqrlxtipebz Jiszs mz Saemon kx na-alvcpxbzle mz dxbu kxpipz. Jiszs wxbutxlzm mz nabz bot kc, sc tqalvztrpele zbo ngr leplz kcng. ");
INSERT INTO ntu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mzli kc tqyrkrpxpe-ngrbz nzryapwx-krde, sc tqrpipebzle mz Saemon kx, “Alvcpxbz bot scm me boongr lue. X nimu badr kztem lang, sc tqapoopeamu br scmu. Sa na-aprtzamu kzdung nc.” ");
INSERT INTO ntu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Rpibz Saemon kx, “Kxetu, kxputxkr kau mzli boitx, a' trtxpnzngr nc kx prtz mz br. A' rpiq kx na-apookr br lc, na-apoopekr ye.” ");
INSERT INTO ntu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nzapotxolr br kc, x nzaprtz-pnzlr nc kqlutx pnz. Br kcng nzmulr nabxpli zpwx, murde nzyrbu-krdr mz nc. ");
INSERT INTO ntu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Sc tzayaglqpebzlr mqdr mz kztedrng kcng tzmncomqng mz bot kzble, kx nayamqng x naokatrpzlr nidr. Nzyamqng x nznulvzlr bot kcng mz nc. X nzmulr nabootxng. ");
INSERT INTO ntu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kx mctxpe Saemon Pita da lc, rweobz zpr mz Jiszs, sc tqrpipebzle kx, “Rlasz txpwz ninge, kx Kxetu rnge! Murde trtakitrpwc'u nzesotr-krbo bam. Ninge ncblo kx alwx ngrde ycbz!” ");
INSERT INTO ntu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pita badr leplz lcng nzkctitxpxlr blzmr nc kcng tzaprtzlr. ");
INSERT INTO ntu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Kzte Saemon nzling, Jemes nidr mz Jon, mrlxng Sebedi, nzkctitxpx-atwrnr-kz-ngrdr. Rpibz Jiszs mz Saemon kx, “Bzkq mwxlrq. Abzo mzli ka sa na-alvztrpo bam nzrtangrngr leplz, kx nangi nengeng.” ");
INSERT INTO ntu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nztetxlzlr bot scdr mz nabz drta', nzdwasztxdr da amrlx, x sc tzvz-nqblqpelr Jiszs. ");
INSERT INTO ntu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kzdq mzli, Jiszs mncpxm mz kzdq taon mrkc tqmncngr kzdq ncblo kx ycngr lepz. Ncblo lcde ngabq kxsqki. Kx mcle Jiszs, rweobz zpr bade, mzte obqo, x sc tqyrnitrpebz bade, mz nzrpi-krde kx, “Kxetu, kx tqsuti drtwrm le, krlzx kx krlzq nzamrlzngr ninge!” ");
INSERT INTO ntu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kxmule-esz' mz Lou sc Mosis batrpzle trnztakitr-krdeu nide mz nzprtrngr mz nzangiongr, a' maletxtrpzle nide. X sc tqrpipebzle kx, “Mrlzm bange. Namrlzq.” X mzli kcpwz lepz kc dwasztx-pnzle ncblo kc. ");
INSERT INTO ntu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Zbz Jiszs rkabz natq, rpibzle bade kx, “Bzkq ena ncblo kx napi-nebanle. A' vz-kaipz mz pris, x pibz bade napwxlitibzle nim, kx namcpzle kx mrlzpeq. Zbz sa napipxbzle mz leplz, murde namnc-lxblr-mouamu badr. X kabz mz Gct blz kx nangi dalr nzamrlzngr nim mz nzyagox-krm, da kc tqwai nzpikr Lou sc Mosis le, x nakrlzngr leplz amrlx le kx tubqpeq mz Loukxtr.” ");
INSERT INTO ntu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","A' nrpa ngr Jiszs sc tqvzlvzpx-ngrde nrlarnrlc kcng. X zbo ngr leplz nzyrkrmqng mz nzxlr-krdr nide x nzamrlz-krde nidr mz zyagox ngrdr. ");
INSERT INTO ntu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","A' Jiszs sc tqvzpx zvz mz kzdung nrlc kx namncne-ngrde esz'-krde mz nzkrka'-krde. ");
INSERT INTO ntu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kzdq zbq, mzli kx Jiszs alvztr-ngrde, kzdung Farzsi x kxnzalvztrng mz Lou sc Mosis sc tzwxbu-kzng mrkc. Ncblo lcng nzyrkrpxmqng mz taon kcng amrlx tzycpxmqng Gzlili, x mz mzteadau Jerusalem x mz kzdu-kzng taon kcng tzycpxmqng Judiz. Mzli lcde, zmatq ngr Yawe sc tqycpxm mz Jiszs mz nzamrlz-krde kxnzyagoxng. ");
INSERT INTO ntu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kzdung ncblo nzvzmqng, nzglqmlr kc ncblo kx nrkrdrtqde bz. Nzglqtimlr kzdq nqni. Nzrpilr naglqtrpzlr brma mz ma kc, murde na-ayrbqtrpzlr mz Jiszs x na-amrlzbzle nide. ");
INSERT INTO ntu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","A' rblxtx nzvzmitr-krbzlrle mz Jiszs murde ncblo nzkqlu-zlwzng mrkc. Sc tzo-zlilzpelr ladz ngr ma kc, mz nzglqlz-krdrle mz nibr ma kxmnzpz'. Nzaobqtxlzlr kc nrlc mrkc mz nibr ma. X sc tzavoopebzlr ncblo kcma mz nqni pnrde. Nzavotxobzlr mz mzlir dzbe leplz kcng, mrkc tqlxlvrkipxbz Jiszs. ");
INSERT INTO ntu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kx krlztrpz Jiszs nzbrtikr drtwrdr nide mz nzamrlz-krde kztedr, sc tqrpipebzle mz ncblo kc tqyagox kx, “Mzlenge, alwx ngrmqng ipqpxpebo.” ");
INSERT INTO ntu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Lr Jiu kcng tzalvztrng mz Lou sc Mosis x Farzsi kcng sc tzrpi-etrpelr kx, “Rlr! Mrlx lc pivxile Gct. Murde Gct txpwz kx krlzle nzipqpxngr alwx!” ");
INSERT INTO ntu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","A' Jiszs krlztitrpebzle nike pnz drtwrdr, sc tqrpipebzle badr kx, “Bzkq nzao-krmu drtwrmu kxmule lc. ");
INSERT INTO ntu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nzmu narpibo mz ncblo lc kx, ‘Ipqpxpebo alwx ngrm,’ rblx nzrmcngr. A' nzmu narpibo bade kx, ‘Tulzm, x vzpe,’ opx angidr nzrmcngr. ");
INSERT INTO ntu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mz nzmu-krde lcde, sa na-amrlzbo nrkrdrtqde mz nzaelwapx-krnge kx ninge, Mrlx Leplz, rngisc-kznge zmatq ngr nzipqpxngr alwx mrka mz nrlc.” X sc tqrpipebzle mz ncblo kc nrkrdrtqde tqbz kx, “Mrlxnge, tulzm, oti nqni pnrm x vzpe mrnyzm!” ");
INSERT INTO ntu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mzli kcpwz ncblo kc tutxlz-pnzm mz mztr amrlx ngrdr. Otibzle nqni kcma tqmnzo-ngrmle, sa tqvzpe mrnyzde. Kx tqvzle kc, sc tqglqpxle Gct. ");
INSERT INTO ntu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Leplz amrlx nzkctitxpx-atwrnr-ngrdr x nzglqpx-kzlr Gct. Nzamatq-zlwzlr Gct, sc tzrpipelr kx, “Mzbq ka rmcku da kx blepx atwrnrngr.” ");
INSERT INTO ntu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mz nibr da lc, Jiszs vzpx x mcle kzdq ncblo kx atakqti takes. Drtqde Livae, x kzdq kz drtqde Matiu. Sc tqwxbu mz ofis nyzde kc tzxpekitr takes. Rpibz Jiszs bade kx, “Vz-nqblqm ninge.” ");
INSERT INTO ntu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Livae tutxlzm, axtxtxbzle da amrlx, x sc tqvz-nqblqpele Jiszs. ");
INSERT INTO ntu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Zbz Livae wz-ngrbzle mz Jiszs kc nzmungr kxetu mz ma nyzde. Mz nzmu-lxblrngr kc ycbz ncblo kxnzatakqting takes kx nzyrkrmqng, x kzdung kz mou ncblo kx nqmq krdr trka mz nzobqkr leplz. ");
INSERT INTO ntu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kzdung Farzsi x ncblo kcng tzalvztrng mz Lou sc Mosis, kx nzngini-kzdr Farzsi, drtwrdr lctrpz mz ncblo neng Jiszs. Nzrpibzlr kx, “?Memule tqmu-lxblr-ngrnamu badr kxnzatakqting takes x kzdung kz leplz kxnztrkang?” ");
INSERT INTO ntu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Rpibz Jiszs kx, “Leplz kx trnzyagoxung trnzsutiu drtwrdr dckta. A' kxnzyagoxng la tzsuti drtwrdr dckta. ");
INSERT INTO ntu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Trvz-ngrpwc'u nzrkqlengr leplz kx nzrpilr nztubqng. A' vz-ngrmc nzrkqlengr kxnzaleng alwx, murde naesablqtilr alwx ngrdrng.” ");
INSERT INTO ntu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kzdung leplz nzrpibzlr mz Jiszs kx, “Oblamzng Jon Kxawrkxtr nzaxtx-zvz-ngrbzlr dakxnzng mz nzkrka'-krdr. X wai kz oblamzng Farzsi kcng. A' ncblo nemqng trnzaxtxdru dakxnzng, a' nzmutx-zvzng.” ");
INSERT INTO ntu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Sc tqrpipebz Jiszs kx, “Apux ncblo kxnayrlz. Mz nqmq lcpwz trtakitrdeu leplz nzaxtx-krdr dakxnzng mz mzli r nzabrtzngr mz nzyrlzngr, trtakitr-kzdeu ncblo nengeng nzaxtx-krdr dakxnzng mzli ka. Murde nzabrtz-ngrdr ninge lc tqmncbepo badr. A' mz nibrde, mzli kc nakatxpx-ngrmc badr, sc tqtakitr-atede nzaxtx-krdr dakxnzng mz nzkrka'-krdr. ");
INSERT INTO ntu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","“Nzycmne-ebzpxngr lcng li nzaelwxpx-ngrdr nqmq krnge kxmrna. Murde trpnzngr ncblo kx narpesalipxm muli nzkq kxmrna, sc tqkxsilvztrpele mz nzkq kxblzlongr. Nzmu nawailele, sc tqatrkatipele nzkq kc tqmrna, x muli lrpz kc tqmrna, nzobq-krdr trkxmulru esz' mz lrpz kc tqblzlongr. ");
INSERT INTO ntu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","X trpnz-kzngr ncblo kx narbzlutr dakxnzng kxmrna mz ncblei kx nzrbzlutrpengr dakxnzng. Murde ncblei kxmule lcde ngcplxtxtr kai mz nzmrnabekr dakxnzng, x da lcng li sc tzatrkatipeng. ");
INSERT INTO ntu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","A' dakxnzng kxmrna nabzlutrpwz mz ncblei kxmrna. ");
INSERT INTO ntu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Murde rblxbz mz leplz kcng tzabrtzlvzpelr nqmq kcng pnz nztekqtr-krdr nqmq krdr mz nztwz-krdr nqmq kxmrna. Apule ncblo kx pxtxpx-ngrde nzrmnq-krde waen kx nzwz-atengr, murde mz drtwrde rpile kx, ‘Kx yc pnz mrlz.’” ");
INSERT INTO ntu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mz kzdq zbq ngr nzangiongr, kc tqrpibz Sabat, Jiszs badr ncblo nedeng nzo-zlilr lrpzki kx vztr mz kzdung lclr wit. Ncblo nedeng sc tzcpqpxpemqng nra wit. Nzwitilr mz mqdr mz nzdwasz-krdr bedr, sc tzngqtipelr. ");
INSERT INTO ntu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Zbz kzdung Farzsi sc tzrpipebzlr kx, “?Nike tqxpqbrlr-ngrnamu Lou sc Mosis mz nzwz-krmu mz Sabat?” ");
INSERT INTO ntu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","A' mz nzaelwapxkr Jiszs kx takitrde nzokatrngr ncblo mz Sabat, sc tqayzlupebzle natqdr rpibzle kx, “Krlz-angidr-kzamu da kc tqale melrmqmu King Devet kc tqamatqamu, mzli kc tzbrtale-ngrdr badr ncblo nedeng! ");
INSERT INTO ntu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Devet vztr mz ma nyz Gct. Otile bret kc tzkabz mz Gct tqngi blz, kabz Nardr Pris, x ngqde, x ka-kzpzle mz ncblo nedeng. A' da lc tqrpwa'ngr Lou scgu. Murde Lou scgu rpile bret kxtr nangqpwz pris. ");
INSERT INTO ntu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ninge Mrlx Leplz kc tqngininge Kxetu r Sabat. X rngiscnge zmatq mz nzpnzkr drtwrnge da kx takitrde nzalengr mz Sabat.” ");
INSERT INTO ntu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mz kzdq mou Sabat, Jiszs vztr mz kzdq mangr-nzkrka'ngr, sc tqalvztrpe. Kzdq kc ncblo tqmnc kz mrkc. Mqde kxrtc bz. ");
INSERT INTO ntu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kzdung Farzsi x kxnzalvtrng mz Lou sc Mosis nzrtangrtrpzng da kx navz-rbrti Jiszs. X namclr nzmu kx tqamrlzle kxnzyagoxng mz Sabat. Murde mz drtwrdr nzamrlzngr doa kxnzyagoxng ngi nzwzngr. ");
INSERT INTO ntu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","A' Jiszs krlztitrpebzle drtwrdr, sc tqrpipebzle mz mrlx kc mqde tqbz kx, “Tulz x vzpxm. X tu mrlc.” Mrlx kc tutxlz x sc tqtupe mrkc. ");
INSERT INTO ntu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Zbz sc tqveatipebz Jiszs mz leplz kcng kx, “?Nike rlrpxngr Lou scgu nzalengr mz Sabat? ?Nzokatrngr leplz o trtingr? ?Nzarlapxngr nzlukr ncblo o nzrlr-ngrbz nzbz-krde? Krlz-angidramu kx Lou scgu rlrpx-ngrmle bagu nzalengr da kxmrlzti mz Sabat!” ");
INSERT INTO ntu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jiszs obq-ngale-ngrde nidr amrlx ngrdr, sc tqrpipebzle mz ncblo kc kx, “Atwztqpx mqm.” Atwztqtxpxle mqde, x brngztx pnz mou. ");
INSERT INTO ntu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","A' Farzsi kcng badr krkcng tzalvztrng, drtwrdr ngyatx atwrnrngr. Sc tzrpi-etrpeng da kx nawaisr-ngrdr Jiszs. ");
INSERT INTO ntu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kzdq zbq mzli lcdeng, Jiszs vzdz mz kzdq newz murde nakrka'. Mz nrlckxbq kc boi sc tqmnc ye mrkc, tqkrka'bz mz Gct. ");
INSERT INTO ntu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Zbz nrlc kx ngrlxopebzle, sc tqkqlepele ncblo nedeng. X mcpxle ncblo nzpnu-esz'-nrade-li (12). Krlcng rpibzle aposol. ");
INSERT INTO ntu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Ncblo lcdeng nidr seleng: Saemon (yrlq-kzpzle drtqde Pita) x mzlede Adru, Jemes nidr mz mzlede Jon, Filip, Batolomiu, (kc kzdq kz drtqde Natzniel), Matiu, (kc kzdq kz drtqde Livae), Tomas, Jemes mrlx Alfizs, Saemon kc tqprtr ena mz dzbede kc tzrpilr namaszlrtxpx-ngrdr gzpman ngr Rom mz nzaclve-krdr Israel, Judzs mrlx Jemes, (kc tqngi kz drtqde Tadizs), x Judzs Iskariot, kc tqamwabzle Jiszs mz enqmi rdeng. ");
INSERT INTO ntu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nzvzomqng badr aposol nedeng mz newz kc, sc tqtupe me mnzpz', tqtumipele kzdq dzbe leplz nedeng kxetu. X kzdq zbo ngr leplz kxetu sc tzmnc-kzng mrkc. Nzyrkrkimlr rlru mz kzdung mztea ngr Judiz, x kzdung nzyrkrkimlr Jerusalem. X nzyrkrmqng kcng mz taon kcng etu Taea x Saedon, mz nrlarde kcng rlru tqycpx prla. ");
INSERT INTO ntu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nzyrkr-ngrmlr mz nzxlr-krdr nzalvztrkr Jiszs x mz nzamrlzngr nidr mz zyagox ngrdrng. Leplz kcng tzatrkating drka' amrlz-kzng Jiszs. ");
INSERT INTO ntu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Leplz kcng amrlx tzabzlr nzrbxtr-ngrbz nide, murde zmatq sc tqvzpxm bade, x tqamrlztile nidr amrlx mz zyagox ngrdr. ");
INSERT INTO ntu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","26","Jiszs obqbz mz leplz nedeng, x sc tqrpipebzle kx, “Ngi da kxmrlz nzkrlz-krmu kx mnc-xgleamu nzokatrkr Gct mz nrlc ka, murde Gct sa nakabzle bamu da kx nzvzpxmqng mz nzngini-krde King rmu mz nrlc kc navzm. A' ngi da kxtrka nzrngisc-krmu da mz nrlc ka, murde trpnz-moungr da kx natwzamu mz nrlc kc navzm. Ngi da kxmrlz nzrtangrti-zvz-krmu Gct mz nrlc ka, murde sa na-aesapxbzle drtwrmu mz nrlc kc navzm. A' ngi da kxtrka nzamrbrtr-krmu Gct mz drtwrmu mz nzesapxkr drtwrmu mz nrlc ka, murde trpnzngr da kxmrlz kx nangi scmu mz nrlc kc navzm. Ngi da kxmrlz nzyrnibu-krmu mz alwx ngrmung mz nrlc ka, murde Gct sa na-aelalzmle nabzmu mz nrlc kc navzm. A' ngi da kxtrka nzmrge-zvz-krmu x nzabrtz-zvz-krmu mz nrlc ka, murde sa nayrni-aloamu mz nrlc kc navzm. Ngi da kxmrlz nzatrkatingr x nzpxtxpxngr, x nzrpibqtingr x nzobqszongr nimu murde vz-nqblqmu ninge mz nrlc ka. Mzli la naelalvzamu nzapu-krmu profet neng Gct kcng tzatrkati pnz melrmqmung. Murde mz nrlc kc navzm, sa natwzamu da kcpwz tqmyapx-esz'ngr tztwzlr profet lcng. A' ngi da kxtrka leplz amrlx nzabrtzlvz-krdr nimu mz nrlc ka. Murde mz nrlc kc navzm, sa natwzamu nzayrplapxngr kcpwz tqkrlzbzle melrmqmung kcng tzabrtzlvzlr profet kcng tzalvztr-rbrng mzli kc bqnc.” ");
INSERT INTO ntu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Rpi-mopwz Jiszs badr kx, “A' pibo bamu nimu lcng tzlalztqmqng bange. Kxmule-esz' nidr enqmi rmung, a' na-aodu-zvzamu nidr. X kxmule-esz' nztrkalr-ngrdr nimu, a' na-alebzmu da kxmrlz badr. ");
INSERT INTO ntu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kxmule-esz' nzpilzlr nimu, a' narlxtibzmu mz Gct nzamrlz-krde nidr. X kxmule-esz' nzalebzng bamu da kxtrka, a' nakrka'-ngrnamu nidr. ");
INSERT INTO ntu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nzmu kzdq ncblo natzlvzbzle nrlar blzmznaom mz nzngyatikr drtwrde nim, bzkq ayzlubzme, a' ao-lxlvr-kzpz nrlarde krali, murde natzlvz-kzpzle. Nzmu ncblo kx tqpnatibzle bot scm, e mz nivz, ka-kzpz nrz scm bade. ");
INSERT INTO ntu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Doa kx rlxbz bamu da, x mcamu kx takitrde nzokatrngr, kabzmu. X doa kx rpnatibz dztumu, bzkq rlxtipe-mopwzmu. ");
INSERT INTO ntu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ale-zvzbzmu mz leplz da kx suti drtwrmu na-alebzlr bamu, kxmule-esz' trnzalepwzlru bamu. ");
INSERT INTO ntu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nzmu namrlzti-txpwzmu kxnzmrlztilr nimu, Gct trabrtzlvzleu nimu. Murde tr-rblxu nzalengr, a' kxdrka'-ngrng nzale-kzlr da lc. ");
INSERT INTO ntu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","X tr-rblxpwzu badr nzale-kz-krbzlr da kxmrlz mz leplz kcng tzalebzng badr da kxmrlz. ");
INSERT INTO ntu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","X tr-rblx-kzpwzu mz kxdrka'-ngrng nzrlr-krbzlr da mz leplz kx nzkrlzlr kx krlzle nzayzlu-mou-ngrbz badr. ");
INSERT INTO ntu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Bzkq apuamu nidr! A' na-aodu-kzamu kxnztrkalr-ngrdr nimu. X na-alebzmu da kxmrlz badr. X narkabzmu da badr, kxmule-esz' trna-ayzlupwzlru bamu. Murde mz nzale-krmu da lcng natwzku kzdq da kxmrlz kxetu. X nanginimu doa neng Gct kc tqmyalz, murde aodu-kzle leplz kx trnzawipwzung bade x kxdrka'-ngrng. ");
INSERT INTO ntu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nayc mz drtwrmu leplz, da kc tqwai Trtemu Gct nzyc-zvzkr drtwrde nidr.” ");
INSERT INTO ntu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Rpibz Jiszs kx, “Bzkq rpiamu kx takitrde doa nzayrplapx-katongr mz alwx ngrdeng, murde ma tqrpi kz Gct kx takitrde nzayrplapx-kato-krde nimu mz alwx ngrmung. X bzkq rpiamu kx doa vz-rbr, murde ma tqrpi kz Gct kx vz-rbramu. A' ipqamu leplz murde Gct naipq-kzle nimu. ");
INSERT INTO ntu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Rkaamu da mz nzokatrngr leplz, x Gct sa nakabzle bamu da. Murde Gct sa na-ayzlu-kzpzle da bamu da kc tqwai nzrka-krmu da. Nzmu narka-angidramu mz nabzmu, sa natwz-kzamu da kxetu. A' nzmu narkaamu da kxpipz, natwz-kzamu da kxpipz. Nzrkakr Gct myaszlzle nzrka-krmu. Murde apule ncblo kx rnulvzobz topla x yrbulzm, lolvzobzle x ayclwzle x nganqlvzle x yrlqo-mopwzle kcng.” ");
INSERT INTO ntu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Zbz pibz Jiszs nzycmne-ebzpxngr lc murde ma tqpikitiku leplz. Rpibzle kx, “Ncblo kx mzte kcba nzmu trmailzleu kzdq kz kx mzte kcba. Nzmu nawailele, nztaong rlilrdr mz gq. ");
INSERT INTO ntu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Trpnzngr oblamz kx myaszlzle kxakrlz ngrde. A' oblamz kx tqkrlz-angidrpele la da kc tzalvztrpz bade, sc tqapupe-kzle kxakrlztrle nide. Mz nzmu-krde lcde, kx tqrpi-ngrnamu kx na-apuamu ninge, e vz-nqblqamu nqmq krnge. ");
INSERT INTO ntu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Murde mz nzrpi-krmu kx leplz nzaleng alwx, obqtiq alwx ngrdr kc tqtopwzne, a' trmcwq alwx ngrm kc tqwzpx. Opxm kx tqobqtitrpzme dcvi kc tqtotakine mz mz mzlem. A' trmcwq dapunounc kc tqyrbqpxm mz mzpq. ");
INSERT INTO ntu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Dekc tqrpi-ngrbzme mz mzlem kx, ‘E mzlenge, nakatxpxbo ena dcvi la tqtopwzne tqycpxm mz mzpq.’ ?Memule tqycmne-ngrn lc? Murde dapunounc kxwzpx la tqycpxm mz mzpq! Nim leplz kx narpi-ngrbz kx rlxngitiq! Kapx kai dapunounc la wzpx tqyrbqpxm mz mzpq, x mzpq kc tqopxpe mz nzrmcngr dcvi kc tqtopwzne, tqycpxm mz mz mzlem. Atubqti-lzbq kai mz alwx ngrmqng x kztemqng kc ate.” ");
INSERT INTO ntu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","44","Rpibz Jiszs kx, “Nounc amrlx nzglx-ngrdr nradr kcng tzpapx-ngrdr. Nounc kxmrlz trpapx-ngrdeu nranc kxtrka. Trpnz-kzngr nounc kxtrka kx papx-ngrde nranc kxmrlz. Murde tr-rkeopwx'u naq mz nc nole x dx mz nc lrpz. ");
INSERT INTO ntu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mz nqmq lcpwz, ncblo krla tqpipxle da kx yclzm mz nabzde. Murde nabz ncblo kxmrlz yclz-ngrm da kxmrlz. X aelwapx-lzbqngr mz nzmrlzti-krde leplz. A' nabz ncblo kxtrka yclz-ngrm da kxtrka. X aelwapx-lzbqngr mz nzrtrkalr-krde leplz.” ");
INSERT INTO ntu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Rpibz Jiszs kx, “?Memule tqrpi-ngrmamu bange kx ninge kxetu rmu, a' tryrlq-angidrwamuu natqnge? ");
INSERT INTO ntu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ncblo kx vzm bange, x xlrmle natqngeng, x yrlq-angidrleng, ");
INSERT INTO ntu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","apule ncblo kx wzti-angidrle ma nyzde. Ekqtiole gq lr nctrpou ngrdeng, vzo la. Kxmule-esz' nenq kxetu wq x yrplatr ma kc, a' trwxlikiou, murde wzti-angidr-pnzle. ");
INSERT INTO ntu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","A' ncblo kc tqxlrle natqngeng x trvz-nqblqleung apule ncblo kx wztiole ma nyzde mz drta' x nctrpou ngrdeng trmqngioung. Nenq kxetu wq, yrplatr ma kc, x mzli kcpwz wxlikitxo pnz!” ");
INSERT INTO ntu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kx yrkrpxbz nzpi-krbz Jiszs da lcng, sc tqvzpe mz taon Kzpznizm. ");
INSERT INTO ntu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kzdq kc kxetu tqmnc elr, kc tqaclvele dzbe ncblo ngr vea ne Rom kx trtqki-esz' (100). A' kxnzawz-nrbalq nede yagoxtx, ycpe pipz nzbz-krde. ");
INSERT INTO ntu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nrpa ngr Jiszs nzamrlz-krde leplz kxnzyagoxng, kx xlrpe kxetu kc le, sc tqatwzlrpe-ngrbzle kzdung lrtzlvz ngr lr Jiu kx naveatibzlr mz Jiszs na-amrlzbzle kxnzawz nede. ");
INSERT INTO ntu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nzvzmqng mz Jiszs, sc tzyrnititrpebzlr bade mz nzrpi-krbzlr kx, “Kxetu lc, takitrde nzokatr-krmle. ");
INSERT INTO ntu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Murde mrlztile nigu lr Jiu x rkapx trau kx nawztingr mangr-nzkrka'ngr nangi nyzgr.” ");
INSERT INTO ntu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Zbz Jiszs kc tzvzpeng badr. Nzesonetrpebzng mz ma nyz kxetu kc, zbz sc tqatwzlrpxpe-ngrbzle kzdung kztedeng mz Jiszs. Nzrpibzlr bade kx, “Kztegr rpimle bagr kx, ‘Kxetu, bzkq da kx nakxne ye drtqm, murde trtakitrpwc'u nim nzdwatr-krme ma nyznge. ");
INSERT INTO ntu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Dekc trvz-ngrpwc'u bam mz ninge esz'-krnge. Mnclzbo mz zmatq ngr kamadz rnge. X ncblo ngr vea nengeng nzmnclzmqng bange. Kx narpibo mz kzdq kx, “Vz!” x sc tqvzpe. X kx narpibo mz kzdq kz kx, “Vzm!” x sc tqvzpem. X kx narpibo mz kxnzawz nenge kx, “Da kx na-aleq se!” x sc tqalepele. Krlzx kx rngiscm zmatq kxmyalz zlwz. Pi txpwz dq ye natq, x ncblo nenge sc tqmrlzpe.’” ");
INSERT INTO ntu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kx xlrbz Jiszs natqdeng kctitxpx-zlwzle. Ayzlutx-lzbq, sc tqrpipebzle mz zbo ngr leplz kc tzvz-nqblqlr nide kx, “Napibo bamu, nzrlxngitikr lr Israel trmyaszpxleu nzrlxngitingr lc!” ");
INSERT INTO ntu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mrlx kcng tzatwzlr-ngrbz mz Jiszs nzyzlutx-mopwzng mz ma nyz kxetu kc. Kx nzkaputrpzlr, nzmcpelr kx mrlx kc tqyagox mrlztxpe. ");
INSERT INTO ntu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mzli trboiu mz nibrde, Jiszs kc tqvzpe mz kzdq taon, drtqde Nein. Ncblo nedeng x kzdq zbo ngr leplz nzvzng badr. ");
INSERT INTO ntu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Mzli kc tzkaputr-ngrbzlr mz naonrx ngr taon kc, nzobqbzng a' ncblo kx bz la tzglqpxm mz nzryrtzmqngr nide. Ncblo kc tqbz ngi mrlx kzdq olvz kx bzsz ncblo ngrde. Mrlxde nide kc txpwz esz'txu. X zbo ngr leplz kx nzvzpxmqng mz taon kc, sc tzyrkrpxmqng badr olvz lcde. ");
INSERT INTO ntu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kx mctxpebz Kxetu olvz kc, sc tqycpe mz drtwrde. Sc tqrpipebzle bade kx, “Bzkq yrniq.” ");
INSERT INTO ntu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Zbz vzbz, sc tqmaletrpebzle da kc tqyrbqo-ngrm namz ngr ncblo kc. X ncblo kcng tzrglqng nztutx-pnzng. X sc tqrpipebz Jiszs mz ncblo kc tqbz kx, “Obla, dwalzm!” ");
INSERT INTO ntu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ncblo kc tqbz lutx pnz, sc tqwxbupe x tqycmnepe. Sc tqavzpe-mopwz Jiszs mz lxede. ");
INSERT INTO ntu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","X leplz amrlx nzkctitxpxlr, x sc tzglqpxpelr Gct. Tzrpipelr kx, “Kzdq profet kxmyalz vzpem mz mzlirgu! Gct atwzlr-ngrmle profet nede mz nzarlapx-krde leplz nedeng!” ");
INSERT INTO ntu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nrpa ngr Jiszs lc talvzpx-pnzle mztea kcng tqyc-ngalele Nein, x mrkcng amrlx tzmnc-ngrdr lr Jiu. ");
INSERT INTO ntu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Oblamzng Jon Kxawrkxtr nzpitibzlr nrpa ngr Jiszs mz Jon, mrkc tqmnc-ngrde mz presin. Aveatile oblamzde nzling. ");
INSERT INTO ntu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","X sc tqatwzlrpe-ngrbzle mz Kxetu, murde naveatibzlr kx nide Kxnzmcpx o trtingr. ");
INSERT INTO ntu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kx nzvzpemlr kc mz Jiszs, sc tzrpipebzlr kx, “Atwzlr-ngrmle nigr Jon Kxawrkxtr bam. Rpimle naveatibzkr bam kx, ‘?Nim Kxnzmcpx kc tzpi navzm, o na-aenzli-moukr dq ncblo kzble?’” ");
INSERT INTO ntu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mzli lcdepwz amrlzle leplz kxkqlu kx nzyagoxng, x kxnzmncng mz drtq kxetq, x maszlrpx-ngrde drka' kx mnctipxmq mz leplz. X leplz kxkqlu kx mztr kcba, mztr aobqpe-mopwz Jiszs. ");
INSERT INTO ntu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Rpibzle mz menrpa kcng tqatwzlr-ngrm Jon kx, “Yzluamu x pibzmu mz Jon da kcng tqmcamu x tqxlramu mrka mz nzwz-krnge. Murde kxmztr kcba nzobqpeng, kxnzbxplong nzvznepeng, kxnzyc-ngrng zkrkqlu nzlqngipe-moung, kxnradrtqdr ngq nzxlrpeng da, kxnzbzpeng nztulz-moung, x Nrpakxmrlz nzyapwxtipxbz mz leplz kxnzobqszong. ");
INSERT INTO ntu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Sa namrlzbz mz ncblo kx trpxpx-ngrdeu ninge mz trnzale-krngeu nike pnz drtwr leplz kx nangi nzwzkr Kxnzmcpx.” ");
INSERT INTO ntu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Mz nibr menrpa ne Jon nzvzpx-krdr, Jiszs kc tqpipxbzle nzmyalzkr Jon mz leplz kcng. Rpibzle kx, “Trvz-ngrpwzmuu mz Jon mrkc lzke nzmc-krmu ncblo kx tekqtr-zvzle da kx pile, mz nzapu-krde neni kx yamengr nenq mrkang kqlu. A' kc tqvz-ngrbzmu naxlramu natq angidr. ");
INSERT INTO ntu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","X trvz-ngrpwzmuu kx namcamu ncblo kx rngisc, kx pxi-ngrde lrpz kx nzxpengr lqlwx. Murde ncblo kxmule lc tqmnc zpwx trnzmcu mrkc lzke, a' nzmcpwz mz ma nyz king. ");
INSERT INTO ntu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Krlc tqvz-ngrbzmu nzmc-krmu profet. A' napibo bamu ncblo lc tqmcamu myaszlzle profet kcng bqnc. Murde nzwz-krde myaszlzle nzwzkr profet amrlx. ");
INSERT INTO ntu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Murde Jon nide menrpa kc tqplzpxle nzvz-krm Kxnzmcpx. Da kc tqwai nzpipxkr Gct le mz Nzryrngrkxtr kx, ‘Krlc menrpa nenge. Sa na-atwzlr-ngrne nartwayz-kaipz bam, murde naokatrle leplz nengeng mz nzoliqti-krdr nzvz-krbzme.’” ");
INSERT INTO ntu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Rpi-mopwz Jiszs kx, “Napibo bamu, trpnzngr ncblo mz nrlc kx myaszlzle Jon, abzo mzli kc krlzmle mzli ka. A' abzo mzli ka, leplz txne amrlx kx nzrlr-lzbq-ngrmqng bange mz nzmnclz-krbz mz Gct namyaszlzlr nide.” ");
INSERT INTO ntu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Zbz Jiszs rpi-mopwzle kx, “Mzli lcde leplz amrlx x ncblo kcng tzatakqting takes tzobqszo nzlxngitilr nqmq kr Gct kc tzxlrbzlr mz Jon x sc tqawrkxtrpeng Jon. ");
INSERT INTO ntu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","A' kzdung Farzsi x krkcng tzalvztrng mz Lou sc Mosis nzpxtxpx-ngrdr me pnz drtwr Gct mz nzpxtxpx-krdr nzawrkxtrkr Jon nidr. ");
INSERT INTO ntu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Naryapwxtr-mopwc' mz nimu leplz kcng tzmncng mzli ka. ");
INSERT INTO ntu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Apuamu doa kxnztopwz kcng drtwrdr tresapxu. Kzdq dzbede tzrkrkxbzng mz kzdq kz dzbede. Tzrpibzlr kx, ‘Ngr-ngrbzkr nabz ngr nzabrtzngr, a' trelawamuu. Ngr-ngrbzkr nabz ngr nzyrningr, a' tryrniwamuu!’ ");
INSERT INTO ntu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Apuamu nidr murde Jon Kxawrkxtr vzm x trmuneu bret x tr-rmnqne-kzu waen. A' rpi-ngrnamu kx, ‘Drka' mncpxm bade!’ ");
INSERT INTO ntu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","X ninge Mrlx Leplz vzmc, x mux dakxnzng x rmnq-kzx waen. A' sc tqrpipeamu kx, ‘Mcamu ena mrlx ka! Mrlx kx mutu x rmnq kato! Kzte ncblo kxnzatakqting takes x leplz kxnztrka-kzng!’ ");
INSERT INTO ntu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","A' nadcpx mz drtwrmu kx nztubqkr natq opx zlwz mz nztubqkr doa kx atutr. X sa namcamu kalr nztubq-krgr rlilrgr mz da kc navzpxmqng mz nzmnckr leplz kcng tzatutrlr natqgr.” ");
INSERT INTO ntu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Kzdq Farzsi drtqde Saemon, aveatile Jiszs mz nzmupx-lxblr-krdr badr. Jiszs vztrpz ma nyzde x sc tqprtrpe mz nzmungr. ");
INSERT INTO ntu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kzdq olvz mnc mz mztea lc, kc tqale-zvzle alwx mzli kc. Kx xlrpele nzmukr Jiszs mz ma nyz Farzsi kc, sc tqvzpebz, twzbzle botol kx yrbulzm mz tolo kx mnrte mrlz zlwz x lqlwx nzxpengr. ");
INSERT INTO ntu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","X esotrpz mz nanyc Jiszs, tqyrni x tqalrprtibzle nanycde mz drlemzte. Zbz amingrtxbzle nanycde mz nqnginarde, x sc tqtcngitx-zvzpwzle nanycdeng. Zbz sc tqpulitxopebzle tolo kc mz nanycde kcng li mz nzawi-krbzle bade nivz lrde. ");
INSERT INTO ntu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Farzsi kc tqaveatile Jiszs mcpzle da lc. X sc tqrpipele mz drtwrde kx, “Ncblo ka nzmu nangini-angidrde profet, e nzmu krlzpele kx olvz ka ngi olvz kxale zvz alwx x nzmu rpwa'-ngrbzle nzbxtr-krbzle nide.” ");
INSERT INTO ntu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","A' Jiszs krlztipele da kx yclzm mz nabz Saemon, sc tqrpipebzle kx, “Saemon, kzdq kc da napibo bam.” Rpibz Saemon kx, “Pim ye, kx kxakrlz.” ");
INSERT INTO ntu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Rpibz Jiszs kx, “Kzdu kcng ncblo nzling. Ncblo kcng nzling nzkaonbzng srlrni mz kzdq ncblo kxrngisc. Kzdq kaontibzle srlrni trtqki-nzlvqn (500), x kzdq kaontibzle srlrni nzpnu-nzlvqn (50). Srlrni kxesz' ngi narncbr ngr nzwzngr mz zbq kxesz'. ");
INSERT INTO ntu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Trpnzngr nidr kx takitrde nzrka-dwzlr-moungr kaon scde. Zbz kxetu kc sc tqpipebzle kx bzkq nzxpenepelr ye. ?Nzmu-krde ke, mrlx kcmang nzling neke namrlzti-zlwzpele ncblo kc tqrngisc?” ");
INSERT INTO ntu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Rpibz Saemon kx, “Mwx ncblo kc kaon scde tqetu.” Rpibz Jiszs kx, “Da angidr la tqpiq.” ");
INSERT INTO ntu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Zbz o-lxlvrbz mz olvz kc, sc tqrpipebzle mz Saemon kx, “?Mcq olvz lc? Dwatrpc' ma nyzm, a' trpnzngr lue kx kame kx nawzti-ngrne nanycnge, mz nzvz-nqblq-krde nqmq krgu. A' wztipebzle nanycnge mz drlemzte x amingrpebzle mz nqnginarde. ");
INSERT INTO ntu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Trabrtzlvzwq ninge mz nzrtcngingr mqnge, mz nzvz-nqblq-krde nqmq krgu, a' tresakika nztcngi-krde nanycnge kx vztrpc' kcma. ");
INSERT INTO ntu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","X kxmule-esz' traeluwq narnge mz tolo, mz nzvz-nqblq-krde nqmq krgu, a' aelupebzle nanycnge mz tolo kxmrlz-esz'ngr. ");
INSERT INTO ntu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","“Napibo bam kx olvz lc tqaelwapx-ngrde nzetukr nivz lrde mz nzipqpx-krbz Gct alwx ngrde kxkqlu. A' mrlx kx plzpxbzle alwx ngrdeng kxpipz mz Gct, Gct ipqpxbzle alwx ngrde kxpipz kz, x rblxbz bade nzxngi-krbzle nivz lr Gct. Mz nzmu-krde lcde nzmrlzti-krde Gct topwz.” ");
INSERT INTO ntu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Zbz sc tqrpipebz Jiszs mz olvz kc kx, “Alwx ngrmqng nzipq-angidrpe.” ");
INSERT INTO ntu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Leplz kcng tzmung badr, sc tzrpi-etrpelr kx, “?Nelc krlc tqkrlz-kzle nzipqpxngr alwx?” ");
INSERT INTO ntu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","A' rpibz Jiszs mz olvz kc kx, “Nzrlxngiti-krm arlapxpele nim. Krka'-ngrne kx namnc-zpwxq. Bzkq da kx nakxnepe drtqm.” ");
INSERT INTO ntu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mz nibrde, Jiszs aesz'tipeleng taon x mztea kcng, mz nzvztr-krde elr. X yapwxtipxle Nrpakxmrlz kx Gct sa tqvectrpemle leplz mz nzmnclz-krbzlr bade mz nzngini-krde King rdr. Nzvzng badr aposol kcng nzpnu-esz'-nrade-li (12). ");
INSERT INTO ntu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nzprtr-kzpzng kzdung olvz kx amrlzleng mz zyagox, x kx maszlrpx-ngrbzle drka' badr. Kzdq olvz lcdeng drtqde Mxri kc Makdala. Drka' rlimz nzmaszlrpx-ngrbz bade mzli kc. ");
INSERT INTO ntu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","X prtr-kzpz Joana krnalz Kusa kc tqngi ncblo kxetu wztrpz mz King Herot Antipas. X prtr-kzpz Susana, x kzdung kz olvz kxkqlu kx nzokatrlr Jiszs x ncblo nedeng, mz trau scdr. ");
INSERT INTO ntu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Leplz kc tzavzpemqng mz Jiszs, nzyrkrkimlr mz taon kcng amrlx. X zbo ngr leplz kx nzmncpelr mrkc, Jiszs kc tqyapwxtipxbzle nzycmne-ebzpxngr lc. ");
INSERT INTO ntu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Rpibzle kx, “Kzdq mzli kzdq kc ncblo oliqtile drtc' ngr nrlanc nyzde. Zbz sc tqarlxpele nra wit nyzdeng, murde rpile nayrkqlvzle mz drtc' mz nibrde. A' mzli kc tqarlx-ngrde nra wit lcdeng, kzdung nztationg mz lrpzki kx drtc' ngrde mqngi, x nztulvztio leplz x nzngqtilz-kzpqng utc. ");
INSERT INTO ntu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","X kzdung nra wit kcng taong me drtc' ngrde melx, ycom mz rplz. Nzlvcpulz-animqng, a' nzglrting x nzmztx-ani-moung, murde mrkc tewa trdc-zvzu x drtc' trlrpru. ");
INSERT INTO ntu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","X kzdung mou nztationg mz drtc' ngr ncngrbz. Krlcng nzlvcpumilzm lxbi x nzyrlvilvzo lxbi nidr. ");
INSERT INTO ntu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","X kzdung mou nztationg mz drtc' kxmrlz. Krlcng nzyrlvzlzmqng x nzpang. X nzyrlqbzlr nradr kqlutx zlwz.” Zbz xplrmitxbz natq Jiszs nzrpi-krbzle kx, “Doa kx yrplapx, na-abzle nztwz-krde drtwr ngr natq lc.” ");
INSERT INTO ntu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mz nibrde mzli kc tzmncpe-ngrdr esz'-krdr, ncblo nedeng nzveatibzlr mz Jiszs drtwr ngr nzycmne-ebzpxngr kc. ");
INSERT INTO ntu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Rpibzle kx, “Ayrbq-zpwx-ngrbo bamu nqmq kr Gct mz nzngini-krde King r leplz nedeng, kc tqyc-kapq mzli kc. A' mz leplz kcng tzpxtxpx-ngrdr nzxlr-krdr da angidr, napipxbo badr mz nzycmne-ebzpxngr. Nidr leplz kcng tqycmnetrngr profet Asaea mz nzrpipxkr Gct kx, ‘Kxmule-esz' nzobqng, a' trnzkrlzlru da angidr. X kxmule-esz' nzlalztqng, a' nardr tryrplatrpwzu.’” ");
INSERT INTO ntu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Rpibz Jiszs kx, “Drtwr ngr nzycmne-ebzpxngr kc nide sele: Nra wit kcng tqarlx ncblo kc ngi natq Gct. Drtc' kc pwx ngi nqmq kr leplz. ");
INSERT INTO ntu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Lrpzki lc drtc' ngrde tqmqngi, drtwr ngrde leplz kcng nardr tqmqngi mz nzxlr-krdr natq Gct. Murde mzli kznikeng nzxlr-ngrdr nrpa ngr Gct, Nar Drka' vzm x katxpxbzle badr, murde rpile narblxbz badr nzrlxngitingr x nzrlapxngr. ");
INSERT INTO ntu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Drtc' kc tqmelx drtwr ngrde leplz kcng nabzdr tqngrgo. Nzxlrlr natq Gct x nzabrtzlvzlr nztwz-krdrle, a' natq Gct trpnzngr dzbrde. Nzrlxngiti-krdr mrbcnepwz, murde rblx nzlolvz-amqngi-krdrle mzli kc tqprtztingr nzatalzngr. ");
INSERT INTO ntu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Drtc' ngr nibr ncngrbz drtwr ngrde leplz kcng drtwrdr tresz'tiu. Murde nzxlrlr natq Gct, a' trbrtiu drtwrdr. Nzaoti-zlwzkr drtwrdr dalr nrlc kxkqlu nzapulr lxbi kcng tzyrlvilvzolr nabzdr, x trpnzngr nzbrpe-krdr. ");
INSERT INTO ntu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Drtc' kxmrlz drtwr ngrde leplz kcng nabzdr tqmrlz x tzoliqtilr nzlxngiti-krdr natq Gct. Murde nztwzlr x nzlolvzlr mqngi, x nra nzrlxngiti-krdr yc-zvzbz, mz nzvectr-krmlr leplz mz Gct.” ");
INSERT INTO ntu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Mz nzaelwapxkr Jiszs kx Nrpakxmrlz na-apule zyzlr, rpibzle kx, “Lam trnztekatru sc tzalalvzope topla. X trnzawxbulzpwzu mz nabz da. Lam nzadolzpwz wq, murde leplz namclr zyzlr mz nzdwatr-krmlr brma. ");
INSERT INTO ntu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mz nzmu-krde lcde, kxmule-esz' Nrpakxmrlz trkrlzkapzle leplz amrlx, a' sa naopxbz badr kalr. X mzli lc sa nayrplatitr nardr x na-aelwapx-ngrbzle da kx yc-kapqbepz badr. ");
INSERT INTO ntu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“X na-aclve-angidramu murde natq Gct kc tqxlramu natwz-kzamu mz nzmnc-krmu. Murde doa kx twzle natq Gct mz nzmnc-krde, natwz-moule nzyrplapxngr mz kzdung kz natq Gct. A' doa kx trtwzleu natq Gct mz nzmnc-krde, trnatwzleu kzdq mou nzyrplapxngr. X kxmule-esz' nzrkrlzngr kxtopwzne kx ycbz bade, a' sa nakatxpx-kzpz Gct bade.” ");
INSERT INTO ntu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kzdq mzli lxe Jiszs x mzledeng nzvzmqng bade mz ma kc tqmnc-ngrde. A' trnzdwatr-pnzpwzung brma, murde zbo ngr leplz kcng tzmncong mrkc. ");
INSERT INTO ntu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kzdq ncblo rpibzle mz Jiszs kx, “Lxem x mzlemqng la tztutrpqng yz, nzrpilr namclr nim.” ");
INSERT INTO ntu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","X sc tqrpipebzle kx, “Lxenge x mzlengeng dekcng tzxlrng natq Gct x nztwzlr mz nzmnc-krdr.” ");
INSERT INTO ntu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kzdq zbq Jiszs badr ncblo nedeng nzprtzng mz kzdq bot kxetu, x sc tqrpipebzle badr kx, “Na-alilvckiopeku mz nrlar dxbu kc.” X sc tzalilvcpeng. ");
INSERT INTO ntu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nzvo-krbzlr kc, Jiszs kc tqmwipe. Kzdq nenq kxetu vzobz mz nabz dxbu kc. Zbz bot kc sc tqdwatiope lue. Mz drtwrdr sc tzrpilr naboopeng. ");
INSERT INTO ntu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nzvzbzng mz Jiszs sc tzameopelr. Nzrpipebzlr kx, “Kxetu, Kxetu! Nabzpeku!” Jiszs dwalzm, x lclvztxde nenq x ebio kx yclwz. X nzamatxo-pnzng x nrwx votx pnz. ");
INSERT INTO ntu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Zbz rpibzle mz ncblo nedeng kx, “?Nike tr-rlxngiti-ngrwamuu?” Nzkcti-lzbqng x nzmwxlr-kzng, x sc tzrpi-etrpelr kx, “Eke! ?Ncblo kznika? Rkabz natq mz nenq x nrc, x nzvz-nqblqlr natqde!” ");
INSERT INTO ntu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nzkaputrpzng mz nrlarnrlc kc tqycngr taon kcng nzpnu-esz', mrkc tzmncngr leplz kcng trngiulrJiu. Kzdq taon lcde drtqde Gergesa, yckiomle mz kzdq nrlar Dxbu Gzlili, x Provins kc Gzlili yckiomle mz kzdq nrlarde. ");
INSERT INTO ntu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jiszs kx poobzle mepz, sc tqrmctipe kzdq ncblo ngr taon kc, kx mncpx-ngrm drka'. Mzli boipe, kx tqvznede la, x trpnzngr scde lrpz. X trmncpeu mrnyzde, a' mnctxpepwz mz butqbr kx nzryrtzmqngr kxnzbzng. ");
INSERT INTO ntu_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Mzli kqlupe tqlolvzngr drka' kc le. X leplz nzapusr-ngrdr nide ncblo kxnzpresin. Kxmule-esz' mqdeng x nanycdeng nzpetibzng mz sen, a' sen lang tqnikileng x tqavztr drka' kc mrkc lzke. Kx mctxbzle Jiszs, katxpxbzle kc natq ngr nzneplangr x nzkya'-nimzngr. X rtctxo-lzbqbz bade. Rpibz Jiszs mz drka' kc kx, “Prpxm bade!” Sc tqnemipele kx, “Vrr! Jiszs, Mrlx Gct kc tqmyalz-esz'ngr! ?Nike tqotime? Yrnitrpo bam, bzkq ayrplapxq nrkrdrtqnge!” ");
INSERT INTO ntu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jiszs veabz rpibzle kx, “?Drtqm neke?” Rpibzle kx, “Drtqnge Siu Kqlu.” Murde drka' kxkqlu nzyrkrtrpebzng bade. ");
INSERT INTO ntu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Drka' kcng nzyrnititrpzlr mz Jiszs nzrpibzlr kx bzkq atwzlro-ngrbzle nidr mz gq kc trpnzngr noude mz Hxl. ");
INSERT INTO ntu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","X mnc-aepztrpz mrkc kzdq nrtrq r poi kxetu sc tzmung mz nra. Drka' kcng nzyrnitrpzlr mz Jiszs kx narlr-ngrbzle badr nzvztr-krdr mz poi kcng. X sc tqrlrpe-ngrbzle. ");
INSERT INTO ntu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Zbz drka' kcng nzdwapxmqng mz ncblo kc x nzdwatr-alzung mz poi kcng. X nrtrq r poi kc nzvoong mz nrlar nqngitrlqli, nztaong mz nabz dxbu kc, sc tzboopeng amrlx. ");
INSERT INTO ntu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kx nzmc ncblo kcng tzaclveng, nzngrlrng sc tzpinepelr nrpa ngrde mz mztea x mz nabz nrlanc kcng. ");
INSERT INTO ntu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Zbz leplz kxnzkqlung sc tzyrkrpebzng mz nzmc-krdr da kc tqprtz. Nzvzmqng mz Jiszs x nzmcpelr ncblo kc tzprszpx drka' kcng, pxitxpe, x drtwrde opxpe. X sc tqwxbulzbz mz nanyc Jiszs, tqlalztqpebz mz nzalvztr-krde. Zbz sc tzmwxlrtxpeng amrlx ngrdr, nzmwxlrtilr zmatq ngr Jiszs kc tqmyalz. ");
INSERT INTO ntu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Krkcng tzrmcng sc tzpipebzlr mz leplz kcng tzvz-atemqng kxmu ncblo kc nzmrlz-krde. ");
INSERT INTO ntu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Zbz leplz kcng amrlx ngr nrlarnrlc kc Gergesa nzrlxti-nrwx-ngrbzlr mz Jiszs kx navzpe, murde nzmwxlrtx-atwrnrpe-ngrng. Zbz mzli kc Jiszs tqprtzpe-ngrde mz bot, ");
INSERT INTO ntu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ncblo kc tzprszpx drka' kcng, sc tqvzpem tqyrnitrpebzle mz Jiszs kx navzng badr. A' atwzlrpxngr Jiszs, rpibzle kx, ");
INSERT INTO ntu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Yzlupe mrnyzm, x pipx da kc tqwzpe-ngrbz Gct bam.” Zbz Jiszs kc tqrlaszpele mrkc x ncblo lc sc tqvz-zlipele taon kc atwrnrngr, tqpinede da kc tqwz-ngrbz Jiszs bade. ");
INSERT INTO ntu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Mzli kc Jiszs tqyzlupe-mou-ngrbzle mz nrlar dxbu kc, zbo ngr leplz kc sc tzabrtzlvzpelr nide. Murde nidr amrlx ngrdr tzaenzlilr nide. ");
INSERT INTO ntu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Zbz kzdq ncblo drtqde Jaerzs, sc tqkaputrpem. Nide kzdq kxetu r mangr-nzkrka'ngr. Rtctxo-lzbq-ngrbz mz nanyc Jiszs x sc tqyrnitrpebz kx navzng badr mrnyzde. ");
INSERT INTO ntu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Murde inyxde esz'txu, yiz ngrde mwx nzpnu-esz'-nrade-li (12), sc nabzpe. Jiszs kx vzbzle, leplz kcng nzrdrlvzti-lzbq-txpwzng mz nzvz-krbzlr bade. ");
INSERT INTO ntu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","A' kzdq olvz kx tresakiu nzrpwx-krde temz sc tqmnc kz mrkc. Nzrpwx-alo-krde lc temz, twztipelele yiz nzpnu-esz'-nrade-li (12) x tqamewetxbzle drtqde. A' trpnzngr kx krlzle nzamrlz-krbzle nide. ");
INSERT INTO ntu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Olvz lc vzdzm mz mzlir zbo ngr leplz kc mz nibr Jiszs x sc tqmaletrpebzle lrpzde. X mzli kcpwz mepyr kc sc tqesakipe. ");
INSERT INTO ntu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jiszs kc tqrpipele kx, “?Neke tqmaletrple ninge?” Leplz amrlx nzrpibzlr kx trpnzngr. Zbz Pita kc tqrpipebzle kx, “Kxetu rnge, leplz amrlx la tzbolikilvzlr nim. Nzkrlzlr kx nzbxtrpzlr nim.” ");
INSERT INTO ntu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","A' rpibz Jiszs kx, “Kzdq kc doa maletrple ninge murde krlztix zmatq vzpxpem bange x amrlzpele kc kzdq doa.” ");
INSERT INTO ntu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Olvz kc mcpele kx nzkrlztipe, sc tqvzpem, rnrcnepem, x rtctxo-lzbqbz mz nanyc Jiszs mz nzaelwapx-krde nzavzo-lzbqngr x nzamatqngr. Mrkc, mz mz leplz amrlx, sc tqpipxpebzle da kc tqmaletr-ngrbzle lrpz sc Jiszs x kxmu nzmrlztx-ani-krpwzle. ");
INSERT INTO ntu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Rpibz Jiszs kx, “Inyxnge, vzpe x bzkq da kx napnz drtwrm. Murde nzrlxngiti-krm ninge amrlzpele nim.” ");
INSERT INTO ntu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jiszs kc tqycmnebe ye, a' kzdq ncblo vzpem mz ma nyz Jaerzs. Rpinemle kx, “Inyxm bzpe, kx Jaerzs. Bzkq akxputipeq kxakrlz la.” ");
INSERT INTO ntu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","A' xlrpebz Jiszs, sc tqrpipebzle mz Jaerzs kx, “Bzkq drtwrm talvzo, a' lxngiti ninge, x sa nalu mou.” ");
INSERT INTO ntu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kx nzkrlzbzlr ma kc trpnzngr leplz kx rlr-ngrbzle nzmncpx-krmlr badr brma, a' ngi txpwz Pita, Jon, Jemes, trtede x lxede. ");
INSERT INTO ntu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Leplz kcng amrlx mrkc tznemipelr nzyrni-krdr. A' mz nzkrlzkr Jiszs kx nzbzkr doa olvz kc trnabz-alou, sc tqrpipebzle kx, “Bzkq yrniamu. Doa lc trbzu, a' mwine ye!” ");
INSERT INTO ntu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","A' nzyrpalelvzlr nide murde nzkrlzlr kx doa olvz kc bzpe. ");
INSERT INTO ntu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","A' Jiszs dwatrpz x otibzle doa olvz kc, malebzle mqde, sc tqrpibzle kx, “Dwalzm!” ");
INSERT INTO ntu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nzlu-krde yzlutx-mop x mzli kcpwz tutxlzm. Zbz sc tqrpipebz Jiszs kx, “Kabzmu du dakxnzng namu doa olvz lc.” ");
INSERT INTO ntu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Lxede x trtede kx nzkctipxlrle, naodr mz txpwz. A' Jiszs lclvztxbzle kx bzkq nzpinedr da lc tqngi-dape. ");
INSERT INTO ntu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jiszs kqleleng aposol kcng nzpnu-esz'-nrade-li (12) x sc tqayrlwr-amqmupeleng. X mz nzmnclz-krbzlr bade, kabzle badr nzxplrngr x zmatq ngr nzmaszlrpx-krdr drka' amrlx x nzamrlz-krdr kxnzyagoxng. ");
INSERT INTO ntu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Zbz atwzlrpxpe-ngrdeng mz mztea kcng trkrlzkapzlrng. Rpibzle kx nayapwxtipxlr Nrpakxmrlz kx Gct sa tqvectrpemle leplz mz nzmnclz-krbzlr bade mz nzngini-krde King rdr. X na-amrlzlr nrkrdrtq leplz kx nzyagoxng. ");
INSERT INTO ntu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Rpi-mopwzle badr kx, “Bzkq da kx natwzamu mz nzvzpx-krmu, kx apule nctoko, bxli, dakxnzng, x srlrni. X bzkq nimu kx nartwz kz nzkq krali. Murde na-abrtrpzmu drtwrmu mz Gct nzrka-krde. ");
INSERT INTO ntu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Drlve ke nzaodu-ngrmu, mncpepwzmu mz ma lapwz esz' navz, nakrlzbzle mzli kx narlasz-ngrnamu mztea la. ");
INSERT INTO ntu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Drlve ke leplz trnzaodu-ngrdru nimu, rlaszamu mztea la x rtc-ngrbzmu rplz nakrlz-ngrdrle kx nqmq krdr trka mz nzapu-krdr kxnzmnc-mrbrng.” ");
INSERT INTO ntu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aposol kcng nzrkalzmqng, sc tzvz-zlipelr mztea kcng amrlx. Tzyapwxtipxlr Nrpakxmrlz kc x tzamrlzting leplz kx nzyagoxng mrkc atwrnrngr. ");
INSERT INTO ntu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Zbz King Herot Antipas, kc tqaclvele lr Gzlili, xlrle nrpa ngr da kcng tqaleting Jiszs x ncblo nedeng. Drtwrde mrbrtxtrpz, murde mzli kc kai pibzle mz kzdung ncblo ngr vea nedeng nanibqlr Jon. A' kzdung leplz tzrpilr kx, “Jon Kxawrkxtr tulzpe-mop mz nzbzngr.” ");
INSERT INTO ntu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Kzdung nzrpilr kx profet Elaeja kc bqnc, tqmatq tqadcpx-lzbqpe. X kzdung nzrpilr kx kzdq kz profet ngr mzli kc lupe mou. ");
INSERT INTO ntu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Rpi Herot kx, “Nar Jon lakipxpe kzdung ncblo ngr vea. ?A' nelc krlc tqxlrx tqaleti da lcng?” X sc tqrpile namcle Jiszs. ");
INSERT INTO ntu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aposol kcng sc tzyzlupemqng mz nzryapwxpx-krdr Nrpakxmrlz x nzamrlz-krdr leplz kxnzyagoxng, sc tzpipebzlr mz Jiszs da kcng amrlx tzalelr. Zbz sc tzvzpxpeng me esotrpz mz kzdq taon drtqde Betsaeda murde namnc-ngrdr esz'-krdr. ");
INSERT INTO ntu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","A' kx nzxlrbz zbo ngr leplz kcng le, sc tzvz-nqblqpelr nide. Kx nzkrlzbzlr nide, sc tqaodupele nidr. X sc tqycmnetr-ngrbzle badr kx Gct sa tqvectrpemle leplz mz nzmnclz-krbzlr bade mz nzngini-krde King rdr. X amrlzle krkcng tzyagoxng. ");
INSERT INTO ntu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","A' mzli kcpe mz milzpq, aposol kcng nzvzmqng bade sc tzrpipebzlr kx, “Kxetu, atwzlrpxngr leplz lcng mz mztea x nrlanc kcng tzyctineng mrlc, murde namwing x narmctineng nadr dakxnzng. Murde trpnzngr me narmctingr leplz lcng dakxnzng.” ");
INSERT INTO ntu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","A' Jiszs rpibzle badr kx, “Nimu kx narkabz nadr dakxnzng.” Nzrpibzlr kx, “Yctxpqng bagr bret nzlvqn kxtopwztine x nc kxsupe li. Takitxtrpwzle nzvz-krgr nzxpe-krgr dakxnzng nang zbo ngr leplz lc.” ");
INSERT INTO ntu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Murde ncblo nzkqlu-krdr nzesolzbzng mz siu kx nzlvqn (5,000). A' trnzrlwxtrpwzu olvz x doa kx nztopwzng.) Rpibz Jiszs mz ncblo nedeng kx, “Awxbuamu leplz mz dzbedeng. Mz dzbede kxesz' leplz nakrlzbzle nzpnu kxnzlvqn (50).” ");
INSERT INTO ntu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","X sc tzawxbutiopelrng. ");
INSERT INTO ntu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jiszs kalzmle bret kcng nzlvqn x nc kcng li, x obqlz mz bongavz mz nzkrka'ngr x sc tqawipebz mz Gct. Zbz lopxitxdeng, x sc tqkapebzleng mz ncblo nedeng, tzakipxbzlr mz leplz kcng nzkqlung. ");
INSERT INTO ntu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Leplz amrlx nzmung x nelzdr krlctxtrpz, x ncblo nedeng nznulvzo-moulr topla nzpnu-esz'-nrade-li (12) mz nctq dakxnzng kx yctxo. ");
INSERT INTO ntu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kzdq zbq, mzli kx Jiszs krka'-ngrde esz'-krde, ncblo nedeng nzvzmqng bade, sc tqveapebz badr, rpibzle kx, “?Myx kxmu nzglxkr leplz ninge?” ");
INSERT INTO ntu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nzrpibzlr kx, “Nzkqlung nzrpilr kx nim Jon Kxawrkxtr tulzpe-mop mz nzbzngr. Kzdung nzrpilr kx nim Elaeja. X kzdu-kzng nzrpilr kx nim dq profet kc bqnc tqlupe mou.” ");
INSERT INTO ntu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Rpibzle kx, “?A' nimu, myx kxmu nzglx-krnamu ninge?” Rpibz Pita kx, “Kxnzmcpx ne Gct.” ");
INSERT INTO ntu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Zbz Jiszs rngidrlvz-ngrbzle badr kx trkrlzkapzle mzli r nzyapwxtine-krbzlr mz leplz nzngini-krde Kxnzmcpx. ");
INSERT INTO ntu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Sc tqrpipebz Jiszs kx, “Ninge, Mrlx Leplz, drtqnge naetqtx zlwz, x natrkalrpx-ngrdr ninge lrtzlvz ngrgung, nidr badr kxnzetu rdr pris, x kxnzalvztrng mz Lou sc Mosis. Sa nanibqlr ninge, a' sa na-atulz-mople ninge Gct Trte mz zbq kratq mz nibr nzbz-krnge.” ");
INSERT INTO ntu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Zbz sc tqrpipebzle badr amrlx ngrdr kx, “Doa kx navz-nqblq-angidrle ninge, narlrpx-lzbq mz nzaetq-ngrbz drtqde mz zbq kang kqlu. X naesablqtile me pnz drtwrde esz'-krde, x bzkq axtxbzle nzo-zli-krde lrpzki rnge. ");
INSERT INTO ntu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Murde doa kx otr-zvzngr drtwrde nzlu-krde, sa namale-lvile nzlungr kxboi. A' krkc tqyrlqtxole nzlu-krde murde lxngitile ninge, sa naprtr mz nzlungr kxboi. ");
INSERT INTO ntu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mane nznginingr bcnyr mz nrlc ka x amrbrtxtrle nzlu-krde mz nrlc kc navzm. ");
INSERT INTO ntu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Doa kx pxtxpx-ngrde ninge x natqngeng mz nzngini-krnge Mrlx Leplz, sa napxtxpx-kz-ngrne nide mzli kc nayzlu-ngr-mopwc' mz zluli rnge x zluli r Trtenge x enjrl kxnztrng. ");
INSERT INTO ntu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","A' napi-angidrbo bamu kx kzdung nimu sa nalubeng mzli kc Gct na-aelwapx-ngrde zmatq ngrde mz nzvectr-krmle leplz mz nzmnclz-krbzlr bade mz nzngini-krde King rdr.” ");
INSERT INTO ntu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mwx zbq rtqmz otx, mz nibr Jiszs nzpi-krbzle da lcng, vzmileng Pita, Jon, x Jemes x sc tzvzdzpeng mz kzdq newz murde Jiszs nakrka'. ");
INSERT INTO ntu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mzli kcpwz tqkrka'-ngrde, Jiszs mzte kc tqblepxpengr x lrpz scde kc tqpnaprtxpxpe. ");
INSERT INTO ntu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nzpwrkilvc-ngrdr ncblo nzling, Mosis x Elaeja, kcng tztupeng badr Jiszs mrkc, tzycmnepeng. ");
INSERT INTO ntu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ncblo lcng nzadcpx-lzbqng mz zluli kxetu, sc tzycmnetrpe-ngrdr kxnamu nzatutrkr Jiszs me pnz drtwr Gct mz nzbz-krde Jerusalem. ");
INSERT INTO ntu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mzli lcde Pita nidr badr kztedeng nzmwipeng. A' kx nzdwalzmlr, sc tzmcpelr zluli r Jiszs, x nzmcpe-kzlr ncblo kcng nzling tztung badr. ");
INSERT INTO ntu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mzli kc ncblo kcng nzling tzrpilr nzrlaszpe-ngrdr Jiszs, sc tqrpipebz Pita mz Jiszs kx, “Kxakrlz, mrlztx angidr nzmnc-krgu mrka. Mwx nawztibzkr du matelq natq, nangi nyzm dq, nyz dq Mosis x nyz dq Elaeja.” (Trkrlz-angidrleu da kc tqpile.) ");
INSERT INTO ntu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mzli kc tqycmnebe-ngrde, kzdq dcbz aelwapx-lzbqngr x akqlvztxde nidr mz zmyo ngrde. X nzmwxlrtx-pnzng. ");
INSERT INTO ntu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Natq Gct vzpxm mz dcbz kc. Rpibzle badr kx, “Krlc mrlxnge Kxnzmcpx. Lalztqbzmu bade!” ");
INSERT INTO ntu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Natq kc kx esakitxde, Jiszs kc tqtutxpe mrkc esz'-krde. Da lcng yc-lrpitxtrpwz badr Pita, Jon x Jemes. A' trpnzngr kx nzpi-nebadrle mzli lcde. ");
INSERT INTO ntu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nrlc ngrlxobz sc tzvzopemqng mz newz kc. Zbz zbo ngr leplz kxetu sc tzrmctipeng Jiszs badr Pita, Jon x Jemes. ");
INSERT INTO ntu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kzdq ncblo sc tqkabopxpem mz nabz zbo ngr leplz kcng. Rpipxmle kx, “Kxakrlz! Mctxbz ena mrlxnge, murde mrlxnge delcpwz esz'txu! ");
INSERT INTO ntu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kzdq drka' mncpxm bade, x mzli kx dwatitr-ngrde mrlxnge, sc tqanepele nide. X batrpzle nzglqkr nimzle, vz vz mzli kx nqbya ngr naode wxbutr-ngrbzle. Tqatakrtibzle drtqde, x waisr-zvz-ngrde nide! ");
INSERT INTO ntu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yrnititrpo mz ncblo nemqng kx namaszlrpx-ngrbzlr bade. A' trnzyatrpwzung.” ");
INSERT INTO ntu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Rpibz Jiszs kx, “?Nike nawai-mopwc' bamu? Nzmnc-krbo bamu mzli boipe! A' trkrlzkalamu nzrlxngitingr x narmu kc tqmqngibe.” Zbz sc tqrpipebzle mz ncblo kc kx, “Vzmim mrlxm mrka.” ");
INSERT INTO ntu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Doa ncblo kc kx vzmle, drka' kc sc tqrtcope-ngrde nide mz drtc' x sc tqngi-batrpebzle nzglqkr nimzle. Jiszs pnanatile drka' kc. Amrlzle doa ncblo kc, x sc tqavzpebzle mz trtede. ");
INSERT INTO ntu_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Leplz amrlx nzkctitxpxlr zmatq ngr Gct kc tqmyalz. ");
INSERT INTO ntu_vpl VALUES ("LK9_43b","072_9_43b","LUK","9","43b","43b","Mzli kc leplz mztr tqprtxbe-ngrde x naodr tqmztxbe-ngrde mz nzrkctipx-krdr, Jiszs kc tqrpipebzle mz ncblo nedeng kx, ");
INSERT INTO ntu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Da lc napibo bamu bzkq mrbrtr mz drtwrmu! Ninge Mrlx Leplz sa na-aprcbz mz zmatq ngr kxnzmwati drtwrdr ninge.” ");
INSERT INTO ntu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","A' trnzkrlzlru nike drtwr ngrde. Nzyrlq-kapqbz badr x tryrplatitru nardr. A' nzmwxlrtilr nzveati-krbzlr nzycmnengr lc. ");
INSERT INTO ntu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kzdq mzli, ncblo neng Jiszs tztalwzti-lzbq-ngrdr neke mz nidr kx myapxbz. ");
INSERT INTO ntu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Krlztrpebz Jiszs da kx tqpnz drtwrdr, zbz otile kc kzdq doa kxtopwz sc tqatupele mz nrlarde. ");
INSERT INTO ntu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","X sc tqrpipebzle badr kx, “Mrlx kx vz-nqblqle ninge mz nzabrtzlvz-krde doa kxtopwz mz drtqnge, abrtzlvz-kzle ninge. X mrlx tqabrtzlvzle ninge, abrtzlvz-kzle Trte kc tqatwzlr-ngrmle ninge. Murde mrlx kx avzo-lzbq, nide kx myalz-zlwzbz mz mz Gct.” ");
INSERT INTO ntu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon rpibzle mz Jiszs kx, “Kxetu rnge, mckr kc ncblo kx rmaszlrpxngr drka' mz drtqm. A' pibzkr bade kx naesakipe, murde trprtrpuu bagu.” ");
INSERT INTO ntu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Rpibz Jiszs bade kx, “Bzkq! Murde mrlx kx tr-rpwa'-ngrbzleu bamu nzale-krmu nzwz-krmu, tukile mz nrlarde nyzmu.” ");
INSERT INTO ntu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Zbq trkqlupeu kx ycbep mz nzbzkr Jiszs x sc tzvzmilzpe Heven, sc tqaoti-angidrpe drtwrde nzvz-krde Jerusalem. ");
INSERT INTO ntu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Atwzlr-ngrde kcng menrpa nedeng kx nartwayz-kaipzng bade. X sc tzvztrpeng mz kzdq mztea ngr Szmariz mz nzoliqti-krbzlr dakxnzng x ma kx namwi-ngrdr. ");
INSERT INTO ntu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","A' leplz kcng mrkc nzpxtxpx-ngrdr nzadwatr-krdr nide, murde opx angidr kx nzvz-krde la navzkile Jerusalem. Tzwai-ngrdr da lc murde lr Szmariz nztrkabzng badr lr Jiu x mzteadau Jerusalem. ");
INSERT INTO ntu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kx nzxlrpe Jemes nidr mz Jon da lc, sc tzrpipebzlr mz Jiszs kx, “?Kxetu rgr, trnakqlelzkakr nyr Heven navzom x na-atrkatile nidr?” ");
INSERT INTO ntu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","A' Jiszs o-lxlvrbz sc tqlclvzpebzle. {X rpibzle badr kx, “Drka' la tqbatrpzle nzycmne-krmu lc. Murde ninge Mrlx Leplz trvz-ngrpwc'u nzodati-krnge nzlukr leplz, a' vz-ngrmc nzarlapxngr nidr.”} ");
INSERT INTO ntu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","X sc tzvzkipelr mztea kzble. ");
INSERT INTO ntu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mzli kc tzvzpe-ngrdr, kzdq ncblo rpibzle mz Jiszs kx, “Sa navz-nqblqx nim drlve keng vzkiq.” ");
INSERT INTO ntu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","A' rpibz Jiszs kx, “?Krlz-angidr-kzq da kx ycpxm mz nzrvz-nqblqngr ninge? Murde fokis nzmnc-zpwxng mz ma nyzdr kx yclzm mz gq. X utc nzmnc-zpwx-kzng mz ma nyzdr kx ngi nrla nounc. A' ninge Mrlx Leplz, trmnc-zpwxwxu, murde lr mrnyzngeng nzpxtxpx-ngrdr ninge. X sa napxtxpx-kz-ngrdr nim. ?Myx kxmule, navz-nqblqpeq ye ninge?” ");
INSERT INTO ntu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Rpibz Jiszs mz kzdq kz ncblo kx, “Vz-nqblqm ninge.” A' rpibz ncblo kc kx, “Kxetu, na-ale-kaipo me pnz drtwr trtenge mzli ka, a' mz nibr nzbz-krde sc tqvz-nqblq-atex nim.” ");
INSERT INTO ntu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Rpibz Jiszs kx, “Trtingr! Rlrpe-ngrbz ye mz krkcng mqngrdr nzbzpeng nzyrtzmq-krdr kxnginidr kx nabzng.” ");
INSERT INTO ntu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kzdq kz ncblo rpibzle kx, “Navz-nqblqbo nim, kx Kxetu. A' navztx-kaipo mz trtenge narlxtibo bade kx rlr-ngrmle o trtingr.” ");
INSERT INTO ntu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Rpibz Jiszs kx, “Ncblo kx ryabo nrlanc a' matinetr drtwrde, trnatwzleu dalr nrlanc. X mz nqmq lcpwz, mane nzpnzkr drtwr doa nzmnclz-krbzle mz Gct mz drtwrde nzlitr-krbzle. Murde rblx nzvectr-krbzle leplz mz Gct mz nzngini-krde King rdr.” ");
INSERT INTO ntu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mz nibrde Jiszs mcpx-moule leplz nzpnu-rlimz-nrade-li. X atwzlrpx-ngrde nidr nzli-lxblrng mz nzrtwayz-kai-krbzlr mz mztea kcng amrlx x mrkcng navzkibzle. ");
INSERT INTO ntu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Rpibzle badr kx, “Kxmule-esz' leplz kxkqlu nzoliqng mz nzlxngiti-krdr Nrpakxmrlz murde nanginidr doa neng Gct, a' mzli ka kxnzawzng nzpipzbeng kx nzaelwapx-ngrbzlr lrpzki angidr badr. Mz nzmu-krde lcde, krka'-ngrbzmu mz Trte, kc tqoliqtile krkcng nabrti drtwrdr ninge. Rlxtibzmu bade nzatwzlr-krmle kzdung mou kxnzawzng kx naokatrlr nimu mz nzvzmi-krmlr leplz bange. ");
INSERT INTO ntu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Oliqamu mz nzvzngr. Murde atwzlrpx-ngrbo nimu mz mzlir leplz kxdrka'-ngrng. Nzapulr kuli kzpeto kx nzrmaneuting leplz. A' Gct sa na-aclvele nimu. ");
INSERT INTO ntu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bzkq rtwzamu trau x bxli, a' twz-txpwzmu sadol kc tqyctr mz nanycmu. Bzkq nzaotr nimu leplz nzycmne-krbzmu badr mz lrpzki, a' rnekitiamu mz nzvzngr. ");
INSERT INTO ntu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mz nzdwatr-krmu mz ma kx nzabrtzlvzlr nimu, rpi-kaipzmu kx, ‘Krka'-ngrne kx Gct na-amnc-zpwxle nimu.’ ");
INSERT INTO ntu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nzmu ncblo kc tqmnc mrla kx tqabrtzlvzle natqmu, nzmnc-zpwxngr la nakrlzbzle nide. Nzmu kx trpnz-ngrde, trpnzngr nzkrlz-krbzle nide. ");
INSERT INTO ntu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mz nzmnc-krmu, mncpepwzmu mz ma la esz'. Dakxnzng kznike nzkabzlr bamu, ngqamu, murde takitrde ncblo kxwz natwzle dalr nzwz-krde. Bzkq vzkiamu mz kzdq ma x vzki-mouamu mz kzdq kz ma. ");
INSERT INTO ntu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Mzli kx vztr-ngrnamu mz kzdq mztea x nzabrtzlvzlr nimu, ngqnamu dakxnzng kx nzkabzlr bamu, kxmule-esz' kxmu nzasungr trvz-nqblqleu Loukxtr. ");
INSERT INTO ntu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Amrlzamu nrkrdrtq kxnzyagoxng mrla, x rpibzmu mz leplz amrlx kx, ‘Gct sa tqaesonetrpemle nimu mz nzmnclz-krbzmu bade mz nzngini-krde King rmu.’ ");
INSERT INTO ntu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","A' nzmu kx tqvztramu mz kzdq mztea x trnzabrtzlvzlru nimu, e vzne-alzuamu mz mzlir ma lang. ");
INSERT INTO ntu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","X pibzmu badr kx, ‘Rtc-ngrbzkr rplz nakrlz-ngrnamu kx nqmq krmu trka mz nzapu-krmu kxnzmnc-mrbrng. A' nadctipx drtwrmu kx Gct rpile navectrpemle nimu mz nzmnclz-krbzmu bade mz nzngini-krde King rmu. A' pxtxpx-ngrnamu nrpa lc, x mz nzmu-krde lc tqpxtxpx-kz-ngrnamu nide!’” ");
INSERT INTO ntu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Rpi-mopwz Jiszs kx, “X napi-angidrbo bamu kx mz Mzli Kxmatq kc navzm, nzayrplapxkr Gct nidr namyaszpxle lr Sodom kxdrka'-ngrng kcng bqnc.” ");
INSERT INTO ntu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Rpi-mopwz Jiszs kx, “Agrmplz nimu lr Korasin. X agrmplz kz nimu lr Betsaeda! Murde Gct sa na-ayrplapxle nimu. Trtekqtrwamuu nqmq nr drtwrmu kxmule-esz' mcamu da kcng tqmatq tzalepxm mz taon nyzmu. A' lr Taea x lr Saedon kxnzmnc-mrbrng kxdrka'-ngrng nzmyaszpxlr nimu. Murde nzmu rkx lcng na-alepx-pnzmle mz taon nyzdrng, e lr mztea lcdeng nzmu nzpxing dzlvq lrpz x nzrlung bq, ngi dalr nztekqtr-krdr nqmq nr drtwrdr. ");
INSERT INTO ntu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mz nzmu krde lc, mz Mzli Kxmatq kc navzm, nzayrplapxkr Gct nimu namyaszpxle nzayrplapx-krde lr Taea x Saedon. ");
INSERT INTO ntu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","X agrmplz nimu lr Kzpznizm murde pxtxpx-ngrnamu ninge. Kxmule-esz' glqlz-lzbqamu wq murde rpiamu natakitramu Heven, a' Gct sa na-adwatrle nimu mz Hxl!” ");
INSERT INTO ntu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Zbz rpibz Jiszs mz leplz nedeng kcng nzpnu-rlimz-nrade-li (72) kx, “Doa kx lxngitile natqmu, lxngiti-kzle natqngeng. X doa kx pxtxpx-ngrde nimu, pxtxpx-kz-ngrde ninge. X krkc tqpxtxpx-ngrde ninge, pxtxpx-kz-ngrde Gct, kc tqatwzlr-ngrmle ninge.” Mz nibr natq lcng, sc tzvzpeng. ");
INSERT INTO ntu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Mzli kc tzyzlu-ngrm ncblo kcng nzpnu-rlimz-nrade-li nzabrtz-zlwzng. X sc tzrpipebzlr mz Jiszs kx, “Kxetu rgr, kxmule-esz' drka' kcng nzlxngitimlr nigr mz nzrkapx-krbzkr natq mz drtqm.” ");
INSERT INTO ntu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Rpibz Jiszs kx, “Krlztipex da lc murde Setzn taom mrkc tqycngr zmatq ngrde. Nzo-anikr nztao-krmle apule bzlrpc kc nilz rde tqo ani txpwz nzvzo-krmle mz bongavz. Nzwz-krmu aovxiole zmatq ngrde. ");
INSERT INTO ntu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kapebo bamu zmatq ngr nzrnzlvzo-krmu zmatq ngr drka', murde namaszlrpx-ngrnamu drka' mz leplz. X kxmule-esz' otaamu badr enqmi rmu Setzn, a' sa na-aovxioamu nide x trpnzngr doa x da kx na-atrkale nimu. ");
INSERT INTO ntu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","A' bzkq abrtz-ngramu drka' kcng nzlxngiti-krdr nimu. Na-abrtz-kz-ngrnamu ye kx Gct yropele drtqmu mz buk ngr nzlungr mrkc Heven.” ");
INSERT INTO ntu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mzli lcde Mqngrkxtr prsrle Jiszs, x mz nzabrtz-krde sc tqrpipele kx, “Trte, Kxetu r lr Heven x lr nrlc! Awibo bam murde aelwapx-ngrbzme mz doa kcng tzavzo-lzbqng da kcng tqyrlq-kapqbzme mz ncblo kcng tzsiklung x tzrpilr kx nzyrplapxng. Trte, da lc vz-nqblqle me pnz drtwrm. Eu.” ");
INSERT INTO ntu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Rpibz Jiszs mz leplz kcng tzmncng mrkc kx, “Nzrkrlzngr x zmatq amrlx kapem Trtenge bange. Trpnzngr leplz kx rkrlzti angidr ninge, a' ngi txpwz Trtenge. X trpnz-kzngr leplz kx rkrlzti angidr Trtenge, a' nitxpwo, x leplz kcng tqmcpxx mz nzaelwapx-krbo nide badr.” ");
INSERT INTO ntu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Zbz Jiszs o-lxlvrtxbz mz ncblo nedeng x sc tqrpi-lrpipebzle badr kx, “Ngi da kx mrlz nzmc-krmu da kcng tqalepex! ");
INSERT INTO ntu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Murde profet x king nzkqlung mzli kc nzrpilr namc-kzlr ninge, Kxnzmcpx ne Gct x da lcng tqalepexng, a' trnzmc-pnzlru. X nzrpilr naxlr-kzlr da lcng tqxlramu, a' trtxpnzngr.” ");
INSERT INTO ntu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kzdq kxalvztr mz Lou sc Mosis tulzm sc tqkapxbzle natq ngr nzatalzngr lcde se. Rpibzle kx, “?Kxakrlz, nike na-alex mz nzprtr-krnge mz nzlungr kxboi?” ");
INSERT INTO ntu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Rpibz Jiszs kx, “?Nike pi Lou sc Mosis? ?Myx kxmu nzyrplatitrkr narm le?” ");
INSERT INTO ntu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Rpibz ncblo kc kx, “Mrlzti Yawe, Gct ngrm mz nabzm atwrnrngr, x mz nzwikr nelzm atwrnrngr, x mz zmatq ngrm atwrnrngr, x mz drtwrm atwrnrngr. X mrlzti kztemqng da kc tqwaiq nzmrlzti-lzbq-krm.” ");
INSERT INTO ntu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Rpibz Jiszs kx, “Nzayzlu-krm natq tubqtx angidr. Nzmu na-ale-angidrq da lc x trpnzngr nzwrde kx atatxo-ngrnle, sa naprtrq mz nzlungr kxboi.” ");
INSERT INTO ntu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","A' mz nide esz'-krde rpile tubq, sc tqrpipebzle mz Jiszs kx, “?Nekeng kztengeng kx namrlztixng?” ");
INSERT INTO ntu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Zbz Jiszs kc tqyapwxtipebzle kzdq kc be mz nzaelwapx-krde kx namrlztiku leplz amrlx. Rpibzle kx, “Kzdq lr Jiu, vzkiomle Jerusalem, navzkiole mz taon kc Jeriko. Ncblo lc tatxtr mz mqdr ncblo kxdrka'-ngrng. Nzaotxpxbzlr lrpzdeng, nzoti-kzpzlr trau scdeng, x nztztitxdr nide mule nabztx. X sc tzvopeng. ");
INSERT INTO ntu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Zbz kzdq pris kc tqvokiopemle Jerusalem mz lrpzki kcpwz. Navokiopele Jeriko, vone mz dcngki. Kx mcpele ncblo kc, sc tqkawipele, tqo-ngalukipele mz kzdq nrlar lrpzki, murde ma tqbatrpzle trnztakitr-krdeu nide mz nzprtrngr mz nzangiongr mz nzvz-nqblq-krde Lou sc Mosis. ");
INSERT INTO ntu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mz nqmq kcpwz, kzdq ncblo kx vzpxm mz nqvi lr Livae vz-kzp mrkc. Obqtxobz mz ncblo kc, x kawitxde. O-ngalukitxde mz kzdq nrlar lrpzki kc, murde rpile kx nzrlr-krbzlr nzprtr-krde mz nzangiongr myaszpxle nzokatr-krde ncblo lc. ");
INSERT INTO ntu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","A' kzdq doa lr Szmariz kx vzkio-kzple mz lrpzki lcde, mcpele ncblo kc, sc tqyctxpe mz drtwrde. ");
INSERT INTO ntu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Vztxbz bade x wztibzle kxsqki ngrdeng mz waen x pnutibzle mz tolo, x pilvzbzleng dzlq lrpz. Zbz glqlzle ncblo kc mz dcngki nede, sc tqvzmipebzle mz kzdq ma kx nzamatrngr mz lrpzki, tqaclvepele elr. ");
INSERT INTO ntu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nrlc ngrlxobz, kalzmle kcng trau kx takitrde kzdung zbq nzmnc-krde mz ma kc, sc tqkapebzle mz ncblo kc tqaclve ma kc. Rpibzle kx, ‘Aclvepwz x nzyzlu-krmc sc tqayzlupe-mopwc' nikeng ayrbzkqtrpzmeng bade.’” ");
INSERT INTO ntu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Rpi-mopwz Jiszs mz kxalvztr mz Lou sc Mosis kc kx, “?Nzpnzkr drtwrm le, neke tqapubzle kztede mz ncblo lc tqtabq ncblo kxayo?” ");
INSERT INTO ntu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Rpibz ncblo kc kx, “Ncblo lcde kc tqmrlztile nide.” Rpibz Jiszs kx, “Vz x vz-nqblq kz nqmq kr ncblo lc.” ");
INSERT INTO ntu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jiszs badr ncblo nedeng, kx nzvzpelr kc, sc tzvzpxpeng mz mztea Betzni, me mncngr kzdq kc olvz drtqde Mata. Sc tqaodupele Jiszs. ");
INSERT INTO ntu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mzli kc tzmncpe-ngrdr brma, ilede Mxri, wxbu-aepztrpz mz Kxetu x tqlalztqbz mz nzalvztr-krdeng. ");
INSERT INTO ntu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","A' Mata drtwrde otxtrpwz mz nzwzngr kcng tqaleleng. Zbz sc tqvzpem mz Jiszs tqrpipebzle kx, “Kxetu rnge, ilenge rlasztxpemle bange nzalengr da kcng amrlx. ?Krlzq nzrpi-ngrbz bade naokatrle ninge?” ");
INSERT INTO ntu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Rpibz Kxetu kx, “Mata e, bzkq otr kato mz drtwrm da lang kqlu. ");
INSERT INTO ntu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","A' da esz'txupwz kx myapxbz. Mxri krlzle da lcde, x tr-rpwa'-ngrpwc'u bade nzlalztq-krde mz nzalvztr-krngeng.” ");
INSERT INTO ntu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kzdq mzli Jiszs krka' mz kzdq nrlc. Kx yrkrpxpebzle kc, kzdq ncblo nede rpibzle bade kx, “Kxetu rnge, alvztrp bagr nzkrka'ngr, da kc tqwai Jon Kxawrkxtr nzalvztr-krde oblamzdeng.” ");
INSERT INTO ntu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Rpibz Jiszs badr kx, “Mz nzkrka'-krmu rpiamu kx, ‘Gct Trte, batrp bagr nigr lr nrlc, nzamatq-krgr drtqm kxtr-esz'ngr, x nzmnclz-krbzkr bam nzngini-krm King rgr. ");
INSERT INTO ntu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kam bagr dzu r da kx natakitrde mzbq ka. ");
INSERT INTO ntu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","X ipqpxbz alwx ngrgrng navz-nqblqle nzipq-krgr krkcng tzaletrpqng da kx trmrlzu bagr. X arlapx nigr mz nzokatr-krm nigr mz nztu-amqngi-krgr mz nzatalzngr. Eu, angida.’ ");
INSERT INTO ntu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","“Napi-mopwc' dq nzycmne-ebzpxngr. Kzdq mzli kzdq kc ncblo adwatile kc kzlede kx kaputrp mz ma nyzde mz aurnrlc. Ncblo lc vzm, x navzkile mz kzdq nrlc. A' trpnzngr nadr dakxnzng kx nakabzlr bade. X ncblo kc tqrnginyz ma, vz mz ma kzble mz nzrlx-krde da. Zbz sc tqrpipebzle kx, ‘?Mzlenge, nakame bange du dakxnzng?’ ");
INSERT INTO ntu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","8","Kxmule-esz' ncblo kc naonrx nyzde pqbrpe x tzmncpeng badr doa nedeng me nzmwi-ngrdr, a' sa natulzpebz mz nzokatr-krde kztede, murde drtqde ma tqamyabz lr mztea nyzdeng. X sa nakabzle da kcng amrlx tqsutibz drtwrde, murde tubq nzale-krdele. ");
INSERT INTO ntu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Mz nqmq lcpwz, rlxtibz da mz Gct, x sa nakabzle. Rtangr da x sa narmctiq. Abc x naonrx sa nalvxpxbz. ");
INSERT INTO ntu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Murde doa kx rlx da kx takitrde nide, sa natwzle. X kx rtangrtile nzokatrkr Gct, sa nangida. X kx abctr-zvzbz mz Gct, naonrx nyz Gct sa nalvxpxbz bade. ");
INSERT INTO ntu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Murde trpnzngr trte doa kx rkabz mz mrlxde ningidoe mzli kx rlx-ngrbzle nc. ");
INSERT INTO ntu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","X trkapwzleu nalx mzli kx rlx-ngrbzle neimr kio. ");
INSERT INTO ntu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nimu kcng trnztubq-zvzung krlzamu nzale-krmu da kxtubq mz nzrka-ngrbz da kxmrlz mz doa nemung. A' da kx myapxbz, Trtemu kc Heven, krlzle nzale-krde da kxtubq mz nzka-krbzle Mqngrkxtr mz krkcng nzrlxtibzlr bade.” ");
INSERT INTO ntu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kzdq mzli, Jiszs rmaszlrpxngr drka' kx batrpzle nznabukr kzdq ncblo. Ncblo kx prszpx drka' kc le, sc tqycmnepe. Zbz nzkctitxpx zbo ngr leplz kcng. ");
INSERT INTO ntu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","A' kzdung leplz nzrpilr kx, “Beelsebol ela, kxetu r ma ngr wq, nide kc tqaclvele drka' amrlx, x sc tqrkabz bade zmatq ngr nzrmaszlrpx-krde drka' mz leplz.” ");
INSERT INTO ntu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kzdung kz nzabzpxlr nide mz nzrlxti-krbzlr bade kx na-alebzle dq da kxmatq mz nzaelwapx-krde kx zmatq ngrde vzpxm mz Gct, a' trvzpxpuu mz Setzn. ");
INSERT INTO ntu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","A' Jiszs krlztitrpebzle drtwrdr x mz nzaelwapx-krbzle badr kx nzvz-rbrng, sc tqrpipebzle kx, “Kandre kx akipx-lzbq mz dzbede sc tzota-etrpeng, mzli kxpipzne sa naodating. Mz nqmq lcpwz doa lr ma kxesz' kx nzamnc-dali-lzbqng, sa na-apulr ma kx wxtxo. ");
INSERT INTO ntu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","X mou, nzmu Setzn badr drka' kztedeng naotablrlr mz nidr esz'-krdr, e zmatq ngrde mz nzaclve-krde leplz sc tqmanepe. ");
INSERT INTO ntu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kxmule-esz' rpiamu kx rmaszlrpx-ngrne drka' mz zmatq ngr Setzn, a' tr-rpiwamuu kx oblamzmung nzrmaszlrpx-kz-ngrdr mz zmatq ngrde. Mz nzmu-krde lc, nzkrlzlr nzrpi-ngrbz bamu kx vz-rbramu! ");
INSERT INTO ntu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","A' me ngi daki-angidrle se. Mz nzmaszlrpx-krnge drka' mz zmatq ngr Gct, aelwapx-ngrne kx Gct sa tqvectrpemle leplz bade mz nzngini-krde King rdr. ");
INSERT INTO ntu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Murde Setzn apule ncblo kx xplr, kx tumile mclrde atwrnrngr mz nzotangr, x aclvele ma nyzde, murde leplz kcng tqlolvzleng ma tzrlapxng. ");
INSERT INTO ntu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","A' ninge ncblo kx xplrpxbz x aovxiopex nide. X twzpex zmatq ngrde atwrnrngr, kc tqabrtr-ngrde drtwrde. X kapebo zmatq rnge mz leplz kcng tqarlapxpex mz nzmaszlrpxpe-krbo drka' kcng badr, murde natu-pz'liti-ngrdr nide. ");
INSERT INTO ntu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Na-aoti drtwrmu nrlarde kx namnckiamu. Doa kx trmnckileu mz nrlarde nyznge, nide enqmi rnge. Doa kx trokatrleu ninge mz nzrvzmi-ngrm leplz mz Gct, nide kx rmaszlrpxngr leplz mz nzvz-krmlr bade.” ");
INSERT INTO ntu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Rpi-mopwz Jiszs mz leplz kcng kx, “Mzli kx kzdq drka' nzmaszlrpx-ngrde mz kzdq ncblo, drka' la vzne lzke, rtangrne me na-ama-ngrde mz nabz leplz. A' nzmu trnamcleu kzdq nrlc, sc tqrpipele mz nide esz'-krde kx, ‘Nayzlupe-moux mz ma nyznge kc tqrlaszpemc.’ ");
INSERT INTO ntu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Zbz yzlu mou, x mcle ncblo kc mrlzpe x nqmq krde mrlzpe x trpnzngr kxnzmncng mzlilxlr kzble kx mncpxm bade. ");
INSERT INTO ntu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Zbz vzpx x vzmitrple drka' rlimz kx nztrka-krdr myaszpxle nztrka-krde. Nzvzmqng sc tzmncpxpemqng bade. X nzmnckr ncblo kc sc tqtrkatx-zlwzpe, myaszpxle mzli kc kai.” ");
INSERT INTO ntu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mzli kc Jiszs tqycmne-ngrde, kzdq olvz ycmnelzm mz mzlir zbo ngr leplz lcng x rpibzle kx, “Namrlzbz mz lxem murde mikale nim x ayqle nim!” ");
INSERT INTO ntu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","A' rpibz Jiszs kx, “Eu, a' sa namrlz-kzpz mz leplz kcng tzxlrng natq Gct x nzvz-nqblqlr!” ");
INSERT INTO ntu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Zbz zbo ngr leplz kc, kx etunepxpele, sc tqrpipe-moule kx, “A' nimu leplz kcng tzmncng mzli ka kxdrka'-ngrng. Rlxtiamu kx na-alebo dq rkx kxmatq-esz'ngr mz nzaelwapx-krnge kx vzpxmc mz Gct. A' trpnzngr rkx kx na-aelwa-ngrbo bamu, a' nangi txpwz rkx kc tqalebz Gct mz profet Jona kc bqnc. ");
INSERT INTO ntu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Murde nqmq kcpwz Jona tqngini-ngrbzle rkx mz lr taon kc etu Ninive, e ninge, Mrlx Leplz, nangini-kzpo rkx mz lr nrlc ka. ");
INSERT INTO ntu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mzli kc bqnc kwin kc Seba mrkc Arabia, vzm rlru mz nzlalztq-krbzle mz Solomon mz natq ngr nzyrplapxngr. Kxmule-esz', a' mzli ka doa kx myaszpx-zlwzle Solomon vzpem, a' pxtxpx-ngrnamu nzlalztq-krbzmu bade. Mz nzmu-krde lcde, mz Mzli Kxmatq kc navzm, Kwin kc Seba sa naycmne kz mz kot mz nzpipx-krde kx vz-rbramu, murde trlalztqpwzmuu mz Gct mz natq ngr nzyrplapxngr. ");
INSERT INTO ntu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mz nqmq lcpwz, mzli kc bqnc leplz ngr taon kxetu Ninive nzlxngitilr nrpa ngr Gct kc tqyapwxtipxbz Jona badr, x nztekqtrlr nqmq nr drtwrdr mz alwx ngrdr. Kxmule-esz', a' mzli ka doa kx myaszpx-zlwzle Jona vzpem mz nzyapwxtipx-krbzle nrpa ngr Gct bamu, a' trtekqtrwamuu nqmq nr drtwrmu. Mz nzmu-krde lcde, mz Mzli Kxmatq kc navzm, lr Ninive sa naycmne-kzng mz kot mz nzpipx-krdr kx vz-rbramu, murde trlxngitiwamuu nrpa ngr Gct da kc tzwailr.” ");
INSERT INTO ntu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Rpi-mopwzle kx, “Trpnzngr leplz kx rtekao lam sc tqyrlq-kapqpele. X tralalvzo-kzleu topla. A' lam nzadolzpwz wq, murde leplz namclr zyzlr mz nzdwatr-krmlr brma. ");
INSERT INTO ntu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","X nzmu mzpu mrlz, krlzamu nzrmc-angidrngr da. A' nzmu mzpu trmrlzu, trkrlzwamuu nzrmcngr da. ");
INSERT INTO ntu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Mz nqmq lcpwz, na-ayayramu nabzmu murde nakrlzamu nzalvztrngr angidrng. A' bzkq amqngiamu nabzmu murde ma tqvz-rbr-zvzamu. ");
INSERT INTO ntu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Murde mzli kx nabzmu yayr-ngrde, krlzamu nzrkrlzngr da angidr kx vzpxm mz Gct. X da angidr lcde sa na-apule zyzlr kx na-aopx-angidrbzle da mz nabzmu.” ");
INSERT INTO ntu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Mzli kc Jiszs tqyrkrpxpe-ngrbzle nzycmne-krde, kzdq kc Farzsi sc tqaveatipebzle nide kx namung badr. Kx krlzbzle kc ma nyzde, sc tqvztrpebz tqwxbuope mz nzmungr, a' trwzti-kaileu mqdeng. ");
INSERT INTO ntu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farzsi kc pwrkilvc-ngrde nzmc-krde kx Jiszs trvz-nqblqleu nqmq kxtr krdr, x sc tqmu ate. ");
INSERT INTO ntu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jiszs krlzle da kc tqaoti drtwr Farzsi kc, sc tqrpipebzle bade kx, “Nimu Farzsi aoti txpwz drtwrmu da kx trmyapxpwzu. Krlzamu nzrwztingr kxpipz nibr kap x nibr plet mz nzvz-nqblqngr nqmq krmu, murde natubqamu mz Lou sc Mosis. A' nabzmu yrbupxm mz nzpnangr da x nqmq ngr alwx. ");
INSERT INTO ntu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Narmu trka x lukurnr-ngrnamu! Murde Gct kc tqrwzngr nrkrdrtqmu yz, nide kc tqrwz-kzngr nabzmu. X mz nzobq-krde, nzbrngzkr nabzmu myaszpx-zlwzle nzrwztingr nibr da. ");
INSERT INTO ntu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nzmu nasuti drtwrmu nztubq-ngrbz mz nzobqkr Gct, bzkq aoti drtwrmu da kx trmyapxpwzu. A' naokatr-alzuamu kxtrnzrngiscung da mz nzrka-ngrbz badr da kxmrlz kx trpnzngr scdr. Murde nzmu na-aleamu da lcng mz nabzmu angidr, nimu badr dztumu amrlx sa natubqpebzmu mz nzobqkr Gct. ");
INSERT INTO ntu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“A' agrmplz nimu, kx Farzsi. Gct sa na-ayrplapxle nimu. Murde kxmule-esz' kabzmu da kranzpnu ngr da scmung amrlx bade mz nzaotikr drtwrmu da kxtopwzng kx trmyapxpwzu, a' trkxu mz drtqmu da kxmyapxbz. X tralewamuu da kcng tqtubqbz mz leplz, x trmrlztiwamuu nidr mz nivz lr Gct. A' takitrde nzale-kai-krmu da lcng tqmyapxbz, x ale-kzamu da kcng trmyapx-zlwzpwzung. ");
INSERT INTO ntu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Agrmplz nimu, kx Farzsi. Gct sa na-ayrplapxle nimu mz nzglqpx-lzbq-krmu! Murde rpiamu nawxbupwzmu mrkc tqmrlztxpxbz mz mangr-nzkrka'ngr, x leplz napi-txpwz bamu natq ngr nzamatqngr me nzyrlwr-lxblrngr. ");
INSERT INTO ntu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Agrmplz nimu, kx Farzsi! Gct sa na-ayrplapxle nimu! Murde apuamu gq lr kxbz kx trnzyrqlzu, x mzli kx leplz nzvzneo-ngrmlr elr, batrpzle trnztakitr-krdru nidr nzprtrngr mz nzangiongr. Mz nqmq lc kz, rblxbz mz leplz nzkrlz-krdr kx nqmq krmu trka. X mzli kx nzvz-nqblq-ngrdr nimu, batrpzle trnztakitr-krdru nidr.” ");
INSERT INTO ntu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Zbz kzdq ncblo kxalvztr mz Lou sc Mosis rpibzle bade kx, “Kxakrlz, mz nzycmne-krm lc pibqtx-kzq nigr!” ");
INSERT INTO ntu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Rpibz Jiszs kx, “Agrmplz nimu, kx kxnzalvztrng mz Lou sc Mosis. Gct sa na-ayrplapx-kzle nimu! Aleti-katoamu nqmq krmu kxkqlu kx yrlqtr-mopwz mz Lou sc Mosis. X rblxbz mz leplz nzma-nqblq-krdrleng. Murde nqmq lcng nzapulr da kxmrlepu, kx yrlqlzbzmu mz nabxdr kx naglqlr. A' nimu esz'-krmu, trvz-nqblqwamuu nqmq lcng x trokatrwamuu leplz mz nzrglqngr. ");
INSERT INTO ntu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Agrmplz nimu! Murde kxmule-esz' rwzo-ngrnamu da kx ycobz mz gq lr profet kcng bqnc, a' profet lcng tznibqti melrmqmung. ");
INSERT INTO ntu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Wztx-ngrbzmu gq lr profet kcng tznibqti melrmqmung. A' trblepx-pnzpwzmuu badr. Murde pxtxpx-kz-ngrnamu nzvz-nqblq-krmu nzalvztrkr profet neng Gct. ");
INSERT INTO ntu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","A' vz zvz, murde Gct ycmnetr-ngrde nimu mz nzyrplapx-krde mz nzrpi-krde kx, ‘Profet x menrpa nengeng sa navzbzng mz leplz nengeng mz nzpipx-krbzlr badr natqnge. A' kzdung nidr sa nanibqlr x kzdu-kzng sa na-atrkatilr.’ ");
INSERT INTO ntu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Mz nzmu-krde lcde, sa narmctiamu nzayrplapx-zlwzngr nimu. Murde Gct sa na-atamutilzbzle bamu alwx ngr nzrnibqngr profet amrlx, ");
INSERT INTO ntu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","abzo mz Ken nznibq-krde Ebol, krlzmle nzrnibqngr Sekaraea, kc tznibq me tavau mz mzlir olta x Mrkc Tqtr. Napibo bamu, Gct sa na-atamutilzbzle bamu alwx ngr nzrnibqngr profet amrlx, murde nzbz-krdr vzpxm mz da kcng tqaletiamu. ");
INSERT INTO ntu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Agrmplz nimu, kxnzalvztrng mz Lou sc Mosis. Gct sa na-ayrplapxle nimu! Murde tr-rlrpx-lzbqwamuu mz nzmnclz-ngrbz bade. X nzalvztr-rbr-krmu rpwa'-ngrbzle mz leplz nzlxngiti-krdr nide. Apule kx yrlq-kapqbzmu badr ki kc nzmu nalvxpxbzle naonrx ngr Heven.” ");
INSERT INTO ntu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jiszs kx rlaszpele kc mrkc, kxnzalvztrng mz Lou sc Mosis, badr Farzsi sc tztrkalrpe-ngrdr nide, x nzrpilr na-aesakibzlr nzwz-krde. Zbz sc tzvea-ebirtxpe-kzpwzng natq kxkqluti. ");
INSERT INTO ntu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Murde nzrpilr na-aprtzlr nide mz trtxki scdr, mz nzrpi-rbr-krde da, x sc tzlolvzpelr nide. ");
INSERT INTO ntu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mzli kcpwz siu ngr leplz tzyrlwr-lxblrng x tzrnekrti-lzbq-ngrdr nzoliki-krdr, Jiszs rpi-kaipzle mz ncblo nedeng kx, “Bzkq apuamu Farzsi. Nzrpilr kx nztubqng, a' nzpokiang. Nqmq krdr apule yisti kx talvzpxle bret atwrnrngr, murde nqmq krdr atrkatipele leplz amrlx kcng tzvz-nqblqlr nidr. ");
INSERT INTO ntu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","A' da kx nzyrlq-kapqting, sa nayrbq-zpwxngr. X mz nqmq lcpwz, da kx nzxpqbrlvzlr, sa napipx me naxlr-lxblr-ngrdeng. ");
INSERT INTO ntu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nike pi-lrpiamu mz nabz nzlo, sa napipx mz nrlckxngrlx. X da kcng tqpi-awabzmu mz leplz, sa napi-kato mz mzlir mztea. Murde alwx ngrmung amrlx kx yc-kapqti, sa nakrlzti leplz kalr. ");
INSERT INTO ntu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“A' napibo bamu, kx mzlengeng, bzkq mwxlrtiamu krkcng nzrnibq-txpwzng nrkrdrtq, a' mz nibrde nzmu trnznibqlru mqngr. ");
INSERT INTO ntu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","A' namwxlrtiamu Gct, murde mz nibr nzrnibq-krde, rngisc zmatq mz nzadwatrngr leplz mz Hxl. Nide kx namwxlrti txpwz! ");
INSERT INTO ntu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Kxmule-esz' nzamwangr boblz kxnzlvqn trau rde pipzne, a' trpnzngr boblz kx mrbrtr mz drtwr Gct. ");
INSERT INTO ntu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","A' nimu myaszlzamu boblz kxkqlu! Murde nqnginarmu amrlx, rlwxti kz Gct kc tqaclvele nimu. Mz nzmu-krde lcde, bzkq mwxlrtiamu leplz. ");
INSERT INTO ntu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Murde doa kx abrtzlvzle ninge Mrlx Leplz mz mz leplz mz nrlc ka, sa na-abrtzlvz-kzx nide mz mz enjrl neng Gct mz Mzli Kxmatq kc na-ayzlu-ngrbz Gct da mz leplz. ");
INSERT INTO ntu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","A' doa kx pxtxpx-ngrde ninge mz mz leplz mz nrlc ka, sa napxtxpx-kz-ngrne nide mz mz enjrl neng Gct. ");
INSERT INTO ntu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Doa kx pibqtile ninge, krlz Gct nzipqpx-ngrbz alwx ngrde, nzmu natekqtrle nqmq nr drtwrde. A' rblx nzipqkr Gct doa kx pivxitile Mqngrkxtr. ");
INSERT INTO ntu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Kzdung mzli sa navzmitrlr nimu mz kot mz mangr-nzkrka'ngr murde lxngitiamu ninge. X na-atubzlr nimu mz kxnzetu r lr Jiu. X kzdung mzli sa navzmilr nimu mz kzdung kz kot. Mz mzli lcdeng, bzkq da nakxne drtqmu kxnamu nzayzlu-krmu natq, x nrpa kc napiamu kx narblxbz badr nzayzlu-krbzlr. ");
INSERT INTO ntu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Murde Mqngrkxtr la naokatrle nimu mz nrpa kc napipxamu.” ");
INSERT INTO ntu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kzdq ncblo kx mncpxm mz zbo ngr leplz kc rpibzle bade kx, “Kxakrlz, pibz mz mzlenge kx na-akikr bade drtc' kc tqbzszm trtegr bagr.” ");
INSERT INTO ntu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Rpibz Jiszs kx, “Trvz-ngrpwc'u nzakingr dztu leplz.” ");
INSERT INTO ntu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Zbz rpibzle mz leplz kcng kx, “Bzkq trkibramu, a' aclvetio-lzbqamu mz da amrlx kx naprlvz mzpu. Murde nzmnc-zpwxngr x nzlungr kxboi trnzvzpxpwung mz nzrngiscngr da.” ");
INSERT INTO ntu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Zbz rpibz Jiszs kx, “Napibo bamu dq nzycmne-ebzpxngr. Kzdq kc bcnyr rnginyz drtc' kx dakxnzng ngrde kqlu x mrlzti. ");
INSERT INTO ntu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kzdq mzli drtwrde aole mz nide esz'-krde kx, ‘Trpengr me nayrlq-ngrne dakxnzng nangeng kx nayctile mzli naboi. ?Nike na-alepex? ");
INSERT INTO ntu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Sa na-awxlikiopex ma ngr da nyzngeng x nawztix ma kxnzetupxbzng, murde nayrlq-ngrne dakxnzng kcng kqlu tqmrlzti x dztungeng amrlx. ");
INSERT INTO ntu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","X mz nibrde sa na-amax x namux x narmnqx x na-abrtzx mz nzmnc-zpwx-krnge! Murde dztungeng takitxtrpedeng nzyc-krdr nzkrlz-krbzle yiz kxkqlu mou.’ ");
INSERT INTO ntu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","A' rpibz Gct bade kx, ‘Kxngqngu e! Mz nrlckxbq ka nabzpeq. X dztumqng amrlx nabzszbzme mz leplz kzbleng.’” ");
INSERT INTO ntu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","X rpi-mopwz Jiszs kx, “X Gct sa na-ayrplapxle leplz amrlx kcng tzatamutilzng da kx nangi scdrng, a' nzpxtxpx-ngrdr nzokatrngr leplz.” ");
INSERT INTO ntu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Zbz sc tqrpipebz Jiszs mz ncblo nedeng kx, “Da kx tqrpi-ngrbo lc bamu kx bzkq da kx nakxne drtqmu mz nzmnc-krmu, mz da kx nangqnamu x lrpz kx napxi-ngrnamu. ");
INSERT INTO ntu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Murde nzmnc-zpwxngr tryctxtrpwzu mz dakxnzng x lrpz. ");
INSERT INTO ntu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","A' na-aoti drtwrmu utc. Trpnzngr da kx nzpetilr x trnzekqlzung dakxnzng. Trpnzngr nyzdr ma ngr dakxnzng, murde apu Gct nidr. A' nzmyalz-krmu myaszpxle utc! X mz nzmu-krde lc, Trtemu sa narkatibz bamu da. ");
INSERT INTO ntu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Rblxbz bamu nzaboinepx-krmu nzlu-krmu mz nzyc-zvzkr mz drtwrmu da. ");
INSERT INTO ntu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","“Mz nzmu-krde lc, mane nzkxkr drtqmu da, murde trokatrleu nimu. ");
INSERT INTO ntu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","A' na-aoti kz drtwrmu nzpqpxkr mqmya. Trnzwzung x trnzrkxsilvzung scdr lrpz. Kxmule-esz' King Solomon kc tqngi nceapu, a' nzlulikr lrpzdeng trmyaszpxleu mqmya lcng. ");
INSERT INTO ntu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Murde Gct la tqapqtipx mqmya nangi lrpzdr nc mqmya. Noude lang trnztu-aboiu murde sa namrbrng mz nzngc-krdr mz nyr, nzngikr nanr leng. Mrla tqyc-ngrde, nakrlzamu kx Gct sa na-apxi-kzle nimu, mz nzmnc-krmu mz nrlc. Murde myaszpx-zlwzamu nounc. A' nzrlxngiti-krmu bzkq topwz! ");
INSERT INTO ntu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mz nzmu-krde lc, bzkq aoti txpwz drtwrmu da kx nangqamu. ");
INSERT INTO ntu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","X bzkq apuamu kxtrnzrlxngitiung kx nzaoti txpwz drtwrdr dakxnzng. Murde trnzkrlzlru kx Gct rkale doa nedeng dakxnzng. A' nadcpx mz drtwrmu kx Trtemu krlzle da kx trycpwzu bamu. ");
INSERT INTO ntu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mz nzmu-krde lcde, narlr-lzbq-ngrbzmu mz nzmnclz-ngrbz mz Gct x mz nibrde da lcng sc tqkape-kzpzle bamu. ");
INSERT INTO ntu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Apuamu sip nengeng x rblx nzokatr-lzbq-krmu. A' bzkq mwxlramu, murde Trtemu kc Heven abrtz-ngrde nzrka-krbzle bamu da kcng tzvzpxmqng mz nzngini-krde King rmu. ");
INSERT INTO ntu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","A' amwa-alzuamu da kcng tqngisctimu x kabzmu trau rdeng mz krkcng trpnzngr scdr. Murde mz nzale-krmu da lc, sa na-atamutilzamu nzrngisc-krmu mrkc Heven, me trnayrkrpx-ngrpwzleu. X mrlc trpnzngr kx napna da x trpnzngr ninr kx nayrti da. ");
INSERT INTO ntu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Na-atamutilzamu nzrngisc-krmu mrkc Heven, murde mrkc tqyrlq-ngrnamu dztumung, delc tqyc-kzngr nabzmu. ");
INSERT INTO ntu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Mzli kx nzyrlzngr, ncblo kxyrlz prtr kai mz nzmungr mz nzyrlzngr. Zbz sc tqvzpe mz nzvzmi-krmle olvz rde brma. X kxnzawz-nrbalq nedeng naoliqng x lam pnrdr nangc mz nzaenzli-krdr nzyzlu-krmle. Murde mzli kc navz-ngrmle na-abctrpz, x nalvxpxbzlr naonrx mzli lcdepwz. ");
INSERT INTO ntu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","X mzli kc kxetu rdr navz-ngrmle, kxnzawz kcng na-abrtzng murde nzobq-pz'lilr x nzoliqpeng, kxmule-esz' na-aenzlilr nide krlzbzle aurnrlc o mzli kx boipx-mopwz! X kxetu rdr sa na-abrtzlvztx-kzle nidr. X sa narpibzle kx nawxbuo-kaing mz nzrka-krbzle nadr dakxnzng. ");
INSERT INTO ntu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","40","X nimu na-apuamu kxnzawz lcng. X na-apu-kzamu ncblo kx oliq mz nzrpwa'-krbzle mz kxpnada nztangetr-krbzle ma nyzde, murde trkrlzleu nabznepi lcde. Mz nqmq lcpwz, naoliq-zvz-kzamu. Murde Ninge, Mrlx Leplz, sa nayzlumc mzli kx trpnzu drtwrmu nayzlu-ngrmc.” ");
INSERT INTO ntu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Rpibz Pita kx, “?Kxetu rnge, nzycmne-ebzpxngr lc pime bagr o pibzme mz leplz amrlx?” ");
INSERT INTO ntu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Rpibz Jiszs kx, “?Neke kxnzawz nenge kx brti drtwrnge? Tqycmnetibo nimu x kzdung kz kxnzrmailzng. Murde kzdq kxetu aprcbzle mz kzdq kxnzawz nede mz nzaclve-krde kztedeng x mz nzapu-krde nidr. Zbz sc tqvzpe mz kzdq nrlc. Kxnzawz kx yrplapx x brti drtwr kxetu rde, sa navz-nqblq-zvzle natq kxetu lc. ");
INSERT INTO ntu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mz nzmu-krde lcde, mzli kc navz-ngrm kxetu rde, kxnzawz lc sa na-abrtzlvzle nzale-krde nzwz-krde. ");
INSERT INTO ntu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Da angidrtx lc napibo bamu, kxetu kc sa nayrlqle kxnzawz lc na-aclvebzle dztudeng amrlx. ");
INSERT INTO ntu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“A' trmrlzu kxnzawz lc nzrpi-krde mz drtwrde kx, ‘Kxetu rnge trpnzngr nzvz-ani-krmle.’ Zbz sc tqibrtipe-kzle kztedeng, waile ncblo x olvz. A' nide kc tqmu x tqangqnguti-lzbq-ngrde nzrmnqngr. ");
INSERT INTO ntu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","A' kxetu kc yzlum mz kzdq mzli kx trpnzu drtwr kxnzawz lc. Zbz kxetu kc na-ayrplapx-zlwzle nide x na-apusr-ngrde nide kxtrnzrlxngitiung. ");
INSERT INTO ntu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Kxnzawz kc tqkrlzle me pnz drtwr kxetu rde a' troliqu nzvz-nqblq-krdele nzrviplangr nide nzwrde nakqlu. ");
INSERT INTO ntu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","A' kxnzawz kc trkrlzleu me pnz drtwr kxetu rde, x alele da kx takitrde nzrviplangr nide, nzrviplangr nide nzwrde napipz. Murde leplz kx nzkrlzlr me pnz drtwr Gct, navz-nqblq-zvzlr. X leplz kx ka-nebang Gct zmatq kxetu, narlr-lzbq-zvz-ngrbzng mz nzwz-krde.” ");
INSERT INTO ntu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Rpi-mopwz Jiszs kx, “Vz-ngrmc nztekatr-krnge nrlc mz nyr pnr Gct. X sutipe drtwrnge nzwou-krde mzli ka! A' sc trwouka. ");
INSERT INTO ntu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Murde nzetqkr drtq kxtrka x nzkxpungr kx nakrlzmle ninge sa tqvzbep. X nabznge tqtalvzo zvz mz nzaotikr drtwrnge le. X nzvz-krde la nakrlzbzle mzli kx nakapupx-ngrde! ");
INSERT INTO ntu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mz drtwrmu rpiamu kx vz-ngrmc nzrtwz-krmc nrwx mz leplz mz nrlc ka. A' trtingr, murde vz-ngrmc nzakipxngr kxnzlxngitilr ninge x kxtrnzrlxngitiung. ");
INSERT INTO ntu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mzli kape doa lr ma kxesz' na-akipx-lzbqng, kzdung mz nrlarde nyznge x kzdung mz nrlarde kzble. ");
INSERT INTO ntu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Kxmule-esz' trte, o lxe, o mrlx, o inyx, o mzle-lzbq, o ile-lzbq, o kzdo-lzbq, o lvxbq-lzbq, a' doa lcng amrlx sa na-aki-lzbqng mz nzrlxngitingr ninge.” ");
INSERT INTO ntu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Rpi-kzpz Jiszs mz leplz kcng kx, “Kx namcpeamu kx zbo kc tqtupe, pitx-pnzamu kx, ‘Mwx tewa nadcpe,’ x dctx. ");
INSERT INTO ntu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","X kx naxngibzmu nenq ngr ulu kx nabaopele mrka Israel, sc tqrpipeamu kx, ‘Nrlc la napqpe,’ x nrlc kc tqpqpe. ");
INSERT INTO ntu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Krlzamu nzrmcngr da kx navzpxm mz nibr zbo x nenq. X rpi-kzamu krlzamu da kx nzvztimqng mz Gct, a' pokiaamu. Murde rblxbz bamu nzrkrlzngr nzwzkr Gct mzli ka. ");
INSERT INTO ntu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“A' nakrlzamu nike tubq x aleamu. ");
INSERT INTO ntu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nzmu kzdq ncblo natwzle nim mz kot, tubqti-lzbq-kaiamu mz lrpzki. Murde ma tqaprcbzle nim mz majzstret kc na-aprc-alzupwzle nim mz pulis, x pulis sc tqadwatrpele nim mz presin. ");
INSERT INTO ntu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Murde nzmu kx tqkrlzpebzme la presin trpengr nzdwapx-krme. Murde rblx nzatatr-krme trau kx na-avzpxmle nim. Mz nqmq lcpwz, tekqtr nqmq nr drtwrmu mzli ka, murde ma tqpibz Gct kx navzq mz Hxl, x trpengr nzdwapx-krme.” ");
INSERT INTO ntu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mzli lcde kzdung leplz kcng tzmncng mrkc, nzpibzlr mz Jiszs kx nznibqti ncblo ngr vea neng Paelzt kzdung lr Gzlili, mzli kc tzkalz-ngrbzlr blz krdr mz Gct mrkc Jerusalem. ");
INSERT INTO ntu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Rpibz Jiszs badr kx, “?Nzpnzkr drtwrmu le rpiamu lr Gzlili lcng, alwx ngrdr trka-zlwzng myaszpxle lr Gzlili kc-kzng? ");
INSERT INTO ntu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mwx trtingr! A' napibo bamu, nzmu kx trtekqtrwamuu la nqmq nr drtwrmu mz alwx ngrmu, Gct sa naodati-alole nimu amrlx ngrmu mz Mzli Kxmatq kc na-ayzlu-ngrbzle da mz leplz. ");
INSERT INTO ntu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nadctipx drtwrmu ncblo kcng nzpnu-esz'-nrade-rtqmz (18) tqtabqlvzo ma kc tqtupx wq, esotrpz mz nabzde Siloam, mrkc Jerusalem. ?Nzpnzkr drtwrmu le nidr kx nztrkatx-zlwzng mz nzobqkr Gct nzmyaszpxlr leplz kc-kzng tzmncng Jerusalem? ");
INSERT INTO ntu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Trtingr! A' napibo bamu kx nzmu kx tresablqtiwamuu la alwx ngrmung, Gct sa na-ayrplapxle nimu mz nzavztr-krde nimu amrlx ngrmu mz Hxl. ");
INSERT INTO ntu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","“Murde nimu lr Israel apuamu nc fiki kc tqpeti Gct. Petile nc fiki mz drtc' kxmrlz mz nrlanc nyzde. Nounc kc kx etupele, sc tqvz-zvzpebz mz nzrtangrtr-krde elr nrade, a' trpnzngr da kx tqmcle. ");
INSERT INTO ntu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Zbz sc tqrpipebzle mz ncblo kc tqaclvebzle nrlanc nyzde kx, ‘Yiz tq vztipemc, tqrtangrtrx nra fiki mz nou fiki lc, a' trgalr kx mcx. Lakitxope nounc la, murde trmrlzu nztu-nrbalq-krde mz drtc' nyznge.’ ");
INSERT INTO ntu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","A' rpibz ncblo kc tqaclve nrlanc kc kx, ‘Natutitx-moule yiz naesz', kx Kxetu. Murde mz nibrde sa nayabo-ngalebo x sc tqyrlqtiopebo da kx na-ayrlvile nide. ");
INSERT INTO ntu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Zbz nzmu nounc nyzm kx tqpale mz yiz lc navzom, e sa tqmrlz. A' nzmu kx trpnz-ngrde, e sc tqlakiopeq x tqangcpeq.’” ");
INSERT INTO ntu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mz kzdq Satde, Sabat nyzdr lr Jiu, Jiszs alvztr mz kzdq mangr-nzkrka'ngr. ");
INSERT INTO ntu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kzdq olvz mnc mrkc kx mncpx-ngrm drka' kc tqayangrngale nide. Yrngzpu txpwz mz nzvzne-krde, twztipelele yiz nzpnu-esz'-nrade-rtqmz (18). ");
INSERT INTO ntu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kx mcpxbz Jiszs nide, rpibzle kx, “Olvz e, vzm. Drtqm opxpe mz zvetq la!” ");
INSERT INTO ntu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","X maletxtrpzle nide, x mzli kcpwz atwztqtxlz-lzbq pnz x sc tqglqpxpele Gct. ");
INSERT INTO ntu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","A' kxaclve mangr-nzkrka'ngr kc drtwrde ngyatx kx Jiszs kc tqamrlz doa mz Sabat. X sc tqrpipebzle mz leplz kcng kx, “Zbq esz'mz kx nawzti mz wiki kxesz'. Vzmamu mz nzamrlzngr nimu mz kzdq zbq lcdeng. A' bzkq ngi mz Sabat!” ");
INSERT INTO ntu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","A' Kxetu rpibzle badr kx, “Nimu leplz kx narpi-ngrbz kx rlxngitiamu! Nimu amrlx ngrmu wzamu mz Sabat mz nzyokaepx-krmu kzu nemung o dcngki nemung me tu-ngrdr x sc tqvzmipxpeamu me na-amnq-ngrnamule lue! Murde mz drtwrmu rpiamu mrlz nzalengr nzwzngr lc, nzaclvengr animol mz Sabat. ");
INSERT INTO ntu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","A' olvz lc nide neidu lr Ebraam x lolvztipe Setzn le yiz nzpnu-esz'-nrade-rtqmz (18). ?Memule nzmu trnzarlapxu nide mz nabz Sabat? Murde myapxbz nzarlapxngr olvz lc mz Sabat, myaszpxle animol.” ");
INSERT INTO ntu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kx pitxbzle natq lc, krkcng tzpxtxpx-ngrdr nide drtqdr myatxlz-pnzm. A' zbo ngr leplz lcng tzabrtzlvzlr da kcng tqmrlzvxi tqaleleng. ");
INSERT INTO ntu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jiszs sc tqrpipebzle kx, “?Nzkqlukr leplz kcng namnclzbzng mz Gct mz nzngini-krde King rdr apule nike? ?Nzycmne-ebzpxngr kznike takitrde nayokaetipx-ngrbole? ");
INSERT INTO ntu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Apule rtq nc seri, kx peti ncblo mz nrlanc nyzde. Yrlvzlzm x sc tqngipe kzdq nounc, x utc kxkqlung nzmncng mz nrladeng mz nzama-krdr elr.” ");
INSERT INTO ntu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jiszs rpi-mopwzle kx, “?Nzetunepxkr Nrpakxmrlz kx Gct sa tqvectrpemle leplz bade mz nzngini-krde King rdr apule nike? ");
INSERT INTO ntu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Apule yisti kxpipz kx oti kzdq olvz, sc tqayabemipele flawa mz kzdq dis kxetu. Mz nibrde yisti kc sc tqapwzpupele flawa kc.” ");
INSERT INTO ntu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Mz nibrde Jiszs kc tqvznepebz Jerusalem. X mz nzvzki-krbzle mz kzdung taon x mztea kcng, sc tqalvztrpele lr mrlcdeng. ");
INSERT INTO ntu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kzdq ncblo veabz bade, rpibzle kx, “?Kxetu, doa kxpipz keng narlatxpxpwzng x navzng Heven?” Mz nzayzlu-krbz Jiszs le, rpi-alzupwzle mz leplz kcng kx, ");
INSERT INTO ntu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Naonrx esz'txu kx topwzne kx naprtrngr Heven. Mz nzmu-krde lcde, namnclzbzmu mz Gct mzli kape. A' napibo bamu, leplz nakqlung na-abzlr nzprtrngr Heven kalr, a' trpnzngr lc nzprtr-krdr elr. ");
INSERT INTO ntu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Murde mzli kc navzm kalr, Gct sa na-apqbrbzle naonrx ngr Heven badr. X natutrpzng mz naonrx x na-abctrpzng mz naonrx mz nzrpi-krbzlr kx, ‘Lvxpxm bagr naonrx, kx Kxetu!’ A' sa narpipxbo badr kx, ‘Trkrlzwxu nimu! Trpnzngr nzlvxpx-krbo naonrx.’ ");
INSERT INTO ntu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","X sa narpitrpzlr kx, ‘A' krlzq nigr murde muku x alvztr-kzq mz mztea nyzgr!’ ");
INSERT INTO ntu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","A' narpi-mopwo kx, ‘Nimu leplz kxdrka'-ngrng amrlx, dwaszpeamu ninge!’ ");
INSERT INTO ntu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","X mzli kc namc-ngrdr Ebraam, Aesak, Jekop x profet kcng amrlx nzmncpx-krmlr Heven, nayrning. X nqngidr namadqlr mz drtwr kxngya murde sa namapulrpxngr Gct nidr! ");
INSERT INTO ntu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kxmule-esz', a' leplz kxkqlu nayrkrkimlr mrkang kqlu mz nrlc. Lr Jiu badr leplz kxtrngiulrJiu navz-lxblrmqng mz nzmungr kc etu mzli kc nayzlu-ngrmc mz nzngini-krnge King. ");
INSERT INTO ntu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","A' kzdung kxnzmyapxbzng mz nrlc ka, sa nanginidr leplz txneng mz nrlc kc navzm. X kzdung kxnznginidr leplz txneng mz nrlc ka, sa nanginidr leplz kxnzmyapxbzng mz nrlc kc navzm.” ");
INSERT INTO ntu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mzli lcpwz kzdung Farzsi nzvzmqng mz Jiszs, sc tzrpipebzlr bade kx, “Rlaszpe mrka x vzkipe mz kzdq kz nrlc. Murde rpi King Herot nanibqle nim.” ");
INSERT INTO ntu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","A' sc tqrpipebz Jiszs badr kx, “Vzbzmu mz Herot la tqngi ncblo kxayo, x pibzmu kx, ‘Mzbq ka tqrmaszlrpx-ngrne drka' x tqamrlz-moux leplz. X nawai-kzle mz kzdung mou zbq. X mzli trnaboiu sc tqayrkrpxpex nzwz-krnge.’ ");
INSERT INTO ntu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kxmule-esz', a' navznebo ye Jerusalem mzbq ka x kalrla x mzbq kcng mou. Murde trtakitrdeu nzrnibqngr profet mrkzble, a' nanibqpwz Jerusalem. ");
INSERT INTO ntu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Kosae lr Jerusalem! Nibqtiamu profet neng Gct x vaebqtiamu menrpa kcng tqatwzlr-ngrmle bamu! Kxmule-esz' aodu-zvzx nimu x mzli kqlu kx rpi-ngrne na-apubo bamu kio kx wxbulvzole neideng, a' tr-rlr-lzbq-ngrpwa'muu bange. ");
INSERT INTO ntu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nakxmupele lape! Murde Gct sa nartxmle nibrde bamu mz nzngini-krmu leplz nedeng. Napibo bamu, trpengr nzmc-krmu ninge nakrlzbzle Mzli Kxmatq kc navzm x narpi-ngrnamu kx, ‘Yawe, glqlzkr Kxnzmcpx kc tqvzm mz drtqm.’” ");
INSERT INTO ntu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kzdq Sabat, Jiszs nzaveatim mz nzmungr mz ma nyz kzdq kxetu rdr Farzsi. X mzli lc Farzsi lcng nzaukzti-angidrpepwzlr Jiszs, murde nzrpilr namctrpzlr du da kx alele kx napipxlr nzvz-rbr-krde. ");
INSERT INTO ntu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mzli kc tqmnc-ngrpwzle brma, kzdq ncblo kx nanycdeng x mqdeng vaoti vzm mz Jiszs. ");
INSERT INTO ntu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Rpibz Jiszs mz kxnzalvztrng mz Lou sc Mosis x Farzsi kcng kx, “?Rlrpxngr Lou sc Mosis nzamrlzngr kxnzyagoxng mz Sabat o trtingr?” ");
INSERT INTO ntu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","A' nzmnc-lrpitxng. Zbz maletrpz Jiszs ncblo kc, amrlzle x sc tqatwzlrpe-ngrde. ");
INSERT INTO ntu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sc tqrpipebzle kx, “Nzmu kzdq nimu nede kc doa ncblo o kzu kx tatxo mz kzdq lrpao mz Sabat, e navectxlz-pnzmle mzli lapwz kxmule-esz' mz drtwrmu xpqbrlr-ngrde lou ngr Sabat!” ");
INSERT INTO ntu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","A' trnzayzlupwzlru natqde. Nzkrlzlr kx ycmne angidr, a' drtwrdr ngyatx, murde nzycmne-krde tqamatile nqmq krdr. ");
INSERT INTO ntu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Mz nzmungr lc, Jiszs krlztrpebzle kx kzdung ncblo nzmcpxlr mrkcng tqmrlzpxbzng tzwxbungr. Zbz sc tqyapwxtipebzle nzycmne-ebzpxngr lc. ");
INSERT INTO ntu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","Sc tqrpipebzle kx, “Nzmu kzdq ncblo aveatile nim mz nzmungr mz nzyrlzngr, bzkq wxbuoq me nzwxbungr kx nzmrlzpxbzng. Murde kzdq mzli doa kx myaszpxle nim nzaveati kz. X ncblo kc tqaveatile nimu rlirmu narpibzle bam kx, ‘Kztem, nawxbubz mrla.’ Zbz drtqm kc tqmyape x sc tqwxbunetr-rlrupebzme me siga. ");
INSERT INTO ntu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","A' mzli kx nzaveati-ngrm, vz x wxbu mrkc tqyctr-rlrupwz me siga, murde mrlx kc tqaveatile nim navzm bam x narpibzle kx, ‘Mzlenge, esolzm, me brngz kxpipz.’ X sc tqamatqpebzle nim mz mz leplz kcng tqaveati-kzleng. ");
INSERT INTO ntu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Murde doa kx amyalz-lzbq mzli ka, sa na-avzo Gct nide yu. A' kx avzo-lzbq mzli ka, sa na-amyalz Gct nide.” ");
INSERT INTO ntu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Zbz Jiszs kc tqrpipebzle mz ncblo kc tqrwzngr nzmungr kc kx, “Nzmu kx tqrwz-ngrn nzmungr, bzkq aveati-txpwzme leplz kx na-ayzlu-mopwzlr bam. Murde mz nzale-krm da lc, twzpeq mz nrlc ka da kxmrlz mz nzale-krm lc da kxmrlz. ");
INSERT INTO ntu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","A' mzli kznike rwz-ngrn nzmungr, aveati kz leplz kx trpnzngr scdr zmatq, kx trpnzngr scdr da, kx mqde bz, kx nanycde bxplo, x kx mzte kc. ");
INSERT INTO ntu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kxmule-esz' leplz lcng trnzkrlzlru nzayzlu-mou-krbzlr bam, a' Gct sa na-amrlzle nim mz nzayzlu-krmle da kxmrlz lc kalr, mzli kc leplz kxnztubqng natulz-ngr-moplr mz nzbzngr.” ");
INSERT INTO ntu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Zbz kzdq ncblo mz nzmungr lc sc tqrpipebzle mz Jiszs kx, “Sa namrlzbz mz leplz kx naprtrpzng mz nzmungr mzli kc Kxnzmcpx nayzlu-ngrmle mz nzngini-krde King.” ");
INSERT INTO ntu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Zbz Jiszs kc tqyapwxtipebzle be lc mz nzaelwapx-krbzle badr kx leplz kxtrngiulrJiu naprtr-kzng Heven. Sc tqrpipebzle badr kx, “Kzdq kxetu wz-ngrde kc nzmungr kxetu. Aveatile ncblo nzkqlung. ");
INSERT INTO ntu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","X mzli kc namupengr, atwzlr-ngrbzle kxnzawz nede kx napibzle badr kx navzpemqng murde da amrlx mrlzpe. ");
INSERT INTO ntu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","A' nidr amrlx ngrdr sc tzrpipebzng da kx aotrleng nidr trnzvz-krpwzlru. Ncblo kc kai rpibzle kx, ‘Xpex kc drtc' kx trmckalx, x navzpex x naoklatipex. Pibz kx trpengr nzvz-krbo.’ ");
INSERT INTO ntu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Kzdq kz rpibzle kx, ‘Xpex kzu nqvi nzlvqn kx trmckalx, naokatrlr ninge mz nzwzngr. A' navzpex na-abzpxpexng. Pibz kx trpengr nzvz-krbo.’ ");
INSERT INTO ntu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Kzdq kz mou rpibzle kx, ‘Sa tqyrlz-atex. X mrlc tqycngr da trpengr nzvz-krbo.’ ");
INSERT INTO ntu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Kxnzawz lc sc tqyzlupe x pipebzle da lcng mz kxetu rde. Zbz kxetu kc drtwrde kc tqngyape x sc tqrpipebzle mz kxnzawz nede kx, ‘Ngrlrtxpx-anipwz mz lrpzki kcng tqetu x krkcng tqtopwz. Vzmim krkcng trpnzngr scdrng da, krkcng mqdr tqbz, krkcng tzbxplong, x krkcng mztr tqkcba.’ ");
INSERT INTO ntu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Vztx x yzlum, sc tqrpipebzle kx, ‘Natqm twzpex, kx kxetu. A' me namncngr la tqkqlube.’ ");
INSERT INTO ntu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Zbz kxetu kc sc tqrpipebzle bade kx, ‘Vzpx mz lrpzki kcng tqyctrp mz nibr nrlc x rvzmitim leplz x lr mrkzbleng nayrkrtrpqng, murde ma nyznge kc tqetu nayrbupxm. ");
INSERT INTO ntu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","A' napibo bamu, kx ncblo kcng tzaveati kai tzpxtxpxng, trpnzngr nidr kx nabxtr naodr dakxnzng kcng tqoliqtix!’” ");
INSERT INTO ntu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mz nibrde, sc tqvznepe-mopwz mz nzvz-krde kc Jerusalem. Mzli lc zbo ngr leplz kxetu sc tzyrkrng badr. O-lxlvrtxbz, sc tqrpipebzle kx, ");
INSERT INTO ntu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Doa kx vzm bange namrlzti nivz lrde ninge namyaszpxle kxnginideng, kx apule trtede, lxede, olvz rde o ncblo ngrde, mzledeng, iledeng, x doa nedeng. X bzkq rlr-ngrbzle nzrpwa'-krbzlr bade nzvz-nqblq-angidr-krde ninge. X nzmrlzti-krde ninge namyaszpx-kzle nide esz'-krde. ");
INSERT INTO ntu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Murde doa kx trglqleu kros ngrde mz nzo-zli-krde lrpzki rnge, trvz-nqblq-angidrleu ninge.” ");
INSERT INTO ntu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Zbz Jiszs pipx-moule nzycmne-ebzpxngr tq, mz nzaelwapx-krde kx doa na-aoti kai drtwrde nike na-alele mz nzvz-nqblq-krde nide. Zbz napnzpe drtwrde kx na-alele o trtingr. Zbz sc tqrpipebzle kx, “Nzmu kzdq nimu aoti drtwrde nzrwztingr ma, e na-aoti kai drtwrde nikeng navztr mz nzrwztingr ma kc, kx takitrpede o trgalr. ");
INSERT INTO ntu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Murde nzmu kx trtakitrdeu, e rblx nzyrkrpx-krde ma kc. X leplz sa naxtrnga-ngrdr nide. ");
INSERT INTO ntu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Narpilr kx, ‘Ncblo ka nzwz-krde ngi nctengr!’” ");
INSERT INTO ntu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Mz nzycmne-ebzpxngr krali, rpi-mopwz Jiszs kx, “Nzmu kzdq king prmipxle ncblo siu-nzpnu-esz' (10,000) mz nzota-krdr mz kzdq kz king kx vzmi-alzuple nede ncblo siu-nzpnu-li (20,000), na-aoti kai drtwrde nzmu nzxplr-krde takitrde nzaovxio-krde king kc o trtingr. ");
INSERT INTO ntu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","X nzmu kx trtakitrdeu, e na-atwzlr-kai-ngrbzle kzdung kxnzetung mz nzrmcti-krdr king kc mzli kc tqmncbe-ngrmle rlru, kx narlxtimle du da kx na-alebzle murde nrwx nayc. ");
INSERT INTO ntu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mz nqmq lcpwz, mrlx kx navz-nqblq-angidrpele ninge, narlaszle doa x da amrlx kx nzlolvzolr nide.” ");
INSERT INTO ntu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Zbz pibzle nzycmne-ebzpxngr kratq mz nzrpi-krbzle kx, “Dcpiz ngi da kxmrlz. A' nzmu nilwzde kx tqmrbrle, trpengr nzamrlz-moungr da. ");
INSERT INTO ntu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","X trpnzngr da kx takitrde, kxmule-esz' nzayabemi drtc' o nzyrlqmi dcvi kxmibi kx na-amrlzle drtc'. A' takitxtrpwzle nzrtctxngr. Doa kx yrplapx, na-abzle nztwz-krde drtwr ngr natq lc.” ");
INSERT INTO ntu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ncblo kcng tzatakqting takes x leplz kc-kzng tzmncng mz alwx nzkqlung, tzlalztq-zvzbzng mz Jiszs. ");
INSERT INTO ntu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","A' Farzsi x kxnzalvztrng mz Lou sc Mosis kcng drtwrdr tqlctrpebz mz Jiszs. Nzrpipelr kx, “Mz Lou sc Mosis, mrlx lc batrpzle trnztakitr-krdeu nide nzprtrngr mz nzangiongr murde aodu-zvzle leplz kcng tzaleng alwx mz nzmu-krdr badr!” ");
INSERT INTO ntu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Zbz yapwxtibz Jiszs nzycmne-ebzpxngr lc mz nzaelwapx-krbzle kx Gct yc mz drtwrde leplz kcng tzmnc-mrbrng. ");
INSERT INTO ntu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Rpibzle kx, “?Nzmu kzdq nimu kx nede sip trtqki-esz' (100) x mrbr esz', nike na-alele? Nzmu amncle krkcng nzpnu-rpwxmz-nrade-rpwxmz (99) me namnc-zpwx-ngrdr. X sc tqvzpe mz nzrtangrti-krde krkc tqmrbr mz nzmc-zpwx-krdele. ");
INSERT INTO ntu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kx mclele kc, abrtz zlwz x glqlzle mz nabxde. X sc tqglqpe-mople mrkc tqamnc-ngrde sip nedeng. ");
INSERT INTO ntu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Mzli kc tqvzpe-ngrde brma, sc tqkqle-lxblrpeleng kxnginideng, kxnzesonetrpzng bade, x mzledeng kxnzmrlzti-lzbqng badr, x sc tqrpipebzle badr kx, ‘Abrtz-zlwzpex murde mctxpex sip nenge kc tqmrbr. Namulvzpeku!’ ");
INSERT INTO ntu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mz nqmq kcpwz, napibo bamu, Gct nzabrtz-krde etu mrkc Heven mzli kx kzdq doa kxale alwx tekqtr-ngrde nqmq nr drtwrde. Nzabrtzngr lc myaszpxle nzabrtzlvz-krde leplz kx nzpnu-rpwxmz-nrade-rpwxmz (99) kx trtakitrpedeu nztekqtr-krdr nqmq nr drtwrdr murde nztubq-angidrpeng.” ");
INSERT INTO ntu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jiszs yapwxti-mopwzle kc nzycmne-ebzpxngr. Rpibzle kx, “?E nzmu narpingr kx kzdq olvz kx rngisc dola kx nzpnu-esz', amrbrle esz', nike na-alele? Nzmu yakatrle kzdq lam x amilxpqtile ma nyzde x obqlvxti-angidrle nrlc amrlx namc-zpwxle. ");
INSERT INTO ntu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Mzli kx mc-ngrdele, kqleleng kxnginideng, kxnzesonetrpzng bade, x iledeng kxnzmrlzti-lzbqng badr, x sc tqrpipebzle badr kx, ‘Abrtztxpex murde mcpex trau kc tqamrbrx. Namulvzpeku!’ ");
INSERT INTO ntu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mz nqmq kcpwz, napibo bamu, Gct nidr badr enjrl nedeng nzabrtzlvzlr kzdq doa kxale alwx kx tekqtrle nqmq nr drtwrde.” ");
INSERT INTO ntu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jiszs yapwxtibzle kc be ngr mrlx kcng nzling tzmnc-mrbrng x trtedr. Sc tqrpipebzle kx, “Kzdq kc ncblo kx mrlxde li. ");
INSERT INTO ntu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Krkc tqtopwzbz pibqtxde trtede mz nzrpi-krbzle bade kx, ‘Trte, rblxtxpem bange nzaenzli-krnge nzbz-krm. A' aprcpem bange mzli ka da kx nangi scnge kalr.’ Kxmule-esz', a' ncblo kc sc tqaotipe drtwrde nzaki-krbzle dztudeng mz mzlir mrlxde kcng nzling. X sc tqkapebzle krsc mrlxde kc tqtopwzbz. ");
INSERT INTO ntu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“A' mzli trboiu, mrlx kc tqtopwzbz amwatxde dztudeng. Twzpele trau scdeng, sc tqrlaszpele brma, vzkipele kc kzdq mrkzble kx ycm rlru. A' trau scde ayrkrtx-nrbalqle mrlcde mz nzrtrngz-krbzle alwx. ");
INSERT INTO ntu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Amrbrtxde da scdeng amrlx. Zbz kzdq dzbi kxtrka tao, talvzpxle mrlcde. X nide kx tqmncle kc, trtxpengr da kx namnc-xglele. ");
INSERT INTO ntu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Zbz sc tqyrnitrpebz nzwzngr mz kzdq doa lr mrkzble kc. Zbz alele nzwzngr kx batrpzle trnztakitr-krdeu nide, murde aclvele poi mz nabxbz. ");
INSERT INTO ntu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nelzde brtaletx-atwrnrpengr, a' trpnzngr kxrkale nide dakxnzng. X mzli kc tqapu-ngrde poi, tqrpile nangqtx-kzle dakxnzng nadr. ");
INSERT INTO ntu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Zbz mz nzngqngu-krde kc, drtwrde kc tqopxpe. X sc tqdctipxpe drtwrde ncblo kcng amrlx tqamcti trtede. Tzrnginating dakxnzng kxkqlu, a' nide nabzpe-ngrde nade. ");
INSERT INTO ntu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","X sc tqrpipele kx, navztx-anipebo mz trtenge x narpibo bade kx, ‘Trte, atrkatix nim x atrkati-kzx Gct. ");
INSERT INTO ntu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Bzkq apusrnepe-ngrn ninge mrlxm, a' nanginipenge kxnzawz nem.’ ");
INSERT INTO ntu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Zbz sc tqvzpebz mz trtede. “Mzli lcde trtede tqaenzli-zvzle nide, x sc tqmcpebzle nide mzli kc tqvzbe-ngrmle rlru mz ma nyzdr. X sc tqvopebz mz nzabrtzlvz-krdele. Sc tqkaplzpele x tcngipele nide, murde ycpengr drtwrde nide. ");
INSERT INTO ntu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Rpibz mrlxde kc kx, ‘Trte, atrkatix nim x atrkati-kzx Gct. Bzkq apusrnepe-ngrm ninge mrlxm.’ ");
INSERT INTO ntu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","A' trte kc kqlebzle kxnzawz-nrbalq nedeng, rpibzle kx, ‘Ngrlr-txpwzmu! Twzmamu nzkq kc tqmrlztxpxbz x akq-ngrnamu nide. Aotrpzmu dq ring scnge mz nratoki r mqde, x yrlqtrpzmu sadol mz nanycdeng. ");
INSERT INTO ntu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Otiamu nei kzu kc tzapulvzti mz mzli r nzrbilvzngr. Vzmimamu x nibqamu murde namulvzku nide mz nzabrtz-krgu. ");
INSERT INTO ntu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Murde mrlxnge lc apule kx bzszpele ninge, a' sa tqlupe mou. Mrbrpe, a' mzli ka dcpxpe-mop.’ Zbz sc tzmulvzpelr. ");
INSERT INTO ntu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Mzli lc mrlxde kc tqetubz sc tqwztrp mz lclr da nyzdr. A' mz nzyzlu-krmle, mzli kc tqesotrpe-ngrbzle ma kc, xlrpebzle nzayrpungr da x nzelangr. ");
INSERT INTO ntu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kqlepebzle kzdq kxnzawz kc x sc tqveatipebzle bade kx, ‘?Nike tzale?’ ");
INSERT INTO ntu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Rpibzle kx, ‘Mzlem yzlupem brma. X trtem pimle bagr kx nanibqbzkr nei kzu kc tzapulvzti, murde mzlem lube x yzlupe-mop.’ ");
INSERT INTO ntu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Mrlxde kc tqetubz drtwrde kx ngyale pxtxpx-ngrde nzdwatr-ngrbz brma. Zbz trtede kc tqdwapxpebz yz, sc tqtamitipele mrlxde kx nadwatrpz brma x naipqle mzlede. ");
INSERT INTO ntu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","A' rpibzle mz trtede kx, ‘Obq ena, mz yiz lcng kqlu nzwztr-krbo bam aputxtrpo kxnzawz-nrbalq. X trpnzngr mzli kx atao-ngrbo natqmqng. A' trpnzngr da kx kame bange, kxmule-esz' gout kx esz'txu nangqkr badr kztengeng. ");
INSERT INTO ntu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","A' mrlxm lc angi-brmrda-ngrbzle dztum mz srlx kxkqlu. X kx yzlumle brma nibqbzme nei kzu kc tqyrlvztxpxbz! Da lc tqaleq trarsakrlrleu nigr rlilrgr!’ ");
INSERT INTO ntu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","A' rpibz trtede kx, ‘Mrlxnge, mnc-zvzki x da amrlx kx ngiscngeng scmqng, murde mzlem twzpele krscdeng. Yctxtrpepwz bam nzale-krm da kx suti drtwrm. ");
INSERT INTO ntu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","A' na-aleku kzdq nzmungr x na-abrtzku, murde mzlem apule kx bzszpele nigi, a' mzli ka lupe mou. Mrbrpe, a' mzli ka dcpxpe-mop.’” ");
INSERT INTO ntu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Zbz rpibz Jiszs mz ncblo nedeng kx, “Kzdq kc ncblo kxrngisc, nede kc kxnzawz kx aclvebzle dztudeng x trau scdeng amrlx. A' kzdung leplz nzpipxlr kx tqangi-brmrda-ngrbzle dztu kxetu rde. ");
INSERT INTO ntu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Zbz sc tqaveatipe kxetu kc kxnzawz nede. Sc tqrpipebzle kx, ‘?Natq lc tzpingr nim, da zpwx? Yrpxbz pepz kx yro-ngrn trau r nzaclve-krm dztungeng, x sc tqkapeme. Murde trpengr nzaclve-krm dztungeng.’ ");
INSERT INTO ntu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Rpipe kc tzawz mz nide esz'-krde kx, ‘Kxetu rnge sa na-ayrkrpxpebzle ninge mz nzwz-krnge. ?Nike nawaipex? Trxplrnewxu mz nzwzngr kxmrlepu. X drtqnge myane kz nzrlx-zvzngr trau. ");
INSERT INTO ntu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","O! Krlzpex da kx na-alex. Sa na-avzobo kaon scdr leplz kcng tzrlxbzng da mz kxetu rnge. X sa na-abrtzlvzlr ninge mz nibr kxetu lc nzayrkrpx-krbzle ninge mz nzwz-krnge.’ ");
INSERT INTO ntu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Zbz sc tqaveatipele leplz kcng amrlx tzkaonbzng mz kxetu rde. Rpibzle mz krkc kai kx, ‘Ngi da kxmrlz nzaolvzti-krgi da mz nike kaontibzme mz kxetu rnge. ?Tqlvr kx nzyro mz pepz scm?’ ");
INSERT INTO ntu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Rpibzle kx, ‘Galon ngr tolo trtqki-rtqmz (800).’ Rpibz kxnzawz kc tqaclve kx, ‘Na-avzopeki kaon scm. A' pepz scm kzble se. Wxbuo ani x yrtxopwz elr trtqki-napwx (400), murde naxpe-txpwzme krlc.’ ");
INSERT INTO ntu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Rpibzle mz kzdq mou kx, ‘?X nim, tqlvr kx kaonqtiq?’ Rpibzle kx, ‘Bxli r wit siu-esz' (1000).’ Rpibz kc tqaclve kx, ‘Pepz scm se. Tekqtxtrpwz trtqki-nartqmz (800).’ ");
INSERT INTO ntu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Kxetu r kc tzawz tqangqngutitr glqtxpxle nide mz nzobqpx-kai-krde. X yapwxti-ngrbo be lc murde mzli kang kqlu kxtrnzrlxngitiung nzmyaszpxlr kxnzrlxngiting. Murde nzavzlr trau scdr mz nzrvectr-krmlr leplz badr, murde na-abrtzlvzlr nidr. A' mzli kang kqlu kxnzrlxngiting trnzavzlru trau scdr mz nzrvectr-krmlr leplz mz Gct.” ");
INSERT INTO ntu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“A' napi-mopwo bamu kx na-avzamu dztumu mz nzokatrngr leplz mz nrlc ka, murde Gct na-abrtzlvzle nimu x mzli kc trnarmalepe-ngrwamuu trau mz nzbzpe-krmu, naprtramu mz nzlungr kxboi. ");
INSERT INTO ntu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Murde doa kx atutrle nzwz-krde mz da kxtopwz, sa na-atutr-kzle nzwz-krde mz da kxetu. A' doa kx angqngutitr mz nzwzngr kxtopwz, sa na-angqngutitr kz mz nzwzngr kxetu. ");
INSERT INTO ntu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mz nqmq lcpwz, nzmu kx trawzq la dztumqng mz nzokatr-krm leplz mz nrlc ka, trpnzngr nzrka-krbz Gct nzrkrlzngr murde naokatrq kztemqng mz nzvz-nqblq-krdr nide. ");
INSERT INTO ntu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","X nzmu kx traclve-angidrwq dztu Gct mz nrlc ka, trpnzngr nzabrtzlvz-krde nqmq krm x trnatwzwq da kxmrlz angidr mrkc Heven. ");
INSERT INTO ntu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Rblx doa nzwztr-krbzle mz kxetu kxli mz mzli kxesz'. Murde sa napqtitrpe drtwrde kzdq, x namatitrpe drtwrde kzdq kz, mz nzrvz-nqblq-ngrng. Mz nqmq lcpwz, rblx nzwztr-krbzmu mz Gct x mz nzrngiscngr da.” ");
INSERT INTO ntu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farzsi kcng nzxlrbzlr da lcng amrlx, sc tzxtrngalvztrpe-ngrdr Jiszs. Murde nzmrlz zlwz badr trau x nzrpilr kx Gct amrlzle kxnztubqng. X mz nzrngisc-krdr da aelwapx-ngrde kx amrlz Gct nidr. ");
INSERT INTO ntu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","A' rpibz Jiszs badr kx, “Kxmule-esz' mz nzobqkr leplz nimu leplz kxnztubqng, a' Gct krlzle da kx tqyctipxm mz nabzmu. X kxmule-esz' nzpnzkr drtwr leplz le kx myapxbzmu, a' Gct obqszole nimu x angyabzmu drtwrde. ");
INSERT INTO ntu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Murde natq ngr Lou sc Mosis x nzryrkr profet kcng bqnc nzryapwxng krlzmle mzli kc Jon kc tqawrkxtr tqbzpe-ngrde. Abzo mzli lcde, rpi Nrpakxmrlz kx Gct sa tqvectrpemle leplz bade mz nzngini-krde King rdr. X leplz kang kqlu drtwrdr pqtr mz nzngini-krde King rdr, nztwz-anilr x nzlolvz-amqngilr lrpzki rde mz nzarlapx-krde nidr. ");
INSERT INTO ntu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kxmule-esz', a' Lou sc Mosis x nzryrkr profet kcng bqnc sa tqngibeng natq Gct. X trpnzngr kx nayrlqtxpx, a' natq Gct amrlx sa na-atutr. ");
INSERT INTO ntu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Mz nzmu-krde lcde, ncblo kx axtxde olvz rde x yrlzti-moule kc olvz kzble, taope mz alwx ngr nzrmwimingr doa kx trngiu krnalzde. Murde olvz krali lc trngiu olvz rde angidr mz nzobqkr Gct. X ncblo kx ryrlzti olvz lcde, tao kz mz alwx lcdepwz.” ");
INSERT INTO ntu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Zbz Jiszs yapwxtibzle kzdq be, rpibzle kx, “Kzdq kc ncblo kx rngisc, pxi txpwz lrpz kxmrlzvxi. X mz zbq kang kqlu mu txpwz dakxnzng kx mrlztxpxbz kx trau rde etu nzxpengr. ");
INSERT INTO ntu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Mzli lc mnc kz kc ncblo kx trpnzngr scde da, drtqde Lasarus. Ncblo lc ngabq kxsqki, tqyrbqne zvz mz naonrx ngr nabxbz ngr ma nyz ncblo kc tqrngisc. ");
INSERT INTO ntu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Murde nzpnzkr drtwrde le rpile kx namune muli dakxnzng kx taneom mz tebol nyz ncblo kc tqrngisc. X kuli nzvzmqng tzmanidutibzlr kxsqki rdeng. A' ncblo kc tqrngisc trokatrleu nide. ");
INSERT INTO ntu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Zbz ncblo kc tr-rngiscu sc tqkrlzpebzle mzli r nzbz-krde. X mqngrde sc tqglqpebz enjrl mrkc tqmncngr Ebraam mz nzmungr kc etu mrkc Heven. Zbz mrlx kc tqrngisc sc tqbzpe kz x sc tzyrtzmqpe. ");
INSERT INTO ntu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","A' vztr mz Hxl x drtqde etqtx atwrnrngr. Zbz obqlzbz x mclzbzle Ebraam mrkc Heven x Lasarus sc tqmnctrpz mz nrlarde. ");
INSERT INTO ntu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Zbz sc tqkqlzpebz, rpibzle kx, ‘Trte Ebraam! Nayc mz drtwrm ninge! X atwzlr-ngrm Lasarus naleole nratoki r mqde mz lue x na-abaobzle nalzpqnge. Murde nyr ka apqtx-zvzpemle drtqnge.’ ");
INSERT INTO ntu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“A' rpibz Ebraam kx, ‘Nadctipx drtwrm, kx mrlxnge, mzli kc tqlu-ngrn da kcng amrlx tqmrlzti nzkabz bam. X Lasarus twztibzle da kcng tqtrkati. A' mzli ka, sa tqabrtzlvzpele nzmnc-krde mrka. X drtqm la tqetq-alzupe. ");
INSERT INTO ntu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","X kzdq la gq kx vzo la tqvivx mz mzlirgu, murde krkcng tzrpilr narkawicbzng bamu mz nzokatr-krdr nimu ma tzwailr, x krkcng tzmncng mrla ma tzvzo-kzpqng bagr!’ ");
INSERT INTO ntu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Zbz mrlx kc tqrngisc rpibzle kx, ‘Kx tqmule la, kx trte, atwzlr-ngrbz Lasarus mz ma nyz trtenge. ");
INSERT INTO ntu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Murde mzlenge nzlvqn sa tzmncng elr. Atwzlr-ngrbz nide badr mz nzpi-krbzle badr bzkq nzvz-pnzmqng mrka tqetq ngr drtq. A' natekqtr-pnzlr nqmq nr drtwrdr mzli ka tzlube-ngrdr mz nrlc.’ ");
INSERT INTO ntu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“A' rpibz Ebraam kx, ‘Mzlemqng lang, nzryrkr Mosis x profet kcng tqyc mz Nzryrngrkxtr sa tqycbz badr, narkabzng badr natq. Mzlemqng nalalztqbzng mz kxnzrlwxng x nalxngitilr da kx napibzlr badr.’ ");
INSERT INTO ntu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Rpibz ncblo kc tqrngisc bade kx, ‘Krla trtakitrdeu, kx trte Ebraam! A' nzmu mqngr leplz kx bzpe navzbzle badr, e nzmu nqmq nr drtwrdr sa tztekqtrlr.’ ");
INSERT INTO ntu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","A' rpibz Ebraam kx, ‘Nzmu kx trnzlxngitilru Nzryrngrkxtr, e trnzlxngiti-kzlru kxyzlubz mz nzbzngr.’” ");
INSERT INTO ntu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Zbz Jiszs rpibzle mz ncblo nedeng kx, “Kxmule-esz' da kcng tzataolr leplz mz alwx sa nakaputrp, a' agrmplz mrlx kx ataole kzdq kz doa mz alwx! ");
INSERT INTO ntu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Murde kalr Gct sa na-ayrplapx-alole nide mz alwx lc mz Hxl. X nzayrplapxngr nide na-apule mrlx kx nzpetrpz rplz kxetu mz drtwrde x nzrtcongr prla me boongr. Mwx mrlz nzbz-krde kai mz nrlc ka, mzli ka tratrkatika-ngrde nzrlxngitikr doa ne Gct. ");
INSERT INTO ntu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Mz nzmu-krde lcde, aclvetio-lzbqamu murde ma tqatrkatiamu nzrlxngitikr doa neng Gct. X nzmu kxrlxngiti kx tqalebzle bam da kxtrka, ycmne-plztitr nide. X nzmu nqmq nr drtwrde kx tqtekqtrlele, e ipqq nide. ");
INSERT INTO ntu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kxmule-esz' alebzle bam da kxtrka kqluti mz zbq kxesz', x mz nzwrde amrlx vzm bam x rpibzle bam kx, ‘Drtwrnge yzlupe,’ a' naipq-zvzq nide.” ");
INSERT INTO ntu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aposol kcng nzkrlzlr kx trnzkrlzlzpwzlru nzipqngr leplz mz nzvz-nqblq-krdr natqde lc, sc tzrpipebzlr mz Kxetu kx, “Aetubz nzrlxngiti-krgr.” ");
INSERT INTO ntu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Rpibz Kxetu kx, “Kxmule-esz' nzlxngiti-krmu Gct topwz apule nztopwzkr rtq nc seri, doa kx esz' mz nimu krlzle nzrpi-ngrbz mz kzdq nounc kx mqngio mz drtc' kx, ‘Naveclz-lzbqng x napetio-lzbq prla!’ X nzmu Gct nabatrpzle nzvz-nqblq-krbzle natqm.” ");
INSERT INTO ntu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Rpibz Jiszs kx, “Nzmu kzdq nimu nangi nede kzdq kxnzawz-nrbalq kx tqryabo mz nrlanc nyzm, e mwx tqaclvele sip nemqng. Mzli kx vztr-ngrmle me wz-ngrde, trtakitrdeu nzrpi-krbzme kx, ‘Vz-anim x ngq drta'm.’ ");
INSERT INTO ntu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Murde kxnzawz-nrbalq nawztr-kaipz bam mz nzngini-krm kxetu rde. Narpi-kaipzme bade kx, ‘Oliqtibz drta'nge kx nangqx mz milzpq. X mz nibr nzmu-krnge, sc tqmu-ateq.’ ");
INSERT INTO ntu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","X mzli kx ayrkrpx-ngrbzle nzwz-krde trtakitrdeu nzawi-krbzme bade. Murde ale-txpwzle nzwzngr kc tzamnqlzbz bade. ");
INSERT INTO ntu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nakxmu-kzpwzle la mz nimu. Mzli kx wztr-ngrbzmu mz Gct, rpi-txpwzmu kx, ‘Trtakitrdeu Gct nzawi-krmle bagu. Murde krlc tqale-txpwzku ye nzwzngr kc tzamnqlzm bagu.’” ");
INSERT INTO ntu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Mzli kc Jiszs badr ncblo nedeng tzvzne-ngrbzlr Jerusalem, nzrlaszlr Gzlili Provins x nzprtrng mz Szmariz Provins. ");
INSERT INTO ntu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nzvztibzlr kzdq mztea, sc tqrmctipeng ncblo nzpnu-esz' kx ycngr lepz. Nztubzng rlru, murde trnzrlrpx-ngru nzesotr-krbzlr mz doa kx tryc-ngru lepz. ");
INSERT INTO ntu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","X nzkq-katopxpemqng nzrpibzlr kx, “Kxetu Jiszs! Nayc mz drtwrm nigr x amrlz nigr!” ");
INSERT INTO ntu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","X rpibzle badr kx, “Vzamu x rtangrtiamu kzdung pris, kx napwxlitibzlr nimu, da kc tqwai nzpikr Lou sc Mosis le. Murde nakrlzlr kx mrlzpeamu x napipxlr.” Kx nzvznepebzlr kc lepz kc sc tqmrbrpe. ");
INSERT INTO ntu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","A' kzdq nidr, kx mcpele kx mrlzpe, yzlum, x sc tqglqpxpele Gct mz natqde kxbe. ");
INSERT INTO ntu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yrngzobz mz drtc' mz nanyc Jiszs, mz nzawi-krbzle bade. Ncblo kc ngi lr Szmariz, kx nzobqszo lr Jiu. ");
INSERT INTO ntu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Rpibz Jiszs mz leplz kcng tzmncng mrkc kx, “Ncblo nzpnu-esz' kcng tzamrlzng. ?A' myx krkcng rpwxmz? ");
INSERT INTO ntu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","?Memule doa lc trngiulrJiu kc tqyzlum mz nzawi-ngrbz mz Gct?” ");
INSERT INTO ntu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","X rpibz Jiszs bade kx, “Tulzpe x vz. Murde nzrlxngiti-krm amrlz-angidrpele nim.” ");
INSERT INTO ntu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Kzdung Farzsi nzveatibzlr mz Jiszs mzli kx Gct na-aclve-angidr-ngrde nrlc. X rpibzle kx, “Gct trnavzmipleu rkx kx nzmc mz nzngini-krde King. ");
INSERT INTO ntu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","X trpnzngr ncblo kx narpile kx nzaclve-krde sc tqyc mrka o sc tqyc mz kzdq nrlc. Murde mzli ka sc tqaclve-angidrpele nabz kzdung leplz mz nrlc.” ");
INSERT INTO ntu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Zbz sc tqrpipebzle mz ncblo nedeng kx, “Ninge Mrlx Leplz. X mzli kc navzm, narpiamu kx namcamu nzyzlu-krmc mz nzngini-krnge king. A' trgalr nzmc-krmule murde mzli lcde trkaputrkap. ");
INSERT INTO ntu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mzli lc tqaenzliamu, kzdu lang leplz narpibzlr kx, ‘Obqbzmu, Kxnzmcpx lcmonr tqmnc mrkc!’ O narpibzlr kx, ‘Obqmamu se tqmnc mrka!’ A' bzkq rtangrtiamu ninge. ");
INSERT INTO ntu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Murde ninge Mrlx Leplz nzyzlu-krmc sa naotxpx angidr mz mzpu. Na-apule nzrpnapxkr bzlrpc mz nzayzlrpx-krde bongavz, abzo mz kzdq nrlarde krlzbzle kzdq nrlarde. ");
INSERT INTO ntu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","A' drtqnge naetq zlwz kai x doa kcng tzmncng mzli ka natrkalrpx-ngrdr ninge. ");
INSERT INTO ntu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nayzlumc mzli kc leplz napxtxpx-ngrdr nzlalztqngr mz natq Gct, da kc tqwaile mz mzli nyz Noa. ");
INSERT INTO ntu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mzli lcde leplz tzmung, tzyrlzng, x tzpxtxpx-ngrdr nzlalztqngr mz natq Gct, vz vz krlzmle mzli kc Noa badr mrlxdeng tzdwatr-ngrdr mz lcsu kc etu. X nubla kc tqvo-atem x nibqtileng leplz kcng amrlx trnzdwatrung elr. ");
INSERT INTO ntu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","X sa nayzlu-mopwc' mzli kc leplz na-apu-ngrdr leplz kcng mz mzli nyz Ebraam x mrlx mzlede, Lot. Mzli lcde leplz kc tzmung ye, tzxpeng da x tzamwang da, tzrpetiong da, x tzrwz-ngrng da. A' trnztekqtrlru nqmq nr drtwrdr kxtrka. ");
INSERT INTO ntu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Zbz mz zbq kcpwz Gct tqatwzlr-ngrbzle enjrl nedeng mz nzmailzpx-krdr Lot x lr ma nyzdeng, ayrplapx-kzle taon kc etu Sodom mz nqmq krdr kxtrka. Avzomle mz bongavz nyr x rplz kxpc kx nzbzlu tatiobz mz taon lcde, x nibqtileng leplz kcng amrlx trnzrlaszpxlru taon kc. ");
INSERT INTO ntu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","X kxnamu-kzle lc mzli kc na-adcpx-lzbq-mou-ngrne. ");
INSERT INTO ntu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Mz zbq lcde, ncblo kx mnctrpz yz mz ma nyzde, bzkq votr mou mz ma nyzde mz nzotitr-krde dztudeng, murde trpnzngr mzli rde. X mz nqmq lcpwz, ncblo kc tqmnctrp mz lclr dakxnzng nyzde, bzkq yzlupe mou mz ma nyzde mz nzoti-krde dztudeng. ");
INSERT INTO ntu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","A' nadcpx mz drtwrmu olvz r Lot, kx bztx pnz murde obq-teblqtx. ");
INSERT INTO ntu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Murde doa kx otr-zvzngr drtwrde nzlu-krde, sa namale-lvile nzlungr kxboi. A' kx yrlqtxole nzlu-krde murde lxngitile ninge, sa naprtr mz nzlungr kxboi. ");
INSERT INTO ntu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Napibo bamu, mz nrlckxbq lc nayzlu-ngrmc, leplz nzling namwing mz nqni kxesz'. Navzmipe Gct Heven krkc tqvz-nqblq-angidrle ninge. A' narlaszpele krkc trvz-nqblqleu ninge mz nzodatingr nide. ");
INSERT INTO ntu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Olvz nzling naoliq-lxblrng dakxnzng. Navzmipe kc, a' narlaszpe kc. ");
INSERT INTO ntu_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ncblo nzling nawz-lxblrng mz nrlanc kxesz'. Navzmipe kc a' narlaszpe kc.” ");
INSERT INTO ntu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Zbz nzrpibzlr ncblo nedeng kx, “?Drlve ke, kx Kxetu?” Rpibz Jiszs kx, “Mzli lcde sa naopxbz bamu mz nzmc-krmu rkx ngrde.” ");
INSERT INTO ntu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Zbz Jiszs kc tqpipebzle badr nzycmne-ebzpxngr lc, mz nzalvztr-krde nidr kx nakrka'-zvzng, x bzkq nabzdr tzprlzm, nakrlzbzle mzli kx ayzlu-ngrbz Gct nzkrka'-krdr. ");
INSERT INTO ntu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Rpibzle kx, “Kzdq kc majzstret mnc mz kzdq taon. Tramatqleu Gct x Lou scde, x trkxu mz drtqde nzale-angidr-krde nzwz-krde. ");
INSERT INTO ntu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","A' kzdq olvz kx bzsz ncblo ngrde mnc kz mz taon kc. Vz-zvzm bade tqrpibzle kx, ‘Ycmnepe-ngrbz ninge. Ycmneamu badr leplz kcng tzangqngutitrlr ninge mz drtc' nyznge, murde nakxmu-lxblrle naesz' bagr.’ ");
INSERT INTO ntu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pxtxpx-zvz-ngrbz majzstret lc. A' kzdq mzli sc tqrpipele mz nide esz'-krde kx, ‘Kxmule-esz' tramatqwxu Gct x trkxu mz drtqnge leplz, ");
INSERT INTO ntu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","a' naycmnepe-ngrbo nide. Murde tramatxpewxu mz nzvz-zvz-krm olvz lc bange!’” ");
INSERT INTO ntu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","X rpi-mopwz Jiszs kx, “Naxlramu da kc tqpi majzstret lc tqdrka'ngr. Kape-ngrbzle da kc tqrlxtile, murde olvz kc nzrlxtx-zvz-krbzle da bade. ");
INSERT INTO ntu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","A' Gct trapuleu majzstret kxmule la. Murde nide tubq x mrlztile leplz nedeng. X trpnzngr nzaenzli-krde mzli kxboi mz nzokatr-krde kxmcpxleng, mz nzkrka'-zvz-krbzlr bade mz zbq kang kqlu. ");
INSERT INTO ntu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Napibo bamu, Gct sa na-atubqti-anibzle da badr. A' mzli kc nayzlu-mou-ngrmc mz nrlc, mwx sa namcx leplz kxnzpipzng kxnzlxngiti-angidrbelr ninge.” ");
INSERT INTO ntu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jiszs pi-kzpzle nzycmne-ebzpxngr lc murde kzdung leplz nzabrtxtrpwzlr drtwrdr mz nzatubqti-lzbq-krdr, a' nzobqszo-ngrdr kzdung kz leplz. ");
INSERT INTO ntu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Rpibzle kx, “Ncblo nzling nzvzdzng Mangr-nzangiongr mz nzkrka'ngr. Kzdq ngi Farzsi kx glqpx-lzbq. X kzdq kz kxatakqti takes, ncblo kx ale zvz alwx, x nzobqszo. ");
INSERT INTO ntu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Farzsi kc tutxpx kai esz'-krde, sc tqkrka'pe-ngrde nide esz'-krde. Rpipele kx, ‘Gct, awibo bam murde trapuwxu ncblo kxnzkqlung. Murde trprlvzu mzke' da, x trangqngutitrwxu, x trmwimiwxu olvz r ncblo kzble. X awi mz trnzapu-krngeu kxatakqti takes lcmonr, nqmq krde tqtrka. ");
INSERT INTO ntu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Alex da kqlupxbz myaszpxle da kc tqpiq mz Lou scm. Murde mz wiki amrlx nzaxtx-krbo dakxnzng zbq li mz nzkrka'-krbo bam. X kabo bam kranzpnu ngr da kcng amrlx tqatatrpc', x kranzpnu ngr dalr nrlanc nyzngeng x animol nengeng.’” ");
INSERT INTO ntu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Rpi-mopwz Jiszs kx, “A' kxatakqti takes kc tqtutrp rlru kxpipz x rblxtxpe nzobqlz-krde Heven mz nzkrka'-krde, murde drtqde myatxpe. X tztrle lomrde mz nzkrka'-krde, sc tqrpipele kx, ‘Gct, nayc mz drtwrm ninge, murde ninge ncblo ngr alwx! Ipqpxbz alwx ngrnge x atubqtim ninge. Eu, angida.’ ");
INSERT INTO ntu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","X napibo bamu, mz nibrde, ncblo lc tubqbz mz nzobqkr Gct. A' ncblo kc kz, trtingr. Murde doa kx amyalz-lzbq mzli ka, sa na-avzo Gct nide yu. A' kx avzo-lzbq mzli ka, sa na-amyalz Gct nide.” ");
INSERT INTO ntu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kzdung leplz nzvzmimlr doa kxnztopwzng x itoto nedrng mz Jiszs mz nzmaletr-krbzle nrkrdrtqdr x nzamrlz-krde nidr. A' kx nzmcpebzlr ncblo nedeng le, sc tzlclvztrpebzlr nzvz-krm leplz kcng. ");
INSERT INTO ntu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","A' Jiszs kqlebzle doa kxnztopwz kcng, sc tqrpipebzle mz ncblo nedeng kx, “Bzkq rpwa'-ngrbzmu badr doa lang tztopwzng nzvz-krmlr bange. Murde leplz kxnzmulr lcng nzlxngitilr Gct mz nzngini-krde King rdr. ");
INSERT INTO ntu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nadcpx da lc! Murde trpnzngr nzmnclz-krbzmu mz Gct mz nzngini-krde King rmu nzmu kx trapuwamuu doa lcng.” ");
INSERT INTO ntu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Zbz kzdq kxrmailz r lr Jiu veabz mz Jiszs, rpibzle kx, “Kxakrlz, krlzx kx nim ncblo kxmrlz. ?Nike na-alex murde natwz-ngrne nzlungr kxboi?” ");
INSERT INTO ntu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Rpibz Jiszs bade kx, “?Memule tqrpi-ngrme bange kx mrlzx? Murde trpnzngr kxmrlz, a' ngi txpwz Gct esz'-krde. ");
INSERT INTO ntu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Krlzq natq kcng tqkapx Gct. Krlcde seleng: ‘Bzkq kx narmwimi doa kxtrngiu krnalzde. Bzkq kx narnibq. Bzkq kx napna da. Bzkq kx narpokiati leplz. Amrlue zvz trtem x lxem,’ x kzdung mou.” ");
INSERT INTO ntu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","A' rpibz ncblo kc kx, “Abzo pnz mzli kc tqngini-ngrne obla, vz-nqblq-angidrx natq lcng amrlx.” ");
INSERT INTO ntu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kx xlrbz Jiszs da lc, sc tqrpipebzle bade kx, “Mrbrpxbep da esz' kx naleq. Amwa mclrm amrlx x kabz trau rde mz leplz kx trpnzngr scdr da. Nzmu na-aleq da lc, nzrngiba-krm namyalz mou mrkc Heven. Vzm x vz-nqblq ninge.” ");
INSERT INTO ntu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","A' kx xlrbz ncblo lc le drtwrde vztx, murde nide ncblo kxrngisc x trsutiu drtwrde nzrlrtx-ngrbz da kcng. ");
INSERT INTO ntu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Mctrpebz Jiszs drtwrde nzvz-krde sc tqrpipebzle kx, “Rblxtx-atwrnr-ngrbz mz leplz kx nzrngiscng nzmnclz-krbzlr mz Gct! Murde trnzkrlzlru kx nzmnc-xglelr nide mz da amrlx. ");
INSERT INTO ntu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamel trkrlzleu nzdwatr-krde mrkc tqmrplxngr nidil. A' nzrblxkr kxnzrngiscng nzmnclz-krbzlr mz Gct myaszpxle da lc.” ");
INSERT INTO ntu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Zbz sc tzrpipebzlr kx, “E kx tqmule lcde, trpengr kx narlapx!” ");
INSERT INTO ntu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","A' rpibz Jiszs kx, “Nike rblxbz mz ncblo tr-rblxpwzu mz Gct.” ");
INSERT INTO ntu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Zbz rpibz Pita kx, “Obq ena! Rlaszpekr mr nyzgr mz nzvz-nqblq-krgr nim.” ");
INSERT INTO ntu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Rpibz Jiszs badr kx, “Napi-angidrbo bamu. Ncblo kx rlaszle ma nyzde, o olvz rde, o mzledeng, o trtede x lxede, o doa nedeng mz nzvectr-krmle leplz mz Gct mz nzngini-krde King rdr, ");
INSERT INTO ntu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Gct sa nakabzle bade da kxkqlu namyaszlzle mzli ka mz nrlc ka, da kx natekqtrle da kcng tqamrbrle. X mz nrlc kc navzm, sa natwz-kzle nzlungr kxboi.” ");
INSERT INTO ntu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Zbz Jiszs vzmileng krkcng nzpnu-esz'-nrade-li (12) mz kzdq nrlc mz nidr esz'-krdr, sc tqrpipebzle badr kx, “Lalztqmamu! Navzpeku Jerusalem x mzli kc nakrlzlz-ngrbzku mrkc, da kcng amrlx tzyro profet kcng mzli kc, tzpi-ngrdr ninge mz nzngini-krnge Mrlx Leplz, sc tzngidatipeng. ");
INSERT INTO ntu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Murde sa nakaobzlr ninge mz mqdr kxtrngiulrJiu. Sa naxtrnga-ngrdr ninge. Na-akrlo-ngrdr ninge. X nabyatilr ninge. ");
INSERT INTO ntu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Naviplatilr ninge x nanibqlr ninge. A' mz zbq kratq sc tqlupe-moux.” ");
INSERT INTO ntu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Da lcng trpnzngr kx yrplatitr nar ncblo nedeng. Drtwr ngr natq kcng yc-kapqbz badr. Trnzkrlzlru da lc tqycmnetrngr Jiszs. ");
INSERT INTO ntu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jiszs badr zbo ngr leplz kcng, sc tzesonetrpebzng Jeriko. A' kzdq kc ncblo kx mzte mwi wxbune mz nrlar lrpzki, tqrlxne scde trau. ");
INSERT INTO ntu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kx xlrle zbo ngr leplz kcng tqvzng mrkc tqmnc-ngrde, sc tqveape, “?Nilc krlc tqkxmule lc?” ");
INSERT INTO ntu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nzrpibzlr bade kx, “Jiszs kc Naszret la tqvz mz lrpzki.” ");
INSERT INTO ntu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Zbz sc tqnepxpe tqrpipele kx, “Jiszs, Mrlx Devet! Nayc mz drtwrm ninge!” ");
INSERT INTO ntu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Leplz kcng tzrtwayzbzng nzlclvzlr nide x nzrpibzlr namnc-lrpi. A' sc tqaetunelz-zlwzle nate, mz nzrpi-krde kx, “Mrlx Devet! Nayc mz drtwrm ninge!” ");
INSERT INTO ntu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kx xlrbz Jiszs natqde, sc tqtupe, x tqrkapebz natq kx ncblo kc mzte tqmwi navzmim bade. X mzli kc tqesotrpe-ngrbzle, Jiszs sc tqveapebz bade, ");
INSERT INTO ntu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","rpibzle kx, “?Nike suti drtwrm kx na-alebo bam?” Rpibzle kx, “Kxetu, naobq-moux.” ");
INSERT INTO ntu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Zbz rpibz Jiszs bade kx, “Obq! Nzlxngiti-krm ninge amrlzpele nim.” ");
INSERT INTO ntu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","X mzli lcpwz mzte obqtxpx pnz, x sc tqvz-nqblqpele Jiszs, tqawibz mz Gct. Kx nzmcpe zbo ngr leplz kc le, sc tzglqlzpelr Gct. ");
INSERT INTO ntu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jiszs krlzbzle taon kc etu Jeriko badr ncblo nedeng x sc tzkawipelr. ");
INSERT INTO ntu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mzli lc kzdq kc ncblo kx mnc mz taon lcde, drtqde Sakizs. Nide nardr krkcng tzatakqting takes mz taon lcde, x rngisc. ");
INSERT INTO ntu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","X Sakizs lc, tqabzle nzrmcngr Jiszs, a' trpnzngr murde zbo ngr leplz kc, x nide ncblo kx mrbcnelzbz. ");
INSERT INTO ntu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Zbz sc tqvope kai, tqrlaszpxpele zbo ngr leplz kc. Sc tqolzpe mz kzdq nc sikomo murde rpile namcomle Jiszs nzvzki-krmle mz lrpzki kc. ");
INSERT INTO ntu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jiszs vzkimle mrkc, obqlzbz x mcle Sakizs. Sc tqrpipebzle bade kx, “Sakizs, voo-anim murde namncx mz ma nyzm mzbq ka.” ");
INSERT INTO ntu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakizs votxo-anim. X kx nzkrlzbzlr ma nyzde, abrtz-ngrde nzadwatr-krdele. ");
INSERT INTO ntu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Leplz kcng tzrmcng da lc drtwrdr lctx, murde mz drtwrdr nzvztr-krbz Jiszs ma nyzde drtwr ngrde kx abrtzlvzle alwx ngr Sakizs. Sc tzrpipelr kx, “Mrlx lc vztrpebz mz ma nyz ncblo lc tqale zvz alwx!” ");
INSERT INTO ntu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mzli kc Jiszs tzmncbe-ngrdr badr, Sakizs kc tqtekqtrpele nqmq nr drtwrde. Tutxlzm, sc tqrpipebzle bade kx, “Kxetu rnge, kzdq se da napibo bam! Dztungeng lcng kqlu nakabo mz krkcng trpnzngr scdr da. X krkcng tqangqngutitrxng, naxpe-mopwc' nzwrde napwx, navz-nqblqle Lou sc Mosis.” ");
INSERT INTO ntu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Rpibz Jiszs mz krkcng tzlalztqng kx, “Otxpxpe kx Gct arlapxpele ncblo lc, murde nzrlxngiti-krde apule melrmqde Ebraam. ");
INSERT INTO ntu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ninge Mrlx Leplz vz-ngrmc mz nrlc mz nzrtangr-krnge x nzarlapx-krnge doa kxnzmrbrng.” ");
INSERT INTO ntu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mzli kcpwz leplz tzlalztq-ngrpwzlr mz da lc, Jiszs sc tqryapwxpe-mopwz badr kzdq nzycmne-ebzpxngr. Pi-ngrbzle da lc murde sc tzesonetrpebzng Jerusalem, x nzpnzkr drtwrdr le, kx mz nzkrlz-krbzle la Jerusalem, sa nayrlqpe Gct nide mz nzngini-krde king rdr, x lr nrlc amrlx namnclzbzng mz Gct. ");
INSERT INTO ntu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Zbz rpibz Jiszs kx, “Kzdq ncblo kxetu navz mrkzble rlru, murde king kxetu ngr mrlcde nakabzle bade zmatq ngr nzngini-krde king r mrnyzde. Zbz sa nayzlu-mop mz nzaclve-krdele. ");
INSERT INTO ntu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Mzli kc ycpe pipz nzrlasz-krde mrkc, sc tqaveatipele kxnzawz-nrbalq nedeng nzpnu-esz'. X mz ncblo kxesz' kabzle trau nzkqlu-krde kxmule-esz'. X rpibzle badr kx, ‘Mwapx-ngrbzmu trau scnge lc mzli kc navz-ngrne.’ Zbz sc tqvzpe. ");
INSERT INTO ntu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","A' kzdung lr mrnyzde nzpxpx-ngrdr nide nzngini-krde king. X sc tzatwzlrpe-ngrbzlr kzdung ncblo mz nibrde, mz nzrpi-krbzlr mz king kc etu kx, ‘Trsutiu drtwrgr ncblo lc nzngini-krde king rgr.’ ");
INSERT INTO ntu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Kxmule-esz', a' ncblo kc etu sc tqnginipede king rdr. X mzli lc tqyzlupe-ngr-mople badr, sc tqaveatipele kxnzawz kcng tqka-nebade trau kcng. Murde nakrlzle kx tqlvr kx nzatatrpemlr mz tr